﻿USE sofia;
DROP TABLE IF EXISTS sofia.mpa_vpl;
CREATE TABLE mpa_vpl (
  verseID VARCHAR(16) NOT NULL PRIMARY KEY,
  canon_order VARCHAR(12) NOT NULL,
  book VARCHAR(3) NOT NULL,
  chapter VARCHAR(3) NOT NULL,
  startVerse VARCHAR(3) NOT NULL,
  endVerse VARCHAR(3) NOT NULL,
  verseText TEXT CHARACTER SET UTF8 NOT NULL) ENGINE=MyISAM;
LOCK TABLES mpa_vpl WRITE;
INSERT INTO mpa_vpl VALUES ("MT1_1","070_1_1","MAT","1","1","1","Chenjenu nde chitabu cha mahina gha lukolu lwaka Yesu Kristo. Yesu Kristo akabhi lubheleku lwaka Daude, wa lubheleku lwaka Ibulahimu. ");
INSERT INTO mpa_vpl VALUES ("MT1_2","070_1_2","MAT","1","2","2","Ibulahimu akumbeliki Isaka, Isaka akumbeliki Yakobo, Yakobo akumbeliki Yuda na bhalongu bhaki, ");
INSERT INTO mpa_vpl VALUES ("MT1_3","070_1_3","MAT","1","3","3","Yuda akumbeliki Pelesi na Zela, bhanihabha mabhu wabhu akalowakiki Tamali, Pelesi akumbeliki Hesiloni, Hesiloni akumbeliki Alamu. ");
INSERT INTO mpa_vpl VALUES ("MT1_4","070_1_4","MAT","1","4","4","Alamu akumbeliki Aminadabu, Aminadabu akumbeliki Nashoni, Nashoni akumbeliki Salimoni. ");
INSERT INTO mpa_vpl VALUES ("MT1_5","070_1_5","MAT","1","5","5","Salimoni akumbeliki Boazi, na mabhu waka Boazi akabhi Lahabu. Boazi akumbeliki Obedi kwaka mabhu joakalowakiki Lutu, Obedi akumbeliki Yese, ");
INSERT INTO mpa_vpl VALUES ("MT1_6","070_1_6","MAT","1","6","6","Yese akumbeliki Nkolongwa Daude. Daude akumbeliki Solomoni, mabhu waka Solomoni akalowakiki Batisheba joakabhi nhwanu waka Ulia. ");
INSERT INTO mpa_vpl VALUES ("MT1_7","070_1_7","MAT","1","7","7","Solomoni akumbeliki Lehoboamu, Lehoboamu akumbeliki Abiya, Abiya akumbeliki Asa, ");
INSERT INTO mpa_vpl VALUES ("MT1_8","070_1_8","MAT","1","8","8","Asa akumbeliki Yehoshafati, Yehoshafati akumbeliki Yolamu, Yolamu akumbeliki Uzia, ");
INSERT INTO mpa_vpl VALUES ("MT1_9","070_1_9","MAT","1","9","9","Uzia akumbeliki Yosamu, Yosamu akumbeliki Ahazi, Ahazi akumbeliki Hezekia. ");
INSERT INTO mpa_vpl VALUES ("MT1_10","070_1_10","MAT","1","10","10","Hezekia akumbeliki Manase, Manase akumbeliki Amoni, Amoni akumbeliki Yosia, ");
INSERT INTO mpa_vpl VALUES ("MT1_11","070_1_11","MAT","1","11","11","Yosia akumbeliki Yekonia na bhalongu bhaki. Chikahi cheniheche Bhayahude bhakapelakiki kuutumwa ku inchi ja ku Babeli. ");
INSERT INTO mpa_vpl VALUES ("MT1_12","070_1_12","MAT","1","12","12","Pabhakajomwili kuhamila ku Babeli, Yekonia akumbeliki Shealitieli, Shealitieli akumbeliki Zelubabeli. ");
INSERT INTO mpa_vpl VALUES ("MT1_13","070_1_13","MAT","1","13","13","Zelubabeli akumbeliki Abiudi, Abiudi akumbeliki Eliakimu, Eliakimu akumbeliki Azoli. ");
INSERT INTO mpa_vpl VALUES ("MT1_14","070_1_14","MAT","1","14","14","Azoli akumbeliki Sadoki, Sadoki akumbeliki Akimu, Akimu akumbeliki Eliudi. ");
INSERT INTO mpa_vpl VALUES ("MT1_15","070_1_15","MAT","1","15","15","Eliudi akumbeliki Eleazali, Eleazali akumbeliki Matani, Matani akumbeliki Yakobo. ");
INSERT INTO mpa_vpl VALUES ("MT1_16","070_1_16","MAT","1","16","16","Yakobo akumbeliki Yusufu, joakabhi ndomi waka Malia mabhu waka Yesu joalowakeka Kristo. ");
INSERT INTO mpa_vpl VALUES ("MT1_17","070_1_17","MAT","1","17","17","Bhela kukabhi na ibheleku komi na nchechi kutumbula Ibulahimu mbaka Daude. Ibheleku komi na nchechi kutumbula Daude mbaka Bhayahude pabhakatolakiki kwa makili kujenda ku Babeli. Na ibheleku komi na nchechi kutumbula kutolakeka kwabhu mbaka chikahi chaka Kristo. ");
INSERT INTO mpa_vpl VALUES ("MT1_18","070_1_18","MAT","1","18","18","Bhenibhela nde Yesu Kristo moakabhelakike. Malia mabhu waki, akabhi abhowakiki hweku na Yusufu. Nambu mangani ja kutama papamu ngati ndomi na nhwanu waki, Malia akabhonakini kubha abhi na chitumbu kwa uwezu waka Roho Mhuhu. ");
INSERT INTO mpa_vpl VALUES ("MT1_19","070_1_19","MAT","1","19","19","Yusufu akabhi mundu wambone palongi jaka Chapanga, ngacheakapaliki kumpoha lihamu Malia palongi ja bhandu, bhela akaholalili kundeka kwa kulihiya. ");
INSERT INTO mpa_vpl VALUES ("MT1_20","070_1_20","MAT","1","20","20","Paakabhi akona kuholalela panani ja mambu ghanihagha, mtumika wa kunani kwaka Bambo akumpitalili mu ndoto na kumpwaghila, “Yusufu, mwana waka Daude, ngawijoghopa kuntola Malia kubha nhwanu waku, maghambu abhi na chitumbu kwa makili ghaka Roho Mhuhu. ");
INSERT INTO mpa_vpl VALUES ("MT1_21","070_1_21","MAT","1","21","21","Jombi anaalibhopulaje mwana wa chikambaku, na wehapa anaundoha lihina laki Yesu, kwa ndandi jombi nde joanaabhakengalyaje bhandu bhaki kuhuma mu mahoku ghabhu.” ");
INSERT INTO mpa_vpl VALUES ("MT1_22","070_1_22","MAT","1","22","22","Bhela mambu ghanihagha ghokapi ghakapitalili nahuli lipitalya lilobhi lela Bambo leakapwaghiki kwa kupetela mlota, ");
INSERT INTO mpa_vpl VALUES ("MT1_23","070_1_23","MAT","1","23","23","“Ndingalyaje, bikila anaapataje chitumbu, anaambelaka mwana wa chikambaku, na analowakika Emanueli,” yani, “Chapanga papamu na tepani.” ");
INSERT INTO mpa_vpl VALUES ("MT1_24","070_1_24","MAT","1","24","24","Bhela Yusufu paakajumwiki mu lughonu akatendiki ngati mtumika waka Bambo hoju moakumpwaghile, akuntoliki Malia nhwanu waki na kujenda naku kunyumba jaki. ");
INSERT INTO mpa_vpl VALUES ("MT1_25","070_1_25","MAT","1","25","25","Nambu ngacheakaghoni naku ngati mundu na nhwanu waki mbaka paakalibhopwili mwana waki wa kutumbula wa chikambaku. Najombi Yusufu akundohiki lihina laki Yesu. ");
INSERT INTO mpa_vpl VALUES ("MT2_1","070_2_1","MAT","2","1","1","Yesu akabhelakiki ku muchi wa ku Beselehemu, mkoa wa ku Yudea, chikahi Helode paakabhi Nkolongwa. Paabhelakika pena bhandu bhabhamanya ghaghipitalyaje kwa kulingali ndondwa kuhuma kolipita lyobha bhakahikiki ku Yelusalemu. ");
INSERT INTO mpa_vpl VALUES ("MT2_2","070_2_2","MAT","2","2","2","Bhakabhalalukili bhandu, “Bho, abhi kwako mwana joabhelakiki kubha Nkolongwa wa Bhayahude? Kwa ndandi tujiweni ndondwa jaki kolipita lyobha, na tepani tuhikiki kunjojabhela.” ");
INSERT INTO mpa_vpl VALUES ("MT2_3","070_2_3","MAT","2","3","3","Nkolongwa Helode paakajowini mambu ghanihagah, akabhi na choghoi namaa papamu na bhandu bhokapi bha ku Yelusalemu. ");
INSERT INTO mpa_vpl VALUES ("MT2_4","070_2_4","MAT","2","4","4","Helode akabhabhongini bhakolongwa bhokapi bha bhapenganyambiku na bhabhola bha Shelia na kubhalalukila, “Bho, Kristo abhelakiki kwako?” ");
INSERT INTO mpa_vpl VALUES ("MT2_5","070_2_5","MAT","2","5","5","Bhombi bhakamuyangiki, “Ku muchi wa ku Beselehemu, mkoa wa ku Yudea. Kwa ndandi mlota waka Chapanga akalembiki, ");
INSERT INTO mpa_vpl VALUES ("MT2_6","070_2_6","MAT","2","6","6","‘Wenga muchi wa Beselehemu mkoa wa ku Yudea, wehapa nga unchoku ng'o pachilanda ja michi jejimanyikana nakanopi ja ku Yudea, maghambu mkati jaku anaapitalya mtawala, jonaabhadima bhandu bhangu, nde Bhaizilaeli.’ ” ");
INSERT INTO mpa_vpl VALUES ("MT2_7","070_2_7","MAT","2","7","7","Bhela Helode akabhalohiki bhandu bhabhamanya ghaghipitalyaje kwa kulingalila ndondwa bhala pandu panga bhandu, nahuli apata uchakaka kuhuma kwabhu chikahi ndondwa jela pajapitalile. ");
INSERT INTO mpa_vpl VALUES ("MT2_8","070_2_8","MAT","2","8","8","Bhela akabhatumiki ku Beselehemu, na kubhapwaghila, “Muyendaye mkapata uchakaka wa mambu ghaka mwana jonihoju. Na pamwambonaje, muhikaye kumbwaghila, nahuli nanatu nyenda kunjojabhela.” ");
INSERT INTO mpa_vpl VALUES ("MT2_9","070_2_9","MAT","2","9","9","Bhela pabhajomula kunjowanela nkolongwa, bhandu bhabhamanya ghaghipitalyaje kwa kulingalila ndondwa bhala bhakabhokike, na kwa ukangachu palongi jabhu bhakajiweni ndondwa jela jebhajiweni kutumbula kolipita lyobha jikabhalongulili, na bhombi bhakajijengalili mbaka pajakajemiki panani ja pandu paakabhi mwana. ");
INSERT INTO mpa_vpl VALUES ("MT2_10","070_2_10","MAT","2","10","10","Pabhajiweni ndondwa jela bhakatweliwi na chiheku chikolongwa changa kulongaleka. ");
INSERT INTO mpa_vpl VALUES ("MT2_11","070_2_11","MAT","2","11","11","Bhakajingi munyumba, bhakumbweni mwana papamu na mabhu waki Malia, bhakachikimi kwa kutopela kukolongwa, na kunjojabhela. Bhela bhakabhopwi mikoba jabhu, na kupiha nhupu ya zahabu, ubani na mahuta manyahi ghaghalowakeka manemane. ");
INSERT INTO mpa_vpl VALUES ("MT2_12","070_2_12","MAT","2","12","12","Chapanga akabhakanakile mu ndoto ngabhikelabhuka kwaka Helode, bhela bhakabhujiki kunyumba yabhu kwa kupetela indela najengi. ");
INSERT INTO mpa_vpl VALUES ("MT2_13","070_2_13","MAT","2","13","13","Bhela bhandu bhabhamanya ghaghipitalyaje kwa kulingali ndondwa bhala pabhabhokiki pena, mtumika wa kunani kwaka Bambo akampitalili Yusufu mu ndoto na kumpwaghila, “Jumuka, untola mwana papamu na mabhu waki na mtililaye ku Misili. Na mkatama konihoku mbaka panumpwaghilaje, kwa ndandi nkolongwa Helode apala kunkoma mwana.” ");
INSERT INTO mpa_vpl VALUES ("MT2_14","070_2_14","MAT","2","14","14","Bhela Yusufu akajumwiki, na kuntola mwana papamu na mabhu waki, na bhombi bhakabhokiki ikilu jelajela kujenda ku Misili. ");
INSERT INTO mpa_vpl VALUES ("MT2_15","070_2_15","MAT","2","15","15","Bhakatemi konihoku mbaka Helode paakapotile. Nahuli ghapitalya malobhi ghala Bambo ghaakapwaghiki kwa kupetela mlota waka Chapanga, akapwagha, “Nikandohiki Mwana wangu kuhuma ku Misili.” ");
INSERT INTO mpa_vpl VALUES ("MT2_16","070_2_16","MAT","2","16","16","Helode paakamanyi kubha bhandu bhabhamanya ghaghipitalyaje kwa kulingalila ndondwa bhala bhatei kunkolowa, akayomiki namaa. Akabhalaghalaki bhandu bhake kujenda ku Beselehemu na pandu pokapi pa pambipi, nahuli kubhakoma bhana bhokapi bha chikambaku kutumbula bhabhabhi na hyaka ibhele na kuhelela pahi. Akatendiki ghanihagha kubhokana na chikahi paakapatiki kumanya kuhuma kwa bhandu bhabhamanya ghaghipitalyaje kwa kulingali ndondwa bhala. ");
INSERT INTO mpa_vpl VALUES ("MT2_17","070_2_17","MAT","2","17","17","Bhela ghakapitali malobhi ghaghapwaghakiki na Yelemia joakabi mlota waka Chapanga. ");
INSERT INTO mpa_vpl VALUES ("MT2_18","070_2_18","MAT","2","18","18","“Sauti jakajowaniki kuhuma ku Lama, kulela kwa bhandu kwa kubhina ntima na maombulezu ghamaheli. Laheli abhalele bhana bhaki, najombi ngacheapala kutumbala, kwa ndandi bhokapi bhapotile.” ");
INSERT INTO mpa_vpl VALUES ("MT2_19","070_2_19","MAT","2","19","19","Helode paakapotili, mtumika wa kunani kwaka Bambo akampitali Yusufu mu ndoto ku Misili kola, ");
INSERT INTO mpa_vpl VALUES ("MT2_20","070_2_20","MAT","2","20","20","akumpwaghile, “Jumukaje, untola mwana papamu na mabhu waki, na ukelabhuka naku ku inchi ja ku Izilaeli. Kwa ndandi bhala bhabhalondikaje kunkoma mwana bhapotile.” ");
INSERT INTO mpa_vpl VALUES ("MT2_21","070_2_21","MAT","2","21","21","Bhela Yusufu akajumwiki, na kuntola mwana papamu na mabhu waki, na kukelabhuka ku inchi ja Izilaeli. ");
INSERT INTO mpa_vpl VALUES ("MT2_22","070_2_22","MAT","2","22","22","Nambu Yusufu paakajowini kubha Alukelao, mwana waka Helode, nkolongwa wa ku Yudea, atamili pandu paka atati waki, akajowipi kujenda konihoku. Kabhete akabya akanakiwi mu ndoto, akapiti upambala wa ku Galilaya, ");
INSERT INTO mpa_vpl VALUES ("MT2_23","070_2_23","MAT","2","23","23","konihoku akapiti kutama ku muchi ghumu ghoulowakeka Nazaleti. Nahuli ghapitalya malobhi ghaghapwaghakiki na bhalota bhaka Chapanga, “Anaalowakika Mnazaleti.” ");
INSERT INTO mpa_vpl VALUES ("MT3_1","070_3_1","MAT","3","1","1","Mu machobha ghala Yohana Mbatizaji akapitalili ku chingwenje cha ku Yudea na kutangaza, ");
INSERT INTO mpa_vpl VALUES ("MT3_2","070_3_2","MAT","3","2","2","akapwagiki, “Mng'anambukaje na kughaleka mahoku ghinu, maghambu Ukolongwa wa kunani kumahunde uheghalile.” ");
INSERT INTO mpa_vpl VALUES ("MT3_3","070_3_3","MAT","3","3","3","Ajo nde Yohana jola ambaju mlota Isaya akapwaghiki panani jaki, “Mundu ajamali kuchingwenje, ‘Ndenganakya indela jaka Bambo, muhatambulaye indela jeanapetaje!’ ” ");
INSERT INTO mpa_vpl VALUES ("MT3_4","070_3_4","MAT","3","4","4","Yohana Mbatizaji akaweti ingobhu yeilenganakiki na mangoma gha chinyama chechilowakeka ngamia. Na muchibhunu chaki akawatiki ulamba wa chingokolu, na chilebhi chaki chakabhi nzige na busi. ");
INSERT INTO mpa_vpl VALUES ("MT3_5","070_3_5","MAT","3","5","5","Bhela, bhandu kuhuma ku Yelusalemu, na upambala wokapi wa ku Yudea, na inchi yokapi ya pambipi na Nkoka Yoludani bhakunjendile. ");
INSERT INTO mpa_vpl VALUES ("MT3_6","070_3_6","MAT","3","6","6","Bhombi pabhakayetakili mahoku ghabhu, Yohana akabhabatizi mu Nkoka Yoludani. ");
INSERT INTO mpa_vpl VALUES ("MT3_7","070_3_7","MAT","3","7","7","Nambu Yohana paakabhaweni Mafalisayo bhamaheli na Masadukayo bhunjendela nahuli abhabatizaje, akabhapwaghile, “Mwenga chibheleku cha lijoka! Bho, nane joandakalile ntila utemulu waka Chapanga ghouhika? ");
INSERT INTO mpa_vpl VALUES ("MT3_8","070_3_8","MAT","3","8","8","Ndangia kwa matendu ghinu kubha mng'anambwiki na kughaleka mahoku ghinu. ");
INSERT INTO mpa_vpl VALUES ("MT3_9","070_3_9","MAT","3","9","9","Ngamuliholalela na kulipwaghila, mumitima jinu kubha, ‘Atati witu nde Ibulahimu!’ Chakaka numpwaghila, Chapanga aweza kughang'anambu maganga aghagha kubha bhana bhaka Ibulahimu. ");
INSERT INTO mpa_vpl VALUES ("MT3_10","070_3_10","MAT","3","10","10","Bhela, libhaghu libhekakiki wichu punhina wa kila nkongu, kila nkongu wangakubheleka mapambiku manyahi anauhekatwaje na kulekaleka pamoto. ");
INSERT INTO mpa_vpl VALUES ("MT3_11","070_3_11","MAT","3","11","11","Nepani numbatiza kwa machi kulangiha kubha mng'anambwiki na kughaleka mahoku ghinu, nambu joahika munyuma jangu nepani anaambatiza kwa Roho Mhuhu na kwa moto. Jombi nde joabhi na makili kupeta nenga, na nenga ngachembalika hata kunhula magubasi ghaki. ");
INSERT INTO mpa_vpl VALUES ("MT3_12","070_3_12","MAT","3","12","12","Jombi abhi na chipalu mumabhoku ghaki, nahuli apeta ingano. Anabhongana ingano na kuibheka ku ugholu waki, nambu mambojwa anaaghajocha kwa moto wangakuchuchuka.” ");
INSERT INTO mpa_vpl VALUES ("MT3_13","070_3_13","MAT","3","13","13","Bhela, Yesu akahikiki kuhuma ku Galilaya na kujenda mbaka ku Nkoka Yoludani nahuli abatizwaje na Yohana. ");
INSERT INTO mpa_vpl VALUES ("MT3_14","070_3_14","MAT","3","14","14","Nambu Yohana akalengiki kunkanila, akapwaghaje, “Nepani nde nembalakika kubatizwa na wehapa, bho, henu kukubha bhole uhika kwangu nepani?” ");
INSERT INTO mpa_vpl VALUES ("MT3_15","070_3_15","MAT","3","15","15","Nambu Yesu akayangike, “Jetakyaje kuhenga bhenibhela kwa sajenu, maghambu nde mokupalakila tuhengaje ghala ghokapi ghaapala Chapanga.” Bhela Yohana akajetakile. ");
INSERT INTO mpa_vpl VALUES ("MT3_16","070_3_16","MAT","3","16","16","Yesu pajomula pela kubatizwa na kuhoghoka kuhuma mu machi. Palapala kunani kumahunde kukabhopwiki, akumbweni Roho waka Chapanga akahelalaje kwa ubhonikanu ngati wa ngunda, na kumetela panani jaka Yesu. ");
INSERT INTO mpa_vpl VALUES ("MT3_17","070_3_17","MAT","3","17","17","Sauti jakajowaniki kuhuma kunani kumahunde, jakapwaghaje, “Hajoju nde Mwana wangu jonumpalike, nyambakiki naku.” ");
INSERT INTO mpa_vpl VALUES ("MT4_1","070_4_1","MAT","4","1","1","Bhela, Roho waka Chapanga akundongwi Yesu mbaka kulipololu nahuli akalengakikaje na Shetani. ");
INSERT INTO mpa_vpl VALUES ("MT4_2","070_4_2","MAT","4","2","2","Paajomwi kukonga kula chilebhe kwa machobha alobaini muhi na ikilu, Yesu akaweni injala. ");
INSERT INTO mpa_vpl VALUES ("MT4_3","070_4_3","MAT","4","3","3","Bhela, Shetani akahikiki na kumpwaghila, “Ngati wehapa nde wa Mwana waka Chapanga, laghalakya maganga aghagha ghakubha mabumunda.” ");
INSERT INTO mpa_vpl VALUES ("MT4_4","070_4_4","MAT","4","4","4","Nambu Yesu akayangiki, “ ‘Ilembakiki, anana mu Malembu Mahuhu, Mundu ngacheaweza kutama kwa libumunda pena, nambu kwa kila lilobhi leapwagha Chapanga.’ ” ");
INSERT INTO mpa_vpl VALUES ("MT4_5","070_4_5","MAT","4","5","5","Kabhete Shetani akundongwi Yesu mbaka ku Yelusalemu, Muchi Uhuhu, na kumbeka kunani nakanopi ja Nyumba jaka Chapanga, na kumpwaghila, ");
INSERT INTO mpa_vpl VALUES ("MT4_6","070_4_6","MAT","4","6","6","“Ngati wehapa nde Mwana waka Chapanga, ulihabhuha pahi, maghambu ilembakiki mu Malembu Mahuhu, ‘Chapanga anaabhatuma bhatumika bhaki bha kunani kumahunde kwa ndandi jaku, anabhakutolaye mumabhoku ghabhu, nahuli chiwolu chaku ngawalikobhandola paliganga.’ ” ");
INSERT INTO mpa_vpl VALUES ("MT4_7","070_4_7","MAT","4","7","7","Yesu akamuyangiki, “Nambu Malembu Mahuhu ghapwagha, ‘Ngawandenga Bambo Chapanga waku.’ ” ");
INSERT INTO mpa_vpl VALUES ("MT4_8","070_4_8","MAT","4","8","8","Panihapa Shetani akuntoliki kabhete Yesu mbaka kunani ja chitombi chilachu nakanopi, na kundangiha ukolongwa wokapi wa pundema na unyahi waki wokapi. ");
INSERT INTO mpa_vpl VALUES ("MT4_9","070_4_9","MAT","4","9","9","Shetani akumpwaghile, “Ananukupekya hindu hayeyi yokapi, ngati anaunjikamili na kunyojabhela.” ");
INSERT INTO mpa_vpl VALUES ("MT4_10","070_4_10","MAT","4","10","10","Nambu Yesu akamuyangiki, “Ubhoka pani wa Shetani! Ilembakiki mu Malembu Mahuhu, ‘Unjojabya Bambo Chapanga waku, na untumakya jombi kanjika jaki.’ ” ");
INSERT INTO mpa_vpl VALUES ("MT4_11","070_4_11","MAT","4","11","11","Bhela Shetani akundekiki Yesu, na bhatumika bha kunani kwaka Chapanga bhakahikiki na kuntumakila. ");
INSERT INTO mpa_vpl VALUES ("MT4_12","070_4_12","MAT","4","12","12","Bhela, Yesu paakajowini kubha Yohana ajeghaliki muchifungo, akapiti ku Galilaya. ");
INSERT INTO mpa_vpl VALUES ("MT4_13","070_4_13","MAT","4","13","13","Akabhokiki ku Nazaleti, na kujenda kutama ku Kapelenaumu, muchi ghoubhi munkeghi ja bahali ja Galilaya, mu malindakanilu gha wilaya ja Zabuloni na Nafutali. ");
INSERT INTO mpa_vpl VALUES ("MT4_14","070_4_14","MAT","4","14","14","Haleli lakahengakiki nahuli lipitalyaye lilobhi lela lelapwaghakiki na mlota Isaya, ");
INSERT INTO mpa_vpl VALUES ("MT4_15","070_4_15","MAT","4","15","15","“Inchi ja Zabuloni na inchi ja Nafutali, kujenda kwindela ja bahali kwihi ja nkoka Yoludani, Galilaya inchi ja bhandu bhangakubha Bhayahude! ");
INSERT INTO mpa_vpl VALUES ("MT4_16","070_4_16","MAT","4","16","16","Bhandu bhabhatemi mu lwihi, bhauweni unang'anu ukolongwa. Na bhombi bhabhatama mu inchi ja lwihi na nhwili wa kupotela, unang'anu ubhamulakile.” ");
INSERT INTO mpa_vpl VALUES ("MT4_17","070_4_17","MAT","4","17","17","Kutumbu chikahi chenihechi Yesu akatumbwili kutangaza ubholu waki, akapwagha, “Mng'anambukaje na kughaleka mahoku ghinu, maghambu Ukolongwa wa kunani kumahunde uheghalile!” ");
INSERT INTO mpa_vpl VALUES ("MT4_18","070_4_18","MAT","4","18","18","Yesu paakabhi ajenda mumaheku ja bahali ja Galilaya, akabhaweni bhalongu bhabheli bhalohe, Simoni joalowakeka Petulu na Andulea ndongu waki, bhakalobha homba mubahali kwa nkwabho, kwa ndandi bhakabhi bhalohe. ");
INSERT INTO mpa_vpl VALUES ("MT4_19","070_4_19","MAT","4","19","19","Yesu akabhapwaghile, “Munyengalyaje, na nepani ananuntenda mwehapa kubha bhalohi bha bhandu.” ");
INSERT INTO mpa_vpl VALUES ("MT4_20","070_4_20","MAT","4","20","20","Palapala bhakajilekiki mikwabhu jabhu, na kunjengale Yesu. ");
INSERT INTO mpa_vpl VALUES ("MT4_21","070_4_21","MAT","4","21","21","Yesu paakajendali, palongi pachokopi akabhaweni bhalongu bhangi bhabheli, Yakobo na Yohana, bhana bhaka Zebedayo. Bhanihabha bhakabhi mkati mu ngalawa papamu na atati wabhu Zebedayo, bhakalenganakya mikwabhu jabhu. Yesu akabhalohike. ");
INSERT INTO mpa_vpl VALUES ("MT4_22","070_4_22","MAT","4","22","22","Palapala bhakajilekiki ngalawa papamu na atati wabhu, na kunjengale Yesu. ");
INSERT INTO mpa_vpl VALUES ("MT4_23","070_4_23","MAT","4","23","23","Yesu akapiti kila pandu mu Galilaya, akabhabhola bhandu mu manyumba ya kuhimanganila Bhayahude, na kutangaza Malobhi Manyahi gha Ukolongwa waka Chapanga. Na kubhalamiha bhandu bhabhalwala hitamu ya kila ntundu na mabhinilu ghokapi. ");
INSERT INTO mpa_vpl VALUES ("MT4_24","070_4_24","MAT","4","24","24","Bhandu bhabhatama ku inchi jokapi ja ku Silia bhakajowini mambu ghanihagha. Bhakandeti bhandu bhamaheli bhabhang'ahika na hitamu ya kila ntundu na bhabhabhi na mabhinilu gha kila ntundu, bhabhabhi na majobhi, bhabhahinduka na bhabhatengwike, na Yesu akabhalamihe. ");
INSERT INTO mpa_vpl VALUES ("MT4_25","070_4_25","MAT","4","25","25","Mapogha ghamaheli gha bhandu kuhuma ku Galilaya, ku Dekapoli ndandi jaki michi komi, ku Yelusalemu, ku Yudea na kuhuma kwihi ja nkoka Yoludani, bhakunjengalile. ");
INSERT INTO mpa_vpl VALUES ("MT5_1","070_5_1","MAT","5","1","1","Yesu paaghaweni mapogha gha bhandu, akakweliki pachitombi, na kutama. Bhabhulwa bhaki bhakunjendile, ");
INSERT INTO mpa_vpl VALUES ("MT5_2","070_5_2","MAT","5","2","2","jombi akatumbwi kubhabhola, akapwaghaje: ");
INSERT INTO mpa_vpl VALUES ("MT5_3","070_5_3","MAT","5","3","3","“Bhapengaliki bhandu bhabhabhi bhahochu bha roho, maghambu Ukolongwa wa kunani kumahunde nde wabhu!” ");
INSERT INTO mpa_vpl VALUES ("MT5_4","070_5_4","MAT","5","4","4","“Bhapengaliki bhabhabhi na huzuni, maghambu Chapanga anaabhajeghala mtima!” ");
INSERT INTO mpa_vpl VALUES ("MT5_5","070_5_5","MAT","5","5","5","“Bhapengaliki bhabhabhi na upole, maghambu anabhapwelila inchi.” ");
INSERT INTO mpa_vpl VALUES ("MT5_6","070_5_6","MAT","5","6","6","“Bhapengaliki bhabhabhi na injala na inywita ja kutenda ghaaghapala Chapanga, maghambu Chapanga anaabhatupalishaye.” ");
INSERT INTO mpa_vpl VALUES ("MT5_7","070_5_7","MAT","5","7","7","“Bhapengaliki bhabhabhi na chiha kwa bhangi, maghambu Chapanga anaabhabhonila chiha.” ");
INSERT INTO mpa_vpl VALUES ("MT5_8","070_5_8","MAT","5","8","8","“Bhapengaliki bhabhabhi na mtima unyahi, maghambu bhanihabha anabhumbona Chapanga.” ");
INSERT INTO mpa_vpl VALUES ("MT5_9","070_5_9","MAT","5","9","9","“Bhapengaliki bhabhaleta lukwale, maghambu anabhalowakika bhana bhaka Chapanga.” ");
INSERT INTO mpa_vpl VALUES ("MT5_10","070_5_10","MAT","5","10","10","Bhapengaliki bhabhang'ahikwa kwa ndandi ja kutenda ghaaghapala Chapanga, maghambu Ukolongwa wa kunani kumahunde nde wabhu. ");
INSERT INTO mpa_vpl VALUES ("MT5_11","070_5_11","MAT","5","11","11","“Mpengaliki mwehapa bhandu pabhuntondola, na kung'aha na kundongalela kila lilobhi lihakau kwa ndandi jangu. ");
INSERT INTO mpa_vpl VALUES ("MT5_12","070_5_12","MAT","5","12","12","Muhekalyaye na kululuta, maghambu nhupu winu nde ukolongwa kunani kumahunde. Maghambu anana nde mobhang'ahakakile bhalota bhaka Chapanga bhabhatamika mangani yinu.” ");
INSERT INTO mpa_vpl VALUES ("MT5_13","070_5_13","MAT","5","13","13","“Mwehapa nde mwinyu wa pundema. Nambu mwinyu anauhoiki kunogha kwaki, bho, anaujeghalika kiki nahuli unogha kabhete? Ngacheijangatila kwa chindu chokapi, nambu kutaghakika kunja na kukanyatwa na bhandu.” ");
INSERT INTO mpa_vpl VALUES ("MT5_14","070_5_14","MAT","5","14","14","“Mwehapa nde unang'anu wa pundema. Muchi ghouchengakiki panani ja chitombi ngacheuweza kulihiya. ");
INSERT INTO mpa_vpl VALUES ("MT5_15","070_5_15","MAT","5","15","15","Nga mundu joapambaki taa na kujikupakila kwa chihulu, nambu abheka panani ja kinala nahuli jabhamulakya bhandu bhokapi bhabhabhi mkati ja nyumba. ");
INSERT INTO mpa_vpl VALUES ("MT5_16","070_5_16","MAT","5","16","16","Bhelabhela unang'anu winu na unang'anaje palongi ja bhandu, nahuli bhaghabhona matendu ghinu manyahi, na bhombi bhundumbalya Atati winu joabhi kunani kumahunde.” ");
INSERT INTO mpa_vpl VALUES ("MT5_17","070_5_17","MAT","5","17","17","“Ngamwiholakela kubha nhikiki kubhoha Shelia au mabholu gha bhalota bhaka Chapanga. Nepani ngachenhikiki kubhoha, nambu kutimiza. ");
INSERT INTO mpa_vpl VALUES ("MT5_18","070_5_18","MAT","5","18","18","Numpwaghi chakaka, mbaka panihapa kunani kumahunde na pundema pakwipetaje, njeta hata chindu kichokopi chechibhohakika mu Shelia, mbaka ghokapi ghatimilaje. ");
INSERT INTO mpa_vpl VALUES ("MT5_19","070_5_19","MAT","5","19","19","Bhela, mundu jokapi joanahekatayi amuli jimu njoku jejibhi mu Shelia jokapi, na kubhabhola bhandu bhangi kutenda bhelabhela, mundu jonihoju anaakubha nchoku nakanopi mu Ukolongwa wa kunani kumahunde. Nambu mundu jola joakamulakila na kubhawola bhandu bhangi bhahenga bhenibhela, jonihoju anaakubha nkolongwa mu Ukolongwa wa kunani kumahunde. ");
INSERT INTO mpa_vpl VALUES ("MT5_20","070_5_20","MAT","5","20","20","Henu numpwaghi kubha, impalika kujetakela na kuhenga ghaaghapala Chapanga, kupeta mobhahengela bhabhola bha Shelia na Mafalisayo, nanga bhela nganjingili mu Ukolongwa wa kunani kumahunde ng'o.” ");
INSERT INTO mpa_vpl VALUES ("MT5_21","070_5_21","MAT","5","21","21","“Njowini bhandu bha mwandi bhakapwaghakiki, ‘Ngawikoma, na mundu anaakomiki impalika utemulo.’ ");
INSERT INTO mpa_vpl VALUES ("MT5_22","070_5_22","MAT","5","22","22","Nambu nenga numpwaghila, jokapi joanhyomela ndongu waki, impalika utemulo. Na mundu joantondola ndongu waki, impalika kutemuliwa pachengu. Mundu anaampwaghili ndongu waki, ‘Ung'ang'a,’ impalika kujingila mu moto wa jehanamu. ");
INSERT INTO mpa_vpl VALUES ("MT5_23","070_5_23","MAT","5","23","23","Bhela anaupeleka nyambiku jaku palongi ja chihanja cha nyambiku, na panihapa anaukombwiki kubha ndongu waku alochini na wenga, ");
INSERT INTO mpa_vpl VALUES ("MT5_24","070_5_24","MAT","5","24","24","jileka nyambiku jaku palongi ja chihacha cha nyambiku, jenda hoti ukajongana na ndongu waku, na panihapa nde ukelabhukaje ubhoha nyambiku jaku.” ");
INSERT INTO mpa_vpl VALUES ("MT5_25","070_5_25","MAT","5","25","25","“Jonganaje na ntakila waku manyata mkabya mwakona mwindela kujenda pachengu. Nanga bhela ntakila waku anaakupelaka kwaka nkolongwa wa pachengu, najombi nkolongu wa pachengu anaakupelaka kwaka linjolinjoli, na wenga anaukongakikaje muchifungo. ");
INSERT INTO mpa_vpl VALUES ("MT5_26","070_5_26","MAT","5","26","26","Nukupwaghi chakaka, ngaupiti monihomu mbaka undepaje sendi ja kujomukela.” ");
INSERT INTO mpa_vpl VALUES ("MT5_27","070_5_27","MAT","5","27","27","“Njowini kubha bhandu bhakapwaghakiki, ‘Ngamwihenga ugone.’ ");
INSERT INTO mpa_vpl VALUES ("MT5_28","070_5_28","MAT","5","28","28","Nambu nepani numpwaghila, kila mundu joandingali mbomba kwa kuntokulela, ajomwi kutenda ugone mumtima waki. ");
INSERT INTO mpa_vpl VALUES ("MT5_29","070_5_29","MAT","5","29","29","Bhela ngati lihu laku la kumalelelu likuhokili, litupulaje ukalilekala kutali. Mbanga nakanopi kwaku kuhobheha pandu pa hyegha jaku, kuliku hyegha jaku jokapi kulekaleka mu moto wa Jehanamu. ");
INSERT INTO mpa_vpl VALUES ("MT5_30","070_5_30","MAT","5","30","30","Ngati chiwoku chaku cha kumalelelu chikuhokii, uhekataje ukalekala kutali. Mbanga kwaku kuhobheha pandu pa hyegha jaku, kuliko hyegha jaku jokapi kulekaleka mu moto wa jehanamu.” ");
INSERT INTO mpa_vpl VALUES ("MT5_31","070_5_31","MAT","5","31","31","“Ipwaghakiki kubha, ‘Mundu joandeka nhwanu waki, impalika ampekya baluwa ja kundeka.’ ");
INSERT INTO mpa_vpl VALUES ("MT5_32","070_5_32","MAT","5","32","32","Nambu nepani numpwaghila, kila mwanalomi joampekeha nhwanu waki baluwa ja kulekana, nambu pena kwa lihoku la ugone, untenda abya mgone. Na mwanalomi anaantotwili mbomba joapatiki baluwa ja kulekana jola, najombi atenda ugone.” ");
INSERT INTO mpa_vpl VALUES ("MT5_33","070_5_33","MAT","5","33","33","“Kabhete, njowini kubha bhandu bha mwandi mobhakapwaghile, ‘Ngawiheketa kulapa kwaku, nambu ipalakika utimizaye kulapa kwaku palongi jaka Bambo.’ ");
INSERT INTO mpa_vpl VALUES ("MT5_34","070_5_34","MAT","5","34","34","Nambu nepani numpwaghila, ngamwilapa ng'o, wala kwa kunani kumahunde, maghambu nde mpandu waki wa Ukolongwa waka Chapanga, ");
INSERT INTO mpa_vpl VALUES ("MT5_35","070_5_35","MAT","5","35","35","wala kwa pundema, maghambu nde mpandu wa kubhekela magholu ghaki, wala kwa Yelusalemu, maghambu nde muchi waka Nkolongwa. ");
INSERT INTO mpa_vpl VALUES ("MT5_36","070_5_36","MAT","5","36","36","Wala ngawilapa kwa mmutu waku, maghambu ngauwezi kuling'anambula hata lijunju limu kubha lihuhu au lipili. ");
INSERT INTO mpa_vpl VALUES ("MT5_37","070_5_37","MAT","5","37","37","Pampwagha, ‘Ena,’ mpwagha pena, ‘Ena,’ au pampwagha ‘Ngabhela’ mpwagha pena, ‘Ngabehla,’ kwa ndandi malobhi ghaghapwaghakika, kupeta ghanihagha ghahuma kwaka Mhakau jola. ");
INSERT INTO mpa_vpl VALUES ("MT5_38","070_5_38","MAT","5","38","38","“Njowini kubha ipwaghakiki, ‘Lihu kwa lihu, na linu kwa linu.’ ");
INSERT INTO mpa_vpl VALUES ("MT5_39","070_5_39","MAT","5","39","39","Nambu nepani numpwaghila, ngamwankelabhukila mundu mhakau. Ngati mundu anaakulapwili lighanja litukwa la kumalelelu, ung'anambulyaje akulapulaje na la kumangeja. ");
INSERT INTO mpa_vpl VALUES ("MT5_40","070_5_40","MAT","5","40","40","Ngati mundu joapala kukutakila nahuli kukunyaghu lishati laku, undekila na likoti bhelabhela. ");
INSERT INTO mpa_vpl VALUES ("MT5_41","070_5_41","MAT","5","41","41","Mundu jokapi anaakujomalakela kutotola chibwahila chaki kilometa jimu, totulaje kilometa ibheli. ");
INSERT INTO mpa_vpl VALUES ("MT5_42","070_5_42","MAT","5","42","42","Mundu anaakujopiki chindu umpekyaje, na mundu joapala kukujahika chindu kwaku ngawanjima. ");
INSERT INTO mpa_vpl VALUES ("MT5_43","070_5_43","MAT","5","43","43","“Njowini kubha ikapwaghakiki, ‘Umpala njako, na unhakalya adui waku.’ ");
INSERT INTO mpa_vpl VALUES ("MT5_44","070_5_44","MAT","5","44","44","Nambu nepani numpwaghila, mwapala maadui bhinu, mwapengalya bhala bhabhung'aha, na mwahengila manyahi bhala bhabhunhakalila, na mwalobhilaje bhala bhabhuntende mahakau, ");
INSERT INTO mpa_vpl VALUES ("MT5_45","070_5_45","MAT","5","45","45","nahuli mpata kubha bhana bha Atati winu joabhi kunani kumahunde. Maghambu jombi abhamulakila lyobha laki bhandu bhahakau na bhambone, na kubhatonyela iyula bhandu bhambone palongi jaka Chapanga na bhahakau. ");
INSERT INTO mpa_vpl VALUES ("MT5_46","070_5_46","MAT","5","46","46","Maghambu anamwapaliki bhandu bhabhumpala mwehapa pena, bho, anampata nyonjeka bhole? Njeta! Maghambu hata bhajopa kode bhatenda ghanihagha! ");
INSERT INTO mpa_vpl VALUES ("MT5_47","070_5_47","MAT","5","47","47","Ngati anamubhalamuki bhalongu bhinu pela, bho, mtenda chindu bhole cha nyonjeka kupeta bhangi? Hata bhandu bhanga kummanya Chapanga bhatenda ghanihagha! ");
INSERT INTO mpa_vpl VALUES ("MT5_48","070_5_48","MAT","5","48","48","Bhela impalika mwehapa kubha bhakamilifu, ngati Atati winu joabhi kunani kumahunde moabheli mkamilifu. ");
INSERT INTO mpa_vpl VALUES ("MT6_1","070_6_1","MAT","6","1","1","“Mlingalyaye ngamwitenda mambu manyahi palongi ja bhandu, nahuli mbonikana nabhu. Maghambu anantendiki ngati ghanihagha, ngampati nhupu kuhuma kwa Atati winu joabhi kunani kumahunde. ");
INSERT INTO mpa_vpl VALUES ("MT6_2","070_6_2","MAT","6","2","2","“Henu pamwajangati bhahochu, ngamwalitangaza, ngamwitenda ngati akandumila kubheli mobhatendela mu nyumba ya kuhimangani Bhayahude na mwindela, nahuli bhandu bhalumbalyaje. Numpwaghi chakaka, bhanihabha bhajomwi kupata nhupu wabhu. ");
INSERT INTO mpa_vpl VALUES ("MT6_3","070_6_3","MAT","6","3","3","Nambu wehapa paunjangati kahochu, utenda chindu hechi hata nkochi waku wa pambipi ngayimanya cheutenda. ");
INSERT INTO mpa_vpl VALUES ("MT6_4","070_6_4","MAT","6","4","4","Bhoha ujangatilu waku kwa kulihiya, na Atati waku wa kunani kumahunde joaghabhona ghaghalihiiki, anaakupekya nhupu. ");
INSERT INTO mpa_vpl VALUES ("MT6_5","070_6_5","MAT","6","5","5","“Kabhete pamundobha Chapanga, ngamwikubha ngati akandumila kubheli, bhombi bhapala kujema na kulobha munyumba ya kuhimanganila Bhayahude na mu malekanganu gha indela nahuli bhandu bhabhabhonaje. Chakaka numpwaghila, bhanihabha bhajomwi kupata nhupu wabho. ");
INSERT INTO mpa_vpl VALUES ("MT6_6","070_6_6","MAT","6","6","6","Nambu wehapa paulobha, ujingala kuchumba chaku, ujighala ndyangu, na undobha Atati waku jwongakubhonikana. Na Atati waku joaghabhona ghaghalihiiki anaakupekya nhupu. ");
INSERT INTO mpa_vpl VALUES ("MT6_7","070_6_7","MAT","6","7","7","“Pamlobha, ngamwikubha na malobhi ghamaheli ngati mobhahenge bhandu bhangakummanya Chapanga. Maghambu bhombi bhahambuki kubha anabhajowanika kwa ndandi ja kujoloka kwa malobhi ghabhu. ");
INSERT INTO mpa_vpl VALUES ("MT6_8","070_6_8","MAT","6","8","8","Ngamwikubha ngati bhanihabha. Kwa ndandi Atati winu wa kunani kumahunde aghamanyi ghamughapala hata mangane ja kulobha. ");
INSERT INTO mpa_vpl VALUES ("MT6_9","070_6_9","MAT","6","9","9","Bhela mwehapa mlobha ana: ‘Atati witu weubhi kunani kumahunde. Lihina laku lilumbalikaje. ");
INSERT INTO mpa_vpl VALUES ("MT6_10","070_6_10","MAT","6","10","10","Ukolongwa waku uhikaje. Pani pundema ngati kunani kumahunde hoku. ");
INSERT INTO mpa_vpl VALUES ("MT6_11","070_6_11","MAT","6","11","11","Utupekya chilebhi chitu cha kila lichobha. ");
INSERT INTO mpa_vpl VALUES ("MT6_12","070_6_12","MAT","6","12","12","Utulekakyaje mahakau ghitu, ngati tepani motubhalekakela bhabhatuhokiye. ");
INSERT INTO mpa_vpl VALUES ("MT6_13","070_6_13","MAT","6","13","13","Ngawatujeghela mu malengakeku, nambu utukengalyaye na Muhakau jola.’ Kwa kubha Ukolongwa nde waku, na makili, na ulumbalilu, hata mileli. Amina. ");
INSERT INTO mpa_vpl VALUES ("MT6_14","070_6_14","MAT","6","14","14","“Maghambu anamwalekakela bhandu mahakau ghabhu, Atati winu wa kunani kumahunde anaandekakya na mwehapa bhelabhela. ");
INSERT INTO mpa_vpl VALUES ("MT6_15","070_6_15","MAT","6","15","15","Nambu ngati ngachemwalekakela bhandu mahakau ghabhu, na Atati winu wa kunani kumahunde ngaandekakele mwehapa mahakau ghinu. ");
INSERT INTO mpa_vpl VALUES ("MT6_16","070_6_16","MAT","6","16","16","“Pamkonga kula, ngamwitenda ngati akandumila kubheli. Bhanihabha bhakwinya pamihu jabhu bhapata kubhonikana na bhandu kubha bhakongiki kula. Numpwaghi chakaka, bhanihabha bhajomwi kupata nhupu wabhu. ");
INSERT INTO mpa_vpl VALUES ("MT6_17","070_6_17","MAT","6","17","17","Nambu wehapa paukonga kula, ulipaka mahuta kumutu jaku, na uchambaje pamihu jaku, ");
INSERT INTO mpa_vpl VALUES ("MT6_18","070_6_18","MAT","6","18","18","nahuli mundu jokapi ngayimanya kubha ukonga kula, nambu lijambu leniheli limanyikana pena kwaka Atati waku jwangakubhonikana. Na Atati waku joabhona ghaughahenga kwa kulihiya, anaakupekya unhupu. ");
INSERT INTO mpa_vpl VALUES ("MT6_19","070_6_19","MAT","6","19","19","“Ngamwalibhekela chikoku pani pundema, mangeki na kutu paiyonanga, na bhihe bhabombola na kujibha. ");
INSERT INTO mpa_vpl VALUES ("MT6_20","070_6_20","MAT","6","20","20","Nambu mlibhekila chikoku kunani kumahunde, pandu ambapu mangeki na kutu ngacheiweza kuyonanga, wala bhihe ngachebhaweza kubombola na kujibha. ");
INSERT INTO mpa_vpl VALUES ("MT6_21","070_6_21","MAT","6","21","21","Maghambu pala pachibhi chikoku chaku, panihapa nde pawibya mtima waku. ");
INSERT INTO mpa_vpl VALUES ("MT6_22","070_6_22","MAT","6","22","22","“Lihu nde taa ja hyegha. Ngati lihu laku analibhi wichu, hyegha jaku jokapi anajibya mu unang'anu. ");
INSERT INTO mpa_vpl VALUES ("MT6_23","070_6_23","MAT","6","23","23","Nambu ngati lihu laku liyonangiki, hyegha jaku jokapi anajibya mu lwihi. Bhela unang'anu woubhi mkati jaku ngati anaubhi lwihi, loniholu analubya lwihi lwa kujoghoha nakanopi! ");
INSERT INTO mpa_vpl VALUES ("MT6_24","070_6_24","MAT","6","24","24","“Njeta mundu joaweza kubhatumakila mabambo bhabheli, maghambu anaanhakyala jumu, na kumpala jongi, au anakamulana na jumu, na kumpoha lihamu jongi. Ngamuwezi kunhengela lihengu Chapanga na kuihengela lihengu hindu yamaheli. ");
INSERT INTO mpa_vpl VALUES ("MT6_25","070_6_25","MAT","6","25","25","“Kwa ndandi jenjenu numpwaghi mwenga, ngamwikubha na choghohi panani ya chilebhi na chakunywa, wala ngamwaling'aha kwa ndandi ya hyegha yinu kubha anamuwata kiki. Bho, womi le ngacheupalika nakanopi kupeta chilebhe, na hyegha le ngachejipalika nakanopi kupeta ingobho? ");
INSERT INTO mpa_vpl VALUES ("MT6_26","070_6_26","MAT","6","26","26","Muilingalya ijuni ya kunani ngacheipanda imbeju, wala ngacheihuna, wala ngacheibheka mahunu ghabhu kuugholu, hata bhela Atati winu wa kunani kumahunde ayipeke chilebhe. Bho, mwehapa le ngachempalika nakanopi kupeta ijuni heye? ");
INSERT INTO mpa_vpl VALUES ("MT6_27","070_6_27","MAT","6","27","27","Bho, nde nane pachilanda jinu, ambaju kwa kuling'aha kwaki, aweza kulijonjukela hata lichobha limu la kutama kwake? ");
INSERT INTO mpa_vpl VALUES ("MT6_28","070_6_28","MAT","6","28","28","“Bho, maghambu kiki muihangajakila ingobhu? Ndingalya malobha gha mumighonda moghaneng'anela. Ngacheghatenda lihengu, wala ngacheghaloka. ");
INSERT INTO mpa_vpl VALUES ("MT6_29","070_6_29","MAT","6","29","29","Nambu numpwaghila, hata Nkolongwa Solomoni papamu na hindu yamaheli yaki yokapi yeakabhi nayu ngacheakawati ingobhu inyahi ngati lilobha limu. ");
INSERT INTO mpa_vpl VALUES ("MT6_30","070_6_30","MAT","6","30","30","Bhela ngati Chapanga aghawatika mahamba gha mungonda ngati anana, ghaghabhonikana lalenu na chilabhu ghataghakika pamoto, bho, ngaantendeli mwehapa nakanopi? Mwehapa mabhandu mwembi na uhobhalelu uchoko! ");
INSERT INTO mpa_vpl VALUES ("MT6_31","070_6_31","MAT","6","31","31","“Bhela ngamwaling'aha, na kupwagha, ‘Bho, anatukula kike? Au bho, anatunywa kike? Au bho, anatuwata kike?’ ");
INSERT INTO mpa_vpl VALUES ("MT6_32","070_6_32","MAT","6","32","32","Ndandi ghanihagha ghokapi gahangaikiwa na bhandu bhangakummanya Chapanga. Atati winu wa kunani kumahunde amanyi kubha muipala hindu yeniheyi yokapi. ");
INSERT INTO mpa_vpl VALUES ("MT6_33","070_6_33","MAT","6","33","33","Nambu muulonda hoti Ukolongwa waka Chapanga na haki jaki, na ghanihagha ghokapi ananjonjukiwaje. ");
INSERT INTO mpa_vpl VALUES ("MT6_34","070_6_34","MAT","6","34","34","Bhela ngamwaling'aha kwa ndandi ja chilabhu, maghambu chilabhu anakubya na mambu ghaki. Kila lichobha libhi na mang'ahiku ghaki gha kuyaghanila kwa lichobha leniheli. ");
INSERT INTO mpa_vpl VALUES ("MT7_1","070_7_1","MAT","7","1","1","“Ngamwatemu bhandu bhange, na mwenga ngamwihika kutemuliwa na Chapanga. ");
INSERT INTO mpa_vpl VALUES ("MT7_2","070_7_2","MAT","7","2","2","Maghambu utemulu ghomwabhatemu bhajinu, ghonihoghu nde ghomwitemuliwaje. Na chipemu chelachela chempema kwa kubhatemu bhajinu, chenihechi nde Chapanga cheanaampemila mwehapa. ");
INSERT INTO mpa_vpl VALUES ("MT7_3","070_7_3","MAT","7","3","3","Bho, mbona ulibhona likanju lelibhi mu lihu laka ndongu waku, na koni ngacheulubhona luboliti lolubhi mu lihu lako? ");
INSERT INTO mpa_vpl VALUES ("MT7_4","070_7_4","MAT","7","4","4","Au anaumpwaghila bho ndongu waku, ‘Ndongu, lenda nukubhoha likanju mu lihu laku,’ chikahi wenga wamweti ubhinalu luboliti mu lihu lako? ");
INSERT INTO mpa_vpl VALUES ("MT7_5","070_7_5","MAT","7","5","5","Wandumila kubheli wenga! Ubhoha hoti luboliti lolubhi mu lihu laku, na panihapa nde anauweza wichu kulibhoha likanju lelibhi mu lihu jaka ndongu wako. ");
INSERT INTO mpa_vpl VALUES ("MT7_6","070_7_6","MAT","7","6","6","“Ngamwipekeha nakawa hindu ihuhu, wala ngamwilekela lulu palongi ja magholobhe, ngaghihika kukanyata pahi ja magholu ghabhu, na kung'anambuka na kunkachulana mwabhene. ");
INSERT INTO mpa_vpl VALUES ("MT7_7","070_7_7","MAT","7","7","7","“Ndobhaje, na mwenga anampataje, mlondaje, na mwenga anampataje, muhodimaje, na mwenga anamuhoghuliwa ndyangu. ");
INSERT INTO mpa_vpl VALUES ("MT7_8","070_7_8","MAT","7","8","8","Maghambu mundu jokapi joalobha ajopalela, na joalonda abhona, na joahodima, anahoghuliwa ndyangu. ");
INSERT INTO mpa_vpl VALUES ("MT7_9","070_7_9","MAT","7","9","9","Bho, mundu bhole pachilanda jinu joaweza kumpekeha mwana waki liganga, ngati anaandobhiki libumunda? ");
INSERT INTO mpa_vpl VALUES ("MT7_10","070_7_10","MAT","7","10","10","Au, bho, nane joaweza kumpekeha mwana waki lijoka, ngati anaandobhiki homba? ");
INSERT INTO mpa_vpl VALUES ("MT7_11","070_7_11","MAT","7","11","11","Bhela anangati mwehapa mwembi mwahakau, mumanyi kwapekeha bhana bhinu hindu yambone, bho, Atati winu wa kunani kumahunde le ngaampeke mwehapa ghambone nakanopi kwa bhala bhabhundobha? ");
INSERT INTO mpa_vpl VALUES ("MT7_12","070_7_12","MAT","7","12","12","“Ghokapi ghampala bhandu bhunhengila mwehapa, nanamu mubhatendila bhandu bhelabhela. Maghambu jenje nde ndandi ja Shelia jaka Chapanga, na mabholu gha bhalota bhaka Chapanga. ");
INSERT INTO mpa_vpl VALUES ("MT7_13","070_7_13","MAT","7","13","13","“Njingalaje kwa kupetela ndyangu upepandahu. Maghambu ndyangu nde upana, na indela nde jipana jejijenda ku uyonangeku, na bhandu bhabhapetela indela jeniheji nde bhamaheli. ");
INSERT INTO mpa_vpl VALUES ("MT7_14","070_7_14","MAT","7","14","14","Nambu indela jejiyenda ku womi nde jipepandahu, na ndyangu wa kujingila monihomu nde upepandahu, na bhandu bhabhajibhona indela jeniheji nde bhachokope. ");
INSERT INTO mpa_vpl VALUES ("MT7_15","070_7_15","MAT","7","15","15","“Mulilingalyaje na bhalota bha ichole, bhandu bhabhahika kwinu kwa kunja bhakabhonikana ngati limbelele, nambu mkati nde mabweha makale. ");
INSERT INTO mpa_vpl VALUES ("MT7_16","070_7_16","MAT","7","16","16","Anamwamanya kwa matendu ghabhu. Bho, bhandu le bhatongo zabibu mu mikongu ja miha, au mapambiku gha mtini mu mingwandu? Ngabhela! ");
INSERT INTO mpa_vpl VALUES ("MT7_17","070_7_17","MAT","7","17","17","Bhelabhela kila nkongu wambone upambika mapambiku ghambone, na kila nkongu uhakau upambika mapambiku mahakau. ");
INSERT INTO mpa_vpl VALUES ("MT7_18","070_7_18","MAT","7","18","18","Nkongu wambone ngacheuweza kupambika mapambiku mahakau, na nkongu uhakau ngacheuweza kupambika mapambiku ghambone. ");
INSERT INTO mpa_vpl VALUES ("MT7_19","070_7_19","MAT","7","19","19","Kila nkongu wangakupambika mapambiku ghambone anauhekatwaje, na kulekaleka mumotu. ");
INSERT INTO mpa_vpl VALUES ("MT7_20","070_7_20","MAT","7","20","20","Bhela, anamwamanyaje kwa matendu ghabhu. ");
INSERT INTO mpa_vpl VALUES ("MT7_21","070_7_21","MAT","7","21","21","“Nga kila mundu joambwaghila, ‘Bambo, Bambo,’ anaajingala mu Ukolongwa wa kunani kumahunde, nambu jola pena joaghatenda mapalu gha Atati wangu joabhi kunani kumahunde. ");
INSERT INTO mpa_vpl VALUES ("MT7_22","070_7_22","MAT","7","22","22","Lichobha lela la utemulu palihikaje, bhandu bhamaheli anabhambwaghilaje, ‘Bambo, Bambo! Bho, ngachetwahengiki ulota kwa lihina laku, na kwa lihina laku kubhoha majobhe, na kwa lihina laku kuhenga ngangachu yamaheli?’ ");
INSERT INTO mpa_vpl VALUES ("MT7_23","070_7_23","MAT","7","23","23","Panihapa nepani ananapwaghilaye hotuhotu, ‘Ngachenumanyi mwehapa ng'o, mbokanyaje palongi jangu, mwenga mabhandu mwentenda mahakau!’ ");
INSERT INTO mpa_vpl VALUES ("MT7_24","070_7_24","MAT","7","24","24","“Bhela, kila mundu joaghajowana malobhi ghangu, na kughatenda, jonihoju alengana na mundu joabhi na malangu, joachengiki nyumba jaki panani ja liganga. ");
INSERT INTO mpa_vpl VALUES ("MT7_25","070_7_25","MAT","7","25","25","Iyula jikatonyiki, mikoka jakatwelili machi, na mpongu ukapuliki na kujilapula nyumba jela. Nambu nyumba jeniheji ngachejahawike, maghambu jakachengakiki panani ja liganga. ");
INSERT INTO mpa_vpl VALUES ("MT7_26","070_7_26","MAT","7","26","26","“Nambu kila mundu joajowana malobhi ghangu, na ngacheaghahenga, jonihoju alengana na mundu ng'ang'a, joachengiki nyumba jaki panani ja luhanga. ");
INSERT INTO mpa_vpl VALUES ("MT7_27","070_7_27","MAT","7","27","27","Iyula jikatonyiki, na mikoka jikatwelili machi nakanopi, mpongu ukolongwa ukapula na kujilapula nyumba jela, najombi jakahawiki, kwa nking'indu ukolongwa!” ");
INSERT INTO mpa_vpl VALUES ("MT7_28","070_7_28","MAT","7","28","28","Yesu paakajomwi kulongela malobhi ghanihagha, lipogha la bhandu bhakakangichi namaa kwa mabholu ghaki. ");
INSERT INTO mpa_vpl VALUES ("MT7_29","070_7_29","MAT","7","29","29","Maghambu ngacheakabhi abhola ngati bhabhola bha Shelia, nambu akabholiki ngati mundu joabhi na lujiniku. ");
INSERT INTO mpa_vpl VALUES ("MT8_1","070_8_1","MAT","8","1","1","Yesu paakahelili kuhuma kuchitombi, mapogha ghamaheli gha bhandu bhakunjengalile. ");
INSERT INTO mpa_vpl VALUES ("MT8_2","070_8_2","MAT","8","2","2","Henu akahikiki mundu jumu joabhi na malohi, akanjojabhili na kupwagha, “Bambo, ngati anaupaliki, uweza kung'olola.” ");
INSERT INTO mpa_vpl VALUES ("MT8_3","070_8_3","MAT","8","3","3","Yesu akahatambwi chiwoku, akankamwili na kupwagha, “Mbala! Ugholulikaje!” Palapala mundu jola akalamiki malohi ghake. ");
INSERT INTO mpa_vpl VALUES ("MT8_4","070_8_4","MAT","8","4","4","Yesu akumpwaghile, “Lingalya, ngawampwaghi mundu jokapi, nambu ujendaje ukalilangiya kwaka mpenganyambiku, na ukabhoha nyambiku ngati moakalaghalaki Musa, nahuli kulangi kubha utehi kulama.” ");
INSERT INTO mpa_vpl VALUES ("MT8_5","070_8_5","MAT","8","5","5","Yesu paakajingi kumbwane ku Kapelenaumu, nkolongwa jumu wa linjolinjoli wa ku Loma akanjendili, na kundobha anjangatyaje, ");
INSERT INTO mpa_vpl VALUES ("MT8_6","070_8_6","MAT","8","6","6","akapwaghaje, “Bambo, mtumika wangu aghoni kunyumba, mtamwa wa kutenguka, na alwala namaa.” ");
INSERT INTO mpa_vpl VALUES ("MT8_7","070_8_7","MAT","8","7","7","Yesu akampwaghile, “Ananhika kundamiha.” ");
INSERT INTO mpa_vpl VALUES ("MT8_8","070_8_8","MAT","8","8","8","Nambu linjolinjoli nkolongwa jola akamuyangiki, “Bambo, nepani ngachembalika wehapa ujingala munyumba jangu. Nambu upwagha lilobhi pena, na mtumika wangu anaalamaje. ");
INSERT INTO mpa_vpl VALUES ("MT8_9","070_8_9","MAT","8","9","9","Maghambu nepani nanatu nde mundu nemekakiki pahi ja ujemalelu wa bhangi, mi na manjolinjoli pahi jangu. Numpwaghila jumu, ‘Ujendaje!’ Na jombi ajenda, na jongi, ‘Uhikaje!’ Na jombi ahika, na muhengalihengu wangu, ‘Tenda chindu chenjenu,’ najombi atenda.” ");
INSERT INTO mpa_vpl VALUES ("MT8_10","070_8_10","MAT","8","10","10","Yesu paakajowini malobhi ghanihagha, akakangichi namaa, akabhapwaghi bhandu bhabhakunjengalile, “Chakaka numpwaghila, ngachenabhali kumbona mundu jokapi mu Izilaeli, joabhi na uhobhalelu ukolongwa ngati ghongone. ");
INSERT INTO mpa_vpl VALUES ("MT8_11","070_8_11","MAT","8","11","11","Henu numpwaghila kubha bhandu bhamaheli anabhahikaje kuhuma kolipita lyobha na kolijibhi lyobha, na bhombi anabhatama pa uwangalalu wa chilebhe papamu na Ibulahimu, Isaka, na Yakobo mu Ukolongwa wa kunani kumahunde. ");
INSERT INTO mpa_vpl VALUES ("MT8_12","070_8_12","MAT","8","12","12","Nambu bhala bhabhakabhi bhapalakika kubha mu Ukolongwa ghola anabhalekalikaje mu lwihi lwa kunja, konihoku anakubya kulela na kuhyagha minu.” ");
INSERT INTO mpa_vpl VALUES ("MT8_13","070_8_13","MAT","8","13","13","Yesu akampwaghi nkolongwa wa manjolinjoli wa ku Loma jola, “Ujendaje kunyumba jaku, na kubyaji ngati mouhobhalile.” Mtumika waka nkolongwa wa manjolinjoli jola akalamiki lisaa lelalela. ");
INSERT INTO mpa_vpl VALUES ("MT8_14","070_8_14","MAT","8","14","14","Yesu akapiti kunyumba jaka Petulu, akanhimanili nkowanu wa chimbomba waka Petulu aghonili pachitala, abhi na chitamu chikolongwa. ");
INSERT INTO mpa_vpl VALUES ("MT8_15","070_8_15","MAT","8","15","15","Henu Yesu akankamwi mabhu jola chiwoku, na chitamu chikandekakili, na mabhu jola akajumwiki na kutumbula kubhatumakila. ");
INSERT INTO mpa_vpl VALUES ("MT8_16","070_8_16","MAT","8","16","16","Pakwahiki pakamihi, bhakundeti Yesu bhandu bhamaheli bhabhakabhi na majobhi, najombi akaghapihiki majobhi kwa malobhi ghaki. Akabhalamihi bhokapi bhabhakabhi na hitamu. ");
INSERT INTO mpa_vpl VALUES ("MT8_17","070_8_17","MAT","8","17","17","Atendika bhenibhela nahuli ghatimilaje malobhi ghaapwaghaki na mlota Isaya, “Jombi mweni akutoliki kulagha kwitu, na atotwili hitamu yitu.” ");
INSERT INTO mpa_vpl VALUES ("MT8_18","070_8_18","MAT","8","18","18","Yesu paakaliweni lipogha la bhandu limuyongalwiti, akabhalaghalaki bhabhulwa bhaki bhalombukaje bhajenda kwihi ja nhwanga. ");
INSERT INTO mpa_vpl VALUES ("MT8_19","070_8_19","MAT","8","19","19","Mbola jumu wa Shelia akanjendi Yesu, na kumpwaghila, “Mbola, nepanu ananukujengalya kwokapi kowijendaje.” ");
INSERT INTO mpa_vpl VALUES ("MT8_20","070_8_20","MAT","8","20","20","Yesu akamyangiki, “Mabweha ghabhi na makolu, na ijuni ibhi na mihuwi, nambu Mwana waka Mundu ngacheabhi na pandu pa kupomulela.” ");
INSERT INTO mpa_vpl VALUES ("MT8_21","070_8_21","MAT","8","21","21","Mbulwa jongi akumpwaghi Yesu, “Bambo, nobha nyendi hoti kuntagha atati wangu.” ");
INSERT INTO mpa_vpl VALUES ("MT8_22","070_8_22","MAT","8","22","22","Nambu Yesu akampwaghile, “Unyengalyaje! Waleka bhakuwa bhabhataghaje bhakuwa bhabhu.” ");
INSERT INTO mpa_vpl VALUES ("MT8_23","070_8_23","MAT","8","23","23","Yesu akajingi mu ngalawa, na bhabhulwa bhaki bhakunjengalile. ");
INSERT INTO mpa_vpl VALUES ("MT8_24","070_8_24","MAT","8","24","24","Kukabhi na mbelu ukolongwa munhwanga mola, na majegha ghakatumbwi kutwelakela ngalawa jela na lakatumbwi kujibhila. Nambu Yesu akabhi aghochi lughonu. ");
INSERT INTO mpa_vpl VALUES ("MT8_25","070_8_25","MAT","8","25","25","Bhabhulwa bhaki bhakunjendili na kunjumuha, bhakapwaghaje, “Bambo, tukengalyaje! Tuyonangeka!” ");
INSERT INTO mpa_vpl VALUES ("MT8_26","070_8_26","MAT","8","26","26","Yesu akabhayangiki, “Mwenga mabhandu mwenbi na uhobhalelu uchoku, bho, mbona njoghopa?” Akajumwiki, akaulakali mpongu na majegha, palapala mpongu na majegha ghakatelwiki chinunu. ");
INSERT INTO mpa_vpl VALUES ("MT8_27","070_8_27","MAT","8","27","27","Bhabhulwa bhaki bhakakangichi, na bhakapwaghike, “Bho, jonihoju mundu wa ntundu bhole? Hata mpongu na majegha yuntii!” ");
INSERT INTO mpa_vpl VALUES ("MT8_28","070_8_28","MAT","8","28","28","Yesu paakahikiki ku inchi ja Bhagelasi kwihi ja nhwanga, akahimangini na bhandu bhabheli bhabhabhi na majobhi. Bhandu bhanihabha bhatamika kumatengeli na bhakabhi bhakujoghupeka, na ngacheakabhi mundu joawezikaye kupeta indela jenijela. ");
INSERT INTO mpa_vpl VALUES ("MT8_29","070_8_29","MAT","8","29","29","Bhombi bhakatumbwi kujamalila, bhakapwaghaje, “Bho, upala kututenda kiki tepanu, Yesu, wa Mwana waka Chapanga? Bho, uhikiki kutung'aha mangani ja chikahi chake?” ");
INSERT INTO mpa_vpl VALUES ("MT8_30","070_8_30","MAT","8","30","30","Pambipi na pandu pala kukabhi na lipogha likolongwa la magholobhi bhakadimaye. ");
INSERT INTO mpa_vpl VALUES ("MT8_31","070_8_31","MAT","8","31","31","Henu majobhi ghala ghakundobhiki Yesu ghakapwagha, “Ngati utubhenga, utulekakyaje tukajingala mu magholobhi ghala.” ");
INSERT INTO mpa_vpl VALUES ("MT8_32","070_8_32","MAT","8","32","32","Yesu akaghapwaghile, “Njendaje.” Palapala majobhi ghala ghakabhapitiki bhandu bhala, na kughajingila magholobhi. Lipogha lokapi la magholobhi lakaheli palikemba likolongwa, lakajibhili munhwanga, na magholobhi ghokapi ghakapotile. ");
INSERT INTO mpa_vpl VALUES ("MT8_33","070_8_33","MAT","8","33","33","Bhadima bha magholobhi bhala bhakakembili, kujenda kumbwane. Konihoku bhakabhapwaghi bhandu mambu ghokapi ghaghapitalile, na mambu ghaghapitalile kwa bhandu bhala bhabhakabhili na majobhi. ");
INSERT INTO mpa_vpl VALUES ("MT8_34","070_8_34","MAT","8","34","34","Bhandu bhokapi bha muchi ghola bhakapiti kuhimangana na Yesu, na pabhakumbweni, bhakundobhiki abhokaje pa inchi jabhu. ");
INSERT INTO mpa_vpl VALUES ("MT9_1","070_9_1","MAT","9","1","1","Yesu akajingi mu ngalawa, na kulomboka kabheti nhwanga kukelabhuka ku muchi waki. ");
INSERT INTO mpa_vpl VALUES ("MT9_2","070_9_2","MAT","9","2","2","Panihapa bhandu bhakandeti mundu jumu joatengwiki, koni bhungoniki panani ja chitala. Yesu paakaweni uhobhalelu wabhu, akampwaghi mundu joatengwiki jola, “Lipekya mtima mwanango! Ulekakiwi mahoku ghako.” ");
INSERT INTO mpa_vpl VALUES ("MT9_3","070_9_3","MAT","9","3","3","Panihapa bhabhola bhakumu bha Shelia bhakatumbwi kuholalela mu mitima jabhu, “Mundu ajoju antondo Chapanga!” ");
INSERT INTO mpa_vpl VALUES ("MT9_4","070_9_4","MAT","9","4","4","Yesu akaghamanyi maholalelu ghabhu, akapwaghite, “Bho, maghambu kiki muholale mahakau mu mitima jinu? ");
INSERT INTO mpa_vpl VALUES ("MT9_5","070_9_5","MAT","9","5","5","Bho, laleku lelipepwiki nakanopi, kupwagha, ‘Ulekakiwi mahoku ghaku,’ au kupwagha, ‘Jemaje na ujendaje?’ ");
INSERT INTO mpa_vpl VALUES ("MT9_6","070_9_6","MAT","9","6","6","Henu, mbala mumanyaye kubha Mwana waka Mundu abhi na uwezu pundema wa kubhalekake bhandu mahoku.” Panihapa akampwaghi mundu jotengwiki jola, “Jemaje, na utola chitala chaku, na ujendaje kunyumba jaku.” ");
INSERT INTO mpa_vpl VALUES ("MT9_7","070_9_7","MAT","9","7","7","Mundu joatengwiki jola akajemiki, na kubhuja kunyumba jaki. ");
INSERT INTO mpa_vpl VALUES ("MT9_8","070_9_8","MAT","9","8","8","Bhandu bhokapi pabhaghaweni ghanihagha, bhakakangichi na kujoghopa, bhakundumbali Chapanga joabhapeki bhandu uwezu wa ntundu agho. ");
INSERT INTO mpa_vpl VALUES ("MT9_9","070_9_9","MAT","9","9","9","Yesu paakabhi abhoka panihapa, akumbweni mundu jumu joalowakeka Matayo, atemi munyumba ja kubhonganela kode. Yesu akampwaghile, “Unyengalyaje.” Matayo akajemiki, na kunjengalela. ");
INSERT INTO mpa_vpl VALUES ("MT9_10","070_9_10","MAT","9","10","10","Yesu paakabhi atemi kunyumba jaka Matayo kula chilebhi, bhajopa kode bhamaheli na bhana mahoku bhakahikiki kutama papamu na Yesu na bhabhulwa bhaki. ");
INSERT INTO mpa_vpl VALUES ("MT9_11","070_9_11","MAT","9","11","11","Mafalisayo bhakumu pabhaghaweni ghanihagha, bhakabhapwaghi bhabhulwa bhaka Yesu, “Bho, maghambu kike mbola winu akula chilebhi papamu na bhajopa kode na bhana mahoku?” ");
INSERT INTO mpa_vpl VALUES ("MT9_12","070_9_12","MAT","9","12","12","Yesu paakajowini, akabhayangiki, “Bhandu bhangakulwala ngachebhumpala sing'anga, nambu bhabhumpala sing'anga nde bhala bhabhalwala. ");
INSERT INTO mpa_vpl VALUES ("MT9_13","070_9_13","MAT","9","13","13","Njendaje mkalibholaye panani ja Malembu Mahuhu moghapwaghila, ‘Mbala chiha, wala nga nyambiku.’ Ngachenhikiki kubhaloha bhandu bhambone bhanyengalyaje, nambu bhandu bhana mahoku bhaghaleka mahoku ghabhu.” ");
INSERT INTO mpa_vpl VALUES ("MT9_14","070_9_14","MAT","9","14","14","Lichobha limu bhabhulwa bhaka Yohana Mbatizaji bhakanjendi Yesu, na kundalukila, “Bho, maghambu kiki tepani na Mafalisayo tukonga kula chilebi, nambu bhabhulwa bhaku ngachebhakonga?” ");
INSERT INTO mpa_vpl VALUES ("MT9_15","070_9_15","MAT","9","15","15","Yesu akabhayangiki, “Bho, bhandu bhabhakokakiki paukwati bhapalika le kulela chikahi bambo ukwati abhi papamu nabhu? Ngabhela! Nambu lichobha analihikaye bambo ukwati anaabhohakika pachilanda jabhu, panihapa nde pabhikonga kula chilebhi. ");
INSERT INTO mpa_vpl VALUES ("MT9_16","070_9_16","MAT","9","16","16","“Nga mundu joaloka chilaka chahenu panani ja ingobhu ja mwandi. Maghambu chilaka hechi anachikachula ingobhu ja mwandi jela, na papakakachwiki pala, anapajonjikika nakanopi. ");
INSERT INTO mpa_vpl VALUES ("MT9_17","070_9_17","MAT","9","17","17","Wala bhandu ngachebhabheka divai jahenu mu mifuku ja chingokolu cha mwandi. Anabhatendiki bhenibhela, mifuku ja chingokolu jela jitenda kukachuka na divai kujitika, na mifuku ja ingokolu heyi anajiyonangikaje. Nambu divai jahenu jibhekakeka mu mifuku ja ingokolu jahenu, panihapa nde yokapi anaitama wichu.” ");
INSERT INTO mpa_vpl VALUES ("MT9_18","070_9_18","MAT","9","18","18","Yesu paakabhi alonge ghanihagha, chiongozi jumu wa Bhayahude akahikike, akunchikamili na kupwagha, “Kamwali wangu apotile esajeno, nambu pepakoku uhikaye ubheka chiwoku chaku panani jaki, najombi apataje kubha mwomi.” ");
INSERT INTO mpa_vpl VALUES ("MT9_19","070_9_19","MAT","9","19","19","Yesu akajemiki, na kunjengalela, na bhabhulwa bhaki na bhombi bhakunjengalile. ");
INSERT INTO mpa_vpl VALUES ("MT9_20","070_9_20","MAT","9","20","20","Mabhu jumu mtamwa wa kupita mwahi kwa chikahi cha hyaka komi na ibheli, akanjengali Yesu cha kunyuma, na kunkamula nkungilu wa ingobhu jaka Yesu. ");
INSERT INTO mpa_vpl VALUES ("MT9_21","070_9_21","MAT","9","21","21","Maghambu akapwaghiki muntima waki, “Ananunkamwi pena ingobhu jaki, ananamaje.” ");
INSERT INTO mpa_vpl VALUES ("MT9_22","070_9_22","MAT","9","22","22","Yesu akang'anambwiki na kumbona, akampwaghile, “Kamwali wangu, ulipekya mtima! Uhobhalelu waku ukulamihe.” Palapala kamwali jola akalamiki. ");
INSERT INTO mpa_vpl VALUES ("MT9_23","070_9_23","MAT","9","23","23","Yesu paakahikiki kunyumba jaka chiongozi jola, na paakabhaweni bhayemba filimbi na lipogha la bhandu bhakalapula njobhela, ");
INSERT INTO mpa_vpl VALUES ("MT9_24","070_9_24","MAT","9","24","24","akabhapwaghile, “Mbokanyaje pambane! Kamwali joni ngacheapotile, nambu atehi pe kughonela.” Na bhombi bhakamuhekite. ");
INSERT INTO mpa_vpl VALUES ("MT9_25","070_9_25","MAT","9","25","25","Nambu bhandu pabhapitiki kunja, Yesu akachiheghali chitanda chaka mwali jola, akankamwili chiwoku chaka mwali jola, najombi akajemiki. ");
INSERT INTO mpa_vpl VALUES ("MT9_26","070_9_26","MAT","9","26","26","Mambu ghanihagha ghakajaghani ku inchi jenijela jokapi. ");
INSERT INTO mpa_vpl VALUES ("MT9_27","070_9_27","MAT","9","27","27","Yesu paakabhokiki pandu panipala, na paakabhi ajenda, akangalola bhabheli bhakanjengalili koni bhakajamalyaje, bhakapwaghaje, “Mwana waka Daude, utubhonila chiha!” ");
INSERT INTO mpa_vpl VALUES ("MT9_28","070_9_28","MAT","9","28","28","Yesu paakajingi munyumba, bhandu bhabheli bhakanjengalile, najombi akabhalalukile, “Bho, muhobhalela kubha nhweza kundamiha?” Na bhombi bhakamuyangiki, “Ena, Bambo.” ");
INSERT INTO mpa_vpl VALUES ("MT9_29","070_9_29","MAT","9","29","29","Panihapa Yesu akapapihi mihu ghabhu, akapwagha, “Na ibya kwinu ngati momuhobhalile.” ");
INSERT INTO mpa_vpl VALUES ("MT9_30","070_9_30","MAT","9","30","30","Palapala mihu ghabhu ghakabhopuliwi. Na jombi Yesu akabhalakalili kwa makili, akapwagha, “Ngamwampwaghi mundu jokapi lijambu lenu.” ");
INSERT INTO mpa_vpl VALUES ("MT9_31","070_9_31","MAT","9","31","31","Nambu bhombi bhakabhokiki, na kutangaza malobhi ghaka Yesu mu inchi jenijela jokapi. ");
INSERT INTO mpa_vpl VALUES ("MT9_32","070_9_32","MAT","9","32","32","Bhandu bhabheli hava pabhakabhokiki, bhandu bhangi bhakundeti Yesu mundu jumu mpuli joakakamuliki na lijobhi. ");
INSERT INTO mpa_vpl VALUES ("MT9_33","070_9_33","MAT","9","33","33","Chikahi pe lijobhi paakabhowakiki, palapala mundu joakabhi mpuli jola akatumbwi kulongela kabheti. Bhandu bhakakangichi na kupwagha, “Ngachetuliweni lijambu ngati haleli mu inchi jokapi ja Izilaeli!” ");
INSERT INTO mpa_vpl VALUES ("MT9_34","070_9_34","MAT","9","34","34","Nambu Mafalisayo bhakapwaghiki, “Yesu atopola lijobhi kwa makili ghaka nkolongwa wa lijobhi.” ");
INSERT INTO mpa_vpl VALUES ("MT9_35","070_9_35","MAT","9","35","35","Yesu akayongalwiti mu mbwane na mu hijiji yokapi akabhabhola bhandu mu manyumba gha kuhimanganila Bhayahude, koni akatangaza Malobhi Manyahi gha Ukolongwa waka Chapanga, na kubhalamiha bhandu hitamu yokapi na kulagha kwabhu kwokapi. ");
INSERT INTO mpa_vpl VALUES ("MT9_36","070_9_36","MAT","9","36","36","Yesu paakaliweni lipogha la bhandu, akabhabhoni chiha, kwa ndandi bhakatondiki na bhakabhi na choghohi na njeta utangatilu, ngati mambeleli ghangakubha na mdima. ");
INSERT INTO mpa_vpl VALUES ("MT9_37","070_9_37","MAT","9","37","37","Panihapa akabhapwaghi bhabhulwa bhaki, “Mahunu nde ghamaheli, nambu bhahenga lihengu nde bhachokope. ");
INSERT INTO mpa_vpl VALUES ("MT9_38","070_9_38","MAT","9","38","38","Henu mundobha Bambo wa mahunu, apelakaje bhahenga lihengu mu mahunu ghake.” ");
INSERT INTO mpa_vpl VALUES ("MT10_1","070_10_1","MAT","10","1","1","Yesu akabhalohiki pamu bhabhulwa bhaki komi na bhabheli, na kubhapekeha uwezu wa kutopola majobhi, na kulamiha bhandu hitamu yabhu, na uzaifu wa kila ntundu. ");
INSERT INTO mpa_vpl VALUES ("MT10_2","070_10_2","MAT","10","2","2","Mahina gha mitumi komi na bhabheli habha nde agha: Wa kutumbula nde Simoni joalowakeka Petulu, na Andulea ndongu waki, Yakobo mwana waka Zebedayo, na Yohana ndongu waki, ");
INSERT INTO mpa_vpl VALUES ("MT10_3","070_10_3","MAT","10","3","3","Filipo na Batolomayo, Tomaso na Matayo joakabhi njopa kode, Yakobo mwana waka Alufayo, na Tadayo, ");
INSERT INTO mpa_vpl VALUES ("MT10_4","070_10_4","MAT","10","4","4","Simoni mkomanela inchi jaki, na Yuda Isikalioti najombi nde jola joakang'anambwiki Yesu. ");
INSERT INTO mpa_vpl VALUES ("MT10_5","070_10_5","MAT","10","5","5","Bhanihabha komi na bhabheli Yesu akabhatumiki na kubhapekeha lujiniku, akabhapwaghila, “Ngamwijenda kwa bhandu bhangakubha Bhayahude, wala ngamwijingila mu michi ja Bhasamalia. ");
INSERT INTO mpa_vpl VALUES ("MT10_6","070_10_6","MAT","10","6","6","Nambu njendaje kwa bhandu bha Izilaeli, kwa ndandi bhabhili ngati mambeleli ghaghahobhike. ");
INSERT INTO mpa_vpl VALUES ("MT10_7","070_10_7","MAT","10","7","7","Panjenda, mkatangaza ana: ‘Ukolongwa wa kunani kumahunde uheghalile!’ ");
INSERT INTO mpa_vpl VALUES ("MT10_8","070_10_8","MAT","10","8","8","Mwalamihaje bhatamwa, mwayoha bhakuwa, mwalamiha bhabhabhi na malohi, mukabhoha majobhi. Mpatiki waka, mboha waka. ");
INSERT INTO mpa_vpl VALUES ("MT10_9","070_10_9","MAT","10","9","9","Ngamwitogho zahabu, wala mbija, wala lingengalema la shaba mu mifuku jinu. ");
INSERT INTO mpa_vpl VALUES ("MT10_10","070_10_10","MAT","10","10","10","Ngamwitogho mikoba ja mwanja, wala likoti la kabheli, wala ndonga. Maghambu mtumika apalika kupata ghala ghaaghapala kwa kila lichobha. ");
INSERT INTO mpa_vpl VALUES ("MT10_11","070_10_11","MAT","10","11","11","“Muchi wokapi au chijiji chokapi chemwijingalaje, mkalondaje nde nane monihomu mundu joapala kunjopalela, mkatama kwaki mbaka pamwibhokaje. ");
INSERT INTO mpa_vpl VALUES ("MT10_12","070_10_12","MAT","10","12","12","Pamwijingala munyumba, mwalamuha bhenehi bhake, mkalamukyaje, ‘Lukwali lubya kwinu.’ ");
INSERT INTO mpa_vpl VALUES ("MT10_13","070_10_13","MAT","10","13","13","Ngati bhenehi bha nyumba heji bhunjopalile, bhela, lukwali lwinu analutama papamu nabhu. Nambu ngati ngabhunjopalele, bhela, lukwali lwinu analunkelabhukya mwabhene. ");
INSERT INTO mpa_vpl VALUES ("MT10_14","070_10_14","MAT","10","14","14","Ngati mundu jokapi anaakaniki kunjopalela au kunjowanela, bhela pamwipita mu nyumba jeniheji au muchi ghonihoghu, mkung'undaje luhombi mumagolu ghinu. ");
INSERT INTO mpa_vpl VALUES ("MT10_15","070_10_15","MAT","10","15","15","Numpwaghi chakaka, lichobha lela Chapanga paanatemula bhandu, muchi ghonihoghu anaupata utemulu ukolongwa kupeta muchi wa Sodoma na Gomola. ");
INSERT INTO mpa_vpl VALUES ("MT10_16","070_10_16","MAT","10","16","16","“Ndingalyaje! Nepani nuntuma mwehapa ngati mambeleli pachilanda ja mabweha gha muchitengu. Mbyaje na mbulau ngati lijoka, na mbya mabhandu bhapole ngati ngunda. ");
INSERT INTO mpa_vpl VALUES ("MT10_17","070_10_17","MAT","10","17","17","Mulilingalya na bhandu, maghambu anabhumpelaka kuchengu na kundapu iboku munyumba ya kuhimanganila Bhayahude. ");
INSERT INTO mpa_vpl VALUES ("MT10_18","070_10_18","MAT","10","18","18","Anabhumpelaka palongi ja bhajemalela na bhakolongwa kwa ndandi jangu, nahuli kunilandila kwabhu na kwa bhandu bhangakubha Bhayahude. ");
INSERT INTO mpa_vpl VALUES ("MT10_19","070_10_19","MAT","10","19","19","Nambu pabhumpelaka kuchengu, ngamwikubha na choghoi mwipwagha kike au kwa ntundu bhole, maghambu anampataje malobhi gha kupwagha chikahi chelachela. ");
INSERT INTO mpa_vpl VALUES ("MT10_20","070_10_20","MAT","10","20","20","Kwa ndandi nga mwehapa mwemwilongilaje, nambu nde Roho wa Atati winu joanalongila mkati jinu. ");
INSERT INTO mpa_vpl VALUES ("MT10_21","070_10_21","MAT","10","21","21","“Ndongu anaamboha ndongu waki nahuli akomakikaje, na tati anaambohaje mwana waki nahuli akomakikaje. Bhana anabhang'anambukya bhabheleka bhabhu, na kubhakoma. ");
INSERT INTO mpa_vpl VALUES ("MT10_22","070_10_22","MAT","10","22","22","Bhandu bhokapi anabhunhakalyaje kwa ndandi ja lihina langu. Nambu joanahinakalya mbaka pakujomukela, anaakengaliwaje. ");
INSERT INTO mpa_vpl VALUES ("MT10_23","070_10_23","MAT","10","23","23","Bhandu pabhantopula mu muchi ghumu, mtililaye ku muchi ghongi. Chakaka numpwaghila, ngamwijomoli kujipetela michi jokapi ja Izilaeli, mangani Mwana waka Mundu ngacheahikiki. ");
INSERT INTO mpa_vpl VALUES ("MT10_24","070_10_24","MAT","10","24","24","“Nga mbulwa joampeta mbola waki, wala mtumwa ngacheampeta bambo waki. ");
INSERT INTO mpa_vpl VALUES ("MT10_25","070_10_25","MAT","10","25","25","Nambu ijaghanila kwaka mbulwa kulengana na mbola waki na mtumika kulengana na bambo waki. Ngati bhundohiki nkolongwa wa nyumba Beelizebuli, bho, bhandu bhala bhabhabhi munyumba heji ngabhilowakeki mahina ghangi mahakau nakanope? ");
INSERT INTO mpa_vpl VALUES ("MT10_26","070_10_26","MAT","10","26","26","“Bhela, ngamwajoghopa bhandu. Kila chindu chekiyekaliki anachiyekuliwaje, na kila chindu chechilihiiki anachibhonikanaje. ");
INSERT INTO mpa_vpl VALUES ("MT10_27","070_10_27","MAT","10","27","27","Lenumpwaghila mwehapa mu lwihi, mulipwaghaye mu unang'anu. Na lijambu lemulijowini nukunjojalyaje, mulitangaza palongi ja bhandu. ");
INSERT INTO mpa_vpl VALUES ("MT10_28","070_10_28","MAT","10","28","28","Ngamwajoghopa bhandu bhala bhabhakoma hyegha, nambu ngachebhaweza kujikoma roho. Mbanga nakanopi kunjoghopa jola joaweza kukoma hyegha papamu na roho mu moto wa jehanamu. ");
INSERT INTO mpa_vpl VALUES ("MT10_29","070_10_29","MAT","10","29","29","Bho, ijuni ibheli ya iwebha ngacheilombeswa kwa sendi jimo? Nambu hata chimu chaki ngachekihabhuka pahi panga Atati winu wa kunani kumahunde kumanya. ");
INSERT INTO mpa_vpl VALUES ("MT10_30","070_10_30","MAT","10","30","30","Nambu hata kwinu mwehapa majunju gha kumutu jinu ghabhalangiki ghokapi. ");
INSERT INTO mpa_vpl VALUES ("MT10_31","070_10_31","MAT","10","31","31","Bhela, ngamwijoghopa, kwa ndandi mwehapa mpalika nakanopi kupeta iwebha yamaheli. ");
INSERT INTO mpa_vpl VALUES ("MT10_32","070_10_32","MAT","10","32","32","“Kila mundu joanyetakela nepanu palongi ja bhandu, nanatu bhelabhela ananunjetakyaje palongi ja Atati wangu joabhi kunani kumahunde. ");
INSERT INTO mpa_vpl VALUES ("MT10_33","070_10_33","MAT","10","33","33","Nambu kila mundu joangana nepanu palongi ja bhandu, nanatu bhelabhela ananunkanaje palongi ja Atati wangu joabhi kunani kumahunde. ");
INSERT INTO mpa_vpl VALUES ("MT10_34","070_10_34","MAT","10","34","34","“Ngamwiholakela kubha nhikiki kuleta lukwali pundema. Nepanu ngachenhikiki kuleta lukwali, nambu lipanga. ");
INSERT INTO mpa_vpl VALUES ("MT10_35","070_10_35","MAT","10","35","35","Maghambu nhikiki kuleta ulekanganu mundu na atati waki, na kamwali na mabhu waki, na mwali na nkowanu waki wa chimbomba, ");
INSERT INTO mpa_vpl VALUES ("MT10_36","070_10_36","MAT","10","36","36","na maadui bhaka mundu nde bhandu bhala bhabhabhi munyumba jaki. ");
INSERT INTO mpa_vpl VALUES ("MT10_37","070_10_37","MAT","10","37","37","“Mundu jokapi joampala atati waki au mabhu waki kupeta nepanu ngacheapalika kubha mbulwa wangu. Na mundu jokapi joampala mwana waki au kamwali waki kupeta nepanu, ngacheapalika kubha mbulwa wangu. ");
INSERT INTO mpa_vpl VALUES ("MT10_38","070_10_38","MAT","10","38","38","Mundu jwangakuutotola msalaba waki na kunyengalela, ngacheapalika kubha mbulwa wangu. ");
INSERT INTO mpa_vpl VALUES ("MT10_39","070_10_39","MAT","10","39","39","Maghambu mundu joapala kuulenda womi waki anaauhoaje, nambu mundu jola joanauhoa womi waki kwa ndandi jangu, anaaupata kabheti. ");
INSERT INTO mpa_vpl VALUES ("MT10_40","070_10_40","MAT","10","40","40","“Mundu jokapi joanaanjopalya mwehapa anyopali nepanu, na mundu jokapi joanyopalela nepanu anaabya anjopali jola joandumiki. ");
INSERT INTO mpa_vpl VALUES ("MT10_41","070_10_41","MAT","10","41","41","Mundu joanjopalela mlota waka Chapanga kwa ndandi nde mlota waka Chapanga, anapata nhupu wa mlota waka Chapanga. Na mundu joanjopalela mundu wamboni kwa ndandi nde wamboni, anapata nhupu waka mundu wamboni. ");
INSERT INTO mpa_vpl VALUES ("MT10_42","070_10_42","MAT","10","42","42","Numpwaghi chakaka, mundu jokapi jonaampekya jumu wa bhachoku abhabha chikombi cha machi mahimu kwa ndandi nde mbulwa wangu, chakaka ngaalepi kupata nhupu waki ng'o.” ");
INSERT INTO mpa_vpl VALUES ("MT11_1","070_11_1","MAT","11","1","1","Yesu paakajomwi kubhalaghalaki ghanihagha kwa bhabhulwa bhaki komi na bhabheli bhala, akabhokiki panihapa, na kujenda kubhola na kutangaza ku michi ja Galilaya. ");
INSERT INTO mpa_vpl VALUES ("MT11_2","070_11_2","MAT","11","2","2","Yohana Mbatizaji paakabhi mu ligeleza akajowini malobhi gha matendu ghaakabhi ahenga Kristo. Henu Yohana akabhatumiki bhabhulwa bhaki, ");
INSERT INTO mpa_vpl VALUES ("MT11_3","070_11_3","MAT","11","3","3","nahuli bhundalukyaje, “Bho, wehapa le nde jola joahika, au tundendalya jonge?” ");
INSERT INTO mpa_vpl VALUES ("MT11_4","070_11_4","MAT","11","4","4","Yesu akabhayangiki, “Njendaje mkumpwaghila Yohana ghala ghamughajowana na kughabhona: ");
INSERT INTO mpa_vpl VALUES ("MT11_5","070_11_5","MAT","11","5","5","Akangalola bhalola, ilema bhajenda, bhabhabhi na malohi bhalamiswa, akangajowa bhajowana, bhakuwa, bhayoka na akakahochu bhatangaziwa Malobhi Manyahi. ");
INSERT INTO mpa_vpl VALUES ("MT11_6","070_11_6","MAT","11","6","6","Apengaliki mundu jola jwangakubha na makangachu na nepani!” ");
INSERT INTO mpa_vpl VALUES ("MT11_7","070_11_7","MAT","11","7","7","Henu bhabhulwa bhaka Yohana habha pabhakabhokiki, Yesu akatumbwi kughapwaghi mapogha gha bhandu malobhi ghaka Yohana Mbatizaji, “Chikahi pamukapiti kwaka Yohana kulipololu kola, bho, mkapiti kulola kike? Bho, mpalika kulibhona litete likanyuhakika na mpongu? ");
INSERT INTO mpa_vpl VALUES ("MT11_8","070_11_8","MAT","11","8","8","Bho, henu mkapiti kulola kike? Bho, mkapiti kumbona mundu joaweti ingobhu inyahi? Bhandu bhabhawata ingobhu inyahi bhatama munyumba ya bhakolongwa. ");
INSERT INTO mpa_vpl VALUES ("MT11_9","070_11_9","MAT","11","9","9","Nambu bho, mkapiti kulola kike? Bho, mlota waka Chapanga? Ena, chakaka mumbweni nkolongwa kupeta mlota waka Chapanga. ");
INSERT INTO mpa_vpl VALUES ("MT11_10","070_11_10","MAT","11","10","10","Hajoju nde Yohana joakalongaliki mu Malembu Mahuhu: Chapanga akapwaghiki, ‘Nepani nuntuma mbolu wangu akulongulyaje, jombi anaakulenganakya indela jaku.’ ");
INSERT INTO mpa_vpl VALUES ("MT11_11","070_11_11","MAT","11","11","11","Numpwaghi chakaka pachilanda ja bhandu bhokapi bhabhabhelakiki na mbomba, ngacheapitali mundu joabhi nkolongwa nakanopi jaka Yohana Mbatizaji. Nambu hata bhela joabhi nchoku nakanopi mu Ukolongwa wa kunani kumahunde, nde nkolongwa kupeta Yohana. ");
INSERT INTO mpa_vpl VALUES ("MT11_12","070_11_12","MAT","11","12","12","Kutumbula chikahi chaka Yohana Mbatizaji paakatangizi mbaka lalenu jenje, Ukolongwa wa kunani kumahunde upengakeka kwa makili, na bhabhabhi na makili nde bhabhapala kuutola kwa makili. ");
INSERT INTO mpa_vpl VALUES ("MT11_13","070_11_13","MAT","11","13","13","Kwa ndandi bhalota bhokapi bhaka Chapanga na Shelia, bhakalotili malobhi gha Ukolongwa waka Chapanga mbaka chikahi chaka Yohana. ");
INSERT INTO mpa_vpl VALUES ("MT11_14","070_11_14","MAT","11","14","14","Ngati anambi tayali kuhobhalela ghangani, henu Yohana nde Eliya joakapalakiki kuhika. ");
INSERT INTO mpa_vpl VALUES ("MT11_15","070_11_15","MAT","11","15","15","Joabhi na makutu, na ajowanaje!” ");
INSERT INTO mpa_vpl VALUES ("MT11_16","070_11_16","MAT","11","16","16","“Bho, nabhalenganisha bhandu bha chibheleku chenjenu na chindu bhole? Bhalengana na bhana bhabhatemi paligulio, bhakapwaghanya lipogha limu lakabhapwaghila lipogha lengi, ");
INSERT INTO mpa_vpl VALUES ("MT11_17","070_11_17","MAT","11","17","17","‘Tukunhoni filimbe, nambu ngachemwakiniki! Tunjembili nyembu ya maombulezu, nambu ngachendelike!’ ");
INSERT INTO mpa_vpl VALUES ("MT11_18","070_11_18","MAT","11","18","18","Maghambu Yohana akahikiki, akakongiki kula chilebhi na kunywa divai, na bhombi bhakapwaghiki, ‘Abhi na majobhi!’ ");
INSERT INTO mpa_vpl VALUES ("MT11_19","070_11_19","MAT","11","19","19","Mwana waka Mundu akahikiki, akakuliki chilebhi na kunywa, na bhombi bhakapwaghiki, ‘Mundingalya mundu ajoju ndohu na ndobhela wembi, nkochi wa bhajopa kode na bhandu bhana mahoku!’ Nambu mbulau yaka Chapanga ibhonakini kubha ya chakaka kwa indela ja mahengu ghaki.” ");
INSERT INTO mpa_vpl VALUES ("MT11_20","070_11_20","MAT","11","20","20","Yesu akatumbwi kujilakalila michi jela ambaju akatendiki ngangachu yamaheli monihomu, nambu bhandu bhaki ngachebhakapaliki kung'anambuka na kughaleka mahoku ghabhu. ");
INSERT INTO mpa_vpl VALUES ("MT11_21","070_11_21","MAT","11","21","21","“Anamuchibhonaje bhandu bha ku Kolazini! Anamuchibhonaje bhandu bha ku Betisaida! Maghambu ngangachu ikolongwa yeyahengakiki mu michi jinu ikahengakiki ku Tilo na ku Sidoni, bhandu bhaki bhakabya bhajomwi kuwata ingobhu ya magunila, na kulijeghela ilihu nahuli kulangiha kubha bhang'anambwiki na kughaleka mahoku ghabhu. ");
INSERT INTO mpa_vpl VALUES ("MT11_22","070_11_22","MAT","11","22","22","Nambu numpwaghila, lichobha lela la utemulu, anaibya mbanga kwa bhandu bha ku Tilo na kwa bhandu bha ku Sidoni kupeta mokwibhelila kwinu. ");
INSERT INTO mpa_vpl VALUES ("MT11_23","070_11_23","MAT","11","23","23","Mwenga mabhandu bha ku Kapelenaumu, bho, muholakela anamulikweha mabhete mbaka kunani kumahunde? Anamuhelakikaje mbaka kuwawa! Maghambu ngangachu yeitendakiki kwaku yakabhi itendakiki ku Sodoma kola, muchi hoghu ukabya ukona mbaka lalenu. ");
INSERT INTO mpa_vpl VALUES ("MT11_24","070_11_24","MAT","11","24","24","Nambu numpwaghi chakaka, lichobha la utemulu wehapa anaupata utemulu ukolongwa kupeta bhandu wa ku inchi ja Sodoma.” ");
INSERT INTO mpa_vpl VALUES ("MT11_25","070_11_25","MAT","11","25","25","Chikahi hechi Yesu akapwaghiki, “Nukuchengula Atati, Bambo, wa kunani kumahunde na pundema, maghambu wahiiki mambu aghagha bhabhabhi na mbulau na bhasomi, na wahyekuli bhana. ");
INSERT INTO mpa_vpl VALUES ("MT11_26","070_11_26","MAT","11","26","26","Ena, Atati, ghanihagha ghokapi ghabhokana na mapalu ghako. ");
INSERT INTO mpa_vpl VALUES ("MT11_27","070_11_27","MAT","11","27","27","“Atati wangu ambekihi hindu yokapi. Nga joammanyi Mwana nambu Atati, na nga joammanyi Atati nambu Mwana, na jokapi Mwana joapala kumuhyekulila, amuhyekulila. ");
INSERT INTO mpa_vpl VALUES ("MT11_28","070_11_28","MAT","11","28","28","“Muhikaje kwangu mwenga mabhokapi mwemung'ahika na kutopakeka na hibwahila, na nenga ananumpomulishaje. ");
INSERT INTO mpa_vpl VALUES ("MT11_29","070_11_29","MAT","11","29","29","Mulikongaje chingolingoli changu, mukalibholaje kwangu, maghambu nepani nde numpole na mili na mtima wa kuliheleha, na mwenga anampata chiheku mu mitima jinu. ");
INSERT INTO mpa_vpl VALUES ("MT11_30","070_11_30","MAT","11","30","30","Maghambu chingolingoli changu nde chijojwike, na chibwahila changu ngachekitopike.” ");
INSERT INTO mpa_vpl VALUES ("MT12_1","070_12_1","MAT","12","1","1","Chikahi chela, Yesu akapetili mu mighonda ja inganu Lichobha la Sabato. Bhela, bhabhulwa bhaki bhakaweni injala, bhakatumbwi kuheketa mapukutu gha ingano, na kula imbeki yaki. ");
INSERT INTO mpa_vpl VALUES ("MT12_2","070_12_2","MAT","12","2","2","Mafalisayo pabhaghaweni ghanihagha, bhakumpwaghi Yesu, “Lingalyaje! Bhabhulwa bhaku bhahenga lijambu langakupalika kuhenga Lichobha la Sabato!” ");
INSERT INTO mpa_vpl VALUES ("MT12_3","070_12_3","MAT","12","3","3","Yesu akabhayangike, “Bho, ngachemsomiki cheakatendiki Daude, papamu na bhajake chikahi pabhakabhi na injala? ");
INSERT INTO mpa_vpl VALUES ("MT12_4","070_12_4","MAT","12","4","4","Jombi akajingi mu Nyumba jaka Chapanga akakuliki mabumunda ghaghabhekakiki palongi jaka Chapanga. Lijambu heli ngachelakapalakiki kwaki, wala kwa bhandu bhaki kula mabumunda ghala, nambu ipalakika pena kumemenwa na bhapenganyambiku kanjika jabhu. ");
INSERT INTO mpa_vpl VALUES ("MT12_5","070_12_5","MAT","12","5","5","Bho, ngachemsomiki mu chitabu cha Shelia kubha kila Lichobha la Sabato, bhapenganyambiku bhabhakubha mu Nyumba jaka Chapanga, chakaka bhaheketa Shelia, nambu ngachebhabhalangika kubha na lihakau? ");
INSERT INTO mpa_vpl VALUES ("MT12_6","070_12_6","MAT","12","6","6","Numpwaghi hotuhotu kubha, joabhi nkolongwa kupeta Nyumba jaka Chapanga abhi pambane. ");
INSERT INTO mpa_vpl VALUES ("MT12_7","070_12_7","MAT","12","7","7","Nambu ngati mukamanyi ndandi ja malobhi aghagha, ‘Mbala chiha, wala nga nyambiku.’ Ngamukabhatemwi bhandu bhangakubha na mahakau. ");
INSERT INTO mpa_vpl VALUES ("MT12_8","070_12_8","MAT","12","8","8","Maghambu Mwana waka Mundu nde Bambo wa Lichobha la Sabato.” ");
INSERT INTO mpa_vpl VALUES ("MT12_9","070_12_9","MAT","12","9","9","Yesu akabhokiki panihapa, akapiti kujingila mu nyumba ja kuhimangani Bhayahude, ");
INSERT INTO mpa_vpl VALUES ("MT12_10","070_12_10","MAT","12","10","10","mkati mola kukabhi na mundu jumu joakatengwiki chiwoku. Bhela, bhandu bhakundaluki Yesu, “Bho, wichu le kundamiha mundu Lichobha la Sabato?” Bhakundaluki bhelabhela nahuli bhapata ndandi ja kuntakila. ");
INSERT INTO mpa_vpl VALUES ("MT12_11","070_12_11","MAT","12","11","11","Yesu akabhayangiki, “Ngati anaabhi mundu jumu pachilanda jinu abhi na limbeleli limu, na limbeleli lela analijingi mulibhomba Lichobha la Sabato, bho, ngaalikamuli na kulipiha mulibhomba mola? ");
INSERT INTO mpa_vpl VALUES ("MT12_12","070_12_12","MAT","12","12","12","Bho, mundu nga wambone nakanopi kupeta limbeleli? Bhela, nde wichu kutenda mambu ghambone mu Lichobha la Sabato.” ");
INSERT INTO mpa_vpl VALUES ("MT12_13","070_12_13","MAT","12","13","13","Panihapa Yesu akampwaghi mundu joakatengwiki chiwoku jola, “Hatambula chiwoku chaku.” Akahatambwili, na chombi chikalamiki na kubha ngati chengi chela. ");
INSERT INTO mpa_vpl VALUES ("MT12_14","070_12_14","MAT","12","14","14","Mafalisayo bhakapitiki kunja, na kujenda kujetanganela ntundu wa kunkoma Yesu. ");
INSERT INTO mpa_vpl VALUES ("MT12_15","070_12_15","MAT","12","15","15","Nambu Yesu paaghamanyi mambu ghanihagha, akabhokiki pandu pala. Na bhandu bhamaheli bhakanjengalile, akabhalamihi bhatamwa bhokapi, ");
INSERT INTO mpa_vpl VALUES ("MT12_16","070_12_16","MAT","12","16","16","akabhakanakili ngabhapwaghi bhandu malobhi ghaki. ");
INSERT INTO mpa_vpl VALUES ("MT12_17","070_12_17","MAT","12","17","17","Akahengiki bhenibhela nahuli ghala ghaakapwaghiki Chapanga kupetela kwaka mlota Isaya ghatimilaje: ");
INSERT INTO mpa_vpl VALUES ("MT12_18","070_12_18","MAT","12","18","18","“Lingalyaje mtumika wangu jonunhawili, mpalu wangu joanihekeha namaa mumtima. Anameka Roho jangu panani jaki, najombi anatangaza utemulu wangu kwa bhandu bha mataifa ghokapi. ");
INSERT INTO mpa_vpl VALUES ("MT12_19","070_12_19","MAT","12","19","19","Ngaakubhi na ing'omu wala kujamalila, wala nga mundu joanajowanaje sauti jaki mwindela. ");
INSERT INTO mpa_vpl VALUES ("MT12_20","070_12_20","MAT","12","20","20","Ndahi woutimbakiki ngawihekateki, wala utambi wouhuka lyohi ngawichuchuke, mbaka payitenda utemulu ghoupalakika utawalaje. ");
INSERT INTO mpa_vpl VALUES ("MT12_21","070_12_21","MAT","12","21","21","Bhandu bhangakubha Bhayahude anabhalihobhalya lihina laki.” ");
INSERT INTO mpa_vpl VALUES ("MT12_22","070_12_22","MAT","12","22","22","Bhela, bhandu bhakumu bhakandeti Yesu mundu jumu joakamuliki na majobhi, na kuntenda kubha ngalola na mpuli. Yesu akandamihi mundu jola mbaka akaweziki kulongela na kulola. ");
INSERT INTO mpa_vpl VALUES ("MT12_23","070_12_23","MAT","12","23","23","Lipogha lokapi la bhandu bhakakangichi, na kupwagha, “Bho, jonjo le nga Mwana waka Daude?” ");
INSERT INTO mpa_vpl VALUES ("MT12_24","070_12_24","MAT","12","24","24","Nambu Mafalisayo pabhakajowini ghanihagha, bhakapwaghike, “Mundu ajoju atopola majobhi kwa makili ghaka Beelizebuli, nkolongwa wa majobhi.” ");
INSERT INTO mpa_vpl VALUES ("MT12_25","070_12_25","MAT","12","25","25","Yesu akaghamanyi maholalelu ghabu, akabhapwaghile, “Ukolongwa wokapi ghoulekangini mapogha mapogha ghaghakomana, ngauwezi kutamakila, na muchi wokapi au nyumba jokapi jejighabhaniki mapogha mapogha ghaghakomana, anajihabhukaje. ");
INSERT INTO mpa_vpl VALUES ("MT12_26","070_12_26","MAT","12","26","26","Ngati Shetani, aghatopola majobhi ghaki, alipenga mweni. Bho, ukolongwa waki anaujema bhole? ");
INSERT INTO mpa_vpl VALUES ("MT12_27","070_12_27","MAT","12","27","27","Mwehapa mpwagha kubha nepani menga lijobhi kwa makili ghaka Beelizebuli, bho, bhahemba bhinu bhatopola kwa uwezu waka nane? Kwa ndandi jeniheji bhombi nde baanabhuntemula mwenga. ");
INSERT INTO mpa_vpl VALUES ("MT12_28","070_12_28","MAT","12","28","28","Nambu anakubhi menga lijobhi kwa makili ghaka Roho waka Chapanga, bhela mumanyaje kubha Ukolongwa waka Chapanga ujomwi kuhika kwinu. ");
INSERT INTO mpa_vpl VALUES ("MT12_29","070_12_29","MAT","12","29","29","“Au, bho, mundu aweza bhole kujingila mu nyumba jaka joabhi na makili na kunyaghula hindu yaki, panga hoti kunkonga mundu joabhi na makili hoju? Anajomwi kunkonga panihapa nde aweza kunyaghula hindu yaki. ");
INSERT INTO mpa_vpl VALUES ("MT12_30","070_12_30","MAT","12","30","30","“Mundu jwangakubha papamu na nenga atenda kumbenga, na mundu jwangakubhongana papamu na nenga, atenda kupechangana. ");
INSERT INTO mpa_vpl VALUES ("MT12_31","070_12_31","MAT","12","31","31","Kwa ndandi jeniheji numpwaghila, bhandu anabhalekakiwaje mahoku na matondu ghabhu ghokapi, nambu ngabhilekakewi mahoku kwa kuntondola Roho waka Chapanga. ");
INSERT INTO mpa_vpl VALUES ("MT12_32","070_12_32","MAT","12","32","32","Kila mundu joandongalela mahakau Mwana waka Mundu anaalekakiwaji, nambu kila mundu joampwagha mahakau Roho Mhuhu, ngaalekakewi ikubhi pundema ghoni au pundema ghouhika. ");
INSERT INTO mpa_vpl VALUES ("MT12_33","070_12_33","MAT","12","33","33","“Nkongu unyahi upambika mapambiku manyahi, na nkongu uhakau upambika mapambiku mahakau. Kwa ndandi nkongu umanyikana kwa mapambiku ghaki. ");
INSERT INTO mpa_vpl VALUES ("MT12_34","070_12_34","MAT","12","34","34","Mwenga mwachibheleku cha lijoka! Bho, muweza bholi kupwagha mambu ghamboni koni mwabheti mwahakau? Maghambu mundu apwagha kubhokana na ghala ghaghatweli muntima waki. ");
INSERT INTO mpa_vpl VALUES ("MT12_35","070_12_35","MAT","12","35","35","Mundu wamboni apiha mambu ghamboni kuhuma mu chikoku chinyahi cha mtima waki, na mundu muhakau apiha mambu mahakau kuhuma mu chikoku chihakau cha mtima waki. ");
INSERT INTO mpa_vpl VALUES ("MT12_36","070_12_36","MAT","12","36","36","“Bhela, numpwaghila, lichobha la utemulu bhandu anabhapalika kuyanga kwa kila lilobhi langakupalika lebhapwagha. ");
INSERT INTO mpa_vpl VALUES ("MT12_37","070_12_37","MAT","12","37","37","Maghambu kwa malobhi ghaku anaubhalangiki kubha wamboni, na kwa malobhi ghaku anautemuliwaje kubha na mahoku.” ");
INSERT INTO mpa_vpl VALUES ("MT12_38","070_12_38","MAT","12","38","38","Panihapa bhabhola bhangi bha Shelia na Mafalisayo bhakamuyangiki Yesu, “Mbola, tupala kubhona nginyulila kuhuma kwaku.” ");
INSERT INTO mpa_vpl VALUES ("MT12_39","070_12_39","MAT","12","39","39","Yesu akabhayangiki, “Chibheleku cha bhandu bhahakau na bhandu bhanga kummanya Chapanga!” Mpala nginyulila, ngampati nginyulila ng'o, nambu nginyulila jela jaka mlota Yona. ");
INSERT INTO mpa_vpl VALUES ("MT12_40","070_12_40","MAT","12","40","40","Maghambu ngati bhela Yona moakatami mulutumbu lwa homba ngolongwa chikahi cha machobha ghatatu, muhi na ikilu, bhelabhela Mwana waka Mundu anandamaje machobha ghatatu, muhi na ikilu mu mtima wa luhombi. ");
INSERT INTO mpa_vpl VALUES ("MT12_41","070_12_41","MAT","12","41","41","Lichobha Chapanga paanabhatemula bhandu, bhandu bha ku Ninawi anabhajemaji na kuntemula mwehapa, kwa ndandi bhombi bhakang'anambwiki na kughaleka mahoku ghabhu chikahi pabhakajowini mabholu ghaka Yona, na pambani abhi nkolongwa kupeta Yona! ");
INSERT INTO mpa_vpl VALUES ("MT12_42","070_12_42","MAT","12","42","42","Linyongolo la ku inchi ja Sheba anajemaje chikahi cha kutemula na kuchitemula chibheleku chenjenu kubha chibhi na mahoku, maghambu jombi akatendiki mwanja kuhuma kutali, na kuhika kujowanela malobhi gha mbulau ghaka Solomoni, na pambani abhi nkolongwa kupeta Solomoni. ");
INSERT INTO mpa_vpl VALUES ("MT12_43","070_12_43","MAT","12","43","43","“Lijobhi palumpita mundu, lipetela pandu panga machi, akalonda pandu pa kupomulela, ngati ngacheapatike, ");
INSERT INTO mpa_vpl VALUES ("MT12_44","070_12_44","MAT","12","44","44","alipwaghi mweni, ‘Anangelabhuka kunyumba jangu konihumike.’ Nambu paakelabhuka na kujihimanila nyumba jela jibhi lipala, na jipyaghaliki na kunyambiswa wichu, ");
INSERT INTO mpa_vpl VALUES ("MT12_45","070_12_45","MAT","12","45","45","ajenda kubhaleta majobhi bhangi saba, bhahakau kupeta jombi, na bhokapi bhahika na kunjingila mundu hoju na kutama mkati jaki. Na hali jaka mundu hoju jikubha jihakau nakanopi kupeta hali jaki ja kutumbulila. Bhenibhela nde mokwibhelila kwa bhandu bhahakau bha chibeleku chenjenu.” ");
INSERT INTO mpa_vpl VALUES ("MT12_46","070_12_46","MAT","12","46","46","Yesu paakabhi akona kulongela na lipogha la bhandu, mabhu waki na bhalongu bhaki bhakajemiki kunja, bhakapala kulonge naku. ");
INSERT INTO mpa_vpl VALUES ("MT12_47","070_12_47","MAT","12","47","47","Mundu jumu akampwaghi Yesu, “Amabhu waku na bhalongu bhaku bhajemiki kunja, bhapala kulonge na wehapa.” ");
INSERT INTO mpa_vpl VALUES ("MT12_48","070_12_48","MAT","12","48","48","Yesu akamuyangike, “Bho, mabhu wangu nde nane? Na bho, bhalongu bhangu nde akanane?” ");
INSERT INTO mpa_vpl VALUES ("MT12_49","070_12_49","MAT","12","49","49","Akahatambwi chiwoku chaki kwa bhabhulwa bhaki, na kupwagha, “Abhabha nde amabhu wangu, na abhabha nde bhalongu bhangu! ");
INSERT INTO mpa_vpl VALUES ("MT12_50","070_12_50","MAT","12","50","50","Maghambu jokapi joaghatenda ghaaghapala Atati wangu wa kunani kumahunde, jonihoju nde mbeli wangu, ndombu wangu, na mabhu wangu.” ");
INSERT INTO mpa_vpl VALUES ("MT13_1","070_13_1","MAT","13","1","1","Lichobha lelalela, Yesu akabhokiki kunyumba na kutama mumaheku ja nhwanga. ");
INSERT INTO mpa_vpl VALUES ("MT13_2","070_13_2","MAT","13","2","2","Lipogha likolongwa la bhandu bhakamuyongalwiti, hata Yesu akakweliki mu ngalawa na kutama. Bhandu bhokapi bhakajemiki mumaheku ja nhwanga. ");
INSERT INTO mpa_vpl VALUES ("MT13_3","070_13_3","MAT","13","3","3","Yesu akabhapwaghi mambu ghamaheli kwa malenganesu. “Njowanyaye! Mpanda akapiti kukweta imbeju. ");
INSERT INTO mpa_vpl VALUES ("MT13_4","070_13_4","MAT","13","4","4","Paakabhi akweta imbeju, yengi ikatolili pandela, ijuni ikahikiki na kula. ");
INSERT INTO mpa_vpl VALUES ("MT13_5","070_13_5","MAT","13","5","5","Yengi ikatolili pamaganga panga kubha na luhombi lwamaheli. Ikabhonakini kumela manyata kwa ndandi luhombi lukabhi luchoku, ");
INSERT INTO mpa_vpl VALUES ("MT13_6","070_13_6","MAT","13","6","6","lyobha likali palabhaliki, ikanyalike, kwa ndandi mikegha jaki ngachejikajibhi mbaka pahi. ");
INSERT INTO mpa_vpl VALUES ("MT13_7","070_13_7","MAT","13","7","7","Imbeju yengi ikatolili mu miha, miha heyi ikakoliki na kuihinya. ");
INSERT INTO mpa_vpl VALUES ("MT13_8","070_13_8","MAT","13","8","8","Imbeju yengi ikatolili pa luhombi lunyahi, ikameliki, na ikapambiki. Yengi ikapambiki mia moja, yengi sitini, na yengi selasini.” ");
INSERT INTO mpa_vpl VALUES ("MT13_9","070_13_9","MAT","13","9","9","Yesu akajomuli kupwagha, “Mundu joabhi na makutu, na ajowanaje!” ");
INSERT INTO mpa_vpl VALUES ("MT13_10","070_13_10","MAT","13","10","10","Bhabhulwa bhaki bhakanjendili, na kundalukila, “Bho, maghambu kiki ulongela na bhandu kwa milenganesu?” ");
INSERT INTO mpa_vpl VALUES ("MT13_11","070_13_11","MAT","13","11","11","Yesu akabhayangiki, “Mwehapa mpekakiwi kuimanya hindu ya sili ya Ukolongwa wa kunani kumahunde, nambu bhombi ngachebhahyekuliwi. ");
INSERT INTO mpa_vpl VALUES ("MT13_12","070_13_12","MAT","13","12","12","Maghambu mundu joabhi na chindu, anapataje na kujonjukewa, nambu jola jwanga na chindu, hata chela cheabhi nachu anachitolakikaje. ");
INSERT INTO mpa_vpl VALUES ("MT13_13","070_13_13","MAT","13","13","13","Kwa ndandi jenjenu nde ndandi mbwagha nabhu kwa milenganesu, anabhalingalyaje nambu ngabhabhoni, na bhajowanela, nambu ngachebhajowana wala ngachebhamanya. ");
INSERT INTO mpa_vpl VALUES ("MT13_14","070_13_14","MAT","13","14","14","Bhela ghapitalili ghala ghaakapwaghiki mlota Isaya, ‘Kujowana ananjowanaje, nambu ngammanye. Kulola anandolaje, nambu ngambone. ");
INSERT INTO mpa_vpl VALUES ("MT13_15","070_13_15","MAT","13","15","15","Maghambu mitima ja bhandu bhanihabha jitehi kunonopa, bhaghahibhiki makutu ghabhu, bhaghahibhiki mihu ghabhu. Nanga bhela, bhakabya bhaloliki kwa mihu ghabhu, bhakabya bhajowini kwa makutu ghabhu, bhakabya bhamanyi kwa malangu ghabhu, na kuning'anambukila, na nenga nakabya nabhalamihe.’ ");
INSERT INTO mpa_vpl VALUES ("MT13_16","070_13_16","MAT","13","16","16","“Nambu mbanga kwinu mwenga, maghambu mihu ghinu ghalola na makutu ghinu ghajowana. ");
INSERT INTO mpa_vpl VALUES ("MT13_17","070_13_17","MAT","13","17","17","Numpwaghi chakaka, bhalota bhamaheli bhaka Chapanga na bhandu bhamaheli bhaka Chapanga bhakatokuli kughabona ghala ghamughabhona mwehapa, ngabhaghabhona, na kujowana ghala ghamughajowana mwehapa, ngabhijowana. ");
INSERT INTO mpa_vpl VALUES ("MT13_18","070_13_18","MAT","13","18","18","“Bhela, mwenga njowanyaje, ndandi ja ulenganesu ghongo waka mpanda. ");
INSERT INTO mpa_vpl VALUES ("MT13_19","070_13_19","MAT","13","19","19","Mundu jokapi joajowana malobhi gha Ukolongwa waka Chapanga panga kumanya, nde ngati imbeju yela yeitolili mundela, na Muhakau jola ahika na kunyaghula lilobhi lela lelipandakiki muntima waki. ");
INSERT INTO mpa_vpl VALUES ("MT13_20","070_13_20","MAT","13","20","20","Imbeju yeipandakiki papabhi na maganga, nde ulenganesu waka mundu joajowana lilobhi heli na kulijopalela kwa chiheku. ");
INSERT INTO mpa_vpl VALUES ("MT13_21","070_13_21","MAT","13","21","21","Nambu kwa kubha mundu hoju ngacheabhi na mikegha mkati jaki, lilobhi heli litama kwa chikahi chijipi, na paupitali ulale au mang'ahiku kwa ndandi ya lilobhi heli, jombi mala pankamu akuleka kuhobhalela. ");
INSERT INTO mpa_vpl VALUES ("MT13_22","070_13_22","MAT","13","22","22","Imbeju jejipandakiki mu miha nde mundu jola joalijowana lilobhi, nambu kubhokana na choghohi cha matamu ghane na utokulelu wa hindu yamaheli, ilihinya lilobhi heli, na ngachebhapambika mapambiku. ");
INSERT INTO mpa_vpl VALUES ("MT13_23","070_13_23","MAT","13","23","23","Nambu imbeju yeipandakiki muluhombi lunyahi nde mundu jola ambaju alijowana lilobhi na kulimanya. Na jombi chakaka apambika mapambiku, jumu mia, na jongi sitini, na jongi selasini.” ");
INSERT INTO mpa_vpl VALUES ("MT13_24","070_13_24","MAT","13","24","24","Yesu akabhapwaghi bhandu ulenganesu ghonge, akapwaghaje, “Ukolongwa wa kunani kumahunde ulengana na mundu joapandiki imbeju jambone mungonda waki. ");
INSERT INTO mpa_vpl VALUES ("MT13_25","070_13_25","MAT","13","25","25","Nambu bhandu pabhakabhi bhaghonile, adui waki akahikiki kupanda maghoghu pachilanda ja ingano, na mweni kubhoka. ");
INSERT INTO mpa_vpl VALUES ("MT13_26","070_13_26","MAT","13","26","26","Ingano pahikameliki, na kutumbula kupambika, maghoghu na ghombi ghakameliki. ");
INSERT INTO mpa_vpl VALUES ("MT13_27","070_13_27","MAT","13","27","27","Bhatumika bhaka mweni ngonda jola bhakanjendili, na kundalukila, ‘Bambo, bho, ngacheukapandiki imbeju jambone mungonda wako? Bho, henu maghoghu aghagha ghahumiki kwako?’ ");
INSERT INTO mpa_vpl VALUES ("MT13_28","070_13_28","MAT","13","28","28","Jombi akabhayangiki, ‘Muhakau nde joatendiki lijambu hele.’ Bhatumika bhaki bhakundalukile, ‘Bho, upala le tukaghatupulaje?’ ");
INSERT INTO mpa_vpl VALUES ("MT13_29","070_13_29","MAT","13","29","29","Nambu akapwaghite, ‘Ngabhela, ngamwitupula, maghambu pamwitupulaje maghoghu, muweza kutupula na ingano papamu. ");
INSERT INTO mpa_vpl VALUES ("MT13_30","070_13_30","MAT","13","30","30","Muileka ingano na maghoghu ghakolaje papamu mbaka chikahi cha mahuno. Chikahi hechi ananabhapwaghila bhahuna bhaghabhongana hoti maghoghu, bhaghakonga makenda makenda nahuli kughajocha. Nambu ingano muibhonganaje na mkaibheka muugholu wangu.’ ” ");
INSERT INTO mpa_vpl VALUES ("MT13_31","070_13_31","MAT","13","31","31","Yesu akabhapwaghi bhandu ulenganesu ghonge, akapwagha, “Ukolongwa wa kunani kumahunde ulengana na imbeju njoku jejilowakeka haladali, jeakatoliki mundu jumu, na kupanda mungonda waki. ");
INSERT INTO mpa_vpl VALUES ("MT13_32","070_13_32","MAT","13","32","32","Imbeju heji nde njoku kupeta imbeju yengi yokapi, nambu anajijomwi kumela, mmea waki ukola kupeta mikongu jokapi muchijongu. Ukola na kubha nkongu ukolongwa, mbaka ijuni ya kunani ihika na kuchenga mihuwi mu mambandi ghaki.” ");
INSERT INTO mpa_vpl VALUES ("MT13_33","070_13_33","MAT","13","33","33","Yesu akabhapwaghi ulenganesu ghonge, akapwagha, “Ukolongwa wa kunani kumahunde ulengini na amila jeakatotwili mbomba jumu, na kuhangaghana na uhembi miyipulila jibheli na upenga, mbaka uhembi wokapi ukatutumwike.” ");
INSERT INTO mpa_vpl VALUES ("MT13_34","070_13_34","MAT","13","34","34","Yesu akaghapwaghi mapogha gha bhandu malobhi ghanihagha ghokapi kwa kupetela milenganesu, wala ngacheakaweziki kubhapwaghila chokapi panga kupetela milenganesu. ");
INSERT INTO mpa_vpl VALUES ("MT13_35","070_13_35","MAT","13","35","35","Nahuli lijambu lelakapwaghakiki na mlota waka Chapanga lipitalyaje, “Anambwagha nabhu kwa milenganesu, ananapwaghila mambu ghaghalihiiki kutumbu kubhombakeka kwa ndema.” ");
INSERT INTO mpa_vpl VALUES ("MT13_36","070_13_36","MAT","13","36","36","Panihapa Yesu akatabhukini na lipogha la bhandu lela, na kujingila munyumba. Bhabhulwa bhaki bhakanjendili, na kumpwaghila, “Utulandilaje ndandi ja ulenganesu ghonihoghu wa maghoghu gha mungonda.” ");
INSERT INTO mpa_vpl VALUES ("MT13_37","070_13_37","MAT","13","37","37","Yesu akabhayangiki, “Mpanda wa imbeju jambone nde Mwana waka Mundu, ");
INSERT INTO mpa_vpl VALUES ("MT13_38","070_13_38","MAT","13","38","38","ngonda nde ndema, na imbeju yambone nde bhandu bhala ambabhu Ukolongwa nde wabhu. Nambu maghoghu nde bhandu bhaka Muhakau jola. ");
INSERT INTO mpa_vpl VALUES ("MT13_39","070_13_39","MAT","13","39","39","Adui joapandiki maghoghu nde Shetani. Mahunu nde ujomukelu wa ndema, na bhahuna nde bhatumika bha kunani kwaka Chapanga. ");
INSERT INTO mpa_vpl VALUES ("MT13_40","070_13_40","MAT","13","40","40","Ngati bhela maghoghu mobhaghabhonganela na kughajocha moto, bhenibhela nde mokwibhelilaje chikahi cha ujomukelu wa ndema. ");
INSERT INTO mpa_vpl VALUES ("MT13_41","070_13_41","MAT","13","41","41","Mwana waka Mundu anaabhatuma bhatumika bhaki, bhabhonganaje kuhuma mu Ukolongwa waki bhandu bhokapi bhabhatenda bhangi bhahenga mahoku, papamu na bhandu bhabhatenda uhakau, ");
INSERT INTO mpa_vpl VALUES ("MT13_42","070_13_42","MAT","13","42","42","na bhombi anabhalekalika mkati ja mvune wa moto ukale, konihoku anakubya na chilelu na kuyagha mino. ");
INSERT INTO mpa_vpl VALUES ("MT13_43","070_13_43","MAT","13","43","43","Nambu bhandu bhabhahenga ghambone palongi jaka Chapanga, anabhang'anyaje ngati lyobha mu Ukolongwa wa Atati wabhu. Joabhi na makutu na ajowanaje! ");
INSERT INTO mpa_vpl VALUES ("MT13_44","070_13_44","MAT","13","44","44","“Ukolongwa wa kunani kumahunde ulengana na chikoku chechihiyakiki mungonda. Mundu jumu akachiwene, na kuchihiya kabhete. Akahekali namaa hata akapiti kulombesa hindu yokapi yeakabhi nayu, na kuhemela ngonda ghola. ");
INSERT INTO mpa_vpl VALUES ("MT13_45","070_13_45","MAT","13","45","45","“Kabhete, Ukolongwa wa kunani kumahunde ulengana na mundu joahemela na kulombesa joakabhi alonda lulu jinyahi, ");
INSERT INTO mpa_vpl VALUES ("MT13_46","070_13_46","MAT","13","46","46","na paakajiwene lulu jimu jinyahi nakanopi, akapiti kuhemalela hindu yokapi yeakabhi nayu, na kuhemela lulu jela.” ");
INSERT INTO mpa_vpl VALUES ("MT13_47","070_13_47","MAT","13","47","47","“Kabhete, Ukolongwa wa kunani kumahunde ulengana na nkwabhu ghobhapendaki muhwanga, na kuwelela homba ya kila ntundu. ");
INSERT INTO mpa_vpl VALUES ("MT13_48","070_13_48","MAT","13","48","48","Paukatweli homba, bhalohi bhakahutiki nkwabhu hoghu mbaka kundema, na kutama pahi, na kuhaghula homba yambone kuibheka muikapu yambone, nambu homba ihakau bhakailekile. ");
INSERT INTO mpa_vpl VALUES ("MT13_49","070_13_49","MAT","13","49","49","Bhenibhela nde mokwibhelilaje chikahi cha ujomukelu wa ndema. Bhatumika bha kunani kwaka Chapanga anabhahikaje na kubhahaghula bhandu bhahakau na bhandu wambone. ");
INSERT INTO mpa_vpl VALUES ("MT13_50","070_13_50","MAT","13","50","50","Bhela bhandu bhahakau anabhalekalika mu mvune wa moto ukale, konihoku anakubya na chilelu na kuyagha mino.” ");
INSERT INTO mpa_vpl VALUES ("MT13_51","070_13_51","MAT","13","51","51","Yesu akabhalalukile, “Bho, mughamanyi le mambu ghanihagha ghokapi?” Bombi bhakamyangiki, “Ena, Bambo.” ");
INSERT INTO mpa_vpl VALUES ("MT13_52","070_13_52","MAT","13","52","52","Akabhapwaghile, “Henu kila mbola wa Shelia joabhi mbulwa wa Ukolongwa wa kunani kumahunde, alengana na mundu mweni nyumba joabhoha hindu kuhuma mu ugholu waki hindu yahenu na hindu ya mwande.” ");
INSERT INTO mpa_vpl VALUES ("MT13_53","070_13_53","MAT","13","53","53","Yesu paakajomwi kubhoha milenganesu jeniheji, akabhokiki pandu pala, ");
INSERT INTO mpa_vpl VALUES ("MT13_54","070_13_54","MAT","13","54","54","na paakahikiki ku muchi waki, akabhabholiki bhandu mu nyumba ja kuhimanganila Bhayahude. Na bhombi bhakakangichi, bhakalalukile, “Bho, mundu jonihoju apatiki kwaku malangu ghanihagha na lujiniku loniholu lwa kutenda ngangachu? ");
INSERT INTO mpa_vpl VALUES ("MT13_55","070_13_55","MAT","13","55","55","Bho, jonihoju le nga mwana waka Selemala jola? Bho, mabhu waki nga joalowakeka Malia, na bhalongu bhaki nde Yakobo na Yusufu na Simoni na Yuda? ");
INSERT INTO mpa_vpl VALUES ("MT13_56","070_13_56","MAT","13","56","56","Bho, bhalombu bhaki ngachebhatama pitu pane? Bho, apatiki kwaku henu malobhi ghanihagha ghokapi?” ");
INSERT INTO mpa_vpl VALUES ("MT13_57","070_13_57","MAT","13","57","57","Bhakakaniki kunjopalela. Nambu Yesu akabhapwaghile, “Mlota waka Chapanga apata utopelu pandu pokapi, nambu nga pa inchi jaki na panyumba jaki.” ");
INSERT INTO mpa_vpl VALUES ("MT13_58","070_13_58","MAT","13","58","58","Yesu ngacheakatendiki ngangachu yamaheli panipala, kwa ndandi ja bhandu kulepa kuhobhalela kwabhu. ");
INSERT INTO mpa_vpl VALUES ("MT14_1","070_14_1","MAT","14","1","1","Chikahi hechi Helode, akabhi chiongozi wa mkoa wa Galilaya, akajowini malobhi ghaka Yesu, ");
INSERT INTO mpa_vpl VALUES ("MT14_2","070_14_2","MAT","14","2","2","akabhapwaghi bhatumika bhaki, “Jonihoju nde Yohana Mbatizaji, ahyokiki kuhuma kwa bhakuwa, ndemana makili gha kutenda ngangachu ghahenga lihengu mkati jaki.” ");
INSERT INTO mpa_vpl VALUES ("MT14_3","070_14_3","MAT","14","3","3","Helode akabhi ankamwile Yohana Mbatizaji, na kunkonga minyololu, na kumbeka muchifungo kwa ndandi jaka Helodia, nhwanu waka Filipo, joakabhi mbeli waki. ");
INSERT INTO mpa_vpl VALUES ("MT14_4","070_14_4","MAT","14","4","4","Maghambu Yohana akabhi ampwaghi Helode kubha, “Nga wichu kwaku wehapa kuntogho mbomba jonihoju!” ");
INSERT INTO mpa_vpl VALUES ("MT14_5","070_14_5","MAT","14","5","5","Helode akapaliki namaa kunkoma Yohana, nambu akabhajowipi bhandu, kwa ndandi bhombi bhakamanyi kubha Yohana nde mlota waka Chapanga. ");
INSERT INTO mpa_vpl VALUES ("MT14_6","070_14_6","MAT","14","6","6","Nambu lichobha la uwangalalu wa kubhelakeka kwaka Helode, kamwali waka Helodia akahiniki palongi ja bhandu bhabhakakokakiki, na Helode akahekalile namaa. ");
INSERT INTO mpa_vpl VALUES ("MT14_7","070_14_7","MAT","14","7","7","Bhela Helode akapwaghiki kwa kulapa kumpekeha kamwali hoju chokapi cheanaandobhaje. ");
INSERT INTO mpa_vpl VALUES ("MT14_8","070_14_8","MAT","14","8","8","Kwa kujowanela malobhi gha amabhu waki, mwali hoju akandobhiki, “Umbekya mmutu waka Yohana Mbatizaji muchipalu.” ");
INSERT INTO mpa_vpl VALUES ("MT14_9","070_14_9","MAT","14","9","9","Nkolongwa Helode ukambiniki mtima, nambu kwa ndandi ja kulapa kola koakalapiki palongi ja bhaghene, akalaghalaki kubha lilobhu laki lijetakaliwe. ");
INSERT INTO mpa_vpl VALUES ("MT14_10","070_14_10","MAT","14","10","10","Bhela, Helode akantumiki mundu muchifungo akunhekata mmutu Yohana Mbatizaji. ");
INSERT INTO mpa_vpl VALUES ("MT14_11","070_14_11","MAT","14","11","11","Mmutu waki ukaletakiki muchipalu, na kumpekeha mwali jola, najombi akapeliki kwaka mabhu waki. ");
INSERT INTO mpa_vpl VALUES ("MT14_12","070_14_12","MAT","14","12","12","Bhabhulwa bhaka Yohana bhakahikiki, na kutola hyegha jaki, na kujitagha. Na bhombi bhakapiti kumpwaghi Yesu lijambu leniheli. ");
INSERT INTO mpa_vpl VALUES ("MT14_13","070_14_13","MAT","14","13","13","Yesu paakajowini malobhi ghaghapitalile, akabhokiki pandu pala kwa ngalawa, na kujenda pandu panga bhandu nahuli abya kanjika jaki. Na bhandu pabhakajowine, bhakunjengalili kwa magholu kuhuma ku michi jabhu. ");
INSERT INTO mpa_vpl VALUES ("MT14_14","070_14_14","MAT","14","14","14","Yesu paakahulwiki mungalawa mumaheku ja bahali, akaliweni lipogha likolongwa la bhandu, akabhabhoni chiha na kubhalamiha hitamu yabhu. ");
INSERT INTO mpa_vpl VALUES ("MT14_15","070_14_15","MAT","14","15","15","Pakwahikiki pakamihi, bhabhulwa bhaki bhakunjendili na kumpwaghila, “Pandu pambane nde pachingwenje, na lichobha lijomwike. Watabhuka bhandu bhabhokaje nahuli bhakahemala chilebhi muijiji.” ");
INSERT INTO mpa_vpl VALUES ("MT14_16","070_14_16","MAT","14","16","16","Yesu akabhayangiki, “Njeta ndandi ja bhombi kubhoka. Mwapekya mwehapa chilebhi.” ");
INSERT INTO mpa_vpl VALUES ("MT14_17","070_14_17","MAT","14","17","17","Nambu bhombi bhakamuyangiki, “Pambane tubhi na mabumunda nhwanu, na homba ibheli pena.” ");
INSERT INTO mpa_vpl VALUES ("MT14_18","070_14_18","MAT","14","18","18","Yesu akabhapwaghile, “Ndeta pambane.” ");
INSERT INTO mpa_vpl VALUES ("MT14_19","070_14_19","MAT","14","19","19","Akabhalaghalakile bhandu bhala bhatama pahi pa manyonyole. Akaghatoliki mabumunda nhwanu ghala na homba ibheli yela, akalingali kunani kumahunde, na akaipengalile. Akanukwili mabumunda ghala na kubhapekeha bhabhulwa bhaki, na bhabhulwa bhaki bhakabhaghabhi bhandu. ");
INSERT INTO mpa_vpl VALUES ("MT14_20","070_14_20","MAT","14","20","20","Bhandu bhokapi bhakalile na kutupila. Na bhabhulwa bhaki bhakabhongini hipandi ya mabumunda yeyahighalile, na bhakatwelaki itonga komi na ibheli. ");
INSERT INTO mpa_vpl VALUES ("MT14_21","070_14_21","MAT","14","21","21","Bhombi bhabhakalile bhakabhi akanalomi ngati elufu nhwanu, panga kubhalanga akambomba na bhana. ");
INSERT INTO mpa_vpl VALUES ("MT14_22","070_14_22","MAT","14","22","22","Yesu paakajomwi mambu ghanihagha, akabhapwaghi bhabhulwa bhaki bhakwela mu ngalawa na bhajenda kwihi ja kabheli ja bahali, chikahi hechi jombi akabhi abhatabhuka bhandu bhala. ");
INSERT INTO mpa_vpl VALUES ("MT14_23","070_14_23","MAT","14","23","23","Paakajomwi kubhatabhuka bhandu, akapiti kuchitombi kanjika jaki kundobha Chapanga. Na chimihi pakwahikiki, Yesu akabhi konihoku kanjika jaki, ");
INSERT INTO mpa_vpl VALUES ("MT14_24","070_14_24","MAT","14","24","24","chikahi hechi ngalawa jela jakabhi jihikiki kutali, jakadengadengaje na majegha, kwa ndandi mpongu ukabhi ukale. ");
INSERT INTO mpa_vpl VALUES ("MT14_25","070_14_25","MAT","14","25","25","Pachibhombu, Yesu akabhajendili bhabhulwa bhaki koni akabya ajenda panani ja machi. ");
INSERT INTO mpa_vpl VALUES ("MT14_26","070_14_26","MAT","14","26","26","Bhabhulwa bhaki pabhakumbwene akajenda panani ja machi, bhakabhi na choghoi namaa. Bhakapwaghike, “Nde lihoka!” Bhakajamalili kwa choghohi. ");
INSERT INTO mpa_vpl VALUES ("MT14_27","070_14_27","MAT","14","27","27","Nambu palapala Yesu akabhapwaghi, “Mlipekya mtima! Nde nepane, ngamwijoghopa.” ");
INSERT INTO mpa_vpl VALUES ("MT14_28","070_14_28","MAT","14","28","28","Petulu akamuyangiki, “Bambo, ngati nde wehapa, umbwaghila nhika kwaku nakabya nyenda panani ja machi.” ");
INSERT INTO mpa_vpl VALUES ("MT14_29","070_14_29","MAT","14","29","29","Yesu akumpwaghile, “Hikaje.” Henu Petulu akapitiki mu ngalawa jela, na kujenda panani ja machi na kunjendela Yesu. ");
INSERT INTO mpa_vpl VALUES ("MT14_30","070_14_30","MAT","14","30","30","Nambu Petulu paakauweni mpongu ukale, akajowipi, na akatumbwi kujibhila, koni akajamalya, “Bambo, ungengalyaye!” ");
INSERT INTO mpa_vpl VALUES ("MT14_31","070_14_31","MAT","14","31","31","Palapala Yesu akahatambwili chiwoku chaki, akankamwile, na kumpwaghila, “Wenga weubhi na uhobalelu uchoku! Bho, maghambu kiki ukabhi na choghoi?” ");
INSERT INTO mpa_vpl VALUES ("MT14_32","070_14_32","MAT","14","32","32","Panihapa bhokapi bhabheli bhakajingi mu ngalawa jela, na mpongu ukatumbili chinunu. ");
INSERT INTO mpa_vpl VALUES ("MT14_33","070_14_33","MAT","14","33","33","Henu bhabhulwa bhabhabhi mu ngalawa jela bhakunjojabhi Yesu, bhakapwaghaje, “Chakaka, wehapa nde Mwana waka Chapanga!” ");
INSERT INTO mpa_vpl VALUES ("MT14_34","070_14_34","MAT","14","34","34","Pabhakajomwi kulomboka nhwanga, bhakahikiki upambala wa ku inchi ja ku Genesaleti. ");
INSERT INTO mpa_vpl VALUES ("MT14_35","070_14_35","MAT","14","35","35","Bhandu bha pandu panipala pabhakamanyiki kubha nde Yesu, bhakatumiki ubholu pandu pokapi pa pambipi. Na bhandu bhakandetili Yesu bhatamwa bhokapi. ");
INSERT INTO mpa_vpl VALUES ("MT14_36","070_14_36","MAT","14","36","36","Bhakundobhiki abhajetakyaje bhatamwa bhakamula pena nkungilu wa ingobhu jaki. Na bhokapi bhabhakankamwili, bhakalamike. ");
INSERT INTO mpa_vpl VALUES ("MT15_1","070_15_1","MAT","15","1","1","Bhela bhakumu wa bhabhola bha Shelia na Mafalisayo kuhuma ku Yelusalemu bhakahikiki kwaka Yesu, na kundalukila, ");
INSERT INTO mpa_vpl VALUES ("MT15_2","070_15_2","MAT","15","2","2","“Bho, mbona bhabhulwa bhaku ngachebhajengalela mabholu ghatujopalile kuhuma kwa akahokolu bhitu? Maghambu bhombi ngachebhachamba machi mawoku ghabhu ngati mokupalakila mangane ja kula!” ");
INSERT INTO mpa_vpl VALUES ("MT15_3","070_15_3","MAT","15","3","3","Yesu akabhayangiki, “Bho, mbona mwehapa ngachemkamu amuli yaka Chapanga kwa ndandi ja mitetu jinu mabhene? ");
INSERT INTO mpa_vpl VALUES ("MT15_4","070_15_4","MAT","15","4","4","Kwa ndandi Chapanga akapwaghiki, ‘Watopila atati waku na mabhu waku’ na ‘Jokapi joandobhe masolu atati waki au mabhu waki, impalika akomakikaje.’ ");
INSERT INTO mpa_vpl VALUES ("MT15_5","070_15_5","MAT","15","5","5","Nambu mwehapa mpwagha kubha mundu anaabhi na chindu cheaweza kubhajangati atati waki au mabhu waki, ‘Nambu akampwaghila kubha chindu achechi nimboki Chapanga,’ ");
INSERT INTO mpa_vpl VALUES ("MT15_6","070_15_6","MAT","15","6","6","bhela ngacheapalika kabheti kunjangati atati waki. Anana nde monyakila Lilobhi laka Chapanga na kujengalela mitetu jinu. ");
INSERT INTO mpa_vpl VALUES ("MT15_7","070_15_7","MAT","15","7","7","Mwehapa mabhandu mwemulibhona kubha wambone! Mlota Isaya akapwaghiki wichu panani jinu paakalotiki malobhi hagha, ");
INSERT INTO mpa_vpl VALUES ("MT15_8","070_15_8","MAT","15","8","8","‘Bhandu abhabha bhandopela kwa malobhi matopu, nambu mitima jabhu jibhi kutali na nenga. ");
INSERT INTO mpa_vpl VALUES ("MT15_9","070_15_9","MAT","15","9","9","Kunyojabhela kwabhu nde kwa waka, kwa ndandi bhabhola malaghalakilu gha bhandu.’ ” ");
INSERT INTO mpa_vpl VALUES ("MT15_10","070_15_10","MAT","15","10","10","Yesu akalilohiki lipogha la bhandu lela, na kubhapwaghila, “Njowanyaje wichu, na mmanyaje. ");
INSERT INTO mpa_vpl VALUES ("MT15_11","070_15_11","MAT","15","11","11","Chindu chechuntenda mundu kubha muhakau nga chela chechunjingi mundomu waki, nambu nde chela chechumpita mundu mundomu waki.” ");
INSERT INTO mpa_vpl VALUES ("MT15_12","070_15_12","MAT","15","12","12","Panihapa bhabhulwa bhaki bhakahikiki, na kumpwaghila, “Bho, umanyi kubha Mafalisayo bhakahakali namaa kwa malobhi ghala ghaukapwaghike?” ");
INSERT INTO mpa_vpl VALUES ("MT15_13","070_15_13","MAT","15","13","13","Yesu akabhayangike, “Kila nkongu wangakupandakika na Atati wangu wa kunani kumahunde, anautupulikaje. ");
INSERT INTO mpa_vpl VALUES ("MT15_14","070_15_14","MAT","15","14","14","Mwalekaje, bhanihabha nde akangalola, bhabhalongoha akangalola bhajabhu. Na ngati ngalola andongoha ngalola njaki, bhokapi bhabheli anabhajibhala mulibhomba.” ");
INSERT INTO mpa_vpl VALUES ("MT15_15","070_15_15","MAT","15","15","15","Petulu akapwaghiki, “Utupwaghilaye ndandi ja ulenganesu ghone.” ");
INSERT INTO mpa_vpl VALUES ("MT15_16","070_15_16","MAT","15","16","16","Yesu akabhalalukile, “Bho, hata na mwehapa le mwakona ngachemumanyi ghangane? ");
INSERT INTO mpa_vpl VALUES ("MT15_17","070_15_17","MAT","15","17","17","Bho, ngachemmanyi kubha kila chechunjingi mundu mundomu waki, chipetela mulutumbu, na kupihakika kunja kulikelo? ");
INSERT INTO mpa_vpl VALUES ("MT15_18","070_15_18","MAT","15","18","18","Nambu chechipita mundomu waka mundu chipita kuhuma muntima, na chenihechi nde chechuntenda mundu kubha muhakau. ");
INSERT INTO mpa_vpl VALUES ("MT15_19","070_15_19","MAT","15","19","19","Kwa ndandi mkati ja mtima waka mundu ghapita maholalelu mahakau, maholalelu gha kukoma, ugone na ukemi, wihi na ulandilu wa upuhi, na matondu. ");
INSERT INTO mpa_vpl VALUES ("MT15_20","070_15_20","MAT","15","20","20","Ghanihagha nde ghaghuntenda mundu ngaijetakalewa palongi jaka Chapanga, nambu kula panga kuchamba machi mabhoku ngachekuntenda mundu kubha muhakau.” ");
INSERT INTO mpa_vpl VALUES ("MT15_21","070_15_21","MAT","15","21","21","Yesu akabhokiki pandu pala na kujenda ku inchi ja ku Tilo na ku Sidoni. ");
INSERT INTO mpa_vpl VALUES ("MT15_22","070_15_22","MAT","15","22","22","Mbomba jumu Mkanaani joatamika pandu panihapa akahikiki kwaka Yesu, na kujamalila, “Bambo! Mwana waka Daude, umonila chiha, kamwali wangu ang'ahakika na lijobhi.” ");
INSERT INTO mpa_vpl VALUES ("MT15_23","070_15_23","MAT","15","23","23","Nambu Yesu ngacheakamuyangiki lilobhi lokapi. Bhela bhabhulwa bhaki bhakanjendili na kundobha, bhakapwaghaje, “Umpwaghila ajendaje, maghambu atujengalela, na ajendalela kutulapuli ngomela.” ");
INSERT INTO mpa_vpl VALUES ("MT15_24","070_15_24","MAT","15","24","24","Yesu akayangiki, “Ndumakiki pena kwa bhandu bha ku Izilaeli bhabhabhi ngati mambeleli ghaghahobhike.” ");
INSERT INTO mpa_vpl VALUES ("MT15_25","070_15_25","MAT","15","25","25","Nambu mbomba jola akahikiki, akachikimi polongi jaka Yesu, na kupwagha, “Bambo, unyangatyaje!” ");
INSERT INTO mpa_vpl VALUES ("MT15_26","070_15_26","MAT","15","26","26","Yesu akamuyangiki, “Nga wichu kutola chilebhi cha bhana na kulekalela nakawa.” ");
INSERT INTO mpa_vpl VALUES ("MT15_27","070_15_27","MAT","15","27","27","Mbomba jola akayangiki, “Ena, Bambo, upwaghiki chakaka, nambu hata nakawa ikula mahighalilu ghaghahabhuka kuhuma pameza ya akabambo wabhu.” ");
INSERT INTO mpa_vpl VALUES ("MT15_28","070_15_28","MAT","15","28","28","Panihapa Yesu akayangiki, “Mabhu, uhobhalelu waku nde kukolongwa! Kubya kwaku ngati moulobhile.” Kutumbu chikahi chelachela mwali waki akalamike. ");
INSERT INTO mpa_vpl VALUES ("MT15_29","070_15_29","MAT","15","29","29","Yesu akabhokiki pandu pala akapetiki mumaheku ja nhwanga Galilaya. Akakweliki pa chitombi na kutama pahi. ");
INSERT INTO mpa_vpl VALUES ("MT15_30","070_15_30","MAT","15","30","30","Lipogha likolongwa la bhandu lakunjendile, bhakumpelakili ilema, na akangalola, na iwete, na akangajowa, na bhangi bhamahele bhabhakabhi bhatamwa, bhakabhabhekiki pambipi na magholu ghaki, najombi Yesu akabhalamihe. ");
INSERT INTO mpa_vpl VALUES ("MT15_31","070_15_31","MAT","15","31","31","Lipogha la bhandu lela bhakakangichi pabhakaweni akangapwagha, bhakapwaghaje, na ilema bhakalamaje, na bhabhatengwiki bhakajendaje, na iwete bhakalamaje, na akangalola bhakalolaje, na bhakundumbali Chapanga wa Izilaeli. ");
INSERT INTO mpa_vpl VALUES ("MT15_32","070_15_32","MAT","15","32","32","Yesu akabhalohiki bhabhulwa bhaki na kubhapwaghila, “Nabhonela chiha bhandu abhabha, maghambu bhabhi na nepane kwa machobha ghatatu, na sajenu ngachebhabhi na chilebhi. Ngachembala nabhatabhuka koni bhakabya na injala ngabhihika kung'anduka mwindela.” ");
INSERT INTO mpa_vpl VALUES ("MT15_33","070_15_33","MAT","15","33","33","Bhabhulwa bhaki bhakumpwaghile, “Pambane tubhi pachingwenji, bho, anatupata kwaku chilebhi cha kubhajaghanila bhandu bhokapi abhabha?” ");
INSERT INTO mpa_vpl VALUES ("MT15_34","070_15_34","MAT","15","34","34","Yesu akabhalalukile, “Bho, mbi na mabumunda ghalenga?” Na bhombi bhakamuyangiki, “Tubhi na mabumunda saba, na tuhomba tuchokope.” ");
INSERT INTO mpa_vpl VALUES ("MT15_35","070_15_35","MAT","15","35","35","Yesu akabhapwaghi bhandu bhatama pahi. ");
INSERT INTO mpa_vpl VALUES ("MT15_36","070_15_36","MAT","15","36","36","Panihapa akatoliki mabumunda saba ghala na homba yela, akanchengwi Chapanga, na akahekiki, na kubhapekeha bhabhulwa bhaki, na bhabhulwa bhaki bhakabhapeki bhandu. ");
INSERT INTO mpa_vpl VALUES ("MT15_37","070_15_37","MAT","15","37","37","Bhokapi bhakakuliki na kutupila. Panihapa bhabhulwa bhakabhongini hipandi yeyakahighalile, bhakatwelakela hitonga saba. ");
INSERT INTO mpa_vpl VALUES ("MT15_38","070_15_38","MAT","15","38","38","Bhandu bhabhakakuliki chilebhi chela bhakabhi akanalomi elufu ncheche, panga kubhabhalanga akambomba na bhana. ");
INSERT INTO mpa_vpl VALUES ("MT15_39","070_15_39","MAT","15","39","39","Paakajomwi kubhatabhuka bhandu, Yesu akajingi mu ngalawa, na kujenda upambala wa ku Magadani. ");
INSERT INTO mpa_vpl VALUES ("MT16_1","070_16_1","MAT","16","1","1","Mafalisayo na Masadukayo bhakanjendi Yesu, nahuli kundenga, bhakandobhiki abhalangiha nginyulila kuhuma kunani kumahunde. ");
INSERT INTO mpa_vpl VALUES ("MT16_2","070_16_2","MAT","16","2","2","Nambu Yesu akabhayangiki, “Pakuhika pakamihi mwehapa mpwagha, ‘Kwa kubha kumahunde nde kukeli, lalenu anakubya kunyahe.’ ");
INSERT INTO mpa_vpl VALUES ("MT16_3","070_16_3","MAT","16","3","3","Lukela mpwagha, ‘Lalenu anakubya na iyula kwa ndandi kunani nde kukeli na mahundi ghajaghanile.’ Mwehapa mwaka ndumila kubheli, mumanyi kulinga pamihu ja kunani na kumanya ghaghipitalyaje, nambu bho, ngachemuweza kumanya nginyulila ja chikahi chenu? ");
INSERT INTO mpa_vpl VALUES ("MT16_4","070_16_4","MAT","16","4","4","Chibheleku kihakau na changa kummanya Chapanga, chipala nginyulila. Nambu ngachipati nginyulila jokapi jela, nambu nginyulila jaka Yona.” Yesu akabhalekiki, na kubhoka. ");
INSERT INTO mpa_vpl VALUES ("MT16_5","070_16_5","MAT","16","5","5","Bhabhulwa bhaka Yesu pabhakajomwi kulomboka mbaka kwihi ja kabheli ja nhwanga, bhakakombwiki kubha bhajewiki kutola mabumunda. ");
INSERT INTO mpa_vpl VALUES ("MT16_6","070_16_6","MAT","16","6","6","Yesu akabhapwaghile, “Mulilingalyaje na amila ja Mafalisayo na Masadukayo.” ");
INSERT INTO mpa_vpl VALUES ("MT16_7","070_16_7","MAT","16","7","7","Bhakalochini bheni kwa bheni, bhakapwaghaje, “Apwagha bhenibhela kwa ndandi ngachetutotwi mabumunda.” ");
INSERT INTO mpa_vpl VALUES ("MT16_8","070_16_8","MAT","16","8","8","Yesu akamanyi maholalelu ghabhu, akabhapwaghile, “Mwenga mabhandu mwembi na uhobhalelu uchoku! Bho, maghambu kiki mlochana kwa ndandi ngachembi na mabumunda? ");
INSERT INTO mpa_vpl VALUES ("MT16_9","070_16_9","MAT","16","9","9","Bho, nkona pena ngachemmanye? Bho, ngachemkomboka mabumunda nhwanu ghala ghanakabhalehiki bhandu elufu nhwanu? Bho, mkatwelakili itonga hilenga ya mahighalilu? ");
INSERT INTO mpa_vpl VALUES ("MT16_10","070_16_10","MAT","16","10","10","Bho, bhelabhela ngachenkomboka mabumunda saba ghala ghanakabhalehiki bhandu elufu nchechi? Bho, mkabhongini hitonga hilenga ya mahighalilu? ");
INSERT INTO mpa_vpl VALUES ("MT16_11","070_16_11","MAT","16","11","11","Bho, kubhi bholi mlepale kumanya kubha ngachenakabhi nongalela malobhi gha mabumunda? Nambu mulilingalya na amila ja Mafalisayo na Masadukayo!” ");
INSERT INTO mpa_vpl VALUES ("MT16_12","070_16_12","MAT","16","12","12","Panihapa bhabhulwa bhakamanyi kubha Yesu ngachealongalya panane ja amila ja kulenganake mabumunda, nambu bhalilingalya na mabholu gha Mafalisayo na Masadukayo. ");
INSERT INTO mpa_vpl VALUES ("MT16_13","070_16_13","MAT","16","13","13","Yesu paakahikiki ku muchi wa ku Kaisalia Filipi, akabhalaluki bhabhulwa bhaki, “Bho, bhandu bhapwagha kubha Mwana waka Mundu nde nane?” ");
INSERT INTO mpa_vpl VALUES ("MT16_14","070_16_14","MAT","16","14","14","Bhakamuyangiki, “Bhakumu bhapwagha kubha nde Yohana Mbatizaji, bhangi bhapwagha nde Eliya, na bhangi bhapwagha kubha nde Yelemia au jumu wabhu wa bhalota baka Chapanga.” ");
INSERT INTO mpa_vpl VALUES ("MT16_15","070_16_15","MAT","16","15","15","Akabhalalukile, “Na mwehapa, bho, mpwagha kubha nepani nde nane?” ");
INSERT INTO mpa_vpl VALUES ("MT16_16","070_16_16","MAT","16","16","16","Simoni Petulu akamuyangiki, “Wehapa nde Kristo, Mwana waka Chapanga joabhi mwome.” ");
INSERT INTO mpa_vpl VALUES ("MT16_17","070_16_17","MAT","16","17","17","Yesu akampwaghile, “Upengaliki, Simoni mwana waka Baliyona, maghambu nga mundu jokapi joakuhyekulile leniheli, nambu nde Atati wangu joabhi kunani kumahunde. ");
INSERT INTO mpa_vpl VALUES ("MT16_18","070_16_18","MAT","16","18","18","Nanenga nukupwaghila, wehapa nde Petulu, na panani ja lindalaghu lendenu, ananjenga likanisa langu, wala makili gha kuwawa ngaghawezi kulishinda. ");
INSERT INTO mpa_vpl VALUES ("MT16_19","070_16_19","MAT","16","19","19","Ananukupekya funguo ya Ukolongwa wa kunani kumahunde, na lokapi leanaulikongaje pundema, analibya likongakiki kunani kumahunde, na lokapi leanaulibhopulaje pundema, analibya libhopuliwi kunani kumahunde.” ");
INSERT INTO mpa_vpl VALUES ("MT16_20","070_16_20","MAT","16","20","20","Panihapa Yesu akabhakanakili ngamaa bhabhulwa bhaki ngabhampwaghi mundu jokapi kubha jombi nde Kristo. ");
INSERT INTO mpa_vpl VALUES ("MT16_21","070_16_21","MAT","16","21","21","Kutumbu chikahi chenihechi Yesu akatumbwi kubhalandila bhabhulwa bhaki hotuhotu, “Imbalika kujenda ku Yelusalemu, na kupata mang'ahiku ghamaheli kuhuma kwa bhazee, na bhapenganyambiku bhakolongwa, na bhabhola bha Shelia, na konihoku anangomakikaje na lichobha la katatu niyokaje.” ");
INSERT INTO mpa_vpl VALUES ("MT16_22","070_16_22","MAT","16","22","22","Petulu akandohiki Yesu punkeghi na kutumbu kundakalila, akapwagha, “Ngawipwagha bhenibhela Bambo! Lijambu leniheli ngalikupati ng'o!” ");
INSERT INTO mpa_vpl VALUES ("MT16_23","070_16_23","MAT","16","23","23","Nambu Yesu akang'anambwiki na kumpwaghi Petulu, “Bhoka palongi jangu, Shetani! Wehapa nde kihibhalakilu kwangu. Kwa ndandi maholalelu ghaku nga ghaka Chapanga, nambu gha bhandu.” ");
INSERT INTO mpa_vpl VALUES ("MT16_24","070_16_24","MAT","16","24","24","Panihapa Yesu akabhapwaghi bhabhulwa bhaki, “Mundu jokapi anaapala kunyengalela, impalika alikana mwene, na autolaye msalaba waki, na anyengalyaje. ");
INSERT INTO mpa_vpl VALUES ("MT16_25","070_16_25","MAT","16","25","25","Kwa ndandi mundu anaapala kukengalela womi waki, anaauhobhihaje, nambu mundu joanaauhobhiha womi waki kwa ndandi jangu, anaaupata kabhete. ");
INSERT INTO mpa_vpl VALUES ("MT16_26","070_16_26","MAT","16","26","26","Bho, mundu anapata kiki ngati anaaupatiki ndema wokapi na kuhobheha womi wake? Au mundu anabhoha chindu bhole chibya pandu pa womi wake? ");
INSERT INTO mpa_vpl VALUES ("MT16_27","070_16_27","MAT","16","27","27","Kwa ndandi Mwana waka Mundu anahikaje mu ulumbalilu wa Atati waki papamu na bhatumika bhaki bha kunani kwaka Chapanga, na panihapa nde anaandepa kila mundu kulengana na matendu ghaki. ");
INSERT INTO mpa_vpl VALUES ("MT16_28","070_16_28","MAT","16","28","28","Numpwaghi chakaka, bhabhi bhakumu bhinu pambane ngabhapotele mangane ja kumbona Mwana waka Mundu akahikaje mu Ukolongwa waki.” ");
INSERT INTO mpa_vpl VALUES ("MT17_1","070_17_1","MAT","17","1","1","Paghapetiki machobha sita, Yesu akabhatoliki Petulu, Yakobo na Yohana ndongu waki, akapiti nabhu kanjika jabhu panani ja chitombi chilachu. ");
INSERT INTO mpa_vpl VALUES ("MT17_2","070_17_2","MAT","17","2","2","Konihoku, Yesu akang'anambwiki ubhonikanu waki palongi jabhu, pamihu jaki pakang'anyiki ngati lyobha, na ingobhu jaki jakabhi jihuhu ngati unang'anu. ");
INSERT INTO mpa_vpl VALUES ("MT17_3","070_17_3","MAT","17","3","3","Palapala Musa na Eliya bhakapitalili, na kulongela na Yesu. ");
INSERT INTO mpa_vpl VALUES ("MT17_4","070_17_4","MAT","17","4","4","Panihapa Petulu akumpwaghi Yesu, “Bambo, nde wichu tepani kubha pambane! Anaupala anachenga indamba itatu, chimu chaku wehapa, chengi chaka Musa, na chimu chaka Eliya.” ");
INSERT INTO mpa_vpl VALUES ("MT17_5","070_17_5","MAT","17","5","5","Petulu paakabhi ajendale kupwagha, palapala lihundi leling'anya lakabhayekalile, na sauti jakapitalile kuhuma mulihundi lela, jakapwagha, “Hajoju nde Mwana wangu mpalu, nyambakiki naku, munjowanya jombe!” ");
INSERT INTO mpa_vpl VALUES ("MT17_6","070_17_6","MAT","17","6","6","Bhabhulwa bhala pabhakajowini sauti jela, bhakajowipi namaa, bhakahawiki ukutama mbaka pahi. ");
INSERT INTO mpa_vpl VALUES ("MT17_7","070_17_7","MAT","17","7","7","Yesu akahikiki, akabhapapihi, na kupwagha, “Njemanyaje, ngamwijoghopa!” ");
INSERT INTO mpa_vpl VALUES ("MT17_8","070_17_8","MAT","17","8","8","Pabhakajinwihi mihu ghabhu ngachebhakumbweni mundu, nambu Yesu kanjika jake. ");
INSERT INTO mpa_vpl VALUES ("MT17_9","070_17_9","MAT","17","9","9","Pabhakabhi bhahelela pachitombi, Yesu akabhakanakili, “Ngamwampwaghi mundu mambu ghamughawene, mbaka Mwana waka Mundu paiyokaje kuhuma kwa bhakuwa.” ");
INSERT INTO mpa_vpl VALUES ("MT17_10","070_17_10","MAT","17","10","10","Bhabhulwa bhakandaluki Yesu, “Bho, mbona bhabhola bha Shelia bhapwagha ipalika hoti Eliya ahikaje?” ");
INSERT INTO mpa_vpl VALUES ("MT17_11","070_17_11","MAT","17","11","11","Yesu akabhayangiki, “Chakaka, Eliya anahika hoti, na kulenganakela mambu ghokapi wichu. ");
INSERT INTO mpa_vpl VALUES ("MT17_12","070_17_12","MAT","17","12","12","Nambu numpwaghila, Eliya ajomwi kuhika, na bhombi ngachebhakammanyi, nambu bhandu bhakamuhengili ntundu mobhakapalile. Bhela Mwana waka Mundu anaang'ahakika bhelabhela mu mawoku ghabhu.” ");
INSERT INTO mpa_vpl VALUES ("MT17_13","070_17_13","MAT","17","13","13","Panihapa bhabhulwa bhakamanyiki kubha akabhi abhapwaghi mambu ghaka Yohana Mbatizaji. ");
INSERT INTO mpa_vpl VALUES ("MT17_14","070_17_14","MAT","17","14","14","Pabhakaliheghalili kabheti lipogha la bhandu lela, mundu jumu akunjendi Yesu, na kunchikamila palongi jaki, ");
INSERT INTO mpa_vpl VALUES ("MT17_15","070_17_15","MAT","17","15","15","akapwaghaje, “Bambo, umbonila chiha mwana wangu kwa ndandi abhi na chitamu cha kuhinduka, kabheti ang'ahika namaa, mala pamaheli ahabhuka pamotu na mumachi. ");
INSERT INTO mpa_vpl VALUES ("MT17_16","070_17_16","MAT","17","16","16","Nakundetiki kwa bhabhulwa bhaku, nambu ngachebhakaweziki kundamiha.” ");
INSERT INTO mpa_vpl VALUES ("MT17_17","070_17_17","MAT","17","17","17","Yesu akabhapwaghi bhabhulwa bhaki, “Mwenga chibheleku changakubha na uhobhalelu, na chechihobhike! Bho, anandama na mwehapa mbaka lile? Undeta pambane nkombu hoju.” ");
INSERT INTO mpa_vpl VALUES ("MT17_18","070_17_18","MAT","17","18","18","Yesu akalilakali lijobhi lela, na lombi lakumpitiki, na kutumbu chikahi chelachela nkombu jola akalamike. ");
INSERT INTO mpa_vpl VALUES ("MT17_19","070_17_19","MAT","17","19","19","Henu bhabhulwa bhakanjendi Yesu bhakabya kanjika jabhu, na kundalukila, “Bho, maghambu kiki tepani ngachetukaweziki kuliboha lijobhi lela?” ");
INSERT INTO mpa_vpl VALUES ("MT17_20","070_17_20","MAT","17","20","20","Yesu akabhayangiki, “Kwa ndandi ja uhobhalelu winu uchoku. Numpwaghi chakaka, anambi na uhobhalelu ngati imbeju njoku jejilowakeka haladali, anamuweza kuchipwaghi chitombi, ‘Ubhokaje pambane ujenda pala,’ na chombi anachibhokaje, na njeta chindu chokapi chechibya ngakuwezikana kwinu. ");
INSERT INTO mpa_vpl VALUES ("MT17_21","070_17_21","MAT","17","21","21","Nambu lijobhi la ntundu aghoghu ngaliwezi kubhohakeka nambu kwa malobhu na kukonga.” ");
INSERT INTO mpa_vpl VALUES ("MT17_22","070_17_22","MAT","17","22","22","Bhabhulwa bhaka Yesu pabhakabhi papamu ku Galilaya, Yesu akabhapwaghile, “Mwana waka Mundu anaabhohakikaje mu mawoku gha bhandu, ");
INSERT INTO mpa_vpl VALUES ("MT17_23","070_17_23","MAT","17","23","23","anabhunkomaje, nambu lichobha la katatu anaayoka kabhete.” Bhabhulwa bhaki jakabhabhiniki namaa mitima jabhu. ");
INSERT INTO mpa_vpl VALUES ("MT17_24","070_17_24","MAT","17","24","24","Yesu na bhabhulwa bhaki pabhakahikiki ku Kapelenaumu, bhajopa kode bha Nyumba jaka Chapanga bhakanjendi Petulu na kundalukila, “Bho, mbola winu le alepa kode ja Nyumba jaka Chapanga?” ");
INSERT INTO mpa_vpl VALUES ("MT17_25","070_17_25","MAT","17","25","25","Petulu akabhayangiki, “Ena, alepa.” Petulu paakajingi mu nyumba, mangane ja kupwagha lilobhi, Yesu akandalukile, “Simoni, wehapa ubhona bhole? Bhakolongwa bha pundema bhabhongana ushulu au kode kuhuma kwa akanane? Bho, kuhuma kwa bhana bhabhu au kwa bhaghene?” ");
INSERT INTO mpa_vpl VALUES ("MT17_26","070_17_26","MAT","17","26","26","Petulu akamuyangiki, “Kuhuma kwa bhandu bhaghene.” Yesu akampwaghile, “Bhela, bhana inchi jabhu bhalekakiwi. ");
INSERT INTO mpa_vpl VALUES ("MT17_27","070_17_27","MAT","17","27","27","Nambu nahuli ngatubhang'aha, ujendaje kunhwanga ukajembalakya ndowana, ukatolaje homba ja kutumbula kutangila, hoghula mundomu waki, na mkati ja ndomu hoghu, anaujihimanya mbija ja kujaghanila ja kode. Jitolaje ukabhapekya jangu nepanu na jaku wehapa.” ");
INSERT INTO mpa_vpl VALUES ("MT18_1","070_18_1","MAT","18","1","1","Chikahi hechi bhabhulwa bhakanjendi Yesu, na kundalukila, “Bho, nde nane joabhi nkolongwa nakanopi mu Ukolongwa wa kunani kumahunde?” ");
INSERT INTO mpa_vpl VALUES ("MT18_2","070_18_2","MAT","18","2","2","Yesu akandohiki mwana jumu nchoku na kunjemeka pachilanda jabhu. ");
INSERT INTO mpa_vpl VALUES ("MT18_3","070_18_3","MAT","18","3","3","Yesu akapwaghike, “Numpwaghi chakaka, nangakung'anambuka, na kubha ngati bhana, ngamwijingili mu Ukolongwa wa kunani kumahunde ng'o. ");
INSERT INTO mpa_vpl VALUES ("MT18_4","070_18_4","MAT","18","4","4","Mundu jokapi joaliheleha ngati mwana ajoju, jonihoju nde joanaabya nkolongwa mu Ukolongwa wa kunani kumahunde. ");
INSERT INTO mpa_vpl VALUES ("MT18_5","070_18_5","MAT","18","5","5","Mundu jokapi joanjopalela mwana jumu ngati ajoju kwa lihina langu, anyopalela nepane. ");
INSERT INTO mpa_vpl VALUES ("MT18_6","070_18_6","MAT","18","6","6","“Nambu mundu jokapi joanaantenda jumu wa bhachoku abhabha bhabhanhobhalela nepanu kuhenga mahoku, ikabya mbaka kwaka mundu hoju kukongakeka liganga likolongwa la kuyaghila, na kujwihakika kulochi ja nhwanga. ");
INSERT INTO mpa_vpl VALUES ("MT18_7","070_18_7","MAT","18","7","7","Anamuchibhonaje bhandu bha pundema, kwa ndandi kubhi na hindu yamaheli yeyatenda bhandu kutenda mahoku, mambu ghanihagha ghapalika ghapitilaje! Nambu anaachibhona mundu jola joaghaleta. ");
INSERT INTO mpa_vpl VALUES ("MT18_8","070_18_8","MAT","18","8","8","“Ngati chiwoku chaku au chiwolu chaku anachikutehi kutenda mahoku, uhekataje na kulekela kutali na wehapa! Mbanga kwaku kujingila mu womi wa mileli panga chiwoku au chiwolu, kuliku kulekaleka mu moto wa mileli ukabya na mabhoku ghabheli na magholu ghaku ghabheli. ");
INSERT INTO mpa_vpl VALUES ("MT18_9","070_18_9","MAT","18","9","9","Lihu laku analikutehi kutenda mahoku, litupulaje na kulilekela kutali na wehapa! Mbanga kwaku kujingila mu womi wa mileli ukabya na lihu limu, kuliku kulekaleka mu Jehanamu ja moto ukabya na mihu ghaku ghokapi ghabheli. ");
INSERT INTO mpa_vpl VALUES ("MT18_10","070_18_10","MAT","18","10","10","“Mulilingalyaje ngamwanzalau jumu wa bhachoku abhabha. Numpwaghila, bhatumika bhabhu bha kunani kwaka Chapanga bhabhi machobha ghokapi palongi ja Atati wangu joabhi kunani kumahunde. ");
INSERT INTO mpa_vpl VALUES ("MT18_11","070_18_11","MAT","18","11","11","Maghambu Mwana waka Mundu ahikiki kubhakengalela bhala bhabhahobhike. ");
INSERT INTO mpa_vpl VALUES ("MT18_12","070_18_12","MAT","18","12","12","“Bho, mbona bhole? Mundu anabhi na mambeleli mia moja, na limu analihobhiki, bho, atenda kike? Aghaleka tisaini na tisa ghala kuchitombi, na kujenda kulilonda lelihobhiki lela. ");
INSERT INTO mpa_vpl VALUES ("MT18_13","070_18_13","MAT","18","13","13","Anaalipatiki, numpwaghi chakaka, anaahekalya nakanopi kwa ndandi ja limbeleli limu kupeta ghala tisaini na tisa ghaghahighalile. ");
INSERT INTO mpa_vpl VALUES ("MT18_14","070_18_14","MAT","18","14","14","Bhelabhela Atati winu wa kunani kumahunde, ngacheapala hata jumu wa bhachoku abhabha ahobhaje. ");
INSERT INTO mpa_vpl VALUES ("MT18_15","070_18_15","MAT","18","15","15","“Ngati ndongu waku anaakuhokihi, ujendaje kwaki ukumpwaghila lihoku laki koni mukabya mwabheli pena. Anaakujowanili, anaubya umpatiki kabheti ndongu waku. ");
INSERT INTO mpa_vpl VALUES ("MT18_16","070_18_16","MAT","18","16","16","Nambu ngati anaakaniki kukujowanela, ujendaje kwaki na mundu jongi jumu au bhabheli nahuli kwa ulandilu wa bhalandilu bhabheli au bhatatu kila litatizo lijomulikaje, ngati moghapwaghi Malembu gaka Chapanga. ");
INSERT INTO mpa_vpl VALUES ("MT18_17","070_18_17","MAT","18","17","17","Anaakaniki kubhajowanela bhandu bhanihabha, ulipwaghila likanisa. Ngati anaakaniki kubhajowanela bhandu habha, na abya kwaku ngati mundu wangakummanya Chapanga au njopa kode. ");
INSERT INTO mpa_vpl VALUES ("MT18_18","070_18_18","MAT","18","18","18","“Numpwaghi chakaka, ghokapi ghamwikongaje pani pundema anaghabya ghakongakiki kunani kumahunde, na ghokapi ghamwibhopulaje pani pundema anaghabya ghabhopuliwi kunani kumahunde. ");
INSERT INTO mpa_vpl VALUES ("MT18_19","070_18_19","MAT","18","19","19","“Kabheti numpwaghi kubha, bhandu bhabheli pabhijongana pundema kubhokana na lijambu lokapi lebhilobhaje kwaka Chapanga, anabhatendiwaje na Atati wangu joabhi kunani kumahunde. ");
INSERT INTO mpa_vpl VALUES ("MT18_20","070_18_20","MAT","18","20","20","Maghambu pokapi pala pabhahimangana bhandu bhabheli au bhatatu kwa lihina langu, nepani mili panihapa pachilanda jabhu.” ");
INSERT INTO mpa_vpl VALUES ("MT18_21","070_18_21","MAT","18","21","21","Panihapa Petulu akanjendi Yesu na kundalukila, “Bambo, bho, ndongu wangu anaanihoki mala palenga nyendalya kundekakela? Bho, nundekakya mala saba?” ");
INSERT INTO mpa_vpl VALUES ("MT18_22","070_18_22","MAT","18","22","22","Yesu akamuyangiki, “Ngachembwagha mala saba pena, nambu saba mala sabini.” ");
INSERT INTO mpa_vpl VALUES ("MT18_23","070_18_23","MAT","18","23","23","Kwa ndandi Ukolongwa wa kunani kumahunde ulengini na nkolongwa jumu joapalika kutenda mabhalangiku gha bhatumika bhaki. ");
INSERT INTO mpa_vpl VALUES ("MT18_24","070_18_24","MAT","18","24","24","Paakatumbwi kulonda mabhalangiku ghaki, mundu jumu joakabhi andahi mbija mamilioni gha ghamaheli, bhakampeliki kwake. ");
INSERT INTO mpa_vpl VALUES ("MT18_25","070_18_25","MAT","18","25","25","Mtumika jola ngacheakabhi na chindu cha kulepa lideni lela, nkolongwa akalaghalaki kubha ahemaliwaje ngati mtumwa, jombi na nhwanu waki, na bhana bhaki, na hindu yokapi yeakabhi nayu, nahuli ipatikanaye mbija ya kulepa lideni lake. ");
INSERT INTO mpa_vpl VALUES ("MT18_26","070_18_26","MAT","18","26","26","Bhela, mtumika jola akachikimi palongi jaka nkolongwa jola, na kupwagha, “Pepakoku Bambo, nukulobha unhinakalyaje, ananukulepa lideni laku lokapi.” ");
INSERT INTO mpa_vpl VALUES ("MT18_27","070_18_27","MAT","18","27","27","Nkolongwa jola akamboni chiha, akandekakili lideni lela, na kundeka ajendaje. ");
INSERT INTO mpa_vpl VALUES ("MT18_28","070_18_28","MAT","18","28","28","“Nambu mtumika jola paakabhokiki, akahimangini na mtumika njaki joakabhi andahi mbija ichokope. Akankamwili, na kunhinya pahingu, akapwagha, ‘Unepaje lideni langu!’ ");
INSERT INTO mpa_vpl VALUES ("MT18_29","070_18_29","MAT","18","29","29","Mtumika njaki jola akanchikamili na kundobha, akapwagha, ‘Pepakoku, nukulobha unhinakalyaje, ananukulepa lideni laku lokapi!’ ");
INSERT INTO mpa_vpl VALUES ("MT18_30","070_18_30","MAT","18","30","30","Jombi akakaniki, nambu akampeliki muchifungo mbaka paanalepa lideni lela. ");
INSERT INTO mpa_vpl VALUES ("MT18_31","070_18_31","MAT","18","31","31","Bhatumika bhajaki pabhakaweni mambu ghanihagha, bhakayomiki namaa. Bhakapiti kumpwaghila nkolongwa mambu ghala ghaghapitalile. ");
INSERT INTO mpa_vpl VALUES ("MT18_32","070_18_32","MAT","18","32","32","Panihapa nkolongwa jola akandohiki mtumika jola, akampwaghile, ‘Wehapa nde mtumika muhakau namaa! Ukanobhiki, na nepani nikakulekakile lideni laku lokapi. ");
INSERT INTO mpa_vpl VALUES ("MT18_33","070_18_33","MAT","18","33","33","Bho, ngacheikapalakiki na wehapa kumbone chiha mtumika njaku ngati nepani monakakubhoni chiha wehapa?’ ");
INSERT INTO mpa_vpl VALUES ("MT18_34","070_18_34","MAT","18","34","34","Bhela, nkolongwa jola akayomiki namaa, akampeliki mtumika hoju muchifungo na kung'ahakika, mbaka paanajomula kulepa lideni laki lokapi.” ");
INSERT INTO mpa_vpl VALUES ("MT18_35","070_18_35","MAT","18","35","35","Yesu akajomulili kupwagha, “Anana nde Atati wangu wa kunani kumahunde moanaantendila mwehapa, ngati kila jumu winu ngacheandekakela ndongu waki kwa mtima waki wokapi.” ");
INSERT INTO mpa_vpl VALUES ("MT19_1","070_19_1","MAT","19","1","1","Yesu paakajomwi kupwagha malobhi ghanihagah, akabhokiki ku Galilaya, na akapiti ku inchi ja ku Yudea, kwihi ja Nkoka Yoludani. ");
INSERT INTO mpa_vpl VALUES ("MT19_2","070_19_2","MAT","19","2","2","Bhandu bhamaheli bhakanjengalili konihoku, na Yesu akabhalamihi hitamu yabhu. ");
INSERT INTO mpa_vpl VALUES ("MT19_3","070_19_3","MAT","19","3","3","Mafalisayo bhakumu bhakanjendi Yesu, bhakandalukili kwa kumpendakela, “Bho, wichu le nkambaku kumpekeha baluwa ja kundeka nhwanu waki kwa ndandi jokapi jela?” ");
INSERT INTO mpa_vpl VALUES ("MT19_4","070_19_4","MAT","19","4","4","Yesu akabhayangiki, “Bho, ngachemsomiki mu Malembu ghaka Chapanga kubha, Chapanga nde joambombiki mundu kutumbula pakutumbulila akuntendiki nkambaku na mbomba? ");
INSERT INTO mpa_vpl VALUES ("MT19_5","070_19_5","MAT","19","5","5","Chapanga apwagha, ‘Kwa ndandi jeniheji mwanalomi anaandeka atati waki na mabhu waki, na kulombana na nhwanu waki, na bhombi bhabheli habha anabhakubha hyegha jimu?’ ");
INSERT INTO mpa_vpl VALUES ("MT19_6","070_19_6","MAT","19","6","6","Henu bhanihabha nga bhabheli kabheti, nambu nde hyegha jimu. Henu, cheachilombanishi Chapanga, mundu ngaachilombola.” ");
INSERT INTO mpa_vpl VALUES ("MT19_7","070_19_7","MAT","19","7","7","Nambu Mafalisayo bhakandaluki Yesu, “Bho, maghambu kiki, Musa akatulaghalaki kubha mundu aweza kumpekeha nhwanu waki baluwa ja kulekana na kundeka?” ");
INSERT INTO mpa_vpl VALUES ("MT19_8","070_19_8","MAT","19","8","8","Yesu akabhayangiki, “Musa akampwaghili kubhaleka akahanu bhinu kwa ndandi ja kunonopa kwa mitima jinu kubholakeka. Nambu kutumbula kubhombakeka kwa ndema ngachekukabhi bhenibhela. ");
INSERT INTO mpa_vpl VALUES ("MT19_9","070_19_9","MAT","19","9","9","Henu, nepani numpwaghi mwehapa, mundu jokapi joandeka nhwanu waki, nanga kubha kwa ndandi ja ugone, na kuntoghola mbomba jongi, ahenga ugone, bhelabhela mundu joantoghola mbomba joapekiwi baluwa ja kulekana jola, najombi atenda ugone.” ");
INSERT INTO mpa_vpl VALUES ("MT19_10","070_19_10","MAT","19","10","10","Bhabhulwa bhaki bhakumpwaghile, “Ngati bhenibhela nde mokubheli mambu ghaka nkambaku na nhwanu waki, mbanga mundu kukotoka kutoghola.” ");
INSERT INTO mpa_vpl VALUES ("MT19_11","070_19_11","MAT","19","11","11","Yesu akabhayangiki, “Nga kila mundu joaweza kulijopalela lilobhi lenu lempwagha, nambu bhala pena Chapanga bhaahagwile. ");
INSERT INTO mpa_vpl VALUES ("MT19_12","070_19_12","MAT","19","12","12","Maghambu bhabhi bhandu bhangakuweza kutoghola kwa ndandi bhabhelakiki bhenibhela, na bhangi bhatendakiki ghanihagha na bhandu, na kabheti bhabhi bhangi ambabhu bhapaliki bheni ngabhitoghola kwa ndandi ja Ukolongwa wa kunani kumahunde. Joaweza kulijopalela lilobhi lenu na alijopalyaje.” ");
INSERT INTO mpa_vpl VALUES ("MT19_13","070_19_13","MAT","19","13","13","Bhandu bhakumu bhakandetili Yesu bhana nahuli abhabhekila mabhoku panani jabhu na abhalobhilaje. Nambu bhabhulwa bhaki bhakabhalakalile. ");
INSERT INTO mpa_vpl VALUES ("MT19_14","070_19_14","MAT","19","14","14","Yesu akabhapwaghile, “Mwaleka bhana bhahika kwangu, ngamwahibhalila, maghambu Ukolongwa wa kunane kumahunde nde wa bhandu bhabhabhi ngati bhana abhabha.” ");
INSERT INTO mpa_vpl VALUES ("MT19_15","070_19_15","MAT","19","15","15","Paakajomwili kubhabhekela mabhoku panani ja bhana bhanihabha nahuli kubhapengalela, Yesu akabhokiki pandu pala. ");
INSERT INTO mpa_vpl VALUES ("MT19_16","070_19_16","MAT","19","16","16","Mundu jumu akanhiki Yesu na kundalukila, “Mbola Wambone, bho, ndenda chindu bhole chambone nahuli niupataje womi wa mileli?” ");
INSERT INTO mpa_vpl VALUES ("MT19_17","070_19_17","MAT","19","17","17","Yesu akamuyangiki, “Bho, maghambu kiki unoha wambone?” “Kubhi na jumu pena joabhi wambone, yani Chapanga. Nambu ngati anaupala kujingila mu womi wa mileli, kamula amuli yaka Chapanga.” ");
INSERT INTO mpa_vpl VALUES ("MT19_18","070_19_18","MAT","19","18","18","Mundu jola akundalukile, “Bho, amuli bhole?” Yesu akamuyangiki, “Ngawikoma, ngawihenga ugone, ngawijibha, ngawilandila upuhi, ");
INSERT INTO mpa_vpl VALUES ("MT19_19","070_19_19","MAT","19","19","19","watopila atati waku na mabhu waku, na umpala njaku ngati moulipali wamwene.” ");
INSERT INTO mpa_vpl VALUES ("MT19_20","070_19_20","MAT","19","20","20","Nkombu jola akampwaghile, “Niikamwi amuli yeniheyi yokapi kutumbula uchoku wangu. Bho, ngepakiwi na chindu bhole kabheti?” ");
INSERT INTO mpa_vpl VALUES ("MT19_21","070_19_21","MAT","19","21","21","Yesu akampwaghile, “Ngati anaupala kubha mundu wambone chakaka, ujenda ukalombisa hindu yokapi yeubhi nayu, na mbija yeanaupataje ukabhapekya bhahochu, na wehapa anaubya ulibekili chikoku kunani kumahunde, na anaujomwili kutenda ghanihagha, uhika unyengalyaje.” ");
INSERT INTO mpa_vpl VALUES ("MT19_22","070_19_22","MAT","19","22","22","Nkombu jola paakajowini malobhi ghanihagha, akabhokiki kwa kung'ong'uteka, maghambu akabhi na hindu yamaheli namaa. ");
INSERT INTO mpa_vpl VALUES ("MT19_23","070_19_23","MAT","19","23","23","Panihapa Yesu akabhapwaghi bhabhulwa bhaki, “Numpwaghi chakaka, anakunonupa namaa kwaka mundu joabhi na hindu yamaheli kujingila mu Ukolongwa wa kunane kumahunde. ");
INSERT INTO mpa_vpl VALUES ("MT19_24","070_19_24","MAT","19","24","24","Numpwaghi kabeti kubha, kupepwiki nakanopi kwa chinyama chechilowakeka ngamia kupeta mu limboghi la sindano, kuliku kwaka mundu joabhi na hindu yamaheli kujingila mu Ukolongwa waka Chapanga.” ");
INSERT INTO mpa_vpl VALUES ("MT19_25","070_19_25","MAT","19","25","25","Bhabhulwa bhaka Yesu pabhakajowini ghanihagha bhakakangichi namaa, bhakandalukile, “Bho, nde nane henu joanaweza kukengaleka?” ");
INSERT INTO mpa_vpl VALUES ("MT19_26","070_19_26","MAT","19","26","26","Yesu akabhalingalili na kubhapwaghila, “Kwaka mundu lijambu lenu ngacheliwezikana, nambu kwaka Chapanga mambu ghokapi ghawezikana.” ");
INSERT INTO mpa_vpl VALUES ("MT19_27","070_19_27","MAT","19","27","27","Petulu akandalukile, “Lingalya! Tepani tuilekiki hindu yokapi na kukujengalela wehapa! Henu bho, na tepani anatupata kike?” ");
INSERT INTO mpa_vpl VALUES ("MT19_28","070_19_28","MAT","19","28","28","Yesu akabhayangiki, “Numpwaghi chakaka, Mwana waka Mundu paitamaje pa mpandu waki wa kikolongwa cha ulumbalilu mu Ndema Wahenu, mwehapa komi na bhebheli mwemnyengalile anamtamaje panani ja mipandu ja ukolongwa komi na jibheli, mkaghatemulaje makabila komi na ghabheli gha Izilaeli. ");
INSERT INTO mpa_vpl VALUES ("MT19_29","070_19_29","MAT","19","29","29","Kila mundu joajilekiki nyumba au ndongu au ndombu au atati au mabhu au bhana au mighonda kwa ndandi jangu nepani, anaajopalyaje mala mia, na kujopalela womi wa mileli. ");
INSERT INTO mpa_vpl VALUES ("MT19_30","070_19_30","MAT","19","30","30","Nambu bhamaheli bhabhabhii bhakutumbula, anabhabya bha kujomukela, na bhamaheli bhabhabhi bha kujomukela, anabhabya bha kutumbula. ");
INSERT INTO mpa_vpl VALUES ("MT20_1","070_20_1","MAT","20","1","1","“Ukolongwa wa kunani kumahunde ulengana na mundu joabhi na ngonda wa mizabibu joakabhokiki lukela pachibhombu kubhapeleka bhahengalihengu mungonda waki. ");
INSERT INTO mpa_vpl VALUES ("MT20_2","070_20_2","MAT","20","2","2","Akajongini nabhu kwa kubhalepa chipandi chimu cha madini gha feza kwa lichobha, na akabhapeliki kungonda wa mizabibu. ");
INSERT INTO mpa_vpl VALUES ("MT20_3","070_20_3","MAT","20","3","3","Pajahikiki saa tatu ja lukela, akabhokiki kabheti na akabhahimani bhandu bhangi bhajemiki paligulio bhanga na lihengu. ");
INSERT INTO mpa_vpl VALUES ("MT20_4","070_20_4","MAT","20","4","4","Akabhapwaghile, ‘Njendanyaje na mwenga mkahenga lihengu mungonda wangu wa mizabibu, na nepani ananundepa ngati mokupalakila.’ Na bhombi bhakapiti. ");
INSERT INTO mpa_vpl VALUES ("MT20_5","070_20_5","MAT","20","5","5","Pajahikiki saa sita ja muhi na saa tisa pakamihi, akabhokiki kabheti na kutenda bhelabhela. ");
INSERT INTO mpa_vpl VALUES ("MT20_6","070_20_6","MAT","20","6","6","Pajahikiki saa komi na moja pakamihi akabhokiki kabheti na akabhahimanili bhandu bhangi bhajemiki pandu paligulio pala. Akabhalalukile, ‘Bho, mbona njemiki pambane muhi jokapi panga na kuhenga lihengo?’ ");
INSERT INTO mpa_vpl VALUES ("MT20_7","070_20_7","MAT","20","7","7","Bhakamuyangiki, ‘Maghambu njeta mundu joatupeki lihengo.’ Akabhapwaghile, ‘Na mwehapa nanamu njendanyaje mkahenga lihengo mu ngonda wangu wa mizabibu.’ ");
INSERT INTO mpa_vpl VALUES ("MT20_8","070_20_8","MAT","20","8","8","“Pakwahikiki pakamihi, mweni ngonda jola akandohiki njemalela wa bhahengalihengo bhala, na kumpwaghila, ‘Ubhalohaje bhahengalihengo na ubhalepaye mbija yabhu, ukatumbula na bhakujomukela na kujomulela na bhakutumbula.’ ");
INSERT INTO mpa_vpl VALUES ("MT20_9","070_20_9","MAT","20","9","9","Pabhakahikiki bhala bha saa kumi na moja, kila jumu wabhu akapatiki chipandi chimu cha madini gha feza. ");
INSERT INTO mpa_vpl VALUES ("MT20_10","070_20_10","MAT","20","10","10","Bhala bhabhakatumbwi kuhenga lihengo pabhakahikiki, bhahambukya anaabhalepa nakanopi, nambu kila jumu wabhu akapatiki chipandi chimu cha madini gha feza. ");
INSERT INTO mpa_vpl VALUES ("MT20_11","070_20_11","MAT","20","11","11","Bhandu bhala bhakajopiki mbiya yabhu, na bhakatumbwi kung'ong'utakela mweni ngonda, ");
INSERT INTO mpa_vpl VALUES ("MT20_12","070_20_12","MAT","20","12","12","bhakapwaghaje, ‘Bhandu bha kujomukela abhabha bhahengiki lihengu kwa lisaa limu pena, nambu bho, maghambu kiki wehapa wapeki malepu kulengana na tepani tetuhengiki lihengu lelinonwipi na kujochakeka na lyobha muhi jokapi?’ ");
INSERT INTO mpa_vpl VALUES ("MT20_13","070_20_13","MAT","20","13","13","“Mweni ngonda jola akamuyangiki jumu waki, ‘Nkoche, ngachenukuponjiki chindo. Bho, ngachetukajongini kubha anauhenga lihengu kwa chipandi chimu cha madini gha feza? ");
INSERT INTO mpa_vpl VALUES ("MT20_14","070_20_14","MAT","20","14","14","Utola mbiya jaku ujendaje. Mbala kumpekeha wa kujomukela ajoju kulengana na wehapa. ");
INSERT INTO mpa_vpl VALUES ("MT20_15","070_20_15","MAT","20","15","15","Bho, ngacheniweza kuhenga chenichipala na hindu yangu namwete? Au bho, umonela wihu kwa ndandi nepani wambone?’ ” ");
INSERT INTO mpa_vpl VALUES ("MT20_16","070_20_16","MAT","20","16","16","Yesu akajomuli kwa kupwagha, “Bhelabhela wa kujomukela anaakubha wa kutumbula, na wa kutumbula, anaakubha wa kujomukela.” ");
INSERT INTO mpa_vpl VALUES ("MT20_17","070_20_17","MAT","20","17","17","Yesu paakabhi akwela kujenda ku Yelusalemu, akabhalohiki bhabhulwa bhaki komi na bhabheli bhala, na pabhakabhi bhajenda mwindela, akabhapwaghile, ");
INSERT INTO mpa_vpl VALUES ("MT20_18","070_20_18","MAT","20","18","18","“Njowanyaje, tujenda ku Yelusalemu, na konihoku Mwana waka Mundu anajeghalika mu mabhoku gha bhapenganyambiku bhakolongwa na bhabhola bha Shelia. Na bhombi anabhuntemula kupotela, ");
INSERT INTO mpa_vpl VALUES ("MT20_19","070_20_19","MAT","20","19","19","anabhumboha kwa bhandu bhangakubha Bhayahude, nahuli bhundongamaje, na kundapu iboku, na kumuwamba panani pa msalaba, nambu lichobha la katatu anahyokaje kabheti.” ");
INSERT INTO mpa_vpl VALUES ("MT20_20","070_20_20","MAT","20","20","20","Panihapa mabhu wabhu bhana bhaka Zebedayo akanjendi Yesu papamu na bhana bhaki, akachikimi palongi jaki, na kundobha anhengila chela cheachipala. ");
INSERT INTO mpa_vpl VALUES ("MT20_21","070_20_21","MAT","20","21","21","Yesu akandalukile, “Bho, upala kike?” Amabhu hoju akampwaghile, “Pepakoku, laghalakya kubha bhana bhangu bhabheli abhabha bhatama jumu upambala waku wa kumalelelu, na jumu upambala waku wa kumangeja, mu Ukolongwa waku.” ");
INSERT INTO mpa_vpl VALUES ("MT20_22","070_20_22","MAT","20","22","22","Yesu akamuyangiki, “Ngachemmanyi chemuchilobha. Bho, muweza kunywele chikombi cheananywelila nenga, na kubatizwa ubatizo ghonibatizwe?” Bhakamuyangiki, “Tuweza.” ");
INSERT INTO mpa_vpl VALUES ("MT20_23","070_20_23","MAT","20","23","23","Yesu akabhapwaghile, “Chakaka ananywelilaje chikombi changu, na kubatizwa ubatizo ghonibatizwe, nambu kutama chiwoku changu cha kumalelelu na chiwoku changu cha kumangeja nga lihengu langu kumpekeha, nambu lijambu heli anabhapekiwa bhala bhabhabhekakiwi tayali na Atati wangu.” ");
INSERT INTO mpa_vpl VALUES ("MT20_24","070_20_24","MAT","20","24","24","Bhabhulwa bhangi komi bhala pabhakajowini ghanihagha, bhakabhayomile bhalongu bhabheli bhala. ");
INSERT INTO mpa_vpl VALUES ("MT20_25","070_20_25","MAT","20","25","25","Nambu Yesu akabhalohiki bhabhulwa bhaki papamu, na kubhapwaghila, “Mmanyi kubha bhatawala bha bhandu bhangakubha Bhayahude bhajemalela bhandu bhabhu kwa makili, na ihongozi habha bhahenga bhandu habha kubha bhabhu. ");
INSERT INTO mpa_vpl VALUES ("MT20_26","070_20_26","MAT","20","26","26","Nambu kwinu mwenga ngakwikubha bhenibhela, nambu mundu jokapi joapala kubha nkolongwa kwinu, impalika abya mtumika winu. ");
INSERT INTO mpa_vpl VALUES ("MT20_27","070_20_27","MAT","20","27","27","Joapala kubha wa kutumbula pachilanda jinu, ipalika abya mtumika winu, ");
INSERT INTO mpa_vpl VALUES ("MT20_28","070_20_28","MAT","20","28","28","maghambu Mwana waka Mundu ngacheahikiki nahuli kutumikiwa, nambu kutumika, na kuubhoha womi waki nahuli kubhakombola bhandu bhamaheli.” ");
INSERT INTO mpa_vpl VALUES ("MT20_29","070_20_29","MAT","20","29","29","Yesu na bhabhulwa bhaki pabhakabhi bhabhoka ku Yeliko, lipogha likolongwa la bhandu, bhakunjengalile. ");
INSERT INTO mpa_vpl VALUES ("MT20_30","070_20_30","MAT","20","30","30","Akangalola bhabheli bhabhakabhi bhatemi punkeghi ja indela, na pabhakajowini kubha Yesu apeta, bhakajamalili, “Bambo, Mwana waka Daude, utubhonila chiha!” ");
INSERT INTO mpa_vpl VALUES ("MT20_31","070_20_31","MAT","20","31","31","Lipogha la bhandu lela lakabhalakalili na kubhapwaghila mtumbalaje, nambu akangalola bhala bhakajonjuki kujamalila nakanopi, bhakapwaghaje, “Bambo, Mwana waka Daude, utubhonila chiha!” ");
INSERT INTO mpa_vpl VALUES ("MT20_32","070_20_32","MAT","20","32","32","Yesu akajemiki, na kubhaloha na kubhalalukila, “Bho, mpala nuntendila kike?” ");
INSERT INTO mpa_vpl VALUES ("MT20_33","070_20_33","MAT","20","33","33","Bhakamuyangiki, “Bambo, tupala kulola.” ");
INSERT INTO mpa_vpl VALUES ("MT20_34","070_20_34","MAT","20","34","34","Yesu akabhabhoni chiha, akaghapapihi mihu ghabhu, na palapala bhakapatiki kulola, na bhakanjengalile. ");
INSERT INTO mpa_vpl VALUES ("MT21_1","070_21_1","MAT","21","1","1","Yesu na bhabhulwa bhaki pabhaheghali ku Yelusalemu na kuhika ku Besifage pachitombi cha Mizeituni, akabhatumiki bhabhulwa bhaki bhabheli, ");
INSERT INTO mpa_vpl VALUES ("MT21_2","070_21_2","MAT","21","2","2","akabhapwaghile “Njendanya mpaka ku chijiji chechibhi palongi jinu na anamulihimanya liponda likongakiki na mwanaliponda papamu naku. Mkaghabhopula na mkaghaleta kwango. ");
INSERT INTO mpa_vpl VALUES ("MT21_3","070_21_3","MAT","21","3","3","Ngati mundu anandaluki chokapi, mumpwaghilaje, ‘Bambo alipala,’ najombi anaandekilaje.” ");
INSERT INTO mpa_vpl VALUES ("MT21_4","070_21_4","MAT","21","4","4","Lijambu haleli likahengakiki nahuli ghala ghaghakapwagakiki na mlota waka Chapanga ghatimilaje. ");
INSERT INTO mpa_vpl VALUES ("MT21_5","070_21_5","MAT","21","5","5","“Mubhapwagila bhandu bha muchi wa Sayuni. Lingalya, Nkolongwa waku ahika kwaku! Nde mpole, na akweliki paliponda. Ahika panani ja mwanaliponda.” ");
INSERT INTO mpa_vpl VALUES ("MT21_6","070_21_6","MAT","21","6","6","Bhela, bhabhulwa bhala bhakapiti, na kuhenga ngati Yesu moakabhalaghalakile. ");
INSERT INTO mpa_vpl VALUES ("MT21_7","070_21_7","MAT","21","7","7","Bhakaliletiki liponda lela, na mwana waki, bhakajaliki ingobhu yabhu panani ja liponda, na Yesu akatemi panani jaki. ");
INSERT INTO mpa_vpl VALUES ("MT21_8","070_21_8","MAT","21","8","8","Lipogha likolongwa la bhandu lakajaliki ingobhu yabhu mwindela, na bhandu bhangi bhakahekiki mambandi gha mikongu, na kughajala mwindela. ");
INSERT INTO mpa_vpl VALUES ("MT21_9","070_21_9","MAT","21","9","9","Lipogha la bhandu lelundongulile na lela lelunjengalyaje lakajamalili kwa sauti ngolongwa, “Alumbalikaje Mwana waka Daude! Apengalika hoju joahika kwa lihina laka Bambo! Ulumbalilu kwaka Chapanga kunani kumahunde!” ");
INSERT INTO mpa_vpl VALUES ("MT21_10","070_21_10","MAT","21","10","10","Yesu paakabhi ajingi ku Yelusalemu, muchi wokapi ukatweli kukenyamuka, na bhandu bhakabhi bhalalukila, “Bho, ajoju nde nane?” ");
INSERT INTO mpa_vpl VALUES ("MT21_11","070_21_11","MAT","21","11","11","Lipogha la bhandu lela lakapwaghike, “Ajoju nde mlota Yesu, kuhuma ku Nazaleti muchi wa ku Galilaya.” ");
INSERT INTO mpa_vpl VALUES ("MT21_12","070_21_12","MAT","21","12","12","Bhela, Yesu akajingili muliwangala la Nyumba jaka Chapanga, akabhatopuli kunja bhandu bhabhatendika kulombesa na kuhemela hindu pa Nyumba jaka Chapanga pala, akaipendwi meza ya bhala bhabhakabhi bhang'anambu mbija, na hitehu ya bhabhabhi bhalombesa ngunda. ");
INSERT INTO mpa_vpl VALUES ("MT21_13","070_21_13","MAT","21","13","13","Akapwaghile, “Ilembakiki mu Malembu Mahuhu, ‘Nyumba jangu jikemakeka nyumba ja malobhu.’ Nambu mwanganya mjitendiki kubha likolu la bhanyaghula.” ");
INSERT INTO mpa_vpl VALUES ("MT21_14","070_21_14","MAT","21","14","14","Akangalola na ilema bhangi bhakunjendili ku Nyumba jaka Chapanga hoku, na Yesu akabhalamihe. ");
INSERT INTO mpa_vpl VALUES ("MT21_15","070_21_15","MAT","21","15","15","Bhela, bhapenganyambiku bhakolongwa na bhabhola bha Shelia pabhakaiweni hindu ya kukangacha yeakatehi Yesu, na kabhe bhana pabhajamalya pa Nyumba jaka Chapanga bhakapwaghaje, “Ulumbalilu kwaka Mwana waka Daude,” bhombi bhakayomiki namaa. ");
INSERT INTO mpa_vpl VALUES ("MT21_16","070_21_16","MAT","21","16","16","Bhela bhakampwaghile, “Bho, ngacheujowana chebhapwagha?” Yesu akabhayangiki, “Ena, nyowana! Bho, ngachendabhali kusoma lilembelu aleli, ‘Kwa milomu ja bhana na bhana bhang'eng'a anaulipatila ulumbalilu wa chakaka?’ ” ");
INSERT INTO mpa_vpl VALUES ("MT21_17","070_21_17","MAT","21","17","17","Bhela, Yesu akabhalekiki, na akabhokiki kunja ja muchi na kujenda ku Besania, na kughonela konihoku. ");
INSERT INTO mpa_vpl VALUES ("MT21_18","070_21_18","MAT","21","18","18","Yesu paakabhi akelebhuka kuhuma ku muchi ghonihoghu lukela pachibombu, jakumbiniki injala. ");
INSERT INTO mpa_vpl VALUES ("MT21_19","070_21_19","MAT","21","19","19","Akauweni nkongu ghumu wa mtini punkeghi ja indela, akaujendile nambu akauketanili ngacheubhi na lipambiku lokapi, nambu mahamba pela. Bhela, akaupwaghile, “Ngawipambika kabheti mapambiku mileli!” Palapala nkongu ghola ukajomike. ");
INSERT INTO mpa_vpl VALUES ("MT21_20","070_21_20","MAT","21","20","20","Bhabhulwa pabhuweni bhakakangichi namaa, bhakapwaghaje, “Bho, maghambu kiki nkongu wa mtini aghoghu ujomiki pe mala punkamo?” ");
INSERT INTO mpa_vpl VALUES ("MT21_21","070_21_21","MAT","21","21","21","Yesu akabhayangiki, “Numpwaghi chakaka, ngati anambi na uhobhalelu panga kubha na choghohi, muweza kuhenga nga la nkongu wa mtini aghoghu pela, nambu hata ngati anamuchipwaghi chitombi achechi, ‘Tupukaje, ukalilekala mubahali,’ analitendika bhenibhela. ");
INSERT INTO mpa_vpl VALUES ("MT21_22","070_21_22","MAT","21","22","22","Ngati anamuhobhalela, chokapi chemwilobhaje kwa malobhu, anampataje.” ");
INSERT INTO mpa_vpl VALUES ("MT21_23","070_21_23","MAT","21","23","23","Yesu akajingi paliwangala la Nyumba jaka Chapanga, na kubhola. Paakabhi akabholaje, bhapenganyambiku bhakolongwa na bhazee bhakahiki kundalukila, “Bho, uhenga mambu aghagha kwa lujiniku bhole? Bho, nane joakupeki lujiniku loniholo?” ");
INSERT INTO mpa_vpl VALUES ("MT21_24","070_21_24","MAT","21","24","24","Yesu akabhayangike, “Na nenga ananundalukya lilaluki limu, anamuniyangiki, bhela nanatu ananumpwaghila nhenga aghagha kwa lujiniku bhole. ");
INSERT INTO mpa_vpl VALUES ("MT21_25","070_21_25","MAT","21","25","25","Bho, lujiniku lwaka Yohana lwa kubatiza lukahumiki kwaka nane? Bho, lukahumiki kunani kumahunde au lukahumiki kwa bhandu?” Nambu bhakaloghulani bheni kwa bheni ana, “Bho anatupwagha bhole? Anatupwagiki, ‘Lukahumiki kwaka Chapanga,’ anaatupwaghila, ‘Mbona henu ngachemunhobhalile?’ ");
INSERT INTO mpa_vpl VALUES ("MT21_26","070_21_26","MAT","21","26","26","Ngati anatupwaghiki, ‘Lukahumiki kwa bhandu,’ tujoghopa lipogha la bhandu ndandi bhokapi bhahobhalela kubha Yohana akabhi mlota waka Chapanga.” ");
INSERT INTO mpa_vpl VALUES ("MT21_27","070_21_27","MAT","21","27","27","Bhela, bhakamuyangiki, “Ngachetumanya!” Na Yesu akabhayangike, Na nepanu nganumpwaghile ndenda mambu aghagha kwa lujiniku bhole. ");
INSERT INTO mpa_vpl VALUES ("MT21_28","070_21_28","MAT","21","28","28","“Mwanganya mbona bhole, mundu jumu akabhi na akakombu bhabheli. Akumpwaghi jola wa kutumbula, ‘Mwanango, lalenu ujenda ukahenga lihengu mu ngonda wa mizabibu.’ ");
INSERT INTO mpa_vpl VALUES ("MT21_29","070_21_29","MAT","21","29","29","Nkombu jola akampwaghile, ‘Ngachembala!’ Nambu panakatahi akang'anambwiki liholalelu laki, akapiti kuhenga lihengo. ");
INSERT INTO mpa_vpl VALUES ("MT21_30","070_21_30","MAT","21","30","30","Atati jola akumpwaghi nkombu waki wa kabheli bhelabhela, najombi akamuyangiki, ‘Ena atati!’ Nambu ngacheakapiti kulihengo. ");
INSERT INTO mpa_vpl VALUES ("MT21_31","070_21_31","MAT","21","31","31","Bho, nane panihapa pachilanda ja bhanganya bhabheli habha joahengiki ghala ghaapalika atati wabhu?” Bhakamuyangike, “Mwana wa kutumbula jola.” Bhela, Yesu akabhapwaghile, “Numpwaghi chakaka, bhajopa kodi na bhakemi anabhundongulya mwehapa kujingila mu Ukolongwa waka Chapanga. ");
INSERT INTO mpa_vpl VALUES ("MT21_32","070_21_32","MAT","21","32","32","Ndandi Yohana akahikiki kwinu na kundangiha indela jejipalika kutama, nambu mwehapa ngachemunhobhalile. Nambu bhajopa kode na bhakemi bhakunhobhalile. Papamu na kughabhona ghanihagha ghokapi, mwanganya ngacheng'anambwiki na kughaleka mahoku ghinu, na ngachemunhobhalile.” ");
INSERT INTO mpa_vpl VALUES ("MT21_33","070_21_33","MAT","21","33","33","Yesu akabhapwaghile, “Njowana ulenganesu ghongi. Mundu jumu mweni ngonda, najombi akalemiki ngonda wa mizabibu, akauyongalwi lubheghu, akalenganaki pandu pa kuminyila divai, na kuchenga mnala. Akabhajahiki bhalemi ngonda ghola, na akabhokiki kujenda mbaka ku muchi wa kutale. ");
INSERT INTO mpa_vpl VALUES ("MT21_34","070_21_34","MAT","21","34","34","Chikahi cha mahunu pachahikite, akabhatumiki bhatumika bhaki kwa bhalemi bhala, nahuli bhakatola pandu pa lifungu laki la mahuno. ");
INSERT INTO mpa_vpl VALUES ("MT21_35","070_21_35","MAT","21","35","35","Bhalemi bhala bhakabhakamwi bhatumika bhala, jumu bhakundapwili, jongi bhakunkomiki, na jongi bhakundapwi maganga. ");
INSERT INTO mpa_vpl VALUES ("MT21_36","070_21_36","MAT","21","36","36","Mweni ngonda jola akabhatumiki kabheti bhatumika bhangi, bhamaheli kupeta bhatumika bha kutumbula. Bhalemi bhala bhabhakajahiki ngonda, bhakabhatendi bhelabhela. ");
INSERT INTO mpa_vpl VALUES ("MT21_37","070_21_37","MAT","21","37","37","Pakujomukela jaki akantumiki mwana waki koni akaholakya, ‘Anabhuntopalya mwana wangu.’ ");
INSERT INTO mpa_vpl VALUES ("MT21_38","070_21_38","MAT","21","38","38","Nambu bhalemi bhala pabhakumbweni mwana waki bhakapwaghani bheni kwa bheni, ‘Ajoju nde mpwelelu waki, henu tunkomaje nahuli tuutola upwelelu waki!’ ");
INSERT INTO mpa_vpl VALUES ("MT21_39","070_21_39","MAT","21","39","39","Bhela, bhakunkamwili, na bhakumbohiki kunja ja ngonda wa mizabibu ghola, na bhakunkomiki. ");
INSERT INTO mpa_vpl VALUES ("MT21_40","070_21_40","MAT","21","40","40","“Henu, mweni ngonda wa mizabibu jola paanahikaje, bho, anaabhatenda kiki bhalemi bhala?” ");
INSERT INTO mpa_vpl VALUES ("MT21_41","070_21_41","MAT","21","41","41","Bhombi bhakamuyangike, “Chakaka anaabhakoma bhandu bhahakau habha, na ngonda ghola anaabhapekya bhalemi bhangi bhaanabhumpekya lifungu laki mapambiku kwa chikahi chaki.” ");
INSERT INTO mpa_vpl VALUES ("MT21_42","070_21_42","MAT","21","42","42","Panihapa Yesu akabhapwaghile, “Bho, ngachemwasomiki lijambu haleli mu Malembu Mahuhu? ‘Liganga lebhalikaniki bhachenga sajenu libhi liganga lelipalika nakanopi la luhuli. Bambo nde joatehi lijambu haleli, na lombi nde la ukangachu namaa kwitu!’ ” ");
INSERT INTO mpa_vpl VALUES ("MT21_43","070_21_43","MAT","21","43","43","“Kwa bhela numpwaghila, Ukolongwa waka Chapanga anaubhohakika kwinu, na kubhapekeha bhandu bhangi bhabhahenga mahengu ghala ghaaghapala Chapanga.” ");
INSERT INTO mpa_vpl VALUES ("MT21_44","070_21_44","MAT","21","44","44","Joanahabuka panani ja liganga leniheli anatunyukana ipandi ipandi, na analunhabuki mundu jokapi, analuntimbaje nakanopi. ");
INSERT INTO mpa_vpl VALUES ("MT21_45","070_21_45","MAT","21","45","45","Bhapenganyambiku bhakolongwa na Mafalisayo pabhajowini malenganesu ghaki hagha, bhakamanyiki kubah abhapwaghika bhombe. ");
INSERT INTO mpa_vpl VALUES ("MT21_46","070_21_46","MAT","21","46","46","Bhela bhakabhi bhalonda indela ja kunkamula, nambu bhabhajoghupa bhandu, kwa ndandi bhombi bhakummanyi kubha Yesu nde mlota waka Chapanga. ");
INSERT INTO mpa_vpl VALUES ("MT22_1","070_22_1","MAT","22","1","1","Yesu akalongi nabhu kabheti kwa malenganesu, ");
INSERT INTO mpa_vpl VALUES ("MT22_2","070_22_2","MAT","22","2","2","“Ukolongwa wa kunani kumahunde ulengini na nkolongwa joakantendi mwana waki uwangalalu wa chilebhi cha ukwate. ");
INSERT INTO mpa_vpl VALUES ("MT22_3","070_22_3","MAT","22","3","3","Bhela akabhatumiki bhatumika bhaki kubhakema bhaakabhakokiki kuhika paukwate, nambu bhombi bhakakaniki kuhika. ");
INSERT INTO mpa_vpl VALUES ("MT22_4","070_22_4","MAT","22","4","4","Akabhatumiki kabheti bhatumika bhangi, akapwagha, ‘Mkabhapwaghila bhala bhanabhakokiki, kubha chilebhi chibhi tayale, njinjiki likambaku langu la ng'ombi, na ng'ombi yengi yeinenipe, na kila chindu chibhi tayale, muhikaye paukwati.’ ");
INSERT INTO mpa_vpl VALUES ("MT22_5","070_22_5","MAT","22","5","5","Nambu bhombi ngachebhaholali ghanighala, bhakabohkiki, jongi akapiti kumighonda jaki, na jongi kumahengu ghaki, ");
INSERT INTO mpa_vpl VALUES ("MT22_6","070_22_6","MAT","22","6","6","na bhangi bhakabhakamwi bhatumika bhala na kubhalapula, na kubhakoma. ");
INSERT INTO mpa_vpl VALUES ("MT22_7","070_22_7","MAT","22","7","7","Nkolongwa jola akayomike, akabhatumiki manjolinjoli bhaki, bhakabhakoma bhala bhabhakomiki bhatumika bhaki, na kuuyonanga muchi wabho. ");
INSERT INTO mpa_vpl VALUES ("MT22_8","070_22_8","MAT","22","8","8","Kabhet akabhapwaghi bhatumika bhaki, ‘Uwangalalu wa chilebhi cha ukwati chibhi tayale, nambu bhabhakokakike ngechebhapalakikaje. ");
INSERT INTO mpa_vpl VALUES ("MT22_9","070_22_9","MAT","22","9","9","Bhela, njenda mwindela na bhokapi bhala bhamwabhonaje mubhakema bhahika paukwate.’ ");
INSERT INTO mpa_vpl VALUES ("MT22_10","070_22_10","MAT","22","10","10","Bhala bhatumika bhakabhokike, bhakapiti mwindela, bhakabhaletiki bhandu bhokapi bhabahwene, bhahakau na bhambone. Nyumba ja ukwate jakatweli bhaghene. ");
INSERT INTO mpa_vpl VALUES ("MT22_11","070_22_11","MAT","22","11","11","“Nkolongwa paakajingi kwabhona bhaghene, akambweni mundu jumu jwangakuwata ingobhu ja ukwate. ");
INSERT INTO mpa_vpl VALUES ("MT22_12","070_22_12","MAT","22","12","12","Nkolongwa akundalukile, ‘Nkoche, bho, ujingi bholi pambane panga ingobhu ja ukwate?’ Nambu jombi akatemi chinunu. ");
INSERT INTO mpa_vpl VALUES ("MT22_13","070_22_13","MAT","22","13","13","Panihapa nkolongwa akabhapwagili bhatumika bhaki, ‘Munkonga magholu na mabhoku mukundekala kunja kulwihi. Konihoku analela na kuyagha mino.’ ” ");
INSERT INTO mpa_vpl VALUES ("MT22_14","070_22_14","MAT","22","14","14","Yesu akajomuli kwa kupwagha, “Bhamaheli bhabhakokakike, nambu bhahaghulika nde bhachokope.” ");
INSERT INTO mpa_vpl VALUES ("MT22_15","070_22_15","MAT","22","15","15","Bhela, Mafalisayo bhakapiti, na kupwaghanila ntundu wa kunkamu Yesu kwa malobhi ghake. ");
INSERT INTO mpa_vpl VALUES ("MT22_16","070_22_16","MAT","22","16","16","Bhela, bhakabhatumiki bhabhulwa bhabhu papamu na bhahemba bhaka Helode kwaka Yesu. Bhakundalukile, “Mbola, tumanyi kubha wenga wa mundu wambone, na kubha ubhola indela jaka Chapanga kwa chakaka, ngacheunjoghopa mundu jokapi jola, panga kuholalela kubha bhandu bhapwagha kike. ");
INSERT INTO mpa_vpl VALUES ("MT22_17","070_22_17","MAT","22","17","17","Henu, utupwaghilaje maholalelu ghako, bho, wichu le kwitu au nga wichu kwitu, kulepa kode kwaka Kaisali?” ");
INSERT INTO mpa_vpl VALUES ("MT22_18","070_22_18","MAT","22","18","18","Nambu Yesu akaumanyi uhakau wabho, akabhapwaghile, “Mwenga mwakandumi kubhele, bho, mbona mnenga? ");
INSERT INTO mpa_vpl VALUES ("MT22_19","070_22_19","MAT","22","19","19","Mnangihaje mbija ja kulepela kode.” Na bhombi bhakumpeki lingengalema la mbija. ");
INSERT INTO mpa_vpl VALUES ("MT22_20","070_22_20","MAT","22","20","20","Bhela, Yesu akabhalalukile, “Bho, sula ajeji na lihina aleli yaka nane?” ");
INSERT INTO mpa_vpl VALUES ("MT22_21","070_22_21","MAT","22","21","21","Bhakamuyangike, “Nde yaka Kaisali.” Panihapa Yesu akabhapwagile, “Bhela, mumpekya Kaisali yeibhi yaki Kaisali, na mumpekya Chapanga yeibhi yaki Chapanga.” ");
INSERT INTO mpa_vpl VALUES ("MT22_22","070_22_22","MAT","22","22","22","Pabhajowini bhenibhela bhakakangichi namaa, bhakundekiki, na bhakabhokanile. ");
INSERT INTO mpa_vpl VALUES ("MT22_23","070_22_23","MAT","22","23","23","Lichobha lelalela, Masadukayo bhakumu bhabhapwagha bhabhawili ngachebhahyoka, bhakunjendi Yesu, ");
INSERT INTO mpa_vpl VALUES ("MT22_24","070_22_24","MAT","22","24","24","na kumpwaghila, “Mbola, Musa akapwaghiki mundu joatowili anaapotile panga na kundeka mwana, ipalika ndongu waki ampwelila mbomba joaweliwi na ndomi hoju, nahuli ambelakya ndongu waki bhana. ");
INSERT INTO mpa_vpl VALUES ("MT22_25","070_22_25","MAT","22","25","25","Henu, pitu pani pakabhi na bhalongu saba. Wa kutumbula akatowi mbomba, na akapotile, na maghambu ngacheakabhi na bhana, akandeki ndongu waki mbomba joaweliwi na ndomi jola. ");
INSERT INTO mpa_vpl VALUES ("MT22_26","070_22_26","MAT","22","26","26","Ikabi bhelabhela kwa ndongu wa kabhele, na wa katatu, mbaka wa saba. ");
INSERT INTO mpa_vpl VALUES ("MT22_27","070_22_27","MAT","22","27","27","Pakujomukela mbomba hoju najombi akapotile. ");
INSERT INTO mpa_vpl VALUES ("MT22_28","070_22_28","MAT","22","28","28","Bho, lichobha bhakuwa pabhiyokaje, mbomba hoju anaabya nhwanu waka nane pachilanda ja bhalongu saba bhala? Kwa ndandi bhokapi saba bhakabhi bhuntogwile.” ");
INSERT INTO mpa_vpl VALUES ("MT22_29","070_22_29","MAT","22","29","29","Yesu akabhayangike, “Mwanganya muhobhike, kwa ndandi ngachemughamanyi Malembu ghaka Chapanga, wala makili ghaka Chapanga. ");
INSERT INTO mpa_vpl VALUES ("MT22_30","070_22_30","MAT","22","30","30","Ndandi bhakuwa pabhiyokaje ngabhitogholi wala kutoghuleka, nambu bhibya ngati bhatumika bhaka Chapanga bha kunani kumahunde. ");
INSERT INTO mpa_vpl VALUES ("MT22_31","070_22_31","MAT","22","31","31","Nambu kubhokana na kuyoka kwa bhakuwa, bho, ngachemsomiki ghala ghaampwaghi Chapanga? Akapwaghike, ");
INSERT INTO mpa_vpl VALUES ("MT22_32","070_22_32","MAT","22","32","32","‘Nepani nde Chapanga waka Ibulahimu, Chapanga waka Isaka, na Chapnga waka Yakobo!’ Bhela, jombi nga Chapanga wa bhakuwa, nambu jombi nde Chapanga wa bhandu bhabhabhi bhome.” ");
INSERT INTO mpa_vpl VALUES ("MT22_33","070_22_33","MAT","22","33","33","Lipogha la bhandu lela palajowini ghanighala, bhakakangichi mabholu ghake. ");
INSERT INTO mpa_vpl VALUES ("MT22_34","070_22_34","MAT","22","34","34","Bhela Mafalisayo pabhajowini kubha Yesu akabhi bhatumbalishi Masadukayo, bhakaketangini papamo. ");
INSERT INTO mpa_vpl VALUES ("MT22_35","070_22_35","MAT","22","35","35","Jumu wabhu, bambo Shelia, akandaluki Yesu kwa kundenga, ");
INSERT INTO mpa_vpl VALUES ("MT22_36","070_22_36","MAT","22","36","36","“Mbola, bho, amuli bhole nde ngolongwa mu Shelia jokapi?” ");
INSERT INTO mpa_vpl VALUES ("MT22_37","070_22_37","MAT","22","37","37","Yesu akayangiki, “ ‘Umpala Bambo Chapanga waku kwa mtima waku wokapi, na kwa roho jaku jokapi, na kwa malangu ghaku ghokapi.’ ");
INSERT INTO mpa_vpl VALUES ("MT22_38","070_22_38","MAT","22","38","38","Jeniheji nde amuli ngolongwa na ja kutumbula. ");
INSERT INTO mpa_vpl VALUES ("MT22_39","070_22_39","MAT","22","39","39","Na ja kabheli jejilengana na jeniheji nde jenjenu, ‘Umpala njaku, ngati moulipali wamwete.’ ");
INSERT INTO mpa_vpl VALUES ("MT22_40","070_22_40","MAT","22","40","40","Shelia jokapi na mabholu ghokapi gha bhalota bhaka Chapanga, ghategamela amuli ibheli hayeyi.” ");
INSERT INTO mpa_vpl VALUES ("MT22_41","070_22_41","MAT","22","41","41","Mafalisayo pabhalibhongini papamu, Yesu akabhalalukile, ");
INSERT INTO mpa_vpl VALUES ("MT22_42","070_22_42","MAT","22","42","42","“Bho, mwanganya mbona bholi panani jaka Kristo? Bho, nde mwana waka nane?” Bhakamuyangike, “Mwana waka Daude.” ");
INSERT INTO mpa_vpl VALUES ("MT22_43","070_22_43","MAT","22","43","43","Yesu akabhapwaghile, “Bhela, bho, iwezikana bholi kupwaga kwa makili ghaka Roho Mhuhu, Daude ankema jombi Bambo? Ndandi akapwaghike, ");
INSERT INTO mpa_vpl VALUES ("MT22_44","070_22_44","MAT","22","44","44","‘Bambo akampwaghi Bambo wangu. Utama upambala wangu wa kumalelelu, mbaka nabhabheka maadui bhaku pahi ja magholu ghako.’ ");
INSERT INTO mpa_vpl VALUES ("MT22_45","070_22_45","MAT","22","45","45","Bhela, ngati anakubhi Daude ankema Kristo, ‘Bambo,’ bho, aweza bholi henu kubha mwana waki?” ");
INSERT INTO mpa_vpl VALUES ("MT22_46","070_22_46","MAT","22","46","46","Nga mundu nga jumu joakaweziki kumuyanga lilobhe. Na kutumbu lichobha leniheli nga mundu hata jumu joakalengiki kundalukila lilalukilu kabheti. ");
INSERT INTO mpa_vpl VALUES ("MT23_1","070_23_1","MAT","23","1","1","Kabheti Yesu akalongi na lipogha la bhandu papamu na bhabhulwa bhaki, ");
INSERT INTO mpa_vpl VALUES ("MT23_2","070_23_2","MAT","23","2","2","“Bhabhola bha Shelia na Mafalisayo nde bhabhabhi na uwezu wa kuilongalela Shelia yaka Musa. ");
INSERT INTO mpa_vpl VALUES ("MT23_3","070_23_3","MAT","23","3","3","Bhela mkamulaje malaghalakilu na kuhenga ghokapi ghabhumpwaghila. Nambu ngamwijigha matendu ghabhu, maghambu ngachebhahenga ghala ghabhumpwaghila. ");
INSERT INTO mpa_vpl VALUES ("MT23_4","070_23_4","MAT","23","4","4","Bhakonga hibwahila yeitopiki na kubhatweka bhandu mumabhegha ghabhu, nambu bhombi bheni ngachebhapala kuhatambula hata lukonji nahuli kujangatila kutotola. ");
INSERT INTO mpa_vpl VALUES ("MT23_5","070_23_5","MAT","23","5","5","Kabheti bhahenga matendu ghabhu ghokapi nahuli bhandu bhabhonaje, kwa ndandi bhawata hindu ikolongwa yeilembakiki Shelia pachibongi, na mumabhoku, na kujonjukela mahundwa gha hunjihunji mukona ja ingobhu yabhu, ");
INSERT INTO mpa_vpl VALUES ("MT23_6","070_23_6","MAT","23","6","6","bhapala hitehu ya kulongi pa uwangalalu wa chilebhi, na kutama kulongi mu manyumba ya kuhimangani Bhayahude. ");
INSERT INTO mpa_vpl VALUES ("MT23_7","070_23_7","MAT","23","7","7","Bhapala kulamukiwa kwa kutopela paligulio, na kulowakeka na bhandu, ‘Mbola.’ ");
INSERT INTO mpa_vpl VALUES ("MT23_8","070_23_8","MAT","23","8","8","Nambu mwanganya ngamwilowakeka, ‘Mbola,’ kwa ndandi Mbola winu nde jumu, wala Kristo, nanamu mabhokapi nde bhalongu. ");
INSERT INTO mpa_vpl VALUES ("MT23_9","070_23_9","MAT","23","9","9","Ngamwandowa mundu ‘Atati,’ pundema, kwa ndandi Atati winu jumu, joabhi wa kunani kumahunde. ");
INSERT INTO mpa_vpl VALUES ("MT23_10","070_23_10","MAT","23","10","10","Kabheti ngamwilowakeka chiongozi, kwa ndandi Chiongozi winu nde jumu, najombi nde Kristo. ");
INSERT INTO mpa_vpl VALUES ("MT23_11","070_23_11","MAT","23","11","11","Nambu jola joabhi nkolongwa winu anaabya ntumika winu. ");
INSERT INTO mpa_vpl VALUES ("MT23_12","070_23_12","MAT","23","12","12","Mundu jokapi joalikweha anahelakikaje, na mundu joaliheleha anakwehakikaje.” ");
INSERT INTO mpa_vpl VALUES ("MT23_13","070_23_13","MAT","23","13","13","“Anamuchibhonaje bhabhola bha Shelia na Mafalisayo, mwemulitenda kubha bhambone! Kwa ndandi mujighila ndyangu wa Ukolongwa wa kunani kumahunde palongi ja bhandu, na mwabheni ngachenjingila, wala bhabhajingila ngachemwaleka bhajingalaje. ");
INSERT INTO mpa_vpl VALUES ("MT23_14","070_23_14","MAT","23","14","14","Anamuchibhonaje bhabhola bha Shelia na Mafalisayo, mwemulibhona kubha bhambone! Kwa ndandi mwanyaghula akamabhu bhabhaweliwi na bhalomi bhabhu hindu yabhu, na kwa kulitenda mwamboni koni ndobha malobhu malachu, bhela anampata utemulo ghoubhi ukolongwa nakanope.” ");
INSERT INTO mpa_vpl VALUES ("MT23_15","070_23_15","MAT","23","15","15","“Anamuchibhonaje bhabhola bha Shelia na Mafalisayo, mwemulitenda kubha bhamboni! Kwa ndandi muyongolota munhwanga na mumaheku nahuli kumpata mundu jumu ahobhalya mabholu ghinu, na kabheti anamumpatike, muntenda abya na uwezu mala pabheli nakanopi ja kujenda mu Jehanamu ja moto kupeta mabhene. ");
INSERT INTO mpa_vpl VALUES ("MT23_16","070_23_16","MAT","23","16","16","“Anamuchibhonaje akachiongozi ngalola, mwembola, ‘Mundu anaalapike kwa Nyumba jaka Chapanga, kulapa hoku nga chindu. Nambu ngati analapiki kwa zahabu jejibhi mu Nyumba jaka Chapanga, kulapa hoku kunkamula.’ ");
INSERT INTO mpa_vpl VALUES ("MT23_17","070_23_17","MAT","23","17","17","Mwanganya mwang'ang'a na akangalola, kwa ndandi nde jaku jejibhi ngolongwa, zahabu jela, au Nyumba jaka Chapanga jela jejitenda zahabu heji jibya jihuhu? ");
INSERT INTO mpa_vpl VALUES ("MT23_18","070_23_18","MAT","23","18","18","Bhelabhela mpwagha, ‘Mundu joalapa kwa chihanja cha nyambiku, nga chindu, nambu mundu jola joalapa kwa nyambiku jelibhi panani ja chihanja cha nyambiku, kulapa hoku kubhi na makili.’ ");
INSERT INTO mpa_vpl VALUES ("MT23_19","070_23_19","MAT","23","19","19","Chakaka mwanganya nde mwakangalola! Kwa ndandi nde jaku jejibhi ngolongwa, nyambiku jela, au chihanja cha nyambiku chela chechigholola nyambiku? ");
INSERT INTO mpa_vpl VALUES ("MT23_20","070_23_20","MAT","23","20","20","Bhela, jombi joalapa kwa chihanja cha nyambiku, alapa kwa jeniheje, na kwa hindu yokapi yeibhi panani jake. ");
INSERT INTO mpa_vpl VALUES ("MT23_21","070_23_21","MAT","23","21","21","Jombi joalapa kwa Nyumba jaka Chapanga, alapa kwa jeniheli, na kwaka Chapanga joatama mkati jake. ");
INSERT INTO mpa_vpl VALUES ("MT23_22","070_23_22","MAT","23","22","22","Joalapa kwa kunani kumahunde, alapa kwa chitehu cha ukolongwa chaka Chapanga, na kwaka jombi joatama panani jake. ");
INSERT INTO mpa_vpl VALUES ("MT23_23","070_23_23","MAT","23","23","23","“Anamuchibhonaje bhabhola bha Shelia na Mafalisayo, mwemulitenda mwambone! Kwa ndandi mboha lifungu la komi kuhuma kwa hata mahamba ghaghanungi wichu, hiliki na mdalasini, na koni nkotwiki kuhenga mambu makolongwa gha Shelia, ngati bhela kuhenga ghaghunyambiha Chapanga, chiha, na uhobhalelu. Aghagha nde ghaghumpalika kuhenga, na kabheti panga na kughaleka ghangi hagha. ");
INSERT INTO mpa_vpl VALUES ("MT23_24","070_23_24","MAT","23","24","24","Mwenga akachiongozi akangalola! Mboha lunjenjema mu chindu cha kunywa, nambu mmila ngamia! ");
INSERT INTO mpa_vpl VALUES ("MT23_25","070_23_25","MAT","23","25","25","“Anamuchibhonaje bhabhola bha Shelia na Mafalisayo, mwemulitenda mwamboni! Kwa ndandi ngolola chikombi na mbale kwa kunja, na mkati jaki itweli hindu yemuipatiki kwa unyagula na wime. ");
INSERT INTO mpa_vpl VALUES ("MT23_26","070_23_26","MAT","23","26","26","Wenga wa Falisayo ngalola, ugholulaji hoti mkati ja chikombi, na kunja jaki anakubya wichu! ");
INSERT INTO mpa_vpl VALUES ("MT23_27","070_23_27","MAT","23","27","27","“Anamuchibhonaje bhabhola bha Shelia na Mafalisayo, mwemulitenda kubha mwambone! Kwa ndandi ndengini na matengeli ghaghapakakiki chokaa kwa kunja, ghabhonikana kubha manyahi, nambu mkati jaki ghatweli mahupa gha bhabhawile, na uchafu wokapi. ");
INSERT INTO mpa_vpl VALUES ("MT23_28","070_23_28","MAT","23","28","28","Bhelabhela na mwanganya nanamu, kwa kunja mbonikana na bhandu kubha mwambone, nambu mkati mtweli kukopungane mwamboni na uhakau. ");
INSERT INTO mpa_vpl VALUES ("MT23_29","070_23_29","MAT","23","29","29","“Anamuchibhonaje bhabhola bha Shelia na Mafalisayo, mwemulitenda kubha mwamboni! Kwa ndandi mghachengalela matengeli gha bhalota bhaka Chapanga, na kughapamba matengeli gha bhandu bhambone. ");
INSERT INTO mpa_vpl VALUES ("MT23_30","070_23_30","MAT","23","30","30","Kabheti mpwagha, ‘Ngati tepanu tukabhili mwandi wa akahokolu bhitu, ngatukajetanganili nabhu kubhakoma bhalota bhaka Chapanga!’ ");
INSERT INTO mpa_vpl VALUES ("MT23_31","070_23_31","MAT","23","31","31","Bhela mlilandila hotuhotu kubha mwanganya nde mabhana wa bhala bhabhakomiki bhalota bhaka Chapanga! ");
INSERT INTO mpa_vpl VALUES ("MT23_32","070_23_32","MAT","23","32","32","Ena njomulyaje lihengu lela lebhakatumbwi akatati bhinu. ");
INSERT INTO mpa_vpl VALUES ("MT23_33","070_23_33","MAT","23","33","33","Mwenga chibheleku cha lijoka, na mabhana bha majoka! Bho, henu anantila bholi utemulu wa Jehanamu? ");
INSERT INTO mpa_vpl VALUES ("MT23_34","070_23_34","MAT","23","34","34","Kwa ndandi jeniheji, ndingalya, nepani nabhatuma kwinu bhalota bhaka Chapanga, na bhandu bhana mbulahu, na bhabhola. Mwehapa anamubhakomaje, na bhangi bhabhu kubhawamba punsalaba, na bhangi bhabhu kulapulika iboku mu manyumba ghinu gha kuhimangani Bhayahude, na bhangi kubhalonda pa kila muchi. ");
INSERT INTO mpa_vpl VALUES ("MT23_35","070_23_35","MAT","23","35","35","Bhela mwahi wokapi wa bhandu bhambone ghoujitiki panani ja pundema anaukubha panani ja mimutu jinu, kutumbu kujitika kwa mwahi waka Abeli, jola joakajetakaliwi palongi jaka Chapanga, mbaka mwahi waka Zakalia mwana waka Balakia, jomukankomiki pachilanda ja Nyumba jaka Chapanga na pachihanja cha nyambiku. ");
INSERT INTO mpa_vpl VALUES ("MT23_36","070_23_36","MAT","23","36","36","Numpwaghi chakaka, utemulo kwa ndandi ja bhandu bhabahkomakiki bhanihabha anauhika panani ja chibheleku chenjenu. ");
INSERT INTO mpa_vpl VALUES ("MT23_37","070_23_37","MAT","23","37","37","“Yelusalemu, Ee Yelusalemu! Weubhakoma bhalota bhaka Chapanga, na kubhalapula kwa maganga bhandu bhala bhabhatumakiki kwaku! Mala palenga nakapaliki kubhabhongana bhandu bhaku papamu, ngati bhela ingoku mojibhonganela ibhana yaki pahi ja mapapanila ghaki, nambu ngachemwapaile! ");
INSERT INTO mpa_vpl VALUES ("MT23_38","070_23_38","MAT","23","38","38","Ndingalyaje, Nyumba jaka Chapanga winu bhundeki mang'obha. ");
INSERT INTO mpa_vpl VALUES ("MT23_39","070_23_39","MAT","23","39","39","Bhela numpwaghila, ngamwimoni kabheti kutumbu sajeno, mbaka pamwipwaghaje, ‘Apengalika hoju joahika kwa lihina laka Bambo.’ ” ");
INSERT INTO mpa_vpl VALUES ("MT24_1","070_24_1","MAT","24","1","1","Yesu akabhokiki pa Nyumba jaka Chapanga, na paakabhi abhoka, bhabhulwa bhaki bhakanjendili kundangiha machengu gha Nyumba jaka Chapanga. ");
INSERT INTO mpa_vpl VALUES ("MT24_2","070_24_2","MAT","24","2","2","Yesu akabhayangiki, akabhapwaghile, “Bho, mughabhona ghokapi aghagha? Numpwaghi chakaka, ngalihighalili liganga panani ja liganga lelibya ngachelibombuliwe.” ");
INSERT INTO mpa_vpl VALUES ("MT24_3","070_24_3","MAT","24","3","3","Hata paakabhi atami pachitombi cha Mizeituni, bhabhulwa bhaki bhakanjendi kwa kulihiya, bhakapwaghaje, “Tupwaghilaje, bho, mambu ghanihagha ghibya lile? Na jombi nde kyani nginyulila jejilangiha kuhika kwaku, na ujomukelu wa ndema?” ");
INSERT INTO mpa_vpl VALUES ("MT24_4","070_24_4","MAT","24","4","4","Yesu akabhayangike, “Ndingalyaje, mundu ngaankolowa. ");
INSERT INTO mpa_vpl VALUES ("MT24_5","070_24_5","MAT","24","5","5","Kwa ndandi bhandu bhamaheli anabhahika kwa lihina langu, bhakapwaga, ‘Nepani nde Kristo!’ Na bhombi anabhakoluwa bhandu bhamaheli. ");
INSERT INTO mpa_vpl VALUES ("MT24_6","070_24_6","MAT","24","6","6","Nanamu mwijowana ngondu, na majojalanelu gha ngondu, ndingalya ngamwijoghopa, ndandi ghanihagha ghapalika kupitalila, nambu ujomukelu ghola wakona. ");
INSERT INTO mpa_vpl VALUES ("MT24_7","070_24_7","MAT","24","7","7","Kwa ndandi bhandu bha inchi jimu anabhabhoka kujenda kukomana na bhandu bha inchi jenge, na ukolongwa kukomana na ukolongwa ghongi, kwibya na injala, na hitamu ya kujambukila, na hinyukunyuku ya luhombe pandu patalipatali. ");
INSERT INTO mpa_vpl VALUES ("MT24_8","070_24_8","MAT","24","8","8","Ghanihagha ghokapi ghibya nde ngati utumbulilu wa mabinilu ghaka mabhu joabhi na chitumbu joapala kulibhopola mwana.” ");
INSERT INTO mpa_vpl VALUES ("MT24_9","070_24_9","MAT","24","9","9","“Chikahi chenihechi anabhung'anambukya mpata mang'ahiku na kukomakeka, nanamu mwibya bhandu bha kuhakaliwa na bhandu bha inchi yokapi kwa ndandi ja lihina langu. ");
INSERT INTO mpa_vpl VALUES ("MT24_10","070_24_10","MAT","24","10","10","Pa chikahi chenihechi bhandu bhamaheli anabhauleka uhobhalelu wabhu, na bhitenda kung'anambukana, na kuhakalilana bheni kwa bheni. ");
INSERT INTO mpa_vpl VALUES ("MT24_11","070_24_11","MAT","24","11","11","Bhalota bhamaheli bhicholi anabhapitalyaje, na kubhakolowa bhandu bhamaheli. ");
INSERT INTO mpa_vpl VALUES ("MT24_12","070_24_12","MAT","24","12","12","Kwa ndandi ja kujonjukeka mahakau, upalu wa bhandu bhamaheli anaupolaje. ");
INSERT INTO mpa_vpl VALUES ("MT24_13","070_24_13","MAT","24","13","13","Nambu joanahinakalya mbaka lichobha la kujomukela, jonihoju nde joanakengaliwaje. ");
INSERT INTO mpa_vpl VALUES ("MT24_14","070_24_14","MAT","24","14","14","Kabheti Malobhi Manyahi gha Ukolongwa waka Chapanga anaghatangazwa kwa bhandu bhokapi pundema, nahuli ubya ulandilu kwabhu, panihapa nde ujomukelu ghola pawihikaje.” ");
INSERT INTO mpa_vpl VALUES ("MT24_15","070_24_15","MAT","24","15","15","“Bhela, panihapa pamwalibhola, ‘Lihakalilu la uyonangeku,’ lela lelalongaliki na mlota Danieli, lijemiki pandu pahuhu mu Nyumba jaka Chapanga, joasoma na amanyaje! ");
INSERT INTO mpa_vpl VALUES ("MT24_16","070_24_16","MAT","24","16","16","Panihapa joabhi ku Yudea na atililaje ku hitombe. ");
INSERT INTO mpa_vpl VALUES ("MT24_17","070_24_17","MAT","24","17","17","Joabhi panani ja chihaghala cha nyumba jaki, ngaihuluka kutola chindu munyumba jake. ");
INSERT INTO mpa_vpl VALUES ("MT24_18","070_24_18","MAT","24","18","18","Joabhi kungonda na ngaikelabuka kunyuma kutola ingobhu jake. ");
INSERT INTO mpa_vpl VALUES ("MT24_19","070_24_19","MAT","24","19","19","Anabhang'ahikaje namaa akambomba bhabhabhi na hitumbu, na bhabhajongeha mu machobha ghanihagha! ");
INSERT INTO mpa_vpl VALUES ("MT24_20","070_24_20","MAT","24","20","20","Ndobhaje kwaka Chapanga, nahuli kutila kwinu ngakwikubha chikahi cha imbepu, wala Lichobha la Sabato. ");
INSERT INTO mpa_vpl VALUES ("MT24_21","070_24_21","MAT","24","21","21","Ndandi chikahi chenihechi kwibya na ulale ukolongwa, ngacheulabhali kubha kutumbu pa kubhombakeka kwa ndema mbaka lalenu, wala ngawipitalili kabheti. ");
INSERT INTO mpa_vpl VALUES ("MT24_22","070_24_22","MAT","24","22","22","Ngati Chapanga ngaakapungwizi machobha ghanihagha nga mundu jokapi joakakengaliki, nambu machobha ghanihagha ghatehi kupunguzwa kwa ndandi ja bhala bhabhahaghulike.” ");
INSERT INTO mpa_vpl VALUES ("MT24_23","070_24_23","MAT","24","23","23","“Bhela, mundu anaampwaghili, ‘Kristo abhi pambane’ au ‘Abhi pala,’ ngamwanhobhalela. ");
INSERT INTO mpa_vpl VALUES ("MT24_24","070_24_24","MAT","24","24","24","Kwa ndandi anabhapitalya aka ‘Kristo’ bha ichole na bhalota bha ichole, na bhitenda nginyulila ikolongwa na ngangachu yamaheli nahuli bhakoluwaje, anaiwezakini, hata kubhakolowa bhahaghulika bhaka Chapanga. ");
INSERT INTO mpa_vpl VALUES ("MT24_25","070_24_25","MAT","24","25","25","Njowanyaje, nyomwi kumpwaghila mangani ja chikahi kuhika mambu ghaghipitalyaje kulongi.” ");
INSERT INTO mpa_vpl VALUES ("MT24_26","070_24_26","MAT","24","26","26","“Bhela, anabhumpwaghili, ‘Ndingalyaje, Kristo abhi kulipololu,’ ngamwijenda konihoko, au ‘Ndingalyaje, alihiiki mkati,’ ngamwihobhalela. ");
INSERT INTO mpa_vpl VALUES ("MT24_27","070_24_27","MAT","24","27","27","Kwa ndandi, ngati bhela unang'anu wa chitobhi mochimulakila kuhuma kolipita lyobha mbaka kolijibhi lyobha, bhenibhela nde mokwibhelila kuhika kwaki Mwana waka Mundu. ");
INSERT INTO mpa_vpl VALUES ("MT24_28","070_24_28","MAT","24","28","28","“Pala paubhi ntuhi, panihapa nde payalibhongana ngwahe.” ");
INSERT INTO mpa_vpl VALUES ("MT24_29","070_24_29","MAT","24","29","29","“Palapala pakwijomuka kulagha kwa machobh ghanihagha, lyobha analijeghalika lwihi, lubhalamwehi ngalwinang'ani, ndondwa anaihabhukaje kuhuma kunani kumahunde, na makili gha hindu ya kunani kumahunde anaghanyuhakikaje. ");
INSERT INTO mpa_vpl VALUES ("MT24_30","070_24_30","MAT","24","30","30","Kabheti, nginyulila jaka Mwana waka Mundu anajibhonikanaje kunani kumahunde, na panihapa makabila ghokapi pundema ghitenda kuombuleza, na anabhumbona Mwana waka Mundu akahelala panani ja mahundi gha kunani kumahunde akabya na makili na ulumbalilu ukolongwa. ");
INSERT INTO mpa_vpl VALUES ("MT24_31","070_24_31","MAT","24","31","31","Sauti ngolongwa ja lipenga anajijowanikaje, najombi anaabhatuma bhatumika bhaki bha kunani kumahunde, na bhombi anabhabhongana bhandu bhahaghulika bhaki kuhuma ipambala yokapi nchechi ya ndema, kutumbula ujomukelu aghoghu wa ndema mbaka ujomukelu ghonge.” ");
INSERT INTO mpa_vpl VALUES ("MT24_32","070_24_32","MAT","24","32","32","“Kwa nkongu wa mtini mulibhola ulenganesu aghogho. Chikahi pela mahamba ghaki paghatumbu kutundulila na kupiha mahamba, mmanya kubha chikahi cha mahunu chiheghalile. ");
INSERT INTO mpa_vpl VALUES ("MT24_33","070_24_33","MAT","24","33","33","Bhelabhela nanamu pamwibhona mambu ghanihagha ghokapi ghahengakeka, mmanya kubha chikahi chibhi pambipi nakanope kuhika. ");
INSERT INTO mpa_vpl VALUES ("MT24_34","070_24_34","MAT","24","34","34","Numpwaghi chakaka, kibheleku chenjenu ngachipeti panga mambu aghagha kupitalila. ");
INSERT INTO mpa_vpl VALUES ("MT24_35","070_24_35","MAT","24","35","35","Kunani na pundema anaipetaje, nambu malobhi ghangu ngaghipeti ng'o.” ");
INSERT INTO mpa_vpl VALUES ("MT24_36","070_24_36","MAT","24","36","36","“Nambu, lichobha heli na lisaa heli, nga mundu joamanya libya lile, wala bhatumika bha kunani kumahunde, wala Mwana, nambu Atati kanjika jaki nde joamanya. ");
INSERT INTO mpa_vpl VALUES ("MT24_37","070_24_37","MAT","24","37","37","Kwa ndandi ngati mokwabheli chikahi chaka Nuhu, bhenibhela nde mokwibhelila kuhika kwaki Mwana waka Mundu. ");
INSERT INTO mpa_vpl VALUES ("MT24_38","070_24_38","MAT","24","38","38","Kwa ndandi chikahi chenichela mangani ja ndema kutwelakeka machi, bhandu bhakabhi bhakakulaje na kunywa, bhakatoghulaje na kutoghuleka, mbaka Nuhu paajingili mkati ja sitima ngolongwa jejilowakeka safina. ");
INSERT INTO mpa_vpl VALUES ("MT24_39","070_24_39","MAT","24","39","39","Ngachebhamanyi chibhi kyane mbaka machi paghatwelile pundema, na kubhajola bhokapi. Nde mokwibhelila chikahi cheanahika Mwana waka Mundu. ");
INSERT INTO mpa_vpl VALUES ("MT24_40","070_24_40","MAT","24","40","40","Chikahi chenihechi bhandu bhabheli bhibya kungonda, jumu anaatolikaji na jongi kuhighalila. ");
INSERT INTO mpa_vpl VALUES ("MT24_41","070_24_41","MAT","24","41","41","Akamabhu bhabheli bhibya bhayagha ulehi, jumu anaatolakikaje, na jongi kuhighalila. ");
INSERT INTO mpa_vpl VALUES ("MT24_42","070_24_42","MAT","24","42","42","“Bhela, mulilingalyaje na kubha tayale, kwa ndandi ngachemmanya lichobha leanahika Bambo winu. ");
INSERT INTO mpa_vpl VALUES ("MT24_43","070_24_43","MAT","24","43","43","Nambu nkombuka lijambu alele. Ngati mweni nyumba akamanyiki lichobha mwihi leanahikaje, akabya atemi mihu ikilu kelukelu, wala ngaakajilekiki nyumba jaki jibombulikaje. ");
INSERT INTO mpa_vpl VALUES ("MT24_44","070_24_44","MAT","24","44","44","Bhela, nanamu bhelabhela mbya tayale, kwa ndandi Mwana waka Mundu anahika chikahi changa kuchihobhalela.” ");
INSERT INTO mpa_vpl VALUES ("MT24_45","070_24_45","MAT","24","45","45","Yesu akajendali kupwagha, “Bho, nde nane mtumika ndongwana na mweni malangu, jola ambaju bambo waki anaambeka kubhajemalela bhandu bhaki, abhapekya chilebhi kwa chikahi chake? ");
INSERT INTO mpa_vpl VALUES ("MT24_46","070_24_46","MAT","24","46","46","Apengaliki mtumika jola, ambaju bambo waki paanahikaje anaanketanya akatenda bhenibhela. ");
INSERT INTO mpa_vpl VALUES ("MT24_47","070_24_47","MAT","24","47","47","Numpwaghi chakaka, anaambeka mtumika hoju ajemalya hindu yaki yokapi. ");
INSERT INTO mpa_vpl VALUES ("MT24_48","070_24_48","MAT","24","48","48","Nambu ngati mtumika muhakau anaalipwaghi muntima jaki, ‘Bambo wangu akabhakili kukelabhuka,’ ");
INSERT INTO mpa_vpl VALUES ("MT24_49","070_24_49","MAT","24","49","49","kabheti na kutumbula kubhalapu bhatumika bhajake, akatumbula kula na kunywa papamu na bhabhalobhe uwembi, ");
INSERT INTO mpa_vpl VALUES ("MT24_50","070_24_50","MAT","24","50","50","bambo waki anahika lichobha langa kuliholalela, na lisaa langa kulimanya. ");
INSERT INTO mpa_vpl VALUES ("MT24_51","070_24_51","MAT","24","51","51","Panihapa nde anaantemula nakanopi mundu hoju, na kumbeka papamu na lipogha la akandumila kubheli, konihoku nde kwibya kulela na kuyagha mino. ");
INSERT INTO mpa_vpl VALUES ("MT25_1","070_25_1","MAT","25","1","1","“Chikahi hechi Ukolongwa wa kunani kumahunde anaulengana na akamwali komi, bhabhatoliki taa yabhu, na kujenda kunjopalela bambo ukwati. ");
INSERT INTO mpa_vpl VALUES ("MT25_2","070_25_2","MAT","25","2","2","Akamwali nhwanu pachilanda jabhu bhakabhi bhang'ang'a, na nhwanu bhakabhi bhabhabhi na malangu. ");
INSERT INTO mpa_vpl VALUES ("MT25_3","070_25_3","MAT","25","3","3","Bhala bhabhakabhi bhang'ang'a bhakaitoliki taa yabhu, nambu ngachebhakatoliki mahuta gha kujonjukela. ");
INSERT INTO mpa_vpl VALUES ("MT25_4","070_25_4","MAT","25","4","4","Nambu bhala bhabhabhi na malangu bhakaitoliki taa yabhu, papamu na mahuta ghangi gha kujonjukela mu makopu ghabhu. ");
INSERT INTO mpa_vpl VALUES ("MT25_5","070_25_5","MAT","25","5","5","Kwa ndandi bambo ukwati akatehi kukabhakila, akamwali bhokapi bhakatitili, na kughochela lughono. ");
INSERT INTO mpa_vpl VALUES ("MT25_6","070_25_6","MAT","25","6","6","“Nambu ikilu pamahiku, pakabhi na ngomela, ‘Njumukaje, bambo ukwati ahika, njendanya mukunjopalyaje!’ ");
INSERT INTO mpa_vpl VALUES ("MT25_7","070_25_7","MAT","25","7","7","Panihapa bhakabhokiki akamwali bhokapi, na kuibheka wichu taa yabhu. ");
INSERT INTO mpa_vpl VALUES ("MT25_8","070_25_8","MAT","25","8","8","Bhang'ang'a bhala bhakabhapwaghi bhabhabhi na malangu bhala, ‘Mutupekya mahuta ghinu machokope, ndandi taa hitu ichuchuka.’ ");
INSERT INTO mpa_vpl VALUES ("MT25_9","070_25_9","MAT","25","9","9","Nambu bhabhabhi na malangu bhala bhakabhayangiki, ‘Ngaghatujaghanile tepani na mwehapa. Mbanga njendanya kobhalombesa, na mkahemala ghinu.’ ");
INSERT INTO mpa_vpl VALUES ("MT25_10","070_25_10","MAT","25","10","10","Bhela, pabhakabhi bhajenda kuhemela, bambo ukwati akahikiki, na akamwali bhabhakabhi tayali bhakajingili papamu naku mu ukwati, na ndyangu ukajighaliki. ");
INSERT INTO mpa_vpl VALUES ("MT25_11","070_25_11","MAT","25","11","11","“Palongi bhakahikiki akamwali bhangi bhala, na kupwagha, ‘Bambo, Bambo, utuhoghulyaje!’ ");
INSERT INTO mpa_vpl VALUES ("MT25_12","070_25_12","MAT","25","12","12","Akabhayangiki, ‘Chakaka, numpwaghila, ngachenumanyi mwehapa.’ ” ");
INSERT INTO mpa_vpl VALUES ("MT25_13","070_25_13","MAT","25","13","13","Bhela Yesu akapwaghike, “Mulilingalyaje, maghambu ngachemmanyi lichobha wala lisaa leanahikaje Mwana waka Mundu. ");
INSERT INTO mpa_vpl VALUES ("MT25_14","070_25_14","MAT","25","14","14","“Chikahi chenihechi Ukolongwa wa kunani kumahunde wibya ngati ulenganesu waka mundu joapala kutenda mwanja. Akabhalohiki bhatumika bhaki, na kubhapekeha hindu yaki. ");
INSERT INTO mpa_vpl VALUES ("MT25_15","070_25_15","MAT","25","15","15","Akumpeki kila jumu kulengana na uwezu waki, jumu akumpeki mbija talanta unhwanu, jongi mbija talanta ibheli, jongi mbija talanta jimu, na mweni kubhoka. ");
INSERT INTO mpa_vpl VALUES ("MT25_16","070_25_16","MAT","25","16","16","Jola joakapatiki mbija talanta unhwanu akapiti, akaihengi lihengu, na kupata nyonjeka mbija talanta yengi unhwanu. ");
INSERT INTO mpa_vpl VALUES ("MT25_17","070_25_17","MAT","25","17","17","Jola joakapatiki mbija talanta ibeli najombi akahengiki bhelabhela, na kupata nyonjeka ibheli. ");
INSERT INTO mpa_vpl VALUES ("MT25_18","070_25_18","MAT","25","18","18","Nambu jola joakapatiki mbija talanta jimu jola akapiti kuhyelalela pahi, na kuhiya mbija jaka nkolongwa waki. ");
INSERT INTO mpa_vpl VALUES ("MT25_19","070_25_19","MAT","25","19","19","“Paghapetiki machobha ghamaheli bambo wa bhatumika jola akahikiki, na kuhenga mabhalanganilu nabhu. ");
INSERT INTO mpa_vpl VALUES ("MT25_20","070_25_20","MAT","25","20","20","Mtumika joakapatiki mbija talanta unhwanu jola akahikiki, na kuleta mbija talanta unhwanu nakanopi. Akapwaghiki, ‘Bambo, ukabhekiki kwangu mbija talanta unhwanu. Lingalya, pambani ibhi mbija talanta unhwanu nakanopi ja nyonjeka jembatike.’ ");
INSERT INTO mpa_vpl VALUES ("MT25_21","070_25_21","MAT","25","21","21","Bambo waki akumpwaghile, ‘Uhengiki wichu namaa, mtumika wambone na undongwana. Ubhi undongwana kwa mambu machoku, ananukupekya lujiniku lwa kujemalela hindu yamaheli. Ujingalaje na uhekalya papamu na bambo waku.’ ");
INSERT INTO mpa_vpl VALUES ("MT25_22","070_25_22","MAT","25","22","22","“Jola joakajopali mbija talanta ibeli najombi akahikiki, na kupwagha, ‘Bambo, ukabhekiki kwangu mbija talanta ibeli. Lingalya, pambani ibhi mbija talanta ibeli ya nyonjeka jembatike.’ ");
INSERT INTO mpa_vpl VALUES ("MT25_23","070_25_23","MAT","25","23","23","Bambo waki akumpwaghile, ‘Uhengiki wichu namaa, mtumika wambone na undongwana. Ubhi undongwana kwa mambu machoku, ananukupekya lujiniku lwa kujemalela hindu yamaheli. Ujingalaje na uhekalya papamu na bambo waku!’ ");
INSERT INTO mpa_vpl VALUES ("MT25_24","070_25_24","MAT","25","24","24","“Jola joakajopalile mbija talanta jimu akahikiki, na kupwagha, ‘Bambo, nakamanyiki kubha wehapa nde wa mundu weunonwipe, uhuna panga kupanda, na ubhongana panga kupechangana imbeju. ");
INSERT INTO mpa_vpl VALUES ("MT25_25","070_25_25","MAT","25","25","25","Bhela nakajowipi, na kujihiya mbija jaku pahi ja luhombi. Utolaje, jenjenu nde mbija jaku.’ ");
INSERT INTO mpa_vpl VALUES ("MT25_26","070_25_26","MAT","25","26","26","“Bambo waki akayangiki, ‘Wehapa nde wa mtumika muhakau na unkata. Umanyi kubha nepani nihuna panga kupanda, na kubhongana panga kupechangana. ");
INSERT INTO mpa_vpl VALUES ("MT25_27","070_25_27","MAT","25","27","27","Bhela ikakupaliki ubheka mbija jangu kwa bhandu bhabhabhoha nyonjeka, nanatu panakahikaje nakapata jejibhi jangu na nyonjeka jaki. ");
INSERT INTO mpa_vpl VALUES ("MT25_28","070_25_28","MAT","25","28","28","Henu, munyaghula mbija heji, na mumpekya jola joabhi nayu mbija komi. ");
INSERT INTO mpa_vpl VALUES ("MT25_29","070_25_29","MAT","25","29","29","Kwa ndandi kila joabhi na chindu anaajonjukiwaje, na kujonjukewa nakanopi. Nambu jola jwangakubha na chindu, hata chela cheabhi nachu anaanyaghulikaje. ");
INSERT INTO mpa_vpl VALUES ("MT25_30","070_25_30","MAT","25","30","30","Mtumika jola jwanga na nyonjeka, mundekala kunja mu lwihi. Konihoku anakubya chilelu na kuyagha mino.’ ");
INSERT INTO mpa_vpl VALUES ("MT25_31","070_25_31","MAT","25","31","31","“Chikahi Mwana waka Mundu paanahikaje ngati nkolongwa mu lujiniku lwaki, na bhatumika bhahuhu bhokapi bha kunani kumahunde, panihapa nde paitama pachitehu cha ukolongwa cha ulumbalilu waki. ");
INSERT INTO mpa_vpl VALUES ("MT25_32","070_25_32","MAT","25","32","32","Bhandu bha inchi yokapi bhalibongana palongi jaki, najombi anaabhalekanisha ngati mdima moalekanashe mambelele na imbuhi yaki. ");
INSERT INTO mpa_vpl VALUES ("MT25_33","070_25_33","MAT","25","33","33","Anaaghabheka mambelele ku chiwoku chaki cha kumalelelu, na imbuhi ku chiwoku chaki cha kumangeja. ");
INSERT INTO mpa_vpl VALUES ("MT25_34","070_25_34","MAT","25","34","34","Panihapa Nkolongwa anaabhapwaghila bhala bhabhabhi ku chiwoku chaki cha kumalelelu, ‘Muhikaje, mwehapa mwempengaliki na Atati wangu, mpwelila ukolongwa ghombekakiwi tayale kutumbu kubhombakeka kwa ndema. ");
INSERT INTO mpa_vpl VALUES ("MT25_35","070_25_35","MAT","25","35","35","Kwa ndandi nakabhi na injala, mkambeki chilebhe. Nakabhi na inywita, mkangengiki machi. Nakabhi nungeni, mkangalibishe. ");
INSERT INTO mpa_vpl VALUES ("MT25_36","070_25_36","MAT","25","36","36","Nakabhi heu, mkanhwatiki ingobhu. Nakabhi nuntamwa, mkahikiki kunilola. Nakabhi muchifungu, mkahikite.’ ");
INSERT INTO mpa_vpl VALUES ("MT25_37","070_25_37","MAT","25","37","37","“Panihapa bhandu bhambone anabhumpwaghila, ‘Bambo, bho, lichobha bhole patukuweni ubhi na injala, tukakulehike, au ukabya na inywita, tukakukengiki machi? ");
INSERT INTO mpa_vpl VALUES ("MT25_38","070_25_38","MAT","25","38","38","Bho, kabheti lile patukuweni ukabya ungeni, tukakukalibishe, au ukabya heu, tukakuwatiki ingobhu? ");
INSERT INTO mpa_vpl VALUES ("MT25_39","070_25_39","MAT","25","39","39","Bho, lile kabheti patukuweni ukabya untamwa, au ukabya muchifungu, tukakuhikile kukubhona?’ ");
INSERT INTO mpa_vpl VALUES ("MT25_40","070_25_40","MAT","25","40","40","Nkolongwa akayangiki, ‘Numpwaghila, chakaka, kila chindu chemukamhengi jumu wa bhalongu bhangu bhachoku abhabha, mkanihengi nepani!’ ");
INSERT INTO mpa_vpl VALUES ("MT25_41","070_25_41","MAT","25","41","41","“Bhela akabhapwaghi bhala bhabhabhi ku chiwoku chaki cha kumangeja, ‘Mbokanya kwangu mwehapa mwempatiki masolu. Njendanya mu moto wa mileli ghoabhekakiwi Shetani papamu na bhatumika bhaki. ");
INSERT INTO mpa_vpl VALUES ("MT25_42","070_25_42","MAT","25","42","42","Kwa ndandi nakabhi na injala, ngachemwambeki chilebhe. Nakabhi na inywita, ngachemwangengiki machi. ");
INSERT INTO mpa_vpl VALUES ("MT25_43","070_25_43","MAT","25","43","43","Nakabhi nungeni, ngachemwangalibishe. Nakabhi heu, ngachemwanhwatiki ingobhu. Nakabhi nuntamwa, na muchifungo, ngachemwahikiki kunilola.’ ");
INSERT INTO mpa_vpl VALUES ("MT25_44","070_25_44","MAT","25","44","44","“Panihapa na bhombi bhiyangaje, ‘Bambo, bho lichobha bhole patukuweni wehapa ukabya na injala, au ukabya na inywita, au ukabya ungeni, au ukabya heu, au ukabya umtamwa, au ukabya muchifungo, na tepanu ngachetukakujangatile?’ ");
INSERT INTO mpa_vpl VALUES ("MT25_45","070_25_45","MAT","25","45","45","Nkolongwa akabhayangiki, ‘Chakaka numpwaghila, kila pankanika kumuhengela mambu aghagha jumu wabhu wa bhachoku abhabha, mkakaniki kunihengela nepani.’ ");
INSERT INTO mpa_vpl VALUES ("MT25_46","070_25_46","MAT","25","46","46","Bhombi anabhajenda kujingila mu mang'ahiku gha mileli, nambu bhandu bhambone bhala anabhajenda mu womi wa mileli.” ");
INSERT INTO mpa_vpl VALUES ("MT26_1","070_26_1","MAT","26","1","1","Yesu paakajomwi kulonge mambu ghanihagha ghokapi, akabapwaghi bhabhulwa bhaki, ");
INSERT INTO mpa_vpl VALUES ("MT26_2","070_26_2","MAT","26","2","2","“Mmanyi kubha machobha ghabheli ghaghahika kwibya na Uwangalalu wa Pasaka, na Mwana waka Mundu anaabhohakikaje nahuli awambakikaje punsalaba.” ");
INSERT INTO mpa_vpl VALUES ("MT26_3","070_26_3","MAT","26","3","3","Chikahi hechi bhapenganyambiku bhakolongwa, bhalemba, na bhazee bha bhandu, bhakalibhongini paliwangala laka mpenganyambiku nkolongwa, lihina laki Kayafa. ");
INSERT INTO mpa_vpl VALUES ("MT26_4","070_26_4","MAT","26","4","4","Bhakajetanganili papamu ntundu wa kunkamula Yesu kwa kulihiya, na bhunkomaje. ");
INSERT INTO mpa_vpl VALUES ("MT26_5","070_26_5","MAT","26","5","5","Nambu bhakapwaghiki, “Ngaikubha chikahi cha uwangalalu la pasaka, ngakwihika kupitalila fujo pachilanda ja bhandu.” ");
INSERT INTO mpa_vpl VALUES ("MT26_6","070_26_6","MAT","26","6","6","Chikahi Yesu paakabhi ku Besania, kunyumba jaka Simoni joakabhi na chitamu cha malohi, ");
INSERT INTO mpa_vpl VALUES ("MT26_7","070_26_7","MAT","26","7","7","akahikiki mbomba jumu akabya anyamwi libotolu lelalenganakiki kwa liganga la alabasta lelibhi na mahuta gha mbija jamaheli, na kughajitila pamutu jaka Yesu koni akabya atami pa chilebhe. ");
INSERT INTO mpa_vpl VALUES ("MT26_8","070_26_8","MAT","26","8","8","Bhabhulwa bhaka Yesu pabhaweni, bhakahakalili na kupwagha, “Bho, maghambu kiki kuhobheha manungilu aghagha waka?” ");
INSERT INTO mpa_vpl VALUES ("MT26_9","070_26_9","MAT","26","9","9","“Manungilu aghagha ghakabya ghalombasiki kwa mbija jamaheli, na kubhapekeha bhahochu mbija yene!” ");
INSERT INTO mpa_vpl VALUES ("MT26_10","070_26_10","MAT","26","10","10","Yesu akamanyi maholalelu ghabhu, akabhapwaghile, “Bho, mbona mung'aha mbomba ajoju? Anihengi lijambu lamboni namaa. ");
INSERT INTO mpa_vpl VALUES ("MT26_11","070_26_11","MAT","26","11","11","Kwa ndandi bhahochu mbi nabhu papamu machobha ghokapi, nambu nepanu ngangubhi papamu na mwehapa machobha ghokapi. ");
INSERT INTO mpa_vpl VALUES ("MT26_12","070_26_12","MAT","26","12","12","Kwa ndandi kwa kunyitalila hyegha jangu mahuta ghaghanungi wichu aghagha, ahengiki bhenibhela kwa kujilenganakela yegha jangu kwa kutaghakika kwangu. ");
INSERT INTO mpa_vpl VALUES ("MT26_13","070_26_13","MAT","26","13","13","Numpwaghi chakaka, pandu pokapi Malobhi Manyahi paghitangazwaje pundema wokapi, lihengu aleli leahengiki mbomba ajoju anabhaliloghulaje kwa kunkomboka jombi.” ");
INSERT INTO mpa_vpl VALUES ("MT26_14","070_26_14","MAT","26","14","14","Bhela Yuda Isikalioti, jumu wa bhabhulwa komi na bhabheli bhala, akapiti kwa bhapenganyambiku bhakolongwa, ");
INSERT INTO mpa_vpl VALUES ("MT26_15","070_26_15","MAT","26","15","15","na kupwagha, “Bho, anambekya chindu bhole, ngati ananumpeki Yesu kwinu?” Bhakambalangili ipandi selasini ya madini gha feza. ");
INSERT INTO mpa_vpl VALUES ("MT26_16","070_26_16","MAT","26","16","16","Kutumbu chikahi chenihechi, Yuda akabhi alonda mbekenyu ja kung'anambuka Yesu. ");
INSERT INTO mpa_vpl VALUES ("MT26_17","070_26_17","MAT","26","17","17","Lichobha la kutumbula la Uwangalalu wa Mabumunda Gangakujegaleka Amila, bhabhulwa bhakapiti kwaka Yesu na kundalukila, “Bho, upala tukakuandalya kwaku chilebhi cha Pasaka?” ");
INSERT INTO mpa_vpl VALUES ("MT26_18","070_26_18","MAT","26","18","18","Yesu akayangiki, “Njendanya kumbwane kwaka mundu jumu, mukumpwaghilaje, ‘Mbola apwagha, chikahi changu chiheghalile, anangula Pasaka kwaku papamu na bhabhulwa bhangu kunyumba jako.’ ” ");
INSERT INTO mpa_vpl VALUES ("MT26_19","070_26_19","MAT","26","19","19","Bhabhulwa bhakahengiki ngati Yesu moakabhalagalakile, bhakaandi chilebhi cha Pasaka. ");
INSERT INTO mpa_vpl VALUES ("MT26_20","070_26_20","MAT","26","20","20","Pakukabhi pakamihi, Yesu akatami kula chilebhi papamu na bhabhulwa bhaki komi na bhabheli bhala. ");
INSERT INTO mpa_vpl VALUES ("MT26_21","070_26_21","MAT","26","21","21","Pabakabhi bhakula, Yesu akapwaghite, “Numpwaghi chakaka, jumu winu anaaning'anambukaje.” ");
INSERT INTO mpa_vpl VALUES ("MT26_22","070_26_22","MAT","26","22","22","Bhabhulwa bhala ukabhakabiniki ntima namaa, na bhakatumbwi kundalukila jumu jumu, “Bambo, bho, nepani lelo?” ");
INSERT INTO mpa_vpl VALUES ("MT26_23","070_26_23","MAT","26","23","23","Yesu akayangiki, “Jola joatobhalile libumunda papamu na nepani mu chikombe, jonihoju nde joaning'anambukaje. ");
INSERT INTO mpa_vpl VALUES ("MT26_24","070_26_24","MAT","26","24","24","Mwana waka Mundu ajenda ngati moilembakike mu Malembu Mahuhu, nambu anaachibhonaje mundu jola joang'anambuka Mwana waka Mundu! Ikabya mbanga kwaka mundu hoju ngati ngaakabhelakike.” ");
INSERT INTO mpa_vpl VALUES ("MT26_25","070_26_25","MAT","26","25","25","Yuda, jola joang'anambwiki, akundalukile, “Mbola, bho, nepani lelo?” Yesu akayangiki, “Wehapa ujomwi kupwagha.” ");
INSERT INTO mpa_vpl VALUES ("MT26_26","070_26_26","MAT","26","26","26","Pabhakabhi bhakula, Yesu akatoliki libumunda, akalipengalili, akalihekiki, na kubhapekeha bhabhulwa bhaki, akapwagha, “Mtolaje, mkulaje, jenjenu nde hyegha jangu.” ");
INSERT INTO mpa_vpl VALUES ("MT26_27","070_26_27","MAT","26","27","27","Akachitoliki chikombi, akunchengwi Chapanga, na kubhapekeha, akapwagha, “Mkunywaje mabhokapi mu chikombi chenjenu, ");
INSERT INTO mpa_vpl VALUES ("MT26_28","070_26_28","MAT","26","28","28","kwa ndandi ghongoni nde mwahi wangu wa Lulaghilu lwa chakaka, mwahi ghoujitika kwa ndandi ja kubhoha mahoku gha bhandu bhamaheli. ");
INSERT INTO mpa_vpl VALUES ("MT26_29","070_26_29","MAT","26","29","29","Nambu numpwaghila, ngangunywi kabheti divai ja zabibu, mbaka lichobha lela panikunywa divai jahenu papamu na mwehapa mu Ukolongwa wa Atati wangu.” ");
INSERT INTO mpa_vpl VALUES ("MT26_30","070_26_30","MAT","26","30","30","Pabhakajomwi kujemba nyembu ja kundumbali Chapanga, bhakapitiki kunja na kujenda ku Chitombi cha Mizeituni. ");
INSERT INTO mpa_vpl VALUES ("MT26_31","070_26_31","MAT","26","31","31","Bhela Yesu akabhapwaghile, “Lalenu ikilu mwehapa mabhokapi anamndilaje, kwa ndandi Malembu Mahuhu ghapwagha, ‘Ananundapula mdima, na mambeleli gha lipogha ghitenda kupechangana.’ ");
INSERT INTO mpa_vpl VALUES ("MT26_32","070_26_32","MAT","26","32","32","Nambu ananyomwi kuhyoka, ananundongulya kujenda ku Galilaya.” ");
INSERT INTO mpa_vpl VALUES ("MT26_33","070_26_33","MAT","26","33","33","Petulu akayangiki, “Hata ngati bhokapi anabhakulekiki, nepanu nganakuleki ng'o.” ");
INSERT INTO mpa_vpl VALUES ("MT26_34","070_26_34","MAT","26","34","34","Yesu akumpwaghile, “Nukupwaghi chakaka, wehapa, ikilu ja lalenu mangani ja kubheka likongobhe, wingana mala patatu.” ");
INSERT INTO mpa_vpl VALUES ("MT26_35","070_26_35","MAT","26","35","35","Petulu akayangiki, “Hata ngati imbalika kupotela papamu na wehapa, nganakuleki ng'o.” Na bhabhulwa bhokapi bhakapwaghiki bhelabhela. ");
INSERT INTO mpa_vpl VALUES ("MT26_36","070_26_36","MAT","26","36","36","Bhela Yesu akapiti papamu na bhabhulwa bhaki mbaka pandu papalowakeka Gethemane, na kubhapwaghi bhabhulwa bhaki, “Mtamanya pambane, nepanu nyenda palongi nakanopi kundobha Chapanga.” ");
INSERT INTO mpa_vpl VALUES ("MT26_37","070_26_37","MAT","26","37","37","Akuntoliki Petulu papamu na bhana bhabheli bhaka Zebedayo, na akatumbwi kubha na mabhinilu na kungajika. ");
INSERT INTO mpa_vpl VALUES ("MT26_38","070_26_38","MAT","26","38","38","Panihapa akabhapwaghile, “Mi na mabhinilu makolongwa muntima jangu hata pambipi kupotela. Ntamanya pambani na mkeshaje papamu na nepani.” ");
INSERT INTO mpa_vpl VALUES ("MT26_39","070_26_39","MAT","26","39","39","Bhela akajendali palongi pachokopi, akaabwiki ukutama, na kundobha Chapanga, akapwagha, “Atati wangu, ngati anaiwezikana, chikombi chenjenu cha mang'ahiku chimbetaje. Nambu ngakwikubha ngati mombalila nepanu, nambu ngati moupali wehapa.” ");
INSERT INTO mpa_vpl VALUES ("MT26_40","070_26_40","MAT","26","40","40","Akakelawiki kwa bhabhulwa bhala, na kubhahimani bhaghochile. Akumpwaghi Petulu, “Bho, ngachemwaweziki kutama mihu na nepanu hata lisaa limu? ");
INSERT INTO mpa_vpl VALUES ("MT26_41","070_26_41","MAT","26","41","41","Mtama mihu, na mlobhaje ngamwihika kujingi mu malengakeku. Roho jipala nambu hyegha ngachejibhi na makili.” ");
INSERT INTO mpa_vpl VALUES ("MT26_42","070_26_42","MAT","26","42","42","Yesu akapiti kabheti pakabheli kundobha Chapanga, “Atati wangu, anangati ngacheiwezikana chikombi achechi cha mang'ahiku chimbetaje pangakunywelela, mapalu ghaku ghapitalyaje.” ");
INSERT INTO mpa_vpl VALUES ("MT26_43","070_26_43","MAT","26","43","43","Akakelabwiki kabheti, na kubhahimani bhaghochile, kwa ndandi mihu ghabhu ghakatweli lughono. ");
INSERT INTO mpa_vpl VALUES ("MT26_44","070_26_44","MAT","26","44","44","Akabhalekiki kabheti, na kujenda kundobha Chapanga pakatatu, koni akapwagha malobhi ghalaghala. ");
INSERT INTO mpa_vpl VALUES ("MT26_45","070_26_45","MAT","26","45","45","Bhela akakelabwiki kabheti kwa bhabhulwa bhaki, na kubhapwaghila, “Bho, mwakali kughochela na kupomulela? Mlingalya, chikahi chihikite, na Mwana waka Mundu anaajeghalika mu mabhoku gha bhabhabhi na mahoku. ");
INSERT INTO mpa_vpl VALUES ("MT26_46","070_26_46","MAT","26","46","46","Njumukaje, na tumbokanyaje. Ndingalya, jola joaying'anambukaje ahika!” ");
INSERT INTO mpa_vpl VALUES ("MT26_47","070_26_47","MAT","26","47","47","Bhela, Yesu paakabhi akali kulongela nabhu, palapala akahikiki Yuda, jumu wa bhabhulwa komi na bhabheli bhala. Papamu naku lakabhi lipogha likolongwa bhanyamwi mapanga na indonga, bhakabya bhahumiki kwa bhapenganyambiku bhakolongwa na bhazee bha bhandu. ");
INSERT INTO mpa_vpl VALUES ("MT26_48","070_26_48","MAT","26","48","48","Jola joapalika kung'anambuka Yesu jola akajomwi kubhapekeha nginyulila kubha, “Jola jonambuswaje, jonihoju nde jombi, munkamulaje!” ");
INSERT INTO mpa_vpl VALUES ("MT26_49","070_26_49","MAT","26","49","49","Bhela, Yuda akamuheghali Yesu, na kupwagha, “Monile, Mbola!” Na kumbusu. ");
INSERT INTO mpa_vpl VALUES ("MT26_50","070_26_50","MAT","26","50","50","Yesu akamuyangiki, “Nkoche, uhenga lela leuhiki kulihenga.” Panihapa bhandu bhala bhakapiti, na kuhatambula mabhoku ghabhu, na kunkamula na kunkonga. ");
INSERT INTO mpa_vpl VALUES ("MT26_51","070_26_51","MAT","26","51","51","Lingalya, jumu wa bhala bhabhakabhi papamu na Yesu akaholapwi lipanga laki, na kundapula mtumika waka Mpenganyambiku Nkolongwa, na kuncheku likutu. ");
INSERT INTO mpa_vpl VALUES ("MT26_52","070_26_52","MAT","26","52","52","Panihapa Yesu akumpwaghile, “Ukelabhuha lipanga laku pandu paki. Kwa ndandi jokapi joatumi lipanga, anaapotila kwa lipanga. ");
INSERT INTO mpa_vpl VALUES ("MT26_53","070_26_53","MAT","26","53","53","Bho, uholake kubha nepanu ngachenhweza kundobha Atati wangu, najombi akabya anetile sajenu manjolinjoli mapogha komi na ghabheli nakanopi gha bhatumika bha kunani kwaka Chapanga? ");
INSERT INTO mpa_vpl VALUES ("MT26_54","070_26_54","MAT","26","54","54","Nambu ngati ananhengiki bhenibhela, bho, anaghapitalya bhole Malembu Mahuhu ghala ghaghapwagha kubha ipalika mambu aghagha ghapitalyaje?” ");
INSERT INTO mpa_vpl VALUES ("MT26_55","070_26_55","MAT","26","55","55","Chikahi hechi Yesu akabhapwaghi lipogha la bhandu bhabhakahikiki kunkamula, “Bho, muhikiki kungamula kwa mapanga na indonga ngati nepani nde mnyaghula? Machobha ghokapi ndamika mu liwangala la Nyumba jaka Chapanga koni nakabholaje, na ngachemwangamwile. ");
INSERT INTO mpa_vpl VALUES ("MT26_56","070_26_56","MAT","26","56","56","Nambu mambu aghagha ghokapi ghahengakiki, nahuli Malembu Mahuhu gha bhalota bhaka Chapanga ghapitalyaje.” Panihapa bhabhulwa bhokapi bhakundekiki, na kutila. ");
INSERT INTO mpa_vpl VALUES ("MT26_57","070_26_57","MAT","26","57","57","Bhela, bhabhunkamwi Yesu bhakumpeliki kunyumba jaka Kayafa, joakabhi Mpenganyambiku Nkolongwa, kobhakabhii bhalibhongini bhalemba na bhazee bha bhandu. ");
INSERT INTO mpa_vpl VALUES ("MT26_58","070_26_58","MAT","26","58","58","Nambu Petulu akunjengalili cha kutali mbaka pa liwangala laka Mpenganyambiku Nkolongwa, akajingi mkati, na kutama papamu na bhalonda, nahuli alola mambu moghijomukyaje. ");
INSERT INTO mpa_vpl VALUES ("MT26_59","070_26_59","MAT","26","59","59","Bhela, bhapenganyambiku bhakolongwa, papamu na chengu chokapi, bhakalondiki ulandilu wa icholi panani jaka Yesu, nahuli bhapata kunkoma, ");
INSERT INTO mpa_vpl VALUES ("MT26_60","070_26_60","MAT","26","60","60","nambu ngachebhakuweni ulandilu wokapi, hata koni bhakahikiki bhalandilu bhamaheli bha icholi. Pakujomukela bhakahikiki bhalandila bhabheli, ");
INSERT INTO mpa_vpl VALUES ("MT26_61","070_26_61","MAT","26","61","61","na kupwagha, “Mundu ajoju akapwaghiki, ‘Nhweza kujibombo Nyumba jaka Chapanga, na kujichenga kabheti kwa machobha ghatatu.’ ” ");
INSERT INTO mpa_vpl VALUES ("MT26_62","070_26_62","MAT","26","62","62","Henu Mpenganyambiku Nkolongwa akajemiki, na kundaluki Yesu, “Bho, ngacheuyanga lilobhi? Bho, bhandu abhabha bhukutaki kyani panani jaku?” ");
INSERT INTO mpa_vpl VALUES ("MT26_63","070_26_63","MAT","26","63","63","Nambu Yesu akatumbi chinunu. Mpenganyambiku Nkolongwa akumpwaghile, “Nukulapisha kwaka Chapanga joabhi mwome, utupwaghilaje ngati wehapa nde wa Kristo, Mwana waka Chapanga.” ");
INSERT INTO mpa_vpl VALUES ("MT26_64","070_26_64","MAT","26","64","64","Yesu akumpwaghile, “Wehapa upwaghite. Nambu numpwaghila, kutumbu sajenu anamumbona Mwana waka Mundu atemi ku chiwoku cha kumalelelu chaka Chapanga mwene makili, na akahika panani ja mahundi gha kunani kumahunde.” ");
INSERT INTO mpa_vpl VALUES ("MT26_65","070_26_65","MAT","26","65","65","Panihapa Mpenganyambiku Nkolongwa akakachwili ingobhu yaki, koni akapwagha, “Atehi kutondola! Bho, tupala kabheti ulandilu ghongi wa kyane? Sajenu njowini kutondoka kwaki. ");
INSERT INTO mpa_vpl VALUES ("MT26_66","070_26_66","MAT","26","66","66","Bho, mwanganya muholale bhole?” Bhombi bhakayangiki, “Impalika kupotela.” ");
INSERT INTO mpa_vpl VALUES ("MT26_67","070_26_67","MAT","26","67","67","Panihapa bhakamuhuni imata kumihu, bhakundapwi ngumi, na bhangi bhakumbangwi maghanja, ");
INSERT INTO mpa_vpl VALUES ("MT26_68","070_26_68","MAT","26","68","68","koni bhakapwaghaje, “We Kristo, ulotilaje, bho, nane joakulapwile?” ");
INSERT INTO mpa_vpl VALUES ("MT26_69","070_26_69","MAT","26","69","69","Petulu akabhi atemi kunja kuliwangala. Mtumika jumu wa chimbomba akunjendili, na kupwagha, “Wehapa nanau ukabhi papamu na Yesu wa ku Galilaya.” ");
INSERT INTO mpa_vpl VALUES ("MT26_70","070_26_70","MAT","26","70","70","Petulu akakaniki palongi ja bhandu bhokapi, koni akapwagha, “Ngachenimanyi cheulongela.” ");
INSERT INTO mpa_vpl VALUES ("MT26_71","070_26_71","MAT","26","71","71","Paakabhi apita pundyangu, mtumika jongi wa chimbomba akumbweni, na akabhapwaghi bhandu bhabhakabhi panihapa, “Mundu ajoju akabhi papamu na Yesu wa ku Nazaleti.” ");
INSERT INTO mpa_vpl VALUES ("MT26_72","070_26_72","MAT","26","72","72","Petulu akakaniki kabheti kwa kulapa, “Ngachenummanyi mundu ajoju.” ");
INSERT INTO mpa_vpl VALUES ("MT26_73","070_26_73","MAT","26","73","73","Palongi pachokopi, bhandu bhabhakabhi panipala bhakunjendi Petulu, na kumpwaghila, “Chakaka, wehapa nde jumu wabhu, kwa ndandi hata kulongela kwaku kukulangiha.” ");
INSERT INTO mpa_vpl VALUES ("MT26_74","070_26_74","MAT","26","74","74","Panihapa Petulu akatumbwi kusola na kulapa, koni akapwagha, “Ngachenummanyi mundu hoju.” Palapala likongobhi likabekite. ");
INSERT INTO mpa_vpl VALUES ("MT26_75","070_26_75","MAT","26","75","75","Petulu akalikombwiki lilobhi lela leakalongi Yesu, “Mangani ja likongobhi kubheka, wingana mala patatu.” Bhela akapitiki kunja, na kulela kwa mabhinilu. ");
INSERT INTO mpa_vpl VALUES ("MT27_1","070_27_1","MAT","27","1","1","Pakwahiki lukela, bhapenganyambiku bhakolongwa, na bhazee bha bhandu bhakahimangini kulongela nahuli bhapata kunkoma Yesu. ");
INSERT INTO mpa_vpl VALUES ("MT27_2","070_27_2","MAT","27","2","2","Bhakunkongiki minyololu, bhakuntoliki na kumpeleka kwaka Pilato, nkolongwa wa Kiloma. ");
INSERT INTO mpa_vpl VALUES ("MT27_3","070_27_3","MAT","27","3","3","Panihapa Yuda, jola joakang'anambwike, paakaweni kubha bhajomwi kuntemula Yesu, ukambiniki mtima namaa, akabhakelabhuki bhapenganyambiku bhakolongwa na bhazee ipandi selasini ya madini gha feza yela, ");
INSERT INTO mpa_vpl VALUES ("MT27_4","070_27_4","MAT","27","4","4","koni akapwagha, “Ndehi mahoku kwa kung'anambuka mundu jwanga na lihakau.” Nambu bhombi bhakayangike, “Bho, tepani tutenda kike? Leniheli umanya wamwete.” ");
INSERT INTO mpa_vpl VALUES ("MT27_5","070_27_5","MAT","27","5","5","Yuda akaileki ipandi ya madini gha feza yela pa Nyumba jaka Chapanga, akabokiki, na kujenda kulikongela. ");
INSERT INTO mpa_vpl VALUES ("MT27_6","070_27_6","MAT","27","6","6","Bhapenganyambiku bhakolongwa bhakaitoliki ipandi ya mbjija yela, na kupwagha, “Ngacheipalika kuibheka mu chikoku cha nyambiku, kwa ndandi nde mbija yeipatakini kwa kukoma.” ");
INSERT INTO mpa_vpl VALUES ("MT27_7","070_27_7","MAT","27","7","7","Bhela bhakajetanganili, na bhakaitumi kwa kuhemela ngonda wa lutopi, lubya pandu pa kubhataghi bhaghene. ");
INSERT INTO mpa_vpl VALUES ("MT27_8","070_27_8","MAT","27","8","8","Nde ndandi mbaka lalenu ngonda hoghu ulowakeka, “Ngonda wa mwahi.” ");
INSERT INTO mpa_vpl VALUES ("MT27_9","070_27_9","MAT","27","9","9","Panihapa nde ghakapitali malobhi ghaka mlota Yelemia, “Bhakaitoliki ipandi selasini ya mbija, malepu ghaka jola ambaju Bhaizilaeli bhakajetakili kulepa, ");
INSERT INTO mpa_vpl VALUES ("MT27_10","070_27_10","MAT","27","10","10","na kuitumila kwa kuhemela ngonda wa lutopi, ngati Bambo moakalaghalakile.” ");
INSERT INTO mpa_vpl VALUES ("MT27_11","070_27_11","MAT","27","11","11","Yesu akajemiki palongi jaka nkolongwa wa ku Loma joakabhi nkolongwa wa mkoa. Bhela nkolongwa hoju akundalukile, “Bho, wehapa le unkolongwa wa Bhayahude?” Yesu akamuyangiki, “Wehapa upwaghike.” ");
INSERT INTO mpa_vpl VALUES ("MT27_12","070_27_12","MAT","27","12","12","Nambu bhapenganyambiku bhakolongwa papamu na bhazee, pabhakuntakile ngacheakayangiki lilobhi. ");
INSERT INTO mpa_vpl VALUES ("MT27_13","070_27_13","MAT","27","13","13","Panihapa Pilato akumpwaghile, “Bho, ngacheujowana mambu ghanihagha ghokapi ghabhukutaki nagho?” ");
INSERT INTO mpa_vpl VALUES ("MT27_14","070_27_14","MAT","27","14","14","Nambu Yesu ngacheakayangiki lilobhi hata limu, na nkolongwa wa ku Loma hoju akakangichi namaa. ");
INSERT INTO mpa_vpl VALUES ("MT27_15","070_27_15","MAT","27","15","15","Bhela kila chikahi cha Uwangalalu wa Pasaka, nkolongwa wa Kiloma akabhi na ntetu wa kumbopulela mkongeka jumu jobhumpala bhandu. ");
INSERT INTO mpa_vpl VALUES ("MT27_16","070_27_16","MAT","27","16","16","Chikahi hechi akabhi mkongeka jumu joakamanyakini namaa, lihina laki Balaba. ");
INSERT INTO mpa_vpl VALUES ("MT27_17","070_27_17","MAT","27","17","17","Bhela pabhakalibhongini, Pilato akabhapwaghile, “Bho, mpala numbopulya nane? Numbopulya Balaba, au Yesu joalowakeka Kristo?” ");
INSERT INTO mpa_vpl VALUES ("MT27_18","070_27_18","MAT","27","18","18","Kwa ndandi akamanyiki kubha bhakundetiki Yesu kwaki kwa ndandi ja wihu wa bhakolongwa bha Bhayahude. ");
INSERT INTO mpa_vpl VALUES ("MT27_19","070_27_19","MAT","27","19","19","Chikahi Pilato paakatemi pachitehu chaki cha utemulu, nhwanu waki akumpelaki ubholu, na kumpwaghila, “Ngawikubha na lilobhi lokapi lela na mundu wambone. Kwa ndandi lalenu ng'ahakiki namaa mu ndoto kwa ndandi jaki.” ");
INSERT INTO mpa_vpl VALUES ("MT27_20","070_27_20","MAT","27","20","20","Bhapenganyambiku bhakolongwa papamu na bhazee bhakabhapwaghi lipogha la bhandu nahuli bhunjopa Balaba abhopuliwaje, na bhunkoma Yesu. ");
INSERT INTO mpa_vpl VALUES ("MT27_21","070_27_21","MAT","27","21","21","Pilato akabhalalukile, “Bho, mpala numbopulya nane pachilanda ja bhabheli abhabha?” Bhakayangiki, “Balaba.” ");
INSERT INTO mpa_vpl VALUES ("MT27_22","070_27_22","MAT","27","22","22","Pilato akabhalalukile, “Bho, henu nhenga kiki na Yesu joalowakeka Kristo?” Bhokapi bhakayangiki, “Unhwambaje punsalaba!” ");
INSERT INTO mpa_vpl VALUES ("MT27_23","070_27_23","MAT","27","23","23","Nambu Pilato akabhalalukile, “Bho, kwa ndandi ja kike? Bho, ahengiki lihoku bhole?” Nambu bhombi bhakajendali kujamalila, koni bhakapwaghaje, “Unhwambaje punsalaba!” ");
INSERT INTO mpa_vpl VALUES ("MT27_24","070_27_24","MAT","27","24","24","Bhela Pilato paakaweni kubha njeta chindu chengi cheaweza kutenda, na njobhela ijonjukeka, akatoliki machi, na kuchamba mabhoku ghaki palongi ja lipogha lokapi, koni akapwaghaje, “Nepani ngachemi na lihoku panani ja mwahi waka mundu ajoju wambone, mmanya mabhete!” ");
INSERT INTO mpa_vpl VALUES ("MT27_25","070_27_25","MAT","27","25","25","Bhandu bhokapi bhakayangiki, bhakapwaghaje, “Mwahi waki na ubya panani jitu, na panani ja bhana bhitu!” ");
INSERT INTO mpa_vpl VALUES ("MT27_26","070_27_26","MAT","27","26","26","Panihapa akabhabhopuli Balaba, na paakalaghalaki Yesu bhundapula iboku, akumbohiki nahuli awambakikaje punsalaba. ");
INSERT INTO mpa_vpl VALUES ("MT27_27","070_27_27","MAT","27","27","27","Panihapa manjolinjoli bhaka Pilato bhakumpeliki Yesu mu nyumba ja kikolongwa jaka Pilato, na kulibhongana manjolinjoli bhokapi kumuyongolota Yesu. ");
INSERT INTO mpa_vpl VALUES ("MT27_28","070_27_28","MAT","27","28","28","Bhakamuhuliki ingobhu yaki, na kumuwatika ingobhu jikeli ngati nkolongwa. ");
INSERT INTO mpa_vpl VALUES ("MT27_29","070_27_29","MAT","27","29","29","Bhakalokiki litaji la miha, bhakunhwatiki pamutu jaki, na kumbekela ndahi mu chiwoku chaki cha kumalelelu. Bhakachikimi palongi jaki, bhakundongimi, bhakapwaghaje, “Monile, Unkolongwa wa Bhayahude!” ");
INSERT INTO mpa_vpl VALUES ("MT27_30","070_27_30","MAT","27","30","30","Bhakunhuni imata, bhakautoliki ndahi ghola, na kundapula naghu pamutu. ");
INSERT INTO mpa_vpl VALUES ("MT27_31","070_27_31","MAT","27","31","31","Pabhakajomwi kundongama, bhakajihuliki ingobhu jela, bhakamuwatiki ingobhu jaki, na kumpeleka kumuwamba punsalaba. ");
INSERT INTO mpa_vpl VALUES ("MT27_32","070_27_32","MAT","27","32","32","Pabhakabhi bhajenda, bhakumbweni mundu jumu Mkilene, lihina laki Simoni. Jonihoju bhakuntwekiki msalaba waka Yesu kwa makili. ");
INSERT INTO mpa_vpl VALUES ("MT27_33","070_27_33","MAT","27","33","33","Pabhakahikiki pandu papalowakeka Goligota, ndandi jaki, Lifuvu la Mmutu, ");
INSERT INTO mpa_vpl VALUES ("MT27_34","070_27_34","MAT","27","34","34","bhakumpeki Yesu kunywa divai jejihangaghini na chindu chibhabha. Nambu jombi paakajionjiki, akakaniki kunywa. ");
INSERT INTO mpa_vpl VALUES ("MT27_35","070_27_35","MAT","27","35","35","Pabhakajomwi kunhwamba punsalaba, bhakaghabhini ingobhu yaki, kwa kuilapulila kula. Nahuli ghapitalya malobhi ghaakapwaghiki mlota waka Chapanga, “Bhakaghabhini ingobhu yangu ya kunja, na kanzu jangu ja mkati bhakajilapuli kula.” ");
INSERT INTO mpa_vpl VALUES ("MT27_36","070_27_36","MAT","27","36","36","Bhela bhakatemi pahi, koni bhakabya bhundenda. ");
INSERT INTO mpa_vpl VALUES ("MT27_37","070_27_37","MAT","27","37","37","Panani ja mmutu waki, punsalaba, bhakalembiki litakilu laki, “Ajoju nde Yesu, Nkolongwa wa Bhayahude.” ");
INSERT INTO mpa_vpl VALUES ("MT27_38","070_27_38","MAT","27","38","38","Chikahi chenihechi bhakongeka bhabheli bhanyaghula bhakawambakiki papamu na Yesu, jumu ku chiwoku chaki cha kumalelelu, na jongi ku chiwoku chaki cha kumangeja. ");
INSERT INTO mpa_vpl VALUES ("MT27_39","070_27_39","MAT","27","39","39","Bhandu bhabhakabhi bhapeta mwindela bhakuntondwile, koni bhakanyuha mimutu jabhu, na kupwagha. ");
INSERT INTO mpa_vpl VALUES ("MT27_40","070_27_40","MAT","27","40","40","“Wehapa, weupwaghika uweza kujiyonanga Nyumba jaka Chapanga na kuchenga kwa machobha ghatatu, ulikengalya wamwete. Ana ngati wehapa wa Mwana waka Chapanga, uhuluka punsalaba hapa!” ");
INSERT INTO mpa_vpl VALUES ("MT27_41","070_27_41","MAT","27","41","41","Bhelabhela, bhapenganyambiku bhakolongwa papamu na bhalemba bha Shelia na bhazee, bhakundongimi bhakapwaghaje, ");
INSERT INTO mpa_vpl VALUES ("MT27_42","070_27_42","MAT","27","42","42","“Akabhakengali bhangi, nambu ngacheaweza kulikengalela mweni. Ana ngati jombi nde Nkolongwa wa Izilaeli, ahuluka punsalaba, na tepanu anatunhobhalyaje! ");
INSERT INTO mpa_vpl VALUES ("MT27_43","070_27_43","MAT","27","43","43","Anhobhale Chapanga, na kupwagha eti jombi nde Mwana waka Chapanga, bhela Chapanga ankengalya sajenu, ngati anaampala.” ");
INSERT INTO mpa_vpl VALUES ("MT27_44","070_27_44","MAT","27","44","44","Bhanyaghula bhabhawambakiki papamu naku bhala, bhakuntondwi kwa indela jejeji. ");
INSERT INTO mpa_vpl VALUES ("MT27_45","070_27_45","MAT","27","45","45","Kutumbu chikahi cha saa sita mbaka saa tisa, inchi jokapi jakabhi lwihi. ");
INSERT INTO mpa_vpl VALUES ("MT27_46","070_27_46","MAT","27","46","46","Ngati saa tisa, Yesu akajamalili sauti jaki kwa makili, akapwagha, “Eloi, Eloi, lama sabakitani?” Ndandi jaki, “Chapanga wangu, Chapanga wangu, mbona unehile?” ");
INSERT INTO mpa_vpl VALUES ("MT27_47","070_27_47","MAT","27","47","47","Nambu bhandu bhakumu bhala bhabhakabhi bhajemani panihapa, pabhakajowini ghanihagha, bhakapwaghite, “Andoha Eliya!” ");
INSERT INTO mpa_vpl VALUES ("MT27_48","070_27_48","MAT","27","48","48","Jumu wabhu akakembili imbelu, akatoliki siponji, na kujitwelakela divai jejilolike, na kujibheka pandahi na kumpekeha akunywaje. ");
INSERT INTO mpa_vpl VALUES ("MT27_49","070_27_49","MAT","27","49","49","Bhandu bhangi bhakapwaghiki, “Lendalya, tulolaje ana ngati Eliya ahika kunkengalela!” ");
INSERT INTO mpa_vpl VALUES ("MT27_50","070_27_50","MAT","27","50","50","Yesu paakajamalili kabheti kwa sauti ngolongwa, akahekiti roho jaki. ");
INSERT INTO mpa_vpl VALUES ("MT27_51","070_27_51","MAT","27","51","51","Palapala lipazia la Nyumba jaka Chapanga likakachwiki ipandi ibhele, kutumbu kunani mbaka pahi. Ndema ukanyukike, na maganga ghakakajwike, ");
INSERT INTO mpa_vpl VALUES ("MT27_52","070_27_52","MAT","27","52","52","matengeli ghakahogwike, na hyegha yamaheli ya bhandu bhaka Chapanga bhabhakapotile bhakahyokite. ");
INSERT INTO mpa_vpl VALUES ("MT27_53","070_27_53","MAT","27","53","53","Bhabhakapitiki mumatengeli, paakajomwi Yesu kuhyoka, bhakapiti kujingila mu Muchi Uhuhu, na kubhonikana na bhandu bhamaheli. ");
INSERT INTO mpa_vpl VALUES ("MT27_54","070_27_54","MAT","27","54","54","Bhela nkolongwa wa manjolinjoli na bhala bhabhakabhi bhundenda Yesu, pabhakaweni kunyukanyuka kwa ndema, na mambu ghaghahengakike, bhakajowipi namaa, bhakapwaghaje, “Chakaka, mundu ajoju akabhi Mwana waka Chapanga!” ");
INSERT INTO mpa_vpl VALUES ("MT27_55","070_27_55","MAT","27","55","55","Pakabhi na akambomba bhamaheli panipala bhakalingalya cha kutali. Bhanihabha nde bhala bhabhunjengalya Yesu kuhuma ku Galilaya, na kuntumakila. ");
INSERT INTO mpa_vpl VALUES ("MT27_56","070_27_56","MAT","27","56","56","Papu akabhi Malia Magidalena, Malia mabhu waka Yakobo na Yusufu, na nhwanu waka Zebedayo. ");
INSERT INTO mpa_vpl VALUES ("MT27_57","070_27_57","MAT","27","57","57","Pakwahiki pakamihi, akahikiki mundu jumu mwana hindu yamaheli mwenei wa ku Alimataya, lihina laki Yusufu. Jonihoju najombi akabhi mbulwa waka Yesu. ");
INSERT INTO mpa_vpl VALUES ("MT27_58","070_27_58","MAT","27","58","58","Yusufu akapiti kwaka Pilato, na kunjopa ampekya hyegha jaka Yesu. Bhela Pilato akalaghalaki antolaje. ");
INSERT INTO mpa_vpl VALUES ("MT27_59","070_27_59","MAT","27","59","59","Yusufu akajitoliki hyegha jaka Yesu, na kujiyongalowa ingobhu jinyahi jihuhu, ");
INSERT INTO mpa_vpl VALUES ("MT27_60","070_27_60","MAT","27","60","60","na kujibheka hyegha mulitengeli laki Yusufu lahenu, leakabhi alilenganaki paliganga. Akahingali liganga likolongwa pandyangu wa litengeli, na mweni kubhoka. ");
INSERT INTO mpa_vpl VALUES ("MT27_61","070_27_61","MAT","27","61","61","Panipala akabhi Malia Magidalena, na Malia jongi jola, bhakabhi bhatemi palongi ja litengeli. ");
INSERT INTO mpa_vpl VALUES ("MT27_62","070_27_62","MAT","27","62","62","Chilabhu jaki, yani lichobha la kabheli baada ja Lichobha la Maandaliu gha Lichobha la Sabato, bhapenganyambiku bhakolongwa, na Mafalisayo bhakunjendi Pilato, ");
INSERT INTO mpa_vpl VALUES ("MT27_63","070_27_63","MAT","27","63","63","bhakapwaghike, “Nkolongwa, tukombwiki kubha mpuhi jola akapwaghike, ‘Paghipeta machobha ghatatu anahyokaje.’ ");
INSERT INTO mpa_vpl VALUES ("MT27_64","070_27_64","MAT","27","64","64","Bhela ulaghalakya litengeli lilendakika wichu mbaka lichobha la katatu, ngabhihika bhabhulwa bhaki kunjibha, na kubhapwaghi bhandu kubha ahyokiki kuhuma kwa bhakuwa. Upuhi wa kujomukela anaupeta ghola wa kutumbula.” ");
INSERT INTO mpa_vpl VALUES ("MT27_65","070_27_65","MAT","27","65","65","Pilato akabhapwaghile, “Mbi na bhalenda, njendanya mkalilenda wichu ngati mommanyila.” ");
INSERT INTO mpa_vpl VALUES ("MT27_66","070_27_66","MAT","27","66","66","Bhakapiti, bhakalilendiki litengeli wichu, kwa kulijeghela liganga la pundyangu lela alama, na kubhabheka manjolinjoli bhalendaje. ");
INSERT INTO mpa_vpl VALUES ("MT28_1","070_28_1","MAT","28","1","1","18 Palapetiki Lichobha la Sabato, lukela pachiwombu lichobha lela la Jumapile, Malia Magidalena, na Malia jongi jola bhakapiti kulibhona litengeli. ");
INSERT INTO mpa_vpl VALUES ("MT28_2","070_28_2","MAT","28","2","2","Palapala pakapitali chinyukunyuku chikolongwa cha ndema, kwa ndandi mtumika wa kunani waka Bambo akahelile kuhuma kunani kumahunde, akalihingali liganga la pundyangu lela, na kulitamila panani. ");
INSERT INTO mpa_vpl VALUES ("MT28_3","070_28_3","MAT","28","3","3","Sula jaki jakabhi ngati unang'anu wa chitobhi, na ingobhu yaki ihuhu kupukupu. ");
INSERT INTO mpa_vpl VALUES ("MT28_4","070_28_4","MAT","28","4","4","Bhalonda bha litengeli bhala pabhakumbweni bhakabhaghiji kwa choghohi, na kubha ngati bhabhapotile. ");
INSERT INTO mpa_vpl VALUES ("MT28_5","070_28_5","MAT","28","5","5","Mtumika wa kunani kwaka Chapanga jola akabhapwaghi akambomba bhala, “Mwehapa ngamwijogopa! Kwa ndandi manyi kubha mundonda Yesu, joakawambakike punsalaba. ");
INSERT INTO mpa_vpl VALUES ("MT28_6","070_28_6","MAT","28","6","6","Ngacheabhi pambane, kwa ndandi ahyokike ngati moakapwaghile. Muhikaje pambani mupabhona pandu pabhakungoniki Bambo. ");
INSERT INTO mpa_vpl VALUES ("MT28_7","070_28_7","MAT","28","7","7","Bhela njendanya manyata, mkabhapwaghila bhabhulwa bhaki, ‘Ahyokiki kuhuma kwa bhakuwa. Lingalyaje, sajenu andongulela kujenda ku Galilaya, konihoku nde komwakumbonaje.’ Haya, nyomwi kumpwaghila.” ");
INSERT INTO mpa_vpl VALUES ("MT28_8","070_28_8","MAT","28","8","8","Bhakabhokiki manyata kuhuma palitengeli, kwa choghohi na chiheku chamaheli, na kubhutuka imbelu kubhapwaghila bhabhulwa bhaki. ");
INSERT INTO mpa_vpl VALUES ("MT28_9","070_28_9","MAT","28","9","9","Palapala Yesu akahimangini nabhu, akapwaghaje, “Lukwali lubya na mwehapa!” Akambomba bhala bhakunheghalili, bhakachikimi na kunkamula magholu, na kunjojabhela. ");
INSERT INTO mpa_vpl VALUES ("MT28_10","070_28_10","MAT","28","10","10","Panihapa Yesu akabhapwaghile, “Ngamwijoghopa, njendanya mkabhapwaghila bhalongu bhangu bhajenda ku Galilaya, konihoku nde kobhakamonaje.” ");
INSERT INTO mpa_vpl VALUES ("MT28_11","070_28_11","MAT","28","11","11","Akambomba bhala pabhakabhi bhajenda, lingalyaje, bhalonda bha litengeli bhakumu bhakajingi mumbwane, na kubhapwaghi bhapenganyambiku bhakolongwa mambu ghokapi ghaghahengakike. ");
INSERT INTO mpa_vpl VALUES ("MT28_12","070_28_12","MAT","28","12","12","Bhela, bhakalibhongini papamu na bhazee, na pabhakalongalanile, bhakabhapeki manjolinjoli bhala mbija yamaheli, ");
INSERT INTO mpa_vpl VALUES ("MT28_13","070_28_13","MAT","28","13","13","bhakapwaghaje, “Mabhanganya mpwagha kubha, ‘Bhabhulwa bhaki bhakahikiki ikilu, na kunjibha chikahi tepani patwaghochile.’ ");
INSERT INTO mpa_vpl VALUES ("MT28_14","070_28_14","MAT","28","14","14","Ngati nkolongwa anaajowini malobhi ghangane, tepani anatulongila naku, na mwehapa ngamwipati mang'ahiku ghokapi ghala.” ");
INSERT INTO mpa_vpl VALUES ("MT28_15","070_28_15","MAT","28","15","15","Bhela bhakaitoliki mbija hyela, na kuhenga ngati mobhabholakike. Lilobhi leniheli lakajaghani pachilanda ja Bhayahude mbaka lalenu. ");
INSERT INTO mpa_vpl VALUES ("MT28_16","070_28_16","MAT","28","16","16","Bhabhulwa komi na jumu bhala bhakapiti ku Galilaya, mbaka ku chitombi chela cheakabhalaghalaki Yesu. ");
INSERT INTO mpa_vpl VALUES ("MT28_17","070_28_17","MAT","28","17","17","Pabhakumbweni bhakunjojabhile. Nambu bhakumu bhabhu bhakabhili na choghoi. ");
INSERT INTO mpa_vpl VALUES ("MT28_18","070_28_18","MAT","28","18","18","Yesu akabhaheghalili na kubhapwaghila, “Mbekiwi lujiniku lwokapi kunani kumahunde na pundema. ");
INSERT INTO mpa_vpl VALUES ("MT28_19","070_28_19","MAT","28","19","19","Bhela, njendanya mkabhabhola bhandu bha pundema wokapi bhakubha bhabhulwa bhangu, koni mkabhabatizaje kwa lihina la Atati, na laka Mwana, na laka Roho Mhuhu. ");
INSERT INTO mpa_vpl VALUES ("MT28_20","070_28_20","MAT","28","20","20","Mubhabhola kukamula mambu ghokapi ghanundaghalaki mwehapa. Na lingalyaje, nepani mili papamu na mwehapa machobha ghokapi, mbaka ujomukelu wa chikahi.”");
INSERT INTO mpa_vpl VALUES ("MK1_1","071_1_1","MRK","1","1","1","Aghagha nde Malobhi Manyahi ghaka Yesu Kristo, Mwana waka Chapanga. ");
INSERT INTO mpa_vpl VALUES ("MK1_2","071_1_2","MRK","1","2","2","Itumbwi ngati moghalembakike na mlota Isaya: “Chapanga akapwaghiki ‘Ananuntuma mbolu wangu akulongulyaje, jombe anaakulenganakya indela jako.’ ");
INSERT INTO mpa_vpl VALUES ("MK1_3","071_1_3","MRK","1","3","3","Mundu ajamali kulipololu akapwaghaje, ‘Ndenganakya indela jaka Bambo, ndenganakya payipetaje!’ ” ");
INSERT INTO mpa_vpl VALUES ("MK1_4","071_1_4","MRK","1","4","4","Yohana Mbatizaji atamika kulipololu, na konihoku abhabatiza bhandu. Akabhatangazya bhandu, “Ng'anambukaje na kughaleka mahoku ghinu na mbatizwaje nahuli Chapanga andekakya mahoku ghinu.” ");
INSERT INTO mpa_vpl VALUES ("MK1_5","071_1_5","MRK","1","5","5","Bhandu bhamaheli kuhuma ku Yudea na ku muchi wa ku Yelusalemu bhakapitiki kunja kunjowane Yohana. Bhakunjendi na kundandi mahoku ghabhu, na Yohana akabhabatizi mu Nkoka Yoludani. ");
INSERT INTO mpa_vpl VALUES ("MK1_6","071_1_6","MRK","1","6","6","Yohana akawatiki ingobhu yeyalenganakiki kwa mangoma gha chinyama chechilowakeka ngamia, na akakongiki ulamba wa chingokolu muchibhunu chaki. Chilebhi chaki chakabhi nzige na busi. ");
INSERT INTO mpa_vpl VALUES ("MK1_7","071_1_7","MRK","1","7","7","Yohana akabhatangazi bhandu, “Punyuma jangu nepani ahika mundu joabhi na makili kumbeta nenga. Ambaju hata nepani ngachembalika kujinama pahi na kumbopo mighoji ja magubasi ghaki. ");
INSERT INTO mpa_vpl VALUES ("MK1_8","071_1_8","MRK","1","8","8","Nepani nakumbatizi mwehapa kwa machi, nambu jombi anaambatiza kwa Roho Mhuhu.” ");
INSERT INTO mpa_vpl VALUES ("MK1_9","071_1_9","MRK","1","9","9","Machobha ghanihagha Yesu akahikiki kuhuma ku muchi wa ku Nazaleti inchi ja ku Galilaya, bhela akabatiziki na Yohana mu Nkoka Yoludani. ");
INSERT INTO mpa_vpl VALUES ("MK1_10","071_1_10","MRK","1","10","10","Yesu pahoghuka pela kuhuma mu machi, kunani kumahunde kukahowiki na Roho waka Chapanga akanhelali panani jaki ngati ngunda. ");
INSERT INTO mpa_vpl VALUES ("MK1_11","071_1_11","MRK","1","11","11","Na sauti jaka Chapanga jakajowaniki kuhuma kunani kumahunde jakapwaga, “Wehapa nde wa Mwanangu wenukupaliki. Nepani nyambakiki na wehapa.” ");
INSERT INTO mpa_vpl VALUES ("MK1_12","071_1_12","MRK","1","12","12","Palapala Roho waka Chapanga akundongwi Yesu kujenda kulipololu. ");
INSERT INTO mpa_vpl VALUES ("MK1_13","071_1_13","MRK","1","13","13","Konihoku akatemi machobha alobaini akalengakika na Shetani. Na hinyama ya muchitengu akatami nayu konihoku, na bhatumika bha kunani kwaka Chapanga bhakabhi bhuntumakila. ");
INSERT INTO mpa_vpl VALUES ("MK1_14","071_1_14","MRK","1","14","14","Yohana paakabhi mu chifungo, Yesu akapiti ku Galilaya kutangaza Malobhi Manyahi ghaka Chapanga. ");
INSERT INTO mpa_vpl VALUES ("MK1_15","071_1_15","MRK","1","15","15","Akapwagha, “Chikahi chihikite,” na Ukolongwa waka Chapanga uheghalile. Ng'anambukaje na kughaleka mahoku na mughahobhalya Malobhi Manyahi. ");
INSERT INTO mpa_vpl VALUES ("MK1_16","071_1_16","MRK","1","16","16","Yesu paakabhi apeta mumaheku ja bahali ja ku Galilaya, akabhaweni bhalohi bhabheli. Simoni na mbeli waki Andulea bhakalobha homba kwa nkwabho. Kwa ndandi bhakabhi bhalohe. ");
INSERT INTO mpa_vpl VALUES ("MK1_17","071_1_17","MRK","1","17","17","Yesu akabhapwaghile, “Muhika nyengalyaje, na nepani ananuntenda kubha bhalohi bha bhandu.” ");
INSERT INTO mpa_vpl VALUES ("MK1_18","071_1_18","MRK","1","18","18","Na palapala bhakajilekiki mikwabhu jabhu na bhakunjengali Yesu. ");
INSERT INTO mpa_vpl VALUES ("MK1_19","071_1_19","MRK","1","19","19","Yesu paakapiti palongi pachokopi, akabhaweni Yakobo na Yohana, bhana bhaka Zebedayo. Na bhombi bhakabhi mkati mu ngalawa jabhu bhakalenganakya mikwabhu jabhu. ");
INSERT INTO mpa_vpl VALUES ("MK1_20","071_1_20","MRK","1","20","20","Yesu akabhalohiki, na bhombi bhakundei atati wabhu Zebedayo mu ngalawa papamu na bhahenga lihengu, bhakunjengali Yesu. ");
INSERT INTO mpa_vpl VALUES ("MK1_21","071_1_21","MRK","1","21","21","Yesu na bhabhulwa bhaki bhakapiti mbaka ku muchi wa ku Kapelenaumu, na palahika Lichobha la Sabato Yesu akajingi munyumba ja kuhimangani Bhayahude, na kutumbu kubhola. ");
INSERT INTO mpa_vpl VALUES ("MK1_22","071_1_22","MRK","1","22","22","Bhandu bhokapi bhabhunjowanili bhakakangichi namaa kubhola kwaki, maghambu ngachebholika ngati bhabhola bhabhu bha Shelia, nambu akalongi ngati mundu joabhi na lujiniku. ");
INSERT INTO mpa_vpl VALUES ("MK1_23","071_1_23","MRK","1","23","23","Palapala mundu joakamuliki na lijobhi, joakabhi mu nyumba ja kuhimangani Bhayahude jela, lakatumbwi kujamalila, ");
INSERT INTO mpa_vpl VALUES ("MK1_24","071_1_24","MRK","1","24","24","lakapwagha, “Wehapa wa Yesu wa ku Nazaleti, bho, upala kike kwitu tepani? Bho, upala kutukoma tepani? Tenga tukumanye wehapa wa nane, wehapa nde Mhuhu waka Chapanga!” ");
INSERT INTO mpa_vpl VALUES ("MK1_25","071_1_25","MRK","1","25","25","Yesu akandakali lijobhi jola akapwagha, “Tumbalaje chinunu! Umpita mundu hoju.” ");
INSERT INTO mpa_vpl VALUES ("MK1_26","071_1_26","MRK","1","26","26","Bhela palapala, lijobhi lela likanjeghi chihinduhindu mundu jola na mundu jola akajamali kwa sauti ngolongwa na kumpita. ");
INSERT INTO mpa_vpl VALUES ("MK1_27","071_1_27","MRK","1","27","27","Bhandu bhokapi bhabhabhi panipala bhakakangichi na kulalukanila, “Bho, aghagha henu mambu bhole? Bho, mabholu ghahenu? Mundu ajoju abhi na uwezu wa kughakanaki majobhi, na ghombi kunjowanela!” ");
INSERT INTO mpa_vpl VALUES ("MK1_28","071_1_28","MRK","1","28","28","Bhela malobhi ghaka Yesu ghakajaghani manyata ku inchi yokapi ya munkeghi ja Galilaya. ");
INSERT INTO mpa_vpl VALUES ("MK1_29","071_1_29","MRK","1","29","29","Yesu na bhabhulwa bhaki bhakapitiki mu nyumba ja kuhimangani Bhayahude, na bhakalongini kujenda ku nyumba jaka Simoni na Andulea, najombi Yakobo na Yohana bhakapiti papamu nabhu. ");
INSERT INTO mpa_vpl VALUES ("MK1_30","071_1_30","MRK","1","30","30","Bhela, nkowanu wa chimbomba waka Simoni, akaghoni pachitanda akabhi na chitamu. Paakahikiki Yesu pela bhakumpwaghi lilobhi lenihele. ");
INSERT INTO mpa_vpl VALUES ("MK1_31","071_1_31","MRK","1","31","31","Yesu akanjendi mabhu jola, akankamwi chiwoku, na kunjangati kujema. Na chitamu hechi chikandekakili, na kutumbu kubhatumakila. ");
INSERT INTO mpa_vpl VALUES ("MK1_32","071_1_32","MRK","1","32","32","Pakamihi lyobha palajibhala, bhandu bhakundeti Yesu bhatamwa bhokapi na bhandu bhaghakamwi majobhi. ");
INSERT INTO mpa_vpl VALUES ("MK1_33","071_1_33","MRK","1","33","33","Bhandu bhokapi bha muchi ghonighola bhakalibhongini palubhanja palongi ja nyumba jela. ");
INSERT INTO mpa_vpl VALUES ("MK1_34","071_1_34","MRK","1","34","34","Yesu akabhalamihi bhandu bhamaheli bhabhabhi na hitamu yamaheli, akaghatopwi majobhi ghamaheli ghaghabhi nkati ja bhandu, kabheti ngacheaghalekiki majobhi kupwagha chindu maghambu ghakummanyiki kubha jombi nde nane. ");
INSERT INTO mpa_vpl VALUES ("MK1_35","071_1_35","MRK","1","35","35","Chilabhu jaki, pachibhombu Yesu akapiti pandu panga na bhandu kundobha Chapanga. ");
INSERT INTO mpa_vpl VALUES ("MK1_36","071_1_36","MRK","1","36","36","Simoni na bhajaki bhakapiti kumpalapala. ");
INSERT INTO mpa_vpl VALUES ("MK1_37","071_1_37","MRK","1","37","37","Pabhakumbweni, bhakampwaghile, “Kila mundu akupalapala wehapa.” ");
INSERT INTO mpa_vpl VALUES ("MK1_38","071_1_38","MRK","1","38","38","Yesu akabhapwaghile, “Tumboka ku michi jengi ja pambipi nakatangaza na konihoku, maghambu nhikiki kwa lihengu leniheli.” ");
INSERT INTO mpa_vpl VALUES ("MK1_39","071_1_39","MRK","1","39","39","Yesu akapiti kila pandu ku Galilaya hoku, akatangaza mu nyumba ya kuhimangani Bhayahude na kughatopo majobhi. ");
INSERT INTO mpa_vpl VALUES ("MK1_40","071_1_40","MRK","1","40","40","Lichobha limu mundu jumu joakabhi na malohi akunjendi Yesu, na kunchikamila na kundobha. “Anaupai, uweza kung'olola.” ");
INSERT INTO mpa_vpl VALUES ("MK1_41","071_1_41","MRK","1","41","41","Yesu akumboni chiha, akahatambwi chiwoku chaki, akankamwi na kumpwaghila, “Mbala! Ugholulikaje!” ");
INSERT INTO mpa_vpl VALUES ("MK1_42","071_1_42","MRK","1","42","42","Palapala chitamu cha malohi chikandekaki mundu jola, na akagholulike. ");
INSERT INTO mpa_vpl VALUES ("MK1_43","071_1_43","MRK","1","43","43","Bhela Yesu akumpwaghi ujendaje na kunkanakila, ");
INSERT INTO mpa_vpl VALUES ("MK1_44","071_1_44","MRK","1","44","44","“Ulingalya, koujenda hoku ngawampwaghi mundu jokapi jola chindu ache chenukutendi wehapa. Nambu ujenda ukalilangiha kwaka mpenganyambiku na ukabhoha nyambiku kwa ndandi ja kulama kwaku ngati moakalaghalaki Musa nahuli kulilangi kubha ulamike.” ");
INSERT INTO mpa_vpl VALUES ("MK1_45","071_1_45","MRK","1","45","45","Bhela, mundu jola akabhokiki na kutumbu kutangaza malobhi ghala pandu pokapi, na kutangaza mambu ghamaheli mbaka ikantendiki Yesu ngayijingi hotuhotu ku muchi wokapi ghola. Ikampaliki kutama kunja, pandu pa kanjika. Papamu na ghanihagha bhandu bhakunjendi kuhuma ipambala yokapi. ");
INSERT INTO mpa_vpl VALUES ("MK2_1","071_2_1","MRK","2","1","1","Machobha nga ghinge Yesu akakelewiki kabheti ku Kapelenaumu, bhandu bhakamanyiki kubha akabhi kunyumba. ");
INSERT INTO mpa_vpl VALUES ("MK2_2","071_2_2","MRK","2","2","2","Bhela, bhakahikiki bhandu bhamaheli namaa mbaka jakahobhiki mbekenyu mkati mbaka na kunja ja pundyangu. Yesu akabhi akabhatangazya malobhi ghaki. ");
INSERT INTO mpa_vpl VALUES ("MK2_3","071_2_3","MRK","2","3","3","Chikahi chenihechi bhandu ncheche bhakundetiki mundu joatengwiki kwaka Yesu. ");
INSERT INTO mpa_vpl VALUES ("MK2_4","071_2_4","MRK","2","4","4","Maghambu gha kutwele kwa bhandu, ngachebhaweziki kumpeleka mbaka paakabhi Yesu. Bhela bhakahotwi kunani ja nhwagala wa nyumba pandu pala paakajemiki Yesu. Pabhakapatiki mbekenyu bhakunheli ntamwa jola koni aghoni panani ja ulele, palongi jaka Yesu. ");
INSERT INTO mpa_vpl VALUES ("MK2_5","071_2_5","MRK","2","5","5","Yesu paakaweni uhobhalelu wabhu, akumpwaghi mundu joatengwiki jola, “Mwanango, ulekakiwi mahoku ghaku.” ");
INSERT INTO mpa_vpl VALUES ("MK2_6","071_2_6","MRK","2","6","6","Bhabhola bhakumu bha Shelia, bhabhakabhi panipala bhakaholali mu mitima jabhu, ");
INSERT INTO mpa_vpl VALUES ("MK2_7","071_2_7","MRK","2","7","7","“Bho, aweza bhole kulonge bhenibhela? Antondola Chapanga! Bho, nde nane joaweza kulekake mahoku nambu jumu pela, yani Chapanga?” ");
INSERT INTO mpa_vpl VALUES ("MK2_8","071_2_8","MRK","2","8","8","Palapala Yesu akamanyiki maholalelu ghaghabhi mkati ja mitima jabhu, akabhapwaghile, “Bho, maghambu kiki muholale ghanihagha mu mitima jino? ");
INSERT INTO mpa_vpl VALUES ("MK2_9","071_2_9","MRK","2","9","9","Henu lelipepwiki nakanopi lako, kumpwaghi mundu joatengwiki ajoju, ‘Ulekakiwi mahoku ghaku,’ au kumpwaghi, ‘Jujmukaje! Utola uleli waku ujendaje’? ");
INSERT INTO mpa_vpl VALUES ("MK2_10","071_2_10","MRK","2","10","10","Nambu mbala mmanya kubha Mwana waka Mundu abhi na lujiniku lwa kubhalekake bhandu mahoku ghabho pani pundema.” Panihapa akumpwaghi mundu joatengwiki jola, ");
INSERT INTO mpa_vpl VALUES ("MK2_11","071_2_11","MRK","2","11","11","“Nukupwaghi, ujemaje, utola uleli waku na ujendaje kunyumba jaku!” ");
INSERT INTO mpa_vpl VALUES ("MK2_12","071_2_12","MRK","2","12","12","Bhandu bhokapi bhakabya bhalingalila, mundu jola akajemiki na kutola uleli waki na kujenda. Bhandu bhala bhakakangichi na kundumbali Chapanga, bhakapwaghaje, “Ngachetulabhali kubhona chindu ngati cheniheche!” ");
INSERT INTO mpa_vpl VALUES ("MK2_13","071_2_13","MRK","2","13","13","Yesu akapiti kabheti mu maheku ja Bahali ja Galilaya. Bhandu bhamaheli bhakanjengalile, najombi akatumbwi kubhabhola. ");
INSERT INTO mpa_vpl VALUES ("MK2_14","071_2_14","MRK","2","14","14","Yesu papetikaje, akumbweni Lawi mwana waka Alufayo, atami mu nyumba ya kujope kode. Yesu akumpwaghi, “Unyengalyaje!” Lawi akajemiki na kunjengalela. ");
INSERT INTO mpa_vpl VALUES ("MK2_15","071_2_15","MRK","2","15","15","Panakatai, Yesu akatami mu nyumba jaka Lawi, kula chilebhe. Bhajopa kode bbhamaheli na bhana mahoku bhamaheli bhakabhi bhujengali Yesu. Na bhamaheli bhabh bhakatami papamu na Yesu na bhabhulwa bhaki bhakakula chilebhe. ");
INSERT INTO mpa_vpl VALUES ("MK2_16","071_2_16","MRK","2","16","16","Bhela, bhabhola bhangi bha Shelia bhabhabhi Mafalisayo bhabhakabhi panipala pabhumbonika Yesu akula chilebhi papamu na bhajopa kode na bhandu bhana mahoku, bhakabhalaluki bhabhulwa bhaki, “Bho, maghambu kiki akula papamu na bhajopa kode na bhana mahoku?” ");
INSERT INTO mpa_vpl VALUES ("MK2_17","071_2_17","MRK","2","17","17","Yesu paakajowini, akabhapwaghile, “Bhandu bhangakulwala ngachebhumpala sing'anga, bhandu bhabhumpala sing'anga bhabhalwala. Ngachenhikiki kubhaloha bhandu bhambone, nambu nhikiki kubhaloha bhandu bhana mahoku.” ");
INSERT INTO mpa_vpl VALUES ("MK2_18","071_2_18","MRK","2","18","18","Bhabhulwa bhaka Yohana Mbatizaji na Mafalisayo bhatendika kukonga. Bhela, bhandu bhakahikiki kundaluki Yesu, “Bho, maghambu kiki bhabhulwa bhaka Yohana Mbatizaji na bhabhulwa bha Mafalisayo bhakonga, nambu bhabhulwa bhaku ngachebhakonga?” ");
INSERT INTO mpa_vpl VALUES ("MK2_19","071_2_19","MRK","2","19","19","Yesu akabhayangiki, “Bho, bhabhakokakiki paukwate bhapalakika le kukonga koni bambo ukwate abhi papamu nabho? Chikahi chokapi chebhakubha na bambo ukwati ngachebhapalika kukonga. ");
INSERT INTO mpa_vpl VALUES ("MK2_20","071_2_20","MRK","2","20","20","Nambu chikahi anachihika ambapu bambo ukwate anaabhohakika kwabho, chikahi chenihechi nde pabhikongaje. ");
INSERT INTO mpa_vpl VALUES ("MK2_21","071_2_21","MRK","2","21","21","“Nga mundu joaloka chilaka cha ingobhu jahenu mu ingobhu ja mwande. Ngati anabhatehi bhenibhela, chilaka chikachuka kuhuma mu ingobhu ja mwandi jela, na ingobhu heji anajikachuka nakanopi. ");
INSERT INTO mpa_vpl VALUES ("MK2_22","071_2_22","MRK","2","22","22","Kabheti nga mundu joaweza kujeghe divai jahenu mu mifuku jejilenganakiki na chingokolu cha mwande. Ngati anabhatehi bhenibhela, divai jela jitenda kututumuka na kukachula mifuku jela na divai je kujitika. Divai jahenu bhajeghe mu mifuku jahenu!” ");
INSERT INTO mpa_vpl VALUES ("MK2_23","071_2_23","MRK","2","23","23","Lichobha limu la Sabato, Yesu na bhabhulwa bhaki bhapetika mu mighonda ja ingano. Pabhakabhi bhajenda mwindela, bhabhulwa bhaki bhakatumbwi kuheketa mapukutu gha ingano. ");
INSERT INTO mpa_vpl VALUES ("MK2_24","071_2_24","MRK","2","24","24","Bhela, Mafalisayo bhakundaluki Yesu bhakapwaghaje, “Ulingalyaje! Bho, mbona bhabhulwa bhaku bhahenga lijambu ambalu ngachelipalika kuhenga mu Lichobha la Sabato?” ");
INSERT INTO mpa_vpl VALUES ("MK2_25","071_2_25","MRK","2","25","25","Yesu akabhayangiki, “Bho, ngachemsomiki moakatendi Daude, papamu ja bhajaki chikahi pabhakabhi na injala? ");
INSERT INTO mpa_vpl VALUES ("MK2_26","071_2_26","MRK","2","26","26","Daude akajingi mu Nyumba jaka Chapanga, na kula mabumunda jejabhekakiki kwa ndandi ja nyambiku kwaka Chapanga. Lilobhi leniheli lakahengakiki chikahi Abisali paakabhi Mpenganyambiku Nkolongwa. Na bhapenganyambiku kanjika jabhu nde bhabhakabhi bhapalakika kula mikati jela. Nambu Daudi akakuliki na kubhapeke bhajake.” ");
INSERT INTO mpa_vpl VALUES ("MK2_27","071_2_27","MRK","2","27","27","Bhela Yesu akabhapwaghile, “Lichobha la Sabato libhekakiki kwa ndandi ja bhandu, nga bhandu kwa ndandi ja Lichobha la Sabato. ");
INSERT INTO mpa_vpl VALUES ("MK2_28","071_2_28","MRK","2","28","28","Bhela, Mwana waka Mundu nde Bambo wa Lichobha la Sabato.” ");
INSERT INTO mpa_vpl VALUES ("MK3_1","071_3_1","MRK","3","1","1","Yesu akajingi kabheti mu nyumba ja kuhimangani Bhayahude, na mkati mola akabhi mundu joatengwiki chiwoku. ");
INSERT INTO mpa_vpl VALUES ("MK3_2","071_3_2","MRK","3","2","2","Monimola, bhandu bhangi bhundingalya Yesu ngati andamiha mundu jola mu Lichobha la Sabato, nahuli bhapata ndandi ja kuntakila. ");
INSERT INTO mpa_vpl VALUES ("MK3_3","071_3_3","MRK","3","3","3","Yesu akumpwaghi mundu joatengwiki chiwoku jola, “Uhika pachilanda pambano.” ");
INSERT INTO mpa_vpl VALUES ("MK3_4","071_3_4","MRK","3","4","4","Bhela, akabhalaluki anana, “Bho, wichu le kwa Lichobha la Sabato kuhenga ghambone au kuhenga mahakau, kujilamiha roho au kujikoma?” Nambu bhombi bhakatumbi chinunu. ");
INSERT INTO mpa_vpl VALUES ("MK3_5","071_3_5","MRK","3","5","5","Yesu akabhalingali bhandu bhokapi kwa inyela na kuhakalila kwa ndandi ja kunonopa mitima jabhu. Bhela akampwaghi joakatengwiki chiwoku jola, “Uhatambula chiwoku chako!” Na jombi akahatambwi chiwoku chaki na akalamike. ");
INSERT INTO mpa_vpl VALUES ("MK3_6","071_3_6","MRK","3","6","6","Palapala Mafalisayo bhakapitiki kunja, bhakahimangini na bhahemba bhaka Helode, bhajetanganya kulonda indela ja kunkoma Yesu. ");
INSERT INTO mpa_vpl VALUES ("MK3_7","071_3_7","MRK","3","7","7","Yesu akabhokiki panipala papamu na bhabhulwa bhaki, akajenda mumaheku ja Nhwanga Galilaya na bhandu bhamaheli bhakunjengalili kuhuma ku Galilaya, ku Yudea, ");
INSERT INTO mpa_vpl VALUES ("MK3_8","071_3_8","MRK","3","8","8","ku Yelusalemu, ku Idumea na kwihi ja Nkoka Yoludani, ku Tilo na ku Sidoni. Bhandu bhanihabha bhokapi bhunjendila Yesu ndandi bhakajowini mambu ghamaheli ghaakahengiki Yesu. ");
INSERT INTO mpa_vpl VALUES ("MK3_9","071_3_9","MRK","3","9","9","Yesu akabhapwaghi bhabhulwa bhaki bhumbekila ngalawa jimu, nahuli lipogha la bhandu ngalwanhinya. ");
INSERT INTO mpa_vpl VALUES ("MK3_10","071_3_10","MRK","3","10","10","Ndandi akabhi alabhalamihi bhandu bhamaheli, na bhatamwa bhokapi bhatendika kukangana nahuli bhunkamulaje. ");
INSERT INTO mpa_vpl VALUES ("MK3_11","071_3_11","MRK","3","11","11","Na bhandu bhabhabhi na majobhi pabhumbweni, bhakalihawi pahi palongi jaki na kujamalila, “Wehapa nde wa Mwana waka Chapanga!” ");
INSERT INTO mpa_vpl VALUES ("MK3_12","071_3_12","MRK","3","12","12","Nambu Yesu akaghalakali kwa makili majobhi ngaghabhapwaghi bhandu kubha jombi nane. ");
INSERT INTO mpa_vpl VALUES ("MK3_13","071_3_13","MRK","3","13","13","Yesu akakweliki ku chitombi, na akabhalohiki bhandu bhaakabhapaliki mwene. Na bhombi bhakunjengalile, ");
INSERT INTO mpa_vpl VALUES ("MK3_14","071_3_14","MRK","3","14","14","najombi akabhahawi bhandu komi na bhabheli bhaakalohiki mitumi. Akabhapwaghi anana, “Nunhaghwi mabhanganya mbya papamu na nepani. Ananuntuma mwakatangazya bhandu Malobhi Manyahi. ");
INSERT INTO mpa_vpl VALUES ("MK3_15","071_3_15","MRK","3","15","15","Na mwiweza kughatopo majobhi.” ");
INSERT INTO mpa_vpl VALUES ("MK3_16","071_3_16","MRK","3","16","16","Bhela, bhandu bhaakahaghwi komi na bhabheli bhakabhi abha, Simoni joapata lihina la Petulu kuhuma kwaka Yesu, ");
INSERT INTO mpa_vpl VALUES ("MK3_17","071_3_17","MRK","3","17","17","Yakobo na Yohana, bhana bhaka Zebedayo Yesu akabhapeki bhalongu bhabheli habha lihina la Boanelige, ndandi jaki “Bhana bha Kulundamila,” ");
INSERT INTO mpa_vpl VALUES ("MK3_18","071_3_18","MRK","3","18","18","Andulea na Filipo, Batolomayo na Matayo, Tomaso na Yakobo mwana waka Alufayo, Tadayo na Simoni joalowakika Zelote ndandi jaki mundu wa kukomanela inchi jake. ");
INSERT INTO mpa_vpl VALUES ("MK3_19","071_3_19","MRK","3","19","19","Na Yuda Isikalioti ambaju nde joang'anambuka Yesu. ");
INSERT INTO mpa_vpl VALUES ("MK3_20","071_3_20","MRK","3","20","20","Bhela Yesu akapiti kunyumba. Bhandu bhakalibhongini kabheti, mbaka Yesu na bhabhulwa bhaki ngapabhapatiki mbekenyu ja kula chilebhe. ");
INSERT INTO mpa_vpl VALUES ("MK3_21","071_3_21","MRK","3","21","21","Bhela, bhalongu bhaki pabhajowana malobhi ghanihagha bhakabhokiki kujenda kuntola maghambu bhandu bhakabhi bhapwagha, “Ajoju mwanamangongo.” ");
INSERT INTO mpa_vpl VALUES ("MK3_22","071_3_22","MRK","3","22","22","Na bhabhola bha Shelia bhabhahumila ku Yelusalemu bhakapwaghiki, “Ajoju abhi na Beelizebuli ndandi jaki Nkolongwa wa majobhi! Kabheti aghatopo majobhi kwa makili ghaka nkolongwa wa majobhi.” ");
INSERT INTO mpa_vpl VALUES ("MK3_23","071_3_23","MRK","3","23","23","Panihapa Yesu akabhalohiki, na akabhapwaghi kwa malenganesu, “Bho, Shetani aweza bhole kuntopo Shetani njake? ");
INSERT INTO mpa_vpl VALUES ("MK3_24","071_3_24","MRK","3","24","24","Ngati ukolongwa ghumu ulekangini mapogha ghaghakomana, ukolongwa hoghu ngautamakile. ");
INSERT INTO mpa_vpl VALUES ("MK3_25","071_3_25","MRK","3","25","25","Kabheti ngati bhalongu bha nyumba jimu bhaghabhaniki mapogha ghaghakomana ulongu hoghu ngautamakile. ");
INSERT INTO mpa_vpl VALUES ("MK3_26","071_3_26","MRK","3","26","26","Na bhela, ngati Shetani na majobhi ghaki anabhatumbwi kukomana bheni kwa bheni, ngabhatamakile nambu ujomukelu wabhu uheghalile. ");
INSERT INTO mpa_vpl VALUES ("MK3_27","071_3_27","MRK","3","27","27","“Nga mundu joaweza kujingila mu nyumba jaka joabhi na makili na kunyaghu hindu yaki. Mbaka ankonga hoti mighoji mundu joabhi na makili jola. Panihapa nde aweza kunyaghu hindu yaki. ");
INSERT INTO mpa_vpl VALUES ("MK3_28","071_3_28","MRK","3","28","28","“Numpwaghi chakaka, bhandu anabhalekakiwa mahoku ghabhu na matondu ghabhu kwa kuntondola Chapanga. ");
INSERT INTO mpa_vpl VALUES ("MK3_29","071_3_29","MRK","3","29","29","Nambu mundu jokapi joantondola Roho Mhuhu, Chapanga ngaandekake mahoku ghaki mileli, ndandi akubha na lihoku la mileli.” ");
INSERT INTO mpa_vpl VALUES ("MK3_30","071_3_30","MRK","3","30","30","Yesu akalongi bhenibhela maghambu bhandu bhumpwaghila, “Abhi na lijobhi.” ");
INSERT INTO mpa_vpl VALUES ("MK3_31","071_3_31","MRK","3","31","31","Amabhu waka Yesu na bhalongu bhaki bhakahikiki panipala, na kujema kunja, bhakumpelaki ubholu wa kundoha. ");
INSERT INTO mpa_vpl VALUES ("MK3_32","071_3_32","MRK","3","32","32","Lipogha la bhandu lakatami panipala kumuyongolota Yesu. Bhela mundu jumu wabhu akumpwaghi Yesu, “Amabhu waku na bhalongu bhaku na bhalombu bhaku bhabhi kunja, bhukulonda.” ");
INSERT INTO mpa_vpl VALUES ("MK3_33","071_3_33","MRK","3","33","33","Yesu akabhapwaghile, “Bho, mabhu wangu nepani na bhalongu bhangu nde akanane?” ");
INSERT INTO mpa_vpl VALUES ("MK3_34","071_3_34","MRK","3","34","34","Panihapa akabhalingali bhandu bhabhatami kumuyongolota na kupwagha, “Ndingalya! Bhanganya abhabha nde akamabhu bhangu na bhalongu bhangu. ");
INSERT INTO mpa_vpl VALUES ("MK3_35","071_3_35","MRK","3","35","35","Mundu jokapi joatenda mapalu ghaka Chapanga, jonihoju nde mbeli wangu, ndombu wangu na mabhu wangu.” ");
INSERT INTO mpa_vpl VALUES ("MK4_1","071_4_1","MRK","4","1","1","Yesu atumbwi kabheti kubhola mumaheku ja bahali ja Galilaya. Lipogha la bhandu lakatehi kumuyongolota hata bhela ikampaliki ajingala mu ngalawa na kutama monihomu. Bhandu bhokapi bhakatamani mumaheku ja bahali. ");
INSERT INTO mpa_vpl VALUES ("MK4_2","071_4_2","MRK","4","2","2","Yesu akatumbwi kubhola mabholu ghaki ghamaheli kwa malenganesu, na mu mabholu ghaki akapwaghiki: ");
INSERT INTO mpa_vpl VALUES ("MK4_3","071_4_3","MRK","4","3","3","“Njowanyaje! Mundu jumu akapiti kukweta imbeju. ");
INSERT INTO mpa_vpl VALUES ("MK4_4","071_4_4","MRK","4","4","4","Pakwetika imbeju, imbeju jengi jakaabhuki pindela, ijuni yakahikiki na yakakuliki. ");
INSERT INTO mpa_vpl VALUES ("MK4_5","071_4_5","MRK","4","5","5","Jengi jakaabhuki pa maganga panga na luhombi lwamaheli. Ndandi luhombi ngapalwabhi lwamaheli jakabhonakini kumela manyata. ");
INSERT INTO mpa_vpl VALUES ("MK4_6","071_4_6","MRK","4","6","6","Lyobha palabhaliki, jakanyaliki na kujoma, ndandi mikegha jaki ngachejabhi na makili, najombi jakanyaliki na kujoma. ");
INSERT INTO mpa_vpl VALUES ("MK4_7","071_4_7","MRK","4","7","7","Jengi yakahabhuki mu mikongu ja miha, na miha yela yakakoliki na kuyihinya najombi ngachejapambiki mapambiku. ");
INSERT INTO mpa_vpl VALUES ("MK4_8","071_4_8","MRK","4","8","8","Jengi jakahabhuki pa luhombi lunyahi, jakameliki, jakakoliki na jakapambiki. Jimu selasini, jimu sitini, na jengi mia moja.” ");
INSERT INTO mpa_vpl VALUES ("MK4_9","071_4_9","MRK","4","9","9","Hela akabhapwaghi, “Joabi na makutu na ajogwanaje!” ");
INSERT INTO mpa_vpl VALUES ("MK4_10","071_4_10","MRK","4","10","10","Yesu paakabhi kanjika jaki, bhandu bhangi bhabhunjowini bhakunjendi papamu na bhabhulwa bhaki komi na bhabheli, na kumpwaghi abhayekulya malengenesu ghala. ");
INSERT INTO mpa_vpl VALUES ("MK4_11","071_4_11","MRK","4","11","11","Na jombi akabhapwaghi, “Mwabhanganya mpatiki kumanya ghaghilihiiki gha Ukolongwa waka Chapanga, nambu bhabhabhi kunja bhalibhola yeniheyi kwa malengenesu pela, ");
INSERT INTO mpa_vpl VALUES ("MK4_12","071_4_12","MRK","4","12","12","nahuli, ‘Bhalingaje chakaka, nambu ngabhibhona. Bhajowanaje chakaka, nambu ngabhimanya. Nanga bhela, bhakabya bhung'anambuki Chapanga, najombi akabya abhalekakile.’ ” ");
INSERT INTO mpa_vpl VALUES ("MK4_13","071_4_13","MRK","4","13","13","Bhela Yesu akabhalalukile, “Bho, mwanganya le ngachemmanyi ndandi ja malengenesu aghagha? Bho, mwimanya bhoo henu ndandi ja malenganesu ghange? ");
INSERT INTO mpa_vpl VALUES ("MK4_14","071_4_14","MRK","4","14","14","Mpanda alipanda Lilobhi laka Chapanga. ");
INSERT INTO mpa_vpl VALUES ("MK4_15","071_4_15","MRK","4","15","15","Bhandu bhangi bhabhi ngati bhandu bhabhabhi mwindela molapandakiki Lilobhi. Nambu pabhalijowana pela Shetani ahika kulitola Lilobhi lelipandakiki mu mitima jabhu. ");
INSERT INTO mpa_vpl VALUES ("MK4_16","071_4_16","MRK","4","16","16","Bhandu bhangi bhabhi ngati imbeju yeyapandakiki pa maganga. Pabhalijowana pela Lilobhi laka Chapanga bhalijopa kwa chiheku. ");
INSERT INTO mpa_vpl VALUES ("MK4_17","071_4_17","MRK","4","17","17","Nambu ngapalajingi na kumela mikyegha mu mitima jabhu. Bhalikamulaki kwa chikahi kichokope, anaghapitali mang'ahiku, na kubhatende mahakau kwa ndandi ja Lilobhi lela bhalileka. ");
INSERT INTO mpa_vpl VALUES ("MK4_18","071_4_18","MRK","4","18","18","Bhandu bhangi bhabhi ngati imbeju yeyahabwiki pa mikongu ja miha. Bhombi bhalenganeswa na bhandu bhabhalijowana Lilobhi heli, ");
INSERT INTO mpa_vpl VALUES ("MK4_19","071_4_19","MRK","4","19","19","nambu kubhokana na choghohi cha pundema panu, kupala hindu yamaheli na kutokulela hindu yamaheli ya hyegha bhapata bhombi na kulihinya Lilobhi heli, na bhombi ngachebhahenga ngati Lilobhi molipalila. ");
INSERT INTO mpa_vpl VALUES ("MK4_20","071_4_20","MRK","4","20","20","Nambu bhandu bhangi bhabhi ngati imbeju yeyapandakiki mu luhombi lunyahi. Bhombi bhalijowane Lilobhi heli na kulijopalela, na kubheleka mapambiku: Jimu selasini, jengi sitini na jengi mia moja.” ");
INSERT INTO mpa_vpl VALUES ("MK4_21","071_4_21","MRK","4","21","21","Yesu akajendali kubhapwagila, “Bho, bhandu le bhaweza kujipambaki taa na kujibheka nkati ja nyumba na kujiyekale mu lidebi au kwihi ku chitanda? Ngabhela! Bbajibheka pa kinala. ");
INSERT INTO mpa_vpl VALUES ("MK4_22","071_4_22","MRK","4","22","22","Bhela, kila chechihiyakiki anachiyekuliwaje, na kila chekiyekaliwi anachibhonikana palanga. ");
INSERT INTO mpa_vpl VALUES ("MK4_23","071_4_23","MRK","4","23","23","Joabhi na makutu na ajowanaje!” ");
INSERT INTO mpa_vpl VALUES ("MK4_24","071_4_24","MRK","4","24","24","Akabhapwaghi kabheti, “Njowanakya wichu ghamughajowana! Chipemu chelachela chemwapeme bhandu bhangi, chenihechi nde cheanampemiwa mwehapa nanamu, na kujonjukewa nakanopi. ");
INSERT INTO mpa_vpl VALUES ("MK4_25","071_4_25","MRK","4","25","25","Maghambu joabhi na chindu anaajonjukiwa nakanopi, na jwangakubha na chindu, hata chela cheabhi nachu anachinyaghuliwaje.” ");
INSERT INTO mpa_vpl VALUES ("MK4_26","071_4_26","MRK","4","26","26","Yesu akajendali kupwagha, “Ukolongwa waka Chapanga ulengana na mundu joapanda imbeju mungonda. ");
INSERT INTO mpa_vpl VALUES ("MK4_27","071_4_27","MRK","4","27","27","Ikilu aghonela, muhi akubha mihu na chikahi cheniheche imbeju jimela na kukola. Jombi ngachemanya chechihengakeka. ");
INSERT INTO mpa_vpl VALUES ("MK4_28","071_4_28","MRK","4","28","28","Mimea jeni jitundu muluhombi jikola na kubheleka. Itumbu kutunduli mahamba machoku machoku, mapukutu na ujomukelu weni mapambiku na imbeki mkati jaki. ");
INSERT INTO mpa_vpl VALUES ("MK4_29","071_4_29","MRK","4","29","29","Imbeju payikoma, ndemi jola atola chisenga na atumbu kuhuna maghambu chikahi cha mahuno chihikike.” ");
INSERT INTO mpa_vpl VALUES ("MK4_30","071_4_30","MRK","4","30","30","Yesu akapwaghiki kabhete, “Bho, Ukolongwa waka Chapanga ulengana na kyane? Bho, tulandila kwa indela bhole? ");
INSERT INTO mpa_vpl VALUES ("MK4_31","071_4_31","MRK","4","31","31","Ulengana na imbeju jejilowakeka haladali, jejibhi njoku kupeta imbeju yokapi yebhakweta bhandu mu mighonda. ");
INSERT INTO mpa_vpl VALUES ("MK4_32","071_4_32","MRK","4","32","32","Nambu anaukwetiki umela na kubha mmea ukolongwa kupeta mimea jokapi ja mungonda. Mambandi ghaki ghakubha makolongwa hata ijuni iweza kuchenga mihui momu jene.” ");
INSERT INTO mpa_vpl VALUES ("MK4_33","071_4_33","MRK","4","33","33","Yesu akapwaghi malobhi ghaki kupete malenganesu ghangi ghamaheli. Ngati mobhamanyilaje nde moajendalya kubhapwaghi Ukolongwa waka Chapanga. ");
INSERT INTO mpa_vpl VALUES ("MK4_34","071_4_34","MRK","4","34","34","Ngachealongila nabhu chokapi panga kutumi malenganesu. Nambu pabhila na bhabhulwa bhaki kanjika abhapwaghila ndandi ja kila ulenganesu. ");
INSERT INTO mpa_vpl VALUES ("MK4_35","071_4_35","MRK","4","35","35","Pakamihi ja lichobha leniheli, Yesu akabhapwaghi bhabhulwa bhaki, “Tulombuka nhwanga, tujenda kwihe.” ");
INSERT INTO mpa_vpl VALUES ("MK4_36","071_4_36","MRK","4","36","36","Bhela bhabhulwa bhaki bhakalitawiki lipogha la bhandu, bhakajingi mu liboti moakabhi Yesu na kubhoka papamu. Na kabheti bhandu bhangi bhakunjengali kwa ngalawa yengi. ");
INSERT INTO mpa_vpl VALUES ("MK4_37","071_4_37","MRK","4","37","37","Bhela, chanangunga chakatumbwi kubuluma, na mbelu ukatumbwi kujilapu ngalawa jela, na ngalawa jakatumbwi kutwele machi. ");
INSERT INTO mpa_vpl VALUES ("MK4_38","071_4_38","MRK","4","38","38","Yesu akabhi kunyuma ja ngalawa, aghoni panani ja pilo. Bhela bhabhulwa bhaki bhakunjumwi na kumpwaghila, “Mbola, ngacheukubhina mtima kubha tepani tupotela!” ");
INSERT INTO mpa_vpl VALUES ("MK4_39","071_4_39","MRK","4","39","39","Akajumwiki na kukenjuki mpongu ghola, na majegha gha munhwanga ghala, “Tumbalaje!” Palapala mpongu ukatondiki, na kupola nakanopi. ");
INSERT INTO mpa_vpl VALUES ("MK4_40","071_4_40","MRK","4","40","40","Bhela Yesu akabhapwaghi bhabhulwa bhaki, “Bho, maghambu kiki njoghopa? Bho, mwakona ngachembi na uhobhalelu?” ");
INSERT INTO mpa_vpl VALUES ("MK4_41","071_4_41","MRK","4","41","41","Na bhombi bhakajowipi namaa, koni bhakalalukanya, “Bho, ajoju henu nane? Mbaka mpongu na majegha yuntii!” ");
INSERT INTO mpa_vpl VALUES ("MK5_1","071_5_1","MRK","5","1","1","Yesu na bhabhulwa bhaki bhakahiki ku inchi ja Bhagelasi, kwihi ja bahali ja Galilaya. ");
INSERT INTO mpa_vpl VALUES ("MK5_2","071_5_2","MRK","5","2","2","Chikahi Yesu pahuluka mu ngalawa, akahimangini na mundu jumu joakabhi na majobhi akahumila mumatengele. ");
INSERT INTO mpa_vpl VALUES ("MK5_3","071_5_3","MRK","5","3","3","Mundu jonihojo atamika mumatengele. Wala ngacheakabhi mundu jowezika kunkonga kabheti hata kwa minyololo. ");
INSERT INTO mpa_vpl VALUES ("MK5_4","071_5_4","MRK","5","4","4","Machobha ghamaheli bhunkongika kwa pengu na minyololo nambu chikahi chokapi awezika kuheketa minyololo na kutunyu pengu yene. Wala njeta mundu joakabhili na makili gha kuweza kunkamula. ");
INSERT INTO mpa_vpl VALUES ("MK5_5","071_5_5","MRK","5","5","5","Ikilu na muhi atamika mumatengele na mwitombi, koni akalapula njobhela na kulicheku chekula kwa maganga. ");
INSERT INTO mpa_vpl VALUES ("MK5_6","071_5_6","MRK","5","6","6","Paakumbweni Yesu cha kutali, akunkembalili na kunchikamila palongi jake, ");
INSERT INTO mpa_vpl VALUES ("MK5_7","071_5_7","MRK","5","7","7","akalehi kwa sauti ngolongwa, “Ne nukutehi kyane! Bho, wehapa le wa Yesu, Mwana waka Chapanga, joabhi kunani kumahunde? Kwa lihina laka Chapanga, nukulobha ngawing'aha!” ");
INSERT INTO mpa_vpl VALUES ("MK5_8","071_5_8","MRK","5","8","8","Akapwaghiki hhenhihela ndandi Yesu akabhi ampwaghi, “Lijobi, umboka mundu hojo.” ");
INSERT INTO mpa_vpl VALUES ("MK5_9","071_5_9","MRK","5","9","9","Panihapa, Yesu akundalukile, “Bho, lihina laku wa nane?” Na jombi akamuyangiki, “Lihina langu ‘Legioni,’ maghambu tubhi bhamaheli.” ");
INSERT INTO mpa_vpl VALUES ("MK5_10","071_5_10","MRK","5","10","10","Panipala lijobhi jola akumpembalaki Yesu ngaantopola pa inchi jenijela. ");
INSERT INTO mpa_vpl VALUES ("MK5_11","071_5_11","MRK","5","11","11","Kukabhi lipogha likolongwa lwa magholobhe pambipi ja punhelelo wa pachitombi bhakadimaje. ");
INSERT INTO mpa_vpl VALUES ("MK5_12","071_5_12","MRK","5","12","12","Bhela majobhi ghala ghumpembali Yesu, “Utulaghalakya tukajingala mu magholobhi ghala.” ");
INSERT INTO mpa_vpl VALUES ("MK5_13","071_5_13","MRK","5","13","13","Yesu akajetakili. Bhela majobhi ghakumpitiki mundu jola, na kughajingi magholobhi ghala. Lipogha lokapi la magholobhi ngati elufu ibheli ghakahelalaje punhelelo kujenda kunhwanga na kujingi mu bahali na kuwa. ");
INSERT INTO mpa_vpl VALUES ("MK5_14","071_5_14","MRK","5","14","14","Bhadima bha magholobhi bhala bhakatiliki, bhakakembili kumbwane na kwijiji kubhatangazi bhandu mambu ghanihagha. Na bhandu bhakahikiki kulinga chechipitalile. ");
INSERT INTO mpa_vpl VALUES ("MK5_15","071_5_15","MRK","5","15","15","Pabhahika kwaka Yesu, bhakumbweni mundu joakabhi na lipogha la majobhi, atami pahi, awati ingobhu abhi na malangu ghaki wichu, bhakajowipe. ");
INSERT INTO mpa_vpl VALUES ("MK5_16","071_5_16","MRK","5","16","16","Bhandu bhabhaghabhona mambu ghaghapitalile bhakabhapwaghi bhandu bhangi ghaghahengakiki kwaka mundu joakabhi na majobhi jola, na ghaghapitali kwa magholobhi ghala. ");
INSERT INTO mpa_vpl VALUES ("MK5_17","071_5_17","MRK","5","17","17","Bhela bhakatumbwi kundobha Yesu abhokaje pa inchi jabho. ");
INSERT INTO mpa_vpl VALUES ("MK5_18","071_5_18","MRK","5","18","18","Yesu pajingala mu ngalawa, mundu joampiha majobhi akunjopiki anjetakya kujenda nako. ");
INSERT INTO mpa_vpl VALUES ("MK5_19","071_5_19","MRK","5","19","19","Nambu Yesu akunkanili. Akumpwaghila, “Ujenda kunyumba kwa bhalongu bhaku, ukabhapwaghila mambu ghokapi Bambo ghaakuhengile na ntundu moakubhoni chiha.” ");
INSERT INTO mpa_vpl VALUES ("MK5_20","071_5_20","MRK","5","20","20","Bhela, mundu jola akapiti na kutumbu kutangaza ku Dekapoli kwoha, mambu ghokapi Yesu ghaakunhengile. Bhandu bhokapi bhabhajowini bhakakangiche. ");
INSERT INTO mpa_vpl VALUES ("MK5_21","071_5_21","MRK","5","21","21","Yesu akalombwiki kabheti upambala wa kabheli wa bahali kwa ngalawa. Pahika pe kwihi lipogha la bhandu lakalibhongini palongi jaki, najombi akajemiki munkeghi ja bahali. ");
INSERT INTO mpa_vpl VALUES ("MK5_22","071_5_22","MRK","5","22","22","Panihapa akahikiki mundu jumu joalowakika Yailo, joakabhi nkolongwa wa nyumba ja kuhimangani Bhayahude. Paakumbweni Yesu, akaheghali na kuchikama pamagholu ghake, ");
INSERT INTO mpa_vpl VALUES ("MK5_23","071_5_23","MRK","5","23","23","akumpembali namaa akapwaghaje, “Kamwali wangu nchoku nde mtamwa pambipi kupotela. Chondi kambokaje, ukumbekila mabhoku ghaku nahuli apata kulama.” ");
INSERT INTO mpa_vpl VALUES ("MK5_24","071_5_24","MRK","5","24","24","Bhela, Yesu akabhokiki papamu nako. Bhandu bhamaheli bhakunhinyiki kila upambala. ");
INSERT INTO mpa_vpl VALUES ("MK5_25","071_5_25","MRK","5","25","25","Papuje akabhi mbomba jumu joakabhi na chitamu cha kupita mwahi kwa chikahi cha hyaka komi na ibheli. ");
INSERT INTO mpa_vpl VALUES ("MK5_26","071_5_26","MRK","5","26","26","Mbomba jonihojo akabhi ang'ahakiki kwa akasing'anga bhamahele. Koni akabya atumili hindu yaki yokapi, ngacheapepukile na hali jaki jakajendali kubha nga wichu. ");
INSERT INTO mpa_vpl VALUES ("MK5_27","071_5_27","MRK","5","27","27","Mbomba hoju paakajowini Yesu abhalamiha bhandu, akapekalaki pa lipogha la bhandu kuhuma kunyuma, na kukamula ingobhu jaka Yesu. ");
INSERT INTO mpa_vpl VALUES ("MK5_28","071_5_28","MRK","5","28","28","Akatendiki bhenibhela, maghambu akalipwaghi mweni muntima waki, “Anangamwi ingobhu jaki pela, ananamaje.” ");
INSERT INTO mpa_vpl VALUES ("MK5_29","071_5_29","MRK","5","29","29","Pakamula pe ingobhu jaka Yesu na mwahi ukakotwike, na palapala akaliweni hyegha jaki jilamike. ");
INSERT INTO mpa_vpl VALUES ("MK5_30","071_5_30","MRK","5","30","30","Palapala Yesu akamanyiki kubha makili ghaki ghumbokiki. Akaling'anambuki lipogha la bhandu lela na kubhalalukila, “Bho, nde nane joakamwi ingobhu jango?” ");
INSERT INTO mpa_vpl VALUES ("MK5_31","071_5_31","MRK","5","31","31","Bhabhulwa bhaki bhakayangike, “Ubhona bhandu mobhakuhinyila. Bho, mbona ulaluki nane joakukamwile?” ");
INSERT INTO mpa_vpl VALUES ("MK5_32","071_5_32","MRK","5","32","32","Nambu Yesu akajendali kulingalila ipambala yokapi nahuli ambona mundu joahengiki ghanihagha. ");
INSERT INTO mpa_vpl VALUES ("MK5_33","071_5_33","MRK","5","33","33","Panihapa mbomba jola, koni akabya amanyi ghaghumpatiki, akapitali palongi koni abhaghaja kwa choghohi, akalihawi pahi palongi jaka Yesu, na kulanda uchakaka wokapi. ");
INSERT INTO mpa_vpl VALUES ("MK5_34","071_5_34","MRK","5","34","34","Yesu akumpwaghile, “Kamwali wangu, uhobhalelu waku ukulamihe. Ujenda kwa lukwale, ulama nakanopi chitamu chaku heche.” ");
INSERT INTO mpa_vpl VALUES ("MK5_35","071_5_35","MRK","5","35","35","Yesu paakabhi akona kulongela, bhakahikiki bhandu kuhuma kunyumba jaka Yailo nkolongwa wa nyumba ja kuhimangani Bhayahude, na kumpwaghi Yailo, “Kamwali waku apotile. Bho, maghambu kiki ujendale kung'aha Mbola?” ");
INSERT INTO mpa_vpl VALUES ("MK5_36","071_5_36","MRK","5","36","36","Nambu Yesu paakajowini malobhi ghabhalongila bhandu, akumpwaghi nkolongwa wa nyumba ja kuhimangani Bhayahude jola, “Ngawijoghopa, uhobhalya pela.” ");
INSERT INTO mpa_vpl VALUES ("MK5_37","071_5_37","MRK","5","37","37","Yesu ngacheapahi mundu jongi jokapi jola ejenda naku nakanopi jaka Petulu, Yakobo na Yohana ndongu waka Yakobo. ");
INSERT INTO mpa_vpl VALUES ("MK5_38","071_5_38","MRK","5","38","38","Ebhahika kunyumba jaka Yailo, Yesu akajowini njobhela na bhandu bhakalelaje na kuombuleza kwa sauti ngolongwa. ");
INSERT INTO mpa_vpl VALUES ("MK5_39","071_5_39","MRK","5","39","39","Pajingala mkati, akabhapwaghi, “Bho, maghambu kiki njobhela na ilelo? Kamwali ngacheapotile, nambu atehi kughone pela.” ");
INSERT INTO mpa_vpl VALUES ("MK5_40","071_5_40","MRK","5","40","40","Nambu bhombi bhakunhekiki namaa. Akabhapihiki bhokapi kunja, akabhatohi tati waki na mabhu waki na bhabhulwa bhaki bhatatu, bhakajingi kuchumba koakabhi kamwali jola. ");
INSERT INTO mpa_vpl VALUES ("MK5_41","071_5_41","MRK","5","41","41","Bhela akunkamwi chiwoku na kumpwaghi, “Talita komi,” ndandi jaki, “Kamwali, nukupwaghi ujumukaje!” ");
INSERT INTO mpa_vpl VALUES ("MK5_42","071_5_42","MRK","5","42","42","Palapala mwali jola akajemiki na kutumbu kujenda. Kamwali hoju akabhi na hyaka komi na ibheli. Panihapa bhandu bhakakangichi nakanopi. ");
INSERT INTO mpa_vpl VALUES ("MK5_43","071_5_43","MRK","5","43","43","Yesu akabhakanaki ngabhampwaghi mundu jokapi jola lilobhi lenihele. Bhela akabhapwaghi bhumpekya chilebhi mwali jola. ");
INSERT INTO mpa_vpl VALUES ("MK6_1","071_6_1","MRK","6","1","1","Yesu akabhokiki panihapa na kujenda ku chijiji chaki, koni bhabhulwa bhaki bhakunjengalyaje. ");
INSERT INTO mpa_vpl VALUES ("MK6_2","071_6_2","MRK","6","2","2","Palahika Lichobha la Sabato Yesu akajingi mu nyumba ja kuhimangani Bhayahude na kutumbu kubhola. Bhandu bhamahele bhabhunjowini bhakakangachi, bhakapwaghaje, “Bho, aghapatiki kwaku mambu hagha ghalongela? Lingalyaje, nde mbulau bholi ajeji jeapekiwi mundu ajojo? Kabheti ahenga bholi ngangachu ayeyi ikolongwa kwa mabhoku ghake? ");
INSERT INTO mpa_vpl VALUES ("MK6_3","071_6_3","MRK","6","3","3","Bho, hajo le nga selemala jola, mwana waka Malia, na ndongu wabhu aka Yakobo, Yusufu, Yuda na Simoni? Akalombu bhaki si bhatamani papitu pane?” Bhela bhakatehi kunkana. ");
INSERT INTO mpa_vpl VALUES ("MK6_4","071_6_4","MRK","6","4","4","Yesu akabhapwaghile, “Mlota waka Chapanga ajetakalewa pandu pokapi, nambu nga mu inchi jaki mweni, kwa bhalongu bhaki na bhandu bha munyumba jaki.” ");
INSERT INTO mpa_vpl VALUES ("MK6_5","071_6_5","MRK","6","5","5","Yesu ngacheaweziki kutenda ngangachu panihapa, nambu akabhabheki mabhoku bhatamwa bhachokopi, na kubhalamiha. ");
INSERT INTO mpa_vpl VALUES ("MK6_6","071_6_6","MRK","6","6","6","Yesu akakangichi namaa, kwa kulepalela kuhobhale kwabho. Na panihapa Yesu akaijendili ijiji ya pambipi jaki na kubhabhola bhandu. ");
INSERT INTO mpa_vpl VALUES ("MK6_7","071_6_7","MRK","6","7","7","Akabhalohiki bhabhulwa bhaki komi na bhabheli, na kutumbula kubhatuma bhabheli bhabheli. Akabhapeki amuli ja kutopo majobhi. ");
INSERT INTO mpa_vpl VALUES ("MK6_8","071_6_8","MRK","6","8","8","Akabhalaghalaki, “Ngamwitogho chindu chokapi kwa ndandi ja mwanja winu nambu nyamula imbeu pela. Ngamwitogho chilebhi, wala nkoba, wala mbija mu chibhuno. ");
INSERT INTO mpa_vpl VALUES ("MK6_9","071_6_9","MRK","6","9","9","Muwata magubasi, nambu ngamwitogho ingobhu ja kung'anambula.” ");
INSERT INTO mpa_vpl VALUES ("MK6_10","071_6_10","MRK","6","10","10","Kabheti akabhapwaghi, “Pandu pokapi bhandu pabhanjopalya panyumba, mwakatamanya pandu panihapa mbaka pamwibhokaje. ");
INSERT INTO mpa_vpl VALUES ("MK6_11","071_6_11","MRK","6","11","11","Pandu pokapi pabhikana kunjopalela au kunjowanela, mkabhokanyaje na kukung'unda luhombi mu magholu ghinu, nahuli kubhalangi kubha bhakaniki ubholu waka Chapanga!” ");
INSERT INTO mpa_vpl VALUES ("MK6_12","071_6_12","MRK","6","12","12","Bhela bhakabhokiki, na kubhatangazi bhandu bhang'anambukaje na kughaleka mahoku. ");
INSERT INTO mpa_vpl VALUES ("MK6_13","071_6_13","MRK","6","13","13","Bhakaghatopwi majobhi ghamaheli. Na bhakabhapakiki mahuta bhatamwa bhamaheli, na bhatamwa bhakalamike. ");
INSERT INTO mpa_vpl VALUES ("MK6_14","071_6_14","MRK","6","14","14","Panihapa Nkolongwa Helode akajowini malobhi ghanihagha, ndandi bhandu bhamahele bhalongalya ngangachu yaka Yesu pandu pokapi. Bhandu bhangi bhakapwaghiki, “Ajoju Yohana Mbatizaji ahyokiki kuhuma kwa bhakuwa! Nde ndandi abhi na makili gha kuhenga hindu ya kukangacha.” ");
INSERT INTO mpa_vpl VALUES ("MK6_15","071_6_15","MRK","6","15","15","Bhangi bhakapwaghiki, “Mundu ajoju nde Eliya.” Bhangi bhakapwaghiki, “Ajoju nde mlota au nde ngati jumu wa bhalota bhaka Chapanga bha mwande.” ");
INSERT INTO mpa_vpl VALUES ("MK6_16","071_6_16","MRK","6","16","16","Nambu Helode paakajowini malobhi ghanihagha akapwaghiki, “Jonihoju nde Yohana. Nakunhekiti mmutu, nambu ahyokike!” ");
INSERT INTO mpa_vpl VALUES ("MK6_17","071_6_17","MRK","6","17","17","Akaholali bhenibhela ndandi pa machobha gha kunyuma Helode akabhohiki amuli Yohana Mbatizaji akamulikaje, na kunkonga muchifungo. Helode akahengiki bhenibhela kwa ndandi jaka Helodia joakabhi nhwanu waka Filipo ndongu waki. Papamu na ghanihagha Helode akaamwi kuntoghola Helodia. ");
INSERT INTO mpa_vpl VALUES ("MK6_18","071_6_18","MRK","6","18","18","Yohana akabhi ampwaghi Helode, “Ngacheutahi wichu kuntogho nhwanu waka ndongu wako.” ");
INSERT INTO mpa_vpl VALUES ("MK6_19","071_6_19","MRK","6","19","19","Bhela Helodia, nhwanu waka nkolongwa akunhakali namaa Yohana, akapaliki kunkoma, nambu ngacheawezike. ");
INSERT INTO mpa_vpl VALUES ("MK6_20","071_6_20","MRK","6","20","20","Helode akunjowipi Yohana ndandi akamanyiki kubha Yohana mundu wamboni na mhuhu, na bhela akundendiki. Helode akapaliki kunjowane Yohana, na hata baada ja kujomo kunjowanela, ngacheakamanyi cha kutenda. ");
INSERT INTO mpa_vpl VALUES ("MK6_21","071_6_21","MRK","6","21","21","Lichobha limu Helodia akapatiki mbekenyu, palahika lichobha la uwangalalu wa kubhelekeka kwaka Helode. Lichobha leniheli Helode akabhakokiki, ihongozi bhakolongwa bha pa inchi jaki na manjolinjoli na ihongozi bhakolongwa bhokapi bha ku Galilaya. ");
INSERT INTO mpa_vpl VALUES ("MK6_22","071_6_22","MRK","6","22","22","Bhela kamwali waka Helodia akajingi na kukina, akabhahekihi namaa bhagheni bhaka Helode. Nkolongwa akumpwaghi mwali jola, “Unyopa chokapi cheuchipala nanatu ananukupekyaje.” ");
INSERT INTO mpa_vpl VALUES ("MK6_23","071_6_23","MRK","6","23","23","Kabheti na kundapila, “Chokapi chewinyopaje ananukupekyaje, hata anajibhi nusu ja ukolongwa wango.” ");
INSERT INTO mpa_vpl VALUES ("MK6_24","071_6_24","MRK","6","24","24","Panihapa kamwali jola akapitiki, na kundaluki mabhu waki, “Bho, nyopa kike?” Na jombi akayangike, “Mmutu waka Yohana Mbatizaji.” ");
INSERT INTO mpa_vpl VALUES ("MK6_25","071_6_25","MRK","6","25","25","Kamwali akakelawiki kabheti kwaka nkolongwa koni akakembala imbelu na kunjopa, “Mbala sajenu, umbekya mmutu waka Yohana Mbatizaji mu chipalo.” ");
INSERT INTO mpa_vpl VALUES ("MK6_26","071_6_26","MRK","6","26","26","Nkolongwa akayomiki namaa, nambu kwa ndandi ja kulapa kwaki, na kwa ndandi ja bhagheni bhaakakokiki, ngacheapaliki kunkanila. ");
INSERT INTO mpa_vpl VALUES ("MK6_27","071_6_27","MRK","6","27","27","Bhela Nkolongwa akuntumiki linjolinjoli akaleta mmutu waka Yohana. Linjolinjoli, akapiti na kucheku mmutu waka Yohana muchifungo, ");
INSERT INTO mpa_vpl VALUES ("MK6_28","071_6_28","MRK","6","28","28","akaletiki mmutu ghola mu chipalo na kumpeke kamwali jola, najombi mwali akumpeki mabhu waki. ");
INSERT INTO mpa_vpl VALUES ("MK6_29","071_6_29","MRK","6","29","29","Bhabhulwa bhaka Yohana pabhakajowini malobhi ghanihagha, bhakapiti kujitola hyegha jaki na kujenda kujitagha mulitengeli. ");
INSERT INTO mpa_vpl VALUES ("MK6_30","071_6_30","MRK","6","30","30","Mitumi bhaki bhala bhakakelawiki kuhuma ku mwanja wabhu, bhakalibhongini palongi jaka Yesu, na kumpwaghila mambu ghokapi ghabhahengiki na kubhola. ");
INSERT INTO mpa_vpl VALUES ("MK6_31","071_6_31","MRK","6","31","31","Yesu akabhapwaghile, “Tambokanya tujenda kanjika jitu pandu pangakubha na bhandu mwakapomulya pachokope.” Akapwaghiki bhenibhela ndandi bhakabhi bhandu bhamaheli namaa bhakahika na kubhoka, hata Yesu na bhabhulwa bhaki ngachebhaweziki kupata mbekenyu ja kula chilebhe. ");
INSERT INTO mpa_vpl VALUES ("MK6_32","071_6_32","MRK","6","32","32","Bhela bhakabhokani kanjika jabhu mu ngalawa bhakajendanya pandu pangakubha na bhandu. ");
INSERT INTO mpa_vpl VALUES ("MK6_33","071_6_33","MRK","6","33","33","Nambu bhandu bhamahele bhakabhaweni bhakajendaje, na bhakamanyike. Bhela bhandu bhangi bhakahumiki ku kila muchi, bhakakembalya koapita Yesu na bhabhulwa bhaki, na bhakabhalonguli kuhika. ");
INSERT INTO mpa_vpl VALUES ("MK6_34","071_6_34","MRK","6","34","34","Yesu paakabhi ahuluka mu ngalawa, akaliweni lipogha la bhandu, na akabhabhoni chiha mumtima waki, maghambu bhakabhi ngati mambelele ghangakubha na ndima. Akatumbwi kubhabhola malobhi ghamahele. ");
INSERT INTO mpa_vpl VALUES ("MK6_35","071_6_35","MRK","6","35","35","Pakamihi pakwahikaje, bhabhulwa bhakunjendi Yesu, na kumpwaghila, “Pandu pani pachingwenje, na sajeno kupilile. ");
INSERT INTO mpa_vpl VALUES ("MK6_36","071_6_36","MRK","6","36","36","Mbanga ubhatabhukaje bhandu habha bhajenda ku mighonda jabhu na kwijiji yabhu ya pambipe, bhakahemala chilebhi.” ");
INSERT INTO mpa_vpl VALUES ("MK6_37","071_6_37","MRK","6","37","37","Nambu Yesu akabhapwaghi, “Mwapekya mabhanganya chilebhi.” Na bhombi bhakundalukile, “Bho, tubhaleha kike? Bho tujenda lelu tukahemala mabumunda kwa ipandi mia ibheli ya madini gha feza, na kubhapekeha bhakulaje?” ");
INSERT INTO mpa_vpl VALUES ("MK6_38","071_6_38","MRK","6","38","38","Yesu akabhalalukile, “Bho, mbi naghu mabumunda ghalenga? Njendanya mkalingaje.” Pabhalingiki, bhakumpwaghile, “Ghabhi mabumunda nhwanu, na homba ibheli.” ");
INSERT INTO mpa_vpl VALUES ("MK6_39","071_6_39","MRK","6","39","39","Bhela Yesu akabhalaghalaki bhabhulwa bhaki bhabhatamika bhandu mu mapogha mapogha pa manyonyoli mabhei. ");
INSERT INTO mpa_vpl VALUES ("MK6_40","071_6_40","MRK","6","40","40","Na bhombi bhakatemi mapogha gha bhandu mia jimu na pangi hamsini. ");
INSERT INTO mpa_vpl VALUES ("MK6_41","071_6_41","MRK","6","41","41","Bhela Yesu akatoliki mabumunda nhwanu na homba ibheli yela, akalingali kunani kumahunde, akunchengwi Chapanga, na kuheketa mabumunda, akabhapeki bhabhulwa bhaki bhaghabhila bhandu. Na homba yela bhakabhaghabhi bhandu bhokapi. ");
INSERT INTO mpa_vpl VALUES ("MK6_42","071_6_42","MRK","6","42","42","Bhandu bhokapi bhakakuliki na kutupila. ");
INSERT INTO mpa_vpl VALUES ("MK6_43","071_6_43","MRK","6","43","43","Bhakatondwi mahighalilu gha mabumunda na homba, na kutwelakela itonga komi na ibheli. ");
INSERT INTO mpa_vpl VALUES ("MK6_44","071_6_44","MRK","6","44","44","Na bhombi bhabhakuliki mabumunda ghala bhakabhi ngati akanalomi elufu nhwano. ");
INSERT INTO mpa_vpl VALUES ("MK6_45","071_6_45","MRK","6","45","45","Palapala Yesu akabhapwaghi bhabhulwa bhaki bhakwela mu ngalawa, bhalongulya kujenda ku Betisaida kwihi ja bahali. Jombi chikahi chenihechi akabhi ajendalela kubhatabhuka lipogha la bhandu. ");
INSERT INTO mpa_vpl VALUES ("MK6_46","071_6_46","MRK","6","46","46","Pajomula kubhatabhuka akapiti ku chitombi kundobha Chapanga. ");
INSERT INTO mpa_vpl VALUES ("MK6_47","071_6_47","MRK","6","47","47","Pakwahika pakamihi, ngalawa jela jakabhi pachilanda ja bahali, najombi akabhi kanjika jaki kuluwanga. ");
INSERT INTO mpa_vpl VALUES ("MK6_48","071_6_48","MRK","6","48","48","Yesu akabhaweni bhabhulwa bhaki bhang'ahika kuhugha ingaye, maghambu mpongu ukabhi wahibhalakilka. Pakwahiki pachibombu, Yesu akabhajendi bhabhulwa bhaki, koni akajendaje panani ja machi, akapala ngati kubhapeta. ");
INSERT INTO mpa_vpl VALUES ("MK6_49","071_6_49","MRK","6","49","49","Nambu pabhumbweni ajenda panani ja machi, bhaambukya lihoka, bhakajamalile. ");
INSERT INTO mpa_vpl VALUES ("MK6_50","071_6_50","MRK","6","50","50","Kwa ndandi bhokapi pabhumbweni bhakajowipi namaa. Palapala Yesu akalongi nabhu, “Mlipekya mtima, ngamwijoghopa, nde nepani!” ");
INSERT INTO mpa_vpl VALUES ("MK6_51","071_6_51","MRK","6","51","51","Na jombi akakweliki mu ngalawa mobhakabhile, na mpongu ukakotwiki. Panihapa bhakakangichi namaa mumitima jabhu, ");
INSERT INTO mpa_vpl VALUES ("MK6_52","071_6_52","MRK","6","52","52","ndandi bhakabhi bhakona ngakumanya cheakahengiki Yesu panani ja mabumunda ghala. Nambu mitima jabhu jakabhi jinonwipe. ");
INSERT INTO mpa_vpl VALUES ("MK6_53","071_6_53","MRK","6","53","53","Bhakalombwiki bahali na kuhika ku inchi ja ku Genesaleti, bhakajemiki ngimo ngalawa jabhu. ");
INSERT INTO mpa_vpl VALUES ("MK6_54","071_6_54","MRK","6","54","54","Pabhahuluka mu ngalawa jela, palapala bhandu bhakamanyiki kubha jolajo Yesu. ");
INSERT INTO mpa_vpl VALUES ("MK6_55","071_6_55","MRK","6","55","55","Bhela, kwa kujombateka bhakayongalwiti inchi jokapi, bhakatumbwi kwatotola bhatamwa bhabhaghoni panani ja mileli jabhu, bhakabhapeliki kila pandu pabhajowana kubha Yesu abhile. ");
INSERT INTO mpa_vpl VALUES ("MK6_56","071_6_56","MRK","6","56","56","Kila pandu Yesu paakapiti, mwijiji, mu mbwane au mu mighonda, bhandu bhabhekika bhatamwa panja, bhakunjopiki bhajetakya bhatamwa bhunkamula pe hata nkungi wa ingobhu jake. Na bhokapi bhabhunkamwili bhakalamike. ");
INSERT INTO mpa_vpl VALUES ("MK7_1","071_7_1","MRK","7","1","1","Lichobha limu Mafalisayo na bhabhola bhangi bha Shelia bhabhahumila ku Yelusalemu bhakapiti kumbona Yesu. ");
INSERT INTO mpa_vpl VALUES ("MK7_2","071_7_2","MRK","7","2","2","Bhakabhaweni bhabhulwa bhangi bhaka Yesu bhakakula chilebhi kwa mabhoku ghabhu panga kuchamba ngati moipalakila. ");
INSERT INTO mpa_vpl VALUES ("MK7_3","071_7_3","MRK","7","3","3","Ndandi Mafalisayo na Bhayahude bhokapi bhakamulaki namaa mabholu ghabhajopali kwa akahokolu bhabhu, ngachebhakula chindu panga kuchambaki ngati mokupalakila. ");
INSERT INTO mpa_vpl VALUES ("MK7_4","071_7_4","MRK","7","4","4","Kabheti ngachebhakula chindu chokapi kuhuma paligulio panga kugholo hoti ngati mokupalakila na mitetu jabho. Jikabhi kabheti mitetu jengi jebhajopali kutumbu pamwandi ngati ntundu wa kugholo ikombi, sufulia na yombu ya shaba. ");
INSERT INTO mpa_vpl VALUES ("MK7_5","071_7_5","MRK","7","5","5","Bhela Mafalisayo na bhabhola bhangi bha Shelia bhakandaluki Yesu, “Bho, maghambu kiki bhabhulwa bhaku ngachebhajengale mitetu ja akahokolu bhito, nambu bhakula chilebhi kwa mabhoku ghanga kuchambaki ngati mokupalakila?” ");
INSERT INTO mpa_vpl VALUES ("MK7_6","071_7_6","MRK","7","6","6","Yesu akabhayangiki, “Mwanganya mulibhona mbi wichu na koni ngachembi wichu! Mlota Isaya akapwaghiki chakaka panani jinu mabhanganya paakalembiki, ‘Chapanga apwagha, bhandu abhabha, bhanumbali kwa malobhi pela, nambu mu mitima jabhu, bhabhi kutali na nepani. ");
INSERT INTO mpa_vpl VALUES ("MK7_7","071_7_7","MRK","7","7","7","Kunyojabhe kwabhu nde waka, maghambu bhaghabhola malaghalaki ghaghahuma kwa bhandu, ngati amuli yaka Chapanga.’ ");
INSERT INTO mpa_vpl VALUES ("MK7_8","071_7_8","MRK","7","8","8","“Mwanganya mwileka amuli yaka Chapanga na kukamuliki malaghalaki gha bhandu.” ");
INSERT INTO mpa_vpl VALUES ("MK7_9","071_7_9","MRK","7","9","9","Yesu akajendali kupwagha, “Mwanganya kwa malangu ghinu mjikana amuli jaka Chapanga nahuli mpata kujengale majopale ghinu! ");
INSERT INTO mpa_vpl VALUES ("MK7_10","071_7_10","MRK","7","10","10","Ndandi Musa akapwaghiki, ‘Untopila atati waku na mabhu waku,’ na ‘Mundu jokapi joantondo atati waki na mabhu waki, apalika akomakikaje.’ ");
INSERT INTO mpa_vpl VALUES ("MK7_11","071_7_11","MRK","7","11","11","Nambu mwanganya mbola, ‘Ngati mundu abhi na chindu cheaweza kunjangati atati waki au mabhu waki, nambu apwagha kubha, chindu che hechi nde Kolubani,’ yani cha kumpeke nhupu Chapanga, ");
INSERT INTO mpa_vpl VALUES ("MK7_12","071_7_12","MRK","7","12","12","bhela ngacheapalika kabheti kunjangati atati waki au mabhu waki. ");
INSERT INTO mpa_vpl VALUES ("MK7_13","071_7_13","MRK","7","13","13","Bhenibhela nde momulikani Lilobhi laka Chapanga kwa ndandi ja mabholu ghamulibhekile. Kabheti muhenga mambu ghamahele ngati ganihaga.” ");
INSERT INTO mpa_vpl VALUES ("MK7_14","071_7_14","MRK","7","14","14","Yesu akalilohiki kabheti lipogha la bhandu lela, na kubhapwaghila, “Nyowanyaje mabhokape, na mmanyaje. ");
INSERT INTO mpa_vpl VALUES ("MK7_15","071_7_15","MRK","7","15","15","Nga chindu cheakula mundu chechiweza kuntenda mundu abya nhwakau. Nambu chechipita mumtima jaka mundu nde chechuntenda mundu abya nhwakau. ");
INSERT INTO mpa_vpl VALUES ("MK7_16","071_7_16","MRK","7","16","16","Joabhi na makutu gha kujowanela, na ajowanaje!” ");
INSERT INTO mpa_vpl VALUES ("MK7_17","071_7_17","MRK","7","17","17","Paalilekiki lipogha la bhandu na kujingi munyumba, bhabhulwa bhaki bhakundaluki ndandi ja mabholu gha ulenganesu ghonighola. ");
INSERT INTO mpa_vpl VALUES ("MK7_18","071_7_18","MRK","7","18","18","Na jombi akabhapwaghile, “Bho, hata mwanganya le ngachemmanye? Bho, ngachemmanyi kubha chindu chechunjingi mundu kuhuma kunja ngachechiweza kuntenda mundu abya muhakau, ");
INSERT INTO mpa_vpl VALUES ("MK7_19","071_7_19","MRK","7","19","19","maghambu ngachechunjingi mumtima, nambu mulutumbo, na ujomukelu waki kupita kunja kulikelo?” Kwa kupwagha bhenibhela Yesu akaigholwi ilebhi yokapi. ");
INSERT INTO mpa_vpl VALUES ("MK7_20","071_7_20","MRK","7","20","20","Akajendali kupwagha, “Mambu ghaghapita nkati jaka mundu, nde ghaghuntenda mundu abya muhakau. ");
INSERT INTO mpa_vpl VALUES ("MK7_21","071_7_21","MRK","7","21","21","Kwa ndandi kuhuma nkati, mumtima waka mundu, ghapita maholalelu ghaliyaha, ukemi, ");
INSERT INTO mpa_vpl VALUES ("MK7_22","071_7_22","MRK","7","22","22","wihi, kukoma, ugone, utokulelu uhakau, milomu, wime, kukoloha, malobhi gha utane na wihu, matondu, ing'omu na ung'ang'a. ");
INSERT INTO mpa_vpl VALUES ("MK7_23","071_7_23","MRK","7","23","23","Mahakau ghanihagha ghokapi ghahuma mumtima waka mundu, na ghombi nde ghaghuntenda mundu abya muhakau.” ");
INSERT INTO mpa_vpl VALUES ("MK7_24","071_7_24","MRK","7","24","24","Bhela Yesu akabhokiki panipala, akapiti ku inchi ja ku Tilo. Konihoku akajingi mu nyumba jimu na ngachepai mundu amanyaje, nambu ngacheaweziki kulihiya. ");
INSERT INTO mpa_vpl VALUES ("MK7_25","071_7_25","MRK","7","25","25","Nambu mbomba jumu joakabhi na mwali waki joakabhi na lijobhi, akajowini malobhi ghaka Yesu, akahikiki na kulileke palongi ja magholu ghaki. ");
INSERT INTO mpa_vpl VALUES ("MK7_26","071_7_26","MRK","7","26","26","Mbomba hoju akabhi Mgiliki, mwenei wa ku Silofainike. Akundobhiki Yesu amboha kamwali waki lijobhi. ");
INSERT INTO mpa_vpl VALUES ("MK7_27","071_7_27","MRK","7","27","27","Yesu akumpwaghile, “Ubhalekaje bhana bhatupila hoti, kwa ndandi nga wichu kutola chilebhi cha bhana na kujenda kuipeke nakawa.” ");
INSERT INTO mpa_vpl VALUES ("MK7_28","071_7_28","MRK","7","28","28","Nambu mabhu jola akapwaghike, “Chakaka, Bambo, hata nakawa yeibhi pahi ja meza ikula mahighalilu gha ilebhi ya bhana.” ");
INSERT INTO mpa_vpl VALUES ("MK7_29","071_7_29","MRK","7","29","29","Yesu akumpwaghile, “Kwa ndandi ja lilobhi leniheli, ubhujaje kunyumba jaku. Lijobhi lumbokiki mwali waku!” ");
INSERT INTO mpa_vpl VALUES ("MK7_30","071_7_30","MRK","7","30","30","Bhela akapiti kunyumba jaki, akunketani mwana aghoni pachitanda na lijobhi lumbokike. ");
INSERT INTO mpa_vpl VALUES ("MK7_31","071_7_31","MRK","7","31","31","Yesu akabhokiki ku inchi ja ku Tilo, akapetili ku Sidoni, akahikiki ku bahali ja Galilaya kwa kupetela inchi ja ku Dekapoli. ");
INSERT INTO mpa_vpl VALUES ("MK7_32","071_7_32","MRK","7","32","32","Bhela bhakundeti mpuli, najombi akabhi ngajowa, bhakunjopiki ambekila mabhoku nahuli andamihaje. ");
INSERT INTO mpa_vpl VALUES ("MK7_33","071_7_33","MRK","7","33","33","Yesu akumbohiki mundu jola pa lipogha la bhandu na akunjingi ngonji mu makutu ghaka mundu jola, akahuni imata mu ngonji yaki na kunkamu mundu jola pa lulimi. ");
INSERT INTO mpa_vpl VALUES ("MK7_34","071_7_34","MRK","7","34","34","Panihapa Yesu akalingali kunani kumahunde kwaka Chapanga, akapomwi kwa makili, na kumpwaghila, “Efata,” ndandi jaki, “Uhoghukaje.” ");
INSERT INTO mpa_vpl VALUES ("MK7_35","071_7_35","MRK","7","35","35","Palapala mundu jola akatumbwi kujowana wichu, na chifungu cha lulimi lwaki chakabhopwiki, na kulonge wichu. ");
INSERT INTO mpa_vpl VALUES ("MK7_36","071_7_36","MRK","7","36","36","Yesu akabhakanaki ngabhampwaghi mundu jokapi jola lilobhi lenihele. Nambu ngati moakabhakanakili, nde mobhajendalili kutangaza lilobhi lenihele. ");
INSERT INTO mpa_vpl VALUES ("MK7_37","071_7_37","MRK","7","37","37","Bhandu bhakakangichi namaa na kupwagha, “Atehi ghokapi wichu. Abhatenda hata akangajowa kujowana, na akabhapuli kulongela!” ");
INSERT INTO mpa_vpl VALUES ("MK8_1","071_8_1","MRK","8","1","1","Chikahi hechi, lipogha likolongwa la bhandu bhakalibhongini kabheti, na ngachebhabhi na chilebhe. Yesu akabhalohiki kabheti bhabhulwa bhaki, na kubhapwaghila, ");
INSERT INTO mpa_vpl VALUES ("MK8_2","071_8_2","MRK","8","2","2","“Nabhabhone chiha bhandu abhabha ndandi bhabhi na nepani kwa machobha ghatatu, wala ngachebhabhi na chilebhe. ");
INSERT INTO mpa_vpl VALUES ("MK8_3","071_8_3","MRK","8","3","3","Ananalekiki bhajenda kunyumba koni bhabhi na injala anabhang'anduka mwindela, ndandi bhangi bhahumiki kutale.” ");
INSERT INTO mpa_vpl VALUES ("MK8_4","071_8_4","MRK","8","4","4","Bhabhulwa bhaki bhakundaluki, “Pandu pani pachingwenje, bho, anaghapatikana kwaku mabumunda gha kubhajaghanila bhandu abhabha bhokape?” ");
INSERT INTO mpa_vpl VALUES ("MK8_5","071_8_5","MRK","8","5","5","Yesu akabhalalukile, “Bho, mbinaghu mabumunda ghalenga?” Bhakayangiki, “Tubhi na mabumunda saba.” ");
INSERT INTO mpa_vpl VALUES ("MK8_6","071_8_6","MRK","8","6","6","Bhela akabhalaghalaki bhandu bhatama pahi. Akatohi mabumunda saba ghala, na kunchengu Chapanga, na kujiheketa, na kubhapeke bhabhulwa bhaki bhaghabhila bhandu, na bhombi bhakabhaghabhile. ");
INSERT INTO mpa_vpl VALUES ("MK8_7","071_8_7","MRK","8","7","7","Bhakabhi kabheti na tuhomba tuchokope. Yesu akaipengalili, na kubhalaghalaki bhabhulwa bhaki bhabhaghabhila bhandu bhelabhela. ");
INSERT INTO mpa_vpl VALUES ("MK8_8","071_8_8","MRK","8","8","8","Bhandu bhakakuliki, na kutupila. Bhakabhongini mahighalilu na kutwelakela hitonga saba. ");
INSERT INTO mpa_vpl VALUES ("MK8_9","071_8_9","MRK","8","9","9","Na bhandu bhabhakuliki bhakabhi ngati elufu ncheche. Bhela Yesu akabhatawiki, ");
INSERT INTO mpa_vpl VALUES ("MK8_10","071_8_10","MRK","8","10","10","na palapala akakwehi mu ngalawa papamu na bhabhulwa bhaki, akapiti ku Dalimanuta. ");
INSERT INTO mpa_vpl VALUES ("MK8_11","071_8_11","MRK","8","11","11","Mafalisayo bhakahikiki na kutumbu kulongalane na Yesu. Kwa kumpendakela, bhakumpaliki ahenga nginyulila nahuli kulangi ngati ahuma kunani kwaka Chapanga. ");
INSERT INTO mpa_vpl VALUES ("MK8_12","071_8_12","MRK","8","12","12","Yesu akayomiki muroho, “Bho, mbona kibheleku chenjenu chipala nginyulila? Numpwaghi chakaka! Chibheleku chenjenu ngachipati nginyuli jokapi jela.” ");
INSERT INTO mpa_vpl VALUES ("MK8_13","071_8_13","MRK","8","13","13","Bhela akabhalekiki, akajingi mungalawa, na kutumbu mwanja kulomboka kwihi ja nhwanga. ");
INSERT INTO mpa_vpl VALUES ("MK8_14","071_8_14","MRK","8","14","14","Bhabhulwa bhakabhi bhajewiki kutotola mabumunda ghamahele, nambu bhakabhi na libumuda limu pela mu ngalawa jela. ");
INSERT INTO mpa_vpl VALUES ("MK8_15","071_8_15","MRK","8","15","15","Yesu akabhakanakile, “Ntama kutali na mlilingalya wichu na amila ja Mafalisayo na amila jaka Helode.” ");
INSERT INTO mpa_vpl VALUES ("MK8_16","071_8_16","MRK","8","16","16","Bhabhulwa bhakatumbwi kulonge bheni kwa bheni, “Apwagha bhenibhela ndandi ngachetubhi na mabumunda.” ");
INSERT INTO mpa_vpl VALUES ("MK8_17","071_8_17","MRK","8","17","17","Yesu akaghamanyi ghanihagha, akabhapwaghile, “Bho, ndongalane bhenibhela maghambu ngachembi na mabumunda? Bho, mwakali nga kumanya? Bho, maghambu kiki mitima jinu jitopike? ");
INSERT INTO mpa_vpl VALUES ("MK8_18","071_8_18","MRK","8","18","18","Mbi na mihu, nambu ngachendinga? Mbi na makutu, nambu ngachenjowana? Bho, ngachenkomboka? ");
INSERT INTO mpa_vpl VALUES ("MK8_19","071_8_19","MRK","8","19","19","Chikahi panahekiti mabumunda nhwanu na kubhapeke bhandu elufu nhwano, mkabhongini itonga ilenga ya mahighalilu?” Bhakamuyangiki, “Itonga komi na ibheli.” ");
INSERT INTO mpa_vpl VALUES ("MK8_20","071_8_20","MRK","8","20","20","Akabhalaluki kabheti, “Na panahekiti mabumunda saba na kubhapeke bhandu elufu ncheche, mwakabhongini mahighalilu itonga ilenga?” Bhakamuyangiki, “Itonga saba.” ");
INSERT INTO mpa_vpl VALUES ("MK8_21","071_8_21","MRK","8","21","21","Bhela akabhapwaghile, “Bho, mwakali le ngakumanya?” ");
INSERT INTO mpa_vpl VALUES ("MK8_22","071_8_22","MRK","8","22","22","Yesu akahiki ku Betisaida papamu na bhabhulwa bhaki. Bhandu bhakundeti ngalola, bhakunjopiki ankamula nahuli andamihaje. ");
INSERT INTO mpa_vpl VALUES ("MK8_23","071_8_23","MRK","8","23","23","Yesu akunkamwi ngalola jola chiwoku akumpeliki kunja ja chijiji. Akunhuni imata mumihu, akumbeki mabhoku, na kundalukila, “Bho, uchibhona chindu?” ");
INSERT INTO mpa_vpl VALUES ("MK8_24","071_8_24","MRK","8","24","24","Ngalola jola akalingiki kunani, na kupwagha, “Nabhabhona bhandu bhabhonikana ngati mikongu jejijenda.” ");
INSERT INTO mpa_vpl VALUES ("MK8_25","071_8_25","MRK","8","25","25","Bhela Yesu akumbeki kabheti mabhoku mumihu. Na jombi akatupiki mihu na uwezu waki wa kulola ukunkelabhukili na akaweni kila chindu wichu. ");
INSERT INTO mpa_vpl VALUES ("MK8_26","071_8_26","MRK","8","26","26","Yesu akumpwaghi abhuja kunyumba jaki na kundakalila, “Ngawikelabhuka kuchijiji, wala kumpwaghila mundu jokapi jola.” ");
INSERT INTO mpa_vpl VALUES ("MK8_27","071_8_27","MRK","8","27","27","Bhela Yesu na bhabhulwa bhapita kuijiji ya ku Kaisalia Filipi. Pabhakabhi mwindela, Yesu akabhalaluki bhabhulwa bhaki, “Bho, bhandu bhapwagha kubha nepani nde nane?” ");
INSERT INTO mpa_vpl VALUES ("MK8_28","071_8_28","MRK","8","28","28","Bhakamuyangiki, “Bhangi bhapwagha wehapa wa Yohana Mbatizaji, bhangi Eliya na jumu wa bhalota bhaka Chapanga.” ");
INSERT INTO mpa_vpl VALUES ("MK8_29","071_8_29","MRK","8","29","29","Na jombi akabhalalukile, “Mwanganya bho, mpwagha nepani nde nane?” Petulu akayangiki, “Wehapa nde Kristo.” ");
INSERT INTO mpa_vpl VALUES ("MK8_30","071_8_30","MRK","8","30","30","Panihapa Yesu akabhakanaki ngabhampwaghi mundu jokapi jola malobhi ghaki. ");
INSERT INTO mpa_vpl VALUES ("MK8_31","071_8_31","MRK","8","31","31","Yesu akatumbwi kwabhola bhabhulwa bhaki, “Impalika Mwana waka Mundu ang'ahikaje pamaheli na kukanakika na bhazee na bhapenganyambiku bhakolongwa na bhabhola bha Shelia. Bhela anakomakikaji, na baada ja machobha ghatatu anahyokaje.” ");
INSERT INTO mpa_vpl VALUES ("MK8_32","071_8_32","MRK","8","32","32","Yesu akabhapwaghi lilobhi heli hotuhotu. Bhela Petulu akundohiki Yesu punkeghi, na kunkanaki ngaipwagha mambu ghanihagha. ");
INSERT INTO mpa_vpl VALUES ("MK8_33","071_8_33","MRK","8","33","33","Nambu Yesu akang'anambwiki, akabhalingali bhabhulwa bhaki, akunkenjuki Petulu, akapwaghaje, “Shetani, bhokaje palongi jango! Maholalelu ghaku nga ghaka Chapanga, nambu gha bhandu.” ");
INSERT INTO mpa_vpl VALUES ("MK8_34","071_8_34","MRK","8","34","34","Kabheti akalilohiki lipogha la bhandu papamu na bhabhulwa bhaki na kubhapwaghila, “Ngati mundu jokapi apala kunyengalela nepani, impalika alikana mwene, autola nsalaba waki na anyengalyaje. ");
INSERT INTO mpa_vpl VALUES ("MK8_35","071_8_35","MRK","8","35","35","Ndandi mundu joapala kukengalela womi waki mweni, anauhoaje, nambu mundu joahoa womi waki kwa ndandi jangu nepani na kwa ndandi ja Malobhi Manyahi, anaukengalyaje. ");
INSERT INTO mpa_vpl VALUES ("MK8_36","071_8_36","MRK","8","36","36","Bho, anakunjangatya kiki mundu kuupata ndema wokapi, na kughahoa matamu ghaki mweni? ");
INSERT INTO mpa_vpl VALUES ("MK8_37","071_8_37","MRK","8","37","37","Kabheti mundu anabhoha chindu bholi nahuli aghapata kabheti matamu ghaki mweni? ");
INSERT INTO mpa_vpl VALUES ("MK8_38","071_8_38","MRK","8","38","38","Mundu jokapi muchibheleku chenjenu chihakau na changakubha na ulongwana kwaka Chapanga, joamone iyoni nepani na mabholu ghangu, Mwana waka Mundu anambonila iyoni mundu hoju, chikahi paanahikaje mu ulumbalilu wa Atati waki papamu na bhatumika bhahuhu bha kunani kwaka Chapanga.” ");
INSERT INTO mpa_vpl VALUES ("MK9_1","071_9_1","MRK","9","1","1","Yesu akajendali kubhapwaghila, “Numpwaghi chakaka, bhabhi bhandu bhangi bhabhajemiki pambani, ambabhu ngabhipoteli ng'o, mbaka pabhaubhona Ukolongwa waka Chapanga ukahikaje kwa makili.” ");
INSERT INTO mpa_vpl VALUES ("MK9_2","071_9_2","MRK","9","2","2","Paghapetiki machobha sita, Yesu akabhatoliki Petulu, Yakobo na Yohana na kujenda nabhu kunani ja chitombi chikolongwa kanjika jabhu. Konihoku bhakumbweni akang'anambuka pamihu palongi jabhu, ");
INSERT INTO mpa_vpl VALUES ("MK9_3","071_9_3","MRK","9","3","3","ingobhu yaki ikang'anyiki, ikang'anyiki kupukupu nga mundu pundema joakaweza kwing'anyiha ngati bhenibhela. ");
INSERT INTO mpa_vpl VALUES ("MK9_4","071_9_4","MRK","9","4","4","Bhabhulwa bhatatu bhala bhakabhaweni Eliya na Musa bhakalongilaje na Yesu. ");
INSERT INTO mpa_vpl VALUES ("MK9_5","071_9_5","MRK","9","5","5","Petulu akumpwaghi Yesu, “Mbola, nde wichu tepani tubya pambane! Tuchengaje indamba itatu, chimu chaku, chimu chaka Musa na chengi chaka Eliya.” ");
INSERT INTO mpa_vpl VALUES ("MK9_6","071_9_6","MRK","9","6","6","Petulu na bhajaki bhakajowipi namaa, hata ngacheamanyi cha kulongela. ");
INSERT INTO mpa_vpl VALUES ("MK9_7","071_9_7","MRK","9","7","7","Bhela likapitali lihundi na kubhayeka, na sauti jakajowaniki kuhuma mu lihundi hele, “Hajoju nde Mwana wangu mpalu, munjowanya jombe!” ");
INSERT INTO mpa_vpl VALUES ("MK9_8","071_9_8","MRK","9","8","8","Palapala bhabhulwa bhaki bhakalingali kabheti, nambu ngachebhumbweni mundu jonge nambu Yesu kanjika jaki papamu na bheni pela. ");
INSERT INTO mpa_vpl VALUES ("MK9_9","071_9_9","MRK","9","9","9","Bhela pabhabhila bhahele pachitombi, Yesu akabhakanaki, “Ngabhumpwaghi mundu jokapi jola mambu ghabhaghaweni, mbaka Mwana waka Mundu paibya ayokiki kabheti.” ");
INSERT INTO mpa_vpl VALUES ("MK9_10","071_9_10","MRK","9","10","10","Bhela bhakalikamwi lilaghalaki hele, bhakatumbwi kulaluwana bheni kwa bheni, “Bho, kuyoka kwa bhabhapotile nde kike?” ");
INSERT INTO mpa_vpl VALUES ("MK9_11","071_9_11","MRK","9","11","11","Bhakundaluki Yesu, “Bho, mbona bhabhola bha Shelia bhapwagha Eliya anatumbula kuhika?” ");
INSERT INTO mpa_vpl VALUES ("MK9_12","071_9_12","MRK","9","12","12","Na jombi akabhayangiki, “Ena, Eliya anahika hoti kulenganake ghokapi. Hata bhela bho, maghambu ki ilembakiki mu Malembu Mahuhu kubha Mwana waka Mundu ahipata mang'ahiku ghamaheli na kuntondola? ");
INSERT INTO mpa_vpl VALUES ("MK9_13","071_9_13","MRK","9","13","13","Nambu numpwaghila, Eliya ajomwi kuhika na bhombi bhakuntendi ngati mobhapalila bheni ngati mokwalembakike mu Malembu Mahuhu panani jaki.” ");
INSERT INTO mpa_vpl VALUES ("MK9_14","071_9_14","MRK","9","14","14","Yesu na bhabhulwa bhangi bhatatu bhala, bhakakelawiki mbaka pabhakabhi bhabhulwa bhangi, bhakaliweni lipogha likolongwa la bhandu papo. Na bhabhola bhangi bha Shelia bhakabhi bhalochana nabhu. ");
INSERT INTO mpa_vpl VALUES ("MK9_15","071_9_15","MRK","9","15","15","Palapala lipogha la bhandu pabhakumbweni Yesu, bhakakangichi namaa, bhakunkembali nahuli bhundamukyaje. ");
INSERT INTO mpa_vpl VALUES ("MK9_16","071_9_16","MRK","9","16","16","Yesu akabhalaluki bhabhulwa, “Bho, ndochana nabhu kike?” ");
INSERT INTO mpa_vpl VALUES ("MK9_17","071_9_17","MRK","9","17","17","Panihapa mundu jumu pa lipogha la bhandu akayangike, “Mbola, nundetiki mwana wangu kwako, abhi na lijobhi leluntei abya mpuli. ");
INSERT INTO mpa_vpl VALUES ("MK9_18","071_9_18","MRK","9","18","18","Kila paghuntukalila, ghunhabhu pahi na kuntenda ghumpita mahuluhulu mundomu, koni akayagha minu ghaki na kujomangana hyegha joha. Nakabhajopiki bhabhulwa bhaku bhumboha lijobhi, nambu ngachebhawezike.” ");
INSERT INTO mpa_vpl VALUES ("MK9_19","071_9_19","MRK","9","19","19","Yesu akabhapwaghile, “Mwanganya chibheleku changakubha na uhobhalelu! Bho, ananunhinakya mbaka lile? Mundeta nkombu wehoju kwangu nepani!” ");
INSERT INTO mpa_vpl VALUES ("MK9_20","071_9_20","MRK","9","20","20","Bhakumpeliki kwaka Yesu. Palapala lijobhi paakumbweni Yesu, akunjeghi mwana jola chihinduhindu, na mwana akaawiki pahi, akaghalawiki na kumpita mahuluhulu mundomu. ");
INSERT INTO mpa_vpl VALUES ("MK9_21","071_9_21","MRK","9","21","21","Yesu akundaluki tati waka mwana jola, “Hindu heyi yumpatiki kutumbu lile? Na jombi akamuyangiki, “Kutumbu umwana waki. ");
INSERT INTO mpa_vpl VALUES ("MK9_22","071_9_22","MRK","9","22","22","Na pamaheli lijobhi hoju angalawi nkombu hoju pamoto na mumachi, nahuli ankomaje. Henu, anauweza kuhenga lijambu lokapi lela, utubhonila chiha na utujangatyaje!” ");
INSERT INTO mpa_vpl VALUES ("MK9_23","071_9_23","MRK","9","23","23","Yesu akumpwaghile, “Bho, maghambu ki upwagha ngati anauweza? Mambu ghokape ghaweza kuhengakeka kwaka mundu joahobhalela.” ");
INSERT INTO mpa_vpl VALUES ("MK9_24","071_9_24","MRK","9","24","24","Palapala, tati jola akaleliki kwa makili, “Nenga nhobhalela! Nambu uhobhalelu wangu nde kuchoko, unyangatya kuhobhalela nakanope.” ");
INSERT INTO mpa_vpl VALUES ("MK9_25","071_9_25","MRK","9","25","25","Yesu paakaliweni lipogha la bhandu lijonjukeka palongi jaki, akundakali lijobhi jola, “Lijobhi weuntenda mwana ajoju abya mpuli na ngajogwa, nukulaghalakila umboka mwana ajoju, na wala ngawanjingi kabhete!” ");
INSERT INTO mpa_vpl VALUES ("MK9_26","071_9_26","MRK","9","26","26","Palapala lijobhi lela lakajamalili, lakungalawi mwana jola pahi na lakumpitike. Mwana akabhonakini ngati joapotile na bhela bhandu bhangi bhakapwaghiki, “Apotile!” ");
INSERT INTO mpa_vpl VALUES ("MK9_27","071_9_27","MRK","9","27","27","Nambu Yesu akunkamwi chiwoku, akunjangati kujema, najombi akajemiki. ");
INSERT INTO mpa_vpl VALUES ("MK9_28","071_9_28","MRK","9","28","28","Bhela, Yesu paakajingi mu nyumba, bhabhulwa bhaki bhakundalukile, “Bho, maghambu ki tepani ngachetaweziki kulibhoha lijobhi lela?” ");
INSERT INTO mpa_vpl VALUES ("MK9_29","071_9_29","MRK","9","29","29","Yesu akabhapwaghile, “Majobhi gha bhenibhela ngacheghaweza kubhoka, nambu kwa indela ja kundobha Chapanga.” ");
INSERT INTO mpa_vpl VALUES ("MK9_30","071_9_30","MRK","9","30","30","Yesu na bhabhulwa bhaki bhakabhokiki panihapa, bhakajendali na mwanja kupete ku Galilaya. Yesu ngachepaliki bhandu bhamanya ngati abhi ku inchi jaki hoku, ");
INSERT INTO mpa_vpl VALUES ("MK9_31","071_9_31","MRK","9","31","31","maghambu akabhi abhabhola bhabhulwa bhaki. Akabhapwaghile, “Mwana waka Mundu anabhumpelaka kwa bhandu na bhombi anabhunkomaje, nambu lichobha la katatu anahyokaje.” ");
INSERT INTO mpa_vpl VALUES ("MK9_32","071_9_32","MRK","9","32","32","Nambu bhabhulwa bhaki ngachebhamanyi malobhi ghalongela, na bhakajowipi kundalukila. ");
INSERT INTO mpa_vpl VALUES ("MK9_33","071_9_33","MRK","9","33","33","Bhela, bhakahiki ku Kapelenaumu. Na paakabhi mu nyumba akabhalaluki, “bho, ndongalanya ki mwindela?” ");
INSERT INTO mpa_vpl VALUES ("MK9_34","071_9_34","MRK","9","34","34","Nambu bhombi ngachebhumpwaghile, ndandi pabhakabhi mwindela bhakalochini kubha nde nane nkolongwa pachilanda jabhu. ");
INSERT INTO mpa_vpl VALUES ("MK9_35","071_9_35","MRK","9","35","35","Yesu akatemi pahi, akabhalohiki komi na bhabheli, na kubhapwaghila, “Mundu anapahi kubha wa kutumbula, impalika akubhaje wa kujomukela na akubhaje mtumika wa bhokapi.” ");
INSERT INTO mpa_vpl VALUES ("MK9_36","071_9_36","MRK","9","36","36","Kabheti Yesu akuntohi mwana nchokuchoku, akunjemiki pachilanda jabhu, akunjobhatili na kubhapwaghila, ");
INSERT INTO mpa_vpl VALUES ("MK9_37","071_9_37","MRK","9","37","37","“Joanjopale mwana ngati jonjo kwa lihina langu, anyopale nepani, na joanyopale nepani, ngacheanyopale nepani pela, nambu anjopale jola joandumike.” ");
INSERT INTO mpa_vpl VALUES ("MK9_38","071_9_38","MRK","9","38","38","Yohana akumpwaghi Yesu, “Mbola, tumbweni mundu jumu aghabhoha majobhi kwa lihina laku. Na tepani tukalengiki kunkanakila ndandi jombi ngacheabhi papamu na tepani.” ");
INSERT INTO mpa_vpl VALUES ("MK9_39","071_9_39","MRK","9","39","39","Nambu Yesu akabhapwaghile, “Ngamwankanakila, ndandi nga mundu joaweza kutenda ngangachu kwa lihina langu, na palapala kunongale mahakau. ");
INSERT INTO mpa_vpl VALUES ("MK9_40","071_9_40","MRK","9","40","40","Ndandi jwangakutupenga tepani abhi upambala wito. ");
INSERT INTO mpa_vpl VALUES ("MK9_41","071_9_41","MRK","9","41","41","Mundu jokapi jola joampekya chikombi cha machi gha kunywa, kwa kubha mabhanganya mabhandu bhaka Kristo, chakaka ngailepi kupata nhupu waki. ");
INSERT INTO mpa_vpl VALUES ("MK9_42","071_9_42","MRK","9","42","42","“Mundu jokapi joanaantenda jumu wa bhachoku abhabha bhabhanhobhale nepani kuhenga mahoku, ikabya mbaka kwaka mundu hoju kukongakeka liganga likolongwa la kuyaghila na kulekaleka mubahali. ");
INSERT INTO mpa_vpl VALUES ("MK9_43","071_9_43","MRK","9","43","43","Chiwoku chaku anachikutendiki utendaje mahoku, hekataje! Mbanga kujingi mu womi panga chiwoku chimu, kuliku kubha na mabhoku ghabheli na kujenda ku Jehanamu, mu moto wangakuchuchuka. ");
INSERT INTO mpa_vpl VALUES ("MK9_44","071_9_44","MRK","9","44","44","Momuje, tundu twaki ngachetukuwa, wala moto waki ngacheuchuchuka. ");
INSERT INTO mpa_vpl VALUES ("MK9_45","071_9_45","MRK","9","45","45","Na chigholu chaku anachikutendiki utendaje mahoku, hekataje! Mbanga kujingi mu womi panga chigholu chimu, kuliku kubha na magholu ghokapi na kukujeghe ku Jehanamu, mu moto wangakuchuchuka. ");
INSERT INTO mpa_vpl VALUES ("MK9_46","071_9_46","MRK","9","46","46","Momuje, tundu twaki ngachetukuwa, wala moto waki ngacheuchuchuka. ");
INSERT INTO mpa_vpl VALUES ("MK9_47","071_9_47","MRK","9","47","47","Na lihu laku analukutendiki utendaje mahoku, litupulaje! Mbanga kujingi mu Ukolongwa waka Chapanga ukabya na lihu limu pela, kuliku kubha na mihu ghaku ghokapi ghabheli na kulekaleka mu moto wa Jehanamu. ");
INSERT INTO mpa_vpl VALUES ("MK9_48","071_9_48","MRK","9","48","48","Momuje tumbeku twaki ngachetukuwa, wala moto waki ngacheuchuchuka. ");
INSERT INTO mpa_vpl VALUES ("MK9_49","071_9_49","MRK","9","49","49","“Ndandi kila mundu anagholulikaji kwa mwinyu, ngati nyambiku mojigholulakela kwa moto. ");
INSERT INTO mpa_vpl VALUES ("MK9_50","071_9_50","MRK","9","50","50","“Mwinyu nde wamboni, nambu anauhoiki kunogha kwaki, bho, anaukolakika na kyane? “Mbya na mwinyu wa ukochi nkati jinu, na mkamulakyaje kutama kwa lukwale mabheti kwa mabheti.” ");
INSERT INTO mpa_vpl VALUES ("MK10_1","071_10_1","MRK","10","1","1","Yesu akabhokiki panihapa na kujenda ku Yudea, mbaka kwihi ja Nkoka Yoludani. Lipogha likolongwa la bhandu lakunjendi kabheti, najombi akabhabholiki ngati mowabheli ntetu waki. ");
INSERT INTO mpa_vpl VALUES ("MK10_2","071_10_2","MRK","10","2","2","Panihapa Mafalisayo bhakunjendili, na kwa kundenga bhakundalukile, “Bho, Amuli jaka Chapanga le jijetakela mwanalomi kundeka nhwanu wake?” ");
INSERT INTO mpa_vpl VALUES ("MK10_3","071_10_3","MRK","10","3","3","Yesu akabhayangike, “Bho, Musa akundaghalaki bhole?” ");
INSERT INTO mpa_vpl VALUES ("MK10_4","071_10_4","MRK","10","4","4","Na bhombi bhakamuyangike, “Musa akalaghalaki mwanalomi ngaandeka nhwanu waki mbaka ampekya baluwa ja kulekana na kundeka.” ");
INSERT INTO mpa_vpl VALUES ("MK10_5","071_10_5","MRK","10","5","5","Yesu akabhapwaghile, “Musa akundembi amuli jeniheji kwa ndandi ja kunonopa kwa mitima jinu. ");
INSERT INTO mpa_vpl VALUES ("MK10_6","071_10_6","MRK","10","6","6","Nambu kutumbu kubhombakeka ndema, Chapanga akumbombiki mwanalomi na mbomba. ");
INSERT INTO mpa_vpl VALUES ("MK10_7","071_10_7","MRK","10","7","7","Bhela mwanalomi anaandeka tati waki na mabhu waki, na kulombana papamu na nhwanu waki machobha ghokape, ");
INSERT INTO mpa_vpl VALUES ("MK10_8","071_10_8","MRK","10","8","8","na bhombi bhabheli habha anabhakubhaje hyegha jimu. Bhela, bhombi nga bhabheli kabhete, nambu hyegha jimu. ");
INSERT INTO mpa_vpl VALUES ("MK10_9","071_10_9","MRK","10","9","9","Bhela, chealombanishi Chapanga, mundu ngayilombola.” ");
INSERT INTO mpa_vpl VALUES ("MK10_10","071_10_10","MRK","10","10","10","Pabhakajingi kabheti mu nyumba, bhabhulwa bhaki bhakundaluki panani ja libholu lenihele. ");
INSERT INTO mpa_vpl VALUES ("MK10_11","071_10_11","MRK","10","11","11","Na jombi akabhapwaghile, “Joandeka nhwanu waki na kuntoghola jongi, antende ugoni nhwanu waki. ");
INSERT INTO mpa_vpl VALUES ("MK10_12","071_10_12","MRK","10","12","12","Bhelabhela na mbomba joandeka ndomi waki na kutoghuleka na jongi, atenda ugone.” ");
INSERT INTO mpa_vpl VALUES ("MK10_13","071_10_13","MRK","10","13","13","Bhandu bhakundeti Yesu bhana bhachoku bhachoku nahuli abhapengalyaje, nambu bhabhulwa bhaki bhakabhalakalile. ");
INSERT INTO mpa_vpl VALUES ("MK10_14","071_10_14","MRK","10","14","14","Yesu paakaweni bhenibhela, akahakalili namaa, akabhapwaghile, “Mwabhaleka bhana abhabha bhahika kwangu nepani, wala ngamwahibhalila, maghambu Ukolongwa waka Chapanga ubhi kwa ndandi ja bhandu bhabhabhi ngati bhana abhabha. ");
INSERT INTO mpa_vpl VALUES ("MK10_15","071_10_15","MRK","10","15","15","Numpwaghi chakaka, mundu jokapi jwangakupala kujopalela Ukolongwa waka Chapanga ngati mwana nchoku ngaijingi monihomu ng'o.” ");
INSERT INTO mpa_vpl VALUES ("MK10_16","071_10_16","MRK","10","16","16","Bhela akabhajopiki bhana habha, akabhabheki mabhoku na kubhapengalela. ");
INSERT INTO mpa_vpl VALUES ("MK10_17","071_10_17","MRK","10","17","17","Yesu patumbula kabheti mwanja waki, mundu jumu akunkembalili, akunchikamili palongi jaki, na kundalukila, “Mbola wambone, bho, ndenda bhole nahuli mbata kuupwelela womi wa mileli?” ");
INSERT INTO mpa_vpl VALUES ("MK10_18","071_10_18","MRK","10","18","18","Yesu akamuyangike, “Bho, mbona unoha wambone? Njeta joabhi wambone nambu jumu pela, yani Chapanga kanjika jaki. ");
INSERT INTO mpa_vpl VALUES ("MK10_19","071_10_19","MRK","10","19","19","Wimanyi le amuli, ‘Ngawihenga ugoni, ngawikoma, ngawijibha, ngawilonge upuhe, ngawikolowa, untopilaje tati waku na mabhu waku.’ ” ");
INSERT INTO mpa_vpl VALUES ("MK10_20","071_10_20","MRK","10","20","20","Na jombi akayangike, “Mbola, ghanihagha ghokapi naghakamwili kutumbu umwana wangu.” ");
INSERT INTO mpa_vpl VALUES ("MK10_21","071_10_21","MRK","10","21","21","Yesu akundingali, na kumpala, akumpwaghile, “Chihighali chindu chimu. Ujendaje ukalombisaje kila chindu cheubhi nachu, ukabhapekya bhahochu mbija yene, na wenga walibhekila chikoku kunani kumahunde. Anautehi bhenibhela, utola msalaba waku, na uhika unyengalyaje.” ");
INSERT INTO mpa_vpl VALUES ("MK10_22","071_10_22","MRK","10","22","22","Paakajowini ghanihagha, akatondike, akabhokiki koni mtima umbina, ndandi akabhi na hindu yamahele na ngacheakapaliki kuighabha hindu yaki. ");
INSERT INTO mpa_vpl VALUES ("MK10_23","071_10_23","MRK","10","23","23","Yesu akalingali ipambala yokapi, akabhapwaghi bhabhulwa bhaki, “Kunonwipi namaa kwa bhanahindu yamahele kujingi mu Ukolongwa waka Chapanga!” ");
INSERT INTO mpa_vpl VALUES ("MK10_24","071_10_24","MRK","10","24","24","Bhabhulwa bhaki bhakakangichi kwa malobhi ghaki. Yesu akabhapwaghi kabhete, “Bhana bhangu, kunonwipi namaa kwa bhandu bhabhahobhalela hindu yamaheli, kujingila mu Ukolongwa waka Chapanga! ");
INSERT INTO mpa_vpl VALUES ("MK10_25","071_10_25","MRK","10","25","25","Kupepwiki namaa kwa chinyama chechilowakeka ngamia kuholota mu limboghi la sindano, kuliku mwanahindu yamaheli kujingi mu Ukolongwa waka Chapanga!” ");
INSERT INTO mpa_vpl VALUES ("MK10_26","071_10_26","MRK","10","26","26","Bhabhulwa bhaki bhakakangichi namaa, bhakalaluhine, “Bho, nane henu, joanawezaje kukengaleka?” ");
INSERT INTO mpa_vpl VALUES ("MK10_27","071_10_27","MRK","10","27","27","Yesu akabhalingalili, na kubhapwaghila, “Kwa bhandu ngakuwezikana, nambu kwaka Chapanga ngabhela, ndandi kwaka Chapanga kila chindu chiwezikana.” ");
INSERT INTO mpa_vpl VALUES ("MK10_28","071_10_28","MRK","10","28","28","Kabheti Petulu akumpwaghile, “Lingalyaje! Na tepani bhole? Tughalekiki ghokapi, na kukujengalela wehapa!” ");
INSERT INTO mpa_vpl VALUES ("MK10_29","071_10_29","MRK","10","29","29","Yesu akapwaghike, “Chakaka numpwaghila, kila mundu joajilehi nyumba, au bhalongu, au bhalombu, au mabhu, au atati, au bhana, au mighonda kwa ndandi jangu na kwa ndandi ja Malobhi Manyahi, ");
INSERT INTO mpa_vpl VALUES ("MK10_30","071_10_30","MRK","10","30","30","anaajopalyaje mala mia jimu nakanope chikahi cha sajenu. Nyumba, ndongu, ndombu, mabhu, bhana na mighonda papamu na mang'ahiku, na mu ndema ghouhika anaajopalyaje womi wa mileli. ");
INSERT INTO mpa_vpl VALUES ("MK10_31","071_10_31","MRK","10","31","31","Nambu bhamaheli bhabhahobhaleka kubha bhakutumbula sajenu bhibya bhakujomukela, na bhabhabhi bha kujomukela sajenu bhibya bhakutumbula.” ");
INSERT INTO mpa_vpl VALUES ("MK10_32","071_10_32","MRK","10","32","32","Bhela, bhakabhi mwindela kukwela ku Yelusalemu, na Yesu akabhi abhalongulile. Bhabhulwa bhaki bhakabhi na lujoghopo, na bhandu bhabhajengalyaje bhakajowipi. Yesu akabhatohi kabheti punkeghi komi na bhabheli bhala, na kutumbula kubhapwaghila mambu ghaghumpataje. ");
INSERT INTO mpa_vpl VALUES ("MK10_33","071_10_33","MRK","10","33","33","Akabhapwaghile, “Ndingalyaje, tukwela kujenda ku Yelusalemu. Na konihoku Mwana waka Mundu anabhumpelaka mu mabhoku gha bhapenganyambiku bhakolongwa na bhabhola bha Shelia, na bhombi anabhuntemula apotilaje na kubhapeke bhandu bha mataifa ghange. ");
INSERT INTO mpa_vpl VALUES ("MK10_34","071_10_34","MRK","10","34","34","Na bhombi anabhundongamaje, anabhunhunila imata, bhandapula chiboku cha ndomondo na kunkoma. Nambu lichobha la katatu anahyokaje.” ");
INSERT INTO mpa_vpl VALUES ("MK10_35","071_10_35","MRK","10","35","35","Yakobo na Yohana bhana bhaka Zebedayo, bhakunjendi Yesu na kumpwaghila, “Mbola, tupala utuhengila chindu chetakulobhaje.” ");
INSERT INTO mpa_vpl VALUES ("MK10_36","071_10_36","MRK","10","36","36","Yesu akabhalalukile, “Bho, mpala nunhengila kike?” ");
INSERT INTO mpa_vpl VALUES ("MK10_37","071_10_37","MRK","10","37","37","Bhakamuyangike, “Utujetakalyaje kutama jumu upambala wa kumalelelu jaku, na jumu upambala wa kumangeja jaku, mu ulumbalilu waku.” ");
INSERT INTO mpa_vpl VALUES ("MK10_38","071_10_38","MRK","10","38","38","Yesu akabhapwaghile, “Ngachemmanyi lendobha! Bho, muweza kunywele chikombi cha mang'ahiku ngati moning'ahikya nepani, na kubatizwa mu ubatizu ngati ghonibatizwaje?” ");
INSERT INTO mpa_vpl VALUES ("MK10_39","071_10_39","MRK","10","39","39","Bhakamuyangike, “Tuweza.” Yesu akabhapwaghile, “Chakaka mwinywelila mu chikombi cha mang'ahiku chenikunywa nepani, na mwibatizwa ngati monibatizwaje. ");
INSERT INTO mpa_vpl VALUES ("MK10_40","071_10_40","MRK","10","40","40","Kwa bhala bhabhitama kumalelelu au kumangeja jangu nga lihengu langu kupanga. Nambu mbekanyu jeniheji bhipata bhabhabhekakiki na Chapanga.” ");
INSERT INTO mpa_vpl VALUES ("MK10_41","071_10_41","MRK","10","41","41","Bhabhulwa bhangi komi bhala pabhakajowini ghanihagha, bhakatumbwi kubhahakali Yakobo na Yohana. ");
INSERT INTO mpa_vpl VALUES ("MK10_42","071_10_42","MRK","10","42","42","Bhela, Yesu akabhalohiki, na kubhapwaghila, “Bhandu bhabhamanyikana kubha bhatawala bha bhandu bhangakubha Bhayahude bhabhatawala bhandu bhabhu kwa makili, na kabheti bhatawala bhe habha bhabhahengela ngati mobhapalila. ");
INSERT INTO mpa_vpl VALUES ("MK10_43","071_10_43","MRK","10","43","43","Nambu kwinu mabhanganya ngakwikubha bhenibhela, nambu joapala kubha nkolongwa pachilanda jinu, apalika abya ntumika winu. ");
INSERT INTO mpa_vpl VALUES ("MK10_44","071_10_44","MRK","10","44","44","Joapala kubha wa kutumbula, apalika abya mtumika wa bhokape. ");
INSERT INTO mpa_vpl VALUES ("MK10_45","071_10_45","MRK","10","45","45","Ndandi Mwana waka Mundu ngachehiki kutumikiwa, nambu kutumikila, na kuubhoha womi waki nahuli kubhalepela bhandu bhamahele.” ");
INSERT INTO mpa_vpl VALUES ("MK10_46","071_10_46","MRK","10","46","46","Bhela, bhakahiki ku Yeliko, najombi Yesu paapitika mu muchi hoghu akabya na bhabhulwa bhaki papamu na lipogha likolongwa la bhandu. Mundu jumu ngalola joalowakeka Batilomayo, mwana waka Timayo, akabhi atami punkeghi ja indela akajopa bhunjangatyaje. ");
INSERT INTO mpa_vpl VALUES ("MK10_47","071_10_47","MRK","10","47","47","Paakajowini kubha Yesu wa ku Nazaleti akabhili apeta pandu panihapa, akatumbwi kujamalila, “Yesu, Mwana wa Daude, umonila chiha!” ");
INSERT INTO mpa_vpl VALUES ("MK10_48","071_10_48","MRK","10","48","48","Bhandu bhamahele bhakundakalile nahuli atumbalaje, nambu jombi akajonjuki kujamalila, “Mwana waka Daude, umonila chiha!” ");
INSERT INTO mpa_vpl VALUES ("MK10_49","071_10_49","MRK","10","49","49","Yesu akajemiki, na kupwagha, “Mundohaje.” Bhela, bhakundohiki ngalola jola, bhakumpwaghili, “Ulipekya mtima! Jemaje, akuloha.” ");
INSERT INTO mpa_vpl VALUES ("MK10_50","071_10_50","MRK","10","50","50","Na jombi akaleki kutali ingobhu jaki, akahombiki, na kunjende Yesu. ");
INSERT INTO mpa_vpl VALUES ("MK10_51","071_10_51","MRK","10","51","51","Yesu akundalukile, “Bho, upala nukuhengila kike?” Ngalola jola akayangike, “Mbola, nyopa mbata kulola.” ");
INSERT INTO mpa_vpl VALUES ("MK10_52","071_10_52","MRK","10","52","52","Yesu akumpwaghile, “Jendaje, uhobhalelu waku ukulamihe.” Palapala ngalola jola akaweziki kulola, na akunjengali Yesu mwindela. ");
INSERT INTO mpa_vpl VALUES ("MK11_1","071_11_1","MRK","11","1","1","Yesu na bhabhulwa bhaki pabhakaheghali muchi wa Yelusalemu, upambala cha Besifage na Besania, pambipi na Chitombi cha Mizeituni. Yesu akabhatumiki bhabhulwa bhaki bhabhele, ");
INSERT INTO mpa_vpl VALUES ("MK11_2","071_11_2","MRK","11","2","2","akabhapwaghile, “Njendanya ku chijiji chechibhi palongi jinu. Pamwibya njingi monihomu, anamulihimanya liponda likongakiki, liponda heli ngachejendi mundu. Mkabhopula na mkaletaje. ");
INSERT INTO mpa_vpl VALUES ("MK11_3","071_11_3","MRK","11","3","3","Ngati mundu anandalukile, ‘Ndandi kiki mulibhopo liponda heli? Mumpwaghila, Bambo alipala na anakelebhua kabheti pambani esajeno.’ ” ");
INSERT INTO mpa_vpl VALUES ("MK11_4","071_11_4","MRK","11","4","4","Bhela bhakapiti na bhakalihimani liponda lela likongakiki pundyangu wa nyumba punkeghi ja indela. Pabhakabhi bhabhopola, ");
INSERT INTO mpa_vpl VALUES ("MK11_5","071_11_5","MRK","11","5","5","bhandu bhabhakabhi panipala bhakabhalalukile, “Ndandi kiki mbopo liponda heli?” ");
INSERT INTO mpa_vpl VALUES ("MK11_6","071_11_6","MRK","11","6","6","Bhabhulwa bhakayangiki ngati moakapwaghi Yesu, na bhandu bhala bhakajetaki bhajenda nalo. ");
INSERT INTO mpa_vpl VALUES ("MK11_7","071_11_7","MRK","11","7","7","Bhakumpelaki Yesu liponda lela, na kutandika ingobhu yabhu panani ja liponda, na Yesu akatami panani jaki. ");
INSERT INTO mpa_vpl VALUES ("MK11_8","071_11_8","MRK","11","8","8","Bhandu bhamahele bhakatandiki ingobhu yabhu mwindela, na bhangi bhakajaliki matutu ghabhaghahekiti mumighonda. ");
INSERT INTO mpa_vpl VALUES ("MK11_9","071_11_9","MRK","11","9","9","Bhandu bhokapi bhabhalongulili na bhabhajengalyaji bhakatumbwi kujamalila, “Chapanga Alumbalikaje! Apengalika jonihoju joahika kwa lihina laka Bambo! ");
INSERT INTO mpa_vpl VALUES ("MK11_10","071_11_10","MRK","11","10","10","Upengalika ukolongwa ghouhika waka hokolu witu Daude! Ulumbalilu kwaka Chapanga kunani kumahunde!” ");
INSERT INTO mpa_vpl VALUES ("MK11_11","071_11_11","MRK","11","11","11","Yesu akahiki ku Yelusalemu na kujenda palubhanja lwa Nyumba jaka Chapanga, akalingali kila chindu wichu. Nambu ndandi kukabhi pakamihi, akapiti ku Besania papamu na bhabhulwa bhaki komi na bhabhele bhala. ");
INSERT INTO mpa_vpl VALUES ("MK11_12","071_11_12","MRK","11","12","12","Chilabhu jaki, pabhakabhi bhakelabhuka kuhuma ku Besania, Yesu akabhi na injala. ");
INSERT INTO mpa_vpl VALUES ("MK11_13","071_11_13","MRK","11","13","13","Bhela akauweni cha kutali nkongu wa mtini ukabya na mahamba ghamahele. Akauheghali nahuli kulinga ngati aweza kughabhona mapambiku. Nambu paakauheghalili, ngacheaghaweni mapambiku nambu mahamba matopo, ndandi ngachechabhi chikahi cha kupambika mapambiku. ");
INSERT INTO mpa_vpl VALUES ("MK11_14","071_11_14","MRK","11","14","14","Yesu akaupwaghi nkongu wa mtini ghola, “Kutumbu lalenu mbaka mileli nga mundu joanakulaje mapambiku ghaku kabheti!” Na bhabhulwa bhaki bhakajowini malobhi ghanihagha. ");
INSERT INTO mpa_vpl VALUES ("MK11_15","071_11_15","MRK","11","15","15","Bhela pabhahiki ku Yelusalemu, Yesu akapiti ku Nyumba jaka Chapanga na kutumbu kubhatopo bhandu bhabhakabhi bhalombesa na kulomba hindu. Akang'anambwi meza ya bhabhabhi bhang'anambulana mbija na hitehu ya bhabhabhi bhalombesa ngunda, ");
INSERT INTO mpa_vpl VALUES ("MK11_16","071_11_16","MRK","11","16","16","na ngacheandekiki mundu jokapi kupeta na chindu chokapi chela palubhanja lwa Nyumba jaka Chapanga. ");
INSERT INTO mpa_vpl VALUES ("MK11_17","071_11_17","MRK","11","17","17","Bhela akabhabholiki bhandu, “Bho, ngacheyalembakiki mu Malembu Mahuhu, ‘Nyumba jangu anajibya Nyumba ja malobhu kwa mataifa ghokapi?’ Nambu mabhanganya mjitehi kubha likolu la bhihe!” ");
INSERT INTO mpa_vpl VALUES ("MK11_18","071_11_18","MRK","11","18","18","Bhapenganyambiku bhakolongwa na bhabhola bha Shelia pabhakajowini malobhi ghanihagha, bhakatumbwi kulonda indela ja kunkoma Yesu. Nambu bhakunjowipi, ndandi lipogha lokapi la bhandu lakakangichi mabholu ghaki. ");
INSERT INTO mpa_vpl VALUES ("MK11_19","071_11_19","MRK","11","19","19","Chimihi pachahikaje, Yesu na bhabhulwa bhaki bhakabhokiki pamuchi ghonighola. ");
INSERT INTO mpa_vpl VALUES ("MK11_20","071_11_20","MRK","11","20","20","Chilabhu jaki palukela, pabhapetika mwindela, bhakauweni nkongu wa mtini ghola ujomiki kaghajo wokapi kutumbu kumikegha mbaka kunani. ");
INSERT INTO mpa_vpl VALUES ("MK11_21","071_11_21","MRK","11","21","21","Petulu akakombwiki chechatendakiki na akumpwaghi Yesu, “Mbola, lingalyaje! Nkongu wa mtini ghoupeki masolu ghola ujomike!” ");
INSERT INTO mpa_vpl VALUES ("MK11_22","071_11_22","MRK","11","22","22","Yesu akabhapwaghile, “Munhobhalya Chapanga. ");
INSERT INTO mpa_vpl VALUES ("MK11_23","071_11_23","MRK","11","23","23","Numpwaghi chakaka, mundu anaachipwaghi chitombi chenje, ‘Jighukaje na ukalilekala mubahali,’ panga kubhona choghohi muntima waki, nambu anahobhale malobhi ghokapi ghalonge anaghahengakikaje, chakaka analihengakika kwake. ");
INSERT INTO mpa_vpl VALUES ("MK11_24","071_11_24","MRK","11","24","24","Bhela numpwaghila, pansalila na kulobha chindu, muhobhalya kubha njopalile, nanamu anampataje. ");
INSERT INTO mpa_vpl VALUES ("MK11_25","071_11_25","MRK","11","25","25","Panjema na kundobha Chapanga, mundekakya kila mundu joanhoki chokapi, nahuli Atati winu joabhi kunani kumahunde andekakya na mwenga mahoku ghinu. ");
INSERT INTO mpa_vpl VALUES ("MK11_26","071_11_26","MRK","11","26","26","Nambu nangakubhalekake bhajinu, hata Atati winu joabhi kunani kumahunde ngaandekakeli mwanganya mahoku ghinu.” ");
INSERT INTO mpa_vpl VALUES ("MK11_27","071_11_27","MRK","11","27","27","Bhela bhakahiki kabheti ku Yelusalemu. Yesu paakabhi ajenda pa liwangala la Nyumba jaka Chapanga, bhapenganyambiku bhakolongwa, bhabhola bha Shelia na bhazee bhakunjendili, ");
INSERT INTO mpa_vpl VALUES ("MK11_28","071_11_28","MRK","11","28","28","na bhakundalukile, “Bho, uhenga mambu ghangane kwa lujiniku lwaka nane? Bho, nde nane joakupeki wehapa lujiniku lwa kuhenga mambu ghangane?” ");
INSERT INTO mpa_vpl VALUES ("MK11_29","071_11_29","MRK","11","29","29","Nambu Yesu akabhayangike, “Ananundalukya lilaluki limu. Anamniyangiki, nanatu ananumpwaghila kubha nhenga mambu ghangani kwa lujiniku lwaka nane. ");
INSERT INTO mpa_vpl VALUES ("MK11_30","071_11_30","MRK","11","30","30","Mbwaghilaje, bho, lujiniku lwaka Yohana Mbatizaji lukahumiki kunani kwaka Chapanga au kwa bhandu? Mniyangaje.” ");
INSERT INTO mpa_vpl VALUES ("MK11_31","071_11_31","MRK","11","31","31","Bhakatumbwi kulongalanela, “Anatupwaghiki, ‘Ghakahumiki kwaka Chapanga,’ anaatulalukya, ‘Bho, mbona ngachemunhobhali Yohana?’ ");
INSERT INTO mpa_vpl VALUES ("MK11_32","071_11_32","MRK","11","32","32","Kabheti anatupwaghiki, ‘Ghakahumiki kwa bhandu,’ kwibya bhole?” Bhakajowipi lipogha la bhandu, maghambu bhandu bhokapi bhakahobhali kubha Yohana akabhi chakaka mlota waka Chapanga. ");
INSERT INTO mpa_vpl VALUES ("MK11_33","071_11_33","MRK","11","33","33","Bhela bhakamuyangiki Yesu, “Tepani ngachetumanye.” Na jombi Yesu akabhapwaghile, “Na nepani nganumpwaghi nhenga mambu ghangani kwa lujiniku bhole.” ");
INSERT INTO mpa_vpl VALUES ("MK12_1","071_12_1","MRK","12","1","1","Yesu akatumbwi kulonge nabhu kwa malenganesu akapwaghaje, “Mundu jumu akalemiki ngonda wa mizabibu, akauyongalwi lumatu, na pachilanda jaki akalenganaki libhomba la kuminyi divai, na kuchenga mnala. Akabhajahiki bhalemi ngonda ghola, na akatumbwi mwanja wa kujenda ku inchi ja kutali. ");
INSERT INTO mpa_vpl VALUES ("MK12_2","071_12_2","MRK","12","2","2","Chikahi cha kuhuna mapambiku pachahikiki, akuntumiki ntumika waki kwa bhalemi bhala nahuli akundetila pandu pa mapambiku gha ngonda waki wa mizabibu. ");
INSERT INTO mpa_vpl VALUES ("MK12_3","071_12_3","MRK","12","3","3","Bhalemi bhala bhakunkamwi ntumika jola, bhakundapwili, na kunkelebhu mabhoku matopu. ");
INSERT INTO mpa_vpl VALUES ("MK12_4","071_12_4","MRK","12","4","4","Akuntumiki kabheti ntumika jongi. Jonihoju kabheti bhakundapwi kumutu na kumpoa lihamo. ");
INSERT INTO mpa_vpl VALUES ("MK12_5","071_12_5","MRK","12","5","5","Mweni ngonda jola akuntumiki kabheti ntumika jongi. Na bhombi bhalemi bhala bhakunkomiki. Bhakalapuliki kabheti bhangi bhamahele bhabhakatumakiki na bhangi kubhakoma. ");
INSERT INTO mpa_vpl VALUES ("MK12_6","071_12_6","MRK","12","6","6","Bhela akahighali na mundu jumu, yani mwana waki mpalu. Pakujomukela akuntumiki jonihoju akapwaghaje, ‘Anabhuntopilaje mwana wango.’ ");
INSERT INTO mpa_vpl VALUES ("MK12_7","071_12_7","MRK","12","7","7","Nambu bhalemi bhala bhakapwaghanile, ‘Jonjo nde mpwelelu, bhela tunkomaje, nahuli upwelelu waki ubya wito!’ ");
INSERT INTO mpa_vpl VALUES ("MK12_8","071_12_8","MRK","12","8","8","Bhela bhakunkamwili na kunkoma, na kujenda kujileke hyegha jaki kunja ja ngonda wa mizabibu ghola.” ");
INSERT INTO mpa_vpl VALUES ("MK12_9","071_12_9","MRK","12","9","9","Yesu akabhalalukile, “Bho, mweni ngonda wa mizabibu anahenga kike?” “Anahikaje kubhakoma bhalemi habha, na kubhajahika ngonda hoghu bhandu bhangi. ");
INSERT INTO mpa_vpl VALUES ("MK12_10","071_12_10","MRK","12","10","10","Bho, ngachensomiki Malembu aghagha? ‘Liganga lebhalikaniki bhachenga, sajenu libhi liganga likolongwa la punkeghi. ");
INSERT INTO mpa_vpl VALUES ("MK12_11","071_12_11","MRK","12","11","11","Bambo nde joatehi lijambu lenihele, nalombi nde la kukangacha kwitu!’ ” ");
INSERT INTO mpa_vpl VALUES ("MK12_12","071_12_12","MRK","12","12","12","Bhapenganyambiku bhakolongwa, bhabhola bha Shelia na akahokolu bhakamanyiki kubha ulenganesu hoghu ubhapwagha bhombe. Bhela bhakalengiki kunkamu Yesu, nambu bhakajowipi lipogha la bhandu. Panihapa bhakundehili na bhakabhokike. ");
INSERT INTO mpa_vpl VALUES ("MK12_13","071_12_13","MRK","12","13","13","Bhela Mafalisayo bhangi na bhahemba bha lipogha laka Helode, bhakatumakiki kwaka Yesu nahuli bhajenda bhakundalukyaje kwa kundenga. ");
INSERT INTO mpa_vpl VALUES ("MK12_14","071_12_14","MRK","12","14","14","Bhakunjendili na kumpwaghila, “Mbola, tumanyi kubha wehapa ulonge chakaka, panga kujoghopa maholalelu gha bhandu. Wala ngacheulingali sula jaka mundu, nambu ubhola chakaka kubhokana na indela jaka Chapanga. Tupwaghilaje, bho, wichu le kwitu tepani kulepa kodi kwaka Kaisali? ");
INSERT INTO mpa_vpl VALUES ("MK12_15","071_12_15","MRK","12","15","15","Bho, tulepaji au ngatwilepa?” Nambu Yesu akamanyiki icholi yabhu, akabahpwaghile, “Bho, mbona ntenda kunenga? Nnetila mbija heje.” ");
INSERT INTO mpa_vpl VALUES ("MK12_16","071_12_16","MRK","12","16","16","Bhakundeti mbija, najombi akabhalalukile, “Bho, sula na lihina lendenu yaka nane?” Bhakamuyangiki, “Yaka Kaisali.” ");
INSERT INTO mpa_vpl VALUES ("MK12_17","071_12_17","MRK","12","17","17","Yesu akabhapwaghile, “Mumpekya Kaisali yeibhi yaki Kaisali, na yeibhi yaka Chapanga mumpekya Chapanga.” Panihapa bhakunkangichi namaa Yesu. ");
INSERT INTO mpa_vpl VALUES ("MK12_18","071_12_18","MRK","12","18","18","Bhela, Masadukayo bhabhapwagha kubha ngachekubhi kuhyoka bhakunjendi Yesu, na kundalukila, ");
INSERT INTO mpa_vpl VALUES ("MK12_19","071_12_19","MRK","12","19","19","“Mbola, Musa akatulaghalakili, ‘Ngati mwanalomi anapotili na kundeka nhwanu waki panga mwana, ndongu waki apalika antola mbomba joaweliwi na ndomi jola nahuli ambelakya bhana ndongu waki joapoti jola.’ ");
INSERT INTO mpa_vpl VALUES ("MK12_20","071_12_20","MRK","12","20","20","Kwa ulenganesu, kukabhi na bhalongu saba, wa kutumbula akatowili na kupotela panga kupata bhana. ");
INSERT INTO mpa_vpl VALUES ("MK12_21","071_12_21","MRK","12","21","21","Ndongu wa kabheli akuntowili joaweliwi na ndomi jola, najombi akapotili panga kupata bhana, na ndongu wa katatu najombi bhelabhela, ");
INSERT INTO mpa_vpl VALUES ("MK12_22","071_12_22","MRK","12","22","22","na bhalongu bhokapi saba bhabhuntowili mbomba jola bhakapotili panga kubhaleka bhana. Machobha paghapetiki, najombi mbomba jola akapotile. ");
INSERT INTO mpa_vpl VALUES ("MK12_23","071_12_23","MRK","12","23","23","Bhela, lichobha la kuhyoka bhandu, bho, mabhu hoju ayibya nhwanu waka nane? Maghambu akanalomi bhokapi saba bhakuntowile.” ");
INSERT INTO mpa_vpl VALUES ("MK12_24","071_12_24","MRK","12","24","24","Yesu akabhayangike, “Bho, mwanganya ngachemuhokiye, maghambu ngachemughamanyi Malembu Mahuhu na uweza waka Chapanga? ");
INSERT INTO mpa_vpl VALUES ("MK12_25","071_12_25","MRK","12","25","25","Kwa ndandi bhabhawili pabhiyokaje ngabhitoghuleki, bhibya ngati bhatumika bha kunani kwaka Chapanga. ");
INSERT INTO mpa_vpl VALUES ("MK12_26","071_12_26","MRK","12","26","26","Bhela, kuhyoka kwa bhabhawili, bho, ngachensomiki mu Chitabu chaka Musa pandu papalongale chitutu chechibhelala moto? Chapanga akumpwaghi Musa, ‘Nepani Chapanga waka Ibulahimu, Chapanga waka Isaka na Chapanga waka Yakobo.’ ");
INSERT INTO mpa_vpl VALUES ("MK12_27","071_12_27","MRK","12","27","27","Bhela jombi nde Chapanga wa bhandu bhabhabhi bhomi, nambu nga wa bhandu bhabhawile. Mwanganya muhobhiki namaa!” ");
INSERT INTO mpa_vpl VALUES ("MK12_28","071_12_28","MRK","12","28","28","Mbola jumu wa Shelia akahikiki na kujowane kulochana kwabho. Paakaweni kubha Yesu akabhayangiki Masadukayo wichu, akunjendi Yesu na kundalukila, “Bho, mu amuli yokapi, nde jaleko jejibhi ngolongwa kupeta yokape?” ");
INSERT INTO mpa_vpl VALUES ("MK12_29","071_12_29","MRK","12","29","29","Yesu akamuyangike, “Amuli nkolongwa nde jenjenu, ‘Njowanyaje, mabhandu bha Izilaeli! Bambo Chapanga witu nde Bambo jumu. ");
INSERT INTO mpa_vpl VALUES ("MK12_30","071_12_30","MRK","12","30","30","Umpalaje Bambo Chapanga waku kwa mtima waku wokapi, kwa roho jaku jokapi, kwa malangu ghaku ghokapi na kwa makili ghaku ghokapi.’ ");
INSERT INTO mpa_vpl VALUES ("MK12_31","071_12_31","MRK","12","31","31","Amuli ngolongwa ja kabheli nde jenjenu, ‘Umpalaje njaku ngati moulipali wamwete.’ Nga amuli jengi ngolongwa ja kuipeta ibheli heye.” ");
INSERT INTO mpa_vpl VALUES ("MK12_32","071_12_32","MRK","12","32","32","Mbola wa Shelia jola akumpwaghi Yesu, “Mbola ulongi wichu! Ulongi chakaka kubha, Chapanga nde jumu pela, wala njeta jongi nambu jombi. ");
INSERT INTO mpa_vpl VALUES ("MK12_33","071_12_33","MRK","12","33","33","Impalika mundu kumpala Chapanga kwa mtima wokapi, kwa malangu ghokapi, kwa makili ghokapi na kumpala njaki ngati moalipali mwene, kupalika nakanopi kuliku kubhoha hinyama ya kujochakeka na nyambiku yokapi.” ");
INSERT INTO mpa_vpl VALUES ("MK12_34","071_12_34","MRK","12","34","34","Yesu paakaweni kubha mundu hoju akayangiki kwa malangu, akumpwaghile, “Wehapa ngacheubhi kutali na Ukolongwa waka Chapanga.” Kutumbu panihapa nga mundu joakajendali kabheti kundaluki Yesu lilalukilo. ");
INSERT INTO mpa_vpl VALUES ("MK12_35","071_12_35","MRK","12","35","35","Chikahi Yesu paakabhi abhola mu Nyumba jaka Chapanga, akalalukile, “Bho, mbona bhabhola bha Shelia bhapwagha kubha Kristo nde mwana Daude? ");
INSERT INTO mpa_vpl VALUES ("MK12_36","071_12_36","MRK","12","36","36","Roho Mhuhu akundongwi Daude kupwagha, ‘Bambo akumpwaghi Bambo wango, Utamaje upambala wangu wa kumalelelu, mbaka panabhabhekaje maadui bhaku pahi ja magholu ghaku.’ ");
INSERT INTO mpa_vpl VALUES ("MK12_37","071_12_37","MRK","12","37","37","Daude mweni andoha Kristo ‘Bambo,’ henu Kristo ayibya bho mwana waka Daude?” Lipogha la bhandu lakabhi lunjowane Yesu kwa chiheku. ");
INSERT INTO mpa_vpl VALUES ("MK12_38","071_12_38","MRK","12","38","38","Mu mabholu ghaki, Yesu akapwaghike, “Mulilingalyaje na bhabhola bha Shelia, bhabhapala kupetapeta bhawati ingobhu ilachu na bhandu kubhalamuki kwa kutopela paligulio. ");
INSERT INTO mpa_vpl VALUES ("MK12_39","071_12_39","MRK","12","39","39","Kabheti bhahaghu itehu ya kulongolu munyumba ja kuhimangani Bhayahude na pandu pa kutopela pa uwangalalu wa chilebhe. ");
INSERT INTO mpa_vpl VALUES ("MK12_40","071_12_40","MRK","12","40","40","Kwa kubhakolowa bhabhatole bhabhaweliwi na bhalomi bhabhu nyumba yabhu na hindu yabhu koni bhakoponganela kulobha malobhu malachu! Bhanihabha utemuliku wabhu anaukubhaje ukolongwa namaa!” ");
INSERT INTO mpa_vpl VALUES ("MK12_41","071_12_41","MRK","12","41","41","Yesu akabhi atami pambipi na lisanduku la chikoku cha mbija, akabhalingali bhandu bhamaheli mobhajeghale mbija yabho. Bhanahindu bhamaheli bhabhohiki mbija yamahele, ");
INSERT INTO mpa_vpl VALUES ("MK12_42","071_12_42","MRK","12","42","42","panihapa akahikiki mabhu jumu kahochu, akajeghi sendi ibheli ya mbija. ");
INSERT INTO mpa_vpl VALUES ("MK12_43","071_12_43","MRK","12","43","43","Yesu akabhalohiki bhabhulwa bhaki papamu na kubhapwaghila, “Chakaka numpwaghila, mabhu ajoju kahochu ajeghi mu lisanduku la chikoku mbija yamaheli kupeta chebhajeghi bhandu bhangi bhokape. ");
INSERT INTO mpa_vpl VALUES ("MK12_44","071_12_44","MRK","12","44","44","Ndandi bhangi bhokape bhakabhohiki kubhokana na kujoloka kwa hindu yabhu, nambu mabhu ajoju, koni abhi kahochu, abhohiki yokapi yeakabhi naku, abhohiki hindu yokapi yeyunjangatyaje kwa matamu ghaki.” ");
INSERT INTO mpa_vpl VALUES ("MK13_1","071_13_1","MRK","13","1","1","Yesu paakabhi apita mu Nyumba jaka Chapanga, jumu wa bhabhulwa bhaki akumpwaghile, “Mbola, lingalyaje ntundu maganga aghagha na machengu aghagha moghabheli gha kukangacha!” ");
INSERT INTO mpa_vpl VALUES ("MK13_2","071_13_2","MRK","13","2","2","Yesu akumpwaghile, “Bho, mughabhona machengu aghagha moghakolile? Njeta hata liganga limu lelihighalya panani ja lenge, kila chindu anachihabhukaje.” ");
INSERT INTO mpa_vpl VALUES ("MK13_3","071_13_3","MRK","13","3","3","Yesu paakabhi atemi panani ja Chitombi cha Mizeituni akalingali upambala wa Nyumba jaka Chapanga, Petulu, Yakobo, Yohana na Andulea bhakundaluki pakanjika jabho, ");
INSERT INTO mpa_vpl VALUES ("MK13_4","071_13_4","MRK","13","4","4","“Tupwaghilaje, bho, mambu ghanihagha ghibya lile? Bho, nginyuli bholi yeilangiaje kubha mambu ghanihagha ghaheghali kupitalila?” ");
INSERT INTO mpa_vpl VALUES ("MK13_5","071_13_5","MRK","13","5","5","Yesu akatumbwi kubhapwaghila, “Mlilingalyaje mundu ngaankolowa. ");
INSERT INTO mpa_vpl VALUES ("MK13_6","071_13_6","MRK","13","6","6","Maghambu bhandu bhamaheli anabhahikaje kwa lihina langu, kila jumu wabhu anaapwaghaje, ‘Nepani nde jombi!’ Na bhombi anabhakoluwaje bhandu bhamahele. ");
INSERT INTO mpa_vpl VALUES ("MK13_7","071_13_7","MRK","13","7","7","Pamwijowana panani ja ngondo na majojalanelu gha ngondo, ngamwijoghopa. Mambu ghanihagha anaghatumbula kupitalila, nambu ujomukelu weni wibya wakali. ");
INSERT INTO mpa_vpl VALUES ("MK13_8","071_13_8","MRK","13","8","8","Likabila limu analikomana na likabila lenge, ukolongwa ghumu anaukomana na ukolongwa ghonge. Pandu patalipatali anakukubhaje na minyukunyuku ja luhombi na injala. Mambu ghanihagha nde ngati mabhinilu gha kutumbula gha kulibhopo mwana. ");
INSERT INTO mpa_vpl VALUES ("MK13_9","071_13_9","MRK","13","9","9","“Nambu mwenga mulilingalyaje. Maghambu bhandu anabhumpelaka pachengu, na kundapu iboku mu nyumba ya kuhimangani Bhayahude. Anabhumpelaka palongi ja bhatawala na bhakolongwa kwa ndandi jangu, nahuli kubha ulandilu kwabho. ");
INSERT INTO mpa_vpl VALUES ("MK13_10","071_13_10","MRK","13","10","10","Nambu anaghatumbula hoti Malobhi Manyahi kutangazwa kwa bhandu bha mataifa ghokapi. ");
INSERT INTO mpa_vpl VALUES ("MK13_11","071_13_11","MRK","13","11","11","Na bhombi pabhunkamulaje na kumpeleka pachengu, ngamwihola panani ja malobhi ghamwilongilaje. Pachihikaje chikahi chenihechi, ndongila chokapi chemwipekiwaje. Ndandi nga mwanganya mwemwilongilaje, nambu Roho Mhuhu. ");
INSERT INTO mpa_vpl VALUES ("MK13_12","071_13_12","MRK","13","12","12","Mbeli anaang'anambuka nnung'una waki akomakikaje, na tati anahenga bhelabhela kwa bhana bhaki, na bhana anabhang'anambukaje kubhalapula bhabheleka bhabhu na kubhakoma. ");
INSERT INTO mpa_vpl VALUES ("MK13_13","071_13_13","MRK","13","13","13","Bhandu bhamaheli anabhunhakalya mwenga kwa ndandi ja lihina langu. Nambu joanahinakyaje mbaka pakujomukela nde joanakengaliwaje. ");
INSERT INTO mpa_vpl VALUES ("MK13_14","071_13_14","MRK","13","14","14","“Pamwibhona, ‘Lihakalilu la Uyonangeku,’ ngati molalembakike na mlota Danieli, lijemiki pandu nga paki.” Joasoma na amanya ndandi jake. “Panihapa, bhabhabhi ku Yudea bhatililaje kwitombi. ");
INSERT INTO mpa_vpl VALUES ("MK13_15","071_13_15","MRK","13","15","15","Mundu jokapi jola joabhi panani ja nhwaghala wa nyumba jaki ngayihuluka, na kujingila mkati ja nyumba jaki na kutola chindu! ");
INSERT INTO mpa_vpl VALUES ("MK13_16","071_13_16","MRK","13","16","16","Bhelabhela joabhi kungonda ngaikelabhuka kunyumba jaki na kutola ingobhu jaki. ");
INSERT INTO mpa_vpl VALUES ("MK13_17","071_13_17","MRK","13","17","17","Anabhachibhona akamabhu bhabhikubhaje na hitumbu, na bhabhajongeha mu machobha ghanihagha! ");
INSERT INTO mpa_vpl VALUES ("MK13_18","071_13_18","MRK","13","18","18","Ndobhaje nahuli mambu ghanihagha ngaghipitalila chikahi cha imbepu. ");
INSERT INTO mpa_vpl VALUES ("MK13_19","071_13_19","MRK","13","19","19","Ndandi chikahi hechi anakubya na kulagha kwanga kubhonikana kutumbu Chapanga paakabhombiki ndema mbaka lalenu, na wala ngaghipitali kabheti. ");
INSERT INTO mpa_vpl VALUES ("MK13_20","071_13_20","MRK","13","20","20","Ngati Bambo ngaakakepishi machobha ghanihagha nga mundu joakakengaliwaje. Nambu kwa ndandi ja bhandu bhaki bhahaghulika, Bambo akepishi machobha ghanihagha. ");
INSERT INTO mpa_vpl VALUES ("MK13_21","071_13_21","MRK","13","21","21","“Henu mundu anampwaghi, ‘Lingalyaje, Kristo abhi apa,’ au ‘Abhi pala,’ ngamwihobhalela. ");
INSERT INTO mpa_vpl VALUES ("MK13_22","071_13_22","MRK","13","22","22","Kwa ndandi anabhapitalyaje maklisto bha upuhe na bhalota bha upuhe, anabhatenda nginyulila na mambu gha kukangacha, nahuli kubhakolowa, ngati anaiwezakini, hata bhahaghulika bhaka Chapanga. ");
INSERT INTO mpa_vpl VALUES ("MK13_23","071_13_23","MRK","13","23","23","Nambu mwenga mulilingalyaje! Nepani numpwaghi mambu ghanihagha ghokapi koni ghakona ngakupitalila. ");
INSERT INTO mpa_vpl VALUES ("MK13_24","071_13_24","MRK","13","24","24","“Bhela paghipetaje machobha ghanihagha gha kulagha, lyobha analiyeghalika lwihi na mwehi ngawinang'ane. ");
INSERT INTO mpa_vpl VALUES ("MK13_25","071_13_25","MRK","13","25","25","Ndondwa anaihabhukaje kuhuma kunani kumahunde, na hindu yokapi ya kunani anainyuhakikaje. ");
INSERT INTO mpa_vpl VALUES ("MK13_26","071_13_26","MRK","13","26","26","Panihapa mwimona nepani, Mwana waka Mundu, nhika mu mahundi kwa makili makolongwa na ulumbalilu. ");
INSERT INTO mpa_vpl VALUES ("MK13_27","071_13_27","MRK","13","27","27","Kabheti ananabhalaghalakya bhatumika bhangu bha kunani kumahunde bhabhonganaje bhahaghulika bhaka Chapanga kuhuma ipambala yokapi nchechi ya ndema. Hata kuhuma kutali nakanopi ja pundema. ");
INSERT INTO mpa_vpl VALUES ("MK13_28","071_13_28","MRK","13","28","28","“Kwa nkongu wa mtini mulibhola libholu lendenu. Chikahi mambandi ghaki paghatumbu kutunduli mahamba na kuneng'anela, mmanya chikahi cha mahunu chiheghalile. ");
INSERT INTO mpa_vpl VALUES ("MK13_29","071_13_29","MRK","13","29","29","Bhelabhela, na mwenga pamughabhona mambu ghanihagha ghahengakeka, mmanyaje kubha Mwana waka Mundu abhi pambipi kuhika. ");
INSERT INTO mpa_vpl VALUES ("MK13_30","071_13_30","MRK","13","30","30","Numpwaghi chakaka, chibheleku chenjenu ngachipeti, mbaka mambu ghanihagha ghokapi ghapitalile. ");
INSERT INTO mpa_vpl VALUES ("MK13_31","071_13_31","MRK","13","31","31","Kunani na pundema anaipetaje, nambu malobhi ghangu ngaghipeti ng'o. ");
INSERT INTO mpa_vpl VALUES ("MK13_32","071_13_32","MRK","13","32","32","“Nambu panani ja lichobha la kujomukela, na lisaa lela, nga mundu joamanyi analihika lile, wala bhatumika bha kunani kwaka Chapanga, wala Mwana. Nambu Atati kanjika jaki nde joamanya. ");
INSERT INTO mpa_vpl VALUES ("MK13_33","071_13_33","MRK","13","33","33","Muliandiaje na mkubhaje mihu, ndandi ngachemmanyi chikahi hechi anachihika lile. ");
INSERT INTO mpa_vpl VALUES ("MK13_34","071_13_34","MRK","13","34","34","Kwibya ngati mundu joabhoka panyumba kutumbu mwanja akabhalekila bhatumika bhaki kujilingalila, kila mundu na lihengu laki na kumpwaghi mlonda wa ndyangu akubha mihu. ");
INSERT INTO mpa_vpl VALUES ("MK13_35","071_13_35","MRK","13","35","35","Mkubhaje mihu, ndandi ngachemmanyi mweni nyumba anahika lile. Pangi kwibya pakamihi, au ikilu pamahiku, au pachibhombu au palukela. ");
INSERT INTO mpa_vpl VALUES ("MK13_36","071_13_36","MRK","13","36","36","Muliandiaje, nahuli anahiki kwa kupwitukila, ngaanhimani ngochile. ");
INSERT INTO mpa_vpl VALUES ("MK13_37","071_13_37","MRK","13","37","37","Malobhi ghanumpwaghi mabhanganya, numpwaghi mabhokapi. Mkubhaje mihu!” ");
INSERT INTO mpa_vpl VALUES ("MK14_1","071_14_1","MRK","14","1","1","Ghakahighali machobha ghabheli kuhika lichobha la Kiyahude la kula Pasaka na lichobha la kula Mikati Jangakujegaleka Amila. Bhapenganyambiku bhakolongwa na bhabhola bha Shelia bhakabhili bhalonda indela ja kunkamu Yesu kwa kulihiya nahuli bhunkomaje. ");
INSERT INTO mpa_vpl VALUES ("MK14_2","071_14_2","MRK","14","2","2","Nambu bhakapwaghike, “Ngatwihenga bhenibhela chikahi cha kula uwangalalu, nahuli bhandu ngabhileta fujo.” ");
INSERT INTO mpa_vpl VALUES ("MK14_3","071_14_3","MRK","14","3","3","Yesu akabhi ku Besania kunyumba jaka Simoni, Yesu joandamihi chitamu cha malohi. Yesu paakabhi akula chilebhe, akahiki mbomba jumu joakabhi na libotolu lelalenganakiki kwa liganga la alabasta la mbija yamaheli na mkati jaki kukabhi na mahuta gha kunungi wichu ghaghalowakeka nalido na gha mbija yamaheli. Akalibhopwi libotolu lela na kunjeghale Yesu mahuta ghala kumutu. ");
INSERT INTO mpa_vpl VALUES ("MK14_4","071_14_4","MRK","14","4","4","Bhandu bhangi bhabhakabhi panipala bhakayomiki na kupwaghanila, “Bho, maghambu kiki kughahowa mahuta aghagha? ");
INSERT INTO mpa_vpl VALUES ("MK14_5","071_14_5","MRK","14","5","5","Ndandi mahuta hagha tukabya tulombisi kwa mbija yamahele, na kubhapeke bhahocho!” Na bhakunkenjuki namaa mabhu jola. ");
INSERT INTO mpa_vpl VALUES ("MK14_6","071_14_6","MRK","14","6","6","Nambu Yesu akabhapwaghile, “Mundekaje! Bho, maghambu kiki mung'aha? Anhengi lihengu lambone. ");
INSERT INTO mpa_vpl VALUES ("MK14_7","071_14_7","MRK","14","7","7","Bhahochu mbi nabhu machobha ghokape, na chikahi chokapi chempala muweza kubhajangatila. Nambu nepani ngangubhi na mwanganya machobha ghokape. ");
INSERT INTO mpa_vpl VALUES ("MK14_8","071_14_8","MRK","14","8","8","Jombi ahengiki ngati moawezile. Anyeghali hyegha jangu mahuta gha kunungila nahuli kunhandaa kwa ndandi ja kutaghakika kwangu. ");
INSERT INTO mpa_vpl VALUES ("MK14_9","071_14_9","MRK","14","9","9","Numpwaghi chakaka, pundema pokapi Malobhi Manyahi paghitangazwaje, bhandu anabhakombukaje na kuliloghola lihina laka mabhu hoju kwa ndandi ja kunkomboka jombi.” ");
INSERT INTO mpa_vpl VALUES ("MK14_10","071_14_10","MRK","14","10","10","Bhela Yuda Isikalioti, jumu wa bhabhulwa komi na bhabheli, akapiti kwa bhapenganyambiku bhakolongwa nahuli kung'anambuka Yesu. ");
INSERT INTO mpa_vpl VALUES ("MK14_11","071_14_11","MRK","14","11","11","Bhapenganyambiku bhakolongwa pabhajowini malobhi ghanihagha bhakahekalile, bhakumpwaghi anabhumpekya mbija. Bhela Yuda akatumbwi kulonda mbekenyu ja kung'anambuka Yesu. ");
INSERT INTO mpa_vpl VALUES ("MK14_12","071_14_12","MRK","14","12","12","Lichobha la kutumbula la Kula Mabumunda Ghangakujeghaleka Amila, chikahi cha kuchinjakika mwanambelele wa Pasaka, bhabhulwa bhaki bhakundaluki Yesu, “Bho, upala tujenda tukakuhandalya kwaku nahuli ukulaje chilebhi cha Pasaka?” ");
INSERT INTO mpa_vpl VALUES ("MK14_13","071_14_13","MRK","14","13","13","Panihapa Yesu akabhatumiki bhabhulwa bhaki bhabheli na kubhapwaghila, “Njendanya kumbwane, na konihoku mwakahimangana na mwanalomi jumu joatotwi chihulu cha machi. Mukunjengalyaje, ");
INSERT INTO mpa_vpl VALUES ("MK14_14","071_14_14","MRK","14","14","14","mbaka mu nyumba jeakajingalaje, na mukumpwaghila mweni nyumba, ‘Mbola apwagha, chibhi kwaku chumba changu monikula chilebhi cha Pasaka papamu na bhabhulwa bhango?’ ");
INSERT INTO mpa_vpl VALUES ("MK14_15","071_14_15","MRK","14","15","15","Na jombi anaandangia chumba chikolongwa cha kugholofa chechiandaliwi na kuchipamba. Mkatuandalya monihomo.” ");
INSERT INTO mpa_vpl VALUES ("MK14_16","071_14_16","MRK","14","16","16","Bhabhulwa bhakabhokiki, bhakapiti kumbwane, na bhakahimani kila chindu chibhi wichu ngati Yesu moakapwaghile, na bhakaandi chilebhi cha Pasaka. ");
INSERT INTO mpa_vpl VALUES ("MK14_17","071_14_17","MRK","14","17","17","Pakwahiki pakamihi, Yesu akahikiki panihapa papamu na bhabhulwa bhaki komi na bhabheli. ");
INSERT INTO mpa_vpl VALUES ("MK14_18","071_14_18","MRK","14","18","18","Pabhakabhi papamu bhatami kwa kula chilebhe, Yesu akapwaghike, “Chakaka numpwaghila, jumu winu joakula papamu na nepani, anaang'anambukaje.” ");
INSERT INTO mpa_vpl VALUES ("MK14_19","071_14_19","MRK","14","19","19","Bhabhulwa bhaki bhakatumbwi kuhyoma na kundaluki jumu jumu, “Bho, nepani lelo?” ");
INSERT INTO mpa_vpl VALUES ("MK14_20","071_14_20","MRK","14","20","20","Yesu akabhayangike, “Jumu winu komi na bhabheli mwenga, joatobhale libumunda mu chikombi chimu na nepani. ");
INSERT INTO mpa_vpl VALUES ("MK14_21","071_14_21","MRK","14","21","21","Chakaka Mwana waka Mundu anaapotilaje ngati moilembakike mu Malembu Mahuhu panani jake, nambu anaachibhona mundu jola joang'anambuka Mwana waka Mundu! Ikabya mbanga kwaka mundu hoju akabya akotwiki kubhelakeka!” ");
INSERT INTO mpa_vpl VALUES ("MK14_22","071_14_22","MRK","14","22","22","Pabhakabhi bhakula, Yesu akatoliki libumunda, akalipengalili, akalihekiki na kubhapekeha bhabhulwa bhaki, akapwaghaje, “Ntolanya nkulaje, jenjenu nde hyegha jango.” ");
INSERT INTO mpa_vpl VALUES ("MK14_23","071_14_23","MRK","14","23","23","Kabheti akatoliki chikombi cha divai, akanchengwi Chapanga, na kubhapekeha bhabhulwa bhaki, bhokapi bhakakunywiki divai kuhuma mu chikombi chela. ");
INSERT INTO mpa_vpl VALUES ("MK14_24","071_14_24","MRK","14","24","24","Yesu akabhapwaghile, “Ghongoni nde mwahi wango wa Lulaghilu lwaka Chapanga, ghoujitika kwa ndandi ja kubhalekakela mahoku gha bhandu bhamahele. ");
INSERT INTO mpa_vpl VALUES ("MK14_25","071_14_25","MRK","14","25","25","Chakaka numpwaghila, ngangunywi kabheti divai mbaka lichobha lela panikunywaje divai jahenu mu Ukolongwa waka Chapanga.” ");
INSERT INTO mpa_vpl VALUES ("MK14_26","071_14_26","MRK","14","26","26","Panihapa bhakajembiki nyembu ya kunchengu Chapanga, na bhakabhokiki kujenda ku Chitombi cha Mizeituni. ");
INSERT INTO mpa_vpl VALUES ("MK14_27","071_14_27","MRK","14","27","27","Yesu akabhapwaghi bhabhulwa bhaki, “Mabhanganya mabhokapi mwindilaji na kuneka, ndandi mu Malembu Mahuhu Chapanga apwagha, ‘Ananunkoma mdima, na mambelele ghitenda kupechangana.’ ");
INSERT INTO mpa_vpl VALUES ("MK14_28","071_14_28","MRK","14","28","28","Nambu panihyokaje, ananundongulya kujenda ku Galilaya.” ");
INSERT INTO mpa_vpl VALUES ("MK14_29","071_14_29","MRK","14","29","29","Petulu akamuyangike, “Hata ngati bhokapi anabhukutiliki na kukuleka, nambu nepani nganakuleki ng'o!” ");
INSERT INTO mpa_vpl VALUES ("MK14_30","071_14_30","MRK","14","30","30","Yesu akumpwaghi Petulu, “Chakaka nukupwaghila, ikilu ja lalenu mangane ja likongobhi kubheka mala pabhele, anaunganaje mala patatu kubha ngacheumanye.” ");
INSERT INTO mpa_vpl VALUES ("MK14_31","071_14_31","MRK","14","31","31","Nambu Petulu akajendali kulongela, “Hata ngati imbalika kupotela papamu na wehapa nganakuleki ng'o.” Na bhabhulwa bhaki bhokapi na bhombi bhakalongi bhelabhela. ");
INSERT INTO mpa_vpl VALUES ("MK14_32","071_14_32","MRK","14","32","32","Bhela bhakahikiki ku chijongu chechilowakeka Gesemane, na Yesu akabhapwaghi bhabhulwa bhaki, “Ntamanya pambane chikahi nepani panundobha Chapanga.” ");
INSERT INTO mpa_vpl VALUES ("MK14_33","071_14_33","MRK","14","33","33","Panihapa akabhatoliki Petulu, Yakobo na Yohana. Akatumbwi Kuholalela na kuhangajika, ");
INSERT INTO mpa_vpl VALUES ("MK14_34","071_14_34","MRK","14","34","34","na akabhapwaghile, “Mili na mabhinilu makolongwa muntima wangu hata pambipi kupotela. Ntamanya pambani na mkubhaje mihu.” ");
INSERT INTO mpa_vpl VALUES ("MK14_35","071_14_35","MRK","14","35","35","Akapiti palongi pachokopi, akalihawi pahi, na kundobha Chapanga kubha, ngati anaiwezikana, ngaipetela mu lisaa la mang'ahiku hele. ");
INSERT INTO mpa_vpl VALUES ("MK14_36","071_14_36","MRK","14","36","36","Akapwaghike, “Atati wangu! Hindu yokapi kwaku wehapa iwezikana. Umokihaje chikombi chenjenu. Nambu ngakwikubha ngati mombali nepani, nambu ngati moupali wehapa.” ");
INSERT INTO mpa_vpl VALUES ("MK14_37","071_14_37","MRK","14","37","37","Akakelawiki kabheti kwa bhabhulwa bhatatu bhala akabhahimani bhagochili lughono. Bhela akundaluki Petulu, “Simoni, bho, ughochile? Ngachewaweziki kutama mihu hata lisaa limu na nepane?” ");
INSERT INTO mpa_vpl VALUES ("MK14_38","071_14_38","MRK","14","38","38","Na akabhapwaghi kabheti, “Mkubhaje mihu na kulobha nahuli ngamwijingi mu malengakeku, roho jipala, nambu hyegha ngachejibhi na makili.” ");
INSERT INTO mpa_vpl VALUES ("MK14_39","071_14_39","MRK","14","39","39","Akapiti kabheti kulobha pakabheli akakelabhuki malobhi ghalaghala. ");
INSERT INTO mpa_vpl VALUES ("MK14_40","071_14_40","MRK","14","40","40","Bhela akakelawiki kabheti na akabhahimani bhaghochile, ndandi mihu ghabhu ghakabhi ghatopike. Nabhombi ngachebhamanyi la kumuyanga. ");
INSERT INTO mpa_vpl VALUES ("MK14_41","071_14_41","MRK","14","41","41","Paakelawiki mala ja katatu, akabhapwaghile, “Bho, mwakali kughochela na kupomulela? Henu kuyaghanile! Lisaa lihikike! Lingalyaje, Mwana waka Mundu bhunjeghe mu mabhoku gha bhandu bhana mahoku. ");
INSERT INTO mpa_vpl VALUES ("MK14_42","071_14_42","MRK","14","42","42","Njumukaje, tumbokanyaje. Lingalyaje, jola joaning'anambukaje aheghalile.” ");
INSERT INTO mpa_vpl VALUES ("MK14_43","071_14_43","MRK","14","43","43","Yesu paakabhi akali kulongela, Yuda joakabhi jumu wa bhabhulwa komi na bhabheli bhala, akahikiki papamu na lipogha la bhandu bhabhabhi na mapanga na indonga. Bhandu bhanihabha bhakatumakiki na bhapenganyambiku bhakolongwa, bhabhola bha Shelia na bhazee. ");
INSERT INTO mpa_vpl VALUES ("MK14_44","071_14_44","MRK","14","44","44","Mng'anambuka Yuda akajomwi kubhapeke nginyulila kubha, “Jonambuswaje nde joju. Munkamulaje na kumpeleka pahi ja ulingalilu.” ");
INSERT INTO mpa_vpl VALUES ("MK14_45","071_14_45","MRK","14","45","45","Palapala Yuda pahikiki pela, akunjendi Yesu na kumpwaghila, “Mbola!” Panihapa akandamuki kwa kumbusu. ");
INSERT INTO mpa_vpl VALUES ("MK14_46","071_14_46","MRK","14","46","46","Bhela bhandu bhanihabha bhakunkamwi Yesu na kumbeka pahi ja ulingalilu. ");
INSERT INTO mpa_vpl VALUES ("MK14_47","071_14_47","MRK","14","47","47","Nambu jumu wa bhabhabhi bhajemani papamu na Yesu, akaholapwi lipanga laki, na kundapu mtumika waka Mpenganyambiku Nkolongwa, na kunheketa likutu. ");
INSERT INTO mpa_vpl VALUES ("MK14_48","071_14_48","MRK","14","48","48","Bhela Yesu akabhapwaghile, “Bho, unhiki na mapanga na indonga kungamula ngati kubha nepani nde mwihi? ");
INSERT INTO mpa_vpl VALUES ("MK14_49","071_14_49","MRK","14","49","49","Kila lichobha nakabhi papamu na mwehapa ku Nyumba jaka Chapanga, na ngachemwangamwile. Nambu aghagha ghahengakeka sajenu nahuli Malembu Mahuhu ghatimilaje.” ");
INSERT INTO mpa_vpl VALUES ("MK14_50","071_14_50","MRK","14","50","50","Panihapa bhabhulwa bhokapi bhakundekiki na kutilanila. ");
INSERT INTO mpa_vpl VALUES ("MK14_51","071_14_51","MRK","14","51","51","Kukabhi na nkombu jumu joakabhi anjengale Yesu koni akongiki lishuka pela. Bhakalengiki kunkamula, ");
INSERT INTO mpa_vpl VALUES ("MK14_52","071_14_52","MRK","14","52","52","nambu jombi akabhatilike, akalilekiki lishuka lela na kutila panga ingobhu. ");
INSERT INTO mpa_vpl VALUES ("MK14_53","071_14_53","MRK","14","53","53","Bhela bhakumpeliki Yesu kwa bhapenganyambiku bhakolongwa, kwa bhazee na bhabhola bha Shelia bhakabya bhalibhongini kunyumba jaka Mpenganyambiku Nkolongwa. ");
INSERT INTO mpa_vpl VALUES ("MK14_54","071_14_54","MRK","14","54","54","Petulu akunjengali Yesu cha kutali, akajingi mu liwangala laka Mpenganyambiku Nkolongwa. Akatami papamu na bhalonda akanyatukya moto. ");
INSERT INTO mpa_vpl VALUES ("MK14_55","071_14_55","MRK","14","55","55","Bhapenganyambiku bhakolongwa na pachengu pokapi bhakalondiki ulandilu wa kuntaki Yesu nahuli bhunkomaje, nambu ngachebhapatike. ");
INSERT INTO mpa_vpl VALUES ("MK14_56","071_14_56","MRK","14","56","56","Bhandu bhamaheli bhakabhohiki ulandilu wa upuhe panani jaka Yesu, nambu ulandilu wabhu wa upuhe ngachewalengine. ");
INSERT INTO mpa_vpl VALUES ("MK14_57","071_14_57","MRK","14","57","57","Bhandu bhangi bhakajemiki na kulonge malobhi gha upuhe kwaka Yesu, bhakapwaghaje, ");
INSERT INTO mpa_vpl VALUES ("MK14_58","071_14_58","MRK","14","58","58","“Tunjowini mundu hoju akapwaghaje, ‘Anamombula Nyumba jaka Chapanga jebhachengiki bhandu, na kwa machobha ghatatu ananjenga najenge jangakuchengakeka na bhandu.’ ” ");
INSERT INTO mpa_vpl VALUES ("MK14_59","071_14_59","MRK","14","59","59","Nambu hata bhela, ghala ghabhalandile ngacheghalengine. ");
INSERT INTO mpa_vpl VALUES ("MK14_60","071_14_60","MRK","14","60","60","Bhela Mpenganyambiku Nkolongwa akajemiki pachilanda jabhu na kundaluki Yesu, “Bho, ngacheuyanga lilobhi kubhokana na malobhi ghabhalandila kwako?” ");
INSERT INTO mpa_vpl VALUES ("MK14_61","071_14_61","MRK","14","61","61","Nambu Yesu akatami chinunu na ngacheakayangiki lilobhi hata limu. Mpenganyambiku Nkolongwa akundaluki kabhete, “Bho, wehapa le wa Kristo, Mwana waka Chapanga Mpengaleka?” ");
INSERT INTO mpa_vpl VALUES ("MK14_62","071_14_62","MRK","14","62","62","Yesu akayangike, “Nepani nde jombi. Kabheti anamumbonaje Mwana waka Mundu akabya atami ku upambala wa chiwoku cha kumalelelu waka Chapanga Joabhi na Makili, na koni akahikaje na mahundi gha kunani kumahunde!” ");
INSERT INTO mpa_vpl VALUES ("MK14_63","071_14_63","MRK","14","63","63","Panihapa Mpenganyambiku Nkolongwa akakachwi ingobhu yaki na kupwagha, “Ngachetupala kabheti mundu jongi alongilaje panani jaka mundu ajoju! ");
INSERT INTO mpa_vpl VALUES ("MK14_64","071_14_64","MRK","14","64","64","Njowini moantondule Chapanga. Bho, mbona bhole?” Bhokapi bhukuntemwili kubha impalika kupotela. ");
INSERT INTO mpa_vpl VALUES ("MK14_65","071_14_65","MRK","14","65","65","Bhela bhangi bhabhu bhakatumbwi kunhuni imata, kumuyeka ingobhu kumihu, kundapula na kumpwaghila, “Lotilaje, nane joakulapwi wehapa!” Na bhalonda bhakuntoliki na kundapu ighanja. ");
INSERT INTO mpa_vpl VALUES ("MK14_66","071_14_66","MRK","14","66","66","Petulu paakabhi akali pahi kuliwangala, mtumika jumu wa chimbomba waka Mpenganyambiku Nkolongwa akunhikile. ");
INSERT INTO mpa_vpl VALUES ("MK14_67","071_14_67","MRK","14","67","67","Paakumbweni Petulu anyatuki moto akundingalili, na kumpwaghila, “Hata wehapa ukabhi papamu na Yesu wa ku Nazaleti.” ");
INSERT INTO mpa_vpl VALUES ("MK14_68","071_14_68","MRK","14","68","68","Nambu Petulu akakanike, “Ngachenummanyi, wala ngachemanyi cheulongela.” Panihapa Petulu akapitiki kunja ja liwangala. Na likongobhi lakabhekike. ");
INSERT INTO mpa_vpl VALUES ("MK14_69","071_14_69","MRK","14","69","69","Mtumika wa chimbomba jola paakumbweni Petulu akatumbwi kubhapwaghi bhandu bhabhakajemiki panihapa, “Mundu jonjoni nde jumu wabho!” ");
INSERT INTO mpa_vpl VALUES ("MK14_70","071_14_70","MRK","14","70","70","Petulu akakaniki kabhete. Chikahi chocho, bhandu bhabhakajemiki panipala bhakumpwaghi Petulu, “Chakaka wehapa nde jumu wabho, maghambu hata wehapa uhumi ku Galilaya.” ");
INSERT INTO mpa_vpl VALUES ("MK14_71","071_14_71","MRK","14","71","71","Nambu Petulu akatumbwi kulipeke masolu na kulapa akapwaghaje, mbata masolu ngati ananonge upuhe, “Napa ngachenummanyi mundu hoju jomundongalela malobhi ghaki!” ");
INSERT INTO mpa_vpl VALUES ("MK14_72","071_14_72","MRK","14","72","72","Panihapa likongobhi lakabhekiki mala ja kabhele, na Petulu akakombwiki Yesu moakumpwaghile, “Mangane likongobhi kubheka mala pabhele, wingana mala patatu.” Na Petulu paakakombwiki, akalihawi pahi na akaleliki namaa. ");
INSERT INTO mpa_vpl VALUES ("MK15_1","071_15_1","MRK","15","1","1","Palukela pakwachaje, bhapenganyambiku bhakolongwa bhakahimangini papamu na bhazee, bhabhola bha Shelia na bhabholu bha pachengu pokapi, bhakunkongiki Yesu, na bhakumpeliki kwaka Pilato. ");
INSERT INTO mpa_vpl VALUES ("MK15_2","071_15_2","MRK","15","2","2","Pilato akundaluki Yesu, “Bho, wehapa le Unkolongwa wa Bhayahude?” Yesu akayangike, “Wehapa upwaghike.” ");
INSERT INTO mpa_vpl VALUES ("MK15_3","071_15_3","MRK","15","3","3","Bhapenganyambiku bhakolongwa bhakuntaki Yesu kwa malobhi ghamaheli. ");
INSERT INTO mpa_vpl VALUES ("MK15_4","071_15_4","MRK","15","4","4","Pilato akundaluki kabheti Yesu, “Bho, ngacheuyanga lilobhi? Lingalyaje ntundu mobhaletela matakilu ghamaheli panani jako!” ");
INSERT INTO mpa_vpl VALUES ("MK15_5","071_15_5","MRK","15","5","5","Nambu Yesu ngacheakayangiki lilobhi, mbaka Pilato akakangiche. ");
INSERT INTO mpa_vpl VALUES ("MK15_6","071_15_6","MRK","15","6","6","Pilato akabhi na ntetu chikahi cha Uwangalalu wa Pasaka kumbopulela mkongeka jumu, jobhundobha bhandu. ");
INSERT INTO mpa_vpl VALUES ("MK15_7","071_15_7","MRK","15","7","7","Chikahi hechi mundu jumu joalowakika Balaba, akakongakiki pandu pabhakongeka bhandu kwa ndandi ja kutumbuli ngondo na kubhakoma bhandu bhangi. ");
INSERT INTO mpa_vpl VALUES ("MK15_8","071_15_8","MRK","15","8","8","Lipogha la bhandu lakunjendi Pilato, na kundobha abhahengila ngati mowabheli ntetu wake. ");
INSERT INTO mpa_vpl VALUES ("MK15_9","071_15_9","MRK","15","9","9","Pilato akabhalalukile, “Bho, mpala numbopulya Nkolongwa wa Bhayahude?” ");
INSERT INTO mpa_vpl VALUES ("MK15_10","071_15_10","MRK","15","10","10","Ndandi jombi akamanyiki kubha bhapenganyambiku bhakolongwa bhakunkamwi Yesu kwa ndandi ja wihu. ");
INSERT INTO mpa_vpl VALUES ("MK15_11","071_15_11","MRK","15","11","11","Nambu bhapenganyambiku bhakolongwa bhakabhaswekaki bhandu nahuli bhundobha abhabhopulya Balaba bhunkonga Yesu. ");
INSERT INTO mpa_vpl VALUES ("MK15_12","071_15_12","MRK","15","12","12","Pilato akabhalaluki kabheti bhandu, “Bho, mpala nepani ndenda kyani na mundu jonjoni jomundoa Nkolongwa wa Bhayahude?” ");
INSERT INTO mpa_vpl VALUES ("MK15_13","071_15_13","MRK","15","13","13","Bhandu bhokapi bhakajamali bhakapwaghaje, “Unhwamba punsalaba!” ");
INSERT INTO mpa_vpl VALUES ("MK15_14","071_15_14","MRK","15","14","14","Nambu Pilato akabhalalukile, “Bho, maghambu kike? Bho, ahengiki lihakau bhole?” Nambu bhombi bhakajendali kujamalila, “Unhwamba punsalaba!” ");
INSERT INTO mpa_vpl VALUES ("MK15_15","071_15_15","MRK","15","15","15","Pilato akapaliki kubhahekeha bhandu bhala, bhela akumbopuli Balaba. Akalaghalaki Yesu alapulika iboku, na kumboha nahuli awambakikaje punsalaba. ");
INSERT INTO mpa_vpl VALUES ("MK15_16","071_15_16","MRK","15","16","16","Manjolinjoli bhakumpeliki Yesu mu liwangala la mkati la nyumba jaka Pilato, yani Pulaitolio, na kubhaloha lipogha lokapi la manjolinjoli. ");
INSERT INTO mpa_vpl VALUES ("MK15_17","071_15_17","MRK","15","17","17","Bhakamuwatiki ingobhu ja zambalau ngati Nkolongwa, bhakalokiki litaji la miha na kunhwatika kumutu. ");
INSERT INTO mpa_vpl VALUES ("MK15_18","071_15_18","MRK","15","18","18","Bhakatumbwi kundamukila kwa kundongama, “Monili ote, Unkolongwa wa Bhayahude!” ");
INSERT INTO mpa_vpl VALUES ("MK15_19","071_15_19","MRK","15","19","19","Bhakundapwi kwa ndahi kumuto, na kunhuni imata. Bhakachikimi na kunjojabhela. ");
INSERT INTO mpa_vpl VALUES ("MK15_20","071_15_20","MRK","15","20","20","Pabhajomwi kundongama, bhakunhuliki ingobhu ja zambalau jela, na kunhwatika ingobhu yaki mweni yela. Bhakumpihiki kunja nahuli kumpeleka kunhwamba punsalaba. ");
INSERT INTO mpa_vpl VALUES ("MK15_21","071_15_21","MRK","15","21","21","Pabhakabhi mwindela bhakahimangini na mundu jumu joalowakika Simoni, akabhi ahika kuhuma ku Kilene, jombi akabhi atati waka Alekizanda na Lufo. Na chikahi hechi akabhi ahuma kunja ja muchi, na manjolinjoli bhakumpwaghi kwa amuli atotulaje nsalaba ghoakabhi naku Yesu. ");
INSERT INTO mpa_vpl VALUES ("MK15_22","071_15_22","MRK","15","22","22","Bhela bhakumpeliki Yesu mbaka pa Goligota, yani “Lifuvu la Mmutu.” ");
INSERT INTO mpa_vpl VALUES ("MK15_23","071_15_23","MRK","15","23","23","Panihapa bhakumpeki divai jebhahangaghini na mitela jejilowakeka manemane, nambu Yesu ngacheanywile. ");
INSERT INTO mpa_vpl VALUES ("MK15_24","071_15_24","MRK","15","24","24","Bhela bhakunhwambiki na kughabhana ingobhu yaki kwa kuilapuli kula nahuli kumanya ngati ingobhu bhole jeapalika mundu kupata. ");
INSERT INTO mpa_vpl VALUES ("MK15_25","071_15_25","MRK","15","25","25","Jakabhi saa tatu ja lukela pabhunhwambikaje. ");
INSERT INTO mpa_vpl VALUES ("MK15_26","071_15_26","MRK","15","26","26","Na panani ja nsalaba bhakalembiki litakilu ale, “NKOLONGWA WA BHAYAHUDE.” ");
INSERT INTO mpa_vpl VALUES ("MK15_27","071_15_27","MRK","15","27","27","Bhela bhakunhwambiki Yesu punsalaba papamu na bhanyaghula bhangi bhabhele, jumu upambala wa kumalelelu na jongi upambala wa kumangeja. ");
INSERT INTO mpa_vpl VALUES ("MK15_28","071_15_28","MRK","15","28","28","Bhela Malembu Mahuhu ghakatimiye ghaghapwagha, “Akabhalangiki papamu na bhandu bhahakau.” ");
INSERT INTO mpa_vpl VALUES ("MK15_29","071_15_29","MRK","15","29","29","Bhandu bhabhapetika pandu panihapa bhakundongali matondo, bhakanyuanyua mimutu jabhu kwa kundongama, bhakapwaghaje, “Aha! Wehapa upwaghika wibhombula Nyumba jaka Chapanga na kuchenga kwa machobha ghatatu! ");
INSERT INTO mpa_vpl VALUES ("MK15_30","071_15_30","MRK","15","30","30","Henu, uhuluka punsalaba na ulikengalya wamwete!” ");
INSERT INTO mpa_vpl VALUES ("MK15_31","071_15_31","MRK","15","31","31","Na bhombi bhapenganyambiku bhakolongwa papamu na bhabhola bha Shelia bhakundongimi pachilanda jabhu, bhakapwaghaje, “Akabhalamihi bhangi, nambu ngacheaweza kulikengale mwene! ");
INSERT INTO mpa_vpl VALUES ("MK15_32","071_15_32","MRK","15","32","32","Eti jombi nde Kristo, Nkolongwa wa ku Izilaeli! Henu ahuluka kuhuma pansalaba nahuli tubhonaje na kuhobhalela.” Hata bhandu bhabhawambakiki pambipi na Yesu bhala bhakundongali matondo. ");
INSERT INTO mpa_vpl VALUES ("MK15_33","071_15_33","MRK","15","33","33","Kutumbu saa sita, mbaka saa tisa ja muhi, lubhendu lukayekiki inchi jokapi. ");
INSERT INTO mpa_vpl VALUES ("MK15_34","071_15_34","MRK","15","34","34","Saa tisa ja muhi Yesu akajamalili, akapwaghaje, “Eloi, Eloi, lama sabakitani,” ndandi jaki, “Chapanga wangu, Chapanga wangu, mbona unehile?” ");
INSERT INTO mpa_vpl VALUES ("MK15_35","071_15_35","MRK","15","35","35","Bhandu bhangi bhabhajemani panipala pabhakajowini ghanihagha, bhakapwaghike, “Jowanyaje! Andoha Eliya!” ");
INSERT INTO mpa_vpl VALUES ("MK15_36","071_15_36","MRK","15","36","36","Mundu jumu akakembili, akatobhali siponji mkati ja divai jejilolike, na kukongale kumwishu ja ndahi. Akumbeki pundomu akapwaghaje, “Mundeka tulolaje ngati Eliya anahika kunheleha kuhuma punsalaba hapa!” ");
INSERT INTO mpa_vpl VALUES ("MK15_37","071_15_37","MRK","15","37","37","Yesu akajamalili kwa sauti nkolongwa, na kuheketa roho. ");
INSERT INTO mpa_vpl VALUES ("MK15_38","071_15_38","MRK","15","38","38","Chikahi hechi lipanzia lelabhi mu Nyumba jaka Chapanga lakakachwiki ipambala ibheli kutumbu kunani mbaka pahi. ");
INSERT INTO mpa_vpl VALUES ("MK15_39","071_15_39","MRK","15","39","39","Nkolongwa jumu wa manjolinjoli joakajemiki palongi jaki paakaweni kubha Yesu apotela ngati bhenibhela, akapwaghike, “Chakaka mundu ajoju akabhi Mwana waka Chapanga!” ");
INSERT INTO mpa_vpl VALUES ("MK15_40","071_15_40","MRK","15","40","40","Bhakabhi kabheti akambomba bhangi cha kutali bhakalingalyaje, papuje akabhi Malia Magidalena, na Malia mabhu waka Yakobo na Yose, na Salome. ");
INSERT INTO mpa_vpl VALUES ("MK15_41","071_15_41","MRK","15","41","41","Akamabhu bhanihabha bhakunjengali Yesu ku Galilaya na kunjangatila. Akamabhu bhangi bhamaheli bhabhunjengali Yesu mbaka ku Yelusalemu na bhombi bhakabhi palapala. ");
INSERT INTO mpa_vpl VALUES ("MK15_42","071_15_42","MRK","15","42","42","Pakwahiki pakamihi, lichobha heli lakabhi Lichobha la Maandaliu, yani lichobha lelilongulela mangani ja Lichobha la Sabato. ");
INSERT INTO mpa_vpl VALUES ("MK15_43","071_15_43","MRK","15","43","43","Panihapa akahiki Yusufu mundu wa ku Alimataya, mbolu wa Pachengu Pakolongwa joakamanyakini namaa. Na jombi akabhi alendalela kuhika kwa Ukolongwa waka Chapanga. Akunjendi Pilato panga choghohi na kunjopa ampekya hyegha jaka Yesu. ");
INSERT INTO mpa_vpl VALUES ("MK15_44","071_15_44","MRK","15","44","44","Pilato akakangichi kujowana kubha Yesu akabhi apotile. Bhela akunkemiki nkolongwa wa manjolinjoli, na kundalukila ngati Yesu akapoti chikahi chilacho. ");
INSERT INTO mpa_vpl VALUES ("MK15_45","071_15_45","MRK","15","45","45","Pilato paakunjowini linjolinjoli jola kubha Yesu apotile, akunjetaki Yusufu atola hyegha jaka Yesu. ");
INSERT INTO mpa_vpl VALUES ("MK15_46","071_15_46","MRK","15","46","46","Panihapa Yusufu wa ku Alimataya akahemi sanda, akajiheli hyegha jaka Yesu, akajiyongalwi sanda. Akajibhehi mulitengele lelalenganakiki pa liganga. Kabheti akahingali liganga likolongwa na kuhibhali pundyangu wa litengele. ");
INSERT INTO mpa_vpl VALUES ("MK15_47","071_15_47","MRK","15","47","47","Na jombi Malia Magidalena na Malia mabhu waka Yose bhakabhi bhalingalila na kupabhona pandu pabhaghoniki hyegha jaka Yesu. ");
INSERT INTO mpa_vpl VALUES ("MK16_1","071_16_1","MRK","16","1","1","Palapetiki Lichobha la Sabato, Malia Magidalena, na Malia mabhu waka Yakobo, na Salome bhakahemi manungilu nahuli bhakapakiya hyegha jaka Yesu. ");
INSERT INTO mpa_vpl VALUES ("MK16_2","071_16_2","MRK","16","2","2","Bhela pachibhombu lichobha la Jumapile, lyobha palitumbula kupita, bhakapiti kulitengele. ");
INSERT INTO mpa_vpl VALUES ("MK16_3","071_16_3","MRK","16","3","3","Mwindela bhalongalanya bheni kwa bheni, “Bho, nde nane joakatukangila liganga lela pundyangu wa litengeli lela?” ");
INSERT INTO mpa_vpl VALUES ("MK16_4","071_16_4","MRK","16","4","4","Nambu pabhakalingalili bhakaweni liganga lela likangakiki kunkeghe. Liganga heli lakabhi likolongwa. ");
INSERT INTO mpa_vpl VALUES ("MK16_5","071_16_5","MRK","16","5","5","Bhela pabhakajingi mkati mulitengele, bhakumbweni nkombu jumu awati ingobhu ihuhu atami upambala wa kumalelelu, na bhombi bhakakangichi namaa. ");
INSERT INTO mpa_vpl VALUES ("MK16_6","071_16_6","MRK","16","6","6","Nambu nkombu jola akabhapwaghile, “Ngamwikangacha. Manyi mumpala Yesu wa ku Nazaleti, joakawambakike. Ayokike, ngacheabhi pambane! Ndingalyaje pandu pambani pabhakumbekike. ");
INSERT INTO mpa_vpl VALUES ("MK16_7","071_16_7","MRK","16","7","7","Henu njendanya mwakabhapwaghila bhabhulwa bhaki papamu na Petulu kubha, ‘Jombi anaandongulyaje kujenda ku Galilaya, konihoku bhakumbona ngati moakumpwaghile.’ ” ");
INSERT INTO mpa_vpl VALUES ("MK16_8","071_16_8","MRK","16","8","8","Bhela bhakabhokiki palitengeli pala imbelu, ndandi bhakabhaghiji kwa lujoghopu na kukangacha. Ngachebhumpwaghi mundu jokapi chindu, maghambu bhakajowipi namaa. ");
INSERT INTO mpa_vpl VALUES ("MK16_9","071_16_9","MRK","16","9","9","Yesu paakahyokiki lukela pachibhombu lichobha la Jumapili, akatumbwi kumpitali Malia Magidalena, mabhu jola Yesu joakumpihiki majobhi saba. ");
INSERT INTO mpa_vpl VALUES ("MK16_10","071_16_10","MRK","16","10","10","Malia Magidalena akapiti kubhapwaghi bhabhabhi papamu na Yesu. Na chikahi hechi bhabhulwa bhala bhakabhi bhaombuleza na kulela. ");
INSERT INTO mpa_vpl VALUES ("MK16_11","071_16_11","MRK","16","11","11","Nambu pabhakajowini kubha Yesu abhi mwomi na Malia Magidalena ambweni, ngachebhahobhalile. ");
INSERT INTO mpa_vpl VALUES ("MK16_12","071_16_12","MRK","16","12","12","Palongi jaki akabhapitali bhabhulwa bhabheli akabya na sula najenge. Bhabhulwa habha bhakabhi bhajenda kungonda. ");
INSERT INTO mpa_vpl VALUES ("MK16_13","071_16_13","MRK","16","13","13","Na bhombi kabheti bhakapiti kubhapwaghi bhajabho, nambu papamu na bhela ngachebhahobhalile. ");
INSERT INTO mpa_vpl VALUES ("MK16_14","071_16_14","MRK","16","14","14","Pakujomukela Yesu akabhapitali bhabhulwa bhaki komi na jumu bhabhabhi pamu pabhakulikaje. Akabhalakali namaa ndandi bhakakaniki kubhahobhalela bhabhumbweni Yesu paakahyokike. ");
INSERT INTO mpa_vpl VALUES ("MK16_15","071_16_15","MRK","16","15","15","Bhela akabhapwaghile, “Njendanya kundema wokapi mkatangazaje Malobhi Manyahi kwaka kila mundu. ");
INSERT INTO mpa_vpl VALUES ("MK16_16","071_16_16","MRK","16","16","16","Mundu jokapi joahobhalela na kubatizwa anakengaliwaje. Nambu jwangakuhobhalela, anatemuliwaje. ");
INSERT INTO mpa_vpl VALUES ("MK16_17","071_16_17","MRK","16","17","17","Na bhokapi bhabhinhobhalyaje bhimanyikana kwa hindu haye, kwa lihina langu anabhabhohaje majobhi na bhilongilaje kwa lugha nayeghe. ");
INSERT INTO mpa_vpl VALUES ("MK16_18","071_16_18","MRK","16","18","18","Anabhakamwi lijoka au kunywa chindu cha kukoma ngayapoteke. Anabhabhekila bhatamwa mabhoku, na Chapanga anaabhalamihaje.” ");
INSERT INTO mpa_vpl VALUES ("MK16_19","071_16_19","MRK","16","19","19","Bhela, Bambo Yesu paakajomwi kulonge nabhu, akatolakiki kujenda kunani kumahunde, atami ku upambala wa kumalelelu wa chiwoku chaka Chapanga. ");
INSERT INTO mpa_vpl VALUES ("MK16_20","071_16_20","MRK","16","20","20","Bhabhulwa bhakapiti kutangaza Malobhi Manyahi pandu pokapi. Bambo akahengiki lihengu papamu nabhu, na kuhenga nginyulila yamahele nahuli kulangi uchakaka wa ubholu hoghu kwa nginyulila yeyahengakike.");
INSERT INTO mpa_vpl VALUES ("LK1_1","072_1_1","LUK","1","1","1","Unkolongwa Teofile: Bhandu bhamaheli bhakatumbwi kulemba ngati mobhawezi panani ja mambu ghaghatendakiki pa chilanda jitu. ");
INSERT INTO mpa_vpl VALUES ("LK1_2","072_1_2","LUK","1","2","2","Bhakalembiki ngati ghabhakatupwaghili na bhandu bhabhakaghaweni mambu ghanighala kutumbu pakutumbula na bhandu bhalabhala bhabhatangizi ubholu ghonighola. ");
INSERT INTO mpa_vpl VALUES ("LK1_3","072_1_3","LUK","1","3","3","Wenga Unkolongwa, nenga nanatu panakalingalaki wichu kutumbu paghatumbulaje, nakaamwi kukulembela malobhi ghanihagha kwa kulongana. ");
INSERT INTO mpa_vpl VALUES ("LK1_4","072_1_4","LUK","1","4","4","Nihenga bhenibhela nahuli na wehapa uweza kumanya uchakaka wokapi wa mambu ghabhakakubholiki. ");
INSERT INTO mpa_vpl VALUES ("LK1_5","072_1_5","LUK","1","5","5","Chikahi Helode paakabhi nkolongwa wa ku Yudea, kukabhi na mpenganyambiku jumu lihina laki Zakalia, akahumi mu lukolu lwa kibheleku chaka Abiya. Nhwanu waki alowakika Elizabeti, najombi akahumiki mu lukolu lwaka mpenganyambiku Aroni. ");
INSERT INTO mpa_vpl VALUES ("LK1_6","072_1_6","LUK","1","6","6","Zakalia na nhwanu waki Elizabeti bhakabhi bhandu bhambone palongi jaka Chapanga, koni bhakakamulakya wichu amuli na malaghalakilu ghokapi ghaka Bambo. ");
INSERT INTO mpa_vpl VALUES ("LK1_7","072_1_7","LUK","1","7","7","Nambu bhombi bhakabhi panga na bhana, maghambu Elizabeti akabhi ngulumba, na bhokapi bhakabhi bhaseja nakanopi. ");
INSERT INTO mpa_vpl VALUES ("LK1_8","072_1_8","LUK","1","8","8","Lichobha limu, Zakalia jakabhi zamu jaki ja kuhenga lihengu la upenganyambiku mu Nyumba jaka Chapanga, ");
INSERT INTO mpa_vpl VALUES ("LK1_9","072_1_9","LUK","1","9","9","Zakalia akahaghuliki kwa gudugudu ngati mowabheli ntetu wa upenganyambiku. Henu akajingi mu Nyumba jaka Bambo nahuli kuhuwa ubane. ");
INSERT INTO mpa_vpl VALUES ("LK1_10","072_1_10","LUK","1","10","10","Chikahi cha kuhuwa ubane pachaheghalili, bhandu bhokapi bhakabhi kunja bhakundobha Chapanga. ");
INSERT INTO mpa_vpl VALUES ("LK1_11","072_1_11","LUK","1","11","11","Bhela mtumika wa kunani waka Bambo akumpitalili, akabya ajemi upambala wa kumalelelu wa meza ja kuhuwi ubane. ");
INSERT INTO mpa_vpl VALUES ("LK1_12","072_1_12","LUK","1","12","12","Zakalia paakambweni mtumika wa kunani waka Chapanga jola, akakangichi namaa na akatwelili choghohi. ");
INSERT INTO mpa_vpl VALUES ("LK1_13","072_1_13","LUK","1","13","13","Nambu, mtumika wa kunani akumpwaghili, “Zakalia, ngawijoghopa! Chapanga ajowini kulobha kwaku. Elizabeti nhwanu waku anaakubhelakya mwana wa chikambaku, na wenga wandoha lihina laki Yohana. ");
INSERT INTO mpa_vpl VALUES ("LK1_14","072_1_14","LUK","1","14","14","Wenga anauhekalya nakanopi na kululuta, na bhandu bhamaheli anabhahekalya kwa kubhelakeka kwaki. ");
INSERT INTO mpa_vpl VALUES ("LK1_15","072_1_15","LUK","1","15","15","Maghambu Yohana anaabya mtumika nkolongwa palongi jaka Bambo. Ngaikunywi divai wala uwembi. Na jombi anaatwelakika Roho Mhuhu hata mangane ja kubhelakeka kwaki. ");
INSERT INTO mpa_vpl VALUES ("LK1_16","072_1_16","LUK","1","16","16","Jombi anabhakelabhua bhandu bhamaheli bha ku Izilaeli bhakelabhuka kwaka Bambo Chapanga wabhu. ");
INSERT INTO mpa_vpl VALUES ("LK1_17","072_1_17","LUK","1","17","17","Anaalongulya palongi jaka Bambo, anaakubha na makili na roho ngati jaka mlota Eliya. Anabhakelabhua akatati bhajongana na bhana bhabhu, anabhakelabhua bhandu bhangakutii bhabya bhandu bhabhuntii Chapanga, na kubhabheka bhandu bhaliandiya kunjopale Bambo.” ");
INSERT INTO mpa_vpl VALUES ("LK1_18","072_1_18","LUK","1","18","18","Zakalia akundaluki mtumika wa kunani kwaka Chapanga, “Bho, anamanya bhole ngati chindu hechi anachibya bhenibhela? Nepani nuncheya, na nhwanu wangu bhelabhela akongapile.” ");
INSERT INTO mpa_vpl VALUES ("LK1_19","072_1_19","LUK","1","19","19","Mtumika wa kunani kwaka Chapanga jola akayangiki, “Nepani nde Gabilieli. Nenyema palongi jaka Chapanga, ndumakiki nongila na wehapa na nukupwaghila malobhi manyahi ghani. ");
INSERT INTO mpa_vpl VALUES ("LK1_20","072_1_20","LUK","1","20","20","Jowanya, anaubya umpuli maghambu ngacheuhobhali malobhi ghangu ghaghihengakika kwa chikahi chaki, ngawiwezi kulongela mbaka ghangani ghanukupwaghili paghipitilaje chakaka.” ");
INSERT INTO mpa_vpl VALUES ("LK1_21","072_1_21","LUK","1","21","21","Chikahi hechi bhandu bhakabhi bhundendale Zakalia kunja koni bhakakangacha kwa kukabhakila kwaki mu Nyumba jaka Chapanga mola. ");
INSERT INTO mpa_vpl VALUES ("LK1_22","072_1_22","LUK","1","22","22","Panihapa papitiki kunja, ngacheaweziki kulonge nabhu, bhela bhombi bhakamanyi kubha aweni mabhono mu Nyumba jaka Chapanga mola. Akajendali kulonge nabhu kwa nginyulila ya mabhoku ghaki, maghambu akabhi mpuli. ");
INSERT INTO mpa_vpl VALUES ("LK1_23","072_1_23","LUK","1","23","23","Machobha ghaki gha kuhenga lihengu mu Nyumba jaka Chapanga paghajomwiki, Zakalia akabujiki kunyumba jake. ");
INSERT INTO mpa_vpl VALUES ("LK1_24","072_1_24","LUK","1","24","24","Paghapetiki machobha machokope nhwanu wake Elizabeti akapatiki chitumbu. Akalihiiki munyumba kwa chikahi cha myehi nhwanu. ");
INSERT INTO mpa_vpl VALUES ("LK1_25","072_1_25","LUK","1","25","25","Elizabeti akapwaghike, “Lendenu nde leandendi Bambo, aningalili na kumokela hiyoni pamihu ja bhandu!” ");
INSERT INTO mpa_vpl VALUES ("LK1_26","072_1_26","LUK","1","26","26","Pamwehi wa sita Chapanga akantumiki mtumika waki Gabilieli kujenda mbaka ku muchi wa Nazaleti, ku inchi ja Galilaya. ");
INSERT INTO mpa_vpl VALUES ("LK1_27","072_1_27","LUK","1","27","27","Akuntumiki kwaka mwali jumu bikila joalowakika Malia, joakabhowakiki hweku na nkambaku joalowakika Yusufu, joakahumi mu lukolu lwaka Nkolongwa Daude. ");
INSERT INTO mpa_vpl VALUES ("LK1_28","072_1_28","LUK","1","28","28","Mtumika wa kunani kwaka Chapanga akunhiki mwali jola na kumpwaghila, “Monile! Bambo abhi papamu na wehapa, najombi atehi kukupengalela!” ");
INSERT INTO mpa_vpl VALUES ("LK1_29","072_1_29","LUK","1","29","29","Malia paakajowini malobhi ghanighala, akaholali nakanopi muntima waki, panihapa akakangichi, akapwaghaje, “Ulamukilu hoghu ndandi jaki kike?” ");
INSERT INTO mpa_vpl VALUES ("LK1_30","072_1_30","LUK","1","30","30","Mtumika wa kunani kwaka Chapanga jola akumpwaghile, “Malia, ngawijoghopa! Maghambu upatiki chihomu palongi jaka Chapanga. ");
INSERT INTO mpa_vpl VALUES ("LK1_31","072_1_31","LUK","1","31","31","Lingalyaje, anaupata chitumbu na anaumbelaka mwana nkambaku, na wandoha lihina laki Yesu. ");
INSERT INTO mpa_vpl VALUES ("LK1_32","072_1_32","LUK","1","32","32","Jombi anaabya nkolongwa analowakika Mwana waka Chapanga Nkolongwa joabhi Kunani Nakanopi. Na Bambo Chapanga anaampekya chiteu cha ukolongwa chaka hokolu waki Daude. ");
INSERT INTO mpa_vpl VALUES ("LK1_33","072_1_33","LUK","1","33","33","Jombi anaabya nkolongwa wa lubheleku lwaka Yakobo mileli, na ukolongwa waki ngawijomoke!” ");
INSERT INTO mpa_vpl VALUES ("LK1_34","072_1_34","LUK","1","34","34","Malia akamuyangiki mtumika waka Chapanga jola, “Nepani nde mwali bikila. Henu, bho, lijambu heli analiwezikana bhole?” ");
INSERT INTO mpa_vpl VALUES ("LK1_35","072_1_35","LUK","1","35","35","Mtumika waka Chapanga akamuyangiki, “Roho Mhuhu anaakuhelalya panani jaku, na makili ghaka Chapanga anaghakuyekaje. Henu mwana Mhuhu anaabhelakikaje, analowakika Mwana waka Chapanga. ");
INSERT INTO mpa_vpl VALUES ("LK1_36","072_1_36","LUK","1","36","36","Ukombuka kabheti ndongu waku Elizabeti, apatiki chitumbu koni akabya ncheya, na sajenu abhi na chitumbu cha myehi sita, jombi joalowakika ngulumba. ");
INSERT INTO mpa_vpl VALUES ("LK1_37","072_1_37","LUK","1","37","37","Maghambu nga chindu chechilepa kuhengakeka kwaka Chapanga.” ");
INSERT INTO mpa_vpl VALUES ("LK1_38","072_1_38","LUK","1","38","38","Malia akapwaghike, “Nepani mtumika waka Bambo, ibya kwangu ngati moupwaghile.” Panihapa mtumika wa kunani jola akabhokike. ");
INSERT INTO mpa_vpl VALUES ("LK1_39","072_1_39","LUK","1","39","39","Machobha gha palongi, Malia akajombatiki kujenda ku muchi ghumu ghoukabhi ku inchi ja itombi ja ku Yudea. ");
INSERT INTO mpa_vpl VALUES ("LK1_40","072_1_40","LUK","1","40","40","Konihoku akajingi mu nyumba jaka Zakalia na kundamuki Elizabeti. ");
INSERT INTO mpa_vpl VALUES ("LK1_41","072_1_41","LUK","1","41","41","Elizabeti paajowana Malia andamukila, mwana joakabhi mulutumbu jaki akatehi kuhomba. Elizabeti akatwelakiki Roho Mhuhu, ");
INSERT INTO mpa_vpl VALUES ("LK1_42","072_1_42","LUK","1","42","42","akajamalili kwa kupwagha, “Upengaliki wehapa pachilanda ja akambomba, na mwana jowambelakaje apengalike! ");
INSERT INTO mpa_vpl VALUES ("LK1_43","072_1_43","LUK","1","43","43","Bho, maghambu kiki lijambu likolongwa heli limbitali nepane, mbaka mabhu waka Bambo wangu anihiki nepane? ");
INSERT INTO mpa_vpl VALUES ("LK1_44","072_1_44","LUK","1","44","44","Panyowana ulamukilu waku, mwana joabhi mulutumbu lwangu akahombiki kwa chiheku. ");
INSERT INTO mpa_vpl VALUES ("LK1_45","072_1_45","LUK","1","45","45","Upengaliki wehapa maghambu uhobhalili kubha analipitalya lijambu leakupwaghi Bambo!” ");
INSERT INTO mpa_vpl VALUES ("LK1_46","072_1_46","LUK","1","46","46","Malia akapwaghike, “Mtima wangu undumbali Bambo, ");
INSERT INTO mpa_vpl VALUES ("LK1_47","072_1_47","LUK","1","47","47","roho jangu junhekalela Chapanga Mkengalela wangu, ");
INSERT INTO mpa_vpl VALUES ("LK1_48","072_1_48","LUK","1","48","48","maghambu angombwiki nepani nuntumika waki nenilihelea! Kutumbu sajenu na kujendalela ibheleku yokapi anabhanoa mpengaleka. ");
INSERT INTO mpa_vpl VALUES ("LK1_49","072_1_49","LUK","1","49","49","Maghambu Chapanga Mweni Makili andendi mambu makolongwa. Na lihina laki nde lihuhu. ");
INSERT INTO mpa_vpl VALUES ("LK1_50","072_1_50","LUK","1","50","50","Chiha chaki chabhajendela bhandu bhabhunjojabhela, kutumbu chibheleku mbaka chibheleku chenge. ");
INSERT INTO mpa_vpl VALUES ("LK1_51","072_1_51","LUK","1","51","51","Atendiki mambu makolongu kwa chiwoku chaki. Abhalekanishi bhandu bhabhabhi na ing'omu, mu maholalelu gha mintima jabhu. ");
INSERT INTO mpa_vpl VALUES ("LK1_52","072_1_52","LUK","1","52","52","Abhaheli bhakolongwa kuhuma pa hiteu yabhu ya ukolongwa, abhakwehiki akakahochu. ");
INSERT INTO mpa_vpl VALUES ("LK1_53","072_1_53","LUK","1","53","53","Abhatupalishi bhabhabhi na injala kwa hindu yambone, na bhanamali abhatopwi mabhoku matopu. ");
INSERT INTO mpa_vpl VALUES ("LK1_54","072_1_54","LUK","1","54","54","Anjangati mtumika waki Izilaeli, na ngacheajewiki kundangi chiha chaki. ");
INSERT INTO mpa_vpl VALUES ("LK1_55","072_1_55","LUK","1","55","55","Ngati mobhalaghali akatati bhitu, Ibulahimu na lubheleku lwaki, mbaka mileli!” ");
INSERT INTO mpa_vpl VALUES ("LK1_56","072_1_56","LUK","1","56","56","Malia akatemi na Elizabeti kwa chikahi cha myehi jitatu, na akakelawiki kunyumba jake. ");
INSERT INTO mpa_vpl VALUES ("LK1_57","072_1_57","LUK","1","57","57","Chikahi cha kulibhopola kwaki Elizabeti ukahikiki, akalibhopwi mwana wa chikambaku. ");
INSERT INTO mpa_vpl VALUES ("LK1_58","072_1_58","LUK","1","58","58","Bhandu bha pambipi jaki na bhalongu bhaki bhakajowini Bambo amboni chiha nakanopi, bhokapi bhakahekali papamu naku. ");
INSERT INTO mpa_vpl VALUES ("LK1_59","072_1_59","LUK","1","59","59","Mwana paahiki machobha nane bhakahiki kunheketa jando. Bhakapaliki kumpeke lihina Zakalia, lihina la atati waki. ");
INSERT INTO mpa_vpl VALUES ("LK1_60","072_1_60","LUK","1","60","60","Nambu mabhu waki akapwaghiki, “Ngabhela! Lihina laki analowakika Yohana.” ");
INSERT INTO mpa_vpl VALUES ("LK1_61","072_1_61","LUK","1","61","61","Bhandu bhakumpwaghile, “Bho, mbona njeta mundu jokapi mu lukolu lwaki joabhi na lihina lenihele?” ");
INSERT INTO mpa_vpl VALUES ("LK1_62","072_1_62","LUK","1","62","62","Bhela bhakalongi naku kwa nginyulila ya mabhoku atati waki nahuli bhapata kumanya apalika mwana waki andoha lihina bhole. ");
INSERT INTO mpa_vpl VALUES ("LK1_63","072_1_63","LUK","1","63","63","Zakalia akalobhiki chibau cha kulembela, akalembiki ana, “Lihina laki Yohana.” Bhandu bhokapi bhakakangiche! ");
INSERT INTO mpa_vpl VALUES ("LK1_64","072_1_64","LUK","1","64","64","Palapala Zakalia akaweziki kulonge kabhete, akatumbwili kulonge kabete, na kundumbalila Chapanga. ");
INSERT INTO mpa_vpl VALUES ("LK1_65","072_1_65","LUK","1","65","65","Bhandu bha pambipi jaki bhakajowipi, na malobhi hagha ghakajaghani ku inchi jokapi ja hitombi ja ku Yudea. ");
INSERT INTO mpa_vpl VALUES ("LK1_66","072_1_66","LUK","1","66","66","Kila mundu joakajowini malobhi hagha akaholalili na kulilalukila, “Bho, mwana jonjo anaabya wa ntundu bhole?” Maghambu makili ghaka Bambo ghabhi papamu naku. ");
INSERT INTO mpa_vpl VALUES ("LK1_67","072_1_67","LUK","1","67","67","Zakalia, atati waka Yohana akatwelakiki Roho Mhuhu, na kupwagha ulota agho, ");
INSERT INTO mpa_vpl VALUES ("LK1_68","072_1_68","LUK","1","68","68","“Leka tundumbalya Bambo, Chapanga wa Izilaeli! Maghambu abhahikili bhandu bhaki na kubhakombola. ");
INSERT INTO mpa_vpl VALUES ("LK1_69","072_1_69","LUK","1","69","69","Atupeki tepani Mkengalela mwana makile, nchokolu waka mtumika waki Daude. ");
INSERT INTO mpa_vpl VALUES ("LK1_70","072_1_70","LUK","1","70","70","Ngati moakalongali kutumbu pamwandi kupete bhalota bhaki bhahuhu, ");
INSERT INTO mpa_vpl VALUES ("LK1_71","072_1_71","LUK","1","71","71","kubha anaatukengalya kuhuma mu mabhoku gha maadui bhitu, na kuhuma mu makili gha bhokapi bhabhatuhakalila. ");
INSERT INTO mpa_vpl VALUES ("LK1_72","072_1_72","LUK","1","72","72","Akapwaghiki anaabhonila chiha bhazee bhitu, na kulukomboka Lulaghilu lwaki luhuhu. ");
INSERT INTO mpa_vpl VALUES ("LK1_73","072_1_73","LUK","1","73","73","Akundapi Ibulahimu atati witu, ");
INSERT INTO mpa_vpl VALUES ("LK1_74","072_1_74","LUK","1","74","74","kubha anaatukengalyaje kuhuma kwa maadui bhitu. Na kunjojabhe Chapanga panga choghohi, ");
INSERT INTO mpa_vpl VALUES ("LK1_75","072_1_75","LUK","1","75","75","henu tupalika tubya twabhahuhu na tubya bhandu tetujetakalewa palongi jaki, machobha ghokapi gha womi witu.” ");
INSERT INTO mpa_vpl VALUES ("LK1_76","072_1_76","LUK","1","76","76","“Wenga wa mwanangu, anaulowakika mlota waka Chapanga joabhi Kunani Nakanope. Anaundongulya Bambo kundenganakela indela jaki, ");
INSERT INTO mpa_vpl VALUES ("LK1_77","072_1_77","LUK","1","77","77","kubhatangazi bhandu bhaki anabhakengaliwaje kwa kulekakewa mahoku ghabhu. ");
INSERT INTO mpa_vpl VALUES ("LK1_78","072_1_78","LUK","1","78","78","Chapanga witu abhi na chiha na mtima wambone. Anaatumulakya unang'anu kuhuma kunani, ");
INSERT INTO mpa_vpl VALUES ("LK1_79","072_1_79","LUK","1","79","79","nahuli kubhamulakila bhokapi bhabhabhi mu lubhendu na mu chihilu cha kupotela, na kutulongo magholu ghitu mwindela ja lukwale.” ");
INSERT INTO mpa_vpl VALUES ("LK1_80","072_1_80","LUK","1","80","80","Mwana akakoliki na kujonjukeka makili mu roho, akatami kuchingwenji mbaka lichobha lela paalilangia palanga kwa bhandu bha Izilaeli. ");
INSERT INTO mpa_vpl VALUES ("LK2_1","072_2_1","LUK","2","1","1","Machobha ghala Kaisali Agusto, akalaghalaki bhandu bhokapi bha pundema bhabhalangikaje. ");
INSERT INTO mpa_vpl VALUES ("LK2_2","072_2_2","LUK","2","2","2","Akoku kukabhi kubhalangika kwa kutumbula, Kilenio paakabhi chiongozi wa ku inchi ja ku Silia. ");
INSERT INTO mpa_vpl VALUES ("LK2_3","072_2_3","LUK","2","3","3","Kila mundu akapiti ku muchi waki ghoabhelakike kulemba lihina laki. ");
INSERT INTO mpa_vpl VALUES ("LK2_4","072_2_4","LUK","2","4","4","Yusufu akabhokiki kuhuma ku muchi wa Nazaleti ghoubhi ku inchi ja ku Galilaya, akapiti ku Beselehemu ghoukabhi ku muchi wa Yudea, pandu paakabhelakiki Nkolongwa Daude. Yusufu akapiti konihoku ndandi akahumi mu lubheleku lwaka Daude. ");
INSERT INTO mpa_vpl VALUES ("LK2_5","072_2_5","LUK","2","5","5","Akapiti kulembakeka konihoku papamu na Malia, joakumboki hweku na akabhi na chitumbu. ");
INSERT INTO mpa_vpl VALUES ("LK2_6","072_2_6","LUK","2","6","6","Bhakabya ku Beselehemu, lichobha laki Malia la kulibhopola lakahikike. ");
INSERT INTO mpa_vpl VALUES ("LK2_7","072_2_7","LUK","2","7","7","Akalibhopwi mwana waki wa kutumbula wa chikambaku, akamuwatiki indenga. Na kungoneka mu libheghi la kulekeha hinyama, maghambu ngachebhapatiki mbekenyu ja kutama mu nyumba ja kuhiki bhaghene. ");
INSERT INTO mpa_vpl VALUES ("LK2_8","072_2_8","LUK","2","8","8","Pa inchi jela bhakabhi bhadima bhabhakabhi bhatami mu mighonda, bhakalenda mapogha gha hinyama yabhu ikilu. ");
INSERT INTO mpa_vpl VALUES ("LK2_9","072_2_9","LUK","2","9","9","Bhela mtumika wa kunani waka Bambo akabhapitalili, na ulumbalilu waka Bambo ukabhamulakile. Na bhombi bhakajowipi namaa, ");
INSERT INTO mpa_vpl VALUES ("LK2_10","072_2_10","LUK","2","10","10","nambu mtumika waka Chapanga jola akabhapwaghile, “Ngamwijoghopa! Maghambu nhiki kundete malobhi manyahi gha chiheku chekibya kwa bhandu bhokape. ");
INSERT INTO mpa_vpl VALUES ("LK2_11","072_2_11","LUK","2","11","11","Lalenu ku muchi waka Nkolongwa Daude abhelakiki Mkengalela winu, jombi nde Kristo, Bambo! ");
INSERT INTO mpa_vpl VALUES ("LK2_12","072_2_12","LUK","2","12","12","Jenje nde anajibya nginyulila kwinu, anamunhimanya mwana nchoku bhunhwatiki indenga, na bhungoniki mu libheghi la kulekeha hinyama.” ");
INSERT INTO mpa_vpl VALUES ("LK2_13","072_2_13","LUK","2","13","13","Palapala bhatumika bhaka Chapanga bhamaheli bhakahikiki na kuhimangana na mtumika njabhu, bhakunjembili Chapanga bhakapwaghaje: ");
INSERT INTO mpa_vpl VALUES ("LK2_14","072_2_14","LUK","2","14","14","“Ulumbalilu kwaka Chapanga Kunani Nakanope, na lukwali kwa bhandu bhabhabhi pundema pokapi bhabhapalakiki naku!” ");
INSERT INTO mpa_vpl VALUES ("LK2_15","072_2_15","LUK","2","15","15","Bhatumika bhaka Chapanga bhala pabhakelawiki kunani kumahunde, bhadima bhakapwaghanile, “Tumbokanyaje ku Beselehemu tukalolaje chenihechi chechipitalile, ghaatupwaghi Bambo.” ");
INSERT INTO mpa_vpl VALUES ("LK2_16","072_2_16","LUK","2","16","16","Henu bhakakembili ku Beselehemu, bhakabhahimani Malia na Yusufu na mwana nkeki jola akabya aghoni pandu pa kulekeha hinyama. ");
INSERT INTO mpa_vpl VALUES ("LK2_17","072_2_17","LUK","2","17","17","Bhadima bhala pabhakumbweni mwana jola, bhakabhapwaghi malobhi kubhokana na mwana ghaakalongili mtumika wa kunani kwaka Chapanga. ");
INSERT INTO mpa_vpl VALUES ("LK2_18","072_2_18","LUK","2","18","18","Bhandu bhokapi bhabhajowini malobhi ghanihagha, bhakakangichi kubhokana na malobhi hagha gha bhadima. ");
INSERT INTO mpa_vpl VALUES ("LK2_19","072_2_19","LUK","2","19","19","Nambu Malia akaghabhehi malobhi ghokapi hagha muntima jaki na kughaholalela nakanopi. ");
INSERT INTO mpa_vpl VALUES ("LK2_20","072_2_20","LUK","2","20","20","Bhadima bhala bhakakelawiki kabheti kuchingwenji, koni bhakunjembila na kundumbali Chapanga kwa ghokapi ghabhajowini na kughabhona, ghokapi ghakahengakiki ngati mtumika wa kunani kwaka Chapanga moakapwaghile. ");
INSERT INTO mpa_vpl VALUES ("LK2_21","072_2_21","LUK","2","21","21","Mu lichobha la nane, lichobha la kuncheku mwana jando palahikaji, akalowakiki lihina laki Yesu. Lihina leniheli akapatiki kuhuma kwaka mtumika wa kunani waka Chapanga pala mabhu waki paakabhi akona ngakutogho chitumbu. ");
INSERT INTO mpa_vpl VALUES ("LK2_22","072_2_22","LUK","2","22","22","Machobha ghakahikite ghaka Malia na Yusufu kutenda ntetu wa kugholuleka nahuli kujetakalewa na Chapanga ngati Shelia jaka Musa mojilaghalakila. Bhela bhakuntoliki mwana, bhakapiti naku ku muchi wa ku Yelusalemu na kumbeka palongi jaka Bambo. ");
INSERT INTO mpa_vpl VALUES ("LK2_23","072_2_23","LUK","2","23","23","Ngati moilembakike mu Shelia jaka Bambo: “Kila mbelakeka wa kutumbula wa chikambaku abhohakika kwaka Bambo.” ");
INSERT INTO mpa_vpl VALUES ("LK2_24","072_2_24","LUK","2","24","24","Kabheti bhakapiti nahuli kubhoha nyambiku kwaka Chapanga, na bhakapalakiki kubhoha injebha ibheli au ibhana ibheli ya ngunda, ngati mojilongale Shelia jaka Bambo. ");
INSERT INTO mpa_vpl VALUES ("LK2_25","072_2_25","LUK","2","25","25","Ku Yelusalemu kola kukabhi na mundu jumu joalowakika Simeoni. Mundu jonihoju akabhi wambone na joanjojabhe Chapanga. Jombi alendalya kuhika kwa ukombola wa Izilaeli, na Roho Mhuhu akabhi papamu naku. ");
INSERT INTO mpa_vpl VALUES ("LK2_26","072_2_26","LUK","2","26","26","Roho Mhuhu akunhekuli kubha ngayipoteli mangane ja kumbona Kristo, jombi nde Bambo. ");
INSERT INTO mpa_vpl VALUES ("LK2_27","072_2_27","LUK","2","27","27","Bhela Roho Mhuhu akundongwi Simeoni na kujenda mu Nyumba jaka Chapanga. Pala bhabheleka pabhakundetiki mwana Yesu mu Nyumba jaka Chapanga nahuli kunhenge ngati moipalakya na ntetu wa Shelia, ");
INSERT INTO mpa_vpl VALUES ("LK2_28","072_2_28","LUK","2","28","28","Simeoni akanjopali mwana Yesu mu mabhoku ghaki koni akunchengula Chapanga, akapwagha, ");
INSERT INTO mpa_vpl VALUES ("LK2_29","072_2_29","LUK","2","29","29","“Henu Bambo, utimizi chilanga chaku, undekakya mtumika waku apotilaje kwa lukwale, ngati mowapwaghile. ");
INSERT INTO mpa_vpl VALUES ("LK2_30","072_2_30","LUK","2","30","30","Maghambu kwa mihu ghangu ghauweni ukengalelu waku, ");
INSERT INTO mpa_vpl VALUES ("LK2_31","072_2_31","LUK","2","31","31","ghoutendiki ubhonikana kwa bhandu bhokape. ");
INSERT INTO mpa_vpl VALUES ("LK2_32","072_2_32","LUK","2","32","32","Unang'anu ghowamulakya bhandu bha mataifa ghokapi, na kuleta ulumbalilu kwa bhandu bhaku bha Izilaeli.” ");
INSERT INTO mpa_vpl VALUES ("LK2_33","072_2_33","LUK","2","33","33","Yusufu na mabhu waka Yesu bhakabhi bhakangacha malobhi ghokapi ghaakalongi Simeoni panani jaka mwana jola. ");
INSERT INTO mpa_vpl VALUES ("LK2_34","072_2_34","LUK","2","34","34","Panihapa Simeoni akabhapengalili, na kumpwaghi Malia, mabhu waka Yesu, “Mwana jonjoni ahaghuliki na Chapanga kwa ndandi ja kuhabhuka na kujema kwa bhandu bhamaheli bha ku inchi ja ku Izilaeli. Kabheti anaabya nginyulila kuhuma kwaka Chapanga, jejikanakika na bhandu bhamahele, ");
INSERT INTO mpa_vpl VALUES ("LK2_35","072_2_35","LUK","2","35","35","nahuli maholalelu gha bhandu bhamaheli ghiyekulikaje palanga. Na kwaku wamweti, lipanga analijingala muntima waku, nahuli ghayekuliwa maholalelu gha mtima waku.” ");
INSERT INTO mpa_vpl VALUES ("LK2_36","072_2_36","LUK","2","36","36","Kabheti mu Nyumba jaka Chapanga mola kukabhi na mlota waka Chapanga jumu mbujamundu, lihina laki Ana, mwali waka Fanueli, wa likabila laka Asheli. Mbomba hoju akatami na ndomi waki kwa hyaka saba kutumbu paatoghulike. ");
INSERT INTO mpa_vpl VALUES ("LK2_37","072_2_37","LUK","2","37","37","Bhela akabhi mbomba joaweliwi na ndomi waki mbaka machobha ghala paakabhi na hyaka semanini na nne. Na machobha ghokapi hagha atamika mu Nyumba jaka Chapanga, ikilu na muhi akunjojabya Chapanga kwa kukonga na kulobha. ");
INSERT INTO mpa_vpl VALUES ("LK2_38","072_2_38","LUK","2","38","38","Chikahi chechechi, Ana akabhajendili koni akunchengula Chapanga, na kupwagha malobhi panani jaka mwana jola kwa bhandu bhokapi bhabhalendalya ukombola wa Yelusalemu. ");
INSERT INTO mpa_vpl VALUES ("LK2_39","072_2_39","LUK","2","39","39","Henu Malia na Yusufu pabhajomwi kuhenga ghokapi ghaghapalika na Shelia jaka Bambo, bhakakelabwiki kunyumba jabhu ku Nazaleti ku muchi wa ku Galilaya. ");
INSERT INTO mpa_vpl VALUES ("LK2_40","072_2_40","LUK","2","40","40","Mwana akakoliki, akajonjukiki makili akabya atweli malangu, na chihomu chaka Chapanga chakabhi papamu naku. ");
INSERT INTO mpa_vpl VALUES ("LK2_41","072_2_41","LUK","2","41","41","Kila chaka mu Uwangalalu wa Pasaka bhabheleka bhaki bhakabhi na ntetu wa kujenda ku Yelusalemu. ");
INSERT INTO mpa_vpl VALUES ("LK2_42","072_2_42","LUK","2","42","42","Yesu paakabhi na hyaka komi na ibheli, bhakapiti naku ku Uwangalalu ngati mowabheli ntetu. ");
INSERT INTO mpa_vpl VALUES ("LK2_43","072_2_43","LUK","2","43","43","Pawajomwiki Uwangalalu ghola, na bhabheleka pabhabhila bhabhuja kunyumba jabhu, Yesu akahighali kunyuma ku Yelusalemu, koni bhabheleka bhaki ngachebhamanye. ");
INSERT INTO mpa_vpl VALUES ("LK2_44","072_2_44","LUK","2","44","44","Bhahambukya kubha akabhi papamu nabhu mulipogha la bhandu bhabhakabhi mu mwanja ghola, bhakajendiki muhi jokapi. Bhela bhakatumbwi kundonda mwalongu bhaki na mwakochi bhaki. ");
INSERT INTO mpa_vpl VALUES ("LK2_45","072_2_45","LUK","2","45","45","Kwa kubha ngachebhumbweni, bhakakelawiki kabhete ku Yelusalemu nahuli kundonda. ");
INSERT INTO mpa_vpl VALUES ("LK2_46","072_2_46","LUK","2","46","46","Pa lichobha la katatu, bhakunhimani pa Nyumba jaka Chapanga, akabya atami pachilanda ja bhabhola bha Kiyahude, koni abhajowanela na kubhalaluki malalukilu. ");
INSERT INTO mpa_vpl VALUES ("LK2_47","072_2_47","LUK","2","47","47","Bhokapi bhabhajowini malobhi ghaki bhakakangichi kwa malangu na kuyanga kwaki. ");
INSERT INTO mpa_vpl VALUES ("LK2_48","072_2_48","LUK","2","48","48","Malia mabhu waki na Yusufu pabhumbweni bhakakangichi nakanopi, na mabhu waki akundalukili, “Mwanango, bho, maghambu ki utuhengi bhenibhela? Lingalya, nepani na atati waku tukabhi tukulonda kwa kubhina mtima.” ");
INSERT INTO mpa_vpl VALUES ("LK2_49","072_2_49","LUK","2","49","49","Yesu akabhayangiki, “Bho, mnonde kyane? Ngachemmanyi kubha imbalika kubha mu Nyumba ja Atati wangu?” ");
INSERT INTO mpa_vpl VALUES ("LK2_50","072_2_50","LUK","2","50","50","Nambu bhombi ngachebhamanyi ndandi ja lilobhi leakapwaghile. ");
INSERT INTO mpa_vpl VALUES ("LK2_51","072_2_51","LUK","2","51","51","Henu Yesu akakelawiki ku Nazaleti papamu nabhu, akajendalya kubhatii. Amabhu waki akabhekiki mambu ghanihagha ghokapi muntima. ");
INSERT INTO mpa_vpl VALUES ("LK2_52","072_2_52","LUK","2","52","52","Yesu akajendali kukola mu mbulau na ulacho, na kujendalela kunyambiha Chapanga na bhandu. ");
INSERT INTO mpa_vpl VALUES ("LK3_1","072_3_1","LUK","3","1","1","Chaka cha komi na unhwanu cha utawala waka Kaisali Tibelio, Pontio Pilato akabhi chiongozi wa ku Yudea. Helode akabhi nkolongwa wa ku Galilaya, na Filipo ndongu waki akabhi chiongozi wa Itulea na inchi ja Tilakoniti. Lisania akabhi nkolongwa wa ku Abilene. ");
INSERT INTO mpa_vpl VALUES ("LK3_2","072_3_2","LUK","3","2","2","Anasi na Kayafa bhakabhi bhapenganyambiku bhakolongwa, chikahi hechi Lilobhi laka Chapanga lakunhiki Yohana mwana waka Zakalia kuchingwenji kola. ");
INSERT INTO mpa_vpl VALUES ("LK3_3","072_3_3","LUK","3","3","3","Henu Yohana akapiti ku inchi yokapi yeilindakanila na nkoka Yoludani. Akabhatangazi bhandu, “Mng'anambukaje na kughaleka mahoku ghinu na mbatizwaje nahuli Chapanga andekakya mahoku ghinu.” ");
INSERT INTO mpa_vpl VALUES ("LK3_4","072_3_4","LUK","3","4","4","Ngati moilembakike mu chitabhu chaka mlota Isaya, “Mundu ajamali kuchilipololu, ‘Mundenganakya Bambo indela jaki, ndenganakya paanapetaje! ");
INSERT INTO mpa_vpl VALUES ("LK3_5","072_3_5","LUK","3","5","5","Kila likemba lipalika liyelalikaje, kila chitombi na katombi ipalika ilenganakikaje. Papapendiki papalika pahatambuliwaje, indela ihakau ipalika ilenganakikaji na kubha wichu. ");
INSERT INTO mpa_vpl VALUES ("LK3_6","072_3_6","LUK","3","6","6","Bhandu bhokapi anabhubhona ukengalelu waka Chapanga!’ ” ");
INSERT INTO mpa_vpl VALUES ("LK3_7","072_3_7","LUK","3","7","7","Bhela bhandu bhakunjendi Yohana nahuli abhabatizaje, najombi akabhapwaghile, “Mwehapa kibheleku cha lijoka! Bho, nane joandakali mabhanganya ntila utemulu waka Chapanga ghouhika? ");
INSERT INTO mpa_vpl VALUES ("LK3_8","072_3_8","LUK","3","8","8","Ndangia kwa matendu kubha mng'anambwiki na kughaleka mahoku ghinu. Kabheti ngamwitumbu kulonge mu mitima jinu, ‘Atati witu nde Ibulahimu!’ Chakaka numpwaghila, Chapanga aweza kughang'anambu maganga aghagha kubha bhana bhaka Ibulahimu. ");
INSERT INTO mpa_vpl VALUES ("LK3_9","072_3_9","LUK","3","9","9","Bhela, libhaghu libhekakiki wichu punhina wa kila nkongu, kila nkongu wangakubheleka mapambiku manyahi anauhekatwaje na kulekaleka pamoto.” ");
INSERT INTO mpa_vpl VALUES ("LK3_10","072_3_10","LUK","3","10","10","Lipogha la bhandu lakundalukile, “Bho, henu tutenda bhole?” ");
INSERT INTO mpa_vpl VALUES ("LK3_11","072_3_11","LUK","3","11","11","Yohana akabhayangiki, “Mundu joabhi na ingobhu ibheli angabhila jwangakubha na ingobhu, na joabhi na chilebhi angabhila jwanga na chilebhi.” ");
INSERT INTO mpa_vpl VALUES ("LK3_12","072_3_12","LUK","3","12","12","Bhajopa kode bhakahikiki nahuli bhabatizwaje, bhakundalukile, “Mbola, bho, na tepani tuhenga kike?” ");
INSERT INTO mpa_vpl VALUES ("LK3_13","072_3_13","LUK","3","13","13","Jombi akabhapwaghile, “Ngamwijopa kode kupetale mobhundaghalakile.” ");
INSERT INTO mpa_vpl VALUES ("LK3_14","072_3_14","LUK","3","14","14","Manjolinjoli na bhombi bhakundalukile, “Bho, na tepani tuhenga kike?” Jombi akabhayangiki, “Ngamwanyaghu mundu jokapi jola hindu yaki kwa makili, kabheti ngamwantakila mundu jokapi kwa upuhe. Mtoshikaje na malepu ghinu.” ");
INSERT INTO mpa_vpl VALUES ("LK3_15","072_3_15","LUK","3","15","15","Bhandu bhalendalya kuhika kwaka Mkombola. Bhakabhi bhalilalukila mumitima jabhu kubha pangi Yohana nde Kristo. ");
INSERT INTO mpa_vpl VALUES ("LK3_16","072_3_16","LUK","3","16","16","Panihapa Yohana akabhapwaghi bhokape, “Nepani numbatiza mwanganya kwa machi, nambu ahika joabhi na makili kumbeta nenga, na nepani ngachembalika kumbopo mighoji ja maghubasi ghake. Jombi anaambatiza kwa Roho Mhuhu na kwa moto. ");
INSERT INTO mpa_vpl VALUES ("LK3_17","072_3_17","LUK","3","17","17","Jombi abhi na chipalu mumabhoku ghaki, nahuli apeta inganu yaki, abhongana ingano mu chikoku chaki, na mambojwa anaaghajocha kwa moto wangakuchuchuka.” ");
INSERT INTO mpa_vpl VALUES ("LK3_18","072_3_18","LUK","3","18","18","Henu kwa malobhi ghangi ghamaheli Yohana akabhi abhatangazi bhandu Malobhi Manyahi na kubhalakalila bhaileka indela yabhu. ");
INSERT INTO mpa_vpl VALUES ("LK3_19","072_3_19","LUK","3","19","19","Nambu Yohana akundakali Helode Nkolongwa wa ku Galilaya, maghambu akuntowi Helodia, joakabhi nhwanu waka ndongu waki, na mahakau ghangi ghamaheli ghaakabhi aghahengike. ");
INSERT INTO mpa_vpl VALUES ("LK3_20","072_3_20","LUK","3","20","20","Panihapa Helode akajonjukili uhakau waki, kwa kumbeka Yohana muchifungo. ");
INSERT INTO mpa_vpl VALUES ("LK3_21","072_3_21","LUK","3","21","21","Bhandu bhokapi pabhajomula kubatizwa, Yesu najombi akabatizwi. Paakabhi andobha Chapanga, kunani kumahunde kukahowiki, ");
INSERT INTO mpa_vpl VALUES ("LK3_22","072_3_22","LUK","3","22","22","na Roho Mhuhu akanhelali panani jaki kwa ulenganesu ngati wa ngunda. Sauti jakajowaniki kuhuma kunani kumahunde jakapwagha, “Wenga wa Mwanangu wenukupaliki. Nenga nyambakiki na wenga.” ");
INSERT INTO mpa_vpl VALUES ("LK3_23","072_3_23","LUK","3","23","23","Yesu paakabhili atumbula lihengu laki akabhi na umuli wa hyaka selasini, na bhandu bhahambukya mwana waka Yusufu, joakabhi mwana waka Heli. ");
INSERT INTO mpa_vpl VALUES ("LK3_24","072_3_24","LUK","3","24","24","Heli akabhi mwana waka Masati, joakabhi mwana waka Lawi, Lawi akabhi mwana waka Meliki, Meliki akabhi mwana waka Yana, Yana akabhi mwana waka Yusufu. ");
INSERT INTO mpa_vpl VALUES ("LK3_25","072_3_25","LUK","3","25","25","Yusufu akabhi mwana waka Matasia, Matasia akabhi mwana waka Amosi, Amosi akabhi mwana waka Nahumu, Nahumu akabhi mwana waka Esili, Esili akabhi mwana waka Nagai. ");
INSERT INTO mpa_vpl VALUES ("LK3_26","072_3_26","LUK","3","26","26","Nagai akabhi mwana waka Maati, Maati akabhi mwana waka Matatia, Matatia akabhi mwana waka Semeni, Semeni akabhi mwana waka Yoseki, Yoseki akabhi mwana waka Yuda. ");
INSERT INTO mpa_vpl VALUES ("LK3_27","072_3_27","LUK","3","27","27","Yuda akabhi mwana waka Yoanani, Yoanani akabhi mwana waka Lesa, Lesa akabhi mwana waka Zelubabeli, Zelubabeli akabhi mwana waka Shealitieli, Shealitieli akabhi mwana waka Neli. ");
INSERT INTO mpa_vpl VALUES ("LK3_28","072_3_28","LUK","3","28","28","Neli akabhi mwana waka Meliki, Meliki akabhi mwana waka Adi, Adi akabhi mwana waka Kosamu, Kosamu akabhi mwana waka Elimadamu, Elimadamu akabhi mwana waka Eli. ");
INSERT INTO mpa_vpl VALUES ("LK3_29","072_3_29","LUK","3","29","29","Eli akabhi mwana waka Yoshua, Yoshua akabhi mwana waka Eliezeli, Eliezeli akabhi mwana waka Yolimu, Yolimu akabhi mwana waka Masati, Matati akabhi mwana waka Lawi. ");
INSERT INTO mpa_vpl VALUES ("LK3_30","072_3_30","LUK","3","30","30","Lawi akabhi mwana waka Simoni, Simoni akabhi mwana waka Yuda, Yuda akabhi mwana waka Yusufu, Yusufu akabhi mwana waka Yonamu, Yonamu akabhi mwana waka Eliakimu. ");
INSERT INTO mpa_vpl VALUES ("LK3_31","072_3_31","LUK","3","31","31","Eliakimu akabhi mwana waka Melea, Melea akabhi mwana waka Mena, Mena akabhi mwana waka Matata, Matata akabhi mwana waka Nasani, Nasani akabhi mwana waka Daude. ");
INSERT INTO mpa_vpl VALUES ("LK3_32","072_3_32","LUK","3","32","32","Daude akabhi mwana waka Yese, Yese akabhi mwana waka Obedi, Obedi akabhi mwana waka Boazi, Boazi akabhi mwana waka Solomoni, Solomoni akabhi mwana waka Nashoni. ");
INSERT INTO mpa_vpl VALUES ("LK3_33","072_3_33","LUK","3","33","33","Nashoni akabhi mwana waka Aminadabu, Aminadabu akabhi mwana waka Adimini, Adimini akabhi mwana waka Hesiloni, Hesiloni akabhi mwana waka Pelesi, Pelesi akabhi mwana waka Yuda. ");
INSERT INTO mpa_vpl VALUES ("LK3_34","072_3_34","LUK","3","34","34","Yuda akabhi mwana waka Yakobo, Yakobo akabhi mwana waka Isaka, Isaka akabhi mwana waka Ibulahimu, Ibulahimu akabhi mwana waka Tela, Tela akabhi mwana waka Naholi. ");
INSERT INTO mpa_vpl VALUES ("LK3_35","072_3_35","LUK","3","35","35","Naholi akabhi mwana waka Selugi, Selugi akabhi mwana waka Leu, Leu akabhi mwana waka Pelegi, Pelegi akabhi mwana waka Ebeli, Ebeli akabhi mwana waka Sala, ");
INSERT INTO mpa_vpl VALUES ("LK3_36","072_3_36","LUK","3","36","36","Sala akabhi mwana waka Kenani, Kenani akabhi mwana waka Alifakisadi, Alifakisadi akabhi mwana waka Shemu, Shemu akabhi mwana waka Nuhu, Noha akabhi mwana waka Lameki. ");
INSERT INTO mpa_vpl VALUES ("LK3_37","072_3_37","LUK","3","37","37","Lameki akabhi mwana waka Metusela, Metusela akabhi mwana waka Enoki, Enoki akabhi mwana waka Yaledi, Yaledi akabhi mwana waka Mahalaleli, Mahalaleli akabhi mwana waka Kenani. ");
INSERT INTO mpa_vpl VALUES ("LK3_38","072_3_38","LUK","3","38","38","Kenani akabhi mwana waka Enoshi, Enoshi akabhi mwana waka Seti, Seti akabhi mwana waka Adamu, Adamu akabhi mwana waka Chapanga. ");
INSERT INTO mpa_vpl VALUES ("LK4_1","072_4_1","LUK","4","1","1","Yesu akakelawiki kuhuma ku Nkoka Yoludani koni atweli Roho Mhuhu, na Roho hoju akundongwi mbaka kulipololu. ");
INSERT INTO mpa_vpl VALUES ("LK4_2","072_4_2","LUK","4","2","2","Konihoku akalengakiki na Shetani kwa machobha alobaini. Mu machobha ghokapi hagha ngacheakakuliki chindu chokapi, na paghapetiki machobha ghanihagha akaweni injala. ");
INSERT INTO mpa_vpl VALUES ("LK4_3","072_4_3","LUK","4","3","3","Shetani akampwaghi Yesu, “Ngati wehapa nde wa Mwana waka Chapanga, lipwaghila lighanga aleli libya libumunda.” ");
INSERT INTO mpa_vpl VALUES ("LK4_4","072_4_4","LUK","4","4","4","Nambu Yesu akayangiki, “Ilembakiki mu Malembu Mahuhu, ‘Mundu ngacheatama kwa kula libumunda pena, nambu kwa kila Lilobhi laka Chapanga.’ ” ");
INSERT INTO mpa_vpl VALUES ("LK4_5","072_4_5","LUK","4","5","5","Palapala Shetani akundongwi Yesu mbaka panani ja chitombi chilachu, na kwa chikahi chijipi akandangi ukolongwa wokapi wa pundema pokapi. ");
INSERT INTO mpa_vpl VALUES ("LK4_6","072_4_6","LUK","4","6","6","Shetani akumpwaghile, “Ananukupekya ukolongwa wokapi na ulumbalilu waki wokapi, maghambu yokapi heyi mbekiwi nepani, na nepani nhweza kumpeke mundu jonumpala. ");
INSERT INTO mpa_vpl VALUES ("LK4_7","072_4_7","LUK","4","7","7","Bhela anaunjikamili na kunyojabhela, yokapi ananukupekyaje wehapa.” ");
INSERT INTO mpa_vpl VALUES ("LK4_8","072_4_8","LUK","4","8","8","Yesu akayangiki, “Ilembakiki mu Malembu Mahuhu, ‘Unjojabya Bambo Chapanga waku na untumakya jombi kanjika jaki!’ ” ");
INSERT INTO mpa_vpl VALUES ("LK4_9","072_4_9","LUK","4","9","9","Kabheti Shetani akundongwi Yesu mbaka ku Yelusalemu, akumbei kunani kunhaghala wa Nyumba jaka Chapanga, na kumpwaghila, “Ngati wehapa nde wa Mwana waka Chapanga, ulilekala pahi kuhuma pambane. ");
INSERT INTO mpa_vpl VALUES ("LK4_10","072_4_10","LUK","4","10","10","Maghambu ilembakiki mu Malembu Mahuhu, ‘Chapanga anaakulaghalakya bhatumika bhaki bha kunani kumahunde bhakulendaje. ");
INSERT INTO mpa_vpl VALUES ("LK4_11","072_4_11","LUK","4","11","11","Bhombi anabhukutola mumabhoku ghabhu nahuli ngawalikobhandola chiwolu chaku paliganga.’ ” ");
INSERT INTO mpa_vpl VALUES ("LK4_12","072_4_12","LUK","4","12","12","Nambu Yesu akayangike, “Ilembakiki mu Malembu Mahuhu, ‘Ngawandenga Bambo Chapanga waku.’ ” ");
INSERT INTO mpa_vpl VALUES ("LK4_13","072_4_13","LUK","4","13","13","Shetani paajomula kundenga Yesu kwa indela yokapi, akundekiki kwa chikahi. ");
INSERT INTO mpa_vpl VALUES ("LK4_14","072_4_14","LUK","4","14","14","Bhela Yesu akakelawiki kujenda ku Galilaya akabya atwelili makili ghaka Roho Mhuhu. Na malobhi ghaki ghakayaghani pandu pokapi pa inchi ya pambipi. ");
INSERT INTO mpa_vpl VALUES ("LK4_15","072_4_15","LUK","4","15","15","Yesu akabhi abhola mu nyumba yabhu ya kuhimangani Bhayahude na bhandu bhokapi bhakundumbalile. ");
INSERT INTO mpa_vpl VALUES ("LK4_16","072_4_16","LUK","4","16","16","Henu Yesu akapiti ku Nazaleti, pandu paakakolile, na Lichobha la Sabato akapiti mu nyumba ja kuhimangani Bhayaude ngati mowabheli ntetu waki. Akajemiki na kusoma Malembu Mahuhu kwa saute. ");
INSERT INTO mpa_vpl VALUES ("LK4_17","072_4_17","LUK","4","17","17","Bhakumpeki chitabu chaka mlota Isaya, akakibhopwili na kupahimani pandu papalembakiki, ");
INSERT INTO mpa_vpl VALUES ("LK4_18","072_4_18","LUK","4","18","18","“Roho waka Bambo abhi panani jangu, maghambu anjawi nabhatangazya bhahochu Malobhi Manyahi. Andumiki kubhatangazi bhabhakongakiki kubhopulewa kwabhu na akangalola kulola kabhete kubhalekakela bhandu bhabhabhonewa. ");
INSERT INTO mpa_vpl VALUES ("LK4_19","072_4_19","LUK","4","19","19","Kutangaza kubha machobha ghahikiki ghaka Bambo kubhakengalela bhandu bhaki.” ");
INSERT INTO mpa_vpl VALUES ("LK4_20","072_4_20","LUK","4","20","20","Yesu paakajomwi kusoma, akakikongiki chitabu chela, akankelabhuki mtumika na akatami pahi. Bhandu bhokapi bhabhabhi mu nyumba ja kuhimangani Bhayahude bhakundingali nakanopi. ");
INSERT INTO mpa_vpl VALUES ("LK4_21","072_4_21","LUK","4","21","21","Yesu akabhapwaghile, “Lilembu lendenu lipitali kubha chakaka lalenu pamukabhi njowanela.” ");
INSERT INTO mpa_vpl VALUES ("LK4_22","072_4_22","LUK","4","22","22","Bhandu bhokapi bhakundandili na kukangacha malobhi gha chihomu ghaakalongile. Bhakalaluwine, “Bho, hojo le nga mwana waka Yusufu?” ");
INSERT INTO mpa_vpl VALUES ("LK4_23","072_4_23","LUK","4","23","23","Yesu akabhapwaghile, “Manyi muweza kumbwaghi lilobhi lendenu, ‘Sing'anga, ulilamiha wamwene!’ Na kabheti muweza kumbwaghila, ‘Mambu ghokapi ghatujowini kubha ukaghahengiki ku Kapelenaumu, ughahenga bhelabhela na pani pa muchi waku.’ ” ");
INSERT INTO mpa_vpl VALUES ("LK4_24","072_4_24","LUK","4","24","24","Yesu akajendali kupwagha, “Chakaka numpwaghila, njeta mlota joajetakalewa pa muchi waki mweni.” ");
INSERT INTO mpa_vpl VALUES ("LK4_25","072_4_25","LUK","4","25","25","“Nambu nyowanyaje! Chakaka nupwaghila kukabhi na akambomba bhabhaweliwi na bhalomi bhamaheli ku inchi ja Izilaeli chikahi chaka mlota Eliya. Machobha ghanihagha iyula ngachejatonyike kwa hyaka hitatu na myehi sita, kukabhi na injala ngolongwa ku inchi jokape. ");
INSERT INTO mpa_vpl VALUES ("LK4_26","072_4_26","LUK","4","26","26","Hata bhela, Eliya ngacheatumakiki hata kwaka jumu wabhu ku Izilaeli, nambu akatumakiki ku Salepata kwaka mabhu jumu joaweliwi na ndomi, ku inchi ja ku Sidoni. ");
INSERT INTO mpa_vpl VALUES ("LK4_27","072_4_27","LUK","4","27","27","Kabheti, mu machobha ghaka mlota Elisha, kukabhi na bhandu bhamahele bhabhabhi na chitamu cha malohi ku Izilaeli. Nga mundu joakalamiki, nambu Naamani kanjika mundu wa ku inchi ja ku Silia.” ");
INSERT INTO mpa_vpl VALUES ("LK4_28","072_4_28","LUK","4","28","28","Bhandu bhokapi bhabhabhi mu nyumba ja kuhimangani Bhayahude mola pabhajowini malobhi ghanihagha, bhakahakali namaa. ");
INSERT INTO mpa_vpl VALUES ("LK4_29","072_4_29","LUK","4","29","29","Bhakajemanile, bhakumpihiki Yesu kunja ja muchi kwa makili, na bhakumpeliki ku chitombi kunani pandu pabhachengiki muchi wabhu. Bhakapaliki bhundekala pahi kulikemba lilachu, ");
INSERT INTO mpa_vpl VALUES ("LK4_30","072_4_30","LUK","4","30","30","nambu Yesu akapetiki palapala pachilanda ja lipogha, na kubhoka. ");
INSERT INTO mpa_vpl VALUES ("LK4_31","072_4_31","LUK","4","31","31","Bhela Yesu akaheli ku Kapelenaumu, muchi wa ku Galilaya. Na Lichobha la Sabato akabhi abhabhola bhandu. ");
INSERT INTO mpa_vpl VALUES ("LK4_32","072_4_32","LUK","4","32","32","Bhakakangichi namaa kwa mabholu ghaki, maghambu mabholu ghaki ghakabhi na makili. ");
INSERT INTO mpa_vpl VALUES ("LK4_33","072_4_33","LUK","4","33","33","Mu nyumba ja kuhimangani Bhayahude, kukabhi na mundu joabhi na majobhi, akajamalili, akapwagha, ");
INSERT INTO mpa_vpl VALUES ("LK4_34","072_4_34","LUK","4","34","34","“Bho, upala kututenda kiki, wa Yesu wa ku Nazaleti? Bho, uhikiki kutukoma? Nukumanyi kubha wehapa nde wa Mhuhu waka Chapanga!” ");
INSERT INTO mpa_vpl VALUES ("LK4_35","072_4_35","LUK","4","35","35","Yesu akandakali lijobhi jola, akapwagha, “Tumbalaje! Umpita mundu hoju!” Palapala lijobhi jola akunhawi mundu jola pahi palongi jabhu bhokapi, na kumpita panga kumpoteka. ");
INSERT INTO mpa_vpl VALUES ("LK4_36","072_4_36","LUK","4","36","36","Bhandu bhokapi bhakakangichi namaa, bhakabhi bhapwaghanila, “Bho, aghagha henu mabholu bhole? Maghambu mundu joni abhi na uwezu na makili wa kughatopo majobhi, na ghombi ghabhoka!” ");
INSERT INTO mpa_vpl VALUES ("LK4_37","072_4_37","LUK","4","37","37","Bhela malobhi ghaka Yesu ghakayaghani pandu pokapi pa muchi wa Galilaya. ");
INSERT INTO mpa_vpl VALUES ("LK4_38","072_4_38","LUK","4","38","38","Yesu akapitiki mu nyumba ja kuhimangani Bhayahude jela na kujenda kunyumba jaka Simoni. Henu konihoku akunhimani nkowanu waka Simoni alwala chitamu chikolongwa namaa, bhakundobhiki Yesu andamiha mabhu jola. ");
INSERT INTO mpa_vpl VALUES ("LK4_39","072_4_39","LUK","4","39","39","Yesu akapiti kujema pambipi na mabhu jola, akajinimi na kuchikenjuki chitamu chela. Na chitamu chela chakundekakile. Palapala akajemiki, na kutumbu kubhateleke chilebhe. ");
INSERT INTO mpa_vpl VALUES ("LK4_40","072_4_40","LUK","4","40","40","Lyobha palakabhi lijibhila, bhandu bhakundeti Yesu bhandu bhabhalwalika kila chitamu, najombi akabhabheki mabhoku ghaki panani ja kila mtamwa, na kubhalamiha bhokapi. ");
INSERT INTO mpa_vpl VALUES ("LK4_41","072_4_41","LUK","4","41","41","Majobhi ghakabhapitiki bhandu bhamahele, na kujamalila koni ghakapwagha, “Wehapa wa Mwana waka Chapanga!” Nambu Yesu akaghakenjukili na kughahibhali kupwagha, maghambu ghakummanyi kubha jombi nde Kristo. ");
INSERT INTO mpa_vpl VALUES ("LK4_42","072_4_42","LUK","4","42","42","Chilabhu jaki lukela, Yesu akapitiki kunja ja muchi pandu panga kubha na bhandu. Bhandu bhakatumbwi kundonda, na pabhakumbweni bhakalengiki kunhibhali nahuli ngaibhoka. ");
INSERT INTO mpa_vpl VALUES ("LK4_43","072_4_43","LUK","4","43","43","Nambu Yesu akabhapwaghile, “Imbalika kabheti kutangaza Malobhi Manyahi gha Ukolongwa waka Chapanga ku michi jenge, maghambu chenihechi nde Chapanga cheandumiki kukihenga.” ");
INSERT INTO mpa_vpl VALUES ("LK4_44","072_4_44","LUK","4","44","44","Henu Yesu akajendali kutangaza mu nyumba ya kuhimangani Bhayahude ya ku Yudea. ");
INSERT INTO mpa_vpl VALUES ("LK5_1","072_5_1","LUK","5","1","1","Lichobha limu Yesu akajemiki pamaheku ja Nhwanga wa Genesaleti, na panihapa bhandu bhamaheli bhakatwelile na kutumbu kukangana, koni bhakajowanya Malobhi ghaka Chapanga. ");
INSERT INTO mpa_vpl VALUES ("LK5_2","072_5_2","LUK","5","2","2","Akaiweni ngalawa ibheli mumaheku ja nhwanga, yeyalekakiki na bhalohi habha bhakabhi bhajigholo mikwabhu jabho. ");
INSERT INTO mpa_vpl VALUES ("LK5_3","072_5_3","LUK","5","3","3","Yesu akajingi mu ngalawa jimu jejikabhi jaka Simoni, bhela akandobhiki Simoni akolula ngalawa jela mumachi, patali pachokopi kuhuma pamaheku ja nhwanga. Bhela akatami monimola koni akabya abhabhola lipogha la bhandu. ");
INSERT INTO mpa_vpl VALUES ("LK5_4","072_5_4","LUK","5","4","4","Pajomwi kubhabhola, akampwaghi Simoni, “Uhugha ngalawa mbaka kulochi kokunyoliki na ukapendakya nkwabhu waku nahuli ulobha homba.” ");
INSERT INTO mpa_vpl VALUES ("LK5_5","072_5_5","LUK","5","5","5","Simoni akamuyangike, “Bambo, tutyalini kulobha homba ikilu jokapi panga kupata chindu, nambu kwa kubha upwaghiki wehapa, anambendakya nkwabho.” ");
INSERT INTO mpa_vpl VALUES ("LK5_6","072_5_6","LUK","5","6","6","Pabhakapendaki nkwabhu wabhu, bhakalobhiki homba yamahele nakanope mbaka nkwabhu wabhu utumbuka kukachuka. ");
INSERT INTO mpa_vpl VALUES ("LK5_7","072_5_7","LUK","5","7","7","Bhela bhakabhalohiki bhajabu bhabhakabhi mu ngalawa najengi bhahika kubhajangatila. Bhakahikiki, bhakatwelaki homba ngalawa yokapi ibheli mbaka ipalika kujibhila. ");
INSERT INTO mpa_vpl VALUES ("LK5_8","072_5_8","LUK","5","8","8","Simoni Petulu paaweni chela chechipitalile, akanchikimili Yesu na kupwagha, “Bambo, ubhoka palongi jangu, maghambu nepani nde mundu mwana mahoku!” ");
INSERT INTO mpa_vpl VALUES ("LK5_9","072_5_9","LUK","5","9","9","Simoni papamu na bhajaki bhakakangichi kwa homba yamahele yebhalobhike. ");
INSERT INTO mpa_vpl VALUES ("LK5_10","072_5_10","LUK","5","10","10","Bhelabhela Yakobo na Yohana bhana bhaka Zebedayo, bhabhakabhi bhakochi bhaka Simoni na bhombi bhakakangiche. Yesu akumpwaghi Simoni, “Ngawijoghopa kutumbu sajenu na kujendalela anaubya undohi wa bhandu.” ");
INSERT INTO mpa_vpl VALUES ("LK5_11","072_5_11","LUK","5","11","11","Bhakahughiki ngalawa yela mbaka kumaheku, bhakahilekiki hindu yokapi na kunjengale Yesu. ");
INSERT INTO mpa_vpl VALUES ("LK5_12","072_5_12","LUK","5","12","12","Yesu paakabhi mu muchi ghumu wa Galilaya, akahikiki mundu joabhi na malohi hyegha jokapi. Ntamwa hoju paakambweni Yesu, akalihawi pahi, akalobhiki, “Bambo, ngati anaupala, uweza kung'olola!” ");
INSERT INTO mpa_vpl VALUES ("LK5_13","072_5_13","LUK","5","13","13","Yesu akahatambwi chiwoku chaki, akankamwi na kumpwaghila, “Mbala! Ugholulikaje!” Palapala malohi ghakumbokike. ");
INSERT INTO mpa_vpl VALUES ("LK5_14","072_5_14","LUK","5","14","14","Yesu akunkanakili, akumpwaghile, “Ngawampwaghi mundu jokapi lilobhi lenu, nambu ujenda ukalilangiya kwaka mpenganyambiku kubha ulamiki na ukabhoha nyambiku ngati moalaghalaki Musa, nahuli ubya ulandilu kwa bhandu bhokapi kubha wenga ulamike.” ");
INSERT INTO mpa_vpl VALUES ("LK5_15","072_5_15","LUK","5","15","15","Nambu malobhi panani jaka Yesu ghakajaghani manyata pandu pokapi, na bhandu bhamahele bhakahikiki kunjowanela na bhakapaliki abhalamiha hitamwa yabhu. ");
INSERT INTO mpa_vpl VALUES ("LK5_16","072_5_16","LUK","5","16","16","Nambu Yesu mala pamaheli akapiti pandu panga bhandu, na kundobha Chapanga. ");
INSERT INTO mpa_vpl VALUES ("LK5_17","072_5_17","LUK","5","17","17","Lichobha limu Yesu paakabhi abhola, Mafalisayo bhakumu na bhabhola bha Shelia kuhuma ku kila chijiji cha ku Galilaya, ku Yudea na ku Yelusalemu, bhakabhi bhatemi panihapa. Makili ghaka Bambo ghakabhi papamu naku kwa kubhalamiha bhatamwa. ");
INSERT INTO mpa_vpl VALUES ("LK5_18","072_5_18","LUK","5","18","18","Panihapa bhandu bhakahikiki, bhuntandaini mundu jumu joatengwiki pa uleli, bhakalengiki kunjingia mkati, nahuli bhumbeka palongi jaka Yesu. ");
INSERT INTO mpa_vpl VALUES ("LK5_19","072_5_19","LUK","5","19","19","Nambu, ngachebhaweziki kujingi mkati, kwa ndandi ja bhandu bhamaheli. Bhela bhakuntotwili bhakankwehiki panani ja nhwaghala, bhakapekanywi, na bhakunheli pa uleli mpaka pachilanda ja bhandu bhala palongi jaka Yesu. ");
INSERT INTO mpa_vpl VALUES ("LK5_20","072_5_20","LUK","5","20","20","Yesu paakaweni uhobhalelu wabhu, akumpwaghi mundu joatengwiki, “Nkochi wangu, mahoku ghaku ghalekakiwi.” ");
INSERT INTO mpa_vpl VALUES ("LK5_21","072_5_21","LUK","5","21","21","Bhabola bha Shelia na Mafalisayo bhakatumbwi kulilaluha, “Bho, hajo mundu bholi joantondo Chapanga? Bho, nane joaweza kulekake mahoku? Chapanga kanjika jaki nde joaweza kulekake mahoku!” ");
INSERT INTO mpa_vpl VALUES ("LK5_22","072_5_22","LUK","5","22","22","Yesu akaghamanyi maholalelu ghabhu, akabhalalukile, “Bho, muholale kiki mu mitima jinu? ");
INSERT INTO mpa_vpl VALUES ("LK5_23","072_5_23","LUK","5","23","23","Bho, lelipepwiki nakanopi lako, kupwagha, ‘Ulekakiwi mahoku ghaku,’ au kupwagha, ‘Jemaje na ujendaje?’ ");
INSERT INTO mpa_vpl VALUES ("LK5_24","072_5_24","LUK","5","24","24","Nambu mbala mmanya kubha Mwana waka Mundu abhi na amule pundema ja kulekakela bhandu mahoku ghabhu.” Bhela akampwaghi mundu jola joatengwiki, “Nukupwaghila, jemaje, utola uleli waku, na ujendaje kunyumba jaku.” ");
INSERT INTO mpa_vpl VALUES ("LK5_25","072_5_25","LUK","5","25","25","Palapala, mundu joatengwiki jola akajemiki palongi jabhu, akatoliki uleli waki na kujenda kunyumba jaki koni akabya andumbali Chapanga. ");
INSERT INTO mpa_vpl VALUES ("LK5_26","072_5_26","LUK","5","26","26","Bhandu bhokapi bhakakangichi nakanope. Bhakajowipi na bhakundumbali Chapanga, bhakapwaghaje, “Lalenu tuweni mambu gha ngangachu!” ");
INSERT INTO mpa_vpl VALUES ("LK5_27","072_5_27","LUK","5","27","27","Paghajomwiki ghanihagha, Yesu akapiti kunja akumbweni mundu njopa kode joalowakika Lawi, atami padowoku mu chindamba cha kulepe kode. Yesu akampwaghile, “Unyengalyaje!” ");
INSERT INTO mpa_vpl VALUES ("LK5_28","072_5_28","LUK","5","28","28","Lawi akajemiki, akailekiki hindu yokapi, na akunjengali Yesu. ");
INSERT INTO mpa_vpl VALUES ("LK5_29","072_5_29","LUK","5","29","29","Lawi akantendi Yesu uwangalalu ukolongwa kunyumba jaki, na lipogha likolongwa la bhandu bhajopa kode na bhandu bhangi bhakabhi bhatemi papamu nabhu. ");
INSERT INTO mpa_vpl VALUES ("LK5_30","072_5_30","LUK","5","30","30","Nambu Mafalisayo bhakumu na bhabhola bhangi bha Shelia bhakabhang'ong'ataki bhabhulwa bhaka Yesu, bhakapwaghaje, “Bho, maghambu kiki mkula na kunywa papamu na bhandu bhajopa kode na bhana mahoku?” ");
INSERT INTO mpa_vpl VALUES ("LK5_31","072_5_31","LUK","5","31","31","Yesu akabhayangiki, “Bhandu bhangakulwala ngapabhumpala sing'anga, nambu bhatamwa nde bhabhumpala sing'anga. ");
INSERT INTO mpa_vpl VALUES ("LK5_32","072_5_32","LUK","5","32","32","Ngachenhikiki kubhaloha bhandu bhamboni, nambu nhikiki kubhaloha bhandu bhana mahoku bhapata kung'anambuka na kughaleka mahoku ghabhu.” ");
INSERT INTO mpa_vpl VALUES ("LK5_33","072_5_33","LUK","5","33","33","Bhandu bhangi bhakampwaghile, “Bhabulwa bhaka Yohana Mbatizaji bhakonga kula chilebhi chikahi kwa chikahi na kulobha, na bhabhulwa bha Mafalisayo bhatenda bhelabhela. Nambu bhabhulwa bhaku bhakula na kunywa.” ");
INSERT INTO mpa_vpl VALUES ("LK5_34","072_5_34","LUK","5","34","34","Yesu akabhayangati, “Bho, bhabhakokakiki kuukwati bhapalika le kukonga koni bambo ukwati abhi papamu nabhu? Ngabhela! ");
INSERT INTO mpa_vpl VALUES ("LK5_35","072_5_35","LUK","5","35","35","Nambu lichobha analihikaje bambo ukwati anaabhohakika kwabhu, na panihapa nde pabhikonga kula chilebhe.” ");
INSERT INTO mpa_vpl VALUES ("LK5_36","072_5_36","LUK","5","36","36","Bhela Yesu akabhapwaghi ulenganesu ghongo, “Nga mundu joakachu chilaka kuhuma mu ingobhu jahenu na kuloke mu ingobhu ja mwande. Ngati anatendiki bhenibhela, anaakachula ingobhu jahenu, na chilaka kuhuma mu ingobhu jahenu ngachilengani na ingobhu ja mwande. ");
INSERT INTO mpa_vpl VALUES ("LK5_37","072_5_37","LUK","5","37","37","Kabheti nga mundu joaweza kujeghe divai jahenu mu mifuku jejilenganakiki na chingokolu cha mwande, ngati anaatehi bhenibhela, divai anajikachula mifuku ja chingokolu na kujitika, na mifuku ja chingokolu jitenda kukachuka. ");
INSERT INTO mpa_vpl VALUES ("LK5_38","072_5_38","LUK","5","38","38","Nambu divai jahenu jijeghaleka mu mifuku ja ingokolu jahenu. ");
INSERT INTO mpa_vpl VALUES ("LK5_39","072_5_39","LUK","5","39","39","Nga mundu joakunywa divai jahenu na kutokule kunywa divai ja mwande, maghambu bhapwagha, ‘Jamwandi nde jinyahi.’ ” ");
INSERT INTO mpa_vpl VALUES ("LK6_1","072_6_1","LUK","6","1","1","Lichobha limu la Sabato Yesu akabhi apeta mu mighonda ja ingano. Bhabhulwa bhaki bhakatumbwi kupanyu mapukutu gha ingano, bhakapulwii mu mabhoku ghabhu na kula. ");
INSERT INTO mpa_vpl VALUES ("LK6_2","072_6_2","LUK","6","2","2","Mafalisayo bhakumu bhakabhalalukile, “Bho, maghambu ki muhenga lihengu lebhakanakili kuhenga Lichobha la Sabato?” ");
INSERT INTO mpa_vpl VALUES ("LK6_3","072_6_3","LUK","6","3","3","Yesu akabhayangike, “Bho, ngachemsomiki moakatendi Daude, na bhajaki chikahi pabhakabhi na injala? ");
INSERT INTO mpa_vpl VALUES ("LK6_4","072_6_4","LUK","6","4","4","Daude akajingi mu Nyumba jaka Chapanga, akatoliki mabumunda ghaghabhowakiki kwaka Chapanga akakulike. Bhelabhela akabhapeki na bhajake. Shelia junkanaki mundu jokapi jola kula mabumunda ghanihagha nambu bhapenganyambiku pela nde bhabhapalika kula mabumunda ghanihagha.” ");
INSERT INTO mpa_vpl VALUES ("LK6_5","072_6_5","LUK","6","5","5","Henu Yesu akabhapwaghile, “Mwana waka Mundu nde Bambo wa Sabato.” ");
INSERT INTO mpa_vpl VALUES ("LK6_6","072_6_6","LUK","6","6","6","Mu lichobha lengi la Sabato, Yesu akapiti kubhola mu nyumba ja kuhimangani Bhayahude. Mkati ja nyumba ja kuhingani Bhayahude jela kukabhi na mundu joatengwiki chiwoku cha kumalelelu. ");
INSERT INTO mpa_vpl VALUES ("LK6_7","072_6_7","LUK","6","7","7","Bhabhola bhakumu bha Shelia na Mafalisayo bhakumu bhapalika bhapata ndandi ja kuntaki Yesu na bhela bhalendalya bhabhona ngati anaandamiha mundu mu Lichobha la Sabato. ");
INSERT INTO mpa_vpl VALUES ("LK6_8","072_6_8","LUK","6","8","8","Nambu Yesu akaghamanyiki maholalelu ghabhu, akumpwaghi mundu joatengwiki chiwoku jola, “Ujema, uwika palongi pambane.” Mundu jola akajemiki pachilanda jabhu. ");
INSERT INTO mpa_vpl VALUES ("LK6_9","072_6_9","LUK","6","9","9","Bhela Yesu akabhapwaghile, “Nundaluki mwanganya, bho, wichu le mu Lichobha la Sabato kuhenga manyahi au kuhenga mahakau? Kukengale womi waka mundu au kuukoma?” ");
INSERT INTO mpa_vpl VALUES ("LK6_10","072_6_10","LUK","6","10","10","Akabhalingalili bhandu bhokapi bhabhabhi panipala, na akumpwaghi mundu jola, “Uhatambula chiwoku chaku.” Akatendiki ngati Yesu moakampwaghile na chiwoku chaki chakalamike. ");
INSERT INTO mpa_vpl VALUES ("LK6_11","072_6_11","LUK","6","11","11","Nambu bhombi bhakahakali namaa, bhakajetanganili kubha chindu bhole cheanabhuntendila Yesu. ");
INSERT INTO mpa_vpl VALUES ("LK6_12","072_6_12","LUK","6","12","12","Lichobha limu Yesu akapiti kuchitombi kundobha Chapanga, akatemi konihoku ikilu jokapi koni akundobha Chapanga. ");
INSERT INTO mpa_vpl VALUES ("LK6_13","072_6_13","LUK","6","13","13","Lukela pakwachile, Yesu akabhalohiki bhabhulwa bhaki. Akabhahawi bhabhulwa komi na bhabheli kuhuma pachilanda jabhu, akabhalohiki mitumi. ");
INSERT INTO mpa_vpl VALUES ("LK6_14","072_6_14","LUK","6","14","14","Simoni, Yesu akumpeki lihina la kabheli Petulu, na Andulea ndongu waki, na Yakobo na Yohana na Filipo na Batolomayo. ");
INSERT INTO mpa_vpl VALUES ("LK6_15","072_6_15","LUK","6","15","15","Matayo na Tomaso na Yakobo mwana waka Alufayo na Simoni joalowakika Zelote, ndandi jaki mundu wa kukomanela inchi jaki. ");
INSERT INTO mpa_vpl VALUES ("LK6_16","072_6_16","LUK","6","16","16","Yuda mwana waka Yakobo na Yuda Isikalioti, joang'anambwiki Yesu. ");
INSERT INTO mpa_vpl VALUES ("LK6_17","072_6_17","LUK","6","17","17","Yesu paakaheli kuhuma kuchitombi papamu na mitumi bhaki, akajemiki pandu papakabhili na uwanda. Pandu panihapa pakabhili na lipogha likolongwa la bhabhulwa bhaki na mapogha makolongwa gha bhandu kuhuma ku inchi ja Yudea, ku Yelusalemu na bhabhakahumiki kumaheku ja ipambala yokapi ya michi ja ku Tilo na ku Sidoni. ");
INSERT INTO mpa_vpl VALUES ("LK6_18","072_6_18","LUK","6","18","18","Bhandu habha bhakahikiki kunjowane Yesu na kulamishwa itamwa yabhu. Bhelabhela bhandu bhala bhabhang'ahakika na majobhi bhakahikiki na bhakalamiswe. ");
INSERT INTO mpa_vpl VALUES ("LK6_19","072_6_19","LUK","6","19","19","Bhandu bhokapi bhakapaliki kunkamu Yesu, kwa ndandi makili ghakapitiki mkati jaki na kubhalamiha bhandu bhokapi. ");
INSERT INTO mpa_vpl VALUES ("LK6_20","072_6_20","LUK","6","20","20","Yesu akabhang'anambuki bhabhulwa bhaki na kupwagha, “Mpengaliki mwanganya mwabhahochu, maghambu Ukolongwa waka Chapanga nde winu! ");
INSERT INTO mpa_vpl VALUES ("LK6_21","072_6_21","LUK","6","21","21","Mpengaliki mwanganya mwembi na injala sajeno, maghambu anantupilaje! Mpengaliki mwanganya mwendela sajeno, maghambu anamuhekaje! ");
INSERT INTO mpa_vpl VALUES ("LK6_22","072_6_22","LUK","6","22","22","“Mpengaliki mwehapa ngati bhandu pabhunhakalila, pabhuntenga, pabhuntondola na kumpwaghi mahakau, kwa ndandi jaka Mwana waka Mundu! ");
INSERT INTO mpa_vpl VALUES ("LK6_23","072_6_23","LUK","6","23","23","Muhekalyaji na kukina kwa chiheku paghipitalya ghanihagha, maghambu chakaka nhupu winu nde ukolongwa kunani kumahunde. Kwa ndandi bhenibhela nde bhazee bhabhu mobhakabhatendi bhalota bhaka Chapanga. ");
INSERT INTO mpa_vpl VALUES ("LK6_24","072_6_24","LUK","6","24","24","Nambu anamuchibhonaje mwembi na hindu yamaheli, maghambu njomwi kupata chiheku chinu! ");
INSERT INTO mpa_vpl VALUES ("LK6_25","072_6_25","LUK","6","25","25","Anamuchibhonaje mwentupi sajenu, maghambu mwibhona injala! Anamuchibhonaje mwemuheka sajenu, maghambu anamuombulizaje na kulela! ");
INSERT INTO mpa_vpl VALUES ("LK6_26","072_6_26","LUK","6","26","26","“Anamuchibhonaje mwenga mwebhundumbali bhandu, maghambu bhazee bhabhu bhakabhahengi bhalota bha icholi bhelabhela. ");
INSERT INTO mpa_vpl VALUES ("LK6_27","072_6_27","LUK","6","27","27","“Nambu numpwaghi mwanganya mwenyowanela, mwapala maadui bhinu, mubhahengila manyahi bhabhunhakalila. ");
INSERT INTO mpa_vpl VALUES ("LK6_28","072_6_28","LUK","6","28","28","Mwapengalya bhala bhabhumpeke masolo, mwalobhila bhandu bhabhunhenge mahakau. ");
INSERT INTO mpa_vpl VALUES ("LK6_29","072_6_29","LUK","6","29","29","Ngati mundu anaakulapwi litukwa lakumu ung'anambulya na la kabheli. Na ngati mundu anakunyawili likoti laku undekila kabheti na lishati laku. ");
INSERT INTO mpa_vpl VALUES ("LK6_30","072_6_30","LUK","6","30","30","Ngati mundu anakujopiki chindu umpekyaje, na ngati mundu jokapi anaakunyawi hindu yaku, ngawanjopa akukelabhukyaje. ");
INSERT INTO mpa_vpl VALUES ("LK6_31","072_6_31","LUK","6","31","31","Mwabhahengila bhandu bhangi chela chempala mwehapa bhunhengilaje. ");
INSERT INTO mpa_vpl VALUES ("LK6_32","072_6_32","LUK","6","32","32","“Ngati anamwapaliki pela bhabhumpala, bho, anampata nyonjeka bhole? Njeta! Maghambu hata bhandu bhana mahoku bhelabhela bhabhapala bhandu bhala bhabhapala. ");
INSERT INTO mpa_vpl VALUES ("LK6_33","072_6_33","LUK","6","33","33","Kabheti ngati anamwahengi manyahi bhala pela bhabhunhenge manyahi mwehapa, bho, anampata nyonjeka bhole? Maghambu hata bhana mahoku bhatenda bhelabhela! ");
INSERT INTO mpa_vpl VALUES ("LK6_34","072_6_34","LUK","6","34","34","Ngati anamwajahika pela bhala bhamuhobhalela anabhundepaje, bho, anandangiha chiha bhole? Bhelabhela hata bhana mahoku bhabhajahika bhana mahoku bhajabhu, nahuli bhabhakelabhukya nyonjeka jelajela. ");
INSERT INTO mpa_vpl VALUES ("LK6_35","072_6_35","LUK","6","35","35","Nambu mwanganya mwapala maadui bhino, na mwahengila manyahi, na mwajahika, panga na kuhobhalela kunkelabhukila. Panihapa nhupu winu anaubya ukolongwa, na mwibya mwabhana bhaka Chapanga joabhi Kunani Nakanopi. Maghambu jombi nde wamboni kwa bhokapi bhanga na uchengulu na bhahakau. ");
INSERT INTO mpa_vpl VALUES ("LK6_36","072_6_36","LUK","6","36","36","Mbya na chiha, ngati Atati winu moabheli na chiha. ");
INSERT INTO mpa_vpl VALUES ("LK6_37","072_6_37","LUK","6","37","37","“Ngamwatemu bhandu bhange, na Chapanga ngaantemuli mwenga. Ngamwalaumu bhandu bhange, na Chapanga ngaandaumu mwenga. Mwabhalekakya bhandu bhange, na Chapanga anaandekakya mwenga. ");
INSERT INTO mpa_vpl VALUES ("LK6_38","072_6_38","LUK","6","38","38","Mwapekya bhandu bhange hindu, na Chapanga anaampekya mwenga. Nanamu mwijopalya mumabhoku ghinu chipemu chechitweli mbaka kujitika. Maghambu chipemu chentumi kubhapeme bhandu bhange, Chapanga anaatumila chipemu chocho kumpeme mwenga.” ");
INSERT INTO mpa_vpl VALUES ("LK6_39","072_6_39","LUK","6","39","39","Kabheti Yesu akabhapwaghi ulenganesu ghongo, “Bho, ngalola aweza le kundongo ngalola njake? Bho, bhokapi bhabheli le ngabhijibhi mulibhomba? ");
INSERT INTO mpa_vpl VALUES ("LK6_40","072_6_40","LUK","6","40","40","Nga mbulwa joampeta mbola waki, numbu kila mbulwa anajomwi mabholu ghaki, anakubha ngati mbola waki. ");
INSERT INTO mpa_vpl VALUES ("LK6_41","072_6_41","LUK","6","41","41","“Bho, maghambu kiki ulolake likanju lelibhi mu lihu laka ndongu wako, nambu ngacheubhona luboliti lolubhi mu lihu lako? ");
INSERT INTO mpa_vpl VALUES ("LK6_42","072_6_42","LUK","6","42","42","Bho, uweza bholi kumpwaghi ndongu waku, ‘Ndongu wango, lendalya nukubhoa likanju lelibhi mu lihu lako,’ na koni ngacheubhona luboliti lolubhi mu lihu laku wamwene? Wenga wandumila kubhele! Utumbula hoti kubhoha luboliti lolubhi mu lihu laku, na panihapa nde wibhona wichu na wiweza kubhoha likanju lelibhili mlihu laka ndongu wako. ");
INSERT INTO mpa_vpl VALUES ("LK6_43","072_6_43","LUK","6","43","43","“Nkongu unyahi ngacheupambika mapambiku mahakau, bhelabhela njeta nkongu uhakau ghoupambika mapambiku manyahi. ");
INSERT INTO mpa_vpl VALUES ("LK6_44","072_6_44","LUK","6","44","44","Ndandi kila nkongu umanyikana kwa mapambiku ghaki ghaghapambika. Ndandi bhandu ngachebhatongola mapambiku gha nkongu ghoulowakeka mtini kuhuma mu miha, wala zabibu kuhuma mu mingwando. ");
INSERT INTO mpa_vpl VALUES ("LK6_45","072_6_45","LUK","6","45","45","Mundu mnyahi alongela malobhi manyahi kuhuma mu chikoku cha mtima wake, na mundu muhakau alonge malobhi mahakau kuhuma mu chikoku cha mtima wake. Maghambu mundu ulonge mambu ghala ghaghatweli mkati ja mtima wake. ");
INSERT INTO mpa_vpl VALUES ("LK6_46","072_6_46","LUK","6","46","46","“Bho, maghambu kiki munoha, ‘Bambo, Bambo,’ na koni ngachemughahenga ghala ghanumpwaghi mughahengaje? ");
INSERT INTO mpa_vpl VALUES ("LK6_47","072_6_47","LUK","6","47","47","Ananundangia ulenganesu waka mundu joanyengalela, joajowanela malobhi ghangu na kughakamula. ");
INSERT INTO mpa_vpl VALUES ("LK6_48","072_6_48","LUK","6","48","48","Jombi alenganeswa na mundu joachenga nyumba, joakemba luhuli pa liganga, na kuchenga nyumba heji panihapa. Iyula ngolongwa pajakatonyiki mafuliku ghakajilapwi nyumba jela, nambu ngacheghaweziki kujinyuha, maghambu jikachengakiki wichu. ");
INSERT INTO mpa_vpl VALUES ("LK6_49","072_6_49","LUK","6","49","49","Nambu joajowanela malobhi ghangu panga na kughakamula, alenganeswa na mundu joachengiki nyumba panani ja luhombi na panga na kukemba luhuli. Iyula ngolongwa pajakatonyiki mafuliku ghakajilapwili nyumba jela, na punkamu jakahawiki na kubhombukana nakanopi!” ");
INSERT INTO mpa_vpl VALUES ("LK7_1","072_7_1","LUK","7","1","1","Yesu paakajomwili kulonge mambu ghanihagha kwa bhandu, akapiti ku Kapelenaumu. ");
INSERT INTO mpa_vpl VALUES ("LK7_2","072_7_2","LUK","7","2","2","Konihoku kukabhi na nkolongwa jumu wa manjolinjoli mia moja wa ku Loma, joakabhi na mtumika waki joakampaliki namaa. Mtumika hoju atendika kulwala pambipi na kupotela. ");
INSERT INTO mpa_vpl VALUES ("LK7_3","072_7_3","LUK","7","3","3","Nkolongwa hoju paakajowini malobhi panani jaka Yesu, akabhatumiki bhazee bhakumu Bhayahude bhajenda bhakundobha Yesu ahika andamiha mtumika waki. ");
INSERT INTO mpa_vpl VALUES ("LK7_4","072_7_4","LUK","7","4","4","Pabhahikiki kwaka Yesu, bhakumpembali namaa, bhakapwaghiki, “Unjangatya mundu ajoju, ");
INSERT INTO mpa_vpl VALUES ("LK7_5","072_7_5","LUK","7","5","5","maghambu abhapala bhandu bha inchi jitu, na nde joatuchengi nyumba ja kuhimangani Bhayahude.” ");
INSERT INTO mpa_vpl VALUES ("LK7_6","072_7_6","LUK","7","6","6","Bhela, Yesu akapiti papamu nabhu. Paakaheghali kuhika pa nyumba jaka nkolongwa hoju, nkolongwa hoju akabhatumiki bhakochi bhaki bhumpwaghila Yesu, “Bambo, ngawaling'aha kuhika kone. Ndandi nenga ngachembalika kukujopale wenga ujingala mu nyumba jangu. ");
INSERT INTO mpa_vpl VALUES ("LK7_7","072_7_7","LUK","7","7","7","Nde ndandi nilibhoniki ngachembalika kuhika kwako. Henu ulongila pe lilobhi, na mtumika wangu anaalamaje. ");
INSERT INTO mpa_vpl VALUES ("LK7_8","072_7_8","LUK","7","8","8","Ndandi nepani nanatu nde na mundu nemi pahi ja ujemelelu wa bhakolongwa, na mi na manjolinjoli pahi jangu. Numpwaghi jumu, ‘Ujendaje!’ Na jombi ajenda, na numpwaghi jongi, ‘Uhika!’ Na jombi ahika. Na ananumpwaghi mtumika wangu, ‘Uhenga anana!’ Na jombi ahenga.” ");
INSERT INTO mpa_vpl VALUES ("LK7_9","072_7_9","LUK","7","9","9","Yesu paakajowini malobhi ghanihagha, akakangichi namaa, na akaling'anambuki lipogha la bhandu lelabhi lunjengalela na kupwagha, “Chakaka numpwaghila ngachenabhali kumbona mundu joabhi na uhobhalelu ngati ghongone, njeta hata ku Izilaeli!” ");
INSERT INTO mpa_vpl VALUES ("LK7_10","072_7_10","LUK","7","10","10","Bhela bhandu bhala pabhahikiki kunyumba jaka Nkolongwa wa ku Loma jola bhakumketanili mtumika jola alamike. ");
INSERT INTO mpa_vpl VALUES ("LK7_11","072_7_11","LUK","7","11","11","Palongi pachokopi, Yesu akapiti ku muchi ghoulowakeka Naini papamu na bhabhulwa bhaki, koni akalongana na lipogha la bhandu. ");
INSERT INTO mpa_vpl VALUES ("LK7_12","072_7_12","LUK","7","12","12","Henu, paakabhi aheghale ndyangu ukolongwa wa muchi, bhakapitali bhandu bhabhatowi ntuwi waka nkombu jumu, mwana kanjika waka mabhu joaweliwi na ndomi. Bhandu bhamaheli bha muchi ghola bhakabhi papamu na mabhu jola. ");
INSERT INTO mpa_vpl VALUES ("LK7_13","072_7_13","LUK","7","13","13","Bambo paakambweni mabhu jola, akamboni chiha, na akampwaghi, “Ngawilela.” ");
INSERT INTO mpa_vpl VALUES ("LK7_14","072_7_14","LUK","7","14","14","Bhela, Yesu akapiti palongi na kukamu chitanda, na bhabhatowi chitanda bhakajemiki. Yesu akapwaghiki, “Nkombo! Nukupwaghi ujumukaje!” ");
INSERT INTO mpa_vpl VALUES ("LK7_15","072_7_15","LUK","7","15","15","Nkombu joakapotili jola akajinwiki na kutumbu kulongela, na Yesu akampeki mabhu waki. ");
INSERT INTO mpa_vpl VALUES ("LK7_16","072_7_16","LUK","7","16","16","Bhandu bhokapi bhakatweliwi na choghohi na bhakundumbali Chapanga bhakapwaghaje, “Mlota nkolongwa waka Chapanga apitali kwitu, Chapanga ahikiki kubhakengale bhandu bhake.” ");
INSERT INTO mpa_vpl VALUES ("LK7_17","072_7_17","LUK","7","17","17","Malobhi ghanihagha Yesu ghahengiki ghakajaghani ku ndema wokapi wa ku Yudea na inchi yokapi ya pambipi. ");
INSERT INTO mpa_vpl VALUES ("LK7_18","072_7_18","LUK","7","18","18","Bhabholu bhaka Yohana Mbatizaji bhakampwaghi Yohana mambu ghala ghokapi ghaghapitalile, bhela Yohana akabhakemiki bhabhulwa bhaki bhabheli. ");
INSERT INTO mpa_vpl VALUES ("LK7_19","072_7_19","LUK","7","19","19","Na kubhatuma kwaka Bambo kundalukila, “Bho, wehapa le nde jola joakapwaghiki Yohana ahika, au tundendalya jonge?” ");
INSERT INTO mpa_vpl VALUES ("LK7_20","072_7_20","LUK","7","20","20","Bhandu bhala pabhahikiki kwaka Yesu bhakumpwaghile, “Yohana Mbatizaji atutumiki tukulalukyaje, ‘Bho, wehapa le nde jola joahika au tundendalya jonge?’ ” ");
INSERT INTO mpa_vpl VALUES ("LK7_21","072_7_21","LUK","7","21","21","Chikahi chelachela, Yesu akabhalamihi bhandu bhangi bhamaheli namaa, bhabhakabhi na itamwa na bhabhakamuliki na majobhi, na kubhatenda akangalola kuweza kulola. ");
INSERT INTO mpa_vpl VALUES ("LK7_22","072_7_22","LUK","7","22","22","Yesu akabhayangiki bhabholu bhaka Yohana akapwagha, “Njenda mkumpwaghila ghokapi ghamughaweni na kughajowana, akangalola bhalola, iwete bhajenda, bhabhabhi na malohi banyambiswa, akangajowa bhajowana, bhakuwa bhayohakeka, na Malobhi Manyahi ghatangwazwa kwa bhahochu. ");
INSERT INTO mpa_vpl VALUES ("LK7_23","072_7_23","LUK","7","23","23","Apengaliki mundu jwangakubha na makangachu na nepani!” ");
INSERT INTO mpa_vpl VALUES ("LK7_24","072_7_24","LUK","7","24","24","Bhabholu bhaka Yohana pabhakabhokiki, Yesu akatumbwi kubhapwaghi mapogha gha bhandu panani jaka Yohana, “Bho, mkapiti kulipololu, kulinga kyane? Bho, mpalika kubhona litete lelinyuhakika na mpongo? ");
INSERT INTO mpa_vpl VALUES ("LK7_25","072_7_25","LUK","7","25","25","Ngati ngabhela, bho, henu mkapiti kulinga kyane? Bho mkapiti kumbona mundu joawati ingobhu inyahi? Bhabhawata ingobhu inyahi na kutama matamu gha kulihekeha bheni nakanopi, bhatama mu manyumba gha kikolongwa! ");
INSERT INTO mpa_vpl VALUES ("LK7_26","072_7_26","LUK","7","26","26","Henu mbwaghilaje, bho, mwakapiti kulingali kike? Bho, mkapiti kundinga mlota waka Chapanga? Hena, nambu mumbweni nkolongwa kupeta mlota waka Chapanga. ");
INSERT INTO mpa_vpl VALUES ("LK7_27","072_7_27","LUK","7","27","27","Hajoju nde Yohana joalongaleka mu Malembu Mahuhu, ‘Chapanga akapwaghiki, ananuntuma mbolu wangu akulongulyaje nahuli akulenganakya indela.’ ” ");
INSERT INTO mpa_vpl VALUES ("LK7_28","072_7_28","LUK","7","28","28","Bhela Yesu akabhapwaghile, “Pachilanda ja bhandu bhokapi bhabhabhelakiki na mbomba Yohana Mbatizaji nde nkolongwa. Nambu joabhi nchokuchoku nakanopi mu Ukolongwa waka Chapanga nde nkolongwa kupeta Yohana.” ");
INSERT INTO mpa_vpl VALUES ("LK7_29","072_7_29","LUK","7","29","29","Bhandu bhokapi, papamu na bhajopa kode pabhakajowini ghahihagha bhakajetakili kubha indela jaka Chapanga nde jambone, na bhandu bhanihabha nde bhala bhabhakabatizwi na Yohana. ");
INSERT INTO mpa_vpl VALUES ("LK7_30","072_7_30","LUK","7","30","30","Nambu Mafalisayo na bhabhola bha Shelia bhakakaniki indela jaka Chapanga kwabhu, kwa kukana kubatizwa na Yohana. ");
INSERT INTO mpa_vpl VALUES ("LK7_31","072_7_31","LUK","7","31","31","Yesu akajendali kupwagha, “Bho, ananabhalenganisha bhandu bha kibheleku chenjenu na kike? Bho, bhandu abhabha bhalengana na kike? ");
INSERT INTO mpa_vpl VALUES ("LK7_32","072_7_32","LUK","7","32","32","Bhalengana na bhana bhabhatemi palighulio. Lipogha limu lakabhapwaghila lipogha lengi, ‘Tunhoni filimbe, nambu ngachenkinike! Tujembili nyembu ya maombulezu, nambu ngachendelike!’ ");
INSERT INTO mpa_vpl VALUES ("LK7_33","072_7_33","LUK","7","33","33","Kwa ndandi Yohana Mbatizaji akahikiki, akakongiki kula chilebhi na kunywa divai, nanamu mkapwaghiki, ‘Abhi na majobhi!’ ");
INSERT INTO mpa_vpl VALUES ("LK7_34","072_7_34","LUK","7","34","34","Mwana waka Mundu akahikike, na akulikaji na kunywa, nanamu mkapwaghiki, ‘Mundingalya mundu ajoju! Ndou na ndobhela, nkochi wa bhajopa kode na bhana mahoku!’ ");
INSERT INTO mpa_vpl VALUES ("LK7_35","072_7_35","LUK","7","35","35","Nambu mbulau jaka Chapanga jimanyakini kubha jamboni kwa bhandu bhokapi bhabhajijetakela.” ");
INSERT INTO mpa_vpl VALUES ("LK7_36","072_7_36","LUK","7","36","36","Mfalisayo jumu akankokiki Yesu kula chilebhi cha pakamihi kunyumba jaki. Na Yesu akapiti kunyumba jaka Mfalisayo jola akatamiki na kula chilebhi. ");
INSERT INTO mpa_vpl VALUES ("LK7_37","072_7_37","LUK","7","37","37","Mu muchi ghola kukabhi na mbomba jumu joakabhi na mahoku. Paakajowini kubha Yesu akulika chilebhi mu nyumba jaka Mfalisayo hoju, akaletiki libotolu lelalenganakiki kwa liganga la alabhasta na mkati jaki kukabhi na mahuta gha kunungi wichu. ");
INSERT INTO mpa_vpl VALUES ("LK7_38","072_7_38","LUK","7","38","38","Akahiki kujema pambipi ja magholu ghaka Yesu, akaleliki na maholi ghaki ghakahabhuki pa magholu ghaka Yesu. Mbomba jola akaghahungwi magholu ghaka Yesu kwa majunju ghaki, na kughabusu magholu na kughapaka mahuta gha kunungi wichu. ");
INSERT INTO mpa_vpl VALUES ("LK7_39","072_7_39","LUK","7","39","39","Mfalisayo joakankokiki Yesu paaghaweni ghanighala, akaliholali muntima waki, “Ngati mundu ajoju akabhi chakaka mlota waka Chapanga, akabya amanyi mbomba joankamu ajo wa ntundu bhole, kubha nde mwana mahoku!” ");
INSERT INTO mpa_vpl VALUES ("LK7_40","072_7_40","LUK","7","40","40","Yesu akampwaghi Mfalisayu jola, “Simoni, mili na lilobhi la kukupwaghila.” Simoni akamyangiki, “Ena Mbola, umbwaghilaje.” ");
INSERT INTO mpa_vpl VALUES ("LK7_41","072_7_41","LUK","7","41","41","Yesu akatumbwi kulongela, “Kukabhi na mundu jumu mwana mbija joakabhajahiki bhandu bhabheli mbija, mundu jumu akunjahiki ipandi mia nhwanu ya madini gha feza, na jongi ipandi hamsini ya madini gha feza. ");
INSERT INTO mpa_vpl VALUES ("LK7_42","072_7_42","LUK","7","42","42","Bhokapi bhabheli njeta joakaweziki kukelabhuha mbija, bhela mwana mbija hoju akabhalekakili bhokapi bhabheli. Bho, jwaku panihapa kwa bhabheli habha joanaampala nakanope mwana mbija?” ");
INSERT INTO mpa_vpl VALUES ("LK7_43","072_7_43","LUK","7","43","43","Simoni akayangike, “Nholake kubha mundu jola joalekakiwi mbija yamaheli.” Yesu akumpwaghile, “Uyangiki chakaka.” ");
INSERT INTO mpa_vpl VALUES ("LK7_44","072_7_44","LUK","7","44","44","Panihapa Yesu akung'anambuki mbomba jola, na kumpwaghi Simoni, “Bho, umbona mbomba ajojo? Nyingi munyumba jaku, ngacheumbeki machi gha kugholola magholu ghangu, nambu mbomba ajoju ang'olwi magholu ghangu kwa maholi ghaki na kunhungu kwa majunju ghaki. ");
INSERT INTO mpa_vpl VALUES ("LK7_45","072_7_45","LUK","7","45","45","Ngacheunamukili kwa kunibusu, nambu mbomba ajoju kutumbu paajingala pambani, ngacheakotwiki kunibusu magholu ghangu. ");
INSERT INTO mpa_vpl VALUES ("LK7_46","072_7_46","LUK","7","46","46","Ngacheumbakiki mahuta pamutu jangu, nambu mbomba ajoju ambakiki mahuta gha kunungi wichu mu magholu ghangu. ");
INSERT INTO mpa_vpl VALUES ("LK7_47","072_7_47","LUK","7","47","47","Bhela nukupwaghila, ndandi alekakiwi mahoku ghaki ghamaheli, bhela ambaliki nakanope. Nambu mundu joalekakiwi pachokope, apala pachokope.” ");
INSERT INTO mpa_vpl VALUES ("LK7_48","072_7_48","LUK","7","48","48","Bhela Yesu akumpwaghi mbomba jola, “Ulekakiwi mahoku ghaku.” ");
INSERT INTO mpa_vpl VALUES ("LK7_49","072_7_49","LUK","7","49","49","Nambu bhokapi bhabhabhi papamu naku koni bhakakula chilebhe bhakatumbwi kulaluwana, “Bho, ajo nane joaweza kubhalekake bhandu mahoku?” ");
INSERT INTO mpa_vpl VALUES ("LK7_50","072_7_50","LUK","7","50","50","Nambu Yesu akumpwaghi mbomba jola, “Uhobhalelu waku ukukengalili wenga, ujenda kwa lukwale.” ");
INSERT INTO mpa_vpl VALUES ("LK8_1","072_8_1","LUK","8","1","1","Paghapetiki ghanighala Yesu akapetiki ku michi na mwijije, koni akatangaza Malobhi Manyahi gha Ukolongwa waka Chapanga. Bhabulwa bhaki komi na bhabheli bhakabhi papamu naku, ");
INSERT INTO mpa_vpl VALUES ("LK8_2","072_8_2","LUK","8","2","2","kabhete bhakabhi akambomba bhakumu Yesu bhaakabhohiki majobhi na kubhalamiha itamu. Pachilanda jabhu akabhi Malia Magidalena, joakambohiki majobhi saba, ");
INSERT INTO mpa_vpl VALUES ("LK8_3","072_8_3","LUK","8","3","3","na Yoana nhwanu waka Kuza, mtumika nkolongwa waka Helode, na Susana na akambomba bhangi bhamaheli. Akambomba habha bhakabhohiki hindu yabhu kwa kunjangati Yesu na bhabhulwa bhaki. ");
INSERT INTO mpa_vpl VALUES ("LK8_4","072_8_4","LUK","8","4","4","Bhandu bhakunjendi Yesu kuhuma ku michi jengi jamaheli, na lipogha likolongwa la bhandu palakalibhongini papamu, Yesu akabhapwaghi ulenganesu hagho: ");
INSERT INTO mpa_vpl VALUES ("LK8_5","072_8_5","LUK","8","5","5","“Pakabhi na mpanda jumu joakapiti kukweta imbeju. Paakabhi akweta imbeju mu ngonda waki, yengi ikaawiki mu indela, bhandu bhakahikanyiti na ijuni ikakuliki. ");
INSERT INTO mpa_vpl VALUES ("LK8_6","072_8_6","LUK","8","6","6","Yengi ikaawiki pa luhombi lolwabhi panani ja maganga, na payameliki, ikanyaliki maghambu ngacheyapatiki machi pa luhombi. ");
INSERT INTO mpa_vpl VALUES ("LK8_7","072_8_7","LUK","8","7","7","Imbeju yengi ikaawiki pa mikongu ja miha, na ikakoliki papamu naku na mikongu ja miha ikajihinyiki mimea heji. ");
INSERT INTO mpa_vpl VALUES ("LK8_8","072_8_8","LUK","8","8","8","Imbeju yengi ikaawiki pa luhombi lunyahi, na yombi ikameliki na kupambika mapambiku, kila jimu mia moja.” Na Yesu paakalongi bhenibhela akajamalili na kupwagha, “Mundu joabhi na makutu na ajowanaje!” ");
INSERT INTO mpa_vpl VALUES ("LK8_9","072_8_9","LUK","8","9","9","Bhabulwa bhaki bhakundaluki Yesu, ulenganesu ghongone ndandi jaki kike? ");
INSERT INTO mpa_vpl VALUES ("LK8_10","072_8_10","LUK","8","10","10","Yesu akabhayangiki, “Mwanganya muyekuliwi kumanya sili ja Ukolongwa waka Chapanga, nambu kwa bhandu bhange, nonge nabhu kwa milenganesu, nahuli bhalingaje nambu ngabhibhona, na bhajowanyaje nambu ngabhimanya.” ");
INSERT INTO mpa_vpl VALUES ("LK8_11","072_8_11","LUK","8","11","11","“Jenjenu nde ndandi ja ulenganesu hoghu, imbeju nde lilobhi laka Chapanga. ");
INSERT INTO mpa_vpl VALUES ("LK8_12","072_8_12","LUK","8","12","12","Imbeju yeyaawiki mwindela ilangi bhandu bhala bhabhajowana lilobhi, nambu Shetani ahika na kulibhoha lilobhi lela mu mitima jabhu nahuli ngabhihika kuhobhalela na kukengaleka. ");
INSERT INTO mpa_vpl VALUES ("LK8_13","072_8_13","LUK","8","13","13","Imbeju yeyaawiki pa luhombi lolwabhi pa maganga ilangi bhandu bhala bhabhalijowana lilobhi na kulijopale kwa chiheku, nambu ngachelibhi na mikegha na ngachelajingile mkati nakanopi mu mitima jabhu. Bhalihobhale kwa chikahi chijipi pela, na pabhalengakeka bhuuleka uhobhalelu wabho. ");
INSERT INTO mpa_vpl VALUES ("LK8_14","072_8_14","LUK","8","14","14","Imbeju yeyaawiki pa mikongu ja miha ilangi bhandu bhala bhabhajowana lilobhi laka Chapanga, nambu pabhajendalela bhahinyakika na mang'ahiku, kupala hindu yamaheli na mahakau gha pani pundema, na bhombi ngachebhapambika mapambiku. ");
INSERT INTO mpa_vpl VALUES ("LK8_15","072_8_15","LUK","8","15","15","Imbeju yeyaawiki pa luhombi lunyahi ilangi bhandu bhala bhabhalijowana lilobhi laka Chapanga, na kulijopalela kwa mtima unyahi na kulijengalela, bhanganya habha nde bhandu bhala bhabhalikamulaki lilobhi na kuhinakalila kwamaheli na kuhenga ngati moapali Chapanga. ");
INSERT INTO mpa_vpl VALUES ("LK8_16","072_8_16","LUK","8","16","16","“Nga mundu joapambaki taa na kukupaki chihulu au kujibheka kwihi ku chitanda. Nambu bhajibheka panani ja chinala, nahuli bhandu pabhajingila munyumba bhaubhona unang'anu. ");
INSERT INTO mpa_vpl VALUES ("LK8_17","072_8_17","LUK","8","17","17","“Ndandi chindu chokapi chechihiyakiki chitenda kuyekulika, na chokapi chechikupakiki chimanyikana na kubhekakeka palanga. ");
INSERT INTO mpa_vpl VALUES ("LK8_18","072_8_18","LUK","8","18","18","“Bhela mlilendaje monjowane malobhi, ndandi joabhi na chindu anajonjukiwa nakanope, nambu jwanga na chindu, hata chela chichoku cheaholake abhi nachu anachitolakikaje.” ");
INSERT INTO mpa_vpl VALUES ("LK8_19","072_8_19","LUK","8","19","19","Amabhu waka Yesu na bhalongu bhaka Yesu bhakahikiki kumbona, nambu ngachebhaweziki kunhikila pambipi kwa ndandi ja lipogha la bhandu. ");
INSERT INTO mpa_vpl VALUES ("LK8_20","072_8_20","LUK","8","20","20","Mundu jumu akumpwaghi Yesu, “Amabhu waku na bhalongu bhaku bhajemiki kunja na bhapala kukubhona.” ");
INSERT INTO mpa_vpl VALUES ("LK8_21","072_8_21","LUK","8","21","21","Yesu akabhayangiki bhokapi, “Amabhu wangu na bhalongu bhangu nde bhala bhokapi bhabhalijowana Lilobhi laka Chapanga na kulitii.” ");
INSERT INTO mpa_vpl VALUES ("LK8_22","072_8_22","LUK","8","22","22","Lichobha limu Yesu akajingi mu ngalawa papamu na bhabhulwa bhaki, na akabhapwaghile, “Tumboka tulombuka mbaka kwihi ja nhwanga.” Panihapa bhakatumbwi mwanja. ");
INSERT INTO mpa_vpl VALUES ("LK8_23","072_8_23","LUK","8","23","23","Pabhakabhi bhalomboka kwa ngalawa, Yesu akaghochi lughono. Palapala mbelu ukolongwa ukatumbwi kupogha mu nhwanga, na machi ghakatumbwi kutwelela mu ngalawa, bhokapi bhakabhi pambipi kujibhila. ");
INSERT INTO mpa_vpl VALUES ("LK8_24","072_8_24","LUK","8","24","24","Bhabhulwa bhakunjendi Yesu na kunjumuwa, bhakapwaghaje, “Bambo, Bambo! Tupotela!” Yesu akajumwiki na kuulakalila mpongu na majegha makolongwa, na kukatondiki na kubha wichu. ");
INSERT INTO mpa_vpl VALUES ("LK8_25","072_8_25","LUK","8","25","25","Panihapa Yesu akabhalaluki bhabhulwa bhaki, “Bho, uhobhalelu winu ubhi kwako?” Nambu bhombi bhakakangichi, na kujoghopa koni bhakapwaghanya, “Bho, hajo mundu bhole? Aulakali mpongu na majegha nayombi yuntii!” ");
INSERT INTO mpa_vpl VALUES ("LK8_26","072_8_26","LUK","8","26","26","Yesu na bhabhulwa bhaki bhakajendali na mwanja mbaka ku inchi ja Bhagelasi, jejibhi kwihi ja nhwanga Galilaya. ");
INSERT INTO mpa_vpl VALUES ("LK8_27","072_8_27","LUK","8","27","27","Yesu paakabhi ahuluka mungalawa, akahimangini na mundu jumu joakabhi na majobhi kuhuma kumbwane akunhikile. Kwa chikahi chilachu mundu hoju ajendika panga kuwata ingobhu na ngacheatamika panyumba, nambu atamika kumatengele. ");
INSERT INTO mpa_vpl VALUES ("LK8_28","072_8_28","LUK","8","28","28","Paambweni Yesu, akaleliki na kulilekela pamagholu ghaki, na kujamalila akapwagha, “Yesu, Mwana waka Chapanga Joabhi Kunani Nakanopi! Bho, upala kundenda kyane? Nukulobha, ngawing'aha!” ");
INSERT INTO mpa_vpl VALUES ("LK8_29","072_8_29","LUK","8","29","29","Mundu ajoju akapwaghiki bhenibhela maghambu Yesu akalipwaghi lijobhi lela limbokaje. Lijobhi lela likankamwili mundu jola pamaheli, na hata ngati bhandu bhunkongika mabhoku na magholu kwa minyololu na pengu, nambu ahekata minyololu na pengu na majobhi ghundonguwa kujenda kulipololo. ");
INSERT INTO mpa_vpl VALUES ("LK8_30","072_8_30","LUK","8","30","30","Yesu akundalukile, “Bho, lihina laku wa nane?” Na jombi akamuyangiki, “Lihina langu ‘Lipogha,’ ” maghambu akabhi na majobhi ghamahele. ");
INSERT INTO mpa_vpl VALUES ("LK8_31","072_8_31","LUK","8","31","31","Majobhi ghala ghakumpembali Yesu ngabhapeleka kuwawa. ");
INSERT INTO mpa_vpl VALUES ("LK8_32","072_8_32","LUK","8","32","32","Pandu pala pakabhi na lipogha likolongwa la magholobhi, bhakalimila mwitombi. Bhela majobhi ghakunjopiki Yesu abhajetakalya bhakajingala mu magholobhi, najombi akaghalekiki ghajendaje. ");
INSERT INTO mpa_vpl VALUES ("LK8_33","072_8_33","LUK","8","33","33","Majobhi ghakumpitiki mundu jola na kujingi mu magholobhi. Lipogha lokapi la magholobhi lakaheli pa likemba na kujibhi mu nhwanga, na ghokapi ghakapotile mumachi. ");
INSERT INTO mpa_vpl VALUES ("LK8_34","072_8_34","LUK","8","34","34","Bhadima bhala pabhaliweni lijambu lelapitalili, bhakakembili na kujenda kupwagha mambu ghanihagha kumbwane na kwijije. ");
INSERT INTO mpa_vpl VALUES ("LK8_35","072_8_35","LUK","8","35","35","Bhandu bhakahiki kulinga lelipitalile, na pabhahiki kwaka Yesu, bhakunhimani mundu joghumpitiki majobhi atami pambipi na Yesu, awati ingobhu na malangu ghaki ghunkelabhukile, na bhandu bhokapi bhakajowipe. ");
INSERT INTO mpa_vpl VALUES ("LK8_36","072_8_36","LUK","8","36","36","Bhala bhabhaghaweni ghaghahengakiki bhakabhapwaghi bhandu ntundu mundu jola moakalamile. ");
INSERT INTO mpa_vpl VALUES ("LK8_37","072_8_37","LUK","8","37","37","Bhela bhandu bhokapi bha inchi ja Bhagelasi bhakunjopiki Yesu abhoka kwabhu, maghambu bhakabhi na choghohi namaa. Panihapa Yesu akajingi mu ngalawa na kubhoka. ");
INSERT INTO mpa_vpl VALUES ("LK8_38","072_8_38","LUK","8","38","38","Mundu joghumpitiki majobhi akunjopiki Yesu, “Unyetakya nyenda na wenga.” Nambu Yesu ngacheajetakili kujenda naku, na akumpwaghile, ");
INSERT INTO mpa_vpl VALUES ("LK8_39","072_8_39","LUK","8","39","39","“Ubhuja kunyumba ukabhalandila bhandu mambu ghokapi makolongwa ghaakutendi Chapanga.” Bhela mundu jola akapetiki ku muchi wokapi, akatangaza mambu ghokapi Yesu ghaakantendile. ");
INSERT INTO mpa_vpl VALUES ("LK8_40","072_8_40","LUK","8","40","40","Yesu paakakelawiki upambala ghongi wa nhwanga, lipogha la bhandu bhakunjopali kwa chiheku, maghambu bhokapi bhundendalya jombi. ");
INSERT INTO mpa_vpl VALUES ("LK8_41","072_8_41","LUK","8","41","41","Panihapa akahikiki mundu jumu joalowakika Yailo, joakabhi nkolongwa wa nyumba ja kuhimangani Bhayahude, akahikiki na kulihabhu pambipi ja magholu ghaka Yesu, akundobha ajenda kunyumba jaki, ");
INSERT INTO mpa_vpl VALUES ("LK8_42","072_8_42","LUK","8","42","42","ndandi mwali waki wa kanjika, joakabhi na hyaka komi na ibheli, akabhi pambipi kupotela. Yesu paajendikaje, lipogha la bhandu lakunhinyiki ipambala yokapi. ");
INSERT INTO mpa_vpl VALUES ("LK8_43","072_8_43","LUK","8","43","43","Pa chilanda jabhu kukabhi na mbomba jumu joakang'ahakiki na chitamu cha kupita mwahi kwa hyaka komi na ibheli, papamu na kutumi hindu yaki yokapi kwa akasing'anga, nambu nga jumu joaweziki kundamiha. ");
INSERT INTO mpa_vpl VALUES ("LK8_44","072_8_44","LUK","8","44","44","Mbomba hoju akanjengali Yesu cha kunyuma na kukamu nkungilu wa ingobhu jaki. Palapala chitamu chaki cha kupita mwahi chakalamike. ");
INSERT INTO mpa_vpl VALUES ("LK8_45","072_8_45","LUK","8","45","45","Yesu akalalukile, “Bho, nde nane joangamwile?” Bhandu bhokapi bhakakaniki, Petulu akapwaghike, “Bambo, lipogha la bhandu likuyongalwiti na kukuhinya.” ");
INSERT INTO mpa_vpl VALUES ("LK8_46","072_8_46","LUK","8","46","46","Nambu Yesu akapwaghike, “Kubhi mundu joangamwile, ndandi niliweni makili ghamokite.” ");
INSERT INTO mpa_vpl VALUES ("LK8_47","072_8_47","LUK","8","47","47","Mbomba jola paamanyiti kubha ngaawezi kulihiya, akahikiki koni abhaghaja kwa choghohi na kulileke palongi jaka Yesu. Panihapa akundandi Yesu palongi ja bhandu bhokapi bhabhakabhi panipala ndandi ja kunkamu Yesu na ntundu moawezi kulamishwa palapala. ");
INSERT INTO mpa_vpl VALUES ("LK8_48","072_8_48","LUK","8","48","48","Yesu akumpwaghi mwali jola, “Kamwali, uhobhalelu waku ukulamihe. Ujenda kwa lukwale.” ");
INSERT INTO mpa_vpl VALUES ("LK8_49","072_8_49","LUK","8","49","49","Yesu paakabhi ajendale kupwagha, mbolu akahikiki kuhuma kunyumba jaka Yairo. Na kumpwaghi Yairo, “Mwali waku apotile. Ngawijendale kung'aha Mbola.” ");
INSERT INTO mpa_vpl VALUES ("LK8_50","072_8_50","LUK","8","50","50","Nambu Yesu paakajowini malobhi ghanihagha, akumpwaghi Yairo, “Ngawijoghopa, uhobhalya pela, na mwali waku analamiswaje.” ");
INSERT INTO mpa_vpl VALUES ("LK8_51","072_8_51","LUK","8","51","51","Yesu paakahikiki kunyumba jaka Yairo, ngacheanjetakali mundu jokapi kujingi naku munyumba, nambu Petulu na Yohana na Yakobo na mabhu na atati bhaka mwali joapotili jola. ");
INSERT INTO mpa_vpl VALUES ("LK8_52","072_8_52","LUK","8","52","52","Bhandu bhokapi bhakabhi bhundelela na kuombuleza kwa ndandi ja kupotela kwaka mwana. Nambu Yesu akabhapwaghile, “Ngamwilela, maghambu mwana ngacheapotile, nambu aghochili lughonu pela!” ");
INSERT INTO mpa_vpl VALUES ("LK8_53","072_8_53","LUK","8","53","53","Bhokapi bhakundongimi Yesu, maghambu bhakamanyiki kubha mwali apotile. ");
INSERT INTO mpa_vpl VALUES ("LK8_54","072_8_54","LUK","8","54","54","Nambu Yesu akamkamwi chibhoku na kundoha, “Kamwali, jumukaje!” ");
INSERT INTO mpa_vpl VALUES ("LK8_55","072_8_55","LUK","8","55","55","Mwali joakapotili jola womi waki ukankelabhukile, na palapala akajemiki. Na Yesu akabhalaghalakili bhumpekya mwali chilebhi. ");
INSERT INTO mpa_vpl VALUES ("LK8_56","072_8_56","LUK","8","56","56","Bhabheleka bhaki bhakakangichi namaa, nambu Yesu akabhalaghalaki ngabhumpwaghi mundu ghaghahengakike. ");
INSERT INTO mpa_vpl VALUES ("LK9_1","072_9_1","LUK","9","1","1","Yesu akabhalohiki bhabhulwa bhaki komi na bhabheli, akabhapeki makili na uwezu wa kughatopo majobhi na kulamiha bhatamwa. ");
INSERT INTO mpa_vpl VALUES ("LK9_2","072_9_2","LUK","9","2","2","Bhela akabhatumiki bhajenda kubhatangazi bhandu ubholu wa Ukolongwa waka Chapanga na kubhalamiha bhatamwa. ");
INSERT INTO mpa_vpl VALUES ("LK9_3","072_9_3","LUK","9","3","3","Akapwagha, “Ngamwitogho chindu chokapi chela pa mwanja winu, ngamwitogho nkongochu, wala nkoba, wala chilebhi, wala mbija, wala ingobhu ibhele. ");
INSERT INTO mpa_vpl VALUES ("LK9_4","072_9_4","LUK","9","4","4","Nyumba jokapi jemwijingalaji na kujopalewa, mtamaje monihomu mbaka pamwibhoka mu muchi ghonihoghu. ");
INSERT INTO mpa_vpl VALUES ("LK9_5","072_9_5","LUK","9","5","5","Ana ngati bhandu bhikana kunjopalela, mboka muchi ghonihoghu na nkung'undaje luhombi mu magholu ghinu ngati ulandilu kubha bhombi bhakaniki kunjowanela.” ");
INSERT INTO mpa_vpl VALUES ("LK9_6","072_9_6","LUK","9","6","6","Panihapa bhabhulwa bhakabhokiki na kujenda kwijiji, koni bhakatangaza Malobhi Manyahi na kubhalamiha bhandu pandu pokapi. ");
INSERT INTO mpa_vpl VALUES ("LK9_7","072_9_7","LUK","9","7","7","Helode mtawala wa ku Galilaya, akajowini malobhi ghokapi ghaghatendakiki na Yesu. Na jombi akabhi na choghohi, maghambu bhandu bhapwaghika kubha Yohana Mbatizaji ayokiki kuhuma kwa bhakuwa. ");
INSERT INTO mpa_vpl VALUES ("LK9_8","072_9_8","LUK","9","8","8","Bhangi bhapwaghika Eliya atehi kupitalila, na bhangi bhapwaghika kubha jumu wa bhalota bhaka Chapanga bha mwandi atehi kuyoka. ");
INSERT INTO mpa_vpl VALUES ("LK9_9","072_9_9","LUK","9","9","9","Helode akapwaghike, “Yohana nukunhekiti mmutu, bho, henu ajoju nde nane ambaju nyowana malobhi ghaki?” Na jombi akatokuli kumbona Yesu. ");
INSERT INTO mpa_vpl VALUES ("LK9_10","072_9_10","LUK","9","10","10","Mitumi bhaka Yesu pabhakelawiki bhakumpwaghi Yesu ghokapi ghabhahengiki. Na jombi akabhatoliki bhabhulwa bhaki na kujenda nabhu kanjika jabhu ku muchi wa ku Betisaida. ");
INSERT INTO mpa_vpl VALUES ("LK9_11","072_9_11","LUK","9","11","11","Nambu lipogha la bhandu palamanyiki koajenda, bhakunjengalile. Yesu akabhajopalili, na kubhapwaghila panani ja Ukolongwa waka Chapanga, na kubhalamiha bhandu bhabhakabhi bhapala kulamishwa. ");
INSERT INTO mpa_vpl VALUES ("LK9_12","072_9_12","LUK","9","12","12","Pakwahiki pakamihi, bhabhulwa komi na bhabheli bhala bhakunjendi Yesu na kumpwaghila, “Wapwaghila bhandu bhajenda kwijiji na mu manyumba yeibhi pambipi na mighonda nahuli bhakalinga chilebhi na pandu pa kughonela, maghambu pandu pani pachingwenje.” ");
INSERT INTO mpa_vpl VALUES ("LK9_13","072_9_13","LUK","9","13","13","Nambu Yesu akabhayangiki, “Mwanganya mwabhete mwapekya chilebhe.” Bhombi bhakapwaghike, “Tubhinaghu pela mabumunda nhwanu na homba ibheli. Bho, upala le tujenda kuheme chilebhi cha kubhaleha bhandu bhokapi abhabha?” ");
INSERT INTO mpa_vpl VALUES ("LK9_14","072_9_14","LUK","9","14","14","Pandu panipala pakabhi na akanalomi ngati elfu nhwano. Yesu akabhapwaghi bhabhulwa bhaki, “Mwatamika bhandu mu mapogha na kila lipogha likubhaje na bhandu hamsini.” ");
INSERT INTO mpa_vpl VALUES ("LK9_15","072_9_15","LUK","9","15","15","Bhabhulwa bhaki bhakatei bhenibhela, na kubhatamika pahi. ");
INSERT INTO mpa_vpl VALUES ("LK9_16","072_9_16","LUK","9","16","16","Yesu akatohi mabumunda nhwanu ghala na homba ibheli, akalingali kunani kumahunde, akaipengalile. Bhela akahekiti mabumunda na homba, na kubhapeke bhabhulwa bhaki bhaghabhila bhandu. ");
INSERT INTO mpa_vpl VALUES ("LK9_17","072_9_17","LUK","9","17","17","Bhandu bhokapi bhakakuliki na bhakatupile. Na bhabhulwa bhakabhongini mahighalilu gha mabumunda na homba itonga komi na ibheli. ");
INSERT INTO mpa_vpl VALUES ("LK9_18","072_9_18","LUK","9","18","18","Lichobha limu Yesu paakabhi andobha Chapanga pandu pa kanjika. Bhabhulwa bhaki bhakunjendile, najombi akabhalalukili, “Bho, bhandu bhapwagha kubha nepani nde nane?” ");
INSERT INTO mpa_vpl VALUES ("LK9_19","072_9_19","LUK","9","19","19","Bhakanjangiki, “Bhandu bhangi bhapwagha wehapa wa Yohana Mbatizaji, na bhangi bhapwagha wehapa wa Eliya, na bhangi bhapwagha, wehapa nde jumu wa bhalota bhaka Chapanga bhamwande weuyokike.” ");
INSERT INTO mpa_vpl VALUES ("LK9_20","072_9_20","LUK","9","20","20","Na jombi akabhalalukile, “Bho, mwanganya mpwagha nepani na nane?” Petulu akayangaki, “Wehapa nde wa Kristo waka Chapanga.” ");
INSERT INTO mpa_vpl VALUES ("LK9_21","072_9_21","LUK","9","21","21","Bhela Yesu akabhakanaki ngabhampwaghi mundu lijambu leniheli. ");
INSERT INTO mpa_vpl VALUES ("LK9_22","072_9_22","LUK","9","22","22","Yesu akapwaghiki kabheti, “Impalika Mwana waka Mundu kupata mang'ahiku na kukanakika na bhazee, bhapenganyambiku bhakolongwa, na bhabhola bha Shelia. Na jombi anabhunkomaje, nambu lichobha la katatu anayokaje.” ");
INSERT INTO mpa_vpl VALUES ("LK9_23","072_9_23","LUK","9","23","23","Kabheti akabhapwaghi bhokapi, “Mundu jokapi jopala kubha mbulwa wangu, impalika alikana mweni, autola msalaba waki machobha ghokapi, na anyengalyaje. ");
INSERT INTO mpa_vpl VALUES ("LK9_24","072_9_24","LUK","9","24","24","Ndandi mundu jokapi joapala kukengalela womi waki anauhoaje, nambu joahoa womi waki kwa ndandi jangu, anaukengalyaje. ");
INSERT INTO mpa_vpl VALUES ("LK9_25","072_9_25","LUK","9","25","25","Bho, anakunjangatya kiki mundu kupata kila chindu chekibhi pani pundema koni auhoa womi waki au kuliyonanga mweni? ");
INSERT INTO mpa_vpl VALUES ("LK9_26","072_9_26","LUK","9","26","26","Anangati mundu amonela iyoni nepani na mabholu ghangu, Mwana waka Mundu anambonila iyoni mundu hoju paanahika mu ulumbalilu waki, na ulumbalilu wa Atati waki, na ulumbalilu wa bhatumika bhahuhu bha kunani bhaka Chapanga. ");
INSERT INTO mpa_vpl VALUES ("LK9_27","072_9_27","LUK","9","27","27","Numpwaghi chakaka, bhabhi bhangi bhabhajemiki pambani ngabhapoteli mbaka pabhaubhona Ukolongwa waka Chapanga.” ");
INSERT INTO mpa_vpl VALUES ("LK9_28","072_9_28","LUK","9","28","28","Paghapetiki machobha nane kutumbu palongila ghanihagha, Yesu akuntoi Petulu, na Yohana, na Yakobo papamu nabhu na kukwela nabhu kuchitombi kundobha Chapanga. ");
INSERT INTO mpa_vpl VALUES ("LK9_29","072_9_29","LUK","9","29","29","Yesu paakabhi andobha Chapanga, pamihu jaki pakang'anambwiki, na ingobhu yaki ikang'anyiki ng'aing'ai. ");
INSERT INTO mpa_vpl VALUES ("LK9_30","072_9_30","LUK","9","30","30","Palapala bhakapitali bhandu bhabheli na kulonge naku. Bhandu habha bhakabhi Musa na Eliya, ");
INSERT INTO mpa_vpl VALUES ("LK9_31","072_9_31","LUK","9","31","31","bhakabhonakini bhakabya mu ulumbalilu wa kunani kumahunde na bhakalongi na Yesu panani ja kutimiza lengu laka Chapanga kwa kupotela ku Yelusalemu. ");
INSERT INTO mpa_vpl VALUES ("LK9_32","072_9_32","LUK","9","32","32","Petulu na bhajaki bhakabhi bhaghochi lughonu nakanopi, na bhakakikanwiki na kuubhona ulumbalilu waka Yesu na bhandu bhabhheli bhabhajemiki papamu naku. ");
INSERT INTO mpa_vpl VALUES ("LK9_33","072_9_33","LUK","9","33","33","Musa na Eliya pabhabhokiki, Petulu akumpwaghi Yesu, “Bambo, mbanga tepani tutama pambane! Tuchenga indamba itatu, chimu chaku, chengi chaka Musa na chengi chaka Eliya.” Petulu ngacheakamanyi chealongilaje. ");
INSERT INTO mpa_vpl VALUES ("LK9_34","072_9_34","LUK","9","34","34","Petulu paakabhi alonge ghanihagha, lihundi lakapitalili na kubhayeka kwa nhwili waki, na bhabhulwa bhakajowipi ntundu lihundi molakabhayekile. ");
INSERT INTO mpa_vpl VALUES ("LK9_35","072_9_35","LUK","9","35","35","Sauti jakajowaniki kuhuma mu lihundi, jakapwagha, “Hajoju nde Mwana wangu jonunhawile, munjowanya jombi.” ");
INSERT INTO mpa_vpl VALUES ("LK9_36","072_9_36","LUK","9","36","36","Sauti pajakotwiki kujowaneka, Yesu akabhonakini abhi kanjika. Bhabhulwa bhakatami chinunu, na kwa chikahi chenihechi ngachebhumpwaghi mundu chindu chokapi chebhachiwene. ");
INSERT INTO mpa_vpl VALUES ("LK9_37","072_9_37","LUK","9","37","37","Chilabhu jaki Yesu na bhabhulwa bhatatu bhala bhakaheli kuhuma kuchitombi, na lipogha likolongwa la bhandu lakaimangini na Yesu. ");
INSERT INTO mpa_vpl VALUES ("LK9_38","072_9_38","LUK","9","38","38","Mundu jumu kuhuma mu lipogha akajamalili, akapwaghaje, “Mbola! Nukujopa undingalya mwana wangu, kwa ndandi jombi nde mwana wangu wa kanjika! ");
INSERT INTO mpa_vpl VALUES ("LK9_39","072_9_39","LUK","9","39","39","Chikahi chamaheli majobhi ghunkamula, najombi palapala ajamalila, kabheti ghunjeghe chihinduhindu, koni akapita mahuluhulu mundomu, ghunkojo muhyegha, na anaghunkamwi ghundekake kwa kung'ahika! ");
INSERT INTO mpa_vpl VALUES ("LK9_40","072_9_40","LUK","9","40","40","Nakabhajopiki bhabhulwa bhaku bhumboha lijobhi, nambu ngachebhawezike.” ");
INSERT INTO mpa_vpl VALUES ("LK9_41","072_9_41","LUK","9","41","41","Yesu akabhayangiki, “Mwenga chibheleku changa uhobhalelu na chechihobhike! Bho, anandama na mwenga mbaka lile? Bho, ananunhinakalya mbaka line?” Bhela akumpwaghi mundu jola, “Undeta mwana waku pambane.” ");
INSERT INTO mpa_vpl VALUES ("LK9_42","072_9_42","LUK","9","42","42","Nkombu jola paakabhi anjende Yesu, lijobhi lela lakunjeghi chihinduhindu na kunhabhu pahi. Yesu akandakali lijobhi, akundamihi nkombu hoju na kunkelabhua kwa atati waki. ");
INSERT INTO mpa_vpl VALUES ("LK9_43","072_9_43","LUK","9","43","43","Bhandu bhokapi bhakakangichi kwa kubhona uwezu ukolongwa waka Chapanga. Bhandu bhokapi pabhabhi bhakona kukangacha mambu ghahengika Yesu, jombi akabhapwaghi bhabhulwa bhaki, ");
INSERT INTO mpa_vpl VALUES ("LK9_44","072_9_44","LUK","9","44","44","“Njowanakya ghanga ghanumpwaghila! Mwana waka Mundu anaajeghalika mu mabhoku gha bhandu.” ");
INSERT INTO mpa_vpl VALUES ("LK9_45","072_9_45","LUK","9","45","45","Nambu bhabhulwa bhaki ngachebhamanyiki ndandi ja malobhi ghanihagha, na ghakahiyakiki kwabhu nahuli ngabhimanya, na bhombi bhakajowipi kundalukila Yesu ndandi ja malobhi ghanihagha. ");
INSERT INTO mpa_vpl VALUES ("LK9_46","072_9_46","LUK","9","46","46","Bhabulwa bhaka Yesu bhakatumbwi kulochana kubha nde nane joaibya nkolongwa kwa lujiniku pachilanda jitu. ");
INSERT INTO mpa_vpl VALUES ("LK9_47","072_9_47","LUK","9","47","47","Yesu akaghamanyi maholalelu gha mitima jabhu, bhela akuntoliki mwana na kunjemeka pambipi jaki. ");
INSERT INTO mpa_vpl VALUES ("LK9_48","072_9_48","LUK","9","48","48","Na kubhapwaghi bhabhulwa bhaki, “Mundu jokapi joanjopale mwana jonjoni kwa lihina langu, anyopale nepani. Na mundu jokapi joanyopale nepani, anjopale jola joandumike. Ndandi joabhi nchoku pachilanda jinu, jonihoju nde nkolongwa kwa lujiniku kupeta bhokapi.” ");
INSERT INTO mpa_vpl VALUES ("LK9_49","072_9_49","LUK","9","49","49","Yohana akumpwaghi Yesu, “Bambo, tumbweni mundu akabhoha majobhi kwa lihina laku, na tepani tukalengiki kundakalila, maghambu jombi ngachealongana na tepani.” ");
INSERT INTO mpa_vpl VALUES ("LK9_50","072_9_50","LUK","9","50","50","Yesu akumpwaghi Yohana papamu na bhabhulwa bhajaki, “Ngamwandakalila, ndandi mundu jokapi jwangakupengana na mwenga abhi upambala chinu.” ");
INSERT INTO mpa_vpl VALUES ("LK9_51","072_9_51","LUK","9","51","51","Chikahi pachaheghali chaka Yesu kutolakeka kujenda kunani kumahunde, Yesu akaamwili kujenda ku Yelusalemu. ");
INSERT INTO mpa_vpl VALUES ("LK9_52","072_9_52","LUK","9","52","52","Akabhatumiki bhabholu bhundongulyaje, na bhombi bhakapiti ku chijiji cha ku Samalia nahuli bhundenganakya kila chindu. ");
INSERT INTO mpa_vpl VALUES ("LK9_53","072_9_53","LUK","9","53","53","Nambu bhandu bha chijiji cha ku Samalia ngachebhunjopalile, ndandi ikamanyakini apita ku Yelusalemu. ");
INSERT INTO mpa_vpl VALUES ("LK9_54","072_9_54","LUK","9","54","54","Bhabhulwa bhaka Yesu, bhabhakabhi Yakobo na Yohana pabhaghhaweni ghanighala, bhakundaluki Yesu, “Bambo, bho, upala le tulaghalakya moto kuhuma kunani ubhajochaje ngati Eliya moakahengile?” ");
INSERT INTO mpa_vpl VALUES ("LK9_55","072_9_55","LUK","9","55","55","Yesu akang'anambwiki na kubhakenjukila, akapwagha, “Ngachemmanyi nde roho ja ntundu bhole jembi naju.” ");
INSERT INTO mpa_vpl VALUES ("LK9_56","072_9_56","LUK","9","56","56","Kwa ndandi Mwana waka Mundu ngacheahikiki kuiyonanga roho ya bhandu, nambu kuikengalela. Panihapa Yesu na bhabhulwa bhaki bhakapiti ku chijiji nachengi. ");
INSERT INTO mpa_vpl VALUES ("LK9_57","072_9_57","LUK","9","57","57","Pabhakabhi mwindela bhakajendaje, mundu jumu akumpwaghi Yesu, “Ananukujengalya kwokapi kowijendaje.” ");
INSERT INTO mpa_vpl VALUES ("LK9_58","072_9_58","LUK","9","58","58","Yesu akumpwaghile, “Mabweha ghabhi na makolu, na ijuni ibhi na mihuwi, nambu Mwana waka Mundu ngacheabhi na pandu pa kulighoneka na kupomulela.” ");
INSERT INTO mpa_vpl VALUES ("LK9_59","072_9_59","LUK","9","59","59","Yesu akumpwaghi mundu jongi, “Unyengalyaje.” Nambu mundu jola akayangaki, “Bambo, uneka hoti nyenda nakuntagha atati wangu.” ");
INSERT INTO mpa_vpl VALUES ("LK9_60","072_9_60","LUK","9","60","60","Yesu akampwaghile, “Waleka bhakuwa bhabhataghaje bhakuwa bhabhu. Nambu wehapa ujenda ukatangaza Ukolongwa waka Chapanga.” ");
INSERT INTO mpa_vpl VALUES ("LK9_61","072_9_61","LUK","9","61","61","Mundu jongi akumpwaghile, “Bambo, ananukujengalyaje, nambu uneka hoti nyendaje nakabhalaghila bhalongu bhangu.” ");
INSERT INTO mpa_vpl VALUES ("LK9_62","072_9_62","LUK","9","62","62","Yesu akumpwaghile, “Mundu jokapi joatumbu kulema na papa kutumbu kabheti kulingali kunyuma ngacheapalika mu Ukolongwa waka Chapanga.” ");
INSERT INTO mpa_vpl VALUES ("LK10_1","072_10_1","LUK","10","1","1","Paghapetiki ghanighala Yesu akahawi bhandu bhangi sabini na bhabheli, akabhatumiki bhabheli bhabheli, bhundongulya mu kila muchi na pandu papalika jombi kujenda. ");
INSERT INTO mpa_vpl VALUES ("LK10_2","072_10_2","LUK","10","2","2","Akabhapwaghile, “Mahunu nde ghamaheli, nambu bhahuna nde bhachoko. Mundobha Bambo wa mahuno abhatuma bhatumika mu ngonda waki. ");
INSERT INTO mpa_vpl VALUES ("LK10_3","072_10_3","LUK","10","3","3","Henu njendanyaje! Nuntuma ngati mambeleli pachilanda ja mabweha gha muchitengu. ");
INSERT INTO mpa_vpl VALUES ("LK10_4","072_10_4","LUK","10","4","4","Ngamwitogho mbija, nkoba, na magubasi, na ngamwijema mwindela kundamuki mundu jokapi jola. ");
INSERT INTO mpa_vpl VALUES ("LK10_5","072_10_5","LUK","10","5","5","Ananjingi munyumba jokapi, kutumbula mpwagha, ‘Lukwale lubya munyumba jenu.’ ");
INSERT INTO mpa_vpl VALUES ("LK10_6","072_10_6","LUK","10","6","6","Ngati monimola anakubhi na mundu joapala kutama kwa lukwali abhi panihapa, lukwali lwinu lwa kulamukila analuhighalya kwaki. Ngati njeta, lukwali lola analunkelebhukyaje. ");
INSERT INTO mpa_vpl VALUES ("LK10_7","072_10_7","LUK","10","7","7","Ntama munyumba jeniheji, koni mkakula na kunywa chokapi chebhampekyaje, maghambu mtumika apalika kujopalela malepu ghaki. Ngamwibhoka kujenda kutama nyumba najengi. ");
INSERT INTO mpa_vpl VALUES ("LK10_8","072_10_8","LUK","10","8","8","Anampiti ku muchi na bhandu bhaki anabhunjopalili, nkula chela chebhampekyaje. ");
INSERT INTO mpa_vpl VALUES ("LK10_9","072_10_9","LUK","10","9","9","Mwalamiha bhatamwa bhabhabhi monihomu, na mwapwaghila, ‘Ukolongwa waka Chapanga uheghali kwinu.’ ");
INSERT INTO mpa_vpl VALUES ("LK10_10","072_10_10","LUK","10","10","10","Nambu ananjingi mu muchi wokapi, na bhandu anabhakaniki kunjopalela, mboka, njenda mu indela yabhu na kupwagha, ");
INSERT INTO mpa_vpl VALUES ("LK10_11","072_10_11","LUK","10","11","11","‘Hata luhombi lwa muchi winu lolukamulini mu magholu ghitu, tukung'unda palongi jinu, ngati ulakalilu kwinu, nambu nkombuka kubha Ukolongwa waka Chapanga unheghalile!’ ");
INSERT INTO mpa_vpl VALUES ("LK10_12","072_10_12","LUK","10","12","12","Numpwaghi chakaka, mu Lichobha la Utemulu Chapanga analangiha chiha kwa muchi wa Sodoma kuliku muchi ghonihoghu! ");
INSERT INTO mpa_vpl VALUES ("LK10_13","072_10_13","LUK","10","13","13","“Anamuchibhonaje bhandu bha muchi wa Kolazini! Anauchibhonaje bhandu bha muchi wa Betisaida! Ndandi ngangachu yeitendakiki kwaku ikatendiki ku Tilo na ku Sidoni, bhandu bha konihoku bhakabya bhajomwi kutama pahi, na kuwata ingobhu ya magunila, na kulipaka ilihu, na kulangi kubha bhang'anambwiki na kughaleka mahoku ghabhu! ");
INSERT INTO mpa_vpl VALUES ("LK10_14","072_10_14","LUK","10","14","14","Nambu Chapanga analangiha chiha nakanopi mu Lichobha la Utemulu kwa bhandu bha muchi wa Tilo na Sidoni kupeta kwinu mwenga. ");
INSERT INTO mpa_vpl VALUES ("LK10_15","072_10_15","LUK","10","15","15","Nanau muchi wa Kapelenaumu! Bho, upala le kulikweha mbaka kunani kumahunde? Anauhelalika mpaka kuwawa!” ");
INSERT INTO mpa_vpl VALUES ("LK10_16","072_10_16","LUK","10","16","16","Yesu akabhapwaghi bhhabulwa bhaki, “Mundu jola joanjowane mwehapa, anyowane nepani, na mundu joankana mwehapa, angana nepani, na mundu joangana nepani ankana jola joandumike.” ");
INSERT INTO mpa_vpl VALUES ("LK10_17","072_10_17","LUK","10","17","17","Bhandu sabini na bhabheli bhala bhakakelawiki kwa chiheku na kupwagha, “Bambo, kwa lihina laku hata majobhi ghatutii!” ");
INSERT INTO mpa_vpl VALUES ("LK10_18","072_10_18","LUK","10","18","18","Yesu akabhapwaghile, “Nakumbweni Shetani akahabhuka kuhuma kunani kumahunde ngati chitobhi. ");
INSERT INTO mpa_vpl VALUES ("LK10_19","072_10_19","LUK","10","19","19","Njowanya! Numpeki uwezu wa kukanyata majoka na hipeleli, na uwezu panani ja makili ghokapi ghaka Adui, na nga chindu chechampotikaje. ");
INSERT INTO mpa_vpl VALUES ("LK10_20","072_10_20","LUK","10","20","20","Nambu ngamwikubha na chiheku ndandi majobhi ghuntii mwehapa, nambu muhekalya maghambu mahina ghinu ghalembakiki kunani kumahunde.” ");
INSERT INTO mpa_vpl VALUES ("LK10_21","072_10_21","LUK","10","21","21","Chikahi chelachela, Yesu akatwelakiki na chiheku kwa uwezu waka Roho Mhuhu, na kupwagha, “Atati, Bambo wa kunani kumahunde na pundema! Nukuchengu maghambu wahiiki mambu ghani bhabhabhi na mbulau na malango, na ughahyekwi kwa bhana. Ena, Atati, ndandi ghanihagha nde moghabheli mapalu ghaku.” ");
INSERT INTO mpa_vpl VALUES ("LK10_22","072_10_22","LUK","10","22","22","Akajendali kubhapwaghi bhandu, “Atati wangu ambeki hindu yokapi. Nga jumu joammanyi Mwana nambu Atati, kabheti nga joammanyi Atati nambu Mwana, na jokapi Mwana joapala kumuhyekulila.” ");
INSERT INTO mpa_vpl VALUES ("LK10_23","072_10_23","LUK","10","23","23","Bhela Yesu akabhang'anambuki bhabhulwa bhaki, na kulonge nabhu bhombi kanjika jabhu, na kubhapwaghila, “Mbanga bhandu bhabhaghabhona mambu ghamughabhona mwenga! ");
INSERT INTO mpa_vpl VALUES ("LK10_24","072_10_24","LUK","10","24","24","Numpwaghi chakaka, bhalota bhamaheli bhaka Chapanga na bhakolongwa bha pundema bhakatokuli kughabhona ghamughabhona, nambu ngachebhaghawene, na kujowana malobhi ghamughajowana, nambu ngachebhajowine.” ");
INSERT INTO mpa_vpl VALUES ("LK10_25","072_10_25","LUK","10","25","25","Mundu jumu joaimanyi Shelia akajemiki, na kundaluki Yesu kwa kundenga, “Mbola, bho, ndenda bhole nahuli mbata kupwelela womi wa mileli?” ");
INSERT INTO mpa_vpl VALUES ("LK10_26","072_10_26","LUK","10","26","26","Yesu akundalukile, “Bho, Shelia jipwagha bhole? Bho, ujimanya bhole paujiasoma?” ");
INSERT INTO mpa_vpl VALUES ("LK10_27","072_10_27","LUK","10","27","27","Mundu jola akamyangiki, “ ‘Umpala Bambo Chapanga waku kwa mtima waku wokapi, kwa roho jaku jokapi, kwa makili ghaku ghokapi, na kwa malangu ghaku ghokapi, na umpala njaku ngati moulipali wamweti.’ ” ");
INSERT INTO mpa_vpl VALUES ("LK10_28","072_10_28","LUK","10","28","28","Yesu akampwaghile, “Uyangiki wichu! Utenda bhenibhela, nanaghu anautamaje.” ");
INSERT INTO mpa_vpl VALUES ("LK10_29","072_10_29","LUK","10","29","29","Nambu jombi kwa kupala kulilinga ngati jombi wamboni akundaluki Yesu, “Bho, njangu nde nane?” ");
INSERT INTO mpa_vpl VALUES ("LK10_30","072_10_30","LUK","10","30","30","Yesu akamyangiki, “Kukabhi na mundu jumu joahelala kuhuma ku Yelusalemu na kujenda ku Yeliko. Paakabhi mwindela, akalapuliki na bhihe, na bhakunyawili hindu yaki, na bhakundekiki aghoni panipala akabya pambipi kupotela. ");
INSERT INTO mpa_vpl VALUES ("LK10_31","072_10_31","LUK","10","31","31","Panihapa akapitali mpenganyambiku jumu akahelala indela jelajela, paakambweni mundu joakalapuliki jola, akapetiki kunkeghi. ");
INSERT INTO mpa_vpl VALUES ("LK10_32","072_10_32","LUK","10","32","32","Bhelabhela Mlawi jumu akahikiki pandu pala, najombi paakambweni mundu joalapuliki jola, najombi akapetiki kunkeghi. ");
INSERT INTO mpa_vpl VALUES ("LK10_33","072_10_33","LUK","10","33","33","Nambu Msamalia jumu joakabhi apeta indela jelajela, akunketani mundu joalapuliki jola. Na jombi paakambweni mundu jola, mtima waki ukamboni chiha. ");
INSERT INTO mpa_vpl VALUES ("LK10_34","072_10_34","LUK","10","34","34","Akanjendili, akangolwi ilonda yaki kwa mahuta na divai na kuikonga kwa itambala. Bhela akamkwehiki paliponda laki, akampeliki munyumba ja kuhiki bhagheni na kundwaa. ");
INSERT INTO mpa_vpl VALUES ("LK10_35","072_10_35","LUK","10","35","35","Chilabhu jaki Msamalia jola akabhohiki ipandi ibhele ya madini gha feza na kumpeke mweni nyumba, na kumpwaghila, ‘Undwaa mundu ajoju. Na mbija yengi yeipetalya yenjenu kwa kunjangatila, ananepa nepani panikelabhukaje.’ ” ");
INSERT INTO mpa_vpl VALUES ("LK10_36","072_10_36","LUK","10","36","36","Yesu akalalukile, “Ubhona bhole, bho, jwaku pachilanda ja bhatatu habha, nde njake mundu joalapuliki na bhihi jola?” ");
INSERT INTO mpa_vpl VALUES ("LK10_37","072_10_37","LUK","10","37","37","Mbola wa Shelia jola akamyangiki, “Nde jola joakamboni chiha.” Yesu akampwaghile, “Jendaje na ukatenda bhelabhela.” ");
INSERT INTO mpa_vpl VALUES ("LK10_38","072_10_38","LUK","10","38","38","Yesu na bhabhulwa bhaki pabhakabhi mu mwanja, bhakajingi mu chijiji chimu. Na mbomba jumu joalowakika Masa, akanjopali kunyumba jaki. ");
INSERT INTO mpa_vpl VALUES ("LK10_39","072_10_39","LUK","10","39","39","Masa akabhi na ndombu waki joalowakika Malia, joakatemi pambipi na Yesu akajowanya mabholu ghaki. ");
INSERT INTO mpa_vpl VALUES ("LK10_40","072_10_40","LUK","10","40","40","Masa akabhi ahangajika na mahengu ghingi gha munyumba, bhela akanjendi Yesu na kumpwaghila, “Bambo, bho, ngacheubhona le kubha ndombu wangu anekiki nhenga mahengu kanjika jango? Umpwaghila ahika anyangatyaje!” ");
INSERT INTO mpa_vpl VALUES ("LK10_41","072_10_41","LUK","10","41","41","Bambo akamyangiki, “Masa, Masa! Ung'ahika na kulyungalyunga kwa mambu ghamaheli, ");
INSERT INTO mpa_vpl VALUES ("LK10_42","072_10_42","LUK","10","42","42","nambu chipalika pe chindu chimu. Malia ahawili chindu chamboni nakanopi chechu nga mundu joanyaghulaje.” ");
INSERT INTO mpa_vpl VALUES ("LK11_1","072_11_1","LUK","11","1","1","Lichobha limu Yesu akabhi pandu pamu akundobha Chapanga. Paakajomwi kulobha, mbulwa waki jumu akumpwaghile, “Bambo, utubhola kulobha, ngati Yohana moakabhabholi bhabhulwa bhaki.” ");
INSERT INTO mpa_vpl VALUES ("LK11_2","072_11_2","LUK","11","2","2","Yesu akabhapwaghile, “Pamundobha Chapanga, mpwagha ana, ‘Atati witu weubhi kunani kumahunde, Lihina laku lilumbalikaje, Ukolongwa waku uhikaje, mapalu ghaku ghapitalyaje, pani pundema, ngati kunani kumahunde. ");
INSERT INTO mpa_vpl VALUES ("LK11_3","072_11_3","LUK","11","3","3","Utupekya chilebhi chitu cha kila lichobha. ");
INSERT INTO mpa_vpl VALUES ("LK11_4","072_11_4","LUK","11","4","4","Utulekakya mahoku ghitu, Ngati tepani motubhalekalela bhokapi bhabhatuhokiye. Na ngawatuleka kujingila mu malengakeku, nambu utukengalya na Muhakau jola.’ ” ");
INSERT INTO mpa_vpl VALUES ("LK11_5","072_11_5","LUK","11","5","5","Bhela Yesu akabhapwaghi bhabhulwa bhaki, “Tupwagha jumu winu ajenda pamahiku kunyumba jaka nkochi waki na kupwagha, ‘Nkochi wangu, unyahika mabumunda ghatatu. ");
INSERT INTO mpa_vpl VALUES ("LK11_6","072_11_6","LUK","11","6","6","Ndandi nkochi wangu ahikiki kwangu kuhuma mu mwanja, nanatu ngachemi na chilebhi cha kumpekeha!’ ");
INSERT INTO mpa_vpl VALUES ("LK11_7","072_11_7","LUK","11","7","7","Na tupwagha nkochi joabhi munyumba akayanga, ‘Ngawing'aha! Ndyangu ujighalike, nepani na bhana bhangu tughonile. Ngachenhweza kujumuka na kukupeke chokapi.’ ");
INSERT INTO mpa_vpl VALUES ("LK11_8","072_11_8","LUK","11","8","8","Chakaka numpwaghila, hata ngati ngaayijumuki na kukupeke chilebhi hata koni wehapa unkochi waki, nambu kwa ndandi ja kujendale kunjopa, ayijumukaji na kumpeke kila chindu cheapala maghambu ngacheakabhi na iyoni kujendale kunjopa.” ");
INSERT INTO mpa_vpl VALUES ("LK11_9","072_11_9","LUK","11","9","9","Bhela numpwaghila, “Ndobhaje nanamu anampataje, mlondaye nanamu mwipataje, muhodimaje nanamu mwihoghuliwa ndyangu. ");
INSERT INTO mpa_vpl VALUES ("LK11_10","072_11_10","LUK","11","10","10","Ndandi mundu jokapi joalobha ayijopalyaje, na mundu jokapi joalonda ayipataje, na mundu jokapi joahodima anahoghuliwa ndyangu. ");
INSERT INTO mpa_vpl VALUES ("LK11_11","072_11_11","LUK","11","11","11","Bho, Atati bholi pachilanda jinu joaweza kumpeke mwana waki liganga ngati anajopiki libumunda au anaanjopiki homba, na badala ja homba anaampekya lijoka? ");
INSERT INTO mpa_vpl VALUES ("LK11_12","072_11_12","LUK","11","12","12","Au mwana anajopiki lihombi, anampekya chipelele? ");
INSERT INTO mpa_vpl VALUES ("LK11_13","072_11_13","LUK","11","13","13","Ngati mwehapa mwembi mwahakau, mmanyi kubhapekeha hindu inayahi bhana bhinu, bho, Atati winu wa kunani kumahunde ngaapeke Roho Mhuhu bhokapi bhabhunjopa?” ");
INSERT INTO mpa_vpl VALUES ("LK11_14","072_11_14","LUK","11","14","14","Lichobha limu Yesu akabhi amboha lijobhi lelakuntendiki mundu jumu abya mpuli. Lijobhi lela palumbokiki mundu jola, akatumbwi kulongela, na lipogha la bhandu lakakangichi namaa. ");
INSERT INTO mpa_vpl VALUES ("LK11_15","072_11_15","LUK","11","15","15","Nambu bhandu bhangi bhakapwaghike, “Aghabhoha majobhi kwa makili ghaka Beelizebuli, nkolongwa wa majobhi.” ");
INSERT INTO mpa_vpl VALUES ("LK11_16","072_11_16","LUK","11","16","16","Bhandu bhangi kwa kundenga Yesu, bhakapaliki atenda nginyulila kuhuma kunani kumahunde. ");
INSERT INTO mpa_vpl VALUES ("LK11_17","072_11_17","LUK","11","17","17","Nambu Yesu akaghamanyi maholalelu ghabhu, akabhapwaghile, “Ukolongwa wokapi woulekangini mapogha ghaghapengana ngauwezi kutamakila, bhelabhela bhandu bha nyumba jimu anabhapengana bheni kwa bheni, bhandu bha nyumba heji anabhalekanaje. ");
INSERT INTO mpa_vpl VALUES ("LK11_18","072_11_18","LUK","11","18","18","Ngati ukolongwa waka Shetani ulekangini mapogha ghaghapengana, bho, ukolongwa waki wijema bhole? Numpwaghi aghagha ndandi mwanganya mpwagha nepani moha majobhi kwa makili ghaka Beelizebuli. ");
INSERT INTO mpa_vpl VALUES ("LK11_19","072_11_19","LUK","11","19","19","Ngati nepani moha majobhi kwa makili ghaka Beelizebuli, bho, bhahemba bhinu bhaghatopola kwa uwezu waka nane? Bhahemba bhinu anabhuntemula kubha mwanganya muhokihe! ");
INSERT INTO mpa_vpl VALUES ("LK11_20","072_11_20","LUK","11","20","20","Nambu ngati anamoha majobhi kwa uwezu waka Chapanga, bhela Ukolongwa waka Chapanga unhikile. ");
INSERT INTO mpa_vpl VALUES ("LK11_21","072_11_21","LUK","11","21","21","“Mundu joabhi na makili, paalenda nyumba jaki kwa silaha, hindu yaki yokapi ikubha lukwale. ");
INSERT INTO mpa_vpl VALUES ("LK11_22","072_11_22","LUK","11","22","22","Nambu anahiki mundu joabhi na makili kumpeta jombhi anakomini naku na kundapula, jonihoju anaanyaghula silaha jeahobhalyaje na kuighabha hindu yeanyawile. ");
INSERT INTO mpa_vpl VALUES ("LK11_23","072_11_23","LUK","11","23","23","“Mundu jokapi jwangakulilomba na nepani, atenda kumbenga, na mundu jokapi jwangakubhongana papamu na nepani, atenda kupechangana. ");
INSERT INTO mpa_vpl VALUES ("LK11_24","072_11_24","LUK","11","24","24","“Lijobhi palumpita mundu, liyongolota yongolota pandu pajomu likalola pandu pa kupomulela. Nambu nangakupabhona pandu pa kupomulela, ajipwaghi, ‘Anangelebhuka kabhete kunyumba jangu konhumiki.’ ");
INSERT INTO mpa_vpl VALUES ("LK11_25","072_11_25","LUK","11","25","25","Paakelabhuka na kujiketane nyumba jipyaghaliki na kupambakika wichu, ");
INSERT INTO mpa_vpl VALUES ("LK11_26","072_11_26","LUK","11","26","26","bhela ajenda na kughaloha majobhi ghangi saba mahakau kupeta jombi, na ghombi ghajingila na kutama mkati jaka mundu hoju. Henu hali jaka mundu jola anajikubha jihakau nakanopi kupeta pakutumbula.” ");
INSERT INTO mpa_vpl VALUES ("LK11_27","072_11_27","LUK","11","27","27","Yesu palongila ghanihagha, mbomba jumu joakabhi pa lipogha la bhandu pala akajamali na kupwagha, “Mbanga mbomba joakubheliki, na kukujongea!” ");
INSERT INTO mpa_vpl VALUES ("LK11_28","072_11_28","LUK","11","28","28","Nambu Yesu akamuyangiki, “Mbanga nakanopi bhabhalijowana Lilobhi laka Chapanga na kulitii.” ");
INSERT INTO mpa_vpl VALUES ("LK11_29","072_11_29","LUK","11","29","29","Lipogha la bhandu palajonjukiki, Yesu akabhapwaghile, “Chibheleku chenjenu nde chibheleku cha bhandu bhahakau. Chipala nginyulila, nambu ngachipati nginyuli jokapi jela, nambu nginyuli jaka Yona. ");
INSERT INTO mpa_vpl VALUES ("LK11_30","072_11_30","LUK","11","30","30","Ndandi ngati mlota Yona moakabheli nginyulila kwa bhandu bha Ninawi, bhelabhela Mwana waka Mundu nde moayibhelila nginyulila kwa chibheleku chenjenu. ");
INSERT INTO mpa_vpl VALUES ("LK11_31","072_11_31","LUK","11","31","31","Lichobha la Utemulu, malikia wa ku Sheba anaajemaje na kubhatakila bhandu bha chibheleku chenjenu, maghambu jombi akahikiki kuhuma kutali nakanopi kuhika kujowane malobhi gha mbulau ghaka Nkolongwa Solomoni, henu numpwaghila, pambani abhi nkolongwa kupeta Solomoni. ");
INSERT INTO mpa_vpl VALUES ("LK11_32","072_11_32","LUK","11","32","32","Mu Lichobha la Utemulu, bhandu bha ku Ninawi bhijema papamu na kubhatakila bhandu bha kibheleku chenjenu, maghambu bhombi bhakang'anambwiki na kughaleka mahoku ghabhu pabhajowini kutangaza kwaka Yona. Chakaka numpwaghila pambani abhi nkolongwa kupeta Yona! ");
INSERT INTO mpa_vpl VALUES ("LK11_33","072_11_33","LUK","11","33","33","“Nga mundu joapambaki taa na kujihiya au kujiyekale na chihulu. Nambu bhajibheka panani ja kinala, nahuli bhandu bhokapi bhabhajingila bhabhona unang'anu waki. ");
INSERT INTO mpa_vpl VALUES ("LK11_34","072_11_34","LUK","11","34","34","Lihu laku nde taa ja hyegha jaku. Ngati lihu laku analibhi linyahi, hyegha jaku jokapi jitweli unang'anu. Nambu ngati lihu laku ngalinyahi, hyegha jaku jitweli lwihe. ");
INSERT INTO mpa_vpl VALUES ("LK11_35","072_11_35","LUK","11","35","35","Bhela ulilingalya wichu unang'anu waku ghoubhi naku mkati ja hyegha jaku ngawikubha lwihe. ");
INSERT INTO mpa_vpl VALUES ("LK11_36","072_11_36","LUK","11","36","36","Bhela anakubhi hyegha jaku jokapi jibhi na unang'anu, panga kubha na pandu papabhi na lwihi, hyegha jaku jokapi anajibya na unang'anu, ngati taa mojikumulakila kwa unang'anu waki.” ");
INSERT INTO mpa_vpl VALUES ("LK11_37","072_11_37","LUK","11","37","37","Yesu paajomula kupwagha, Mfalisayo jumu akundohiki ajenda kunyumba jaki akakula chilebhe. Bhela Yesu akajingili na kutama kula chilebhe. ");
INSERT INTO mpa_vpl VALUES ("LK11_38","072_11_38","LUK","11","38","38","Mfalisayo jola akakangichi kumbona Yesu akula chilebhe mangane ja kuchamba machi mabhoku ghaki. ");
INSERT INTO mpa_vpl VALUES ("LK11_39","072_11_39","LUK","11","39","39","Bhela Bambo akampwaghile, “Mwanganya Mwafalisayo, mwengolola chikombi na mbali kwa kunja, nambu mkati ntweli unyaghula na uhakau. ");
INSERT INTO mpa_vpl VALUES ("LK11_40","072_11_40","LUK","11","40","40","Mwanganya mwang'ang'a! Bho, nga Chapanga le joalenganaki kunja, na nde joalenganaki mkati? ");
INSERT INTO mpa_vpl VALUES ("LK11_41","072_11_41","LUK","11","41","41","Nambu mwajangatya bhahochu kwa hindu hinu, na yengi yokapi anaibya wichu kwinu. ");
INSERT INTO mpa_vpl VALUES ("LK11_42","072_11_42","LUK","11","42","42","“Nambu anamuchibhonaje Mafalisayo! Maghambu mumboke Chapanga zaka ya nchicha na imbogha yokapi ya mahamba, ngati nabwaka na makolu ghangi ghokapi, nambu nkotoka kubhahenge bhandu mambu ghaaghapala Chapanga, na nkotoka kumpala Chapanga. Ikampaliki kuhenga mambu ghamboni palongi jaka Chapanga na kumpala Chapanga, panga kughaleka ghangi hagha. ");
INSERT INTO mpa_vpl VALUES ("LK11_43","072_11_43","LUK","11","43","43","“Anamuchibhonaje Mwafalisayo! Ndandi mpala kutama itehu ya kutopela mu nyumba ja kuhimangani Bhayahude, na kulamukiwa kwa utopelu palighulio. ");
INSERT INTO mpa_vpl VALUES ("LK11_44","072_11_44","LUK","11","44","44","Anamuchibhonaje! Maghambu mbi ngati matengeli ghangakubhonikana, ghaghu bhandu bhajenda panani jaki panga kumanya.” ");
INSERT INTO mpa_vpl VALUES ("LK11_45","072_11_45","LUK","11","45","45","Mbola jumu wa Shelia akupwaghile, “Mbola, paupwagha malobhi ghanihagha, bhelabhela ututondola na tepani.” ");
INSERT INTO mpa_vpl VALUES ("LK11_46","072_11_46","LUK","11","46","46","Yesu akamuyangiki, “Na mwanganya bhabhola bha Shelia, anamuchibhonaje, maghambu mwatweka bhandu ibwahila yeitopike yanga kunyamulika, koni mwabheti ngachenhwatambu hata lukonji kubhajangati kunyamula. ");
INSERT INTO mpa_vpl VALUES ("LK11_47","072_11_47","LUK","11","47","47","Anamuchibhonaje! Maghambu nchengalela matengeli gha bhalota bhaka Chapanga bhala bhabhakomakiki na akahoko bhinu. ");
INSERT INTO mpa_vpl VALUES ("LK11_48","072_11_48","LUK","11","48","48","Bhela mwanganya mabheti njetakela ghala ghabhakahengiki akahoko bhinu, bhombi bhakabhakomiki bhalota bhaka Chapanga, na mwanganya nchengale matengeli ghabhu. ");
INSERT INTO mpa_vpl VALUES ("LK11_49","072_11_49","LUK","11","49","49","Bhela Chapanga kwa malangu ghaki akapwaghiki, ‘Ananatuma kwabhu bhalota na bhatenga bhangu, nambu bhombi anabhakoma bhakumu bhabhu na bhangi kubhang'aha.’ ");
INSERT INTO mpa_vpl VALUES ("LK11_50","072_11_50","LUK","11","50","50","Bhela bhandu bha kibheleku chenjenu bhitemulikaje kwa kupotela kwa bhalota bhokapi bhaka Chapanga bhabhakakomakiki kutumbu kubhombakeka kwa ndema, ");
INSERT INTO mpa_vpl VALUES ("LK11_51","072_11_51","LUK","11","51","51","kutumbu kukomakeka kwaka Abeli mbaka kukomakeka kwaka Zakalia, joakomakiki pa chilanda ja chihanja cha nyambiku na Pandu Pahuhu. Ena, chakaka numpwaghila, bhandu bha kibheleku chenjenu bhitemulika kwa kubhakoma bhokapi habha.” ");
INSERT INTO mpa_vpl VALUES ("LK11_52","072_11_52","LUK","11","52","52","“Anamuchibhonaje mwanganya bhabhola bha Shelia! Maghambu muhiiki ufunguu wa kuhoghule ndyangu wa umanyi, mabhanganya mabheti ngachenjingi na mwahibhali bhandu bhabhajingi ngabhijingila!” ");
INSERT INTO mpa_vpl VALUES ("LK11_53","072_11_53","LUK","11","53","53","Yesu paakabhi abhoka munyumba jaka Mfalifayu jola, bhabhola bha Shelia na Mafalisayo bhakatumbwi kuntumbula kwa kundalukila malobhi ghamahele, ");
INSERT INTO mpa_vpl VALUES ("LK11_54","072_11_54","LUK","11","54","54","nahuli bhapata kunkamula kwa chindu chokapi cheayilongilaje. ");
INSERT INTO mpa_vpl VALUES ("LK12_1","072_12_1","LUK","12","1","1","Chikahi bhandu bhamaheli pabhakabhi bhalibhongini mbaka kukanyatana, Yesu akatumbwi hoti kupwagha na bhabhulwa bhaki, “Mlilingalya na amila ja undumila kubheli ja Mafalisayo. ");
INSERT INTO mpa_vpl VALUES ("LK12_2","072_12_2","LUK","12","2","2","Njeta lilobhi lelihiyakiki ambalu ngaliyekuliwi, wala lelihiyakiki ambalu ngalimanyikane. ");
INSERT INTO mpa_vpl VALUES ("LK12_3","072_12_3","LUK","12","3","3","Henu, kila chendongila kulubhendu bhandu anabhaghajowana paunang'anu, na kila chenjojalanya koni njighi milyangu kuchumba, ghitangazwa panani ja unhaghala wa nyumba.” ");
INSERT INTO mpa_vpl VALUES ("LK12_4","072_12_4","LUK","12","4","4","“Numpwaghi, mwanganya mwabhakochi bhangu, ngamwajoghopa bhala bhabhakoma hyegha nambu anabhajomwile ngachebhaweza kuhenga kabheti chindu chokapi kupetalela. ");
INSERT INTO mpa_vpl VALUES ("LK12_5","072_12_5","LUK","12","5","5","Ananundangia jola joapalika kujoghupeka. Munjoghupa jola, ambaju anaakomiki, abhi na uwezu wa kundekela ku motu wa jehanamu. Chakaka numpwaghila, jonihoju nde jumu joapalika kujoghupeka!” ");
INSERT INTO mpa_vpl VALUES ("LK12_6","072_12_6","LUK","12","6","6","“Bho, iwebha nhwanu ngacheilombaseka kwa sendi ibhele? Nambu njeta chiwebha hata chimu chechijewakeka palongi jaka Chapanga. ");
INSERT INTO mpa_vpl VALUES ("LK12_7","072_12_7","LUK","12","7","7","Kabheti hata majunju gha mimutu jinu ghabhalangiki ghokapi. Ngamwijoghopa, maghambu mabhanganya mpalika nakanopi kupeta iwebha yamahele! ");
INSERT INTO mpa_vpl VALUES ("LK12_8","072_12_8","LUK","12","8","8","“Chakaka numpwaghila, mundu jokapi joanyetakela nepani palongi ja bhandu, Mwana waka Mundu najombi anaanjetakalya palongi ja bhatumika bha kunani bhaka Chapanga. ");
INSERT INTO mpa_vpl VALUES ("LK12_9","072_12_9","LUK","12","9","9","Nambu mundu jokapi joangana palongi ja bhandu, Mwana waka Mundu najombi anaankana palongi ja bhatumika bha kunani bhaka Chapanga. ");
INSERT INTO mpa_vpl VALUES ("LK12_10","072_12_10","LUK","12","10","10","“Mundu jokapi joandongale lilobhi lihakau Mwana waka Mundu analekakiwaje, nambu mundu jokapi joantondo Roho Mhuhu ngailekakewi ng'o. ");
INSERT INTO mpa_vpl VALUES ("LK12_11","072_12_11","LUK","12","11","11","“Pabhampelaka mwanganya palongi ja nyumba ya kuhimangani Bhayahude, na palongi ja ihongozi, na bhatawala, ngamwijoghopa ntundu momwalikengalyaje panani ja malobhi ghamwilongilaje. ");
INSERT INTO mpa_vpl VALUES ("LK12_12","072_12_12","LUK","12","12","12","Ndandi chikahi chenihechi Roho Mhuhu anaambola chela chempalika kulongela.” ");
INSERT INTO mpa_vpl VALUES ("LK12_13","072_12_13","LUK","12","13","13","Mundu jumu pa lipogha la bhandu lela akumpwaghi Yesu, “Mbola, umpwaghila ndongu wangu tughabhana upwelelu ghoatuleki atati witu.” ");
INSERT INTO mpa_vpl VALUES ("LK12_14","072_12_14","LUK","12","14","14","Yesu akamuyangiki, “Nkoche, bho, nde nane joamekiki nepani kubha mtemula au kubha mundu wa kubhaghabhanaki bhandu hindu yabho?” ");
INSERT INTO mpa_vpl VALUES ("LK12_15","072_12_15","LUK","12","15","15","Yesu akajendali kubhapwaghi bhokapi, “Mulijepa na ntundu wokapi wa kubha na wime! Ndandi hindu ngacheiweza kukengalela womi waka mundu, hata ngati anabhi na hindu yamahele.” ");
INSERT INTO mpa_vpl VALUES ("LK12_16","072_12_16","LUK","12","16","16","Bhela Yesu akabhapwaghi ulenganesu ghongo, “Kukabhi na mundu jumu mwanahindu yamaheli joakabhi na ngonda ghoubholalanile ghoupiika mahunu ghamaheli. ");
INSERT INTO mpa_vpl VALUES ("LK12_17","072_12_17","LUK","12","17","17","Jombi akatumbwi kuholalela mumtima waki, ‘Ngachemi na pandu pa kubheka mahunu ghangu ghokapi. Bho, ndenda bhole?’ ");
INSERT INTO mpa_vpl VALUES ("LK12_18","072_12_18","LUK","12","18","18","Akalipwaghi, ‘Anandenda ana, anamombula ugholu wangu na kuchenga ugholu ukolongwa nakanopi. Nanatu anameka monihomu mahunu ghangu ghokapi na hindu yangu yengi.’ ");
INSERT INTO mpa_vpl VALUES ("LK12_19","072_12_19","LUK","12","19","19","Bhela ananilipwaghila namwete, ‘Wenga mtima wangu! Sajenu ubhi na hindu yamaheli yambone ya kujaghanila kwa hyaka yamaheli. Upomulyaje, ukulaji, ukunywaji na kuhekalela!’ ");
INSERT INTO mpa_vpl VALUES ("LK12_20","072_12_20","LUK","12","20","20","Nambu Chapanga akampwaghile, ‘Ung'ang'a wenga! Lalenu ikilu roho jaku anajitolakikaje, henu bho, hindu yokapi yeulilundakile anaikubha yaka nane?’ ” ");
INSERT INTO mpa_vpl VALUES ("LK12_21","072_12_21","LUK","12","21","21","Yesu akajomuli kwa kupwagha, “Ana nde mokubhelile kwaka mundu joalilundaki hindu kwa ndandi jaka mwene, nambu palongi jaka Chapanga ngacheabhalangika kubha na chindu.” ");
INSERT INTO mpa_vpl VALUES ("LK12_22","072_12_22","LUK","12","22","22","Bhela Yesu akabhapwaghi bhabhulwa bhaki, “Kwa ndandi jeniheji numpwaghila, ngamwikubha na choghohi kubhokana na chilebhi chemchipala nahuli mpata kubha bhomi, wala ingobhu yemuipala kwa ndandi ja hyegha yinu. ");
INSERT INTO mpa_vpl VALUES ("LK12_23","072_12_23","LUK","12","23","23","Ndandi womi nde wambone nakanopi kupeta chilebhi, na hyegha nde jambone nakanopi kupeta ingobhu. ");
INSERT INTO mpa_vpl VALUES ("LK12_24","072_12_24","LUK","12","24","24","Mughalingalya makongolu, ngacheghapanda, wala ngacheghahuna, wala ngacheghabhi na ugholu, nambu Chapanga aghaleha! Mwabhanganya mpalika nakanopi kupeta ijuni! ");
INSERT INTO mpa_vpl VALUES ("LK12_25","072_12_25","LUK","12","25","25","Bho, nde nane pachilanda jinu, kwa kuhangajika kwaki, aweza kulijonjuke hata lisaa limu nakanopi ja chikahi cha womi wake? ");
INSERT INTO mpa_vpl VALUES ("LK12_26","072_12_26","LUK","12","26","26","Ngati ngachemuweza kutenda lijambu lichokopi ngati leniheli, bho, maghambu kiki mng'ahikila mambu ghange? ");
INSERT INTO mpa_vpl VALUES ("LK12_27","072_12_27","LUK","12","27","27","Ndingalya malobha moghakolela, ngacheghahenga lihengu wala ngacheghaloka. Nambu numpwaghila, hata Nkolongwa Solomoni na hindu yaki yokapi ngacheakawatikwi ingobhu jejiweza kulengana na unyahi wa lilobha limu. ");
INSERT INTO mpa_vpl VALUES ("LK12_28","072_12_28","LUK","12","28","28","Bhela ngati Chapanga aghawatika mahamba gha mungonda ngati bhenibhela ghaghabhonikana pambani lalenu na chilabhu kutaghakika pamotu. Bho, ngaiwezi kunhwatika mwanganya nakanope? Mwenga mabhandu mwembi na uhobhalelu uchoko! ");
INSERT INTO mpa_vpl VALUES ("LK12_29","072_12_29","LUK","12","29","29","“Bhela ngamwing'ahika mumitima jinu kubha anankula kiki au anankunywa kiki. ");
INSERT INTO mpa_vpl VALUES ("LK12_30","072_12_30","LUK","12","30","30","Ndandi ghanihagha ghokapi bhaghahangajaki bhandu bhokapi bhangakummanya Chapanga. Nambu Atati winu wa kunani kumahunde amanya kubha muipala hindu yeniheyi. ");
INSERT INTO mpa_vpl VALUES ("LK12_31","072_12_31","LUK","12","31","31","Nambu mwanganya ndonda hoti Ukolongwa waka Chapanga, najombi anaampekya hindu yeniheyi yokapi. ");
INSERT INTO mpa_vpl VALUES ("LK12_32","072_12_32","LUK","12","32","32","“Ngamwijoghopa, mwenga lipogha lichoku, maghambu Atati winu apaliki kumpeke mwehapa Ukolongwa waki. ");
INSERT INTO mpa_vpl VALUES ("LK12_33","072_12_33","LUK","12","33","33","Ndombisa hindu yinu na mukabhaghabhila bhahochu mbija yene. Mulibhekila nkoba wanga kulala na mulibhekila chikoku kunani kumahunde, changakuweza kujomoka. Maghambu konihoku bhihi ngachebhaweza kujibha, wala mangeki ngacheghayonanga. ");
INSERT INTO mpa_vpl VALUES ("LK12_34","072_12_34","LUK","12","34","34","Maghambu pandu pachibhi chikoku chaku, nde pala pawibya mtima waku.” ");
INSERT INTO mpa_vpl VALUES ("LK12_35","072_12_35","LUK","12","35","35","“Mulikonga ulamba mwibhunu hinu, na taa yinu ikayakaje. ");
INSERT INTO mpa_vpl VALUES ("LK12_36","072_12_36","LUK","12","36","36","Mbya ngati bhatumika bhabhundendalela bambo wabhu ahika kuhuma ku ndowa. Nahuli anahikiki na kuhodima bhunhoghulya ndyango. ");
INSERT INTO mpa_vpl VALUES ("LK12_37","072_12_37","LUK","12","37","37","Mbanga bhatumika bhala, ambabhu bambo wabhu paikelabhukaje anaabhaketanyaje bhabhi mihu! Numpwaghi chakaka, bambo hoju anaalikongaje ulamba muchibhuno, na kubhapwaghila bhatama pahi pachilebhi, na kubhatumakila. ");
INSERT INTO mpa_vpl VALUES ("LK12_38","072_12_38","LUK","12","38","38","Mbanga bhatumika bhala, ambabhu bombo wabhu anaabhahimanyaje bhabhi mihu hata ngati anahiki ikilu pa mahiku au pachibhombu! ");
INSERT INTO mpa_vpl VALUES ("LK12_39","072_12_39","LUK","12","39","39","Nambu mmanya kubha, ngati mweni nyumba akamanyiki lisaa la kuhika mwihi, akabya atemi mihu, ngaakajilekiki nyumba jaki jibhombuliwaje na mwihi. ");
INSERT INTO mpa_vpl VALUES ("LK12_40","072_12_40","LUK","12","40","40","Nanamu mkubhaje tayali, maghambu Mwana waka Mundu anahika lisaa langakumanyikana.” ");
INSERT INTO mpa_vpl VALUES ("LK12_41","072_12_41","LUK","12","41","41","Petulu akundaluki Yesu, “Bambo, bho, ulenganesu aghoghu utulongale tepani au bhandu bhokape?” ");
INSERT INTO mpa_vpl VALUES ("LK12_42","072_12_42","LUK","12","42","42","Bambo akamuyangiki, “Bho, henu nde nane joabhi mtumika ndongwana na joabhi na malango? Nde jola ambaju bambo waki ambei kubhajemalela bhatumika bhaki bhangi na kubhapeke chilebhi chabhu kwa chikahi chechipalika. ");
INSERT INTO mpa_vpl VALUES ("LK12_43","072_12_43","LUK","12","43","43","Apengaliki mtumika jola, ambaju anangati bambo waki akelabhuka anhimani akahenga bhenibhela. ");
INSERT INTO mpa_vpl VALUES ("LK12_44","072_12_44","LUK","12","44","44","Chakaka numpwaghila, bambo waki anaambeka mtumika jola kubha njemalela wa hindu yaki yokapi. ");
INSERT INTO mpa_vpl VALUES ("LK12_45","072_12_45","LUK","12","45","45","Nambu anangati mtumika jola alipwaghi mweni muntima waki, ‘Bambo wangu anaakabhakya kukelabhuka,’ na bhela kutumbu kubhalapu bhatumika bhajaki, akambomba na akanalomi, najombi akula na kunywa na kulobhela. ");
INSERT INTO mpa_vpl VALUES ("LK12_46","072_12_46","LUK","12","46","46","Bhela bambo waka mtumika jola anahika lichobha langa kumanyikana na lisaa langa kumanyikana. Na bambo hoju anaanhekata ipandi ibheli na kumbeka papamu na bhandu bhangakuhobhalela. ");
INSERT INTO mpa_vpl VALUES ("LK12_47","072_12_47","LUK","12","47","47","“Mtumika joamanya mambu ghaapala bambo waki ahengaji, nambu alepale kulibheka wichu na kukotoka kuhenga mambu ghaapala bambo jola, mtumika hoju ayilapulika nakanopi. ");
INSERT INTO mpa_vpl VALUES ("LK12_48","072_12_48","LUK","12","48","48","Nambu mtumika jola jwangakumanya mambu ghaapala bambo waki ahengaje, najombi ahenga mambu ghaghapalika kutemulika, mtumika hoju ayipulika pachokopi. Kwa ndandi mundu jokapi joajopali yamaheli ayijopakika yamahele. Na mundu jokapi joajopali yamahele nakanopi, ayijopakika yamahele nakanopi kuhuma kwaki. ");
INSERT INTO mpa_vpl VALUES ("LK12_49","072_12_49","LUK","12","49","49","“Nhikiki kupambaki motu pani pundema, nenga mbala nakanopi kubhona ukabya ujomwi kubhelela! ");
INSERT INTO mpa_vpl VALUES ("LK12_50","072_12_50","LUK","12","50","50","Nambu mi na ubatizu ghombalika kubatizwa, nanatu anang'ahakika namaa mbaka ubatizu hoghu ujomukaje. ");
INSERT INTO mpa_vpl VALUES ("LK12_51","072_12_51","LUK","12","51","51","Bho, muhambuki nhikiki kuleta lukwale kwa bhandu pani pundema? Ngabhela! Ngachenhikiki kubhatenda bhandu bhatama kwa lukwale, nambu nhikiki kubhalekanisha bhandu. ");
INSERT INTO mpa_vpl VALUES ("LK12_52","072_12_52","LUK","12","52","52","Maghambu kutumbu sajenu bhandu nhwanu bha nyumba jimu anabhakomanaje, bhatatu kwa bhabheli na bhabheli kwa bhatatu. ");
INSERT INTO mpa_vpl VALUES ("LK12_53","072_12_53","LUK","12","53","53","Atati anakomana na mwana waki, na mwana anakomana na atati waki. Amabhu anakomana na mwali waki, na mwali anakomana na mabhu waki. Nkowanu anakomana na nhwanu waka mwana waki, na jonihoju anakomana na akowanu waki.” ");
INSERT INTO mpa_vpl VALUES ("LK12_54","072_12_54","LUK","12","54","54","Yesu akabhapwaghi kabheti bhandu, “Pamughabhona mahundi ghapitalila kuhuma kolijibhi lyobha, panihapa mpwagha, iyula anajitonyaje, na chakaka iyula jitonya. ");
INSERT INTO mpa_vpl VALUES ("LK12_55","072_12_55","LUK","12","55","55","Chikahi pambona mpongu upogha kuhuma upambala wa kunkachi, panihapa mpwagha kubha anakupyopaje, na kukubha bhenibhela. ");
INSERT INTO mpa_vpl VALUES ("LK12_56","072_12_56","LUK","12","56","56","Mwanganya mwaka ndumi kubhele! Muweza kulingalila kunani kumahunde na pundema na kupwagha kubha iyula anajitonyaje na lyobha analibhalaje. Bho, ndepale bhole kumanya chikahi chenjenu cha sajenu? ");
INSERT INTO mpa_vpl VALUES ("LK12_57","072_12_57","LUK","12","57","57","“Bho, maghambu kiki mwanganya ngachemuweza kumanya lijambu lambone la kutenda? ");
INSERT INTO mpa_vpl VALUES ("LK12_58","072_12_58","LUK","12","58","58","Ndandi paulongana na mtakila waku kukupeleka pachengu, ukangamala ujongana naku ukabya wakona mwindela. Nanga bhela mtemula anaakupelaka kwa manjolinjoli, na manjolinjoli anabhukubheka muchifungo. ");
INSERT INTO mpa_vpl VALUES ("LK12_59","072_12_59","LUK","12","59","59","Nukupwaghila, ngawipiti monihomu mbaka pawijomulya kulepa sendi ja mwisho.” ");
INSERT INTO mpa_vpl VALUES ("LK13_1","072_13_1","LUK","13","1","1","Chikahi hechi bhandu bhakumu bhakahikite, bhakundandi Yesu panani ja bhandu bha ku Galilaya ambabhu Pilato akabhi abhakomiti chikahi pabhakabhi bhachinja hinyama yabhu kwa ndandi ja nyambiku kwaka Chapanga. ");
INSERT INTO mpa_vpl VALUES ("LK13_2","072_13_2","LUK","13","2","2","Yesu akabhayangiki, “Bho muhambuki kubha Bhagalilaya habha bhakakomakiki bhenibhela, maghambu bhombi bhakabhi na mahakau kupeta Bhagalilaya bhangi bhokape? ");
INSERT INTO mpa_vpl VALUES ("LK13_3","072_13_3","LUK","13","3","3","Chakaka ngabhela! Nambu nanamu nangakung'anambuka na kughaleka mahoku ghinu, bhelabhela nanamu mwiyonangikaje ngati mobhayonangakaki bhombe. ");
INSERT INTO mpa_vpl VALUES ("LK13_4","072_13_4","LUK","13","4","4","Au bhandu komi na nane bhala bhabhapotili pawahabhukili mnala wa ku Siloamu, bho, muhambuki bhandu bhala bhakabhi bhahakau kupeta bhandu bhokapi bhabhatamika ku Yelusalemu? ");
INSERT INTO mpa_vpl VALUES ("LK13_5","072_13_5","LUK","13","5","5","Chakaka ngabhela! Nupwaghila nanamu nangakung'anambuka na kughaleka mahoku ghinu, mabhokapi mwiyonangikaje ngati bhombi.” ");
INSERT INTO mpa_vpl VALUES ("LK13_6","072_13_6","LUK","13","6","6","Yesu akabhapwaghi kabheti ulenganesu agho, “Kukabhi na mundu jumu joakabhi na nkongu wa mtini ghoakaupandiki mungonda waki wa mizabibu. Akahikiki kulonda mapambiku mu nani jaki nambu ngacheapatiki chindu. ");
INSERT INTO mpa_vpl VALUES ("LK13_7","072_13_7","LUK","13","7","7","Bhela akampwaghi mtumika wa ngonda hoghu, ‘Lingalyaje! Kwa hyaka itatu mili nakahikaje kutongo mapambiku gha nkongu wa mtini aghoghu, panga kupata chokapi chela. Uhekataje! Bho, ndandi ki ujendale kutumi luhombi waka?’ ");
INSERT INTO mpa_vpl VALUES ("LK13_8","072_13_8","LUK","13","8","8","Nambu mtumika wa ngonda jola akayangiki, ‘Bambo, uleka kabheti chaka chimu chenu ananukulaghalya munkeghi jaki na kujeghale mbolea. ");
INSERT INTO mpa_vpl VALUES ("LK13_9","072_13_9","LUK","13","9","9","Ngati anaupambiki mapambiku chaka chechihika, chamboni, nambu nangakupambika, wauhekataje.’ ” ");
INSERT INTO mpa_vpl VALUES ("LK13_10","072_13_10","LUK","13","10","10","Mu Lichobha limu la Sabato Yesu akabhi abhola mu nyumba ja kuhimangani Bhayahude. ");
INSERT INTO mpa_vpl VALUES ("LK13_11","072_13_11","LUK","13","11","11","Mkati mola kukabhi na mbomba joakakamuliki na lijobhi kwa chikahi cha hyaka komi na nane. Akabhi na chipendi na ngacheawezika kuhatambuka. ");
INSERT INTO mpa_vpl VALUES ("LK13_12","072_13_12","LUK","13","12","12","Yesu paakambweni mbomba jola, akandohiki, na kumpwaghila, “We mabhu, chitamu chaku ulamike.” ");
INSERT INTO mpa_vpl VALUES ("LK13_13","072_13_13","LUK","13","13","13","Akabhei mabhoku panani jaki na kundamiha, na palapala akahatambwiki na kundumbali Chapanga. ");
INSERT INTO mpa_vpl VALUES ("LK13_14","072_13_14","LUK","13","14","14","Nambu nkolongwa wa nyumba ja kuhimangani Bhayahude, akahakali ndandi Yesu akandamihi mbomba hoju mu Lichobha la Sabato. Bhela akabhapwaghi bhandu bhabhabhi panipala, “Mbi na machobha sita gha kuhenga lihengu, muhika kulamishwa kwa machobha ghanihagha, nambu ngamwihika kulamishwa mu Lichobha la Sabato!” ");
INSERT INTO mpa_vpl VALUES ("LK13_15","072_13_15","LUK","13","15","15","Nambu Bambo akamuyangiki, “Mwanganya mwaka ndumi kubhele! Bho, kubhi na mundu pachilanda jinu joakalepa kubhopo ng'ombi au liponda laki kuhuma mu chindamba kulipeleka kunywa machi, hata ngati lichobha heli nde Lichobha la Sabato? ");
INSERT INTO mpa_vpl VALUES ("LK13_16","072_13_16","LUK","13","16","16","Mbomba ajoju nde wa lubhelakeku lwaka Ibulahimu, joju akongakiki na Shetani kwa hyaka komi na nane. Bho, nga wichu le kumbopulela mu Lichobha la Sabato?” ");
INSERT INTO mpa_vpl VALUES ("LK13_17","072_13_17","LUK","13","17","17","Yesu paakalongi ghanihagha, maadui bhaki bhakaweni hiyoni, nambu bhandu bhangi bhokapi bhakatweli chiheku kwa ndandi ja mambu ghokapi gha kukangacha ghaakahengike. ");
INSERT INTO mpa_vpl VALUES ("LK13_18","072_13_18","LUK","13","18","18","Bhela Yesu akabhalalukile, “Bho, Ukolongwa waka Chapanga ulengana na kyane? Bho, tulandila kwa indela bhole? ");
INSERT INTO mpa_vpl VALUES ("LK13_19","072_13_19","LUK","13","19","19","Ulengana na imbeju njoku jejilowakeka haladali jeakatoliki mundu na kupanda mungonda waki. Imbeju jakameliki na kubha nkongu ukolongwa, na ijuni ihika kuchenga mihuwi mu mambandi ghaki.” ");
INSERT INTO mpa_vpl VALUES ("LK13_20","072_13_20","LUK","13","20","20","Yesu akabhalaluki kabheti, “Bho, ananulenganisha na kyane Ukolongwa waka Chapanga? ");
INSERT INTO mpa_vpl VALUES ("LK13_21","072_13_21","LUK","13","21","21","Ulengana na amila jeatotwi mabhu jumu na kuhangangana papamu na uhembi madebi ghabheli na uwembi wokapi ukatutumwike.” ");
INSERT INTO mpa_vpl VALUES ("LK13_22","072_13_22","LUK","13","22","22","Yesu paakabhi ajendale na mwanja waki kujenda ku Yelusalemu, akapeti mu michi na mwijiji koni akabhabhola bhandu. ");
INSERT INTO mpa_vpl VALUES ("LK13_23","072_13_23","LUK","13","23","23","Mundu jumu akundaluki Yesu, “Bambo, bho, bhandu bhachokopi le pe nde bhabhikengalikaje?” Yesu akabhayangiki, ");
INSERT INTO mpa_vpl VALUES ("LK13_24","072_13_24","LUK","13","24","24","“Mkangamala mkajingala mkati kupetela ndyangu upepandahu, ndandi chakaka bhandu bhamaheli bhilenga kujingila mkati, nambu ngabhiweze. ");
INSERT INTO mpa_vpl VALUES ("LK13_25","072_13_25","LUK","13","25","25","Mweni nyumba paijema na kujighila ndyangu, mwanganya mwitama kunja na kutumbu kukong'onda ndyangu mkapwagha, ‘Bambo, utuhogulyaje!’ Na jombi anaampwaghila, ‘Ngachenumanyi muhumiki kwako.’ ");
INSERT INTO mpa_vpl VALUES ("LK13_26","072_13_26","LUK","13","26","26","Bhela mwitumbula kumpwaghila, ‘Tepani nde bhala tetukulika na kunywa papamu na wenga, na wenga utubholika mu michi jitu!’ ");
INSERT INTO mpa_vpl VALUES ("LK13_27","072_13_27","LUK","13","27","27","Nambu anaampwaghila kabheti, ‘Ngachemanyi muhuma kwako. Mboka pambane, mabhanganya mwenhwenga mahakau!’ ");
INSERT INTO mpa_vpl VALUES ("LK13_28","072_13_28","LUK","13","28","28","Konihoku mwilela na kuyagha mino pamwambona Ibulahimu, Isaka na Yakobo na bhalota bhokapi bhaka Chapanga mu Ukolongwa waka Chapanga, nambu mwanganya mwibya ndekaliki kunja! ");
INSERT INTO mpa_vpl VALUES ("LK13_29","072_13_29","LUK","13","29","29","Bhandu bhihika kuhuma kolipita lyobha na kolijibhi lyobha, kungondi na kunkache, na bhombi bhitama pangokelu na kula chilebhi mu Ukolongwa waka Chapanga. ");
INSERT INTO mpa_vpl VALUES ("LK13_30","072_13_30","LUK","13","30","30","Bhela bhandu bhokapi bhabhabhi sajenu bha kujomukela bhibya bha kutumbula, na bhabhabhi sajenu bha kutumbula bhibya bha kujomukela.” ");
INSERT INTO mpa_vpl VALUES ("LK13_31","072_13_31","LUK","13","31","31","Chikahi chelachela, Mafalisayo bhakumu bhukunjendi Yesu na kumpwaghila, “Ubhoka pandu pambani ujenda pandu pangi, maghambu Helode apala kukukoma.” ");
INSERT INTO mpa_vpl VALUES ("LK13_32","072_13_32","LUK","13","32","32","Yesu akabhayangiki, “Njenda mukumpwaghila mwanabweha hoju ana, ‘Laleno na chilabhu anandopula majobhi na kalamiha bhatamwa, na pamalabhu ananyomulya lihengu langu.’ ");
INSERT INTO mpa_vpl VALUES ("LK13_33","072_13_33","LUK","13","33","33","Hata bhela imbalika kujendale na mwanja wangu laleno, chilabhu na pamalabu, ndandi ngacheimpalika mlota waka Chapanga kukomakeka kunja na muchi wa Yelusalemu. ");
INSERT INTO mpa_vpl VALUES ("LK13_34","072_13_34","LUK","13","34","34","“Yelusalemu! Mwenga bhandu bha Yelusalemu! Mwenga mwemwakoma bhalota bhaka Chapanga na kubhalapu maganga bhabholu bhaka Chapanga bhabhakatumakiki kwinu! Mala palenga nakapaliki kubhabhongana bhandu bhaku, ngati ingoku mojibhongane ibhana yaki pahi ja mapapanila ghaki, nambu mwanganya ngachemwapalike! ");
INSERT INTO mpa_vpl VALUES ("LK13_35","072_13_35","LUK","13","35","35","Ndingalya, matamu ghinu anaghahighalya mahame. Numpwaghila, kutumbu sajenu ngamwimoni kabheti mbaka pamwipwagha, ‘Apengalika hoju joahika kwa lihina laka Bambo.’ ” ");
INSERT INTO mpa_vpl VALUES ("LK14_1","072_14_1","LUK","14","1","1","Mu Lichobha limu la Sabato, Yesu akapiti kula chilebhe kunyumba jaka mundu jumu nkolongwa wa Mafalisayo, na bhandu bhabhakabhi panipala bhakabhi bhundingalakila. ");
INSERT INTO mpa_vpl VALUES ("LK14_2","072_14_2","LUK","14","2","2","Mundu jumu joakabhi na chitamu cha kuhimba hyegha akabhi palongi jaka Yesu. ");
INSERT INTO mpa_vpl VALUES ("LK14_3","072_14_3","LUK","14","3","3","Yesu akabhalalukili bhabhola bha Shelia na Mafalisayo, “Bho, Shelia jitu le jilaghalaki kundamiha mundu mu Lichobha la Sabato au nga wichu?” ");
INSERT INTO mpa_vpl VALUES ("LK14_4","072_14_4","LUK","14","4","4","Nambu bhombi bhakatemi chinunu. Yesu akamkamwi mtamwa jola, akandamihi na kundeka ajendaje. ");
INSERT INTO mpa_vpl VALUES ("LK14_5","072_14_5","LUK","14","5","5","Bhela Yesu akabhalaluki bhandu bhala, “Bho, mundu bhole pachilanda jinu anangati mwana waki au ng'ombi jaki anayijibhi muchilibha mu Lichobha la Sabato joayilepa kujenda kwipiya?” ");
INSERT INTO mpa_vpl VALUES ("LK14_6","072_14_6","LUK","14","6","6","Nambu bhombi ngachebhaweziki kumuyanga lilobhi lokapi lela. ");
INSERT INTO mpa_vpl VALUES ("LK14_7","072_14_7","LUK","14","7","7","Yesu paabhaweni bhagheni bhabhakokakiki bhala bhahaghu itehu ya kutopela, akabhapwaghi ulenganesu aghoghu, ");
INSERT INTO mpa_vpl VALUES ("LK14_8","072_14_8","LUK","14","8","8","“Chikahi mundu paakukoka pa ukwati, ngawitama pandu pa kutopela. Maghambu pangi pachilanda ja bhabhakokiki kubhi na mundu wa kutopela kukupeta wehapa, ");
INSERT INTO mpa_vpl VALUES ("LK14_9","072_14_9","LUK","14","9","9","na anahiki mwenei winu joankokiki mwanganya mabhokapi nhwikaje ayihika na kukupwaghila, ‘Undekila mundu ajoju chitehu hechi.’ Panihapa wipowakika lihamu palongi ja bhandu bhokapi na wijenda kutama kwitehu yanga kutopela. ");
INSERT INTO mpa_vpl VALUES ("LK14_10","072_14_10","LUK","14","10","10","Nambu anabhukukokiki paukwati, utama kwitehu yanga kutopela, nahuli joankokiki paahikaje akupwaghila ‘Nkochi wangu, uhika utama pani palongi, pandu panyahi nakanopi.’ Panihapa wibya utopile palongi ja bhandu bhokapi bhawitama naku kula chilebhe. ");
INSERT INTO mpa_vpl VALUES ("LK14_11","072_14_11","LUK","14","11","11","Maghambu mundu jokapi joalikweha mweni anahelakikaje, na mundu jokapi joaliheleha, anakwehakikaje.” ");
INSERT INTO mpa_vpl VALUES ("LK14_12","072_14_12","LUK","14","12","12","Bhela Yesu akampwaghi mundu joakankokiki jola, “Chikahi pauwandaa uwangalalu wa chilebhe cha muhi au cha pakamihi, ngawakoka bhakochi bhaku au bhalongu bhaku au bhandu bha pambipi au bhana hindu yamahele. Anauhengiki bhenibhela, na bhombi anabhukukoka kumanyumba ghabhu, na wehapa wibya bhakulepiki ngati chewahengile. ");
INSERT INTO mpa_vpl VALUES ("LK14_13","072_14_13","LUK","14","13","13","Nambu pauhenga uwangalalu wa kula chilebhe, wabhakoka bhahochu, ilema, bhabhatengwiki na akangalola, ");
INSERT INTO mpa_vpl VALUES ("LK14_14","072_14_14","LUK","14","14","14","nanaghu wibya upengaliki, maghambu bhandu habha ngachebhabhi na chakukulepa. Chapanga anaakulepa mu lichobha la kuyohakeka kwa bhandu bhambone.” ");
INSERT INTO mpa_vpl VALUES ("LK14_15","072_14_15","LUK","14","15","15","Jumu wa bhala bhabhakabhi bhakula chilebhe papamu na Yesu paakajowini malobhi ghanihagha, akumpwaghile, “Bhapengaliki bhandu bhokapi bhabhitama kula chilebhe cha uwangalalu mu Ukolongwa waka Chapanga!” ");
INSERT INTO mpa_vpl VALUES ("LK14_16","072_14_16","LUK","14","16","16","Yesu akamuyangiki, “Mundu jumu akatendiki uwangalalu ukolongwa wa kula chilebhe na kubhakoka bhandu bhamahele. ");
INSERT INTO mpa_vpl VALUES ("LK14_17","072_14_17","LUK","14","17","17","Chikahi cha kula chilebhe cha uwangalalu pachahikike, mundu jola akuntumiki mtumika waki akabhalohaje bhabhakokakiki, ‘Muhikaje, kila chindu chibhi wichu!’ ");
INSERT INTO mpa_vpl VALUES ("LK14_18","072_14_18","LUK","14","18","18","Nambu bhokapi bhakatumbwi kubhoha ndandi ya kulepa kuhika. Mundu wa kutumbula akumpwaghi mtumika jola, ‘Nhemi ngonda na mbalika nyenda nakulingaje, chondi nganhike.’ ");
INSERT INTO mpa_vpl VALUES ("LK14_19","072_14_19","LUK","14","19","19","Mundu jongi akapwaghiki, ‘Nhemi ng'ombi mapongu komi gha kulemela, henu nyenda kwilengesha, chondi nganhike.’ ");
INSERT INTO mpa_vpl VALUES ("LK14_20","072_14_20","LUK","14","20","20","Bhelabhela mundu jongi akapwaghiki, ‘Ndotwi mbomba, na bhela nganhike.’ ");
INSERT INTO mpa_vpl VALUES ("LK14_21","072_14_21","LUK","14","21","21","“Mtumika jola akakelawiki, na kundandi bambo waki mambu ghanihagha ghokapi. Panihapa bambo jola akahakalile na kumpwagii mtumika waki, ‘Ujenda kanyata mwijiji, na mwindela ya muchi, na ukabhaleta bhahochu, ilema, akangalola, na bhabhatengwike na kubhapwaghi bhahikaje.’ ");
INSERT INTO mpa_vpl VALUES ("LK14_22","072_14_22","LUK","14","22","22","Palongi pachokope mtumika jola akakelawiki na kupwagha, ‘Bambo, kila chindu kihenghakiki wichu ngati mowalaghalakile, nambu mbekenyu ja kutama bhandu jikale.’ ");
INSERT INTO mpa_vpl VALUES ("LK14_23","072_14_23","LUK","14","23","23","Bhela bambo jola akampwaghi mtumika waki, ‘Ujenda mwindela ya muchi na mwijiji na ukabhalazimisha bhandu bhahikaje, nahuli nyumba jangu jitwelalaje. ");
INSERT INTO mpa_vpl VALUES ("LK14_24","072_14_24","LUK","14","24","24","Maghambu numpwaghila nga mundu nga jumu pachilanda ja bhanakokiki joanahonja chilebhi cha uwangalalu wangu!’ ” ");
INSERT INTO mpa_vpl VALUES ("LK14_25","072_14_25","LUK","14","25","25","Bhela mapogha ghamaheli gha bhandu bhakabhi bhunjengale Yesu, jombi akang'anambwiki na kubhapwaghila bhandu, ");
INSERT INTO mpa_vpl VALUES ("LK14_26","072_14_26","LUK","14","26","26","“Mundu jokapi joanyengale nepani anaabya chakaka mbulwa wangu ngati anaambai nepani kupeta atati na mabhu waki, nhwanu waki na bhana bhaki, bhabheli bhaki na bhalombu bhaki, na mweni. ");
INSERT INTO mpa_vpl VALUES ("LK14_27","072_14_27","LUK","14","27","27","Mundu jokapi jwanga kunyamula msalaba waki na kunyengalela nepani, ngaawezi kubha mbulwa wangu.” ");
INSERT INTO mpa_vpl VALUES ("LK14_28","072_14_28","LUK","14","28","28","“Bho, mundu bholi pachilanda jinu joapala kuchenga mnala, joailepa kutumbu kutama pahi na kubhalanga mbija yeabhi nayu kwa kuchenga, nahuli amanya ngati abhi na mbija yeilenganela kwa kujomulela? ");
INSERT INTO mpa_vpl VALUES ("LK14_29","072_14_29","LUK","14","29","29","Kwa kubha ngati anaatumbwi kuchenga luhuli, na kulepale kujomule kuchenga, bhandu bhokapi bhabhabhona cheakihengike bhitenda kunheka. ");
INSERT INTO mpa_vpl VALUES ("LK14_30","072_14_30","LUK","14","30","30","Bhela bhipwagha, ‘Mundu ajoju akatumbwi kuchenga nambu ngacheaweziki kujomulela lihengu laki!’ ");
INSERT INTO mpa_vpl VALUES ("LK14_31","072_14_31","LUK","14","31","31","“Au nkolongwa bholi joajenda kukomana na nkolongwa jongi, jwanga kutumbu kutama pahi, na kuholalela ngati anaweza kwa manjolinjoli bhaki elufu komi kukomana na jola joabhi na manjolinjoli elufu ishiline? ");
INSERT INTO mpa_vpl VALUES ("LK14_32","072_14_32","LUK","14","32","32","Jombi ngati ngaayiwezi, anaantumila nkolongwa njaki jola ubholu wa kujopa kujongana kwa lukwale koni jongi hoju akabya akali kutali.” ");
INSERT INTO mpa_vpl VALUES ("LK14_33","072_14_33","LUK","14","33","33","Yesu akajomuli kwa kupwagha, “Kwa ntundu ghonihoghu, njeta pachilanda jinu joayiweza kubha mbulwa wangu ngati nangakuileka yokapi yeabhi naku.” ");
INSERT INTO mpa_vpl VALUES ("LK14_34","072_14_34","LUK","14","34","34","“Mwinyu nde wamboni, nambu mwinyu anauhoiki kunogha kwaki, bho, anaaujeghalika kiki nahuli ukelabhuha kunogha kwaki? ");
INSERT INTO mpa_vpl VALUES ("LK14_35","072_14_35","LUK","14","35","35","Ngacheupalika kabheti hata kwa kujeghela mungonda wala kuhangaghana na mbolea, nambu bhandu bhaulekela pela. Joabhi na makutu na ajowanaje!” ");
INSERT INTO mpa_vpl VALUES ("LK15_1","072_15_1","LUK","15","1","1","Lichobha limu bhajopa kode na bhana mahoku bhamaheli bhakapiti kunjowane Yesu. ");
INSERT INTO mpa_vpl VALUES ("LK15_2","072_15_2","LUK","15","2","2","Nambu Mafalisayo na bhabhola bha Shelia bhakatumbwi kung'ong'uteka bhakapwaghaje, “Mundu ajoju abhakoka bhana mahoku na kula papamu nabhu!” ");
INSERT INTO mpa_vpl VALUES ("LK15_3","072_15_3","LUK","15","3","3","Bhela Yesu akabhapwaghi ulenganesu aghoghu: ");
INSERT INTO mpa_vpl VALUES ("LK15_4","072_15_4","LUK","15","4","4","“Bho, ngati jumu winu anabhi na mambeleli mia moja, anaamanyi limu laki litehi kuhobha aitenda bhole, bho, ngaaghaleki tisini na tisa ghala pandu pa kudimila na kujenda kulilonda lelihobhiki lela mbaka alipataje? ");
INSERT INTO mpa_vpl VALUES ("LK15_5","072_15_5","LUK","15","5","5","Anaalipatiki, ayihekalya na kulitotola pachilembela chaki, ");
INSERT INTO mpa_vpl VALUES ("LK15_6","072_15_6","LUK","15","6","6","na kubhuja nalu kunyumba. Panihapa anaabhalohaje bhakochi bhaki na bhandu bha pambipi jaki, na kubhapwaghila, ‘Muhekalyaje papamu na nepani, maghambu nilipatiki limbeleli langu lelahobhike!’ ");
INSERT INTO mpa_vpl VALUES ("LK15_7","072_15_7","LUK","15","7","7","Bhelabhela numpwaghila, kwibya na chiheku kunani kumahunde kwa ndandi jaka mwana mahoku jumu joang'anambuka na kughaleka mahoku ghaki, kupeta bhandu tisini na tisa bhabhalibhona kubha bhamboni na bhangakupala kughaleka mahoku ghabhu. ");
INSERT INTO mpa_vpl VALUES ("LK15_8","072_15_8","LUK","15","8","8","“Au tupwagha mbomba jumu abhi na mangengelema kome gha mbija, bho, anahoiki lingengelema limu, aitenda bhole? Anapambakya taa na kupyaghi munyumba na kujilonda wichu mbaka ajipataje. ");
INSERT INTO mpa_vpl VALUES ("LK15_9","072_15_9","LUK","15","9","9","Jombi anaalipatiki lingengelema heli, anaabhalohaje bhakochi bhaki na bhandu bha pambipi jaki, na kubhapwaghila, ‘Muhekalyaje papamu na nepani, maghambu nilipatiki lingengalema langu limu lelahobhike!’ ");
INSERT INTO mpa_vpl VALUES ("LK15_10","072_15_10","LUK","15","10","10","Bhelebhela numpwaghila, bhenibhela nde mobhahekalela nakanopi bhatumika bha kunani kumahunde bhaka Chapanga kwa ndandi jaka muhakau jumu joang'anambuka na kughaleka mahoku ghaki.” ");
INSERT INTO mpa_vpl VALUES ("LK15_11","072_15_11","LUK","15","11","11","Yesu akajendali kubhapwaghila, “Kukabhi na mundu jumu joakabhi na bhana bhabheli bha chikambaku. ");
INSERT INTO mpa_vpl VALUES ("LK15_12","072_15_12","LUK","15","12","12","Nchoku jola akampwaghi atati waki, ‘Atati, umbekya upwelelu wangu.’ ” Bhela atati akabhaghabhi hindu yaki. ");
INSERT INTO mpa_vpl VALUES ("LK15_13","072_15_13","LUK","15","13","13","Paghapetiki machobha machokope, nchoku jola akalombisi hindu yaki. Akapiti na mbija yeakapatiki ku inchi ja kutali, konihoku akajitangini mbija yaki kwa matamu gha chijaka. ");
INSERT INTO mpa_vpl VALUES ("LK15_14","072_15_14","LUK","15","14","14","Paakajomwi kutumi mbija yaki, kukapitali injala ngolongwa ku inchi jenijela jokape, najombi akahighali panga chindu. ");
INSERT INTO mpa_vpl VALUES ("LK15_15","072_15_15","LUK","15","15","15","Bhela akapiti kujopa lihengu kwaka mundu jumu mwenei wa inchi jenijela, najombi akundaghalaki ajenda kungonda waki kulekeya magholobhi. ");
INSERT INTO mpa_vpl VALUES ("LK15_16","072_15_16","LUK","15","16","16","Jombi akatokuli namaha kula makambati ghala ghaghakulika magholobhi, nambu nga mundu joakampeki chindu cha kula. ");
INSERT INTO mpa_vpl VALUES ("LK15_17","072_15_17","LUK","15","17","17","Paakatumbwili kupata malangu, akaholali mumtima waki na kupwagha, “Atati wangu abhi na bhatumika bhamahele bhakula na kukileka chilebhe, na nepani mbotela kwa injala! ");
INSERT INTO mpa_vpl VALUES ("LK15_18","072_15_18","LUK","15","18","18","Bhela anamoka kongo na kujenda kwa atati wangu na kampwaghila, ‘Atati, nuntendi mahoku Chapanga na nukutendi mahoku wehapa. ");
INSERT INTO mpa_vpl VALUES ("LK15_19","072_15_19","LUK","15","19","19","Ngachembalika kabheti kulowakeka mwana waku, undenda mya ngati jumu wa bhatumika bhaku.’ ” ");
INSERT INTO mpa_vpl VALUES ("LK15_20","072_15_20","LUK","15","20","20","Bhela akatumbwi mwanja wa kukelabhuka kwa atati waki. “Nambu paakabhi akali patali pachokopi, atati waki akumbweni, koni mtima waki utweli chiha, akunkembalili mwana waki, akunjobhatili na kumbusu. ");
INSERT INTO mpa_vpl VALUES ("LK15_21","072_15_21","LUK","15","21","21","Mwana jola akumpwaghi atati waki, ‘Atati wangu, nuntendi mahoku Chapanga na nukutendi mahoku wehapa. Ngachembalika kabheti kulowakeka mwana waku.’ ” ");
INSERT INTO mpa_vpl VALUES ("LK15_22","072_15_22","LUK","15","22","22","Nambu atati waki akabhapwaghi bhatumika bhaki, “ ‘Kanyata! Ndeta ingobhu jinyahi munhwatikaje. Munhwatika pete mulukonji lwa mumabhoku na magubasi mumagholu ghake. ");
INSERT INTO mpa_vpl VALUES ("LK15_23","072_15_23","LUK","15","23","23","Bhela ndeta litoli lelinenipi na kulichinja, tukulaji na kuhekalela! ");
INSERT INTO mpa_vpl VALUES ("LK15_24","072_15_24","LUK","15","24","24","Ndandi mwana wangu ajoju akabhi apotile, nambu sajenu abhi mwome, akabhi ahobhiki, nambu sajenu abhonakini.’ ” Bhela na bhombi bhakatumbwi kuhekalela papamu. ");
INSERT INTO mpa_vpl VALUES ("LK15_25","072_15_25","LUK","15","25","25","“Uwangalalu pawabhi ujendalela mwana waki nkolongwa akabhi akali kungonda. Paakabhi akelabhuka na kuheghale panyumba, akajowini sauti ja nyembu na bhandu bhakina. ");
INSERT INTO mpa_vpl VALUES ("LK15_26","072_15_26","LUK","15","26","26","Bhela akandohiki mtumika jumu na kundalukila, ‘Bho, kubhi na kyane pambane?’ ");
INSERT INTO mpa_vpl VALUES ("LK15_27","072_15_27","LUK","15","27","27","Mtumika jola akamuyangiki, ‘Nnung'una waku akelawiki panyumba, na atati waku achinjiki litole lelinenipi, maghambu mwana waki akelawiki wichu na mwome.’ ");
INSERT INTO mpa_vpl VALUES ("LK15_28","072_15_28","LUK","15","28","28","“Mbeli waki jola akahakalili na kukana kujingi munyumba. Bhela atati waki akapitiki kunja na kumpembalela ajingala munyumba. ");
INSERT INTO mpa_vpl VALUES ("LK15_29","072_15_29","LUK","15","29","29","Nambu jombi akamuyangiki atati waki, ‘Lingalya! Hyaka yokapi nukutumaki ngati nuntumwa, ngachenhoki amuli yaku hata punkamu. Bho, umbeki kyane? Ngacheumbeki hata likenda la imbuhi jimu nahuli nhekalya na bhakochi bhangu! ");
INSERT INTO mpa_vpl VALUES ("LK15_30","072_15_30","LUK","15","30","30","Nambu mwana waku ajoju joapechangini hindu yaku papamu na bhakemi chikahi pe pahikiki unchinjili litoli lelinenipi lela!’ ");
INSERT INTO mpa_vpl VALUES ("LK15_31","072_15_31","LUK","15","31","31","Atati waki akamuyangiki, ‘Mwanango, wehapa ubhi na nepani machobha ghokapi, na hindu yokapi yemi nayu nde yako. ");
INSERT INTO mpa_vpl VALUES ("LK15_32","072_15_32","LUK","15","32","32","Nambu itupaliki kutenda uwangalalu na kuhekalela, maghambu nnung'una waku ajoju akabhi apotile, nambu sajenu abhi mwomi, akabhi ahobhike, nambu sajenu abhonakine.’ ” ");
INSERT INTO mpa_vpl VALUES ("LK16_1","072_16_1","LUK","16","1","1","Yesu akabhapwaghi bhabhulwa bhaki ulenganesu agho, “Pakabhi na mwanahindu yamaheli jumu joakabhi na mlonda wa hindu yaki. Bhandu bhakunchochaki mwanahindu hoju kubha mlonda waki apechangana hindu yaki liyaha. ");
INSERT INTO mpa_vpl VALUES ("LK16_2","072_16_2","LUK","16","2","2","Bhela mwana hindu jola akunkemiki na kumpwaghila, ‘Bho, hagha malobhi bholi ghanyowana panani jako? Nukujopa ubhalanga hindu yangu yokapi yeujopiki na yeubhohiki, maghambu ngacheupalika kabheti kujendalela kubha wa mlonda wa hindu yangu.’ ");
INSERT INTO mpa_vpl VALUES ("LK16_3","072_16_3","LUK","16","3","3","Mlonda jola akaliholalili, ‘Nkolongwa wangu anandopula lihengu la kujemalela. Henu anandenda kike? Ngachemili na makili gha kulemela, na kujenda kujopajopa mona hiyoni. ");
INSERT INTO mpa_vpl VALUES ("LK16_4","072_16_4","LUK","16","4","4","Henu nikimanyi chembalika kuchihenga, nahuli anandopuliki lihengu langu, bhandu bhaweza kunyopalela kunyumba jabhu.’ ");
INSERT INTO mpa_vpl VALUES ("LK16_5","072_16_5","LUK","16","5","5","“Bhela akabhakemiti bhokapi bhabhadaiwa na bambo waki. Akundaluki wa kutumbula, ‘Bho, bambo wangu akudai mbija ilenga?’ ");
INSERT INTO mpa_vpl VALUES ("LK16_6","072_16_6","LUK","16","6","6","Jombi akamuyangiki, ‘Mapipa mia moja gha mahuta gha mizeituni.’ Mlonda jola akumpwaghile, ‘Utola cheti chaku cha lideni, utama pahi na ulemba mapipa hamsini.’ ");
INSERT INTO mpa_vpl VALUES ("LK16_7","072_16_7","LUK","16","7","7","Bhela akundaluki na jongi, ‘Wenga akudai kike?’ Na jombi akamuyangiki, ‘Magunila mia moja gha ingano.’ Mlonda jola akumpwaghile, ‘Utola cheti chaku cha lideni, na ulemba magunila semanini.’ ” ");
INSERT INTO mpa_vpl VALUES ("LK16_8","072_16_8","LUK","16","8","8","“Bhela bambo waka mlonda jola akundumbali mlonda muhakau ndandi akahengiki kila chindu kwa kuchenjela. Maghambu bhandu bha pundema pani bhachenjili nakanopi mukuhenga mambu ghabhu kupeta bhandu bha unang'anu.” ");
INSERT INTO mpa_vpl VALUES ("LK16_9","072_16_9","LUK","16","9","9","Yesu akajendali kupwagha, “Nanatu numpwaghila, ntumila hindu ya pundema pani kwa kulonda bhakochi, nahuli payanjomukya, muweza kujopalewa munyumba ja womi wa mileli. ");
INSERT INTO mpa_vpl VALUES ("LK16_10","072_16_10","LUK","16","10","10","Jokapi joakubha ndongwana kwa mambu machoku, akubha ndongwana bhelabhela kwa mambu makolongwa, na jokapi jwangakubha ndongwana kwa mambu machoku, bhelabhela ngacheaweza kubha ndongwana kwa mambu makolongwa. ");
INSERT INTO mpa_vpl VALUES ("LK16_11","072_16_11","LUK","16","11","11","Bhela anangati mwanganya ngachemwabhi mwalongwana kwa kujemalela hindu ya pundema pani, bho, nane joaweza kukupekeha yela hindu ya chakaka? ");
INSERT INTO mpa_vpl VALUES ("LK16_12","072_16_12","LUK","16","12","12","Ngati ngachemwabhi bhalongwana kwa hindu yaka mundu jongi, bho, nane joampekya hindu hinu mabhete? ");
INSERT INTO mpa_vpl VALUES ("LK16_13","072_16_13","LUK","16","13","13","“Njeta mtumika joaweza kubhatumakila mabambo bhabheli, maghambu ananhwakalya jumu na kumpala jongi, au anaakamulana na jumu na kumpoha lihamu jongi. Ngamuwezi kuntumaki Chapanga na kwitumiki mbija kwa papamu.” ");
INSERT INTO mpa_vpl VALUES ("LK16_14","072_16_14","LUK","16","14","14","Bhela Mafalisayo pabhajowini malobhi ghanihagha, bhakundongimi Yesu, maghambu bhakabhi bhapala mbija. ");
INSERT INTO mpa_vpl VALUES ("LK16_15","072_16_15","LUK","16","15","15","Yesu akabhapwaghile, “Mwanganya mulibhona mabhamdu bhamboni palongi ja bhandu, nambu Chapanga ajimanyi mitima jinu. Maghambu chechibhonikana kubha chamboni palongi ja mihu gha bhandu, Chapanga akibhona kubha chihakau. ");
INSERT INTO mpa_vpl VALUES ("LK16_16","072_16_16","LUK","16","16","16","“Shelia na Malembu gha bhalota bhaka Chapanga ghakatangaziki mbaka chikahi chaka Yohana Mbatizaji. Kutumbu panihapa Malobhi Manyahi gha Ukolongwa waka Chapanga ghatangizwi, na kila mundu aujingi kwa makili. ");
INSERT INTO mpa_vpl VALUES ("LK16_17","072_16_17","LUK","16","17","17","Nambu kupepwiki namaa kwa kunani kumahunde na pundema kupeta, kuliku hata chindu chimu kichokope mu Shelia kubhowakeka. ");
INSERT INTO mpa_vpl VALUES ("LK16_18","072_16_18","LUK","16","18","18","“Mwanalomi jokapi joandeka nhwanu waki na kuntogho mbomba jongi, atenda ugone, na jokapi joantogho mbomba joalekini na ndomi waki, atenda ugone. ");
INSERT INTO mpa_vpl VALUES ("LK16_19","072_16_19","LUK","16","19","19","“Kukabhi na mundu jumu mwanahindu, jonihoju akabhi awata ingobhu ya mbija yamaheli, na kutenda uwangalalu machobha ghokapi. ");
INSERT INTO mpa_vpl VALUES ("LK16_20","072_16_20","LUK","16","20","20","Bhelabhela kukabhi na mundu jumu kahochu joalowakika Lazalo, joakabhi na hilonda hyegha jokapi, bhakabhi bhundeta palongi ja pundyangu wa nyumba jaka mwanahindu jola. ");
INSERT INTO mpa_vpl VALUES ("LK16_21","072_16_21","LUK","16","21","21","Jombi akabhi akatokulya kula imbala yeihabhuka kuhuma panani ja meza jaka mwanahindu jola. Hata nakawa ikaikiki kundambalamba mwilonda yaki. ");
INSERT INTO mpa_vpl VALUES ("LK16_22","072_16_22","LUK","16","22","22","“Lichobha limu kahochu jola akapotile, na bhatumika bha kunani kwaka Chapanga bhakampeliki mbaka pambipi na Ibulahimu. Na mwanahindu jola akapotile, na kuntagha. ");
INSERT INTO mpa_vpl VALUES ("LK16_23","072_16_23","LUK","16","23","23","Paakabhi kuwawa, akabhi ang'ahika namaa, akalingiki kunani na kumbona Ibulahimu cha kutali, na Lazalo akabya pambipi jaki. ");
INSERT INTO mpa_vpl VALUES ("LK16_24","072_16_24","LUK","16","24","24","Bhela akandohiki kwa kujamalila akapwagha, ‘Atati Ibulahimu! Umonila chiha! Untuma Lazalo akajwiha lukonji lwaki mumachi, ahika ahimiya lulimi lwangu, ndandi ning'ahika namaa mu motu ghone!’ ");
INSERT INTO mpa_vpl VALUES ("LK16_25","072_16_25","LUK","16","25","25","“Nambu Ibulahimu akamuyangiki, ‘Mwanango, ukombuka kubha ujomwi kupata mambu manyahi ghaku chikahi cha womi waku, na Lazalo akapatiki mambu mahakau. Na sajenu Lazalo abhi pambani ahekalela, nambu wenga ung'ahakika. ");
INSERT INTO mpa_vpl VALUES ("LK16_26","072_16_26","LUK","16","26","26","Papamu na bhela kubhi na libhomba likolongwa pachilanda jitu na mwenga, nahuli bhabhabhi kongone anabhapai kulomboka konihoku ngabhiweza, kabheti bhabhabhi konihoku anabhapai kulomboka na kuhika kongone ngabhiweza.’ ");
INSERT INTO mpa_vpl VALUES ("LK16_27","072_16_27","LUK","16","27","27","Bhela mwanahindu akapwaghike, ‘Bhela, atati wangu nukujopa, untuma Lazalo kunyumba ja bhalongu bhangu, ");
INSERT INTO mpa_vpl VALUES ("LK16_28","072_16_28","LUK","16","28","28","kwa ndandi monihomu mi na bhalongu nhwano. Undeka ajenda akabhalakalya nahuli ngabhihika pandu pani pamang'ahiku.’ ");
INSERT INTO mpa_vpl VALUES ("LK16_29","072_16_29","LUK","16","29","29","“Ibulahimu akamuyangike, ‘Bhalongu bhaku bhabhi na Musa na bhalota bhaka Chapanga, waleka bhajowanya bhombe.’ ");
INSERT INTO mpa_vpl VALUES ("LK16_30","072_16_30","LUK","16","30","30","Mwanahindu akayangike, ‘Ngabhela atati Ibulahimu, nambu ngati mundu anayokiki na kubhajendela, anabhang'anambukaje na kughaleka mahoku ghabhu.’ ");
INSERT INTO mpa_vpl VALUES ("LK16_31","072_16_31","LUK","16","31","31","Nambu Ibulahimu akumpwaghile, ‘Ngati ngachebhunjowane Musa na bhalota bhaka Chapanga, ngabhijetakeli hata ngati mundu anahyokike.’ ” ");
INSERT INTO mpa_vpl VALUES ("LK17_1","072_17_1","LUK","17","1","1","Yesu akabhapwaghi bhabhulwa bhaki, “Anaipitalya hindu yamaheli yeyampelakya mundu kuhenga mahoku, nambu anaachibhonaje mundu jola joaghatenda ghapitalyaje! ");
INSERT INTO mpa_vpl VALUES ("LK17_2","072_17_2","LUK","17","2","2","Ikabya mbanga mundu hoju akongakika liganga la kuyaghila pahingu na kundeke mu bahali kuliku kuntenda jumu wa bhachoku abhabha atenda mahoku. ");
INSERT INTO mpa_vpl VALUES ("LK17_3","072_17_3","LUK","17","3","3","Kwa ndandi ajeji mulilendaje. “Ngati ndongu waku anaakuhokihi, undakalya, na anaang'anambwiki na kukotoka lihoku laki, undekakyaje. ");
INSERT INTO mpa_vpl VALUES ("LK17_4","072_17_4","LUK","17","4","4","Ngati anaakuhoki mala saba pa lichobha limu, na anaakelawiki mala saba na kupwagha, ‘Ng'anambwiki na kughaleka mahoku ghangu,’ upalika undekakyaje.” ");
INSERT INTO mpa_vpl VALUES ("LK17_5","072_17_5","LUK","17","5","5","Mitumi bhaki bhakumpwaghi Bambo, “Utujonjukya uhobhalelu.” ");
INSERT INTO mpa_vpl VALUES ("LK17_6","072_17_6","LUK","17","6","6","Bambo akapwaghike, “Ngati uhobhalelu winu ukabhi uchoku hata ngati imbeju njoku ja haladali, mukabya muweziki kuupwaghi nkongu wa mtini aghoghu, ‘Utupukaje, na ukalipanda mubahali,’ nawombi ukabya unjetakile. ");
INSERT INTO mpa_vpl VALUES ("LK17_7","072_17_7","LUK","17","7","7","“Tupwagha jumu winu abhi na mundu joandemela mungonda au kundimila mambeleli ghaki. Muhenga lihengu jola paahika kuhuma kungonda, bho, aweza le kumpwaghi, ‘Uhika kinyata, utama pahi, na ukula chilebhe?’ ");
INSERT INTO mpa_vpl VALUES ("LK17_8","072_17_8","LUK","17","8","8","Ngabhela! Jombi anampwaghila, ‘Kutumbula ndelakya chilebhi na undumakya mbaka panijomula kula na kunywa, na panihapa nde uweza kula na kunywa!’ ");
INSERT INTO mpa_vpl VALUES ("LK17_9","072_17_9","LUK","17","9","9","Bho, ngaanchenguli mtumika hoju kwa ndandi ahengiki ghala ghaandaghalakile? ");
INSERT INTO mpa_vpl VALUES ("LK17_10","072_17_10","LUK","17","10","10","Bhelabhela nanamu ananjomwi kuhenga kila chindu chechumpalika kuhenga, mpwagha, ‘Tepani twa bhatumika pela twanga na nyonjeka, tuhengiki pe ghaghapalika tuhengaje.’ ” ");
INSERT INTO mpa_vpl VALUES ("LK17_11","072_17_11","LUK","17","11","11","Yesu paakabhi mumwanja wa kujenda ku Yelusalemu, akapetiki mukulindakani mwa muchi wa Samalia na wa Galilaya. ");
INSERT INTO mpa_vpl VALUES ("LK17_12","072_17_12","LUK","17","12","12","Paakabhi ajingi mu chijiji chimu, akahimangini na bhandu komi bhana malohi. Bhakajemi cha kutali, ");
INSERT INTO mpa_vpl VALUES ("LK17_13","072_17_13","LUK","17","13","13","bhakajamalili, bhakapwaghaje, “Yesu! Bambo utubhonila chiha!” ");
INSERT INTO mpa_vpl VALUES ("LK17_14","072_17_14","LUK","17","14","14","Yesu paakabhaweni, akabhapwaghile, “Njenda mkalilangia kwa bhapenganyambiku.” Pabhakabhi mwindela bhakajendaje, bhakalamike. ");
INSERT INTO mpa_vpl VALUES ("LK17_15","072_17_15","LUK","17","15","15","Jumu wabhu paaliweni kubha alamike, akakelawiki kwaka Yesu koni akundumbalya Chapanga kwa kujamalila. ");
INSERT INTO mpa_vpl VALUES ("LK17_16","072_17_16","LUK","17","16","16","Akalileki pahi palongi ja magholu ghaka Yesu koni akunchengulaje. Mundu jonihoju akabhi Msamalia. ");
INSERT INTO mpa_vpl VALUES ("LK17_17","072_17_17","LUK","17","17","17","Yesu akalalukile, “Bho, nga bhandu komi le bhabhalamike? Bho, tisa bhala bhabhi kwako? ");
INSERT INTO mpa_vpl VALUES ("LK17_18","072_17_18","LUK","17","18","18","Bho, ngacheabhonakini mundu jongi joakelawiki kundumbali Chapanga nambu ngeni ajoju pela?” ");
INSERT INTO mpa_vpl VALUES ("LK17_19","072_17_19","LUK","17","19","19","Bhela Yesu akumpwaghi mundu jola, “Ujemaje, ujendaje, uhobhalelu waku ukulamihe.” ");
INSERT INTO mpa_vpl VALUES ("LK17_20","072_17_20","LUK","17","20","20","Chikahi chimu Mafalisayo bhakundaluki Yesu, “Bho, Ukolongwa waka Chapanga anauhika lile?” Yesu akabhayangike, “Ukolongwa waka Chapanga ngacheuhika kwa kubhonikana kwa mihu. ");
INSERT INTO mpa_vpl VALUES ("LK17_21","072_17_21","LUK","17","21","21","Nga jumu joanawezaje kupwagha, ‘Lingalyaje, ubhi pambane, au ubhi pala.’ Chakaka Ukolongwa waka Chapanga ubhi mkati jinu.” ");
INSERT INTO mpa_vpl VALUES ("LK17_22","072_17_22","LUK","17","22","22","Bhela Yesu akabhapwaghi bhabhulwa bhaki, “Machobha ghahika pamwitokulya kubhona lichobha limu pa machobha ghaka Mwana waka Mundu, nambu ngamwalibhone. ");
INSERT INTO mpa_vpl VALUES ("LK17_23","072_17_23","LUK","17","23","23","Bhandu bhampwaghila, ‘Ndingalya abhi kola!’ Au ‘Ndingalya abhi pambane!’ Nambu ngamwibhoka pambile na kubhajengalela. ");
INSERT INTO mpa_vpl VALUES ("LK17_24","072_17_24","LUK","17","24","24","Kwa ndandi ngati unang'anu wa chitobhi moubhonakela kunani na kumulika kutumbula upambala ghumu mbaka upambala ghongi, bhenibhela nde Mwana waka Mundu moayibhonakanya mu lichobha leanahikaje. ");
INSERT INTO mpa_vpl VALUES ("LK17_25","072_17_25","LUK","17","25","25","Nambu mangani ja mambu ghanihagha ghokapi anaang'ahakika namaa na kukanakika na bhandu bha kibheleku chenu. ");
INSERT INTO mpa_vpl VALUES ("LK17_26","072_17_26","LUK","17","26","26","Ngati mokwabheli pa machobha ghaka Nuhu, nde mokwibhelila pa machobha gha kuhika kwaka Mwana waka Mundu. ");
INSERT INTO mpa_vpl VALUES ("LK17_27","072_17_27","LUK","17","27","27","Machobha ghanighala bhandu bhakabhi bhakula na kunywa, bhakatoghula na kutoghuleka, mbaka lichobha lela Nuhu paajingala mu sitima ngolongwa jejilowakeka safina. Na panihapa iyula ngolongwa jakatonyiki na kubhakoma bhokapi. ");
INSERT INTO mpa_vpl VALUES ("LK17_28","072_17_28","LUK","17","28","28","Kwibya bhenibhela ngati mokwabheli pa machobha ghaka Lutu. Bhandu bhakabhi bhakula na kunywa, bhakalomba na kulombesa, bhakapanda imbeju na kuchenga. ");
INSERT INTO mpa_vpl VALUES ("LK17_29","072_17_29","LUK","17","29","29","Nambu lichobha Lutu paakabhokiki ku Sodoma, motu na maganga ghaghabhelela motu ghakahawiki pahi kuhuma kunani kumahunde na kubhakoma bhokapi. ");
INSERT INTO mpa_vpl VALUES ("LK17_30","072_17_30","LUK","17","30","30","Bhenibhela nde mokwibhelila lichobha lela Mwana waka Mundu paanahikaje. ");
INSERT INTO mpa_vpl VALUES ("LK17_31","072_17_31","LUK","17","31","31","“Mu Lichobha heli, mundu jokapi joayibya kunani ja nhwaghala ngaayihuluka kujingi munyumba na kutola hindu yaki. Bhelabhela mundu joayibya kungonda ngaikelabhuka kunyumba kutola chindu. ");
INSERT INTO mpa_vpl VALUES ("LK17_32","072_17_32","LUK","17","32","32","Mkombuka ghala ghaghumpatiki nhwanu waka Lutu. ");
INSERT INTO mpa_vpl VALUES ("LK17_33","072_17_33","LUK","17","33","33","Mundu jokapi joapala kuukengale womi waki, anauhoaje, nambu mundu jola joapala kuuhoa womi waki, anaukengalyaje. ");
INSERT INTO mpa_vpl VALUES ("LK17_34","072_17_34","LUK","17","34","34","Numpwaghila, ikilu heji, bhandu bhabheli bhibya bhaghoni pachitanda chimu, jumu ayitolakikaje na jongi kuhighalila. ");
INSERT INTO mpa_vpl VALUES ("LK17_35","072_17_35","LUK","17","35","35","Akambomba bhabheli bhibya bhapola mahunu papamu, jumu ayitolakikaje na jongi kuhighalila. ");
INSERT INTO mpa_vpl VALUES ("LK17_36","072_17_36","LUK","17","36","36","Bhandu bhabheli bhibya kungonda, jumu ayitolakikaje na jongi kuhighalila.” ");
INSERT INTO mpa_vpl VALUES ("LK17_37","072_17_37","LUK","17","37","37","Panihapa bhabhulwa bhaki bhakundalukile, “Bambo, bho, mambu ghanihagha ghitendakika kwako?” Yesu akabhayangiki, “Pandu papibya na ntuhi, panihapa nde payalibhongana ngwahe.” ");
INSERT INTO mpa_vpl VALUES ("LK18_1","072_18_1","LUK","18","1","1","Bhela Yesu akabhalandi bhabhulwa bhaki ulenganesu ghongo kwa kubhabhola kubha bhapalika kundobha Chapanga kila lichobha panga na kutonda. ");
INSERT INTO mpa_vpl VALUES ("LK18_2","072_18_2","LUK","18","2","2","Akapwaghike, “Ku muchi ghumu kukabhi na mtemula jumu jwangakunjoghopa Chapanga wala ngacheapalika bhandu. ");
INSERT INTO mpa_vpl VALUES ("LK18_3","072_18_3","LUK","18","3","3","Pa muchi ghonighola, kukabhi na mbomba jumu joaweliwi na ndomi joakabhi anjende mtemula jola panga kutonda na kumpwaghila, ‘Chondi, unyemalya mbata chechibhi changu kuhuma kwaka adui wangu!’ ");
INSERT INTO mpa_vpl VALUES ("LK18_4","072_18_4","LUK","18","4","4","Kwa chikahi chilachu mtemula jola akakaniki kunjangatila mbomba joaweliwi na ndomi jola. Nambu palongi akalilaluki mweni, ‘Hata ngati nepani ngachenunjoghopa Chapanga wala ngachenabhapala bhandu, ");
INSERT INTO mpa_vpl VALUES ("LK18_5","072_18_5","LUK","18","5","5","nambu maghambu mbomba ajoju joaweliwi na ndomi apetali kung'aha ananunjangatya apata chekibhi chaki, nanga bhela anaajendalya kunhikila na kundenda ndondaje!’ ” ");
INSERT INTO mpa_vpl VALUES ("LK18_6","072_18_6","LUK","18","6","6","Bhela Bambo akabhapwaghile, “Njowanya ntundu mtemula muhakau ajo moapwaghile. ");
INSERT INTO mpa_vpl VALUES ("LK18_7","072_18_7","LUK","18","7","7","Bho, Chapanga le ngaabhakengaleli bhahaghulika bhaki, bhabhundelela ikilu na muhi? Bho, anaakabhakya le kwajangatila? ");
INSERT INTO mpa_vpl VALUES ("LK18_8","072_18_8","LUK","18","8","8","Numpwaghi mabhanganya, anabhajangatya manyata. Nambu Mwana waka Mundu paanahikaje, bho, anakubya le na uhobhalelu pani pundema?” ");
INSERT INTO mpa_vpl VALUES ("LK18_9","072_18_9","LUK","18","9","9","Yesu akalongi kabheti ulenganesu aghoghu kwa ndandi ja bhandu bhala bhabhabhi na makoma na kubhalongale mahakau bhajabhu. ");
INSERT INTO mpa_vpl VALUES ("LK18_10","072_18_10","LUK","18","10","10","“Lichobha limu bhandu bhabheli bhakapiti kulobha mu Nyumba jaka Chapanga. Jumu akabhi Mfalisayo na jongi akabhi njopa kode. ");
INSERT INTO mpa_vpl VALUES ("LK18_11","072_18_11","LUK","18","11","11","“Mufalisayo jola akajemiki, koni akalobha mumtima waki ana, ‘Nukuchengu wa Chapanga, maghambu nepani ngachemi ngati bhandu bhangi bhokapi bhabhabhi bhanyaghula, bhabhatenda mahakau, na bhabhatenda ugone. Nukuchengu bhelabhela maghambu nepani ngachemi ngati njopa kode ajoju. ");
INSERT INTO mpa_vpl VALUES ("LK18_12","072_18_12","LUK","18","12","12","Nepani ngonga kula chilebhe machobha ghabheli kwa juma, na moha pandu pa komi pa hindu yangu yokapi yembata.’ ");
INSERT INTO mpa_vpl VALUES ("LK18_13","072_18_13","LUK","18","13","13","“Nambu njopa kode jola akajemiki cha kutali, najombi ngachealengiki hata kulingali kunani kumahunde, nambu akalilapwilapwi pachihimba kwa kumbina mtima na kupwagha, ‘Wenga wa Chapanga, umonila chiha nepani mwana mahoku!’ ” ");
INSERT INTO mpa_vpl VALUES ("LK18_14","072_18_14","LUK","18","14","14","Yesu akajendali kupwagha, “Numpwaghila, mundu ajoju njopa kode akabhujiki kunyumba jaki koni akabya ajetakaliwi palongi jaka Chapanga, nambu nga Mfalisayo jola. Maghambu kila mundu joalikweha, anahelalikaje, nambu kila mundu joaliheleha, anakwehakikaje.” ");
INSERT INTO mpa_vpl VALUES ("LK18_15","072_18_15","LUK","18","15","15","Bhandu bhakundeti Yesu bhana bhachoku nahuli abhabhekila mabhoku na kubhapengalela. Bhabhulwa pabhaweni bhenibhela, bhakabhalakali bhandu bhanibhala. ");
INSERT INTO mpa_vpl VALUES ("LK18_16","072_18_16","LUK","18","16","16","Nambu Yesu akabhakemiki bhana bhahikaje na kupwagha, “Mwaleka bhana bhachoku bhahika kwangu, wala ngamwahibhalila, maghambu Ukolongwa waka Chapanga nde wa bhandu bhabhalengana na bhana. ");
INSERT INTO mpa_vpl VALUES ("LK18_17","072_18_17","LUK","18","17","17","Chakaka numpwaghila, mundu jokapi jwangakujopalela Ukolongwa waka Chapanga ngati mwana nchoku, ngawezi kujingila mu Ukolongwa hoghu ng'o.” ");
INSERT INTO mpa_vpl VALUES ("LK18_18","072_18_18","LUK","18","18","18","Chiongozi jumu wa Bhayahude akundaluki Yesu, “Mbola Wambone, bho, ndenda bhole nahuli mbata womi wa mileli?” ");
INSERT INTO mpa_vpl VALUES ("LK18_19","072_18_19","LUK","18","19","19","Yesu akandalukile, “Bho maghambu ki unoha nepani wambone? Nga mundu joabhi wambone nambu Chapanga kanjika jaki. ");
INSERT INTO mpa_vpl VALUES ("LK18_20","072_18_20","LUK","18","20","20","Wimanyi amule: ‘Ngawitenda ugone, ngawikoma, ngawijibha, ngawilonge ichole, wajinika atati waku na mabhu waku.’ ” ");
INSERT INTO mpa_vpl VALUES ("LK18_21","072_18_21","LUK","18","21","21","Jombi akamuyangiki, “Amuli yokapi ayeyi nikamwi kutumbu uchoku wangu.” ");
INSERT INTO mpa_vpl VALUES ("LK18_22","072_18_22","LUK","18","22","22","Yesu paakajowini ghanihagha, akampwaghile, “Ukepakiwi na chindu chimo. Ujenda ukalombisa hindu yokapi yeubhi nayo, na ukabhaghabhila bhahochu mbija heyi, nanaghu wibya ulibheki chikoku kunani kumahunde. Panihapa nde uhika unyengalyaje.” ");
INSERT INTO mpa_vpl VALUES ("LK18_23","072_18_23","LUK","18","23","23","Nambu mundu jola paakajowini malobhi ghanighala, akayomiki namaa kwa ndandi akabhi na hindu yamaheli. ");
INSERT INTO mpa_vpl VALUES ("LK18_24","072_18_24","LUK","18","24","24","Yesu paakambweni ahakalili nakanopi akapwaghike, “Ntundu bhole mokunonupile kwaka mwanahindu yamaheli kujingi mu Ukolongwa waka Chapanga! ");
INSERT INTO mpa_vpl VALUES ("LK18_25","072_18_25","LUK","18","25","25","Kwa ndandi kupepwiki namaa kwa chinyama chekilowakeka ngamia kuholota mulimboghi la sindano kuliku mwanahindu yamaheli kujingi mu Ukolongwa waka Chapanga.” ");
INSERT INTO mpa_vpl VALUES ("LK18_26","072_18_26","LUK","18","26","26","Bhandu bhabhajowini malobhi ghanighala bhakalalukile, “Bho, henu nde nane joaweza kukengaleka?” ");
INSERT INTO mpa_vpl VALUES ("LK18_27","072_18_27","LUK","18","27","27","Yesu akayangike, “Mambu ghangakuwezikana kwa bhandu, ghawezikana kwaka Chapanga.” ");
INSERT INTO mpa_vpl VALUES ("LK18_28","072_18_28","LUK","18","28","28","Bhela Petulu akapwaghike, “Lingalya! Tepani tuilekiki hindu yitu yokapi na kukujengale wehapa!” ");
INSERT INTO mpa_vpl VALUES ("LK18_29","072_18_29","LUK","18","29","29","Yesu akamuyangiki, “Chakaka numpwaghila, ngati mundu anaajilekiki nyumba jaki, na nhwanu waki, na bhalongu bhaki, na bhabheleka bhaki, na bhana bhaki kwa ndandi ja Ukolongwa waka Chapanga, ");
INSERT INTO mpa_vpl VALUES ("LK18_30","072_18_30","LUK","18","30","30","anaajopalya ghamaheli nakanopi kwa chikahi cha sajenu, na mu ndema ghouhika ayijopalya womi wa mileli.” ");
INSERT INTO mpa_vpl VALUES ("LK18_31","072_18_31","LUK","18","31","31","Yesu akabhatoliki bhabhulwa bhaki komi na bhabheli punkeghi na kubhapwaghila, “Njowanyaje! Tukwela kujenda ku Yelusalemu, na malembu ghokapi ghaghalembakiki na bhalota bhaka Chapanga panani jaka Mwana waka Mundu anaghapitalyaje. ");
INSERT INTO mpa_vpl VALUES ("LK18_32","072_18_32","LUK","18","32","32","Maghambu anabhunkamula na kumpeleka kwa bhandu bha Mataifa, anabhunhekaje, anabhuntondulaje na kunhuni imata. ");
INSERT INTO mpa_vpl VALUES ("LK18_33","072_18_33","LUK","18","33","33","Anabhundapulaje na kunkoma, nambu lichobha la katatu anaayokaje.” ");
INSERT INTO mpa_vpl VALUES ("LK18_34","072_18_34","LUK","18","34","34","Nambu bhabhulwa bhaki ngachebhamanyi ndandi ja malobhi ghanihagha, maghambu malobhi ghanihagha ghakahiyakiki kwabho, na bhombi ngachebhamanyi ngati Yesu alongalya panani ja kike. ");
INSERT INTO mpa_vpl VALUES ("LK18_35","072_18_35","LUK","18","35","35","Yesu paakabhi aheghali muchi wa Yeliko, kukabhi na mundu jumu ngalola akatemi punkeghi ja indela akajopaje. ");
INSERT INTO mpa_vpl VALUES ("LK18_36","072_18_36","LUK","18","36","36","Paakajowini lipogha la bhandu bhakapetaje, akalalukile, “Bho, kubhi na kyane?” ");
INSERT INTO mpa_vpl VALUES ("LK18_37","072_18_37","LUK","18","37","37","Bhakumpwaghile, “Yesu wa ku Nazaleti apeta.” ");
INSERT INTO mpa_vpl VALUES ("LK18_38","072_18_38","LUK","18","38","38","Jombi akajamalili akapwagha, “Yesu! Mwana waka Daude! Umonila chiha!” ");
INSERT INTO mpa_vpl VALUES ("LK18_39","072_18_39","LUK","18","39","39","Bhandu bhabhalonguli bhala bhakundakalili na kumpwaghila atumbalaje. Nambu jombi akajendali kujamalila, akapwagha, “Mwana waka Daude! Umonila chiha!” ");
INSERT INTO mpa_vpl VALUES ("LK18_40","072_18_40","LUK","18","40","40","Yesu akajemiki na kubhalaghalaki bhundeta ngalola jola kwaki. Ngalola jola paakaheghalili pambipi, Yesu akundalukile, ");
INSERT INTO mpa_vpl VALUES ("LK18_41","072_18_41","LUK","18","41","41","“Bho, upala nukuhengila kyane?” Akayangiki, “Bambo, mbala kubhona kabhate.” ");
INSERT INTO mpa_vpl VALUES ("LK18_42","072_18_42","LUK","18","42","42","Yesu akumpwaghile, “Ubhonaje! Uhobhalelu waku ukulamihe.” ");
INSERT INTO mpa_vpl VALUES ("LK18_43","072_18_43","LUK","18","43","43","Palapala ngalola jola akaweziki kulola, na kunjengale Yesu koni akundumbalya Chapanga. Na bhandu bhokapi bhabhaliweni lijambu leniheli, na bhombi bhakundumbali Chapanga. ");
INSERT INTO mpa_vpl VALUES ("LK19_1","072_19_1","LUK","19","1","1","Yesu akajingi mu muchi wa Yeliko na kupeta pachilanda ja muchi hoghu. ");
INSERT INTO mpa_vpl VALUES ("LK19_2","072_19_2","LUK","19","2","2","Konikola kukabhi na mundu jumu lihina laki Zakayo, joakabhi nkolongwa wa bhajopa kode, na mwanahindu yamaheli. ");
INSERT INTO mpa_vpl VALUES ("LK19_3","072_19_3","LUK","19","3","3","Jonihoju akapaliki kumbona Yesu kubha mundu wa ntundu bhole, nambu kwa ndandi akabhi mundu njipi, ngacheaweziki kumbona maghambu bhandu bhakabhi bhamaheli. ");
INSERT INTO mpa_vpl VALUES ("LK19_4","072_19_4","LUK","19","4","4","Bhela akakembili kubhalongulela bhandu, na kukwela mnani ja nkongu wa mtini nahuli ambona Yesu, maghambu Yesu anahika kwa kupete indela jenijela. ");
INSERT INTO mpa_vpl VALUES ("LK19_5","072_19_5","LUK","19","5","5","Yesu paakahikiki pandu panipala, akalingali mnani na kumpwaghila, “Zakayo, uhuluka manyata, ndandi laleno imbalika kupilakila munyumba jako.” ");
INSERT INTO mpa_vpl VALUES ("LK19_6","072_19_6","LUK","19","6","6","Bhela Zakayo akahulwiki manyata, akahelili na kunjopale kwa chiheku chikolongwa. ");
INSERT INTO mpa_vpl VALUES ("LK19_7","072_19_7","LUK","19","7","7","Bhandu bhokapi bhabhaghaweni ghanihagha bhakatumbwi kung'ong'uteka bhakapwaghaje, “Apiti kutama kwaka mundu mwana mahoku!” ");
INSERT INTO mpa_vpl VALUES ("LK19_8","072_19_8","LUK","19","8","8","Nambu Zakayo akajemi na kumpwaghi Bambo, “Lingalyaje, Bambo! Ananabhapekya bhahochu nusu ja hindu yangu, na ngati nakatoliki chindu chaka mundu kwa kukolowa, ananunkelabhukya mala pachechi pa chindu chaki.” ");
INSERT INTO mpa_vpl VALUES ("LK19_9","072_19_9","LUK","19","9","9","Yesu akumpwaghile, “Lalenu ukengaleku ujingi mu nyumba moni, kwa ndandi mundu ajoju najombi nde mwana waka Ibulahimu. ");
INSERT INTO mpa_vpl VALUES ("LK19_10","072_19_10","LUK","19","10","10","Kwa ndandi Mwana waka Mundu ahikiki kulonda na kukengalela bhandu bhala bhabhahobhiki.” ");
INSERT INTO mpa_vpl VALUES ("LK19_11","072_19_11","LUK","19","11","11","Bhandu pabhajowini malobhi ghanihagha, Yesu akajonjuki kupwagha kwa ulenganesu, maghambu akabhi pambipi na muchi wa Yelusalemu, na bhandu bhala bhahambukya kubha Ukolongwa waka Chapanga uhika chikahi chelachela. ");
INSERT INTO mpa_vpl VALUES ("LK19_12","072_19_12","LUK","19","12","12","Bhela akabhapwaghile, “Kukabhi na mundu jumu wa lukolu lwa kikolongwa joakapiti ku inchi ja kutali nahuli akajopalya ukolongwa na kukelabhuka. ");
INSERT INTO mpa_vpl VALUES ("LK19_13","072_19_13","LUK","19","13","13","Bhela paakabhi akona ngakubhoka, akabhalohiki bhatumika bhaki komi na kubhapeke mbija kila jumu wabhu na kubhapwaghila, ‘Muhemala hindu na kulombesa mbaka panikelebhukaje.’ ");
INSERT INTO mpa_vpl VALUES ("LK19_14","072_19_14","LUK","19","14","14","Nambu bhandu bha muchi waki bhakatehi kunhakalila, na bhela bhakabhatumiki bhabholu bhajenda bhakapwaghaje, ‘Ngachetumpala mundu ajoju atutawalaje.’ ");
INSERT INTO mpa_vpl VALUES ("LK19_15","072_19_15","LUK","19","15","15","“Nambu mundu jola akaupatiki ukolongwa na kukelabhuka. Akabhalohiki bhatumika bhala bhaakabhapeki mbija nahuli apata kumanya kila mundu apatiki nyonjeka bhole. ");
INSERT INTO mpa_vpl VALUES ("LK19_16","072_19_16","LUK","19","16","16","Mtumika wa kutumbula akahikiki na kupwagha, ‘Bambo, mbatiki nyonjeka komi yengi ya mbija yewambekie.’ ");
INSERT INTO mpa_vpl VALUES ("LK19_17","072_19_17","LUK","19","17","17","Jombi akumpwaghile, ‘Uhengiki wichu, wenga wantumika wambone! Maghambu ukabhi undongwana kwa chindu kichoku, nukubheka ubya unkolongwa wa michi komi.’ ");
INSERT INTO mpa_vpl VALUES ("LK19_18","072_19_18","LUK","19","18","18","Mtumika wa kabheli akahikiki na kupwagha, ‘Bambo, mbatiki nyonjeka nhwanu nakanopi kwa mbija jewambekie.’ ");
INSERT INTO mpa_vpl VALUES ("LK19_19","072_19_19","LUK","19","19","19","Jombi akampwaghile, ‘Na wenga bhelabhela nukubheka ubya unkolongwa wa michi nhwano.’ ");
INSERT INTO mpa_vpl VALUES ("LK19_20","072_19_20","LUK","19","20","20","“Mtumika wa katatu akahikiki na kupwagha, ‘Bambo, jenje nde mbija jaku, jenakajihiiki wichu mu chitambala. ");
INSERT INTO mpa_vpl VALUES ("LK19_21","072_19_21","LUK","19","21","21","Nukujoghupa wehapa, maghambu wa mundu unkale. Wenga wa mundu we utola yangakubha yaku na kuhuna yangakupanda.’ ");
INSERT INTO mpa_vpl VALUES ("LK19_22","072_19_22","LUK","19","22","22","Bambo waki akampwaghile, ‘Wehapa wa mtumika muhakao! Nukutemula kubhokana na malobhi ghaku! Wamanyiki kubha nepani na mundu nunkali, nendola hindu yangu na kuhuna yangakupanda. ");
INSERT INTO mpa_vpl VALUES ("LK19_23","072_19_23","LUK","19","23","23","Bho, maghambu ja kyane ngachewabhei mbija jangu kubenki, nahuli lichobha la kukelebhuka kwangu nakapata mbija jangu papamu na nyonjeka jake?’ ");
INSERT INTO mpa_vpl VALUES ("LK19_24","072_19_24","LUK","19","24","24","“Bhela akabhapwaghi bhabhajemi pambipi, ‘Munyaghula mbija heji kuhuma kwaki na mukumpekya jola joapatiki nyonjokela komi.’ ");
INSERT INTO mpa_vpl VALUES ("LK19_25","072_19_25","LUK","19","25","25","Bhombi bhakumpwaghile, ‘Nambu Bambo, jonihoju abhi nayu tayale nyonjeka komi!’ ");
INSERT INTO mpa_vpl VALUES ("LK19_26","072_19_26","LUK","19","26","26","Jombi akayangiki, ‘Kila mundu joabhi na chindu anajonjukiwa chengi, nambu mundu jwangakubha na chindu ananyaghulika hata kichokopi cheabhi naku. ");
INSERT INTO mpa_vpl VALUES ("LK19_27","072_19_27","LUK","19","27","27","Henu kwa bhala maadui bhangu, bhangakupala nepani mya nunkolongwa wabhu, mwabhaleta pambani, na mwakoma palongi jangu!’ ” ");
INSERT INTO mpa_vpl VALUES ("LK19_28","072_19_28","LUK","19","28","28","Yesu paakajomwi kulonge malobhi ghanihagha, akabhalonguli palongi jabhu na kujenda ku Yelusalemu. ");
INSERT INTO mpa_vpl VALUES ("LK19_29","072_19_29","LUK","19","29","29","Paakaheghali kuhika ku Besifage na ku Besania pambipi na Chitombi cha Mizeituni, Yesu akabhatumiki bhabheli pachilanda ja bhabhulwa bhaki, ");
INSERT INTO mpa_vpl VALUES ("LK19_30","072_19_30","LUK","19","30","30","na kubhapwaghila, “Njendanya ku chijiji chela chemukibhona, pamkahika konikola mkalihimanya liponda likongakiki na njeta mundu joalabhali kujendela. Mukalibhopula na kulileta pambane. ");
INSERT INTO mpa_vpl VALUES ("LK19_31","072_19_31","LUK","19","31","31","Ngati mundu anaandalukile, ‘Maghambu ki mulibhopo liponda heli?’ Mumpwaghila, ‘Bambo alipala.’ ” ");
INSERT INTO mpa_vpl VALUES ("LK19_32","072_19_32","LUK","19","32","32","Bhela bhala bhabhatumakiki kujenda bhakahimani kila chindu kibhi ngati Yesu moakapwaghile. ");
INSERT INTO mpa_vpl VALUES ("LK19_33","072_19_33","LUK","19","33","33","Pabhakabhi bhalibhopo liponda lela, bheni labhu bhakabhalalukile, “Ndandi ki mulibhopo liponda heli?” ");
INSERT INTO mpa_vpl VALUES ("LK19_34","072_19_34","LUK","19","34","34","Bhakayangiki, “Bambo alipala.” ");
INSERT INTO mpa_vpl VALUES ("LK19_35","072_19_35","LUK","19","35","35","Bhela bhakalipeliki kwaka Yesu liponda lela, na bhandu bhakatandiki ingobhu yabhu pangongu wa liponda na kunkwea Yesu panani jaki. ");
INSERT INTO mpa_vpl VALUES ("LK19_36","072_19_36","LUK","19","36","36","Paakabhi ajendalela na mwanja, bhandu bhakatandiki ingobhu yabhu mwindela. ");
INSERT INTO mpa_vpl VALUES ("LK19_37","072_19_37","LUK","19","37","37","Paakabhi pambipi na muchi wa Yelusalemu, punhelelu wa Chitombi cha Mizeituni, lipogha lokapi la bhabhulwa bhakahekalili na kundumbali Chapanga kwa kujamalila, kwa ndandi ja ngangachu yokapi yebhiwene. ");
INSERT INTO mpa_vpl VALUES ("LK19_38","072_19_38","LUK","19","38","38","Bhakapwaghaje, “Apengalikaje Nkolongwa joahika kwa lihina laka Bambo! Lukwali kunani kumahunde na ulumbalilu kunani nakanope!” ");
INSERT INTO mpa_vpl VALUES ("LK19_39","072_19_39","LUK","19","39","39","Bhela Mafalisayo bhangi bhabhakabhi panipala papamu na lipogha la bhandu lela bhakumpwaghi Yesu, “Mbola, ubhalakalyaje bhabhulwa bhaku bhatumbalaje!” ");
INSERT INTO mpa_vpl VALUES ("LK19_40","072_19_40","LUK","19","40","40","Yesu akabhayangike, “Numpwaghi mabhanganya, anangati bhandu abhabha anabhatumbile, maganga aghagha anaghajamalyaje.” ");
INSERT INTO mpa_vpl VALUES ("LK19_41","072_19_41","LUK","19","41","41","Yesu paakaheghali ku Yelusalemu na kuubhona muchi, akaulelile, ");
INSERT INTO mpa_vpl VALUES ("LK19_42","072_19_42","LUK","19","42","42","akapwaghaje, “Ngati wenga ukamanyiki lalenu mambu ghaghaleta lukwali! Nambu sajenu mambu hagha ghahiyakika pamihu jaku. ");
INSERT INTO mpa_vpl VALUES ("LK19_43","072_19_43","LUK","19","43","43","Maghambu machobha ghahika maadui bhaku pabhichenga lumatu, anabhukuyongalutaje, na kukuhinya ipambala yokapi. ");
INSERT INTO mpa_vpl VALUES ("LK19_44","072_19_44","LUK","19","44","44","Pabhakuyagha wenga papamu na bhana bhaku mu lumatu lwaku. Ngabhakulekeli hata lighanga limu panani ja lengi, maghambu ngachewamanyi chikahi Chapanga paakahiki kukukengalela!” ");
INSERT INTO mpa_vpl VALUES ("LK19_45","072_19_45","LUK","19","45","45","Bhela Yesu akapiti pa Nyumba jaka Chapanga na kutumbu kubhapiha kunja bhabhahemela na kulombesa. ");
INSERT INTO mpa_vpl VALUES ("LK19_46","072_19_46","LUK","19","46","46","Jombi akabhapwaghile, “Ilembakiki mu Malembu Mahuhu, ‘Nyumba jangu anajibya nyumba ja malobhu.’ Nambu mwanganya mujibhei kubha likolu la bhanyaghula!” ");
INSERT INTO mpa_vpl VALUES ("LK19_47","072_19_47","LUK","19","47","47","Yesu akabhi abhola kila lichobha pa Nyumba jaka Chapanga. Nambu bhapenganyambiku bhakolongwa, bhabhola bha Shelia papamu na bhakolongwa bha bhandu bhakalondiki indela ja kunkoma, ");
INSERT INTO mpa_vpl VALUES ("LK19_48","072_19_48","LUK","19","48","48","nambu ngachebhapatiki indela ja kunkoma, maghambu bhandu bhokapi bhakabhi bhunjowanela kwa wichu nakanopi. ");
INSERT INTO mpa_vpl VALUES ("LK20_1","072_20_1","LUK","20","1","1","Lichobha limu Yesu akabhi pa Nyumba jaka Chapanga, akabhatangazya bhandu Malobhi Manyahi. Bhapenganyambiku bhakolongwa na bhabhola bha Shelia papamu na bhakolongwa bha bhandu bhakunhikile, ");
INSERT INTO mpa_vpl VALUES ("LK20_2","072_20_2","LUK","20","2","2","na kundalukila, “Utupwaghilaje! Bho, uhenga mambu ghanihagha kwa lujiniku lwaka nane? Na bho, nane joakupeki lujiniku loniholo?” ");
INSERT INTO mpa_vpl VALUES ("LK20_3","072_20_3","LUK","20","3","3","Yesu akabhayangiki, “Na nenga ananundalukya lilaluki limu. Mbwaghilaje, ");
INSERT INTO mpa_vpl VALUES ("LK20_4","072_20_4","LUK","20","4","4","bho, ubatizu waka Yohana ukahumiki kwaka Chapanga au kwa bhandu?” ");
INSERT INTO mpa_vpl VALUES ("LK20_5","072_20_5","LUK","20","5","5","Nambu bhombi bhakapwaghani ana, “Anatupwaghiki ukahumiki kwaka Chapanga, anaatulalukya, ‘Bho, mbona ngachemunhobhalile Yohana?’ ");
INSERT INTO mpa_vpl VALUES ("LK20_6","072_20_6","LUK","20","6","6","Nambu anatupwaghiki, ‘Ukahumiki kwa bhandu,’ bhandu bhokapi anabhutulapula maganga, maghambu bhokapi bhahobhalela kubha Yohana akabhi nde mlota waka Chapanga.” ");
INSERT INTO mpa_vpl VALUES ("LK20_7","072_20_7","LUK","20","7","7","Bhela bhakumpwaghile, “Ngachetumanyi ukahumiki kwako.” ");
INSERT INTO mpa_vpl VALUES ("LK20_8","072_20_8","LUK","20","8","8","Yesu akabhapwaghile, “Hata nenga nganumpwaghi kubha ndenda mambu ghangane kwa lujiniku lwaka nane.” ");
INSERT INTO mpa_vpl VALUES ("LK20_9","072_20_9","LUK","20","9","9","Yesu akajendali kubhapwaghi bhandu ulenganesu agho, “Mundu jumu akapandiki ngonda wa mizabibu. Akabhajahiki bhalemi ngonda ghola, na kutumbu mwanja wa kujenda ku inchi jengi na kutama konihoku kwa chikahi chilachu. ");
INSERT INTO mpa_vpl VALUES ("LK20_10","072_20_10","LUK","20","10","10","Chikahi cha mahunu pachahikili, akuntumiki mtumwa waki kwa bhalemi bhala, nahuli akatola pandu pa mahunu gha mizabibu. Nambu bhalemi bhakundapwi mtumwa jola na kunkelebhu mabhoku matopu. ");
INSERT INTO mpa_vpl VALUES ("LK20_11","072_20_11","LUK","20","11","11","Mweni ngonda jola akuntumiki mtumwa jongi, nambu jonihoju najombi bhelabhela bhakundapwili na kuntende mambu gha iyoni, na kunkelabhu mabhoku matopu. ");
INSERT INTO mpa_vpl VALUES ("LK20_12","072_20_12","LUK","20","12","12","Akumtumiki kabheti mtumika wa katatu, jonihoju najombi, bhakumpotiki na kuntopola. ");
INSERT INTO mpa_vpl VALUES ("LK20_13","072_20_13","LUK","20","13","13","Bhela mweni ngonda jola akapwaghike, ‘Bho, anandenda bhole? Ananuntuma mwana wangu jonumpalike, pangi anabhuntopilaje jombi.’ ");
INSERT INTO mpa_vpl VALUES ("LK20_14","072_20_14","LUK","20","14","14","Nambu bhalemi bhala pabhumbweni akahikaje, bhakapwaghanile, ‘Ajoju nde mpwelelu wa ngonda. Bhela tunkomaje nahuli upwelelu waki ubya witu.’ ");
INSERT INTO mpa_vpl VALUES ("LK20_15","072_20_15","LUK","20","15","15","Bhela bhakunkamwili na kumpiha kunja ja ngonda wa mizabibu na kunkoma.” Yesu akalalukile, “Bho, mweni ngonda anaabhatenda kyani bhalemi bhanihabha? ");
INSERT INTO mpa_vpl VALUES ("LK20_16","072_20_16","LUK","20","16","16","Anahika na kubhakoma bhalemi habha, na kubhapeke bhalemi bhangi ngonda wa mizabibu hoghu.” Bhandu pabhajowini ulenganesu hoghu, bhakapwaghike, “Ngabhela! Chapanga ajepisha kutali mambu ghanihagha ngaghipitalila.” ");
INSERT INTO mpa_vpl VALUES ("LK20_17","072_20_17","LUK","20","17","17","Nambu Yesu akabhalingalakili na kubhalalukila, “Bho, Malembu hagha ndandi jaki kike? ‘Lighanga lebhalikaniki bhachenga, sajenu libhi lighanga likolongwa lelipalika nakanopi.’ ");
INSERT INTO mpa_vpl VALUES ("LK20_18","072_20_18","LUK","20","18","18","Mundu jokapi joanahabhuka panani ja lighanga heli, anatunyukana ipandi ipandi, na mundu jolanhwabhukya lighanga heli, analunhyagha nakanope.” ");
INSERT INTO mpa_vpl VALUES ("LK20_19","072_20_19","LUK","20","19","19","Bhabhola bha Shelia na bhapenganyambiku bhakolongwa bhakapaliki kunkamu Yesu palapala, maghambu bhakamanyi kubha ulenganesu hoghu walongale bhombe, nambu bhabhajoghupa bhandu. ");
INSERT INTO mpa_vpl VALUES ("LK20_20","072_20_20","LUK","20","20","20","Bhela bhakatumbwi kunjobhale Yesu, bhakabhatumiki bhandu bhakopunganya kubha bhamboni nahuli bhunkamula Yesu kwa malobhi ghaki, nahuli bhumpeleka kwaka nkolongwa wa inchi ja ku Loma. ");
INSERT INTO mpa_vpl VALUES ("LK20_21","072_20_21","LUK","20","21","21","Bhandu bhala bhakundaluki Yesu, “Mbola, tumanyi kubha ulongela na kubhola malobhi gha chakaka. Bhelabhela wehapa ngacheulingali lujiniku lwaka mundu, nambu ubhola indela ja chakaka ngati Chapanga moapali bhandu tutamaje. ");
INSERT INTO mpa_vpl VALUES ("LK20_22","072_20_22","LUK","20","22","22","Tupwaghilaje, bho, wichu le kwitu tepani kulepa kode kwaka Kaisali au ngatwilepa?” ");
INSERT INTO mpa_vpl VALUES ("LK20_23","072_20_23","LUK","20","23","23","Nambu Yesu akaumanyi uhakau wabhu, akabhapwaghile, ");
INSERT INTO mpa_vpl VALUES ("LK20_24","072_20_24","LUK","20","24","24","“Mnangiya lingengelema la mbija. Bho, jibhi na sula na lihina laka nane?” Na bhombi bhakayangiki, “Jaka Kaisali.” ");
INSERT INTO mpa_vpl VALUES ("LK20_25","072_20_25","LUK","20","25","25","Bhela Yesu akabhapwaghile, “Bhela mumpekya Kaisali, yeibhi yaki Kaisali, na mumpekya Chapanga yeibhi yaki Chapanga.” ");
INSERT INTO mpa_vpl VALUES ("LK20_26","072_20_26","LUK","20","26","26","Bhela bhandu bhala ngachebhaweziki kunkamula kwa chela cheakalongi palongi ja bhandu, nambu bhakakangichi na liyangu laki, na bhombi bhakatumbile. ");
INSERT INTO mpa_vpl VALUES ("LK20_27","072_20_27","LUK","20","27","27","Masadukayo bhakumu, bhabhapwagha kubha bhakuwa ngabhiyoki, bhakunjendi Yesu na kundalukila, ");
INSERT INTO mpa_vpl VALUES ("LK20_28","072_20_28","LUK","20","28","28","“Mbola, Musa akatulaghalaki ana, ‘Ngati ndongu waka mundu anapotili na kundeka nhwanu waki panga mwana, ndongu waki apalika antoghula mbomba joaweliwi na ndomi jola nahuli ambelakya bhana ndongu waki joapoti jola.’ ");
INSERT INTO mpa_vpl VALUES ("LK20_29","072_20_29","LUK","20","29","29","Bhela kukabhi na bhalongu saba, wa kutumbula akatowili na kupotela panga kupata bhana. ");
INSERT INTO mpa_vpl VALUES ("LK20_30","072_20_30","LUK","20","30","30","Ndongu wa kabhele akuntowi joaweliwi na ndomi jola, najombi akapotoli panga kupata bhana, ");
INSERT INTO mpa_vpl VALUES ("LK20_31","072_20_31","LUK","20","31","31","na ndongu wa katatu najombi kukabhi bhelabhela. Mambu ghakabhi ghalaghala kwa bhokapi saba na bhokapi bhakapotili panga kubhaleka bhana. ");
INSERT INTO mpa_vpl VALUES ("LK20_32","072_20_32","LUK","20","32","32","Pakujomukela jaki mbomba jola akapotile. ");
INSERT INTO mpa_vpl VALUES ("LK20_33","072_20_33","LUK","20","33","33","Henu palichobha bhakuwa pabhiyokaje, mbomba jonihoju anabya nhwanu waka nane? Maghambu bhokapi saba bhakabhi bhuntowile.” ");
INSERT INTO mpa_vpl VALUES ("LK20_34","072_20_34","LUK","20","34","34","Yesu akabhayangike, “Bhandu bha pundema pani bhatoghola na kutoghuleka. ");
INSERT INTO mpa_vpl VALUES ("LK20_35","072_20_35","LUK","20","35","35","Nambu kwa bhala ambabhu Chapanga abhabhona kubha bhapalika kuyoka na kubha bhomi pa ndema ghouhika, ngabhitogholi wala kutoghuleka. ");
INSERT INTO mpa_vpl VALUES ("LK20_36","072_20_36","LUK","20","36","36","Kutumbu panihapa ngabhikuwi kabhete. Maghambu bhibya ngati bhatumika bha kunani kumahunde bhaka Chapanga. Na bhombi nde bhana bhaka Chapanga, maghambu bhatehi kuyohakeka. ");
INSERT INTO mpa_vpl VALUES ("LK20_37","072_20_37","LUK","20","37","37","Nambu kupwagha kubha bhakuwa bhiyokaje, hata Musa akalangi hotuhotu mu Malembu Mahuhu panani ja lijambu leniheli, kubhokana na kihole chekibhelala motu. Jombi andongale Bambo kubha ngati nde, ‘Chapanga waka Ibulahimu, Chapanga waka Isaka na Chapanga waka Yakobo.’ ");
INSERT INTO mpa_vpl VALUES ("LK20_38","072_20_38","LUK","20","38","38","Jombi nga Chapanga wa bhabhawile, nambu jombi nde Chapanga wa bhabhabhi bhome, maghambu kwaki jombi bhokapi bhakubha bhome.” ");
INSERT INTO mpa_vpl VALUES ("LK20_39","072_20_39","LUK","20","39","39","Bhabhola bhakumu bha Shelia bhakapwaghike, “Mbola, uyangiki wichu!” ");
INSERT INTO mpa_vpl VALUES ("LK20_40","072_20_40","LUK","20","40","40","Nga mundu joakalengiki kabheti kundaluki malobhi ghange. ");
INSERT INTO mpa_vpl VALUES ("LK20_41","072_20_41","LUK","20","41","41","Yesu akajendali kubhapwaghila, “Bho, kubhi bholi bhandu bhapwagha kubha Kristo nde Mwana waka Daude? ");
INSERT INTO mpa_vpl VALUES ("LK20_42","072_20_42","LUK","20","42","42","Daude mweni akapwaghiki mu chitabu cha Zabuli, ‘Bambo akumpwaghi Bambo wangu, Utama upambala wangu wa kumalelelu, ");
INSERT INTO mpa_vpl VALUES ("LK20_43","072_20_43","LUK","20","43","43","mbaka panabhabheka maadui bhaku pahi ja magholu ghaku.’ ");
INSERT INTO mpa_vpl VALUES ("LK20_44","072_20_44","LUK","20","44","44","Ngati Daude akandohiki Kristo ‘Bambo,’ henu ayibya bho mwana wake?” ");
INSERT INTO mpa_vpl VALUES ("LK20_45","072_20_45","LUK","20","45","45","Bhandu bhokapi pabhakabhi bhunjowanela, Yesu akabhapwaghi bhabhulwa bhaki, ");
INSERT INTO mpa_vpl VALUES ("LK20_46","072_20_46","LUK","20","46","46","“Mulijepa na bhabhola bha Shelia bhabhapala kujenda koni bhakabya bhawati ingobhu ilachu na kupala kulamukiwa na bhandu kwa kutopela paligulio, bhelabhela bhapala kutama kwitehu ya kutopela mu nyumba ja kuhimangani Bhayahude na pandu pakutopela pa uwangalalu wa chilebhe. ");
INSERT INTO mpa_vpl VALUES ("LK20_47","072_20_47","LUK","20","47","47","Bhakula mu nyumba ya bhabhaweliwi na bhalomi bhabhu, na kwa undumila kubheli bhalobha malobhu malachu. Bhanganya bhanihabha bhitemuliwa nakanopi!” ");
INSERT INTO mpa_vpl VALUES ("LK21_1","072_21_1","LUK","21","1","1","Yesu akabhalingali na kubhabhona bhandu bhanahindu yamaheli bhakabheka nhupu yabhu mu chikoku cha pa Nyumba jaka Chapanga. ");
INSERT INTO mpa_vpl VALUES ("LK21_2","072_21_2","LUK","21","2","2","Bhelabhela akumbweni kabheti mbomba jumu kahochu joaweliwi na ndomi akajeghala sendi ibheli ichoku mu chikoku mola. ");
INSERT INTO mpa_vpl VALUES ("LK21_3","072_21_3","LUK","21","3","3","Yesu akapwaghike, “Chakaka numpwaghila, mabhu ajoju kahochu joaweliwi na ndomi ajeghi nakanopi kupeta bhandu bhangi bhokapi. ");
INSERT INTO mpa_vpl VALUES ("LK21_4","072_21_4","LUK","21","4","4","Kwa ndandi bhandu bhangi bhokapi bhabhekiki nhupu yabhu kubhokana na kujoloka kwa hindu yabhu, nambu mabhu ajoju papamu najombi kubha kahochu, abhohiki kila chindu cheabhi nanchu kwa ndandi ja matamu ghaki.” ");
INSERT INTO mpa_vpl VALUES ("LK21_5","072_21_5","LUK","21","5","5","Bhabhulwa bhakumu bhaka Yesu bhakabhi bhalongelongela panani ja Nyumba jaka Chapanga, bhakapwaghaje panani ja machengu ghaki manyahi gha maganga na kwa hindu yengi inyahi bhandu yebhakabhohiki nhupu kwaka Chapanga. Nambu Yesu akapwaghike, ");
INSERT INTO mpa_vpl VALUES ("LK21_6","072_21_6","LUK","21","6","6","“Mambu aghagha ghamughabona, chikahi anachihikaje ambapu njeta liganga hata limu leanalihighalya panani ja liganga lengi, kila limu analibombuliwaje.” ");
INSERT INTO mpa_vpl VALUES ("LK21_7","072_21_7","LUK","21","7","7","Bhandu bhakundaluki Yesu, “Mbola, bho, mambu ghanihagha ghaulongile ghibya lile? Bho, nginyulila bholi yeilangia kubha mambu ghanihagha ghabhi pambipi kupitalila?” ");
INSERT INTO mpa_vpl VALUES ("LK21_8","072_21_8","LUK","21","8","8","Yesu akabhayangiki, “Mulilingalya wichu ngamwikoluweka. Bhandu bhamaheli anabhahikaje bhakaliloha kwa lihina langu, bhakapwaghaje, ‘Nepani nde Kristo, na kubha chikahi hechi chiheghalile.’ Nambu mwanganya ngamwajengalela. ");
INSERT INTO mpa_vpl VALUES ("LK21_9","072_21_9","LUK","21","9","9","Pamwijowana mambu gha ngondu na fujo, ngamwijoghopa, maghambu ipalika ghanihagha kupitalila hoti nambu ujomukelu wibya wakale.” ");
INSERT INTO mpa_vpl VALUES ("LK21_10","072_21_10","LUK","21","10","10","Bhela Yesu akajendali kupwagha, “Bhandu bha inchi jimu anabhakomana na bhandu bha inchi najengi, na ukolongwa ghumu wikomana na ukolongwa ghongi. ");
INSERT INTO mpa_vpl VALUES ("LK21_11","072_21_11","LUK","21","11","11","Anakubya na chinyukunyuku chikolongwa cha ndema pandu patalipatali, injala ngolongwa na hitamu ya kujambukila pandu pokapi. Kubhoke panihapa kwibya na mambu gha kujoghoha na nginyulila ngolongwa kuhuma kunani kumahunde. ");
INSERT INTO mpa_vpl VALUES ("LK21_12","072_21_12","LUK","21","12","12","Nambu mambu ghanihagha ghokapi ghakabya ghakona nga kupitalila, bhankamula na kung'aha. Bhampelaka munyumba ya kuhimangani Bhayahude na kunjeghe muchifungo, bhelabhela anabhumpelaka palongi ja bhakolongwa na bhatawala kwa ndandi ja lihina langu. ");
INSERT INTO mpa_vpl VALUES ("LK21_13","072_21_13","LUK","21","13","13","Kupetela ghanihagha mwabhatangazya Malobhi Manyahi. ");
INSERT INTO mpa_vpl VALUES ("LK21_14","072_21_14","LUK","21","14","14","Nambu ngamwijoghopa mu mitima jinu ntundu momwilongalyaje. ");
INSERT INTO mpa_vpl VALUES ("LK21_15","072_21_15","LUK","21","15","15","Maghambu nepani ananumpekya malobhi gha kulongela na mbulau. Hata maadui bhinu ngabhiwezi kughapenga wala kughakana. ");
INSERT INTO mpa_vpl VALUES ("LK21_16","072_21_16","LUK","21","16","16","Nanamu anankanakika hata na bhabheleka bhinu, na bhalongu bhinu, na bhakochi bhinu na bhandu bha pambipi jinu, na bhangi bhinu mwitenda kukomakeka. ");
INSERT INTO mpa_vpl VALUES ("LK21_17","072_21_17","LUK","21","17","17","Bhandu bhokapi anabhunhwakalya kwa ndandi ja lihina langu. ");
INSERT INTO mpa_vpl VALUES ("LK21_18","072_21_18","LUK","21","18","18","Nambu njeta hata lijunju limu la mimutu jinu lelihobhaje. ");
INSERT INTO mpa_vpl VALUES ("LK21_19","072_21_19","LUK","21","19","19","Kwa kuhinakila kwinu anankengalya roho hinu. ");
INSERT INTO mpa_vpl VALUES ("LK21_20","072_21_20","LUK","21","20","20","“Chikahi pamwibhona bhandu bha muchi wa Yelusalemu bhayongalwitwi na manjolinjoli, mmanya kubha kuyonangeka kwabhu kuheghalile. ");
INSERT INTO mpa_vpl VALUES ("LK21_21","072_21_21","LUK","21","21","21","Panihapa bhandu bhabhabhi ku Yudea bhatilila ku itombi, na bhandu bhala bhabhabhi mu muchi bhatilila kunja ja muchi, na bhandu bhala bhabhabhi kumighonda ngabhikelabhuka kumuchi. ");
INSERT INTO mpa_vpl VALUES ("LK21_22","072_21_22","LUK","21","22","22","Maghambu machobha hagha ghibya ‘Machobha gha Utemulo,’ nahuli mambu ghokapi ghaghalembakiki mu Malembu Mahuhu ghapitalyaje. ");
INSERT INTO mpa_vpl VALUES ("LK21_23","072_21_23","LUK","21","23","23","Anabhachibhonaje bhana hitumbu na bhabhajongeya mu machobha ghanihagha! Maghambu kwibya na ulale pundema na Chapanga ayilangiya inyela yaki kwa bhandu bha ndema ghoni. ");
INSERT INTO mpa_vpl VALUES ("LK21_24","072_21_24","LUK","21","24","24","Bhangi bhikomakika kwa lipanga, bhangi bhitolakika kubha bhakongeka ku inchi yokapi, bhelabhela bhandu bhangakubha Bhayahude anabhakanyata muchi wa Yelusalemu mbaka chikahi chabhu pachijomukaje. ");
INSERT INTO mpa_vpl VALUES ("LK21_25","072_21_25","LUK","21","25","25","“Bhela kwibya na nginyulila ku lyobha, na mwehi, na ndondwa. Bhandu bha pundema bhibya na mang'ahiku kwa ndandi ja choghohi cha kubuluma kwa bahali na majegha ghaki. ");
INSERT INTO mpa_vpl VALUES ("LK21_26","072_21_26","LUK","21","26","26","Bhandu bhizimiya kwa ndandi ja choghohi, bhakalendalya mambu ghaghihika pundema wokapi, maghambu hindu ya kunani hinyuhakikaje. ");
INSERT INTO mpa_vpl VALUES ("LK21_27","072_21_27","LUK","21","27","27","Panihapa nde pamwambona Mwana waka Mundu ahika mu mahundi, kwa makili makolongwa na ulumbalilu ukolongwa. ");
INSERT INTO mpa_vpl VALUES ("LK21_28","072_21_28","LUK","21","28","28","Mambu ghanihagha paghitumbula kupitalila, nchenjalaje. Njinula mimutu jinu kunani, maghambu kukombulewa kwinu kuheghalile.” ");
INSERT INTO mpa_vpl VALUES ("LK21_29","072_21_29","LUK","21","29","29","Bhela Yesu akabhapwaghi bhabhulwa bhaki ulenganesu aghoghu, “Ndingalya nkongu wa mtini na mikongu jengi jokapi. ");
INSERT INTO mpa_vpl VALUES ("LK21_30","072_21_30","LUK","21","30","30","Pambona kubha mahamba ghaki ghatumbu kutundulila, mmanya kubha chikahi cha mahunu chiheghalile. ");
INSERT INTO mpa_vpl VALUES ("LK21_31","072_21_31","LUK","21","31","31","Bhelabhela, pamwibhona mambu ghanumpwaghi hagha ghapitalila, mmanya kubha Ukolongwa waka Chapanga uheghalile. ");
INSERT INTO mpa_vpl VALUES ("LK21_32","072_21_32","LUK","21","32","32","“Chakaka numpwaghila, bhandu bha kibheleku chenjenu ngachipeti panga mambu ghanihagha kupitalila. ");
INSERT INTO mpa_vpl VALUES ("LK21_33","072_21_33","LUK","21","33","33","Kunani na pundema anaipetaje, nambu malobhi ghangu ngaghipeti ng'o. ");
INSERT INTO mpa_vpl VALUES ("LK21_34","072_21_34","LUK","21","34","34","“Mulilenda wichu, mu mitima jinu ngajihika kulepale na kula liyaha, kulobhela na kung'ahika kwa ndandi ja matamu ghani, ngati nga bhela lichobha heli lanhikila ngati chitabha. ");
INSERT INTO mpa_vpl VALUES ("LK21_35","072_21_35","LUK","21","35","35","Kwa ndandi lichobha heli analibhahikila ghafula bhandu bhokapi bhabhatama pani pundema wokapi. ");
INSERT INTO mpa_vpl VALUES ("LK21_36","072_21_36","LUK","21","36","36","Bhela mbya mihu chikahi chokapi, mkalobhaje, nahuli mpata makili gha kujepangana na mambu ghanihagha ghokapi ghaghipitalyaje, nanamu mpata kuweza kujema palongi jaka Mwana waka Mundu.” ");
INSERT INTO mpa_vpl VALUES ("LK21_37","072_21_37","LUK","21","37","37","Machobha ghokapi hagha muhi, Yesu akabhi abhola pa Nyumba jaka Chapanga, na ikilu akabhi ajenda ku Chitombi cha Mizeituni na kutama konihoku. ");
INSERT INTO mpa_vpl VALUES ("LK21_38","072_21_38","LUK","21","38","38","Bhandu bhokapi bhakabhi bhajumuka palukela na kujenda kunjowanela Yesu pa Nyumba jaka Chapanga. ");
INSERT INTO mpa_vpl VALUES ("LK22_1","072_22_1","LUK","22","1","1","Chikahi cha uwangalalu wa kula mabumunda ghangakujeghaleka amila, jejilowakeka Uwangalalu wa Pasaka, ukabhi uheghalile. ");
INSERT INTO mpa_vpl VALUES ("LK22_2","072_22_2","LUK","22","2","2","Bhapenganyambiku bhakolongwa na bhabhola bha Shelia bhakabhi bhalonda indela ja kunkoma Yesu, nambu bhakabhajowipi bhandu. ");
INSERT INTO mpa_vpl VALUES ("LK22_3","072_22_3","LUK","22","3","3","Bhela Shetani akunjingi Yuda, joalowakika Isikalioti, joakabhi jumu wa bhabhulwa komi na bhabheli. ");
INSERT INTO mpa_vpl VALUES ("LK22_4","072_22_4","LUK","22","4","4","Bhela Yuda akapiti kulongela nabhu bhapenganyambiku bhakolongwa na bhalonda bha Nyumba jaka Chapanga ntundu moang'anambukya Yesu kwabhu. ");
INSERT INTO mpa_vpl VALUES ("LK22_5","072_22_5","LUK","22","5","5","Bhakahekalili namaa na bhakajongini na Yuda kubha anabhumpekya mbija. ");
INSERT INTO mpa_vpl VALUES ("LK22_6","072_22_6","LUK","22","6","6","Yuda akajetakili na kutumbu kulonda mbekenyu jinyahi ja kung'anambuka Yesu kwabho, pandu ambapu njeta lipogha la bhandu. ");
INSERT INTO mpa_vpl VALUES ("LK22_7","072_22_7","LUK","22","7","7","Bhela lichobha la uwangalalu wa Mabumunda Ghangakujeghaleka Amila lakahikike, leniheli nde lichobha lelipalika mwanambeleli wa Pasaka kuchinjakika. ");
INSERT INTO mpa_vpl VALUES ("LK22_8","072_22_8","LUK","22","8","8","Bhela Yesu akabhatumiki Petulu na Yohana na kubhapwaghila, “Njendanya mkatuandalya chilebhi nahuli tukula Pasaka.” ");
INSERT INTO mpa_vpl VALUES ("LK22_9","072_22_9","LUK","22","9","9","Bhombi bhakundalukile, “Bho, upala tukakuandalya kwako?” ");
INSERT INTO mpa_vpl VALUES ("LK22_10","072_22_10","LUK","22","10","10","Yesu akabhayangiki, “Pamkajingala ku muchi, mkahimangana na mwanalomi joanyamwi chihulu cha machi. Mukunjengalyaje mbaka mu nyumba jeakajingalaje. ");
INSERT INTO mpa_vpl VALUES ("LK22_11","072_22_11","LUK","22","11","11","Mukumpwaghila mweni nyumba, ‘Mbola akulalukila, bho, kibhi kwa chumba cha bhagheni chenikula chilebhi cha Pasaka papamu na bhabhulwa bhango?’ ");
INSERT INTO mpa_vpl VALUES ("LK22_12","072_22_12","LUK","22","12","12","Jombi anandangiya chumba chikolongwa cha kugholofa chekijomwi kubhekakeka wichu. Monihomu nde mkatuandalya chilebhe.” ");
INSERT INTO mpa_vpl VALUES ("LK22_13","072_22_13","LUK","22","13","13","Bhakapiti na kukihimani kila chindu kibhi wichu ngati Yesu moakapwaghile, na bhombi bhakaandi chilebhi cha Pasaka. ");
INSERT INTO mpa_vpl VALUES ("LK22_14","072_22_14","LUK","22","14","14","Chikahi pachahikaje, Yesu akatemi pahi, na kula chilebhi papamu na mitumi bhaki. ");
INSERT INTO mpa_vpl VALUES ("LK22_15","072_22_15","LUK","22","15","15","Akabhapwaghile, “Ndokuli namaa kula chilebhi chenu cha Pasaka papamu na mwenga mangane ja kung'ahika kwangu. ");
INSERT INTO mpa_vpl VALUES ("LK22_16","072_22_16","LUK","22","16","16","Chakaka numpwaghila, nganikuli kabheti chilebhi chenu cha Pasaka mbaka pajipitalya mu Ukolongwa waka Chapanga.” ");
INSERT INTO mpa_vpl VALUES ("LK22_17","072_22_17","LUK","22","17","17","Bhela Yesu akachitoi chikombi cha divai, na kuchipengalela akapwagha, “Mtola chenjenu na ngabhana mabhokapi. ");
INSERT INTO mpa_vpl VALUES ("LK22_18","072_22_18","LUK","22","18","18","Maghambu numpwaghila kutumbu sajenu ngangunywi kabheti divai jenu mbaka Ukolongwa waka Chapanga pawihikaje.” ");
INSERT INTO mpa_vpl VALUES ("LK22_19","072_22_19","LUK","22","19","19","Kabheti akatohi libumunda, akunchengwi Chapanga, akalihekiti, na kubhapekeha, akapwaghaje, “Jenjenu nde hyegha jangu, jempatiki mwenga. Ntenda anana kwa kungomboka nepani.” ");
INSERT INTO mpa_vpl VALUES ("LK22_20","072_22_20","LUK","22","20","20","Bhelabhela paakajomwi kula chilebhi cha pakamihi akachitoi chikombi cha divai na kupwagha, “Chikombi chenjenu nde lulaghilu lwahenu lwaka Chapanga lolusibitishwa kwa mwahi wangu, ghoujitika kwa ndandi jinu. ");
INSERT INTO mpa_vpl VALUES ("LK22_21","072_22_21","LUK","22","21","21","“Nambu, ndingalyaje! Jola joaying'anambukaje akula chilebhi papamu na nepani. ");
INSERT INTO mpa_vpl VALUES ("LK22_22","072_22_22","LUK","22","22","22","Maghambu Mwana waka Mundu anaapotilaje ngati moapangi Chapanga, nambu anaachibhonaje mundu jola joang'anambukaje!” ");
INSERT INTO mpa_vpl VALUES ("LK22_23","072_22_23","LUK","22","23","23","Bhela bhakatumbwi kulaluhana bheni kwa bheni kubha nde nane pachilanda jabhu joanahenga lijambu leniheli. ");
INSERT INTO mpa_vpl VALUES ("LK22_24","072_22_24","LUK","22","24","24","Kukapitali kulochana kwa bhabhulwa kubhokana na nde nane joaholaleka kubha anaabya nkolongwa pachilanda jabhu kupeta bhangi bhokapi. ");
INSERT INTO mpa_vpl VALUES ("LK22_25","072_22_25","LUK","22","25","25","Yesu akabhapwaghile, “Bhakolongwa bha bhandu bhanga Bhayahude bhabhajemale bhandu bhabhu kwa makile, na bhala bhabhabhi na lujiniku panani jabhu bhaliloha, ‘Bhakochi bha bhandu.’ ");
INSERT INTO mpa_vpl VALUES ("LK22_26","072_22_26","LUK","22","26","26","Nambu ngakwikubha bhenibhela kwinu mabhanganya. Nambu jola joabhi nkolongwa pachilanda jinu, impalika abya ngati nchoku wa bhokapi, na joabhi chiongozi impalika abya ngati mtumika. ");
INSERT INTO mpa_vpl VALUES ("LK22_27","072_22_27","LUK","22","27","27","Bho, nane joabhi nkolongwa? Bho, jola joatama kula chilebhhi, au jola joabhatumakila? Chakaka nde jola joatama kula chilebhi. Nambu nepani mili pambane pachilanda jinu ngati mtumika. ");
INSERT INTO mpa_vpl VALUES ("LK22_28","072_22_28","LUK","22","28","28","“Mwenga nde mwemwahighali na nepani chikahi chokapi cha kulengakeka kwangu, ");
INSERT INTO mpa_vpl VALUES ("LK22_29","072_22_29","LUK","22","29","29","nepani numpekihi mwehapa ukolongwa, ngati Atati wangu moambeki nepani kubha nunkolongwa. ");
INSERT INTO mpa_vpl VALUES ("LK22_30","072_22_30","LUK","22","30","30","Nahuli mpata kula na kunywa pa meza jangu mu Ukolongwa wangu na kutama mu itehu ya kikolongwa kughatemula makabila komi na ghabheli gha Izilaeli.” ");
INSERT INTO mpa_vpl VALUES ("LK22_31","072_22_31","LUK","22","31","31","Yesu akapwaghiki, “Simoni, Simoni! Ujowanyaje! Shetani apala kumpeta mwehapa ngati ingano. ");
INSERT INTO mpa_vpl VALUES ("LK22_32","072_22_32","LUK","22","32","32","Nambu nepani nukulobhi wehapa wa Simoni, nahuli uhobhalelu waku ngawikepa, na wenga pawikelebhuka kwangu kabheti, wajangatya bhalongu bhaku.” ");
INSERT INTO mpa_vpl VALUES ("LK22_33","072_22_33","LUK","22","33","33","Petulu akamuyangiki, “Bambo, nepani nyetaki kujenda papamu na wehapa muchifungo, na hata kupotela!” ");
INSERT INTO mpa_vpl VALUES ("LK22_34","072_22_34","LUK","22","34","34","Yesu akamuyangiki, “Nukumpwaghi wehapa wa Petulu, lalenu mangane ja likongobhi kubheka wibya unganiki mala patatu kubha ngacheunimanye.” ");
INSERT INTO mpa_vpl VALUES ("LK22_35","072_22_35","LUK","22","35","35","Bhela Yesu akabhalaluki bhabhulwa bhaki, “Panuntumiki panga mbija, wala nkoba, na wala magubasi, bho, mkakepakiwi na chindu bhole?” Bhakayangiki, “Ngachetwakepakiwi na chindu.” ");
INSERT INTO mpa_vpl VALUES ("LK22_36","072_22_36","LUK","22","36","36","Yesu akabhapwaghile, “Nambu henu, jola joabhi na mfuku wa mbija autolaje, na joabhi na nkoba autola bhelabhela. Na jokapi jwanga lipanga, alombisa ingobhu jaki na ahemala limu. ");
INSERT INTO mpa_vpl VALUES ("LK22_37","072_22_37","LUK","22","37","37","Maghambu numpwaghila, ipalika malobhi aghagha ghapitalya kwangu ngati moghalembakike mu Malembu Mahuhu, ‘Jombi akabhalangiki papamu na bhahenga mahakau.’ Chakaka ghala ghaghapalika kwangu ghapalika ghapitalyaje.” ");
INSERT INTO mpa_vpl VALUES ("LK22_38","072_22_38","LUK","22","38","38","Bhabhulwa bhakapwaghike, “Bambo! Lingalyaje, pambani ghabhi mapanga ghabhele!” Jombi akayangike, “Base iyaghanila.” ");
INSERT INTO mpa_vpl VALUES ("LK22_39","072_22_39","LUK","22","39","39","Yesu akabhokiki na kujenda ku Chitombi cha Mizeituni ngati mowabheli ntetu waki, na bhabhulwa bhaki bhakapiti papamu naku. ");
INSERT INTO mpa_vpl VALUES ("LK22_40","072_22_40","LUK","22","40","40","Paakahiki pandu panipala, akabhapwaghile, “Ndobhaje nahuli ngamwijingi mu malengakeku.” ");
INSERT INTO mpa_vpl VALUES ("LK22_41","072_22_41","LUK","22","41","41","Bhela mweni akabhokiki na kujenda pandu pa kuweza mundu kuleke liganga. Akachikimi, na kulobha, ");
INSERT INTO mpa_vpl VALUES ("LK22_42","072_22_42","LUK","22","42","42","akapwagha, “Atati, ngati anaupaliki, nukujopa umokiya kutali chikombi cha mang'ahiku. Ngakwikubha ngati mombali nepani, nambu kubya ngati moupali wehapa.” ");
INSERT INTO mpa_vpl VALUES ("LK22_43","072_22_43","LUK","22","43","43","Panihapa mtumika kuhuma kunani kwaka Chapanga akampitalili na kunjeghe makili. ");
INSERT INTO mpa_vpl VALUES ("LK22_44","072_22_44","LUK","22","44","44","Yesu akabhi mu mabhinilu makolongwa, akajonjuki kulobha nakanopi, na lihoghatela laki lakabhi ngati mandonyi gha mwahi, lelikaheli mbaka paluhombi. ");
INSERT INTO mpa_vpl VALUES ("LK22_45","072_22_45","LUK","22","45","45","Paakajomwi kulobha akakelawiki kwa bhabhulwa bhaki, akabhahimani bhaghochile, maghambu bhakabhi na huzune. ");
INSERT INTO mpa_vpl VALUES ("LK22_46","072_22_46","LUK","22","46","46","Akabhapwaghile, “Bho, mbona ngochile? Njumukaje na ndobhaje, nahuli ngamwijingi mu malengakeku.” ");
INSERT INTO mpa_vpl VALUES ("LK22_47","072_22_47","LUK","22","47","47","Yesu paakabhi akali kulongela, lipogha la bhandu lakahikiki koni akalilonguwa Yuda, jumu wa bhabhulwa komi na bhabheli. Yuda akunjendi Yesu na kumbusu. ");
INSERT INTO mpa_vpl VALUES ("LK22_48","072_22_48","LUK","22","48","48","Nambu Yesu akundalukile, “Yuda! Bho, ung'anambuka Mwana waka Mundu kwa kumbusu?” ");
INSERT INTO mpa_vpl VALUES ("LK22_49","072_22_49","LUK","22","49","49","Bhabhulwa bhaka Yesu pabhaghaweni mambu ghaghipitalyaje bhakapwaghike, “Bambo, bho, twahekata le kwa mapanga?” ");
INSERT INTO mpa_vpl VALUES ("LK22_50","072_22_50","LUK","22","50","50","Jumu wabhu akundapwi lipanga mtumika waka Mpenganyambiku Nkolongwa, na kunchekula likutu laki la kumalelelu. ");
INSERT INTO mpa_vpl VALUES ("LK22_51","072_22_51","LUK","22","51","51","Nambu Yesu akapwaghike, “Nkotukaje, ngamwihenga kabhete!” Akalikamwi likutu laka mundu jola na kundamiha. ");
INSERT INTO mpa_vpl VALUES ("LK22_52","072_22_52","LUK","22","52","52","Bhela Yesu akabhapwaghi bhapenganyambiku bhakolongwa, na bhalonda bhakolongwa bha Nyumba jaka Chapanga, na bhazee bhabhahiki kunkamula, “Bho, muhikiki na mapanga na indonga kungamula ngati nepani nde mnyaghula? ");
INSERT INTO mpa_vpl VALUES ("LK22_53","072_22_53","LUK","22","53","53","Machobha ghokapi nakabhi na mwehapa pa Nyumba jaka Chapanga, na ngachemwangamwile. Nambu sajenu nde chikahi chinu, cha makili gha lubhendu kutawala.” ");
INSERT INTO mpa_vpl VALUES ("LK22_54","072_22_54","LUK","22","54","54","Bhela bhakunkamwi Yesu, na kumpeleka kunyumba jaka Mpenganyambiku Nkolongwa. Nambu Petulu akabhi anjengale cha kutali. ");
INSERT INTO mpa_vpl VALUES ("LK22_55","072_22_55","LUK","22","55","55","Bhandu bhangi bhakapuliki motu pachilanda ja liwangala na kutama, na Petulu akahiki kunyatuki motu papamu nabhu. ");
INSERT INTO mpa_vpl VALUES ("LK22_56","072_22_56","LUK","22","56","56","Mtumika jumu wa chimbomba paambweni Petulu atami pambipi na motu, akundingalaki namaa na kupwagha, “Mundu ajoju najombi akabhi papamu na Yesu!” ");
INSERT INTO mpa_vpl VALUES ("LK22_57","072_22_57","LUK","22","57","57","Nambu Petulu akakaniki, akapwagha, “Mbomba, nepani ngachenummanyi!” ");
INSERT INTO mpa_vpl VALUES ("LK22_58","072_22_58","LUK","22","58","58","Palongi pachokope, mundu jongi akumbweni Petulu na kumpwaghila, “Wehapa nanau wa jumu wabho!” Nambu Petulu akayangike, “We mundu, nepani nga jumu wabho!” ");
INSERT INTO mpa_vpl VALUES ("LK22_59","072_22_59","LUK","22","59","59","Palapetiki lisaa limu, mundu jongi akajomalaki kwa kupwagha, “Chakaka mundu ajoju akabhi papamu naku, maghambu najombi nde mwenei wa ku Galilaya!” ");
INSERT INTO mpa_vpl VALUES ("LK22_60","072_22_60","LUK","22","60","60","Nambu Petulu akapwaghike, “We mundu, ngachemanyi malobhi ghaulongela.” Palapala paakabhi akali kulongela, likongobhi lakabhekike. ");
INSERT INTO mpa_vpl VALUES ("LK22_61","072_22_61","LUK","22","61","61","Bambo akang'anambwiki na kundingali Petulu. Na jombi Petulu akakombwiki malobhi ghala Bambo ghaampwagi, kubha, “Lalenu mangani ja kubheka likongobhe, wingana mala patatu kubha ngacheunimanyi.” ");
INSERT INTO mpa_vpl VALUES ("LK22_62","072_22_62","LUK","22","62","62","Petulu akapitiki kunja na kulela kwa kumbina mtima. ");
INSERT INTO mpa_vpl VALUES ("LK22_63","072_22_63","LUK","22","63","63","Bhandu bhala bhabhabhi bhundenda Yesu, bhakatumbwi kundongama na kundapula. ");
INSERT INTO mpa_vpl VALUES ("LK22_64","072_22_64","LUK","22","64","64","Bhakunhibhiki mihu kwa ingobhu na kundalukila, “Ulotilaje! Bho, akulapwi nane?” ");
INSERT INTO mpa_vpl VALUES ("LK22_65","072_22_65","LUK","22","65","65","Na bhombi bhakundongali malobhi ghangi ghamahele gha kuntondola. ");
INSERT INTO mpa_vpl VALUES ("LK22_66","072_22_66","LUK","22","66","66","Palukela, bhazee, bhapenganyambiku bhakolongwa na bhabhola bha Shelia bhakahimangini, na bhakumpeliki Yesu palongi ja pachengu jabhu. ");
INSERT INTO mpa_vpl VALUES ("LK22_67","072_22_67","LUK","22","67","67","Na bhombi bhakapwaghike, “Tupwaghilaje! Bho, wehapa le wa Kristo?” Nambu Yesu akabhapwaghile, “Hata ngati ananumpwaghile, ngamwihobhalele, ");
INSERT INTO mpa_vpl VALUES ("LK22_68","072_22_68","LUK","22","68","68","na hata ngati ananundaluki lilalukilu, ngamuniyange. ");
INSERT INTO mpa_vpl VALUES ("LK22_69","072_22_69","LUK","22","69","69","Nambu kutumbu sajenu, Mwana waka Mundu ayibya atami upambala wa kumalelelu waka Chapanga Mweni Makili.” ");
INSERT INTO mpa_vpl VALUES ("LK22_70","072_22_70","LUK","22","70","70","Bhela bhokapi bhakundalukile, “Bho, nde kupwagha kubha wehapa le wa Mwana waka Chapanga?” Na jombi akabhayangike, “Mwenga mpwagha chakaka kubha nepani nde jombi.” ");
INSERT INTO mpa_vpl VALUES ("LK22_71","072_22_71","LUK","22","71","71","Na bhombi bhakapwaghike, “Bho, tupala le mundu jongi ahikaje na atupwaghila ulandilu wake? Maghambu tepani tabhete tujowini akapwagha kwa ndomu waki mweni!” ");
INSERT INTO mpa_vpl VALUES ("LK23_1","072_23_1","LUK","23","1","1","Bhela bhandu bhokapi bha pachengo pakolongwa bhakajemiki na kumpeleka Yesu kwaka Pilato. ");
INSERT INTO mpa_vpl VALUES ("LK23_2","072_23_2","LUK","23","2","2","Bhakatumbwi kuntakila, bhakapwaghaje, “Tunketani mundu ajoju akabhakoluwa bhandu bhitu. Apenga kulepa kode kwaka Kaisali, na kulilowa kubha jombi nde Kristo, Nkolongwa.” ");
INSERT INTO mpa_vpl VALUES ("LK23_3","072_23_3","LUK","23","3","3","Pilato akundaluki Yesu, “Bho, wehapa le unkolongwa wa Bhayahude?” Yesu akayangike, “Wehapa upwaghike.” ");
INSERT INTO mpa_vpl VALUES ("LK23_4","072_23_4","LUK","23","4","4","Bhela Pilato akabhapwaghi bhapenganyambiku bhakolongwa na lipogha la bhandu kubha, “Nepani ngachemona lihakau lokapi lela la kuntaki mundu ajoju.” ");
INSERT INTO mpa_vpl VALUES ("LK23_5","072_23_5","LUK","23","5","5","Nambu bhombi bhakajomalaki nakanopi, bhakapwaghaje, “Kwa mabholu ghaki abhachochake bhandu bhabhabhi ku Yudea jokapi. Akatumbwi ku Galilaya na sajenu abhi pitu pani.” ");
INSERT INTO mpa_vpl VALUES ("LK23_6","072_23_6","LUK","23","6","6","Pilato paajowini malobhi ghanihagha, akalalukile, “Bho, mundu ajo le mwenei wa ku Galilaya?” ");
INSERT INTO mpa_vpl VALUES ("LK23_7","072_23_7","LUK","23","7","7","Paakamanyi kubha Yesu akahumi ku inchi jeatawala Helode, akumpeliki kwaka Helode, maghambu akabhi ku Yelusalemu chikahi chela. ");
INSERT INTO mpa_vpl VALUES ("LK23_8","072_23_8","LUK","23","8","8","Helode paakambweni Yesu, akahekali namaa maghambu kwa machobha ghamahele akabhi atokule kumbona. Maghambu akajowini malobhi panani jaki, najombi akapaliki kubhona nginyulila kuhuma kwaka Yesu. ");
INSERT INTO mpa_vpl VALUES ("LK23_9","072_23_9","LUK","23","9","9","Bhela Helode akundaluki Yesu malalukilu ghamahele, nambu Yesu ngacheayangiki lilobhi. ");
INSERT INTO mpa_vpl VALUES ("LK23_10","072_23_10","LUK","23","10","10","Bhapenganyambiku bhakolongwa na bhabhola bha Shelia bhakajemiki panipala, bhakabhoha matakilu ghabhu kwa makili panani jaka Yesu. ");
INSERT INTO mpa_vpl VALUES ("LK23_11","072_23_11","LUK","23","11","11","Bhela Helode papamu na manjolinjoli bhaki bhakunhekiki Yesu na kundongama. Bhakunhwatiki ingobhu jinyahi ngati nkolongwa na kunkelabhu kwaka Pilato. ");
INSERT INTO mpa_vpl VALUES ("LK23_12","072_23_12","LUK","23","12","12","Kutumbu lichobha heli Helode akabhi nkochi waka Pilato, maghambu pamwandi bhakabhi maadui. ");
INSERT INTO mpa_vpl VALUES ("LK23_13","072_23_13","LUK","23","13","13","Bhela Pilato akalohiki uhimanganu wa bhapenganyambiku bhakolongwa, ihongozi bha bhandu na bhandu bhabhu, ");
INSERT INTO mpa_vpl VALUES ("LK23_14","072_23_14","LUK","23","14","14","na kubhapwaghila, “Mundetiki mundu ajo kwangu mkapwagha kubha abhachochake bhandu. Henu nepani nundaluki malobhi ghaki palongi jinu, nambu ngachenumbweni na lihakau lokapi lela lemuntaki mabhanganya. ");
INSERT INTO mpa_vpl VALUES ("LK23_15","072_23_15","LUK","23","15","15","Hata Helode ngacheambweni na lihakau, na kwa ndandi jeniheji ankelawi kwitu. Chakaka kubha mundu ajoju ngacheahengiki lihakau lokapi lela lelumpalika kupotela. ");
INSERT INTO mpa_vpl VALUES ("LK23_16","072_23_16","LUK","23","16","16","Bhela ananaghalakya alapulika iboku, na kundekakela.” ");
INSERT INTO mpa_vpl VALUES ("LK23_17","072_23_17","LUK","23","17","17","Bhela kila lichobha la Uwangalalu wa Pasaka, Pilato ikampaliki kubhabhopule bhandu nkongeka jumu. ");
INSERT INTO mpa_vpl VALUES ("LK23_18","072_23_18","LUK","23","18","18","Nambu bhokapi kwa papamu bhakajamali, bhakapwaghaje, “Umboha mundu hoju! Utubhopulya Balaba!” ");
INSERT INTO mpa_vpl VALUES ("LK23_19","072_23_19","LUK","23","19","19","Balaba bhakunkongiki kwa kutumbuli fujo yeyatendakiki ku muchi na kwa ndandi ja kukoma. ");
INSERT INTO mpa_vpl VALUES ("LK23_20","072_23_20","LUK","23","20","20","Pilato akapaliki kundekake Yesu, bhela akalongi nabhu kabhete. ");
INSERT INTO mpa_vpl VALUES ("LK23_21","072_23_21","LUK","23","21","21","Nambu bhombi bhakajamali kabhete, “Unhwamba punsalaba! Unhwamba punsalaba!” ");
INSERT INTO mpa_vpl VALUES ("LK23_22","072_23_22","LUK","23","22","22","Pilato akabhapwaghi kabheti mala ja katatu, “Bho, maghambu ja kyane? Bho, ahengiki lihakau bhole? Ngachemweni lihakau lokapi kwaki lelumpalika kukomakeka. Bhela ananundapula iboku ya ndomondo na kundekakela.” ");
INSERT INTO mpa_vpl VALUES ("LK23_23","072_23_23","LUK","23","23","23","Nambu bhombi bhakajendali kujamali nakanopi, bhakajopa Yesu awambakika punsalaba. Na kwa kujamalila kwabhu kukantendiki Pilato ajetakyaje. ");
INSERT INTO mpa_vpl VALUES ("LK23_24","072_23_24","LUK","23","24","24","Bhela Pilato akaamwi kubhahenge ngati mobhapalilaje. ");
INSERT INTO mpa_vpl VALUES ("LK23_25","072_23_25","LUK","23","25","25","Akumbopuli mundu jobhumpalika jola, joakongakiki muchifungu kwa kuchokake fujo na kukoma, na kumboha Yesu kwabhu nahuli bhunhengila ngati mobhapalilaje. ");
INSERT INTO mpa_vpl VALUES ("LK23_26","072_23_26","LUK","23","26","26","Pabhakabhi bhumpeleka, bhakahimangini na mundu jumu joalowakika Simoni, mwenei wa ku Kilene, joakabhi ahuma kungonda kuhika kumuchi. Bhela bhakunkamwili, na kuntweka aunyamula nsalaba punyuma jaka Yesu. ");
INSERT INTO mpa_vpl VALUES ("LK23_27","072_23_27","LUK","23","27","27","Lipogha likolongwa la bhandu lakabhi lunjengalela, pachilanda jabhu bhakabhi akambomba bhakabya bhundelela na kumuombulezela. ");
INSERT INTO mpa_vpl VALUES ("LK23_28","072_23_28","LUK","23","28","28","Yesu akabhang'anambukili na kubhapwaghila, “Mwenga akambomba bha Yelusalemu, ngamwinele nepani, nambu mulilelila mabhete papamu na bhana bhinu. ");
INSERT INTO mpa_vpl VALUES ("LK23_29","072_23_29","LUK","23","29","29","Kwa ndandi machobha ghahika ambapu bhandu pabhipwagha, ‘Mbanga kwabhu akambomba ngulumba, bhangakubheleka bhana, na bhangakujongeha!’ ");
INSERT INTO mpa_vpl VALUES ("LK23_30","072_23_30","LUK","23","30","30","Chikahi hechi bhandu bhitumbula kwipwaghi itombi, ‘Mtuhabhukyaje!’ Na tutombi, ‘Mtuyekalyaje!’ ");
INSERT INTO mpa_vpl VALUES ("LK23_31","072_23_31","LUK","23","31","31","Kwa ndandi ngati bhandu bhutende nkongu ubhehi ntundu agho, bho, kwibya bhole kwa nkongu ujomo?” ");
INSERT INTO mpa_vpl VALUES ("LK23_32","072_23_32","LUK","23","32","32","Bhakabhatohi kabheti bhahakau bhangi bhabhele, bhakapelakiki kukomakeka papamu na Yesu. ");
INSERT INTO mpa_vpl VALUES ("LK23_33","072_23_33","LUK","23","33","33","Pabhahiki pandu papalowakeka, “Lifuvu la Mmutu,” panihapa nde pabhunhwambiki Yesu punsalaba papamu na bhahenga mahakau bhala kila jumu punsalaba waki, jumu upambala wa kumalelelu na jongi upambala wa kumangeja ja msalaba waka Yesu. ");
INSERT INTO mpa_vpl VALUES ("LK23_34","072_23_34","LUK","23","34","34","Yesu akapwaghike, “Atati! Ubhalekakyaje mahoku ghabhu, maghambu ngachebhamanyi lebhalihenga.” Bhela bhakaghabhini ingobhu yaki kwa kwilapuli kula. ");
INSERT INTO mpa_vpl VALUES ("LK23_35","072_23_35","LUK","23","35","35","Bhandu bhakajemi panipala bhakalingalyaje. Na bhombi bhakolongwa bha Bhayahude bhakundongimi Yesu, “Akabhakengali bhandu bhangi, henu alikengalya mwene, anangati jombi nde Kristo, joahaghuliki na Chapanga!” ");
INSERT INTO mpa_vpl VALUES ("LK23_36","072_23_36","LUK","23","36","36","Manjolinjoli na bhombi bhakundongimi, bhakunjendili na kumpeke divai jejibhabha, ");
INSERT INTO mpa_vpl VALUES ("LK23_37","072_23_37","LUK","23","37","37","bhakumpwaghile, “Ana ngati chakaka wehapa nde Nkolongwa wa Bhayahude, ulikengalya wamwene!” ");
INSERT INTO mpa_vpl VALUES ("LK23_38","072_23_38","LUK","23","38","38","Na panani ja msalaba waki ghakalembakiki malobhi ghangane, “AJOJU NDE NKOLONGWA WA BHAYAHUDE.” ");
INSERT INTO mpa_vpl VALUES ("LK23_39","072_23_39","LUK","23","39","39","Mwihi jumu pachilanda ja bhabhawambakiki punsalaba bhala, akuntondwi Yesu, akapwagha, “Bho, nga chakaka le kubha wehapa nde Kristo? Bhela ulikengalya wamwete na utukengalya na tepani!” ");
INSERT INTO mpa_vpl VALUES ("LK23_40","072_23_40","LUK","23","40","40","Nambu mwihi jongi jola akundakali njaki akapwagha, “Bho, wehapa le ngacheunjoghopa Chapanga hata pachokope? Koni nanau utemuliwi bhelabhela. ");
INSERT INTO mpa_vpl VALUES ("LK23_41","072_23_41","LUK","23","41","41","Wenga na nepani tutemuliwi ngati mokupalakila, maghambu ghangani nde malepu gha ghala ghatuhengike. Nambu mundu ajoju ngacheahengiki chindu chokapi chihakau.” ");
INSERT INTO mpa_vpl VALUES ("LK23_42","072_23_42","LUK","23","42","42","Bhela akajonjuki kupwagha, “Wenga Yesu, ungombukaje chikahi pawihikaje mu Ukolongwa waku!” ");
INSERT INTO mpa_vpl VALUES ("LK23_43","072_23_43","LUK","23","43","43","Yesu akayangiki, “Chakaka nukupwaghi wehapa lalenu anana, wibya papamu na nepani ku Paladiso.” ");
INSERT INTO mpa_vpl VALUES ("LK23_44","072_23_44","LUK","23","44","44","Ikabhi ngati saa sita ja muhi, lubhendu lukayekiki inchi jokapi mbaka saa tisa, ");
INSERT INTO mpa_vpl VALUES ("LK23_45","072_23_45","LUK","23","45","45","na lipanzia lelakabhi libhekakiki mu Nyumba jaka Chapanga lakakachwiki ipandi ibhele. ");
INSERT INTO mpa_vpl VALUES ("LK23_46","072_23_46","LUK","23","46","46","Panihapa Yesu akajamali, akapwagha, “Atati! Mu mabhoku ghaku nijibheka roho jangu.” Na paakajomwi kulongela ghanihagha, akahekiti roho. ");
INSERT INTO mpa_vpl VALUES ("LK23_47","072_23_47","LUK","23","47","47","Nkolongwa wa manjolinjoli mia moja wa ki Loma jola paakaweni mambu ghanihagha ghaghapitalile, akundumbali Chapanga, akapwagha, “Chakaka mundu ajoju akabhi wambone.” ");
INSERT INTO mpa_vpl VALUES ("LK23_48","072_23_48","LUK","23","48","48","Bhandu bhokapi bhabhalibhongini panipala kwa ndandi ja kulingali mambu ghanihagha, pabhaghaweni ghokapi ghaghapitalile, bhakakelawiki kumanyumba ghabhu koni bhakabya na huzuni ngolongwa. ");
INSERT INTO mpa_vpl VALUES ("LK23_49","072_23_49","LUK","23","49","49","Bhakochi bhaka Yesu papamu na akambomba bhabhunjengali kutumbu ku Galilaya, bhakajemiki cha kutali bhakalingalya mambu ghanihagha. ");
INSERT INTO mpa_vpl VALUES ("LK23_50","072_23_50","LUK","23","50","50","Kukabhi na mundu jumu, joalowakika Yusufu, ambaju akabhi mundu wa pachengu, akabhi mundu wamboni na wa kutopela. ");
INSERT INTO mpa_vpl VALUES ("LK23_51","072_23_51","LUK","23","51","51","Akabhi mundu wa ku Alimataya, na akabhi alendale kuhika kwa Ukolongwa waka Chapanga. Papamu na kubha akabhi jumu wabhu wa Pachengo Pakolongwa pa Bhayahude, ngacheakajetangani nabhu kwa ghokapi ghabhahengiki bhajake. ");
INSERT INTO mpa_vpl VALUES ("LK23_52","072_23_52","LUK","23","52","52","Bhela Yusufu akapiti kwaka Pilato, akajopiki ampekya hyegha jaka Yesu. ");
INSERT INTO mpa_vpl VALUES ("LK23_53","072_23_53","LUK","23","53","53","Bhela akajiheli hyegha jaka Yesu kuhuma punsalaba, akajiyongalwi sanda, na kujibheka hyegha jaka Yesu mulitengele lelalenganakiki mu liganga, lelakabhi likona nga kutaghakika mundu. ");
INSERT INTO mpa_vpl VALUES ("LK23_54","072_23_54","LUK","23","54","54","Lichobha heli lakabhi Ijumaa, na Lichobha la Sabato lakabhi litumbula. ");
INSERT INTO mpa_vpl VALUES ("LK23_55","072_23_55","LUK","23","55","55","Akambomba bhala bhabhakunjengali Yesu kutumbu ku Galilaya bhakunjengali Yusufu, bhakaliweni litengeli na ntundu hyegha jaka Yesu mobhakajibhekile. ");
INSERT INTO mpa_vpl VALUES ("LK23_56","072_23_56","LUK","23","56","56","Bhela bhakakelawiki kunyumba, na kulenganakela manungilu na mahuta gha kujipaka hyegha jaka Yesu. Na Lichobha la Sabato bhakapomulili, ngati mojilaghalaki Shelia. ");
INSERT INTO mpa_vpl VALUES ("LK24_1","072_24_1","LUK","24","1","1","Jumapili lukela pachibhombu, akambomba bhala bhakapiti kulitengeli, koni bhatoghwi manungilu ghabhalenganakile. ");
INSERT INTO mpa_vpl VALUES ("LK24_2","072_24_2","LUK","24","2","2","Bhakalihimani liganga la kuyekalela litengeli lela likangakiki kutali na litengele. ");
INSERT INTO mpa_vpl VALUES ("LK24_3","072_24_3","LUK","24","3","3","Bhela bhakajingi mulitengeli, nambu ngachebhajiweni hyegha jaka Bambo Yesu. ");
INSERT INTO mpa_vpl VALUES ("LK24_4","072_24_4","LUK","24","4","4","Pabhakabhi bhaholale panani ja lilobhi leniheli, palapala bhandu bhabhele bhabhaweti ingobhu ihuhu kupukupu bhakajemiki pambipi nabhu. ");
INSERT INTO mpa_vpl VALUES ("LK24_5","072_24_5","LUK","24","5","5","Akambomba bhala bhakajowipi namaa na kujinama mbaka pahi. Nambu bhandu bhala bhakabhapwaghile, “Bho, magambu kiki mundonda joayokiki pachilanda ja bhabhawile? ");
INSERT INTO mpa_vpl VALUES ("LK24_6","072_24_6","LUK","24","6","6","Yesu ngacheabhi pambane, ahyokike! Nkombuka moakampwaghile chikahi paakabhi ku Galilaya. ");
INSERT INTO mpa_vpl VALUES ("LK24_7","072_24_7","LUK","24","7","7","Akumpwaghi kubha, ‘Mwana waka Mundu anabhumpelaka mu mabhoku gha bhana mahoku, na kuwambakika punsalaba, nambu lichobha la katatu ayiyokaje.’ ” ");
INSERT INTO mpa_vpl VALUES ("LK24_8","072_24_8","LUK","24","8","8","Panihapa akambomba bhala bhakakombwiki malobhi ghaka Yesu. ");
INSERT INTO mpa_vpl VALUES ("LK24_9","072_24_9","LUK","24","9","9","Bhakakelawiki kuhuma kulitengeli, na bhakabhapwaghi mambu ghanihagha bhabhulwa bhaki komi na jumu bhala, na kwa bhahemba bhangi bhokapi bhaka Yesu. ");
INSERT INTO mpa_vpl VALUES ("LK24_10","072_24_10","LUK","24","10","10","Akambomba bhabhapwaghika mambu ghanihagha kwa mitumi bhaka Yesu bhakabhi nde, Malia Magidalena, na Yoana, na Malia mabhu waka Yakobo, na akambomba bhangi bhabhakabhi papamu nabhu. ");
INSERT INTO mpa_vpl VALUES ("LK24_11","072_24_11","LUK","24","11","11","Nambu mitumi bhaka Yesu bhakaghatohi mambu ghanihagha kubha ngati gha upuhe, na bhela ngachebhahobhalile. ");
INSERT INTO mpa_vpl VALUES ("LK24_12","072_24_12","LUK","24","12","12","Nambu Petulu akajemiki, na kukembela imbelu mbaka kulitengeli. Paakahikiki, akajinimi na kulingali mkati, akaiweni pe sanda. Bhela akabhujiki kunyumba koni akangacha kwa ndandi ja mambu ghaghapitalile. ");
INSERT INTO mpa_vpl VALUES ("LK24_13","072_24_13","LUK","24","13","13","Lichobha lelalela, bhabhulwa bhabhele bhaka Yesu bhakabhi bhajenda ku chijiji chimu chekilowakeka Emau, chechikabhi utali wa kilometa komi na moja kuhuma ku Yelusalemu. ");
INSERT INTO mpa_vpl VALUES ("LK24_14","072_24_14","LUK","24","14","14","Bhakabhi bhalongale panani ja mambu ghokapi ghaghapitalile. ");
INSERT INTO mpa_vpl VALUES ("LK24_15","072_24_15","LUK","24","15","15","Pabhakabhi bhalongale na kulaluwana, Yesu mweni akabhaheghali pambipi na kulongana nabhu. ");
INSERT INTO mpa_vpl VALUES ("LK24_16","072_24_16","LUK","24","16","16","Bhakumbweni nambu ngachebhumanye. ");
INSERT INTO mpa_vpl VALUES ("LK24_17","072_24_17","LUK","24","17","17","Yesu akabhalalukile, “Bho, ndongale kiki koni njenda?” Na bhombi bhakajemiki na kutumbala chinunu, koni bhakalangiya pamihu jabhu kubha bhabhi na huzuni. ");
INSERT INTO mpa_vpl VALUES ("LK24_18","072_24_18","LUK","24","18","18","Jumu wabhu pachilanda ja bhandu bhanihabha, joalowakika Kileopa, akamuyangike, “Bho, wehapa le ungeni kanjika jaku ku Yelusalemu, wangakumanya mambu ghaghapitali konihoku machobha ghane?” ");
INSERT INTO mpa_vpl VALUES ("LK24_19","072_24_19","LUK","24","19","19","Jombi akabhalalukile, “Mambu bhole?” Bhombi bhakamuyangiki, “Mambu ghaghumpitali Yesu wa ku Nazaleti. Mundu hoju akabhi mlota waka Chapanga joakabhi na uwezu wa kuhenga na kubhola palongi jaka Chapanga na palongi ja bhandu bhokapi. ");
INSERT INTO mpa_vpl VALUES ("LK24_20","072_24_20","LUK","24","20","20","Bhapenganyambiku bhakolongwa na bhatawala bhitu bhakumbohiki nahuli atemuliwa kupotela, na bhombi bhakunhwambiki punsalaba. ");
INSERT INTO mpa_vpl VALUES ("LK24_21","072_24_21","LUK","24","21","21","Tepani tukahobhali kubha jombi nde joabhakombulaje bhandu bha Izilaeli. Nambu lalenu nde lichobha la katatu kutumbu mambu ghanihagha paghahengakike. ");
INSERT INTO mpa_vpl VALUES ("LK24_22","072_24_22","LUK","24","22","22","Bhelabhela akambomba bhangi kuhuma mulipogha litu bhatehi kutukangacha. Bhakapiti kulitengeli lukela pachibhombu, ");
INSERT INTO mpa_vpl VALUES ("LK24_23","072_24_23","LUK","24","23","23","nambu ngachebhakajiweni hyegha jaki. Bhela bhakakelawiki na kutupwaghi kubha bhakapitaliwi na bhatumika bha kunani kwaka Chapanga na kubhapwaghi kubha Yesu abhi mwome. ");
INSERT INTO mpa_vpl VALUES ("LK24_24","072_24_24","LUK","24","24","24","Bhakumu bhitu bhakapiti kulitengeli, na kughahimani mambu ghokapi chakaka ngati mobhapwaghila akambomba bhala, nambu jombi ngachebhumbwene.” ");
INSERT INTO mpa_vpl VALUES ("LK24_25","072_24_25","LUK","24","25","25","Bhela Yesu akabhapwaghile, “Bho, mbona mbi mwang'ang'a bhenibhela, na mitima jinu jinonwopi kuhobhalela malobhi ghokapi ghaghalongaliki na bhalota bhaka Chapanga? ");
INSERT INTO mpa_vpl VALUES ("LK24_26","072_24_26","LUK","24","26","26","Bho, ngachekumpaliki Kristo kung'ahakika, na bhela kujingi mu ulumbalilu waki?” ");
INSERT INTO mpa_vpl VALUES ("LK24_27","072_24_27","LUK","24","27","27","Akabhapwaghi mambu ghokapi ghaghumpalika jombi mu Malembu Mahuhu ghokapi, kutumbu itabu yokapi yaka Musa na kujendale mu itabhu yokapi ya bhalota bhokapi bhaka Chapanga. ");
INSERT INTO mpa_vpl VALUES ("LK24_28","072_24_28","LUK","24","28","28","Pabhakaheghali pambipi na chijiji chebhapita chela, Yesu akalengiki kubha ngati ajendale na mwanja, ");
INSERT INTO mpa_vpl VALUES ("LK24_29","072_24_29","LUK","24","29","29","nambu bhombi bhakumpembali namaa, bhakapwaghaje, “Utama papamu na tepani, maghambu kutenda kupilila, na ikilu kuheghalela.” Bhela akapiti na kutama papamu nabhu. ");
INSERT INTO mpa_vpl VALUES ("LK24_30","072_24_30","LUK","24","30","30","Paakatami kula chilebhi papamu nabhu, akatoliki libumunda, akalipengalili, akalihekiti, na kubhapekeha. ");
INSERT INTO mpa_vpl VALUES ("LK24_31","072_24_31","LUK","24","31","31","Palapala mihu ghabhu ghakahoghuliwi, bhakummanye, nambu jombi akahobhiki pamihu jabhu. ");
INSERT INTO mpa_vpl VALUES ("LK24_32","072_24_32","LUK","24","32","32","Bhela bhakapwaghanile, “Bho, mitima jitu le ngachejibhelala mkati jitu paakabhi atuyekulila Malembu Mahuhu kwindela kola?” ");
INSERT INTO mpa_vpl VALUES ("LK24_33","072_24_33","LUK","24","33","33","Palapala bhakabhokiki na kukelabhuka ku Yelusalemu. Konikola bhakabhaketani mitumi komi na jumu bhala bhalibhongini papamu, bhakabya na bhandu bhangi bhabhakabhili papamu nabhu, ");
INSERT INTO mpa_vpl VALUES ("LK24_34","072_24_34","LUK","24","34","34","bhakapwaghaje, “Chakaka Bambo ayokike, na akumpitali Simoni.” ");
INSERT INTO mpa_vpl VALUES ("LK24_35","072_24_35","LUK","24","35","35","Bhela bhabhulwa bhabheli bhala bhakabhalandi mambu ghala ghaghapatiki mwindela, na ntundu mobhakummanyi paakabhi aheketa libumunda. ");
INSERT INTO mpa_vpl VALUES ("LK24_36","072_24_36","LUK","24","36","36","Pabhakabhi bhapwaghanila ghanihagha, palapala Yesu mweni akajemiki pachilanda jabhu, na kubhapwaghila, “Lukwali lukubha na mwehapa.” ");
INSERT INTO mpa_vpl VALUES ("LK24_37","072_24_37","LUK","24","37","37","Bhakakenyamwiki na kujoghopa namaa, bhakaholakya pangi bhaweni lihoka. ");
INSERT INTO mpa_vpl VALUES ("LK24_38","072_24_38","LUK","24","38","38","Nambu jombi akabhapwaghile, “Bho, mbona mlagha? Bho, mbona nkubha na choghohi mu mitima jinu? ");
INSERT INTO mpa_vpl VALUES ("LK24_39","072_24_39","LUK","24","39","39","Ndingalya mabhoku na magholu ghangu, kubha nde nepani namwete. Mbapiya mbonaje, maghambu lihoka ngachelibhi na hyegha wala ihupa ngati mommone nepane.” ");
INSERT INTO mpa_vpl VALUES ("LK24_40","072_24_40","LUK","24","40","40","Paakajomwi kulonge ghanighala, akabhalangi mabhoku na magholu ghaki. ");
INSERT INTO mpa_vpl VALUES ("LK24_41","072_24_41","LUK","24","41","41","Bhombi pabhakabhi bhakona ngakuhobhalela, kwa ndandi ja chiheku na kukangacha, Yesu akabhalalukile, “Bho, mbi na chilebhi chokapi chela pambane?” ");
INSERT INTO mpa_vpl VALUES ("LK24_42","072_24_42","LUK","24","42","42","Bhakumpeki chipandi cha homba ja kujocha. ");
INSERT INTO mpa_vpl VALUES ("LK24_43","072_24_43","LUK","24","43","43","Akachitoliki, akalili koni bhokapi bhakabya bhumbona. ");
INSERT INTO mpa_vpl VALUES ("LK24_44","072_24_44","LUK","24","44","44","Bhela akabhapwaghile, “Aghagha nde mambu ghanakumpwaghili chikahi panakabhi nakona papamu na mwehapa: Kubha ipalika ghapitalya mambu ghokapi ghaghalembakiki panani jangu mu Shelia yaka Musa, na mu Malembu gha bhalota bhaka Chapanga na mu Chitabu cha Zabuli.” ");
INSERT INTO mpa_vpl VALUES ("LK24_45","072_24_45","LUK","24","45","45","Panihapa akabhayekwi malangu ghabhu nahuli bhapata kumanya Malembu Mahuhu. ");
INSERT INTO mpa_vpl VALUES ("LK24_46","072_24_46","LUK","24","46","46","Akabhapwaghile, “Ilembakiki mu Malembu Mahuhu kubha Kristo aying'ahakika na kuyoka lichobha la katatu. ");
INSERT INTO mpa_vpl VALUES ("LK24_47","072_24_47","LUK","24","47","47","Bhandu bhokapi bhapalika kutangaziwa kwa lihina laki bhang'anambukaje na kughaleka mahoku ghabhu, na Chapanga anaabhalekakya mahoku ghabhu, kutumbula ku Yelusalemu na kwa inchi yokapi. ");
INSERT INTO mpa_vpl VALUES ("LK24_48","072_24_48","LUK","24","48","48","Mabhanganya nde momwapwaghila bhandu kubha mambu ghokapi ghaghapitalili hagha nde gha chakaka. ");
INSERT INTO mpa_vpl VALUES ("LK24_49","072_24_49","LUK","24","49","49","Nepani namweti ananundetila jola Atati wangu joapwaghiki anaantumaje. Nambu mwenga ndendalya moni mu Yelusalemu, mbaka pamwijopalya makili ghala ghaghahuma kunani kumahunde.” ");
INSERT INTO mpa_vpl VALUES ("LK24_50","072_24_50","LUK","24","50","50","Bhela akabhalongwi kunja ja muchi wa Yelusalemu mbaka ku Besania, akajinwi mabhoku ghaki na kubhapengalela. ");
INSERT INTO mpa_vpl VALUES ("LK24_51","072_24_51","LUK","24","51","51","Paakabhi abhapengalela, akabhalekiki, na kutolakeka kujenda kunani kumahunde. ");
INSERT INTO mpa_vpl VALUES ("LK24_52","072_24_52","LUK","24","52","52","Bhombi bhakunjojabhili, na panihapa bhakakelawiki ku Yelusalemu bhakabya na chiheku nakanopi. ");
INSERT INTO mpa_vpl VALUES ("LK24_53","072_24_53","LUK","24","53","53","Machobha ghokapi bhakajendali kutama pa Nyumba jaka Chapanga koni bhakundumbalya Chapanga. Amina.");
INSERT INTO mpa_vpl VALUES ("JN1_1","073_1_1","JHN","1","1","1","Mangani ja hindu yokapi kubhombakeka, kukabhi na Lilobhi, na Lilobhi hoju akabhi na Chapanga, najombi Lilobhi akabhi Chapanga. ");
INSERT INTO mpa_vpl VALUES ("JN1_2","073_1_2","JHN","1","2","2","Pakutumbula hapa Lilobhi hoju akabhi kwaka Chapanga. ");
INSERT INTO mpa_vpl VALUES ("JN1_3","073_1_3","JHN","1","3","3","Kupetela jombi Chapanga akabhombiki hindu yokapi, wala panga jombi nga chindu chokapi chechabhombakiki ambachu chibhombakike. ");
INSERT INTO mpa_vpl VALUES ("JN1_4","073_1_4","JHN","1","4","4","Jombi akabhi nde kutumbula kwa womi, na womi hoghu uletiki unang'anu wa bhandu. ");
INSERT INTO mpa_vpl VALUES ("JN1_5","073_1_5","JHN","1","5","5","Unang'anu hoghu ung'anya mulwihi, nalombi lwihi ngapalwaweziki kuluchuchuha. ");
INSERT INTO mpa_vpl VALUES ("JN1_6","073_1_6","JHN","1","6","6","Chapanga akuntumiki mundu jumu, lihina laki Yohana. ");
INSERT INTO mpa_vpl VALUES ("JN1_7","073_1_7","JHN","1","7","7","Akahikiki kubhapwaghi bhandu panani ja Unang'anu hoghu, nahuli kwa kupetela jombi bhandu bhokapi bhapata kujowana ulandilu waki na kuhobhalela. ");
INSERT INTO mpa_vpl VALUES ("JN1_8","073_1_8","JHN","1","8","8","Yohana mweni ngacheakabhi Unang'anu hoghu, nambu akahikiki kubhalandi bhandu panani ja Unang'anu hoghu. ");
INSERT INTO mpa_vpl VALUES ("JN1_9","073_1_9","JHN","1","9","9","Aghoghu nde Unang'anu wa chakaka, Unang'anu ghouhika pani pundema na kubhamulaki bhandu bhokapi. ");
INSERT INTO mpa_vpl VALUES ("JN1_10","073_1_10","JHN","1","10","10","Bhela Lilobhi jola akabhi pani pundema, na kwa kupetela jombi Chapanga akabhombiki ndema, nambu bhandu bha pundema ngachebhummanye. ");
INSERT INTO mpa_vpl VALUES ("JN1_11","073_1_11","JHN","1","11","11","Akahikiki kwa bhandu bhaki mweni, nambu bhombi ngachebhunjopalile. ");
INSERT INTO mpa_vpl VALUES ("JN1_12","073_1_12","JHN","1","12","12","Nambu bhokapi bhabhunjopalile na kunhobhalela, akabhapeki uwezu wa kuhengakeka bhana bhaka Chapanga, nde bhala bhabhalihobhalela lihina lake, ");
INSERT INTO mpa_vpl VALUES ("JN1_13","073_1_13","JHN","1","13","13","bhahengakiki bhana bhaka Chapanga nga kwa kubhelakeka ngati mobhabhelakake bhandu, au kwa kupala kwaka mundu, nambu bhabhelakiki kubhokana na Chapanga mweni. ");
INSERT INTO mpa_vpl VALUES ("JN1_14","073_1_14","JHN","1","14","14","Lilobhi akabhi mundu, na akatami kwitu, na tepani tukauweni ulumbalilu waki, ulumbalilu ngati waka Mwana kanjika joahuma kwa Atati, atweli chihomu na chakaka. ");
INSERT INTO mpa_vpl VALUES ("JN1_15","073_1_15","JHN","1","15","15","Yohana akabhalandi bhandu malobhi ghake, akajamalili nakanopi, na kupwagha, “Hajoju nde jola jonumpwaghilaje, ‘Joahika munyuma jangu, nambu nde nkolongwa kumbeta nepane, ndandi jombi akabhi mangane ja kubhelekeka nepani.’ ” ");
INSERT INTO mpa_vpl VALUES ("JN1_16","073_1_16","JHN","1","16","16","Kubhokana na ukamilifu waki, tepani tabhokapi tujopali chihomu panani ja chihomu. ");
INSERT INTO mpa_vpl VALUES ("JN1_17","073_1_17","JHN","1","17","17","Maghambu Chapanga akabhohiki Shelia kwa indela jaka Musa, nambu chihomu chaka Chapanga na chakaka jikahikiki kwa indela jaka Yesu Kristo. ");
INSERT INTO mpa_vpl VALUES ("JN1_18","073_1_18","JHN","1","18","18","Nga mundu jokapi joambweni Chapanga mu chikahi chokapi chela ng'o, nambu Chapanga Mwana kanjika jaki, joabhi pachihimba cha Atati waki, jonihoju nde joatulangihe ntundu Chapanga moabhelile. ");
INSERT INTO mpa_vpl VALUES ("JN1_19","073_1_19","JHN","1","19","19","Haghoghu nde ulandilu waka Yohana, chikahi bhakolongwa bha Bhayahude pabhakabhatumiki bhapenganyambiku na Bhalawi kuhuma ku Yelusalemu nahuli bhakundalukyaje, “Bho, wehapa wa nane?” ");
INSERT INTO mpa_vpl VALUES ("JN1_20","073_1_20","JHN","1","20","20","Yohana akajetakili, wala ngacheakaniki, akapwaghike, “Nepani nga Kristo.” ");
INSERT INTO mpa_vpl VALUES ("JN1_21","073_1_21","JHN","1","21","21","Bhakundalukile, “Bho, henu wehapa wa nane? Bho, wehapa le wa Eliya?” Yohana akabhayangike, “Nga nepane.” Bhakundaluki kabhete, “Bho, wehapa le wa Mlota waka Chapanga jola?” Akabhayangike, “Nga nepane.” ");
INSERT INTO mpa_vpl VALUES ("JN1_22","073_1_22","JHN","1","22","22","Bhela bhakumpwaghile, “Bho, wehapa wa nane? Bho, ulilongale bhole panani jaku wamwete? Utupwaghilaje, nahuli tupata liyangu la kubhapelakela bhala bhabhatutumike.” ");
INSERT INTO mpa_vpl VALUES ("JN1_23","073_1_23","JHN","1","23","23","Yohana akabhayangiki na kupwagha, ngati moakapwaghi mlota Isaya, “Nepani nde sauti jaka mundu jejijamalila kulipololu, ‘Ndenganakyaje indela jaka Bambo!’ ” ");
INSERT INTO mpa_vpl VALUES ("JN1_24","073_1_24","JHN","1","24","24","Na bhandu bhala bhabhakatumakiki bhakabhi bhahumiki kwa Mafalisayo. ");
INSERT INTO mpa_vpl VALUES ("JN1_25","073_1_25","JHN","1","25","25","Bhakundaluki Yohana, “Ngati wehapa nga wa Kristo, au nga wa Eliya, wala nga wa Mlota waka Chapanga jola, bho, maghambu ki ubatiza?” ");
INSERT INTO mpa_vpl VALUES ("JN1_26","073_1_26","JHN","1","26","26","Yohana akabhayangiki, akapwaghaje, “Nepani numbatiza kwa machi, nambu pachilanda jinu ajemiki mundu jwanga mabhanganya kummanya. ");
INSERT INTO mpa_vpl VALUES ("JN1_27","073_1_27","JHN","1","27","27","Jombi nde joahika punyuma jangu, nepani ngachembalika hata kujibhopola mighoji ja magubasi ghake.” ");
INSERT INTO mpa_vpl VALUES ("JN1_28","073_1_28","JHN","1","28","28","Mambu aghagha ghokapi ghakahengakiki ku muchi wa Besania, kwihi ja nkoka Yoludani, koakabhi Yohana abatiza. ");
INSERT INTO mpa_vpl VALUES ("JN1_29","073_1_29","JHN","1","29","29","Chilabhu jaki, Yohana akumbweni Yesu akahikaje kwaki, akapwaghike, “Lingalyaje, hajoju nde Mwanalimbeleli waka Chapanga, joatola mahoku gha ndema! ");
INSERT INTO mpa_vpl VALUES ("JN1_30","073_1_30","JHN","1","30","30","Hajoju nde jola jonukupwaghili, ‘Anahika mundu punyuma jangu, joabhi nkolongwa kumbeta nepani, maghambu jombi akabhili mangane ja kubhelakeka nepane.’ ");
INSERT INTO mpa_vpl VALUES ("JN1_31","073_1_31","JHN","1","31","31","Nepani namwete ngachenummanye, nambu nhikiki kubatiza kwa machi, nahuli bhandu bha Izilaeli bhapata kummanya jombi.” ");
INSERT INTO mpa_vpl VALUES ("JN1_32","073_1_32","JHN","1","32","32","Yohana akalandili ana, “Nakumbweni Roho Mhuhu akahelalaje kuhuma kunani kumahunde ngati ngunda, na kumetela panani jaki. ");
INSERT INTO mpa_vpl VALUES ("JN1_33","073_1_33","JHN","1","33","33","Nepani ngachenummanyike, nambu jola joandumiki kubatiza kwa machi, jonihoju akambwaghile, ‘Jola jowambonaje Roho akahelalaje na kutama panani jaki, jonihoju nde joabatiza kwa Roho Mhuhu.’ ");
INSERT INTO mpa_vpl VALUES ("JN1_34","073_1_34","JHN","1","34","34","Yohana akapwaghiki, nepani mweni lijambu leniheli, na nandila chakaka kubha hajoju nde Mwana waka Chapanga.” ");
INSERT INTO mpa_vpl VALUES ("JN1_35","073_1_35","JHN","1","35","35","Chilabhu jaki kabhete, Yohana akabhi ajemiki papamu na bhabhulwa bhaki bhabhele. ");
INSERT INTO mpa_vpl VALUES ("JN1_36","073_1_36","JHN","1","36","36","Paakumbweni Yesu akapetaje, akapwaghike, “Lingalyaje, hajoju nde Mwanalimbeleli waka Chapanga!” ");
INSERT INTO mpa_vpl VALUES ("JN1_37","073_1_37","JHN","1","37","37","Bhabhulwa bhabheli bhala bhakunjowini Yohana akalongilaje, bhakunjengali Yesu. ");
INSERT INTO mpa_vpl VALUES ("JN1_38","073_1_38","JHN","1","38","38","Yesu akang'anambwiki, na paakabhaweni bhabhulwa habha bhakunjengalyaje, akabhapwaghile, “Bho, mpala kike?” Bhakamuyangike, “Labi,” ndandi jaki, “Mbola,” bho, utama kwako? ");
INSERT INTO mpa_vpl VALUES ("JN1_39","073_1_39","JHN","1","39","39","Yesu akabhapwaghile, “Muhikaje, nanamu anambonaje. Bhabhulwa habha bhakunjengalile, na kupabhona paatama, na bhakatami kwaki lichobha lela. Ndandi kukabhi ngati saa kumi pakamihi.” ");
INSERT INTO mpa_vpl VALUES ("JN1_40","073_1_40","JHN","1","40","40","Andulea, ndongu waka Simoni Petulu, akabhi jumu wa bhabheli bhala bhabhakunjowini Yohana akalongilaje ghanihagha, na kunjengalela Yesu. ");
INSERT INTO mpa_vpl VALUES ("JN1_41","073_1_41","JHN","1","41","41","Jonihoju akumbweni hoti Simoni, ndongu waki mweni, na akumpwaghile, “Tumbweni Masihi.” Ndandi jaki, “Kristo.” ");
INSERT INTO mpa_vpl VALUES ("JN1_42","073_1_42","JHN","1","42","42","Najombi akumpeliki Simoni kwaka Yesu. Najombi Yesu akundingalili, na kumpwaghila, “Wehapa wa Simoni, mwana waka Yohana, nanau anaulowakika Kefa.” Ndandi jaki kwa Kigiliki nde Petulu, au Liganga. ");
INSERT INTO mpa_vpl VALUES ("JN1_43","073_1_43","JHN","1","43","43","Lichobha la kabheli laki Yesu akapaliki kujenda ku inchi ja Galilaya. Bhela akumbweni Filipo, na kumpwaghila, “Unyengalyaje!” ");
INSERT INTO mpa_vpl VALUES ("JN1_44","073_1_44","JHN","1","44","44","Filipo akabhi mundu wa kuhuma ku muchi wa Betisaida, mwenehi wa muchi ghobhatama Andulea na Petulu. ");
INSERT INTO mpa_vpl VALUES ("JN1_45","073_1_45","JHN","1","45","45","Filipo akumbweni Nathanaeli, na kumpwaghila, “Tumbweni jombi ambaju Musa akalembiki panani jaki mu chitabu cha Shelia, na ambaju bhalota bhaka Chapanga nabhombi bhakalembiki panani jaki. Nde Yesu, mwana waka Yusufu, kuhuma ku muchi wa Nazaleti.” ");
INSERT INTO mpa_vpl VALUES ("JN1_46","073_1_46","JHN","1","46","46","Nathanaeli akumpwaghi Filipo, “Bho, liwezikana bholi lilobhi lamboni lihuma ku Nazaleti?” Filipo akumpwaghile, “Uhika ulolaje.” ");
INSERT INTO mpa_vpl VALUES ("JN1_47","073_1_47","JHN","1","47","47","Bhela Yesu akumbweni Nathanaeli akahika kwaki, na kulongela malobhi ghaki, “Lingalyaje Mwizilaeli chakaka, ngacheabhi na upuhi mkati jake.” ");
INSERT INTO mpa_vpl VALUES ("JN1_48","073_1_48","JHN","1","48","48","Nathanaeli akumpwaghile, “Bho, upatiki bholi kumanya?” Yesu akamuyangiki, akapwaghaje, “Nakakuweni mangane Filipo ngacheakulohiki, paukabhi pahi ja nkongu wa mtini.” ");
INSERT INTO mpa_vpl VALUES ("JN1_49","073_1_49","JHN","1","49","49","Nathanaeli akamuyangike, “Mbola, wehapa wa Mwana waka Chapanga! Wehapa nde Unkolongwa wa Izilaeli!” ");
INSERT INTO mpa_vpl VALUES ("JN1_50","073_1_50","JHN","1","50","50","Yesu akamuyangiki, na kumpwaghila, “Bho, maghambu nakakupwaghi, nakakuweni pahi ja nkongu wa mtini, nde ndandi uhobhalela? Anaubhonaje mambu makolongwa nakanopi kupeta ghangane.” ");
INSERT INTO mpa_vpl VALUES ("JN1_51","073_1_51","JHN","1","51","51","Yesu akajendali kubhapwaghila, numpwaghila, “Chakaka, anambonaje kunani kumahunde kuhoghoka, na bhatumika bhaka Chapanga bhakahelalaje na kukwela panani jaka Mwana waka Mundu.” ");
INSERT INTO mpa_vpl VALUES ("JN2_1","073_2_1","JHN","2","1","1","Na lichobha la katatu kukabhi na ukwati ku muchi wa Kana, ja ku Galilaya. Na mabhu waka Yesu akabhi konikola, ");
INSERT INTO mpa_vpl VALUES ("JN2_2","073_2_2","JHN","2","2","2","Yesu najombi akabhi bhunkokiki paukwati ghola papamu na bhabhulwa bhaki. ");
INSERT INTO mpa_vpl VALUES ("JN2_3","073_2_3","JHN","2","3","3","Chikahi divai pajajomwiki, mabhu waka Yesu akumpwaghile, “Ngachebhabhi na divai.” ");
INSERT INTO mpa_vpl VALUES ("JN2_4","073_2_4","JHN","2","4","4","Yesu akumpwaghile, “Mbomba, bho, maghambu kiki umbwaghi malobhi aghagha nepane? Chenjenu nga chikahi chechipalika kwangu nepani kuhenga leniheli.” ");
INSERT INTO mpa_vpl VALUES ("JN2_5","073_2_5","JHN","2","5","5","Amabhu waka Yesu akabhapwaghi bhatumika, “Lokapi lenaampwaghilaje, mulihengaje.” ");
INSERT INTO mpa_vpl VALUES ("JN2_6","073_2_6","JHN","2","6","6","Bhela kukabhi na ihulu sita ya maganga, kila chimu chakabhi na ukolongwa wa kutama machi madebi ghabheli au ghatatu, nayombi ikabhekakiki konihoku ngati mowabheli ntetu wa Bhayahude wa kuligholola kwa ndandi ja kunjojabhe Chapanga. ");
INSERT INTO mpa_vpl VALUES ("JN2_7","073_2_7","JHN","2","7","7","Yesu akabhapwaghile, “Ntwelakya machi tuwe mwihulu heyi.” Nabhombi bhakatwelaki mbaka panani. ");
INSERT INTO mpa_vpl VALUES ("JN2_8","073_2_8","JHN","2","8","8","Akabhapwaghile, “Henu ntekaje, na mumpelakyaje nkolongwa wa ukwati.” Nabhombi bhakapeliki. ");
INSERT INTO mpa_vpl VALUES ("JN2_9","073_2_9","JHN","2","9","9","Najombi nkolongwa wa chilebhe cha ukwati paakaghaonjiki machi ghala ghakang'anambwiki kubha divai, panga na kumanya koghahumiki, nambu bhatumika bhakamanyiki, bhala bhabhatekiki machi ghala, nkolongwa wa ukwati jola akundohiki bambo ukwati, ");
INSERT INTO mpa_vpl VALUES ("JN2_10","073_2_10","JHN","2","10","10","akumpwaghile, “Kila mundu atumbu hoti kuandaa divai jambone, na bhandu anabhanywili nakanopi, bhaleta divai jangakunogha. Nambu wehapa ujibhekiki divai jamboni mbaka sajenu!” ");
INSERT INTO mpa_vpl VALUES ("JN2_11","073_2_11","JHN","2","11","11","Nginyulila jenjenu ja kutumbula akahengiki Yesu ku Kana ja ku Galilaya, na kulangiha ulumbalilu waki, na bhabhhulwa bhaki bhakunhobhalile. ");
INSERT INTO mpa_vpl VALUES ("JN2_12","073_2_12","JHN","2","12","12","Paghapetiki ghanigala Yesu akahelili mbaka ku Kapelenaumu, jombi na mabhu waki na bhalongu bhaki na bhabhulwa bhaki, bhakatemi konihoku kwa machobha machokope. ");
INSERT INTO mpa_vpl VALUES ("JN2_13","073_2_13","JHN","2","13","13","Pasaka ja Bhayahude jakabhi jiheghalile, najombi Yesu akakweliki mbaka ku Yelusalemu. ");
INSERT INTO mpa_vpl VALUES ("JN2_14","073_2_14","JHN","2","14","14","Akapaweni pala pa liwangala la Nyumba jaka Chapanga bhandu bhakahemalya ng'ombi, na mambeleli, na ngunda na bhabhang'anambu mbija bhatami pameza yabhu. ");
INSERT INTO mpa_vpl VALUES ("JN2_15","073_2_15","JHN","2","15","15","Akalokiki ntibhi kubha chiboku, akabhabhohiki bhokapi pa liwangala la Nyumba jaka Chapanga, na mambeleli na ng'ombi, akajitili mbija ya bhabhang'anambu mbija, na kuipendula meza yabhu, ");
INSERT INTO mpa_vpl VALUES ("JN2_16","073_2_16","JHN","2","16","16","akabhapwaghi bhala bhabhahemalela ngunda, “Muhibhoha hindu hayeyi pambane, na ngamwajitenda nyumba ja Atati wangu kubha pandu pa kuhemela na kulombasela!” ");
INSERT INTO mpa_vpl VALUES ("JN2_17","073_2_17","JHN","2","17","17","Bhabhulwa bhaki bhakakombwiki kubha ilembakiki mu Malembu Mahuhu, “Wenga wa Chapanga, wihu wangu kwa nyumba jaku unyocha ngati moto!” ");
INSERT INTO mpa_vpl VALUES ("JN2_18","073_2_18","JHN","2","18","18","Henu Bhayahude bhakamuyangiki, na kumpwaghila, “Bho, anautulangiha nginyulila bholi, nahuli kutulangiha kubha ubhi na lujiniku lwa kuhenga mambu ghangane?” ");
INSERT INTO mpa_vpl VALUES ("JN2_19","073_2_19","JHN","2","19","19","Yesu akabhayangike, na kubhapwaghila, “Mjibhombulaje Nyumba jaka Chapanga hajeji, na nepani ananjengaje kwa machobha ghatatu.” ");
INSERT INTO mpa_vpl VALUES ("JN2_20","073_2_20","JHN","2","20","20","Bhela Bhayahude bhakapwaghike, “Nyumba jaka Chapanga hajeji jakachengakiki kwa hyaka alobaini na sita, bho, na wehapa anauchengaje kwa machobha ghatatu?” ");
INSERT INTO mpa_vpl VALUES ("JN2_21","073_2_21","JHN","2","21","21","Nambu jombi akapwagiki kwa nyumba ja hyegha jake. ");
INSERT INTO mpa_vpl VALUES ("JN2_22","073_2_22","JHN","2","22","22","Bhela Yesu paakayokiki kuhuma kwa bhakuwa, bhabhulwa bhaki bhakakombwiki kubha akapwaghiki ghanihagha, bhakaghahobhalili Malembu Mahuhu ghala, na malobhi ghokapi ghaakalongi Yesu. ");
INSERT INTO mpa_vpl VALUES ("JN2_23","073_2_23","JHN","2","23","23","Yesu paakabhi ku Yelusalemu ku uwangalalu wa Pasaka, bhandu bhamaheli bhakunhobhali kubha jombi nde Masihi, pabhiweni nginyulila yaki yeakahengike. ");
INSERT INTO mpa_vpl VALUES ("JN2_24","073_2_24","JHN","2","24","24","Nambu Yesu ngacheabhahobhalile, kwa ndandi jombi akabhamanyiki bhokapi, ");
INSERT INTO mpa_vpl VALUES ("JN2_25","073_2_25","JHN","2","25","25","na ngacheakabhi na ndandi ja kupala mundu wa kundandila mambu gha bhandu, kwa ndandi jombi mweni akamanyiki ghaghabhi mkati ja mtima waka mundu. ");
INSERT INTO mpa_vpl VALUES ("JN3_1","073_3_1","JHN","3","1","1","Kukabhi na mundu jumu wa Mafalisayo, lihina laki Nikodemu, jumu wa ihongozi bha pachengu pa Bhayahude. ");
INSERT INTO mpa_vpl VALUES ("JN3_2","073_3_2","JHN","3","2","2","Lichobha limu ikilu Nikodemu akunjedi Yesu, na kumpwaghila, “Labi, tumanyi kubha wehapa nde wambola, uhumiki kwaka Chapanga, kwa ndandi nga mundu joaweza kutenda nginyulila hayeyi yewitenda wehapa, nambu Chapanga abhi papamu naku.” ");
INSERT INTO mpa_vpl VALUES ("JN3_3","073_3_3","JHN","3","3","3","Yesu akamuyangiki, na kumpwaghila, “Chakaka, nukupwaghila, mundu nangakubhelakeka mala ja kabhele, ngaawezi kuubhona Ukolongwa waka Chapanga.” ");
INSERT INTO mpa_vpl VALUES ("JN3_4","073_3_4","JHN","3","4","4","Nikodemu akampwaghile, “Bho, aweza bholi mundu kubhelakeka kabheti, koni asejike? Bho, aweza kujingi mulutumbu lwa mabhu waki mala ja kabheli na kubhelakeka?” ");
INSERT INTO mpa_vpl VALUES ("JN3_5","073_3_5","JHN","3","5","5","Yesu akayangike, “Nukupwaghi chakaka, mundu nangakubhelakeka kwa machi na kwa Roho Mhuhu, ngaawezi kujingila mu Ukolongwa waka Chapanga. ");
INSERT INTO mpa_vpl VALUES ("JN3_6","073_3_6","JHN","3","6","6","Mundu abhelakeka kihyegha kwa atati na mabhu, nambu chechibhelakiki kiroho nde Roho Mhuhu. ");
INSERT INTO mpa_vpl VALUES ("JN3_7","073_3_7","JHN","3","7","7","Ngawikangacha ndandi nukupwaghili, ‘Hipalika kubhelakeka mala ja kabhele.’ ");
INSERT INTO mpa_vpl VALUES ("JN3_8","073_3_8","JHN","3","8","8","Mpongu upogha koupala, na kupogha kwaki ukujowana, nambu ngacheumanya kouhuma wala koujenda. Bhenibhela nde mokubhelela kwaka mundu jola joabhelakiki kwa Roho Mhuhu.” ");
INSERT INTO mpa_vpl VALUES ("JN3_9","073_3_9","JHN","3","9","9","Nikodemu akundaluki Yesu, “Bho, mambu haghagha ghawezikana bholi kubha?” ");
INSERT INTO mpa_vpl VALUES ("JN3_10","073_3_10","JHN","3","10","10","Yesu akamuyangiki, na kumpwaghila, “Bho, wehapa ubhi wambola wa ku Izilaeli, na mambu haghagha ngacheughamanye? ");
INSERT INTO mpa_vpl VALUES ("JN3_11","073_3_11","JHN","3","11","11","Nukupwaghi chakaka kubha, lela letulimanya tulipwagha, na lela letuliweni tulilandila, kabheti ulandilu witu ngachemujetakela. ");
INSERT INTO mpa_vpl VALUES ("JN3_12","073_3_12","JHN","3","12","12","Ngati numpwaghili mambu gha pani pundema, wala ngachemuhobhalela, bho, mwiweza bholi kuhobhalela, ananumpwaghi mambu gha kunani kumahunde? ");
INSERT INTO mpa_vpl VALUES ("JN3_13","073_3_13","JHN","3","13","13","Nga mundu joapiti kunani kumahunde, nambu jombi joaheli kuhuma kunani kumahunde, yani, Mwana waka Mundu joatama kunani kumahunde.” ");
INSERT INTO mpa_vpl VALUES ("JN3_14","073_3_14","JHN","3","14","14","Na ngati Musa moakalikwehi lijoka la shaba punkongu kulipololu kola, najombi Mwana waka Mundu anakwehakika bhelabhela, ");
INSERT INTO mpa_vpl VALUES ("JN3_15","073_3_15","JHN","3","15","15","nahuli kila mundu joanhobhalela akubhaje na womi wa mileli muka jombi. ");
INSERT INTO mpa_vpl VALUES ("JN3_16","073_3_16","JHN","3","16","16","Maghambu kwa ntundu aghoghu Chapanga akaupaliki ndema, hata akumbohiki Mwana waki wa kanjika, nahuli kila mundu joanhobhalela ngayihobha, nambu akubhaje na womi wa mileli. ");
INSERT INTO mpa_vpl VALUES ("JN3_17","073_3_17","JHN","3","17","17","Kwa ndandi Chapanga ngacheakuntumiki Mwana waki pani pundema nahuli kubhatemula bhandu bha pundema, nambu bhandu bha pundema bhapata kukengalewa kwa indela jaka jombi. ");
INSERT INTO mpa_vpl VALUES ("JN3_18","073_3_18","JHN","3","18","18","Joanhobhale Mwana waka Chapanga ngacheatemuliwa, nambu jwangakunhobhalela ajomwi kutemuliwa, maghambu ngachealihobhalili lihina laka Mwana wa kanjika waka Chapanga. ");
INSERT INTO mpa_vpl VALUES ("JN3_19","073_3_19","JHN","3","19","19","Na ghongoni nde utemuliku: Kubha unang'anu uhikiki kwa bhandu bha pundema, na bhandu bhakapaliki lwihi kuliku unang'anu, maghambu matendu ghabhu ghakabhi mahakau. ");
INSERT INTO mpa_vpl VALUES ("JN3_20","073_3_20","JHN","3","20","20","Ndandi kila mundu joatenda mahakau auhakalila unang'anu, wala ngacheahika mu unang'anu, nahuli matendu ghaki ngaghihika kulakaliwa. ");
INSERT INTO mpa_vpl VALUES ("JN3_21","073_3_21","JHN","3","21","21","Nambu jola joatenda gha chakaka ahika mu unang'anu, nahuli matendu ghaki ghabhonikanaje hotuhotu kubha ghahengakiki muka Chapanga. ");
INSERT INTO mpa_vpl VALUES ("JN3_22","073_3_22","JHN","3","22","22","Paghajomwiki ghanihagha Yesu na bhabhulwa bhaki bhakapiti mbaka ku inchi ja ku Yudea, akapilaki konihoku papamu nabhu, na kubatiza bhandu. ");
INSERT INTO mpa_vpl VALUES ("JN3_23","073_3_23","JHN","3","23","23","Yohana akabhi akabatiza bhandu ku Ainoni, pambipi na Salimu, kwa ndandi konihoku kukabhi na machi ghamaheli, na bhandu bhakunjendile, nabhombi bhakabatizwi. ");
INSERT INTO mpa_vpl VALUES ("JN3_24","073_3_24","JHN","3","24","24","Haghagha ghakahengakiki chikahi Yohana paakabhi akali ngacheabhekakiki muchifungo. ");
INSERT INTO mpa_vpl VALUES ("JN3_25","073_3_25","JHN","3","25","25","Bhela kukapitali kulochana kwa bhabhulwa bhaka Yohana na Myahude jumu panani ja ntetu wa kuligholola kwa ndandi ja kunjojabhe Chapanga. ");
INSERT INTO mpa_vpl VALUES ("JN3_26","073_3_26","JHN","3","26","26","Bhakunjendi Yohana, na kumpwaghila, “Mbola, jombi joakabhi papamu na wehapa kwihi ja Yoludani, jola joukamlandile malobhi ghaki, lingalyaje, sajenu atenda kubatiza, na bhandu bhokapi bhunjende jombi.” ");
INSERT INTO mpa_vpl VALUES ("JN3_27","073_3_27","JHN","3","27","27","Yohana akayangiki, na kupwagha, “Ngacheaweza mundu kujopalela lilobhi lokapi lela, pangakubha apatiki kuhuma kunani kwaka Chapanga. ");
INSERT INTO mpa_vpl VALUES ("JN3_28","073_3_28","JHN","3","28","28","Mabhanganya mabheni mwabhalandilu bhangu kubha nakapwaghiki, ‘Nepani nga Kristo, nambu ndumakiki palongi jaki.’ ");
INSERT INTO mpa_vpl VALUES ("JN3_29","073_3_29","JHN","3","29","29","Joabhi naku mabhu ukwati nde bambo ukwati, nambu nkochi waki bambo ukwati, jombi joajema na kunjowanela, ahekalela paajowana malobhi akalongila bambo ukwati. Bhenibhela nde chiheku changu mochikamilikila. ");
INSERT INTO mpa_vpl VALUES ("JN3_30","073_3_30","JHN","3","30","30","Bhela Yesu ipalika atopila nakanopi, nambu nepani mbunguwaje.” ");
INSERT INTO mpa_vpl VALUES ("JN3_31","073_3_31","JHN","3","31","31","Jombi joahika kuhuma kunani kumahunde, nde nkolongwa kupeta bhokapi. Jombi joabhi wa pani pundema, nde wa pundema, najombi apwagha mambu gha pundema. Nambu joahika kuhuma kunani kumahunde atawala panani ja ghokapi. ");
INSERT INTO mpa_vpl VALUES ("JN3_32","073_3_32","JHN","3","32","32","Ghala ghaaghaweni na kughajowana, nde ghaaghalandila, na nga mundu joajetakela ulandilu waki. ");
INSERT INTO mpa_vpl VALUES ("JN3_33","073_3_33","JHN","3","33","33","Jombi joajetakili ulandilu waki ammanyakisha kubha Chapanga nde chakaka. ");
INSERT INTO mpa_vpl VALUES ("JN3_34","073_3_34","JHN","3","34","34","Kwa ndandi jombi joatumakiki na Chapanga aghalonge malobhi ghaka Chapanga, ndandi Chapanga antwelakela Roho Mhuhu waki panga na chipemu. ");
INSERT INTO mpa_vpl VALUES ("JN3_35","073_3_35","JHN","3","35","35","Atati ampala Mwana, najombi ampeki hindu yokapi mumabhoku ghaki. ");
INSERT INTO mpa_vpl VALUES ("JN3_36","073_3_36","JHN","3","36","36","Joanhobhalela Mwana abhi na womi wa mileli, na jwangakunhobhalela Mwana ngaubhoni womi, nambu inyela jaka Chapanga anajuntamilaje panani jaki. ");
INSERT INTO mpa_vpl VALUES ("JN4_1","073_4_1","JHN","4","1","1","Mafalisayo bhakajowini kubha Yesu abhapata bhabhulwa bhamaheli kupeta Yohana, na kubhabatiza bhandu. ");
INSERT INTO mpa_vpl VALUES ("JN4_2","073_4_2","JHN","4","2","2","Nambu nga Yesu mweni joakabhi abatiza bhandu, nambu bhabhulwa bhaki, ");
INSERT INTO mpa_vpl VALUES ("JN4_3","073_4_3","JHN","4","3","3","Bhela Yesu paakajowini mambu ghanihagha akabhokiki ku inchi ja Yudea, na akakelawiki kabheti mbaka ku Galilaya. ");
INSERT INTO mpa_vpl VALUES ("JN4_4","073_4_4","JHN","4","4","4","Pamwanja ghonihoghu ikampaliki kupeta ku muchi wa Samalia. ");
INSERT INTO mpa_vpl VALUES ("JN4_5","073_4_5","JHN","4","5","5","Bhela akahikiki ku muchi wa ku Samalia, ghoulowakeka Sikali, pambipi na ngonda ghola Yakobo ghoakumpeki Yusufu mwana waki. ");
INSERT INTO mpa_vpl VALUES ("JN4_6","073_4_6","JHN","4","6","6","Na panihapa pakabhi na chilibha chaka Yakobo. Bhela Yesu, kwa ndandi akatondiki na mwanja waki, akatami pambipi na pachilibha pala. Kukabhi ngati saa sita ja muhi. ");
INSERT INTO mpa_vpl VALUES ("JN4_7","073_4_7","JHN","4","7","7","Bhela akahikiki mbomba Msamalia kuteka machi. Yesu akumpwaghile, “Mbekya machi ngunywaje.” ");
INSERT INTO mpa_vpl VALUES ("JN4_8","073_4_8","JHN","4","8","8","Kwa ndandi chikahi hechi bhabhulwa bhaka Yesu bhakapiti kumbwani kuheme chilebhe. ");
INSERT INTO mpa_vpl VALUES ("JN4_9","073_4_9","JHN","4","9","9","Bhela mbomba Msamalia jola akumpwaghi Yesu, “Bho, kubhi bholi wehapa wa Myahude kupala machi kwangu nepani, koni nepani nu mbomba Msamalia?” Maghambu Bhayahude ngachebhajongana na Bhasamalia hata pachokope. ");
INSERT INTO mpa_vpl VALUES ("JN4_10","073_4_10","JHN","4","10","10","Yesu akamuyangiki, na kumpwaghila, “Ngati ukamanyiki chindu chela Chapanga cheapala kukupekeha, najombi nde nane joakupwaghila, ‘Mbekya machi ngunywaje,’ ukabya unjopiki jombi, najombi akabya akupekihi machi ghaghabhi ghomi.” ");
INSERT INTO mpa_vpl VALUES ("JN4_11","073_4_11","JHN","4","11","11","Mbomba jola akumpwaghile, “Bambo, ngacheubhi na chindu cha kutekela machi, na chilibha nde chilachu. Bho, ughapatiki kwaku machi ghanihagha ghaghabhi ghomi? ");
INSERT INTO mpa_vpl VALUES ("JN4_12","073_4_12","JHN","4","12","12","Bho, wehapa ubhi unkolongwa kupeta tati witu Yakobo, joakatupeki chilibha chenu, najombi akanywili machi ghaki, na bhana bhaki, na hinyama yaki?” ");
INSERT INTO mpa_vpl VALUES ("JN4_13","073_4_13","JHN","4","13","13","Yesu akamuyangiki, na kumpwaghila, “Kila joakunywa machi aghagha anaabhona nywita kabhete. ");
INSERT INTO mpa_vpl VALUES ("JN4_14","073_4_14","JHN","4","14","14","Nambu mundu jokapi joanakunywa machi ghala ghaananumpekya nepani ngaibhoni inywita mileli. Nambu machi ghala ghaananupekya anaghabya chemichemi ja machi mkati jaki, ghakajitikaje womi wa mileli.” ");
INSERT INTO mpa_vpl VALUES ("JN4_15","073_4_15","JHN","4","15","15","Mbomba jola akapwaghike, “Bambo, umbekya machi ghanihagha, nganibhona inywita kabhete, wala nganihika kabhete pambane kuteka machi.” ");
INSERT INTO mpa_vpl VALUES ("JN4_16","073_4_16","JHN","4","16","16","Yesu akumpwaghile, “Jendaje ukundoha ndomi waku, na uhika naku pambane.” ");
INSERT INTO mpa_vpl VALUES ("JN4_17","073_4_17","JHN","4","17","17","Mbomba jola akamuyangiki, na kupwagha, “Ngachemili na ndomi wangu.” Yesu akumpwaghile, “Uyangiki wichu, ngacheubhi na ndomi waku. ");
INSERT INTO mpa_vpl VALUES ("JN4_18","073_4_18","JHN","4","18","18","Kwa ndandi ubhi na akanalomi nhwanu, na mwanalomi joubhi naku sajenu nga ndomi wako, panihapa upwaghiki chakaka.” ");
INSERT INTO mpa_vpl VALUES ("JN4_19","073_4_19","JHN","4","19","19","Mbomba jola akumpwaghile, “Bambo, mona kubha wehepa wa mlota waka Chapanga. ");
INSERT INTO mpa_vpl VALUES ("JN4_20","073_4_20","JHN","4","20","20","Akahoko bhitu bhakabhi bhajojabhela pa chitombi achechi, nanamu mpwagha kubha ku Yelusalemu nde pandu pa chakaka pa kunjojabhela Chapanga.” ");
INSERT INTO mpa_vpl VALUES ("JN4_21","073_4_21","JHN","4","21","21","Yesu akumpwaghile, “Mbomba, unhobhalyaje chembwagha, machobha ghahika ambapu ngamwanjojabheli Atati pa chitombi achechi, wala ku Yelusalemu. ");
INSERT INTO mpa_vpl VALUES ("JN4_22","073_4_22","JHN","4","22","22","Mwenga Bhasamalia mkijojabhela changa kuchimanya, nambu tepani tujojabhela chetukimanya, maghambu ukengaleku uhuma kwa Bhayahude. ");
INSERT INTO mpa_vpl VALUES ("JN4_23","073_4_23","JHN","4","23","23","Nambu chikahi chihika, na chombi chihikike, ambapu bhajojabhela bha chakaka anabhunjojabya Atati mu Roho Mhuhu na mu chakaka. Kwa ndandi Atati abhalonda bhandu ngati bhanihaba bhunjojabyaje. ");
INSERT INTO mpa_vpl VALUES ("JN4_24","073_4_24","JHN","4","24","24","Chapanga nde Roho, na bhombi bhabhunjojabhe jombi ibhapalika kunjojabhela mu Roho Mhuhu na mu chakaka.” ");
INSERT INTO mpa_vpl VALUES ("JN4_25","073_4_25","JHN","4","25","25","Mbomba jola akumpwaghile, “Manyi kubha anahika Masihi, joalowakeka Kristo, najombi paanahikaje, jombi anaatuhyekulyaje mambu ghokapi.” ");
INSERT INTO mpa_vpl VALUES ("JN4_26","073_4_26","JHN","4","26","26","Yesu akamuyangike, “Nepani nenongela na wehapa, nde Masihi.” ");
INSERT INTO mpa_vpl VALUES ("JN4_27","073_4_27","JHN","4","27","27","Panihapa bhakahikiki bhabhulwa bhaki, bhakakangichi ndandi Yesu akabhi alongela na mbomba, nambu njeta hata jumu joakapwaghike, “Bho, ulonda kike?” Au, kundalukila, “Bho, mbona ulongela na mbomba?” ");
INSERT INTO mpa_vpl VALUES ("JN4_28","073_4_28","JHN","4","28","28","Bhela mbomba jola akachilekiki chihulu chaki, na kujenda kumbwane, na kubhapwaghi bhandu, ");
INSERT INTO mpa_vpl VALUES ("JN4_29","073_4_29","JHN","4","29","29","“Muhikaje, mumbona mundu joambwaghi mambu ghokapi ghanhengike. Bho, iwezekana le kubha hajoju nde Kristo?” ");
INSERT INTO mpa_vpl VALUES ("JN4_30","073_4_30","JHN","4","30","30","Bhela bhandu bhakahumiki kumbwani, na bhakunjendili Yesu. ");
INSERT INTO mpa_vpl VALUES ("JN4_31","073_4_31","JHN","4","31","31","Kunyuma kola bhabhulwa bhakabhi bhundobha, bhakapwaghaje, “Mbola, ukula chilebhe!” ");
INSERT INTO mpa_vpl VALUES ("JN4_32","073_4_32","JHN","4","32","32","Yesu akabhapwaghile, “Nepani mi na chilebhe changa kuchimanya mwehapa.” ");
INSERT INTO mpa_vpl VALUES ("JN4_33","073_4_33","JHN","4","33","33","Bhela bhabhulwa bhaka Yesu bhakapwaghanile, “Bho, kubhi na mundu joandeti chilebhe?” ");
INSERT INTO mpa_vpl VALUES ("JN4_34","073_4_34","JHN","4","34","34","Yesu akabhapwaghile, “Chilebhi changu nde achechi, naghatendaje mapalu ghaki jola joandumike, na kujomola lihengu laki. ");
INSERT INTO mpa_vpl VALUES ("JN4_35","073_4_35","JHN","4","35","35","Bho, mwehapa ngachempwagha, ‘Jikona myehi nchechi, nde paghihika mahunu?’ Lingalyaje, nepani numpwaghila, nkwehaje mihu ghinu mujilingalya mighonda, kubha chilebhi mungonda chijomwi kukoma, na chibhi tayali kwa mahunu. ");
INSERT INTO mpa_vpl VALUES ("JN4_36","073_4_36","JHN","4","36","36","Na jombi joahuna ajopalela malepu ghaki, na kubhongana mahunu kwa ndandi ja womi wa mileli, nahuli jola joapanda na jola joahuna bhapata kuhekalela papamu. ");
INSERT INTO mpa_vpl VALUES ("JN4_37","073_4_37","JHN","4","37","37","Kwa ndandi panihapa lilobhi leniheli likubha chakaka kubha, ‘Jumu apanda, na jongi kuhuna.’ ");
INSERT INTO mpa_vpl VALUES ("JN4_38","073_4_38","JHN","4","38","38","Nenga nakuntumiki mughahuna ghala ghanga kughahangajakila, bhangi bhakahengiki lihengu lelinonwipe, nanamu mpatiki nyonjeka kubhokana na lihengu labhu lelinonwipe.” ");
INSERT INTO mpa_vpl VALUES ("JN4_39","073_4_39","JHN","4","39","39","Na ku muchi wa Bhasamalia ghola bhandu bhamaheli bhakunhobhali Yesu kwa ndandi ja kulandila kwaka mbomba jola, joakalandili kubha, “Akambwaghi mambu ghokapi ghanakahengike.” ");
INSERT INTO mpa_vpl VALUES ("JN4_40","073_4_40","JHN","4","40","40","Bhela Bhasamalia bhala pabhakunjendi Yesu, bhakundobhiki atama kwabhu, najombi akatami konikola machobha ghabhele. ");
INSERT INTO mpa_vpl VALUES ("JN4_41","073_4_41","JHN","4","41","41","Bhandu bhamaheli nakanopi bhakahobhalili kwa ndandi ja malobhi ghaka Yesu. ");
INSERT INTO mpa_vpl VALUES ("JN4_42","073_4_42","JHN","4","42","42","Bhakumpwaghi mbomba jola, “Henu tuhobhalela, wala nga kwa ndandi ja malobhi ghaku pela, maghambu tepani tujowini tabhete, na tumanyi kubha chakaka hajoju nde Kristo, Mkengalela wa ndema.” ");
INSERT INTO mpa_vpl VALUES ("JN4_43","073_4_43","JHN","4","43","43","Bhela paghapetiki machobha ghabheli hagha Yesu akabhokiki konihoku, na kujenda ku Galilaya. ");
INSERT INTO mpa_vpl VALUES ("JN4_44","073_4_44","JHN","4","44","44","Kwa ndandi Yesu mweni akapwaghiki, “Mlota waka Chapanga ngacheapata utopelu mu inchi jaki mwene.” ");
INSERT INTO mpa_vpl VALUES ("JN4_45","073_4_45","JHN","4","45","45","Bhela paakahikiki ku Galilaya, Bhagalilaya bhakunjopalili, kwa ndandi bhanganya habha na bhombi bhakapiti ku uwangalalu wa Pasaka, na bhakaghaweni mambu ghokapi Yesu ghaakahengiki ku Yelusalemu kola chikahi cha uwangalalu hoghu. ");
INSERT INTO mpa_vpl VALUES ("JN4_46","073_4_46","JHN","4","46","46","Bhela akahikiki kabheti ku Kana ja Galilaya, panihapa paakaghatendiki machi kubha divai. Panihapa pakabhi na ofisa jumu joakabhi na mwana waki mtamwa ku Kapelenaumu hoku. ");
INSERT INTO mpa_vpl VALUES ("JN4_47","073_4_47","JHN","4","47","47","Jombi paakajowini kubha Yesu ahikiki kuhuma ku Yudea mbaka ku Galilaya, akunjendili, akundobhiki ahelalaje na ajendaje kundamiha mwana waki joakabhi mtamwa, kwa ndandi akabhi pambipi kupotela. ");
INSERT INTO mpa_vpl VALUES ("JN4_48","073_4_48","JHN","4","48","48","Bhela Yesu akumpwaghile, “Nanga kubhona nginyulila na ngangachu, ngamwihobhaleli ng'o.” ");
INSERT INTO mpa_vpl VALUES ("JN4_49","073_4_49","JHN","4","49","49","Ofisa jola akumpwaghile, “Bambo, chondi uhelalaje mangani mwana wangu ngacheapotile.” ");
INSERT INTO mpa_vpl VALUES ("JN4_50","073_4_50","JHN","4","50","50","Yesu akumpwaghile, “Ujendaje, mwana waku alamike.” Mundu jola akalihobhali lilobhi lela leakalongi Yesu, najombi akapiti. ");
INSERT INTO mpa_vpl VALUES ("JN4_51","073_4_51","JHN","4","51","51","Na paakabhi ahelela, bhatumika bhaki bhakunjopalile, bhakapwaghaje, “Mwana waku alamike!” ");
INSERT INTO mpa_vpl VALUES ("JN4_52","073_4_52","JHN","4","52","52","Bhela akabhalalukili lisaa paakatumbwi kubha wichu, na bhombi bhakumpwaghili, “Lichu, saa saba ja muhi, chitamu chakundekike.” ");
INSERT INTO mpa_vpl VALUES ("JN4_53","073_4_53","JHN","4","53","53","Bhela tati waki akamanyiki kubha lisaa lelalela leakumpwaghi Yesu, “Mwana waku alamike.” Jombi na bhokapi bha munyumba jaki bhakunhobhali Yesu. ");
INSERT INTO mpa_vpl VALUES ("JN4_54","073_4_54","JHN","4","54","54","Jeniheji nde nginyulila ja kabheli jeakahengiki Yesu, paakabhi ahuma ku Yudea kujenda ku Galilaya. ");
INSERT INTO mpa_vpl VALUES ("JN5_1","073_5_1","JHN","5","1","1","Paghapetiki ghanihagha kukabhi na uwangalalu ghongi wa Bhayahude, najombi Yesu akakweliki kujenda ku Yelusalemu. ");
INSERT INTO mpa_vpl VALUES ("JN5_2","073_5_2","JHN","5","2","2","Na ku Yelusalemu hoku pundyangu ukolongwa wa muchi ghoulowakeka Ndyangu wa Limbeleli, pambipi jaki pakabhi na litanda la machi lelilowakeka kwa Kiebulania Betizata, nalombi lakabhi na mabalaza nhwanu. ");
INSERT INTO mpa_vpl VALUES ("JN5_3","073_5_3","JHN","5","3","3","Mkati ja mabalaza hagha kukabhi na lipogha likolongwa la bhatamwa bhaghonile, akangalola, iwete, na bhabhatengwike, bhakabhi bhalendalela machi ghakilabhanwaje. ");
INSERT INTO mpa_vpl VALUES ("JN5_4","073_5_4","JHN","5","4","4","Kwa ndandi kubhi chikahi cheahele mtumika wa kunani kwaka Chapanga, na kujingi mkati ja machi, na kughakilabhana machi. Bhela jola joakubha wa kutumbula kujibhila chikahi machi paghakilabhanwa, alama chitamu chokapi cheakabhi apatike. ");
INSERT INTO mpa_vpl VALUES ("JN5_5","073_5_5","JHN","5","5","5","Na panihapa pakabhi na mundu jumu, joakabhi atengwike kwa hyaka selasini na nane. ");
INSERT INTO mpa_vpl VALUES ("JN5_6","073_5_6","JHN","5","6","6","Yesu paakumbweni jonihoju aghonile, najombi akamanya kubha jombi abhi mtamwa na hali jeniheji kwa chikahi chilachu, akundalukile, “Bho, upala kulama?” ");
INSERT INTO mpa_vpl VALUES ("JN5_7","073_5_7","JHN","5","7","7","Mtamwa jola akamuyangiki, “Bambo, nepani ngachemi na mundu wa kumbeleka mulitanda, machi paghakilabhanwa, nambu chikahi panhika nepani, mundu jongi ajingila mangani jangu.” ");
INSERT INTO mpa_vpl VALUES ("JN5_8","073_5_8","JHN","5","8","8","Yesu akumpwaghile, “Jemaje, utola uleli waku, na ujendaje.” ");
INSERT INTO mpa_vpl VALUES ("JN5_9","073_5_9","JHN","5","9","9","Palapala mundu jola akalamike, na akalitwekiki uleli waki, na kujenda. Na lichobha leniheli lakabhi Lichobha la Sabato. ");
INSERT INTO mpa_vpl VALUES ("JN5_10","073_5_10","JHN","5","10","10","Kwa ndandi jeniheji Bhayahude bhakumpwaghi mundu joakalamishwi jola, “Lalenu nde Lichobha la Sabato, shelia jikanakila kutotola uleli waku.” ");
INSERT INTO mpa_vpl VALUES ("JN5_11","073_5_11","JHN","5","11","11","Jombi akabhayangike, “Jombi joandendiki mya mwomi nde joambwaghile, ‘Utola uleli waku, na ujendaje.’ ” ");
INSERT INTO mpa_vpl VALUES ("JN5_12","073_5_12","JHN","5","12","12","Bhela bhakundalukile, “Bho, joakupwaghi wehapa ulitweka uleli waku, na ujendaje, nde nane?” ");
INSERT INTO mpa_vpl VALUES ("JN5_13","073_5_13","JHN","5","13","13","Nambu mundu joakalamiki jola ngacheamanyiki joandamihe, ndandi Yesu akabhi ajomwi kubhoka, kwa ndandi pakabhi na bhandu bhamaheli pandu panipala. ");
INSERT INTO mpa_vpl VALUES ("JN5_14","073_5_14","JHN","5","14","14","Paghapetiki ghanihagha Yesu akunketanili mundu jola joakundamihe mkati ja Nyumba jaka Chapanga, akumpwaghile, “Ulingalyaje, ubhi wa mwomi, ngawihenga mahoku kabhete, ngalihika kukupata lijambu lihakau nakanopi.” ");
INSERT INTO mpa_vpl VALUES ("JN5_15","073_5_15","JHN","5","15","15","Mundu jola akapiti, akabhapwaghi malobhi bhakolongwa bha Bhayahude kubha Yesu nde joandamihe. ");
INSERT INTO mpa_vpl VALUES ("JN5_16","073_5_16","JHN","5","16","16","Kwa ndandi jeniheji Bhayahude bhakatumbwi kung'aha Yesu, kwa ndandi akahengiki mambu ghanihagha mu Lichobha la Sabato. ");
INSERT INTO mpa_vpl VALUES ("JN5_17","073_5_17","JHN","5","17","17","Yesu akabhayangiki, “Atati wangu ahenga lihengu mbaka sajenu, na nepani bhelabhela nhenga lihengu.” ");
INSERT INTO mpa_vpl VALUES ("JN5_18","073_5_18","JHN","5","18","18","Bhela kwa ndandi jeniheji bhakolongwa bha Bhayahude bhakajendali kulonda mbekenyu ja kunkoma, nga kwa ndandi akahekiti shelia ja Lichobha la Sabato pela, nambu papamu na ghanihagha akundohiki Chapanga Atati waki, na bhela kulitenda jombi alengana na Chapanga. ");
INSERT INTO mpa_vpl VALUES ("JN5_19","073_5_19","JHN","5","19","19","Bhela Yesu akabhayangiki, na kubhapwaghila, “Chakaka, numpwaghila, Mwana ngacheaweza kuhenga lijambu lokapi lela kanjika jaki, nambu ahenga lijambu lela leambona Atati waki akahengaje, kwa ndandi ghokapi ghaahenga Atati, na Mwana najombi aghahenga ghaghagha. ");
INSERT INTO mpa_vpl VALUES ("JN5_20","073_5_20","JHN","5","20","20","Kwa ndandi Atati ampala Mwana, najombi andangiha ghokapi ghaahenga mweni. Hata mahengu makolongwa nakanopi kupeta ghanihagha anaandangihaje, nahuli mwehapa mpata kukangacha. ");
INSERT INTO mpa_vpl VALUES ("JN5_21","073_5_21","JHN","5","21","21","Ndandi ngati Atati moabhayoke bhakuwa na kubhapeke womi kabhete, bhelabhela na Mwana najombi abhapekeha womi bhala bhaabhapala. ");
INSERT INTO mpa_vpl VALUES ("JN5_22","073_5_22","JHN","5","22","22","Kabheti Atati ngacheantemu mundu jokapi, nambu ampeki Mwana lihengu la kubhatemula bhandu bhokapi, ");
INSERT INTO mpa_vpl VALUES ("JN5_23","073_5_23","JHN","5","23","23","nahuli bhandu bhokapi bhuntopila Mwana, ngati mobhuntopale Atati. Jokapi jwangakuntopela Mwana ngacheantopela Atati joantumike.” ");
INSERT INTO mpa_vpl VALUES ("JN5_24","073_5_24","JHN","5","24","24","Chakaka, numpwaghila, “Jombi joalijowana lilobhi langu na kunhobhalela jola joandumike abhi na womi wa mileli. Na wala ngaitemuliwe, nambu apetiki kuhuma mu kupotela na kujingila mu womi. ");
INSERT INTO mpa_vpl VALUES ("JN5_25","073_5_25","JHN","5","25","25","Chakaka, numpwaghila, lisaa lihika, na sajenu libhile, bhakuwa pabhijowanaje sauti jaka Mwana waka Chapanga, na bhala bhabhijowanaje anabhakubha bhome. ");
INSERT INTO mpa_vpl VALUES ("JN5_26","073_5_26","JHN","5","26","26","Ndandi ngati bhela Atati moabheli na womi mkati jaki, bhelabhela akumpeki na Mwana uwezu wa kubha na womi mkati jaki. ");
INSERT INTO mpa_vpl VALUES ("JN5_27","073_5_27","JHN","5","27","27","Na jombi akumpeki lujiniku lwa kutemula kwa ndandi jombi nde Mwana waka Mundu. ");
INSERT INTO mpa_vpl VALUES ("JN5_28","073_5_28","JHN","5","28","28","Ngamwikangacha malobhi ghanihagha, kwa ndandi lisaa lihika, ambalu bhokapi bhabhabhi mumatengeli anabhajowanaje sauti jaki. ");
INSERT INTO mpa_vpl VALUES ("JN5_29","073_5_29","JHN","5","29","29","Na bhombi anabhayokaje, bhala bhabhatehi manyahi kwa uyohakeku wa womi, na bhala bhabhatehi mahakau kwa uyohakeku wa utemulo.” ");
INSERT INTO mpa_vpl VALUES ("JN5_30","073_5_30","JHN","5","30","30","“Nepani ngachenhweza kuhenga lihengu namwete, ngati monyowanela kuhuma kwa Atati bhenibhela nde mondemulila, na utemulu wangu nde wa chakaka, kwa ndandi ngachenonda kuhenga ngati mombali nepane, nambu ngati moapali jola joandumike.” ");
INSERT INTO mpa_vpl VALUES ("JN5_31","073_5_31","JHN","5","31","31","Nepani ngati ananililandi namwete, ulilandilu wangu nga wa chakaka. ");
INSERT INTO mpa_vpl VALUES ("JN5_32","073_5_32","JHN","5","32","32","Abhi jongi joanandila nepani, nanatu manyi kubha ulandilu waki ghoanandila nepani nde wa chakaka. ");
INSERT INTO mpa_vpl VALUES ("JN5_33","073_5_33","JHN","5","33","33","Mabhanganya mkabhatumiki bhandu kwaka Yohana Mbatizaji, najombi akundandili chakaka. ");
INSERT INTO mpa_vpl VALUES ("JN5_34","073_5_34","JHN","5","34","34","Nepani nga ngati nujopalela ulandilu wa bhandu, nambu nongela mambu aghagha nahuli mwehapa mpata kukengalewa. ");
INSERT INTO mpa_vpl VALUES ("JN5_35","073_5_35","JHN","5","35","35","Yohana akabhi ngati taa jejibhelela na kung'anya, nanamu mkahawi kuuhekalela unang'anu waki kwa chikahi. ");
INSERT INTO mpa_vpl VALUES ("JN5_36","073_5_36","JHN","5","36","36","Nambu ulandilu ghominaku nepani nde ukolongwa kupeta ghola waka Yohana, kwa ndandi mahengu ghala ghaambeki Atati nahuli naghajomulaje, mahengu ghanihagha ghanaghahenga, ghanandila kubha Atati nde joandumike. ");
INSERT INTO mpa_vpl VALUES ("JN5_37","073_5_37","JHN","5","37","37","Atati joandumike bhelabhela anandila. Sauti jaki ngachemujijowine chikahi chokapi, wala ngachemumbweni pamihu jaki. ");
INSERT INTO mpa_vpl VALUES ("JN5_38","073_5_38","JHN","5","38","38","Wala lilobhi laki ngachembinalu likatama mkati jinu, kwa ndandi mabhanganya ngachemunhobhalela jola joatumakiki na jombe. ");
INSERT INTO mpa_vpl VALUES ("JN5_39","073_5_39","JHN","5","39","39","Mughachunguzaje Malembelu Mahuhu, maghambu kwa ghanihagha mwehapa muholakela kubha mkati jaki mbi na womi wa mileli, na Malembu ghanihagha nde ghaghanandila nepane. ");
INSERT INTO mpa_vpl VALUES ("JN5_40","073_5_40","JHN","5","40","40","Wala ngachempala kuhika kwangu nepane, nahuli mpata kubha na womi wa mileli. ");
INSERT INTO mpa_vpl VALUES ("JN5_41","073_5_41","JHN","5","41","41","“Nepani ngachenulonda ulumbalilu kuhuma kwa bhandu. ");
INSERT INTO mpa_vpl VALUES ("JN5_42","073_5_42","JHN","5","42","42","Nambu nummanyiki mabhanganya kubha ngachembi na upalu waka Chapanga mkati ja mitima jinu. ");
INSERT INTO mpa_vpl VALUES ("JN5_43","073_5_43","JHN","5","43","43","Nepani nhikiki kwa lujiniku lwa Atati wangu, wala mabhanganya ngachemnyopalela, jongi anahikiki kwa lihina laki mwene, anamunjopalya jonihoju. ");
INSERT INTO mpa_vpl VALUES ("JN5_44","073_5_44","JHN","5","44","44","Bho, muweza bhole kuhobhalela mabhanganya mwenjopalanela ulumbalilu mabheni kwa mabheni, na ulumbalilu ghola ghouhuma kwaka Chapanga joabhi wa kanjika ngachemulonda? ");
INSERT INTO mpa_vpl VALUES ("JN5_45","073_5_45","JHN","5","45","45","Ngamwiholake nepani ananuntakila kwa Atati. Musa jomunhobhalela mabhanganya nde joantakila. ");
INSERT INTO mpa_vpl VALUES ("JN5_46","073_5_46","JHN","5","46","46","Kwa ndandi ngati mkabhili munhobhalela Musa, mkabya mnihobhalili na nepane, maghambu Musa akalembiki malobhi ghangu nepane. ");
INSERT INTO mpa_vpl VALUES ("JN5_47","073_5_47","JHN","5","47","47","Nambu ngati ngachemughahobhalela malembu ghaka Musa, bho, anamughahobhalya bhole mabholu ghangu nepane?” ");
INSERT INTO mpa_vpl VALUES ("JN6_1","073_6_1","JHN","6","1","1","Paakajomwi ghanihagha Yesu akalombwiki kwihi ja Bahali ja Galilaya, au ghoulowakeka Bahali ja Tibelia. ");
INSERT INTO mpa_vpl VALUES ("JN6_2","073_6_2","JHN","6","2","2","Na lipgha likolongwa la bhandu lakunjengalile, kwa ndandi bhakaiweni ngangachu yeakabhahengi bhatamwa. ");
INSERT INTO mpa_vpl VALUES ("JN6_3","073_6_3","JHN","6","3","3","Bhela Yesu akakweliki kuchitombi, na akatami konihoku papamu na bhabhulwa bhaki. ");
INSERT INTO mpa_vpl VALUES ("JN6_4","073_6_4","JHN","6","4","4","Na chikahi cha uwangalalu wa Pasaka ja Bhayahude, chakabhi chiheghalile. ");
INSERT INTO mpa_vpl VALUES ("JN6_5","073_6_5","JHN","6","5","5","Bhela Yesu paakalingalili, na kulibhona lipogha likolongwa la bhandu lihika kwaki, akumpwaghi Filipo, “Bho, tuhemala kwaku mabumunda, nahuli bhandu abhabha bhapata kula?” ");
INSERT INTO mpa_vpl VALUES ("JN6_6","073_6_6","JHN","6","6","6","Na leniheli akalongi nahuli kundenga Filipo, kwa ndandi akamanyiki mweni leanahengaje. ");
INSERT INTO mpa_vpl VALUES ("JN6_7","073_6_7","JHN","6","7","7","Filipo akamuyangike, “Mabumunda gha ipandi mia mbili ya madini gha feza ngaghabhajaghanile, hata ngati kila jumu wabhu anaapatiki chipandi kichokope.” ");
INSERT INTO mpa_vpl VALUES ("JN6_8","073_6_8","JHN","6","8","8","Jumu wa bhabhulwa bhaki joalowakeka Andulea, ndongu waka Simoni Petulu, akumpwaghile, ");
INSERT INTO mpa_vpl VALUES ("JN6_9","073_6_9","JHN","6","9","9","“Pambani abhi nkombu jumu, joabhi na mabumunda nhwano gha shaili, na homba ibheli. Bho, nambu hayeyi anaijaghanya kiki kwa bhandu bhamaheli ngati abhabha?” ");
INSERT INTO mpa_vpl VALUES ("JN6_10","073_6_10","JHN","6","10","10","Yesu akapwaghike, “Mwatamika bhandu pahi.” Na pandu pala pakabhi na manyonyoli ghamaheli. Bhela akanalomi bhakatami, ngati bhandu elufu nhwano jumula jabhu. ");
INSERT INTO mpa_vpl VALUES ("JN6_11","073_6_11","JHN","6","11","11","Bhela Yesu akaghatoliki mabumunda ghala, akunchengwi Chapanga, na kubhapekeha bhabhulwa bhaki, na bhabhulwa bhakabhaghabhi bhandu bhabhakabhi bhatami, bhelabhela na homba yela kulengana na mobhapalilaje. ");
INSERT INTO mpa_vpl VALUES ("JN6_12","073_6_12","JHN","6","12","12","Na bhandu bhokapi pabhakatupile, akabhapwaghi bhabhulwa bhaki, “Mbonganaje ipandi yeihighalile, ngachihobha chokapi.” ");
INSERT INTO mpa_vpl VALUES ("JN6_13","073_6_13","JHN","6","13","13","Bhela bhakaibhongini papamu, na kutwelakela itonga komi na ibhele kubhokana na mabumunda nhwanu gha shaili ghala, ghabhakahighakile bhandu bhala bhabhakulike. ");
INSERT INTO mpa_vpl VALUES ("JN6_14","073_6_14","JHN","6","14","14","Bhela bhandu bhala, pabhajiweni nginyulila jeakahengiki Yesu, bhakapwaghike, “Chakaka hajoju nde Mlota waka Chapanga jola joakapwaghiki anahika pani pundema.” ");
INSERT INTO mpa_vpl VALUES ("JN6_15","073_6_15","JHN","6","15","15","Bhela Yesu paakamanyiki kubha bhakapaliki kuhika kunkamula kwa makili, nahuli bhumbeka kubha Nkolongwa wabhu, akabhokiki kabhete, na kujenda kuchitombi jombi kanjika jaki. ");
INSERT INTO mpa_vpl VALUES ("JN6_16","073_6_16","JHN","6","16","16","Hata pakwabhi pakamihi bhabhulwa bhaka Yesu bhakahelili ku bahali, ");
INSERT INTO mpa_vpl VALUES ("JN6_17","073_6_17","JHN","6","17","17","bhakakweliki mu liboti, na kutumbula kulomboka bahali kujenda ku Kapelenaumu. Chikahi hechi kukabhi lwihi lujingile, na Yesu akabhi akali ngakubhahikila. ");
INSERT INTO mpa_vpl VALUES ("JN6_18","073_6_18","JHN","6","18","18","Bahali jakatumbwi kuhakula kwa kupogha mpongu ukolongwa. ");
INSERT INTO mpa_vpl VALUES ("JN6_19","073_6_19","JHN","6","19","19","Bhela pabhakabhi bhahughiki ingahe na kujenda utali wa kilometa nhwanu au sita, bhakumbweni Yesu akajendaje panani ja machi na kuliheghalela liboti, bhakajowipi namaa. ");
INSERT INTO mpa_vpl VALUES ("JN6_20","073_6_20","JHN","6","20","20","Yesu akabhapwaghile, “Nde nepane, ngamwijoghopa!” ");
INSERT INTO mpa_vpl VALUES ("JN6_21","073_6_21","JHN","6","21","21","Bhela bhakapaliki kuntola Yesu mu liboti, na chikahi chelachela liboti lakahikiki mumaheku ja kobhakabhi bhajenda. ");
INSERT INTO mpa_vpl VALUES ("JN6_22","073_6_22","JHN","6","22","22","Chilabhu jaki lipogha la bhandu lelajemiki kwihi ja bahali bhakaweni kubha njeta liboti lengi konihoku nambu liboti limu pela, na bhakamanyiki kubha Yesu ngacheakajingi mu liboti lela papamu na bhabhulwa bhaki, nambu bhabhulwa bhaki bhakapiti kanjika jabhu. ");
INSERT INTO mpa_vpl VALUES ("JN6_23","073_6_23","JHN","6","23","23","Nambu ghakahikiki maboti ghangi kuhuma ku Tibelia mbaka pambipi na pandu pala lipogha likolongwa la bhandu pabhakulikaje mabumunda, chikahi Bambo paakunchengwi Chapanga. ");
INSERT INTO mpa_vpl VALUES ("JN6_24","073_6_24","JHN","6","24","24","Bhela lipogha la bhandu palaweni kubha Yesu ngacheabhi konihoku wala bhabhulwa bhaki, bhakajingili mu maboti ghangi bheni, na kujenda ku Kapelenaumu nahuli kundonda Yesu. ");
INSERT INTO mpa_vpl VALUES ("JN6_25","073_6_25","JHN","6","25","25","Hata pabhakunhimanili kwihi ja bahali, bhakundalukile, “Mbola, wehapa uhikiki lile pambane?” ");
INSERT INTO mpa_vpl VALUES ("JN6_26","073_6_26","JHN","6","26","26","Yesu akabhayangiki, na kubhapwaghila, “Chakaka, numpwaghila, mwenga mnonda nepani nga kwa ndandi mkaweni nginyulila, nambu maghambu mkakuliki mabumunda ghala, na kutupila. ");
INSERT INTO mpa_vpl VALUES ("JN6_27","073_6_27","JHN","6","27","27","Ngamwachihenge lihengu chilebhi chechiyonangeka, nambu chilebhi chechitamakila mbaka womi wa mileli, ambachu Mwana waka Mundu anaampekyaje, kwa ndandi jonihoju nde joajeghaliki muhuli na Chapanga Atati.” ");
INSERT INTO mpa_vpl VALUES ("JN6_28","073_6_28","JHN","6","28","28","Bhela bhakumpwaghile, “Bho, tutenda bholi nahuli tupata kughahenga mahengu ghaka Chapanga?” ");
INSERT INTO mpa_vpl VALUES ("JN6_29","073_6_29","JHN","6","29","29","Yesu akabhayangiki, na kubhapwaghila, “Haleli nde lihengu laka Chapanga, kubha munhobhalyaje jola joatumakiki najombi.” ");
INSERT INTO mpa_vpl VALUES ("JN6_30","073_6_30","JHN","6","30","30","Bhakumpwaghile, “Bho, anauhenga nginyulila bhole nahuli tujibhonaje na tupata kuhobhalela? Bho, anauhenga lihengu bhole? ");
INSERT INTO mpa_vpl VALUES ("JN6_31","073_6_31","JHN","6","31","31","Akahokolu bhitu bhakakuliki mana kulipololu ngati moilembakike mu Malembelu Mahuhu, ‘Akabhapeki mana kuhuma kunani kumahunde nahuli bhakulaje.’ ” ");
INSERT INTO mpa_vpl VALUES ("JN6_32","073_6_32","JHN","6","32","32","Yesu akabhapwaghile, “Chakaka, numpwaghila, nga Musa joakumpeki mabumunda kuhuma kunani kumahunde, nambu Chapanga Atati wangu nde joampekeha mwehapa mabumunda gha chakaka kuhuma kunani kumahunde. ");
INSERT INTO mpa_vpl VALUES ("JN6_33","073_6_33","JHN","6","33","33","Kwa ndandi libumunda laka Chapanga nde jola joahelela kuhuma kunani kumahunde, na kuupekeha ndema womi.” ");
INSERT INTO mpa_vpl VALUES ("JN6_34","073_6_34","JHN","6","34","34","Bhela bhakumpwaghile, “Bambo, machobha ghokapi utupekyaje libumunda leniheli.” ");
INSERT INTO mpa_vpl VALUES ("JN6_35","073_6_35","JHN","6","35","35","Yesu akabhapwaghile, “Nepani nde libumunda la womi. Jokapi joahika kwangu nepani ngayibhoni injala ng'o, na jola joanhobhale nepani ngayibhoni inywita ng'o. ");
INSERT INTO mpa_vpl VALUES ("JN6_36","073_6_36","JHN","6","36","36","Nambu numpwaghile kubha, njomwi kumona, nambu mwakali ngachemuhobhalela. ");
INSERT INTO mpa_vpl VALUES ("JN6_37","073_6_37","JHN","6","37","37","Bhokapi bhaambeke Atati anabhahika kwangu, kabheti jokapi joahika kwangu nganundekeli kunja ng'o. ");
INSERT INTO mpa_vpl VALUES ("JN6_38","073_6_38","JHN","6","38","38","Kwa ndandi ngachenheli kuhuma kunani kumahunde nahuli kuhenga ngati mombali nepani, nambu nhenga mapalu ghaka jola joandumike. ");
INSERT INTO mpa_vpl VALUES ("JN6_39","073_6_39","JHN","6","39","39","Na mapalu ghaka jola joandumike nde aghagha, ja kubha kwa bhokapi bhaambekihe nganunhoa hata jumu, nambu nimuyoha kabhete mu lichobha la kujomukela. ");
INSERT INTO mpa_vpl VALUES ("JN6_40","073_6_40","JHN","6","40","40","Kwa ndandi mapalu gha Atati wangu nde aghagha, ja kubha kila joandingalila Mwana na kunhobhalela jombi, akubhaje na womi wa mileli, na nepani ananimuyohaje mu lichobha la kujomukela.” ");
INSERT INTO mpa_vpl VALUES ("JN6_41","073_6_41","JHN","6","41","41","Bhela Bhayahude bhakutumbwi kung'ong'uteka, kwa ndandi akapwaghiki, “Nepani nde libumunda lelihelile kuhuma kunani kunahundi.” ");
INSERT INTO mpa_vpl VALUES ("JN6_42","073_6_42","JHN","6","42","42","Bhakapwaghike, “Bho, hajoju le nga Yesu, mwana waka Yusufu, jotummanyi atati waki na mabhu waki? Bho, henu apwagha bhole kubha, ‘Nhelili kuhuma kunani kumahunde?’ ” ");
INSERT INTO mpa_vpl VALUES ("JN6_43","073_6_43","JHN","6","43","43","Bhela Yesu akayangiki, na kubhapwaghila, “Ngamwing'ong'uteka mabheti kwa mabheti.” ");
INSERT INTO mpa_vpl VALUES ("JN6_44","073_6_44","JHN","6","44","44","Nga mundu joaweza kuhika kwangu nepani, nangakuhutwa na Atati joandumike, na nepani ananimuyohaje mu lichobha la kujomukela. ");
INSERT INTO mpa_vpl VALUES ("JN6_45","073_6_45","JHN","6","45","45","Ilembakiki mu Malembu gha bhalota bhaka Chapanga, “Bhandu bhokapi anabhabholakikaje na Chapanga.” Bhela kila mundu joanjowana Atati, na kulibhola kuhuma kwaki, jonihoju ahika kwangu nepani. ");
INSERT INTO mpa_vpl VALUES ("JN6_46","073_6_46","JHN","6","46","46","Njeta mundu joambweni Atati, nambu jombi joahuma kwaka Chapanga, jonihoju nde joambweni Atati. ");
INSERT INTO mpa_vpl VALUES ("JN6_47","073_6_47","JHN","6","47","47","Chakaka numpwaghila, jombi joanhobhalela nepani abhi na womi wa mileli. ");
INSERT INTO mpa_vpl VALUES ("JN6_48","073_6_48","JHN","6","48","48","Nepani nde libumunda la womi. ");
INSERT INTO mpa_vpl VALUES ("JN6_49","073_6_49","JHN","6","49","49","Akahokolu bhinu bhakakuliki mana kulipololu, na bhakapotile. ");
INSERT INTO mpa_vpl VALUES ("JN6_50","073_6_50","JHN","6","50","50","Nambu lendenu nde libumunda lelihelili kuhuma kunani kumahunde, na kubha mundu aweza kula, na wala ngayipotele. ");
INSERT INTO mpa_vpl VALUES ("JN6_51","073_6_51","JHN","6","51","51","Nepani nde libumunda lelihelili kuhuma kunani kumahunde, mundu anaakuliki libumunda lenu, anaatamaje mileli. Na libumunda lemoha nepani nde hyegha jangu, jenijibhoha kwa ndandi ja womi wa bhandu bha pundema. ");
INSERT INTO mpa_vpl VALUES ("JN6_52","073_6_52","JHN","6","52","52","Bhela Bhayahude bhakalochini bheni kwa bheni, bhakapwaghaje, “Bho, aweza bholi mundu ajoju kutupekeha tepani hyegha jaki nahuli tukulaje?” ");
INSERT INTO mpa_vpl VALUES ("JN6_53","073_6_53","JHN","6","53","53","Bhela Yesu akabhapwaghile, “Chakaka, numpwaghila, ngati ngachemkula hyegha jaka Mwana waka Mundu, na kunywa mwahi waki, ngachembi na womi mkati jinu. ");
INSERT INTO mpa_vpl VALUES ("JN6_54","073_6_54","JHN","6","54","54","Joakula hyegha jangu, na kunywa mwahi wangu, abhi na womi wa mileli, na nepani ananimuyohaje mu lichobha la kujomukela. ");
INSERT INTO mpa_vpl VALUES ("JN6_55","073_6_55","JHN","6","55","55","Kwa ndandi hyegha jangu nde chilebhi cha chakaka, na mwahi wangu nde chakunywa cha chakaka. ");
INSERT INTO mpa_vpl VALUES ("JN6_56","073_6_56","JHN","6","56","56","Joakula hyegha jangu, na kunywa mwahi wangu, atama mkati jangu, na nepani ndama mkati jaki. ");
INSERT INTO mpa_vpl VALUES ("JN6_57","073_6_57","JHN","6","57","57","Ngati Atati joabhi mwome moandumi nepani, na nepani mili mwome kwa Atati, bhelabhela jola joangula nepani, anaakubha mwome kwangu nepani. ");
INSERT INTO mpa_vpl VALUES ("JN6_58","073_6_58","JHN","6","58","58","Lendenu nde libumunda lelihelile kuhuma kunani kumahunde, nga ngati akahokolu bhinu mobhakakuli mana, na kupotela, nambu jola joakula libumunda lendenu anaatamaje mileli.” ");
INSERT INTO mpa_vpl VALUES ("JN6_59","073_6_59","JHN","6","59","59","Yesu akapwaghiki malobhi ghanihagha paakabhi abhola mu nyumba ja kuhimanganila Bhayahude, ku Kapelenaumu hoku. ");
INSERT INTO mpa_vpl VALUES ("JN6_60","073_6_60","JHN","6","60","60","Bhela bhandu bhamaheli pachilanda ja bhabhulwa bhaki pabhakajowini lijambu leniheli, bhakapwaghike, “Mambu aghagha nde ghanonwipe, bho, mundu bholi joaweza kughajowanela?” ");
INSERT INTO mpa_vpl VALUES ("JN6_61","073_6_61","JHN","6","61","61","Najombi Yesu akamanyi muntima waki kubha bhabhulwa bhaki bhaling'ong'utakela lijambu leniheli, akabhapwaghile, “Bho, lijambu haleli le luntenda kuhakalila? ");
INSERT INTO mpa_vpl VALUES ("JN6_62","073_6_62","JHN","6","62","62","Bho, henu anakukubha bhole pamwambona Mwana waka Mundu akagholukaje kujenda kola koakabhi pakutumbula? ");
INSERT INTO mpa_vpl VALUES ("JN6_63","073_6_63","JHN","6","63","63","Roho Mhuhu nde joajeghela womi, hyegha jaka mundu ngachejibhi na chindu ndeka. Nambu malobhi ghanihagha ghanumpwaghile nde Roho, kabheti nde womi. ");
INSERT INTO mpa_vpl VALUES ("JN6_64","073_6_64","JHN","6","64","64","Nambu kubhi na bhangi pachilanda jinu bhangakuhobhalela.” Kwa ndandi Yesu akamanyiki kutumbu pa kutumbulila kubha nde bhangakuhobhalela, najombi nde nane joamung'anambukaje. ");
INSERT INTO mpa_vpl VALUES ("JN6_65","073_6_65","JHN","6","65","65","Akapwaghike, “Kwa ndandi jeniheji nukumpwaghili kubha nga mundu joaweza kuhika kwangu nepani, pangakujangatiwa na Atati wangu.” ");
INSERT INTO mpa_vpl VALUES ("JN6_66","073_6_66","JHN","6","66","66","Kwa ndandi ja ghanihagha bhamaheli pachilanda ja bhabhulwa bhaki bhakakelawiki kunyuma, na ngachebhalongini naku kabhete. ");
INSERT INTO mpa_vpl VALUES ("JN6_67","073_6_67","JHN","6","67","67","Bhela Yesu akabhalalukili bhabhulwa bhaki komi na bhabheli bhala, “Bho, mwehapa nanamu mpala kubhoka?” ");
INSERT INTO mpa_vpl VALUES ("JN6_68","073_6_68","JHN","6","68","68","Bhela Simoni Petulu akamuyangike, “Bombo, bho, tujenda kwaka nane? Wehapa ubhi na mabholu ghaghaleta womi wa mileli. ");
INSERT INTO mpa_vpl VALUES ("JN6_69","073_6_69","JHN","6","69","69","Na tepani tuhobhalela, kabheti tumanyi, ja kubha wehapa nde Kristo, Mhuhu waka Chapanga.” ");
INSERT INTO mpa_vpl VALUES ("JN6_70","073_6_70","JHN","6","70","70","Yesu akabhayangike, “Bho, nepani ngachenunhawili mwenga komi na bhabheli, na jumu winu nde Shetani?” ");
INSERT INTO mpa_vpl VALUES ("JN6_71","073_6_71","JHN","6","71","71","Panihapa Yesu akabhi andongalela Yuda, mwana waka Simoni Isikalioti, ndandi jonihoju nde joamung'anambukaje, najombi nde jumu wa bhabhulwa komi na bhabheli bhala. ");
INSERT INTO mpa_vpl VALUES ("JN7_1","073_7_1","JHN","7","1","1","Paghajomwiki ghanihagha Yesu akabhi ajenda mu Galilaya, ndandi ngacheapaliki kujenda mu Yudea, kwa ndandi bhakolongwa bha Bhayahude bhakabhi bhalonda kunkoma. ");
INSERT INTO mpa_vpl VALUES ("JN7_2","073_7_2","JHN","7","2","2","Na chikahi cha uwangalalu wa Bhayahude, Uwangalalu wa Indamba, chakabhi chiheghalile. ");
INSERT INTO mpa_vpl VALUES ("JN7_3","073_7_3","JHN","7","3","3","Bhela bhalongu bhaka Yesu bhakumpwaghile, “Ubhoka pambane, na ujenda ku Yudea, nahuli bhabhulwa bhaku nabhombi bhapata kughabhona mahengu ghaku ghaughahenga. ");
INSERT INTO mpa_vpl VALUES ("JN7_4","073_7_4","JHN","7","4","4","Nga mundu joatenda mambu kwa kulihiya, na koni mweni apala kumanyikana. Ngati anauhenga mambu aghagha, bhela ulilangihaje wamwete pundema wokapi.” ");
INSERT INTO mpa_vpl VALUES ("JN7_5","073_7_5","JHN","7","5","5","Kwa ndandi hata bhalongu bhaki ngachebhunhobhalile. ");
INSERT INTO mpa_vpl VALUES ("JN7_6","073_7_6","JHN","7","6","6","Bhela Yesu akabhapwaghile, “Chenjenu nga chikahi changu chechipalika, nambu kwinu mwehapa chikahi chokapi chipalika. ");
INSERT INTO mpa_vpl VALUES ("JN7_7","073_7_7","JHN","7","7","7","Bhandu bha pundema ngabhawezi kunhakalila mwehapa, nambu bhanhakalila nepani, kwa ndandi nepani nabhalandila kubha matendu ghabhu nde mahakau. ");
INSERT INTO mpa_vpl VALUES ("JN7_8","073_7_8","JHN","7","8","8","Nkwelaje mwehapa njendanyaje mkakula uwangalalu. Nepani nga ngweli nakona kujenda kula uwangalalu hoghu, kwa ndandi chikahi changu chekimbalila chakali ngachechihikike.” ");
INSERT INTO mpa_vpl VALUES ("JN7_9","073_7_9","JHN","7","9","9","Paakajomwi kubhapwaghi malobhi ghanihagha, akajendali kutama mu Galilaya. ");
INSERT INTO mpa_vpl VALUES ("JN7_10","073_7_10","JHN","7","10","10","Hata bhalongu bhaki pabhajomwili kukwela kujenda ku Uwangalalu wa Indamba, na Yesu akakweliki kujenda ku uwangalalu, nga kwa kubhonikana, nambu ngati kwa kulihiya. ");
INSERT INTO mpa_vpl VALUES ("JN7_11","073_7_11","JHN","7","11","11","Bhela bhakolongwa bha Bhayahude bhakundondiki pa uwangalalu, bhakapwaghaje, “Bho, abhi kwako mundu jola?” ");
INSERT INTO mpa_vpl VALUES ("JN7_12","073_7_12","JHN","7","12","12","Kukabhi na kujojalanela kwamaheli pa lipogha la bhandu panani jaki jombi. Na bhangi bhakapwaghike, “Mundu hoju nde wambone.” Bhandu bhangi bhakapwaghike, “Ngabhela, nambu abhakolowa bhandu.” ");
INSERT INTO mpa_vpl VALUES ("JN7_13","073_7_13","JHN","7","13","13","Nambu nga mundu joakumpwaghiki Yesu palanga, kwa ndandi ja kubhajoghopa bhakolongwa bha Bhayahude. ");
INSERT INTO mpa_vpl VALUES ("JN7_14","073_7_14","JHN","7","14","14","Pajahika pakati ja uwangalalu Yesu akakweliki na kujingila mu liwangala la Nyumba jaka Chapanga, na kutumbula kubhola. ");
INSERT INTO mpa_vpl VALUES ("JN7_15","073_7_15","JHN","7","15","15","Bhakolongwa bha Bhayahude bhakakangichi bhakapwaghaje, “Bho, mundu ajoju apatiki bhole kumanya mambu aghagha, koni ngacheasomike?” ");
INSERT INTO mpa_vpl VALUES ("JN7_16","073_7_16","JHN","7","16","16","Bhela Yesu akabhayangiki, na kupwagha, “Mabholu ghangu nga ghangu namwete, nambu ghaka jombi joandumike. ");
INSERT INTO mpa_vpl VALUES ("JN7_17","073_7_17","JHN","7","17","17","Mundu anaapaliki kughahenga mapalu ghaka Chapanga, anaamanyaje kubha mabholu ghangu ghahuma kwaka Chapanga, au nepani nongela kwa ndandi jangu namwete. ");
INSERT INTO mpa_vpl VALUES ("JN7_18","073_7_18","JHN","7","18","18","Jola joalongela kwa ndandi jaki mweni pela alonda lujiniku lwaki mweni. Nambu jola joalonda lujiniku lwaka jola joantumiki, jonihoju nde wa chakaka, na wala mkati jaki njeta uhakau. ");
INSERT INTO mpa_vpl VALUES ("JN7_19","073_7_19","JHN","7","19","19","Bho, Musa ngacheakumpeki Shelia? Nambu njeta hata jumu winu joajikamula Shelia heji. Bho, maghambu kiki mpala kungoma?” ");
INSERT INTO mpa_vpl VALUES ("JN7_20","073_7_20","JHN","7","20","20","Bhandu bhakayangike, “Wehapa ubhi na majobhi! Bho, nane joapala kukukoma?” ");
INSERT INTO mpa_vpl VALUES ("JN7_21","073_7_21","JHN","7","21","21","Yesu akabhayangike, “Nepani nakahengiki ngangachu jimu, na mwehapa mabhokapi mkangacha. ");
INSERT INTO mpa_vpl VALUES ("JN7_22","073_7_22","JHN","7","22","22","Musa akumpeki malaghalakilu gha jando, nambu nga ngati ghahuma kwaka Musa, nambu kwa akahokolu, nanamu munheketa mundu jandu hata mu Lichobha la Sabato. ");
INSERT INTO mpa_vpl VALUES ("JN7_23","073_7_23","JHN","7","23","23","Bhela ngati anakubhi mundu aheketa jandu hata mu Lichobha la Sabato nahuli Shelia jaka Musa ngajihika kuhekateka, bho, mbona muhyomela nepani kwa ndandi nakundamihi mundu mu Lichobha la Sabato? ");
INSERT INTO mpa_vpl VALUES ("JN7_24","073_7_24","JHN","7","24","24","Nkotukaje kutemula mambu kwa kulingalila kwa kunja pela, nambu mughalingaje mambu na kutemula kwa chakaka.” ");
INSERT INTO mpa_vpl VALUES ("JN7_25","073_7_25","JHN","7","25","25","Bhela bhandu bhakumu bha ku Yelusalemu bhakapwaghike, “Bho, hajoju le nga mundu jola ambaju ihongozi bhundonda nahuli bhunkomaje?” ");
INSERT INTO mpa_vpl VALUES ("JN7_26","073_7_26","JHN","7","26","26","Lingalyaje, abhi pambane! Akalongilaje palanga, wala ngachebhumpwaghi lilobhi lokapi lela. Bho, iwezikana kubha chakaka ihongozi abhabha bhamanyi kubha hajoju nde Kristo? ");
INSERT INTO mpa_vpl VALUES ("JN7_27","073_7_27","JHN","7","27","27","Nambu hajoju tummanyi koahuma, nambu Kristo paanahikaje, nga mundu joamanya koahuma. ");
INSERT INTO mpa_vpl VALUES ("JN7_28","073_7_28","JHN","7","28","28","Bhela Yesu akajamalili sauti jaki mu liwangala la Nyumba jaka Chapanga, akabholaje na kupwagha, “Bho, nepani mmanye, na konhuma hoku mkumanye? Wala nepani ngachenhikiki kwa ndandi ja lujiniku lwangu namwete, nambu jombi joandumike nde wa chakaka, jwangakummanya mwehapa. ");
INSERT INTO mpa_vpl VALUES ("JN7_29","073_7_29","JHN","7","29","29","Nambu nepani nummanyi jombi, kwa ndandi nhumiki kwaki, najombi nde joandumike.” ");
INSERT INTO mpa_vpl VALUES ("JN7_30","073_7_30","JHN","7","30","30","Bhela bhandu bhakalondiki kunkamula, nambu nga mundu joakahatambwili chiwoku chaki nahuli kunkamula, kwa ndandi lisaa laki lakabhi likali ngakuhika. ");
INSERT INTO mpa_vpl VALUES ("JN7_31","073_7_31","JHN","7","31","31","Bhandu bhamaheli pa uwangalalu pala bhakunhobhalile, na bhakapwaghike, “Bho, Kristo paanahikaje, anahenga nginyulila yamaheli nakanopi kupeta yeahengiki mundu ajojo?” ");
INSERT INTO mpa_vpl VALUES ("JN7_32","073_7_32","JHN","7","32","32","Mafalisayo bhakabhajowini bhandu bhakang'ong'utikaje malobhi ghanihagha panani jaka Yesu, bhela bhapenganyambiku bhakolongwa papamu na Mafalisayo bhakabhatumiki bhalonda bha Nyumba jaka Chapanga nahuli bhakunkamulaje. ");
INSERT INTO mpa_vpl VALUES ("JN7_33","073_7_33","JHN","7","33","33","Bhela Yesu akabhapwaghile, “Nakona mili na mwehapa kwa chikahi kichokopi pela, na bhela ananyendaje kwaka jola joandumike. ");
INSERT INTO mpa_vpl VALUES ("JN7_34","073_7_34","JHN","7","34","34","Mwinonda nepani, wala ngamwimone, na nepani pamile mwehapa ngachemuweza kuhika.” ");
INSERT INTO mpa_vpl VALUES ("JN7_35","073_7_35","JHN","7","35","35","Bhela bhakolongwa bha Bhayahude bhakapwaghanile, “Bho, hajoju anajenda kwaku, hata tepani ngatumbona? Bho, apala kujenda ku michi ja Bhagiliki kobhaghabhaniki Bhayahude, na kubhabhola Bhagiliki? ");
INSERT INTO mpa_vpl VALUES ("JN7_36","073_7_36","JHN","7","36","36","Bho, nde lilobhi bhole leniheli lealilongile, ‘Anamunonda nambu ngamwimone, wala nepani pamile mwehapa ngamuwezi kuhika?’ ” ");
INSERT INTO mpa_vpl VALUES ("JN7_37","073_7_37","JHN","7","37","37","Pa lichobha la kujomukela, lichobha lela likolongwa la uwangalalu, Yesu akajemiki, na kujamalila, akapwaghaje, “Mundu joabhona inywita, ahikaje kwangu nepani, na akunywaje. ");
INSERT INTO mpa_vpl VALUES ("JN7_38","073_7_38","JHN","7","38","38","Ngati moghapwaghi Malembu Mahuhu kubha, ‘Jola joanhobhalela nepani, mikoka ja machi ghaghabhi womi anajipitaje kuhuma mkati jaki.’ ” ");
INSERT INTO mpa_vpl VALUES ("JN7_39","073_7_39","JHN","7","39","39","Yesu akalilongi lilobhi leniheli kubhokana na Roho Mhuhu, ambaju bhala bhabhunhobhalela anabhunjopalyaje, kwa ndandi Roho Mhuhu akabhi akali ngakuhika, na maghambu Chapanga akabhi akali ngakuuyekula ulumbalilu waka Yesu. ");
INSERT INTO mpa_vpl VALUES ("JN7_40","073_7_40","JHN","7","40","40","Bhela bhandu bhangi pa uhangalalu pala pabhakajowini malobhi ghanihagha, bhakapwaghike, “Chakaka hajoju nde jola Mlota waka Chapanga.” ");
INSERT INTO mpa_vpl VALUES ("JN7_41","073_7_41","JHN","7","41","41","Bhangi bhakapwaghike, “Hajoju nde Kristo.” Nambu bhangi bhakapwaghike, “Bho, Kristo aweza bhole kuhuma ku Galilaya? ");
INSERT INTO mpa_vpl VALUES ("JN7_42","073_7_42","JHN","7","42","42","Bho, Malembu Mahuhu ngacheghapwagha, ‘Kristo anahikaje kuhuma mu lubheleku lwaka Nkolongwa Daude, na kuhuma ku Beselehemu, na muchi ghola ghoatamika Daude?’ ” ");
INSERT INTO mpa_vpl VALUES ("JN7_43","073_7_43","JHN","7","43","43","Bhela kukapitali na kulekangana pachilanda ja lipogha la bhandu kwa ndandi jaka Yesu. ");
INSERT INTO mpa_vpl VALUES ("JN7_44","073_7_44","JHN","7","44","44","Bhakumu bhabhu bhakapaliki kunkamula, nambu nga mundu joakalengiki kuhatambula chiwoku chaki nahuli kunkamula. ");
INSERT INTO mpa_vpl VALUES ("JN7_45","073_7_45","JHN","7","45","45","Bhela bhalonda bhala bhakabhajendili ihongozi bha bhapenganyambiku na Mafalisayo. Nabhombi bhakabhapwaghile, “Bho, mbona ngachemundetiki Yesu?” ");
INSERT INTO mpa_vpl VALUES ("JN7_46","073_7_46","JHN","7","46","46","Bhalonda bhala bhakabhayangike, “Nga mundu jokapi joalabhali kulongela ngati mundu hajoju!” ");
INSERT INTO mpa_vpl VALUES ("JN7_47","073_7_47","JHN","7","47","47","Bhela Mafalisayo bhakabhayangike, “Bho, mwehapa nanamu atehi kunkolowa? ");
INSERT INTO mpa_vpl VALUES ("JN7_48","073_7_48","JHN","7","48","48","Bho, ndabhali le kumbona chiongozi jokapi jola wa Bhayahude joanhobhalela, au pachilanda ja Mafalisayo? ");
INSERT INTO mpa_vpl VALUES ("JN7_49","073_7_49","JHN","7","49","49","Ngabhela! Nambu bhandu abhabha bhangakujimanya Shelia jaka Musa bhabhili na masolu!” ");
INSERT INTO mpa_vpl VALUES ("JN7_50","073_7_50","JHN","7","50","50","Panihapa Nikodemu, jola joakabhi anjendili Yesu lichobha limu ikilu, ambaju akabhi jumu wabhu, akabhapwaghile, ");
INSERT INTO mpa_vpl VALUES ("JN7_51","073_7_51","JHN","7","51","51","“Bho, Shelia jitu juntemu mundu panga na kunjowanela hote, na kumanya cheahengike?” ");
INSERT INTO mpa_vpl VALUES ("JN7_52","073_7_52","JHN","7","52","52","Bhakamuyangike, na kumpwaghila, “Bho, wehapa nanau uhumiki ku Galilaya? Ulondaje na anaubhonaje kubha nga mlota waka Chapanga joahuma ku Galilaya.” ");
INSERT INTO mpa_vpl VALUES ("JN7_53","073_7_53","JHN","7","53","53","Bhela, kila jumu akabhujiki kunyumba jaki. ");
INSERT INTO mpa_vpl VALUES ("JN8_1","073_8_1","JHN","8","1","1","Bhela Yesu akapiti mbaka ku Chitombi cha Mizeituni. ");
INSERT INTO mpa_vpl VALUES ("JN8_2","073_8_2","JHN","8","2","2","Lukela pakwachile akajingili kabheti mu liwangala la Nyumba jaka Chapanga, na bhandu bhokapi bhakunjendile, najombi akatami pahi, na kutumbula kubhabhola. ");
INSERT INTO mpa_vpl VALUES ("JN8_3","073_8_3","JHN","8","3","3","Bhabhola bha Shelia na Mafalisayo bhakundetili mbomba jumu joakamuliki akahenga ugone, na kunjemeka pachilanda jabhu, ");
INSERT INTO mpa_vpl VALUES ("JN8_4","073_8_4","JHN","8","4","4","bhakumpwaghi Yesu, “Mbola, mbomba hajoju akamuliki paakabhi ahenga ugone. ");
INSERT INTO mpa_vpl VALUES ("JN8_5","073_8_5","JHN","8","5","5","Bhela mu Shelia jitu, Musa akatulaghalakili kubhalapula kwa maganga mbaka bhapotilaje akambomba ngati abhabha. Nambu bho, wehapa upwagha bhole?” ");
INSERT INTO mpa_vpl VALUES ("JN8_6","073_8_6","JHN","8","6","6","Bhombi bhakapwaghiki lilobhi leniheli kwa kundenga Yesu, nahuli bhapataje ndandi ja kumtakila. Nambu Yesu akajinimi, na kulemba paluhombi, kwa lukonji lwaki. ");
INSERT INTO mpa_vpl VALUES ("JN8_7","073_8_7","JHN","8","7","7","Bhombi pabhakajendali kundalukila, akajinwiki, na kubhapwaghila, “Mundu jokapi jwangakubha na mahoku pachilanda jinu, na akubhaje wa kutumbula kundapula liganga.” ");
INSERT INTO mpa_vpl VALUES ("JN8_8","073_8_8","JHN","8","8","8","Akajinimi kabheti pahi na kulemba paluhombi. ");
INSERT INTO mpa_vpl VALUES ("JN8_9","073_8_9","JHN","8","9","9","Bhombi pabhajowini malobhi ghanihagha bhakatakilwi na zamili yabhu, na bhakabhokiki jumu jumu, bhakatumbula bhazee. Yesu akahighali kanjika jaki, na mbomba jola akabhi ajemiki palapala. ");
INSERT INTO mpa_vpl VALUES ("JN8_10","073_8_10","JHN","8","10","10","Yesu akajinwiki na kumpwaghila mbomba jola, “Mbomba, bho, bhabhi kwaku bhala bhabhakutakile? Bho, nga jumu joakutemwili kubha na lihoku?” ");
INSERT INTO mpa_vpl VALUES ("JN8_11","073_8_11","JHN","8","11","11","Mbomba jola akamuyangike, “Bambo, njeta hata mundu jumu.” Yesu akumpwaghile, “Wala nepani nganukutemule. Ujendaje, na kutumbu sajenu ngawihenga mahoku kabhete.” ");
INSERT INTO mpa_vpl VALUES ("JN8_12","073_8_12","JHN","8","12","12","Bhela Yesu akalongili na bhandu kabhete, akapwaghaje, “Nepani nde unang'anu wa ndema, jombi joanyengalela nepani ngaajendi mulwihi ng'o, nambu anakubhaje na unang'anu wa womi.” ");
INSERT INTO mpa_vpl VALUES ("JN8_13","073_8_13","JHN","8","13","13","Bhela Mafalisayo bhakumpwaghile, “Wehapa ulilandila wamwete, kulilandila kwaku nga kwa chakaka.” ");
INSERT INTO mpa_vpl VALUES ("JN8_14","073_8_14","JHN","8","14","14","Yesu akayangike, “Nepani hata ngati nililandila namwete, ulandilu wangu nde wa chakaka, kwa ndandi manyi konhuma, na kola konyenda. Nambu mwehapa ngachemmanyi kola konhuma, wala kola konyenda. ");
INSERT INTO mpa_vpl VALUES ("JN8_15","073_8_15","JHN","8","15","15","Mwehapa mtemula kwa kujengalela mambu gha hyegha, nambu nepani ngachenuntemula mundu jokapi jola. ");
INSERT INTO mpa_vpl VALUES ("JN8_16","073_8_16","JHN","8","16","16","Nepani hata ngati anandemwile, utemulu wangu nde chakaka. Kwa ndandi nepani ngachemi kanjika jangu, nambu mili nepani papamu na Atati joandumike. ");
INSERT INTO mpa_vpl VALUES ("JN8_17","073_8_17","JHN","8","17","17","Kabheti ilembakiki mu Shelia hinu kubha, ulandilu wa bhandu bhabeli nde wa chakaka. ");
INSERT INTO mpa_vpl VALUES ("JN8_18","073_8_18","JHN","8","18","18","Nepani nililandila namwete, najombi Atati joandumiki anandila bhelabhela.” ");
INSERT INTO mpa_vpl VALUES ("JN8_19","073_8_19","JHN","8","19","19","Bhela bhakumpwaghile, “Bho, abhi kwaku Atati wako?” Yesu akabhayangike, “Nepani ngachemmanye, wala Atati wangu ngachemummanye. Ngati mkamanyiki nepani, mkabya mummanyiki na Atati wangu.” ");
INSERT INTO mpa_vpl VALUES ("JN8_20","073_8_20","JHN","8","20","20","Yesu akaghalongili malobhi ghanihagha paakabhi abhola mu liwangala la Nyumba jaka Chapanga, mu chumba cha kubheke masanduku gha nyambiko. Wala nga mundu joakunkamwile, kwa ndandi lisaa laki lakabhi likali ngakuhika. ");
INSERT INTO mpa_vpl VALUES ("JN8_21","073_8_21","JHN","8","21","21","Yesu akabhapwaghi kabhete, “Nepani ndenda kubhoka, nanamu anamnondaje, nanamu anampotilaje mu mahoku ghinu. Konyenda nepani, mwehapa ngamuwezi kuhika.” ");
INSERT INTO mpa_vpl VALUES ("JN8_22","073_8_22","JHN","8","22","22","Bhela ihongozi bha Bhayahude bhakapwaghike, “Bho, anaalikoma le mwene? Kwa ndandi apwagha, ‘Konyenda nepani, mwehapa ngamuwezi kuhika!’ ” ");
INSERT INTO mpa_vpl VALUES ("JN8_23","073_8_23","JHN","8","23","23","Yesu akabhapwaghile, “Mwehapa muhumiki pahi, nambu nepani nhumiki kunani kumahunde. Mwehapa nde bha pani pundema, nambu nepani nga wa pundema ghoni. ");
INSERT INTO mpa_vpl VALUES ("JN8_24","073_8_24","JHN","8","24","24","Bhela nakumpwaghi kubha anampotilaje mu mahoku ghinu, kwa ndandi nangakuhobhalela kubha, ‘Nepani nde Jombi,’ anampotilale mu mahoku ghinu.” ");
INSERT INTO mpa_vpl VALUES ("JN8_25","073_8_25","JHN","8","25","25","Bhela bhakumpwaghile, “Bho, wehapa wa nane?” Yesu akabhapwaghile, “Nepani nde jola jonakabhili nukumpwaghilaje kutumbu pakutumbula. ");
INSERT INTO mpa_vpl VALUES ("JN8_26","073_8_26","JHN","8","26","26","Mili naghu ghamaheli gha kulongela na kutemula panani jinu. Nambu jola joandumike nde chakaka, nanatu ghanaghajowini kwaki nde ghanongela kwa bhandu bha pundema.” ");
INSERT INTO mpa_vpl VALUES ("JN8_27","073_8_27","JHN","8","27","27","Wala ngachebhamanyi kubha akabhi abhapwaghila panani jaka Chapanga Atati wake. ");
INSERT INTO mpa_vpl VALUES ("JN8_28","073_8_28","JHN","8","28","28","Bhela Yesu akabhapwaghile, “Pamwibya njomwili kunkweha panani Mwana waka Mundu, panihapa nde pamwimanyaje kubha ‘Nepani nde Jombi,’ na kubha ngachenhenga lilobhi lokapi lela ngati mombali namwete, nambu nongela chela pela ngati Atati wangu moamolile. ");
INSERT INTO mpa_vpl VALUES ("JN8_29","073_8_29","JHN","8","29","29","Jombi joandumike abhi papamu na nepani, Atati ngacheanekiki nepani kanjika jangu, kwa ndandi machobha ghokapi nhenga mambu ghala ghaghunyambiha.” ");
INSERT INTO mpa_vpl VALUES ("JN8_30","073_8_30","JHN","8","30","30","Yesu paakabhi alongela malobhi ghanihagha, bhandu bhamaheli bhakunhobhalile. ");
INSERT INTO mpa_vpl VALUES ("JN8_31","073_8_31","JHN","8","31","31","Bhela Yesu akabhapwaghi Bhayahude bhabhunhobhali bhala kubha, “Mwehapa anamtamakili mu malobhi ghangu, anamkubhaje bhabhulwa bhangu bha chakaka. ");
INSERT INTO mpa_vpl VALUES ("JN8_32","073_8_32","JHN","8","32","32","Anamujimanya chakaka, na chakaka heji anajumbeka mwehapa kulijeka.” ");
INSERT INTO mpa_vpl VALUES ("JN8_33","073_8_33","JHN","8","33","33","Bhakamuyangike, “Tepani tubhi lubheleku lwaka Ibulahimu, wala ngachetubhi bhatumwa bhaka mundu jokapi jola. Bho, uweza bhole kupwagha kubha, ‘Anambya kulijeka?’ ” ");
INSERT INTO mpa_vpl VALUES ("JN8_34","073_8_34","JHN","8","34","34","Yesu akabhayangike, “Chakaka numpwaghila, kila mundu joahenga mahoku nde mtumwa wa mahoku. ");
INSERT INTO mpa_vpl VALUES ("JN8_35","073_8_35","JHN","8","35","35","Wala mtumwa ngacheatama panyumba machobha ghokape, nambu mwana atama mileli. ");
INSERT INTO mpa_vpl VALUES ("JN8_36","073_8_36","JHN","8","36","36","Bhela ngati Mwana anaambekiki kulijeka, anambya kulijeka chakaka. ");
INSERT INTO mpa_vpl VALUES ("JN8_37","073_8_37","JHN","8","37","37","Manyi kubha mwehapa nde lubheleku lwaka Ibulahimu, nambu mpala kungoma, maghambu lilobhi langu ngachelibhi mkati jinu. ");
INSERT INTO mpa_vpl VALUES ("JN8_38","073_8_38","JHN","8","38","38","Ghanaghaweni kwa Atati wangu nde ghanaghalongela, nanamu bhelabhela ghamughajowini kwa atati winu nde ghamughahenga.” ");
INSERT INTO mpa_vpl VALUES ("JN8_39","073_8_39","JHN","8","39","39","Bhakayangike, “Atati witu nde Ibulahimu!” Yesu akabhapwaghile, “Ngati mkabhi bhana bhaka Ibulahimu, mkabya mughahengiki mahengu ghala ghaakahengiki Ibulahimu.” ");
INSERT INTO mpa_vpl VALUES ("JN8_40","073_8_40","JHN","8","40","40","Nambu sajenu mpala kungoma nepani, nenumpwaghili jejibhi chakaka jenyowini kwaka Chapanga. Ibulahimu ngacheahengiki bhenibhela. ");
INSERT INTO mpa_vpl VALUES ("JN8_41","073_8_41","JHN","8","41","41","Mwehapa mughahenga mahengu gha atati winu. Bhombi bhakamuyangike, “Tepani ngachetwabhelakiki kwa ukemi, tepani tubhi na Atati jumu, yani, Chapanga.” ");
INSERT INTO mpa_vpl VALUES ("JN8_42","073_8_42","JHN","8","42","42","Yesu akabhapwaghile, “Ngati Chapanga akabhi Atati winu, mkabya mbaliki nepani, kwa ndandi nakahumiki kwaka Chapanga, na sajenu mili pambane, wala ngachenahikiki kwa kupala namwete, nambu jombi nde joandumike. ");
INSERT INTO mpa_vpl VALUES ("JN8_43","073_8_43","JHN","8","43","43","Bho, mbona ngachemughamanya aghagha ghanumpwaghila? Nde kwa kubha mwehapa ngachempala kughajowanela mabholu ghangu. ");
INSERT INTO mpa_vpl VALUES ("JN8_44","073_8_44","JHN","8","44","44","Mwehapa nde mabhana bha atati winu Shetani, na mpala pe kuhenga matokulelu gha atati winu. Jombi akabhi wa kukoma bhandu kutumbu pamwandi, na wala ngacheakajemi mu upambala wa chakaka, na chakaka ngachejibhili mkati jake. Paalonge upuhe, alongela ghaghabhi ghaki mweni, kwa ndandi jombi nde mpuhe, na atati wa upuhe. ");
INSERT INTO mpa_vpl VALUES ("JN8_45","073_8_45","JHN","8","45","45","Kwa ndandi nepani numpwaghi chakaka, nambu mwehapa ngachemnihobhalela. ");
INSERT INTO mpa_vpl VALUES ("JN8_46","073_8_46","JHN","8","46","46","Bho, mundu bholi pachilanda jinu joaweza kulangiha kubha nepani mili na mahoku? Na ngati nongela chakaka, bho, mbona ngachemnihobhalela? ");
INSERT INTO mpa_vpl VALUES ("JN8_47","073_8_47","JHN","8","47","47","Jombi joabhi waka Chapanga aghajowana malobhi ghaka Chapanga, bhela mwehapa ngachenjowanela kwa ndandi mwehapa nga mabhandu bhaka Chapanga.” ");
INSERT INTO mpa_vpl VALUES ("JN8_48","073_8_48","JHN","8","48","48","Bhayahude bhakamuyangiki Yesu, “Bho, tepani ngachetupwagha chakaka kubha wehapa nde Msamalia, na kabheti ubhi na lijobhe?” ");
INSERT INTO mpa_vpl VALUES ("JN8_49","073_8_49","JHN","8","49","49","Yesu akayangike, “Nepani ngachemi na lijobhe. Nepani nuntopela Atati wangu, na mwehapa muheketa utopelu wangu. ");
INSERT INTO mpa_vpl VALUES ("JN8_50","073_8_50","JHN","8","50","50","Nepani ngachenonda ulumbalilu wangu, nambu abhi jumu joanondela ulumbalilu wango. ");
INSERT INTO mpa_vpl VALUES ("JN8_51","073_8_51","JHN","8","51","51","Chakaka numpwaghila, mundu anaalikamwili lilobhi langu, ngayipoteli mileli.” ");
INSERT INTO mpa_vpl VALUES ("JN8_52","073_8_52","JHN","8","52","52","Bhela Bhayahude bhakumpwaghile, “Sajenu tumanyi kubha wehapa ubhi na lijobhe. Ibulahimu apotile, na bhalota bhaka Chapanga bhapotile, na wehapa upwagha kubha, ‘Mundu anaalikamwi lilobhi langu, ngayipoteli mileli.’ ");
INSERT INTO mpa_vpl VALUES ("JN8_53","073_8_53","JHN","8","53","53","Bho, wehapa le unkolongwa kupeta atati witu Ibulahimu, ambaju apotile? Nabhombi bhalota bhaka Chapanga bhapotile. Bho, wehapa ulitenda kubha wa nane?” ");
INSERT INTO mpa_vpl VALUES ("JN8_54","073_8_54","JHN","8","54","54","Yesu akayangike, “Ananililumbalili namwete ulumbalilu wangu nga chindu. Joanumbali nepani nde Atati wangu, ambaju mwehapa mpwagha kubha nde Chapanga winu. ");
INSERT INTO mpa_vpl VALUES ("JN8_55","073_8_55","JHN","8","55","55","Wala mwehapa ngachemummanye, nambu nepani nummanye. Ngati anambwaghiki ngachenummanye, anangubha numpuhe ngati mwehapa. Nambu nummanye, na lilobhi laki nilikamula. ");
INSERT INTO mpa_vpl VALUES ("JN8_56","073_8_56","JHN","8","56","56","Atati winu, Ibulahimu, akahekalili kulibhona lichobha la kuhika kwangu, najombi akaliweni, na akahekalile.” ");
INSERT INTO mpa_vpl VALUES ("JN8_57","073_8_57","JHN","8","57","57","Bhela Bhayahude bhakumpwaghile, “Wehapa wakali ngacheuhikiki hyaka hamsini, bho, upwagha bhole kubha umbweni Ibulahimu?” ");
INSERT INTO mpa_vpl VALUES ("JN8_58","073_8_58","JHN","8","58","58","Yesu akabhapwaghile, “Chakaka, numpwaghila, mangani jaka Ibulahimu kubhelakeka, ‘Nepani mile.’ ” ");
INSERT INTO mpa_vpl VALUES ("JN8_59","073_8_59","JHN","8","59","59","Bhela bhakatondwili maganga nahuli kundapula, nambu Yesu akalihiiki, na kupita pa Nyumba jaka Chapanga, na kubhoka. ");
INSERT INTO mpa_vpl VALUES ("JN9_1","073_9_1","JHN","9","1","1","Yesu paakabhi apeta, akumbweni mundu joakabhi ngalola kutumbu kubhelakeka. ");
INSERT INTO mpa_vpl VALUES ("JN9_2","073_9_2","JHN","9","2","2","Bhabhulwa bhaki bhakundalukili bhakapwaghaje, “Mbola, bho, nane joatendiki mahoku, mundu ajoju au bhabheleka bhaki, mbaka abhelakika ngalola?” ");
INSERT INTO mpa_vpl VALUES ("JN9_3","073_9_3","JHN","9","3","3","Yesu akayangike, “Hajoju ngacheatendiki mahoku, wala bhabheleka bhaki, nambu akabhelakiki ngalola nahuli makili ghaka Chapanga ghabhonikanaje ghahenga lihengu mkati jaki. ");
INSERT INTO mpa_vpl VALUES ("JN9_4","073_9_4","JHN","9","4","4","Imbalika kuhenga mahengu ghaki jombi joandumike. Koni kwakali muhi, ikilu jihika, kwanga kuweza mundu kutenda lihengu. ");
INSERT INTO mpa_vpl VALUES ("JN9_5","073_9_5","JHN","9","5","5","Chikahi chemili pundema, nepani nde unang'anu wa ndema.” ");
INSERT INTO mpa_vpl VALUES ("JN9_6","073_9_6","JHN","9","6","6","Paakajomwi kulongela ghanihagha, Yesu akahuniki imata pahi, akatendiki litopi kwa imata ghala, na kumpaka ngalola jola litopi mumihu, ");
INSERT INTO mpa_vpl VALUES ("JN9_7","073_9_7","JHN","9","7","7","na kumpwaghila, “Ujendaje ukachamba machi ku litanda la Siloamu. Silohamu ndandi jaki joatumakike.” Bhela akapiti, na kuchamba machi, na kukelabhuka koni akabya alola. ");
INSERT INTO mpa_vpl VALUES ("JN9_8","073_9_8","JHN","9","8","8","Bhela bhandu bha pambipi jaki, na bhala bhabhakumbweni mwandi kubha akabhi njopajopa, bhakapwaghike, “Bho, hajoju le nga jola joakabhi akatamaje na kujopajopa?” ");
INSERT INTO mpa_vpl VALUES ("JN9_9","073_9_9","JHN","9","9","9","Bhangi bhakapwaghike, “Nde jombe.” Bhangi bhakapwaghike, “Nga jombe! Nambu atehi pe kulengana naku.” Jombi mweni akapwaghike, “Nepani nde jombi.” ");
INSERT INTO mpa_vpl VALUES ("JN9_10","073_9_10","JHN","9","10","10","Bhela bhakundalukile, “Bho, mihu ghaku ghayekuliwi bhole?” ");
INSERT INTO mpa_vpl VALUES ("JN9_11","073_9_11","JHN","9","11","11","Jombi akabhayangike, “Mundu jola joalowakeka Yesu akatendiki litopi, akambakiki mumihu, na kumbwaghila, ‘Ujenda ku litanda la Siloamu, ukachamba machi kumihu.’ Bhela nakapiti, na kuchamba, na nakapatiki kulola.” ");
INSERT INTO mpa_vpl VALUES ("JN9_12","073_9_12","JHN","9","12","12","Bhakumpwaghile, “Bho, abhi kwaku jonihojo?” Akayangike, “Nepani ngachemanye!” ");
INSERT INTO mpa_vpl VALUES ("JN9_13","073_9_13","JHN","9","13","13","Bhela bhakumpeliki kwa Mafalisayo mundu jola joakabhi ngalola pamwandi. ");
INSERT INTO mpa_vpl VALUES ("JN9_14","073_9_14","JHN","9","14","14","Bhela lichobha heli Yesu paakalenganaki litopi na kughayekula mihu ghaka mundu hoju, lakabhi Lichobha la Sabato. ");
INSERT INTO mpa_vpl VALUES ("JN9_15","073_9_15","JHN","9","15","15","Bhela Mafalisayo bhakundaluki kabhete mundu jola ntundu bholi moapati kulola. Akabhapwaghile, “Akanyeghi litopi panani ja mihu, na nepani nakachambiki machi, na sajenu nola.” ");
INSERT INTO mpa_vpl VALUES ("JN9_16","073_9_16","JHN","9","16","16","Bhela Mafalisayo bhakumu bhakapwaghike, “Mundu hoju ngacheakahumiki kwaka Chapanga, kwa ndandi ngacheakamula Lichobha la Sabato.” Bhangi bhakapwaghike, “Bho, aweza bholi mundu mwana mahoku kutenda nginyulila ngati yeniheye?” Kukabhi na kulekana pachilanda jabhu. ");
INSERT INTO mpa_vpl VALUES ("JN9_17","073_9_17","JHN","9","17","17","Bhela bhakundaluki mundu jola joakabhi ngalola mala ja kabheli, “Bho, wehapa upwagha bholi malobhi ghaki kubhokana na moakuyekuli mihu ghako?” Jombi akapwaghike, “Jombi nde mlota waka Chapanga.” ");
INSERT INTO mpa_vpl VALUES ("JN9_18","073_9_18","JHN","9","18","18","Bhela ihongozi bha Bhayahude ngachebhahobhali malobhi ghaki, gha kubha akabhi ngalola, na akapatiki kulola, mbaka pabhakabhalohiki bhabheleka bhaki mundu jola joakapatiki kulola. ");
INSERT INTO mpa_vpl VALUES ("JN9_19","073_9_19","JHN","9","19","19","Bhakabhalalukili bhabheleka bhaki, “Bho, hajoju le mwana winu, jompwagha kubha akabhelakiki ngalola? Bho, henu apatiki bholi kulola?” ");
INSERT INTO mpa_vpl VALUES ("JN9_20","073_9_20","JHN","9","20","20","Bhabheleka bhaki bhakayangike, “Tumanya kubha hajoju nde mwana witu, na kabheti akabhelakiki ngalola. ");
INSERT INTO mpa_vpl VALUES ("JN9_21","073_9_21","JHN","9","21","21","Nambu ntundu moalole sajenu ngachetumanyi, jombi nde akolike, mundalukya jombi, anaalilongalya mwene!” ");
INSERT INTO mpa_vpl VALUES ("JN9_22","073_9_22","JHN","9","22","22","Bhabheleka bhaki bhakalongi ghanihagha kwa ndandi bhakabhi bhabhajoghopa Bhayahude, maghambu Bhayahude bhakabhi bhajomwi kujetanganela kubha mundu anaanjetakili kubha Yesu nde Kristo, anaatopuliwa kunja ja nyumba ja kuhimanganila. ");
INSERT INTO mpa_vpl VALUES ("JN9_23","073_9_23","JHN","9","23","23","Nde ndandi bhabheleka bhaki bhakapwaghiki, “Hajoju akolike, mundalukya jombe!” ");
INSERT INTO mpa_vpl VALUES ("JN9_24","073_9_24","JHN","9","24","24","Bhela bhakundohiki kabhete mala ja kabheli mundu jola joakabhelakiki ngalola, na kumpwaghila, “Umpekya Chapanga ulumbalilu! Tepani tumanyi kubha mundu hajoju joakulamihe nde mwana mahoku.” ");
INSERT INTO mpa_vpl VALUES ("JN9_25","073_9_25","JHN","9","25","25","Bhela mundu jola akayangike, “Kubha jombi nde mwana mahoku au nga mwana mahoku, ngachemanya. Nambu chindu chimu chemanya, kubha nakabhi ngalola, na sajenu nola.” ");
INSERT INTO mpa_vpl VALUES ("JN9_26","073_9_26","JHN","9","26","26","Bhela bhakumpwaghile, “Bho, akuhengi kike? Bho, akuyekwi mihu kwa indela bhole?” ");
INSERT INTO mpa_vpl VALUES ("JN9_27","073_9_27","JHN","9","27","27","Akabhapwaghile, “Nyomwi kumpwaghila, wala ngachenjowine. Bho, mbona mpala kujowana kabhete? Bho, Mabhanganya nanamu mpala kubha bhabhulwa bhake?” ");
INSERT INTO mpa_vpl VALUES ("JN9_28","073_9_28","JHN","9","28","28","Bhela bhakuntondwili, bhakapwaghaje, “Wehapa nde wa mbulwa waka mundu jola, nambu tepani nde bhabhulwa bhaka Musa. ");
INSERT INTO mpa_vpl VALUES ("JN9_29","073_9_29","JHN","9","29","29","Tepani tumanyi kubha Chapanga akalongili na Musa, nambu mundu jonijola ngachetumanyi koahumike!” ");
INSERT INTO mpa_vpl VALUES ("JN9_30","073_9_30","JHN","9","30","30","Mundu jola akayangike, “Haleli nde lijambu la kukangacha! Kubha mwehapa ngachemmanya koahuma, najombi akaniyekwi mihu! ");
INSERT INTO mpa_vpl VALUES ("JN9_31","073_9_31","JHN","9","31","31","Tumanya kubha Chapanga ngacheajowanela bhana mahoku, nambu mundu joanjoghopa Chapanga, na kughahenga mapalu ghaka Chapanga, anjowanela jonihoju. ");
INSERT INTO mpa_vpl VALUES ("JN9_32","073_9_32","JHN","9","32","32","Kutumbula kubhombakeka kwa ndema ngachetujowini kubha mundu andamihi jokapi jola joabhelakiki ngalola. ");
INSERT INTO mpa_vpl VALUES ("JN9_33","073_9_33","JHN","9","33","33","Ngati mundu hajoju ngacheakahumiki kwa Chapanga, ngaakaweziki kuhenga lihengu lokapi lela.” ");
INSERT INTO mpa_vpl VALUES ("JN9_34","073_9_34","JHN","9","34","34","Bhombi bhakayangike, “Wehapa ukabhelakiki na kukolela mu mahoku pela, bho, nanau utubhola tepani?” Bhakumpihiki kunja ja nyumba ja kuhimangani Bhayahude. ");
INSERT INTO mpa_vpl VALUES ("JN9_35","073_9_35","JHN","9","35","35","Yesu akajowini kubha bhumpihiki kunja ja nyumba ja kuhimangani Bhayahude, najombi paakumbweni akumpwaghile, “Bho, wehapa le unhobhalela Mwana waka Chapanga?” ");
INSERT INTO mpa_vpl VALUES ("JN9_36","073_9_36","JHN","9","36","36","Mundu hoju akayangike, “Jombi nde nane, Bambo, nahuli mbata kunhobhalela?” ");
INSERT INTO mpa_vpl VALUES ("JN9_37","073_9_37","JHN","9","37","37","Yesu akumpwaghile, “Ujomwi kumbona, najombi nde joalongela na wehapa sajeno.” ");
INSERT INTO mpa_vpl VALUES ("JN9_38","073_9_38","JHN","9","38","38","Akapwaghike, “Bambo, nhobhalela.” Najombi akunjojabhile. ");
INSERT INTO mpa_vpl VALUES ("JN9_39","073_9_39","JHN","9","39","39","Yesu akapwaghike, “Nepani nhikiki pundema ghongone kubhatemula bhandu, nahuli bhala bhangakulola bhalolaje, na bhala bhabhalola bhabya akangalola.” ");
INSERT INTO mpa_vpl VALUES ("JN9_40","073_9_40","JHN","9","40","40","Mafalisayo bhakumu bhabhakabhi papamu naku bhakajowini ghanighala, bhakumpwaghile, “Bho, tepani natatu tubhi le akangalola?” ");
INSERT INTO mpa_vpl VALUES ("JN9_41","073_9_41","JHN","9","41","41","Yesu akabhapwaghile, “Ngati mwakabhi akangalola, ngamwakabhonakini kubha mbi na mahoku, nambu mwehapa mpwagha kubha ‘Tulola,’ bhela mbonikana kubha mbi na mahoku.” ");
INSERT INTO mpa_vpl VALUES ("JN10_1","073_10_1","JHN","10","1","1","Yesu akabhapwaghile, “Chakaka, numpwaghila, jola jwangakujingila pundyangu mu libheghi la mambeleli, nambu akwela kwa kupetela pandu pangi, jonihoju nde mwihe najombi nde mnyaghula. ");
INSERT INTO mpa_vpl VALUES ("JN10_2","073_10_2","JHN","10","2","2","Nambu joajingila pundyangu, jonihoju nde mdima wa mambelele. ");
INSERT INTO mpa_vpl VALUES ("JN10_3","073_10_3","JHN","10","3","3","Mlonda wa pundyangu anhoghulela jonihoju, na mambeleli ghajowana sauti jake, najombi aghaloha mambeleli kwa mahina ghabhu, na kughapeleka kunja. ");
INSERT INTO mpa_vpl VALUES ("JN10_4","073_10_4","JHN","10","4","4","Najombi paaghapiha kunja mambeleli ghaki ghokapi, aghalongulela, na mambeleli ghala ghunjengalela, maghambu bhajimanya sauti jake. ");
INSERT INTO mpa_vpl VALUES ("JN10_5","073_10_5","JHN","10","5","5","Mambeleli hagha ngaghawezi kunjengalela ngeni ng'o, nambu anaghuntilaje, maghambu ngachebhajimanyi sauti jaka ngeni.” ");
INSERT INTO mpa_vpl VALUES ("JN10_6","073_10_6","JHN","10","6","6","Yesu akabhapwaghi ulenganesu aghoghu, nambu bhombi ngachebhamanyi mambu ghaakabhi abhapwaghila. ");
INSERT INTO mpa_vpl VALUES ("JN10_7","073_10_7","JHN","10","7","7","Bhela Yesu akabhapwaghi kabhete, “Chakaka, numpwaghila nepani nde ndyangu wa mambelele. ");
INSERT INTO mpa_vpl VALUES ("JN10_8","073_10_8","JHN","10","8","8","Bhokapi bhabhanongulile nde bhihe na bhanyaghula, nambu mambeleli ngacheghajowanile. ");
INSERT INTO mpa_vpl VALUES ("JN10_9","073_10_9","JHN","10","9","9","Nepani nde ndyangu. Mundu anaajingi kwangu nepani, anaakengalikaje, anaajingala na kupita, najombi anaapata malelelo. ");
INSERT INTO mpa_vpl VALUES ("JN10_10","073_10_10","JHN","10","10","10","Mwihi ahika pe kwa ndandi ja kujibha, kukoma, na kuyonanga. Nepani nakahikiki nahuli bhabya na womi, kabheti bhabya naku womi wamaheli.” ");
INSERT INTO mpa_vpl VALUES ("JN10_11","073_10_11","JHN","10","11","11","“Nepani nde mdima wambone. Mdima wambone aubhoha womi waki kwa ndandi ja mambelele. ");
INSERT INTO mpa_vpl VALUES ("JN10_12","073_10_12","JHN","10","12","12","Nambu mundu wa malepu, wala nga mdima wa mambelele, ambaju mambeleli nga ghake, paalibhona libweha lihika, aghaleka mambelele na mweni kutila. Na libweha lighakamula na kughapechangana. ");
INSERT INTO mpa_vpl VALUES ("JN10_13","073_10_13","JHN","10","13","13","Mundu hoju atila, wala ngacheaghajali mambelele, kwa ndandi abhi mundu wa malepu pela. ");
INSERT INTO mpa_vpl VALUES ("JN10_14","073_10_14","JHN","10","14","14","Nepani nde mdima wambone, na naghamanya mambelele ghangu, na mambelele ghangu ghamanye. ");
INSERT INTO mpa_vpl VALUES ("JN10_15","073_10_15","JHN","10","15","15","Ngati bhela Atati moamanyi nepani, na nepani monimmanyi Atati. Na nepani niubhoha womi wangu kwa ndandi ja mambelele. ");
INSERT INTO mpa_vpl VALUES ("JN10_16","073_10_16","JHN","10","16","16","Na mili kabheti na mambeleli ghangi, ghaghu nga gha libheghi lendeno, na ghanihagha naghombe imbalika kughaleta, na sauti jangu anabhajowanaje, na bhela anakukubhaje na lipogha limu na mdima jumu.” ");
INSERT INTO mpa_vpl VALUES ("JN10_17","073_10_17","JHN","10","17","17","“Atati wangu ambala nepani, maghambu nubhoha womi wangu, nahuli nupataje kabhete. ");
INSERT INTO mpa_vpl VALUES ("JN10_18","073_10_18","JHN","10","18","18","Nga mundu joamokela womi wangu, nambu nepani nubhoha namwete. Mili na lujiniku lwa kuubhoha, na mili na lujiniku lwa kuukelebhuha kabhete. Anana nde Atati wangu moanaghalakile nhengaje.” ");
INSERT INTO mpa_vpl VALUES ("JN10_19","073_10_19","JHN","10","19","19","Kukabhi kabheti na ughabhaniku wa Bhayahude, kwa ndandi ja malobhi ghanihagha. ");
INSERT INTO mpa_vpl VALUES ("JN10_20","073_10_20","JHN","10","20","20","Bhamaheli bhabhu bhakapwaghike, “Hajoju abhi na lijobhe, na kabheti mwanamangongo! Bho, maghambu kiki munjowanela?” ");
INSERT INTO mpa_vpl VALUES ("JN10_21","073_10_21","JHN","10","21","21","Bhangi bhakapwaghike, “Malobhi ghanihagha nga ghaka mundu joabhi na lijobhe. Bho, lijobhi liweza kaghayeku mihu ghaka ngalola?” ");
INSERT INTO mpa_vpl VALUES ("JN10_22","073_10_22","JHN","10","22","22","Bhela ku Yelusalemu hoku kukabhili na Uwangalalu wa kubheka wakifu Nyumba jaka Chapanga, na chikahi hechi chakabhi chikahi cha imbepu. ");
INSERT INTO mpa_vpl VALUES ("JN10_23","073_10_23","JHN","10","23","23","Yesu akabhi akajendajenda mu Nyumba jaka Chapanga, mu liwangala laka Solomoni. ");
INSERT INTO mpa_vpl VALUES ("JN10_24","073_10_24","JHN","10","24","24","Bhela Bhayahude bhakamuyongalwiti, na kumpwaghila, “Bho, mbaka lile anautung'ahaje mitima jitu? Ngati wehapa nde wa Kristo, utupwaghila hotuhotu.” ");
INSERT INTO mpa_vpl VALUES ("JN10_25","073_10_25","JHN","10","25","25","Yesu akabhayangike, “Numpwaghile, nambu mwehapa ngachemuhobhalela. Mahengu ghangani ghanihenga kwa lihina la Atati wangu, nde ghaghanandila. ");
INSERT INTO mpa_vpl VALUES ("JN10_26","073_10_26","JHN","10","26","26","Nambu mwehapa ngachemuhobhalela, maghambu mwehapa ngachembili mu mambeleli ghangu. ");
INSERT INTO mpa_vpl VALUES ("JN10_27","073_10_27","JHN","10","27","27","Mambeleli ghangu ghajowana sauti jangu. Nanatu naghamanye, naghombi ghanyengalela. ");
INSERT INTO mpa_vpl VALUES ("JN10_28","073_10_28","JHN","10","28","28","Nanatu naghapekeha womi wa mileli, wala ngaghapoteli ng'o. Kabheti nga mundu joaweza kubhanyaghula kuhuma mu mabhoku ghangu. ");
INSERT INTO mpa_vpl VALUES ("JN10_29","073_10_29","JHN","10","29","29","Atati wangu, joambeki bhanihabha, nde nkolongwa kupeta bhokapi, kabheti nga mundu joaweza kubhanyaghula kuhuma mumabhoku gha Atati wangu. ");
INSERT INTO mpa_vpl VALUES ("JN10_30","073_10_30","JHN","10","30","30","Nepani na Atati wangu tubhi jumu.” ");
INSERT INTO mpa_vpl VALUES ("JN10_31","073_10_31","JHN","10","31","31","Bhela Bhayahude bhakatondwi maganga kabheti nahuli bhundapulaje. ");
INSERT INTO mpa_vpl VALUES ("JN10_32","073_10_32","JHN","10","32","32","Yesu akabhayangike, “Mahengu ghamboni ghamaheli nundangihe, ghaghahuma kwa Atati wangu, bho, kwa ndandi ja lihengu bhole pamahengu ghanihagha mpala kunapula kwa maganga?” ");
INSERT INTO mpa_vpl VALUES ("JN10_33","073_10_33","JHN","10","33","33","Bhayahude bhakamuyangike, “Ngechetukulapu maganga kwa ndandi ja mahengu ghambone, nambu kwa ndandi ja kutondola, na kwa ndandi wehapa weubhi wa mundu, ulitenda wamwete kubha nde Chapanga.” ");
INSERT INTO mpa_vpl VALUES ("JN10_34","073_10_34","JHN","10","34","34","Yesu akabhayangike, “Bho, ngacheilembakiki mu Shelia hinu kubha, ‘Nepani nakapwaghiki, kubha mwehapa nde ichapanga?’ ");
INSERT INTO mpa_vpl VALUES ("JN10_35","073_10_35","JHN","10","35","35","Ngati akabhalohiki ichapanga, bhala bhalakabhahiki Lilobhi laka Chapanga, naghombi Malembu Mahuhu ghapwagha chakaka machobha ghokapi, ");
INSERT INTO mpa_vpl VALUES ("JN10_36","073_10_36","JHN","10","36","36","henu jola ambaju Atati akungolwili na kuntuma pundema, maghambu kiki mbwaghi kubha nuntondola Chapanga, pambwagha, ‘Nepani nde Mwana waka Chapanga?’ ");
INSERT INTO mpa_vpl VALUES ("JN10_37","073_10_37","JHN","10","37","37","Ngati ngachenhenga mahengu gha Atati wangu, ngamwinhobhalela. ");
INSERT INTO mpa_vpl VALUES ("JN10_38","073_10_38","JHN","10","38","38","Nambu ananaghahenga, hata ngati ngachemunihobhalela nepani, mughahobhalyaje mahengu ghanihagha nahuli mpataje kumanya, na kuhobhalela, kubha Atati abhi mkati jangu, na nepani mili mkati ja Atati.” ");
INSERT INTO mpa_vpl VALUES ("JN10_39","073_10_39","JHN","10","39","39","Bhela bhakapaliki kabheti kunkamula, nambu Yesu akabhokiki mu mabhoku ghabhu. ");
INSERT INTO mpa_vpl VALUES ("JN10_40","073_10_40","JHN","10","40","40","Yesu akapiti kabhete kwihi ja nkoka Yoludani, pandu Yohana Mbatizaje paakabhi abatiza pakutumbula hapa, na kutama konihoku. ");
INSERT INTO mpa_vpl VALUES ("JN10_41","073_10_41","JHN","10","41","41","Bhandu bhamaheli bhakunjendi Yesu, na kupwagha, “Yohana ngacheakatendiki ngangachu jokapi jela, nambu mambu ghokapi Yohana ghaakalongili panani jaka mundu hajoju ghakabhi gha chakaka.” ");
INSERT INTO mpa_vpl VALUES ("JN10_42","073_10_42","JHN","10","42","42","Bhandu bhamaheli konihoku bhakunhobhali Yesu. ");
INSERT INTO mpa_vpl VALUES ("JN11_1","073_11_1","JHN","11","1","1","Bhela mundu jumu joakalowakiki Lazalo akabhi mtamwa. Jombi akabhi atama ku Besania, mwenehi wa chijiji cheatamika Malia na ndombu waki Masa. ");
INSERT INTO mpa_vpl VALUES ("JN11_2","073_11_2","JHN","11","2","2","Jonihoju akabhi nde Malia jola joakampakiki Bambo mahuta gha kunungila wichu, na kughahungula magholu ghaki kwa majunju ghaki. Lazalo mbeli waka Malia akabhi mtamwa. ");
INSERT INTO mpa_vpl VALUES ("JN11_3","073_11_3","JHN","11","3","3","Bhela bhalombu bhaki bhabheli bhala bhakatumiki ubholu kwaka Yesu, na kumpwaghila, “Bambo, nkochi waku joumpala jola atenda kulwala.” ");
INSERT INTO mpa_vpl VALUES ("JN11_4","073_11_4","JHN","11","4","4","Yesu paakajowini ghanihagha, akapwaghike, “Chitamu achechi nga cha kupotela, nambu kwa ndandi ja ulumbalilu waka Chapanga, nahuli Mwana waka Chapanga alumbalikaje mu chitamu chenihechi.” ");
INSERT INTO mpa_vpl VALUES ("JN11_5","073_11_5","JHN","11","5","5","Bhela Yesu akumpaliki Masa, Malia, na Lazalo. ");
INSERT INTO mpa_vpl VALUES ("JN11_6","073_11_6","JHN","11","6","6","Yesu paakajowini kubha Lazalo nde mtamwa, akajendali kutama pandu panipala kwa machobha ghabheli nakanopi. ");
INSERT INTO mpa_vpl VALUES ("JN11_7","073_11_7","JHN","11","7","7","Bhela Yesu akabhapwaghi bhabhulwa bhaki, “Tujendaje kabhete ku Yudea!” ");
INSERT INTO mpa_vpl VALUES ("JN11_8","073_11_8","JHN","11","8","8","Bhabhulwa bhaki bhakumpwaghile, “Mbola, kwichu kwichu pela Bhayahude bhakapaliki kukulapula kwa maganga, bho, nanau upala kujenda kabheti konihoko?” ");
INSERT INTO mpa_vpl VALUES ("JN11_9","073_11_9","JHN","11","9","9","Yesu akabhayangike, “Bho, Masaa gha muhi nga komi na ghabhele? Mundu anaajenda muhi ngachealikobhandola, maghambu aubhona unang'anu wa ndema ghone. ");
INSERT INTO mpa_vpl VALUES ("JN11_10","073_11_10","JHN","11","10","10","Nambu anaajendiki ikilu alikobhandola, maghambu unang'anu ngacheubhi mkati jake.” ");
INSERT INTO mpa_vpl VALUES ("JN11_11","073_11_11","JHN","11","11","11","Yesu paakajomwi kupwagha malobhi ghanihagha, akabhapwaghile, “Nkochi witu Lazalo aghonile, nambu nepani ananyenda kunjumuwa.” ");
INSERT INTO mpa_vpl VALUES ("JN11_12","073_11_12","JHN","11","12","12","Bhabhulwa bhaki bhakumpwaghile, “Bambo, anangati aghoni lughonu pela, anaalamaje.” ");
INSERT INTO mpa_vpl VALUES ("JN11_13","073_11_13","JHN","11","13","13","Yesu akabhi alongalela mambu gha kupotela kwaka Lazalo, nambu bhombi bhaholakya apwagha kubha Lazalo aghoni lughonu pela. ");
INSERT INTO mpa_vpl VALUES ("JN11_14","073_11_14","JHN","11","14","14","Bela Yesu akabhapwaghi hotuhotu, “Lazalo apotile. ");
INSERT INTO mpa_vpl VALUES ("JN11_15","073_11_15","JHN","11","15","15","Nambu kwa ndandi jinu nhekalela kwa kubha ngachenakabhi konihoko, nahuli mpata kuhobhalela, nambu sajenu tujendaje kwake.” ");
INSERT INTO mpa_vpl VALUES ("JN11_16","073_11_16","JHN","11","16","16","Bhela Tomaso, joalowakika Mapaha, akabhapwaghi bhabhulwa bhajaki, “Tujendaje na tepani, nahuli tukapotilaje papamu na Yesu!” ");
INSERT INTO mpa_vpl VALUES ("JN11_17","073_11_17","JHN","11","17","17","Bhela Yesu paakahikiki konihoku, akunketani Lazalo kubha ajomwi kutaghakika mulitengeli kwa machobha ncheche. ");
INSERT INTO mpa_vpl VALUES ("JN11_18","073_11_18","JHN","11","18","18","Na chijiji cha Besania chakabhi pambipi na Yelusalemu, utali waki ukabhi ngati kilometa itatu. ");
INSERT INTO mpa_vpl VALUES ("JN11_19","073_11_19","JHN","11","19","19","Bhayahude bhamaheli bhakabhi bhahikike kwaka Masa na Malia, nahuli kubhajeghe mtima kwa ndandi jaka mbeli wabhu. ");
INSERT INTO mpa_vpl VALUES ("JN11_20","073_11_20","JHN","11","20","20","Bhela Masa paakajowini kubha Yesu atenda kuhika, akapiti kunjopalela, nambu Malia akahighali atami kunyumba. ");
INSERT INTO mpa_vpl VALUES ("JN11_21","073_11_21","JHN","11","21","21","Masa akumpwaghi Yesu, “Bambo, ngati wehapa ukabhi pambane, mbeli wangu ngaakapotile. ");
INSERT INTO mpa_vpl VALUES ("JN11_22","073_11_22","JHN","11","22","22","Nambu hata sajenu manyi kubha, chokapi chewandobhaje Chapanga, Chapanga anaakupekyaje.” ");
INSERT INTO mpa_vpl VALUES ("JN11_23","073_11_23","JHN","11","23","23","Yesu akumpwaghile, “Mbeli waku anahyokaje kabhete.” ");
INSERT INTO mpa_vpl VALUES ("JN11_24","073_11_24","JHN","11","24","24","Masa akumpwaghile, “Manyi kubha anaayokaje pa uyohakeku wa bhakuwa mu lichobha la kujomukela.” ");
INSERT INTO mpa_vpl VALUES ("JN11_25","073_11_25","JHN","11","25","25","Yesu akumpwaghile, “Nepani nde uyohakeku hoghu, na nde nenabhapekeha bhandu womi. Mundu jokapi joanhobhale nepani, hata ngati anaapotile, anaakubha atama, ");
INSERT INTO mpa_vpl VALUES ("JN11_26","073_11_26","JHN","11","26","26","na kila mundu joatama na kunhobhalela nepani ngaapoteli mileli. Bho, uhobhalela ghanihagha?” ");
INSERT INTO mpa_vpl VALUES ("JN11_27","073_11_27","JHN","11","27","27","Masa akumpwaghile, “Ena, Bambo, nepani nhobhalela kubha wehapa nde wa Kristo, Mwana waka Chapanga, jola joahika pani pundema.” ");
INSERT INTO mpa_vpl VALUES ("JN11_28","073_11_28","JHN","11","28","28","Yesu paakajomwi kulongela ghanihagha, Masa akapiti kundoha Malia ndombu waki pandu pa kanjika, na kumpwaghila, “Mbola ahikike, na akulowa.” ");
INSERT INTO mpa_vpl VALUES ("JN11_29","073_11_29","JHN","11","29","29","Malia paakajowini, akajemiki manyata, na kujenda mbaka paakabhi Yesu. ");
INSERT INTO mpa_vpl VALUES ("JN11_30","073_11_30","JHN","11","30","30","Yesu akabhi ngacheahikiki mkati ja chijiji, nambu akabhi akali pandu pala Masa paakunjopalile. ");
INSERT INTO mpa_vpl VALUES ("JN11_31","073_11_31","JHN","11","31","31","Bhela Bhayahude bhabhabhi panyumba pala na Malia, bhakunjeghala mtima, pabhakumbweni Malia ntundu moakajemi manyata na kubhoka, bhakunjengalile. Koni bhakaholakya kubha ajenda kumatengeli nahuli alela konihoku. ");
INSERT INTO mpa_vpl VALUES ("JN11_32","073_11_32","JHN","11","32","32","Bhela Malia paakahikiki pandu pala paakabhi Yesu, na kumbona, akachikimi pamagholu ghaka Yesu, na kumpwaghila, “Bambo, ngati ukabhi pambane, mbeli wangu ngaakapotile!” ");
INSERT INTO mpa_vpl VALUES ("JN11_33","073_11_33","JHN","11","33","33","Yesu paakumbweni Malia alela, na Bhayahude bhaakalongini naku bhala nabhombi bhalela, Yesu ukambiniki mtima waki, na kung'ahakika muntima waki, ");
INSERT INTO mpa_vpl VALUES ("JN11_34","073_11_34","JHN","11","34","34","akapwaghike, “Bho, mumbekiki kwako?” Bhakumpwaghile, “Bambo, uhika ulingaje.” ");
INSERT INTO mpa_vpl VALUES ("JN11_35","073_11_35","JHN","11","35","35","Yesu akaleliki mahole. ");
INSERT INTO mpa_vpl VALUES ("JN11_36","073_11_36","JHN","11","36","36","Bhela Bhayahude bhakapwaghike, “Ndingalyaje ntundu moakumpali Lazalo!” ");
INSERT INTO mpa_vpl VALUES ("JN11_37","073_11_37","JHN","11","37","37","Nambu bhangi bhabhu bhakapwaghike, “Bho, hajoju joakamuyekwi mihu ngalola, ngacheakaweziki kuntenda na Lazalo ngayipotela?” ");
INSERT INTO mpa_vpl VALUES ("JN11_38","073_11_38","JHN","11","38","38","Bhela Yesu akabya kabhete umbina mtima waki, akahikiki palitengeli. Litengeli heli lakabhi likolo, na liganga lakabhi libhekakiki panani jaki. ");
INSERT INTO mpa_vpl VALUES ("JN11_39","073_11_39","JHN","11","39","39","Yesu akapwaghike, “Mulibhoha liganga!” Masa ndombu waka jola joapotile, akumpwaghile, “Bambo, kwa sajenu atumbwi kununga, kwa ndandi abhi ntuhi kwa machobha ncheche!” ");
INSERT INTO mpa_vpl VALUES ("JN11_40","073_11_40","JHN","11","40","40","Yesu akumpwaghile, “Bho, nepani ngachenukupwaghile kubha ngati anauhobhalela, anaubhona ulumbalilu waka Chapanga?” ");
INSERT INTO mpa_vpl VALUES ("JN11_41","073_11_41","JHN","11","41","41","Bhela bhakalibhohiki liganga lela. Na Yesu akalingalili kunani kumahunde, na kupwagha, “Atati, nukuchengula kwa ndandi unyowine. ");
INSERT INTO mpa_vpl VALUES ("JN11_42","073_11_42","JHN","11","42","42","Nanatu nakamanyi kubha wehapa unyowana machobha ghokapi, nambu kwa ndandi ja bhandu bhabhajemiki pambani nakapwaghiki ghanihagha, nahuli bhandu bhabhabhi pambane, bhapata kuhobhalela kubha wehapa nde weundumike.” ");
INSERT INTO mpa_vpl VALUES ("JN11_43","073_11_43","JHN","11","43","43","Najombi paakajomwili kulongela ghanihagha, Yesu akaleliki kwa sauti ngolongwa, “Lazalo, uhikaje koni kunja!” ");
INSERT INTO mpa_vpl VALUES ("JN11_44","073_11_44","JHN","11","44","44","Na jola joakapotile akapitiki kunja, koni akabya akongakiki sanda mumagholu na mumabhoku, na pamihu jaki. Yesu akabhapwaghile, “Mumbopulaje, na mundekaje ajendaje.” ");
INSERT INTO mpa_vpl VALUES ("JN11_45","073_11_45","JHN","11","45","45","Bhela Bhayahude bhamaheli bhabhakabhi bhahikiki kwaka Malia, na kughabhona mambu ghala ghaakahengiki Yesu, bhakunhobhalile. ");
INSERT INTO mpa_vpl VALUES ("JN11_46","073_11_46","JHN","11","46","46","Nambu bhakumu bhabhu bhakapiti kwa Mafalisayo, na kubhapwaghila mambu ghokapi ghaakahengiki Yesu. ");
INSERT INTO mpa_vpl VALUES ("JN11_47","073_11_47","JHN","11","47","47","Bhela ihongozi bha bhapenganyambiku papamu na Mafalisayo bhakahengiki uhimanganu wa Pachengu Pakolongwa pa Bhayahude, na kupwagha, “Bho, tuhenga kike? Maghambu mundu hajoju ahenga nginyulila yamaheli nakanopi! ");
INSERT INTO mpa_vpl VALUES ("JN11_48","073_11_48","JHN","11","48","48","Ngati anatundekiki ajendalya kuhenga bhenibhela, bhandu bhokapi anabhunhobhalyaje, na bhakolongwa bha Bhaloma anabhahikaje na kutubhokela pandu pitu na litaifa litu.” ");
INSERT INTO mpa_vpl VALUES ("JN11_49","073_11_49","JHN","11","49","49","Mundu jumu pachilanda jabhu, joalowakika Kayafa, joakabhi Mpenganyambiku Nkolongwa chaka chela, akabhapwaghile, “Mabhanganya ngachemulimanyi lilobhi lokapi lela! ");
INSERT INTO mpa_vpl VALUES ("JN11_50","073_11_50","JHN","11","50","50","Bho, ngachemuholalela kubha nde mbanga mundu jumu kupotela kwa ndandi ja bhandu bhokapi, kuliku bhandu bhokapi bha litaifa litu kuyonangeka?” ");
INSERT INTO mpa_vpl VALUES ("JN11_51","073_11_51","JHN","11","51","51","Ngacheakalongili ghanihagha kwa maholalelu ghaki mweni, nambu kwa ndandi akabhi Mpenganyambiku Nkolongwa chaka chela, akalotiki kubha Yesu anaapotilaje kwa ndandi ja litaifa la Bhayahude. ");
INSERT INTO mpa_vpl VALUES ("JN11_52","073_11_52","JHN","11","52","52","Wala nga kwa ndandi ja Bhayahude pela, nambu papamu na hagha abhabhonganaje bhana bhaka Chapanga bhabhapechangine, nahuli bhabya bhamu. ");
INSERT INTO mpa_vpl VALUES ("JN11_53","073_11_53","JHN","11","53","53","Bhela kutumbula lichobha lela ihongozi bha Bhayahude bhakajongini kunkoma Yesu. ");
INSERT INTO mpa_vpl VALUES ("JN11_54","073_11_54","JHN","11","54","54","Bhela Yesu ngacheakajendiki kabhete kwa palanga pachilanda ja Bhayahude, nambu akabhokiki konihoku, na kujenda pandu pambipi na lipololu, mbaka ku muchi ghoulowakeka Efulaimu, na kutama konihoku papamu na bhabhulwa bhaki. ");
INSERT INTO mpa_vpl VALUES ("JN11_55","073_11_55","JHN","11","55","55","Chikahi cha Uwangalalu wa Pasaka ja Bhayahude jakabhi jiheghalile, na bhandu bhamaheli bhakabhi bhakwela kuhuma kumighonda na kujenda ku Yelusalemu, nahuli kuligholola kwa ndandi ja kunjojabhela Chapanga mangani ja kuhika Pasaka. ");
INSERT INTO mpa_vpl VALUES ("JN11_56","073_11_56","JHN","11","56","56","Bhela bhakabhi bhundonda Yesu, bhakalaluhini koni bhakabya bhajemanile mu liwangala la Nyumba jaka Chapanga, “Bho, mbona bhole? Bho, ibhonikana kubha ngaahiki ng'o pauhangalalu ghone?” ");
INSERT INTO mpa_vpl VALUES ("JN11_57","073_11_57","JHN","11","57","57","Bhapenganyambiku bhakolongwa papanu na Mafalisayo bhakabhi bhabhohiki amuli ja kubha anangati mundu amanyi paabhi Yesu, aleta ubholu, nahuli bhapata kunkamula. ");
INSERT INTO mpa_vpl VALUES ("JN12_1","073_12_1","JHN","12","1","1","Machobha sita mangani ja Uwangalalu wa Pasaka, Yesu akapiti ku Besania, koatamika Lazalo ambaju Yesu akamuhyohiki kuhuma kwa bhakuwa. ");
INSERT INTO mpa_vpl VALUES ("JN12_2","073_12_2","JHN","12","2","2","Konihoku bhakumbeki chilebhi cha chimihi, najombi Masa akabhi abhatumakila. Lazalo akabhi jumu wa bhala bhabhakabhi bhakula papamu na Yesu. ");
INSERT INTO mpa_vpl VALUES ("JN12_3","073_12_3","JHN","12","3","3","Bhela Malia akatoliki nusu lita ja mahuta ghaghanungila wichu ghaghalenganakiki kwa nkongu wa nalido ja mbiya yamaheli, na kumpaka mumagholu ghaka Yesu na kunhungula kwa majunju ghaki. Nyumba jokapi jakatweli unungilu wa mahuta ghanihagha. ");
INSERT INTO mpa_vpl VALUES ("JN12_4","073_12_4","JHN","12","4","4","Henu Yuda Isikalioti, jumu wa bhabhulwa komi na bhabheli, jonihoju nde joanaang'anambuka Yesu, akapwaghike, ");
INSERT INTO mpa_vpl VALUES ("JN12_5","073_12_5","JHN","12","5","5","“Bho, maghambu kiki manungilu ghanihagha ngacheghakahemaliwi kwa ipandi mia tatu yeilenganakiki kwa madini gha feza, na mbija yene kubhapekeha bhahocho?” ");
INSERT INTO mpa_vpl VALUES ("JN12_6","073_12_6","JHN","12","6","6","Yuda akapwaghiki bhenibhela, nga kwa ndandi ja kubhabhonela chiha bhahocho, nambu kwa ndandi akabhi mwihi. Maghambu jombi nde joakabhi abheka mfuku wa mbija, najombi akabhi ajibha yela yeyabhekakiki monihomu. ");
INSERT INTO mpa_vpl VALUES ("JN12_7","073_12_7","JHN","12","7","7","Nambu Yesu akapwaghike, “Ngamung'aha mabhu hoju! Mundekaje aghabhekaje kwa ndandi ja lichobha la kutaghakika kwangu. ");
INSERT INTO mpa_vpl VALUES ("JN12_8","073_12_8","JHN","12","8","8","Kwa ndandi bhahocho mbinabhu machobha ghokapi, nambu ngankubhi na nepani machobha ghokapi.” ");
INSERT INTO mpa_vpl VALUES ("JN12_9","073_12_9","JHN","12","9","9","Bhayahude bhamaheli bhakajowini kubha Yesu akabhi ku Besania. Henu, bhakahikiki konihoku nga kwa ndandi ja kumbona Yesu pela, nambu bhumbona kabheti na Lazalo, ambaju Yesu akamuhyohiki kuhuma kwa bhakuwa. ");
INSERT INTO mpa_vpl VALUES ("JN12_10","073_12_10","JHN","12","10","10","Nambu ihongozi bha bhapenganyambiku bhakatendiki njama ja kunkoma kabhete Lazalo, ");
INSERT INTO mpa_vpl VALUES ("JN12_11","073_12_11","JHN","12","11","11","maghambu kwa ndandi jaki Bhayahude bhamaheli bhakabhakaniki ihongozi bhabhu, na kunhobhale Yesu. ");
INSERT INTO mpa_vpl VALUES ("JN12_12","073_12_12","JHN","12","12","12","Chilabhu jaki lipogha la bhandu bhabhakahikiki kwa ndandi ja Uwangalalu wa Pasaka, bhakajowini kubha Yesu abhi mwindela kuhika ku Yelusalemu. ");
INSERT INTO mpa_vpl VALUES ("JN12_13","073_12_13","JHN","12","13","13","Bhela bhakatoliki mambandi gha mikongu ja mitende, na kujenda kumpengana, na kujamalila bhakapwaghaje, “Chapanga apengalikaje! Apengalika jonihoju joahika kwa lihina laka Bambo! Apengalikaje Nkolongwa wa Izilaeli!” ");
INSERT INTO mpa_vpl VALUES ("JN12_14","073_12_14","JHN","12","14","14","Yesu akapatiki mwanaliponda jumu, na kukwela na kutama panani jaki, ngati moghalembakike mu Malembelu Mahuhu, ");
INSERT INTO mpa_vpl VALUES ("JN12_15","073_12_15","JHN","12","15","15","“Ngamwijoghopa bhandu bha muchi wa Sayuni! Lingalyaje, Nkolongwa waku ahika, akweliki mwanaliponda.” ");
INSERT INTO mpa_vpl VALUES ("JN12_16","073_12_16","JHN","12","16","16","Bhabhulwa bhaka Yesu ngachebhakamanyi mambu ghanihagha hoti, nambu Yesu paakahyokike kuhuma kwa bhakuwa na paakalumbaliki, panihapa nde bhabhulwa bhaki bhakakombwiki kubha mambu ghanihagha ghakabhi ghalembakiki kwa ndandi jaki, na kubha bhakuntendi jombi. ");
INSERT INTO mpa_vpl VALUES ("JN12_17","073_12_17","JHN","12","17","17","Lipogha la bhandu bhala bhabhakabhi papamu na Yesu chikahi paandohika Lazalo kuhuma mulitengeli, na kumuhyoha kuhuma kwa bhakuwa, bhakabhalandi bhandu mambu ghala ghaghapitalile. ");
INSERT INTO mpa_vpl VALUES ("JN12_18","073_12_18","JHN","12","18","18","Kwa ndandi jeniheji lipogha la bhandu lakapiti kumpengana, maghambu bhakajowini kubha Yesu akahengiki ngangachu jeniheji. ");
INSERT INTO mpa_vpl VALUES ("JN12_19","073_12_19","JHN","12","19","19","Bhela Mafalisayo pabhakaghaweni ghanihagha bhakapwaghanile, “Mbona? Bho, ngatuwezi kutenda chokapi? Lingalyaje, bhandu bhokapi pundema bhunjengale jombi.” ");
INSERT INTO mpa_vpl VALUES ("JN12_20","073_12_20","JHN","12","20","20","Kukabhi na Bhagiliki bhakumu pachilanda ja bhala bhabhahikiki ku Yelusalemu kujojabhela chikahi cha Uwangalalu wa Pasaka. ");
INSERT INTO mpa_vpl VALUES ("JN12_21","073_12_21","JHN","12","21","21","Bhanihabha bhakunjendi Filipo, mwenehi wa ku Betisaida ja inchi ja ku Galilaya, na kundobha, bhakapwaghaje, “Nkolongwa, tepani tupala kumbona Yesu.” ");
INSERT INTO mpa_vpl VALUES ("JN12_22","073_12_22","JHN","12","22","22","Filipo akapiti kumpwaghi Andulea, kabheti Andulea na Filipo bhakumpwaghi Yesu. ");
INSERT INTO mpa_vpl VALUES ("JN12_23","073_12_23","JHN","12","23","23","Yesu akabhayangike, “Lisaa la kulumbalika kwaka Mwana waka Mundu lihikike! ");
INSERT INTO mpa_vpl VALUES ("JN12_24","073_12_24","JHN","12","24","24","Numpwaghi chakaka, imbeju ya ingano nangakuhabhuka paluhombi na kuwa, ihighalila ngati imbeju kanjika jaki. Nambu ngati anaihawiki pahi na kuwa, jibheleka imbeju yamaheli. ");
INSERT INTO mpa_vpl VALUES ("JN12_25","073_12_25","JHN","12","25","25","Mundu jokapi joaghapala matamu ghaki anaaghahobhihaje, na mundu jokapi joaghahobheha matamu ghaki mu ndema ghoni anaaghakengalyaje hata womi wa mileli. ");
INSERT INTO mpa_vpl VALUES ("JN12_26","073_12_26","JHN","12","26","26","Mundu jokapi joapala kundumakila, impalika anyengalyaje, na nepani pamili, panihapa nde na mtumika wangu payibyaje. Kabheti mundu jokapi joandumakila nepani, Atati wangu anaampekya utopelu. ");
INSERT INTO mpa_vpl VALUES ("JN12_27","073_12_27","JHN","12","27","27","“Sajenu roho jangu jing'ahika, bho, henu mbwagha kike? ‘Atati, ungengalyaje mu chikahi chenu!’ Nambu nde kwa ndandi ja ghanihagha nakahikiki nahuli naghapetilaje mang'ahiku gha chikahi chenu. ");
INSERT INTO mpa_vpl VALUES ("JN12_28","073_12_28","JHN","12","28","28","Atati ulilumbalyaje lihina laku!” Panihapa sauti kuhuma kunani kumahunde jakapwaghike, “Nililumbalile, na ananililumbalya kabhete.” ");
INSERT INTO mpa_vpl VALUES ("JN12_29","073_12_29","JHN","12","29","29","Lipogha la bhandu bhabhakabhi pandu pala bhakajowini sauti jela, na bhakumu bhabhu bhakapwaghike, “Jeniheji nde sauti ja kulundamila kwa chitobhi.” Nambu bhangi bhakapwaghiki, “Mtumika wa kunani kwaka Chapanga atehi kulongela naku!” ");
INSERT INTO mpa_vpl VALUES ("JN12_30","073_12_30","JHN","12","30","30","Nambu Yesu akabhayangiki, “Sauti jeniheji ngachejabhili kwa ndandi jangu nepani, nambu kwa ndandi jinu mwehapa. ");
INSERT INTO mpa_vpl VALUES ("JN12_31","073_12_31","JHN","12","31","31","Sajenu nde chikahi cha kutemuliwa kwa ndema ghoni, henu Shetani, nkolongwa wa ndema ghoni anaalekalikaje kunja. ");
INSERT INTO mpa_vpl VALUES ("JN12_32","073_12_32","JHN","12","32","32","Nambu nepani panikwehakikaje kunani kuhuma pundema, ananabhahutaje bhandu bhokapi bhahikaje kwangu.” ");
INSERT INTO mpa_vpl VALUES ("JN12_33","073_12_33","JHN","12","33","33","Yesu akapwaghiki ghanihagha akalangiya kubha anapotilaje kwa ntundu bhole. ");
INSERT INTO mpa_vpl VALUES ("JN12_34","073_12_34","JHN","12","34","34","Bhela lipogha la bhandu lela lakalapwili njobhela lakapwaghaje, “Tujowini mu Shelia jitu kubha Kristo anatama mileli. Bho, uweza bholi henu kupwagha kubha impalika Mwana waka Mundu kujinuliwa kunani? Bho, henu Mwana waka Mundu nde nane?” ");
INSERT INTO mpa_vpl VALUES ("JN12_35","073_12_35","JHN","12","35","35","Yesu akapwaghike, “Unang'anu wakona ubhi na mwehapa kwa chikahi kichokope. Njendaje koni mbili na unang'anu, nahuli lwihi ngalwampata, maghambu joajenda mulwihi ngacheamanya koajenda. ");
INSERT INTO mpa_vpl VALUES ("JN12_36","073_12_36","JHN","12","36","36","Bhela kwa ndandi mbili na unang'anu, muuhobhalyaje unang'anu hoghu, nahuli mpata kubha mabhana bha unang'anu.” Paakajomwi kulonge ghanihagha, Yesu akabhokike, na kulihiya nahuli ngabhumbona. ");
INSERT INTO mpa_vpl VALUES ("JN12_37","073_12_37","JHN","12","37","37","Nambu Yesu papamu na kutenda ngangachu hayeyi yokapi palongi jabhu, bhombi ngachebhunhobhalile. ");
INSERT INTO mpa_vpl VALUES ("JN12_38","073_12_38","JHN","12","38","38","Nahuli ghapata kupitalila malobhi ghaakapwaghiki mlota Isaya, “Bambo, bho, nde nane joakauhobhalile ubholu wito? Na bho, nde nane joayekuliwi makili ghaka Bambo?” ");
INSERT INTO mpa_vpl VALUES ("JN12_39","073_12_39","JHN","12","39","39","Ndemana bhombi ngachebhahobhalile, kwa ndandi Isaya akapwaghiki kabhete, ");
INSERT INTO mpa_vpl VALUES ("JN12_40","073_12_40","JHN","12","40","40","“Chapanga abhatendiki akangalola, ajitendiki kunonopa mitima jabhu, ngabhilola kwa mihu ghabhu, ngabhimanya kwa mitima jabhu, wala ngabhing'anambuka, nahuli mbata kubhalamiha, apwagha Bambo.” ");
INSERT INTO mpa_vpl VALUES ("JN12_41","073_12_41","JHN","12","41","41","Mlota Isaya akapwaghiki malobhi ghanihagha kwa ndandi akauweni ulumbalilu waka Yesu, na akapwaghiki malobhi ghaki. ");
INSERT INTO mpa_vpl VALUES ("JN12_42","073_12_42","JHN","12","42","42","Hata bhela, bhamaheli pachilanda ja ihongozi bha Bhayahude bhakunhobhali Yesu. Nambu kwa ndandi ja Mafalisayo, ngachebhakapwaghiki palanga, kwa kujoghopa kubhatopola mu nyumba ya kuhimangani Bhayahude. ");
INSERT INTO mpa_vpl VALUES ("JN12_43","073_12_43","JHN","12","43","43","Kwa ndandi bhombi bhakapaliki ulumbalilu wa bhandu kuliku ulumbalilu waka Chapanga. ");
INSERT INTO mpa_vpl VALUES ("JN12_44","073_12_44","JHN","12","44","44","Yesu akajamalila kwa sauti ngolongwa, akapwaghaje, “Mundu joanhobhalela nepani, ngacheanhobhale nepani pela, nambu bhelabhela anhobhalela jola joandumike. ");
INSERT INTO mpa_vpl VALUES ("JN12_45","073_12_45","JHN","12","45","45","Na jola joaningali nepani andingali jola joandumike. ");
INSERT INTO mpa_vpl VALUES ("JN12_46","073_12_46","JHN","12","46","46","Nepani nhikiki nahuli mya unang'anu wa pundema, nahuli kila mundu joanhobhale nepani ngayitama mulwihi. ");
INSERT INTO mpa_vpl VALUES ("JN12_47","073_12_47","JHN","12","47","47","Na ngati mundu anaaghajowini malobhi ghangu, nambu ngacheaghakamula, nepani ngachenuntemula. Maghambu ngachenhikiki kuutemula ndema, nambu kuukengalela ndema. ");
INSERT INTO mpa_vpl VALUES ("JN12_48","073_12_48","JHN","12","48","48","Mundu joangana nepani, jwangakughahobhalela malobhi ghangu, abhi na wa kuntemula. Lilobhi heli lenilipwaghiki nde lelantemulaje mu lichobha la kujomukela. ");
INSERT INTO mpa_vpl VALUES ("JN12_49","073_12_49","JHN","12","49","49","Maghambu nepani ngachenapwaghiki kwa ndandi ja lujiniku lwangu, nambu Atati joandumiki, nde joanaghalakili cha kupwagha na ntundu monipwaghilaje. ");
INSERT INTO mpa_vpl VALUES ("JN12_50","073_12_50","JHN","12","50","50","Nanatu manyi kubha amuli yaki ileta womi wa mileli. Bhela nepani nongela malobhi ghala pela ghaanaghalakili Atati.” ");
INSERT INTO mpa_vpl VALUES ("JN13_1","073_13_1","JHN","13","1","1","Bhela, mangani ja lichobha la Uwangalalu wa Pasaka. Yesu akamanyi kubha chikahi chaki cha kubhoka pundema na kujenda kwa Atati waki chakabhi chihikike, akabhi abhapaliki bhandu bhaki bhabhabhi pundema, akabhapaliki mbaka pakujomukela. ");
INSERT INTO mpa_vpl VALUES ("JN13_2","073_13_2","JHN","13","2","2","Henu Yesu na bhabhulwa bhaki bhakabhi bhatemi kula chilebhi cha chimihi. Shetani akajomwi kunjeghela Yuda, mwana waka Simoni Isikalioti, maholalelu gha kung'anambuka Yesu. ");
INSERT INTO mpa_vpl VALUES ("JN13_3","073_13_3","JHN","13","3","3","Yesu akamanyi kubha Atati abhekiki hindu yokapi mu makili ghaki, na kubha jombi akahumiki kwaka Chapanga, na akelabhuka kwaka Chapanga, ");
INSERT INTO mpa_vpl VALUES ("JN13_4","073_13_4","JHN","13","4","4","akabhokiki pachilebhi, na kubhoha ingobhu jaki ja kunja na kubheka punkeghi, akatoliki chitambala, na kulikonga muchibhunu. ");
INSERT INTO mpa_vpl VALUES ("JN13_5","073_13_5","JHN","13","5","5","Panihapa akajeghi machi mu likalahi, na kutumbu kubhagholola bhabhulwa bhaki magholu, na kughahungula kwa chitambala chela cheakakongiki muchihunu. ");
INSERT INTO mpa_vpl VALUES ("JN13_6","073_13_6","JHN","13","6","6","Paakahikiki kwaka Simoni Petulu, Petulu akapwaghike, “Bambo, bho, wehapa anaung'olula nepani magholu?” ");
INSERT INTO mpa_vpl VALUES ("JN13_7","073_13_7","JHN","13","7","7","Yesu akamuyangiki, “Chendenda sajenu ngauchimanye, nambu anauchimanya palonge.” ");
INSERT INTO mpa_vpl VALUES ("JN13_8","073_13_8","JHN","13","8","8","Petulu akumpwaghile, “Wehapa ngaung'ololi nepani magholu ng'o!” Yesu akamuyangike, “Ngati nganukughololi magholu, wehapa ngaukubhi wa mbulwa wangu.” ");
INSERT INTO mpa_vpl VALUES ("JN13_9","073_13_9","JHN","13","9","9","Simoni Petulu akamuyangike, “Bambo, ung'olulaje, nga magholu pela, nambu papamu na mabhoku ghangu na mmutu wangu bhelabhela!” ");
INSERT INTO mpa_vpl VALUES ("JN13_10","073_13_10","JHN","13","10","10","Yesu akumpwaghile, “Mundu joajomwi kujogha hyegha jokapi apalika kugholola magholu pela, maghambu ajomwi kunyamba hyegha jokapi. Mwehapa mnyambike, nambu nga mabhokape.” ");
INSERT INTO mpa_vpl VALUES ("JN13_11","073_13_11","JHN","13","11","11","Yesu akamanyi jola joanaang'anambukaje, nde ndandi akapwaghiki, “Mwehapa mnyambike, nambu nga mabhokape.” ");
INSERT INTO mpa_vpl VALUES ("JN13_12","073_13_12","JHN","13","12","12","Yesu paakajomwi kubhagholola magholu bhabhulwa bhaki, akawatiki kabhete ingobhu jaki ja kunja na kukelabhuka na kutama kabhete, na kubhalalukila, “Bho, mmanyi ghanuntendile?” ");
INSERT INTO mpa_vpl VALUES ("JN13_13","073_13_13","JHN","13","13","13","“Mwehapa mnoha Mbola na Bambo, nanamu mpwagha wichu, maghambu nde momelile. ");
INSERT INTO mpa_vpl VALUES ("JN13_14","073_13_14","JHN","13","14","14","Henu anakubhi nepani, nemi Bambo winu na Mbola winu, nungolwili mwehapa magholu, impalika na mwehapa kugholulana magholu mabheti kwa mabheti. ");
INSERT INTO mpa_vpl VALUES ("JN13_15","073_13_15","JHN","13","15","15","Kwa ndandi nepani numpeki ulenganesu, nahuli na mwehapa mtendaje ngati nepani monuntendile. ");
INSERT INTO mpa_vpl VALUES ("JN13_16","073_13_16","JHN","13","16","16","Numpwaghi Chakaka, mtumika nga nkolongwa kumpeta bambo waki, wala mtumi nga nkolongwa kumpeta jola joantumike. ");
INSERT INTO mpa_vpl VALUES ("JN13_17","073_13_17","JHN","13","17","17","Anamughamanyi mambu ghanihagha, mbanga kwinu mwehapa ngati anamughatendike. ");
INSERT INTO mpa_vpl VALUES ("JN13_18","073_13_18","JHN","13","18","18","“Ngachembwagha kwinu mwehapa mabhokapi. Nepani nabhamanyi bhala bhanabhahawile. Nambu nahuli ghapitalyaje Malembu Mahuhu ghaghapwagha, ‘Jola joakuliki chilebhi changu, atehi kuning'anambuka.’ ");
INSERT INTO mpa_vpl VALUES ("JN13_19","073_13_19","JHN","13","19","19","Nepani numpwaghili mambu ghanihagha sajenu mangani ngacheghapitalile, nahuli paghipitalyaje, mpata kuhobhalela kubha ‘Nepani nde Jombi.’ ");
INSERT INTO mpa_vpl VALUES ("JN13_20","073_13_20","JHN","13","20","20","Numpwaghi Chakaka, mundu jokapi joanjopalela mundu jola jonumtumiki, anyopalela nepane. Na mundu jokapi joanyopalela nepane, anjopalela jombi joandumiki nepane.” ");
INSERT INTO mpa_vpl VALUES ("JN13_21","073_13_21","JHN","13","21","21","Yesu paakajomwili kupwagha ghanihagha, akang'ahakiki mu roho jaki, akalandili hotuhotu, “Chakaka numpwaghila, jumu winu anaang'anambukaje.” ");
INSERT INTO mpa_vpl VALUES ("JN13_22","073_13_22","JHN","13","22","22","Bhabhulwa bhaki bhakalingalanili bheni kwa bheni, koni ngachebhamanyi kubha nde nane joandongalela. ");
INSERT INTO mpa_vpl VALUES ("JN13_23","073_13_23","JHN","13","23","23","Jumu wa bhabhulwa bhaki, ambaju Yesu akabhi ampala nakanopi, akabhi ajeghamakili pachihimba chaka Yesu. ");
INSERT INTO mpa_vpl VALUES ("JN13_24","073_13_24","JHN","13","24","24","Bhela Simoni Petulu akumpongi mbulwa jola chiwoku chaki, na kumpwaghila, “Undalukyaje, bho, ampwagha nane?” ");
INSERT INTO mpa_vpl VALUES ("JN13_25","073_13_25","JHN","13","25","25","Mbulwa hoju koni akabya ajeghamaki pachihimba chaka Yesu, akundalukile, “Bambo, bho, nde nane?” ");
INSERT INTO mpa_vpl VALUES ("JN13_26","073_13_26","JHN","13","26","26","Yesu akayangike, “Nde mundu jola jonampekyaje chipandi cha libumunda. Akatobhalili libumunda heli mumbale, na kumpekeha Yuda, mwana waka Simoni Isikalioti.” ");
INSERT INTO mpa_vpl VALUES ("JN13_27","073_13_27","JHN","13","27","27","Yuda paakajomwi kujopa chipandi cha libumunda heli, Shetani akunjingile. Bhela Yesu akumpwaghile, “Cheupala kuchihenga, uchihenga manyata!” ");
INSERT INTO mpa_vpl VALUES ("JN13_28","073_13_28","JHN","13","28","28","Wala nga mundu hata jumu wa bhala bhabhakabhi bhatemi pachilebhi joakamanyi ndandi kiki Yesu akumpwaghi bhenibhela. ");
INSERT INTO mpa_vpl VALUES ("JN13_29","073_13_29","JHN","13","29","29","Kwa kubha Yuda akabhi mbeka mbija, bhangi bhakaholali kubha Yesu akabhi ampwaghi akahemalaje hindu yeipalika kwa ndandi ja Uwangalalu wa Pasaka, au abhapekya bhahocho chokapi. ");
INSERT INTO mpa_vpl VALUES ("JN13_30","073_13_30","JHN","13","30","30","Yuda paakajomwi kujopa chipandi cha libumunda chela, palapala akapitiki kunja. Chikahi hechi kukabhi ikilu. ");
INSERT INTO mpa_vpl VALUES ("JN13_31","073_13_31","JHN","13","31","31","Bhela Yuda paakajomwi kupita kunja, Yesu akapwaghike, “Sajenu Mwana waka Mundu alumbalike, najombi Chapanga alumbaliki mkati jaki. ");
INSERT INTO mpa_vpl VALUES ("JN13_32","073_13_32","JHN","13","32","32","Ngati Chapanga alumbaliki mkati jaka Mwana, Chapanga anaandumbalyaje Mwana mkati jaki mweni bhelabhela, najombi ngaakabhakile kundumbalila henu kateki. ");
INSERT INTO mpa_vpl VALUES ("JN13_33","073_13_33","JHN","13","33","33","Bhana bhango, chakona chikahi kichokopi mili na mwehapa. Anamunondaje nepani, na ngati monakabhapwaghile ihongozi bha Bhayahude kubha, ‘Nepani konyenda mwehapa ngamuwezi kuhika, bhelabhela sajenu numpwaghi mwehapa.’ ");
INSERT INTO mpa_vpl VALUES ("JN13_34","073_13_34","JHN","13","34","34","Amuli jahenu numpekeha: Mpalanaje. Mpalanaje ngati nepani monumpali mwehapa. ");
INSERT INTO mpa_vpl VALUES ("JN13_35","073_13_35","JHN","13","35","35","Ngati anampalana mabheti kwa mabheti, bhandu bhokapi anabhamanyaje kubha mwehapa nde bhabhulwa bhangu.” ");
INSERT INTO mpa_vpl VALUES ("JN13_36","073_13_36","JHN","13","36","36","Simoni Petulu akundalukile, “Bambo, bho, ujenda kwako?” Yesu akamuyangike, “Konyenda ngauwezi kunyengale sajenu, nambu anaunyengalyaje palongi.” ");
INSERT INTO mpa_vpl VALUES ("JN13_37","073_13_37","JHN","13","37","37","Petulu akundalukili kabhete, “Bambo, bho, maghambu kiki nepani nganiweza kukujengale sajenu? Nepani mi tayali kuubhoha womi wangu kwa ndandi jaku!” ");
INSERT INTO mpa_vpl VALUES ("JN13_38","073_13_38","JHN","13","38","38","Yesu akayangike, “Bho, chakaka le kubha wehapa anaubhoha womi waku kwa ndandi jangu? Chakaka nukupwaghila, mangani ja likongobhi ngachelibhekiki anaunganaje mala patatu.” ");
INSERT INTO mpa_vpl VALUES ("JN14_1","073_14_1","JHN","14","1","1","Yesu akabhapwaghile, “Ngamwikubha na choghohi mumitima jinu, munhobhale Chapanga, mnihobhalya na nepani bhelabhela. ");
INSERT INTO mpa_vpl VALUES ("JN14_2","073_14_2","JHN","14","2","2","Munyumba ja Atati wangu kubhi na matamu ghamaheli, ikabhi ngabhela, nakabya numpwaghile. Ndandi nyenda kunhandalila matamu. ");
INSERT INTO mpa_vpl VALUES ("JN14_3","073_14_3","JHN","14","3","3","Ngati anambiti na kunhandalila matamu, ananhika kabhete, na kuntola mwehapa kwangu, nahuli pandu pamili nepani, na mwehapa mbyaje. ");
INSERT INTO mpa_vpl VALUES ("JN14_4","073_14_4","JHN","14","4","4","Konyenda mukumanye, na indela mujimanye.” ");
INSERT INTO mpa_vpl VALUES ("JN14_5","073_14_5","JHN","14","5","5","Tomaso akundalukile, “Bambo, tepani ngachetumanyi koujenda, bho, anatuweza bhole kujimanya indela?” ");
INSERT INTO mpa_vpl VALUES ("JN14_6","073_14_6","JHN","14","6","6","Yesu akayangike, “Nepani nde indela, chakaka na womi. Mundu ngacheaweza kuhika kwa Atati, nambu kwa kupetela kwangu nepani. ");
INSERT INTO mpa_vpl VALUES ("JN14_7","073_14_7","JHN","14","7","7","Ngati mkabhili mmanyi nepani, mkabya mummanyi na Atati wangu. Kutumbula sajenu mummanye, na kabhete mumbwene.” ");
INSERT INTO mpa_vpl VALUES ("JN14_8","073_14_8","JHN","14","8","8","Filipo akumpwaghile, “Bambo, utulangihaje Atati, chenihechi nde chetukipala.” ");
INSERT INTO mpa_vpl VALUES ("JN14_9","073_14_9","JHN","14","9","9","Yesu akayangike, “Filipo, ndemi na mwehapa kwa machobha ghamaheli, bho, nanau ngacheunimanye? Mundu jokapi joamweni nepani, ambweni Atati. Bho, henu wehapa uweza bhole kupwagha, ‘Utulangihaje Atati?’ ");
INSERT INTO mpa_vpl VALUES ("JN14_10","073_14_10","JHN","14","10","10","Bho, ngacheuhobhalela kubha nepani mi mkati ja Atati, na Atati abhi mkati jangu nepane? Malobhi ghanumpwaghila ngachembwagha kwa ndandi jangu namwete, nambu Atati joatama mkati jangu, aghatenda mahengu ghake. ");
INSERT INTO mpa_vpl VALUES ("JN14_11","073_14_11","JHN","14","11","11","Mnihobhalyaje pambwagha kubha nepani mi mkati ja Atati, na Atati abhi mkati jangu nepani! Nangabhela muhobhalyaje kwa ndandi ja mahengu ghala ghanaghatenda. ");
INSERT INTO mpa_vpl VALUES ("JN14_12","073_14_12","JHN","14","12","12","Numpwaghila Chakaka, jokapi joanhobhalela nepani, mahengu ghanaghahenga nepani, najombi anaaghahengaje. Ena, na mahengu makolongwa nakanopi kupeta ghanihagha anahengaje, kwa ndandi nepani nyenda kwa Atati. ");
INSERT INTO mpa_vpl VALUES ("JN14_13","073_14_13","JHN","14","13","13","Chokapi chemwilobhaje kwa lihina langu, anandendaje, nahuli Atati alumbalikaje mkati jaka Mwana. ");
INSERT INTO mpa_vpl VALUES ("JN14_14","073_14_14","JHN","14","14","14","Anandobhiki chindu chokapi kupetela lihina langu, anandendaje. ");
INSERT INTO mpa_vpl VALUES ("JN14_15","073_14_15","JHN","14","15","15","“Ngati anambala nepani, anankamulaje amuli yangu. ");
INSERT INTO mpa_vpl VALUES ("JN14_16","073_14_16","JHN","14","16","16","Nanatu ananundobhaje Atati, najombi anaampekyaje Mjangatila najongi, nahuli atamaje na mwehapa mileli. ");
INSERT INTO mpa_vpl VALUES ("JN14_17","073_14_17","JHN","14","17","17","Jombi nde Roho wa chakaka. Ambaju bhandu bha pundema ngabhawezi kunjopalela, kwa ndandi ngachebhumbona, wala ngachebhummanye. Nambu mwehapa anamummanyaje, kwa ndandi atama kwinu, najombi anaakubhaje mkati jinu. ");
INSERT INTO mpa_vpl VALUES ("JN14_18","073_14_18","JHN","14","18","18","“Nganundeki mwehapa ngati bhakebha, ananhika kabheti kwinu. ");
INSERT INTO mpa_vpl VALUES ("JN14_19","073_14_19","JHN","14","19","19","Chakona chikahi kichokopi, bhandu bha pundema ngabhimoni kabhete, nambu mwehapa anammonaje. Kwa ndandi nepani mi mwomi, na mwehapa anamkubha bhomi. ");
INSERT INTO mpa_vpl VALUES ("JN14_20","073_14_20","JHN","14","20","20","Lichobha lela palihikaje, mwehapa anammanyaje kubha nepani mi mkati ja Atati wangu, na mwehapa mkati jangu, na nepani mkati jinu. ");
INSERT INTO mpa_vpl VALUES ("JN14_21","073_14_21","JHN","14","21","21","“Mundu jola joabhi na amuli yangu na kuikamula, jonihoju nde joambala nepani. Najombi joambala nepani, anaapalakikaje na Atati wangu, na nepani ananumpalaje, na kulilangiha kwaki.” ");
INSERT INTO mpa_vpl VALUES ("JN14_22","073_14_22","JHN","14","22","22","Panihapa Yuda, nga jola Yuda Isikalioti, akumpwaghile, “Bambo, bho, kubhi bhole wehapa upala kulilangiha kwitu, na wala nga kwa bhandu bha pundema?” ");
INSERT INTO mpa_vpl VALUES ("JN14_23","073_14_23","JHN","14","23","23","Yesu akayangike, “Mundu jokapi joambala nepani, anaakamulaje malobhi ghangu, na Atati wangu anaampalaje, nepani na Atati wangu anatuhikaje kwaki, na kuhenga matamu kwaki. ");
INSERT INTO mpa_vpl VALUES ("JN14_24","073_14_24","JHN","14","24","24","Mundu jokapi jwangakumbala nepani, ngacheaghakamula malobhi ghangu. Na malobhi ghamughajowana nga ghangu, nambu ghahumiki kwa Atati joandumike.” ");
INSERT INTO mpa_vpl VALUES ("JN14_25","073_14_25","JHN","14","25","25","“Mambu ghanihagha nde ghanakumpwaghile, chikahi panakabhi ndama papamu na mwehapa. ");
INSERT INTO mpa_vpl VALUES ("JN14_26","073_14_26","JHN","14","26","26","Mjangatila hoju, nde Roho Mhuhu, ambaju Atati anaantumaje kupetela lihina langu, anaambolaje mambu ghokapi, na kunkombosha mambu ghokapi ghanumpwaghile.” ");
INSERT INTO mpa_vpl VALUES ("JN14_27","073_14_27","JHN","14","27","27","“Lukwale nundekela, lukwale lwangu numpekeha. Monumpeke nepani, nga ngati bhandu bha pundema mobhumpekeha. Ngamwing'ahika mumitima jinu, wala ngamwijoghopa. ");
INSERT INTO mpa_vpl VALUES ("JN14_28","073_14_28","JHN","14","28","28","Mkajowini kubha nepani nakumpwaghile, ‘Nyenda, na ananhika kabheti kwinu.’ Ngati mkabhi mbala, mkabya muhekalile, kwa ndandi nyenda kwa Atati, maghambu Atati nde nkolongwa kupeta nepani. ");
INSERT INTO mpa_vpl VALUES ("JN14_29","073_14_29","JHN","14","29","29","Numpwaghi mambu ghanihagha sajenu mangani ngacheghapitalile, nahuli paghipitalyaje mpata kuhobhalela. ");
INSERT INTO mpa_vpl VALUES ("JN14_30","073_14_30","JHN","14","30","30","Nepani nganongeli na mwehapa malobhi ghamaheli kabhete, maghambu Shetani, nkolongwa wa ndema ghoni ahika, nambu jonihoju ngacheabhi na chindu kwangu, ");
INSERT INTO mpa_vpl VALUES ("JN14_31","073_14_31","JHN","14","31","31","nambu bhandu bha pundema bhapata kumanya kubha numpala Atati. Ngati bhela Atati moanaghalakile, bhenibhela nde monhengela.” Haya njemanyaje, na tujendaje. ");
INSERT INTO mpa_vpl VALUES ("JN15_1","073_15_1","JHN","15","1","1","“Nepani nde mzabibu wa chakaka, na Atati wangu nde ndeme. ");
INSERT INTO mpa_vpl VALUES ("JN15_2","073_15_2","JHN","15","2","2","Kila limbandi mkati jangu langakupambika mapambiku, Atati wangu aliheketa. Na kila limbandi lelipambika mapambiku, Atati wangu alikulaghalila, nahuli lipambikaje mapambiku nakanopi. ");
INSERT INTO mpa_vpl VALUES ("JN15_3","073_15_3","JHN","15","3","3","Sajenu mwehapa njomwi kubha mwanyahi kwa ndandi ja malobhi ghala ghanakumpwaghile. ");
INSERT INTO mpa_vpl VALUES ("JN15_4","073_15_4","JHN","15","4","4","Mtamaje mkati jangu, na nepani mkati jinu. Ngati bhela limbandi molilepalela kupambika mapambiku kanjika jaki, nangakutama mkati ja mzabibu, bhelabhela na mwehapa ngamuwezi kupambika mapambiku, nangakutama mkati jangu.” ");
INSERT INTO mpa_vpl VALUES ("JN15_5","073_15_5","JHN","15","5","5","“Nepani nde mzabibu, na mwehapa nde mambandi. Joatama mkati jangu, na nepani mkati jaki, jonihoju apambika mapambiku nakanopi. Maghambu panga kubha nepani, mwehapa ngamuwezi kutenda chindu chokapi. ");
INSERT INTO mpa_vpl VALUES ("JN15_6","073_15_6","JHN","15","6","6","Mundu jokapi jwangakutama mkati jangu, anaalekalikaje kunja ngati limbandi na kunyala. Na bhandu anabhabhonganaje, na kughalekela pamoto, na kutinyika. ");
INSERT INTO mpa_vpl VALUES ("JN15_7","073_15_7","JHN","15","7","7","Ngati mwehapa anantami mkati jangu, na malobhi ghangu anaghatemi mkati jinu, ndobhaje chokapi chemchipala nanamu anampataje. ");
INSERT INTO mpa_vpl VALUES ("JN15_8","073_15_8","JHN","15","8","8","Bhela alumbalikaje Atati wangu, kwa bhela mompambaki mapambiku nakanopi, na kwa indela jeniheji anambya bhabhulwa bhangu. ");
INSERT INTO mpa_vpl VALUES ("JN15_9","073_15_9","JHN","15","9","9","Ngati Atati moambali nepani, nanatu monumpali mwehapa. Njendalyaje kutama mu upalu wangu. ");
INSERT INTO mpa_vpl VALUES ("JN15_10","073_15_10","JHN","15","10","10","Ngati anamkamwili amuli yangu, anamtamaje mu upalu wangu, ngati bhela nepani monikamulile amuli ya Atati wangu, na kutama mu upalu waki. ");
INSERT INTO mpa_vpl VALUES ("JN15_11","073_15_11","JHN","15","11","11","“Numpwaghili mambu ghanihagha, nahuli chiheku changu chibya mkati jinu, na chiheku chinu chikubhaje kamili. ");
INSERT INTO mpa_vpl VALUES ("JN15_12","073_15_12","JHN","15","12","12","Amuli jangu nde ajeji: Mpalanaye ngati nepani monumpali mwehapa. ");
INSERT INTO mpa_vpl VALUES ("JN15_13","073_15_13","JHN","15","13","13","Njeta mundu joabhi na upalu ukolongwa kupeta ghongone, mundu kuubhoha womi waki kwa ndandi ja bhakochi bhaki. ");
INSERT INTO mpa_vpl VALUES ("JN15_14","073_15_14","JHN","15","14","14","Mwehapa mbi bhakochi bhangu, ngati anantendiki ghanundaghalakile. ");
INSERT INTO mpa_vpl VALUES ("JN15_15","073_15_15","JHN","15","15","15","Nganundohi bhatumika kabhete, kwa ndandi mtumika ngacheamanya cheatenda bambo waki. Nambu mwehapa nundohiki bhakochi bhangu, maghambu numpwaghi mambu ghokapi ghanyowini kwa Atati wangu. ");
INSERT INTO mpa_vpl VALUES ("JN15_16","073_15_16","JHN","15","16","16","Nga mwehapa mwemunhawili nepani, nambu nepani nde nenunhawili mwehapa, nanatu numbekiki njenda mkapambikaje mapambiku, na mapambiku ghinu ghapataje kutamakila, nahuli lokapi lemundobha Atati kupetela lihina langu, ampekyaje. ");
INSERT INTO mpa_vpl VALUES ("JN15_17","073_15_17","JHN","15","17","17","Haghagha nundaghalaki mwehapa, nahuli mpalanaje.” ");
INSERT INTO mpa_vpl VALUES ("JN15_18","073_15_18","JHN","15","18","18","“Ngati bhandu bha pundema anabhunhakali mwehapa, mmanyi kubha bhakanhakali nepani mangane ja kunhakali mwehapa. ");
INSERT INTO mpa_vpl VALUES ("JN15_19","073_15_19","JHN","15","19","19","Ngati mkabhi bhandu bha pundema, ndema ukabya umpaliki bhabhabhi bhaki. Nambu kwa kubha mwehapa nga mabhandu bha pundema, nambu nepani nakunhawili kuhuma pundema, kwa ndandi jeniheji bhandu bha pundema bhunhakalila. ");
INSERT INTO mpa_vpl VALUES ("JN15_20","073_15_20","JHN","15","20","20","Nkombukaje malobhi ghangu ghanakumpwaghile, ‘Mtumika nga nkolongwa kupeta bambo waki. Ngati bhakang'ahiki nepani, anabhung'aha na mwehapa bhelabhela, na ngati bhakakamwi malobhi ghangu, anabhakamulaje na malobhi ghinu bhelabhela.’ ");
INSERT INTO mpa_vpl VALUES ("JN15_21","073_15_21","JHN","15","21","21","Nambu ghanihagha ghokapi anabhuntendilaje mwehapa kwa ndandi ja lihina langu, maghambu ngachebhummanyi jombi joandumike. ");
INSERT INTO mpa_vpl VALUES ("JN15_22","073_15_22","JHN","15","22","22","Ngati nganakahikiki na kupwagha nabhu, ngabhakabhi na mahoku, nambu sajenu ngachebhabhili na cha kukopunganela kwa mahoku ghabhu. ");
INSERT INTO mpa_vpl VALUES ("JN15_23","073_15_23","JHN","15","23","23","Jola joanhakali nepani, anhakalila na Atati wangu bhelabhela. ");
INSERT INTO mpa_vpl VALUES ("JN15_24","073_15_24","JHN","15","24","24","Ngati nganakatendiki kwabhu mahengu ghangakughatenda mundu jongi jokapi, ngabhakabhi na mahoku. Nambu sajenu bhaweni ngangachu yenu na bhakali kutuhakalila nepani papamu na Atati wangu. ");
INSERT INTO mpa_vpl VALUES ("JN15_25","073_15_25","JHN","15","25","25","Nambu bhatendiki bhenibhela nahuli malobhi ghala ghaghalembakiki mu Shelia jabhu ghapitalyaje, ghaghapwagha, ‘Bhakanhakali waka.’ ” ");
INSERT INTO mpa_vpl VALUES ("JN15_26","073_15_26","JHN","15","26","26","“Nambu paanahikaje Mjangatila hoju, joananuntumaje kwinu kuhuma kwa Atati, yani, Roho Mhuhu wa chakaka joahuma kwa Atati, najombi anaanandilaje nepane. ");
INSERT INTO mpa_vpl VALUES ("JN15_27","073_15_27","JHN","15","27","27","Mwehapa nanamu mnandila, kwa ndandi mkabhi papamu na nepani kutumbu pakutumbula.” ");
INSERT INTO mpa_vpl VALUES ("JN16_1","073_16_1","JHN","16","1","1","“Numpwaghi mambu ghanihagha ghokapi, nahuli ngamwauleka uhobhalelu winu. ");
INSERT INTO mpa_vpl VALUES ("JN16_2","073_16_2","JHN","16","2","2","Bhandu anabhuntopula mwenga mu nyumba ya kuhimangani Bhayahude, na chikahi chihika kila mundu joanaankomaje akahambukya kubha antende Chapanga ibada. ");
INSERT INTO mpa_vpl VALUES ("JN16_3","073_16_3","JHN","16","3","3","Anabhuntendila mambu ghanihagha, kwa ndandi ngachebhummanyi Atati, wala nepani. ");
INSERT INTO mpa_vpl VALUES ("JN16_4","073_16_4","JHN","16","4","4","Nambu numpwaghili mambu ghanihagha, nahuli chikahi chela pachihikaje, mpata kukomboka kubha nyomwi kumpwaghila. “Ngachenumpwaghili mambu ghanihagha kutumbu pakutumbula, maghambu nakabhi papamu na mwehapa.” ");
INSERT INTO mpa_vpl VALUES ("JN16_5","073_16_5","JHN","16","5","5","Nambu sajenu nyenda kwaka jombi joandumike, na wala ngajoanalukila, “Bho, ujenda kwako?” ");
INSERT INTO mpa_vpl VALUES ("JN16_6","073_16_6","JHN","16","6","6","Nambu kwa ndandi numpwaghi mambu ghanihagha, mitima jinu jitwelili huzuni. ");
INSERT INTO mpa_vpl VALUES ("JN16_7","073_16_7","JHN","16","7","7","Nambu nepani numpwaghi chakaka, impalika mwehapa nepani mokaje, maghambu nangakubhoka nepani, Mjangatila hoju ngaahiki kwinu. Nambu nepani anambiti, ananuntuma kwinu. ");
INSERT INTO mpa_vpl VALUES ("JN16_8","073_16_8","JHN","16","8","8","Jombi paanahikaje, jonihoju anaabhalangiha bhandu bha pundema kubha maholalelu ghabhu nga manyahi panani ja mahoku, panani ja kujetakalewa palongi jaka Chapanga, na panani ja utemulu waka Chapanga. ");
INSERT INTO mpa_vpl VALUES ("JN16_9","073_16_9","JHN","16","9","9","Kwa malobhi gha mahoku, maghambu ngachebhanhobhali nepani. ");
INSERT INTO mpa_vpl VALUES ("JN16_10","073_16_10","JHN","16","10","10","Kwa malobhi gha kujetakalewa palongi jaka Chapanga, maghambu nyenda kwa Atati, na mwehapa ngamwimoni kabhete. ");
INSERT INTO mpa_vpl VALUES ("JN16_11","073_16_11","JHN","16","11","11","Kwa malobhi gha utemulu waka Chapanga, maghambu Shetani, nkolongwa wa ndema ghoni ajomwi kutemuliwa. ");
INSERT INTO mpa_vpl VALUES ("JN16_12","073_16_12","JHN","16","12","12","“Mi naghu mambu ghamaheli gha kumpwaghila, nambu kwa sajenu ngamuwezi kughakamula. ");
INSERT INTO mpa_vpl VALUES ("JN16_13","073_16_13","JHN","16","13","13","Nambu jombi paanahikaje, Roho Mhuhu wa chakaka, anaandonguha mwehapa mu chakaka jokapi. Maghambu ngayipwaghi kwa ndandi jaki mweni, nambu ghokapi ghayijowanaje kuhuma kwaka Chapanga anaaghapwaghaje, na mambu ghaghahika anaampwaghila malobhi ghaki. ");
INSERT INTO mpa_vpl VALUES ("JN16_14","073_16_14","JHN","16","14","14","Jombi anaanumbalyaje nepani, kwa ndandi anaatola ghaghabhi ghangu, na kumpwaghi mwehapa. ");
INSERT INTO mpa_vpl VALUES ("JN16_15","073_16_15","JHN","16","15","15","Ghokapi ghaabhi naghu Atati nde ghangu, nde ndandi nakapwaghiki Roho Mhuhu anaatola ghaghabhi ghangu, na kumpwaghi mwehapa.” ");
INSERT INTO mpa_vpl VALUES ("JN16_16","073_16_16","JHN","16","16","16","“Chihighali chikahi kichokopi, mwehapa ngamwimone, na kabhete, chihighali chikahi kichokopi, mwehapa anammonaje, maghambu nyenda kwa Atati.” ");
INSERT INTO mpa_vpl VALUES ("JN16_17","073_16_17","JHN","16","17","17","Panihapa bhakumu bha bhabhulwa bhaki bhakalaluhini, “Bho, lilobhi bhole leapwagha heli, paatupwaghi, ‘Chihighali chikahi kichokopi, mwehapa ngamwimone, na kabhete, chihighali chikahi kichokopi, mwehapa anammonaje?’ Na paapwagha, ‘Maghambu nyenda kwa Atati?’ ” ");
INSERT INTO mpa_vpl VALUES ("JN16_18","073_16_18","JHN","16","18","18","Bhela bhakapwaghike, “Bho, lilobhi bhole leniheli leapwagha, ‘Chihighali chikahi kichokopi?’ Ngachetumanyi alongale panani ja kike!” ");
INSERT INTO mpa_vpl VALUES ("JN16_19","073_16_19","JHN","16","19","19","Yesu akamanyi kubha bhapala kundalukila, bhela akabhapwaghile, “Bho, mlaluhana panani ja ghala ghanapwaghiki, ‘Chihighali chikahi kichokopi, mwehapa ngamwimone, na kabhete, chihighali chikahi kichokopi, mwehapa anammonaje?’ ");
INSERT INTO mpa_vpl VALUES ("JN16_20","073_16_20","JHN","16","20","20","Chakaka numpwaghila, mwehapa anamlelaje na kuombuleza, nambu bhandu bha pundema anabhahekalyaje. Na mwehapa anajumbina mitima jinu, nambu mabhinilu ghinu anaghang'anambuka na kubha chiheku. ");
INSERT INTO mpa_vpl VALUES ("JN16_21","073_16_21","JHN","16","21","21","Mbomba paalibhopola, lumbina lipyanda kwa ndandi chikahi chaki chihikike. Nambu anaajomwi kulibhopo mwana, ngacheakomboka kabhete mabhinilu ghala, kwa ndandi ja chiheku cha kubhelakeka mwana pundema. ");
INSERT INTO mpa_vpl VALUES ("JN16_22","073_16_22","JHN","16","22","22","Sajenu mwehapa mbi na mabhinilu, nambu nepani ananumbona kabhete, na mitima jinu anajihekalyaje, na chiheku chinu njeta mundu wa kumbokeha. ");
INSERT INTO mpa_vpl VALUES ("JN16_23","073_16_23","JHN","16","23","23","“Mu lichobha lela ngamwilalukile lilobhi lokapi. Numpwaghi Chakaka, ngati anamundobhiki Atati chindu chokapi kwa lihina langu, jombi anaampekyaje. ");
INSERT INTO mpa_vpl VALUES ("JN16_24","073_16_24","JHN","16","24","24","Mbaka sajenu ngachendobhiki chindu chokapi kwa lihina langu. Ndobhaje, na mwehapa anampataje, nahuli chiheku chinu chikamilikaje. ");
INSERT INTO mpa_vpl VALUES ("JN16_25","073_16_25","JHN","16","25","25","“Numpwaghi mambu ghanihagha kwa ulenganesu. Nambu chikahi chihika ambapu nganipwaghi na mwehapa kabhete kwa ulenganesu, nambu ananumpwaghilaje hotuhotu malobhi gha Atati. ");
INSERT INTO mpa_vpl VALUES ("JN16_26","073_16_26","JHN","16","26","26","Mu lichobha lela mwilobhaje kwa lihina langu, na wala ngachenumpwaghila kubha nepani ananundobhila kwa Atati, ");
INSERT INTO mpa_vpl VALUES ("JN16_27","073_16_27","JHN","16","27","27","kwa ndandi Atati mwene ampala mwehapa. Maghambu mwehapa mumbaliki nepani, na kuhobhalela kubha nepani nakahumiki kwaka Chapanga.” ");
INSERT INTO mpa_vpl VALUES ("JN16_28","073_16_28","JHN","16","28","28","Nepani nakahumiki kwa Atati, nanatu nhikiki pani pundema, na kabhete nuleka ndema, na kujenda kwa Atati. ");
INSERT INTO mpa_vpl VALUES ("JN16_29","073_16_29","JHN","16","29","29","Bhela bhabhulwa bhaki bhakapwaghike, “Lingalyaje, sajenu upwagha hotuhotu, wala ngacheupwagha kwa malenganesu ghokapi ghala. ");
INSERT INTO mpa_vpl VALUES ("JN16_30","073_16_30","JHN","16","30","30","Sajenu tumanyi kubha wehapa umanyi mambu ghokapi, na wala ngachekubhi na ndandi jaka mundu kukulalukila, bhela tuhobhalela kubha ukahumiki kwaka Chapanga.” ");
INSERT INTO mpa_vpl VALUES ("JN16_31","073_16_31","JHN","16","31","31","Yesu akabhayangike, “Bho, sajenu le muhobhalela? ");
INSERT INTO mpa_vpl VALUES ("JN16_32","073_16_32","JHN","16","32","32","Lingalyaje, chikahi chihika, ena, chijomwi kuhika, pamwipechanganaje kila mundu kwaki, na kuneka nepani kanjika jangu. Nambu nepani ngachemi kanjika jangu, kwa ndandi Atati abhi papamu na nepani. ");
INSERT INTO mpa_vpl VALUES ("JN16_33","073_16_33","JHN","16","33","33","Numpwaghili mambu ghanihagha nahuli mpata kubha na lukwale mkati jangu. Pundema anampata ulale, nambu mulipekya mtima, kwa ndandi nepani niuweziki ndema!” ");
INSERT INTO mpa_vpl VALUES ("JN17_1","073_17_1","JHN","17","1","1","Yesu paakajomwi kulongela malobhi ghanihagha, akalingali kunani kumahunde, na kupwagha, “Atati, lisaa lihikike. Undumbalyaje Mwana waku, nahuli najombi Mwana waku akulumbalyaje wehapa. ");
INSERT INTO mpa_vpl VALUES ("JN17_2","073_17_2","JHN","17","2","2","Ngati moumpeki lujiniku panani ja bhandu bhokapi, nahuli kwa bhokapi bhaumpekihe abhapekya womi wa mileli. ");
INSERT INTO mpa_vpl VALUES ("JN17_3","073_17_3","JHN","17","3","3","Na womi wa mileli nde ghongone, bhandu bhakumanya wehapa wa Chapanga wa kanjika wa chakaka, na Yesu Kristo joukantumike. ");
INSERT INTO mpa_vpl VALUES ("JN17_4","073_17_4","JHN","17","4","4","Nepani nukulumbalili pundema, nakabya nyomwile lihengu lela leukambekihe nilihengaje. ");
INSERT INTO mpa_vpl VALUES ("JN17_5","073_17_5","JHN","17","5","5","Sajenu Atati! Unumbalyaje nepani papamu na wehapa, kwa ulumbalilu ghola ghonakabhi naghu papamu na wehapa mangane ja kubhombakeka kwa ndema.” ");
INSERT INTO mpa_vpl VALUES ("JN17_6","073_17_6","JHN","17","6","6","“Nukutendiki umanyikanaje kwa bhandu bhala bhawambekihe pundema. Bhakabhi bhaku, ukambekihi nepani, na Lilobhi laku bhalijowine. ");
INSERT INTO mpa_vpl VALUES ("JN17_7","073_17_7","JHN","17","7","7","Sajenu bhamanyi kubha yokapi yewambekihe ihumiki kwaku. ");
INSERT INTO mpa_vpl VALUES ("JN17_8","073_17_8","JHN","17","8","8","Magambu malobhi ghala ghawambekihe nabhapekihi bhombi, na bhombi bhakaghajopalile. Na bhakamanyi chakaka kubha nakahumiki kwaku, na bhakahobhalili kubha wehapa nde wewandumike.” ");
INSERT INTO mpa_vpl VALUES ("JN17_9","073_17_9","JHN","17","9","9","Nepani nabhalobhela bhombi. Nepani ngachenulobhela ndema, nambu bhala bhaumbekihe, maghambu bhanihabha nde bhaku. ");
INSERT INTO mpa_vpl VALUES ("JN17_10","073_17_10","JHN","17","10","10","Bhokapi bhabhabhi bhangu nde bhaku, na bhabhabhi bhaku nde bhangu, nanatu numbaliwi mkati jabhu. ");
INSERT INTO mpa_vpl VALUES ("JN17_11","073_17_11","JHN","17","11","11","Nepani sajenu ngangubhi kabheti pundema, nambu bhombi bhakali bhabhi pundema, nanatu nhika kwaku. Atati Mhuhu, kwa makili gha lihina laku lewambekihe ubhalenda bhombi, nahuli bhabya chindu chimu ngati tepani motubhelile. ");
INSERT INTO mpa_vpl VALUES ("JN17_12","073_17_12","JHN","17","12","12","Panakabhi papamu nabhu pundema, nakabhalendiki kwa makili gha lihina laku lewambekihe, wala njeta jumu wabhu joakahobhike, nambu jola mwana wa kuhobha, nahuli Malembu Mahuhu ghatimilaje. ");
INSERT INTO mpa_vpl VALUES ("JN17_13","073_17_13","JHN","17","13","13","Na sajenu nhika kwaku, na malobhi ghangani naghalongela pundema, nahuli bhabya na chiheku changu chakabya chikamilike mkati jabhu. ");
INSERT INTO mpa_vpl VALUES ("JN17_14","073_17_14","JHN","17","14","14","Nepani nabhapeki lilobhi laku, na bhandu bha pundema bhatenda kubhahakalila, maghambu bhombi nga bha pundema ghoni, ngati nepani momeli nga wa pundema ghoni. ");
INSERT INTO mpa_vpl VALUES ("JN17_15","073_17_15","JHN","17","15","15","Nepani ngachenobha kubha ubhabhoha pundema, nambu ubhalenda na Mhakau jola. ");
INSERT INTO mpa_vpl VALUES ("JN17_16","073_17_16","JHN","17","16","16","Bhombi nga bha pundema ghoni, ngati nepani momeli nga wa pundema ghoni. ");
INSERT INTO mpa_vpl VALUES ("JN17_17","073_17_17","JHN","17","17","17","Ubhagholulaje kwa chakaka jela, lilobhi laku nde chakaka. ");
INSERT INTO mpa_vpl VALUES ("JN17_18","073_17_18","JHN","17","18","18","Ngati bhela mowandumi nepani pundema, nanatu bhelabhela nakabhatumiki bhombi pundema. ");
INSERT INTO mpa_vpl VALUES ("JN17_19","073_17_19","JHN","17","19","19","Na kwa ndandi jabhu niligholola namwete, nahuli nabhombi bhagholulikaje mu chakaka jela. ");
INSERT INTO mpa_vpl VALUES ("JN17_20","073_17_20","JHN","17","20","20","Wala nga bhanihabha pela bhanabhalobhela, nambu na bhala bhabhinhobhalyaje kwa ndandi ja lilobhi labhu. ");
INSERT INTO mpa_vpl VALUES ("JN17_21","073_17_21","JHN","17","21","21","Nobha nahuli bhokapi bhabya chindu chimu, ngati wehapa, Atati, moubheli mkati jangu, nanatu mkati jaku, bhanganya habha nabhombi bhabya mkati jitu. Nahuli bhandu bha pundema bhapata kuhobhalela kubha wehapa nde wewandumike. ");
INSERT INTO mpa_vpl VALUES ("JN17_22","073_17_22","JHN","17","22","22","Na ulumbalilu ghola ghowambeki nepani nabhapeki bhombi, nahuli bhabya chindu chimu ngati tepani motubheli chindu chimu. ");
INSERT INTO mpa_vpl VALUES ("JN17_23","073_17_23","JHN","17","23","23","Nepani mkati jabhu, na wehapa mkati jangu. Nahuli bhabya bhakamiliki mu chindu chimu. Nahuli bhandu bha pundema bhamanya kubha wehapa nde wewandumike, ubhapala bhombi ngati mowambali nepani. ");
INSERT INTO mpa_vpl VALUES ("JN17_24","073_17_24","JHN","17","24","24","“Atati, bhanihabha bhaumbekihe mbala bhabya papamu na nepani pokapi pamile, bhapata kuulinga ulumbalilu wangu ghoumbekihe. Maghambu ukambaliki mangani ja kutumbula kubhombakeka ndema. ");
INSERT INTO mpa_vpl VALUES ("JN17_25","073_17_25","JHN","17","25","25","Atati Wambone! Bhandu bha pundema ngachebhukumanye, nambu nepani nakakumanyi, nabhombi bhamanyiki kubha wehapa nde wewandumike. ");
INSERT INTO mpa_vpl VALUES ("JN17_26","073_17_26","JHN","17","26","26","Nanatu nilitendiki lihina laku limanyikanaje kwabhu, kabheti ananyendalyaje kulitenda limanyikanaje, nahuli upalu ghola ghowambaliki nepani ubya mkati jabhu, na nepani mya mkati jabhu.” ");
INSERT INTO mpa_vpl VALUES ("JN18_1","073_18_1","JHN","18","1","1","Yesu paakajomwi kundobha Chapanga, akabhokiki na bhabhulwa bhaki na kujenda kwihi ja kikoka Keduloni, pakukabhi na chijongu, akajingi jombi papamu na bhabhulwa bhaki. ");
INSERT INTO mpa_vpl VALUES ("JN18_2","073_18_2","JHN","18","2","2","Bhela Yuda, jola joapalikaje kung'anambuka Yesu, akapamanyi pandu pala. Maghambu Yesu akabhi ajenda konihoku pamaheli papamu na bhabhulwa bhaki. ");
INSERT INTO mpa_vpl VALUES ("JN18_3","073_18_3","JHN","18","3","3","Bhela Yuda, akabya atoliki lipogha la manjolinjoli bha Kiloma na bhalonda bha Nyumba jaka Chapanga bhabhakahumiki kwa ihongozi bha bhapenganyambiku na Mafalisayo, bhakapiti konihoku bhakabya bhatotwi taa, na myengi, na mikoha na ndonga. ");
INSERT INTO mpa_vpl VALUES ("JN18_4","073_18_4","JHN","18","4","4","Yesu akabya amanyi ghala ghaghumpataje, akapiti palongi jabhu na kubhalalukila, “Bho, mundonda nane?” ");
INSERT INTO mpa_vpl VALUES ("JN18_5","073_18_5","JHN","18","5","5","Bhombi bhakamuyangike, “Yesu wa ku Nazaleti.” Yesu akabhapwaghile, “Nde nepani.” Najombi Yuda, jola joakang'anambwiki Yesu, akabhi ajemiki papamu nabhu. ");
INSERT INTO mpa_vpl VALUES ("JN18_6","073_18_6","JHN","18","6","6","Yesu paakabhapwaghi, “Nde nepani,” bhakakelawiki chihanganyuma, na kuhabhuka pahi. ");
INSERT INTO mpa_vpl VALUES ("JN18_7","073_18_7","JHN","18","7","7","Bhela Yesu akabhalaluki kabhete, “Bho, mundonda nane?” Bhakamuyangike, “Yesu wa ku Nazaleti.” ");
INSERT INTO mpa_vpl VALUES ("JN18_8","073_18_8","JHN","18","8","8","Yesu akabhayangike, “Nyomwi kumpwaghila kubha nde nepani. Bhela ngati mnonda nepani, mwabhaleka bhanganya abhabha bhajendaje.” ");
INSERT INTO mpa_vpl VALUES ("JN18_9","073_18_9","JHN","18","9","9","Nahuli litimiaje lilobhi lela leakapwaghiki, “Atati, bhala bhawambekihe ngachenunhoiki hata jumu wabhu.” ");
INSERT INTO mpa_vpl VALUES ("JN18_10","073_18_10","JHN","18","10","10","Bhela Simoni Petulu akabhi na lipanga, akalihungwili na kunheketa likutu la kumalelelu laka mtumika waka Mpenganyambiku Nkolongwa. Mtumika hoju lihina laki alowakika Maliko. ");
INSERT INTO mpa_vpl VALUES ("JN18_11","073_18_11","JHN","18","11","11","Bhela Yesu akumpwaghi Petulu, “Ukelabhuwa lipanga laku mu ala jaki. Bho, chikombi cha mang'ahiku cheambeki Atati le nganinywelela?” ");
INSERT INTO mpa_vpl VALUES ("JN18_12","073_18_12","JHN","18","12","12","Bhela manjolinjoli bha Kiloma bhala na nkolongwa wabhu wa manjolinjoli papamu na ihongozi bha Bhayahude bhakunkamwili Yesu, na kunkonga. ");
INSERT INTO mpa_vpl VALUES ("JN18_13","073_18_13","JHN","18","13","13","Kutumbula bhakumpeliki kwaka Anasi. Nkohanu waka Kayafa, joakabhi Mpenganyambiku Nkolongwa chaka chela. ");
INSERT INTO mpa_vpl VALUES ("JN18_14","073_18_14","JHN","18","14","14","Kayafa nde jola joakabhapeki bhakolongwa bha Bhayahude lilobhi lela la kubha impalika mundu jumu kupotela kwa ndandi ja bhandu bhokapi. ");
INSERT INTO mpa_vpl VALUES ("JN18_15","073_18_15","JHN","18","15","15","Simoni Petulu papamu na mbulwa njaki bhakabhi bhunjengalela Yesu. Mbulwa jongi hoju akabhi amanyikana kwaka Mpenganyambiku Nkolongwa, akajingili papamu na Yesu mu liwangala laka Mpenganyambiku Nkolongwa. ");
INSERT INTO mpa_vpl VALUES ("JN18_16","073_18_16","JHN","18","16","16","Nambu Petulu akajemiki kunja ja ndyangu. Bhela mbulwa jongi joakamanyakini kwaka Mpenganyambiku Nkolongwa jola, akapitiki kunja, na kulongela na mwali joalendika pundyangu jola, na kundeta Petulu mkati. ");
INSERT INTO mpa_vpl VALUES ("JN18_17","073_18_17","JHN","18","17","17","Bhela mwali joakabhi alenda ndyangu jola akundaluki Petulu, “Bho, wehapa le nga jumu wa bhabhulwa bhaka mundu ajojo?” Petulu akayangike, “Nga nepane.” ");
INSERT INTO mpa_vpl VALUES ("JN18_18","073_18_18","JHN","18","18","18","Bhatumika bhala papamu na manjolinjoli bhakabhi bhajemiki, bhakanyatukya moto wa makalakala, maghambu kukabhi na imbepu. Petulu najombi akabhi ajemi papamu nabhu, akanyatukya moto. ");
INSERT INTO mpa_vpl VALUES ("JN18_19","073_18_19","JHN","18","19","19","Bhela Mpenganyambiku Nkolongwa akundaluki Yesu panani ja bhabhulwa bhaki, na panani ja mabholu ghaki. ");
INSERT INTO mpa_vpl VALUES ("JN18_20","073_18_20","JHN","18","20","20","Yesu akayangike, “Nepani nongili hotuhotu pundema wokapi. Machobha ghokapi molika mu nyumba ya kuhimanganila Bhayahude, na paliwangala la Nyumba jaka Chapanga, pabhalibhongana Bhayahude bhokapi. Na ngachenalongi lilobhi lokapi lela kwa kulihiya. ");
INSERT INTO mpa_vpl VALUES ("JN18_21","073_18_21","JHN","18","21","21","Bho, maghambu ki unalukila nepani? Ubhalalukya bhala bhabhajowini ghala ghanabhapwaghile. Kwa ndandi bhombi bhamanyi ghanakapwaghike.” ");
INSERT INTO mpa_vpl VALUES ("JN18_22","073_18_22","JHN","18","22","22","Bhela paakapwaghiki ghanihagha, jumu wa manjolinjoli joakabhi ajemiki pambipi naku, akundapwi Yesu lighanja la kumihu, na kupwagha, “Bho, bhenibhela nde moumuyangi Mpenganyambiku Nkolongwa?” ");
INSERT INTO mpa_vpl VALUES ("JN18_23","073_18_23","JHN","18","23","23","Yesu akamuyangike, “Anangati nongili lijambu lihakau, ulandilaje uhakau ghonongile palongi ja bhandu. Nambu anangati nongili chakaka, bho, maghambu kiki unapula?” ");
INSERT INTO mpa_vpl VALUES ("JN18_24","073_18_24","JHN","18","24","24","Bhela Anasi akumpeliki Yesu kwaka Kayafa Mpenganyambiku Nkolongwa, koni akabya akongakiki. ");
INSERT INTO mpa_vpl VALUES ("JN18_25","073_18_25","JHN","18","25","25","Chikahi hechi Simoni Petulu akabhi akali ajemiki akanyatukya moto. Bhakumu bha bhabhakabhi panipala bhakundaluki Petulu, “Bho, wehapa le nga wa jumu wa bhabhulwa bhake?” Petulu akakaniki, akapwaghaje, “Nga nepani.” ");
INSERT INTO mpa_vpl VALUES ("JN18_26","073_18_26","JHN","18","26","26","Jumu wa bhatumika bhaka Mpenganyambiku Nkolongwa, ndongu waka mundu jola Petulu joakunchekwi likutu, akundalukile, “Bho, nepani le ngachenukuweni kuchijongu kola ukabya papamu na Yesu?” ");
INSERT INTO mpa_vpl VALUES ("JN18_27","073_18_27","JHN","18","27","27","Bhela Petulu akakaniki kabhete, na palapala likongobhi lakabhekike. ");
INSERT INTO mpa_vpl VALUES ("JN18_28","073_18_28","JHN","18","28","28","Bhela bhakuntoliki Yesu kuhuma kwaka Kayafa na kumpeleka panyumba jaka mtawala wa Kiloma. Kukabhi lukela, nambu bheni ngachebhajingili mkati ja nyumba jaka Gavana, ngabhihika kubha bhahakau, nahuli bhapata kula Pasaka. ");
INSERT INTO mpa_vpl VALUES ("JN18_29","073_18_29","JHN","18","29","29","Bhela Pilato akapitiki kunja ja nyumba jaki, na kubhalalukila, “Bho, ndetiki matakilu bhole panani jaka mundu ajojo?” ");
INSERT INTO mpa_vpl VALUES ("JN18_30","073_18_30","JHN","18","30","30","Bhakamuyangike, “Ngati kukabhi mundu ajojo ngacheahengiki mahakau, ngatukundetiki kwaku.” ");
INSERT INTO mpa_vpl VALUES ("JN18_31","073_18_31","JHN","18","31","31","Pilato akabhapwaghile, “Haya muntola mwehapa mukuntemulaje kwa kulengana na shelia hinu.” Bhayahude bhakumpwaghile, “Tepani ngachetubhi na lujiniku lwa kuntemula mundu kupotela.” ");
INSERT INTO mpa_vpl VALUES ("JN18_32","073_18_32","JHN","18","32","32","Bhakalongi bhenibhela nahuli malobhi ghaakalongi Yesu, panani ja ntundu wa nyiwa jeayikuwaje ghapata kutimia. ");
INSERT INTO mpa_vpl VALUES ("JN18_33","073_18_33","JHN","18","33","33","Bhela Pilato akajingi kabhete munyumba jaki, akundohiki Yesu, na kundalukila, “Bho, wehapa le nde Unkolongwa wa Bhayahude?” ");
INSERT INTO mpa_vpl VALUES ("JN18_34","073_18_34","JHN","18","34","34","Yesu akamuyangike, “Bho, unalukila lilalukilu lendenu kubhokana na maholalelu ghaku au bhakakupwaghi bhandu bhangi malobhi panani jangu?” ");
INSERT INTO mpa_vpl VALUES ("JN18_35","073_18_35","JHN","18","35","35","Pilato akamuyangike, “Bho, nepani le nu Myahude?” Bhandu bhaku na ihongozi bha bhapenganyambiku nde bhabhukuletiki kwangu. Bho, uhengiki kike? ");
INSERT INTO mpa_vpl VALUES ("JN18_36","073_18_36","JHN","18","36","36","Yesu akamuyangike, “Ukolongwa wangu nga wa ndema ghoni. Ngati ukolongwa wangu ukabhi wa ndema ghoni, bhatumika bhangu bhakabya bhangomanile, nahuli nganikamulika na bhakolongwa bha Bhayahude. Nambu ukolongwa wangu nga wa pani pundema!” ");
INSERT INTO mpa_vpl VALUES ("JN18_37","073_18_37","JHN","18","37","37","Bhela Pilato akumpwaghile, “Bho, henu wehapa le unkolongwa?” Yesu akamuyangike, “Wehapa upwaghike kubha nepani nunkolongwa. Nepani melakiki kwa ndandi ja ghangane, na kwa ndandi ja ghangane nakahiki pundema, nahuli nandila chakaka. Mundu jokapi joabhi wa chakaka anyowanela sauti jango.” ");
INSERT INTO mpa_vpl VALUES ("JN18_38","073_18_38","JHN","18","38","38","Pilato akalalukile, “Bho, chakaka nde kike?” Pilato paakalongi malobhi ghanihagha, akapitiki kabheti kunja na kubhapwaghila bhakolongwa bha Bhayahude bhabhakuntakili Yesu, “Nepani ngachemona lihoku lokapi lela kwaka mundu ajojo. ");
INSERT INTO mpa_vpl VALUES ("JN18_39","073_18_39","JHN","18","39","39","Nambu mabhanganya mbi na ntetu winu kubha chikahi cha Pasaka numbopulya mkongeka jumu jomumpala. Bho, mpala le numbopulya Nkolongwa wa Bhayahude ajojo?” ");
INSERT INTO mpa_vpl VALUES ("JN18_40","073_18_40","JHN","18","40","40","Bhombi bhakajamali kabhete, bhakapwaghaje, “Nga mundu hoju, nambu utubhopulya Balaba!” Bhela Balaba akabhi mnyaghula wa hindu ya bhandu. ");
INSERT INTO mpa_vpl VALUES ("JN19_1","073_19_1","JHN","19","1","1","Bhela Pilato akalaghalakili bhuntola Yesu, na kundapu iboku. ");
INSERT INTO mpa_vpl VALUES ("JN19_2","073_19_2","JHN","19","2","2","Nabhombi manjolinjoli bhakalokiki litaji la miha, na kunhwatika Yesu kumutu, na bhakunhwatiki ingobhu ja zambalau. ");
INSERT INTO mpa_vpl VALUES ("JN19_3","073_19_3","JHN","19","3","3","Bhakabhi bhunjendela na kumpwaghila, “Monile! Nkolongwa wa Bhayahude!” Na bhakundapwi maghanja kumihu. ");
INSERT INTO mpa_vpl VALUES ("JN19_4","073_19_4","JHN","19","4","4","Bhela Pilato akapitiki kabheti kunja, na kubhapwaghila, “Ndingalyaje! Nundeta Yesu kwinu, mpata kumanya kubha nepani ngachemweni lihakau lokapi lela la kuntemula kwaki.” ");
INSERT INTO mpa_vpl VALUES ("JN19_5","073_19_5","JHN","19","5","5","Panihapa Yesu akapitiki kunja, akabya awatiki litaji la miha lela, na ingobhu ja zambalau jela. Pilato akabhapwaghile, “Ndingalyaje! Mundu wene jopambane!” ");
INSERT INTO mpa_vpl VALUES ("JN19_6","073_19_6","JHN","19","6","6","Bhapenganyambiku bhakolongwa na bhalonda bha Nyumba jaka Chapanga pabhakumbweni, bhakajamalili, bhakapwaghaje, “Unhwamba punsalaba! Unhwamba punsalaba!” Pilato akabhapwaghile, “Muntola mabhete, mukunhwambaje. Maghambu nepani ngachemona lihakau la kuntemula kwaki.” ");
INSERT INTO mpa_vpl VALUES ("JN19_7","073_19_7","JHN","19","7","7","Bhayahude bhakamuyangike, “Tepani tubhi na shelia, na kubhokana na shelia heji, impalika kupotela, maghambu akalitendiki kubha Mwana waka Chapanga.” ");
INSERT INTO mpa_vpl VALUES ("JN19_8","073_19_8","JHN","19","8","8","Pilato paakajowini malobhi ghanihagha, akajowipi nakanopi. ");
INSERT INTO mpa_vpl VALUES ("JN19_9","073_19_9","JHN","19","9","9","Akajingi kabhete munyumba jaki ja kikolongwa jela na kundaluki Yesu, “Bho, wehapa uhumiki kwako?” Nambu Yesu ngacheakayangiki lilobhi lokapi lela. ");
INSERT INTO mpa_vpl VALUES ("JN19_10","073_19_10","JHN","19","10","10","Pilato akumpwaghile, “Bho, ngacheulonge na nepane? Bho, ngacheumanyi kubha nepani mi na lujiniku lwa kukubhopola au lujiniku lwa kukuwamba?” ");
INSERT INTO mpa_vpl VALUES ("JN19_11","073_19_11","JHN","19","11","11","Yesu akamuyangike, “Wehapa ngaukabhi na lujiniku lwokapi lola panani jangu, ngati ngaukajopali kuhuma kwaka Chapanga. Kwa ndandi jeniheji, jola joanetiki kwaku abhi na lihoku likolongwa nakanopi.” ");
INSERT INTO mpa_vpl VALUES ("JN19_12","073_19_12","JHN","19","12","12","Kutumbula panihapa Pilato akalondiki indela ja kumbopola Yesu. Nambu Bhayahude bhakajamalili, bhakapwaghaje, “Anaumbopuli mundu ajoju, wehapa nga unkochi waka Kaisali. Maghambu kila mundu joalitenda kubha nkolongwa ampenga Kaisali!” ");
INSERT INTO mpa_vpl VALUES ("JN19_13","073_19_13","JHN","19","13","13","Bhela, Pilato paakajowini malobhi ghanihagha, akundetiki Yesu kunja, akatami pachitehu chaki cha utemulu, pandu papalowakeka, “Lubhanja lwa Liganga,” au kwa Kiebulania, “Gabata.” ");
INSERT INTO mpa_vpl VALUES ("JN19_14","073_19_14","JHN","19","14","14","Na ghakabhi maandalilu gha Pasaka, ngati saa sita ja muhi. Pilato akabhapwaghi Bhayahude, “Ndingalyaje, nkolongwa winu!” ");
INSERT INTO mpa_vpl VALUES ("JN19_15","073_19_15","JHN","19","15","15","Nambu bhombi bhakajamalili, bhakapwaghaje, “Unkomaje! Unkomaje! Unhwamba punsalaba!” Pilato akabhapwaghile, “Bho, nunhwamba nkolongwa wino?” Ihongozi bha bhapenganyambiku bhakamuyangiki, “Tepani ngachetubhi na nkolongwa nambu Kaisali!” ");
INSERT INTO mpa_vpl VALUES ("JN19_16","073_19_16","JHN","19","16","16","Bhela Pilato akabhapeki Yesu kwabhu nahuli bhunhwambaje. Nabhombi bhakuntoliki Yesu. ");
INSERT INTO mpa_vpl VALUES ("JN19_17","073_19_17","JHN","19","17","17","Yesu akabya autotwili msalaba waki, akapitiki na kujenda pandu papalowakeka, “Lifuvu la Mmutu,” au kwa Kiebulania, “Goligota.” ");
INSERT INTO mpa_vpl VALUES ("JN19_18","073_19_18","JHN","19","18","18","Bhakamuwambiki konihoku, na bhangi bhabheli papamu naku, jumu upambala wa kumalelelu, na jongi upambala wa kumangeja, na Yesu akabya pachilanda jabhu. ");
INSERT INTO mpa_vpl VALUES ("JN19_19","073_19_19","JHN","19","19","19","Pilato akalembiki anuwane, na kujibheka panani ja msalaba waka Yesu. Na jakalembakiki, “Yesu wa ku Nazaleti, Nkolongwa wa Bhayahude.” ");
INSERT INTO mpa_vpl VALUES ("JN19_20","073_19_20","JHN","19","20","20","Bhela anuwani jeniheji bhakajisomiki Bhayahude bhamaheli. Maghambu pandu pala paakawambakiki Yesu pakabhi pambipi na muchi. Na jakalembakiki kwa Kiebulania, na Kilumi, na Kigiliki. ");
INSERT INTO mpa_vpl VALUES ("JN19_21","073_19_21","JHN","19","21","21","Nambu bhapenganyambiku bhakolongwa na Bhayahude bhakumpwaghi Pilato, “Ngawilemba, ‘Nkolongwa wa Bhayahude,’ nambu ulemba, ‘Mundu ajoju akapwaghiki kubha, Nepani nde Nkolongwa wa Bhayahude.’ ” ");
INSERT INTO mpa_vpl VALUES ("JN19_22","073_19_22","JHN","19","22","22","Pilato akayangike, “Chenyomwi kulemba, nembike.” ");
INSERT INTO mpa_vpl VALUES ("JN19_23","073_19_23","JHN","19","23","23","Bhela manjolinjoli pabhakajomwi kunhwamba Yesu, bhakaitoliki ingobhu yaki, na kuighabha mapogha ncheche, kwa kila linjolinjoli lipogha laki. Nambu bhakajetangani likanzu laki lela ngabhalikachula, maghambu lakabhi nga mshonu, nambu lilokakiki kutumbu kunani mbaka pahi. ");
INSERT INTO mpa_vpl VALUES ("JN19_24","073_19_24","JHN","19","24","24","Bhela bhakapwaghani bheni kwa bheni, “Ngatujikachula, nambu tujilapulya kula, jibya jaka nane.” Nahuli ghatimiaje Malembu Mahuhu ghaghapwagha, “Bhakaghabhini ingobhu yangu, na kanzu jangu bhakajilapuli kula.” Bhenibhela nde mobhakahengi manjolinjoli bhala. ");
INSERT INTO mpa_vpl VALUES ("JN19_25","073_19_25","JHN","19","25","25","Na pambipi na msalaba waka Yesu akabhi ajemiki mabhu waka Yesu, na ndombu wa mabhu waki, na Malia nhwanu waka Kileopa, na Malia Magidalena. ");
INSERT INTO mpa_vpl VALUES ("JN19_26","073_19_26","JHN","19","26","26","Bhela Yesu paakumbweni mabhu waki, na mbulwa joakumpaliki jola ajemiki pambipi, akumpwaghi mabhu waki, “Amabhu, hajoju nde mwana waku.” ");
INSERT INTO mpa_vpl VALUES ("JN19_27","073_19_27","JHN","19","27","27","Kebhete akumpwaghi mbulwa jola, “Lingalyaje, hajoju nde mabhu waku.” Na kutumbu chikahi chela mbulwa jola akuntoliki mabhu waka Yesu kunyumba jaki. ");
INSERT INTO mpa_vpl VALUES ("JN19_28","073_19_28","JHN","19","28","28","Paghajomwiki ghanihagha, Yesu akamanyi kubha ghokapi ghajomwike. Nahuli ghapitalyaje Malembu Mahuhu, akapwaghike, “Mona inywita.” ");
INSERT INTO mpa_vpl VALUES ("JN19_29","073_19_29","JHN","19","29","29","Panihapa pakabhi na mbale jejitweli siki. Bhela bhakatobhali siponji mu siki jela, na kujibheka mu ufito wa nkongu wa hisopo, na kumpelakela mundomu. ");
INSERT INTO mpa_vpl VALUES ("JN19_30","073_19_30","JHN","19","30","30","Yesu paakayomwi kujionja siki heji, akapwaghike, “Ghajomwike!” Akajinamishi mmutu waki, na kuheketa roho. ");
INSERT INTO mpa_vpl VALUES ("JN19_31","073_19_31","JHN","19","31","31","Bhela bhakolongwa bha Bhayahude kwa kubha lakabhi nde lichobha la Ijumaa, yani, lichobha la Maandalio mangani ja Lichobha la Sabato na hyegha ngaitama punsalaba Lichobha la Sabato, maghambu Lichobha la Sabato lakabhi lichobha likolongwa, bhakundobhiki Pilato bhahekata magholu gha bhala bhabhawambakike, na bhakabhohakikaje. ");
INSERT INTO mpa_vpl VALUES ("JN19_32","073_19_32","JHN","19","32","32","Bhela manjolinjoli bhakapiti, bhakunhekiti magholu wa kutumbula, na wa kabheli, joakawambakiki punsalaba papamu na Yesu. ");
INSERT INTO mpa_vpl VALUES ("JN19_33","073_19_33","JHN","19","33","33","Nambu pabhakunhiki Yesu, na kumbona ajomwi kupotela, ngachebhunhekiti magholu. ");
INSERT INTO mpa_vpl VALUES ("JN19_34","073_19_34","JHN","19","34","34","Nambu linjolinjoli jumu akunhomiki mwindeta jaka Yesu kwa nkoha, na palapala ukapitiki mwahi na machi. ");
INSERT INTO mpa_vpl VALUES ("JN19_35","073_19_35","JHN","19","35","35","Mundu joakaweni mambu ghanihagha nde joabhohika ulandilu, na ulandilu waki nde wa chakaka. Najombi amanyi kubha alongela chakaka, nahuli nanamu mpata kuhobhalela. ");
INSERT INTO mpa_vpl VALUES ("JN19_36","073_19_36","JHN","19","36","36","Mambu ghanihagha ghakahengakiki nahuli Malembu Mahuhu ghapata kupitalila, “Njeta hata chihupa chaki chimu chechihekatwaje.” ");
INSERT INTO mpa_vpl VALUES ("JN19_37","073_19_37","JHN","19","37","37","Na kabheti Malembu ghangi ghapwagha, “Anabhundinga jola jobhunhotwile.” ");
INSERT INTO mpa_vpl VALUES ("JN19_38","073_19_38","JHN","19","38","38","Paghapetiki mambu ghanihagha, Yusufu mundu wa ku Alimataya, akunjopiki Pilato anjetakalya kujiheleha hyegha jaka Yesu punsalaba. Yusufu akabhi nde mbulwa waka Yesu, nambu kwa kulihiya, kwa choghohi ja Bhayahude, na Pilato akunjetakalile. Bhela Yusufu akapiti, na kujitola hyegha jaka Yesu. ");
INSERT INTO mpa_vpl VALUES ("JN19_39","073_19_39","JHN","19","39","39","Yusufu akalongini na Nikodemu jola ambaju pakutumbula akunjendi Yesu ikilu, akaletiki mahangaghanu gha manungilu ghaghalowakeka manemane na ubani, ngati kilo selasini. ");
INSERT INTO mpa_vpl VALUES ("JN19_40","073_19_40","JHN","19","40","40","Bhokapi bhabeli bhakajitoliki hyegha jaka Yesu, bhakajikongiki sanda ja ingobhu jinyahi jihuhu papamu na manungilu ghala, ngati moubheli ntetu wa Bhayahude wa kutagha. ");
INSERT INTO mpa_vpl VALUES ("JN19_41","073_19_41","JHN","19","41","41","Na palapala paakawambakiki Yesu pala, pakabhi na chijongu, na mkati ja chijongu chela kukabhi na litengeli lahenu, lelu ngachealabhali kutaghakika mundu. ");
INSERT INTO mpa_vpl VALUES ("JN19_42","073_19_42","JHN","19","42","42","Bhela maghambu lakabhi lichobha la Bhayahude la Maandalio gha Lichobha la Sabato na litengeli lakabhi pambipi, bhakajibhekiki hyegha jaka Yesu mulitengele. ");
INSERT INTO mpa_vpl VALUES ("JN20_1","073_20_1","JHN","20","1","1","Lukela pachibhombu lichobha la Jumapili, kukabya kukali na lwihi, Malia Magidalena akapiti kulitengeli, na akaliweni liganga lela libhohakiki pundyangu wa litengeli. ");
INSERT INTO mpa_vpl VALUES ("JN20_2","073_20_2","JHN","20","2","2","Bhela akakembili imbelu mbaka kwaka Simoni Petulu na mbulwa jongi jola ambaju Yesu akumpaliki, na kubhapwaghila, “Bhumbohiki Bambo mulitengeli, wala ngachetumanyi kobhumbekike.” ");
INSERT INTO mpa_vpl VALUES ("JN20_3","073_20_3","JHN","20","3","3","Bhela Petulu papamu na mbulwa jongi jola, bhakabhokiki na kujenda kulitengeli. ");
INSERT INTO mpa_vpl VALUES ("JN20_4","073_20_4","JHN","20","4","4","Bhakakembili imbelu bhokapi bhabheli, nambu mbulwa jongi jola akakembili nakanopi kumpeta Petulu, na kubha wa kutumbula kuhika kulitengeli. ");
INSERT INTO mpa_vpl VALUES ("JN20_5","073_20_5","JHN","20","5","5","Akajinimi na kulingalila mulitengeli mola, akaiweni itambala ya sanda mkati mola, nambu ngacheajingile. ");
INSERT INTO mpa_vpl VALUES ("JN20_6","073_20_6","JHN","20","6","6","Simoni Petulu najombi akajengalile, akajingili mkati ja litengeli, na akaiweni itambala ya sanda yela mkati ja litengele, ");
INSERT INTO mpa_vpl VALUES ("JN20_7","073_20_7","JHN","20","7","7","na chitambala chechakabhi bhahyongalwi pamutu jaka Yesu. Ngachechaghonili papamu na itambala ya sanda yela, nambu chakabhi chikunjakiki na kubhekakeka kutali pandu pa kanjika jaki. ");
INSERT INTO mpa_vpl VALUES ("JN20_8","073_20_8","JHN","20","8","8","Bhela mbulwa jongi joakalonguli kuhika palitengeli jola, najombi akajingili mkati, akaweni, na kuhobhalela. ");
INSERT INTO mpa_vpl VALUES ("JN20_9","073_20_9","JHN","20","9","9","Maghambu mbaka chikahi chenihechi bhakabhi bhakali ngakumanya Malembu Mahuhu ghala kubha, ikabhi impalika Yesu ayokaje kabhete kuhuma kwa bhakuwa. ");
INSERT INTO mpa_vpl VALUES ("JN20_10","073_20_10","JHN","20","10","10","Bhela bhabhulwa bhala bhakakelawiki kabhete kunyumba jabhu. ");
INSERT INTO mpa_vpl VALUES ("JN20_11","073_20_11","JHN","20","11","11","Nambu Malia akabhi ajemiki pambipi na litengeli akalelaje. Chikahi paakabhi alela, akajinimi na kulingalila mkati ja litengeli. ");
INSERT INTO mpa_vpl VALUES ("JN20_12","073_20_12","JHN","20","12","12","Akabhaweni bhatumika bhabheli bha kunani kwaka Chapanga, bhawati ingobhu ihuhu kupukupu, bhatami pala pabhajighoniki hyegha jaka Yesu, jumu kumutu, na jongi kumagholu. ");
INSERT INTO mpa_vpl VALUES ("JN20_13","073_20_13","JHN","20","13","13","Bhombi bhakumpwaghi Malia, “Mbomba, bho, mbona ulela?” Malia akabhayangike, “Bhumbohiki Bambo wangu, wala nepani ngachemanyi kobhumbekike!” ");
INSERT INTO mpa_vpl VALUES ("JN20_14","073_20_14","JHN","20","14","14","Malia paakajomwi kulonge ghanihagha, akang'anambwiki kunyuma, na kumbona Yesu ajemiki, koni akabya ngakumanya kubha nde Yesu. ");
INSERT INTO mpa_vpl VALUES ("JN20_15","073_20_15","JHN","20","15","15","Yesu akumpwaghile, “Mbomba, bho, ulela kike?” Bho, undonda nane? Jombi koni akaholakya kubha nde mlonda wa chijongu, akumpwaghile, “Nkolongwa, anangati untoliki wehapa, umbwaghilaje paumbekike, nanatu ananuntolaje.” ");
INSERT INTO mpa_vpl VALUES ("JN20_16","073_20_16","JHN","20","16","16","Yesu akumpwaghile, “Malia.” Malia akang'anambwiki, na kumpwaghila kwa Kiebulania, “Laboni!” Yani, “Mbola!” ");
INSERT INTO mpa_vpl VALUES ("JN20_17","073_20_17","JHN","20","17","17","Yesu akumpwaghile, “Ngawingamula, maghambu nakali ngachembiti kwa Atati wangu.” Nambu ujenda kwa bhalongu bhangu ukabhapwaghilaje, “Ng'oloka kujenda kwa Atati wangu, najombi nde Atati winu, na kwaka Chapanga wangu, najombi nde Chapanga winu.” ");
INSERT INTO mpa_vpl VALUES ("JN20_18","073_20_18","JHN","20","18","18","Malia Magidalena akapiti na kubhapwaghila bhabhulwa malobhi, “Numbweni Bambo!” Na kubha ampwaghi mambu ghanihagha. ");
INSERT INTO mpa_vpl VALUES ("JN20_19","073_20_19","JHN","20","19","19","Kukabhi pakamihi, lichobha lela la kutumbula la juma la Jumapile. Bhabhulwa bhaki bhakabhi bhalibhongini papamu, milyangu jakabya jijighaliki kwa ndandi ja kubhajoghopa ihongozi bha Bhayahude. Yesu akahikike, akajemiki pachilanda jabhu, na kubhapwaghila, “Lukwali lubya na mwenga!” ");
INSERT INTO mpa_vpl VALUES ("JN20_20","073_20_20","JHN","20","20","20","Na paakapwaghiki ghanihagha, akabhalangi mabhoku ghaki na indeta jaki. Bhela bhabhulwa bhala bhakahekalili namaa, pabhakumbweni Bambo. ");
INSERT INTO mpa_vpl VALUES ("JN20_21","073_20_21","JHN","20","21","21","Bhela Yesu akabhapwaghi kabhete, “Lukwali lubya na mwenga, ngati Atati moandumi nepani, nepani nanatu nuntuma mwehapa.” ");
INSERT INTO mpa_vpl VALUES ("JN20_22","073_20_22","JHN","20","22","22","Paakajomwi kulonge ghanihagha, akabhapulali na kubhapwaghila, “Njopalyaje Roho Mhuhu. ");
INSERT INTO mpa_vpl VALUES ("JN20_23","073_20_23","JHN","20","23","23","Bhokapi bhamwabhokia mahoku, bhabhohakike, na bhokapi bhamwakongila mahoku, bhakongakike.” ");
INSERT INTO mpa_vpl VALUES ("JN20_24","073_20_24","JHN","20","24","24","Nambu Tomaso, jumu wa bhabhulwa komi na bhabheli bhala, joalowakika Mabhela, ngacheakabhi papamu nabhu chikahi pahikika Yesu. ");
INSERT INTO mpa_vpl VALUES ("JN20_25","073_20_25","JHN","20","25","25","Bhela bhabhulwa bhangi bhakumpwaghile, “Tumbweni Bambo.” Tomaso akabhapwaghile, “Nepani nangakughabhona makumba gha misumali mumabhoku ghaki, na kubheka lukonji lwangu pa likumba la misumali, na kubheka lukonji lwangu pa indeta jaki, nganhobhaleli hata pachokope.” ");
INSERT INTO mpa_vpl VALUES ("JN20_26","073_20_26","JHN","20","26","26","Paghapetiki machobha nane, bhabhulwa bhaki bhakabhi mkati kabhete, na Tomaso akabya papamu nabhu. Bhela Yesu akahikike, na milyangu jijighalike, akajemiki pachilanda jabhu, na kupwagha, “Lukwali lubya na mwenga.” ");
INSERT INTO mpa_vpl VALUES ("JN20_27","073_20_27","JHN","20","27","27","Bhela akumpwaghi Tomaso, “Uletaje pambani lukonji lwaku, na ughalinga mabhoku ghangu, uletaje na chiwoku chaku ukamulaje mu indeta jangu, wala ngawikubha na choghohi, nambu uhobhalyaje.” ");
INSERT INTO mpa_vpl VALUES ("JN20_28","073_20_28","JHN","20","28","28","Tomaso akayangiki, na kumpwaghila, “Bambo wangu na Chapanga wangu!” ");
INSERT INTO mpa_vpl VALUES ("JN20_29","073_20_29","JHN","20","29","29","Yesu akumpwaghi Tomaso, “Bho, wehapa le uhobhalili maghambu utehi kumona? Bhapengaliki bhala bhanga kumona, nambu bhahobhalela.” ");
INSERT INTO mpa_vpl VALUES ("JN20_30","073_20_30","JHN","20","30","30","Bhela kubhi kabhete na nginyulila yengi yamaheli yeakahengiki Yesu palongi ja bhabhulwa bhaki, yangakulembakeka mu chitabu chenu. ");
INSERT INTO mpa_vpl VALUES ("JN20_31","073_20_31","JHN","20","31","31","Nambu yenjenu ilembakiki nahuli mmanya kubha Yesu nde Kristo, Mwana waka Chapanga, na kwa kunhobhalela jombi mbya na womi wa chakaka kwa kupetela lihina laki. ");
INSERT INTO mpa_vpl VALUES ("JN21_1","073_21_1","JHN","21","1","1","Paghapetiki mambu ghanihagha Yesu akalilangi kabhete kwa bhabhulwa bhaki, pamaheku ja Bahali ja Tibelia, najombi akabhonakini ana: ");
INSERT INTO mpa_vpl VALUES ("JN21_2","073_21_2","JHN","21","2","2","Simoni Petulu, na Tomaso joalowakeka Mabhela, na Nathanaeli wa ku Kana ja ku Galilaya, na bhana bhabheli bhaka Zebedayo, na bhabhulwa bhangi bhabheli, bhakabhi papamu. ");
INSERT INTO mpa_vpl VALUES ("JN21_3","073_21_3","JHN","21","3","3","Simoni Petulu akabhapwaghi bhajaki, “Nyenda kulobha homba.” Nabhombi bhakumpwaghile, “Natatu anatujenda papamu na wehapa.” Bhela bhakabhokiki, bhakakweliki mu liboti, nambu ikilu jela ngachebhapatiki chindu. ");
INSERT INTO mpa_vpl VALUES ("JN21_4","073_21_4","JHN","21","4","4","Lukela pakwachile, Yesu akajemiki mumaheku, nambu bhabhulwa ngachebhamanyi kubha akabhi nde Yesu. ");
INSERT INTO mpa_vpl VALUES ("JN21_5","073_21_5","JHN","21","5","5","Bhela Yesu akabhapwaghile, “Bhanango, bho, mbi na homba?” Bhakamuyangiki, “Njeta.” ");
INSERT INTO mpa_vpl VALUES ("JN21_6","073_21_6","JHN","21","6","6","Yesu akabhapwaghile, “Mpendakya nkwabhu upambala wa kumalelelu wa liboti linu, nanamu anampata homba.” Bhela bhakapendakili, wala sajenu ngachebhaweziki kuhuta kabhete kwa ndandi ja kujoloka kwa homba. ");
INSERT INTO mpa_vpl VALUES ("JN21_7","073_21_7","JHN","21","7","7","Bhela mbulwa joakapalakiki na Yesu jola akumpwaghi Petulu, “Nde Bambo!” Najombi Simoni Petulu paakajowini kubha nde Bambo, akalikongiki ingobhu jaki, maghambu akahuliki ingobhu ja kunja, na kulilekela mubahali. ");
INSERT INTO mpa_vpl VALUES ("JN21_8","073_21_8","JHN","21","8","8","Bhabhulwa bhangi bhala bhakahikiki na liboti heli, maghambu bhakabhi nga kutali na kumaheku, nambu bhakabhi ngati utali wa mita mia moja kuhuma kundema, koni bhakahuta nkwabhu wana homba. ");
INSERT INTO mpa_vpl VALUES ("JN21_9","073_21_9","JHN","21","9","9","Bhela pabhaheli kumaheku, bhakauweni moto wa makalakala, na panani jaki bhajochiki homba, na libumunda. ");
INSERT INTO mpa_vpl VALUES ("JN21_10","073_21_10","JHN","21","10","10","Yesu akabhapwaghile, “Ndeta pambani homba yakumu yendobhiki sajeno.” ");
INSERT INTO mpa_vpl VALUES ("JN21_11","073_21_11","JHN","21","11","11","Simoni Petulu akakweliki mu liboti, akauhutiki nkwawu kumaheku, utweli homba ikoluikolu, mia moja hamsini na tatu. Hata koni homba ikabhi yamaheli ntundu ghonihoghu, nambu nkwabhu ngachewakachwike. ");
INSERT INTO mpa_vpl VALUES ("JN21_12","073_21_12","JHN","21","12","12","Yesu akabhapwaghile, “Nhwika nkula chilebhi cha lukela.” Wala nga mundu pachilanda ja bhabhulwa bhala joakalengiki kundalukila kubha wehapa wa nane, maghambu bhakamanyi kubha nde Bambo. ");
INSERT INTO mpa_vpl VALUES ("JN21_13","073_21_13","JHN","21","13","13","Yesu akahikiki, na kutola libumunda, na kubhapekeha, na homba akahengiki bhelabhela. ");
INSERT INTO mpa_vpl VALUES ("JN21_14","073_21_14","JHN","21","14","14","Haje jakabhi mala ja katatu kwaka Yesu kubhapitalila bhabhulwa bhaki, kutumbula paakahyokiki kuhuma kwa bhakuwa. ");
INSERT INTO mpa_vpl VALUES ("JN21_15","073_21_15","JHN","21","15","15","Bhela pabhakajomwi kula, Yesu akumpwaghi Simoni Petulu, “Simoni mwana waka Yohana! Bho, umbala nepani kuliku bhanganya abhabha?” Petulu akayangiki, “Ena, Bambo, wehapa umanyi kubha nukupala.” Yesu akumpwaghile, “Ulehaje mambelele ghangu!” ");
INSERT INTO mpa_vpl VALUES ("JN21_16","073_21_16","JHN","21","16","16","Akumpwaghi kabhete pakabheli, “Simoni mwana waka Yohana! Bho, umbala nepani?” Petulu akayangiki, “Ena, Bambo, wehapa umanyi kubha nukupala!” Yesu akumpwaghile, “Ulehaje mambelele ghangu!” ");
INSERT INTO mpa_vpl VALUES ("JN21_17","073_21_17","JHN","21","17","17","Yesu akundaluki kabhete pakatatu, “Simoni mwana waka Yohana! Bho, umbala nepani?” Petulu akayomike maghambu akundaluki pakatatu, “Bho, umbala nepani?” Bhela akumpwaghile, “Bambo, wehapa umanyi ghokapi, wehapa umanyi kubha nukupala.” Yesu akumpwaghile, “Ulehaje mambelele ghangu!” ");
INSERT INTO mpa_vpl VALUES ("JN21_18","073_21_18","JHN","21","18","18","Nukupwaghi chakaka, paukabhi unkombo, ukabhi ulikonga wamwete na kujenda koupala. Nambu pawibya ukongapile, wihatambula mabhoku ghaku, na jongi anaakukongaje na kukupeleka kwanga kupala wehapa kujenda. ");
INSERT INTO mpa_vpl VALUES ("JN21_19","073_21_19","JHN","21","19","19","Kwa kupwagha malobhi ghanihagha, Yesu akalangi kubha kwa ntundu bhole Petulu anakuwaje nahuli kundumbali Chapanga. Bhela paakalongi ghanihagha, Yesu akumpwaghi Petulu, “Unyengalyaje!” ");
INSERT INTO mpa_vpl VALUES ("JN21_20","073_21_20","JHN","21","20","20","Petulu akang'anambwiki na kumbona mbulwa jola joakapalakiki na Yesu. Jonihoju nde mbulwa jola joakajeghamaki pachihimba chaka Yesu chikahi cha kula chilebhi cha pakamihi, na kulalukila, “Bambo, bho, nane joakung'anambukaje?” ");
INSERT INTO mpa_vpl VALUES ("JN21_21","073_21_21","JHN","21","21","21","Bhela Petulu paakumbweni jonihoju, akumpwaghi Yesu, “Bambo, na ajoju anaatenda kike?” ");
INSERT INTO mpa_vpl VALUES ("JN21_22","073_21_22","JHN","21","22","22","Yesu akumpwaghile, “Ngati anambaliki ajoju atama mbaka panihikaje, bho, wehapa upala kike? Wehapa unyengalya nepani.” ");
INSERT INTO mpa_vpl VALUES ("JN21_23","073_21_23","JHN","21","23","23","Bhela lilobhi leniheli lakajaghani pachilanda ja bhahobhalela kubha mbulwa jola ngaakuwe. Nambu Yesu ngacheakumpwaghi kubha ngaakuwe, nambu, “Ngati anambaliki ajoju atama mbaka panihikaje, bho, wehapa upala kike?” ");
INSERT INTO mpa_vpl VALUES ("JN21_24","073_21_24","JHN","21","24","24","Hajoju nde mbulwa jola joaghalandila mambu ghanihagha, na nde joaghalembiki mambu ghanihagha. Natatu tumanyi kubha ghaaghapwaghiki nde gha chakaka. ");
INSERT INTO mpa_vpl VALUES ("JN21_25","073_21_25","JHN","21","25","25","Kubhi kabhete na mambu ghangi ghamaheli ghaakahengiki Yesu. Ghaghu anangati ghakalembakiki limu limu, nholake hata ndema wokapi ngaukajaghanile kwa itabu yela yeikalembakikaje. Amina.");
INSERT INTO mpa_vpl VALUES ("AC1_1","074_1_1","ACT","1","1","1","Unkolongwa Teofile: Mu chitabu changu cha kutumbula, nakakulembi kubhokana na mambu ghokapi Yesu ghaakatumbwi kuhenga na kubhola kutumbu chikahi paatumbulaje lihengu laki, ");
INSERT INTO mpa_vpl VALUES ("AC1_2","074_1_2","ACT","1","2","2","mbaka lichobha leatolakikaje kujenda kunani kumahunde. Mangani ja kubhoka kwaki, kwa makili ghaka Roho Mhuhu, Yesu akabhalaghalaki bhandu bhaakahawile kubha mitumi bhaki. ");
INSERT INTO mpa_vpl VALUES ("AC1_3","074_1_3","ACT","1","3","3","Kwa machobha alobaini baada ja kupotela akabhapitali mala jamahele kwa ntundu ghoulangia chakaka kubha jombi akabhi mwome. Bhakumbweni, najombi akalongi nabhu panani ja Ukolongwa waka Chapanga. ");
INSERT INTO mpa_vpl VALUES ("AC1_4","074_1_4","ACT","1","4","4","Chikahi chimu Yesu paakahimangini nabhu akabhalaghalaki anana: “Ngamwibhoka mu Yelusalemu, nambu mlendalyaje nhupu ghoakapwaghiki Atati wangu, ambau mwanyowini nakalongalyaje panani jake. ");
INSERT INTO mpa_vpl VALUES ("AC1_5","074_1_5","ACT","1","5","5","Kabheti Yohana abatiza kwa machi, nambu pa machobha machokopi ghaghahika, mabhanganya anambatizwaje kwa Roho Mhuhu.” ");
INSERT INTO mpa_vpl VALUES ("AC1_6","074_1_6","ACT","1","6","6","Bhela, mitumi bhaki pabhakabhi bhalibhongini papamu, bhakundaluki Yesu, “Bambo, bho, chikahi chenje le nde paukelabhuha ukolongwa ghola kwa bhandu bha ku Izilaeli?” ");
INSERT INTO mpa_vpl VALUES ("AC1_7","074_1_7","ACT","1","7","7","Nambu Yesu akabhapwaghile, “Chikahi chenihechi chibhi pahi ja lujiniku lwa Atati wangu, kabheti nga lihengu linu kumanya ghibya lile. ");
INSERT INTO mpa_vpl VALUES ("AC1_8","074_1_8","ACT","1","8","8","Nambu chikahi Roho Mhuhu paanhelalya mwehapa, mwijopalya makili kabheti mwibya bhalandilu bhangu ku Yelusalemu, na ku muchi wokapi wa ku Yudea na ku Samalia, kabheti mbaka kumajomukanelu gha ndema wokapi.” ");
INSERT INTO mpa_vpl VALUES ("AC1_9","074_1_9","ACT","1","9","9","Paakajomwili kulonge ghanihagha, koni bhokapi bhundingalila, Yesu akatolakiki kujenda kunani kumahunde, na lihundi lakunhiiki ngabhumbona kabhete. ");
INSERT INTO mpa_vpl VALUES ("AC1_10","074_1_10","ACT","1","10","10","Pabhakabhi bhakali kulingalila kunani kumahunde, paakabhi ajenda jake, palapala bhandu bhabheli bhabhawati ingobhu ihuhu kupukupu bhakajemiki pambipi nabhu, ");
INSERT INTO mpa_vpl VALUES ("AC1_11","074_1_11","ACT","1","11","11","bhakapwaghike, “Mwe mabhandu bha ku Galilaya! Bho, mbona njemane mwakalingalya kunani kumahunde? Yesu ajo joatolakiki kwinu kujenda kunani kumahunde, anahika kabheti ngati bhelabhela momumbonile akajenda kunani kumahunde.” ");
INSERT INTO mpa_vpl VALUES ("AC1_12","074_1_12","ACT","1","12","12","Panihapa mitumi bhala bhakakelawiki ku Yelusalemu kuhumi ku Chitombi cha Mizeituni chekibhi pambipi kilometa jimu kuhuma ku muchi. ");
INSERT INTO mpa_vpl VALUES ("AC1_13","074_1_13","ACT","1","13","13","Pabhakahiki mu muchi bhakajingi mu chumba cha kugholofa mobhatamikaje, nabhombi bhakabhi Petulu, Yohana, Yakobo, Andulea, Filipo na Tomaso, Batolomayo na Matayo, Yakobo mwana waka Alufayo, Simoni Zelote na Yuda mwana waka Yakobo. ");
INSERT INTO mpa_vpl VALUES ("AC1_14","074_1_14","ACT","1","14","14","Bhanganya habha bhokapi bhakalibhongini papamu bhakundobha Chapanga, papamu na akamabhu bhamahele, na Malia mabhu waka Yesu, na bhalongu bhaki. ");
INSERT INTO mpa_vpl VALUES ("AC1_15","074_1_15","ACT","1","15","15","Lichobha limu la palongolo, Petulu akajemiki pachilanda ja bhalongu bhaki bhahobhalela bhabhakabhi bhalibhongine, bhokapi bhakabhi ngati bhandu mia moja na ishilini. ");
INSERT INTO mpa_vpl VALUES ("AC1_16","074_1_16","ACT","1","16","16","Petulu akapwaghiki, “Bhalongu bhango, jakabhi lazima pandu pa Malembu Mahuhu ghatimiaje, kwa malobhi ghaka Roho Mhuhu kupetela kwaka Daude, akalotiki malobhi ghaka Yuda jola joabhalongua bhandu bhabhunkamula Yesu. ");
INSERT INTO mpa_vpl VALUES ("AC1_17","074_1_17","ACT","1","17","17","Yuda akabhi jumu wa lipogha litu, ndandi najombi akahaghuliki akamulaje lihengu litu.” ");
INSERT INTO mpa_vpl VALUES ("AC1_18","074_1_18","ACT","1","18","18","Jombi akahemi ngonda kwa mbija yela yeakapatiki kubhokana na lihengu lihakau, akabya kungonda hoku akaawiki pahi puu, akapojwiki na matumbu ghaki ghakajitiki kunja. ");
INSERT INTO mpa_vpl VALUES ("AC1_19","074_1_19","ACT","1","19","19","Bhandu bhokapi bhabhatamika ku Yelusalemu bhakajowini malobhi ghanihagha na bhela, kwa lugha jabhu, bhakaulohiki ngonda ghola Akelidama, ndandi jaki, “Ngonda wa Mwahi.” ");
INSERT INTO mpa_vpl VALUES ("AC1_20","074_1_20","ACT","1","20","20","“Henu, ngati moilembakike mu chitabu cha Zabuli, ‘Matamu ghaki anaghahighalya ukebha, mundu jokapi ngaitama mkati jake.’ Kabheti ilembakiki, ‘Mundu jongi atola pandu paki pa lihengu.’ ");
INSERT INTO mpa_vpl VALUES ("AC1_21","074_1_21","ACT","1","21","21","“Henu mundu jumu joakabhi alongana papamu na tepani chikahi chokapi Bambo Yesu pajendika mwanja waki papamu na tepani ahaghulikaje kulongana na tepani. ");
INSERT INTO mpa_vpl VALUES ("AC1_22","074_1_22","ACT","1","22","22","Jonihoju, apalika abya jumu pachilanda ja bhandu bhabhalonganaje na tepani kutumbu Yohana paakabhi abatiza mbaka lichobha Yesu paatolakikaje kuhuma kwitu kujenda kunani kumahunde. Jonihoju anabyaje mlandilu papamu na tepani kuhenga lihengu la kubhatangazi bhandu kuhyoka kwaka Yesu.” ");
INSERT INTO mpa_vpl VALUES ("AC1_23","074_1_23","ACT","1","23","23","Panihapa, bhakalowi mahina gha bhandu bhabhele, wa kutumbula Yusufu joalowakika Basaba au Yusto na wa kabhele akabhi Matia. ");
INSERT INTO mpa_vpl VALUES ("AC1_24","074_1_24","ACT","1","24","24","Panihapa bhakundobhiki Chapanga, na kupwagha, “Bambo, wehapa ujimanyi mitima ja bhandu bhokapi, henu utulangiaje unhawi jwaku pachilanda ja bhandu bhabheli abhabha, ");
INSERT INTO mpa_vpl VALUES ("AC1_25","074_1_25","ACT","1","25","25","nahuli atola pandu pa lihengu la utumi waku ghoaulekiki Yuda akajenda pandu paki mwene.” ");
INSERT INTO mpa_vpl VALUES ("AC1_26","074_1_26","ACT","1","26","26","Bhakalapwi kura, na kura jakumpatiki Matia, najombi akajonjukiki kwa mitumi bhangi komi na jumu. ");
INSERT INTO mpa_vpl VALUES ("AC2_1","074_2_1","ACT","2","1","1","Lichobha la Pentekoste palahikile, bhahobhalela bhokapi bhakalibhongini pandu pamo. ");
INSERT INTO mpa_vpl VALUES ("AC2_2","074_2_2","ACT","2","2","2","Chikahi chelachela, saute jakajowaniki kuhuma kunani kumahunde, saute jejabhi ngati ja kupogha kwa mpongu ukale, na kujitwelakela nyumba jokapi mobhatami mola. ");
INSERT INTO mpa_vpl VALUES ("AC2_3","074_2_3","ACT","2","3","3","Kabheti ikapitali hindu yeyabhonakini ngati lulimi lwa moto, ikapechangini na kumetela panani jaka kila jumu wabhu. ");
INSERT INTO mpa_vpl VALUES ("AC2_4","074_2_4","ACT","2","4","4","Bhokapi bhakatwelakiki Roho Mhuhu, bhakatumbwi kulongela kwa lugha nayenge, ngati Roho Mhuhu moabhalongui kuloghola. ");
INSERT INTO mpa_vpl VALUES ("AC2_5","074_2_5","ACT","2","5","5","Bhela ku Yelusalemu hoku bhakabhi Bhayahude, bhandu bhabhunjojabhe Chapanga, bhabhahumiki ku kila inchi ja pundema pani. ");
INSERT INTO mpa_vpl VALUES ("AC2_6","074_2_6","ACT","2","6","6","Pabhajowini sauti jeniheje, lipogha likolongwa la bhandu bhakahimangini pamo. Bhokapi bhakakangichi namaa, maghambu kila jumu wabhu akabhajowini bhahobhalela habha bhakapwaghaje kwa lugha jaki mwene. ");
INSERT INTO mpa_vpl VALUES ("AC2_7","074_2_7","ACT","2","7","7","Bhakabya bhakangacha bhakalalukile, “Bho, bhanganya abhabha bhokapi bhatubhajowana bhakapwagha ana le nga bhenei bha ku Galilaya? ");
INSERT INTO mpa_vpl VALUES ("AC2_8","074_2_8","ACT","2","8","8","Bho, kubhi bholi henu, kubha kila jumu witu tubhajowana bhakapwaghaje kwa lugha jitu tabhete ja kubhelakeka nako? ");
INSERT INTO mpa_vpl VALUES ("AC2_9","074_2_9","ACT","2","9","9","Bhangi bhitu nde Bhapalasi, Bhaamedi na Bhaelami, bhangi bha ku Mesopotamia, ku Yudea, ku Kapodokia, ku Ponto na ku Asia, ");
INSERT INTO mpa_vpl VALUES ("AC2_10","074_2_10","ACT","2","10","10","kuhuma ku Filigia na ku Pamfilia, kuhuma ku Misili na ku pandu pa ku Libia pambipi na ku Kilene, bhangi bhitu bhagheni kuhuma ku Loma. ");
INSERT INTO mpa_vpl VALUES ("AC2_11","074_2_11","ACT","2","11","11","Bhayahude na bhandu bhangakubha Bhayahude bhabhajengalili dini ja Kiyahude na bhangi bha kuhumi ku Kilete na Bhaalabu. Tepani tabhokapi tubhajowana bhakapwaghaje kwa lugha hitu tabhete mambu makolongwa ghaka Chapanga.” ");
INSERT INTO mpa_vpl VALUES ("AC2_12","074_2_12","ACT","2","12","12","Bhokapi bhakakangichi na kuhangajika koni bhakalaluwanaje, “Bho, mambu aghagha ndandi jaki kike?” ");
INSERT INTO mpa_vpl VALUES ("AC2_13","074_2_13","ACT","2","13","13","Nambu bhangi bhakabhalongimi bhakapwaghaje, “Bhandu abhabha bhalobhi uwembe!” ");
INSERT INTO mpa_vpl VALUES ("AC2_14","074_2_14","ACT","2","14","14","Panihapa Petulu akajemiki papamu na mitumi komi na jumu bhala, akatumbwi kulitangazila lipogha la bhandu kwa kujamalila, akapwaghaje, “Mwenga mabhandu bha Yudea, na mabhandu mwentamani pani pa Yelusalemu, njowanyaje wichu malobhi ghanumpwaghila. ");
INSERT INTO mpa_vpl VALUES ("AC2_15","074_2_15","ACT","2","15","15","Bhandu abhabha ngachebhalobhi ngati monhwambukila, kwa ndandi sajenu nde saa tatu pela ja lukela! ");
INSERT INTO mpa_vpl VALUES ("AC2_16","074_2_16","ACT","2","16","16","Ngabhela, nambu lijambu lendenu nde lela leakalotiki mlota Yoeli, akapwaghaje: ");
INSERT INTO mpa_vpl VALUES ("AC2_17","074_2_17","ACT","2","17","17","‘Mu machobha gha kujomukela, apwagha Chapanga, ananabhajitalya bhandu bhokapi Roho jangu. Bhana bhinu akakombu na akakamwali anabhalotaje, akakombu bhinu bhibhona mabhono, na bhazee bhinu anabhalota ndoto. ");
INSERT INTO mpa_vpl VALUES ("AC2_18","074_2_18","ACT","2","18","18","Ena, hata bhatumika bhangu bha chikambaku na bha chimbomba, ananabhajitalya Roho jangu machobha ghanihagha, na bhombi anabhalotaje. ");
INSERT INTO mpa_vpl VALUES ("AC2_19","074_2_19","ACT","2","19","19","Ananangia ngangachu kunani kumahunde, na nginyulila pahi pundema, kwibya na mwahi, moto na lyohi likolongwa. ");
INSERT INTO mpa_vpl VALUES ("AC2_20","074_2_20","ACT","2","20","20","Lyobha analijeghalika lwihi, na mwehi wibya ukeli ngati mwahi, mangane ja kuhika lichobha likolongwa na la ulumbalilu laka Bambo. ");
INSERT INTO mpa_vpl VALUES ("AC2_21","074_2_21","ACT","2","21","21","Panihapa, mundu jokapi joayilobhaje kwa lihina laka Bambo, anaakengaliwaje.’ ");
INSERT INTO mpa_vpl VALUES ("AC2_22","074_2_22","ACT","2","22","22","“Mabhandu bha Izilaeli, njowanyaje malobhi ghangani ghanongela! Yesu wa ku Nazaleti akabhi mundu joakayekuliwi palanga na Chapanga palongi jinu kwa indela ja ngangachu, na nginyulila ambayu Chapanga akahengiki kupetela kwaki ngati mommanyi mabhete. ");
INSERT INTO mpa_vpl VALUES ("AC2_23","074_2_23","ACT","2","23","23","Kubhokana na mpangu waki mweni Chapanga akajomwi kumanya kubha Yesu anakamulikaje mu mabhoku ghinu, na mabhanganya unhwamulaje kunkoma kwa kubhalekela bhandu bhahakau bhunhwambaje punsalaba. ");
INSERT INTO mpa_vpl VALUES ("AC2_24","074_2_24","ACT","2","24","24","Nambu Chapanga akamuhyohiki kuhuma kwa bhakuwa, akunkengalili kuhuma mu mabhinilu gha nyiwa kwa ndandi ngachekwawezakini jombi akamulikaje na makili gha nyiwa. ");
INSERT INTO mpa_vpl VALUES ("AC2_25","074_2_25","ACT","2","25","25","Kwa ndandi Daude akalongi panani jaki anana, ‘Nakumbweni Bambo palongi jangu machobha ghokapi, abhi na nepani upambala wangu wa kumalelelu hata nganinyukinyuke. ");
INSERT INTO mpa_vpl VALUES ("AC2_26","074_2_26","ACT","2","26","26","Henu mtima wangu ukahekalile, na kabheti nakalapwi chilulu cha kuhekalela. Hyegha jangu najombi anajitamaje mu mahobhalelu. ");
INSERT INTO mpa_vpl VALUES ("AC2_27","074_2_27","ACT","2","27","27","Maghambu ngaujileki roho jangu kuwawa, wala kujetakela Mhuhu waku abholaje. ");
INSERT INTO mpa_vpl VALUES ("AC2_28","074_2_28","ACT","2","28","28","Unangihi indela ja womi, anaundwelakyaje chiheku kwa kubha palongi jaku.’ ");
INSERT INTO mpa_vpl VALUES ("AC2_29","074_2_29","ACT","2","29","29","“Mwalongu bhangu Bhaizilaeli, mbala kumpwaghi chakaka kubhokana na mambu ghaghumpatiki nkolongwa Daude, hokolu witu joakamanyakini namaa. Jombi akapotili, na bhakuntaghike, kabheti litengeli laki libhi pani pitu mbaka lalenu. ");
INSERT INTO mpa_vpl VALUES ("AC2_30","074_2_30","ACT","2","30","30","Nambu kwa kubha Daude akabhi mlota waka Chapanga, akamanyiki kubha Chapanga akundapi mbamba ngati ananhaghula jumu wa mbelakeka waki, na kunkweha atama pa chitehu chaki cha ukolongwa. ");
INSERT INTO mpa_vpl VALUES ("AC2_31","074_2_31","ACT","2","31","31","Daude akaweni mangani mambu ghaghitendakikaje kulongi na Chapanga, na henu akapwaghiki panani ja kuhyoka kwaka Kristo pala paakapwaghike, ‘Ngacheakundei kuwawa, hyegha jaki ngachejabholike.’ ");
INSERT INTO mpa_vpl VALUES ("AC2_32","074_2_32","ACT","2","32","32","Bhela, Chapanga akamuhyohiki Yesu, na tepani tabhokapi nde bhalandilu bha lijambu lenihele. ");
INSERT INTO mpa_vpl VALUES ("AC2_33","074_2_33","ACT","2","33","33","Yesu pajomwi kukwela na kubhekakeka na Chapanga upambala waki wa kumalelelu, akajopalili kuhuma kwa Atati jola Roho Mhuhu joakatulaghile, najombi atujitalili Roho hoju. Chenihechi nde chembona sajenu na kujowana. ");
INSERT INTO mpa_vpl VALUES ("AC2_34","074_2_34","ACT","2","34","34","Ndandi Daude mwene, ngacheakwei mbaka kunani kumahunde, nambu jombi akapwaghike, ‘Bambo akumpwaghi Bambo wangu, utama upambala wangu wa kumalelelu, ");
INSERT INTO mpa_vpl VALUES ("AC2_35","074_2_35","ACT","2","35","35","mbaka nabhabhekaje maadui bhaku pahi ja magholu ghaku.’ ");
INSERT INTO mpa_vpl VALUES ("AC2_36","074_2_36","ACT","2","36","36","“Bhandu bhokapi bha ku Izilaeli bhapalika kumanya kwa chakaka kubha hajo Yesu jomunhwambiki punsalaba, Chapanga antehi kubha Bambo na Kristo!” ");
INSERT INTO mpa_vpl VALUES ("AC2_37","074_2_37","ACT","2","37","37","Henu bhandu pabhajowini malobhi ghanihagha, ghakabhabhiniki mitima jabhu, bhakundaluki Petulu na mitumi bhajaki bhala, “Bhalongu bihto, bho, tuhenga kike?” ");
INSERT INTO mpa_vpl VALUES ("AC2_38","074_2_38","ACT","2","38","38","Petulu akabhayangike, “Ng'anambukaje na kughaleka mahoku ghinu na kila jumu winu abatizwaje kwa lihina laka Yesu Kristo nahuli mpata kugholuleka mahoku ghinu na kujopalela nhupu wa Roho Mhuhu. ");
INSERT INTO mpa_vpl VALUES ("AC2_39","074_2_39","ACT","2","39","39","Maghambu chilanga chela chakabhi kwa ndandi jinu, kwa ndandi ja bhana bhinu, kwa ndandi ja bhokapi bhabhatama kutali na kwa ndandi ja kila mundu ambaju Bambo Chapanga witu anaandoa kwake.” ");
INSERT INTO mpa_vpl VALUES ("AC2_40","074_2_40","ACT","2","40","40","Kwa malobhi ghangi ghamaheli, Petulu akabhalakali bhandu akapwaghaje, “Mulijepaje na chibheleku chenjenu chihakau.” ");
INSERT INTO mpa_vpl VALUES ("AC2_41","074_2_41","ACT","2","41","41","Bhandu bhamaheli bhakaghahobhali malobhi ghaki na bhakabatizwe, na bhandu ngati elufu itatu bhakajonjukiki mu lipogha lichobha lenihele. ");
INSERT INTO mpa_vpl VALUES ("AC2_42","074_2_42","ACT","2","42","42","Bhanganya habha bhokapi bhakajendali kulibhola kuhuma mu libholu la mitumi, kutama pamu chilongo, kuheketa libumunda na kundobha Chapanga. ");
INSERT INTO mpa_vpl VALUES ("AC2_43","074_2_43","ACT","2","43","43","Ngangachu yamaheli na nginyulila yakahengakike kwa indela ja mitumi hata kila mundu akabhi na choghoi. ");
INSERT INTO mpa_vpl VALUES ("AC2_44","074_2_44","ACT","2","44","44","Bhahobhalela bhokapi bhakajendali kubha lipogha limu na hindu yabhu bhakaghabhine. ");
INSERT INTO mpa_vpl VALUES ("AC2_45","074_2_45","ACT","2","45","45","Bhombi bhakalombisi hindu yabhu na yokapi yebhakabhi nayu, kabheti bhakaghabhini mbija kulengana na kila mundu moapalilaje. ");
INSERT INTO mpa_vpl VALUES ("AC2_46","074_2_46","ACT","2","46","46","Bhakajendali kuhimangana papamu kila lichobha mu liwangala la Nyumba jaka Chapanga. Nambu chikahi cha kuheketa libumunda, bhakahimangini mu manyumba ghabhu na bhakakuliki chilebhi chenihechi kwa chiheku na kwa mtima wambone, ");
INSERT INTO mpa_vpl VALUES ("AC2_47","074_2_47","ACT","2","47","47","bhakundumbali Chapanga, na bhakapalakiki na bhandu bhokapi. Machobha ghokapi Bambo akajonjukili bhandu mu lipogha bhabhakengaliwaje. ");
INSERT INTO mpa_vpl VALUES ("AC3_1","074_3_1","ACT","3","1","1","Lichobha limu, saa tisa ja muhi, Petulu na Yohana bhakabhi bhajenda ku Nyumba jaka Chapanga, chikahi cha kundobha Chapanga. ");
INSERT INTO mpa_vpl VALUES ("AC3_2","074_3_2","ACT","3","2","2","Chikahi heche bhandu bhakunyamuhini mundu jumu joatengwiki kutumbu kubhelakeka. Bhandu bhanihabha bhumbekika mundu hoju kila lichobha pundyangu wa Nyumba jaka Chapanga ghoulowakikaje, “Ndyangu Unyahi,” nahuli ajopa mbija kwa bhandu bhabhajingalaje mu Nyumba jaka Chapanga. ");
INSERT INTO mpa_vpl VALUES ("AC3_3","074_3_3","ACT","3","3","3","Mundu hoju paabhaweni Petulu na Yohana bhakaheghalya kujingila mu Nyumba jaka Chapanga, akabhajopiki bhumpekya mbija. ");
INSERT INTO mpa_vpl VALUES ("AC3_4","074_3_4","ACT","3","4","4","Petulu na Yohana bhakundingalakili, na Petulu akapwaghike, “Utulingalya tepani!” ");
INSERT INTO mpa_vpl VALUES ("AC3_5","074_3_5","ACT","3","5","5","Jombi akabhalingalile, akalendalya kupata chindu kuhuma kwabho. ");
INSERT INTO mpa_vpl VALUES ("AC3_6","074_3_6","ACT","3","6","6","Henu Petulu akumpwaghile, “Ngachemi na madini gha feza wala zahabu, nambu chemi nachu ananukupekyaje. Kwa lihina laka Yesu Kristo wa ku Nazaleti, ujemaje na ujendaje!” ");
INSERT INTO mpa_vpl VALUES ("AC3_7","074_3_7","ACT","3","7","7","Petulu akunkamwi mundu jola chiwoku chaki cha kumalelelu na kunjangati kujema. Palapala lwaju lwaki na majuwa gha magholu ghaki ghakapatiki makili, ");
INSERT INTO mpa_vpl VALUES ("AC3_8","074_3_8","ACT","3","8","8","akahombiki kujema kwa magholu ghaki, na kutumbu kujenda. Kabheti akajingili mu Nyumba jaka Chapanga papamu na Petulu na Yohana, akajenda na kuhombahomba na koni akundumbalya Chapanga. ");
INSERT INTO mpa_vpl VALUES ("AC3_9","074_3_9","ACT","3","9","9","Bhandu bhokapi bhakumbweni mundu jola akajendaje na koni andumbali Chapanga, ");
INSERT INTO mpa_vpl VALUES ("AC3_10","074_3_10","ACT","3","10","10","bhandu bhakummanyiki kubha jombi nde joakatengwiki joatamika na kujopajopa nhupu pu ndyangu wa Nyumba jaka Chapanga ghoulowakikaje, “Ndyangu Unyahi,” bhakakangichi namaa hata ngachebhamanyi ghaghumpatike. ");
INSERT INTO mpa_vpl VALUES ("AC3_11","074_3_11","ACT","3","11","11","Mundu joatengwiki jola, joalamiki paakabhi alongana na Petulu na Yohana, bhandu bhokapi bhakakangichi namaa, bhakabhakembali mbaka ku Liwangala laka Solomoni. ");
INSERT INTO mpa_vpl VALUES ("AC3_12","074_3_12","ACT","3","12","12","Henu Petulu paakabhaweni bhandu bhanihabha, akabhapwaghile, “Mabhandu bha Izilaeli, bho, maghambu ki nkangachwa na lijambu lendeno? Bho, mbona mtulingalaki nakanopi ngati tuhengiki kwa makili ghitu, au wamboni witu tabhete palongi jaka Chapanga tuntehi mundu jonjo aweza kujenda? ");
INSERT INTO mpa_vpl VALUES ("AC3_13","074_3_13","ACT","3","13","13","Chapanga waka Ibulahimu, Isaka na Yakobo, Chapanga wa akahoko bhitu andumbalili Mwana waki Yesu. Jombi nde jolajola jomukumpeliki mu mabhoku gha bhakolongwa na kunkamu palongi jaka Pilato hata baada jaka Pilato kundekake ajendaje. ");
INSERT INTO mpa_vpl VALUES ("AC3_14","074_3_14","ACT","3","14","14","Mabhanganya mwakunkaniki Mhuhu hoju na Mweni Haki, mkumpaliki mundu jongi joakabhi mkoma bhandu abhopuliwaje. ");
INSERT INTO mpa_vpl VALUES ("AC3_15","074_3_15","ACT","3","15","15","Henu, mukunkomiki Yesu joabhi kutumbula kwa wome. Nambu Chapanga akamuyohiki kuhuma kwa bhakuwa. Na tepani nde bhalandilu bha lijambu lenihele. ");
INSERT INTO mpa_vpl VALUES ("AC3_16","074_3_16","ACT","3","16","16","Lihina laka Yesu na kuhobhalela mu lihina lenihele nde kokumpeki makili mundu jonjo jomumbona na kummanya. Na kwa lihina laka Yesu na uhobhalelu ghouhuma kwaki nde kokundamihi nakanopi mundu jonjo ngati mombone mabhokapi. ");
INSERT INTO mpa_vpl VALUES ("AC3_17","074_3_17","ACT","3","17","17","“Henu mwabhalongu bhangu, mmanyiki ngati mabhanganya papamu na ihongozi bhinu mkahengiki ghanihagha ndandi ngachemwamanye. ");
INSERT INTO mpa_vpl VALUES ("AC3_18","074_3_18","ACT","3","18","18","Nambu kwa indela jenjenu Chapanga nde moakatimizili ghanihagha ghaakatangizi pamwande kwa indela ja bhalota bhaki bhokapi, kubha ikampaliki Kristo waki ang'ahikaje. ");
INSERT INTO mpa_vpl VALUES ("AC3_19","074_3_19","ACT","3","19","19","Henu, mng'ambukaje na kughaleka mahoku ghinu, na nkelebhukaje kwaka Chapanga nahuli jombi andekakyaje mahoku ghinu. ");
INSERT INTO mpa_vpl VALUES ("AC3_20","074_3_20","ACT","3","20","20","Muhenga bhenibhela nahuli Bambo ampekya chikahi cha kuhekalela muntima na kundetela Kristo jola joanchawile ambaju nde Yesu. ");
INSERT INTO mpa_vpl VALUES ("AC3_21","074_3_21","ACT","3","21","21","Impaliki Yesu ahighalya kunani kumahunde mbaka pachihika chikahi cha kulenganakeka hindu yokapi, ngati Chapanga moakapwaghile kwa indela ja bhalota bhaki bhahuhu kutumbu pamwande. ");
INSERT INTO mpa_vpl VALUES ("AC3_22","074_3_22","ACT","3","22","22","Ndandi Musa akapwaghike, ‘Bambo Chapanga winu anaampelakyaje mlota ngati nepani kuhuma kwinu mabhete. Mwipalika kunjowanela kila chindu cheampwaghilaje kuhenga. ");
INSERT INTO mpa_vpl VALUES ("AC3_23","074_3_23","ACT","3","23","23","Mundu jokapi joanakanaje kunjowanela mlota hoju, anaayonangikaje na kutengakeka kutali nakanope na bhandu bhaki.’ ");
INSERT INTO mpa_vpl VALUES ("AC3_24","074_3_24","ACT","3","24","24","Bhalota bhokapi, kutumbu Samweli na bhokapi bhabhakanjengalili palongi jaki, bhakalotiki malobhi ghokapi ghaghahengakeka machobha ghani. ");
INSERT INTO mpa_vpl VALUES ("AC3_25","074_3_25","ACT","3","25","25","Chilanga yela yeakabhohiki Chapanga kwa indela ja bhalota bhaki nde hinu, na kabhete lilaghilu lela leakahengiki Chapanga na akahokolu bhinu nde linu. Ngati moakumpwaghili Ibulahimu, ‘Kwa indela ja chibheleku chaku, bhandu bhokapi bha pundema anabhapengaliwaje.’ ");
INSERT INTO mpa_vpl VALUES ("AC3_26","074_3_26","ACT","3","26","26","Henu, Chapanga akamuyohiki Yesu Mwana waki, na kuntuma kwinu hoti, akuntumiki nahuli andetila upengalelu kwa kuntenda kila jumu winu aghalekaje mahakau ghaki.” ");
INSERT INTO mpa_vpl VALUES ("AC4_1","074_4_1","ACT","4","1","1","Petulu na Yohana pabhakabhi bhakali kubhatangazi bhandu, bhapenganyambiku bhakolongwa, chiongozi wa manjolinjoli wa Nyumba jaka Chapanga, papamu na Masadukayo bhakumu bhakabhahikile. ");
INSERT INTO mpa_vpl VALUES ("AC4_2","074_4_2","ACT","4","2","2","Bhakayomiki namaa ndandi mitumi bhaka Yesu habha bhabhatangazya bhandu kubha Yesu akayokiki kuhuma kwa bhakuwa, chihengu chechilangia hotuhotu kubha bhandu bhabhapotili anabhayokaje. ");
INSERT INTO mpa_vpl VALUES ("AC4_3","074_4_3","ACT","4","3","3","Henu bhakabhakamwi Petulu na Yohana na ndandi ikilu ukaheghalile, bhakabhabhei muchifungo mbaka chilabhu jaki. ");
INSERT INTO mpa_vpl VALUES ("AC4_4","074_4_4","ACT","4","4","4","Nambu bhandu bhamaheli bhabhakajowini malobhi ghaka Petulu na Yohana bhakahobhalile, kwa kubhalangika bhakabhi ngati akanalomi elufu nhwano. ");
INSERT INTO mpa_vpl VALUES ("AC4_5","074_4_5","ACT","4","5","5","Chilabhu jaki ihongozi bha Bhayahude, bhazee, na bhabhola bha Shelia bhakahimangini papamu ku Yelusalemu. ");
INSERT INTO mpa_vpl VALUES ("AC4_6","074_4_6","ACT","4","6","6","Bhakahimangini papamu na Anasi Mpenganyambiku Nkolongwa, Kayafa, Yohana, Alekizanda, na bhandu bhangi bhalongu bhaka Mpenganyambiku Nkolongwa. ");
INSERT INTO mpa_vpl VALUES ("AC4_7","074_4_7","ACT","4","7","7","Pabhakabhajemiki Petulu na Yohana pachilanda jabhu, bhakabhalalukile, “Bho, mabhanganya muhengiki lijambu lendenu kwa makili bholi na kwa lihina laka nane?” ");
INSERT INTO mpa_vpl VALUES ("AC4_8","074_4_8","ACT","4","8","8","Panihapa Petulu akabya atwelakiki Roho Mhuhu, akabhayangike, “Ihongozi na bhazee bha bhandu bha Izilaeli, ");
INSERT INTO mpa_vpl VALUES ("AC4_9","074_4_9","ACT","4","9","9","anamutulaluki lalenu panani ja lijambu la wichu letunhengi mundu joakabhi atengwiki jola na moapati kubha mwome, ");
INSERT INTO mpa_vpl VALUES ("AC4_10","074_4_10","ACT","4","10","10","henu, imanyikana kwinu mabhanganya na bhandu bhokapi bha Izilaeli kubha, mundu jonjo alamiki nakanopi kwa makili na lihina laka Yesu Kristo wa ku Nazaleti, jomukunhwambiki mabhanganya punsalaba, nambu Chapanga akamuyohiki kuhuma kwa bhabhawile. ");
INSERT INTO mpa_vpl VALUES ("AC4_11","074_4_11","ACT","4","11","11","Ajoju nde joghakolabheka Malembu Mahuhu, ‘Liganga lemulikaniki mwabhachenga, sajenu libhi liganga likolongwa la kunkeghe.’ ");
INSERT INTO mpa_vpl VALUES ("AC4_12","074_4_12","ACT","4","12","12","Kabheti ukengaleku ngachekupatikana kwaka mundu jongi jokapi jola, maghambu pundema pokapi bhandu ngachebhapatiki lihina laka mundu jokapi jola leliweza kutukengalela twabhandu.” ");
INSERT INTO mpa_vpl VALUES ("AC4_13","074_4_13","ACT","4","13","13","Ihongozi bha pachengu pabhaweni ukangamalu waka Petulu na Yohana na kumanya kubha bhakabhi bhandu bha pahi na bhangakubha na malangu, bhakakangichi namaa, na bhakamanyiki kubha bhandu bhanihabha bhakabhi papamu na Yesu. ");
INSERT INTO mpa_vpl VALUES ("AC4_14","074_4_14","ACT","4","14","14","Bhela pabhakumbweni mundu joalamiswi ajemi papamu na Petulu na Yohana, ngachebhaweziki kulonge lilobhi lokapi lela la kubhapenga. ");
INSERT INTO mpa_vpl VALUES ("AC4_15","074_4_15","ACT","4","15","15","Bhakabhapwaghi bhapitaje mu chumba cha pachengu, bhombi bhakahighali mkati ja chumba bhakalongila bheni kwa bheni. ");
INSERT INTO mpa_vpl VALUES ("AC4_16","074_4_16","ACT","4","16","16","Bhakalaluwine, “Bho, tubhahenga kiki bhandu abhabha? Kila mundu joatama mu Yelusalemu amanyiki chakaka ngati ukangachu ghongo ukolongwa bhuhengike, na tepani ngatuwezi kupenga lijambu lenihele. ");
INSERT INTO mpa_vpl VALUES ("AC4_17","074_4_17","ACT","4","17","17","Nambu ngati anatupala kulihibhalaki lijambu lenu ngalijendale kwa bhandu bhamahele, tubhalakalya ngabhilonge na mundu jokapi jola kwa lihina laka Yesu.” ");
INSERT INTO mpa_vpl VALUES ("AC4_18","074_4_18","ACT","4","18","18","Bhakabhalohiki kabheti bhajingala mkati ja pachengu na bhakabhalakali ngabhilonge kabheti palanga, wala kubhabhola bhandu kwa lihina laka Yesu. ");
INSERT INTO mpa_vpl VALUES ("AC4_19","074_4_19","ACT","4","19","19","Nambu Petulu na Yohana bhakabhayangiki, “Muhaghula mabhanganya mabhete ngati wichu palongi jaka Chapanga kuntii mabhanganya kuliku kuntii Chapanga. ");
INSERT INTO mpa_vpl VALUES ("AC4_20","074_4_20","ACT","4","20","20","Nambu tepani ngatuwezi kukotoka kulonge mambu ghatughaweni na kughajowana.” ");
INSERT INTO mpa_vpl VALUES ("AC4_21","074_4_21","ACT","4","21","21","Bhakolongwa bha pachengu habha bhakabhajowihi kabheti nakanopi na kubhalekakela bhabhokaje. Ngachebhaweziki kubhalapula ndandi bhandu bhokapi bhundumbalya Chapanga kwa ndandi ja lijambu lenilela. ");
INSERT INTO mpa_vpl VALUES ("AC4_22","074_4_22","ACT","4","22","22","Mundu joakalamiswi jola akabhi na umule wa kupeta hyaka alobaini. ");
INSERT INTO mpa_vpl VALUES ("AC4_23","074_4_23","ACT","4","23","23","Palapala Petulu na Yohana, pabhakalekakiwi pela bhakakelawiki kwa bhajabho, na kubhapwaghi mambu ghabhapwaghiki bhakolongwa bha bhapenganyambiku na bhazee bha pachengu. ");
INSERT INTO mpa_vpl VALUES ("AC4_24","074_4_24","ACT","4","24","24","Bhandu habha pabhakajowini mambu ghanihagha bhakalibhongini papamu kundobha Chapanga, bhakapwaghaje, “Bambo, wehapa nde weubhombiki kunani kumahunde na ndema, nhwanga na yokapi yeibhi mkati jake! ");
INSERT INTO mpa_vpl VALUES ("AC4_25","074_4_25","ACT","4","25","25","Wehapa ukuntei mtumika waku, atati witu Daude, alongilaje kwa makili ghaka Roho Mhuhu, paapwaghikaje, ‘Bho, maghambu kiki bhandu bhatehi kuhakalila? Bho, mbona makabila gha bhandu bhahengiki mipangu ja waka? ");
INSERT INTO mpa_vpl VALUES ("AC4_26","074_4_26","ACT","4","26","26","Bhakolongwa bha pundema bhakajiandii, bhajemalela bhakahimangini papamu kulongalela panani jaka Bambo, na Kristo wake.’ ");
INSERT INTO mpa_vpl VALUES ("AC4_27","074_4_27","ACT","4","27","27","Maghambu kwa chakaka Helode, Pontio Pilato, bhandu bha Izilaeli, na bhandu bha ku inchi nayengi bhakahimangani pa muchi pani, kumpenga Yesu, Mtumika waku Mhuhu, joukunjeghili mahuta. ");
INSERT INTO mpa_vpl VALUES ("AC4_28","074_4_28","ACT","4","28","28","Bhombi bhakahimangini nahuli bhahenga malobhi ghaughapalikaje na kupanga kutumbu pamwandi kwa uwezu na mapalu ghaku. ");
INSERT INTO mpa_vpl VALUES ("AC4_29","074_4_29","ACT","4","29","29","Nambu sajenu, Bambo, lingalyaje malakalilu ghabhu. Utujangatyaje tepani mitumi bhaku kutangaza lilobhi laku panga na choghohi. ");
INSERT INTO mpa_vpl VALUES ("AC4_30","074_4_30","ACT","4","30","30","Uhatambulaje chiwoku chaku nahuli ubhalamihaje bhatamwa. Na kuhenga nginyulila na ngangachu kwa lihina laka Mwana waku mhuhu Yesu.” ");
INSERT INTO mpa_vpl VALUES ("AC4_31","074_4_31","ACT","4","31","31","Pabhakajomwi kundobha Chapanga, pandu pabhakahimangini pala pakanyuwakiki, na bhokapi bhakatwelakiki Roho Mhuhu. Bhokapi bhakatumbwi kutangaza lilobhi laka Chapanga panga na choghohi. ");
INSERT INTO mpa_vpl VALUES ("AC4_32","074_4_32","ACT","4","32","32","Bhahobhalela bhala bhokapi bhakabhi na mtima ghumu na roho jimu. Nga mundu hata jumu joakabhi na chindu chokapi chela akakibheka kubha chindu chaki mweni kanjika, nambu bhakajangatini kila chindu chebhakabhi nachu. ");
INSERT INTO mpa_vpl VALUES ("AC4_33","074_4_33","ACT","4","33","33","Mitumi bhakatangizi kwa makili ghamaheli kuhyoka kwaka Bambo Yesu na chihomu chamaheli chaka Chapanga chakabhi panani jabho. ");
INSERT INTO mpa_vpl VALUES ("AC4_34","074_4_34","ACT","4","34","34","Nga mundu nga jumu joakabhi panga chindu, maghambu pamaheli bhabhakabhi na mighonda au nyumba bhakailombise, na kuleta mbija yebhalombasile, ");
INSERT INTO mpa_vpl VALUES ("AC4_35","074_4_35","ACT","4","35","35","na kubhapeke mitumi mbija yene, nabhombi bhakaghabhini ngati kila mundu kulengana na moapalilaje. ");
INSERT INTO mpa_vpl VALUES ("AC4_36","074_4_36","ACT","4","36","36","Kukabhi na Mlawi jumu, mbelekeka wa ku Kipulo, lihina laki Yusufu, jobhundohika mitumi Banaba ndandi jaki, “Mundu wa kujeghe mtima,” ");
INSERT INTO mpa_vpl VALUES ("AC4_37","074_4_37","ACT","4","37","37","najombi akabhi na ngonda waki akaulombisi, na akatoliki mbija yeakapatiki na kubhapeke mitumi. ");
INSERT INTO mpa_vpl VALUES ("AC5_1","074_5_1","ACT","5","1","1","Nambu pakabhi na mundu jumu joalowakika Anania, papamu na nhwanu waki Safila bhakalombisi ngonda wabho. ");
INSERT INTO mpa_vpl VALUES ("AC5_2","074_5_2","ACT","5","2","2","Nambu nhwanu waki koni akamanya, ndomi waki Anania ahiiki mbija yakumu yeakalombasi ngonda, na yeyakahighali akabhapeki mitumi. ");
INSERT INTO mpa_vpl VALUES ("AC5_3","074_5_3","ACT","5","3","3","Bhela, Petulu akundalukile, “Anania, bho, mbona Shetani ajingi mu mtima waku na kumpwaghi icholi Roho Mhuhu kwa kuhiya pandu pa mbija yeupatiki kubhokana na ngonda ghola? ");
INSERT INTO mpa_vpl VALUES ("AC5_4","074_5_4","ACT","5","4","4","Bho, pawabhi nga kulombesa ngonda si ukabhi mali ghako? Bho, na pawakalombisi mbija heye si yakabhi yaku utumila ngati moupalila? Bho, henu ndandi kiki muntima waku ukaamwi kuhenga lijambu ngati lenihele? Ngacheunkongiki mundu, nambu unkongiki Chapanga!” ");
INSERT INTO mpa_vpl VALUES ("AC5_5","074_5_5","ACT","5","5","5","Anania paakajowini malobhi ghanihagha, akaawiki pahi na kupotela. Bhandu bhokapi bhabhakajowini lijambu lelakahengakiki bhakajowipi namaa. ");
INSERT INTO mpa_vpl VALUES ("AC5_6","074_5_6","ACT","5","6","6","Akakombu bhakahikiki, bhakajiyekalili hyegha jaki kwa sanda, bhakumpihiki kunja, na kuntagha. ");
INSERT INTO mpa_vpl VALUES ("AC5_7","074_5_7","ACT","5","7","7","Paghakapetiki masaa ghatatu palonge, nhwanu waki akahikike, panga kumanya mambu ghaghapitalile, akajingi mkati. ");
INSERT INTO mpa_vpl VALUES ("AC5_8","074_5_8","ACT","5","8","8","Petulu akundalukile, “Umbwagilaje! Bho, mwakalombisi ngonda kwa mbija yenjenu pela?” Safila akajetakile, “Ena, nde yeniheye.” ");
INSERT INTO mpa_vpl VALUES ("AC5_9","074_5_9","ACT","5","9","9","Petulu akumpwaghile, “Bho, maghambu kiki wehapa na ndomi waku mkajetangani kundenga Roho waka Bambo? Lingalyaje! Bhandu bhabhapiti kuntagha ndomi waku bhala sajenu bhabhi pundyangu, anabhukupiya kabheti na wehapa kunja!” ");
INSERT INTO mpa_vpl VALUES ("AC5_10","074_5_10","ACT","5","10","10","Palapala Safila akaawiki palongi ja magholu ghaka Petulu na kupotela. Akakombu bhala pabhajingalaje, bhakunhimani apotile, bhakumpihiki kunja, bhakuntaghiki pambipi na ndomi wake. ");
INSERT INTO mpa_vpl VALUES ("AC5_11","074_5_11","ACT","5","11","11","Lujoghopu lukolongwa lukalipatiki likanisa lokapi na bhandu bhokapi bhabhakajowini panani ja lijambu lenihele. ");
INSERT INTO mpa_vpl VALUES ("AC5_12","074_5_12","ACT","5","12","12","Mitumi bhakahengiki nginyulila na ngangachu yamahele pachilanda ja bhandu bhamahele. Bhahobhalela bhokapi bhakabhi bhahimangana papamu mu liwangala laka Solomoni. ");
INSERT INTO mpa_vpl VALUES ("AC5_13","074_5_13","ACT","5","13","13","Nga mundu nga jumu jwangakuhobhalela joakalengiki kulilomba papamu nabhu. Nambu bhandu bhakalongi malobhi manyahi panani jabhu. ");
INSERT INTO mpa_vpl VALUES ("AC5_14","074_5_14","ACT","5","14","14","Nambu bhahobhalela bhamaheli bhakajonjukiki kwaka Bambo, akanalomi na akambomba bhakajonjukiki namaa. ");
INSERT INTO mpa_vpl VALUES ("AC5_15","074_5_15","ACT","5","15","15","Kubhokana na mambu ghanihagha ghaghapitalile, bhandu bhakabhapeliki bhatamwa mwindela na kubhaghoneka panani ja itanda na mileli, nahuli Petulu anaapetiki kihilu chaki chabhayekaje bhangi bhabho. ");
INSERT INTO mpa_vpl VALUES ("AC5_16","074_5_16","ACT","5","16","16","Bhandu bhamaheli bhakahikiki kuhuma ku michi ja munkeghi ja ku Yelusalemu, bhakabhaletiki bhatamwa bhabhu na bhabhakabhi bhang'ahakika na majobhi, na bhanganya habha bhokapi bhakalamiswe. ");
INSERT INTO mpa_vpl VALUES ("AC5_17","074_5_17","ACT","5","17","17","Panihapa Mpenganyambiku Nkolongwa na bhajake bhabhabhi bha lipogha la Masadukayo bha pandu panihapa, bhakabhabhoni wihu. ");
INSERT INTO mpa_vpl VALUES ("AC5_18","074_5_18","ACT","5","18","18","Bhakabhakamwi mitumi na kubhakonga muligeleza. ");
INSERT INTO mpa_vpl VALUES ("AC5_19","074_5_19","ACT","5","19","19","Nambu ikilu mtumika wa kunani waka Chapanga akajibhopwi milyangu ja muligeleza, akabhapihiki kunja, na kubhapwaghila, ");
INSERT INTO mpa_vpl VALUES ("AC5_20","074_5_20","ACT","5","20","20","“Njendanyaje mkajemaje mu Nyumba jaka Chapanga mkabhatangazya bhandu malobhi ghokapi gha womi ghoni wahenu.” ");
INSERT INTO mpa_vpl VALUES ("AC5_21","074_5_21","ACT","5","21","21","Mitumi bhakajetakile, na lukela bhakajingili mu Nyumba jaka Chapanga, na kutumbu kubhola. Mpenganyambiku Nkolongwa na bhajake pabhahikile, bhakalohiki uhimanganu wa pachengu na bhazee bha Izilaeli, kabheti bhakabhatumiki bhandu muligeleza bhakabhaleta mitumi bhala. ");
INSERT INTO mpa_vpl VALUES ("AC5_22","074_5_22","ACT","5","22","22","Nambu chikahi bhalonda bha pachengu pabhakahikiki mkati, ngachebhahimani mitumi muligeleza. Henu bhakakelawiki, na kubhoha ubholu pa uhimangano, ");
INSERT INTO mpa_vpl VALUES ("AC5_23","074_5_23","ACT","5","23","23","bhakapwaghaje, “Patwahiki muligeleza, tukahimani lijighaliki milyangu jokapi wichu na bhalonda bhakalenda milyango. Nambu patabhopwi milyango ngachetunhimani mundu jokapi jola mkati.” ");
INSERT INTO mpa_vpl VALUES ("AC5_24","074_5_24","ACT","5","24","24","Bhela mlonda nkolongwa wa Nyumba jaka Chapanga na bhapenganyambiku bhakolongwa pabhajowini mambu ghanihagha bhakabhi na choghoi, na kukangacha nakanopi, panga kumanya ghaghabhapatiki mitumi. ");
INSERT INTO mpa_vpl VALUES ("AC5_25","074_5_25","ACT","5","25","25","Akahiki mundu jumu, akabhapwaghile, “Bhandu bhamwakongiki muligeleza, sajenu bhajemiki mu Nyumba jaka Chapanga, na bhabhola bhandu.” ");
INSERT INTO mpa_vpl VALUES ("AC5_26","074_5_26","ACT","5","26","26","Panihapa nkolongwa wa bhalonda wa Nyumba jaka Chapanga papamu na bhalonda bhaki bhakapiti ku Nyumba jaka Chapanga, na kubhaleta. Nambu ngachebhakamwi kwa makili, maghambu bhabhajoghupa bhandu bhakabya bhalapwi maganga. ");
INSERT INTO mpa_vpl VALUES ("AC5_27","074_5_27","ACT","5","27","27","Bhakabhapeliki mitumi mkati, na kubhajemeka palongi ja pachengo, na Mpenganyambiku Nkolongwa akabhalalukile. ");
INSERT INTO mpa_vpl VALUES ("AC5_28","074_5_28","ACT","5","28","28","Akapwaghaje, “Tukunkanaki kwa makili ngamwibhola kwa lihina laka mundu jonihojo, nambu mabhanganya mughatangizi mabholu ghinu pa Yelusalemu pokapi na mpala kutuletela mwahi waka mundu jonihojo panani jitu.” ");
INSERT INTO mpa_vpl VALUES ("AC5_29","074_5_29","ACT","5","29","29","Petulu na mitumi bhajaki bhala, bhakayangike, “Itupalika kuntii Chapanga kuliku bhandu. ");
INSERT INTO mpa_vpl VALUES ("AC5_30","074_5_30","ACT","5","30","30","Chapanga wa akahoko bhitu akamuyohiki Yesu jomunkomiki mabhanganya kwa kunhwamba punsalaba. ");
INSERT INTO mpa_vpl VALUES ("AC5_31","074_5_31","ACT","5","31","31","Chapanga ankwehiki mbaka upambala waki wa kumalelelu nahuli abya Chiongozi na Mkengalela, nahuli abhapekya mbekenyu bhandu bha Izilaeli bhang'anambukaje na kughaleka mahoku ghabhu nahuli Chapanga abhalekakyaje mahoku ghabhu. ");
INSERT INTO mpa_vpl VALUES ("AC5_32","074_5_32","ACT","5","32","32","Tepani nde bhalandilu bha mambu ghanihagha, bhelabhela Roho Mhuhu najombi alongalela lijambu leniheli ambaju Chapanga abhapeki bhokapi bhabhuntii jombi.” ");
INSERT INTO mpa_vpl VALUES ("AC5_33","074_5_33","ACT","5","33","33","Bhabholu bhokapi bha pachengu pabhajowini malobhi ghanihagha, bhakahakali namaa, na bhakajetangani kubhakoma mitumi bhala. ");
INSERT INTO mpa_vpl VALUES ("AC5_34","074_5_34","ACT","5","34","34","Nambu Mfalisayo jumu joalowakika Gamalieli, joakabhi mbola wa Shelia na joakamanyakini nakanopi kwa bhandu bhamaheli, akajemiki palongi ja pachengu pala, jombi akalaghalaki bhabhapiya mitumi bhala kunja kwa chikahi chijipe. ");
INSERT INTO mpa_vpl VALUES ("AC5_35","074_5_35","ACT","5","35","35","Panihapa akabhapwaghi bhabholu bha pachengo, “Mabhandu bha Izilaeli, muholalya wichu mambu ghampala kuhenga kwa bhandu bhanihabha. ");
INSERT INTO mpa_vpl VALUES ("AC5_36","074_5_36","ACT","5","36","36","Pamwandi pachokopi akapitali mundu jumu lihina laki alowakika Teuda, akaliweni mweni kubha jombi nde mundu nkolongwa, na bhandu ngati mia nchechi bhakalibhongini naku. Nambu bhandu bhakunkomike, na bhandu bhokapi bhabhunjengalyaje bhakapechangine na lipogha laki lakahobhike. ");
INSERT INTO mpa_vpl VALUES ("AC5_37","074_5_37","ACT","5","37","37","Kabheti, pachahika chikahi cha kubhalanga bhandu, akapitali Yuda mundu wa ku Galilaya. Najombi akabhahutiki bhandu bhakunjengalile, nambu bhandu bhakunkomike na bhandu bhokapi bhabhunjengalyaje bhakapechangine. ");
INSERT INTO mpa_vpl VALUES ("AC5_38","074_5_38","ACT","5","38","38","Henu nde, nepani numpwaghi anana, ngamwahenge bhandu bhanihabha lihakau lokapi lela, mwabhaleka bhajendaje! Maghambu anangati lihengu labhu heli litumbuliwi na bhandu, ngalijendalele. ");
INSERT INTO mpa_vpl VALUES ("AC5_39","074_5_39","ACT","5","39","39","Nambu ngati lihengu leniheli lihumiki kwaka Chapanga, ngamuwezi kulipenga nambu mwalihimanya mpengana na Chapanga!” Bhandu bhokapi bha pachengu pala bhakajetangani naku Gamalieli. ");
INSERT INTO mpa_vpl VALUES ("AC5_40","074_5_40","ACT","5","40","40","Bhakabhalohiki mitumi bhala mkati, na kubhalapu iboko na kubhakanaki ngabhibhola kabheti kwa lihina laka Yesu, na kubhalekake bhajendaje. ");
INSERT INTO mpa_vpl VALUES ("AC5_41","074_5_41","ACT","5","41","41","Bhela mitumi bhakapitiki kunja ja pachengu koni bhatweli chiheku, ndandi bhabhalangiki ikabhapaliki kupohakeka lihamu kwa ndandi ja lihina laka Yesu. ");
INSERT INTO mpa_vpl VALUES ("AC5_42","074_5_42","ACT","5","42","42","Ngachebhakotwiki kubhola kila lichobha, na kutangaza Malobhi Manyahi kubha Yesu nde Kristo mu Nyumba jaka Chapanga na ku manyumba gha bhandu. ");
INSERT INTO mpa_vpl VALUES ("AC6_1","074_6_1","ACT","6","1","1","Mu machobha ghanihagha namba ja bhabhulwa pajijendalya kujonjokeka nakanopi, kukapitali lung'olo pachilanda ja Bhayahude bhabhalongila Kigiliki na Bhayahude bhabhalongila Kiebulania. Bhayahude bhabhalongila Kigiliki bhang'olika kubha bhabhaweliwi na bhalomi bhabhu bhatendika kujewakeka mu kughabhana chilebhi kwa kila lichobha. ");
INSERT INTO mpa_vpl VALUES ("AC6_2","074_6_2","ACT","6","2","2","Mitumi komi na bhabheli bhala bhakabhalohiki lipogha lokapi la bhabhulwa papamu, na kupwagha, “Nga wichu kwitu tepani kukotoka kulitangaza Lilobhi laka Chapanga nahuli kughabha chilebhi kwa bhandu. ");
INSERT INTO mpa_vpl VALUES ("AC6_3","074_6_3","ACT","6","3","3","Bhela mwalongu bhitu, mubhahaghulaje akanalomi saba kuhuma kwinu bhabhabhi na luhomu lwambone, bhabhatwelakiki Roho Mhuhu na bhabhabhi na malangu, bhatuweza kubhapeke lihengu lenihele. ");
INSERT INTO mpa_vpl VALUES ("AC6_4","074_6_4","ACT","6","4","4","Tepani anatutumila chikahi chitu chilachu kwa kuhenga lihengu la kundobha Chapanga na kutangaza Lilobhi laka Chapanga.” ");
INSERT INTO mpa_vpl VALUES ("AC6_5","074_6_5","ACT","6","5","5","Lilobhi lenihele lakapalakiki na bhahobhalela bhokapi. Nabhombi bhakabhahawi Stefano, mundu joakabhi na uhobhalelu ukolongwa na joatwelakiki Roho Mhuhu, Filipo, Pulokolo, Nikanoli, Timoni, Pamena, na Nikolao mundu wa ku Antiokia joakahobhalile dini ja Kiyahude. ");
INSERT INTO mpa_vpl VALUES ("AC6_6","074_6_6","ACT","6","6","6","Bhakabhaletiki bhandu bhanihabha palongi ja mitumi, nabhombi bhakabhalobhili na kubhabheke mabhoku. ");
INSERT INTO mpa_vpl VALUES ("AC6_7","074_6_7","ACT","6","7","7","Lilobhi laka Chapanga lakajendali kujaghanila ku Yelusalemu hoku na ubhalangiku wa bhabhulwa ukajonjukiki nakanopi na bhapenganyambiku bhamaheli bhakunhobhali Yesu. ");
INSERT INTO mpa_vpl VALUES ("AC6_8","074_6_8","ACT","6","8","8","Stefano, akabya atwelakiki chihomu nakanopi na makili ghaka Chapanga, akahengiki nginyulila na ngangachu ikolongwa pachilanda ja bhandu. ");
INSERT INTO mpa_vpl VALUES ("AC6_9","074_6_9","ACT","6","9","9","Nambu bhakapitali bhandu nahuli bhalochana na Stefano. Bhandu habha bhakabhi bha nyumba ja kuhimangani Bhayahude jejilowakika, “Bhandu Bhakulijeka.” Nabhombi bhakahumi ku inchi ja ku Kilene na ku Alekizandilia, bhelabhela na Bhayahude bhangi kuhuma ku Kilikia na ku Asia. Bhandu bhanihabha bhakatumbwi kulochana na Stefano. ");
INSERT INTO mpa_vpl VALUES ("AC6_10","074_6_10","ACT","6","10","10","Nambu ngachebhaweziki kumpeta kulochana naku, maghambu Roho waka Chapanga akumpeki mbulau yamaheli chikahi paalongila nabhu. ");
INSERT INTO mpa_vpl VALUES ("AC6_11","074_6_11","ACT","6","11","11","Panihapa bhakabhapwaghi bhandu bhalongila kwa ichole nahuli bhapwaghaje, “Tunjowini Stefano akalongilaje malobhi gha kuntondo Musa na Chapanga.” ");
INSERT INTO mpa_vpl VALUES ("AC6_12","074_6_12","ACT","6","12","12","Kwa kulonge bhenibhela bbakabhajonjuki bhandu, bhazee na bhabhola bha Shelia. Nabhombi bhakunjendi Stefano, bhakunkamwili na kundeta palongi ja pachengu pakolongwa. ");
INSERT INTO mpa_vpl VALUES ("AC6_13","074_6_13","ACT","6","13","13","Bhakaletiki bhalandilu bha icholi bhabhapwaghikaje, “Mundu jonjo ngacheakotoka kulonge malobhi gha kupatondola pandu pambane pa Nyumba jaka Chapanga na Shelia. ");
INSERT INTO mpa_vpl VALUES ("AC6_14","074_6_14","ACT","6","14","14","Maghambu tukunjowini akapwagha kubha Yesu wa ku Nazaleti anaapabhombulaje pa Nyumba jaka Chapanga pani na kung'anambula mitetu jokapi jetujopalili kuhuma kwaka Musa.” ");
INSERT INTO mpa_vpl VALUES ("AC6_15","074_6_15","ACT","6","15","15","Bhandu bhokapi bhabhatamani pachengu kwa uhimanganu ghonihoghu bhakundingalaki mihu Stefano, bhakapaweni pamihu jaki pang'anya ngati pamihu ja bhatumika bha kunani kwaka Chapanga. ");
INSERT INTO mpa_vpl VALUES ("AC7_1","074_7_1","ACT","7","1","1","Bhela Mpenganyambiku Nkolongwa akundaluki Stefano, “Bho, mambu ghangani le gha chakaka?” ");
INSERT INTO mpa_vpl VALUES ("AC7_2","074_7_2","ACT","7","2","2","Stefano akayangike, “Mwabhalongu bhangu na akatati bhangu, nyowanyaje! Chapanga akumpitali ahoko witu Ibulahimu paakabhi ku Mesopotamia paakabhi akali nga kujenda kutama ku Halani. ");
INSERT INTO mpa_vpl VALUES ("AC7_3","074_7_3","ACT","7","3","3","Chapanga akumpwaghile, ‘Ubhoka pa inchi jaku na waleka bhandu bha lukolu lwaku ujendaje ku inchi jenakulangiaje.’ ");
INSERT INTO mpa_vpl VALUES ("AC7_4","074_7_4","ACT","7","4","4","Bhela, Ibulahimu akahamiki ku inchi ja ku Kalidayo, akapiti kutama ku Halani. Paakajomwi kupotela atati waki, Chapanga akumbohiki kabheti Ibulahimu kuhuma ku Halani na kundeta kutama ku inchi jenjenu jentama sajeno. ");
INSERT INTO mpa_vpl VALUES ("AC7_5","074_7_5","ACT","7","5","5","Chapanga ngacheampeki Ibulahimu inchi nahuli jibya jaki, ngacheakumpeki hata chipandi kichokopi cha kubheka chigholu chaki, hata bhela Chapanga akumpeki chilanga kubha jombi na lubheleku lwaki anabhatola upwelelu wa inchi jenjenu, hata koni chikahi hechi Ibulahimu ngacheakabhi na mwana. ");
INSERT INTO mpa_vpl VALUES ("AC7_6","074_7_6","ACT","7","6","6","Chapanga akumpwaghi ana, ‘Bhana bhaku bhibya bhaghene ku inchi ja bhandu bhangi, na konihoko bhibya bhatumwa bhabho, na kubhahenge mambu mahakau kwa chikahi cha hyaka mia ncheche.’ ");
INSERT INTO mpa_vpl VALUES ("AC7_7","074_7_7","ACT","7","7","7","Chapanga akapwaghike, ‘Nambu nepani ananabhatemula bhandu bha inchi jeniheji jejabhabheka bhabya bhatumwa, na baada ja ghanihagha, ananabhabhoha bhabhelakeka bhinu pa inchi jeniheje nahuli bhahika kunyojabhela pandu pani.’ ");
INSERT INTO mpa_vpl VALUES ("AC7_8","074_7_8","ACT","7","8","8","Panihapa Chapanga akumpeki Ibulahimu lulaghilu lwa jando ngati nginyulila jaki. Ibulahimu akumbeliki Isaka na akunhekiti jando lichobha la nane kutumbu paakabhelakike. Palongi Isaka akumbeliki Yakobo najombi akunhengi bhelabhela, na Yakobo akabhabheliki akahoko bhitu komi na bhabheli bhala na kubhahenge bhelabhela. ");
INSERT INTO mpa_vpl VALUES ("AC7_9","074_7_9","ACT","7","9","9","“Maghambu akahoko bhitu bhala bhakumboni wihu Yusufu,” bhakundombisi kutumwa ku Misili. Nambu Chapanga akabhi papamu naku. ");
INSERT INTO mpa_vpl VALUES ("AC7_10","074_7_10","ACT","7","10","10","Akunkengali kubhokana na mang'ahiku ghaki ghokapi ghaghumpatike, kabheti Chapanga akumpeki chihomu, apata kupalakika na Falao, nkolongwa wa ku Misili na kubhonikana abhi na mbulau yamaheli palongi jaki. Nkolongwa jola akumbehi abya njemalela wa inchi jaki na wa nyumba jaki jokapi. ");
INSERT INTO mpa_vpl VALUES ("AC7_11","074_7_11","ACT","7","11","11","Bhela kukabhi na injala ku inchi jokapi ja ku Misili na ku Kanaani, jakapelaki ulali ukolongwa. Akahoko bhitu ngachebhaweziki kupata chilebhi cha kubhajaghanila. ");
INSERT INTO mpa_vpl VALUES ("AC7_12","074_7_12","ACT","7","12","12","Nambu Yakobo paakajowini kubha ku Misili kukabhi na ingano, akabhatumiki bhana bhaki, yani akahoko bhitu, bhajendaje ku Misili kwa mala ja kutumbula. ");
INSERT INTO mpa_vpl VALUES ("AC7_13","074_7_13","ACT","7","13","13","Pamwanja wabhu wa kabhele, Yusufu akalilowili kwa bhalongu bhaki, na Falao akabhamanyiki bhalongu bhaka Yusufu. ");
INSERT INTO mpa_vpl VALUES ("AC7_14","074_7_14","ACT","7","14","14","Yusufu akatumiki ubholu wa kundoha Yakobo atati waki na bhalongu bhaki bhokapi bhahikaje ku Misili, jumula jabhu bhakabhi bhandu sabini na nhwanu. ");
INSERT INTO mpa_vpl VALUES ("AC7_15","074_7_15","ACT","7","15","15","Bhela Yakobo akapiti ku Misili hoku jombi na akahoko bhitu kobhakapotalile. ");
INSERT INTO mpa_vpl VALUES ("AC7_16","074_7_16","ACT","7","16","16","Hyegha yabhu ikaletakiki mbaka ku Shekemu, ikataghakiki mu litengeli leakahemi Ibulahimu kuhuma kwa bhana bhaka Hamoli kwa pandu fulani pa mbija. ");
INSERT INTO mpa_vpl VALUES ("AC7_17","074_7_17","ACT","7","17","17","“Chikahi pachakahikiki Chapanga kumpeke chilanga cheakumbeki Ibulahimu, ubhalangiku wa bhandu bhitu ku Misili ukajonjukiki namaa. ");
INSERT INTO mpa_vpl VALUES ("AC7_18","074_7_18","ACT","7","18","18","Pa kujomukela nkolongwa jumu jwangakummanya Yusufu akatumbwi kutawala ku Misili. ");
INSERT INTO mpa_vpl VALUES ("AC7_19","074_7_19","ACT","7","19","19","Jonihoju akabhahakali namaa bhandu bhitu Bhaizilaeli, na kubhahenge mahakau akahoko bhitu, kwa kubhapeke amuli bhabhalekala kunja bhana bhabhu bhang'eng'a, nahuli bhapotilaje. ");
INSERT INTO mpa_vpl VALUES ("AC7_20","074_7_20","ACT","7","20","20","Chikahi hechi akabhelakiki Musa, najombi akabhi mwana nyahi namaa. Akaleliwi mu nyumba ja atati waki kwa chikahi cha myehi jitatu. ");
INSERT INTO mpa_vpl VALUES ("AC7_21","074_7_21","ACT","7","21","21","Pabhalepali kunhiya nakanope, bhakumpihiki kunja na kamwali waka nkolongwa Falao akumtoliki, na kundela ngati mwana waki mwene. ");
INSERT INTO mpa_vpl VALUES ("AC7_22","074_7_22","ACT","7","22","22","Musa akabholakiki mambu ghokapi gha mbulau ya Bhamisili, na akabhi mundu joamanyakine kwa malobhi na matendu ghaki.” ");
INSERT INTO mpa_vpl VALUES ("AC7_23","074_7_23","ACT","7","23","23","“Chikahi Musa paakabhi na hyaka alobaini, akaamwi kujenda kubhalola bhalongu bhaki Bhaizilaeli. ");
INSERT INTO mpa_vpl VALUES ("AC7_24","074_7_24","ACT","7","24","24","Konihoku akumbweni mundu jumu wa ku Misili akunhengila uhakau mundu jumu wa ku Izilaeli, akapiti kunkengalela joabhoniwa jola, na kwa kulepa kisasi akunkomiki Mmisili jola. ");
INSERT INTO mpa_vpl VALUES ("AC7_25","074_7_25","ACT","7","25","25","Musa aholalya kubha bhalongu bhaki bhimanya kubha Chapanga anaabhakengalyaje kwa kuntumi jombe, nambu bhombi ngachebhamanyi bhenibhela. ");
INSERT INTO mpa_vpl VALUES ("AC7_26","074_7_26","ACT","7","26","26","Chilabhu jaki, Musa akabhaweni Bhaizilaeli bhabheli bhakakomanaje, akalengiki kubhakenga kwa kubhapwaghila, ‘Mwe mabhandu, mabhanganya mabhalongo, bho, maghambu kiki mpotikana mabhete kwa mabhete?’ ");
INSERT INTO mpa_vpl VALUES ("AC7_27","074_7_27","ACT","7","27","27","Nambu mundu joakabhi andapula njaki jola akunkangiki Musa kunkeghe na kundalukila, ‘Bho, nane joakubhei wehapa ubya chiongozi na mtemula witu tepani?’ ");
INSERT INTO mpa_vpl VALUES ("AC7_28","074_7_28","ACT","7","28","28","‘Bho, upala kungoma ngati moukunkomi Mmisili jola licho?’ ");
INSERT INTO mpa_vpl VALUES ("AC7_29","074_7_29","ACT","7","29","29","Musa paakajowini malobhi ghanihagha, akatiliki na kujenda kutama ngati ngeni ku inchi ja ku Midiani. Na konihoku akapatiki bhana bhabheli bha chikambaku. ");
INSERT INTO mpa_vpl VALUES ("AC7_30","074_7_30","ACT","7","30","30","“Payapetiki hyaka alobaini, mtumika wa kunani kwaka Chapanga akumpitali Musa pa chitutu chechibhelala moto kulipololu hoku pambipi na Chitombi Sinai. ");
INSERT INTO mpa_vpl VALUES ("AC7_31","074_7_31","ACT","7","31","31","Musa paakaweni mambu ghanihagha, akakangichi namaa kubhona mabhonu ghala. Akaheghali pambipi nahuli kulingalila, akajowini sauti jaka Bambo. ");
INSERT INTO mpa_vpl VALUES ("AC7_32","074_7_32","ACT","7","32","32","Jakapwaghaje, ‘Nepani nde Chapanga wa akahokolu bhaku, Chapanga waka Ibulahimu, Isaka na Yakobo.’ Musa akabhaghiji kwa choghoi na wala ngacheaweziki kujendale kulingalila. ");
INSERT INTO mpa_vpl VALUES ("AC7_33","074_7_33","ACT","7","33","33","Bambo akumpwaghile, ‘Uhulaje magubasi ghaku maghambu pandu paujemi pani nde pandu pahuhu. ");
INSERT INTO mpa_vpl VALUES ("AC7_34","074_7_34","ACT","7","34","34","Chakaka naghaweni mang'ahiku gha bhandu bhangu ku Misili hoku. Nikijowini chilelu chabhu cha mabhinilu, na nepani nhelili nahuli nabhakengalyaje. Henu uhikaje, nanatu ananukutumaje ku Misili.’ ");
INSERT INTO mpa_vpl VALUES ("AC7_35","074_7_35","ACT","7","35","35","“Jonihoju akabhi Musa jobhunkanika bhandu, bhakapwaghaje, ‘Bho, joakubhehi wehapa ubya chiongozi na mtemula witu tepani nane?’ Chapanga nde joakuntumiki abya chiongozi na mkombola, kwa indela jaka mtumika wa kunani kwaka Chapanga joakumpitali ku chitutu chechibhelala moto. ");
INSERT INTO mpa_vpl VALUES ("AC7_36","074_7_36","ACT","7","36","36","Musa nde jobhalonguwa bhandu bhabhoka ku Misili kwa kuhenga nginyulila na ngangachu ku inchi ja ku Misili, ku Bahali ja Shamu, na kulipololu kwa chikahi cha hyaka alobaini. ");
INSERT INTO mpa_vpl VALUES ("AC7_37","074_7_37","ACT","7","37","37","Jonihoju nde Musa jobhapwaghila bhandu bha ku Izilaeli, ‘Chapanga anaanhaghulya mlota ngati nepani kuhuma kwa bhalongu bhinu mabhete, munjowanyaje jombi.’ ");
INSERT INTO mpa_vpl VALUES ("AC7_38","074_7_38","ACT","7","38","38","Chikahi hechi pakukabhi uhimanganu wa Bhaizilaeli kulipololu hoku, jombi akabhi panipala na akahoko bhitu papamu na mtumika wa kunani kwaka Chapanga joalongila naku ku Chitombi Sinai jola. Jombi nde joakajopalili malobhi gha womi nahuli atupekyaje tepani. ");
INSERT INTO mpa_vpl VALUES ("AC7_39","074_7_39","ACT","7","39","39","“Nambu akahoko bhitu ngachebhapaliki kumtii Musa, bhakunkaniki na bhakatokuli kukelebhuka kabheti ku Misili. ");
INSERT INTO mpa_vpl VALUES ("AC7_40","074_7_40","ACT","7","40","40","Bhakumpwaghi Haluni, ‘Utulenganakyaje imong'umong'u yeyatulonguwa mwindela, maghambu ngachetumanyi ghaghumpatiki Musa joatulonguhaje tubhokaje ku inchi ja Misili.’ ");
INSERT INTO mpa_vpl VALUES ("AC7_41","074_7_41","ACT","7","41","41","Panihapa bhakalenganaki chimong'umong'u cha ubhonikanu wa litoli la ng'ombi, bhakaletiki nyambiku kwa chimong'umong'u chela na kuhekalela lihengu lebhahengiki kwa mabhoku ghabhu bhene. ");
INSERT INTO mpa_vpl VALUES ("AC7_42","074_7_42","ACT","7","42","42","Bhela Chapanga akabhokiki pachilanda jabhu, akabhalehi bhajojabya ndondwa, lyobha na mwehi ngati moilembakike mu chitabu cha bhalota bhaka Chapanga. ‘Mabhandu bha Izilaeli! Bho, nga nepani le mwemokila nyambiku na nhupu, kwa chikahi cha hyaka alobaini kulipololu kola? ");
INSERT INTO mpa_vpl VALUES ("AC7_43","074_7_43","ACT","7","43","43","Mabhanganya mwakalitotwili lihema laka kichapanga winu Moleki, na ichapanga ya ndondwa yaka kichapanga winu Refani. Mkalenganakili imong'umong'u nahuli muijojabyaje. Kwa kuhenga bhenibhela ananumpelakaje kutali kupeta ku Babeli.’ ");
INSERT INTO mpa_vpl VALUES ("AC7_44","074_7_44","ACT","7","44","44","“Ku lipololu kola akahoko bhitu bhakabhi na Lihema la Ulandilu. Lakalenganakiki ngati Chapanga moakumpwaghi Musa alenganakyaje, kulengana na ulenganesu ghola ghoauwene. ");
INSERT INTO mpa_vpl VALUES ("AC7_45","074_7_45","ACT","7","45","45","Akahoko bhitu bhakajopalani bheni kwa bheni mbaka chikahi chaka Yoshua, pabhakajitohi inchi jela kuhuma kwa bhandu bha inchi nayenge ambayu Chapanga akaitopwile palongi jabho. Panihapa likatami mbaka chikahi chaka Daude. ");
INSERT INTO mpa_vpl VALUES ("AC7_46","074_7_46","ACT","7","46","46","Daude akapatiki chihomu palongi jaka Chapanga, akundobhiki Chapanga kunchenge matamu gha kutama jombi joakabhi Chapanga waka Yakobo. ");
INSERT INTO mpa_vpl VALUES ("AC7_47","074_7_47","ACT","7","47","47","Nambu Solomoni nde joakunchengi Chapanga nyumba. ");
INSERT INTO mpa_vpl VALUES ("AC7_48","074_7_48","ACT","7","48","48","“Papamu na bhela, Chapanga Joabhi Kunani Nakanope ngacheatama mu nyumba yeichengakiki na mabhoku gha bhandu, ngati mlota waka Chapanga moapwaghila: ");
INSERT INTO mpa_vpl VALUES ("AC7_49","074_7_49","ACT","7","49","49","‘Bambo apwagha, kunani nde chitehu changu cha ukolongwa, na pundema nde chitehu changu cha kubheke magholu ghango. Bho, ananjengila nyumba ja ntundu bhole? Bho, pandu pangu pa kupomulela anapabya kwako? ");
INSERT INTO mpa_vpl VALUES ("AC7_50","074_7_50","ACT","7","50","50","Bho, mabhoku ghangu le ngacheghabhombiki hindu ayeyi yokape?’ ");
INSERT INTO mpa_vpl VALUES ("AC7_51","074_7_51","ACT","7","51","51","“Mwenga mwemnonwipi hingo! Mitima na makutu ghinu ghabhi ngati gha bhandu bhangakummanya Chapanga. Mabhanganya ngati akahoko bhinu. Machobha ghokapi mumpenga Roho Mhuhu. ");
INSERT INTO mpa_vpl VALUES ("AC7_52","074_7_52","ACT","7","52","52","Bho, abhi mlota jwangakung'ahakika na akahoko bhinu? Akahoko bhinu bhakabhakomiki bhalota bhaka Chapanga bhaakabhatumiki bhatangazaje kuhika kwaka Mweni Haki. Na sajenu, mabhanganya ntehi kung'anambuka, na kunkoma. ");
INSERT INTO mpa_vpl VALUES ("AC7_53","074_7_53","ACT","7","53","53","Mwanganya mkajopali Shelia yeyaletakiki kwinu na bhatumika bha kunani kwaka Chapanga, nambu ngachemwikamwile!” ");
INSERT INTO mpa_vpl VALUES ("AC7_54","074_7_54","ACT","7","54","54","Bhazee bha pachengo pabhajowini malobhi ghanihagha, bhakahakali namaa, bhakamuyaghi Stefano minu kwa inyela. ");
INSERT INTO mpa_vpl VALUES ("AC7_55","074_7_55","ACT","7","55","55","Nambu Stefano koni akabya atweli Roho Mhuhu, akalingalaki kunani kumahunde, akauweni ulumbalilu waka Chapanga na Yesu akabya ajemiki upambala wa kumalelelu waka Chapanga. ");
INSERT INTO mpa_vpl VALUES ("AC7_56","074_7_56","ACT","7","56","56","Akapwaghike, “Ndingalyaje! Mona kunani kumahunde kuhowike na Mwana waka Mundu ajemiki upambala wa kumalelelu waka Chapanga!” ");
INSERT INTO mpa_vpl VALUES ("AC7_57","074_7_57","ACT","7","57","57","Panihapa, bhandu bhokapi bhabhabhi pa uhimanganu wa pachengo pala, bhakajamalili na kuhibha makutu kwa mabhoku ghabho. Na bhela bhakamuhombili bhokapi kwa papamu, ");
INSERT INTO mpa_vpl VALUES ("AC7_58","074_7_58","ACT","7","58","58","bhakumpihiki kunja ja muchi, na kundapula maganga. Na bhalandilu bhakabhei makoti ghabhu pahi ja ulingalilu waka nkombu jumu lihina laki Sauli. ");
INSERT INTO mpa_vpl VALUES ("AC7_59","074_7_59","ACT","7","59","59","Bhakajendali kundapu kwa maganga koni Stefano akundobha Chapanga, “Bambo Yesu, ujopalya roho jango!” ");
INSERT INTO mpa_vpl VALUES ("AC7_60","074_7_60","ACT","7","60","60","Akachikimi pahi, akaleliki kwa sauti ngolongwa, “Bambo! Ngawabhalangila lihoku lendenu.” Paakajomwi kulonge bhenibhela, akapotile. Sauli najombi akachiweni chihengu chenihechi cha kukomakeka kwaka Stefano kubha wichu. ");
INSERT INTO mpa_vpl VALUES ("AC8_1","074_8_1","ACT","8","1","1","Lichobha leniheli likanisa la ku Yelusalemu lakatumbwi kung'ahakika chihakao. Bhahobhalela bhokapi, pangakubha mitumi bhala, bhakatili ku inchi ja ku Yudea na ku Samalia. ");
INSERT INTO mpa_vpl VALUES ("AC8_2","074_8_2","ACT","8","2","2","Bhandu bhakumu bhabhunjojabhe Chapanga bhakuntaghiki Stefano, na kuntendela maombulezu makolongwa namaa. ");
INSERT INTO mpa_vpl VALUES ("AC8_3","074_8_3","ACT","8","3","3","Nambu chikahi hechi, Sauli akatumbwi kuliyonanga likanisa. Akapiti ku kila nyumba, na kubhapiha akambomba na akanalomi, na kubhabheka muligeleza. ");
INSERT INTO mpa_vpl VALUES ("AC8_4","074_8_4","ACT","8","4","4","Bhahobhalela bhabhatilani bhala, bhakapiti pandu patalipatali koni bhakatangaza Lilobhi laka Chapanga. ");
INSERT INTO mpa_vpl VALUES ("AC8_5","074_8_5","ACT","8","5","5","Filipo akapiti ku muchi wa ku Samalia na kuntangaza Kristo kwa bhandu bha konihoko. ");
INSERT INTO mpa_vpl VALUES ("AC8_6","074_8_6","ACT","8","6","6","Bhandu pabhunjowini Filipo na kubhona nginyulila na ngangachu yeakabhi ahenga, bhakajowanakili nakanopi malobhi ghaakabhi aghalongela. ");
INSERT INTO mpa_vpl VALUES ("AC8_7","074_8_7","ACT","8","7","7","Maghambu majobhi ghakabhapitiki bhandu bhamahele, koni bhakajamalyaje na bhandu bhamaheli bhabhatengwiki na bhabhabhi na hilema, bhakalamike. ");
INSERT INTO mpa_vpl VALUES ("AC8_8","074_8_8","ACT","8","8","8","Kukabhi na chiheku chikolongwa ku muchi ghonighola. ");
INSERT INTO mpa_vpl VALUES ("AC8_9","074_8_9","ACT","8","9","9","Henu, kukabhi na mundu jumu lihina laki alowakika Simoni, jombi akaweziki kuhenga uhabhi waki ku muchi ghola kwa chikahi chilachu na kubhakangacha bhandu bha ku Samalia. Akapwagha kubha jombi nde mundu nkolongwa, ");
INSERT INTO mpa_vpl VALUES ("AC8_10","074_8_10","ACT","8","10","10","bhandu bhokapi, bhana kwa bhakolongwa, bhakunjowani wichu bhakapwaghaje, “Simoni nde makili ghaka Chapanga, ghaghalowakeka ‘Makili Makolongwa,’ ” ");
INSERT INTO mpa_vpl VALUES ("AC8_11","074_8_11","ACT","8","11","11","Bhakunjengalili maghambu akabhakangichi kwa uhabhi waki kwa chikahi chilachu. ");
INSERT INTO mpa_vpl VALUES ("AC8_12","074_8_12","ACT","8","12","12","Nambu bhandu pabhakunhobhali Filipo panani ja Malobhi Manyahi gha Ukolongwa waka Chapanga na lihina laka Yesu Kristo, bhakabatizwi akanalomi na akambomba. ");
INSERT INTO mpa_vpl VALUES ("AC8_13","074_8_13","ACT","8","13","13","Simoni najombi akahobhalili na kubatizwa. Akunjengali Filipo kila pandu, akakangichi nginyulila na ngangachu yeikabhi ihengakeka. ");
INSERT INTO mpa_vpl VALUES ("AC8_14","074_8_14","ACT","8","14","14","Mitumi bhabhakabhi ku Yelusalemu pabhakajowini kubha bhandu bha ku Samalia nabhombi bhalijopali Lilobhi laka Chapanga, bhakabhapeliki konihoku Petulu na Yohana. ");
INSERT INTO mpa_vpl VALUES ("AC8_15","074_8_15","ACT","8","15","15","Pabhakahikiki bhakabhalobhili bhahobhalela bhala nahuli bhunjopalya Roho Mhuhu, ");
INSERT INTO mpa_vpl VALUES ("AC8_16","074_8_16","ACT","8","16","16","maghambu chikahi hechi Roho Mhuhu ngacheakunhelali mundu jokapi jola, nambu bhakabatizwi pela kwa lihina laka Bambo Yesu. ");
INSERT INTO mpa_vpl VALUES ("AC8_17","074_8_17","ACT","8","17","17","Henu, Petulu na Yohana bhakabhekiki mabhoku ghabhu panani ja bhahobhalela, nabhombi bhakunjopali Roho Mhuhu. ");
INSERT INTO mpa_vpl VALUES ("AC8_18","074_8_18","ACT","8","18","18","Simoni paakaweni kubha bhandu bhumpata Roho Mhuhu kwa kubhekakeka mabhoku gha mitumi, akapaliki kubhapekeha mbija Petulu na Yohana, ");
INSERT INTO mpa_vpl VALUES ("AC8_19","074_8_19","ACT","8","19","19","akapwaghaje, “Mbekyaje na nepani bhelabhela uwezu ghonihogho nahuli mundu jokapi jonambekila mabhoku ghangu, ajopalyaje Roho Mhuhu.” ");
INSERT INTO mpa_vpl VALUES ("AC8_20","074_8_20","ACT","8","20","20","Nambu Petulu akamuyangike, “Uhobhila kutale na mbija yako, ndandi uholakela kubha uweza kuhemela kalama jaka Chapanga kwa mbija! ");
INSERT INTO mpa_vpl VALUES ("AC8_21","074_8_21","ACT","8","21","21","Wehapa ngacheubhi na pandu kwa lihengu lenihele, maghambu mtima waku nga unyahi palongi ja mihu ghaka Chapanga. ");
INSERT INTO mpa_vpl VALUES ("AC8_22","074_8_22","ACT","8","22","22","Henu, ung'anambukaje na kuuleka uhakau waku ghongo na undobhaje Bambo, najombi pangi aweza kukulekakela maholalelu ghaubhi naghu muntima waku. ");
INSERT INTO mpa_vpl VALUES ("AC8_23","074_8_23","ACT","8","23","23","Maghambu nukubhona wehapa utweli kubhabha ngati nyongo, na ukongakiki muchifungu cha mahoku.” ");
INSERT INTO mpa_vpl VALUES ("AC8_24","074_8_24","ACT","8","24","24","Simoni akumpwaghi Petulu na Yohana, “Mnobhilaje mabhanganya kwaka Bambo, nahuli ngaghihika kumbata mambu ghankolabhike.” ");
INSERT INTO mpa_vpl VALUES ("AC8_25","074_8_25","ACT","8","25","25","Petulu na Yohana pabhajomwi kulandila ghabhaghaweni na kutangaza ubholu waka Bambo, bhakakelawiki ku Yelusalemu koni bhakatangazaje Malobhi Manyahi kwijiji yamaheli ya ku Samalia. ");
INSERT INTO mpa_vpl VALUES ("AC8_26","074_8_26","ACT","8","26","26","Mtumika wa kunani waka Bambo akumpwaghi Filipo, “Ubhokaje ujenda upambala wa kunkachi kupeta indela jejihumi ku Yelusalemu kujenda ku Gaza.” Indela heji jipetela kulipololu. ");
INSERT INTO mpa_vpl VALUES ("AC8_27","074_8_27","ACT","8","27","27","Henu, Filipo akalibhehi wichu, na kutumbu mwanja. Paakabhi mwindela akahimangini na njemalela jumu towashi wa ku Esiopia, joakabhi mundu nkolongwa wa kujemalela hindu yokapi yaka Kandake, malikia wa ku Esiopia. Akapiti ku Yelusalemu kunjojabhe Chapanga na chikahi hechi atendika kubhuja akabya akweliki mu ligali la kunhuta. ");
INSERT INTO mpa_vpl VALUES ("AC8_28","074_8_28","ACT","8","28","28","Paakabhi mu mwanja waki, akabhuja kunyumba koni atami mu ligali laki asomika chitabu chaka mlota Isaya. ");
INSERT INTO mpa_vpl VALUES ("AC8_29","074_8_29","ACT","8","29","29","Henu, Roho Mhuhu akumpwaghi Filipo, “Uheghalyaje pambipi ja ligali lenihele, ukajendaje pambipi nalu.” ");
INSERT INTO mpa_vpl VALUES ("AC8_30","074_8_30","ACT","8","30","30","Filipo akalikembali imbelu ligali lela, akunjowini akasomaje kwa sauti ngolongwa chitabu chaka mlota Isaya. Akundalukile, “Bho, ghausomaghe hagha le ughamanye?” ");
INSERT INTO mpa_vpl VALUES ("AC8_31","074_8_31","ACT","8","31","31","Mundu hojo akayangike, “Nhweza bho kumanya panga mundu wa kunongoha?” Panihapa akundobhiki Filipo akwela mu ligali la kuhuta na kutama papamu naku. ");
INSERT INTO mpa_vpl VALUES ("AC8_32","074_8_32","ACT","8","32","32","Nkolongwa hoju asomika pandu pambani pa Malembu Mahuhu: “Bhakundongwi ngati limbelele lebhajenda kulichinja, ngati mwanambelele moatumbalila, palongi jaka joanheketa mangoma, jombi ngacheakalongi lilobhi. ");
INSERT INTO mpa_vpl VALUES ("AC8_33","074_8_33","ACT","8","33","33","Bhakumpohiki lihamu na kunjima ghaakapaliki kughapata. Bho, nde nane joaweza kulandila kubhokana na kibheleku chaki? Maghambu womi waki ubhohakiki pani pundema.” ");
INSERT INTO mpa_vpl VALUES ("AC8_34","074_8_34","ACT","8","34","34","Mundu wa ku Esiopia jola akundaluki Filipo, “Umbwaghilaje, bho mlota jonjoni waka Chapanga alongela mambu ghangani panani jaka mweni au panani jaka mundu jonge?” ");
INSERT INTO mpa_vpl VALUES ("AC8_35","074_8_35","ACT","8","35","35","Henu, Filipo akatumbwi kupwagha akatumbulaje pa lilembu leakabhi asoma, akundandili Malobhi Manyahi ghaka Yesu. ");
INSERT INTO mpa_vpl VALUES ("AC8_36","074_8_36","ACT","8","36","36","Pabhakabhi bhakali kujendele na mwanja, bhakahiki pandu papabhi na machi, mundu wa ku Esiopia jola akumpwaghi Filipo, “Lingalyaje, pandu pambani pabhi na machi. Bho, chindu bholi chechiweza kunhibhalila nganibatizwa?” ");
INSERT INTO mpa_vpl VALUES ("AC8_37","074_8_37","ACT","8","37","37","Filipo akumpwaghile, “Ana ngati uhobhalela kwa mtima waku wokapi, uweza kubatizwa.” Najombi akayangiki, na kupwagha, “Hena, nhobhalela kubha Yesu Kristo nde Mwana waka Chapanga.” ");
INSERT INTO mpa_vpl VALUES ("AC8_38","074_8_38","ACT","8","38","38","Henu, mundu jola akabhohiki amuli ligali la kuhuta lela lijemaje, na bhokapi bhabhele, Filipo na towashi bhakahelili mu machi, na Filipo akumbatizi towashi jola. ");
INSERT INTO mpa_vpl VALUES ("AC8_39","074_8_39","ACT","8","39","39","Pabhakahowiki kuhuma mu machi, palapala Roho Mhuhu akuntoliki Filipo, na towashi jola ngacheambweni kabhete, nambu akajendali na mwanja waki kwa chiheku. ");
INSERT INTO mpa_vpl VALUES ("AC8_40","074_8_40","ACT","8","40","40","Filipo akaliweni mweni akabya ku Azota, akapetiki ku michi jokapi koni akatangaza Malobhi Manyahi mbaka paakahikiki ku Kaisalia. ");
INSERT INTO mpa_vpl VALUES ("AC9_1","074_9_1","ACT","9","1","1","Chikahi hechi Sauli akajonjuki kwajoghoha nakanopi na kupala kubhakoma bhabhulwa bhaka Bambo. Akapiti kwaka Mpenganyambiku Nkolongwa, ");
INSERT INTO mpa_vpl VALUES ("AC9_2","074_9_2","ACT","9","2","2","akunjopiki ampekya baluwa ja kujenda ku nyumba ya kuhimanganila Bhayahude ya ku Damasko, nahuli anaabhahimani bhandu bhabhajengalela Indela jaka Bambo, anabhabhi akanalomi au akambomba, abhakamulaje na kubhaleta ku Yelusalemu. ");
INSERT INTO mpa_vpl VALUES ("AC9_3","074_9_3","ACT","9","3","3","Chikahi paakabhi mwindela pambipi kuhika ku muchi wa ku Damasko, palapala unang'anu kuhuma kunani kumahunde ukamnang'anili ipambala yokapi. ");
INSERT INTO mpa_vpl VALUES ("AC9_4","074_9_4","ACT","9","4","4","Akaawiki pahi na kujowana sauti jakumpwaghilaje, “Sauli, Sauli! Bho, maghambu kiki uning'aha?” ");
INSERT INTO mpa_vpl VALUES ("AC9_5","074_9_5","ACT","9","5","5","Sauli akalalukile, “Bambo, bho, wehapa wa nane?” Bambo akayangike, “Nepani nde Yesu joung'aha, kunonwipi namaa kuilapula miha. ");
INSERT INTO mpa_vpl VALUES ("AC9_6","074_9_6","ACT","9","6","6","Nambu sajenu ujemaje, na ujingala ku muchi na konihoku anabhukupwaghila cheupalika kuhenga.” ");
INSERT INTO mpa_vpl VALUES ("AC9_7","074_9_7","ACT","9","7","7","Bhandu bhabhapita papamu na Sauli bhala bhakajemiki chinunu ngachebhaweziki kulongela chindu, bhakajowini sauti, nambu ngachebhumbweni mundu. ");
INSERT INTO mpa_vpl VALUES ("AC9_8","074_9_8","ACT","9","8","8","Sauli akajemiki, na paakalengiki kuyeku mihu ghaki ngacheaweziki kubhona chindu. Bhandu bhala bhakundongwihi kwa kunkamu chiwoku mbaka ku muchi wa ku Damasko. ");
INSERT INTO mpa_vpl VALUES ("AC9_9","074_9_9","ACT","9","9","9","Sauli akatamiki machobha ghatatu panga kulola, na chikahi hechi ngacheaweziki kula wala kunywa. ");
INSERT INTO mpa_vpl VALUES ("AC9_10","074_9_10","ACT","9","10","10","Bhela, ku Damasko kola kukabhi na mbulwa jumu lihina laki Anania, Bambo akumpwaghi mu mabhono, “Anania!” Anania akajetiki, “Mi pambani Bambo.” ");
INSERT INTO mpa_vpl VALUES ("AC9_11","074_9_11","ACT","9","11","11","Bambo akumpwaghile, “Ulibheka wichu ujenda kwindela jejilowakeka Indela Jejihatambwike, na ukalalukyaje kunyumba jaka Yuda mundu jumu kuhuma ku Taso joalowakeka Sauli. Sajenu andobha Chapanga, ");
INSERT INTO mpa_vpl VALUES ("AC9_12","074_9_12","ACT","9","12","12","na mu mabhono akumbweni mundu joalowakeka Anania akajingala mkati na kumbekela mabhoku nahuli aweza kulola kabhete.” ");
INSERT INTO mpa_vpl VALUES ("AC9_13","074_9_13","ACT","9","13","13","Nambu Anania akamuyangike, “Bambo, naghajowini mambu ghaka mundu jonihoju kuhuma kwa bhandu bhamahele, nyowini panani ja mahakau ghabhahengi bhandu bhaku bha ku Yelusalemu. ");
INSERT INTO mpa_vpl VALUES ("AC9_14","074_9_14","ACT","9","14","14","Jombi ahikiki pambane akabya na amuli kuhuma kwa bhapenganyambiku bhakolongwa nahuli kubhakamula bhandu bhabhalobha kwa Lihina lako.” ");
INSERT INTO mpa_vpl VALUES ("AC9_15","074_9_15","ACT","9","15","15","Nambu Bambo akumpwaghile, “Ujenda pela, maghambu nunhawi abya chombu chihaghulika kwangu, alitangazaje Lihina langu kwa bhandu bha inchi nayenge na bhakolongwa bhabhu na palongi ja bhandu bha Izilaeli. ");
INSERT INTO mpa_vpl VALUES ("AC9_16","074_9_16","ACT","9","16","16","Ananundangia ghokapi ghaapalika kung'ahika kwa ndandi ja Lihina langu.” ");
INSERT INTO mpa_vpl VALUES ("AC9_17","074_9_17","ACT","9","17","17","Bhela, Anania akapiti kujingi mu nyumba jenijela. Akabhei mabhoku ghaki panani jaka Sauli, akapwaghaje, “Undongu Sauli, Bambo Yesu mwene joakakupitalili paukabhi mwindela kuhika pambane, andumiki nahuli uweza kulola kabhete na kutwelakeka Roho Mhuhu.” ");
INSERT INTO mpa_vpl VALUES ("AC9_18","074_9_18","ACT","9","18","18","Palapala hindu ngati mang'amba ikaawiki kuhuma mu mihu ghaka Sauli, akaweziki kubhona kabhete, akajemiki na kubatizwa. ");
INSERT INTO mpa_vpl VALUES ("AC9_19","074_9_19","ACT","9","19","19","Paakakuliki chilebhe, akapatiki makili kabhete. Sauli akatami machobha machokopi papamu na bhabhulwa bha ku Damasko. ");
INSERT INTO mpa_vpl VALUES ("AC9_20","074_9_20","ACT","9","20","20","Palapala akatumbwi kutangaza mu nyumba ya kuhimangani Bhayahude kubha Yesu Kristo nde Mwana waka Chapanga. ");
INSERT INTO mpa_vpl VALUES ("AC9_21","074_9_21","ACT","9","21","21","Bhandu bhokapi bhabhunjowini Sauli bhakakangiche na kulalukila bhakapwaghaje, “Bho, mundu jonjo le ngajobhakomika bhandu bhabhalobhikaje kwa lihina laka Yesu ku Yelusalemu? Bho, kabheti ngacheahiki pambane akapala kubhakamu bhandu bhanihabha na kubhapeleka kwa ihongozi bha bhapenganyambiku koni bhakabya bhakongakike?” ");
INSERT INTO mpa_vpl VALUES ("AC9_22","074_9_22","ACT","9","22","22","Sauli akajendali kupata makili, na kubhakangacha Bhayahude bhabhatamika ku Damasko kwa kubhapwaghi kubha Yesu nde Kristo. ");
INSERT INTO mpa_vpl VALUES ("AC9_23","074_9_23","ACT","9","23","23","Paghapetiki machobha ghamaheli, Bhayahude bhakahimangini na kulongela mipangu ja kunkoma Sauli. ");
INSERT INTO mpa_vpl VALUES ("AC9_24","074_9_24","ACT","9","24","24","Nambu Sauli akajowini malobhi ghanihagha. Ikilu na muhi Bhayahude bhakalendiki milyangu ja kujingali kumbwane nahuli bhaweza kunkoma. ");
INSERT INTO mpa_vpl VALUES ("AC9_25","074_9_25","ACT","9","25","25","Nambu chikahi cha ikilu bhabhulwa bhaki bhakuntoliki, bhakunhelihi pahi mkati ja chitonga chikolongwa kwa kupetela mbekenyu jejabhi mulumato. ");
INSERT INTO mpa_vpl VALUES ("AC9_26","074_9_26","ACT","9","26","26","Sauli paakahiki ku Yelusalemu akalengiki kutama papamu na bhabhulwa bhala. Nambu bhokapi bhakunjowipe, ngachebhaweziki kunhobhalela kubha chakaka jombe akabhi mbulwa, nabhokapi bhakunjowipe. ");
INSERT INTO mpa_vpl VALUES ("AC9_27","074_9_27","ACT","9","27","27","Nambu Banaba akahikiki na kumtola Sauli, akumpeliki kwa mitumi na kubhapwaghi ntundu Sauli moakumboni Bambo mwindela na ntundu Bambo moakalongali nako. Akabhapwaghi kabheti ntundu Sauli moatangazya panga choghohi kwa lihina laka Yesu ku Damasko. ");
INSERT INTO mpa_vpl VALUES ("AC9_28","074_9_28","ACT","9","28","28","Bhela, Sauli akatami papamu nabhu akajangatana nabhu na kutangaza hotuhotu kwa lihina laka Yesu pandu pokapi pa ku Yelusalemu hoku. ");
INSERT INTO mpa_vpl VALUES ("AC9_29","074_9_29","ACT","9","29","29","Kabhete akalongi na kulochana na Bhayahude bhabhalongila Kigiliki kwa lihina laka Bambo Yesu, nambu bhombi bhalondika indela ja kunkoma. ");
INSERT INTO mpa_vpl VALUES ("AC9_30","074_9_30","ACT","9","30","30","Bhalongu bhabhunhobhale Kristo bhala pabhamanyiki lijambu leniheli, bhakuntoliki Sauli, bhakumpeliki ku Kaisalia na kuntuma ajenda ku Taso. ");
INSERT INTO mpa_vpl VALUES ("AC9_31","074_9_31","ACT","9","31","31","Chikahi hechi likanisa lokapi lakabhi na lukwali ku Yudea, ku Galilaya na ku Samalia. Bhakajonjukiki kupata makili na bhakajendali kutama mu kunjojabhe Bambo, na kwa chiheku chaka Roho Mhuhu, ubhalangiku wabhu ukajonjukiki nakanopi. ");
INSERT INTO mpa_vpl VALUES ("AC9_32","074_9_32","ACT","9","32","32","Chikahi Petulu paakabhi ajenda pandu patalipatali, lichobha limu akapiti kwa bhandu bhaka Chapanga bhabhatamika ku Lida. ");
INSERT INTO mpa_vpl VALUES ("AC9_33","074_9_33","ACT","9","33","33","Konihoku akahimangini na mundu jumu joalowakika Ainea, ambaju kwa chikahi cha hyaka nane akaghoni pa chitanda, ndandi akatei kutenguka. ");
INSERT INTO mpa_vpl VALUES ("AC9_34","074_9_34","ACT","9","34","34","Bhela, Petulu akumpwaghile, “Ainea, Yesu Kristo akulamiha. Ujumukaje utandika chitanda chaku.” Na palapala Ainea akajumwike. ");
INSERT INTO mpa_vpl VALUES ("AC9_35","074_9_35","ACT","9","35","35","Bhandu bhokapi bha ku Lida na ku Shaloni pabhumbweni Ainea akajendaje, bhakung'anambuki Bambo. ");
INSERT INTO mpa_vpl VALUES ("AC9_36","074_9_36","ACT","9","36","36","Kukabhi mbulwa jumu mbomba ku muchi wa ku Yafa lihina laki alowakika Tabisa au Dokasi kwa Kigiliki, ndandi jaki mbabhala. Mbomba hoju akabhi wamboni namaa, akahenga manyahi na kubhajangati bhahocho. ");
INSERT INTO mpa_vpl VALUES ("AC9_37","074_9_37","ACT","9","37","37","Chikahi hechi Tabisa akatei kulwala, na akapotile. Bhandu bhakajijohiki hyegha jaki, na kujibheka mu chumba cha kugholofa. ");
INSERT INTO mpa_vpl VALUES ("AC9_38","074_9_38","ACT","9","38","38","Kwa kubha ku Yafa ngachekwabhi kutali na ku Lida, na bhabhulwa pabhakajowini kubha Petulu akabhi ku Lida, bhakabhatumiki bhandu bhabhele kwaki nahuli kunjopa, “Chondi uhika kwitu manyata ngawikabhakila.” ");
INSERT INTO mpa_vpl VALUES ("AC9_39","074_9_39","ACT","9","39","39","Bhela, Petulu akajemiki na kujenda nabhu. Najombi paakahikiki, bhakumpeliki mbaka ku chumba cha kugholofa pabhakungonike. Bhabhaweliwi na bhalomi bhabhu bhamaheli bhakajemiki pambipi na Petulu, bhakalelaji na kulangi ingobhu yebhapekiwaje na Dokasi chikahi paakabhi akali mwome. ");
INSERT INTO mpa_vpl VALUES ("AC9_40","074_9_40","ACT","9","40","40","Petulu akabhapihiki bhokapi kunja, akachikimi, na kundobha Chapanga. Kabheti akung'anambuki ntuhi ghola, akapwaghaje, “Tabisa, ujumukaje.” Najombi akahekanwi mihu ghaki, na paakumbweni Petulu, akatamike. ");
INSERT INTO mpa_vpl VALUES ("AC9_41","074_9_41","ACT","9","41","41","Petulu akunkamwi chiwoku na kunjangati kujinuka, kabheti akabhalohiki bhahobhalela na bhabhaweliwi na bhalomi bhabhu, na akabhapeki bhombi akabya mwome. ");
INSERT INTO mpa_vpl VALUES ("AC9_42","074_9_42","ACT","9","42","42","Lilobhi leniheli lakamanyakini ku Yafa kwokapi na bhandu bhamaheli bhakunhobhali Bambo. ");
INSERT INTO mpa_vpl VALUES ("AC9_43","074_9_43","ACT","9","43","43","Petulu akatami ku Yafa kwa machobha ghamahele, akabhi atama kwaka mundu jumu ndenganakela wa hingumba, joalowakika Simoni. ");
INSERT INTO mpa_vpl VALUES ("AC10_1","074_10_1","ACT","10","1","1","Kukabhi na mundu jumu ku Kaisalia joalowakika Kolinelio. Jombi akabhi nkolongwa wa lipogha la manjolinjoli lelilowakika, “Lipogha la ku Italia.” ");
INSERT INTO mpa_vpl VALUES ("AC10_2","074_10_2","ACT","10","2","2","Akabhi mundu wambone, jombi papamu na bhalongu bhaki bhunjojabya Chapanga, akabhapekihi bhahochu nhupu yamaheli, na kundobha Chapanga chikahi chokapi. ");
INSERT INTO mpa_vpl VALUES ("AC10_3","074_10_3","ACT","10","3","3","Lichobha limu saa tisa ja muhi, akumbweni hotuhotu mu mabhono mtumika wa kunani kwaka Chapanga akajingala mkati ja nyumba na kumpwaghila, “Kolinelio!” ");
INSERT INTO mpa_vpl VALUES ("AC10_4","074_10_4","ACT","10","4","4","Kolinelio akundingalaki mtumika wa kunani kwaka Chapanga kwa lujoghopo, akapwaghaje, “Bho, kibhi kiki Bambo?” Mtumika wa kunani kwaka Chapanga jola akumpwaghile, “Chapanga ajowini malobhu ghaku na nhupu yaku ihikiki kunani kumahunde, na henu akukomboka. ");
INSERT INTO mpa_vpl VALUES ("AC10_5","074_10_5","ACT","10","5","5","Sajenu watumaje bhandu bhakumu ku Yafa, bhakundoha mundu jumu lihina laki Simoni, kwa lihina lengi alowakeka Petulu. ");
INSERT INTO mpa_vpl VALUES ("AC10_6","074_10_6","ACT","10","6","6","Jombi abhi kunyumba jaka Simoni ndenganakela wa hingumba, ambaju nyumba jaki jibhi pambipi na bahali.” ");
INSERT INTO mpa_vpl VALUES ("AC10_7","074_10_7","ACT","10","7","7","Mtumika wa kunani kwaka Chapanga jola paakajomwi kulonge malobhi ghanihagha na kubhoka, Kolinelio akabhalohiki bhatumika bhaki bhabhele bha pa nyumba jaki na jumu wa linjolinjoli waki joakabhi antumakila na joakabhi anjojabhe Chapanga. ");
INSERT INTO mpa_vpl VALUES ("AC10_8","074_10_8","ACT","10","8","8","Akabhapwaghi ghokapi ghaghakumpatike, na akabhatumiki bhajenda ku Yafa. ");
INSERT INTO mpa_vpl VALUES ("AC10_9","074_10_9","ACT","10","9","9","Chilabhu jaki, bhandu bhatatu bhala bhakabya bhakali mu mwanja, nambu pambipi kuhika ku Yafa, Petulu akakweliki kugholu ja nyumba chikahi cha saa sita ja muhi nahuli kundobha Chapanga. ");
INSERT INTO mpa_vpl VALUES ("AC10_10","074_10_10","ACT","10","10","10","Petulu akaweni injala, na akatokuli kula chilebhe. Nambu chilebhi pachitelakikaje akaghochi lughonu lwa kuwa na kubhona mabhono. ");
INSERT INTO mpa_vpl VALUES ("AC10_11","074_10_11","ACT","10","11","11","Akaweni kunani kumahunde kuhoghuliwi na chindu ngati ingobhu jikolongwa, jakabhi jihelela pahi jakabya jikamuliki ipambala yaki ncheche. ");
INSERT INTO mpa_vpl VALUES ("AC10_12","074_10_12","ACT","10","12","12","Mkati ja ingobhu jeniheji kukabhi na hinyama yokapi, hinyama yeibhi na magholu ncheche, hinyama yeikwabha na hijuni ya kunani. ");
INSERT INTO mpa_vpl VALUES ("AC10_13","074_10_13","ACT","10","13","13","Akajowini sauti jakumpwaghilaje, “Petulu, ujumuka uchinjaje, na ukulaje!” ");
INSERT INTO mpa_vpl VALUES ("AC10_14","074_10_14","ACT","10","14","14","Petulu akayangike, “Ngabhela, Bambo! Chakaka nepani ngachenabhali kula chindu chokapi chela chekibhi chihakau na changakupalika palongi jaka Chapanga.” ");
INSERT INTO mpa_vpl VALUES ("AC10_15","074_10_15","ACT","10","15","15","Sauti jela jakajowaniki kabhete jakumpwaghilaje, “Ngawailowa ihakau hindu yeigholuliki na Chapanga.” ");
INSERT INTO mpa_vpl VALUES ("AC10_16","074_10_16","ACT","10","16","16","Lijambu leniheli lakahengakiki mala patatu, na ingobhu jela jakatolakiki kunani kumahunde. ");
INSERT INTO mpa_vpl VALUES ("AC10_17","074_10_17","ACT","10","17","17","Petulu paakabhi akali kulilalukila panani ja ndandi ja mabhono ghanihagha, bhandu bhabhatumakiki na Kolinelio bhala pabhakajimanyi nyumba jaka Simoni, bhakahiki kujema palongi ja ndyangu. ");
INSERT INTO mpa_vpl VALUES ("AC10_18","074_10_18","ACT","10","18","18","Bhakalohiki na kulalukila, “Bho, mombo le atama ngeni joalowakeka Simoni Petulu?” ");
INSERT INTO mpa_vpl VALUES ("AC10_19","074_10_19","ACT","10","19","19","Petulu akabhi akali ngakumanya ndandi ja mabhono ghala, na panihapa Roho Mhuhu akumpwaghile, “Ujowanyaje! Bhabhi bhandu bhatatu pambane, bhakupala wehapa. ");
INSERT INTO mpa_vpl VALUES ("AC10_20","074_10_20","ACT","10","20","20","Ujinukaje na uhulukaje, na ngawisita kujenda papamu nabho, ndandi nabhatumiki nepani.” ");
INSERT INTO mpa_vpl VALUES ("AC10_21","074_10_21","ACT","10","21","21","Petulu akahulwiki na kubhapwaghi bhandu bhabhatumakiki na Kolinelio bhala, “Nepani nde jomumpala. Bho, nhwikiki kutenda bhole?” ");
INSERT INTO mpa_vpl VALUES ("AC10_22","074_10_22","ACT","10","22","22","Bhakamuyangike, “Nkolongwa wa manjolinjoli Kolinelio mundu wambone joanjojabhe Chapanga na kumanyikana na Bhayahude bhokapi, atutumiki kwaku. Jombi akalaghalakiwi na mtumika wa kunani kwaka Chapanga akulowa kunyumba jaki, nahuli akujowanya malobhi ghawampwaghilaje.” ");
INSERT INTO mpa_vpl VALUES ("AC10_23","074_10_23","ACT","10","23","23","Bhela, Petulu akabhajopalili na kubhapeke pandu pa kughonela ikilu jela. Chilabhu jaki Petulu akabhokiki nabhu papamu na bhandu bhangi bhakumu bhabhakunhobhali Kristo bha kuhuma ku Yafa. ");
INSERT INTO mpa_vpl VALUES ("AC10_24","074_10_24","ACT","10","24","24","Lichobha lelijengalyaje bhakahiki ku Kaisalia. Kolinelio akabhi abhalendalela papamu na bhalongu bhaki na bhakochi bhaki bha pambipi bhaabhakokike. ");
INSERT INTO mpa_vpl VALUES ("AC10_25","074_10_25","ACT","10","25","25","Petulu paakabhi ajingi mu nyumba, Kolinelio akapiti kunjopalela, akachikimi palongi jaki na kunjojabhela. ");
INSERT INTO mpa_vpl VALUES ("AC10_26","074_10_26","ACT","10","26","26","Nambu Petulu akanjemiki na kumpwaghila, “Ujemaje, maghambu nepani nde mundu pela.” ");
INSERT INTO mpa_vpl VALUES ("AC10_27","074_10_27","ACT","10","27","27","Petulu paakabhi alongela naku na kujingi munyumba, akabhahimani bhandu bhamaheli bhalibhongine. ");
INSERT INTO mpa_vpl VALUES ("AC10_28","074_10_28","ACT","10","28","28","Akabhapwaghile, “Mabhanganya mmanyi kubha Myahude jokapi jola akanakiwi na amuli ja dini jitu kujangatana na bhandu bhangakubha Bhayahude. Nambu Chapanga anangi kubha nganandoha mundu jokapi jola kubha muhakau au jwangakupalika. ");
INSERT INTO mpa_vpl VALUES ("AC10_29","074_10_29","ACT","10","29","29","Nde ndandi pawalaghalaki bhanowaje, nakahikili panga na kupenga chokapi chela. Bhela, nukujopa umbwagilaje, bho, ungemili lijambu bhole?” ");
INSERT INTO mpa_vpl VALUES ("AC10_30","074_10_30","ACT","10","30","30","Kolinelio akayangike, “Machobha ghatatu ghaghapetiki chikahi ngati sajenu, saa tisa ja muhi nakabhi kuchumba changu nakundobha Chapanga. Palapala mundu joakabhi na ingobhu yeing'anya akajemiki palongi jangu, ");
INSERT INTO mpa_vpl VALUES ("AC10_31","074_10_31","ACT","10","31","31","na kupwagha, ‘Kolinelio, malobhu ghaku na nhupu yaku ijetakaliwi palongi jaka Chapanga. ");
INSERT INTO mpa_vpl VALUES ("AC10_32","074_10_32","ACT","10","32","32","Bhela, untuma mundu ku Yafa akundoha mundu jumu joalowakeka Simoni, kwa lihina lengi Petulu. Jombi nde ngeni mu nyumba jaka Simoni ndenganakela wa hingumba, joju nyumba jaki jibhi pambipi na bahali.’ ");
INSERT INTO mpa_vpl VALUES ("AC10_33","074_10_33","ACT","10","33","33","Nakabhatumiki bhandu bhahika bhakulowaje, na wehapa utehi wichu kuhika. Bhela, tepani tubhi pambani palongi jaka Chapanga, tulendale kujowana ghokapi Bambo ghaakulaghalaki kutupwaghila.” ");
INSERT INTO mpa_vpl VALUES ("AC10_34","074_10_34","ACT","10","34","34","Panihapa Petulu akatumbwi kupwagha, “Sajenu manyi chakaka kubha Chapanga ngacheabhi na upendeleu. ");
INSERT INTO mpa_vpl VALUES ("AC10_35","074_10_35","ACT","10","35","35","Nambu ku kila inchi, mundu jokapi joanjojabhe Chapanga na kuhenga mambu ghambone, ajetakalewa najombi. ");
INSERT INTO mpa_vpl VALUES ("AC10_36","074_10_36","ACT","10","36","36","Mabhanganya mmanyi ubholu waka Chapanga ghoakatumiki kwa bhandu bha ku Izilaeli, ukatangaza Malobhi Manyahi ghaghaleta lukwali kwa indela jaka Yesu Kristo. Jombi nde Bambo wa bhokapi. ");
INSERT INTO mpa_vpl VALUES ("AC10_37","074_10_37","ACT","10","37","37","Mabhanganya mmanyi lijambu lelahengakiki ku inchi jokapi ja ku Yudea, kutumbu ku Galilaya baada ja ubatizu ghoatangaza Yohana. ");
INSERT INTO mpa_vpl VALUES ("AC10_38","074_10_38","ACT","10","38","38","Mmanyi ntundu Chapanga moakunjeghali Yesu wa ku Nazaleti mahuta kwa kunjeghale Roho Mhuhu na makili. Akapiti kila pandu, akahenga mambu ghambone na kubhalamiha bhandu bhabhakamuliki na makili ghaka Shetani, maghambu Chapanga akabhi papamu naku. ");
INSERT INTO mpa_vpl VALUES ("AC10_39","074_10_39","ACT","10","39","39","Tepani nde bhalandilu bha mambu ghokapi ghahengiki ku inchi ja Bhayahude na ku Yelusalemu. Panihapa bhakunkomiki kwa kunhwamba pumsalaba. ");
INSERT INTO mpa_vpl VALUES ("AC10_40","074_10_40","ACT","10","40","40","Nambu Chapanga akamuyohiki kuhuma kwa bhakuwa lichobha la tatu, na kunhenga abhonikanaje. ");
INSERT INTO mpa_vpl VALUES ("AC10_41","074_10_41","ACT","10","41","41","Ngacheabhonakini kwa bhandu bhokapi, nambu kwitu tepani tetuhaghuliki na Chapanga nahuli tubya bhalandilu bhaki, nde tepani tetakuliki na kunywa naku paakayokiki kuhuma kwa bhakuwa. ");
INSERT INTO mpa_vpl VALUES ("AC10_42","074_10_42","ACT","10","42","42","Jombi akatulaghalaki kutangaza Malobhi Manyahi kwa bhandu bhokapi na kulandila kubha jombi nde joahaghuliki na Chapanga nahuli abya Mtemula wa bhabhabhi bhomi na bhakuwa. ");
INSERT INTO mpa_vpl VALUES ("AC10_43","074_10_43","ACT","10","43","43","Bhalota bhokapi bhaka Chapanga bhakundandili, kubha kila mundu joanhobhalela ajopale kulekakewa mahoku ghaki ghokapi kwa lihina laki.” ");
INSERT INTO mpa_vpl VALUES ("AC10_44","074_10_44","ACT","10","44","44","Chikahi Petulu paakabhi akali alongela, Roho Mhuhu akabhahelali bhandu bhokapi bhabhakabhi bhajowanela ubholu ghonihoghu. ");
INSERT INTO mpa_vpl VALUES ("AC10_45","074_10_45","ACT","10","45","45","Bhayahude bhabhahikili papamu na Petulu kuhuma ku Yafa bhakakangichi kubhona kubha Chapanga abhohiki chipawa chaka Roho Mhuhu hata kwa bhandu bha inchi nayenge. ");
INSERT INTO mpa_vpl VALUES ("AC10_46","074_10_46","ACT","10","46","46","Maghambu bhakabhajowini bhakalongilaje kwa lugha nayenge koni bhakundumbalya Chapanga. Panihapa Petulu akapwaghike: ");
INSERT INTO mpa_vpl VALUES ("AC10_47","074_10_47","ACT","10","47","47","“Bhandu abhabha bhunjopali Roho Mhuhu ngati tepani motunjopalile. Bho, abhi mundu joaweza kubhahibhalakila ngabhibatizwa kwa machi?” ");
INSERT INTO mpa_vpl VALUES ("AC10_48","074_10_48","ACT","10","48","48","Bhela, Petulu akalaghalaki bhabatizwaje kwa lihina laka Yesu Kristo. Kabheti bhakunjopiki jombi atama nabhu kwa machobha machokope. ");
INSERT INTO mpa_vpl VALUES ("AC11_1","074_11_1","ACT","11","1","1","Mitumi na bhalongu bhahobhalela bhabhakabhi ku Yudea bhakajowini kubha bhandu bhangakubha Bhayahude nabhombi bhalijopali Lilobhi laka Chapanga. ");
INSERT INTO mpa_vpl VALUES ("AC11_2","074_11_2","ACT","11","2","2","Bhela, Petulu paakelawiki ku Yelusalemu, Bhayahude bhala bhabhakamulakili kubha bhandu bhangakubha Bhayahude bhahekata jando, bhakatei kulochana naku, ");
INSERT INTO mpa_vpl VALUES ("AC11_3","074_11_3","ACT","11","3","3","bhakapwaghaje, “Ukapiti kunyumba ya bhandu bhangakuheketa jando, nanau ukakuliki chilebhi papamu nabhu!” ");
INSERT INTO mpa_vpl VALUES ("AC11_4","074_11_4","ACT","11","4","4","Panihapa nde Petulu akatumbwi kubhalandi mambu ghokapi ngati moghabhelile kutumba pakutumbula: ");
INSERT INTO mpa_vpl VALUES ("AC11_5","074_11_5","ACT","11","5","5","“Lichobha limu nakabhi ku muchi wa ku Yafa nakundobha Chapanga, nakabya mulughonu lwa kupotela nakaweni mabhono. Nakaweni chindu ngati ingobhu ngolongwa jihelela kuhuma kunani kumahunde jakabya jikamuliki ipambala yaki ncheche, na kunheghalela pambipi jangu. ");
INSERT INTO mpa_vpl VALUES ("AC11_6","074_11_6","ACT","11","6","6","Panakalingalaki mkati jaki wichu, nakaweni hinyama yeibhi na magholu ncheche, hinyama ya kudimakika, hinyama ya muchitengu, yeikwabha na ijuni ya kunani. ");
INSERT INTO mpa_vpl VALUES ("AC11_7","074_11_7","ACT","11","7","7","Panihapa nakajowini sauti jakambwaghilaje, ‘Petulu, ujumukaje uchinja na ukulaje!’ ");
INSERT INTO mpa_vpl VALUES ("AC11_8","074_11_8","ACT","11","8","8","Nambu nepani nakayangike, ‘Ngabhela, Bambo! Maghambu ngachenabhali kula chilebhi chokapi chela chechibhi chihakau na changakujetakalewa kwaka Chapanga mu ndomu jangu.’ ");
INSERT INTO mpa_vpl VALUES ("AC11_9","074_11_9","ACT","11","9","9","Nambu sauti jakalongi kabheti mala jakabhele kuhuma kunani kumahunde jakapwaghaje, ‘Ngawailowa ihakau hindu yeigholuliki na Chapanga.’ ");
INSERT INTO mpa_vpl VALUES ("AC11_10","074_11_10","ACT","11","10","10","Mambu ghanihagha ghakajowaniki mala patatu, na hindu yela yokapi ikakwehakiki kunani kumahunde kabhete. ");
INSERT INTO mpa_vpl VALUES ("AC11_11","074_11_11","ACT","11","11","11","Palapala bhandu bhatatu bhabhatumakiki kwangu kuhuma ku Kaisalia bhakahikili panyumba jendamikaje. ");
INSERT INTO mpa_vpl VALUES ("AC11_12","074_11_12","ACT","11","12","12","Roho Mhuhu akambwaghi nyendaje papamu nabhu nganikotoka. Bhahobhalela abhabha sita bhamwabhona bhakanhindakile, na tepani tabhokapi tukakapiti kujingila mu nyumba jaka Kolinelio. ");
INSERT INTO mpa_vpl VALUES ("AC11_13","074_11_13","ACT","11","13","13","Akatupwaghi ntundu moamboni mtumika wa kunani waka Chapanga joakajemi mu nyumba jaki na kumpwaghila, ‘Watuma bhandu ku Yafa bhajenda bhakundoha Simoni, kwa lihina lengi Petulu. ");
INSERT INTO mpa_vpl VALUES ("AC11_14","074_11_14","ACT","11","14","14","Jombi anaakupwaghila ubholu nahuli wehapa na bhalongu bhaku bhokapi mpata kukengalewa.’ ");
INSERT INTO mpa_vpl VALUES ("AC11_15","074_11_15","ACT","11","15","15","Panatumbwi kulongela, Roho Mhuhu akabhahelalili panani jabhu ngati moakatuhelali tepani pakutumbula hapa. ");
INSERT INTO mpa_vpl VALUES ("AC11_16","074_11_16","ACT","11","16","16","Panihapa nakakombwiki malobhi Bambo ghaalongili kubha, ‘Yohana abatiza kwa machi, nambu mwehapa anambatizwaje kwa Roho Mhuhu.’ ");
INSERT INTO mpa_vpl VALUES ("AC11_17","074_11_17","ACT","11","17","17","Bhela ngati Chapanga abhapeki bhandu bhangakubha Bhayahude nhupu wa Roho Mhuhu jolajola joatupeki na tepani tetunhobhali Bambo Yesu Kristo, bho, nepani na nane mbaka nhweza kumpenga Chapanga?” ");
INSERT INTO mpa_vpl VALUES ("AC11_18","074_11_18","ACT","11","18","18","Bhalongu bhahobhalela pabhajowini mambu ghanihagha, bhakatumbili na kundumbali Chapanga, bhakapwaghaje, “Henu Chapanga abhapeki bhandu bhangakubha Bhayahude mbekenyu ja kung'anambuka na kughaleka mahoku nahuli kupata womi wa mileli!” ");
INSERT INTO mpa_vpl VALUES ("AC11_19","074_11_19","ACT","11","19","19","Kubhokana na mang'ahiku ghaghapitali chikahi pabhunkomiki Stefano, bhahobhalela bhakapechangine. Bhangi bhakapiti ku inchi ja ku Foinike, ku Kipulo na ku Antiokia, bhakatangaza ubholu kwa Bhayahude pela. ");
INSERT INTO mpa_vpl VALUES ("AC11_20","074_11_20","ACT","11","20","20","Nambu bhahobhalela bhangi bhabhahumiki ku Kipulo na ku Kilene, bhakapiti ku Antiokia bhakatangaza Malobhi Manyahi ghaka Bambo Yesu Kristo kwa Bhagiliki. ");
INSERT INTO mpa_vpl VALUES ("AC11_21","074_11_21","ACT","11","21","21","Makili ghaka Bambo ghakabhi papamu nabhu, na ubhalangiku ukolongwa wa bhandu bhakahobhalile na kung'anambuki Bambo. ");
INSERT INTO mpa_vpl VALUES ("AC11_22","074_11_22","ACT","11","22","22","Likanisa la ku Yelusalemu palajowini mambu ghanihagha, bhakuntumiki Banaba ajenda ku Antiokia. ");
INSERT INTO mpa_vpl VALUES ("AC11_23","074_11_23","ACT","11","23","23","Paakahikiki na kubhona ntundu Chapanga moabhapeki chihomu bhandu bhala, akahekalili na kubhajeghe mtima bhokapi bhatama mu ulongwana wabhu kwaka Bambo kwa mitima jabhu jokapi. ");
INSERT INTO mpa_vpl VALUES ("AC11_24","074_11_24","ACT","11","24","24","Banaba akabhi mundu wambone, na joakatweli Roho Mhuhu na uhobhalelu, bhandu bhamahele bhakajonjukiki kwaka Bambo. ");
INSERT INTO mpa_vpl VALUES ("AC11_25","074_11_25","ACT","11","25","25","Bhela Banaba akapiti ku Taso kundonda Sauli. ");
INSERT INTO mpa_vpl VALUES ("AC11_26","074_11_26","ACT","11","26","26","Paambweni, akundetiki ku Antiokia. Bhokapi bhabhele bhakatami na likanisa kwa chaka chokapi bhakabhola lipogha likolongwa la bhandu. Kukabhi ku Antiokia kobhatumbula bhahobhalela bhaka Kristo kulowakeka Bhakristo. ");
INSERT INTO mpa_vpl VALUES ("AC11_27","074_11_27","ACT","11","27","27","Chikahi chenihechi bhalota bhaka Chapanga bhakaheli kuhuma ku Yelusalemu mbaka ku Antiokia. ");
INSERT INTO mpa_vpl VALUES ("AC11_28","074_11_28","ACT","11","28","28","Jumu wabhu joalowakika Agabo akajemiki, na kwa uwezu waka Roho Mhuhu akalotiki kubha kwibya na injala ngolongwa pundema pokapi. Injala heji jakapitali chikahi cha utawala waka Klaudio. ");
INSERT INTO mpa_vpl VALUES ("AC11_29","074_11_29","ACT","11","29","29","Bhabhulwa bhakajetangani kubha kila jumu kulengana na uwezu waki apelaka chokapi nahuli kubhajangati bhahobhalela bhabhatamika ku Yudea. ");
INSERT INTO mpa_vpl VALUES ("AC11_30","074_11_30","ACT","11","30","30","Bhakatei bhenibhela, na kubhapeke Banaba na Sauli nchangu wabbu nahuli bhapelaka bhombi kwa ihongozi bha likanisa. ");
INSERT INTO mpa_vpl VALUES ("AC12_1","074_12_1","ACT","12","1","1","Pa machobha ghanihagha nkolongwa Helode akatumbwi kubhahenge uhakau bhandu bhakumu bha likanisa. ");
INSERT INTO mpa_vpl VALUES ("AC12_2","074_12_2","ACT","12","2","2","Akabhohiki lilaghalakilu kubha Yakobo, ndongu waka Yohana, akomakikaje kwa lipanga. ");
INSERT INTO mpa_vpl VALUES ("AC12_3","074_12_3","ACT","12","3","3","Paakaweni kubha kihengu chenihechi Bhayahude bhatehi kuchihekalela, akajendali kumbeka Petulu muligeleza. Mambu ghanihagha ghakahengakiki pa chikahi cha uwangalalu wa Bhayahude wa kula mabumunda ghangakujegaleka amila. ");
INSERT INTO mpa_vpl VALUES ("AC12_4","074_12_4","ACT","12","4","4","Paakunkamwili Petulu, akunkongiki muligeleza, na kumbeka pahi ja ulingalilu wa mapogha nchechi gha manjolinjoli nchechinchechi. Helode akapaliki pawakapeta Uwangalalu wa Pasaka akumpiya palongi ja bhandu. ");
INSERT INTO mpa_vpl VALUES ("AC12_5","074_12_5","ACT","12","5","5","Bhela Petulu akabhekakiki muligeleza, nambu likanisa lakabhi lundobhela kwaka Chapanga kwa mtima wokapi. ");
INSERT INTO mpa_vpl VALUES ("AC12_6","074_12_6","ACT","12","6","6","Ikilu panga na kuhika lichobha leapalika nkolongwa Helode kumpiya Petulu kwa bhandu, Petulu akabhi aghonili pachilanda ja manjolinjoli bhabhele. Akabhi akongakiki minyololu jibhele, na bhalonda bhakabhi bhalenda pundyangu wa ligeleza. ");
INSERT INTO mpa_vpl VALUES ("AC12_7","074_12_7","ACT","12","7","7","Palapala mtumika wa kunani kwaka Bambo akajemiki panipala, na unang'anu ukanang'ini mu chumba chela. Mtumika jonihoju akunyuhiki Petulu palibhegha, akunjumwi, akapwaghaje, “Ujemaje! Manyata!” Palapala minyololu jakabhopwiki kuhuma mu mabhoku ghaka Petulu. ");
INSERT INTO mpa_vpl VALUES ("AC12_8","074_12_8","ACT","12","8","8","Bhela mtumika jola akumpwaghile, “Ukonga nkungilu waku na uwata magubasi ghaku.” Petulu akahengiki bhenibhela. Bhela akumpwaghile, “Uwata likoti laku na unyengalyaje.” ");
INSERT INTO mpa_vpl VALUES ("AC12_9","074_12_9","ACT","12","9","9","Petulu akunjengali mbaka kunja ja paligeleza, nambu ngacheamanyi kubha mambu ghaahengika mtumika wa kunani kwaka Chapanga ghakabhi gha chakaka, ahambukya aweni mabhono. ");
INSERT INTO mpa_vpl VALUES ("AC12_10","074_12_10","ACT","12","10","10","Bhakabhapetiki lipogha la kutumbula la bhalonda na bhakabhele, bhakahiki mbaka pundyangu wa choma wa kujingali mu muchi. Ndyangu ukabhopwiki weni, nabhombi bhakapitike. Bhakabhi bhajenda mu indela jimu, na palapala mtumika wa kunani kwaka Chapanga jola akundehi Petulu. ");
INSERT INTO mpa_vpl VALUES ("AC12_11","074_12_11","ACT","12","11","11","Panihapa Petulu akamanyiki kubha mambu ghaghahengakiki ghakabhi gha chakaka, akapwaghike, “Sajenu manyi chakaka kubha Bambo akuntumiki mtumika waki wa kunani kumahunde kungengalela kuhuma mu mabhoku ghaka Helode na mambu ghokapi Bhayahude ghabhakabhi bhalendale kupitalila.” ");
INSERT INTO mpa_vpl VALUES ("AC12_12","074_12_12","ACT","12","12","12","Paakabhi amanyiki mambu ghaghapitalili, akapiti kunyumba jaka Malia mabhu waka Yohana joalowakika Mako. Bhandu bhamaheli bhakahimangini monimola bhakundobha Chapanga. ");
INSERT INTO mpa_vpl VALUES ("AC12_13","074_12_13","ACT","12","13","13","Petulu akahodimi kunja ja ndyangu, mtumika jumu wa chimbomba joalowakika Loda akahikiki kunjeteka. ");
INSERT INTO mpa_vpl VALUES ("AC12_14","074_12_14","ACT","12","14","14","Paajimanyi sauti jaka Petulu akahekali namaa, na ngacheakahowi ndyangu, akakembali mkati na kubhapwaghi kubha Petulu ajemi kunja ja ndyangu. ");
INSERT INTO mpa_vpl VALUES ("AC12_15","074_12_15","ACT","12","15","15","Bhakumpwaghile, “Ubhi na mangongo!” Nambu paakajendali kubhapwaghi kubha chakaka. Bhakamuyangiki, “Jonihoju nde mtumika waki wa kunani kwaka Chapanga.” ");
INSERT INTO mpa_vpl VALUES ("AC12_16","074_12_16","ACT","12","16","16","Petulu akabhi akali kujendale kulowa. Pakujomukela bhakahowi ndyangu, na pabhumbweni, bhakakangichi namaa. ");
INSERT INTO mpa_vpl VALUES ("AC12_17","074_12_17","ACT","12","17","17","Akabhakinyuli kwa chiwoku chaki bhatumbalaje, akabhalandi ntundu Bambo moakumpiki muligeleza. Akapapwaghaje, “Mumpwaghila Yakobo na bhahobhalela bhangi bhabhunhobhale Kristo kubhokana na mambu ghane.” Bhela akabhalekiki na kujenda pandu pangi. ");
INSERT INTO mpa_vpl VALUES ("AC12_18","074_12_18","ACT","12","18","18","Pakwachili, bhalonda bhakabhi na choghohi chikolongwa kubhokana na mambu ghaghumpitali Petulu. ");
INSERT INTO mpa_vpl VALUES ("AC12_19","074_12_19","ACT","12","19","19","Helode akalaghalaki bhundondaje, nambu ngachebhumbwene. Bhela akabhalaluki bhalonda bhala na kulaghalaki bhakomakikaje. Panihapa Helode akaheli kuhuma ku Yudea na kujenda kutama ku Kaisalia kwa chikahi. ");
INSERT INTO mpa_vpl VALUES ("AC12_20","074_12_20","ACT","12","20","20","Helode akabhahakali namaa bhandu bha ku Tilo na ku Sidoni, bhela bhakumpelaki bhabholu bhakundingaje. Bhakatumbwi hoti kumpwaghi Blasto abya upambala wabhu, joakabhi njemalela wa chumba cha kughonela chaka nkolongwa. Bhela bhakajopiki majonganu gha lukwale kwaka Helode, maghambu inchi jabhu jijihobhalya inchi jaka nkolongwa hoju kwa kupata chilebhe. ");
INSERT INTO mpa_vpl VALUES ("AC12_21","074_12_21","ACT","12","21","21","Mu lichobha lelahaghuliwi, Helode akabya awati ingobhu yaki ya kikolongwa, akatami pa chitehu chaki cha ukolongwa, na kubhatangazi bhandu. ");
INSERT INTO mpa_vpl VALUES ("AC12_22","074_12_22","ACT","12","22","22","Bhandu bhabhakabhi panipala bhakajamalili, bhakapwaghaje, “Haje nga sauti jaka mundu, nambu nde sauti jaka chapanga!” ");
INSERT INTO mpa_vpl VALUES ("AC12_23","074_12_23","ACT","12","23","23","Palapala mtumika wa kunani kwaka Chapanga akamuhawi pahi Helode, maghambu ngacheakumpeki Bambo ulumbalilu. Akalelakiki na imbeku na kupotela. ");
INSERT INTO mpa_vpl VALUES ("AC12_24","074_12_24","ACT","12","24","24","Nambu Lilobhi laka Chapanga lakajendali kujaghanila na bhandu bhamaheli bhakajetangani nalu. ");
INSERT INTO mpa_vpl VALUES ("AC12_25","074_12_25","ACT","12","25","25","Banaba na Sauli pabhakabhi bhajomwi lihengu labhu, bhakabhokiki kabhete ku Yelusalemu, bhakabya bhuntoliki Yohana joalowakika Mako papamu nabhu. ");
INSERT INTO mpa_vpl VALUES ("AC13_1","074_13_1","ACT","13","1","1","Mu likanisa la ku Antiokia kukabhi na bhandu bhakumu bhabhakabhi bhalota bhaka Chapanga na bhabhola, pachilanda jabhu akabhi Banaba, Simoni joalowakika Nigeri au Mpile, Lukio mundu wa ku Kilene, na Manaeni ndongu wa kulelewa na nkolongwa Helode, na Sauli. ");
INSERT INTO mpa_vpl VALUES ("AC13_2","074_13_2","ACT","13","2","2","Pabhakabhi bhunjojabhe Bambo na kukonga kula chilebhe, Roho Mhuhu akabhapwaghile, “Munihaghulya Banaba na Sauli, bhahenga lihengu lenabhakemile.” ");
INSERT INTO mpa_vpl VALUES ("AC13_3","074_13_3","ACT","13","3","3","Bhela bhakakongiki kula chilebhe na kundobha Chapanga, bhakabhabheki mabhoku panani jabhu, na kubhaleka bhajendaje. ");
INSERT INTO mpa_vpl VALUES ("AC13_4","074_13_4","ACT","13","4","4","Banaba na Sauli pabhakabhi bhatumakiki na Roho Mhuhu, bhakaheli mbaka ku Seleukia, na kuhuma konihoku bhakajingi mu sitima mbaka ku chilu cha ku Kipulo. ");
INSERT INTO mpa_vpl VALUES ("AC13_5","074_13_5","ACT","13","5","5","Pabhahikiki ku muchi wa ku Salami, bhakatangizi Lilobhi laka Chapanga mu nyumba ya kuhimangani Bhayahude. Yohana joakalowakiki Mako akabhi papamu nabhu kubhajangatila kuhenga lihengu. ");
INSERT INTO mpa_vpl VALUES ("AC13_6","074_13_6","ACT","13","6","6","Pabhakapetiki mu chilu chela chokapi bhakahikiki ku muchi wa ku Pafo, konihoku bhakahimangini na Myahude jumu nhwabhi joakabhi mlota wa icholi, lihina laki Bar-Yesu. ");
INSERT INTO mpa_vpl VALUES ("AC13_7","074_13_7","ACT","13","7","7","Akabhi nkochi waka mtawala wa chilu chela, joalowakika Seligio Paulo, mundu joakabhi na malangu ghamahele. Mtawala jola akabhalohiki Banaba na Sauli nahuli kulijowanela Lilobhi laka Chapanga. ");
INSERT INTO mpa_vpl VALUES ("AC13_8","074_13_8","ACT","13","8","8","Nambu Elima, nhwabi jola, ngati moalowakakya kwa Kigiliki, akapengini nabhu, koni akapala kung'anambula mtawala wa chilu jola nahuli ngayijetakela uhobhalelu wa Kikristo. ");
INSERT INTO mpa_vpl VALUES ("AC13_9","074_13_9","ACT","13","9","9","Panihapa Sauli joalowakika Paulo, akabya atwelakiki Roho Mhuhu, akundingalaki mihu nduu, ");
INSERT INTO mpa_vpl VALUES ("AC13_10","074_13_10","ACT","13","10","10","na kupwagha, “Wehapa wa mwana waka Shetani! Wehapa nde adui wa kila chindu chambone. Utweli kila ntundu wa hindu ihakau, na machobha ghokapi ngacheulepa kuhing'anambula indela yaka Bambo ya chakaka na kubha ya ichole! ");
INSERT INTO mpa_vpl VALUES ("AC13_11","074_13_11","ACT","13","11","11","Henu makili ghaka Bambo anaghahika panani jaku, anaubya ngalola na ngawaubhoni unang'anu wa lyobha kwa chikahi.” Palapala mihu ghaka Elima ghakapatiki ngongwahi na lubhendu, akatumbwi kuyongolota nahuli kumpapaa mundu wa kunkamu chiwoku na kundongowa. ");
INSERT INTO mpa_vpl VALUES ("AC13_12","074_13_12","ACT","13","12","12","Mtawala wa chilu jola paakaweni mambu ghaghahengakiki, akahobhalile, na kukangacha namaa mabholu ghaakajowini panani jaka Bambo. ");
INSERT INTO mpa_vpl VALUES ("AC13_13","074_13_13","ACT","13","13","13","Paulo na bhajaki bhakalombwiki kuhuma ku Pafo na kuhika ku Pega, muchi wa ku Pamfilia, konihoku Yohana akabhalekiki na kukelabhuka ku Yelusalemu. ");
INSERT INTO mpa_vpl VALUES ("AC13_14","074_13_14","ACT","13","14","14","Kubhoke pa Pega bhakapiti ku muchi wa ku Antiokia ja ku Pisidia. Lichobha la Sabato bhakajingi mu nyumba ja kuhimangani Bhayahude, na kutama. ");
INSERT INTO mpa_vpl VALUES ("AC13_15","074_13_15","ACT","13","15","15","Paakasomiki mu chitabu cha Shelia na mu itabu ya bhalota bhaka Chapanga, ihongozi bha mu nyumba ja kuhimangani Bhayahude bhakabhapwaghi ubholu ghongo, “Bhalongo, ngati anambi na lilobhi la kubhajeghe mtima bhandu abhabha, ndongilaje.” ");
INSERT INTO mpa_vpl VALUES ("AC13_16","074_13_16","ACT","13","16","16","Paulo akajemiki, na kubhaponge chiwoku na kupwagha, “Mwabhalongu bhangu Bhaizilaeli papamu na bhandu bhokapi bhangakubha Bhayahude mwemunjojabhe Chapanga pani pa Izilaeli, nyowanyaje! ");
INSERT INTO mpa_vpl VALUES ("AC13_17","074_13_17","ACT","13","17","17","Chapanga wa bhandu bha ku Izilaeli akabhahawi akahoko bhitu, akabhahengiki bhabya bhandu bhamaheli nakanopi pabhakabhi bhatama kugheni ku inchi ja Misili. Chapanga akabhabhohiki konihoku kwa uwezu waki ukolongwa. ");
INSERT INTO mpa_vpl VALUES ("AC13_18","074_13_18","ACT","13","18","18","Chapanga akabhahinakali matendu ghabhu kwa hyaka alobaini chikahi pabhakabhi kulipololu. ");
INSERT INTO mpa_vpl VALUES ("AC13_19","074_13_19","ACT","13","19","19","Akaghakomiki makabila saba gha inchi ja Kanaani, na kubhapeke bhandu bhaki upwelelu wa inchi jabhu. ");
INSERT INTO mpa_vpl VALUES ("AC13_20","074_13_20","ACT","13","20","20","Ghokapi hagha ghakatohi hyaka mia nne na hamsine. “Kubhoke panihapa, Chapanga akabhapeki bhatemula chikahi chaka mlota Samweli. ");
INSERT INTO mpa_vpl VALUES ("AC13_21","074_13_21","ACT","13","21","21","Panihapa bhandu bhakajopiki bhabya na nkolongwa, na Chapanga akabhapeki Sauli mwana waka Kishi wa likabila laka Benyamini, ambaju akajemali kwa chikahi cha hyaka alobaine. ");
INSERT INTO mpa_vpl VALUES ("AC13_22","074_13_22","ACT","13","22","22","Paambohiki Sauli, Chapanga akabhapeki Daude abya nkolongwa wabhu. Lendenu nde Chapanga leakalongili panani jaki, ‘Numbweni Daude mwana waka Yese, mundu joajendana na mtima wangu, joanahenga mambu ghokapi ghanipala ahengaje.’ ");
INSERT INTO mpa_vpl VALUES ("AC13_23","074_13_23","ACT","13","23","23","Kuhuma mu lubheleku lwaka mundu joni, Chapanga akalaghalaki anaabhapekya bhandu bha ku Izilaeli Mkengalela, yani Yesu. ");
INSERT INTO mpa_vpl VALUES ("AC13_24","074_13_24","ACT","13","24","24","Mangane ja kuhika Yesu, Yohana akalongulili kwa kubhatangazi bhandu bhokapi bha Izilaeli panani ja kung'anambuka na kughaleka mahoku ghabhu na kubatizwa. ");
INSERT INTO mpa_vpl VALUES ("AC13_25","074_13_25","ACT","13","25","25","Yohana paajomula lihengu laki akabhalaluki bhandu, ‘Bho, muholake nepani nde nane? Nepani nga jomundendalela. Ndingalya! Jombi anaahika punyuma jangu, na nepani ngachembalika kumbopo mighoji ja magubasi ghaki.’ ");
INSERT INTO mpa_vpl VALUES ("AC13_26","074_13_26","ACT","13","26","26","“Mwalongu bhangu Bhaizilaeli, mabhana bha lukolu lwaka Ibulahimu, na mabhandu bhangakubha Mwayahude mwemunjojabhe Chapanga, nde kwandi jitu tepani ubholu ghongoni wa ukengaleku uletakiki. ");
INSERT INTO mpa_vpl VALUES ("AC13_27","074_13_27","ACT","13","27","27","Maghambu bhandu bha ku Yelusalemu na ihongozi bhabhu ngachebhummanyi kubha jombi nde Yesu, kabheti ngachebhaghamanyi kubha mambu ghabhalongila bhalota bhaka Chapanga mu kila Lichobha la Sabato. Papamu na bhenibhela, bhakaghahengiki mambu gha bhalota bhaka Chapanga ghapitilaje chakaka kwa kunkoma Yesu. ");
INSERT INTO mpa_vpl VALUES ("AC13_28","074_13_28","ACT","13","28","28","Nambu hata koni ngachebhunhimani na uhakau ghoumpalika kukomakeka, bhakunjopiki Pilato antemula kupotela. ");
INSERT INTO mpa_vpl VALUES ("AC13_29","074_13_29","ACT","13","29","29","Pabhajomwi kuhenga ghokapi ghaghalembakiki panani jaki, bhakunheli kuhuma pamsalaba na kumbeka mu litengele. ");
INSERT INTO mpa_vpl VALUES ("AC13_30","074_13_30","ACT","13","30","30","Nambu Chapanga akamuyohiki kuhuma kwa bhabhapotile. ");
INSERT INTO mpa_vpl VALUES ("AC13_31","074_13_31","ACT","13","31","31","Jombi kwa machobha ghamahele akabhapitali bhabhalongana naku kuhuma ku Galilaya mbaka ku Yelusalemu. Bhanganya habha nde bhabhabhi sajenu bhalandilu bhaki kwa bhandu. ");
INSERT INTO mpa_vpl VALUES ("AC13_32","074_13_32","ACT","13","32","32","Tepani tuhikiki kundete Malobhi Manyahi, lilobhi lela Bambo leabhapwaghi akahoko bhitu, ");
INSERT INTO mpa_vpl VALUES ("AC13_33","074_13_33","ACT","13","33","33","sajenu atimizi kwa lubheleku lwitu kwa kumuyoha Yesu kuhuma kwa bhakuwa. Ngati moilembakike mu Zabuli ja kabhele, ‘Wehapa wa Mwanango, lalenu mili Atati waku.’ ");
INSERT INTO mpa_vpl VALUES ("AC13_34","074_13_34","ACT","13","34","34","Ghangani nde mambu ghaakalongi Chapanga panani ja kumuyoha kuhuma kwa bhakuwa, nahuli ngaahibhola, ‘Ananukupekya wehapa upengalelu unyahi na wa chakaka ghonalaghi ananumpekya Daude.’ ");
INSERT INTO mpa_vpl VALUES ("AC13_35","074_13_35","ACT","13","35","35","Ena pandu pangi pa Zabuli palembakiki ana, ‘Ngawandeki Mhuhu waku abholaje.’ ");
INSERT INTO mpa_vpl VALUES ("AC13_36","074_13_36","ACT","13","36","36","Nambu Daude mweni akahengiki ghaghumpalika anhengila Chapanga kwa chikahi chaki, bhela akapotili, bhakuntaghiki papamu na bhazee bhaki, na hyegha jaki jakabholiki. ");
INSERT INTO mpa_vpl VALUES ("AC13_37","074_13_37","ACT","13","37","37","Nambu ajoju ambaju Chapanga joakamuyohiki kuhuma kwa bhakuwa, chakaka ngacheakabholike. ");
INSERT INTO mpa_vpl VALUES ("AC13_38","074_13_38","ACT","13","38","38","Henu, mwabhalongu bhangu Bhaizilaeli, mbala mmanya kubha kwa kupetela kwaka Yesu kulekakewa mahoku kutangazwa kwinu. ");
INSERT INTO mpa_vpl VALUES ("AC13_39","074_13_39","ACT","13","39","39","Kwa kupetela kwaka Yesu, kila mundu joanhobhalela alekakewa mahoku ghokapi, kihengu hechi ngachakawezakini kwa indela ja Shelia jaka Musa. ");
INSERT INTO mpa_vpl VALUES ("AC13_40","074_13_40","ACT","13","40","40","Mulilingalyaje, ngaghihika kumpata mambu ghala ghabhalongila bhalota bhaka Chapanga: ");
INSERT INTO mpa_vpl VALUES ("AC13_41","074_13_41","ACT","13","41","41","‘Ndingalya mwendongama bhajinu, mkangacha na muhobhaje! Maghambu chindu chenikihenga sajenu pa machobha ghinu, chindu hechi ngamwakijetakeli hata ngati mundu anaampwaghile!’ ” ");
INSERT INTO mpa_vpl VALUES ("AC13_42","074_13_42","ACT","13","42","42","Paulo na Banaba pabhakapitiki kunja ja nyumba ja kuhimangani Bhayahude jela, bhandu bhangakubha Bhayahude bhakabhajopiki bhahika kabheti kulongela nakanopi panani ja mambu ghanihagha mu Lichobha la Sabato najenge. ");
INSERT INTO mpa_vpl VALUES ("AC13_43","074_13_43","ACT","13","43","43","Uhimanganu hoghu pawajomwiki, Bhayahude bhamaheli na bhandu bhangakubha Bhayahude bhabhahobhalile dini ja Kiyahude bhakabhajengali Paulo na Banaba. Mitumi bhakalongi nabhu, bhakabhajegi mtima bhajendalya kutama bahkahobhalya chihomu chaka Chapanga. ");
INSERT INTO mpa_vpl VALUES ("AC13_44","074_13_44","ACT","13","44","44","Lichobha la Sabato jejijengalyaje, kalibu bhandu bhokapi bha muchi ghonighola bhakahiki kujowanela Lilobhi laka Chapanga. ");
INSERT INTO mpa_vpl VALUES ("AC13_45","074_13_45","ACT","13","45","45","Nambu Bhayahude pabhakaliweni lipogha la bhandu lela, bhakatweli wihu, na kughapenga malobhi ghokapi ghaalongila Paulo, na kuntondola. ");
INSERT INTO mpa_vpl VALUES ("AC13_46","074_13_46","ACT","13","46","46","Panihapa Paulo na Banaba bhakabhayangiki kwa makakala, bhakapwaghaje, “Ikabhi lazima Lilobhi laka Chapanga lunhikila hoti mabhanganya. Nambu maghambu ntehi kulikana na kulibhona ngachempalika womi wa mileli, henu tutenda kundeka na kubhajende bhandu bhangakubha Bhayahude. ");
INSERT INTO mpa_vpl VALUES ("AC13_47","074_13_47","ACT","13","47","47","Maghambu Bambo akatulaghalaki ana: ‘Nukubhehi wehapa ubya unang'anu kwa bhandu bhangakubha Bhayahude, nahuli wabhaletila bhandu ukengaleku pundema wokapi.’ ” ");
INSERT INTO mpa_vpl VALUES ("AC13_48","074_13_48","ACT","13","48","48","Bhandu bhangakubha Bhayahude pabhajowini mambu ghanihagha, bhakahekali namaa na kuulumbalila ubholu waka Bambo, na bhabhakabhi bhahaghuliki kupata womi wa mileli bhakahobhalile. ");
INSERT INTO mpa_vpl VALUES ("AC13_49","074_13_49","ACT","13","49","49","Lilobhi laka Bambo lakajaghani pandu pokapi pa inchi jenijela. ");
INSERT INTO mpa_vpl VALUES ("AC13_50","074_13_50","ACT","13","50","50","Nambu Bhayahude bhakabhachokaki akambomba bhabhakabhi na lujiniku nakanopi na kunjojabhe Chapanga, bhabhabhi na yehu papamu na ihongozi bha muchi ghonihoghu, na akanalomi bhabhamanyakini bha muchi ghola. Bhakatumbwi kubhang'aha Paulo na Banaba na kubhatopola pa muchi wabhu. ");
INSERT INTO mpa_vpl VALUES ("AC13_51","074_13_51","ACT","13","51","51","Mitumi bhakakung'windi luhombi mu magholu ghabhu ngati ulakalilu na bhakapiti ku Ikonio. ");
INSERT INTO mpa_vpl VALUES ("AC13_52","074_13_52","ACT","13","52","52","Na bhabhulwa bha ku Antiokia bhakatweli chiheku na Roho Mhuhu. ");
INSERT INTO mpa_vpl VALUES ("AC14_1","074_14_1","ACT","14","1","1","Ku Ikonio mambu ghakabhi ngati moghakabheli ku Antiokia, Paulo na Banaba bhakapiti mu nyumba ja kuhimanganila Bhayahude ngati mowabheli ntetu wabhu. Monihomu bhakalongi kwa uwezu ukolongwa mbaka lipogha likolongwa la Bhayahude na Bhagiliki bhakahobhalile. ");
INSERT INTO mpa_vpl VALUES ("AC14_2","074_14_2","ACT","14","2","2","Nambu Bhayahude bhabhakaniki kubha bhahobhalela bhakabhachokaki na kujeghe maholalelu mahakau mu mitima ja bhandu bhangakubha Bhayahude nahuli bhabhakana bhalongu bhanihabha. ");
INSERT INTO mpa_vpl VALUES ("AC14_3","074_14_3","ACT","14","3","3","Bhela Paulo na Banaba bhakajendali kutama konihoku kwa chikahi chilacho. Bhakalandili kwa makakala makolongwa panani jaka Bambo, na Chapanga akaulangihi kubha ubholu waki wa chihomu chaki nde wa chakaka kwa kubhapekeha makili gha kutenda nginyulila na ngangachu. ");
INSERT INTO mpa_vpl VALUES ("AC14_4","074_14_4","ACT","14","4","4","Bhandu bha muchi ghonihoghu bhakalekangine. Bhangi bhakabhi papamu na Bhayahude, na bhangi bhakabhi upambala wa mitumi. ");
INSERT INTO mpa_vpl VALUES ("AC14_5","074_14_5","ACT","14","5","5","Bhayahude na bhandu bhangakubha Bhayahude, bhakajangatini na ihongozi bhabhu, bhakapangiki kubhahenge mahakau mitumi na kubhalapu maganga. ");
INSERT INTO mpa_vpl VALUES ("AC14_6","074_14_6","ACT","14","6","6","Mitumi pabhamanyi lijambu leniheli, bhakakembali ku michi ja Listila na Delibe, jejibhi mu inchi ja Likaonia na pa inchi yeilindakani na muchi ghonihoghu. ");
INSERT INTO mpa_vpl VALUES ("AC14_7","074_14_7","ACT","14","7","7","Konihoku bhakabhi bhatangaza Malobhi Manyahi. ");
INSERT INTO mpa_vpl VALUES ("AC14_8","074_14_8","ACT","14","8","8","Ku muchi wa ku Listila kukabhi na mundu jumu joakatengwiki magholu kutumbu kubhelakeka kwaki na ngacheakawahiki kujenda. ");
INSERT INTO mpa_vpl VALUES ("AC14_9","074_14_9","ACT","14","9","9","Mundu jonihoju akabhi anjowanela Paulo paakabhi atangaza. Paulo akundingalakili na paakumbweni kubha abhi na uhobhalelu wa kulamiswa, ");
INSERT INTO mpa_vpl VALUES ("AC14_10","074_14_10","ACT","14","10","10","akajamalili akapwaghaje, “Ujemaje kwa magholu ghaku!” Palapala mundu jola akahombiki manyata na kutumbu kujenda. ");
INSERT INTO mpa_vpl VALUES ("AC14_11","074_14_11","ACT","14","11","11","Lipogha la bhandu pabhaweni cheakahengiki Paulo, bhakatumbwi kujamalila kwa lugha ja Kilikaonia bhakapwaghaje, “Ichapanga ituhikili kwa ubhonikanu ngati bhandu!” ");
INSERT INTO mpa_vpl VALUES ("AC14_12","074_14_12","ACT","14","12","12","Banaba bhakundohiki Zeu, na kwa kubha Paulo nde ndongela nkolongwa, bhakundohiki Helime. ");
INSERT INTO mpa_vpl VALUES ("AC14_13","074_14_13","ACT","14","13","13","Mpenganyambiku wa nyumba jaka kichapanga Zeu jejakabhi kunja ja muchi akaletiki mapongu gha ng'ombi na malobha palongi ja ndyangu wa muchi, jombi papamu na bhandu bhangi bhala akapaliki kubhatambikila mitumi bhala. ");
INSERT INTO mpa_vpl VALUES ("AC14_14","074_14_14","ACT","14","14","14","Nambu Banaba na Paulo pabhajowini mambu ghanihagha bhakaikachwi ingobhu yabhu na kukembalela mu lipogha la bhandu bhakajamalyaje, na kupwagha, ");
INSERT INTO mpa_vpl VALUES ("AC14_15","074_14_15","ACT","14","15","15","“Bhalongo, bho, maghambu kiki muhenga mambu ghanihagha? Tepani twa bhandu pela ngati mabhanganya! Tubhi pambani kwa ndandi ja kuntangazila Malobhi Manyahi, nahuli muilekaje imong'umong'u hinu yanga na chindu, na munkelabhukya Chapanga joabhi mwome, joabhombiki kunani kumahunde na ndema, bahali na yokapi yeibhi mkati ja hindu yeniheyi. ");
INSERT INTO mpa_vpl VALUES ("AC14_16","074_14_16","ACT","14","16","16","Pamwandi Chapanga akabhalekiki bhandu bhokapi bhahenga ngati mobhapalilaje. ");
INSERT INTO mpa_vpl VALUES ("AC14_17","074_14_17","ACT","14","17","17","Nambu Chapanga ngacheakotwiki kulilangiha kwa mambu manyahi ghaabhahengela. Kuntonyela iyula kuhuma kunani, ampeke mahunu kwa chikahi chaki, ampeke chilebhi na kujitwelakela mitima jinu kwa chiheku.” ");
INSERT INTO mpa_vpl VALUES ("AC14_18","074_14_18","ACT","14","18","18","Papamu na kulonge bhenibhela ngachekwabhi kupepuka kubhahibhali bhandu, nahuli ngabhabhokela nyambiku. ");
INSERT INTO mpa_vpl VALUES ("AC14_19","074_14_19","ACT","14","19","19","Bhayahude bhakumu bhakahikili kuhuma ku muchi wa ku Antiokia na ku Ikonio, bhakabhaswembiki bhandu bhalilomba nabhu, bhakundapwi maganga Paulo na kunhutana mbaka kunja ja muchi bhakaholakya kubha apotile. ");
INSERT INTO mpa_vpl VALUES ("AC14_20","074_14_20","ACT","14","20","20","Nambu bhabhulwa pabhakalibhongini na kumuyongolota Paulo, akajumwiki na kukelabhuka kumbwane. Chilabhu jaki jombi na Banaba bhakapiti ku Delibe. ");
INSERT INTO mpa_vpl VALUES ("AC14_21","074_14_21","ACT","14","21","21","Paulo na Banaba bhakatangizi Malobhi Manyahi ku Delibe na kubhapata bhabhulwa bhamahele. Kubhoka panihapa bhakakelawiki ku Listila, bhakapiti mbaka ku Ikonio na kuhika ku Antiokia. ");
INSERT INTO mpa_vpl VALUES ("AC14_22","074_14_22","ACT","14","22","22","Konihoku bhakabhachengiki bhahobhalela bha michi jeniheji na kubhajeghe mtima bhahighalya mu uhobhalelu wa chakaka. Bhakabhapwaghile, “Itupalika tabhokapi kupetela mang'ahiku ghamahele nahuli tujingala mu Ukolongwa waka Chapanga.” ");
INSERT INTO mpa_vpl VALUES ("AC14_23","074_14_23","ACT","14","23","23","Mu kila likanisa bhakabhahawi ihongozi kwa ndandi ja bhahobhalela, na kwa kulobha na kukonga bhakabhabhehi palongi jaka Bambo jobhunhobhalile. ");
INSERT INTO mpa_vpl VALUES ("AC14_24","074_14_24","ACT","14","24","24","Pabhapetiki inchi ja ku Pisidia, bhakahiki ku Pamfilia. ");
INSERT INTO mpa_vpl VALUES ("AC14_25","074_14_25","ACT","14","25","25","Pabhakajomwi kutangaza Lilobhi laka Chapanga kwa bhandu bha ku muchi wa ku Pega, bhakapiti ku muchi wa ku Atalia. ");
INSERT INTO mpa_vpl VALUES ("AC14_26","074_14_26","ACT","14","26","26","Kubhoka konihoku bhakakelawiki kwa sitima mbaka ku Antiokia, konihoku punyuma bhakabhekakiki pahi ja ulingalilu wa chihomu chaka Chapanga kwa ndandi ja lihengu ambalu sajenu bhalijomwile. ");
INSERT INTO mpa_vpl VALUES ("AC14_27","074_14_27","ACT","14","27","27","Pabhahiki ku Antiokia, bhakahengiki uhimanganu na likanisa la panihapa, bhakabhapeki ubholu panani ja mambu ghaabhahengi Chapanga, na ntundu mobhahoghulili bhandu bhangakubha Bhayahude ndyangu wa kujingila mu uhobhalelu. ");
INSERT INTO mpa_vpl VALUES ("AC14_28","074_14_28","ACT","14","28","28","Bhakatami ku Antiokia kwa machobha ghamahele papamu na bhabhulwa. ");
INSERT INTO mpa_vpl VALUES ("AC15_1","074_15_1","ACT","15","1","1","Bhandu bhakumu bhakaheli kuhuma ku Yudea kujenda ku Antiokia na kutumbu kubhabhola bhahobhalela, “Ngamuwezi kukengaleka mbaka muhekata jando ngati ntetu wa Shelia jaka Musa mojipalila.” ");
INSERT INTO mpa_vpl VALUES ("AC15_2","074_15_2","ACT","15","2","2","Paulo na Banaba bhakabhapengiki na kulochana nabhu nakanopi panani ja lijambu lenihele, Paulo na Banaba na bhahobhalela bhakumu bha ku Antiokia bhakapalakiki kujenda ku Yelusalemu kubhalola mitumi na ihongozi panani ja lijambu lenihele. ");
INSERT INTO mpa_vpl VALUES ("AC15_3","074_15_3","ACT","15","3","3","Bhela bhakatumakiki na likanisa, na pabhapetiki mu inchi ja Foinike na Samalia, bhakabhapwaghi bhandu ntundu bhandu bhangakubha Bhayahude mobhakelabhuki kwaka Chapanga, mambu ghanihagha ghakapelaki chiheku namaa kwa bhahobhalela bhokapi. ");
INSERT INTO mpa_vpl VALUES ("AC15_4","074_15_4","ACT","15","4","4","Pabhahikiki ku Yelusalemu, bhakajopaliwi na likanisa, na mitumi na bhazee, nabhombi bhakabhapwaghi mambu ghokapi Chapanga ghaakahengiki kupete bhombe. ");
INSERT INTO mpa_vpl VALUES ("AC15_5","074_15_5","ACT","15","5","5","Nambu bhahobhalela bhakumu bhabhakabhi bha lipogha la Mafalisayo bhakajemiki na kupwagha, “Ibhapalika bhandu bhangakubha Bhayahude kuheketa jando na kubhalaghalaki kujengalela Shelia yaka Musa.” ");
INSERT INTO mpa_vpl VALUES ("AC15_6","074_15_6","ACT","15","6","6","Mitumi na bhazee bhakahimangini papamu nahuli kuholalela panani ja lijambu lenihele. ");
INSERT INTO mpa_vpl VALUES ("AC15_7","074_15_7","ACT","15","7","7","Pabhalongalani kwa chikahi chilachu, Petulu akajemiki na kupwagha, “Bhalongu bhango, mmanyi kubha pamwandi Chapanga akanhawi nepani pachilanda jinu nahuli ndangaza Malobhi Manyahi kwa bhandu bhangakubha Bhayahude, nahuli bhapata kujowana na kuhobhalela. ");
INSERT INTO mpa_vpl VALUES ("AC15_8","074_15_8","ACT","15","8","8","Chapanga joamanyi mitima ja bhandu, akalangi kubha abhajetakili bhandu bhangakubha Bhayahude kwa kubhapeke Roho Mhuhu ngati moakatupeki tepani. ");
INSERT INTO mpa_vpl VALUES ("AC15_9","074_15_9","ACT","15","9","9","Chapanga ngacheahengiki tofauti jokapi jela pachilanda jitu na bhombe, akajigholwi mitima jabhu kwa kuhobhalela. ");
INSERT INTO mpa_vpl VALUES ("AC15_10","074_15_10","ACT","15","10","10","Bho, henu maghambu kiki mpala kundenga Chapanga kwa kubhatweka bhahobhalela chibwahila ambachu akahokolu bhitu wala tabheti ngachetwaweziki kuchinyamula? ");
INSERT INTO mpa_vpl VALUES ("AC15_11","074_15_11","ACT","15","11","11","Ngabhela! Tepani na bhombi tuhobhalela na kukengalewa kwa indela ja chihomu chaka Bambo Yesu Kristo.” ");
INSERT INTO mpa_vpl VALUES ("AC15_12","074_15_12","ACT","15","12","12","Lipogha lokapi la bhandu lakatami chinunu lakajowanya malobhi ghaka Banaba na Paulo bhakalanda panani ja ngangachu yeikabhi ahenga Chapanga kwa kupete bhombi kwa bhandu bhangakubha Bhayahude. ");
INSERT INTO mpa_vpl VALUES ("AC15_13","074_15_13","ACT","15","13","13","Pabhajomwi kulongela, Yakobo akatumbwi kupwagha, “Bhalongu bhango, nyowanyaje! ");
INSERT INTO mpa_vpl VALUES ("AC15_14","074_15_14","ACT","15","14","14","Simoni ajomwi kulongela ntundu Chapanga pamwandi moakabhahengi bhandu bhangakubha Bhayahude kwa kubhahaghula bhakumu nahuli bhabya bhandu bhaki. ");
INSERT INTO mpa_vpl VALUES ("AC15_15","074_15_15","ACT","15","15","15","Lijambu leniheli lilengana na malobhi gha bhalota bhaka Chapanga, ngati moilembakike mu Malembu Mahuhu: ");
INSERT INTO mpa_vpl VALUES ("AC15_16","074_15_16","ACT","15","16","16","‘Bambo apwagha, paghipeta mambu ghangani ananhikaje, ananuchenga kabheti ukolongwa waka Daude. Ananjenga kabheti mahami ghaki na kughalenganake wichu. ");
INSERT INTO mpa_vpl VALUES ("AC15_17","074_15_17","ACT","15","17","17","Nahuli bhandu bhangi bhokapi bhakelabhuka kwango, bhandu bhokapi bhangakubha Bhayahude bhanabhahawili bhabya bhangu. ");
INSERT INTO mpa_vpl VALUES ("AC15_18","074_15_18","ACT","15","18","18","Nde moapwaghi Bambo, joahengiki lijambu lenu limanyikana kutumbu mwande.’ ” ");
INSERT INTO mpa_vpl VALUES ("AC15_19","074_15_19","ACT","15","19","19","Yakobo akajendali kupwagha, “Henu kwa momonela, ngatwabhang'aha bhandu bhangakubha Bhayahude bhabhakelabhuka kwaka Chapanga. ");
INSERT INTO mpa_vpl VALUES ("AC15_20","074_15_20","ACT","15","20","20","Nambu, itupalika tubhalembila baluwa ja kubhapwaghila ngabhikula hilebhi yeijeghaliki uhakau kwa kutambikila imong'umong'u, bhuleka ukemi, ngabhikula chinyama chekinyongakiki, na ngabhikula mwahi. ");
INSERT INTO mpa_vpl VALUES ("AC15_21","074_15_21","ACT","15","21","21","Kwa ndandi kutumbu pamwandi Shelia jaka Musa jisomakeka mu kila Lichobha la Sabato munyumba ya kuhimangani Bhayahude, na malobhi ghaki ghatangazwa ku kila muchi.” ");
INSERT INTO mpa_vpl VALUES ("AC15_22","074_15_22","ACT","15","22","22","Kabheti mitumi na bhazee, papamu na bhandu bhokapi bha likanisa, bhakaholali kubhahaghu bhandu bhakumu kuhuma kwabhu na kubhatuma ku Antiokia papamu na Paulo na Banaba. Bhela bhakabhahawi bhandu bhabheli Yuda joalowakika Basaba na Sila, bhanganya habha bhakamanyakini namaa kwa bhahobhalela. ");
INSERT INTO mpa_vpl VALUES ("AC15_23","074_15_23","ACT","15","23","23","Bhakatumakiki na baluwa jejilembakiki ana: “Tepani, twabhalongu bhinu na mitumi na bhazee, tundamukila mwabhalongu bhitu mwangakubha Mwayahude mombi ku Antiokia, ku Silia na ku Kilikia. ");
INSERT INTO mpa_vpl VALUES ("AC15_24","074_15_24","ACT","15","24","24","Tujowini kubha bhandu bhangi kuhuma kwitu panga na kubhalaghalaki tepani bhung'ahiki kwa malobhi ghabhu, na kujibheka mitima jinu mu choghohi. ");
INSERT INTO mpa_vpl VALUES ("AC15_25","074_15_25","ACT","15","25","25","Henu, kubhokana na bhenibhela kwa papamu tujetanganili kubhahaghula bhandu bhakumu na kubhatuma kwinu. Anabhahika na bhalongu bhitu Banaba na Paulo, ");
INSERT INTO mpa_vpl VALUES ("AC15_26","074_15_26","ACT","15","26","26","bhabhalibhohiki bheni kwa kuntumakila Bambo witu Yesu Kristo. ");
INSERT INTO mpa_vpl VALUES ("AC15_27","074_15_27","ACT","15","27","27","Bhela tubhatuma Yuda na Sila kwinu, bhombi anabhumpwaghila bheni mambu ghokapi ghatundembela. ");
INSERT INTO mpa_vpl VALUES ("AC15_28","074_15_28","ACT","15","28","28","Ipalakiki na Roho Mhuhu na tepani tujetakali ngatuntweka chibwahila chengi nambu mambu ghanga ghaghapalika nakanopi, ");
INSERT INTO mpa_vpl VALUES ("AC15_29","074_15_29","ACT","15","29","29","ngamwikula hilebhi yebhatambakile imong'umong'u, ngamwikula wala kunywa mwahi, ngamwikula inyama ja chinyama chechinyongakike, na ngamwikubha bhakemi. Mwibya ntehi wichu ngati anankotwiki kuhenga mambu ghanihagha. Tundamukila!” ");
INSERT INTO mpa_vpl VALUES ("AC15_30","074_15_30","ACT","15","30","30","Pabhatawiki, bhabholu bhakapiti ku Antiokia, konihoku bhakalohiki uhimanganu wa bhahobhalela na kubhapeke baluwa. ");
INSERT INTO mpa_vpl VALUES ("AC15_31","074_15_31","ACT","15","31","31","Pabhasomiki baluwa jela, bhakabhi na chiheku kubhokana na ubholu wa kubhajeghe mtima. ");
INSERT INTO mpa_vpl VALUES ("AC15_32","074_15_32","ACT","15","32","32","Yuda na Sila bhabhakabhi bhalota bhaka Chapanga, bhakalongi nabhu malobhi ghamaheli na kubhajeghe mtima na kubhachenga. ");
INSERT INTO mpa_vpl VALUES ("AC15_33","074_15_33","ACT","15","33","33","Pabhatami ku Antiokia kwa chikahi, bhalongu bhahobhalela bhala bhakabhatawiki na kubhalobhela bhajenda kwa lukwale nabhombi bhakakelawiki kwa bhajabhu bhabhakabhatumike. ");
INSERT INTO mpa_vpl VALUES ("AC15_34","074_15_34","ACT","15","34","34","Nambu Sila akaweni wichu kuhighali konihoku. ");
INSERT INTO mpa_vpl VALUES ("AC15_35","074_15_35","ACT","15","35","35","Paulo na Banaba bhakahighali ku Antiokia kwa chikahi, bhakabholiki na kutangaza Lilobhi laka Bambo. ");
INSERT INTO mpa_vpl VALUES ("AC15_36","074_15_36","ACT","15","36","36","Paghapetiki machobha machokope Paulo akumpwaghi Banaba, “Tukelabhuka tukabhalinga bhalongu bhabhahobhalili ku kila muchi kotapetiki kutangaza Lilobhi laka Bambo, na kubhona ntundu mobhajendalela.” ");
INSERT INTO mpa_vpl VALUES ("AC15_37","074_15_37","ACT","15","37","37","Banaba akapaliki bhuntola Yohana joalowakika Mako bhajenda papamu naku. ");
INSERT INTO mpa_vpl VALUES ("AC15_38","074_15_38","ACT","15","38","38","Nambu Paulo ngacheakaweni kubha nde wichu kujenda na Mako, magahmbu akakaniki kuhenga lihengu labhu na akabhalehi ku inchi ja ku Pamfilia. ");
INSERT INTO mpa_vpl VALUES ("AC15_39","074_15_39","ACT","15","39","39","Kukapitali upenganu ukolongwa pachilanda jabhu na bhakalekine, Banaba akuntoliki Mako na bhakakweliki sitima kujenda ku Kipulo. ");
INSERT INTO mpa_vpl VALUES ("AC15_40","074_15_40","ACT","15","40","40","Nambu Paulo akunhawi Sila, na bhalongu bhahobhalela bha panihapa pabhakabhalobhili chihomu chaka Chapanga, bhakabhokike. ");
INSERT INTO mpa_vpl VALUES ("AC15_41","074_15_41","ACT","15","41","41","Akapetiki ku inchi ja ku Silia na ku Kilikia, akaghapekya makili makanisa gha konihoku. ");
INSERT INTO mpa_vpl VALUES ("AC16_1","074_16_1","ACT","16","1","1","Paulo akahikiki ku Delibe na ku Listila, koatamika mbulwa jumu joalowakika Timoseo. Amabhu waki najombi akabhi mbulwa, akabhi Myahude, nambu atati waki akabhi Mgiliki. ");
INSERT INTO mpa_vpl VALUES ("AC16_2","074_16_2","ACT","16","2","2","Bhahobhalela bhokapi bha ku Listila na ku Ikonio bhakalongi ulandilu wambone panani jaka Timoseo. ");
INSERT INTO mpa_vpl VALUES ("AC16_3","074_16_3","ACT","16","3","3","Paulo akapaliki antola Timoseo mu mwanja waki, bhela akunhekiti jando. Akatehi bhenibhela kwa ndandi ja Bhayahude bhabhakabhi bhatama pandu panipala, maghambu bhokapi bhakamanyi kubha atati waka Timoseo akabhi Mgiliki. ");
INSERT INTO mpa_vpl VALUES ("AC16_4","074_16_4","ACT","16","4","4","Mu michi jokapi jebhapetiki, bhakalongili kwa bhabhulwa malaghalakilu ghaghabhohakiki na mitumi na bhazee bha ku Yelusalemu, na kubhapwaghi bhaghakamula malaghalaki ghokape. ");
INSERT INTO mpa_vpl VALUES ("AC16_5","074_16_5","ACT","16","5","5","Bhela makanisa ghakajonjukiki makili mu uhobhalelu na ubhalangiku wa bhabhulwa ukajonjukiki mu kila lichobha. ");
INSERT INTO mpa_vpl VALUES ("AC16_6","074_16_6","ACT","16","6","6","Paulo papamu na bhajaki bhakapetiki ku inchi ja ku Filigia na ku Galatia, maghambu Roho Mhuhu ngachebhapwaghi kutangaza Lilobhi laka Chapanga ku inchi ja ku Asia. ");
INSERT INTO mpa_vpl VALUES ("AC16_7","074_16_7","ACT","16","7","7","Pabhahiki mu malindakanilu gha Misia, bhakalengiki kujenda ku inchi ja Bisinia, nambu Roho waka Yesu ngacheabhajetakile. ");
INSERT INTO mpa_vpl VALUES ("AC16_8","074_16_8","ACT","16","8","8","Bhela bhakapetiki ku mkoa wa ku Misia na kujenda ku Tiloa. ");
INSERT INTO mpa_vpl VALUES ("AC16_9","074_16_9","ACT","16","9","9","Pakwahiki ikilu Paulo akaweni mabhono gha kubha akumbweni mundu jumu wa ku Makedonia ajemi na anjopa, “Ulombukaje, uhika ku Makedonia utujangatyaje!” ");
INSERT INTO mpa_vpl VALUES ("AC16_10","074_16_10","ACT","16","10","10","Palapala Paulo paakaweni mabhono ghanihagha, tukalibhehi wichu kujenda ku Makedonia, maghambu tukamanyi kubha Chapanga akatulohiki kujenda kutangaza Malobhi Manyahi kwa bhandu bha konikola. ");
INSERT INTO mpa_vpl VALUES ("AC16_11","074_16_11","ACT","16","11","11","Kuhuma ku Tiloa tukalombwiki kwa sitima mbaka ku Samosilake, na lichobha lelijengalyaje tukalombwiki ku Neapoli. ");
INSERT INTO mpa_vpl VALUES ("AC16_12","074_16_12","ACT","16","12","12","Kuhuma konihoku tukapiti ku Filipi, muchi ukolongwa wa ku Makedonia, ghoukabhi pahi ja utawala wa Bhaloma. Tukatami konihoku kwa machobha machokope. ");
INSERT INTO mpa_vpl VALUES ("AC16_13","074_16_13","ACT","16","13","13","Lichobha la Sabato tukapitiki kunja ja muchi na kujenda pambipi na nkoka, patwaholali kubha pandu patuweza kuhimangana kwa kundobha Chapanga. Tukatami, na kulongela na akambomba bhabhalibhongini pandu panipala. ");
INSERT INTO mpa_vpl VALUES ("AC16_14","074_16_14","ACT","16","14","14","Jumu wa akambomba bhabhabhi bhatujowanela akabhi Lidia kuhuma ku Tiatila, joakabhi ndombesa wa ingobhu ya langi ja zambalau ya mbija yamaheli. Akabhi mbomba joanjojabhe Chapanga, na Bambo akaubhopwi mtima waki kughajopalela malobhi ghokapi ghalongila Paulo. ");
INSERT INTO mpa_vpl VALUES ("AC16_15","074_16_15","ACT","16","15","15","Paabatizwi jombi na bhandu bha munyumba jaki, akatupembalili akapwaghaje, “Ngati anambona kubha chakaka nunhobhali Bambo, tambokanya mwakatama kunyumba jangu.” Tukajetakili kujenda kunyumba jaki. ");
INSERT INTO mpa_vpl VALUES ("AC16_16","074_16_16","ACT","16","16","16","Lichobha limu patupita pandu pa kundobha Chapanga, tukahimangini na mtumika jumu wa chimbomba joakabhi na majobhi na uwezu wa kulondola. Kwa indela jaki ja kulondola akabhapeki akabambo bhaki mbija yamahele. ");
INSERT INTO mpa_vpl VALUES ("AC16_17","074_16_17","ACT","16","17","17","Mtumika hoju akunjengali Paulo na tepani, akajamalyaje, “Bhandu habha nde bhatumika bhaka Chapanga Nkolongwa wa Kunani Nakanope! Bhuntangazi indela ja kuweza kukengaleka!” ");
INSERT INTO mpa_vpl VALUES ("AC16_18","074_16_18","ACT","16","18","18","Akahengiki bhenibhela kwa machobha ghamahele, mbaka lichobha limu Paulo akahakalili namaa na kumpwaghi lijobhi jola, “Nukukenjukila kwa lihina laka Yesu Kristo umpita mwali hoju!” Palapala lijobhi akumpitiki mwali jola. ");
INSERT INTO mpa_vpl VALUES ("AC16_19","074_16_19","ACT","16","19","19","Akabambo bhaka mwali jola bhakaweni kubha uhobhalelu wabhu wa kupata mbija ujomwike, bhakabhakamwi Paulo na Sila na kubhahutana mbaka paligulio palongi ja ihongozi. ");
INSERT INTO mpa_vpl VALUES ("AC16_20","074_16_20","ACT","16","20","20","Bhakabhapeliki kwa ihongozi bha ku Loma na kupwagha, “Bhandu abhabha nde Bhayahude, na bhaleta fujo pa muchi witu. ");
INSERT INTO mpa_vpl VALUES ("AC16_21","074_16_21","ACT","16","21","21","Bhabhola mitetu jejipengana na malaghalakilu ghitu, tepani twa Bhaloma, na ngachetupalika kujijetakela na kujijengalela.” ");
INSERT INTO mpa_vpl VALUES ("AC16_22","074_16_22","ACT","16","22","22","Lipogha la bhandu lakalibhongini na kubhalapu Paulo na Sila. Bhela bhatemula bhala bhakabhahuliki ingobhu yaka Paulo na Sila kwa makili, na kulaghalaki bhalapulika iboko. ");
INSERT INTO mpa_vpl VALUES ("AC16_23","074_16_23","ACT","16","23","23","Pabhajomwi kubhalapula nakanopi, bhakabhabhehi muligeleza, na bhakundaghalakili nkolongwa wa bhalonda bha ligeleza kubhabheka pahi ja ulingalilu ukale. ");
INSERT INTO mpa_vpl VALUES ("AC16_24","074_16_24","ACT","16","24","24","Kubhokana na amuli jeniheji, mlonda akabhabhehi muchumba cha mkati nakanopi na kughakonga magholu ghabhu pa ligogo. ");
INSERT INTO mpa_vpl VALUES ("AC16_25","074_16_25","ACT","16","25","25","Pamahiku Paulo na Sila bhakabhi bhalobha na kundumbali Chapanga, na bhakongeka bhangi bhakabhi bhajowanela. ");
INSERT INTO mpa_vpl VALUES ("AC16_26","074_16_26","ACT","16","26","26","Palapala kukapitali kinyukunyuku cha ndema, chikanyuhiki misingi ja ligeleza panihapa milyangu ja ligeleza jakahowiki na pengu ikabhopwiki. ");
INSERT INTO mpa_vpl VALUES ("AC16_27","074_16_27","ACT","16","27","27","Mlonda wa ligeleza paakajumwiki na kubhona milyangu ja ligeleza jihoghuliki, akaholali kubha bhakongeka bhokapi bhatilike, na panihapa akaliholapwi lipanga laki na kupala kulikoma. ");
INSERT INTO mpa_vpl VALUES ("AC16_28","074_16_28","ACT","16","28","28","Nambu Paulo akajamalili akapwaghaje, “Ngawalipoteka wamwete! Tepani tabhokapi tubhi pambane!” ");
INSERT INTO mpa_vpl VALUES ("AC16_29","074_16_29","ACT","16","29","29","Mlonda jola akajopiki bhundetila taa, akakembali mkati, na kulileke pamagholu ghaka Paulo na Sila. ");
INSERT INTO mpa_vpl VALUES ("AC16_30","074_16_30","ACT","16","30","30","Bhela akabhalongwi kunja na kubhalalukila, “Bhakolongwa bhango, bho, nhenga kiki nahuli mbata kukengaleka?” ");
INSERT INTO mpa_vpl VALUES ("AC16_31","074_16_31","ACT","16","31","31","Bhombi bhakamuyangike, “Unhobhalya Bambo Yesu, wikengalika wehapa papamu na bhandu bha munyumba jaku.” ");
INSERT INTO mpa_vpl VALUES ("AC16_32","074_16_32","ACT","16","32","32","Bhela bhakuntangazi Lilobhi laka Bambo jombi papamu na bhandu bhabhakabhi munyumba jake. ");
INSERT INTO mpa_vpl VALUES ("AC16_33","074_16_33","ACT","16","33","33","Chikahi chelachela cha ikilu mlonda wa ligeleza akabhatoliki na kubhagholola hilonda yabhu, na panihapa jombi na bhalongu bhaki bhakabatizwi palapala. ");
INSERT INTO mpa_vpl VALUES ("AC16_34","074_16_34","ACT","16","34","34","Bhela akabhatoliki Paulo na Sila mbaka kunyumba jaki na kubhapeke chilebhe. Jombi na bhalongu bhaki bhakatweliwi na chiheku, maghambu bhakunhobhali Chapanga. ");
INSERT INTO mpa_vpl VALUES ("AC16_35","074_16_35","ACT","16","35","35","Chilabhu jaki lukela bhatemula bha ku Loma bhakabhatumiki manjolinjoli kwaka mlonda wa muligeleza na kumpwaghila, “Wabhopula bhandu bhala.” ");
INSERT INTO mpa_vpl VALUES ("AC16_36","074_16_36","ACT","16","36","36","Bhela mlonda wa ligeleza jola akumpwaghi Paulo, “Bhakolongwa bhalaghalaki nukubhopulya wehapa na Sila. Sajenu muweza kubhoka na kujenda kwa lukwale.” ");
INSERT INTO mpa_vpl VALUES ("AC16_37","074_16_37","ACT","16","37","37","Nambu Paulo akabhapwaghi manjolinjoli bhala, “Bhatulapwi iboko palongi ja bhandu bhokapi panga na uhakau wokapi ghola koni tepani nde bhandu bha ku Loma. Na kutukonga muligeleza. Bho, sajenu bhapala kutulekakela kwa kulihiya? Ngaiwezikane! Bhatemula bha ku Loma bhapalika bhahika bheni bhatubhopulyaje.” ");
INSERT INTO mpa_vpl VALUES ("AC16_38","074_16_38","ACT","16","38","38","Manjolinjoli bhakakelawiki na kubhapwaghi bhatemula bha ku Loma malobhi ghala, na pabhakajowini kubha Paulo na Sila nde bhandu bha ku Loma, bhakajowipi namaa. ");
INSERT INTO mpa_vpl VALUES ("AC16_39","074_16_39","ACT","16","39","39","Bhela bhakapiti na kubhapembalela, bhakabhapihiki kunja ja ligeleza, na kubhapwaghi bhabhokaje pa muchi ghonighola. ");
INSERT INTO mpa_vpl VALUES ("AC16_40","074_16_40","ACT","16","40","40","Paulo na Sila pabhakapitiki muligeleza bhakapiti kunyumba jaka Lidia. Konihoku bhakahimangini na bhahobhalela, bhakabhapeki malobhi gha kubhajeghe mtima, na bhakabhokike. ");
INSERT INTO mpa_vpl VALUES ("AC17_1","074_17_1","ACT","17","1","1","Paulo na Sila bhakajendali na mwanja na kupeta mu muchi wa Amfipoli na Apolonia na kuhika mbaka ku Sesalonike, na konihoku kukabhi na nyumba ja kuhimangani Bhayahude. ");
INSERT INTO mpa_vpl VALUES ("AC17_2","074_17_2","ACT","17","2","2","Paulo, ngati mowabheli ntetu waki, akapiti munyumba ja kuhimangani Bhayahude. Kwa Machobha ghatatu gha Sabato kwa kujengalane juma itatu, akalongalani na bhandu bhabhabhila monimola kwa Malembu Mahuhu, ");
INSERT INTO mpa_vpl VALUES ("AC17_3","074_17_3","ACT","17","3","3","akalongila na kulangi kubha Kristo ikampaliki kung'ahakika na kuhyoka. Akabhapwaghile, “Yesu hajoju ambaju nepani nuntangaza kwinu, nde Kristo.” ");
INSERT INTO mpa_vpl VALUES ("AC17_4","074_17_4","ACT","17","4","4","Bhayahude bhakumu bhakahobhalili na kulilomba papamu na Paulo na Sila, kabheti Bhagiliki bhamaheli bhabhunjojabya Chapanga papamu na akambomba bhabhabhili na yehu ikolongwa bhakahobhalile. ");
INSERT INTO mpa_vpl VALUES ("AC17_5","074_17_5","ACT","17","5","5","Nambu Bhayahude bhakaweni wihu na bhakabhabhongini bhandu bha liyaha kuhuma pandu pa kuhimangani bhandu na kulenganakela lipogha. Bhakahengiki uhakau ukolongwa mu muchi wokapi na kujenda kujivamila nyumba jaka Yasoni, bhakaholalya kubhapata Paulo na Sila nahuli bhabhapiya pa bhandu. ");
INSERT INTO mpa_vpl VALUES ("AC17_6","074_17_6","ACT","17","6","6","Nambu maghambu ngachebhaweni, bhakunkamwi Yasoni papamu na bhalongu bhahobhalela mbaka palongi ja bhakolongwa bha muchi na kujamalila, “Bhandu abhabha bhahengiki fujo pundema wokapi! Na sajenu bhahikiki pa muchi pani, ");
INSERT INTO mpa_vpl VALUES ("AC17_7","074_17_7","ACT","17","7","7","najombi Yasoni akabhakemiki kunyumba jaki. Bhanganya abhabha bhokapi bhapenga amuli yaka nkolongwa Kaisali, bhakapwaghaje kubha abhi kabheti nkolongwa jongi, joalowakeka Yesu.” ");
INSERT INTO mpa_vpl VALUES ("AC17_8","074_17_8","ACT","17","8","8","Kwa malobhi ghanihagha bhakabhajeghi choghohi bhakolongwa bha muchi papamu na lipogha la bhandu. ");
INSERT INTO mpa_vpl VALUES ("AC17_9","074_17_9","ACT","17","9","9","Bhakolongwa bha muchi bhakabhalaghalaki Yasoni na bhajaki kulepa mbija, na panihapa bhakabhalehi bhajendaje. ");
INSERT INTO mpa_vpl VALUES ("AC17_10","074_17_10","ACT","17","10","10","Ikilu jelajela bhalongu bhahobhalela bhala bhakabhapwaghi Paulo na Sila bhajenda ku Beloya. Pabhahikiki pela konikola, bhakajingi munyumba ja kuhimangani Bhayahude. ");
INSERT INTO mpa_vpl VALUES ("AC17_11","074_17_11","ACT","17","11","11","Bhandu bha ku Beloya bhakabhi bhajowanela nakanopi kubhapeta bhandu bha ku Sesalonike, nabhombi bhakajopali Lilobhi laka Chapanga kwa utokulelu ukolongwa. Kila lichobha bhalingalakya wichu Malembu Mahuhu nahuli bhapata kumanya kubha malobhi ghaalongila Paulo na Sila ghakabhi gha chakaka. ");
INSERT INTO mpa_vpl VALUES ("AC17_12","074_17_12","ACT","17","12","12","Bhayahude bhamaheli bhakahobhalile papamu na akambomba bhabhabhili na yehu bha Kigiliki, na akanalomi nabhombi bhakahobhalile. ");
INSERT INTO mpa_vpl VALUES ("AC17_13","074_17_13","ACT","17","13","13","Nambu Bhayahude bha ku Sesalonike pabhajowini kubha Paulo atangaza kabheti Lilobhi laka Chapanga ku Beloya, bhakapiti konikola na kutumbu fujo na kubhachochake bhandu. ");
INSERT INTO mpa_vpl VALUES ("AC17_14","074_17_14","ACT","17","14","14","Palapala bhahobhalela bhala bhakunhindaki Paulo ajenda kumaheku, nambu Sila na Timoseo bhakahighali ku Beloya. ");
INSERT INTO mpa_vpl VALUES ("AC17_15","074_17_15","ACT","17","15","15","Bhalongu bhabhunhindakya Paulo bhakapiti mbaka ku Asene, na konihoku bhakakelawiki ku Beloya bhakabya bhalaghalakiwi kuhuma kwaka Paulo kubhapwaghi Sila na Timoseo bhunjengalya manyata. ");
INSERT INTO mpa_vpl VALUES ("AC17_16","074_17_16","ACT","17","16","16","Paulo paakabhi andendale Sila na Timoseo ku Asene, mtima waki ukahakali namaa kwa kubhona muchi utwelili imong'umong'u. ");
INSERT INTO mpa_vpl VALUES ("AC17_17","074_17_17","ACT","17","17","17","Akalochini na Bhayahude na bhandu bhangakubha Bhayahude mu nyumba ja kuhimangani Bhayahude bhabhunjojabya Chapanga, na machobha ghangi alochana na bhandu bhabhahimanya paligulio. ");
INSERT INTO mpa_vpl VALUES ("AC17_18","074_17_18","ACT","17","18","18","Bhaepikuleo bhakumu na Bhastoiko bhabhakabhi bhasomi bhakolongwa nabhombi bhakalochini naku. Bhangi bhakapwaghike, “Bho, hajo bambo malobhi apala kulonge kyane?” Bhangi bhakayangike, “Ibhonikana atangaza malobhi panani ja ichapanga ya kighene.” Bhakalongi ghanihagha maghambu Paulo atangaza malobhi panani jaka Yesu na panani ja kuhyoka. ");
INSERT INTO mpa_vpl VALUES ("AC17_19","074_17_19","ACT","17","19","19","Bhela bhakuntoliki Paulo, na kumpeleka palongi ja pachengo ja muchi papalowakika Aleopago, na kumpwaghila, “Tupala kumanya ndandi ja mabholu hagha ghahenu ghaulongela. ");
INSERT INTO mpa_vpl VALUES ("AC17_20","074_17_20","ACT","17","20","20","Mambu ghatughajowana mumakutu ghitu tubhona kubha gha kigheni kwitu. Tupala kumanya malobhi hagha ndandi jaki kyane.” ");
INSERT INTO mpa_vpl VALUES ("AC17_21","074_17_21","ACT","17","21","21","Bhenei bha ku Asene na bhagheni bhabhatamika konihoku bhakabhi bhakatumila chikahi chabhu chokapi kwa kulandani na kujowanela mabholu ghahenu. ");
INSERT INTO mpa_vpl VALUES ("AC17_22","074_17_22","ACT","17","22","22","Paulo akajemiki pachilanda ja pachengo ja Aleopago na kupwagha, “Mabhandu bha pa Asene, numbona mabhanganya kubha mabhandu mompala namaa kuholalela mambu gha dini. ");
INSERT INTO mpa_vpl VALUES ("AC17_23","074_17_23","ACT","17","23","23","Maghambu panakabhi mbetambeta mu muchi winu nakabhi ningali pandu pinu panjojabhalela, nakaweni chihanja cha nyambiku chilembakiki, ‘Kwaka Chapanga Wangakumanyikana.’ Henu jola jomunjojabhe panga kummanya jonihoju nde nepani jonuntangaza kwinu. ");
INSERT INTO mpa_vpl VALUES ("AC17_24","074_17_24","ACT","17","24","24","Chapanga joabhombiki ndema na hindu yokapi yeibhi mkati jaki, nde Bambo wa kunani kumahunde na ndema najombi ngacheatama mu nyumba ya kunjojabhela yeichengakiki kwa mabhoku gha bhandu. ");
INSERT INTO mpa_vpl VALUES ("AC17_25","074_17_25","ACT","17","25","25","Jombi ngacheapala kunhenge bhandu nahuli apata chokapi chela, nambu jombi nde joabhapeke bhandu bhokapi womi na kubhawezesha kupomola, na hindu yokapi. ");
INSERT INTO mpa_vpl VALUES ("AC17_26","074_17_26","ACT","17","26","26","Kubhokana na mundu jumu akabhombiki mataifa gha bhandu bhokapi bhatama pundema wokapi. Akabhabheki chikahi cha kutama na malindakanilu gha inchi jebhapalika kutama. ");
INSERT INTO mpa_vpl VALUES ("AC17_27","074_17_27","ACT","17","27","27","Chapanga akahengiki bhenibhela nahuli bhaweza kunjengalela, pangi bhakabya bhunhikile hata ngati kwa kupapahapapaha nahuli bhumbonaje. Chakaka Chapanga ngacheabhi kutali na kila jumu witu, ");
INSERT INTO mpa_vpl VALUES ("AC17_28","074_17_28","ACT","17","28","28","ngati moakapwaghi mundu jumu, ‘Mkati jaki tepani tulama, tujenda na tubhile.’ Ngati mobhapwaghi bhatonga nyembu bhinu, ‘Tepani natatu nde bhana bhaki.’ ");
INSERT INTO mpa_vpl VALUES ("AC17_29","074_17_29","ACT","17","29","29","Bhela kwa kubha tepani nde bha lubheleku lwaka Chapanga, ngacheipalika tepani tunholalya kubha Chapanga alenganakeka kwa zahabu, mbija au liganga lelilenganakiki kwa malangu ghaka mundu. ");
INSERT INTO mpa_vpl VALUES ("AC17_30","074_17_30","ACT","17","30","30","Chapanga ngachealinga kabheti chikahi chela bhandu pabhakabhi ngakummanya, nambu sajenu abhalaghalaki bhandu pandu pokapi kung'anambuka na kughaleka mahoku ghabhu. ");
INSERT INTO mpa_vpl VALUES ("AC17_31","074_17_31","ACT","17","31","31","Maghambu ajomwi kupanga lichobha leanatemula ndema wokapi ngati moipalakila kwa indela jaka mundu jumu joanhawile. Chapanga alangihi mambu ghanihagha kubha chakaka kwa kumuyoha mundu hoju kuhuma kwa bhabhapotile!” ");
INSERT INTO mpa_vpl VALUES ("AC17_32","074_17_32","ACT","17","32","32","Pabhajowini Paulo alongale panani ja kuhyoka, bhakumu bhabhu bhakundongime, nambu bhangi bhakapwaghike, “Tupala kujowana kabheti lilobhi leniheli.” ");
INSERT INTO mpa_vpl VALUES ("AC17_33","074_17_33","ACT","17","33","33","Bhela Paulo akabhokiki pachilanda jabhu. ");
INSERT INTO mpa_vpl VALUES ("AC17_34","074_17_34","ACT","17","34","34","Bhandu bhakumu bhakalilombiki naku na kubha bhahobhalela, pachilanda jabhu akabhi Dionisio mundu wa ku Aleopago, na mbomba jumu joalowakika Damali na bhandu bhangi bhamaheli. ");
INSERT INTO mpa_vpl VALUES ("AC18_1","074_18_1","ACT","18","1","1","Paghapetiki mambu ghanihagha, Paulo akabhokiki ku Asene na kujenda ku Kolinso. ");
INSERT INTO mpa_vpl VALUES ("AC18_2","074_18_2","ACT","18","2","2","Konihoku akahimangini na Myahude jumu joalowakika Akila, mbelakeka wa ku Ponto, Akila papamu na nhwanu waki Pulisila, bhakabhi bhabhuja kuhuma ku Italia machobha ghalaghala, maghambu nkolongwa Klaudio akalaghalaki kubha Bhayahude bhokapi bhabhokaje ku Loma. Paulo akapiti kubhabhona, ");
INSERT INTO mpa_vpl VALUES ("AC18_3","074_18_3","ACT","18","3","3","na kwa kubha bhombi bhakabhi mafundi bha kulenganake mahema ngati jombi, Paulo akatami nabhu na kuhenga lihengu leniheli. ");
INSERT INTO mpa_vpl VALUES ("AC18_4","074_18_4","ACT","18","4","4","Kila Lichobha la Sabato, Paulo alongalanya nabhu nahuli kubhapata Bhayahude na Bhagiliki mu nyumba ja kuhimangani Bhayahude. ");
INSERT INTO mpa_vpl VALUES ("AC18_5","074_18_5","ACT","18","5","5","Sila na Timoseo pabhahikiki kuhuma ku Makedonia, Paulo akatumbwi kutumi chikahi chaki chokapi kwa kutangaza Lilobhi laka Chapanga, akabhapwaghi Bhayahude kubha chakaka Yesu nde Kristo. ");
INSERT INTO mpa_vpl VALUES ("AC18_6","074_18_6","ACT","18","6","6","Pabhumpengiki Paulo na kutumbu kuntondola, akaikung'windi ingobhu yaki palongi jabhu akapwaghaje, “Anamuhobhiki mmanya mabhete, nepani ngachemi na lawama panani ja lijambu lenihele! Na kutumbu sajenu nabhajendela bhandu bhangakubha Bhayahude.” ");
INSERT INTO mpa_vpl VALUES ("AC18_7","074_18_7","ACT","18","7","7","Panihapa Paulo akabhalekiki na kujenda kutama kunyumba jaka mundu jumu joalowakika Tito Yusto, joakabhi anjojabhe Chapanga, nyumba jaka mundu jonihoju jakabhi pambipi namaa na nyumba ja kuhimangani Bhayahude jela. ");
INSERT INTO mpa_vpl VALUES ("AC18_8","074_18_8","ACT","18","8","8","Krispo, joakabhi nkolongwa wa nyumba ja kuhimangani Bhayahude jela, akunhobhali Bambo, papamu na bhandu bhokapi bha munyumba jaki. Bhakolinso bhamaheli pabhakaujowini ubholu ghonihoghu, bhakahobhalile, na bhakabatizwe. ");
INSERT INTO mpa_vpl VALUES ("AC18_9","074_18_9","ACT","18","9","9","Lichobha limu ikilu Bambo akalongi naku Paulo mu mabhono, “Ngawijoghopa, nambu ujendalya kubhola wala ngawitumbala, ");
INSERT INTO mpa_vpl VALUES ("AC18_10","074_18_10","ACT","18","10","10","maghambu nepani mi papamu na wehapa. Nga mundu joanawezaje kukukamula nahuli kukupoteka, maghambu bhandu bhamahele bha muchi ghongoni nde bhandu bhango.” ");
INSERT INTO mpa_vpl VALUES ("AC18_11","074_18_11","ACT","18","11","11","Bhela Paulo akatami konihoku koni akabhola Lilobhi laka Chapanga kwa chikahi cha chaka chimu na nusu. ");
INSERT INTO mpa_vpl VALUES ("AC18_12","074_18_12","ACT","18","12","12","Nambu Galio paakabhi mtawala wa ku mkoa wa ku Akaya, Bhayahude bhakalilombiki papamu na kunhenge Paulo mahakau, kwa kunkamula na kumpeleka pachengo. ");
INSERT INTO mpa_vpl VALUES ("AC18_13","074_18_13","ACT","18","13","13","Bhakapwaghiki, “Tuntaki mundu jonjoni kwa kubhahuta bhandu kunjojabhe Chapanga kwa indela jejipengana na shelia.” ");
INSERT INTO mpa_vpl VALUES ("AC18_14","074_18_14","ACT","18","14","14","Paulo paakabhi akali ngakutumbu kulongela, Galio akabhapwaghi Bhayahude, “Njowanya Mwayahude! Ngati chakaka lijambu leniheli lakabhi panani ja uhakau au lihakalilu leahengiki, nakabya nunjowanile. ");
INSERT INTO mpa_vpl VALUES ("AC18_15","074_18_15","ACT","18","15","15","Nambu maghambu ndochana panani ja malobhi na mahina na shelia hinu, mtemula mabhete. Nepani ngachembala kubha mtemula wa mambu ghanihagha!” ");
INSERT INTO mpa_vpl VALUES ("AC18_16","074_18_16","ACT","18","16","16","Panihapa akabhatopwi bhabhokaje pachengu pala. ");
INSERT INTO mpa_vpl VALUES ("AC18_17","074_18_17","ACT","18","17","17","Bhombi bhokapi bhakunkamwi Sositene, nkolongwa wa nyumba ja kuhimangani Bhayahude, na kundapula palongi ja pachengu. Nambu Galio ngacheakaholali panani ja kihengu chenihechi kubha nde chindu. ");
INSERT INTO mpa_vpl VALUES ("AC18_18","074_18_18","ACT","18","18","18","Paulo akajendali kutama na bhahobhalela bha ku Kolinso kwa machobha ghamahele, bhela akabhatawiki, akakweliki sitima kujenda ku Silia papamu na Pulisila na Akila. Pabhakahiki ku Kenkilea Paulo akamoghiki majunju ghaki maghambu akabhehi nazili. ");
INSERT INTO mpa_vpl VALUES ("AC18_19","074_18_19","ACT","18","19","19","Bhakahikiki ku Efeso, konihoku Paulo akabhalekiki Plisila na Akila. Mweni akapiti kujingila munyumba ja kuhimangani Bhayahude na kulongalane na Bhayahude. ");
INSERT INTO mpa_vpl VALUES ("AC18_20","074_18_20","ACT","18","20","20","Bhakunjopiki bhajendalya kutama naku kwa chikahi chamahele, nambu ngacheakajetakile. ");
INSERT INTO mpa_vpl VALUES ("AC18_21","074_18_21","ACT","18","21","21","Nambu paakabhi abhoka, akapwaghike, “Ngati Chapanga anapalike ananhika kabheti kwinu.” Akabhokiki ku Efeso kwa sitima. ");
INSERT INTO mpa_vpl VALUES ("AC18_22","074_18_22","ACT","18","22","22","Paakahikiki ku Kaisalia, Paulo akapiti ku Yelusalemu na kulilamukila likanisa, na panihapa akapiti ku Antiokia. ");
INSERT INTO mpa_vpl VALUES ("AC18_23","074_18_23","ACT","18","23","23","Paakatami konihoku kwa machobha machokopi, akabhokiki na kujendale na mwanja waki kwa kupetela muchi wa Galatia na Filigia, akabhapekya mtima bhahobhalela bhokapi. ");
INSERT INTO mpa_vpl VALUES ("AC18_24","074_18_24","ACT","18","24","24","Myahude jumu joalowakika Apolo, mwenei wa ku Alekizandilia, akahiki ku Efeso. Akabhi mundu joalonge wichu na joaghamanyi nakanopi Malembu Mahuhu. ");
INSERT INTO mpa_vpl VALUES ("AC18_25","074_18_25","ACT","18","25","25","Mundu hoju akabhi abohlakiki indela jaka Bambo, na koni akabya motumotu, akalongi panani ja malobhi ghaka Yesu akabholiki wichu. Nambu, akamanyi pe ubatizo waka Yohana. ");
INSERT INTO mpa_vpl VALUES ("AC18_26","074_18_26","ACT","18","26","26","Apolo akatumbwi kubhola kwa makili munyumba ja kuhimangani Bhayahude. Pulisila na Akila pabhunjowini, bhakuntoliki mbaka kunyumba jabhu na kumbola wichu indela jaka Chapanga. ");
INSERT INTO mpa_vpl VALUES ("AC18_27","074_18_27","ACT","18","27","27","Apolo paakapaliki kujenda ku Akaya, bhahobhalela bhala bhakumpeki mtima kwa kubhalembela baluwa bhahobhalela bha ku Akaya bhunjopalyaje. Paakahikiki konikola, akaweziki kubhajangatila kwa chihomu chaka Chapanga, na kubhajangati nakanopi bhalongu bhala bhabhapatiki kubha bhahobhalela bhaka Kristo. ");
INSERT INTO mpa_vpl VALUES ("AC18_28","074_18_28","ACT","18","28","28","Maghambu akajendali kwa makili kubhaweza Bhayahude palanga akalangiha chakaka kwa kupetela Malembu Mahuhu kubha Yesu nde Kristo. ");
INSERT INTO mpa_vpl VALUES ("AC19_1","074_19_1","ACT","19","1","1","Chikahi Apolo paakabhi ku Kolinso, Paulo akajendali na mwanja waki kupetela inchi ya kundonda na akahiki ku Efeso. Konihoku akabhahimani bhabhulwa bhakumu, ");
INSERT INTO mpa_vpl VALUES ("AC19_2","074_19_2","ACT","19","2","2","akabhalalukile, “Bho, mwakajopali le Roho Mhuhu chikahi pamwahobhalile?” Bhombi bhakamuyangiki, “Ngabhela! Ngachetujowini hata pachokopi kubha kubhi na Roho Mhuhu.” ");
INSERT INTO mpa_vpl VALUES ("AC19_3","074_19_3","ACT","19","3","3","Paulo akabhalalukile, “Wichu, bho, henu mwakabatizwi kwa ubatizu bhole?” Bhakamuyangiki, “Kwa ubatizu waka Yohana.” ");
INSERT INTO mpa_vpl VALUES ("AC19_4","074_19_4","ACT","19","4","4","Paulo akabhapwaghile, “Yohana akabatizi kwa ubatizu wa kung'anambuka na kughaleka mahoku, na kubhapwaghi bhandu kubha bhunhobhalyaje jola joanahikaje punyuma jake, yani, Yesu.” ");
INSERT INTO mpa_vpl VALUES ("AC19_5","074_19_5","ACT","19","5","5","Pabhajowini ghanihagha bhakabatizwi kwa lihina laka Bambo Yesu. ");
INSERT INTO mpa_vpl VALUES ("AC19_6","074_19_6","ACT","19","6","6","Paulo akabhekiki mabhoku ghaki panani jabhu, na Roho Mhuhu akabhahelali panani jabhu, nabhombi bhakatumbwi kulongela kwa lugha nayenge na kulotela. ");
INSERT INTO mpa_vpl VALUES ("AC19_7","074_19_7","ACT","19","7","7","Na ubhalangiku wabhu bhakabhi ngati akanalomi komi na bhabheli. ");
INSERT INTO mpa_vpl VALUES ("AC19_8","074_19_8","ACT","19","8","8","Paulo akajingi munyumba ja kuhimanganila Bhayahude, na kwa chikahi cha myehi jitatu akabhatangazili bhandu panga na choghohi, na akalongalanili nabhu malobhi gha Ukolongwa waka Chapanga koni akapala kubhahuta bhandu bhahobhalyaje. ");
INSERT INTO mpa_vpl VALUES ("AC19_9","074_19_9","ACT","19","9","9","Nambu bhakumu bhabhu bhakabhi na mitima ja kunonopa na ngachebhahobhalile, na bhakatumbwi kulongela mambu mahakau palongi ja lipogha la bhandu kubhokana na Indela jaka Bambo. Bhela Paulo akabhalekiki na kubhatola bhabhulwa bhaki, na kila lichobha akabhi alongalane na bhabhulwa bhaki munyumba ja kulibholela jaka Tilano. ");
INSERT INTO mpa_vpl VALUES ("AC19_10","074_19_10","ACT","19","10","10","Mambu ghanihagha ghakajendali kwa chikahi cha hyaka ibhele, bhela bhandu bhokapi bhabhatamika ku mkoa wa Asia, bhokapi Bhayahude na Bhagiliki, bhakajowini Lilobhi laka Bambo Yesu. ");
INSERT INTO mpa_vpl VALUES ("AC19_11","074_19_11","ACT","19","11","11","Chapanga akahengiki nginyulila ya kukangacha yamahele kupetela mabhoku ghaka Paulo. ");
INSERT INTO mpa_vpl VALUES ("AC19_12","074_19_12","ACT","19","12","12","Bhandu bhakabhi bhatola itambala na ingobhu yengi yeikabhi Paulo atumile, bhakaipeliki kwa bhatamwa, nabhombi bhakalamiki hitamu yabhu, na majobhi ghakabhapitike. ");
INSERT INTO mpa_vpl VALUES ("AC19_13","074_19_13","ACT","19","13","13","Bhakabhi Bhayahude bhakumu bhabhahangajika koni na hako, nabhombi nde bhaponga majobhi, bhakalengiki kuloghola lihina laka Yesu kwa bhala bhabhakabhi na majobhi, bhakapwaghaje, “Nunkenjukila kwa lihina laka Bambo Yesu, joantangaza Paulo, ubhokaje.” ");
INSERT INTO mpa_vpl VALUES ("AC19_14","074_19_14","ACT","19","14","14","Bhabhakabhi bhahenga bhenibhela bhakabhi bhana saba bhaka Sikewa, joakabhi Mpenganyambiku Nkolongwa wa Bhayahude. ");
INSERT INTO mpa_vpl VALUES ("AC19_15","074_19_15","ACT","19","15","15","Nambu lijobhi jola akabhayangike, “Yesu nummanyi, na Paulo nummanyi, bho, nambu mabhanganya mabhane?” ");
INSERT INTO mpa_vpl VALUES ("AC19_16","074_19_16","ACT","19","16","16","Panihapa mundu joakabhi na majobhi jola akabhahombile. Akabhaweziki bhokapi kwa makili na kubhahenge liyaha, bhakatiliki kuhuma munyumba jela bhakabya bhabhi panga na ingobho na bhatweli hilonda. ");
INSERT INTO mpa_vpl VALUES ("AC19_17","074_19_17","ACT","19","17","17","Bhayahude na Bhagiliki bhabhatamika ku Efeso bhakajowini ghanihagha, bhokapi bhakatweliwi na choghohi, na lihina laka Bambo Yesu lakalumbalike. ");
INSERT INTO mpa_vpl VALUES ("AC19_18","074_19_18","ACT","19","18","18","Bhahobhalela bhamahele bhakahikiki palongi ja bhandu na bhakajetakili mahoku ghabhu ghabhakabhi bhaghahengike. ");
INSERT INTO mpa_vpl VALUES ("AC19_19","074_19_19","ACT","19","19","19","Bhangi bhabhakabhi bhahangajika na mambu gha kihabhi pakutumbula hapa, bhakailetiki itabu yabhu na kuijocha kwa moto palongi ja bhandu bhokapi. Bei ja itabu yela payabhalangiki, ikahiki jumula ja ipandi elufu hamsini ya madini gha feza. ");
INSERT INTO mpa_vpl VALUES ("AC19_20","074_19_20","ACT","19","20","20","Ana nde ntundu lilobhi laka Bambo molijonjukakyaje kujaghanila na kubhonikana kubha na makili nakanopi. ");
INSERT INTO mpa_vpl VALUES ("AC19_21","074_19_21","ACT","19","21","21","Paghajomwiki mambu ghanihagha, Paulo akaholali muntima waki kujenda ku Yelusalemu kwa kupetela ku Makedonia na ku Akaya. Akapwaghike, “Ananhikiki konihoku, anaimbalika kujenda mbaka ku Loma nakombe.” ");
INSERT INTO mpa_vpl VALUES ("AC19_22","074_19_22","ACT","19","22","22","Bhela akabhatumiki bhandu bhabhele pachilanda ja bhabhunjangatya lihengu, Timoseo na Elasto bhalongulyaje kujenda ku Makedonia, nambu jombi akahighali kwa chikahi ku mkoa wa Asia. ");
INSERT INTO mpa_vpl VALUES ("AC19_23","074_19_23","ACT","19","23","23","Chikahi chenihechi nde pakukapitali fujo ngolongwa ku Efeso kubhokana na Indela jaka Bambo. ");
INSERT INTO mpa_vpl VALUES ("AC19_24","074_19_24","ACT","19","24","24","Kukabhi na mundu jumu joakabhi alenganakela madini gha feza, lihina laki alowakika Demetilio, lihengu laki lakabhi kulenganakela imong'umong'u ya nyumba ya ichapanga ya chimbomba yeilowakika Alitemi. Lihengu leniheli lakabhapeki bhatumika bhaki nyonjeka yamaheli. ");
INSERT INTO mpa_vpl VALUES ("AC19_25","074_19_25","ACT","19","25","25","Bhela akabhabhongini bhatumika bhaki bhokapi papamu na bhandu bhangi bhabhahengika lihengu ngati leniheli na kubhapwaghila, “Bhalongo, mmanyi kubha tepani tupata mbija yamahele kupetela lihengu lendenu. ");
INSERT INTO mpa_vpl VALUES ("AC19_26","074_19_26","ACT","19","26","26","Henu mabheti mmbona na kujowana ntundu moahenge Paulo. Ajomwi kubhahuta na kubhalakalila bhandu bhamahele, nga pa Efeso pani pela, nambu na ku mkoa wokapi wa ku Asia. Apwagha kubha imong'umong'u yebhalenganake bhandu nga ichapanga hata pachokope. ");
INSERT INTO mpa_vpl VALUES ("AC19_27","074_19_27","ACT","19","27","27","Bhela kubhi na hatale biashala jitu anajipohakika lihamu. Na wala nga bhenibhela pela, nambu lijambu leniheli liweza kujitenda nyumba ja ichapanga imbomba Alitemi, anaibhalangikaje kubha nde chindu cha waka. Na ulumbalilu waki anaujomukaje, jombi jobhunjojabhela bhandu bhokapi bha ku Asia na pundema wokapi!” ");
INSERT INTO mpa_vpl VALUES ("AC19_28","074_19_28","ACT","19","28","28","Bhandu bhala pabhajowini malobhi ghanihagha, bhakatweliwi na inyela na kutumbu kujamalila bhakapwagha, “Alitemi wa ku Efeso nde Nkolongwa!” ");
INSERT INTO mpa_vpl VALUES ("AC19_29","074_19_29","ACT","19","29","29","Fujo jakatumbwi ku muchi wokapi. Bhandu bhala bhakabhakamwi Gayo na Alistako bhenei bha ku Makedonia, bhabhakabhi bhalongana papamu na Paulo, na bhokapi kwa kujombateka bhakabhapeliki muchibhanja cha kukinila. ");
INSERT INTO mpa_vpl VALUES ("AC19_30","074_19_30","ACT","19","30","30","Paulo akapaliki kulilangiha pa lipogha la bhandu pala, nambu bhabhulwa bhala bhakunhibhalile. ");
INSERT INTO mpa_vpl VALUES ("AC19_31","074_19_31","ACT","19","31","31","Ihongozi bhakumu bha mkoa wa ku Asia, bhabhakabhi bhakochi bhaki bhakumpelaki ubholu bhakunjopa kubha ngahijingila mkati ja liwangala la kukinila lela. ");
INSERT INTO mpa_vpl VALUES ("AC19_32","074_19_32","ACT","19","32","32","Chikahi hechi kila mundu akabhi ajamalila, bhangi aleli na bhangi aleli, mbaka uhimanganu weni ukayonangike, na bhangi ngachebhamanyi kwa ndandi ja kiki bhahimangini panihapa. ");
INSERT INTO mpa_vpl VALUES ("AC19_33","074_19_33","ACT","19","33","33","Bhayahude bhakunkangiki Alekizanda apitalyaje palongi, bhandu bhangi pa lipogha lela bhahambukya kubha jonihoju nde joatumbulila mambu ghanihagha. Bhela Alekizanda akabhakinyuli bhandu kwa chiwoku chaki koni akapala kulikengalela palongi ja lipogha la bhandu lela. ");
INSERT INTO mpa_vpl VALUES ("AC19_34","074_19_34","ACT","19","34","34","Nambu pabhamanyiki kubha jombi Myahude, bhokapi bhakajamalili papamu kwa chikahi cha masaa ghabhele, bhakapwaghaje, “Alitemi wa ku Efeso nde Nkolongwa!” ");
INSERT INTO mpa_vpl VALUES ("AC19_35","074_19_35","ACT","19","35","35","Pakujomukela chiongozi jumu wa muchi akabhatumbalishi bhandu, akapwaghaje, “Mabhalongu bhangu Bhaefeso! Bho, bhandu bhokapi bha pundema le ngachebhamanyi kubha bhenei bha pa Efeso nde bhabhapalika kulenda nyumba ja ichapanga Alitemi na chimong'umong'u chaki chekiheli kuhuma kunani kumahunde? ");
INSERT INTO mpa_vpl VALUES ("AC19_36","074_19_36","ACT","19","36","36","Njeta mundu joaweza kukana mambu ghangane. Bhela, impalika ntumbalaje na ngamwihenga chindu chokapi chela panga na kuholalela. ");
INSERT INTO mpa_vpl VALUES ("AC19_37","074_19_37","ACT","19","37","37","Maghambu mubhaletiki bhandu abhabha pambane, hata koni ngachebhajibhiki hindu ya munyumba jaka kichapanga Alitemi, wala kuitondola ichapanga hitu ya chimbomba. ");
INSERT INTO mpa_vpl VALUES ("AC19_38","074_19_38","ACT","19","38","38","Ana ngati Demetilio na mafundi bhajaki bhabhi na matakilu panani jaka mundu jokapi jola, kubhi na pachengo na bhakolongwa bha mikoa, bhaweza kujenda kutakila konihoku. ");
INSERT INTO mpa_vpl VALUES ("AC19_39","074_19_39","ACT","19","39","39","Nambu ana ngati mbi na mambu ghangi, ghapalika ghajomukanya pa uhimanganu ghoupalika. ");
INSERT INTO mpa_vpl VALUES ("AC19_40","074_19_40","ACT","19","40","40","Maghambu kubhokana na mambu ghaghapitali lalenu, bhaweza kututakila kubha tuletiki fujo. Kabheti njeta lilobhi letuweza kulilongela kwa kulanda ndandi ja kuhenga uhimanganu ghongone.” ");
INSERT INTO mpa_vpl VALUES ("AC19_41","074_19_41","ACT","19","41","41","Bhela chiongozi hoju paakalongi malobhi ghanihagha, akabhapwaghi bhandu bhabhokaje. ");
INSERT INTO mpa_vpl VALUES ("AC20_1","074_20_1","ACT","20","1","1","Fujo payajomwiki, Paulo akabhabhongini bhabhulwa na kubhapeke malobhi gha kubhajeghe mtima. Panihapa akabhatawiki na kujenda ku Makedonia. ");
INSERT INTO mpa_vpl VALUES ("AC20_2","074_20_2","ACT","20","2","2","Akapetiki ku inchi jenijela akabhapwaghila bhabhulwa malobhi ghamaheli gha kubhajeghe mtima. Na bhela akahikiki ku Ugiliki, ");
INSERT INTO mpa_vpl VALUES ("AC20_3","074_20_3","ACT","20","3","3","konihoku akatami kwa myehi jitatu. Paakabhi alibhehi wichu kujenda ku Silia, akajowini kubha Bhayahude bhapalika kunhenge mahakau, bhela akaholali kukelabhuka kwa kupetela ku Makedonia. ");
INSERT INTO mpa_vpl VALUES ("AC20_4","074_20_4","ACT","20","4","4","Bhandu abhabha nde bhabhapiti papamu naku, Sopatulo mwana waka Pilo, kuhuma ku Beloya, bhangi Alistako na Sekundo, kuhuma ku Sesalonike, na Gayo kuhuma ku Delibe, Timoseo na Tikiko na Tilofimo kuhuma ku mkoa wa ku Asia. ");
INSERT INTO mpa_vpl VALUES ("AC20_5","074_20_5","ACT","20","5","5","Bhanganya habha bhakatulongulili na kujenda kutulendale ku Tiloa. ");
INSERT INTO mpa_vpl VALUES ("AC20_6","074_20_6","ACT","20","6","6","Pawapetiki uwangalalu wa kula Mikati Jangakujeghaleka Amila, tukakweliki sitima kuhuma ku Filipi na lichobha la kahanu tukahimangini nabhu ku Tiloa, konihoku tukatami kwa machobha saba. ");
INSERT INTO mpa_vpl VALUES ("AC20_7","074_20_7","ACT","20","7","7","Jumamosi pakamihi tukalibhongini papamu nahuli kuheketa libumunda. Paulo akabhatangazi bhandu, najombi kwa kubha akaholali kubhoka chilabhu jaki, akajendali kulonge nabhu mbaka pamahiku. ");
INSERT INTO mpa_vpl VALUES ("AC20_8","074_20_8","ACT","20","8","8","Kukabhi na taa yamaheli muchumba cha kugholofa chela chetukabhi tulibhongini mkati jaki. ");
INSERT INTO mpa_vpl VALUES ("AC20_9","074_20_9","ACT","20","9","9","Nkombu jumu joalowakika Eutiko akabhi atami palidilisha. Chikahi Paulo paakabhili ajendalela kutangaza, nkombu hoju akatumbwi kutitila mbolimboli, na pakujomukela akaawiki kuhuma kugholofa ja katatu mbaka pahi. Pabhakunjumwihi bhakunhimani ajomwi kupotela. ");
INSERT INTO mpa_vpl VALUES ("AC20_10","074_20_10","ACT","20","10","10","Nambu Paulo akaheli mbaka pahi na kunhabhukila panani jaki na kunkumbatila na kupwagha, “Ngamwijoghopa, maghambu akali mwome!” ");
INSERT INTO mpa_vpl VALUES ("AC20_11","074_20_11","ACT","20","11","11","Bhela Paulo akakweliki kabheti kugholofa, akahekiti libumunda, na kula. Akajendali kulongela nabhu kwa chikahi chilachu mbaka palukela, na panihapa akabhokike. ");
INSERT INTO mpa_vpl VALUES ("AC20_12","074_20_12","ACT","20","12","12","Bhandu bhala bhakuntoliki nkombu jola mbaka kunyumba akabya mwome na bhakahekali namaa. ");
INSERT INTO mpa_vpl VALUES ("AC20_13","074_20_13","ACT","20","13","13","Tepani tukalongulili kujingi musitima na kujenda ku Aso, konihoku tupita kuntola Paulo. Bhenibhela nde moatulaghalakile, maghambu akaholali kujenda konihoku kwa magholu. ");
INSERT INTO mpa_vpl VALUES ("AC20_14","074_20_14","ACT","20","14","14","Patahimangini naku ku Aso, twakuntoliki musitima na kujenda ku Mitilene. ");
INSERT INTO mpa_vpl VALUES ("AC20_15","074_20_15","ACT","20","15","15","Chilabhu jaki tukabhokiki konikola kwa sitima na kujenda ku Kio. Na pamalabhu jaki tukalombwiki ku chilu cha Samo, na lichobha lelijengalyaje tukahiki ku Mileto. ");
INSERT INTO mpa_vpl VALUES ("AC20_16","074_20_16","ACT","20","16","16","Paulo akaholali ngatwipetela ku Efeso kwa sitima, nahuli ngaayikabhaki ku mkoa wa ku Asia. Maghambu akabhi ajombatakela kujenda ku Yelusalemu kwa uwangalalu wa Pentekoste, ngati anaiwezakine. ");
INSERT INTO mpa_vpl VALUES ("AC20_17","074_20_17","ACT","20","17","17","Kuhuma ku Mileto Paulo akatumiki bhandu kujenda ku Efeso, na kubhakema bhazee bha likanisa nahuli bhahimangana naku. ");
INSERT INTO mpa_vpl VALUES ("AC20_18","074_20_18","ACT","20","18","18","Nabhombi pabhahikiki, akabhapwaghile, “Mmanyi ntundu monatami na mabhanganya machobha ghokapi kutumbu lichobha la kutumbula panahiki mu mkoa wa Asia. ");
INSERT INTO mpa_vpl VALUES ("AC20_19","074_20_19","ACT","20","19","19","Mmanyi ntundu monuntumakya Bambo kwa kuliheleya kwokapi na kwa maholi ghamaheli na kulengakeka konapetile na mipangu mihakau ja Bhayahude. ");
INSERT INTO mpa_vpl VALUES ("AC20_20","074_20_20","ACT","20","20","20","Mmanyi kubha ngachenakotwiki hata pachokopi kutangaza palanga, na munyumba hinu na kumbola chokapi cha kunjangatila. ");
INSERT INTO mpa_vpl VALUES ("AC20_21","074_20_21","ACT","20","21","21","Nakabhalakali Bhayahude na Bhagiliki kubha ibhapalika kung'anambuka na kughaleka mahoku na kunkelabhuki Chapanga na kunhobhale Bambo witu Yesu Kristo. ");
INSERT INTO mpa_vpl VALUES ("AC20_22","074_20_22","ACT","20","22","22","Henu, nakabya anongo Roho Mhuhu, nyenda ku Yelusalemu, panga kumanya mambu ghaghimbata konihoku. ");
INSERT INTO mpa_vpl VALUES ("AC20_23","074_20_23","ACT","20","23","23","Chenikimanya pe kubha Roho Mhuhu ambwaghila mu kila muchi kubha kukongeka na kung'ahika nde yeinendalela. ");
INSERT INTO mpa_vpl VALUES ("AC20_24","074_20_24","ACT","20","24","24","Nambu malanga womi wangu kubha nga chindu kwangu, chindu chimu chenikilingalila nde kuhika kuujomukelu wa utumika wangu na kuhenga lihengu lela leambeki Bambo Yesu, yani kutangaza Malobhi Manyahi gha chihomu chaka Chapanga. ");
INSERT INTO mpa_vpl VALUES ("AC20_25","074_20_25","ACT","20","25","25","“Nakabhi niyongolota kwinu mabhanganya mabhokapi nakatangaza Ukolongwa waka Chapanga. Na sajenu manyi kubha njeta hata jumu winu joanamona kabhete. ");
INSERT INTO mpa_vpl VALUES ("AC20_26","074_20_26","ACT","20","26","26","Nde ndandi nongela palongi jinu lalenu kubha anaipitali jumu winu anahobhiki, nepani ngachemili na lawama jokapi jela kwaka mundu jonihoju. ");
INSERT INTO mpa_vpl VALUES ("AC20_27","074_20_27","ACT","20","27","27","Maghambu nakuntangazili mwehapa mambu ghokapi ghaaghapala Chapanga panga kunhiya chindu. ");
INSERT INTO mpa_vpl VALUES ("AC20_28","074_20_28","ACT","20","28","28","Mulilingalya mabhete na mlilenda lipogha lokapi ambalu Roho Mhuhu ambekiki mabhanganya kubha bhajemalela bhaki. Mulighoha likanisa laka Chapanga lealihemile kwa mwahi waka Mwana waki. ");
INSERT INTO mpa_vpl VALUES ("AC20_29","074_20_29","ACT","20","29","29","Nimanyi wichu kubha anamokiki mabweha makali anaghahika kwinu, na ngaghikubhi na chiha kwa lipogha leniheli. ");
INSERT INTO mpa_vpl VALUES ("AC20_30","074_20_30","ACT","20","30","30","Pachilanda jinu anabhapitalya bhandu bhabhibhola mambu gha ichole nahuli kubhahoa bhabhulwa na kupala bhabhajengalya bhombi pela. ");
INSERT INTO mpa_vpl VALUES ("AC20_31","074_20_31","ACT","20","31","31","Kwa ndandi jeniheji mulilingalyaje, koni mwakakombuka kubha kwa hyaka itatu, ikilu na muhi, ngachenakotwiki kundakalila kila jumu winu kwa mahole. ");
INSERT INTO mpa_vpl VALUES ("AC20_32","074_20_32","ACT","20","32","32","“Bhela, sajenu numbeka pahi ja ulingalilu waka Chapanga, na wa lilobhi laki la chihomu leliweza kunchenga na kumpeke mwehapa upwelelu papamu na bhandu bhaki bhabhagholulike. ");
INSERT INTO mpa_vpl VALUES ("AC20_33","074_20_33","ACT","20","33","33","Nepani ngachenatokuli madini gha feza, zahabu na ingobhu yaka mundu jokapi jola. ");
INSERT INTO mpa_vpl VALUES ("AC20_34","074_20_34","ACT","20","34","34","Mabhanganya mabhete mmanyi ntundu monahengi lihengu kwa mabhoku ghangu namweti nahuli kulipati yenipala nepani, na yebhipala bhala bhabhakabhili papamu na nepani. ");
INSERT INTO mpa_vpl VALUES ("AC20_35","074_20_35","ACT","20","35","35","Kubhokana na mambu ghokapi hagha ghandendiki, nundangi kubha kwa ntundu aghoghu wa mtima wambone, itupalika kuhenga lihengu nakanopi kwa kubhajangati bhangakujiweza, koni tukakombuka malobhi ghaki mweni Bambo Yesu, paapwaghika, ‘Mbanga nakanopi kubhoha kuliku kujopalela.’ ” ");
INSERT INTO mpa_vpl VALUES ("AC20_36","074_20_36","ACT","20","36","36","Paulo paakajomwi kulongela mambu ghanihagha ghokapi, akachikimi pahi papamu nabhu bhokapi na kundobha Chapanga. ");
INSERT INTO mpa_vpl VALUES ("AC20_37","074_20_37","ACT","20","37","37","Bhokapi bhakaleliki, na kuntabhuka Paulo kwa kunkumbatila na kumbusu. ");
INSERT INTO mpa_vpl VALUES ("AC20_38","074_20_38","ACT","20","38","38","Bhakaleliki nakanopi maghambu akabhapwaghi kubha ngabhamboni kabhete. Na bhela bhakunhindaki mbaka ku sitima. ");
INSERT INTO mpa_vpl VALUES ("AC21_1","074_21_1","ACT","21","1","1","Patajomwi kulaghalani nabhu, tukajingi mu sitima na kujenda mbaka ku Kosi. Chilabhu jaki tukahikiki ku muchi wa Lodo, na kubhoka konihoku tukahiki ku muchi wa Patala. ");
INSERT INTO mpa_vpl VALUES ("AC21_2","074_21_2","ACT","21","2","2","Konihoku tukajihimani sitima jejijenda ku Foinike, tukajingi monihomu na kujenda. ");
INSERT INTO mpa_vpl VALUES ("AC21_3","074_21_3","ACT","21","3","3","Patwahiki pandu patwabhona kubha pa Kipulo, tukapeti upambala waki wa kunkache na kujenda ku Silia. Tukabhei ngimo ku muchi wa ku Tilo, maghambu panipala nde pajipalakika sitima jela kuhuluha ibwahila. ");
INSERT INTO mpa_vpl VALUES ("AC21_4","074_21_4","ACT","21","4","4","Konikola tukabhahimani bhabhulwa na tukatami nabhu kwa machobha saba. Nabhombi koni bhakalonguhika na Roho Mhuhu bhakumpwaghi Paulo ngaijenda ku Yelusalemu. ");
INSERT INTO mpa_vpl VALUES ("AC21_5","074_21_5","ACT","21","5","5","Nambu chikahi chitu pachajomwiki tukabhokiki na kujendale na mwanja witu na bhandu bhokapi, papamu na akabhahanu bhabhu na bhana bhabhu, bhakatuhindaki mbaka kunja ja muchi. Patwahiki kumaheku, tukachikimi na kundobha Chapanga. ");
INSERT INTO mpa_vpl VALUES ("AC21_6","074_21_6","ACT","21","6","6","Bhela tukalaghalani nabhu, na tepani tukakweliki musitima nambu bhombi bhakabhujiki kunyumba jabhu. ");
INSERT INTO mpa_vpl VALUES ("AC21_7","074_21_7","ACT","21","7","7","Kubhoka ku Tilo tukajendali na mwanja witu na kuhika ku Tolemai, konihoku tukabhalamuki bhahobhalela bhajitu na kutama nabhu kwa lichobha limu. ");
INSERT INTO mpa_vpl VALUES ("AC21_8","074_21_8","ACT","21","8","8","Chilabhu jaki tukabhokiki na kuhika ku muchi wa ku Kaisalia. Konihoku tukajingi munyumba jaka mtangaza jumu wa Malobhi Manyahi, lihina laki alowakika Filipo, joakabhi jumu pa chilanda ja bhandu saba bhabhahaghuliki ku Yelusalemu. ");
INSERT INTO mpa_vpl VALUES ("AC21_9","074_21_9","ACT","21","9","9","Akabhi na akakamwali ncheche bhabhakabhi bhakona mabikila, bhanganya habha bhakabhi bhalota bhaka Chapanga. ");
INSERT INTO mpa_vpl VALUES ("AC21_10","074_21_10","ACT","21","10","10","Bhela tepani patukabhi tutami konihoku kwa machobha ghamahele, mlota jumu waka Chapanga joalowakika Agabo akahiki kuhuma ku Yudea. ");
INSERT INTO mpa_vpl VALUES ("AC21_11","074_21_11","ACT","21","11","11","Paakatuhikili, akatoliki ulamba waka Paulo, akalikongiki magholu na mabhoku ghaki, na kupwagha, “Roho Mhuhu apwagha anana, ‘Bhayahude bha ku Yelusalemu anabhunkonga kwa ntundu ghongo mundu mweni ulamba ghongoni na kumboha kwa bhandu bhangakubha Bhayahude.’ ” ");
INSERT INTO mpa_vpl VALUES ("AC21_12","074_21_12","ACT","21","12","12","Patwajowini ghanihagha, tepani na bhandu bhangi bhabhakabhi panihapa tukunjopiki Paulo ngaijenda ku Yelusalemu. ");
INSERT INTO mpa_vpl VALUES ("AC21_13","074_21_13","ACT","21","13","13","Nambu Paulo akayangiki, “Bho, maghambu ja kiki ndela na kundunyu mtima? Nepani mi tayali nga pe kungonga ku Yelusalemu, nambu hata kupotela kwa ndandi ja lihina laka Bambo Yesu.” ");
INSERT INTO mpa_vpl VALUES ("AC21_14","074_21_14","ACT","21","14","14","Patwaweni akaniki malobhi ghitu, tukatumbili na kupwagha, “Mapalu ghaka Bambo na ghahengakikaje.” ");
INSERT INTO mpa_vpl VALUES ("AC21_15","074_21_15","ACT","21","15","15","Patwatami panipala kwa chikahi, tukakongiki ibwahila hitu na kukwela kujenda ku Yelusalemu. ");
INSERT INTO mpa_vpl VALUES ("AC21_16","074_21_16","ACT","21","16","16","Bhabhulwa bhakumu kuhuma ku muchi wa ku Kaisalia bhakapiti papamu na tepani na kutupeleka kunyumba jaka Mnasoni, mundu wa ku Kipulo, jumu wa bhabhulwa bha mwande, nahuli tukatama kwaki. ");
INSERT INTO mpa_vpl VALUES ("AC21_17","074_21_17","ACT","21","17","17","Patwahiki ku Yelusalemu, bhalongu bhahobhalela bhakatujopalili kwa chiheku namaa. ");
INSERT INTO mpa_vpl VALUES ("AC21_18","074_21_18","ACT","21","18","18","Chilabhu jaki Paulo akapiti papamu na tepani kundamuki Yakobo, na bhazee bhokapi bha likanisa bhakabhi panipala. ");
INSERT INTO mpa_vpl VALUES ("AC21_19","074_21_19","ACT","21","19","19","Paulo akabhalamukili na kubhapeke ubholu wokapi Chapanga ghoakahengiki kwa bhandu bhangakubha Bhayahude kupetela lihengu laki. ");
INSERT INTO mpa_vpl VALUES ("AC21_20","074_21_20","ACT","21","20","20","Pabhajowini malobhi ghanihagha, bhakundumbali Chapanga. Na bhela bhakumpwaghi Paulo, “Ndongu wito, ubhona ntundu Bhayahude bhamaheli nakanopi mobhunhobhalile Kristo, na bhokapi bhalibhoha namaa kwa kukamulakila Shelia. ");
INSERT INTO mpa_vpl VALUES ("AC21_21","074_21_21","ACT","21","21","21","Bhajowini malobhi panani jaku kubha ubhi ukabhabhola Bhayahude bhabhatama kwa bhandu bhangakubha Bhayahude ngabhikamulaki Shelia yaka Musa, na ubhakanakili ngabhacheku jando bhana bhabhu wala ngabhijengalela mitetu ja Bhayahude. ");
INSERT INTO mpa_vpl VALUES ("AC21_22","074_21_22","ACT","21","22","22","Bho, henu tuhenga kike? Maghambu chakaka bhandu bhala anabhajowana kubha ujomwi kuhika. ");
INSERT INTO mpa_vpl VALUES ("AC21_23","074_21_23","ACT","21","23","23","Henu tukujopa uhenga chenjenu chetukupwaghila. Pambani tubhi na bhandu ncheche bhabhabhekiki nazili palongi jaka Chapanga. ");
INSERT INTO mpa_vpl VALUES ("AC21_24","074_21_24","ACT","21","24","24","Ubhatola bhandu bhanihabha, na ulilomba nabhu mu uwangalalu wa kuligholola, na ukabhalepila malepu ghaghapalika nahuli bhapata kumoghakeka majunju ghabhu. Na kubhoke panihapa bhandu bhokapi bhimanya kubha wehapa wamwete utama na kujengalela Shelia. ");
INSERT INTO mpa_vpl VALUES ("AC21_25","074_21_25","ACT","21","25","25","Nambu panani ja bhandu bhangakubha Bhayahude bhabhabhi bhahobhalela, tujomwi kubhapelakela baluwa ja mambu ghatuamwile, kubha ngabhikula chilebhi chokapi chekitambakiwi imong'umong'u, na ngabhikula wala kunywa mwahi, na ngabhikula inyama ja chinyama chekinyongakike, na ngabhikubha bhakemi.” ");
INSERT INTO mpa_vpl VALUES ("AC21_26","074_21_26","ACT","21","26","26","Bhela chilabhu jaki Paulo akapiti na bhandu ncheche bhala na kuligholola papamu nabhu. Na akajingi mu Nyumba jaka Chapanga na kutangaza ujomukelu wa lichobha la kuligholola na panani ja nyambiku jaka Chapanga kwa ndandi ja kila jumu wabhu. ");
INSERT INTO mpa_vpl VALUES ("AC21_27","074_21_27","ACT","21","27","27","Machobha saba paghaheghalya kujomoka, Bhayahude bhakumu bhabhahumila ku mkoa wa ku Asia bhakumbweni Paulo mu Nyumba jaka Chapanga. Bhombi bhakabhachochaki bhandu bhokapi bhabhalibhongini na kunkamu Paulo. ");
INSERT INTO mpa_vpl VALUES ("AC21_28","074_21_28","ACT","21","28","28","Bhakajamalili bhakapwaghaje, “Bhandu bha Izilaeli, mtujangatyaje!” Hajoju nde mundu jola jobhabhola bhandu bhokapi mambu ghaghapenga bhandu bha Izilaeli, ghaghapengana na Shelia, na pa Nyumba jaka Chapanga pani. Kabhete abhajingihi Bhagiliki mu Nyumba jaka Chapanga na kupajeghela uhakau pandu pani pahuhu. ");
INSERT INTO mpa_vpl VALUES ("AC21_29","074_21_29","ACT","21","29","29","Bhakalongi bhenibhela maghambu bhakumbweni Tilofimo, mundu wa ku Efeso, akabya kumbwane papamu na Paulo, nabhombi bhaholalya kubha Paulo akunjingi mundu hoju mu Nyumba jaka Chapanga. ");
INSERT INTO mpa_vpl VALUES ("AC21_30","074_21_30","ACT","21","30","30","Muchi wokapi ukajaghani fujo, na bhandu bhokapi bhakakembili imbelu na kulibhongana panipala, bhakunkamwi Paulo, na kunhutana mbaka kunja ja Nyumba jaka Chapanga. Na palapala bhakajighi milyangu ja Nyumba jaka Chapanga. ");
INSERT INTO mpa_vpl VALUES ("AC21_31","074_21_31","ACT","21","31","31","Pabhakabhi bhalonda indela ja kunkoma Paulo, malobhi ghakunhiki nkolongwa wa manjolinjoli wa Kiloma kubha muchi wokapi wa ku Yelusalemu utweli fujo. ");
INSERT INTO mpa_vpl VALUES ("AC21_32","074_21_32","ACT","21","32","32","Palapala akabhatoliki manjolinjoli na ihongozi bhakumu na kukembela nabhu mbaka pandu pabhalibhongini bhandu pala. Nabhombi pabhumbweni chiongozi hoju na manjolinjoli bhaki, bhakakotwiki kundapu Paulo. ");
INSERT INTO mpa_vpl VALUES ("AC21_33","074_21_33","ACT","21","33","33","Chiongozi wa manjolinjoli hoju akunjendi Paulo, akunkamwili na kubhoha malagahlakilu kubha akongakikaje kwa minyololo jibhele. Bhela akalalukile, “Bho, mundu hajoju nde nane? Na bho, ahengiki kyane?” ");
INSERT INTO mpa_vpl VALUES ("AC21_34","074_21_34","ACT","21","34","34","Bhandu bhangi pa lipogha lela bhakajamalili na kupwagha chindu achechi, na bhangi chindu chengi. Nambu kubhokana na ngomela ya bhandu bhala, chiongozi hoju ngacheaweziki kumanya ndandi ja ngomela yeniheyi, bhela akalaghalakili bhundeta Paulo munyumba ja manjolinjoli. ");
INSERT INTO mpa_vpl VALUES ("AC21_35","074_21_35","ACT","21","35","35","Paulo paakahiki pa ngazi, manjolinjoli ikabhapaliki kuntotola munani munani maghambu ja bhandu kujonjukela fujo. ");
INSERT INTO mpa_vpl VALUES ("AC21_36","074_21_36","ACT","21","36","36","Maghambu bhokapi bhatendika kunjengalela, bhakajamalyaje, “Unkomaje mundu hoju!” ");
INSERT INTO mpa_vpl VALUES ("AC21_37","074_21_37","ACT","21","37","37","Manjolinjoli pabhapalika kunjingi Paulo munyumba, akundaluki chiongozi wa lipogha la manjolinjoli, “Bho, uweza le kunyetakale kukupwaghi lilobhi limo?” Chiongozi wa manjolinjoli jola akundalukile, “Bho, umanyi kulonge lugha ja Kigiliki? ");
INSERT INTO mpa_vpl VALUES ("AC21_38","074_21_38","ACT","21","38","38","Bho, wehapa le nga Ummisili joatumbulya kuasi machobha gha lakwichu na kubhalongo magaide elufu ncheche mbaka kulipololu?” ");
INSERT INTO mpa_vpl VALUES ("AC21_39","074_21_39","ACT","21","39","39","Paulo akayangike, “Nepani nde Myahude, mbelakeka wa muchi wa ku Taso ja ku inchi ja ku Kilikia. Nhuma ku muchi ghoumanyikana nakanopi. Chondi nukujopa unyetakalya kulonge na bhandu abhabha.” ");
INSERT INTO mpa_vpl VALUES ("AC21_40","074_21_40","ACT","21","40","40","Nkolongwa wa manjolinjoli jola akunjetakalile, bhela Paulo akajemiki pa ngazi na kubhaponge bhandu chiwoku bhatumbalaje. Na bhandu pabhatumbili nakanopi, Paulo akalongi nabhu kwa lugha ja Kiebulania, akapwaghaje, ");
INSERT INTO mpa_vpl VALUES ("AC22_1","074_22_1","ACT","22","1","1","“Mwalongu bhangu Bhayahude, nyowanya chela chembala kulongela kwa kulikengale palongi jinu!” ");
INSERT INTO mpa_vpl VALUES ("AC22_2","074_22_2","ACT","22","2","2","Pabhakajowini kubha alongela nabhu kwa lugha ja Kiebulania, bhakajendalili kutumbala nakanopi kupeta pakutumbula hapa, na Paulo akajendali kupwagha, ");
INSERT INTO mpa_vpl VALUES ("AC22_3","074_22_3","ACT","22","3","3","“Nepani nde Myahude, melakiki ku Taso, ku inchi ja ku Kilikia, neliwi mu muchi ghongoni wa Yelusalemu ngati mbulwa waka Gamalieli. Molakiki kukamulakila wichu Shelia ya akahokolu bhitu na nakalibhohiki kwa kuntumakila Chapanga ngati mombeli mabhanganya mabhokapi lalenu. ");
INSERT INTO mpa_vpl VALUES ("AC22_4","074_22_4","ACT","22","4","4","Nepani nakabhang'ahiki na hata kubhakoma bhandu bhabhajengalyaje Indela jaka Bambo. Nakabhakamwi akambomba na akanalomi na kubhakonga muligeleza. ");
INSERT INTO mpa_vpl VALUES ("AC22_5","074_22_5","ACT","22","5","5","Hata Mpenganyambiku Nkolongwa papamu na lipogha lokapi la bhazee bha pachengu bhaweza kunandila kubha mbwagha chachaka. Kuhuma kwabhu bhakambeki baluwa jebhakabhalembile Bhayahude bhajitu bhabhatama ku Damasko, bhela nakapiti konihoku nahuli nakabhakamulaje bhandu bhahobhalela na kubhaleta bhakabya bhakongakiki mbaka ku Yelusalemu nahuli bhalapulikaje. ");
INSERT INTO mpa_vpl VALUES ("AC22_6","074_22_6","ACT","22","6","6","“Panakabhi nyendale na mwanja pambipi kuhika ku Damasko, ikabhi ngati saa sita ja muhi, unang'anu ukolongwa ukabhonakini kuhuma kunani kumahunde na ukamulakili nepani ipambala yokapi. ");
INSERT INTO mpa_vpl VALUES ("AC22_7","074_22_7","ACT","22","7","7","Nakaawiki pahi, na nakajowini sauti jakambwaghilaje, ‘Sauli, Sauli! Bho, maghambu kiki uning'aha?’ ");
INSERT INTO mpa_vpl VALUES ("AC22_8","074_22_8","ACT","22","8","8","Nakalalukile, ‘Bho, wehapa wa nane, Bambo?’ Akayangike, ‘Nepani nde Yesu wa ku Nazaleti, joung'aha.’ ");
INSERT INTO mpa_vpl VALUES ("AC22_9","074_22_9","ACT","22","9","9","Bhajangu bhanabhi nabhu bhakauweni unang'anu hoghu, bhakajowipi nambu ngachebhajowini sauti jaka jola joalongila na nepane. ");
INSERT INTO mpa_vpl VALUES ("AC22_10","074_22_10","ACT","22","10","10","Bhela nakalalukile, ‘Bho, ndenda kike, Bambo?’ Bambo akayangike, ‘Ujemaje, ujenda ku Damasko, na konihoku anabhakupwaghila ghokapi ghaupalika kughahenga.’ ");
INSERT INTO mpa_vpl VALUES ("AC22_11","074_22_11","ACT","22","11","11","Na kwa kubha nakabhi ngachemona kwa ndandi ja kung'anya kwa unang'anu ghola, bhajangu bhakangamwi chiwoku na kunongoha mbaka nakahikiki ku Damasko. ");
INSERT INTO mpa_vpl VALUES ("AC22_12","074_22_12","ACT","22","12","12","“Na ku Damasko kola kukabhi na mundu jumu joalowakika Anania, mundu joanjojabhe Chapanga na kukamulaki namaa Shelia hitu. Joakatopile nakanopi na Bhayahude bhokapi bhabhatama konihoku. ");
INSERT INTO mpa_vpl VALUES ("AC22_13","074_22_13","ACT","22","13","13","Jombi akahikiki, akajemiki pambipi na nepani, na kumbwaghila, ‘Undongu wangu wa Sauli, upata kulola kabhete!’ Na palapala nakapatiki kulola kabhete na kuweza kumbona. ");
INSERT INTO mpa_vpl VALUES ("AC22_14","074_22_14","ACT","22","14","14","Bhela Anania akapwaghike, ‘Chapanga wa akahokolu bhitu akuhawi wehapa nahuli ughamanyaje mapalu ghaki. Apala umbonaje jola Mweni haki, na kughajowana malobhi ghaghapita kuhuma mu ndomu waki mweni. ");
INSERT INTO mpa_vpl VALUES ("AC22_15","074_22_15","ACT","22","15","15","Maghambu anautangazaje malobhi ghaki kwa bhandu bhokapi, na anaulongilaje panani ja mambu ghala ghaughaweni na kughajowana. ");
INSERT INTO mpa_vpl VALUES ("AC22_16","074_22_16","ACT","22","16","16","Bho, henu ulendale kyane? Ujemaje, ubatizwaje na kugholuleka mahoku ghaku, ukalobha kwa lihina laka Bambo.’ ");
INSERT INTO mpa_vpl VALUES ("AC22_17","074_22_17","ACT","22","17","17","“Panakelawiki ku Yelusalemu, na panakabhi nobha mu Nyumba jaka Chapanga, nakaweni mabhono. ");
INSERT INTO mpa_vpl VALUES ("AC22_18","074_22_18","ACT","22","18","18","Nakumbweni Bambo, najombi akambwaghile, ‘Ujombatikaje ubhoka pa muchi ghongoni wa Yelusalemu maghambu ngabhaujetakeli ulandilu ghowibhoha panani jangu.’ ");
INSERT INTO mpa_vpl VALUES ("AC22_19","074_22_19","ACT","22","19","19","Nepani nakayangike, ‘Bambo, bhandu abhabha bhamanyi kubha nepani nde nenakabhi mbetambeta munyumba ya kuhimangani Bhayahude kwa kubhakamula na kubhalapula bhala bhabhukuhobhalela. ");
INSERT INTO mpa_vpl VALUES ("AC22_20","074_22_20","ACT","22","20","20","Na chikahi bhandu pabhunkomika Stefano, joabhohika ulandilu panani jaku, nepani namweti nakabhi panipala, nakabhi nyetangani nabhu kwa kihengu chabhu cha kunkoma, na kuilenda ingobhu ya bhala bhabhakabhi bhunkoma.’ ");
INSERT INTO mpa_vpl VALUES ("AC22_21","074_22_21","ACT","22","21","21","Bambo akambwaghile, ‘Ujendaje, maghambu nukutuma kutali kwa bhandu bhangakubha Bhayahude.’ ” ");
INSERT INTO mpa_vpl VALUES ("AC22_22","074_22_22","ACT","22","22","22","Mbaka kuhika panihapa bhandu bhakabhi bhunjowanela, nambu paakapwaghiki malobhi ghanihagha, bhakatumbwi kujamalila, bhakapwaghaje, “Umboha pundema! Unkomaje! Maghambu ngacheapalika kubha mwome!” ");
INSERT INTO mpa_vpl VALUES ("AC22_23","074_22_23","ACT","22","23","23","Bhakajamali namaa koni bhakalekalana ingobhu yabhu na kuhuwa luhombi kunani. ");
INSERT INTO mpa_vpl VALUES ("AC22_24","074_22_24","ACT","22","24","24","Nkolongwa wa manjolinjoli jola akabhohiki lilaghalakilu kubha manjolinjoli bhumpelaka Paulo munyumba ja manjolinjoli. Akalaghalaki kabheti bhundalukyaje na alapulika iboko nahuli amanya ndandi ja Bhayahude kunjobhanela. ");
INSERT INTO mpa_vpl VALUES ("AC22_25","074_22_25","ACT","22","25","25","Nambu pabhajomwi kunkonga Paulo nahuli alapulika iboko, Paulo akumpwaghi nkolongwa jumu wa manjolinjoli joakabhi panipala, “Bho, chakaka le kwinu mabhanganya kundapu iboko mundu wa ku Loma, mangani ja kupatikana na hatia?” ");
INSERT INTO mpa_vpl VALUES ("AC22_26","074_22_26","ACT","22","26","26","Linjolinjoli jola paakajowini ghanihagha akapiti kwaka nkolongwa waki na kundalukila, “Bho, upala kuhenga kyane? Kwa ndandi mundu ajoju nde wa ku Loma!” ");
INSERT INTO mpa_vpl VALUES ("AC22_27","074_22_27","ACT","22","27","27","Bhela nkolongwa wa manjolinjoli hoju akunjendi Paulo na kundalukila, “Umbwaghila chakaka, bho, wehapa le wa mundu wa ku Loma?” Paulo akamuyangike, “Ena.” ");
INSERT INTO mpa_vpl VALUES ("AC22_28","074_22_28","ACT","22","28","28","Nkolongwa wa manjolinjoli akapwaghike, “Nepani nakahemi wenei wa ku Loma kwa kulepa mbija yamahele.” Paulo akayangike, “Nambu nepani nde mundu wa ku Loma kwa kubhelakeka.” ");
INSERT INTO mpa_vpl VALUES ("AC22_29","074_22_29","ACT","22","29","29","Palapala bhandu bhabhakalibhei wichu kwa kundapu na kundalukila Paulo bhakabhokanili na kundeka. Hata nkolongwa wa manjolinjoli jola akajowipi namaa paakamanyiki kubha Paulo akabhi mundu wa ku Loma, na kubha akabhi ankongiki kwa minyololo. ");
INSERT INTO mpa_vpl VALUES ("AC22_30","074_22_30","ACT","22","30","30","Chilabhu jaki, nkolongwa wa manjolinjoli akapaliki kumanya maghambu ja kyane Bhayahude bhakuntaki Paulo, bhela akumbopwi minyololo na kubhalaghalaki bhapenganyambiku bhakolongwa papamu na bhazee bha pachengu pakolongwa bhatenda uhimanganu. Bhela akundetiki Paulo na kunjemeka palongi jabhu. ");
INSERT INTO mpa_vpl VALUES ("AC23_1","074_23_1","ACT","23","1","1","Paulo akabhalingalaki mihu ghaki bhandu bha pachengu pakolongwa na kupwagha, “Mwalongu bhangu Bhaizilaeli! Mbaka lalenu mi nakatama na luhomu lwambone palongi jaka Chapanga.” ");
INSERT INTO mpa_vpl VALUES ("AC23_2","074_23_2","ACT","23","2","2","Mpenganyambiku Nkolongwa Anania akabhalaghalaki bhala bhabhajemi pambipi na Paulo bhundapula likofi kundomo. ");
INSERT INTO mpa_vpl VALUES ("AC23_3","074_23_3","ACT","23","3","3","Bhela Paulo akumpwaghile, “Chapanga mweni anaakulapula lighanja wehapa weubhi ngati lumatu luhakau lolupakakiki chokaa! Wehapa utami panihapa kundemula kulengana na shelia, koni wamweti ngacheujengale shelia kwa kulaghalaki napulikaje?” ");
INSERT INTO mpa_vpl VALUES ("AC23_4","074_23_4","ACT","23","4","4","Bhandu bhabhajemi pambipi na Paulo bhakumpwaghile, “Bho, wehapa untondola Mpenganyambiku Nkolongwa waka Chapanga?” ");
INSERT INTO mpa_vpl VALUES ("AC23_5","074_23_5","ACT","23","5","5","Paulo akayangike, “Bhalongu bhangu, ngachenamanyi kubha jombi nde Mpenganyambiku Nkolongwa. Maghambu ilembakiki mu Malembu Mahuhu, ‘Ngawandongalela mahakau mtawala wa bhandu bhaku.’ ” ");
INSERT INTO mpa_vpl VALUES ("AC23_6","074_23_6","ACT","23","6","6","Paulo paakamanyi kubha bhandu bhakumu bhakabhi Masadukayo na bhangi bhakabhi Mafalisayo, akajamali palongi ja pachengu, “Mwalongu bhangu Bhaizilaeli! Nepani nde Mfalisayo, mwana waka Mfalisayo. Nepani bhandakila maghambu nhobhalela kubha bhabhapotile anabhayokaje.” ");
INSERT INTO mpa_vpl VALUES ("AC23_7","074_23_7","ACT","23","7","7","Paulo paakajomwi pe kulonge malobhi ghanihagha, kukapitali fujo pachilanda ja Mafalisayo na Masadukayo, na uhimanganu ukaghabhanike. ");
INSERT INTO mpa_vpl VALUES ("AC23_8","074_23_8","ACT","23","8","8","Kukapitali fujo yeniheyi maghambu Masadukayo bhapwagha bhabhawili ngabhayoki, na kubha njeta bhatumika bha kunani kwaka Chapanga, wala njeta roho, nambu Mafalisayo bhahobhalela mambu ghokapi ghatatu hagha. ");
INSERT INTO mpa_vpl VALUES ("AC23_9","074_23_9","ACT","23","9","9","Bhela kukabhi na ngomela yamahale, na bhabhola bha Shelia bha lipogha la Mafalisayo bhakajemiki na kubhoha matakilu ghabhu kwa makili, bhakapwaghaje, “Ngachetubhona uhakau wokapi kwaka mundu ajoju! Pangi roho au bhatumika bha kunani kwaka Chapanga bhatehi kulonge naku!” ");
INSERT INTO mpa_vpl VALUES ("AC23_10","074_23_10","ACT","23","10","10","Fujo payajonjukiki nakanopi, nkolongwa wa manjolinjoli akajowipi kubha bhandu bhala bhaweza kunheketa Paulo ipandi ipandi. Bhela akabhalaghalaki manjolinjoli bhajenda pachilanda ja uhimanganu ghola na kumboha Paulo kwa makili na kunkelabhuha munyumba ja manjolinjoli. ");
INSERT INTO mpa_vpl VALUES ("AC23_11","074_23_11","ACT","23","11","11","Ikilu jelajela Bambo akajemiki pambipi na Paulo na kumpwaghila, “Ulipekya mtima! Maghambu ngati moubhoki ulandilu panani jangu pani pa Yelusalemu, nde bhelabhela moukabhokiya ku Loma.” ");
INSERT INTO mpa_vpl VALUES ("AC23_12","074_23_12","ACT","23","12","12","Chilabhu jaki lukela Bhayahude bhakahengiki mpangu na kulapa kubha ngabhakuli wala kunywa chindu mbaka bhunkoma Paulo. ");
INSERT INTO mpa_vpl VALUES ("AC23_13","074_23_13","ACT","23","13","13","Bhandu bhabhahengiki mpangu ghonihoghu bhakabhi kupeta bhandu alobaini. ");
INSERT INTO mpa_vpl VALUES ("AC23_14","074_23_14","ACT","23","14","14","Bhela bhakapiti kwa bhapenganyambiku bhakolongwa na bhazee na kupwagha, “Tepani tutei kulapa ngatukuli chindu chokapi chela mbaka tunkoma hoti Paulo. ");
INSERT INTO mpa_vpl VALUES ("AC23_15","074_23_15","ACT","23","15","15","Henu mabhanganya papamu na pachengu pakolongwa ntumaje malobhi kwaka nkolongwa wa manjolinjoli andetila Paulo, mkopunganya kubha mpala kundalukaki wichu malobhi ghaki. Nambu tepani tubhi tayali kunkoma hata koni akali ngakuhika pambane.” ");
INSERT INTO mpa_vpl VALUES ("AC23_16","074_23_16","ACT","23","16","16","Nambu mwana waka ndombu waka Paulo paakajowini ghanihagha, akapiti munyumba ja manjolinjoli na kumpwaghi Paulo panani ja malobhi ghanihagha. ");
INSERT INTO mpa_vpl VALUES ("AC23_17","074_23_17","ACT","23","17","17","Bhela Paulo akundohiki jumu wa manjolonjoli na kumpwaghila, “Umpelaka nkombu ajoju kwaka nkolongwa wa manjolinjoli maghambu abhi na lilobhi la kumpwaghila.” ");
INSERT INTO mpa_vpl VALUES ("AC23_18","074_23_18","ACT","23","18","18","Linjolinjoli jola akapiti naku kwaka nkolongwa wa manjolinjoli na kumpwaghila, “Mkongeka Paulo akanohiki na kunyopa nundeta nkombu jonjoni kwaku, maghambu abhi na lilobhi leapala kukupwaghila.” ");
INSERT INTO mpa_vpl VALUES ("AC23_19","074_23_19","ACT","23","19","19","Nkolongwa wa manjolinjoli hoju akunkamwi chiwoku nkombu jola na kujenda naku punkeghi na kundalukila, “Bho, upala kumbwaghi kyane?” ");
INSERT INTO mpa_vpl VALUES ("AC23_20","074_23_20","ACT","23","20","20","Nkombu jola akapwaghike, “Bhayahude bhajetangani kukujopa chilabhu undeta Paulo Pachengu Pakolongwa, bhakakopunganya ngati bhapala kulalukaki wichu malobhi ghaki. ");
INSERT INTO mpa_vpl VALUES ("AC23_21","074_23_21","ACT","23","21","21","Nambu wehapa ngawijetakela malobhu ghabhu, maghambu bhabhi bhandu kupeta alobaine bhabhanyepale kuntukalila. Bhandu bhanihabha bhalapiki kubha ngabhakuli wala kunywa mbaka bhunkoma hoti Paulo. Na sajenu bhabhi tayali bhakalendalya kujowana anaulongila kyane.” ");
INSERT INTO mpa_vpl VALUES ("AC23_22","074_23_22","ACT","23","22","22","Nkolongwa wa manjolinjoli jola akumpwaghi nkombu jola, “Ngawampwaghi mundu jokapi jola kubha umbwaghili mambu ghanihagha.” Na panihapa akundekiki nkombu jola ajendaje. ");
INSERT INTO mpa_vpl VALUES ("AC23_23","074_23_23","ACT","23","23","23","Bhela nkolongwa wa manjolinjoli akabhalohiki manjolinjoli bhabheli na kubhapwaghila, “Mubhabheka wichu manjolinjoli mia mbili, na manjolinjoli bhakwela falasi sabini, na manjolinjoli bhahoma mikoha mia mbili kwa kujenda ku Kaisalia saa tatu ja ikilu. ");
INSERT INTO mpa_vpl VALUES ("AC23_24","074_23_24","ACT","23","24","24","Mbekaje wichu kabheti falasi yengi kwa kuntotola Paulo nahuli akahika lukwale kwaka mtawala Feliki.” ");
INSERT INTO mpa_vpl VALUES ("AC23_25","074_23_25","ACT","23","25","25","Nkolongwa hoju akalembiki baluwa jejipwagha ana: ");
INSERT INTO mpa_vpl VALUES ("AC23_26","074_23_26","ACT","23","26","26","“Nepani Klaudio Lisia, nukulembe wehapa wa mtawala Feliki, ujopalya ulamukilu wangu. ");
INSERT INTO mpa_vpl VALUES ("AC23_27","074_23_27","ACT","23","27","27","Bhayahude bhakunkamwi mundu ajoju na kupala kunkoma. Na nepani panajowini kubha jombi nde Mloma, nakapiti konihoku na lipogha la manjolinjoli na kunkengalela. ");
INSERT INTO mpa_vpl VALUES ("AC23_28","074_23_28","ACT","23","28","28","Kwa ndandi nakapaliki kumanya ndandi ja Bhayahude kuntakila, nakundetiki palongi ja pachengu jabhu pakolongwa. ");
INSERT INTO mpa_vpl VALUES ("AC23_29","074_23_29","ACT","23","29","29","Nakaweni kubha matakilu ghene ghakabhi panani ja malalukilu gha shelia yabhu, nambu ngacheahengiki lihakau lokapi lela lelumpalika kukomakeka wala kukongeka. ");
INSERT INTO mpa_vpl VALUES ("AC23_30","074_23_30","ACT","23","30","30","Panajowini kubha Bhayahude bhanyepale kuntendela uhakau mundu jonihoju, mala punkamu nakaamwi kundeta kwaku. Nabhalaghalaki bhabhuntakila bhaleta matakilu ghabhu kwaku wehapa.” ");
INSERT INTO mpa_vpl VALUES ("AC23_31","074_23_31","ACT","23","31","31","Bhela manjolinjoli bhala bhakahengiki ngati mobhapwaghakike. Bhakuntoliki Paulo na ikilu jelajela bhakumpeliki mbaka ku Antipatili. ");
INSERT INTO mpa_vpl VALUES ("AC23_32","074_23_32","ACT","23","32","32","Chilabhu jaki manjolinjoli bhabhajendika pamagholu bhakakelawiki kunyumba ja manjolinjoli, na kubhaleka manjolinjoli bhakwela falasi bhajendalya papamu na Paulo. ");
INSERT INTO mpa_vpl VALUES ("AC23_33","074_23_33","ACT","23","33","33","Nabhombi pabhahiki ku Kaisalia, bhakumpeki mtawala Feliki baluwa jela na kundeta Paulo palongi jaki. ");
INSERT INTO mpa_vpl VALUES ("AC23_34","074_23_34","ACT","23","34","34","Feliki akasomiki baluwa jela na kundaluki Paulo ahumi mkoa bhole. Paakajowini kubha jombi mundu wa ku mkoa wa ku Kilikia, ");
INSERT INTO mpa_vpl VALUES ("AC23_35","074_23_35","ACT","23","35","35","akumpwaghile, “Nakujowanya wehapa pala pabhihikaje bhabhukutakile.” Bhela akalaghalaki Paulo alendakika munyumba jaka Helode. ");
INSERT INTO mpa_vpl VALUES ("AC24_1","074_24_1","ACT","24","1","1","Paghapetiki machobha nhwanu, Mpenganyambiku Nkolongwa Anania, akapiti ku Kaisalia papamu na bhazee bhakumu bha bhandu na mundu joayimanyi shelia joalowakika Tetulo. Nabhombi bhakahiki kwaka mtawala Feliki na kundandi matakilu panani jaka Paulo. ");
INSERT INTO mpa_vpl VALUES ("AC24_2","074_24_2","ACT","24","2","2","Pabhakundohiki Paulo, Tetulo akatumbwi kuntakila, akapwaghaje, “Unkolongwa Feliki! Kwa mbulau ja kujemalela kwaku tupatiki lukwali lwa chakaka. Na kwa kujemalela kwaku uletiki mang'anambuku ghamaheli ghamboni kwa ndandi ja bhandu bha inchi jenjenu. ");
INSERT INTO mpa_vpl VALUES ("AC24_3","074_24_3","ACT","24","3","3","Mtawala Feliki, tulijopalela lijambu lendenu kila chikahi na kila pandu, na machobha ghokapi tukuchengu namaa wehapa. ");
INSERT INTO mpa_vpl VALUES ("AC24_4","074_24_4","ACT","24","4","4","Nambu maghambu ngachembala kuhowa chikahi chamaheli, nukujopa ujowanya kwa wamboni waku malobhi ghatwilongilaje kwa ujipi. ");
INSERT INTO mpa_vpl VALUES ("AC24_5","074_24_5","ACT","24","5","5","Tumanyiki kubha mundu ajoju muhakau namaa, atumbuli fujo kwa Bhayahude bhokapi bha pundema, najombi nde chiongozi wa lipogha la Bhanazaleti. ");
INSERT INTO mpa_vpl VALUES ("AC24_6","074_24_6","ACT","24","6","6","Kabheti akalengiki kujeghe uhakau Nyumba jaka Chapanga, ngajikuba jihuhu na tepani tukunkamwile. Bhela tukapaliki kuntemula kwa shelia jitu. ");
INSERT INTO mpa_vpl VALUES ("AC24_7","074_24_7","ACT","24","7","7","Nambu Lisia, nkolongwa wa manjolinjoli akahikiki na kumboha pachilanda jitu kwa makili, ");
INSERT INTO mpa_vpl VALUES ("AC24_8","074_24_8","ACT","24","8","8","bhela akabhalaghalaki bhala bhabhuntakila bhahika kwaku. Ngati anaundaluki wamwete, anauweza kumanya mambu ghanihagha ghokapi ghatuntakila.” ");
INSERT INTO mpa_vpl VALUES ("AC24_9","074_24_9","ACT","24","9","9","Bhayahude nabhombi bhakuntakile, bhakapwaghaje kubha mambu ghanihagha ghokapi nde gha chakaka. ");
INSERT INTO mpa_vpl VALUES ("AC24_10","074_24_10","ACT","24","10","10","Bhela nkolongwa wa mkoa Feliki akumpongi chiwoku chaki Paulo nahuli alongilaje. Paulo akapwaghike, “Manyi kubha wehapa ubhi wa mtemula wa inchi jenjenu kwa chikahi chilachu. Henu nilikengalela namwete palongi jaku kwa mtima wa chiheku. ");
INSERT INTO mpa_vpl VALUES ("AC24_11","074_24_11","ACT","24","11","11","Uweza kumanya wamwete, ngacheghapetiki machobha komi na ghabhele kutumbula panakweliki kujenda ku Yelusalemu kwa kunjojabhe Chapanga. ");
INSERT INTO mpa_vpl VALUES ("AC24_12","074_24_12","ACT","24","12","12","Bhandu abhabha ngachebhanhimani nakalochana na mundu jokapi mu Nyumba jaka Chapanga, wala nakabhachochakya bhandu kuhenga fujo munyumba ja kuhimangani Bhayahude. ");
INSERT INTO mpa_vpl VALUES ("AC24_13","074_24_13","ACT","24","13","13","Wala ngabhawezi kulongela malobhi ghabhandaki sajenu kubha nde gha chakaka. ");
INSERT INTO mpa_vpl VALUES ("AC24_14","074_24_14","ACT","24","14","14","Nambu nepani nyetakela palongi jaku kubha nuntumakila Chapanga wa akahokolu bhangu na kujengale Indela jela jebhajikema bhombi chama cha upuhi. Nepani nhobhalela mambu ghokapi ghaghalembakiki mu Shelia na mwitabu ya bhalota bhaka Chapanga. ");
INSERT INTO mpa_vpl VALUES ("AC24_15","074_24_15","ACT","24","15","15","Nhobhalela kuhuma kwaka Chapanga, ngati bhombi mobhahobhalela, kubha anakubya kuhyoka kwa bhabhapotile, bhokapi bhambone na bhahakau anabhahyokaje. ");
INSERT INTO mpa_vpl VALUES ("AC24_16","074_24_16","ACT","24","16","16","Bhela ngangamala machobha ghokapi kutama wichu na kubha na zamili jangakubha na hatia palongi jaka Chapanga na palongi ja bhandu. ");
INSERT INTO mpa_vpl VALUES ("AC24_17","074_24_17","ACT","24","17","17","“Panakatami kwa hyaka yamaheli kutali na muchi wa ku Yelusalemu, nakapiti konihoku nahuli kubhapelake bhandu bhangu nhupu na kubhoha nyambiku kwaka Chapanga. ");
INSERT INTO mpa_vpl VALUES ("AC24_18","074_24_18","ACT","24","18","18","Chikahi panakabhi nhenga ghanihagha panihapa nde pabhanhimanya mu Nyumba jaka Chapanga, panakabhi nyomwi kuhenga uwangalalu wa kuligholola. Ngachekwabhi na lipogha la bhandu wala fujo. Nambu kukabhi na Bhayahude bhakumu kuhuma ku Asia bhabhakabhi panipala, ");
INSERT INTO mpa_vpl VALUES ("AC24_19","074_24_19","ACT","24","19","19","bhanihabha nde bhabhapalika kuhika palongi jaku na kundakila ngati anabhabhi na lilobhi lokapi lela panani jangu. ");
INSERT INTO mpa_vpl VALUES ("AC24_20","074_24_20","ACT","24","20","20","Au ubhaleka bhandu abhabha, bhabhabhi pambani bhapwagha lihakau langu lebhamweni nalu pabhakanyemiki palongi ja pachengo jabhu pakolongwa, ");
INSERT INTO mpa_vpl VALUES ("AC24_21","074_24_21","ACT","24","21","21","nambu lilobhi limu pe lenapwaghiki kwa kujamalila panakabhi nyemi palongi jabhu nde ale, ‘Ndemulika lalenu maghambu nhobhalela kubha bhabhapotile anabhayokaje.’ ” ");
INSERT INTO mpa_vpl VALUES ("AC24_22","074_24_22","ACT","24","22","22","Bhela mtawala Feliki, joakabhi amanya wichu mambu gha Indela jaka Bambo, akalaghalaki malobhi ghanihagha ghakelabhukyaje, akapwaghaje, “Anamohaje utemulu wa lighambu lenu chikahi nkolongwa Lisia paanahikaje.” ");
INSERT INTO mpa_vpl VALUES ("AC24_23","074_24_23","ACT","24","23","23","Bhela akundaghalaki nkolongwa wa manjolinjoli kubha bhundenda Paulo, koni bhakundekila kulijeka kuchokopi, na ngabhahibhali bhakochi bhaki kunjangatila. ");
INSERT INTO mpa_vpl VALUES ("AC24_24","074_24_24","ACT","24","24","24","Paghapetiki machobha machokopi, mtawala Feliki akahiki papamu na nkowanu waki Dilisila, joakabhi Myahude. Akalaghalaki bhundoha Paulo, najombi akunjowani akalongila panani ja kunhobhalela Yesu Kristo. ");
INSERT INTO mpa_vpl VALUES ("AC24_25","074_24_25","ACT","24","25","25","Nambu chikahi Paulo patumbula kutangaza panani ja wambone, kubha na ntima wa kulihibhalakila na utemulu ghouhika, mtawala Feliki akajowipi na kumpwaghila, “Sajenu uweza kujenda, ananukuloha kabhete panipata chikahi.” ");
INSERT INTO mpa_vpl VALUES ("AC24_26","074_24_26","ACT","24","26","26","Papamu na ghanihagha aholakya kubha Paulo anaampekya ngolukelu, kwa ndandi jeniheji akabhi andoha mala pamahele na kulonge naku. ");
INSERT INTO mpa_vpl VALUES ("AC24_27","074_24_27","ACT","24","27","27","Payapetiki hyaka ibheli, Pokio Festo akatoliki pandu paka mtawala Feliki, na kubha nkolongwa wa mkoa. Nambu kwa kubha Feliki akapaliki kubhahemakela Bhayahude, akundehi Paulo muligeleza. ");
INSERT INTO mpa_vpl VALUES ("AC25_1","074_25_1","ACT","25","1","1","Paghapetiki machobha ghatatu akahiki ku mkoa, Festo akabhokiki ku Kaisalia na kujenda ku Yelusalemu. ");
INSERT INTO mpa_vpl VALUES ("AC25_2","074_25_2","ACT","25","2","2","Konikola bhapenganyambiku bhakolongwa na ihongozi bha Bhayahude bhakuntaki Paulo palongi jaki. Bhakundobhiki Festo, ");
INSERT INTO mpa_vpl VALUES ("AC25_3","074_25_3","ACT","25","3","3","abhahengila umboni kwa kubhalete Paulo ku Yelusalemu, maghambu bhakabhi bhatenda mpangu wa kunkoma mwindela. ");
INSERT INTO mpa_vpl VALUES ("AC25_4","074_25_4","ACT","25","4","4","Festo akayangike, “Paulo alendakeka ku Kaisalia, na nepani namwete ananyendaje konihoku henu kateki. ");
INSERT INTO mpa_vpl VALUES ("AC25_5","074_25_5","ACT","25","5","5","Bhela ihongozi bhinu bhajendaje konihoku papamu na nepani ku Kaisalia bhakuntakila konihoku, ngati anaahengiki uhakau wokapi ghola.” ");
INSERT INTO mpa_vpl VALUES ("AC25_6","074_25_6","ACT","25","6","6","Paakatami nabhu kwa machobha nane au komi, akaheli kujenda ku Kaisalia. Chilabhu jaki akapiti pa chitehu cha utemulu na kulaghalaki bhundeta Paulo. ");
INSERT INTO mpa_vpl VALUES ("AC25_7","074_25_7","ACT","25","7","7","Paulo paakahikiki, Bhayahude bhabhahiki kuhuma ku Yelusalemu bhakamuyongalwiti na kubhoha matakilu ghaghatopiki panani jaki, ambaghu ngachebhaweziki kulangiha uchakaka waki. ");
INSERT INTO mpa_vpl VALUES ("AC25_8","074_25_8","ACT","25","8","8","Nambu Paulo akalikengali kwa kupwagha, “Nepani ngachenatehi lihakau lokapi lela panani ja Shelia ja Bhayahude, na panani ja Nyumba jaka Chapanga, wala panani jaka Kaisali.” ");
INSERT INTO mpa_vpl VALUES ("AC25_9","074_25_9","ACT","25","9","9","Nambu Festo akapala kulihemakela kwa Bhayahude, akundaluki Paulo, “Bho, upala le kujenda ku Yelusalemu na konihoku ukatemulika palongi jangu kwa matakilu ghangane?” ");
INSERT INTO mpa_vpl VALUES ("AC25_10","074_25_10","ACT","25","10","10","Paulo akayangike, “Nyema pambani palongi ja chitehu cha utemulu chaka nkolongwa Kaisali, na panipani nde pambalika kutemulika. Ngachenabhahoki Bhayahude kwa lilobhi lokapi lela, ngati wehapa moumanyi wichu. ");
INSERT INTO mpa_vpl VALUES ("AC25_11","074_25_11","ACT","25","11","11","Bhela ngati nepani ndehi kuhokeha au ndehi lilobhi lelimbalika kupotela, ngachengana kupotela. Nambu ngati njeta uchakaka wokapi mu matakilu ghabhu panani jangu, nga mundu joaweza kumbeleka kwabho. Nyopa nakatemuliwaje na Kaisali.” ");
INSERT INTO mpa_vpl VALUES ("AC25_12","074_25_12","ACT","25","12","12","Bhela Festo paakajomwi kulongela na bhandu bha pachengo, akayangike, “Bho, upala kujenda kutemuliwa na Kaisali? Henu anaujenda kwaka Kaisali.” ");
INSERT INTO mpa_vpl VALUES ("AC25_13","074_25_13","ACT","25","13","13","Paghapetiki machobha machokopi, nkolongwa Agilipa na ndombu waki Belenike bhakahiki ku Kaisalia nahuli kundamuki Festo. ");
INSERT INTO mpa_vpl VALUES ("AC25_14","074_25_14","ACT","25","14","14","Pabhakabhi konikola kwa machobha ghamahele, Festo akundandi nkolongwa Agilipa malobhi ghaka Paulo. Akumpwaghi, “Pambani abhi mundu jumu joakundekiki Feliki muligeleza. ");
INSERT INTO mpa_vpl VALUES ("AC25_15","074_25_15","ACT","25","15","15","Panapiti ku Yelusa