﻿USE sofia;
DROP TABLE IF EXISTS sofia.moz_vpl;
CREATE TABLE moz_vpl (
  verseID VARCHAR(16) NOT NULL PRIMARY KEY,
  canon_order VARCHAR(12) NOT NULL,
  book VARCHAR(3) NOT NULL,
  chapter VARCHAR(3) NOT NULL,
  startVerse VARCHAR(3) NOT NULL,
  endVerse VARCHAR(3) NOT NULL,
  verseText TEXT CHARACTER SET UTF8 NOT NULL) ENGINE=MyISAM;
LOCK TABLES moz_vpl WRITE;
INSERT INTO moz_vpl VALUES ("MT1_1","070_1_1","MAT","1","1","1","Kun ollo, eŋ sumɓiyagi kʼita moŋgiɗagi kʼIsa Almasi, yoŋ ti biza bumɓu mozigo Dawut, wo yode Dawut batum ti biza bumɓu kʼIbirayim. ");
INSERT INTO moz_vpl VALUES ("MT1_2","070_1_2","MAT","1","2","2","Ibirayim yʼa tʼehe Isaaka, Isaaka yʼa tʼehe Yakup, Yakup yʼa tʼehe Ziida kane ti zemɓadí. ");
INSERT INTO moz_vpl VALUES ("MT1_3","070_1_3","MAT","1","3","3","Ziida yʼa tʼehe Pares ti Zara, kane geŋ meedaŋ Tamar. Pares yʼa tʼehe Eziroŋ, Eziroŋ yʼa tʼehe Araŋ. ");
INSERT INTO moz_vpl VALUES ("MT1_4","070_1_4","MAT","1","4","4","Araŋ yʼa tʼehe Aminadap, Aminadap yʼa tʼehe Nasoŋ, Nasoŋ yʼa tʼehe Salmo. ");
INSERT INTO moz_vpl VALUES ("MT1_5","070_1_5","MAT","1","5","5","Salmo yʼa tʼehe Booz, Booz meedí Raahap. Booz yʼa tʼehe Ibet, Ibet meedí Riit. Ibet yʼa tʼehe Zeese, ");
INSERT INTO moz_vpl VALUES ("MT1_6","070_1_6","MAT","1","6","6","wo Zeese yʼa tʼehe mozigo Dawut. Mozigo Dawut yʼa tʼehe Salamoŋ, Salamoŋ meedí ere ki Iri. ");
INSERT INTO moz_vpl VALUES ("MT1_7","070_1_7","MAT","1","7","7","Salamoŋ yʼa tʼehe Robowan, Robowan yʼa tʼehe Abbiya, Abbiya yʼa tʼehe Aza. ");
INSERT INTO moz_vpl VALUES ("MT1_8","070_1_8","MAT","1","8","8","Aza yʼa tʼehe Zozapat, Zozapat yʼa tʼehe Zoram, Zoram yʼa tʼehe Oziyas. ");
INSERT INTO moz_vpl VALUES ("MT1_9","070_1_9","MAT","1","9","9","Oziyas yʼa tʼehe Yotam, Yotam yʼa tʼehe Akaz, Akaz yʼa tʼehe Ezekiyas. ");
INSERT INTO moz_vpl VALUES ("MT1_10","070_1_10","MAT","1","10","10","Ezekiyas yʼa tʼehe Manase, Manase yʼa tʼehe Amoŋ, Amoŋ yʼa tʼehe Zoziyas. ");
INSERT INTO moz_vpl VALUES ("MT1_11","070_1_11","MAT","1","11","11","Zoziyas yʼa tʼehe Yekoniyas ti zemɓadí, a ozzine geŋ ɗoŋ kʼIzirayel an tiʼn ziki ɓuliko ki siiɗo Babiloon. ");
INSERT INTO moz_vpl VALUES ("MT1_12","070_1_12","MAT","1","12","12","Aame ɗoŋ kʼIzirayel an tiʼn ziki ɓuliko ki siiɗo Babiloon maŋ, Yekoniyas yʼa tʼehe Salatiyel, Salatiyel yʼa tʼehe Zorobabel. ");
INSERT INTO moz_vpl VALUES ("MT1_13","070_1_13","MAT","1","13","13","Zorobabel yʼa tʼehe Abbiyut, Abbiyut yʼa tʼehe Eliyakim, Eliyakim yʼa tʼehe Azor. ");
INSERT INTO moz_vpl VALUES ("MT1_14","070_1_14","MAT","1","14","14","Azor yʼa tʼehe Sadok, Sadok yʼa tʼehe Asim, Asim yʼa tʼehe Eliyut. ");
INSERT INTO moz_vpl VALUES ("MT1_15","070_1_15","MAT","1","15","15","Eliyut yʼa tʼehe Eliyazar, Eliyazar yʼa tʼehe Matan, Matan yʼa tʼehe Yakup. ");
INSERT INTO moz_vpl VALUES ("MT1_16","070_1_16","MAT","1","16","16","Yakup yʼa tʼehe Yusup kule ki Mariyam, tode ere tʼa ehe Isa, yoŋ an di yʼ waaku Almasi Raa yi biire. ");
INSERT INTO moz_vpl VALUES ("MT1_17","070_1_17","MAT","1","17","17","Iŋkino maŋ an di gize ita moŋgiɗagi koomat makumu piɗe, iise ti Ibirayim bini Dawut. Saŋ ita moŋgiɗagi koomat makumu piɗe, iise ti Dawut bini sokiyo ɗoŋ kʼIzirayel ki siiɗo Babiloon. Saŋ ita moŋgiɗagi koomat makumu piɗe, iise ti sokiyadaŋ ki siiɗo Babiloon bini ehiyo kʼAlmasi Raa yi biire. ");
INSERT INTO moz_vpl VALUES ("MT1_18","070_1_18","MAT","1","18","18","Kun ollo tʼurzi tuuku an dʼehe Isa Almasi me. Mariyam ere tʼa yi tʼeha gette todʼ tʼibire Yusup. Wo ki poone an di koona ɓoy ɓotto geŋ, ti-ti ziiɗa mahuwe ti toogo kʼUnde Kamilen̰ ki Raa. ");
INSERT INTO moz_vpl VALUES ("MT1_19","070_1_19","MAT","1","19","19","Yoŋ Yusup kule kʼebiratú geŋ yoŋ wede ki diine, yi ki dehu yʼa ki ti waare ye, iŋkino maŋ yʼa dihe yʼa tʼarga ti tuddutú kaŋ mookiko. ");
INSERT INTO moz_vpl VALUES ("MT1_20","070_1_20","MAT","1","20","20","Aame yʼilke iŋkino maŋ, maaleeka ki Galmeega Raa yʼa yʼuuna kaŋ suniye wo yi di ruute, yʼede: «Kʼollo, Yusup kee wede ti biza bumɓu Dawut, kee kʼorgiɗe ye, ki ti sooɗo ere kʼebirayá Mariyam te, kono ulo wede ti tʼeha geŋ yoŋ yʼettiyo tʼurzi toogo kʼUnde Kamilen̰. ");
INSERT INTO moz_vpl VALUES ("MT1_21","070_1_21","MAT","1","21","21","Todʼ tʼa tʼeha ulo wo kʼa yi waaka sundí Isa, kono yoŋ geŋ yʼa utta ɗoŋzí ti olɗikadaŋ.» ");
INSERT INTO moz_vpl VALUES ("MT1_22","070_1_22","MAT","1","22","22","Sulɗi pay geŋ a iina kono a-tʼette a ono ɗoŋ Galmeega Raa yi ruute ti kaaga ti bize nebi, yʼede: ");
INSERT INTO moz_vpl VALUES ("MT1_23","070_1_23","MAT","1","23","23","«Kun ollo, uto koŋso tʼa seeɗa mahuwe wo tʼa tʼeha ulo, an di yʼ waaka sundí Emanuwel.» Suma gette i-kaza «Raa ti kine». ");
INSERT INTO moz_vpl VALUES ("MT1_24","070_1_24","MAT","1","24","24","Aame Yusup yi tʼinne maŋ, yʼa tʼize munɗa wede maaleeka ki Galmeega Raa yi-ruute yʼaase, yʼa ti ziiɗa eddí Mariyam te. ");
INSERT INTO moz_vpl VALUES ("MT1_25","070_1_25","MAT","1","25","25","Wo yi kʼiide tuddutú ye bini tʼa tʼehe ulo wede Yusup yʼa yi wiike sundí Isa. ");
INSERT INTO moz_vpl VALUES ("MT2_1","070_2_1","MAT","2","1","1","Isa an yʼehe a Betilehem geeger ki siiɗo Ziide, aame geŋ Erod yoŋ mozigo. Isa an ti yʼehe maŋ, ɗoŋ suuniyo molɗali an dʼiido ti kese peeɗo ge-koliyo, an dʼiiney a geeger Zeruzalem ");
INSERT INTO moz_vpl VALUES ("MT2_2","070_2_2","MAT","2","2","2","wo an tunde ɗuwo, anʼde: «A too me mozigo Yawudiyagi wede an ehe me? Kaye ay wullo moolayí ti kese peeɗo ge-koliyo wo ay iido ay i dʼottile.» ");
INSERT INTO moz_vpl VALUES ("MT2_3","070_2_3","MAT","2","3","3","Aame mozigo Erod yʼilliga rabila gettiyo maŋ, yʼa iddira ti ɗoŋ geeger Zeruzalem pay a itadí. ");
INSERT INTO moz_vpl VALUES ("MT2_4","070_2_4","MAT","2","4","4","Iŋkino maŋ yʼa-tusse kane deero ɗoŋ seɗeke ti ɗoŋ suuniyo kʼoogoro ɗoŋ adda siiɗo gette pay, wo yʼanni tunde, yʼede: «A too me Almasi Raa yi biire, an di yʼ tʼehey me?» ");
INSERT INTO moz_vpl VALUES ("MT2_5","070_2_5","MAT","2","5","5","Kane an i di ruute, anʼde: «A Betilehem siiɗo Ziide, kono en̰n̰o ono ɗoŋ nebi yi riiŋe ti kaaga adda mattup ki Raa, yʼede: ");
INSERT INTO moz_vpl VALUES ("MT2_6","070_2_6","MAT","2","6","6","“Wo kune ɗoŋ ki geeger Betilehem siiɗo Ziide, ɗerec geegirguŋ todʼte n̰eŋko a ki jiire ye ti diine geegiryagi ki Ziide me”, kono ti tode i dʼaɗɗa mozigo yʼa dokka ɗoŋzó Izirayel.» ");
INSERT INTO moz_vpl VALUES ("MT2_7","070_2_7","MAT","2","7","7","Iŋkino maŋ mozigo Erod yʼanni wiike ɗoŋ suuniyo molɗali geŋ kaŋ ombiɗe, kono yʼa seɗɗe mekkʼono, yʼede: «Tʼume muno moole yʼuɗɗo, kun yi wulle me?» ");
INSERT INTO moz_vpl VALUES ("MT2_8","070_2_8","MAT","2","8","8","Maŋ yʼan diʼn igibe ki Betilehem, yʼan di ruute, yʼede: «Kunʼdo, uloʼŋ kun yi dehiti ki koɗuwo, wo aame kun yʼuuno maŋ, kun o dʼagibi kono nuŋ toŋ maŋ nʼa etta ni dʼottiley kay.» ");
INSERT INTO moz_vpl VALUES ("MT2_9","070_2_9","MAT","2","9","9","Aame mozigo Erod yʼan ti ruutite iŋkino maŋ, ɗoŋ suuniyo molɗali an dʼiŋgile, wo geŋ an di yʼ wulle sey moole wede an wullo ti kese peeɗo ge-koliyo geŋ me. Yoŋ ki ɗaanadaŋ yi dʼettiyo dʼettiyo bini yʼiiney tʼekki ɓoy wede ulo adda maŋ, yʼa tʼîhira. ");
INSERT INTO moz_vpl VALUES ("MT2_10","070_2_10","MAT","2","10","10","A wolliso ki moole wede an wullo geŋ, addaŋ a ûune tʼuŋsuwo ɓaadaŋ. ");
INSERT INTO moz_vpl VALUES ("MT2_11","070_2_11","MAT","2","11","11","Kane an iiney maŋ, an tʼiide kʼadda ɓoy an dʼuuney ulo ti meedí Mariyam wo an di dikke an tʼuttile a ɗaana kʼulo. Saŋ maŋ sandupiyagaŋ an tʼihinte, an tʼuɗɗo sulɗi ɗoŋ an ziko, aakede: dap, sulɗi koddiyo eeɗiyadaŋ uŋse wo dunnu sundí mirr zooyayí oon̰e geŋ, an i dʼele a ulo. ");
INSERT INTO moz_vpl VALUES ("MT2_12","070_2_12","MAT","2","12","12","Saŋ maŋ Raa yʼan di tuuke kuudaŋ kaŋ suniye, yʼede: «Kun kima ye ki tukkʼ Erod me.» Iŋkino maŋ kane an di-gime siiɗadaŋ tʼurzi doolo. ");
INSERT INTO moz_vpl VALUES ("MT2_13","070_2_13","MAT","2","13","13","Aame ɗoŋ suuniyo molɗali an iŋgile maŋ, maaleeka ki Galmeega Raa yʼa yʼuuney Yusup kaŋ suniye wo yi di ruute, yʼede: «Yusup kesiko ki tʼoozo, ki tʼamɓo ulo ti meedí, kun tʼombo ki siiɗo Misir. Kun di lekki bini onniyo ere nʼa di roota, kono mozigo Erod yi yʼ deha ulo ki tôwwadí.» ");
INSERT INTO moz_vpl VALUES ("MT2_14","070_2_14","MAT","2","14","14","Iŋkino maŋ a diɗɗo gettiyo batum Yusup yʼa tʼiiziga, yʼa tʼumɓe ulo ti meedí, an tʼumbe ki siiɗo Misir. ");
INSERT INTO moz_vpl VALUES ("MT2_15","070_2_15","MAT","2","15","15","A siiɗo Misir gette an di likko bini unto ki mozigo Erod, geŋ a iina kono a-tʼette a ono ɗoŋ Galmeega Raa yi ruute ti kaaga ti bize nebi, yʼede: «Ulóʼŋ nʼa ti yʼ wiiko yʼa tʼuɗɗo ti siiɗo Misir me.» ");
INSERT INTO moz_vpl VALUES ("MT2_16","070_2_16","MAT","2","16","16","Aame Erod yi zuune ɗoŋ suuniyo molɗali an ti yʼ mibilɗe maŋ, yʼa gulkuwe ɓaadaŋ. Maŋ yʼan di ruute a asigiryagi an di-tʼîde a Betilehem ti illiyagi ɗoŋ i ti ɗuule geŋ, in̰n̰i kuuli pay ɗoŋ kʼozzine sire a ɗiigo. Ozzinagi sire geŋ a-tʼîide tʼume wede ɗoŋ suuniyo molɗali an i ruute moole yʼuɗɗe. ");
INSERT INTO moz_vpl VALUES ("MT2_17","070_2_17","MAT","2","17","17","Geŋ iŋkino a iina kono a-tʼette a ono ɗoŋ Raa yi ruute ti kaaga ti bize nebi Zeremi, yʼede: ");
INSERT INTO moz_vpl VALUES ("MT2_18","070_2_18","MAT","2","18","18","«Ɗuwo an dʼilliga tarkuuse ki ɗollite môolo ɓaadaŋ a geeger ki Rama. To Rasel ti môolo kʼin̰n̰itú, wo an ti selliyo toŋ ti kʼoyyiso ye, kono in̰n̰itú an tʼinda.» ");
INSERT INTO moz_vpl VALUES ("MT2_19","070_2_19","MAT","2","19","19","Saŋ mozigo Erod yʼinda maŋ, maaleeka ki Galmeega Raa yʼa yʼuuney Yusup kaŋ suniye a siiɗo Misir, yi di ruute, ");
INSERT INTO moz_vpl VALUES ("MT2_20","070_2_20","MAT","2","20","20","yʼede: «Ki tʼoozo, ki tʼamɓo ulo ti meedí, kun di kama ki siiɗo kʼIzirayel kono ɗoŋ i dehu tôwwo kʼulo geŋ an tʼinda.» ");
INSERT INTO moz_vpl VALUES ("MT2_21","070_2_21","MAT","2","21","21","Iŋkino maŋ Yusup yʼa tʼiiziga, yʼa tʼumɓe ulo ti meedí, an di-gime ki siiɗo kʼIzirayel. ");
INSERT INTO moz_vpl VALUES ("MT2_22","070_2_22","MAT","2","22","22","Aame Yusup yʼiiney a siiɗo kʼIzirayel maŋ, yʼa illiga rabila ki mozigo wede i gili a siiɗo Ziide geŋ, yoŋ ulo ki Erod sundí Arkeleyus. Aame geŋ orgiso tʼa yi ziiɗa kʼettiyo kʼadda siiɗo Ziide me. Maŋ Raa yi di tuuke kuudí kaŋ suniye, tʼume geŋ yʼa iŋgile ki siiɗo Galile. ");
INSERT INTO moz_vpl VALUES ("MT2_23","070_2_23","MAT","2","23","23","Yʼiideʼŋ yʼa-guune a geeger sundutú Nazaret. Geŋ a iina kono a-tʼette a ono ɗoŋ Raa yi ruute ti kaaga ti bize nebiyagi, yʼede: «Yoŋ an di yʼ waaka wede ti geeger Nazaret.» ");
INSERT INTO moz_vpl VALUES ("MT3_1","070_3_1","MAT","3","1","1","Saŋ ozzinagi kʼita maŋ, Zaŋ Batis geŋ yʼa tʼiide kʼadda balɗa ki siiɗo Ziide wo yʼa iise kazita, yi dʼeesiyo: ");
INSERT INTO moz_vpl VALUES ("MT3_2","070_3_2","MAT","3","2","2","«Kun ti kama lekkiyaguŋ kono Moziko Raa tʼiina goppoŋ.» ");
INSERT INTO moz_vpl VALUES ("MT3_3","070_3_3","MAT","3","3","3","Zaŋ geŋ yoŋ wede nebi Ezayi yʼa ruute taayadí ti kaaga, yʼede: «Ɗoŋ an dʼollige golla ki wedusu yi ɗollite adda balɗa, yi dʼeesiyo: Kun i tʼokkoŋ urzi Galmeega, erkiyagí kun i tiʼn okkoŋ ki diine ɗelele.» ");
INSERT INTO moz_vpl VALUES ("MT3_4","070_3_4","MAT","3","4","4","Zaŋ geŋ kallayí yʼossiyo an indigo kʼilali ziŋzo, wo ser a tooni ki golmodo. Omɓadí gannoori ti madde. ");
INSERT INTO moz_vpl VALUES ("MT3_5","070_3_5","MAT","3","5","5","Iŋkino maŋ ɗoŋ ɓaadaŋ ti geeger Zeruzalem, ti siiɗo Ziide gette pay, wo ti siiɗo ere a biza kʼooye Zurden gette pay an dʼettiyo tukki Zaŋ. ");
INSERT INTO moz_vpl VALUES ("MT3_6","070_3_6","MAT","3","6","6","An tʼooɗibe addaŋ a urzi kʼolɗikadaŋ a ɗaana ɗuwo pay, wo yoŋ yi-tiʼn suyyiso batem adda kʼooye Zurden. ");
INSERT INTO moz_vpl VALUES ("MT3_7","070_3_7","MAT","3","7","7","Aame Zaŋ yi wulle kane Pariziyeŋ ti Saduseyeŋ ɓaadaŋ anʼtiyo tuddí kono yʼa tiʼn suyye batem maŋ, yʼan di ruute, yʼede: «Kune ɗoŋ ulpi aakede maŋkikagi! Wee wee un gize urzi wede kun tʼalɗa ti booro ki Raa ere ettiyo goppoŋ te? ");
INSERT INTO moz_vpl VALUES ("MT3_8","070_3_8","MAT","3","8","8","Iŋkino maŋ kun iso naabo ere beehiye, geŋ a kize kun ti gime lekkiyaguŋ. ");
INSERT INTO moz_vpl VALUES ("MT3_9","070_3_9","MAT","3","9","9","Wo kun roote ye adda kʼadduguŋ: “Kaye mugiyey Ibirayim me”, kono kun tʼalɗa ti booro Raa te. Wo kun ollo nʼun di rooto: Ti moŋgali eŋ miŋ, Raa yʼaane yi dʼaɗɗe ɗuwo a tʼise ita kʼin̰n̰i kʼIbirayim me. ");
INSERT INTO moz_vpl VALUES ("MT3_10","070_3_10","MAT","3","10","10","Aŋken̰n̰o booro Raa i guute goppoŋ, todʼte aa wede yi tʼumɓe ulpaasi yʼa-dokkiɗa inda ti sondayzaŋ pay: Undumu tuuku yi kʼehiyo in̰n̰i beehiye ye maŋ, an di-ɗekka an di seɗɗa adda kʼuwwo mendí. ");
INSERT INTO moz_vpl VALUES ("MT3_11","070_3_11","MAT","3","11","11","Nuŋ nʼunni suyyiso batem tʼahu kono a kize kun ti gime lekkiyaguŋ, wo ɗe wede ettiyo kʼitadó geŋ yoŋ toogo yi jiire nuŋ, wo nuŋ ni kʼîide nʼa ki tʼoɗɗipe toɓiyagí ye. Yoŋ yʼunni suyya batem tʼUnde Kamilen̰ wo ti uwwo. ");
INSERT INTO moz_vpl VALUES ("MT3_12","070_3_12","MAT","3","12","12","Wo yoŋ yʼa ɗekka booro aakede wedusu yi tʼumɓo munɗa ki solɗe a beezí, yʼa silɗa koɗuwo, in̰n̰i yi-tʼoɓa giiƴe, wo oɗɗo yʼa tʼogga mentú adda kʼuwwo ere i kʼunto ye.» ");
INSERT INTO moz_vpl VALUES ("MT3_13","070_3_13","MAT","3","13","13","Iŋkino maŋ ti siiɗo Galile Isa yʼa iide ki tukki Zaŋ a biza kʼooye Zurden kono Zaŋ yʼa ti yʼ suyye batem. ");
INSERT INTO moz_vpl VALUES ("MT3_14","070_3_14","MAT","3","14","14","Aame geŋ Zaŋ yʼa dihe yʼa-tooge, wo yi di ruute, yʼede: «Nuŋ miŋ a ni suyye batem kee, ɗe mummino kee ki dʼettiyo ki tukki nuŋ nʼa ki suyye batem me?» ");
INSERT INTO moz_vpl VALUES ("MT3_15","070_3_15","MAT","3","15","15","Wo ɗe Isa yi diʼn gime onamí, yʼede: «Aŋken̰n̰o kee kʼoyyo ki tiʼn suyyi batem, kono tʼurzi en̰n̰o kine in dʼise sulɗi ɗoŋ pay ki diine a-tʼette a naabo ere aa Raa yi dehu.» Iŋkino maŋ Zaŋ yʼa iyye yʼa ti yʼ suyye batem. ");
INSERT INTO moz_vpl VALUES ("MT3_16","070_3_16","MAT","3","16","16","Aame Isa yi ti yʼ zuyye batem wo yʼaɗɗiya tʼadda kʼahu maŋ, a kaamiki kandaane a tʼihina wo yʼa wulle Unde Raa ti ɗeegu ti kandaane aa deere tʼa di guune a tuddí. ");
INSERT INTO moz_vpl VALUES ("MT3_17","070_3_17","MAT","3","17","17","Wo ɗuwo an dʼilliga golla ettiyo ti kandaane tʼa ruute, tʼede: «Eŋ Ulo nuuno ni yʼ giyye ɓaadaŋ, ulbó uŋse ti yode me.» ");
INSERT INTO moz_vpl VALUES ("MT4_1","070_4_1","MAT","4","1","1","Saŋ maŋ Unde Raa tʼa-di tʼiide Isa kʼadda balɗa kono Meeda siitanɗani tʼa yi naame daggiya. ");
INSERT INTO moz_vpl VALUES ("MT4_2","070_4_2","MAT","4","2","2","Yʼa likke diɗɗo ada piɗe on̰n̰u ada piɗe daa kʼomɓo, maŋ mosogo tʼa yi ziiɗa. ");
INSERT INTO moz_vpl VALUES ("MT4_3","070_4_3","MAT","4","3","3","Meeda siitanɗani tʼa dʼiide sirpadí kono tʼa yi naame daggiya, wo ti di ruute, tʼede: «Aame kee Ulo Raa kotto maŋ, kʼelo urzi a moŋgali eŋ a-kime omɓo.» ");
INSERT INTO moz_vpl VALUES ("MT4_4","070_4_4","MAT","4","4","4","Wo Isa yi diʼn gime onamtú, yʼede: «Koŋ te mʼollo, ono eŋ an riiŋe ti kaaga adda mattup ki Raa, anʼde: “Lekkiyo wedusu todʼte tʼurzi kʼomɓo bizí ɗaŋŋal ye, wo tʼurzi kʼono ɗoŋ pay aɗɗiya ti bize Raa.”» ");
INSERT INTO moz_vpl VALUES ("MT4_5","070_4_5","MAT","4","5","5","Tiŋ geŋ Meeda siitanɗani tʼa-di tʼiide Zeruzalem geeger ere kamilen̰, tʼa-ti yʼ ziipe tʼekki Ɓoy Raa a ume wede awwa, ");
INSERT INTO moz_vpl VALUES ("MT4_6","070_4_6","MAT","4","6","6","wo ti di ruute, tʼede: «Aame kee Ulo Raa kotto maŋ, tʼawwa geŋ kʼolɗi kʼa zabba siiɗo, kono ono eŋ an riiŋe ti kaaga adda mattup ki Raa, anʼde: “Raa yʼan di roota maaleekiyagí kono kee, wo an gi di seeɗa beezaŋ kono kʼa tʼalɗa zoŋɗá a ki tʼoggo ekki mokkolo ye.”» ");
INSERT INTO moz_vpl VALUES ("MT4_7","070_4_7","MAT","4","7","7","Isa yi di ruute, yʼede: «Mʼollo, ono eŋ an riiŋe sey ti kaaga adda mattup ki Raa, anʼde: “Kee Galmeega Raazá ki yʼ naame ye.”» ");
INSERT INTO moz_vpl VALUES ("MT4_8","070_4_8","MAT","4","8","8","Saŋ maŋ Meeda siitanɗani tʼa-di tʼiide sey kʼekki mokkolo sohoro a jiire, wo ti di gizite moziko duniya pay ti laalatú, ");
INSERT INTO moz_vpl VALUES ("MT4_9","070_4_9","MAT","4","9","9","wo ti di ruute, tʼede: «Sulɗi eŋ nʼa di tʼela pay a kee, aame ki-dikka wo kʼo uttila maŋ.» ");
INSERT INTO moz_vpl VALUES ("MT4_10","070_4_10","MAT","4","10","10","Iŋkino maŋ Isa yi di ruute, yʼede: «Meeda siitanɗani, mi leɗɗo ti tuddó me! Mʼollo, ono eŋ an riiŋe ti kaaga adda mattup ki Raa, anʼde: “Kee kʼottilo a Galmeega Raazá, wo geŋ a yode ɗaŋŋal ki naabo me.”» ");
INSERT INTO moz_vpl VALUES ("MT4_11","070_4_11","MAT","4","11","11","Aame geŋ Meeda siitanɗani tʼa yʼiili. Saŋ maŋ maaleekiyagi an a dʼiide sirpadí wo an i di naabiya. ");
INSERT INTO moz_vpl VALUES ("MT4_12","070_4_12","MAT","4","12","12","Isa yʼilliga Zaŋ Batis an ti yʼ ziiɗa daŋgay maŋ, aame geŋ yʼa tʼiide ki siiɗo Galile. ");
INSERT INTO moz_vpl VALUES ("MT4_13","070_4_13","MAT","4","13","13","Yʼiiney maŋ yʼa ki likke ye a Nazaret me, yʼa iŋgile yʼa likke a Kapernayim, geeger ere a biza bar ki Galile adda siiɗo Zabiloŋ ti Nepitali. ");
INSERT INTO moz_vpl VALUES ("MT4_14","070_4_14","MAT","4","14","14","Geŋ a iina kono a-tʼette a ono ɗoŋ nebi Ezayi yi ruute ti kaaga, yʼede: ");
INSERT INTO moz_vpl VALUES ("MT4_15","070_4_15","MAT","4","15","15","«Kune ɗoŋ siiɗo Zabiloŋ ti Nepitali, goppoŋ ti biza bar ki Galile, ti dar kʼooye Zurden ki kese peeɗo kʼooriyo, siiɗo Galile gette, i lekkiyo kane ɗoŋ Yawudiyagi ye. ");
INSERT INTO moz_vpl VALUES ("MT4_16","070_4_16","MAT","4","16","16","Kane ɗoŋ i lekkiyo adda zimolo geŋ an wulle toore Raa. Kane ɗoŋ i lekkiyo adda kʼundiso kʼunto geŋ toore Raa yʼan da tʼan gili.» ");
INSERT INTO moz_vpl VALUES ("MT4_17","070_4_17","MAT","4","17","17","Tʼume geŋ Isa yʼa iise kazita kʼono, yi dʼeesiyo: «Kun ti kama lekkiyaguŋ kono Moziko Raa tʼiina goppoŋ.» ");
INSERT INTO moz_vpl VALUES ("MT4_18","070_4_18","MAT","4","18","18","Onniyo soo Isa yi sooru a biza bar ki Galile, maŋ yi dʼuune zemɓa sire, Simo wede an yi waaku sundí soo te Piyer, ti leemadí Andire. An kakkiya lebiɗo kʼadda bar kono kane naabadaŋ sawwiya puuni. ");
INSERT INTO moz_vpl VALUES ("MT4_19","070_4_19","MAT","4","19","19","Maŋ Isa yʼan di ruute, yʼede: «Kun ni daani, wo nuŋ nʼun diʼn isa ɗoŋ dehutu ɗuwo kono an dʼetto kʼurzizó.» ");
INSERT INTO moz_vpl VALUES ("MT4_20","070_4_20","MAT","4","20","20","A kaamiki lembiɗagaŋ an dʼiili, an di yʼ diine. ");
INSERT INTO moz_vpl VALUES ("MT4_21","070_4_21","MAT","4","21","21","Tiŋ geŋ Isa yʼa iide ki ɗaana maŋ, yi dʼuuney zemɓa sire ti doolo, Zak ti leemadí Zaŋ in̰n̰i Zebede, kane adda tooko ti meegaŋ Zebede an okkime lembiɗagaŋ. Maŋ Isa yʼa tiʼn wiike. ");
INSERT INTO moz_vpl VALUES ("MT4_22","070_4_22","MAT","4","22","22","A kaamiki, tooko ti meegaŋ an dʼiili wo kane an di yʼ diine. ");
INSERT INTO moz_vpl VALUES ("MT4_23","070_4_23","MAT","4","23","23","Saŋ maŋ Isa yi soorutu adda siiɗo Galile gette pay, yi dooyisito ɗuwo adda ɓoyɗi ɗoŋ Yawudiyagi ge dooyiso, yʼan kazita Rabila Majjaanawa ki Moziko Raa wo yʼan dʼeliyo beeko a ɗoŋ pay eeni wo a ɗoŋ pay an dʼede ita kʼeeni tuuku toŋ maŋ. ");
INSERT INTO moz_vpl VALUES ("MT4_24","070_4_24","MAT","4","24","24","A naabadí gette, Isa sundí tʼa iile adda siiɗo Siiri gette pay, iŋkino maŋ ɗuwo an i-dʼettiyo ti kane ɗoŋ pay an dʼede ita kʼeeni tuuku toŋ maŋ wo ti ɗoŋ eeni yi tiʼn dabirsa ɓaadaŋ, aakede: ɗoŋ an dʼede siitanɗani a eedaŋ, ti ɗoŋ an dʼede amputput wo ɗoŋ ruŋguyuŋ. Geŋ Isa yʼan dʼeliyo beeko. ");
INSERT INTO moz_vpl VALUES ("MT4_25","070_4_25","MAT","4","25","25","Ɗoŋ duuru ɓaadaŋ an di yʼ daaniya, wo kane geŋ an iido ti siiɗo Galile, ti siiɗo sundutú Geegiryagi Koomat, ti geeger Zeruzalem, ti siiɗo Ziide wo ti dar kʼooye Zurden ki kese peeɗo ge-koliyo. ");
INSERT INTO moz_vpl VALUES ("MT5_1","070_5_1","MAT","5","1","1","Aame Isa yi wulle ɗoŋ duuru ɓaadaŋ gen̰n̰o maŋ, yʼa di gili eego kesse yʼa-guune. Kane sanalliyagí an a-tʼiide kʼume yode, ");
INSERT INTO moz_vpl VALUES ("MT5_2","070_5_2","MAT","5","2","2","maŋ yʼa tʼihina bizí, yʼan diʼn iise dooyiso, yʼede: ");
INSERT INTO moz_vpl VALUES ("MT5_3","070_5_3","MAT","5","3","3","«Uŋsuwo a kane ɗoŋ i ki tʼîide an ki tʼamɓe eedaŋ a ɗaana Raa ye, kono Moziko Raa todʼte ki kane. ");
INSERT INTO moz_vpl VALUES ("MT5_4","070_5_4","MAT","5","4","4","Uŋsuwo a kane ɗoŋ i môolo, kono kane geŋ Raa yʼa tiʼn sella. ");
INSERT INTO moz_vpl VALUES ("MT5_5","070_5_5","MAT","5","5","5","Uŋsuwo a kane ɗoŋ biza kʼulbaŋ tasse, kono kane geŋ an tʼooney siiɗo ere Raa yi ruute yʼan tʼeley. ");
INSERT INTO moz_vpl VALUES ("MT5_6","070_5_6","MAT","5","6","6","Uŋsuwo a kane ɗoŋ mosogo wo ôrme a urzi lekkiyo ere ki diine aa Raa yi dehu, kono kane geŋ mosigadaŋ ti ôrmayaŋ Raa yʼan tiʼn tʼîda. ");
INSERT INTO moz_vpl VALUES ("MT5_7","070_5_7","MAT","5","7","7","Uŋsuwo a kane ɗoŋ an isiyo adde koɗuwo a ɗuwo, kono kane geŋ Raa yʼan dʼisa adde koɗuwo kay. ");
INSERT INTO moz_vpl VALUES ("MT5_8","070_5_8","MAT","5","8","8","Uŋsuwo a kane ɗoŋ ele tuddaŋ pay a Raa, kono kane geŋ Raa an di yʼ wolley. ");
INSERT INTO moz_vpl VALUES ("MT5_9","070_5_9","MAT","5","9","9","Uŋsuwo a kane ɗoŋ i dehu urzi toose yʼa koone a diine ɗuwo, kono kane geŋ Raa yʼanni waaka in̰n̰izí. ");
INSERT INTO moz_vpl VALUES ("MT5_10","070_5_10","MAT","5","10","10","Uŋsuwo a kane ɗoŋ an i dabirsa kono an isiyo munɗa wede ki diine aa Raa yi dehu, kono Moziko Raa todʼte ki kane. ");
INSERT INTO moz_vpl VALUES ("MT5_11","070_5_11","MAT","5","11","11","Uŋsuwo a kune aame ɗuwo an unni kalɗita, an unni dabirsa wo an lohito ita kʼono ɗoŋ pay ulpi a egguŋ, kono kun ziipe adduguŋ a nuŋ. ");
INSERT INTO moz_vpl VALUES ("MT5_12","070_5_12","MAT","5","12","12","Kune ulbuguŋ un iso uŋse, kun lekko tʼuŋsuwo kono munɗa wede Raa yi dehu yʼun tʼeley geŋ, yoŋ ɓaadaŋ yʼunni delliyo a kandaane. Geŋ iŋkino kay anʼni dibire nebiyagi ɗoŋ ti kaaga i tʼiŋgile ti kune me.» ");
INSERT INTO moz_vpl VALUES ("MT5_13","070_5_13","MAT","5","13","13","«Kune aakede sumade ki duniya, wo ɗe aame sumade geŋ uŋsuwadaŋ i tʼize umbo maŋ, kaŋ mummino kʼan ise uŋse sey me? Kane geŋ uŋse ye, ki sebbiyo mendaŋ a disse, ɗuwo an dʼon̰ƴilse. ");
INSERT INTO moz_vpl VALUES ("MT5_14","070_5_14","MAT","5","14","14","Kune aakede toore ki ɗoŋ duniya. Aame an iiziga geeger eego kesse maŋ, i ki tʼombiɗa ye. ");
INSERT INTO moz_vpl VALUES ("MT5_15","070_5_15","MAT","5","15","15","Wo aame kʼa tʼuyye pitila maŋ, kʼa ki tʼossibe bogoro ye. Ki too maŋ kʼa ti doɗɗe tʼawwa, kono todʼ tʼa toore a kane ɗoŋ pay adda ɓoy. ");
INSERT INTO moz_vpl VALUES ("MT5_16","070_5_16","MAT","5","16","16","Geŋ iŋkino kay, kune toŋ kun di toore a ɗaana ɗuwo me, kono aame an wulla naabaguŋ ere beehiye kun isiyo gettiyo maŋ, an di tʼimma Meeguguŋ Raa a kandaane.» ");
INSERT INTO moz_vpl VALUES ("MT5_17","070_5_17","MAT","5","17","17","«Kun elkiyo miŋ nuŋ nʼiido kono oogoro Muusa ti dooyiso nebiyagi, nʼa tiʼn tʼîde ko? Aha! Nuŋ nʼiido kono nʼa ki tiʼn tʼîde ye, wo nʼiido nʼa-tʼise itadaŋ a tʼaɗɗe keren̰. ");
INSERT INTO moz_vpl VALUES ("MT5_18","070_5_18","MAT","5","18","18","Ɗerec iŋkino wo nʼun di rooto: Ki poone kandaane ti siiɗo an tʼeŋgila geŋ, tʼadda kʼoogoro ette ise arku raaŋiya soo wede n̰eŋku a jiire, ise guttiye soo toŋ i ki dagga ye, geŋ iŋkino bini sulɗi pay geŋ an tʼeŋgila. ");
INSERT INTO moz_vpl VALUES ("MT5_19","070_5_19","MAT","5","19","19","Kono kamo, wede tuuku urzi kʼoogoro wede n̰eŋku a jiire geŋ yi ti yʼ diipiɗa wo yi duuya ɗuwo an dʼise iŋkino maŋ, yode geŋ Raa yʼa ti yʼ ɗeega n̰eŋku a ceera a Mozikadí me. Wo ɗe wede tuuku urziyagi kʼoogoro geŋ yi tiʼn sooru eego wo yi dooyiso ɗuwo an dʼise iŋkino kay maŋ, yoŋ geŋ Raa yʼa yʼisa goole a Mozikadí me ");
INSERT INTO moz_vpl VALUES ("MT5_20","070_5_20","MAT","5","20","20","Kono kun ollo, nʼun di rooto: Aame lekkiyaguŋ ere ki diine gette, ti ki jiira ere ki ɗoŋ suuniyo kʼoogoro ti Pariziyeŋ ye maŋ, ki kotto Moziko Raa kun ki tʼetta ye.» ");
INSERT INTO moz_vpl VALUES ("MT5_21","070_5_21","MAT","5","21","21","«Kune kun illiga an ruute a moŋgiɗagiŋ ti kaaga, anʼde: “Ki tôwwo wedusu mirsi ulu”, soŋ anʼde: “Wede yʼîida bakadí mirsi maŋ, yoŋ geŋ an di-tʼetta kʼume booro.” ");
INSERT INTO moz_vpl VALUES ("MT5_22","070_5_22","MAT","5","22","22","Wo kun ollo, nuŋ nʼun di rooto: Wede tuuku yi ti kulkuwa ti leemadí maŋ, yoŋ geŋ an di-tʼetta kʼume booro. Wede yi gilɗa leemadí: “Ulsu!” maŋ, yoŋ geŋ booradí a ɗaana deero ɗoŋ booradiŋ. Wede yi gilɗa leemadí: “Maade!” maŋ, yoŋ geŋ an ti yʼ seɗɗa adda kʼuwwo ere ki dabar. ");
INSERT INTO moz_vpl VALUES ("MT5_23","070_5_23","MAT","5","23","23","Aame ɗe kee kʼette eliyo seɗeke kʼadda Ɓoy Raa, wo a ume seɗeke geŋ kʼilke leemadá i-dʼede kulkuwo ti kee maŋ, ");
INSERT INTO moz_vpl VALUES ("MT5_24","070_5_24","MAT","5","24","24","seɗikadá ki oolo a ume gen̰n̰o, kʼokko ki yʼoonoy leemadá me, kun tʼokkiƴi ɗoo miŋ, saŋ kʼa-kami kʼa tʼela seɗikadá a Raa kollo. ");
INSERT INTO moz_vpl VALUES ("MT5_25","070_5_25","MAT","5","25","25","Aame ti leemadá un ede ono, wo kune a urzi kun ette kʼume wede booro ɓotto geŋ, ti yode ono kun tiʼn ôodo. Para maŋ leemadá geŋ yʼa-da tʼiida kʼume wede booro maŋ, wede booro yʼan gi di tʼeley a bey kʼasigiryagi, wo kane an ki ti tʼeley daŋgay. ");
INSERT INTO moz_vpl VALUES ("MT5_26","070_5_26","MAT","5","26","26","Ɗerec iŋkino wo nʼa di rooto: Tʼume geŋ ki ki tʼaɗɗa ye, daa ki munɗa wede an dehu kʼan ki yʼela pay ye maŋ, tammiyagi ɗoŋ sun̰n̰i sun̰n̰i toŋ an a-kʼoola ye.» ");
INSERT INTO moz_vpl VALUES ("MT5_27","070_5_27","MAT","5","27","27","«Kune kun illiga an ruute ti kaaga, anʼde: “Ki moone tʼere bakadá ise ti kule bakatú ulu.” ");
INSERT INTO moz_vpl VALUES ("MT5_28","070_5_28","MAT","5","28","28","Wo kun ollo, nuŋ nʼun di rooto: Wede tuuku yi wulla ere bakadí wo addí i iɓa a tode maŋ, yoŋ geŋ adda kʼaddí aa yi-tʼudige baa. ");
INSERT INTO moz_vpl VALUES ("MT5_29","070_5_29","MAT","5","29","29","Aame ɗe ersadá kʼammade tʼa-da tʼettiyo kʼadda kʼolɗiko maŋ, kʼa tʼooɗo mentú kʼa seɗɗo dokki ti kee. Beehiye i jiire a kee, moka soo ki tuddá i digge bee miŋ, tuddá pecek an ki ti seɗɗey adda kʼuwwo. ");
INSERT INTO moz_vpl VALUES ("MT5_30","070_5_30","MAT","5","30","30","Wo aame ɗe beezá wede kʼammade yʼa-da tʼettiyo kʼadda kʼolɗiko maŋ, kʼa-ɗekko mendí kʼa seɗɗo dokki ti kee. Beehiye i jiire a kee, moka soo ki tuddá i digge bee miŋ, tuddá pecek ti-tʼettey kʼadda kʼuwwo.» ");
INSERT INTO moz_vpl VALUES ("MT5_31","070_5_31","MAT","5","31","31","«Soŋ an ruute ti kaaga, anʼde: “Aame wede yi-peere eddí maŋ, yi di ɗekke mattup ki peeriyo yi di tʼele a beytú i-kaza todʼte peeriyo.” ");
INSERT INTO moz_vpl VALUES ("MT5_32","070_5_32","MAT","5","32","32","Wo kun ollo, nuŋ nʼun di rooto: Ki peeriyo kʼerewo ulu, wo wede yi peere eddí geŋ, aame ti moone ti kule bakatú ɗaŋŋal! Para maŋ yi ti peeriyo geŋ, yi ti tʼeliyo a moone ti kule bakatú, aame todʼ ti ziiɗa maŋ. Wo wede i seeɗa erewo ere peeriyo gette, Raa yi yi wolliyo yoŋ wede i moone tʼere bakadí.» ");
INSERT INTO moz_vpl VALUES ("MT5_33","070_5_33","MAT","5","33","33","«Kune kun illiga sey an ruute a moŋgiɗagiŋ ti kaaga, anʼde: “Munɗa wede kʼa ti nîime tuddá geŋ, ki tʼooɗiba eedá ye, kʼa ti yʼ ɗaŋgo munɗa wede kʼa ti nîime tuddá a ɗaana Galmeega Raa geŋ me.” ");
INSERT INTO moz_vpl VALUES ("MT5_34","070_5_34","MAT","5","34","34","Wo kun ollo, nuŋ nʼun di rooto: Kun nâama tudduguŋ ye tak: Ti kandaane kun nâama tudduguŋ ye, kono yoŋ geŋ kaakido moziko Raa. ");
INSERT INTO moz_vpl VALUES ("MT5_35","070_5_35","MAT","5","35","35","Ti siiɗo kun nâama tudduguŋ ye, kono todʼte ume yi dʼoɓe zoŋɗí. Ti Zeruzalem kun nâama tudduguŋ ye, kono todʼte geeger ki Raa mozigo goole. ");
INSERT INTO moz_vpl VALUES ("MT5_36","070_5_36","MAT","5","36","36","Ti egguŋ toŋ kun nâama tudduguŋ ye, kono wedusu geŋ ililso kʼeedí soo toŋ yi kʼaane yi ki tʼise tuwarwa ye gammilawa ye. ");
INSERT INTO moz_vpl VALUES ("MT5_37","070_5_37","MAT","5","37","37","Aame munɗa kun isa maŋ, kunʼde “Eyye, ay isa” ɗaŋŋal, wo munɗa kun kʼisa ye maŋ, kunʼde “Aha, ay kʼisa ye” ɗaŋŋal. Ono ɗoŋ kun rootiyo ti doolo geŋ ettiyo tʼurzi Mohita kʼolɗiko.» ");
INSERT INTO moz_vpl VALUES ("MT5_38","070_5_38","MAT","5","38","38","«Kune kun illiga an ruute ti kaaga, anʼde: “Wede yi tuuka ersa bakadí maŋ, ki yode an i di tooka kay, wede yi tʼiira sinta bakadí maŋ, ki yode an i di tʼoora kay.” ");
INSERT INTO moz_vpl VALUES ("MT5_39","070_5_39","MAT","5","39","39","Wo kun ollo, nuŋ nʼun di rooto: A wede yʼa ize ulsu geŋ, kee ki-ti dooze ye. Aame wede yi ki diin̰e a toɓɓisadá kʼammade ki bita maŋ, ki kama toɓɓisadá ere ki geelo toŋ yʼa ki ti daan̰a. ");
INSERT INTO moz_vpl VALUES ("MT5_40","070_5_40","MAT","5","40","40","A wede i dehu yʼa-di tʼette kʼume wede ɗekkiyo booro kono yʼa tʼamɓa kallayá wede n̰eŋku tʼadda maŋ, ki-oolo kallayá wede goole toŋ yʼa tʼamɓo pây. ");
INSERT INTO moz_vpl VALUES ("MT5_41","070_5_41","MAT","5","41","41","Aame wede yi-kʼisiyo ki toogo i-dʼede attiɗi yi dehu kʼa di yʼ tʼigibo suma kuɓɓaara soo maŋ, kʼa yʼagiba kuɓɓaara sire. ");
INSERT INTO moz_vpl VALUES ("MT5_42","070_5_42","MAT","5","42","42","Wede yi tondiyo munɗa ti beezá maŋ, ki eelo, wo wede yi tondiyo see ti beezá maŋ, ki-tooge ye.» ");
INSERT INTO moz_vpl VALUES ("MT5_43","070_5_43","MAT","5","43","43","«Kune kun illiga an ruute ti kaaga, anʼde: “Ki geyyo bakadá wo aduzá ki koogor.” ");
INSERT INTO moz_vpl VALUES ("MT5_44","070_5_44","MAT","5","44","44","Wo ɗe kun ollo, nuŋ nʼun di rooto: Kun geyyo kane ɗoŋ ti kune adu, wo kun tondo Raa ki ɗoŋ unni dabirsa. ");
INSERT INTO moz_vpl VALUES ("MT5_45","070_5_45","MAT","5","45","45","Aame kun isiyo iŋkino maŋ, kun tʼisa in̰n̰i ki Meeguguŋ Raa a kandaane. Ɗerec, yoŋ yi koliyo peeɗadí a tukki ɗoŋ bundiɗi wo a tukki ɗoŋ beehiye pây, yi koppiyo mizzi a ɗoŋ ki diine wo a ɗoŋ ki diine ye pây. ");
INSERT INTO moz_vpl VALUES ("MT5_46","070_5_46","MAT","5","46","46","Aame kun geyyiso ɗoŋ unni geyyiso ɗaŋŋal maŋ, munɗa wede Raa yi dehu yʼun tʼeley geŋ kun di yʼ tʼooney ɗey ko? Ɗerec, ɗoŋ seɗɗu jibaaye kane batum toŋ an isiyo iŋkino kay. ");
INSERT INTO moz_vpl VALUES ("MT5_47","070_5_47","MAT","5","47","47","Aame kun eesiyto zemɓaguŋ ɗaŋŋal maŋ, geŋ munɗa wede ki kune i tʼîhina siidí too me ti ɗoŋ oŋgo me? Ɗerec, kane ɗoŋ Yawudiyagi ye batum toŋ an isiyo iŋkino kay. ");
INSERT INTO moz_vpl VALUES ("MT5_48","070_5_48","MAT","5","48","48","Iŋkino maŋ kun tʼiso ɗoŋ ɗerec ki diine baa, aakede Meeguguŋ Raa a kandaane toŋ yoŋ ɗerec ki diine.» ");
INSERT INTO moz_vpl VALUES ("MT6_1","070_6_1","MAT","6","1","1","«Kun koona mentikagi kono a urzi daaniya Raaguŋ geŋ, kun ise bitin̰ bitin̰ a ɗaana ɗuwo an un gi diʼn wolle ye. Para maŋ munɗa wede Meeguguŋ Raa a kandaane yi dehu yʼun tʼeley geŋ, kun ki yʼ tʼoone ye. ");
INSERT INTO moz_vpl VALUES ("MT6_2","070_6_2","MAT","6","2","2","Iŋkino aame ki-tʼele munɗa a wede i-kʼede munɗa ye geŋ, ki koppe darru ye, aakede ɗoŋ bizaŋ sire sire ge dʼisiyo a urziyagi geeger wo adda ɓoyɗi ɗoŋ in di dooyiso. An isiyo iŋkino kono ɗuwo an diʼn tʼimme. Ɗerec iŋkino wo nʼun di rooto: Kane geŋ munɗa wede an dehu an tʼoona a naabadaŋ, an yʼuune baa. ");
INSERT INTO moz_vpl VALUES ("MT6_3","070_6_3","MAT","6","3","3","Wo ki kee, aame ki-tʼele munɗa a wede i-kʼede munɗa ye ti beezá wede kʼammade maŋ, beezá wede ki geelo batum yʼa ki suune ye. ");
INSERT INTO moz_vpl VALUES ("MT6_4","070_6_4","MAT","6","4","4","Iŋkino maŋ munɗa wede kʼele geŋ yʼa lekke ombiɗe, wo Meegá Raa yi wolliyo munɗa wede kʼisiyo kaŋ ombiɗe geŋ me. Iŋkino munɗa wede Raa yi dehu yʼa di tʼele geŋ, kʼa yi tʼooney.» ");
INSERT INTO moz_vpl VALUES ("MT6_5","070_6_5","MAT","6","5","5","«A urzi tondiyo Raa geŋ, kun ise aakede ɗoŋ bizaŋ sire sire ge dʼisiyo ye. Kane an geyyiso tondiyo Raa kaŋ ôhire adda ɓoyɗi ɗoŋ in di dooyiso wo a urziyagi kʼokkime, kono ɗuwo an diʼn wolle. Ɗerec iŋkino wo nʼun di rooto: Kane geŋ munɗa wede an dehu an tʼoona, an yʼuune baa. ");
INSERT INTO moz_vpl VALUES ("MT6_6","070_6_6","MAT","6","6","6","Wo ki kee, aame ki dehu kʼa tonde Raa maŋ, ki tʼodo adda biino moonizá, biza kʼa-tʼappa wo kʼa tondo Meegá Raa yoŋ ede a ume ombiɗe geŋ me. Wo Meegá Raa yi wolliyo munɗa wede kʼisiyo kaŋ ombiɗe me. Iŋkino munɗa wede Raa yi dehu yʼa di tʼele geŋ, kʼa yi tʼooney. ");
INSERT INTO moz_vpl VALUES ("MT6_7","070_6_7","MAT","6","7","7","Aame kun tondiyo Raa maŋ, ono kunʼni ɗoolite ye, aakede kane ɗoŋ Yawudiyagi ye ge dʼisiyo me, kono an elkiyo an bobbiso ɓaadaŋ geŋ Raa yʼan olliga. ");
INSERT INTO moz_vpl VALUES ("MT6_8","070_6_8","MAT","6","8","8","Iŋkino kun dooze kane ye, kono Meeguguŋ Raa yi suune munɗa wede kun dehu a urzi lekkiyaguŋ, ki poone kun di yʼ tonda geŋ me. ");
INSERT INTO moz_vpl VALUES ("MT6_9","070_6_9","MAT","6","9","9","Iŋkino maŋ kun tondo Raa kino: Meegey wede a kandaane, kee kʼiso ɗuwo pay an di suune kee Raa kamilen̰, ");
INSERT INTO moz_vpl VALUES ("MT6_10","070_6_10","MAT","6","10","10","Mozikadá kʼa-di tʼedi. Munɗa wede addá i dehu kʼaase a siiɗo ette, ki yʼiso aakede ki dʼisiyo a kandaane. ");
INSERT INTO moz_vpl VALUES ("MT6_11","070_6_11","MAT","6","11","11","Aŋki kee kʼay eeli omɓadey ere ay di tʼîde. ");
INSERT INTO moz_vpl VALUES ("MT6_12","070_6_12","MAT","6","12","12","Kʼay tʼisi tambobino a munɗa wede ulsu ay ize a kee, aakede kaye toŋ ay an tʼize tambobino a kane ɗoŋ ay ize munɗa ulsu kay. ");
INSERT INTO moz_vpl VALUES ("MT6_13","070_6_13","MAT","6","13","13","Kʼaynʼooli adda naamiya daggiya i ceera eedey ay tʼetta adda kʼolɗiko ye, wo ɗe kʼay tiʼn aɗɗi ti bey Mohita kʼolɗiko. Geŋ moziko, toogo wo tamma, kane pay ki kee ki daayum. Eyye. ");
INSERT INTO moz_vpl VALUES ("MT6_14","070_6_14","MAT","6","14","14","Iŋkino maŋ, aame a ɗoŋ a ti doopiɗe a onamguŋ geŋ tambobino kun an tʼisiyo maŋ, Meeguguŋ Raa a kandaane toŋ, yʼun tʼisa tambobino kay a munɗa wede kun a ti doopiɗe me. ");
INSERT INTO moz_vpl VALUES ("MT6_15","070_6_15","MAT","6","15","15","Wo ɗe aame a ɗoŋ a ti doopiɗe a onamguŋ geŋ tambobino kun an kʼisiyo ye maŋ, Meeguguŋ Raa toŋ yʼun kʼisa ye kay tambobino a munɗa wede kun a ti doopiɗe me.» ");
INSERT INTO moz_vpl VALUES ("MT6_16","070_6_16","MAT","6","16","16","«A lekkiyaguŋ onniyo muno kun lekkiyo daa kʼomɓo geŋ, kun ti yʼise ume kʼedaguŋ zimolo aa ɗoŋ bizaŋ sire sire ge dʼisiyo ye. Kane an tiʼn n̰eeriyo edayaŋ kono ɗuwo an diʼn wolle kane onniyo muno an lekkiyo daa kʼomɓo. Ɗerec iŋkino wo nʼun di rooto: Kane geŋ munɗa wede an dehu an tʼoona, an yʼuune baa. ");
INSERT INTO moz_vpl VALUES ("MT6_17","070_6_17","MAT","6","17","17","Wo kee aame onniyo muno ki lekkiyo daa kʼomɓo maŋ, edayá ki tʼopilo wo eedá kʼa tʼassigo egey, ");
INSERT INTO moz_vpl VALUES ("MT6_18","070_6_18","MAT","6","18","18","kono ɗuwo an ki di suune ye kee onniyo muno ki lekkiyo daa kʼomɓo me. A suune Meegá Raa ɗaŋŋal yoŋ ede a ume ombiɗe geŋ me, wo yoŋ Meegá Raa yi wolliyo munɗa wede kʼisiyo ombiɗe me. Iŋkino munɗa wede Raa yi dehu yʼa di tʼele geŋ, kʼa yi tʼooney.» ");
INSERT INTO moz_vpl VALUES ("MT6_19","070_6_19","MAT","6","19","19","«Kun tʼokume ye laale a siiɗo ette, kono a eŋ amma ti dibe an tʼooma pay, a eŋ ɗoŋ kʼoogire an di tooka ti ɓoy wo an di sika. ");
INSERT INTO moz_vpl VALUES ("MT6_20","070_6_20","MAT","6","20","20","Ki too maŋ kun okumo laale a kandaane, a ummey amma ti dibe umbo, a ummey ɗoŋ kʼoogire umbo a-tooka ɓoy wo an di sika me. ");
INSERT INTO moz_vpl VALUES ("MT6_21","070_6_21","MAT","6","21","21","Ɗerec, a ume wede laalayá yi lekkiyo geŋ, addáʼŋ toŋ aŋgen̰n̰o.» ");
INSERT INTO moz_vpl VALUES ("MT6_22","070_6_22","MAT","6","22","22","«Eda kane aa pitila ki tudde. Aame edayá kane bee maŋ, tuddá pay gette adda toore. ");
INSERT INTO moz_vpl VALUES ("MT6_23","070_6_23","MAT","6","23","23","Wo aame edayá geŋ kane bee ye maŋ, tuddá pay gette adda zimolo. Iŋkino aame toore wede a-dʼede geŋ i tʼize zimolo maŋ, geŋ kee adda zimolo ere dil baa.» ");
INSERT INTO moz_vpl VALUES ("MT6_24","070_6_24","MAT","6","24","24","«Wenɗa soo toŋ umbo a aane a naabe ti galmaawi sire me, ise maŋ soŋ yʼa yʼolmiɗa wo yʼa-geyye soo me, wo ise maŋ yʼa di kette ti wede soo me wo soŋ yʼa yi kiigira. Kun kʼaane kun ki ti daane ye, urzi Raa wo urzi soŋko sirwaŋ pay me.» ");
INSERT INTO moz_vpl VALUES ("MT6_25","070_6_25","MAT","6","25","25","«Geŋ kono kʼiŋkino nʼun di rooto: Kune a lekkiyaguŋ ulbuguŋ un tʼooɗe ye a urzi kʼomɓo wo a urzi soɓo me, ise a urzi kʼossiyo ere ki tudduguŋ toŋ maŋ. Ki kotto lekkiyaguŋ ere kun lekkiyo ette ti jiire omɓo, wo tudduguŋ ti jiire ossiyo. ");
INSERT INTO moz_vpl VALUES ("MT6_26","070_6_26","MAT","6","26","26","Kun wollo emɓi, an ki korso ye, an kʼayɗu ye wo an kʼokimso mudu adda giiƴagi ye, wo Meeguguŋ Raa a kandaane yi diʼn moɗɗiyo. Wo kune ki kotto kun i jiire kane geŋ taŋ ɓaadaŋ! ");
INSERT INTO moz_vpl VALUES ("MT6_27","070_6_27","MAT","6","27","27","Wee wee ti diinaguŋ, ti ulbe kʼooɗiyo wede i-dʼede geŋ, yʼaane yʼa dʼaagila ti keɗise soo onniytagi ɗoŋ ki lekkiyadí a duniya eŋ me? ");
INSERT INTO moz_vpl VALUES ("MT6_28","070_6_28","MAT","6","28","28","Wo ɗe ki moo me ulbuguŋ un dʼooɗiyo a ossiyo me? Kun wollo bobbo soole adda balɗa gette, ti dʼohire, ti ki naabiya ye, ti kʼisiyo kallagi ye. ");
INSERT INTO moz_vpl VALUES ("MT6_29","070_6_29","MAT","6","29","29","Wo kun ollo, nʼun di rooto: Mozigo Salamoŋ toŋ ti laale wede pay i-dʼede geŋ, yi kʼusse ye kalle wede majjaane aakede bobbo soole soo toŋ maŋ. ");
INSERT INTO moz_vpl VALUES ("MT6_30","070_6_30","MAT","6","30","30","Iŋkino Raa yi-ti yʼossiyo soole wede adda balɗa aŋki kuti kutin̰, wo soggo an tʼoggiyo adda kʼuwwo mendí. Geŋ taŋ miibi a ceere Raa yʼun diʼn osse kune batum me! Ki kotto kune zaapu kʼadduguŋ a Raa baata. ");
INSERT INTO moz_vpl VALUES ("MT6_31","070_6_31","MAT","6","31","31","Iŋkino maŋ kune ulbuguŋ un tʼooɗe ye, adda kʼadduguŋ kun roote ye: “Ay dʼooma moo me?”, “Ay siɓa moo me?” wo “Ay dʼossa moo me?” me. ");
INSERT INTO moz_vpl VALUES ("MT6_32","070_6_32","MAT","6","32","32","Sulɗi pay geŋ, daayum iʼni dehutu kane ɗoŋ pay i ki suune Raa soo ɗaŋŋal ye gen̰n̰o. Wo Meeguguŋ Raa a kandaane geŋ, yoŋ yi suune sulɗi geŋ kunʼni dehu a urzi lekkiyaguŋ me. ");
INSERT INTO moz_vpl VALUES ("MT6_33","070_6_33","MAT","6","33","33","Ki too maŋ kun deho ki poone Moziko Raa wo urzi lekkiyo ere ki diine aa Raa yi dehu, wo saŋ sulɗi pay geŋ yʼun diʼn tʼela kay. ");
INSERT INTO moz_vpl VALUES ("MT6_34","070_6_34","MAT","6","34","34","Iŋkino maŋ kune ulbuguŋ un tʼooɗe ye a munɗa wede ki soggo me, kono onniyo ere ki soggo gette todʼte tʼonniyatú. Onniyo ere soo dabaratú i-tôwwo kʼettú kʼettú.» ");
INSERT INTO moz_vpl VALUES ("MT7_1","070_7_1","MAT","7","1","1","«Kun ɗekke booro a tukki wede tuuku toŋ maŋ ye, geŋ Raa toŋ yi ki ɗekka booro egguŋ ye. ");
INSERT INTO moz_vpl VALUES ("MT7_2","070_7_2","MAT","7","2","2","Ɗerec, tʼurzi wede kun ɗekkiyo booro a tukki ɗoŋ oŋgo geŋ, Raa toŋ yʼa ɗekka booro egguŋ, wo dooziyo ere kun dooziyo a ɗuwo gette, Raa toŋ yʼun ti dooza a kune iŋkino kay. ");
INSERT INTO moz_vpl VALUES ("MT7_3","070_7_3","MAT","7","3","3","Ki moo me ki wolliyo un̰umu wede adda kʼersa leemadá, wo undumu wede adda kʼersadá ki gi di yʼowwiyo ye me? ");
INSERT INTO moz_vpl VALUES ("MT7_4","070_7_4","MAT","7","4","4","Ɗe mummino kʼa aane ki di roote a leemadá, kʼa tʼeese: “Kʼoolo nʼa di tʼamɓo un̰umu wede adda kʼersadá en̰n̰o”, wo kaciŋ kee a-dʼede undumu adda kʼersadá me? ");
INSERT INTO moz_vpl VALUES ("MT7_5","070_7_5","MAT","7","5","5","Kee wede biza sire sire, ki tʼamɓo undumu wede adda kʼersadá ɗoo, iŋkino kʼa wolla keren̰, saŋ kʼa tʼamɓa un̰umu wede adda kʼersa leemadá kollo. ");
INSERT INTO moz_vpl VALUES ("MT7_6","070_7_6","MAT","7","6","6","Munɗa wede kamilen̰ a ɗaana Raa geŋ a gede ki-tʼele ye, para maŋ yʼaa kima ki tuddá yʼa ki ti kʼahita. Ɗogoro ere zooyatú oon̰e gette kun seɗɗa a ɗaana kinzir ye, para maŋ tode gette yʼa-tʼon̰ƴilsa mentú.» ");
INSERT INTO moz_vpl VALUES ("MT7_7","070_7_7","MAT","7","7","7","«Kun tondo wo munɗa an un tʼeela, kun dehito wo kun tʼoona, kun koppo biza wo an un di-tʼihina. ");
INSERT INTO moz_vpl VALUES ("MT7_8","070_7_8","MAT","7","8","8","Wede tuuku yi tondiyo maŋ, munɗa an i-dʼeliyo, wede yi dehutu maŋ, yi dʼooniyo, wo wede yi koppiyo biza maŋ, an i di tʼohine. ");
INSERT INTO moz_vpl VALUES ("MT7_9","070_7_9","MAT","7","9","9","Wee wee ti diinaguŋ aame ulí yi tunde omɓo maŋ, yi di tʼele mokkolo me? ");
INSERT INTO moz_vpl VALUES ("MT7_10","070_7_10","MAT","7","10","10","Koo yi tunde puuniso maŋ, yi di tʼele miipo me? Aha umbo! ");
INSERT INTO moz_vpl VALUES ("MT7_11","070_7_11","MAT","7","11","11","Iŋkino maŋ kune ɗoŋ adduguŋ ulpi toŋ, kun suune eliyo sulɗi ɗoŋ majjanɗani a in̰n̰iguŋ. Wo geŋ taŋ miibi a ceere Meeguguŋ Raa a kandaane yʼaane yʼan tʼele sulɗi ɗoŋ majjanɗani a ɗoŋ i yi tondiyo me! ");
INSERT INTO moz_vpl VALUES ("MT7_12","070_7_12","MAT","7","12","12","Sulɗi ɗoŋ pay kun dehu ɗuwo an un dʼise geŋ, a kane toŋ kun an iso iŋkino kay. Geŋ iŋkino ita kʼono ɗoŋ pay an riiŋe ti kaaga adda mattup kʼoogoro Muusa ti ɗoŋ ki nebiyagi me.» ");
INSERT INTO moz_vpl VALUES ("MT7_13","070_7_13","MAT","7","13","13","«Kun tʼodo ti biza perƴeƴe. Ɗerec, biza goole geŋ yoŋ urzi wede sooruzí i kʼoon̰e ye, yʼa-da tʼette kʼume daggiya, wo ɗoŋ ɓaadaŋ an aɗɗiya tʼurzi gen̰n̰o. ");
INSERT INTO moz_vpl VALUES ("MT7_14","070_7_14","MAT","7","14","14","Ki kotto biza perƴeƴe geŋ, yoŋ urzi sooruzí oon̰e, yʼa-da tʼette kʼume lekkiyo ere ki daayum, wo ɗoŋ baata aɗɗiya tʼurzi geŋ me.» ");
INSERT INTO moz_vpl VALUES ("MT7_15","070_7_15","MAT","7","15","15","«Kun koona mentikagi ti ɗuwo ɗoŋ an ti tʼisiyo tuddaŋ aa nebiyagi. Anʼtiyo tudduguŋ kane tasse aa damɓami, wo kaciŋ tʼadda kʼaddaŋ kane bundiɗi aa sullibagi. ");
INSERT INTO moz_vpl VALUES ("MT7_16","070_7_16","MAT","7","16","16","Geŋ kane kun diʼn suune a urzi sooruzaŋ. In̰n̰i kʼinda bin̰ ekkʼundumu kʼahimagi ki ki rakke ye, ise in̰n̰i tormo toŋ ekki woskani ki ki rakke ye. ");
INSERT INTO moz_vpl VALUES ("MT7_17","070_7_17","MAT","7","17","17","Iŋkino undumu tuuku beehiye yʼa tʼehe in̰n̰izí toŋ beehiye, wo undumu wede ulsu yʼa tʼehe in̰n̰izí toŋ ulpi. ");
INSERT INTO moz_vpl VALUES ("MT7_18","070_7_18","MAT","7","18","18","Undumu wede beehiye yi kʼaane yi ki tʼehe in̰n̰i ulpi ye, wo undumu wede ulsu yi kʼaane yi ki tʼehe in̰n̰i beehiye ye. ");
INSERT INTO moz_vpl VALUES ("MT7_19","070_7_19","MAT","7","19","19","Undumu tuuku yi kʼehiyo in̰n̰i beehiye ye maŋ, yoŋ geŋ an di ɗekka an di seɗɗa adda kʼuwwo mendí. ");
INSERT INTO moz_vpl VALUES ("MT7_20","070_7_20","MAT","7","20","20","Geŋ iŋkino ɗuwo ɗoŋ an ti tʼisiyo tuddaŋ kane nebiyagi kaciŋ nebiyagi ye geŋ, kun diʼn suune a urzi sooruzaŋ.» ");
INSERT INTO moz_vpl VALUES ("MT7_21","070_7_21","MAT","7","21","21","«Kane ɗoŋ an ni waaku: “Galmeegey, Galmeegey” geŋ, pay an ki tʼetta ye kʼadda Moziko Raa te. Wo etta kane ɗoŋ isiyo munɗa wede Meego Raa a kandaane yi dehu ɗaŋŋalaŋ. ");
INSERT INTO moz_vpl VALUES ("MT7_22","070_7_22","MAT","7","22","22","A onniyo booro gette ɗoŋ ɓaadaŋ an o di roota, an tʼeesa: “Galmeegey, Galmeegey, ki kotto ti sundá ay ruutito ono ɗoŋ Raa yʼigibo, ti sundá ay dʼilmito siitanɗani, ti sundá ay dʼizito sulɗi kʼarmika ɓaadaŋ ɗe me!” ");
INSERT INTO moz_vpl VALUES ("MT7_23","070_7_23","MAT","7","23","23","Iŋkino maŋ nʼan di roota keren̰, nʼa tʼeesa: “Kune toc aŋ wenɗa nʼun kiʼn zuune ye. Kun ti leɗɗo dokki ti tuddó me, kune ɗoŋ isiyo sulɗi ɗoŋ ulpi!”» ");
INSERT INTO moz_vpl VALUES ("MT7_24","070_7_24","MAT","7","24","24","«Iŋkino wede tuuku yʼollige ono ɗoŋ ni rootiyo en̰n̰o wo yi sooru eego maŋ, yoŋ geŋ yi deeƴiso aa wede i-dʼede elkiso yʼa tʼiiziga ɓoozí eego paŋgiragi. ");
INSERT INTO moz_vpl VALUES ("MT7_25","070_7_25","MAT","7","25","25","Mizzi yʼa guppe ti maaye ɓaadaŋ, oyɗayi an dʼûunite i palɗita waawiye. Maaye ti bormo geŋ an di ŋiiƴa ɓoy gen̰n̰o wo yʼa kʼiire ye, kono yoŋ itadí an ziipe ekki paŋgiragi. ");
INSERT INTO moz_vpl VALUES ("MT7_26","070_7_26","MAT","7","26","26","Wo ɗe wede tuuku yʼollige ono ɗoŋ ni rootiyo en̰n̰o wo yi ki sooru eego ye maŋ, yoŋ geŋ yi deeƴiso aa wede elkisadí umbo yʼa tʼiiziga ɓoozí a dolso. ");
INSERT INTO moz_vpl VALUES ("MT7_27","070_7_27","MAT","7","27","27","Mizzi yʼa guppe ti maaye ɓaadaŋ, oyɗayi an dʼûunite i palɗita waawiye. Maaye ti bormo geŋ an di ŋiiƴa ɓoy gen̰n̰o wo a ruuge pay.» ");
INSERT INTO moz_vpl VALUES ("MT7_28","070_7_28","MAT","7","28","28","Isa yʼa ti ɗiŋge dooyiso gettiyo maŋ, kane ɗoŋ duuru dooyisadí gette tʼan diʼn ziiɗa, ");
INSERT INTO moz_vpl VALUES ("MT7_29","070_7_29","MAT","7","29","29","kono yoŋ yi dooyiso ti toogo suuniyo ere ki yode batum, wo aakede ki ɗoŋ suuniyo kʼoogoro ge ki dooyiso ye. ");
INSERT INTO moz_vpl VALUES ("MT8_1","070_8_1","MAT","8","1","1","Isa yi ti ɗiige tʼekki kesse maŋ, ɗoŋ duuru ɓaadaŋ an di yʼ diine. ");
INSERT INTO moz_vpl VALUES ("MT8_2","070_8_2","MAT","8","2","2","Iŋkino maŋ i dʼede wede bitiɗe yʼa dʼiide sirpa kʼIsa, yʼa-dikke a ɗaanadí wo yʼa yi tunde, yʼede: «Galmeeʼki nuŋ, ki dehu maŋ, kʼo eli beeko nʼa tʼise kamilen̰ a ɗaana Raa.» ");
INSERT INTO moz_vpl VALUES ("MT8_3","070_8_3","MAT","8","3","3","Maŋ Isa yʼa igibe beezí yʼa yi butte, wo yʼa ruute, yʼede: «Nuŋ ni dehu, ki tʼiso kamilen̰!» A kaamiki bitiɗayí a n̰ukkiɗe, yʼa tʼize kamilen̰. ");
INSERT INTO moz_vpl VALUES ("MT8_4","070_8_4","MAT","8","4","4","Wo Isa yi di ruute, yʼede: «Kʼollo koɗuwo, a munɗa wede ize eŋ a wenɗa soo toŋ ki rootey ye! Wo ɗe kʼodo deddet ki-ti kazoy tuddá a wede seɗeke yʼa ki ti wolley, wo kʼa eloy munɗa ki seɗeke aa Muusa yʼa ruute adda kʼoogoro in dʼise, kono ɗoŋ pay an di wolle kee kʼuune bee.» ");
INSERT INTO moz_vpl VALUES ("MT8_5","070_8_5","MAT","8","5","5","Isa yʼette kʼadda geeger Kapernayim geŋ, i dʼede goole kʼasigiryagi meeda ki Romeŋ, yʼa dʼiide sirpa kʼIsa wo yi-dʼoɓe bey, yʼede: ");
INSERT INTO moz_vpl VALUES ("MT8_6","070_8_6","MAT","8","6","6","«Galmeeʼki nuŋ, wede naabadó eeni, tuddí i tʼinda moone a ɓoy, yi dabirsa ɓaadaŋ.» ");
INSERT INTO moz_vpl VALUES ("MT8_7","070_8_7","MAT","8","7","7","Maŋ Isa yi di ruute, yʼede: «Nuŋ nʼa etta ni-tʼeley beeko te.» ");
INSERT INTO moz_vpl VALUES ("MT8_8","070_8_8","MAT","8","8","8","Wo goole kʼasigiryagi yi diʼn gime onamí, yʼede: «Galmeeʼki nuŋ, nuŋ ni kʼîide ye kʼa ette ki ɓoozó me. Wo tʼeŋ miŋ ki rooto munɗa soo kono wede naabadó yʼa tʼoone bee. ");
INSERT INTO moz_vpl VALUES ("MT8_9","070_8_9","MAT","8","9","9","Iŋkino nuŋ batum nʼottilso a ɗoŋ deero tʼeedó wo i dʼede asigiryagi ɗoŋ nuŋ goole tʼeedaŋ. Aame ni rootiyo a wede soo: “Kʼodo!” maŋ, geŋ yi dʼeŋgilso. Aame ni rootiyo a wede doolo: “Kʼedi!” maŋ, geŋ yi dʼettiyo. Wo aame ni rootiyo a ɓulayó: “Naabo ette ki-tʼiso!” maŋ, geŋ yi-ti tʼisiyo.» ");
INSERT INTO moz_vpl VALUES ("MT8_10","070_8_10","MAT","8","10","10","Aame Isa yʼilliga ono gen̰n̰o maŋ, yʼa ziiɗa giggirí wo yʼan di ruute a ɗoŋ duuru ɗoŋ i yi daaniya geŋ, yʼede: «Ɗerec iŋkino wo nʼun di rooto: Adda siiɗo kʼIzirayel ette wenɗa soo toŋ ni kʼuune ye, wede a zaape addí a Raa aa yode kino eŋ me. ");
INSERT INTO moz_vpl VALUES ("MT8_11","070_8_11","MAT","8","11","11","Wo kun ollo, nʼun di rooto sey: Ɗoŋ ɓaadaŋ an dʼetto ti kese peeɗo ge-koliyo wo ti kese peeɗo kʼooriyo, an di kooney an dʼoomey kaŋ soo adda Moziko Raa ti Ibirayim, Isaaka wo Yakup. ");
INSERT INTO moz_vpl VALUES ("MT8_12","070_8_12","MAT","8","12","12","Wo ɗe kane Yawudiyagi ɗoŋ toc ooma Moziko Raa geŋ, ɗoŋ oŋgo an tiʼn sebbey ti paate adda zimolo, ume wede ki ɗollite môolo wo kʼaaɗumu sina.» ");
INSERT INTO moz_vpl VALUES ("MT8_13","070_8_13","MAT","8","13","13","Maŋ Isa yi di ruute a goole kʼasigiryagi, yʼede: «Ki-kama ki ɓoozá. Kono ki ziipe addá a nuŋ geŋ, wede naabadá yʼoono bee.» A peeɗo gettiyo batum wede naabo ki goole kʼasigiryagi geŋ yʼa uune bee. ");
INSERT INTO moz_vpl VALUES ("MT8_14","070_8_14","MAT","8","14","14","Saŋ maŋ Isa yʼa tʼiide daŋ Piyer. Aame yʼiiney maŋ yi-tʼuuney ande Piyer ekkʼoŋgali i-ti dʼiire. ");
INSERT INTO moz_vpl VALUES ("MT8_15","070_8_15","MAT","8","15","15","Maŋ Isa yi ziiɗa beytú, wo a kaamiki ooriyo tʼa tʼiili, tʼa tʼiiziga wo ti di naabiya. ");
INSERT INTO moz_vpl VALUES ("MT8_16","070_8_16","MAT","8","16","16","A peeɗo tʼa tʼiire maŋ, tiŋ geŋ ɗuwo an i di ziko ɗoŋ ɓaadaŋ an dʼede siitanɗani a eedaŋ. Tʼurzi toogo kʼonamí Isa yʼan ilmiti siitanɗani me, wo ɗoŋ kʼeeni pay geŋ yʼan dʼele beeko. ");
INSERT INTO moz_vpl VALUES ("MT8_17","070_8_17","MAT","8","17","17","Yʼize sulɗi iŋkino kono a-tʼette a ono ɗoŋ nebi Ezayi yi riiŋe ti kaaga adda mattup ki Raa, yʼede: «Yode batum yʼa iyye yʼa tʼumɓe dabaradiŋ ti enɗanziŋ a eedí.» ");
INSERT INTO moz_vpl VALUES ("MT8_18","070_8_18","MAT","8","18","18","Onniyo soo Isa yi wulle ɗoŋ duuru ɓaadaŋ an i di-tʼugiye maŋ, yʼan di ruute a sanalliyagí an di doopiɗa ti yode ti dar bar ki Galile ti nee. ");
INSERT INTO moz_vpl VALUES ("MT8_19","070_8_19","MAT","8","19","19","Aame geŋ wede suuniyo kʼoogoro yʼa dʼiide sirpa kʼIsa wo yi di ruute, yʼede: «Wede dooyisadey, nʼa ki daana kʼume wede tuuku kee kʼetta geŋ me.» ");
INSERT INTO moz_vpl VALUES ("MT8_20","070_8_20","MAT","8","20","20","Wo Isa yi-tiʼn gime onamí, yʼede: «Boo ti ɓoyɗutú wo emɓi toŋ ti ɓoyɗizaŋ, wo ɗe nuŋ wede an nʼehe aa ulo wede eŋ, oo kʼede ume ni ki ti tʼele eedó nʼa ki puuke ye.» ");
INSERT INTO moz_vpl VALUES ("MT8_21","070_8_21","MAT","8","21","21","I dʼede wede doolo ti diine sanalliyagí yi di ruute Isa, yʼede: «Galmeeʼki nuŋ, kʼo eeli urzi nʼa ette nʼa tʼottibo meegó ɗo.» ");
INSERT INTO moz_vpl VALUES ("MT8_22","070_8_22","MAT","8","22","22","Wo ɗe Isa yi di ruute, yʼede: «Ki ni daani, wo kiʼn oolo kane ɗoŋ aa unto an dʼottiba tuddaŋ.» ");
INSERT INTO moz_vpl VALUES ("MT8_23","070_8_23","MAT","8","23","23","Maŋ Isa yi ti gili adda tooko, wo kane sanalliyagí an a di gili ti yode. ");
INSERT INTO moz_vpl VALUES ("MT8_24","070_8_24","MAT","8","24","24","An a iide maŋ, a kaamiki i dʼiiziga maaye ɓaadaŋ adda bar. Ahu geŋ i-kolzite kolzite i dʼoɓite kʼadda tooko, wo yo Isa geŋ yʼa udige kuy. ");
INSERT INTO moz_vpl VALUES ("MT8_25","070_8_25","MAT","8","25","25","Kane sanalliyagi an a dʼiide sirpadí an di yʼinne kaŋ ɗollite, anʼde: «Galmeegey kʼin utti, paraʼŋ in ti tʼinda!» ");
INSERT INTO moz_vpl VALUES ("MT8_26","070_8_26","MAT","8","26","26","Maŋ Isa yʼan di ruute, yʼede: «Kun orgiso iŋkino moo me? Ki kotto kune zaapu kʼadduguŋ a Raa baata!» Iŋkino maŋ Isa yʼa tʼiiziga, yʼan iɗɗise maaye ti ahu bar geŋ me, wo a kaamiki an dʼinniga ɗeɗɗek. ");
INSERT INTO moz_vpl VALUES ("MT8_27","070_8_27","MAT","8","27","27","Kane ɗoŋ pay ti yode geŋ an ziiɗa giggiraŋ wo an di rootiyo, anʼde: «Yode eŋ moo wede me, kono aŋ maaye ti ahu bar toŋ an dʼollige onamí me!» ");
INSERT INTO moz_vpl VALUES ("MT8_28","070_8_28","MAT","8","28","28","Aame Isa yʼiiney a siiɗo Gadara ti dar bar Galile ti nee maŋ, i dʼiide ɗoŋ sire tʼume muuziyagi, an iideʼŋ an a yʼikkima. Kane ɗoŋ geŋ an dʼede siitanɗani a eedaŋ, kane bundiɗi wenɗa soo toŋ yi kʼaane yi kʼaɗɗe tʼurzi gen̰n̰o ye. ");
INSERT INTO moz_vpl VALUES ("MT8_29","070_8_29","MAT","8","29","29","Wo a kaamiki an dʼiise ɗollite, anʼde: «Kee Isa Ulo Raa no, ki dehu moo me a tukki kaye me? Kee kʼiido ken̰n̰o kʼay diʼn dabire ki poone onniyo booro tʼa aana ko?» ");
INSERT INTO moz_vpl VALUES ("MT8_30","070_8_30","MAT","8","30","30","Goppoŋ tiŋ geŋ i dʼede torɗo meeda ki kinzir an elso. ");
INSERT INTO moz_vpl VALUES ("MT8_31","070_8_31","MAT","8","31","31","Kane siitanɗani geŋ an i dʼoɓe bey a Isa, anʼde: «Kee kʼay tiʼn lomme maŋ, kʼay tiʼn agibi ay tʼette adda torɗo kinzir ettiyo.» ");
INSERT INTO moz_vpl VALUES ("MT8_32","070_8_32","MAT","8","32","32","Isa yʼan di ruute, yʼede: «Kun tʼaɗɗo!» Iŋkino tʼekki ɗoŋ sire geŋ an tʼuɗɗe, an tʼiide adda kinzirɗari. A kaamiki tʼawwa tʼekki kesse geŋ, torɗo pay tʼa zide okko, kinzirɗari an tʼiɓi adda bar, an tʼinda adda kʼahu. ");
INSERT INTO moz_vpl VALUES ("MT8_33","070_8_33","MAT","8","33","33","Kane ɗoŋ kʼelso geŋ an dʼukke kʼadda geeger, an an tʼîide taaya a sulɗi pay ɗoŋ ize wo a munɗa wede ize a tukki ɗoŋ sire an dʼede siitanɗani a eedaŋ geŋ me. ");
INSERT INTO moz_vpl VALUES ("MT8_34","070_8_34","MAT","8","34","34","Iŋkino maŋ ɗoŋ pay tʼadda geeger an tʼuɗɗo, an tʼette kʼume kʼIsa. Aame an iiney a sirpadí maŋ, an i dʼoɓe bey kono ti siiɗadaŋ yʼa eŋgile. ");
INSERT INTO moz_vpl VALUES ("MT9_1","070_9_1","MAT","9","1","1","Saŋ maŋ Isa yi ti gili adda tooko, yʼa diipiɗa bar sey wo yʼa tʼiide kʼadda geeger ere yi-lekkiyo. ");
INSERT INTO moz_vpl VALUES ("MT9_2","070_9_2","MAT","9","2","2","Ɗoŋ miibi an i dʼumɓo wede ruŋguyuŋ kaŋ moone a zaaɗe. Isa yi wulle kane an ziipe addaŋ a yode maŋ, aame geŋ yi di ruute a wede ruŋguyuŋ, yʼede: «Ulo ki nuŋ ki tʼooɓo addá, olɗikadá nʼa yʼ tʼize tambobino.» ");
INSERT INTO moz_vpl VALUES ("MT9_3","070_9_3","MAT","9","3","3","Iŋkino maŋ i dʼede ɗoŋ suuniyo kʼoogoro miibi an di rootiyto tʼadda kʼaddaŋ, anʼde: «Wede eŋ yi kalɗa suma Raa!» ");
INSERT INTO moz_vpl VALUES ("MT9_4","070_9_4","MAT","9","4","4","Isa elkisadaŋ yʼa ti zuune wo yʼa ruute, yʼede: «Ki moo me un dʼede elkiso ere olɗo adda kʼadduguŋ me? ");
INSERT INTO moz_vpl VALUES ("MT9_5","070_9_5","MAT","9","5","5","Ise laylay a jiire miŋ too me a nuŋ nʼa roote: “Olɗikadá Raa yʼa yʼ tʼize tambobino” kunuŋ, nʼa roote: “Ki tʼoozo wo kʼa oziro” me? ");
INSERT INTO moz_vpl VALUES ("MT9_6","070_9_6","MAT","9","6","6","Wo ni dehu kun di suune, nuŋ wede an nʼehe aa ulo wede eŋ, adda duniya ette o dʼede toogo kʼisiyo tambobino a olɗiko.» Maŋ yi di ruute a wede ruŋguyuŋ, yʼede: «Ki tʼoozo, ki tʼamɓo zaaɗayá, kʼa aaho ɓoozá!» ");
INSERT INTO moz_vpl VALUES ("MT9_7","070_9_7","MAT","9","7","7","Wede geŋ yʼa tʼiiziga wo yʼa aahe ɓoozí. ");
INSERT INTO moz_vpl VALUES ("MT9_8","070_9_8","MAT","9","8","8","Aame ɗoŋ duuru an wulle munɗa wede ize gen̰n̰o maŋ, orgiso tʼanni ziiɗa wo an di tamma Raa wede ele toogo iŋkino a ɗuwo. ");
INSERT INTO moz_vpl VALUES ("MT9_9","070_9_9","MAT","9","9","9","Tiŋ geŋ Isa yʼa iide ɗaana maŋ, a urzi yi wulle wedusu sundí Matiye yi guune a ume naabadí yi seɗɗu jibaaye. Isa yi di ruute, yʼede: «Ki ni daani!» Maŋ yoŋ yʼa tʼiiziga wo yʼa yi diine. ");
INSERT INTO moz_vpl VALUES ("MT9_10","070_9_10","MAT","9","10","10","Isa yʼiideʼŋ yʼa guune omɓo ti sanalliyagí adda ɓoy ki Matiye. Aame an di-guune maŋ, ɗoŋ seɗɗu jibaaye ɓaadaŋ ti ɗoŋ kʼolɗiko oŋgo pây an di guune ti kane kaŋ soo. ");
INSERT INTO moz_vpl VALUES ("MT9_11","070_9_11","MAT","9","11","11","Kane Pariziyeŋ an wulle iŋkino maŋ, an an di ruute a sanalliyagí, anʼde: «Ki moo me wede dooyisaguŋ yi dʼomɓo ti ɗoŋ seɗɗu jibaaye wo ti ɗoŋ kʼolɗiko oŋgo me?» ");
INSERT INTO moz_vpl VALUES ("MT9_12","070_9_12","MAT","9","12","12","Isa yiʼn illiga maŋ, yʼa ruute, yʼede: «Kane ɗoŋ waalin̰ an ki yʼ dehe ye wede daawiya me, wo i yʼ dehe ɗoŋ kʼeeni. ");
INSERT INTO moz_vpl VALUES ("MT9_13","070_9_13","MAT","9","13","13","Kunʼdo, kun ti dooyi ono ɗoŋ Raa yi ruute ti kaaga, yʼede: “Ni dehu kun dʼise adde koɗuwo ti ɗuwo, geŋ i jiire seɗeke ere kun isiyo ki seyɗi.” Ɗerec, nuŋ ni kʼiidoʼŋ waaku kane ɗoŋ ki diine ye, wo ɗe nʼiidoʼŋ waaku kane ɗoŋ kʼolɗiko.» ");
INSERT INTO moz_vpl VALUES ("MT9_14","070_9_14","MAT","9","14","14","Iŋkino maŋ kane sanalliyagi ki Zaŋ Batis an dʼiide an tunde Isa, anʼde: «Ki moo me kane sanalliyagá onniyo muno an ki lekkiyo daa kʼomɓo ye, wo kaciŋ kaye ti kane Pariziyeŋ onniyo muno ay di lekkiyo daa kʼomɓo me?» ");
INSERT INTO moz_vpl VALUES ("MT9_15","070_9_15","MAT","9","15","15","Isa yʼan diʼn gime onamaŋ, yʼede: «Kun elkiyo miŋ ɗoŋ anʼni wiiko a tarnaape seeɗu, an di lekke sommagi dondoŋ koo, aame kule kʼere yoŋ a diinayaŋ maŋ? Aha, iŋkino ye! Wo saŋ onniytagi an dʼaana, aame kule kʼere ti diinayaŋ an ti yʼumɓa maŋ. Aame geŋ kane onniyo muno an di lekka daa kʼomɓo kollo. ");
INSERT INTO moz_vpl VALUES ("MT9_16","070_9_16","MAT","9","16","16","Beehiye ye wenɗa yi dʼamɓe buuɗe kalle aware yʼa-tʼobbira ekki kalle mazzini me, para maŋ buuɗe geŋ yʼa tʼaaɗi kalle gen̰n̰o, a di sittite a ceere sey. ");
INSERT INTO moz_vpl VALUES ("MT9_17","070_9_17","MAT","9","17","17","Wo soŋ beehiye ye wenɗa yi-tʼeepe toote kʼin̰n̰i bin̰ wede oozige ɓotto adda riitile wede mazzini me, para maŋ riitile a ɓatte, toote geŋ a tʼoɓi siiɗo wo riitile a latte pây. Ki too maŋ yi-tʼeepe toote wede oozige ɓotto adda riitile wede aware, wo geŋ a lekke beehiye.» ");
INSERT INTO moz_vpl VALUES ("MT9_18","070_9_18","MAT","9","18","18","Aame Isa yʼan ti rootiyto iŋkino geŋ, i dʼiina wede iŋkino i-dʼede gooliko. Yʼa dʼiide sirpa kʼIsa, yʼa-dikke a ɗaanadí wo yi di ruute, yʼede: «Aŋken̰n̰o eŋ miŋ uto nuŋ tʼa tʼihe. Wo ɗe kʼa ette maŋ, ki zaapey beezá a tuddutú wo tʼa balɗey.» ");
INSERT INTO moz_vpl VALUES ("MT9_19","070_9_19","MAT","9","19","19","Maŋ Isa yʼa tʼiiziga, wo ti sanalliyagí an di diine wede gen̰n̰o. ");
INSERT INTO moz_vpl VALUES ("MT9_20","070_9_20","MAT","9","20","20","Aame an eŋgile geŋ i dʼede erewo soo iŋkino ti dabirsa, puuzo oɓite tʼitatú îide ozzine koomat makumu sire. Iŋkino ti-tʼiide ti dar kʼIsa, tʼa-butte bize kallayí, ");
INSERT INTO moz_vpl VALUES ("MT9_21","070_9_21","MAT","9","21","21","kono tʼa ruute tʼadda kʼaddutú, tʼede: «Aame nʼiina nʼa butta a kallayí ɗaŋŋal toŋ maŋ, nʼa utta tʼeenizó me.» ");
INSERT INTO moz_vpl VALUES ("MT9_22","070_9_22","MAT","9","22","22","Maŋ Isa yʼa gilɗe, yi di wolliyo wo yʼa ruute, yʼede: «Uto ki nuŋ, mi tʼooɓo addí! Kono koŋ mi ziipe addí a nuuno geŋ, mʼutte.» A kaamiki, erewo tʼa uune bee. ");
INSERT INTO moz_vpl VALUES ("MT9_23","070_9_23","MAT","9","23","23","Aame Isa yʼiiney a ɓoy ki wede i-dʼede gooliko gen̰n̰o maŋ, yiʼn uuney ɗuwo an isiyo unto ti siriryagi. ");
INSERT INTO moz_vpl VALUES ("MT9_24","070_9_24","MAT","9","24","24","Maŋ Isa yʼa ruute, yʼede: «Kun tʼaɗɗo tʼadda ɓoy me, kono uto ti kʼinda ye, ti moone moone.» Wo kane ɗuwo geŋ an di yʼokko maade. ");
INSERT INTO moz_vpl VALUES ("MT9_25","070_9_25","MAT","9","25","25","Aame ɗoŋ duuru geŋ an tiʼn uɗɗe maŋ, Isa yi-tʼiide kʼadda biino, yi ziiɗa bey kʼuto wo tʼa tʼiiziga. ");
INSERT INTO moz_vpl VALUES ("MT9_26","070_9_26","MAT","9","26","26","Rabila gette i di tiipe adda siiɗo gette pay. ");
INSERT INTO moz_vpl VALUES ("MT9_27","070_9_27","MAT","9","27","27","Tiŋ geŋ Isa yʼeŋgile maŋ, i dʼede koŋzayi sire iŋkino an di yʼ daaniya, an di ɗollite an dʼeesiyo: «Kee Wede ti biza bumɓu Dawut, kʼiso adde koɗuwo, kʼiso adde koɗuwo!» ");
INSERT INTO moz_vpl VALUES ("MT9_28","070_9_28","MAT","9","28","28","Isa yʼiiney ɓoy wo yi tʼiide adda maŋ, kane koŋzayi gen̰n̰o toŋ an a-tʼiide, wo an a dʼiide sirpadí. Maŋ Isa yʼanni tunde, yʼede: «Kun ziipe adduguŋ ko, nuŋ nʼaane nʼun tʼele beeko me?» Maŋ kane an i tiʼn gime onamí, anʼde: «Eyye Galmeegey, ay ziipe addey.» ");
INSERT INTO moz_vpl VALUES ("MT9_29","070_9_29","MAT","9","29","29","Iŋkino maŋ yʼan buttite a edayaŋ wo yʼa ruute, yʼede: «Munɗa geŋ Raa yʼun ti yʼiso kono kun ziipe adduguŋ a nuuno geŋ me.» ");
INSERT INTO moz_vpl VALUES ("MT9_30","070_9_30","MAT","9","30","30","Wo edayaŋ a tʼihina an di wolliyo. Maŋ Isa yʼan di ruute ti golla zakiɗi, yʼede: «Kun ollo koɗuwo, a wenɗa soo toŋ kun roota ye a munɗa wede ize eŋ me.» ");
INSERT INTO moz_vpl VALUES ("MT9_31","070_9_31","MAT","9","31","31","Wo kane aame an tʼuɗɗe maŋ, an dʼiise rootiyto sundí adda siiɗo gette pay. ");
INSERT INTO moz_vpl VALUES ("MT9_32","070_9_32","MAT","9","32","32","Aame kane an eŋgile geŋ, ɗuwo an i dʼirkiɗo wede soo iŋkino bizí i tʼippe yi kʼorbe ye, kono i-dʼede siitan a eedí. ");
INSERT INTO moz_vpl VALUES ("MT9_33","070_9_33","MAT","9","33","33","Isa yʼa-tʼilmi siitan gette, wo aame ti tʼuɗɗe maŋ, wede bizí i tʼippe geŋ yʼa iise ono. Maŋ kane ɗoŋ duuru geŋ an ziiɗa giggiraŋ, wo an di ruute, anʼde: «A siiɗo kʼIzirayel ette, munɗa kinoʼŋ kaŋ soo toŋ ay ki wulle ye.» ");
INSERT INTO moz_vpl VALUES ("MT9_34","070_9_34","MAT","9","34","34","Wo miŋ kane Pariziyeŋ an di ruute, anʼde: «Geŋ Meeda siitanɗani i eliyo toogo ki lommite siitanɗani me!» ");
INSERT INTO moz_vpl VALUES ("MT9_35","070_9_35","MAT","9","35","35","Adda siiɗo gette Isa yi dʼettiyo geeger ti geeger wo ille ti ille, yi dooyisito ɗuwo adda ɓoyɗi ɗoŋ Yawudiyagi ge dooyiso, yʼan kazita Rabila Majjaanawa ki Moziko Raa, yʼan dʼeliyo beeko a ɗoŋ pay eeni wo ɗoŋ pay an dʼede ita kʼeeni tuuku toŋ maŋ. ");
INSERT INTO moz_vpl VALUES ("MT9_36","070_9_36","MAT","9","36","36","A ɗoŋ duuru pay a ɗaanadí geŋ i di tʼize sommagi, kono kane geŋ an urme wo eedaŋ ti digge aakede damɓami daa wede kʼelsadaŋ. ");
INSERT INTO moz_vpl VALUES ("MT9_37","070_9_37","MAT","9","37","37","Iŋkino maŋ yʼan di ruute a sanalliyagí, yʼede: «Kane ɗoŋ duuru eŋ aa doome goole yʼize kʼayɗu, wo ɗoŋ naabo baata. ");
INSERT INTO moz_vpl VALUES ("MT9_38","070_9_38","MAT","9","38","38","Iŋkino kun tondo wede doome kono yʼa-tʼigibo ɗoŋ naabo kʼayɗu.» ");
INSERT INTO moz_vpl VALUES ("MT10_1","070_10_1","MAT","10","1","1","Isa yʼa-wiike sanalliyagí kane koomat makumu sire, yʼan dʼele toogo ki lommite siitanɗani ɗoŋ an tʼooney a ɗaanadaŋ, an di tʼeley beeko a ɗoŋ an dʼede ita kʼeeni tuuku toŋ maŋ wo a aaɗumutu tudde pay. ");
INSERT INTO moz_vpl VALUES ("MT10_2","070_10_2","MAT","10","2","2","Kun ollo eŋ sumɓiyagi ɗoŋ zina kʼIsa kane koomat makumu sire: ki poone Simo wede sundí soo te Piyer, wo leemadí Andire; Zak ti leemadí Zaŋ, kane sirwaŋ pay in̰n̰i Zebede; ");
INSERT INTO moz_vpl VALUES ("MT10_3","070_10_3","MAT","10","3","3","Pilip ti Bartelemi; Toma wo Matiye wede seɗɗu jibaaye; Taade wo Zak ulo kʼAlpe; ");
INSERT INTO moz_vpl VALUES ("MT10_4","070_10_4","MAT","10","4","4","Simo wede addí wehini kono siiɗadí me, wo Ziidas Iskariyot wede saŋ yʼan di yʼ tʼela Isa a bey ɗoŋ kʼolmiɗayí. ");
INSERT INTO moz_vpl VALUES ("MT10_5","070_10_5","MAT","10","5","5","Kane ɗoŋ koomat makumu sire geŋ, Isa yʼan agisa kʼisiyo naabadí wo yʼan di ruute munɗa wede an dʼisey, yʼede: «Kun ettey ye ki tukki kane ɗoŋ Yawudiyagi ye me, wo kʼadda geeger ki siiɗo Samari soo toŋ kun ettey ye. ");
INSERT INTO moz_vpl VALUES ("MT10_6","070_10_6","MAT","10","6","6","Ki too kun dʼettey ki tukki ɗoŋ kʼIzirayel kane aa damɓami i digge. ");
INSERT INTO moz_vpl VALUES ("MT10_7","070_10_7","MAT","10","7","7","A urzi kun di kazitoy, kun dʼeesoy: “Moziko Raa tʼiina goppoŋ.” ");
INSERT INTO moz_vpl VALUES ("MT10_8","070_10_8","MAT","10","8","8","Ɗoŋ kʼeeni kun an dʼeloy beeko, ɗoŋ unto kun tiʼn balɗoy, ɗoŋ bitiɗe kun an dʼeloy beeko an tʼisoy kamilen̰, siitanɗani kun diʼn olmitoy. Kune sulɗi pay kun uune ki waawiye, wo kun an eloy toŋ ki waawiye. ");
INSERT INTO moz_vpl VALUES ("MT10_9","070_10_9","MAT","10","9","9","Ki torguwaguŋ dap kun amɓa ye, ise soŋko, ise tammiyagi sun̰n̰i sun̰n̰i adda poosaguŋ me, ");
INSERT INTO moz_vpl VALUES ("MT10_10","070_10_10","MAT","10","10","10","ise eese, ise kalle ki sirwe, ise toɓiyagi zoŋ ki sirwe, ise dalka toŋ maŋ. Ɗerec, wede yi naabiyaʼŋ i-dʼede urzi yʼa oomi ti bey ɗoŋ yʼan naabiya. ");
INSERT INTO moz_vpl VALUES ("MT10_11","070_10_11","MAT","10","11","11","Aame kun tʼiidey adda geeger ere tuuku ise adda kʼille tuuku toŋ, kun di tonditoy wede beehiye ede wo yʼunni seeɗa bey sire maŋ, kun di ɗeegoy di yode bini eŋgilsaguŋ. ");
INSERT INTO moz_vpl VALUES ("MT10_12","070_10_12","MAT","10","12","12","A ettiyaguŋ ki ɓoy wede kun ettey geŋ, kun dʼeesoy: “Toose Raa ti koona egguŋ.” ");
INSERT INTO moz_vpl VALUES ("MT10_13","070_10_13","MAT","10","13","13","Aame ɗoŋ ɓoy geŋ an unni ziiɗey maŋ, toose kune tʼa koonoy eedaŋ, wo aame an un kiʼn ziiɗey ye maŋ, toose kune tʼa-kamoy ki tudduguŋ. ");
INSERT INTO moz_vpl VALUES ("MT10_14","070_10_14","MAT","10","14","14","Aame an un kiʼn ziiɗey ye wo onamguŋ an kʼilligey ye maŋ, a eŋgilsaguŋ ti ɓoy gen̰n̰o ise ti geeger gettiyo geŋ, odde zoŋguŋ toŋ kun an ti yʼ tottigoy, geŋ i-kaza Raa ulbí uŋse ye ti kane me. ");
INSERT INTO moz_vpl VALUES ("MT10_15","070_10_15","MAT","10","15","15","Ɗerec iŋkino wo nʼun di rooto: Onniyo ere Raa yi ɗekka booro gette, kane ɗoŋ siiɗo Sodom ti Gomor ti kaaga Raa yʼan igge pay geŋ, booradaŋ tʼa koona soodo ti ɗoŋ ki geeger gettiyo.» ");
INSERT INTO moz_vpl VALUES ("MT10_16","070_10_16","MAT","10","16","16","«Kun ollo, nuŋ nʼun agisa eŋ aakede damɓami kʼadda diine sullibagi. Iŋkino maŋ kun koonoy mentikagi aakede mimbayi, wo tasse aakede deere. ");
INSERT INTO moz_vpl VALUES ("MT10_17","070_10_17","MAT","10","17","17","Kun koonoy mentikagi, kono ɗuwo an un tiʼn seɗɗey, an un diʼn tʼettey kʼume ɗoŋ booro wo an un diʼn gorpipey ti marpa adda ɓoyɗi ɗoŋ an di dooyiso. ");
INSERT INTO moz_vpl VALUES ("MT10_18","070_10_18","MAT","10","18","18","Kono kune ɗoŋzó geŋ, an un diʼn tʼettey ɗaana ɗoŋ deero siiɗo wo ɗaana mozagi. Aame geŋ, a ɗaanadaŋ wo a ɗaana kane ɗoŋ Yawudiyagi ye, kun tʼooney urzi kun di rootey a sulɗi ɗoŋ kun wulle wo kun illiga a tukki nuuno geŋ me. ");
INSERT INTO moz_vpl VALUES ("MT10_19","070_10_19","MAT","10","19","19","Aame an un diʼn tʼiidey kʼume ɗoŋ booro maŋ, ulbuguŋ un tʼooɗey ye a maana kʼono ɗoŋ kun di rootey, ise a munɗa wede kun di rootey me. A ume geŋ miŋ Raa yʼun tʼeley ono ɗoŋ kun di rootey. ");
INSERT INTO moz_vpl VALUES ("MT10_20","070_10_20","MAT","10","20","20","Iŋkino maŋ aame kun rootey geŋ, ono ettey ti suuniyo kune ye, wo unni dokkey Unde ki Meeguguŋ Raa. ");
INSERT INTO moz_vpl VALUES ("MT10_21","070_10_21","MAT","10","21","21","Leema yʼan di yʼ tʼela leemadí a bey ɗuwo ki tôwwadí, wo meege toŋ iŋkino kay a in̰n̰izí me. In̰n̰i an di-kima adu ki maawaŋ, an deha urzi, ɗuwo an di seɗɗa maawaŋ ki tôwwadaŋ. ");
INSERT INTO moz_vpl VALUES ("MT10_22","070_10_22","MAT","10","22","22","Kune ɗoŋ duniya pay an un diʼn olmiɗa kono kun umɓe a sundó, wo ɗe wede yʼa ziiɗa zakiɗi a urzizó bini ɗaŋgu maŋ, yode geŋ Raa yʼa yʼutta. ");
INSERT INTO moz_vpl VALUES ("MT10_23","070_10_23","MAT","10","23","23","Aame adda geeger tuuku an unni dabirsa maŋ, kun tʼomboy ki geeger ti doolo. Ɗerec iŋkino wo nʼun di rooto: Kune geegiryagi ki siiɗo kʼIzirayel geŋ kun ki tiʼn ozira pay ye, ki poone nuŋ wede an nʼehe aa ulo wede eŋ, nʼa kimo me. ");
INSERT INTO moz_vpl VALUES ("MT10_24","070_10_24","MAT","10","24","24","Sanallusu geŋ yoŋ tʼekki wede dooyisadí ye, wo wede naabo toŋ yoŋ tʼekki galmeegí ye. ");
INSERT INTO moz_vpl VALUES ("MT10_25","070_10_25","MAT","10","25","25","Sanallusu geŋ, i dehu yʼa tʼise aa wede dooyisadí ɗaŋŋal, wo wede naabo toŋ iŋkino yʼa tʼise aa galmeegí. Aame nuŋ wede ɓoy ɗuwo an ni kalɗa anʼde nuŋ Belzebul maŋ, kune ɗoŋ ɓoozó an un diʼn kilɗita a ceera sey.» ");
INSERT INTO moz_vpl VALUES ("MT10_26","070_10_26","MAT","10","26","26","«Kune a ɗuwo kun an orgiɗe ye. Sulɗi ɗoŋ pay ombiɗeʼŋ, saŋ onniyo soo a tʼooɗiba ita, wo ono ɗoŋ i ki dehu ɗuwo an kʼolliga ye geŋ, saŋ onniyo soo ɗoŋ pay an diʼn olliga. ");
INSERT INTO moz_vpl VALUES ("MT10_27","070_10_27","MAT","10","27","27","Munɗa wede nʼun rootiyo a zimolo geŋ, kun ti yʼ rooto keren̰, wo munɗa wede an un melin̰so a kuuduguŋ geŋ, kun yi rooto aa kun a ti gili tʼekki biino kun ɗolle. ");
INSERT INTO moz_vpl VALUES ("MT10_28","070_10_28","MAT","10","28","28","Kun an orgiɗe ye a ɗoŋ i tôwwo tudde wo an kʼaane tôwwo kʼunde ye me. Ki too maŋ kun dʼorgiɗe a Raa, yode wede aane i tʼîde tudde ti unde pây adda kʼuwwo. ");
INSERT INTO moz_vpl VALUES ("MT10_29","070_10_29","MAT","10","29","29","Kun suune ooyo sire ɗoo miŋ in tʼowile ti soŋko soo kollo, wo ti diinayaŋ soo toŋ a siiɗo i kʼoore ye, daa ki Galmeeguguŋ Raa yi ki suune ye me. ");
INSERT INTO moz_vpl VALUES ("MT10_30","070_10_30","MAT","10","30","30","Wo ki kune, ilali kʼegguŋ gen̰n̰o toŋ Raa yi tiʼn kaza pay. ");
INSERT INTO moz_vpl VALUES ("MT10_31","070_10_31","MAT","10","31","31","Iŋkino kun orgiɗe ye, kono kune zooyaguŋ yi jiire ooyo ɓaadaŋ!» ");
INSERT INTO moz_vpl VALUES ("MT10_32","070_10_32","MAT","10","32","32","«Wede tuuku yi ruuta a ɗaana ɗuwo yoŋ ki nuuno maŋ, nuŋ toŋ nʼa rootey kay yoŋ ki nuuno, a ɗaana Meegó Raa a kandaane me. ");
INSERT INTO moz_vpl VALUES ("MT10_33","070_10_33","MAT","10","33","33","Wo ɗe wede tuuku yi ruuta a ɗaana ɗuwo yi ki nʼ suune ye maŋ, nuŋ toŋ nʼa rootey ni ki yʼ suune ye kay, a ɗaana Meegó Raa a kandaane me.» ");
INSERT INTO moz_vpl VALUES ("MT10_34","070_10_34","MAT","10","34","34","«Kun elke ye, nuŋ nʼiido nʼun tʼela toose adda duniya me. Nʼa kʼiido ti toose ye, wo ɗe nʼa iido ti ɗeyyiso. ");
INSERT INTO moz_vpl VALUES ("MT10_35","070_10_35","MAT","10","35","35","Eyye, nuŋ nʼiido ulo ti meegí nʼan ahinte, uto ti mettú nʼan ahinte, erewo ti andutú nʼan ahinte. ");
INSERT INTO moz_vpl VALUES ("MT10_36","070_10_36","MAT","10","36","36","Wede tuuku toŋ i di tʼisa ɗoŋ kʼaduzí miŋ, ɗoŋ adda ɓoozí gen̰n̰o. ");
INSERT INTO moz_vpl VALUES ("MT10_37","070_10_37","MAT","10","37","37","Wede yi geyyiso meegí ise meedí a jiire nuuno maŋ, yoŋ geŋ yi kʼîide ki daaniyadó ye. Wede yi geyyiso ulí ise utí a jiire nuuno maŋ, yoŋ geŋ yi kʼîide ki daaniyadó ye. ");
INSERT INTO moz_vpl VALUES ("MT10_38","070_10_38","MAT","10","38","38","Wede yi kʼiyya yʼa ki tʼinda kono nuuno wo yʼa ki nʼ daane ye maŋ, yoŋ geŋ yi kʼîide ki daaniyadó ye. ");
INSERT INTO moz_vpl VALUES ("MT10_39","070_10_39","MAT","10","39","39","Wede yi diha boohiyo tuddí kʼaggadí maŋ, yʼa ti dagga, wo wede yʼiila tuddí kono nuuno maŋ, yʼa tʼutta.» ");
INSERT INTO moz_vpl VALUES ("MT10_40","070_10_40","MAT","10","40","40","«Wede unni seeɗu bey sire maŋ, geŋ aa yi seeɗu nuŋ batum, wo wede yi ni seeɗu bey sire maŋ, geŋ aa yi seeɗu wede i nʼigibo. ");
INSERT INTO moz_vpl VALUES ("MT10_41","070_10_41","MAT","10","41","41","Wede i seeɗu nebi ki Raa kono yoŋ nebi maŋ, munɗa wede Raa yi dehu yi-tʼeley a nebi geŋ, yʼa yi tʼooney kay, wo wede yi seeɗu wede ki diine kono yoŋ ki diine maŋ, munɗa wede Raa yi dehu yi-tʼeley a wede ki diine geŋ, yʼa yi tʼooney kay. ");
INSERT INTO moz_vpl VALUES ("MT10_42","070_10_42","MAT","10","42","42","Ɗerec iŋkino wo nʼun di rooto: Wede tuuku yi eela ahu ŋoyoyo a kulso ɗaŋŋal, a wede soo ɗuwo an yi wolliyo yoŋ n̰eŋku kono yoŋ ti diine sanalliyagó maŋ, munɗa wede Raa yi dehu yi-tʼeley geŋ, yʼa yi tʼooney.» ");
INSERT INTO moz_vpl VALUES ("MT11_1","070_11_1","MAT","11","1","1","Aame Isa yʼa ti ɗiŋge ti rootiyto a munɗa wede kane sanalliyagí koomat makumu sire an dʼisey maŋ, tiŋ geŋ yʼa iŋgile dooyiso ɗuwo wo yi kazita adda geegiryagi ki siiɗo gettiyo. ");
INSERT INTO moz_vpl VALUES ("MT11_2","070_11_2","MAT","11","2","2","Wo Zaŋ Batis yi lekkiyo daŋgay geŋ, yʼa illiga ɗoŋ an tôwwo taaya a naabo kʼAlmasi Raa yi biire. Iŋkino maŋ yi dʼigibe ɗoŋ miibi ti diine sanalliyagí ki tukkʼIsa. ");
INSERT INTO moz_vpl VALUES ("MT11_3","070_11_3","MAT","11","3","3","An iideʼŋ an di yʼ tunde, anʼde: «Kee miŋ Almasi Raa yi biire, saŋ a etto ko? Kunuŋ ay di dello wede doolo ko?» ");
INSERT INTO moz_vpl VALUES ("MT11_4","070_11_4","MAT","11","4","4","Isa yʼan diʼn gime onamaŋ, yʼede: «Kunʼdo a Zaŋ, kun i-tʼôodoy taaya a munɗa wede kun ollige wo kun wolliyo eŋ me: ");
INSERT INTO moz_vpl VALUES ("MT11_5","070_11_5","MAT","11","5","5","Koŋzayi an di wolliyo keren̰, ɗoŋ jekese an sooru beehiye, ɗoŋ bitiɗe an tʼize kamilen̰, duŋgiyagi an dʼollige, ɗoŋ unto an di bilɗe wo Rabila Majjaanawa an an gizite a ɗoŋ an kʼede munɗa ye. ");
INSERT INTO moz_vpl VALUES ("MT11_6","070_11_6","MAT","11","6","6","Wo uŋsuwo a wede yʼa ziiɗa zakiɗi kono nuuno bini ɗaŋgu!» ");
INSERT INTO moz_vpl VALUES ("MT11_7","070_11_7","MAT","11","7","7","Sanalliyagi ki Zaŋ Batis an tʼiŋgile maŋ, aame geŋ Isa yʼa iise rootiyto a ɗoŋ duuru a tukki Zaŋ, yʼede: «Kun iide kʼadda balɗa wolliyo ki moo me? Ki wedusu wede aa alala ere maaye yi tʼagisa gettiyo ko? Aha. ");
INSERT INTO moz_vpl VALUES ("MT11_8","070_11_8","MAT","11","8","8","Ɗe iŋkino kun iide wolliyo ki moo me? Ki wedusu yi tʼusse kallagi majjanɗani ko? Wo ɗe kane ɗoŋ ossiyo kallagi majjanɗani geŋ, an lekkiyo adda ɓoyɗi mozagi. ");
INSERT INTO moz_vpl VALUES ("MT11_9","070_11_9","MAT","11","9","9","Ɗe kun iide wolliyo ki moo me? Ki nebi ko? Eyye, wo kun ollo nʼun di rooto, yoŋ geŋ yi jiire nebi sey. ");
INSERT INTO moz_vpl VALUES ("MT11_10","070_11_10","MAT","11","10","10","Yoŋ geŋ wede an riiŋe ti kaaga adda mattup ki Raa, anʼde: “Kun ollo, nuŋ nʼa tʼigiba wede zindó yʼa ooguma ki poone ti kee, yʼa di tʼokkimey urzizá.”» ");
INSERT INTO moz_vpl VALUES ("MT11_11","070_11_11","MAT","11","11","11","Isa yʼa ruute sey, yʼede: «Ɗerec iŋkino wo nʼun di rooto: Ti diine ɗuwo ɗoŋ pay erayi an ehe geŋ, wede aase goole a ceere Zaŋ Batis umbo. Wo iŋkino toŋ maŋ, wede yoŋ n̰eŋku a jiire adda Moziko Raa geŋ, yoŋ goole yi jiire Zaŋ. ");
INSERT INTO moz_vpl VALUES ("MT11_12","070_11_12","MAT","11","12","12","Tʼume Zaŋ Batis yʼiise naabo Raa bini aŋken̰n̰o geŋ, ɗuwo an dʼeliyo gotono kono an tʼette adda Moziko Raa, wo kane ɗoŋ i ŋaaƴu ki toogo geŋ, an dehu an di-tʼoobe. ");
INSERT INTO moz_vpl VALUES ("MT11_13","070_11_13","MAT","11","13","13","Raa yʼan di ruute a ɗuwo a tukki Mozikadí ere a etto, tʼurzi kʼono ɗoŋ an riiŋe ti kaaga adda mattup kʼoogoro Muusa ti ɗoŋ pay ki nebiyagi, bini aaniya Zaŋ Batis. ");
INSERT INTO moz_vpl VALUES ("MT11_14","070_11_14","MAT","11","14","14","Aame kun dehu kun amɓe maŋ, gen̰n̰o Zaŋ yode wede nebiyagi an ruute, anʼde: “Saŋ Eli yʼa etto me.” ");
INSERT INTO moz_vpl VALUES ("MT11_15","070_11_15","MAT","11","15","15","Wede i-dʼede kuwwa kʼollige maŋ, yʼollo koɗuwo! ");
INSERT INTO moz_vpl VALUES ("MT11_16","070_11_16","MAT","11","16","16","Ɗoŋ aŋken̰n̰o eŋ nʼa tʼeese kane aa wee wee? Kane an deeƴiso aa in̰n̰i an ti guune a bere ɗoŋ duuru, an di waakutu eebaŋ, an dʼeesiyo: ");
INSERT INTO moz_vpl VALUES ("MT11_17","070_11_17","MAT","11","17","17","“Kaye ay un di biiha siraro toŋ maŋ, kun ki dʼimmira ye! Ay un dʼûure ôoro kʼunto toŋ maŋ, kun ki dʼiile ye!” ");
INSERT INTO moz_vpl VALUES ("MT11_18","070_11_18","MAT","11","18","18","Iŋkino Zaŋ yʼiina geŋ, onniyo muno yi lekkiyo daa kʼomɓo, toote kʼin̰n̰i bin̰ yi kʼiiɓe ye, wo ɗuwo an di rootiyo, anʼde: “Yoŋ i-dʼede siitan a eedí!” ");
INSERT INTO moz_vpl VALUES ("MT11_19","070_11_19","MAT","11","19","19","Wo nuŋ wede an nʼehe aa ulo wede eŋ, nʼiina maŋ ni dʼomɓo ni soɓo, wo an di rootiyo, anʼde: “Kun wollo, wede eŋ yʼelkiyo miŋ a omɓo ti soɓo toote kʼin̰n̰i bin̰ ɗaŋŋal, yoŋ laŋze ki ɗoŋ seɗɗu jibaaye wo ti ɗoŋ kʼolɗiko oŋgo.” Wo Raaʼŋ, suuniyo kʼono ere i dʼede, ɗuwo an ti zuune todʼte ki diine tʼurzi naabatú.» ");
INSERT INTO moz_vpl VALUES ("MT11_20","070_11_20","MAT","11","20","20","Adda geegiryagi ɗoŋ Isa yʼa ize sulɗi kʼarmika ɗoŋ a ise ɓaadaŋ geŋ, ɗoŋzaŋ an ki ti gime lekkiyadaŋ ye. Iŋkino maŋ yʼan diʼn iise aapuɗu, yʼede: ");
INSERT INTO moz_vpl VALUES ("MT11_21","070_11_21","MAT","11","21","21","«Dabar a kune ɗoŋ geeger Korazeŋ! Dabar a kune ɗoŋ geeger Betsayda! Ɗerec, aame sulɗi kʼarmika ɗoŋ Raa yʼize di kune geŋ aŋki yʼaase a geeger Tir ti Sidoŋ maŋ, aŋki ti kaagine ɗoŋzaŋ an tʼossite kallagi môolo wo tuddaŋ an aa di kosse puure, wo an di-kime lekkiyadaŋ. ");
INSERT INTO moz_vpl VALUES ("MT11_22","070_11_22","MAT","11","22","22","Eyye, wo kun ollo nʼun di rooto, onniyo ere Raa yi ɗekka booro gette, kane ɗoŋ geeger Tir ti Sidoŋ geŋ booradaŋ tʼa koona soodo ti ere ki kune. ");
INSERT INTO moz_vpl VALUES ("MT11_23","070_11_23","MAT","11","23","23","Wo kune ɗoŋ geeger Kapernayim, kun elkiyo miŋ Raa yʼun tiʼn sika kʼawwa ki kandaane ko? Aha, Raa yʼun tiʼn ɗeega adda diine ɗoŋ unto. Ɗerec, aame sulɗi kʼarmika ɗoŋ ize di kune geŋ, aŋki aase a geeger ki Sodom maŋ, geeger gette aŋken̰n̰o toŋ tʼa lekke sey. ");
INSERT INTO moz_vpl VALUES ("MT11_24","070_11_24","MAT","11","24","24","Kono kamo nʼun di rooto, onniyo ere Raa yi ɗekka booro gette, kane ɗoŋ siiɗo Sodom geŋ booradaŋ tʼa koona soodo ti ere ki kune.» ");
INSERT INTO moz_vpl VALUES ("MT11_25","070_11_25","MAT","11","25","25","Aame geŋ Isa yʼa ruute, yʼede: «Meeʼki nuŋ, kee Galmeeʼki kandaane ti siiɗo, ni ki tamma kono sulɗi eŋ kʼan diʼn umbiɗa a ɗoŋ suuniyo kʼono wo a ɗoŋ eedaŋ soodo a elkiso geŋ me, wo kʼan tʼiiɗiba ita a ɗoŋ aa in̰n̰i sun̰n̰i. ");
INSERT INTO moz_vpl VALUES ("MT11_26","070_11_26","MAT","11","26","26","Eyye Meeʼki nuŋ, geŋ ki dihe sulɗi a tʼise iŋkino. ");
INSERT INTO moz_vpl VALUES ("MT11_27","070_11_27","MAT","11","27","27","Sulɗi pay Meegó Raa yʼo nʼele a beezó, wenɗa soo toŋ a suune Ulo umbo, i yʼ suune Meega ɗaŋŋal. Wo wenɗa soo toŋ a suune Meega umbo, i yʼ suune Ulo wo ti kane ɗoŋ Ulo yi dehu yʼan tʼooɗiba itadí ɗaŋŋal.» ");
INSERT INTO moz_vpl VALUES ("MT11_28","070_11_28","MAT","11","28","28","«Kune ɗoŋ pay i sarkiya attiɗi wede ki ɗoŋ dooyiso kʼoogoro an zaapu egguŋ wo kun urme geŋ, kunʼdi kʼume nuuno, wo nuŋ nʼun tiʼn puuka. ");
INSERT INTO moz_vpl VALUES ("MT11_29","070_11_29","MAT","11","29","29","Kun tʼamɓo talgayó wo kun dʼoziro a urzi dooyisadó, kono nuŋ addó tasse ni ki koliyo tuddó ye, wo kune kun tʼoona puukiyo kʼundiyaguŋ. ");
INSERT INTO moz_vpl VALUES ("MT11_30","070_11_30","MAT","11","30","30","Ɗerec, talgayó yoŋ i kʼoon̰e ye kʼamɓu me, wo attiɗizó wede nʼun tʼela yoŋ soodo ki sarkiya me.» ");
INSERT INTO moz_vpl VALUES ("MT12_1","070_12_1","MAT","12","1","1","Saŋ maŋ a onniyo ere ki puukiyo Yawudiyagi maŋ, Isa yi doopiɗe tʼadda domɓi ɗoŋ ki geme ti sanalliyagí. Aame geŋ kane sanalliyagí mosogo, maŋ an dʼiise sattita geme an di doyɗiso. ");
INSERT INTO moz_vpl VALUES ("MT12_2","070_12_2","MAT","12","2","2","Kane Pariziyeŋ an wulle iŋkino maŋ, an i di ruute Isa, anʼde: «Ki wollo sanalliyagá an dʼisiyo munɗa wede oogiradiŋ ti kʼele urzi kʼisiyo ye a onniyo ere ki puukiyadiŋ te!» ");
INSERT INTO moz_vpl VALUES ("MT12_3","070_12_3","MAT","12","3","3","Wo ɗe Isa yʼan di ruute, yʼede: «Ki kotto kun gire munɗa wede ti kaaga onniyo soo yode Dawut yʼize ti ɗoŋ a itadí, aame mosogo tiʼni ziiɗa geŋ me. ");
INSERT INTO moz_vpl VALUES ("MT12_4","070_12_4","MAT","12","4","4","Yi-tʼiide adda Ɓoy Raa wede an ikkima ki golmodo, yʼa ziki mappa wede an i ele seɗeke a Raa, wo yode ti ɗoŋ a itadí an dʼiimi. Wo Raa yʼan kʼize munɗa ye, ki too maŋ kane an kʼede ye urzi an dʼoomi me, oogiradiŋ tʼele urzi a ɗoŋ seɗeke ɗaŋŋal. ");
INSERT INTO moz_vpl VALUES ("MT12_5","070_12_5","MAT","12","5","5","Ki kotto kun gire adda mattup kʼoogoro Muusa me a onniyo ere ki puukiyadiŋ toŋ, ɗoŋ seɗeke i naabiya adda Ɓoy Raa geŋ, an ki daaniya urzi kʼoogoro kʼonniyo gettiyo ye, an di naabiya, toŋ maŋ booro tʼan kiʼn seeɗu ye. ");
INSERT INTO moz_vpl VALUES ("MT12_6","070_12_6","MAT","12","6","6","Wo kun ollo, nʼun di rooto: a en̰n̰o i dʼede wede ede i jiire Ɓoy Raa! ");
INSERT INTO moz_vpl VALUES ("MT12_7","070_12_7","MAT","12","7","7","Kuneʼŋ ɗuwo eŋ munɗa ulsu an kʼize ye toŋ, kunʼde booro tiʼni ziiɗa. Iŋkino maŋ kun kiʼn zuune ye ita kʼono ɗoŋ an riiŋe ti kaaga adda mattup ki Raa, anʼde: “Ni dehu kun dʼise adde koɗuwo ti ɗuwo, geŋ i jiire seɗeke ere kun isiyo ki seyɗi.”» ");
INSERT INTO moz_vpl VALUES ("MT12_8","070_12_8","MAT","12","8","8","Isa yʼa ruute sey, yʼede: «Nuŋ wede an nʼehe aa ulo wede eŋ, o dʼede urzi kʼisiyo munɗa wede aa addó i dehu ekkʼonniyo ere ki puukiyadiŋ te.» ");
INSERT INTO moz_vpl VALUES ("MT12_9","070_12_9","MAT","12","9","9","Tiŋ geŋ Isa yʼa iŋgile yi-tʼiide adda ɓoy wede Yawudiyagi ge dooyiso. ");
INSERT INTO moz_vpl VALUES ("MT12_10","070_12_10","MAT","12","10","10","Adda ɓoy geŋ i dʼede wedusu soo iŋkino beezí unto. Kane Pariziyeŋ an dehu an tʼoone urzi an di sakiya Isa, kono kamo an di yʼ tunde, anʼde: «Oogiradiŋ urzi tʼele ko, kʼeliyo beeko a onniyo ere ki puukiyadiŋ te?» ");
INSERT INTO moz_vpl VALUES ("MT12_11","070_12_11","MAT","12","11","11","Wo yo Isa yʼan diʼn gime onamaŋ, yʼede: «Ti diinaguŋ eŋ wee wee, aame i-dʼede damsadí soo ɗaŋŋal ti tʼiire adda kʼolɗe sohuru a onniyo ere ki puukiyadiŋ maŋ, yʼa kʼette, tʼadda kʼolɗe yʼa ki tʼaɗɗe ye me? Eyye, yʼa-tʼaɗɗe! ");
INSERT INTO moz_vpl VALUES ("MT12_12","070_12_12","MAT","12","12","12","Wo wedusu geŋ yi jiire damsa taŋ ɓaadaŋ! Geŋ iŋkino oogiradiŋ urzi tʼele a wedusu ki-dʼise beehiye a onniyo ere ki puukiyadiŋ te.» ");
INSERT INTO moz_vpl VALUES ("MT12_13","070_12_13","MAT","12","13","13","Iŋkino maŋ Isa yi di ruute a wede geŋ, yʼede: «Beezá ki yʼonɗo.» Maŋ yʼa yʼunɗe, wo beezí a tʼikkima aakede bakadí soo me. ");
INSERT INTO moz_vpl VALUES ("MT12_14","070_12_14","MAT","12","14","14","Saŋ kane Pariziyeŋ tiŋ geŋ an tʼuɗɗe, an iideʼŋ an tʼugiye, an tʼîide onamaŋ kaŋ soo a tukkʼIsa, an di dehe urzi ki tôwwadí. ");
INSERT INTO moz_vpl VALUES ("MT12_15","070_12_15","MAT","12","15","15","Isa yʼa ti zuune elkiso Pariziyeŋ te, iŋkino maŋ tiŋ geŋ yʼa tʼirga, wo ɗoŋ ɓaadaŋ an di yʼ diine. Ti diinayaŋ ɗoŋ pay eeni yʼan dʼele beeko. ");
INSERT INTO moz_vpl VALUES ("MT12_16","070_12_16","MAT","12","16","16","Wo yʼan di ruute ti golla zakiɗi a ɗuwo, kono an ki roote ye a munɗa wede yʼize me. ");
INSERT INTO moz_vpl VALUES ("MT12_17","070_12_17","MAT","12","17","17","Geŋ iŋkino a iina kono a-tʼette a ono ɗoŋ Raa yi ruute ti kaaga ti bize nebi Ezayi, yʼede: ");
INSERT INTO moz_vpl VALUES ("MT12_18","070_12_18","MAT","12","18","18","«En̰n̰o wede naabadó wede ni biire me, nuŋ ni yʼ giyye ɓaadaŋ, wo ulbó pay uŋse ti yode me. Undó tʼa koona a eedí, wo a ita ɗuwo pay yʼan kizita urzi wede ki diine ki Raa. ");
INSERT INTO moz_vpl VALUES ("MT12_19","070_12_19","MAT","12","19","19","Yi ki deha niikiyto kʼono ulpi ti wenɗa ye, yi ki ɗillita ɗollite ye, wo an kʼolliga golladí a bere ɗoŋ duuru ye. ");
INSERT INTO moz_vpl VALUES ("MT12_20","070_12_20","MAT","12","20","20","Yoŋ yʼa koona tasse ti kane ɗoŋ toogadaŋ umbo me, geŋ aakede alala ere i-guuɗite gette yi ki ti damɓa ye, wo rippinso kʼuwwo ti koddiyo ɓotto gette, yi ki ti tʼîda ye. Yʼaasa iŋkino bini munɗa wede ki diine geŋ yʼa ceera olɗiko. ");
INSERT INTO moz_vpl VALUES ("MT12_21","070_12_21","MAT","12","21","21","Wo ita ɗuwo pay an zaapa elkiyadaŋ a sundí.» ");
INSERT INTO moz_vpl VALUES ("MT12_22","070_12_22","MAT","12","22","22","Saŋ maŋ Isa an i dʼirkiɗo wede soo iŋkino koosiyo wo yi kʼorbe ye, kono i-dʼede siitan a eedí. Wede geŋ Isa yi-dʼele beeko, bizí a tʼihina yʼa iise ono wo yi wolliyo keren̰. ");
INSERT INTO moz_vpl VALUES ("MT12_23","070_12_23","MAT","12","23","23","Kane ɗoŋ duuru geŋ an ziiɗa giggiraŋ wo pay an di ruute, anʼde: «Yode eŋ wede an yi waaku Wede ti biza bumɓu Dawut ye ko?» ");
INSERT INTO moz_vpl VALUES ("MT12_24","070_12_24","MAT","12","24","24","Wo kane Pariziyeŋ an illiga iŋkino maŋ, an di ruute, anʼde: «Wede eŋ, tode Belzebul Meeda siitanɗani i eliyo toogo ki lommite siitanɗani me!» ");
INSERT INTO moz_vpl VALUES ("MT12_25","070_12_25","MAT","12","25","25","Wo Isa yʼa zuune elkisadaŋ, iŋkino maŋ yʼan di ruute, yʼede: «Moziko ere tuuku ɗoŋtú an ɗeyyiso ti tuddaŋ maŋ, mozikadaŋ a latte. Geeger ere tuuku ɗoŋtú an ɗeyyiso ti tuddaŋ, wo adda ɓoy wede tuuku ɗoŋzí an ɗeyyiso ti tuddaŋ maŋ, kane geŋ an kʼaane an ki ti lekke kaŋ soo ye. ");
INSERT INTO moz_vpl VALUES ("MT12_26","070_12_26","MAT","12","26","26","Geŋ iŋkino kay, aame Meeda siitanɗani ti lommite siitanɗani eebutú maŋ, geŋ an ɗeyyiso ti tuddaŋ batum. Wo ɗe geŋ ki kotto mozikatú ti kʼaane ti ki lekke ye! ");
INSERT INTO moz_vpl VALUES ("MT12_27","070_12_27","MAT","12","27","27","Kune kunʼde ni lommite siitanɗani o eliyo toogo Belzebul. Ɗe iŋkino maŋ, ɗoŋ a itaguŋ an lommite siitanɗani ti toogo kʼaaye? Geŋ kane batum an un kaza munɗa wede kun rootiyo a tukki nuuno geŋ ɗerec ye. ");
INSERT INTO moz_vpl VALUES ("MT12_28","070_12_28","MAT","12","28","28","Wo ɗe geŋ, nuŋ o eliyo toogo Unde Raa ni lommite siitanɗani me maŋ, geŋ i-kaza Moziko Raa todʼ tʼiina di kune baa. ");
INSERT INTO moz_vpl VALUES ("MT12_29","070_12_29","MAT","12","29","29","Aame wede yi dehu yi-tʼette adda ɓoy ki wede i-dʼede toogo wo yʼa sikiti sulɗizí maŋ, wede geŋ ki poone yʼa-kettite wede toogo ɗoo miŋ, yʼa aane yʼa sikiti sulɗi tʼadda ɓoy kollo. ");
INSERT INTO moz_vpl VALUES ("MT12_30","070_12_30","MAT","12","30","30","Wede yoŋ ki nuuno yeʼŋ, yoŋ aduzó. Wo wede yʼa ki nʼ noogiyo ki tussiyo yeʼŋ, yoŋ yi teepiyo ki teepiyo. ");
INSERT INTO moz_vpl VALUES ("MT12_31","070_12_31","MAT","12","31","31","Geŋ kono kʼiŋkino, nʼun di rooto, ɗuwo Raa yʼan tʼisa tambobino a olɗiko ere pay an isiyo, ti kalɗita ere pay an kalɗita suma Raa gette. Wo ɗe wede i kalɗita Unde Raa maŋ, a olɗikadí gette Raa yi-kʼisa tambobino ye. ");
INSERT INTO moz_vpl VALUES ("MT12_32","070_12_32","MAT","12","32","32","Wede tuuku yi ruuta munɗa ulsu a tukki nuŋ wede an nʼehe aa ulo wede en̰n̰o maŋ, a olɗikadí gette Raa yi-tʼisa tambobino. Wo ɗe wede tuuku i ruutita munɗa ulsu a tukki Unde Kamilen̰ maŋ, a olɗikadí gette Raa yi-kʼisa tambobino ye, ise adda duniya ere aŋken̰n̰o, ise adda duniya ere ki ɗaana toŋ maŋ.» ");
INSERT INTO moz_vpl VALUES ("MT12_33","070_12_33","MAT","12","33","33","«Aame undumu beehiye maŋ, in̰n̰izí toŋ beehiye pây. Wo aame undumu ulsu maŋ, in̰n̰izí toŋ ulpi kay. Iŋkino maŋ undumu in yi suuniyo tʼurzi kʼin̰n̰izí. ");
INSERT INTO moz_vpl VALUES ("MT12_34","070_12_34","MAT","12","34","34","Kune ɗoŋ ulpi aakede maŋkikagi ɗe! Mummino kun dʼaane kun di roote ono ɗoŋ beehiye me? Ɗerec, munɗa wede ɗuwo an okumso adda kʼaddaŋ gen̰n̰o aɗɗiya ti bizaŋ me. ");
INSERT INTO moz_vpl VALUES ("MT12_35","070_12_35","MAT","12","35","35","Wedusu wede beehiyeʼŋ, beehiyko tʼettiyo ti sulɗi ɗoŋ beehiye yʼukume adda kʼaddí, wo wedusu wede ulsuʼŋ, munɗa ulsu yʼettiyo ti sulɗi ɗoŋ ulpi yʼukume adda kʼaddí. ");
INSERT INTO moz_vpl VALUES ("MT12_36","070_12_36","MAT","12","36","36","Kun ollo, nʼun di rooto: A onniyo ere Raa yi ɗekka booro gette, ɗuwo a ono ɗoŋ pay an ruutite daa kʼurzizaŋ geŋ an dʼoopey eedaŋ. ");
INSERT INTO moz_vpl VALUES ("MT12_37","070_12_37","MAT","12","37","37","Ɗerec, tʼurzi kʼono ɗoŋ aɗɗiya ti bizá, Raa yʼa di roota kee ki diine a ɗaanadí, wo tʼurzi kʼono ɗoŋ aɗɗiya ti bizá, Raa yʼa di roota kee booro ti ki ziiɗa me.» ");
INSERT INTO moz_vpl VALUES ("MT12_38","070_12_38","MAT","12","38","38","Iŋkino maŋ ɗoŋ suuniyo kʼoogoro miibi ti Pariziyeŋ miibi an di tunde Isa, anʼde: «Wede dooyisadey, ay dehu kʼay dʼise munɗa kʼarmika ay di wolle a kize kee Raa yi-kʼigibo.» ");
INSERT INTO moz_vpl VALUES ("MT12_39","070_12_39","MAT","12","39","39","Isa yʼan diʼn gime onamaŋ, yʼede: «Ita ɗuwo ɗoŋ aŋken̰n̰o eŋ, kane ɗoŋ ulpi wo an ki seeɗu urzi Raa ye, an tondiyo munɗa kʼarmika a kize nuŋ Raa yi nʼigibo. Wo armika ti doolo Raa yʼan kʼisa ye, daa ki armika ere Raa yʼize ti kaaga a nebi Zonas ye maŋ. ");
INSERT INTO moz_vpl VALUES ("MT12_40","070_12_40","MAT","12","40","40","Kun suune Zonas geŋ yʼa likke on̰n̰u aɗo wo diɗɗo aɗo adda kʼadde puuniso ere meeda. Iŋkino kay nuŋ wede an nʼehe aa ulo wede eŋ, an di nʼottiba wo nʼa lekka on̰n̰u aɗo wo diɗɗo aɗo adda muuzo. ");
INSERT INTO moz_vpl VALUES ("MT12_41","070_12_41","MAT","12","41","41","A onniyo ere Raa yi ɗekka booro gette, ɗoŋ geeger ki Ninib an dʼooziga ki tukki ɗuwo ɗoŋ aŋken̰n̰o, wo an di roota: “Kuneʼŋ booro tʼunni ziiɗa.” An roota iŋkino kono aame ɗoŋ geeger ki Ninib an illiga Zonas yi gizite urzi kʼono Raa maŋ, an di gime lekkiyadaŋ. Wo a en̰n̰o i dʼede wede ede yʼa jiire Zonas sey. ");
INSERT INTO moz_vpl VALUES ("MT12_42","070_12_42","MAT","12","42","42","A onniyo ere Raa yi ɗekka booro gette, mohita ere ti siiɗo ki kese ɗanɗi tʼa ooziga ki tukki ɗuwo ɗoŋ aŋken̰n̰o, wo tʼan di roota: “Kuneʼŋ booro tʼunni ziiɗa.” Ti roota iŋkino kono todʼ tʼiizigo ti siiɗiyagi ɗoŋ dokki tʼita Raa kono tʼa olliga suuniyo kʼono ere ki Salamoŋ, wo a en̰n̰o i dʼede wede ede yʼa jiire Salamoŋ sey.» ");
INSERT INTO moz_vpl VALUES ("MT12_43","070_12_43","MAT","12","43","43","«Aame siitan gette ti tukki wedusu ti tʼaɗɗiya maŋ, ti dʼeŋgilso kʼadda balɗa dehutu kʼume wede tʼa lekkey, wo ti ki dʼooniyo ye. ");
INSERT INTO moz_vpl VALUES ("MT12_44","070_12_44","MAT","12","44","44","Iŋkino ti rootiyo adda kʼaddutú, ti dʼeesiyo: “Ni-kime kʼadda bindó ere an di nʼilmo.” Wo a kamatú gette, tʼiideʼŋ ti-tʼuuney biino guguba, rookiyo kamilen̰ wo sulɗutú okkime beehiye. ");
INSERT INTO moz_vpl VALUES ("MT12_45","070_12_45","MAT","12","45","45","Iŋkino maŋ ti di kama kʼadda balɗa, tʼa waaku siitanɗani ti doolo sarat bundiɗi a jiire tode sey. An di-kama kaŋ soo, an tʼettiyo adda biino gettiyo i-tʼisiyo ɓoozaŋ. Iŋkino yo wede geŋ, lekkiyadí ere kʼita i-tʼisiyo oon̰e i ceeriyo ere ki poone. Wo geŋ aasa iŋkino kay ki ɗuwo ɗoŋ aŋken̰n̰o ulpi geŋ me.» ");
INSERT INTO moz_vpl VALUES ("MT12_46","070_12_46","MAT","12","46","46","Isa adda ɓoy, a ɗoŋ duuru yʼan ti rootiyto ɓotto, aame geŋ meedí ti zemɓadí an dʼiina, wo an tʼîhira ti paate, an dehu an i di roote. ");
INSERT INTO moz_vpl VALUES ("MT12_47","070_12_47","MAT","12","47","47","Maŋ wede soo iŋkino yi di ruute a Isa, yʼede: «Kʼollo, meedá ti zemɓadá an tʼîhira ti paate, an dehu an a-di roote.» ");
INSERT INTO moz_vpl VALUES ("MT12_48","070_12_48","MAT","12","48","48","Wo ɗe a wede geŋ Isa yi diʼn gime onamí, yʼede: «Ki kotto maŋ, meedó ti zemɓadó aŋ wee wee?» ");
INSERT INTO moz_vpl VALUES ("MT12_49","070_12_49","MAT","12","49","49","Maŋ yʼa dʼuuye beezí ki tukki sanalliyagí wo yʼa ruute, yʼede: «Kun wollo, kane en̰n̰o aŋ meedó ti zemɓadó me. ");
INSERT INTO moz_vpl VALUES ("MT12_50","070_12_50","MAT","12","50","50","Iŋkino maŋ wede tuuku yʼisiyo sulɗi ɗoŋ pay Meegó Raa a kandaane yi dehu geŋ, yode gen̰n̰o leemadó, teemadó wo meedó me.» ");
INSERT INTO moz_vpl VALUES ("MT13_1","070_13_1","MAT","13","1","1","A onniyo gettiyo batum, tʼadda ɓoy Isa yʼa tʼuɗɗe yʼa iŋgile, yʼiideʼŋ yʼa-guune a biza bar. ");
INSERT INTO moz_vpl VALUES ("MT13_2","070_13_2","MAT","13","2","2","Ɗoŋ duuru ɓaadaŋ an di-tʼugiye, iŋkino yi di gili adda tooko, yʼa-guune wo kane ɗoŋ duuru pay an tʼîhira a biza bar. ");
INSERT INTO moz_vpl VALUES ("MT13_3","070_13_3","MAT","13","3","3","Yoŋ yʼan di ruutite sulɗi ɓaadaŋ tʼono ombiɗe, yʼede: «I dʼede wedusu soo iŋkino yi tʼiide korso buzu kʼadda doome. ");
INSERT INTO moz_vpl VALUES ("MT13_4","070_13_4","MAT","13","4","4","Aame yi sakkisa geŋ, buzu oŋgoŋ a-zilɗiti a urzi, emɓi an iidoʼŋ an di-tiɓɓe pay. ");
INSERT INTO moz_vpl VALUES ("MT13_5","070_13_5","MAT","13","5","5","Buzu oŋgoŋ soŋ a-zilɗiti a ume wede tʼaddaʼŋ paŋgiragi, siiɗadí baata. Kane geŋ a tʼuɗɗe kesiko kono siiɗadaŋ soodo. ");
INSERT INTO moz_vpl VALUES ("MT13_6","070_13_6","MAT","13","6","6","Aame peeɗo ti-gilo wo tʼihina maŋ, kane geŋ a tʼigge, a-biiha kono sondayzaŋ i ki ti ɗiige ye. ");
INSERT INTO moz_vpl VALUES ("MT13_7","070_13_7","MAT","13","7","7","Ɗoŋ soŋ a-zilɗiti adda kʼahimagi, kane geŋ a tʼuɗɗe wo ahimagi an iiziga maŋ, an diʼn ippe. ");
INSERT INTO moz_vpl VALUES ("MT13_8","070_13_8","MAT","13","8","8","Ɗoŋ oŋgoŋ soŋ a-zilɗiti a siiɗo ere beehiye, kane geŋ a tʼuɗɗe, an dʼihira wo an dʼehe: ulo muduso soo yʼa ehe in̰n̰i meeda, soŋ ada zoot wo soŋ ada gʼaɗo. ");
INSERT INTO moz_vpl VALUES ("MT13_9","070_13_9","MAT","13","9","9","Wede i-dʼede kuwwa kʼollige maŋ, yʼollo koɗuwo!» ");
INSERT INTO moz_vpl VALUES ("MT13_10","070_13_10","MAT","13","10","10","Iŋkino maŋ kane sanalliyagi an aa dʼiide ki sirpa kʼIsa wo an di yʼ tunde, anʼde: «Ɗe ki moo me kʼan rootiyto a ɗoŋ duuru tʼono ombiɗe me?» ");
INSERT INTO moz_vpl VALUES ("MT13_11","070_13_11","MAT","13","11","11","Yoŋ yʼan diʼn gime onamaŋ, yʼede: «Ni rootiyto iŋkino kono a kuneʼŋ Raa yʼun ele suuniyo ki sulɗi ɗoŋ ombiɗe ki Moziko Raa te, wo a kane geŋ suuniyo gette Raa yʼan kʼele ye. ");
INSERT INTO moz_vpl VALUES ("MT13_12","070_13_12","MAT","13","12","12","Ɗerec, a wede i-dʼede suuniyo geŋ, an i-tʼeela tʼeego i di tʼisa ɓaadaŋ a ceera, wo ɗe a wede i-kʼede suuniyo ye geŋ, ere booloŋ i-dʼede toŋ an i-tʼamɓa. ");
INSERT INTO moz_vpl VALUES ("MT13_13","070_13_13","MAT","13","13","13","Kun ollo, nuŋ nʼan orbe tʼono ombiɗe me kono kane an aane an wolle toŋ, ki kotto munɗa an ki yʼ wolle ye, wo an aane an olliga toŋ, ki kotto munɗa an ki yʼolliga ye wo itadí an ki ti suune ye. ");
INSERT INTO moz_vpl VALUES ("MT13_14","070_13_14","MAT","13","14","14","Geŋ a kane gen̰n̰o a-tʼiide a ono ɗoŋ Raa yʼigibo ti kaaga tʼurzi nebi Ezayi, yʼa ruute, yʼede: “Kune kun dʼolliga keren̰, wo ono itadaŋ kun ki ti suuna ye, kun di wolla keren̰, wo munɗa kun ki yʼ wolla ye. ");
INSERT INTO moz_vpl VALUES ("MT13_15","070_13_15","MAT","13","15","15","Ɗerec, ɗuwo eŋ kuwwagaŋ an a-ti ŋiƴƴe daŋkila kono a kʼolliga ye, edayaŋ an a-tʼippe kono a ki wolle ye, wo an tʼize tuusiyagi kono ono itadaŋ an gi diʼn suune ye. An ize iŋkino kono an ki dehu ye an di-kimo ki tukki nuŋ Raa, nʼan tʼele beeko me.” ");
INSERT INTO moz_vpl VALUES ("MT13_16","070_13_16","MAT","13","16","16","Wo nuŋ nʼa roote, uŋsuwo a kune kono edaguŋ i wolliyo wo kuwwaguŋ ollige. ");
INSERT INTO moz_vpl VALUES ("MT13_17","070_13_17","MAT","13","17","17","Ɗerec iŋkino wo nʼun di rooto: Nebiyagi ɓaadaŋ ti ɗoŋ ki diine ɓaadaŋ an dihe an di wolle munɗa wede kun wolliyo en̰n̰o, wo an gi di yʼ wulle ye. An dihe an dʼolliga munɗa wede kun ollige en̰n̰o, wo an gi di yʼilliga ye.» ");
INSERT INTO moz_vpl VALUES ("MT13_18","070_13_18","MAT","13","18","18","«Iŋkino kun ollo, ette ita kʼono ombiɗe a tukki wede korso. ");
INSERT INTO moz_vpl VALUES ("MT13_19","070_13_19","MAT","13","19","19","Buzu wede i zilɗiti a biza kʼurzi geŋ, i-kaza ɗuwo ɗoŋ ollige ono ki Moziko Raa wo an gi diʼn seeɗu addaŋ ye. Aame geŋ Mohita kʼolɗiko tʼettiyo, ono ɗoŋ an illiga ti tʼoɗɗipe tʼadda kʼaddaŋ me. ");
INSERT INTO moz_vpl VALUES ("MT13_20","070_13_20","MAT","13","20","20","Buzu wede i zilɗiti a ume wede tʼadda paŋgiragi geŋ, i-kaza ɗuwo ɗoŋ ollige ono Raa, kesiko ulbaŋ uŋse an dʼamɓu. ");
INSERT INTO moz_vpl VALUES ("MT13_21","070_13_21","MAT","13","21","21","Wo ɗe ono sottadaŋ ti ki ti ɗeegu adda kʼaddaŋ, an aa ki seeɗu zakiɗi ye. Aame i ettiyo dabar ise ɗuwo anʼni dabirsa kono an umɓe a ono Raa maŋ, kesiko an tʼargu. ");
INSERT INTO moz_vpl VALUES ("MT13_22","070_13_22","MAT","13","22","22","Buzu wede i zilɗiti adda kʼahimagi geŋ, i-kaza ɗuwo ɗoŋ ollige ono Raa, wo ɗe saŋ elkisito a sulɗi duniya ti dehutu kʼurzi maala an diʼn appiya ono geŋ me, an ki dʼohire ye a urzi Raa me. ");
INSERT INTO moz_vpl VALUES ("MT13_23","070_13_23","MAT","13","23","23","Ki ɗaŋgu buzu wede i zilɗiti a siiɗo ere beehiyeʼŋ, i-kaza ɗuwo ɗoŋ ollige ono Raa wo an di suuniyo itadaŋ, an dʼohire a urzi Raa, an aa dʼooniyo eebaŋ ti doolo, aakede ulo muduso soo yʼa ehe in̰n̰i meeda, soŋ ada zoot, wo soŋ ada gʼaɗo.» ");
INSERT INTO moz_vpl VALUES ("MT13_24","070_13_24","MAT","13","24","24","A ɗoŋ duuru geŋ, Isa yʼan dʼiise rootiyo kʼono ombiɗe ti doolo sey, yʼede: «Kun ollo, Moziko Raa todʼ ti deeƴiso aa wedusu yi giira buzu wede beehiye adda doomizí. ");
INSERT INTO moz_vpl VALUES ("MT13_25","070_13_25","MAT","13","25","25","Wo a diɗɗo ɗuwo pay an udige maŋ, aduzí yʼa tʼiide kʼadda doome gen̰n̰o yʼa di giira iizi buŋgari adda kay, wo tuddí yoŋ yʼa aahe. ");
INSERT INTO moz_vpl VALUES ("MT13_26","070_13_26","MAT","13","26","26","Aame mudu geŋ an tʼuɗɗe wo an iise pan̰ita maŋ, iizi buŋgari gen̰n̰o toŋ an di bin̰e kay. ");
INSERT INTO moz_vpl VALUES ("MT13_27","070_13_27","MAT","13","27","27","Iŋkino kane ɗoŋ naabo ki wede ɓoy geŋ, an iidoʼŋ an i di ruute, anʼde: “Galmeegey, para maŋ ki giira buzu wede beehiye adda doome me, ɗe iizi buŋgari geŋ an iido ti too me?” ");
INSERT INTO moz_vpl VALUES ("MT13_28","070_13_28","MAT","13","28","28","Yoŋ yʼan diʼn gime onamaŋ, yʼede: “Geŋ ize aduzó.” Iŋkino maŋ kane ɗoŋ naabo an di yʼ tunde, anʼde: “Ki dehu ay tʼodo iizi buŋgari ay diʼn oɗɗipoy ko?” ");
INSERT INTO moz_vpl VALUES ("MT13_29","070_13_29","MAT","13","29","29","Yoŋ yʼan di ruute, yʼede: “Aha, kunʼte ye, kono kun oɗɗipey iizi buŋgari geŋ, kun a tʼoɗɗipey ti mudu pây. ");
INSERT INTO moz_vpl VALUES ("MT13_30","070_13_30","MAT","13","30","30","Kun oolo an dʼôhira ti mudu kaŋ soo bini onniyo kʼayɗu, aame geŋ nʼan di roota ɗoŋ kʼayɗu, ki poone an di kirɓa iizi buŋgari an di-kettita kʼoggiyadaŋ ɗoo miŋ, saŋ mudu an diʼn tʼaaha kʼadda giiƴayó kollo.”» ");
INSERT INTO moz_vpl VALUES ("MT13_31","070_13_31","MAT","13","31","31","Isa yʼan rootiyo ono ombiɗe ti doolo, yʼede: «Moziko Raa todʼ ti deeƴiso aa ulo kʼundumu soo sundí mutard wedusu yʼa tʼumɓe, yʼa-giira adda doomizí. ");
INSERT INTO moz_vpl VALUES ("MT13_32","070_13_32","MAT","13","32","32","Wo ɗe ulo kʼundumu geŋ yoŋ n̰eŋku a jiire ti diine kʼin̰n̰i kʼinda pay. Aame yi tʼaɗɗiya maŋ, yi dʼisiyo goole i ceeriyo inda ɗoŋ pay adda jineene gen̰n̰o, geŋ emɓi toŋ an dʼappiyta ɓoyɗi ekki layɗayí.» ");
INSERT INTO moz_vpl VALUES ("MT13_33","070_13_33","MAT","13","33","33","Isa yʼan rootiyo ono ombiɗe sey ti doolo, yʼede: «Moziko Raa todʼ ti deeƴiso aa orme erewo ti-sokiyo booloŋ, tʼa-tʼoɓe a moono ɓaadaŋ lootiyo, wo saŋ orme geŋ moono yi-ti tʼoozige pay.» ");
INSERT INTO moz_vpl VALUES ("MT13_34","070_13_34","MAT","13","34","34","A onniyo gette, Isa a dooyisadí ere pay gette yiʼni duuye ɗoŋ duuru tʼono ombiɗe, wo munɗa daa kʼono ombiɗe yʼan ki rootiyo ye. ");
INSERT INTO moz_vpl VALUES ("MT13_35","070_13_35","MAT","13","35","35","Yoŋ yʼize iŋkino kono a-tʼette a ono ɗoŋ nebi yi ruute ti kaaga, yʼede: «Nuŋ ni tʼihina bizó nʼan rootita tʼono ombiɗe, wo nʼan di kizita sulɗi ɗoŋ Raa yi tiʼn umbiɗa tʼume yʼikkima duniya.» ");
INSERT INTO moz_vpl VALUES ("MT13_36","070_13_36","MAT","13","36","36","Iŋkino maŋ ɗoŋ duuru Isa yiʼn iili wo yʼa aahe ɓoy. Maŋ kane sanalliyagí an aa dʼiide sirpadí an di yʼ tunde, anʼde: «Kee kʼay tʼooɗibi ita kʼono ombiɗe a tukkʼiizi buŋgari ɗoŋ adda doome gen̰n̰o.» ");
INSERT INTO moz_vpl VALUES ("MT13_37","070_13_37","MAT","13","37","37","Isa yʼan diʼn gime onamaŋ, yʼede: «Wede i korso buzu beehiye geŋ, nuuno wede an nʼehe aa ulo wede. ");
INSERT INTO moz_vpl VALUES ("MT13_38","070_13_38","MAT","13","38","38","Doome geŋ, duniya. Buzu wede beehiye geŋ, kane ɗoŋ ki Moziko Raa. Iizi buŋgari geŋ, kane ɗoŋ ki Mohita kʼolɗiko. ");
INSERT INTO moz_vpl VALUES ("MT13_39","070_13_39","MAT","13","39","39","Adu wede i giira iizi buŋgari geŋ, tode Meeda siitanɗani. Onniyo kʼayɗu gette, onniyo ere ki ɗaŋgu duniya. Wo ɗoŋ kʼayɗu geŋ, maaleekiyagi. ");
INSERT INTO moz_vpl VALUES ("MT13_40","070_13_40","MAT","13","40","40","Geŋ aakede iizi buŋgari ɗuwo an tʼoɗɗipe an di zebbiyo adda kʼuwwo kʼoggiyo geŋ, aasa iŋkino kay a onniyo ere ki ɗaŋgu duniya te. ");
INSERT INTO moz_vpl VALUES ("MT13_41","070_13_41","MAT","13","41","41","Nuŋ wede an nʼehe aa ulo wede eŋ, nʼa tʼigiba maaleekiyagó an di sika tʼadda diine ɗoŋ ki Mozikadó, kane ɗoŋ pay i tʼeliyo eebaŋ adda kʼolɗiko wo ɗoŋ pay isiyo sulɗi ɗoŋ ulpi geŋ me, ");
INSERT INTO moz_vpl VALUES ("MT13_42","070_13_42","MAT","13","42","42","wo an tiʼn sebbey adda baala kʼuwwo tʼoggiyo ɗala ɗala, ume wede ki ɗollite môolo wo kʼaaɗumu sina. ");
INSERT INTO moz_vpl VALUES ("MT13_43","070_13_43","MAT","13","43","43","Wo kane ɗoŋ ki diine a ɗaana Raa geŋ, an di rilitey aakede peeɗo adda Moziko ki Meegaŋ Raa. Wede i-dʼede kuwwa kʼollige maŋ, yʼollo koɗuwo!» ");
INSERT INTO moz_vpl VALUES ("MT13_44","070_13_44","MAT","13","44","44","«Kun ollo, Moziko Raa todʼ ti deeƴiso aa laale an tʼumbiɗa adda doome, wo wedusu yʼiideʼŋ yʼa yʼuune. Yoŋ wede geŋ laale yi di yʼumbiɗa sey, wo a uŋsuwo ere i-dʼede ɓaadaŋ gette yʼa iŋgile, yʼiideʼŋ sulɗizí pay yʼa tʼiwilto, wo yʼiidoʼŋ yʼa tʼiwila doome gen̰n̰o.» ");
INSERT INTO moz_vpl VALUES ("MT13_45","070_13_45","MAT","13","45","45","«Kun ollo, Moziko Raa todʼ ti deeƴiso sey, aakede wede suuk yi dehutu ɗogoro majjaanawa tuwarwa kar. ");
INSERT INTO moz_vpl VALUES ("MT13_46","070_13_46","MAT","13","46","46","Aame ɗogoro zooyatú oon̰e ɓaadaŋ gette yi tʼuune maŋ, yʼa iŋgile, yʼiideʼŋ sulɗizí pay yʼa tʼiwilto, wo yʼiidoʼŋ yʼaa tʼiwila ɗogoro gettiyo.» ");
INSERT INTO moz_vpl VALUES ("MT13_47","070_13_47","MAT","13","47","47","«Kun ollo sey, Moziko Raa todʼ ti deeƴiso aa lebiɗo an ti seɗɗiyo adda bar, ita puuni ɗoŋ tuuku toŋ pay, ti tʼin sokiyo. ");
INSERT INTO moz_vpl VALUES ("MT13_48","070_13_48","MAT","13","48","48","Aame ôoniyo maŋ ɗoŋ sawwiya an tʼargu a zeŋge, maŋ an di konso, an di beeriyo puuni ɗoŋ kʼomɓo kʼadda kʼeesayaŋ, wo ɗoŋ kʼomɓo ye ki sebbiyo mendaŋ. ");
INSERT INTO moz_vpl VALUES ("MT13_49","070_13_49","MAT","13","49","49","Geŋ a onniyo ere ki ɗaŋgu duniya toŋ aasa iŋkino, maaleekiyagi an dʼetta an diʼn ooyey ɗuwo ɗoŋ ulpi tʼadda diine ɗoŋ ki diine me, ");
INSERT INTO moz_vpl VALUES ("MT13_50","070_13_50","MAT","13","50","50","kono an tiʼn sebbey adda baala kʼuwwo tʼoggiyo ɗala ɗala, ume wede ki ɗollite môolo wo kʼaaɗumu sina.» ");
INSERT INTO moz_vpl VALUES ("MT13_51","070_13_51","MAT","13","51","51","Isa yʼa tunde sanalliyagí, yʼede: «Ono ombiɗe pay geŋ itadaŋ kunʼni zuune ko?» Kane an i-diʼn gime onamí, anʼde: «Eyye, itadaŋ ay ti zuune.» ");
INSERT INTO moz_vpl VALUES ("MT13_52","070_13_52","MAT","13","52","52","Maŋ yoŋ yʼan di ruute, yʼede: «Geŋ iŋkino wede suuniyo kʼoogoro tuuku toŋ yi daaniya urzi ki Moziko Raa maŋ, yoŋ geŋ yi deeƴiso aa wede ɓoy, tʼadda laalayí wede yʼukume geŋ, yi dʼamɓu sulɗi ɗoŋ aware wo sulɗi ɗoŋ mazzini yi naabiya eego.» ");
INSERT INTO moz_vpl VALUES ("MT13_53","070_13_53","MAT","13","53","53","Aame Isa dooyisadí ere tʼono ombiɗe gette yʼa ti ɗiŋge maŋ, tiŋ geŋ yʼa tʼiiziga. ");
INSERT INTO moz_vpl VALUES ("MT13_54","070_13_54","MAT","13","54","54","Wo yʼa iŋgile ki Nazaret geeger ere yʼa ihira. Aame yʼiiney maŋ, yʼa iise dooyiso ɗuwo adda ɓoy wede Yawudiyagi ge dooyiso, wo kane ɗoŋ pay adda ɓoy geŋ an ziiɗa giggiraŋ. Kane an di ruute, anʼde: «Yoŋ yʼuuno suuniyo kʼono ette ti too me, wo mummino yi dʼisiyo sulɗi kʼarmika kino me? ");
INSERT INTO moz_vpl VALUES ("MT13_55","070_13_55","MAT","13","55","55","Yo eŋ ulo ki wede kʼâhuntu sarpaŋje ɗe me! Tode meedí tiŋ sundutú Mariyam ɗe te! Kane zemɓadí kuuliʼŋ sumɓiyagaŋ Zak, Yusup, Simo wo Ziid ɗe me! ");
INSERT INTO moz_vpl VALUES ("MT13_56","070_13_56","MAT","13","56","56","Wo zemɓadí erayi toŋ kane an lekkiyo pay ti kine ɗe me! Toogo ti suuniyo kʼono kino eŋ, yʼa uuno ti too me?» ");
INSERT INTO moz_vpl VALUES ("MT13_57","070_13_57","MAT","13","57","57","Kono kʼiŋkino an di-tuuge kʼamɓu onamí me. Maŋ Isa yʼan di ruute, yʼede: «Ɗerec, nebi geŋ aame tuuku toŋ onamí an dʼollige, wo ɗe ɗoŋ a geeger ere yʼa ihira ti ɗoŋ adda ɓoozí ɗaŋŋal, onamí an kʼolliga ye me.» ");
INSERT INTO moz_vpl VALUES ("MT13_58","070_13_58","MAT","13","58","58","Wo a ume geŋ sulɗi kʼarmika Isa yi kʼize ɓaadaŋ ye, kono kane an ki ziipe addaŋ a yode ye. ");
INSERT INTO moz_vpl VALUES ("MT14_1","070_14_1","MAT","14","1","1","Aame geŋ Erod yoŋ wede goole yi dokkiyo siiɗo Galile, yʼa illiga suma kʼIsa ti môolo. ");
INSERT INTO moz_vpl VALUES ("MT14_2","070_14_2","MAT","14","2","2","Maŋ yʼan di ruute ɗoŋ naabadí, yʼede: «Wede geŋ yoŋ Zaŋ Batis! Yi bilɗo ti diine ɗoŋ unto, geŋ kono kʼiŋkino i-dʼede toogo yi dʼisiyto sulɗi kʼarmika me.» ");
INSERT INTO moz_vpl VALUES ("MT14_3","070_14_3","MAT","14","3","4","Erod yʼilke iŋkino kono yi-ziiɗa ere leemadí Pilip sundutú Erodiyas, wo Zaŋ Batis yi di ruute, yʼede: «Oogoro urzi ti kʼele ye kʼa seeɗa erewo gette.» Iŋkino maŋ Erod yʼan di ruute a asigiryagi an ti yʼ ziiɗo Zaŋ me, an ti yʼ gittite wo an ti yʼ ziɗɗe adda daŋgay. ");
INSERT INTO moz_vpl VALUES ("MT14_5","070_14_5","MAT","14","5","5","Erod yi dehu Zaŋ asigiryagí an di yʼ tʼîde, wo ɗe yʼan dʼorgiso a Yawudiyagi kono kane pay an zuune adda kʼaddaŋ Zaŋ geŋ yoŋ nebi. ");
INSERT INTO moz_vpl VALUES ("MT14_6","070_14_6","MAT","14","6","6","Ozzine ti ozzine, onniyo kʼehiyo kʼErod tʼaaniya maŋ, an dʼisiyo tarnaape. Iŋkino onniyo gette tʼiina maŋ, uto koŋso kʼErodiyas tʼa immira a ɗaana ki ɗoŋ anʼni wiiko, wo a tode gette Erod addí i-dʼiɓi. ");
INSERT INTO moz_vpl VALUES ("MT14_7","070_14_7","MAT","14","7","7","Iŋkino maŋ yʼa-ti nîime tuddí, yʼede: «Munɗa wede tuuku mi dehuʼŋ mi rooto, wo ni di tʼela.» ");
INSERT INTO moz_vpl VALUES ("MT14_8","070_14_8","MAT","14","8","8","Mettú Erodiyas ti di tʼelite ono, maŋ uto koŋso ti di ruute Erod, tʼede: «Aŋken̰n̰o kʼo ti ɗekki eego Zaŋ Batis, kʼo di zaapi adda supira, wo kʼo dʼadi ken̰n̰o!» ");
INSERT INTO moz_vpl VALUES ("MT14_9","070_14_9","MAT","14","9","9","Aame geŋ mozigo yʼa tʼize sommagi dondoŋ, wo ɗe kono yʼa ti nîime tuddí a ɗaana ɗoŋ anʼni wiiko geŋ, yʼa iyye yʼan di ruute a asigiryagí an di-ɗekko eego Zaŋ, an i tʼela. ");
INSERT INTO moz_vpl VALUES ("MT14_10","070_14_10","MAT","14","10","10","Iŋkino maŋ yʼan igibe kʼadda daŋgay an di ɗikko eego Zaŋ te. ");
INSERT INTO moz_vpl VALUES ("MT14_11","070_14_11","MAT","14","11","11","Eego an tʼumɓo adda supira, an i dʼele a uto koŋso wo todʼ ti dʼiide a mettú. ");
INSERT INTO moz_vpl VALUES ("MT14_12","070_14_12","MAT","14","12","12","Wo kane sanalliyagi Zaŋ an dʼiido, nuune an tʼumɓe an tʼittiba. Saŋ an dʼiŋgile kʼume kʼIsa, an iideʼŋ an i tʼîide taaya a munɗa wede ize. ");
INSERT INTO moz_vpl VALUES ("MT14_13","070_14_13","MAT","14","13","13","Aame Isa yʼilliga taaya gettiyo maŋ, tiŋ geŋ yi di gili adda tooko yʼa diipiɗa bar kono yʼa tʼarga siidí kʼadda balɗa. Wo kane ɗoŋ duuru geŋ umayí an di yʼilliga, an tʼuɗɗito tʼadda geegiryagi ɗoŋ go-goppoŋ geŋ me, wo an di yʼ diine ti zoŋɗaŋ. ");
INSERT INTO moz_vpl VALUES ("MT14_14","070_14_14","MAT","14","14","14","Isa yi ti ɗiige ti tooko maŋ, yi wolliyo ɗoŋ duuru ɓaadaŋ, wo i di tʼize sommagi a ɗuwo geŋ me, yʼan dʼiise eliyo beeko a ɗoŋ kʼeeni a diinayaŋ. ");
INSERT INTO moz_vpl VALUES ("MT14_15","070_14_15","MAT","14","15","15","A peeɗo ti tʼaahe kʼooriyo maŋ, sanalliyagi kʼIsa an a dʼiide sirpadí wo an i di ruute, anʼde: «Kʼollo, ume eŋ balɗa wo peeɗo toŋ tʼiŋgile, iŋkino maŋ ɗuwo pay eŋ kʼan eezo an tʼette kʼadda kʼilliyagi an dʼowiltey munɗa kʼomɓo.» ");
INSERT INTO moz_vpl VALUES ("MT14_16","070_14_16","MAT","14","16","16","Wo Isa yʼan di ruute, yʼede: «I kʼise ye an dʼeŋgile me, omɓo an eelo kune batum.» ");
INSERT INTO moz_vpl VALUES ("MT14_17","070_14_17","MAT","14","17","17","Maŋ kane an di ruute, anʼde: «A en̰n̰o kaye ay dʼede miŋ mappa paat wo puuni sire ɗaŋŋal.» ");
INSERT INTO moz_vpl VALUES ("MT14_18","070_14_18","MAT","14","18","18","Yo Isa yʼan di ruute, yʼede: «Kane geŋ, kun o dʼedi ken̰n̰o.» ");
INSERT INTO moz_vpl VALUES ("MT14_19","070_14_19","MAT","14","19","19","Maŋ yʼan di ruute a ɗoŋ duuru an di-koone adda soole, saŋ yʼa-ziki mappa paat ti puuni sire gen̰n̰o, yʼa tʼumɓe edayí kʼawwa ki kandaane, yʼa ruute koɗuwo a Raa. Maŋ mappa yʼa ɓurkite, yʼan dʼele a sanalliyagi wo kane an an di dikkiɗa a ɗoŋ duuru gen̰n̰o. ");
INSERT INTO moz_vpl VALUES ("MT14_20","070_14_20","MAT","14","20","20","Kane pay geŋ an dʼiimi wo an dʼisse. Wo omɓo ere uupite sanalliyagi an ti-tusse, a ûune dappa koomat makumu sire. ");
INSERT INTO moz_vpl VALUES ("MT14_21","070_14_21","MAT","14","21","21","Kane ɗoŋ iimi geŋ, an tʼîde kuuli suma dupu paat, daa kaza kʼerayi wo in̰n̰i. ");
INSERT INTO moz_vpl VALUES ("MT14_22","070_14_22","MAT","14","22","22","Saŋ maŋ kesiko Isa yʼan di ruute a sanalliyagi, an di-kili adda tooko kono an dʼoogume, an di doopiɗa ti dar bar ti nee, koore yoŋ ɗoŋ duuru yi-tiʼn tʼigiba geŋ me. ");
INSERT INTO moz_vpl VALUES ("MT14_23","070_14_23","MAT","14","23","23","Aame ɗoŋ duuru yi tiʼn igibe maŋ, yoŋ yʼa-ti gili ekki kesse kono yʼa tonde Raa siidí. Wo siidí yʼa tunde Raa a ume gen̰n̰o, bini ume a-tʼize diɗɗo. ");
INSERT INTO moz_vpl VALUES ("MT14_24","070_14_24","MAT","14","24","24","Aame geŋ tooko todʼte dokki ɓotto ti zeŋge me. Wo maaye a giggiraŋ, iŋkino ahu i-kolzite ɓaadaŋ i dʼoɓe dubusuk dubusuk ekki tooko. ");
INSERT INTO moz_vpl VALUES ("MT14_25","070_14_25","MAT","14","25","25","A diɗɗo biza soohe maŋ Isa yi-tʼuɗɗo, yi sooru tʼekkʼahu yi dʼettiyo tukki sanalliyagí. ");
INSERT INTO moz_vpl VALUES ("MT14_26","070_14_26","MAT","14","26","26","Aame kane an yi wulle yi sooru tʼekkʼahu maŋ, orgiso tʼanni ziiɗa ɓaadaŋ wo an di ruute, anʼde: «Eŋ beyye!» Wo a orgisadaŋ gette an dʼiise ɗollite. ");
INSERT INTO moz_vpl VALUES ("MT14_27","070_14_27","MAT","14","27","27","Kesiko Isa yʼan di ruute, yʼede: «Kun omɓon̰! Kun orgiɗe ye, eŋ nuuno!» ");
INSERT INTO moz_vpl VALUES ("MT14_28","070_14_28","MAT","14","28","28","Maŋ Piyer yʼa tʼihina bizí yi di ruute, yʼede: «Galmeeʼki nuŋ, eŋ ki kotto kee maŋ, kʼo eli urzi nʼa ozire tʼekkʼahu, nʼa ette kʼume kee.» ");
INSERT INTO moz_vpl VALUES ("MT14_29","070_14_29","MAT","14","29","29","Isa yʼa ruute, yʼede: «Ki tʼedi!» Maŋ Piyer tʼadda tooko yi-ti ɗiige, yʼa iise sooru tʼekkʼahu, yi dʼettiyo tukkʼIsa. ");
INSERT INTO moz_vpl VALUES ("MT14_30","070_14_30","MAT","14","30","30","Wo aame yʼuwwe maaye yi tûuke ɓaadaŋ maŋ, orgiso tʼa yi ziiɗa, yʼa iise sooyiso kʼadda kʼahu wo yi ɗollite, yi dʼeesiyo: «Galmeeʼki nuŋ, ki nʼutti, ki nʼutti!» ");
INSERT INTO moz_vpl VALUES ("MT14_31","070_14_31","MAT","14","31","31","A kaamiki Isa yʼa igibe beezí, yʼa yi ziiɗa Piyer me, wo yi di ruute, yʼede: «Kee zaapu kʼaddá a nuuno baata, ki moo me ki niiku me?» ");
INSERT INTO moz_vpl VALUES ("MT14_32","070_14_32","MAT","14","32","32","Wo aame kane sirwaŋ an ti gili adda tooko maŋ, maaye yʼa ziiɗa. ");
INSERT INTO moz_vpl VALUES ("MT14_33","070_14_33","MAT","14","33","33","Iŋkino maŋ kane pay adda tooko geŋ an di dikke a ɗaana kʼIsa, wo an i di ruute, anʼde: «Ki kotto keeʼŋ Ulo Raa!» ");
INSERT INTO moz_vpl VALUES ("MT14_34","070_14_34","MAT","14","34","34","An ti diipiɗa bar maŋ, an dʼiiney a siiɗo Zenezaret. ");
INSERT INTO moz_vpl VALUES ("MT14_35","070_14_35","MAT","14","35","35","Kane ɗoŋ siiɗo gette Isa an di yʼ zuune, maŋ rabiladí an ti-tiipe adda siiɗo pay, wo ɗoŋ kʼeeni pay an i di ziko. ");
INSERT INTO moz_vpl VALUES ("MT14_36","070_14_36","MAT","14","36","36","Kane ɗuwo geŋ, an i dʼoɓe bey kono ɗoŋ kʼeeni an a-botte a bize kallayí ɗaŋŋal toŋ maŋ, wo kane ɗoŋ pay a bottiyo geŋ an dʼuttiyo. ");
INSERT INTO moz_vpl VALUES ("MT15_1","070_15_1","MAT","15","1","1","Saŋ maŋ ɗoŋ miibi ti diine Pariziyeŋ ti ɗoŋ suuniyo kʼoogoro iido ti Zeruzalem, an dʼiide kʼume kʼIsa wo an di yʼ tunde, anʼde: ");
INSERT INTO moz_vpl VALUES ("MT15_2","070_15_2","MAT","15","2","2","«Ki moo me sanalliyagá an a-ti doopiɗe a dooyiso ere ki moŋgiɗagiŋ an duuye te? Kʼollo, ki poone an tʼeesa omɓo geŋ, beyɗaŋ an kʼopilso ye aa moŋgiɗagiŋ an ruute me.» ");
INSERT INTO moz_vpl VALUES ("MT15_3","070_15_3","MAT","15","3","3","Isa yʼan diʼn gime onamaŋ, yʼede: «Wo kuneʼŋ, ki moo me kun a-ti doopiɗe a urzi kʼoogoro ere ki Raa, wo kun di sooru a urzi dooyisaguŋ me? ");
INSERT INTO moz_vpl VALUES ("MT15_4","070_15_4","MAT","15","4","4","Ɗerec, Raa yi ruute ti kaaga, yʼede: “Ki elo suma a meegá ti meedá.” Wo soŋ yʼede: “Wede yi duuɗiyo meegí ise meedí koo maŋ, yoŋ geŋ ki tôwwo.” ");
INSERT INTO moz_vpl VALUES ("MT15_5","070_15_5","MAT","15","5","5","Wo ɗe kuneʼŋ, kun dooyiso ɗuwo, kunʼde: “Wede tuuku yi rootiyo a meegí ise a meedí, yʼede: Munɗa wede nʼa-di tʼele a gi di nooge, yoŋ ni ele seɗeke a Raa. ");
INSERT INTO moz_vpl VALUES ("MT15_6","070_15_6","MAT","15","6","6","Maŋ yode geŋ yi ki tʼize ye munɗa wede i-tʼele suma a meegí me.” Kun isiyo iŋkino geŋ, kun ti tôwwo ono ɗoŋ Raa yi ruute kun dʼise me, wo kun di sooru a urzi dooyisaguŋ. ");
INSERT INTO moz_vpl VALUES ("MT15_7","070_15_7","MAT","15","7","7","Kune ɗoŋ biziguŋ sire sire, nebi Ezayi yi ruute ono ɗoŋ Raa yʼigibo a tukki kune geŋ ɗerec, aame yi ruute ti kaaga, yʼede: ");
INSERT INTO moz_vpl VALUES ("MT15_8","070_15_8","MAT","15","8","8","“Ɗuwo eŋ an o eliyo suma tʼono bizaŋ, wo ɗe ki kotto adda kʼaddaŋ kane dokki ti nuŋ Raa me. ");
INSERT INTO moz_vpl VALUES ("MT15_9","070_15_9","MAT","15","9","9","Kane sulɗi ɗoŋ an isiyo kono an o ottilso geŋ ki bita, kono urziyagi kʼoogoro ɗoŋ an dooyiso geŋ ettiyo tʼurzi ɗuwo ɗaŋŋal.”» ");
INSERT INTO moz_vpl VALUES ("MT15_10","070_15_10","MAT","15","10","10","Saŋ Isa yʼa wiike ɗoŋ duuru an tʼiide kʼume yode, wo yʼan di ruute, yʼede: «Kun ollo, wo ono eŋ itadaŋ kun diʼn suuno: ");
INSERT INTO moz_vpl VALUES ("MT15_11","070_15_11","MAT","15","11","11","Sulɗi ɗoŋ pay wedusu yʼoomi geŋ, i ki yʼise ganigi ye a ɗaana Raa me, ki too maŋ i yʼise ganigi a ɗaana Raa munɗa wede aɗɗiya ti bizí gen̰n̰o.» ");
INSERT INTO moz_vpl VALUES ("MT15_12","070_15_12","MAT","15","12","12","Iŋkino maŋ kane sanalliyagi an a dʼiide sirpa kʼIsa wo an i di ruute, anʼde: «Kee ki suune ɗey ko, kane Pariziyeŋ a onamá ɗoŋ an illiga geŋ, kane iʼn uun̰e me?» ");
INSERT INTO moz_vpl VALUES ("MT15_13","070_15_13","MAT","15","13","13","Yʼan diʼn gime onamaŋ, yʼede: «Kane Pariziyeŋ geŋ aakede inda ɗoŋ Meegó Raa a kandaane yi kʼiite ye, wo kane pay geŋ yʼan oɗɗipa. ");
INSERT INTO moz_vpl VALUES ("MT15_14","070_15_14","MAT","15","14","14","Kane geŋ kun oolo, kane aakede koŋzayi, an dokkiyo koŋzayi eebaŋ! Wo ɗe aame wede koosiyo yʼarkuɗu koosiyo bakadí maŋ, sirwaŋ pay an di silɗiti adda kʼolɗe.» ");
INSERT INTO moz_vpl VALUES ("MT15_15","070_15_15","MAT","15","15","15","Maŋ Piyer yʼa tʼihina bizí wo yi di ruute, yʼede: «Kʼay tʼooɗibi ita a ono ombiɗe eŋ me.» ");
INSERT INTO moz_vpl VALUES ("MT15_16","070_15_16","MAT","15","16","16","Isa yʼa ruute, yʼede: «Ki kotto, kune toŋ onamó egguŋ ti kʼaane ti kiʼn seeɗa ye pi me! ");
INSERT INTO moz_vpl VALUES ("MT15_17","070_15_17","MAT","15","17","17","Kun ki suune ye ko, sulɗi ɗoŋ pay wedusu yʼoomi geŋ i-ti ɗeegu adda kʼaddí, wo saŋ yi-tiʼn naamiya me? ");
INSERT INTO moz_vpl VALUES ("MT15_18","070_15_18","MAT","15","18","18","Wo ono ɗoŋ aɗɗiya ti bize geŋ ettiyo ti biza kʼulbe, wo kane gen̰n̰o i-ti yʼisiyo wedeʼŋ ganigi a ɗaana Raa me. ");
INSERT INTO moz_vpl VALUES ("MT15_19","070_15_19","MAT","15","19","19","Ɗerec, ti biza kʼulbe gen̰n̰o ettiyo elkiso ere olɗo i-ti yʼeliyo wedeʼŋ a sulɗi ɗoŋ ulpi aakede: tôwwo ɗuwo mirsi, moone tʼere bakadí ise ti kule bakatú, boliyo, oogire, rootiyo kʼono butte a tukki bakadá a ɗaana booro, wo kalɗita tudde. ");
INSERT INTO moz_vpl VALUES ("MT15_20","070_15_20","MAT","15","20","20","Kane sulɗi gen̰n̰o ɗoŋ i-ti yʼisiyo wedeʼŋ ganigi a ɗaana Raa me! Wo ɗe urzi kʼomɓo daa kʼopilso bey aa moŋgiɗagi an ruute geŋ, wedeʼŋ i ki yʼise ganigi ye a ɗaana Raa me.» ");
INSERT INTO moz_vpl VALUES ("MT15_21","070_15_21","MAT","15","21","21","Saŋ maŋ tiŋ geŋ Isa yʼa tʼiiziga, yʼa iŋgile ki siiɗo ere i ɗuule geeger Tir kane ti Sidoŋ. ");
INSERT INTO moz_vpl VALUES ("MT15_22","070_15_22","MAT","15","22","22","Wo aame geŋ i dʼede erewo todʼte ti siiɗo Kanahaŋ ti lekkiyo adda siiɗo gettiyo, tʼa iido tukkʼIsa tʼa iise ɗollite, tʼede: «Galmeega, kee Wede ti biza bumɓu Dawut, kʼiso adde koɗuwo! Uto nuŋ i-dʼede siitan a ettú wo ti dabirsa ɓaadaŋ.» ");
INSERT INTO moz_vpl VALUES ("MT15_23","070_15_23","MAT","15","23","23","Wo yoŋ onamtú yi-kiʼn gime ye. Kane sanalliyagí an a dʼiide sirpadí wo an di yʼ tunde, anʼde: «Erewo gette ki ti-kama, kono tʼinni daaniya ti ɗollite wo ti kʼannugu ye.» ");
INSERT INTO moz_vpl VALUES ("MT15_24","070_15_24","MAT","15","24","24","Isa yʼan diʼn gime onamaŋ, yʼede: «Nuŋ Raa yi nʼigibo ki tukki ɗoŋ kʼIzirayel ɗaŋŋal, kane aa damɓami ɗoŋ i digge.» ");
INSERT INTO moz_vpl VALUES ("MT15_25","070_15_25","MAT","15","25","25","Wo erewo gette tʼiideʼŋ, tʼa dikke a ɗaanadí wo ti di ruute, tʼede: «Galmeega, kʼedi kʼa ni noogi!» ");
INSERT INTO moz_vpl VALUES ("MT15_26","070_15_26","MAT","15","26","26","Yoŋ yi diʼn gime onamtú, yʼede: «Beehiye ye kʼa tʼamɓe omɓo kʼin̰n̰i, kʼan di tʼele a gahiti me.» ");
INSERT INTO moz_vpl VALUES ("MT15_27","070_15_27","MAT","15","27","27","Maŋ todʼ ti di ruute, tʼede: «Galmeega onamá geŋ ɗerec, wo ki kotto kane gahiti gen̰n̰o toŋ omɓo ere i solɗite ti bey galmaawaŋ aame an omɓo geŋ, an di pettiyo.» ");
INSERT INTO moz_vpl VALUES ("MT15_28","070_15_28","MAT","15","28","28","Iŋkino maŋ Isa yi diʼn gime onamtú, yʼede: «Erewo no, koŋ zaapu kʼaddí a nuuno ɓaadaŋ geŋ, Raa yi elo munɗa wede addí i dehu.» Wo a kaamiki ututú tʼa uune bee. ");
INSERT INTO moz_vpl VALUES ("MT15_29","070_15_29","MAT","15","29","29","Saŋ maŋ tʼume geŋ, Isa yʼa tʼiiziga wo yʼa iŋgile ki biza bar ki Galile. Yʼa-ti gili ekki kesse wo yʼa-guune. ");
INSERT INTO moz_vpl VALUES ("MT15_30","070_15_30","MAT","15","30","30","Ɗoŋ duuru ɓaadaŋ an dʼettiyo ki tuddí, an di ziko ti kane ɗoŋ jekese, ɗoŋ koŋzayi, ɗoŋ kesiyagaŋ soo soo, ɗoŋ bizaŋ a tʼippe an kʼorbe ye, wo ɗoŋ kʼeeni ɓaadaŋ ti doolo toŋ ede. Kane geŋ, ɗoŋ duuru an tiʼn zippe a ɗaana kʼIsa wo yoŋ yʼan dʼele beeko. ");
INSERT INTO moz_vpl VALUES ("MT15_31","070_15_31","MAT","15","31","31","Kane ɗuwo geŋ an ziiɗa giggiraŋ aame an wulle ɗoŋ bizaŋ a tʼippe an orbe, ɗoŋ kesiyagaŋ soo soo an tʼikkima, ɗoŋ jekese an di sooru beehiye, wo ɗoŋ koŋzayi an di wolliyo. Wo kane pay geŋ an dʼiise tamma Raa wede ki ɗoŋ kʼIzirayel. ");
INSERT INTO moz_vpl VALUES ("MT15_32","070_15_32","MAT","15","32","32","Isa yʼa wiike sanalliyagí wo yʼan di ruute, yʼede: «Nuŋ ɗuwo eŋ o tʼize sommagi kono kun wollo an lekkiyo ti nuŋ îide onniyo aɗo, wo aŋken̰n̰o munɗa kʼomɓo an kʼede ye. Ni ki dehu nʼan ki tiʼn tʼigibe addaŋ guguba ye, para maŋ an dʼoopey a urzi.» ");
INSERT INTO moz_vpl VALUES ("MT15_33","070_15_33","MAT","15","33","33","Kane sanalliyagi an di tunde, anʼde: «Ɗe adda balɗa ette, ti too me in tʼoona mappa ɓaadaŋ a ɗoŋ duuru kino eŋ an dʼooma an tʼassa me?» ");
INSERT INTO moz_vpl VALUES ("MT15_34","070_15_34","MAT","15","34","34","Maŋ Isa yʼan diʼn tunde, yʼede: «Kune un dʼede mappa miibi me?» Wo kane an i di ruute, anʼde: «Ay dʼede mappa sarat, ti puuni sun̰n̰i miibi.» ");
INSERT INTO moz_vpl VALUES ("MT15_35","070_15_35","MAT","15","35","35","Iŋkino yʼan di ruute a ɗoŋ duuru geŋ, yʼede: «Kun ti koona siiɗo!» ");
INSERT INTO moz_vpl VALUES ("MT15_36","070_15_36","MAT","15","36","36","Maŋ yʼa ziki mappa sarat ti puuni geŋ a beezí, yʼa ruute koɗuwo a Raa, yʼa ɓurkite wo yʼan dʼele a sanalliyagi an an di-dikkiɗa a ɗoŋ duuru gen̰n̰o. ");
INSERT INTO moz_vpl VALUES ("MT15_37","070_15_37","MAT","15","37","37","Wede tuuku toŋ yʼa iimi yʼa isse isse a dʼuupite, wo omɓo ere uupite gette, an ti tussite a ûune dambayi deero sarat. ");
INSERT INTO moz_vpl VALUES ("MT15_38","070_15_38","MAT","15","38","38","Kane ɗoŋ iimi geŋ kuuli dupu piɗe, daa kaza kʼerayi tʼin̰n̰i. ");
INSERT INTO moz_vpl VALUES ("MT15_39","070_15_39","MAT","15","39","39","Aame ɗoŋ duuru Isa yi tiʼn igibe maŋ, yoŋ yi-ti gili adda tooko, wo yʼa iŋgile ki siiɗo Magadaŋ. ");
INSERT INTO moz_vpl VALUES ("MT16_1","070_16_1","MAT","16","1","1","Ɗoŋ miibi ti diine kane Pariziyeŋ ti Saduseyeŋ geŋ, an a dʼiide sirpa kʼIsa kono an dehu an i dʼekke ikka tʼurzi kʼonamí. Iŋkino maŋ an di yʼ tunde yʼan dʼise munɗa kʼarmika wede a kize yoŋ Raa yi yʼigibo. ");
INSERT INTO moz_vpl VALUES ("MT16_2","070_16_2","MAT","16","2","2","Wo Isa yʼan diʼn gime onamaŋ, yʼede: «Aame peeɗo tʼa tʼooriyo wo kandaane i tʼisiyo teeze maŋ, kun dʼeesiyo: “Ume yʼisa tasse beehiye.” ");
INSERT INTO moz_vpl VALUES ("MT16_3","070_16_3","MAT","16","3","3","Wo ti soohe walak kun dʼeesiyo: “Aŋki mizzi yi koppa, kono kandaane teezikadí ki zimolo.” Iŋkino maŋ kun dʼaaniya kun di suuniyo ita sulɗi ɗoŋ kun wolliyo tʼedaguŋ isiyo a kandaane, wo ɗe ki moo me kun ki dʼaaniya kun gi di yʼ suuniyo ye munɗa wede i-kaza ita sulɗi ɗoŋ Raa yʼisiyo aŋken̰n̰o eŋ me! ");
INSERT INTO moz_vpl VALUES ("MT16_4","070_16_4","MAT","16","4","4","Ita ɗuwo ɗoŋ aŋken̰n̰o eŋ, kane ɗoŋ ulpi wo an ki seeɗu urzi Raa ye, an tondiyo munɗa kʼarmika a kize nuŋ Raa yi nʼigibo. Wo armika ti doolo Raa yʼan kʼisa ye, daa ki armika ere Raa yʼize ti kaaga a nebi Zonas ye maŋ.» Iŋkino kane geŋ Isa yiʼn iili, yʼa iŋgile. ");
INSERT INTO moz_vpl VALUES ("MT16_5","070_16_5","MAT","16","5","5","Kane sanalliyagi an doopiɗe ti kese bar Galile ti nee geŋ, an dunɗo an dʼamɓo mappa me. ");
INSERT INTO moz_vpl VALUES ("MT16_6","070_16_6","MAT","16","6","6","Aame geŋ Isa yʼan di ruute, yʼede: «Kun koona mentikagi a orme wede ki Pariziyeŋ ti Saduseyeŋ me.» ");
INSERT INTO moz_vpl VALUES ("MT16_7","070_16_7","MAT","16","7","7","Kane sanalliyagi an dʼiise rootiyto ti tuddaŋ, anʼde: «Yi rootiyo iŋkino kono in kʼumɓo mappa ye.» ");
INSERT INTO moz_vpl VALUES ("MT16_8","070_16_8","MAT","16","8","8","Wo yo Isa rootiyadaŋ gette yʼa ti zuune, iŋkino maŋ yʼanni tunde, yʼede: «Ki moo me kun di rootiyto ti tudduguŋ, kun kʼumɓo mappa ye me? Ki kotto kune zaapu kʼadduguŋ a Raa baata! ");
INSERT INTO moz_vpl VALUES ("MT16_9","070_16_9","MAT","16","9","9","Ki kotto kune sulɗi ɗoŋ ize geŋ, itadaŋ kun ki ti zuune ye ɓotto! Kune un dunɗe baa a mappa paat wede an an di-dikkiɗa a kuuli dupu paat, wo a onniyo gette oopiyo ki mappa dambayi miibi kun zikiti me? ");
INSERT INTO moz_vpl VALUES ("MT16_10","070_16_10","MAT","16","10","10","Wo kune un dunɗe baa a mappa sarat wede an an di-dikkiɗa a kuuli dupu piɗe, wo a onniyo gette oopiyo ki mappa dambayi deero miibi kun zikiti me? ");
INSERT INTO moz_vpl VALUES ("MT16_11","070_16_11","MAT","16","11","11","Ɗe mummino kuneʼŋ ita kʼonamó kun gi diʼn suuniyo ye me? Aame nʼun ruute, nʼede: “Kun koona mentikagi ti orme wede ki Pariziyeŋ ti Saduseyeŋ” geŋ, nʼun rootiyo ti mappa ye.» ");
INSERT INTO moz_vpl VALUES ("MT16_12","070_16_12","MAT","16","12","12","Iŋkino maŋ kane sanalliyagi ita kʼonamí an diʼn zuune, yoŋ yʼan ki rootiyo an di koone mentikagi ti orme wede an ki dʼooɗibe mappa ye, kaciŋ yʼan rootiyo ti dooyiso ere ki Pariziyeŋ ti Saduseyeŋ. ");
INSERT INTO moz_vpl VALUES ("MT16_13","070_16_13","MAT","16","13","13","Isa yʼiŋgile ki geeger Sezare siiɗo Pilip, aame yʼiiney maŋ sanalliyagí yʼanni tunde, yʼede: «A tukki nuŋ wede an nʼehe aa ulo wede eŋ, ɗuwo an rootiyo nuŋ wee wee?» ");
INSERT INTO moz_vpl VALUES ("MT16_14","070_16_14","MAT","16","14","14","Kane an i diʼn gime onamí, anʼde: «Ɗoŋ soŋ anʼde kee Zaŋ Batis, ɗoŋ oŋgo anʼde kee nebi Eli, wo ɗoŋ oŋgo soŋ anʼde kee nebi Zeremi koo ise nebi ti diine nebiyagi ɗoŋ ti kaaga koo maŋ.» ");
INSERT INTO moz_vpl VALUES ("MT16_15","070_16_15","MAT","16","15","15","Wo yoŋ yʼan di ruute, yʼede: «Ɗe kune me, kunʼde nuŋ wee wee?» ");
INSERT INTO moz_vpl VALUES ("MT16_16","070_16_16","MAT","16","16","16","Simo wede an yi waaku sundí soo te Piyer yi diʼn gime onamí, yʼede: «Kee Almasi Raa yi biire, wo Ulo Raa zeere.» ");
INSERT INTO moz_vpl VALUES ("MT16_17","070_16_17","MAT","16","17","17","Iŋkino maŋ Isa yi di ruute, yʼede: «Simo ulo Zonas, uŋsuwo a kee kono ɗerec gette a-tʼiiɗiba itaʼŋ wede tudde ye, a iiɗiba ita Meegó Raa a kandaane. ");
INSERT INTO moz_vpl VALUES ("MT16_18","070_16_18","MAT","16","18","18","Wo aŋkeŋ nʼa di rooto keren̰, kee sundá Piyer, suma i-kaza “mokkolo”, wo geŋ ekki mokkolo gettiyo nʼa tiʼn koona kane ɗoŋ ogiyso ti sundó me, kono an tʼise aakede ɓoy wede nuŋ nʼoozige. A kane ɗoŋ ogiyso geŋ, ume ki ɗoŋ i tʼinda batum i-kʼede toogo yʼa kiʼn ceera ye. ");
INSERT INTO moz_vpl VALUES ("MT16_19","070_16_19","MAT","16","19","19","Nʼa di tʼela kerle wede ki Moziko Raa a beezá: Munɗa wede tuuku a siiɗo kʼa ti gitta maŋ, a kandaane Raa yʼa di kettey, wo munɗa wede tuuku a siiɗo ki tʼiiza maŋ, a kandaane Raa yʼa tʼeezey.» ");
INSERT INTO moz_vpl VALUES ("MT16_20","070_16_20","MAT","16","20","20","Maŋ Isa a sanalliyagi yʼan dʼundirɗe kono a wenɗa soo toŋ an i roota ye, yoŋ Almasi Raa yi biire me. ");
INSERT INTO moz_vpl VALUES ("MT16_21","070_16_21","MAT","16","21","21","Tiŋ geŋ Isa yʼan dʼiise rootiyto keren̰ a sanalliyagí, yʼede: «I dehu nuŋ nʼa tʼette ki Zeruzalem, wo a ummey geŋ kane ɗoŋ i dokkiyo ɗoŋziŋ, deero ɗoŋ seɗeke ti ɗoŋ suuniyo kʼoogoro, an tʼeley urzi a ɗuwo an di nʼ seeɗey, an di nʼ dabirey ɓaadaŋ, an a di nʼ tʼîdey. Wo onniyo sire kʼaɗuwe maŋ Raa yʼa ti nʼ balɗey.» ");
INSERT INTO moz_vpl VALUES ("MT16_22","070_16_22","MAT","16","22","22","Maŋ Piyer yʼa yʼirga siidí, yʼa yʼiise aapuɗu, yʼede: «Aha Galmeega, kee Raa yi ki booho! Munɗa geŋ a aana ye!» ");
INSERT INTO moz_vpl VALUES ("MT16_23","070_16_23","MAT","16","23","23","Wo ɗe yo Isa yʼa-gime ki tukki Piyer wo yi di ruute, yʼede: «Kee Meeda siitanɗani tʼa-tʼûune adda kʼaddá, ki leɗɗo dokki ti tuddó me! Kee a nuŋ mokkolo morkiƴe a munɗa wede nʼaase me kono elkisadá ti ere ki Raa soo ye, elkisadá ki ɗoŋ tudde.» ");
INSERT INTO moz_vpl VALUES ("MT16_24","070_16_24","MAT","16","24","24","Saŋ Isa yʼan di ruute a sanalliyagí, yʼede: «Wede yi dehu yʼa daane urzi nuuno maŋ, tuddí batum yʼa ti kiigira, ki unto toŋ yʼa oyye yʼa tʼinda kono nuuno, wo yʼa ni daane. ");
INSERT INTO moz_vpl VALUES ("MT16_25","070_16_25","MAT","16","25","25","Iŋkino wede tuuku yi dehu boohiyo tuddí kʼaggadí maŋ, yʼa ti dagga, wo ɗe wede tuuku yʼooliyo tuddí kono nuuno maŋ, yʼa tʼutta. ");
INSERT INTO moz_vpl VALUES ("MT16_26","070_16_26","MAT","16","26","26","A wede koɗuwatú moo me sulɗi duniya pay yʼanni tʼoone, wo tuddí yʼa ti dagge me? Wo ki kotto wede geŋ tuddí zooyatú oon̰e, geŋ yi kʼaane yʼa ki tʼele munɗa yʼa ki pelke tuddí ye! ");
INSERT INTO moz_vpl VALUES ("MT16_27","070_16_27","MAT","16","27","27","Ɗerec, nuŋ wede an nʼehe aa ulo wede eŋ, nʼaa kimo ti maaleekiyagó adda darƴika ere ki Meegó Raa, wo aame geŋ wede tuuku toŋ yʼa tʼoona munɗa wede ni dehu ni-tʼela a naabadí ere yʼize gette. ");
INSERT INTO moz_vpl VALUES ("MT16_28","070_16_28","MAT","16","28","28","Ɗerec iŋkino wo nʼun di rooto: Ɗoŋ oŋgoŋ ti diine kane ɗoŋ aŋken̰n̰o eŋ an ki ti tʼinda ki poone pay ye, an di nʼ wolla nuŋ wede an nʼehe aa ulo wede eŋ, nʼetto adda mozikadó me.» ");
INSERT INTO moz_vpl VALUES ("MT17_1","070_17_1","MAT","17","1","1","Îide onniyo zoot kʼita maŋ, Isa yʼa-wiike ti yode Piyer, Zak wo leemadí Zaŋ, yʼan dʼan dʼiŋgile siidaŋ kʼekki mokkolo sohoro. ");
INSERT INTO moz_vpl VALUES ("MT17_2","070_17_2","MAT","17","2","2","An iiney maŋ, a ɗaanadaŋ geŋ miŋ tuddí a-gime sittú, iŋkino ume kʼedayí a iise ralita aa peeɗo wo kallagí a tʼize tuwarɗi kar aa toore. ");
INSERT INTO moz_vpl VALUES ("MT17_3","070_17_3","MAT","17","3","3","A kaamiki, kane sanalliyagi aɗo geŋ an wolliyo bibiraw Muusa ti nebi Eli an rootiyto tʼIsa. ");
INSERT INTO moz_vpl VALUES ("MT17_4","070_17_4","MAT","17","4","4","Iŋkino maŋ Piyer yʼa tʼihina bizí, yi di ruute Isa, yʼede: «Galmeeʼki nuŋ, beehiyeʼŋ kine in di lekke a en̰n̰o! Ki dehu maŋ, a eŋ nʼun dʼokkima daabagi aɗo, a kee soo, a Muusa soo, wo a Eli soo.» ");
INSERT INTO moz_vpl VALUES ("MT17_5","070_17_5","MAT","17","5","5","Aame onamí yʼa ki tiʼn ɗeŋge ye ɓotto geŋ, i dʼiido dondirso ti-tooriyo ti diʼn ippe kane geŋ me. Wo tʼadda dondirso gette an dʼilliga golla, tʼede: «Eŋ Ulo nuuno ni yʼ giyye ɓaadaŋ, ulbó uŋse ti yode me. Kun yʼollo!» ");
INSERT INTO moz_vpl VALUES ("MT17_6","070_17_6","MAT","17","6","6","Aame sanalliyagi an illiga golla gettiyo maŋ, orgiso tʼanni ziiɗa ɓaadaŋ an di zilɗiti kaŋ ossiso. ");
INSERT INTO moz_vpl VALUES ("MT17_7","070_17_7","MAT","17","7","7","Isa yʼa dʼiide sirpadaŋ, yʼan dʼan buttite wo yʼan di ruute, yʼede: «Kun tʼoozoŋ, kun orgiɗe ye!» ");
INSERT INTO moz_vpl VALUES ("MT17_8","070_17_8","MAT","17","8","8","Maŋ kane an dʼumɓe edayaŋ, wo an wolliyo Isa siidí, wenɗa ti doolo umbo. ");
INSERT INTO moz_vpl VALUES ("MT17_9","070_17_9","MAT","17","9","9","A ɗeeguzaŋ tʼekki mokkolo, Isa yʼan di ruute, yʼede: «Kun ollo, a munɗa wede iido kun wulle geŋ, a wenɗa soo toŋ kun rootey ye, bini balɗiya ki nuŋ wede an nʼehe aa ulo wede eŋ ti diine ɗoŋ unto.» ");
INSERT INTO moz_vpl VALUES ("MT17_10","070_17_10","MAT","17","10","10","Maŋ kane sanalliyagi an di yʼ tunde, anʼde: «Ki moo me ɗoŋ suuniyo kʼoogoro an di rootiyo, anʼde: “Ki poone i kimo Eli ɗoo miŋ, saŋ Almasi Raa yi biire kollo” me?» ");
INSERT INTO moz_vpl VALUES ("MT17_11","070_17_11","MAT","17","11","11","Isa yʼan diʼn gime onamaŋ, yʼede: «Ɗerec, Eli geŋ yʼa etto, wo sulɗi pay yʼan okkima a urzizaŋ. ");
INSERT INTO moz_vpl VALUES ("MT17_12","070_17_12","MAT","17","12","12","Wo kun ollo, nʼun di rooto, Eli geŋ yoŋ yi tʼiido baa, ɗuwo an gi di yʼ zuune ye, yoŋ wede a etto me, wo an i-dʼize ulsu aa addaŋ i dehu. Geŋ iŋkino kay nuŋ wede an nʼehe aa ulo wede en̰n̰o toŋ, an di nʼ dabira.» ");
INSERT INTO moz_vpl VALUES ("MT17_13","070_17_13","MAT","17","13","13","Iŋkino maŋ kane sanalliyagi an di zuune, yoŋ yʼan rootiyo a tukki Zaŋ Batis, a tukkʼEli ye. ");
INSERT INTO moz_vpl VALUES ("MT17_14","070_17_14","MAT","17","14","14","Isa ti sanalliyagi aɗo an iiney a ume ɗoŋ duuru maŋ, a ume geŋ i dʼede wede yʼa dʼiide sirpa kʼIsa, yʼa-dikke a ɗaanadí ");
INSERT INTO moz_vpl VALUES ("MT17_15","070_17_15","MAT","17","15","15","wo yi di ruute, yʼede: «Galmeeʼki nuŋ, kʼiso adde koɗuwo a ulo nuŋ, yoŋ i-dʼede amputput, yi dabirsa ɓaadaŋ, onniyo ti yʼamɓu maŋ, ti-ti yʼ seɗɗiyo adda kʼuwwo ise adda kʼahu toŋ maŋ. ");
INSERT INTO moz_vpl VALUES ("MT17_16","070_17_16","MAT","17","16","16","Nʼan di yʼumɓo a sanalliyagá, wo ɗe kane an kʼiine an i kʼele beeko ye.» ");
INSERT INTO moz_vpl VALUES ("MT17_17","070_17_17","MAT","17","17","17","Maŋ Isa yʼa tʼihina bizí, yʼa ruute, yʼede: «Kune ɗoŋ ulpi wo kun ki ziipe adduguŋ a Raa ye. Nuŋ ti kaagine ni lekkiyo ti kune, wo ɗe a nuŋ kun ki dʼumɓe ye! Geŋ nʼa omɓin̰a ki daayum koo ti kune me? Ulo kun o dʼedi ken̰n̰o.» ");
INSERT INTO moz_vpl VALUES ("MT17_18","070_17_18","MAT","17","18","18","Isa yʼa tʼiɗɗise siitan gette, maŋ todʼ tʼa tʼuɗɗe ti tukkʼulo me. Wo a kaamiki yoŋ yʼa uune bee. ");
INSERT INTO moz_vpl VALUES ("MT17_19","070_17_19","MAT","17","19","19","Iŋkino maŋ sanalliyagi an a dʼiide sirpa kʼIsa wo an di yʼ tunde siidaŋ, anʼde: «Wo ɗe ki moo me siitan gette kaye ay ki dʼiine lommatú ye me?» ");
INSERT INTO moz_vpl VALUES ("MT17_20","070_17_20","MAT","17","20","20","Yoŋ yʼan di ruute, yʼede: «Kun kʼiine lommatú ye kono kuneʼŋ zaapu kʼadduguŋ a Raa baata. Ɗerec iŋkino wo nʼun di rooto: Ise zaapu kʼadduguŋ a Raa gette tʼaase n̰eŋko aa ulo kʼundumu sundí mutard toŋ maŋ, kun aane kun i di roote a tokomo ette, kun tʼeese: “Tʼumayí eŋ mi-ɗeeto kʼummey”, toŋ maŋ todʼ tʼa-ɗeete. Munɗa wede kun kʼaane ye umbo. ");
INSERT INTO moz_vpl VALUES ("MT17_21","070_17_21","MAT","17","21","21","Wo geŋ ita siitan ere kino ette, aɗɗiyatú tʼurzi tondiyo Raa wo ti lekkiyo ere onniyo muno daa kʼomɓo ɗaŋŋal.» ");
INSERT INTO moz_vpl VALUES ("MT17_22","070_17_22","MAT","17","22","22","Onniyo soo kane sanalliyagi an tʼugiye pay a siiɗo Galile, maŋ Isa yʼan di ruute, yʼede: «Nuŋ wede an nʼehe aa ulo wede eŋ, an di nʼ tʼeley a bey ɗuwo. ");
INSERT INTO moz_vpl VALUES ("MT17_23","070_17_23","MAT","17","23","23","Kane an di nʼ tʼîdey, wo onniyo sire kʼaɗuwe maŋ Raa yʼa ti nʼ balɗey.» Iŋkino kane sanalliyagi an tʼize sommagi dondoŋ. ");
INSERT INTO moz_vpl VALUES ("MT17_24","070_17_24","MAT","17","24","24","Isa ti sanalliyagí an iiney geeger Kapernayim. Aame geŋ kane ɗoŋ seɗɗu jibaaye ki Ɓoy Raa an a dʼiide sirpa Piyer wo an di yʼ tunde, anʼde: «Wede dooyisaguŋ jibaaye yʼeliyo ko ki Ɓoy Raa te?» ");
INSERT INTO moz_vpl VALUES ("MT17_25","070_17_25","MAT","17","25","25","Yo Piyer yʼa ruute, yʼede: «Eyye, yʼeliyo.» Saŋ Piyer yi-tʼiide kʼadda ɓoy, wo ki poone yʼa tʼihina bizí geŋ, Isa yʼa ruute, yʼede: «Simo kee elkisadá moo me? Wee wee a tʼele jibaaye wo patanti a mozagi ɗoŋ a duniya ette? Ɗoŋ siiɗo kunuŋ, torgagi ko?» ");
INSERT INTO moz_vpl VALUES ("MT17_26","070_17_26","MAT","17","26","26","Piyer yi diʼn gime onamí, yʼede: «Torgagi a tʼele me.» Maŋ Isa yi di ruute, yʼede: «Iŋkino maŋ ɗoŋ siiɗo an ki tʼele ye. ");
INSERT INTO moz_vpl VALUES ("MT17_27","070_17_27","MAT","17","27","27","Wo miŋ kane ɗoŋ seɗɗu jibaaye in ki tiʼn kulkuwa ye geŋ, kʼodo ki biza bar, kʼa seɗɗoy tiwili kʼadda kʼahu, wo puuniso ere kʼamɓey ki poone gette kʼa tʼohinoy bittú, ki-tʼooney tamma soo ere a tʼîdey ki jibaaye, kʼa tʼamɓoy wo ti tode gette kʼa eloy jibaaye ki nuuno wo ki kee.» ");
INSERT INTO moz_vpl VALUES ("MT18_1","070_18_1","MAT","18","1","1","Aame geŋ kane sanalliyagi an a dʼiide sirpa kʼIsa wo an di tunde, anʼde: «Wee wee goole a jiire a Moziko Raa te?» ");
INSERT INTO moz_vpl VALUES ("MT18_2","070_18_2","MAT","18","2","2","Maŋ Isa yi wiike ulo n̰eŋku, yʼa yʼîhira a diinayaŋ, ");
INSERT INTO moz_vpl VALUES ("MT18_3","070_18_3","MAT","18","3","3","wo yʼa ruute, yʼede: «Ɗerec iŋkino wo nʼun di rooto: Aame kun ki ti gima lekkiyaguŋ wo kun ki tʼiza aa in̰n̰i sun̰n̰i ye maŋ, Moziko Raa kun ki tʼetta ye. ");
INSERT INTO moz_vpl VALUES ("MT18_4","070_18_4","MAT","18","4","4","Iŋkino maŋ wede yi-tʼiza tuddí n̰eŋku aa ulo en̰n̰o maŋ, yode gen̰n̰o goole a jiire a Moziko Raa te. ");
INSERT INTO moz_vpl VALUES ("MT18_5","070_18_5","MAT","18","5","5","Wede tuuku yi seeɗu ulo aa yode eŋ bey sire a sundó maŋ, geŋ aa yi seeɗu nuŋ batum.» ");
INSERT INTO moz_vpl VALUES ("MT18_6","070_18_6","MAT","18","6","6","«Wede tuuku yi tʼeliyo adda kʼolɗiko wede soo ti diine kane ɗoŋ tasse a urzi zaapu kʼadde a nuuno maŋ, a wede iŋkino geŋ, dabar ere an i di kette assa meeda a golladí an ti yʼ seɗɗe adda moyta bar gette, soodo sey ti ere yi tʼooney a ɗaana Raa te. ");
INSERT INTO moz_vpl VALUES ("MT18_7","070_18_7","MAT","18","7","7","Dabar a ɗoŋ duniya, kono i dʼede sulɗi ɓaadaŋ an tʼeliyo ɗuwo adda kʼolɗiko. Ɗerec, kane sulɗi daayum ede ɗoŋ i tʼeliyo ɗuwo adda kʼolɗiko me, wo ɗe dabar a yode wede i tʼeliyo bakadí adda kʼolɗiko. ");
INSERT INTO moz_vpl VALUES ("MT18_8","070_18_8","MAT","18","8","8","Aame beezá ise zindá koo a-da tʼettiyo kʼadda kʼolɗiko maŋ, kʼa-ɗekko kʼa seɗɗo dokki ti kee. Beehiye i jiire a kee zindá soo ise beezá soo wo kʼa tʼooney lekkiyo ere ki daayum, bee miŋ kʼa lekke beyɗaŋ sirwaŋ ise zoŋɗaŋ sirwaŋ wo an ki ti seɗɗey adda kʼuwwo ere tʼoggiyo ki daayum. ");
INSERT INTO moz_vpl VALUES ("MT18_9","070_18_9","MAT","18","9","9","Wo aame ersadá tʼa-da tʼettiyo kʼadda kʼolɗiko maŋ, kʼa tʼooɗo kʼa seɗɗo dokki ti kee me. Beehiye i jiire a kee tʼersadá soo wo kʼa tʼooney lekkiyo ere ki daayum, bee miŋ kʼa lekke edayá sire wo an ki ti seɗɗey adda kʼuwwo ere ki dabar.» ");
INSERT INTO moz_vpl VALUES ("MT18_10","070_18_10","MAT","18","10","10","«Kun koona mentikagi, wenɗa yi kiigira wede soo ye ti diine kane ɗoŋ tasse a urzi zaapu kʼadde a Raa me. Kun ollo, nʼun di rooto, kane geŋ maaleekiyagaŋ an lekkiyo jep a ɗaana Meegó Raa a kandaane me.  ");
INSERT INTO moz_vpl VALUES ("MT18_11","070_18_11","MAT","18","11","11","Ɗerec, nuŋ wede an nʼehe aa ulo wede eŋ, nʼiidoʼŋ nʼan tʼele uttiyo a ɗoŋ i digge adda kʼolɗikadaŋ. ");
INSERT INTO moz_vpl VALUES ("MT18_12","070_18_12","MAT","18","12","12","Kun ollo taaya ettiyo wo kun dʼelkito eego. Aakede wedeʼŋ i-dʼede damɓami meeda wo ere soo ti diinayaŋ tʼa digge. Iŋkino wede geŋ yʼaase mummino me? Ki kotto ɗoŋ ada gessat makumu gessat geŋ yi dʼooli a ita tokomo, yʼa tʼette dehutu ki ere i digge. ");
INSERT INTO moz_vpl VALUES ("MT18_13","070_18_13","MAT","18","13","13","Ɗerec iŋkino wo nʼun di rooto: Aame wede geŋ yi tʼuuno maŋ, uŋsuwadí ere a tukki damsa gette tʼaase ɓaadaŋ a ceere ki ɗoŋ ada gessat makumu gessat i ki digge ye gen̰n̰o. ");
INSERT INTO moz_vpl VALUES ("MT18_14","070_18_14","MAT","18","14","14","Geŋ iŋkino Meeguguŋ Raa a kandaane yi dehu wenɗa soo toŋ i ki dagge ye ti diine kane ɗoŋ tasse a urzi zaapu kʼadde a yode me.» ");
INSERT INTO moz_vpl VALUES ("MT18_15","070_18_15","MAT","18","15","15","«Aame leemadá wede i ziipe addí a Raa geŋ yi tʼize olɗiko ti kee maŋ, kʼodo ki yʼoonoy wo ki rootoy munɗa geŋ sigguŋ. Aame yi-kʼilligey maŋ, leemadá ki ti yʼ gimo kʼurzi wede beehiye. ");
INSERT INTO moz_vpl VALUES ("MT18_16","070_18_16","MAT","18","16","16","Aame yi ki kʼilligey ye maŋ, kʼa waako wede soo ise ɗoŋ sire toŋ maŋ, kun di yʼoonoy sey, kono sulɗi pay geŋ kun tiʼn tʼîde a ɗaana ɗoŋ sire tʼaɗo i wulle wo illiga ɗoo. ");
INSERT INTO moz_vpl VALUES ("MT18_17","070_18_17","MAT","18","17","17","Aame kane geŋ yʼan kiʼn illigey ye maŋ, kʼan tʼôodo taaya a ɗoŋ ogiyso ti sundó. Wo ki ɗaŋgu, aame kane geŋ yi kiʼn illigey ye sey maŋ, ki yʼ wollo yoŋ geŋ aakede wede i ki suune Raa soo ɗaŋŋal ye, wo aakede wede seɗɗu jibaaye. ");
INSERT INTO moz_vpl VALUES ("MT18_18","070_18_18","MAT","18","18","18","Ɗerec iŋkino wo nʼun di rooto: Munɗa wede tuuku a siiɗo kun a ti gitta maŋ, a kandaane Raa yʼa di kettey, wo munɗa wede tuuku a siiɗo kun tʼiiza maŋ, a kandaane toŋ Raa yʼa tʼeezey. ");
INSERT INTO moz_vpl VALUES ("MT18_19","070_18_19","MAT","18","19","19","Kun ollo, nʼun di rooto sey: Aame a siiɗo geŋ ɗoŋ sire ti diinaguŋ an ti gitte onamaŋ kaŋ soo an di tonde Raa a munɗa tuuku toŋ maŋ, geŋ Meegó Raa a kandaane yʼan di yʼ tʼela. ");
INSERT INTO moz_vpl VALUES ("MT18_20","070_18_20","MAT","18","20","20","Ɗerec, a ume tuuku ɗoŋ sire tʼaɗo wo a gili geŋ an tʼugiye ti sundó maŋ, nuŋ a diinayaŋ.» ");
INSERT INTO moz_vpl VALUES ("MT18_21","070_18_21","MAT","18","21","21","Iŋkino maŋ Piyer yʼa dʼiide sirpa kʼIsa wo yʼa yi tunde, yʼede: «Galmeeʼki nuŋ, aame leemadó yʼo tʼize olɗiko maŋ, taŋ miibi ni-dʼise tambobino me? Bini taŋ sarat ko?» ");
INSERT INTO moz_vpl VALUES ("MT18_22","070_18_22","MAT","18","22","22","Isa yi diʼn gime onamí, yʼede: «Aha, nʼa-ki roote bini taŋ sarat ye, wo nʼa di roote bini ada sarat sarat, taŋ sarat. ");
INSERT INTO moz_vpl VALUES ("MT18_23","070_18_23","MAT","18","23","23","Kun ollo, Moziko Raa todʼ ti deeƴiso aa naabo mozigo yi dehu yʼa wolle soŋko ere ɗoŋ naabadí an i di tʼele. ");
INSERT INTO moz_vpl VALUES ("MT18_24","070_18_24","MAT","18","24","24","Iŋkino maŋ yi-tʼiise, ki poone an i di wiiko wede i di tʼele soŋko ɓaadaŋ ɓaadaŋ ki kʼaane ki ti kize ye. ");
INSERT INTO moz_vpl VALUES ("MT18_25","070_18_25","MAT","18","25","25","Wede geŋ, i-kʼede munɗa ye yi di tʼele soŋko ki galmeegí me. Iŋkino maŋ galmeegí yʼan di ruute a ɗoŋzí, yʼede: “Wede eŋ kun ti yʼowol, eddí, in̰n̰izí wo sulɗizí pay kono a-ti tʼîde a soŋkadó.” ");
INSERT INTO moz_vpl VALUES ("MT18_26","070_18_26","MAT","18","26","26","Maŋ wede naabo geŋ yʼa iire a zoŋ galmeegí, wo yi di ruute, yʼede: “Kʼamɓo omɓin̰e a nuuno me, soŋkadá nuŋ nʼa-ti kima pay.” ");
INSERT INTO moz_vpl VALUES ("MT18_27","070_18_27","MAT","18","27","27","Galmeeʼki wede naabo geŋ i di tʼize sommagi, soŋko ere yi di tʼele yi-dʼiili mentú, maŋ wede naabo yʼa iŋgile. ");
INSERT INTO moz_vpl VALUES ("MT18_28","070_18_28","MAT","18","28","28","Aame wede naabo geŋ ti di mozigo yi tʼuɗɗe maŋ, an a-tʼikkima ti wede ume naabadaŋ soo, yoŋ geŋ i-dʼede see ki soŋko miibi ɗaŋŋal. Yʼiideʼŋ yi di ziiɗa golladí bin̰ wo yi di ruute, yʼede: “Seezá kʼo yʼeli.” ");
INSERT INTO moz_vpl VALUES ("MT18_29","070_18_29","MAT","18","29","29","Maŋ yo wede ume naabadaŋ soo geŋ, yʼa iire a zoŋɗí wo yi-dʼoɓe bey, yʼede: “Kʼamɓo omɓin̰e ti nuuno, seezó nʼa yi tʼela.” ");
INSERT INTO moz_vpl VALUES ("MT18_30","070_18_30","MAT","18","30","30","Wo ɗe yo wede geŋ yʼa-tuuge, wo ulsu a jiire sey yi-ti yʼ ziɗɗe daŋgay koore seezí yi di yʼ tʼela geŋ me. ");
INSERT INTO moz_vpl VALUES ("MT18_31","070_18_31","MAT","18","31","31","Aame kane ɗoŋ ume naabadaŋ soo geŋ an wulle iŋkino maŋ, an tʼize sommagi dondoŋ, an iideʼŋ a galmeegaŋ an i di tʼîide taaya a sulɗi ɗoŋ pay ize geŋ me. ");
INSERT INTO moz_vpl VALUES ("MT18_32","070_18_32","MAT","18","32","32","Iŋkino maŋ galmeega geŋ wede naabo yʼa yi wiike, wo yi di ruute, yʼede: “Kʼo iɓi bey moŋ seezá pay nʼa-di yʼîide miŋ, kaciŋ kee wede naabo ulsu kino too! ");
INSERT INTO moz_vpl VALUES ("MT18_33","070_18_33","MAT","18","33","33","Ki too maŋ kee kʼa dehe kʼaase adde koɗuwo a wede naabo aa kee, aakede nuŋ batum nʼize adde koɗuwo a kee.” ");
INSERT INTO moz_vpl VALUES ("MT18_34","070_18_34","MAT","18","34","34","Wo galmeegí adda kulkuwadí ere ɓaadaŋ gette yʼan di yʼele a bey kʼasigiryagi, an di yʼ dabire adda daŋgay koore soŋkadí yi di tʼela pay geŋ me.» ");
INSERT INTO moz_vpl VALUES ("MT18_35","070_18_35","MAT","18","35","35","Isa yʼan di ruute sey, yʼede: «Geŋ iŋkino kay Meegó Raa a kandaane yʼun isa me, aame wede tuuku ti diinaguŋ yi kʼiza tambobino a leemadí tʼadde soo ye maŋ.» ");
INSERT INTO moz_vpl VALUES ("MT19_1","070_19_1","MAT","19","1","1","Aame Isa ti dooyiso ɗuwo yʼa ti ɗiŋge maŋ, ti siiɗo Galile yʼa tʼiiziga yʼa-diipiɗa ti siiɗo Ziide ere ti dar kʼooye Zurden ti nee. ");
INSERT INTO moz_vpl VALUES ("MT19_2","070_19_2","MAT","19","2","2","Ɗoŋ duuru ɓaadaŋ an di yʼ diine wo a ume geŋ yʼan dʼele beeko a ɗoŋ kʼeeni ti diinayaŋ. ");
INSERT INTO moz_vpl VALUES ("MT19_3","070_19_3","MAT","19","3","3","Ɗoŋ miibi ti diine Pariziyeŋ an a dʼiide sirpadí kono an dehu an i dʼekke ikka tʼurzi kʼono. Maŋ kane an di yʼ tunde, anʼde: «Oogiradiŋ tʼele ko urzi ki peeriyo kʼerewo, aame kule yi uune munɗa tuuku eddí tʼize wo ulbí i-kʼize uŋse ye maŋ?» ");
INSERT INTO moz_vpl VALUES ("MT19_4","070_19_4","MAT","19","4","4","Isa yʼan diʼn gime onamaŋ, yʼede: «Ki kotto kune kun gire ono ɗoŋ an riiŋe ti kaaga adda mattup ki Raa, anʼde: “Tʼume kʼeesiyo Raa yi ziipe sulɗi pay geŋ, yʼikkima aŋ kule tʼere.” ");
INSERT INTO moz_vpl VALUES ("MT19_5","070_19_5","MAT","19","5","5","Wo Raa yʼa ruute sey, yʼede: “Kono kamo kule yi dʼoola meegí ti meedí, yʼa di ketta bin̰ ti eddí. Wo kane sire geŋ an tʼisa tudde soo.” ");
INSERT INTO moz_vpl VALUES ("MT19_6","070_19_6","MAT","19","6","6","Iŋkino maŋ kane geŋ sire ye baa, an tʼize tudde soo. Geŋ iŋkino munɗa wede Raa yʼa ti gitte geŋ, wede tudde yi ki tʼeeze ye.» ");
INSERT INTO moz_vpl VALUES ("MT19_7","070_19_7","MAT","19","7","7","Kane Pariziyeŋ an di yʼ tunde, anʼde: «Ɗe ki moo me ti kaaga Muusa yʼa ele urzi, aame wede yi-peere eddí maŋ, yi di ɗekke mattup ki peeriyo yi di tʼele a beytú me?» ");
INSERT INTO moz_vpl VALUES ("MT19_8","070_19_8","MAT","19","8","8","Isa yʼan di ruute, yʼede: «Muusa yʼun ele urzi ki peeriyo kʼerayguŋ kono a eego zakiɗi ere un dʼede gettiyo, para maŋ tʼume kʼeesiyo iŋkino ye. ");
INSERT INTO moz_vpl VALUES ("MT19_9","070_19_9","MAT","19","9","9","Wo kono kʼiŋkino toŋ nʼun di rooto: Ki peeriyo kʼerewo ulu, wo wede yi peere eddí geŋ, aame ti moone ti kule bakatú ɗaŋŋal! Para maŋ yi ti biira wo yi ziiɗa erewo ti doolo maŋ, Raa yi yi wolliyo yoŋ wede i moone tʼere bakadí.» ");
INSERT INTO moz_vpl VALUES ("MT19_10","070_19_10","MAT","19","10","10","Kane sanalliyagi an i di ruute, anʼde: «Aame wede yi peere eddí tʼurzi soo ɗaŋŋal gen̰n̰o maŋ, geŋ ki ki ziiɗa ye toŋ bee.» ");
INSERT INTO moz_vpl VALUES ("MT19_11","070_19_11","MAT","19","11","11","Isa yʼan diʼn gime onamaŋ, yʼede: «Ɗoŋ pay an kʼaane an kʼamɓe ye a dooyiso ette, aane amɓe kane ɗoŋ soo Raa yʼan ele urzi ɗaŋŋal. ");
INSERT INTO moz_vpl VALUES ("MT19_12","070_19_12","MAT","19","12","12","I dʼede urziyagi miibi ɗoŋ i-tʼeegirso kuuli an kʼaane an ki seɗɗe erayi ye me. Ki ɗoŋ oŋgo moytaŋ umbo tʼume kʼehiyadaŋ too, ɗoŋ oŋgo kokkiso tʼurzi ɗuwo wo ɗoŋ soŋ kane batum an ti seeɗu tuddaŋ aa moytaŋ umbo kono Moziko Raa. Geŋ wede yʼaane suuniyo kʼita kʼono en̰n̰o maŋ, yi ni suuno.» ");
INSERT INTO moz_vpl VALUES ("MT19_13","070_19_13","MAT","19","13","13","Saŋ maŋ ɗuwo an i di ziko in̰n̰i sun̰n̰i a Isa kono yʼan di zaape beezí a eedaŋ wo yʼa tonde Raa kono kane, miŋ kane sanalliyagi an ki dehu ye, an diʼn eɗɗisito ɗuwo geŋ me. ");
INSERT INTO moz_vpl VALUES ("MT19_14","070_19_14","MAT","19","14","14","Maŋ Isa yʼa ruute, yʼede: «Kun oolo in̰n̰i eŋ an dʼetto ki tuddó, kun tiʼn eegire ye, kono Moziko Raa todʼte ki ɗoŋ i deeƴiso aa kane kino.» ");
INSERT INTO moz_vpl VALUES ("MT19_15","070_19_15","MAT","19","15","15","Aame geŋ yʼan di ziipe beezí a eedaŋ, maŋ tʼume geŋ yʼa iŋgile ki ɗaana. ");
INSERT INTO moz_vpl VALUES ("MT19_16","070_19_16","MAT","19","16","16","Saŋ i dʼede wede soo yʼa dʼiide sirpa kʼIsa wo yʼa yi tunde, yʼede: «Wede dooyisadey, munɗa wede beehiye nʼaase moo me kono nʼa tʼoona lekkiyo ere ki daayum te?» ");
INSERT INTO moz_vpl VALUES ("MT19_17","070_19_17","MAT","19","17","17","Isa yi di ruute, yʼede: «Ki moo me ki di nʼ tondiyo a munɗa wede beehiye me? Beehiye Raa soo ɗaŋŋal. Aame ki dehu kʼa tʼoona lekkiyo ere ki daayum maŋ, ki sooɗo urziyagi kʼoogoro Raa.» ");
INSERT INTO moz_vpl VALUES ("MT19_18","070_19_18","MAT","19","18","18","Wede geŋ yi di ruute, yʼede: «Kane miŋ ɗoŋ tuuku me?» Isa yi diʼn gime onamí, yʼede: «Kane en̰n̰o: Ki tôwwo wedusu mirsi ulu, ki moone tʼere bakadá ise ti kule bakatú ulu, kʼoogire ulu, ki rootiyo kʼono butte a tukki bakadá a ɗaana booro ulu, ");
INSERT INTO moz_vpl VALUES ("MT19_19","070_19_19","MAT","19","19","19","ki elo suma a meegá ti meedá, wo ki ɗaŋgu ki geyyo bakadá aa ki geyyiso tuddá batum.» ");
INSERT INTO moz_vpl VALUES ("MT19_20","070_19_20","MAT","19","20","20","Obulsu yi di ruute, yʼede: «Kane geŋ pay niʼni seeɗu, wo o biite moo sey me?» ");
INSERT INTO moz_vpl VALUES ("MT19_21","070_19_21","MAT","19","21","21","Isa yi di ruute, yʼede: «Aame ki dehu kʼa-tʼette a munɗa wede aa Raa yi dehu maŋ, kʼodo, sulɗi ɗoŋ a-dʼedeʼŋ ki tʼowiltoy pay wo soŋko kʼan dʼeloy a ɗoŋ an kʼede munɗa ye, iŋkino kʼa tʼooney laale wede ki kotto a kandaane. Saŋ kʼa tʼedi wo kʼa ni daana.» ");
INSERT INTO moz_vpl VALUES ("MT19_22","070_19_22","MAT","19","22","22","Aame obulsu geŋ yʼilliga ono gen̰n̰o maŋ, yʼa tʼize sommagi dondoŋ kono yoŋ maaladí ɓaadaŋ, saŋ yʼa iŋgile. ");
INSERT INTO moz_vpl VALUES ("MT19_23","070_19_23","MAT","19","23","23","Maŋ Isa yʼan di ruute sanalliyagí, yʼede: «Ɗerec iŋkino wo nʼun di rooto: Oon̰e ɓaadaŋ a wede laale yi tʼettey adda Moziko Raa te. ");
INSERT INTO moz_vpl VALUES ("MT19_24","070_19_24","MAT","19","24","24","Kun ollo, nʼun di rooto sey: Oon̰e a ziŋzo ti-tʼaɗɗe ti bulɗo rippile me, wo geŋ oon̰e ɓaadaŋ a ceere sey a wede laale yi-tʼettey a Moziko Raa te.» ");
INSERT INTO moz_vpl VALUES ("MT19_25","070_19_25","MAT","19","25","25","Aame kane sanalliyagi an illiga ono gen̰n̰o maŋ, an di ziiɗa giggiraŋ wo an di ruute, anʼde: «Iŋkino maŋ, geŋ a utta wee wee?» ");
INSERT INTO moz_vpl VALUES ("MT19_26","070_19_26","MAT","19","26","26","Isa yi diʼn wolliyo ƴerere adda kʼedayaŋ wo yʼan di ruute, yʼede: «Munɗa eŋ ɗuwo an kʼaane ye, wo ɗe a Raa sulɗi pay i-kʼoon̰e ye, yʼaane.» ");
INSERT INTO moz_vpl VALUES ("MT19_27","070_19_27","MAT","19","27","27","Iŋkino maŋ Piyer yʼa tʼihina bizí wo yi di ruute, yʼede: «Aŋkeŋ kʼollo, kayeʼŋ sulɗizey pay ay dʼiilo wo ay di daaniya kee. Ɗe geŋ ki kaye aasa mummino me?» ");
INSERT INTO moz_vpl VALUES ("MT19_28","070_19_28","MAT","19","28","28","Isa yʼan di ruute, yʼede: «Ɗerec iŋkino wo nʼun di rooto: A onniyo ere sulɗi pay i tʼisa awirɗi geŋ, nuŋ wede an nʼehe aa ulo wede eŋ nʼa di kooney a kaakido moziko adda darƴikadó. Wo aame geŋ kune ɗoŋ kun ni daaniya, kune toŋ kun di konɗitey ekki kaakidagi koomat makumu sire ɗoŋ ki moziko, kun ɗekkey booro a tukki boha bumɓiyagi koomat makumu sire ki ɗoŋ kʼIzirayel. ");
INSERT INTO moz_vpl VALUES ("MT19_29","070_19_29","MAT","19","29","29","Wo wede tuuku yi iila ɓoyɗizí, ise zemɓadí kuuli erayi, meegí ti meedí, in̰n̰izí wo domɓizí kono sundó maŋ, kane geŋ yʼanni tʼoona taŋ ɓaadaŋ a ceera wo yʼa tʼooney lekkiyo ere ki daayum. ");
INSERT INTO moz_vpl VALUES ("MT19_30","070_19_30","MAT","19","30","30","Ɗoŋ ɓaadaŋ aŋken̰n̰o kane ki biza, saŋ an tʼisa ɗoŋ kʼita, wo ɗoŋ ɓaadaŋ aŋken̰n̰o kane kʼita, saŋ an tʼisa ɗoŋ ki biza.» ");
INSERT INTO moz_vpl VALUES ("MT20_1","070_20_1","MAT","20","1","1","Isa yʼa ruute sey, yʼede: «Kun ollo, Moziko Raa todʼ ti deeƴiso aa naabo wede ɓoy yʼa tʼuɗɗe ti soohe walak, kono yi-deho ɗoŋ naabo yʼa tiʼn tʼigiba kʼadda doomizí kʼinda sundaŋ bin̰. ");
INSERT INTO moz_vpl VALUES ("MT20_2","070_20_2","MAT","20","2","2","Aame ɗoŋ naabo yi uune maŋ, an di ruute ti kane geŋ, yʼan tʼela ran̰n̰adaŋ, a wede soŋ a naabo kʼonniyo soo soo, wo yʼan igibe kʼadda doomizí. ");
INSERT INTO moz_vpl VALUES ("MT20_3","070_20_3","MAT","20","3","3","A peeɗo tʼize kʼaaɗumu mesuwe maŋ, yʼa uɗɗe sey, yi wolliyo ɗoŋ doolo an ti guune a bere ɗoŋ duuru, naabo an kʼuune ye an delliyo. ");
INSERT INTO moz_vpl VALUES ("MT20_4","070_20_4","MAT","20","4","4","Maŋ yoŋ yʼan di ruute, yʼede: “Kune toŋ maŋ kun tʼodo naabo kʼadda doomizó, wo nʼun tʼela munɗa wede ɗerec a ran̰n̰aguŋ.” ");
INSERT INTO moz_vpl VALUES ("MT20_5","070_20_5","MAT","20","5","5","Maŋ kane an dʼiŋgile. Wede ɓoy geŋ, a peeɗo tʼize diine wo a peeɗo tʼibbira toŋ iŋkino, yʼa uɗɗe sey ɗoŋ naabo yi dʼuune, wo yʼan diʼn igibe kʼadda doomizí. ");
INSERT INTO moz_vpl VALUES ("MT20_6","070_20_6","MAT","20","6","6","A lohe maŋ yʼa uɗɗe sey, yi dʼuuney ɗoŋ doolo an ti guune a bere ɗoŋ duuru. Wo yʼan di ruute, yʼede: “Ki moo me on̰n̰uguŋ kun di yʼeŋgilso a en̰n̰o daa naabo me?” ");
INSERT INTO moz_vpl VALUES ("MT20_7","070_20_7","MAT","20","7","7","Maŋ kane an i di ruute, anʼde: “Wenɗa yʼay ki tiʼn ziki naabo ye.” Yoŋ yʼan di ruute, yʼede: “Aa ɗe geŋ, kune toŋ kun eŋgilo naabo kʼadda doomizó.” ");
INSERT INTO moz_vpl VALUES ("MT20_8","070_20_8","MAT","20","8","8","A peeɗo tʼa tʼiire maŋ, wede ɓoy yi di ruute a wede ƴeeriyadí, yʼede: “Kʼodo, ɗoŋ naabo kiʼn oozigi wo wede tuuku toŋ ki-dʼelo ran̰n̰adí te, ki-tʼeeso ti ɗoŋ a tʼiide kʼita, kʼa ti ɗeŋgo ti ɗoŋ iide ki biza.” ");
INSERT INTO moz_vpl VALUES ("MT20_9","070_20_9","MAT","20","9","9","Iŋkino maŋ kane ɗoŋ iise naabo a lohe geŋ an dʼiido, wo wede ƴeeriyo geŋ yʼan dʼele ran̰n̰adaŋ a wede soŋ a naabo kʼonniyo soo soo. ");
INSERT INTO moz_vpl VALUES ("MT20_10","070_20_10","MAT","20","10","10","Aame iina kaaɓa ki kane ɗoŋ iise naabo ti soohe walak maŋ, an elkiyo an tʼoona ɓaadaŋ baaki, kaciŋ kane toŋ an dʼuune ran̰n̰adaŋ tiŋ wede soŋ a naabo kʼonniyo soo soo pay. ");
INSERT INTO moz_vpl VALUES ("MT20_11","070_20_11","MAT","20","11","11","Aame wede ƴeeriyo geŋ yʼan ele ran̰n̰adaŋ maŋ, an dʼiise gurgirso a tukki wede ɓoy, ");
INSERT INTO moz_vpl VALUES ("MT20_12","070_20_12","MAT","20","12","12","anʼde: “Kane ɗoŋ a tʼiido kʼita wo an niibe peeɗo soo toŋ, kee kʼan dʼele ran̰n̰adaŋ aa ki kaye ɗoŋ iido ti soohe, ay niibe kee kee adda malla, ay dʼurme bini peeɗo kʼooriyo.” ");
INSERT INTO moz_vpl VALUES ("MT20_13","070_20_13","MAT","20","13","13","Wo wede ɓoy geŋ, a wede soo ti diinayaŋ yi diʼn gime onamí, yʼede: “Laŋze ki nuŋ, nʼa-kʼisiyo ulsu ye, ki kotto kee in ti ruute ti nuŋ, nʼa-tʼela ran̰n̰a ki naabadá kʼonniyo soo. ");
INSERT INTO moz_vpl VALUES ("MT20_14","070_20_14","MAT","20","14","14","Iŋkino ki tʼamɓo gettiŋ ran̰n̰adá kʼeŋgilo. Ɗoŋ iido kʼita toŋ ni dehu ran̰n̰adaŋ nʼan tʼele aa ki kee. ");
INSERT INTO moz_vpl VALUES ("MT20_15","070_20_15","MAT","20","15","15","Ɗerec, nuŋ ti maaladó ette o ede urzi nʼaase munɗa wede aa addó i dehu kunuŋ, a beehiyko ere nʼisiyo gette kee ki kolɓiso ko?”» ");
INSERT INTO moz_vpl VALUES ("MT20_16","070_20_16","MAT","20","16","16","Wo Isa yʼa ruute sey, yʼede: «Iŋkino maŋ ɗoŋ aŋken̰n̰o kane kʼita, saŋ an tʼisa ɗoŋ ki biza, wo ɗoŋ aŋken̰n̰o kane ki biza, saŋ an tʼisa ɗoŋ kʼita.» ");
INSERT INTO moz_vpl VALUES ("MT20_17","070_20_17","MAT","20","17","17","Isa yi-kili ki Zeruzalem maŋ, yʼa-wiike sanalliyagi kane koomat makumu sire, yʼan irga siidaŋ, a urzi yʼan di ruute, yʼede: ");
INSERT INTO moz_vpl VALUES ("MT20_18","070_20_18","MAT","20","18","18","«Kun ollo, in ti kili ki Zeruzalem wo nuŋ wede an nʼehe aa ulo wede eŋ, an di nʼ tʼeley a bey deero ɗoŋ seɗeke ti ɗoŋ suuniyo kʼoogoro. Kane geŋ tʼurzi kʼonamaŋ nuŋ booro tʼa ni seeɗey ki tôwwo, ");
INSERT INTO moz_vpl VALUES ("MT20_19","070_20_19","MAT","20","19","19","wo an di nʼ tʼeley a bey ɗoŋ kane Yawudiyagi ye, kono an di nʼ tʼokkey maade, an di nʼ gorpipey ti marpa wo an ti nʼ taakey ekkʼundumu wede zaapu tʼekki bakadí kaŋ tontilko. Wo onniyo sire kʼaɗuwe maŋ, Raa yʼa ti nʼ balɗey.» ");
INSERT INTO moz_vpl VALUES ("MT20_20","070_20_20","MAT","20","20","20","Iŋkino maŋ mekkʼin̰n̰i kuuli ki Zebede, tʼin̰n̰itú geŋ tʼa dʼiide sirpa kʼIsa, wo tʼa dikke ɗaanadí kono tʼa yi tonde. ");
INSERT INTO moz_vpl VALUES ("MT20_21","070_20_21","MAT","20","21","21","Maŋ Isa yʼa ti tunde, yʼede: «Ɗe koŋ mi dehu moo me?» Todʼ ti di ruute, tʼede: «Ni dehu kʼa tʼele urzi, onniyo ki tʼiida mozikadá maŋ, in̰n̰izó sire eŋ kʼa tiʼn zappey soŋ a ammidadá, soŋ a geeladá.» ");
INSERT INTO moz_vpl VALUES ("MT20_22","070_20_22","MAT","20","22","22","Isa yʼan diʼn gime onamaŋ, yʼede: «Munɗa wede kun tondiyo, kun ki yʼ suune ye. Kun aana kun siɓa ko kop ki dabar wede nuŋ ni siɓa me?» Maŋ kane an i di ruute, anʼde: «Eyye, ay aana.» ");
INSERT INTO moz_vpl VALUES ("MT20_23","070_20_23","MAT","20","23","23","Yoŋ yʼan di ruute, yʼede: «Ɗerec, kop ki dabar wede ni siɓa geŋ kun siɓa. Wo ɗe ki ume konso wede a ammidadó soŋ a geeladó geŋ, urzi yoŋ a bey nuuno ye, ume geŋ yoŋ ki kane ɗoŋ Meegó Raa yʼan ikkima.» ");
INSERT INTO moz_vpl VALUES ("MT20_24","070_20_24","MAT","20","24","24","Aame kane sanalliyagi ɗoŋ koomat geŋ an illiga maŋ, an di-gulkuwe ti kane zemɓa sire gen̰n̰o. ");
INSERT INTO moz_vpl VALUES ("MT20_25","070_20_25","MAT","20","25","25","Maŋ Isa yʼa tiʼn wiike sanalliyagi geŋ pay ki ɗaanadí, wo yʼan di ruute, yʼede: «Kune kun suune, mozagi siiɗiyagi pay an dʼomɓo tʼekki ɗoŋzaŋ ti toogo, wo kane ɗoŋ deero an dʼomɓo tʼekki ɗoŋzaŋ tʼurzi dokkiyo ere an dʼede. ");
INSERT INTO moz_vpl VALUES ("MT20_26","070_20_26","MAT","20","26","26","Wo geŋ a diinaguŋ i dehu iŋkino a kʼise ye. Ki too maŋ, wede tuuku yi dehu yʼa tʼise goole ti diinaguŋ maŋ, yoŋ geŋ yi tʼiso wede naabaguŋ, ");
INSERT INTO moz_vpl VALUES ("MT20_27","070_20_27","MAT","20","27","27","wo wede tuuku ti diinaguŋ yi dehu yʼa tʼise ki biza maŋ, yoŋ geŋ yi tʼiso ɓulaguŋ. ");
INSERT INTO moz_vpl VALUES ("MT20_28","070_20_28","MAT","20","28","28","Geŋ iŋkino, nuŋ wede an nʼehe aa ulo wede eŋ, nʼiidoʼŋ kono ɗuwo on o-ki naabe ye, wo ɗe nʼiidoʼŋ nʼan di naabe ɗuwo wo nʼa oyye nʼa tʼinda kono nʼa tʼaɗɗe ɗoŋ ɓaadaŋ tʼadda kʼolɗikadaŋ.» ");
INSERT INTO moz_vpl VALUES ("MT20_29","070_20_29","MAT","20","29","29","Isa ti sanalliyagí tʼadda Zeriko an a tʼaɗɗe maŋ, ɗoŋ duuru ɓaadaŋ an diʼn daaniya. ");
INSERT INTO moz_vpl VALUES ("MT20_30","070_20_30","MAT","20","30","30","Maŋ i dʼede koŋzayi sire an ti guune a biza kʼurzi. Aame an illiga eŋgilso geŋ Isa maŋ, an dʼiise ɗollite, anʼde: «Galmeegey, kee Wede ti biza bumɓu Dawut, kʼiso adde koɗuwo a kaye!» ");
INSERT INTO moz_vpl VALUES ("MT20_31","070_20_31","MAT","20","31","31","Kane ɗoŋ duuru an diʼn eɗɗisito kono an dʼanniga, wo kane koŋzayi an a ɗolle ɓaadaŋ i ceeriyo, an dʼeesiyo: «Galmeegey, kee Wede ti biza bumɓu Dawut, kʼiso adde koɗuwo a kaye, kʼiso adde koɗuwo a kaye!» ");
INSERT INTO moz_vpl VALUES ("MT20_32","070_20_32","MAT","20","32","32","Maŋ Isa yʼa tʼîhira, yʼanni wiike wo yʼan di ruute, yʼede: «Kune kun dehu nʼun dʼise moo me?» ");
INSERT INTO moz_vpl VALUES ("MT20_33","070_20_33","MAT","20","33","33","Kane an di ruute, anʼde: «Galmeegey, ay dehu edayey a-tʼihina.» ");
INSERT INTO moz_vpl VALUES ("MT20_34","070_20_34","MAT","20","34","34","Isa i di tʼize sommagi, yʼan di buttite a edayaŋ. A kaamiki, edayaŋ a tʼihina an di wolliyo, maŋ an di yʼ diine. ");
INSERT INTO moz_vpl VALUES ("MT21_1","070_21_1","MAT","21","1","1","Isa ti sanalliyagi an iiney goppoŋ ki Zeruzalem, a sirpa kʼille sundutú Betpaze, wo a sirpa mokkolo kʼInda kʼOlibiye. A ume geŋ yi dʼigibe sanalliyagi sire, ");
INSERT INTO moz_vpl VALUES ("MT21_2","070_21_2","MAT","21","2","2","wo yʼan di ruute, yʼede: «Kunʼdo kʼadda kʼille ere a ɗaanaguŋ gettiyo. Kun iiney, kesiko kun tʼooney buuru kettiyo, tʼulutú a sirpa. Kun tʼeezi, kun o diʼn arkiɗi. ");
INSERT INTO moz_vpl VALUES ("MT21_3","070_21_3","MAT","21","3","3","Aame wenɗa yʼun ruutey munɗa maŋ, kun dʼeesoy: “Burɗari eŋ i dehu Galmeega.” Maŋ kesiko wede geŋ burɗari yʼun dʼoolo, kun dʼeŋgilo.» ");
INSERT INTO moz_vpl VALUES ("MT21_4","070_21_4","MAT","21","4","4","Geŋ a iina kono a-tʼette a ono ɗoŋ nebi yi ruute ti kaaga, yʼede: ");
INSERT INTO moz_vpl VALUES ("MT21_5","070_21_5","MAT","21","5","5","«Kun an rooto a ɗoŋ geeger Siyoŋ geŋ: En̰n̰o mozigaguŋ me, yʼettiyo ki tudduguŋ ti buuru, yoŋ addí tasse yʼa ti gilo ekkʼulo buuru, seysu ki sarkiya kʼattiɗi.» ");
INSERT INTO moz_vpl VALUES ("MT21_6","070_21_6","MAT","21","6","6","Iŋkino maŋ kane sanalliyagi sire geŋ an dʼiŋgile, wo an tʼizo munɗa wede Isa yʼan ruute an dʼiso me. ");
INSERT INTO moz_vpl VALUES ("MT21_7","070_21_7","MAT","21","7","7","An tʼirkiɗo buuru tʼulutú an dʼiido, an a-ti gikkite kallagaŋ ɗoŋ deero a dar burɗari wo Isa yʼa-ti gili eego. ");
INSERT INTO moz_vpl VALUES ("MT21_8","070_21_8","MAT","21","8","8","Kane ɗoŋ duuru geŋ, ɗoŋ ɓaadaŋ ti diinayaŋ an di gikkite kallagaŋ ɗoŋ deero a urzi, ɗoŋ oŋgoŋ an dimɓo puutagi kʼinda an di gikkite a urzi kay. ");
INSERT INTO moz_vpl VALUES ("MT21_9","070_21_9","MAT","21","9","9","Kane ɗuwo ɗoŋ i sooru ɗaanadí ti ɗoŋ i yi daaniya geŋ, pay kaŋ soo an di ɗollite, an dʼeesiyo: «Tamma a Wede ti biza bumɓu Dawut! Beeko Raa ti koona a ekki wede ettiyo ti suma Galmeega Raa! Tamma a Raa tʼawwa a kandaane!» ");
INSERT INTO moz_vpl VALUES ("MT21_10","070_21_10","MAT","21","10","10","Aame Isa yi tʼiide adda Zeruzalem maŋ, kane ɗoŋ geeger pay an dʼiise okkito ken̰n̰o ken̰n̰o, an di tondiso ti tuddaŋ, anʼde: «Ɗe yo eŋ wee wee?» ");
INSERT INTO moz_vpl VALUES ("MT21_11","070_21_11","MAT","21","11","11","Maŋ kane ɗoŋ duuru an an di tiʼn gime onamaŋ, anʼde: «Eŋ nebi Isa, ti geeger Nazaret ki siiɗo Galile.» ");
INSERT INTO moz_vpl VALUES ("MT21_12","070_21_12","MAT","21","12","12","Saŋ Isa yi-tʼiide a booro Ɓoy Raa, wo yʼan ilmiti kane ɗoŋ isiyo suuk ti ɗoŋ kʼowilte pay a ume gen̰n̰o. Yʼan di gippirɗe taabulyagi ki ɗoŋ pelkiyto soŋko ere ettiyo ti siiɗiyagi doolo, wo ti kaakidagi ɗoŋ kʼowilte deere. ");
INSERT INTO moz_vpl VALUES ("MT21_13","070_21_13","MAT","21","13","13","Maŋ yʼan di ruute, yʼede: «Kun ollo, ono eŋ an riiŋe ti kaaga adda mattup ki Raa, anʼde: “Ɓoozó eŋ an di yʼ waaka ɓoy wede ki tondiyo Raa.” Wo ɗe kune, kun di yʼize urmi kʼombiɗe ɗoŋ kʼoogire!» ");
INSERT INTO moz_vpl VALUES ("MT21_14","070_21_14","MAT","21","14","14","Aame geŋ i dʼede ɗoŋ koŋzayi ti ɗoŋ jekese, an a dʼiide kʼume kʼIsa a booro Ɓoy Raa, wo yʼan dʼele beeko. ");
INSERT INTO moz_vpl VALUES ("MT21_15","070_21_15","MAT","21","15","15","Kane deero ɗoŋ seɗeke ti ɗoŋ suuniyo kʼoogoro an wulle sulɗi kʼarmika ɗoŋ Isa yʼize me. Wo soŋ an wulle in̰n̰i an ɗollite a booro Ɓoy Raa, an dʼeesiyo: «Tamma a Wede ti biza bumɓu Dawut!» Iŋkino maŋ, an di gulkuwe, ");
INSERT INTO moz_vpl VALUES ("MT21_16","070_21_16","MAT","21","16","16","wo an i di ruute, anʼde: «Kʼollige ɗey ko, munɗa wede an rootiyo me?» Wo Isa yʼan di ruute, yʼede: «Eyye nʼollige, wo kune ki kotto kun gire munɗa wede an riiŋe ti kaaga adda mattup ki Raa, anʼde: “Kee kʼaaze kono ti bize kʼin̰n̰i sun̰n̰i ti ɗoŋ oɗiyo uɗu toŋ, ki dʼuɗɗe tamma”?» ");
INSERT INTO moz_vpl VALUES ("MT21_17","070_21_17","MAT","21","17","17","Maŋ yiʼn iili, wo ti geeger yi tʼuɗɗe, yʼa iŋgile ki ille Betani yʼa onno. ");
INSERT INTO moz_vpl VALUES ("MT21_18","070_21_18","MAT","21","18","18","Soggo ti soohe Isa yi kama ki Zeruzalem maŋ, aame geŋ mosogo tʼa yi ziiɗa. ");
INSERT INTO moz_vpl VALUES ("MT21_19","070_21_19","MAT","21","19","19","Maŋ yi wulle undumu sundí pigiye a biza kʼurzi, yʼaa dʼiide wo ɗe yʼiideʼŋ in̰n̰i umbo, yi dʼuuney puutagi ɗaŋŋal. Iŋkino yʼa ruute a undumu geŋ, yʼede: «Ti aŋki, in̰n̰i ki ki tʼeha ye baa!» A kaamiki pigiye geŋ a-biiha. ");
INSERT INTO moz_vpl VALUES ("MT21_20","070_21_20","MAT","21","20","20","Kane sanalliyagi an wulle iŋkino maŋ, an ziiɗa giggiraŋ wo an di ruute, anʼde: «Ɗe mummino a kaamiki eŋ miŋ, pigiye eŋ a-biiha kino me?» ");
INSERT INTO moz_vpl VALUES ("MT21_21","070_21_21","MAT","21","21","21","Isa yʼan diʼn gime onamaŋ, yʼede: «Ɗerec iŋkino wo nʼun di rooto: Aame un dʼede zaapu kʼadde a Raa wo adda kʼadduguŋ kun ki niikiyo ye maŋ, kun aane kun dʼise munɗa wede aa ni ize a pigiye en̰n̰o. Wo kun aane sey kun i di roote a tokomo ette, “Tʼumayí eŋ mi tʼoozo mi tʼooro adda bar” toŋ, geŋ a tʼise. ");
INSERT INTO moz_vpl VALUES ("MT21_22","070_21_22","MAT","21","22","22","Sulɗi ɗoŋ pay kun tonda Raa tʼurzi zaapu kʼadde a yode geŋ, kun diʼn tʼoona.» ");
INSERT INTO moz_vpl VALUES ("MT21_23","070_21_23","MAT","21","23","23","Maŋ Isa yi-tʼiide a booro Ɓoy Raa, aame geŋ yʼa iise dooyiso ɗuwo. Iŋkino maŋ kane deero ɗoŋ seɗeke ti ɗoŋ i dokkiyo Yawudiyagi, an dʼiido tuddí wo an di yʼ tunde, anʼde: «Kee kʼisiyto sulɗi eŋ tʼurzi kʼaaye? Wo urzi eŋ a ele wee wee?» ");
INSERT INTO moz_vpl VALUES ("MT21_24","070_21_24","MAT","21","24","24","Isa yʼan diʼn gime onamaŋ, yʼede: «Nuŋ toŋ nʼun diʼn tondo a munɗa soo ɗaŋŋal. Aame onamó kun o tiʼn gima maŋ, nuŋ toŋ nʼun ti yʼ kiza urzi wede ni dʼisiyto sulɗi eŋ me. ");
INSERT INTO moz_vpl VALUES ("MT21_25","070_21_25","MAT","21","25","25","Aame Zaŋ ɗuwo yʼanni zuyye batem geŋ, urzi iido ti Raa kunuŋ ti ɗuwo ko?» Maŋ an dʼiise rootiyto ti tuddaŋ, anʼde: «Aame kine in ruuta: “Iidoʼŋ tʼurzi Raa” maŋ, yoŋ yʼin di roota: “Iŋkino ki moo me kun ki dʼumɓe a ono Zaŋ ye me?” ");
INSERT INTO moz_vpl VALUES ("MT21_26","070_21_26","MAT","21","26","26","Wo aame kine in ruuta: “Iidoʼŋ tʼurzi ɗuwo” maŋ, kine in dʼede orgiso a ɗoŋ duuru kono kane pay geŋ an elkiyoʼŋ Zaŋ yoŋ nebi.» ");
INSERT INTO moz_vpl VALUES ("MT21_27","070_21_27","MAT","21","27","27","Iŋkino maŋ Isa onamí an i-tiʼn gime, anʼde: «Ay ki suune ye.» Wo yode Isa toŋ yʼan di ruute, yʼede: «Nuŋ toŋ maŋ nʼun ki yʼ roote ye kay, wede o ele urzi ni dʼisiyto sulɗi eŋ me.» ");
INSERT INTO moz_vpl VALUES ("MT21_28","070_21_28","MAT","21","28","28","Isa yʼa ruute sey, yʼede: «Kun ollo taaya ettiyo wo kun dʼelkito eego. I dʼede wede soo iŋkino in̰n̰izí kuuli sire. Yoŋ yʼiideʼŋ a ulí ki kaɓɓa yi di ruute, yʼede: “Ulo ki nuŋ, aŋki kʼodo kʼin ti wolli doome kʼinda bin̰.” ");
INSERT INTO moz_vpl VALUES ("MT21_29","070_21_29","MAT","21","29","29","Yo ulo geŋ yi-tiʼn gime onamí, yʼede: “Aha, ni kʼette ye”, wo taŋ booloŋ maŋ i di tʼize attiɗi, yʼa tʼiide ki doome me. ");
INSERT INTO moz_vpl VALUES ("MT21_30","070_21_30","MAT","21","30","30","Maŋ meega yʼa iide tukkʼulí wede soo me, wo yi di ruute iŋkino kay. Maŋ yo ulo geŋ yi-tiʼn gime onamí, yʼede: “Eyye meeʼki nuŋ, kʼoolo nʼa tʼette ki doome me.” Wo kaciŋ yʼa guune, doome yʼa kʼiide ye.» ");
INSERT INTO moz_vpl VALUES ("MT21_31","070_21_31","MAT","21","31","31","Maŋ Isa yʼa ruute, yʼede: «Ti diine kane sire geŋ, wee wee i tʼize munɗa wede meegí yi dihe me?» Kane deero Yawudiyagi an i diʼn gime onamí, anʼde: «Wede ki kaɓɓa.» Iŋkino maŋ Isa yʼan di ruute, yʼede: «Ɗerec iŋkino wo nʼun di rooto: Kane ɗoŋ seɗɗu jibaaye ti erayi ɗoŋ ooniyo omɓo bizaŋ tʼitadaŋ geŋ, an un uugume ki Moziko Raa te. ");
INSERT INTO moz_vpl VALUES ("MT21_32","070_21_32","MAT","21","32","32","Ni rootiyo iŋkino kono Zaŋ Batis yʼiido kʼume kune, yʼun di gize urzi lekkiyo ere ki diine aa Raa yi dehu toŋ, kun ki dʼumɓe ye a onamí me, wo ɗe kane ɗoŋ seɗɗu jibaaye ti erayi ɗoŋ ooniyo omɓo bizaŋ tʼitadaŋ geŋ, an dʼumɓe a onamí me. Wo kune, kun wulle ɗuwo geŋ an umɓe me, wo toŋ lekkiyaguŋ kun ki ti gime ye kono kun dʼamɓe a onamí me.» ");
INSERT INTO moz_vpl VALUES ("MT21_33","070_21_33","MAT","21","33","33","«Kun ollo ono ombiɗe ti doolo en̰n̰o: I dʼede wede doome iŋkino yi dʼiite doome kʼinda sundaŋ bin̰. Doome geŋ yʼa ti yʼ ɗuule ti waaya moŋgali, yʼa dʼittiba sôole ki ŋaƴƴu kʼin̰n̰i kʼinda bin̰ gen̰n̰o, yʼa dʼippe ɓoy sohuru ki boɗɗiyo. Maŋ doome geŋ yʼan dʼele ɗuwo an di naabe saŋ yoŋ aggadí yʼa tʼamɓa, wo yoŋ tuddí yʼa iŋgile torguwo. ");
INSERT INTO moz_vpl VALUES ("MT21_34","070_21_34","MAT","21","34","34","Aame onniyo ki rakku kʼin̰n̰i kʼinda bin̰ tʼiina maŋ, yʼa igibe ɗoŋ naabadí ki tukki ɗoŋ naabo doome gen̰n̰o, kono an i di tʼelo aggadí ere kʼin̰n̰i kʼinda bin̰ an rikke te. ");
INSERT INTO moz_vpl VALUES ("MT21_35","070_21_35","MAT","21","35","35","An iiney maŋ, kane ɗoŋ naabo doomeʼŋ an tiʼn ziɗɗe ɗoŋ naabadí me: soŋ an di yʼ gusse ɓaadaŋ, soŋ an di yʼîide, wo wede kʼaɗuwe an ti yʼ gikkite ti moŋgali yʼa inda. ");
INSERT INTO moz_vpl VALUES ("MT21_36","070_21_36","MAT","21","36","36","Wede doomeʼŋ yi dʼigibe ɗoŋ naabadí ɓaadaŋ ti doolo a jiire ɗoŋ ti poone, wo kane gen̰n̰o toŋ ɗoŋ naabo doome an an dʼize iŋkino kay. ");
INSERT INTO moz_vpl VALUES ("MT21_37","070_21_37","MAT","21","37","37","Kʼita maŋ yʼan tʼigibe ulí wo yʼa ruute tʼadda kʼaddí, yʼede: “Yoŋ eŋ ulo kʼaddó, an i dʼottiley.” ");
INSERT INTO moz_vpl VALUES ("MT21_38","070_21_38","MAT","21","38","38","Wo ɗe aame kane ɗoŋ naabo doomeʼŋ ulo an yi wulle maŋ, an dʼiise rootiyto ti tuddaŋ, anʼde: “En̰n̰o ulo wede doome i oopa me! In yʼôodo kono doome eŋ yʼin dʼoopa.” ");
INSERT INTO moz_vpl VALUES ("MT21_39","070_21_39","MAT","21","39","39","Maŋ ulo geŋ an di yʼ ziiɗa, tʼadda doome an di yʼirkiɗe ki toogo ki paate, wo an di yʼîide.» ");
INSERT INTO moz_vpl VALUES ("MT21_40","070_21_40","MAT","21","40","40","Maŋ Isa yʼa tunde, yʼede: «Iŋkino geŋ aame wede doome kʼinda bin̰ yʼiina maŋ, yʼan dʼisa mummino a ɗoŋ naabo doome geŋ me?» ");
INSERT INTO moz_vpl VALUES ("MT21_41","070_21_41","MAT","21","41","41","Wo kane deero ɗoŋ seɗeke ti ɗoŋ i dokkiyo Yawudiyagi geŋ an i diʼn gime onamí, anʼde: «Kane ɗoŋ ulpi geŋ wede doome yʼiido maŋ, yi ki wolla sommagaŋ ye, yʼa tiʼn tʼîda wo doome kʼinda bin̰ geŋ, yʼan tʼela a ɗoŋ doolo an di naaba, wo kane geŋ aggadí an i tʼela aame iina ume rakku kʼin̰n̰i kʼinda bin̰ maŋ.» ");
INSERT INTO moz_vpl VALUES ("MT21_42","070_21_42","MAT","21","42","42","Isa yʼan di ruute, yʼede: «Ki kotto kune kun gire ono ɗoŋ an riiŋe ti kaaga adda mattup ki Raa, anʼde: “Mokkolo ere ɗoŋ kʼoozige ɓoy an di ziɗɗe mentú gette, tode gettiyo a tʼize mokkolo ere majjaanawa a jiire kʼoozige ɓoy te. Munɗa geŋ iido ti Galmeega Raa, wo a kine in di wolliyoʼŋ munɗa geŋ i jiire eego.” ");
INSERT INTO moz_vpl VALUES ("MT21_43","070_21_43","MAT","21","43","43","Kono kamo kun ollo, nʼun di rooto: Raa Mozikadí ti beezaŋ yʼa-tʼamɓa wo yʼan tʼela a ɗoŋ doolo, ɗoŋ aana isa naabo beehiye ere yoŋ yi dehu. ");
INSERT INTO moz_vpl VALUES ("MT21_44","070_21_44","MAT","21","44","44","Wede tuuku yʼa tʼiira ekki mokkolo gettiyo maŋ, yʼa-damɓa, wo aame mokkolo gette ti-di tʼiira a wenɗa maŋ, tʼa ti yʼ n̰oguma.» ");
INSERT INTO moz_vpl VALUES ("MT21_45","070_21_45","MAT","21","45","45","Kane deero ɗoŋ seɗeke ti Pariziyeŋ an illiga ono ombiɗe Isa yi rootiyo gen̰n̰o maŋ, an di zuune keren̰ yi rootiyo ti kane me. ");
INSERT INTO moz_vpl VALUES ("MT21_46","070_21_46","MAT","21","46","46","Iŋkino maŋ an di dihe urzi an di yʼ seeɗa, wo ɗe an dʼurgiɗe a ɗoŋ duuru kono kane ɗuwo geŋ an elkiyoʼŋ Isa yoŋ nebi. ");
INSERT INTO moz_vpl VALUES ("MT22_1","070_22_1","MAT","22","1","1","Maŋ Isa yʼan di ruute sey tʼono ombiɗe, yʼede: ");
INSERT INTO moz_vpl VALUES ("MT22_2","070_22_2","MAT","22","2","2","«Moziko Raa todʼ ti deeƴiso aa naabo mozigo yʼize tarnaape a seeɗu kʼere kʼulí. ");
INSERT INTO moz_vpl VALUES ("MT22_3","070_22_3","MAT","22","3","3","Yi dʼigibe ɗoŋ naabadí an di waako ɗoŋ yiʼni wiike a tarnaape seeɗu kʼere kʼulí, wo kane an di-tuugo kʼettiyo me. ");
INSERT INTO moz_vpl VALUES ("MT22_4","070_22_4","MAT","22","4","4","Iŋkino maŋ yi dʼigibe ɗoŋ naabadí ti doolo, yʼan di ruute, yʼede: “Kunʼdo kun an rooti a ɗoŋ niʼni wiike geŋ, kunʼde: Galmeegey yʼede: Omɓo ettú tʼîide baa, kun tʼedi tarnaape seeɗu. Buŋgarzó ti in̰n̰i buŋgarí ɗoŋ ɓokkidagi îide kʼaaɗumu mozagi ni-wilɗite.” ");
INSERT INTO moz_vpl VALUES ("MT22_5","070_22_5","MAT","22","5","5","Wo kane ɗoŋ yiʼni wiike geŋ seezaŋ ye, an di tiipe wede tuuku toŋ kʼume naabadí naabadí, soŋ kʼadda doomizí, soŋ kʼume suukadí ");
INSERT INTO moz_vpl VALUES ("MT22_6","070_22_6","MAT","22","6","6","wo ɗoŋ soŋ an di ziɗɗe ɗoŋ naabo mozigo, an an dʼize ulsu wo an a diʼn îide. ");
INSERT INTO moz_vpl VALUES ("MT22_7","070_22_7","MAT","22","7","7","Iŋkino mozigo yʼa gulkuwe, yʼa igibe asigiryagí an tʼîido kane ɗoŋ i tʼîide ɗoŋ naabadí, wo geegirzaŋ an a-tʼuyyo. ");
INSERT INTO moz_vpl VALUES ("MT22_8","070_22_8","MAT","22","8","8","Maŋ yʼan di ruute ɗoŋ naabadí, yʼede: “Omɓo tarnaape seeɗu ettú tʼîide, wo ɗe kane ɗoŋ niʼni waaku geŋ an ki tʼîide ye kʼomɓo me. ");
INSERT INTO moz_vpl VALUES ("MT22_9","070_22_9","MAT","22","9","9","Iŋkino maŋ kunʼdo kʼurziyagi kʼokkime, wo ɗoŋ pay kun tʼooney a ɗaanaguŋ geŋ kun tiʼn waaki an dʼisa tarnaape seeɗu.” ");
INSERT INTO moz_vpl VALUES ("MT22_10","070_22_10","MAT","22","10","10","Ɗoŋ naabo geŋ an dʼiŋgile kʼurziyagi kʼokkime, wo ɗoŋ an uune pay a ɗaanadaŋ geŋ an tiʼn wiiko, ɗoŋ beehiye ise ɗoŋ ulpi toŋ maŋ. Geŋ iŋkino biino ki tarnaape seeɗu ɗuwo an dʼûune ɓoo. ");
INSERT INTO moz_vpl VALUES ("MT22_11","070_22_11","MAT","22","11","11","Saŋ maŋ mozigo yi-tʼiide adda biino yʼa-tʼeese ɗoŋ yiʼni wiiko, aame geŋ yi wolliyo maŋ wede soo yi ki tʼussoʼŋ kalle ki tarnaape seeɗu ye. ");
INSERT INTO moz_vpl VALUES ("MT22_12","070_22_12","MAT","22","12","12","Mozigo yi di ruute, yʼede: “Laŋze ki nuŋ, kee ki-tʼiido daa kalle ki tarnaape seeɗu mummino me?” Wo yo wede geŋ yʼa kʼihina bizí ye. ");
INSERT INTO moz_vpl VALUES ("MT22_13","070_22_13","MAT","22","13","13","Iŋkino maŋ mozigo yʼan di ruute ɗoŋ naabo, yʼede: “Wede eŋ kun yi sooɗo, kun ti kettito beyɗí ti zoŋɗí wo kun di seɗɗi ti paate adda zimolo, ume wede ki ɗollite môolo wo kʼaaɗumu sina.”» ");
INSERT INTO moz_vpl VALUES ("MT22_14","070_22_14","MAT","22","14","14","Maŋ Isa yʼa ruute, yʼede: «Ki kotto ɗoŋ Raa yiʼni waaku kane ɓaadaŋ, wo ɗe ɗoŋ yi biire i-tʼetta Mozikadí kane baata.» ");
INSERT INTO moz_vpl VALUES ("MT22_15","070_22_15","MAT","22","15","15","Iŋkino maŋ kane Pariziyeŋ an a dʼirga siidaŋ, an di ruute a tukkʼIsa kono an i tʼekka ikka tʼurzi kʼonamí. ");
INSERT INTO moz_vpl VALUES ("MT22_16","070_22_16","MAT","22","16","16","Saŋ maŋ an dʼigibe ɗoŋ miibi ti diine sanalliyagaŋ ti kane ɗoŋ a ita kʼErod. An iideʼŋ an i di ruute a Isa, anʼde: «Wede dooyisadey, ay suune kee ki rootiyo ono ɗoŋ ɗerec, ki dooyiso urzi Raa tʼono ɗoŋ ɗerec, ki kʼorgiso eda ɗuwo ye, wo kiʼni wolliyo ɗuwo geŋ pay kaŋ soo. ");
INSERT INTO moz_vpl VALUES ("MT22_17","070_22_17","MAT","22","17","17","Iŋkino kʼay ki ti rooti ɗoo, elkiyadá moo a ono eŋ me: A urzi kʼoogiradiŋ miŋ jibaaye a mozigo goole ki Romeŋ geŋ kʼeliyo kunuŋ, kʼeliyo ye ko?» ");
INSERT INTO moz_vpl VALUES ("MT22_18","070_22_18","MAT","22","18","18","Wo Isa metiŋkadaŋ yʼa ti zuune, maŋ yʼan di ruute, yʼede: «Kune ɗoŋ biziguŋ sire sire, ɗe ki moo me kun o dʼekkiyo ikka me? ");
INSERT INTO moz_vpl VALUES ("MT22_19","070_22_19","MAT","22","19","19","Kun o kʼeeli soŋko tamma ere kʼeliyo jibaaye nʼa ki wolle ɗo?» Maŋ an i-dʼeele tamma soo. ");
INSERT INTO moz_vpl VALUES ("MT22_20","070_22_20","MAT","22","20","20","Wo Isa yʼanni tunde, yʼede: «Undiso ti suma ekki tamma ette kʼaaye?» ");
INSERT INTO moz_vpl VALUES ("MT22_21","070_22_21","MAT","22","21","21","Kane an i diʼn gime onamí, anʼde: «Ki mozigo goole ki Romeŋ.» Maŋ Isa yʼan di ruute, yʼede: «Iŋkino maŋ munɗa wede ki mozigo goole ki Romeŋ yoŋ ki yode, kun i yʼelo, wo munɗa wede ki Raa yoŋ ki yode, kun i yʼelo.» ");
INSERT INTO moz_vpl VALUES ("MT22_22","070_22_22","MAT","22","22","22","Aame an illiga ono gen̰n̰o maŋ, an di ziiɗa giggiraŋ. Maŋ kane an di yʼiili a umayí, an dʼiŋgile. ");
INSERT INTO moz_vpl VALUES ("MT22_23","070_22_23","MAT","22","23","23","A onniyo gettiyo batum ɗoŋ miibi ti diine ɗoŋ anʼni waaku sundaŋ Saduseyeŋ geŋ, an dʼiide sirpa kʼIsa. Kun suune kane Saduseyeŋ an rootiyo ɗoŋ i tʼinda geŋ an ki ti balɗa ye. Iŋkino Isa an di yʼ tunde, anʼde: ");
INSERT INTO moz_vpl VALUES ("MT22_24","070_22_24","MAT","22","24","24","«Wede dooyisadey, Muusa yi riiŋe ti kaaga adda mattup kʼoogoro, yʼede: “Aame wede yi ziiɗa erewo wo yʼa inda daa magin̰e maŋ, mandaayawa gette leemadí yʼa ti seeɗa kono an tʼehe in̰n̰i a suma ki wede inda gen̰n̰o.” ");
INSERT INTO moz_vpl VALUES ("MT22_25","070_22_25","MAT","22","25","25","Iŋkino aakede di kaye i dʼede zemɓa kane sarat. Wede ki poone geŋ yʼa ziiɗa erewo wo yʼa inda daa magin̰e, iŋkino leemadí wede ki sirwe yʼa ti ziiɗa mandaayawa gette. ");
INSERT INTO moz_vpl VALUES ("MT22_26","070_22_26","MAT","22","26","26","Wo leema gen̰n̰o toŋ yʼa inda daa magin̰e kay, wede kʼaɗuwe toŋ iŋkino, maŋ kane zemɓa sarat geŋ an ti duude wo an tʼinda pay. ");
INSERT INTO moz_vpl VALUES ("MT22_27","070_22_27","MAT","22","27","27","Aame kane sarat geŋ pay an tʼinda maŋ, tode erewo gettiyo toŋ tʼaa dʼinda. ");
INSERT INTO moz_vpl VALUES ("MT22_28","070_22_28","MAT","22","28","28","Iŋkino maŋ a onniyo ere ɗoŋ i tʼinda an ti balɗa geŋ, ti diine kane ɗoŋ sarat geŋ erewo gette tʼaasa kʼaaye, kono kane pay geŋ miŋ kulutú me?» ");
INSERT INTO moz_vpl VALUES ("MT22_29","070_22_29","MAT","22","29","29","Isa yʼan diʼn gime onamaŋ, yʼede: «Kune kun ti digge a elkiyaguŋ, kono kun kiʼn suune ye ita kʼono ɗoŋ an riiŋe ti kaaga adda mattup ki Raa, ise toogo Raa toŋ maŋ. ");
INSERT INTO moz_vpl VALUES ("MT22_30","070_22_30","MAT","22","30","30","Ɗerec, a onniyo ere ɗoŋ i tʼinda an ti balɗa geŋ, kuuli ti erayi an ki seɗɗa tuddaŋ ye baa, wo ɗe an di lekkey daa seɗɗu aa maaleekiyagi a kandaane. ");
INSERT INTO moz_vpl VALUES ("MT22_31","070_22_31","MAT","22","31","31","Wo a urzi balɗiya ki ɗoŋ i tʼinda geŋ, ki kotto kun gire ono ɗoŋ an riiŋe ti kaaga adda mattup ki Raa, anʼde: ");
INSERT INTO moz_vpl VALUES ("MT22_32","070_22_32","MAT","22","32","32","“Nuŋ Raa kʼIbirayim, kʼIsaaka wo ki Yakup.”» Isa yʼa ruute sey, yʼede: «Raa geŋ yoŋ Raa ki ɗoŋ unto ye, yoŋ Raa ki ɗoŋ zeere.» ");
INSERT INTO moz_vpl VALUES ("MT22_33","070_22_33","MAT","22","33","33","Kane ɗoŋ duuru illiga dooyisadí gette, an i ziiɗa an di biyiso biyiso baa. ");
INSERT INTO moz_vpl VALUES ("MT22_34","070_22_34","MAT","22","34","34","Aame Pariziyeŋ geŋ an illiga Saduseyeŋ Isa yʼan îide, bizaŋ an ki ti yʼohine ye maŋ, kane an iideʼŋ an tʼugiye kaŋ soo. ");
INSERT INTO moz_vpl VALUES ("MT22_35","070_22_35","MAT","22","35","35","Wo wede soo ti diinayaŋ, yoŋ wede suuniyo kʼoogoro, yʼa dʼiide sirpa kʼIsa, yi dehu yi-dʼekke ikka tʼurzi kʼono, wo yʼa yi tunde, yʼede: ");
INSERT INTO moz_vpl VALUES ("MT22_36","070_22_36","MAT","22","36","36","«Wede dooyisadey, adda mattup kʼoogoro Muusa, urzi kʼoogoro wede goole a jiire tuuku me?» ");
INSERT INTO moz_vpl VALUES ("MT22_37","070_22_37","MAT","22","37","37","Isa yi diʼn gime onamí, yʼede: «“Ki geyyo Galmeega Raazá ti addá pay, ti undá pay wo ti elkiyadá pay.” ");
INSERT INTO moz_vpl VALUES ("MT22_38","070_22_38","MAT","22","38","38","Geŋ urzi kʼoogoro wede goole a di jiire pay. ");
INSERT INTO moz_vpl VALUES ("MT22_39","070_22_39","MAT","22","39","39","Wo en̰n̰o wede ki sirwe toŋ, yoŋ goole aa bakadí kay, “Ki geyyo bakadá aa ki geyyiso tuddá batum.” ");
INSERT INTO moz_vpl VALUES ("MT22_40","070_22_40","MAT","22","40","40","Ono ɗoŋ pay an riiŋe ti kaaga adda mattup kʼoogoro Muusa, ti ɗoŋ ki nebiyagi geŋ, toogadaŋ tiŋ urzi kʼoogoro sire en̰n̰o.» ");
INSERT INTO moz_vpl VALUES ("MT22_41","070_22_41","MAT","22","41","41","Koore kane Pariziyeŋ an lekkiyo ogiyso geŋ, Isa yʼan diʼn tunde, yʼede: ");
INSERT INTO moz_vpl VALUES ("MT22_42","070_22_42","MAT","22","42","42","«Elkiyaguŋ moo me a tukki Almasi Raa yi biire me? Yoŋ yʼaɗɗo ti biza bumɓu kʼaaye?» Kane an i diʼn gime onamí, anʼde: «Yoŋ yʼaɗɗo ti biza bumɓu Dawut.» ");
INSERT INTO moz_vpl VALUES ("MT22_43","070_22_43","MAT","22","43","43","Isa yʼan di ruute, yʼede: «Ɗe geŋ mummino Dawut tʼurzi kʼUnde Raa yʼa yi wiike Almasi “Galmeegí” me? Ni rootiyo iŋkino kono Dawut yʼa ruute ti kaaga, yʼede: ");
INSERT INTO moz_vpl VALUES ("MT22_44","070_22_44","MAT","22","44","44","“Galmeega Raa yi di ruute a Galmeegó, yʼede: Kʼedi ki-koona a ammidadó kino, bini ɗoŋ kʼaduzá nʼan isa aa munɗa ki bita ti ɗanɗi zoŋɗá.” ");
INSERT INTO moz_vpl VALUES ("MT22_45","070_22_45","MAT","22","45","45","Iŋkino maŋ Dawut yi yi waaku Almasi “Galmeega.” Ɗe geŋ mummino Almasi yʼa aɗɗo ti biza bumɓu Dawut ɗaŋŋal me?» ");
INSERT INTO moz_vpl VALUES ("MT22_46","070_22_46","MAT","22","46","46","Ti diine kane Pariziyeŋ, wenɗa soo toŋ i di kime onamí umbo. Wo ti onniyo gettiyo an dʼurgiɗe, an di yʼ tondite ti doolo sey me. ");
INSERT INTO moz_vpl VALUES ("MT23_1","070_23_1","MAT","23","1","1","Saŋ maŋ Isa yʼan di ruute ɗoŋ duuru ti sanalliyagí, yʼede: ");
INSERT INTO moz_vpl VALUES ("MT23_2","070_23_2","MAT","23","2","2","«Ɗoŋ suuniyo kʼoogoro ti Pariziyeŋ, an dʼede urzi ki dooyiso kʼoogoro Muusa. ");
INSERT INTO moz_vpl VALUES ("MT23_3","070_23_3","MAT","23","3","3","Iŋkino maŋ kun ollo onamaŋ wo munɗa wede an un ruute geŋ kun tʼiso. Wo ɗe a urzi naabadaŋ kun ozire ye, kono munɗa wede an dooyiso geŋ an ki sooru eego ye. ");
INSERT INTO moz_vpl VALUES ("MT23_4","070_23_4","MAT","23","4","4","Kane geŋ an diʼn isiyo ɗuwo ki toogo an di daane urziyagi kʼoogoro ɗoŋ ti doolo kane batum an a zaapu tʼeedaŋ tʼekki ɗoŋ ki Raa, sarkiyatú oon̰e aakede an kettiso attiɗi an a di zaapu a dar ɗuwo. Wo ɗe a attiɗi geŋ, kane batum ti ƴilsadaŋ soo toŋ an ki dehu an a ki botte ye ki noogiyo ɗuwo geŋ me. ");
INSERT INTO moz_vpl VALUES ("MT23_5","070_23_5","MAT","23","5","5","Kane geŋ naabadaŋ pay gette an isiyo kono ɗuwo an diʼn wolle. Iŋkino an dʼisiyo munɗa aakede laaya a ise goole ti ɗoŋ oŋgo an tʼeliyto mattup kʼoogoro adda an a di kettiso a zumɓamaŋ wo a mayɗayzaŋ, wo a boha kallagaŋ toŋ an a dʼisiyo gozubo soŋhirti i ceeriyo. ");
INSERT INTO moz_vpl VALUES ("MT23_6","070_23_6","MAT","23","6","6","Adda tarnaapagi a ume kʼomɓo, an geyyiso an koone a ume wede suma, wo adda ɓoyɗi ɗoŋ in di dooyiso, an geyyiso an koone a ume wede suma pây. ");
INSERT INTO moz_vpl VALUES ("MT23_7","070_23_7","MAT","23","7","7","A bere ɗoŋ duuru toŋ, an dehu ɗuwo an diʼn tʼeesite ti ottilso, wo an diʼn waake “Wede dooyiso, wede dooyiso.” ");
INSERT INTO moz_vpl VALUES ("MT23_8","070_23_8","MAT","23","8","8","Wo kune ti diinaguŋ wenɗa yʼoyya ye an di yʼ waake “Wede dooyiso” me, kono kune pay miŋ zemɓa kaŋ soo, wo wede dooyisaguŋ miŋ yoŋ soo ɗaŋŋal. ");
INSERT INTO moz_vpl VALUES ("MT23_9","070_23_9","MAT","23","9","9","A siiɗo ette wenɗa soo toŋ kun di yʼ waake “Meegey” umbo, kono kune un dʼede Meega soo ɗaŋŋal, yoŋ a kandaane. ");
INSERT INTO moz_vpl VALUES ("MT23_10","070_23_10","MAT","23","10","10","Wo kune ti diinaguŋ wenɗa yʼoyya ye an di yʼ waake “Mozigo” me, kono kune un dʼede Mozigo soo ɗaŋŋal, yoŋ Almasi Raa yi biire. ");
INSERT INTO moz_vpl VALUES ("MT23_11","070_23_11","MAT","23","11","11","Wede goole a jiire ti diinaguŋ geŋ miŋ yi koona wede naabo ki kune. ");
INSERT INTO moz_vpl VALUES ("MT23_12","070_23_12","MAT","23","12","12","Wede tuuku tuddí yi ti koliyo maŋ, yoŋ geŋ Raa yʼa yʼisa n̰eŋku, wo wede tuuku tuddí yi ti tʼisiyo n̰eŋko maŋ, yoŋ geŋ Raa yʼa yʼisa goole.» ");
INSERT INTO moz_vpl VALUES ("MT23_13","070_23_13","MAT","23","13","13","Isa yʼa ruute sey, yʼede: «Dabar a kune ɗoŋ suuniyo kʼoogoro ti Pariziyeŋ, kune ɗoŋ biziguŋ sire sire! Kuneʼŋ a ɗuwo kun an tʼappiya a biza kʼettiyo ki Moziko Raa te. Kune batum miŋ kun ki tʼettiyo ye, wo a ɗoŋ i dehu i-tʼette geŋ kun an tʼeegirso.  ");
INSERT INTO moz_vpl VALUES ("MT23_14","070_23_14","MAT","23","14","14","Dabar a kune ɗoŋ suuniyo kʼoogoro ti Pariziyeŋ, kune ɗoŋ biziguŋ sire sire! Kuneʼŋ bey mandayɗayi kun tʼomɓo pay, wo kun eesiyo tondiyo Raa maŋ ki noko nokot, kono ɗuwo an un diʼn wolle. Kono kamo booraguŋ tʼa kooney wehini a ceerey. ");
INSERT INTO moz_vpl VALUES ("MT23_15","070_23_15","MAT","23","15","15","Dabar a kune ɗoŋ suuniyo kʼoogoro ti Pariziyeŋ, kune ɗoŋ biziguŋ sire sire! Kuneʼŋ kʼume tuuku toŋ kun dʼeŋgilso torguwo, a siiɗo wo tʼekkʼahu pây, kʼooniyo wede soo ɗaŋŋal yoŋ Yawudusu ye wo kun dʼisiyo yʼa tʼise Yawudusu. Wo aame yi tʼisiyo Yawudusu maŋ, kun di yʼisiyo wede i tʼîide kʼettiyo kʼadda kʼuwwo i ɗooliyo taŋ sire a jiire ti ere ki kune batum. ");
INSERT INTO moz_vpl VALUES ("MT23_16","070_23_16","MAT","23","16","16","Dabar a kune ɗoŋ aa koŋzayi i dokkiyo ɗuwo, kun di rootiyo, kunʼde: “Aame wedusu yʼalzu ti Ɓoy Raa maŋ, yoŋ geŋ onamí yi kiʼn ziiɗa zakiɗi ye toŋ i kʼise munɗa ye, wo aame yʼalzu ti dap ere adda Ɓoy Raa maŋ, yoŋ geŋ i dehu onamí yʼanni seeɗa zakiɗi.” ");
INSERT INTO moz_vpl VALUES ("MT23_17","070_23_17","MAT","23","17","17","Kune ɗoŋ elkisaguŋ umbo wo aa koŋzayi, a jiire miŋ dap kunuŋ Ɓoy Raa wede i-ti tʼisiyo dap gette kamilen̰ a ɗaana Raa ko? ");
INSERT INTO moz_vpl VALUES ("MT23_18","070_23_18","MAT","23","18","18","Wo kun di rootiyo sey, kunʼde: “Aame wede yʼalzu ti ume seɗeke maŋ, yoŋ geŋ onamí yi kiʼn ziiɗa zakiɗi ye toŋ i kʼise munɗa ye, wo aame yʼalzu ti munɗa seɗeke zaapu ekkʼume seɗeke gen̰n̰o maŋ, yoŋ geŋ i dehu onamí yʼanni seeɗa zakiɗi.” ");
INSERT INTO moz_vpl VALUES ("MT23_19","070_23_19","MAT","23","19","19","Kune ɗoŋ aakede koŋzayi no, a jiire miŋ munɗa seɗeke kunuŋ, ume seɗeke wede i-ti tʼisiyo seɗeke kamilen̰ a ɗaana Raa ko? ");
INSERT INTO moz_vpl VALUES ("MT23_20","070_23_20","MAT","23","20","20","Geŋ iŋkino wede yʼalzu tʼume seɗeke maŋ, geŋ yʼalzu tʼume seɗeke gen̰n̰o wo ti sulɗi pay ɗoŋ eego. ");
INSERT INTO moz_vpl VALUES ("MT23_21","070_23_21","MAT","23","21","21","Wede yʼalzu ti Ɓoy Raa maŋ, geŋ yʼalzu ti Ɓoy gen̰n̰o, wo ti Raa wede i lekkiyo adda pây. ");
INSERT INTO moz_vpl VALUES ("MT23_22","070_23_22","MAT","23","22","22","Wo wede yʼalzu ti kandaane maŋ, geŋ yʼalzu ti kaakido moziko Raa wo ti Raa wede i lekkiyo eego batum. ");
INSERT INTO moz_vpl VALUES ("MT23_23","070_23_23","MAT","23","23","23","Dabar a kune ɗoŋ suuniyo kʼoogoro ti Pariziyeŋ, kune ɗoŋ biziguŋ sire sire! Kuneʼŋ a urzi zakka, kun dʼeliyo zakka a Raa ki ita sulɗi ɗoŋ sun̰n̰i sun̰n̰i i dʼeliyo uŋsuwo a zaami, ise puutagi ɗoŋ ki zaami toŋ maŋ. Wo ɗe sulɗi ɗoŋ a jiire adda kʼoogoro ki Raa, aakede munɗa wede kun dʼise ki diine a ɗuwo, isiyo kʼadde koɗuwo a ɗuwo, ti seeɗu daayum zakiɗi a urzi Raa, kane geŋ kun dʼooliyo a kese. Ki too maŋ ki poone kane gen̰n̰o ɗoŋ kun dʼozire eego me, wo sulɗi ɗoŋ sun̰n̰i sun̰n̰i toŋ kun kiʼn ooli ye. ");
INSERT INTO moz_vpl VALUES ("MT23_24","070_23_24","MAT","23","24","24","Kune ɗoŋ aa koŋzayi i dokkiyo ɗuwo, kune aame kun soɓo ahu geŋ, tuude yi tooriro toŋ kun di yʼamɓu, wo kaciŋ ziŋzo toŋ kun ti soho. ");
INSERT INTO moz_vpl VALUES ("MT23_25","070_23_25","MAT","23","25","25","Dabar a kune ɗoŋ suuniyo kʼoogoro ti Pariziyeŋ, kune ɗoŋ biziguŋ sire sire! Kuneʼŋ kulso ti bogoro kun tʼopilso daaraŋ beehiye, wo addaʼŋ ôoniyo ɓoo ti tama wo ti sulɗi ɗoŋ ulpi tudduguŋ ti dehu. ");
INSERT INTO moz_vpl VALUES ("MT23_26","070_23_26","MAT","23","26","26","Kune Pariziyeŋ ɗoŋ aakede koŋzayi no, ki poone kulso kun tʼopilo addutú kamilen̰ ɗoo miŋ, iŋkino maŋ dartú toŋ a-tʼisa kamilen̰ pây. ");
INSERT INTO moz_vpl VALUES ("MT23_27","070_23_27","MAT","23","27","27","Dabar a kune ɗoŋ suuniyo kʼoogoro ti Pariziyeŋ, kune ɗoŋ biziguŋ sire sire! Kun deeƴiso aa muuziyagi ɗoŋ an an tʼeliyo buuye tuware kʼa wolle beehiye, kaciŋ tʼaddaʼŋ ôoniyo ɓoo tʼossagi ki ɗoŋ i tʼinda, ti ita sulɗi ɗoŋ pay ruumiyo. ");
INSERT INTO moz_vpl VALUES ("MT23_28","070_23_28","MAT","23","28","28","Wo kune toŋ iŋkino, a eda ɗuwo kun ti tʼisiyo tudduguŋ kune ki diine a ɗaana Raa, kaciŋ biziguŋ sire sire wo adduguŋ ôoniyo ɓoo ti sulɗi ɗoŋ ulpi. ");
INSERT INTO moz_vpl VALUES ("MT23_29","070_23_29","MAT","23","29","29","Dabar a kune ɗoŋ suuniyo kʼoogoro ti Pariziyeŋ, kune ɗoŋ biziguŋ sire sire! Kun aabuɗu muuziyagi majjanɗani ki nebiyagi ti kaaga, wo a kane ɗoŋ ki diine muuziyagaŋ kun tiʼn raaŋiya murkic ti buuye, ");
INSERT INTO moz_vpl VALUES ("MT23_30","070_23_30","MAT","23","30","30","wo kun dʼeesiyo: “Aame ti eda moŋgiɗagey geŋ kaye ede maŋ, ay a ki ti kette kaŋ soo ye ti ɗoŋ tôwwo nebiyagi me.” ");
INSERT INTO moz_vpl VALUES ("MT23_31","070_23_31","MAT","23","31","31","A onamguŋ ti sulɗi ɗoŋ kun isiyo geŋ, i-kaza kune itaguŋ soo ti ɗoŋ îide nebiyagi me. ");
INSERT INTO moz_vpl VALUES ("MT23_32","070_23_32","MAT","23","32","32","Ɗe iŋkino maŋ, kun dʼodo tʼiŋkino aakede ki maawuguŋ gʼaaze! ");
INSERT INTO moz_vpl VALUES ("MT23_33","070_23_33","MAT","23","33","33","Kune aa mimbayi wo ɗoŋ ulpi aakede maŋkikagi, ki kotto kun ki tʼalɗa ye, booro tʼun diʼn seeɗa kʼadda kʼuwwo. ");
INSERT INTO moz_vpl VALUES ("MT23_34","070_23_34","MAT","23","34","34","Kono kamo kun ollo, nʼun tʼigibo nebiyagi ti ɗoŋ suuniyo kʼoogoro, wo ɗuwo ɗoŋ un diʼn dooya urzi Raa. Ɗoŋ soŋ kun tiʼn tʼîda, ɗoŋ oŋgo kun tiʼn taakita ekkʼinda ɗoŋ zappu ekkʼeebaŋ kaŋ tontilko, ɗoŋ oŋgo soŋ kun diʼn gorpipa ti marpa adda ɓoyɗi ɗoŋ kun di dooyiso, wo kun diʼn limmita geeger ti geeger. ");
INSERT INTO moz_vpl VALUES ("MT23_35","070_23_35","MAT","23","35","35","Tʼume kʼeesiyo duniya bini aŋki, kune Yawudiyagi kun îide ɗoŋ ki diine ɓaadaŋ, wo kono ki puuzadaŋ gette kune Raa yʼun tiʼn tʼela daŋgay. Ki poone kun îide Abel wede ki diine, saŋ ɗoŋ ti doolo bini Zakari ulo Barasi wede kun yʼîide adda booro Ɓoy Raa, a diine Ɓoy Raa ti ume seɗeke. ");
INSERT INTO moz_vpl VALUES ("MT23_36","070_23_36","MAT","23","36","36","Ɗerec iŋkino wo nʼun di rooto: Kane ɗoŋ aŋken̰n̰o eŋ Raa yi tiʼn tʼela daŋgay kono ki puuzo kane pay gette.» ");
INSERT INTO moz_vpl VALUES ("MT23_37","070_23_37","MAT","23","37","37","«Wayya kune ɗoŋ Zeruzalem no! Wayya kune ɗoŋ Zeruzalem no! Kune ɗoŋ i tôwwito nebiyagi, wo ɗoŋ Raa yʼun akkisa kun tiʼn kakkisa ti moŋgali kun tiʼn tôwwo. Nuŋ taŋ ɓaadaŋ ɓaadaŋ nʼa dihe nʼun tiʼn tusse aa ôsso ti tussiyo in̰n̰itú adda kambartú, wo ɗe kun ki dihe ye! ");
INSERT INTO moz_vpl VALUES ("MT23_38","070_23_38","MAT","23","38","38","Iŋkino maŋ ɓoyguŋ Raa yʼun di yʼoola. ");
INSERT INTO moz_vpl VALUES ("MT23_39","070_23_39","MAT","23","39","39","Wo kun ollo nʼun di rooto, ti aŋki nuŋ kun ki nʼ wolla ye baa, bini a tʼîda onniyo ere kun di roota: “Beeko Raa ti koona a ekki wede ettiyo ti suma Galmeega Raa.”» ");
INSERT INTO moz_vpl VALUES ("MT24_1","070_24_1","MAT","24","1","1","Isa yi tʼuɗɗe tʼadda booro Ɓoy Raa wo yi dehu yʼeŋgile maŋ, kane sanalliyagí an a dʼiide sirpadí kono an i di kize majjaanika kʼoozige Ɓoy Raa. ");
INSERT INTO moz_vpl VALUES ("MT24_2","070_24_2","MAT","24","2","2","Maŋ Isa yʼan di ruute, yʼede: «Pay eŋ kun wolliyo ɗeʼŋ? Wo ɗerec nʼun di rooto, mokkolo soo toŋ tʼekki bakatú i ki lekka ye, pay a ruuga.» ");
INSERT INTO moz_vpl VALUES ("MT24_3","070_24_3","MAT","24","3","3","Isa yʼiiney ekki mokkolo kʼInda kʼOlibiye, maŋ yʼa-guune siidí. Aame geŋ sanalliyagi an a dʼiide sirpadí wo an di yʼ tunde, anʼde: «Kee kʼay ki ti rooti ɗoo, sulɗi geŋ an aana woogo me? Wo moo me munɗa wede a kiza urzi kamadá ti onniyo ere duniya ti ɗaŋga me?» ");
INSERT INTO moz_vpl VALUES ("MT24_4","070_24_4","MAT","24","4","4","Isa yʼan diʼn gime onamaŋ, yʼede: «Kun koona mentikagi, wenɗa soo toŋ yʼun tiʼn dagga ye. ");
INSERT INTO moz_vpl VALUES ("MT24_5","070_24_5","MAT","24","5","5","Ɗerec, i dʼetto ɗoŋ ɓaadaŋ an tʼamɓo sundó, wede tuuku toŋ yʼa tʼeesa: “Nuŋ Almasi Raa yi biire!”, wo kane geŋ an di dagga ɗuwo ɓaadaŋ. ");
INSERT INTO moz_vpl VALUES ("MT24_6","070_24_6","MAT","24","6","6","Kun dʼolliga tarkuuse ki arka goppoŋ, wo kun dʼolliga rabila kʼarka dokki. Aame geŋ kun koona mentikagi, kun addira ye. I dehu sulɗi geŋ an dʼaane, wo aame geŋ a ki tʼisa ɗaŋgiya duniya ye ɓotto. ");
INSERT INTO moz_vpl VALUES ("MT24_7","070_24_7","MAT","24","7","7","Ɗoŋ siiɗo soo ti siiɗo soo te an ɗeyya ti tuddaŋ, ɗoŋ mozigo soo ti mozigo soo me an ɗeyya ti tuddaŋ kay. I dʼisa mosogo ti ŋoŋŋirso siiɗo adda siiɗiyagi ɓaadaŋ. ");
INSERT INTO moz_vpl VALUES ("MT24_8","070_24_8","MAT","24","8","8","Wo kane sulɗi pay geŋ, aakede kakkisa ere ki poone kʼerewo addutú i tʼumɓe kʼehiyo. ");
INSERT INTO moz_vpl VALUES ("MT24_9","070_24_9","MAT","24","9","9","Iŋkino maŋ ɗuwo an un diʼn tʼela bey ɗoŋ kʼaduguŋ kono an un diʼn dabira wo an un tiʼn tʼîda. Wo kane ɗoŋ siiɗiyagi pay an un diʼn olmiɗa kono kun umɓe a sundó. ");
INSERT INTO moz_vpl VALUES ("MT24_10","070_24_10","MAT","24","10","10","Aame geŋ ɗoŋ ɓaadaŋ urzi zaapu kʼaddaŋ a nuŋ an dʼoola, kane geŋ an dʼoɗɗipa ita tuddaŋ ki seɗɗuzaŋ, wo an dʼolmiɗa tuddaŋ. ");
INSERT INTO moz_vpl VALUES ("MT24_11","070_24_11","MAT","24","11","11","I dʼaɗɗa ɗoŋ ɓaadaŋ an ti tʼisa tuddaŋ aa nebiyagi, wo kane geŋ an dagga ɗoŋ ɓaadaŋ. ");
INSERT INTO moz_vpl VALUES ("MT24_12","070_24_12","MAT","24","12","12","A ume tuuku toŋ sulɗi ɗoŋ ulpi geŋ an dʼaagila kʼaagulu, iŋkino geyyiso tudde toŋ tʼa tʼisa baata. ");
INSERT INTO moz_vpl VALUES ("MT24_13","070_24_13","MAT","24","13","13","Wo ɗe wede yʼa ziiɗa zakiɗi a urzizó bini ɗaŋgu maŋ, yode geŋ Raa yʼa yʼutta. ");
INSERT INTO moz_vpl VALUES ("MT24_14","070_24_14","MAT","24","14","14","I dehu Rabila Majjaanawa ki Moziko Raa gette an di kizite adda siiɗiyagi pay, wo kane ita ɗuwo pay toŋ an di tʼolliga ti kuudaŋ ɗoo miŋ, saŋ duniya tʼa ɗaŋga kollo.» ");
INSERT INTO moz_vpl VALUES ("MT24_15","070_24_15","MAT","24","15","15","«Kune kun di wolla munɗa wede ulsu kʼa yʼazzira wo yi lattiya, geŋ a-tʼetta a ono ɗoŋ ti kaaga nebi Daniyel yi ruute, munɗa geŋ an ti yʼ zaapa adda Ɓoy Raa a ume wede kamilen̰. Wede i gariya ono eŋ eedí tiʼni sooɗo beehiye. ");
INSERT INTO moz_vpl VALUES ("MT24_16","070_24_16","MAT","24","16","16","Aame geŋ kane ɗoŋ adda siiɗo Ziide an tʼombo kʼekki moŋgali. ");
INSERT INTO moz_vpl VALUES ("MT24_17","070_24_17","MAT","24","17","17","Wede yʼa ti gili yi-guune tʼekki daŋgayadí maŋ, yoŋ geŋ yi-ɗeega amɓu munɗa adda daŋgay ye, yi tʼombo. ");
INSERT INTO moz_vpl VALUES ("MT24_18","070_24_18","MAT","24","18","18","Wo wede yoŋ adda doome maŋ, yi tʼombo, yi kima ɓoy amɓu kallayí wede goole ye. ");
INSERT INTO moz_vpl VALUES ("MT24_19","070_24_19","MAT","24","19","19","A onniytagi geŋ aasa dabar ɓaadaŋ a kane erayi ɗoŋ mahuwagi ti ɗoŋ in̰n̰izaŋ an ooɗiyo! ");
INSERT INTO moz_vpl VALUES ("MT24_20","070_24_20","MAT","24","20","20","Kun tondo Raa kono okkaguŋ tʼa kʼisa a ume reele, ise a onniyo ere ki puukiyadiŋ ye. ");
INSERT INTO moz_vpl VALUES ("MT24_21","070_24_21","MAT","24","21","21","Iŋkino maŋ dabar gette tʼaasa oon̰e ɓaadaŋ. Tʼume kʼeesiyo duniya bini aŋken̰n̰o, dabar iŋkino i kʼize ye, wo ki ɗaana toŋ i kʼisa ye. ");
INSERT INTO moz_vpl VALUES ("MT24_22","070_24_22","MAT","24","22","22","Aame onniytagi ɗoŋ ki dabar geŋ Raa yʼa kiʼn îhira goppoŋ ye maŋ, wede tudde soo toŋ umbo a lekka zeere me. Wo ki kotto onniytagi geŋ yʼan ôhira goppoŋ kono ɗoŋ yi biire ki yode. ");
INSERT INTO moz_vpl VALUES ("MT24_23","070_24_23","MAT","24","23","23","Iŋkino maŋ aame wenɗa yʼiisa: “Almasi Raa yi biire, yoŋ a en̰n̰o!” ise “Yoŋ a ummey!” maŋ, kune onamí kun amɓa ye. ");
INSERT INTO moz_vpl VALUES ("MT24_24","070_24_24","MAT","24","24","24","Ni rootiyo iŋkino kono i dʼaɗɗa ɗuwo an ti tʼisa tuddaŋ aa Almasi Raa yi biire, wo ti ɗuwo an ti tʼisa tuddaŋ aa nebiyagi. Kane geŋ an dʼisa sulɗi kʼarmika ti sulɗi ɗoŋ i ceeriyo eego, aame urzi ede maŋ kane an di dagga ɗuwo ɗoŋ Raa yi biire ki yode, wo an ki dʼaana ye. ");
INSERT INTO moz_vpl VALUES ("MT24_25","070_24_25","MAT","24","25","25","Kun ollo, sulɗi eŋ nʼun tiʼn ruute ki poone an dʼaana. ");
INSERT INTO moz_vpl VALUES ("MT24_26","070_24_26","MAT","24","26","26","Iŋkino maŋ, aame an un ruuta, an iisa: “Kun ollo, Almasi Raa yi biire, yoŋ adda balɗa!” maŋ, kunʼta ye, ise wenɗa yʼun ruuta, yʼiisa: “Kun ollo, yoŋ yi tʼumbiɗa a en̰n̰o!” toŋ maŋ, kun amɓa ye a onamí me. ");
INSERT INTO moz_vpl VALUES ("MT24_27","070_24_27","MAT","24","27","27","Ɗerec, aa kun wolliyo mizzi yʼomile i-ti tooriyo kandaane ti kese peeɗo ge-koliyo bini peeɗo kʼooriyo geŋ, aaniya ki nuŋ wede an nʼehe aa ulo wede en̰n̰o toŋ, tʼaasa iŋkino kay. ");
INSERT INTO moz_vpl VALUES ("MT24_28","070_24_28","MAT","24","28","28","A ume wede nuune yi tʼudiga geŋ, zumbi toŋ ti tʼogiya aŋgen̰n̰o.» ");
INSERT INTO moz_vpl VALUES ("MT24_29","070_24_29","MAT","24","29","29","«Onniytagi ɗoŋ ki dabar geŋ an tʼiŋgila lewwet maŋ, peeɗo ti ki toora ye, tere yi ki toora ye, molɗali an silɗita ti kandaane, wo sulɗi ɗoŋ an dʼede toogo a kandaane, Raa yʼa tiʼn gozziga. ");
INSERT INTO moz_vpl VALUES ("MT24_30","070_24_30","MAT","24","30","30","Aame geŋ a kandaane i dʼisa munɗa a kiza kama ki nuŋ wede an nʼehe aa ulo wede en̰n̰o. Iŋkino ita ɗuwo pay adda duniya an ɗillita môolo wo an di nʼ wolla nuŋ wede an nʼehe aa ulo wede eŋ, ni kama ti kandaane ekki dondirso ti toogo ere pay wo ti darƴika ere o dʼede. ");
INSERT INTO moz_vpl VALUES ("MT24_31","070_24_31","MAT","24","31","31","Maaleeka yʼa baaha parre ti kandaane, nʼa tʼigiba maaleekiyagó kʼadda siiɗiyagi ɗoŋ a duniya itatú piɗe, an di tʼogiya ɗoŋ ni biire.» ");
INSERT INTO moz_vpl VALUES ("MT24_32","070_24_32","MAT","24","32","32","«Kun wollo wo kun elko a ono ombiɗe ɗoŋ a tukki tormo ettiyo: Aame tormo tʼeesiyo oɗɗize wo puutagutú eesiyo rooɓiyo maŋ, geŋ kune kun suune adda kʼadduguŋ kizini yoŋ goppoŋ. ");
INSERT INTO moz_vpl VALUES ("MT24_33","070_24_33","MAT","24","33","33","Geŋ iŋkino kay, kune toŋ kun wulla sulɗi pay geŋ an iina maŋ, kun suuno kama ki nuŋ wede an nʼehe aa ulo wede eŋ todʼte goppoŋ, aakede nuŋ a biza bumɓuguŋ. ");
INSERT INTO moz_vpl VALUES ("MT24_34","070_24_34","MAT","24","34","34","Ɗerec iŋkino wo nʼun di rooto: Ɗoŋ aŋken̰n̰o eŋ an ki ti tʼinda pay ye, ki poone sulɗi pay geŋ an dʼaana me. ");
INSERT INTO moz_vpl VALUES ("MT24_35","070_24_35","MAT","24","35","35","Kandaane kane ti siiɗo an tʼeŋgila, wo kane onamó an ki tʼeŋgila ye, an di lekka ki daayum.» ");
INSERT INTO moz_vpl VALUES ("MT24_36","070_24_36","MAT","24","36","36","«Wo sulɗi geŋ an aana a onniyo tuuku koo, a peeɗo ere tuuku koo maŋ, i suune yode Meega Raa siidí. Wenɗa doolo yi ki suune ye, ise maaleekiyagi a kandaane, ise Ulo Raa toŋ maŋ. ");
INSERT INTO moz_vpl VALUES ("MT24_37","070_24_37","MAT","24","37","37","Munɗa wede ize ti kaaga a ozzinagi ɗoŋ ki Nowe geŋ, a kama ki nuŋ wede an nʼehe aa ulo wede en̰n̰o toŋ, aasa iŋkino kay. ");
INSERT INTO moz_vpl VALUES ("MT24_38","070_24_38","MAT","24","38","38","Adda kʼonniytagi ɗoŋ ti kaaga ki poone mizzi goole yʼa koppa, ahu an tʼooma siiɗo geŋ, ɗuwo an dʼomɓo, an soɓo, an seɗɗu ti tuddaŋ bini onniyo ere Nowe yi-tʼiide adda tooko ere meeda a jiire. ");
INSERT INTO moz_vpl VALUES ("MT24_39","070_24_39","MAT","24","39","39","Kane ulbaŋ an kʼooɗiyo a munɗa ye bini mizzi goole yʼa guppe, ahu an tʼiimi siiɗo, iŋkino ɗuwo geŋ pay an tʼinda adda kʼahu. Geŋ aasa iŋkino kay a kama ki nuŋ wede an nʼehe aa ulo wede eŋ me. ");
INSERT INTO moz_vpl VALUES ("MT24_40","070_24_40","MAT","24","40","40","Iŋkino maŋ kuuli sire kane adda doome soo, wede soo geŋ an di yʼamɓa wo wede soŋ an di yʼoola. ");
INSERT INTO moz_vpl VALUES ("MT24_41","070_24_41","MAT","24","41","41","Erayi sire an massu kaŋ soo, ere soo an ti tʼamɓa wo ere soo an di tʼoola. ");
INSERT INTO moz_vpl VALUES ("MT24_42","070_24_42","MAT","24","42","42","Iŋkino kun lekko zeere, kono kun ki suune ye onniyo ere tuuku nuŋ Galmeeguguŋ ni kimo te. ");
INSERT INTO moz_vpl VALUES ("MT24_43","070_24_43","MAT","24","43","43","Ono eŋ kun ollo koɗuwo: Aame wede ɓoy geŋ yi suune peeɗo ere tuuku a diɗɗo wede kʼoogire yʼetto maŋ, yʼa lekke zeere, yi kʼooli wede kʼoogire yi-ki tʼette kʼadda ɓoozí ye. ");
INSERT INTO moz_vpl VALUES ("MT24_44","070_24_44","MAT","24","44","44","Geŋ iŋkino kune toŋ maŋ kun koona mentikagi, kono nuŋ wede an nʼehe aa ulo wede eŋ, nʼetto a peeɗo ere tuuku kun ki ti suune ye.» ");
INSERT INTO moz_vpl VALUES ("MT24_45","070_24_45","MAT","24","45","45","«Iŋkino maŋ wede naabo wede i seeɗu zakiɗi a naabadí wo i-dʼede elkiyo geŋ, a yode gen̰n̰o galmeegí yi oola attiɗi pay ki ɗoŋ naabadí oŋgoŋ me, kono yʼan tʼela omɓadaŋ aame peeɗo tʼîida maŋ. ");
INSERT INTO moz_vpl VALUES ("MT24_46","070_24_46","MAT","24","46","46","Uŋsuwo a wede naabo geŋ me, aame galmeegí a kamadí yi yʼuuna yʼisiyo naabo gettiyo maŋ. ");
INSERT INTO moz_vpl VALUES ("MT24_47","070_24_47","MAT","24","47","47","Ɗerec iŋkino wo nʼun di rooto: Wede iŋkino geŋ galmeegí yi di tʼela attiɗi ki sulɗizí pay a beezí. ");
INSERT INTO moz_vpl VALUES ("MT24_48","070_24_48","MAT","24","48","48","Wo ɗe aakede wede naabo ulsu geŋ yʼilka adda kʼaddí, yʼiisa: “Galmeegó eŋ yi tʼûsso”, ");
INSERT INTO moz_vpl VALUES ("MT24_49","070_24_49","MAT","24","49","49","wo yi tʼiida taazu ɗoŋ an naabiya kaŋ soo, wo yi tʼussa a omɓo ti soɓito tʼeebí ɗoŋ i soɓo i ceeriyo eego. ");
INSERT INTO moz_vpl VALUES ("MT24_50","070_24_50","MAT","24","50","50","Maŋ galmeegí yʼa aana a onniyo ere wede naabo geŋ yi kʼelkiyo ye, wo a peeɗo ere yi ki ti suune ye. ");
INSERT INTO moz_vpl VALUES ("MT24_51","070_24_51","MAT","24","51","51","Galmeegí yi di tʼela daŋgay ere zakiɗi wo yi-tʼela aggadí aa ki ɗoŋ bizaŋ sire sire, a ume wede ki ɗollite môolo wo kʼaaɗumu sina.» ");
INSERT INTO moz_vpl VALUES ("MT25_1","070_25_1","MAT","25","1","1","Isa yʼa ruute sey, yʼede: «Iŋkino maŋ Moziko Raa todʼ ti deeƴiso aa naabo konazi kane koomat an di zikiti lampiyagaŋ an tʼiide okkime ki kule yi seeɗu erewo. ");
INSERT INTO moz_vpl VALUES ("MT25_2","070_25_2","MAT","25","2","2","Ti diine kane konazi geŋ, ɗoŋ paat soŋ elkiyadaŋ umbo wo ɗoŋ paat soŋ an dʼede elkiyo. ");
INSERT INTO moz_vpl VALUES ("MT25_3","070_25_3","MAT","25","3","3","Kane konazi ɗoŋ elkiyadaŋ umbo geŋ lampiyagaŋ an tʼûunite tʼegey wo ti doolo an a ki dʼumɓe ye a beezaŋ me. ");
INSERT INTO moz_vpl VALUES ("MT25_4","070_25_4","MAT","25","4","4","Wo kane konazi ɗoŋ an dʼede elkiyo geŋ, lampiyagaŋ an tʼûunite wo an a dʼiipe egey adda kuŋgilagaŋ. ");
INSERT INTO moz_vpl VALUES ("MT25_5","070_25_5","MAT","25","5","5","Wo yo wede i seeɗu erewo geŋ yi-tʼusso yʼa kʼiina kesiko ye, iŋkino maŋ kane konazi geŋ moone tʼan diʼn ziiɗa pay, an dʼudige kuy. ");
INSERT INTO moz_vpl VALUES ("MT25_6","070_25_6","MAT","25","6","6","A diɗɗo meeda maŋ an dʼilliga ɗolle, anʼde: “Kun ollo, kule wede i seeɗu erewo yʼettiyo! Kun tʼaɗɗi okkimayí!” ");
INSERT INTO moz_vpl VALUES ("MT25_7","070_25_7","MAT","25","7","7","Iŋkino maŋ kane konazi pay geŋ an tʼinnite wo lampiyagaŋ an diʼn ikkima. ");
INSERT INTO moz_vpl VALUES ("MT25_8","070_25_8","MAT","25","8","8","Kane ɗoŋ elkiyadaŋ umbo geŋ, an tunde a bey ɗoŋ an dʼede elkiyo, anʼde: “Kun ay eeli egayguŋ kono lampiyagey i tʼunto.” ");
INSERT INTO moz_vpl VALUES ("MT25_9","070_25_9","MAT","25","9","9","Wo kane ɗoŋ an dʼede elkiyo geŋ an an diʼn gime onamaŋ, anʼde: “Aha, in ki tʼîda ye! Kunʼdo kʼume kʼowilte, kun owili a kune me.” ");
INSERT INTO moz_vpl VALUES ("MT25_10","070_25_10","MAT","25","10","10","Kane an dʼiŋgile an dʼowilo egey me, koore geŋ yo kule wede i seeɗu erewo, yʼa iina. Maŋ kane konazi ɗoŋ paat i tʼikkima tuddaŋ geŋ, an tʼiide kʼadda ɓoy tarnaape seeɗu ti yode kaŋ soo, wo biza yʼan tʼippe ti kerle. ");
INSERT INTO moz_vpl VALUES ("MT25_11","070_25_11","MAT","25","11","11","Saŋ maŋ kane konazi ɗoŋ elkiyadaŋ umbo geŋ an dʼiina, an dʼiise ɗollite, anʼde: “Galmeegey, Galmeegey, kʼay tʼohon!” ");
INSERT INTO moz_vpl VALUES ("MT25_12","070_25_12","MAT","25","12","12","Wo ɗe yoŋ yʼan diʼn gime onamaŋ, yʼede: “Ɗerec iŋkino wo nʼun di rooto: Kune aŋ wenɗa nʼun kiʼn suune ye.”» ");
INSERT INTO moz_vpl VALUES ("MT25_13","070_25_13","MAT","25","13","13","Maŋ Isa yʼa ruute, yʼede: «Iŋkino maŋ kun lekko zeere, kono onniyo tuuku ise peeɗo tuuku ere nʼetto kun ki ti suune ye.» ");
INSERT INTO moz_vpl VALUES ("MT25_14","070_25_14","MAT","25","14","14","«Wo soŋ Moziko Raa gette todʼ ti deeƴiso aa naabo wede ɓoy iŋkino, yi dehu yʼeŋgile torguwo. Ki poone yʼa eŋgila geŋ, yʼa wiike ɗoŋ naabadí yʼan dʼooli laalayí a beezaŋ. ");
INSERT INTO moz_vpl VALUES ("MT25_15","070_25_15","MAT","25","15","15","A wede soŋ yi dʼele tammiyagi ki dap dupu paat, a wede soo yi dʼele tammiyagi ki dap dupu sire wo a wede soŋ yi dʼele tammiyagi ki dap dupu soo, a wede tuuku toŋ yi-dʼeele a toogadí toogadí, maŋ yoŋ tuddí yʼa iŋgile. ");
INSERT INTO moz_vpl VALUES ("MT25_16","070_25_16","MAT","25","16","16","Wede galmeegí yi ele tammiyagi dupu paat geŋ, kesiko yʼa iŋgile yi naabiya eego tʼaa dʼaagulu wo yʼa dʼuune tʼeego tammiyagi dupu paat sey. ");
INSERT INTO moz_vpl VALUES ("MT25_17","070_25_17","MAT","25","17","17","Wede galmeegí yi ele tammiyagi dupu sire toŋ iŋkino, yʼa ti niibe yʼa dʼuune tʼeego tammiyagi dupu sire. ");
INSERT INTO moz_vpl VALUES ("MT25_18","070_25_18","MAT","25","18","18","Wo wede galmeegí yi ele tammiyagi dupu soo geŋ, yʼa iŋgile yʼiideʼŋ yi dʼittiba olɗe a siiɗo wo soŋko galmeegí yi-tʼumbiɗa adda. ");
INSERT INTO moz_vpl VALUES ("MT25_19","070_25_19","MAT","25","19","19","Galmeeʼki ɗoŋ naabo geŋ yi likko bini maŋ, saŋ yʼa aaho wo yʼa dihe yʼa wolle soŋko ere ɗoŋ naabadí an i di tʼele. ");
INSERT INTO moz_vpl VALUES ("MT25_20","070_25_20","MAT","25","20","20","Wede galmeegí yi ele tammiyagi dupu paat geŋ, yʼa dʼiide sirpadí, yi-dʼele tammiyagi dupu paat ɗoŋ yʼuune tʼeego gen̰n̰o, wo yi di ruute, yʼede: “Galmeeʼki nuŋ, kee kʼo iili tammiyagi dupu paat nʼa niibe, nʼaa dʼuune tammiyagi dupu paat ti doolo, aŋkeŋ en̰n̰o ki wollo.” ");
INSERT INTO moz_vpl VALUES ("MT25_21","070_25_21","MAT","25","21","21","Maŋ galmeegí yi di ruute, yʼede: “Geŋ koɗuwo kee wede naabo beehiye ki seeɗu zakiɗi a naabadá, kee a naabo ere booloŋ gettiŋ kʼa ti ziiɗa zakiɗi, aŋkeŋ nʼa-ki ti zaapo a naabo ere ɓaadaŋ. Kʼedi, kʼisa uŋsuwo ti nuŋ galmeegá.” ");
INSERT INTO moz_vpl VALUES ("MT25_22","070_25_22","MAT","25","22","22","Saŋ maŋ wede galmeegí yi ele tammiyagi dupu sire geŋ, yʼa dʼiide sirpadí yi di ruute, yʼede: “Galmeeʼki nuŋ, kee kʼo iili tammiyagi dupu sire nʼa niibe, nʼaa dʼuune tammiyagi dupu sire ti doolo, aŋkeŋ en̰n̰o ki wollo.” ");
INSERT INTO moz_vpl VALUES ("MT25_23","070_25_23","MAT","25","23","23","Maŋ galmeegí yi di ruute, yʼede: “Geŋ koɗuwo kee wede naabo beehiye ki seeɗu zakiɗi a naabadá, kee a naabo ere booloŋ gettiŋ kʼa ti ziiɗa zakiɗi, aŋkeŋ nʼa-ki ti zaapo a naabo ere ɓaadaŋ. Kʼedi, kʼisa uŋsuwo ti nuŋ galmeegá.” ");
INSERT INTO moz_vpl VALUES ("MT25_24","070_25_24","MAT","25","24","24","Maŋ wede galmeegí yi ele tammiyagi dupu soo geŋ, yʼa dʼiide sirpadí yi di ruute, yʼede: “Galmeeʼki nuŋ, ni suune kee wehini a naabo me, ki dʼayɗu a ume wede ki ki giira ye, wo ki sokiyo a ume wede ki ki zire ye toŋ maŋ. ");
INSERT INTO moz_vpl VALUES ("MT25_25","070_25_25","MAT","25","25","25","Iŋkino nʼa urgiɗe, nʼiideʼŋ ni dʼittiba olɗe a siiɗo, tammiyagi dupu soo geŋ ni tʼumbiɗa adda, aŋkeŋ laalayá en̰n̰o ki wollo.” ");
INSERT INTO moz_vpl VALUES ("MT25_26","070_25_26","MAT","25","26","26","Wo galmeegí yi diʼn gime onamí, yʼede: “Kee wede naabo ulsu wo golge, ki suune ni dʼayɗu a ume wede ni ki giira ye, wo ni sokiyo a ume wede ni ki zire ye. ");
INSERT INTO moz_vpl VALUES ("MT25_27","070_25_27","MAT","25","27","27","Iŋkino ki moo me soŋkadó kʼo gi di ziipe adda baŋki ye me, tʼo dʼaagila, a kamadó geŋ nʼiido nʼa-tʼamɓe ti jugulu.” ");
INSERT INTO moz_vpl VALUES ("MT25_28","070_25_28","MAT","25","28","28","Iŋkino yʼan di ruute a kane ɗoŋ a sirpadí geŋ, yʼede: “Tammiyagi dupu soo geŋ kun ti sooɗo, kun i elo a wede i-dʼede tammiyagi dupu koomat. ");
INSERT INTO moz_vpl VALUES ("MT25_29","070_25_29","MAT","25","29","29","Ɗerec, a wede i-dʼede geŋ, an i-tʼeela tʼeego i di tʼisa ɓaadaŋ a ceera, wo ɗe a wede i-kʼede ye geŋ, munɗazí wede booloŋ yʼelkiyo yi tʼoona toŋ an i-tʼamɓa. ");
INSERT INTO moz_vpl VALUES ("MT25_30","070_25_30","MAT","25","30","30","Wo ki yo wede a naabo kontilme geŋ, kun di seɗɗi ti paate adda zimolo, ume wede ki ɗollite môolo wo kʼaaɗumu sina.”» ");
INSERT INTO moz_vpl VALUES ("MT25_31","070_25_31","MAT","25","31","31","«A onniyo kʼita nuŋ wede an nʼehe aa ulo wede eŋ, nʼa-kimo adda mozikadó ti maaleekiyagi pay geŋ, nʼa di koona a kaakido moziko adda darƴikadó. ");
INSERT INTO moz_vpl VALUES ("MT25_32","070_25_32","MAT","25","32","32","Ita ɗuwo pay an di tʼogiya a ɗaanadó, wo ɗuwo nʼa tiʼn dokkiɗa sire aakede wede kʼelso yʼâhuntu mooɗe ti damɓami. ");
INSERT INTO moz_vpl VALUES ("MT25_33","070_25_33","MAT","25","33","33","Nʼan ooya kane ɗoŋ aa damɓami a beezó kʼammade, wo kane ɗoŋ aa mooɗe a beezó ki geelo. ");
INSERT INTO moz_vpl VALUES ("MT25_34","070_25_34","MAT","25","34","34","Iŋkino maŋ nuŋ mozigo nʼan di roota a kane ɗoŋ a ammidadó, nʼa tʼeesa: “Kunʼdi kune ɗoŋ Meegó Raa yʼun ti ziipe beeko, kun tʼodo a Moziko Raa, todʼte yoŋ yʼun tʼikkima a kune, tʼume kʼeesiyo duniya too. ");
INSERT INTO moz_vpl VALUES ("MT25_35","070_25_35","MAT","25","35","35","Nʼun rootiyo iŋkino kono aame nuŋ mosogo, omɓo kun o dʼeele, aame nuŋ ôrme, ahu kun o dʼeele, aame nuŋ torgusu, kun di nʼ ziiɗa bey sire. ");
INSERT INTO moz_vpl VALUES ("MT25_36","070_25_36","MAT","25","36","36","Aame nuŋ bontilin̰, kun di nʼ usse, aame nuŋ tuddó eeni kun tʼiide tondiyadó, wo aame nuŋ adda daŋgay toŋ kun tʼiide wolliyadó.” ");
INSERT INTO moz_vpl VALUES ("MT25_37","070_25_37","MAT","25","37","37","Iŋkino maŋ kane ɗoŋ ki diine an o tiʼn kima onamó, an tʼeesa: “Galmeegey, woogo me kaye ay gi di wulle kee mosogo wo ay a dʼeele omɓo me, ay gi di wulle kee ôrme wo ay a dʼele ahu me, ");
INSERT INTO moz_vpl VALUES ("MT25_38","070_25_38","MAT","25","38","38","ay gi di wulle kee torgusu wo ay gi di ziiɗa bey sire me, ay gi di wulle kee bontilin̰ wo ay ki ti kʼusse me? ");
INSERT INTO moz_vpl VALUES ("MT25_39","070_25_39","MAT","25","39","39","Woogo me kaye ay dʼilliga kee tuddá eeni wo ay dʼiide tondiyadá me, ay dʼilliga kee adda daŋgay wo ay dʼiide wolliyadá me?” ");
INSERT INTO moz_vpl VALUES ("MT25_40","070_25_40","MAT","25","40","40","Wo nuŋ mozigo nʼan diʼn kima onamaŋ, nʼa tʼeesa: “Ɗerec iŋkino wo nʼun di rooto: Aame tuuku kun ize munɗa soo a wede soo ti diine zemɓadó ɗuwo an i kʼeliyo suma ye geŋ, geŋ kun ize a nuuno.” ");
INSERT INTO moz_vpl VALUES ("MT25_41","070_25_41","MAT","25","41","41","Saŋ maŋ nuŋ mozigo nʼan di roota a kane ɗoŋ a geeladó, nʼa tʼeesa: “Kune ɗoŋ egguŋ duuɗiyo, kun ti leɗɗo ti tuddó me, kun eŋgilo kʼadda kʼuwwo ere tʼoggiyo ki daayum, Raa yi muɗɗe a Meeda siitanɗani ti maaleekiyagutú. ");
INSERT INTO moz_vpl VALUES ("MT25_42","070_25_42","MAT","25","42","42","Dabar gette kun uune kono aame nuŋ mosogo, omɓo kun o kʼeele ye, aame nuŋ ôrme, ahu kun o kʼeele ye. ");
INSERT INTO moz_vpl VALUES ("MT25_43","070_25_43","MAT","25","43","43","Aame nuŋ torgusu geŋ kun ki nʼ ziiɗa bey sire ye, aame nuŋ bontilin̰ geŋ kun gi di nʼusse ye, aame nuŋ tuddó eeni wo adda daŋgay geŋ wolliyadó kun kʼiide ye.” ");
INSERT INTO moz_vpl VALUES ("MT25_44","070_25_44","MAT","25","44","44","Iŋkino maŋ kane toŋ an o tiʼn kima onamó, an tʼeesa: “Galmeegey, woogo me kaye ay gi di wulle kee mosogo ise ôrme, torgusu ise bontilin̰, ise ay dʼilliga kee tuddá eeni ise adda daŋgay wo ay gi di nuuge ye me?” ");
INSERT INTO moz_vpl VALUES ("MT25_45","070_25_45","MAT","25","45","45","Maŋ nuŋ mozigo nʼan diʼn kima onamaŋ, nʼa tʼeesa: “Ɗerec iŋkino wo nʼun di rooto: Aame tuuku munɗa soo kun kʼize ye a wede soo ti diine kane ɗoŋ ɗuwo an i-kʼeliyo suma ye geŋ, kune kun kʼize ye a nuuno.” ");
INSERT INTO moz_vpl VALUES ("MT25_46","070_25_46","MAT","25","46","46","Wo kane geŋ an tʼetta kʼadda dabar ere ki daayum, wo kane ɗoŋ ki diine an tʼoona lekkiyo ere ki daayum.» ");
INSERT INTO moz_vpl VALUES ("MT26_1","070_26_1","MAT","26","1","1","Isa dooyisadí pay gette yʼa ti ɗiŋge maŋ, yʼan di ruute a sanalliyagí, yʼede: ");
INSERT INTO moz_vpl VALUES ("MT26_2","070_26_2","MAT","26","2","2","«Kune kun suune tarnaapayiŋ ki Pak geŋ a guute onniyo sire maŋ yʼa aɗɗa, aame geŋ nuŋ wede an nʼehe aa ulo wede eŋ an di nʼ seeɗa, an di nʼ tʼela a bey ɗoŋ kʼolmiɗayó, an ti nʼ taaka ekkʼundumu wede zaapu tʼekki bakadí kaŋ tontilko.» ");
INSERT INTO moz_vpl VALUES ("MT26_3","070_26_3","MAT","26","3","3","A onniyo gettiyo batum deero ɗoŋ seɗeke ti kane ɗoŋ i dokkiyo Yawudiyagi an tʼugiye adda ɓoy ki mozigo goole ɗoŋ seɗeke sundí Kayip. ");
INSERT INTO moz_vpl VALUES ("MT26_4","070_26_4","MAT","26","4","4","Kane geŋ an tʼîide onamaŋ pay kaŋ soo, Isa an di yʼ seeɗa ti metiŋko ki tôwwadí. ");
INSERT INTO moz_vpl VALUES ("MT26_5","070_26_5","MAT","26","5","5","Wo kane an di ruute, anʼde: «Yoŋ in ki yʼ seeɗa adda tarnaape kino ye, para maŋ ɗoŋ duuru an in diʼn tʼooziga ono.» ");
INSERT INTO moz_vpl VALUES ("MT26_6","070_26_6","MAT","26","6","6","Isa yoŋ a ille ki Betani adda ɓoy ki Simo wede ti poone yoŋ ki bitiɗe, ");
INSERT INTO moz_vpl VALUES ("MT26_7","070_26_7","MAT","26","7","7","an di guune omɓo. Aame an ti guune geŋ, i dʼede erewo tʼa dʼiide sirpa kʼIsa, a beytú ulo diŋgile an ikkima ki mokkolo sundutú albaatir, adda egey ɗoŋ eeɗiyadaŋ uŋse zooyayaŋ oon̰e ɓaadaŋ, ti-tʼiɓi ekkʼIsa. ");
INSERT INTO moz_vpl VALUES ("MT26_8","070_26_8","MAT","26","8","8","Kane sanalliyagi an wulle iŋkino maŋ, ulbaŋ an ki tʼize uŋse ye, an di rootiyto diinayaŋ, anʼde: «Ɗe ki moo me ti tiʼn lattiya egey me? ");
INSERT INTO moz_vpl VALUES ("MT26_9","070_26_9","MAT","26","9","9","Egey geŋ in aane in tʼowila ti zooye wede oon̰e ɓaadaŋ, wo in an tʼele soŋko gette a ɗoŋ an kʼede munɗa ye.» ");
INSERT INTO moz_vpl VALUES ("MT26_10","070_26_10","MAT","26","10","10","Isa yʼa zuune munɗa wede an rootiyo me, maŋ yʼa ruute, yʼede: «Erewo kun i-tʼooɗe ulbutú ye, kono munɗa wede tʼo ize geŋ a nuŋ uŋse. ");
INSERT INTO moz_vpl VALUES ("MT26_11","070_26_11","MAT","26","11","11","Kane ɗoŋ an kʼede munɗa ye geŋ an lekka daayum ti kune, wo ɗe nuŋ ni ki lekka daayum ti kune ye. ");
INSERT INTO moz_vpl VALUES ("MT26_12","070_26_12","MAT","26","12","12","Todʼ tʼiɓi egey ɗoŋ eeɗiyadaŋ uŋse a tuddó eŋ, aakede ti nʼikkima ki poone an di nʼ tʼela adda muuzo. ");
INSERT INTO moz_vpl VALUES ("MT26_13","070_26_13","MAT","26","13","13","Ɗerec iŋkino wo nʼun di rooto: A omagi pay adda duniya an kizita Rabila Majjaanawa geŋ, erewo ette ɗuwo an tʼîda taaya a naabo ere todʼ tʼize, wo sundutú a ki danɗa ye.» ");
INSERT INTO moz_vpl VALUES ("MT26_14","070_26_14","MAT","26","14","14","I dʼede wede soo ti diine sanalliyagi kane koomat makumu sire yoŋ sundí Ziidas Iskariyot. Yoŋ yʼiide yʼa uuney kane deero ɗoŋ seɗeke, ");
INSERT INTO moz_vpl VALUES ("MT26_15","070_26_15","MAT","26","15","15","wo yʼan di ruute, yʼede: «Kun o-tʼela moo me, aame Isa nʼun yʼela a beyguŋ maŋ?» Maŋ kane geŋ an i di ruute an i di tʼela tamma ada gʼaɗo. ");
INSERT INTO moz_vpl VALUES ("MT26_16","070_26_16","MAT","26","16","16","Tʼume geŋ Ziidas yʼa iise dehutu kʼurzi wede kaŋ mummino yʼan di yʼ tʼela Isa a beezaŋ me. ");
INSERT INTO moz_vpl VALUES ("MT26_17","070_26_17","MAT","26","17","17","Onniyo ere ki poone ki tarnaape Yawudiyagi wede an dʼomɓo mappa daa kʼorme gette tʼiina maŋ, kane sanalliyagi an aa dʼiide kʼume kʼIsa an di yʼ tunde, anʼde: «A too me ki dehu ay in dʼisey omɓo tarnaapayiŋ ki Pak te?» ");
INSERT INTO moz_vpl VALUES ("MT26_18","070_26_18","MAT","26","18","18","Yoŋ yʼa ruute, yʼede: «Kunʼdo kʼadda geeger di wede kino, kun tʼodoy di yode wo kun i di rootoy, kun dʼeesoy: “Wede dooyisadey yʼede, yoŋ onniyadí goppoŋ, wo di kee ay isa tarnaapayiŋ ki Pak ti sanalliyagí me.”» ");
INSERT INTO moz_vpl VALUES ("MT26_19","070_26_19","MAT","26","19","19","Kane sanalliyagi an tʼize munɗa wede Isa yʼan ruute me, iŋkino omɓo tarnaape ki Pak an tʼize. ");
INSERT INTO moz_vpl VALUES ("MT26_20","070_26_20","MAT","26","20","20","A peeɗo tʼa tʼiire maŋ, Isa ti sanalliyagi kane koomat makumu sire geŋ an di guune omɓo. ");
INSERT INTO moz_vpl VALUES ("MT26_21","070_26_21","MAT","26","21","21","Aame an omɓo geŋ Isa yʼa ruute, yʼede: «Ɗerec iŋkino wo nʼun di rooto: Wede soo ti diinaguŋ yʼa ni tʼela bey ɗoŋ kʼolmiɗayó.» ");
INSERT INTO moz_vpl VALUES ("MT26_22","070_26_22","MAT","26","22","22","Kane sanalliyagi an tʼize sommagi dondoŋ, wo wede tuuku toŋ yi di yʼ tondiyo, yi dʼeesiyo: «Galmeeʼki nuŋ, nuuno ko, nuuno ko?» ");
INSERT INTO moz_vpl VALUES ("MT26_23","070_26_23","MAT","26","23","23","Yoŋ yʼan diʼn gime onamaŋ, yʼede: «Wede ay igibe beezey kaŋ soo adda kʼooko eŋ, yode i ni tʼela bey ɗoŋ kʼolmiɗayó me. ");
INSERT INTO moz_vpl VALUES ("MT26_24","070_26_24","MAT","26","24","24","Ɗerec, nuŋ wede an nʼehe aa ulo wede eŋ nʼa tʼinda, geŋ a-tʼetta a ono ɗoŋ an riiŋe ti kaaga adda mattup ki Raa a tukki nuuno. Wo ɗe dabar a yode wede i ni tʼela bey ɗoŋ kʼolmiɗayó, nuŋ wede an nʼehe aa ulo wede eŋ me! Yode geŋ, an ki yʼehe adda duniya ye toŋ bee!» ");
INSERT INTO moz_vpl VALUES ("MT26_25","070_26_25","MAT","26","25","25","Ziidas wede i tʼela Isa a bey ɗoŋ kʼolmiɗayí geŋ, yʼa yi tunde, yʼede: «Wede dooyisadó, nuuno ko?» Isa yi tiʼn gime onamí, yʼede: «Geŋ aa ki ruute.» ");
INSERT INTO moz_vpl VALUES ("MT26_26","070_26_26","MAT","26","26","26","Aame an omɓo geŋ, Isa yʼa tʼumɓe mappa, yʼa ruute koɗuwo a Raa kono kʼomɓo gette, maŋ yʼa ɓurke, yʼan dʼele sanalliyagi wo yʼa ruute, yʼede: «Ooho kun sooɗo, kun tʼoomo, ette tuddó.» ");
INSERT INTO moz_vpl VALUES ("MT26_27","070_26_27","MAT","26","27","27","Saŋ yʼa tʼumɓe kop ti soɓo adda, yʼa ruute koɗuwo a Raa kono soɓo gette, maŋ yʼan dʼele wo yʼa ruute, yʼede: «Ooho kun sooɗo, wede soŋ yi dʼooɓo dʼooɓo. ");
INSERT INTO moz_vpl VALUES ("MT26_28","070_26_28","MAT","26","28","28","Ette puuzadó, puuzo ki taasuwa ere Raa yʼa ketta ti ɗuwo, to tʼoɓa ki ɗoŋ ɓaadaŋ kono an tʼoona tambobino kʼolɗikadaŋ. ");
INSERT INTO moz_vpl VALUES ("MT26_29","070_26_29","MAT","26","29","29","Wo kun ollo, nʼun di rooto, nʼa tʼiiɓe ti aŋki, ki ɗaana ni ki siɓa ye baa toote kʼin̰n̰i bin̰ me, bini onniyo ere ni siɓa ti kune sey geŋ toote wede aware kʼin̰n̰i bin̰ a moziko Meegó Raa.» ");
INSERT INTO moz_vpl VALUES ("MT26_30","070_26_30","MAT","26","30","30","Aame an tʼiimi an aa tʼiiɓe maŋ, an dʼûure ôrɗari tarnaape ki Pak, saŋ an tʼuɗɗe an dʼiŋgile kʼekki mokkolo kʼInda kʼOlibiye. ");
INSERT INTO moz_vpl VALUES ("MT26_31","070_26_31","MAT","26","31","31","Maŋ Isa yʼan di ruute a sanalliyagí, yʼede: «A diɗɗo ettiyo batum, kune pay kun di nʼ kiigira a munɗa wede o aana geŋ me, kono ono eŋ an riiŋe ti kaaga adda mattup ki Raa, anʼde: “Wede kʼelso nʼa yi tʼîda, wo torɗo damɓami a-teepa.”» ");
INSERT INTO moz_vpl VALUES ("MT26_32","070_26_32","MAT","26","32","32","Isa yʼa ruute sey, yʼede: «Wo ɗe saŋ Raa yi ti nʼ bilɗa maŋ, nʼun dʼooguma kun di nʼ tʼooney a siiɗo Galile.» ");
INSERT INTO moz_vpl VALUES ("MT26_33","070_26_33","MAT","26","33","33","Maŋ Piyer yʼa tʼihina bizí, yʼa ruute, yʼede: «Aame ɗoŋ pay an ki giigira a munɗa wede a aana toŋ, nuŋ ti kee tak ni ki kiigira ye.» ");
INSERT INTO moz_vpl VALUES ("MT26_34","070_26_34","MAT","26","34","34","Isa yi di ruute, yʼede: «Ɗerec iŋkino wo nʼa di rooto: A diɗɗo ettiyo batum, ki poone uzu yʼa ôola geŋ, kʼa roota ki ki nʼ suune ye, suune ye taŋ aɗo.» ");
INSERT INTO moz_vpl VALUES ("MT26_35","070_26_35","MAT","26","35","35","Maŋ Piyer yi di ruute, yʼede: «Ato, ni ki kiigira ye, aame ise kʼunto toŋ nʼa tʼinda ti kee!» Wo kane sanalliyagi ɗoŋ soo toŋ an a-ti ruute iŋkino kay. ");
INSERT INTO moz_vpl VALUES ("MT26_36","070_26_36","MAT","26","36","36","Saŋ Isa ti sanalliyagi an dʼiiney a ume sundí Zesimaane, wo yʼan di ruute, yʼede: «Kun ti koona kino, koore nʼa-leɗɗe nʼa tondey Raa geŋ me.» ");
INSERT INTO moz_vpl VALUES ("MT26_37","070_26_37","MAT","26","37","37","Maŋ ti yode yʼa-wiike Piyer tʼin̰n̰i kuuli sire ki Zebede. Aame geŋ yʼa tʼize sommagi dondoŋ wo ulbí i-dʼooɗiyo ɓaadaŋ. ");
INSERT INTO moz_vpl VALUES ("MT26_38","070_26_38","MAT","26","38","38","Iŋkino yo yʼan di ruute, yʼede: «Nuŋ eŋ sommagi dondoŋ aa nʼa tʼinda, kun ti koona kino wo kun di lekko zeere ti nuuno.» ");
INSERT INTO moz_vpl VALUES ("MT26_39","070_26_39","MAT","26","39","39","Wo yo yʼa-liɗɗe dokki booloŋ ti kane me, maŋ yʼa tʼuttile zumayí a siiɗo, yʼa iise tondiyo Raa, yʼede: «Meeʼki nuŋ, aame i tʼise maŋ kop ki dabar eŋ kʼo ti yʼ leɗɗo ti tuddó me, wo toŋ maŋ pay geŋ a ki tʼise aa nuŋ ni dehu ye, wo a tʼise aa kee ki dehu.» ");
INSERT INTO moz_vpl VALUES ("MT26_40","070_26_40","MAT","26","40","40","Saŋ yʼa-gime ki tukki sanalliyagi ɗoŋ aɗo gen̰n̰o, wo yiʼn uuna an udige. Maŋ Isa yʼa tʼinne Piyer wo yi di ruute, yʼede: «Kuneʼŋ ki peeɗo soo toŋ kun kʼiine kun ki likke zeere ti nuŋ ye! ");
INSERT INTO moz_vpl VALUES ("MT26_41","070_26_41","MAT","26","41","41","Kun lekko zeere wo kun tondo Raa, kono kun ki tʼoora adda naamiya daggiya ye. Wede tudde geŋ a elkiyadí yi dehu yʼaase munɗa wede beehiye, wo ɗe tuddí toogatú baata.» ");
INSERT INTO moz_vpl VALUES ("MT26_42","070_26_42","MAT","26","42","42","Ki sirwe Isa yʼa-liɗɗe siidí sey, wo yʼa iise tondiyo Raa, yʼede: «Meeʼki nuŋ, aame kop ki dabar eŋ kʼo ti yʼ leɗɗe ti tuddó i ki tʼise ye nʼa dabire ɗo maŋ, i tʼiso aa kee ki dehu.» ");
INSERT INTO moz_vpl VALUES ("MT26_43","070_26_43","MAT","26","43","43","Maŋ yʼa-gime kʼume sanalliyagi sey, yiʼn uuna an urme, edayaŋ an ziiɗa moone. ");
INSERT INTO moz_vpl VALUES ("MT26_44","070_26_44","MAT","26","44","44","Kʼaɗuwe Isa yiʼn iili yʼa-liɗɗe siidí sey, wo yʼa iise tondiyo Raa iŋkino sey. ");
INSERT INTO moz_vpl VALUES ("MT26_45","070_26_45","MAT","26","45","45","Maŋ yʼa-gime ki tukki sanalliyagi wo yʼan di ruute, yʼede: «Kune kun moone pi, wo kun dʼudigo baa! Aŋkeŋ peeɗo i guute goppoŋ, wo nuŋ wede an nʼehe aa ulo wede eŋ, an nʼele a bey ɗoŋ kʼolɗiko. ");
INSERT INTO moz_vpl VALUES ("MT26_46","070_26_46","MAT","26","46","46","Kun tʼoozo, in eŋgile! Kun wollo, wede i ni tʼela a bey ɗoŋ kʼolmiɗayó yi tʼuɗɗo.» ");
INSERT INTO moz_vpl VALUES ("MT26_47","070_26_47","MAT","26","47","47","Isa onamí yʼa ki tiʼn ɗiŋge ye ɓotto, aame geŋ Ziidas wede soo ti diine sanalliyagi kane koomat makumu sire geŋ, yi tʼuɗɗo ti ɗoŋ duuru a itadí, a beyɗaŋ kasigara ti dalyagi. Kane geŋ iʼn igibo deero ɗoŋ seɗeke ti ɗoŋ i dokkiyo Yawudiyagi. ");
INSERT INTO moz_vpl VALUES ("MT26_48","070_26_48","MAT","26","48","48","Yo wede yʼan di yʼ tʼela Isa a bey ɗoŋ kʼolmiɗayí geŋ, yʼan di ruuto ɗoŋ duuru a munɗa wede yʼaasey kono an di suuney eŋ Isa me, yʼede: «Wede kun wulley ni izey puuc a toɓɓisadí maŋ, geŋ yode kun di yʼ sooɗoy.» ");
INSERT INTO moz_vpl VALUES ("MT26_49","070_26_49","MAT","26","49","49","Kesiko Ziidas yʼa yʼ zikke Isa kaɓɓaŋ wo yi di ruute, yʼede: «Toosadá wede dooyisadó!» Maŋ yi dʼize puuc a toɓɓisadí. ");
INSERT INTO moz_vpl VALUES ("MT26_50","070_26_50","MAT","26","50","50","Isa yi di ruute, yʼede: «Laŋze ki nuŋ, munɗa wede kʼiido kʼaase, ki yʼiso.» Iŋkino maŋ kane ɗoŋ duuru an dʼiiziga tuddí, an di yʼ ziiɗa. ");
INSERT INTO moz_vpl VALUES ("MT26_51","070_26_51","MAT","26","51","51","Maŋ wede soo ti diine ɗoŋ i daaniya Isa, yʼa tʼiiɗiba kasigaradí, yʼa-diikiɗa wede naabo ki mozigo goole ɗoŋ seɗeke, kuudí a ɗikke. ");
INSERT INTO moz_vpl VALUES ("MT26_52","070_26_52","MAT","26","52","52","Iŋkino maŋ Isa yi di ruute, yʼede: «Kasigaradá ki ti tʼelo saapatú, kono ɗoŋ pay i ɗeyyiso ti kasigara geŋ untadaŋ toŋ ti kasigara. ");
INSERT INTO moz_vpl VALUES ("MT26_53","070_26_53","MAT","26","53","53","Kee ki kʼelkiyo ye, paraʼŋ ni dehu ni ɗeyye maŋ, nʼa tonde Meegó Raa wo a kaamiki yʼo-tʼigibo maaleekiyagi dupiyagi ɓaadaŋ? ");
INSERT INTO moz_vpl VALUES ("MT26_54","070_26_54","MAT","26","54","54","Wo ɗe nʼaase iŋkino maŋ, geŋ ono ɗoŋ an riiŋe ti kaaga adda mattup ki Raa a tukki nuuno a ki tʼette ye. Geŋ i tʼiso aa an rootiyo.» ");
INSERT INTO moz_vpl VALUES ("MT26_55","070_26_55","MAT","26","55","55","Aame geŋ Isa yʼan di ruute a ɗoŋ duuru, yʼede: «Ɗe ki moo me kun dʼettiyo seeɗuzó wo tudduguŋ kun tʼikkimo ti kasigaryagi wo ti dalyagi, aa nuŋ wede kʼoogire me? Para maŋ nuŋ miŋ daayum ni ti konso ni dooyiso a booro Ɓoy Raa, wo kun gi di nʼ ziiɗa ye. ");
INSERT INTO moz_vpl VALUES ("MT26_56","070_26_56","MAT","26","56","56","Wo ɗe sulɗi pay geŋ a iina kono a-tʼette a ono ɗoŋ nebiyagi an riiŋe ti kaaga adda mattup ki Raa.» Maŋ kane sanalliyagi pay an di yʼiili, an tʼumbe. ");
INSERT INTO moz_vpl VALUES ("MT26_57","070_26_57","MAT","26","57","57","Kane ɗoŋ i ziiɗa Isa geŋ an di-tʼiide di Kayip mozigo goole ɗoŋ seɗeke, a ume wede ɗoŋ suuniyo kʼoogoro ti ɗoŋ i dokkiyo Yawudiyagi an tʼugiye. ");
INSERT INTO moz_vpl VALUES ("MT26_58","070_26_58","MAT","26","58","58","Wo Piyer yi di yʼ daaniya Isa ti dokki, bini yʼa iiney ɓoy ki mozigo goole ɗoŋ seɗeke, maŋ yi-tʼiide yʼa-guune a booro ti ɗoŋ naabo kono yʼa wolle mummino a ti ɗaŋga me. ");
INSERT INTO moz_vpl VALUES ("MT26_59","070_26_59","MAT","26","59","59","Kane deero booro Yawudiyagi pay ti deero ɗoŋ seɗeke, an di dehutu ɗuwo an di rootite ono butte a tukkʼIsa kono booro tʼa yi seeɗa ki tôwwadí. ");
INSERT INTO moz_vpl VALUES ("MT26_60","070_26_60","MAT","26","60","60","Ɗoŋ ɓaadaŋ an iideʼŋ an di ruutite ono butte a tukki yode, wo toŋ munɗa an ki dʼuune ye wede i di tʼîde kʼunto me. Kʼita maŋ i dʼiido ɗoŋ sire ");
INSERT INTO moz_vpl VALUES ("MT26_61","070_26_61","MAT","26","61","61","an di ruute, anʼde: «Ay yʼilliga wede eŋ yi ruute, Ɓoy Raa eŋ yʼaane yʼa kossite, wo adda kʼonniyo aɗo yʼa yʼooziga sey.» ");
INSERT INTO moz_vpl VALUES ("MT26_62","070_26_62","MAT","26","62","62","Maŋ mozigo goole ɗoŋ seɗeke yʼa tʼiiziga, yi di ruute a Isa, yʼede: «Ono ɗuwo an rootiyo a tukki kee eŋ, kee ki ki roote munɗa ye ko?» ");
INSERT INTO moz_vpl VALUES ("MT26_63","070_26_63","MAT","26","63","63","Wo yo Isa yi dʼannugu ɗeɗɗek. Maŋ mozigo goole ɗoŋ seɗeke yi di ruute, yʼede: «Nuŋ ni dehu kʼa di nâame tuddá ti suma Raa zeere, kʼay ki ti rooti ɗo, kee Ulo Raa, wo Almasi Raa yi biire ko?» ");
INSERT INTO moz_vpl VALUES ("MT26_64","070_26_64","MAT","26","64","64","Isa yi diʼn gime onamí, yʼede: «Geŋ aa ki ruute. Wo kun ollo, nʼun di rooto: Ti aŋki kun di nʼ wolla nuŋ wede an nʼehe aa ulo wede eŋ, nʼa-kooney a ammade Raa toogadí tʼa jiire pay wo kun di nʼ wolla nʼa-kimo ekki dondirso a kandaane.» ");
INSERT INTO moz_vpl VALUES ("MT26_65","070_26_65","MAT","26","65","65","Iŋkino maŋ mozigo goole ɗoŋ seɗeke yi-ti gulkuwe, kallagí yʼa zittite, wo yʼa ruute, yʼede: «Yoŋ geŋ yi gilɗe suma Raa. In ki dehe wenɗa ti doolo wede illiga yʼin ki roote sey ye baa! Kun illiga ti kuuduguŋ yi gilɗe suma Raa me. ");
INSERT INTO moz_vpl VALUES ("MT26_66","070_26_66","MAT","26","66","66","Kune elkiyaguŋ moo me?» Kane an i diʼn gime onamí, anʼde: «Munɗa wede yoŋ yʼize eŋ i-îide ki tôwwo.» ");
INSERT INTO moz_vpl VALUES ("MT26_67","070_26_67","MAT","26","67","67","Iŋkino maŋ an dʼiise paɗɗita lee a edayí wo an di gohiso kutuba. Ɗoŋ oŋgo an di yʼ ɓattisa, ");
INSERT INTO moz_vpl VALUES ("MT26_68","070_26_68","MAT","26","68","68","an dʼeesiyo: «Kee Almasi Raa yi biire, kee nebi maŋ, ki yʼunto wede i ki diin̰e me!» ");
INSERT INTO moz_vpl VALUES ("MT26_69","070_26_69","MAT","26","69","69","Aame geŋ Piyer yi-guune ti paate a booro ɓoy, maŋ i dʼede ere naabo tʼa dʼiide sirpadí ti di ruute, tʼede: «Kee toŋ ti Isa wede ti siiɗo Galile, kune soo.» ");
INSERT INTO moz_vpl VALUES ("MT26_70","070_26_70","MAT","26","70","70","Wo ɗe Piyer yʼa yi giigira a ɗaana ɗuwo pay, yʼa ruute, yʼede: «Koŋ munɗa wede mi rootiyo geŋ ti nuuno ye!» ");
INSERT INTO moz_vpl VALUES ("MT26_71","070_26_71","MAT","26","71","71","Saŋ maŋ yʼa tʼiiziga yʼa tʼaɗɗe, yʼa tʼette ki biza bumɓu, aame geŋ ere naabo ti doolo tʼa yi wulle wo tʼan di ruute a kane ɗoŋ a sirpatú, tʼede: «Yode eŋ ti Isa wede ti geeger Nazaret, kane soo.» ");
INSERT INTO moz_vpl VALUES ("MT26_72","070_26_72","MAT","26","72","72","Piyer yʼa yi giigira sey wo yʼa-ti nîime tuddí, yʼede: «Wede eŋ ni ki yʼ suune ye!» ");
INSERT INTO moz_vpl VALUES ("MT26_73","070_26_73","MAT","26","73","73","Taŋ booloŋ maŋ ɗoŋ a ume geŋ an aa dʼiide sirpa Piyer, an i di ruute, anʼde: «Ki kotto, kee toŋ wede soo ti diine kane sanalliyagi kʼIsa, ay ki zuune tʼurzi golladá.» ");
INSERT INTO moz_vpl VALUES ("MT26_74","070_26_74","MAT","26","74","74","Iŋkino maŋ Piyer yʼa-ti nîime tuddí, yʼede: «Wede eŋ ni ki yʼ suune ye! Para maŋ ono ɗoŋ ni rootiyo eŋ ɗerec ye maŋ, a golladó!» Wo a kaamiki uzu yʼa îile. ");
INSERT INTO moz_vpl VALUES ("MT26_75","070_26_75","MAT","26","75","75","Aame geŋ Piyer yʼa ilke a ono ɗoŋ Isa yi ruute, yʼede: «Ki poone uzu yʼa ôola geŋ, kʼa roota ki ki nʼ suune ye, suune ye taŋ aɗo.» Maŋ tʼadda ɓoy Piyer yi-tʼuɗɗe ti paate wo yʼa iise môolo ɓaadaŋ. ");
INSERT INTO moz_vpl VALUES ("MT27_1","070_27_1","MAT","27","1","1","A biza soohe maŋ kane deero ɗoŋ seɗeke pay ti ɗoŋ i dokkiyo Yawudiyagi, an tʼugiye an di ruute a tukkʼIsa, a urzi wede booro tʼa yi seeɗa ki tôwwadí. ");
INSERT INTO moz_vpl VALUES ("MT27_2","070_27_2","MAT","27","2","2","Maŋ an ti yʼ gittite, tiŋ geŋ an di tʼiide, an i di yʼele a bey Pilat, yoŋ Romeŋ goole siiɗo. ");
INSERT INTO moz_vpl VALUES ("MT27_3","070_27_3","MAT","27","3","3","Ziidas wede yʼan dʼele Isa a bey ɗoŋ kʼolmiɗayí geŋ, yi wolliyoʼŋ Isa booro ti yʼ ziiɗa ki tôwwo, maŋ i di tʼize attiɗi. Yʼa ziki tamma ada gʼaɗo gette, yʼan dʼiide deero ɗoŋ seɗeke ti ɗoŋ i dokkiyo Yawudiyagi, ");
INSERT INTO moz_vpl VALUES ("MT27_4","070_27_4","MAT","27","4","4","wo yʼan di ruute, yʼede: «Nuŋ ni tʼize olɗiko, nʼun di yʼele wede i kʼize olɗiko ye a beyguŋ.» Wo ɗe kane an di ruute, anʼde: «Kaye seezey ye, a wollo kee baa.» ");
INSERT INTO moz_vpl VALUES ("MT27_5","070_27_5","MAT","27","5","5","Iŋkino maŋ Ziidas soŋko yʼa zibbe adda Ɓoy Raa, wo yʼa iŋgile, yʼiideʼŋ yʼa zuuye. ");
INSERT INTO moz_vpl VALUES ("MT27_6","070_27_6","MAT","27","6","6","Soŋko gette kane deero ɗoŋ seɗeke an ti ziki wo an di ruute, anʼde: «Soŋko ette, oogiradiŋ ti kʼele urzi ye in a-tʼoɓi a korɓite Ɓoy Raa me, kono todʼte zooye ki puuzo.» ");
INSERT INTO moz_vpl VALUES ("MT27_7","070_27_7","MAT","27","7","7","Iŋkino an tʼîide onamaŋ kaŋ soo, maŋ soŋko gette an tʼiwila doome ki wede kʼaabuɗu, kono kʼottibe torgagi aŋgen̰n̰o. ");
INSERT INTO moz_vpl VALUES ("MT27_8","070_27_8","MAT","27","8","8","Geŋ kono kʼiŋkino bini aŋki toŋ, doome geŋ an di yʼ waaku sundí «doome puuzo.» ");
INSERT INTO moz_vpl VALUES ("MT27_9","070_27_9","MAT","27","9","9","Geŋ a iina kono a-tʼette a ono ɗoŋ Raa yʼa ruute ti kaaga ti bize nebi Zeremi, yʼede: «An tʼumɓe soŋko ere tamma ada gʼaɗo te, geŋ zooye wede ɗoŋ kʼIzirayel an ti wulle maŋ, an dʼiyye eego wede eŋ zooyayí i tʼîde ki soŋko ettiyo ɗaŋŋal. ");
INSERT INTO moz_vpl VALUES ("MT27_10","070_27_10","MAT","27","10","10","Wo ti soŋko gette an tʼiwila doome ki wede kʼaabuɗu, geŋ a-tʼette a munɗa wede Galmeega Raa yʼo ruute nʼaase.» ");
INSERT INTO moz_vpl VALUES ("MT27_11","070_27_11","MAT","27","11","11","Isa an di-tʼiide ki ɗaana goole siiɗo. Aame geŋ goole siiɗo yʼa yʼiise tondiso, yʼede: «Kee mozigo Yawudiyagi ko?» Isa yi diʼn gime onamí, yʼede: «Geŋ aa ki rootiyo.» ");
INSERT INTO moz_vpl VALUES ("MT27_12","070_27_12","MAT","27","12","12","Wo ɗe a ono ɗoŋ deero ɗoŋ seɗeke ti ɗoŋ i dokkiyo Yawudiyagi an rootiyto a eedí geŋ, yoŋ yi kʼohine bizí ye. ");
INSERT INTO moz_vpl VALUES ("MT27_13","070_27_13","MAT","27","13","13","Iŋkino maŋ Pilat yi di ruute, yʼede: «Ki kʼollige ye ko, ono ɗoŋ pay an rootiyto a tukki kee eŋ me?» ");
INSERT INTO moz_vpl VALUES ("MT27_14","070_27_14","MAT","27","14","14","A ono ɗoŋ an rootiyto pay geŋ, a ono soo toŋ Isa yi kʼihina bizí ye, iŋkino maŋ goole siiɗo yʼa ziiɗa giggirí ɓaadaŋ. ");
INSERT INTO moz_vpl VALUES ("MT27_15","070_27_15","MAT","27","15","15","Aa daayum goole siiɗo yi dʼisiyo a tarnaape ki Pak maŋ, yʼan dʼaɗɗiya tʼadda daŋgay wedusu soo wede ɗoŋ duuru an dehu. ");
INSERT INTO moz_vpl VALUES ("MT27_16","070_27_16","MAT","27","16","16","Wo aame geŋ adda daŋgay i dʼede wede soo sundí Barabas, sundí ti môolo. ");
INSERT INTO moz_vpl VALUES ("MT27_17","070_27_17","MAT","27","17","17","Iŋkino Pilat yʼa tunde ɗoŋ duuru i tʼugiye, yʼede: «Kun dehu miŋ nʼun tʼaɗɗo Barabas kunuŋ, ni-dʼeezo Isa wede an yi waaku Almasi Raa yi biire ko?» ");
INSERT INTO moz_vpl VALUES ("MT27_18","070_27_18","MAT","27","18","18","Pilat yi rootiyo iŋkino kono yi suune, kane deero ɗoŋ seɗeke Isa an i yʼele beezí kono an kolɓiso ti yode. ");
INSERT INTO moz_vpl VALUES ("MT27_19","070_27_19","MAT","27","19","19","Koore yoŋ konso ekki kaakido booro geŋ, eddí ti-dʼigibe ti di ruute, tʼede: «A ono ki wede ki diine eŋ, ki tʼela eedá ye, kono nuŋ te a diɗɗo ni dibire ɓaadaŋ a urzi suniye a tukki yode.» ");
INSERT INTO moz_vpl VALUES ("MT27_20","070_27_20","MAT","27","20","20","Kane deero ɗoŋ seɗeke ti ɗoŋ i dokkiyo Yawudiyagi geŋ, an an tʼelite ono a ɗoŋ duuru an dʼiyye an di roote Pilat yʼan tʼaɗɗe Barabas wo Isa ki tôwwadí. ");
INSERT INTO moz_vpl VALUES ("MT27_21","070_27_21","MAT","27","21","21","Yo goole siiɗo yʼa tunde ɗoŋ duuru, yʼede: «Ti diine kane sire eŋ, kun dehu nʼun tʼaɗɗo wee wee?» Maŋ kane an i diʼn gime onamí, anʼde: «Kʼay tʼaɗɗi Barabas!» ");
INSERT INTO moz_vpl VALUES ("MT27_22","070_27_22","MAT","27","22","22","Pilat yʼanni tunde, yʼede: «Ɗe Isa wede an yi waaku Almasi Raa yi biire geŋ, kun dehu ni-dʼise mummino me?» Maŋ kane pay an i tiʼn gime onamí, anʼde: «Ki ti yʼ taako ekkʼundumu wede zaapu tʼekki bakadí kaŋ tontilko!» ");
INSERT INTO moz_vpl VALUES ("MT27_23","070_27_23","MAT","27","23","23","Pilat yʼanni tunde sey, yʼede: «Ɗe munɗa ulsu miŋ yʼize moo me?» Wo kane an di ɗollite ɓaadaŋ ki ɓaadaŋ, anʼde: «Ki ti yʼ taako ekkʼundumu wede zaapu tʼekki bakadí kaŋ tontilko!» ");
INSERT INTO moz_vpl VALUES ("MT27_24","070_27_24","MAT","27","24","24","Aame Pilat yi wulle onamí an kʼollige ye wo i tʼooziga ɗeyyiso maŋ, yi dʼeezi ahu yʼa tʼupile beezí a ɗaana ɗoŋ duuru, wo yʼa ruute, yʼede: «Wede i kʼize munɗa ye eŋ nʼun di yʼelo, wo puuzadí ti kʼoopa eedó ye.» ");
INSERT INTO moz_vpl VALUES ("MT27_25","070_27_25","MAT","27","25","25","Kane ɗoŋ duuru pay an i tiʼn gime onamí, anʼde: «Eyye, kaye tʼin̰n̰izey pay puuzadí tʼoopo edey.» ");
INSERT INTO moz_vpl VALUES ("MT27_26","070_27_26","MAT","27","26","26","Iŋkino maŋ Pilat yʼan di yʼuɗɗe Barabas me, wo yʼan di ruute a asigiryagi Isa an ti yʼ girpipe ti marpa, saŋ yʼan di yʼele an ti yʼ taake ekkʼundumu wede zaapu tʼekki bakadí kaŋ tontilko. ");
INSERT INTO moz_vpl VALUES ("MT27_27","070_27_27","MAT","27","27","27","Iŋkino maŋ kane asigiryagi ki goole siiɗo, an di-tʼiide Isa kʼadda ɓoy ki goole siiɗo, wo eebaŋ asigiryagi ti doolo toŋ ɓaadaŋ an a-tiʼn wiiko pay, an di ti ɗuule. ");
INSERT INTO moz_vpl VALUES ("MT27_28","070_27_28","MAT","27","28","28","Kallagí an tʼiɗɗipe wo an dʼumɓe kalle wede goole teeze, an i di tʼusse. ");
INSERT INTO moz_vpl VALUES ("MT27_29","070_27_29","MAT","27","29","29","An di gini kaɗumul kʼahimagi an i-tʼusse eedí, wo a beezí kʼammade an i dʼele koƴile. Maŋ an di dikkite a ɗaanadí, an di yʼokko maade, an dʼeesiyo: «Toosadá mozigo Yawudiyagi no! Toosadá mozigo Yawudiyagi no!» ");
INSERT INTO moz_vpl VALUES ("MT27_30","070_27_30","MAT","27","30","30","An di paɗɗita lee a tuddí, wo koƴile wede a beezí an di ziiɗa an di yʼoggiso eedí. ");
INSERT INTO moz_vpl VALUES ("MT27_31","070_27_31","MAT","27","31","31","Aame an ti yʼukke maade maŋ, kalle wede goole an tʼiiɗiba wo an i di tʼusse kallagí. Maŋ Isa kane an ti yʼ dukke, an di tʼette kono an ti yʼ taakey ekkʼundumu wede zaapu tʼekki bakadí kaŋ tontilko. ");
INSERT INTO moz_vpl VALUES ("MT27_32","070_27_32","MAT","27","32","32","A aɗɗiyadaŋ ti geeger, an a-tʼikkima ti wede soo iŋkino yoŋ ti geeger Sireŋ, sundí Simo. Asigiryagi an di yʼize ki toogo yʼa tʼumɓe undumu taakiya kʼIsa. ");
INSERT INTO moz_vpl VALUES ("MT27_33","070_27_33","MAT","27","33","33","Maŋ an dʼiiney a ume wede sundí Golgota, i-kaza ume aa osse kʼeego. ");
INSERT INTO moz_vpl VALUES ("MT27_34","070_27_34","MAT","27","34","34","A ume geŋ, a Isa an i dʼeele toote kʼin̰n̰i bin̰ kalsiya ti munɗa kaɗigi yʼa siɓe. Yi yʼuwwe maŋ, yʼa-tuuge ki soɓo me. ");
INSERT INTO moz_vpl VALUES ("MT27_35","070_27_35","MAT","27","35","35","Kane asigiryagi an ti yʼ tiike ekkʼundumu wede zaapu tʼekki bakadí kaŋ tontilko, saŋ kallagí an di dikkiɗa tʼurzi kʼarɓu teltel muntelliyo kono a-tʼette a ono ɗoŋ nebi yi ruute ti kaaga, yʼede: «Kallagó an di dikkiɗa, wo kallayó wede goole an tʼirɓe teltel muntelliyo. ");
INSERT INTO moz_vpl VALUES ("MT27_36","070_27_36","MAT","27","36","36","Maŋ an di guune aŋgen̰n̰o, an di yʼ boohiyo.» ");
INSERT INTO moz_vpl VALUES ("MT27_37","070_27_37","MAT","27","37","37","Tʼekkʼeedí an tiike pakirte wo an a-ti riiŋe, anʼde: «Yode eŋ Isa, mozigo Yawudiyagi.» Geŋ munɗa wede i-dʼîide untadí. ");
INSERT INTO moz_vpl VALUES ("MT27_38","070_27_38","MAT","27","38","38","Wo a sirpadí an a-tiike ɗoŋ kʼoogire sire, wede soŋ tʼundumzí a kese kʼammidadí, wo wede soŋ tʼundumzí a kese geeladí. ");
INSERT INTO moz_vpl VALUES ("MT27_39","070_27_39","MAT","27","39","39","Ɗoŋ aɗɗiya tiŋ gen̰n̰o, an di yʼ kalɗita wo an ɗeŋilso eedaŋ, ");
INSERT INTO moz_vpl VALUES ("MT27_40","070_27_40","MAT","27","40","40","wo an dʼeesiyo: «Kee wede kʼede Ɓoy Raa kʼa kossita wo adda kʼonniyo aɗo kʼa yʼooziga geŋ, kee Ulo Raa kotto maŋ, kʼutto tuddá batum wo tʼekkʼundumu wede zaapu tʼekki bakadí kaŋ tontilko, ki ti ɗeegi!» ");
INSERT INTO moz_vpl VALUES ("MT27_41","070_27_41","MAT","27","41","41","Kane deero ɗoŋ seɗeke, ɗoŋ suuniyo kʼoogoro ti ɗoŋ i dokkiyo Yawudiyagi toŋ, an di yʼokko maade kay, an dʼeesiyo: ");
INSERT INTO moz_vpl VALUES ("MT27_42","070_27_42","MAT","27","42","42","«Yoŋ ɗoŋ doolo yʼan diʼn utte miŋ, yi kʼaane tuddí batum yi ki tʼutte ye! Yoŋ mozigo ki ɗoŋ kʼIzirayel kotto maŋ, aŋken̰n̰o tʼekkʼundumu geŋ yi ti ɗeegi, iŋkino ay zaapa addey a yode. ");
INSERT INTO moz_vpl VALUES ("MT27_43","070_27_43","MAT","27","43","43","Yoŋ yi ziipe addí a Raa wo Raa yi yʼ giyye kotto maŋ, aŋkeŋ yi yʼutto baa, kono yi ruute, yoŋ Ulo Raa!» ");
INSERT INTO moz_vpl VALUES ("MT27_44","070_27_44","MAT","27","44","44","Kane ɗoŋ kʼoogire ɗoŋ an tiike a sirpadí toŋ, an di yʼ kalɗita iŋkino kay. ");
INSERT INTO moz_vpl VALUES ("MT27_45","070_27_45","MAT","27","45","45","Tʼume peeɗo tʼize diine geŋ, adda siiɗo pay ume a tʼize zimolo dil a likke bini eesiyo peeɗo lohe. ");
INSERT INTO moz_vpl VALUES ("MT27_46","070_27_46","MAT","27","46","46","A eesiyo peeɗo lohe maŋ, Isa yʼa iɗili ti golla awwa, yʼede: «Eli, Eli, lama sabaktani.» Geŋ i-kaza: «Raa ki nuŋ, Raa ki nuŋ, moo me ki ni giigira me?» ");
INSERT INTO moz_vpl VALUES ("MT27_47","070_27_47","MAT","27","47","47","Ɗoŋ oŋgo ti diine ɗoŋ i lekkiyo aŋgen̰n̰o geŋ, an dʼilliga wo an di ruute, anʼde: «Kun ollo kay, yi waaku nebi Eli.» ");
INSERT INTO moz_vpl VALUES ("MT27_48","070_27_48","MAT","27","48","48","Kesiko wede soo ti diinayaŋ yʼa ukke yi dʼumɓe sooso, yi di zulpe adda toote suddo kʼin̰n̰i kʼinda bin̰, maŋ yi-tʼele a biza koƴile, yi-tʼusse bize kʼIsa yʼa suuƴe. ");
INSERT INTO moz_vpl VALUES ("MT27_49","070_27_49","MAT","27","49","49","Wo kane ɗoŋ oŋgo an di ruute, anʼde: «Kʼa dello, in gi di wolla ɗo Elizi wenɗa yʼetto yi yʼutta maŋ.» ");
INSERT INTO moz_vpl VALUES ("MT27_50","070_27_50","MAT","27","50","50","Isa yʼa iɗili sey ti golla awwa, maŋ yʼa iili undí tʼa tʼuɗɗe, yʼa-tʼihe. ");
INSERT INTO moz_vpl VALUES ("MT27_51","070_27_51","MAT","27","51","51","Aame geŋ alboy wede i ɗikke adde Ɓoy Raa soŋ kʼadda soŋ ki paate geŋ, a tʼîhina tar tʼawwa a ti ɗiige les. Siiɗo tʼa ŋuŋŋire, zombali a tʼîhinte, ");
INSERT INTO moz_vpl VALUES ("MT27_52","070_27_52","MAT","27","52","52","muuziyagi a tʼihinte, wo ɗoŋ ki Raa ɓaadaŋ ɗoŋ i tʼinda geŋ an di bilɗe. ");
INSERT INTO moz_vpl VALUES ("MT27_53","070_27_53","MAT","27","53","53","Kane ɗoŋ i tʼinda toŋ ti muuziyagaŋ an tʼuɗɗite wo aame Isa yi bilɗe maŋ, an tʼiide ki Zeruzalem geeger ere kamilen̰ wo ɗoŋ ɓaadaŋ an diʼn wulle. ");
INSERT INTO moz_vpl VALUES ("MT27_54","070_27_54","MAT","27","54","54","Goole kʼasigiryagi meeda ki Romeŋ ti ɗoŋ a itadí i boohiyo Isa, an wulle ŋoŋŋirso siiɗo ti sulɗi ɗoŋ ize gen̰n̰o maŋ, orgiso tʼanni ziiɗa ɓaadaŋ wo an di ruute, anʼde: «Wede eŋ Ulo Raa ki kotto!» ");
INSERT INTO moz_vpl VALUES ("MT27_55","070_27_55","MAT","27","55","55","A ume geŋ i dʼede erayi ɓaadaŋ ɗoŋ i diino Isa ti siiɗo Galile nee kono an i di naabiya, kane an tʼîhirte ti dokki an di wolliyo munɗa wede isiyo. ");
INSERT INTO moz_vpl VALUES ("MT27_56","070_27_56","MAT","27","56","56","Ti diinayaŋ i dʼede Mariyam ere ti siiɗo Magdalla, Mariyam mekki Zak ti Yusup, wo soo te mekkʼin̰n̰i kuuli ki Zebede. ");
INSERT INTO moz_vpl VALUES ("MT27_57","070_27_57","MAT","27","57","57","A peeɗo tʼette kʼooriyo maŋ, wede sundí Yusup ti geeger kʼArimate geŋ yʼa iina, yoŋ geŋ wede bey wo sanallusu kʼIsa Almasi pây. ");
INSERT INTO moz_vpl VALUES ("MT27_58","070_27_58","MAT","27","58","58","Yode geŋ yʼiideʼŋ, yʼa uuney goole siiɗo Pilat, yʼa tunde nuune kʼIsa kono yʼa tʼottiba. Iŋkino maŋ Pilat yʼa iyye, yʼan di ruute a asigiryagi nuune an i-dʼele. ");
INSERT INTO moz_vpl VALUES ("MT27_59","070_27_59","MAT","27","59","59","Yusup yʼiideʼŋ, nuuneʼŋ yʼa tʼumɓe, yʼa n̰ilpe ti sotor aware tuwarwa kar. ");
INSERT INTO moz_vpl VALUES ("MT27_60","070_27_60","MAT","27","60","60","Yi-tʼele adda muuzo aware ere ki yode batum, todʼte aa urmi an ittiba mokkolo. Maŋ yʼa-ti ɗuŋkile a biza muuzo zumbulu yeepiyo wo yʼa iŋgile. ");
INSERT INTO moz_vpl VALUES ("MT27_61","070_27_61","MAT","27","61","61","Aame geŋ Mariyam ere ti siiɗo Magdalla wo ti bakatú Mariyam kay, an di-guune aŋgen̰n̰o, edayaŋ ki biza muuzo. ");
INSERT INTO moz_vpl VALUES ("MT27_62","070_27_62","MAT","27","62","62","Sulɗi geŋ ize a onniyo jima ɗuwo an okkime tuddaŋ kono onniyo ere ki puukiyo Yawudiyagi ti tʼeesa. A onniyo ere ki puukiyo maŋ, kane deero ɗoŋ seɗeke ti Pariziyeŋ geŋ an dʼiŋgile kaŋ soo di Pilat. An iideʼŋ ");
INSERT INTO moz_vpl VALUES ("MT27_63","070_27_63","MAT","27","63","63","an di ruute, anʼde: «Galmeegey, kaye ay ilke yo wede daggiya ɗuwo eŋ, yi ruute aame yo zeere, yʼede saŋ yi dʼisa onniyo sire kʼaɗuwe yʼa balɗa. ");
INSERT INTO moz_vpl VALUES ("MT27_64","070_27_64","MAT","27","64","64","Iŋkino maŋ kʼan rooto a asigiryagi an di boohey muuzo bini onniyo kʼaɗuwe, koo sanalliyagí nuune an tʼooɗiba wo a ɗuwo an tʼeesa: “Isa yi bilɗe ti diine ɗoŋ unto me.” Maŋ daggiya ɗuwo ere kʼita ette tʼa ceera ere ki poone.» ");
INSERT INTO moz_vpl VALUES ("MT27_65","070_27_65","MAT","27","65","65","Pilat yʼan di ruute, yʼede: «Asigiryagi en̰n̰o, kunʼdo muuzo kun boohoy aa kun ollige.» ");
INSERT INTO moz_vpl VALUES ("MT27_66","070_27_66","MAT","27","66","66","Iŋkino maŋ an dʼiŋgile wo biza muuzo an a-ti lin̰ƴe wo an di zippe asigiryagi an di boohiyo. ");
INSERT INTO moz_vpl VALUES ("MT28_1","070_28_1","MAT","28","1","1","Onniyo ere ki puukiyo Yawudiyagi i tʼiŋgile. A onniyo dumas ti soohe maŋ, Mariyam ere ti siiɗo Magdalla ti bakatú Mariyam an tʼiide an di wollo muuzo. ");
INSERT INTO moz_vpl VALUES ("MT28_2","070_28_2","MAT","28","2","2","A kaamiki, siiɗo tʼa ŋuŋŋire ɓaadaŋ, maaleeka ki Galmeega Raa yʼa ɗiigo ti kandaane, yʼiideʼŋ zumbulu ti biza muuzo yʼa ti yʼ ɗuŋkile kese wo yʼa-ti guune tʼeego. ");
INSERT INTO moz_vpl VALUES ("MT28_3","070_28_3","MAT","28","3","3","Yoŋ tuddí i ralita aa omile mizzi, wo kallayí tuware kar aa kuube. ");
INSERT INTO moz_vpl VALUES ("MT28_4","070_28_4","MAT","28","4","4","Maŋ kane asigiryagi i boohiyo muuzo, orgiso tʼanni ziiɗa ɓaadaŋ, an dʼiise ŋoŋŋirso wo a tʼiɓi a siiɗo aa an tʼinda. ");
INSERT INTO moz_vpl VALUES ("MT28_5","070_28_5","MAT","28","5","5","Maaleeka yʼa tʼihina bizí wo yʼan di ruute erayi, yʼede: «Kuneʼŋ, kun orgiɗe ye. Ni suune kun dehu Isa wede an yi tiike ekkʼundumu wede zaapu tʼekki bakadí kaŋ tontilko me. ");
INSERT INTO moz_vpl VALUES ("MT28_6","070_28_6","MAT","28","6","6","Yoŋ a en̰n̰o ye, Raa yi ti yʼ bilɗe ti diine ɗoŋ unto me, aakede yʼa ruute. Kunʼdi, kun wolla ume an ziipe nuunayí toŋ en̰n̰o. ");
INSERT INTO moz_vpl VALUES ("MT28_7","070_28_7","MAT","28","7","7","Aŋkeŋ kunʼdo kesiko, kun an ti kazoy sanalliyagí, kun dʼeesoy: “Yoŋ ti diine ɗoŋ unto Raa yi ti yʼ bilɗe, wo aŋkeŋ yʼunni delliyo a siiɗo Galile, a ume geŋ kun di yʼ wolley.” Geŋ iŋkino ono ɗoŋ o dʼede nʼun di ruute.» ");
INSERT INTO moz_vpl VALUES ("MT28_8","070_28_8","MAT","28","8","8","Maŋ erayi ti biza muuzo kesiko an di-gime, addaŋ i-tʼûune tʼorgiso wo tʼuŋsuwo ɓaadaŋ, an dʼukke kono an an dʼette ti rabila a sanalliyagi kʼIsa. ");
INSERT INTO moz_vpl VALUES ("MT28_9","070_28_9","MAT","28","9","9","A kaamiki Isa yʼiideʼŋ, yʼan ikkima wo yʼan di ruute, yʼede: «Toosaguŋ.» Kane erayi an a dʼiide sirpadí, an di dikke, an a-ti ziiɗe zoŋɗí wo an i dʼuttile. ");
INSERT INTO moz_vpl VALUES ("MT28_10","070_28_10","MAT","28","10","10","Iŋkino maŋ Isa yʼan di ruute, yʼede: «Kun orgiɗe ye, kunʼdo kun an ti rootoy a zemɓadó geŋ an tʼodoy ki siiɗo Galile, an di nʼ wolley a ummey.» ");
INSERT INTO moz_vpl VALUES ("MT28_11","070_28_11","MAT","28","11","11","Koore kane erayi a urzi ɓotto geŋ, asigiryagi miibi ti diine ɗoŋ a buuhe muuzo geŋ an tʼiide kʼadda geeger, an an tʼîide taaya a deero ɗoŋ seɗeke a sulɗi ɗoŋ pay ize geŋ me. ");
INSERT INTO moz_vpl VALUES ("MT28_12","070_28_12","MAT","28","12","12","Maŋ kane deero ɗoŋ seɗeke ti ɗoŋ i dokkiyo Yawudiyagi an tʼugiye an tʼîide onamaŋ kaŋ soo, saŋ an an dʼele soŋko ɓaadaŋ a asigiryagi, ");
INSERT INTO moz_vpl VALUES ("MT28_13","070_28_13","MAT","28","13","13","wo an an di ruute, anʼde: «Kun rooto a ɗuwoʼŋ: “Sanalliyagi wede eŋ an iido a diɗɗo, nuune an tʼuugira aame kaye ay moone geŋ me.” ");
INSERT INTO moz_vpl VALUES ("MT28_14","070_28_14","MAT","28","14","14","Aame ono geŋ goole siiɗo yʼilliga toŋ maŋ, kaye ay dʼisa tʼurzi tuuku toŋ addí a yi-tiʼn tʼassa kono munɗa un ki dʼaana ye.» ");
INSERT INTO moz_vpl VALUES ("MT28_15","070_28_15","MAT","28","15","15","Kane asigiryagi geŋ soŋko an di ziiɗa, wo an di diine ono ɗoŋ an an ruute. Iŋkino maŋ, rabila gette a-tiipe a diine Yawudiyagi bini aŋki. ");
INSERT INTO moz_vpl VALUES ("MT28_16","070_28_16","MAT","28","16","16","Maŋ kane sanalliyagi kʼIsa ɗoŋ koomat makumu soo geŋ, an dʼiŋgile siiɗo Galile kʼekki mokkolo ere Isa yʼan ruute an dʼette. ");
INSERT INTO moz_vpl VALUES ("MT28_17","070_28_17","MAT","28","17","17","A ume geŋ Isa an di yʼ wulle, maŋ an tʼuttile wo ɗoŋ oŋgo ti diinayaŋ an dʼede niiku adda kʼaddaŋ. ");
INSERT INTO moz_vpl VALUES ("MT28_18","070_28_18","MAT","28","18","18","Isa yʼa dʼiide sirpadaŋ wo yʼan di ruute, yʼede: «Toogo pay Raa yʼo ele a kandaane wo a siiɗo toŋ maŋ. ");
INSERT INTO moz_vpl VALUES ("MT28_19","070_28_19","MAT","28","19","19","Iŋkino maŋ kunʼdo ki tukkʼita ɗuwo pay kun diʼn isoy sanalliyagó, kun tiʼn suyyoy batem ti suma Meega, ti suma kʼUlo wo ti suma kʼUnde Kamilen̰. ");
INSERT INTO moz_vpl VALUES ("MT28_20","070_28_20","MAT","28","20","20","Wo kun diʼn dooyoy an seeɗa sulɗi ɗoŋ pay nʼun ruute kun dʼise, wo nuŋ nʼa lekka daayum ti kune, bini onniyo ere duniya ti ɗaŋga.»");
INSERT INTO moz_vpl VALUES ("MK1_1","071_1_1","MRK","1","1","1","Kun ollo ette eesiyo Rabila Majjaanawa kʼIsa Almasi Ulo Raa. ");
INSERT INTO moz_vpl VALUES ("MK1_2","071_1_2","MRK","1","2","2","Ono eŋ an riiŋe ti kaaga adda mattup ki nebi Ezayi, anʼde: «Kun ollo, nʼa tʼigiba wede zindó yʼa ooguma ki poone ti kee, yʼa di tʼokkimey urzizá. ");
INSERT INTO moz_vpl VALUES ("MK1_3","071_1_3","MRK","1","3","3","Iŋkino maŋ ɗoŋ an dʼollige golla ki wedusu yi ɗollite adda balɗa, yi dʼeesiyo: Kun i tʼokkoŋ urzi Galmeega, erkiyagí kun i tiʼn okkoŋ ki diine ɗelele.» ");
INSERT INTO moz_vpl VALUES ("MK1_4","071_1_4","MRK","1","4","4","Geŋ aa Ezayi yʼa ruute, Zaŋ Batis yʼa iina yi lekkiyo adda balɗa. Ɗoŋ an dʼettiyo tuddí, yʼan di kazita, yi dʼeesiyo: «Kun ti kama lekkiyaguŋ, an un tiʼn suyyo batem wo Raa yʼun tʼisa tambobino a olɗikaguŋ te.» ");
INSERT INTO moz_vpl VALUES ("MK1_5","071_1_5","MRK","1","5","5","Ɗoŋ ɓaadaŋ ti siiɗo Ziide wo ti geeger Zeruzalem an dʼettiyo tukki Zaŋ. An tʼooɗibe addaŋ a urzi kʼolɗikadaŋ a ɗaana ɗuwo pay, wo yoŋ yi-tiʼn suyyiso batem adda kʼooye Zurden. ");
INSERT INTO moz_vpl VALUES ("MK1_6","071_1_6","MRK","1","6","6","Zaŋ geŋ kallayí yʼossiyo an indigo kʼilali ziŋzo, wo ser a tooni ki golmodo. Omɓadí gannoori ti madde. ");
INSERT INTO moz_vpl VALUES ("MK1_7","071_1_7","MRK","1","7","7","Yʼan di kazita ɗuwo, yi dʼeesiyo: «I dʼede wede ettiyo kʼitadó yoŋ toogo yi jiire nuŋ, wo ni kʼîide nʼa ki tʼottile nʼa ki tʼeeze sibe toɓiyagí ye. ");
INSERT INTO moz_vpl VALUES ("MK1_8","071_1_8","MRK","1","8","8","Nuŋ nʼunni suyyiso batem tʼahu, wo yoŋ yʼunni suyya batem tʼUnde Kamilen̰.» ");
INSERT INTO moz_vpl VALUES ("MK1_9","071_1_9","MRK","1","9","9","Aame geŋ Isa yʼa iide ti geeger Nazaret siiɗo Galile, wo Zaŋ yʼa ti yʼ zuyye batem adda kʼooye Zurden. ");
INSERT INTO moz_vpl VALUES ("MK1_10","071_1_10","MRK","1","10","10","Aame Isa yʼaɗɗiya tʼadda kʼahu, yi wulle kandaane a tʼîhina, wo Unde Raa ti ɗeegu ti kandaane aa deere tʼa di guune a tuddí. ");
INSERT INTO moz_vpl VALUES ("MK1_11","071_1_11","MRK","1","11","11","Wo yʼa illiga golla ettiyo ti kandaane tʼa ruute, tʼede: «Kee Ulo nuuno, ni ki giyye ɓaadaŋ, ulbó uŋse ti kee me.» ");
INSERT INTO moz_vpl VALUES ("MK1_12","071_1_12","MRK","1","12","12","Yi tʼuɗɗe tʼahu maŋ, a kaamiki Unde Raa tʼa-di tʼiide kʼadda balɗa. ");
INSERT INTO moz_vpl VALUES ("MK1_13","071_1_13","MRK","1","13","13","A ume geŋ yʼa likke onniyo ada piɗe ti seyɗi. Aame yi lekkiyo geŋ, Meeda siitanɗani tʼa yi niime daggiya, wo kane maaleekiyagi Raa ti yode, an i di naabiya. ");
INSERT INTO moz_vpl VALUES ("MK1_14","071_1_14","MRK","1","14","14","Onniyo soo Zaŋ an ti yʼ ziiɗa daŋgay, maŋ Isa yʼa iŋgile siiɗo Galile yi kazita Rabila Majjaanawa ki Raa, ");
INSERT INTO moz_vpl VALUES ("MK1_15","071_1_15","MRK","1","15","15","yʼede: «Onniyo tʼîide, wo Moziko Raa tʼiina goppoŋ. Kun ti kama lekkiyaguŋ, kun amɓo a Rabila Majjaanawa ettiyo.» ");
INSERT INTO moz_vpl VALUES ("MK1_16","071_1_16","MRK","1","16","16","Onniyo soo Isa yi sooru a biza bar ki Galile, maŋ yi dʼuuney zemɓa sire, Simo ti leemadí Andire. An kakkiya lembiɗagaŋ kʼadda bar kono kane naabadaŋ sawwiya puuni. ");
INSERT INTO moz_vpl VALUES ("MK1_17","071_1_17","MRK","1","17","17","Maŋ Isa yʼan di ruute, yʼede: «Kun ni daani, wo nuŋ nʼun diʼn isa ɗoŋ dehutu ɗuwo kono an dʼetto kʼurzizó.» ");
INSERT INTO moz_vpl VALUES ("MK1_18","071_1_18","MRK","1","18","18","A kaamiki lembiɗagaŋ an dʼiili, an di yʼ diine. ");
INSERT INTO moz_vpl VALUES ("MK1_19","071_1_19","MRK","1","19","19","Tiŋ geŋ Isa yʼa iide ki ɗaana booloŋ maŋ, yi dʼuuney Zak ti leemadí Zaŋ in̰n̰i Zebede, kane adda tooko an okkime lembiɗagaŋ. ");
INSERT INTO moz_vpl VALUES ("MK1_20","071_1_20","MRK","1","20","20","Aame geŋ yʼa tiʼn wiike, maŋ kesiko meegaŋ Zebede an di yʼiili adda tooko ti ɗoŋ naabo me, wo kane an di yʼ diine. ");
INSERT INTO moz_vpl VALUES ("MK1_21","071_1_21","MRK","1","21","21","Saŋ maŋ an dʼiŋgile ki geeger Kapernayim. A onniyo ere ki puukiyo Yawudiyagi maŋ, Isa yʼa tʼiide kʼadda ɓoy wede Yawudiyagi ge dooyiso, yʼa iise dooyiso ɗuwo. ");
INSERT INTO moz_vpl VALUES ("MK1_22","071_1_22","MRK","1","22","22","Dooyisadí gette tʼan diʼn ziiɗa, kono yoŋ yi dooyiso ti toogo suuniyo ere ki yode batum, wo aakede ki ɗoŋ suuniyo kʼoogoro ge ki dooyiso ye. ");
INSERT INTO moz_vpl VALUES ("MK1_23","071_1_23","MRK","1","23","23","Adda ɓoy geŋ i dʼede wedusu i-dʼede siitan a eedí, yʼa iɗili, yʼede: ");
INSERT INTO moz_vpl VALUES ("MK1_24","071_1_24","MRK","1","24","24","«Isa wede ti geeger Nazaret, ki dehu moo me a tukki kaye me? Kee kʼiido daggiyadey ko? Nuŋ ni ki suune, kee Wede Kamilen̰ Raa yʼigibo.» ");
INSERT INTO moz_vpl VALUES ("MK1_25","071_1_25","MRK","1","25","25","Iŋkino maŋ Isa yʼa tʼiɗɗise siitan gette, yʼede: «Mʼa tʼappa bizí, wo mi tʼaɗɗo ti tukki wede me!» ");
INSERT INTO moz_vpl VALUES ("MK1_26","071_1_26","MRK","1","26","26","Siitan gette tʼa-ti yi zihite wede me, wo tʼa-tʼuɗɗe ti ɗollite. ");
INSERT INTO moz_vpl VALUES ("MK1_27","071_1_27","MRK","1","27","27","Ɗoŋ pay an ziiɗa giggiraŋ, an dʼiise rootiyto ti tuddaŋ, anʼde: «Eŋ moo me? Dooyiso ette aware aa ki wede adda toogo kino me! Siitanɗani toŋ yʼan di rootiyo an tʼaɗɗe, wo an dʼollige onamí!» ");
INSERT INTO moz_vpl VALUES ("MK1_28","071_1_28","MRK","1","28","28","A kaamiki geŋ rabila kʼIsa a-tiipe adda siiɗo Galile pay. ");
INSERT INTO moz_vpl VALUES ("MK1_29","071_1_29","MRK","1","29","29","Saŋ maŋ aŋ Isa an tʼuɗɗe tʼadda ɓoy wede Yawudiyagi ge dooyiso me, an tʼiide daŋ Simo kane ti Andire, wo Zak ti Zaŋ toŋ ti kane. ");
INSERT INTO moz_vpl VALUES ("MK1_30","071_1_30","MRK","1","30","30","An iiney maŋ an tʼuuney ande Simo ekkʼoŋgali i-ti dʼiire, aame geŋ an i di ruute Isa kono tode. ");
INSERT INTO moz_vpl VALUES ("MK1_31","071_1_31","MRK","1","31","31","Yʼa dʼiide goppoŋ ki tuddutú, yi ziiɗa beytú yʼa-tʼiiziga. A kaamiki ooriyo tʼa tʼiili, wo tʼan dʼiise naabiya. ");
INSERT INTO moz_vpl VALUES ("MK1_32","071_1_32","MRK","1","32","32","A peeɗo tʼa tʼiire maŋ, tiŋ geŋ ɗuwo an i di ziko ɗoŋ kʼeeni ti ɗoŋ an dʼede siitanɗani a eedaŋ. ");
INSERT INTO moz_vpl VALUES ("MK1_33","071_1_33","MRK","1","33","33","Ɗoŋ geeger pay geŋ an tʼugiye a biza bumɓu ɓoy wede Isa adda. ");
INSERT INTO moz_vpl VALUES ("MK1_34","071_1_34","MRK","1","34","34","Yʼan dʼele beeko a ɗoŋ kʼeeni ɓaadaŋ i dabirsa wede tuuku toŋ tʼita kʼeenizí kʼeenizí, wo siitanɗani ɓaadaŋ yʼan ilmiti. Yoŋ yʼan kʼooliyo urzi a siitanɗani an ki dʼorba ye, kono kane an yi suune yoŋ Isa wee wee me. ");
INSERT INTO moz_vpl VALUES ("MK1_35","071_1_35","MRK","1","35","35","Soggo maŋ, yʼa ziiha ti diɗɗo kʼadda balɗa kono yʼa tondey Raa. ");
INSERT INTO moz_vpl VALUES ("MK1_36","071_1_36","MRK","1","36","36","Ume i wiyye maŋ, Simo ti ɗoŋ a itadí an tʼiide dehuzí. ");
INSERT INTO moz_vpl VALUES ("MK1_37","071_1_37","MRK","1","37","37","Aame an yʼuune maŋ, an i di ruute, anʼde: «Ɗoŋ pay an ki dehu.» ");
INSERT INTO moz_vpl VALUES ("MK1_38","071_1_38","MRK","1","38","38","Maŋ Isa yʼan di ruute, yʼede: «In tʼodo kʼilliyagi goppoŋ gen̰n̰o, rabila gette a kane toŋ nʼan di ti kizey kay, kono nuŋ nʼiido miŋ kʼiŋkino.» ");
INSERT INTO moz_vpl VALUES ("MK1_39","071_1_39","MRK","1","39","39","Maŋ Isa yʼa-tʼizire siiɗo Galile gette pay, yi kazita ono Raa a ɓoyɗi ɗoŋ Yawudiyagi ge dooyiso, wo siitanɗani yi-tiʼn lommite. ");
INSERT INTO moz_vpl VALUES ("MK1_40","071_1_40","MRK","1","40","40","I dʼede wede bitiɗe yʼa iide kʼume kʼIsa, yʼa-dikke a ɗaanadí wo yi-dʼoɓe bey, yʼede: «Ki dehu maŋ, kʼo eli beeko nʼa tʼise kamilen̰ a ɗaana Raa.» ");
INSERT INTO moz_vpl VALUES ("MK1_41","071_1_41","MRK","1","41","41","Isa yi yʼ wulle maŋ, i di tʼize sommagi, yʼa igibe beezí yʼa yi butte, wo yʼa ruute, yʼede: «Nuŋ ni dehu, ki tʼiso kamilen̰!» ");
INSERT INTO moz_vpl VALUES ("MK1_42","071_1_42","MRK","1","42","42","A kaamiki bitiɗayí an n̰ukkiɗe, yʼa tʼize kamilen̰. ");
INSERT INTO moz_vpl VALUES ("MK1_43","071_1_43","MRK","1","43","43","Aame geŋ kesiko Isa yʼa yʼigibe, wo yʼa di yʼiipiɗe, ");
INSERT INTO moz_vpl VALUES ("MK1_44","071_1_44","MRK","1","44","44","yʼede: «Kʼollo koɗuwo, a munɗa wede ize eŋ a wenɗa soo toŋ ki rootey ye! Wo ɗe kʼodo deddet ki-ti kazoy tuddá a wede seɗeke yʼa ki ti wolley, wo kʼa eloy munɗa ki seɗeke a kize ki tʼize kamilen̰ aa Muusa yʼa ruute adda kʼoogoro in dʼise, kono ɗoŋ pay an di wolle kee kʼuune bee.» ");
INSERT INTO moz_vpl VALUES ("MK1_45","071_1_45","MRK","1","45","45","Miŋ wede geŋ yi tʼuɗɗe maŋ, yʼa iise kazita a ɗoŋ pay a beeko ere yʼuune gette. Iŋkino maŋ rabila gette a-tiipe a omagi pay, urzi Isa yʼa ette kʼadda kʼille umbo. Yʼa uupe balɗa wo ɗoŋ an dʼettiyo ki tuddí tʼume tuuku toŋ maŋ. ");
INSERT INTO moz_vpl VALUES ("MK2_1","071_2_1","MRK","2","1","1","Onniyo miibi kʼita maŋ Isa yʼa-gime Kapernayim. Ɗoŋ an illiga maŋ Isa yi-gimo, yoŋ adda ɓoy. ");
INSERT INTO moz_vpl VALUES ("MK2_2","071_2_2","MRK","2","2","2","Ɗuwo an dʼuune ɓoy wede Isa adda geŋ ɓoo a-tʼuɗɗe biza bumɓu. Wo yʼan di kazita ono Raa. ");
INSERT INTO moz_vpl VALUES ("MK2_3","071_2_3","MRK","2","3","3","Aame geŋ i dʼiido ɗuwo an dʼumɓo wede ruŋguyuŋ ti zaaɗe, ɗoŋ piɗe ge sarkiya. ");
INSERT INTO moz_vpl VALUES ("MK2_4","071_2_4","MRK","2","4","4","Wo urzi an i-di tʼette kʼume kʼIsa umbo kono ɗuwo ɓaadaŋ. Iŋkino maŋ an a-ti gili tʼekki ɓoy, an dʼihina bulɗo tʼeego a ume Isa yi tʼîhira. Wede ruŋguyuŋ geŋ an ti yʼ zuyye ti zaaɗayí pay a gulbayí. ");
INSERT INTO moz_vpl VALUES ("MK2_5","071_2_5","MRK","2","5","5","Isa yi wulle kane an ziipe addaŋ a yode maŋ, aame geŋ yi di ruute a wede ruŋguyuŋ, yʼede: «Ulo ki nuŋ, olɗikadá nʼa yʼ tʼize tambobino.» ");
INSERT INTO moz_vpl VALUES ("MK2_6","071_2_6","MRK","2","6","6","A ume geŋ i dʼede ɗoŋ suuniyo kʼoogoro miibi, an ti guune. Kane an dʼelkiso adda kʼaddaŋ, anʼde: ");
INSERT INTO moz_vpl VALUES ("MK2_7","071_2_7","MRK","2","7","7","«Ki moo me wede eŋ yi rootiyo iŋkino me? Yi kalɗa suma Raa! Wee wee aane aase tambobino a olɗiko wede, daa ki Raa siidí ye maŋ?» ");
INSERT INTO moz_vpl VALUES ("MK2_8","071_2_8","MRK","2","8","8","A kaamiki, elkisadaŋ Isa yʼa ti zuune adda kʼaddí, wo yʼan di ruute, yʼede: «Ki moo me kun dʼelkiso adda kʼadduguŋ iŋkino me? ");
INSERT INTO moz_vpl VALUES ("MK2_9","071_2_9","MRK","2","9","9","Ise laylay a jiire miŋ too me a nuŋ nʼa roote a wede ruŋguyuŋ: “Olɗikadá Raa yʼa yʼ tʼize tambobino” kunuŋ, nʼa roote: “Ki tʼoozo, ki tʼamɓo zaaɗayá wo kʼa oziro me?” ");
INSERT INTO moz_vpl VALUES ("MK2_10","071_2_10","MRK","2","10","10","Wo ni dehu kun di suune, nuŋ wede an nʼehe aa ulo wede eŋ, adda duniya ette o dʼede toogo kʼisiyo tambobino a olɗiko.» Maŋ yi di ruute a wede ruŋguyuŋ, yʼede: ");
INSERT INTO moz_vpl VALUES ("MK2_11","071_2_11","MRK","2","11","11","«Nuŋ nʼa di rooto, ki tʼoozo, ki tʼamɓo zaaɗayá, kʼa aaho ɓoozá.» ");
INSERT INTO moz_vpl VALUES ("MK2_12","071_2_12","MRK","2","12","12","A kaamiki wede yʼa tʼiiziga, yʼa tʼumɓe zaaɗayí a ɗaana ɗoŋ pay, yʼa tʼuɗɗe yʼa iŋgile. Kane ɗoŋ pay geŋ an ziiɗa giggiraŋ, an tamma Raa, anʼde: «Munɗa kino eŋ kaŋ soo toŋ ay ki wulle ye.» ");
INSERT INTO moz_vpl VALUES ("MK2_13","071_2_13","MRK","2","13","13","Onniyo soo Isa yʼa-gime biza bar Galile. Ɗoŋ ɓaadaŋ an dʼettiyo tuddí wo yi diʼn dooyiso. ");
INSERT INTO moz_vpl VALUES ("MK2_14","071_2_14","MRK","2","14","14","Tiŋ geŋ yʼa iide, a urzi yi wulle Lebi ulo kʼAlpe, yi-guune a ume naabadí yi seɗɗu jibaaye. Isa yi di ruute, yʼede: «Ki ni daani!» Maŋ yoŋ yʼa tʼiiziga wo yʼa yi diine. ");
INSERT INTO moz_vpl VALUES ("MK2_15","071_2_15","MRK","2","15","15","Isa yʼiideʼŋ yʼa-guune omɓo ti sanalliyagí di Lebi. Aame an ti guune maŋ, ɗoŋ seɗɗu jibaaye ɓaadaŋ ti ɗoŋ kʼolɗiko oŋgo pây an di-guune ti kane kaŋ soo, kono ɗoŋ ɓaadaŋ i yi diine me. ");
INSERT INTO moz_vpl VALUES ("MK2_16","071_2_16","MRK","2","16","16","Kane ɗoŋ suuniyo kʼoogoro ti diine Pariziyeŋ an wolliyo Isa yʼomɓo ti ɗoŋ seɗɗu jibaaye wo ti ɗoŋ kʼolɗiko oŋgo iŋkino maŋ, an an di ruute a sanalliyagí, anʼde: «Ki moo me yi dʼomɓo ti ɗoŋ seɗɗu jibaaye wo ti ɗoŋ kʼolɗiko oŋgo me?» ");
INSERT INTO moz_vpl VALUES ("MK2_17","071_2_17","MRK","2","17","17","Isa yiʼn illiga maŋ, yʼan di ruute, yʼede: «Kane ɗoŋ waalin̰ an ki yʼ dehe ye wede daawiya me, wo i yi dehe ɗoŋ kʼeeni. Nuŋ ni kʼiidoʼŋ waaku kane ɗoŋ ki diine ye, wo ɗe nʼiidoʼŋ waaku kane ɗoŋ kʼolɗiko.» ");
INSERT INTO moz_vpl VALUES ("MK2_18","071_2_18","MRK","2","18","18","Onniyo soo sanalliyagi ki Zaŋ Batis ti Pariziyeŋ, an di lekkiyo onniyo muno daa kʼomɓo. Ɗoŋ miibi an dʼiide an tunde Isa, anʼde: «Ki moo me kane sanalliyagá onniyo muno an ki lekkiyo daa kʼomɓo ye, wo kaciŋ sanalliyagi ki Zaŋ ti ɗoŋ ki Pariziyeŋ, onniyo muno an di lekkiyo daa kʼomɓo me?» ");
INSERT INTO moz_vpl VALUES ("MK2_19","071_2_19","MRK","2","19","19","Isa yʼan diʼn gime onamaŋ, yʼede: «Kun elkiyo miŋ ɗoŋ anʼni wiiko a tarnaape seeɗu, onniyo muno an di lekke daa kʼomɓo ko aame kule kʼere yoŋ a diinayaŋ maŋ? Aha, iŋkino ye! Ise onniyo miibi toŋ kule kʼere a sirpadaŋ maŋ, onniyo muno an kʼaane an ki lekke daa kʼomɓo ye. ");
INSERT INTO moz_vpl VALUES ("MK2_20","071_2_20","MRK","2","20","20","Wo saŋ onniytagi an dʼaana, aame kule kʼere ti diinayaŋ an ti yʼumɓa maŋ. A onniytagi geŋ kane onniyo muno an di lekka daa kʼomɓo kollo. ");
INSERT INTO moz_vpl VALUES ("MK2_21","071_2_21","MRK","2","21","21","Beehiye ye wenɗa yi dʼamɓe buuɗe kalle aware yʼa-tʼobbira ekki kalle mazzini me, para maŋ buuɗe wede aware geŋ yʼa tʼaaɗi kalle wede mazzini gen̰n̰o, a di sittite a ceere sey. ");
INSERT INTO moz_vpl VALUES ("MK2_22","071_2_22","MRK","2","22","22","Wo beehiye ye wenɗa yi tʼeepe toote kʼin̰n̰i bin̰ wede oozige ɓotto adda riitile wede mazzini me, para maŋ toote geŋ yʼa-ɓatte riitile, wo toote ti riitile pây i-litte. Ki too maŋ toote wede oozige ɓotto geŋ eepiyadí adda riitile wede aware.» ");
INSERT INTO moz_vpl VALUES ("MK2_23","071_2_23","MRK","2","23","23","Onniyo soo ere ki puukiyo Yawudiyagi maŋ, Isa yi doopiɗe tʼadda domɓi ɗoŋ ki geme ti sanalliyagí. Aame geŋ kane sanalliyagí an dʼiise sattita geme an di doyɗiso. ");
INSERT INTO moz_vpl VALUES ("MK2_24","071_2_24","MRK","2","24","24","Kane Pariziyeŋ an i di ruute Isa, anʼde: «Ki moo me sanalliyagá an dʼisiyo munɗa wede oogiradiŋ ti kʼele urzi kʼisiyo ye a onniyo ere ki puukiyadiŋ te?» ");
INSERT INTO moz_vpl VALUES ("MK2_25","071_2_25","MRK","2","25","25","Maŋ Isa yʼan diʼn gime onamaŋ, yʼede: «Ki kotto kun gire munɗa wede ti kaaga onniyo soo yode Dawut yʼize ti ɗoŋ a itadí, aame an tʼize oon̰e wo mosogo tiʼni ziiɗa geŋ me. ");
INSERT INTO moz_vpl VALUES ("MK2_26","071_2_26","MRK","2","26","26","Aame mozigo goole ɗoŋ seɗeke Abiyatar geŋ, Dawut yi-tʼiide adda Ɓoy Raa wede an ikkima ki golmodo, yʼa ziki mappa wede an i ele seɗeke a Raa, wo yode ti ɗoŋ a itadí toŋ an dʼiimi. Wo Raa yʼan kʼize munɗa ye, ki too maŋ kane an kʼede ye urzi an dʼoomi me, oogiradiŋ tʼele urzi a ɗoŋ seɗeke ɗaŋŋal.» ");
INSERT INTO moz_vpl VALUES ("MK2_27","071_2_27","MRK","2","27","27","Wo Isa yʼan di ruute sey, yʼede: «Onniyo ere ki puukiyo gette Raa yi ti ziipe a wede, wo wede geŋ Raa yi yʼikkima kono kʼonniyo ere ki puukiyo ye. ");
INSERT INTO moz_vpl VALUES ("MK2_28","071_2_28","MRK","2","28","28","Iŋkino maŋ nuŋ wede an nʼehe aa ulo wede eŋ, o dʼede urzi kʼisiyo munɗa wede aa addó i dehu ekkʼonniyo ere ki puukiyadiŋ toŋ maŋ.» ");
INSERT INTO moz_vpl VALUES ("MK3_1","071_3_1","MRK","3","1","1","Saŋ maŋ Isa yʼa tʼiide sey kʼadda ɓoy wede Yawudiyagi ge dooyiso. Adda ɓoy geŋ i dʼede wedusu soo iŋkino beezí unto. ");
INSERT INTO moz_vpl VALUES ("MK3_2","071_3_2","MRK","3","2","2","Kane Pariziyeŋ an dehu an tʼoone urzi an di sakiya Isa, kono kamo an di wolliyo koomadí, a onniyo ere ki puukiyo Yawudiyagi, a wede geŋ yi-tʼela beeko ko. ");
INSERT INTO moz_vpl VALUES ("MK3_3","071_3_3","MRK","3","3","3","Iŋkino maŋ Isa yi di ruute a wede beezí unto geŋ, yʼede: «Ki tʼoozo, ki tʼôhor a diine ɗuwo kino.» ");
INSERT INTO moz_vpl VALUES ("MK3_4","071_3_4","MRK","3","4","4","Maŋ Isa yʼa tunde ɗoŋ i yi wolliyo, yʼede: «Oogiradiŋ tʼele urzi kʼisiyo ki moo me a onniyo ere ki puukiyadiŋ te? A wedusu ki dʼise beehiye kunuŋ, ki dʼise ulsu ko? Wedusu kʼa yʼutte kunuŋ, kʼa yi tʼîde ko?» Wo ɗe kane an dʼannugu ɗeɗɗek. ");
INSERT INTO moz_vpl VALUES ("MK3_5","071_3_5","MRK","3","5","5","Aame geŋ kane Isa yi diʼn wolliyo adda kʼedayaŋ ti kulkuwo, wo addí a litte kono kane addaŋ zakiɗi. Iŋkino maŋ yi di ruute a wede geŋ, yʼede: «Beezá ki yʼonɗo.» Maŋ yʼa yʼunɗe, wo beezí a tʼikkima. ");
INSERT INTO moz_vpl VALUES ("MK3_6","071_3_6","MRK","3","6","6","Saŋ kane Pariziyeŋ tiŋ geŋ an tʼuɗɗe, a kaamiki an tʼugiye ti ɗoŋ a ita kʼErod, an tʼîide onamaŋ kaŋ soo a tukkʼIsa, an di dehe urzi ki tôwwadí. ");
INSERT INTO moz_vpl VALUES ("MK3_7","071_3_7","MRK","3","7","7","Isa ti sanalliyagí an tʼirga biza bar ki Galile, wo ɗoŋ duuru ɓaadaŋ an di yʼ diine. Kane ɗuwo geŋ anʼtiyo ti siiɗo Galile, ti siiɗo Ziide, ");
INSERT INTO moz_vpl VALUES ("MK3_8","071_3_8","MRK","3","8","8","ti geeger Zeruzalem, ti siiɗo kʼIdume, ti dar kʼooye Zurden ki kese peeɗo ge-koliyo, wo ti siiɗo ere i ɗuule geeger Tir ti Sidoŋ. Kane ɗoŋ duuru pay geŋ an dʼiide kʼume kʼIsa kono an illiga sulɗi ɗoŋ pay yʼisiyo geŋ me. ");
INSERT INTO moz_vpl VALUES ("MK3_9","071_3_9","MRK","3","9","9","Iŋkino maŋ Isa yʼan di ruute sanalliyagí, yʼede: «Kunʼdo, kun o wolli tooko, kun o-tʼargi goppoŋ kono ɗoŋ duuru an ki tiʼn n̰iiɗa ye.» ");
INSERT INTO moz_vpl VALUES ("MK3_10","071_3_10","MRK","3","10","10","Yi ruute iŋkino kono yoŋ yʼeliyo beeko a ɗoŋ ɓaadaŋ geŋ, wede kʼeeni tuuku toŋ yi ŋaaƴu, yʼette, yʼa bottey tuddí. ");
INSERT INTO moz_vpl VALUES ("MK3_11","071_3_11","MRK","3","11","11","Wo kane ɗoŋ an dʼede siitan eedaŋ geŋ, wede tuuku yi wolliyo Isa maŋ yi-tʼottilso, yi dʼeesiyo ɗollite: «Kee Ulo Raa! Kee Ulo Raa!» ");
INSERT INTO moz_vpl VALUES ("MK3_12","071_3_12","MRK","3","12","12","Wo ɗe yʼan di ruute ti golla zakiɗi a ɗuwo, kono an ki roote ye a munɗa wede yʼize me. ");
INSERT INTO moz_vpl VALUES ("MK3_13","071_3_13","MRK","3","13","13","Saŋ maŋ Isa yi wiike ɗoŋ aa addí i dehu, an dʼiŋgile ti yode kʼekki mokkolo. ");
INSERT INTO moz_vpl VALUES ("MK3_14","071_3_14","MRK","3","14","14","Maŋ yi dʼiiɗiba ti diinayaŋ ɗoŋ koomat makumu sire yʼanni wiike sundaŋ ɗoŋ zina. Yoŋ yiʼni biire a yode, kono yʼanni tʼikkipa kazita kʼono Raa. ");
INSERT INTO moz_vpl VALUES ("MK3_15","071_3_15","MRK","3","15","15","Wo yʼan dʼele toogo ki lommite siitanɗani ɗoŋ an tʼooney a ɗaanadaŋ. ");
INSERT INTO moz_vpl VALUES ("MK3_16","071_3_16","MRK","3","16","16","En̰n̰o sumɓiyagi ɗoŋ koomat makumu sire Isa yi biire me: Simo wede Isa yʼa yi wiike sundí soo te Piyer; ");
INSERT INTO moz_vpl VALUES ("MK3_17","071_3_17","MRK","3","17","17","Zak ti leemadí Zaŋ in̰n̰i Zebede, Isa yi diʼn waaku sundaŋ Bonarzez, i-kaza kane geŋ aa eɗɗiso mizzi; ");
INSERT INTO moz_vpl VALUES ("MK3_18","071_3_18","MRK","3","18","18","Andire, Pilip, Bartelemi, Matiye, Toma, Zak ulo kʼAlpe, Taade, Simo wede addí wehini kono siiɗadí me, ");
INSERT INTO moz_vpl VALUES ("MK3_19","071_3_19","MRK","3","19","19","wo Ziidas Iskariyot wede saŋ yʼan di yʼ tʼela Isa a bey ɗoŋ kʼolmiɗayí. ");
INSERT INTO moz_vpl VALUES ("MK3_20","071_3_20","MRK","3","20","20","Saŋ maŋ Isa ti sanalliyagí an di-gimo ɓoy, wo ɗoŋ ɓaadaŋ an di tʼugiye sey, urzi an dʼoomi munɗa toŋ umbo. ");
INSERT INTO moz_vpl VALUES ("MK3_21","071_3_21","MRK","3","21","21","Aame maawí an illiga iŋkino maŋ, an tʼiide waakuzí, kono an elkiyo eedí ti digge. ");
INSERT INTO moz_vpl VALUES ("MK3_22","071_3_22","MRK","3","22","22","Ɗoŋ suuniyo kʼoogoro iido ti Zeruzalem an di rootiyo, anʼde: «Meeda siitanɗani sundutú Belzebul ti yode. Geŋ Meeda siitanɗani i eliyo toogo ki lommite siitanɗani me!» ");
INSERT INTO moz_vpl VALUES ("MK3_23","071_3_23","MRK","3","23","23","Iŋkino maŋ Isa yʼanni wiike, yʼan di ruute tʼono ombiɗe, yʼede: «Mummino me Meeda siitanɗani tʼa limmi tuddutú me? ");
INSERT INTO moz_vpl VALUES ("MK3_24","071_3_24","MRK","3","24","24","Aame moziko ere tuuku ɗoŋtú an ɗeyyiso ti tuddaŋ maŋ, kane geŋ an kʼaane an ki ti lekke kaŋ soo ye. ");
INSERT INTO moz_vpl VALUES ("MK3_25","071_3_25","MRK","3","25","25","Wo aame adda ɓoy ɗoŋzí an ɗeyyiso ti tuddaŋ maŋ, kane geŋ an kʼaane an ki ti lekke kaŋ soo ye. ");
INSERT INTO moz_vpl VALUES ("MK3_26","071_3_26","MRK","3","26","26","Geŋ iŋkino kay, aame Meeda siitanɗani ti ɗeyyiso ti siitanɗani eebutú maŋ, geŋ an ɗeyyiso ti tuddaŋ batum. Wo ɗe geŋ ki kotto, mozikatú ti kʼaane ti ki lekke ye, tʼa ɗaŋga! ");
INSERT INTO moz_vpl VALUES ("MK3_27","071_3_27","MRK","3","27","27","Aame wede yi dehu yi-tʼette adda ɓoy ki wede i-dʼede toogo wo yʼa sikiti sulɗizí maŋ, wede geŋ ki poone yʼa-kettite wede toogo ɗoo miŋ, yʼa aane yʼa sikiti sulɗi tʼadda ɓoy kollo. ");
INSERT INTO moz_vpl VALUES ("MK3_28","071_3_28","MRK","3","28","28","Ɗerec iŋkino wo nʼun di rooto: Ɗuwo Raa yʼan tʼisa tambobino a olɗiko ere pay an isiyo, ti kalɗita ere pay an kalɗita suma Raa gette. ");
INSERT INTO moz_vpl VALUES ("MK3_29","071_3_29","MRK","3","29","29","Wo ɗe wede tuuku i kalɗita Unde Kamilen̰ maŋ, yoŋ geŋ toc Raa yi-kʼisa tambobino ye, olɗikadí tʼa lekka ki daayum.» ");
INSERT INTO moz_vpl VALUES ("MK3_30","071_3_30","MRK","3","30","30","Isa yʼan orbe iŋkino kono ɗuwo anʼde yoŋ i-dʼede siitan a eedí. ");
INSERT INTO moz_vpl VALUES ("MK3_31","071_3_31","MRK","3","31","31","Isa adda ɓoy, aame geŋ meedí ti zemɓadí an dʼiina, wo an tʼîhira ti paate, an dʼigibe wedusu yʼan di yʼ waako. ");
INSERT INTO moz_vpl VALUES ("MK3_32","071_3_32","MRK","3","32","32","Ɗoŋ ɓaadaŋ an di-guune, Isa an ti yʼ ɗuule, yoŋ a diine. Maŋ an i di ruute, anʼde: «Kʼollo, meedá ti zemɓadá an tʼîhira ti paate, an ki dehu.» ");
INSERT INTO moz_vpl VALUES ("MK3_33","071_3_33","MRK","3","33","33","Isa yi diʼn gime onamí, yʼede: «Ki kotto maŋ, meedó ti zemɓadó aŋ wee wee?» ");
INSERT INTO moz_vpl VALUES ("MK3_34","071_3_34","MRK","3","34","34","Maŋ ɗoŋ i-guune i ti yʼ ɗuule geŋ yi diʼn wolliyo adda kʼedayaŋ, wo yʼa ruute, yʼede: «Kun wollo, kane en̰n̰o aŋ meedó ti zemɓadó me. ");
INSERT INTO moz_vpl VALUES ("MK3_35","071_3_35","MRK","3","35","35","Iŋkino maŋ wede tuuku yʼisiyo sulɗi ɗoŋ pay Raa yi dehu geŋ, yode gen̰n̰o leemadó, teemadó wo meedó me.» ");
INSERT INTO moz_vpl VALUES ("MK4_1","071_4_1","MRK","4","1","1","Isa yo a biza bar Galile, aame geŋ yʼa iise dooyiso ɗuwo sey. Ɗoŋ duuru ɓaadaŋ ɓaadaŋ an di-tʼugiye, iŋkino yi di gili adda tooko ekkʼahu, yʼa-guune wo kane ɗoŋ duuru pay an tʼîhira a biza bar. ");
INSERT INTO moz_vpl VALUES ("MK4_2","071_4_2","MRK","4","2","2","A dooyisadí gette yʼan diʼn duuye a sulɗi ɓaadaŋ tʼono ombiɗe, yʼede: ");
INSERT INTO moz_vpl VALUES ("MK4_3","071_4_3","MRK","4","3","3","«Kun ollo! I dʼede wedusu soo iŋkino yi tʼiide korso buzu kʼadda doome. ");
INSERT INTO moz_vpl VALUES ("MK4_4","071_4_4","MRK","4","4","4","Aame yi sakkisa geŋ, buzu oŋgoŋ a-zilɗiti a urzi, emɓi an iidoʼŋ an di-tiɓɓe pay. ");
INSERT INTO moz_vpl VALUES ("MK4_5","071_4_5","MRK","4","5","5","Buzu oŋgoŋ soŋ a-zilɗiti a ume wede tʼaddaʼŋ paŋgiragi, siiɗadí baata. Kane geŋ a tʼuɗɗe kesiko kono siiɗadaŋ soodo. ");
INSERT INTO moz_vpl VALUES ("MK4_6","071_4_6","MRK","4","6","6","Aame peeɗo ti-gilo wo tʼihina maŋ, kane geŋ a tʼigge, a-biiha kono sondayzaŋ i ki ti ɗiige ye. ");
INSERT INTO moz_vpl VALUES ("MK4_7","071_4_7","MRK","4","7","7","Ɗoŋ soŋ a-zilɗiti adda kʼahimagi, kane geŋ a tʼuɗɗe wo ahimagi an iiziga maŋ, an diʼn ippe an ki dʼehe ye. ");
INSERT INTO moz_vpl VALUES ("MK4_8","071_4_8","MRK","4","8","8","Ɗoŋ oŋgoŋ soŋ a-zilɗiti a siiɗo ere beehiye, kane geŋ a tʼuɗɗe, an dʼihira wo an dʼehe: ulo muduso soo yʼa ehe in̰n̰i ada gʼaɗo, soŋ ada zoot wo soŋ meeda.» ");
INSERT INTO moz_vpl VALUES ("MK4_9","071_4_9","MRK","4","9","9","Maŋ Isa yʼa ruute, yʼede: «Wede i-dʼede kuwwa kʼollige maŋ, yʼollo koɗuwo!» ");
INSERT INTO moz_vpl VALUES ("MK4_10","071_4_10","MRK","4","10","10","Saŋ Isa yʼa tʼirga ti tukki ɗoŋ duuru. Aame geŋ ɗoŋ i ti yʼ ɗuule ti kane sanalliyagi koomat makumu sire geŋ an di yʼ tunde, ki moo me yʼan rootiyto a ɗoŋ duuru tʼono ombiɗe me? ");
INSERT INTO moz_vpl VALUES ("MK4_11","071_4_11","MRK","4","11","11","Yoŋ yʼan di ruute, yʼede: «A kuneʼŋ Raa yʼun ele suuniyo ki sulɗi ɗoŋ ombiɗe ki Moziko Raa te, wo ɗe a ɗoŋ oŋgoŋ sulɗi pay geŋ an an rootiytoʼŋ tʼono ombiɗe, ");
INSERT INTO moz_vpl VALUES ("MK4_12","071_4_12","MRK","4","12","12","iŋkino: “Kane geŋ an di wolliyo keren̰, wo munɗa an ki yʼ wolliyo ye, an dʼollige keren̰, wo ono itadaŋ an ki ti suuniyo ye, para maŋ an di-kime ki tukki Raa, yʼan tʼise tambobino a olɗikadaŋ te!”» ");
INSERT INTO moz_vpl VALUES ("MK4_13","071_4_13","MRK","4","13","13","Isa yʼan di ruute sey, yʼede: «Ono ombiɗe eŋ itadaŋ kun kiʼn suuniyo ye! Ɗe mummino kun diʼn suuna ita kʼono ombiɗe pay geŋ me? ");
INSERT INTO moz_vpl VALUES ("MK4_14","071_4_14","MRK","4","14","14","Wede korso geŋ yi korso ono Raa. ");
INSERT INTO moz_vpl VALUES ("MK4_15","071_4_15","MRK","4","15","15","Buzu wede i zilɗiti a biza kʼurzi geŋ, i-kaza ɗuwo ɗoŋ ollige ono Raa, wo ɗe an tʼollige maŋ a kaamiki Meeda siitanɗani tʼettiyo, ti-tʼoɗɗipe ono geŋ tʼadda kʼaddaŋ me. ");
INSERT INTO moz_vpl VALUES ("MK4_16","071_4_16","MRK","4","16","16","Buzu wede i zilɗiti a ume wede tʼadda paŋgiragi geŋ, i-kaza ɗuwo ɗoŋ ollige ono Raa, kesiko ulbaŋ uŋse an dʼamɓu. ");
INSERT INTO moz_vpl VALUES ("MK4_17","071_4_17","MRK","4","17","17","Wo ɗe ono sottadaŋ ti ki ti ɗeegu adda kʼaddaŋ, an aa ki seeɗu zakiɗi ye, aame i ettiyo dabar ise ɗuwo anʼni dabirsa kono an umɓe a ono Raa maŋ, kesiko an tʼargu. ");
INSERT INTO moz_vpl VALUES ("MK4_18","071_4_18","MRK","4","18","18","Buzu wede i zilɗiti adda kʼahimagi geŋ, i-kaza ɗuwo ɗoŋ ollige ono Raa, ");
INSERT INTO moz_vpl VALUES ("MK4_19","071_4_19","MRK","4","19","19","wo ɗe saŋ elkisito a sulɗi duniya, dehutu kʼurzi maala wo zaapu kʼadde a sulɗi ɗoŋ ulpi tuddaŋ ti dehu ti doolo toŋ ede. Kane pay geŋ ono an diʼn appiya, an ki dʼohire ye a urzi Raa me. ");
INSERT INTO moz_vpl VALUES ("MK4_20","071_4_20","MRK","4","20","20","Ki ɗaŋgu buzu wede i zilɗiti a siiɗo ere beehiye gette, i-kaza ɗuwo ɗoŋ ollige ono Raa wo an diʼn seeɗu adda kʼaddaŋ, an dʼohire a urzi Raa, an aa dʼooniyo eebaŋ ti doolo, aakede ulo muduso soo yʼa ehe in̰n̰i ada gʼaɗo, soŋ ada zoot, wo soŋ meeda.» ");
INSERT INTO moz_vpl VALUES ("MK4_21","071_4_21","MRK","4","21","21","Isa yʼan di ruute sey, yʼede: «Aame wede yʼa tʼuyye pitila maŋ, yʼa-tʼossibe bogoro kunuŋ, yi-ti tʼele a ita kʼoŋgali ko? Aha, ki too maŋ yʼa ti zaape tʼawwa. ");
INSERT INTO moz_vpl VALUES ("MK4_22","071_4_22","MRK","4","22","22","Sulɗi ɗoŋ pay ombiɗeʼŋ, saŋ onniyo soo a tʼooɗiba ita, wo ono ɗoŋ i ki dehu ɗuwo an kʼolliga ye geŋ, saŋ onniyo soo a tʼaɗɗa a toore. ");
INSERT INTO moz_vpl VALUES ("MK4_23","071_4_23","MRK","4","23","23","Wede i-dʼede kuwwa kʼollige maŋ, yʼollo koɗuwo!» ");
INSERT INTO moz_vpl VALUES ("MK4_24","071_4_24","MRK","4","24","24","Isa yʼan di ruute sey, yʼede: «Kun koona mentikagi a ono ɗoŋ kun ollige. Ɗerec, dooziyo ere kun dooziyo a ɗuwo gette, Raa toŋ yʼun ti dooza a kune iŋkino kay, wo yʼa dʼoɓa ti jugulu a kune me. ");
INSERT INTO moz_vpl VALUES ("MK4_25","071_4_25","MRK","4","25","25","Ɗerec, a wede i-dʼede suuniyoʼŋ, an i-tʼeela tʼeego, wo ɗe a wede i-kʼede suuniyo ye, ere booloŋ i-dʼede toŋ an i-tʼamɓa.» ");
INSERT INTO moz_vpl VALUES ("MK4_26","071_4_26","MRK","4","26","26","Isa yʼa ruute sey, yʼede: «Moziko Raa todʼ ti deeƴiso aa wede yi sakkisa buzu adda doomizí. ");
INSERT INTO moz_vpl VALUES ("MK4_27","071_4_27","MRK","4","27","27","Wo ki yode diɗɗo tʼettiyo yi-ti moone, wo ume i tʼompilso maŋ yi-tʼoozige, yi ki suune ye ume buzu yʼaɗɗiya wo yi dʼohire mummino toŋ maŋ. ");
INSERT INTO moz_vpl VALUES ("MK4_28","071_4_28","MRK","4","28","28","Naabo gette i ti suuniyo tode siiɗo sittú. I-tʼaɗɗiya ki poone soole, saŋ i-tʼisiyo koƴile, saŋ mahuwe i-ti pan̰a, saŋ i-ti tana. ");
INSERT INTO moz_vpl VALUES ("MK4_29","071_4_29","MRK","4","29","29","Aame i ti tana maŋ, wede yi dʼamɓu suwwo ki ayɗu baa, kono peeɗo tʼîide kʼayɗu.» ");
INSERT INTO moz_vpl VALUES ("MK4_30","071_4_30","MRK","4","30","30","Isa yʼa ruute sey, yʼede: «Moziko Raa in tʼeese todʼte aa moo me? In di roote todʼte ti ono ombiɗe ɗoŋ tuuku me? ");
INSERT INTO moz_vpl VALUES ("MK4_31","071_4_31","MRK","4","31","31","Tode gette ti deeƴiso aa ulo kʼundumu soo sundí mutard. Aame ki kiira geŋ, ulo kʼundumu miŋ yoŋ n̰eŋku a jiire ti diine kʼin̰n̰i kʼinda pay ɗoŋ adda duniya. ");
INSERT INTO moz_vpl VALUES ("MK4_32","071_4_32","MRK","4","32","32","Wo ɗe ki-giira kotto maŋ, yi-tʼaɗɗiya yi dʼisiyo goole i ceeriyo inda ɗoŋ pay adda jineene gen̰n̰o, yi dʼahuntu layɗayi deero emɓi an dʼappiyta ɓoyɗizaŋ eego.» ");
INSERT INTO moz_vpl VALUES ("MK4_33","071_4_33","MRK","4","33","33","Geŋ Isa a dooyisadí gette, yiʼni duuye ɗuwo tʼono ombiɗe ɓaadaŋ iŋkino, aa ere an aane an yʼolliga. ");
INSERT INTO moz_vpl VALUES ("MK4_34","071_4_34","MRK","4","34","34","A ɗuwo munɗa daa kʼono ombiɗe yʼan ki rootiyo ye, wo ɗe aame yoŋ siidí ti sanalliyagí maŋ, yʼan tʼooɗibe ita kʼono ombiɗe pay geŋ me. ");
INSERT INTO moz_vpl VALUES ("MK4_35","071_4_35","MRK","4","35","35","A onniyo gettiyo batum a peeɗo tʼa tʼiire maŋ, Isa yʼan di ruute a sanalliyagí, yʼede: «In ti doopoʼŋ ti dar bar ti nee.» ");
INSERT INTO moz_vpl VALUES ("MK4_36","071_4_36","MRK","4","36","36","Iŋkino maŋ ɗoŋ duuru an diʼn iili zeŋge tʼinno, kane sanalliyagí an a di gili ti yode adda tooko, wo tookiyagi doolo toŋ ede a sirpadaŋ an dʼiŋgile. ");
INSERT INTO moz_vpl VALUES ("MK4_37","071_4_37","MRK","4","37","37","A kaamiki, i dʼiiziga maaye ɓaadaŋ adda bar. Ahu geŋ i-kolzite kolzite i dʼoɓite kʼadda tooko, todʼte i tʼôoniyo tʼahu. ");
INSERT INTO moz_vpl VALUES ("MK4_38","071_4_38","MRK","4","38","38","Isa geŋ yoŋ a ume kʼita, yʼa udige kuy yʼa ti ziɗɗe eedí a wasaade. Sanalliyagí an tʼiide an di yʼinne, wo an i di ruute, anʼde: «Wede dooyisadey, kine in tʼunto miŋ, kee ki moone tanɗaŋ?» ");
INSERT INTO moz_vpl VALUES ("MK4_39","071_4_39","MRK","4","39","39","Iŋkino maŋ Isa yʼa tʼiiziga, yʼa yʼiɗɗise maaye me, wo ahu bar yʼan di ruute, yʼede: «Kun ôhor! Kun tʼasso!» Maŋ maaye yʼa ziiɗa, wo ahu toŋ an tʼudige ɗeɗɗek. ");
INSERT INTO moz_vpl VALUES ("MK4_40","071_4_40","MRK","4","40","40","Saŋ Isa yʼan di ruute sanalliyagi, yʼede: «Kun orgiso iŋkino moo me? Kun ki ziipe adduguŋ a nuuno ye ɓotto ko?» ");
INSERT INTO moz_vpl VALUES ("MK4_41","071_4_41","MRK","4","41","41","Wo kane orgiso tʼanni ziiɗa ɓaadaŋ, an di rootiyto tuddaŋ, anʼde: «Yode eŋ moo wede me, kono aŋ maaye ti ahu bar toŋ an dʼollige onamí me!» ");
INSERT INTO moz_vpl VALUES ("MK5_1","071_5_1","MRK","5","1","1","Saŋ Isa ti sanalliyagí an dʼiiney a siiɗo Gadara ti dar bar Galile ti nee. ");
INSERT INTO moz_vpl VALUES ("MK5_2","071_5_2","MRK","5","2","2","Isa yi ti ɗiige tʼekki tooko maŋ, a kaamiki i dʼiide wedusu tʼume muuziyagi yoŋ i-dʼede siitan a eedí, yʼiideʼŋ yʼa yʼikkima. ");
INSERT INTO moz_vpl VALUES ("MK5_3","071_5_3","MRK","5","3","3","Lekkiyadí adda diine muuziyagi, wo wenɗa soo toŋ yi kʼaane yi ki ti kettite ye, ise ti ziŋziri toŋ maŋ. ");
INSERT INTO moz_vpl VALUES ("MK5_4","071_5_4","MRK","5","4","4","Taŋ ɓaadaŋ beyɗí an di kettiso ti ziŋziri wo zoŋɗí adda poole, wo toŋ ziŋziri yi-ti ɗekkiso wo maala poole yi-ti damɓu. Wo wenɗa soo toŋ a aane a ti boohe umbo. ");
INSERT INTO moz_vpl VALUES ("MK5_5","071_5_5","MRK","5","5","5","Daayum, diɗɗo on̰n̰u, lekkiyadí a ume muuziyagi wo ekki kessagi, yi ɗollite, tuddí yi-tʼâhuntu ti moŋgali, kunɗayi jerem. ");
INSERT INTO moz_vpl VALUES ("MK5_6","071_5_6","MRK","5","6","6","Aame yi yʼ wulle Isa ti dokki maŋ, yʼa ukke kʼume yode, yʼa-dikke a ɗaanadí, ");
INSERT INTO moz_vpl VALUES ("MK5_7","071_5_7","MRK","5","7","7","wo yʼa iɗili ti golla awwa, yʼede: «Ki dehu moo me a tukki nuŋ me, Isa Ulo ki Raa goole a jiire pay? Ni dehu kʼa di nâame ti suma Raa, ki ni dabire ye.» ");
INSERT INTO moz_vpl VALUES ("MK5_8","071_5_8","MRK","5","8","8","Yi rootiyo iŋkino kono Isa yi-ruute, yʼede: «Siitan no, mi tʼaɗɗo ti tukki wede me!» ");
INSERT INTO moz_vpl VALUES ("MK5_9","071_5_9","MRK","5","9","9","Isa yʼa yi tunde, yʼede: «Kee sundá wee wee?» Wede geŋ yi diʼn gime onamí, yʼede: «Nuŋ sundó Ɗoŋ Duuru, kono kaye ɓaadaŋ.» ");
INSERT INTO moz_vpl VALUES ("MK5_10","071_5_10","MRK","5","10","10","Wo yi-dʼoɓe bey a Isa, yi koɗɗime kono siitanɗani geŋ yʼa ki tiʼn limmi dokki ti siiɗo gettiyo ye. ");
INSERT INTO moz_vpl VALUES ("MK5_11","071_5_11","MRK","5","11","11","A ume geŋ i dʼede torɗo meeda ki kinzir an elso ekki kesse. ");
INSERT INTO moz_vpl VALUES ("MK5_12","071_5_12","MRK","5","12","12","Kane siitanɗani geŋ an i dʼoɓe bey a Isa, anʼde: «Kʼay tiʼn agibi ay tʼette adda kinzirɗari gen̰n̰o.» ");
INSERT INTO moz_vpl VALUES ("MK5_13","071_5_13","MRK","5","13","13","Maŋ Isa yʼan dʼiyye. Iŋkino siitanɗani tʼekki wede geŋ an tʼuɗɗe, an tʼiide adda kinzirɗari. Wo torɗo gette tʼawwa tʼekki kesse tʼa zide okko, kinzirɗari an tʼiɓi adda bar, an tʼinda adda kʼahu. Kane suma dupu sire. ");
INSERT INTO moz_vpl VALUES ("MK5_14","071_5_14","MRK","5","14","14","Kane ɗoŋ kʼelso geŋ an dʼukke, an an tʼîide taaya a ɗoŋ adda geeger wo a ɗoŋ i lekkiyto a domɓi pây. Ɗuwo geŋ an tʼuɗɗito wolliso ki munɗa wede ize. ");
INSERT INTO moz_vpl VALUES ("MK5_15","071_5_15","MRK","5","15","15","An iina a sirpa kʼIsa maŋ, an wulle wede i ede siitanɗani ɓaadaŋ a eedí wo an tʼuɗɗe geŋ, yoŋ yi-guune, yi tʼusse kalle wo eedí tʼiido. Iŋkino kane geŋ orgiso tʼanni ziiɗa. ");
INSERT INTO moz_vpl VALUES ("MK5_16","071_5_16","MRK","5","16","16","Kane ɗoŋ i wulle munɗa wede ize geŋ an an tʼîide taaya, kaŋ mummino wede i-dʼede siitanɗani a eedí yʼa uune bee, wo soŋ a munɗa wede ize a kinzirɗari. ");
INSERT INTO moz_vpl VALUES ("MK5_17","071_5_17","MRK","5","17","17","Iŋkino maŋ kane ɗoŋ pay an i dʼiise oɓe bey a Isa, kono ti siiɗadaŋ yʼa eŋgile. ");
INSERT INTO moz_vpl VALUES ("MK5_18","071_5_18","MRK","5","18","18","Maŋ Isa yi-ti gili adda tooko, yʼa eŋgile. Aame geŋ wede i ede siitanɗani a eedí wo an tʼuɗɗe geŋ, yi tondiyo Isa kono yʼa lekke ti yode. ");
INSERT INTO moz_vpl VALUES ("MK5_19","071_5_19","MRK","5","19","19","Isa yi-ki dʼiyye ye, wo ɗe yi di ruute, yʼede: «Ki-kama di kee wo kʼan tʼôodoy taaya a ɗoŋzá a sulɗi ɗoŋ pay Galmeega yʼa ize, a isiyo kʼadde koɗuwo yʼize a kee.» ");
INSERT INTO moz_vpl VALUES ("MK5_20","071_5_20","MRK","5","20","20","Maŋ wede yʼa-gime, wo yʼa iise kazita adda siiɗo ere sundutú «Geegiryagi Koomat» sulɗi ɗoŋ pay Isa yi ize a yode geŋ me. Wo kane ɗoŋ pay illiga geŋ an ziiɗa giggiraŋ. ");
INSERT INTO moz_vpl VALUES ("MK5_21","071_5_21","MRK","5","21","21","Isa yʼa-gimo ti tooko yi-ti diipiɗo ti dar bar tʼinno, maŋ yʼa tʼîhira a biza bar wo ɗoŋ duuru ɓaadaŋ an di-tʼugiye. ");
INSERT INTO moz_vpl VALUES ("MK5_22","071_5_22","MRK","5","22","22","Aame geŋ i dʼiina wedusu sundí Zayiris, yoŋ goole ti diine deero ɓoy wede Yawudiyagi ge dooyiso. Yi wulle Isa maŋ yʼa iido, yʼa iire a zoŋɗí ");
INSERT INTO moz_vpl VALUES ("MK5_23","071_5_23","MRK","5","23","23","wo yi-dʼoɓe bey ti koɗɗime, yʼede: «Uto nuŋ tuddutú eeni tʼunto. Kʼa ette maŋ, ki zaapey beezá tʼa uttey wo tʼa lekkey.» ");
INSERT INTO moz_vpl VALUES ("MK5_24","071_5_24","MRK","5","24","24","Iŋkino maŋ Isa yʼa iyye, an dʼiŋgile soo. Wo ɗoŋ duuru ɓaadaŋ an di yʼ diine, an di yʼ ŋaƴƴu tʼen̰n̰o tʼen̰n̰o. ");
INSERT INTO moz_vpl VALUES ("MK5_25","071_5_25","MRK","5","25","25","Ti diine ɗoŋ duuru i dʼede erewo soo iŋkino ti dabirsa, puuzo oɓite tʼitatú îide ozzine koomat makumu sire. ");
INSERT INTO moz_vpl VALUES ("MK5_26","071_5_26","MRK","5","26","26","Tʼa dibire ɓaadaŋ a bey ɗoŋ daawiya ɓaadaŋ wo beytú tʼa zikkuwe pay kono tʼa tʼoone beeko, wo umbo beeko ti kʼuune ye, ki too maŋ ti dabirsa i-ceeriyo ki ceeriyo. ");
INSERT INTO moz_vpl VALUES ("MK5_27","071_5_27","MRK","5","27","27","Todʼ tʼilliga rabila kʼIsa, iŋkino ti-tʼiide diine ɗoŋ duuru ti dar kʼIsa, tʼa-butte kallayí, ");
INSERT INTO moz_vpl VALUES ("MK5_28","071_5_28","MRK","5","28","28","kono tʼa ruute tʼadda kʼaddutú, tʼede: «Aame nʼiina nʼa butta kallayí ɗaŋŋal toŋ maŋ, nʼa utta.» ");
INSERT INTO moz_vpl VALUES ("MK5_29","071_5_29","MRK","5","29","29","Tʼa butte kallayí maŋ, a kaamiki oɓite puuzo a îhira yip, tʼa uwwe a tuddutú tʼuune bee. ");
INSERT INTO moz_vpl VALUES ("MK5_30","071_5_30","MRK","5","30","30","Aame geŋ Isa yʼa uwwe toogo a uɗɗe ti tuddí me. Maŋ yʼa-tuuye tukki ɗoŋ duuru wo yʼa tunde, yʼede: «Wee wee i butte kallayó me?» ");
INSERT INTO moz_vpl VALUES ("MK5_31","071_5_31","MRK","5","31","31","Kane sanalliyagí an i di ruute, anʼde: «Kee kʼowwiyo ɗoŋ an ki ŋaƴƴu tʼen̰n̰o tʼen̰n̰o, wo ki-tondiyo wee wee i butte kallayá sey me?» ");
INSERT INTO moz_vpl VALUES ("MK5_32","071_5_32","MRK","5","32","32","Wo ɗe Isa yi wolliyo ɗoŋ i ti yʼ ɗuule kono yi dehu yʼa suune wede i yʼ butte. ");
INSERT INTO moz_vpl VALUES ("MK5_33","071_5_33","MRK","5","33","33","Maŋ to ere gette tʼa urgiɗe, ti ŋoŋŋirso kono ti zuune munɗa wede i-iide me. Tʼa dʼiide, tʼa iire zoŋɗí wo ɗerec ti di ruute pay. ");
INSERT INTO moz_vpl VALUES ("MK5_34","071_5_34","MRK","5","34","34","Wo ɗe Isa yi di ruute, yʼede: «Uto ki nuŋ, kono koŋ mi ziipe addí a nuuno geŋ, mʼutte. Tʼeenizí geŋ mʼuune bee, mʼaaho ti toose.» ");
INSERT INTO moz_vpl VALUES ("MK5_35","071_5_35","MRK","5","35","35","Aame Isa yʼa ti rootiyto iŋkino geŋ, ɗoŋ zina an okko ti di goole ɓoy wede Yawudiyagi ge dooyiso, an i di ruute a Zayiris, anʼde: «Utá tʼa tʼihe, ki moo me wede dooyiso ki yʼ naatiya sey me?» ");
INSERT INTO moz_vpl VALUES ("MK5_36","071_5_36","MRK","5","36","36","Wo ɗe ono geŋ Isa yʼilliga toŋ seezí ye, wo yi di ruute a goole ɓoy wede Yawudiyagi ge dooyiso, yʼede: «Kee kʼorgiɗe ye, ki zaapo addá a nuuno ɗaŋŋal.» ");
INSERT INTO moz_vpl VALUES ("MK5_37","071_5_37","MRK","5","37","37","Wo a wenɗa soo toŋ urzi yi kʼele ye a ette ti yode me, iide ti yode Piyer, Zak ti leemadí Zaŋ ɗaŋŋal. ");
INSERT INTO moz_vpl VALUES ("MK5_38","071_5_38","MRK","5","38","38","An iiney di goole ɓoy wede Yawudiyagi ge dooyiso maŋ, a ume geŋ Isa yi wolliyo ɗoŋ ɓaadaŋ an ɗollite môolo ɗaŋkar. ");
INSERT INTO moz_vpl VALUES ("MK5_39","071_5_39","MRK","5","39","39","Isa yi-tʼiide kʼadda ɓoy, wo yʼan di ruute, yʼede: «Moo me kun ɗollite môolo me? Uto ti kʼinda ye, ti moone moone.» ");
INSERT INTO moz_vpl VALUES ("MK5_40","071_5_40","MRK","5","40","40","Kane ɗuwo geŋ an di yʼokko maade. Wo ɗe yoŋ yʼan uɗɗe ɗuwo tʼadda ɓoy me, a uupe ti yode meekʼuto ti mekkʼuto wo sanalliyagí ɗoŋ aɗo gen̰n̰o, saŋ Isa yi-tʼiide kʼadda biino ere uto adda. ");
INSERT INTO moz_vpl VALUES ("MK5_41","071_5_41","MRK","5","41","41","Maŋ yi ziiɗa beytú wo yi di ruute, yʼede: «Talita kum!» Geŋ i-kaza: «Uto ki nuŋ, mi tʼonno ni-rootiyo me!» ");
INSERT INTO moz_vpl VALUES ("MK5_42","071_5_42","MRK","5","42","42","A kaamiki, uto tʼa tʼiiziga ti sooru. Todʼte ozzinatú koomat makumu sire. Kane ɗuwo geŋ an wulle iŋkino maŋ, an ziiɗa giggiraŋ kono i jiire eedaŋ. ");
INSERT INTO moz_vpl VALUES ("MK5_43","071_5_43","MRK","5","43","43","Maŋ Isa yʼan dʼundirɗe, yʼede: «A wenɗa soo toŋ kun i roota ye a munɗa wede ize eŋ me.» Saŋ yʼan di ruute, yʼede: «Uto kun i eelo omɓo.» ");
INSERT INTO moz_vpl VALUES ("MK6_1","071_6_1","MRK","6","1","1","Tʼume geŋ Isa yʼa tʼiiziga, yʼa iŋgile ti sanalliyagí ki Nazaret geeger ere yʼa ihira. ");
INSERT INTO moz_vpl VALUES ("MK6_2","071_6_2","MRK","6","2","2","A onniyo ere ki puukiyo Yawudiyagi maŋ, yʼa iise dooyiso ɗuwo adda ɓoy wede Yawudiyagi ge dooyiso. Ɗoŋ ɓaadaŋ i yʼollige geŋ an ziiɗa giggiraŋ, wo an di ruute, anʼde: «Ɗe ono pay eŋ yʼuuno ti too me? Suuniyo kʼono ette i elo wee wee? Wo mummino yi dʼisiyto sulɗi kʼarmika kino me? ");
INSERT INTO moz_vpl VALUES ("MK6_3","071_6_3","MRK","6","3","3","Yo eŋ wede kʼâhuntu sarpaŋje ɗe me! Yoŋ miŋ ulo Mariyam ɗe me! Kane zemɓadí kuuliʼŋ sumɓiyagaŋ Zak, Zoz, Ziid wo Simo ɗe me! Wo zemɓadí erayi toŋ kane an lekkiyo ti kine ɗe me!» Kono kʼiŋkino an di-tuuge kʼamɓu kʼonamí me. ");
INSERT INTO moz_vpl VALUES ("MK6_4","071_6_4","MRK","6","4","4","Isa yʼan di ruute, yʼede: «Ɗerec, nebi geŋ aame tuuku toŋ onamí an dʼollige, wo ɗe ɗoŋ a geeger ere yʼa ihira, ɗoŋ a biza bumɓizí ti ɗoŋ adda ɓoozí ɗaŋŋal, onamí an kʼolliga ye me.» ");
INSERT INTO moz_vpl VALUES ("MK6_5","071_6_5","MRK","6","5","5","A ume geŋ munɗa kʼarmika soo toŋ yi kʼiine yi kʼize ye, wo yʼan di ziipe miŋ beezí a ɗoŋ kʼeeni miibi ɗaŋŋal, an dʼuune bee. ");
INSERT INTO moz_vpl VALUES ("MK6_6","071_6_6","MRK","6","6","6","Wo Isa yi nuukiso eedí kono kane an ki ziipe addaŋ a yode ye. Saŋ maŋ Isa yʼan izire pay illiyagi ɗoŋ i-ɗuule Nazaret geŋ me. ");
INSERT INTO moz_vpl VALUES ("MK6_7","071_6_7","MRK","6","7","7","Maŋ yʼa-wiike sanalliyagi kane koomat makumu sire, yʼan ikkipe sire sire, wo yʼan dʼele toogo ki lommite siitanɗani ɗoŋ an tʼooney a ɗaanadaŋ, ");
INSERT INTO moz_vpl VALUES ("MK6_8","071_6_8","MRK","6","8","8","wo yʼan di ruute munɗa wede an dʼisey, yʼede: «Ki torguwaguŋ munɗa a beyguŋ kun amɓa ye, ise munɗa kʼomɓo, ise eese, ise tammiyagi sun̰n̰i sun̰n̰i adda poosaguŋ toŋ maŋ. Kun amɓo dalka ɗaŋŋal, ");
INSERT INTO moz_vpl VALUES ("MK6_9","071_6_9","MRK","6","9","9","toɓiyagi a zoŋguŋ wo kun osso kalle toŋ soo a tudduguŋ.» ");
INSERT INTO moz_vpl VALUES ("MK6_10","071_6_10","MRK","6","10","10","Wo yʼan di ruute sey, yʼede: «Aame kun tʼiidey adda ɓoy tuuku wo an unni ziiɗey maŋ, kun di lekkoy aŋgen̰n̰o bini eŋgilsaguŋ tʼume gen̰n̰o. ");
INSERT INTO moz_vpl VALUES ("MK6_11","071_6_11","MRK","6","11","11","Wo aame kun tʼiidey ille wo ɗoŋtú an un kiʼn ziiɗey ye wo onamguŋ an kʼilligey ye maŋ, a eŋgilsaguŋ tʼume gen̰n̰o odde zoŋguŋ toŋ kun a ti tottigoy, geŋ i-kaza Raa ulbí uŋse ye ti kane me.» ");
INSERT INTO moz_vpl VALUES ("MK6_12","071_6_12","MRK","6","12","12","Kane sanalliyagi geŋ an dʼiŋgile, an an kazita a ɗuwo kono an di-kime lekkiyadaŋ. ");
INSERT INTO moz_vpl VALUES ("MK6_13","071_6_13","MRK","6","13","13","Siitanɗani ɓaadaŋ an tiʼn lommite, wo ɗoŋ kʼeeni ɓaadaŋ an an di ƴergutu egey an dʼooniyo bee. ");
INSERT INTO moz_vpl VALUES ("MK6_14","071_6_14","MRK","6","14","14","Mozigo Erod geŋ yʼa illiga rabila kʼIsa te, kono yoŋ sundí ti môolo. Ɗoŋ oŋgoŋ an ruute, anʼde: «Geŋ Zaŋ Batis yi bilɗo ti diine ɗoŋ unto! Geŋ kono kʼiŋkino i-dʼede toogo yi dʼisiyto sulɗi kʼarmika me.» ");
INSERT INTO moz_vpl VALUES ("MK6_15","071_6_15","MRK","6","15","15","Ɗoŋ oŋgoŋ anʼde: «Geŋ nebi Eli.» Wo ɗoŋ soŋ anʼde: «Geŋ nebi soo aa wede ti diine nebiyagi ɗoŋ ti kaaga.» ");
INSERT INTO moz_vpl VALUES ("MK6_16","071_6_16","MRK","6","16","16","Wo ɗe aame Erod yʼilliga iŋkino maŋ, yʼa ruute, yʼede: «Geŋ Zaŋ Batis wede nʼan di ruute a asigiryagi an di-ɗikke eedí, geŋ yode i-bilɗe me.» ");
INSERT INTO moz_vpl VALUES ("MK6_17","071_6_17","MRK","6","17","18","Erod yʼilke iŋkino kono yi-ziiɗa ere leemadí Pilip sundutú Erodiyas, wo Zaŋ Batis yi di ruute, yʼede: «Oogoro urzi ti kʼele ye kʼa seeɗa ere leemadá te.» Iŋkino maŋ Erod batum yʼan di ruute a asigiryagi an ti yʼ ziiɗo Zaŋ me, an ti yʼ gittite wo an ti yʼ ziɗɗe adda daŋgay. ");
INSERT INTO moz_vpl VALUES ("MK6_19","071_6_19","MRK","6","19","19","A rootiyo Zaŋ gette Erodiyas ti di gulkuwe tʼa ti yʼ ziiɗa addutú. Ti dehu tʼa yi tʼîde, wo ɗe urzi ti kʼooniyo ye, ");
INSERT INTO moz_vpl VALUES ("MK6_20","071_6_20","MRK","6","20","20","kono Erod geŋ yi orgiso a Zaŋ me, yi suune yoŋ wede ki diinekamilen̰, iŋkino yi di yʼ boohiyo. Aame Zaŋ yi eesiyo kazita kʼono Raa maŋ, Erod yi yʼollige tʼuŋsuwo wo munɗa yʼa roote yi ki suune ye. ");
INSERT INTO moz_vpl VALUES ("MK6_21","071_6_21","MRK","6","21","21","Ozzine ti ozzine, onniyo kʼehiyo kʼErod tʼaaniya maŋ, an dʼisiyo tarnaape. Iŋkino onniyo gette tʼiina maŋ, Erodiyas ti dʼuune urzi. Erod yʼan dʼize omɓo a ɗoŋ deero siiɗo, a deero kʼasigiryagi wo a ɗoŋ suma ki siiɗo Galile. ");
INSERT INTO moz_vpl VALUES ("MK6_22","071_6_22","MRK","6","22","22","Aame geŋ uto koŋso kʼErodiyas ti-tʼiide adda ɓoy tʼa immira, wo a tode gette Erod addí i-dʼiɓi ti ɗoŋ anʼni wiiko pây. Iŋkino maŋ mozigo yi di ruute a uto koŋso, yʼede: «Munɗa wede tuuku mi dehuʼŋ mi rooto, wo ni di tʼela.» ");
INSERT INTO moz_vpl VALUES ("MK6_23","071_6_23","MRK","6","23","23","Wo yʼa-ti nîime tuddí, yʼede: «Munɗa wede tuuku mi dehuʼŋ mi rooto, ni di tʼela, ise kese mozikadó toŋ maŋ.» ");
INSERT INTO moz_vpl VALUES ("MK6_24","071_6_24","MRK","6","24","24","Maŋ uto koŋso tʼa tʼuɗɗe ti di ruute mettú, tʼede: «Ɗe nʼa tonde moo me?» Mettú ti diʼn gime onamtú, tʼede: «Mi tondo eego Zaŋ Batis.» ");
INSERT INTO moz_vpl VALUES ("MK6_25","071_6_25","MRK","6","25","25","Kesiko uto koŋso tʼa-gime ki tukki mozigo, tʼiideʼŋ ti di ruute, tʼede: «Ni dehu aŋken̰n̰o kʼo ti ɗekki eego Zaŋ Batis, kʼo di zaapi adda supira, wo kʼo dʼadi ken̰n̰o!» ");
INSERT INTO moz_vpl VALUES ("MK6_26","071_6_26","MRK","6","26","26","Aame geŋ mozigo yʼa tʼize sommagi dondoŋ, wo ɗe kono yʼa ti nîime tuddí a ɗaana ɗoŋ anʼni wiiko geŋ, yʼa iyye yi gi di tuuge ye. ");
INSERT INTO moz_vpl VALUES ("MK6_27","071_6_27","MRK","6","27","27","A kaamiki, yi dʼigibe asugursu soo ti diine ɗoŋ boohiyadí, yi di ruute, yʼede: «Kʼodo, kʼo ti ɗekki eego Zaŋ te, wo kʼo dʼedi.» Maŋ asugursu geŋ yʼa tʼiide kʼadda daŋgay, yʼa-ɗikko eego Zaŋ te. ");
INSERT INTO moz_vpl VALUES ("MK6_28","071_6_28","MRK","6","28","28","Eego yʼa tʼumɓo adda supira, yi-dʼele a uto koŋso wo todʼ ti dʼiide a mettú. ");
INSERT INTO moz_vpl VALUES ("MK6_29","071_6_29","MRK","6","29","29","Sanalliyagi Zaŋ an illiga rabila gettiyo maŋ, aame geŋ an dʼiido, nuune an tʼumɓe, an dʼiŋgile an tʼele adda muuzo. ");
INSERT INTO moz_vpl VALUES ("MK6_30","071_6_30","MRK","6","30","30","Ɗoŋ zina kʼIsa an di-gimo ki sirpadí, an i di tʼîide taaya a naabo ere pay an izo wo a dooyiso ere pay an duuyo ɗuwo. ");
INSERT INTO moz_vpl VALUES ("MK6_31","071_6_31","MRK","6","31","31","A ume geŋ i dʼede ɗuwo ɓaadaŋ, ɗoŋ oŋgoŋ an eŋgile, ɗoŋ oŋgoŋ an ette ettiyo, wo Isa ti sanalliyagí geŋ an tʼoone peeɗo booloŋ an di-koone an dʼoomi toŋ umbo. Iŋkino maŋ yʼan di ruute, yʼede: «Kun tʼedi ti nuuno, in tʼarga siidiŋ ki balɗa kun a-puukey booloŋ.» ");
INSERT INTO moz_vpl VALUES ("MK6_32","071_6_32","MRK","6","32","32","Maŋ an di gili adda tooko, an di diipiɗa bar kono an tʼarga siidaŋ kʼadda balɗa. ");
INSERT INTO moz_vpl VALUES ("MK6_33","071_6_33","MRK","6","33","33","A eŋgilsadaŋ geŋ ɗoŋ ɓaadaŋ an diʼn wulle wo an diʼn zuune. Iŋkino maŋ ɗoŋ tʼadda geegiryagi pay geŋ an dʼiise okkito ti zoŋɗaŋ, an tʼiide geere sey kʼume Isa ti sanalliyagí anʼte geŋ me. ");
INSERT INTO moz_vpl VALUES ("MK6_34","071_6_34","MRK","6","34","34","Isa yi ti ɗiige ti tooko maŋ, yi wolliyo ɗoŋ duuru ɓaadaŋ, wo i di tʼize sommagi kono kane geŋ aakede damɓami daa wede kʼelsadaŋ. Iŋkino maŋ yʼan diʼn iise dooyiso a sulɗi ɓaadaŋ. ");
INSERT INTO moz_vpl VALUES ("MK6_35","071_6_35","MRK","6","35","35","Kane sanalliyagí an wolliyo peeɗo tʼiŋgile, maŋ an a dʼiide sirpa kʼIsa, an i di ruute, anʼde: «Kʼollo, ume eŋ balɗa wo peeɗo toŋ tʼiŋgile. ");
INSERT INTO moz_vpl VALUES ("MK6_36","071_6_36","MRK","6","36","36","Iŋkino maŋ ɗuwo eŋ kʼan eezo an tʼette ki ɓoyɗi ɗoŋ doome wo kʼadda kʼilliyagi ɗoŋ goppoŋ, an dʼowiltey munɗa kʼomɓo.» ");
INSERT INTO moz_vpl VALUES ("MK6_37","071_6_37","MRK","6","37","37","Wo Isa yʼan di ruute, yʼede: «Omɓo an eelo kune batum.» Kane an di ruute, anʼde: «Kee ki dehu ay tʼoono tamma meeda sire, ay tʼowilo mappa pay ay an tʼela a ɗoŋ duuru an dʼooma ko?» ");
INSERT INTO moz_vpl VALUES ("MK6_38","071_6_38","MRK","6","38","38","Isa yʼan diʼn tunde, yʼede: «Un dʼede mappa miibi me, kʼun ki ti wolli ɗo a eesaguŋ me?» An ti wullo maŋ, an di ruute, anʼde: «Kaye ay dʼede miŋ mappa paat wo puuni sire.» ");
INSERT INTO moz_vpl VALUES ("MK6_39","071_6_39","MRK","6","39","39","Maŋ Isa yʼan di ruute a sanalliyagí, yʼede: «Ɗuwo kun tiʼn koona kaŋ ogiysito adda soole.» ");
INSERT INTO moz_vpl VALUES ("MK6_40","071_6_40","MRK","6","40","40","Maŋ ɗuwo an di gunɗite, oŋgoŋ meeda, oŋgoŋ ada paat. ");
INSERT INTO moz_vpl VALUES ("MK6_41","071_6_41","MRK","6","41","41","Aame geŋ Isa yʼa-ziki mappa paat ti puuni sire gen̰n̰o, yʼa tʼumɓe edayí kʼawwa ki kandaane, yʼa ruute koɗuwo a Raa. Maŋ mappa yʼa ɓurkite, yʼan dʼele a sanalliyagí kono an an di-dokkiɗa a ɗoŋ duuru gen̰n̰o. Puuni toŋ iŋkino kay yʼan di-dikkiɗa a ɗuwo pay. ");
INSERT INTO moz_vpl VALUES ("MK6_42","071_6_42","MRK","6","42","42","Kane pay geŋ an dʼiimi wo an dʼisse. ");
INSERT INTO moz_vpl VALUES ("MK6_43","071_6_43","MRK","6","43","43","Wo mappa ti puuni ɗoŋ uupite, sanalliyagi an ti-tusse, a îide dappa koomat makumu sire. ");
INSERT INTO moz_vpl VALUES ("MK6_44","071_6_44","MRK","6","44","44","Kane ɗoŋ iimi mappa geŋ, an tʼîde kuuli dupu paat. ");
INSERT INTO moz_vpl VALUES ("MK6_45","071_6_45","MRK","6","45","45","Saŋ maŋ kesiko Isa yʼan di ruute a sanalliyagí, an di kili adda tooko an dʼoogume, an di doopiɗa ti dar bar ti nee, ki kese geeger Betsayda, koore yode batum ɗoŋ duuru yi-tiʼn tʼigiba geŋ me. ");
INSERT INTO moz_vpl VALUES ("MK6_46","071_6_46","MRK","6","46","46","Aame ɗoŋ duuru yi tiʼn igibe maŋ, yoŋ yʼa-ti gili ekki kesse kono yʼa tonde Raa. ");
INSERT INTO moz_vpl VALUES ("MK6_47","071_6_47","MRK","6","47","47","Ume yʼize diɗɗo geŋ, tooko todʼte a diine kʼahu dokki ɓotto ti biza bar me, wo Isa siidí ti zeŋge tʼinno me. ");
INSERT INTO moz_vpl VALUES ("MK6_48","071_6_48","MRK","6","48","48","Isa yi wolliyo kane sanalliyagí an tʼize oon̰e ki korre kʼahu me, kono maaye a giggiraŋ. Iŋkino a diɗɗo biza soohe maŋ yi-tʼuɗɗo yi dʼettiyo tuddaŋ, yi sooru tʼekkʼahu aa yʼan diʼn eŋgile. ");
INSERT INTO moz_vpl VALUES ("MK6_49","071_6_49","MRK","6","49","49","Aame kane an yi wulle yi sooru tʼekkʼahu geŋ, an elkiyo beyye ɗaŋ, wo an dʼiise ɗollite ");
INSERT INTO moz_vpl VALUES ("MK6_50","071_6_50","MRK","6","50","50","kono kane pay geŋ an yi wulle wo orgiso tʼanni ziiɗa ɓaadaŋ. Kesiko Isa yʼan di ruute, yʼede: «Kun omɓon̰! Kun orgiɗe ye, eŋ nuuno!» ");
INSERT INTO moz_vpl VALUES ("MK6_51","071_6_51","MRK","6","51","51","Maŋ yʼa di gili ti kane adda tooko, aame geŋ maaye yʼa ziiɗa. Iŋkino maŋ kane sanalliyagi undaŋ a tʼuɗɗe. ");
INSERT INTO moz_vpl VALUES ("MK6_52","071_6_52","MRK","6","52","52","Ɗerec, armika ere yʼize tʼurzi mappa gette itatú an ki ti zuune ye, eedaŋ ti kʼaane ti kiʼn seeɗa ye sulɗi geŋ me. ");
INSERT INTO moz_vpl VALUES ("MK6_53","071_6_53","MRK","6","53","53","An ti diipiɗa bar maŋ, an dʼiiney a siiɗo Zenezaret, tooko an di gitte a zeŋge wo an di ɗiggite. ");
INSERT INTO moz_vpl VALUES ("MK6_54","071_6_54","MRK","6","54","54","Aame an ɗeggutu geŋ, a kaamiki Isa ɗuwo an di yʼ zuune. ");
INSERT INTO moz_vpl VALUES ("MK6_55","071_6_55","MRK","6","55","55","Maŋ an dʼiise okkito tʼadda siiɗo gette pay. Aame an yʼollige yoŋ kʼume tuuku maŋ, ɗoŋ kʼeeni an di sokiyo ti zaaɗagi, an i-dʼettiyo kiŋgen̰n̰o gen̰n̰o. ");
INSERT INTO moz_vpl VALUES ("MK6_56","071_6_56","MRK","6","56","56","A ume wede tuuku Isa yʼettiyo kʼadda kʼilliyagi, ki geegiryagi, ise ki ɓoyɗi ɗoŋ doome geŋ, ɗoŋ kʼeeni an an dʼan tʼettiyo a bere ɗoŋ duuru. Maŋ kane ɗuwo geŋ an i dʼoɓe bey kono ɗoŋ kʼeeni an a-botte a bize kallayí ɗaŋŋal toŋ maŋ, wo kane ɗoŋ pay a bottiyo geŋ an dʼuttiyo. ");
INSERT INTO moz_vpl VALUES ("MK7_1","071_7_1","MRK","7","1","1","Kane Pariziyeŋ ti ɗoŋ miibi ti diine ɗoŋ suuniyo kʼoogoro iido ti Zeruzalem geŋ, an di-tʼugiye a Isa. ");
INSERT INTO moz_vpl VALUES ("MK7_2","071_7_2","MRK","7","2","2","An wolliyo maŋ kane sanalliyagí oŋgo an omɓo beezaŋ ganigi a ɗaana Raa me, geŋ i-kaza ki poone an tʼeese omɓo, beyɗaŋ an ki tʼopilso ye aa moŋgiɗagaŋ an ruute me. ");
INSERT INTO moz_vpl VALUES ("MK7_3","071_7_3","MRK","7","3","3","Ɗerec, kane Pariziyeŋ ti Yawudiyagi pay geŋ an kʼomɓo ye beyɗaŋ daa kʼopilso koɗuwo ye maŋ, kono an aa seeɗu zakiɗi a dooyiso ere ki moŋgiɗagaŋ an duuye te. ");
INSERT INTO moz_vpl VALUES ("MK7_4","071_7_4","MRK","7","4","4","Aame an aahiya suuk toŋ, an kʼomɓo ye daa kʼopilso tuddaŋ me. Wo an aa seeɗu a dooyiso ɓaadaŋ ti doolo toŋ ede ere moŋgiɗagaŋ an duuye te, aakede: opilsito kuŋzali, diŋgilagi wo keyyagi maala. ");
INSERT INTO moz_vpl VALUES ("MK7_5","071_7_5","MRK","7","5","5","Iŋkino maŋ kane Pariziyeŋ ti ɗoŋ suuniyo kʼoogoro an di tunde Isa, anʼde: «Ki moo me sanalliyagá an dʼomɓo beyɗaŋ ganigi a ɗaana Raa, wo ɗe an ki daaniya ye dooyiso ere ki moŋgiɗagiŋ an duuye te?» ");
INSERT INTO moz_vpl VALUES ("MK7_6","071_7_6","MRK","7","6","6","Maŋ Isa yʼan diʼn gime onamaŋ, yʼede: «Kune ɗoŋ biziguŋ sire sire, nebi Ezayi yi ruute ono ɗoŋ Raa yʼigibo a tukki kune geŋ ɗerec, aa an riiŋe ti kaaga adda mattup ki Raa, anʼde: “Ɗuwo eŋ an o eliyo suma tʼono bizaŋ, wo ɗe ki kotto adda kʼaddaŋ kane dokki ti nuŋ Raa me. ");
INSERT INTO moz_vpl VALUES ("MK7_7","071_7_7","MRK","7","7","7","Kane sulɗi ɗoŋ an isiyo kono an o ottilso geŋ ki bita, kono urziyagi kʼoogoro ɗoŋ an dooyiso geŋ ettiyo tʼurzi ɗuwo ɗaŋŋal.”» ");
INSERT INTO moz_vpl VALUES ("MK7_8","071_7_8","MRK","7","8","8","Maŋ Isa yʼan di ruute, yʼede: «Oogoro Raa kun dʼooliyo kese, wo kun tʼamɓu dooyiso ɗuwo.» ");
INSERT INTO moz_vpl VALUES ("MK7_9","071_7_9","MRK","7","9","9","Wo yʼan di ruute sey, yʼede: «Kune kon̰aguŋ kʼooliyo kʼurziyagi kʼoogoro Raa ki kese, wo kun di sooru a urzi dooyisaguŋ. ");
INSERT INTO moz_vpl VALUES ("MK7_10","071_7_10","MRK","7","10","10","Ɗerec, Muusa yi ruute ti kaaga, yʼede: “Ki elo suma a meegá ti meedá.” Wo soŋ yʼede: “Wede yi duuɗiyo meegí ise meedí koo maŋ, yoŋ geŋ ki tôwwo.” ");
INSERT INTO moz_vpl VALUES ("MK7_11","071_7_11","MRK","7","11","11","Wo ɗe kuneʼŋ, kun dooyiso ɗuwo, kunʼde: “Aame wede yi rootiyo a meegí ise a meedí, yʼede: Munɗa wede nʼa-di tʼele a gi di nooge yoŋ korbaŋ, i-kaza yoŋ ni ele seɗeke a Raa” maŋ, ");
INSERT INTO moz_vpl VALUES ("MK7_12","071_7_12","MRK","7","12","12","geŋ kun eliyo urzi a wedusu yi ki tʼele munɗa a meegí ise meedí ye. ");
INSERT INTO moz_vpl VALUES ("MK7_13","071_7_13","MRK","7","13","13","Kun isiyo iŋkino geŋ, kun ti tôwwo ono ɗoŋ Raa yi ruute kun dʼise me, wo kun di sooru a urzi dooyisaguŋ. Wo sulɗi ɓaadaŋ ti doolo toŋ ede kun isiyo iŋkino me.» ");
INSERT INTO moz_vpl VALUES ("MK7_14","071_7_14","MRK","7","14","14","Saŋ Isa yʼa wiike ɗoŋ duuru sey an tʼiide kʼume yode, wo yʼan di ruute, yʼede: «Kune pay kun ollo, wo ono eŋ itadaŋ kun diʼn suuno: ");
INSERT INTO moz_vpl VALUES ("MK7_15","071_7_15","MRK","7","15","15","Sulɗi ɗoŋ pay wedusu yʼoomi geŋ, i ki yʼise ganigi ye a ɗaana Raa me, ki too maŋ i yʼise ganigi a ɗaana Raa munɗa wede aɗɗiya ti bizí gen̰n̰o.  ");
INSERT INTO moz_vpl VALUES ("MK7_16","071_7_16","MRK","7","16","16","Wede i-dʼede kuwwa kʼollige maŋ, yʼollo koɗuwo.» ");
INSERT INTO moz_vpl VALUES ("MK7_17","071_7_17","MRK","7","17","17","Aame ɗoŋ duuru Isa yiʼn iili yʼaahe ɓoy maŋ, kane sanalliyagí an di yi tunde, anʼde: «Kee kʼay tʼooɗibi ita a ono ombiɗe eŋ me.» ");
INSERT INTO moz_vpl VALUES ("MK7_18","071_7_18","MRK","7","18","18","Yoŋ yʼan di ruute, yʼede: «Iŋkino maŋ ki kotto, kune toŋ onamó egguŋ ti kʼaane ti kiʼn seeɗa ye pi me! Kun ki suune ye ko, sulɗi ɗoŋ pay wedusu yʼoomi geŋ i ki yʼise ganigi ye a ɗaana Raa me? ");
INSERT INTO moz_vpl VALUES ("MK7_19","071_7_19","MRK","7","19","19","Kono sulɗi ɗoŋ wede yʼoomi geŋ, i-ki ti ɗeegu adda biza kʼulbí ye, wo ɗe i-ti ɗeegu adda kʼaddí, wo saŋ yi-tiʼn naamiya.» A onamí geŋ, Isa yi rootiyo omɓo pay kamilen̰ a ɗaana Raa me. ");
INSERT INTO moz_vpl VALUES ("MK7_20","071_7_20","MRK","7","20","20","Yoŋ yʼa ruute sey, yʼede: «I ti yʼisiyo wedusu ganigi a ɗaana Raa munɗa wede aɗɗiya tʼadda biza kʼulbe. ");
INSERT INTO moz_vpl VALUES ("MK7_21","071_7_21","MRK","7","21","21","Ɗerec, tʼadda kʼadde wede geŋ, ti biza kʼulbí i dʼaɗɗiya elkiso ere olɗo i-ti yʼeliyo a sulɗi ɗoŋ ulpi aakede: boliyo, oogire, tôwwo ɗuwo mirsi, ");
INSERT INTO moz_vpl VALUES ("MK7_22","071_7_22","MRK","7","22","22","moone tʼere bakadí ise ti kule bakatú, okkiso a sulɗi pay, bundiko, daggiya ɗuwo ti metiŋko, eliyo tudde kʼisiyo sulɗi ɗoŋ ulpi, zaapu kʼadde a munɗa wede, kalɗita tudde, koliyo tudde wo isiyo munɗa daa kʼelkiso. ");
INSERT INTO moz_vpl VALUES ("MK7_23","071_7_23","MRK","7","23","23","Sulɗi ɗoŋ ulpi pay geŋ aɗɗiya tʼadda kʼadde, wo an di yʼisiyo wedusu ganigi a ɗaana Raa me.» ");
INSERT INTO moz_vpl VALUES ("MK7_24","071_7_24","MRK","7","24","24","Saŋ maŋ tiŋ geŋ Isa yʼa tʼiiziga, yʼa iŋgile ki siiɗo ere i ɗuule geeger Tir. Yi-tʼiide adda ɓoy soo iŋkino, kono yi dehu wenɗa yʼa ki suune umayí ye, miŋ umbo yʼa kʼiine ombiɗe ye. ");
INSERT INTO moz_vpl VALUES ("MK7_25","071_7_25","MRK","7","25","26","A ume geŋ, i dʼede erewo ti Pinisi siiɗo Siiri. Todʼte Yawudowo ye, tʼorbe ono Girek, ututú i-dʼede siitan a ettú. Tʼilliga rabila kʼIsa maŋ, kesiko tʼa ukke kʼume yode. Tʼiideʼŋ tʼa dikke a ɗaanadí, wo tʼa yi tunde, tʼede: «Galmeega, ni ki tondiyo ki-tʼolmu siitan ti tukkʼuto nuŋ.» ");
INSERT INTO moz_vpl VALUES ("MK7_27","071_7_27","MRK","7","27","27","Isa yi di ruute, yʼede: «Mʼoolo in̰n̰i an tʼoomo an asso ɗo, kono iŋkino beehiye ye kʼa tʼamɓe omɓo kʼin̰n̰i kʼan di tʼele a gahiti me.» ");
INSERT INTO moz_vpl VALUES ("MK7_28","071_7_28","MRK","7","28","28","Maŋ to ere gette ti diʼn gime onamí, tʼede: «Galmeega onamá geŋ ɗerec, wo ki kotto gahiti gen̰n̰o toŋ an di delliyo a ume kʼomɓo, omɓo ere i solɗite ti bey kʼin̰n̰i aame an omɓo geŋ, an di pettiyo.» ");
INSERT INTO moz_vpl VALUES ("MK7_29","071_7_29","MRK","7","29","29","Yoŋ yi di ruute, yʼede: «A tukkʼonamí geŋ, mi-kama ɓoozí, siitan ti tʼuɗɗe ti tukkʼutí te.» ");
INSERT INTO moz_vpl VALUES ("MK7_30","071_7_30","MRK","7","30","30","Saŋ erewo gette tʼaahe, maŋ ti-tʼuuney uto ekkʼoŋgali ti moone, siitan ti tʼuɗɗe ti tuddutú me. ");
INSERT INTO moz_vpl VALUES ("MK7_31","071_7_31","MRK","7","31","31","Saŋ maŋ ti siiɗo ere i ɗuule geeger Tir gette Isa yʼa iŋgile, yi-tʼuɗɗe ti siiɗo ere i ɗuule geeger Sidoŋ, yʼa tûukey siiɗo sundutú Geegiryagi Koomat, yʼa-gime biza bar ki Galile. ");
INSERT INTO moz_vpl VALUES ("MK7_32","071_7_32","MRK","7","32","32","Aame geŋ ɗuwo an di wiiko wede dugiya wo ilzí toŋ attiɗi ki rootiyo me. Maŋ an i-dʼoɓe bey a Isa, anʼde: «Ki ti zaapo beezá a wede en̰n̰o, yʼa tʼoone bee.» ");
INSERT INTO moz_vpl VALUES ("MK7_33","071_7_33","MRK","7","33","33","Isa yʼa yʼirga siidí ti diine ɗoŋ duuru me, maŋ yi-tʼele ƴelagí adda kuwwa wede gen̰n̰o, wo yi dʼuŋke leezí yi tʼeele ilzí. ");
INSERT INTO moz_vpl VALUES ("MK7_34","071_7_34","MRK","7","34","34","Saŋ yʼa tʼumɓe edayí kʼawwa ki kandaane, wo yʼa zuupe suup, maŋ yi di ruute wede dugiya geŋ, yʼede: «Eppata!» Geŋ i-kaza a-tʼohon keren̰. ");
INSERT INTO moz_vpl VALUES ("MK7_35","071_7_35","MRK","7","35","35","A kaamiki wede kuwwagí a tʼihina, yi dʼollige keren̰ wo ilzí toŋ a tʼikkima, yi dʼorbe koɗuwo. ");
INSERT INTO moz_vpl VALUES ("MK7_36","071_7_36","MRK","7","36","36","A ɗuwo geŋ Isa yʼan di ruute, yʼede: «Kun ollo koɗuwo, a munɗa wede ize eŋ a wenɗa soo toŋ kun i roota ye!» Wo ɗe eŋ yʼan aapuɗu a wenɗa kun i roota ye, wo a kane aa yʼan eliyo oln̰o ki rootiyto. ");
INSERT INTO moz_vpl VALUES ("MK7_37","071_7_37","MRK","7","37","37","Kane ɗuwo geŋ an di ziiɗa giggiraŋ, wo an di ruute, anʼde: «Naabadí pay yʼisiyo ette beehiye ɓaadaŋ! Duŋgiyagi kuwwagaŋ yʼan diʼn ohinte, wo ɗoŋ bizaŋ a tʼippe ki rootiyo umbo toŋ an dʼorbe.» ");
INSERT INTO moz_vpl VALUES ("MK8_1","071_8_1","MRK","8","1","1","Aame geŋ ɗoŋ duuru ɓaadaŋ an tʼugiye sey wo munɗa an dʼoomi umbo, iŋkino maŋ Isa yʼa wiike sanalliyagí wo yʼan di ruute, yʼede: ");
INSERT INTO moz_vpl VALUES ("MK8_2","071_8_2","MRK","8","2","2","«Nuŋ ɗuwo eŋ o tʼize sommagi kono kun wollo an lekkiyo ti nuŋ îide onniyo aɗo, wo aŋken̰n̰o munɗa kʼomɓo an kʼede ye. ");
INSERT INTO moz_vpl VALUES ("MK8_3","071_8_3","MRK","8","3","3","Wo niʼn igiba addaŋ guguba maŋ, an dʼoopey a urzi kono ɗoŋ ɓaadaŋ ti diinayaŋ an iido ti dokki.» ");
INSERT INTO moz_vpl VALUES ("MK8_4","071_8_4","MRK","8","4","4","Kane sanalliyagí an i di ruute, anʼde: «Ɗe adda balɗa ette, ti too me in tʼoona mappa ɓaadaŋ a ɗuwo eŋ an dʼooma an tʼassa me?» ");
INSERT INTO moz_vpl VALUES ("MK8_5","071_8_5","MRK","8","5","5","Isa yʼan diʼn tunde, yʼede: «Kune un dʼede mappa miibi me?» Wo kane an i di ruute, anʼde: «Ay dʼede mappa sarat.» ");
INSERT INTO moz_vpl VALUES ("MK8_6","071_8_6","MRK","8","6","6","Iŋkino yʼan di ruute a ɗoŋ duuru geŋ, yʼede: «Kun ti koona siiɗo!» Maŋ yʼa ziki mappa sarat geŋ a beezí, yʼa ruute koɗuwo a Raa, yʼa ɓurkite wo yʼan dʼele a sanalliyagí kono an an di-dokkiɗa a ɗoŋ duuru gen̰n̰o. ");
INSERT INTO moz_vpl VALUES ("MK8_7","071_8_7","MRK","8","7","7","Wo soŋ an dʼede puuni miibi sun̰n̰i sun̰n̰i iŋkino. Isa yʼa ruute koɗuwo a Raa kono kʼomɓo gette wo a sanalliyagí, yʼede: «Puuni kun an ti dokko pây!» ");
INSERT INTO moz_vpl VALUES ("MK8_8","071_8_8","MRK","8","8","8","Wede tuuku toŋ yʼa iimi yʼa isse isse a dʼuupite, wo omɓo ere uupite gette, an ti tussite a dambayi deero sarat. ");
INSERT INTO moz_vpl VALUES ("MK8_9","071_8_9","MRK","8","9","9","Kane ɗoŋ iimi geŋ i tʼîde suma dupu piɗe. Saŋ Isa yʼan igibe. ");
INSERT INTO moz_vpl VALUES ("MK8_10","071_8_10","MRK","8","10","10","Wo yoŋ kesiko yi-ti gili adda tooko ti sanalliyagí, an dʼiŋgile ki siiɗo Dalmanuta. ");
INSERT INTO moz_vpl VALUES ("MK8_11","071_8_11","MRK","8","11","11","Kane Pariziyeŋ an dʼiide kʼume kʼIsa, an dʼiise niikiyto kono an dehu an i dʼekke ikka tʼurzi kʼonamí. Iŋkino maŋ an di yʼ tunde yʼan dʼise munɗa kʼarmika a kize yoŋ Raa yi yʼigibo. ");
INSERT INTO moz_vpl VALUES ("MK8_12","071_8_12","MRK","8","12","12","Isa yʼa zuupe suup, wo yʼa ruute, yʼede: «Ki moo me kane ɗoŋ aŋken̰n̰o eŋ an tondiyo munɗa kʼarmika a kize nuŋ Raa yi nʼigibo? Ɗerec iŋkino wo nʼun di rooto: Munɗa kʼarmika soo toŋ Raa yʼan kʼisa ye a kane ɗoŋ aŋken̰n̰o eŋ me.» ");
INSERT INTO moz_vpl VALUES ("MK8_13","071_8_13","MRK","8","13","13","Saŋ kane Pariziyeŋ Isa yiʼn iili, yi-ti gili adda tooko, yʼa-doopiɗa ti dar bar Galile ti nee. ");
INSERT INTO moz_vpl VALUES ("MK8_14","071_8_14","MRK","8","14","14","Kane sanalliyagi an doopiɗe ti kese bar Galile ti nee geŋ, an dunɗo an dʼamɓo mappa me, wo adda tooko i dʼede mappa soo ɗaŋŋal a beezaŋ. ");
INSERT INTO moz_vpl VALUES ("MK8_15","071_8_15","MRK","8","15","15","Aame geŋ Isa yʼan di ruute, yʼede: «Kun ollo, kun koona mentikagi a orme wede ki Pariziyeŋ wo a orme wede ki Erod.» ");
INSERT INTO moz_vpl VALUES ("MK8_16","071_8_16","MRK","8","16","16","Maŋ kane sanalliyagi an dʼiise rootiyto ti tuddaŋ kono an kʼumɓo mappa ye. ");
INSERT INTO moz_vpl VALUES ("MK8_17","071_8_17","MRK","8","17","17","Wo yo Isa rootiyadaŋ gette yʼa ti zuune, iŋkino maŋ yʼanni tunde, yʼede: «Ki moo me kun di rootiyto ti tudduguŋ, kun kʼumɓo mappa ye me? Ki kotto kune sulɗi ɗoŋ ize geŋ itadaŋ kun ki ti ziiɗa wo kun kiʼn zuune ye ɓotto. Kuneʼŋ egguŋ a tʼippe ko? ");
INSERT INTO moz_vpl VALUES ("MK8_18","071_8_18","MRK","8","18","18","Ki kotto kune un dʼede eda, wo kun ki wolliyo ye! Kune un dʼede kuwwa, wo kun kʼollige ye! Kune un dunɗe baa ");
INSERT INTO moz_vpl VALUES ("MK8_19","071_8_19","MRK","8","19","19","a mappa paat wede nʼa-dimɓe ɗoŋ dupu paat ga iimi geŋ, wo a onniyo gette oopiyo ki mappa kun dʼûune dambayi miibi kun zikiti me?» Kane an i diʼn gime onamí, anʼde: «Dambayi koomat makumu sire.» ");
INSERT INTO moz_vpl VALUES ("MK8_20","071_8_20","MRK","8","20","20","Isa yʼa ruute sey, yʼede: «Wo ɗe un dunɗe baa a mappa sarat wede nʼa ɓurkite a kuuli dupu piɗe ga iimi geŋ, wo a onniyo gette oopiyo ki mappa kun dʼûune dambayi deero miibi kun zikiti me?» Kane an i diʼn gime onamí, anʼde: «Dambayi deero sarat.» ");
INSERT INTO moz_vpl VALUES ("MK8_21","071_8_21","MRK","8","21","21","Iŋkino maŋ yʼan di ruute, yʼede: «Ki kotto sulɗi ɗoŋ nʼize geŋ itadaŋ kun ki ti zuune ye ɓotto!» ");
INSERT INTO moz_vpl VALUES ("MK8_22","071_8_22","MRK","8","22","22","Isa ti sanalliyagí an iiney Betsayda maŋ, ɗuwo an dʼirkiɗo wede koosiyo an i-dʼiido a Isa, an i-dʼoɓe bey, anʼde: «Galmeega wede eŋ ki zaapo beezá, yʼa tʼoone bee.» ");
INSERT INTO moz_vpl VALUES ("MK8_23","071_8_23","MRK","8","23","23","Isa yi ziiɗa bey wede gen̰n̰o, yʼa yʼirkiɗe dokki tʼille. Yʼiideʼŋ yi dʼuŋkite lee a edayí, wo yʼa-ti ziipe beezí a tuddí, maŋ yʼa yi tunde, yʼede: «Munɗa ki wolliyo ko?» ");
INSERT INTO moz_vpl VALUES ("MK8_24","071_8_24","MRK","8","24","24","Wede yʼa ihina edayí wo yʼa ruute, yʼede: «Eyye, ɗuwo niʼni wolliyo, wo niʼni wolliyo aa inda i sooru.» ");
INSERT INTO moz_vpl VALUES ("MK8_25","071_8_25","MRK","8","25","25","Isa yʼa butte beezí a edayí sey. Maŋ wede edayí a tʼihina yi wolliyo keren̰. ");
INSERT INTO moz_vpl VALUES ("MK8_26","071_8_26","MRK","8","26","26","Iŋkino maŋ Isa yʼa yʼigibe wede ki ɓoozí, wo yi di ruute, yʼede: «Kʼaaho ɓoozá, kʼadda kʼille kʼaɗɗey ye.» ");
INSERT INTO moz_vpl VALUES ("MK8_27","071_8_27","MRK","8","27","27","Isa ti sanalliyagí an dʼiŋgile kʼilliyagi goppoŋ ti geeger Sezare siiɗo Pilip. A urzi maŋ sanalliyagí yʼanni tunde, yʼede: «Ɗuwo an rootiyo nuŋ wee wee?» ");
INSERT INTO moz_vpl VALUES ("MK8_28","071_8_28","MRK","8","28","28","Kane an i diʼn gime onamí, anʼde: «Ɗoŋ soŋ anʼde kee Zaŋ Batis, ɗoŋ oŋgo anʼde kee nebi Eli, wo ɗoŋ oŋgo soŋ anʼde kee nebi ti diine nebiyagi ɗoŋ ti kaaga.» ");
INSERT INTO moz_vpl VALUES ("MK8_29","071_8_29","MRK","8","29","29","Maŋ Isa yʼanni tunde, yʼede: «Ɗe kune me, kunʼde nuŋ wee wee?» Piyer yʼa tʼihina bizí, yʼa ruute, yʼede: «Kee Almasi Raa yi biire.» ");
INSERT INTO moz_vpl VALUES ("MK8_30","071_8_30","MRK","8","30","30","Iŋkino maŋ Isa yʼan diʼn iipiɗe, kono a wenɗa soo toŋ an i roota munɗa ye a tukki yode me. ");
INSERT INTO moz_vpl VALUES ("MK8_31","071_8_31","MRK","8","31","31","Saŋ maŋ, Isa yʼa iise dooyiso sanalliyagí, yʼede: «Nuŋ wede an nʼehe aa ulo wede eŋ, nʼa dabirey ɓaadaŋ. Kane ɗoŋ i dokkiyo ɗoŋziŋ, deero ɗoŋ seɗeke ti ɗoŋ suuniyo kʼoogoro pây an di nʼ kiigirey. Ɗuwo an di nʼ tʼîdey, wo onniyo sire kʼaɗuwe maŋ Raa yʼa ti nʼ balɗey.» ");
INSERT INTO moz_vpl VALUES ("MK8_32","071_8_32","MRK","8","32","32","Isa yʼan di ruute pataŋ, maŋ Piyer yʼa yʼirga siidí, yʼa yʼiise aapuɗu. ");
INSERT INTO moz_vpl VALUES ("MK8_33","071_8_33","MRK","8","33","33","Aame geŋ Isa yʼa-gime, edayí yi wolliyo sanalliyagí, wo yʼa iise aapuɗu Piyer, yʼede: «Kee Meeda siitanɗani tʼa-tʼûune adda kʼaddá, ki leɗɗo dokki ti tuddó me! Elkisadá ti ere ki Raa soo ye, elkisadá ki ɗoŋ tudde.» ");
INSERT INTO moz_vpl VALUES ("MK8_34","071_8_34","MRK","8","34","34","Saŋ maŋ Isa yʼa wiike ɗoŋ duuru ti sanalliyagí, wo yʼan di ruute, yʼede: «Wede yi dehu yʼa daane urzi nuuno maŋ, tuddí batum yʼa ti kiigira, ki unto toŋ yʼa oyye yʼa tʼinda kono nuuno, wo yʼa ni daane. ");
INSERT INTO moz_vpl VALUES ("MK8_35","071_8_35","MRK","8","35","35","Iŋkino wede tuuku yi dehu boohiyo tuddí kʼaggadí maŋ, yʼa ti dagga, wo ɗe wede tuuku yʼooliyo tuddí kono nuuno wo ki Rabila Majjaanawa maŋ, yʼa tʼutta. ");
INSERT INTO moz_vpl VALUES ("MK8_36","071_8_36","MRK","8","36","36","A wede koɗuwatú moo me sulɗi duniya pay yʼanni tʼoone, wo tuddí yʼa ti dagge me? ");
INSERT INTO moz_vpl VALUES ("MK8_37","071_8_37","MRK","8","37","37","Wo ki kotto wede geŋ tuddí zooyatú oon̰e, geŋ yi kʼaane yʼa ki tʼele munɗa yʼa ki pelke tuddí ye! ");
INSERT INTO moz_vpl VALUES ("MK8_38","071_8_38","MRK","8","38","38","Aame wede yʼisiyo sukiyagi a nuŋ wo a onamó a ɗaana ɗoŋ aŋken̰n̰o, kane ɗoŋ kʼolɗiko wo an ki seeɗu urzi Raa ye maŋ, nuŋ wede an nʼehe aa ulo wede eŋ, aame nʼetto ti darƴika ere ki Meegó wo ti ere ki maaleekiyagi ɗoŋ kamilen̰ geŋ, nuŋ toŋ ni-dʼisa sukiyagi kay a yoŋ me.» ");
INSERT INTO moz_vpl VALUES ("MK9_1","071_9_1","MRK","9","1","1","Isa yʼan di ruute sey, yʼede: «Ɗerec iŋkino wo nʼun di rooto: Ɗoŋ oŋgoŋ ti diine kane ɗoŋ aŋken̰n̰o eŋ an ki ti tʼinda ki poone pay ye, an di wolla Moziko Raa tʼetto ti toogo ɓaadaŋ gette.» ");
INSERT INTO moz_vpl VALUES ("MK9_2","071_9_2","MRK","9","2","2","Îide onniyo zoot kʼita maŋ, Isa yʼa-wiike ti yode Piyer, Zak wo Zaŋ, yʼan dʼan dʼiŋgile siidaŋ kʼekki mokkolo sohoro. An iiney maŋ, a ɗaanadaŋ geŋ miŋ tuddí a-gime sittú, ");
INSERT INTO moz_vpl VALUES ("MK9_3","071_9_3","MRK","9","3","3","iŋkino kallagí a tʼize tuwarɗi kar i ralita, adda siiɗo pay ette wede a aane a-tʼopile kallayí a tʼise tuware aa ki yode umbo. ");
INSERT INTO moz_vpl VALUES ("MK9_4","071_9_4","MRK","9","4","4","A kaamiki, kane sanalliyagi aɗo geŋ an wolliyo bibiraw nebi Eli ti Muusa an rootiyto tʼIsa. ");
INSERT INTO moz_vpl VALUES ("MK9_5","071_9_5","MRK","9","5","5","Iŋkino maŋ Piyer yʼa tʼihina bizí, yi di ruute Isa, yʼede: «Wede dooyisadey, beehiyeʼŋ kine in di lekke a en̰n̰o! Ay un dʼokkima daabagi aɗo, a kee soo, a Muusa soo, wo a Eli soo.» ");
INSERT INTO moz_vpl VALUES ("MK9_6","071_9_6","MRK","9","6","6","Piyer munɗa yʼa roote yi ki suune ye, kono kane aɗuwaŋ pay geŋ orgiso tiʼni ziiɗa ɓaadaŋ. ");
INSERT INTO moz_vpl VALUES ("MK9_7","071_9_7","MRK","9","7","7","Maŋ i dʼiido dondirso ti diʼn ippe kane geŋ me, wo tʼadda dondirso gette an dʼilliga golla, tʼede: «Eŋ ulo nuuno ni yʼ giyye ɓaadaŋ. Kun yʼollo!» ");
INSERT INTO moz_vpl VALUES ("MK9_8","071_9_8","MRK","9","8","8","A kaamiki an di gelɗiso, wo ɗe an wolliyo Isa siidí a sirpadaŋ me, wenɗa ti doolo umbo. ");
INSERT INTO moz_vpl VALUES ("MK9_9","071_9_9","MRK","9","9","9","A ɗeeguzaŋ tʼekki mokkolo, Isa yʼan di ruute, yʼede: «Kun ollo, a munɗa wede kun wulle geŋ, a wenɗa soo toŋ kun rootey ye, bini balɗiya ki nuŋ wede an nʼehe aa ulo wede eŋ ti diine ɗoŋ unto.» ");
INSERT INTO moz_vpl VALUES ("MK9_10","071_9_10","MRK","9","10","10","Onamí an dʼumɓe, wo ɗe an tondiso tuddaŋ, anʼde: «Onamí geŋ miŋ i-kaza moo me: balɗiya ti diine ɗoŋ unto me?» ");
INSERT INTO moz_vpl VALUES ("MK9_11","071_9_11","MRK","9","11","11","Saŋ maŋ kane sanalliyagi an di yʼ tunde sey, anʼde: «Ki moo me ɗoŋ suuniyo kʼoogoro an di rootiyo, anʼde: “Ki poone i kimo Eli ɗoo miŋ, saŋ Almasi Raa yi biire kollo” me?» ");
INSERT INTO moz_vpl VALUES ("MK9_12","071_9_12","MRK","9","12","12","Isa yʼan diʼn gime onamaŋ, yʼede: «Ɗerec, Eli geŋ yʼa etto ki poone, wo sulɗi pay yʼan okkima a urzizaŋ. Wo ɗe kun suune ono ɗoŋ an riiŋe ti kaaga adda mattup ki Raa, a tukki nuŋ wede an nʼehe aa ulo wede eŋ, nʼa dabira ɓaadaŋ, wo ɗuwo an di nʼ kiigira. ");
INSERT INTO moz_vpl VALUES ("MK9_13","071_9_13","MRK","9","13","13","Wo kun ollo, nʼun di rooto: Eli geŋ yoŋ yʼiina wo ɗuwo an i-dʼize ulsu aa addaŋ i dehu, geŋ a-tʼiide a ono ɗoŋ an riiŋe ti kaaga adda mattup ki Raa a tukki yode.» ");
INSERT INTO moz_vpl VALUES ("MK9_14","071_9_14","MRK","9","14","14","Aame Isa ti sanalliyagi aɗo an ti gime kʼume sanalliyagi ɗoŋ an iili maŋ, an wolliyo ɗoŋ duuru ɓaadaŋ an dʼan tʼugiye. Ti diinayaŋ i dʼede ɗoŋ suuniyo kʼoogoro an niikiyto ti kane. ");
INSERT INTO moz_vpl VALUES ("MK9_15","071_9_15","MRK","9","15","15","Kane ɗoŋ duuru an wulle Isa maŋ, aame geŋ an dʼiddira, an dʼukke tuddí an i tʼisey toose. ");
INSERT INTO moz_vpl VALUES ("MK9_16","071_9_16","MRK","9","16","16","Iŋkino maŋ Isa yʼa tunde sanalliyagi, yʼede: «A tukkʼamo kun niikiyto ti kane me?» ");
INSERT INTO moz_vpl VALUES ("MK9_17","071_9_17","MRK","9","17","17","Maŋ ti diine ɗoŋ duuru i dʼede wedusu, yi di ruute Isa, yʼede: «Wede dooyisadó, nuŋ nʼa-dʼiido ti ulo nuŋ i-dʼede siitan a eedí, bizí ti-tʼippe ki rootiyo umbo. ");
INSERT INTO moz_vpl VALUES ("MK9_18","071_9_18","MRK","9","18","18","A ume tuuku siitan ti yʼamɓu maŋ, ti di-seɗɗiyo a siiɗo, bizí i-dʼaɗɗiyta goopiyagi, yi dʼaaɗumu sinaní, wo yʼa dʼunto sen̰. Nuŋ nʼa tunde sanalliyagá kono an ti-limmi siitan gette, wo ɗe kane an ki dʼiine ye.» ");
INSERT INTO moz_vpl VALUES ("MK9_19","071_9_19","MRK","9","19","19","Maŋ Isa yʼa tʼihina bizí, yʼa ruute, yʼede: «Kune ɗoŋ kun ki ziipe adduguŋ a Raa ye. Nuŋ ti kaagine ni lekkiyo ti kune, wo ɗe a nuŋ kun ki dʼumɓe ye! Geŋ nʼa omɓin̰a ki daayum koo ti kune me? Ulo kun o dʼedi.» ");
INSERT INTO moz_vpl VALUES ("MK9_20","071_9_20","MRK","9","20","20","Maŋ ulo an i-dʼiido. Aame siitan gette ti wulle Isa maŋ, ulo geŋ tʼa ziɗɗe siiɗo yi tuŋkulso bizí goopiyagi. ");
INSERT INTO moz_vpl VALUES ("MK9_21","071_9_21","MRK","9","21","21","Isa yʼa tunde meekʼulo, yʼede: «Ulo tʼume muno i yʼiise iŋkino me?» Meega yʼa ruute, yʼede: «I yʼiise tʼume yoŋ n̰eŋku. ");
INSERT INTO moz_vpl VALUES ("MK9_22","071_9_22","MRK","9","22","22","Onniyo muno siitan gette ti-ti yʼ seɗɗiyo adda kʼuwwo ise adda kʼahu ki tôwwadí. Wo ɗe aame kee kʼaane maŋ, ki wollo sommagey, kʼokki a ɗolladey!» ");
INSERT INTO moz_vpl VALUES ("MK9_23","071_9_23","MRK","9","23","23","Isa yi di ruute, yʼede: «Ki moo me ki rootiyo, kʼede: “Kee kʼaane maŋ” me? A wede i zaapu addí geŋ, sulɗi pay a Raa i-kʼoon̰e ye, yʼaane.» ");
INSERT INTO moz_vpl VALUES ("MK9_24","071_9_24","MRK","9","24","24","A kaamiki meekʼulo yʼa iɗili, yʼede: «Nuŋ ni ziipe addó a kee, wo ɗe kʼa ni noogi kono nuŋ zaapu kʼaddó baata.» ");
INSERT INTO moz_vpl VALUES ("MK9_25","071_9_25","MRK","9","25","25","Isa yi wolliyo ɗoŋ duuru i-dihimo tuddaŋ, iŋkino maŋ yi di ruute a siitan gette ti golla zakiɗi, yʼede: «Koŋ siitan no, mi-tiʼn isiyto ɗuwo duŋgiyagi wo mʼan tʼappiyta a bohanaŋ geŋ, mʼollo ni-di rooto, mi tʼaɗɗo ti tukkʼulo me, wo mi kima ye baa!» ");
INSERT INTO moz_vpl VALUES ("MK9_26","071_9_26","MRK","9","26","26","Siitan tʼa iise ɗollite, ulo tʼa ziɗɗe siiɗo yi-zehiso bar bar, wo tʼa tʼuɗɗe. Ulo geŋ lokiƴok aa yʼinda, iŋkino ɗoŋ ɓaadaŋ a sirpa an di ruute, anʼde: «Yoŋ yʼinda.» ");
INSERT INTO moz_vpl VALUES ("MK9_27","071_9_27","MRK","9","27","27","Wo ɗe Isa yi ziiɗa beezí, yʼa yʼiiziga, maŋ ulo yʼa tʼîhira. ");
INSERT INTO moz_vpl VALUES ("MK9_28","071_9_28","MRK","9","28","28","Saŋ Isa yʼaahe ɓoy maŋ, kane sanalliyagí an di yʼ tunde siidaŋ, anʼde: «Wo ɗe ki moo me siitan gette kaye ay ki dʼiine lommatú ye me?» ");
INSERT INTO moz_vpl VALUES ("MK9_29","071_9_29","MRK","9","29","29","Maŋ Isa yʼan di ruute, yʼede: «Ita siitan ere kino ette, aɗɗiyatú tʼurzi tondiyo Raa ɗaŋŋal.» ");
INSERT INTO moz_vpl VALUES ("MK9_30","071_9_30","MRK","9","30","30","Tʼume geŋ an dʼiŋgile, an di doopiɗa ti siiɗo Galile. Isa yi ki dehu ɗuwo an ki suune umayí ye, ");
INSERT INTO moz_vpl VALUES ("MK9_31","071_9_31","MRK","9","31","31","kono yi dehu yʼa dooye sanalliyagí. Iŋkino yʼan di ruute, yʼede: «Nuŋ wede an nʼehe aa ulo wede eŋ, an di nʼ tʼeley a bey ɗuwo. Kane an di nʼ tʼîdey, wo onniyo sire kʼaɗuwe maŋ Raa yʼa ti nʼ balɗey ti diine ɗoŋ unto me.» ");
INSERT INTO moz_vpl VALUES ("MK9_32","071_9_32","MRK","9","32","32","Wo ɗe kane sanalliyagi ita kʼono geŋ an kiʼn zuune ye, wo ki tondiyadí an dʼorgiso. ");
INSERT INTO moz_vpl VALUES ("MK9_33","071_9_33","MRK","9","33","33","Isa ti sanalliyagi an dʼiiney Kapernayim. Aame geŋ an tʼiide adda ɓoy, wo Isa yʼanni tunde, yʼede: «Ɗe a urzi kun niikiyto a tukkʼa moo?» ");
INSERT INTO moz_vpl VALUES ("MK9_34","071_9_34","MRK","9","34","34","Wo ɗe kane an dʼinda kuy, kono a urzi an niikito ti tuddaŋ an dehu an di suune, ti diinayaŋ miŋ wee wee goole a jiire me. ");
INSERT INTO moz_vpl VALUES ("MK9_35","071_9_35","MRK","9","35","35","Iŋkino maŋ Isa yʼa-guune, yʼanni wiike sanalliyagi kane koomat makumu sire wo yʼan di ruute, yʼede: «Wede tuuku yi dehu yʼa tʼise ki biza maŋ, yoŋ geŋ yi tʼiso wede kʼita ti ɗoŋ pay, wo wede naabo a ɗoŋ pay.» ");
INSERT INTO moz_vpl VALUES ("MK9_36","071_9_36","MRK","9","36","36","Maŋ Isa yi wiike ulo n̰eŋku, yʼa yʼîhira a diinayaŋ, yʼa ti yʼ ziiɗa beezí wo yʼan di ruute, yʼede: ");
INSERT INTO moz_vpl VALUES ("MK9_37","071_9_37","MRK","9","37","37","«Wede tuuku yi seeɗu ulo aa yode eŋ bey sire a sundó maŋ, geŋ aa yi seeɗu nuŋ batum. Wo wede tuuku yi seeɗu nuuno maŋ, geŋ yi seeɗu nuuno ɗaŋŋal ye, wo ɗe aa yi seeɗu wede i nʼigibo pây.» ");
INSERT INTO moz_vpl VALUES ("MK9_38","071_9_38","MRK","9","38","38","Maŋ Zaŋ yi di ruute a Isa, yʼede: «Galmeegey, kaye ay di wullo wede yi lommite siitanɗani ti sundá, wo ay di dihe urzi kʼohirayí kono yoŋ ti kine ye.» ");
INSERT INTO moz_vpl VALUES ("MK9_39","071_9_39","MRK","9","39","39","Wo ɗe Isa yʼa ruute, yʼede: «Kun yʼôhira ye, kono wede yʼaase sulɗi kʼarmika ti sundó, wo a kaamiki yʼa-kime rootiyo ulsu a tukki nuŋ sey, i kʼise ye. ");
INSERT INTO moz_vpl VALUES ("MK9_40","071_9_40","MRK","9","40","40","Wede aduziŋ ye geŋ, yoŋ ki kine. ");
INSERT INTO moz_vpl VALUES ("MK9_41","071_9_41","MRK","9","41","41","Ɗerec iŋkino wo nʼun di rooto: Wede tuuku yi eela ahu ŋoyoyo a kulso ɗaŋŋal, a wede soo ti diinaguŋ a suma ki nuŋ Almasi Raa yi biire maŋ, munɗa wede Raa yi dehu yi-tʼeley geŋ, yʼa yi tʼooney.» ");
INSERT INTO moz_vpl VALUES ("MK9_42","071_9_42","MRK","9","42","42","«Wede tuuku yi tʼeliyo adda kʼolɗiko wede soo ti diine kane ɗoŋ tasse a urzi zaapu kʼadde a nuuno maŋ, a wede iŋkino geŋ, dabar ere an i di kette assa meeda a golladí an ti yʼ seɗɗe adda bar gette, soodo sey ti ere yi tʼooney a ɗaana Raa te. ");
INSERT INTO moz_vpl VALUES ("MK9_43","071_9_43","MRK","9","43","43","Aame ɗe beezá yʼa-da tʼettiyo kʼadda kʼolɗiko maŋ, kʼa-ɗekko mendí. Beehiye i jiire a kee, beezá soo wo kʼa tʼooney lekkiyo ere ki daayum bee miŋ, kʼa lekke beyɗaŋ sirwaŋ wo kʼa tʼettey kʼadda kʼuwwo ere i kʼunto ye.  ");
INSERT INTO moz_vpl VALUES ("MK9_44","071_9_44","MRK","9","44","44","A ume geŋ ɗuwo ge ruumiyo, ondirɗagi ge dʼomɓo ki daayum i ki ɗaŋgiya ye, wo uwwo tʼoggiyo ki daayum. ");
INSERT INTO moz_vpl VALUES ("MK9_45","071_9_45","MRK","9","45","45","Aame zindá tʼa-da tʼettiyo kʼadda kʼolɗiko maŋ, kʼa tʼooɗo kʼa seɗɗo dokki ti kee. Beehiye i jiire a kee zindá soo wo kʼa tʼooney lekkiyo ere ki daayum, bee miŋ kʼa lekke zoŋɗá sirwaŋ wo an ki ti seɗɗey adda kʼuwwo.  ");
INSERT INTO moz_vpl VALUES ("MK9_46","071_9_46","MRK","9","46","46","A ume geŋ ɗuwo ge ruumiyo, ondirɗagi ge dʼomɓo ki daayum i ki ɗaŋgiya ye, wo uwwo tʼoggiyo ki daayum. ");
INSERT INTO moz_vpl VALUES ("MK9_47","071_9_47","MRK","9","47","47","Wo aame ɗe ersadá tʼa-da tʼettiyo kʼadda kʼolɗiko maŋ, kʼa tʼooɗo mentú. Beehiye i jiire a kee tʼersadá soo wo ki tʼettey Moziko Raa, bee miŋ kʼa lekke edayá sire wo an ki ti seɗɗey adda kʼuwwo. ");
INSERT INTO moz_vpl VALUES ("MK9_48","071_9_48","MRK","9","48","48","A ume geŋ ɗuwo ge ruumiyo, ondirɗagi ge dʼomɓo ki daayum i ki ɗaŋgiya ye, wo uwwo tʼoggiyo ki daayum. ");
INSERT INTO moz_vpl VALUES ("MK9_49","071_9_49","MRK","9","49","49","Wede tuuku toŋ yʼa tʼoona dabar, wo todʼ dabar gette aa uwwo tʼa ki ti kʼooɗiba kamilen̰ aa sumade. ");
INSERT INTO moz_vpl VALUES ("MK9_50","071_9_50","MRK","9","50","50","Kane sumadeʼŋ munɗa wede beehiye, wo ɗe aame sumade geŋ uŋsuwadaŋ i tʼize umbo maŋ, kaŋ mummino kʼan ise uŋse sey me? Iŋkino maŋ kune toŋ kun lekko daayum uŋse aakede sumade, wo kun di lekko ti toose ti tudduguŋ me.» ");
INSERT INTO moz_vpl VALUES ("MK10_1","071_10_1","MRK","10","1","1","Ti Kapernayim Isa yʼa tʼiiziga, yʼa tʼiide siiɗo Ziide. Saŋ maŋ yi-ti diipiɗa ti dar kʼooye Zurden ti nee. Ɗoŋ ɓaadaŋ an di-tʼugiye sey, wo yʼan iise dooyiso aakede naabadí ere daayum yi dʼisiyo. ");
INSERT INTO moz_vpl VALUES ("MK10_2","071_10_2","MRK","10","2","2","Aame geŋ i dʼede Pariziyeŋ miibi an a dʼiide sirpa kʼIsa kono an dehu an i dʼekke ikka tʼurzi kʼono. Iŋkino an di yʼ tunde, anʼde: «Oogiradiŋ tʼele ko urzi a kule yʼa-peere eddí te?» ");
INSERT INTO moz_vpl VALUES ("MK10_3","071_10_3","MRK","10","3","3","Isa onamaŋ yʼan tiʼn gime ti tondiyo, yʼede: «Oogoro ere Muusa yʼun ele wee te?» ");
INSERT INTO moz_vpl VALUES ("MK10_4","071_10_4","MRK","10","4","4","Kane an di ruute, anʼde: «Ti kaaga Muusa yʼa ele urzi, aame wede yi-peere eddí maŋ, yi di ɗekke mattup ki peeriyo yi di tʼele a beytú wo yʼa ti tʼigibe.» ");
INSERT INTO moz_vpl VALUES ("MK10_5","071_10_5","MRK","10","5","5","Maŋ Isa yʼan di ruute, yʼede: «Muusa yʼun riiŋe urzi kʼoogoro geŋ kono a eego zakiɗi ere un dʼede gettiyo. ");
INSERT INTO moz_vpl VALUES ("MK10_6","071_10_6","MRK","10","6","6","Wo ɗe ono eŋ an riiŋe ti kaaga adda mattup ki Raa, anʼde: “Tʼume kʼeesiyo Raa yi ziipe sulɗi pay geŋ, yʼikkima aŋ kule tʼere. ");
INSERT INTO moz_vpl VALUES ("MK10_7","071_10_7","MRK","10","7","7","Kono kamo kule yi dʼoola meegí ti meedí, yʼa di ketta bin̰ ti eddí. ");
INSERT INTO moz_vpl VALUES ("MK10_8","071_10_8","MRK","10","8","8","Wo kane sire geŋ an tʼisa tudde soo.” Iŋkino maŋ kane geŋ sire ye baa, an tʼize tudde soo. ");
INSERT INTO moz_vpl VALUES ("MK10_9","071_10_9","MRK","10","9","9","Geŋ iŋkino munɗa wede Raa yʼa ti gitte geŋ, wede tudde yi ki tʼeeze ye.» ");
INSERT INTO moz_vpl VALUES ("MK10_10","071_10_10","MRK","10","10","10","Isa ti sanalliyagi an aahe ɓoy. An iideʼŋ sanalliyagi an di yʼ tunde sey a urzi peeriyo geŋ me. ");
INSERT INTO moz_vpl VALUES ("MK10_11","071_10_11","MRK","10","11","11","Maŋ Isa yʼan di ruute, yʼede: «Ki peeriyo kʼerewo ulu, wo eddí yi ti biira wo yi ziiɗa erewo ti doolo maŋ, yoŋ geŋ yi tʼize olɗiko a ɗaana kʼeddí ere ki poone, kono Raa yi yi wolliyo yoŋ wede i moone tʼere bakadí. ");
INSERT INTO moz_vpl VALUES ("MK10_12","071_10_12","MRK","10","12","12","Wo erewo toŋ iŋkino, aame kulatú ti yʼiila wo ti ziiɗa kule ti doolo maŋ, tode gette Raa yi ti wolliyo ere ti moone ti kule bakatú.» ");
INSERT INTO moz_vpl VALUES ("MK10_13","071_10_13","MRK","10","13","13","Ɗuwo an i di ziko in̰n̰i sun̰n̰i a Isa kono yʼan di zaape beezí a eedaŋ, miŋ kane sanalliyagi an ki dehu ye, an diʼn eɗɗisito ɗuwo geŋ me. ");
INSERT INTO moz_vpl VALUES ("MK10_14","071_10_14","MRK","10","14","14","Isa yi wulle iŋkino maŋ yi-ti gulkuwe, yʼan di ruute a sanalliyagi, yʼede: «Kun oolo in̰n̰i eŋ an dʼetto ki tuddó, kun tiʼn eegire ye, kono Moziko Raa todʼte ki ɗoŋ i deeƴiso aa kane kino. ");
INSERT INTO moz_vpl VALUES ("MK10_15","071_10_15","MRK","10","15","15","Ɗerec iŋkino wo nʼun di rooto: Wede tuuku Moziko Raa yi ki ti seeɗu aa yi seeɗu ulo n̰eŋku ye maŋ, yi ki tʼetta ye.» ");
INSERT INTO moz_vpl VALUES ("MK10_16","071_10_16","MRK","10","16","16","Iŋkino maŋ ulo soŋ yi di yʼamɓu, yi di zaapu beezí ki beeko a eedí eedí. ");
INSERT INTO moz_vpl VALUES ("MK10_17","071_10_17","MRK","10","17","17","Isa yi tʼiiziga yʼeŋgile maŋ, i dʼede wedusu yʼa ukko ki tuddí, yʼa dikke a ɗaanadí wo yʼa yi tunde, yʼede: «Wede dooyisadey kee wede beehiye, nʼaase moo me kono nʼa tʼoona lekkiyo ere ki daayum te?» ");
INSERT INTO moz_vpl VALUES ("MK10_18","071_10_18","MRK","10","18","18","Isa yi di ruute, yʼede: «Ki moo me ki rootiyo nuŋ wede beehiye me? Beehiye Raa soo ɗaŋŋal, wenɗa ti doolo umbo. ");
INSERT INTO moz_vpl VALUES ("MK10_19","071_10_19","MRK","10","19","19","Kee urziyagi kʼoogoro kiʼni suune ɗoŋ anʼde: Ki tôwwo wedusu mirsi ulu, ki moone tʼere bakadá ise ti kule bakatú ulu, kʼoogire ulu, ki rootiyo kʼono butte a tukki bakadá a ɗaana booro ulu, omɓo bize ti suma ɗuwo ulu, wo ki elo suma a meegá ti meedá.» ");
INSERT INTO moz_vpl VALUES ("MK10_20","071_10_20","MRK","10","20","20","Maŋ wede geŋ yi diʼn gime onamí, yʼede: «Wede dooyisadey, kane geŋ pay niʼni seeɗu tʼume nuŋ obulsu to.» ");
INSERT INTO moz_vpl VALUES ("MK10_21","071_10_21","MRK","10","21","21","Wede geŋ Isa yi di wolliyo teɓen̰ wo yʼa yi giyye, maŋ yi di ruute, yʼede: «Kee a ki biite munɗa soo: kʼodo, sulɗi ɗoŋ a-dʼedeʼŋ ki tʼowiltoy pay wo soŋko kʼan dʼeloy a ɗoŋ an kʼede munɗa ye, iŋkino kʼa tʼooney laale wede ki kotto a kandaane. Saŋ kʼa tʼedi wo kʼa ni daana.» ");
INSERT INTO moz_vpl VALUES ("MK10_22","071_10_22","MRK","10","22","22","Aame wede geŋ yʼilliga ono gen̰n̰o maŋ, ume kʼedayí a tʼize zimolo wo yʼa tʼize sommagi dondoŋ, kono yoŋ maaladí ɓaadaŋ, saŋ yʼa iŋgile. ");
INSERT INTO moz_vpl VALUES ("MK10_23","071_10_23","MRK","10","23","23","Isa yʼa wulle sanalliyagí ɗoŋ i ti yʼ ɗuule, wo yʼan di ruute, yʼede: «Ki kotto oon̰e ɓaadaŋ a ɗoŋ maala an tʼettey adda Moziko Raa te!» ");
INSERT INTO moz_vpl VALUES ("MK10_24","071_10_24","MRK","10","24","24","A onamí geŋ kane sanalliyagi an ziiɗa giggiraŋ. Wo ɗe Isa yʼan di ruute sey, yʼede: «In̰n̰i ki nuŋ, ki kotto oon̰e ɓaadaŋ kʼettiyo kʼadda Moziko Raa te! ");
INSERT INTO moz_vpl VALUES ("MK10_25","071_10_25","MRK","10","25","25","Oon̰e a ziŋzo ti-tʼaɗɗe ti bulɗo rippile me, wo geŋ oon̰e ɓaadaŋ a ceere sey a wede laale yi-tʼettey a Moziko Raa te.» ");
INSERT INTO moz_vpl VALUES ("MK10_26","071_10_26","MRK","10","26","26","Maŋ kane sanalliyagi an ziiɗa giggiraŋ a jiire sey, an di rootiyto tuddaŋ, anʼde: «Iŋkino maŋ, geŋ a utta wee wee?» ");
INSERT INTO moz_vpl VALUES ("MK10_27","071_10_27","MRK","10","27","27","Isa yi diʼn wolliyo ƴerere adda kʼedayaŋ wo yʼan di ruute, yʼede: «Munɗa eŋ ɗuwo an kʼaane ye, wo ɗe Raa yʼaane, kono a Raa sulɗi pay i-kʼoon̰e ye.» ");
INSERT INTO moz_vpl VALUES ("MK10_28","071_10_28","MRK","10","28","28","Maŋ Piyer yi di ruute Isa, yʼede: «Aŋkeŋ kʼollo, kayeʼŋ sulɗizey pay ay dʼiilo wo ay di daaniya kee.» ");
INSERT INTO moz_vpl VALUES ("MK10_29","071_10_29","MRK","10","29","29","Isa yi di ruute, yʼede: «Ɗerec iŋkino wo nʼun di rooto: Wede tuuku yi iila ɓoozí, ise zemɓadí kuuli erayi, meegí ti meedí, in̰n̰izí wo domɓizí kono nuuno wo ki Rabila Majjaanawa maŋ, ");
INSERT INTO moz_vpl VALUES ("MK10_30","071_10_30","MRK","10","30","30","a lekkiyo ere aŋken̰n̰o ette kane geŋ yʼanni tʼoona taŋ ɓaadaŋ a ceera ɓoyɗi, ise zemɓa kuuli erayi, maawi erayi, in̰n̰i, domɓi, wo ti dabar ere tʼurzi ɗoŋ kʼolmiɗayí. Wo saŋ maŋ adda duniya ere ki ɗaana, yʼa tʼooney lekkiyo ere ki daayum. ");
INSERT INTO moz_vpl VALUES ("MK10_31","071_10_31","MRK","10","31","31","Ɗoŋ ɓaadaŋ aŋken̰n̰o kane ki biza, saŋ an tʼisa ɗoŋ kʼita, wo ɗoŋ aŋken̰n̰o kane kʼita, saŋ an tʼisa ɗoŋ ki biza.» ");
INSERT INTO moz_vpl VALUES ("MK10_32","071_10_32","MRK","10","32","32","Isa ti sanalliyagi an ti kili Zeruzalem, yo Isa yʼan tʼuugume. Kane sanalliyagi undaŋ a tʼuɗɗe, wo ɗoŋ iʼni daaniya toŋ orgiso tʼanni ziiɗa. Maŋ Isa sanalliyagi koomat makumu sire geŋ yʼan irga sey ki sirpadí, wo yʼan dʼiise rootiyo a munɗa wede saŋ i aaney, yʼede: ");
INSERT INTO moz_vpl VALUES ("MK10_33","071_10_33","MRK","10","33","33","«Kun ollo, in ti kili ki Zeruzalem wo nuŋ wede an nʼehe aa ulo wede eŋ, an di nʼ tʼeley a bey deero ɗoŋ seɗeke ti ɗoŋ suuniyo kʼoogoro. Kane geŋ tʼurzi kʼonamaŋ nuŋ booro tʼa ni seeɗey ki tôwwo, wo an di nʼ tʼeley a bey ɗoŋ Yawudiyagi ye. ");
INSERT INTO moz_vpl VALUES ("MK10_34","071_10_34","MRK","10","34","34","Kane geŋ an di nʼ tʼokkey maade, an piɗɗitey lee a tuddó, an di nʼ gorpipey ti marpa wo an aa di nʼ tʼîdey. Wo onniyo sire kʼaɗuwe maŋ, Raa yʼa ti nʼ balɗey.» ");
INSERT INTO moz_vpl VALUES ("MK10_35","071_10_35","MRK","10","35","35","Saŋ maŋ Zak ti Zaŋ, in̰n̰i Zebede, an a dʼiide kʼume kʼIsa wo an di ruute, anʼde: «Wede dooyisadey, kaye ay dehu kʼay tʼise munɗa wede ay ki tonda.» ");
INSERT INTO moz_vpl VALUES ("MK10_36","071_10_36","MRK","10","36","36","Maŋ Isa yʼanni tunde, yʼede: «Kune kun dehu nʼun dʼise moo me?» ");
INSERT INTO moz_vpl VALUES ("MK10_37","071_10_37","MRK","10","37","37","Kane an i di ruute anʼde: «Ay dehu kʼa tʼele urzi, onniyo ki tʼiida darƴikadá maŋ, kayeʼŋ kʼay tiʼn zappey soŋ a ammidadá, soŋ a geeladá.» ");
INSERT INTO moz_vpl VALUES ("MK10_38","071_10_38","MRK","10","38","38","Wo ɗe Isa yʼan di ruute, yʼede: «Munɗa wede kun tondiyo, kun ki yʼ suune ye. Kun aana kun siɓa ko kop ki dabar wede nuŋ ni soɓo me? Wo kun aana kun suyya batem ki dabar ere nuŋ ni suyyiso ko?» ");
INSERT INTO moz_vpl VALUES ("MK10_39","071_10_39","MRK","10","39","39","Maŋ an i di ruute, anʼde: «Eyye, ay aana.» Isa yʼan di ruute, yʼede: «Ɗerec, kop ki dabar wede nuŋ ni soɓo geŋ kun siɓa, wo suyyiso batem ki dabar ere ni suyyiso gette kun suyya. ");
INSERT INTO moz_vpl VALUES ("MK10_40","071_10_40","MRK","10","40","40","Wo ɗe ki ume konso wede a ammidadó soŋ a geeladó geŋ, urzi yoŋ a bey nuuno ye, ume geŋ yoŋ ki kane ɗoŋ Raa yʼan ikkima.» ");
INSERT INTO moz_vpl VALUES ("MK10_41","071_10_41","MRK","10","41","41","Aame kane sanalliyagi ɗoŋ koomat geŋ an illiga maŋ, an dʼiise kulkuwo ti Zak wo Zaŋ. ");
INSERT INTO moz_vpl VALUES ("MK10_42","071_10_42","MRK","10","42","42","Maŋ Isa yʼa tiʼn wiike sanalliyagi geŋ pay ki ɗaanadí, wo yʼan di ruute, yʼede: «Kune kun suune, kane ɗuwo anʼni wolliyo mozagi siiɗiyagi pay geŋ an dʼomɓo tʼekki ɗoŋzaŋ ti toogo, wo kane ɗoŋ deero an dʼomɓo tʼekki ɗoŋzaŋ tʼurzi dokkiyo ere an dʼede. ");
INSERT INTO moz_vpl VALUES ("MK10_43","071_10_43","MRK","10","43","43","Wo geŋ a diinaguŋ i dehu iŋkino a kʼise ye. Ki too maŋ, wede tuuku yi dehu yʼa tʼise goole ti diinaguŋ maŋ, yoŋ geŋ yi tʼiso wede naabaguŋ, ");
INSERT INTO moz_vpl VALUES ("MK10_44","071_10_44","MRK","10","44","44","wo wede tuuku ti diinaguŋ yi dehu yʼa tʼise ki biza maŋ, yoŋ geŋ yi tʼiso ɓule ki kune pay. ");
INSERT INTO moz_vpl VALUES ("MK10_45","071_10_45","MRK","10","45","45","Ɗerec, nuŋ wede an nʼehe aa ulo wede eŋ, nʼiidoʼŋ kono ɗuwo an o-ki naabe ye, wo ɗe nʼiidoʼŋ nʼan di naabe ɗuwo wo nʼa oyye nʼa tʼinda kono nʼa tʼaɗɗe ɗoŋ ɓaadaŋ tʼadda kʼolɗikadaŋ.» ");
INSERT INTO moz_vpl VALUES ("MK10_46","071_10_46","MRK","10","46","46","Saŋ maŋ Isa ti sanalliyagí an dʼiiney geeger Zeriko. A aɗɗiyadaŋ ti geeger gettiyo geŋ ɗoŋ duuru ɓaadaŋ an diʼn daaniya, an dʼuuney wede koosiyo konso a biza kʼurzi, yi dʼahultu. Wede geŋ sundí Bartime, ulo Time. ");
INSERT INTO moz_vpl VALUES ("MK10_47","071_10_47","MRK","10","47","47","Aame yʼilliga eŋgilso geŋ Isa wede ti geeger Nazaret maŋ, yʼa iise ɗollite, yʼede: «Isa kee Wede ti biza bumɓu Dawut, kʼiso adde koɗuwo a nuŋ!» ");
INSERT INTO moz_vpl VALUES ("MK10_48","071_10_48","MRK","10","48","48","Ɗoŋ ɓaadaŋ an di yʼeɗɗisito kono yʼa anniga, wo ɗe yoŋ yʼa ɗolle i ceeriyo ki ceeriyo, yi dʼeesiyo: «Kee Wede ti biza bumɓu Dawut, kʼiso adde koɗuwo a nuŋ, kʼiso adde koɗuwo a nuŋ!» ");
INSERT INTO moz_vpl VALUES ("MK10_49","071_10_49","MRK","10","49","49","Isa yʼa tʼîhira, wo yʼa ruute, yʼede: «Kun o yi waaki.» Maŋ koosiyo an di yʼ wiiko, anʼde: «Kʼomɓon̰, ki tʼoozigi. Isa yi ki waaku!» ");
INSERT INTO moz_vpl VALUES ("MK10_50","071_10_50","MRK","10","50","50","Iŋkino maŋ kallayí yʼa ziɗɗe, perek yʼa tʼiiziga, yʼa iide kʼume kʼIsa. ");
INSERT INTO moz_vpl VALUES ("MK10_51","071_10_51","MRK","10","51","51","Maŋ Isa yʼa yi tunde, yʼede: «Kee ki dehu nʼa-dʼise moo me?» Yo koosiyo geŋ yi diʼn gime onamí, yʼede: «Wede dooyisadey, ni dehu edayó a-tʼihina.» ");
INSERT INTO moz_vpl VALUES ("MK10_52","071_10_52","MRK","10","52","52","Maŋ Isa yi di ruute, yʼede: «Kono kee ki ziipe addá a nuuno geŋ, kʼutte kʼaaho.» A kaamiki, edayí a tʼihina yi wolliyo, wo yʼa diine Isa, an di sooru soo. ");
INSERT INTO moz_vpl VALUES ("MK11_1","071_11_1","MRK","11","1","1","Isa ti sanalliyagi an iiney goppoŋ ki Zeruzalem, a sirpa kʼilliyagi sundaŋ Betpaze wo Betani, wo a sirpa mokkolo kʼInda kʼOlibiye. A ume geŋ yi dʼigibe ɗoŋ sire ti diine sanalliyagí, ");
INSERT INTO moz_vpl VALUES ("MK11_2","071_11_2","MRK","11","2","2","wo yʼan di ruute, yʼede: «Kunʼdo kʼadda kʼille ere a ɗaanaguŋ gettiyo. Kun iiney, kesiko kun tʼooney ulo buuru kettiyo, wenɗa kaŋ soo toŋ yi ki gili ye. Kun tʼeezi, kun o-tʼarkiɗi. ");
INSERT INTO moz_vpl VALUES ("MK11_3","071_11_3","MRK","11","3","3","Aame wenɗa yʼun ruutey, yʼiisey: “Kun isiyo iŋkinoʼŋ moo me?” maŋ, kun dʼeesoy: “Buuru eŋ i dehu Galmeega, wo saŋ yʼun di yʼ kimo kaamiki.”» ");
INSERT INTO moz_vpl VALUES ("MK11_4","071_11_4","MRK","11","4","4","Iŋkino maŋ an dʼiŋgile. An iideʼŋ an dʼuuney ulo buuru kettiyo ti paate a biza kʼurzi, a biza bumɓu soo iŋkino, maŋ an tʼiize. ");
INSERT INTO moz_vpl VALUES ("MK11_5","071_11_5","MRK","11","5","5","Ɗoŋ miibi i lekkiyo a ume geŋ an diʼn wulle, maŋ an diʼn tunde, anʼde: «Kun isiyo moo me? Ɗe ki moo me kun tʼeeziyo ulo buuru eŋ me?» ");
INSERT INTO moz_vpl VALUES ("MK11_6","071_11_6","MRK","11","6","6","Maŋ kane sanalliyagi an an diʼn gime onamaŋ aa ɗoŋ Isa yʼan ruuto. Iŋkino maŋ an diʼn iili, an dʼiŋgile. ");
INSERT INTO moz_vpl VALUES ("MK11_7","071_11_7","MRK","11","7","7","Ulo buuru an i-dʼiide a Isa, an a-ti gikkite kallagaŋ ɗoŋ deero a dar kʼulo buuru wo Isa yʼa-ti gili eego. ");
INSERT INTO moz_vpl VALUES ("MK11_8","071_11_8","MRK","11","8","8","Ɗoŋ ɓaadaŋ kallagaŋ ɗoŋ deero an di gikkite a urzi, ɗoŋ oŋgoŋ an dimɓo puutagi kʼinda ti balɗa, an di gikkite a urzi kay. ");
INSERT INTO moz_vpl VALUES ("MK11_9","071_11_9","MRK","11","9","9","Kane ɗuwo ɗoŋ i sooru ki ɗaana ti ɗoŋ i daaniya geŋ, pay kaŋ soo an di ɗollite, an dʼeesiyo: «Tamma a Raa! Beeko Raa ti koona a ekki wede ettiyo ti suma Galmeega Raa! ");
INSERT INTO moz_vpl VALUES ("MK11_10","071_11_10","MRK","11","10","10","Beeko Raa ti koona a moziko ere ettiyo, moziko ere i tʼeesa ti meegiŋ Dawut ette. Tamma a Raa tʼawwa a kandaane!» ");
INSERT INTO moz_vpl VALUES ("MK11_11","071_11_11","MRK","11","11","11","Maŋ Isa yʼa iiney Zeruzalem, yi-tʼiide booro Ɓoy Raa. Yʼa wullite sulɗi ɗoŋ adda pay, wo ume yʼize baa peeɗo tʼette kʼooriyo, kesiko ti sanalliyagi kane koomat makumu sire geŋ, an dʼiŋgile ki Betani. ");
INSERT INTO moz_vpl VALUES ("MK11_12","071_11_12","MRK","11","12","12","Soggo Isa ti sanalliyagí an tʼuɗɗe ti Betani maŋ, aame geŋ mosogo tʼa yi ziiɗa. ");
INSERT INTO moz_vpl VALUES ("MK11_13","071_11_13","MRK","11","13","13","Ti dokki geŋ yi wulle undumu sundí pigiye i-dʼede puutagi dogibok, maŋ yʼa zikke kaɓɓaŋ yʼelkiyo yi-tʼooney in̰n̰i, wo ɗe yʼiideʼŋ in̰n̰i umbo, yi dʼuuney puutagi ɗaŋŋal kono umayí ki ehiyo i kʼiina ye ɓotto. ");
INSERT INTO moz_vpl VALUES ("MK11_14","071_11_14","MRK","11","14","14","Iŋkino maŋ Isa yi di ruute a undumu geŋ, yʼede: «Ti aŋki, wenɗa soo toŋ yi ki ɗekka ulá yʼa ki tʼooma ye baa!» Wo kane sanalliyagí an dʼilliga. ");
INSERT INTO moz_vpl VALUES ("MK11_15","071_11_15","MRK","11","15","15","Saŋ an di gimo sey ki Zeruzalem, maŋ Isa yi-tʼiide a booro Ɓoy Raa, yʼa iise lommite kane ɗoŋ isiyo suuk ti ɗoŋ kʼowilte pay a ume gen̰n̰o. Yʼan di gippirɗe taabulyagi ki ɗoŋ pelkiyto soŋko ere ettiyo ti siiɗiyagi doolo wo ti kaakidagi ɗoŋ kʼowilte deere. ");
INSERT INTO moz_vpl VALUES ("MK11_16","071_11_16","MRK","11","16","16","Wo a ɗoŋ pay yʼan di tuuge ki sokiyo sulɗi kʼadda booro Ɓoy Raa me. ");
INSERT INTO moz_vpl VALUES ("MK11_17","071_11_17","MRK","11","17","17","Maŋ yʼan iise dooyiso, yʼede: «Kun ollo, ono eŋ an riiŋe ti kaaga adda mattup ki Raa, anʼde: “Ɓoozó eŋ an di yʼ waaka ɓoy wede ki tondiyo Raa ki ita ɗuwo pay.” Wo ɗe kune, kun di yʼize urmi kʼombiɗe ɗoŋ kʼoogire!» ");
INSERT INTO moz_vpl VALUES ("MK11_18","071_11_18","MRK","11","18","18","Kane deero ɗoŋ seɗeke ti ɗoŋ suuniyo kʼoogoro an illiga iŋkino maŋ, an dehutu urzi ki tôwwadí. Wo an isiyo iŋkino kono an orgiso, kono ɗoŋ duuru dooyisadí tiʼni ziiɗa. ");
INSERT INTO moz_vpl VALUES ("MK11_19","071_11_19","MRK","11","19","19","A lohe peeɗo tʼa tʼiire maŋ, Isa ti sanalliyagí an tʼuɗɗe tʼadda geeger me. ");
INSERT INTO moz_vpl VALUES ("MK11_20","071_11_20","MRK","11","20","20","Soggo ti soohe aŋ Isa an aɗɗiya tiŋ gen̰n̰o, maŋ an wolliyo pigiye wede Isa yi duuɗe geŋ i biiha ti sondayzí pay. ");
INSERT INTO moz_vpl VALUES ("MK11_21","071_11_21","MRK","11","21","21","Piyer geŋ yʼa ilke a munɗa wede ize, maŋ yi di ruute a Isa, yʼede: «Wede dooyisadey, ki wollo pigiye wede ki duuɗe i biiha.» ");
INSERT INTO moz_vpl VALUES ("MK11_22","071_11_22","MRK","11","22","22","Maŋ Isa yʼan di ruute, yʼede: «Kun zaapo adduguŋ a Raa. ");
INSERT INTO moz_vpl VALUES ("MK11_23","071_11_23","MRK","11","23","23","Ɗerec iŋkino wo nʼun di rooto: Wedeʼŋ yʼaane yi di roote a tokomo ette, yʼa tʼeese: “Tʼumayí eŋ mi tʼoozo, mi tʼooro adda bar”, daa niikiyo addí, wo ɗe yi zaapu addí munɗa wede yi ruute geŋ i tʼisa maŋ, geŋ Raa yi di tʼela. ");
INSERT INTO moz_vpl VALUES ("MK11_24","071_11_24","MRK","11","24","24","Kono kamo nʼun di rooto: Sulɗi ɗoŋ pay kun tondiyo Raa geŋ, kun zaapu adduguŋ a yode kun uune baa, wo kane geŋ yʼun diʼn tʼela. ");
INSERT INTO moz_vpl VALUES ("MK11_25","071_11_25","MRK","11","25","25","Wo aame kun tʼîhira tondiyo Raa wo un dʼede ono ti wenɗa maŋ, kun i tʼiso tambobino, kono Meeguguŋ Raa a kandaane toŋ yʼun tʼisa tambobino kay a munɗa wede kun a ti doopiɗe me.  ");
INSERT INTO moz_vpl VALUES ("MK11_26","071_11_26","MRK","11","26","26","Wo ɗe aame a ɗoŋ a ti doopiɗe a onamguŋ geŋ tambobino kun an kʼisiyo ye maŋ, Meeguguŋ Raa a kandaane toŋ yʼun kʼisa ye kay tambobino a munɗa wede kun a ti doopiɗe me.» ");
INSERT INTO moz_vpl VALUES ("MK11_27","071_11_27","MRK","11","27","27","Saŋ maŋ an di-gimo ki Zeruzalem. Koore Isa yi tʼiide yi sooru adda booro Ɓoy Raa geŋ, kane deero ɗoŋ seɗeke, ɗoŋ suuniyo kʼoogoro wo ti ɗoŋ i dokkiyo Yawudiyagi an dʼiido kʼume yode. ");
INSERT INTO moz_vpl VALUES ("MK11_28","071_11_28","MRK","11","28","28","Iŋkino maŋ an di yʼ tunde, anʼde: «Kee kʼisiyto sulɗi eŋ tʼurzi kʼaaye? Wo a ele wee wee urzi kʼisiyto sulɗi eŋ me?» ");
INSERT INTO moz_vpl VALUES ("MK11_29","071_11_29","MRK","11","29","29","Maŋ Isa yʼan diʼn gime onamaŋ, yʼede: «Nuŋ nʼun diʼn tondo a munɗa soo ɗaŋŋal. Onamó kun o-tiʼn kami, wo nuŋ toŋ nʼun ti yʼ kiza urzi wede ni dʼisiyto sulɗi eŋ me. ");
INSERT INTO moz_vpl VALUES ("MK11_30","071_11_30","MRK","11","30","30","Aame Zaŋ ɗuwo yʼanni zuyye batem geŋ, urzi iido ti Raa kunuŋ, ti ɗuwo ko? Onamó kun o tiʼn kami.» ");
INSERT INTO moz_vpl VALUES ("MK11_31","071_11_31","MRK","11","31","31","Maŋ an dʼiise rootiyto ti tuddaŋ, anʼde: «Aame kine in ruuta: “Iidoʼŋ tʼurzi Raa” maŋ, yoŋ yʼa roota: “Iŋkino ki moo me kun ki dʼumɓe a ono Zaŋ ye me?” ");
INSERT INTO moz_vpl VALUES ("MK11_32","071_11_32","MRK","11","32","32","Wo aame in ruuta: “Iidoʼŋ tʼurzi ɗuwo …” maŋ? An rootiyo iŋkino kono an dʼede orgiso a ɗoŋ duuru, kono kane pay geŋ an elkiyoʼŋ ki kotto Zaŋ yoŋ nebi.» ");
INSERT INTO moz_vpl VALUES ("MK11_33","071_11_33","MRK","11","33","33","Iŋkino maŋ Isa onamí an i-tiʼn gime, anʼde: «Ay ki suune ye.» Maŋ Isa yʼan di ruute, yʼede: «Nuŋ toŋ maŋ nʼun ki yʼ roote ye kay, wede o ele urzi ni dʼisiyto sulɗi eŋ me.» ");
INSERT INTO moz_vpl VALUES ("MK12_1","071_12_1","MRK","12","1","1","Saŋ maŋ Isa yʼan dʼiise rootiyto tʼono ombiɗe a deero Yawudiyagi, yʼede: «I dʼede wedusu iŋkino yi dʼiite doome kʼinda sundaŋ bin̰. Doome geŋ yʼa ti yʼ ɗuule ti waaya moŋgali, yʼa dʼittiba sôole ki ŋaƴƴu kʼin̰n̰i kʼinda bin̰ gen̰n̰o, yʼa dʼippe ɓoy sohuru ki boɗɗiyo. Maŋ doome geŋ yʼan dʼele ɗuwo an di naabe saŋ yoŋ aggadí yʼa tʼamɓa, wo yoŋ tuddí yʼa iŋgile torguwo. ");
INSERT INTO moz_vpl VALUES ("MK12_2","071_12_2","MRK","12","2","2","Aame onniyo ki rakku tʼiina maŋ, yʼa igibe wede naabadí soo ki tukki ɗoŋ naabo doome gen̰n̰o, kono an i di tʼelo aggadí ere kʼin̰n̰i kʼinda bin̰ an rikke te. ");
INSERT INTO moz_vpl VALUES ("MK12_3","071_12_3","MRK","12","3","3","Aame yʼiiney maŋ, kane an di yʼ ziiɗa, an di yʼ gusse wo an aa di yʼigibe beezí guguba. ");
INSERT INTO moz_vpl VALUES ("MK12_4","071_12_4","MRK","12","4","4","Wede doomeʼŋ yʼan dʼigibe wede naabadí ti doolo, wo yode gen̰n̰o toŋ an di yʼ tiiza a eedí, an a-ti yʼ gilɗite. ");
INSERT INTO moz_vpl VALUES ("MK12_5","071_12_5","MRK","12","5","5","Yi dʼigibe kʼaɗuwe sey, yode geŋ an di yʼîide. Saŋ wede doome ɗoŋ naabadí ɓaadaŋ yʼikkipe kʼita toŋ ɗoŋ naabo doome an diʼn gussite, wo ɗoŋ oŋgoŋ an diʼn îidite. ");
INSERT INTO moz_vpl VALUES ("MK12_6","071_12_6","MRK","12","6","6","Kʼita maŋ i guute miŋ ulo geyyisadí, yʼan ti yʼigibe wo yʼa ruute tʼadda kʼaddí, yʼede: “Yoŋ eŋ ulo kʼaddó, an i dʼottiley.” ");
INSERT INTO moz_vpl VALUES ("MK12_7","071_12_7","MRK","12","7","7","Wo ɗe kane ɗoŋ naabo doome an dʼiise rootiyto ti tuddaŋ, anʼde: “En̰n̰o ulo wede doome i oopa me! In yʼôodo kono doome eŋ in dʼoopa a kine.” ");
INSERT INTO moz_vpl VALUES ("MK12_8","071_12_8","MRK","12","8","8","Maŋ ulo geŋ an di yʼ ziiɗa, an di yʼîide wo nuune an tʼumɓe an di ziɗɗo dokki ti doome me.» ");
INSERT INTO moz_vpl VALUES ("MK12_9","071_12_9","MRK","12","9","9","Maŋ Isa yʼa ruute, yʼede: «Wo aŋkeŋ wede doome yʼaasa mummino? Yoŋ yʼa etto, ɗoŋ naabo doome yʼa tiʼn tʼîda, wo doome kʼinda bin̰ yʼan tʼela a ɗoŋ naabo doolo, saŋ aggadí yʼa tʼamɓa. ");
INSERT INTO moz_vpl VALUES ("MK12_10","071_12_10","MRK","12","10","10","Ki kotto kune kun gire ono eŋ an riiŋe ti kaaga adda mattup ki Raa, anʼde: “Mokkolo ere ɗoŋ kʼoozige ɓoy an di ziɗɗe mentú gette, tode gettiyo a tʼize mokkolo ere majjaanawa a jiire kʼoozige ɓoy te. ");
INSERT INTO moz_vpl VALUES ("MK12_11","071_12_11","MRK","12","11","11","Munɗa geŋ iido ti Galmeega Raa, wo a kine in di wolliyoʼŋ munɗa geŋ i jiire eego.”» ");
INSERT INTO moz_vpl VALUES ("MK12_12","071_12_12","MRK","12","12","12","Kane deero Yawudiyagi an di zuune keren̰, Isa yi rootiyo ono ombiɗe geŋ ti kane me. Iŋkino maŋ an di dihe urzi an di yʼ seeɗa, wo ɗe an dʼurgiɗe a ɗoŋ duuru. Maŋ an di yʼiili, an dʼiŋgile. ");
INSERT INTO moz_vpl VALUES ("MK12_13","071_12_13","MRK","12","13","13","Saŋ maŋ deero Yawudiyagi an dʼigibe ɗoŋ miibi ti diine Pariziyeŋ ti ɗoŋ a ita kʼErod kʼume kʼIsa, kono an i tʼekka ikka tʼurzi kʼonamí. ");
INSERT INTO moz_vpl VALUES ("MK12_14","071_12_14","MRK","12","14","14","An iido maŋ, an i di ruute, anʼde: «Wede dooyisadey, ay suune kee ki rootiyo ono ɗoŋ ɗerec, ki kʼorgiso eda ɗuwo ye, kiʼni wolliyo ɗuwo geŋ pay kaŋ soo, wo ki dooyiso urzi Raa tʼono ɗoŋ ɗerec. Aŋkeŋ a urzi kʼoogiradiŋ miŋ jibaaye a mozigo goole ki Romeŋ geŋ kʼeliyo kunuŋ, kʼeliyo ye ko? In tʼele kunuŋ, ulu ko?» ");
INSERT INTO moz_vpl VALUES ("MK12_15","071_12_15","MRK","12","15","15","Wo Isa yʼa zuune kane bizaŋ sire sire, iŋkino maŋ yʼan di ruute, yʼede: «Ɗe ki moo me kun o dʼekkiyo ikka me? Kun o kʼeeli tamma soo, nʼa ki wolle ɗo.» ");
INSERT INTO moz_vpl VALUES ("MK12_16","071_12_16","MRK","12","16","16","Maŋ an i-dʼeele tamma soo, wo Isa yʼanni tunde, yʼede: «Undiso ti suma ekki tamma ette kʼaaye?» Kane an i diʼn gime onamí, anʼde: «Ki mozigo goole ki Romeŋ.» ");
INSERT INTO moz_vpl VALUES ("MK12_17","071_12_17","MRK","12","17","17","Maŋ Isa yʼan di ruute, yʼede: «Iŋkino maŋ munɗa wede ki mozigo goole ki Romeŋ yoŋ ki yode kun i yʼelo, wo munɗa wede ki Raa yoŋ ki yode, kun i yʼelo.» Aame an illiga ono gen̰n̰o maŋ, an ziiɗa giggiraŋ kono yode geŋ me. ");
INSERT INTO moz_vpl VALUES ("MK12_18","071_12_18","MRK","12","18","18","Ɗoŋ miibi ti diine ɗoŋ anʼni waaku sundaŋ Saduseyeŋ geŋ, an dʼiide sirpa kʼIsa. Kun suune kane Saduseyeŋ an rootiyo, ɗoŋ i tʼinda an ki ti balɗa ye. Iŋkino Isa an di yʼ tunde, anʼde: ");
INSERT INTO moz_vpl VALUES ("MK12_19","071_12_19","MRK","12","19","19","«Wede dooyisadey, Muusa yi riiŋe ti kaaga adda mattup kʼoogoro munɗa wede in dʼise me, yʼede: “Aame wede yʼinda wo yi iili erewo daa magin̰e maŋ, mandaayawa gette leemadí yʼa ti seeɗa kono an tʼehe in̰n̰i a suma ki wede inda gen̰n̰o.” ");
INSERT INTO moz_vpl VALUES ("MK12_20","071_12_20","MRK","12","20","20","Iŋkino aakede i-dʼede zemɓa kane sarat. Wede ki poone geŋ yʼa ziiɗa erewo wo yʼa inda daa magin̰e. ");
INSERT INTO moz_vpl VALUES ("MK12_21","071_12_21","MRK","12","21","21","Mandaayawa gette leema wede ki sirwe yʼa ti ziiɗa, wo yode toŋ yʼa inda daa magin̰e kay, wede kʼaɗuwe toŋ iŋkino. ");
INSERT INTO moz_vpl VALUES ("MK12_22","071_12_22","MRK","12","22","22","Kane zemɓa sarat geŋ an ti duude pay, wo wede tuuku yi-tʼoone magin̰e umbo. Aame kane sarat geŋ pay an tʼinda maŋ, tode erewo gettiyo toŋ tʼaa dʼinda. ");
INSERT INTO moz_vpl VALUES ("MK12_23","071_12_23","MRK","12","23","23","Iŋkino maŋ a onniyo ere ɗoŋ i tʼinda an ti balɗa geŋ, ti diine kane zemɓa geŋ erewo gette tʼaasa kʼaaye, kono kane sarat pay geŋ miŋ kulutú me?» ");
INSERT INTO moz_vpl VALUES ("MK12_24","071_12_24","MRK","12","24","24","Isa yʼan di ruute, yʼede: «Kune kun ti digge a elkiyaguŋ, kono ki kotto kun kiʼn suune ye ita kʼono ɗoŋ an riiŋe ti kaaga adda mattup ki Raa, ise toogo Raa toŋ maŋ. ");
INSERT INTO moz_vpl VALUES ("MK12_25","071_12_25","MRK","12","25","25","Ɗerec, a onniyo ere ɗoŋ i tʼinda an ti balɗa geŋ, kuuli ti erayi an ki seɗɗa tuddaŋ ye baa, wo ɗe an di lekkey daa seɗɗu aa maaleekiyagi a kandaane. ");
INSERT INTO moz_vpl VALUES ("MK12_26","071_12_26","MRK","12","26","26","Wo a urzi balɗiya ki ɗoŋ i tʼinda geŋ, ki kotto kun gire adda mattup ki Muusa ono ɗoŋ Raa yi-ruute tʼadda beyga kʼundumu oggiyo uwwo ɗala ɗala geŋ, yʼede: “Nuŋ Raa kʼIbirayim, kʼIsaaka wo ki Yakup.”» ");
INSERT INTO moz_vpl VALUES ("MK12_27","071_12_27","MRK","12","27","27","Isa yʼa ruute sey, yʼede: «Raa geŋ yoŋ Raa ki ɗoŋ unto ye, yoŋ Raa ki ɗoŋ zeere. Geŋ ki kotto kun ti digge a elkiyaguŋ gette.» ");
INSERT INTO moz_vpl VALUES ("MK12_28","071_12_28","MRK","12","28","28","I dʼede wede suuniyo kʼoogoro soo iŋkino, yiʼn ollige Isa an niikiyto ti Saduseyeŋ me. Wo yʼilliga Isa yʼanni gime onamaŋ ɗerec maŋ, yʼa dʼiide sirpadí wo yʼa yi tunde, yʼede: «Tʼadda diine kʼurziyagi kʼoogoro pay ki Muusa geŋ, urzi kʼoogoro wede goole a jiire tuuku me?» ");
INSERT INTO moz_vpl VALUES ("MK12_29","071_12_29","MRK","12","29","29","Isa yi diʼn gime onamí, yʼede: «Urzi kʼoogoro wede a jiire en̰n̰o: “Kun ollo ɗoŋ kʼIzirayel no, Galmeega Raaziŋ, yoŋ Galmeega soo ɗaŋŋal. ");
INSERT INTO moz_vpl VALUES ("MK12_30","071_12_30","MRK","12","30","30","Ki geyyo Galmeega Raazá ti addá pay, ti undá pay, ti elkiyadá pay wo ti toogadá pay.” ");
INSERT INTO moz_vpl VALUES ("MK12_31","071_12_31","MRK","12","31","31","Wo wede ki sirwe en̰n̰o: “Ki geyyo bakadá aa ki geyyiso tuddá batum.” Urzi kʼoogoro wede a ceera kane sire eŋ umbo ti doolo me.» ");
INSERT INTO moz_vpl VALUES ("MK12_32","071_12_32","MRK","12","32","32","Wede suuniyo kʼoogoro yi di ruute a Isa, yʼede: «Geŋ beehiye wede dooyisadey, onamá ki ruute geŋ ɗerec. Galmeega Raa yoŋ soo ɗaŋŋal, Raa ti doolo umbo daa yode me. ");
INSERT INTO moz_vpl VALUES ("MK12_33","071_12_33","MRK","12","33","33","Wede geŋ yʼa geyye Raa ti addí pay, ti elkiyadí pay wo ti toogadí pay, wo yʼa geyye bakadí aa yi geyyiso tuddí batum. Wede iza iŋkino maŋ, geŋ i jiire seɗeke ere an oggiyo a ume seɗeke, wo i jiire seɗeke ere an isiyo ki seyɗi pay.» ");
INSERT INTO moz_vpl VALUES ("MK12_34","071_12_34","MRK","12","34","34","Isa yʼilliga ono wedusu yiʼni ruute geŋ ɗerec maŋ, yi di ruute, yʼede: «Kee dokki ye ti Moziko Raa te.» Wo tʼume geŋ an dʼurgiɗe, an di yʼ tondite ti doolo sey me. ");
INSERT INTO moz_vpl VALUES ("MK12_35","071_12_35","MRK","12","35","35","Isa yi dooyiso ɗuwo adda booro Ɓoy Raa, aame geŋ yʼan di ruute, yʼede: «Ɗe mummino kane ɗoŋ suuniyo kʼoogoro an di rootiyo Almasi Raa yi biire, yʼaɗɗo ti biza bumɓu Dawut me? ");
INSERT INTO moz_vpl VALUES ("MK12_36","071_12_36","MRK","12","36","36","Wo yode Dawut batum yʼa ruute ti kaaga tʼurzi kʼUnde Kamilen̰, yʼede: “Galmeega Raa yi di ruute a Galmeegó, yʼede: Kʼedi ki-koona a ammidadó kino, bini ɗoŋ kʼaduzá nʼan isa aa munɗa ki bita ti ɗanɗi zoŋɗá.” ");
INSERT INTO moz_vpl VALUES ("MK12_37","071_12_37","MRK","12","37","37","Kun ollige, yode Dawut batum yi yi waaku Almasi “Galmeega”. Ɗe geŋ mummino Almasi yʼa aɗɗo ti biza bumɓu Dawut ɗaŋŋal me?» Aame geŋ ɗoŋ duuru ɓaadaŋ an di yʼollige ti ulbe uŋse. ");
INSERT INTO moz_vpl VALUES ("MK12_38","071_12_38","MRK","12","38","38","Isa a dooyisadí gette yʼan di ruute a ɗuwo, yʼede: «Kun koona mentikagi ti ɗoŋ suuniyo kʼoogoro! Kane an geyyiso sooru ti kallagi deero a arga boy, wo a bere ɗoŋ duuru an dehu ɗuwo an an diʼn tʼeesite ti ottilso. ");
INSERT INTO moz_vpl VALUES ("MK12_39","071_12_39","MRK","12","39","39","Adda ɓoyɗi ɗoŋ in di dooyiso, an dehu an koone a ume wede suma, wo adda tarnaapagi a ume kʼomɓo toŋ, an dehu an koone a ume wede suma pây. ");
INSERT INTO moz_vpl VALUES ("MK12_40","071_12_40","MRK","12","40","40","Kane geŋ bey mandayɗayi an tʼomɓo pay, wo soŋ an eesiyo tondiyo Raa maŋ ki noko nokot kono ɗuwo an diʼn wolle. Kono kʼiŋkino geŋ booradaŋ tʼa kooney wehini a ceerey.» ");
INSERT INTO moz_vpl VALUES ("MK12_41","071_12_41","MRK","12","41","41","Saŋ maŋ Isa yʼa-guune edayí kʼume sandup ere ɗuwo an dʼeliyo soŋko adda booro Ɓoy Raa, yi wolliyo mummino ɗuwo an oɓe soŋko me. Ɗoŋ bey geŋ an dʼoɓe soŋko ɓaadaŋ. ");
INSERT INTO moz_vpl VALUES ("MK12_42","071_12_42","MRK","12","42","42","Wo i dʼede mandaayawa tʼa iina, kʼumbatú ti dʼiɓi soŋko sun̰n̰i sun̰n̰i sire. ");
INSERT INTO moz_vpl VALUES ("MK12_43","071_12_43","MRK","12","43","43","Iŋkino maŋ Isa yʼa wiike sanalliyagí wo yʼan di ruute, yʼede: «Ɗerec iŋkino wo nʼun di rooto: Mandaayawa i-kʼede munɗa ye ette, todʼ tʼele a jiire ti kane ɗoŋ pay oŋgo eliyo soŋko adda sandup gettiyo. ");
INSERT INTO moz_vpl VALUES ("MK12_44","071_12_44","MRK","12","44","44","Ɗerec, kane ɗoŋ doolo pay geŋ an ele tʼadda soŋko ere an uupe oopiyo, wo ɗe todʼte kʼumbatúʼŋ tʼa dʼele pay soŋko ere ii guute ki lekkiyatú te.» ");
INSERT INTO moz_vpl VALUES ("MK13_1","071_13_1","MRK","13","1","1","Saŋ maŋ Isa yi tʼuɗɗe tʼadda booro Ɓoy Raa, aame geŋ wede soo ti diine sanalliyagí yi di ruute, yʼede: «Wede dooyisadey, ki wollo majjaanika moŋgali ti oozige ɓoy en̰n̰o ɗo!» ");
INSERT INTO moz_vpl VALUES ("MK13_2","071_13_2","MRK","13","2","2","Isa yi di ruute, yʼede: «Ɗerec, ki wolliyo ɓoy an tʼiiziga majjaane eŋ, mokkolo soo toŋ tʼekki bakatú i ki lekka ye, pay a ruuga.» ");
INSERT INTO moz_vpl VALUES ("MK13_3","071_13_3","MRK","13","3","3","Isa yʼa iŋgile kʼekki mokkolo kʼInda kʼOlibiye, yʼa guune edayí kʼume Ɓoy Raa. Aame geŋ sanalliyagí Piyer, Zak, Zaŋ wo Andire, kane siidaŋ ti yode ɗaŋŋal an di yʼ tunde, anʼde: ");
INSERT INTO moz_vpl VALUES ("MK13_4","071_13_4","MRK","13","4","4","«Kee kʼay ki ti rooti ɗoo, sulɗi geŋ an aana woogo me? Wo moo me munɗa wede a kiza onniyo kino sulɗi pay geŋ an aana me?» ");
INSERT INTO moz_vpl VALUES ("MK13_5","071_13_5","MRK","13","5","5","Iŋkino maŋ Isa yʼan dʼiise rootiyto, yʼede: «Kun koona mentikagi, wenɗa soo toŋ yʼun tiʼn dagga ye. ");
INSERT INTO moz_vpl VALUES ("MK13_6","071_13_6","MRK","13","6","6","I dʼetto ɗoŋ ɓaadaŋ an tʼamɓo sundó, wede tuuku toŋ yʼa tʼeesa: “Nuŋ Almasi Raa yi biire!”, wo kane geŋ an di dagga ɗuwo ɓaadaŋ. ");
INSERT INTO moz_vpl VALUES ("MK13_7","071_13_7","MRK","13","7","7","Kun dʼolliga tarkuuse ki arka goppoŋ, wo kun dʼolliga rabila kʼarka dokki. Aame geŋ kun addira ye. I dehu sulɗi geŋ an dʼaane, wo aame geŋ a ki tʼisa ɗaŋgiya duniya ye ɓotto. ");
INSERT INTO moz_vpl VALUES ("MK13_8","071_13_8","MRK","13","8","8","Ɗoŋ siiɗo soo ti siiɗo soo te an ɗeyya ti tuddaŋ, ɗoŋ mozigo soo ti mozigo soo me an ɗeyya ti tuddaŋ kay. I dʼisa ŋoŋŋirso siiɗo adda siiɗiyagi ɓaadaŋ, wo i dʼisa mosogo pây. Wo kane sulɗi geŋ aakede kakkisa ere ki poone kʼerewo addutú i tʼumɓe kʼehiyo. ");
INSERT INTO moz_vpl VALUES ("MK13_9","071_13_9","MRK","13","9","9","Kun koona mentikagi a urzi lekkiyaguŋ, kono ɗuwo an un tiʼn seɗɗa an un diʼn tʼetta kʼume ɗoŋ booro, wo an un diʼn gorpipa ti marpa adda ɓoyɗi ɗoŋ in di dooyiso. An un diʼn tʼetta ɗaana ɗoŋ deero siiɗo wo ɗaana mozagi, kono kune ɗoŋzó. Aame geŋ a ɗaanadaŋ kun tʼoona urzi kun di roota a sulɗi ɗoŋ kun wulle wo kun illiga a tukki nuuno geŋ me. ");
INSERT INTO moz_vpl VALUES ("MK13_10","071_13_10","MRK","13","10","10","Ki poone onniyo gette tʼa aana geŋ, i dehu Rabila Majjaanawa an an ti kizite a ita ɗuwo pay. ");
INSERT INTO moz_vpl VALUES ("MK13_11","071_13_11","MRK","13","11","11","Wo aame an un tiʼn ziɗɗa kono an un diʼn tʼette kʼume ɗoŋ booro maŋ, ulbuguŋ un tʼooɗa ki poone ye a munɗa wede kun di rootey me. A ume geŋ miŋ Raa yʼun tʼeley ono ɗoŋ kun di rootey. Iŋkino maŋ aame kun rootey geŋ, ono ettey ti suuniyo kune ye, wo ɗe ettey tʼUnde Kamilen̰. ");
INSERT INTO moz_vpl VALUES ("MK13_12","071_13_12","MRK","13","12","12","Leema yʼan di yʼ tʼela leemadí a bey ɗuwo ki tôwwadí, wo meege toŋ iŋkino kay a in̰n̰izí me. In̰n̰i an di kima adu ki maawaŋ, an deha urzi ɗuwo an di seɗɗa maawaŋ ki tôwwadaŋ. ");
INSERT INTO moz_vpl VALUES ("MK13_13","071_13_13","MRK","13","13","13","Kune ɗoŋ duniya pay an un diʼn olmiɗa kono kun umɓe a sundó, wo ɗe wede yʼa ziiɗa zakiɗi a urzizó bini ɗaŋgu maŋ, yode geŋ Raa yʼa yʼutta. ");
INSERT INTO moz_vpl VALUES ("MK13_14","071_13_14","MRK","13","14","14","Kune kun di wolla munɗa wede ulsu kʼa yʼazzira wo yi lattiya, yode geŋ an ti yʼ zaapa adda Ɓoy Raa a ume i ki dehu kʼettiyo ye. Wede i gariya ono eŋ eedí tiʼni sooɗo beehiye. Aame geŋ kane ɗoŋ adda siiɗo Ziide an tʼombo kʼekki moŋgali. ");
INSERT INTO moz_vpl VALUES ("MK13_15","071_13_15","MRK","13","15","15","Wede yʼa ti gili yi-guune tʼekki daŋgayadí maŋ, yoŋ geŋ yi-ɗeega, yʼetta amɓu munɗa adda daŋgay ye, yi tʼombo. ");
INSERT INTO moz_vpl VALUES ("MK13_16","071_13_16","MRK","13","16","16","Wo wede yoŋ adda doome maŋ, yi tʼombo, yi kima ɓoy amɓo kallayí wede goole ye. ");
INSERT INTO moz_vpl VALUES ("MK13_17","071_13_17","MRK","13","17","17","A onniytagi geŋ aasa dabar ɓaadaŋ a kane erayi ɗoŋ mahuwagi ti ɗoŋ in̰n̰izaŋ an ooɗiyo! ");
INSERT INTO moz_vpl VALUES ("MK13_18","071_13_18","MRK","13","18","18","Kun tondo Raa kono sulɗi geŋ a kʼaana a ume reele ye. ");
INSERT INTO moz_vpl VALUES ("MK13_19","071_13_19","MRK","13","19","19","Ɗerec, a onniytagi geŋ dabar tʼaasa oon̰e ɓaadaŋ. Tʼume Raa yʼikkima duniya bini aŋken̰n̰o, dabar iŋkino i kʼize ye, wo ki ɗaana toŋ i kʼisa ye. ");
INSERT INTO moz_vpl VALUES ("MK13_20","071_13_20","MRK","13","20","20","Aame onniytagi ɗoŋ ki dabar geŋ Galmeega Raa yʼa kiʼn îhira goppoŋ ye maŋ, wede tudde soo toŋ umbo a lekka zeere me. Wo ki kotto onniytagi geŋ yʼan ôhira goppoŋ kono ɗoŋ yi biire ki yode. ");
INSERT INTO moz_vpl VALUES ("MK13_21","071_13_21","MRK","13","21","21","Iŋkino maŋ aame wenɗa yʼiisa: “Almasi Raa yi biire, yoŋ a en̰n̰o!” ise “Yoŋ a ummey!” maŋ, kune onamí kun amɓa ye. ");
INSERT INTO moz_vpl VALUES ("MK13_22","071_13_22","MRK","13","22","22","Ni rootiyo iŋkino kono i dʼaɗɗa ɗoŋ an ti tʼisa tuddaŋ aa Almasi Raa yi biire, wo ti ɗoŋ an ti tʼisa tuddaŋ aa nebiyagi. Kane geŋ an dʼisa sulɗi kʼarmika ti sulɗi ɗoŋ i ceeriyo eego, aame urzi ede maŋ kane an di dagga ɗuwo ɗoŋ Raa yi biire ki yode, wo an ki dʼaana ye. ");
INSERT INTO moz_vpl VALUES ("MK13_23","071_13_23","MRK","13","23","23","Kun koona mentikagi, sulɗi pay eŋ nʼun tiʼn ruute ki poone an dʼaana.» ");
INSERT INTO moz_vpl VALUES ("MK13_24","071_13_24","MRK","13","24","24","Isa yʼan di ruute sey, yʼede: «Onniytagi ɗoŋ ki dabar geŋ an tʼiŋgila lewwet maŋ, i dʼaana onniytagi ɗoŋ peeɗo ti ki toora ye, tere yi ki toora ye, ");
INSERT INTO moz_vpl VALUES ("MK13_25","071_13_25","MRK","13","25","25","molɗali an silɗita ti kandaane, wo sulɗi ɗoŋ an dʼede toogo a kandaane, Raa yʼa tiʼn gozziga. ");
INSERT INTO moz_vpl VALUES ("MK13_26","071_13_26","MRK","13","26","26","Aame geŋ ɗuwo an di nʼ wolla nuŋ wede an nʼehe aa ulo wede eŋ, ni kama ekki dondirso ti toogo ere pay wo ti darƴika. ");
INSERT INTO moz_vpl VALUES ("MK13_27","071_13_27","MRK","13","27","27","Wo nʼa tʼigiba maaleekiyagi kʼadda siiɗiyagi ɗoŋ a duniya itatú piɗe, an di tʼogiya ɗoŋ ni biire.» ");
INSERT INTO moz_vpl VALUES ("MK13_28","071_13_28","MRK","13","28","28","«Kun wollo wo kun elko a ono ombiɗe ɗoŋ a tukki tormo ettiyo: Aame tormo tʼeesiyo oɗɗize wo puutagutú eesiyo rooɓiyo maŋ, geŋ kune kun suune adda kʼadduguŋ kizini yoŋ goppoŋ. ");
INSERT INTO moz_vpl VALUES ("MK13_29","071_13_29","MRK","13","29","29","Geŋ iŋkino kay, kune toŋ kun wulla sulɗi geŋ an iina maŋ, kun suuno kama ki nuŋ wede an nʼehe aa ulo wede eŋ todʼte goppoŋ, aakede nuŋ a biza bumɓuguŋ. ");
INSERT INTO moz_vpl VALUES ("MK13_30","071_13_30","MRK","13","30","30","Ɗerec iŋkino wo nʼun di rooto: Ɗoŋ aŋken̰n̰o eŋ an ki ti tʼinda pay ye, ki poone sulɗi pay geŋ an dʼaana me. ");
INSERT INTO moz_vpl VALUES ("MK13_31","071_13_31","MRK","13","31","31","Kandaane kane ti siiɗo an tʼeŋgila, wo kane onamó an ki tʼeŋgila ye, an di lekka ki daayum.» ");
INSERT INTO moz_vpl VALUES ("MK13_32","071_13_32","MRK","13","32","32","«Wo sulɗi geŋ an aana a onniyo tuuku koo, a peeɗo ere tuuku koo maŋ, i suune yode Meega Raa siidí. Wenɗa doolo yi ki suune ye, ise maaleekiyagi a kandaane, ise Ulo Raa toŋ maŋ. ");
INSERT INTO moz_vpl VALUES ("MK13_33","071_13_33","MRK","13","33","33","Kun koona mentikagi, kun lekko zeere, kono onniyo gette kun ki ti suune ye. ");
INSERT INTO moz_vpl VALUES ("MK13_34","071_13_34","MRK","13","34","34","Sulɗi geŋ i deeƴiso aa wede yi tʼette torguwo. Attiɗi ɓoozí yʼan dʼiili a bey ɗoŋ naabadí, a wede tuuku toŋ yi dʼeele naabo sittú sittú, wo a wede boohiyo biza bumɓu yi ruute, yʼede: “Kʼollo, ki lekko zeere!” ");
INSERT INTO moz_vpl VALUES ("MK13_35","071_13_35","MRK","13","35","35","Iŋkino kun lekko zeere, kono wede ɓoy yi kimo a peeɗo ere tuuku kun ki suuna ye: yʼaana a lohe koo, diɗɗo koo, uzu yʼôola koo, ti soohe koo maŋ. ");
INSERT INTO moz_vpl VALUES ("MK13_36","071_13_36","MRK","13","36","36","Aame yi kimo a onniyo ere kun ki ti suune ye maŋ, yʼun gi diʼn tʼoona kun udige ye. ");
INSERT INTO moz_vpl VALUES ("MK13_37","071_13_37","MRK","13","37","37","Ono ɗoŋ nʼun rootiyo eŋ, ni rootiyo a ɗuwo pay: Kun lekko zeere!» ");
INSERT INTO moz_vpl VALUES ("MK14_1","071_14_1","MRK","14","1","1","A guute onniyo sire maŋ tarnaape Pak ki Yawudiyagi wo tarnaape wede an dʼomɓo mappa daa kʼorme geŋ, an dʼaɗɗa. Maŋ kane deero ɗoŋ seɗeke ti ɗoŋ suuniyo kʼoogoro, an dehutu urzi Isa an di yʼ seeɗa ti metiŋko ki tôwwadí. ");
INSERT INTO moz_vpl VALUES ("MK14_2","071_14_2","MRK","14","2","2","Wo kane an di ruute, anʼde: «Yoŋ in ki yʼ seeɗa adda tarnaape kino ye, para maŋ ɗoŋ duuru an in diʼn tʼooziga ono.» ");
INSERT INTO moz_vpl VALUES ("MK14_3","071_14_3","MRK","14","3","3","Isa yoŋ a ille ki Betani adda ɓoy ki Simo wede ti poone yoŋ ki bitiɗe, an di guune omɓo. Aame an ti guune geŋ i dʼede erewo ti tʼuɗɗo, a beytú ulo diŋgile an ikkima ki mokkolo sundutú albaatir, adda egey ɗoŋ eeɗiyadaŋ uŋse. Egey geŋ sundaŋ nardo, wo zooyayaŋ oon̰e ɓaadaŋ kono an a ki gilse ti munɗa ye. Tʼiideʼŋ, ulo diŋgile golladí tʼa dihima, wo egey geŋ ti-tʼiɓi ekkʼIsa. ");
INSERT INTO moz_vpl VALUES ("MK14_4","071_14_4","MRK","14","4","4","Maŋ ɗoŋ oŋgo ti diine kane ɗoŋ en̰n̰o geŋ ulbaŋ an ki tʼize uŋse ye, an di rootiyto diinayaŋ, anʼde: «Ɗe ki moo me ti tiʼn lattiya egey ɗoŋ eeɗiyadaŋ uŋse geŋ me? ");
INSERT INTO moz_vpl VALUES ("MK14_5","071_14_5","MRK","14","5","5","Egey geŋ in aane in tʼowila in tʼoone tamma meeda aɗo ti uto, wo in an tʼele soŋko gette a ɗoŋ an kʼede munɗa ye.» Wo an i-dʼorbite ɓaadaŋ a erewo gette. ");
INSERT INTO moz_vpl VALUES ("MK14_6","071_14_6","MRK","14","6","6","Wo ɗe Isa yʼa ruute, yʼede: «Erewo kun tʼoolo, kun i-tʼooɗe ulbutú ye, kono munɗa wede tʼo ize geŋ a nuŋ uŋse. ");
INSERT INTO moz_vpl VALUES ("MK14_7","071_14_7","MRK","14","7","7","Kane ɗoŋ an kʼede munɗa ye geŋ an lekka daayum ti kune, wo kun aane kun an dʼise beehiye aame kun dehu maŋ. Wo ɗe nuŋ ni ki lekka daayum ti kune ye. ");
INSERT INTO moz_vpl VALUES ("MK14_8","071_14_8","MRK","14","8","8","Todʼ tʼize munɗa wede a toogatú, todʼ tʼo di ƴirge egey ɗoŋ eeɗiyadaŋ uŋse a tuddó eŋ aakede ti nʼikkima ki poone an di nʼ tʼela adda muuzo. ");
INSERT INTO moz_vpl VALUES ("MK14_9","071_14_9","MRK","14","9","9","Ɗerec iŋkino wo nʼun di rooto: A omagi pay adda duniya an kizita Rabila Majjaanawa geŋ, erewo ette ɗuwo an tʼîda taaya a naabo ere todʼ tʼize, wo sundutú a ki danɗa ye.» ");
INSERT INTO moz_vpl VALUES ("MK14_10","071_14_10","MRK","14","10","10","Ziidas Iskariyot wede soo ti diine sanalliyagi kane koomat makumu sire geŋ, yʼiideʼŋ yʼa uuney kane deero ɗoŋ seɗeke kono yi dehu Isa yʼan di yʼ tʼela beezaŋ. ");
INSERT INTO moz_vpl VALUES ("MK14_11","071_14_11","MRK","14","11","11","Aame an illiga iŋkino maŋ, kane ulbaŋ a tʼize uŋse wo an i di ruute an i-tʼeela soŋko. Tʼume geŋ Ziidas yʼa iise dehutu kʼurzi wede kaŋ mummino yʼan di yʼ tʼela Isa a beezaŋ me. ");
INSERT INTO moz_vpl VALUES ("MK14_12","071_14_12","MRK","14","12","12","Onniyo ere ki poone ki tarnaape Yawudiyagi wede an dʼomɓo mappa daa kʼorme gette tʼa iina, todʼte onniyo ere an di walɗutu in̰n̰i damɓami an dʼisiyo omɓo ki tarnaape Pak ki Yawudiyagi. Aame geŋ sanalliyagi kʼIsa an di yʼ tunde, anʼde: «A too me ki dehu ay in dʼisey omɓo tarnaapayiŋ ki Pak te?» ");
INSERT INTO moz_vpl VALUES ("MK14_13","071_14_13","MRK","14","13","13","Maŋ Isa yi dʼigibe ɗoŋ sire ti diine sanalliyagí, wo yʼan di ruute, yʼede: «Kunʼdo kʼadda geeger, aame geŋ kun tʼikkimey ti wedusu yi tʼeezo ahu ti diŋgile, kun di yʼ daanoy ");
INSERT INTO moz_vpl VALUES ("MK14_14","071_14_14","MRK","14","14","14","bini adda ɓoy wede yʼa tʼettey. Wo kun tʼiidey maŋ, a wede ɓoy kun i di rootoy, kun dʼeesoy: “Wede dooyisadey yi ki tondiyo, too te biino ere yʼa ooma omɓo tarnaapayiŋ ki Pak ti sanalliyagí te?” ");
INSERT INTO moz_vpl VALUES ("MK14_15","071_14_15","MRK","14","15","15","Wo yoŋ biino yʼun di-kizey, todʼte dildil tʼawwa tʼekki bakatú, sulɗi pay adda okkime beehiye. Geŋ a ume gen̰n̰o kun in dʼisoy omɓo te.» ");
INSERT INTO moz_vpl VALUES ("MK14_16","071_14_16","MRK","14","16","16","Maŋ kane sanalliyagi an dʼiŋgile, an iideʼŋ adda geeger, sulɗi an diʼn uuney pay aakede Isa yʼan ruute, iŋkino omɓo tarnaape ki Pak an tʼize. ");
INSERT INTO moz_vpl VALUES ("MK14_17","071_14_17","MRK","14","17","17","A peeɗo tʼa tʼiire maŋ, Isa yʼa iina ti sanalliyagi kane koomat makumu sire geŋ me. ");
INSERT INTO moz_vpl VALUES ("MK14_18","071_14_18","MRK","14","18","18","Kane an di guune omɓo, wo aame an omɓo geŋ Isa yʼa ruute, yʼede: «Ɗerec iŋkino wo nʼun di rooto: Wede soo ti diinaguŋ ay omɓo kaŋ soo eŋ, yʼa ni tʼela bey ɗoŋ kʼolmiɗayó.» ");
INSERT INTO moz_vpl VALUES ("MK14_19","071_14_19","MRK","14","19","19","Kane sanalliyagi an tʼize sommagi dondoŋ, wo an di yʼiise tondiso, wede soŋ yi dʼeesiyo: «Nuuno ko, nuuno ko?» ");
INSERT INTO moz_vpl VALUES ("MK14_20","071_14_20","MRK","14","20","20","Yoŋ yʼan diʼn gime onamaŋ, yʼede: «Yoŋ wede soo ti diine kune ɗoŋ koomat makumu sire en̰n̰o, wede ay agisa beezey kaŋ soo adda kʼooko. ");
INSERT INTO moz_vpl VALUES ("MK14_21","071_14_21","MRK","14","21","21","Ɗerec, nuŋ wede an nʼehe aa ulo wede eŋ nʼa tʼinda, geŋ a-tʼetta a ono ɗoŋ an riiŋe ti kaaga adda mattup ki Raa a tukki nuuno. Wo ɗe dabar a yode wede i ni tʼela bey ɗoŋ kʼolmiɗayó, nuŋ wede an nʼehe aa ulo wede eŋ me! Yode geŋ, an ki yʼehe adda duniya ye toŋ bee!» ");
INSERT INTO moz_vpl VALUES ("MK14_22","071_14_22","MRK","14","22","22","Aame an omɓo geŋ, Isa yʼa tʼumɓe mappa, yʼa ruute koɗuwo a Raa kono kʼomɓo gette, maŋ yʼa ɓurke, yʼan dʼele sanalliyagí wo yʼa ruute, yʼede: «Ooho kun sooɗo, ette tuddó.» ");
INSERT INTO moz_vpl VALUES ("MK14_23","071_14_23","MRK","14","23","23","Saŋ yʼa tʼumɓe kop ti soɓo adda, yʼa ruute koɗuwo a Raa kono soɓo gette, maŋ yʼan dʼele, wede soŋ yi guume guume, ");
INSERT INTO moz_vpl VALUES ("MK14_24","071_14_24","MRK","14","24","24","wo yʼan di ruute, yʼede: «Ette puuzadó, puuzo ki taasuwa ere Raa yʼa ketta ti ɗuwo, to tʼoɓa ki ɗoŋ ɓaadaŋ. ");
INSERT INTO moz_vpl VALUES ("MK14_25","071_14_25","MRK","14","25","25","Ɗerec iŋkino wo nʼun di rooto: Nʼa tʼiiɓe ti aŋki, ki ɗaana ni ki siɓa ye baa toote kʼin̰n̰i bin̰, bini onniyo ere ni siɓa sey geŋ toote wede aware kʼin̰n̰i bin̰ a Moziko Raa.» ");
INSERT INTO moz_vpl VALUES ("MK14_26","071_14_26","MRK","14","26","26","Aame an tʼiimi an aa tʼiiɓe maŋ, an dʼûure ôrɗari tarnaape ki Pak, saŋ an tʼuɗɗe an dʼiŋgile kʼekki mokkolo kʼInda kʼOlibiye. ");
INSERT INTO moz_vpl VALUES ("MK14_27","071_14_27","MRK","14","27","27","Maŋ Isa yʼan di ruute a sanalliyagí, yʼede: «Kune pay kun di nʼ kiigira a munɗa wede aana geŋ me, kono ono eŋ an riiŋe ti kaaga adda mattup ki Raa, anʼde: “Wede kʼelso nʼa yi tʼîda, wo torɗo damɓami a-teepa.”» ");
INSERT INTO moz_vpl VALUES ("MK14_28","071_14_28","MRK","14","28","28","Isa yʼa ruute sey, yʼede: «Wo ɗe saŋ Raa yi ti nʼ bilɗa maŋ, nʼun dʼooguma kun di nʼ tʼooney a siiɗo Galile.» ");
INSERT INTO moz_vpl VALUES ("MK14_29","071_14_29","MRK","14","29","29","Maŋ Piyer yi di ruute, yʼede: «Aame ɗoŋ pay an ki giigira a munɗa wede aana toŋ, nuŋ ni ki kiigira ye.» ");
INSERT INTO moz_vpl VALUES ("MK14_30","071_14_30","MRK","14","30","30","Isa yi di ruute, yʼede: «Ɗerec iŋkino wo nʼa di rooto: Aŋki a diɗɗo ettiyo batum, ki poone uzu yʼa ôola bizí sire geŋ, kee kʼa roota ki ki nʼ suune ye, suune ye taŋ aɗo.» ");
INSERT INTO moz_vpl VALUES ("MK14_31","071_14_31","MRK","14","31","31","Wo ɗe Piyer yi koɗɗime, yʼede: «Ato, ni ki kiigira ye, aame ise kʼunto toŋ nʼa tʼinda ti kee!» Wo kane ɗoŋ soo toŋ an a-ti ruute iŋkino kay. ");
INSERT INTO moz_vpl VALUES ("MK14_32","071_14_32","MRK","14","32","32","Saŋ Isa ti sanalliyagí an dʼiiney a ume sundí Zesimaane, wo yʼan di ruute, yʼede: «Kun ti koona kino, koore nʼette nʼa tondey Raa geŋ me.» ");
INSERT INTO moz_vpl VALUES ("MK14_33","071_14_33","MRK","14","33","33","Maŋ ti yode yʼa-wiike Piyer, Zak wo Zaŋ. Aame geŋ orgiso tʼa yi ziiɗa wo ulbí i-dʼooɗiyo ɓaadaŋ. ");
INSERT INTO moz_vpl VALUES ("MK14_34","071_14_34","MRK","14","34","34","Yo yʼan di ruute, yʼede: «Nuŋ eŋ sommagi dondoŋ aa nʼa tʼinda, kun ti koona kino wo kun di lekko zeere.» ");
INSERT INTO moz_vpl VALUES ("MK14_35","071_14_35","MRK","14","35","35","Wo yo yʼa-liɗɗe dokki booloŋ ti kane me, maŋ yʼa tʼuttile zumayí a siiɗo, yʼa iise tondiyo Raa kono ise kotto maŋ dabar gette yi di ti leɗɗe ti tuddí me. ");
INSERT INTO moz_vpl VALUES ("MK14_36","071_14_36","MRK","14","36","36","Adda tondiyadí yʼede: «Abba, i-kaza Meegó, sulɗi pay a kee i-kʼoon̰e ye, ise maŋ kop ki dabar ette kʼo ti leɗɗo ti tuddó me. Wo too maŋ pay geŋ a ki tʼise aa nuŋ ni dehu ye, wo a tʼise aa kee ki dehu.» ");
INSERT INTO moz_vpl VALUES ("MK14_37","071_14_37","MRK","14","37","37","Saŋ yʼa-gime ki tukki sanalliyagi ɗoŋ aɗo gen̰n̰o, wo yiʼn uuna an udige. Maŋ Isa yʼa tʼinne Piyer wo yi di ruute, yʼede: «Simo, kee kʼudige! Ki peeɗo soo toŋ ki kʼiine ki ki likke zeere ye! ");
INSERT INTO moz_vpl VALUES ("MK14_38","071_14_38","MRK","14","38","38","Kun lekko zeere wo kun tondo Raa, kono kun ki tʼoora adda naamiya daggiya ye. Wede tudde geŋ a elkiyadí yi dehu yʼaase munɗa wede beehiye, wo ɗe tuddí toogatú baata.» ");
INSERT INTO moz_vpl VALUES ("MK14_39","071_14_39","MRK","14","39","39","Saŋ Isa yʼa-liɗɗe siidí sey, wo yʼa iise tondiyo Raa iŋkino sey. ");
INSERT INTO moz_vpl VALUES ("MK14_40","071_14_40","MRK","14","40","40","Maŋ yʼa-gime kʼume sanalliyagi, yiʼn uuna an urme, edayaŋ an ziiɗa moone. Wo munɗa an i-di roote toŋ an ki suune ye. ");
INSERT INTO moz_vpl VALUES ("MK14_41","071_14_41","MRK","14","41","41","Maŋ kʼaɗuwe Isa yʼa-gime ki tukki sanalliyagi wo yʼan di ruute, yʼede: «Kune kun moone pi, wo kun dʼudigo baa! Aŋkeŋ peeɗo tʼîide, sulɗi pay i tʼize, wo nuŋ wede an nʼehe aa ulo wede eŋ, an nʼele a bey ɗoŋ kʼolɗiko. ");
INSERT INTO moz_vpl VALUES ("MK14_42","071_14_42","MRK","14","42","42","Kun tʼoozo, in eŋgile! Kun wollo, wede i ni tʼela a bey ɗoŋ kʼolmiɗayó yi tʼuɗɗo.» ");
INSERT INTO moz_vpl VALUES ("MK14_43","071_14_43","MRK","14","43","43","Isa onamí yʼa ki tiʼn ɗiŋge ye ɓotto, a kaamiki Ziidas wede soo ti diine sanalliyagi kane koomat makumu sire geŋ, yi-tʼuɗɗo ti ɗoŋ duuru a itadí, a beyɗaŋ kasigara ti dalyagi. Kane geŋ iʼn igibo deero ɗoŋ seɗeke, ɗoŋ suuniyo kʼoogoro ti ɗoŋ i dokkiyo Yawudiyagi. ");
INSERT INTO moz_vpl VALUES ("MK14_44","071_14_44","MRK","14","44","44","Yo wede yʼan di yʼ tʼela Isa a bey ɗoŋ kʼolmiɗayí geŋ, yʼan di ruuto ɗoŋ duuru a munɗa wede yʼaasey kono an di suuney eŋ Isa me, yʼede: «Wede kun wulley ni izey puuc a toɓɓisadí maŋ, geŋ yode kun di yʼ sooɗoy, kun di dʼeŋgiloy, kun di boohoy koɗuwo.» ");
INSERT INTO moz_vpl VALUES ("MK14_45","071_14_45","MRK","14","45","45","Ziidas yʼiina maŋ, kesiko yʼa yʼ zikke Isa kaɓɓaŋ wo yi di ruute, yʼede: «Wede dooyisadó!» Maŋ yi dʼize puuc a toɓɓisadí. ");
INSERT INTO moz_vpl VALUES ("MK14_46","071_14_46","MRK","14","46","46","Iŋkino maŋ kane ɗoŋ duuru an dʼiiziga tuddí, an di yʼ ziiɗa. ");
INSERT INTO moz_vpl VALUES ("MK14_47","071_14_47","MRK","14","47","47","Aame geŋ wede soo ti diine sanalliyagi yʼa tʼiiɗiba kasigaradí, yʼa-diikiɗa wede naabo ki mozigo goole ɗoŋ seɗeke, kuudí a ɗikke. ");
INSERT INTO moz_vpl VALUES ("MK14_48","071_14_48","MRK","14","48","48","Wo Isa yʼa tʼihina bizí, yʼan di ruute, yʼede: «Ɗe ki moo me kun dʼettiyo seeɗuzó wo tudduguŋ kun tʼikkimo ti kasigaryagi wo ti dalyagi, aa nuŋ wede kʼoogire me? ");
INSERT INTO moz_vpl VALUES ("MK14_49","071_14_49","MRK","14","49","49","Para maŋ nuŋ miŋ daayum ti kune, ni dooyiso a booro Ɓoy Raa wo kun gi di nʼ ziiɗa ye. Wo ɗe sulɗi geŋ a iina kono a-tʼette a ono ɗoŋ an riiŋe ti kaaga adda mattup ki Raa.» ");
INSERT INTO moz_vpl VALUES ("MK14_50","071_14_50","MRK","14","50","50","Maŋ kane sanalliyagi pay an di yʼiili, an tʼumbe. ");
INSERT INTO moz_vpl VALUES ("MK14_51","071_14_51","MRK","14","51","51","Wo i dʼede obulsu yi-daaniya Isa, yʼa diibo miŋ parde ɗaŋŋalaŋ a tuddí me. Ɗuwo an dehu an di yʼ seeɗa, ");
INSERT INTO moz_vpl VALUES ("MK14_52","071_14_52","MRK","14","52","52","wo ɗe yʼan di buuye pardayí a beezaŋ, yʼa tʼumbe bontilin̰. ");
INSERT INTO moz_vpl VALUES ("MK14_53","071_14_53","MRK","14","53","53","Isa an di tʼiide kʼadda ɓoy mozigo goole ɗoŋ seɗeke, a ume wede kane deero ɗoŋ seɗeke, ɗoŋ i dokkiyo Yawudiyagi ti ɗoŋ suuniyo kʼoogoro an tʼugiye pay. ");
INSERT INTO moz_vpl VALUES ("MK14_54","071_14_54","MRK","14","54","54","Wo Piyer yi di yʼ daaniya Isa ti dokki, bini yʼa iiney ɓoy ki mozigo goole ɗoŋ seɗeke, maŋ yi-tʼiide yʼa-guune a booro ti ɗoŋ naabo, an di kookiyo uwwo. ");
INSERT INTO moz_vpl VALUES ("MK14_55","071_14_55","MRK","14","55","55","Kane deero booro Yawudiyagi pay ti deero ɗoŋ seɗeke, an di dehutu wede a roote ono a tukkʼIsa kono booro tʼa yi seeɗa ki tôwwadí, miŋ umbo an kʼooniyo ye. ");
INSERT INTO moz_vpl VALUES ("MK14_56","071_14_56","MRK","14","56","56","Ɗoŋ ɓaadaŋ an iideʼŋ an di ruutite ono butte a tukki yode, wo ɗe onamaŋ aa ki tʼettiyo kaŋ soo ye. ");
INSERT INTO moz_vpl VALUES ("MK14_57","071_14_57","MRK","14","57","57","Maŋ ɗoŋ miibi an tʼiiziga an di ruute ono butte a tukki yode, anʼde: ");
INSERT INTO moz_vpl VALUES ("MK14_58","071_14_58","MRK","14","58","58","«Ay yʼilliga yi ruute, Ɓoy Raa wede ɗuwo an iiziga eŋ yʼa kossita, wo adda kʼonniyo aɗo yʼa yʼooziga a kʼisa ɓoy wede i kʼiiziga ɗuwo ye.» ");
INSERT INTO moz_vpl VALUES ("MK14_59","071_14_59","MRK","14","59","59","Wo tʼurzi kʼono gen̰n̰o toŋ onamaŋ aa ki tʼettiyo kaŋ soo ye. ");
INSERT INTO moz_vpl VALUES ("MK14_60","071_14_60","MRK","14","60","60","Iŋkino maŋ mozigo goole ɗoŋ seɗeke yʼa tʼiiziga a ɗaana ɗoŋ i tʼugiye, wo yʼa tunde Isa, yʼede: «Ono ɗuwo an rootiyo a tukki kee eŋ, kee ki ki roote munɗa ye ko?» ");
INSERT INTO moz_vpl VALUES ("MK14_61","071_14_61","MRK","14","61","61","Wo yo Isa yi dʼannugu ɗeɗɗek, yʼan ki rootiyo munɗa ye. Maŋ mozigo goole ɗoŋ seɗeke yʼa yi tunde sey, yʼede: «Kee Almasi Raa yi biire, wo Ulo ki Raa wede ɗuwo an di tamma ko?» ");
INSERT INTO moz_vpl VALUES ("MK14_62","071_14_62","MRK","14","62","62","Isa yi diʼn gime onamí, yʼede: «Eyye nuuno, wo kun di nʼ wolla nuŋ wede an nʼehe aa ulo wede eŋ, nʼa-kooney a ammade Raa toogadí tʼa jiire pay, wo kun di nʼ wolla nʼa-kimo ekki dondari a kandaane.» ");
INSERT INTO moz_vpl VALUES ("MK14_63","071_14_63","MRK","14","63","63","Iŋkino maŋ mozigo goole ɗoŋ seɗeke yi-ti gulkuwe, kallagí yʼa zittite, wo yʼa ruute, yʼede: «In ki dehe wenɗa ti doolo wede illiga yʼin ki roote sey ye baa! ");
INSERT INTO moz_vpl VALUES ("MK14_64","071_14_64","MRK","14","64","64","Kun illiga ti kuuduguŋ yi gilɗe suma Raa te. Kune elkiyaguŋ moo me?» Maŋ kane pay geŋ an di ruute, anʼde: «Booro ti yʼ ziiɗa, munɗa wede yoŋ yʼize eŋ i-îide ki tôwwo.» ");
INSERT INTO moz_vpl VALUES ("MK14_65","071_14_65","MRK","14","65","65","Ɗoŋ oŋgo ti diinayaŋ an dʼiise paɗɗita lee a tuddí. Edayí an i-tʼippe, an di gohiso kutuba wo an dʼeesiyo: «Kee nebi maŋ, ki yʼunto wede i kʼize me!» Maŋ kane asigiryagi an di yʼ ɓattisa. ");
INSERT INTO moz_vpl VALUES ("MK14_66","071_14_66","MRK","14","66","66","Aame Piyer yoŋ ti ɗanɗi a booro ki paate geŋ, ere soo ti diine ɗoŋ naabo mozigo goole ɗoŋ seɗeke ti-tʼuɗɗo. ");
INSERT INTO moz_vpl VALUES ("MK14_67","071_14_67","MRK","14","67","67","Tode gette Piyer tʼa yi wulle yi kookiyo uwwo, ti ti yʼ wulle ti ti yʼ ɗiŋge maŋ, ti di ruute, tʼede: «Kee toŋ ti Isa wede ti geeger Nazaret, kune soo.» ");
INSERT INTO moz_vpl VALUES ("MK14_68","071_14_68","MRK","14","68","68","Wo Piyer yʼa yi giigira, yʼa ruute, yʼede: «Koŋ munɗa wede mi rootiyo geŋ ni ki yʼ suune ye, wo itadí toŋ ni ki ti suune ye!» Maŋ ti booro ɓoy yʼa tʼiiziga, yʼa tʼiide biza bumɓu. Aame geŋ uzu yʼa iise môolo. ");
INSERT INTO moz_vpl VALUES ("MK14_69","071_14_69","MRK","14","69","69","Wo to ere naabo gette tʼa yi wulle sey, tʼan dʼiise rootiyo a kane ɗoŋ a sirpatú, tʼede: «Yoŋ wedusu eŋ ti diine kane sanalliyagi kʼIsa.» ");
INSERT INTO moz_vpl VALUES ("MK14_70","071_14_70","MRK","14","70","70","Wo Piyer yʼa yi giigira sey. Taŋ booloŋ maŋ kane ɗoŋ a sirpadí geŋ an i di ruute sey, anʼde: «Ki kotto kee wede soo ti diine kane sanalliyagi kʼIsa, kono kee toŋ ti siiɗo Galile.» ");
INSERT INTO moz_vpl VALUES ("MK14_71","071_14_71","MRK","14","71","71","Iŋkino maŋ Piyer yʼa-ti nîime tuddí, yʼede: «Wede kun rootiyo eŋ ni ki yʼ suune ye! Para maŋ ono ɗoŋ ni rootiyo eŋ ɗerec ye maŋ, a golladó!» ");
INSERT INTO moz_vpl VALUES ("MK14_72","071_14_72","MRK","14","72","72","Wo a kaamiki uzu yʼa îile ki sirwe. Aame geŋ Piyer yʼa ilke a ono ɗoŋ Isa yi-ruute, yʼede: «Ki poone uzu yʼa ôola bizí sire geŋ, kʼa roota ki ki nʼ suune ye, suune ye taŋ aɗo.» Iŋkino maŋ yʼa iise môolo. ");
INSERT INTO moz_vpl VALUES ("MK15_1","071_15_1","MRK","15","1","1","A biza soohe maŋ, kane deero booro Yawudiyagi pay, deero ɗoŋ seɗeke, ɗoŋ i dokkiyo Yawudiyagi ti ɗoŋ suuniyo kʼoogoro, an tʼugiye an di ruute onamaŋ kaŋ soo. Maŋ Isa an ti yʼ gittite, tiŋ geŋ an di tʼiide, an i di yʼele a bey Pilat, yoŋ Romeŋ goole siiɗo. ");
INSERT INTO moz_vpl VALUES ("MK15_2","071_15_2","MRK","15","2","2","Pilat yʼa yi tunde, yʼede: «Kee mozigo Yawudiyagi ko?» Isa yi diʼn gime onamí, yʼede: «Geŋ aa ki rootiyo.» ");
INSERT INTO moz_vpl VALUES ("MK15_3","071_15_3","MRK","15","3","3","Kane deero ɗoŋ seɗeke geŋ, wede tuuku toŋ yi rootiyo ono a eedí eedí. ");
INSERT INTO moz_vpl VALUES ("MK15_4","071_15_4","MRK","15","4","4","Maŋ Pilat yʼa yi tunde sey, yʼede: «Kee ki ki roote munɗa ye ko? Ki kʼollige ko ono ɗoŋ pay an rootiyto a tukki kee eŋ me?» ");
INSERT INTO moz_vpl VALUES ("MK15_5","071_15_5","MRK","15","5","5","Wo ɗe Isa yi dʼannugu ɗeɗɗek. Pilat yi wulle iŋkino maŋ, yʼa ziiɗa giggirí. ");
INSERT INTO moz_vpl VALUES ("MK15_6","071_15_6","MRK","15","6","6","Aa daayum Pilat yi dʼisiyo a tarnaape Pak maŋ, yʼan dʼaɗɗiya tʼadda daŋgay wedusu soo wede ɗoŋ duuru an dehu. ");
INSERT INTO moz_vpl VALUES ("MK15_7","071_15_7","MRK","15","7","7","Wo aame geŋ adda daŋgay, i dʼede wede soo sundí Barabas ti ɗoŋ doolo kaŋ soo an an tʼelite ono a ɗuwo an dʼiiziga ɗeyyiso ki tukki Romeŋ. Kane anʼni ziɗɗe kono aame an iiziga ɗeyyiso geŋ an tʼîide wedusu. ");
INSERT INTO moz_vpl VALUES ("MK15_8","071_15_8","MRK","15","8","8","Iŋkino ɗoŋ duuru an tʼiide di Pilat wo an di yʼ tunde, yʼan dʼise munɗa wede aa daayum yi dʼisiyo. ");
INSERT INTO moz_vpl VALUES ("MK15_9","071_15_9","MRK","15","9","9","Maŋ Pilat yʼan di ruute, yʼede: «Kun dehu miŋ nʼun tʼaɗɗo mozigo Yawudiyagi ko?» ");
INSERT INTO moz_vpl VALUES ("MK15_10","071_15_10","MRK","15","10","10","Pilat yi rootiyo iŋkino kono yi suune, kane deero ɗoŋ seɗeke Isa an i yʼele beezí kono an kolɓiso ti yode. ");
INSERT INTO moz_vpl VALUES ("MK15_11","071_15_11","MRK","15","11","11","Wo ɗe kane deero ɗoŋ seɗeke an an tʼelite ono a ɗoŋ duuru an dʼiyye an di roote Pilat yʼan tʼaɗɗe Barabas. ");
INSERT INTO moz_vpl VALUES ("MK15_12","071_15_12","MRK","15","12","12","Iŋkino maŋ Pilat yʼa tunde ɗoŋ duuru sey, yʼede: «Ɗe wede kun yi waaku mozigo Yawudiyagi geŋ, kun dehu ni-dʼise mummino me?» ");
INSERT INTO moz_vpl VALUES ("MK15_13","071_15_13","MRK","15","13","13","Wo kane an dʼiise ɗollite, anʼde: «Ki ti yʼ taako ekkʼundumu wede zaapu tʼekki bakadí kaŋ tontilko!» ");
INSERT INTO moz_vpl VALUES ("MK15_14","071_15_14","MRK","15","14","14","Maŋ Pilat yʼan di ruute, yʼede: «Ɗe munɗa ulsu miŋ yʼize moo me?» Wo ɗe kane an di ɗollite ɓaadaŋ ki ɓaadaŋ, anʼde: «Ki ti yʼ taako ekkʼundumu wede zaapu tʼekki bakadí kaŋ tontilko!» ");
INSERT INTO moz_vpl VALUES ("MK15_15","071_15_15","MRK","15","15","15","Kono adde ɗoŋ duuru a tʼasse geŋ, Pilat yʼan di yʼuɗɗe Barabas me, wo yʼan di ruute a asigiryagi Isa an ti yʼ girpipe ti marpa. Saŋ yʼan di yʼele an ti yʼ taakey ekkʼundumu wede zaapu tʼekki bakadí kaŋ tontilko. ");
INSERT INTO moz_vpl VALUES ("MK15_16","071_15_16","MRK","15","16","16","Iŋkino maŋ kane asigiryagi an di-tʼiide Isa kʼadda ɓoy ki goole siiɗo, wo eebaŋ asigiryagi ti doolo toŋ ɓaadaŋ an a-tiʼn wiiko pay. ");
INSERT INTO moz_vpl VALUES ("MK15_17","071_15_17","MRK","15","17","17","An dʼumɓe kalle wede goole teeze an i di tʼusse, wo an di gini kaɗumul kʼahimagi an i-tʼusse eedí. ");
INSERT INTO moz_vpl VALUES ("MK15_18","071_15_18","MRK","15","18","18","Maŋ an i dʼiise isiyo toose, an tettiso beezaŋ, an dʼeesiyo: «Toosadá mozigo Yawudiyagi no! Toosadá mozigo Yawudiyagi no!» ");
INSERT INTO moz_vpl VALUES ("MK15_19","071_15_19","MRK","15","19","19","An di yʼoggiso a eedí ti koƴile, an di paɗɗita lee a tuddí, wo an di dikkiyto, an dʼottilso a ɗaanadí. ");
INSERT INTO moz_vpl VALUES ("MK15_20","071_15_20","MRK","15","20","20","Aame an ti yʼukke maade maŋ, kalle wede goole teeze an tʼiiɗiba wo an i di tʼusse kallagí. Maŋ Isa an ti yʼ dukke, an di tʼette kono an ti yʼ taakey ekkʼundumu wede zaapu tʼekki bakadí kaŋ tontilko. ");
INSERT INTO moz_vpl VALUES ("MK15_21","071_15_21","MRK","15","21","21","A aɗɗiyadaŋ ti geeger, an a-tʼikkima ti wede soo iŋkino yʼaahiya doome, yoŋ ti geeger Sireŋ, sundí Simo. Yoŋ geŋ meekʼ Alegzandire ti Ripis. Asigiryagi an di yʼize ki toogo yʼa tʼumɓe undumu taakiya kʼIsa. ");
INSERT INTO moz_vpl VALUES ("MK15_22","071_15_22","MRK","15","22","22","Wo an di tʼiide Isa kʼume wede sundí Golgota, i-kaza ume aa osse kʼeego. ");
INSERT INTO moz_vpl VALUES ("MK15_23","071_15_23","MRK","15","23","23","A ume geŋ, a Isa an i dʼeele toote kʼin̰n̰i bin̰ kalsiya ti dunnu sundí mirr, miŋ yʼa-tuuge ki soɓo me. ");
INSERT INTO moz_vpl VALUES ("MK15_24","071_15_24","MRK","15","24","24","Kane asigiryagi an ti yʼ tiike ekkʼundumu wede zaapu tʼekki bakadí kaŋ tontilko, wo kallagí an di dikkiɗa tʼurzi kʼarɓu teltel muntelliyo, a wede tuuku i tʼooriyo yi tʼamɓu tʼamɓu. ");
INSERT INTO moz_vpl VALUES ("MK15_25","071_15_25","MRK","15","25","25","Isa an ti yʼ tiike ekkʼundumu geŋ, a peeɗo tʼize kʼaaɗumu mesuwe. ");
INSERT INTO moz_vpl VALUES ("MK15_26","071_15_26","MRK","15","26","26","Ekkʼundumu an tiike pakirte eego wo an a-ti riiŋe, anʼde: «Yoŋ mozigo Yawudiyagi.» Geŋ munɗa wede i-dʼîide untadí. ");
INSERT INTO moz_vpl VALUES ("MK15_27","071_15_27","MRK","15","27","27","Wo a sirpadí an a-tiike ɗoŋ kʼoogire sire, soŋ tʼundumzí a kese kʼammidadí, wo wede soŋ tʼundumzí a kese geeladí.  ");
INSERT INTO moz_vpl VALUES ("MK15_28","071_15_28","MRK","15","28","28","Geŋ a-tʼiide a ono ɗoŋ an riiŋe ti kaaga adda mattup ki Raa, anʼde: «Yoŋ an ti yi gize ti ɗoŋ kʼolɗiko.» ");
INSERT INTO moz_vpl VALUES ("MK15_29","071_15_29","MRK","15","29","29","Ɗoŋ aɗɗiya tiŋ gen̰n̰o, an di yʼ kalɗita wo an ɗeŋilso eedaŋ, wo an dʼeesiyo: «Eeyu, kee wede kʼede Ɓoy Raa kʼa kossita wo adda kʼonniyo aɗo kʼa yʼooziga geŋ, ");
INSERT INTO moz_vpl VALUES ("MK15_30","071_15_30","MRK","15","30","30","kʼutto tuddá batum wo tʼekkʼundumu wede zaapu tʼekki bakadí kaŋ tontilko, ki ti ɗeegi!» ");
INSERT INTO moz_vpl VALUES ("MK15_31","071_15_31","MRK","15","31","31","Kane deero ɗoŋ seɗeke ti ɗoŋ suuniyo kʼoogoro toŋ an di yʼokko maade kay, wo an di rootiyto ti tuddaŋ, anʼde: «Yoŋ ɗoŋ doolo yʼan diʼn utte miŋ, yi kʼaane tuddí batum yi ki tʼutte ye! ");
INSERT INTO moz_vpl VALUES ("MK15_32","071_15_32","MRK","15","32","32","Yoŋ Almasi Raa yi biire, wo mozigo ki ɗoŋ kʼIzirayel kotto maŋ, aŋken̰n̰o tʼekkʼundumu geŋ yi ti ɗeegi! Ay wulla yi ti ɗiiga maŋ, kaye ay zaapa addey a yode.» Kane ɗoŋ an tiike a sirpadí toŋ, an di yʼ kalɗita iŋkino kay. ");
INSERT INTO moz_vpl VALUES ("MK15_33","071_15_33","MRK","15","33","33","Tʼume peeɗo tʼize diine geŋ, adda siiɗo pay ume a tʼize zimolo dil a likke bini eesiyo peeɗo lohe. ");
INSERT INTO moz_vpl VALUES ("MK15_34","071_15_34","MRK","15","34","34","A eesiyo peeɗo lohe maŋ, Isa yʼa iɗili ti golla awwa, yʼede: «Eli, Eli, lama sabaktani.» Geŋ i-kaza: «Raa ki nuŋ, Raa ki nuŋ, moo me ki ni giigira me?» ");
INSERT INTO moz_vpl VALUES ("MK15_35","071_15_35","MRK","15","35","35","Ɗoŋ oŋgo ti diine ɗoŋ i lekkiyo aŋgen̰n̰o geŋ an dʼilliga wo an di ruute, anʼde: «Kun ollo kay, yi waaku nebi Eli.» ");
INSERT INTO moz_vpl VALUES ("MK15_36","071_15_36","MRK","15","36","36","Wede soo ti diinayaŋ yʼa ukke yi dʼumɓe sooso, yi di zulpe adda toote suddo kʼin̰n̰i kʼinda bin̰, maŋ yi-tʼele a biza koƴile, yi-tʼusse bize kʼIsa yʼa suuƴe, wo yʼa ruute, yʼede: «Kun dello, in gi di wolla ɗo Elizi wenɗa yi etto, yi ti yʼ ɗeega maŋ.» ");
INSERT INTO moz_vpl VALUES ("MK15_37","071_15_37","MRK","15","37","37","Wo ɗe Isa yʼa iɗili ti golla awwa, maŋ yʼa-tʼihe. ");
INSERT INTO moz_vpl VALUES ("MK15_38","071_15_38","MRK","15","38","38","Aame geŋ alboy wede i ɗikke adde Ɓoy Raa soŋ kʼadda soŋ ki paate geŋ, a tʼîhina tar tʼawwa a ti ɗiige les. ");
INSERT INTO moz_vpl VALUES ("MK15_39","071_15_39","MRK","15","39","39","Goole kʼasigiryagi meeda ki Romeŋ yi tʼîhira ɗaana kʼIsa, yi wulle untadí te, maŋ yʼa ruute, yʼede: «Wede eŋ Ulo Raa ki kotto!» ");
INSERT INTO moz_vpl VALUES ("MK15_40","071_15_40","MRK","15","40","40","A ume geŋ i dʼede erayi toŋ ede, kane an tʼîhirte ti dokki an di wolliyo munɗa wede isiyo. Ti diinayaŋ i dʼede Mariyam ere ti siiɗo Magdalla, Mariyam mekki Zak wede n̰eŋku ti Zoz, wo soo te Salome. ");
INSERT INTO moz_vpl VALUES ("MK15_41","071_15_41","MRK","15","41","41","Kane erayi geŋ an daaniya Isa wo an i di naabiya aame yoŋ a siiɗo Galile. An di gili ti yode ki Zeruzalem, wo erayi ti doolo toŋ ɓaadaŋ an iido ti kane me. ");
INSERT INTO moz_vpl VALUES ("MK15_42","071_15_42","MRK","15","42","42","Sulɗi geŋ ize onniyo jima, ɗuwo an okkime tuddaŋ kono onniyo ere ki puukiyo Yawudiyagi ti tʼeesa. A peeɗo tʼette kʼooriyo maŋ, ");
INSERT INTO moz_vpl VALUES ("MK15_43","071_15_43","MRK","15","43","43","wede soo ti geeger kʼArimate sundí Yusup yʼa iina. Yode toŋ maŋ wede goole ti diine ɗoŋ deero booro Yawudiyagi, wo yi zaapu elkisadí a ettiyo Moziko Raa kay. Yʼa iiɓe edayí, yʼa uuney Pilat, yʼa tunde nuune kʼIsa kono yʼa tʼottiba. ");
INSERT INTO moz_vpl VALUES ("MK15_44","071_15_44","MRK","15","44","44","Aame Pilat yʼilliga Isa yʼinda baa maŋ, yʼa ziiɗa giggirí. Iŋkino yʼa wiike goole kʼasigiryagi meeda, yʼa yi tunde, yʼede: «Isa yʼinda ti kaagine ko?» ");
INSERT INTO moz_vpl VALUES ("MK15_45","071_15_45","MRK","15","45","45","Aame goole kʼasigiryagi meeda yi-ti ruute maŋ, yi dʼiili urzi a Yusup yʼa tʼamɓe nuune kʼIsa me. ");
INSERT INTO moz_vpl VALUES ("MK15_46","071_15_46","MRK","15","46","46","Yusup yi dʼiwila sotor tuwarwa, nuuneʼŋ yʼa ti yʼ ɗiige tʼekki undumu wede zaapu tʼekki bakadí kaŋ tontilko me. Wo yʼa n̰ilpe ti sotor gettiyo, yi-tʼele adda muuzo, todʼte aa urmi an ittiba mokkolo. Maŋ yʼa-ti ɗuŋkile a biza muuzo zumbulu yeepiyo. ");
INSERT INTO moz_vpl VALUES ("MK15_47","071_15_47","MRK","15","47","47","Aame geŋ Mariyam ere ti siiɗo Magdalla wo Mariyam mekki Zoz, kane geŋ an di wolliyo ume an ele nuune kʼIsa me. ");
INSERT INTO moz_vpl VALUES ("MK16_1","071_16_1","MRK","16","1","1","Onniyo ere ki puukiyo Yawudiyagi i tʼiŋgile. Aame geŋ Mariyam ere ti siiɗo Magdalla, Mariyam mekki Zak, wo soo te Salome an tʼiide, an dʼiwilo egey ɗoŋ eeɗiyadaŋ uŋse kono an i-tʼassigey tukkʼIsa. ");
INSERT INTO moz_vpl VALUES ("MK16_2","071_16_2","MRK","16","2","2","Ti soohe a onniyo dumas, peeɗo ti-gilo maŋ, an dʼiŋgile ki biza muuzo. ");
INSERT INTO moz_vpl VALUES ("MK16_3","071_16_3","MRK","16","3","3","Wo a urzi an di rootiyto ti tuddaŋ, anʼde: «Ɗe zumbulu a biza muuzo geŋ in ti yʼ ɗoŋkiley wee wee?» ");
INSERT INTO moz_vpl VALUES ("MK16_4","071_16_4","MRK","16","4","4","Wo an iiney maŋ, an wolliyo zumbulu goole an a tʼippe a biza muuzo geŋ ɗoŋkilso a kese. ");
INSERT INTO moz_vpl VALUES ("MK16_5","071_16_5","MRK","16","5","5","Kane an tʼiide kʼadda muuzo, wo an wolliyo obulsu ti kalle tuware yi-guune a kese kʼammade. Aame geŋ kane orgiso tʼanni ziiɗa ɓaadaŋ. ");
INSERT INTO moz_vpl VALUES ("MK16_6","071_16_6","MRK","16","6","6","Wo ɗe wede geŋ yʼan di ruute, yʼede: «Kun orgiɗe ye. Ni suune kun dehu Isa wede ti geeger Nazaret, wede an ti yʼ tiike ekkʼundumu wede zaapu tʼekki bakadí kaŋ tontilko me. Yoŋ geŋ Raa yi ti yʼ bilɗe, yoŋ a en̰n̰o ye. En̰n̰o kun wollo ume an ziipe nuunayí me. ");
INSERT INTO moz_vpl VALUES ("MK16_7","071_16_7","MRK","16","7","7","Aŋkeŋ kunʼdo, kun an ti kazoy a sanalliyagí wo a Piyer pây, kun dʼeesoy: “Yoŋ yʼunni delliyo a siiɗo Galile. A ume geŋ kun di yʼ wolley, aakede yʼun di ruute.”» ");
INSERT INTO moz_vpl VALUES ("MK16_8","071_16_8","MRK","16","8","8","Iŋkino maŋ tʼadda muuzo an tʼuɗɗe, an di ŋoŋŋirso burbur eedaŋ a digge, an tʼumbe dokki. Wo munɗa a wenɗa soo toŋ an i-ki ruute ye kono orgiso tʼanni ziiɗa.  ");
INSERT INTO moz_vpl VALUES ("MK16_9","071_16_9","MRK","16","9","9","Onniyo dumas ti soohe walak Isa yi bilɗe maŋ, ki poone yʼa gize tuddí a Mariyam ti siiɗo Magdalla, tode ere yi dʼilmo siitanɗani sarat tʼettú. ");
INSERT INTO moz_vpl VALUES ("MK16_10","071_16_10","MRK","16","10","10","Tode gette tʼan dʼiide rabila a ɗoŋ i likke ti yode, kane an tʼize sommagi dondoŋ an isiyo môolo. ");
INSERT INTO moz_vpl VALUES ("MK16_11","071_16_11","MRK","16","11","11","Wo aame an illiga tʼan ruute Isa yoŋ zeere ti yi wullo toŋ, onamtú an ki dʼumɓe ye. ");
INSERT INTO moz_vpl VALUES ("MK16_12","071_16_12","MRK","16","12","12","Saŋ maŋ Isa yʼan ti gize tuddí tʼurzi doolo, aame geŋ an dʼikkima ti sanalliyagi kane sire an amɓe kʼadda kʼille ti paate. ");
INSERT INTO moz_vpl VALUES ("MK16_13","071_16_13","MRK","16","13","13","Kane sanalliyagi sire geŋ an di-gime ki Zeruzalem, an an tʼîide taaya a ɗoŋ oŋgo, wo toŋ maŋ onamaŋ an ki dʼumɓe ye pây. ");
INSERT INTO moz_vpl VALUES ("MK16_14","071_16_14","MRK","16","14","14","Saŋ maŋ Isa yʼan di gize tuddí a sanalliyagi kane koomat makumu soo, an ti guune omɓo. Aame geŋ yʼan diʼn iise aapuɗu, yʼede: «Zaapu kʼadduguŋ a nuŋ umbo, biza kʼulbuguŋ zakiɗi, kono ɗoŋ an ni wulle ni bilɗe an un kaza toŋ, kun kʼamɓu onamaŋ ye!» ");
INSERT INTO moz_vpl VALUES ("MK16_15","071_16_15","MRK","16","15","15","Maŋ yʼan di ruute, yʼede: «Kunʼdo kʼadda duniya pay, kun an kazitoy Rabila Majjaanawa a ɗuwo pay. ");
INSERT INTO moz_vpl VALUES ("MK16_16","071_16_16","MRK","16","16","16","Wede yi ziipa addí a Isa wo an ti yʼ zuyya batem maŋ, Raa yʼa yʼutta. Wo ɗe wede yi ki ziipa addí a Isa ye maŋ, booro Raa tʼa yi seeɗa. ");
INSERT INTO moz_vpl VALUES ("MK16_17","071_16_17","MRK","16","17","17","Ɗoŋ i zaapa addaŋ a nuŋ geŋ, en̰n̰o sulɗi kʼarmika an dʼisa a kiza toogo Raa ti kane me: an di limmita siitanɗani ti sundó, an dʼorba tʼono ɗoŋ doolo. ");
INSERT INTO moz_vpl VALUES ("MK16_18","071_16_18","MRK","16","18","18","An seɗɗa mimbayi ti beyɗaŋ, an siɓa inda kʼunto toŋ, munɗa soo toŋ i kiʼn isa ye. An di zaapa beezaŋ a tukki ɗoŋ kʼeeni, wo kane geŋ an tʼoona bee.» ");
INSERT INTO moz_vpl VALUES ("MK16_19","071_16_19","MRK","16","19","19","Aame Galmeega Isa yʼan ti ruute iŋkino maŋ, Raa yʼa yʼumɓe kʼawwa ki kandaane, yʼa-guune a ammade Raa. ");
INSERT INTO moz_vpl VALUES ("MK16_20","071_16_20","MRK","16","20","20","Wo kane sanalliyagi an di tiipe kʼadda duniya pay kazita Rabila Majjaanawa. Wo Galmeega ti kane, yʼan diʼn noogiyo ti sulɗi kʼarmika, i-kaza onamaŋ geŋ ɗerec.");
INSERT INTO moz_vpl VALUES ("LK1_1","072_1_1","LUK","1","1","2","Teyopil meeʼki nuŋ, ɗoŋ oŋgo an wulle tʼedayaŋ sulɗi ɗoŋ Raa yʼize tʼume kʼeesiyo a diinayiŋ me. Saŋ kane an tʼize ɗoŋ kazita kʼono wo an in tʼîide taaya a sulɗi geŋ me, maŋ ɗoŋ ɓaadaŋ ti diinayiŋ an dʼiise raaŋiya ki taaya gettiyo. ");
INSERT INTO moz_vpl VALUES ("LK1_3","072_1_3","LUK","1","3","3","Wo aame ni ziɗɗe ita mekkʼono a sulɗi ɗoŋ pay ize tʼume kʼeesiyo gen̰n̰o maŋ, Teyopil nuŋ toŋ o dʼize uŋse nʼa di raaŋe a kee ita ki sulɗi geŋ, soŋ kʼita bakadí bakadí. ");
INSERT INTO moz_vpl VALUES ("LK1_4","072_1_4","LUK","1","4","4","Nuŋ nʼa raaŋiya kono kʼa suune beehiye, dooyiso ere an ki duuye gette todʼte ɗerec. ");
INSERT INTO moz_vpl VALUES ("LK1_5","072_1_5","LUK","1","5","5","A ozzinagi ɗoŋ Erod yoŋ mozigo ki siiɗo Ziide, i dʼede wede seɗeke sundí Zakari, yoŋ geŋ ti diine ɗoŋ seɗeke ɗoŋ kʼAbbiya. Wo to eddí sundutú Elizabet, ti ita kʼin̰n̰i kʼAroŋ mozigo goole ɗoŋ seɗeke. ");
INSERT INTO moz_vpl VALUES ("LK1_6","072_1_6","LUK","1","6","6","Kane geŋ sirwaŋ pay ki diine a ɗaana Raa, an ollige onamí wo an sooru a urzi wede pay kʼoogoro ki Galmeega Raa, ɗuwo an an ki zaapu ono a eedaŋ ye. ");
INSERT INTO moz_vpl VALUES ("LK1_7","072_1_7","LUK","1","7","7","Wo kane ulo an kʼede ye kono Elizabet todʼte karta, kane sirwaŋ pay an ti gûulike. ");
INSERT INTO moz_vpl VALUES ("LK1_8","072_1_8","LUK","1","8","8","Onniyo soo Zakari yʼa tʼiide kʼadda Ɓoy Raa isiyo naabo ki seɗeke, kono iina a kaaɓadaŋ an dʼise. ");
INSERT INTO moz_vpl VALUES ("LK1_9","072_1_9","LUK","1","9","9","A urzi kʼoogoro, kane ɗoŋ seɗeke an tʼize teltel muntelliyo maŋ, i-tʼiire a yode a ogge sulɗi koddiyo eeɗiyadaŋ uŋse adda Ɓoy Galmeega Raa wede kʼadda me. ");
INSERT INTO moz_vpl VALUES ("LK1_10","072_1_10","LUK","1","10","10","A peeɗo ere an dʼoggiyo sulɗi koddiyo eeɗiyadaŋ uŋse, kane ɗoŋ duuru pay ti paate an tondiyo Raa. ");
INSERT INTO moz_vpl VALUES ("LK1_11","072_1_11","LUK","1","11","11","A kaamiki, maaleeka ki Galmeega Raa yʼa iide tukki Zakari, wo yʼa tʼîhira a kese kʼammade ki munɗa aa sandup an dʼoggiyo sulɗi koddiyo eeɗiyadaŋ uŋse. ");
INSERT INTO moz_vpl VALUES ("LK1_12","072_1_12","LUK","1","12","12","Aame Zakari yi yʼ wulle maŋ, eedí tʼa digge wo orgiso tʼa yi ziiɗa. ");
INSERT INTO moz_vpl VALUES ("LK1_13","072_1_13","LUK","1","13","13","Wo ɗe maaleeka yi di ruute, yʼede: «Zakari kee kʼorgiɗe ye, kono tondiyadá a Raa gette, yoŋ yʼilliga. Eddá Elizabet tʼa tʼeha ulo, wo ki di-zaapa sundí Zaŋ. ");
INSERT INTO moz_vpl VALUES ("LK1_14","072_1_14","LUK","1","14","14","Kee addá a ôona tʼuŋsuwo kono yode, wo ɗoŋ ɓaadaŋ ulbaŋ an dʼisa uŋse a ehiyadí te. ");
INSERT INTO moz_vpl VALUES ("LK1_15","072_1_15","LUK","1","15","15","Yoŋ yʼa tʼisa wede goole a ɗaana Galmeega Raa, toote kʼin̰n̰i bin̰ yi ki siɓa ye, ise toote ti doolo wede i-dʼede orme toŋ maŋ. Yoŋ tʼadda kʼadde meedí geŋ miŋ, addí ôoniyo tʼUnde Kamilen̰. ");
INSERT INTO moz_vpl VALUES ("LK1_16","072_1_16","LUK","1","16","16","Ɗoŋ kʼIzirayel ɓaadaŋ yʼa tiʼn kimo ki tukki Galmeega Raazaŋ. ");
INSERT INTO moz_vpl VALUES ("LK1_17","072_1_17","LUK","1","17","17","Ettiyadí yʼetto yoŋ wede zina Raa, ti toogo kʼUnde Kamilen̰ ere i-dokkiyo nebi Eli. Iŋkino maŋ maawi ti in̰n̰izaŋ yʼa tiʼn sella an di tʼokkiƴa, wo ɗoŋ i kʼollige ono ye toŋ yʼa tiʼn kimo a suuniyo kʼono ere ki ɗoŋ ki diine, kono yʼan isa ɗoŋ i tʼikkima tuddaŋ a Galmeega.» ");
INSERT INTO moz_vpl VALUES ("LK1_18","072_1_18","LUK","1","18","18","Zakari yi di ruute a maaleeka, yʼede: «Ɗe kaŋ mummino nʼa suuna ono geŋ ɗerec me? Ɗerec, nuŋ ni tʼize gôole wo eddó toŋ ozzinagutú îide, ti ki tʼehe ye.» ");
INSERT INTO moz_vpl VALUES ("LK1_19","072_1_19","LUK","1","19","19","Maŋ maaleeka yi diʼn gime onamí, yʼede: «Eŋ nuŋ maaleeka Gabiriyel wede ôhire a ɗaana Raa ni di naabiya, yi nʼigibo nʼa-dʼiido ti rabila majjaanawa kono nʼa-di kize. ");
INSERT INTO moz_vpl VALUES ("LK1_20","072_1_20","LUK","1","20","20","Wo kee onamó ki kʼumɓe ye, iŋkino maŋ bizá a di tʼippa ki rootiyo umbo bini onniyo ere sulɗi pay geŋ a-tʼetta. Eyye, ono ɗoŋ ni ruute geŋ a tʼisa aame onniyo tʼîida maŋ.» ");
INSERT INTO moz_vpl VALUES ("LK1_21","072_1_21","LUK","1","21","21","Aame geŋ kane ɗoŋ duuru an delliyo Zakari, wo an ziiɗa giggiraŋ kono tʼadda Ɓoy Raa wede kʼadda geŋ yi ki tʼaɗɗiya kesiko ye. ");
INSERT INTO moz_vpl VALUES ("LK1_22","072_1_22","LUK","1","22","22","Aame yi tʼuɗɗo kotto maŋ, yi kʼaaniya rootiyo ye a ɗoŋ duuru geŋ me. Wo kane an di zuune yoŋ i-iido munɗa aa suniye adda Ɓoy Raa wede kʼadda geŋ me, yʼan ooyisito dugiyko ɗaŋŋal wo bizí ki rootiyo umbo. ");
INSERT INTO moz_vpl VALUES ("LK1_23","072_1_23","LUK","1","23","23","Aame Zakari yʼa ti ɗiŋge onniytagi ɗoŋ ki naabadí adda Ɓoy Raa maŋ, yʼa aahe ɓoozí. ");
INSERT INTO moz_vpl VALUES ("LK1_24","072_1_24","LUK","1","24","24","Bini maŋ eddí Elizabet ti tʼumɓe adde, tere paat geŋ tʼombiɗe tuddutú. Wo todʼ tʼa ruute tʼadda kʼaddutú, tʼede: ");
INSERT INTO moz_vpl VALUES ("LK1_25","072_1_25","LUK","1","25","25","«En̰n̰o munɗa wede Galmeega Raa yʼize a tukki nuŋ te: Nuŋ te sukiyagi a ɗaana ɗoŋzó me, kono o kʼede ulo ye. Wo aŋkeŋ yʼa dihe yʼo di booye sukiyagó a ɗaana ɗuwo pay.» ");
INSERT INTO moz_vpl VALUES ("LK1_26","072_1_26","LUK","1","26","26","Elizabet mahiwatú îide tere zoot maŋ, Raa yʼa igibe maaleeka Gabiriyel kʼadda geeger soo ki siiɗo Galile sundutú Nazaret. ");
INSERT INTO moz_vpl VALUES ("LK1_27","072_1_27","LUK","1","27","27","Yi yʼigibe ki tukkʼuto koŋso, todʼ tʼibire ulo obulsu sundí Yusup, yoŋ geŋ ti biza bumɓu Dawut. Wo to uto koŋso gette sundutú Mariyam. ");
INSERT INTO moz_vpl VALUES ("LK1_28","072_1_28","LUK","1","28","28","Maaleeka yi-tʼiide di tode, yʼa tʼuuney wo yi di ruute, yʼede: «Koŋ ulbí i iso uŋse, koŋ ere Raa yi ize beeko, Galmeega Raa yoŋ ti koŋ.» ");
INSERT INTO moz_vpl VALUES ("LK1_29","072_1_29","LUK","1","29","29","A onamí geŋ ettú a digge, ti dʼelkiso tʼadda kʼaddutú wo tʼede: «Toose kino ettiŋ i-kaza moo me?» ");
INSERT INTO moz_vpl VALUES ("LK1_30","072_1_30","LUK","1","30","30","Iŋkino maŋ maaleeka yi di ruute, yʼede: «Mariyam koŋ mʼorgiɗe ye, kono koŋ mʼuune beeko ti Raa. ");
INSERT INTO moz_vpl VALUES ("LK1_31","072_1_31","LUK","1","31","31","Koŋ mʼollo koɗuwo, mʼa seeɗa mahuwe, mʼa tʼeha ulo wo mi di zaapa sundí Isa. ");
INSERT INTO moz_vpl VALUES ("LK1_32","072_1_32","LUK","1","32","32","Yoŋ geŋ yʼa tʼisa wede goole, an di yʼ waaka Ulo ki Raa goole a jiire pay. Galmeega Raa yi di tʼela kaakido moziko ere ki mugiyí Dawut, ");
INSERT INTO moz_vpl VALUES ("LK1_33","072_1_33","LUK","1","33","33","wo yʼa lekka a moziko ki daayum a tukki ɗoŋ kʼIzirayel, wo mozikadí ti ki ɗaŋga ye.» ");
INSERT INTO moz_vpl VALUES ("LK1_34","072_1_34","LUK","1","34","34","Mariyam ti di ruute maaleeka, tʼede: «Geŋ aasa mummino, kono nuŋ ti kule kaŋ soo toŋ ay kʼikkima ye me?» ");
INSERT INTO moz_vpl VALUES ("LK1_35","072_1_35","LUK","1","35","35","Maaleeka yi diʼn gime onamtú, yʼede: «Unde Kamilen̰ tʼa ɗeega eedí, wo toogo ki Raa goole a jiire pay ti-ki tiʼn diiba aa lukkise. Kono kamo ulo wede mi tʼeha geŋ yoŋ kamilen̰, wo soŋ an di yʼ waaka Ulo Raa. ");
INSERT INTO moz_vpl VALUES ("LK1_36","072_1_36","LUK","1","36","36","Wo mʼollo, Elizabet taasadí toŋ ti uune adde ki tere zoot, tʼa tʼeha ulo a gôolikatú geŋ me, tode ere anʼde karta toŋ maŋ. ");
INSERT INTO moz_vpl VALUES ("LK1_37","072_1_37","LUK","1","37","37","Ɗerec, munɗa wede Raa yi kʼaane ye umbo.» ");
INSERT INTO moz_vpl VALUES ("LK1_38","072_1_38","LUK","1","38","38","Iŋkino maŋ Mariyam tʼa ruute, tʼede: «Nuŋ te ere naabo Galmeega Raa, pay geŋ o tʼiso aa kee kʼo ruute.» Saŋ maaleeka yi-tʼiili, yʼa iŋgile. ");
INSERT INTO moz_vpl VALUES ("LK1_39","072_1_39","LUK","1","39","39","Onniyto miibi kʼita maŋ, Mariyam tʼa tʼiiziga, tʼa iŋgile ti naariya kʼadda geeger ki siiɗo Ziide ere adda diine moŋgali. ");
INSERT INTO moz_vpl VALUES ("LK1_40","072_1_40","LUK","1","40","40","Tʼiideʼŋ ti tʼiide adda ɓoy Zakari wo tʼa ruute, tʼede: «Elizabet toosadí.» ");
INSERT INTO moz_vpl VALUES ("LK1_41","072_1_41","LUK","1","41","41","Aame Elizabet tʼilliga toose ki Mariyam kotto maŋ, ulo adda kʼaddutú yʼa iise arɓu wo todʼ Elizabet addutú a ûune tʼUnde Kamilen̰. ");
INSERT INTO moz_vpl VALUES ("LK1_42","072_1_42","LUK","1","42","42","Todʼ tʼa iɗili ti golla awwa, tʼede: «Koŋ te Raa yi ti ziipe beeko a jiire erayi pay, wo ulo wede adda kʼaddí toŋ beeko Raa a eedí. ");
INSERT INTO moz_vpl VALUES ("LK1_43","072_1_43","LUK","1","43","43","Nuŋ te wee te ɗoo miŋ mekki Galmeegó tʼa iido wolliyadó me? ");
INSERT INTO moz_vpl VALUES ("LK1_44","072_1_44","LUK","1","44","44","Ki kotto mʼollo, aame nʼilliga toose ki koŋ geŋ, ulo adda kʼaddó toŋ i-dʼize uŋse, yʼa iise arɓu. ");
INSERT INTO moz_vpl VALUES ("LK1_45","072_1_45","LUK","1","45","45","Uŋsuwo a tode ere umɓe a ono ɗoŋ iido tʼurzi Galmeega Raa, kane geŋ a-tʼetta.» ");
INSERT INTO moz_vpl VALUES ("LK1_46","072_1_46","LUK","1","46","46","Iŋkino maŋ Mariyam tʼa ruute, tʼede: «Nuŋ tʼaddó pay nʼa tʼimme Galmeega. ");
INSERT INTO moz_vpl VALUES ("LK1_47","072_1_47","LUK","1","47","47","Raa yoŋ Wede kʼUttiyadó, kono kʼiŋkino addó a ûune tʼuŋsuwo, ");
INSERT INTO moz_vpl VALUES ("LK1_48","072_1_48","LUK","1","48","48","kono yʼa dihe yʼa zibbe edayí a tukki nuŋ ere naabadí ere umbadó ettiyo. Eyye, ti aŋki wo ki daayum ɗuwo pay an di roota keren̰, nuŋ te ere ulbutú uŋse, ");
INSERT INTO moz_vpl VALUES ("LK1_49","072_1_49","LUK","1","49","49","kono Raa toogo a jiire pay, a nuŋ te yʼo ize sulɗi ɗoŋ beehiye a jiire, yoŋ sundí kamilen̰. ");
INSERT INTO moz_vpl VALUES ("LK1_50","072_1_50","LUK","1","50","50","Yʼisiyo adde koɗuwo kʼeda kʼin̰n̰i a tukki ɗoŋ i ottilso me. ");
INSERT INTO moz_vpl VALUES ("LK1_51","072_1_51","LUK","1","51","51","Ti toogo ere pay ki beezí, yʼaaze sulɗi ɗoŋ a jiire, aakede: Yʼa tiʼn tiipe kane ɗoŋ an ede elkiso ere ki koliyo tuddaŋ gette, ");
INSERT INTO moz_vpl VALUES ("LK1_52","072_1_52","LUK","1","52","52","kane mozagi yi tiʼn gippirɗe tʼekki kaakidagaŋ me, wo ɗoŋ i ki koliyo tuddaŋ ye, yi-tiʼn gili tʼawwa. ");
INSERT INTO moz_vpl VALUES ("LK1_53","072_1_53","LUK","1","53","53","Kane ɗoŋ mosogo yi diʼn ûune ti sulɗi ɗoŋ majjanɗani, wo ɗoŋ bey yʼan ilmi daa munɗa beezaŋ. ");
INSERT INTO moz_vpl VALUES ("LK1_54","072_1_54","LUK","1","54","54","Yo yʼa iide noogiyo ɗoŋ kʼIzirayel ɗoŋ naabadí, wo yʼaaze adde koɗuwo a kane i-ki dunɗe ye. ");
INSERT INTO moz_vpl VALUES ("LK1_55","072_1_55","LUK","1","55","55","Gen̰n̰o munɗa wede Raa yʼan ruute yʼaasa a maawiŋ, a Ibirayim wo a ita kʼin̰n̰izí ki daayum me.» ");
INSERT INTO moz_vpl VALUES ("LK1_56","072_1_56","LUK","1","56","56","Mariyam tʼa likke ti Elizabet suma tere aɗo, saŋ tʼa aahe ɓoytú. ");
INSERT INTO moz_vpl VALUES ("LK1_57","072_1_57","LUK","1","57","57","Aame Elizabet onniyatú îide kʼehiyo maŋ, tʼa tʼehe ulo. ");
INSERT INTO moz_vpl VALUES ("LK1_58","072_1_58","LUK","1","58","58","Kane ɗoŋ kʼita waayatú ti taasiyagutú an di zuune Galmeega Raa yi ize adde koɗuwo a todʼte, wo kane toŋ an dʼisiyo uŋsuwo ti tode. ");
INSERT INTO moz_vpl VALUES ("LK1_59","072_1_59","LUK","1","59","59","Tʼume an ti yʼehe îide onniyo gessire maŋ, kane an tʼiide ulo an i di walɗa ponde wo an i di zaape sundí Zakari aa suma meegí. ");
INSERT INTO moz_vpl VALUES ("LK1_60","072_1_60","LUK","1","60","60","Wo maŋ meedí tʼan di ruute keren̰, tʼede: «Aha, ulo an di yʼ waaka sundí Zaŋ.» ");
INSERT INTO moz_vpl VALUES ("LK1_61","072_1_61","LUK","1","61","61","Maŋ kane an i di ruute, anʼde: «A biza bumɓuguŋ wede sundí iŋkino umbo.» ");
INSERT INTO moz_vpl VALUES ("LK1_62","072_1_62","LUK","1","62","62","Maŋ an i di ruute a meegí kaŋ dugiyko, kono an di suune uloʼŋ yi dehu an di yʼ waake wee wee? ");
INSERT INTO moz_vpl VALUES ("LK1_63","072_1_63","LUK","1","63","63","Yoŋ yʼa tunde pakirte, maŋ an i dʼele wo yʼa riiŋe: «Sundí te Zaŋ.» Kane pay geŋ an ziiɗa giggiraŋ. ");
INSERT INTO moz_vpl VALUES ("LK1_64","072_1_64","LUK","1","64","64","A kaamiki bizí a tʼihina, yʼa iise ono wo yi tamma Raa. ");
INSERT INTO moz_vpl VALUES ("LK1_65","072_1_65","LUK","1","65","65","Iŋkino maŋ kane ɗoŋ pay a ita waaya geŋ orgiso tʼanni ziiɗa, wo adda siiɗo Ziide ere pay adda diine moŋgali gette, an tôwwo taaya a sulɗi ɗoŋ pay ize geŋ me. ");
INSERT INTO moz_vpl VALUES ("LK1_66","072_1_66","LUK","1","66","66","Kane ɗoŋ pay illiga sulɗi ɗoŋ ize geŋ, an dʼelkiso eego wo an di tondiso tuddaŋ, anʼde: «Saŋ maŋ yo ulo eŋ yʼa tʼisa moo me?» Iŋkino maŋ ki kotto toogo Galmeega Raa gette ti yode. ");
INSERT INTO moz_vpl VALUES ("LK1_67","072_1_67","LUK","1","67","67","Zakari meekʼulo geŋ addí a ûune ti Unde Kamilen̰, wo yʼa iise rootiyto ki ono ɗoŋ Raa yʼigibo, yʼede: ");
INSERT INTO moz_vpl VALUES ("LK1_68","072_1_68","LUK","1","68","68","«Tamma a Galmeega, yoŋ Raa ki ɗoŋ kʼIzirayel, kono ɗoŋzí geŋ yʼa ukko noogiyadaŋ, yoŋ yʼan uɗɗe. ");
INSERT INTO moz_vpl VALUES ("LK1_69","072_1_69","LUK","1","69","69","Wo a kine yʼin dʼuɗɗo Wede kʼUttiyo i-dʼede toogo, ti biza bumɓu ki mozigo Dawut wede naabo Raa. ");
INSERT INTO moz_vpl VALUES ("LK1_70","072_1_70","LUK","1","70","70","Eŋ onamí ɗoŋ yʼa ruute ti kaaga ti bize nebiyagí ɗoŋ kamilen̰: ");
INSERT INTO moz_vpl VALUES ("LK1_71","072_1_71","LUK","1","71","71","Yi ruute yʼin diʼn utta ti bey ɗoŋ kʼaduziŋ wo ti bey kane ɗoŋ pay in olmiɗe. ");
INSERT INTO moz_vpl VALUES ("LK1_72","072_1_72","LUK","1","72","72","Yʼaaze adde koɗuwo a moŋgiɗagiŋ, wo i ki dunɗe ye a taasuwadí ere kamilen̰ yi gitte ti kane gette. ");
INSERT INTO moz_vpl VALUES ("LK1_73","072_1_73","LUK","1","73","73","Gette nâamiya ere Raa yʼa-ti nîime tuddí ti mugiyiŋ Ibirayim, ");
INSERT INTO moz_vpl VALUES ("LK1_74","072_1_74","LUK","1","74","74","yʼin diʼn aɗɗe ti bey ɗoŋ kʼadu. Iŋkino maŋ in dʼoola urzi in i di naaba daa kʼorgiso, ");
INSERT INTO moz_vpl VALUES ("LK1_75","072_1_75","LUK","1","75","75","kono in tʼise ɗoŋ kamilen̰ wo ki diine a ɗaanadí me adda kʼonniytagi ɗoŋ pay ki lekkiyadiŋ gette. ");
INSERT INTO moz_vpl VALUES ("LK1_76","072_1_76","LUK","1","76","76","Wo ulo ki nuŋ, kee kʼa ozira a ɗaana Galmeega kono ki-dʼokkima urzizí, geŋ iŋkino kʼa tʼisa nebi ki Raa goole a jiire pay, ");
INSERT INTO moz_vpl VALUES ("LK1_77","072_1_77","LUK","1","77","77","wo kʼan di kiza a ɗoŋzí an di suuna yoŋ yʼan utta tʼurzi tambobino kʼolɗikadaŋ. ");
INSERT INTO moz_vpl VALUES ("LK1_78","072_1_78","LUK","1","78","78","Eyye, Raaziŋ yoŋ ôoniyo tʼisiyo kʼadde koɗuwo. Yʼin tiʼn tuure ti toore wede iido tʼawwa, aakede toore peeɗo ti koliyo. ");
INSERT INTO moz_vpl VALUES ("LK1_79","072_1_79","LUK","1","79","79","Yo yʼa toora a tukki kane ɗoŋ i lekkiyo adda zimolo wo ɗoŋ i lekkiyo a biza kʼolɗe, kono yʼa dokka zoŋɗiŋ a urzi wede ki toose.» ");
INSERT INTO moz_vpl VALUES ("LK1_80","072_1_80","LUK","1","80","80","Tʼume geŋ miŋ ulo yi dʼohire a urzi tudde wo a urzi kʼUnde Raa. Yi lekkiyo adda balɗa bini a îide onniyo ere tuddí yʼan ti gize keren̰ a ɗaana ɗoŋ kʼIzirayel. ");
INSERT INTO moz_vpl VALUES ("LK2_1","072_2_1","LUK","2","1","1","Aame geŋ mozigo goole ki Romeŋ Ogust yi dʼize oogoro ki kaza ɗuwo adda siiɗiyagi pay ɗoŋ Romeŋ ge-dokkiyo. ");
INSERT INTO moz_vpl VALUES ("LK2_2","072_2_2","LUK","2","2","2","Ette kaza ere ki poone, todʼ tʼiise aame Kiriniyus yoŋ goole ki siiɗo Siiri. ");
INSERT INTO moz_vpl VALUES ("LK2_3","072_2_3","LUK","2","3","3","Ɗoŋ pay an tʼette an di-kizo tuddaŋ, wede tuuku toŋ yi dʼaahiya ki siiɗo kʼehiyadí kʼehiyadí. ");
INSERT INTO moz_vpl VALUES ("LK2_4","072_2_4","LUK","2","4","4","Wo yode Yusup toŋ yʼa tʼiiziga ti geeger Nazaret siiɗo Galile, yʼa iŋgile ki geeger Betilehem siiɗo Ziide, ume wede an dʼehe mozigo Dawut, kono yode Yusup toŋ yʼuɗɗo tʼadda ɓoy wede kʼita kʼin̰n̰i Dawut. ");
INSERT INTO moz_vpl VALUES ("LK2_5","072_2_5","LUK","2","5","5","Yʼa tʼiide, an di-kizo kaŋ soo ti Mariyam ere kʼebirayí te, aame geŋ todʼte tʼadde. ");
INSERT INTO moz_vpl VALUES ("LK2_6","072_2_6","LUK","2","6","6","Koore kane a Betilehem geŋ onniyatú kʼehiyo a îide, ");
INSERT INTO moz_vpl VALUES ("LK2_7","072_2_7","LUK","2","7","7","tʼa tʼehe ulo ki kaɓɓatú me. Ti di mulpite sotor, tʼa ti yʼ duwwe a kulaaye kono ume adda biino torgagi umbo. ");
INSERT INTO moz_vpl VALUES ("LK2_8","072_2_8","LUK","2","8","8","Adda siiɗo gettiyo batum, i dʼede ɗoŋ kʼelso an lekkiyo a balɗa an boohiyo maaladaŋ. ");
INSERT INTO moz_vpl VALUES ("LK2_9","072_2_9","LUK","2","9","9","Onniyo soo a diɗɗo maŋ, maaleeka ki Galmeega Raa yʼa dʼiide tuddaŋ wo toore Galmeega Raa yi-tooriyo eedaŋ. Iŋkino maŋ orgiso tʼan diʼn ziiɗa ɓaadaŋ. ");
INSERT INTO moz_vpl VALUES ("LK2_10","072_2_10","LUK","2","10","10","Wo maaleeka yʼan di ruute, yʼede: «Kun orgiɗe ye, kono kun ollo, nʼun dʼiido nʼun di kize rabila majjaanawa aasa uŋsuwo ɓaadaŋ a ɗoŋ pay, todʼte ettiyo: ");
INSERT INTO moz_vpl VALUES ("LK2_11","072_2_11","LUK","2","11","11","Aŋki adda diɗɗo ette adda geeger Dawut, an un ehe Wede kʼUttiyo, yoŋ Almasi Raa yi biire, yoŋ Galmeega. ");
INSERT INTO moz_vpl VALUES ("LK2_12","072_2_12","LUK","2","12","12","En̰n̰o munɗa wede un kizey kun di yʼ suuney me: kun tʼooney ulo n̰eŋku mulpiyo ti sotor, duwwiyo adda kulaaye.» ");
INSERT INTO moz_vpl VALUES ("LK2_13","072_2_13","LUK","2","13","13","A kaamiki a sirpa maaleeka geŋ, i dʼuɗɗo maaleekiyagi ɓaadaŋ ti kandaane an tamma Raa, anʼde: ");
INSERT INTO moz_vpl VALUES ("LK2_14","072_2_14","LUK","2","14","14","«Tamma a Raa tʼawwa a kandaane, wo a siiɗo toose tʼa koone a ɗoŋ yi giyye.» ");
INSERT INTO moz_vpl VALUES ("LK2_15","072_2_15","LUK","2","15","15","Aame maaleekiyagi an iili an ti gime ki kandaane maŋ, kane ɗoŋ kʼelso an dʼiise rootiyto tuddaŋ, anʼde: «Iŋkino in tʼette Betilehem, in di wollo munɗa wede iido, wede Galmeega Raa yʼin gize.» ");
INSERT INTO moz_vpl VALUES ("LK2_16","072_2_16","LUK","2","16","16","Maŋ an dʼiŋgile an di naariya. An iiney maŋ, an di dihite wo an diʼn uune Mariyam ti Yusup, wo ulo n̰eŋku duwwiyo adda kulaaye me. ");
INSERT INTO moz_vpl VALUES ("LK2_17","072_2_17","LUK","2","17","17","Aame ulo an ti yʼ wulle maŋ, an dʼiise tôwwo taaya ere maaleeka yʼan ruuto kono kʼulo geŋ me. ");
INSERT INTO moz_vpl VALUES ("LK2_18","072_2_18","LUK","2","18","18","Wo ɗoŋ pay illiga geŋ an di ziiɗa giggiraŋ a rabila ere ki ɗoŋ kʼelso gette. ");
INSERT INTO moz_vpl VALUES ("LK2_19","072_2_19","LUK","2","19","19","Wo ki tode Mariyam maŋ, sulɗi pay geŋ tʼa tiʼn buuhe adda kʼaddutú, wo ti dʼelkiso ɓaadaŋ eego. ");
INSERT INTO moz_vpl VALUES ("LK2_20","072_2_20","LUK","2","20","20","Saŋ maŋ ɗoŋ kʼelso an di-gime, an di tamma Raa wo an di ruute koɗuwo a yode a sulɗi ɗoŋ pay an illiga wo an wulle, kono sulɗi pay geŋ a-tʼiide aakede maaleeka yʼan ruute. ");
INSERT INTO moz_vpl VALUES ("LK2_21","072_2_21","LUK","2","21","21","Tʼume an ti yʼehe îide onniyo gessire maŋ, ulo an i-di wilɗa ponde, wo yoŋ an i-di ziipe sundí Isa aa maaleeka yʼa ruute, ti poone meedí tʼa seeɗa mahuwe ɓotto. ");
INSERT INTO moz_vpl VALUES ("LK2_22","072_2_22","LUK","2","22","22","Saŋ maŋ onniyo tʼa îide ere aŋ Yusup ti eddí Mariyam an ti tʼise tuddaŋ kamilen̰ a ɗaana Raa, aakede oogoro Muusa ti rootiyo. Iŋkino maŋ ulo an tʼumɓe kʼadda booro Ɓoy Galmeega Raa a geeger Zeruzalem, kono an i-ti yʼ zaapey a ɗaanadí. ");
INSERT INTO moz_vpl VALUES ("LK2_23","072_2_23","LUK","2","23","23","An ize iŋkino a-tʼiide a ono ɗoŋ an riiŋe ti kaaga adda mattup kʼoogoro Galmeega Raa, anʼde: «In̰n̰i kuuli ɗoŋ pay ki kaɓɓa geŋ, kane kun i diʼn ooye kese a Galmeega Raa.» ");
INSERT INTO moz_vpl VALUES ("LK2_24","072_2_24","LUK","2","24","24","Wo soŋ kane maawí an dʼise seɗeke ere tode oogoro gettiyo batum ti rootiyo, tʼede: «An di seɗɗe deere sire ere ki balɗa umbo ere ki moɗɗiyo toŋ sire wo in̰n̰i.» ");
INSERT INTO moz_vpl VALUES ("LK2_25","072_2_25","LUK","2","25","25","A Zeruzalem geŋ i dʼede wede iŋkino sundí Simeyoŋ, yoŋ wede ki diine wo yʼorgiso a Raazí, yi delliyo wede yʼa utta ɗoŋ kʼIzirayel. Unde Kamilen̰ ti yode ");
INSERT INTO moz_vpl VALUES ("LK2_26","072_2_26","LUK","2","26","26","wo todʼ ti di tʼiiɗiba ita ki poone, tʼede: «Kee ki ki tʼinda ye, daa ki ki wulla Almasi Galmeega Raa yi biire gen̰n̰o ye maŋ.» ");
INSERT INTO moz_vpl VALUES ("LK2_27","072_2_27","LUK","2","27","27","Iŋkino maŋ tʼurzi kʼUnde Raa, Simeyoŋ yʼa tʼiide kʼadda booro Ɓoy Raa aame Isa maawí an ti yʼumɓo, kono an dʼise munɗa wede aa oogoro ti rootiyo. ");
INSERT INTO moz_vpl VALUES ("LK2_28","072_2_28","LUK","2","28","28","Maŋ Simeyoŋ yʼa tʼumɓe ulo a beezí wo yi tamma Raa, yʼede: ");
INSERT INTO moz_vpl VALUES ("LK2_29","072_2_29","LUK","2","29","29","«Aŋken̰n̰o eŋ Galmeega Raa, kee onamá ɗoŋ ki ruute a tʼiide, nuŋ wede naabadá ki nʼoolo nʼa tʼinda ti toose. ");
INSERT INTO moz_vpl VALUES ("LK2_30","072_2_30","LUK","2","30","30","Ki kotto ni yʼ wulle tʼedayó wede kʼigibo a utta ɗuwo me, ");
INSERT INTO moz_vpl VALUES ("LK2_31","072_2_31","LUK","2","31","31","yode wede kʼigibo ɗuwo pay an di yʼ wolla. ");
INSERT INTO moz_vpl VALUES ("LK2_32","072_2_32","LUK","2","32","32","Yoŋ geŋ toore, wede a kiza a ɗoŋ Yawudiyagi ye an di suuna kee Raa, wo tʼurzi yode geŋ ɗuwo an di tʼimma ɗoŋ kʼIzirayel.» ");
INSERT INTO moz_vpl VALUES ("LK2_33","072_2_33","LUK","2","33","33","A ono ɗoŋ Simeyoŋ yi rootiyo a tukkʼulo geŋ, kane maawí an ziiɗa giggiraŋ. ");
INSERT INTO moz_vpl VALUES ("LK2_34","072_2_34","LUK","2","34","34","Simeyoŋ yʼan di ziipe beeko, wo yi di ruute a Mariyam meekʼulo, yʼede: «Koŋ mʼollo, ulo eŋ Raa yi ziipo yʼa koona urzi wede ɗoŋ ɓaadaŋ adda siiɗo kʼIzirayel an di dagga, wo ɗoŋ oŋgoŋ an tʼoona uttiyo. Wo yoŋ yʼa koona munɗa wede a kiza Raa a ɗuwo, wo kane an di yʼ kiigira. ");
INSERT INTO moz_vpl VALUES ("LK2_35","072_2_35","LUK","2","35","35","Iŋkino maŋ elkiso ere ombiɗe adda kʼadde ɗoŋ ɓaadaŋ gette yʼa-tʼoora keren̰, wo koŋ Mariyam dabar tʼa kiʼn seeɗa ɓaadaŋ aa an kiʼn giira ti kasigara.» ");
INSERT INTO moz_vpl VALUES ("LK2_36","072_2_36","LUK","2","36","36","I dʼede soŋ nebi erewo sundutú An uto ki Peenuwel, tode gette ti biza bumɓu kʼAser. Todʼ ti gûulike baa. Ti kule wede ti ziiɗa ki koŋsuwatú geŋ, an di likke ozzine sarat ɗaŋŋal, maŋ yʼa inda. ");
INSERT INTO moz_vpl VALUES ("LK2_37","072_2_37","LUK","2","37","37","Tʼume geŋ tʼa likke mandaayawa bini ozzinagutú a îide ada gessire makumu piɗe. Ti booro Ɓoy Raa ti ki ɗekkiyo ye, ti naabiya diɗɗo on̰n̰u a Raa me, onniyo muno ti lekkiyo daa kʼomɓo wo ti tondiyo Raa. ");
INSERT INTO moz_vpl VALUES ("LK2_38","072_2_38","LUK","2","38","38","Aame Simeyoŋ yi rootiyto geŋ, tode toŋ maŋ tʼa dʼiiney wo tʼa iise tamma Raa. Wo ti tôwwo taaya kʼulo a ɗoŋ Zeruzalem pay, ɗoŋ i delliyo Raa yʼan aɗɗa ti dabaradaŋ. ");
INSERT INTO moz_vpl VALUES ("LK2_39","072_2_39","LUK","2","39","39","Aame kane maawi kʼIsa an tʼize pay sulɗi ɗoŋ oogoro Galmeega Raa ti dehu an dʼise me maŋ, an di-gime ti ulaŋ ki Nazaret geeger ere an di lekkiyo adda siiɗo Galile. ");
INSERT INTO moz_vpl VALUES ("LK2_40","072_2_40","LUK","2","40","40","Wo ulo geŋ yi dʼohire a urzi tudde wo a urzi kʼUnde Raa, eedí ôoniyo ɓoo ti suuniyo kʼono, wo beeko Raa a eedí. ");
INSERT INTO moz_vpl VALUES ("LK2_41","072_2_41","LUK","2","41","41","Ozzine ti ozzine maawi kʼIsa an di-koliyo ki Zeruzalem kono an dʼisiyo tarnaape Pak ki Yawudiyagi. ");
INSERT INTO moz_vpl VALUES ("LK2_42","072_2_42","LUK","2","42","42","Wo aame Isa i îide ozzine koomat makumu sire maŋ, maawí an ti yʼ wiike ti kane ki Zeruzalem, aa oogoro ki tarnaape ti rootiyo. ");
INSERT INTO moz_vpl VALUES ("LK2_43","072_2_43","LUK","2","43","43","Aame onniyto tarnaape i tʼiŋgile maŋ, kane an di-gime, wo yo ulo Isa yʼa uupe a Zeruzalem, maawí an ki suune ye. ");
INSERT INTO moz_vpl VALUES ("LK2_44","072_2_44","LUK","2","44","44","Kane an elkiyo uloʼŋ ti ɗoŋ an ziiɗo urzizaŋ soo. Iŋkino aame an izire bini peeɗo tʼette kʼooriyo maŋ, an dʼiise dehuzí adda diine taasiyagaŋ ti laŋziyagaŋ. ");
INSERT INTO moz_vpl VALUES ("LK2_45","072_2_45","LUK","2","45","45","Umbo an ki yʼuune ye, maŋ an di dehutu an di-gime ki Zeruzalem. ");
INSERT INTO moz_vpl VALUES ("LK2_46","072_2_46","LUK","2","46","46","Onniyo sire kʼaɗuwe maŋ, an di yʼuuno adda booro Ɓoy Raa, yi-guune adda diine ɗoŋ suuniyo kʼoogoro, yiʼn ollige wo yi diʼn tondiyto. ");
INSERT INTO moz_vpl VALUES ("LK2_47","072_2_47","LUK","2","47","47","Wo kane ɗoŋ pay i yʼollige an ziiɗa giggiraŋ a eedí soodo a elkiso ere i-dʼede, ti kama kʼono ɗoŋ yʼanni kama geŋ me. ");
INSERT INTO moz_vpl VALUES ("LK2_48","072_2_48","LUK","2","48","48","Kane maawí an yi wulle maŋ, an ziiɗa giggiraŋ wo meedí ti di ruute, tʼede: «Ulo ki nuŋ, kʼisiyo kino moo me a kaye maawá me? Ki wollo, nuŋ ti meegá ay ki dehutu eŋ undey i tʼuɗɗe.» ");
INSERT INTO moz_vpl VALUES ("LK2_49","072_2_49","LUK","2","49","49","Yoŋ yʼan di ruute, yʼede: «Ɗe kun ni dehutu iŋkino moo me? Kun ki suune ye ko, i dehu nuŋ nʼa lekke adda Ɓoy Meegó me?» ");
INSERT INTO moz_vpl VALUES ("LK2_50","072_2_50","LUK","2","50","50","Wo kane eedaŋ ti ki seeɗu ye onamí ɗoŋ yʼan rootiyo geŋ me. ");
INSERT INTO moz_vpl VALUES ("LK2_51","072_2_51","LUK","2","51","51","Saŋ maŋ yʼa tʼiiziga, an di-ɗiige ki Nazaret ti maawí soo. Yo yi dʼollige onamaŋ, wo meedí gette sulɗi ɗoŋ pay ize geŋ ti diʼn boohiyo addutú. ");
INSERT INTO moz_vpl VALUES ("LK2_52","072_2_52","LUK","2","52","52","Isa geŋ yi dʼohire a urzi tudde, a urzi suuniyo kʼono, ti beeko a ɗaana Raa wo a ɗaana ɗuwo pay. ");
INSERT INTO moz_vpl VALUES ("LK3_1","072_3_1","LUK","3","1","1","Kun ollo, tʼume Tiber yoŋ mozigo goole ki Romeŋ, wo îide ozzine koomat makumu paat maŋ, goole ki siiɗo Ziide sundí Pons Pilat. Goole ki siiɗo Galile sundí Erod Antipas, leemadí Pilip yoŋ goole yi dokkiyo siiɗo kʼIture ti siiɗo Tirakoni. Goole ki siiɗo kʼAbilen sundí Lizaniya, ");
INSERT INTO moz_vpl VALUES ("LK3_2","072_3_2","LUK","3","2","2","wo mozagi deero ɗoŋ seɗeke sumɓiyagaŋ Anne ti Kayip. A ozzine geŋ Raa yi-dʼele onamí a Zaŋ ulo Zakari, aame yi lekkiyo adda balɗa. ");
INSERT INTO moz_vpl VALUES ("LK3_3","072_3_3","LUK","3","3","3","Wo yo Zaŋ geŋ yi soorutu adda siiɗiyagi ɗoŋ pay a biza kʼooye Zurden, yi kazita yi dʼeesiyo: «Kun ti kama lekkiyaguŋ, an un tiʼn suyyo batem wo Raa yʼun tʼisa tambobino a olɗikaguŋ te.» ");
INSERT INTO moz_vpl VALUES ("LK3_4","072_3_4","LUK","3","4","4","Geŋ a-tʼiide a ono ɗoŋ nebi Ezayi yi riiŋe ti kaaga adda mattupadí, yʼede: «Ɗoŋ an dʼollige golla ki wedusu yi ɗollite adda balɗa, yi dʼeesiyo: Kun i tʼokkoŋ urzi Galmeega, erkiyagí kun i tiʼn okkoŋ ki diine ɗelele. ");
INSERT INTO moz_vpl VALUES ("LK3_5","072_3_5","LUK","3","5","5","Polɗagi kun tiʼn ôono pay, moŋgali ti kessagi pay kun di bursiɗito, urzi guuɗiyto kun ti yʼahan ɗelele, wo urzi wede moŋgali toŋ kun ti yʼiso patal. ");
INSERT INTO moz_vpl VALUES ("LK3_6","072_3_6","LUK","3","6","6","Iŋkino ɗuwo pay an di yʼ suuna urzi kʼuttiyo wede Raa yʼan ele me.» ");
INSERT INTO moz_vpl VALUES ("LK3_7","072_3_7","LUK","3","7","7","A ɗoŋ duuru i dihimo ki tukki Zaŋ yʼa tiʼn suyye batem geŋ, yʼan di rootiyo, yʼede: «Kune ɗoŋ ulpi aakede maŋkikagi! Wee wee un gize urzi wede kun tʼalɗa ti booro ki Raa ere ettiyo goppoŋ te? ");
INSERT INTO moz_vpl VALUES ("LK3_8","072_3_8","LUK","3","8","8","Iŋkino maŋ kun iso naabo ere beehiye, geŋ a kize kun ti gime lekkiyaguŋ. Wo kun roote ye adda kʼadduguŋ: “Kaye mugiyey Ibirayim me”, kono kun tʼalɗa ti booro Raa te. Wo kun ollo, nʼun di rooto: Ti moŋgali eŋ miŋ, Raa yʼaane yi dʼaɗɗe ɗuwo a tʼise ita kʼin̰n̰i kʼIbirayim me. ");
INSERT INTO moz_vpl VALUES ("LK3_9","072_3_9","LUK","3","9","9","Aŋken̰n̰o booro Raa i guute goppoŋ, todʼte aa wede yi tʼumɓe ulpaasi yʼa-dokkiɗa inda ti sondayzaŋ pay: Undumu tuuku yi kʼehiyo in̰n̰i beehiye ye maŋ, an di-ɗekka an di seɗɗa adda kʼuwwo mendí.» ");
INSERT INTO moz_vpl VALUES ("LK3_10","072_3_10","LUK","3","10","10","Iŋkino maŋ kane ɗoŋ duuru Zaŋ an di yʼ tunde, anʼde: «Ɗe ay dʼise mummino me?» ");
INSERT INTO moz_vpl VALUES ("LK3_11","072_3_11","LUK","3","11","11","Maŋ yʼan di ruute, yʼede: «Aame wede i-dʼede kallagi sire maŋ, soŋ yi elo a wede i-kʼede ye. Aame wede i-dʼede omɓo maŋ, yʼan ti dooko ti wede i-kʼede ye.» ");
INSERT INTO moz_vpl VALUES ("LK3_12","072_3_12","LUK","3","12","12","A ume geŋ i dʼede ɗoŋ seɗɗu jibaaye toŋ an iido yʼa tiʼn suyye batem, wo Zaŋ an di yʼ tunde, anʼde: «Wede dooyisadey, ay dʼise mummino me?» ");
INSERT INTO moz_vpl VALUES ("LK3_13","072_3_13","LUK","3","13","13","Maŋ yoŋ yʼan di ruute, yʼede: «Kune a munɗa wede an un ɗikke geŋ, ti doolo kun a amɓa ye.» ");
INSERT INTO moz_vpl VALUES ("LK3_14","072_3_14","LUK","3","14","14","Iŋkino asigiryagi toŋ an di yʼ tunde, anʼde: «Wo ɗe kaye me, ay dʼise mummino?» Yoŋ yʼan di ruute, yʼede: «Munɗa wedusu kun amɓe ki toogo ye, ise omɓo bize ti suma ɗuwo toŋ ulu, ulbuguŋ iso uŋse a ran̰n̰aguŋ.» ");
INSERT INTO moz_vpl VALUES ("LK3_15","072_3_15","LUK","3","15","15","Kane ɗoŋ duuru geŋ an di delliso wo an di zaapu elkisadaŋ ekki yode, wede tuuku toŋ yi rootiyo adda kʼaddí a urzi Zaŋ geŋ me, anʼde: «Kunuŋ eŋ miŋ aasa Almasi Raa yi biire ko?» ");
INSERT INTO moz_vpl VALUES ("LK3_16","072_3_16","LUK","3","16","16","Iŋkino maŋ Zaŋ yʼan di ruute a kane pay, yʼede: «Nuŋ nʼunni suyyiso batem tʼahu, wo ɗe wede ettiyo kʼita geŋ yoŋ toogo yi jiire nuŋ, ni kʼîide nʼa ki tʼeeze sibe toɓiyagí ye. Yoŋ yʼunni suyya batem tʼUnde Kamilen̰ wo ti uwwo. ");
INSERT INTO moz_vpl VALUES ("LK3_17","072_3_17","LUK","3","17","17","Wo yoŋ yʼa ɗekka booro aakede wedusu yi tʼumɓo munɗa ki solɗe a beezí, yʼa silɗa koɗuwo, in̰n̰i yi-tʼoɓa giiƴayí, wo oɗɗo yʼa tʼogga mentú adda kʼuwwo ere i kʼunto ye.» ");
INSERT INTO moz_vpl VALUES ("LK3_18","072_3_18","LUK","3","18","18","A ɗoŋ duuru Zaŋ yʼan dʼeele kooke ti doolo toŋ ɓaadaŋ. Geŋ iŋkino yʼan di kazita urzi Rabila Majjaanawa me. ");
INSERT INTO moz_vpl VALUES ("LK3_19","072_3_19","LUK","3","19","19","Wo aame geŋ Erod wede i dokkiyo siiɗo Galile, Zaŋ yʼa yʼiipiɗe kono yi ziiɗa ere leemadí sundutú Erodiyas, wo kono soŋ yʼize sulɗi ɗoŋ ulpi ɓaadaŋ ti doolo. ");
INSERT INTO moz_vpl VALUES ("LK3_20","072_3_20","LUK","3","20","20","Wo tʼekki sulɗi ɗoŋ pay ulpi Erod yʼize geŋ, Zaŋ yʼa-ti yʼ ziiɗa daŋgay. ");
INSERT INTO moz_vpl VALUES ("LK3_21","072_3_21","LUK","3","21","21","Ɗoŋ pay Zaŋ yi tiʼn zuyye batem maŋ, Isa toŋ yʼa-ti yʼ zuyye batem. Wo aame Isa yi tondiyo Raa geŋ, kandaane a tʼihina, ");
INSERT INTO moz_vpl VALUES ("LK3_22","072_3_22","LUK","3","22","22","wo Unde Kamilen̰ tʼa ɗiigo a tuddí, ti tudde ere aa deere. Wo golla tʼa ruute ti kandaane, tʼede: «Kee ulo nuuno, ni ki giyye ɓaadaŋ, ulbó uŋse ti kee me.» ");
INSERT INTO moz_vpl VALUES ("LK3_23","072_3_23","LUK","3","23","23","Aame Isa i îide suma kʼozzine ada gʼaɗo maŋ, yʼa iise kazita Rabila Majjaanawa. Aa in di rootiyo yoŋ ulo ki Yusup, geŋ ita moŋgiɗagi ettiyo: Yusup yoŋ ulo kʼEli, ");
INSERT INTO moz_vpl VALUES ("LK3_24","072_3_24","LUK","3","24","24","Eli ulo ki Matat, Matat ulo ki Lebi, Lebi ulo ki Melki, Melki ulo ki Yanay, Yanay ulo ki Yusup, ");
INSERT INTO moz_vpl VALUES ("LK3_25","072_3_25","LUK","3","25","25","Yusup ulo ki Matatiyas, Matatiyas ulo ki Amos, Amos ulo ki Nahum, Nahum ulo ki Esili, Esili ulo ki Nagay, ");
INSERT INTO moz_vpl VALUES ("LK3_26","072_3_26","LUK","3","26","26","Nagay ulo ki Maat, Maat ulo ki Matatiyas, Matatiyas ulo ki Simeyin, Simeyin ulo ki Yosek, Yosek ulo ki Yoda, ");
INSERT INTO moz_vpl VALUES ("LK3_27","072_3_27","LUK","3","27","27","Yoda ulo ki Yohanan, Yohanan ulo ki Resa, Resa ulo ki Zorobabel, Zorobabel ulo ki Salatiyel, Salatiyel ulo ki Neri, ");
INSERT INTO moz_vpl VALUES ("LK3_28","072_3_28","LUK","3","28","28","Neri ulo ki Melki, Melki ulo ki Addi, Addi ulo ki Kosam, Kosam ulo ki Elmudam, Elmudam ulo ki Er, ");
INSERT INTO moz_vpl VALUES ("LK3_29","072_3_29","LUK","3","29","29","Er ulo ki Zozuwe, Zozuwe ulo ki Eliyezer, Eliyezer ulo ki Yorim, Yorim ulo ki Matat, Matat ulo ki Lebi, ");
INSERT INTO moz_vpl VALUES ("LK3_30","072_3_30","LUK","3","30","30","Lebi ulo ki Simeyoŋ, Simeyoŋ ulo ki Ziida, Ziida ulo ki Yusup, Yusup ulo ki Yonam, Yonam ulo ki Eliyakim, ");
INSERT INTO moz_vpl VALUES ("LK3_31","072_3_31","LUK","3","31","31","Eliyakim ulo ki Meleya, Meleya ulo ki Menna, Menna ulo ki Matata, Matata ulo ki Natan, Natan ulo ki Dawut, ");
INSERT INTO moz_vpl VALUES ("LK3_32","072_3_32","LUK","3","32","32","Dawut ulo ki Zeese, Zeese ulo ki Ibet, Ibet ulo ki Booz, Booz ulo ki Sala, Sala ulo ki Nasoŋ, ");
INSERT INTO moz_vpl VALUES ("LK3_33","072_3_33","LUK","3","33","33","Nasoŋ ulo ki Aminadap, Aminadap ulo ki Adimin, Adimin ulo ki Arini, Arini ulo ki Eziroŋ, Eziroŋ ulo ki Pares, Pares ulo ki Ziida, ");
INSERT INTO moz_vpl VALUES ("LK3_34","072_3_34","LUK","3","34","34","Ziida ulo ki Yakup, Yakup ulo kʼIsaaka, Isaaka ulo kʼIbirayim, Ibirayim ulo ki Tera, Tera ulo ki Nahor, ");
INSERT INTO moz_vpl VALUES ("LK3_35","072_3_35","LUK","3","35","35","Nahor ulo ki Serug, Serug ulo ki Regu, Regu ulo ki Pelek, Pelek ulo ki Eber, Eber ulo ki Sala, ");
INSERT INTO moz_vpl VALUES ("LK3_36","072_3_36","LUK","3","36","36","Sala ulo ki Kenan, Kenan ulo ki Arpazad, Arpazad ulo ki Sem, Sem ulo ki Nowe, Nowe ulo ki Lemek, ");
INSERT INTO moz_vpl VALUES ("LK3_37","072_3_37","LUK","3","37","37","Lemek ulo ki Matusalem, Matusalem ulo ki Enok, Enok ulo ki Yered, Yered ulo ki Malaleyel, Malaleyel ulo ki Kenan, ");
INSERT INTO moz_vpl VALUES ("LK3_38","072_3_38","LUK","3","38","38","Kenan ulo ki Enos, Enos ulo ki Set, Set ulo ki Adum, Adum ulo ki Raa. ");
INSERT INTO moz_vpl VALUES ("LK4_1","072_4_1","LUK","4","1","1","Isa yi kama ti biza kʼooye Zurden ôoniyo tʼUnde Kamilen̰, maŋ Unde Raa gette tʼa-di tʼiide kʼadda balɗa. ");
INSERT INTO moz_vpl VALUES ("LK4_2","072_4_2","LUK","4","2","2","A ume geŋ Meeda siitanɗani tʼa yi niime daggiya adda kʼonniyo ada piɗe geŋ me. Adda kʼonniytagi geŋ yoŋ yʼa likke daa kʼomɓo, wo aame onniytagi geŋ an tʼiŋgile maŋ, mosogo tʼa yi ziiɗa. ");
INSERT INTO moz_vpl VALUES ("LK4_3","072_4_3","LUK","4","3","3","Iŋkino maŋ Meeda siitanɗani ti di ruute, tʼede: «Aame kee Ulo Raa kotto maŋ, kʼelo urzi a mokkolo ette tʼa-kime omɓo.» ");
INSERT INTO moz_vpl VALUES ("LK4_4","072_4_4","LUK","4","4","4","Isa yi diʼn gime onamtú, yʼede: «Koŋ te mʼollo, ono eŋ an riiŋe ti kaaga adda mattup ki Raa, anʼde: “Lekkiyo wedusu, todʼte tʼurzi kʼomɓo bizí ɗaŋŋal ye.”» ");
INSERT INTO moz_vpl VALUES ("LK4_5","072_4_5","LUK","4","5","5","Maŋ Meeda siitanɗani tʼa-di tʼiide kʼekki mokkolo sohoro, wo a kaamiki ita moziko pay ki duniya ti di gizite, ");
INSERT INTO moz_vpl VALUES ("LK4_6","072_4_6","LUK","4","6","7","wo ti di ruute, tʼede: «Aame ki-dikka wo kʼo uttila maŋ, nʼa di tʼela a kee toogo ti laale wede ki moziko pay ette, kono kane pay eŋ an oo nʼele a nuŋ, wo ni-tʼele a wede aa ni dehu.» ");
INSERT INTO moz_vpl VALUES ("LK4_8","072_4_8","LUK","4","8","8","Maŋ Isa yi di ruute, yʼede: «Mʼollo, ono eŋ an riiŋe ti kaaga adda mattup ki Raa, anʼde: “Kee kʼottilo a Galmeega Raazá, wo geŋ a yode ɗaŋŋal ki naabo me.”» ");
INSERT INTO moz_vpl VALUES ("LK4_9","072_4_9","LUK","4","9","9","Saŋ maŋ Meeda siitanɗani tʼa-di tʼiide Zeruzalem tʼa-ti yʼ ziipe tʼekki Ɓoy Raa a ume wede awwa, wo ti di ruute, tʼede: «Aame kee Ulo Raa kotto maŋ, tʼawwa geŋ kʼolɗi kʼa zabba siiɗo, ");
INSERT INTO moz_vpl VALUES ("LK4_10","072_4_10","LUK","4","10","10","kono ono eŋ an riiŋe ti kaaga adda mattup ki Raa, anʼde: “Raa yʼan di roota maaleekiyagí kono kee, an gi di booha.” ");
INSERT INTO moz_vpl VALUES ("LK4_11","072_4_11","LUK","4","11","11","Wo soŋ an riiŋe, anʼde: “an gi di seeɗa beezaŋ, kono kʼa tʼalɗa zoŋɗá a ki tʼoggo ekki mokkolo ye.”» ");
INSERT INTO moz_vpl VALUES ("LK4_12","072_4_12","LUK","4","12","12","Isa yi di ruute, yʼede: «Mʼollo, ono eŋ an riiŋe ti kaaga adda mattup ki Raa, anʼde: “Kee Galmeega Raazá ki yʼ naame ye.”» ");
INSERT INTO moz_vpl VALUES ("LK4_13","072_4_13","LUK","4","13","13","Iŋkino aame Meeda siitanɗani ita naamiya daggiya ere tuuku toŋ pay ti ti ɗiŋge maŋ, tʼa tʼirga ti tuddí bini onniyo ere ti tʼoona ti doolo. ");
INSERT INTO moz_vpl VALUES ("LK4_14","072_4_14","LUK","4","14","14","Isa geŋ ôoniyo ti toogo kʼUnde Kamilen̰ yʼa-gime ki siiɗo Galile, wo sundí tʼa îile adda siiɗo pay gette. ");
INSERT INTO moz_vpl VALUES ("LK4_15","072_4_15","LUK","4","15","15","A ume geŋ yi dooyisito adda ɓoyɗi ɗoŋ Yawudiyagi ge dooyiso, wo ɗoŋ pay an di yʼ tamma. ");
INSERT INTO moz_vpl VALUES ("LK4_16","072_4_16","LUK","4","16","16","Isa yʼa tʼiiziga, yʼa iŋgile ki Nazaret geeger ere yʼa ihira. A onniyo ere ki puukiyo Yawudiyagi maŋ, aa daayum yi dʼisiyo yi-tʼiide adda ɓoy wede Yawudiyagi ge dooyiso, maŋ yʼa tʼiiziga yʼan di gare mattup ki Raa ere ti kaaga. ");
INSERT INTO moz_vpl VALUES ("LK4_17","072_4_17","LUK","4","17","17","An i dʼele mattup lobiɗe ki nebi Ezayi. Aame yi tʼihina maŋ, yi dʼuune ume wede an riiŋe, anʼde: ");
INSERT INTO moz_vpl VALUES ("LK4_18","072_4_18","LUK","4","18","18","«Unde Galmeega Raa ti konso a eedó, yoŋ yi ni biire kono nʼa kizite Rabila Majjaanawa a ɗoŋ an kʼede munɗa ye. Yʼa nʼigibe kono nʼa kizite a ɗoŋ an ziɗɗo ɓulagi an tʼaɗɗe, a ɗoŋ koŋzayi edayaŋ a-tʼihina an di wolle keren̰, wo a ɗoŋ an an ooɗibe yeebadaŋ an tʼaɗɗe ti dabaradaŋ te, ");
INSERT INTO moz_vpl VALUES ("LK4_19","072_4_19","LUK","4","19","19","kono nʼan di kize ozzine wede an di wolle beeko Galmeega Raa.» ");
INSERT INTO moz_vpl VALUES ("LK4_20","072_4_20","LUK","4","20","20","Aame yi ɗiŋge gariya maŋ, mattup yʼa-tʼilbiɗa umatú, yi-di tʼele a wede i naabiya adda ɓoy gen̰n̰o, yoŋ yʼa-guune. Wo ɗoŋ pay adda ɓoy geŋ edayaŋ ki tukki yode. ");
INSERT INTO moz_vpl VALUES ("LK4_21","072_4_21","LUK","4","21","21","Iŋkino maŋ yʼan dʼiise rootiyo, yʼede: «Aŋki batum ono ɗoŋ an riiŋe ti kaaga adda mattup ki Raa ɗoŋ kun illiga eŋ, a tʼiide a kune.» ");
INSERT INTO moz_vpl VALUES ("LK4_22","072_4_22","LUK","4","22","22","Ɗoŋ pay an di yʼimme, an ziiɗa giggiraŋ a ono ɗoŋ majjanɗani uɗɗe ti bizí geŋ me, wo an di rootiyo, anʼde: «Yo eŋ ulo Yusup ɗe me!» ");
INSERT INTO moz_vpl VALUES ("LK4_23","072_4_23","LUK","4","23","23","Maŋ Isa yʼan di ruute, yʼede: «Ki kotto nʼelkiyo kune kun o roota ono ombiɗe en̰n̰o, kun tʼeesa: “Wede daawiya no, ki daawo tuddá ɗo.” Wo kun o di roota soŋ: “Kaye ay yʼilliga sulɗi ɗoŋ pay kee kʼizo a geeger Kapernayim me, wo a en̰n̰o adda siiɗadá toŋ kʼiso sulɗi ɗoŋ iŋkino kay.”» ");
INSERT INTO moz_vpl VALUES ("LK4_24","072_4_24","LUK","4","24","24","Wo yʼa ruute sey, yʼede: «Ɗerec iŋkino wo nʼun di rooto: Nebi geŋ ɗoŋ a geeger ere yʼa ihira ɗaŋŋal, onamí an kʼolliga ye me. ");
INSERT INTO moz_vpl VALUES ("LK4_25","072_4_25","LUK","4","25","25","Ɗerec iŋkino wo nʼun di rooto: Ti kaaga a ozzinagi ki nebi Eli geŋ, ozzine aɗo ti gootiyo mizzi yi ki guppe ye, i dʼize mosogo ɓaadaŋ adda siiɗo pay. A ozzine geŋ mandayɗayi ɓaadaŋ a siiɗo kʼIzirayel me, ");
INSERT INTO moz_vpl VALUES ("LK4_26","072_4_26","LUK","4","26","26","wo toŋ nebi Eli Raa yi ki yʼigibe ye, yʼa nooge ere soo ti diine kane geŋ me. Yʼa yʼigibe kʼume mandaayawa ere soo Yawudowo ye ti lekkiyo a Sarepita adda siiɗo ki Sidoŋ. ");
INSERT INTO moz_vpl VALUES ("LK4_27","072_4_27","LUK","4","27","27","Soŋ a ozzinagi ki nebi Elize geŋ, i dʼede ɗoŋ bintiɗagi ɓaadaŋ a siiɗo kʼIzirayel me, wo ti diinayaŋ wenɗa soo toŋ i kʼize ye kamilen̰ me, a tʼize kamilen̰ Naama ɗaŋŋal yoŋ ti siiɗo Siiri.» ");
INSERT INTO moz_vpl VALUES ("LK4_28","072_4_28","LUK","4","28","28","Aame an illiga onamí iŋkino maŋ, kane ɗoŋ pay i tʼugiye adda ɓoy wede Yawudiyagi ge dooyiso geŋ, an di gulkuwe ɓaadaŋ. ");
INSERT INTO moz_vpl VALUES ("LK4_29","072_4_29","LUK","4","29","29","Maŋ kane an tʼiiziga, Isa tʼadda geeger an di yʼuɗɗe, an di-tʼiide neere tokomo ere geegirzaŋ eego, kono Isa an ti yʼ kibiro kʼekki zire. ");
INSERT INTO moz_vpl VALUES ("LK4_30","072_4_30","LUK","4","30","30","Wo yoŋ yi tʼuɗɗe ti diinayaŋ, yʼa ziiɗa urzizí yʼa iŋgile. ");
INSERT INTO moz_vpl VALUES ("LK4_31","072_4_31","LUK","4","31","31","Iŋkino maŋ Isa yʼa-ɗiige ki Kapernayim geeger ki siiɗo Galile. A onniyo ere ki puukiyo Yawudiyagi maŋ, ɗuwo yi diʼn dooyiso, ");
INSERT INTO moz_vpl VALUES ("LK4_32","072_4_32","LUK","4","32","32","wo kane dooyisadí gette tʼan diʼn ziiɗa, kono yi dooyiso ti toogo suuniyo ere ki yode batum. ");
INSERT INTO moz_vpl VALUES ("LK4_33","072_4_33","LUK","4","33","33","Adda ɓoy wede Yawudiyagi ge dooyiso geŋ i dʼede wedusu i-dʼede siitan a eedí, yʼa iɗili ti golla awwa, yʼede: ");
INSERT INTO moz_vpl VALUES ("LK4_34","072_4_34","LUK","4","34","34","«Wayya Isa wede ti geeger Nazaret no, ki dehu moo me a tukki kaye me? Ay suune kee kʼiido kono kʼay diʼn dagge. Kee nuŋ ni ki suune, kee Wede Kamilen̰ Raa yʼigibo.» ");
INSERT INTO moz_vpl VALUES ("LK4_35","072_4_35","LUK","4","35","35","Maŋ Isa yi di ruute ti golla zakiɗi, yʼede: «Koŋ mʼa tʼappa bizí wo mi tʼaɗɗo ti tukki wede me.» Wede geŋ siitan tʼaa diin̰e siiɗo a diinayaŋ wo tʼa tʼuɗɗe ti tuddí, ti-kʼize munɗa ulsu ye. ");
INSERT INTO moz_vpl VALUES ("LK4_36","072_4_36","LUK","4","36","36","Kane ɗoŋ pay orgiso tʼanni ziiɗa wo an dʼiise rootiyto ti tuddaŋ, anʼde: «Urzi kʼono ɗoŋ kino eŋ miŋ mummino me! Wede eŋ tʼurzi wede an i ele wo ti toogo ere i-dʼede gette, siitanɗani yʼan di rootiyo an tʼaɗɗe, wo an tʼaɗɗiya.» ");
INSERT INTO moz_vpl VALUES ("LK4_37","072_4_37","LUK","4","37","37","Wo Isa sundí ti môolo adda siiɗo gette pay. ");
INSERT INTO moz_vpl VALUES ("LK4_38","072_4_38","LUK","4","38","38","Isa geŋ tʼadda ɓoy wede Yawudiyagi ge dooyiso yi-tʼuɗɗe, yʼa tʼiide daŋ Simo. Aame yʼiiney maŋ yi-tʼuuney ande Simo i-ti dʼiire girgir, wo an tunde Isa, anʼde: «Erewo ette mummino ki iso!» ");
INSERT INTO moz_vpl VALUES ("LK4_39","072_4_39","LUK","4","39","39","Maŋ Isa yʼaa dʼuttile ki tuddutú, wo yʼa ruute ti golla zakiɗi a ooriyo tʼa tʼooli. A kaamiki ooriyo tʼa tʼiili, todʼ tʼa tʼiiziga wo tʼan dʼiise naabiya. ");
INSERT INTO moz_vpl VALUES ("LK4_40","072_4_40","LUK","4","40","40","A peeɗo tʼa tʼiire maŋ, kane ɗoŋ pay an dʼede ɗoŋzaŋ eeni wede tuuku toŋ tʼita kʼeenizí kʼeenizí geŋ, an i di ziko a Isa. Yoŋ a wede tuuku toŋ yi di zaapu beezí beezí, wo kane an dʼooniyo bee. ");
INSERT INTO moz_vpl VALUES ("LK4_41","072_4_41","LUK","4","41","41","Iŋkino kane siitanɗani toŋ an tʼaɗɗiyta kay ti tukki ɗoŋ ɓaadaŋ kaŋ ɗollite, an dʼeesiyo: «Kee Ulo Raa! Kee Ulo Raa!» Wo yo Isa yʼan di rootiyo ti golla zakiɗi wo yʼan kʼooliyo urzi an ki dʼorba ye, kono kane an yi suune yoŋ Almasi Raa yi biire me. ");
INSERT INTO moz_vpl VALUES ("LK4_42","072_4_42","LUK","4","42","42","Aame ume i tʼumpile maŋ, ti Kapernayim Isa yʼa tʼuɗɗe yʼa iŋgile kʼadda balɗa. Kane ɗoŋ duuru an di yʼ dehutu. Aame an yʼuune maŋ, kane an dehu yʼa lekke a sirpadaŋ wo an di yʼeegire yi kiʼn ooli ye. ");
INSERT INTO moz_vpl VALUES ("LK4_43","072_4_43","LUK","4","43","43","Wo Isa yʼan di ruute, yʼede: «A geegiryagi ɗoŋ ti doolo toŋ, i dehu nʼan kizite Rabila Majjaanawa ki Moziko Raa tʼiina, kono yi nʼigibo miŋ kʼiŋkino.» ");
INSERT INTO moz_vpl VALUES ("LK4_44","072_4_44","LUK","4","44","44","Maŋ adda siiɗo Ziide yi kazita adda ɓoyɗi ɗoŋ Yawudiyagi ge dooyiso. ");
INSERT INTO moz_vpl VALUES ("LK5_1","072_5_1","LUK","5","1","1","Onniyo soo Isa yoŋ a biza bar ki Zenezaret, wo kane ɗoŋ duuru an di-tʼugiye, an di ŋaaƴu ti tuddaŋ kono an dehu an dʼolliga ono Raa. ");
INSERT INTO moz_vpl VALUES ("LK5_2","072_5_2","LUK","5","2","2","Maŋ a biza geŋ yi wulle tookiyagi sire, ɗoŋ sawwiya an ti ɗiggite an opilsito lembiɗagaŋ. ");
INSERT INTO moz_vpl VALUES ("LK5_3","072_5_3","LUK","5","3","3","Isa geŋ yi di gili adda tooko ere soo, todʼte ki Simo, wo yi di ruute a yoŋ, yʼede: «Ti zeŋge kʼin odo kʼadda kʼahu booloŋ.» Aame an a iide kʼadda maŋ, Isa yʼa-guune ekki tooko wo yʼa iise dooyiso ɗoŋ duuru. ");
INSERT INTO moz_vpl VALUES ("LK5_4","072_5_4","LUK","5","4","4","Aame yʼa ti ɗiŋge dooyisadí maŋ, yi di ruute a Simo, yʼede: «Kun a odo kʼadda mohita gettiyo, wo kun ti kakko lembiɗaguŋ, kun sawwoy puuni.» ");
INSERT INTO moz_vpl VALUES ("LK5_5","072_5_5","LUK","5","5","5","Maŋ Simo yi diʼn gime onamí, yʼede: «Wede dooyiso, diɗɗo ette kaye ay niite bini bini toŋ, munɗa ay kʼuune ye, wo a onamá geŋ kaye ay di-kakke lembiɗagey me.» ");
INSERT INTO moz_vpl VALUES ("LK5_6","072_5_6","LUK","5","6","6","Aame an ti gikke maŋ, an di ziki puuni lembiɗagaŋ ɓokɓok aa a sittite. ");
INSERT INTO moz_vpl VALUES ("LK5_7","072_5_7","LUK","5","7","7","Iŋkino maŋ kane an dʼumɓe beezaŋ, i-kaza laŋziyagaŋ ɗoŋ adda tooko ere ti doolo an tʼokko noogiyadaŋ. Kane an iido maŋ, ti kane pay an tʼûunite ɓokɓok ti puuni tookiyagi sire geŋ aa i di sooyite. ");
INSERT INTO moz_vpl VALUES ("LK5_8","072_5_8","LUK","5","8","8","Aame Simo Piyer yi wulle iŋkino maŋ, yʼa-dikke a ɗaana kʼIsa wo yʼa ruute, yʼede: «Galmeeʼki nuŋ, kʼa leɗɗo ti tuddó me, kono nuŋ wede kʼolɗiko.» ");
INSERT INTO moz_vpl VALUES ("LK5_9","072_5_9","LUK","5","9","9","Yi rootiyo iŋkino kono yode ti ɗoŋ a itadí pay orgiso tʼanni ziiɗa ɓaadaŋ, a ɓaadika puuni ɗoŋ an ziki geŋ me. ");
INSERT INTO moz_vpl VALUES ("LK5_10","072_5_10","LUK","5","10","10","Wo Zak ti Zaŋ in̰n̰i Zebede, kane ɗoŋ naabadaŋ kaŋ soo ti Simo me, toŋ iŋkino kay orgiso tʼanni ziiɗa. Wo ɗe Isa yi di ruute a Simo, yʼede: «Kee kʼorgiɗe ye, ti aŋki eŋ kʼa tʼisa wede dehutu ɗuwo an dʼetto kʼurzizó.» ");
INSERT INTO moz_vpl VALUES ("LK5_11","072_5_11","LUK","5","11","11","Iŋkino aame ti tookiyagaŋ an iiney biza zeŋge maŋ, sulɗizaŋ pay an dʼiili gen̰n̰o, an di diine Isa. ");
INSERT INTO moz_vpl VALUES ("LK5_12","072_5_12","LUK","5","12","12","Onniyo soo Isa yi tʼiide kʼadda geeger soo ki siiɗo Galile, a ume geŋ i dʼiido wede bitiɗe tuddí risimik. Aame yi wulle Isa maŋ, yʼa tʼuttile zumayí a siiɗo, wo yʼa yi tunde, yʼede: «Galmeeʼki nuŋ, ki dehu maŋ, kʼo eli beeko nʼa tʼise kamilen̰ a ɗaana Raa.» ");
INSERT INTO moz_vpl VALUES ("LK5_13","072_5_13","LUK","5","13","13","Maŋ Isa yʼa igibe beezí, yʼa yi butte wo yʼa ruute, yʼede: «Nuŋ ni dehu, ki tʼiso kamilen̰!» A kaamiki bitiɗayí a n̰ukkiɗe. ");
INSERT INTO moz_vpl VALUES ("LK5_14","072_5_14","LUK","5","14","14","Wo Isa yi di ruute, yʼede: «Kʼollo koɗuwo, a munɗa wede ize eŋ, a wenɗa soo toŋ ki rootey ye! Wo ɗe kʼodo deddet, ki-ti kazoy tuddá a wede seɗeke yʼa ki ti wolley, wo kʼa eloy munɗa ki seɗeke a kize ki tʼize kamilen̰ aa Muusa yʼa ruute adda kʼoogoro in dʼise, kono ɗoŋ pay an di wolle kee kʼuune bee.» ");
INSERT INTO moz_vpl VALUES ("LK5_15","072_5_15","LUK","5","15","15","Aame geŋ rabila kʼIsa ti-teepiyo ki teepiyo, wo ɗoŋ ɓaadaŋ an dʼettiyo ki tuddí kono an dʼollige onamí wo an dʼooniyo beeko kʼenɗanzaŋ. ");
INSERT INTO moz_vpl VALUES ("LK5_16","072_5_16","LUK","5","16","16","Wo yo Isa yi tʼargu kʼadda balɗa kono yi-tondiyo Raa. ");
INSERT INTO moz_vpl VALUES ("LK5_17","072_5_17","LUK","5","17","17","Onniyo soo Isa yi dooyiso ɗuwo. Kane Pariziyeŋ ti ɗoŋ suuniyo kʼoogoro, an iido ti illiyagi ɗoŋ pay ki siiɗo Galile, ki siiɗo Ziide, wo ki Zeruzalem, an di-guune a sirpadí. Wo toogo Galmeega Raa ti yode, ti-dʼeliyo urzi yʼan dʼeliyo beeko a ɗoŋ kʼeeni. ");
INSERT INTO moz_vpl VALUES ("LK5_18","072_5_18","LUK","5","18","18","Aame geŋ i dʼiido ɗuwo an dʼumɓo wede ruŋguyuŋ ti zaaɗe, an dehu an ti yʼ tʼele kʼadda ɓoy an ti yʼ zaape a ɗaana kʼIsa. ");
INSERT INTO moz_vpl VALUES ("LK5_19","072_5_19","LUK","5","19","19","Wo kono ɗuwo ɓaadaŋ geŋ urzi an ti yʼ tʼele kʼadda ɓoy umbo, iŋkino maŋ an a-ti gili tʼekki ɓoy gen̰n̰o, an dʼihina bulɗo, ruŋguyuŋ an ti yʼ zuuye ti zaaɗayí pây a diine ɗoŋ duuru a ɗaana kʼIsa. ");
INSERT INTO moz_vpl VALUES ("LK5_20","072_5_20","LUK","5","20","20","Isa yi wulle kane an ziipe addaŋ a yode maŋ, aame geŋ yʼa ruute, yʼede: «Olɗikadá nʼa yʼ tʼize tambobino.» ");
INSERT INTO moz_vpl VALUES ("LK5_21","072_5_21","LUK","5","21","21","Maŋ kane ɗoŋ suuniyo kʼoogoro ti Pariziyeŋ, an dʼelkiso adda kʼaddaŋ, anʼde: «Yo wede eŋ miŋ wee wee yi kalɗita suma Raa iŋkino me? Wee wee aane aase tambobino a olɗiko wede, daa ki Raa siidí ye maŋ?» ");
INSERT INTO moz_vpl VALUES ("LK5_22","072_5_22","LUK","5","22","22","Isa elkisadaŋ yʼa ti zuune wo yʼan di ruute, yʼede: «Ki moo me kun dʼelkiso adda kʼadduguŋ iŋkino me? ");
INSERT INTO moz_vpl VALUES ("LK5_23","072_5_23","LUK","5","23","23","Ise laylay a jiire miŋ too me a nuŋ nʼa roote: “Olɗikadá Raa yʼa yʼ tʼize tambobino” kunuŋ, nʼa roote: “Ki tʼoozo wo kʼa oziro” me? ");
INSERT INTO moz_vpl VALUES ("LK5_24","072_5_24","LUK","5","24","24","Wo ni dehu kun di suune, nuŋ wede an nʼehe aa ulo wede eŋ, adda duniya ette o dʼede toogo kʼisiyo tambobino a olɗiko.» Maŋ yi di ruute a wede ruŋguyuŋ, yʼede: «Nuŋ nʼa di rooto, ki tʼoozo, ki tʼamɓo zaaɗayá, kʼa aaho ɓoozá.» ");
INSERT INTO moz_vpl VALUES ("LK5_25","072_5_25","LUK","5","25","25","A kaamiki geŋ wede yʼa tʼiiziga a ɗaana ɗuwo pay, yʼa tʼumɓe zaaɗayí wede yi moone eego, wo yʼa aahe ɓoozí yi tamma Raa. ");
INSERT INTO moz_vpl VALUES ("LK5_26","072_5_26","LUK","5","26","26","Kane ɗoŋ pay geŋ an ziiɗa giggiraŋ wo an tamma Raa. Ti orgiso ɓaadaŋ adda kʼaddaŋ an di rootiyo, anʼde: «Aŋki kaye ay wulle sulɗi ɗoŋ ki kʼaane ki ki tiʼn roote ye!» ");
INSERT INTO moz_vpl VALUES ("LK5_27","072_5_27","LUK","5","27","27","Saŋ maŋ tiŋ geŋ Isa yʼa tʼuɗɗe wo yi wulle wede seɗɗu jibaaye sundí Lebi, yi-guune a ume naabadí yi seɗɗu jibaaye. Isa yi di ruute, yʼede: «Ki ni daani.» ");
INSERT INTO moz_vpl VALUES ("LK5_28","072_5_28","LUK","5","28","28","Maŋ yoŋ yʼa tʼiiziga, sulɗizí pay yi dʼiili, wo yʼa yi diine. ");
INSERT INTO moz_vpl VALUES ("LK5_29","072_5_29","LUK","5","29","29","Lebi yi dʼize omɓo ɓaadaŋ a ɓoozí a suma kʼIsa, i dʼede ɗoŋ seɗɗu jibaaye ɓaadaŋ wo ɗoŋ ti doolo toŋ ede, an di-guune omɓo ti kane kaŋ soo. ");
INSERT INTO moz_vpl VALUES ("LK5_30","072_5_30","LUK","5","30","30","Kane Pariziyeŋ ti ɗoŋ suuniyo kʼoogoro a diinayaŋ an dʼorbe sun̰n̰i sun̰n̰i, an an di ruute a sanalliyagi kʼIsa, anʼde: «Ki moo me kun dʼomɓo wo kun di soɓo ti ɗoŋ seɗɗu jibaaye wo ti ɗoŋ kʼolɗiko oŋgo me?» ");
INSERT INTO moz_vpl VALUES ("LK5_31","072_5_31","LUK","5","31","31","Maŋ Isa yʼan diʼn gime onamaŋ, yʼede: «Kane ɗoŋ waalin̰ an ki yʼ dehe ye wede daawiya me, wo i yi dehe ɗoŋ kʼeeni. ");
INSERT INTO moz_vpl VALUES ("LK5_32","072_5_32","LUK","5","32","32","Nuŋ ni kʼiidoʼŋ waaku kane ɗoŋ ki diine ye, wo ɗe nʼiidoʼŋ waaku kane ɗoŋ kʼolɗiko kono an di-kime lekkiyadaŋ.» ");
INSERT INTO moz_vpl VALUES ("LK5_33","072_5_33","LUK","5","33","33","Kane Pariziyeŋ an i di ruute a Isa, anʼde: «Sanalliyagi ki Zaŋ ti ɗoŋ ki kaye, onniyo muno an di lekkiyo daa kʼomɓo wo an tondiyo Raa, wo kaciŋ kane sanalliyagá an dʼomɓo wo an di soɓo me.» ");
INSERT INTO moz_vpl VALUES ("LK5_34","072_5_34","LUK","5","34","34","Isa yʼan di ruute, yʼede: «Kun elkiyo miŋ ɗuwo ɗoŋ anʼni wiiko a tarnaape ki seeɗu, kun diʼn ise ki toogo an di lekke daa kʼomɓo ko, aame kule kʼere yoŋ a sirpadaŋ geŋ me? Aha, iŋkino ye! ");
INSERT INTO moz_vpl VALUES ("LK5_35","072_5_35","LUK","5","35","35","Wo saŋ onniytagi an dʼaana, aame kule kʼere ti diinayaŋ an ti yʼumɓa maŋ. A onniytagi geŋ kane onniyo muno an di lekka daa kʼomɓo kollo.» ");
INSERT INTO moz_vpl VALUES ("LK5_36","072_5_36","LUK","5","36","36","Isa yʼan di ruute ono ombiɗe en̰n̰o sey, yʼede: «Beehiye ye wenɗa yi sitte buuɗe kalle aware kono yʼa-tʼobbira ekki kalle mazzini me, para maŋ kalle wede aware ki ti yʼ zitto wo buuɗe kalle wede aware ki zittoʼŋ geŋ, ti kalle mazzini an ki tʼokkiƴa ye. ");
INSERT INTO moz_vpl VALUES ("LK5_37","072_5_37","LUK","5","37","37","Wo beehiye ye wenɗa yi tʼeepe toote kʼin̰n̰i bin̰ wede oozige ɓotto adda riitile wede mazzini me, para maŋ toote wede oozige ɓotto geŋ yʼa-ɓatte riitile, toote a tʼoɓi siiɗo wo riitile a latte pây. ");
INSERT INTO moz_vpl VALUES ("LK5_38","072_5_38","LUK","5","38","38","Ki too maŋ i dehu toote wede oozige ɓotto geŋ eepiyadí adda riitile wede aware. ");
INSERT INTO moz_vpl VALUES ("LK5_39","072_5_39","LUK","5","39","39","Geŋ wede tuuku yi tʼiiɓe toote wede iine maŋ, toote wede oozige ɓotto geŋ yi ki yʼ dehe ye kono yʼa tʼeese: “Wede iine uŋse a jiire.”» ");
INSERT INTO moz_vpl VALUES ("LK6_1","072_6_1","LUK","6","1","1","Onniyo soo ere ki puukiyo Yawudiyagi maŋ, Isa yi doopiɗe tʼadda domɓi ɗoŋ ki geme ti sanalliyagí. Aame geŋ kane sanalliyagí an sattita geme, an tʼaɗɗuzu an tʼayɗu. ");
INSERT INTO moz_vpl VALUES ("LK6_2","072_6_2","LUK","6","2","2","Kane Pariziyeŋ oŋgo an di ruute, anʼde: «Ki moo me kun dʼisiyo munɗa wede oogiradiŋ ti kʼele urzi kʼisiyo ye, a onniyo ere ki puukiyadiŋ te?» ");
INSERT INTO moz_vpl VALUES ("LK6_3","072_6_3","LUK","6","3","3","Maŋ Isa yʼan diʼn gime onamaŋ, yʼede: «Ki kotto kun gire munɗa wede ti kaaga onniyo soo yode Dawut yʼize ti ɗoŋ a itadí, aame mosogo tiʼni ziiɗa geŋ me. ");
INSERT INTO moz_vpl VALUES ("LK6_4","072_6_4","LUK","6","4","4","Yi-tʼiide adda Ɓoy Raa wede an ikkima ki golmodo, yʼa ziki mappa wede an i ele seɗeke a Raa, wo yode ti ɗoŋ a itadí an dʼiimi. Wo Raa yʼan kʼize munɗa ye, ki too maŋ kane an kʼede ye urzi an dʼoomi me, oogiradiŋ tʼele urzi a ɗoŋ seɗeke ɗaŋŋal.» ");
INSERT INTO moz_vpl VALUES ("LK6_5","072_6_5","LUK","6","5","5","Maŋ Isa yʼan di ruute, yʼede: «Nuŋ wede an nʼehe aa ulo wede eŋ, o dʼede urzi kʼisiyo munɗa wede aa addó i dehu ekkʼonniyo ere ki puukiyadiŋ te.» ");
INSERT INTO moz_vpl VALUES ("LK6_6","072_6_6","LUK","6","6","6","A onniyo ere ki puukiyo Yawudiyagi ti doolo maŋ, Isa yi-tʼiide adda ɓoy wede Yawudiyagi ge dooyiso, yʼa iise dooyiso ɗuwo. Adda ɓoy geŋ i dʼede wedusu soo iŋkino beezí wede kʼammade unto. ");
INSERT INTO moz_vpl VALUES ("LK6_7","072_6_7","LUK","6","7","7","Kane ɗoŋ suuniyo kʼoogoro ti Pariziyeŋ, an dehu an tʼoone urzi an di sakiya Isa, kono kamo an di wolliyo koomadí, a onniyo ere ki puukiyo Yawudiyagi a wede yi-tʼela beeko ko? ");
INSERT INTO moz_vpl VALUES ("LK6_8","072_6_8","LUK","6","8","8","Wo yo Isa yi suune elkisadaŋ te, iŋkino maŋ yi di ruute a wede beezí unto geŋ, yʼede: «Kee ki tʼoozo, ki tʼôhor a ɗaana ɗuwo pay kino.» Maŋ wede yʼa tʼiiziga, yʼa tʼîhira a umayí gen̰n̰o. ");
INSERT INTO moz_vpl VALUES ("LK6_9","072_6_9","LUK","6","9","9","Saŋ Isa yʼan di ruute, yʼede: «Nʼun diʼn tondo ɗo, oogiradiŋ tʼele urzi kʼisiyo ki moo me a onniyo ere ki puukiyadiŋ te? A wedusu ki-dʼise beehiye kunuŋ, ki-dʼise ulsu ko? Wedusu kʼa yʼutte kunuŋ, kʼa yi tʼîde ko?» ");
INSERT INTO moz_vpl VALUES ("LK6_10","072_6_10","LUK","6","10","10","Aame geŋ kane ɗoŋ pay Isa yi diʼn wolliyo adda kʼedayaŋ, wo saŋ yi di ruute a wede geŋ, yʼede: «Beezá ki yʼonɗo.» Maŋ yʼa yʼunɗe, wo beezí a tʼikkima. ");
INSERT INTO moz_vpl VALUES ("LK6_11","072_6_11","LUK","6","11","11","Wo kane ɗoŋ suuniyo kʼoogoro ti Pariziyeŋ geŋ addaŋ a ûune ti kulkuwo, an di rootiyto ti tuddaŋ a munɗa wede an aane an i dʼise a tukkʼIsa geŋ me. ");
INSERT INTO moz_vpl VALUES ("LK6_12","072_6_12","LUK","6","12","12","Aame geŋ saŋ Isa yʼa-gili kʼekki kesse kono yʼa tonde Raa, wo diɗɗo yʼa-tʼumpile pay ti tondiyo Raa. ");
INSERT INTO moz_vpl VALUES ("LK6_13","072_6_13","LUK","6","13","13","Aame ume i tʼumpile maŋ, Isa yʼa wiike sanalliyagí, wo yi biire ti diinayaŋ ɗoŋ koomat makumu sire yʼanni wiike sundaŋ ɗoŋ zina. ");
INSERT INTO moz_vpl VALUES ("LK6_14","072_6_14","LUK","6","14","14","Kane sumɓiyagaŋ: Simo wede Isa yʼa yi wiike sundí soo te Piyer, wo leemadí Andire; Zak, Zaŋ, Pilip, Bartelemi, ");
INSERT INTO moz_vpl VALUES ("LK6_15","072_6_15","LUK","6","15","15","Matiye, Toma wo Zak ulo kʼAlpe; Simo wede an yi waaku wede addí wehini kono siiɗadí me; ");
INSERT INTO moz_vpl VALUES ("LK6_16","072_6_16","LUK","6","16","16","Ziidas ulo ki Zak, wo Ziidas Iskariyot wede saŋ yʼa tʼowila Isa. ");
INSERT INTO moz_vpl VALUES ("LK6_17","072_6_17","LUK","6","17","17","Saŋ maŋ tʼekki kesse Isa ti kane ɗoŋ yi biire an di ɗiigo ki bere wede ekki kesse gen̰n̰o batum, a ume wede sanalliyagí ɗoŋ ɓaadaŋ an tʼugiye. A ume gen̰n̰o toŋ i dʼede ɗoŋ duuru ɓaadaŋ an iido ti siiɗo Ziide pay, ti geeger Zeruzalem, wo ti geeger Tir ti Sidoŋ ɗoŋ a biza bar. ");
INSERT INTO moz_vpl VALUES ("LK6_18","072_6_18","LUK","6","18","18","Kane an iido kono an dehu an di yʼolliga wo yʼan tʼele beeko a enɗanzaŋ. Wo kane ɗoŋ siitanɗani anʼni dabirsa geŋ, yʼan dʼele beeko. ");
INSERT INTO moz_vpl VALUES ("LK6_19","072_6_19","LUK","6","19","19","Kane ɗoŋ duuru pay an dehu an di botte tudde kʼIsa, kono toogo i dʼaɗɗiya ti tuddí, an dʼooniyo beeko pay. ");
INSERT INTO moz_vpl VALUES ("LK6_20","072_6_20","LUK","6","20","20","Iŋkino maŋ Isa yʼa zibbe edayí kʼume sanalliyagí wo yʼa ruute, yʼede: «Uŋsuwo a kune ɗoŋ un kʼede munɗa ye, kono Moziko Raa todʼte ki kune. ");
INSERT INTO moz_vpl VALUES ("LK6_21","072_6_21","LUK","6","21","21","Uŋsuwo a kune ɗoŋ aŋken̰n̰o mosogo tʼunni tôwwo, kono saŋ maŋ omɓo tʼun diʼn pilɗey. Uŋsuwo a kune ɗoŋ aŋken̰n̰o kun môolo, kono saŋ maŋ kun di koobitey. ");
INSERT INTO moz_vpl VALUES ("LK6_22","072_6_22","LUK","6","22","22","Uŋsuwo a kune aame ɗuwo an un olmiɗe, an unni koogire, an unni kalɗita wo an un rootiyto ono ɗoŋ ulpi a egguŋ, kono kun ziipe adduguŋ a nuŋ wede an nʼehe aa ulo wede en̰n̰o. ");
INSERT INTO moz_vpl VALUES ("LK6_23","072_6_23","LUK","6","23","23","Aame sulɗi geŋ an iina maŋ, kune ulbuguŋ un iso uŋse wo kun olɗito uŋsuwo kʼawwa, kono munɗa wede Raa yi dehu yʼun tʼeley geŋ, yoŋ ɓaadaŋ yʼunni delliyo a kandaane. Geŋ iŋkino kay kane maawaŋ anʼni dibire nebiyagi ɗoŋ ti kaaga me. ");
INSERT INTO moz_vpl VALUES ("LK6_24","072_6_24","LUK","6","24","24","Wo ɗe dabar a kune ɗoŋ bey, kono uŋsuwaguŋ kun tʼuune baa. ");
INSERT INTO moz_vpl VALUES ("LK6_25","072_6_25","LUK","6","25","25","Dabar a kune ɗoŋ aŋken̰n̰o omɓo tʼunni palɗa, kono saŋ maŋ mosogo tʼun diʼn tʼîdey. Dabar a kune ɗoŋ aŋken̰n̰o i koobiyto, kono saŋ maŋ kun di lekkey adda môolo wo kun dʼôoley ti zumari a edaguŋ. ");
INSERT INTO moz_vpl VALUES ("LK6_26","072_6_26","LUK","6","26","26","Dabar a kune aame ɗuwo pay an unni tamma maŋ, kono geŋ iŋkino kay kane maawaŋ an ize ti ɗoŋ an ti tʼisiyo tuddaŋ aa nebiyagi.» ");
INSERT INTO moz_vpl VALUES ("LK6_27","072_6_27","LUK","6","27","27","«Wo nʼun di rooto a kune ɗoŋ i nʼollige: Kun geyyo kane ɗoŋ ti kune adu, kun an iso beehiye a ɗoŋ unnʼolmiɗe me. ");
INSERT INTO moz_vpl VALUES ("LK6_28","072_6_28","LUK","6","28","28","Kun zaapo beeko a ɗoŋ unni duuɗiyo, wo kun tondo Raa kono ɗoŋ i rootiyto ono ulpi a tukki kune. ");
INSERT INTO moz_vpl VALUES ("LK6_29","072_6_29","LUK","6","29","29","Aame wede yi ki diin̰e a toɓɓisadá ki bita maŋ, ki kama toɓɓisadá ere soo toŋ maŋ yʼa ki ti daan̰a. Aame wede yi tʼumɓe kallayá wede goole maŋ, ki-oolo kallayá wede n̰eŋku tʼadda toŋ yʼa tʼamɓo pây. ");
INSERT INTO moz_vpl VALUES ("LK6_30","072_6_30","LUK","6","30","30","Wede tuuku yi tondiyo munɗa ti beezá maŋ, ki eelo, wo aame wede yi tʼumɓe munɗazá maŋ, ki yʼ tonda ye. ");
INSERT INTO moz_vpl VALUES ("LK6_31","072_6_31","LUK","6","31","31","Munɗa wede kun dehu ɗuwo an un dʼise geŋ, a kane toŋ kun an iso iŋkino kay. ");
INSERT INTO moz_vpl VALUES ("LK6_32","072_6_32","LUK","6","32","32","Aame kun geyyiso ɗoŋ unni geyyiso ɗaŋŋal maŋ, sunduguŋ ede ɗey ko? Ɗerec, ɗoŋ kʼolɗiko toŋ kane an geyyiso ɗoŋ anʼni geyyiso kay. ");
INSERT INTO moz_vpl VALUES ("LK6_33","072_6_33","LUK","6","33","33","Wo aame kun isiyo beehiye a ɗoŋ unnʼisiyo beehiye ɗaŋŋal maŋ, sunduguŋ ede ɗey ko? Ɗerec, kane ɗoŋ kʼolɗiko batum toŋ an isiyo iŋkino kay. ");
INSERT INTO moz_vpl VALUES ("LK6_34","072_6_34","LUK","6","34","34","Aame kun eliyo see a wede kun elkiyo yʼun yi kima ɗaŋŋalaŋ maŋ, geŋ sunduguŋ ede ɗey ko? Ɗerec, ɗoŋ kʼolɗiko toŋ kane an eliyo see a ɗoŋ kʼolɗiko ɗoŋ aana an yi kima. ");
INSERT INTO moz_vpl VALUES ("LK6_35","072_6_35","LUK","6","35","35","Wo ki too maŋ kun geyyo kane ɗoŋ ti kune adu, kun an iso beehiye, kun an elo see me wo kun zaape adduguŋ eego ye aame an un ki yʼ gime ye toŋ maŋ. Iŋkino maŋ munɗa wede Raa yi dehu yʼun tʼeley geŋ yoŋ ɓaadaŋ, wo kun tʼisey in̰n̰i ki Raa goole a jiire pay. Ɗerec, yoŋ wede beehiye a ɗoŋ i ki rootiyo koɗuwo a yode ye, wo a ɗoŋ bundiɗi pây. ");
INSERT INTO moz_vpl VALUES ("LK6_36","072_6_36","LUK","6","36","36","Kun tʼiso ɗoŋ i wolliyo sommagi ɗuwo, aakede Meeguguŋ Raa toŋ yi wolliyo sommagi ɗuwo.» ");
INSERT INTO moz_vpl VALUES ("LK6_37","072_6_37","LUK","6","37","37","«Kun ɗekke booro a tukki wede tuuku toŋ maŋ ye, geŋ Raa toŋ yi ki ɗekka booro egguŋ ye. Kune ɗoŋ oŋgoŋ kun i seeɗa ti booro ye, geŋ booro Raa toŋ tʼun kiʼn seeɗa ye. Kun oyyo isiyo tambobino a wede tuuku toŋ maŋ, geŋ Raa toŋ yʼun tʼisa tambobino. ");
INSERT INTO moz_vpl VALUES ("LK6_38","072_6_38","LUK","6","38","38","Kune a wede tuuku toŋ kun i elo, geŋ Raa toŋ yʼun tʼeela. Yʼun tʼeela ɓaadaŋ adda munɗaguŋ ɓoo, sokkiyo wo a pilɗita. Ɗerec, dooziyo ere kun dooziyo a ɗuwo gette, Raa toŋ yʼun ti dooza a kune iŋkino kay.» ");
INSERT INTO moz_vpl VALUES ("LK6_39","072_6_39","LUK","6","39","39","Isa yʼan di ruute ono ombiɗe sey, yʼede: «Kun ollo, wede koosiyoʼŋ bakadí koosiyo yi yʼarkiɗe ko? Para maŋ sirwaŋ pay an di silɗiti adda kʼolɗe. ");
INSERT INTO moz_vpl VALUES ("LK6_40","072_6_40","LUK","6","40","40","Sanallusu geŋ, yoŋ tʼekki wede dooyisadí ye, wo ɗe wede tuuku yi-duuye beehiye maŋ, yʼa tʼise aa wede dooyisadí. ");
INSERT INTO moz_vpl VALUES ("LK6_41","072_6_41","LUK","6","41","41","Ki moo me ki wolliyo un̰umu wede adda kʼersa leemadá, wo undumu wede adda kʼersa kee, ki gi di yʼowwiyo ye me? ");
INSERT INTO moz_vpl VALUES ("LK6_42","072_6_42","LUK","6","42","42","Ɗe mummino kʼa aane ki di roote a leemadá, kʼa tʼeese: “Leema ki nuŋ, kʼoolo nʼa di tʼamɓo un̰umu wede adda kʼersadá en̰n̰o”, wo undumu wede adda kʼersadá, kee batum ki ki yʼ wolliyo ye me? Kee wede biza sire sire, ki tʼamɓo undumu wede adda kʼersadá ɗoo, iŋkino kʼa wolla keren̰, saŋ kʼa tʼamɓa un̰umu wede adda kʼersa leemadá kollo.» ");
INSERT INTO moz_vpl VALUES ("LK6_43","072_6_43","LUK","6","43","43","«Undumu wede beehiyeʼŋ, in̰n̰i ulpi yi ki tʼehe ye, wo undumu wede ulsu toŋ, in̰n̰i beehiye yi ki tʼehe ye. ");
INSERT INTO moz_vpl VALUES ("LK6_44","072_6_44","LUK","6","44","44","Undumu tuuku toŋ ki yʼ suune tʼurzi kʼin̰n̰izí. Geŋ iŋkino in̰n̰i tormo ki ki rakke ye ekkʼundumu kʼahimagi me, wo in̰n̰i kʼinda bin̰ ki ki rakke ye ekki woskani me. ");
INSERT INTO moz_vpl VALUES ("LK6_45","072_6_45","LUK","6","45","45","Wedusu wede beehiyeʼŋ, beehiyko tʼettiyo ti sulɗi ɗoŋ beehiye yʼukume adda kʼaddí, wo wedusu wede ulsuʼŋ, munɗa ulsu yʼettiyo ti sulɗi ɗoŋ ulpi yʼukume adda kʼaddí. Ɗerec, munɗa wede wedusu yʼokumso adda kʼaddí gen̰n̰o aɗɗiya ti bizí me.» ");
INSERT INTO moz_vpl VALUES ("LK6_46","072_6_46","LUK","6","46","46","«Ki moo me kune kun di nʼ waaku “Galmeegey, Galmeegey”, wo kun ki tʼisiyo ye munɗa wede nʼun rootiyo me? ");
INSERT INTO moz_vpl VALUES ("LK6_47","072_6_47","LUK","6","47","47","Wede tuuku yʼettiyo ki tuddó, yʼollige onamó wo yi sooru eego maŋ, nuŋ nʼun di roote yoŋ geŋ yi deeƴiso aa wee wee. ");
INSERT INTO moz_vpl VALUES ("LK6_48","072_6_48","LUK","6","48","48","Yode geŋ yi deeƴiso aa wede yʼoozige ɓoy. Yoŋ geŋ yi dʼittiba olɗe sohuru wo ita ɓoy yʼa di ziipe eego paŋgiragi. Kuyyo ti gilo wo ooye yʼa ûune i palɗita waawiye. Bormo gette tʼa ŋiiƴa ɓoy gen̰n̰o wo toŋ maŋ yʼa kʼiddira ye, kono ɓoy geŋ oozigayí koɗuwo. ");
INSERT INTO moz_vpl VALUES ("LK6_49","072_6_49","LUK","6","49","49","Wo ɗe wede yʼollige onamó wo yi ki sooru eego ye maŋ, yoŋ geŋ yi deeƴiso aa wede yʼa tʼiiziga ɓoy a siiɗo daa ki zaapu kʼita ɓoy. Ooye yʼa ûune i palɗita waawiye. Bormo gette tʼa ŋiiƴa ɓoy gen̰n̰o, wo a kaamiki ɓoy a ruuge, a n̰ulile pay.» ");
INSERT INTO moz_vpl VALUES ("LK7_1","072_7_1","LUK","7","1","1","Aame Isa onamí a ɗoŋ duuru yʼa tiʼn ɗiŋge pay maŋ, yʼa tʼiiziga yʼa iŋgile geeger Kapernayim. ");
INSERT INTO moz_vpl VALUES ("LK7_2","072_7_2","LUK","7","2","2","A ume geŋ i dʼede goole kʼasigiryagi meeda ki Romeŋ, yoŋ i-dʼede wede naabo yi yʼ giyye ɓaadaŋ wo yi-tʼiire eeni yʼunto. ");
INSERT INTO moz_vpl VALUES ("LK7_3","072_7_3","LUK","7","3","3","Aame goole kʼasigiryagi geŋ yʼilliga taaya kʼIsa maŋ, yi dʼigibe ɗoŋ i dokkiyo Yawudiyagi miibi ki tukki yode, an i-dʼoɓo bey kono yʼa ette yʼa uttey wede naabadí. ");
INSERT INTO moz_vpl VALUES ("LK7_4","072_7_4","LUK","7","4","4","Kane deero geŋ an iiney a sirpa kʼIsa maŋ, an i-dʼiise oɓe bey an koɗɗime, anʼde: «Wede eŋ, yʼîide kee kʼa ette kʼa di yʼ noogey, ");
INSERT INTO moz_vpl VALUES ("LK7_5","072_7_5","LUK","7","5","5","kono yoŋ geŋ siiɗadey yi ti giyye, wo ɓoy wede in di dooyiso toŋ ay iiziga yode.» ");
INSERT INTO moz_vpl VALUES ("LK7_6","072_7_6","LUK","7","6","6","Iŋkino maŋ Isa an di giƴƴe ti kane kaŋ soo, an dʼiŋgile. Aame yoŋ yʼiiney goppoŋ ti ɓoy maŋ, goole kʼasigiryagi meeda yi dʼigibe laŋziyagi, an i-di ruute, anʼde: «Goolayey yʼede: Galmeeʼki nuŋ, kee ki naate ye, kono nuŋ ni kʼîide ye kʼa ette ki ɓoozó me. ");
INSERT INTO moz_vpl VALUES ("LK7_7","072_7_7","LUK","7","7","7","Geŋ kono kʼiŋkino ni wulle tuddó maŋ, nuŋ batum o kʼede urzi nʼa kʼette ki tuddá ye. Wo tiŋ geŋ miŋ ki rooto munɗa soo kono wede naabadó yʼa tʼoone bee. ");
INSERT INTO moz_vpl VALUES ("LK7_8","072_7_8","LUK","7","8","8","Iŋkino nuŋ batum nʼottilso a ɗoŋ deero tʼeedó, wo i dʼede asigiryagi ɗoŋ nuŋ goole tʼeedaŋ. Aame ni rootiyo a wede soo: “Kʼodo!” maŋ, geŋ yi dʼeŋgilso. Aame ni rootiyo a wede doolo: “Kʼedi!” maŋ, geŋ yi dʼettiyo. Wo aame ni rootiyo a ɓulayó: “Naabo ette ki-tʼiso!” maŋ, geŋ yi-ti tʼisiyo.» ");
INSERT INTO moz_vpl VALUES ("LK7_9","072_7_9","LUK","7","9","9","Aame Isa yʼilliga ono gen̰n̰o maŋ, yʼa ziiɗa giggirí kono yode geŋ me, wo yʼa-gime ki tukki ɗoŋ duuru ɗoŋ i yi daaniya, yʼan di ruute, yʼede: «Kun ollo, nʼun di rooto: Adda siiɗo kʼIzirayel batum toŋ, ni kʼuune ye wede a zaape addí a Raa aa yode kino eŋ me.» ");
INSERT INTO moz_vpl VALUES ("LK7_10","072_7_10","LUK","7","10","10","Wo kane ɗoŋ zina an di-gime ki ɓoy, an iide maŋ an yʼuuney wede naabo yʼuune bee. ");
INSERT INTO moz_vpl VALUES ("LK7_11","072_7_11","LUK","7","11","11","Saŋ maŋ tiŋ geŋ Isa yʼa iŋgile ki geeger sundutú Nayin, sanalliyagí ti ɗoŋ duuru ɓaadaŋ an di yʼ daaniya. ");
INSERT INTO moz_vpl VALUES ("LK7_12","072_7_12","LUK","7","12","12","Aame yʼiiney goppoŋ ki biza bumɓu ki geeger gettiyo maŋ, an a-tʼikkima ti ɗuwo an tʼette ottibe nuune kʼulo obulsu ki mandaayawa yoŋ soo ɗaŋŋal yʼinda. Wo ɗoŋ ɓaadaŋ ti geeger gette a itatú. ");
INSERT INTO moz_vpl VALUES ("LK7_13","072_7_13","LUK","7","13","13","Aame Galmeega yi wulle erewo gettiyo maŋ, i di tʼize sommagi, wo yi di ruute, yʼede: «Koŋ mʼanna, mʼôole ye.» ");
INSERT INTO moz_vpl VALUES ("LK7_14","072_7_14","LUK","7","14","14","Saŋ yʼa dʼiide goppoŋ ki sirpa saŋgali yʼa-butte, maŋ ɗoŋ i sarkiya an tʼîhira, wo Isa yʼa ruute, yʼede: «Ulo ki nuŋ nʼa di rooto, ki tʼonno!» ");
INSERT INTO moz_vpl VALUES ("LK7_15","072_7_15","LUK","7","15","15","Maŋ wede inda yʼa tʼiizi, yʼa-guune, yʼa iise rootiyto, wo Isa yi di yʼele a meedí. ");
INSERT INTO moz_vpl VALUES ("LK7_16","072_7_16","LUK","7","16","16","Kane ɗoŋ pay orgiso tʼanni ziiɗa, wo an tamma Raa, anʼde: «I uɗɗo nebi goole a diinayiŋ, wo Raa yʼukko noogiyo ɗoŋzí!» ");
INSERT INTO moz_vpl VALUES ("LK7_17","072_7_17","LUK","7","17","17","Wo a munɗa wede Isa yʼize geŋ, rabiladí a-tiipe adda siiɗo Ziide pay, wo ti siiɗiyagi pay ɗoŋ i ti ɗuule. ");
INSERT INTO moz_vpl VALUES ("LK7_18","072_7_18","LUK","7","18","18","A sulɗi ɗoŋ pay ize geŋ, a goolayaŋ Zaŋ Batis sanalliyagí an i-di tʼîide taaya. Maŋ yoŋ yi wiike ɗoŋ sire ti diinayaŋ, ");
INSERT INTO moz_vpl VALUES ("LK7_19","072_7_19","LUK","7","19","19","wo yʼan igibe ki tukki Galmeega kono an ti yʼ tondo: «Kee miŋ Almasi Raa yi biire, saŋ a etto ko? Kunuŋ ay di dello wede doolo ko?» ");
INSERT INTO moz_vpl VALUES ("LK7_20","072_7_20","LUK","7","20","20","Aame an iiney a sirpa kʼIsa maŋ, an i-di ruute, anʼde: «Kaye Zaŋ Batis yʼaynʼigibo kono ay ki ti tonde: “Kee miŋ Almasi Raa yi biire, saŋ a etto ko? Kunuŋ ay di dello wede doolo ko?”» ");
INSERT INTO moz_vpl VALUES ("LK7_21","072_7_21","LUK","7","21","21","A ume geŋ miŋ Isa yʼan dʼele beeko a ɗoŋ kʼeeni ɓaadaŋ, ɗoŋ kesiyagaŋ soo soo, wo ɗoŋ an dʼede siitanɗani a eedaŋ, wo koŋzayi ɓaadaŋ edayaŋ yʼan diʼn ihinte. ");
INSERT INTO moz_vpl VALUES ("LK7_22","072_7_22","LUK","7","22","22","Saŋ yʼan diʼn gime onamaŋ, yʼede: «Kunʼdo a Zaŋ, kun i-tʼôodoy taaya a munɗa wede kun wulle wo kun illiga eŋ me: Koŋzayi an di wolliyo keren̰, ɗoŋ jekese an sooru beehiye, ɗoŋ bitiɗe an tʼize kamilen̰, duŋgiyagi an dʼollige, ɗoŋ unto an di bilɗe, wo Rabila Majjaanawa an an gizite a ɗoŋ an kʼede munɗa ye. ");
INSERT INTO moz_vpl VALUES ("LK7_23","072_7_23","LUK","7","23","23","Wo uŋsuwo a wede yʼa ziiɗa zakiɗi kono nuuno bini ɗaŋgu!» ");
INSERT INTO moz_vpl VALUES ("LK7_24","072_7_24","LUK","7","24","24","Ɗoŋ zina ki Zaŋ Batis an tʼiŋgile maŋ, saŋ Isa yʼa iise rootiyto a ɗoŋ duuru a tukki Zaŋ, yʼede: «Kun iide kʼadda balɗa wolliyo ki moo me? Ki wedusu wede aa alala ere maaye yi tʼagisa gettiyo ko? Aha! ");
INSERT INTO moz_vpl VALUES ("LK7_25","072_7_25","LUK","7","25","25","Ɗe iŋkino kun iide wolliyo ki moo me? Ki wedusu yi tʼusse kallagi majjanɗani ko? Wo ɗe kane ɗoŋ ossiyo kallagi majjanɗani wo an lekkiyo togos geŋ, an lekkiyo adda ɓoyɗi mozagi. ");
INSERT INTO moz_vpl VALUES ("LK7_26","072_7_26","LUK","7","26","26","Ɗe kun iide wolliyo ki moo me? Ki nebi ko? Eyye, wo kun ollo nʼun di rooto, yoŋ geŋ yi jiire nebi sey. ");
INSERT INTO moz_vpl VALUES ("LK7_27","072_7_27","LUK","7","27","27","Ɗerec, ono eŋ an riiŋe ti kaaga adda mattup ki Raa a tukki Zaŋ, anʼde: “Kun ollo, nuŋ nʼa tʼigiba wede zindó yʼa ooguma ki poone ti kee, yʼa di tʼokkimey urzizá.”» ");
INSERT INTO moz_vpl VALUES ("LK7_28","072_7_28","LUK","7","28","28","Isa yʼa ruute sey, yʼede: «Kun ollo, nʼun di rooto, ti diine ɗuwo ɗoŋ pay erayi an ehe geŋ, wede aase goole a ceere Zaŋ umbo. Wo iŋkino toŋ maŋ, wede yoŋ n̰eŋku a jiire adda Moziko Raa geŋ, yoŋ goole yi jiire Zaŋ. ");
INSERT INTO moz_vpl VALUES ("LK7_29","072_7_29","LUK","7","29","29","Kane ɗoŋ pay ti ɗoŋ seɗɗu jibaaye batum toŋ an di yʼilliga, an di zuune Raa yoŋ ki diine, maŋ an dʼiyye Zaŋ yʼa tiʼn zuyye batem. ");
INSERT INTO moz_vpl VALUES ("LK7_30","072_7_30","LUK","7","30","30","Wo kane Pariziyeŋ ti ɗoŋ suuniyo kʼoogoro, an di giigira munɗa wede Raa yi dehu yʼaase a kane me, maŋ an di-tuuge Zaŋ yʼa tiʼn suyye batem me.» ");
INSERT INTO moz_vpl VALUES ("LK7_31","072_7_31","LUK","7","31","31","Isa yʼa ruute sey, yʼede: «Ɗoŋ aŋken̰n̰o eŋ nʼa tʼeese kane aa wee wee? An deeƴiso aa wee wee? ");
INSERT INTO moz_vpl VALUES ("LK7_32","072_7_32","LUK","7","32","32","Kane an deeƴiso aa in̰n̰i an ti guune a bere ɗoŋ duuru, an di waakutu eebaŋ, an dʼeesiyo: “Kaye ay un di biiha siraro toŋ maŋ, kun ki dʼimmira ye! Ay un dʼûure ôoro kʼunto toŋ maŋ, kun ki dʼîile ye!” ");
INSERT INTO moz_vpl VALUES ("LK7_33","072_7_33","LUK","7","33","33","Iŋkino Zaŋ Batis yʼiina geŋ, yi kʼomɓo mappa ye, toote kʼin̰n̰i bin̰ yi kʼiiɓe ye, wo kun di rootiyo, kunʼde: “Yoŋ i-dʼede siitan a eedí.” ");
INSERT INTO moz_vpl VALUES ("LK7_34","072_7_34","LUK","7","34","34","Wo nuŋ wede an nʼehe aa ulo wede eŋ, nʼiina maŋ ni dʼomɓo ni soɓo, wo kun di rootiyo, kunʼde: “Kun wollo, wede eŋ yʼelkiyo miŋ a omɓo ti soɓo toote kʼin̰n̰i bin̰ ɗaŋŋal, yoŋ laŋze ki ɗoŋ seɗɗu jibaaye wo ti ɗoŋ kʼolɗiko oŋgo.” ");
INSERT INTO moz_vpl VALUES ("LK7_35","072_7_35","LUK","7","35","35","Wo Raaʼŋ suuniyo kʼono ere i dʼede, ɗuwo an ti zuune todʼte ki diine tʼurzi kʼin̰n̰izí pay.» ");
INSERT INTO moz_vpl VALUES ("LK7_36","072_7_36","LUK","7","36","36","I dʼede wede soo iŋkino yoŋ Pariziyeŋ, yʼa wiike Isa yʼa oomey di yode. Isa yʼa tʼiide di wede gen̰n̰o wo an di-guune an dʼoomi. ");
INSERT INTO moz_vpl VALUES ("LK7_37","072_7_37","LUK","7","37","37","I dʼede adda geeger gette, erewo sundutú ti môolo kʼisiyo kʼolɗiko. Aame tʼilliga Isa an ti guune omɓo di wede Pariziyeŋ gen̰n̰o maŋ, ti dʼumɓo ulo diŋgile an ikkima ki mokkolo sundutú albaatir, adda egey ɗoŋ eeɗiyadaŋ uŋse. ");
INSERT INTO moz_vpl VALUES ("LK7_38","072_7_38","LUK","7","38","38","Ti-tʼiide dar kʼIsa a ume zoŋɗí wo tʼa iise môolo, zoŋɗí tʼa tiʼn zuyye ti zumartú, tʼa tiʼn zippite tʼilaltú, ti-dʼize puuc a zoŋɗí i-kaza ottilsatú ɓaadaŋ a yoŋ me, wo ti di ƴirgite egey geŋ a zoŋɗí. ");
INSERT INTO moz_vpl VALUES ("LK7_39","072_7_39","LUK","7","39","39","Aame yo Pariziyeŋ wede i wiike Isa yi wulle iŋkino maŋ, yʼa ruute tʼadda kʼaddí, yʼede: «Aame wede eŋ yoŋ nebi ki kotto maŋ, yʼa ti suune erewo ere i yʼ butte gettiŋ wee te, todʼte ere an amɓu sundutú kʼisiyo kʼolɗiko.» ");
INSERT INTO moz_vpl VALUES ("LK7_40","072_7_40","LUK","7","40","40","Iŋkino Isa yʼa tʼihina bizí, yi di ruute a Pariziyeŋ, yʼede: «Simo, nuŋ oo ede ono nʼa di roote.» Maŋ yi diʼn gime onamí, yʼede: «Wede dooyiso, ki rooto.» ");
INSERT INTO moz_vpl VALUES ("LK7_41","072_7_41","LUK","7","41","41","Isa yʼa ruute, yʼede: «I dʼede ɗoŋ sire, an i di kime soŋko ki wede yʼan ele see. Wede soŋ yi di-kime tamma meeda paat, wo soŋ tamma ada paat. ");
INSERT INTO moz_vpl VALUES ("LK7_42","072_7_42","LUK","7","42","42","Aakede kane an kʼiine kamatú ye geŋ, wede yʼan dʼize beeko, sirwaŋ pay seezaŋ yʼan di yʼîide. Kane ɗoŋ sire geŋ, wede a yi geyye a di ceere tuuku me?» ");
INSERT INTO moz_vpl VALUES ("LK7_43","072_7_43","LUK","7","43","43","Simo yi diʼn gime onamí, yʼede: «A elkiyadó maŋ, yi ize beeko a wede seezí ɓaadaŋ a jiire wo yi-di yʼîide gen̰n̰o.» Isa yi di ruute, yʼede: «Ono geŋ ki tiʼn ɗikke ɗerec.» ");
INSERT INTO moz_vpl VALUES ("LK7_44","072_7_44","LUK","7","44","44","Maŋ Isa yʼa-gime ki tukkʼerewo gettiyo, wo yi di ruute a Simo, yʼede: «Erewo ette ki ti wolliyo ɗeʼŋ? Nuŋ ni-tʼiido adda ɓoozá wo ahu toŋ kʼo kʼeele ye kʼopilso zoŋɗó me, wo ɗe todʼ tʼo tʼupile zoŋɗó ti zumartú wo tʼa zippite tʼilaltú. ");
INSERT INTO moz_vpl VALUES ("LK7_45","072_7_45","LUK","7","45","45","Kee ki ki nʼ ziiɗa yop kʼo kʼize puuc a toɓɓisadó ye, wo ɗe todʼte tʼume nʼiina geŋ miŋ, ti kʼiili ye kʼisiyo puuc a zoŋɗó me. ");
INSERT INTO moz_vpl VALUES ("LK7_46","072_7_46","LUK","7","46","46","Kee egey kʼin̰n̰i kʼolibiye a eedó kʼo ki ƴirge ye, wo todʼ tʼo di ƴirgite egey ɗoŋ eeɗiyadaŋ uŋse a zoŋɗó. ");
INSERT INTO moz_vpl VALUES ("LK7_47","072_7_47","LUK","7","47","47","Kono kamo nʼa di rooto: geyyiso ere ɓaadaŋ tʼize gette i-kaza tʼolɗikatú ere ɓaadaŋ, todʼ tʼuune tambobino. Wo a wede ooniyo tambobino kʼolɗikadí baata geŋ, yi geyyiso toŋ baata kay.» ");
INSERT INTO moz_vpl VALUES ("LK7_48","072_7_48","LUK","7","48","48","Iŋkino maŋ Isa yi di ruute a erewo, yʼede: «Olɗikadí ni tʼize tambobino.» ");
INSERT INTO moz_vpl VALUES ("LK7_49","072_7_49","LUK","7","49","49","Kane ɗoŋ i-guune omɓo ti yodeʼŋ, wede soŋ yi dʼelkiyo adda kʼaddí kʼaddí, anʼde: «Ita ɗoŋ kino eŋ miŋ ti too me, isiyo tambobino kʼolɗiko toŋ yi dʼaaniya me?» ");
INSERT INTO moz_vpl VALUES ("LK7_50","072_7_50","LUK","7","50","50","Wo Isa yi di ruute a erewo, yʼede: «Kono koŋ mi ziipe addí a nuŋ geŋ, mʼutte mʼaaho ti toose.» ");
INSERT INTO moz_vpl VALUES ("LK8_1","072_8_1","LUK","8","1","1","Saŋ maŋ tiŋ geŋ Isa yʼa tʼiiziga, yi dʼettiyo geeger ti geeger wo ille ti ille, yi kazita Rabila Majjaanawa ki Moziko Raa. Kane sanalliyagiɗoŋ koomat makumu sire geŋ a itadí, ");
INSERT INTO moz_vpl VALUES ("LK8_2","072_8_2","LUK","8","2","2","ti erayi miibi ɗoŋ yʼan ilmito siitanɗani wo yʼan dʼelo beeko a enɗanzaŋ. Kane erayi geŋ Mariyam ere an ti waaku Mariyam ti siiɗo Magdalla, tode ere yi dʼilmo siitanɗani sarat tʼettú, ");
INSERT INTO moz_vpl VALUES ("LK8_3","072_8_3","LUK","8","3","3","Zane ere ki Kuuza wede i ƴeeriyo ɓoy ki mozigo Erod, Suuzan wo erayi ɗoŋ ti doolo toŋ ede ɓaadaŋ, kane geŋ an di noogiyo Isa ti sanalliyagí ti beezaŋ. ");
INSERT INTO moz_vpl VALUES ("LK8_4","072_8_4","LUK","8","4","4","Ti geeger ere tuuku toŋ, ɗoŋ ɓaadaŋ an dʼiide tukkʼIsa, an di-tʼugiye. Maŋ yʼan diʼn duuye tʼono ombiɗe en̰n̰o, yʼede: ");
INSERT INTO moz_vpl VALUES ("LK8_5","072_8_5","LUK","8","5","5","«I dʼede wedusu soo iŋkino yi tʼiide korso buzuní kʼadda doomizí. Aame yi sakkisa geŋ, buzu oŋgoŋ a-zilɗiti a urzi, ɗuwo an aa tʼin̰ƴilse wo emɓi an aa di tiɓɓe. ");
INSERT INTO moz_vpl VALUES ("LK8_6","072_8_6","LUK","8","6","6","Buzu oŋgoŋ soŋ a-zilɗiti a ume tʼaddaʼŋ paŋgiragi. Kane geŋ i tʼuɗɗe maŋ, a biiha kono kuyyo umbo. ");
INSERT INTO moz_vpl VALUES ("LK8_7","072_8_7","LUK","8","7","7","Ɗoŋ soŋ a-zilɗiti adda kʼahimagi, kane geŋ a tʼuɗɗe wo ahimagi an iiziga maŋ, an diʼn ippe. ");
INSERT INTO moz_vpl VALUES ("LK8_8","072_8_8","LUK","8","8","8","Ɗoŋ oŋgoŋ soŋ a-zilɗiti a siiɗo ere beehiye, kane geŋ a tʼuɗɗe, an dʼihira wo an dʼehe: ulo muduso soo yʼa ehe in̰n̰i meeda meeda.» Maŋ Isa yʼa ruute ti golla awwa, yʼede: «Wede i-dʼede kuwwa kʼollige maŋ, yʼollo koɗuwo!» ");
INSERT INTO moz_vpl VALUES ("LK8_9","072_8_9","LUK","8","9","9","Kane sanalliyagi kʼIsa an di yʼ tunde, anʼde: «Ono ombiɗe geŋ i-kaza moo me?» ");
INSERT INTO moz_vpl VALUES ("LK8_10","072_8_10","LUK","8","10","10","Yoŋ yʼan diʼn gime onamaŋ, yʼede: «A kuneʼŋ Raa yʼun ele suuniyo ki sulɗi ɗoŋ ombiɗe ki Moziko Raa te, wo a ɗoŋ oŋgoŋ sulɗi geŋ an an rootiytoʼŋ tʼono ombiɗe. Iŋkino kaneʼŋ an di wolliyo, wo munɗa an ki yʼ wolliyo ye, an dʼollige, wo ono itadaŋ an ki ti suuniyo ye. ");
INSERT INTO moz_vpl VALUES ("LK8_11","072_8_11","LUK","8","11","11","Kun ollo, ette ita kʼono ombiɗe: Buzu geŋ, i-kaza ono Raa. ");
INSERT INTO moz_vpl VALUES ("LK8_12","072_8_12","LUK","8","12","12","Buzu wede i zilɗiti a biza kʼurzi geŋ, i-kaza ɗuwo ɗoŋ ollige ono Raa. Saŋ Meeda siitanɗani tʼettiyo, ono Raa tʼadda kʼaddaŋ ti tʼoɗɗipe kono an ki ti zaape addaŋ a Raa wo an ki tʼoone uttiyo ye. ");
INSERT INTO moz_vpl VALUES ("LK8_13","072_8_13","LUK","8","13","13","Buzu wede i zilɗiti a ume wede tʼadda paŋgiragi geŋ, i-kaza ɗuwo ɗoŋ ollige ono Raa, kesiko an diʼn seeɗu tʼulbe uŋse. Wo ɗe ono sottadaŋ ti ki ti ɗeegu adda kʼaddaŋ ye, an di zaapu addaŋ ki peeɗo booloŋ, wo aame i aaniya naamiya munɗa maŋ, urzi zaapu kʼaddaŋ a Raa an dʼooliyo. ");
INSERT INTO moz_vpl VALUES ("LK8_14","072_8_14","LUK","8","14","14","Buzu wede i zilɗiti adda kʼahimagi geŋ, i-kaza ɗuwo ɗoŋ ollige ono Raa, wo ɗe saŋ elkisito, dehutu kʼurzi maala wo uŋsuwo lekkiyo duniya i ceeriyo eedaŋ. Iŋkino an ki dʼohire ye a urzi Raa me. ");
INSERT INTO moz_vpl VALUES ("LK8_15","072_8_15","LUK","8","15","15","Ki ɗaŋgu buzu wede i zilɗiti a siiɗo ere beehiyeʼŋ, i-kaza ɗuwo ɗoŋ ollige ono Raa tʼadde tasse wo beehiye. Ono Raa an diʼn boohiyo, an seeɗu zakiɗi an dʼohire a urzi Raa, an aa dʼooniyo eebaŋ ti doolo.» ");
INSERT INTO moz_vpl VALUES ("LK8_16","072_8_16","LUK","8","16","16","«Wenɗa soo toŋ yʼa tʼoyye pitila kono yʼa-tʼossibe bogoro, ise yi-ti tʼele a ita kʼoŋgali umbo. Ki too maŋ yʼa doɗɗe tʼawwa kono ɗoŋ ette kʼadda biino an di wolle toore. ");
INSERT INTO moz_vpl VALUES ("LK8_17","072_8_17","LUK","8","17","17","Sulɗi ɗoŋ pay ombiɗeʼŋ, saŋ onniyo soo a tʼooɗiba ita, wo ono ɗoŋ i ki dehu ɗuwo an kʼolliga ye geŋ, saŋ onniyo soo an diʼn olliga, a tʼaɗɗa a toore. ");
INSERT INTO moz_vpl VALUES ("LK8_18","072_8_18","LUK","8","18","18","Iŋkino maŋ kun koona mentikagi a urzi kʼollige geŋ me. Ɗerec, a wede i-dʼedeʼŋ, an i-tʼeela tʼeego, wo ɗe a wede i-kʼede ye geŋ, munɗazí wede booloŋ yʼelkiyo yi tʼoona toŋ, an i-tʼamɓa.» ");
INSERT INTO moz_vpl VALUES ("LK8_19","072_8_19","LUK","8","19","19","MekkʼIsa ti zemɓadí an tʼiide an di yʼ tʼooney, wo kane an kʼaane ettiyo kʼume yode ye kono ɗuwo ɓaadaŋ. ");
INSERT INTO moz_vpl VALUES ("LK8_20","072_8_20","LUK","8","20","20","Ɗuwo an i-di ruute a Isa, anʼde: «Meedá ti zemɓadá kane ti paate, an dehu an ki ti wolle.» ");
INSERT INTO moz_vpl VALUES ("LK8_21","072_8_21","LUK","8","21","21","Wo ɗe Isa yʼan diʼn gime onamaŋ, yʼede: «Meedó ti zemɓadó, kane ɗoŋ ollige ono Raa wo an sooru eego.» ");
INSERT INTO moz_vpl VALUES ("LK8_22","072_8_22","LUK","8","22","22","Onniyo soo Isa ti sanalliyagí an di gili adda tooko, maŋ yʼan di ruute, yʼede: «In ti doopoʼŋ ti dar bar ti nee.» Wo kane an dʼiŋgile. ");
INSERT INTO moz_vpl VALUES ("LK8_23","072_8_23","LUK","8","23","23","Aame an doopiɗe geŋ, Isa yʼa udige kuy. A kaamiki, i dʼiiziga maaye ɓaadaŋ adda bar, tooko i tʼôoniyo tʼahu, an tʼize oon̰e kono tʼan di tiʼn sooyiso. ");
INSERT INTO moz_vpl VALUES ("LK8_24","072_8_24","LUK","8","24","24","Kane sanalliyagi an a dʼiide sirpadí, an di yʼinne kaŋ ɗollite, anʼde: «Wede dooyisadey, wede dooyisadey, kine in tʼunto!» Maŋ Isa yʼa tʼinne, yʼan iɗɗise maaye ti ahu ɗoŋ i kolzite ɓaadaŋ geŋ me, wo a kaamiki maaye yʼa ziiɗa, ahu an tʼudige ɗeɗɗek. ");
INSERT INTO moz_vpl VALUES ("LK8_25","072_8_25","LUK","8","25","25","Saŋ Isa yʼan di ruute, yʼede: «Ki moo me kun ki zaapu adduguŋ a nuuno ye me?» Wo kane orgiso tʼanni ziiɗa, an ziiɗa giggiraŋ wo an di rootiyto tuddaŋ, anʼde: «Yode eŋ moo wede me, kono yi di rootiyo a maaye ti ahu toŋ an dʼollige onamí me!» ");
INSERT INTO moz_vpl VALUES ("LK8_26","072_8_26","LUK","8","26","26","Saŋ Isa ti sanalliyagí an dʼiiney a siiɗo Gadara, todʼte ti dar bar ti nee a ɗaana siiɗo Galile. ");
INSERT INTO moz_vpl VALUES ("LK8_27","072_8_27","LUK","8","27","27","Aame Isa yi ɗeegu ti tooko geŋ, i dʼiide wedusu iŋkino ti geeger gettiyo, yʼiideʼŋ yʼa yʼikkima. Yo wede geŋ i-dʼede siitanɗani a eedí, ti kaagine yi kʼossiyo kallagi ye, wo yi ki lekkiyo a ɓoy ye, lekkiyadí adda diine muuziyagi. ");
INSERT INTO moz_vpl VALUES ("LK8_28","072_8_28","LUK","8","28","28","Aame yi wulle Isa maŋ, yʼa iise ɗollite, yʼa iire zoŋɗí wo yʼa ruute ti golla awwa, yʼede: «Ki dehu moo a tukki nuŋ me, Isa Ulo ki Raa goole a jiire pay? Ni ki tondiyo, ki ni dabire ye.» ");
INSERT INTO moz_vpl VALUES ("LK8_29","072_8_29","LUK","8","29","29","Yi ruute iŋkino kono Isa yi ruute siitan: «Mi tʼaɗɗo ti tukki yode me!» Siitan gette taŋ ɓaadaŋ ti-ti yʼ seɗɗiyo a siiɗo. Iŋkino maŋ beyɗí an di kettiso ti ziŋziri wo zoŋɗí an tʼeliyo adda poole, kono yʼa-koone umayí soo, toŋ umbo yi-ti damɓu, siitan tʼa-di dʼeŋgilso kʼadda balɗa. ");
INSERT INTO moz_vpl VALUES ("LK8_30","072_8_30","LUK","8","30","30","Isa yʼa yi tunde, yʼede: «Kee sundá wee wee?» Wede geŋ yi diʼn gime onamí, yʼede: «Nuŋ sundó Ɗoŋ Duuru.» Yi rootiyo iŋkino kono siitanɗani a eedí ɓaadaŋ. ");
INSERT INTO moz_vpl VALUES ("LK8_31","072_8_31","LUK","8","31","31","Wo kane siitanɗani an i dʼoɓe bey a Isa, kono yʼan gi di roote an ki dʼeŋgile kʼadda kʼolɗe wede aakede bulɗume ye. ");
INSERT INTO moz_vpl VALUES ("LK8_32","072_8_32","LUK","8","32","32","A ume geŋ i dʼede torɗo meeda ki kinzir an elso ekki kesse. Kane siitanɗani an i dʼoɓe bey a Isa kono yʼan tʼele urzi an tʼette adda kinzirɗari gen̰n̰o, maŋ yʼan dʼiyye. ");
INSERT INTO moz_vpl VALUES ("LK8_33","072_8_33","LUK","8","33","33","Iŋkino siitanɗani tʼekki wede geŋ an tʼuɗɗe, an tʼiide adda kinzirɗari. Wo torɗo gette tʼawwa tʼekki kesse tʼa zide okko, kinzirɗari an tʼiɓi adda bar, an tʼinda adda kʼahu. ");
INSERT INTO moz_vpl VALUES ("LK8_34","072_8_34","LUK","8","34","34","Aame kane ɗoŋ kʼelso an wulle munɗa wede ize gen̰n̰o maŋ, an dʼukke wo an an tʼîide taaya a ɗoŋ adda geeger wo a ɗoŋ i lekkiyto a domɓi pây. ");
INSERT INTO moz_vpl VALUES ("LK8_35","072_8_35","LUK","8","35","35","Ɗuwo geŋ an tʼuɗɗito wolliso ki munɗa wede ize. An iina a sirpa kʼIsa maŋ, an yʼuuna wede i ede siitanɗani a eedí wo an tʼuɗɗe geŋ, yoŋ yi-guune a ume zoŋ kʼIsa, yi tʼusse kalle wo eedí tʼiido. Iŋkino kane geŋ orgiso tʼanni ziiɗa. ");
INSERT INTO moz_vpl VALUES ("LK8_36","072_8_36","LUK","8","36","36","Kane ɗoŋ i wulle munɗa wede ize, an an tʼîide taaya kaŋ mummino wede i-dʼede siitanɗani a eedí yʼa yʼutte me. ");
INSERT INTO moz_vpl VALUES ("LK8_37","072_8_37","LUK","8","37","37","Iŋkino maŋ kane ɗoŋ siiɗo pay an i-di ruute a Isa ti siiɗadaŋ yʼa eŋgile, kono orgiso tiʼni ziiɗa ɓaadaŋ. Maŋ Isa yi-ti gili adda tooko, yʼa eŋgile. ");
INSERT INTO moz_vpl VALUES ("LK8_38","072_8_38","LUK","8","38","38","Wede i ede siitanɗani a eedí wo an tʼuɗɗe geŋ, yi tondiyo Isa kono yʼa lekke ti yode, wo Isa yʼa yʼigibe, yʼede: ");
INSERT INTO moz_vpl VALUES ("LK8_39","072_8_39","LUK","8","39","39","«Ki-kama di kee wo kʼan tʼôodoy taaya a sulɗi ɗoŋ pay Raa yʼize a kee geŋ me.» Maŋ wede yʼa-gime, yʼan di-gizite a ɗoŋ geeger sulɗi ɗoŋ pay Isa yi ize a yode geŋ me. ");
INSERT INTO moz_vpl VALUES ("LK8_40","072_8_40","LUK","8","40","40","Isa yi-gimo ti dar bar tʼinno maŋ, ɗoŋ duuru an di yʼ ziiɗa bey sire kono kane pay an yi delliyo. ");
INSERT INTO moz_vpl VALUES ("LK8_41","072_8_41","LUK","8","41","41","Aame geŋ i dʼiina wedusu sundí Zayiris, yoŋ goole ɓoy wede Yawudiyagi ge dooyiso. Yʼa iido, yʼa iire a zoŋ kʼIsa wo yi-dʼoɓe bey yʼa ette di yode, ");
INSERT INTO moz_vpl VALUES ("LK8_42","072_8_42","LUK","8","42","42","kono i-dʼede utí tiŋ soo ɗaŋŋal, ozzinatú ette suma koomat makumu sire, tuddutú eeni tʼunto. Aame Isa yʼette di yode geŋ, ɗoŋ ɓaadaŋ an di yʼ ŋaƴƴu tʼen̰n̰o tʼen̰n̰o. ");
INSERT INTO moz_vpl VALUES ("LK8_43","072_8_43","LUK","8","43","43","Ti diine ɗoŋ duuru i dʼede erewo soo iŋkino ti dabirsa, puuzo oɓite tʼitatú îide ozzine koomat makumu sire. Beytú tʼa zikkuwe pay a ɗoŋ daawiya, wo umbo wenɗa soo toŋ yi ki ti diiwe ye. ");
INSERT INTO moz_vpl VALUES ("LK8_44","072_8_44","LUK","8","44","44","Todʼ ti-tʼiide ti dar kʼIsa, tʼa-butte bize kallayí. A kaamiki yip oɓite puuzo a îhira. ");
INSERT INTO moz_vpl VALUES ("LK8_45","072_8_45","LUK","8","45","45","Isa yʼa tunde, yʼede: «Wee wee i ni butte me?» Kane pay an di ruute, anʼde: «Nuuno ye, nuuno ye.» Maŋ Piyer yʼa ruute, yʼede: «Wede dooyisadey, kee ɗuwo an ki ŋaƴƴu tʼen̰n̰o tʼen̰n̰o.» ");
INSERT INTO moz_vpl VALUES ("LK8_46","072_8_46","LUK","8","46","46","Wo ɗe Isa yʼa ruute, yʼede: «Ɗerec, nuŋ wenɗa yi ni butte, kono nʼa uwwe toogo a uɗɗe ti tuddó.» ");
INSERT INTO moz_vpl VALUES ("LK8_47","072_8_47","LUK","8","47","47","Erewo tʼuwwe maŋ Isa yi ti zuune, iŋkino to tʼa iire zoŋɗí ti ŋoŋŋirso burbur. A ɗaana ɗoŋ duuru geŋ ti di tʼîide taaya, ki moo me ti yʼ butte wo mummino a kaamiki tʼa uune bee me. ");
INSERT INTO moz_vpl VALUES ("LK8_48","072_8_48","LUK","8","48","48","Wo ɗe Isa yi di ruute, yʼede: «Uto ki nuŋ, kono koŋ mi ziipe addí a nuuno geŋ, mʼutte mʼaaho ti toose.» ");
INSERT INTO moz_vpl VALUES ("LK8_49","072_8_49","LUK","8","49","49","Aame Isa yʼa ti rootiyto iŋkino geŋ, wede zina yʼokko ti di goole ɓoy wede Yawudiyagi ge dooyiso, wo yi di ruute a Zayiris, yʼede: «Utá tʼa tʼihe, kee ki yʼ naate ye baa wede dooyiso me.» ");
INSERT INTO moz_vpl VALUES ("LK8_50","072_8_50","LUK","8","50","50","Wo ono geŋ Isa yiʼn illiga, maŋ yi di ruute a Zayiris, yʼede: «Kee kʼorgiɗe ye, ki zaapo addá a nuuno ɗaŋŋal, utá tʼutta.» ");
INSERT INTO moz_vpl VALUES ("LK8_51","072_8_51","LUK","8","51","51","Aame an iiney adda ɓoy ki Zayiris maŋ, a ɗoŋ duuru pay Isa yʼan di-tuuge kʼettiyo kʼadda biino me, iide ti yode kane Piyer, Zaŋ, Zak wo meekʼuto ti mekkʼuto ɗaŋŋal. ");
INSERT INTO moz_vpl VALUES ("LK8_52","072_8_52","LUK","8","52","52","Kane ɗuwo pay an ɗollite môolo ɗaŋkar kono kʼuto. Iŋkino maŋ Isa yʼan di ruute, yʼede: «Kun ôole ye. Todʼ ti kʼinda ye, ti moone moone.» ");
INSERT INTO moz_vpl VALUES ("LK8_53","072_8_53","LUK","8","53","53","Wo kane an di yʼokko maade kono an zuune todʼ tʼinda me. ");
INSERT INTO moz_vpl VALUES ("LK8_54","072_8_54","LUK","8","54","54","Wo yo Isa geŋ yi ziiɗa beytú, yʼa ruute ti golla awwa, yʼede: «Uto ki nuŋ, mi tʼonno!» ");
INSERT INTO moz_vpl VALUES ("LK8_55","072_8_55","LUK","8","55","55","A kaamiki undutú tʼa gimo wo tʼa tʼiiziga. Maŋ Isa yʼan di ruute, yʼede: «Kun i eelo omɓo.» ");
INSERT INTO moz_vpl VALUES ("LK8_56","072_8_56","LUK","8","56","56","Kane maawutú an ziiɗa giggiraŋ, wo Isa yʼan di ruute, yʼede: «A wenɗa soo toŋ kun i roota ye a munɗa wede ize eŋ me.» ");
INSERT INTO moz_vpl VALUES ("LK9_1","072_9_1","LUK","9","1","1","Isa yʼa-wiike sanalliyagi kane koomat makumu sire, yʼan dʼele toogo wo urzi ki lommite siitanɗani ɗoŋ pay an tʼooney a ɗaanadaŋ, wo kʼeliyo beeko a enɗani ɗuwo. ");
INSERT INTO moz_vpl VALUES ("LK9_2","072_9_2","LUK","9","2","2","Saŋ maŋ yʼan igibe kazita kʼurzi Moziko Raa wo kʼeliyo beeko a ɗoŋ kʼeeni, ");
INSERT INTO moz_vpl VALUES ("LK9_3","072_9_3","LUK","9","3","3","wo yʼan di ruute, yʼede: «Ki torguwaguŋ munɗa a beyguŋ kun amɓa ye, ise dalka, ise eese, ise munɗa kʼomɓo, ise soŋko, ise wede tuuku toŋ kalle ki sirwe yʼamɓa ye. ");
INSERT INTO moz_vpl VALUES ("LK9_4","072_9_4","LUK","9","4","4","Aame kun tʼiidey adda ɓoy tuuku wo an unni ziiɗey maŋ, kun di lekkoy aŋgen̰n̰o bini eŋgilsaguŋ tʼume gen̰n̰o. ");
INSERT INTO moz_vpl VALUES ("LK9_5","072_9_5","LUK","9","5","5","Aame tuuku ɗuwo an un kiʼn ziiɗey ye maŋ, a eŋgilsaguŋ ti geeger gette, odde zoŋguŋ toŋ kun a ti tottigoy, geŋ i-kaza Raa ulbí uŋse ye ti kane me.» ");
INSERT INTO moz_vpl VALUES ("LK9_6","072_9_6","LUK","9","6","6","Iŋkino kane sanalliyagi an dʼiŋgile, an dʼettiyo ille ti ille, an di kazita Rabila Majjaanawa wo an dʼeliyo beeko a ɗoŋ kʼeeni a ume tuuku toŋ maŋ. ");
INSERT INTO moz_vpl VALUES ("LK9_7","072_9_7","LUK","9","7","7","Erod yoŋ wede goole yi dokkiyo siiɗo Galile, yʼa illiga taaya ki sulɗi ɗoŋ pay isiyto geŋ me. Wo munɗa yʼa roote yi ki suune ye, kono ɗoŋ oŋgoŋ anʼde: «Zaŋ Batis yi bilɗo ti diine ɗoŋ unto me.» ");
INSERT INTO moz_vpl VALUES ("LK9_8","072_9_8","LUK","9","8","8","Oŋgo anʼde: «I gimo ki siiɗo nebi Eli.» Oŋgo soŋ anʼde: «I bilɗo nebi soo ti diine nebiyagi ɗoŋ ti kaaga.» ");
INSERT INTO moz_vpl VALUES ("LK9_9","072_9_9","LUK","9","9","9","Wo Erod yʼa ruute yʼede: «Zaŋ miŋ nuŋ batum nʼan di ruute a asigiryagi an di-ɗikke tʼeedí me. Wo ɗe wede geŋ miŋ tuuku me, ɗoo miŋ ni dʼollige yi dʼisiyto sulɗi pay geŋ me?» Wo yi dehu urzi Isa yʼa-ti yʼ wolle. ");
INSERT INTO moz_vpl VALUES ("LK9_10","072_9_10","LUK","9","10","10","Kane ɗoŋ zina kʼIsa an ti gimo maŋ, an i-di tʼîide taaya a naabo pay ere an izo. Maŋ yʼa tiʼn wiike an dʼiŋgile ti yode, an tʼirga siidaŋ goppoŋ ti geeger an ti waaku Betsayda. ");
INSERT INTO moz_vpl VALUES ("LK9_11","072_9_11","LUK","9","11","11","Wo kane ɗoŋ duuru, umayí an di yʼilliga wo an diʼn diine. Aame ɗuwo an iina maŋ, Isa yʼanni ziiɗa bey sire, yʼan di gizite urzi Moziko Raa, wo a ɗoŋ i dehu beeko tuddaŋ yʼan dʼele beeko. ");
INSERT INTO moz_vpl VALUES ("LK9_12","072_9_12","LUK","9","12","12","Peeɗo tʼette kʼooriyo maŋ, kane sanalliyagi koomat makumu sire, an a dʼiide sirpa kʼIsa wo an i di ruute, anʼde: «Ɗoŋ duuru eŋ kiʼn agiba, an tʼette kʼadda kʼilliyagi ti ɓoyɗi ɗoŋ doome go-goppoŋ en̰n̰o, kono an di tʼooney ume moone ti omɓo, kono kine eŋ adda balɗa.» ");
INSERT INTO moz_vpl VALUES ("LK9_13","072_9_13","LUK","9","13","13","Wo Isa yʼan di ruute, yʼede: «Omɓo an eelo kune batum.» Maŋ kane an di ruute, anʼde: «Kaye ay dʼede miŋ mappa paat wo puuni sire ɗaŋŋal, koo ki dehu kaye batum ay dʼette ay dʼowilo omɓo a ɗoŋ duuru pay en̰n̰o maŋ.» ");
INSERT INTO moz_vpl VALUES ("LK9_14","072_9_14","LUK","9","14","14","An ruute iŋkino kono kane ɗoŋ duuru an tʼîde kuuli suma dupu paat. Isa yʼan di ruute a sanalliyagí, yʼede: «Ɗuwo eŋ kun tiʼn konɗita kaŋ ogiysito ada paat, paat.» ");
INSERT INTO moz_vpl VALUES ("LK9_15","072_9_15","LUK","9","15","15","Kane sanalliyagi an tʼize aa yʼan ruute, an tiʼn gunɗite pay. ");
INSERT INTO moz_vpl VALUES ("LK9_16","072_9_16","LUK","9","16","16","Isa yʼa-ziki mappa paat ti puuni sire gen̰n̰o, yʼa tʼumɓe edayí kʼawwa ki kandaane yʼa ruute koɗuwo a Raa kono kʼomɓo gette. Maŋ mappa ti puuni yʼa ɓurkite, yʼan dʼele a sanalliyagi kono an an di-dokkiɗa a ɗoŋ duuru gen̰n̰o. ");
INSERT INTO moz_vpl VALUES ("LK9_17","072_9_17","LUK","9","17","17","Kane pay geŋ an dʼiimi wo an dʼisse. Wo omɓo ere uupite sanalliyagi an ti-tusse, a îide dappa koomat makumu sire. ");
INSERT INTO moz_vpl VALUES ("LK9_18","072_9_18","LUK","9","18","18","Onniyo soo Isa yʼa tʼirga siidí ti sanalliyagi, yi tondiyo Raa. Aame geŋ yʼanni tunde, yʼede: «Ɗoŋ duuru an rootiyo nuŋ wee wee?» ");
INSERT INTO moz_vpl VALUES ("LK9_19","072_9_19","LUK","9","19","19","Kane an i diʼn gime onamí, anʼde: «Ɗoŋ soŋ anʼde kee Zaŋ Batis, ɗoŋ oŋgo anʼde kee nebi Eli, wo ɗoŋ oŋgo soŋ anʼde kee nebi ti diine nebiyagi ɗoŋ ti kaaga i bilɗo me.» ");
INSERT INTO moz_vpl VALUES ("LK9_20","072_9_20","LUK","9","20","20","Wo yoŋ yʼan di ruute, yʼede: «Ɗe kune me, kunʼde nuŋ wee wee?» Piyer yi diʼn gime onamí, yʼede: «Kee Almasi Raa yi biire.» ");
INSERT INTO moz_vpl VALUES ("LK9_21","072_9_21","LUK","9","21","21","Maŋ Isa yʼan dʼundirɗe kono ono geŋ a wenɗa soo toŋ anʼni ki roota ye. ");
INSERT INTO moz_vpl VALUES ("LK9_22","072_9_22","LUK","9","22","22","Wo yʼa ruute sey, yʼede: «Geŋ ɗerec, nuŋ wede an nʼehe aa ulo wede eŋ, i dehu nʼa dabirey ɓaadaŋ. Ɗoŋ i dokkiyo ɗoŋziŋ, deero ɗoŋ seɗeke ti ɗoŋ suuniyo kʼoogoro pây an di nʼ kiigirey, ɗuwo an di nʼ seeɗey an di nʼ tʼîdey, wo onniyo sire kʼaɗuwe maŋ Raa yʼa ti nʼ balɗey.» ");
INSERT INTO moz_vpl VALUES ("LK9_23","072_9_23","LUK","9","23","23","Saŋ maŋ Isa yʼan di ruute a ɗoŋ pay, yʼede: «Wede yi dehu yʼa daane urzi nuuno maŋ, tuddí batum yʼa ti kiigira, onniyo ti onniyo ki unto toŋ yʼa oyye yʼa tʼinda kono nuuno, wo yʼa ni daane. ");
INSERT INTO moz_vpl VALUES ("LK9_24","072_9_24","LUK","9","24","24","Iŋkino wede tuuku yi dehu boohiyo tuddí kʼaggadí maŋ, yʼa ti dagga, wo ɗe wede tuuku yʼooliyo tuddí kono nuuno maŋ, yʼa tʼutta. ");
INSERT INTO moz_vpl VALUES ("LK9_25","072_9_25","LUK","9","25","25","A wede koɗuwatú moo me sulɗi duniya pay yʼanni tʼoone, wo tuddí yʼa ti dagge ise yʼa tʼettey kʼume daggiya me? ");
INSERT INTO moz_vpl VALUES ("LK9_26","072_9_26","LUK","9","26","26","Aame wede yʼisiyo sukiyagi a nuŋ wo a onamó maŋ, nuŋ wede an nʼehe aa ulo wede eŋ, aame nʼetto ti darƴikadó wo ti darƴika ere ki Meegó wo ti ere ki maaleekiyagi ɗoŋ kamilen̰ geŋ, nuŋ toŋ ni-dʼisa sukiyagi kay a wede geŋ me. ");
INSERT INTO moz_vpl VALUES ("LK9_27","072_9_27","LUK","9","27","27","Ɗerec iŋkino wo nʼun di rooto: Ɗoŋ oŋgoŋ ti diine kane ɗoŋ aŋken̰n̰o eŋ an ki ti tʼinda ki poone pay ye, an di wolla Moziko Raa te.» ");
INSERT INTO moz_vpl VALUES ("LK9_28","072_9_28","LUK","9","28","28","Tʼume Isa yʼa ti ruutite onamí geŋ îide suma kʼonniyo gessire maŋ, yʼa-wiike ti yode Piyer, Zaŋ wo Zak, an dʼiŋgile kʼekki mokkolo kono an tondey Raa. ");
INSERT INTO moz_vpl VALUES ("LK9_29","072_9_29","LUK","9","29","29","Aame yi tondiyo Raa geŋ, ume kʼedayí a-gime siidí wo kallagí a tʼize tuwarɗi kar. ");
INSERT INTO moz_vpl VALUES ("LK9_30","072_9_30","LUK","9","30","31","A ume geŋ a kaamiki, adda toore wede iido ti kandaaneʼŋ i dʼede kuuli sire an rootiyto tʼIsa, kane geŋ Muusa ti nebi Eli, an rootiso a urzi wede ki ɗaŋgu naabadí, yʼa-tʼindey a Zeruzalem. ");
INSERT INTO moz_vpl VALUES ("LK9_32","072_9_32","LUK","9","32","32","Piyer ti eebíʼŋ kane an udige kuy. Wo aame an tʼinne maŋ, kane an wolliyo toore aɗɗiya ti tukkʼIsa wo kuuli sire an tʼîhira a sirpadí. ");
INSERT INTO moz_vpl VALUES ("LK9_33","072_9_33","LUK","9","33","33","Kane kuuli sire geŋ Isa an yʼiili maŋ, Piyer yi di ruute, yʼede: «Wede dooyisadey, beehiyeʼŋ kine in di lekke a en̰n̰o! Ay un dʼokkima daabagi aɗo, a kee soo, a Muusa soo, wo a Eli soo.» Wo yoŋ yi ki yʼ suune ye munɗa wede yi rootiyo geŋ me. ");
INSERT INTO moz_vpl VALUES ("LK9_34","072_9_34","LUK","9","34","34","Aame yi rootiyto iŋkino geŋ, i dʼiido dondirso ti diʼn ippe kane geŋ me. Aame dondirso ti tiʼn ippe maŋ, orgiso tʼanni ziiɗa. ");
INSERT INTO moz_vpl VALUES ("LK9_35","072_9_35","LUK","9","35","35","Wo tʼadda dondirso an dʼilliga golla, tʼede: «Eŋ Ulo nuuno, yode wede ni yʼ biire. Kun yʼollo!» ");
INSERT INTO moz_vpl VALUES ("LK9_36","072_9_36","LUK","9","36","36","Aame golla ti rootiyto geŋ, kane an wolliyoʼŋ uupe Isa siidí ɗaŋŋal. Kane sanalliyagi a munɗa wede an wulle an dʼinniga ɗeɗɗek, aame geŋ munɗa a wenɗa soo toŋ an i ki ruute ye. ");
INSERT INTO moz_vpl VALUES ("LK9_37","072_9_37","LUK","9","37","37","Soggo ti soohe an ti ɗiige tʼekki mokkolo maŋ, aame geŋ ɗoŋ duuru an tʼiide okkime kʼIsa. ");
INSERT INTO moz_vpl VALUES ("LK9_38","072_9_38","LUK","9","38","38","Maŋ ti diine ɗoŋ duuru i dʼede wedusu, yʼa iɗili, yʼede: «Wede dooyisadó, ni ki tondiyo, ki wollo sommagi kʼulo nuŋ, kono yoŋ miŋ soo ɗaŋŋal. ");
INSERT INTO moz_vpl VALUES ("LK9_39","072_9_39","LUK","9","39","39","Siitan ti yʼamɓu maŋ, a kaamiki yi dʼeesiyo ɗollite, yʼa-ti zehiso bar bar wo bizí i dʼaɗɗiyta goopiyagi. Todʼ ti di yʼ dabirsa ɓaadaŋ wo ti dehu ti ki yʼooli ye. ");
INSERT INTO moz_vpl VALUES ("LK9_40","072_9_40","LUK","9","40","40","Nuŋ nʼa tunde sanalliyagá kono an ti-limmi siitan gette, wo ɗe kane an ki dʼiine ye.» ");
INSERT INTO moz_vpl VALUES ("LK9_41","072_9_41","LUK","9","41","41","Maŋ Isa yʼa tʼihina bizí, yʼa ruute, yʼede: «Kune ɗoŋ ulpi wo kun ki ziipe adduguŋ a Raa ye. Nuŋ ti kaagine ni lekkiyo ti kune, wo ɗe a nuŋ kun ki dʼumɓe ye! Geŋ nʼa omɓin̰a ki da-daayum koo ti kune me? Ulá kʼa edi ken̰n̰o.» ");
INSERT INTO moz_vpl VALUES ("LK9_42","072_9_42","LUK","9","42","42","Aame ulo yʼette kʼume kʼIsa geŋ, siitan gette tʼa ti yʼ ziɗɗe a siiɗo, yʼa di zihite bar bar. Wo ɗe Isa yʼa tʼiɗɗise siitan te kono tʼa tʼaɗɗe ti tukkʼulo me, maŋ uloʼŋ yʼa uune bee, wo yi di yʼele a meegí. ");
INSERT INTO moz_vpl VALUES ("LK9_43","072_9_43","LUK","9","43","43","Wo ɗuwo pay an ziiɗa giggiraŋ a toogo ere ɓaadaŋ ki Raa gette. Aame kane pay an seeɗu giggiraŋ ɓotto a munɗa wede Isa yʼize geŋ, yoŋ yʼan di ruute a sanalliyagí, yʼede: ");
INSERT INTO moz_vpl VALUES ("LK9_44","072_9_44","LUK","9","44","44","«Kuneʼŋ kun ollo koɗuwo munɗa wede nʼun roota eŋ me: Nuŋ wede an nʼehe aa ulo wede eŋ, an di nʼ tʼeley a bey ɗuwo.» ");
INSERT INTO moz_vpl VALUES ("LK9_45","072_9_45","LUK","9","45","45","Wo kane ono geŋ itadaŋ an kiʼn suuniyo ye, i tʼize ombiɗe iŋkino itadaŋ an gi diʼn suuniyo ye, wo Isa an i dʼorgiso kono an di yʼ tonde a ono geŋ me. ");
INSERT INTO moz_vpl VALUES ("LK9_46","072_9_46","LUK","9","46","46","Kane sanalliyagi an dʼiise rootiyto ti tuddaŋ kono an dehu an di suune, ti diinayaŋ miŋ wee wee goole a jiire me. ");
INSERT INTO moz_vpl VALUES ("LK9_47","072_9_47","LUK","9","47","47","Elkisadaŋ gette Isa yʼa ti zuune. Iŋkino maŋ yi wiike ulo n̰eŋku, yʼa yʼîhira a ɗaanadí, ");
INSERT INTO moz_vpl VALUES ("LK9_48","072_9_48","LUK","9","48","48","wo yʼan di ruute, yʼede: «Wede tuuku yi seeɗu ulo aa yode eŋ bey sire kono yʼumɓe a sundó maŋ, geŋ aa yi seeɗu nuŋ batum. Wo wede tuuku yi seeɗu nuuno maŋ, geŋ aa yi seeɗu wede i nʼigibo pây. Ɗerec, yo wede ti diine kune pay eŋ yoŋ n̰eŋku a jiire maŋ, geŋ yode wede goole a jiire me.» ");
INSERT INTO moz_vpl VALUES ("LK9_49","072_9_49","LUK","9","49","49","Maŋ Zaŋ yʼa tʼihina bizí, yʼa ruute, yʼede: «Wede dooyisadey, kaye ay di wullo wedusu soo iŋkino yi lommite siitanɗani ti sundá, wo ay di dihe ôhirayí kono yoŋ ti diinayey ye.» ");
INSERT INTO moz_vpl VALUES ("LK9_50","072_9_50","LUK","9","50","50","Wo Isa yi diʼn gime onamí, yʼede: «Kun yʼôhira ye, kono wede aduguŋ ye geŋ yoŋ ki kune.» ");
INSERT INTO moz_vpl VALUES ("LK9_51","072_9_51","LUK","9","51","51","Aame onniyo ere Isa yʼa-kima ki kandaane aa guute goppoŋ maŋ, yʼa ziiɗa zakiɗi yʼa tʼette ki Zeruzalem. ");
INSERT INTO moz_vpl VALUES ("LK9_52","072_9_52","LUK","9","52","52","Yi dʼigibe ɗoŋ zina an dʼuugume poone. Kane an dʼiŋgile, maŋ an tʼiide adda kʼille soo ki siiɗo Samari kono an i-di tʼokkimey ume ɗeeguzí. ");
INSERT INTO moz_vpl VALUES ("LK9_53","072_9_53","LUK","9","53","53","Wo kane ɗoŋ kʼille gette an di-tuuge an di yʼ seeɗa me, kono yoŋ yʼette ki Zeruzalem. ");
INSERT INTO moz_vpl VALUES ("LK9_54","072_9_54","LUK","9","54","54","Aame kane sanalliyagi Zak wo Zaŋ an illiga iŋkino maŋ, an di ruute, anʼde: «Galmeegey, kee ki dehu maŋ, ay tonde uwwo ti kandaane tʼa ɗeego tʼan uute mendaŋ?» ");
INSERT INTO moz_vpl VALUES ("LK9_55","072_9_55","LUK","9","55","55","Wo ɗe Isa yʼan gime, wo yʼan diʼn iipiɗe. yʼede: «Kune kun ki suune ye, unde ere tuuku un ede te. ");
INSERT INTO moz_vpl VALUES ("LK9_56","072_9_56","LUK","9","56","56","Ɗerec, nuŋ wede an nʼehe aa ulo wede eŋ, nʼiidoʼŋ kono nʼa ki dagge undiyagi ɗuwo ye, wo nʼan utte.» Maŋ an dʼiŋgile ki ille ti doolo. ");
INSERT INTO moz_vpl VALUES ("LK9_57","072_9_57","LUK","9","57","57","Aame kane a urzi geŋ, i dʼede wedusu soo iŋkino yi di ruute a Isa, yʼede: «Nʼa ki daana kʼume wede tuuku kee kʼetta geŋ me.» ");
INSERT INTO moz_vpl VALUES ("LK9_58","072_9_58","LUK","9","58","58","Wo Isa yi-tiʼn gime onamí, yʼede: «Boo ti ɓoyɗutú wo emɓi toŋ ti ɓoyɗizaŋ, wo ɗe nuŋ wede an nʼehe aa ulo wede eŋ, oo kʼede ume ni ki ti tʼele eedó nʼa-ki puuke ye.» ");
INSERT INTO moz_vpl VALUES ("LK9_59","072_9_59","LUK","9","59","59","Isa yi di ruute a wede doolo, yʼede: «Ki ni daani.» Wo wede geŋ yʼa ruute, yʼede: «Galmeeʼki nuŋ, kʼo eeli urzi nʼa ette nʼa tʼottibo meegó ɗo.» ");
INSERT INTO moz_vpl VALUES ("LK9_60","072_9_60","LUK","9","60","60","Maŋ Isa yi di ruute, yʼede: «Kiʼn oolo kane ɗoŋ aa unto an dʼottiba tuddaŋ, wo kee kʼeŋgilo kazita kʼono ki Moziko Raa.» ");
INSERT INTO moz_vpl VALUES ("LK9_61","072_9_61","LUK","9","61","61","Wede doolo sey yʼa ruute, yʼede: «Galmeeʼki nuŋ, ni ki daana, wo ɗe kʼo eeli urzi nʼa di tʼeeso ɗoŋ ɓoozó ɗo.» ");
INSERT INTO moz_vpl VALUES ("LK9_62","072_9_62","LUK","9","62","62","Isa yi di ruute, yʼede: «Wede yi derku ti buŋgari wo yʼa gelɗe ki daarí geŋ, yoŋ beehiykadí umbo ki Moziko Raa te.» ");
INSERT INTO moz_vpl VALUES ("LK10_1","072_10_1","LUK","10","1","1","Saŋ maŋ tiŋ geŋ Galmeega yi biire sanalliyagi ti doolo, kane ada sarat makumu sire, wo yʼan ikkipe sire sire, an dʼuugume kʼadda geegiryagi ti omagi pay ɗoŋ yode batum yi dihe yʼetta. ");
INSERT INTO moz_vpl VALUES ("LK10_2","072_10_2","LUK","10","2","2","Yʼan di ruute, yʼede: «Kane ɗoŋ duuru eŋ aa doome goole yʼize kʼayɗu, wo ɗoŋ naabo baata. Iŋkino kun tondo wede doome kono yʼa-tʼigibo ɗoŋ naabo kʼayɗu. ");
INSERT INTO moz_vpl VALUES ("LK10_3","072_10_3","LUK","10","3","3","Aŋkeŋ kun eŋgilo! Kun ollo, nʼun agisa eŋ aakede in̰n̰i damɓami kʼadda diine sullibagi. ");
INSERT INTO moz_vpl VALUES ("LK10_4","072_10_4","LUK","10","4","4","A beyguŋ soŋko kun amɓa ye, ise eese, ise toɓiyagi ti doolo toŋ maŋ. A urzi wenɗa soo toŋ kun tʼeesey ye. ");
INSERT INTO moz_vpl VALUES ("LK10_5","072_10_5","LUK","10","5","5","Aame kun tʼiidey adda ɓoy tuuku maŋ, ki poone kun dʼeesoy: “Toose Raa ti koona adda ɓoy en̰n̰o.” ");
INSERT INTO moz_vpl VALUES ("LK10_6","072_10_6","LUK","10","6","6","Aame wede i dehu toose a ume geŋ ede maŋ, toose kune tʼa koonoy eedí. Wo aame wede iŋkino umbo maŋ, toose kune tʼa-kamoy ki tudduguŋ. ");
INSERT INTO moz_vpl VALUES ("LK10_7","072_10_7","LUK","10","7","7","Ɓoy wede unni ziiɗey maŋ, kun lekkoy aŋgen̰n̰o, kun dʼoomoy, kun dʼooɓoy munɗa wede an un tʼeley me, kono wede yi naabiyaʼŋ i-dʼede urzi yʼa oomi ti bey ɗoŋ yʼan naabiya. Kun ɗettitey ɓoy ti ɓoy ye. ");
INSERT INTO moz_vpl VALUES ("LK10_8","072_10_8","LUK","10","8","8","Aame kun tʼiidey adda geeger ere tuuku wo an unni ziiɗey maŋ, kun oomoy munɗa wede an un tʼeley me. ");
INSERT INTO moz_vpl VALUES ("LK10_9","072_10_9","LUK","10","9","9","Adda geeger gette, kun an eloy beeko a ɗoŋ kʼeeni, wo a ɗoŋtú kun an di rootoy, kunʼde: “Moziko Raa tʼiina goppoŋ ti kune.” ");
INSERT INTO moz_vpl VALUES ("LK10_10","072_10_10","LUK","10","10","10","Wo aame kun tʼiidey adda geeger ere tuuku wo ɗoŋtú an un kiʼn ziiɗey ye maŋ, kun dʼeŋgiloy bere ɗoŋ duuru wo kun an di rootoy a ɗoŋ pay, kun dʼeesoy: ");
INSERT INTO moz_vpl VALUES ("LK10_11","072_10_11","LUK","10","11","11","“Kaye odde siiɗaguŋ wede a zoŋɗey toŋ ay un ti yʼ tottigo, geŋ i-kaza Raa ulbí uŋse ye ti kune me. Wo geŋ ono eŋ kunʼni suuno koɗuwo: Moziko Raa tʼiina goppoŋ ti kune.” ");
INSERT INTO moz_vpl VALUES ("LK10_12","072_10_12","LUK","10","12","12","Kun ollo, nʼun di rooto, onniyo ere Raa yi ɗekka booro gette, kane ɗoŋ geeger Sodom booradaŋ tʼa koona soodo ti ɗoŋ ki geeger gettiyo. ");
INSERT INTO moz_vpl VALUES ("LK10_13","072_10_13","LUK","10","13","13","Dabar a kune ɗoŋ geeger Korazeŋ! Dabar a kune ɗoŋ geeger Betsayda! Ɗerec, aame sulɗi kʼarmika ɗoŋ Raa yʼize di kune geŋ aŋki yʼaase a geeger Tir ti Sidoŋ maŋ, aŋki ti kaagine ɗoŋzaŋ an tʼossite kallagi môolo wo tuddaŋ an aa di kosse puure, wo an di-kime lekkiyadaŋ. ");
INSERT INTO moz_vpl VALUES ("LK10_14","072_10_14","LUK","10","14","14","Kono kamo onniyo ere Raa yi ɗekka booro gette, kane ɗoŋ geeger Tir ti Sidoŋ booradaŋ tʼa koona soodo ti ere ki kune. ");
INSERT INTO moz_vpl VALUES ("LK10_15","072_10_15","LUK","10","15","15","Wo kune ɗoŋ geeger Kapernayim, kun elkiyo miŋ Raa yʼun tiʼn sika kʼawwa ki kandaane ko? Aha! Raa yʼun tiʼn ɗeega adda diine ɗoŋ unto.» ");
INSERT INTO moz_vpl VALUES ("LK10_16","072_10_16","LUK","10","16","16","Isa yʼan di ruute sey a sanalliyagí, yʼede: «Wede un ollige maŋ, geŋ aa yʼollige nuuno. Wede unni koogire maŋ, geŋ aa yi koogire nuuno. Wo wede i ni koogire maŋ, geŋ aa yi koogire wede i nʼigibo.» ");
INSERT INTO moz_vpl VALUES ("LK10_17","072_10_17","LUK","10","17","17","Kane sanalliyagi ada sarat makumu sire geŋ an di-gimo ulbaŋ ôoniyo tʼuŋsuwo, wo an di ruute, anʼde: «Galmeegey, siitanɗani toŋ an aynʼollige aame ay an rootiyo munɗa ti sundá maŋ.» ");
INSERT INTO moz_vpl VALUES ("LK10_18","072_10_18","LUK","10","18","18","Isa yʼan di ruute, yʼede: «Nuŋ ni wolliyo Meeda siitanɗani, tʼa iiro ti kandaane aakede omile mizzi. ");
INSERT INTO moz_vpl VALUES ("LK10_19","072_10_19","LUK","10","19","19","Kun ollo, nʼun ele toogo ere kun dʼozire tʼekki mimbayi, tʼekkʼottiyagi wo tʼekki toogo pay ere ki adu, wo munɗa un dʼisa ulsu a kune umbo. ");
INSERT INTO moz_vpl VALUES ("LK10_20","072_10_20","LUK","10","20","20","Wo beehiye kune ulbuguŋ un isiyo uŋse kono siitanɗani an un ollige, wo ki too maŋ beehiye a ceere ulbuguŋ aase uŋse kono sumɓiyaguŋ raaŋiyta adda mattup ki Raa a kandaane.» ");
INSERT INTO moz_vpl VALUES ("LK10_21","072_10_21","LUK","10","21","21","Aame gen̰n̰o batum, Isa Unde Kamilen̰ ti diʼn ûune addí tʼuŋsuwo wo yʼa ruute, yʼede: «Meeʼki nuŋ, kee Galmeeʼki kandaane ti siiɗo, ni ki tamma kono sulɗi eŋ kʼan diʼn umbiɗa a ɗoŋ suuniyo kʼono wo a ɗoŋ eedaŋ soodo a elkiso geŋ me, wo kʼan tʼiiɗiba ita a ɗoŋ aa in̰n̰i sun̰n̰i. Eyye Meeʼki nuŋ, geŋ ki dihe sulɗi a tʼise iŋkino. ");
INSERT INTO moz_vpl VALUES ("LK10_22","072_10_22","LUK","10","22","22","Sulɗi pay Meegó Raa yʼo nʼele a beezó. Wenɗa soo toŋ a suune Ulo umbo, i yʼ suune Meega ɗaŋŋal, wo wenɗa soo toŋ a suune Meega umbo, i yʼ suune Ulo wo ti kane ɗoŋ Ulo yi dehu yʼan tʼooɗiba itadí ɗaŋŋal.» ");
INSERT INTO moz_vpl VALUES ("LK10_23","072_10_23","LUK","10","23","23","Saŋ maŋ Isa yʼa-gime ki tukki sanalliyagi wo yʼan di ruute a kane siidaŋ, yʼede: «Uŋsuwo a kune a munɗa wede kun wolliyo en̰n̰o. ");
INSERT INTO moz_vpl VALUES ("LK10_24","072_10_24","LUK","10","24","24","Kun ollo, nʼun di rooto, nebiyagi ɓaadaŋ ti mozagi ɓaadaŋ an dihe an di wolle munɗa wede kun wolliyo en̰n̰o, wo an gi di yʼ wulle ye. An dihe an dʼolliga munɗa wede kun ollige en̰n̰o, wo an gi di yʼilliga ye.» ");
INSERT INTO moz_vpl VALUES ("LK10_25","072_10_25","LUK","10","25","25","Onniyo soo, wede suuniyo kʼoogoro yi dehu yi-dʼekke ikka tʼurzi kʼono a Isa. Iŋkino maŋ yʼa dʼiide sirpadí, yʼa yi tunde, yʼede: «Wede dooyisadey, nʼaase moo me kono nʼa tʼoona lekkiyo ere ki daayum te?» ");
INSERT INTO moz_vpl VALUES ("LK10_26","072_10_26","LUK","10","26","26","Isa yi di ruute, yʼede: «An riiŋe adda mattup kʼoogiradiŋ moo me? Moo me ki gariya adda me?» ");
INSERT INTO moz_vpl VALUES ("LK10_27","072_10_27","LUK","10","27","27","Wede geŋ yi diʼn gime onamí, yʼede: «An riiŋe, anʼde: “Ki geyyo Galmeega Raazá ti addá pay, ti undá pay, ti toogadá pay wo ti elkisadá pay.” Wo soŋ anʼde: “Ki geyyo bakadá aa ki geyyiso tuddá batum.”» ");
INSERT INTO moz_vpl VALUES ("LK10_28","072_10_28","LUK","10","28","28","Iŋkino maŋ Isa yi di ruute, yʼede: «Onamá ki ni ruute geŋ ɗerec. Kʼiso iŋkino wo kʼa lekka.» ");
INSERT INTO moz_vpl VALUES ("LK10_29","072_10_29","LUK","10","29","29","Wo wede suuniyo kʼoogoro yi dehu yʼa tʼokkima bizí, iŋkino yʼa tunde Isa, yʼede: «Bakadó wee wee?» ");
INSERT INTO moz_vpl VALUES ("LK10_30","072_10_30","LUK","10","30","30","Isa yi diʼn gime onamí, yʼede: «I dʼede wedusu soo iŋkino, yi ɗeegu ti Zeruzalem yʼamɓe ki geeger Zeriko. Yo yi-tʼiire bey ɗoŋ ɗekkiyo kʼurzi, sulɗizí an tʼuube pay, an di yʼ gusse, an di yʼiili pulpul a siiɗo wo an dʼiŋgile. ");
INSERT INTO moz_vpl VALUES ("LK10_31","072_10_31","LUK","10","31","31","Saŋ maŋ i dʼiido wede seɗeke yi ɗeegu tʼurzi gen̰n̰o kay. Aame yʼiina yi wulle wedusu kaŋ moone maŋ, yʼa uɗɗe dokki ti yode, yʼa iŋgile. ");
INSERT INTO moz_vpl VALUES ("LK10_32","072_10_32","LUK","10","32","32","Iŋkino kay i dʼiido wedusu yoŋ ti biza bumɓu Lebi yʼiina a ume gen̰n̰o, wo aame yi wulle wede gen̰n̰o maŋ, yʼa uɗɗe dokki ti yode, yʼa iŋgile. ");
INSERT INTO moz_vpl VALUES ("LK10_33","072_10_33","LUK","10","33","33","Saŋ i dʼiido Samariten yi tʼette torguwo, yʼa iina a ume gen̰n̰o kay. Aame yi wulle wede gen̰n̰o maŋ, i di tʼize sommagi ɓaadaŋ. ");
INSERT INTO moz_vpl VALUES ("LK10_34","072_10_34","LUK","10","34","34","Yʼa dʼiide goppoŋ ki tuddí wo a kunɗayí yi dʼiɓiti egey ti toote kʼin̰n̰i bin̰, maŋ yi di gittite. Yʼa di yʼumɓe eego buurizí, yʼa-di tʼiide kʼadda kʼille wo yʼa ti yʼ ziipe a ume ɗeegu torgagi, yʼa-tʼudige ɗok. ");
INSERT INTO moz_vpl VALUES ("LK10_35","072_10_35","LUK","10","35","35","Soggo ti soohe maŋ, yi dʼiiɗiba tamma sire, yi-dʼele a wede ɓoy wo yi di ruute, yʼede: “Wede eŋ kʼa-tʼudigo ɗok a eedí. Wo soŋko ette a biita toŋ ki yʼoola ye, aame ni-gimo maŋ, munɗa wede ki dagga kono yode geŋ, nuŋ batum nʼa di yʼ tʼela.”» ");
INSERT INTO moz_vpl VALUES ("LK10_36","072_10_36","LUK","10","36","36","Maŋ Isa yʼa ruute sey, yʼede: «A elkiyadá maŋ, ti diine ɗoŋ torguwo aɗo geŋ, wede tuuku baka ki wede ɗoŋ kʼoogire an yi gusse me?» ");
INSERT INTO moz_vpl VALUES ("LK10_37","072_10_37","LUK","10","37","37","Wede suuniyo kʼoogoro yi diʼn gime onamí, yʼede: «Bakadí wede i ize adde koɗuwo a yode gen̰n̰o.» Iŋkino maŋ Isa yi di ruute, yʼede: «Geŋ kʼodo, kee toŋ kʼaasoy iŋkino kay.» ");
INSERT INTO moz_vpl VALUES ("LK10_38","072_10_38","LUK","10","38","38","Aame Isa kane ti sanalliyagí an sooru a urzi geŋ, an tʼiide adda kʼille soo, a ume geŋ i dʼede erewo sundutú Marte todʼ tʼanni ziiɗa di tode. ");
INSERT INTO moz_vpl VALUES ("LK10_39","072_10_39","LUK","10","39","39","To Marte i-dʼede teematú sundutú Mariyam, todʼ tʼa-guune a sirpa zoŋ ki Galmeega ti dʼollige ono ɗoŋ yi dooyiso. ");
INSERT INTO moz_vpl VALUES ("LK10_40","072_10_40","LUK","10","40","40","Marte gette naabo zigile i ti ziiɗa, tʼa dʼiide kʼume kʼIsa ti di ruute, tʼede: «Galmeeʼki nuŋ, kee a-ki kaza munɗa ye koo, kunuŋ teemadó gette naabo pay tʼo dʼiili a nuŋ siidó me? Iŋkino ki rooto tʼa di nʼ nooge» ");
INSERT INTO moz_vpl VALUES ("LK10_41","072_10_41","LUK","10","41","41","Maŋ Galmeega yi diʼn gime onamtú, yʼede: «Marte, Marte, koŋ ulbí i-dʼooɗiyo wo mi dʼelkiso ki sulɗi ɓaadaŋ, ");
INSERT INTO moz_vpl VALUES ("LK10_42","072_10_42","LUK","10","42","42","wo munɗa soo ɗaŋŋal wede i dehu mʼaase me. To Mariyam ti biire munɗa wede majjaane a jiire, wenɗa yi kʼaane yi ki tʼooɗiba ye.» ");
INSERT INTO moz_vpl VALUES ("LK11_1","072_11_1","LUK","11","1","1","I dʼede onniyo soo, Isa yi tondiyo Raa a ume soo iŋkino. Aame yʼa ti ɗiŋge ti tondiyo maŋ, wede soo ti diine sanalliyagí yʼa yi tunde, yʼede: «Galmeeʼki nuŋ, kʼay tiʼn dooyi urzi tondiyo Raa, aakede Zaŋ Batis yʼa duuye sanalliyagí.» ");
INSERT INTO moz_vpl VALUES ("LK11_2","072_11_2","LUK","11","2","2","Isa yʼan di ruute, yʼede: «Aame kun tonde Raa maŋ, kun dʼeeso: “Meegey, kee kʼiso ɗuwo pay an di suune kee Raa kamilen̰, Mozikadá kʼa-di tʼedi. ");
INSERT INTO moz_vpl VALUES ("LK11_3","072_11_3","LUK","11","3","3","Onniyo ti onniyo kʼay eeli omɓadey ere ay di tʼîde. ");
INSERT INTO moz_vpl VALUES ("LK11_4","072_11_4","LUK","11","4","4","Kʼay tʼisi tambobino a olɗiko ere ay ize a kee, kono kaye toŋ ay isiyo tambobino a wede tuuku ay ize ulsu kay. Wo kʼaynʼooli ye adda naamiya daggiya i ceera eedey ay tʼetta adda kʼolɗiko ye.”» ");
INSERT INTO moz_vpl VALUES ("LK11_5","072_11_5","LUK","11","5","5","Isa yʼan di ruute sey, yʼede: «Kun ollo, aakede wede soo ti diinaguŋ i-dʼede laŋze, yʼa ette ki ɓoozí a diɗɗo meeda, wo yʼa tʼeese: “Laŋze ki nuŋ, kee kʼo eeli mappa aɗo, ");
INSERT INTO moz_vpl VALUES ("LK11_6","072_11_6","LUK","11","6","6","kono wede soo ti diine laŋziyagó yʼiina ti torguwo di nuuno, wo nuŋ munɗa kʼomɓo ni di tʼele umbo.” ");
INSERT INTO moz_vpl VALUES ("LK11_7","072_11_7","LUK","11","7","7","Yo laŋzayí ummey tʼadda biino yʼa tʼeese: “Kee ki nʼoolo ɗeɗɗek, kono tʼin̰n̰izó biza nʼay tʼippe baa, ay moone, ni kʼaane ni ki tʼooziga nʼa-ki tʼele mappa ye.” ");
INSERT INTO moz_vpl VALUES ("LK11_8","072_11_8","LUK","11","8","8","Wo kun ollo, nʼun di rooto, laŋzayí yi tʼooziga yi-tʼela sulɗi ɗoŋ pay yoŋ yi dehu, kono yoŋ laŋzayí ye, wo kono yoŋ yi koɗɗime ɓaadaŋ a munɗa wede yi dehu me. ");
INSERT INTO moz_vpl VALUES ("LK11_9","072_11_9","LUK","11","9","9","Wo nuŋ nʼun di rooto: Kun tondo wo munɗa an un tʼeela, kun dehito wo kun tʼoona, kun koppo biza wo an un di-tʼihina. ");
INSERT INTO moz_vpl VALUES ("LK11_10","072_11_10","LUK","11","10","10","Wede tuuku yi tondiyo maŋ, munɗa an i-dʼeeliyo, wede yi dehutu maŋ, yi dʼooniyo, wo wede yi koppiyo biza maŋ, an i di tʼohine. ");
INSERT INTO moz_vpl VALUES ("LK11_11","072_11_11","LUK","11","11","11","Meege tuuku ti diinaguŋ, aame ulí yi tunde omɓo maŋ, yi di tʼele mokkolo me? Koo yi tunde puuniso maŋ, yi di tʼele miipo me? ");
INSERT INTO moz_vpl VALUES ("LK11_12","072_11_12","LUK","11","12","12","Koo yi tunde kumilso maŋ, yi di tʼele otto me? Aha, umbo! ");
INSERT INTO moz_vpl VALUES ("LK11_13","072_11_13","LUK","11","13","13","Iŋkino maŋ kune ɗoŋ adduguŋ ulpi toŋ, kun suune eliyo sulɗi ɗoŋ majjanɗani a in̰n̰iguŋ. Wo geŋ taŋ miibi a ceere Meega Raa a kandaane yʼaane yʼan tʼele Unde Kamilen̰ a ɗoŋ i yi tondiyo me!» ");
INSERT INTO moz_vpl VALUES ("LK11_14","072_11_14","LUK","11","14","14","Onniyo soo, Isa yʼa-tʼilmi siitan ere wedeʼŋ ti tʼippe bizí yi kʼorbe ye geŋ me. Aame siitan gette ti tʼuɗɗe maŋ, wede geŋ bizí a tʼihina, yʼa iise ono, wo kane ɗoŋ duuru an ziiɗa giggiraŋ. ");
INSERT INTO moz_vpl VALUES ("LK11_15","072_11_15","LUK","11","15","15","Aame geŋ ɗoŋ oŋgo ti diinayaŋ an di ruute, anʼde: «Tode Belzebul Meeda siitanɗani i eliyo toogo ki lommite siitanɗani me!» ");
INSERT INTO moz_vpl VALUES ("LK11_16","072_11_16","LUK","11","16","16","Ɗoŋ oŋgoŋ an dehu an i dʼekke ikka tʼurzi kʼonamí. Iŋkino maŋ an di yʼ tunde yʼan dʼise munɗa kʼarmika, a kize yoŋ Raa yi yʼigibo. ");
INSERT INTO moz_vpl VALUES ("LK11_17","072_11_17","LUK","11","17","17","Wo Isa yʼa zuune elkisadaŋ, iŋkino maŋ yʼan di ruute, yʼede: «Moziko ere tuuku ɗoŋtú an ɗeyyiso ti tuddaŋ maŋ, mozikadaŋ a latte, ɓoyɗizaŋ a di ruugite wede soŋ ekki bakadí bakadí. ");
INSERT INTO moz_vpl VALUES ("LK11_18","072_11_18","LUK","11","18","18","Geŋ iŋkino kay, aame Meeda siitanɗani ti ɗeyyiso ti siitanɗani eebutú maŋ, geŋ an ɗeyyiso ti tuddaŋ batum. Wo ɗe geŋ ki kotto, mozikatú ti kʼaane ti ki lekke ye! Ni rootiyo iŋkino kono kunʼde, ni lommite siitanɗani o eliyo toogo Belzebul. ");
INSERT INTO moz_vpl VALUES ("LK11_19","072_11_19","LUK","11","19","19","Ɗe iŋkino maŋ, ɗoŋ a itaguŋ an lommite siitanɗani ti toogo kʼaaye? Geŋ kane batum an un kaza munɗa wede kun rootiyo a tukki nuuno geŋ ɗerec ye. ");
INSERT INTO moz_vpl VALUES ("LK11_20","072_11_20","LUK","11","20","20","Wo ɗe geŋ, nuŋ o eliyo toogo Raa ni lommite siitanɗani me maŋ, geŋ i-kaza Moziko Raa todʼ tʼiina di kune baa. ");
INSERT INTO moz_vpl VALUES ("LK11_21","072_11_21","LUK","11","21","21","Aame wedeʼŋ toogo ti aryagí geŋ ɓoozí yʼa ti yʼ boohe, iŋkino maŋ maaladí wenɗa soo toŋ yʼa ki botte ye. ");
INSERT INTO moz_vpl VALUES ("LK11_22","072_11_22","LUK","11","22","22","Wo ɗe aame i iido wede toogo ti yode wo yi yʼ jiire maŋ, aryagi ɗoŋ pay yi zaapu addí geŋ yʼa-tʼoobe, wo sulɗi ɗoŋ pay yʼa siki yʼan di dokkiɗa a ɗuwo. ");
INSERT INTO moz_vpl VALUES ("LK11_23","072_11_23","LUK","11","23","23","Wede yoŋ ki nuuno yeʼŋ, yoŋ aduzó, wo wede yʼa ki nʼ noogiyo ki tussiyo yeʼŋ, yoŋ yi teepiyo ki teepiyo.» ");
INSERT INTO moz_vpl VALUES ("LK11_24","072_11_24","LUK","11","24","24","«Aame siitan ti tukki wedusu ti tʼaɗɗiya maŋ, ti dʼeŋgilso kʼadda balɗa dehutu kʼume wede tʼa lekkey, wo ti ki dʼooniyo ye. Iŋkino ti rootiyo adda kʼaddutú, ti dʼeesiyo: “Ni-kime kʼadda bindó ere an di nʼilmo.” ");
INSERT INTO moz_vpl VALUES ("LK11_25","072_11_25","LUK","11","25","25","Wo a kamatú gette, tʼiideʼŋ ti-tʼuuney biino rookiyo kamilen̰ wo sulɗutú okkime beehiye. ");
INSERT INTO moz_vpl VALUES ("LK11_26","072_11_26","LUK","11","26","26","Iŋkino maŋ ti di kama kʼadda balɗa, tʼa waaku siitanɗani ti doolo sarat bundiɗi a jiire tode sey. An di-kama kaŋ soo, an tʼettiyo adda biino gettiyo, i-tʼisiyo ɓoozaŋ. Iŋkino yo wede geŋ, lekkiyadí ere kʼita i-tʼisiyo oon̰e i ceeriyo ere ki poone.» ");
INSERT INTO moz_vpl VALUES ("LK11_27","072_11_27","LUK","11","27","27","Aame Isa yi rootiyto iŋkino geŋ, i dʼede erewo soo iŋkino ti diine ɗoŋ duuru, ti di ruute ti golla awwa, tʼede: «Uŋsuwo a erewo ere tʼa ki zirke adda kʼaddutú wo kʼa uuɗe uɗutú.» ");
INSERT INTO moz_vpl VALUES ("LK11_28","072_11_28","LUK","11","28","28","Wo yoŋ yi di ruute, yʼede: «Wo uŋsuwo a jiire a kane ɗoŋ ollige ono Raa wo an di sooru eego.» ");
INSERT INTO moz_vpl VALUES ("LK11_29","072_11_29","LUK","11","29","29","Kane ɗoŋ duuru an dʼettiyo kʼume kʼIsa. Aame an tʼugiye maŋ, yʼa iise rootiyo, yʼede: «Ita ɗuwo ɗoŋ aŋken̰n̰o eŋ, kane ɗoŋ ulpi, an tondiyo munɗa kʼarmika a kize Raa yi nʼigibo. Wo armika ti doolo Raa yʼan kʼisa ye, daa ki armika ere Raa yʼize ti kaaga a nebi Zonas ye maŋ. ");
INSERT INTO moz_vpl VALUES ("LK11_30","072_11_30","LUK","11","30","30","Kun suune Zonas yʼa guune munɗa wede Raa yʼan di gize a ɗoŋ geeger Ninib. Geŋ iŋkino nuŋ wede an nʼehe aa ulo wede eŋ, nʼa koona munɗa wede Raa yʼan kiza a ɗoŋ aŋken̰n̰o kay. ");
INSERT INTO moz_vpl VALUES ("LK11_31","072_11_31","LUK","11","31","31","A onniyo ere Raa yi ɗekka booro gette, mohita ere ti siiɗo ki kese ɗanɗi tʼa ooziga ki tukki ɗuwo ɗoŋ aŋken̰n̰o, wo tʼan di roota: “Kuneʼŋ booro tʼunni ziiɗa.” Ti roota iŋkino kono todʼ tʼiizigo ti siiɗiyagi ɗoŋ dokki tʼita Raa kono tʼa olliga suuniyo kʼono ere ki Salamoŋ, wo a en̰n̰o i dʼede wede ede yʼa jiire Salamoŋ sey. ");
INSERT INTO moz_vpl VALUES ("LK11_32","072_11_32","LUK","11","32","32","A onniyo ere Raa yi ɗekka booro gette, ɗoŋ geeger ki Ninib an dʼooziga ki tukki ɗuwo ɗoŋ aŋken̰n̰o, wo an di roota: “Kuneʼŋ booro tʼunni ziiɗa.” An roota iŋkino kono aame ɗoŋ geeger ki Ninib an illiga Zonas yi gizite urzi kʼono Raa maŋ, an di-gime lekkiyadaŋ. Wo a en̰n̰o i dʼede wede ede yʼa jiire Zonas sey.» ");
INSERT INTO moz_vpl VALUES ("LK11_33","072_11_33","LUK","11","33","33","«Wenɗa soo toŋ yʼa-tʼoyye pitila kono yi-ti tʼombiɗa, ise yʼa-tʼossibe bogoro umbo. Ki too maŋ yʼa ti doɗɗe tʼawwa kono ɗoŋ ette kʼadda biino an di wolle toore. ");
INSERT INTO moz_vpl VALUES ("LK11_34","072_11_34","LUK","11","34","34","Eda kane aa pitila ki tudde. Aame edayá kane bee maŋ, tuddá pay tiŋ adda toore, wo aame edayá kane bee ye maŋ, tuddá pay tiŋ adda zimolo. ");
INSERT INTO moz_vpl VALUES ("LK11_35","072_11_35","LUK","11","35","35","Iŋkino maŋ ki koona metike kono toore wede a tuddá geŋ, a ki tʼise zimolo ye. ");
INSERT INTO moz_vpl VALUES ("LK11_36","072_11_36","LUK","11","36","36","Wo aame tuddá pay adda toore daa munɗa ki zimolo maŋ, tuddá pay gettiŋ adda toore, geŋ aakede pitila ti tooriyo tuddá ti tooratú wede keren̰ gen̰n̰o.» ");
INSERT INTO moz_vpl VALUES ("LK11_37","072_11_37","LUK","11","37","37","Aame Isa yʼa ti ɗiŋge onamí maŋ, i dʼede wedusu soo yoŋ Pariziyeŋ yʼa ti yʼ wiike yʼa oomey di yode. Isa yʼa tʼiide kʼadda ɓoy, wo an di-guune omɓo. ");
INSERT INTO moz_vpl VALUES ("LK11_38","072_11_38","LUK","11","38","38","Yo Pariziyeŋ yʼa ziiɗa giggirí aame yi wulle Isa ki poone yʼa tʼeese omɓoʼŋ, beezí yi kʼupile ye aa moŋgiɗagi an ruute me. ");
INSERT INTO moz_vpl VALUES ("LK11_39","072_11_39","LUK","11","39","39","Iŋkino maŋ yo Galmeega yi di ruute, yʼede: «Kun ollo, kune Pariziyeŋ! Kuneʼŋ kulso ti bogoro kun tʼopilso daaraŋ beehiye, wo adduguŋ ôoniyo ɓoo ti tama kʼoogire wo ti bundiko. ");
INSERT INTO moz_vpl VALUES ("LK11_40","072_11_40","LUK","11","40","40","Kune ɗoŋ elkisaguŋ umbo, kun suune keren̰ Raa wede ikkima ume ti paate geŋ, ikkima ume tʼadda toŋ yode me. ");
INSERT INTO moz_vpl VALUES ("LK11_41","072_11_41","LUK","11","41","41","Wo ki too maŋ a kane ɗoŋ an kʼede munɗa ye, kun an elo tʼadduguŋ pay, iŋkino kune kun tʼisa kamilen̰. ");
INSERT INTO moz_vpl VALUES ("LK11_42","072_11_42","LUK","11","42","42","Wo dabar a kune Pariziyeŋ! Kuneʼŋ a urzi zakka, kun dʼeliyo zakka a Raa ki ita sulɗi ɗoŋ sun̰n̰i sun̰n̰i i dʼeliyo uŋsuwo a zaami, ise puutagi ɗoŋ ki zaami toŋ maŋ. Wo ɗe munɗa wede kun dʼise ki diine a ɗuwo, ti geyyiso ki Raa, kane geŋ kun dʼooliyo a kese. Ki too maŋ ki poone kane gen̰n̰o ɗoŋ kun dʼozire eego me, wo sulɗi ɗoŋ sun̰n̰i sun̰n̰i toŋ kun kiʼn ooli ye. ");
INSERT INTO moz_vpl VALUES ("LK11_43","072_11_43","LUK","11","43","43","Dabar a kune Pariziyeŋ! Kuneʼŋ adda ɓoyɗi ɗoŋ in di dooyiso, kun geyyiso kun koone a ume wede suma, wo a bere ɗoŋ duuru toŋ, kun geyyiso ɗuwo an un diʼn tʼeesite ti ottilso. ");
INSERT INTO moz_vpl VALUES ("LK11_44","072_11_44","LUK","11","44","44","Dabar a kune! Kuneʼŋ ɗoŋ aakede muuziyagi daa zappu moŋgali, ɗoŋ an sooru eego daa suuniyo a urzi kʼoogoro an tʼisiyo ganigi a ɗaana Raa me.» ");
INSERT INTO moz_vpl VALUES ("LK11_45","072_11_45","LUK","11","45","45","Wede soo ti diine ɗoŋ suuniyo kʼoogoro yi di ruute a Isa, yʼede: «Wede dooyisadey, a onamá geŋ kee ki kalɗa kaye ti kane pây.» ");
INSERT INTO moz_vpl VALUES ("LK11_46","072_11_46","LUK","11","46","46","Isa yi diʼn gime onamí, yʼede: «Dabar a kune ɗoŋ suuniyo kʼoogoro pây! Kuneʼŋ ɗuwo kun diʼn isiyo ki toogo an di daane urziyagi kʼoogoro ɗoŋ ti doolo kune batum kun a ziipe tʼegguŋ tʼekki ɗoŋ ki Raa, sarkiyatú oon̰e aakede kun zaapu attiɗi a dar. Wo a attiɗizaŋ geŋ, kune ti ƴilsaguŋ soo toŋ kun aa ki bottiyo ye ki noogiyadaŋ me. ");
INSERT INTO moz_vpl VALUES ("LK11_47","072_11_47","LUK","11","47","47","Dabar a kune! Kun aabuɗu muuziyagi majjanɗani ki nebiyagi ti kaaga, kane ɗoŋ moŋgiɗaguŋ an tiʼn îide. ");
INSERT INTO moz_vpl VALUES ("LK11_48","072_11_48","LUK","11","48","48","A onamguŋ ti sulɗi ɗoŋ kun isiyo geŋ, i-kaza kun iyye a naabo ere ki moŋgiɗaguŋ gʼize te, kono kane an tiʼn îide nebiyagi me, wo aŋkeŋ kune kun dʼaabuɗu muuziyagaŋ. ");
INSERT INTO moz_vpl VALUES ("LK11_49","072_11_49","LUK","11","49","49","Kono kamo Raa ti suuniyo kʼono ere i dʼede gette yʼa ruute, yʼede: “Nuŋ nʼan tʼigiba nebiyagi ti ɗoŋ zina, ɗoŋ oŋgoŋ ti diinayaŋ an tiʼn tʼîda, ɗoŋ oŋgoŋ an diʼn dabira.” ");
INSERT INTO moz_vpl VALUES ("LK11_50","072_11_50","LUK","11","50","50","Tʼume kʼeesiyo duniya bini aŋki, an îide nebiyagi ɓaadaŋ, wo kono ki puuzadaŋ gette kune ɗuwo ɗoŋ aŋken̰n̰o Raa yʼun tiʼn tʼela daŋgay. ");
INSERT INTO moz_vpl VALUES ("LK11_51","072_11_51","LUK","11","51","51","Ki poone an îide Abel, saŋ ɗoŋ ti doolo bini Zakari wede an yʼîide adda booro Ɓoy Raa, a diine kʼume seɗeke ti Ɓoy Raa. Eyye, wo kun ollo nʼun di rooto, kane ɗoŋ aŋken̰n̰o eŋ Raa yi tiʼn tʼela daŋgay kono ki puuzadaŋ. ");
INSERT INTO moz_vpl VALUES ("LK11_52","072_11_52","LUK","11","52","52","Dabar a kune ɗoŋ suuniyo kʼoogoro! Kuneʼŋ kun a-tʼippe a urzi wede i dʼeliyo suuniyo ki Raa te. Kune batum kun ki sooru eego ye, wo a ɗoŋ i dehu an dʼozire eego kun an tʼiigire.» ");
INSERT INTO moz_vpl VALUES ("LK11_53","072_11_53","LUK","11","53","53","Aame Isa yi tʼuɗɗe tʼadda ɓoy gen̰n̰o maŋ, kane ɗoŋ suuniyo kʼoogoro ti Pariziyeŋ an di gulkuwe ɓaadaŋ ti yode, wo an di yʼ tundite a urzi kʼono ɓaadaŋ. ");
INSERT INTO moz_vpl VALUES ("LK11_54","072_11_54","LUK","11","54","54","Iŋkino geŋ kane an i ekkiyo ikka kono an tʼoona munɗa wede butte adda kʼonamí. ");
INSERT INTO moz_vpl VALUES ("LK12_1","072_12_1","LUK","12","1","1","Aame geŋ ɗoŋ duuru ɓaadaŋ ɓaadaŋ an tʼugiye, ume an dʼozire toŋ umbo, an tʼon̰ƴilse dugganaŋ. Isa yʼan di ruute ki poone a sanalliyagí, yʼede: «Kun koona mentikagi a orme wede ki Pariziyeŋ, i-kaza an dʼede bize wede sire sire. ");
INSERT INTO moz_vpl VALUES ("LK12_2","072_12_2","LUK","12","2","2","Ɗerec, sulɗi ɗoŋ pay ombiɗeʼŋ, saŋ onniyo soo a tʼooɗiba ita, wo ono ɗoŋ pay i ki dehu ɗuwo an kʼolliga ye geŋ, saŋ onniyo soo ɗuwo an diʼn olliga. ");
INSERT INTO moz_vpl VALUES ("LK12_3","072_12_3","LUK","12","3","3","Kono kamo sulɗi ɗoŋ pay kun ruute a zimolo geŋ, saŋ onniyo soo ɗuwo an diʼn olliga keren̰, wo munɗa wede kun milin̰e a kuude bakaguŋ adda biino appiya geŋ, saŋ onniyo soo an di yʼ roota aa an a ti gili tʼekki biino an ɗolle.» ");
INSERT INTO moz_vpl VALUES ("LK12_4","072_12_4","LUK","12","4","4","«Laŋziyagi ki nuŋ kun ollo, nʼun di rooto: Kun an orgiɗe ye a ɗoŋ i tôwwo tudde, wo saŋ maŋ an kʼaane an aa kʼise munɗa ti doolo sey ye. ");
INSERT INTO moz_vpl VALUES ("LK12_5","072_12_5","LUK","12","5","5","Nuŋ nʼun di yʼ kaza wedusu wede kun i-dʼorgiɗe me: Kun orgiɗo a Raa, yode wede aame kun tʼinda maŋ, i-dʼede toogo yʼun diʼn tʼette kʼadda kʼuwwo. Eyye, wo kun ollo nʼun di rooto, geŋ a yode kun i-dʼorgiɗe me. ");
INSERT INTO moz_vpl VALUES ("LK12_6","072_12_6","LUK","12","6","6","Kun suune ooyo paat ɗoo miŋ in tʼowile ti soŋko sire kollo, wo ti diinayaŋ soo toŋ Raa i ki danɗiya ye. ");
INSERT INTO moz_vpl VALUES ("LK12_7","072_12_7","LUK","12","7","7","Wo soŋ ilali kʼegguŋ gen̰n̰o toŋ Raa yi tiʼn kaza pay. Iŋkino kun orgiɗe ye, kono kune zooyaguŋ yi jiire ooyo ɓaadaŋ!» ");
INSERT INTO moz_vpl VALUES ("LK12_8","072_12_8","LUK","12","8","8","«Kun ollo, nʼun di rooto, wede tuuku yi ruuta a ɗaana ɗuwo yoŋ ki nuuno maŋ, nuŋ wede an nʼehe aa ulo wede en̰n̰o toŋ, nʼa rootey kay yoŋ ki nuuno a ɗaana maaleekiyagi ɗoŋ ki Raa me. ");
INSERT INTO moz_vpl VALUES ("LK12_9","072_12_9","LUK","12","9","9","Wo ɗe wede tuuku yi ruuta a ɗaana ɗuwo yi ki nʼ suune ye maŋ, nuŋ toŋ nʼa rootey ni ki yʼ suune ye kay, a ɗaana maaleekiyagi ɗoŋ ki Raa me. ");
INSERT INTO moz_vpl VALUES ("LK12_10","072_12_10","LUK","12","10","10","Wede tuuku yi ruuta munɗa ulsu a tukki nuŋ wede an nʼehe aa ulo wede en̰n̰o maŋ, a olɗikadí gette Raa yi-tʼisa tambobino. Wo ɗe wede tuuku i kalɗita Unde Kamilen̰ maŋ, a olɗikadí gette Raa yi-kʼisa tambobino ye. ");
INSERT INTO moz_vpl VALUES ("LK12_11","072_12_11","LUK","12","11","11","Aame an un diʼn tʼiidey kʼume ɗoŋ booro adda ɓoyɗi ɗoŋ in di dooyiso, ise ki ɗaana ɗoŋ deero, ise ki ɗaana mozagi toŋ maŋ, ulbuguŋ un tʼooɗey ye a maana kʼono ɗoŋ kun dʼooɗibey egguŋ, ise a munɗa wede kun di rootey me. ");
INSERT INTO moz_vpl VALUES ("LK12_12","072_12_12","LUK","12","12","12","A ume geŋ miŋ Unde Kamilen̰ tʼun diʼn dooyey a munɗa wede kun di rootey me.» ");
INSERT INTO moz_vpl VALUES ("LK12_13","072_12_13","LUK","12","13","13","I dʼede wedusu ti diine ɗoŋ duuru yi di ruute a Isa, yʼede: «Wede dooyiso, ki rooto a leemadó yʼay ti dokkiɗi laale ki meegey wede yʼay iili me.» ");
INSERT INTO moz_vpl VALUES ("LK12_14","072_12_14","LUK","12","14","14","A wede geŋ Isa yi di ruute, yʼede: «Wee wee i ni ziipe wede ɗekkiyo booro a sulɗuguŋ, ise wede dokkiɗe laalaguŋ me?» ");
INSERT INTO moz_vpl VALUES ("LK12_15","072_12_15","LUK","12","15","15","Saŋ maŋ yʼan di ruute a ɗoŋ pay, yʼede: «Kun koona mentikagi, kun okkibe a sulɗi pay ye, kono lekkiyo wedusu ere ki kotto gette tʼettiyo tʼurzi sulɗi ɗoŋ ki laale ye, ise yoŋ laalayí ɓaadaŋ toŋ maŋ.» ");
INSERT INTO moz_vpl VALUES ("LK12_16","072_12_16","LUK","12","16","16","Iŋkino maŋ yʼan dʼîide taaya tʼurzi kʼono ombiɗe, yʼede: «I dʼede wedusu ki laale, i-dʼede domɓi majjanɗani yi-darniyta. ");
INSERT INTO moz_vpl VALUES ("LK12_17","072_12_17","LUK","12","17","17","Yo yi rootiyo tʼadda kʼaddí, yʼede: “Nuŋ geŋ nʼaase mummino, nʼa oɓita mudizó a ume too me, ume oo kʼede ye me?” ");
INSERT INTO moz_vpl VALUES ("LK12_18","072_12_18","LUK","12","18","18","Saŋ yʼa ruute sey, yʼede: “En̰n̰o munɗa wede nʼaasa me, giiƴagó eŋ nʼa-kossita, nʼan aabiɗa ti doolo deero, mudizó pay ni-tʼoɓita adda wo sulɗi ɗoŋ ti doolo toŋ maŋ. ");
INSERT INTO moz_vpl VALUES ("LK12_19","072_12_19","LUK","12","19","19","Saŋ ni di roota a tuddó batum: hay nuŋ geŋ me, en̰n̰o sulɗi kaca kaca kʼozzinagi ɓaadaŋ, nʼa-puuka, nʼa ooma, nʼa siɓa wo nʼaasa uŋsuwo.” ");
INSERT INTO moz_vpl VALUES ("LK12_20","072_12_20","LUK","12","20","20","Wo Raa yi di ruute, yʼede: “Kee wede elkisadá umbo, a diɗɗo ettiyo batum nuŋ undá ni tʼamɓa, wo geŋ sulɗi ɗoŋ pay kʼukume aaye?”» ");
INSERT INTO moz_vpl VALUES ("LK12_21","072_12_21","LUK","12","21","21","Isa yʼa ruute sey, yʼede: «Geŋ aasa iŋkino ki wede yʼokumso laale a yode batum, wo yi kʼokumso laale ki sulɗi Raa ye me.» ");
INSERT INTO moz_vpl VALUES ("LK12_22","072_12_22","LUK","12","22","22","Maŋ Isa yʼan di ruute a sanalliyagí, yʼede: «Geŋ kono kʼiŋkino nʼun di rooto: Kune a lekkiyaguŋ ulbuguŋ un tʼooɗe ye a urzi kʼomɓo, ise a urzi kʼossiyo ere ki tudduguŋ toŋ maŋ. ");
INSERT INTO moz_vpl VALUES ("LK12_23","072_12_23","LUK","12","23","23","Ki kotto lekkiyaguŋ ere kun lekkiyo ette ti jiire omɓo, wo tudduguŋ ti jiire ossiyo. ");
INSERT INTO moz_vpl VALUES ("LK12_24","072_12_24","LUK","12","24","24","Kun wollo gaagagi, an ki korso ye, an kʼayɗu ye, an kʼede giiƴagi ye wo ume ti doolo kʼoɓite kʼomɓadaŋ ye, wo Raa yi diʼn moɗɗiyo. Wo kuneʼŋ ki kotto kun i jiire emɓi taŋ ɓaadaŋ! ");
INSERT INTO moz_vpl VALUES ("LK12_25","072_12_25","LUK","12","25","25","Wee wee ti diinaguŋ, ti ulbe kʼooɗiyo wede i-dʼede geŋ, yʼaane yʼa dʼaagila ti keɗise soo onniytagi ɗoŋ ki lekkiyadí a duniya ette? ");
INSERT INTO moz_vpl VALUES ("LK12_26","072_12_26","LUK","12","26","26","Aame a sulɗi ɗoŋ bo-booloŋ ɗaŋŋal toŋ kun kʼaane ye maŋ, ɗe ki moo me kune ulbuguŋ un dʼooɗiyo a sulɗi ɗoŋ pay ti doolo a urzi lekkiyaguŋ me? ");
INSERT INTO moz_vpl VALUES ("LK12_27","072_12_27","LUK","12","27","27","Kun wollo bobbo soole, ti dʼohire, ti ki naabiya ye, ti kʼisiyo kallagi ye. Wo kun ollo, nʼun di rooto: Mozigo Salamoŋ toŋ ti laale wede pay i-dʼede geŋ, yi kʼusse ye kalle wede majjaane aakede bobbo soole soo toŋ maŋ. ");
INSERT INTO moz_vpl VALUES ("LK12_28","072_12_28","LUK","12","28","28","Iŋkino Raa yi-ti yʼossiyo soole wede adda balɗa aŋki kuti kutin̰, wo soggo an tʼoggiyo adda kʼuwwo mendí. Geŋ taŋ miibi a ceere Raa yʼun diʼn osse kune batum me! Ki kotto kune zaapu kʼadduguŋ a Raa baata! ");
INSERT INTO moz_vpl VALUES ("LK12_29","072_12_29","LUK","12","29","29","Wo kune ulbuguŋ un ki tʼooɗe daayum a urzi dehutu kʼomɓo ti soɓo ye. ");
INSERT INTO moz_vpl VALUES ("LK12_30","072_12_30","LUK","12","30","30","Sulɗi pay geŋ, daayum iʼni dehutu kane ɗoŋ pay adda duniya i ki suune Raa soo ɗaŋŋal ye gen̰n̰o. Wo Meeguguŋ Raa, yoŋ yi suune sulɗi geŋ kun i dehu a urzi lekkiyaguŋ me. ");
INSERT INTO moz_vpl VALUES ("LK12_31","072_12_31","LUK","12","31","31","Ki too maŋ kun deho ki poone Moziko Raa, wo saŋ sulɗi geŋ yʼun diʼn tʼela kay.» ");
INSERT INTO moz_vpl VALUES ("LK12_32","072_12_32","LUK","12","32","32","«Kune aakede torɗo mooɗe ere baata toŋ maŋ, kun orgiɗe ye! Ɗerec, Meeguguŋ Raa yi wulle maŋ beehiye Mozikadí yʼun di-tʼele me. ");
INSERT INTO moz_vpl VALUES ("LK12_33","072_12_33","LUK","12","33","33","Sulɗuguŋ ɗoŋ un dʼede kun tʼowilto, wo soŋko kun an di dokko a ɗoŋ an kʼede munɗa ye. Kun soko zaaɗa ere i ki ruumiyo ye wo ti laale wede i ki dagga ye a kandaane, a ummey wede kʼoogire yi kʼaana yi ki botta ye, a ummey amma toŋ ti ki ti yʼ latta ye. ");
INSERT INTO moz_vpl VALUES ("LK12_34","072_12_34","LUK","12","34","34","Ɗerec, a ume wede laalaguŋ yi lekkiyo geŋ, adduguŋ toŋ aŋgen̰n̰o.» ");
INSERT INTO moz_vpl VALUES ("LK12_35","072_12_35","LUK","12","35","35","«Kun ti ketto toonuguŋ a munɗa wede kun ise, wo pintilaguŋ oyyisito. ");
INSERT INTO moz_vpl VALUES ("LK12_36","072_12_36","LUK","12","36","36","Kun lekko aakede ɗoŋ naabo ɗoŋ an delliyo kama ki goolayaŋ ti tarnaape seeɗu, kono saŋ aame yʼiina wo yi guppa biza maŋ, kesiko an i-di tʼihina. ");
INSERT INTO moz_vpl VALUES ("LK12_37","072_12_37","LUK","12","37","37","Uŋsuwo a ɗoŋ naabo gen̰n̰o, ɗoŋ goolayaŋ a kamadí yiʼni tʼoona kane zeere. Ɗerec iŋkino wo nʼun di rooto: Yoŋ yi-tʼossa sulɗi naabo, yʼa tiʼn koona ɗoŋ naabadí me, wo aame geŋ yoŋ yʼan tʼela omɓo. ");
INSERT INTO moz_vpl VALUES ("LK12_38","072_12_38","LUK","12","38","38","Aame yi-kimo a diɗɗo meeda ise ki biza soohe toŋ maŋ, yiʼn uuna kane zeere maŋ, geŋ uŋsuwo a kane. ");
INSERT INTO moz_vpl VALUES ("LK12_39","072_12_39","LUK","12","39","39","Ono eŋ kun ollo koɗuwo: Aame wede ɓoy geŋ yi suune peeɗo ere wede kʼoogire yʼetto maŋ, yi kʼooli wede kʼoogire yi-ki tʼette kʼadda ɓoozí ye. ");
INSERT INTO moz_vpl VALUES ("LK12_40","072_12_40","LUK","12","40","40","Kune toŋ maŋ kun koona mentikagi, kono nuŋ wede an nʼehe aa ulo wede eŋ, nʼetto a peeɗo ere tuuku kun ki ti suune ye.» ");
INSERT INTO moz_vpl VALUES ("LK12_41","072_12_41","LUK","12","41","41","Iŋkino maŋ Piyer yʼa yi tunde, yʼede: «Galmeeʼki nuŋ, ono ombiɗe kiʼni rootiyo eŋ a kaye ɗaŋŋal kunuŋ, a ɗuwo pay ko?» ");
INSERT INTO moz_vpl VALUES ("LK12_42","072_12_42","LUK","12","42","42","Maŋ Galmeega yi di ruute, yʼede: «Iŋkino maŋ wede ƴeeriyo wede i seeɗu zakiɗi a naabadí wo i-dʼede elkiyo geŋ, a yode gen̰n̰o galmeegí yi oola attiɗi pay ki ɗoŋ naabadí oŋgoŋ me, kono yʼan tʼela omɓadaŋ aame peeɗo tʼîida maŋ. ");
INSERT INTO moz_vpl VALUES ("LK12_43","072_12_43","LUK","12","43","43","Uŋsuwo a wede naabo geŋ me, aame galmeegí a kamadí yi yʼuuna yʼisiyo naabo gettiyo maŋ. ");
INSERT INTO moz_vpl VALUES ("LK12_44","072_12_44","LUK","12","44","44","Ɗerec iŋkino wo nʼun di rooto: Wede iŋkino geŋ galmeegí yi di tʼela attiɗi ki sulɗizí pay a beezí. ");
INSERT INTO moz_vpl VALUES ("LK12_45","072_12_45","LUK","12","45","45","Wo ɗe aakede wede naabo geŋ yʼilka adda kʼaddí, yʼiisa: “Galmeegó eŋ yi tʼûsso”, wo yi tʼiida taazu ɗoŋ naabo ti doolo kuuli wo erayi, yi tʼussa a omɓo ti soɓito i jiira eedí. ");
INSERT INTO moz_vpl VALUES ("LK12_46","072_12_46","LUK","12","46","46","Aame geŋ galmeegí yʼa aana a onniyo ere wede naabo geŋ yi kʼelkiyo ye, wo a peeɗo ere yi ki ti suune ye. Galmeegí yi di tʼela daŋgay ere zakiɗi wo yi-tʼela aggadí aa ki ɗoŋ i ki zaapu addaŋ a Raa ye. ");
INSERT INTO moz_vpl VALUES ("LK12_47","072_12_47","LUK","12","47","47","Wede naabo wede i suune munɗa wede galmeegí yi dehu, wo yʼa ki tʼikkima tuddí yʼa ki tʼize ye naabo ere aa galmeegí yi dehu te maŋ, yoŋ geŋ yʼa tʼoona kossiyo ɓaadaŋ. ");
INSERT INTO moz_vpl VALUES ("LK12_48","072_12_48","LUK","12","48","48","Wo wede naabo wede yi ki yʼ suune ye munɗa wede galmeegí yi dehu me, wo yi tʼize naabo ere yʼa tʼoone kossiyo maŋ, kossiyadí tʼaase baata. A wede sulɗi ɓaadaŋ an i ele a beezí geŋ, an tonda ɓaadaŋ kay, wo a wede an ziipe addaŋ ɓaadaŋ geŋ, an tonda ɓaadaŋ sey a ceera.» ");
INSERT INTO moz_vpl VALUES ("LK12_49","072_12_49","LUK","12","49","49","«Nuŋ nʼiido nʼa-tʼoyye uwwo a duniya te, wo aŋken̰n̰o eŋ ni dehu tʼadde soo, todʼ ti ziiɗa baa. ");
INSERT INTO moz_vpl VALUES ("LK12_50","072_12_50","LUK","12","50","50","Nuŋ nʼa aɗɗa tʼurzi dabar aakede an ni suyyiso batem, nuŋ biza kʼulbó i zehiso wo a zehita bini ɗaŋgiya ki suyyiso batem gettiyo. ");
INSERT INTO moz_vpl VALUES ("LK12_51","072_12_51","LUK","12","51","51","Kune kun elkiyo nuŋ nʼiido nʼun tʼela toose adda duniya ko? Aha, wo nʼun di rooto, kono nuuno geŋ ɗuwo tuddaŋ an ti-tʼahinta. ");
INSERT INTO moz_vpl VALUES ("LK12_52","072_12_52","LUK","12","52","52","Ti aŋki eŋ ɗoŋ adda ɓoozaŋ kane paat maŋ, tuddaŋ an ti-tʼahinta, ɗoŋ aɗo ki tukki ɗoŋ sire, wo ɗoŋ sire ki tukki ɗoŋ aɗo. ");
INSERT INTO moz_vpl VALUES ("LK12_53","072_12_53","LUK","12","53","53","Meege yʼa tʼahina ti tukkʼulí wo ulo ti tukki meegí, meede tʼa tʼahina ti tukkʼututú wo uto ti tukki mettú, ande tʼa tʼahina ti tukkʼere kʼulutú wo ere kʼulutú ti tukkʼandutú.» ");
INSERT INTO moz_vpl VALUES ("LK12_54","072_12_54","LUK","12","54","54","Isa yʼa ruute sey a ɗoŋ duuru, yʼede: «Aame kun wolliyo dondirso ti koliyo ti kese peeɗo kʼooriyo maŋ, a kaamiki kun dʼeesiyo: “Mizzi yi koppa”, wo geŋ ki kotto i-tʼisiyo. ");
INSERT INTO moz_vpl VALUES ("LK12_55","072_12_55","LUK","12","55","55","Wo aame kun owwiyo maaye yi baahu ti kese ki ɗanɗi maŋ, kun dʼeesiyo: “Ume aŋki yʼisa wehini”, wo geŋ ki kotto i-tʼisiyo. ");
INSERT INTO moz_vpl VALUES ("LK12_56","072_12_56","LUK","12","56","56","Kune ɗoŋ biziguŋ sire sire, kun dʼaaniya kun di suuniyo ita sulɗi ɗoŋ kun wolliyo tʼedaguŋ isiyo a siiɗo wo a kandaane me, wo ɗe ki moo me ita sulɗi ɗoŋ Raa yʼisiyo aŋken̰n̰o kun kiʼn suuniyo ye me?» ");
INSERT INTO moz_vpl VALUES ("LK12_57","072_12_57","LUK","12","57","57","«Ɗe ki moo me munɗa wede ki diine kune batum kun dʼise, kun ki yʼ suuniyo ye me? ");
INSERT INTO moz_vpl VALUES ("LK12_58","072_12_58","LUK","12","58","58","Aame ti leemadá un ede ono, wo kune a urzi kun ette kʼume wede booro ɓotto geŋ, ti yode ono kun tiʼn ôodo. Para maŋ yʼa-da tʼiida kʼume wede booro maŋ, wede booro yʼan gi di tʼeley a bey kʼasigiryagi, wo kane an ki ti tʼeley daŋgay. ");
INSERT INTO moz_vpl VALUES ("LK12_59","072_12_59","LUK","12","59","59","Ki kotto nʼa di rooto, tʼume geŋ ki ki tʼaɗɗa ye, daa ki munɗa wede an dehu kʼan ki yʼela pay ye maŋ, tammiyagi ɗoŋ sun̰n̰i sun̰n̰i toŋ an a-kʼoola ye.» ");
INSERT INTO moz_vpl VALUES ("LK13_1","072_13_1","LUK","13","1","1","Aame geŋ i dʼiido ɗuwo an i-tʼîide taaya a Isa, mummino Pilat yʼele urzi ɗoŋ miibi ti siiɗo Galile an diʼn îide, aame an isiyo seɗeke a Raa geŋ me. ");
INSERT INTO moz_vpl VALUES ("LK13_2","072_13_2","LUK","13","2","2","Isa yʼan diʼn gime onamaŋ, yʼede: «Kune kun elkiyo aame kane ɗoŋ ti siiɗo Galile an tiʼn îide iŋkino geŋ, i-kaza kane ɗoŋ kʼolɗiko a jiire ɗoŋ ti siiɗo Galile ti doolo pay ko? ");
INSERT INTO moz_vpl VALUES ("LK13_3","072_13_3","LUK","13","3","3","Nʼun di rooto aha, wo aame kun ki ti gima lekkiyaguŋ ye maŋ, kune toŋ kun di-tʼinda pay aa kane. ");
INSERT INTO moz_vpl VALUES ("LK13_4","072_13_4","LUK","13","4","4","Wo kane ɗoŋ koomat makumu gessire ɓoy wede sohuru ki Silowe yʼan di tiʼn ruuge an tʼinda geŋ, kun elkiyo kane ɗoŋ kʼolɗiko a jiire ɗoŋ ki geeger Zeruzalem ti doolo pay ko? ");
INSERT INTO moz_vpl VALUES ("LK13_5","072_13_5","LUK","13","5","5","Nʼun di rooto aha, wo aame kun ki ti gima lekkiyaguŋ ye maŋ, kune toŋ kun di-tʼinda pay iŋkino kay.» ");
INSERT INTO moz_vpl VALUES ("LK13_6","072_13_6","LUK","13","6","6","Saŋ maŋ Isa yʼan di ruute ono ombiɗe en̰n̰o, yʼede: «I dʼede wedusu yi dʼiite undumu sundí pigiye adda doome kʼinda bin̰. Onniyo soo yo wede geŋ yʼa iido yi dehu yi rakke in̰n̰izí, miŋ umbo yi ki dʼuune ye. ");
INSERT INTO moz_vpl VALUES ("LK13_7","072_13_7","LUK","13","7","7","Iŋkino maŋ yi di ruute a wede naabadí, yʼede: “Ki wollo, pigiye eŋ îide ozzine aɗo ni dʼettiyo dʼettiyo ni rakke in̰n̰izí miŋ ni kʼooniyo ye. Iŋkino ki ti yʼ ɗekko, yi tʼamɓu ume ki bita.” ");
INSERT INTO moz_vpl VALUES ("LK13_8","072_13_8","LUK","13","8","8","Wo wede naabo yi diʼn gime onamí, yʼede: “Galmeeʼki nuŋ, ki yʼoolo yʼa-tʼozzine sey kʼaŋki me, siiɗo itadí nʼa-tʼottiba a tʼisa ɗolgite, maŋ nʼa dʼoɓita iizi. ");
INSERT INTO moz_vpl VALUES ("LK13_9","072_13_9","LUK","13","9","9","Geŋ iŋkino ozzine ki ɗaana eŋ koo yi tʼeha maŋ, umbo pi maŋ kʼa ti yʼ ɗekka kollo.”» ");
INSERT INTO moz_vpl VALUES ("LK13_10","072_13_10","LUK","13","10","10","Onniyo soo ere ki puukiyo Yawudiyagi maŋ, Isa yi dooyiso ɗuwo adda ɓoy wede Yawudiyagi ge dooyiso. ");
INSERT INTO moz_vpl VALUES ("LK13_11","072_13_11","LUK","13","11","11","A ume geŋ i dʼede erewo, siitan ti ziiɗa diine dartú i-dʼede ozzine koomat makumu gessire, ti lekkiyo ottilso ume tʼa tʼôhira ɗelele umbo. ");
INSERT INTO moz_vpl VALUES ("LK13_12","072_13_12","LUK","13","12","12","Aame Isa yi ti wulle maŋ, yʼa ti wiike wo yi di ruute, yʼede: «Erewo no, koŋ te kettiyo ye baa, mʼuune bee ti eenizí me.» ");
INSERT INTO moz_vpl VALUES ("LK13_13","072_13_13","LUK","13","13","13","Yoŋ yi di ziipe beezí a tuddutú, a kaamiki tʼa tʼîhira ɗelele wo tʼa iise tamma Raa. ");
INSERT INTO moz_vpl VALUES ("LK13_14","072_13_14","LUK","13","14","14","Wo yo goole ɓoy geŋ yi-ti gulkuwe a beeko ere Isa yi ele a erewo a onniyo ere ki puukiyo Yawudiyagi gette. Iŋkino yʼa tʼihina bizí wo yʼan di ruute a ɗoŋ duuru, yʼede: «Adda suuk i dʼede onniyo zoot ere ki naabo te. Kune kun dehu beeko maŋ, kun dʼetto adda kʼonniytagi gen̰n̰o, a onniyo ere ki puukiyadiŋ ye.» ");
INSERT INTO moz_vpl VALUES ("LK13_15","072_13_15","LUK","13","15","15","Maŋ Galmeega yi diʼn gime onamí, yʼede: «Kune ɗoŋ biziguŋ sire sire, a onniytagi ɗoŋ ki puukiyadiŋ wede tuuku toŋ yi-tʼeeziyo ti kuulayeʼŋ burizí koo, ise buurizí koo maŋ, kun an tʼeliyo ahu ɗee me? ");
INSERT INTO moz_vpl VALUES ("LK13_16","072_13_16","LUK","13","16","16","Erewo ette todʼte ti biza bumɓu kʼIbirayim, Meeda siitanɗani ti ti-gitte i-dʼede ozzine koomat makumu gessire, geŋ i kʼise ye ko a onniyo ere ki puukiyadiŋ kino, ni di tʼeeze sibatú me?» ");
INSERT INTO moz_vpl VALUES ("LK13_17","072_13_17","LUK","13","17","17","A rootiyo kʼIsa gette, kane pay ɗoŋ kʼolmiɗayí an ziiɗa sukiyagi, wo kane pay ɗoŋ duuru geŋ ulbaŋ uŋse a sulɗi ɗoŋ pay yʼisiyto i ceeriyo eego geŋ me. ");
INSERT INTO moz_vpl VALUES ("LK13_18","072_13_18","LUK","13","18","18","Maŋ Isa yʼa ruute, yʼede: «Moziko Raa todʼ ti deeƴiso toŋ aa moo me? Nʼa tʼeese todʼte aa moo me? ");
INSERT INTO moz_vpl VALUES ("LK13_19","072_13_19","LUK","13","19","19","Todʼ ti deeƴiso aa ulo kʼundumu soo sundí mutard wedusu yʼa tʼumɓe yʼa-giira adda jineene. Saŋ a tʼuɗɗe, a tʼize undumu wo emɓi an dʼappiyta ɓoyɗi ekki layɗayí.» ");
INSERT INTO moz_vpl VALUES ("LK13_20","072_13_20","LUK","13","20","20","Isa yʼa ruute sey, yʼede: «Moziko Raa nʼa tʼeese todʼte aa moo me? ");
INSERT INTO moz_vpl VALUES ("LK13_21","072_13_21","LUK","13","21","21","Todʼ ti deeƴiso aa orme erewo ti-sokiyo booloŋ, tʼa-tʼoɓe a moono ɓaadaŋ lootiyo, wo saŋ orme geŋ moono yi-ti tʼoozige pay.» ");
INSERT INTO moz_vpl VALUES ("LK13_22","072_13_22","LUK","13","22","22","Aame Isa yʼamɓe ki Zeruzalem geŋ, yi dʼettiyo geeger ti geeger, ille ti ille, yi dooyiso ɗuwo. ");
INSERT INTO moz_vpl VALUES ("LK13_23","072_13_23","LUK","13","23","23","Maŋ i dʼede wedusu yʼa yi tunde, yʼede: «Galmeeʼki nuŋ, ɗe geŋ Raa yi dʼutta ɗuwo booloŋ ɗaŋŋal ko?» Iŋkino Isa yʼan di ruute a ɗoŋ duuru, yʼede: ");
INSERT INTO moz_vpl VALUES ("LK13_24","072_13_24","LUK","13","24","24","«Kun ollo, nʼun di rooto, kun elo gotono kun tʼodo ti biza perƴeƴe. Ɗerec, ɗoŋ ɓaadaŋ an deha an tʼette ti biza gen̰n̰o wo an ki dʼaana ettiyo ye. ");
INSERT INTO moz_vpl VALUES ("LK13_25","072_13_25","LUK","13","25","25","Saŋ onniyo tʼaana ere wede ɓoy yʼa tʼooziga wo biza yʼa di-tʼippa ti kerle, maŋ kune kun dʼoopa ti paate. Aame geŋ kun tʼeesa koppiyo a biza bumɓu, wo kun di roota: “Galmeegey, kʼay tʼohon!” Wo yoŋ yʼun tiʼn kima onamguŋ, yʼa tʼeesa: “Nʼun kiʼn suune ye kune ti tunɗa me.” ");
INSERT INTO moz_vpl VALUES ("LK13_26","072_13_26","LUK","13","26","26","Iŋkino maŋ kun di roota kun tʼeesa: “Kaye ay dʼiimito, ay dʼiiɓito ti kee kaŋ soo, kʼa duuyite a urziyagi ki geegirzey pây.” ");
INSERT INTO moz_vpl VALUES ("LK13_27","072_13_27","LUK","13","27","27","Wo yoŋ yʼun di roota sey: “Nʼun kiʼn suune ye kune ti tunɗa me. Kun ti leɗɗo dokki ti tuddó me, kune ɗoŋ pay isiyo sulɗi ɗoŋ ki diine ye.” ");
INSERT INTO moz_vpl VALUES ("LK13_28","072_13_28","LUK","13","28","28","Wo aame kun wulley Ibirayim, Isaaka wo Yakup ti nebiyagi pay adda Moziko Raa, wo kune an un tiʼn zibbey ti paate maŋ, a ume geŋ kun ɗillitey môolo wo kun dʼaaɗimey sina. ");
INSERT INTO moz_vpl VALUES ("LK13_29","072_13_29","LUK","13","29","29","Wo i dʼetto ɗuwo sey ti kese peeɗo ti koliyo, ti kese peeɗo kʼooriyo, ti kese kʼawwa wo ti kese ɗanɗi, an di-kooney an dʼoomey kaŋ soo adda Moziko Raa. ");
INSERT INTO moz_vpl VALUES ("LK13_30","072_13_30","LUK","13","30","30","Iŋkino maŋ ɗoŋ oŋgo aŋken̰n̰o kane kʼita, saŋ an tʼisa ɗoŋ ki biza, wo ɗoŋ oŋgo aŋken̰n̰o kane ki biza, saŋ an tʼisa ɗoŋ kʼita.» ");
INSERT INTO moz_vpl VALUES ("LK13_31","072_13_31","LUK","13","31","31","Aame Isa yʼa ti ɗiŋge ti dooyiso maŋ, i dʼede ɗoŋ miibi ti diine Pariziyeŋ, an aa dʼiide sirpa kʼIsa wo an i-di ruute, anʼde: «Kee tʼeŋ ki tʼoozo kʼeŋgilo kʼume doolo, kono mozigo Erod yi dehu tôwwadá.» ");
INSERT INTO moz_vpl VALUES ("LK13_32","072_13_32","LUK","13","32","32","Wo Isa yʼan di ruute, yʼede: «Kunʼdo kun i-ti rootoy a yo wede metike aa boo yi ti daggiya ɗuwo geŋ, kunʼde: “Isa yʼede aŋki ti soggo yoŋ yʼa limmiti siitanɗani wo yʼa tʼele beeko a ɗoŋ kʼeeni, wo a onniyo ere kʼaɗuwe maŋ, naabadí yʼa-ti ɗaŋga.” ");
INSERT INTO moz_vpl VALUES ("LK13_33","072_13_33","LUK","13","33","33","Wo ni roote eŋ a kune: i dehu aŋki, soggo wo soŋŋo kino geŋ, nʼa eŋgila ki ɗaanadó, ki too maŋ ɗerec nebi yʼa tʼinda a Zeruzalem, a ume doolo ye. ");
INSERT INTO moz_vpl VALUES ("LK13_34","072_13_34","LUK","13","34","34","Wayya kune ɗoŋ Zeruzalem no, wayya kune ɗoŋ Zeruzalem no! Kune ɗoŋ i tôwwito nebiyagi, wo ɗoŋ Raa yʼun akkisa kun tiʼn kakkisa ti moŋgali kun tiʼn tôwwo. Nuŋ taŋ ɓaadaŋ nʼa dihe nʼun tiʼn tusse aa ôsso ti tussiyo in̰n̰itú adda kambartú, wo ɗe kun ki dihe ye. ");
INSERT INTO moz_vpl VALUES ("LK13_35","072_13_35","LUK","13","35","35","Iŋkino maŋ ɓoyguŋ Raa yʼun di yʼoola. Wo kun ollo nʼun di rooto, nuŋ kun ki nʼ wolla ye baa, bini a tʼîda onniyo ere kun di roota: “Beeko Raa ti koona a ekki wede ettiyo ti suma Galmeega Raa.”» ");
INSERT INTO moz_vpl VALUES ("LK14_1","072_14_1","LUK","14","1","1","Onniyo soo ere ki puukiyo Yawudiyagi maŋ, Isa yʼa tʼiide omɓo di wede soo ti diine deero Pariziyeŋ. Kane ɗoŋ a sirpa geŋ, ersadaŋ a tukkʼIsa tak. ");
INSERT INTO moz_vpl VALUES ("LK14_2","072_14_2","LUK","14","2","2","Aame geŋ i dʼede wedusu tuddí tʼiiziga, yʼa tʼîhira a ɗaana yode. ");
INSERT INTO moz_vpl VALUES ("LK14_3","072_14_3","LUK","14","3","3","Isa yʼa tʼihina bizí, yʼa tunde kane ɗoŋ suuniyo kʼoogoro ti Pariziyeŋ, yʼede: «To oogiradiŋ tiŋ urzi tʼele kunuŋ, ti kʼele ye ko, kʼeliyo beeko a wedusu a onniyo ere ki puukiyadiŋ te?» ");
INSERT INTO moz_vpl VALUES ("LK14_4","072_14_4","LUK","14","4","4","Wo a onamí geŋ kane an dʼinniga ɗeɗɗek. Iŋkino maŋ wede geŋ Isa yʼa yi butte, yi-dʼele beeko wo yʼa-yʼigibe ki ɓoozí. ");
INSERT INTO moz_vpl VALUES ("LK14_5","072_14_5","LUK","14","5","5","Saŋ yʼan di ruute, yʼede: «Ti diinaguŋ eŋ wee wee, aame i-dʼede ulo ise buru yi tʼiire adda kʼosso a onniyo ere ki puukiyadiŋ maŋ, yʼa kʼette, tʼadda kʼosso yʼa ki yʼaɗɗe ye me? Eyye, kesiko yʼa-tʼaɗɗe!» ");
INSERT INTO moz_vpl VALUES ("LK14_6","072_14_6","LUK","14","6","6","Wo a onamí geŋ, kane an di roote munɗa an ki suune ye. ");
INSERT INTO moz_vpl VALUES ("LK14_7","072_14_7","LUK","14","7","7","Isa yi wulleʼŋ ɗoŋ anʼni waaku kʼomɓoʼŋ, an beeriyo omagi konsito ɗoŋ majjanɗani. Iŋkino yʼan di ruute a kane pay geŋ tʼono ombiɗe en̰n̰o, yʼede: ");
INSERT INTO moz_vpl VALUES ("LK14_8","072_14_8","LUK","14","8","8","«Aame wenɗa yi ki wiike a tarnaape ki seeɗu maŋ, kʼetta ki koona ume wede suma a jiire ye. Koo ise an wiiko wede goole i jiire kee yʼa-koona maŋ, ");
INSERT INTO moz_vpl VALUES ("LK14_9","072_14_9","LUK","14","9","9","wo wede unni wiike kee ti yode geŋ, yʼa etto yʼa di roota, yʼa tʼeesa: “Ume eŋ ki tʼoozo, ki oolo a yode en̰n̰o.” Iŋkino kʼa tʼooziga ti sukiyagi, kʼetta kʼa-kooney a ume kʼita. ");
INSERT INTO moz_vpl VALUES ("LK14_10","072_14_10","LUK","14","10","10","Ki too maŋ an ki wiiko geŋ, kʼodo ki-koonoy a ume kʼita, iŋkino aame wede i ki wiiko yʼiina maŋ, yoŋ yʼa di roota, yʼa tʼeesa: “Laŋze ki nuŋ, kee ki tʼoozigi, ki-koona a ume ki ɗaana a ise majjaane kino.” Iŋkino maŋ a kee a di tʼisa suma a ɗaana kane ɗoŋ pay ooma ti kee kaŋ soo geŋ me. ");
INSERT INTO moz_vpl VALUES ("LK14_11","072_14_11","LUK","14","11","11","Ɗerec, wede tuuku tuddí yi ti-koliyo maŋ, Raa yʼa yʼisa n̰eŋku, wo wede tuddí yi ti-tʼisiyo n̰eŋko maŋ, Raa yʼa yʼisa goole.» ");
INSERT INTO moz_vpl VALUES ("LK14_12","072_14_12","LUK","14","12","12","Isa yi di ruute sey a wede i yʼ wiike geŋ, yʼede: «Aame ki dehu ki waake ɗuwo an dʼoomi di kee, ise a peeɗo tʼize diine, ise a peeɗo tʼette kʼooriyo toŋ maŋ, ki waake laŋziyagá ye, zemɓadá ye, taasiyagá ye wo ɗoŋ bey a ita waayadá ye, kono kane gen̰n̰o toŋ saŋ an gi di waaka kay, iŋkino omɓadá aakede an a-ti gime. ");
INSERT INTO moz_vpl VALUES ("LK14_13","072_14_13","LUK","14","13","13","Wo ki too maŋ, aame ki waake ɗuwo a tarnaape di kee maŋ, ki waako ɗoŋ an kʼede munɗa ye, ɗoŋ kesiyagaŋ soo soo, ɗoŋ jekese wo ɗoŋ koŋzayi. ");
INSERT INTO moz_vpl VALUES ("LK14_14","072_14_14","LUK","14","14","14","Geŋ kee ulbá aasa uŋse, kono kane an kʼede munɗa an a-ki ti yʼ kima ye. Iŋkino a di ti yʼ kima Raa, a onniyo ere ɗoŋ ki diine a ɗaanadí an ti bilɗa maŋ.» ");
INSERT INTO moz_vpl VALUES ("LK14_15","072_14_15","LUK","14","15","15","Wede soo ti diine ɗoŋ an ti guune omɓo, yʼilliga ono ɗoŋ Isa yi ruute gen̰n̰o maŋ, yi di ruute, yʼede: «Uŋsuwo a wede i kooney omɓo adda Moziko Raa.» ");
INSERT INTO moz_vpl VALUES ("LK14_16","072_14_16","LUK","14","16","16","Wo Isa yi di ruute tʼono ombiɗe en̰n̰o, yʼede: «Onniyo soo wedusu yi dʼize omɓo ɓaadaŋ, maŋ yi wiike ɗoŋ ɓaadaŋ. ");
INSERT INTO moz_vpl VALUES ("LK14_17","072_14_17","LUK","14","17","17","Aame omɓo ettú tʼîide maŋ, wede ɓoy yʼa igibe wede naabadí kono yʼan di kizo a ɗoŋ yiʼni wiike. Wede geŋ yʼiideʼŋ, yʼa ruute, yʼede: “Kunʼdi, omɓo ettú tʼîide baa.” ");
INSERT INTO moz_vpl VALUES ("LK14_18","072_14_18","LUK","14","18","18","Iŋkino maŋ kane ɗoŋ pay yi wiike geŋ, wede soŋ yi-tʼisiyo tambobino tambobino. Wede ki poone yi di ruute a wede naabo, yʼede: “Nuŋ ni iwila doome, i dehu nʼa ette nʼa ti yʼ wollo ɗo. Kee kʼo tʼisi tambobino.” ");
INSERT INTO moz_vpl VALUES ("LK14_19","072_14_19","LUK","14","19","19","Wede doolo yi di ruute, yʼede: “Nuŋ ni iwila buŋgari koomat ki naabo sire sire, wo nʼette nʼa tiʼn naamey. Kee kʼo tʼisi tambobino.” ");
INSERT INTO moz_vpl VALUES ("LK14_20","072_14_20","LUK","14","20","20","Wede doolo sey yi di ruute, yʼede: “Nuŋ aŋken̰n̰o ni ziiɗa erewo ni morbiyo, kono kʼiŋkino ni kʼaane ettiyo ye me.” ");
INSERT INTO moz_vpl VALUES ("LK14_21","072_14_21","LUK","14","21","21","Wede naabo geŋ yʼa-gime kʼume galmeegí, yʼiideʼŋ yi di tʼîide taaya a onamaŋ geŋ me. Aame geŋ wede ɓoy yi di gulkuwe wo yi di ruute a wede naabadí, yʼede: “Kʼokko kesiko kʼomagi ɗoŋ ɗuwo ge lekkiyo, kʼadda kʼurziyagi ɗoŋ adda geeger, ki waaki kane ɗoŋ an kʼede munɗa ye, ɗoŋ kesiyagaŋ soo soo, ɗoŋ koŋzayi wo ɗoŋ jekese, kʼan dʼan tʼedi ken̰n̰o.” ");
INSERT INTO moz_vpl VALUES ("LK14_22","072_14_22","LUK","14","22","22","Saŋ maŋ wede naabo geŋ yʼa-gimo kʼume galmeegí, yi di ruute, yʼede: “Galmeeʼki nuŋ, naabo ere kʼo ruute nʼaase ni-tʼizo, wo ume ede sey.” ");
INSERT INTO moz_vpl VALUES ("LK14_23","072_14_23","LUK","14","23","23","Iŋkino maŋ wede ɓoy yi di ruute a wede naabadí, yʼede: “Kʼokko sey ki urziyagi domɓi, kʼadda jinenɗani, wo ɗoŋ ki tʼooney a ɗaanadá geŋ, tʼurzi tuuku toŋ ki tiʼn waaki an tʼedi kʼadda ɓoy kono ɓoozó a ôone. ");
INSERT INTO moz_vpl VALUES ("LK14_24","072_14_24","LUK","14","24","24","Geŋ kun ollo, nʼun di rooto, kane ɗoŋ ni wiike ki poone geŋ, wenɗa soo toŋ i kʼooma ye omɓadó te.”» ");
INSERT INTO moz_vpl VALUES ("LK14_25","072_14_25","LUK","14","25","25","Ɗoŋ duuru ɓaadaŋ an daaniya Isa, maŋ yʼa-gime ki tuddaŋ wo yʼan di ruute, yʼede: ");
INSERT INTO moz_vpl VALUES ("LK14_26","072_14_26","LUK","14","26","26","«Aame wede yi ni daane maŋ, i dehu nuŋ yʼa ni geyye a ceere meegí, meedí, eddí, in̰n̰izí, zemɓadí kuuli erayi, wo tuddí batum toŋ maŋ. Para maŋ yi kʼaane yi ki tʼise sanallusizó ye. ");
INSERT INTO moz_vpl VALUES ("LK14_27","072_14_27","LUK","14","27","27","Wede tuuku yi kʼiyya yʼa ki tʼinda kono nuuno wo yʼa ki nʼ daane ye maŋ, yoŋ geŋ yi kʼaane yi ki tʼise sanallusizó ye. ");
INSERT INTO moz_vpl VALUES ("LK14_28","072_14_28","LUK","14","28","28","Iŋkino aame wede ti diinaguŋ yi dehu yʼa ooziga ɓoy sohuru maŋ, ki poone yʼa-koone yʼa-kize soŋko ki sulɗi ɗoŋ pay yʼowilta, wo yʼa wolle aame soŋkadí i-tʼîda tôwwo ɓoy maŋ. ");
INSERT INTO moz_vpl VALUES ("LK14_29","072_14_29","LUK","14","29","29","Wo ɗe aame yi-ziipa ita ɗaŋŋal wo ɓoy yʼa ki ti yʼîida ye maŋ, ɗoŋ pay i wolla geŋ an di yʼ tʼokka maade, ");
INSERT INTO moz_vpl VALUES ("LK14_30","072_14_30","LUK","14","30","30","an tʼeesa: “Wede eŋ yi-tʼiise oozige ɓoy miŋ naabadí yʼa-ki ti ɗiŋge ye.” ");
INSERT INTO moz_vpl VALUES ("LK14_31","072_14_31","LUK","14","31","31","Iŋkino kay, aame mozigo yi dehu yʼette ɗeyyiso mozigo bakadí wede ettiyo ti asigiryagi dupu ada sire geŋ, ki poone yʼa-koone yʼa wolle toogadí, aame yʼaane ɗeyyiso ti asigiryagi dupu koomat gen̰n̰o maŋ. ");
INSERT INTO moz_vpl VALUES ("LK14_32","072_14_32","LUK","14","32","32","Aame yi kʼaane ye maŋ, yi-tʼigibe ɗoŋ zina ki tukki mozigo bakadí ki poone yoŋ ɓotto dokki geŋ, yʼa ti yʼ tondo toose tʼa koone diinayaŋ.» ");
INSERT INTO moz_vpl VALUES ("LK14_33","072_14_33","LUK","14","33","33","Isa yʼa ruute sey, yʼede: «Geŋ iŋkino kay, i dehu wede tuuku ti diinaguŋ sulɗi ɗoŋ pay i-dʼedeʼŋ, yʼan ooli. Para maŋ yi kʼaane yi ki tʼise sanallusizó ye.» ");
INSERT INTO moz_vpl VALUES ("LK14_34","072_14_34","LUK","14","34","34","«Kane sumadeʼŋ munɗa wede beehiye, wo ɗe aame sumade uŋsuwadaŋ i tʼize umbo maŋ, kaŋ mummino kʼan ise uŋse sey me? ");
INSERT INTO moz_vpl VALUES ("LK14_35","072_14_35","LUK","14","35","35","Kane geŋ i kʼise beehiye ki ruumiyo siiɗo ye, ise ki guuru toŋ i kʼise ye, iŋkino kane geŋ ki sebbiyo mendaŋ a disse. Wede i-dʼede kuwwa kʼollige maŋ, yʼollo koɗuwo!» ");
INSERT INTO moz_vpl VALUES ("LK15_1","072_15_1","LUK","15","1","1","Ɗoŋ seɗɗu jibaaye ti ɗoŋ kʼolɗiko doolo, kane pay an aa dʼiide ki sirpa kʼIsa kono an di yʼolliga. ");
INSERT INTO moz_vpl VALUES ("LK15_2","072_15_2","LUK","15","2","2","Kane Pariziyeŋ ti ɗoŋ suuniyo kʼoogoro an dʼorbe sun̰n̰i sun̰n̰i a tukkʼIsa, anʼde: «Wede eŋ ɗoŋ kʼolɗiko yi diʼn seeɗu bey sire wo yi dʼomɓo ti kane.» ");
INSERT INTO moz_vpl VALUES ("LK15_3","072_15_3","LUK","15","3","3","Iŋkino maŋ Isa yʼan dʼiise tôwwo taaya tʼono ombiɗe en̰n̰o, yʼede: ");
INSERT INTO moz_vpl VALUES ("LK15_4","072_15_4","LUK","15","4","4","«Aame wede soo ti diinaguŋ i-dʼede damɓami meeda wo ere soo tʼa digge maŋ, ki kotto ɗoŋ ada gessat makumu gessat geŋ yi dʼooli adda balɗa, yʼa-kime dehutu ki ere i digge, bini yʼa ti tʼoono. ");
INSERT INTO moz_vpl VALUES ("LK15_5","072_15_5","LUK","15","5","5","Wo aame yi tʼuuno maŋ, yoŋ ulbí uŋse ɓaadaŋ, yʼa tʼamɓo a dannayí, ");
INSERT INTO moz_vpl VALUES ("LK15_6","072_15_6","LUK","15","6","6","yʼa tʼaahe ɓoy, saŋ yʼa waake laŋziyagí ti ɗoŋ kʼita waayadí, wo yʼan di roote, yʼa tʼeese: “Kun iso uŋsuwo ti nuuno, kono nuŋ damuzó wede i digge ni yʼuuno baa!” ");
INSERT INTO moz_vpl VALUES ("LK15_7","072_15_7","LUK","15","7","7","Kun ollo, nʼun di rooto, geŋ iŋkino kay aasa uŋsuwo ɓaadaŋ a kane ɗoŋ a kandaane, kono wede kʼolɗiko soo yi-gime ti lekkiyadí ere olɗo gette. Uŋsuwo ere a tukki wede soo gette, a ceera ere a tukki ɗoŋ ada gessat makumu gessat kane ki diine wo an ti gime lekkiyadaŋ gen̰n̰o.» ");
INSERT INTO moz_vpl VALUES ("LK15_8","072_15_8","LUK","15","8","8","«Wo kun ollo sey, i dʼede erewo soo iŋkino tammiyagutú koomat wo soo i di tʼiire maŋ, geŋ ki kotto todʼ tʼa moɗɗe pitilatú, binditú tʼa rooke, tʼa dehite boolo booloŋ bini tʼa ti tʼoone. ");
INSERT INTO moz_vpl VALUES ("LK15_9","072_15_9","LUK","15","9","9","Wo aame ti tʼuune maŋ, tʼa waake laŋziyagutú ti ɗoŋ kʼita waayatú, tʼan di roote, tʼa tʼeese: “Kun iso uŋsuwo ti nuuno, kono nuŋ tammadó ere i digge ni tʼuune baa.” ");
INSERT INTO moz_vpl VALUES ("LK15_10","072_15_10","LUK","15","10","10","Kun ollo, nʼun di rooto, geŋ iŋkino kay aasa uŋsuwo ɓaadaŋ a diine maaleekiyagi ɗoŋ ki Raa, kono ki wede kʼolɗiko soo yi ti kama ti lekkiyadí ere olɗo gette.» ");
INSERT INTO moz_vpl VALUES ("LK15_11","072_15_11","LUK","15","11","11","Isa yʼa ruute sey, yʼede: «I dʼede wede soo iŋkino in̰n̰izí kuuli sire. ");
INSERT INTO moz_vpl VALUES ("LK15_12","072_15_12","LUK","15","12","12","Onniyo soo, ulo wede n̰eŋku yi di ruute a meegí, yʼede: “Baaba, kee kʼo eli aggadó ere saŋ ni tʼoona tʼadda laalayá gen̰n̰o.” Iŋkino maŋ meegaŋ yʼan di diikiɗa laalayí a in̰n̰izí sire gen̰n̰o. ");
INSERT INTO moz_vpl VALUES ("LK15_13","072_15_13","LUK","15","13","13","Onniyo miibi kʼita maŋ, yo ulo wede n̰eŋku geŋ aggadí yʼa tʼiwilte pay wo yʼa ziiɗa soŋko, yʼa iŋgile ki siiɗo ere dokki. A ummey geŋ yi-tʼiide adda lekkiyo ere kʼarɓutu, iŋkino maaladí pay yʼa tʼirɓe. ");
INSERT INTO moz_vpl VALUES ("LK15_14","072_15_14","LUK","15","14","14","Aame maaladí pay yi ti ɗiŋge maŋ, i dʼize mosogo ɓaadaŋ adda siiɗo gette, wo yoŋ munɗa a beezí umbo. ");
INSERT INTO moz_vpl VALUES ("LK15_15","072_15_15","LUK","15","15","15","Aame geŋ yʼa tʼiide naabo di wede soo ki ɗoŋ siiɗo gettiyo, wo yo wede geŋ yʼa yʼigibe kʼadda doomizí elso kinzir. ");
INSERT INTO moz_vpl VALUES ("LK15_16","072_15_16","LUK","15","16","16","Ulo geŋ yʼa dihe yi dʼaaɗi in̰n̰i boriyo ɗoŋ an sebbiso a kinzir, wo wenɗa soo toŋ i di tʼele umbo. ");
INSERT INTO moz_vpl VALUES ("LK15_17","072_15_17","LUK","15","17","17","Iŋkino maŋ a lekkiyadí gette yi dʼelkiso adda kʼaddí, yʼede: “Ɗoŋ naabo meegó ɓaadaŋ, an dʼomɓo i diʼn palɗa! Wo nuŋ a en̰n̰o nʼunto ki mosogo! ");
INSERT INTO moz_vpl VALUES ("LK15_18","072_15_18","LUK","15","18","18","Nʼa-kima di meegó wo ni di rootey, nʼa tʼeesey: Baaba, ni tʼize olɗiko a Raa wo a kee. ");
INSERT INTO moz_vpl VALUES ("LK15_19","072_15_19","LUK","15","19","19","Ni kʼîide kʼa ki nʼ wolle aa ulá ye baa, iŋkino ki nʼiso aa wede soo ti diine ɗoŋ naabadá.” ");
INSERT INTO moz_vpl VALUES ("LK15_20","072_15_20","LUK","15","20","20","Maŋ yʼa tʼiiziga, yʼa-gime kʼume meegí. Aame ulo yo dokki booloŋ ti ɓoy geŋ, meegí yʼa yi wulle, wo i di tʼize sommagi ɓaadaŋ. Yʼa ukke okkimayí, yʼiideʼŋ yʼa yi ziiɗa yop. ");
INSERT INTO moz_vpl VALUES ("LK15_21","072_15_21","LUK","15","21","21","Iŋkino maŋ ulo yi di ruute, yʼede: “Baaba, ni tʼize olɗiko a Raa wo a kee. Ni ki tʼîide kʼa ki nʼ wolle aa ulá ye baa.” ");
INSERT INTO moz_vpl VALUES ("LK15_22","072_15_22","LUK","15","22","22","Wo meegí yʼan di ruute a ɗoŋ naabadí, yʼede: “Kesiko, kun amɓi kalle wede goole majjaane a jiire wo kun i-tʼosso a ulo me. Kun i tʼeelo kokkiɗe a ƴelsadí wo zoŋɗí kun i-tʼosso toɓiyagi. ");
INSERT INTO moz_vpl VALUES ("LK15_23","072_15_23","LUK","15","23","23","Kun sooɗi ulo buru wede ɓokkide, kun tʼôodo, in dʼooma wo in dʼisa tarnaape, ");
INSERT INTO moz_vpl VALUES ("LK15_24","072_15_24","LUK","15","24","24","kono ulo nuŋ kun wolliyo eŋ, yoŋ aa yʼinda wo aŋkeŋ aa yi bilɗe, yoŋ yi digge wo aŋkeŋ ni yʼuune.” Maŋ an dʼiise isiyo tarnaape. ");
INSERT INTO moz_vpl VALUES ("LK15_25","072_15_25","LUK","15","25","25","Aame geŋ ulo kaɓɓadí yoŋ a doome. A kamadí ti doome geŋ, aame yʼiina goppoŋ ki ɓoy maŋ, yʼollige tarkuuse kʼotoro ti ommire. ");
INSERT INTO moz_vpl VALUES ("LK15_26","072_15_26","LUK","15","26","26","Maŋ yi wiike wede soo ti diine ɗoŋ naabo, yʼa yi tunde, yʼede: “Ɗe ize moo me?” ");
INSERT INTO moz_vpl VALUES ("LK15_27","072_15_27","LUK","15","27","27","Wede naabo yi di ruute, yʼede: “Geŋ leemadá aaho me, wo meegá yi dʼîide ulo buru wede ɓokkide, kono ulí yi yʼuune yi lekkiyo bee.” ");
INSERT INTO moz_vpl VALUES ("LK15_28","072_15_28","LUK","15","28","28","Iŋkino maŋ ulo kaɓɓa yi di gulkuwe wo yi ki dehu kʼadda ɓoy yi kʼette ye. Meegí yʼa tʼuɗɗo yi di yʼ selliyo, yʼede: “Ulo ki nuŋ, ki tʼedi kʼadda ɓoy me.” ");
INSERT INTO moz_vpl VALUES ("LK15_29","072_15_29","LUK","15","29","29","Wo ulo yi diʼn gime ono meegí, yʼede: “Kʼollo kay baaba, nuŋ ozzinagi ɓaadaŋ nʼa naabiya me, wo ŋuƴƴur kaŋ soo toŋ ni kʼize ye a munɗa wede kʼo rootiyo me, wo a nuŋ gogguru soo ɗaŋŋal toŋ kʼo kʼeele ye, kono nʼa tʼise uŋsuwo ti laŋziyagó me. ");
INSERT INTO moz_vpl VALUES ("LK15_30","072_15_30","LUK","15","30","30","Wo a ulá wede en̰n̰o kotto maŋ, yode wede maaladá pay yʼa ti diggo yʼa tʼirɓo ti erayi, aame yʼiina maŋ a yode ki-dʼîide ulo buru wede ɓokkide!” ");
INSERT INTO moz_vpl VALUES ("LK15_31","072_15_31","LUK","15","31","31","Maŋ meegí yi di ruute, yʼede: “Ulo ki nuŋ, kee daayum ti nuŋ wo sulɗi pay ɗoŋ oo dʼede toŋ kane ki kee. ");
INSERT INTO moz_vpl VALUES ("LK15_32","072_15_32","LUK","15","32","32","Wo geŋ i dehu kine in dʼise tarnaape wo in dʼise uŋsuwo, kono leemadá eŋ yoŋ aa yʼinda wo aŋkeŋ aa yi bilɗe, yoŋ yi digge wo aŋkeŋ ni yʼuune.”» ");
INSERT INTO moz_vpl VALUES ("LK16_1","072_16_1","LUK","16","1","1","Saŋ Isa yʼan di ruute a sanalliyagí, yʼede: «I dʼede wede laale soo iŋkino, yoŋ i-dʼede wedusu yi di ƴeeriyo laalayí. Wede laale geŋ ɗuwo an i dʼiido ti rabila, kono wede ƴeeriyo yi-ti yʼ daggiya laalayí me. ");
INSERT INTO moz_vpl VALUES ("LK16_2","072_16_2","LUK","16","2","2","Maŋ wede laale yʼa wiike wede ƴeeriyo wo yi di ruute, yʼede: “Kee nʼilliga naabadá ere kʼisiyo te, kʼo tʼôodi taaya a urzi naabadá, kono ki ki ƴeera ye baa laalayó me.” ");
INSERT INTO moz_vpl VALUES ("LK16_3","072_16_3","LUK","16","3","3","Iŋkino maŋ wede ƴeeriyo yʼa ruute tʼadda kʼaddí, yʼede: “Nuŋ eŋ nʼaasa mummino, tʼume naabo ƴeeriyo galmeegó yi-tiʼn aɗɗiya geŋ me? Ki derku nuŋ toogadó umbo, wo kʼahultu a nuŋ sukiyagi. ");
INSERT INTO moz_vpl VALUES ("LK16_4","072_16_4","LUK","16","4","4","Geŋ ni suune munɗa wede nʼa isa me. Iŋkino aame tʼume naabo ƴeeriyo yi nʼuɗɗa maŋ, ɗoŋ ede an di nʼ seeɗa di kane me.” ");
INSERT INTO moz_vpl VALUES ("LK16_5","072_16_5","LUK","16","5","5","Iŋkino maŋ kane ɗoŋ i ziɗɗe seeyagi ki galmeegí, yʼa tiʼn wiiko soo soo. Yi di ruute a wede ki poone, yʼede: “Kee ginno seezá miibi ki-tʼela a galmeegó me?” ");
INSERT INTO moz_vpl VALUES ("LK16_6","072_16_6","LUK","16","6","6","Yoŋ yi diʼn gime onamí, yʼede: “Ɓoŋgali ada sire kʼegey kʼin̰n̰i kʼolibiye.” Wede ƴeeriyo yi di ruute, yʼede: “Mattup ki seezá ettiyo, kesiko ki koona ki raaŋa ɓoŋgali koomat.” ");
INSERT INTO moz_vpl VALUES ("LK16_7","072_16_7","LUK","16","7","7","Saŋ yi di ruute a wede doolo, yʼede: “Wo kee me, seezá miibi ki tʼela me?” Yoŋ yi diʼn gime onamí, yʼede: “Suwal meeda piɗe ki geme.” Wede ƴeeriyo yi di ruute, yʼede: “Mattup ki seezá ettiyo, ki raaŋa suwal meeda aɗo.” ");
INSERT INTO moz_vpl VALUES ("LK16_8","072_16_8","LUK","16","8","8","Wo yo galmeega yʼa yʼimme wede ƴeeriyo wede ki diine ye geŋ me, kono yʼizeʼŋ metiŋko. Iŋkino maŋ kane ɗoŋ duniya a urzi lekkiyo ere ti tuddaŋ gette, kane mentikagi an jiire kane ɗoŋ ki Raa toorayí a eedaŋ.» ");
INSERT INTO moz_vpl VALUES ("LK16_9","072_16_9","LUK","16","9","9","Isa yʼa ruute sey, yʼede: «Wo kun ollo, nuŋ nʼun di rooto, kun soɗɗo laŋziyagi ti laale wede kun ooniyo tʼurzi wede ki diine ye geŋ me. Iŋkino onniyo soo yo laale geŋ ti beyguŋ yi ɗikka maŋ, kane laŋziyagi an un diʼn seeɗey adda ɓoyɗi ɗoŋ ɗuwo an di lekkey ki daayum. ");
INSERT INTO moz_vpl VALUES ("LK16_10","072_16_10","LUK","16","10","10","Wede a naabo ere n̰eŋko booloŋ yi ti seeɗu zakiɗi geŋ, a naabo ere meeda toŋ ɗuwo an zaape addaŋ a yode kay. Wo wede a naabo ere n̰eŋko booloŋ yi ki ti seeɗu zakiɗi ye geŋ, a naabo ere meeda toŋ ɗuwo an ki zaape addaŋ a yode ye kay. ");
INSERT INTO moz_vpl VALUES ("LK16_11","072_16_11","LUK","16","11","11","Iŋkino maŋ, aame kune a laale wede kun ooniyo tʼurzi wede ki diine ye eŋ, kun ki yʼ ziiɗa zakiɗi ye maŋ, Raa toŋ yi kʼaane yʼun ki tʼele a beyguŋ ye laale wede ki kotto me. ");
INSERT INTO moz_vpl VALUES ("LK16_12","072_16_12","LUK","16","12","12","Wo aame a laale wede ki kune ye kun ki yʼ ziiɗa zakiɗi ye maŋ, Raa toŋ yʼun ki tʼeley ye laale wede ki kune me. ");
INSERT INTO moz_vpl VALUES ("LK16_13","072_16_13","LUK","16","13","13","Wede naabo soo toŋ umbo a aane a naabe ti galmaawi sire me, ise maŋ soŋ yʼa yʼolmiɗa wo yʼa-geyye soo me, wo ise maŋ yʼa di kette ti wede soo me wo soŋ yʼa yi kiigira. Kun kʼaane kun ki ti daane ye, urzi Raa wo urzi soŋko sirwaŋ pay me.» ");
INSERT INTO moz_vpl VALUES ("LK16_14","072_16_14","LUK","16","14","14","Aame kane Pariziyeŋ an illiga ono ɗoŋ pay Isa yi ruutite gen̰n̰o maŋ, an di yʼ koobiyto kono kane soŋko an ti geyyiso. ");
INSERT INTO moz_vpl VALUES ("LK16_15","072_16_15","LUK","16","15","15","Isa yʼan di ruute, yʼede: «Kune a ɗaana ɗuwo kun ti tʼisiyo tudduguŋ aa ɗoŋ ki diine, wo Raa adduguŋ yiʼni suune, kono munɗa wede ɗuwo an yi wolliyo goole geŋ, Raa yi yʼazzuru a ɗaanadí me. ");
INSERT INTO moz_vpl VALUES ("LK16_16","072_16_16","LUK","16","16","16","Ono ɗoŋ an riiŋe ti kaaga adda mattup kʼoogoro Muusa ti ɗoŋ ki nebiyagi geŋ, urzizaŋ a iide bini aaniya Zaŋ Batis. Tʼume geŋ an di kazita Rabila Majjaanawa ki Moziko Raa, wo wede tuuku toŋ yi dʼeliyo gotono kono yi-tʼette kʼadda. ");
INSERT INTO moz_vpl VALUES ("LK16_17","072_16_17","LUK","16","17","17","Wo kun ollo koɗuwo, oon̰e a kandaane ti siiɗo an tʼeŋgile me, wo oon̰e ɓaadaŋ sey a arku raaŋiya soo wede n̰eŋku a jiire kʼoogoro ette yʼa dagge me. ");
INSERT INTO moz_vpl VALUES ("LK16_18","072_16_18","LUK","16","18","18","Wede tuuku eddí yi ti biira wo yʼa ziiɗa erewo ti doolo maŋ, Raa yi yʼ wolliyo yoŋ wede i moone tʼere bakadí. Wo wede yi ziiɗa erewo ere kulatú yi ti-biire maŋ, Raa yi yʼ wolliyo yoŋ wede i moone tʼere bakadí.» ");
INSERT INTO moz_vpl VALUES ("LK16_19","072_16_19","LUK","16","19","19","Saŋ maŋ Isa yʼan dʼîide taaya, yʼede: «I dʼede wede laale soo iŋkino kallagi yʼossiyo ki ramica zooyatú oon̰e, daayum yi lekkiyo togos adda kʼuŋsuwo wo daayum yi dʼisiyo omɓo ɓaadaŋ aa ki tarnaape, ɗuwo an dʼomɓo. ");
INSERT INTO moz_vpl VALUES ("LK16_20","072_16_20","LUK","16","20","20","I dʼede wedusu i-kʼede munɗa ye sundí Lazar, tuddí kunɗayi risimik kaŋ moone a biza bumɓu ki wede laale gen̰n̰o. ");
INSERT INTO moz_vpl VALUES ("LK16_21","072_16_21","LUK","16","21","21","Yoŋ yʼa dihe yʼa oomi omɓo ere i solɗite tʼekki taabul ki wede laale gen̰n̰o toŋ umbo, wo ɗe kane gahiti toŋ an dʼettiyo an di dalɗutu kunɗayzí. ");
INSERT INTO moz_vpl VALUES ("LK16_22","072_16_22","LUK","16","22","22","Wede i-kʼede munɗa ye yʼinda maŋ, maaleekiyagi an tʼumɓe undí ki sirpa kʼIbirayim. Saŋ wede laale toŋ yʼa inda, an tʼittiba. ");
INSERT INTO moz_vpl VALUES ("LK16_23","072_16_23","LUK","16","23","23","Wo kaŋ unde yʼa tʼiide kʼadda diine ɗoŋ unto, wo a ume geŋ yi dabirsa ɓaadaŋ. Maŋ yʼa umɓe edayí kʼawwa, yʼa wulle ti dokki Ibirayim wo Lazar a sirpadí. ");
INSERT INTO moz_vpl VALUES ("LK16_24","072_16_24","LUK","16","24","24","Iŋkino yʼa iɗili, yʼede: “Ibirayim meeʼki nuŋ, kʼiso adde koɗuwo a nuŋ, kʼagibi Lazar yi dʼoŋko ahu a biza ƴilsadí, yʼo di zozza a bizó, ilzó a tʼorsa kono ni dabirsa ɓaadaŋ adda kʼuwwo ette.” ");
INSERT INTO moz_vpl VALUES ("LK16_25","072_16_25","LUK","16","25","25","Wo Ibirayim yi di ruute, yʼede: “Ulo ki nuŋ, ki suune aame kee adda duniya lekkiyadá ki tuuze tuuziyo, wo Lazar yʼuune dabar ɓaadaŋ. Wo aŋkeŋ Raa yi ti yʼ zille a en̰n̰o me, wo kee ki-tʼiide adda dabar baaɗi. ");
INSERT INTO moz_vpl VALUES ("LK16_26","072_16_26","LUK","16","26","26","Wo soŋ i dʼede olɗe sohuru wo goole aa bulɗume a diine kune ti kaye me. Iŋkino maŋ ɗoŋ i dehu ette tʼen̰n̰o kʼume kune, an kʼaane ye, wo ɗoŋ tʼume kune an dehu an dʼetto kʼume kaye, an kʼaane ye.” ");
INSERT INTO moz_vpl VALUES ("LK16_27","072_16_27","LUK","16","27","27","Wede laale yʼa ruute, yʼede: “Iŋkino maŋ meeʼki nuŋ, ki wollo sommagó kʼagiba Lazar ki ɓoy meegó, ");
INSERT INTO moz_vpl VALUES ("LK16_28","072_16_28","LUK","16","28","28","kono oo dʼede zemɓa paat, yʼa ette yʼan di tookey kuudaŋ, kono kane toŋ an ki dʼetto kʼume dabar en̰n̰o ye.” ");
INSERT INTO moz_vpl VALUES ("LK16_29","072_16_29","LUK","16","29","29","Ibirayim yi di ruute, yʼede: “Zemɓadá an dʼede mattup kʼoogoro Muusa ti ɗoŋ ki nebiyagi, onamaŋ anʼn olligey.” ");
INSERT INTO moz_vpl VALUES ("LK16_30","072_16_30","LUK","16","30","30","Wede laale yi di ruute, yʼede: “Geŋ i kʼîide ye Ibirayim meeʼki nuŋ, wo aame wede ti diine ɗoŋ unto yʼiida yʼan uuney maŋ, aame geŋ an di-kimey lekkiyadaŋ.” ");
INSERT INTO moz_vpl VALUES ("LK16_31","072_16_31","LUK","16","31","31","Wo Ibirayim yi di ruute, yʼede: “Aame mattup kʼoogoro Muusa ti ɗoŋ ki nebiyagi, onamaŋ an ki dihe an kʼolliga ye maŋ, ki kotto kane an kʼamɓe ye aame wede ti diine ɗoŋ unto yʼa balɗe yʼa ette toŋ maŋ.”» ");
INSERT INTO moz_vpl VALUES ("LK17_1","072_17_1","LUK","17","1","1","Isa yʼan di ruute a sanalliyagí, yʼede: «Ɗerec, kane sulɗi daayum ede ɗoŋ i-tʼeliyo ɗuwo adda kʼolɗiko me, wo ɗe dabar a yode wede i tʼeliyo bakadí adda kʼolɗiko. ");
INSERT INTO moz_vpl VALUES ("LK17_2","072_17_2","LUK","17","2","2","A wede iŋkino geŋ, dabar ere an i di kette assa meeda a golladí an ti yʼ seɗɗe adda bar gette, soodo sey ti ere yi tʼooney a ɗaana Raa te, aame yi tʼeliyo adda kʼolɗiko wede soo ti diine kane ɗoŋ tasse a urzi zaapu kʼadde a nuuno maŋ. ");
INSERT INTO moz_vpl VALUES ("LK17_3","072_17_3","LUK","17","3","3","Kun koona mentikagi! Aame leemadá yi tʼiza olɗiko a kee maŋ, kʼodo ki yʼoonoy, ki rootoy munɗa wede yʼa ize geŋ ti golla ere tasse, wo aame yi-kʼilligey olɗikadí yi ti zuuney yi-gimey lekkiyadí maŋ, kʼoyyo ki tʼiso tambobino te. ");
INSERT INTO moz_vpl VALUES ("LK17_4","072_17_4","LUK","17","4","4","Wo aame leemadá yi tʼiza olɗiko a kee wo saŋ yʼa iido ki tuddá, yʼa tʼeese: “Leema ki nuŋ, nuŋ olɗikadó ni ti zuune nʼa-kime lekkiyadó”, iŋkino iŋkino adda kʼon̰n̰u taŋ sarat toŋ maŋ, kʼoyyo ki tʼiso tambobino te.» ");
INSERT INTO moz_vpl VALUES ("LK17_5","072_17_5","LUK","17","5","5","Ɗoŋ zina Galmeega an i di ruute, anʼde: «Zaapu kʼaddey a kee baata, kʼayni noogi tʼa tʼihira.» ");
INSERT INTO moz_vpl VALUES ("LK17_6","072_17_6","LUK","17","6","6","Galmeega yʼa ruute, yʼede: «Ki kotto, aame kune zaapu kʼadduguŋ a nuŋ tʼaase n̰eŋko aa ulo kʼundumu sundí mutard toŋ maŋ, kun aane kun i di roote a undumu eŋ, kun tʼeese: “Tʼumayá eŋ ki-ɗeeto ki koonoy adda bar”, ki kotto yʼa olliga onamguŋ, yʼa-ɗeete.» ");
INSERT INTO moz_vpl VALUES ("LK17_7","072_17_7","LUK","17","7","7","«Kun ollo, aakede wede soo ti diinaguŋ i-dʼede wede naabo yi derku ise yʼelso mooɗe koo maŋ. Aame yi wulle wede naabo yʼaahiya ti doome maŋ, ki kotto yi-ki roote ye: “Kesiko kʼokki ki-koona omɓo me.” ");
INSERT INTO moz_vpl VALUES ("LK17_8","072_17_8","LUK","17","8","8","Ki too maŋ yi di roote, yʼa tʼeese: “Kʼo isi omɓo, wo kallagá kʼa booyo ki-tʼossi ɗoŋ ti doolo, omɓo kʼo dʼeli, kʼo dʼeeli soɓo koore ni tʼiima wo nʼaa tʼiiɓa maŋ. Saŋ a kaaɓadá kee kʼa ooma wo kʼa siɓa kollo.” ");
INSERT INTO moz_vpl VALUES ("LK17_9","072_17_9","LUK","17","9","9","Wede geŋ yi roota ɗey koɗuwo a wede naabadí, a naabo ere yi ruute yʼaase, yi tʼize gette? Aha, yi-ki roota ye koɗuwo me. ");
INSERT INTO moz_vpl VALUES ("LK17_10","072_17_10","LUK","17","10","10","Geŋ ki kune toŋ iŋkino: Aame naabaguŋ ere an un ruute kun ti tʼize pay maŋ, kun rooto kunʼde: “Kaye ɗoŋ naabo ay kʼede urzi ɗuwo an ay ki roote koɗuwo ye, ay ize munɗa wede an ay ruute ay dʼise ɗaŋŋal.”» ");
INSERT INTO moz_vpl VALUES ("LK17_11","072_17_11","LUK","17","11","11","Aame Isa yo a urzi yʼette ki Zeruzalem geŋ, yʼa uɗɗe ti diine siiɗo Samari kane ti Galile. ");
INSERT INTO moz_vpl VALUES ("LK17_12","072_17_12","LUK","17","12","12","A ettiyadí kʼadda kʼille soo iŋkino gette, ɗoŋ bitiɗe koomat an tʼiide an a di yʼ tʼikkimo. Kane an tʼîhirte ti dokki ");
INSERT INTO moz_vpl VALUES ("LK17_13","072_17_13","LUK","17","13","13","wo an dʼiise ɗollite, anʼde: «Isa, kee wede dooyisadey, kʼiso adde koɗuwo a kaye.» ");
INSERT INTO moz_vpl VALUES ("LK17_14","072_17_14","LUK","17","14","14","Isa yʼanni wulle wo yʼan di ruute, yʼede: «Kunʼdo, tudduguŋ kun an ti kazoy a ɗoŋ seɗeke.» Aame anʼte kʼume ɗoŋ seɗeke ɓotto geŋ, a urzi bitiɗayaŋ a n̰ukkiɗe an tʼize kamilen̰. ");
INSERT INTO moz_vpl VALUES ("LK17_15","072_17_15","LUK","17","15","15","Wede soo ti diinayaŋ yi wulle yʼuune bee maŋ, yʼa-gime kʼume kʼIsa, yi-tamma Raa ti golla awwa. ");
INSERT INTO moz_vpl VALUES ("LK17_16","072_17_16","LUK","17","16","16","Yʼiideʼŋ yʼa dikke a zoŋ kʼIsa, yʼa tʼuttile zumayí a siiɗo, wo yʼa ruute koɗuwo a Isa. Wo yo wede geŋ Samariten. ");
INSERT INTO moz_vpl VALUES ("LK17_17","072_17_17","LUK","17","17","17","Iŋkino Isa yʼa ruute, yʼede: «Kane koomat geŋ an ki tʼize kamilen̰ ye ko? Wo kane ɗoŋ gessat uune bee too me? ");
INSERT INTO moz_vpl VALUES ("LK17_18","072_17_18","LUK","17","18","18","Wenɗa a elke yʼa-kimo yʼa tʼimme Raa umbo daa ki torgusu en̰n̰o ye maŋ?» ");
INSERT INTO moz_vpl VALUES ("LK17_19","072_17_19","LUK","17","19","19","Maŋ Isa yi di ruute, yʼede: «Ki tʼoozo, kʼeŋgilo. Kono kee ki ziipe addá a nuŋ geŋ, kʼutte.» ");
INSERT INTO moz_vpl VALUES ("LK17_20","072_17_20","LUK","17","20","20","Onniyo soo kane Pariziyeŋ an di tunde Isa, anʼde: «Woogo Moziko Raa tʼaana me?» Yoŋ yʼan diʼn gime onamaŋ, yʼede: «Aaniya Moziko Raa, todʼte urzi wede aa munɗa kun gi di wolla tʼersaguŋ ye. ");
INSERT INTO moz_vpl VALUES ("LK17_21","072_17_21","LUK","17","21","21","Ɗuwo an ki roota ye: “Kun wollo todʼte a en̰n̰o!”, ise “Todʼte a ummey me!” Ɗerec kun suuno, Moziko Raa todʼte a diinaguŋ.» ");
INSERT INTO moz_vpl VALUES ("LK17_22","072_17_22","LUK","17","22","22","Iŋkino maŋ Isa yʼan di ruute a sanalliyagi, yʼede: «Saŋ onniyo tʼaana ere kun di deha kun ti nʼ wolle onniyo soo toŋ maŋ, nuŋ wede an nʼehe aa ulo wede eŋ me, wo umbo kun ki nʼ wolla ye. ");
INSERT INTO moz_vpl VALUES ("LK17_23","072_17_23","LUK","17","23","23","Aame geŋ ɗuwo an un di roota, an tʼeesa: “Kun wollo yoŋ a en̰n̰o!”, ise “Yoŋ a ummey!” Wo kune kunʼta ye, kun tʼokkita ye. ");
INSERT INTO moz_vpl VALUES ("LK17_24","072_17_24","LUK","17","24","24","Wo aa kun wolliyo mizzi yʼomile biɗiɗi i-ti tooriyo kandaane pay geŋ, onniyo ki nuŋ wede an nʼehe aa ulo wede en̰n̰o toŋ, tʼaasa iŋkino kay. ");
INSERT INTO moz_vpl VALUES ("LK17_25","072_17_25","LUK","17","25","25","Wo ɗe ki poone i dehu nʼa dabire ɓaadaŋ wo ɗoŋ aŋken̰n̰o eŋ an di nʼ kiigira. ");
INSERT INTO moz_vpl VALUES ("LK17_26","072_17_26","LUK","17","26","26","Munɗa wede ize ti kaaga a ozzinagi ɗoŋ ki Nowe geŋ, a onniytagi ɗoŋ ki nuŋ wede an nʼehe aa ulo wede en̰n̰o toŋ, aasa iŋkino kay. ");
INSERT INTO moz_vpl VALUES ("LK17_27","072_17_27","LUK","17","27","27","Ɗuwo an dʼomɓo, an soɓo, an seɗɗu ti tuddaŋ bini onniyo ere Nowe yi-tʼiide adda tooko ere meeda a jiire. Maŋ mizzi goole yʼa guppe, ahu an tʼiimi siiɗo, iŋkino ɗuwo geŋ pay an tʼinda adda kʼahu. ");
INSERT INTO moz_vpl VALUES ("LK17_28","072_17_28","LUK","17","28","28","Wo soŋ munɗa wede ize a ozzinagi Lot geŋ a aana iŋkino kay: ɗuwo geŋ an dʼomɓo, an soɓo, an dʼowilte, an tʼowilte, an dʼaatiya wo an dʼossige ɓoyɗi. ");
INSERT INTO moz_vpl VALUES ("LK17_29","072_17_29","LUK","17","29","29","Wo a onniyo ere Lot yi tʼuɗɗe ti geeger Sodom maŋ, Raa ti kandaane yʼa guppe ubali kʼuwwo ti moono ki suupire, an tʼîide ɗuwo pay. ");
INSERT INTO moz_vpl VALUES ("LK17_30","072_17_30","LUK","17","30","30","Geŋ aasa iŋkino kay a onniyo ere nuŋ wede an nʼehe aa ulo wede eŋ, ni kiza tuddó geŋ me. ");
INSERT INTO moz_vpl VALUES ("LK17_31","072_17_31","LUK","17","31","31","A onniyo gette, wede yʼa ti gili yi-guune tʼekki daŋgayadí wo sulɗizí yi iili adda maŋ, yi-ɗeego sokiyo ye, yi tʼombo. Iŋkino kay wede yoŋ adda doome maŋ, yi kima ki ɓoozí ye. ");
INSERT INTO moz_vpl VALUES ("LK17_32","072_17_32","LUK","17","32","32","Kun elko a taaya kʼere Lot. ");
INSERT INTO moz_vpl VALUES ("LK17_33","072_17_33","LUK","17","33","33","Wede yi diha boohiyo tuddí kʼaggadí maŋ, yʼa ti dagga, wo wede yʼiila tuddí kono nuuno maŋ, yʼa tʼutta. ");
INSERT INTO moz_vpl VALUES ("LK17_34","072_17_34","LUK","17","34","34","Kun ollo, nʼun di rooto, a diɗɗo gettiyo batum ɗoŋ sire an moone oŋgalzaŋ soo, wede soo an di yʼamɓa wo wede soŋ an di yʼoola. ");
INSERT INTO moz_vpl VALUES ("LK17_35","072_17_35","LUK","17","35","35","Erayi sire an massu kaŋ soo, ere soo an ti tʼamɓa wo ere soo an di tʼoola. ");
INSERT INTO moz_vpl VALUES ("LK17_36","072_17_36","LUK","17","36","36","Kuuli sire kane adda doome soo, wede soo an di yʼamɓa wo wede soŋ an di yʼoola.» ");
INSERT INTO moz_vpl VALUES ("LK17_37","072_17_37","LUK","17","37","37","Iŋkino maŋ kane sanalliyagi an di yʼ tunde, anʼde: «Galmeegey, a ume too me aasa me?» Wo yoŋ yʼan di ruute, yʼede: «A ume wede nuune yi tʼudiga geŋ, zumbi toŋ ti tʼogiya aŋgen̰n̰o.» ");
INSERT INTO moz_vpl VALUES ("LK18_1","072_18_1","LUK","18","1","1","Isa yi dehu yʼan di kize a sanalliyagi kono an di tonde Raa daayum an ki tʼorme ye. Iŋkino yʼan di rootiyo tʼurzi kʼono ombiɗe en̰n̰o, ");
INSERT INTO moz_vpl VALUES ("LK18_2","072_18_2","LUK","18","2","2","yʼede: «Adda geeger soo i dʼede wede ɗekkiyo booro, yoŋ yi kʼorgiso a Raa ye wo yi kʼottilso a wenɗa ye. ");
INSERT INTO moz_vpl VALUES ("LK18_3","072_18_3","LUK","18","3","3","Wo adda geeger gette i dʼede mandaayawa soo iŋkino, ti dʼettiyo daayum ki tukki yode geŋ me, ti dʼeesiyo: “Kee kʼay tʼisi booradey ti wede kʼolmiɗayó me.” ");
INSERT INTO moz_vpl VALUES ("LK18_4","072_18_4","LUK","18","4","4","Iŋkino aaze onniytagi ɓaadaŋ wede geŋ yi ki dehu yi-kʼise booratú ye. Wo saŋ yʼa ruute adda kʼaddí, yʼede: “Ɗerec, nuŋ a Raa ni-kʼorgiso ye, wo a wenɗa soo toŋ ni-kʼottilso ye. ");
INSERT INTO moz_vpl VALUES ("LK18_5","072_18_5","LUK","18","5","5","Wo to mandaayawa ette nuŋ ti ti nʼormiyo, iŋkino booratú ni di tʼise, para maŋ ti koɗɗime ɓaadaŋ tʼo ti kossa eedó.”» ");
INSERT INTO moz_vpl VALUES ("LK18_6","072_18_6","LUK","18","6","6","Saŋ Galmeega yʼa ruute sey, yʼede: «Kun ollo koɗuwo ono ki wede ɗekkiyo booro wede ki diine ye yi rootiyo. ");
INSERT INTO moz_vpl VALUES ("LK18_7","072_18_7","LUK","18","7","7","Wo yo Raa booro ki ɗoŋ yi biire, yi ki ti ɗekke ye ko aame kane an i môolo on̰n̰u wo diɗɗo maŋ? Ki noogiyadaŋ yʼa-tʼôsse ko? ");
INSERT INTO moz_vpl VALUES ("LK18_8","072_18_8","LUK","18","8","8","Kun ollo, nʼun di rooto, kesiko booradaŋ yʼan ti-ɗekke. Wo nuŋ wede an nʼehe aa ulo wede eŋ, aame ni-kimo geŋ, nʼiido ɗuwo ni-tʼoona ɗey ko ɗoŋ i ziipe addaŋ a nuŋ a siiɗo me?» ");
INSERT INTO moz_vpl VALUES ("LK18_9","072_18_9","LUK","18","9","9","I dʼede ɗuwo oŋgoŋ an elkiyo kane ɗoŋ ki diine a ɗaana Raa, wo an di koogire ɗoŋ oŋgoŋ pay. Iŋkino maŋ Isa yi rootiyo ono ombiɗe sey a tukki kane gen̰n̰o, yʼede: ");
INSERT INTO moz_vpl VALUES ("LK18_10","072_18_10","LUK","18","10","10","«I dʼede ɗoŋ sire iŋkino an tʼiide tondiyo Raa kʼadda booro Ɓoy Raa. Kane geŋ wede soŋ Pariziyeŋ, soŋ wede seɗɗu jibaaye. ");
INSERT INTO moz_vpl VALUES ("LK18_11","072_18_11","LUK","18","11","11","Yo Pariziyeŋ geŋ yʼa tʼîhira yi tondiyo Raa tʼadda kʼaddí, yʼede: “Eyye Raa ki nuŋ, nʼa di roote koɗuwo kono nuŋ aa ɗoŋ oŋgo ye, kane ɗoŋ kʼoogire, ɗoŋ ki diine ye, ɗoŋ i moonite tʼerayi ise ti kuuli kʼeebaŋ, wo soŋ nuŋ aa wede seɗɗu jibaaye en̰n̰o ye. ");
INSERT INTO moz_vpl VALUES ("LK18_12","072_18_12","LUK","18","12","12","Adda suuk ni lekkiyo onniyo sire daa kʼomɓo, ni dʼeliyo zakka a Raa ki sulɗizó ɗoŋ pay nʼooniyo me.” ");
INSERT INTO moz_vpl VALUES ("LK18_13","072_18_13","LUK","18","13","13","Yo wede seɗɗu jibaayeʼŋ yʼa tʼîhira dokki, edayí kʼawwa ki kandaane toŋ yi ki dehu yi kʼamɓe ye, wo yʼa-tʼiɓi beyɗí a giggirí, yʼa ruute, yʼede: “Eyye Raa ki nuŋ, ki wollo sommagi ki nuŋ wede kʼolɗiko en̰n̰o.”» ");
INSERT INTO moz_vpl VALUES ("LK18_14","072_18_14","LUK","18","14","14","Isa yʼa ruute sey, yʼede: «Kun ollo, nʼun di rooto, yo wede seɗɗu jibaayeʼŋ yʼa aahe ki ɓoozí, Raa yʼa yi wulle yoŋ ki diine, wo ki bakadí Raa yʼa yi wulle yoŋ ki diine ye. Ɗerec, wede tuuku tuddí yi ti-koliyo maŋ, Raa yʼa yʼisa n̰eŋku, wo ɗe wede tuddí yi ti-tʼisiyo n̰eŋko maŋ, Raa yʼa yʼisa goole.» ");
INSERT INTO moz_vpl VALUES ("LK18_15","072_18_15","LUK","18","15","15","Ɗuwo an di ziko in̰n̰i sun̰n̰i a Isa kono yʼan di zaape beezí a eedaŋ. Kane sanalliyagi an wulle iŋkino maŋ, an ki dehu ye, an diʼn eɗɗisito ɗuwo geŋ me. ");
INSERT INTO moz_vpl VALUES ("LK18_16","072_18_16","LUK","18","16","16","Wo ɗe Isa yʼa ele urzi kono in̰n̰i an i-dʼette sirpadí, wo yʼa ruute, yʼede: «Kun oolo in̰n̰i eŋ an dʼetto ki tuddó, kun tiʼn eegire ye, kono Moziko Raa todʼte ki ɗoŋ i deeƴiso aa kane kino. ");
INSERT INTO moz_vpl VALUES ("LK18_17","072_18_17","LUK","18","17","17","Ɗerec iŋkino wo nʼun di rooto: Wede tuuku Moziko Raa yi ki ti seeɗu aa yi seeɗu ulo n̰eŋku ye maŋ, yi ki tʼetta ye.» ");
INSERT INTO moz_vpl VALUES ("LK18_18","072_18_18","LUK","18","18","18","I dʼede wede iŋkino i-dʼede gooliko yʼa tunde Isa, yʼede: «Wede dooyisadey kee wede beehiye, nʼaase moo me kono nʼa tʼoona lekkiyo ere ki daayum te?» ");
INSERT INTO moz_vpl VALUES ("LK18_19","072_18_19","LUK","18","19","19","Isa yi di ruute, yʼede: «Ki moo me ki rootiyo nuŋ wede beehiye me? Beehiye Raa soo ɗaŋŋal, wenɗa ti doolo umbo. ");
INSERT INTO moz_vpl VALUES ("LK18_20","072_18_20","LUK","18","20","20","Kee urziyagi kʼoogoro kiʼni suune ɗoŋ anʼde: Ki moone tʼere bakadá ise ti kule bakatú ulu, ki tôwwo wedusu mirsi ulu, kʼoogire ulu, ki rootiyo kʼono butte a tukki bakadá a ɗaana booro ulu, wo ki elo suma a meegá ti meedá.» ");
INSERT INTO moz_vpl VALUES ("LK18_21","072_18_21","LUK","18","21","21","Wede geŋ yi diʼn gime onamí, yʼede: «Kane geŋ pay niʼni seeɗu tʼume nuŋ obulsu to.» ");
INSERT INTO moz_vpl VALUES ("LK18_22","072_18_22","LUK","18","22","22","Aame Isa yʼilliga iŋkino maŋ yi di ruute, yʼede: «Kee a ki biite munɗa soo sey: sulɗi ɗoŋ a-dʼedeʼŋ ki tʼowiltoy pay wo soŋko kʼan dʼeloy a ɗoŋ an kʼede munɗa ye, iŋkino kʼa tʼooney laale wede ki kotto a kandaane. Saŋ kʼa tʼedi wo kʼa ni daana.» ");
INSERT INTO moz_vpl VALUES ("LK18_23","072_18_23","LUK","18","23","23","Aame wede geŋ yʼilliga iŋkino maŋ, yʼa tʼize sommagi dondoŋ kono yoŋ laalayí ɓaadaŋ. ");
INSERT INTO moz_vpl VALUES ("LK18_24","072_18_24","LUK","18","24","24","Isa yi wulle wede geŋ yi tʼize sommagi dondoŋ maŋ, yʼa ruute, yʼede: «Ki kotto oon̰e ɓaadaŋ a ɗoŋ maala an tʼettey adda Moziko Raa te! ");
INSERT INTO moz_vpl VALUES ("LK18_25","072_18_25","LUK","18","25","25","Ɗerec kun suune, oon̰e a ziŋzo ti-tʼaɗɗe ti bulɗo rippile me, wo geŋ oon̰e ɓaadaŋ a ceere sey a wede laale yi-tʼettey a Moziko Raa te.» ");
INSERT INTO moz_vpl VALUES ("LK18_26","072_18_26","LUK","18","26","26","Kane ɗoŋ i yʼollige an di ruute, anʼde: «Iŋkino maŋ, geŋ a utta wee wee?» ");
INSERT INTO moz_vpl VALUES ("LK18_27","072_18_27","LUK","18","27","27","Yo Isa yʼan diʼn gime onamaŋ, yʼede: «Munɗa wede ɗuwo an kʼaane ye geŋ, a Raa i-kʼoon̰e ye, yʼaane.» ");
INSERT INTO moz_vpl VALUES ("LK18_28","072_18_28","LUK","18","28","28","Maŋ Piyer yʼa ruute, yʼede: «Aŋkeŋ kʼollo, kayeʼŋ sulɗizey pay ay dʼiilo wo ay di daaniya kee.» ");
INSERT INTO moz_vpl VALUES ("LK18_29","072_18_29","LUK","18","29","29","Isa yʼan di ruute, yʼede: «Ɗerec iŋkino wo nʼun di rooto: Wede tuuku yi iila ɓoozí, ise eddí, zemɓadí kuuli, maawí wo in̰n̰izí kono Moziko Raa maŋ, ");
INSERT INTO moz_vpl VALUES ("LK18_30","072_18_30","LUK","18","30","30","a lekkiyo ere aŋken̰n̰o ette kane geŋ yʼanni tʼoona ɓaadaŋ a ceera, wo saŋ maŋ adda duniya ere ki ɗaana yʼa tʼooney lekkiyo ere ki daayum.» ");
INSERT INTO moz_vpl VALUES ("LK18_31","072_18_31","LUK","18","31","31","Isa yʼa tiʼn wiike sanalliyagi kane koomat makumu sire ki sirpadí, wo yʼan di ruute, yʼede: «Kun ollo, in ti kili ki Zeruzalem wo a ummey sulɗi pay ɗoŋ nebiyagi an riiŋe a tukki nuŋ wede an nʼehe aa ulo wede eŋ, a-tʼettey baa. ");
INSERT INTO moz_vpl VALUES ("LK18_32","072_18_32","LUK","18","32","32","Iŋkino maŋ nuŋ ɗuwo an di nʼ tʼeley a bey ɗoŋ kane Yawudiyagi ye, an di nʼ tʼokkey maade, an di nʼ kilɗitey wo an piɗɗitey lee a tuddó. ");
INSERT INTO moz_vpl VALUES ("LK18_33","072_18_33","LUK","18","33","33","An di nʼ gorpipey ti marpa, saŋ an aa di nʼ tʼîdey, wo onniyo sire kʼaɗuwe maŋ, Raa yʼa ti nʼ balɗey.» ");
INSERT INTO moz_vpl VALUES ("LK18_34","072_18_34","LUK","18","34","34","Wo kane sanalliyagi munɗa soo toŋ an ki zuune ye, ita kʼono gette an tʼize ombiɗe, wo an ki zuune ye munɗa wede Isa yi rootiyo me. ");
INSERT INTO moz_vpl VALUES ("LK18_35","072_18_35","LUK","18","35","35","Onniyo soo Isa yʼiiney goppoŋ ki geeger Zeriko maŋ, i dʼede wedusu koosiyo yi guune a biza kʼurzi wo yi dʼahultu. ");
INSERT INTO moz_vpl VALUES ("LK18_36","072_18_36","LUK","18","36","36","Wede geŋ yʼilliga tarkuuse ki ɗoŋ duuru eŋgile gen̰n̰o maŋ, yʼanni tunde, yʼede: «Ɗe tarkuuse ki moo me?» ");
INSERT INTO moz_vpl VALUES ("LK18_37","072_18_37","LUK","18","37","37","Kane an i di ruute, anʼde: «Geŋ Isa wede ti geeger Nazaret eŋgile me.» ");
INSERT INTO moz_vpl VALUES ("LK18_38","072_18_38","LUK","18","38","38","Maŋ yʼa iise ɗolle, yʼede: «Isa kee Wede ti biza bumɓu Dawut, kʼiso adde koɗuwo a nuŋ!» ");
INSERT INTO moz_vpl VALUES ("LK18_39","072_18_39","LUK","18","39","39","Kane ɗoŋ i sooru ki ɗaana an di yʼeɗɗisito kono yʼa anniga, wo ɗe yoŋ yʼa ɗolle i ceeriyo ki ceeriyo, yi dʼeesiyo: «Kee Wede ti biza bumɓu Dawut, kʼiso adde koɗuwo a nuŋ, kʼiso adde koɗuwo a nuŋ!» ");
INSERT INTO moz_vpl VALUES ("LK18_40","072_18_40","LUK","18","40","40","Isa yʼa tʼîhira, wo yʼan di ruute, yʼede: «Wede geŋ kun oo ti yʼarkiɗi.» Wo aame an i-ti yʼirkiɗo maŋ, Isa yʼa yi tunde, yʼede: ");
INSERT INTO moz_vpl VALUES ("LK18_41","072_18_41","LUK","18","41","41","«Kee ki dehu nʼa-dʼise moo me?» Wede geŋ yi diʼn gime onamí, yʼede: «Galmeegey, ni dehu edayó a-tʼihina.» ");
INSERT INTO moz_vpl VALUES ("LK18_42","072_18_42","LUK","18","42","42","Maŋ Isa yi di ruute, yʼede: «Edayá a-tʼohon kʼa wollo! Kono kee ki ziipe addá a nuuno geŋ, kʼutte.» ");
INSERT INTO moz_vpl VALUES ("LK18_43","072_18_43","LUK","18","43","43","A kaamiki edayí a tʼihina, maŋ yʼa diine Isa, yi tamma Raa. Kane ɗoŋ duuru pay an wulle iŋkino maŋ, an tamma Raa kay. ");
INSERT INTO moz_vpl VALUES ("LK19_1","072_19_1","LUK","19","1","1","Isa yi tʼiide adda geeger Zeriko, wo yi-doopiɗa yʼeŋgile ki ɗaana. ");
INSERT INTO moz_vpl VALUES ("LK19_2","072_19_2","LUK","19","2","2","Maŋ a ume geŋ i dʼiido wedusu sundí Zaase, yoŋ goole ɗoŋ seɗɗu jibaaye wo yoŋ ki laale. ");
INSERT INTO moz_vpl VALUES ("LK19_3","072_19_3","LUK","19","3","3","Yi dehutu urzi yʼa ti yʼ wolle yo Isa miŋ wee wee, wo urzi yʼa ti yʼ wolle umbo kono ɗuwo ɓaadaŋ an i-tʼiigire, yoŋ kupili. ");
INSERT INTO moz_vpl VALUES ("LK19_4","072_19_4","LUK","19","4","4","Iŋkino maŋ yʼa ukke ki ɗaana, yʼiideʼŋ yʼa di gili ekkʼundumu aa moote, kono Isa yʼaɗɗa tiŋ gen̰n̰o, yʼa ti yʼ wolla. ");
INSERT INTO moz_vpl VALUES ("LK19_5","072_19_5","LUK","19","5","5","Aame Isa yʼiiney a ume kʼundumu gen̰n̰o maŋ, yʼa umɓe edayí kʼawwa wo yi di ruute, yʼede: «Zaase, kesiko ki-ɗeegi, aŋki eŋ i dehu nʼa-ɗeegey a di kee.» ");
INSERT INTO moz_vpl VALUES ("LK19_6","072_19_6","LUK","19","6","6","Kesiko tʼekkʼundumu Zaase yi-ti ɗiigo, an dʼaahe ɓoozí wo yʼa yi ziiɗa Isa tʼulbe uŋse. ");
INSERT INTO moz_vpl VALUES ("LK19_7","072_19_7","LUK","19","7","7","Aame ɗuwo an wulle iŋkino maŋ, kane pay an dʼorbite sun̰n̰i sun̰n̰i ti tuddaŋ, anʼde: «Kun wollo wede eŋ, yʼa ɗiige a di wede kʼolɗiko!» ");
INSERT INTO moz_vpl VALUES ("LK19_8","072_19_8","LUK","19","8","8","Wo Zaase yʼa dʼiide kʼume Galmeega, yi di ruute, yʼede: «Kee kʼollo Galmeeʼki nuŋ, laalayó nʼa-dookiɗa omagi sire, ume soo nʼan di-dokkiɗa ki waawiye a ɗoŋ an kʼede munɗa ye. Wo aame ni-tʼumɓe soŋko ki wenɗa daa kʼurzutú toŋ, ni-di tʼela tʼa aagila taŋ piɗe.» ");
INSERT INTO moz_vpl VALUES ("LK19_9","072_19_9","LUK","19","9","9","Iŋkino maŋ Isa yʼa ruute a tukki Zaase, yʼede: «Aŋki eŋ ɗoŋ ɓoy Zaase an uune uttiyo ere ki kotto, kono yode Zaase toŋ ti biza bumɓu kʼIbirayim. ");
INSERT INTO moz_vpl VALUES ("LK19_10","072_19_10","LUK","19","10","10","Ɗerec, nuŋ wede an nʼehe aa ulo wede eŋ, nʼiidoʼŋ dehutu ki ɗoŋ i digge adda kʼolɗikadaŋ wo nʼan tʼele uttiyo.» ");
INSERT INTO moz_vpl VALUES ("LK19_11","072_19_11","LUK","19","11","11","A kane ɗoŋ illiga ono geŋ, Isa yʼan di ruute ono ombiɗe sey kono yʼiina goppoŋ ti Zeruzalem, wo toŋ kane an elkiyo Moziko Raa tʼaana an di wolla a kaamiki gen̰n̰o. ");
INSERT INTO moz_vpl VALUES ("LK19_12","072_19_12","LUK","19","12","12","Iŋkino maŋ yʼa ruute, yʼede: «I dʼede wedusu iŋkino ti biza bumɓu wede goole, yʼa iŋgile ki siiɗo dokki omɓo moziko, saŋ yʼa-kimo. ");
INSERT INTO moz_vpl VALUES ("LK19_13","072_19_13","LUK","19","13","13","Ki poone yʼa eŋgile geŋ, yi wiike ɗoŋ koomat ti diine ɗoŋ naabadí, wo yʼan dʼeele a wede soŋ tamma soo soo ki dap ere zooyatú oon̰e, wo yʼan di ruute, yʼede: “Kun di naabo eego, tʼaa dʼaagal bini kamadó.” ");
INSERT INTO moz_vpl VALUES ("LK19_14","072_19_14","LUK","19","14","14","Wo kane ɗoŋ siiɗadí an yʼolmiɗe, iŋkino an dʼigibe ɗuwo kʼitadí kono an di rootey, an tʼeesey: “Kaye wede eŋ ay ki dehu yʼa kʼise mozigayey ye.” ");
INSERT INTO moz_vpl VALUES ("LK19_15","072_19_15","LUK","19","15","15","Wo aame wede geŋ yi tʼiimo moziko yi-gimo maŋ, yʼanni wiike kane ɗoŋ naabadí ɗoŋ yʼan dikki soŋko gette, kono yʼa-wolle naabadaŋ an aa uune tʼeego moo me. ");
INSERT INTO moz_vpl VALUES ("LK19_16","072_19_16","LUK","19","16","16","Wede ki poone yʼa iina wo yʼa ruute, yʼede: “Galmeeʼki nuŋ, ti tamma ere kʼo ele gette, nʼaa dʼuune a îide tamma koomat ki dap.” ");
INSERT INTO moz_vpl VALUES ("LK19_17","072_19_17","LUK","19","17","17","Mozigo yi di ruute, yʼede: “Geŋ koɗuwo kee wede naabo beehiye, kee a naabo ere booloŋ gettiŋ kʼa ti ziiɗa zakiɗi, aŋkeŋ nʼa-ki ti zaapo wede goole tʼekki geegiryagi koomat.” ");
INSERT INTO moz_vpl VALUES ("LK19_18","072_19_18","LUK","19","18","18","Wede ki sirwe yʼa iina wo yʼa ruute, yʼede: “Galmeeʼki nuŋ, ti tamma ere kʼo ele gette, nʼaa dʼuune a îide tamma paat ki dap.” ");
INSERT INTO moz_vpl VALUES ("LK19_19","072_19_19","LUK","19","19","19","A yode gen̰n̰o toŋ mozigo yi di ruute, yʼede: “Kee nʼa-ki ti zaapo wede goole tʼekki geegiryagi paat.” ");
INSERT INTO moz_vpl VALUES ("LK19_20","072_19_20","LUK","19","20","20","Wede ti doolo yʼa iina, yʼa ruute, yʼede: “Galmeeʼki nuŋ, ettiyo tammadá ki dap te, nuŋ nʼa-gitte a buuɗe, nʼa ziipe a teɗɗise. ");
INSERT INTO moz_vpl VALUES ("LK19_21","072_19_21","LUK","19","21","21","Nʼa orgiso kono kee wehini a naabo me, ki-tʼamɓu munɗa wede i ki ziipe kee ye, wo ki dʼayɗu a ume wede ki ki giira ye toŋ maŋ.” ");
INSERT INTO moz_vpl VALUES ("LK19_22","072_19_22","LUK","19","22","22","Maŋ mozigo yi di ruute, yʼede: “Kee wede naabo ulsu, nʼa ɗekke booro a eedá ti ono ɗoŋ uɗɗe ti bizá geŋ me. Ki suune nuŋ wehini a naabo me, munɗa wede i ki ziipe nuuno ye toŋ ni-tʼamɓu, wo ni dʼayɗu a ume wede ni ki giira ye maŋ. ");
INSERT INTO moz_vpl VALUES ("LK19_23","072_19_23","LUK","19","23","23","Iŋkino ki moo me soŋkadó kʼo gi di ziipe adda baŋki ye me, tʼo dʼaagila, a kamadó geŋ nʼiido nʼa-tʼamɓe ti jugulu.” ");
INSERT INTO moz_vpl VALUES ("LK19_24","072_19_24","LUK","19","24","24","Maŋ yʼan di ruute a kane ɗoŋ a sirpadí geŋ, yʼede: “Tammadí ki dap te kun ti sooɗo, kun i elo a wede i-dʼede tamma koomat.” ");
INSERT INTO moz_vpl VALUES ("LK19_25","072_19_25","LUK","19","25","25","Maŋ kane an di ruute, anʼde: “Galmeegey, yoŋ i-dʼede baa tamma ki dap koomat te.” ");
INSERT INTO moz_vpl VALUES ("LK19_26","072_19_26","LUK","19","26","26","Yoŋ yʼa ruute, yʼede: “Kun ollo, nʼun di rooto, a wede i-dʼede geŋ, an i-tʼeela tʼeego, wo ɗe a wede i-kʼede ye geŋ, munɗazí wede booloŋ yʼelkiyo yi tʼoona toŋ an i-tʼamɓa. ");
INSERT INTO moz_vpl VALUES ("LK19_27","072_19_27","LUK","19","27","27","Wo ɗoŋ kane adu ti nuŋ, an ki dihe nʼa kʼise mozigayaŋ ye geŋ, kun tiʼn waaki ken̰n̰o kun tiʼn tʼîda a ɗaanadó.”» ");
INSERT INTO moz_vpl VALUES ("LK19_28","072_19_28","LUK","19","28","28","Aame Isa yʼa ti ruute iŋkino maŋ, yʼan tʼuugume a ɗoŋ duuru kono yʼa-kili ki Zeruzalem. ");
INSERT INTO moz_vpl VALUES ("LK19_29","072_19_29","LUK","19","29","29","Isa yʼiiney goppoŋ tʼilliyagi sundaŋ Betpaze wo Betani, a sirpa mokkolo ere an ti waaku mokkolo kʼInda kʼOlibiye. A ume geŋ yi dʼigibe ɗoŋ sire ti diine sanalliyagí, ");
INSERT INTO moz_vpl VALUES ("LK19_30","072_19_30","LUK","19","30","30","wo yʼan di ruute, yʼede: «Kunʼdo kʼadda kʼille ere a ɗaanaguŋ gettiyo. Kun iiney, aame geŋ kun tʼooney ulo buuru kettiyo, wenɗa kaŋ soo toŋ yi ki gili ye. Kun tʼeezi, kun o-tʼarkiɗi. ");
INSERT INTO moz_vpl VALUES ("LK19_31","072_19_31","LUK","19","31","31","Wo aame wenɗa yʼunni tundey, yʼiisey: “Kun ti yʼeeziyo moo me?” maŋ, kun dʼeesoy: “Buuru eŋ i dehu Galmeega.”» ");
INSERT INTO moz_vpl VALUES ("LK19_32","072_19_32","LUK","19","32","32","Kane ɗoŋ yʼan agisaʼŋ an dʼiŋgile, an iideʼŋ an diʼn uuney sulɗiʼŋ pay aa Isa yʼan ruute. ");
INSERT INTO moz_vpl VALUES ("LK19_33","072_19_33","LUK","19","33","33","Aame an iise eeziyo kʼulo buuru maŋ, kane ɗoŋzí an di ruute, anʼde: «Ɗe kun tʼeeziyo ulo buuru eŋ ki moo me?» ");
INSERT INTO moz_vpl VALUES ("LK19_34","072_19_34","LUK","19","34","34","Kane an an diʼn gime onamaŋ, anʼde: «Buuru eŋ i dehu Galmeega.» ");
INSERT INTO moz_vpl VALUES ("LK19_35","072_19_35","LUK","19","35","35","Maŋ ulo buuru an i-dʼiide a Isa, an a-ti gikkite kallagaŋ ɗoŋ deero a dar kʼulo buuru wo Isa an a-ti yʼ gili eego. ");
INSERT INTO moz_vpl VALUES ("LK19_36","072_19_36","LUK","19","36","36","A urzi yʼettiyo geŋ, ɗuwo an di gikkite kallagaŋ ɗoŋ deero, yi sooru eego. ");
INSERT INTO moz_vpl VALUES ("LK19_37","072_19_37","LUK","19","37","37","Aame yʼiina goppoŋ ti Zeruzalem a ume ɗeegu ti mokkolo kʼInda kʼOlibiye maŋ, kane sanalliyagi ɓaadaŋ geŋ pay ulbaŋ a ûune tʼuŋsuwo, an dʼiise tamma Raa ti golla awwa a sulɗi kʼarmika ɗoŋ pay an wullite geŋ me. ");
INSERT INTO moz_vpl VALUES ("LK19_38","072_19_38","LUK","19","38","38","Kane an dʼeesiyo: «Beeko Raa ti koona a ekki mozigo wede ettiyo ti suma Galmeega Raa! Toose tʼa koone a kandaane wo tamma a Raa tʼawwa a kandaane!» ");
INSERT INTO moz_vpl VALUES ("LK19_39","072_19_39","LUK","19","39","39","I dʼede Pariziyeŋ miibi ti diine ɗoŋ duuru, an i-di ruute a Isa, anʼde: «Wede dooyisadey, sanalliyagá kiʼn eɗɗiso, an dʼanniga!» ");
INSERT INTO moz_vpl VALUES ("LK19_40","072_19_40","LUK","19","40","40","Wo Isa yʼan tiʼn gime onamaŋ, yʼede: «Kun ollo, nʼun di rooto, aame kane an inniga maŋ, moŋgali toŋ an di ɗillita!» ");
INSERT INTO moz_vpl VALUES ("LK19_41","072_19_41","LUK","19","41","41","Aame Isa yʼa tʼette ki geeger Zeruzalem wo yi ti wulle maŋ, yʼa iise môolo kono tode, ");
INSERT INTO moz_vpl VALUES ("LK19_42","072_19_42","LUK","19","42","42","yʼede: «Wayya, wayya! Kune ɗoŋ ki Zeruzalem, nuŋ ni dihe ɓaadaŋ kune batum, onniyo gette aŋki urzi wede kun di tʼoone toose kun yi zuune maŋ! Wo ɗe umbo, aŋken̰n̰o edaguŋ Raa yʼun tʼippe, urzi toose kun ki yʼ wolle ye baa. ");
INSERT INTO moz_vpl VALUES ("LK19_43","072_19_43","LUK","19","43","43","Iŋkino saŋ onniytagi an aana egguŋ, aame geŋ ɗoŋ kʼaduguŋ an kilita siiɗo a-ɗoola geeger gette pay ki ɗeyyisaguŋ, an un tiʼn gootika tʼume tuuku toŋ maŋ. ");
INSERT INTO moz_vpl VALUES ("LK19_44","072_19_44","LUK","19","44","44","Kane an un tiʼn damɓa kame kamec ti ɓoyɗuguŋ pay, mokkolo soo toŋ tʼekki bakatú an kʼoola ye, kono kune onniyo ere Raa yʼiido tudduguŋ, kun ki dihe kun ki di yʼ suune ye.» ");
INSERT INTO moz_vpl VALUES ("LK19_45","072_19_45","LUK","19","45","45","Saŋ Isa yi-tʼiide a booro Ɓoy Raa, wo yʼa iise lommite ɗoŋ isiyo suuk. ");
INSERT INTO moz_vpl VALUES ("LK19_46","072_19_46","LUK","19","46","46","Yʼan di ruute, yʼede: «Kun ollo, ono eŋ an riiŋe ti kaaga adda mattup ki Raa, anʼde: “Ɓoozó eŋ yʼa koona ɓoy wede ki tondiyo Raa.” Wo ɗe kune, kun di yʼize urmi kʼombiɗe ɗoŋ kʼoogire!» ");
INSERT INTO moz_vpl VALUES ("LK19_47","072_19_47","LUK","19","47","47","Isa geŋ onniyo ti onniyo yi dooyiso ɗuwo a booro Ɓoy Raa. Kane deero ɗoŋ seɗeke ti ɗoŋ suuniyo kʼoogoro wo ti ɗoŋ deero Yawudiyagi geŋ, an dehutu urzi ki tôwwadí, ");
INSERT INTO moz_vpl VALUES ("LK19_48","072_19_48","LUK","19","48","48","wo ɗe urzi an ki yʼooniyo ye, kono kane ɗoŋ pay an ollige ɓaadaŋ dooyisadí gette. ");
INSERT INTO moz_vpl VALUES ("LK20_1","072_20_1","LUK","20","1","1","Onniyo soo Isa yi dooyiso ɗuwo wo yʼan kazita Rabila Majjaanawa a booro Ɓoy Raa. Maŋ kane deero ɗoŋ seɗeke, ɗoŋ suuniyo kʼoogoro ti ɗoŋ i dokkiyo Yawudiyagi, an dʼiido tuddí ");
INSERT INTO moz_vpl VALUES ("LK20_2","072_20_2","LUK","20","2","2","wo an i di ruute, anʼde: «Kee kʼay ki ti rooti ɗoo, kʼisiyto sulɗi eŋ tʼurzi kʼaaye? Wo urzi eŋ a ele wee wee?» ");
INSERT INTO moz_vpl VALUES ("LK20_3","072_20_3","LUK","20","3","3","Isa yʼan diʼn gime onamaŋ, yʼede: «Nuŋ toŋ nʼun diʼn tondo a munɗa soo. Onamó kun o tiʼn kami: ");
INSERT INTO moz_vpl VALUES ("LK20_4","072_20_4","LUK","20","4","4","Aame Zaŋ ɗuwo yʼanni zuyye batem geŋ, urzi iido ti Raa kunuŋ ti ɗuwo ko?» ");
INSERT INTO moz_vpl VALUES ("LK20_5","072_20_5","LUK","20","5","5","Maŋ an dʼiise rootiyto ti tuddaŋ, anʼde: «Aame kine in ruuta: “Iidoʼŋ tʼurzi Raa” maŋ, yoŋ yʼa roota: “Iŋkino ki moo me kun ki dʼumɓe a ono Zaŋ ye me?” ");
INSERT INTO moz_vpl VALUES ("LK20_6","072_20_6","LUK","20","6","6","Wo aame kine in ruuta: “Iidoʼŋ tʼurzi ɗuwo” maŋ, ɗoŋ duuru pay an in tiʼn kakkita ti moŋgali ki tôwwadiŋ, kono kane an zuune adda kʼaddaŋ Zaŋ yoŋ nebi.» ");
INSERT INTO moz_vpl VALUES ("LK20_7","072_20_7","LUK","20","7","7","Iŋkino maŋ Isa onamí an i-tiʼn gime, anʼde: «Ay ki suune ye wenɗa i ele urzi me.» ");
INSERT INTO moz_vpl VALUES ("LK20_8","072_20_8","LUK","20","8","8","Maŋ Isa yʼan di ruute, yʼede: «Nuŋ toŋ maŋ nʼun ki yʼ roote ye kay, wede o ele urzi ni dʼisiyto sulɗi eŋ me.» ");
INSERT INTO moz_vpl VALUES ("LK20_9","072_20_9","LUK","20","9","9","Saŋ maŋ Isa yʼa iise rootiyo a ɗoŋ duuru tʼono ombiɗe en̰n̰o, yʼede: «I dʼede wedusu iŋkino yi dʼiite doome kʼinda sundaŋ bin̰, maŋ doome geŋ yʼan dʼele ɗuwo an di naabe saŋ yoŋ aggadí yʼa tʼamɓa. Wo yoŋ tuddí yʼa iŋgile torguwo, yʼa ki kimo kesiko ye. ");
INSERT INTO moz_vpl VALUES ("LK20_10","072_20_10","LUK","20","10","10","Aame onniyo rakku tʼiina maŋ, yʼa igibe wede naabadí soo ki tukki ɗoŋ naabo doome gen̰n̰o, kono an i di tʼelo aggadí ere kʼin̰n̰i bin̰ an rikke te. Aame yʼiiney maŋ, kane ɗoŋ naabo doomeʼŋ wede naabadí an di yʼ ziiɗa, an di yʼ gusse, an aa di yʼigibe beezí guguba. ");
INSERT INTO moz_vpl VALUES ("LK20_11","072_20_11","LUK","20","11","11","Wede doomeʼŋ yi dʼigibe wede naabadí ti doolo, wo yode gen̰n̰o toŋ an di yʼ ziiɗa, an di yʼ gusse, an a-ti yʼ gilɗite, an aa di yʼigibe beezí guguba. ");
INSERT INTO moz_vpl VALUES ("LK20_12","072_20_12","LUK","20","12","12","Wo yi dʼigibe wede naabadí kʼaɗuwe sey, yode gen̰n̰o toŋ an i-tʼeelite kunɗayi, wo tʼadda doome an aa di yʼilmi. ");
INSERT INTO moz_vpl VALUES ("LK20_13","072_20_13","LUK","20","13","13","Iŋkino maŋ wede doome kʼinda bin̰ yʼa ruute tʼadda kʼaddí, yʼede: “Ɗe nʼaase mummino me? Nʼa tʼigiba ulo ki geyyisadó, a yode geŋ koo an i ottiley maŋ.” ");
INSERT INTO moz_vpl VALUES ("LK20_14","072_20_14","LUK","20","14","14","Wo ɗe aame kane ɗoŋ naabo doomeʼŋ ulo an yi wulle maŋ, an dʼiise rootiyto ti tuddaŋ, anʼde: “En̰n̰o ulo wede doome i oopa me! In yʼôodo kono doome eŋ in dʼoopa a kine.” ");
INSERT INTO moz_vpl VALUES ("LK20_15","072_20_15","LUK","20","15","15","Maŋ ulo geŋ an di yʼ ziiɗa, tʼadda doome an di yʼirkiɗe ki toogo ki paate, wo an di yʼîide.» Maŋ Isa yʼa ruute, yʼede: «Wo aŋkeŋ wede doome kʼinda bin̰ yʼan dʼisa mummino? ");
INSERT INTO moz_vpl VALUES ("LK20_16","072_20_16","LUK","20","16","16","Yoŋ yʼa etto, ɗoŋ naabo doome geŋ yʼa tiʼn tʼîda wo doome kʼinda bin̰ yʼan tʼela a ɗoŋ naabo doolo, saŋ aggadí yʼa tʼamɓa.» Aame kane ɗuwo an illiga ono gen̰n̰o maŋ, an di ruute, anʼde: «Aha, iŋkino geŋ i kʼisa ye!» ");
INSERT INTO moz_vpl VALUES ("LK20_17","072_20_17","LUK","20","17","17","Wo Isa yi diʼn wolliso adda kʼedayaŋ wo yʼan di ruute, yʼede: «I-kaza moo me ono ɗoŋ an riiŋe ti kaaga adda mattup ki Raa, anʼde: “Mokkolo ere ɗoŋ kʼoozige ɓoy an di ziɗɗe mentú gette, tode gettiyo a tʼize mokkolo ere majjaanawa a jiire kʼoozige ɓoy” te? ");
INSERT INTO moz_vpl VALUES ("LK20_18","072_20_18","LUK","20","18","18","Wede tuuku yʼa tʼiira ekki mokkolo gettiyo maŋ, yʼa-damɓa, wo aame mokkolo gette ti-di tʼiira a wenɗa maŋ, tʼa ti yʼ n̰oguma.» ");
INSERT INTO moz_vpl VALUES ("LK20_19","072_20_19","LUK","20","19","19","Kane deero ɗoŋ seɗeke ti ɗoŋ suuniyo kʼoogoro, an di zuune keren̰ Isa yi rootiyo ono ombiɗe geŋ ti kane me. Iŋkino maŋ an di dihe an di yʼ seeɗa aame gen̰n̰o batum, wo ɗe an dʼurgiɗe a ɗoŋ duuru. ");
INSERT INTO moz_vpl VALUES ("LK20_20","072_20_20","LUK","20","20","20","Maŋ kane geŋ Isa an di yʼiise gerɗiyo. Wo an i dʼigibe ɗuwo an ti tʼize tuddaŋ aa ɗoŋ ki diine, kane an dehu an di yʼ seeɗey tʼurzi tondiso, kono aame yi ti ruuta butte maŋ, an tʼoona urzi an i-di yʼ tʼela a bey goole siiɗo. ");
INSERT INTO moz_vpl VALUES ("LK20_21","072_20_21","LUK","20","21","21","Kane an di yʼ tunde, anʼde: «Wede dooyisadey, ay suune ono ɗoŋ ki rootiyto wo ti dooyisadá kane a urzizaŋ, kiʼni wolliyo ɗuwo pay kaŋ soo wo ki dooyiso urzi Raa tʼono ɗoŋ ɗerec. ");
INSERT INTO moz_vpl VALUES ("LK20_22","072_20_22","LUK","20","22","22","Aŋkeŋ, a urzi kʼoogiradiŋ miŋ jibaaye a mozigo goole ki Romeŋ geŋ kʼeliyo kunuŋ, kʼeliyo ye ko?» ");
INSERT INTO moz_vpl VALUES ("LK20_23","072_20_23","LUK","20","23","23","Wo Isa metiŋkadaŋ yʼa ti zuune, wo yʼan di ruute, yʼede: ");
INSERT INTO moz_vpl VALUES ("LK20_24","072_20_24","LUK","20","24","24","«Kun o kʼeeli tamma soo nʼa ki wolle ɗo. Undiso ti suma ekki tamma ette kʼaaye?» Kane an i diʼn gime onamí, anʼde: «Ki mozigo goole ki Romeŋ.» ");
INSERT INTO moz_vpl VALUES ("LK20_25","072_20_25","LUK","20","25","25","Maŋ Isa yʼan di ruute, yʼede: «Iŋkino maŋ munɗa wede ki mozigo goole ki Romeŋ yoŋ ki yode kun i yʼelo, wo munɗa wede ki Raa yoŋ ki yode kun i yʼelo.» ");
INSERT INTO moz_vpl VALUES ("LK20_26","072_20_26","LUK","20","26","26","A onamí ɗoŋ yi rootiyto a ɗaana ɗuwo geŋ, an ki dʼiine seeɗuzí ye, wo a ono ɗoŋ yʼanni gime geŋ kane an ziiɗa giggiraŋ wo an dʼinniga ɗeɗɗek. ");
INSERT INTO moz_vpl VALUES ("LK20_27","072_20_27","LUK","20","27","27","Ɗoŋ miibi ti diine ɗoŋ anʼni waaku sundaŋ Saduseyeŋ, an dʼiide sirpa kʼIsa. Kun suune kane Saduseyeŋ an rootiyo ɗoŋ i tʼinda an ki ti balɗa ye. Iŋkino Isa an di yʼ tunde, anʼde: ");
INSERT INTO moz_vpl VALUES ("LK20_28","072_20_28","LUK","20","28","28","«Wede dooyisadey, Muusa yi riiŋe ti kaaga adda mattup kʼoogoro munɗa wede in dʼise me, yʼede: “Aame wede yi ziiɗa erewo wo yʼa inda daa magin̰e maŋ, mandaayawa gette leemadí yʼa ti seeɗa kono an tʼehe in̰n̰i a suma ki wede inda gen̰n̰o.” ");
INSERT INTO moz_vpl VALUES ("LK20_29","072_20_29","LUK","20","29","29","Iŋkino aakede i dʼede zemɓa kane sarat. Wede ki poone yʼa ziiɗa erewo wo yʼa inda daa magin̰e. ");
INSERT INTO moz_vpl VALUES ("LK20_30","072_20_30","LUK","20","30","30","Wede ki sirwe yʼa ti ziiɗa wo yʼa inda daa magin̰e, ");
INSERT INTO moz_vpl VALUES ("LK20_31","072_20_31","LUK","20","31","31","saŋ wede kʼaɗuwe toŋ iŋkino. Kane sarat geŋ an di duude pay, wo an tʼinda wenɗa soo toŋ yi kʼuune magin̰e ye. ");
INSERT INTO moz_vpl VALUES ("LK20_32","072_20_32","LUK","20","32","32","Kʼita maŋ tode toŋ tʼaa dʼinda kay. ");
INSERT INTO moz_vpl VALUES ("LK20_33","072_20_33","LUK","20","33","33","Iŋkino maŋ a onniyo ere ɗoŋ i tʼinda an ti balɗa geŋ, ti diine kane zemɓa geŋ erewo gette tʼaasa kʼaaye, kono kane sarat pay geŋ miŋ kulutú me?» ");
INSERT INTO moz_vpl VALUES ("LK20_34","072_20_34","LUK","20","34","34","Isa yʼan di ruute, yʼede: «Kuuli ti erayi an seɗɗu tuddaŋ adda duniya ettiyo. ");
INSERT INTO moz_vpl VALUES ("LK20_35","072_20_35","LUK","20","35","35","Wo ɗe ki kane ɗoŋ Raa yiʼni wulle an îide ki balɗiya ti diine ɗoŋ unto wo an di lekka a duniya ere ki ɗaana gette, kane kuuli ti erayi an ki seɗɗa tuddaŋ ye baa. ");
INSERT INTO moz_vpl VALUES ("LK20_36","072_20_36","LUK","20","36","36","Kane geŋ an ki tʼinda ye baa, kono an tʼize aa maaleekiyagi. Kane in̰n̰i Raa, kono ti unto an ti bilɗe. ");
INSERT INTO moz_vpl VALUES ("LK20_37","072_20_37","LUK","20","37","37","Wo a urzi balɗiya ki ɗoŋ i tʼinda geŋ, Muusa yi ruute keren̰ adda taaya ki beyga kʼundumu oggiyo uwwo ɗala ɗala gette, aame geŋ yʼa yi wiike Galmeega Raa, “Raa kʼIbirayim, kʼIsaaka wo ki Yakup.”» ");
INSERT INTO moz_vpl VALUES ("LK20_38","072_20_38","LUK","20","38","38","Isa yʼa ruute sey, yʼede: «Raa geŋ yoŋ Raa ki ɗoŋ unto ye, yoŋ Raa ki ɗoŋ zeere, kono a yode kane pay geŋ zeere.» ");
INSERT INTO moz_vpl VALUES ("LK20_39","072_20_39","LUK","20","39","39","Ɗoŋ suuniyo kʼoogoro miibi ti diinayaŋ an i-di ruute, anʼde: «Wede dooyisadey, onamá ki ruute geŋ a urzizaŋ.» ");
INSERT INTO moz_vpl VALUES ("LK20_40","072_20_40","LUK","20","40","40","An rootiyo iŋkino kono an urgiɗe, an di yʼ tondite ti doolo sey me. ");
INSERT INTO moz_vpl VALUES ("LK20_41","072_20_41","LUK","20","41","41","Isa yʼan di ruute, yʼede: «Mummino me ɗuwo an di rootiyo Almasi Raa yi biire, yʼaɗɗo ti biza bumɓu Dawut me? ");
INSERT INTO moz_vpl VALUES ("LK20_42","072_20_42","LUK","20","42","42","Wo yode Dawut batum yʼa ruute ti kaaga adda mattup ki Soom, yʼede: “Galmeega Raa yi di ruute a Galmeegó, yʼede: Kʼedi ki-koona a ammidadó kino, ");
INSERT INTO moz_vpl VALUES ("LK20_43","072_20_43","LUK","20","43","43","bini ɗoŋ kʼaduzá nʼan isa aa munɗa ki bita ti ɗanɗi zoŋɗá.” ");
INSERT INTO moz_vpl VALUES ("LK20_44","072_20_44","LUK","20","44","44","Iŋkino maŋ Dawut yi yi waaku Almasi “Galmeega.” Ɗe geŋ mummino Almasi yʼa aɗɗo ti biza bumɓu Dawut ɗaŋŋal me?» ");
INSERT INTO moz_vpl VALUES ("LK20_45","072_20_45","LUK","20","45","45","Isa yʼan di ruute a sanalliyagí a ɗaana ɗoŋ pay i yʼollige, yʼede: ");
INSERT INTO moz_vpl VALUES ("LK20_46","072_20_46","LUK","20","46","46","«Kun koona mentikagi ti ɗoŋ suuniyo kʼoogoro! Kane an geyyiso sooru ti kallagi deero a arga boy, wo a bere ɗoŋ duuru an geyyiso ɗuwo an an diʼn tʼeesite ti ottilso. Adda ɓoyɗi ɗoŋ in di dooyiso, an geyyiso an koone a ume wede suma, wo adda tarnaapagi a ume kʼomɓo toŋ, an geyyiso an koone a ume wede suma pây. ");
INSERT INTO moz_vpl VALUES ("LK20_47","072_20_47","LUK","20","47","47","Kane geŋ bey mandayɗayi an tʼomɓo pay, wo soŋ an eesiyo tondiyo Raa maŋ ki noko nokot kono ɗuwo an diʼn wolle. Kane geŋ booradaŋ tʼa kooney wehini a ceerey.» ");
INSERT INTO moz_vpl VALUES ("LK21_1","072_21_1","LUK","21","1","1","Saŋ Isa yʼa umɓe edayí, maŋ yi wolliyo ɗoŋ laale an eliyo soŋkiyagaŋ a Raa, a ume wede an dʼeliyo soŋko a booro Ɓoy Raa. ");
INSERT INTO moz_vpl VALUES ("LK21_2","072_21_2","LUK","21","2","2","Wo yi wulle soŋ mandaayawa i-kʼede munɗa ye, todʼ tʼele soŋko sun̰n̰i sun̰n̰i sire. ");
INSERT INTO moz_vpl VALUES ("LK21_3","072_21_3","LUK","21","3","3","Maŋ Isa yʼa ruute, yʼede: «Ɗerec iŋkino wo nʼun di rooto: Mandaayawa i-kʼede munɗa ye ette, todʼ tʼele a jiire ki kane ɗoŋ oŋgo pay. ");
INSERT INTO moz_vpl VALUES ("LK21_4","072_21_4","LUK","21","4","4","Ɗerec, kane ɗoŋ laale pay geŋ an ele tʼadda soŋko ere an uupe oopiyo, wo ɗe todʼte kʼumbatúʼŋ tʼa dʼele pay soŋko ere ii guute ki lekkiyatú te.» ");
INSERT INTO moz_vpl VALUES ("LK21_5","072_21_5","LUK","21","5","5","I dʼede ɗoŋ miibi an di rootiyo a tukki Ɓoy Raa, anʼde: «Yo ɓoy eŋ, moŋgalí ti oozigayí wo ti sulɗi ɗoŋ ɗuwo an i ele a Raa, kane pay majjanɗani.» Wo Isa yʼa ruute, yʼede: ");
INSERT INTO moz_vpl VALUES ("LK21_6","072_21_6","LUK","21","6","6","«Ɓoy kun yi wolliyo eŋ, saŋ onniytagi an dʼaana mokkolo soo toŋ tʼekki bakatú i ki lekka ye, pay a ruuga.» ");
INSERT INTO moz_vpl VALUES ("LK21_7","072_21_7","LUK","21","7","7","Iŋkino maŋ kane an di yʼ tunde, anʼde: «Wede dooyisadey, ɗe sulɗi geŋ an aana woogo me? Wo moo me munɗa wede a kiza onniyo kino sulɗi geŋ an aana me?» ");
INSERT INTO moz_vpl VALUES ("LK21_8","072_21_8","LUK","21","8","8","Isa yʼan diʼn gime onamaŋ, yʼede: «Kun koona mentikagi, kun oola tudduguŋ a ɗuwo an un tiʼn dagga ye. Ɗerec, i dʼetto ɗoŋ ɓaadaŋ an tʼamɓo sundó, wede tuuku toŋ yʼa tʼeesa: “Nuŋ Almasi Raa yi biire!”, wo soŋ “Peeɗo tʼîide!” Kane geŋ kunʼni daana ye. ");
INSERT INTO moz_vpl VALUES ("LK21_9","072_21_9","LUK","21","9","9","Kun dʼolliga tarkuuse ki arka goppoŋ, wo kun dʼolliga rabila kʼoozige ɗeyyiso dokki. Aame geŋ kun addira ye. I dehu sulɗi geŋ an dʼaane ɗoo, wo aame geŋ a ki tʼisa kaamiki ɗaŋgiya duniya ye ɓotto.» ");
INSERT INTO moz_vpl VALUES ("LK21_10","072_21_10","LUK","21","10","10","Saŋ yʼan di ruute, yʼede: «Ɗoŋ siiɗo soo ti siiɗo soo te an ɗeyya ti tuddaŋ, ɗoŋ mozigo soo ti mozigo soo me an ɗeyya ti tuddaŋ kay. ");
INSERT INTO moz_vpl VALUES ("LK21_11","072_21_11","LUK","21","11","11","I dʼisa ŋoŋŋirsito siiɗo ti toogo, wo adda siiɗiyagi ɓaadaŋ toŋ i dʼisa mosogo wo enɗani ɗettiso, soŋ i dʼisa a kandaane sulɗi ɗoŋ kʼa addira, wo sulɗi ɗoŋ kʼa seeɗa giggirá i-kaza munɗa etto. ");
INSERT INTO moz_vpl VALUES ("LK21_12","072_21_12","LUK","21","12","12","Wo ɗe ki poone sulɗi ɗoŋ pay eŋ an dʼaana geŋ, kune an un diʼn seɗɗa wo an un diʼn dabira. An un diʼn tʼetta kʼume ɗoŋ booro adda ɓoyɗi ɗoŋ in di dooyiso, an un tiʼn tʼela adda daŋgay, wo an un diʼn tʼetta ɗaana mozagi wo ɗaana ɗoŋ deero siiɗo kono kun umɓe a sundó. ");
INSERT INTO moz_vpl VALUES ("LK21_13","072_21_13","LUK","21","13","13","Geŋ un tʼisa a kune urzi wede kun di roota a sulɗi ɗoŋ kun wulle wo kun illiga a tukki nuuno. ");
INSERT INTO moz_vpl VALUES ("LK21_14","072_21_14","LUK","21","14","14","Kun zaapo adduguŋ a ono ni roota eŋ me: A munɗa wede kun dʼooɗiba egguŋ geŋ, kun okkima tudduguŋ ki poone ye. ");
INSERT INTO moz_vpl VALUES ("LK21_15","072_21_15","LUK","21","15","15","Aame geŋ nuŋ batum un tʼeley ono a ceerey kun diʼn rootey ti suuniyo kʼono ere ɗoŋ kʼaduguŋ an kʼaane an un ki tiʼn kiɗɗita ye, an ki rootey ono eŋ butte ye. ");
INSERT INTO moz_vpl VALUES ("LK21_16","072_21_16","LUK","21","16","16","Kune maawuguŋ, zemɓaguŋ, taasiyaguŋ wo laŋziyaguŋ geŋ, kane batum unni tʼela bey ɗoŋ deero, wo an tiʼn tʼîda ɗoŋ ɓaadaŋ ti diinaguŋ me. ");
INSERT INTO moz_vpl VALUES ("LK21_17","072_21_17","LUK","21","17","17","Kune ɗoŋ duniya pay an un diʼn olmiɗa kono kun umɓe a sundó, ");
INSERT INTO moz_vpl VALUES ("LK21_18","072_21_18","LUK","21","18","18","wo ililso kʼegguŋ soo toŋ i ki dagga ye. ");
INSERT INTO moz_vpl VALUES ("LK21_19","072_21_19","LUK","21","19","19","Kun sooɗo zakiɗi bini ɗaŋgu, iŋkino tʼurzi geŋ kun tʼoona lekkiyo ere ki daayum.» ");
INSERT INTO moz_vpl VALUES ("LK21_20","072_21_20","LUK","21","20","20","«Aame kun wulla geeger ki Zeruzalem asigiryagi an di ti ɗuula maŋ, kun suuno aame geŋ onniyatú tʼîide, todʼte an di damɓa kame kamec. ");
INSERT INTO moz_vpl VALUES ("LK21_21","072_21_21","LUK","21","21","21","Iŋkino maŋ kane ɗoŋ adda siiɗo Ziide an tʼombo kʼekki moŋgali, kane ɗoŋ adda geeger Zeruzalem an tʼaɗɗo, wo kane ɗoŋ a domɓi i-ɗuule geeger gette an etta ye kʼadda geeger te. ");
INSERT INTO moz_vpl VALUES ("LK21_22","072_21_22","LUK","21","22","22","Ɗerec, onniytagi geŋ an koona ki booro Raa, aame geŋ a aana kono a-tʼetta a ono ɗoŋ pay an riiŋe ti kaaga adda mattup ki Raa. ");
INSERT INTO moz_vpl VALUES ("LK21_23","072_21_23","LUK","21","23","23","A onniytagi geŋ aasa dabar ɓaadaŋ a kane erayi ɗoŋ mahuwagi ti ɗoŋ in̰n̰izaŋ an ooɗiyo! Ɗerec, adda siiɗo gette aasa dabar ɓaadaŋ, wo kulkuwo Raa tʼa ɗeega a tukki ɗoŋ siiɗo gettiyo. ");
INSERT INTO moz_vpl VALUES ("LK21_24","072_21_24","LUK","21","24","24","Ɗoŋ oŋgo an tiʼn tʼîda ti kasigara, ɗoŋ oŋgo an tiʼn seɗɗa ɓulagi ki siiɗiyagi pay adda duniya, wo kane ɗoŋ Yawudiyagi ye, Zeruzalem an dʼonƴilsa zoŋɗaŋ bini ɗaŋgu kʼonniytagi ɗoŋ Raa yʼan ɗikke.» ");
INSERT INTO moz_vpl VALUES ("LK21_25","072_21_25","LUK","21","25","25","«Kun ollo, ekki peeɗo, ekki tere wo ekki molɗali toŋ, i dʼisa sulɗi ɗoŋ a kiza munɗa. Adda siiɗiyagi pay ɗuwo an dʼaddira, an di-tʼela elkiso ɓaadaŋ a tarkuuse wede ki bar wo ti wede ki ahu i kolzite geŋ me. ");
INSERT INTO moz_vpl VALUES ("LK21_26","072_21_26","LUK","21","26","26","Ɗuwo an di-tʼinda kʼorgiso ti elkiso a munɗa wede aana adda siiɗo pay, kono sulɗi ɗoŋ an dʼede toogo a kandaane, Raa yʼa tiʼn gozziga. ");
INSERT INTO moz_vpl VALUES ("LK21_27","072_21_27","LUK","21","27","27","Iŋkino maŋ an di nʼ wolla nuŋ wede an nʼehe aa ulo wede eŋ, nʼa aana ekki dondirso ti toogo ere pay wo ti darƴika ere o dʼede. ");
INSERT INTO moz_vpl VALUES ("LK21_28","072_21_28","LUK","21","28","28","Aame sulɗi geŋ an iisa ettiyto maŋ, kun tʼôhor kaŋ ôhire, kun tʼamɓo egguŋ awwa, kono aɗɗiyaguŋ goppoŋ.» ");
INSERT INTO moz_vpl VALUES ("LK21_29","072_21_29","LUK","21","29","29","Saŋ Isa yʼan di ruute ono ombiɗe en̰n̰o, yʼede: «Kun wollo tormo wo ti inda ɗoŋ oŋgo pay. ");
INSERT INTO moz_vpl VALUES ("LK21_30","072_21_30","LUK","21","30","30","Aame kun wolliyo inda geŋ puutagizaŋ eesiyo rooɓiyo maŋ, kune batum kun suune adda kʼadduguŋ kizini yoŋ goppoŋ. ");
INSERT INTO moz_vpl VALUES ("LK21_31","072_21_31","LUK","21","31","31","Geŋ iŋkino kay, kun wulla sulɗi geŋ an iina maŋ, kun suuno Moziko Raa todʼte goppoŋ. ");
INSERT INTO moz_vpl VALUES ("LK21_32","072_21_32","LUK","21","32","32","Ɗerec iŋkino wo nʼun di rooto: Ɗoŋ aŋken̰n̰o eŋ an ki ti tʼinda pay ye, ki poone sulɗi pay geŋ an dʼaana me. ");
INSERT INTO moz_vpl VALUES ("LK21_33","072_21_33","LUK","21","33","33","Kandaane kane ti siiɗo an tʼeŋgila, wo kane onamó an ki tʼeŋgila ye, an di lekka ki daayum.» ");
INSERT INTO moz_vpl VALUES ("LK21_34","072_21_34","LUK","21","34","34","«Kun koona mentikagi, peeɗaguŋ kun ti tʼeŋgile a isiyto tarnaapagi, ti soɓito wo a elkisito sulɗi ɗoŋ ki lekkiyo duniya ye. Para maŋ onniyo ere Raa yi ɗekka booro tʼaana aame kun ki ti delliyo ye. ");
INSERT INTO moz_vpl VALUES ("LK21_35","072_21_35","LUK","21","35","35","Todʼ tʼetto aakede lebiɗo, kono tʼa di tʼippa a tukki ɗoŋ adda duniya geŋ pay. ");
INSERT INTO moz_vpl VALUES ("LK21_36","072_21_36","LUK","21","36","36","Kun lekko zeere, kun tondo Raa daa puukiyo. Iŋkino kun tʼoona toogo kono kun tʼalɗa ti sulɗi ɗoŋ pay aana kʼita, wo aame nuŋ wede an nʼehe aa ulo wede eŋ nʼiina maŋ, nʼun diʼn tʼoona kune kaŋ ôhire a ɗaanadó me.» ");
INSERT INTO moz_vpl VALUES ("LK21_37","072_21_37","LUK","21","37","37","Isa geŋ a on̰n̰u yi-tʼettiyo dooyiso ɗuwo kʼadda booro Ɓoy Raa, wo a diɗɗo maŋ yi-tʼettiyo yi dʼonniyo ekki mokkolo ere an ti waaku mokkolo kʼInda kʼOlibiye. ");
INSERT INTO moz_vpl VALUES ("LK21_38","072_21_38","LUK","21","38","38","Ti soohe walak maŋ, kane ɗoŋ duuru an tʼettiyo an di yʼooniyo a booro Ɓoy Raa kono an di yʼolliga. ");
INSERT INTO moz_vpl VALUES ("LK22_1","072_22_1","LUK","22","1","1","Tarnaape wede an dʼomɓo mappa daa kʼorme, an yi waaku Pak ki Yawudiyagi geŋ, a guute goppoŋ. ");
INSERT INTO moz_vpl VALUES ("LK22_2","072_22_2","LUK","22","2","2","Aame geŋ kane deero ɗoŋ seɗeke ti ɗoŋ suuniyo kʼoogoro an dehutu urzi ki tôwwo kʼIsa, wo an dʼorgiso a ɗoŋ duuru me. ");
INSERT INTO moz_vpl VALUES ("LK22_3","072_22_3","LUK","22","3","3","Iŋkino Meeda siitanɗani ti-tʼiide eedí Ziidas wede an yi waaku sundí soo Iskariyot, yoŋ wede ti diine sanalliyagi kane koomat makumu sire geŋ me. ");
INSERT INTO moz_vpl VALUES ("LK22_4","072_22_4","LUK","22","4","4","Yoŋ yʼa iide an di ruuto ti deero ɗoŋ seɗeke wo ti deero ɗoŋ boohiyo Ɓoy Raa, a urzi wede mummino yʼan di yʼ tʼela Isa a beezaŋ me. ");
INSERT INTO moz_vpl VALUES ("LK22_5","072_22_5","LUK","22","5","5","Kane ulbaŋ a tʼize uŋse ɓaadaŋ wo an i di ruute an i-tʼeela soŋko. ");
INSERT INTO moz_vpl VALUES ("LK22_6","072_22_6","LUK","22","6","6","Aame geŋ Ziidas yʼa iyye, maŋ yʼa iise dehutu kʼurzi wede kaŋ mummino yʼan di yʼ tʼela Isa a beezaŋ wo kane ɗoŋ duuru an ki suuna ye me. ");
INSERT INTO moz_vpl VALUES ("LK22_7","072_22_7","LUK","22","7","7","Adda tarnaape ki Yawudiyagi wede an dʼomɓo mappa daa kʼorme geŋ, onniyo tʼa iina ere an di walɗutu in̰n̰i damɓami an dʼisiyo omɓo ere ki Pak ki Yawudiyagi te. ");
INSERT INTO moz_vpl VALUES ("LK22_8","072_22_8","LUK","22","8","8","Iŋkino maŋ Isa yʼa igibe Piyer kane ti Zaŋ, wo yʼan di ruute, yʼede: «Kunʼdo kun in isoy omɓo tarnaapayiŋ ki Pak kono in dʼooma.» ");
INSERT INTO moz_vpl VALUES ("LK22_9","072_22_9","LUK","22","9","9","Maŋ kane an di yʼ tunde, anʼde: «Ɗe a too me kee ki dehu ay in dʼisey omɓe te?» ");
INSERT INTO moz_vpl VALUES ("LK22_10","072_22_10","LUK","22","10","10","Yoŋ yʼan diʼn gime onamaŋ, yʼede: «Kun ollo, aame kun aa tʼettey kʼadda geeger, kun tʼikkimey ti wedusu yi tʼeezo ahu ti diŋgile, kun di yʼ daanoy bini adda ɓoy wede yʼa tʼettey. ");
INSERT INTO moz_vpl VALUES ("LK22_11","072_22_11","LUK","22","11","11","Wo kun tʼiidey maŋ, a wede ɓoy kun i di rootoy, kun dʼeesoy: “Wede dooyisadey yi ki tondiyo, too te biino ere yʼa ooma omɓo tarnaapayiŋ ki Pak ti sanalliyagí me?” ");
INSERT INTO moz_vpl VALUES ("LK22_12","072_22_12","LUK","22","12","12","Wo yoŋ biino yʼun di kizey todʼte dildil tʼawwa tʼekki bakatú, sulɗi pay adda okkime. Geŋ a ume gen̰n̰o kun dʼisoy omɓo te.» ");
INSERT INTO moz_vpl VALUES ("LK22_13","072_22_13","LUK","22","13","13","Maŋ kane an dʼiŋgile, an iideʼŋ sulɗi an diʼn uuney pay aakede Isa yʼan ruute, iŋkino omɓo tarnaape ki Pak an tʼize. ");
INSERT INTO moz_vpl VALUES ("LK22_14","072_22_14","LUK","22","14","14","Aame peeɗo tʼîide maŋ, Isa yʼa-guune omɓo ti ɗoŋ zindí ");
INSERT INTO moz_vpl VALUES ("LK22_15","072_22_15","LUK","22","15","15","wo yʼan di ruute, yʼede: «Nuŋ ti kaagine ni dihe tʼaddó pay omɓo tarnaapayiŋ ki Pak ette nʼa oomi ti kune, ki poone nʼa dabira geŋ me. ");
INSERT INTO moz_vpl VALUES ("LK22_16","072_22_16","LUK","22","16","16","Geŋ kun ollo, nʼun di rooto, omɓo ette ni kʼooma ye baa, bini urzutú a-tʼetta keren̰ a aaniya Moziko Raa.» ");
INSERT INTO moz_vpl VALUES ("LK22_17","072_22_17","LUK","22","17","17","Iŋkino maŋ yʼa tʼumɓe kop, yʼa ruute koɗuwo a Raa, maŋ yʼede: «Kun sooɗo kop eŋ, kun di dokko wede soŋ yi goomo goomo. ");
INSERT INTO moz_vpl VALUES ("LK22_18","072_22_18","LUK","22","18","18","Geŋ kun ollo, nʼun di rooto, nʼa tʼiiɓe ti aŋki, ki ɗaana ni ki siɓa ye baa toote kʼin̰n̰i bin̰ me, bini aaniya Moziko Raa.» ");
INSERT INTO moz_vpl VALUES ("LK22_19","072_22_19","LUK","22","19","19","Saŋ yʼa tʼumɓe mappa, yʼa ruute koɗuwo a Raa kono kʼomɓo gette, maŋ yʼa ɓurke, yʼan dʼele sanalliyagí wo yʼa ruute, yʼede: «Ette tuddó ere ni tʼela kono kune, kun dʼiso iŋkino kono kun dʼelka a nuuno.» ");
INSERT INTO moz_vpl VALUES ("LK22_20","072_22_20","LUK","22","20","20","Aame an tʼiimi maŋ, ki kop toŋ iŋkino, yʼa tʼumɓe yʼan dʼele wo yʼa ruute, yʼede: «Kop ti soɓo adda ette, todʼte taasuwa ere aware Raa yi ketta ti ɗuwo tʼurzi puuzadó, to tʼoɓa kono kune. ");
INSERT INTO moz_vpl VALUES ("LK22_21","072_22_21","LUK","22","21","21","Wo kun ollo, wede yi ni tʼela bey ɗoŋ kʼolmiɗayó, yoŋ a en̰n̰o, yʼomɓo ti nuŋ kaŋ soo. ");
INSERT INTO moz_vpl VALUES ("LK22_22","072_22_22","LUK","22","22","22","Ɗerec, nuŋ wede an nʼehe aa ulo wede eŋ nʼa tʼinda, geŋ a-tʼetta a munɗa wede aa Raa yi dehu, wo ɗe dabar a wede yi ni tʼela bey ɗoŋ kʼolmiɗayó.» ");
INSERT INTO moz_vpl VALUES ("LK22_23","072_22_23","LUK","22","23","23","Iŋkino maŋ an dʼiise tondiso ti tuddaŋ, anʼde: «Ɗe geŋ ti diinayiŋ wee wee aasa munɗa iŋkino me?» ");
INSERT INTO moz_vpl VALUES ("LK22_24","072_22_24","LUK","22","24","24","Saŋ maŋ kane sanalliyagi an dʼiise niikiyto ɓaadaŋ ti tuddaŋ kono an dehu an di suune, ti diinayaŋ miŋ wee wee goole a jiire me. ");
INSERT INTO moz_vpl VALUES ("LK22_25","072_22_25","LUK","22","25","25","Maŋ Isa yʼan di ruute, yʼede: «Kane mozagi siiɗiyagi pay an dʼomɓo tʼekki ɗoŋzaŋ ti toogo, wo kane ɗoŋ an dʼede urzi ki dokkiyo ekki ɗoŋzaŋ, an dehu ɗuwo an diʼn waake “Ɗoŋ kʼisiyo beehiyko.” ");
INSERT INTO moz_vpl VALUES ("LK22_26","072_22_26","LUK","22","26","26","Wo ki kune iŋkino ye. Ki too maŋ wede goole a jiire ti diinaguŋ yʼa tʼise aa wede n̰eŋku a jiire, wo wede yi dokkiyo ɗuwo yʼa tʼise aa wede naabo a ɗuwo. ");
INSERT INTO moz_vpl VALUES ("LK22_27","072_22_27","LUK","22","27","27","Wo a elkiyaguŋ maŋ, wede goole a jiire wee wee, wede i-guune omɓo kunuŋ, wede i naabiya a yode gen̰n̰o ko? Kun suune, goole wede i-guune omɓo. Wo kun wollo, aŋken̰n̰o nuŋ a diinaguŋ eŋ aa wede i naabiya a kune. ");
INSERT INTO moz_vpl VALUES ("LK22_28","072_22_28","LUK","22","28","28","Kune kun ziiɗa daayum zakiɗi a ita nuŋ adda sulɗi ɗoŋ oon̰e o iido me. ");
INSERT INTO moz_vpl VALUES ("LK22_29","072_22_29","LUK","22","29","29","Wo Meegó yʼo ele Moziko a nuŋ, iŋkino kay nuŋ nʼun di-tʼele a kune. ");
INSERT INTO moz_vpl VALUES ("LK22_30","072_22_30","LUK","22","30","30","Iŋkino maŋ kun dʼoomey kun di siɓey ti nuŋ kaŋ soo adda mozikadó, wo kun di konɗitey ekki kaakidagi moziko, kun ɗekkey booro a tukki boha bumɓiyagi koomat makumu sire ki ɗoŋ kʼIzirayel.» ");
INSERT INTO moz_vpl VALUES ("LK22_31","072_22_31","LUK","22","31","31","Galmeeega yʼa ruute, yʼede: «Simo, Simo, kee kʼollo, Meeda siitanɗani ti tunde urzi ti Raa wo yi-dʼele, kune pay tʼun tiʼn toŋgile aakede an toŋgilso geme. ");
INSERT INTO moz_vpl VALUES ("LK22_32","072_22_32","LUK","22","32","32","Wo ɗe nuŋ nʼa tunde Raa kono kee, kono zaapu kʼaddá a nuŋ a ki dagge ye. Wo aame ki-gimo a nuuno maŋ, zemɓadá kʼan eelo toogo.» ");
INSERT INTO moz_vpl VALUES ("LK22_33","072_22_33","LUK","22","33","33","Maŋ Piyer yi di ruute, yʼede: «Galmeeʼki nuŋ, nʼiyye nʼa tʼette ti kee, ise kʼadda daŋgay, ise nʼa tʼindey toŋ maŋ.» ");
INSERT INTO moz_vpl VALUES ("LK22_34","072_22_34","LUK","22","34","34","Isa yi di ruute, yʼede: «Piyer kʼollo, nʼa di rooto, aŋki a diɗɗo ki poone uzu yʼa kookila geŋ, kʼa roota ki ki nʼ suune ye, suune ye taŋ aɗo.» ");
INSERT INTO moz_vpl VALUES ("LK22_35","072_22_35","LUK","22","35","35","Maŋ Isa yʼan di ruute sey, yʼede: «Aame nʼun igibe isiyo naabadó daa soŋko, daa kʼeese wo daa toɓiyagi geŋ, munɗa unni biito ko?» Kane an i diʼn gime onamí, anʼde: «Munɗa ay kiʼn biito ye.» ");
INSERT INTO moz_vpl VALUES ("LK22_36","072_22_36","LUK","22","36","36","Yoŋ yʼan di ruute, yʼede: «Wo aŋken̰n̰o eŋ wede i-dʼede soŋko maŋ yʼa tʼamɓe, wede i dʼede eese toŋ iŋkino kay, wo wede i-kʼede kasigara ye maŋ, kallayí wede goole yʼa tʼowol, wo yi dʼowili kasigara te. ");
INSERT INTO moz_vpl VALUES ("LK22_37","072_22_37","LUK","22","37","37","Geŋ kun ollo, nʼun di rooto, eŋ ono ɗoŋ an riiŋe ti kaaga adda mattup ki Raa, anʼde: “Yoŋ an aa ti yʼ gize ti ɗoŋ tôwwo ɗuwo kaŋ soo.” Geŋ iŋkino i dehu o dʼaane. Maŋ ono ɗoŋ an riiŋe a tukki nuŋ geŋ, a-tʼetta.» ");
INSERT INTO moz_vpl VALUES ("LK22_38","072_22_38","LUK","22","38","38","Kane sanalliyagi an di ruute, anʼde: «Galmeegey, kasigara ede, sire ettiyo.» Yoŋ yʼan diʼn gime onamaŋ, yʼede: «Geŋ îide baa.» ");
INSERT INTO moz_vpl VALUES ("LK22_39","072_22_39","LUK","22","39","39","Maŋ tʼadda geeger Isa yi-tʼuɗɗe, yʼa iŋgile kʼekki mokkolo kʼInda kʼOlibiye aa yi dʼisiyo daayum, wo kane sanalliyagí an di yʼ diine. ");
INSERT INTO moz_vpl VALUES ("LK22_40","072_22_40","LUK","22","40","40","Aame yʼiiney a ume gen̰n̰o maŋ, yoŋ yʼan di ruute, yʼede: «Kun tondo Raa kono kun ki tʼoora adda naamiya daggiya ye.» ");
INSERT INTO moz_vpl VALUES ("LK22_41","072_22_41","LUK","22","41","41","Wo yoŋ yʼaa liɗɗe dokki ti tuddaŋ suma wede yʼa seɗɗe mokkolo, maŋ yʼa-dikke wo yi tondiyo Raa, yʼede: ");
INSERT INTO moz_vpl VALUES ("LK22_42","072_22_42","LUK","22","42","42","«Meegó, ki dehu maŋ dabar ette kʼo ti leɗɗo ti tuddó me, wo toŋ maŋ a ki tʼise aa nuŋ ni dehu ye, wo a tʼise aa kee ki dehu.» ");
INSERT INTO moz_vpl VALUES ("LK22_43","072_22_43","LUK","22","43","43","Maŋ i dʼiido maaleeka ti kandaane yi dʼeele toogo a Isa me. ");
INSERT INTO moz_vpl VALUES ("LK22_44","072_22_44","LUK","22","44","44","Isa ulbí i-dʼooɗiyo ɓaadaŋ, maŋ yi tondiyo Raa ti toogo a jiire sey, wo ran̰n̰adí a tʼize aa puuzo i zozziso a siiɗo. ");
INSERT INTO moz_vpl VALUES ("LK22_45","072_22_45","LUK","22","45","45","Aame yi-tunde Raa maŋ, yʼa tʼiiziga yʼa-gime ki tukki sanalliyagi, yʼan diʼn uuney kane an udige kono an tʼize sommagi dondoŋ. ");
INSERT INTO moz_vpl VALUES ("LK22_46","072_22_46","LUK","22","46","46","Yoŋ yʼan di ruute, yʼede: «Ki moo me kun moone me? Kun tʼoozo wo kun tondo Raa, kono kun ki tʼoora adda naamiya daggiya ye.» ");
INSERT INTO moz_vpl VALUES ("LK22_47","072_22_47","LUK","22","47","47","Isa onamí yʼa ki tiʼn ɗiŋge ye ɓotto, aame geŋ kane ɗoŋ duuru an tʼuɗɗo. Yode wede an yi waaku Ziidas, yoŋ ti diine sanalliyagi kane koomat makumu sire geŋ, yʼan tʼuugumo a ɗoŋ duuru me. An iiney maŋ, yʼa dʼiide sirpa kʼIsa yʼa yi ziiɗa yop kono yi-dʼise puuc a toɓɓisadí. ");
INSERT INTO moz_vpl VALUES ("LK22_48","072_22_48","LUK","22","48","48","Isa yi di ruute, yʼede: «Ziidas, nuŋ wede an nʼehe aa ulo wede eŋ, kʼan di nʼ tʼele bey ɗoŋ kʼolmiɗayó tʼurzi kʼisiyo puuc a toɓɓisadó ko?» ");
INSERT INTO moz_vpl VALUES ("LK22_49","072_22_49","LUK","22","49","49","Aame kane ɗoŋ a ita kʼIsa an wulle munɗa wede isa gen̰n̰o maŋ, an di yʼ tunde, anʼde: «Galmeegey, ay tiʼn dokko ti kasigara ko?» ");
INSERT INTO moz_vpl VALUES ("LK22_50","072_22_50","LUK","22","50","50","Maŋ wede soo ti diinayaŋ yʼa-diikiɗa wede naabo ki mozigo goole ɗoŋ seɗeke, kuudí a ɗikke. ");
INSERT INTO moz_vpl VALUES ("LK22_51","072_22_51","LUK","22","51","51","Wo ɗe Isa yʼa ruute, yʼede: «Kun oolo, geŋ îide baa.» Iŋkino yo yʼaa butte a kuudí wede gen̰n̰o wo yi-dʼele bee. ");
INSERT INTO moz_vpl VALUES ("LK22_52","072_22_52","LUK","22","52","52","Iŋkino maŋ a kane deero ɗoŋ seɗeke, deero ɗoŋ boohiyo Ɓoy Raa wo ti ɗoŋ i dokkiyo Yawudiyagi iido seeɗuzí, Isa yʼan di ruute, yʼede: «Ɗe ki moo me kun dʼettiyo tuddó wo tudduguŋ kun tʼikkimo ti kasigaryagi wo ti dalyagi, aa nuŋ wede kʼoogire me? ");
INSERT INTO moz_vpl VALUES ("LK22_53","072_22_53","LUK","22","53","53","Para maŋ nuŋ miŋ daayum ti kune a booro Ɓoy Raa, wo kun gi di nʼ ziiɗa ye. Wo ɗe aŋken̰n̰o ette peeɗaguŋ, peeɗo ere ki ɗoŋ toogo adda zimolo an dʼise naabadaŋ.» ");
INSERT INTO moz_vpl VALUES ("LK22_54","072_22_54","LUK","22","54","54","Maŋ Isa an di yʼ ziiɗa, an ti yʼ dukke, an di tʼiide kʼadda ɓoy ki mozigo goole ɗoŋ seɗeke. Wo Piyer yi diʼn daaniya ti dokki. ");
INSERT INTO moz_vpl VALUES ("LK22_55","072_22_55","LUK","22","55","55","Ɗuwo an di muɗɗe uwwo a diine booro ɓoy, wo Piyer yʼa zuŋke yi kookiyo uwwo ti kane. ");
INSERT INTO moz_vpl VALUES ("LK22_56","072_22_56","LUK","22","56","56","Aame yi zuŋke yi kookiyo uwwo geŋ, i dʼede ere naabo tʼa yi wulle, wo ti di yʼ wolliso teɓen̰ adda kʼedayí, maŋ tʼa ruute, tʼede: «Wede en̰n̰o toŋ yoŋ ti yode kaŋ soo.» ");
INSERT INTO moz_vpl VALUES ("LK22_57","072_22_57","LUK","22","57","57","Wo Piyer yʼa yi giigira, yi di ruute, yʼede: «Erewo no, nuŋ ni ki yʼ suune ye.» ");
INSERT INTO moz_vpl VALUES ("LK22_58","072_22_58","LUK","22","58","58","Taŋ ɓooloŋ maŋ i dʼiido wede ti doolo, yʼa yi wulle wo yʼa ruute, yʼede: «Ɗerec, kee toŋ wede soo ti diine kane sanalliyagi kʼIsa!» Maŋ Piyer yi diʼn gime onamí, yʼede: «Ato, nuŋ ti diine kane ye.» ");
INSERT INTO moz_vpl VALUES ("LK22_59","072_22_59","LUK","22","59","59","A likke bini maŋ, i dʼiido wede ti doolo yi-koɗɗime, yi dʼeesiyo: «Ki kotto wede eŋ yoŋ ti yode kaŋ soo, kono yoŋ ti siiɗo Galile.» ");
INSERT INTO moz_vpl VALUES ("LK22_60","072_22_60","LUK","22","60","60","Maŋ Piyer yi diʼn gime onamí, yʼede: «Aha, munɗa wede ki rootiyo geŋ a nuuno ye.» Wo a kaamiki aame yʼa ti rootiyo ɓotto geŋ, uzu yʼa îile. ");
INSERT INTO moz_vpl VALUES ("LK22_61","072_22_61","LUK","22","61","61","Galmeega yʼa gilɗe ki tukki Piyer wo yi di yʼ wolliyo teɓen̰ adda kʼedayí. Iŋkino maŋ Piyer yʼa ilke a ono ɗoŋ Galmeega yi-ruute, yʼede: «Aŋki eŋ ki poone uzu yʼa ôola geŋ, kʼa roota ki ki nʼ suune ye, suune ye taŋ aɗo.» ");
INSERT INTO moz_vpl VALUES ("LK22_62","072_22_62","LUK","22","62","62","Maŋ tʼadda ɓoy Piyer yi-tʼuɗɗe ti paate wo yʼa iise môolo ɓaadaŋ. ");
INSERT INTO moz_vpl VALUES ("LK22_63","072_22_63","LUK","22","63","63","Ɗuwo ɗoŋ i boohiyo Isa an di yʼokko maade wo an di yʼ kossiyo. ");
INSERT INTO moz_vpl VALUES ("LK22_64","072_22_64","LUK","22","64","64","Edayí an i-tʼippe wo an di yʼ tondiso, anʼde: «Kee nebi maŋ, ki yʼunto wede i ki diin̰e me!» ");
INSERT INTO moz_vpl VALUES ("LK22_65","072_22_65","LUK","22","65","65","Wo an i-dʼirbita ono ɓaadaŋ ti doolo ɗoŋ ki kalɗita. ");
INSERT INTO moz_vpl VALUES ("LK22_66","072_22_66","LUK","22","66","66","Aame ume i tʼumpile maŋ, kane ɗoŋ i dokkiyo Yawudiyagi, deero ɗoŋ seɗeke ti ɗoŋ suuniyo kʼoogoro, an tʼugiye pay an di-tʼiide Isa ki ɗaana deero booro Yawudiyagi, ");
INSERT INTO moz_vpl VALUES ("LK22_67","072_22_67","LUK","22","67","67","wo an di yʼ tunde, anʼde: «Almasi Raa yi biire, kee ko? Kʼay ki ti rooti ɗo.» Yoŋ yʼan diʼn gime onamaŋ, yʼede: «Aame nʼun ruuta maŋ, kun kʼamɓa ye onamó me, ");
INSERT INTO moz_vpl VALUES ("LK22_68","072_22_68","LUK","22","68","68","wo aame nʼunni tunda toŋ maŋ, onamó kun ki tiʼn kima ye. ");
INSERT INTO moz_vpl VALUES ("LK22_69","072_22_69","LUK","22","69","69","Wo ti aŋki eŋ, nuŋ wede an nʼehe aa ulo wede eŋ, nʼa-kooney a ammade Raa toogadí tʼa jiire pay.» ");
INSERT INTO moz_vpl VALUES ("LK22_70","072_22_70","LUK","22","70","70","Kane pay an di ruute, anʼde: «Iŋkino maŋ kee Ulo Raa ko?» Yoŋ yʼan diʼn gime onamaŋ, yʼede: «Aa kune batum kun ruute, eŋ miŋ nuuno.» ");
INSERT INTO moz_vpl VALUES ("LK22_71","072_22_71","LUK","22","71","71","Iŋkino maŋ an di ruute, anʼde: «In ki dehe wenɗa ti doolo wede illiga yʼin ki roote sey ye baa! Kine in illiga bize yode batum i ruute me.» ");
INSERT INTO moz_vpl VALUES ("LK23_1","072_23_1","LUK","23","1","1","Maŋ kane ɗoŋ i tʼugiye an tʼiiziga pay, an di-tʼiide Isa ki ɗaana Pilat, yoŋ Romeŋ goole siiɗo. ");
INSERT INTO moz_vpl VALUES ("LK23_2","072_23_2","LUK","23","2","2","A ume geŋ kane an dʼiise sakiysa kʼIsa, anʼde: «Wede eŋ kaye ay yʼuuney ɗoŋ siiɗadey yi tiʼn daggiya, yʼan rootiyo jibaaye an ti toogo kʼeliyo a mozigo goole ki Romeŋ me, wo soŋ yi tʼize yode batum Almasi Raa yi biire, yoŋ mozigo Yawudiyagi.» ");
INSERT INTO moz_vpl VALUES ("LK23_3","072_23_3","LUK","23","3","3","Pilat yʼa yi tunde, yʼede: «Kee mozigo Yawudiyagi ko?» Isa yi diʼn gime onamí, yʼede: «Geŋ aa ki ruute.» ");
INSERT INTO moz_vpl VALUES ("LK23_4","072_23_4","LUK","23","4","4","Iŋkino maŋ Pilat yʼan di ruute a kane deero ɗoŋ seɗeke ti ɗoŋ duuru, yʼede: «Wede eŋ nuŋ munɗa kʼulsu a eedí ni kʼuune ye, wede i di tʼîde booro tʼa yi seeɗa me.» ");
INSERT INTO moz_vpl VALUES ("LK23_5","072_23_5","LUK","23","5","5","Wo kane an di koɗɗime, anʼde: «Yoŋ tʼurzi dooyisadí ɗoŋ pay yʼan tʼeliyto ono bini a-tʼooziga ɗeyyiso. Yoŋ yʼiiso ti siiɗo Galile, yʼa tûukey siiɗo Ziide pay, wo aŋkeŋ yʼaa dʼiina a en̰n̰o.» ");
INSERT INTO moz_vpl VALUES ("LK23_6","072_23_6","LUK","23","6","6","Aame Pilat yʼilliga ono gen̰n̰o maŋ, yʼa tunde, yʼede: «Wede eŋ yoŋ ti siiɗo Galile ko?» ");
INSERT INTO moz_vpl VALUES ("LK23_7","072_23_7","LUK","23","7","7","Wo aame yi zuune Isa yoŋ ti siiɗo ere mozigo Erod Antipas maŋ, Pilat yi di yʼigibe a Erod, kono a onniytagi geŋ yode Erod toŋ a Zeruzalem. ");
INSERT INTO moz_vpl VALUES ("LK23_8","072_23_8","LUK","23","8","8","Aame Erod yi wulle Isa maŋ, ulbí aaze uŋse ɓaadaŋ, kono yoŋ yʼollige rabiladí ti kaagine wo yi dehu yʼa ti yʼ wolle. Iŋkino yi zaapu elkisadí yi-dʼisa munɗa kʼarmika yʼa-wolla. ");
INSERT INTO moz_vpl VALUES ("LK23_9","072_23_9","LUK","23","9","9","Erod yʼa yi tundite taŋ ɓaadaŋ, wo yo Isa yi-kʼohine bizí ye. ");
INSERT INTO moz_vpl VALUES ("LK23_10","072_23_10","LUK","23","10","10","Kane deero ɗoŋ seɗeke, ti ɗoŋ suuniyo kʼoogoro, kane a sirpa an di rootiyto ono ti golla zakiɗi. ");
INSERT INTO moz_vpl VALUES ("LK23_11","072_23_11","LUK","23","11","11","Erod kane ti asigiryagí an di yʼokko maade wo an di yʼamɓutu saa saac. An i-di tʼusse kalle majjaane, maŋ yi di yʼigibe a Pilat. ");
INSERT INTO moz_vpl VALUES ("LK23_12","072_23_12","LUK","23","12","12","Erod ti Pilat geŋ ti poone kane adu, wo ti onniyo gette an tʼize laŋziyagi. ");
INSERT INTO moz_vpl VALUES ("LK23_13","072_23_13","LUK","23","13","13","Iŋkino maŋ Pilat yʼa-tusse kane deero ɗoŋ seɗeke, deero Yawudiyagi wo ti ɗoŋ duuru, ");
INSERT INTO moz_vpl VALUES ("LK23_14","072_23_14","LUK","23","14","14","wo yʼan di ruute, yʼede: «Wede eŋ kun oo dʼiidoʼŋ kunʼde, ɗuwo pay yi tiʼn daggiya. Iŋkino ni yʼ tunde a ɗaanaguŋ a ono ɗoŋ kun rootiyto a tukki yode geŋ me, wo nuŋ munɗa ulsu a eedí ni kʼuune ye a tʼîde booro tʼa yi seeɗa me. ");
INSERT INTO moz_vpl VALUES ("LK23_15","072_23_15","LUK","23","15","15","Erod gen̰n̰o toŋ munɗa ulsu yi kʼuune ye a eedí me, iŋkino yʼay ti yʼ gimo. Kono kʼiŋkino, wede eŋ munɗa ulsu yi kʼize ye wede a tʼîde kʼunto me. ");
INSERT INTO moz_vpl VALUES ("LK23_16","072_23_16","LUK","23","16","16","Iŋkino maŋ nʼan tʼela urzi a asigiryagó an ti yʼ gorpipa ti marpa ɗoo miŋ, saŋ an i-dʼeeza kollo.» ");
INSERT INTO moz_vpl VALUES ("LK23_17","072_23_17","LUK","23","17","17","Yi ruute iŋkino kono aa an dʼisiyo daayum a tarnaape Pak ki Yawudiyagi, i dehu Pilat yʼan dʼaɗɗe wedusu soo tʼadda daŋgay. ");
INSERT INTO moz_vpl VALUES ("LK23_18","072_23_18","LUK","23","18","18","Wo pay kaŋ soo an dʼiise ɗollite, anʼde: «Wede geŋ ki yʼôodo! Kʼay tʼaɗɗi Barabas!» ");
INSERT INTO moz_vpl VALUES ("LK23_19","072_23_19","LUK","23","19","19","Yo Barabas geŋ an yi ziiɗa daŋgay kono yoŋ wede an tʼeelite ono a ɗuwo an dʼiiziga ɗeyyiso adda geeger ki tukki Romeŋ, wo soŋ yʼîide wedusu. ");
INSERT INTO moz_vpl VALUES ("LK23_20","072_23_20","LUK","23","20","20","Pilat yʼan dʼiise rootiyo sey a ɗoŋ duuru kono yi dehu Isa yi-dʼeeze. ");
INSERT INTO moz_vpl VALUES ("LK23_21","072_23_21","LUK","23","21","21","Wo kane an di ɗollite, an dʼeesiyo: «Ki ti yʼ taako ekkʼundumu wede zaapu tʼekki bakadí kaŋ tontilko! Ki ti yʼ taako ekkʼundumu wede zaapu tʼekki bakadí kaŋ tontilko!» ");
INSERT INTO moz_vpl VALUES ("LK23_22","072_23_22","LUK","23","22","22","Maŋ Pilat yʼan di ruute kʼaɗuwe, yʼede: «Wede eŋ munɗa ulsu miŋ yʼize moo me? Nuŋ maŋ munɗa ulsu ni kʼuune ye a eedí i di tʼîde kʼunto me. Iŋkino nʼan tʼela urzi an ti yʼ gorpipa ti marpa ɗoo miŋ, saŋ an i-dʼeeza kollo.» ");
INSERT INTO moz_vpl VALUES ("LK23_23","072_23_23","LUK","23","23","23","Wo kane an di koɗɗime ɗollite ti golla awwa, an dʼeesiyo: «Isa ki ti yʼ taako ekkʼundumu wede zaapu tʼekki bakadí kaŋ tontilko!» Maŋ Pilat i-di tʼiide a ɗollitadaŋ gette. ");
INSERT INTO moz_vpl VALUES ("LK23_24","072_23_24","LUK","23","24","24","Iŋkino yoŋ booro yʼan ti-ɗikke a munɗa wede Yawudiyagi an tondiyo me. ");
INSERT INTO moz_vpl VALUES ("LK23_25","072_23_25","LUK","23","25","25","Barabas wede kane an dehu geŋ, Pilat yʼa yʼuɗɗe, yode wede an ti yʼele adda daŋgay kono yʼan tʼeelite ono a ɗuwo an dʼiiziga ɗeyyiso ki tukki Romeŋ, soŋ yʼîide wedusu geŋ me. Wo yo Isa yʼan di yʼele a bey kʼasigiryagi, an dʼise munɗa wede kane Yawudiyagi an dehu. ");
INSERT INTO moz_vpl VALUES ("LK23_26","072_23_26","LUK","23","26","26","Maŋ Isa an di-tʼette kʼume taakiyadí. A urzi an a-tʼikkima ti wede soo iŋkino yoŋ ti geeger Sireŋ, sundí Simo, yʼaahiya doome. Kane asigiryagi an di yʼ ziiɗa, an i-dʼele undumu wede zaapu tʼekki bakadí kaŋ tontilko, yʼa tʼumɓe a dannayí wo yi daaniya Isa. ");
INSERT INTO moz_vpl VALUES ("LK23_27","072_23_27","LUK","23","27","27","Ɗoŋ duuru ɓaadaŋ ki siiɗo gette an di yʼ daaniya, ti diinayaŋ erayi an a-tʼiɓi beyɗaŋ a giggiraŋ wo an di ɗollite môolo kono kʼIsa. ");
INSERT INTO moz_vpl VALUES ("LK23_28","072_23_28","LUK","23","28","28","Maŋ Isa yʼa gilɗe kʼume kʼerayi gen̰n̰o wo yʼan di ruute, yʼede: «Kune erayi Zeruzalem no, kun ôole ye kono nuŋ me, ki too maŋ kun ôoloʼŋ ki kune wo ki in̰n̰iguŋ. ");
INSERT INTO moz_vpl VALUES ("LK23_29","072_23_29","LUK","23","29","29","Ɗerec, onniytagi saŋ maŋ an dʼaana, aame geŋ an di roota: “Uŋsuwo a kane erayi ɗoŋ kartiyagi, a kane ɗoŋ an kʼehe ye wo an kʼuuɗe in̰n̰i ye ɓotto.” ");
INSERT INTO moz_vpl VALUES ("LK23_30","072_23_30","LUK","23","30","30","Iŋkino maŋ ɗuwo an di roota, an tʼeesa: “Moŋgali an ay di tiʼn ruugi!” wo soŋ an tʼeesa: “Kessagi an ay tiʼn ombiɗi!” ");
INSERT INTO moz_vpl VALUES ("LK23_31","072_23_31","LUK","23","31","31","Aame ɗuwo an o isiyo kino a nuŋ wede aakede undumu zeere eŋ me maŋ, an dʼaana moo me a kane ɗoŋ aakede inda ɗoŋ meeɗi me?» ");
INSERT INTO moz_vpl VALUES ("LK23_32","072_23_32","LUK","23","32","32","An a-dukko a ita kʼIsa ɗoŋ sire ti doolo, kane ɗoŋ kʼoogire, an tiʼn tʼîde ti yode kaŋ soo. ");
INSERT INTO moz_vpl VALUES ("LK23_33","072_23_33","LUK","23","33","33","An iiney a ume wede sundí «osse kʼeego» maŋ, a ume geŋ Isa asigiryagi an ti yʼ tiike ekkʼundumu wede zaapu tʼekki bakadí kaŋ tontilko. Wo an a-tiike ti yode ɗoŋ kʼoogire sire, wede soŋ tʼundumzí a kese kʼammidadí wo soŋ tʼundumzí a kese geeladí. ");
INSERT INTO moz_vpl VALUES ("LK23_34","072_23_34","LUK","23","34","34","Iŋkino maŋ Isa yʼa ruute, yʼede: «Meeʼki nuŋ, kʼan tʼiso tambobino, kono an ki suune ye munɗa wede an isiyo geŋ me.» Wo asigiryagi an di dikkiɗa kallagi kʼIsa tʼurzi kʼarɓu teltel muntelliyo. ");
INSERT INTO moz_vpl VALUES ("LK23_35","072_23_35","LUK","23","35","35","Kane ɗoŋ duuru an tʼîhira aŋgen̰n̰o, an di wolliyo. Kane deero Yawudiyagi an di yʼokko maade, an dʼeesiyo: «Yoŋ ɗoŋ doolo yʼan utte ɗe, aŋkeŋ yʼutto tuddí batum, aame yo Almasi Raa yi biire kotto maŋ!» ");
INSERT INTO moz_vpl VALUES ("LK23_36","072_23_36","LUK","23","36","36","Kane asigiryagi toŋ an di yʼokko maade, an a dʼettiyo goppoŋ ki sirpadí, an i-dʼeliyo toote suddo kʼin̰n̰i kʼinda bin̰ yʼa siɓe, ");
INSERT INTO moz_vpl VALUES ("LK23_37","072_23_37","LUK","23","37","37","wo an dʼeesiyo: «Aame kee mozigo Yawudiyagi kotto maŋ, kʼutto tuddá batum!» ");
INSERT INTO moz_vpl VALUES ("LK23_38","072_23_38","LUK","23","38","38","Tʼekkʼeedí an tiike pakirte wo an a-ti riiŋe, anʼde: «Yode eŋ mozigo Yawudiyagi.» ");
INSERT INTO moz_vpl VALUES ("LK23_39","072_23_39","LUK","23","39","39","Ti diine ɗoŋ kʼoogire sire an tiʼn tiike ekkʼinda geŋ, wede soŋ yʼa gilɗe Isa, yʼede: «Kee Almasi Raa yi biire kotto maŋ, kʼutto tuddá batum wo kaye pây!» ");
INSERT INTO moz_vpl VALUES ("LK23_40","072_23_40","LUK","23","40","40","Wo yo wede soŋ yʼa yʼiɗɗise, yi di ruute, yʼede: «Kee a Raa ki-kʼorgiso ye, kee wede booro ti ki ziiɗa kʼunto ti yode eŋ kaŋ soo. ");
INSERT INTO moz_vpl VALUES ("LK23_41","072_23_41","LUK","23","41","41","Ki kine dabar ette ɗerec, kono in ooniyo munɗa wede in ize tʼurzi naabadiŋ, wo yo wede eŋ munɗa ulsu yi kʼize ye.» ");
INSERT INTO moz_vpl VALUES ("LK23_42","072_23_42","LUK","23","42","42","Saŋ yʼa ruute sey, yʼede: «Isa, kʼa nʼelko aame ki-kimo ki mozikadá geŋ me.» ");
INSERT INTO moz_vpl VALUES ("LK23_43","072_23_43","LUK","23","43","43","Maŋ Isa yi diʼn gime onamí, yʼede: «Ɗerec iŋkino wo nʼa di rooto: Aŋki eŋ kee ki-tʼetta ti nuŋ adda jenne.» ");
INSERT INTO moz_vpl VALUES ("LK23_44","072_23_44","LUK","23","44","45","Aame peeɗo tʼize diine maŋ, ti ki tooriyo ye, ume a tʼize zimolo dil a likke bini eesiyo peeɗo lohe. Wo alboy wede i ɗikke adde Ɓoy Raa soŋ kʼadda soŋ ki paate, a tʼîhina tar a diinayí. ");
INSERT INTO moz_vpl VALUES ("LK23_46","072_23_46","LUK","23","46","46","Isa yʼa iɗili ti golla awwa, yʼede: «Meeʼki nuŋ, nʼa-dʼelo undó a beezá.» Aame yʼa ti ruute iŋkino maŋ, yʼa-tʼihe. ");
INSERT INTO moz_vpl VALUES ("LK23_47","072_23_47","LUK","23","47","47","Goole kʼasigiryagi meeda ki Romeŋ yi wulle munɗa wede ize me. Maŋ yʼa imme Raa wo yʼa ruute, yʼede: «Ki kotto wede eŋ yoŋ ki diine.» ");
INSERT INTO moz_vpl VALUES ("LK23_48","072_23_48","LUK","23","48","48","Kane ɗoŋ duuru pay iide wolliyo geŋ, aame an wulle munɗa wede ize maŋ, kane an di-gime, beyɗaŋ an a-tʼiɓi giggiraŋ kono an môolo. ");
INSERT INTO moz_vpl VALUES ("LK23_49","072_23_49","LUK","23","49","49","Wo kane pay laŋziyagi kʼIsa ti erayi ɗoŋ i yi diino ti siiɗo Galile, an tʼîhirte ti dokki an di wolliyo munɗa wede isiyo. ");
INSERT INTO moz_vpl VALUES ("LK23_50","072_23_50","LUK","23","50","51","I dʼede wedusu sundí Yusup yoŋ ti geeger ki Yawudiyagi sundutú Arimate. Wede geŋ yoŋ beehiye wo ki diine, yi zaapu elkisadí a ettiyo Moziko Raa. Yoŋ wede ti diine deero booro Yawudiyagi, wo yi kʼiyye ye a munɗa wede ɗoŋ deero booro oŋgo an dihe an dʼise a tukkʼIsa, wo soŋ a naabadaŋ ere an ize te. ");
INSERT INTO moz_vpl VALUES ("LK23_52","072_23_52","LUK","23","52","52","Yo yʼa iide yʼa uuney Pilat, yʼa yi tunde a nuune kʼIsa. ");
INSERT INTO moz_vpl VALUES ("LK23_53","072_23_53","LUK","23","53","53","Pilat yi-dʼiyye, maŋ Yusup yʼa ti yʼ ɗiige nuune tʼekkʼundumu wede zaapu tʼekki bakadí kaŋ tontilko me. Yʼa n̰ilpe ti sotor tuwarwa zooyatú oon̰e, yi-tʼele adda muuzo, todʼte aa urmi an ittiba mokkolo, a ume isire wenɗa kaŋ soo toŋ an kʼeele ye. ");
INSERT INTO moz_vpl VALUES ("LK23_54","072_23_54","LUK","23","54","54","Sulɗi geŋ ize onniyo jima, ɗuwo an okkime tuddaŋ kono onniyo ere ki puukiyo Yawudiyagi ti tʼeesa. ");
INSERT INTO moz_vpl VALUES ("LK23_55","072_23_55","LUK","23","55","55","Kane erayi ɗoŋ i diino Isa ti siiɗo Galile geŋ, Yusup an di yʼ diine, an di wullo muuzo wo mummino an ziipe nuune kʼIsa me. ");
INSERT INTO moz_vpl VALUES ("LK23_56","072_23_56","LUK","23","56","56","Saŋ maŋ an di-gime kʼadda geeger, an iideʼŋ an dʼiwilo egey ti puutagi kʼinda ɗoŋ eeɗiyadaŋ uŋse, an aa di gilse ki rorriso a nuune kʼIsa. A onniyo ere ki puukiyo Yawudiyagi maŋ, an di buuke aakede oogoro ti rootiyo. ");
INSERT INTO moz_vpl VALUES ("LK24_1","072_24_1","LUK","24","1","1","Onniyo dumas ti soohe walak maŋ, erayi an di ziki egey ɗoŋ kalsiya eeɗiyadaŋ uŋse a beyɗaŋ, an dʼiŋgile ki biza muuzo. ");
INSERT INTO moz_vpl VALUES ("LK24_2","072_24_2","LUK","24","2","2","An iiney maŋ, an wolliyo zumbulu wede an a-tʼippe a biza muuzoʼŋ ɗoŋkilso a kese. ");
INSERT INTO moz_vpl VALUES ("LK24_3","072_24_3","LUK","24","3","3","Kane an tʼiide kʼadda muuzo, wo nuune Galmeega Isa an ki yʼuuney ye. ");
INSERT INTO moz_vpl VALUES ("LK24_4","072_24_4","LUK","24","4","4","Kane erayi an dʼuhibe, a kaamiki a ɗaanadaŋ i dʼiido kuuli sire ti kallagi i ralita. ");
INSERT INTO moz_vpl VALUES ("LK24_5","072_24_5","LUK","24","5","5","Iŋkino kane orgiso tʼanni ziiɗa, an di nukkite, wo ɗe kuuli ɗoŋ sire geŋ an an di ruute, anʼde: «Ki moo me kun wekku wede zeere a diine ɗoŋ unto me? ");
INSERT INTO moz_vpl VALUES ("LK24_6","072_24_6","LUK","24","6","6","Yoŋ umbo a en̰n̰o me, Raa yi ti yʼ bilɗe. Kun elko a ono ɗoŋ yʼun ruute aame yo ɓotto a siiɗo Galile, yʼede: ");
INSERT INTO moz_vpl VALUES ("LK24_7","072_24_7","LUK","24","7","7","“I dehu nuŋ wede an nʼehe aa ulo wede eŋ, an di nʼ tʼela a bey ɗoŋ kʼolɗiko, an ti nʼ taaka ekkʼundumu wede zaapu tʼekki bakadí kaŋ tontilko, wo onniyo sire kʼaɗuwe maŋ nʼa-balɗa.”» ");
INSERT INTO moz_vpl VALUES ("LK24_8","072_24_8","LUK","24","8","8","Iŋkino maŋ kane erayi geŋ an diʼn ilke ono ɗoŋ Isa yʼan ruute geŋ me. ");
INSERT INTO moz_vpl VALUES ("LK24_9","072_24_9","LUK","24","9","9","Kane ti biza muuzo an di-gime, wo an iideʼŋ an an tʼîide taaya gette pay a kane ɗoŋ koomat makumu soo wo a kane sanalliyagi ɗoŋ oŋgo pay. ");
INSERT INTO moz_vpl VALUES ("LK24_10","072_24_10","LUK","24","10","10","Kane erayi ɗoŋ iide ki biza muuzo geŋ, Mariyam ere ti siiɗo Magdalla, Zane wo Mariyam ere mekki Zak. Wo erayi ɗoŋ ti doolo ɗoŋ iide ti kane geŋ, taaya gette an an tʼîide pay a ɗoŋ zina kʼIsa me. ");
INSERT INTO moz_vpl VALUES ("LK24_11","072_24_11","LUK","24","11","11","Wo kane a onamaŋ geŋ an diʼn wulle erayi aa ɗoŋ maadagi, onamaŋ an ki dʼumɓe ye. ");
INSERT INTO moz_vpl VALUES ("LK24_12","072_24_12","LUK","24","12","12","Wo toŋ maŋ Piyer yʼa tʼiiziga yʼa ukke ki biza muuzo. Yʼiiney maŋ, yʼa tʼuttile yi ŋooŋiyo kʼadda, yi wolliyoʼŋ sarwilagi ɗaŋŋal, maŋ yʼa ziiɗa giggirí a munɗa wede ize geŋ me, wo yʼa-gime ki ɓoozí. ");
INSERT INTO moz_vpl VALUES ("LK24_13","072_24_13","LUK","24","13","13","A onniyo gettiyo batum i dʼede sanalliyagi sire an amɓe kʼadda kʼille sundutú Emayus, todʼte suma kuɓɓaara paat ti Zeruzalem me. ");
INSERT INTO moz_vpl VALUES ("LK24_14","072_24_14","LUK","24","14","14","Kane an di rootiyto tuddaŋ a sulɗi ɗoŋ pay ize geŋ me. ");
INSERT INTO moz_vpl VALUES ("LK24_15","072_24_15","LUK","24","15","15","Aame kane an rootiyto wo an niikiyto ti tuddaŋ geŋ, yode Isa batum yʼa iide, yʼa-ti giƴƴe ti kane an di sooru kaŋ soo. ");
INSERT INTO moz_vpl VALUES ("LK24_16","072_24_16","LUK","24","16","16","Kane an di yʼ wolliyo, wo munɗa an tʼeegirso ki suuniyadí me. ");
INSERT INTO moz_vpl VALUES ("LK24_17","072_24_17","LUK","24","17","17","Maŋ Isa yʼanni tunde, yʼede: «Kune kun di sooru ɗe, kun di niikiyto a tukkʼamme?» Iŋkino maŋ kane an tʼîhira, sommagi dondoŋ. ");
INSERT INTO moz_vpl VALUES ("LK24_18","072_24_18","LUK","24","18","18","Wede soo ti diine kane sire geŋ sundí Kiliyopas, yi di ruute, yʼede: «Kee siidá ɗaŋŋal ko, wede i lekkiyo a Zeruzalem wo i ki suune ye munɗa wede ize adda kʼonniytagi ɗoŋ kʼita eŋ me?» ");
INSERT INTO moz_vpl VALUES ("LK24_19","072_24_19","LUK","24","19","19","Yoŋ yʼanni tunde, yʼede: «Ɗe ize moo me?» Kane an i diʼn gime onamí, anʼde: «Munɗa wede i-iina a tukkʼIsa wede ti geeger Nazaret. Yoŋ geŋ nebi wede toogo, wo yʼa ti gize toogadí tʼurzi naabadí wo tʼurzi kʼonamí a ɗaana Raa wo a ɗaana ɗuwo pay. ");
INSERT INTO moz_vpl VALUES ("LK24_20","072_24_20","LUK","24","20","20","Kane deero ɗoŋ seɗikadiŋ ti ɗoŋ dokkiyadiŋ an an di yʼele a bey ɗoŋ kʼolmiɗayí kono booro tʼa yi seeɗa ki tôwwo, wo an ti yʼ tiike ekkʼundumu wede zaapu tʼekki bakadí kaŋ tontilko. ");
INSERT INTO moz_vpl VALUES ("LK24_21","072_24_21","LUK","24","21","21","Kaye ay ziipe elkisadey a yode, yoŋ wede soo yʼan aɗɗa ɗoŋ kʼIzirayel ti bey ɗoŋ kʼaduzaŋ. Wo tʼekki sulɗi pay geŋ, onniyo aŋki ette kʼaɗuwe tʼume sulɗi geŋ ize me. ");
INSERT INTO moz_vpl VALUES ("LK24_22","072_24_22","LUK","24","22","22","Wo toŋ erayi miibi ti diinayey an aynʼiddira. Aŋki ti soohe walak an dʼiŋgile ki biza muuzo. ");
INSERT INTO moz_vpl VALUES ("LK24_23","072_24_23","LUK","24","23","23","An iideʼŋ, nuune kʼIsa an ki yʼuune ye. Kane an di-gimo, an ay tʼîide taayadaŋ te anʼde, maaleekiyagi anʼn iido tuddaŋ wo an di ruute, anʼde: “Yoŋ zeere.” ");
INSERT INTO moz_vpl VALUES ("LK24_24","072_24_24","LUK","24","24","24","Ti diine kaye ay sooru kaŋ soo geŋ, ɗoŋ miibi an dʼukke ki biza muuzo wo an dʼuuney miŋ pay a-tʼiide aakede erayi an ruute. Wo yoŋ miŋ umbo, an ki yʼ wullo ye.» ");
INSERT INTO moz_vpl VALUES ("LK24_25","072_24_25","LUK","24","25","25","Iŋkino maŋ Isa yʼan di ruute, yʼede: «Kune ɗoŋ elkisaguŋ attiɗi, kun kʼamɓu kesiko ye ono ɗoŋ pay nebiyagi an ruutite geŋ me. ");
INSERT INTO moz_vpl VALUES ("LK24_26","072_24_26","LUK","24","26","26","Ki kotto i dehu Almasi Raa yi biire geŋ yʼa dabire iŋkino ɗoo miŋ, saŋ yi tʼetta adda darƴikadí kollo.» ");
INSERT INTO moz_vpl VALUES ("LK24_27","072_24_27","LUK","24","27","27","Saŋ yʼan di gizite keren̰ sulɗi ɗoŋ pay an riiŋite ti kaaga a tukki yode adda mattup ki Raa geŋ me, yʼa iise ti mattup kʼoogoro Muusa bini yʼa-ti ɗiŋge ti mattupiyagi ɗoŋ pay ki nebiyagi. ");
INSERT INTO moz_vpl VALUES ("LK24_28","072_24_28","LUK","24","28","28","Aame kane an iiney goppoŋ ti ille ere anʼte maŋ, Isa yi dʼisiyo aakede yʼiŋgile ki ɗaana iŋkino. ");
INSERT INTO moz_vpl VALUES ("LK24_29","072_24_29","LUK","24","29","29","Wo kane an di koɗɗime, an dʼeesiyo: «Kee kʼoopo ti kaye kino, peeɗo tʼa tʼooriyo ume yʼize.» Iŋkino maŋ yi-tʼiide adda ɓoy, yʼa uupe ti kane. ");
INSERT INTO moz_vpl VALUES ("LK24_30","072_24_30","LUK","24","30","30","Yʼa-guune omɓo ti kane, yʼa tʼumɓe mappa, yʼa ruute koɗuwo a Raa, maŋ yʼa ɓurkite, yʼan dʼele. ");
INSERT INTO moz_vpl VALUES ("LK24_31","072_24_31","LUK","24","31","31","Aame geŋ edayaŋ a tʼihina, kane an di yʼ zuune Isa me, wo a kaamiki ti ɗaanadaŋ yʼa n̰ukkiɗe. ");
INSERT INTO moz_vpl VALUES ("LK24_32","072_24_32","LUK","24","32","32","Kane an dʼiise rootiyto ti tuddaŋ, anʼde: «Aame kine a urzi wo yoŋ yʼin rootiyto a tukkʼono ɗoŋ an riiŋite ti kaaga adda mattup ki Raa geŋ, ki kotto in dʼuwwe munɗa a biza kʼulbiŋ me.» ");
INSERT INTO moz_vpl VALUES ("LK24_33","072_24_33","LUK","24","33","33","Maŋ kesiko kane an tʼiiziga, an di-gime ki Zeruzalem. An iideʼŋ an diʼn uuney kane sanalliyagi koomat makumu soo geŋ an tʼugiye ti ɗoŋ an sooru soo, ");
INSERT INTO moz_vpl VALUES ("LK24_34","072_24_34","LUK","24","34","34","wo kane an an di ruute a ɗoŋ sire geŋ, anʼde: «Ki kotto Galmeega yi bilɗe, yi gize tuddí a Simo!» ");
INSERT INTO moz_vpl VALUES ("LK24_35","072_24_35","LUK","24","35","35","Wo kane batum an an tʼîide taaya a munɗa wede ize a urzi, wo mummino kane Isa an di yʼ zuune a ume wede yʼan ɓorkiso mappa geŋ me. ");
INSERT INTO moz_vpl VALUES ("LK24_36","072_24_36","LUK","24","36","36","Aame kane onamaŋ ɓotto an a ki tiʼn ɗiŋge ye geŋ, a kaamiki yode Isa batum yʼa gize tuddí a diinayaŋ, wo yʼan di ruute, yʼede: «Toose ti koona ti kune.» ");
INSERT INTO moz_vpl VALUES ("LK24_37","072_24_37","LUK","24","37","37","Kane an dʼiddira, orgiso tʼanni ziiɗa ɓaadaŋ kono an elkiyo an wulleʼŋ beyye. ");
INSERT INTO moz_vpl VALUES ("LK24_38","072_24_38","LUK","24","38","38","Wo Isa yʼan di ruute, yʼede: «Moo me kun orgiso me? Moo me un dʼede niikiyo adda kʼadduguŋ me?» ");
INSERT INTO moz_vpl VALUES ("LK24_39","072_24_39","LUK","24","39","39","Kun wollo beyɗó ti zoŋɗó, eŋ miŋ nuŋ! Kun ni botto, wo kun wollo beyyeʼŋ i-kʼede tukin̰o ye osse ye, wo nuŋ oo dʼede aakede kune kun wolliyo. ");
INSERT INTO moz_vpl VALUES ("LK24_40","072_24_40","LUK","24","40","40","Yoŋ yʼa ti ɗiŋge onamí maŋ, yʼan di gize beyɗí ti zoŋɗí. ");
INSERT INTO moz_vpl VALUES ("LK24_41","072_24_41","LUK","24","41","41","Wo kane onamí an kʼamɓu ye ɓotto kono addaŋ ûune tʼuŋsuwo wo an ziiɗa giggiraŋ. Iŋkino maŋ yoŋ yʼanni tunde, yʼede: «A en̰n̰o un ede munɗa kʼomɓo ko?» ");
INSERT INTO moz_vpl VALUES ("LK24_42","072_24_42","LUK","24","42","42","Kane an i di ɓurko puuniso gaƴirsa an i-dʼele. ");
INSERT INTO moz_vpl VALUES ("LK24_43","072_24_43","LUK","24","43","43","Yoŋ yʼa ziiɗa wo yʼa tʼiimi a ɗaanadaŋ. ");
INSERT INTO moz_vpl VALUES ("LK24_44","072_24_44","LUK","24","44","44","Saŋ yʼan di ruute, yʼede: «Aame nuŋ ɓotto ti kune geŋ, en̰n̰o munɗa wede nʼun ruute me: I dehu ono ɗoŋ an riiŋe a tukki nuŋ adda mattup kʼoogoro Muusa ti ono ɗoŋ ki nebiyagi wo adda mattup ki Soom geŋ, kane pay a aane kono a-tʼette a ono mattupiyagi gen̰n̰o.» ");
INSERT INTO moz_vpl VALUES ("LK24_45","072_24_45","LUK","24","45","45","Iŋkino maŋ yoŋ yʼan tʼihina eedaŋ, kono an di seeɗa ita kʼono ɗoŋ an riiŋe ti kaaga adda mattup ki Raa, ");
INSERT INTO moz_vpl VALUES ("LK24_46","072_24_46","LUK","24","46","46","wo yʼan di ruute, yʼede: «En̰n̰o munɗa wede an riiŋe me, anʼde: Almasi Raa yi biire, yʼa dabira bini yʼa tʼinda, saŋ onniyo sire kʼaɗuwe maŋ Raa yʼa ti yʼ balɗa ti diine ɗoŋ unto me. ");
INSERT INTO moz_vpl VALUES ("LK24_47","072_24_47","LUK","24","47","47","Geŋ i dehu an di kizite ti sundí a ita ɗuwo pay, an di tʼeese ti Zeruzalem, an an di roota a ɗuwo an di-kima lekkiyadaŋ wo an tʼoona tambobino kʼolɗikadaŋ. ");
INSERT INTO moz_vpl VALUES ("LK24_48","072_24_48","LUK","24","48","48","A sulɗi pay geŋ kune kun illiga wo kun wulle. ");
INSERT INTO moz_vpl VALUES ("LK24_49","072_24_49","LUK","24","49","49","Wo nuŋ ni-tʼigibo a egguŋ munɗa wede Meegó Raa yi ruute yʼun tʼela. Wo kuneʼŋ, kun lekko adda geeger bini toogo ere i ɗeego tʼawwa ti kandaane tʼun diʼn ôona.» ");
INSERT INTO moz_vpl VALUES ("LK24_50","072_24_50","LUK","24","50","50","Saŋ tʼadda geeger Isa yʼan tʼuɗɗe ti paate, an dʼiŋgile kʼume wede goppoŋ ti ille ki Betani. A ume geŋ yʼa ziki beyɗí wo yʼan di ziipe beeko. ");
INSERT INTO moz_vpl VALUES ("LK24_51","072_24_51","LUK","24","51","51","Aame yʼan zaapu beeko geŋ, kane yʼan diʼn iili, yoŋ Raa yʼa yʼumɓe kʼawwa ki kandaane. ");
INSERT INTO moz_vpl VALUES ("LK24_52","072_24_52","LUK","24","52","52","Aame geŋ kane an di-dikke wo an tʼuttile a ɗaanadí, saŋ an di-gime ki Zeruzalem tʼuŋsuwo ɓaadaŋ. ");
INSERT INTO moz_vpl VALUES ("LK24_53","072_24_53","LUK","24","53","53","Kane an dʼettiyo daayum kʼadda booro Ɓoy Raa, wo an di tamma Raa.");
INSERT INTO moz_vpl VALUES ("JN1_1","073_1_1","JHN","1","1","1","Ki poone Raa yʼa okkima sulɗi pay geŋ, wedusu an yi waaku Ono yoŋ ede to. Raa kane ti wede an yi waaku Ono geŋ kane soo, wo wede an yi waaku Ono geŋ yoŋ miŋ Raa batum. ");
INSERT INTO moz_vpl VALUES ("JN1_2","073_1_2","JHN","1","2","2","Ki poone Raa yʼa okkima sulɗi pay geŋ, yode ti wede an yi waaku Ono geŋ kane soo. ");
INSERT INTO moz_vpl VALUES ("JN1_3","073_1_3","JHN","1","3","3","Sulɗi ɗoŋ Raa yʼikkima pay geŋ, an ikkima ti wede an yi waaku Ono geŋ soo. Munɗa wede Raa yʼize siidí umbo, daa wede an yi waaku Ono geŋ me. ");
INSERT INTO moz_vpl VALUES ("JN1_4","073_1_4","JHN","1","4","4","Wede an yi waaku Ono geŋ, yoŋ lekkiyo ere ki daayum, wo tode lekkiyo gette ti dʼeliyo toore a ɗuwo. ");
INSERT INTO moz_vpl VALUES ("JN1_5","073_1_5","JHN","1","5","5","Toore geŋ yi-tooriyo adda zimolo, wo zimolo tʼa ki yʼ ziiɗa ye. ");
INSERT INTO moz_vpl VALUES ("JN1_6","073_1_6","JHN","1","6","6","Iŋkino maŋ ti kaaga Raa yʼa igibe wede zindí ki tukki ɗuwo, wedusu geŋ sundí Zaŋ. ");
INSERT INTO moz_vpl VALUES ("JN1_7","073_1_7","JHN","1","7","7","Zaŋ yoŋ wede illiga rabila toore, yʼa iide yʼan di kize urzi toore gen̰n̰o, kono tʼurzi yode ɗuwo pay an dʼolliga, wo an zaape addaŋ a toore gen̰n̰o. ");
INSERT INTO moz_vpl VALUES ("JN1_8","073_1_8","JHN","1","8","8","Yode Zaŋ geŋ toore yode batum ye, yoŋ yʼiide yʼan di kize toore a ɗuwo. ");
INSERT INTO moz_vpl VALUES ("JN1_9","073_1_9","JHN","1","9","9","Yo Wede an yi waaku Ono geŋ, toore wede ki kotto, yʼettiyo kʼadda duniya, yʼa toore adda kʼadde ɗuwo pay. ");
INSERT INTO moz_vpl VALUES ("JN1_10","073_1_10","JHN","1","10","10","Yoŋ geŋ yʼa iido kʼadda duniya, wo duniya ette Raa yʼikkima tʼurzi yode batum. Yʼa likke, wo ɗoŋ duniya an gi di yʼ zuune ye. ");
INSERT INTO moz_vpl VALUES ("JN1_11","073_1_11","JHN","1","11","11","Yʼa tʼiide kʼume ɗoŋzí Izirayel, wo kane an gi di yʼ ziiɗa ye. ");
INSERT INTO moz_vpl VALUES ("JN1_12","073_1_12","JHN","1","12","12","Wo ɗe a kane ɗoŋ i yi ziiɗa wo i ziipe addaŋ a yode geŋ, yʼan dʼele urzi an tʼize in̰n̰i Raa. ");
INSERT INTO moz_vpl VALUES ("JN1_13","073_1_13","JHN","1","13","13","An tʼize in̰n̰i Raa tʼurzi kʼehiyo ere a urzi tudde ye, aa ɗuwo an ki-dehu ye, wo an tʼize in̰n̰i Raa tʼurzi kʼehiyo ere ti toogo Raa. ");
INSERT INTO moz_vpl VALUES ("JN1_14","073_1_14","JHN","1","14","14","Iŋkino maŋ wede an yi waaku Ono geŋ yʼa-gime wedusu, yʼa iido yʼa likke diine kaye, addí ôoniyo ti beeko wo yʼin di kaza urzi wede ɗerec. Ay di wulle goolikadí, goolikadí ere meeda gette i ele Meega Raa a yode Ulí soo ɗaŋŋal. ");
INSERT INTO moz_vpl VALUES ("JN1_15","073_1_15","JHN","1","15","15","Wo Zaŋ geŋ yʼa iise kazita a tukkʼIsa ti golla awwa, yʼede: «En̰n̰o wedusu wede ni rootiyo onamí me, wede nʼede: wede ede ettiyo kʼitadó me, wo yoŋ goole yʼa jiire nuŋ, kono nuŋ an diʼn tʼeha ɓotto geŋ, yoŋ ede to.» ");
INSERT INTO moz_vpl VALUES ("JN1_16","073_1_16","JHN","1","16","16","Yoŋ addíʼŋ tasse ti kine me, yʼin di ziipe beeko ɓaadaŋ ki daayum a kine pay, wo beekadí daayum a ekki kine. ");
INSERT INTO moz_vpl VALUES ("JN1_17","073_1_17","JHN","1","17","17","Oogoro todʼte Raa yi tʼelo ti kaaga tʼurzi Muusa a ɗuwo. Wo ɗe beeko ti ɗerec an iido tʼurzi kʼIsa Almasi. ");
INSERT INTO moz_vpl VALUES ("JN1_18","073_1_18","JHN","1","18","18","Wenɗa soo toŋ i wulle Raa umbo, wo ɗe Ulo yoŋ soo ɗaŋŋal yode batum Raa, yi lekkiyo a sirpa Meega Raa geŋ, yʼin di yʼ gize. ");
INSERT INTO moz_vpl VALUES ("JN1_19","073_1_19","JHN","1","19","19","Kun ollo eŋ ono Zaŋ yi gizite. Onniyo soo deero Yawudiyagi a siiɗo Zeruzalem an dʼigibe ɗoŋ seɗeke ti ɗoŋ ti biza bumɓu Lebi ki tukki Zaŋ. An dʼiide, an dʼuuney Zaŋ kono an di yʼ tonde: «Keeʼŋ wee wee?» ");
INSERT INTO moz_vpl VALUES ("JN1_20","073_1_20","JHN","1","20","20","Aame an iide an yi tunde maŋ, yoŋ yʼan kʼumbida ye, wo yʼan di ruute keren̰, yʼede: «Nuŋ Almasi Raa yi biire ye.» ");
INSERT INTO moz_vpl VALUES ("JN1_21","073_1_21","JHN","1","21","21","Iŋkino maŋ an di yʼ tunde sey, anʼde: «Ɗe keeʼŋ Eli ko?» Maŋ Zaŋ yʼede: «Aha, nuŋ Eli ye.» An di yi tunde sey, anʼde: «Keeʼŋ nebi wede ay delliyo ko?» Zaŋ yʼede: «Aha, nuuno ye.» ");
INSERT INTO moz_vpl VALUES ("JN1_22","073_1_22","JHN","1","22","22","Iŋkino an i di ruute, anʼde: «Keeʼŋ wee wee? Kʼay ti rooti, kono ay an di kizey a ɗoŋ aynʼigibo me. Kee miŋ wee wee?» ");
INSERT INTO moz_vpl VALUES ("JN1_23","073_1_23","JHN","1","23","23","Maŋ Zaŋ yʼan diʼn gime onamaŋ ti ono ɗoŋ nebi Ezayi yi ruute ti kaaga, yʼede: «Nuŋ golla ki wedusu yi ɗollite adda balɗa, yi dʼeesiyo: Urzi Galmeega kun i-ti yʼokkoŋ ki diine ɗelele.» ");
INSERT INTO moz_vpl VALUES ("JN1_24","073_1_24","JHN","1","24","24","A diine ɗoŋ zina an igibe ki tukki Zaŋ geŋ, Pariziyeŋ toŋ adda. ");
INSERT INTO moz_vpl VALUES ("JN1_25","073_1_25","JHN","1","25","25","Kane geŋ an di yi tunde Zaŋ sey, anʼde: «Keeʼŋ Almasi Raa yi biire ye, Eli ye wo nebi wede ay delliyo ye ɗe, ki moo me kiʼni suyyiso ɗuwoʼŋ batem me?» ");
INSERT INTO moz_vpl VALUES ("JN1_26","073_1_26","JHN","1","26","26","Zaŋ yʼan diʼn gime onamaŋ, yʼede: «Nuŋ ɗuwo niʼni suyyiso batem tʼahu, wo ɗe a diinaguŋ geŋ i dʼede wede ede kun ki yʼ suune ye. ");
INSERT INTO moz_vpl VALUES ("JN1_27","073_1_27","JHN","1","27","27","Wede geŋ yʼettiyo kʼitadó, wo nuŋ ni kʼîide nʼa ki tʼeeze sibe toɓiyagí ye.» ");
INSERT INTO moz_vpl VALUES ("JN1_28","073_1_28","JHN","1","28","28","Sulɗizaŋ pay an ize geŋ a ille Betani, ti dar kʼooye Zurden ki kese peeɗo ge-koliyo a ume Zaŋ ɗuwo yʼanni zuyyite batem. ");
INSERT INTO moz_vpl VALUES ("JN1_29","073_1_29","JHN","1","29","29","Soggo maŋ Isa yi-tʼuɗɗo kʼume Zaŋ. Aame Zaŋ yi yʼ wulle maŋ, yʼede: «Kun wollo en̰n̰o Ulo Damu Raa i booyiso olɗiko ɗoŋ duniya pay me. ");
INSERT INTO moz_vpl VALUES ("JN1_30","073_1_30","JHN","1","30","30","Ono ni ruute a tukki yode en̰n̰o, nʼede: “Wede ede yʼettiyo kʼitadó me, wo yoŋ goole yʼa jiire nuŋ, kono nuŋ an di nʼ tʼeha ɓotto geŋ, yoŋ ede to.” ");
INSERT INTO moz_vpl VALUES ("JN1_31","073_1_31","JHN","1","31","31","Ki poone toŋ nuŋ ni ki yʼ suune ye yoŋ wenɗa me, wo nʼiido ɗuwo ni diʼn suyyiso batem tʼahuʼŋ kono nʼan di yʼ kize a ɗoŋ kʼIzirayel.» ");
INSERT INTO moz_vpl VALUES ("JN1_32","073_1_32","JHN","1","32","32","Zaŋ yi kazita a tukkʼIsa sey, yʼede: «Nʼa wulle Unde Raa tʼa ɗiigo ti kandaane aa deere, tʼa di-guune a tuddí. ");
INSERT INTO moz_vpl VALUES ("JN1_33","073_1_33","JHN","1","33","33","Nuŋ ni ki yʼ suune ye, wo Raa wede i nʼigibe ɗuwo ni diʼn suyyiso batem tʼahu geŋ yʼo di ruute, yʼede: “Unde Raa gette kʼa ti wolla tʼa ɗeego ti kandaane, tʼa di koona a tukki wede. Geŋ yode gen̰n̰o wede a suyya ɗuwo ti Unde Kamilen̰ me.” ");
INSERT INTO moz_vpl VALUES ("JN1_34","073_1_34","JHN","1","34","34","Wo munɗa geŋ nʼa yi wulle, wo iŋkino maŋ nʼun di kaza keren̰, wede eŋ yoŋ Ulo Raa.» ");
INSERT INTO moz_vpl VALUES ("JN1_35","073_1_35","JHN","1","35","35","Ti soggatú sey toŋ, Zaŋ ti sanalliyagí ɗoŋ sire geŋ an lekkiyo a umayaŋ. ");
INSERT INTO moz_vpl VALUES ("JN1_36","073_1_36","JHN","1","36","36","Zaŋ geŋ yi wulle Isa yʼ eŋgile maŋ, yʼa ruute yʼede: «En̰n̰o Ulo Damu Raa me.» ");
INSERT INTO moz_vpl VALUES ("JN1_37","073_1_37","JHN","1","37","37","Aame kane sanalliyagi sire geŋ an illiga Zaŋ yi ruute iŋkino maŋ, an dʼiise daaniya kʼIsa. ");
INSERT INTO moz_vpl VALUES ("JN1_38","073_1_38","JHN","1","38","38","Isa yi gilɗe maŋ, yi wolliyoʼŋ an yi daaniya, maŋ yʼanni tunde, yʼede: «Kun ni daaniyaʼŋ kun dehu moo me?» Maŋ kane an i-diʼn gime onamí, anʼde: «Rabbi (i-kaza wede dooyisadey) kee ki lekkiyo a too me?» ");
INSERT INTO moz_vpl VALUES ("JN1_39","073_1_39","JHN","1","39","39","Isa yʼan di ruute, yʼede: «Kunʼdi, kun di-wolley.» Maŋ an dʼiŋgile, an di wullo ume yi-lekkiyo me. Geŋ a peeɗo lohe, umeʼŋ an a-ti yʼiŋgile ti yode. ");
INSERT INTO moz_vpl VALUES ("JN1_40","073_1_40","JHN","1","40","40","Andire leema Simo Piyer geŋ, yoŋ ti diine ɗoŋ sire illiga ono Zaŋ yi ruute wo an di diine Isa gen̰n̰o. ");
INSERT INTO moz_vpl VALUES ("JN1_41","073_1_41","JHN","1","41","41","An ti gimo maŋ, Andire yʼiideʼŋ yʼa uuney ki pooneʼŋ leemadí Simo, wo yi di ruute, yʼede: «Almasi Raa yi biireʼŋ, ay yi wullo.» (Tʼono Girek geŋ Kiris i-kaza Almasi.) ");
INSERT INTO moz_vpl VALUES ("JN1_42","073_1_42","JHN","1","42","42","Maŋ yi-di tʼiide leemadí Simo kʼume kʼIsa. An iiney maŋ, Isa yi di yʼ wolliso ƴerere adda kʼedayí, maŋ yi di ruute, yʼede: «Keeʼŋ Simo ulo ki Zonas, wo ti aŋki eŋ an gi di waaka Piyer.» Suma gette i-kaza mokkolo. ");
INSERT INTO moz_vpl VALUES ("JN1_43","073_1_43","JHN","1","43","44","Onniyo kʼita maŋ Isa yʼa iŋgile ki siiɗo Galile, an dʼikkima ti Pilip wede ti geeger Betsayda, siiɗo kʼAndire ti Piyer. Maŋ Isa yi di ruute a Pilip, yʼede: «Pilip, ki ni daani.» ");
INSERT INTO moz_vpl VALUES ("JN1_45","073_1_45","JHN","1","45","45","Saŋ maŋ Pilip yʼa uuney Natanayel, wo yi di ruute, yʼede: «Ay yi wullo wedusu wede Muusa yʼa ruute adda mattup kʼoogoro, wo nebiyagi toŋ an ruute onamí me. Yoŋ Isa wede ti geeger Nazaret, ulo Yusup.» ");
INSERT INTO moz_vpl VALUES ("JN1_46","073_1_46","JHN","1","46","46","Natanayel yi di ruute, yʼede: «Ti Nazaret ummey, munɗa beehiye etto ɗey ko?» Pilip yi di ruute, yʼede: «Kʼedi, wo kʼa wolla.» ");
INSERT INTO moz_vpl VALUES ("JN1_47","073_1_47","JHN","1","47","47","Aame Isa yi wulle Natanayel yʼette tuddí maŋ, yʼa ruute ono a tukki yode, yʼede: «Ulo kʼIzirayel toc miŋ yode en̰n̰o, yo eŋ wede ki diine.» ");
INSERT INTO moz_vpl VALUES ("JN1_48","073_1_48","JHN","1","48","48","Natanayel yi di ruute, yʼede: «Ɗe kaŋ mummino kʼa ni zuune me?» Isa yi di ruute, yʼede: «Ki poone Pilip yʼa ki waakoʼŋ geŋ, ni ki wulle keeʼŋ a undiso pigiye.» ");
INSERT INTO moz_vpl VALUES ("JN1_49","073_1_49","JHN","1","49","49","Iŋkino maŋ Natanayel yi di ruute, yʼede: «Wede dooyisadó, keeʼŋ Ulo Raa. Keeʼŋ mozigo ɗoŋ kʼIzirayel.» ");
INSERT INTO moz_vpl VALUES ("JN1_50","073_1_50","JHN","1","50","50","Isa yi di ruute, yʼede: «Kee ki ziipe addá a nuŋ kono kʼilliga ni ruute ni ki wulle a undiso pigiye, wo kʼa wolla sulɗi ɓaadaŋ a ceera en̰n̰o sey.» ");
INSERT INTO moz_vpl VALUES ("JN1_51","073_1_51","JHN","1","51","51","Maŋ Isa yi di ruute sey, yʼede: «Ɗerec iŋkino wo nʼun di rooto: Kun di wolla kandaane a-tʼihina, wo maaleekiyagi Raa an di ɗeegita wo an di kilita tʼawwa nuŋ wede an nʼehe aa ulo wede en̰n̰o.» ");
INSERT INTO moz_vpl VALUES ("JN2_1","073_2_1","JHN","2","1","1","Onniyo sire kʼaɗuwe maŋ, i dʼize seeɗu kʼerewo a geeger Kana siiɗo Galile. MekkʼIsa tʼiide, ");
INSERT INTO moz_vpl VALUES ("JN2_2","073_2_2","JHN","2","2","2","wo Isa ti sanalliyagí toŋ anʼni wiike. ");
INSERT INTO moz_vpl VALUES ("JN2_3","073_2_3","JHN","2","3","3","An ize bini maŋ, toote kʼin̰n̰i bin̰ a biite. Iŋkino maŋ mekkʼIsa ti di ruute a ulutúʼŋ, tʼede: «Toote kʼin̰n̰i bin̰ an biite.» ");
INSERT INTO moz_vpl VALUES ("JN2_4","073_2_4","JHN","2","4","4","Maŋ Isa yi di ruute, yʼede: «Meeʼki nuŋ, nuŋ nʼaase mummino? Peeɗadó ti kʼîide ye ɓotto.» ");
INSERT INTO moz_vpl VALUES ("JN2_5","073_2_5","JHN","2","5","5","Iŋkino maŋ todʼ tʼan di ruute ɗoŋ naaboʼŋ, tʼede: «Yʼun ruuta munɗa maŋ, kun tʼiso.» ");
INSERT INTO moz_vpl VALUES ("JN2_6","073_2_6","JHN","2","6","6","Aame geŋ i dʼede ɓoŋgali zoot an tutte ki moŋgali, Yawudiyagi an dʼoɓite ahu adda, an dʼopilsito tuddaŋ, kʼa tʼise kamilen̰ a ɗaana Raa a urzi kʼoogiradaŋ. Ɓukkulu soo geŋ yʼoomi suma toolo sire aɗo. ");
INSERT INTO moz_vpl VALUES ("JN2_7","073_2_7","JHN","2","7","7","Maŋ Isa yʼan di ruute ɗoŋ naabo, yʼede: «Ɓoŋgali geŋ kun tʼôonito tʼahu.» Iŋkino maŋ kane ɗoŋ naabo an iideʼŋ, an tʼûunite ɓoŋgaliʼŋ geŋ pepelele. ");
INSERT INTO moz_vpl VALUES ("JN2_8","073_2_8","JHN","2","8","8","Aame ɓoŋgaliʼŋ an tiʼn ûunite maŋ, Isa yʼede: «Aŋkeŋ kun eesu ahu geŋ, kun i-dʼodo a wede dokkiɗe.» Maŋ kane ɗoŋ naabo an dʼeezi, an i-dʼiide. ");
INSERT INTO moz_vpl VALUES ("JN2_9","073_2_9","JHN","2","9","9","Wede dokkiɗe geŋ yʼan uwwe ahu ɗoŋ i-gime toote kʼin̰n̰i bin̰ geŋ me, wo yi ki suune ye toote yʼettiyo ti tunɗa me, wo ɗoŋ naabo ɗoŋ eeziti ahu geŋ an suune. Wede dokkiɗe yʼa wiike kule kʼerewo, ");
INSERT INTO moz_vpl VALUES ("JN2_10","073_2_10","JHN","2","10","10","wo yi di ruute, yʼede: «Ki pooneʼŋ ɗuwo an eesiyo dokkiɗe ti toote wede kaɗigi, saŋ ɗuwo geŋ i ti koliyo eedaŋ maŋ, an dʼeesiyo wede uŋse ye kʼita. Wo kee kʼa buuhe toote kaɗigi kʼume kʼita.» ");
INSERT INTO moz_vpl VALUES ("JN2_11","073_2_11","JHN","2","11","11","Geŋ iŋkino munɗa kʼarmika wede Isa yʼize ki poone, a Kana siiɗo Galile. Yʼan di gize toogadí, wo tʼurzi geŋ sanalliyagí an di ziipe addaŋ a yode. ");
INSERT INTO moz_vpl VALUES ("JN2_12","073_2_12","JHN","2","12","12","Saŋ maŋ tiŋ geŋ Isa yʼa tʼiiziga, meedí, zemɓadí ti sanalliyagí pay an di-ɗiige ki geeger Kapernayim. A ume geŋ an di likke onniyo miibi. ");
INSERT INTO moz_vpl VALUES ("JN2_13","073_2_13","JHN","2","13","13","Aame tarnaape Pak ki Yawudiyagi aa guute goppoŋ maŋ, Isa yʼa-gili Zeruzalem. ");
INSERT INTO moz_vpl VALUES ("JN2_14","073_2_14","JHN","2","14","14","Yʼiiney maŋ, yi-tʼiide a booro Ɓoy Raa, yi dʼuuney ɗoŋ kʼowilte buŋgari, ki damɓami, ki deere wo ɗoŋ pelkiyto soŋko ere ettiyo ti siiɗiyagi doolo pây, an isiyo suuk adda. ");
INSERT INTO moz_vpl VALUES ("JN2_15","073_2_15","JHN","2","15","15","Iŋkino maŋ yi dʼize karre, yʼan iise lommite. Tʼadda booro Ɓoy Raa yʼa tiʼn tiipe pay ti damɓamzaŋ wo ti buŋgarzaŋ me. Wo taabulyagi ɗoŋ pelkiyto gurus geŋ yʼan di gippirɗe, ti soŋkiyagaŋ a-zibbite. ");
INSERT INTO moz_vpl VALUES ("JN2_16","073_2_16","JHN","2","16","16","Wo a ɗoŋ kʼowilte deere yʼan di ruute, yʼede: «Sulɗuguŋ eŋ pay kun ti sokito tʼeŋ me. Ɓoy Meegó eŋ, kun ti yʼise ume suuk ye.» ");
INSERT INTO moz_vpl VALUES ("JN2_17","073_2_17","JHN","2","17","17","Aame geŋ kane sanalliyagí an dʼilke a ono ɗoŋ an riiŋe ti kaaga adda mattup ki Raa, anʼde: «Geyyiso ere o dʼede kono ɓoy kee Raa gette, nuŋ addó i nʼaaɗumu.» ");
INSERT INTO moz_vpl VALUES ("JN2_18","073_2_18","JHN","2","18","18","Iŋkino maŋ kane deero Yawudiyagi an i di ruute, anʼde: «Kʼay isi munɗa kʼarmika wede a kize kee a-dʼede urzi kʼaase kino.» ");
INSERT INTO moz_vpl VALUES ("JN2_19","073_2_19","JHN","2","19","19","Maŋ Isa yʼan di ruute, yʼede: «Ɓoy Raa eŋ kun di-kossito, wo adda kʼonniyo aɗo nʼa yʼooziga.» ");
INSERT INTO moz_vpl VALUES ("JN2_20","073_2_20","JHN","2","20","20","Kane deero Yawudiyagi an i di ruute, anʼde: «Ɓoy Raa eŋ ɗuwo an iiziga adda kʼozzine ada piɗe makumu zoot miŋ, kee kʼede adda kʼonniyo aɗo maŋ kʼa yʼooziga?» ");
INSERT INTO moz_vpl VALUES ("JN2_21","073_2_21","JHN","2","21","21","Wo Isa yi rootiyo Ɓoy Raa tuddí batum. ");
INSERT INTO moz_vpl VALUES ("JN2_22","073_2_22","JHN","2","22","22","Bini aame Isa yʼinda wo yi-bilɗe maŋ, sanalliyagí an dʼilke a ono ɗoŋ yi ruute geŋ me. Iŋkino an dʼumɓe a ono ɗoŋ an riiŋe ti kaaga adda mattup ki Raa, wo a ono ɗoŋ Isa yi ruute. ");
INSERT INTO moz_vpl VALUES ("JN2_23","073_2_23","JHN","2","23","23","Isa yi lekkiyo a Zeruzalem, a tarnaape Pak ki Yawudiyagi geŋ, yʼaaze sulɗi kʼarmika ɓaadaŋ ɗuwo an di wulle, wo ɗoŋ ɓaadaŋ an di ziipe addaŋ a yode. ");
INSERT INTO moz_vpl VALUES ("JN2_24","073_2_24","JHN","2","24","24","Wo Isa yi ki zaapu addí a kane ye, kono kane pay yiʼni suune. ");
INSERT INTO moz_vpl VALUES ("JN2_25","073_2_25","JHN","2","25","25","Yoŋ geŋ wenɗa yi gi di kize ye a tukki kane me, kono adde ɗuwo pay yoŋ yiʼni suune. ");
INSERT INTO moz_vpl VALUES ("JN3_1","073_3_1","JHN","3","1","1","Aame geŋ i dʼede wedusu sundí Nikodem. Yode geŋ ti diine ɗoŋ sundaŋ Pariziyeŋ, wo ti diine deero Yawudiyagi pay. ");
INSERT INTO moz_vpl VALUES ("JN3_2","073_3_2","JHN","3","2","2","Onniyo soo a diɗɗo maŋ, yʼa iide yʼa uuney Isa, wo yi di ruute, yʼede: «Wede dooyisadey, kaye ay suune keeʼŋ Raa yi-kʼigibo dooyisadey. Wenɗa ti doolo yi kʼaane yi ki tʼise ye sulɗi kʼarmika ɗoŋ aa kee ki dʼisiyo eŋ me, aame Raa ti yode ye maŋ.» ");
INSERT INTO moz_vpl VALUES ("JN3_3","073_3_3","JHN","3","3","3","Isa yi di ruute, yʼede: «Ɗerec iŋkino wo nʼa di rooto: Aame wedeʼŋ yi kʼuune ehiyo ere aware ye maŋ, Moziko Raa yi kʼaane yi ki ti wolley ye.» ");
INSERT INTO moz_vpl VALUES ("JN3_4","073_3_4","JHN","3","4","4","Maŋ Nikodem yi di ruute, yʼede: «Mummino me, wede yi tʼize goole wo an ti yʼ tʼehe sey me? Yʼaane yi-tʼette adda kʼadde meedí, tʼa ti yʼ tʼehe sey ko?» ");
INSERT INTO moz_vpl VALUES ("JN3_5","073_3_5","JHN","3","5","5","Isa yi diʼn gime onamí, yʼede: «Ɗerec iŋkino wo nʼa di rooto: Aame wedeʼŋ yi kʼuune ehiyo ere aware tʼurzi kʼahu wo tʼurzi kʼUnde Raa ye maŋ, Moziko Raa yi kʼaane yi ki tʼettey ye. ");
INSERT INTO moz_vpl VALUES ("JN3_6","073_3_6","JHN","3","6","6","Munɗa wede ettiyo tʼurzi tudde geŋ yoŋ ki tudde, wo wede ettiyo tʼurzi kʼUnde Raa geŋ yoŋ unde. ");
INSERT INTO moz_vpl VALUES ("JN3_7","073_3_7","JHN","3","7","7","Kee kʼelkite ye a ono ɗoŋ nʼa ruute, nʼede: “An un tiʼn eho doolo geŋ me.” ");
INSERT INTO moz_vpl VALUES ("JN3_8","073_3_8","JHN","3","8","8","Kʼelko a maaye wede i baahu gen̰n̰o. Yi baahu kʼume wede aa addí i dehu, kʼa olliga buukayí ɗaŋŋal wo ume yʼettiyo ti tunɗa wo yʼamɓe ki tunɗaʼŋ ki ki suune ye. Geŋ iŋkino ki wede yʼuune ehiyo tʼurzi kʼUnde Raa toŋ maŋ.» ");
INSERT INTO moz_vpl VALUES ("JN3_9","073_3_9","JHN","3","9","9","Maŋ Nikodem yi di ruute a Isa, yʼede: «Ɗe geŋ iŋkino mummino me?» ");
INSERT INTO moz_vpl VALUES ("JN3_10","073_3_10","JHN","3","10","10","Iŋkino maŋ Isa yi diʼn gime onamí, yʼede: «Ɗe keeʼŋ wede dooyiso goole a siiɗo kʼIzirayel, miŋ ono geŋ ki gi diʼn suuniyo ye ko? ");
INSERT INTO moz_vpl VALUES ("JN3_11","073_3_11","JHN","3","11","11","Ɗerec iŋkino wo nʼa di rooto: Kaye ay rootiyo munɗa wede ay suune wo ay kazita munɗa wede ay wulle, wo kun kʼamɓu ye a onamey ɗoŋ ay kazita me. ");
INSERT INTO moz_vpl VALUES ("JN3_12","073_3_12","JHN","3","12","12","Wo aame nʼun rootiyo ti sulɗi ɗoŋ isiyo a siiɗo toŋ kun kʼamɓu ye, ɗe mummino kun dʼamɓa me aame nʼun ruuta ti sulɗi ɗoŋ a kandaane maŋ? ");
INSERT INTO moz_vpl VALUES ("JN3_13","073_3_13","JHN","3","13","13","Wenɗa soo toŋ ti siiɗo a kili kandaane umbo, daa ki nuŋ wede an nʼehe aa ulo wede en̰n̰o, ni ki ɗiigo tʼawwa ye maŋ. ");
INSERT INTO moz_vpl VALUES ("JN3_14","073_3_14","JHN","3","14","14","Aakede ti kaaga aŋ Muusa kane adda balɗa geŋ yi dʼumɓe maala, yʼa tʼikkima miipo, yi dʼittiba mobbo, yʼa-duɗɗe tʼawwa. Geŋ iŋkino, nuŋ wede an nʼehe aa ulo wede en̰n̰o toŋ maŋ, an tiʼn doɗɗa tʼawwa kay, ");
INSERT INTO moz_vpl VALUES ("JN3_15","073_3_15","JHN","3","15","15","kono wede tuuku yi ziipa addí a nuuno maŋ, yʼa tʼoona lekkiyo ere ki daayum. ");
INSERT INTO moz_vpl VALUES ("JN3_16","073_3_16","JHN","3","16","16","Raa geŋ yʼa giyye kine ɗoŋ duniya pay, yʼaa tʼigibo Ulí yoŋ soo ɗaŋŋal ki duniya, kono wede tuuku yi ziipa addí a yode maŋ, yʼa ki tʼinda ye, wo yʼa tʼoona lekkiyo ere ki daayum. ");
INSERT INTO moz_vpl VALUES ("JN3_17","073_3_17","JHN","3","17","17","Raa yʼigibo Ulí ki duniya kono yʼa ki ɗekka booro ekki ɗoŋ duniya ye. Wo ɗe yi yʼigibo kono tʼurzi yode ɗoŋ duniya an dʼutte. ");
INSERT INTO moz_vpl VALUES ("JN3_18","073_3_18","JHN","3","18","18","Wede yi ziipa addí a yode maŋ, booro ti ki yʼ seeɗa ye, wo wede yi ki ziipa addí a yode ye maŋ, booro ti yʼ ziiɗa baa, kono yi ki ziipe addí a suma kʼUlo wede soo ɗaŋŋal ki Raa gen̰n̰o ye. ");
INSERT INTO moz_vpl VALUES ("JN3_19","073_3_19","JHN","3","19","19","Toore yʼa iido adda duniya, wo ɗe tooreʼŋ ɗuwo an di yʼ giigira, an tʼumɓe zimolo kono kane an isiyo naabo ere olɗo. Gen̰n̰o urzi wede booro Raa tʼa seeɗa wede me. ");
INSERT INTO moz_vpl VALUES ("JN3_20","073_3_20","JHN","3","20","20","Iŋkino maŋ wede tuuku yʼisiyo munɗa wede ulsu geŋ, toore yʼa yi kiigira, wo yi kʼette ye ki toore me, kono yʼorgiso a naabo ere yʼisiyo olɗo gette, itadí i tʼaɗɗa. ");
INSERT INTO moz_vpl VALUES ("JN3_21","073_3_21","JHN","3","21","21","Wo wede daayum yʼisiyo naabo ere ɗerec geŋ, yʼa tʼaɗɗe a toore kono ɗuwo an di wolle naabadí ere ɗerec gette, an tʼeese yo eŋ wede Raa kotto.» ");
INSERT INTO moz_vpl VALUES ("JN3_22","073_3_22","JHN","3","22","22","Saŋ maŋ ti Zeruzalem Isa ti sanalliyagí an tʼiiziga, an dʼiŋgile ki siiɗo Ziide. An di-guune aŋgen̰n̰o, wo Isa yi diʼn suyyiso ɗuwo batem. ");
INSERT INTO moz_vpl VALUES ("JN3_23","073_3_23","JHN","3","23","23","Aame geŋ Zaŋ Batis toŋ yi suyyiso pay ɗuwo me a ume sundí Aynoŋ, goppoŋ ti Salim, a ume geŋ ahu ɓaadaŋ. Ɗuwo an dʼettiyo tuddí, yi tiʼn suyyiso batem. ");
INSERT INTO moz_vpl VALUES ("JN3_24","073_3_24","JHN","3","24","24","Aame geŋ yoŋ Zaŋ an ki ti yʼ ziiɗa daŋgay ye ɓotto. ");
INSERT INTO moz_vpl VALUES ("JN3_25","073_3_25","JHN","3","25","25","Iŋkino maŋ onniyo soo i dʼiiziga niikiyo, sanalliyagi Zaŋ ti Yawudusu, a urzi wede mummino wede yʼa tʼise kamilen̰ a ɗaana Raa me. ");
INSERT INTO moz_vpl VALUES ("JN3_26","073_3_26","JHN","3","26","26","Maŋ kane an di yʼuuney Zaŋ me, an i di ruute, anʼde: «Wede dooyisadey, kee ki wollo kay, wede kun di likko ti dar kʼooye Zurden ki kese peeɗo ge-koliyo, kʼa ruutite taayadí geŋ, yode toŋ aŋken̰n̰o ɗuwo yʼanni suyyiso batem kay, wo aŋkeŋ ɗuwo pay an ti dihima tuddí.» ");
INSERT INTO moz_vpl VALUES ("JN3_27","073_3_27","JHN","3","27","27","Maŋ Zaŋ yʼan di ruute, yʼede: «Wede geŋ ti siidí yi kʼaane yi ki tʼoone munɗa ye, daa Raa yi-kʼele ye maŋ. ");
INSERT INTO moz_vpl VALUES ("JN3_28","073_3_28","JHN","3","28","28","Kune toŋ maŋ kuuduguŋ yʼilliga aame ni ruute, nʼede: “Nuŋ Almasi Raa yi biire ye. Nuŋ Raa yi nʼigibo, ni-dʼuugumo a yode.” ");
INSERT INTO moz_vpl VALUES ("JN3_29","073_3_29","JHN","3","29","29","Kun suune, wede i ziiɗa erewo geŋ kulatú yode gen̰n̰o. Wo yo laŋze kule kʼere geŋ yʼa tʼôhira a sirpadí, ulbí uŋse ɓaadaŋ kono yʼa olliga munɗa wede laŋzayí yi roota. Geŋ nuŋ toŋ iŋkino, ulbóʼŋ aase uŋse ɓaadaŋ a di ceere. ");
INSERT INTO moz_vpl VALUES ("JN3_30","073_3_30","JHN","3","30","30","Iŋkino maŋ ɗerec, yode geŋ sundí tʼa ôole, wo suma nuuno a kime kʼita te.» ");
INSERT INTO moz_vpl VALUES ("JN3_31","073_3_31","JHN","3","31","31","Wede i ɗiigo ti kandaane geŋ, yoŋ yi jiire ɗuwo pay. Wo wede a siiɗo geŋ, yoŋ a siiɗo, wo onamí yʼorbe toŋ ki sulɗi ɗoŋ a siiɗo. Wede yi ɗiigo ti kandaane geŋ, yoŋ yi jiire ɗuwo pay. ");
INSERT INTO moz_vpl VALUES ("JN3_32","073_3_32","JHN","3","32","32","Yi kazita ti munɗa wede yi wulle wo yʼilliga, wo wede a amɓe onamí umbo. ");
INSERT INTO moz_vpl VALUES ("JN3_33","073_3_33","JHN","3","33","33","Wo wede yʼumɓe onamí geŋ, yi suune adda kʼaddí Raa yi rootiyo ono ɗoŋ ɗerec. ");
INSERT INTO moz_vpl VALUES ("JN3_34","073_3_34","JHN","3","34","34","Wede Raa yʼigibo eŋ yi rootiyo ono Raa, kono Raa yi elo Unde ere daa dooziyatú. ");
INSERT INTO moz_vpl VALUES ("JN3_35","073_3_35","JHN","3","35","35","Meega Raa geŋ Ulí yi yʼ giyye, yi-dʼele sulɗi pay a beezí. ");
INSERT INTO moz_vpl VALUES ("JN3_36","073_3_36","JHN","3","36","36","Wo wede yʼela addí a Ulo Raa maŋ, yʼa tʼoona lekkiyo ere ki daayum. Wo wede yi-tuuga zaapu kʼaddí a Ulo Raa maŋ, lekkiyo gette yi ki ti tʼoona ye, wo kulkuwo Raa tʼa koona eedí. ");
INSERT INTO moz_vpl VALUES ("JN4_1","073_4_1","JHN","4","1","1","Isa geŋ yʼa zuune Pariziyeŋ an illiga ɗuwo an rootiyo anʼde, ɗoŋ ɓaadaŋ yi-tiʼn isiyo sanalliyagi, wo yʼa-tiʼn suyyiso batem i ceeriyo ɗoŋ ki Zaŋ, ");
INSERT INTO moz_vpl VALUES ("JN4_2","073_4_2","JHN","4","2","2","wo kaciŋ yo Isa geŋ ɗuwo iʼni suyyiso batem yode ye, iʼni suyyiso batem sanalliyagí. ");
INSERT INTO moz_vpl VALUES ("JN4_3","073_4_3","JHN","4","3","3","Iŋkino maŋ yʼa tʼiiziga ti siiɗo Ziide, yʼa-gime ki siiɗo Galile. ");
INSERT INTO moz_vpl VALUES ("JN4_4","073_4_4","JHN","4","4","4","Wo ki Galile geŋ, i dehu yʼa aɗɗe ti siiɗo Samari. ");
INSERT INTO moz_vpl VALUES ("JN4_5","073_4_5","JHN","4","5","5","Maŋ yʼa iiney a Sisar, geeger ki Samari goppoŋ ti doome wede Yakup yi-ele a ulí Yusup ti kaaga. ");
INSERT INTO moz_vpl VALUES ("JN4_6","073_4_6","JHN","4","6","6","A ume geŋ i dʼede osso Yakup yʼittiba. Isa yʼiziro kee, yʼiina a ume gen̰n̰o maŋ, yʼurme yʼa-guune biza kʼosso gettiyo a peeɗo tʼize diine. ");
INSERT INTO moz_vpl VALUES ("JN4_7","073_4_7","JHN","4","7","8","Aame Isa yi-guune biza kʼosso yi puukiyo geŋ, kane sanalliyagí an tʼiide kʼadda geeger an di deho munɗa kʼomɓo, maŋ i dʼiido erewo tʼadda kʼille eesiyo kʼahu. Erewo gette Samariten. Maŋ Isa yʼa ti tunde, yʼede: «Erewo no, mʼo kʼeeli ahu, ni-ki siɓe ɗo.» ");
INSERT INTO moz_vpl VALUES ("JN4_9","073_4_9","JHN","4","9","9","Iŋkino maŋ todʼerewo ti di ruute, tʼede: «Mummino, kee Yawudusu ɗe ki tondiyo ahu soɓo a bey nuŋ Samaritenowo me?» Ki too maŋ kane Yawudiyagi an ki dehu an ki tʼokkiƴe ye ti Samariten me. ");
INSERT INTO moz_vpl VALUES ("JN4_10","073_4_10","JHN","4","10","10","Isa yi di ruute, yʼede: «Aame koŋ mi yʼ suune munɗa wede Raa yʼeliyo, wo wede i kin tondiyo ahu soɓo me maŋ, a tonde ahu soɓo miŋ koŋ a bey yoŋ me, wo yʼaane yi di tʼeele ahu ɗoŋ i dʼeliyo lekkiyo.» ");
INSERT INTO moz_vpl VALUES ("JN4_11","073_4_11","JHN","4","11","11","Iŋkino maŋ erewo ti di ruute, tʼede: «Wede no, kee a-kʼede dara ye, wo osso sohoro ɗe kʼa tʼoona ahu ɗoŋ i dʼeliyo lekkiyo ti too me? ");
INSERT INTO moz_vpl VALUES ("JN4_12","073_4_12","JHN","4","12","12","Kunuŋ kee kʼelkiyo ki ceere mugiyey wede ti kaaga Yakup, wede ay iili osso ettiyo ko? Yode batum yʼa iiɓe, in̰n̰izí wo ti maaladí pay me.» ");
INSERT INTO moz_vpl VALUES ("JN4_13","073_4_13","JHN","4","13","13","Isa yi di ruute, yʼede: «Wede tuuku yʼiiɓa ahu kʼosso en̰n̰o maŋ, ôrme yʼa yi seeɗa sey. ");
INSERT INTO moz_vpl VALUES ("JN4_14","073_4_14","JHN","4","14","14","Wo wede yʼiiɓa ahu ɗoŋ nuŋ ni-tʼela maŋ, ôrme yi ki yʼ seeɗa ye baa. Ahu ɗoŋ nuŋ ni-tʼela eŋ, a yode i di tʼisa aa ersa kʼahu okko i di tʼela lekkiyo ere ki daayum.» ");
INSERT INTO moz_vpl VALUES ("JN4_15","073_4_15","JHN","4","15","15","Iŋkino maŋ erewo ti di ruute, tʼede: «Wede no, ahu geŋ kʼo eeli kono ôrme yʼa ki nʼ seeɗa ye baa, wo nʼa kʼetto eesiyo ye.» ");
INSERT INTO moz_vpl VALUES ("JN4_16","073_4_16","JHN","4","16","16","Maŋ Isa yi di ruute, yʼede: «Mʼodo, mi waaki kulayí, kun tʼedi.» ");
INSERT INTO moz_vpl VALUES ("JN4_17","073_4_17","JHN","4","17","17","Erewo ti di ruute, tʼede: «Nuŋ daa kulayó.» Isa yi di ruute, yʼede: «Koŋ onamí ɗerec, mi rootiyo kulayí umbo me. ");
INSERT INTO moz_vpl VALUES ("JN4_18","073_4_18","JHN","4","18","18","Koŋ mi ziɗɗe kuuli paat, wo wede kun lekkiyo aŋken̰n̰o eŋ kulayí ye. Mi ruute ɗerec.» ");
INSERT INTO moz_vpl VALUES ("JN4_19","073_4_19","JHN","4","19","19","Iŋkino maŋ erewo ti di ruute, tʼede: «Galmeegó, nuŋ ni wolliyo maŋ, kee eŋ nebi. ");
INSERT INTO moz_vpl VALUES ("JN4_20","073_4_20","JHN","4","20","20","Ti kaaga moŋgiɗagey Samariten an uttile a Raa ekki mokkolo ettiyo, wo kune Yawudiyagi kunʼde ume kʼottilso a Raa a Zeruzalem.» ");
INSERT INTO moz_vpl VALUES ("JN4_21","073_4_21","JHN","4","21","21","Isa yi di ruute, yʼede: «Erewo no, mʼamɓo onamó, saŋ onniyo tʼaana, aame geŋ kun kʼottila a Meega Raa ekki mokkolo ettiyo ye, wo a Zeruzalem ye. ");
INSERT INTO moz_vpl VALUES ("JN4_22","073_4_22","JHN","4","22","22","Kune Samariten kun ottilso a Raa wede kun ki yʼ suune ye, wo kaye Yawudiyagi ay ottilso a Raa wede ay yi suune, kono wede a utta ɗuwo yʼettiyo ti di Yawudiyagi. ");
INSERT INTO moz_vpl VALUES ("JN4_23","073_4_23","JHN","4","23","23","Wo onniyo gette saŋ tʼaana, wo todʼtiŋ tʼiina, ɗoŋ ottilso a Meega tʼaddaŋ soo geŋ, an i-dʼottila ti toogo kʼUnde Raa wo aa Raa yi dehu, kono Meega yi dehu ɗoŋ ottilso iŋkino. ");
INSERT INTO moz_vpl VALUES ("JN4_24","073_4_24","JHN","4","24","24","Raa yoŋ unde, wo ɗoŋ ottilso a yode geŋ an i-dʼottile ti toogo kʼUnde Raa wo tʼadde soo.» ");
INSERT INTO moz_vpl VALUES ("JN4_25","073_4_25","JHN","4","25","25","Maŋ erewo ti di ruute, tʼede: «Nuŋ ni suune Almasi Raa yi biire saŋ yʼa etto (wede an yi waaku tʼono Girek Kiris) wo aame yʼiina maŋ, sulɗi pay yʼay tiʼn kizita.» ");
INSERT INTO moz_vpl VALUES ("JN4_26","073_4_26","JHN","4","26","26","Isa yi di ruute, yʼede: «Nuŋ wede i rootiyo eŋ miŋ Almasi.» ");
INSERT INTO moz_vpl VALUES ("JN4_27","073_4_27","JHN","4","27","27","Iŋkino maŋ sanalliyagi kʼIsa an aa dʼiina, wo an ziiɗa giggiraŋ aame an wulle Isa yi rootiyto tʼerewo gettiyo maŋ, wo wenɗa soo toŋ ti diinayaŋ yi di roote umbo: «Ɗe ki dehu moo me ti bey kʼerewo?» kunuŋ, «Kun rootiyto tʼerewo moo me?» me. ");
INSERT INTO moz_vpl VALUES ("JN4_28","073_4_28","JHN","4","28","28","Iŋkino maŋ erewo ti dʼiili toolatú a biza kʼosso, todʼ tʼa ukke kʼadda geeger, tʼiideʼŋ tʼan di ruuto ɗuwo, tʼede: ");
INSERT INTO moz_vpl VALUES ("JN4_29","073_4_29","JHN","4","29","29","«Kun okki, kun wolla wenɗa en̰n̰o kay, yʼo-tʼiɗɗipe itadó a sulɗi ɗoŋ nʼize pay me. Yode eŋ aasa Almasi Raa yi biire koo maŋ!» ");
INSERT INTO moz_vpl VALUES ("JN4_30","073_4_30","JHN","4","30","30","Maŋ tʼadda geeger ɗuwo an di dihimo kʼume kʼIsa. ");
INSERT INTO moz_vpl VALUES ("JN4_31","073_4_31","JHN","4","31","31","Aame erewo tʼiŋgile maŋ kane sanalliyagi an i-di ruute, anʼde: «Wede dooyisadey, kʼedi ki ooma ɗo.» ");
INSERT INTO moz_vpl VALUES ("JN4_32","073_4_32","JHN","4","32","32","Wo yoŋ yʼan di ruute, yʼede: «Nuŋ omɓadó ede, wo kune kun ki ti suune ye.» ");
INSERT INTO moz_vpl VALUES ("JN4_33","073_4_33","JHN","4","33","33","Maŋ kane sanalliyagi an di rootiso tuddaŋ, anʼde: «Kunuŋ omɓo wenɗa yi-tʼeeley ko?» ");
INSERT INTO moz_vpl VALUES ("JN4_34","073_4_34","JHN","4","34","34","Isa yʼan di ruute, yʼede: «Omɓadó te isiyo naabo ki wede i nʼigibo yi dehu, wo nʼa-ti ɗaŋge naabo ere yʼo elo.» ");
INSERT INTO moz_vpl VALUES ("JN4_35","073_4_35","JHN","4","35","35","Isa yʼan di ruute sey, yʼede: «Ɗuwo an rootiyo, anʼde: “Adda tere piɗe aasa kʼayɗu kollo.” Wo kun ollo, nuŋ nʼun di rooto, kun amɓo edaguŋ, kun wollo domɓi an iine kʼayɗu. ");
INSERT INTO moz_vpl VALUES ("JN4_36","073_4_36","JHN","4","36","36","Wede ayɗu geŋ ran̰n̰adí yʼa ti tʼoone, wo in̰n̰i yʼa-tʼokume a lekke ki lekkiyo ere ki daayum, kono wede yi giira ti wede iyɗa geŋ, kane miŋ pay ulbaŋ uŋse. ");
INSERT INTO moz_vpl VALUES ("JN4_37","073_4_37","JHN","4","37","37","Iŋkino maŋ ono an rootiyo geŋ ɗerec: “Wede sooʼŋ ki korso wo wede sooʼŋ kʼayɗu me.” ");
INSERT INTO moz_vpl VALUES ("JN4_38","073_4_38","JHN","4","38","38","Nuŋ, nʼun igibe ayɗu kʼadda doome wede kune kun ki niibe ye, i dibire ɗoŋ doolo, wo kun aa di-guune a ran̰n̰adaŋ.» ");
INSERT INTO moz_vpl VALUES ("JN4_39","073_4_39","JHN","4","39","39","Iŋkino maŋ kane Samariten ɗoŋ ti geeger gette, ɗoŋ ɓaadaŋ an di ziipe addaŋ a Isa a ono kʼerewo tʼan ruute, tʼede: «Isa yi-tʼiiɗiba ita a sulɗi ɗoŋ pay tʼize geŋ me.» ");
INSERT INTO moz_vpl VALUES ("JN4_40","073_4_40","JHN","4","40","40","Geŋ iŋkino kane Samariten geŋ an iina aame kʼIsa maŋ, an di yʼ tommiyo, anʼde yʼa lekke ti kane. Maŋ yoŋ yi dʼize onniyo sire ti kane me. ");
INSERT INTO moz_vpl VALUES ("JN4_41","073_4_41","JHN","4","41","41","A onniyto gette Isa yʼan diʼn duuye, wo a dooyisadí gette ɗoŋ ɓaadaŋ a jiire sey an di ziipe addaŋ a yode, a onamí ɗoŋ yʼan gizite me. ");
INSERT INTO moz_vpl VALUES ("JN4_42","073_4_42","JHN","4","42","42","Iŋkino maŋ kane Samariten an i di ruute a erewo, anʼde: «Kaye ay ziipe addey a Isa a ono ɗoŋ ay illiga kuudey, a ono ɗoŋ koŋ mʼay ruute ɗaŋŋal ye. Aŋkeŋ ay zuune ki kotto yoŋ Wede kʼUttiyo ɗoŋ duniya pay.» ");
INSERT INTO moz_vpl VALUES ("JN4_43","073_4_43","JHN","4","43","43","Aame Isa yi ize onniyo sire a Samari maŋ, tiŋ geŋ yʼa tʼiiziga, yʼa iŋgile ki Galile. ");
INSERT INTO moz_vpl VALUES ("JN4_44","073_4_44","JHN","4","44","44","Yode batum yʼa ruute, yʼede: «Ɗerec, nebi geŋ ɗoŋ a geeger yʼa ihira ɗaŋŋal, onamí an kʼolliga ye me.» ");
INSERT INTO moz_vpl VALUES ("JN4_45","073_4_45","JHN","4","45","45","Wo aame yʼiiney Galile maŋ, kaciŋ kane ɗoŋ siiɗo geŋ an di yʼ ziiɗa bey sire, kono kane toŋ maŋ an iide tarnaape Pak ki Yawudiyagi a Zeruzalem me, wo an wullo sulɗi ɗoŋ pay Isa yʼize a onniyo tarnaape geŋ me. ");
INSERT INTO moz_vpl VALUES ("JN4_46","073_4_46","JHN","4","46","46","Saŋ maŋ Isa yʼa-gime ki Kana geeger ki siiɗo Galile, a ume wede ahu yʼa tiʼn gime toote kʼin̰n̰i bin̰ gen̰n̰o. A geeger Kapernayim i dʼede wede goole adda kʼakuuma, ulí tuddí eeni yʼunto. ");
INSERT INTO moz_vpl VALUES ("JN4_47","073_4_47","JHN","4","47","47","Aame yʼilliga Isa ti Ziide yʼiina Galile maŋ, yʼa tʼiiziga, yʼa iide, yʼa yʼuuney, wo yi di tommiyo, yʼede: «Galmeeʼki nuŋ, kʼedi in ti ɗeege Kapernayim. Ulo nuŋ tuddí eeni yʼunto, ki di tʼeley bee.» ");
INSERT INTO moz_vpl VALUES ("JN4_48","073_4_48","JHN","4","48","48","Maŋ Isa yi di ruute, yʼede: «Kune ɗuwo eŋ, aame kun ki wulla sulɗi kʼarmika ye maŋ, kun ki zaapa adduguŋ a Raa ye.» ");
INSERT INTO moz_vpl VALUES ("JN4_49","073_4_49","JHN","4","49","49","Wo yo wede goole geŋ yi-koɗɗime, yi dʼeesiyo: «Galmeeʼki nuŋ, in ti ɗeege kotok, kono ulo nuŋ yʼunto.» ");
INSERT INTO moz_vpl VALUES ("JN4_50","073_4_50","JHN","4","50","50","Isa yi di ruute, yʼede: «Ki-kama, ulá yʼuune bee.» Maŋ wede geŋ yʼa umɓe a ono ɗoŋ Isa yi-ruute, wo yʼa-gime. ");
INSERT INTO moz_vpl VALUES ("JN4_51","073_4_51","JHN","4","51","51","Aame yoŋ a urzi geŋ, ɗoŋ naabadí an aa di yʼikkima, an i di ruute, anʼde: «Ulá yʼuune bee.» ");
INSERT INTO moz_vpl VALUES ("JN4_52","073_4_52","JHN","4","52","52","Maŋ yoŋ yʼanni tunde, yʼede: «A peeɗo tʼize muno ulo yʼuune bee me?» Maŋ kane an di ruute, anʼde: «Loho a peeɗo ti dihima gollatú, ooriyo ti yʼiili me.» ");
INSERT INTO moz_vpl VALUES ("JN4_53","073_4_53","JHN","4","53","53","Maŋ yo meekʼulo geŋ yʼa zuune adda kʼaddí peeɗo gettiŋ a-tʼîide a peeɗo ere loho Isa yi di ruute, yʼede: «Ki-kama, ulá yʼuune bee.» Iŋkino maŋ ti onniyo gettiyo yode ti ɗoŋ ɓoozí pay an di ziipe addaŋ a Isa. ");
INSERT INTO moz_vpl VALUES ("JN4_54","073_4_54","JHN","4","54","54","Geŋ munɗa kʼarmika wede ki sirwe Isa yʼize a kamadí ti Ziide siiɗo Galile. ");
INSERT INTO moz_vpl VALUES ("JN5_1","073_5_1","JHN","5","1","1","Bini maŋ tarnaape ki Yawudiyagi yʼa uɗɗe a Zeruzalem, wo Isa toŋ yʼa gili. ");
INSERT INTO moz_vpl VALUES ("JN5_2","073_5_2","JHN","5","2","2","Wo a Zeruzalem geŋ, goppoŋ ti biza bumɓu wede damɓami an dʼaɗɗiya, i dʼede togile kʼahu tʼono ɗoŋ kʼEber an yi waaku Betzata. A biza togile geŋ an dʼize daabagi deero paat.  ");
INSERT INTO moz_vpl VALUES ("JN5_3","073_5_3","JHN","5","3","3","Adda daabagi geŋ ɗoŋ kʼeeni ɓaadaŋ moonite. Oŋgoŋ koŋzayi, ɗoŋ oŋgoŋ zoŋɗaŋ unto, muŋkilagi pay an delliyo eesiyo kolzite kʼahu, ");
INSERT INTO moz_vpl VALUES ("JN5_4","073_5_4","JHN","5","4","4","kono ume muno maŋ maaleeka Galmeega yi-ti ɗeegu adda kʼahu yi diʼn korre. Maŋ wede kʼeeni wede i ti ɗeegu ki poone geŋ, yi dʼooniyo bee ise ita kʼeenizí tuuku toŋ maŋ. ");
INSERT INTO moz_vpl VALUES ("JN5_5","073_5_5","JHN","5","5","5","Aame geŋ i dʼede wede kʼeeni, tʼume eeni yi yi ziiɗa geŋ i-dʼede ozzine ada gʼaɗo makumu gessire. ");
INSERT INTO moz_vpl VALUES ("JN5_6","073_5_6","JHN","5","6","6","Aame Isa yʼiiney aame gen̰n̰o maŋ, yʼa yi wulle wede geŋ kaŋ moone, wo yʼa zuune eenizí ti kaagine me. Maŋ yʼa yi tunde, yʼede: «Kee ki dehu kʼa tʼoone bee ko?» ");
INSERT INTO moz_vpl VALUES ("JN5_7","073_5_7","JHN","5","7","7","Maŋ wede kʼeeni yʼede: «Galmeeʼki nuŋ, ki nuŋ oo dʼede wee wee i-tiʼn seɗɗe adda kʼahu me? Aame ahu an eesiyo kolzite, nʼeesiyo moykiso maŋ, wede doolo yi-ti ɗeegu.» ");
INSERT INTO moz_vpl VALUES ("JN5_8","073_5_8","JHN","5","8","8","Iŋkino maŋ Isa yi di ruute, yʼede: «Ki tʼoozo, ki tʼamɓo zaaɗayá, kʼa eŋgilo!» ");
INSERT INTO moz_vpl VALUES ("JN5_9","073_5_9","JHN","5","9","9","A kaamiki geŋ wede yʼa uune bee, yʼa tʼumɓe zaaɗayí, yi-sooru yʼa iŋgile. Wo onniyo gette onniyo ere ki puukiyo Yawudiyagi. ");
INSERT INTO moz_vpl VALUES ("JN5_10","073_5_10","JHN","5","10","10","Wede geŋ kane deero Yawudiyagi an yi wulle yʼuune bee me, maŋ an i-di ruute, anʼde: «Aŋki onniyo ere ki puukiyadiŋ. A urzi kʼoogiradiŋ a-kʼede urzi ki sarkiya zaaɗe beezá ye.» ");
INSERT INTO moz_vpl VALUES ("JN5_11","073_5_11","JHN","5","11","11","Maŋ yoŋ yʼan di ruute, yʼede: «Wede o ele beeko geŋ yʼede: “Ki tʼamɓo zaaɗayá, kʼa eŋgilo.”» ");
INSERT INTO moz_vpl VALUES ("JN5_12","073_5_12","JHN","5","12","12","Maŋ kane an di yʼ tunde, anʼde: «A-ruute iŋkino wee wee: “Ki tʼamɓo zaaɗayá, kʼa eŋgilo” me?» ");
INSERT INTO moz_vpl VALUES ("JN5_13","073_5_13","JHN","5","13","13","Wo wede uune bee geŋ yi ki yʼ zuune ye wede i-ele beeko me, kono yo Isa yʼa-ti digge adda diine ɗoŋ duuru aŋgen̰n̰o. ");
INSERT INTO moz_vpl VALUES ("JN5_14","073_5_14","JHN","5","14","14","Kʼita maŋ, wede geŋ Isa yʼa yʼuune adda booro Ɓoy Raa. Maŋ yi di ruute, yʼede: «Kʼollo, aŋkeŋ kʼuune bee, wo kʼita kʼisa olɗiko ye, para maŋ a-dʼaana munɗa wede ulsu a ceera en̰n̰o sey.» ");
INSERT INTO moz_vpl VALUES ("JN5_15","073_5_15","JHN","5","15","15","Maŋ yo wede geŋ yʼiide, yʼan di gize deero Yawudiyagi, yʼede: «Kaciŋ o ele beeko Isa.» ");
INSERT INTO moz_vpl VALUES ("JN5_16","073_5_16","JHN","5","16","16","Iŋkino maŋ ti onniyo gettiyo kane deero Yawudiyagi an dʼiise gerɗiyo kʼIsa, kono yi ele beeko a wedusu a onniyo ere ki puukiyo Yawudiyagi me. ");
INSERT INTO moz_vpl VALUES ("JN5_17","073_5_17","JHN","5","17","17","Maŋ Isa yʼan di ruute, yʼede: «Ette naabo ere Meegó yi dʼisiyo daayum bini aŋken̰n̰o. Nuŋ toŋ maŋ, nʼa naabe.» ");
INSERT INTO moz_vpl VALUES ("JN5_18","073_5_18","JHN","5","18","18","Aame deero Yawudiyagi an illiga iŋkino maŋ, an dʼiise dehutu kʼurzi ki tôwwadí, kono yʼa ti diipiɗa a oogoro kʼonniyo ere ki puukiyo, wo ki sirwe yʼa ruute sey, yʼede Raa Meegí, yi-tʼize tuddí aa Raa batum. ");
INSERT INTO moz_vpl VALUES ("JN5_19","073_5_19","JHN","5","19","19","Isa yʼan di ruute sey, yʼede: «Ɗerec iŋkino wo nʼun di rooto: Nuŋ Ulo eŋ munɗa ti suma nuuno kʼeedó ni kʼisiyo ye. Wo munɗa wede nʼisiyo geŋ ni wolliyo ki Meega yʼisiyo. Munɗa wede Meega yʼisiyo geŋ, nuŋ Ulo toŋ ni dʼisiyo kay. ");
INSERT INTO moz_vpl VALUES ("JN5_20","073_5_20","JHN","5","20","20","Ɗerec, Meega yi giyye nuŋ Ulo geŋ, yʼo-di gizite sulɗi pay ɗoŋ yoŋ yʼisiyo me. Sulɗi ɗoŋ yʼo kizita a ceera ɗoŋ en̰n̰o sey, wo kune kun seeɗa giggirguŋ. ");
INSERT INTO moz_vpl VALUES ("JN5_21","073_5_21","JHN","5","21","21","Wo aa Meega yi balɗiya ɗoŋ i tʼinda wo yʼan dʼeliyo lekkiyo geŋ, nuŋ Ulo toŋ ni dʼeliyo lekkiyo a ɗuwo ɗoŋ aa addó i dehu. ");
INSERT INTO moz_vpl VALUES ("JN5_22","073_5_22","JHN","5","22","22","Meega geŋ yi ki ɗekkiyo booro a tukki wenɗa ye, yoŋ yʼo elo urzi ɗekkiyo booro a nuŋ Ulo, ");
INSERT INTO moz_vpl VALUES ("JN5_23","073_5_23","JHN","5","23","23","iŋkino ɗuwo pay an tʼimme nuŋ Ulo, aa an tamma Meega. Wo wede yi ki tamma nuŋ Ulo ye maŋ, geŋ aa Meega wede i nʼigibo yi ki yʼ tamma ye. ");
INSERT INTO moz_vpl VALUES ("JN5_24","073_5_24","JHN","5","24","24","Ɗerec iŋkino wo nʼun di rooto: Wede yʼilliga onamó wo yi ziipa addí a wede i nʼigibo maŋ, yoŋ geŋ yʼuune lekkiyo ere ki daayum. Booro ti ki yʼ seeɗa ye, yi tʼuɗɗe tʼurzi kʼunto me, yʼuune lekkiyo. ");
INSERT INTO moz_vpl VALUES ("JN5_25","073_5_25","JHN","5","25","25","Ɗerec iŋkino wo nʼun di rooto: Onniyo tʼaana wo todʼtiŋ tʼiina. Kane ɗoŋ a ɗaana Raa aa an tʼinda geŋ, an dʼolliga golla nuŋ Ulo Raa, wo ɗoŋ illiga golladó maŋ an di lekka ki daayum. ");
INSERT INTO moz_vpl VALUES ("JN5_26","073_5_26","JHN","5","26","26","Wo aa Meega i-dʼede toogo kʼeliyo lekkiyo a ɗuwo geŋ, a nuŋ Ulo toŋ maŋ yʼo dʼele toogo kʼeliyo lekkiyo a ɗuwo kay. ");
INSERT INTO moz_vpl VALUES ("JN5_27","073_5_27","JHN","5","27","27","Ɗerec, nuŋ wede an nʼehe aa ulo wede eŋ, yʼo dʼele toogo ki ɗekkiyo booro. ");
INSERT INTO moz_vpl VALUES ("JN5_28","073_5_28","JHN","5","28","28","Iŋkino maŋ ulbuguŋ i tʼooɗe ye a ono geŋ me, kono onniyo saŋ tʼaana, wo ɗoŋ pay adda muuziyagi an dʼolliga golladó, wo an di-balɗa. ");
INSERT INTO moz_vpl VALUES ("JN5_29","073_5_29","JHN","5","29","29","Aame geŋ ɗoŋ ize beehiyeʼŋ an di-balɗa, an tʼoona lekkiyo, wo ɗoŋ ize olɗiko an di-balɗa, booro tʼanni seeɗa. ");
INSERT INTO moz_vpl VALUES ("JN5_30","073_5_30","JHN","5","30","30","Nuŋ munɗa ti suma nuuno kʼeedó ni kʼaane ni kʼise ye, ni ɗekkiyo booro nʼollige ti golla Meega Raa. Wo booro ere ni ɗekkiyo gette ki diine, kono ni ki dehu nʼa kʼise munɗa wede aa addó i dehu ye, nʼaase munɗa wede aa wede yi nʼigibo yi dehu.» ");
INSERT INTO moz_vpl VALUES ("JN5_31","073_5_31","JHN","5","31","31","Isa yʼa ruute sey, yʼede: «Aame nuŋ batum nʼa kizite ono a tukki nuŋ batum maŋ, onamó ɗuwo an kʼamɓe ye. ");
INSERT INTO moz_vpl VALUES ("JN5_32","073_5_32","JHN","5","32","32","Wo i kazita a tukki nuŋ wede doolo, wo ni suune onamí ɗoŋ yi kazita a tukki nuŋ geŋ ɗerec. ");
INSERT INTO moz_vpl VALUES ("JN5_33","073_5_33","JHN","5","33","33","Kune kun dʼigibe ɗoŋ zina ki tukki Zaŋ Batis, wo yoŋ yʼun di gizite ono ɗoŋ ɗerec a tukki nuŋ. ");
INSERT INTO moz_vpl VALUES ("JN5_34","073_5_34","JHN","5","34","34","Wo ki nuŋ, ni ki dehu wedusu ye a kizite ono a tukki nuŋ me, wo ni rootiyo iŋkino kono ni dehu kune kun dʼutte. ");
INSERT INTO moz_vpl VALUES ("JN5_35","073_5_35","JHN","5","35","35","Zaŋ geŋ yoŋ aa biŋge oyyiso i tooriyo, wo kune kun dʼiyye kun dʼize uŋsuwo ti yode kʼonniyo miibi a toorayí. ");
INSERT INTO moz_vpl VALUES ("JN5_36","073_5_36","JHN","5","36","36","Zaŋ yi gizite ono a tukki nuŋ, wo nuŋ o dʼede sulɗi ɓaadaŋ ti doolo sey a jiire ɗoŋ Zaŋ yi gizite. Ɗerec, naabo ere Meega yʼo elo, ere ni dʼisiyo ettiyo batum, ti kazita a tukki nuŋ, wo i-kaza i nʼigibo Meega. ");
INSERT INTO moz_vpl VALUES ("JN5_37","073_5_37","JHN","5","37","37","Wo Meega wede i nʼigibo toŋ, yode batum yʼa gizite a tukki nuŋ. Yoŋ wede kun kʼilliga golladí ye, kun ki wulle ume kʼedayí ye, ");
INSERT INTO moz_vpl VALUES ("JN5_38","073_5_38","JHN","5","38","38","wo onamí i ki lekkiyo adda kʼadduguŋ ye, kono kun ki ziipe adduguŋ a nuŋ wede yʼigibo ye. ");
INSERT INTO moz_vpl VALUES ("JN5_39","073_5_39","JHN","5","39","39","Kun dooyiso ɓaadaŋ ono ɗoŋ an riiŋe ti kaaga adda mattup ki Raa, kono kun elkiyo ti kane geŋ miŋ kun tʼoona lekkiyo ere ki daayum. Ɗe kane geŋ miŋ an kazita a tukki nuuno. ");
INSERT INTO moz_vpl VALUES ("JN5_40","073_5_40","JHN","5","40","40","Wo kune kun ki dehu kun ki dʼetto tuddó, kun ki tʼoone uttiyo ye. ");
INSERT INTO moz_vpl VALUES ("JN5_41","073_5_41","JHN","5","41","41","Nuŋ ni ki dehu tamma ere ettiyo tʼurzi ɗuwo ye. ");
INSERT INTO moz_vpl VALUES ("JN5_42","073_5_42","JHN","5","42","42","Kune nʼunni suune, geyyiso Raa a adduguŋ umbo. ");
INSERT INTO moz_vpl VALUES ("JN5_43","073_5_43","JHN","5","43","43","Nuŋ nʼiidoʼŋ ti suma Meegó, wo kun gi diʼn ziiɗa ye. Wo wede doolo yʼa etto ti suma yode geŋ, kun di yʼ seeɗa bey sire. ");
INSERT INTO moz_vpl VALUES ("JN5_44","073_5_44","JHN","5","44","44","Kune kun dehu ɗuwo an un diʼn tʼimme, wo tamma ere ettiyo ti Raa soo ɗaŋŋal kun ki ti dehu ye. Ɗe kun zaape adduguŋ a nuŋ mummino? ");
INSERT INTO moz_vpl VALUES ("JN5_45","073_5_45","JHN","5","45","45","Kun elke ye unni sakiyey a ɗaana Meega nuuno me, unni sakiyey Muusa yode wede kune kun di ziipe elkisaguŋ gen̰n̰o. ");
INSERT INTO moz_vpl VALUES ("JN5_46","073_5_46","JHN","5","46","46","Aame kun ziipe adduguŋ a Muusa kotto maŋ, a nuuno toŋ maŋ kun zaape adduguŋ, kono yoŋ yi riiŋe miŋ a tukki nuuno. ");
INSERT INTO moz_vpl VALUES ("JN5_47","073_5_47","JHN","5","47","47","Wo aame ono ɗoŋ Muusa yi riiŋe geŋ kun kʼumɓe ye maŋ, kun dʼamɓe onamó mummino?» ");
INSERT INTO moz_vpl VALUES ("JN6_1","073_6_1","JHN","6","1","1","Saŋ maŋ tiŋ geŋ Isa yʼa tʼiiziga, yi-ti diipiɗa ti dar bar Galile ti nee, sundutú soo bar ki Tiberiyat. ");
INSERT INTO moz_vpl VALUES ("JN6_2","073_6_2","JHN","6","2","2","Wo ɗoŋ ɓaadaŋ an di yʼ diine kono an wulle sulɗi kʼarmika ɗoŋ yʼisiyo a ɗoŋ kʼeeni gen̰n̰o. ");
INSERT INTO moz_vpl VALUES ("JN6_3","073_6_3","JHN","6","3","3","Maŋ Isa ti sanalliyagí an aa di gili eego mokkolo, an di-guune. ");
INSERT INTO moz_vpl VALUES ("JN6_4","073_6_4","JHN","6","4","4","Onniyto gette tarnaape Pak ki Yawudiyagi aa guute goppoŋ. ");
INSERT INTO moz_vpl VALUES ("JN6_5","073_6_5","JHN","6","5","5","Isa yi zibbe edayí maŋ, yi wolliyo ɗoŋ duuru ɓaadaŋ anʼtiyo tuddaŋ. Maŋ yi di ruute Pilip, yʼede: «Ɗe a too me in dʼowila mappa, in an tʼela ɗoŋ duuru kino ga ooma me?» ");
INSERT INTO moz_vpl VALUES ("JN6_6","073_6_6","JHN","6","6","6","Isa yi-rootiyo a Pilip iŋkino yi deeɗiyo addí, yi roota moo me. Wo ki yode Isa maŋ, yi suune munɗa wede yʼaasa me. ");
INSERT INTO moz_vpl VALUES ("JN6_7","073_6_7","JHN","6","7","7","Maŋ Pilip yi diʼn gime onamí, yʼede: «In tʼoone tamma meeda sire, in tʼowila mappa pay toŋ maŋ, a tʼîde ɗey ko wede soŋ yi-tʼoone boolo booloŋ me?» ");
INSERT INTO moz_vpl VALUES ("JN6_8","073_6_8","JHN","6","8","8","Maŋ Andire leema Simo Piyer, yode toŋ ti diine sanalliyagi kʼIsa, yi di ruute, yʼede: ");
INSERT INTO moz_vpl VALUES ("JN6_9","073_6_9","JHN","6","9","9","«A sirpa eŋ i dʼede ulo a beezí mappa paat an iiɗiba ki orz ti puuni sire, ɗe geŋ a tʼîde moo a ɗoŋ duuru eŋ me?» ");
INSERT INTO moz_vpl VALUES ("JN6_10","073_6_10","JHN","6","10","10","Iŋkino maŋ Isa yʼa ruute, yʼede: «Ɗuwo eŋ kun tiʼn konɗita.» A ume geŋ soole ɓaadaŋ. Maŋ ɗuwo suma dupu paat geŋ an di-gunɗite adda. ");
INSERT INTO moz_vpl VALUES ("JN6_11","073_6_11","JHN","6","11","11","Maŋ Isa yʼa-ziki mappa, yʼa ruute koɗuwo a Raa, yʼan di-dikkiɗa a ɗoŋ duuru gen̰n̰o. Wo puuni toŋ yʼa-tʼize iŋkino kay, an dʼiimi, an dʼisse a uupite. ");
INSERT INTO moz_vpl VALUES ("JN6_12","073_6_12","JHN","6","12","12","Aame ɗuwo pay geŋ an iimi an issite maŋ, Isa yʼan di ruute sanalliyagí, yʼede: «Omɓo ere uupite kun ti tussi mentú ye.» ");
INSERT INTO moz_vpl VALUES ("JN6_13","073_6_13","JHN","6","13","13","Maŋ kane an ti-tusse, an dʼûune dappa koomat makumu sire, ti oopiyo ki mappa paat ki orz wede ɗuwo an dʼiimi geŋ me. ");
INSERT INTO moz_vpl VALUES ("JN6_14","073_6_14","JHN","6","14","14","Aame ɗoŋ geŋ an wulle munɗa kʼarmika wede Isa yʼize gen̰n̰o maŋ, anʼde: «Ki kotto wede eŋ nebi wede an ruute ti kaaga yʼa etto kʼadda duniya.» ");
INSERT INTO moz_vpl VALUES ("JN6_15","073_6_15","JHN","6","15","15","Aame geŋ Isa yʼa zuune, an iidoʼŋ ki toogo miŋ an tiʼn tʼela mozigo, maŋ yʼa tʼirga siidí kʼekki mokkolo. ");
INSERT INTO moz_vpl VALUES ("JN6_16","073_6_16","JHN","6","16","16","A tukki lohe maŋ, tʼekki mokkolo sanalliyagí an di-ɗiigo biza bar. ");
INSERT INTO moz_vpl VALUES ("JN6_17","073_6_17","JHN","6","17","17","An di-gili adda tooko kono an di-doopiɗa ki geeger Kapernayim ti dar bar ti nee. Ume yʼize diɗɗo, wo Isa yi kiʼn uuna ye ɓotto. ");
INSERT INTO moz_vpl VALUES ("JN6_18","073_6_18","JHN","6","18","18","Aame kane adda kʼahu geŋ i dʼiiziga maaye ɓaadaŋ, ahu i-kolzite. ");
INSERT INTO moz_vpl VALUES ("JN6_19","073_6_19","JHN","6","19","19","An ize suma kuɓɓaara paat zoot maŋ, an wolliyoʼŋ Isa yi sooru tʼekkʼahu, yʼettiyo tuddaŋ. Maŋ orgiso tʼanni ziiɗa kono an ki zuune ye ettiyo geŋ Isa me. ");
INSERT INTO moz_vpl VALUES ("JN6_20","073_6_20","JHN","6","20","20","Maŋ Isa yʼan di ruute, yʼede: «Kun orgiɗe ye, eŋ nuuno!» ");
INSERT INTO moz_vpl VALUES ("JN6_21","073_6_21","JHN","6","21","21","Aame geŋ an dehu yʼa di kili ti kane adda tooko, wo kaciŋ taŋ booloŋ an iina zeŋge ki siiɗo ere an dʼette. ");
INSERT INTO moz_vpl VALUES ("JN6_22","073_6_22","JHN","6","22","22","Soggo maŋ kane ɗuwo ɗoŋ uupe ti zeŋge bar tʼinno geŋ, an wulle tooko tiŋ soo ɗaŋŋal. Sanalliyagí an di-gili, wo Isa ti kane yi kʼiŋgile ye, an iŋgile siidaŋ. ");
INSERT INTO moz_vpl VALUES ("JN6_23","073_6_23","JHN","6","23","23","Wo saŋ maŋ i dʼiina tookiyagi ti Tiberiyat, a ume wede ɗuwo an dʼiimi mappa wede Galmeega yʼa ruute koɗuwo a Raa gen̰n̰o. ");
INSERT INTO moz_vpl VALUES ("JN6_24","073_6_24","JHN","6","24","24","Aame kane ɗuwo geŋ, an wulle Isa ti sanalliyagí kane umbo maŋ, an aa di-giliti adda tookiyagi gen̰n̰o, an dʼumɓe Kapernayim dehu kʼIsa. ");
INSERT INTO moz_vpl VALUES ("JN6_25","073_6_25","JHN","6","25","25","Aame an ti diipiɗa maŋ, an di yʼuune ti dar bar ti nee, wo an di yʼ tunde, anʼde: «Wede dooyisadey, ɗe kee kʼiina a eŋ woogo me?» ");
INSERT INTO moz_vpl VALUES ("JN6_26","073_6_26","JHN","6","26","26","Isa yʼan di ruute, yʼede: «Ɗerec iŋkino wo nʼun di rooto: Kune kun ni dehu kono kun zuune ita sulɗi kʼarmika gen̰n̰o ye. Kun ni dehu kono nʼun dʼele mappa kun dʼiimi, kun dʼisse gen̰n̰o. ");
INSERT INTO moz_vpl VALUES ("JN6_27","073_6_27","JHN","6","27","27","Kun naabe ki omɓo ere i-ti lattiya gettiyo ye, wo ɗe kun naabo ki omɓo ere un tʼela lekkiyo ere ki daayum, ere nuŋ wede an nʼehe aa ulo wede eŋ, nʼun tʼela. Ɗerec, Meega yʼa ti ziipe tampo ki toogadí a nuuno.» ");
INSERT INTO moz_vpl VALUES ("JN6_28","073_6_28","JHN","6","28","28","Maŋ kane an i di ruute, anʼde: «Ay dʼise mummino kono ay di naabe naabo ere Raa yi dehu te?» ");
INSERT INTO moz_vpl VALUES ("JN6_29","073_6_29","JHN","6","29","29","Isa yʼan di ruute, yʼede: «Naabo ere Raa yi delliyo kune kun dʼise te, kun zaape adduguŋ a yo wede yode batum yʼigibo.» ");
INSERT INTO moz_vpl VALUES ("JN6_30","073_6_30","JHN","6","30","30","Maŋ kane an di ruute, anʼde: «Munɗa kʼarmika miŋ tuuku me kee kʼisa ay di wolla, wo ay di zaapa addey a kee me? Naabo tiŋ kʼisa tuuku te? ");
INSERT INTO moz_vpl VALUES ("JN6_31","073_6_31","JHN","6","31","31","Ti kaaga toŋ moŋgiɗagiŋ aame kane adda balɗa geŋ an iimi omɓo ere sundutú mann, aa an riiŋe ti kaaga adda mattup ki Raa, anʼde: “Yʼan ele omɓadaŋ iido ti kandaane.”» ");
INSERT INTO moz_vpl VALUES ("JN6_32","073_6_32","JHN","6","32","32","Maŋ Isa yʼan di ruute, yʼede: «Ɗerec iŋkino wo nʼun di rooto: Omɓo ere iido ti kandaane gette un ele Muusa ye, wo Meegó yʼun eliyo omɓo ere ki kotto, ettiyo ti kandaane. ");
INSERT INTO moz_vpl VALUES ("JN6_33","073_6_33","JHN","6","33","33","Omɓo ere Raa yʼeliyo, todʼte ti ɗiigo ti kandaane, ti dʼeliyo lekkiyo a ɗoŋ duniya pay.» ");
INSERT INTO moz_vpl VALUES ("JN6_34","073_6_34","JHN","6","34","34","Iŋkino maŋ an i-di ruute, anʼde: «Galmeegey, omɓo gette kʼay eeli ki daayum.» ");
INSERT INTO moz_vpl VALUES ("JN6_35","073_6_35","JHN","6","35","35","Isa yʼan di ruute, yʼede: «Nuŋ miŋ omɓo ere ti dʼeliyo lekkiyo. Wede yʼiido tuddó maŋ, mosogo ti ki yʼ seeɗa ye ki daayum. Wo wede yi ziipa addí a nuŋ maŋ, ôrme yi ki yʼ seeɗa ye ki daayum. ");
INSERT INTO moz_vpl VALUES ("JN6_36","073_6_36","JHN","6","36","36","Wo ɗe nʼun ti yʼ ruute: kun wulle toŋ, kun ki ziipe adduguŋ a nuŋ ye. ");
INSERT INTO moz_vpl VALUES ("JN6_37","073_6_37","JHN","6","37","37","Kane ɗoŋ pay Meega yʼo eliyo eŋ, an dʼetto ki tuddó. Wo wede ettiyo ki tuddó geŋ, ni ki yʼ kiigira ye. ");
INSERT INTO moz_vpl VALUES ("JN6_38","073_6_38","JHN","6","38","38","Nuŋ nʼiido ti kandaane nʼa kʼise naabo ere aa addó i ki dehu ye, nʼaase naabo ere aa wede i nʼigibo yi dehu. ");
INSERT INTO moz_vpl VALUES ("JN6_39","073_6_39","JHN","6","39","39","Wo naabo ere ki wede i nʼigibo yi dehu ettiyo: kane ɗoŋ yʼo elo eŋ, soo toŋ ni ki dagga ye, wo nʼa tiʼn balɗa pay a onniyo kʼita maŋ. ");
INSERT INTO moz_vpl VALUES ("JN6_40","073_6_40","JHN","6","40","40","Eyye, ettiyo naabo ere Meegó yi dehu te: kane ɗoŋ pay an ti gima edayaŋ ki tukkʼUlo, an ziipa addaŋ a yode maŋ, an tʼoona lekkiyo ere ki daayum, wo nuŋ onniyo kʼita maŋ nʼa tiʼn balɗa.» ");
INSERT INTO moz_vpl VALUES ("JN6_41","073_6_41","JHN","6","41","41","Aame Isa yi ruute, yʼede: «Nuŋ omɓo ere i ɗiigo ti kandaane» geŋ, kane Yawudiyagi an illiga maŋ, an dʼorbe sun̰n̰i sun̰n̰i ti tuddaŋ kono yode, ");
INSERT INTO moz_vpl VALUES ("JN6_42","073_6_42","JHN","6","42","42","wo an di ruute, anʼde: «Yode eŋ Isa ulo Yusup ye ko? Meegí ti meedí toŋ inʼni suune en̰n̰o. Ɗe yi rootiyo yi ɗiigo ti kandaane mummino?» ");
INSERT INTO moz_vpl VALUES ("JN6_43","073_6_43","JHN","6","43","43","Isa yʼan di ruute, yʼede: «Kun orba sun̰n̰i sun̰n̰i ti tudduguŋ ye. ");
INSERT INTO moz_vpl VALUES ("JN6_44","073_6_44","JHN","6","44","44","Wenɗa soo toŋ yʼa etto ki tuddó ti siidí umbo, daa ki Meega wede i nʼigibo yʼa ki yʼirgo ki tuddó ye maŋ. Wo nuŋ onniyo kʼita nʼa ti yʼ balɗa. ");
INSERT INTO moz_vpl VALUES ("JN6_45","073_6_45","JHN","6","45","45","Ono eŋ nebiyagi an riiŋe ti kaaga adda mattup ki Raa, anʼde: “Ɗoŋ pay an tʼoona dooyiso ti Raa.” Iŋkino maŋ wede tuuku yʼilliga ono Meega wo yʼa ziiɗa a dooyiso gettiyo maŋ, yʼa etto ki tuddó. ");
INSERT INTO moz_vpl VALUES ("JN6_46","073_6_46","JHN","6","46","46","Wenɗa soo toŋ i wulle Meega umbo, daa ki wede iido ti ɗaana Raa ye maŋ. Yode ɗaŋŋal i yi wulle Meega me. ");
INSERT INTO moz_vpl VALUES ("JN6_47","073_6_47","JHN","6","47","47","Ɗerec iŋkino wo nʼun di rooto: Wede yi ziipa addí a nuŋ maŋ, yode geŋ yʼuune lekkiyo ere ki daayum. ");
INSERT INTO moz_vpl VALUES ("JN6_48","073_6_48","JHN","6","48","48","Nuŋ miŋ omɓo ere i dʼeliyo lekkiyo. ");
INSERT INTO moz_vpl VALUES ("JN6_49","073_6_49","JHN","6","49","49","Ti kaaga moŋgiɗaguŋ an iimi omɓo sundutú mann a balɗa toŋ, an tʼinda, ");
INSERT INTO moz_vpl VALUES ("JN6_50","073_6_50","JHN","6","50","50","wo ɗe omɓo ere ti ɗiigo ti kandaane ette, todʼte wede yʼiima maŋ, yi ki tʼinda ye. ");
INSERT INTO moz_vpl VALUES ("JN6_51","073_6_51","JHN","6","51","51","Nuŋ miŋ omɓo ere i dʼeliyo lekkiyo, i ɗiigo ti kandaane. Aame wede yʼiima omɓo ettiyo maŋ, yʼa tʼoona lekkiyo ere ki daayum. Wo omɓo ere nʼan tʼela todʼte tukin̰adó, nʼan tʼele kono ɗuwo pay an tʼoona lekkiyo.» ");
INSERT INTO moz_vpl VALUES ("JN6_52","073_6_52","JHN","6","52","52","A onamí geŋ kane Yawudiyagi an dʼiise niikiyto ti tuddaŋ, anʼde: «Mummino me wede eŋ yʼin tʼela tukin̰adí in dʼaaɗima me?» ");
INSERT INTO moz_vpl VALUES ("JN6_53","073_6_53","JHN","6","53","53","Maŋ Isa yʼan di ruute, yʼede: «Ɗerec iŋkino wo nʼun di rooto: Aame kune kun kʼiiɗima tukin̰o ki nuŋ wede an nʼehe aa ulo wede en̰n̰o ye, wo kun kʼiiɓa puuzadó ye maŋ, lekkiyo kun ki ti tʼoona ye. ");
INSERT INTO moz_vpl VALUES ("JN6_54","073_6_54","JHN","6","54","54","Wede yʼiiɗima tukin̰adó wo yʼiiɓa puuzadó maŋ, yʼa tʼoona lekkiyo ere ki daayum. Wo yʼinda toŋ maŋ nuŋ onniyo kʼita nʼa ti yʼ balɗa. ");
INSERT INTO moz_vpl VALUES ("JN6_55","073_6_55","JHN","6","55","55","Ɗerec, tukin̰adó todʼte omɓo ere ki kotto, wo puuzadó soɓo ere ki kotto. ");
INSERT INTO moz_vpl VALUES ("JN6_56","073_6_56","JHN","6","56","56","Wede yʼiiɗima tukin̰adó wo yʼiiɓa puuzadó maŋ, yʼa lekka kettiyo ti nuŋ, wo nuŋ nʼa lekka kettiyo ti yode. ");
INSERT INTO moz_vpl VALUES ("JN6_57","073_6_57","JHN","6","57","57","Meega wede i nʼigibo, yoŋ yi lekkiyo zeere, wo nuŋ toŋ ni lekkiyo zeere tʼurzi yode. Geŋ iŋkino wede yʼiiɗima tuddó maŋ, yʼa lekka zeere tʼurzi nuuno kay. ");
INSERT INTO moz_vpl VALUES ("JN6_58","073_6_58","JHN","6","58","58","Wo omɓo ere i ɗiigo ti kandaane ette: Todʼte aa omɓo ere sundutú mann, moŋgiɗaguŋ ɗoŋ ti kaaga an dʼiimi gettiyo ye. Omɓo gette an dʼiimi toŋ an tʼinda. Wo wede yʼiima omɓo ere nuŋ nʼeliyo ettiyo maŋ, yʼa tʼoona lekkiyo ere ki daayum.» ");
INSERT INTO moz_vpl VALUES ("JN6_59","073_6_59","JHN","6","59","59","Ono geŋ Isa yi ruute a Kapernayim, aame yi dooyiso ɗuwo a ɓoy wede Yawudiyagi ge dooyiso. ");
INSERT INTO moz_vpl VALUES ("JN6_60","073_6_60","JHN","6","60","60","Aame kane sanalliyagí an illiga Isa yi ruute iŋkino maŋ, oŋgoŋ anʼde: «Onamí eŋ i jiire eego, iŋkino wee wee a amɓe me?» ");
INSERT INTO moz_vpl VALUES ("JN6_61","073_6_61","JHN","6","61","61","Yode Isa yʼa zuune tʼadda kʼaddí sanalliyagí geŋ an orbe sun̰n̰i sun̰n̰i ti tuddaŋ a ono ɗoŋ yi ruute geŋ me, maŋ yʼan di ruute, yʼede: «Onamó eŋ kune un uun̰e ɗe? ");
INSERT INTO moz_vpl VALUES ("JN6_62","073_6_62","JHN","6","62","62","Aame kun wulla nuŋ wede an nʼehe aa ulo wede eŋ, ni-gila kʼawwa kʼumayó ti poone maŋ, kun tʼeesa moo me? ");
INSERT INTO moz_vpl VALUES ("JN6_63","073_6_63","JHN","6","63","63","Eliyo lekkiyo a ɗuwo Unde Raa, wo naabo gette wede tudde yi kʼaane yi ki-tʼise ye. Ono ɗoŋ nʼun ruute geŋ, kane anʼtiyo ti Unde Raa wo an dʼeliyo lekkiyo. ");
INSERT INTO moz_vpl VALUES ("JN6_64","073_6_64","JHN","6","64","64","Wo ɗe ti diinaguŋ ɗoŋ oŋgoŋ an ki ziipe addaŋ a nuŋ ye.» Wo geŋ Isa yiʼni suune tʼume kʼeesiyo too kane ɗoŋ i ki ziipe addaŋ a yode ye, wo wede a yi tʼela a bey ɗoŋ kʼolmiɗayí me. ");
INSERT INTO moz_vpl VALUES ("JN6_65","073_6_65","JHN","6","65","65","Isa yʼa ruute sey, yʼede: «Geŋ iŋkino kono kamo nʼun ruute, wede ti siidí yi kʼaane yi kʼetto tuddó ye, aame Meega yi-ki tʼihina urzi ye maŋ.» ");
INSERT INTO moz_vpl VALUES ("JN6_66","073_6_66","JHN","6","66","66","Aame yi ruute iŋkino maŋ, kane sanalliyagí ɓaadaŋ an di liɗɗe ti tuddí, an dʼiili daaniyadí te. ");
INSERT INTO moz_vpl VALUES ("JN6_67","073_6_67","JHN","6","67","67","Iŋkino maŋ Isa yʼan di ruute sanalliyagi kane koomat makumu sire geŋ, yʼede: «Wo kune toŋ, kunuŋ kun dehu kun ti leɗɗe pay ko?» ");
INSERT INTO moz_vpl VALUES ("JN6_68","073_6_68","JHN","6","68","68","Maŋ Simo Piyer yi di ruute, yʼede: «Galmeegey, kaye ay dʼette kʼita kʼaaye? Kee onamá i dʼeliyo lekkiyo ere ki daayum me. ");
INSERT INTO moz_vpl VALUES ("JN6_69","073_6_69","JHN","6","69","69","Kaye ay ziipe addey a kee, wo ay suune kee Wede kamilen̰ Raa yʼigibo.» ");
INSERT INTO moz_vpl VALUES ("JN6_70","073_6_70","JHN","6","70","70","Isa yʼan di ruute, yʼede: «Kune koomat makumu sire geŋ, unni biire nuuno ye ko? Wo ɗe wede soo ti diinaguŋ yoŋ ulo Meeda siitanɗani.» ");
INSERT INTO moz_vpl VALUES ("JN6_71","073_6_71","JHN","6","71","71","Isa yi rootiyo iŋkino ti Ziidas ulo Simo Iskariyot, wede ti diine sanalliyagi kane koomat makumu sire, a yʼowila a bey ɗoŋ kʼolmiɗayí. ");
INSERT INTO moz_vpl VALUES ("JN7_1","073_7_1","JHN","7","1","1","Aame geŋ Isa yoŋ daayum a siiɗo Galile, yi sooru, yi dʼamɓu ken̰n̰o ken̰n̰o. Yi ki dehu yʼa kʼozirte adda siiɗo ki Ziide ye, kono deero Yawudiyagi an yi dehu ki tôwwadí. ");
INSERT INTO moz_vpl VALUES ("JN7_2","073_7_2","JHN","7","2","2","Aame geŋ tarnaape Yawudiyagi sundí soo tarnaape ki daabagi geŋ goppoŋ. ");
INSERT INTO moz_vpl VALUES ("JN7_3","073_7_3","JHN","7","3","3","Iŋkino maŋ zemɓa kʼIsa an i di ruute, anʼde: «Tʼeŋ ki tʼoozo, kʼeŋgilo ki siiɗo Ziide kono sanalliyagá ɗoŋ a ummey toŋ maŋ, an di wolle naabo ere kʼisiyo gette. ");
INSERT INTO moz_vpl VALUES ("JN7_4","073_7_4","JHN","7","4","4","Aame wede yi dehu ɗuwo an di yʼ suune maŋ, yi kʼombiɗa ye naabo ere yi dʼisiyo te. Wo kee kʼisiyo sulɗi kʼarmika geŋ beehiyeʼŋ, ɗoŋ duniya pay an di wolle, wo an gi-di suune.» ");
INSERT INTO moz_vpl VALUES ("JN7_5","073_7_5","JHN","7","5","5","Kaciŋ kane zemɓa kʼIsa toŋ an ki ziipe addaŋ a yode ye. ");
INSERT INTO moz_vpl VALUES ("JN7_6","073_7_6","JHN","7","6","6","Maŋ Isa yʼan di ruute, yʼede: «Nuŋ peeɗadó ti kʼîide ye ɓotto. Kune peeɗaguŋ todʼte daayum koɗuwo. ");
INSERT INTO moz_vpl VALUES ("JN7_7","073_7_7","JHN","7","7","7","Kune ɗoŋ duniya an un kiʼn kiigira ye. Wo nuŋ an ni koogire kono nʼan tʼooɗibe ita a naabadaŋ ere an isiyo olɗo gettiyo. ");
INSERT INTO moz_vpl VALUES ("JN7_8","073_7_8","JHN","7","8","8","Kune tarnaape kun ti kolo. Nuŋ ni ki kili ye kono peeɗadó ti kʼîide ye ɓotto.» ");
INSERT INTO moz_vpl VALUES ("JN7_9","073_7_9","JHN","7","9","9","Aame yʼan ti ruute iŋkino maŋ, yoŋ yʼa uupe a siiɗo Galile. ");
INSERT INTO moz_vpl VALUES ("JN7_10","073_7_10","JHN","7","10","10","Aame zemɓadí an ti gili tarnaape maŋ, saŋ maŋ yode toŋ yʼa-gili, wo kaŋ ombiɗe, wenɗa soo toŋ i ki yʼ wulle ye. ");
INSERT INTO moz_vpl VALUES ("JN7_11","073_7_11","JHN","7","11","11","Adda tarnaape geŋ kane deero Yawudiyagi an di yʼ dehutu, anʼde: «Ɗe Isa miŋ a too me?» ");
INSERT INTO moz_vpl VALUES ("JN7_12","073_7_12","JHN","7","12","12","Wo kane ɗoŋ duuru geŋ an di niikutu ti tuddaŋ. Ɗoŋ oŋgoŋ anʼde: «Yoŋ wede isiyo beehiye.» Wo ɗoŋ soŋ anʼde: «Ato, yoŋ yi ti daggiya ɗuwo.» ");
INSERT INTO moz_vpl VALUES ("JN7_13","073_7_13","JHN","7","13","13","Wo ti diinayaŋ geŋ wenɗa yʼa roote ti golla awwa umbo, kono an orgiso a deero Yawudiyagi. ");
INSERT INTO moz_vpl VALUES ("JN7_14","073_7_14","JHN","7","14","14","I tʼinnite iina diine tarnaape maŋ, Isa yʼa tʼiide booro Ɓoy Raa, yʼa iise dooyiso ɗuwo. ");
INSERT INTO moz_vpl VALUES ("JN7_15","073_7_15","JHN","7","15","15","A dooyisadí gette kane deero Yawudiyagi an ziiɗa giggiraŋ, anʼde: «Mummino me wede eŋ yi ki duuye tunɗa ye, wo yi suuniyo ono mattup kino me?» ");
INSERT INTO moz_vpl VALUES ("JN7_16","073_7_16","JHN","7","16","16","Maŋ Isa yʼan di ruute, yʼede: «Dooyiso ere ni dooyiso ette ti suuniyo nuuno kʼeedó ye. Tʼettiyo ti Raa wede i nʼigibo. ");
INSERT INTO moz_vpl VALUES ("JN7_17","073_7_17","JHN","7","17","17","Aame wede yi dehu yʼaase naabo ere Raa yi dehu maŋ, yʼa ti suune dooyisadó te. Dooyisadó ettiŋ tʼettiyo ti Raa kunuŋ, ni rootiyo ti suma nuuno kʼeedó ko? ");
INSERT INTO moz_vpl VALUES ("JN7_18","073_7_18","JHN","7","18","18","Wede geŋ aame yi rootiyo ti suma yode kʼeedí maŋ, geŋ yi dehu ɗuwo an di yʼ tʼimme. Wo wede yi naabiya a suma wede i yʼigibo maŋ, wede geŋ yi rootiyo ono ɗoŋ ɗerec, munɗa wede di yode ki diine ye umbo. ");
INSERT INTO moz_vpl VALUES ("JN7_19","073_7_19","JHN","7","19","19","Ki kotto kune un ele oogoro Muusa, wo kune wenɗa soo toŋ a seeɗa aa oogoro ti rootiyo umbo. Ɗe ki moo me kun dehu kun di nʼ tʼîde me?» ");
INSERT INTO moz_vpl VALUES ("JN7_20","073_7_20","JHN","7","20","20","Kane ɗoŋ duuru an i-di ruute, anʼde: «Kee a-dʼede siitan a eedá ko? Kunuŋ wee wee i dehu tôwwadá me?» ");
INSERT INTO moz_vpl VALUES ("JN7_21","073_7_21","JHN","7","21","21","Isa yʼan di ruute, yʼede: «Nuŋ nʼize munɗa kʼarmika soo ɗaŋŋal, wo kune pay kun ziiɗa giggirguŋ. ");
INSERT INTO moz_vpl VALUES ("JN7_22","073_7_22","JHN","7","22","22","Walɗu ponde gette tʼiise ti moŋgiɗaguŋ ti kaaga to, ti kʼiise ti Muusa ye. Wo Muusa yʼun dʼele urzi ki walɗu kʼin̰n̰i kuuli. Maŋ onniyo ere ki puukiyadiŋ toŋ kune kun di walɗu ponde me. ");
INSERT INTO moz_vpl VALUES ("JN7_23","073_7_23","JHN","7","23","23","Wo aame uloʼŋ onniyo walɗu pondayí a tʼooriyo onniyo ere ki puukiyadiŋ, kun di walɗu kono kun aa ki ti doopiɗa oogoro Muusa ye maŋ, ɗe ki moo me kune kun di kulkiso ti nuŋ, kono ni ele beeko pay a wede tudde a onniyo ere ki puukiyadiŋ me? ");
INSERT INTO moz_vpl VALUES ("JN7_24","073_7_24","JHN","7","24","24","Kun ɗekke booro a munɗa wede kun wolliyo tʼedaguŋ ye, wo ɗe kun ɗekko booro ere ki diine.» ");
INSERT INTO moz_vpl VALUES ("JN7_25","073_7_25","JHN","7","25","25","Ɗoŋ oŋgo ti siiɗo Zeruzalem geŋ an di rootiyo, anʼde: «Eŋ miŋ wede an dehu ki tôwwadí ɗey? ");
INSERT INTO moz_vpl VALUES ("JN7_26","073_7_26","JHN","7","26","26","Kun wollo ɗo yi dʼorbe a ɗaana ɗuwo daa kʼombiɗe, wo wenɗa i di roote umbo. Kunuŋ ɗoŋ deero an yi zuune eŋ Almasi Raa yi biire ko? ");
INSERT INTO moz_vpl VALUES ("JN7_27","073_7_27","JHN","7","27","27","Wo ki too maŋ yo Almasi Raa yi biire ettiyadí gette yʼetto ti tunɗa, wenɗa soo toŋ umbo a suuna itadí me, wo yode eŋ itadí in ti suune.» ");
INSERT INTO moz_vpl VALUES ("JN7_28","073_7_28","JHN","7","28","28","Iŋkino maŋ Isa yi dooyiso a booro Ɓoy Raa geŋ, yʼa ruute ti golla awwa, yʼede: «Kune ɗuwo eŋ, kunʼde nuŋ kun ni suune, wo kun suune itadó. Para maŋ ni kʼiido ti suma nuuno kʼeedó ye, wo yo wede i nʼigibo geŋ yoŋ yi rootiyo ono ɗoŋ ɗerec, miŋ kun ki yʼ suune ye. ");
INSERT INTO moz_vpl VALUES ("JN7_29","073_7_29","JHN","7","29","29","Wo nuŋ ni yi suune kono i nʼigibo yode, wo nuŋ nʼiido ti gulbe yode.» ");
INSERT INTO moz_vpl VALUES ("JN7_30","073_7_30","JHN","7","30","30","Iŋkino maŋ kane an di dehu urzi seeɗuzí, wo wenɗa soo toŋ a ette a yi seeɗa umbo, kono yoŋ onniyadí ti kʼîide ye ɓotto. ");
INSERT INTO moz_vpl VALUES ("JN7_31","073_7_31","JHN","7","31","31","Aame geŋ ɗoŋ ɓaadaŋ ti diine ɗoŋ duuru an di ziipe addaŋ a yode, wo kane an di ruute, anʼde: «Almasi Raa yi biire yʼiido toŋ maŋ, yʼaasa sulɗi kʼarmika ɓaadaŋ a ceera wede en̰n̰o ɗey?» ");
INSERT INTO moz_vpl VALUES ("JN7_32","073_7_32","JHN","7","32","32","Maŋ kane Pariziyeŋ an dʼilliga ono ɗoŋ, ɗoŋ duuru an orbe sun̰n̰i sun̰n̰i a tukkʼIsa geŋ me. Iŋkino maŋ kane Pariziyeŋ ti deero ɗoŋ seɗeke an dʼigibe ɗoŋ i boohiyo Ɓoy Raa ki seeɗu kʼIsa. ");
INSERT INTO moz_vpl VALUES ("JN7_33","073_7_33","JHN","7","33","33","Maŋ Isa yʼa ruute, yʼede: «Nuŋ ti kune onniyadó oo guute baata, saŋ maŋ nʼa-kima kʼume wede i nʼigibo. ");
INSERT INTO moz_vpl VALUES ("JN7_34","073_7_34","JHN","7","34","34","Kune kun di nʼ deha wo kun ki nʼ tʼoona ye, kono ume wede nuŋ nʼette geŋ, kun kʼaana ettiyo ye.» ");
INSERT INTO moz_vpl VALUES ("JN7_35","073_7_35","JHN","7","35","35","Iŋkino maŋ kane Yawudiyagi an di ruute diinayaŋ, anʼde: «Ɗe yʼa amɓa miŋ, ki too me in gi di yʼ tʼoona ye me? Yʼa eŋgila ki tukki Yawudiyagi ɗoŋ i-tiipe an lekkiyo adda diine ɗoŋ Yawudiyagi ye gen̰n̰o ko? Kunuŋ yʼa dooyey ɗoŋ Yawudiyagi ye ko? ");
INSERT INTO moz_vpl VALUES ("JN7_36","073_7_36","JHN","7","36","36","Ono ɗoŋ yi rootiyo, yʼede: “Kun di nʼ deha wo kun ki nʼ tʼoona ye” wo “ume wede nuŋ nʼette geŋ, kune kun kʼaana ettiyo ye”, miŋ i-kaza moo me?» ");
INSERT INTO moz_vpl VALUES ("JN7_37","073_7_37","JHN","7","37","37","Onniyo ere ki ɗaŋgu tarnaape gette, todʼte onniyo ere meeda. A onniyo gette Isa yʼa tʼiiziga kaŋ ôhire, wo yʼa ruute ti golla awwa, yʼede: «Wede ôrme yi yʼ ziiɗa maŋ, yʼedi tuddó yi-siɓa. ");
INSERT INTO moz_vpl VALUES ("JN7_38","073_7_38","JHN","7","38","38","Wede yi ziipa addí a nuuno maŋ, aakede an riiŋe ti kaaga adda mattup ki Raa, anʼde: “Yʼa tʼisa aa ersa kʼahu ɗoŋ i dʼeliyo lekkiyo okko ɓaadaŋ tʼadda kʼaddí.”» ");
INSERT INTO moz_vpl VALUES ("JN7_39","073_7_39","JHN","7","39","39","Isa yi rootiyo iŋkino ti Unde Raa ere Raa yʼan tʼela a ɗoŋ i ziipe addaŋ a yode. Aame geŋ Raa yʼan kʼele Undí ye ɓotto a ɗuwo me, kono Isa yi ki gili kʼawwa ki darƴikadí ye ɓotto. ");
INSERT INTO moz_vpl VALUES ("JN7_40","073_7_40","JHN","7","40","40","Ɗoŋ oŋgo ti diine ɗoŋ duuru geŋ an illiga ono kʼIsa maŋ, an di ruute, anʼde: «Wede eŋ ki kotto yoŋ nebi wede an ruute a etto.» ");
INSERT INTO moz_vpl VALUES ("JN7_41","073_7_41","JHN","7","41","41","Oŋgo soŋ anʼde: «Eŋ Almasi Raa yi biire.» Wo ɗe ɗoŋ oŋgo anʼde: «Almasi Raa yi biire geŋ yʼa aɗɗo ti Galile, i kʼise ye! ");
INSERT INTO moz_vpl VALUES ("JN7_42","073_7_42","JHN","7","42","42","Ki kotto an riiŋe ti kaaga adda mattup ki Raa, Almasi Raa yi biire geŋ yʼaɗɗa ti biza bumɓu mozigo Dawut, wo an yi tʼeha a Betilehem siiɗo ere an dʼehe Dawut.» ");
INSERT INTO moz_vpl VALUES ("JN7_43","073_7_43","JHN","7","43","43","Iŋkino maŋ kono kʼIsa geŋ, ɗuwo tuddaŋ an ti-tʼihinte. ");
INSERT INTO moz_vpl VALUES ("JN7_44","073_7_44","JHN","7","44","44","Ɗoŋ oŋgo ti diinayaŋ geŋ an dehu seeɗuzí, wo wenɗa soo toŋ a tʼooziga a yi seeɗa umbo. ");
INSERT INTO moz_vpl VALUES ("JN7_45","073_7_45","JHN","7","45","45","Aame geŋ ɗoŋ i boohiyo Ɓoy Raa, kane an igibe ki seeɗu kʼIsa geŋ, an di-gimo. Maŋ kane deero ɗoŋ seɗeke ti Pariziyeŋ an diʼn tunde, anʼde: «Ɗe moo me kun ki yʼ ziiɗo ye me?» ");
INSERT INTO moz_vpl VALUES ("JN7_46","073_7_46","JHN","7","46","46","Maŋ kane ɗoŋ i boohiyo Ɓoy Raa anʼde: «Wede eŋ me, wede tudde a roote ono aa yode umbo.» ");
INSERT INTO moz_vpl VALUES ("JN7_47","073_7_47","JHN","7","47","47","Maŋ kane Pariziyeŋ an an di ruute, anʼde: «Kune toŋ maŋ yʼun tiʼn diggo pay ko? ");
INSERT INTO moz_vpl VALUES ("JN7_48","073_7_48","JHN","7","48","48","Kunuŋ kun wulle ko? Ti diine deero Yawudiyagi ise Pariziyeŋ wede soo i ziipe addí a yode me! ");
INSERT INTO moz_vpl VALUES ("JN7_49","073_7_49","JHN","7","49","49","Kun wolliyo kane ɗoŋ amɓu ono yode geŋ, kane oogoro an ki ti suune ye, duuɗiyo Raa a eedaŋ.» ");
INSERT INTO moz_vpl VALUES ("JN7_50","073_7_50","JHN","7","50","50","Nikodem yoŋ ede, yoŋ wede ti diine Pariziyeŋ, yode wede onniyo soo yʼa uuney Isa a diɗɗo geŋ, yʼan di ruute, yʼede: ");
INSERT INTO moz_vpl VALUES ("JN7_51","073_7_51","JHN","7","51","51","«A urzi kʼoogiradiŋ, wede daa kʼollige bizí wo daa suuniyo munɗa wede yʼize geŋ, booro ti yʼ seeɗa ko?» ");
INSERT INTO moz_vpl VALUES ("JN7_52","073_7_52","JHN","7","52","52","Kane an i diʼn gime onamí, anʼde: «Kee toŋ ti siiɗo Galile pay ko? Ki wollo mattup kʼono Raa ki koɗuwo, ki tʼoona ko nebi ti siiɗo Galile me?»  ");
INSERT INTO moz_vpl VALUES ("JN7_53","073_7_53","JHN","7","53","53","Iŋkino maŋ an di-tiipe wede tuuku toŋ yʼa aahe ɓoozí ɓoozí. ");
INSERT INTO moz_vpl VALUES ("JN8_1","073_8_1","JHN","8","1","1","Wo Isa yʼa iŋgile kʼekki mokkolo kʼInda kʼOlibiye. ");
INSERT INTO moz_vpl VALUES ("JN8_2","073_8_2","JHN","8","2","2","Soggo ti soohe walak maŋ, Isa yʼa-gimo ki booro Ɓoy Raa, wo ɗoŋ ɓaadaŋ an dʼiido tuddí. Iŋkino maŋ yʼa-guune, yʼan diʼn iise dooyiso. ");
INSERT INTO moz_vpl VALUES ("JN8_3","073_8_3","JHN","8","3","3","Aame geŋ ɗoŋ suuniyo kʼoogoro ti Pariziyeŋ, an ziiɗo erewo an aa ti ziiɗo ti moone ti kule bakatú, an di-tʼiido kʼume kʼIsa, an ti-tʼîhira a ɗaana ɗuwo pay ");
INSERT INTO moz_vpl VALUES ("JN8_4","073_8_4","JHN","8","4","4","wo an i di ruute a Isa, anʼde: «Galmeegey, erewo ette ay aa ti ziiɗo ti moone ti kule bakatú. ");
INSERT INTO moz_vpl VALUES ("JN8_5","073_8_5","JHN","8","5","5","Adda mattup kʼoogoro, Muusa yʼin riiŋe ti kaaga yʼede, erayi ɗoŋ isiyo kino eŋ, ki tôwwo ki kakkisa ti moŋgali. Wo ki kee maŋ, kʼede moo me?» ");
INSERT INTO moz_vpl VALUES ("JN8_6","073_8_6","JHN","8","6","6","An rootiyo iŋkino an i ekkiyo ikka, kono an di yʼ seeɗa tʼono. Maŋ Isa yʼa tʼuttile, yi-reekiso ƴelagí a siiɗo. ");
INSERT INTO moz_vpl VALUES ("JN8_7","073_8_7","JHN","8","7","7","Kane an koɗɗime tondisadí, iŋkino Isa yʼa tʼumɓe eedí, wo yʼan di ruute, yʼede: «Ti diinaguŋ eŋ wede yi kʼisiyo olɗiko ye maŋ, yi amɓo mokkolo, yʼa ti seɗɗo ki poone.» ");
INSERT INTO moz_vpl VALUES ("JN8_8","073_8_8","JHN","8","8","8","Maŋ yʼa tʼuttile sey, yi-reekiso ƴelagí a siiɗo. ");
INSERT INTO moz_vpl VALUES ("JN8_9","073_8_9","JHN","8","9","9","Aame an illiga Isa yi ruute iŋkino maŋ, kane ɗoŋ duuru an dʼiise eŋgilsito soo me kʼita bakadí bakadí, iise ti gôlɗali bini a-tʼîide. I dʼuupe Isa kane ti erewo gettiyo ti dʼôhire a ɗaanadí. ");
INSERT INTO moz_vpl VALUES ("JN8_10","073_8_10","JHN","8","10","10","Iŋkino maŋ Isa yʼa tʼumɓe eedí, wo yʼa tunde erewo, yʼede: «Erewo no, ɗoŋ i kiʼn ziiɗoʼŋ kane too me? Wenɗa soo toŋ a roote koŋ booro ti kiʼn ziiɗa umbo ko?» ");
INSERT INTO moz_vpl VALUES ("JN8_11","073_8_11","JHN","8","11","11","Maŋ ti diʼn gime onamí, tʼede: «Wenɗa soo toŋ umbo, Galmeeʼki nuŋ.» Iŋkino maŋ Isa yʼa ruute, yʼede: «Nuŋ toŋ maŋ ni ki ɗekke booro eedí ye. Mi tʼoozo, mʼeŋgilo wo mʼisa olɗiko ye baa.» ");
INSERT INTO moz_vpl VALUES ("JN8_12","073_8_12","JHN","8","12","12","Isa yʼan di ruute sey, yʼede: «Nuŋ miŋ wede i dʼeliyo toore a ɗoŋ duniya pay. Wede yi ni diina maŋ, yʼa tʼoona toore wede i di tʼela lekkiyo, yi kʼozira zimolo ye.» ");
INSERT INTO moz_vpl VALUES ("JN8_13","073_8_13","JHN","8","13","13","Maŋ kane Pariziyeŋ an i di ruute, anʼde: «Kee ki kazita ono a tukki kee batum geŋ, onamá ay kʼamɓe ye.» ");
INSERT INTO moz_vpl VALUES ("JN8_14","073_8_14","JHN","8","14","14","Isa yʼan di ruute, yʼede: «Aame nuŋ ni kazita ono a tukki nuuno batum toŋ maŋ, onamó ɗerec kono ni suune ti too me nʼiido me, wo ume nʼamɓe me. Wo ɗe kune, kun ki suune ye ume wede nʼiido, wo nʼamɓe ki tunɗa me. ");
INSERT INTO moz_vpl VALUES ("JN8_15","073_8_15","JHN","8","15","15","Kune kun ɗekkiyo booro a suuniyo ere ki kune ɗoŋ tudde. Nuŋ a tukki wenɗa soo toŋ ni ki ɗekkiyo booro ye. ");
INSERT INTO moz_vpl VALUES ("JN8_16","073_8_16","JHN","8","16","16","Wo aame ni ɗekkiyo booro maŋ, ni ɗekkiyo ɗerec kono nuŋ siidó ye. Ay ɗekkiyo booro soo ti Meega wede i nʼigibo me. ");
INSERT INTO moz_vpl VALUES ("JN8_17","073_8_17","JHN","8","17","17","Ono eŋ an riiŋe ti kaaga adda mattup kʼoogiraguŋ, anʼde: “Ɗoŋ sire an rootiyo onamaŋ i tʼiide kaŋ soo maŋ, geŋ onamaŋ ɗerec.” ");
INSERT INTO moz_vpl VALUES ("JN8_18","073_8_18","JHN","8","18","18","Nuŋ ni kazita ono a tukki nuŋ batum, wo Meega wede i nʼigibo toŋ, yi kazita ono a tukki nuŋ kay.» ");
INSERT INTO moz_vpl VALUES ("JN8_19","073_8_19","JHN","8","19","19","Iŋkino maŋ kane an i di ruute, anʼde: «Ɗe Meegá too me?» Maŋ Isa yʼan diʼn gime onamaŋ, yʼede: «Nuŋ kun ki nʼ suune ye, wo Meegó toŋ kun ki yʼ suune ye. Aame nuŋ kun ni zuune maŋ, Meegó toŋ kun di yʼ suune.» ");
INSERT INTO moz_vpl VALUES ("JN8_20","073_8_20","JHN","8","20","20","Isa yi ruutite ono geŋ aame yo a booro Ɓoy Raa, yi dooyiso goppoŋ ti ume wede ɗuwo an di boohiyo korɓite Ɓoy Raa. Wo wenɗa soo toŋ a yi seeɗa umbo kono yoŋ onniyadí ti kʼîide ye ɓotto. ");
INSERT INTO moz_vpl VALUES ("JN8_21","073_8_21","JHN","8","21","21","Isa yʼan di ruute sey, yʼede: «Nuŋ nʼeŋgila, wo kune kun di nʼ deha, wo ɗe kun aa di tʼinda ti olɗikaguŋ a egguŋ. Ume wede nʼette eŋ, kun kʼaane ettiyo ye.» ");
INSERT INTO moz_vpl VALUES ("JN8_22","073_8_22","JHN","8","22","22","Iŋkino maŋ kane Yawudiyagi an di ruute tuddaŋ, anʼde: «Kunuŋ yi rootiyo iŋkino yʼa tʼîda tuddí ko, yi rootiyo: “Ume wede nʼetta eŋ, kun kʼaane ettiyo ye” me?» ");
INSERT INTO moz_vpl VALUES ("JN8_23","073_8_23","JHN","8","23","23","Maŋ Isa yʼan di ruute, yʼede: «Kuneʼŋ ti ɗanɗi a duniya, wo nuŋ ti kandaane tʼawwa. Kune ki duniya ettiyo, wo nuŋ ki duniya ettiyo ye. ");
INSERT INTO moz_vpl VALUES ("JN8_24","073_8_24","JHN","8","24","24","Kono kʼiŋkino nʼun di ruute kun di tʼinda tʼolɗikaguŋ a egguŋ me. Aame kun kʼamɓu “nuŋ miŋ nuŋ” ye maŋ, kune kun di-tʼinda ti olɗikaguŋ a egguŋ.» ");
INSERT INTO moz_vpl VALUES ("JN8_25","073_8_25","JHN","8","25","25","Maŋ kane Yawudiyagi an di yʼ tunde, anʼde: «Ɗe kee miŋ wee wee?» Isa yʼan di ruute, yʼede: «Nuŋ nʼun ti gize tuddó tʼume kʼeesiyo to. ");
INSERT INTO moz_vpl VALUES ("JN8_26","073_8_26","JHN","8","26","26","Nuŋ oo dʼede ono ki rootiyo a ekki kune, ti sulɗi ɗoŋ nʼa ɗekke booro egguŋ toŋ ɓaadaŋ, wo wede i nʼigiboʼŋ yoŋ yi rootiyo ono ɗoŋ ɗerec, wo ni kazita a ɗuwo pay munɗa wede nʼollige ti bize yode Raa.» ");
INSERT INTO moz_vpl VALUES ("JN8_27","073_8_27","JHN","8","27","27","Wo kane Yawudiyagi an ki zuune ye yʼan rootiyo ti Meega me. ");
INSERT INTO moz_vpl VALUES ("JN8_28","073_8_28","JHN","8","28","28","Iŋkino maŋ Isa yʼan di ruute, yʼede: «Aame nuŋ wede an nʼehe aa ulo wede eŋ, kun ti nʼ ziipa tʼawwa maŋ, kun diʼn suuna eŋ “nuŋ miŋ nuŋ”. Wo kun di suuna munɗa wede ti suma nuuno kʼeedó ni kʼisiyo ye, ni rootiyo munɗa wede Meega yi ni duuye. ");
INSERT INTO moz_vpl VALUES ("JN8_29","073_8_29","JHN","8","29","29","Wo yo wede i nʼigibo geŋ, yoŋ ti nuuno. Yi ki nʼooliyo siidó ye, kono nuŋ nʼisiyo daayum munɗa wede ulbí i-dʼise uŋse.» ");
INSERT INTO moz_vpl VALUES ("JN8_30","073_8_30","JHN","8","30","30","A ono ɗoŋ Isa yi ruute geŋ, ɗoŋ ɓaadaŋ an di ziipe addaŋ a yode. ");
INSERT INTO moz_vpl VALUES ("JN8_31","073_8_31","JHN","8","31","31","Maŋ Isa yʼan di ruute a Yawudiyagi ɗoŋ i ziipe addaŋ a yode, yʼede: «Aame kun lekkiyo kettiyo a onamó maŋ, kune sanalliyagó ki kotto. ");
INSERT INTO moz_vpl VALUES ("JN8_32","073_8_32","JHN","8","32","32","Aame geŋ ɗerec kun di suuna, wo ɗerec gette tʼun diʼn isa ɗoŋ eedaŋ toore.» ");
INSERT INTO moz_vpl VALUES ("JN8_33","073_8_33","JHN","8","33","33","Maŋ kane an i di ruute, anʼde: «Kaye ita kʼin̰n̰i kʼIbirayim, ɓuliko a wenɗa kaŋ soo toŋ ay kʼize ye. Ɗe kʼay di rootiyo kun tʼisa ɗoŋ eedaŋ toore mummino?» ");
INSERT INTO moz_vpl VALUES ("JN8_34","073_8_34","JHN","8","34","34","Isa yʼan di ruute, yʼede: «Ɗerec iŋkino wo nʼun di rooto: Wede isiyo olɗiko geŋ yoŋ ɓule kʼolɗiko. ");
INSERT INTO moz_vpl VALUES ("JN8_35","073_8_35","JHN","8","35","35","Wede ɓule geŋ yi ki lekka daayum adda ɓoy ye, wo ulo ɓoy geŋ yoŋ miŋ daayum yʼa lekka adda ɓoy. ");
INSERT INTO moz_vpl VALUES ("JN8_36","073_8_36","JHN","8","36","36","Aame Ulo Raa yʼun tiʼn iza egguŋ toore maŋ, kune kun tʼisa ki kotto ɗoŋ eedaŋ toore. ");
INSERT INTO moz_vpl VALUES ("JN8_37","073_8_37","JHN","8","37","37","Nuŋ ni suune kune ita kʼin̰n̰i kʼIbirayim me. Wo kun di dehu urzi tôwwadó kono onamó geŋ kun kʼamɓu ye. ");
INSERT INTO moz_vpl VALUES ("JN8_38","073_8_38","JHN","8","38","38","Munɗa wede nuŋ ni rootiyo, ni wullo ki Meegó. Wo kune kun isiyo munɗa wede meeguguŋ yʼun ruute.» ");
INSERT INTO moz_vpl VALUES ("JN8_39","073_8_39","JHN","8","39","39","Maŋ kane an di ruute, anʼde: «Kaye meegey Ibirayim.» Isa yʼan di ruute, yʼede: «Ki kotto aame kune in̰n̰i kʼIbirayim maŋ, kun dʼise naabo ere aa yoŋ yʼaaze. ");
INSERT INTO moz_vpl VALUES ("JN8_40","073_8_40","JHN","8","40","40","Nuŋ nʼun ruute ono ɗoŋ ɗerec nʼilligo ti Raa toŋ, aŋkeŋ kun di dehu urzi tôwwadó. Wo iŋkino me Ibirayim yi kʼize ye. ");
INSERT INTO moz_vpl VALUES ("JN8_41","073_8_41","JHN","8","41","41","Kune kun isiyo naabo ere ki meeguguŋ.» Maŋ kane an i di ruute, anʼde: «Kaye in̰n̰i ɗoŋ ki bande ye, Meegey soo, yode Raa.» ");
INSERT INTO moz_vpl VALUES ("JN8_42","073_8_42","JHN","8","42","42","Isa yʼan di ruute, yʼede: «Aame Meeguguŋ Raa ki kotto maŋ, nuŋ kun di nʼ geyye kono nuŋ nʼuɗɗo miŋ ti Raa, wo nʼiido ken̰n̰o tʼurzi yode. Ni kʼiidoʼŋ ti toogo kʼeedó ye, yode i nʼigibo me. ");
INSERT INTO moz_vpl VALUES ("JN8_43","073_8_43","JHN","8","43","43","Moo me ono ni rootiyo itadaŋ kun kiʼn suuniyo ye me? Kono kun ki dehu kun kʼolliga ye onamó me. ");
INSERT INTO moz_vpl VALUES ("JN8_44","073_8_44","JHN","8","44","44","Kune meeguguŋ Meeda siitanɗani, wo kun dehu kun dʼise naabo ere meeguguŋ yi dehu. Yoŋ tʼume kʼeesiyo to, naabadí tôwwo ɗuwo. Munɗa wede ɗerec yi kʼisiyo ye, kono ɗerec di yode umbo. Aame yi lohito ono maŋ, yi rootiyo tʼaddí pay, kono yoŋ wede lohito, wo yoŋ meeki lohito kʼono. ");
INSERT INTO moz_vpl VALUES ("JN8_45","073_8_45","JHN","8","45","45","Wo kono nuŋ ni rootiyo ono ɗoŋ ɗerec geŋ, onamó kun ki dʼamɓu ye. ");
INSERT INTO moz_vpl VALUES ("JN8_46","073_8_46","JHN","8","46","46","Wee wee tʼadda diinaguŋ eŋ aane i roote nuŋ ni ize olɗiko me? Wo ɗe aame ni rootiyo ono ɗoŋ ɗerec maŋ, ki moo me onamó kun ki dʼamɓu ye me? ");
INSERT INTO moz_vpl VALUES ("JN8_47","073_8_47","JHN","8","47","47","Iŋkino maŋ wede yoŋ ki Raa geŋ yʼa olliga ono ki Raa. Wo kun kʼollige ye kono kune ki yode Raa ye.» ");
INSERT INTO moz_vpl VALUES ("JN8_48","073_8_48","JHN","8","48","48","Maŋ kane deero Yawudiyagi an i di ruute a Isa, anʼde: «Kaye ay ruute ayʼde kee Samariten, wo a-dʼede siitan a eedá geŋ, ɗerec ye ko?» ");
INSERT INTO moz_vpl VALUES ("JN8_49","073_8_49","JHN","8","49","49","Isa yʼan di-gime onamaŋ, yʼede: «Nuŋ oo kʼede siitan a eedó ye. Ni tamma Meegó, wo kune kun di-toogiyo ki tammadó me. ");
INSERT INTO moz_vpl VALUES ("JN8_50","073_8_50","JHN","8","50","50","Nuŋ ni ki dehu tamma tuddó ye, wo wede ede i dehu tammadó me, yoŋ geŋ wede ɗekkiyo booro. ");
INSERT INTO moz_vpl VALUES ("JN8_51","073_8_51","JHN","8","51","51","Ɗerec iŋkino wo nʼun di rooto: Wede yʼollige onamó wo yʼa ti sooru eego maŋ, kuɗic unto yi ki ti wolla ye.» ");
INSERT INTO moz_vpl VALUES ("JN8_52","073_8_52","JHN","8","52","52","Maŋ kane deero Yawudiyagi an i di ruute, anʼde: «Aŋkeŋ kaye ay zuune baa, kee a-dʼede siitan a eedá. Ibirayim yʼinda ti kaaga wo nebiyagi toŋ an tʼinda, miŋ kee kʼede: “Wede yʼollige onamó wo yʼa ti sooru eego maŋ, kuɗic unto yi ki ti wolla ye.” ");
INSERT INTO moz_vpl VALUES ("JN8_53","073_8_53","JHN","8","53","53","Keeʼŋ goole ki ceere meegey Ibirayim wede inda, ti nebiyagi ɗoŋ i tʼinda ko? Kunuŋ kʼelkiyo kee wee wee?» ");
INSERT INTO moz_vpl VALUES ("JN8_54","073_8_54","JHN","8","54","54","Maŋ Isa yʼan di ruute, yʼede: «Aame nuŋ nʼa tʼimme tuddó maŋ, tammadó gette ki bita. Nuŋ i ni tamma Meegó, wede kunʼde yoŋ Raaguŋ gen̰n̰o, ");
INSERT INTO moz_vpl VALUES ("JN8_55","073_8_55","JHN","8","55","55","wo kun gi di yʼ suuniyo ye. Nuŋ ni yʼ suune, wo aame nʼa roote ni ki yʼ suune ye maŋ, geŋ nuŋ ni tʼize wede lohito kʼono aa kune. Wo ɗe nuŋ ni yʼ suune, wo ni dʼollige onamí nʼa-ti sooru eego. ");
INSERT INTO moz_vpl VALUES ("JN8_56","073_8_56","JHN","8","56","56","Aame meeguguŋ Ibirayim yʼilliga onniyadó yi ti wolla maŋ, addí a ûune tʼuŋsuwo, wo yi ti wulle maŋ, ulbí uŋse.» ");
INSERT INTO moz_vpl VALUES ("JN8_57","073_8_57","JHN","8","57","57","Maŋ kane deero Yawudiyagi an i di ruute, anʼde: «Kee ozzinagá ada paat toŋ i kʼîide ye, ɗe Ibirayim kʼa yi wulle mummino?» ");
INSERT INTO moz_vpl VALUES ("JN8_58","073_8_58","JHN","8","58","58","Isa yʼan di ruute, yʼede: «Ɗerec iŋkino wo nʼun di rooto: Ki poone Ibirayim an di yi tʼeha geŋ, “nuŋ miŋ nuŋ”.» ");
INSERT INTO moz_vpl VALUES ("JN8_59","073_8_59","JHN","8","59","59","Iŋkino maŋ an ziki moŋgali ki kakkisadí, wo Isa yi-ti digge diine ɗoŋ duuru, tʼadda booro Ɓoy Raa yʼa tʼuɗɗe. ");
INSERT INTO moz_vpl VALUES ("JN9_1","073_9_1","JHN","9","1","1","Onniyo soo Isa yi sooru, maŋ yi wulle wede koosiyo tʼume an yʼehe to. ");
INSERT INTO moz_vpl VALUES ("JN9_2","073_9_2","JHN","9","2","2","Maŋ kane sanalliyagí an di yʼ tunde, anʼde: «Wede dooyisadey, wede eŋ ize olɗiko miŋ, yode kunuŋ maawí ko, an di yʼehe koosiyo me?» ");
INSERT INTO moz_vpl VALUES ("JN9_3","073_9_3","JHN","9","3","3","Isa yʼan di ruute, yʼede: «Yoŋ koosiyo kono kʼolɗiko yode ye, wo kono kʼolɗiko maawí ye. An yʼehe koosiyo kono Raa yi dehu yʼa kize toogadí tʼurzi yode. ");
INSERT INTO moz_vpl VALUES ("JN9_4","073_9_4","JHN","9","4","4","Peeɗo to ede ɓotto, tʼa ki tʼiire ye geŋ, in dʼise naabo ki wede i nʼigibo. Aame diɗɗo tʼiina maŋ, wenɗa soo toŋ a naaba umbo. ");
INSERT INTO moz_vpl VALUES ("JN9_5","073_9_5","JHN","9","5","5","Aŋken̰n̰o nuŋ adda duniya ɓotto eŋ, nuŋ miŋ wede i dʼeliyo toore a ɗoŋ duniya pay.» ");
INSERT INTO moz_vpl VALUES ("JN9_6","073_9_6","JHN","9","6","6","Aame Isa yʼa ti ruute iŋkino maŋ, yi biɗɗe lee a siiɗo, yʼa-lutte, yi-tʼelite eda wede koosiyo gen̰n̰o, ");
INSERT INTO moz_vpl VALUES ("JN9_7","073_9_7","JHN","9","7","7","maŋ yi di ruute, yʼede: «Kʼodo, ki tʼopili a togile ki Silowe.» (Suma Silowe i-kaza «Agisa».) Wede geŋ yʼa iide, yʼa tʼupilo, yi-gimo maŋ yi wolliyo keren̰. ");
INSERT INTO moz_vpl VALUES ("JN9_8","073_9_8","JHN","9","8","8","Iŋkino maŋ kane ɗoŋ kʼita waayadí ti kane ɗoŋ i yi wullite yʼahultu geŋ, an di ruute, anʼde: «Ɗe eŋ wede i-ti konso, i dʼahultu ginno ye ko?» ");
INSERT INTO moz_vpl VALUES ("JN9_9","073_9_9","JHN","9","9","9","Ɗoŋ oŋgo anʼde: «Eŋ yode.» Oŋgo anʼde: «Ato, eŋ yode ye. Wenɗa eŋ yi yi deeƴiso.» Maŋ yode batum yʼede: «Eŋ miŋ nuuno ɗey.» ");
INSERT INTO moz_vpl VALUES ("JN9_10","073_9_10","JHN","9","10","10","Kane an di yi tunde, anʼde: «Kaŋ mummino edayá a tʼihina me?» ");
INSERT INTO moz_vpl VALUES ("JN9_11","073_9_11","JHN","9","11","11","Maŋ yoŋ yʼan diʼn gime onamaŋ, yʼede: «Wede an yi waaku Isa geŋ yi-lutte siiɗo ti lee bizí, wo yʼo-tʼelite a edayó, maŋ yʼo di ruute, yʼede: “Kʼodo, ki tʼopili a togile Silowe.” Nʼa iide, nʼa tʼupilo, maŋ edayó o-tʼihino.» ");
INSERT INTO moz_vpl VALUES ("JN9_12","073_9_12","JHN","9","12","12","Maŋ kane an di ruute, anʼde: «Wede geŋ too me?» Yoŋ yʼa ruute, yʼede: «Ɗaŋ ni ki suune ye.» ");
INSERT INTO moz_vpl VALUES ("JN9_13","073_9_13","JHN","9","13","13","Koosiyo wede edayí i tʼihina geŋ, an di tʼiide ki ɗaana Pariziyeŋ. ");
INSERT INTO moz_vpl VALUES ("JN9_14","073_9_14","JHN","9","14","14","Onniyo ere Isa yi lutte siiɗo, yi dʼihina eda wede geŋ, onniyo gette onniyo ere ki puukiyo Yawudiyagi. ");
INSERT INTO moz_vpl VALUES ("JN9_15","073_9_15","JHN","9","15","15","Iŋkino maŋ kane Pariziyeŋ toŋ an di yʼ tunde, anʼde: «Mummino edayá a tʼihina me?» Maŋ wede yʼan di ruute, yʼede: «Nʼuune bee me, wede yʼiideʼŋ, yʼo tʼuŋkite lee a edayó, wo nʼiideʼŋ nʼa tʼupilo, maŋ edayó a tʼihina, ni wolliyo.» ");
INSERT INTO moz_vpl VALUES ("JN9_16","073_9_16","JHN","9","16","16","Maŋ kane Pariziyeŋ oŋgo an di ruute, anʼde: «Wede ize naabo gette yi kʼiido ti Raa ye, kono yʼa ti diipiɗa onniyo ere ki puukiyadiŋ.» Wo ɗe kane ɗoŋ soŋ anʼde: «Wede kʼolɗiko sulɗi kʼarmika kino yʼaane yi tʼise ko?» Geŋ ti diinayaŋ an tʼîhinte. ");
INSERT INTO moz_vpl VALUES ("JN9_17","073_9_17","JHN","9","17","17","Iŋkino maŋ wede koosiyo edayí i tʼihina geŋ, an di yʼ tunde sey, anʼde: «Ɗe kee kʼede moo me a wede a ihina edayá me?» Maŋ wede yʼa ruute, yʼede: «Yoŋ geŋ nebi.» ");
INSERT INTO moz_vpl VALUES ("JN9_18","073_9_18","JHN","9","18","18","Wo kane deero Yawudiyagi an di-tuuge kʼamɓu, wede geŋ ti poone yoŋ koosiyo wo aŋkeŋ edayí a tʼihina me. Iŋkino an di wiiko maawi kʼehiyadí. ");
INSERT INTO moz_vpl VALUES ("JN9_19","073_9_19","JHN","9","19","19","Maawí an iina maŋ, an diʼn tunde, anʼde: «Yode eŋ ulo kune kotto ko? Wo kun yʼehe miŋ koosiyo to ko? Wo aŋkeŋ mummino yi wolliyo me?» ");
INSERT INTO moz_vpl VALUES ("JN9_20","073_9_20","JHN","9","20","20","Kane maawí an an diʼn gime onamaŋ, anʼde: «Eyye, ay suune eŋ uley, wo ay ehe koosiyo to. ");
INSERT INTO moz_vpl VALUES ("JN9_21","073_9_21","JHN","9","21","21","Wo aŋken̰n̰o yi wolliyo aaze mummino ay ki suune ye, wenɗa i ele beeko ay ki yʼ suune ye. Kun tondo yode, yoŋ en̰n̰o yi tʼize goole, yʼun ti rooto.» ");
INSERT INTO moz_vpl VALUES ("JN9_22","073_9_22","JHN","9","22","22","Maawí an rootiyo iŋkino kono an orgiso a deero Yawudiyagi, kono kane an ti ruute ti diinayaŋ anʼde, wede yi ruuta keren̰ Isa yoŋ Almasi Raa yi biire maŋ, an ti yʼ limma ti diinayaŋ me, kʼadda ɓoy wede Yawudiyagi ge dooyiso yi kʼetta ye. ");
INSERT INTO moz_vpl VALUES ("JN9_23","073_9_23","JHN","9","23","23","Geŋ iŋkino maawí an ruute, anʼde: «Yoŋ en̰n̰o yi tʼize goole, kun tondo yode» me. ");
INSERT INTO moz_vpl VALUES ("JN9_24","073_9_24","JHN","9","24","24","Maŋ kane Pariziyeŋ an di yʼ wiike sey ki sirwe, wo an i di ruute, anʼde: «Ki rooto ɗerec a ɗaana Raa, ki kaye maŋ ay suune wede eŋ yoŋ wede kʼolɗiko.» ");
INSERT INTO moz_vpl VALUES ("JN9_25","073_9_25","JHN","9","25","25","Iŋkino yoŋ yʼan di ruute, yʼede: «Nuŋ ni ki suune ye yoŋ wede kʼolɗiko, wede kʼolɗiko ye toŋ maŋ. Ki nuŋ munɗa wede ni suune, ti poone nuŋ koosiyo wo aŋkeŋ ni wolliyo.» ");
INSERT INTO moz_vpl VALUES ("JN9_26","073_9_26","JHN","9","26","26","Kane an di yʼ tunde, anʼde: «Yʼa ize moo me? Mummino me yʼa di tʼihina edayá me?» ");
INSERT INTO moz_vpl VALUES ("JN9_27","073_9_27","JHN","9","27","27","Yʼan di ruute, yʼede: «Nuŋ ono geŋ nʼun ti ruute, wo kun ki nʼilliga ye. Ɗe ki moo me kun dehu nʼun di roote sey me? Kunuŋ, kune toŋ kun dehu kun tʼise sanalliyagí pây ko?» ");
INSERT INTO moz_vpl VALUES ("JN9_28","073_9_28","JHN","9","28","28","Iŋkino maŋ an di yʼiise kalɗita, anʼde: «Kee sanallusu yode me, kaye sanalliyagi ki Muusa. ");
INSERT INTO moz_vpl VALUES ("JN9_29","073_9_29","JHN","9","29","29","Kaye ay suune a Muusa Raa yi ruute me, wo yo wede eŋ ay ki suune ye yʼettiyo ti tunɗa koo maŋ.» ");
INSERT INTO moz_vpl VALUES ("JN9_30","073_9_30","JHN","9","30","30","Wede yʼan di ruute, yʼede: «Onamguŋ eŋ nuŋ ni ziiɗa giggiró, wede yʼo tʼihina edayó miŋ, way kunʼde yʼettiyo ti tunɗa kun ki suune ye! ");
INSERT INTO moz_vpl VALUES ("JN9_31","073_9_31","JHN","9","31","31","Kine in suune Raa geŋ ɗoŋ kʼolɗiko yi kiʼn ollige ye. Wo yʼollige wede i ottilso wo yʼisiyo naabo ere aa yode Raa yi dehu. ");
INSERT INTO moz_vpl VALUES ("JN9_32","073_9_32","JHN","9","32","32","Tʼume kʼeesiyo duniya bini aŋki, wenɗa kaŋ soo toŋ yi kʼilliga ye wedusu yi di tʼihina eda koosiyo tʼume kʼehiyadí me. ");
INSERT INTO moz_vpl VALUES ("JN9_33","073_9_33","JHN","9","33","33","Aame wede eŋ yi kʼiido ti Raa ye maŋ, yi kʼaane yi ki tʼise munɗa ye.» ");
INSERT INTO moz_vpl VALUES ("JN9_34","073_9_34","JHN","9","34","34","Iŋkino maŋ kane an i di ruute, anʼde: «Kee miŋ tʼume kʼehiyadá to n̰ilpiyo adda kʼolɗiko, miŋ ki dehu kʼay diʼn dooye!» Maŋ an di yʼilmi, an di yʼuɗɗe paate. ");
INSERT INTO moz_vpl VALUES ("JN9_35","073_9_35","JHN","9","35","35","Aame Isa yʼilliga wede yi ihina edayí geŋ deero Yawudiyagi an ti yʼilmi maŋ, yʼa iide, yʼa yʼuuney wo yi di ruute, yʼede: «Kee ki ziipe addá ko a yoŋ wede an yʼehe aa ulo wede eŋ me?» ");
INSERT INTO moz_vpl VALUES ("JN9_36","073_9_36","JHN","9","36","36","Maŋ wede geŋ yi diʼn gime onamí, yʼede: «Yoŋ wee wee Galmeegó, kono nʼa zaape addó a yode me?» ");
INSERT INTO moz_vpl VALUES ("JN9_37","073_9_37","JHN","9","37","37","Isa yi di ruute, yʼede: «Wede ki yi wolliyo wo a-rootiyo, eŋ miŋ yode.» ");
INSERT INTO moz_vpl VALUES ("JN9_38","073_9_38","JHN","9","38","38","Maŋ wede yi di ruute, yʼede: «Nuŋ ni ziipe addó a kee, Galmeegó.» Yʼa-dikke, yʼa tʼuttile a ɗaanadí. ");
INSERT INTO moz_vpl VALUES ("JN9_39","073_9_39","JHN","9","39","39","Iŋkino maŋ Isa yi di ruute, yʼede: «Nuŋ nʼiido kʼadda duniya kono nʼa ɗekka booro, ɗoŋ koŋzayi edayaŋ a-tʼihina, wo ɗoŋ an wolliyo geŋ an tʼisa koŋzayi.» ");
INSERT INTO moz_vpl VALUES ("JN9_40","073_9_40","JHN","9","40","40","A sirpa geŋ i dʼede Pariziyeŋ an illiga iŋkino maŋ, an di ruute, anʼde: «Kunuŋ kaye toŋ ay tʼisa koŋzayi pay ko?» ");
INSERT INTO moz_vpl VALUES ("JN9_41","073_9_41","JHN","9","41","41","Isa yʼan di ruute, yʼede: «Aame kune koŋzayi wo munɗa wede kun isiyo kun ki suune ye maŋ, geŋ booro tʼun kiʼn seeɗa ye. Wo kune kunʼde kun wolliyo keren̰ geŋ, booro tʼun diʼn seeɗa, olɗikaguŋ a lekka daayum a egguŋ.» ");
INSERT INTO moz_vpl VALUES ("JN10_1","073_10_1","JHN","10","1","1","Isa yʼan di ruute sey, yʼede: «Ɗerec iŋkino wo nʼun di rooto: Aame wede yi kʼaɗɗiya ti biza ye, yi dahumu ti zaribe kʼadda kʼume moone damɓami me maŋ, yoŋ geŋ wede kʼoogire goole. ");
INSERT INTO moz_vpl VALUES ("JN10_2","073_10_2","JHN","10","2","2","Wo wede ettiyo ti biza geŋ, yoŋ wede kʼelso. ");
INSERT INTO moz_vpl VALUES ("JN10_3","073_10_3","JHN","10","3","3","A wede kʼelso geŋ, wede boohiyo damɓami yi di tʼihina biza. Yi-tʼette, yʼa waake damɓamí ere soo ti sundutú sundutú, wo kane an dʼollige golladí, pay yʼan aɗɗe paate. ");
INSERT INTO moz_vpl VALUES ("JN10_4","073_10_4","JHN","10","4","4","Aame yi tiʼn aɗɗiya pay ti paate maŋ, yʼan tʼoogumso wo kane an di yʼ daaniya, kono kane golladí an ti suune. ");
INSERT INTO moz_vpl VALUES ("JN10_5","073_10_5","JHN","10","5","5","Wo wede an ki yʼ suune ye geŋ, kuɗic kane an ki yʼ daane ye. Wo a jiire sey an tʼombe dokki ti tuddí me, kono golladí an ki ti suune ye.» ");
INSERT INTO moz_vpl VALUES ("JN10_6","073_10_6","JHN","10","6","6","Isa yʼan di ruute ono ombiɗe, wo ono geŋ itadaŋ an gi diʼn zuune ye, yi rootiyo munɗa me. ");
INSERT INTO moz_vpl VALUES ("JN10_7","073_10_7","JHN","10","7","7","Isa yʼan di ɗuule sey, yʼede: «Ɗerec iŋkino wo nʼun di rooto: Nuŋ miŋ aa biza bumɓu wede damɓami an dʼaɗɗiya. ");
INSERT INTO moz_vpl VALUES ("JN10_8","073_10_8","JHN","10","8","8","Ɗoŋ iido ki poone ti nuŋ geŋ, kane deero kʼoogire, wo kaneʼŋ damɓami an kiʼn illiga ye. ");
INSERT INTO moz_vpl VALUES ("JN10_9","073_10_9","JHN","10","9","9","Nuŋ miŋ aa biza bumɓu. Aame wede yʼettiyo tʼurzi nuuno maŋ, yʼa tʼoona uttiyo. Yi-tʼette wo yʼa tʼaɗɗe aa addí i dehu, wo omɓo toŋ yi-tʼoona. ");
INSERT INTO moz_vpl VALUES ("JN10_10","073_10_10","JHN","10","10","10","Wede kʼoogire geŋ yʼettiyo miŋ ki oogire, ki tôwwo wo ki lattiya. Wo nuŋ nʼiido kono nʼan tʼele lekkiyo a ɗuwo, lekkiyo ere adda darna. ");
INSERT INTO moz_vpl VALUES ("JN10_11","073_10_11","JHN","10","11","11","Nuŋ miŋ wede kʼelso beehiye. Wede kʼelso beehiye geŋ yʼa oyye yʼa tʼinda kono damɓamí me. ");
INSERT INTO moz_vpl VALUES ("JN10_12","073_10_12","JHN","10","12","12","Wo wede i naabiya ki ran̰n̰adí, yoŋ wede kʼelso ye, damɓami ki yode ye geŋ, yi wulle sullibe yi tʼuɗɗo maŋ, yʼa tʼombe, damɓami yi dʼooli. Maŋ damɓami sullibe yi-seɗɗe, wo ɗoŋ soŋ an aa di-teepe. ");
INSERT INTO moz_vpl VALUES ("JN10_13","073_10_13","JHN","10","13","13","Wede i naabiya ki ran̰n̰adí geŋ, yoŋ yʼa tʼombe kono yi wolliyo munɗa wede ki yode, yoŋ seezí ye a damɓami me. Nuŋ wede kʼelso beehiye, ");
INSERT INTO moz_vpl VALUES ("JN10_14","073_10_14","JHN","10","14","14","damɓamó niʼni suune, wo kane an ni suune. ");
INSERT INTO moz_vpl VALUES ("JN10_15","073_10_15","JHN","10","15","15","Aakede Meega yi ni suune, wo nuŋ toŋ ni yʼ suune. Nʼa oyye nʼa tʼinda kono damɓamó. ");
INSERT INTO moz_vpl VALUES ("JN10_16","073_10_16","JHN","10","16","16","Nuŋ oo dʼede damɓami ti doolo toŋ ede, an aa ki tʼiido kʼadda zaribe en̰n̰o ye. Kane gen̰n̰o toŋ nʼa-tiʼn waako pây, an dʼolliga golladó. Iŋkino a tʼisa torɗo soo, wede kʼelso toŋ soo. ");
INSERT INTO moz_vpl VALUES ("JN10_17","073_10_17","JHN","10","17","17","Meega geŋ yi ni giyye kono nuŋ nʼiyye nʼa tʼinda, kono saŋ nʼa balɗa. ");
INSERT INTO moz_vpl VALUES ("JN10_18","073_10_18","JHN","10","18","18","Wenɗa soo toŋ umbo aane a tʼooɗiba puukiyadó te, i tʼeliyo nuŋ ti siidó. Nuŋ o dʼede toogo kʼooɗibe puukiyadó wo o dʼede toogo kʼeliyo a umatú. Geŋ iŋkino munɗa wede Meegó yʼo ruute nʼaase me.» ");
INSERT INTO moz_vpl VALUES ("JN10_19","073_10_19","JHN","10","19","19","Aame kane deero Yawudiyagi an illiga ono kʼIsa iŋkino maŋ, ti tuddaŋ an tʼîhinte sey. ");
INSERT INTO moz_vpl VALUES ("JN10_20","073_10_20","JHN","10","20","20","Ɗoŋ ɓaadaŋ ti diinayaŋ an di ruute, anʼde: «Yoŋ geŋ ki maade, siitan a eedí. Ɗe ki moo me kun di yʼollige me?» ");
INSERT INTO moz_vpl VALUES ("JN10_21","073_10_21","JHN","10","21","21","Wo ɗoŋ soŋ anʼde: «Eŋ ono ki wede i-dʼede siitan a eedí ye. Ki kotto siitan ti kʼaane ti ki tʼihina eda ki koŋzayi ye.» ");
INSERT INTO moz_vpl VALUES ("JN10_22","073_10_22","JHN","10","22","22","Ozzine ti ozzine, a sommide a ume reele ɓaadaŋ maŋ, an dʼisiyo tarnaape a Zeruzalem kono an dʼelkiyo a onniyo ere Ɓoy Raa an di yʼize kamilen̰. ");
INSERT INTO moz_vpl VALUES ("JN10_23","073_10_23","JHN","10","23","23","Aame geŋ Isa yi-tʼiide adda booro Ɓoy Raa, yi sooru adda daabe goole wede an yi waaku Daabe Salamoŋ, yi dʼamɓu kʼume soo me, soo me. ");
INSERT INTO moz_vpl VALUES ("JN10_24","073_10_24","JHN","10","24","24","Iŋkino kane deero Yawudiyagi an di ti ɗuule, wo an i-di ruute, anʼde: «Ɗe keeʼŋ ay della, kʼay kʼiza tuddá woogo me? Aame kee Almasi Raa yi biire maŋ, kʼay ti rooti keren̰.» ");
INSERT INTO moz_vpl VALUES ("JN10_25","073_10_25","JHN","10","25","25","Maŋ Isa yʼan di ruute, yʼede: «Nuŋ nʼun ruute, wo kun ki ziipe adduguŋ a nuuno ye. Naabo ere pay nuŋ nʼisiyo ti suma Meegó gette, i-kaza a tukki nuŋ. ");
INSERT INTO moz_vpl VALUES ("JN10_26","073_10_26","JHN","10","26","26","Wo kune kun ki ziipe adduguŋ a nuuno ye, kono kune damɓamó ye. ");
INSERT INTO moz_vpl VALUES ("JN10_27","073_10_27","JHN","10","27","27","Damɓamó an dʼollige golla nuŋ wede kʼelsadaŋ. Nuŋ niʼni suune wo kane an di nʼ daaniya. ");
INSERT INTO moz_vpl VALUES ("JN10_28","073_10_28","JHN","10","28","28","Nuŋ nʼan tʼela lekkiyo ere ki daayum. Kuɗic an ki tʼinda ye wo wenɗa soo toŋ a tiʼn tʼooba ti beezó umbo. ");
INSERT INTO moz_vpl VALUES ("JN10_29","073_10_29","JHN","10","29","29","Meegó wede oo nʼelo geŋ yoŋ toogo yʼa jiire pay, wenɗa soo toŋ umbo a aane a-tʼoobe munɗa ti bey Meega me. ");
INSERT INTO moz_vpl VALUES ("JN10_30","073_10_30","JHN","10","30","30","Nuŋ ti Meega geŋ kaye wede soo.» ");
INSERT INTO moz_vpl VALUES ("JN10_31","073_10_31","JHN","10","31","31","Iŋkino maŋ kane deero Yawudiyagi an ziki moŋgali sey ki kakkisadí ki tôwwadí. ");
INSERT INTO moz_vpl VALUES ("JN10_32","073_10_32","JHN","10","32","32","Isa yʼan di ruute, yʼede: «Nuŋ a ɗaanaguŋ nʼize naabo beehiye ɓaadaŋ ti suma Meegó me, wo naabo tiŋ tuuku ere nʼize kun dehu kun di nʼ kakkite ti moŋgali ki tôwwadó me?» ");
INSERT INTO moz_vpl VALUES ("JN10_33","073_10_33","JHN","10","33","33","Kane deero Yawudiyagi an i-di ruute, anʼde: «Ay dehu ay ki ti kakkite ti moŋgali ay gi di tʼîde ki naabo ere beehiye kʼize gettiyo ye. Ay ki tʼîde kono ki kalɗa suma Raa, kee wedusu, wo ki-ti tʼisiyo tuddá Raa.» ");
INSERT INTO moz_vpl VALUES ("JN10_34","073_10_34","JHN","10","34","34","Isa yʼan di ruute, yʼede: «Ono eŋ an riiŋe ti kaaga adda mattup kʼoogiraguŋ: “Raa yʼede kune raayagi.” ");
INSERT INTO moz_vpl VALUES ("JN10_35","073_10_35","JHN","10","35","35","Kun suune wenɗa soo toŋ umbo a aane a tʼooɗiba munɗa wede an riiŋe ti kaaga adda mattup ki Raa me. Geŋ iŋkino kane ɗoŋ Raa yʼan ruute onamí geŋ, yʼanni wiike kane raayagi me. ");
INSERT INTO moz_vpl VALUES ("JN10_36","073_10_36","JHN","10","36","36","Wo nuŋ wede Raa yʼa-nʼuuye kese a yode, yʼa-nʼigibo kʼadda duniya, wo ni rootiyo nʼede nuŋ Ulo Raa maŋ, kune kunʼde ni kalɗita suma Raa. Geŋ kaŋ mummino ni kalɗita me? ");
INSERT INTO moz_vpl VALUES ("JN10_37","073_10_37","JHN","10","37","37","Aame ni kʼisiyo naabo Meegó ye maŋ, kune toŋ kun ki zaape adduguŋ a nuuno ye. ");
INSERT INTO moz_vpl VALUES ("JN10_38","073_10_38","JHN","10","38","38","Wo aame naabo Meega ni ti tʼisiyo wo a nuŋ kun ki zaape adduguŋ ye toŋ, kun zaapo adduguŋ a naabo gettiyo, kono tiŋ geŋ kun di suuna keren̰ Meega ti nuŋ wo nuŋ ti yode.» ");
INSERT INTO moz_vpl VALUES ("JN10_39","073_10_39","JHN","10","39","39","Iŋkino maŋ kane Yawudiyagi an di dihe seeɗuzí sey, wo yoŋ yʼan tʼumbilke. ");
INSERT INTO moz_vpl VALUES ("JN10_40","073_10_40","JHN","10","40","40","Maŋ Isa yʼa-gime, yi-ti diipiɗa ti dar kʼooye Zurden ki kese peeɗo ge-koliyo, kʼume wede Zaŋ yʼa zuyyite batem ti poone. Yi lekkiyo aŋgen̰n̰o. ");
INSERT INTO moz_vpl VALUES ("JN10_41","073_10_41","JHN","10","41","41","Ɗoŋ ɓaadaŋ an dʼiide tuddí, wo an di rootiyo, anʼde: «Zaŋ geŋ munɗa kʼarmika yi kʼize ye, wo ono ɗoŋ yi ruutite a tukkʼIsa geŋ ɗerec.» ");
INSERT INTO moz_vpl VALUES ("JN10_42","073_10_42","JHN","10","42","42","A ume geŋ ɗoŋ ɓaadaŋ an di ziipe addaŋ a yode Isa. ");
INSERT INTO moz_vpl VALUES ("JN11_1","073_11_1","JHN","11","1","2","I dʼede wede soo sundí Lazar ti ille ki Betani. Yoŋ geŋ leema Mariyam ti Marte, an lekkiyo kaŋ soo, wo to Mariyam gette ere i di ƴirgite egey ɗoŋ eeɗiyadaŋ uŋse a zoŋ kʼIsa, tʼa di zippite tʼilaltú. Maŋ onniyo soo leemadaŋ Lazar geŋ yi tʼiire eeni. ");
INSERT INTO moz_vpl VALUES ("JN11_3","073_11_3","JHN","11","3","3","Iŋkino maŋ kane zemɓadí geŋ an di gibe wedusu, yi di rooto a Isa, yʼiideʼŋ yʼede: «Galmeegey kʼollo, laŋzayá wede ki giyye geŋ, yi tʼiire eeni.» ");
INSERT INTO moz_vpl VALUES ("JN11_4","073_11_4","JHN","11","4","4","Aame Isa yʼilliga iŋkino maŋ, yʼa ruute, yʼede: «Tʼeeni geŋ Lazar yi ki tʼinda ye, wo tʼurzi geŋ ɗuwo an di tʼimma Raa. Wo soŋ tʼurzi geŋ ɗuwo an di tʼimma Ulo Raa.» ");
INSERT INTO moz_vpl VALUES ("JN11_5","073_11_5","JHN","11","5","5","To Marte ti teematú Mariyam wo Lazar geŋ, Isa yiʼni giyye ɓaadaŋ. ");
INSERT INTO moz_vpl VALUES ("JN11_6","073_11_6","JHN","11","6","6","Wo aame yʼilliga Lazar tuddí eeni maŋ, yʼa kʼiide kaamiki ye. A umayí geŋ yi likke onniyo sire. ");
INSERT INTO moz_vpl VALUES ("JN11_7","073_11_7","JHN","11","7","7","Saŋ maŋ yʼan di ruute sanalliyagi, yʼede: «In ti kime ki siiɗo Ziide.» ");
INSERT INTO moz_vpl VALUES ("JN11_8","073_11_8","JHN","11","8","8","Maŋ kane sanalliyagi an i di ruute, anʼde: «Wede dooyisadey, ɓotto ɓotto eŋ miŋ Yawudiyagi an dehu an ki ti kakkite ti moŋgali ki tôwwadá, miŋ ki dehu kʼa kime kʼummey sey!» ");
INSERT INTO moz_vpl VALUES ("JN11_9","073_11_9","JHN","11","9","9","Isa yʼan di ruute, yʼede: «Tʼume peeɗo ti koliyo bini tʼa-tʼoore geŋ, umeʼŋ toore keren̰, wo wede yi sooru toŋ maŋ morkiƴe yi ki tʼele ye, kono yi wolliyo toore ki ɗoŋ duniya pay. ");
INSERT INTO moz_vpl VALUES ("JN11_10","073_11_10","JHN","11","10","10","Wo wede yi sooru diɗɗo maŋ, yʼa tʼele morkiƴagi kono toore i-kʼede ye.» ");
INSERT INTO moz_vpl VALUES ("JN11_11","073_11_11","JHN","11","11","11","Aame Isa yi ruute iŋkino maŋ, yʼan di ruute sey, yʼede: «Laŋzayiŋ Lazar edayí i ziiɗa moone, wo nuŋ nʼette nʼa ti yʼ tʼinney.» ");
INSERT INTO moz_vpl VALUES ("JN11_12","073_11_12","JHN","11","12","12","Maŋ kane sanalliyagi an i di ruute, anʼde: «Ɗe yi moone maŋ, saŋ yʼa utta.» ");
INSERT INTO moz_vpl VALUES ("JN11_13","073_11_13","JHN","11","13","13","Yo Isa yi ruute iŋkino ti moone ere Lazar yʼinda, wo kane an elkiyo ti moone ere aa daayum. ");
INSERT INTO moz_vpl VALUES ("JN11_14","073_11_14","JHN","11","14","14","Iŋkino maŋ Isa yʼan di ruute pataŋ, yʼede: «Lazar yʼinda. ");
INSERT INTO moz_vpl VALUES ("JN11_15","073_11_15","JHN","11","15","15","Nuŋ ulbó uŋse a kune sanalliyagó, kono nʼa tʼize umbo a untadí me. Tʼurzi geŋ un tʼela toogo kun di zaapa adduguŋ a nuuno. Wo aŋkeŋ in eŋgile, in ti yʼ wollo.» ");
INSERT INTO moz_vpl VALUES ("JN11_16","073_11_16","JHN","11","16","16","Iŋkino maŋ Toma wede an yi waaku soŋ Wede Rooŋo geŋ, yʼan di ruute a sanalliyagi oŋgoŋ, yʼede: «Kun tʼoozo, kine toŋ in di tʼindey ti yode.» ");
INSERT INTO moz_vpl VALUES ("JN11_17","073_11_17","JHN","11","17","17","Isa yʼa iiney Betani. A aaniyadí geŋ an i di ruute Lazar an tʼeele adda muuzo îide onniyo piɗe. ");
INSERT INTO moz_vpl VALUES ("JN11_18","073_11_18","JHN","11","18","18","Betani gette todʼte goppoŋ ti Zeruzalem me, suma kuɓɓaara aɗo. ");
INSERT INTO moz_vpl VALUES ("JN11_19","073_11_19","JHN","11","19","19","Iŋkino maŋ a unto ki Lazar leema Mariyam ti Marte geŋ, ti Zeruzalem Yawudiyagi ɓaadaŋ an dʼiide selliyadaŋ. ");
INSERT INTO moz_vpl VALUES ("JN11_20","073_11_20","JHN","11","20","20","Aame Marte tʼilliga Isa yʼiina goppoŋ tʼilladaŋ maŋ, tʼa tʼiiziga tʼa tʼiide okkimayí, wo to Mariyam gette ti lekkiyo a ɓoy. ");
INSERT INTO moz_vpl VALUES ("JN11_21","073_11_21","JHN","11","21","21","Marte ti yʼuuney maŋ, ti di ruute, tʼede: «Galmeeʼki nuŋ, aŋki kee ede maŋ, leemadó yi ki tʼinda ye. ");
INSERT INTO moz_vpl VALUES ("JN11_22","073_11_22","JHN","11","22","22","Wo nuŋ ni suune aŋken̰n̰o toŋ maŋ, munɗa wede ki tonde Raa geŋ, Raa yʼaane yʼa-tʼele.» ");
INSERT INTO moz_vpl VALUES ("JN11_23","073_11_23","JHN","11","23","23","Maŋ Isa yi di ruute, yʼede: «Leemadí geŋ yi-balɗa.» ");
INSERT INTO moz_vpl VALUES ("JN11_24","073_11_24","JHN","11","24","24","Marte ti di ruute, tʼede: «Nuŋ ni suune a onniyo kʼita ɗoŋ i tʼinda an ti balɗa geŋ, yode toŋ yʼa-balɗa.» ");
INSERT INTO moz_vpl VALUES ("JN11_25","073_11_25","JHN","11","25","25","Isa yi di ruute, yʼede: «Nuŋ miŋ wede i dʼeliyo lekkiyo wo i balɗiya ɗoŋ unto. Wede yi ziipa addí a nuuno maŋ, aame yʼinda toŋ yʼa-balɗa. ");
INSERT INTO moz_vpl VALUES ("JN11_26","073_11_26","JHN","11","26","26","Wo wede tuuku yi lekkiyo, wo yi zaapu addí a nuuno maŋ, kuɗic unto yi ki ti wolla ye. A ono eŋ koŋ mʼumɓe ko?» ");
INSERT INTO moz_vpl VALUES ("JN11_27","073_11_27","JHN","11","27","27","Maŋ todʼ ti diʼn gime onamí, tʼede: «Eyye Galmeeʼki nuŋ, nuŋ nʼumɓe kee Almasi Raa yi biire, wo Ulo Raa, wede Raa yi ruute a etto ki duniya.» ");
INSERT INTO moz_vpl VALUES ("JN11_28","073_11_28","JHN","11","28","28","Iŋkino maŋ, tʼa-gime waaku teematú Mariyam. Tʼiideʼŋ ti di milin̰e, tʼede: «Wede dooyisadiŋ yo a en̰n̰o. Mʼedi, yi kin tondiyo.» ");
INSERT INTO moz_vpl VALUES ("JN11_29","073_11_29","JHN","11","29","29","Mariyam tʼilliga iŋkino maŋ, perek tʼa tʼiiziga, tʼa iŋgile kʼume yode. ");
INSERT INTO moz_vpl VALUES ("JN11_30","073_11_30","JHN","11","30","30","Aame geŋ Isa kʼadda kʼille yi ki tʼiide ye ɓotto. Yo daayum a ume Marte tʼa yʼuuney gen̰n̰o. ");
INSERT INTO moz_vpl VALUES ("JN11_31","073_11_31","JHN","11","31","31","Kane Yawudiyagi ɗoŋ a ita Mariyam an ti selliyo geŋ an wulle ti tʼiiziga perek maŋ, kane toŋ an a-tʼiiziga, an di-diine, kono an elkiyo ti tʼette môolo ki biza muuzo. ");
INSERT INTO moz_vpl VALUES ("JN11_32","073_11_32","JHN","11","32","32","Mariyam gette tʼiiney aame kʼIsa wo ti yʼ wulle maŋ, tʼa dikke a ɗaanadí, wo ti di ruute, tʼede: «Galmeeʼki nuŋ, aŋki kee ede maŋ, leemadó yi ki tʼinda ye.» ");
INSERT INTO moz_vpl VALUES ("JN11_33","073_11_33","JHN","11","33","33","Isa yi wulle Mariyam ti môolo ti Yawudiyagi ɗoŋ a itatú pay maŋ, yode toŋ addí yʼa ki nʼiiɓe ye, a-litte. ");
INSERT INTO moz_vpl VALUES ("JN11_34","073_11_34","JHN","11","34","34","Maŋ yʼa tunde, yʼede: «A ume too me kun ti yʼeele me?» Wo kane an i di ruute, anʼde: «Kʼedi Galmeegey, kʼa wolley a ummey.» ");
INSERT INTO moz_vpl VALUES ("JN11_35","073_11_35","JHN","11","35","35","Iŋkino maŋ Isa edayí a ise solɗite zumari. ");
INSERT INTO moz_vpl VALUES ("JN11_36","073_11_36","JHN","11","36","36","Maŋ kane Yawudiyagi an di ruute, anʼde: «Kun ki wollo ɗo, yi giyye ɓaadaŋ ɗe me, yi môolo me.» ");
INSERT INTO moz_vpl VALUES ("JN11_37","073_11_37","JHN","11","37","37","Wo kane ɗoŋ oŋgo ti diinayaŋ an di ruute, anʼde: «Yoŋ wede i di tʼihina eda wede koosiyo ɗe, ki moo me yʼa iili Lazar yʼa inda me?» ");
INSERT INTO moz_vpl VALUES ("JN11_38","073_11_38","JHN","11","38","38","Isa geŋ daayum yi kʼiine addí yi ki nʼiiɓe ye, yʼa tʼiide biza muuzo. Wo to muuzo gette aa urmi, an tʼele nuune adda, biza an a-ti ɗuŋkile zumbulu. ");
INSERT INTO moz_vpl VALUES ("JN11_39","073_11_39","JHN","11","39","39","Isa yʼan di ruute, yʼede: «Zumbulu kun ti yʼ ɗoŋkilo ti biza muuzo me.» Maŋ Marte teema ki wede inda geŋ, ti di ruute, tʼede: «Galmeeʼki nuŋ, yoŋ yʼeeɗiyo baa kono i dʼede onniyo piɗe tʼume an ti yʼeele adda muuzo me.» ");
INSERT INTO moz_vpl VALUES ("JN11_40","073_11_40","JHN","11","40","40","Maŋ Isa yi di ruute, yʼede: «Nuŋ ni ruute ɗe me, aame mi ziipa addí a nuuno maŋ, mʼa wolla toogo ki Raa.» ");
INSERT INTO moz_vpl VALUES ("JN11_41","073_11_41","JHN","11","41","41","Maŋ zumbulu ti biza muuzo an ti yʼ ɗuŋkile. Aame geŋ Isa yʼa tʼumɓe edayí kʼawwa, yʼa ruute, yʼede: «Koɗuwo ɓaadaŋ a kee Meegó, kono kee ki nʼilliga. ");
INSERT INTO moz_vpl VALUES ("JN11_42","073_11_42","JHN","11","42","42","Ɗerec, nuŋ ni suune daayum kee ki nʼollige, wo nuŋ ni rootiyo iŋkino a ɗoŋ sirpadó eŋ an dʼamɓe kono i nʼigibo kee Raa.» ");
INSERT INTO moz_vpl VALUES ("JN11_43","073_11_43","JHN","11","43","43","Aame yʼa ti ruute iŋkino maŋ, yʼa iɗili ti golla awwa, yʼede: «Lazar, ki-tʼaɗɗi!» ");
INSERT INTO moz_vpl VALUES ("JN11_44","073_11_44","JHN","11","44","44","Maŋ Lazar wede inda geŋ yʼa bilɗe, yʼa tʼuɗɗo tʼadda muuzo me, beyɗí ti zoŋɗí geŋ tuuniyto ti buɗɗani, wo eedí diibiyo ti buuɗe pây. Wo Isa yʼan di ruute a ɗoŋ sirpa geŋ, yʼede: «Buɗɗani kun i tʼeezito, wo kun di yʼoolo, yʼa eŋgile.» ");
INSERT INTO moz_vpl VALUES ("JN11_45","073_11_45","JHN","11","45","45","Yawudiyagi ɓaadaŋ ɗoŋ iido selliyo Mariyam geŋ an wulle armika ere Isa yʼize gettiyo maŋ, an di ziipe addaŋ a yode. ");
INSERT INTO moz_vpl VALUES ("JN11_46","073_11_46","JHN","11","46","46","Wo ɗoŋ oŋgo an iideʼŋ, an an di gize a Pariziyeŋ a munɗa wede Isa yʼize. ");
INSERT INTO moz_vpl VALUES ("JN11_47","073_11_47","JHN","11","47","47","Maŋ kane deero ɗoŋ seɗeke ti Pariziyeŋ geŋ an tʼugiye deero booro Yawudiyagi, an di ruute diinayaŋ, anʼde: «In dʼise mummino, kono wede eŋ yʼisiyo sulɗi kʼarmika ɓaadaŋ. ");
INSERT INTO moz_vpl VALUES ("JN11_48","073_11_48","JHN","11","48","48","Aame in yʼiila a naabadí ettiyo maŋ, ɗuwo pay an di zaapa addaŋ a yode, iŋkino kane Romeŋ an dʼetto, Ɓoy kamilen̰ ki Raa an ti yʼ latta wo siiɗadiŋ pây.» ");
INSERT INTO moz_vpl VALUES ("JN11_49","073_11_49","JHN","11","49","49","Maŋ ti diinayaŋ i dʼede wede soo sundí Kayip, a ozzine geŋ mozigo goole ɗoŋ seɗeke yode, yʼan di ruute, yʼede: «Kune munɗa kun ki suune ye. ");
INSERT INTO moz_vpl VALUES ("JN11_50","073_11_50","JHN","11","50","50","Kun ki wolliyo ye ko, munɗa wede beehiye a kine, wede soo yʼa tʼinda ki kine ɗoŋ siiɗo, miŋ kine pay in di tʼinda.» ");
INSERT INTO moz_vpl VALUES ("JN11_51","073_11_51","JHN","11","51","51","Wo ono ɗoŋ uɗɗe ti bize geŋ i kʼiido ti suuniyo yode ye, kono a ozzine geŋ mozigo goole ɗoŋ seɗeke yode geŋ, Raa yi-dʼele ono ɗoŋ yʼa ruute Isa yʼa tʼinda kono ɗoŋzí Yawudiyagi. ");
INSERT INTO moz_vpl VALUES ("JN11_52","073_11_52","JHN","11","52","52","Wo yi tʼinda ki ɗoŋ siiɗo ɗaŋŋal ye, wo ɗe kʼogiyso kʼin̰n̰i Raa ɗoŋ i-tiipe, an tʼisa kaŋ soo. ");
INSERT INTO moz_vpl VALUES ("JN11_53","073_11_53","JHN","11","53","53","Geŋ iŋkino ti onniyo gette kane pay an dʼiyye ki tôwwadí. ");
INSERT INTO moz_vpl VALUES ("JN11_54","073_11_54","JHN","11","54","54","Tiŋ geŋ yode Isa toŋ tuddí yʼa ti ziiɗa, yi gi di waariya ye a diine Yawudiyagi me. Wo tʼumayí geŋ yʼa tʼirga, yʼa iŋgile ki geeger sundutú Epirayim a biza balɗa, ti sanalliyagí an di lekkiyo aŋgen̰n̰o. ");
INSERT INTO moz_vpl VALUES ("JN11_55","073_11_55","JHN","11","55","55","Aame geŋ tarnaape Pak ki Yawudiyagi aa guute goppoŋ. Iŋkino maŋ ɗoŋ ɓaadaŋ tʼadda siiɗiyagi an di-gili ki Zeruzalem kono an tʼokkimey tuddaŋ, an tʼise kamilen̰ a ɗaana Raazaŋ. ");
INSERT INTO moz_vpl VALUES ("JN11_56","073_11_56","JHN","11","56","56","Adda booro Ɓoy Raa geŋ Isa an di yʼ wekkutu, an di rootiyo tuddaŋ, anʼde: «Elkiyaguŋ moo me? Kun elkiyo miŋ Isa yʼetto ko tarnaape me?» ");
INSERT INTO moz_vpl VALUES ("JN11_57","073_11_57","JHN","11","57","57","Kane deero ɗoŋ seɗeke ti Pariziyeŋ geŋ an di ruute, anʼde: «Wede tuuku yi zuuna ume kʼIsa maŋ, yʼay di rooto, ay di seeɗa.» ");
INSERT INTO moz_vpl VALUES ("JN12_1","073_12_1","JHN","12","1","1","Onniyo zoot ki poone tarnaape Pak ki Yawudiyagi yʼa aana geŋ, Isa yʼa tʼiide Betani, ille ki Lazar wede Isa yʼa ti yʼ bilɗe ti diine ɗoŋ unto. ");
INSERT INTO moz_vpl VALUES ("JN12_2","073_12_2","JHN","12","2","2","Aame Isa yʼiiney Betani maŋ, an dʼize omɓo ti sundí. Marte ere kʼeliyo kʼomɓadaŋ, wo Lazar yoŋ ti diine ɗoŋ an iimi kaŋ soo. ");
INSERT INTO moz_vpl VALUES ("JN12_3","073_12_3","JHN","12","3","3","Maŋ Mariyam ti dʼumɓe egey ɗoŋ eeɗiyadaŋ uŋse sundaŋ nardo, daa kalsiya munɗa, suma litir a diinayí wo zooyayaŋ oon̰e. Ti di ƴirgite zoŋ kʼIsa, wo tʼa zippite tʼilaltú. Ɓoy geŋ i dʼûune ti eeɗiyo ki egey gen̰n̰o. ");
INSERT INTO moz_vpl VALUES ("JN12_4","073_12_4","JHN","12","4","4","Maŋ i dʼede wede soo ti diine kane sanalliyagi kʼIsa sundí Ziidas Iskariyot, yode wede an di yʼ tʼela Isa a bey ɗoŋ kʼolmiɗayí geŋ, yʼede: ");
INSERT INTO moz_vpl VALUES ("JN12_5","073_12_5","JHN","12","5","5","«I dehu egey eŋ in tʼowila a aɗɗe suma wede yʼa naabe ki ozzine batum, wo in an tʼele soŋko gette a ɗoŋ an kʼede munɗa ye!» ");
INSERT INTO moz_vpl VALUES ("JN12_6","073_12_6","JHN","12","6","6","Ziidas yi rootiyo iŋkino kono yoŋ wede kʼoogire. I sarkiya korɓitayaŋ yode, wo yi ti sokiyto. Yi ki wolliyo sommagi ki ɗoŋ munɗa an kʼede ye ye. ");
INSERT INTO moz_vpl VALUES ("JN12_7","073_12_7","JHN","12","7","7","Maŋ Isa yʼa ruute, yʼede: «Todʼte kun tʼoolo ɗeɗɗek, kono naabo ere todʼ tʼize ette aakede ti nʼikkima ki poone an di nʼ tʼela adda muuzo. ");
INSERT INTO moz_vpl VALUES ("JN12_8","073_12_8","JHN","12","8","8","Kane ɗoŋ an kʼede munɗa ye geŋ an lekka daayum ti kune, wo ɗe nuŋ ni ki lekka daayum ti kune ye.» ");
INSERT INTO moz_vpl VALUES ("JN12_9","073_12_9","JHN","12","9","9","Maŋ kane Yawudiyagi ɓaadaŋ an dʼilliga Isa yo a Betani. Iŋkino maŋ an dʼiŋgile ki Betani, wo ettiyadaŋ an iide gette an di wollo Isa ɗaŋŋal ye, wo an a di wollo Lazar wede Isa yi ti yʼ bilɗe ti diine ɗoŋ unto pây. ");
INSERT INTO moz_vpl VALUES ("JN12_10","073_12_10","JHN","12","10","10","Ti onniyo gettiŋ kane deero ɗoŋ seɗeke an di dihe Lazar toŋ an di yʼ tʼîde, ");
INSERT INTO moz_vpl VALUES ("JN12_11","073_12_11","JHN","12","11","11","kono tʼurzi yode Yawudiyagi ɓaadaŋ an tʼargu ti tuddaŋ wo an di zaapu addaŋ a Isa. ");
INSERT INTO moz_vpl VALUES ("JN12_12","073_12_12","JHN","12","12","12","Ti soggatú maŋ kane ɗoŋ ɓaadaŋ iide tarnaape geŋ, an dʼilliga Isa yʼettiyo kʼadda geeger Zeruzalem. ");
INSERT INTO moz_vpl VALUES ("JN12_13","073_12_13","JHN","12","13","13","Iŋkino maŋ kane ɗoŋ geŋ an dimɓo puutagi kʼinda sundaŋ palmiye a beyɗaŋ, an tʼiide okkimayí, an di ɗollite, an dʼeesiyo: «Tamma a Raa! Beeko Raa ti koona a ekki wede ettiyo ti suma Galmeega Raa, yoŋ mozigo ki ɗoŋ kʼIzirayel!» ");
INSERT INTO moz_vpl VALUES ("JN12_14","073_12_14","JHN","12","14","14","Isa yi dʼuune ulo buuru, yʼa-ti gili eego, geŋ a-tʼiide a ono ɗoŋ an riiŋe ti kaaga adda mattup ki Raa, anʼde: ");
INSERT INTO moz_vpl VALUES ("JN12_15","073_12_15","JHN","12","15","15","«Kune ɗoŋ geeger Siyoŋ kun orgiɗe ye. En̰n̰o mozigaguŋ yʼettiyo, yʼa ti gilo ekkʼulo buuru.» ");
INSERT INTO moz_vpl VALUES ("JN12_16","073_12_16","JHN","12","16","16","Munɗa wede ize geŋ ki poone sanalliyagí an ki zuune ye. Wo aame Isa yi-gili kandaane goolikadí Raa yi-tʼele maŋ, kane an dʼilke kaciŋ munɗa wede an riiŋe ti kaaga adda mattup ki Raa a tukkʼIsa geŋ, a-tʼiide. ");
INSERT INTO moz_vpl VALUES ("JN12_17","073_12_17","JHN","12","17","17","Aame Isa yʼa wiike Lazar tʼadda muuzo wo yʼa ti yʼ bilɗe ti diine ɗoŋ unto geŋ, ɗoŋ ɓaadaŋ an wulle, maŋ kane geŋ an iideʼŋ, an di gizite a ɗuwo a munɗa wede ize me. ");
INSERT INTO moz_vpl VALUES ("JN12_18","073_12_18","JHN","12","18","18","Iŋkino maŋ ɗoŋ ɓaadaŋ an dʼukke okkimayí, kono an illiga munɗa kʼarmika wede yʼize geŋ me. ");
INSERT INTO moz_vpl VALUES ("JN12_19","073_12_19","JHN","12","19","19","Maŋ kane Pariziyeŋ an dʼiise rootiyo ti tuddaŋ, anʼde: «Kun wolliyo ɗeʼŋ, kune kun kʼaana ye. Wede eŋ yʼinni jiire, ɗuwo pay an ti buuye kʼume yode.» ");
INSERT INTO moz_vpl VALUES ("JN12_20","073_12_20","JHN","12","20","20","Ti diine ɗoŋ iide Zeruzalem an i-dʼottile a Raa a onniyo tarnaape geŋ, i dʼede ɗoŋ miibi kane Girek. ");
INSERT INTO moz_vpl VALUES ("JN12_21","073_12_21","JHN","12","21","21","Kane geŋ an dʼiide tukki Pilip wede ti Betsayda siiɗo Galile, an di yʼ tunde, anʼde: «Madi, kaye ay dehu ay di wolle Isa.» ");
INSERT INTO moz_vpl VALUES ("JN12_22","073_12_22","JHN","12","22","22","Maŋ Pilip yʼa uuney Andire, sirwaŋ pay an dʼiŋgile kʼume kʼIsa an i di ruuto. ");
INSERT INTO moz_vpl VALUES ("JN12_23","073_12_23","JHN","12","23","23","Aame geŋ Isa yʼan di ruute, yʼede: «Aŋkeŋ peeɗo tʼîide, nuŋ wede an nʼehe aa ulo wede eŋ, Raa yʼan di kiza goolikadó a ɗuwo. ");
INSERT INTO moz_vpl VALUES ("JN12_24","073_12_24","JHN","12","24","24","Ɗerec iŋkino wo nʼun di rooto: Aame buzu ki-giira maŋ, adda siiɗo yi dʼunto ɗoo miŋ, yi-tʼaɗɗiya kollo, yi dʼehiyo in̰n̰i ɓaadaŋ ti doolo. Wo aame yi kʼinda ye maŋ, yʼa lekke daayum yoŋ miŋ yode. ");
INSERT INTO moz_vpl VALUES ("JN12_25","073_12_25","JHN","12","25","25","Wede yi geyyiso tuddí maŋ, yʼa ti dagga, wo wede lekkiyadí ere adda duniya ette yi ti giigira maŋ, yʼa tʼutta wo yʼa tʼoona lekkiyo ere ki daayum. ");
INSERT INTO moz_vpl VALUES ("JN12_26","073_12_26","JHN","12","26","26","Wede yi dehu yi naabe ki nuŋ maŋ, yʼa ni daane. Geŋ iŋkino ume nuŋ ni lekkey geŋ, wede naabadó toŋ aŋgen̰n̰o. Wede yi dehu yi naabe ki nuŋ maŋ, Meega yʼa yi tʼimma. ");
INSERT INTO moz_vpl VALUES ("JN12_27","073_12_27","JHN","12","27","27","Aŋkeŋ undó ti gorpiso, wo nuŋ nʼa roote moo me? Nʼa tʼeese: “Meeʼki nuŋ, kee ki nʼutti ti munɗa wede ettiyo a eedó eŋ me?” Wo nuŋ nʼiido miŋ kono kʼiŋkino, nʼa aɗɗa tʼurzi dabirsa. ");
INSERT INTO moz_vpl VALUES ("JN12_28","073_12_28","JHN","12","28","28","Meeʼki nuŋ a ɗuwo sundá kʼan ti kaza.» Iŋkino maŋ ti kandaane golla ti rootiyo, tʼede: «Nuŋ nʼan ti gize, wo nʼan di kiza sey.» ");
INSERT INTO moz_vpl VALUES ("JN12_29","073_12_29","JHN","12","29","29","Wo kane ɗoŋ a ume geŋ an dʼilliga, an di ruute, anʼde: «Iɗɗise mizzi ko?» Wo ɗoŋ oŋgo anʼde: «I ruute Maaleeka Raa!» ");
INSERT INTO moz_vpl VALUES ("JN12_30","073_12_30","JHN","12","30","30","Maŋ Isa yʼan di ruute, yʼede: «Golla gette ti rootiyo a tukki nuuno ye, a tukki kune. ");
INSERT INTO moz_vpl VALUES ("JN12_31","073_12_31","JHN","12","31","31","Aŋkeŋ peeɗo tʼîide ɗoŋ duniya booro tʼanni seeɗa, wo Mohita duniya gette Raa yʼa ti limma dokki ti paate. ");
INSERT INTO moz_vpl VALUES ("JN12_32","073_12_32","JHN","12","32","32","Wo ki nuŋ, aame ti siiɗo an ti nʼ duɗɗa tʼawwa maŋ, ɗuwo pay nʼan arga a nuuno.» ");
INSERT INTO moz_vpl VALUES ("JN12_33","073_12_33","JHN","12","33","33","A onamí geŋ yi rootiyo kaŋ mummino urzi yi tʼinda me. ");
INSERT INTO moz_vpl VALUES ("JN12_34","073_12_34","JHN","12","34","34","Maŋ kane ɗoŋ duuru geŋ an i di ruute, anʼde: «Kaye ay duuye munɗa wede an riiŋe ti kaaga adda mattup kʼoogiradiŋ, Almasi Raa yi biire geŋ yoŋ yʼa lekka ki daayum, wo mummino kee ki rootiyo yoŋ wede an yʼehe aa ulo wede eŋ, an ti yʼ doɗɗa tʼawwa me! Yo wede an yʼehe aa ulo wede, miŋ wee wee?» ");
INSERT INTO moz_vpl VALUES ("JN12_35","073_12_35","JHN","12","35","35","Iŋkino maŋ Isa yʼan di ruute, yʼede: «Toore yoŋ ede ɓotto a diinaguŋ ki onniyto miibi geŋ, kun oziro a toore gen̰n̰o kono zimolo tʼun gi diʼn seeɗa ye. Wede i sooru a zimolo geŋ, ume yʼette ki tunɗa yi ki suune ye. ");
INSERT INTO moz_vpl VALUES ("JN12_36","073_12_36","JHN","12","36","36","Miŋ yo toore ede ɓotto geŋ, kun zaapo adduguŋ kun daano toore gen̰n̰o, kono kun tʼisa in̰n̰i toore.» Isa yʼa ti ruute iŋkino maŋ, ti tuddaŋ yʼa tʼirga wo yi-tʼumbiɗa. ");
INSERT INTO moz_vpl VALUES ("JN12_37","073_12_37","JHN","12","37","37","Ti sulɗi kʼarmika ɗoŋ Isa yʼize ɓaadaŋ a ɗaanadaŋ gen̰n̰o toŋ, kane Yawudiyagi an ki ziipe addaŋ a yode ye. ");
INSERT INTO moz_vpl VALUES ("JN12_38","073_12_38","JHN","12","38","38","Geŋ a-tʼiide a ono ɗoŋ nebi Ezayi yi ruute ti kaaga, yʼede: «Galmeeʼki nuŋ, wee wee umɓe a ono ɗoŋ ay ruutite me? Wo a wee wee Galmeega Raa yi gize toogadí te?» ");
INSERT INTO moz_vpl VALUES ("JN12_39","073_12_39","JHN","12","39","39","Yode Ezayi gen̰n̰o batum yʼa ruute sey, ki moo me ɗuwo eŋ an kʼamɓu ye me, kono: ");
INSERT INTO moz_vpl VALUES ("JN12_40","073_12_40","JHN","12","40","40","«Raa yʼan tʼippe a edayaŋ, wo addaŋ yʼan ize zakiɗi, kono edayaŋ a ki wolle ye, wo eedaŋ tʼa ki seeɗa munɗa ye. Nʼan ize iŋkino kono an ki dehu ye an di-kimo ki tukki nuŋ Raa, nʼan tʼele beeko me.» ");
INSERT INTO moz_vpl VALUES ("JN12_41","073_12_41","JHN","12","41","41","Ezayi yi ruute iŋkino kono yi wulle gooliko kʼIsa, maŋ yʼa ruute ono a tukki yode me. ");
INSERT INTO moz_vpl VALUES ("JN12_42","073_12_42","JHN","12","42","42","Wo tʼurzi gen̰n̰o toŋ ti diine deero Yawudiyagi geŋ, ɗoŋ ɓaadaŋ an di ziipe addaŋ a yode kaŋ ombiɗe, kono an orgiso a kane Pariziyeŋ, an tiʼn limma ti diinayaŋ, kʼadda ɓoy wede Yawudiyagi ge dooyiso an kʼetta ye. ");
INSERT INTO moz_vpl VALUES ("JN12_43","073_12_43","JHN","12","43","43","Iŋkino maŋ kane an di geyyiso tamma ere ettiyo tʼurzi ɗuwo, miŋ ti ere ki Raa yʼanni tʼimme. ");
INSERT INTO moz_vpl VALUES ("JN12_44","073_12_44","JHN","12","44","44","Isa yʼa ruute ti golla awwa, yʼede: «Wede yi ziipe addí a nuuno geŋ, yi ki ziipe addí a nuuno ye, wo ɗe yi ziipe addí a wede i nʼigibo. ");
INSERT INTO moz_vpl VALUES ("JN12_45","073_12_45","JHN","12","45","45","Wo wede i ni wulla maŋ, geŋ aa yi wulle wede i nʼigibo. ");
INSERT INTO moz_vpl VALUES ("JN12_46","073_12_46","JHN","12","46","46","Nuŋ toore wo nʼa iido kʼadda duniya, kono wede tuuku yi ziipe addí a nuŋ maŋ, yʼa ki lekke adda zimolo ye. ");
INSERT INTO moz_vpl VALUES ("JN12_47","073_12_47","JHN","12","47","47","Aame wede yʼollige onamó wo yi ki sooru eego ye maŋ, i ɗekka booro eedí nuuno ye, kono nuŋ ni kʼiidoʼŋ ɗekkiyo booro ye, nʼiidoʼŋ nʼa utte ɗuwo. ");
INSERT INTO moz_vpl VALUES ("JN12_48","073_12_48","JHN","12","48","48","Wede i ni giigira wo onamó yi kʼamɓu ye maŋ, munɗa a ɗekka booro eedí ede. Wo ono ɗoŋ ni ruute geŋ miŋ, onniyo kʼita maŋ kane geŋ an ɗekka booro eedí. ");
INSERT INTO moz_vpl VALUES ("JN12_49","073_12_49","JHN","12","49","49","Ɗerec, ono ɗoŋ ni rootiyo eŋ ti suma nuuno kʼeedó ye. Meega wede i nʼigibo yʼo di ruute munɗa wede nʼa roote wo nʼa dooye me. ");
INSERT INTO moz_vpl VALUES ("JN12_50","073_12_50","JHN","12","50","50","Wo nuŋ ni suune onamí ɗoŋ yʼo ruute nʼa rooteʼŋ kane i dʼeliyo lekkiyo ere ki daayum, wo ono ɗoŋ ni rootiyo eŋ, niʼni rootiyo aa Meega yʼo ni ruuto.» ");
INSERT INTO moz_vpl VALUES ("JN13_1","073_13_1","JHN","13","1","1","Soggoʼŋ tarnaape Pak ki Yawudiyagi, wo Isa yi suune onniyadí tʼîide, duniya ette yi tʼoola, yi-kime kʼume Meega. Isa geŋ ɗoŋzí a duniya yiʼni giyye, iŋkino maŋ yʼan diʼn geyye bini untadí. ");
INSERT INTO moz_vpl VALUES ("JN13_2","073_13_2","JHN","13","2","2","A lohe Isa ti sanalliyagí an ti guune omɓo maŋ, Meeda siitanɗani ti-dʼele elkiyo a biza kʼulbe Ziidas ulo Simo Iskariyot, yʼan di yʼ tʼela Isa a bey ɗoŋ kʼolmiɗayí. ");
INSERT INTO moz_vpl VALUES ("JN13_3","073_13_3","JHN","13","3","3","Wo yo Isa yi suune Raa yi ele sulɗi pay a beezí, yoŋ yi suune yʼiido tʼume Raa, wo yʼa-kima kʼume yode Raa, ");
INSERT INTO moz_vpl VALUES ("JN13_4","073_13_4","JHN","13","4","4","tʼume kʼomɓo yʼa tʼiiziga, kalayí goole tʼawwa yʼa-buuye, wo yi dʼumɓe buuɗe yʼa gitte a tooní. ");
INSERT INTO moz_vpl VALUES ("JN13_5","073_13_5","JHN","13","5","5","Maŋ yi dʼiɓi ahu a seelo, yʼa iise opilso zoŋ sanalliyagí, yʼan di sapita ti buuɗe wede yi gitte tooní gen̰n̰o. ");
INSERT INTO moz_vpl VALUES ("JN13_6","073_13_6","JHN","13","6","6","Iina a kaaɓa Simo Piyer maŋ, yʼede: «Galmeeʼki nuŋ, kee kʼo ki tʼopile ye zoŋɗó me!» ");
INSERT INTO moz_vpl VALUES ("JN13_7","073_13_7","JHN","13","7","7","Maŋ Isa yi di ruute, yʼede: «Kee munɗa wede nuŋ nʼisiyoʼŋ ki ki yʼ suune ye, wo saŋ maŋ kʼa yi suuna.» ");
INSERT INTO moz_vpl VALUES ("JN13_8","073_13_8","JHN","13","8","8","Simo Piyer yi di ruute, yʼede: «Kuɗic, kee kʼo ki tʼopila ye zoŋɗó me!» Maŋ Isa yi di ruute, yʼede: «Aame nʼa ki tʼupila ye maŋ, kee ti nuŋ in ki tʼokkiƴa ye.» ");
INSERT INTO moz_vpl VALUES ("JN13_9","073_13_9","JHN","13","9","9","Aame geŋ Simo Piyer yi di ruute, yʼede: «Iŋkino maŋ kʼo ki tʼopile zoŋɗó ɗaŋŋal ye, kʼo tʼopili beyɗó ti eedó pây!» ");
INSERT INTO moz_vpl VALUES ("JN13_10","073_13_10","JHN","13","10","10","Maŋ Isa yi di ruute, yʼede: «Wede yi zuyye geŋ yʼa ki suyye sey ye, yʼa-tʼopile zoŋɗí baa, kono yoŋ tuddí pay kamilen̰. Wo aŋken̰n̰o eŋ kune kamilen̰, wo pay ye.» ");
INSERT INTO moz_vpl VALUES ("JN13_11","073_13_11","JHN","13","11","11","Wo yo Isa geŋ yi yʼ suune wede i yi tʼela a bey ɗoŋ kʼolmiɗayí me. Geŋ iŋkino yi rootiyo, yʼede: «Kune pay kamilen̰ ye me.» ");
INSERT INTO moz_vpl VALUES ("JN13_12","073_13_12","JHN","13","12","12","Aame yʼa ti ɗiŋge tʼopilso zoŋ sanalliyagí maŋ, yʼa tʼumɓe kalayí yi-tʼusse, yʼa-guune a ume an dʼomɓo wo yʼan di ruute, yʼede: «Munɗa wede nʼize a kune geŋ, itadí kun yi zuune ɗey? ");
INSERT INTO moz_vpl VALUES ("JN13_13","073_13_13","JHN","13","13","13","Kune kun di nʼ waaku “wede dooyiso” wo “Galmeega”, geŋ ki kune ɗerec kono eŋ miŋ nuuno. ");
INSERT INTO moz_vpl VALUES ("JN13_14","073_13_14","JHN","13","14","14","Wo aame nuŋ wede dooyisaguŋ wo Galmeeguguŋ nʼun upile zoŋguŋ maŋ, kune toŋ wede tuuku yi-di tʼopile zoŋ ki bakadí bakadí. ");
INSERT INTO moz_vpl VALUES ("JN13_15","073_13_15","JHN","13","15","15","Iŋkino geŋ nʼun gize urzi, kono kun dʼise aa nuŋ ize a kune. ");
INSERT INTO moz_vpl VALUES ("JN13_16","073_13_16","JHN","13","16","16","Ɗerec iŋkino wo nʼun di rooto: Wede naabo geŋ yoŋ tʼekki wede dooyisadí ye, wo wede an yʼigibe zina geŋ, yoŋ tʼekki wede i yʼigibe ye. ");
INSERT INTO moz_vpl VALUES ("JN13_17","073_13_17","JHN","13","17","17","Ono eŋ kunʼni zuune maŋ, kune adda kʼuŋsuwo aame kun a ziiɗa zakiɗi maŋ. ");
INSERT INTO moz_vpl VALUES ("JN13_18","073_13_18","JHN","13","18","18","Nuŋ ni ki rootiyo ti kune pay ye, wo nuŋ niʼni suune ɗoŋ ni biire me. Wo geŋ iŋkino a-tʼette a ono ɗoŋ an riiŋe ti kaaga adda mattup ki Raa, anʼde: “Wede ay omɓo umpadey soo geŋ, yi tʼize wede kʼolmiɗayó.” ");
INSERT INTO moz_vpl VALUES ("JN13_19","073_13_19","JHN","13","19","19","Tʼaŋken̰n̰o sulɗi nʼun tiʼn rooto ki poone an dʼaana, wo aame an iina maŋ, kun dʼamɓa miŋ “nuŋ miŋ nuŋ”. ");
INSERT INTO moz_vpl VALUES ("JN13_20","073_13_20","JHN","13","20","20","Ɗerec iŋkino wo nʼun di rooto: Wede tuuku yi seeɗu wede nʼagisa maŋ, geŋ aa yi seeɗu nuŋ batum, wo wede tuuku yi seeɗu nuuno maŋ, geŋ aa yi seeɗu wede i nʼigibo.» ");
INSERT INTO moz_vpl VALUES ("JN13_21","073_13_21","JHN","13","21","21","Aame Isa yi ruute iŋkino maŋ, biza kʼulbí a iise zehiso, wo yʼa ruute, yʼede: «Ɗerec iŋkino wo nʼun di rooto: Wede soo ti diinaguŋ yʼa ni tʼela bey ɗoŋ kʼolmiɗayó.» ");
INSERT INTO moz_vpl VALUES ("JN13_22","073_13_22","JHN","13","22","22","Maŋ kane sanalliyagi geŋ wede soŋ yi ti gelɗiyo bakadí bakadí, wo an ki zuune ye yi rootiyo ti wenɗa me. ");
INSERT INTO moz_vpl VALUES ("JN13_23","073_13_23","JHN","13","23","23","Ti diine kane sanalliyagi geŋ wede soo Isa yi giyye ɓaadaŋ, yʼa-guune a sirpadí. ");
INSERT INTO moz_vpl VALUES ("JN13_24","073_13_24","JHN","13","24","24","Maŋ Simo Piyer yi di dihima ersadí, kono yʼa tonde Isa yi rootiyo tʼaaye. ");
INSERT INTO moz_vpl VALUES ("JN13_25","073_13_25","JHN","13","25","25","Iŋkino maŋ yo sanallusu geŋ yʼa dʼuttile kʼume kʼIsa, yʼa yi tunde, yʼede: «Galmeeʼki nuŋ, kee ki rootiyo tʼaaye?» ");
INSERT INTO moz_vpl VALUES ("JN13_26","073_13_26","JHN","13","26","26","Isa yi diʼn gime onamí, yʼede: «Aame ni umɓa mappa nʼa tʼihiba zaami ni ela maŋ, geŋ yode.» Maŋ Isa yi dʼumɓe mappa, yʼa-tʼihiba zaami yi-dʼele a Ziidas ulo Simo Iskariyot. ");
INSERT INTO moz_vpl VALUES ("JN13_27","073_13_27","JHN","13","27","27","Tʼume Ziidas yi ziiɗa mappa yi tʼiimi maŋ, Meeda siitanɗani ti-tʼiide eedí. Maŋ Isa yi di ruute, yʼede: «Munɗa ki dehu kʼaase, ki yʼiso kesiko.» ");
INSERT INTO moz_vpl VALUES ("JN13_28","073_13_28","JHN","13","28","28","Wo ti diine kane ɗoŋ i-guune omɓo geŋ, wenɗa soo toŋ umbo a suune ki moo me Isa yi rootiyo Ziidas iŋkino me. ");
INSERT INTO moz_vpl VALUES ("JN13_29","073_13_29","JHN","13","29","29","Ziidas geŋ yoŋ wede sarkiya korɓite, iŋkino ɗoŋ oŋgoŋ an elkiyo Isa yi rootiyo, yʼette yi dʼowilo munɗa i dehu ki tarnaape koo, yʼan dʼette ti munɗa a ɗoŋ weedayaŋ umbo koo maŋ. ");
INSERT INTO moz_vpl VALUES ("JN13_30","073_13_30","JHN","13","30","30","Wo aame Ziidas yi ziiɗa mappa maŋ, kesiko yʼa tʼuɗɗe paate. Ume toŋ yʼize diɗɗo baa. ");
INSERT INTO moz_vpl VALUES ("JN13_31","073_13_31","JHN","13","31","31","Aame Ziidas yi tʼuɗɗe maŋ, Isa yʼa ruute, yʼede: «Aŋkeŋ nuŋ wede an nʼehe aa ulo wede eŋ, goolikadó i-gize. Wo tʼurzi nuŋ geŋ, ɗuwo an di wolla gooliko Raa. ");
INSERT INTO moz_vpl VALUES ("JN13_32","073_13_32","JHN","13","32","32","Tʼurzi ki nuŋ gooliko ki Raa i gize geŋ, tʼurzi yode Raa yʼan di kiza gooliko ki nuŋ Ulo gette a ɗuwo, wo taŋ booloŋ Raa yʼa-tʼisa. ");
INSERT INTO moz_vpl VALUES ("JN13_33","073_13_33","JHN","13","33","33","In̰n̰i ki nuŋ, ti kune nʼaa ki lekka ɓaadaŋ ye baa. Kune kun diʼn deha, wo aŋkeŋ nʼun di rooto aakede nʼan ruute deero Yawudiyagi: Ume wede nuŋ nʼette eŋ, kun kʼaane ettiyo ye. ");
INSERT INTO moz_vpl VALUES ("JN13_34","073_13_34","JHN","13","34","34","Kun ollo, nʼun di rooto urzi kʼoogoro aware: Kun geyyo tudduguŋ. Eyye, kun geyyo tudduguŋ aakede nuŋ nʼunni giyye. ");
INSERT INTO moz_vpl VALUES ("JN13_35","073_13_35","JHN","13","35","35","Aame kun giyya tudduguŋ maŋ, ɗuwo pay an un diʼn suuna kune sanalliyagó.» ");
INSERT INTO moz_vpl VALUES ("JN13_36","073_13_36","JHN","13","36","36","Maŋ Simo Piyer yʼa tunde Isa, yʼede: «Galmeeʼki nuŋ, kee kʼamɓe ki too me?» Maŋ Isa yi diʼn gime onamí, yʼede: «Ume wede nuŋ nʼette eŋ, aŋken̰n̰o ki kʼaane ki ki nʼ daane ye. Wo aame onniyo tʼîida maŋ, kʼa ni daana kollo.» ");
INSERT INTO moz_vpl VALUES ("JN13_37","073_13_37","JHN","13","37","37","Piyer yi di ruute, yʼede: «Galmeeʼki nuŋ, moo me aŋken̰n̰o ni kʼaane daaniyadá ye me? Kono kee geŋ, kʼunto toŋ nʼa oyye nʼa tʼinda.» ");
INSERT INTO moz_vpl VALUES ("JN13_38","073_13_38","JHN","13","38","38","Maŋ Isa yi diʼn gime onamí, yʼede: «Ki kotto kʼa oyya kʼa tʼinda kono nuŋ? Ɗerec iŋkino wo nʼa di rooto: Ki poone uzu yʼa ôola geŋ, kʼa roota ki ki nʼ suune ye, suune ye taŋ aɗo.» ");
INSERT INTO moz_vpl VALUES ("JN14_1","073_14_1","JHN","14","1","1","Isa yʼan di ruute sanalliyagí, yʼede: «Kune ulbuguŋ i tʼooɗe ye. Kun zaapo adduguŋ a Raa wo kun zaapo adduguŋ a nuuno pây. ");
INSERT INTO moz_vpl VALUES ("JN14_2","073_14_2","JHN","14","2","2","Adda ɓoy Meegó geŋ ume lekkiyo ɓaadaŋ. Ki kotto aame ume umbo maŋ, nuŋ nʼun ki roote ye, nʼette nʼun dʼokkimey ume me. ");
INSERT INTO moz_vpl VALUES ("JN14_3","073_14_3","JHN","14","3","3","Aame ume nʼiida nʼun tʼikkimo maŋ, nʼa-kimo nʼun tiʼn sika, kono in di lekkey kaŋ soo a ume wede nuŋ ni lekkey. ");
INSERT INTO moz_vpl VALUES ("JN14_4","073_14_4","JHN","14","4","4","Kune kun yi suune urzi wede kʼume nuŋ nʼette me.» ");
INSERT INTO moz_vpl VALUES ("JN14_5","073_14_5","JHN","14","5","5","Maŋ Tomas yi di ruute, yʼede: «Galmeegey, kaye ay ki suune ye ume wede kee kʼette me. Ɗe mummino ay di suune urzi me?» ");
INSERT INTO moz_vpl VALUES ("JN14_6","073_14_6","JHN","14","6","6","Isa yi di ruute, yʼede: «Nuŋ miŋ urzi, nuŋ miŋ ɗerec wo nuŋ miŋ lekkiyo. Wenɗa soo toŋ umbo yʼa tʼette kʼume Meega daa nuuno me. ");
INSERT INTO moz_vpl VALUES ("JN14_7","073_14_7","JHN","14","7","7","Aame nuŋ kun ni zuune maŋ, Meegó toŋ kun di yʼ suune kay. Wo ti aŋki eŋ miŋ kun yi zuune, wo kun yi wulle.» ");
INSERT INTO moz_vpl VALUES ("JN14_8","073_14_8","JHN","14","8","8","Maŋ Pilip yi di ruute, yʼede: «Galmeegey, Meega too me kʼay ki yʼ kazi ɗo, maŋ addey a-tʼudiga.» ");
INSERT INTO moz_vpl VALUES ("JN14_9","073_14_9","JHN","14","9","9","Maŋ Isa yi di ruute, yʼede: «Kee Pilip, nuŋ ti kaagine ni lekkiyo ti kune, miŋ ki ki nʼ suune ye? Wede yi ni wulle maŋ, geŋ aa yi wulle Meega. Ɗe ki moo me ki rootiyo nʼun kaza Meega me? ");
INSERT INTO moz_vpl VALUES ("JN14_10","073_14_10","JHN","14","10","10","Kee ki kʼumɓe ye ko, nuŋ ti Meega, wo yoŋ ti nuŋ aa wede soo me. Ono ɗoŋ ni rootiyo eŋ, ni ki rootiyo ti suma nuuno kʼeedó ye. Wo Meega wede i lekkiyo kettiyo ti nuŋ geŋ, yi dʼisiyo naabadí tʼurzi nuuno. ");
INSERT INTO moz_vpl VALUES ("JN14_11","073_14_11","JHN","14","11","11","Kun zaapo adduguŋ a nuuno, ki kotto nuŋ ti Meega wo yoŋ ti nuŋ kaye aa wede soo. Aame a onamó eŋ kun kʼamɓu ye toŋ, kun amɓo a naabo ere nʼisiyo. ");
INSERT INTO moz_vpl VALUES ("JN14_12","073_14_12","JHN","14","12","12","Ɗerec iŋkino wo nʼun di rooto: Wede yi ziipa addí a nuuno maŋ, naabo ere nuŋ nʼisiyo ette, yoŋ yʼa-tʼisa, wo yʼaasa naabo ere a ceera ettiyo sey, kono ni-kime kʼume Meega. ");
INSERT INTO moz_vpl VALUES ("JN14_13","073_14_13","JHN","14","13","13","Munɗa wede kun tunda ti sundó maŋ, nuŋ nʼun di yʼisa, kono ɗuwo an tʼimma Meega tʼurzi kʼUlo. ");
INSERT INTO moz_vpl VALUES ("JN14_14","073_14_14","JHN","14","14","14","Aame kun tunda munɗa ti sundó maŋ, nuŋ nʼun di yʼisa.» ");
INSERT INTO moz_vpl VALUES ("JN14_15","073_14_15","JHN","14","15","15","«Aame kun ni geyyiso maŋ, urziyagi kʼoogoro ɗoŋ ni rootiyo geŋ kun dʼozire eego. ");
INSERT INTO moz_vpl VALUES ("JN14_16","073_14_16","JHN","14","16","16","Wo nuŋ nʼa tonda Meega, yʼun tʼigibo wede doolo yʼun diʼn nooga, yʼa lekka daayum kettiyo ti kune. ");
INSERT INTO moz_vpl VALUES ("JN14_17","073_14_17","JHN","14","17","17","Wo todʼtiŋ Unde ere ki Ɗerec, tode gette ɗoŋ duniya an ki ti seeɗa ye, kono an ki ti wolliyo ye wo an ki ti suune ye. Wo ɗe kune kun ti suune, kono todʼ ti lekkiyo kettiyo ti kune, wo todʼte tʼa lekka adda kʼadduguŋ. ");
INSERT INTO moz_vpl VALUES ("JN14_18","073_14_18","JHN","14","18","18","Geŋ i-kaza nʼun kiʼn oola noŋgayi ye, nʼa kimo tudduguŋ. ");
INSERT INTO moz_vpl VALUES ("JN14_19","073_14_19","JHN","14","19","19","Taŋ booloŋ ɗaŋŋal ɗoŋ duniya an ki nʼ wolla ye baa. Wo kune kun di nʼ wolla, kono nuŋ ni lekkiyo zeere, wo kune toŋ kun di lekka zeere kay. ");
INSERT INTO moz_vpl VALUES ("JN14_20","073_14_20","JHN","14","20","20","Onniyo gette tʼiina maŋ, kune kun di suuna nuŋ ti Meegó kaye aa wede soo, kune ti nuŋ wo nuŋ ti kune aa wede soo. ");
INSERT INTO moz_vpl VALUES ("JN14_21","073_14_21","JHN","14","21","21","Wede yi seeɗu a urziyagi kʼoogoro ɗoŋ ni rootiyo wo yʼa ti sooru eego maŋ, yoŋ yi ni giyye. Wo wede i ni giyye geŋ, Meegó yʼa yi geyya wo nuŋ toŋ maŋ nʼa yi geyya kay, nuŋ nʼa kiza tuddó daayum a yode.» ");
INSERT INTO moz_vpl VALUES ("JN14_22","073_14_22","JHN","14","22","22","Ziid, wede an yi waaku Ziidas Iskariyot ye, yi di ruute a Isa, yʼede: «Galmeegey, mummino me kee kʼa kiza tuddá a kaye, a ɗoŋ duniya ye me?» ");
INSERT INTO moz_vpl VALUES ("JN14_23","073_14_23","JHN","14","23","23","Maŋ Isa yi di ruute, yʼede: «Wede yi ni giyye geŋ, yʼa seeɗa onamó, wo Meegó yʼa yi geyya. Meegó ti nuŋ kaye ay tʼetta di yode, ay di lekkey soo. ");
INSERT INTO moz_vpl VALUES ("JN14_24","073_14_24","JHN","14","24","24","Wede yi ki nʼ geyye ye geŋ, onamó yi kiʼn seeɗu ye. Ono ɗoŋ kun ollige eŋ ti suma nuuno kʼeedó ye, ettiyo ti Meega wede i nʼigibo. ");
INSERT INTO moz_vpl VALUES ("JN14_25","073_14_25","JHN","14","25","25","Sulɗi geŋ nʼun tiʼn ruute ki poone nuŋ ede ɓotto ti kune geŋ me. ");
INSERT INTO moz_vpl VALUES ("JN14_26","073_14_26","JHN","14","26","26","Wo to Ere Noogiyo todʼte Unde Kamilen̰, Meegó yi tʼigibo ti suma nuuno. Tode gette tʼun diʼn dooya a sulɗi pay, wo tʼun tʼela elkiyo kun dʼelka ono ɗoŋ pay nʼun ruutite. ");
INSERT INTO moz_vpl VALUES ("JN14_27","073_14_27","JHN","14","27","27","Nuŋ nʼun iili toose, nʼun ele toose ere ki nuŋ batum. Nuŋ nʼun ele aa ɗoŋ duniya an ki dʼeliyo ye. Ulbuguŋ i tʼooɗe ye, kun orgiɗe ye. ");
INSERT INTO moz_vpl VALUES ("JN14_28","073_14_28","JHN","14","28","28","Kun illiga nʼun ruute, nʼede: “Nʼeŋgile wo nʼa kimo tudduguŋ.” Aame kun ni giyye maŋ, ulbuguŋ aase uŋse a eŋgilsadó kʼume Meega, kono yo Meega goole ti nuŋ. ");
INSERT INTO moz_vpl VALUES ("JN14_29","073_14_29","JHN","14","29","29","Sulɗi geŋ tʼaŋken̰n̰o nʼun tiʼn rooto ki poone an dʼaana, kono aame an iina maŋ kun di zaapa adduguŋ a nuŋ. ");
INSERT INTO moz_vpl VALUES ("JN14_30","073_14_30","JHN","14","30","30","Aŋkeŋ ki ɗaana eŋ ni kʼaana rootiyo kʼono ti kune ye baa, kono Mohita duniya tʼettiyo, wo ɗerec tode gette i-kʼede toogo ye a tukki nuŋ me. ");
INSERT INTO moz_vpl VALUES ("JN14_31","073_14_31","JHN","14","31","31","Nʼisiyo munɗa wede a-tʼette a ono ɗoŋ Meega Raa yʼo ruute, kono tʼurzi geŋ ɗoŋ duniya an di suuna nuŋ Meega ni yʼ giyye. Tʼeŋ kun tʼoozo, in eŋgile.» ");
INSERT INTO moz_vpl VALUES ("JN15_1","073_15_1","JHN","15","1","1","Isa yʼa ruute, yʼede: «Nuŋ aa undumu bin̰ wede ki kotto an iite adda doome, wo Meegó wede naabo. ");
INSERT INTO moz_vpl VALUES ("JN15_2","073_15_2","JHN","15","2","2","Layɗayi ɗoŋ pay kettiyo ti nuŋ wo i kʼehiyo ye, yi-tiʼn ɗekkiso mendaŋ. Wo layɗayi ɗoŋ ehiyo, pay yi diʼn okkime, kono an tʼehe ɓaadaŋ sey. ");
INSERT INTO moz_vpl VALUES ("JN15_3","073_15_3","JHN","15","3","3","Wo kune sanalliyagó, tʼurzi dooyiso ere nʼun ele gette, kun tʼize ɗoŋ kamilen̰ aa undumu wede an ti yʼikkima. ");
INSERT INTO moz_vpl VALUES ("JN15_4","073_15_4","JHN","15","4","4","Kun lekko kettiyo ti nuŋ, wo nuŋ nʼa lekka kettiyo ti kune. Aakede layisa kʼundumu gette todʼte ekki duntultú ye maŋ ti ki tʼehe ye, geŋ kune toŋ iŋkino aame kun ki likka kettiyo ti nuŋ ye maŋ, kun tʼisa ki bita. ");
INSERT INTO moz_vpl VALUES ("JN15_5","073_15_5","JHN","15","5","5","Nuŋ aa undumu bin̰ wo kune aa layɗayi. Wede yi likka kettiyo ti nuŋ, wo nuŋ ti yode maŋ, yode geŋ yʼa tʼisa aa layisa kʼundumu ere ehiyo ɓaadaŋ, kono daa nuuno munɗa kun kʼaane kun ki tʼise ye. ");
INSERT INTO moz_vpl VALUES ("JN15_6","073_15_6","JHN","15","6","6","Wede yi ki lekkiyo kettiyo ti nuŋ ye maŋ, yoŋ geŋ an di seɗɗa dokki ti paate aakede layisa ɗekkiyo. Tode gette i-ti baahu, maŋ an tʼamɓu, an di seɗɗiyo adda kʼuwwo, ti-tʼoggiyo mentú. ");
INSERT INTO moz_vpl VALUES ("JN15_7","073_15_7","JHN","15","7","7","Aame kun lekkiyo kettiyo ti nuŋ wo onamó kunʼni seeɗu maŋ, kun tondo munɗa wede kun dehu me, wo munɗa geŋ kun di yʼ tʼoona. ");
INSERT INTO moz_vpl VALUES ("JN15_8","073_15_8","JHN","15","8","8","Munɗa wede i dʼeliyo tamma a Meego en̰n̰o: kun tʼiso aa layisa kʼundumu ere ehiyo ɓaadaŋ wo kun tʼiso sanalliyagó. ");
INSERT INTO moz_vpl VALUES ("JN15_9","073_15_9","JHN","15","9","9","Aa Meega yi ni giyye geŋ, nuŋ toŋ nʼunni giyye. Kun lekko daayum adda geyyisadó. ");
INSERT INTO moz_vpl VALUES ("JN15_10","073_15_10","JHN","15","10","10","Aame kun seeɗu a urziyagi kʼoogoro ɗoŋ ni rootiyo maŋ, kun di lekka adda geyyisadó, aakede nuŋ ni seeɗu a sulɗi ɗoŋ Meegó yi ruute nʼaase wo ni-lekkiyo adda geyyisadí. ");
INSERT INTO moz_vpl VALUES ("JN15_11","073_15_11","JHN","15","11","11","Nuŋ nʼun ruute iŋkino kono nuŋ ulbó aase uŋse ti kune, wo uŋsuwaguŋ gette tʼaase ɓaadaŋ ki ɓaadaŋ a ceere. ");
INSERT INTO moz_vpl VALUES ("JN15_12","073_15_12","JHN","15","12","12","Kun ollo, en̰n̰o urzi kʼoogiradó ni rootiyo me: Kun geyyo tudduguŋ, aakede nuŋ nʼunni giyye. ");
INSERT INTO moz_vpl VALUES ("JN15_13","073_15_13","JHN","15","13","13","Wede yʼa oyye yʼa tʼinda kono laŋziyagi geŋ, geyyiso ti doolo a ceera tode gette umbo. ");
INSERT INTO moz_vpl VALUES ("JN15_14","073_15_14","JHN","15","14","14","Aame munɗa wede nʼun rootiyo kun dʼise kun ti yʼisiyo maŋ, geŋ kune laŋziyagó. ");
INSERT INTO moz_vpl VALUES ("JN15_15","073_15_15","JHN","15","15","15","Kune nʼun kiʼn waake ɗoŋ naabadó ye, kono wede naabo geŋ yi ki suune ye munɗa wede galmeegí yʼisiyo me. Wo kune nʼunni waaku laŋziyagó, kono sulɗi ɗoŋ Meegó yʼo gizite nʼun kʼiŋga ye, nʼun tiʼn gizite pay. ");
INSERT INTO moz_vpl VALUES ("JN15_16","073_15_16","JHN","15","16","16","Nuŋ i ki nʼ biire kune ye, wo nuuno unni biire me. Nuŋ nʼun dʼele attiɗi kun dʼette kun dʼise naabo ere ki ɗaakatú, aa layisa kʼundumu ehiyo ɓaadaŋ. Naabo ere kun isa gette tʼa lekka ki daayum. Iŋkino maŋ munɗa wede kun tonda Meega ti sundó geŋ, yʼun di yʼ tʼela. ");
INSERT INTO moz_vpl VALUES ("JN15_17","073_15_17","JHN","15","17","17","Eŋ munɗa wede nʼun rootiyo kun dʼise: Kun geyyo tudduguŋ.» ");
INSERT INTO moz_vpl VALUES ("JN15_18","073_15_18","JHN","15","18","18","«Aame ɗoŋ duniya an unni giigira maŋ, kun elko an giigira ki poone nuuno. ");
INSERT INTO moz_vpl VALUES ("JN15_19","073_15_19","JHN","15","19","19","Aame kune ti ɗoŋ duniya soo maŋ, an un diʼn geyye kono kune ki kane. Wo ɗe kune ki kane ye, kono nuŋ nʼunni biire wo nʼun tiʼn iiɗiba ti diinayaŋ me. Kono kamo ɗoŋ duniya an un diʼn koogire me. ");
INSERT INTO moz_vpl VALUES ("JN15_20","073_15_20","JHN","15","20","20","Iŋkino maŋ kun elko a ono ɗoŋ nʼun ruute, nʼede: “Wede naabo geŋ yoŋ tʼekki wede dooyisadí ye.” Geŋ nuŋ an ni dibire, wo kune toŋ maŋ an un diʼn dabira kay. Wo nuŋ onamó anʼni seeɗu maŋ, ki kune toŋ an diʼn seeɗa kay. ");
INSERT INTO moz_vpl VALUES ("JN15_21","073_15_21","JHN","15","21","21","Dabar ere an unni dabira gette kono kun umɓe a sundó, kono wede i nʼigibo an ki yʼ suune ye. ");
INSERT INTO moz_vpl VALUES ("JN15_22","073_15_22","JHN","15","22","22","Aame nuŋ ni kʼiido wo nʼan ki ruute ye maŋ, booro kʼolɗiko tʼan kiʼn seeɗa ye. Wo aŋkeŋ an lekkiyo adda kʼolɗikadaŋ pi maŋ, urzi an tʼaɗɗa eedaŋ umbo tʼolɗikadaŋ me. ");
INSERT INTO moz_vpl VALUES ("JN15_23","073_15_23","JHN","15","23","23","Iŋkino maŋ wede i ni koogire geŋ, yi koogire Meegó pây. ");
INSERT INTO moz_vpl VALUES ("JN15_24","073_15_24","JHN","15","24","24","Aame nuŋ a diinayaŋ ni kʼize sulɗi ɗoŋ wenɗa ti doolo soo toŋ yi kʼize ye maŋ, geŋ booro kʼolɗiko ti kiʼn seeɗa ye. Wo aŋkeŋ sulɗi ɗoŋ geŋ an i wulle toŋ, nuŋ ti Meegó an ay diʼn koogire pi. ");
INSERT INTO moz_vpl VALUES ("JN15_25","073_15_25","JHN","15","25","25","Wo ɗe sulɗi geŋ a iina kono a-tʼette a ono ɗoŋ an riiŋe ti kaaga adda mattup kʼoogiradaŋ, anʼde: “An ni giigira daa kʼurzutú.” ");
INSERT INTO moz_vpl VALUES ("JN15_26","073_15_26","JHN","15","26","26","Nuŋ nʼiiney a ume Meega maŋ, Ere Noogiyaguŋ nʼun ti-tʼigibo tʼa etto. Ni rootiyo ti Unde ere Ɗerec etto ti sirpa Meega. Aame tʼiina maŋ, tʼan di kiza onamó a ɗuwo. ");
INSERT INTO moz_vpl VALUES ("JN15_27","073_15_27","JHN","15","27","27","Wo kune toŋ kun di kizita onamó, kono tʼume nʼiise naabo geŋ kune ti nuuno.» ");
INSERT INTO moz_vpl VALUES ("JN16_1","073_16_1","JHN","16","1","1","«Sulɗi pay geŋ nʼun tiʼn ruutite kono urzi zaapu kʼadduguŋ a Raa kun ki dʼoola ye. ");
INSERT INTO moz_vpl VALUES ("JN16_2","073_16_2","JHN","16","2","2","Tʼadda ɓoyɗi ɗoŋ in di dooyiso, an un tiʼn limma. Wo ulsu a jiire sey, onniyo tʼaana iŋkino wede tuuku unni tʼîda geŋ yʼelkiyo yʼisiyo naabo ere beehiye a ɗaana Raa. ");
INSERT INTO moz_vpl VALUES ("JN16_3","073_16_3","JHN","16","3","3","Kane an un isa iŋkino kono nuŋ ti Meega an ay kiʼn zuune ye. ");
INSERT INTO moz_vpl VALUES ("JN16_4","073_16_4","JHN","16","4","4","Wo ɗe sulɗi geŋ nʼun tiʼn ruute kono aame onniyo tʼiina maŋ, kun dʼelka a ono ɗoŋ nʼun ruute.» «Nuŋ nʼun ki ruute tʼume kʼeesiyo yeʼŋ kono nuŋ ti kune. ");
INSERT INTO moz_vpl VALUES ("JN16_5","073_16_5","JHN","16","5","5","Aŋkeŋ ni-kime kʼume wede i nʼigibo, wo ti diinaguŋ wede a ni tonde umbo, yʼa tʼeese: “Kʼamɓe ki too me?” ");
INSERT INTO moz_vpl VALUES ("JN16_6","073_16_6","JHN","16","6","6","Wo ɗe sulɗi nʼun tiʼn ruute iŋkino maŋ, ulbuguŋ i dʼooɗiyo ɓaadaŋ. ");
INSERT INTO moz_vpl VALUES ("JN16_7","073_16_7","JHN","16","7","7","Wo ki too maŋ nʼun rootiyo ono ɗoŋ ɗerec, beehiye a kune nuŋ nʼa iŋgile. Wo aame ni kʼiŋgila ye maŋ, tode Ere Noogiyaguŋ gette ti kʼetto ye. Wo ɗe nʼiŋgila nʼiiney maŋ, nʼun ti-tʼigibo. ");
INSERT INTO moz_vpl VALUES ("JN16_8","073_16_8","JHN","16","8","8","Todʼ tʼiina maŋ, ɗoŋ duniya eedaŋ tʼan ti-dagga a elkisadaŋ ere a urzi kʼolɗiko, a urzi wede ki diine ki Raa, wo a urzi Raa yi ɗekka booro te. ");
INSERT INTO moz_vpl VALUES ("JN16_9","073_16_9","JHN","16","9","9","Kane an ti digge a elkisadaŋ ere a urzi kʼolɗiko, kono an ki zaapu addaŋ a nuŋ ye. ");
INSERT INTO moz_vpl VALUES ("JN16_10","073_16_10","JHN","16","10","10","An ti digge a elkisadaŋ ere a urzi wede ki diine ki Raa, kono nuŋ nʼeŋgile kʼume Meega wo kun ki nʼ wolla ye baa. ");
INSERT INTO moz_vpl VALUES ("JN16_11","073_16_11","JHN","16","11","11","Wo an ti digge pây a elkisadaŋ ere a urzi Raa yi ɗekka booro, kono Mohita duniya gette booro ti ti ziiɗa. ");
INSERT INTO moz_vpl VALUES ("JN16_12","073_16_12","JHN","16","12","12","Para maŋ nuŋ oo dʼede sulɗi ɓaadaŋ sey ki rootiyo a kune, wo ɗe kune un kʼede toogo ye ki seeɗizaŋ aŋken̰n̰o me. ");
INSERT INTO moz_vpl VALUES ("JN16_13","073_16_13","JHN","16","13","13","Aame Unde ere ki Ɗerec tʼiina maŋ, tʼun diʼn kiza sulɗi ɗoŋ pay ɗerec me. Todʼ ti roota munɗaʼŋ ti toogo suuniyo ere kʼettú ye, wo ɗe ti rootita sulɗi ɗoŋ pay tʼolliga ti kandaane, wo tʼun di kiza a sulɗi ɗoŋ etto kʼita. ");
INSERT INTO moz_vpl VALUES ("JN16_14","073_16_14","JHN","16","14","14","Tode gette tʼan di-kiza goolikadó a ɗuwo, kono ono ɗoŋ todʼ tʼun roota geŋ aɗɗa ti bize nuuno. ");
INSERT INTO moz_vpl VALUES ("JN16_15","073_16_15","JHN","16","15","15","Sulɗi ɗoŋ pay Meega i-dʼede geŋ, kane ki nuuno. Kono kamo nʼa ruute, Unde gette tʼun kiza munɗa wede tʼolliga ti bize nuuno me.» ");
INSERT INTO moz_vpl VALUES ("JN16_16","073_16_16","JHN","16","16","16","«Taŋ booloŋ maŋ kun ki nʼ wolla ye, wo saŋ maŋ taŋ booloŋ sey kun di nʼ wolla.» ");
INSERT INTO moz_vpl VALUES ("JN16_17","073_16_17","JHN","16","17","17","Iŋkino maŋ kane sanalliyagí oŋgo an di rootiyo diinayaŋ, anʼde: «I-kaza moo me onamí ɗoŋ yʼin rootiyo: Taŋ booloŋ maŋ in ki yʼ wolla ye, wo saŋ maŋ taŋ booloŋ sey in di yʼ wolla me, wo soŋ yʼede: Yi-kime kʼume Meega me?» ");
INSERT INTO moz_vpl VALUES ("JN16_18","073_16_18","JHN","16","18","18","Maŋ kane anʼde: «Onamí ɗoŋ yi rootiyo “taŋ booloŋ” miŋ, i-kaza moo me? In kiʼn suune ye ita kʼono ɗoŋ yi rootiyo me.» ");
INSERT INTO moz_vpl VALUES ("JN16_19","073_16_19","JHN","16","19","19","Isa yʼa zuune kane an dehu an di yʼ tonde me, maŋ yʼan di ruute, yʼede: «Kune kun tondiso tudduguŋ miŋ a ono ɗoŋ nʼun ruute, nʼede: “Taŋ booloŋ maŋ kun ki nʼ wolla ye, wo saŋ maŋ taŋ booloŋ sey kun di nʼ wolla” gen̰n̰o ko? ");
INSERT INTO moz_vpl VALUES ("JN16_20","073_16_20","JHN","16","20","20","Ɗerec iŋkino wo nʼun di rooto: Kune kun dʼôola wo kun di ɗillita, wo kane ɗoŋ duniya ulbaŋ aasa uŋse. Kun di lekka tʼulbe kʼooɗiyo, saŋ ulbuguŋ a ôona tʼuŋsuwo. ");
INSERT INTO moz_vpl VALUES ("JN16_21","073_16_21","JHN","16","21","21","Geŋ aakede erewo addutú i tʼumɓe kʼehiyo geŋ, ti ɗawilsa sommagi dondoŋ aame kʼehiyo geŋ me. Wo aame ti dʼehiyo ulo maŋ, dabaratú i-danɗiya, ulbutú i-dʼisiyo uŋse kono ti ehe wedusu adda duniya. ");
INSERT INTO moz_vpl VALUES ("JN16_22","073_16_22","JHN","16","22","22","Wo kuneʼŋ aŋken̰n̰o kun lekko tʼulbe kʼooɗiyo, wo ɗe saŋ maŋ nʼun diʼn wolla sey. Aame geŋ adduguŋ a ôona tʼuŋsuwo, wo uŋsuwaguŋ gette wenɗa soo toŋ a aane un di-dagge umbo. ");
INSERT INTO moz_vpl VALUES ("JN16_23","073_16_23","JHN","16","23","23","Onniyo gette tʼiina maŋ, munɗa wede kun tonda nuŋ umbo. Ɗerec iŋkino wo nʼun di rooto: Munɗa wede kun tonda Meega ti sundó geŋ, yʼun di yʼ tʼela. ");
INSERT INTO moz_vpl VALUES ("JN16_24","073_16_24","JHN","16","24","24","Tʼume kʼeesiyo bini aŋki munɗa ti sundó kun ki tunde ye. Kun tondo wo kun tʼoona, iŋkino maŋ adduguŋ a ôona tʼuŋsuwo.» ");
INSERT INTO moz_vpl VALUES ("JN16_25","073_16_25","JHN","16","25","25","«Sulɗi pay geŋ nʼun ruutite tʼono ombiɗe, wo ɗe onniyo tʼîida maŋ nʼun dʼorba keren̰ tʼono ombiɗe ye baa. Wo sulɗi pay ki Meega geŋ nʼun tiʼn roota keren̰. ");
INSERT INTO moz_vpl VALUES ("JN16_26","073_16_26","JHN","16","26","26","Onniyo gette tʼîida maŋ, ti sigguŋ kun tonda munɗa ti sundó a bey Meega, wo nuŋ ni ki yʼ tonda ye baa kono kune me. ");
INSERT INTO moz_vpl VALUES ("JN16_27","073_16_27","JHN","16","27","27","Yo Meega batum miŋ yʼunni giyye kono nuŋ kun ni giyye, wo kun umɓe nuŋ nʼiidoʼŋ ti sirpa Raa me. ");
INSERT INTO moz_vpl VALUES ("JN16_28","073_16_28","JHN","16","28","28","Nuŋ nʼiidoʼŋ tʼume Meegó ki duniya me, wo aŋkeŋ duniya ni tʼooli, ni-kime kʼume Meegó.» ");
INSERT INTO moz_vpl VALUES ("JN16_29","073_16_29","JHN","16","29","29","Maŋ kane sanalliyagí an i di ruute, anʼde: «Aŋkeŋ onamá ki rootiyo eŋ keren̰ baa, ombiɗe ye. ");
INSERT INTO moz_vpl VALUES ("JN16_30","073_16_30","JHN","16","30","30","Aŋkeŋ kaye ay zuune kee ki suune sulɗi pay, wo ki ki dehu wenɗa yʼa ki tonde ye baa. Kono kamo kaye ay umɓe kee kʼiido ti Raa.» ");
INSERT INTO moz_vpl VALUES ("JN16_31","073_16_31","JHN","16","31","31","Isa yʼan di ruute, yʼede: «Aŋkeŋ kun umɓe baa ko? ");
INSERT INTO moz_vpl VALUES ("JN16_32","073_16_32","JHN","16","32","32","Saŋ onniyo tʼaana wo todʼtiŋ tʼiina baa, kun di-teepa wede soŋ kʼumayí kʼumayí, kun di nʼoola siidó. Wo ɗe nuŋ siidó ye, kono Meega ti nuuno. ");
INSERT INTO moz_vpl VALUES ("JN16_33","073_16_33","JHN","16","33","33","Sulɗi geŋ nʼun tiʼn ruute kono kun di lekke ti toose ere ki nuŋ. Adda duniya ette kun tʼoona dabar, wo kun omɓon̰ kono nuŋ duniya ni ti jiire.» ");
INSERT INTO moz_vpl VALUES ("JN17_1","073_17_1","JHN","17","1","1","Aame Isa yʼan ti ruute iŋkino maŋ, yʼa tʼumɓe edayí kʼawwa ki kandaane wo yʼa ruute, yʼede: «Meeʼki nuŋ, peeɗo tʼîide. Kʼan ti kaza gooliko kʼUlá a ɗuwo, kono Ulá toŋ yʼan di-kize goolikadá te. ");
INSERT INTO moz_vpl VALUES ("JN17_2","073_17_2","JHN","17","2","2","Yo Ulá ki dʼele toogo a tukki ɗuwo pay, kono yʼan tʼele lekkiyo ere ki daayum a kane ɗoŋ pay kee ki ele geŋ me. ");
INSERT INTO moz_vpl VALUES ("JN17_3","073_17_3","JHN","17","3","3","Lekkiyo ere ki daayum gette, i dehu an di suune kee Raa wede ki kotto soo ɗaŋŋal, wo i dehu an di suune nuŋ Isa Almasi wede kee kʼigibo. ");
INSERT INTO moz_vpl VALUES ("JN17_4","073_17_4","JHN","17","4","4","Nuŋ adda duniya ette, goolikadá a ɗuwo nʼan ti-gize, wo naabo ere kʼo elo nʼaase, ni-tʼize. ");
INSERT INTO moz_vpl VALUES ("JN17_5","073_17_5","JHN","17","5","5","Meeʼki nuŋ, ti poone kʼa okkima duniya ɓotto geŋ, nuŋ o dʼede gooliko a ɗaana kee. Aŋkeŋ tode gette a ɗaanadá kʼo tʼeli. ");
INSERT INTO moz_vpl VALUES ("JN17_6","073_17_6","JHN","17","6","6","A ɗuwo ɗoŋ kee ki biire tʼadda duniya wo kʼo diʼn ele geŋ, suma kee Raa nʼan ti gize. Kane ki kee wo kʼo diʼn elo, wo onamá an diʼn ziiɗa. ");
INSERT INTO moz_vpl VALUES ("JN17_7","073_17_7","JHN","17","7","7","Aŋkeŋ kane an zuune sulɗi pay ɗoŋ kʼo elo a beezó eŋ, kane ettiyo ti kee, ");
INSERT INTO moz_vpl VALUES ("JN17_8","073_17_8","JHN","17","8","8","wo ono ɗoŋ kee kʼo elo geŋ, a kane nuŋ nʼan tiʼn ruute. Kane an diʼn ziiɗa bey sire, an di zuune ki kotto nuŋ nʼiido ti gulbe kee, wo an dʼumɓe i nʼigibo kee me. ");
INSERT INTO moz_vpl VALUES ("JN17_9","073_17_9","JHN","17","9","9","Nuŋ ni tondiyo keeʼŋ kono kane. Ni ki-tondiyo kono ɗoŋ duniya ye, wo ɗe ni ki tondiyo ki kane ɗoŋ kee kʼo elo, kono kane ki kee. ");
INSERT INTO moz_vpl VALUES ("JN17_10","073_17_10","JHN","17","10","10","Sulɗi pay oo dʼede geŋ kane ki kee, wo sulɗi ki kee ki nuŋ. Wo tʼurzi sulɗi ɗoŋ kʼo elo geŋ nuŋ ɗuwo an di nʼ tʼimma. ");
INSERT INTO moz_vpl VALUES ("JN17_11","073_17_11","JHN","17","11","11","Wo aŋkeŋ nuŋ duniya ni tʼooli ni-kime kʼume kee, wo kane an lekka adda duniya. Meeʼki nuŋ kee wede kamilen̰, kʼanni booho ti toogo sundá ere kʼo ele, kono an di lekke aa wede soo, aa kee ti nuŋ kine aa wede soo. ");
INSERT INTO moz_vpl VALUES ("JN17_12","073_17_12","JHN","17","12","12","Aame nuŋ ti kane geŋ, ni diʼn boohiyo ti toogo sundá ere kʼo ele. Nʼan diʼn buuhe, ti diinayaŋ wenɗa soo toŋ i ki digge ye. I digge wede soo kono a-tʼiide a ono ɗoŋ an riiŋe ti kaaga adda mattup ki Raa. ");
INSERT INTO moz_vpl VALUES ("JN17_13","073_17_13","JHN","17","13","13","Aŋkeŋ ni-kime kʼume kee, wo ni rootiyo ono eŋ nuŋ ɓotto adda duniya, kono uŋsuwadó tʼa koone ɓaadaŋ ki ɓaadaŋ adda kʼaddaŋ. ");
INSERT INTO moz_vpl VALUES ("JN17_14","073_17_14","JHN","17","14","14","Nuŋ onamá nʼan ele a ɗoŋzá me, wo kane ɗoŋ duniya an diʼn giigira kono kane ki duniya ye, aakede nuŋ toŋ ki duniya ye. ");
INSERT INTO moz_vpl VALUES ("JN17_15","073_17_15","JHN","17","15","15","Nuŋ ni ki tondiyo ɗoŋzá kʼa kiʼn aɗɗe tʼadda duniya ye, wo ni ki tondiyo kʼanni boohe ti Mohita kʼolɗiko gettiyo. ");
INSERT INTO moz_vpl VALUES ("JN17_16","073_17_16","JHN","17","16","16","Kane ki duniya ye, aakede nuŋ toŋ ki duniya ye. ");
INSERT INTO moz_vpl VALUES ("JN17_17","073_17_17","JHN","17","17","17","Kane kiʼn ooyo kese a kee tʼurzi wede ɗerec, kono onamá kane ɗerec. ");
INSERT INTO moz_vpl VALUES ("JN17_18","073_17_18","JHN","17","18","18","Aakede kee ki nʼigibo kʼadda duniya geŋ, nuŋ toŋ maŋ nʼa tiʼn tʼigibe kʼadda duniya. ");
INSERT INTO moz_vpl VALUES ("JN17_19","073_17_19","JHN","17","19","19","Wo kono kane geŋ nuŋ batum tuddó nʼa-tʼuuye kese a kee, kono kane toŋ tuddaŋ an ti-tʼooye kese a kee tʼurzi wede ɗerec. ");
INSERT INTO moz_vpl VALUES ("JN17_20","073_17_20","JHN","17","20","20","Nuŋ ni ki-tondiyo kono ki kane ɗaŋŋal ye, wo ki ɗoŋ pay i zaapa addaŋ a nuŋ tʼurzi kʼono ɗoŋ an an kizita. ");
INSERT INTO moz_vpl VALUES ("JN17_21","073_17_21","JHN","17","21","21","Nuŋ ni ki tondiyo sey kono kane pay an tʼise aa wede soo. Meeʼki nuŋ, aakede kee kettiyo ti nuŋ wo nuŋ kettiyo ti kee geŋ, kane toŋ an tʼise kettiyo aa wede soo, kono ɗoŋ duniya an dʼamɓe i nʼigibo kee. ");
INSERT INTO moz_vpl VALUES ("JN17_22","073_17_22","JHN","17","22","22","Gooliko ere kee kʼo elo gette, nuŋ nʼan ele. Iŋkino kane an tʼise aa wede soo, aakede kee ti nuŋ aa wede soo, ");
INSERT INTO moz_vpl VALUES ("JN17_23","073_17_23","JHN","17","23","23","nuŋ ti kane wo kee ti nuŋ. Tʼurzi geŋ an tʼise ɗoŋ i lekkiyo kettiyo kaŋ soo, iŋkino ɗoŋ duniya an di suuna i nʼigibo kee, wo sanalliyagó kiʼni giyye aakede ki giyye nuŋ. ");
INSERT INTO moz_vpl VALUES ("JN17_24","073_17_24","JHN","17","24","24","Meeʼki nuŋ, kane kee kʼoʼn elo, wo nuŋ ni dehu ume wede nuŋ ni lekkey geŋ, kane toŋ an di lekkey kay. Aame geŋ kane an di wolley goolikadó ere kʼo ele, kono kee ki ni giyye ti poone tʼume kʼa okkima duniya ɓotto too. ");
INSERT INTO moz_vpl VALUES ("JN17_25","073_17_25","JHN","17","25","25","Meeʼki nuŋ, kee wede ki diine. Ɗoŋ ɓaadaŋ adda duniya an ki suune ye, wo nuŋ ni ki suune, wo kane sanalliyagó toŋ an zuune i nʼigibo kee me. ");
INSERT INTO moz_vpl VALUES ("JN17_26","073_17_26","JHN","17","26","26","Kee sundá nʼan ti gize a kane me, wo nʼan di kiza sey sundá te, kono geyyiso ere kee ki ni giyye gette, kane toŋ an di tʼoona kay, wo nuŋ batum miŋ ti kane aa wede soo.» ");
INSERT INTO moz_vpl VALUES ("JN18_1","073_18_1","JHN","18","1","1","Aame Isa yʼa ti ɗiŋge onamí iŋkino maŋ, tiŋ geŋ ti sanalliyagí an tʼiiziga, an dʼiŋgile, an di diipiɗa sorgile ki Sediroŋ. Ti darga geŋ i dʼede jineene kʼinda, Isa ti sanalliyagí an tʼiide adda. ");
INSERT INTO moz_vpl VALUES ("JN18_2","073_18_2","JHN","18","2","2","Wo Ziidas, wede yʼan di yʼ tʼela Isa a bey ɗoŋ kʼolmiɗayí geŋ, umeʼŋ yi yʼ suune kono Isa ti sanalliyagí an sooruʼŋ daayum kʼume geŋ me. ");
INSERT INTO moz_vpl VALUES ("JN18_3","073_18_3","JHN","18","3","3","Iŋkino maŋ Ziidas yʼan dʼan tʼiide kʼadda jineene gettiyo a asigiryagi ɗoŋ ki Romeŋ, ti ɗoŋ i boohiyo Ɓoy Raa kane ɗoŋ deero ɗoŋ seɗeke ti Pariziyeŋ an iiɗiba geŋ me. Kane asigiryagi geŋ an ziki a beyɗaŋ lampiyagi, biŋgagi wo sulɗi ɗeyyiso. ");
INSERT INTO moz_vpl VALUES ("JN18_4","073_18_4","JHN","18","4","4","Wo ki Isa yoŋ yi suune sulɗi ɗoŋ pay i aana me. Iŋkino maŋ yʼa dʼiide kʼume kane, wo yʼanni tunde, yʼede: «Kun dehuʼŋ wee wee?» ");
INSERT INTO moz_vpl VALUES ("JN18_5","073_18_5","JHN","18","5","5","Kane asigiryagi an i diʼn gime onamí, anʼde: «Ay dehu Isa wede ti geeger Nazaret.» Maŋ Isa yʼan di ruute, yʼede: «Nuŋ miŋ nuŋ.» Wo Ziidas wede yʼan di yʼ tʼela Isa a bey ɗoŋ kʼolmiɗayí geŋ yoŋ a diine kane. ");
INSERT INTO moz_vpl VALUES ("JN18_6","073_18_6","JHN","18","6","6","Aame Isa yʼan ruute «Nuŋ miŋ nuŋ» maŋ, kane asigiryagi an di-gusiɗe kʼita, an tʼiɓi siiɗo ramama. ");
INSERT INTO moz_vpl VALUES ("JN18_7","073_18_7","JHN","18","7","7","Isa yʼanni tunde sey, yʼede: «Kun dehuʼŋ wee wee?» Wo kane an i diʼn gime onamí, anʼde: «Ay dehu Isa wede ti geeger Nazaret.» ");
INSERT INTO moz_vpl VALUES ("JN18_8","073_18_8","JHN","18","8","8","Isa yʼan di ruute, yʼede: «Nuŋ nʼun ruute ɗe me, nuŋ miŋ nuŋ. Aame kun dehu nuuno maŋ, ɗoŋzóʼŋ kun oolo an dʼeŋgile.» ");
INSERT INTO moz_vpl VALUES ("JN18_9","073_18_9","JHN","18","9","9","Geŋ iŋkino a onamí ɗoŋ yi ruute ki pooneʼŋ a-tʼiide a urzizaŋ, onamí ɗoŋ yi ruute, yʼede: «Meeʼki nuŋ, ɗuwo ɗoŋ kʼo ele eŋ, soo toŋ ni ki digge ye.» ");
INSERT INTO moz_vpl VALUES ("JN18_10","073_18_10","JHN","18","10","10","Maŋ Simo Piyer i-dʼede kasigara a beezí, yʼa tʼiiɗiba, yʼa-diikiɗa wede naabo ki mozigo goole ɗoŋ seɗeke, kuudí wede kʼammade a ɗikke. Wede naabo geŋ sundí Malkus. ");
INSERT INTO moz_vpl VALUES ("JN18_11","073_18_11","JHN","18","11","11","Maŋ Isa yi di ruute a Piyer, yʼede: «Kasigaradá ki ti tʼelo saapatú. Kee kʼelkiyo miŋ kop ki dabar ere Meegó yʼo elo ette, nʼa ki-ti dabira ye ko?» ");
INSERT INTO moz_vpl VALUES ("JN18_12","073_18_12","JHN","18","12","12","Saŋ maŋ kane asigiryagi Romeŋ ti goolayaŋ, wo ti asigiryagi deero Yawudiyagi ɗoŋ i boohiyo Ɓoy Raa geŋ, Isa an di yʼ ziiɗa, an ti yʼ gittite. ");
INSERT INTO moz_vpl VALUES ("JN18_13","073_18_13","JHN","18","13","13","An di-tʼiide ki pooneʼŋ di Anne eeme Kayip. Kayip geŋ mozigo goole ɗoŋ seɗeke a ozzine geŋ me. ");
INSERT INTO moz_vpl VALUES ("JN18_14","073_18_14","JHN","18","14","14","Wo yo Kayip geŋ yʼan di ruute ono a deero Yawudiyagi me, yʼede: «Beehiyeʼŋ wedusu soo yʼa tʼinda kono ɗoŋ duuru pay an dʼutte.» ");
INSERT INTO moz_vpl VALUES ("JN18_15","073_18_15","JHN","18","15","15","Simo Piyer ti sanallusu soo geŋ an daaniya Isa. Sanallusu wede soo geŋ, mozigo goole ɗoŋ seɗeke yi yʼ suune, yi-tʼiide ti Isa soo kʼadda booro ɓoy ki mozigo goole ɗoŋ seɗeke me. ");
INSERT INTO moz_vpl VALUES ("JN18_16","073_18_16","JHN","18","16","16","Wo Piyer geŋ yʼa uupe paate a biza bumɓu. Iŋkino maŋ sanallusu wede mozigo goole ɗoŋ seɗeke yi yʼ suune geŋ yʼa dʼuɗɗe, yi di ruute a ere naabo i boohiyo biza bumɓu gettiyo, maŋ Piyer toŋ yi-tʼiide kay. ");
INSERT INTO moz_vpl VALUES ("JN18_17","073_18_17","JHN","18","17","17","Aame yʼette kʼadda geŋ, to ere naabo i boohiyo biza bumɓu gette tʼa yi tunde Piyer me, tʼede: «Kee toŋ maŋ ti diine sanalliyagi ki wedusu en̰n̰o ɗee ɗa?» Piyer yi diʼn gime onamtú, yʼede: «Aha! Nuŋ ti kane ye.» ");
INSERT INTO moz_vpl VALUES ("JN18_18","073_18_18","JHN","18","18","18","Umeʼŋ reele, iŋkino maŋ kane ɗoŋ naabo ti asigiryagi ɗoŋ i boohiyo Ɓoy Raa geŋ an di muɗɗe uwwo, an di kookiyo. Piyer toŋ maŋ yʼa-tʼiide ti kane, yi-kookiyo kay. ");
INSERT INTO moz_vpl VALUES ("JN18_19","073_18_19","JHN","18","19","19","Aame geŋ yo mozigo goole ɗoŋ seɗeke yʼa iise tondiso kʼIsa a tukki sanalliyagí wo a dooyisadí. ");
INSERT INTO moz_vpl VALUES ("JN18_20","073_18_20","JHN","18","20","20","Isa yi diʼn gime onamí, yʼede: «Munɗa ombiɗe soo toŋ ni ki ruute ye. Ni ruute onamóʼŋ keren̰ a ɗaana ɗoŋ duniya me. Ni duuyiteʼŋ daayum adda ɓoyɗi ɗoŋ in di dooyiso, wo adda Ɓoy Raa, ume wede Yawudiyagi pay an dʼollige. ");
INSERT INTO moz_vpl VALUES ("JN18_21","073_18_21","JHN","18","21","21","Ɗe ki moo me ki ni tondiso me? Ki tondoʼŋ ɗoŋ i nʼilliga a munɗa wede nʼan ruute. Kʼollo, munɗa wede nuŋ nʼan ruute, an yi suune.» ");
INSERT INTO moz_vpl VALUES ("JN18_22","073_18_22","JHN","18","22","22","A ono ɗoŋ Isa yi ruute iŋkino geŋ, i dʼede asugursu i boohiyo Ɓoy Raa yʼôhire a ume gen̰n̰o, yʼa yi ɓitte Isa me, wo yʼa ruute, yʼede: «A mozigo goole ɗoŋ seɗeke miŋ ki di rootiyo iŋkino ko?» ");
INSERT INTO moz_vpl VALUES ("JN18_23","073_18_23","JHN","18","23","23","Isa yi di ruute, yʼede: «Munɗa wede ni ruute ulsuʼŋ too me? Ki ki yʼ kazi ɗo. Wo ni ruuteʼŋ ɗerec maŋ, ki moo me ki di nʼ ɓattiya me?» ");
INSERT INTO moz_vpl VALUES ("JN18_24","073_18_24","JHN","18","24","24","Iŋkino maŋ Anne yʼa yʼigibe kaŋ kettiso di Kayip mozigo goole ɗoŋ seɗeke. ");
INSERT INTO moz_vpl VALUES ("JN18_25","073_18_25","JHN","18","25","25","Aame geŋ Piyer yo ede a biza kʼuwwo, yi kookiyo. An di yʼ tunde, anʼde: «Kee toŋ ti diine sanalliyagi ki wede en̰n̰o ɗee ɗa?» Maŋ Piyer yʼa yi giigira, yʼede: «Aha! Nuŋ ti kane ye.» ");
INSERT INTO moz_vpl VALUES ("JN18_26","073_18_26","JHN","18","26","26","Ti diine ɗoŋ naabo ki mozigo goole ɗoŋ seɗeke geŋ, i dʼede wede ede yoŋ taasa ki wede Piyer yʼa-ɗikke kuudí gen̰n̰o, yi di ruute, yʼede: «Wo kee eŋ, ni ki wullo ti yode adda jineene ɗee ɗa?» ");
INSERT INTO moz_vpl VALUES ("JN18_27","073_18_27","JHN","18","27","27","Maŋ Piyer yʼa yi giigira sey Isa me. Aame geŋ uzu yʼa îile. ");
INSERT INTO moz_vpl VALUES ("JN18_28","073_18_28","JHN","18","28","28","Saŋ maŋ ti soohe walak, ti di Kayip Isa an di tʼiide di Pilat, yoŋ Romeŋ goole siiɗo. An iiney maŋ, kane deero Yawudiyagi an ki dʼiide ye kʼadda ɓoy me, kono an ki dehu an ki-tʼise ganigi a urzi kʼoogiradaŋ ye, kono an dʼooma omɓo tarnaape Pak ki Yawudiyagi. ");
INSERT INTO moz_vpl VALUES ("JN18_29","073_18_29","JHN","18","29","29","Iŋkino maŋ Pilat yʼa tʼuɗɗe, yʼan uuney paate. Aame yiʼn uuney maŋ, yʼanni tunde, yʼede: «Wede eŋ kun yi zikiyeʼŋ ki moo me?» ");
INSERT INTO moz_vpl VALUES ("JN18_30","073_18_30","JHN","18","30","30","Kane an i diʼn gime onamí, anʼde: «Aame yi kʼize munɗa ulsu ye maŋ, ay di yʼ seeɗo ay a dʼetto ko?» ");
INSERT INTO moz_vpl VALUES ("JN18_31","073_18_31","JHN","18","31","31","Maŋ Pilat yʼan di ruute, yʼede: «Iŋkino maŋ ooho, kune batum kun ti yʼ waako, kun ɗekkoy booro aa oogiraguŋ ti rootiyo.» Maŋ kane Yawudiyagi an i di ruute, anʼde: «Oogoro tʼay kʼele urzi ki tôwwo wedusu ye.» ");
INSERT INTO moz_vpl VALUES ("JN18_32","073_18_32","JHN","18","32","32","Geŋ iŋkino a-tʼiide a ono ɗoŋ Isa yi ruute a urzi kʼuntadí, kaŋ mummino untadí ere yi tʼinda te. ");
INSERT INTO moz_vpl VALUES ("JN18_33","073_18_33","JHN","18","33","33","Iŋkino maŋ Pilat yʼa-gime kʼadda ɓoy, yʼa yi wiike Isa me, wo yʼa yi tunde, yʼede: «Keeʼŋ mozigo Yawudiyagi ko?» ");
INSERT INTO moz_vpl VALUES ("JN18_34","073_18_34","JHN","18","34","34","Isa yi diʼn gime onamí, yʼede: «Onamá ɗoŋ ki rootiyo eŋ, ilkeʼŋ kee kunuŋ, a-gizeʼŋ ɗuwo ko a tukki nuŋ me?» ");
INSERT INTO moz_vpl VALUES ("JN18_35","073_18_35","JHN","18","35","35","Maŋ Pilat yi di ruute, yʼede: «Nuŋ Yawudusu ko? I ki ziiɗoʼŋ ɗoŋ siiɗadá ti deero ɗoŋ seɗeke oo dʼiido me. Kʼizo moo me?» ");
INSERT INTO moz_vpl VALUES ("JN18_36","073_18_36","JHN","18","36","36","Isa yi diʼn gime onamí, yʼede: «Nuŋ mozikadó a siiɗo ettiyo ye. Aame mozikadó ki duniya ettiyo maŋ, ɗoŋzó an dʼobbira arka, an kʼooli, an di nʼ seeɗa, an an di nʼ tʼele bey deero Yawudiyagi ye. Wo iŋkino ye, aŋken̰n̰o mozikadó a siiɗo ettiyo ye.» ");
INSERT INTO moz_vpl VALUES ("JN18_37","073_18_37","JHN","18","37","37","Iŋkino maŋ Pilat yʼa yi tunde, yʼede: «Keeʼŋ kaciŋ mozigo ko?» Isa yi diʼn gime onamí, yʼede: «Eyye aa ki ruute, nuŋ mozigo. Kono iŋkino nuŋ an di nʼehe wo nʼa iido kʼadda duniya, nʼan di kize urzi wede ki ɗerec, wo kane ɗoŋ i dehu urzi wede ki ɗerec geŋ, an dʼollige onamó.» ");
INSERT INTO moz_vpl VALUES ("JN18_38","073_18_38","JHN","18","38","38","Maŋ Pilat yʼa tunde Isa, yʼede: «Wo ɗerec, i-kaza moo me?» Aame Pilat yʼa ti ruute iŋkino maŋ yʼa tʼiiziga, yʼa tʼuɗɗe kʼume Yawudiyagi sey. Yʼiideʼŋ yʼan di ruute, yʼede: «Nuŋ me, a tukki wede eŋ munɗa ulsu ni kʼuune ye. ");
INSERT INTO moz_vpl VALUES ("JN18_39","073_18_39","JHN","18","39","39","Wo ɗe aa daayum kun dʼisiyo a tarnaape Pak ki Yawudiyagi maŋ, nʼun dʼaɗɗiya wedusu tʼadda daŋgay, wede aa adduguŋ i dehu. Geŋ kun dehu nʼun tʼaɗɗo mozigo Yawudiyagi ko?» ");
INSERT INTO moz_vpl VALUES ("JN18_40","073_18_40","JHN","18","40","40","Iŋkino maŋ kane an dʼiise ɗollite, anʼde: «Aha, yode ye! Kʼay tʼaɗɗiʼŋ Barabas! Aha, yode ye! Kʼay tʼaɗɗiʼŋ Barabas!» Wo yo Barabas geŋ, yoŋ wede ɗekkiyo kʼurzi. ");
INSERT INTO moz_vpl VALUES ("JN19_1","073_19_1","JHN","19","1","1","Iŋkino maŋ Pilat yʼan di yʼele Isa a asigiryagi, an di yʼ kosse ti marpa. ");
INSERT INTO moz_vpl VALUES ("JN19_2","073_19_2","JHN","19","2","2","Asigiryagi an di gini kaɗumul kʼahimagi an i-tʼusse eedí, wo an dʼumɓe kalle teeze an i di tʼusse. ");
INSERT INTO moz_vpl VALUES ("JN19_3","073_19_3","JHN","19","3","3","Maŋ an aa dʼettiyo goppoŋ kʼume yode, an dʼeesiyo: «Toosadá mozigo Yawudiyagi no! Toosadá mozigo Yawudiyagi no!» Wo an di yʼ dan̰ƴisa. ");
INSERT INTO moz_vpl VALUES ("JN19_4","073_19_4","JHN","19","4","4","Pilat yʼa tʼuɗɗe sey, wo yʼan di ruute Yawudiyagi, yʼede: «Kun ollo, nuŋ Isa nʼun di yʼaɗɗo paate, wo kun suuno a tukki yode eŋ nuŋ munɗa ulsu ni kʼuune ye, i di tʼîde kʼunto me.» ");
INSERT INTO moz_vpl VALUES ("JN19_5","073_19_5","JHN","19","5","5","Maŋ Isa yʼa tʼuɗɗe paate ti kaɗumul kʼahimagi a eedí, wo ti kalle teeze. Wo Pilat yʼan di ruute, yʼede: «Kun wollo wedeʼŋ en̰n̰o!» ");
INSERT INTO moz_vpl VALUES ("JN19_6","073_19_6","JHN","19","6","6","Aame deero ɗoŋ seɗeke ti asigiryagi ɗoŋ i boohiyo Ɓoy Raa an wulle Isa maŋ, an dʼiise ɗollite, anʼde: «Ki ti yʼ taako ekkʼundumu wede zaapu tʼekki bakadí kaŋ tontilko! Ki ti yʼ taako ekkʼundumu wede zaapu tʼekki bakadí kaŋ tontilko!» Maŋ Pilat yʼan di ruute, yʼede: «Kunʼdo, i ti yʼ taakoy kune ekkʼundumu wede zaapu tʼekki bakadí kaŋ tontilko me, kono nuŋ a tukki yode eŋ munɗa ulsu ni kʼuune ye, i di tʼîde kʼunto me.» ");
INSERT INTO moz_vpl VALUES ("JN19_7","073_19_7","JHN","19","7","7","Maŋ kane deero Yawudiyagi an i di ruute, anʼde: «Kayeʼŋ ay dʼede oogoro, wo a urzi kʼoogoro yʼa tʼinda kono yi-tʼize tuddí yoŋ Ulo Raa.» ");
INSERT INTO moz_vpl VALUES ("JN19_8","073_19_8","JHN","19","8","8","Aame Pilat yʼilliga ono gen̰n̰o maŋ, yʼa urgiɗe ɓaadaŋ. ");
INSERT INTO moz_vpl VALUES ("JN19_9","073_19_9","JHN","19","9","9","Yi-tʼiide kʼadda ɓoy, maŋ yʼa tunde Isa, yʼede: «Kee kʼettiyoʼŋ ti too me?» Wo yo Isa yi dʼannugu ɗeɗɗek, onamíʼŋ yi-kiʼn kama ye. ");
INSERT INTO moz_vpl VALUES ("JN19_10","073_19_10","JHN","19","10","10","Iŋkino maŋ Pilat yi di ruute, yʼede: «A nuuno miŋ, kee ki dʼannugu me? Kee ki ki suune ye ko nuŋ oo dʼede toogo nʼaane nʼa-dʼeeze, wo nʼaane nʼa ki ti taake ekkʼundumu wede zaapu tʼekki bakadí kaŋ tontilko me.» ");
INSERT INTO moz_vpl VALUES ("JN19_11","073_19_11","JHN","19","11","11","Isa yi di ruute, yʼede: «Keeʼŋ a-kʼede toogo a tukki nuuno ye, daa kʼere Raa yʼa-kʼele ye maŋ. Kono kamo, wede yʼan ele nuŋ a beezá geŋ, yoŋ wede kʼolɗiko a jiire kee.» ");
INSERT INTO moz_vpl VALUES ("JN19_12","073_19_12","JHN","19","12","12","Tiŋ geŋ Pilat yʼa iise dehu kʼurzi yi-dʼeeze a Isa, wo kane deero Yawudiyagi an dʼiise ɗollite, anʼde: «Wede eŋ ki iiza maŋ, ɗuwo an di suuna kaciŋ keeʼŋ laŋze ki mozigo goole ki Romeŋ ye. Wede yi ti tʼisiyo tuddí aa mozigo geŋ, yʼolmiɗe mozigo goole ki Romeŋ.» ");
INSERT INTO moz_vpl VALUES ("JN19_13","073_19_13","JHN","19","13","13","Aame Pilat yʼilliga iŋkino maŋ, Isa yʼa yʼuɗɗe ti paate, wo yoŋ yʼa-guune ekki kaakido booro. Ume geŋ an iiziga ti kaŋgiragi deero, an di yʼ waaku Gabata tʼono ɗoŋ kʼEber me. ");
INSERT INTO moz_vpl VALUES ("JN19_14","073_19_14","JHN","19","14","14","Iŋkino maŋ soggo tarnaape Pak ki Yawudiyagi geŋ, a peeɗo tʼize diine maŋ, Pilat yʼan di ruute Yawudiyagi, yʼede: «Kun wollo, mozigaguŋ en̰n̰o!» ");
INSERT INTO moz_vpl VALUES ("JN19_15","073_19_15","JHN","19","15","15","Maŋ kane an dʼiise ɗollite, anʼde: «Ki yʼôodo, ki yʼôodo, ki ti yʼ taako ekkʼundumu wede zaapu tʼekki bakadí kaŋ tontilko!» Maŋ Pilat yʼan di ruute, yʼede: «Kun dehu mozigaguŋ nʼa ti yʼ taako ekkʼundumu gen̰n̰o ko?» Kane deero ɗoŋ seɗeke an i diʼn gime onamí, anʼde: «Mozigayey ti dooloʼŋ umbo. Mozigayey miŋ yoŋ soo, mozigo goole ki Romeŋ.» ");
INSERT INTO moz_vpl VALUES ("JN19_16","073_19_16","JHN","19","16","16","Iŋkino maŋ Pilat yʼan di yʼele Isa a beezaŋ, kono an ti yʼ taake ekkʼundumu wede zaapu tʼekki bakadí kaŋ tontilko. Maŋ kane asigiryagi an ti yʼ ziiɗa. ");
INSERT INTO moz_vpl VALUES ("JN19_17","073_19_17","JHN","19","17","17","Isa yode batum yʼa tʼumɓe undumzí an di yʼ taakey, yʼa tʼuɗɗe tʼadda geeger me, yʼa iŋgile kʼume wede an yi waaku «osse kʼeego», tʼono ɗoŋ kʼEber an yi waaku Golgota. ");
INSERT INTO moz_vpl VALUES ("JN19_18","073_19_18","JHN","19","18","18","Aame an iiney a ume gen̰n̰o maŋ, asigiryagi an ti yʼ tiike Isa ekkʼundumu wede zaapu tʼekki bakadí kaŋ tontilko. Wo an aa tiike ɗoŋ sire a sirpa kʼIsa me, wede soŋ tʼundumzí a kese kʼammade, wede soŋ tʼundumzí a kese geelo, wo Isa a diine. ");
INSERT INTO moz_vpl VALUES ("JN19_19","073_19_19","JHN","19","19","19","Pilat yʼan dʼele urzi an a di riiŋe ekki pakirte, an a-ti tiike ekkʼundumu gen̰n̰o: «Isa wede ti geeger Nazaret, mozigo Yawudiyagi.» ");
INSERT INTO moz_vpl VALUES ("JN19_20","073_19_20","JHN","19","20","20","Raaŋiya gette Yawudiyagi ɓaadaŋ an di girite, kono ume wede an di tiike Isa geŋ yoŋ goppoŋ ti geeger te, wo raaŋiya gette an riiŋe tʼono ɗoŋ kʼEber, tʼono Romeŋ wo tʼono Girek pây. ");
INSERT INTO moz_vpl VALUES ("JN19_21","073_19_21","JHN","19","21","21","Aame kane deero ɗoŋ seɗeke Yawudiyagi an wulle raaŋiya gettiyo maŋ, an dʼiide an dʼuuney Pilat, wo an i di ruute, anʼde: «Raaŋiya ere yoŋ “mozigo Yawudiyagi” gette mentú. Ki raaŋa: “Wede eŋ yi-tʼize tuddí, yʼede yoŋ mozigo Yawudiyagi.”» ");
INSERT INTO moz_vpl VALUES ("JN19_22","073_19_22","JHN","19","22","22","Maŋ Pilat yʼan diʼn gime onamaŋ, yʼede: «Nuŋ ni riiŋe geŋ, ni riiŋe baa.» ");
INSERT INTO moz_vpl VALUES ("JN19_23","073_19_23","JHN","19","23","23","Aame asigiryagi an ti yʼ tiike Isa ekkʼundumu wede zaapu tʼekki bakadí kaŋ tontilko maŋ, kallagí an di ziki, an di dikkiɗa omagi piɗe, wede soŋ yi dʼumɓe dʼumɓe. I dʼiili kallayí goole, yoŋ geŋ an indigo miŋ iŋkino baa, tʼawwa a-ti ɗiige ɗanɗi daa ƴeppiyo. ");
INSERT INTO moz_vpl VALUES ("JN19_24","073_19_24","JHN","19","24","24","Asigiryagi an di ruute tuddaŋ, anʼde: «Yo eŋ in ti yʼ sittite ye, in tʼiso teltel muntelliyo, wede tuuku i tʼiira maŋ, yʼa tʼamɓa.» Geŋ iŋkino a-tʼiide a ono ɗoŋ an riiŋe ti kaaga adda mattup ki Raa, anʼde: «Kallagó an di dikkiɗa, wo kallayó goole an tʼize teltel muntelliyo.» Geŋ iŋkino munɗa wede asigiryagi an ize me. ");
INSERT INTO moz_vpl VALUES ("JN19_25","073_19_25","JHN","19","25","25","A sirpa kʼundumu wede an di tiike Isa geŋ, an tʼîhira meedí, teema meedí, Mariyam ere Kilopas, wo Mariyam ere ti siiɗo Magdalla. ");
INSERT INTO moz_vpl VALUES ("JN19_26","073_19_26","JHN","19","26","26","Isa yi wolliyoʼŋ meedí, wo a sirpatú sanallusu wede yi yʼ giyye gen̰n̰o. Maŋ yi di ruute a meedí, yʼede: «Mekʼki nuŋ, mi wollo ulí en̰n̰o.» ");
INSERT INTO moz_vpl VALUES ("JN19_27","073_19_27","JHN","19","27","27","Saŋ maŋ yi di ruute a sanallusu geŋ, yʼede: «Ki wollo, meedá gettiyo.» Iŋkino maŋ tʼume geŋ sanallusu yʼa ti wiike Mariyam di yode. ");
INSERT INTO moz_vpl VALUES ("JN19_28","073_19_28","JHN","19","28","28","Tiŋ geŋ, Isa yʼa zuune sulɗi pay a ti ɗiŋge, maŋ yʼa ruute, yʼede: «Nuŋ ôrme.» Yi ruute iŋkino kono a-tʼette a ono ɗoŋ an riiŋe ti kaaga adda mattup ki Raa. ");
INSERT INTO moz_vpl VALUES ("JN19_29","073_19_29","JHN","19","29","29","Aame geŋ i dʼede keyye ɓoo ti toote suddo kʼin̰n̰i kʼinda bin̰. Asigiryagi an dʼumɓe buuɗe, an a di gitte a biza kʼundumu aa koƴile sundí izop. An di zulpe adda toote gen̰n̰o, maŋ an i-tʼusse a bize kʼIsa. ");
INSERT INTO moz_vpl VALUES ("JN19_30","073_19_30","JHN","19","30","30","Aame Isa yʼuwwe toote gen̰n̰o maŋ, yʼa ruute, yʼede: «Pay a ti ɗiŋge.» Iŋkino maŋ yʼa tʼuttile eedí ki siiɗo, maŋ yʼa iili undí tʼa tʼuɗɗe, yʼa-tʼihe. ");
INSERT INTO moz_vpl VALUES ("JN19_31","073_19_31","JHN","19","31","31","Aakede kane Yawudiyagi an okkime tuddaŋ soggoʼŋ onniyo puukiyo geŋ, kane deero Yawudiyagi an ki dehu ɗoŋ an tiʼn tiike ekkʼinda ɗoŋ zaapu tʼekkʼeebaŋ kaŋ tontilko geŋ, nunɗanzaŋ an ki lekke ekkʼindanzaŋ ye, kono onniyo ere ki puukiyo Yawudiyagi ette, todʼte onniyo ere majjaanawa a jiire. Iŋkino maŋ an dʼiide, an tunde Pilat, anʼde: «Urzi ede maŋ kʼan rooto an di damɓe zoŋɗaŋ an di tʼinda, wo an tiʼn ɗeego tʼekkʼinda me, an tʼottiba ki poone onniyo ere ki puukiyo tʼa aana geŋ me.» ");
INSERT INTO moz_vpl VALUES ("JN19_32","073_19_32","JHN","19","32","32","Maŋ Pilat yʼa igibe asigiryagi. An dʼiide, an dʼiise ti ɗoŋ sire an tiike ti Isa soo gen̰n̰o. Wede ki poone an di dimɓe zoŋɗí, saŋ wede ki sirwe. ");
INSERT INTO moz_vpl VALUES ("JN19_33","073_19_33","JHN","19","33","33","Aame an iide kʼume kʼIsa maŋ, an wolliyoʼŋ yoŋ yʼinda. Iŋkino maŋ an dʼiili an ki dimɓe ye baa zoŋɗí me. ");
INSERT INTO moz_vpl VALUES ("JN19_34","073_19_34","JHN","19","34","34","Wo asigursu soo ti diine kane asigiryagi geŋ, yʼa yi giira Isa ti arku a sirpadí, maŋ a kaamiki a uɗɗe puuzo ti ahu. ");
INSERT INTO moz_vpl VALUES ("JN19_35","073_19_35","JHN","19","35","35","Wede eŋ yi wulle tʼedayí sulɗi pay geŋ me, ɗoo miŋ yi rootiyo taayadaŋ me, wo onamí eŋ yi rootiyo ɗerec. Yoŋ yi suune yi rootiyo ono ɗoŋ ɗerec, kono kune toŋ kun dʼamɓe kay. ");
INSERT INTO moz_vpl VALUES ("JN19_36","073_19_36","JHN","19","36","36","Iŋkino maŋ sulɗi pay eŋ a iina, kono a-tʼette a ono ɗoŋ an riiŋe ti kaaga adda mattup ki Raa, anʼde: «Ossayí soo toŋ i ki dahima ye.» ");
INSERT INTO moz_vpl VALUES ("JN19_37","073_19_37","JHN","19","37","37","A ume doolo toŋ ede an riiŋe ti kaaga adda mattup ki Raa, anʼde: «Saŋ onniyo soo wede an yi giira geŋ, an di yʼ wolla.» ");
INSERT INTO moz_vpl VALUES ("JN19_38","073_19_38","JHN","19","38","38","Saŋ maŋ tiŋ geŋ i dʼede wede soo sundí Yusup ti geeger kʼArimate. Yoŋ geŋ sanallusu kʼIsa, wo yi kʼooɗibe itadí ye kono yʼorgiso a deero Yawudiyagi. Yʼiideʼŋ, yʼa uuney Pilat, yʼa yi tunde kono yʼa ti yʼ ɗeege nuune kʼIsa me. Maŋ Pilat yʼa iyye. Yusup yʼiideʼŋ, yʼa ti yʼ ɗiige nuune tʼekkʼundumu me. ");
INSERT INTO moz_vpl VALUES ("JN19_39","073_19_39","JHN","19","39","39","Nikodem, wede onniyo soo yʼa iide kʼume kʼIsa a diɗɗo geŋ, yʼa iide kay. Yi ziki dunnu sundí mirr kalsiya ti sulɗi doolo eeɗiyadaŋ uŋse, attiɗi suma jeenu ada gʼaɗo. ");
INSERT INTO moz_vpl VALUES ("JN19_40","073_19_40","JHN","19","40","40","Iŋkino maŋ Yusup kane ti Nikodem an tʼumɓe nuune kʼIsa, an a-dʼiɓiti sulɗi eeɗiyadaŋ uŋse, an di n̰ilpiyo ti sarwilagi, an aa dʼoɓite sulɗi eeɗiyadaŋ uŋse, an di n̰ilpiyo n̰ilpiyo. An tʼize aa a urzi kʼottibe Yawudiyagi. ");
INSERT INTO moz_vpl VALUES ("JN19_41","073_19_41","JHN","19","41","41","Goppoŋ ti ume an tiike Isa ekkʼundumu geŋ i dʼede jineene, wo adda jineene gette i dʼede muuzo aware, wenɗa soo toŋ an kʼeele ye. ");
INSERT INTO moz_vpl VALUES ("JN19_42","073_19_42","JHN","19","42","42","An tʼeele nuune kʼIsa adda muuzo gettiyo kono todʼte goppoŋ. Sulɗi geŋ ize a onniyo jima, Yawudiyagi an okkime tuddaŋ kono onniyo ere ki puukiyo ti tʼeesa. ");
INSERT INTO moz_vpl VALUES ("JN20_1","073_20_1","JHN","20","1","1","A onniyo dumas ti soohe walak peeɗo daa koliyo, Mariyam ere ti siiɗo Magdalla tʼa iŋgile ki biza muuzo kʼIsa. Aame tʼiiney maŋ, ti wolliyoʼŋ zumbulu wede an ɗuŋkile a biza muuzo geŋ, ɗoŋkilso a kese. ");
INSERT INTO moz_vpl VALUES ("JN20_2","073_20_2","JHN","20","2","2","Iŋkino maŋ tʼa-gime kaŋ okko. Tʼiideʼŋ, tʼa uuney Piyer kane ti sanallusu soo, wede Isa yi yʼ giyye gen̰n̰o, wo tʼan di ruute, tʼede: «Galmeega aŋ wenɗa an tʼiiɗiba tʼadda muuzo me, wo an di zaapey a tunɗa koo maŋ ay ki suune ye.» ");
INSERT INTO moz_vpl VALUES ("JN20_3","073_20_3","JHN","20","3","3","Aame Piyer kane ti sanallusu soo geŋ an illiga iŋkino maŋ, an tʼiiziga an dʼiŋgile ki biza muuzo. ");
INSERT INTO moz_vpl VALUES ("JN20_4","073_20_4","JHN","20","4","4","Sirwaŋ pay an zide okko, wo ɗe yo sanallusu soo geŋ yʼokko ɓaadaŋ i jiire Piyer yʼa iiney kaaga a biza muuzo me. ");
INSERT INTO moz_vpl VALUES ("JN20_5","073_20_5","JHN","20","5","5","Yʼiiney maŋ, yʼaa dʼuttile, yi ŋooŋiyo kʼadda muuzo. Yi wolliyoʼŋ sarwilagi ɗoŋ an di n̰ilpeʼŋ booyiso a siiɗo, wo kʼaddaʼŋ yi-ki tʼiide ye. ");
INSERT INTO moz_vpl VALUES ("JN20_6","073_20_6","JHN","20","6","6","Taŋ booloŋ maŋ, Simo Piyer yʼa dʼiiney, yi-tʼiide kʼadda muuzo. Yi wolliyoʼŋ sarwilagi ɗoŋ an di n̰ilpeʼŋ booyiso a siiɗo. ");
INSERT INTO moz_vpl VALUES ("JN20_7","073_20_7","JHN","20","7","7","Wo sarwilagi ɗoŋ an di gitte bizíʼŋ geŋ, kaneʼŋ lobiɗe zaapu a kese siidaŋ ti ɗoŋ an di n̰ilpe tuddeʼŋ kaŋ soo ye. ");
INSERT INTO moz_vpl VALUES ("JN20_8","073_20_8","JHN","20","8","8","Iŋkino maŋ sanallusu wede iiney a biza muuzo kaaga geŋ, yi-tʼiide kay, yʼa wulle, wo yʼa umɓe Isa yi-bilɗe. ");
INSERT INTO moz_vpl VALUES ("JN20_9","073_20_9","JHN","20","9","9","Bini onniyo gettiyo toŋ, kane sanalliyagi ita kʼono geŋ an ki zuune ye ɓotto, ono ɗoŋ an riiŋe ti kaaga adda mattup ki Raa, saŋ Isa yʼa-balɗa ti diine ɗoŋ unto geŋ me. ");
INSERT INTO moz_vpl VALUES ("JN20_10","073_20_10","JHN","20","10","10","Saŋ maŋ kane sanalliyagi sire geŋ an di-gime, an dʼaahe ki ɓoozaŋ. ");
INSERT INTO moz_vpl VALUES ("JN20_11","073_20_11","JHN","20","11","11","Saŋ maŋ Mariyam gette tʼaa gime ki biza muuzo sey. Tʼiideʼŋ, tʼa tʼîhira ti paate a biza muuzo, ti-môolo. Kaŋ môolo geŋ tʼa tʼuttile, ti-ŋooŋiyo kʼadda muuzo. ");
INSERT INTO moz_vpl VALUES ("JN20_12","073_20_12","JHN","20","12","12","Ti wolliyoʼŋ addaʼŋ maaleekiyagi sire ossiyo ti kallagi tuwarɗi an lekkiyo a ume an di ziipe nuune kʼIsa. Wede soŋ a ume kʼeedí, wo soŋ a ume zoŋɗí. ");
INSERT INTO moz_vpl VALUES ("JN20_13","073_20_13","JHN","20","13","13","Kane maaleekiyagi geŋ an di-tunde, anʼde: «Erewo no, mi môolo moo me?» Todʼ tʼan diʼn gime onamaŋ, tʼede: «Ni môolo Galmeegó, aŋ wenɗa an tʼiiɗiba, wo ni ki suune ye an di-zaapey a tunɗa me.» ");
INSERT INTO moz_vpl VALUES ("JN20_14","073_20_14","JHN","20","14","14","Aame ti rootiyo geŋ tʼa gilɗe, wo ti wolliyoʼŋ Isa yi tʼîhira a ume gen̰n̰o, wo tʼa ki yʼ zuune ye. ");
INSERT INTO moz_vpl VALUES ("JN20_15","073_20_15","JHN","20","15","15","Saŋ maŋ Isa yʼa ti tunde, yʼede: «Erewo no, mi môolo moo me, wo mi dehu wee wee?» Wo to Mariyam tʼelkiyo i ti tondiyo wede jineene, maŋ tʼa yi tunde, tʼede: «Wede no, koo i tʼiiɗiba nuune kʼIsa kee maŋ, kʼo kazi ume kʼa ziipe a tunɗaʼŋ, nʼette nʼa tʼamɓo.» ");
INSERT INTO moz_vpl VALUES ("JN20_16","073_20_16","JHN","20","16","16","Isa yʼa ti wiike ti sundutú, yʼede: «Mariyam.» Tʼa-gime edatúʼŋ kʼume yode, wo ti di ruute tʼono ɗoŋ kʼEber, tʼede: «Rabuni.» (I-kaza «wede dooyisadó.») ");
INSERT INTO moz_vpl VALUES ("JN20_17","073_20_17","JHN","20","17","17","Maŋ Isa yi di ruute, yʼede: «Mʼodo botte ye, kono nuŋ ni ki gili kʼume Meegó ye ɓotto. Wo koŋ, mʼodo kʼume zemɓadó, mʼan rootoy nuŋ ni kili kʼume Meegó wede a kune toŋ Meeguguŋ kay, kʼume Raazó wede a kune toŋ Raaguŋ kay.» ");
INSERT INTO moz_vpl VALUES ("JN20_18","073_20_18","JHN","20","18","18","Iŋkino maŋ Mariyam ere ti siiɗo Magdalla gette, tʼa iŋgile kʼume sanalliyagi. Tʼiideʼŋ tʼede ti yi wullo Galmeega me, wo tʼan di-ruute ono ɗoŋ yi ruuto me. ");
INSERT INTO moz_vpl VALUES ("JN20_19","073_20_19","JHN","20","19","19","A onniyo dumas gettiyo batum a lohe maŋ, sanalliyagi kʼIsa an tʼugiye adda ɓoy, bohaʼŋ an a-tʼippite ti kerle kono an orgiso a deero Yawudiyagi. Aame kane an lekkiyo adda geŋ, Isa yʼan uuney an wolliyoʼŋ yi tʼîhira a diinayaŋ, maŋ yʼan di ruute, yʼede: «Toose ti koona ti kune.» ");
INSERT INTO moz_vpl VALUES ("JN20_20","073_20_20","JHN","20","20","20","Aame yʼan ti ruute iŋkino maŋ, saŋ yʼan dʼiise kazita beyɗí ti ume wede an yi giira a sirpadí. Wo kane sanalliyagi ulbaŋ uŋse an wulle Galmeegaŋ geŋ me. ");
INSERT INTO moz_vpl VALUES ("JN20_21","073_20_21","JHN","20","21","21","Isa yʼan di ruute sey, yʼede: «Toose ti koona ti kune. Aakede Meegó yi nʼigibo kʼadda duniya geŋ, kune toŋ nʼun diʼn agiba kʼadda duniya kay.» ");
INSERT INTO moz_vpl VALUES ("JN20_22","073_20_22","JHN","20","22","22","Yʼa ti ruute iŋkino maŋ, yʼan di biiha maaye a tukki kane, wo yʼan di ruute, yʼede: «Kun sooɗo Unde Kamilen̰. ");
INSERT INTO moz_vpl VALUES ("JN20_23","073_20_23","JHN","20","23","23","A wede tuuku kun i tʼiza tambobino a olɗikadí maŋ, Raa toŋ yi tʼisa tambobino kay a olɗikadí te, wo a wede kun i ki tʼiza tambobino ye maŋ, olɗikadí Raa yi-kʼisa tambobino ye kay.» ");
INSERT INTO moz_vpl VALUES ("JN20_24","073_20_24","JHN","20","24","24","Onniyo ere Isa yʼuuney sanalliyagi geŋ, sanallusu wede an yi waaku Tomas, sundí soo Ulo Rooŋo, yoŋ ti diine sanalliyagi kane koomat makumu sire geŋ, yoŋ umbo. ");
INSERT INTO moz_vpl VALUES ("JN20_25","073_20_25","JHN","20","25","25","Aame Tomas yʼiina maŋ, kane sanalliyagi oŋgo an i di ruute, anʼde: «Kaye ay yi wulle Galmeega me!» Wo ɗe Tomas yʼan di ruute, yʼede: «Aame ni ki wulla ume an di yʼ tiike ti ponte a beyɗí ye, aame ni ki tʼeela ƴelsadó adda bulɗo ponte ye, wo beezó eŋ ni ki tʼeela a bulɗo ere an yi giira a sirpadí ye maŋ, onamguŋ eŋ ni kʼamɓa ye.» ");
INSERT INTO moz_vpl VALUES ("JN20_26","073_20_26","JHN","20","26","26","Onniyo dumas ki ɗaana maŋ, kane sanalliyagi an tʼugiye sey adda ɓoy, wo onniyo gette Tomas toŋ ti kane baa. Boha an aa tʼippite ti kerle, maŋ Isa yʼan diʼn uuney sey, yʼa tʼîhira a diinayaŋ, yʼan di ruute, yʼede: «Toose ti koona ti kune.» ");
INSERT INTO moz_vpl VALUES ("JN20_27","073_20_27","JHN","20","27","27","Saŋ maŋ yi di ruute Tomas, yʼede: «Kee ki wollo beyɗó me, kʼagibi ƴelsadá, ki tʼeelo adda. Kʼeli beezá pây ki tʼagiba adda sirpadó, wo ki niikiyoʼŋ kʼa oolo baa, ki zaapo addá a nuuno.» ");
INSERT INTO moz_vpl VALUES ("JN20_28","073_20_28","JHN","20","28","28","Maŋ Tomas yi di ruute, yʼede: «Kee Galmeegó, wo kee Raazó.» ");
INSERT INTO moz_vpl VALUES ("JN20_29","073_20_29","JHN","20","29","29","Isa yi di ruute, yʼede: «Kee ki ziipe addá a nuŋ kono ki ni wulle tʼedayá, wo uŋsuwo a kane ɗoŋ an ki nʼ wulle ye wo an di ziipe addaŋ a nuŋ.» ");
INSERT INTO moz_vpl VALUES ("JN20_30","073_20_30","JHN","20","30","30","Isa yʼizeʼŋ sulɗi kʼarmika ɓaadaŋ a ɗaana sanalliyagí me, wo kane raaŋiya pay ye adda mattup ette. ");
INSERT INTO moz_vpl VALUES ("JN20_31","073_20_31","JHN","20","31","31","Ono ɗoŋ soo raaŋiya adda mattup ette, kono kun dʼamɓe Isa yoŋ Almasi Raa yi biire, wo Ulo Raa. Wede yʼumɓe a sundí maŋ, yi di tʼela lekkiyo ere ki daayum. ");
INSERT INTO moz_vpl VALUES ("JN21_1","073_21_1","JHN","21","1","1","Aame sulɗi geŋ i tʼiŋgile maŋ, Isa yʼan di-gize tuddí sey a sanalliyagi a biza bar ki Tiberiyat. Kun wollo mummino me yʼan di-gize tuddí te. ");
INSERT INTO moz_vpl VALUES ("JN21_2","073_21_2","JHN","21","2","2","Simo Piyer, Tomas wede an yi waaku Ulo Rooŋo, Natanayel wede ti Kana siiɗo Galile, in̰n̰i Zebede, wo sanalliyagi kʼIsa sire ti doolo, kane pay geŋ an lekkiyo kaŋ soo. ");
INSERT INTO moz_vpl VALUES ("JN21_3","073_21_3","JHN","21","3","3","Maŋ Simo Piyer yʼan di ruute, yʼede: «Nuŋ ni tʼette sawwiya puuni.» Wo kane an i di ruute, anʼde: «In tʼette soo.» Iŋkino maŋ an dʼiŋgile, an iiney maŋ an di gili adda tooko, an dʼiise sawwiya. A diɗɗo gette an ziwwe kee, puuniso soo toŋ an kʼumɓe ye. ");
INSERT INTO moz_vpl VALUES ("JN21_4","073_21_4","JHN","21","4","4","Ume i tʼumpile maŋ, Isa yʼa tʼîhira a biza bar, wo kane sanalliyagi an ki yʼ zuune ye. ");
INSERT INTO moz_vpl VALUES ("JN21_5","073_21_5","JHN","21","5","5","Iŋkino maŋ Isa yʼanni tunde, yʼede: «In̰n̰i ki nuŋ, puuni kun uune ɗey?» Kane an i diʼn gime onamí, anʼde: «Aha, ay kʼuune ye.» ");
INSERT INTO moz_vpl VALUES ("JN21_6","073_21_6","JHN","21","6","6","Iŋkino maŋ Isa yʼan di ruute, yʼede: «Kun seɗɗo lebiɗo ki kese kʼammade tooko, wo kun tʼoona puuni me.» Maŋ an di ziɗɗe lebiɗo ki kese kʼammade ki tooko. An iise argu maŋ, kʼamɓu kʼadda tooko an kʼaaniya ye kono puuniʼŋ ɓaadaŋ, lebiɗo ɓoo. ");
INSERT INTO moz_vpl VALUES ("JN21_7","073_21_7","JHN","21","7","7","Sanallusu wede Isa yi giyye geŋ, yi di ruute a Piyer, yʼede: «Eŋ Galmeega!» Aame Piyer yʼilliga eŋ Galmeega maŋ, kallayí wede goole yi tʼiiɗiba geŋ yi tʼusse, yi-ti ɗiige adda kʼahu. ");
INSERT INTO moz_vpl VALUES ("JN21_8","073_21_8","JHN","21","8","8","Wo kane sanalliyagi ɗoŋ soŋ an dʼettiyo ti tooko, an dʼargu lebiɗo ɓoo ti puuni gettiyo, kono kaneʼŋ ti zeŋge dokki ye, suma kʼoole meeda sire ɗaŋŋal. ");
INSERT INTO moz_vpl VALUES ("JN21_9","073_21_9","JHN","21","9","9","Aame an ti ɗiige a siiɗo maŋ, an wolliyoʼŋ puuni ossiyto a biza kʼuwwo, wo mappa a kese. ");
INSERT INTO moz_vpl VALUES ("JN21_10","073_21_10","JHN","21","10","10","Maŋ Isa yʼan di ruute, yʼede: «Puuni ɗoŋ kun ziko geŋ, kun soki miibi.» ");
INSERT INTO moz_vpl VALUES ("JN21_11","073_21_11","JHN","21","11","11","Simo Piyer yʼa di gili adda tooko, yʼa-tʼirgo siiɗo lebiɗo ti puuni ɓoo gette, adda puuni deero, meeda uto ada paat makumu aɗo, toŋ lebiɗo a ki zitte ye. ");
INSERT INTO moz_vpl VALUES ("JN21_12","073_21_12","JHN","21","12","12","Maŋ Isa yʼan di ruute, yʼede: «Kunʼdi, kun ooma.» Iŋkino maŋ an dʼiide, wo ti diine sanalliyagi wenɗa soo toŋ umbo a yi tonde, yʼa tʼeese: «Kee wee wee me?» Ɗerec, kane an yi zuune yoŋ Galmeega me. ");
INSERT INTO moz_vpl VALUES ("JN21_13","073_21_13","JHN","21","13","13","Isa yʼaa dʼiide, yʼa tʼumɓe mappa, yʼan di-dikkiɗa, wo puuni toŋ yʼan dʼeele. ");
INSERT INTO moz_vpl VALUES ("JN21_14","073_21_14","JHN","21","14","14","Eŋ kʼaɗuwe Isa yʼan kaza tuddí a sanalliyagí, tʼume yi-bilɗe ti diine ɗoŋ unto me. ");
INSERT INTO moz_vpl VALUES ("JN21_15","073_21_15","JHN","21","15","15","Aame an tʼiimi maŋ, Isa yʼa tunde Simo Piyer, yʼede: «Simo ulo ki Zaŋ, kee ki ni giyye a jiire kane en̰n̰o ko?» Simo yi diʼn gime onamí, yʼede: «Eyye Galmeeʼki nuŋ, kee ki suune nuŋ ni ki giyye me.» Maŋ Isa yi di ruute, yʼede: «Kʼelso in̰n̰i damɓamó.» ");
INSERT INTO moz_vpl VALUES ("JN21_16","073_21_16","JHN","21","16","16","Yʼa yi tunde ki sirwe, yʼede: «Simo ulo ki Zaŋ, kee ki ni giyye ko?» Yoŋ yi diʼn gime onamí, yʼede: «Eyye Galmeeʼki nuŋ, kee ki suune nuŋ ni ki giyye me.» Isa yi di ruute, yʼede: «Ki booho damɓamó.» ");
INSERT INTO moz_vpl VALUES ("JN21_17","073_21_17","JHN","21","17","17","Saŋ maŋ yʼa yi tunde kʼaɗuwe sey, yʼede: «Simo ulo ki Zaŋ, kee ki ni giyye ko?» Aame yi yʼ tunde kʼaɗuwe sey «Kee ki ni giyye ko?» maŋ, Piyer yʼa tʼize sommagi dondoŋ, wo yi di ruute, yʼede: «Galmeeʼki nuŋ, kee ki suune sulɗi pay, wo ki suune ni ki giyye me.» Maŋ Isa yi di ruute, yʼede: «Kʼelso damɓamó. ");
INSERT INTO moz_vpl VALUES ("JN21_18","073_21_18","JHN","21","18","18","Ɗerec iŋkino wo nʼa di rooto: Aame keeʼŋ obulsu geŋ ki kettiyo serrayá ti siidá, wo ki dʼettiyo kʼume wede aa addá i dehu, wo aame ki tʼiza gôole maŋ, beyɗá kʼan onɗa soken̰, a di ketta serrayá wede doolo, wo yʼa-da tʼetta kʼume wede ki ki deha ye.» ");
INSERT INTO moz_vpl VALUES ("JN21_19","073_21_19","JHN","21","19","19","Isa yi rootiyo iŋkino kono yi kaza tʼurzi mummino Piyer yi tʼinda, wo a tʼela tamma a Raa me. Aame yʼa ti ruute iŋkino maŋ, a Piyer yi di ruute, yʼede: «Ki ni daani.» ");
INSERT INTO moz_vpl VALUES ("JN21_20","073_21_20","JHN","21","20","20","Maŋ Piyer yʼa gilɗe, yi wolliyoʼŋ sanallusu wede Isa yi giyye gen̰n̰o ti daraŋ me, wede onniyo soo aame an omɓo geŋ, yʼaa dʼuttile kʼume kʼIsa, yʼa yi tunde, yʼede: «Galmeeʼki nuŋ, wee wee wede a ki ti kʼowila me?» ");
INSERT INTO moz_vpl VALUES ("JN21_21","073_21_21","JHN","21","21","21","Piyer yi yʼ wulle maŋ, yʼa tunde Isa, yʼede: «Galmeegó, wo a yode eŋ i-dʼaana moo me?» ");
INSERT INTO moz_vpl VALUES ("JN21_22","073_21_22","JHN","21","22","22","Isa yi di ruute, yʼede: «Ni dehu maŋ, yʼa lekke bini kamadó ki duniya, wo keeʼŋ seezá ye, ki ni daani daaniya.» ");
INSERT INTO moz_vpl VALUES ("JN21_23","073_21_23","JHN","21","23","23","Iŋkino maŋ rabila gette a-tiipe, zemɓa ɗoŋ i ziipe addaŋ a Isa geŋ an dʼilliga, sanallusu geŋ yi ki tʼinda ye. Wo ki too maŋ Isa yi ki ruute ye a Piyer sanallusu geŋ yi ki tʼinda ye me, wo ɗe yi ruuteʼŋ, yʼede: «Ni dehu maŋ yʼa lekke bini kamadó ki duniya, wo keeʼŋ seezá ye.» ");
INSERT INTO moz_vpl VALUES ("JN21_24","073_21_24","JHN","21","24","24","Yode sanallusu gen̰n̰o i rootiyo taaya ki sulɗi geŋ me, wo yʼa tiʼn riiŋe. Wo ay suune onamí yi rootiyo eŋ ɗerec. ");
INSERT INTO moz_vpl VALUES ("JN21_25","073_21_25","JHN","21","25","25","Isa yʼize sulɗi ti doolo toŋ ɓaadaŋ, wo aame an tiʼn raaŋe pay soo ti soo maŋ, nʼelkiyo duniya pay ette ti kiʼn amɓe ye mattupiyagi ɗoŋ an raaŋe me.");
INSERT INTO moz_vpl VALUES ("AC1_1","074_1_1","ACT","1","1","1","Teyopil meeʼki nuŋ, nuŋ adda mattupadó ere ki poone, ni riiŋe sulɗi ɗoŋ pay Isa yʼize wo yi duuye ɗuwo tʼume kʼeesiyo, ");
INSERT INTO moz_vpl VALUES ("AC1_2","074_1_2","ACT","1","2","2","bini onniyo ere Raa yʼa yʼumɓe kʼawwa ki kandaane. Wo ki poone yʼa yʼamɓa geŋ, ti toogo kʼUnde Kamilen̰ yʼan di ruute sulɗi ɗoŋ an dʼise a ɗoŋ zindí ɗoŋ yi biire. ");
INSERT INTO moz_vpl VALUES ("AC1_3","074_1_3","ACT","1","3","3","Aame yi dibire bini yʼinda wo yi bilɗe maŋ, yʼan di gize tuddí te a kane ɗoŋ zindí tʼurzi ɓaadaŋ, geŋ i-kaza yoŋ ki kotto yi-bilɗe. Wo adda kʼonniyo ada piɗe geŋ tuddí yʼan di gize, wo yʼan di gizite sulɗi ɗoŋ ki Moziko Raa. ");
INSERT INTO moz_vpl VALUES ("AC1_4","074_1_4","ACT","1","4","4","Onniyo soo an ti guune omɓo ti kane gen̰n̰o maŋ, yʼan di ruute, yʼede: «Kun ollo koɗuwo, ti Zeruzalem eŋ kun arga tunɗa ye, kun dello munɗa wede Meega Raa yi ruute yʼun tʼela, aa kun illiga nʼun ruute ti bizó. ");
INSERT INTO moz_vpl VALUES ("AC1_5","074_1_5","ACT","1","5","5","Ti poone Zaŋ ɗuwo yiʼni zuyyite batem tʼahu, wo ɗe kuneʼŋ adda kʼonniyto miibi Raa yʼun tiʼn suyya batem tʼUnde Kamilen̰.» ");
INSERT INTO moz_vpl VALUES ("AC1_6","074_1_6","ACT","1","6","6","Wo kane ɗoŋ i tʼugiye a ɗaanadí geŋ an di yʼ tunde, anʼde: «Galmeegey, kee a onniyo gettiyo ko moziko ki ɗoŋ kʼIzirayel kʼan ti tʼela me?» ");
INSERT INTO moz_vpl VALUES ("AC1_7","074_1_7","ACT","1","7","7","Isa yʼan di ruute, yʼede: «Kane sulɗi ɗoŋ aakede onniyto, ise peeɗo ere tuuku Meega Raa yi dihe yʼaase ti toogadí geŋ, kun kʼaane kun ki tiʼn suune ye. ");
INSERT INTO moz_vpl VALUES ("AC1_8","074_1_8","ACT","1","8","8","Wo ɗe kune kun tʼoona toogo aame Unde Kamilen̰ ti ɗiiga egguŋ maŋ. Iŋkino maŋ kun kizita onamó, kun tʼeesa ti Zeruzalem, kun dʼamɓa kʼadda siiɗo ki Ziide ti Samari pay, bini ɗaŋgu siiɗo pay.» ");
INSERT INTO moz_vpl VALUES ("AC1_9","074_1_9","ACT","1","9","9","Aame yʼa ti ruute iŋkino maŋ, a ɗaanadaŋ geŋ miŋ yʼa tʼiiziga jomkey, yʼa iŋgile kʼawwa ki kandaane, an di wolliyo bini dondirso ti di yʼippe. ");
INSERT INTO moz_vpl VALUES ("AC1_10","074_1_10","ACT","1","10","10","Aame kane an ɓaɓɓiya Isa yʼeŋgile kʼawwa ki kandaane geŋ, an wolliyo bibaraw a sirpadaŋ ɗoŋ sire ti kallagi tuwarɗi, an an di ruute, anʼde: ");
INSERT INTO moz_vpl VALUES ("AC1_11","074_1_11","ACT","1","11","11","«Kune ɗoŋ ti siiɗo Galile no, kun ôhire kun ɓaɓɓiya kʼawwa ki kandaane moo me? Geŋ Isa Raa yi yʼumɓe ti ɗaanaguŋ, saŋ onniyo soo yʼa-kimo, kun di yʼ wolla aa kun yi wulle yʼiŋgile kʼawwa ki kandaane iŋkino sey.» ");
INSERT INTO moz_vpl VALUES ("AC1_12","074_1_12","ACT","1","12","12","Iŋkino maŋ kane ɗoŋ zina geŋ, tʼekki mokkolo ere an ti waaku mokkolo kʼInda kʼOlibiye an di-ɗiige, an dʼiŋgile ki Zeruzalem kono to mokkolo gette dokki ye ti Zeruzalem me, suma kuɓɓaara soo. ");
INSERT INTO moz_vpl VALUES ("AC1_13","074_1_13","ACT","1","13","13","An iiney Zeruzalem maŋ, an di-gili biino ere tʼawwa tʼekki bakatú aame an dʼogiyso daayum. Aame geŋ kane Piyer, Zaŋ, Zak, Andire, Pilip, Toma, Bartelemi, Matiye, Zak ulo kʼAlpe, Simo wede addí wehini kono siiɗadí me, wo Ziid ulo Zak. ");
INSERT INTO moz_vpl VALUES ("AC1_14","074_1_14","ACT","1","14","14","Kane pay onamaŋ kaŋ soo, daayum an tondiyo Raa ti erayi ɗoŋ oŋgo, ti Mariyam mekkʼIsa wo ti zemɓa kʼIsa pây. ");
INSERT INTO moz_vpl VALUES ("AC1_15","074_1_15","ACT","1","15","15","Adda kʼonniytagi geŋ, onniyo soo Piyer yʼa tʼiiziga a ɗaana zemɓa kane suma meeda uto ada sire an tʼugiye gen̰n̰o, wo yʼan di ruute, yʼede: ");
INSERT INTO moz_vpl VALUES ("AC1_16","074_1_16","ACT","1","16","17","«Zemɓa ki nuŋ, kun suune Ziidas yoŋ ti diine kine, wo naabadí ede ere yi naabiya aa kine in naabiya te. Kʼita maŋ yʼa tʼize wede kʼoogumso a ɗoŋ ki seeɗu kʼIsa. Ono geŋ Unde Kamilen̰ tiʼni ruute ti kaaga adda mattup ki Raa, ti bize Dawut a tukki Ziidas me, geŋ a-tʼiide. ");
INSERT INTO moz_vpl VALUES ("AC1_18","074_1_18","ACT","1","18","18","Iŋkino maŋ ti soŋko ere an i ele ki dimme gette, yʼa tʼiwila doome. Wo kaciŋ wede geŋ yʼa iire tʼaddí a siiɗo adda doome geŋ me, addí a ɓitte in̰n̰i kʼaddí a tʼuɗɗite pay ti paate. ");
INSERT INTO moz_vpl VALUES ("AC1_19","074_1_19","ACT","1","19","19","Rabila gette ɗoŋ siiɗo Zeruzalem pay an di-tʼilliga, wo geŋ iŋkino doome Ziidas yʼiwila geŋ an di yʼ waaku ti onamaŋ “Akil Damma”, i-kaza “doome an iwila ti puuzo wede.” ");
INSERT INTO moz_vpl VALUES ("AC1_20","074_1_20","ACT","1","20","20","Ono eŋ nebi Dawut yi riiŋe ti kaaga adda mattup ki Soom, yʼede: “Ɓoozí a kila bulgo, wenɗa a lekka umbo.” Wo yi riiŋe soŋ, yʼede: “Ume naabadí wenɗa doolo yʼa tʼamɓa.” ");
INSERT INTO moz_vpl VALUES ("AC1_21","074_1_21","ACT","1","21","22","Iŋkino maŋ i dehu wedusu yʼa-tʼette ti kine, yʼa tʼise wede kazita ki rabila ki balɗiya Galmeega Isa. Wedusu geŋ yʼaase ti diine kane ɗoŋ izire ti kine onniyo ti onniyo aame Galmeega Isa yʼizire adda siiɗo ti kine, tʼume Zaŋ yi ti yʼ zuyye batem bini onniyo ere Raa yʼa yʼumɓe ti diine kine, yʼa iŋgile kʼawwa ki kandaane.» ");
INSERT INTO moz_vpl VALUES ("AC1_23","074_1_23","ACT","1","23","23","Aame geŋ an di biire ɗoŋ sire, Yusup wede Barsabas sundí soo Zistus, kane ti Matiyas. ");
INSERT INTO moz_vpl VALUES ("AC1_24","074_1_24","ACT","1","24","24","Iŋkino maŋ an tunde Raa, anʼde: «Galmeega, kee ki suune adde ɗuwo pay, iŋkino ki beero soo ti diine ɗoŋ sire en̰n̰o, ");
INSERT INTO moz_vpl VALUES ("AC1_25","074_1_25","ACT","1","25","25","kono yʼa tʼamɓe naabo ɗoŋ zina kʼIsa a olɗe ki Ziidas, kono yo Ziidas geŋ ume naabadí yi iili, yi tʼiide kʼume wede aa addí i dehu i-dʼîide untadí.» ");
INSERT INTO moz_vpl VALUES ("AC1_26","074_1_26","ACT","1","26","26","Iŋkino maŋ an tʼize teltel muntelliyo, maŋ i-tʼiire a Matiyas, geŋ yoŋ yʼa di giƴƴe ti kane ɗoŋ zina ɗoŋ koomat makumu soo gen̰n̰o. ");
INSERT INTO moz_vpl VALUES ("AC2_1","074_2_1","ACT","2","1","1","Aame onniyo tarnaape ki Pantekot tʼiina toŋ maŋ, kane ɗoŋ i ziipe addaŋ a Isa geŋ pay an lekkiyo umayaŋ soo. ");
INSERT INTO moz_vpl VALUES ("AC2_2","074_2_2","ACT","2","2","2","A kaamiki an ollige maŋ tarkuuse aa ki maaye ɓaadaŋ i-ɗeegu ti kandaane, iideʼŋ i-tʼûune adda ɓoy wede kane adda gen̰n̰o. ");
INSERT INTO moz_vpl VALUES ("AC2_3","074_2_3","ACT","2","3","3","Aame geŋ an wolliyo munɗa aa ilze kʼuwwo iide a tʼîhinte, wede soŋ i di ziipe tuddí tuddí. ");
INSERT INTO moz_vpl VALUES ("AC2_4","074_2_4","ACT","2","4","4","Kane pay addaŋ a ûune tʼUnde Kamilen̰, iŋkino an dʼiise orbe tʼono ɗoŋ doolo, wede tuuku toŋ yi dʼorbe tʼono ɗoŋ aa Unde Raa ti ele ele. ");
INSERT INTO moz_vpl VALUES ("AC2_5","074_2_5","ACT","2","5","5","Wo aame geŋ a Zeruzalem i dʼede Yawudiyagi ɗoŋ i seeɗu urzi Raazaŋ zakiɗi, an iido ti siiɗiyagi ɗoŋ adda duniya pay. ");
INSERT INTO moz_vpl VALUES ("AC2_6","074_2_6","ACT","2","6","6","A onamaŋ ɗoŋ geŋ kane ɗoŋ duuru an dʼukke, an iide, an ziiɗa giggiraŋ kono wede tuuku toŋ yi dʼollige ono tʼonamí tʼonamí. ");
INSERT INTO moz_vpl VALUES ("AC2_7","074_2_7","ACT","2","7","7","Wo kane ɗoŋ duuru an di roote munɗa an ki suune ye, an di wolliyo ɓeesel, wo anʼde: «Kane ɗoŋ i rootiso eŋ, kane pay miŋ ti siiɗo Galile ye ko? ");
INSERT INTO moz_vpl VALUES ("AC2_8","074_2_8","ACT","2","8","8","Ɗe mummino kane ɗuwo eŋ wede tuuku toŋ yi dʼorbe ti ono kine me? ");
INSERT INTO moz_vpl VALUES ("AC2_9","074_2_9","ACT","2","9","9","Kine ɗoŋ iido ti siiɗiyagi ɗoŋ ki Partiya, ki Meediya, ki Elam, ki Mezapotami, ki Ziide, ki Kapados, ki Pontus, ki Aazi, ");
INSERT INTO moz_vpl VALUES ("AC2_10","074_2_10","ACT","2","10","10","ki Pirizi, ki Pampili, ki Misir, ki Sireŋ adda siiɗo Libi, ɗoŋ soŋ an iido ti Room, ");
INSERT INTO moz_vpl VALUES ("AC2_11","074_2_11","ACT","2","11","11","ti siiɗo Kiret, wo ti siiɗo kʼArabi. Ɗoŋ soŋ Yawudiyagi, ɗoŋ oŋgo Yawudiyagi ye an ti tʼize tuddaŋ Yawudiyagi pay miŋ, kane ay diʼn ollige an dʼorbe tʼonamey tʼonamey me. Ɗe geŋ munɗa kʼarmika Raa ye ko?» ");
INSERT INTO moz_vpl VALUES ("AC2_12","074_2_12","ACT","2","12","12","Kane pay eedaŋ tʼa digge, an di roote munɗa an ki suune ye, an di rootiyo ti tuddaŋ, anʼde: «Ɗe geŋ i-kaza moo me?» ");
INSERT INTO moz_vpl VALUES ("AC2_13","074_2_13","ACT","2","13","13","Wo oŋgoŋ an diʼn okko maade, anʼde: «Kane eŋ an tʼiiɓo toote.» ");
INSERT INTO moz_vpl VALUES ("AC2_14","074_2_14","ACT","2","14","14","Iŋkino maŋ Piyer ti kane ɗoŋ zina ɗoŋ koomat makumu soo geŋ an tʼiiziga, wo yʼa ruute ti golla awwa, yʼede: «Kune pay Yawudiyagi wo kune ɗoŋ pay iido ki Zeruzalem, kun tʼohinto kuwwaguŋ a ono ɗoŋ ni roota, kono kun di suune munɗa wede ize. ");
INSERT INTO moz_vpl VALUES ("AC2_15","074_2_15","ACT","2","15","15","Kunʼde ɗoŋ eŋ an tʼiiɓo, maŋ an ki tʼiiɓo ye, ume ti soohe ɓotto. ");
INSERT INTO moz_vpl VALUES ("AC2_16","074_2_16","ACT","2","16","17","Wo aŋkeŋ ono ɗoŋ Raa yi ruute ti kaaga ti bize nebi Zowel a-tʼiide, yʼede: “A onniytagi ɗoŋ ettiyo kʼita geŋ, Undó nʼa ti teepa ekki ɗuwo pay. In̰n̰iguŋ kuuli erayi an di rootita ono ɗoŋ nʼagisa. In̰n̰i obilagi ti konazi an dʼetta munɗa aa suniye, wo gôlɗalguŋ an tʼoona suniye. ");
INSERT INTO moz_vpl VALUES ("AC2_18","074_2_18","ACT","2","18","18","Eyye, ki kotto onniytagi geŋ, a ɗoŋ naabadó kuuli erayi pây, nʼan di teepa Undó wo an di rootita ono ɗoŋ nʼagisa. ");
INSERT INTO moz_vpl VALUES ("AC2_19","074_2_19","ACT","2","19","19","Nʼaasa sulɗi ɗoŋ i ceeriyo eego awwa a kandaane, wo a ɗanɗi a siiɗo sulɗi ɗoŋ i-kaza munɗa, an di wolla puuzo, uwwo wo dondari ki saa. ");
INSERT INTO moz_vpl VALUES ("AC2_20","074_2_20","ACT","2","20","20","Peeɗo ti-tʼetta ume a tʼisa zimolo, tere a tʼisa aa puuzo. Aame sulɗi geŋ an tʼiŋgila maŋ, onniyo Galmeega Raa tʼa aana, onniyo ere meeda ki darƴika Raa gette. ");
INSERT INTO moz_vpl VALUES ("AC2_21","074_2_21","ACT","2","21","21","Wo aame geŋ wede tuuku yʼiila ti suma Galmeega Raa maŋ, yoŋ yʼa yʼutta.”» ");
INSERT INTO moz_vpl VALUES ("AC2_22","074_2_22","ACT","2","22","22","Piyer yʼan di ruute sey, yʼede: «Kune ɗoŋ kʼIzirayel no, kun ollo munɗa wede nʼun di roote: Isa wede ti geeger Nazaret geŋ, tʼurzi yode Raa yʼa ize sulɗi kʼarmika wo sulɗi ɗoŋ i ceeriyo eego a diinaguŋ, wo kune batum kunʼni suune. Iŋkino maŋ Raa yʼun gize keren̰ i yʼigibo yode. ");
INSERT INTO moz_vpl VALUES ("AC2_23","074_2_23","ACT","2","23","23","Yode wede geŋ un yʼele a beyguŋ Raa batum aa yoŋ yi dihe, wo aa munɗa wede yʼilke ti poone yʼaasa. Iŋkino maŋ kun an di yʼele a bey ɗoŋ i ki suune Raa ye, an ti yʼ tiike ekkʼundumu wede zaapu tʼekki bakadí kaŋ tontilko, an di yʼîide. ");
INSERT INTO moz_vpl VALUES ("AC2_24","074_2_24","ACT","2","24","24","Wo ɗe Raa yʼa ti yʼ bilɗe, yʼa yʼuɗɗe ti dabar ere kʼunto te, kono unto i-kʼede toogo ye a tukkʼIsa me. ");
INSERT INTO moz_vpl VALUES ("AC2_25","074_2_25","ACT","2","25","25","Dawut toŋ yi ruute ti kaaga a tukki yoŋ me, yʼede: “Yo Galmeega daayum ni yi wolliyo ɗaanadó, nʼa kʼorgiɗe ye kono yoŋ daayum a sirpadó. ");
INSERT INTO moz_vpl VALUES ("AC2_26","074_2_26","ACT","2","26","26","Kono kamo nuŋ ulbó uŋse, wo ilzó yʼa tʼimme tʼuŋsuwo, wo ni zaapu elkisadó aame nʼinda toŋ, nuŋ Raa yi ti nʼ balɗa. ");
INSERT INTO moz_vpl VALUES ("AC2_27","074_2_27","ACT","2","27","27","Nuŋ ni suune kee Galmeegó ki ki nʼoola adda diine ɗoŋ unto ye, ki kʼoola tudde ki wedizá kamilen̰ a ki ruuma adda muuzo ye. ");
INSERT INTO moz_vpl VALUES ("AC2_28","074_2_28","ACT","2","28","28","Kee urziyagi ɗoŋ o-do tʼettey kʼume lekkiyo kʼo ni gize, ulbó uŋse kono kee daayum ti nuŋ.”» ");
INSERT INTO moz_vpl VALUES ("AC2_29","074_2_29","ACT","2","29","29","Piyer yʼan di ruute sey, yʼede: «Kun ollo zemɓa ki nuŋ, nuŋ oo dʼede urzi nʼun di rooto keren̰ a urzi ki mugiyiŋ Dawut me. Yoŋ yʼinda, an di yʼele adda muuzo, wo muuzadí toŋ maŋ aŋken̰n̰o todʼte di kine. ");
INSERT INTO moz_vpl VALUES ("AC2_30","074_2_30","ACT","2","30","30","Yo Dawut geŋ yoŋ nebi, wo yi suune Raa geŋ yʼa ti nîime tuddí a ɗaana yode, yʼa ruute, yʼede: “Mozikadá gette ni di tʼela a ulo ti diine kʼin̰n̰i ɗoŋ ki biza bumɓizá.” ");
INSERT INTO moz_vpl VALUES ("AC2_31","074_2_31","ACT","2","31","31","Dawut geŋ yi zuune ki poone Almasi Raa yi biire yi balɗa me, geŋ yʼa ruute, yʼede: “Yoŋ an ki yʼiili adda diine ɗoŋ unto ye, wo tuddí i ki ruume adda muuzo ye.”» ");
INSERT INTO moz_vpl VALUES ("AC2_32","074_2_32","ACT","2","32","32","Piyer yʼa ruute sey, yʼede: «Wede nʼa ruute geŋ yoŋ Isa, kaye pay ay di yʼ wulle Raa yʼa ti yʼ bilɗe. ");
INSERT INTO moz_vpl VALUES ("AC2_33","074_2_33","ACT","2","33","33","Raa yʼa yʼumɓe kʼawwa ki kandaane yʼa lekkey a ammidadí, wo a Isa Meega Raa yi-dʼele Unde Kamilen̰ ere yi ruute yʼin di tʼela. Iŋkino maŋ yo Isa yʼin dʼelo Unde Kamilen̰ a kine aa kun wolliyo wo kun ollige aŋken̰n̰o. ");
INSERT INTO moz_vpl VALUES ("AC2_34","074_2_34","ACT","2","34","34","Wo yo Dawut geŋ yode batum kʼawwa ki kandaane yi ki gili ye, wo toŋ yʼa ruute, yʼede: “Galmeega Raa yi di ruute a Galmeegó, yʼede: Kʼedi ki-koona a ammidadó kino, ");
INSERT INTO moz_vpl VALUES ("AC2_35","074_2_35","ACT","2","35","35","bini ɗoŋ kʼaduzá nʼan isa aa munɗa ki bita ti ɗanɗi zoŋɗá.” ");
INSERT INTO moz_vpl VALUES ("AC2_36","074_2_36","ACT","2","36","36","Iŋkino maŋ kune ɗoŋ kʼIzirayel pay kun suuno ki kotto, Isa wede kun ti yʼ tiike ekkʼundumu wede zaapu tʼekki bakadí kaŋ tontilko geŋ, Raa yi yʼize Galmeega wo Almasi Raa yi biire.» ");
INSERT INTO moz_vpl VALUES ("AC2_37","074_2_37","ACT","2","37","37","Aame kane ɗuwo an illiga iŋkino maŋ addaŋ a iile wiic, wo an tunde Piyer ti ɗoŋ zina kʼIsa oŋgo, anʼde: «Ɗe ay dʼise mummino, zemɓa ki nuŋ?» ");
INSERT INTO moz_vpl VALUES ("AC2_38","074_2_38","ACT","2","38","38","Maŋ Piyer yʼan di ruute, yʼede: «Kun ti kama lekkiyaguŋ wo wede tuuku toŋ yi suyyo batem ti suma kʼIsa Almasi, kono kun tʼoona tambobino kʼolɗikaguŋ. Iŋkino maŋ Raa yʼun tʼela Unde Kamilen̰, ");
INSERT INTO moz_vpl VALUES ("AC2_39","074_2_39","ACT","2","39","39","kono ono ɗoŋ Raa yi ruute yʼaasa eŋ a kune, a in̰n̰iguŋ, wo a ɗoŋ dokki, a ɗoŋ pay ɗoŋ Galmeega Raaziŋ yiʼni waaka.» ");
INSERT INTO moz_vpl VALUES ("AC2_40","074_2_40","ACT","2","40","40","Piyer geŋ yʼan di ruutite ono ɓaadaŋ sey kono an tʼeele kooke, an dʼamɓe, wo yʼan di ruute, yʼede: «Kun tʼaɗɗo ti diine ɗoŋ i tʼuɗɗe tʼurzi wede ɗerec ki Raa geŋ me, wo kun tʼoona uttiyo.» ");
INSERT INTO moz_vpl VALUES ("AC2_41","074_2_41","ACT","2","41","41","Ɗoŋ umɓe a ono Piyer geŋ an tiʼn zuyye batem, wo a onniyo gette kane suma dupu aɗo an a-ti giƴƴe ti zemɓa ɗoŋ i ziipe addaŋ a Isa. ");
INSERT INTO moz_vpl VALUES ("AC2_42","074_2_42","ACT","2","42","42","Kane pay kaŋ soo an dʼollige dooyiso ere ɗoŋ zina kʼIsa anʼni dooyiso, an di lekkiyo kettiyo kaŋ soo, omɓadaŋ kaŋ soo, wo daayum an tondiyo Raa kaŋ soo. ");
INSERT INTO moz_vpl VALUES ("AC2_43","074_2_43","ACT","2","43","43","Kane ɗoŋ duuru pay an lekkiyo tʼorgiso a Raa, kono kane ɗoŋ zina geŋ ti toogo ere ki Raa an dʼisiyto sulɗi ɓaadaŋ ɗoŋ i ceeriyo eego ti sulɗi kʼarmika. ");
INSERT INTO moz_vpl VALUES ("AC2_44","074_2_44","ACT","2","44","44","Kane ɗoŋ pay i ziipe addaŋ a Isa, an lekkiyo kaŋ soo, maaladaŋ toŋ kaŋ soo. ");
INSERT INTO moz_vpl VALUES ("AC2_45","074_2_45","ACT","2","45","45","An owile doome koo ɓoy koo maŋ, soŋko gette an di-dokkiɗe diinayaŋ pay, a wede tuuku toŋ a attiɗizí attiɗizí. ");
INSERT INTO moz_vpl VALUES ("AC2_46","074_2_46","ACT","2","46","46","Kane pay addaŋ soo, onniyo ti onniyo an dʼettiyo booro Ɓoy Raa, omɓadaŋ kaŋ soo ti uŋsuwo wo ti tassuwa adda ɓoyɗizaŋ me. ");
INSERT INTO moz_vpl VALUES ("AC2_47","074_2_47","ACT","2","47","47","Daayum an tamma Raa wo a lekkiyadaŋ gette ɗuwo pay an diʼn geyyiso. Wo onniyo ti onniyo Galmeega yiʼn aagulu ti ɗuwo ɗoŋ an ooniyo urzi kʼuttiyo. ");
INSERT INTO moz_vpl VALUES ("AC3_1","074_3_1","ACT","3","1","1","Onniyo soo Piyer kane ti Zaŋ an tʼette tondiyo a booro Ɓoy Raa a peeɗo tʼibbira, peeɗo ere aa daayum an tondiyo Raa. ");
INSERT INTO moz_vpl VALUES ("AC3_2","074_3_2","ACT","3","2","2","Wo goppoŋ a sirpa ki biza Ɓoy Raa wede an yi waaku biza majjaane geŋ, an dʼumɓo wedusu zoŋɗí unto tʼume kʼehiyadí to, daayum an ti yʼ zaapu aŋgen̰n̰o, yi dʼahultu munɗa a bey ɗoŋ ettiyo ki booro Ɓoy Raa. ");
INSERT INTO moz_vpl VALUES ("AC3_3","074_3_3","ACT","3","3","3","Aame wede geŋ yi wulle Piyer kane ti Zaŋ anʼte booro Ɓoy Raa maŋ, yʼa iise ahulu munɗa a beezaŋ. ");
INSERT INTO moz_vpl VALUES ("AC3_4","074_3_4","ACT","3","4","4","Aame an illiga iŋkino maŋ, Piyer kane ti Zaŋ geŋ an di yʼ wolliyo teɓen̰, wo Piyer yʼede: «Kʼayni wolli!» ");
INSERT INTO moz_vpl VALUES ("AC3_5","074_3_5","ACT","3","5","5","Aame geŋ wede yʼan iise wolliyo, kono yʼelkiyo yi-tʼoona munɗa ti beezaŋ. ");
INSERT INTO moz_vpl VALUES ("AC3_6","074_3_6","ACT","3","6","6","Maŋ Piyer yi di ruute, yʼede: «Nuŋ o kʼede soŋko ye, dap ye, wo munɗa wede o dʼede nʼa-dʼelo, ti suma ere ki Isa Almasi wede ti geeger Nazaret, ki tʼoozo wo kʼa oziro.» ");
INSERT INTO moz_vpl VALUES ("AC3_7","074_3_7","ACT","3","7","7","Maŋ Piyer yʼa igibe beezí wede kʼammade, yʼa di yʼ ziiɗa, yʼa yʼiiziga kaŋ ôhire. A kaamiki wedeʼŋ ɗonɗali ti zoŋɗí a tʼize toogo. ");
INSERT INTO moz_vpl VALUES ("AC3_8","074_3_8","ACT","3","8","8","Wede geŋ yʼa ilɗe kʼawwa yʼa tʼîhira, wo yʼa iise sooru, yi-tʼiide ti kane kʼadda booro Ɓoy Raa, yi sooru, yi lohito, yi tamma Raa. ");
INSERT INTO moz_vpl VALUES ("AC3_9","074_3_9","ACT","3","9","9","Wo yoŋ wede geŋ ɗuwo pay an di yʼ wulle yi sooru wo yi tamma Raa. ");
INSERT INTO moz_vpl VALUES ("AC3_10","074_3_10","ACT","3","10","10","Aame ɗuwo geŋ an yi wulle wo an yi zuune yoŋ wede i konso daayum a biza Ɓoy Raa wede an yi waaku biza majjaane yi dʼahultu gen̰n̰o maŋ, an ziiɗa giggiraŋ ti orgiso a munɗa wede i iide a wede gen̰n̰o. ");
INSERT INTO moz_vpl VALUES ("AC3_11","074_3_11","ACT","3","11","11","Wo wede geŋ Piyer ti Zaŋ yʼan kʼeeziyo ye. Iŋkino maŋ ɗoŋ duuru pay an dʼiide kʼume kane kaŋ okko, kʼadda daabe wede an yi waaku daabe ki Salamoŋ, kono kane an ziiɗa giggiraŋ. ");
INSERT INTO moz_vpl VALUES ("AC3_12","074_3_12","ACT","3","12","12","Aame Piyer yi wulle ɗuwo iido tuddaŋ maŋ, yʼan di ruute yʼede: «Kune ɗoŋ kʼIzirayel no, kun seeɗu giggirguŋ moo me, kun ay diʼn wolliso iŋkino me? Kun elkiyo wede uune bee yi sooru eŋ ti toogo kaye ko kunuŋ, kun elkiyo kaye ki diine a urzi Raazey me ko? Aha, iŋkino ye. ");
INSERT INTO moz_vpl VALUES ("AC3_13","074_3_13","ACT","3","13","13","Raa kʼIbirayim, kʼIsaaka wo ki Yakup, yoŋ geŋ miŋ Raa moŋgiɗagiŋ, yi-dʼele gooliko a Isa wede naabadí. Yode wede kune batum kun an di yʼele a deero Romeŋ. Aame mozigo Pilat yi dihe yi-dʼeeze kono yo yi zuune yi kʼize munɗa ye toŋ, kune kun di giigira. ");
INSERT INTO moz_vpl VALUES ("AC3_14","074_3_14","ACT","3","14","14","Yode wede kamilen̰ wo ki diine a ɗaana Raa geŋ kun di yʼ giigira, wo kun di dihe kun i dʼize beeko a wede tôwwo ɗoŋ. ");
INSERT INTO moz_vpl VALUES ("AC3_15","074_3_15","ACT","3","15","15","Iŋkino maŋ wede i dʼeliyo lekkiyo a ɗuwo geŋ, kun an di yʼele a ɗuwo, an di yʼîide. Wo Raa yʼa ti yʼ bilɗe ti diine ɗoŋ unto me, kaye ay di yʼ wulle. ");
INSERT INTO moz_vpl VALUES ("AC3_16","074_3_16","ACT","3","16","16","Wo wede eŋ kun yi suune wo kun yi wolliyo, munɗa wede ize a ɗaanaguŋ. I ele beeko te toogo ere ki suma kʼIsa tʼurzi zaapu kʼadde a yode, yʼuune beeko pay ette tʼurzi zaapu kʼadde a Isa, aa kune pay kun wolliyo en̰n̰o. ");
INSERT INTO moz_vpl VALUES ("AC3_17","074_3_17","ACT","3","17","17","Wo aŋkeŋ zemɓa ki nuŋ, ni suune aame kune wo ti deeruguŋ pay Isa kun di yʼ giigira geŋ, munɗa wede kun isiyo kun ki yʼ suune ye. ");
INSERT INTO moz_vpl VALUES ("AC3_18","074_3_18","ACT","3","18","18","Geŋ iŋkino a-tʼiide a ono ɗoŋ Raa yi ruute ti kaaga ti bize nebiyagi pay, yʼede: “Almasi Raa yi biire, yʼa dabira.” ");
INSERT INTO moz_vpl VALUES ("AC3_19","074_3_19","ACT","3","19","19","Aŋkeŋ kun ti kama lekkiyaguŋ, kun ti kami ki tukki Raa kono yʼun di-booya olɗikaguŋ. ");
INSERT INTO moz_vpl VALUES ("AC3_20","074_3_20","ACT","3","20","20","Iŋkino maŋ Galmeega Raa yʼun tʼela puukiyo, wo yʼun ti yʼ tʼigibo Almasi Raa yi biire a kune, yoŋ Isa. ");
INSERT INTO moz_vpl VALUES ("AC3_21","074_3_21","ACT","3","21","21","Wo aŋken̰n̰o Almasi yʼa-lekko a kandaane bini onniyo ere sulɗi pay a tʼisa aware, aa Raa yʼa ruute ti kaaga ti bize nebiyagí ɗoŋ kamilen̰. ");
INSERT INTO moz_vpl VALUES ("AC3_22","074_3_22","ACT","3","22","22","Muusa yʼa ruute ti kaaga, yʼede: “Galmeega Raaguŋ yʼun dʼooɗiba nebi aa nuuno ti diine zemɓaguŋ, wo kune kun dʼolliga sulɗi ɗoŋ pay yʼun rootita geŋ me.” ");
INSERT INTO moz_vpl VALUES ("AC3_23","074_3_23","ACT","3","23","23","Wo soŋ yʼede, aame wede tuuku yi-tuuga kʼollige kʼono nebi gen̰n̰o maŋ, yʼa dagga, yode geŋ yi kʼisa ti diine ɗoŋ Raa ye. ");
INSERT INTO moz_vpl VALUES ("AC3_24","074_3_24","ACT","3","24","24","Wo nebiyagi pay iise ti Samiyel a iide soŋ kʼita bakadí bakadí geŋ, an ruutite wo an gizite a sulɗi ɗoŋ isiyo a onniytagi ɗoŋ aŋken̰n̰o geŋ me. ");
INSERT INTO moz_vpl VALUES ("AC3_25","074_3_25","ACT","3","25","25","Zemɓa ki nuŋ, ono ɗoŋ nebiyagi an ruutite pay geŋ a kune, wo taasuwa ere Raa yi gitte ti moŋgiɗagiŋ gette kune adda, aame yi ruute a Ibirayim, yʼede: “Ita ɗuwo pay a siiɗo an tʼoona beeko tʼurzi kʼin̰n̰izá.” ");
INSERT INTO moz_vpl VALUES ("AC3_26","074_3_26","ACT","3","26","26","Geŋ ki poone a kune Raa yʼigibo wede naabadí me, kono yʼun di zaape beeko wo tuuku toŋ yʼa ti yʼ kimo ti naabadí ere olɗo gette.» ");
INSERT INTO moz_vpl VALUES ("AC4_1","074_4_1","ACT","4","1","1","Aame Piyer ti Zaŋ an an ti rootiyto a ɗoŋ duuru geŋ, kane ɗoŋ seɗeke, goole ɗoŋ boohiyo Ɓoy Raa ti Saduseyeŋ miibi an dʼiina aame kane. ");
INSERT INTO moz_vpl VALUES ("AC4_2","074_4_2","ACT","4","2","2","Kane an di-gulkuwe ɓaadaŋ aame an wulle ɗoŋ zina sire an dooyiso ɗoŋ duuru wo an an kazita, anʼde Isa yi-bilɗe, wo ɗoŋ i tʼinda toŋ an di balɗa kay. ");
INSERT INTO moz_vpl VALUES ("AC4_3","074_4_3","ACT","4","3","3","Iŋkino maŋ Piyer ti Zaŋ an tiʼn ziɗɗe, an diʼn iɓi daŋgay bini ki soggo, kono peeɗo tʼiŋgile baa. ");
INSERT INTO moz_vpl VALUES ("AC4_4","074_4_4","ACT","4","4","4","Aame geŋ ti diine ɗoŋ illiga ono ki Piyer ti Zaŋ geŋ, ɗoŋ ɓaadaŋ an dʼumɓe, wo ti ɗoŋ i ziipe addaŋ a Isa an aa di giƴƴe, kane ɗuwo ette suma dupu paat. ");
INSERT INTO moz_vpl VALUES ("AC4_5","074_4_5","ACT","4","5","5","Soggo maŋ kane deero ɗoŋ seɗeke, ɗoŋ i dokkiyo Yawudiyagi wo ɗoŋ suuniyo kʼoogoro an tʼugiye pay a geeger ki Zeruzalem. ");
INSERT INTO moz_vpl VALUES ("AC4_6","074_4_6","ACT","4","6","6","A ogiysadaŋ gette i dʼede kane Annemozigo goole ɗoŋ seɗeke ti ɗoŋ ɓoozí pay, Kayip, Zaŋ wo Alegzandire. ");
INSERT INTO moz_vpl VALUES ("AC4_7","074_4_7","ACT","4","7","7","Piyer ti Zaŋ tʼadda daŋgay an diʼn uɗɗo, an dʼan tʼiide diinayaŋ wo an diʼn tunde, anʼde: «Wede eŋ kun i ele beeko ti toogo ere tuuku te, wo ti suma kʼaaye?» ");
INSERT INTO moz_vpl VALUES ("AC4_8","074_4_8","ACT","4","8","8","Aame geŋ Piyer yoŋ addiŋ ûune ti Unde Kamilen̰ wo yʼan di ruute, yʼede: ");
INSERT INTO moz_vpl VALUES ("AC4_9","074_4_9","ACT","4","9","9","«Kune deero ɗoŋ seɗeke wo ɗoŋ i dokkiyo ɗoŋziŋ, aŋki kun ayni wiiko ki ɗaanaguŋ eŋ, kun dehu kun ɗekke booro a eedey kono ay ize beehiye a wede zoŋɗí unto, wo soŋ kun dehu kun di suune tʼurzi mummino yʼutte tʼeenizí me. ");
INSERT INTO moz_vpl VALUES ("AC4_10","074_4_10","ACT","4","10","10","Iŋkino maŋ kune deero siiɗo ti ɗoŋ kʼIzirayel pay, munɗa eŋ kun yi suuno koɗuwo: wede kun wolliyo yi tʼîhira a ɗaanaguŋ eŋ, yʼuune bee ti toogo ki suma ere kʼIsa Almasi wede ti geeger Nazaret, yode wede kun ti yʼ tiike ekkʼundumu wede zaapu tʼekki bakadí kaŋ tontilko, wo Raa yʼa ti yʼ bilɗe ti diine ɗoŋ unto me. ");
INSERT INTO moz_vpl VALUES ("AC4_11","074_4_11","ACT","4","11","11","Aakede an riiŋe ti kaaga adda mattup ki Raa, Isa yoŋ aa mokkolo ere kune ɗoŋ kʼoozige ɓoy kun di ziɗɗe mentú, tode gettiyo a tʼize mokkolo ere majjaanawa a jiire kʼoozige ɓoy te. ");
INSERT INTO moz_vpl VALUES ("AC4_12","074_4_12","ACT","4","12","12","Iŋkino maŋ nʼun di rooto Isa ɗaŋŋal urzi kʼuttiyo me, kono adda duniya pay ette Raa yi kʼeele ye suma ti doolo in diʼn utta kine ɗuwo me.» ");
INSERT INTO moz_vpl VALUES ("AC4_13","074_4_13","ACT","4","13","13","Aame geŋ kane deero an wulle Piyer ti Zaŋ an rootiyo onamaŋ daa kʼorgiso maŋ, an ziiɗa giggiraŋ kono kane ɗoŋ i ki duuye tunɗa ye, kane miŋ ɗoŋ kino baa. Wo kane deero geŋ an suune an izire tʼIsa me. ");
INSERT INTO moz_vpl VALUES ("AC4_14","074_4_14","ACT","4","14","14","Wo aakede an wolliyo wede uune bee a sirpadaŋ geŋ, urzi an an di roote munɗa a kane umbo. ");
INSERT INTO moz_vpl VALUES ("AC4_15","074_4_15","ACT","4","15","15","Iŋkino maŋ an an dʼele urzi an tʼaɗɗe tʼadda ɓoy me. Aame kane an tʼuɗɗe maŋ, kane deero booro Yawudiyagi an di-ruute diinayaŋ, ");
INSERT INTO moz_vpl VALUES ("AC4_16","074_4_16","ACT","4","16","16","anʼde: «A ɗoŋ eŋ in an dʼisa mummino me? Ɗerec, Piyer ti Zaŋ an ize munɗa kʼarmika geŋ, ɗoŋ Zeruzalem pay an yʼilliga, kine in kʼaane in ki niike ye. ");
INSERT INTO moz_vpl VALUES ("AC4_17","074_4_17","ACT","4","17","17","Wo kono rabila gette a ki teepa a ɗuwo pay ye geŋ, in an ondirɗo ki kossiyadaŋ, kono suma kʼIsa piɗipiɗin̰ an ki roota ye baa a wede tuuku toŋ maŋ.» ");
INSERT INTO moz_vpl VALUES ("AC4_18","074_4_18","ACT","4","18","18","Saŋ maŋ Piyer ti Zaŋ an diʼn wiike, wo an an di ruute, anʼde: «Ti aŋki kun ôhor, suma kʼIsa kun kizita ye, wo kun dooya wenɗa ye baa.» ");
INSERT INTO moz_vpl VALUES ("AC4_19","074_4_19","ACT","4","19","19","Maŋ Piyer ti Zaŋ an an diʼn gime onamaŋ, anʼde: «A suuno kune batum munɗa wede ki diine a ɗaana Raa me, ay dʼamɓe ono kune kunuŋ, ono Raa ko? ");
INSERT INTO moz_vpl VALUES ("AC4_20","074_4_20","ACT","4","20","20","Ki kaye maŋ ay kʼanniga ye ti rootiyto a munɗa wede ay wulle wo ay illiga me.» ");
INSERT INTO moz_vpl VALUES ("AC4_21","074_4_21","ACT","4","21","21","Maŋ kane deero geŋ an an dʼundirɗe ki kossiyadaŋ sey, wo an an dʼiize. An an dʼise ulsu an kʼuune ye, kono ɗuwo pay geŋ an tamma Raa a munɗa ize geŋ me. ");
INSERT INTO moz_vpl VALUES ("AC4_22","074_4_22","ACT","4","22","22","Yoŋ wede uune beeko tʼurzi munɗa kʼarmika geŋ, ozzinayí ette suma kʼada piɗe ti makumu. ");
INSERT INTO moz_vpl VALUES ("AC4_23","074_4_23","ACT","4","23","23","Aame Piyer ti Zaŋ ti daŋgay an an iize maŋ, an dʼiŋgile an dʼuuney zemɓadaŋ, an an tʼîide taaya pay a munɗa wede deero ɗoŋ seɗeke ti ɗoŋ i dokkiyo Yawudiyagi an an ruutite me. ");
INSERT INTO moz_vpl VALUES ("AC4_24","074_4_24","ACT","4","24","24","Aame ɗoŋ i ziipe addaŋ a Isa geŋ an illiga ono ki Piyer ti Zaŋ gen̰n̰o maŋ, pay onamaŋ kaŋ soo an tunde Raa, anʼde: «Galmeegey, kee wede kʼikkima kandaane ti siiɗo wo bar, ti sulɗi ɗoŋ pay adda. ");
INSERT INTO moz_vpl VALUES ("AC4_25","074_4_25","ACT","4","25","25","Kee wede ki ele Unde Kamilen̰ a Dawut wede naabadá, Unde gette ti di gize, yʼa ruute, yʼede: “Ki moo me ɗoŋ siiɗiyagi pay an ahutu bokimo me? Ki moo me ita ɗuwo pay an tôwwo onamaŋ ki bita me? ");
INSERT INTO moz_vpl VALUES ("AC4_26","074_4_26","ACT","4","26","26","Kane mozagi a siiɗo pay an tʼikkima tuddaŋ ki arka, wo deero boha bumɓiyagi an tʼugiye ki ɗeyyiso ki Galmeega Raa wo ti Almasi Raa yi biire.” ");
INSERT INTO moz_vpl VALUES ("AC4_27","074_4_27","ACT","4","27","27","Eyye, ono geŋ ɗerec, Erod ti Pons Pilat an tʼukkiƴe a geeger ettiyo, ti kane ɗoŋ Yawudiyagi ti ɗoŋ Yawudiyagi ye, an di kiigira wede naabadá, Isa wede kamilen̰ ki biire. ");
INSERT INTO moz_vpl VALUES ("AC4_28","074_4_28","ACT","4","28","28","Iŋkino maŋ munɗa wede ki dihe ti poone geŋ, an tʼize pay tʼurzi toogadá, aa kee ki dihe. ");
INSERT INTO moz_vpl VALUES ("AC4_29","074_4_29","ACT","4","29","29","Wo aŋkeŋ Galmeega, kee ki wollo an ay ondirso ki kossiyadey, kaye ɗoŋ naabadá kee kʼay eli toogadá ay di kizite onamá daa kʼorgiso. ");
INSERT INTO moz_vpl VALUES ("AC4_30","074_4_30","ACT","4","30","30","Kʼay eli toogadá kono ay an tʼele beeko a ɗuwo, wo ay dʼise sulɗi kʼarmika ti sulɗi ɗoŋ i ceeriyo eego ti suma wede naabadá, Isa wede kamilen̰.» ");
INSERT INTO moz_vpl VALUES ("AC4_31","074_4_31","ACT","4","31","31","Aame kane an ɗiŋge ti tondiyo Raa maŋ, ume wede an dʼugiye ki tondiyo geŋ yʼa iise ŋoŋŋirso. Wo Raa yi diʼn ûune tʼUnde Kamilen̰ pay, maŋ an dʼiise kazita kʼono Raa daa kʼorgiso. ");
INSERT INTO moz_vpl VALUES ("AC4_32","074_4_32","ACT","4","32","32","Ɗoŋ i ziipe addaŋ a Isa pay geŋ elkisadaŋ kaŋ soo, ti diinayaŋ wenɗa soo toŋ yʼa roote eŋ ki nuuno umbo, pay maaladaŋ an tʼoɓe ume soo. ");
INSERT INTO moz_vpl VALUES ("AC4_33","074_4_33","ACT","4","33","33","Kane ɗoŋ zina kʼIsa an kazita ti toogo ɓaadaŋ rabila kʼIsa te, an dʼeesiyo: «Yoŋ Galmeega Isa yi-bilɗe, kaye ay yi wulle.» Wo kane pay geŋ Raa yʼan di ziipe beeko ɓaadaŋ. ");
INSERT INTO moz_vpl VALUES ("AC4_34","074_4_34","ACT","4","34","34","Ti diinayaŋ wenɗa soo toŋ munɗa i-baate umbo. Ɗoŋ an dʼede domɓi ise ɓoyɗi toŋ an owile maŋ, soŋko gette an dʼettiyo, ");
INSERT INTO moz_vpl VALUES ("AC4_35","074_4_35","ACT","4","35","35","wo an an dʼeliyo a bey ɗoŋ zina kʼIsa, maŋ kane geŋ an an di-dokkiɗe, soŋko gette a wede tuuku toŋ a attiɗizí attiɗizí. ");
INSERT INTO moz_vpl VALUES ("AC4_36","074_4_36","ACT","4","36","36","Ti diine ɗoŋ geŋ i dʼede wede sundí Yusup yoŋ ti biza bumɓu Lebi, wo kane ɗoŋ zina kʼIsa an di yʼ waaku Barnabas suma gette i-kaza «wede kʼeliyo kooke», yoŋ an yʼehe a siiɗo Siipire. ");
INSERT INTO moz_vpl VALUES ("AC4_37","074_4_37","ACT","4","37","37","Yoŋ wede geŋ i-dʼede doome wo yʼa tʼiwila, yʼa tʼumɓo soŋko yʼan dʼiido, yʼan dʼele a bey ɗoŋ zina kʼIsa. ");
INSERT INTO moz_vpl VALUES ("AC5_1","074_5_1","ACT","5","1","1","Wo i dʼede wedusu sundí Ananiyas ti eddí Sapira, doomizaŋ an tʼiwila. ");
INSERT INTO moz_vpl VALUES ("AC5_2","074_5_2","ACT","5","2","2","Kane geŋ an ti gitte onamaŋ kaŋ soo, soŋko yʼa-diikiɗa sire, ere soo a yode wo soo yʼa tʼumɓe, yʼan dʼiide yʼan dʼeliyo a bey ɗoŋ zina kʼIsa. ");
INSERT INTO moz_vpl VALUES ("AC5_3","074_5_3","ACT","5","3","3","Maŋ Piyer yi di ruute, yʼede: «Ki moo me Ananiyas ki-dʼiili addá a Meeda siitanɗani ti-tʼiide me, wo ki moo me ki lohito ono a Unde Kamilen̰, kʼa tʼuuyo soŋko doomizá soo a kee me? ");
INSERT INTO moz_vpl VALUES ("AC5_4","074_5_4","ACT","5","4","4","Wo doome doomizá, aame ki ki tʼowila ye wo ki tʼiwila toŋ maŋ, soŋko gette kʼa ti naabe aa addá i dehu. Wo ɗe ki moo me ki dʼisiyo iŋkino me? Naabadá kʼize gette a ɗuwo ye, kʼize ulsu a Raa.» ");
INSERT INTO moz_vpl VALUES ("AC5_5","074_5_5","ACT","5","5","5","Aame Ananiyas yʼilliga ono gen̰n̰o maŋ, yʼa iiɗiba, yʼa iire tul, yʼa inda. Wo kane ɗoŋ pay illiga geŋ orgiso tʼanni ziiɗa ɓaadaŋ. ");
INSERT INTO moz_vpl VALUES ("AC5_6","074_5_6","ACT","5","6","6","Iŋkino maŋ obilagi an tʼiiziga, an di n̰ilpe, an iide, an tʼelo adda muuzo. ");
INSERT INTO moz_vpl VALUES ("AC5_7","074_5_7","ACT","5","7","7","Saŋ an likke bini maŋ, eddí ti-tʼuɗɗo daa suuniyo munɗa wede ize. ");
INSERT INTO moz_vpl VALUES ("AC5_8","074_5_8","ACT","5","8","8","Aame tʼiina maŋ, Piyer yʼa ti tunde, yʼede: «Mʼo ki ti rooti ɗo, ettiŋ soŋko ere pay kun iwila doomuguŋ ko?» Maŋ todʼ tʼa ruute, tʼede: «Eyye, ettiŋ soŋko tode.» ");
INSERT INTO moz_vpl VALUES ("AC5_9","074_5_9","ACT","5","9","9","Iŋkino maŋ Piyer yi di ruute, yʼede: «Mummino me koŋ ti kulayí kun di-gitte onamguŋ kaŋ soo, kun di naame Unde Galmeega me? Mʼollo, ɗoŋ iide ottibe kulayí an ti gimo kane a biza bumɓu gen̰n̰o, an ki tiʼn amɓa an tʼottibo kay.» ");
INSERT INTO moz_vpl VALUES ("AC5_10","074_5_10","ACT","5","10","10","A kaamiki tʼa iiɗiba, tʼa iire a zoŋ ki Piyer, tʼa inda. Aame obilagi an ti gimo ti ottibe ki kulatú maŋ, an tʼuuna tʼinda. An tʼumɓe, an a-tʼittibo a sirpa kulatú. ");
INSERT INTO moz_vpl VALUES ("AC5_11","074_5_11","ACT","5","11","11","A armika gette ɗoŋ pay ogiyso ti suma kʼIsa wo ɗoŋ pay illiga toŋ maŋ, orgiso tʼanni ziiɗa ɓaadaŋ. ");
INSERT INTO moz_vpl VALUES ("AC5_12","074_5_12","ACT","5","12","12","Ɗoŋ zina kʼIsa an dʼizite sulɗi kʼarmika ti sulɗi ɗoŋ i ceeriyo eego ɓaadaŋ a diine ɗoŋ duuru me. Kane ɗoŋ i ziipe addaŋ a Isa geŋ pay kaŋ soo, an tʼogiyso adda daabe goole wede an yi waaku daabe Salamoŋ. ");
INSERT INTO moz_vpl VALUES ("AC5_13","074_5_13","ACT","5","13","13","Kane ɗoŋ i ki ziipe addaŋ a Isa ye geŋ, wenɗa ti doolo a roote taaya keƴƴiso ti kane umbo. Wo toŋ kane ɗoŋ duuru geŋ an diʼn tamma ɓaadaŋ. ");
INSERT INTO moz_vpl VALUES ("AC5_14","074_5_14","ACT","5","14","14","Wo onniyo ti onniyo ɗoŋ ɓaadaŋ erayi kuuli an dʼaagulu kʼaagulu, an di zaapu addaŋ a Galmeega, an a-ti keƴƴiso ti kane. ");
INSERT INTO moz_vpl VALUES ("AC5_15","074_5_15","ACT","5","15","15","Ti sulɗi kʼarmika ɗoŋ an isiyto geŋ, ɗoŋ kʼeeni an tiʼn sokiyto biza kʼurzi ti zaaɗagi, oŋgoŋ a raŋgayi, kono aame Piyer yʼuɗɗa wo undisadí ti butta tuuku ti diinayaŋ maŋ, yʼa tʼoona bee. ");
INSERT INTO moz_vpl VALUES ("AC5_16","074_5_16","ACT","5","16","16","Ti geegiryagi sun̰n̰i ɗoŋ goppoŋ ti Zeruzalem toŋ, ɗoŋ ɓaadaŋ an di zikito ɗoŋ kʼeeni, oŋgoŋ siitanɗani an tiʼn ukkite maadagi, wo kane pay geŋ an dʼuune bee. ");
INSERT INTO moz_vpl VALUES ("AC5_17","074_5_17","ACT","5","17","17","Iŋkino maŋ mozigo goole ɗoŋ seɗeke ti ɗoŋ itadí, kane geŋ ti diine deero siiɗo anʼni waaku soŋ Saduseyeŋ, kolɓiso tʼa jiire eedaŋ, an dehu ɗoŋ zina kʼIsa an diʼn dabire. ");
INSERT INTO moz_vpl VALUES ("AC5_18","074_5_18","ACT","5","18","18","Aame geŋ an tiʼn ziɗɗe, an diʼn iɓi daŋgay a ɗaana ki ɗoŋ pay. ");
INSERT INTO moz_vpl VALUES ("AC5_19","074_5_19","ACT","5","19","19","Wo a diɗɗo kotto maŋ, Galmeega Raa yi dʼigibe maaleeka yʼa tʼihinte boha daŋgay me, ɗoŋ zina kʼIsa yʼan uɗɗe wo yʼan di ruute, yʼede: ");
INSERT INTO moz_vpl VALUES ("AC5_20","074_5_20","ACT","5","20","20","«Kun eŋgilo kʼadda booro Ɓoy Raa, kun an kazitoy a ɗuwo taaya ki sulɗi pay i dʼeliyo lekkiyo ere aware gettiyo.» ");
INSERT INTO moz_vpl VALUES ("AC5_21","074_5_21","ACT","5","21","21","Iŋkino maŋ onamí an dʼilliga, soggo ti soohe walak an dʼiŋgile kʼadda booro Ɓoy Raa, an dʼiise dooyiso ɗuwo. Wo yo mozigo goole ɗoŋ seɗeke ti ɗoŋ kʼitadí, an di wiiko deero booro Yawudiyagi an tʼugiye, kane ɗoŋ wolliyo kʼono kʼadda siiɗo kʼIzirayel. Maŋ an dʼigibe ɗoŋ i boohiyo Ɓoy Raa an di waaku ɗoŋ zina kʼIsa adda daŋgay. ");
INSERT INTO moz_vpl VALUES ("AC5_22","074_5_22","ACT","5","22","22","Wo aame ɗoŋ an igibe an iide maŋ, ɗoŋ zina kʼIsa umbo adda daŋgay me. Maŋ an di-gimo kʼume ɗoŋ iʼn igibe, an an tʼîide taaya a munɗa wede kane an wullo, ");
INSERT INTO moz_vpl VALUES ("AC5_23","074_5_23","ACT","5","23","23","anʼde: «Kaye ay iide, ay uuney boha daŋgay appiyta ɓeɓerec, wo ɗoŋ boohiyo toŋ kane ede. Wo aame an ay tʼihinte boha maŋ, kane ɗoŋ zina kʼIsa umbo adda daŋgay me.» ");
INSERT INTO moz_vpl VALUES ("AC5_24","074_5_24","ACT","5","24","24","Aame goole ɗoŋ boohiyo Ɓoy Raa ti deero ɗoŋ seɗeke an illiga iŋkino maŋ, an di roote munɗa an ki suune ye a munɗa wede ize a tukki ɗoŋ zina geŋ me, wo an tondiso tondiso ti tuddaŋ baa, ɗe aasey moo me, moo me. ");
INSERT INTO moz_vpl VALUES ("AC5_25","074_5_25","ACT","5","25","25","Saŋ maŋ i dʼede wedusu yʼa iido ti rabila, yʼan di ruute, yʼede: «Kun ollo kay, ɗoŋ kun tiʼn iɓi adda daŋgay geŋ, aŋkeŋ kane adda booro Ɓoy Raa an dooyiso ɗuwo.» ");
INSERT INTO moz_vpl VALUES ("AC5_26","074_5_26","ACT","5","26","26","Iŋkino maŋ kesiko goole ɗoŋ i boohiyo Ɓoy Raa yʼa iide ti ɗuwo itadí kono ɗoŋ zina kʼIsa yʼan tiʼn waako, wo an an kʼizo oon̰e ye kono an orgiso ɗuwo an tiʼn kakkita. ");
INSERT INTO moz_vpl VALUES ("AC5_27","074_5_27","ACT","5","27","27","Aame kane ɗoŋ zina kʼIsa geŋ ti Ɓoy Raa an tiʼn wiiko, an dʼan tʼiide ki ɗaana deero Yawudiyagi maŋ, mozigo goole ɗoŋ seɗeke yʼan iise tondiso, ");
INSERT INTO moz_vpl VALUES ("AC5_28","074_5_28","ACT","5","28","28","yʼede: «Kaye ay un ruute, kun ôhor, ti suma kʼIsa kun dooya wenɗa ye. Wo aŋkeŋ kun wollo, kun ize eŋ moo me, ɗoŋ siiɗo Zeruzalem pay kun an ti gizite, kun dehu puuzo wede eŋ tʼa oope eedey.» ");
INSERT INTO moz_vpl VALUES ("AC5_29","074_5_29","ACT","5","29","29","Maŋ Piyer ti ɗoŋ zina kʼIsa oŋgoŋ an di ruute, anʼde: «Kaye ay dʼise ki poone munɗa wede Raa yi dehu, saŋ wede ki ɗuwo kollo. ");
INSERT INTO moz_vpl VALUES ("AC5_30","074_5_30","ACT","5","30","30","Kune Isa kun ti yʼ tiike ekkʼundumu, kun di yʼîide, wo Raa wede ki moŋgiɗagiŋ yʼa ti yʼ bilɗe ti diine ɗoŋ unto me. ");
INSERT INTO moz_vpl VALUES ("AC5_31","074_5_31","ACT","5","31","31","Raa yʼa yʼumɓe a ammidadí, yʼa ti yʼ ziipe Mozigo wo Wede kʼUttiyo kono yʼan di kize urzi a ɗoŋ kʼIzirayel, an di kime lekkiyadaŋ wo an tʼoone tambobino kʼolɗikadaŋ. ");
INSERT INTO moz_vpl VALUES ("AC5_32","074_5_32","ACT","5","32","32","Wo sulɗi ize geŋ kaye ay wulle wo ay illiga, kaye ti Unde Kamilen̰ ere Raa yʼan ele a ɗoŋ i ollige onamí toŋ maŋ.» ");
INSERT INTO moz_vpl VALUES ("AC5_33","074_5_33","ACT","5","33","33","Aame kane ɗoŋ geŋ an illiga ono gen̰n̰o maŋ, an di-gulkuwe ɓaadaŋ, an dehu an tiʼn tʼîide ɗoŋ zina kʼIsa geŋ me. ");
INSERT INTO moz_vpl VALUES ("AC5_34","074_5_34","ACT","5","34","34","Wo ɗe a diine deero Yawudiyagi geŋ i dʼede wedusu yoŋ Pariziyeŋ sundí Gamaliyel, yoŋ wede dooyiso kʼoogoro Yawudiyagi, wo ɗoŋ pay an yi suune yoŋ wede beehiye. Yoŋ yʼa tʼiiziga a diinayaŋ wo yʼan di ruute, yʼede: «Kun ollo, ki poone nʼa roote geŋ ɗoŋ eŋ kun tiʼn aɗɗo.» ");
INSERT INTO moz_vpl VALUES ("AC5_35","074_5_35","ACT","5","35","35","Aame an tiʼn uɗɗe maŋ, yʼan di ruute a ɗoŋ booro, yʼede: «Zemɓa ki nuŋ ɗoŋ kʼIzirayel, kun elko ɗo munɗa wede kun dehu kun an dʼise a ɗoŋ eŋ me. ");
INSERT INTO moz_vpl VALUES ("AC5_36","074_5_36","ACT","5","36","36","Kun elke munɗa dokki ye, i dʼede wedusu sundí Tedas yʼa-tʼize tuddí wede suma, yi dʼirga ɗuwo a itadí suma meeda piɗe. Wo yode geŋ an di yʼîide, maŋ ɗoŋzí an di-tiipe wo munɗa geŋ a-ti ɗiŋge iŋkino. ");
INSERT INTO moz_vpl VALUES ("AC5_37","074_5_37","ACT","5","37","37","Aame yode geŋ yi tʼiŋgile maŋ, i dʼize wede ti doolo sundí Ziidas, yode geŋ ti siiɗo Galile. Aame deero Romeŋ an iiziga kaza ɗuwo geŋ, yʼa tʼuɗɗe ki balɗa wo ɗoŋ ɓaadaŋ an di yʼ diine, wo yode toŋ an di yʼîide kay, wo ɗoŋzí an di-tiipe. ");
INSERT INTO moz_vpl VALUES ("AC5_38","074_5_38","ACT","5","38","38","Wo aŋkeŋ nʼun di rooto, kun tʼele egguŋ ye a ɗoŋ eŋ me, kun oolo an dʼeŋgile, aame sulɗizaŋ ɗoŋ an isiyo, wo onamaŋ an kazita eŋ ettiyo tʼurzi ɗuwo maŋ, saŋ a ôhira. ");
INSERT INTO moz_vpl VALUES ("AC5_39","074_5_39","ACT","5","39","39","Wo aame munɗazaŋ an isiyo eŋ ki Raa kotto maŋ, kun kʼaana ôhiradaŋ ye kino me, para maŋ koo kun ɗeyyiso Raa batum maŋ.» Iŋkino maŋ kane ɗoŋ booro an dʼumɓe a ono Gamaliyel. ");
INSERT INTO moz_vpl VALUES ("AC5_40","074_5_40","ACT","5","40","40","Ɗoŋ zina kʼIsa geŋ an an diʼn gime, an an diʼn ele a bey ɗoŋ boohiyo Ɓoy Raa, an diʼn gusse ti dalyagi. Saŋ deero an an di ruute, anʼde: «Kun ôhor, ti suma kʼIsa kun kizita ye baa.» Maŋ an an dʼiize. ");
INSERT INTO moz_vpl VALUES ("AC5_41","074_5_41","ACT","5","41","41","Ɗoŋ zina kʼIsa an tʼuɗɗe ti diine deero Yawudiyagi tʼulbe uŋse, kono Raa yiʼni wulle kane an tʼîide an dabire kono an umɓe a suma kʼAlmasi. ");
INSERT INTO moz_vpl VALUES ("AC5_42","074_5_42","ACT","5","42","42","Wo ti tarkuuse a eedaŋ gen̰n̰o toŋ, onniyo ti onniyo adda booro Ɓoy Raa, adda ɓoyɗizaŋ daayum an kazita, an dooyiso ɗuwo a urzi Rabila Majjaanawa kʼIsa, yoŋ Almasi Raa yi biire. ");
INSERT INTO moz_vpl VALUES ("AC6_1","074_6_1","ACT","6","1","1","A onniytagi geŋ sanalliyagi kʼIsa an dʼaagulu kʼaagulu, wo kane Yawudiyagi ɗoŋ orbe ono Girek geŋ an kulkiso ti Yawudiyagi ɗoŋ orbe ono ɗoŋ kʼEber, kono mandayɗazaŋ ɗoŋ orbe Girek geŋ a dokkiɗe kʼomɓo ere daayum daayum gette, an an kʼeliyo ye. ");
INSERT INTO moz_vpl VALUES ("AC6_2","074_6_2","ACT","6","2","2","Aame kane ɗoŋ zina koomat makumu sire an illiga iŋkino maŋ, an diʼn ugiye sanalliyagi kʼIsa pay, maŋ an an di ruute, anʼde: «Ɗerec ye, kaye ay dʼooli ti kazita kʼono Raa a ɗuwo, ay tʼette dokkiɗe kʼomɓo sey me.» ");
INSERT INTO moz_vpl VALUES ("AC6_3","074_6_3","ACT","6","3","3","Geŋ iŋkino zemɓa ki nuŋ, kune batum kun beero ti diinaguŋ ɗoŋ sarat, ɗuwo ɗoŋ sundaŋ ti môolo ki beehiye, ôoniyo tʼUnde Kamilen̰ wo ti suuniyo kʼono, wo naabo ette ay an tʼela a kane. ");
INSERT INTO moz_vpl VALUES ("AC6_4","074_6_4","ACT","6","4","4","Iŋkino maŋ kaye ay ele tuddey pay a urzi tondiyo Raa, wo a naabo kazita kʼonamí a ɗuwo. ");
INSERT INTO moz_vpl VALUES ("AC6_5","074_6_5","ACT","6","5","5","A onamaŋ geŋ kane zemɓa pay an dʼumɓe eego, maŋ an di biire Etiyeŋ wede i ziipe addí pay a Raa wo ôoniyo tʼUnde Kamilen̰. An di biire sey Pilip, Pirokor, Nikanor, Timoŋ, Parmenas wo Nikolas wede ti geeger ki Antiyos, yoŋ Yawudusu ye wo yʼa-tʼize tuddí Yawudusu. ");
INSERT INTO moz_vpl VALUES ("AC6_6","074_6_6","ACT","6","6","6","Maŋ kane geŋ, zemɓa an an dʼan tʼiide ki ɗaana ɗoŋ zina kʼIsa, an di tunde Raa, an an di-ziipe bey ki beeko. ");
INSERT INTO moz_vpl VALUES ("AC6_7","074_6_7","ACT","6","7","7","Iŋkino maŋ ono Raa geŋ adda siiɗo Zeruzalem a-tiipe, ɗuwo an diʼn zuune, sanalliyagi kʼIsa geŋ an dʼaagulu kʼaagulu, wo ɗoŋ seɗeke Yawudiyagi ɓaadaŋ an di ziipe addaŋ a Isa pây. ");
INSERT INTO moz_vpl VALUES ("AC6_8","074_6_8","ACT","6","8","8","Etiyeŋ geŋ Raa yi di yʼûune ti beeko, wo yi-dʼele toogo kʼisiyo sulɗi kʼarmika ɓaadaŋ ti sulɗi ɗoŋ i ceeriyo eego a diine ɗoŋ duuru. ");
INSERT INTO moz_vpl VALUES ("AC6_9","074_6_9","ACT","6","9","9","Wo i dʼede kuuli miibi an guune jikisi ti yode. Ti diinayaŋ ɗoŋ oŋgoŋ Yawudiyagi ɗoŋ ti geeger Sireŋ wo ti Alegzandire, kane geŋ ti diine ɗoŋ adda ɓoy wede Yawudiyagi ge dooyiso an yi waaku «ɓoy ɓulagi an an iize», wo ɗoŋ oŋgoŋ Yawudiyagi ɗoŋ ki siiɗo Silisi ti Aazi. Kane pay an dʼiise niikiyto ti Etiyeŋ. ");
INSERT INTO moz_vpl VALUES ("AC6_10","074_6_10","ACT","6","10","10","Wo ɗe an ki dʼiine kersiyadí ye a suuniyo kʼono ere Unde Kamilen̰ ti ele geŋ me. ");
INSERT INTO moz_vpl VALUES ("AC6_11","074_6_11","ACT","6","11","11","Iŋkino maŋ kane geŋ an dʼiwila ɗuwo kono an di roote: «Kaye ay yʼilliga yi ruute ono ɗoŋ ki kalɗa kʼoogoro Muusa ti suma Raa.» ");
INSERT INTO moz_vpl VALUES ("AC6_12","074_6_12","ACT","6","12","12","A ɗoŋ duuru an an tʼelite ono wo a ɗoŋ i dokkiyo Yawudiyagi ti ɗoŋ suuniyo kʼoogoro Yawudiyagi pây, wo kane ɗoŋ pay geŋ an dʼiiziga tukki Etiyeŋ, an di yʼ ziiɗa an di-tʼiide ki ɗaana deero booro Yawudiyagi. ");
INSERT INTO moz_vpl VALUES ("AC6_13","074_6_13","ACT","6","13","13","Wo a ɗaana kane geŋ an di wiike ɗoŋ lohito kʼono pay, anʼde: «Wede eŋ daayum yi kalɗa Ɓoy Raa wo oogoro Muusa, ");
INSERT INTO moz_vpl VALUES ("AC6_14","074_6_14","ACT","6","14","14","kono ay yʼilliga yi ruute, Isa wede ti geeger Nazaret geŋ yʼa-kossita ti Ɓoy Raa wo dooyiso ere Muusa yʼin ele gette yʼa ti-kima ti doolo.» ");
INSERT INTO moz_vpl VALUES ("AC6_15","074_6_15","ACT","6","15","15","Aame geŋ ɗoŋ duuru pay i-guune adda ɓoy goole ki booro geŋ, an di yʼ wolliso Etiyeŋ teɓen̰, wo ume kʼedayí i-tooriyo aa ume kʼeda maaleeka. ");
INSERT INTO moz_vpl VALUES ("AC7_1","074_7_1","ACT","7","1","1","Iŋkino maŋ mozigo goole ɗoŋ seɗeke yʼa tunde Etiyeŋ, yʼede: «Onamaŋ an rootiyo a tukki kee geŋ ɗerec ko?» ");
INSERT INTO moz_vpl VALUES ("AC7_2","074_7_2","ACT","7","2","2","Etiyeŋ yi diʼn gime onamí, yʼede: «Maawi ki nuŋ, zemɓa ki nuŋ, kun ollo bee. Aame Ibirayim yi lekkiyo ɓotto a siiɗo kʼehiyadí sundutú Mezapotami, wo ki poone yʼa eŋgila ki geeger ki Araŋ geŋ, Raa goole a jiire yi di gize tuddí, ");
INSERT INTO moz_vpl VALUES ("AC7_3","074_7_3","ACT","7","3","3","wo yi di ruute, yʼede: “Ki tʼoozo ki oolo siiɗadá, wo ɗoŋ ɓoozá kʼa eŋgilo ki siiɗo ere saŋ maŋ nʼa di kizey.” ");
INSERT INTO moz_vpl VALUES ("AC7_4","074_7_4","ACT","7","4","4","Iŋkino maŋ Ibirayim yʼa tʼiiziga, yʼa tʼuɗɗe ti siiɗo Kalde, yʼa iŋgile yi lekkiyo a geeger ki Araŋ. Wo bini meegí yʼinda maŋ, saŋ Raa yʼa-di tʼiido ki siiɗo ere aŋkeŋ kun di lekkiyo aŋken̰n̰o ettiyo. ");
INSERT INTO moz_vpl VALUES ("AC7_5","074_7_5","ACT","7","5","5","Wo ɗe Raa yi di ruute munɗa wede yi di tʼela, yʼede: “Siiɗo ette nʼa-tʼela a kee wo kʼeda kʼin̰n̰izá, an di lekka adda.” Wo aame geŋ Raa yi-kʼele ume booloŋ suma yʼa-koone toŋ umbo a siiɗo ette, wo ki sirwe ulo kʼaddí toŋ umbo Raa yi-kʼele ye. ");
INSERT INTO moz_vpl VALUES ("AC7_6","074_7_6","ACT","7","6","6","Maŋ Raa yi ruute sey, yʼede: “Ita kʼin̰n̰izá an di lekka a siiɗo torgagi, an diʼn isa ɓulagi, an diʼn dabira ozzinagi meeda piɗe. ");
INSERT INTO moz_vpl VALUES ("AC7_7","074_7_7","ACT","7","7","7","Wo kane ɗuwo ɗoŋ iʼn isa ɓulagi geŋ, nuŋ Raa nʼa ɗekka booro a eedaŋ. Wo saŋ kane ita kʼin̰n̰izá geŋ tʼumayaŋ an tʼoozigo, an tʼetto ken̰n̰o, an oo dʼottila.” ");
INSERT INTO moz_vpl VALUES ("AC7_8","074_7_8","ACT","7","8","8","Aame Raa yʼa ti ɗiŋge onamí iŋkino maŋ, yʼa gitte taasuwa ti Ibirayim, wo munɗa wede i-kaza taasuwa geŋ, walɗu ponde. Iŋkino maŋ Ibirayim a ulí Isaaka yi di wilɗa ponde, aame yi yʼehe i îide onniyo gessire maŋ. Iŋkino kay Isaaka yi di wilɗa ponde a ulí Yakup, wo Yakup yʼan di wilɗite ponde a in̰n̰izí kane koomat makumu sire moŋgiɗagiŋ gen̰n̰o. ");
INSERT INTO moz_vpl VALUES ("AC7_9","074_7_9","ACT","7","9","9","Moŋgiɗagiŋ in̰n̰i Yakup geŋ an gulɓike ti leemadaŋ Yusup, an di yʼiwila aa ɓule, wo ɗoŋ i yʼiwila an di-tʼiide siiɗo Misir. Wo Raa daayum ti yode, ");
INSERT INTO moz_vpl VALUES ("AC7_10","074_7_10","ACT","7","10","10","dabaradí yi di ti buuye pay. Yi dʼele suuniyo kʼono, lekkiyadí yi di ti tʼize uŋse a ɗaana Parahoŋ mozigo ki siiɗo Misir. Iŋkino maŋ Parahoŋ yʼa ti yʼ ziipe wede goole ki siiɗo Misir, wo ɓoozí toŋ yi-dʼiili a beezí pây. ");
INSERT INTO moz_vpl VALUES ("AC7_11","074_7_11","ACT","7","11","11","Bini maŋ i dʼize mosogo ɓaadaŋ adda siiɗo Misir pay, wo a siiɗo Kanahaŋ pây. Ɗuwo an di dibire ɓaadaŋ, wo moŋgiɗagiŋ munɗa an tʼoomi toŋ umbo. ");
INSERT INTO moz_vpl VALUES ("AC7_12","074_7_12","ACT","7","12","12","Aame Yakup yʼilligo a Misir omɓo ede maŋ, yʼa igibe moŋgiɗagiŋ an an dʼowilo, gette ettiyadaŋ ere ki poone. ");
INSERT INTO moz_vpl VALUES ("AC7_13","074_7_13","ACT","7","13","13","Aame yiʼn igibe ki sirwe sey maŋ, Yusup yʼan tʼiiɗiba itadí a zemɓadí an di yʼ zuune. Wo Parahoŋ toŋ ita maawi Yusup a Kanahaŋ yʼa ti zuune pây. ");
INSERT INTO moz_vpl VALUES ("AC7_14","074_7_14","ACT","7","14","14","Iŋkino maŋ Yusup yʼa igibe, yʼa-waako meegí Yakup ti ɗoŋ ɓoozí pay, kane ada sarat makumu paat. ");
INSERT INTO moz_vpl VALUES ("AC7_15","074_7_15","ACT","7","15","15","Aame Yakup yʼilliga maŋ, yʼa tʼiiziga ti ɗoŋ ɓoozí pay, yʼa iŋgile Misir an di likko bini maŋ, yʼa inda ti in̰n̰izí pay kane ɗoŋ moŋgiɗagiŋ me. ");
INSERT INTO moz_vpl VALUES ("AC7_16","074_7_16","ACT","7","16","16","Wo nunɗanzaŋ an di ziko ki Sisem, an tʼittiba adda muuzo ere Ibirayim yʼiwila ti soŋko a bey kʼin̰n̰i kʼAmor a Sisem. ");
INSERT INTO moz_vpl VALUES ("AC7_17","074_7_17","ACT","7","17","17","Ozzinagi ti ozzinagi maŋ ɗoŋziŋ an dʼiigila ɓaadaŋ a siiɗo Misir me, wo peeɗo toŋ tʼîide ere Raa yʼa-ti ɗaŋge ono ɗoŋ yi ruute yʼaasa a Ibirayim. ");
INSERT INTO moz_vpl VALUES ("AC7_18","074_7_18","ACT","7","18","18","Saŋ maŋ i-gili mozigo ti doolo a Misir me, wo yoŋ geŋ yi ki suune ye urzi Yusup me. ");
INSERT INTO moz_vpl VALUES ("AC7_19","074_7_19","ACT","7","19","19","Mozigo geŋ ɗoŋziŋ yi tiʼn digge, wo moŋgiɗagiŋ yʼanni dibire, yiʼn isiyo ki toogo in̰n̰izaŋ an dʼooliyo an tʼunto. ");
INSERT INTO moz_vpl VALUES ("AC7_20","074_7_20","ACT","7","20","20","Aame geŋ Muusa an ti yʼehe, yoŋ ulo ɗemilen̰, majjaane a ɗaana Raa, an di yʼ muɗɗe kaŋ ombiɗe tere aɗo adda ɓoy meegí. ");
INSERT INTO moz_vpl VALUES ("AC7_21","074_7_21","ACT","7","21","21","Aame an kʼaane ombiɗayí ye maŋ, an tʼumɓe, an di ziipo paate, wo saŋ uto Parahoŋ tʼa yʼuune, tʼa tʼumɓe a tode, tʼa yi muɗɗe aa ulutú. ");
INSERT INTO moz_vpl VALUES ("AC7_22","074_7_22","ACT","7","22","22","Muusa geŋ an ti yʼ duuye a suuniyo ere pay ki ɗoŋ Misir. Yʼa tʼize wede i suune rootiyo kʼono wo toogo a naabo pây. ");
INSERT INTO moz_vpl VALUES ("AC7_23","074_7_23","ACT","7","23","23","Muusa i îide ozzine ada piɗe maŋ, i-dʼiide elkiyo yʼa ette, yʼa wollo zemɓadí ɗoŋ kʼIzirayel. ");
INSERT INTO moz_vpl VALUES ("AC7_24","074_7_24","ACT","7","24","24","Maŋ yʼa iŋgile, yʼiideʼŋ yi wolliyo wede Misir yi isiyo ulsu a wede soo ti diine zemɓadí, maŋ yʼa-yʼuube, wo yi di ti duuze, wede Misir geŋ yʼa yʼîide. ");
INSERT INTO moz_vpl VALUES ("AC7_25","074_7_25","ACT","7","25","25","Yʼize iŋkino geŋ yʼelkiyo zemɓadí ɗoŋ kʼIzirayel an dʼelka Raa yi dehu yʼan utte tʼurzi yode, kaciŋ umbo an ki zuune ye. ");
INSERT INTO moz_vpl VALUES ("AC7_26","074_7_26","ACT","7","26","26","Saŋ soggo sey maŋ, yi dʼuune ɗoŋ kʼIzirayel sire an ɗeyyiso, wo yi dehu yʼa tiʼn tʼokkiƴe an di lekke ti toose. Iŋkino maŋ yʼan di ruute, yʼede: “Zemɓa ki nuŋ, kuneʼŋ zemɓa ye ko? Ɗe ki moo me kun isiyo ulsu ti tudduguŋ me?” ");
INSERT INTO moz_vpl VALUES ("AC7_27","074_7_27","ACT","7","27","27","Wo wede i isiyo ulsu a leemadí geŋ yʼa gibira Muusa, wo yʼede: “Kee i ki ziipe mozigo wo wede ɗekkiyo booro a tukki kaye wee wee? ");
INSERT INTO moz_vpl VALUES ("AC7_28","074_7_28","ACT","7","28","28","Kunuŋ ki dehu kʼa ni tʼîde aa loho kʼîide wede Misir ko?” ");
INSERT INTO moz_vpl VALUES ("AC7_29","074_7_29","ACT","7","29","29","Aame Muusa yʼilliga iŋkino maŋ, ti siiɗo Misir yʼa tʼumbe, yʼa iŋgile ki siiɗo Madiyan, yi lekkiyo aŋgen̰n̰o, a siiɗo gette yi dʼehe in̰n̰i kuuli sire. ");
INSERT INTO moz_vpl VALUES ("AC7_30","074_7_30","ACT","7","30","30","Adda siiɗo gette Muusa yi likke ozzine ada piɗe. Saŋ onniyo soo maŋ yoŋ adda balɗa goppoŋ ti mokkolo sundutú Sinayi, maaleeka ki Raa yi di gize tuddí adda beyga kʼundumu oggiyo uwwo ɗala ɗala. ");
INSERT INTO moz_vpl VALUES ("AC7_31","074_7_31","ACT","7","31","31","A munɗa kʼarmika Muusa yi wulle geŋ, yʼa ziiɗa giggirí. Wo yʼa dʼiide goppoŋ, yʼa wolle koɗuwo, yʼa iide maŋ yʼollige golla Galmeega Raa, tʼede: ");
INSERT INTO moz_vpl VALUES ("AC7_32","074_7_32","ACT","7","32","32","“Nuŋ Raa ki moŋgiɗagá, Raa kʼIbirayim, kʼIsaaka wo ki Yakup.” Muusa orgiso tʼa yi ziiɗa ɓaadaŋ, yʼa iise ŋoŋŋirso, yi kʼaane yi kʼamɓe edayí, yʼa ki wolle munɗa gen̰n̰o ye. ");
INSERT INTO moz_vpl VALUES ("AC7_33","074_7_33","ACT","7","33","33","Iŋkino maŋ Galmeega yi di ruute, yʼede: “Toɓiyagá ki tʼoɗɗipo kono ume wede kee kʼôhire eŋ, yoŋ kamilen̰ ki nuŋ Galmeega. ");
INSERT INTO moz_vpl VALUES ("AC7_34","074_7_34","ACT","7","34","34","Ɗerec, ni wulle dabar ki ɗoŋzó a siiɗo Misir te, nʼilliga soopiytadaŋ te, wo nuŋ nʼiidoʼŋ kono nʼan aɗɗe. Aŋkeŋ kʼedi, nʼa-kʼagiba ki siiɗo Misir.”» ");
INSERT INTO moz_vpl VALUES ("AC7_35","074_7_35","ACT","7","35","35","Saŋ Etiyeŋ yʼa ruute sey, yʼede: «Yode Muusa wede ɗoŋ kʼIzirayel an di yʼ giigira, anʼde: “Kee wee wee i ki ziipe mozigo, wo wede ɗekkiyo booro me?” Geŋ saŋ Raa batum yʼa yʼigibe, yʼa tʼize mozigayaŋ, wo yʼa tʼize wede kʼaɗɗiyadaŋ. Raa yi yʼigibe tʼurzi maaleeka wede an ikkima adda kʼundumu gozzibor gen̰n̰o. ");
INSERT INTO moz_vpl VALUES ("AC7_36","074_7_36","ACT","7","36","36","Yode Muusa geŋ yʼan uɗɗo ɗoŋ kʼIzirayel ti siiɗo Misir, tʼurzi kʼisiyo sulɗi ɗoŋ i ceeriyo eego ti sulɗi kʼarmika adda siiɗo Misir batum, wo soŋ aame kane an doopiɗe Bar Teezowo, wo aame kane adda balɗa ozzine ada piɗe. ");
INSERT INTO moz_vpl VALUES ("AC7_37","074_7_37","ACT","7","37","37","Yode Muusa sey yʼan di ruute a ɗoŋ kʼIzirayel, yʼede: “Raa yi dʼaɗɗa ti diine zemɓaguŋ nebi aa nuuno.” ");
INSERT INTO moz_vpl VALUES ("AC7_38","074_7_38","ACT","7","38","38","Wo aame ɗoŋ kʼIzirayel an tʼugiye a balɗa toŋ maŋ, yode Muusa sey a guune a diine moŋgiɗagiŋ ti maaleeka me, yode geŋ yi di rootiyo a Muusa tʼekki mokkolo Sinayi. Iŋkino yode Muusa sey yi-tʼollige ono Raa ɗoŋ i dʼeliyo lekkiyo, yʼin dʼettiyo yʼin di kaza. ");
INSERT INTO moz_vpl VALUES ("AC7_39","074_7_39","ACT","7","39","39","Wo moŋgiɗagiŋ an ki dʼilliga ye onamí me, an di yʼ giigira, wo adda kʼaddaŋ an dehu an di-kime ki siiɗo Misir. ");
INSERT INTO moz_vpl VALUES ("AC7_40","074_7_40","ACT","7","40","40","An i-di ruute a Aroŋ, anʼde: “Kʼin okkoŋ raayagi a ozira a ɗaanadiŋ, kono in ki suune ye munɗa i iide a yode Muusa wede yʼin diʼn uɗɗo ti siiɗo Misir me.” ");
INSERT INTO moz_vpl VALUES ("AC7_41","074_7_41","ACT","7","41","41","Iŋkino maŋ a onniytagi geŋ an dʼikkima ulo buru go loŋgusizaŋ, maŋ an i dʼele seɗeke a yode geŋ me, ulbaŋ uŋse an dʼize tarnaape a naabo ere an ize ti beezaŋ gette. ");
INSERT INTO moz_vpl VALUES ("AC7_42","074_7_42","ACT","7","42","42","Wo Raa yʼan gime dar yʼan diʼn iili, an dʼottilso a molɗali a kandaane, aa an riiŋe ti kaaga adda mattup ki nebiyagi, anʼde: “Kune ɗoŋ kʼIzirayel no, geŋ a nuuno ɗey ko kun izite seɗeke ki seyɗi wo senɗikagi ɗoŋ oŋgo kun izite, aame kune adda balɗa ozzine ada piɗe geŋ me? Aha, a nuuno ye. ");
INSERT INTO moz_vpl VALUES ("AC7_43","074_7_43","ACT","7","43","43","Kune kun zirke ɓoy golmodo ki raayusu sundí Molok, wo ti mooliso ere ki raa wede sundí Repan. Kane sulɗi geŋ kun ikkima ti beyguŋ kono kun an dʼottile. Iŋkino maŋ nuŋ nʼun tiʼn limma bini siiɗo Babiloon, wo ti Babiloon geŋ ki ɗaana sey.”» ");
INSERT INTO moz_vpl VALUES ("AC7_44","074_7_44","ACT","7","44","44","Etiyeŋ yʼa ruute sey, yʼede: «Adda balɗa geŋ moŋgiɗagiŋ an dʼede Ɓoy Raa wede an ikkima ki golmodo, i-boohiyo sulɗi ɗoŋ ki taasuwa ere Raa yi gitte ti ɗoŋzí. Ɓoy geŋ Muusa yʼa tʼikkima aa Raa yi ruute yʼaase. Yʼa tʼikkima a-tʼiide a munɗa wede yi wulle i-iide aa suniye. ");
INSERT INTO moz_vpl VALUES ("AC7_45","074_7_45","ACT","7","45","45","Kʼita maŋ moŋgiɗagiŋ an an dʼiili Ɓoy Raa wede an ikkima ki golmodo geŋ a in̰n̰izaŋ, an tʼumɓo ti kane aame geŋ Zozuwe wede dokkiyadaŋ, yʼan dʼan dʼaaho ki siiɗo ere ita ɗoŋtú Raa yiʼn ilmi ti ɗaanadaŋ. Geŋ iŋkino Ɓoy Raa geŋ yʼa likke adda siiɗo gettiyo bini moziko ki Dawut. ");
INSERT INTO moz_vpl VALUES ("AC7_46","074_7_46","ACT","7","46","46","Dawut yʼa uune beeko ti Raa, maŋ Dawut yʼa tunde Raa, yi dʼooziga ɓoy a Raa ki Yakup. ");
INSERT INTO moz_vpl VALUES ("AC7_47","074_7_47","ACT","7","47","47","Wo miŋ a ki tʼize ye, a tʼiiziga Ɓoy Raa ulí Salamoŋ. ");
INSERT INTO moz_vpl VALUES ("AC7_48","074_7_48","ACT","7","48","48","Wo Raa goole a jiire pay geŋ, yoŋ yi ki lekkiyo adda ɓoy wede ɗuwo an oozige ye, aa Raa yi ruute ti kaaga ti bize nebi soo: ");
INSERT INTO moz_vpl VALUES ("AC7_49","074_7_49","ACT","7","49","49","“Galmeega yʼede: Kandaane aa ume wede ni-konso, ni lekkiyo wo siiɗo aa ume wede ni dʼoɓe zoŋɗó ni puukiyo. Ɗe kune ɓoy miŋ wede tuuku me, kun o ooziga, wo aame tuuku nʼa lekka adda me? ");
INSERT INTO moz_vpl VALUES ("AC7_50","074_7_50","ACT","7","50","50","Sulɗi pay eŋ i zippe nuŋ ye ko?”» ");
INSERT INTO moz_vpl VALUES ("AC7_51","074_7_51","ACT","7","51","51","Etiyeŋ yʼan di ruute ɗoŋ booro sey, yʼede: «Kune ɗoŋ i koogire Raa, kune ɗoŋ sukkiya kun ki ziipe adduguŋ a Raa ye, kun tʼuɗɗe aa maawuguŋ koyok, daayum kun koogire Unde Kamilen̰. ");
INSERT INTO moz_vpl VALUES ("AC7_52","074_7_52","ACT","7","52","52","Ti kaaga maawuguŋ nebiyagi pay an diʼn dibire, wo an diʼn îide kane ɗoŋ i gizite ti poone aaniya kʼAlmasi yoŋ ki diine geŋ me. Wo aame onniyo tʼîide maŋ, yode toŋ kun di yʼ giigira, kun di yʼîide. ");
INSERT INTO moz_vpl VALUES ("AC7_53","074_7_53","ACT","7","53","53","Raa yʼun dʼele oogiradí tʼurzi maaleekiyagi, wo kune kun a-ki tʼizire eego ye.» ");
INSERT INTO moz_vpl VALUES ("AC7_54","074_7_54","ACT","7","54","54","Aame ɗoŋ booro an illiga Etiyeŋ yi ruute iŋkino maŋ, an di-gulkuwe ɓaadaŋ, an dʼahutu bokimo. ");
INSERT INTO moz_vpl VALUES ("AC7_55","074_7_55","ACT","7","55","55","Wo yo Etiyeŋ ôoniyo ti Unde Kamilen̰ yʼa tʼumɓe edayí kʼawwa ki kandaane maŋ, yʼa wulle toore darƴika Raa wo Isa yi tʼîhira a ammade Raa. ");
INSERT INTO moz_vpl VALUES ("AC7_56","074_7_56","ACT","7","56","56","Yʼa ruute, yʼede: «Kun ollo kay, ni wolliyo kandaane i tʼihina wo yoŋ wede an yʼehe aa ulo wede geŋ yi tʼîhira a ammade Raa.» ");
INSERT INTO moz_vpl VALUES ("AC7_57","074_7_57","ACT","7","57","57","Kane an illiga iŋkino maŋ an ziɗɗe ɗolle ɓaadaŋ, kuwwagaŋ an aa ti ŋiƴƴite, kono an kʼolliga onamí ye. Maŋ an dʼiiziga pay kaŋ soo ki tuddí. ");
INSERT INTO moz_vpl VALUES ("AC7_58","074_7_58","ACT","7","58","58","An di yʼ ziiɗa tʼadda geeger, an di yʼuɗɗe paate, an di yʼiise kakkisa ti moŋgali ki tôwwadí. Kane ɗoŋ i wulle wo illiga geŋ, kallagaŋ deero an tʼiɗɗipe, an tʼiɓi sirpa kʼulo obulsu sundí Sool. ");
INSERT INTO moz_vpl VALUES ("AC7_59","074_7_59","ACT","7","59","59","Aame an yi kakkisa geŋ, Etiyeŋ yi tondiyo Raa, yʼede: «Galmeega Isa, ki tʼamɓo undó.» ");
INSERT INTO moz_vpl VALUES ("AC7_60","074_7_60","ACT","7","60","60","Saŋ yʼa iire ti zibbaní, wo yʼa iɗili ti golla awwa, yʼede: «Galmeega, a olɗikadaŋ ette kʼan tʼiso tambobino.» Aame yʼa ti ruute iŋkino maŋ, yʼa-tʼihe. ");
INSERT INTO moz_vpl VALUES ("AC8_1a","074_8_1a","ACT","8","1a","1a","Wo Sool onamaŋ soo ti ɗoŋ îide Etiyeŋ me. ");
INSERT INTO moz_vpl VALUES ("AC8_1b","074_8_1b","ACT","8","1b","1b","A onniyo gettiyo batum ɗuwo an diʼn iise dabirsa ɓaadaŋ ki ɗoŋ ogiyso ti suma kʼIsa a Zeruzalem. Kane pay geŋ an di-tiipe kʼadda siiɗo Ziide ti Samari, a Zeruzalem i dʼuupe ɗoŋ zina kʼIsa siidaŋ. ");
INSERT INTO moz_vpl VALUES ("AC8_2","074_8_2","ACT","8","2","2","Ɗoŋ i seeɗu urzi Raa zakiɗi geŋ an tʼittiba Etiyeŋ me, wo an dʼîile ɓaadaŋ a untadí gette. ");
INSERT INTO moz_vpl VALUES ("AC8_3","074_8_3","ACT","8","3","3","Wo ki yode Sool maŋ yi dehu yʼan ise umbo ɗoŋ ogiyso ti suma kʼIsa me, yi dʼettiyo ɓoy ti ɓoy, yi diʼn dehutu yi tiʼn seɗɗu kuuli erayi, yi tiʼn oɓe daŋgay. ");
INSERT INTO moz_vpl VALUES ("AC8_4","074_8_4","ACT","8","4","4","Kane ɗoŋ i-tiipe geŋ, an dʼettiyo borko ti borko an di kazita Rabila Majjaanawa. ");
INSERT INTO moz_vpl VALUES ("AC8_5","074_8_5","ACT","8","5","5","Geŋ iŋkino Pilip yʼa tʼiide kʼadda geeger meeda ki siiɗo Samari, yʼa iise kazita rabila kʼAlmasi Raa yi biire a ɗoŋ siiɗo gettiyo. ");
INSERT INTO moz_vpl VALUES ("AC8_6","074_8_6","ACT","8","6","6","Kane ɗoŋ siiɗo gette pay an zaapu kuudaŋ tak a ono ɗoŋ Pilip yʼan kazita geŋ me, kono an illiga wo an wolliyo tʼedayaŋ sulɗi kʼarmika ɗoŋ yʼisiyto geŋ me. ");
INSERT INTO moz_vpl VALUES ("AC8_7","074_8_7","ACT","8","7","7","Iŋkino maŋ siitanɗani an tʼuɗɗite ti tukki ɗoŋ kʼeeni ɓaadaŋ ti ɗollite ere ti golla awwa. Wo ɗoŋ ɓaadaŋ ruŋguyuŋ, oŋgoŋ an deŋkiso, pay an dʼuune bee. ");
INSERT INTO moz_vpl VALUES ("AC8_8","074_8_8","ACT","8","8","8","Iŋkino maŋ ɗoŋ geeger pay gette ulbaŋ uŋse ɓaadaŋ. ");
INSERT INTO moz_vpl VALUES ("AC8_9","074_8_9","ACT","8","9","9","Aame geŋ i dʼede wedusu adda geeger gette sundí Simo, yoŋ kombiɗe ti kaagine wo a ɗoŋ siiɗo Samari geŋ yʼan dʼisiyto sulɗi kʼarmika, kane pay an seeɗu giggiraŋ. Yʼa-tʼize tuddí aa wede i-dʼede toogo. ");
INSERT INTO moz_vpl VALUES ("AC8_10","074_8_10","ACT","8","10","10","Kane ɗuwo pay iise ti in̰n̰isi bini ɗoŋ deero geŋ, an di yʼ daaniya telele, wo an dʼeesiyo: «Wede eŋ i-dʼede toogo Raa, ere an ti waaku “toogo a jiire ɓaadaŋ” gettiyo.» ");
INSERT INTO moz_vpl VALUES ("AC8_11","074_8_11","ACT","8","11","11","Ti kaagine Simo ti kombiɗikadí gette, yi dʼisiyto sulɗi kʼarmika ɗuwo an seeɗu giggiraŋ, iŋkino an di yʼ daaniya telele. ");
INSERT INTO moz_vpl VALUES ("AC8_12","074_8_12","ACT","8","12","12","Wo aŋkeŋ Pilip yʼiide yʼan gizite Rabila Majjaanawa ki Moziko Raa wo ki suma kʼIsa Almasi. Iŋkino maŋ erayi kuuli pay an dʼumɓe wo an tiʼn zuyye batem. ");
INSERT INTO moz_vpl VALUES ("AC8_13","074_8_13","ACT","8","13","13","Aame geŋ yode Simo batum toŋ, yʼa ziipe addí a Isa wo an ti yʼ zuyye batem, yʼa ziiɗa ita Pilip. Wo aame yi wulle sulɗi kʼarmika ɓaadaŋ ti sulɗi ɗoŋ i ceeriyo eego ɗoŋ Pilip yʼisiyto gen̰n̰o maŋ, yʼa ziiɗa giggirí. ");
INSERT INTO moz_vpl VALUES ("AC8_14","074_8_14","ACT","8","14","14","Aame kane ɗoŋ zina kʼIsa a Zeruzalem an illiga ɗoŋ siiɗo Samari anʼni ziiɗa ono Raa bey sire maŋ, an an dʼigibe Piyer ti Zaŋ. ");
INSERT INTO moz_vpl VALUES ("AC8_15","074_8_15","ACT","8","15","15","Aame an iiney a Samari maŋ, an tunde Raa a kane Samariten ɗoŋ i ziipe addaŋ a Isa kono Raa yʼan tʼele Unde Kamilen̰. ");
INSERT INTO moz_vpl VALUES ("AC8_16","074_8_16","ACT","8","16","16","Wo aame geŋ Raa yi-kʼele Undí ye ɓotto a wenɗa me, anʼni suyyiso batem ti suma Galmeega Isa ɗaŋŋal. ");
INSERT INTO moz_vpl VALUES ("AC8_17","074_8_17","ACT","8","17","17","Iŋkino maŋ Piyer ti Zaŋ an an di ziipe bey a eedaŋ wo an dʼuune Unde Kamilen̰. ");
INSERT INTO moz_vpl VALUES ("AC8_18","074_8_18","ACT","8","18","18","Aame Simo yi wulle Unde Raa ti ɗiigo a tukki ɗoŋ geŋ tʼurzi ɗoŋ zina kʼIsa an an ti ziipe beezaŋ a eedaŋ maŋ, yi dehu yʼan tʼele soŋko a Piyer ti Zaŋ me. ");
INSERT INTO moz_vpl VALUES ("AC8_19","074_8_19","ACT","8","19","19","Wo yʼan di ruute, yʼede: «Toogo gette kun o eeli kay kono nʼa zaape bey a tukki ɗuwo, an tʼoone Unde Kamilen̰.» ");
INSERT INTO moz_vpl VALUES ("AC8_20","074_8_20","ACT","8","20","20","Maŋ Piyer yi di ruute, yʼede: «Kee ti soŋkadá pay Raa yʼunni dagga, kono kʼelkiyo ti soŋkadá gette kʼaane ki tʼowila munɗa wede Raa yʼeliyo ti mozuwo me. ");
INSERT INTO moz_vpl VALUES ("AC8_21","074_8_21","ACT","8","21","21","Adda naabadey ette kee adda ye, aggadá umbo ti kaye me, kono a ɗaana Raa biza kʼulbá ki diine ye. ");
INSERT INTO moz_vpl VALUES ("AC8_22","074_8_22","ACT","8","22","22","Ki-kama lekkiyadá, naabadá ere olɗo gette ki tʼoolo, wo kʼa tondo Raa koo yʼay tʼisa tambobino maŋ a elkisadá ere olɗo gette. ");
INSERT INTO moz_vpl VALUES ("AC8_23","074_8_23","ACT","8","23","23","Nuŋ ni wolliyo maŋ kee addá i-kʼaaɗumu a sulɗi eŋ me, wo kee ɓule kʼolɗiko.» ");
INSERT INTO moz_vpl VALUES ("AC8_24","074_8_24","ACT","8","24","24","Iŋkino maŋ Simo yʼan di ruute, yʼede: «I tondo Galmeega kune batum kono nuŋ me, kono munɗa wede kun rootiyo geŋ oo ki dʼaana ye.» ");
INSERT INTO moz_vpl VALUES ("AC8_25","074_8_25","ACT","8","25","25","Saŋ maŋ Piyer ti Zaŋ geŋ an an tʼîide taaya a ɗuwo, a munɗa wede kane an wulle a urzi kʼIsa, wo an di gizite ono Galmeega. Saŋ maŋ an di-gime ki Zeruzalem, a kamadaŋ geŋ a urzi an di gizite Rabila Majjaanawa a borkiyagi ɓaadaŋ ki siiɗo Samari. ");
INSERT INTO moz_vpl VALUES ("AC8_26","074_8_26","ACT","8","26","26","Saŋ maaleeka ki Galmeega Raa yi di ruute a Pilip, yʼede: «Ki tʼoozo, kʼodo kʼurzi wede ki ɗanɗi, urzi wede ti Zeruzalem i dʼamɓu geeger Gaza, urzi geŋ yoŋ tʼadda balɗa.» ");
INSERT INTO moz_vpl VALUES ("AC8_27","074_8_27","ACT","8","27","27","Iŋkino maŋ kesiko Pilip yʼa tʼiiziga, yʼa iŋgile, yi sooru sooru. A sooruzí gette yi wolliyo bibiraw wedusu a ɗaanadí. Wedeʼŋ geŋ yoŋ wede goole wo kokkiso ti siiɗo kʼEtiyopi, yi naabiya ti Kandas mohita kʼEtiyopi, wede ƴeeriyo korɓite tode, yi tʼiide Zeruzalem ottilso a Raa. ");
INSERT INTO moz_vpl VALUES ("AC8_28","074_8_28","ACT","8","28","28","Konso adda puusadí yi-kime ki siiɗadí, wo yi gariya mattup ki nebi Ezayi. ");
INSERT INTO moz_vpl VALUES ("AC8_29","074_8_29","ACT","8","29","29","Unde Raa ti di ruute a Pilip, tʼede: «Kʼa naara, ki yʼoonoy wede puus geŋ me.» ");
INSERT INTO moz_vpl VALUES ("AC8_30","074_8_30","ACT","8","30","30","Maŋ Pilip yʼa-niire, yʼiideʼŋ yʼa yi ziiɗa wede suma adda puusadí geŋ me, yʼollige yi gariya mattup ki nebi Ezayi, maŋ yʼa yi tunde, yʼede: «Ki gariya geŋ, munɗa ki yi suuniyo ɗey ko?» ");
INSERT INTO moz_vpl VALUES ("AC8_31","074_8_31","ACT","8","31","31","Wede yi diʼn gime onamí, yʼede: «Ɗe nʼa suune mummino, wenɗa yʼa kiʼn ziipe urzi ye maŋ?» Maŋ wede yi di ruute Pilip, yʼede: «Kʼedi, kʼa ti koli adda puus, kʼa-koona a sirpa nuuno.» ");
INSERT INTO moz_vpl VALUES ("AC8_32","074_8_32","ACT","8","32","32","En̰n̰o ume wede yi gariya an riiŋe ti kaaga adda mattup ki Raa me: «Yoŋ aa damu wede an arkuɗu ki tôwwo, wo aa ulo ki damu wede an ɗekkiso ilalí wo yi ki môolo ye, iŋkino kay yode toŋ bizí yi kʼihina ye. ");
INSERT INTO moz_vpl VALUES ("AC8_33","074_8_33","ACT","8","33","33","An di-dʼele sukiyagi, ɗerec ki yode an i-ki tʼele ye, wee wee a roota suma kʼin̰n̰izí me, lekkiyadí a siiɗo an i-ti ɗikke.» ");
INSERT INTO moz_vpl VALUES ("AC8_34","074_8_34","ACT","8","34","34","Wede suma geŋ yʼa tunde Pilip, yʼede: «Kee kʼollo ɗo, nebi yi rootiyo iŋkino tʼaaye ti yode batum kunuŋ, ti wenɗa doolo ko?» ");
INSERT INTO moz_vpl VALUES ("AC8_35","074_8_35","ACT","8","35","35","Iŋkino maŋ Pilip yʼa tʼihina bizí, wo tʼurzi gariya mattup gette yi di gizite Rabila Majjaanawa kʼIsa. ");
INSERT INTO moz_vpl VALUES ("AC8_36","074_8_36","ACT","8","36","36","An iide kee maŋ, an dʼuune ahu. A ume geŋ wede suma yʼa ruute, yʼede: «Ki wollo kay eŋ ahu, ɗe moo sey aa biite kʼa tiʼn suyye batem me?»  ");
INSERT INTO moz_vpl VALUES ("AC8_37","074_8_37","ACT","8","37","37","Pilip yi di ruute, yʼede: «Aame kee ki ziipe addáʼŋ pay a Isa maŋ, nʼa ki ti suyye batem.» Maŋ wede yi diʼn gime onamí, yʼede: «Nʼumɓe, Isa Almasi yoŋ Ulo Raa.» ");
INSERT INTO moz_vpl VALUES ("AC8_38","074_8_38","ACT","8","38","38","Iŋkino maŋ Pilip yi di ruute a wede tuuliyo, yʼede: «Puusadá ki-tʼôhor.» Maŋ Pilip kane ti wede suma an di-ɗiige tʼekki puus me, an di-ɗiige kʼadda kʼahu, Pilip yʼa ti yʼ zuyye batem. ");
INSERT INTO moz_vpl VALUES ("AC8_39","074_8_39","ACT","8","39","39","Aame an tʼuɗɗe tʼadda kʼahu maŋ, Unde Galmeega tʼa ti yʼ n̰ukkiɗe Pilip me. Wo yo wede suma geŋ yi ki yʼ wulle ye baa, iŋkino yʼa iŋgile ki ɗaanadí ti uŋsuwo. ");
INSERT INTO moz_vpl VALUES ("AC8_40","074_8_40","ACT","8","40","40","Wo yo Pilip yi wolliyoʼŋ yo a Azot, maŋ yi dʼettiyo geeger ti geeger, yi kazita Rabila Majjaanawa adda geegiryagi pay bini yʼa dʼiiney Sezare. ");
INSERT INTO moz_vpl VALUES ("AC9_1","074_9_1","ACT","9","1","1","Wo aame geŋ Sool yi dehu daayum yʼa dabire wo yʼa tʼîde sanalliyagi ki Galmeega. Iŋkino maŋ yʼa iide, yʼa uuney mozigo goole ɗoŋ seɗeke ");
INSERT INTO moz_vpl VALUES ("AC9_2","074_9_2","ACT","9","2","2","kono yi di tʼele mattup. Wo ti mattup gette yʼa tʼooney deero ɓoyɗi ɗoŋ Yawudiyagi ge dooyiso a Damas, wo aame ɗoŋ i daaniya urzi wede aware ki Galmeega kuuli ti erayi ede maŋ, yʼa tiʼn seɗɗo yʼan dʼan tʼetto ki Zeruzalem, an diʼn oɓey daŋgay. ");
INSERT INTO moz_vpl VALUES ("AC9_3","074_9_3","ACT","9","3","3","Aame yi uune mattup maŋ, yʼa iŋgile ki Damas. Yʼizire kee yʼiiney goppoŋ ti geeger maŋ, a kaamiki i ɗiigo toore ti kandaane, wilin̰ a tuure a tukki yode. ");
INSERT INTO moz_vpl VALUES ("AC9_4","074_9_4","ACT","9","4","4","Yʼa iire a siiɗo wo yʼollige golla ti rootiyo, tʼede: «Sool, Sool, ɗe moo me ki ni dabirsa me?» ");
INSERT INTO moz_vpl VALUES ("AC9_5","074_9_5","ACT","9","5","5","Maŋ Sool yʼa tunde, yʼede: «Galmeega, ɗe kee wee wee?» Maŋ golla gette tʼa ruute, tʼede: «Nuŋ Isa wede kee ki di yʼ dabirsa. ");
INSERT INTO moz_vpl VALUES ("AC9_6","074_9_6","ACT","9","6","6","Wo ki tʼoozo, kʼeŋgilo kʼadda geeger, aŋgeŋ an aa di kizey munɗa wede Raa yi dehu kʼaasey me.» ");
INSERT INTO moz_vpl VALUES ("AC9_7","074_9_7","ACT","9","7","7","Wo kane ɗoŋ ti Sool soo geŋ an tʼîhira, munɗa an di roote an ki suune ye, orgiso tʼanni ziiɗa kono golla an di-tʼollige wo wenɗa an ki yʼ wolliyo ye. ");
INSERT INTO moz_vpl VALUES ("AC9_8","074_9_8","ACT","9","8","8","Maŋ Sool yʼa tʼiiziga, edayí kargigal wo i ki wolliyo ye. Aame geŋ ɗoŋ iide ti yode an i ziiɗa beezí, an ti yʼ dukke kʼadda geeger Damas. ");
INSERT INTO moz_vpl VALUES ("AC9_9","074_9_9","ACT","9","9","9","Onniyo aɗo Sool edayí i ki wolliyo ye, wo yi lekkiyo daa kʼomɓo daa soɓo. ");
INSERT INTO moz_vpl VALUES ("AC9_10","074_9_10","ACT","9","10","10","A Damas geŋ i dʼede wedusu sundí Ananiyas, yode geŋ sanallusu kʼIsa. I-dʼiide munɗa aa suniye Galmeega yi di gize tuddí, wo yʼa yi wiike, yʼede: «Ananiyas!» Maŋ Ananiyas yi diʼn gime onamí, yʼede: «Galmeegó, nuŋ en̰n̰o nʼollige.» ");
INSERT INTO moz_vpl VALUES ("AC9_11","074_9_11","ACT","9","11","11","Galmeega yi di ruute, yʼede: «Ki tʼoozo, kʼodo kʼaɗɗo ti urzi wede an yi waaku urzi ɗelele, ki tʼodoy adda ɓoy Ziidas, kʼa tondoy wede ede sundí Sool ki Tarsi. Aŋken̰n̰o yi tondiyo Raa, ");
INSERT INTO moz_vpl VALUES ("AC9_12","074_9_12","ACT","9","12","12","wo adda munɗa i-iide aa suniye geŋ yʼa wulle wedusu sundí Ananiyas, yoŋ yi-tʼiide di yode, yi di ziipe beezí a edayí, maŋ edayí a tʼihina.» ");
INSERT INTO moz_vpl VALUES ("AC9_13","074_9_13","ACT","9","13","13","Wo Ananiyas yi diʼn gime onamí, yʼede: «Galmeegó, wede eŋ rabiladí ni tʼilliga, ɗoŋ ɓaadaŋ an ruute a sulɗi ɗoŋ ulpi pay yʼisiyo a ɗoŋzá a Zeruzalem me. ");
INSERT INTO moz_vpl VALUES ("AC9_14","074_9_14","ACT","9","14","14","Wo deero ɗoŋ seɗeke an i ele mattup yʼa-seɗɗe ɗoŋ i tondiyo ti suma kee a en̰n̰o, geŋ iŋkino yʼiido ken̰n̰o me.» ");
INSERT INTO moz_vpl VALUES ("AC9_15","074_9_15","ACT","9","15","15","Wo ɗe Galmeega yi di ruute, yʼede: «Kʼodo, ki yʼoonoy wede geŋ me, kono nuŋ ni yʼ biire, nʼa-yʼisa wede a kiza sundó a ɗuwo ɗoŋ Yawudiyagi ye, a mozagaŋ wo a ɗoŋ kʼIzirayel. ");
INSERT INTO moz_vpl VALUES ("AC9_16","074_9_16","ACT","9","16","16","Wo nuŋ batum ni di kizita sulɗi ɗoŋ pay yʼa dabira kono sundó.» ");
INSERT INTO moz_vpl VALUES ("AC9_17","074_9_17","ACT","9","17","17","Iŋkino maŋ Ananiyas yʼa tʼiiziga yʼa iŋgile, yʼiiney maŋ yi-tʼiide adda ɓoy Ziidas, Sool toŋ adda. Yʼiideʼŋ yi di ziipe beezí a yode wo yi di ruute, yʼede: «Sool leema ki nuŋ, Galmeega i nʼigibo me, yode Isa wede yʼa di gize tuddí aame kee a urzi kʼettiyo ken̰n̰o, yi nʼigibo ki tukki kee kono edayá a wolle sey, wo Raa yi-ki ti kʼôone tʼUnde Kamilen̰.» ");
INSERT INTO moz_vpl VALUES ("AC9_18","074_9_18","ACT","9","18","18","A kaamiki gaŋgiragi aa ki puuni a iise solɗite ti edayí, maŋ edayí a iise wolliso sey. Yʼa tʼiiziga, wo Ananiyas yʼa ti yʼ zuyye batem. ");
INSERT INTO moz_vpl VALUES ("AC9_19","074_9_19","ACT","9","19","19","Saŋ yi dʼiimi, toogadí tʼa iido. Sool yʼa likke onniyto miibi ti sanalliyagi kʼIsa a Damas me. ");
INSERT INTO moz_vpl VALUES ("AC9_20","074_9_20","ACT","9","20","20","Wo tiŋ geŋ miŋ yʼa iise kazita baa adda ɓoyɗi ɗoŋ Yawudiyagi ge dooyiso, yi dʼeesiyo: «Isa yoŋ Ulo Raa.» ");
INSERT INTO moz_vpl VALUES ("AC9_21","074_9_21","ACT","9","21","21","Kane ɗoŋ pay i yʼollige geŋ an ziiɗa giggiraŋ, wo an di rootiyo diinayaŋ, anʼde: «Eŋ miŋ yo wede i-dabirsa ɓaadaŋ kane ɗoŋ i tondiyo ti suma kʼIsa a Zeruzalem ye ko? Wo ettiyadí ken̰n̰o ette yʼiidoʼŋ toc miŋ seɗɗuzaŋ, wo yʼan diʼn tʼeley bey deero ɗoŋ seɗeke ye ko?» ");
INSERT INTO moz_vpl VALUES ("AC9_22","074_9_22","ACT","9","22","22","Yo Sool a kazita kʼonamí geŋ, i di tʼele toogo yi kazita i ceeriyo ki ceeriyo tʼaddí pay, yʼan di rootiyo keren̰ Isa yoŋ Almasi Raa yi biire. Iŋkino kane Yawudiyagi ɗoŋ i lekkiyo a Damas geŋ, an i di roote munɗa an ki suune ye. ");
INSERT INTO moz_vpl VALUES ("AC9_23","074_9_23","ACT","9","23","23","Saŋ bini maŋ kane Yawudiyagi geŋ, kaŋ soo an di-ruute ti diinayaŋ ki tôwwadí Sool me. ");
INSERT INTO moz_vpl VALUES ("AC9_24","074_9_24","ACT","9","24","24","Iŋkino a rootiyadaŋ gette wedusu yi di gize a Sool me, kono kane Yawudiyagi an tʼikkima tuddaŋ, an di boohiyo boha bumɓiyagi geeger on̰n̰u wo diɗɗo kono Sool yʼuɗɗa maŋ ki tôwwadí. ");
INSERT INTO moz_vpl VALUES ("AC9_25","074_9_25","ACT","9","25","25","Iŋkino maŋ onniyo soo a diɗɗo, kane sanalliyagi Sool an di-tʼiide, an ti yʼ ziipe adda geɗɗe, an ti yʼ zuuye ti waaya moŋgali ti nee. ");
INSERT INTO moz_vpl VALUES ("AC9_26","074_9_26","ACT","9","26","26","Saŋ ti Damas geŋ Sool yʼa iiney Zeruzalem. Aame yʼiiney maŋ, yʼa dihe yʼa di keƴƴe ti sanalliyagi kʼIsa. Wo kane pay an orgiso a yoŋ me, kono an kʼamɓu ye ki kotto yi tʼize sanallusu kʼIsa me. ");
INSERT INTO moz_vpl VALUES ("AC9_27","074_9_27","ACT","9","27","27","Iŋkino maŋ Barnabas yʼa iyye, yʼa ti yʼ wiike, wo yʼa-di tʼiide kʼume ɗoŋ zina kʼIsa. Aame geŋ yʼan tʼîide taaya mummino Sool yi wullo Galmeega aame yo a urzi ki Damas me, mummino Galmeega yi ruutito me, wo soŋ mummino Sool yi gizito ti suma kʼIsa daa kʼorgiso a Damas me. ");
INSERT INTO moz_vpl VALUES ("AC9_28","074_9_28","ACT","9","28","28","Iŋkino maŋ tʼume gen̰n̰o Sool yʼa-tʼiide ti kane a Zeruzalem, an dʼamɓu ken̰n̰o ken̰n̰o kaŋ soo wo yi kazita ti suma Galmeega daa kʼorgiso. ");
INSERT INTO moz_vpl VALUES ("AC9_29","074_9_29","ACT","9","29","29","A kane Yawudiyagi ɗoŋ orbe ono Girek toŋ yʼan di kazita wo yi niikiyto pay ti kane me, wo kane an di dihe urzi ki tôwwadí. ");
INSERT INTO moz_vpl VALUES ("AC9_30","074_9_30","ACT","9","30","30","Aame kane zemɓa ɗoŋ i ziipe addaŋ a Isa geŋ an illiga iŋkino maŋ, Sool an di dʼiŋgile ki geeger Sezare, wo an ti yʼ diipiɗa yʼa iŋgile ki geeger Tarsi. ");
INSERT INTO moz_vpl VALUES ("AC9_31","074_9_31","ACT","9","31","31","Iŋkino maŋ kane ɗoŋ ogiyso ti suma kʼIsa a siiɗo Ziide, a siiɗo Galile wo a siiɗo Samari pây geŋ, an di lekkiyo ti toose. Kane an tʼize ɗoŋ toogo a urzi Raa, an di lekkiyo ti ottilso a Galmeega, wo Unde Kamilen̰ ti diʼn noogiyo an dʼaagulu kʼaagulu. ");
INSERT INTO moz_vpl VALUES ("AC9_32","074_9_32","ACT","9","32","32","Aame geŋ Piyer daayum yi sooru adda siiɗo pay, yi dʼamɓu ken̰n̰o ken̰n̰o. Onniyo soo maŋ yʼa tʼiide wolliyo ki ɗoŋ ki Raa i lekkiyo a geeger Lidda. ");
INSERT INTO moz_vpl VALUES ("AC9_33","074_9_33","ACT","9","33","33","A ume geŋ i dʼede wedusu sundí Ene yoŋ ruŋguyuŋ, ozzine gessire yi lekkiyo moone ekkʼoŋgali. Aame Piyer yʼiiney a ume gen̰n̰o maŋ, wede geŋ yi yʼuuney, ");
INSERT INTO moz_vpl VALUES ("AC9_34","074_9_34","ACT","9","34","34","wo yi di ruute, yʼede: «Ene, Isa Almasi yʼa ele bee. Ki tʼoozoʼŋ, kee batum ki tʼolbo sulɗi moonizá me.» A kaamiki Ene yʼa tʼiizi, yʼa tʼîhira. ");
INSERT INTO moz_vpl VALUES ("AC9_35","074_9_35","ACT","9","35","35","Aame kane ɗoŋ pay a geeger Lidda wo a bere ki siiɗo Saroŋ geŋ an wulle iŋkino maŋ, an di-gime lekkiyadaŋ a urzi Galmeega. ");
INSERT INTO moz_vpl VALUES ("AC9_36","074_9_36","ACT","9","36","36","I dʼede erewo adda geeger Zoppa todʼte sanallawa kʼIsa, sundutú Tabita (i-kaza Dorkas tʼono Girek). Tode gette a ɗuwo tʼan isiyo beehiye, ɗoŋ umbadaŋ toŋ tʼan dʼeeliyo munɗa me. ");
INSERT INTO moz_vpl VALUES ("AC9_37","074_9_37","ACT","9","37","37","Aame Piyer yoŋ daayum a geeger Lidda geŋ, Tabita gette ti tʼiire eeni wo tʼa inda. Tʼinda maŋ an ti-zuyye, nuune an ti yʼ gili biino ere tʼawwa tʼekki bakatú, an ti yʼ duwwe. ");
INSERT INTO moz_vpl VALUES ("AC9_38","074_9_38","ACT","9","38","38","Lidda gette goppoŋ ti Zoppa me, kane sanalliyagi kʼIsa a Zoppa an illiga Piyer yoŋ aŋgen̰n̰o maŋ, an dʼigibe kuuli sire an i di ruuto, anʼde: «Leema ki nuŋ kʼaynʼolliga maŋ, kʼedi kesiko, in tʼette di kaye.» ");
INSERT INTO moz_vpl VALUES ("AC9_39","074_9_39","ACT","9","39","39","Piyer yʼa tʼiiziga, kesiko yʼa iŋgile ti kane. Aame yʼiiney maŋ, kane an di ti gili biino ere tʼawwa tʼekki bakatú. Kane mandayɗayi pay an di yʼuuna ti zumari a edayaŋ, wo an i di kazita kallagi ɗoŋ Tabita ti giniti aame tʼa tʼinda ɓotto. ");
INSERT INTO moz_vpl VALUES ("AC9_40","074_9_40","ACT","9","40","40","Piyer yʼan di ruute a ɗuwo an tʼaɗɗe tʼadda ɓoy. An tʼuɗɗe maŋ, yo yʼa-dikke, yʼa iise tondiyo Raa. Saŋ maŋ yʼa-gime edayí kʼume nuune, wo yʼa ruute, yʼede: «Tabita koŋ mi tʼoozoʼŋ.» Maŋ tʼa tʼihina edatú, wo aame ti wulle Piyer maŋ, tʼa-guune. ");
INSERT INTO moz_vpl VALUES ("AC9_41","074_9_41","ACT","9","41","41","Piyer yi ziiɗa beytú tʼa-tʼiiziga, maŋ mandayɗayi ti ɗoŋ ki Raa oŋgoŋ yʼanni wiiko, wo yʼan ti-gize an di wulle todʼ ti lekkiyo zeere. ");
INSERT INTO moz_vpl VALUES ("AC9_42","074_9_42","ACT","9","42","42","Iŋkino maŋ ɗoŋ pay adda geeger ki Zoppa an dʼilliga rabila gette, wo ɗoŋ ɓaadaŋ an di ziipe addaŋ a Galmeega. ");
INSERT INTO moz_vpl VALUES ("AC9_43","074_9_43","ACT","9","43","43","Wo a Zoppa geŋ Piyer yʼaa likke onniyto ɓaadaŋ di wede kʼoɗige golmidagi sundí Simo. ");
INSERT INTO moz_vpl VALUES ("AC10_1","074_10_1","ACT","10","1","1","I dʼede wedusu sundí Korney, yi lekkiyo a geeger Sezare. Yoŋ goole ki asigiryagi meeda ki Romeŋ, ti diine kʼasigiryagi meeda zoot anʼni waaku sundaŋ «Italiyeŋ». ");
INSERT INTO moz_vpl VALUES ("AC10_2","074_10_2","ACT","10","2","2","Wede geŋ yoŋ yi seeɗu urzi Raazí zakiɗi, yode ti ɗoŋ adda ɓoozí pay an ottilso a Raa. Yawudiyagi ɗoŋ an kʼede munɗa ye toŋ yʼan dʼisiyo beehiye, wo yi tondiyo Raa daayum. ");
INSERT INTO moz_vpl VALUES ("AC10_3","074_10_3","ACT","10","3","3","Iŋkino maŋ onniyo soo a peeɗo lohe Korney i-dʼiido munɗa aa suniye. Yʼa yi wulle keren̰ maaleeka Raa me yi dʼiiɗiba itadí, yi dʼettiyo di yode wo yʼa yi wiike, yʼede: «Korney!» ");
INSERT INTO moz_vpl VALUES ("AC10_4","074_10_4","ACT","10","4","4","Wo yoŋ yi di yʼ wolliso maaleeka teɓen̰, maŋ orgiso tʼa yi ziiɗa wo yi di ruute, yʼede: «Galmeega, ɗe moo me?» Maaleeka yi di ruute, yʼede: «Kee tondiyadá Raa yʼilliga ti beehiyko ere kʼisiyo a ɗuwo te, iŋkino yoŋ yi ki kʼelkiyo. ");
INSERT INTO moz_vpl VALUES ("AC10_5","074_10_5","ACT","10","5","5","Wo aŋkeŋ ki agiba ɗuwo an dʼette ki Zoppa, an di waako wede soo sundí Simo, sundí soo te Piyer, yʼa etto. ");
INSERT INTO moz_vpl VALUES ("AC10_6","074_10_6","ACT","10","6","6","Yo wede geŋ torgusu yi lekkiyo di wede sundí Simo kay, wede kʼoɗige golmidagi, ɓoozí a biza bar.» ");
INSERT INTO moz_vpl VALUES ("AC10_7","074_10_7","ACT","10","7","7","Aame maaleeka wede i ruute a Korney geŋ yʼiŋgile maŋ, Korney yi wiiko ɗoŋ sire ti diine ɗoŋ naabadí, wo asugursu soo wede i seeɗu urzi Raazí zakiɗi, ti diine kʼasigiryagí. ");
INSERT INTO moz_vpl VALUES ("AC10_8","074_10_8","ACT","10","8","8","Korney yʼan tʼîide taaya a munɗa wede ize, saŋ yʼan igibe ki Zoppa. ");
INSERT INTO moz_vpl VALUES ("AC10_9","074_10_9","ACT","10","9","9","Iŋkino maŋ kane an dʼiŋgile, soggo toŋ kane daayum a urzi goppoŋ an a-tʼette ki Zoppa, wo peeɗo tʼize diine. Iŋkino a peeɗo gettiyo batum, Piyer yʼa-ti gili tʼekki ɓoy tʼawwa, yʼa tonde Raa. ");
INSERT INTO moz_vpl VALUES ("AC10_10","074_10_10","ACT","10","10","10","Aame geŋ mosogo tʼa yi ziiɗa, yi dehu yi dʼoomi. Koore an i-dʼisa omɓo geŋ, i-dʼiido munɗa aa suniye, ");
INSERT INTO moz_vpl VALUES ("AC10_11","074_10_11","ACT","10","11","11","wo yi wolliyoʼŋ kandaane a tʼihina wo munɗa aa boojo goole kettiso a bohaní piɗe, i-ɗeegu ki siiɗo aa dara. ");
INSERT INTO moz_vpl VALUES ("AC10_12","074_10_12","ACT","10","12","12","Wo adda kʼaddí i dʼede ita seyɗi ɗoŋ zoŋɗaŋ piɗe piɗe, ita seyɗi ɗoŋ i morkimso a siiɗo wo ita kʼemɓi ɗoŋ oppiyso a kandaane pây. ");
INSERT INTO moz_vpl VALUES ("AC10_13","074_10_13","ACT","10","13","13","Aame geŋ yʼa illi golla ti di ruute, tʼede: «Piyer, ki tʼoozoʼŋ! Seyɗi eŋ ki soɗɗo, kʼa tʼôodo, kʼa tʼaaɗa.» ");
INSERT INTO moz_vpl VALUES ("AC10_14","074_10_14","ACT","10","14","14","Wo Piyer yʼa ruute, yʼede: «Galmeegó aha! Nuŋ munɗa wede kʼomɓo ulu, yoŋ ganigi a ɗaanadá geŋ kaŋ soo toŋ ni kʼiimi ye.» ");
INSERT INTO moz_vpl VALUES ("AC10_15","074_10_15","ACT","10","15","15","Maŋ golla gette ki sirwe sey Piyer yʼa tʼilliga, tʼede: «Munɗa wede Raa yʼede yo eŋ kamilen̰ geŋ, ki kʼelke aa munɗa kʼomɓo ulu ye.» ");
INSERT INTO moz_vpl VALUES ("AC10_16","074_10_16","ACT","10","16","16","Golla gette Piyer yʼa tʼilliga ti rootiyo onamtú miŋ kane ɗey taŋ aɗo, saŋ a kaamiki munɗa geŋ a-gili ki kandaane. ");
INSERT INTO moz_vpl VALUES ("AC10_17","074_10_17","ACT","10","17","17","Piyer geŋ yʼa ziiɗa giggirí a munɗa wede i-iide aa suniye, wo munɗa i-kaza yi ki yʼ suuniyo ye geŋ me. Koore geŋ kane ɗuwo ɗoŋ Korney yiʼn igibe geŋ, ɓoy Simo an di yʼ dihite, an yʼuune, aŋkeŋ kane a biza bumɓu. ");
INSERT INTO moz_vpl VALUES ("AC10_18","074_10_18","ACT","10","18","18","Kane an di wiike ɗoŋ ɓoy, an iido maŋ an diʼn tunde, anʼde: «Simo wede an yi waaku soŋ Piyer geŋ, yoŋ a en̰n̰o ko?» ");
INSERT INTO moz_vpl VALUES ("AC10_19","074_10_19","ACT","10","19","19","Piyer geŋ yoŋ daayum yʼelkiso a munɗa wede i-iide aa suniye gen̰n̰o, aame Unde Raa ti rootiyo, tʼede: «Kʼollo, i dʼede ɗoŋ aɗo an ki dehu toŋ maŋ. ");
INSERT INTO moz_vpl VALUES ("AC10_20","074_10_20","ACT","10","20","20","Ki tʼoozoʼŋ, ki ti ɗeego, kʼeŋgilo ti kane daa kʼorgiso, kono ɗuwo eŋ iʼn igibo nuuno.» ");
INSERT INTO moz_vpl VALUES ("AC10_21","074_10_21","ACT","10","21","21","Iŋkino maŋ Piyer yi-ti ɗiigo, yʼan diʼn uuney kane ɗuwo geŋ me, wo yʼan di ruute, yʼede: «Eŋ miŋ nuŋ wede kun dehu. Ki moo me kun nʼiido me?» ");
INSERT INTO moz_vpl VALUES ("AC10_22","074_10_22","ACT","10","22","22","Maŋ an i diʼn gime onamí, anʼde: «Kaye eŋ aynʼigibo Korney, yode wede goole kʼasigiryagi meeda ki Romeŋ, yoŋ wede ki diine yʼottilso a Raa, wo kane Yawudiyagi pay an yi giyye. Yoŋ maaleeka Raa yi ruuto, kee kʼa ette di yode kono ki di rootey ono yʼa-kʼolligey.» ");
INSERT INTO moz_vpl VALUES ("AC10_23","074_10_23","ACT","10","23","23","Iŋkino maŋ ɗuwo geŋ Piyer yʼa tiʼn wiike kʼadda ɓoy, an dʼinne di yode. Ti soggatú maŋ kane ɗuwo geŋ an tʼiiziga ti Piyer an dʼiŋgile kaŋ soo. Wo zemɓa miibi an ziipe addaŋ a Isa ki Zoppa, an aa diʼn igibo. ");
INSERT INTO moz_vpl VALUES ("AC10_24","074_10_24","ACT","10","24","24","Saŋ onniyo ki ɗaana maŋ Piyer ti kane ɗuwo geŋ an dʼiiney Sezare. Koore geŋ yo Korney yʼa tʼugiye ɗoŋ ɓoozí ti laŋziyagi ɗoŋ kuc an diʼn delliyo. ");
INSERT INTO moz_vpl VALUES ("AC10_25","074_10_25","ACT","10","25","25","Aame Piyer yʼiiney wo yʼette kʼadda ɓoy maŋ, Korney yʼa iide yʼa yʼikkimo, yʼa iire a zoŋɗí kono yi-dʼottile. ");
INSERT INTO moz_vpl VALUES ("AC10_26","074_10_26","ACT","10","26","26","Maŋ Piyer yi di ruute, yʼede: «Aha, ki tʼoozoʼŋ!» Wo yi ziiɗa beezí, yʼa yʼiiziga, yʼede: «Nuŋ wede tudde aa kee pây.» ");
INSERT INTO moz_vpl VALUES ("AC10_27","074_10_27","ACT","10","27","27","Maŋ Piyer yi pelkiyo ti Korney, yʼa-tʼiide kʼadda ɓoy. A ume geŋ yi wolliyo ɗoŋ ɓaadaŋ i tʼugiye a ɗaanadí. ");
INSERT INTO moz_vpl VALUES ("AC10_28","074_10_28","ACT","10","28","28","Yʼan di ruute, yʼede: «Kune kun ti suune oogoro Yawudiyagi te, urzi ti kʼele ye a Yawudusu yʼa ette ɓoy wede Yawudusu ye, yʼa lekke ti yode me. Wo ɗe nuŋ Raa yʼo ruute keren̰, koɗuwo ye a ɗaanadí wede tuuku toŋ nʼa yi wolle yoŋ ganigi wo ulsu me. ");
INSERT INTO moz_vpl VALUES ("AC10_29","074_10_29","ACT","10","29","29","Geŋ iŋkino, aame kun iide kun ni wiiko geŋ, ni ki ruuto ye munɗa me wo nʼa iŋgilo miŋ ti kune baa. Aŋkeŋ ni dehu nʼa suune, ki moo me kun ni wiiko nʼa iido me.» ");
INSERT INTO moz_vpl VALUES ("AC10_30","074_10_30","ACT","10","30","30","Maŋ Korney yi di ruute, yʼede: «I dʼede onniyo aɗo, a peeɗo ere ki lohe gettiyo batum, ni tondiyo Raa adda ɓoozó. A kaamiki geŋ miŋ wedusu ti kallagí i ralita wic wic yi-tʼôhire a ɗaanadó, ");
INSERT INTO moz_vpl VALUES ("AC10_31","074_10_31","ACT","10","31","31","wo yʼo di rootiyo: “Korney, kee tondiyadá Raa yʼilliga, wo yʼelkiyo a beehiyko ere kee kʼisiyo a ɗoŋ an kʼede munɗa ye me. ");
INSERT INTO moz_vpl VALUES ("AC10_32","074_10_32","ACT","10","32","32","Aŋkeŋ ki agiba ɗuwo an dʼette ki Zoppa, an di waako wede soo sundí Simo, sundí soo te Piyer, yʼa etto. Yo wede geŋ torgusu yi lekkiyo di wede sundí Simo kay, wede kʼoɗige golmidagi, ɓoozí a biza bar.” ");
INSERT INTO moz_vpl VALUES ("AC10_33","074_10_33","ACT","10","33","33","Aame geŋ kesiko ni dʼigibe ɗuwo ki tuddá, wo kee kʼaaze adde koɗuwo kʼa iido. Wo aŋkeŋ kaye pay en̰n̰o a ɗaana Raa kono ay dʼolliga sulɗi ɗoŋ pay Galmeega yʼa ruuto kʼay di roote.» ");
INSERT INTO moz_vpl VALUES ("AC10_34","074_10_34","ACT","10","34","34","Iŋkino maŋ Piyer yʼa iise kazita kʼono, yʼede: «Aŋken̰n̰o ni suune ki kotto Raa geŋ yʼinni wolliyo kine ɗuwo pay eŋ miŋ kaŋ soo. ");
INSERT INTO moz_vpl VALUES ("AC10_35","074_10_35","ACT","10","35","35","Ti ita ɗuwo pay, wede tuuku yʼottilso a Raa wo yʼisiyo munɗa ki diine maŋ, yoŋ geŋ lekkiyadí i di tʼise uŋse a Raa me. ");
INSERT INTO moz_vpl VALUES ("AC10_36","074_10_36","ACT","10","36","36","A ɗoŋ kʼIzirayel Raa yʼigibo onamí, Rabila Majjaanawa ere ki toose tʼurzi kʼIsa Almasi, yode wede Galmeeʼki ɗuwo pay. ");
INSERT INTO moz_vpl VALUES ("AC10_37","074_10_37","ACT","10","37","37","Kune kun suune Zaŋ yi kazita a ɗuwo, yʼede: “Kun ti suyyo batem”, wo soŋ munɗa wede iina ki poone a siiɗo Galile wo adda siiɗo Ziide pay. ");
INSERT INTO moz_vpl VALUES ("AC10_38","074_10_38","ACT","10","38","38","Wo kun suune mummino Raa yi biiro Isa wede ti geeger Nazaret, yode wede yi-dʼele Unde Kamilen̰ ti toogo ere yi dʼisiyo armika me. Isa geŋ yʼan izire omagi pay, a ɗuwo yʼan dʼisiyo beehiye, kane ɗoŋ an dʼede toogo Meeda siitanɗani a eedaŋ toŋ yʼan dʼeliyo bee kono Raa ti yode. ");
INSERT INTO moz_vpl VALUES ("AC10_39","074_10_39","ACT","10","39","39","Wo kaye ay wulle tʼedayey sulɗi ɗoŋ pay Isa yʼize adda siiɗo Yawudiyagi wo a Zeruzalem me. Yoŋ geŋ deero Yawudiyagi an ti yʼ tiike ekkʼundumu, an di yʼîide. ");
INSERT INTO moz_vpl VALUES ("AC10_40","074_10_40","ACT","10","40","40","Saŋ onniyo sire kʼaɗuwe maŋ Raa yʼa ti yʼ bilɗe ti diine ɗoŋ unto, wo yi dʼele urzi yʼan di gize tuddí. ");
INSERT INTO moz_vpl VALUES ("AC10_41","074_10_41","ACT","10","41","41","A balɗiyadí gette i yʼ wulle Yawudiyagi pay ye, i yʼ wulle kaye ɗoŋ Raa yi biire ti poone kono ay di roota taayadí, kaye ɗoŋ ay dʼiimi wo ay dʼiiɓe ti yode aame Raa yi ti yʼ bilɗe ti diine ɗoŋ unto geŋ me. ");
INSERT INTO moz_vpl VALUES ("AC10_42","074_10_42","ACT","10","42","42","Saŋ Isa yʼay ruute ay di kizite Rabila Majjaanawa a kane Yawudiyagi wo ay di roote Isa yoŋ wede Raa yi biire yʼa ɗekka booro a tukki ɗoŋ zeere wo ɗoŋ i tʼinda pây. ");
INSERT INTO moz_vpl VALUES ("AC10_43","074_10_43","ACT","10","43","43","Kane nebiyagi pay an rootiyo ti yode Isa, anʼde: “Wede tuuku yi ziipa addí a yode maŋ, yʼa tʼoona tambobino kʼolɗikadí tʼurzi toogo ere ki sundí.”» ");
INSERT INTO moz_vpl VALUES ("AC10_44","074_10_44","ACT","10","44","44","Aame Piyer yʼan kazita ɓotto geŋ, a kaamiki Unde Kamilen̰ tʼa ɗiigo a tukki kane ɗoŋ pay ollige onamí gen̰n̰o. ");
INSERT INTO moz_vpl VALUES ("AC10_45","074_10_45","ACT","10","45","45","Maŋ kane Yawudiyagi ɗoŋ i ziipe addaŋ a Isa iido ti Piyer geŋ an ziiɗa giggiraŋ, wo an di zuune kane ɗoŋ Yawudiyagi ye toŋ, Unde Kamilen̰ ere Raa yʼelo gette ti ɗiige a tukki kane pay. ");
INSERT INTO moz_vpl VALUES ("AC10_46","074_10_46","ACT","10","46","46","Kane Yawudiyagi geŋ an ollige ɗoŋ Yawudiyagi ye toŋ, an orbe tʼono ɗoŋ doolo wo an tamma taŋ miibi Raa yoŋ goole a jiire me. Iŋkino Piyer yʼa ruute, yʼede: ");
INSERT INTO moz_vpl VALUES ("AC10_47","074_10_47","ACT","10","47","47","«Aŋkeŋ kane ɗuwo eŋ an uune Unde Kamilen̰ aakede kaye, geŋ ay kʼaane ay gi di-tooge ye an di suyye batem tʼahu me.» ");
INSERT INTO moz_vpl VALUES ("AC10_48","074_10_48","ACT","10","48","48","Maŋ Piyer yʼan di ruute, yʼede: «Ɗuwo eŋ kun tiʼn suyyo batem ti suma kʼIsa Almasi.» Iŋkino maŋ Piyer an di yʼ tunde yʼa lekke onniyto miibi ti kane. ");
INSERT INTO moz_vpl VALUES ("AC11_1","074_11_1","ACT","11","1","1","Ɗoŋ zina kʼIsa ti zemɓa ɗoŋ i ziipe addaŋ a Isa a siiɗo Ziide geŋ, an illiga kane ɗoŋ Yawudiyagi ye toŋ ono Raa an uune. ");
INSERT INTO moz_vpl VALUES ("AC11_2","074_11_2","ACT","11","2","2","Wo aame Piyer yi-gime ki Zeruzalem maŋ, kane Yawudiyagi ɗoŋ i ziipe addaŋ a Isa an di yʼirba, ");
INSERT INTO moz_vpl VALUES ("AC11_3","074_11_3","ACT","11","3","3","wo an i ruute, anʼde: «Ki moo me kee kʼize iŋkino, ki-tʼiide di ɗoŋ i ki walɗu ponde ye wo kʼa iimo ti kane me!» ");
INSERT INTO moz_vpl VALUES ("AC11_4","074_11_4","ACT","11","4","4","Iŋkino maŋ Piyer yʼan dʼiise tôwwo taaya, yi-tʼiise tʼume kʼeesiyo soo ti soo a munɗa wede ize. ");
INSERT INTO moz_vpl VALUES ("AC11_5","074_11_5","ACT","11","5","5","Yʼan di ruute, yʼede: «Aame nuŋ a geeger ki Zoppa ni tondiyo Raa geŋ, munɗa o dʼiido aa suniye. Ni wolliyoʼŋ munɗa i ɗeegu ti Raa ki tuddó, yode geŋ yi deeƴiso aa boojo goole kettiso a bohaní piɗe, munɗa geŋ yi ɗeegu ti kandaane bini a iina aame sirpadó. ");
INSERT INTO moz_vpl VALUES ("AC11_6","074_11_6","ACT","11","6","6","Wo ni wolliyo teɓen̰ kʼadda kʼadde munɗa gen̰n̰o, nʼa wulle seyɗi ɓooze, seyɗi balɗa, seyɗi ɗoŋ i morkimso a siiɗo wo emɓi ɗoŋ oppiyso a kandaane pây. ");
INSERT INTO moz_vpl VALUES ("AC11_7","074_11_7","ACT","11","7","7","Maŋ nʼollige golla tʼo-di ruute, tʼede: “Piyer, ki tʼoozoʼŋ! Seyɗi eŋ ki soɗɗo, kʼa tʼôodo, kʼa tʼaaɗa.” ");
INSERT INTO moz_vpl VALUES ("AC11_8","074_11_8","ACT","11","8","8","Wo nʼa ruute, nʼede: “Galmeegó ato! Nuŋ munɗa wede kʼomɓo ulu, yoŋ ganigi a ɗaanadá geŋ kaŋ soo toŋ ni kʼiimi ye.” ");
INSERT INTO moz_vpl VALUES ("AC11_9","074_11_9","ACT","11","9","9","Golla gette nʼa tʼilliga ki sirwe ti kandaane, tʼede: “Munɗa wede Raa yʼede yo eŋ kamilen̰ geŋ, ki kʼelke aa munɗa wede kʼomɓo ulu ye.” ");
INSERT INTO moz_vpl VALUES ("AC11_10","074_11_10","ACT","11","10","10","Golla gette tʼa ruute ruute taŋ aɗo, saŋ a kaamiki munɗa geŋ a-gili ki kandaane sey. ");
INSERT INTO moz_vpl VALUES ("AC11_11","074_11_11","ACT","11","11","11","Kaciŋ aame geŋ miŋ a kaamiki ɗoŋ aɗo an o igibo ti Sezare, an iido an di nʼuuna adda ɓoy wede kayeʼŋ adda. ");
INSERT INTO moz_vpl VALUES ("AC11_12","074_11_12","ACT","11","12","12","Unde Kamilen̰ tʼo di ruute nʼa iŋgile ti kane daa kʼorgiso. Kane zemɓa ɗoŋ zoot i ziipe addaŋ a Isa ni wiiko ken̰n̰o geŋ, an di nʼigibo a Sezare, wo nuŋ ti kane pay ay tʼiide kʼadda ɓoy Korney. ");
INSERT INTO moz_vpl VALUES ("AC11_13","074_11_13","ACT","11","13","13","Yoŋ yʼay tʼîide taaya mummino maaleeka yʼiide kʼadda ɓoozí yʼa yi wulle, wo yo maaleeka yi di ruute, yʼede: “Ki agiba ɗuwo ki geeger Zoppa, an di waako Simo wede sundí soo an yi waaku Piyer, yʼa etto. ");
INSERT INTO moz_vpl VALUES ("AC11_14","074_11_14","ACT","11","14","14","Yoŋ yʼa di roota ono a urzi wede saŋ kun tʼooney uttiyo, kee ti ɗoŋ ɓoozá pay.” ");
INSERT INTO moz_vpl VALUES ("AC11_15","074_11_15","ACT","11","15","15","Aame Korney yʼa ti ɗiŋge taayadí wo nʼa tʼeese tôwwo taayadó ɓotto geŋ, Unde Kamilen̰ tʼa ɗiige a tuddaŋ aa ti ɗiige a tukki kaye tʼume kʼeesiyo. ");
INSERT INTO moz_vpl VALUES ("AC11_16","074_11_16","ACT","11","16","16","Iŋkino maŋ nʼa ilke a ono Galmeega yi ruute, yʼede: “Zaŋ ɗuwo yiʼni zuyyite batem tʼahu, wo ɗe kuneʼŋ Raa yʼun tiʼn suyya batem tʼUnde Kamilen̰.” ");
INSERT INTO moz_vpl VALUES ("AC11_17","074_11_17","ACT","11","17","17","Ni wulle kane toŋ Raa yʼan ele Undí aa yʼay ele a kaye, aame ay ziipe addey a Galmeega Isa Almasi. Iŋkino maŋ, nuŋ wee wee nʼa aane nʼa tʼeegire Raa a munɗa yi dehu yʼaase me?» ");
INSERT INTO moz_vpl VALUES ("AC11_18","074_11_18","ACT","11","18","18","Saŋ ono geŋ ɗuwo an tiʼn illiga maŋ, kane pay an dʼinniga wo an dʼiise tamma Raa, anʼde: «Ki kotto Raa a ɗoŋ Yawudiyagi ye toŋ, urzi yʼan ele an di-kime lekkiyadaŋ wo an tʼoona lekkiyo ere ki kotto.» ");
INSERT INTO moz_vpl VALUES ("AC11_19","074_11_19","ACT","11","19","19","Aame Etiyeŋ an yʼîide maŋ, an dʼiise dabirsa ɗoŋ i ziipe addaŋ a Isa. Iŋkino maŋ kane geŋ an di-tiipite ki siiɗiyagi doolo. Ɗoŋ oŋgo ti diinayaŋ an dʼiŋgile ki siiɗo Pinisi, ki siiɗo Siipire, wo ki geeger kʼAntiyos, wo an di kazita ono Raa a ɗoŋ Yawudiyagi ɗaŋŋal. ");
INSERT INTO moz_vpl VALUES ("AC11_20","074_11_20","ACT","11","20","20","Aame geŋ ɗoŋ miibi ti diine kane ɗoŋ i ziipe addaŋ a Isa iido ti Siipire wo ti siiɗo Sireŋ geŋ, an dʼiŋgile ki Antiyos, wo an di gizite kay Rabila Majjaanawa ki Galmeega Isa a ɗoŋ Yawudiyagi ye. ");
INSERT INTO moz_vpl VALUES ("AC11_21","074_11_21","ACT","11","21","21","Toogo Galmeega ti kane, iŋkino ɗoŋ ɓaadaŋ an di-gime lekkiyadaŋ, wo an di ziipe addaŋ a Galmeega. ");
INSERT INTO moz_vpl VALUES ("AC11_22","074_11_22","ACT","11","22","22","Ɗoŋ ogiyso ti suma kʼIsa a Zeruzalem geŋ rabila gette an tʼiire kuudaŋ, maŋ an dʼigibe Barnabas ki Antiyos kono yʼa ette yʼa wollo. ");
INSERT INTO moz_vpl VALUES ("AC11_23","074_11_23","ACT","11","23","24","Barnabas geŋ yoŋ wede beehiye, yi ziipe addí pay a Isa wo addiŋ ôoniyo ti Unde Kamilen̰. Aame yʼiiney a Antiyos wo yi wulle ɗoŋ i ziipe addaŋ a Isa geŋ Raa yʼan ti ziipe beeko maŋ, ulbí i-dʼize uŋse ɓaadaŋ, wo yʼan dʼeele kooke pay kono an di lekke kettiyo ti Galmeega. Wo aame geŋ ɗoŋ ɓaadaŋ an a-ti giƴƴe ti Galmeega. ");
INSERT INTO moz_vpl VALUES ("AC11_25","074_11_25","ACT","11","25","25","Saŋ maŋ Barnabas yʼa iŋgile ki Tarsi kono yʼa waako Sool. ");
INSERT INTO moz_vpl VALUES ("AC11_26","074_11_26","ACT","11","26","26","Aame yi yʼuuno maŋ, yʼa ti yʼ wiiko an tʼiido kʼAntiyos. Maŋ kane sirwaŋ ozzine an di yʼiiɗiba ti ɗoŋ ogiyso ti suma kʼIsa aŋgen̰n̰o, wo an di duuye ɗoŋ ɓaadaŋ a urzi zaapu kʼaddaŋ a Isa. Geŋ a Antiyos gen̰n̰o sanalliyagi kʼIsa an diʼn wiike waaku ere ki poone «ɗoŋ kʼAlmasi». ");
INSERT INTO moz_vpl VALUES ("AC11_27","074_11_27","ACT","11","27","27","Aame geŋ i dʼede nebiyagi an ɗiigo ti Zeruzalem an tʼiide ki Antiyos. ");
INSERT INTO moz_vpl VALUES ("AC11_28","074_11_28","ACT","11","28","28","Nebi soo ti diinayaŋ sundí Agabus, Unde Raa ti di ruute adda kʼaddí, yʼa tʼiiziga yʼa ruute, yʼede: «Saŋ i dʼisa mosogo ɓaadaŋ adda siiɗiyagi ɗoŋ pay ɗoŋ Romeŋ ge dokkiyo.» Wo kun suune mosogo gette ize aame Kilood yoŋ mozigo goole ki Romeŋ. ");
INSERT INTO moz_vpl VALUES ("AC11_29","074_11_29","ACT","11","29","29","Aame kane sanalliyagi kʼIsa an illiga iŋkino maŋ, an di dihe an tusse munɗa wede tuuku toŋ a toogadí, an di-tʼigibe ki noogiyo zemɓa i lekkiyo a siiɗo Ziide. ");
INSERT INTO moz_vpl VALUES ("AC11_30","074_11_30","ACT","11","30","30","Iŋkino maŋ an tusse, an an dʼele a bey Barnabas ti Sool, an dʼiide an an dʼele a bey ɗoŋ dokkiyo ki zemɓa ɗoŋ a Ziide. ");
INSERT INTO moz_vpl VALUES ("AC12_1","074_12_1","ACT","12","1","1","Aame geŋ mozigo Erod yʼa iise dabirsa zemɓa oŋgoŋ ti diine ɗoŋ ogiyso ti suma kʼIsa. ");
INSERT INTO moz_vpl VALUES ("AC12_2","074_12_2","ACT","12","2","2","Yʼan dʼele urzi a asigiryagi, Zak leema Zaŋ an di yʼîide ti seebir. ");
INSERT INTO moz_vpl VALUES ("AC12_3","074_12_3","ACT","12","3","3","Wo aame Erod yi wulle a Yawudiyagi an tʼize uŋse maŋ, yʼan dʼele urzi Piyer toŋ an ti yʼ seeɗo a onniytagi ɗoŋ ki tarnaape wede an dʼomɓo mappa daa kʼorme. ");
INSERT INTO moz_vpl VALUES ("AC12_4","074_12_4","ACT","12","4","4","Aame an ti yʼ ziiɗo maŋ, an di yʼele adda daŋgay, wo Erod yʼa-ti zippe asigiryagi koomat makumu zoot, yʼa tiʼn dikkiɗa omagi piɗe, an di yʼ boohe. Yi dehu yʼa ɗekka booradí a ɗaana ɗuwo pay aame tarnaape Pak ki Yawudiyagi yi tʼiŋgila maŋ. ");
INSERT INTO moz_vpl VALUES ("AC12_5","074_12_5","ACT","12","5","5","Iŋkino maŋ Piyer yi lekkiyo daŋgay wo kane ɗoŋ ogiyso ti suma kʼIsa geŋ an tondiyo Raa daa puukiyo wo tʼaddaŋ pay kono yode. ");
INSERT INTO moz_vpl VALUES ("AC12_6","074_12_6","ACT","12","6","6","A diɗɗo ere soggo Erod yʼa ɗekka booro ki Piyer a ɗaana ɗuwo pay gette, Piyer geŋ yi moone a diine kʼasigiryagi sire, beyɗíʼŋ kettiso ti ziŋziri sire, wo a biza daŋgay ummey asigiryagi sey an boohiyo. ");
INSERT INTO moz_vpl VALUES ("AC12_7","074_12_7","ACT","12","7","7","A kaamiki maaleeka ki Galmeega Raa yʼa ɗiige adda daŋgay, biino ere Piyer adda gette a-tuure keren̰. Maŋ maaleeka yʼa yi butte Piyer a sirpadí kono yʼa-tʼinne, wo yi di ruute, yʼede: «Kesiko ki tʼoozo!» Maŋ ziŋziri ti beyɗí a tiipe. ");
INSERT INTO moz_vpl VALUES ("AC12_8","074_12_8","ACT","12","8","8","Saŋ maaleeka yi di ruute, yʼede: «Ki-ketto tooná wo ki tʼosso toɓiyagá.» Piyer yʼa tʼize aa maaleeka yi ruute, wo yi di ruute sey, yʼede: «Ki tʼosso kallayá goole wo kʼa ni daani.» ");
INSERT INTO moz_vpl VALUES ("AC12_9","074_12_9","ACT","12","9","9","Iŋkino maŋ Piyer yʼa diine maaleeka, tʼadda daŋgay yʼa tʼuɗɗe, wo a elkiyadí yi ki zuune ye munɗa wede maaleeka yʼisiyo geŋ ɗerec me, yʼelkiyo i-iido munɗa aa suniye. ");
INSERT INTO moz_vpl VALUES ("AC12_10","074_12_10","ACT","12","10","10","An tʼuɗɗe tʼume kʼasigiryagi ɗoŋ ki poone, ti ɗoŋ ki sirwe toŋ an a-tʼuɗɗe pây, an dʼiiney a biza wede ki maala kʼa-tʼaɗɗe kʼadda geeger. Biza geŋ a tʼihina siidí a ɗaanadaŋ me, wo an tʼuɗɗe maŋ an dʼizire kaŋ soo a urzi, saŋ a kaamiki n̰okkot maaleeka yi yʼiili Piyer me. ");
INSERT INTO moz_vpl VALUES ("AC12_11","074_12_11","ACT","12","11","11","Iŋkino maŋ Piyer eedí tʼa iido, yʼa yi zuune munɗa wede i-iido me, wo yʼa ruute, yʼede: «Aŋkeŋ ni zuune baa geŋ ɗerec, Galmeega Raa yʼigibo maaleeka yʼa-nʼuɗɗe ti bey kʼErod wo ti munɗa wede ulsu Yawudiyagi an dehu an oo dʼise me.» ");
INSERT INTO moz_vpl VALUES ("AC12_12","074_12_12","ACT","12","12","12","Aame yi zuune iŋkino maŋ, yʼa iŋgile ki ɓoy kʼerewo sundutú Mariyam mekki Zaŋ, sundí soo Markus. Adda ɓoy geŋ ɗoŋ ɓaadaŋ an tʼugiye an tondiyo Raa. ");
INSERT INTO moz_vpl VALUES ("AC12_13","074_12_13","ACT","12","13","13","Piyer yʼiideʼŋ yi koppiyo biza yi-tʼette, wo i dʼede ere naabo sundutú Rood, tʼa iido tʼa-tʼihina biza. ");
INSERT INTO moz_vpl VALUES ("AC12_14","074_12_14","ACT","12","14","14","Aame tʼilligaʼŋ golla ki Piyer tʼa ti zuune, wo todʼte ulbutú a ûune tʼuŋsuwo ɓaadaŋ. Iŋkino maŋ tʼa-tʼihina biza umbo, tʼa-gime kaŋ okko, tʼan di ruuto, tʼede: «Piyer yo en̰n̰o a biza.» ");
INSERT INTO moz_vpl VALUES ("AC12_15","074_12_15","ACT","12","15","15","Kane an i-di ruute, anʼde: «Koŋ mi tʼokko maade ko?» Wo ɗe todʼ tʼa ruute, tʼede: «Ki kotto yo a biza.» Iŋkino maŋ kane an di ruute, anʼde: «Geŋ maaleekayí koo maŋ.» ");
INSERT INTO moz_vpl VALUES ("AC12_16","074_12_16","ACT","12","16","16","Iŋkino yo Piyer geŋ yi koppiyo biza pi bini an dʼiido, an i-tʼihina. An yi wulle maŋ, an ziiɗa giggiraŋ. ");
INSERT INTO moz_vpl VALUES ("AC12_17","074_12_17","ACT","12","17","17","Maŋ yʼan dʼize likuw ti beezí kono an dʼanniga, wo yʼan tʼîide taaya mummino Galmeega yi-yʼuɗɗo ti daŋgay me. Yʼan di ruute sey, yʼede: «A Zak wo a zemɓa oŋgo toŋ, kun an tʼôodoy taaya.» Saŋ tʼume kane yʼaa tʼuɗɗe, yʼa iŋgile kʼume doolo. ");
INSERT INTO moz_vpl VALUES ("AC12_18","074_12_18","ACT","12","18","18","Ume i tʼumpile maŋ asigiryagi an wolliyo Piyer umbo, undaŋ a tʼuɗɗe, an dʼiise tondiso, anʼde: «Ɗe Piyer a yʼihe moo me?» ");
INSERT INTO moz_vpl VALUES ("AC12_19","074_12_19","ACT","12","19","19","Mozigo Erod yʼa igibe ɗuwo ki dehuzí, wo an ki yʼuuno ye. Maŋ yʼanni wiike kane asigiryagi ɗoŋ i yi boohiyo me, yʼanni tundite ti kulkuwo, yʼede: «Ɗe Piyer kun i ize mummino!» Iŋkino maŋ yʼan di ruute a asigiryagi doolo an tiʼn ôodo. Saŋ maŋ Erod yʼa tʼiiziga ti siiɗo Ziide, yʼa-lekko a geeger Sezare onniyto miibi. ");
INSERT INTO moz_vpl VALUES ("AC12_20","074_12_20","ACT","12","20","20","Iŋkino maŋ kane ɗoŋ geegiryagi Tir ti Sidoŋ geŋ, an ooniyo omɓo ti siiɗo ki mozigo Erod, wo aame geŋ yoŋ yi ti gulkuwe ɓaadaŋ ti kane ɗoŋ siiɗo geŋ me. Maŋ kane ɗoŋ pay geŋ an tʼîide onamaŋ kaŋ soo, an tʼoone urzi ki toose ti Erod. Maŋ an dʼuuney wede soo sundí Bilastus, yoŋ geŋ wede boohiyo biino mozigo. Kane an iide an ti yʼ ŋiiƴa, yʼan dʼan tʼette kʼume mozigo Erod. ");
INSERT INTO moz_vpl VALUES ("AC12_21","074_12_21","ACT","12","21","21","Iŋkino maŋ Erod yʼan dʼele onniyo, wo aame onniyo gette tʼiina maŋ yi-tʼusse kallayí ki moziko, yʼa-guune kaakido booro, yʼa iise rootiyto a ɗaana ɗuwo pay. ");
INSERT INTO moz_vpl VALUES ("AC12_22","074_12_22","ACT","12","22","22","Ɗoŋ ollige geŋ an dʼiise ɗollite, anʼde: «En̰n̰o eŋ i rootiyto wedusu ye, eŋ raayusu!» ");
INSERT INTO moz_vpl VALUES ("AC12_23","074_12_23","ACT","12","23","23","Aame Erod yʼilliga ono ɗuwo gen̰n̰o maŋ, ulbí uŋse tuddí yʼa ti-gili, tamma gette yi-kʼiili a Raa ye. Iŋkino maŋ a kaamiki, maaleeka ki Galmeega Raa yʼa yi diin̰e ti eeni, ondirɗagi adda kʼaddí an di yʼiimi, yʼa inda. ");
INSERT INTO moz_vpl VALUES ("AC12_24","074_12_24","ACT","12","24","24","Tiŋ geŋ ono Raa i-teepiyo ki ɗaana ki ɗaana, wo ɗoŋ ɓaadaŋ an di ziipe addaŋ a Isa. ");
INSERT INTO moz_vpl VALUES ("AC12_25","074_12_25","ACT","12","25","25","Aame Pool ti Barnabas a zina ere an an igibe ki noogiyo ɗuwo a Zeruzalem an aa ti-ɗiŋge maŋ, an a-ti yʼ wiike ti kane Zaŋ wede sundí soo Markus, an di-gime ki Antiyos. ");
INSERT INTO moz_vpl VALUES ("AC13_1","074_13_1","ACT","13","1","1","Tʼadda diine ɗoŋ ogiyso ti suma kʼIsa a Antiyos geŋ, i dʼede nebiyagi wo ɗoŋ dooyiso: Barnabas, Simeyoŋ an yi waaku sundí soo Bakulu, Lisiyus ti siiɗo Sireŋ, Manayen wede an iiziga kaŋ soo ti Erod wede mozigo a siiɗo Galile, wo Sool. ");
INSERT INTO moz_vpl VALUES ("AC13_2","074_13_2","ACT","13","2","2","Onniyo soo, an tʼugiye an ottilso a Galmeega wo an di lekkiyo daa kʼomɓo, aame geŋ Unde Kamilen̰ tʼan di ruute, tʼede: «Barnabas ti Sool geŋ kun oo tiʼn ooyo siidaŋ ki naabo ere nuŋ niʼni wiike.» ");
INSERT INTO moz_vpl VALUES ("AC13_3","074_13_3","ACT","13","3","3","Iŋkino maŋ aame an ti likke daa kʼomɓo wo an tunde Raa geŋ, zemɓa an an di ziipe beeko wo an diʼn iili Barnabas ti Sool, an dʼiŋgile. ");
INSERT INTO moz_vpl VALUES ("AC13_4","074_13_4","ACT","13","4","4","Iŋkino maŋ Barnabas ti Sool Unde Kamilen̰ tiʼn agisa naabo geŋ, an dʼiŋgile an tʼiide ki geeger Selusi. Tiŋ geŋ an dʼuune tooko, an di-gili an dʼiŋgile ki Siipire, siiɗo ere a diine kʼahu. ");
INSERT INTO moz_vpl VALUES ("AC13_5","074_13_5","ACT","13","5","5","An iiney a geeger Salamin a Siipire maŋ, an dʼiise kazita kʼono Raa adda ɓoyɗi ɗoŋ Yawudiyagi ge dooyiso. Aame geŋ Zaŋ Markus toŋ yoŋ ti kane yʼan diʼn noogiyo. ");
INSERT INTO moz_vpl VALUES ("AC13_6","074_13_6","ACT","13","6","6","Aame an ti diipiɗa siiɗo Siipire maŋ, an dʼiiney geeger Papos. A ume geŋ an dʼikkima ti Yawudusu soo sundí Bar-Zezu, yode geŋ kombiɗe, yi ti tʼisiyo tuddí aa nebi, ");
INSERT INTO moz_vpl VALUES ("AC13_7","074_13_7","ACT","13","7","7","yoŋ yi lekkiyo a sirpa goole ki Romeŋ adda siiɗo gettiyo. Wede goole siiɗo geŋ sundí Serziyus Poolus, yoŋ wede eedí soodo a elkiso. Yode geŋ yʼanni wiike Barnabas kane ti Sool di yode kono yi dehu yʼa olliga ono Raa. ");
INSERT INTO moz_vpl VALUES ("AC13_8","074_13_8","ACT","13","8","8","Wo kombiɗe geŋ sundí soo tʼono Girek an yi waaku Elimas geŋ, yʼan di-tuuge a Barnabas ti Sool me kono yi ki dehu ye goole siiɗo yʼa zaape addí a Isa me. ");
INSERT INTO moz_vpl VALUES ("AC13_9","074_13_9","ACT","13","9","9","Iŋkino maŋ Unde Kamilen̰ ti-tʼûune adda kʼadde Sool sundí soo Pool, yi di yʼ wolliyo wedeʼŋ geŋ ƴerere adda kʼedayí, ");
INSERT INTO moz_vpl VALUES ("AC13_10","074_13_10","ACT","13","10","10","wo yi di ruute, yʼede: «Kee wede adda ûune ti metiŋko wo ti bundiko! Kee ulo Meeda siitanɗani! Kee adu ki sulɗi ɗoŋ pay ki diine, ki dehu daayum urziyagi ɗoŋ ɗelele ki Galmeega ki di tiʼn lette. ");
INSERT INTO moz_vpl VALUES ("AC13_11","074_13_11","ACT","13","11","11","Wo aŋkeŋ kʼollo, Galmeega yʼa ki daan̰a, kʼa koosa suma kʼonniyo miibi toore peeɗo ki ki yʼ wolla ye.» A kaamiki yʼa-guuse, yoŋ aa adda zimolo, yi-kama ken̰n̰o ken̰n̰o yi dehu wenɗa yi seeɗa a beezí yʼa ti yʼ dokke. ");
INSERT INTO moz_vpl VALUES ("AC13_12","074_13_12","ACT","13","12","12","Aame goole siiɗo geŋ yi wulle munɗa wede i iina a Elimas gen̰n̰o maŋ, yʼa ziipe addí a Galmeega kono dooyiso gette i yʼ ziiɗa ɓaadaŋ. ");
INSERT INTO moz_vpl VALUES ("AC13_13","074_13_13","ACT","13","13","13","Wo Pool ti ɗoŋ a itadí an tʼiiziga ti Papos, an di-gili adda tooko, an dʼiŋgile ki geeger Perz a siiɗo Pampili, wo aame an iiney maŋ Zaŋ Markus yiʼn iili, yʼa-gime ki Zeruzalem. ");
INSERT INTO moz_vpl VALUES ("AC13_14","074_13_14","ACT","13","14","14","Maŋ ti Perz geŋ kane an tʼiiziga, an dʼiŋgile ki geeger kʼAntiyos siiɗo Pizidi. An iiney Antiyos geŋ, a onniyo ere ki puukiyo Yawudiyagi an tʼiide adda ɓoy wede Yawudiyagi ge dooyiso, an di-gunɗite. ");
INSERT INTO moz_vpl VALUES ("AC13_15","074_13_15","ACT","13","15","15","Aame kane ɗuwo geŋ an gire adda mattup kʼoogoro Muusa ti ono ɗoŋ ki nebiyagi maŋ, ɗoŋ deero ki ɓoy geŋ an an di ruute, anʼde: «Zemɓa ki nuŋ, aame un ede ono ki kooke a ɗuwo en̰n̰o maŋ, kun an eelo.» ");
INSERT INTO moz_vpl VALUES ("AC13_16","074_13_16","ACT","13","16","16","Iŋkino maŋ Pool yʼa tʼiiziga, yʼan dʼize likuw ti beezí kono an dʼanniga, maŋ yʼa ruute, yʼede: «Kune ɗoŋ kʼIzirayel, wo kune ɗoŋ Yawudiyagi ye ɗoŋ ottilso a Raa, kun nʼollo. ");
INSERT INTO moz_vpl VALUES ("AC13_17","074_13_17","ACT","13","17","17","Raa wede ki kine ɗoŋ kʼIzirayel yʼa biire moŋgiɗagiŋ. Yʼan iigila aame kane an lekkiyo a siiɗo Misir, saŋ ti toogadí yʼan uɗɗo ti siiɗo gette. ");
INSERT INTO moz_vpl VALUES ("AC13_18","074_13_18","ACT","13","18","18","Adda kʼozzine ette suma kʼada piɗe, Raa yʼanni muɗɗe adda balɗa me. ");
INSERT INTO moz_vpl VALUES ("AC13_19","074_13_19","ACT","13","19","19","Saŋ maŋ ita ɗuwo sarat adda siiɗo Kanahaŋ gette Raa yʼa-tʼuute, yʼan dʼele siiɗo kane gette aa korɓite a ɗoŋzí. ");
INSERT INTO moz_vpl VALUES ("AC13_20","074_13_20","ACT","13","20","20","Sulɗi pay geŋ i tʼiŋgile a îide ozzine suma meeda piɗe uto ada paat. Maŋ Raa yi biire ɗoŋ ɗekkiyo booro a ekki moŋgiɗagiŋ, an di wolliyo onamaŋ bini nebi Samiyel. ");
INSERT INTO moz_vpl VALUES ("AC13_21","074_13_21","ACT","13","21","21","Aame Samiyel yoŋ nebi geŋ, moŋgiɗagiŋ an tunde Raa yʼan tʼeele mozigo. Maŋ Raa yʼan dʼeele Sayul ulo Kis ti biza bumɓu Benzamen, yʼiimi mozikadí ozzinagi ada piɗe. ");
INSERT INTO moz_vpl VALUES ("AC13_22","074_13_22","ACT","13","22","22","Saŋ maŋ Raa yʼa ti ɗiige Sayul me, yʼa di ziipe Dawut mozigo me, yoŋ geŋ wede Raa yʼa ruute sundí, yʼede: “Ni uune Dawut ulo Zeese, yoŋ geŋ wede aa addó i dehu, yʼaasa naabo ere pay aa ni dehu.” ");
INSERT INTO moz_vpl VALUES ("AC13_23","074_13_23","ACT","13","23","23","Ti ita kʼin̰n̰i Dawut geŋ Raa yi dʼiiɗiba wede soo sundí Isa, yoŋ Wede kʼUttiyo ki ɗoŋ kʼIzirayel. Geŋ iŋkino Raa yʼa-ti ɗiŋge ono ɗoŋ yi ruute yʼaasa me. ");
INSERT INTO moz_vpl VALUES ("AC13_24","074_13_24","ACT","13","24","24","Ki poone Isa yʼa aana geŋ, Zaŋ Batis yʼa iido yʼa gizite a ɗoŋ kʼIzirayel pay kono an di-kime lekkiyadaŋ wo yʼa tiʼn suyye batem. ");
INSERT INTO moz_vpl VALUES ("AC13_25","074_13_25","ACT","13","25","25","Aame Zaŋ yi zuune naabadí goppoŋ ti ɗaŋga maŋ, yʼa ruute, yʼede: “Kune kun elkiyo nuŋ wee wee? Nuŋ Almasi wede kun delliyo gen̰n̰o ye. Wo ɗe wede ettiyo kʼitadó geŋ, yoŋ nuŋ batum ni kʼîide nʼa ki tʼeeze sibe toɓiyagí ye.” ");
INSERT INTO moz_vpl VALUES ("AC13_26","074_13_26","ACT","13","26","26","Zemɓa ki nuŋ, kune ɗoŋ ti ita kʼin̰n̰i kʼIbirayim wo kune ɗoŋ ottilso a Raa, ono ɗoŋ kʼuttiyo eŋ Raa yiʼn elo a kine. ");
INSERT INTO moz_vpl VALUES ("AC13_27","074_13_27","ACT","13","27","27","Aame Isa yʼiina maŋ, ɗoŋ Zeruzalem ti deerizaŋ an ki yʼ zuune ye Isa wede Raa yʼigibo me, wo ono nebiyagi ɗoŋ an gariya daayum a onniyo ere ki puukiyadiŋ gen̰n̰o toŋ, itadaŋ an kiʼn zuune ye. Wo ɗe an dʼize kono booro tʼa yi ziiɗa ki tôwwo, a-tʼiide a ono nebiyagi an ruute ti kaaga. ");
INSERT INTO moz_vpl VALUES ("AC13_28","074_13_28","ACT","13","28","28","Kane ɗuwo geŋ munɗa wede an tʼoone a tukki yode a tʼîde ki tôwwadí umbo, wo toŋ maŋ an di tunde Pilat yʼa tʼele urzi ki tôwwadí. ");
INSERT INTO moz_vpl VALUES ("AC13_29","074_13_29","ACT","13","29","29","Iŋkino a munɗa wede kane an ize geŋ a-tʼiide a ono ɗoŋ pay an riiŋe ti kaaga adda mattup ki Raa a tukki yode, maŋ kane Yawudiyagi an ti yʼ ɗiige tʼekkʼundumu me, wo an di yʼeele adda muuzo. ");
INSERT INTO moz_vpl VALUES ("AC13_30","074_13_30","ACT","13","30","30","Wo ɗe Raa yʼa ti yʼ bilɗe ti diine ɗoŋ unto me. ");
INSERT INTO moz_vpl VALUES ("AC13_31","074_13_31","ACT","13","31","31","Saŋ maŋ yʼan di gize tuddí taŋ ɓaadaŋ a en̰n̰o en̰n̰o, a ɗoŋzí ɗoŋ an gilo kaŋ soo ti siiɗo Galile ki Zeruzalem, wo aŋkeŋ kane geŋ an di rootiyo taayadí a ɗaana Yawudiyagi pay. ");
INSERT INTO moz_vpl VALUES ("AC13_32","074_13_32","ACT","13","32","33","Iŋkino maŋ ono ɗoŋ Raa yi ruute yʼaasa a moŋgiɗagiŋ ti kaaga geŋ, aŋkeŋ yʼa tiʼn ɗiŋge a kine in̰n̰izaŋ, aame Isa yi ti yʼ bilɗe ti diine ɗoŋ unto geŋ me. Wo aŋkeŋ Rabila Majjaanawa gette kaye batum ay iido, ay un di kizite. Raa yʼize iŋkino aa an riiŋe ti kaaga adda mattup ki Soom sire, anʼde: “Kee ulo nuŋ me, wo ti aŋki ɗuwo an di suune nuŋ Meegá.” ");
INSERT INTO moz_vpl VALUES ("AC13_34","074_13_34","ACT","13","34","34","Wo Raa yi ruute ti kaaga, yoŋ yʼa ti yʼ balɗa ti diine ɗoŋ unto kono yʼa ki ruuma ye. Geŋ Raa yi ruute iŋkino, yʼede: “Nʼun di zaapa beeko ere kamilen̰ wo sulɗi ɗoŋ ɗerec ni ruute ni-tʼela a Dawut.” ");
INSERT INTO moz_vpl VALUES ("AC13_35","074_13_35","ACT","13","35","35","Kono kamo Dawut yʼa ruute sey adda mattup ti doolo, yʼede: “Ki oola tudde ki wedizá kamilen̰ i-ruuma adda muuzo ye.” ");
INSERT INTO moz_vpl VALUES ("AC13_36","074_13_36","ACT","13","36","36","Wo Dawut yoŋ a koɗuwadí yʼa niibe naabo Raa wo saŋ yʼa inda, an di yʼele adda muuzo aame moŋgiɗagí, wo tuddí a ruume. ");
INSERT INTO moz_vpl VALUES ("AC13_37","074_13_37","ACT","13","37","37","Wo yode wede Raa yʼa ti yʼ bilɗe ti diine ɗoŋ unto geŋ, tuddí i ki ruume adda muuzo ye. ");
INSERT INTO moz_vpl VALUES ("AC13_38","074_13_38","ACT","13","38","39","Zemɓa ki nuŋ, ni dehu kun di suune, tʼurzi kʼIsa an un di kazita kun dʼooniyo tambobino kʼolɗikaguŋ. Wo tʼurzi yode, wede tuuku yi ziipe addí a yode maŋ, yoŋ geŋ Raa yi yʼ wolliyo ki diine a ɗaanadí me. Ɗerec, oogoro Muusa ti kʼiine tʼun gi diʼn ize ɗoŋ ki diine a ɗaana Raa ye. ");
INSERT INTO moz_vpl VALUES ("AC13_40","074_13_40","ACT","13","40","40","Iŋkino kun koona mentikagi, kono un ki dʼaana ye munɗa wede nebiyagi an riiŋe ti kaaga, anʼde: ");
INSERT INTO moz_vpl VALUES ("AC13_41","074_13_41","ACT","13","41","41","“Kun ollo bee kune ɗoŋ okko maade Raa geŋ, kun sooɗo giggirguŋ wo kun di n̰okkiɗo, kono a lekkiyaguŋ ette ni dʼisa munɗa wede kun dʼaddira, wo munɗa geŋ aame wenɗa yʼun ruuta toŋ maŋ, kun kʼamɓa ye.”» ");
INSERT INTO moz_vpl VALUES ("AC13_42","074_13_42","ACT","13","42","42","Aame Pool ti Barnabas an aɗɗiya ti ɓoy wede Yawudiyagi ge dooyiso geŋ, kane ɗoŋ duuru an diʼn tunde, anʼde: «Soŋŋo a onniyo ere ki puukiyo kun di kami, kun ay kizita sey ono eŋ me.» ");
INSERT INTO moz_vpl VALUES ("AC13_43","074_13_43","ACT","13","43","43","Aame ti ogiyso an ti tiipe maŋ, ɗoŋ ɓaadaŋ Yawudiyagi, ti ɗoŋ Yawudiyagi ye an ti tʼize tuddaŋ Yawudiyagi an dʼottilso a Raa pây, an di diine Pool kane ti Barnabas. Kane geŋ an an di kazita ono Raa, wo an an dʼeliyo kooke an di lekke ki diine a urzi beeko ere ki Raa. ");
INSERT INTO moz_vpl VALUES ("AC13_44","074_13_44","ACT","13","44","44","Onniyo ere ki puukiyo Yawudiyagi tʼiina maŋ, ɗoŋ ɓaadaŋ ti diine ɗoŋ adda geeger gette an tʼugiye, an dʼollige ono Galmeega ɗoŋ Pool ti Barnabas an kazita. ");
INSERT INTO moz_vpl VALUES ("AC13_45","074_13_45","ACT","13","45","45","Wo aame kane Yawudiyagi an wulle ɗoŋ duuru gen̰n̰o maŋ, kolɓiso tʼa jiire eedaŋ, an dʼiise kalɗita Pool anʼde, onamí yi rootiyo geŋ lohito. ");
INSERT INTO moz_vpl VALUES ("AC13_46","074_13_46","ACT","13","46","46","Iŋkino maŋ Pool ti Barnabas an an di ruute daa kʼorgiso, anʼde: «Ki kotto, ki pooneʼŋ a kune Yawudiyagi ay un di kizite ono Raa me. Wo ɗe kune kun ti-tuuge kʼollige kʼono Raa geŋ, aa kune batum kun ɗikke booro a egguŋ, lekkiyo ere ki daayum kun ki ti tʼoona ye. Iŋkino kaye ay dʼamɓe ki tukki ɗoŋ Yawudiyagi ye, ");
INSERT INTO moz_vpl VALUES ("AC13_47","074_13_47","ACT","13","47","47","kono en̰n̰o munɗa wede Galmeega yʼay ruute ay dʼise me, yʼede: “Nuŋ ni ki ziipe aa toore ki ita ɗuwo pay, kono kʼan dʼetta tʼuttiyo ere ki Raa bini ɗaŋgu siiɗo pay.”» ");
INSERT INTO moz_vpl VALUES ("AC13_48","074_13_48","ACT","13","48","48","Aame kane ɗoŋ Yawudiyagi ye an illiga ono gen̰n̰o maŋ, an tamma Raa wo an di ruute, anʼde: «Ono Galmeega eŋ uŋse ɓaadaŋ.» Wo kane ɗoŋ pay Raa yi biire an tʼoona lekkiyo ere ki daayum geŋ, an di ziipe addaŋ a Isa. ");
INSERT INTO moz_vpl VALUES ("AC13_49","074_13_49","ACT","13","49","49","Iŋkino maŋ ono Galmeega a-tiipe adda siiɗo gette pay. ");
INSERT INTO moz_vpl VALUES ("AC13_50","074_13_50","ACT","13","50","50","Wo kane Yawudiyagi geŋ an an tʼelite ono a erayi ɗoŋ sundaŋ ti môolo wo an ottilso a Raa, ti ɗoŋ deero adda geeger. Kane pay geŋ an an tʼelite ono a ɗoŋ duuru, an di dibire Pool ti Barnabas, wo ti siiɗadaŋ an diʼn ilmi. ");
INSERT INTO moz_vpl VALUES ("AC13_51","074_13_51","ACT","13","51","51","Kane sire geŋ odde zoŋɗaŋ an an ti yʼ tuttige, wo an dʼiŋgile ki geeger kʼIkoniyoŋ. ");
INSERT INTO moz_vpl VALUES ("AC13_52","074_13_52","ACT","13","52","52","Wo kane sanalliyagi kʼIsa a Antiyos siiɗo Pizidi geŋ, an di lekkiyo addaŋ ôoniyo tʼUnde Kamilen̰ wo ulbaŋ uŋse. ");
INSERT INTO moz_vpl VALUES ("AC14_1","074_14_1","ACT","14","1","1","Aame Pool ti Barnabas an iiney a Ikoniyoŋ maŋ, an dʼiŋgile an tʼiide adda ɓoy wede Yawudiyagi ge dooyiso, aa an dʼizo a Antiyos. Aame an iise kazita kʼono Raa geŋ, Yawudiyagi ɓaadaŋ ti ɗoŋ Yawudiyagi ye an di ziipe addaŋ a Isa. ");
INSERT INTO moz_vpl VALUES ("AC14_2","074_14_2","ACT","14","2","2","Wo ɗe kane Yawudiyagi ɗoŋ i-tuuge ki zaapu kʼaddaŋ a Isa geŋ, an an tʼelite ono a kane ɗoŋ Yawudiyagi ye kono an di-kime elkisadaŋ, an di kulkuwe ti kane zemɓa gen̰n̰o. ");
INSERT INTO moz_vpl VALUES ("AC14_3","074_14_3","ACT","14","3","3","Wo toŋ maŋ Pool ti Barnabas an di likke onniyo ɓaadaŋ adda geeger gette. An di gizite ono Raa tʼadde soo, orgiso adda kʼaddaŋ umbo kono Galmeega ti kane. Wo yoŋ yʼan dʼeliyo toogo kʼisiyo sulɗi kʼarmika ti sulɗi ɗoŋ i ceeriyo eego, i-kaza onamaŋ a urzi beeko Galmeega geŋ ɗerec. ");
INSERT INTO moz_vpl VALUES ("AC14_4","074_14_4","ACT","14","4","4","Kane ɗoŋ geeger an tʼîhinte omagi sire, ɗoŋ soŋ a ita Yawudiyagi, wo ɗoŋ soŋ a ita ɗoŋ zina kʼIsa. ");
INSERT INTO moz_vpl VALUES ("AC14_5","074_14_5","ACT","14","5","5","Saŋ kane Yawudiyagi miibi ti ɗoŋ Yawudiyagi ye wo ti deerizaŋ, an di ruute an an dʼise ulsu a ɗoŋ zina kʼIsa, an tiʼn kakkite ti moŋgali an tiʼn tʼîde. ");
INSERT INTO moz_vpl VALUES ("AC14_6","074_14_6","ACT","14","6","6","Wo aame Pool kane ti Barnabas an illiga iŋkino maŋ, an tʼumbe an dʼumɓe kʼurzi Listire ti Derbe, geegiryagi ki siiɗo Likayuni, ti illiyagi ɗoŋ i ti-ɗuule. ");
INSERT INTO moz_vpl VALUES ("AC14_7","074_14_7","ACT","14","7","7","Aame an iɓey a siiɗo gettiyo maŋ, aŋgen̰n̰o toŋ an dʼiise kazita Rabila Majjaanawa. ");
INSERT INTO moz_vpl VALUES ("AC14_8","074_14_8","ACT","14","8","8","A geeger ki Listire gette i dʼede wedusu zoŋɗí unto tʼume an ti yʼehe too, kaŋ soo toŋ umbo yi kʼizire ye. ");
INSERT INTO moz_vpl VALUES ("AC14_9","074_14_9","ACT","14","9","9","Onniyo soo Pool yi kazita ono Raa maŋ, yo wede geŋ yi dʼollige. Pool yi di yʼ wolliyo teɓen̰, maŋ yʼa zuune wede geŋ yi ziipe addí, yi dehu yʼa utte tʼeenizí me. ");
INSERT INTO moz_vpl VALUES ("AC14_10","074_14_10","ACT","14","10","10","Iŋkino maŋ Pool yi di ruute ti golla awwa, yʼede: «Ki tʼoozo, ki tʼôhor kaŋ ôhire!» Wede yʼa ilɗe kʼawwa, yʼa tʼîhira, yʼa iise sooru. ");
INSERT INTO moz_vpl VALUES ("AC14_11","074_14_11","ACT","14","11","11","Aame kane ɗoŋ duuru an wulle munɗa wede Pool yʼize gen̰n̰o maŋ, an dʼiise ɗollite tʼono ki Likayuni, anʼde: «Raayagi an tʼumɓo tukki ɗuwo, an di-ɗiigo diinayiŋ!» ");
INSERT INTO moz_vpl VALUES ("AC14_12","074_14_12","ACT","14","12","12","Iŋkino maŋ Barnabas an i-dʼele suma ki raazaŋ Zewus, wo Pool an i-dʼele suma ki raazaŋ Ermes kono yoŋ wede kʼeesiyo kʼono. ");
INSERT INTO moz_vpl VALUES ("AC14_13","074_14_13","ACT","14","13","13","Ɓoy raayusu Zewus geŋ yoŋ a biza geeger. Iŋkino maŋ wede seɗeke ki Zewus geŋ yʼiideʼŋ, yi ziɗɗe buŋgari, yʼan dʼizite ɗogoro ki bobbo kʼinda, wo yʼan dʼan tʼiide ki biza ɓoy gen̰n̰o, kono yi dehu ti kane ɗoŋ duuru geŋ an an dʼise seɗeke akka Pool ti Barnabas. ");
INSERT INTO moz_vpl VALUES ("AC14_14","074_14_14","ACT","14","14","14","Wo aame kane ɗoŋ zina sire geŋ an illiga iŋkino maŋ, addaŋ a kʼize uŋse ye, kallagaŋ an di zittite, maŋ an dʼukke an tʼiide diine ɗoŋ duuru gen̰n̰o, an di ɗollite, anʼde: ");
INSERT INTO moz_vpl VALUES ("AC14_15","074_14_15","ACT","14","15","15","«Wayya, kune ɗuwo eŋ, kun isiyo iŋkino moo me? Kaye miŋ ɗuwo aa kune pay! Kaye ay un kazita urzi Rabila Majjaanawa kono loŋgayi ɗoŋ ki bita geŋ kun diʼn ooli, wo kun di-kimo ki tukki Raa zeere, wede ikkima kandaane ti siiɗo wo bar, ti sulɗi ɗoŋ adda pay. ");
INSERT INTO moz_vpl VALUES ("AC14_16","074_14_16","ACT","14","16","16","Ti kaaga Raa yʼan iili ɗuwo adda siiɗiyagi pay, ɗoŋ tuuku toŋ an aɗɗiya urzizaŋ kʼeedaŋ kʼeedaŋ. ");
INSERT INTO moz_vpl VALUES ("AC14_17","074_14_17","ACT","14","17","17","Wo toŋ maŋ yʼan di kaza daayum a ɗuwo yoŋ Raa wede beehiye, ti kandaane yʼun dʼeliyo mizzi, yʼun dʼeliyo sulɗi ɗoŋ ki derku, kun dʼayɗu aame onniyo ti tôwwo maŋ. Eyye, yoŋ yʼun dʼeliyo omɓo ɓaadaŋ wo adduguŋ yʼun diʼn ôoniyo tʼuŋsuwo.» ");
INSERT INTO moz_vpl VALUES ("AC14_18","074_14_18","ACT","14","18","18","Ti onamaŋ gen̰n̰o toŋ, ti oon̰e ɓaadaŋ Pool ti Barnabas an dʼiine ɗoŋ duuru an diʼn îhira tʼisiyo seɗeke a kane me. ");
INSERT INTO moz_vpl VALUES ("AC14_19","074_14_19","ACT","14","19","19","Saŋ maŋ kane Yawudiyagi ti Antiyos siiɗo Pizidi wo ti Ikoniyoŋ an dʼiina a Listire, an diʼn irga ɗoŋ duuru ki tukki kane. Iŋkino maŋ Pool an ti yʼ gikkite ti moŋgali ki tôwwadí, saŋ an tʼirga tʼadda geeger ki paate, an elkiyo yʼinda. ");
INSERT INTO moz_vpl VALUES ("AC14_20","074_14_20","ACT","14","20","20","Wo kane sanalliyagi geŋ an di-tʼugiye a eedí, saŋ Pool yʼa tʼiiziga, yʼa-gime kʼadda geeger gettiyo. Soggo maŋ ti Barnabas an dʼiŋgile ki geeger Derbe. ");
INSERT INTO moz_vpl VALUES ("AC14_21","074_14_21","ACT","14","21","21","Pool ti Barnabas an iiney a Derbe maŋ, an di gizite Rabila Majjaanawa wo ɗoŋ ɓaadaŋ an di ziipe addaŋ a Isa, an tʼize sanalliyagi. Saŋ maŋ an di-gime kʼadda geegiryagi ki Listire, Ikoniyoŋ wo Antiyos siiɗo Pizidi. ");
INSERT INTO moz_vpl VALUES ("AC14_22","074_14_22","ACT","14","22","22","Adda geeger soŋ an an dʼeeliyo kooke kooke a sanalliyagi me, an di seeɗa zakiɗi a urzi zaapu kʼaddaŋ a Isa, an dʼeesiyo: «In tʼoona dabar ɓaadaŋ ɗoo miŋ, in tʼetta ki Moziko Raa kollo.» ");
INSERT INTO moz_vpl VALUES ("AC14_23","074_14_23","ACT","14","23","23","Wo tʼadda diine ɗoŋ ogiyso ti suma kʼIsa geŋ a ume soŋ an di beeriyo ɗoŋ dokkiyo dokkiyo, wo aame geŋ an di lekkiyo onniyo muno daa kʼomɓo ti tondiyo Raa, saŋ kane zemɓa geŋ an i-diʼn ele a bey Galmeega wede an ziipe addaŋ kono yʼanni boohe. ");
INSERT INTO moz_vpl VALUES ("AC14_24","074_14_24","ACT","14","24","24","Saŋ maŋ Pool ti Barnabas an dʼiŋgile an di diipiɗa ki Pizidi, an dʼiŋgile ki siiɗo Pampili. ");
INSERT INTO moz_vpl VALUES ("AC14_25","074_14_25","ACT","14","25","25","An di gizite ono Raa a geeger ki Perz, saŋ maŋ an di-ɗiige ki biza bar ki geeger kʼAtali. ");
INSERT INTO moz_vpl VALUES ("AC14_26","074_14_26","ACT","14","26","26","Tiŋ geŋ an di-gili adda tooko, an di-gimo ki Antiyos siiɗo Siiri, ume wede ti poone zemɓa an an diʼn ele kane a beeko ere ki Raa, a naabo ere an dʼise wo ankeŋ an ti ɗiŋge. ");
INSERT INTO moz_vpl VALUES ("AC14_27","074_14_27","ACT","14","27","27","Aame an iiney a Antiyos maŋ, an diʼn ugiye ɗoŋ ogiyso ti suma kʼIsa geŋ pay, wo an an tʼîide taaya a munɗa wede Raa yʼize tʼurzi kane, wo soŋ mummino Raa yʼize yʼan tʼihina urzi a kane ɗoŋ Yawudiyagi ye toŋ, an ziipe addaŋ a Isa me. ");
INSERT INTO moz_vpl VALUES ("AC14_28","074_14_28","ACT","14","28","28","Aame geŋ Pool ti Barnabas an di likke onniyto ɓaadaŋ ti sanalliyagi me. ");
INSERT INTO moz_vpl VALUES ("AC15_1","074_15_1","ACT","15","1","1","I dʼede ɗoŋ ede kane a siiɗo Ziide, an dʼiŋgile ki Antiyos an di dooyiso zemɓa, anʼde: «Kune kun ki ti wilɗa ponde aa oogoro Muusa ti ki rootiyo ye maŋ, Raa yʼun kiʼn utta ye.» ");
INSERT INTO moz_vpl VALUES ("AC15_2","074_15_2","ACT","15","2","2","Wo Pool ti Barnabas an ki dʼiyye ye a onamaŋ geŋ me, an di niikite ɓaadaŋ ti kane me. Iŋkino maŋ an di dihe Pool ti Barnabas an di-kili Zeruzalem ti zemɓa oŋgo kono an di wollo ono geŋ ti ɗoŋ zina kʼIsa wo ti ɗoŋ dokkiyo. ");
INSERT INTO moz_vpl VALUES ("AC15_3","074_15_3","ACT","15","3","3","Iŋkino maŋ ɗoŋ ogiyso ti suma kʼIsa a Antiyos an an dʼeele munɗa ki torguwadaŋ me, wo an diʼn igibe an dʼiŋgile. An di diipiɗa ki siiɗo Pinisi wo ki siiɗo Samari, a ume geŋ an an tʼîide taaya mummino ɗoŋ Yawudiyagi ye an di ziipe addaŋ a Isa me, wo kane zemɓa pay geŋ addaŋ a ûune tʼuŋsuwo. ");
INSERT INTO moz_vpl VALUES ("AC15_4","074_15_4","ACT","15","4","4","Aame kane an iiney Zeruzalem maŋ, ɗoŋ ogiyso ti suma kʼIsa, ɗoŋ zina kʼIsa wo ɗoŋ dokkiyo pay geŋ, an diʼn ziiɗa bey sire. Wo Pool ti Barnabas an an tʼîide taaya a sulɗi ɗoŋ pay Raa yʼize tʼurzi kane. ");
INSERT INTO moz_vpl VALUES ("AC15_5","074_15_5","ACT","15","5","5","Wo ɗoŋ ede ti diine Pariziyeŋ ɗoŋ i ziipe addaŋ a Isa geŋ, an tʼiiziga an dʼiise rootiyo, anʼde: «Ɗoŋ Yawudiyagi ye an ziipe addaŋ a Isa geŋ i dehu an di walɗa ponde, wo kun an di roote an di daane oogoro Muusa.» ");
INSERT INTO moz_vpl VALUES ("AC15_6","074_15_6","ACT","15","6","6","Iŋkino maŋ kane ɗoŋ zina kʼIsa ti ɗoŋ dokkiyo an tʼugiye kono an di wolle urzi kʼono gen̰n̰o. ");
INSERT INTO moz_vpl VALUES ("AC15_7","074_15_7","ACT","15","7","7","Aame an niikite kee maŋ, Piyer yʼa tʼiiziga yʼan di ruute, yʼede: «Zemɓa ki nuŋ, kun suune nuŋ Raa yi ni biire ti diine kune ti kaagine, kono nʼan di kizite Rabila Majjaanawa a ɗoŋ Yawudiyagi ye, kono ono eŋ an diʼn olliga wo an zaape addaŋ a Isa. ");
INSERT INTO moz_vpl VALUES ("AC15_8","074_15_8","ACT","15","8","8","Wo yo Raa yoŋ wede yi suune adde ɗuwo pay, geŋ yʼan di gize kono kane toŋ yiʼni dehu yʼan tʼele Unde Kamilen̰ aa yʼin ele a kine kay. ");
INSERT INTO moz_vpl VALUES ("AC15_9","074_15_9","ACT","15","9","9","Raa yʼinni wolliyo kine ti kane pay miŋ kaŋ soo: kono kane an ziipe addaŋ a Isa, Raa yiʼn ize addaŋ kamilen̰ a ɗaanadí me. ");
INSERT INTO moz_vpl VALUES ("AC15_10","074_15_10","ACT","15","10","10","Wo aŋkeŋ moo me kun dehu kun di lette adde Raa, kun an di zaape attiɗi ki daaniya kʼoogoro Muusa a ekki sanalliyagi kʼIsa me, attiɗi wede moŋgiɗagiŋ toŋ an kʼiine sarkiya ye, wo kine toŋ maŋ in kʼaane ye kay? ");
INSERT INTO moz_vpl VALUES ("AC15_11","074_15_11","ACT","15","11","11","Aha, i kʼise ye iŋkino me. In amɓo miŋ tʼurzi beeko ere ki Galmeega Isa kine Yawudiyagi in uune uttiyo, wo a kane toŋ iŋkino pây.» ");
INSERT INTO moz_vpl VALUES ("AC15_12","074_15_12","ACT","15","12","12","Aame kane ɗoŋ duuru pay geŋ an illiga iŋkino maŋ, an dʼinda kuy, wo an dʼollige Pool ti Barnabas an tôwwo taaya a sulɗi kʼarmika ti sulɗi ɗoŋ i ceeriyo eego Raa yʼize tʼurzi kane a diine ɗoŋ Yawudiyagi ye. ");
INSERT INTO moz_vpl VALUES ("AC15_13","074_15_13","ACT","15","13","13","Aame onamaŋ i ɗiŋge maŋ, Zak yʼa iise rootiyo, yʼede: «Zemɓa ki nuŋ, kun ollo kay! ");
INSERT INTO moz_vpl VALUES ("AC15_14","074_15_14","ACT","15","14","14","Simo yʼin ruute mummino tʼume kʼeesiyo Raa yʼa buuhe ɗoŋ Yawudiyagi ye me, kono yi-beere ti diine kane an tʼise ɗoŋ ti suma yode. ");
INSERT INTO moz_vpl VALUES ("AC15_15","074_15_15","ACT","15","15","15","Wo ono nebiyagi toŋ a-tʼiide a sulɗi gen̰n̰o, kono ono eŋ an riiŋe ti kaaga adda mattup ki Raa, anʼde: ");
INSERT INTO moz_vpl VALUES ("AC15_16","074_15_16","ACT","15","16","16","“Galmeega yʼede: Saŋ maŋ nuŋ nʼa kimo nʼa yʼooziga ɓoy Dawut wede iire me, sulɗi pay i litte geŋ nʼan okkima nʼa yʼooziga a umayí. ");
INSERT INTO moz_vpl VALUES ("AC15_17","074_15_17","ACT","15","17","17","Iŋkino maŋ ɗoŋ pay ti doolo toŋ an di deha nuŋ Galmeega, eyye ita ɗoŋ siiɗo pay ni wiiko an tʼisa ɗoŋzó. En̰n̰o ono ɗoŋ Galmeega yi ruute me. ");
INSERT INTO moz_vpl VALUES ("AC15_18","074_15_18","ACT","15","18","18","Sulɗi geŋ yoŋ yʼan tiʼn gize tʼume ti kaaga too.”» ");
INSERT INTO moz_vpl VALUES ("AC15_19","074_15_19","ACT","15","19","19","Zak yʼa ruute sey, yʼede: «En̰n̰o munɗa wede ni wolliyo beehiye me, in an ki tʼise ye mokkolo morkiƴe a kane ɗoŋ Yawudiyagi ye i-gime ki tukki Raa. ");
INSERT INTO moz_vpl VALUES ("AC15_20","074_15_20","ACT","15","20","20","Wo in an raaŋa mattup kono in an di roote, an kʼaaɗi ye sey wede an eliyo seɗeke a loŋgayi me, kono a ɗaana Raa yoŋ ganigi, boliyo toŋ ulu an dʼooli, an kʼaaɗi ye sey wede ki seysu inda puuzadí ti kʼuɗɗe ye me, ise puuzo toŋ ulu an kʼoomi ye. ");
INSERT INTO moz_vpl VALUES ("AC15_21","074_15_21","ACT","15","21","21","In an raaŋa iŋkino kono ti kaagine ɗuwo an kazita urzi kʼoogoro Muusa adda geegiryagi pay, wo an gariyta adda ɓoyɗi ɗoŋ in di dooyiso a onniytagi ɗoŋ ki puukiyadiŋ me.» ");
INSERT INTO moz_vpl VALUES ("AC15_22","074_15_22","ACT","15","22","22","Iŋkino maŋ ɗoŋ zina kʼIsa, ɗoŋ dokkiyo ti ɗoŋ pay ogiyso ti suma kʼIsa, kaŋ soo an di biire ti diinayaŋ ɗuwo an tiʼn tʼigibe a ita Pool ti Barnabas ki Antiyos siiɗo Siiri. Maŋ an tʼiiɗiba Ziid sundí soo Barsabas, wo Silas, kane geŋ ɗoŋ suma, zemɓa pay anʼni suune. ");
INSERT INTO moz_vpl VALUES ("AC15_23","074_15_23","ACT","15","23","23","An an dʼele mattup gette a beezaŋ, wo adda mattup an riiŋe, anʼde: «Kaye ɗoŋ zina kʼIsa, ɗoŋ dokkiyo ti zemɓa pay ay un tʼize toose a kune zemɓa ɗoŋ Yawudiyagi ye i lekkiyo a geeger kʼAntiyos, a siiɗo Siiri wo a siiɗo Silisi. ");
INSERT INTO moz_vpl VALUES ("AC15_24","074_15_24","ACT","15","24","24","Ay illiga ɗoŋ ede ti diinayey, an tʼiide di kune. Kane ɗoŋ geŋ an un ti-digge egguŋ te, wo an un diʼn ele adda kʼelkiso ti onamaŋ geŋ me, biza kʼulbuguŋ a-gime. Wo ɗe kaye ay an ki ruute ye an dʼise iŋkino me. ");
INSERT INTO moz_vpl VALUES ("AC15_25","074_15_25","ACT","15","25","25","Iŋkino maŋ kaye pay ay di ruute kaŋ soo ay biire ɗuwo ay diʼn tʼigibe ki tukki kune a ita zemɓa ɗoŋ ki geyyiso Barnabas ti Pool, ");
INSERT INTO moz_vpl VALUES ("AC15_26","074_15_26","ACT","15","26","26","kane ɗoŋ ele tuddaŋ kʼunto toŋ maŋ kono an daaniya suma Galmeegiŋ Isa Almasi. ");
INSERT INTO moz_vpl VALUES ("AC15_27","074_15_27","ACT","15","27","27","Iŋkino ay un tʼigibe Ziid ti Silas, an un di rootey ti bizaŋ munɗa wede ay un riiŋe adda mattup ette. ");
INSERT INTO moz_vpl VALUES ("AC15_28","074_15_28","ACT","15","28","28","Geŋ iŋkino tʼurzi kʼUnde Kamilen̰, kaye batum ay un ki zaape attiɗi ti doolo ye, wo kun daano munɗa wede ay un riiŋe adda mattup: ");
INSERT INTO moz_vpl VALUES ("AC15_29","074_15_29","ACT","15","29","29","Sey wede an eliyo seɗeke a loŋgayi kun aaɗi ye, puuzo toŋ ulu kun oomi ye, sey wede ki seysu inda puuzadí ti kʼuɗɗe ye kun aaɗi ye, ise boliyo toŋ ulu kun dʼooli. Aame sulɗi pay geŋ kun iila maŋ, a kune beehiye. Kaye zemɓaguŋ a en̰n̰o ay un tʼize toose ɓaadaŋ.» ");
INSERT INTO moz_vpl VALUES ("AC15_30","074_15_30","ACT","15","30","30","Mattup gette an an dʼele a ɗoŋ an biire, maŋ kane an dʼiŋgile ki Antiyos. An iiney maŋ an diʼn ugiye ɗoŋ i ziipe addaŋ a Isa geŋ pay, mattup gette an an dʼele. ");
INSERT INTO moz_vpl VALUES ("AC15_31","074_15_31","ACT","15","31","31","Aame mattup gette an ti gire maŋ, onamtú geŋ zemɓa an dʼeele kooke wo ulbaŋ an tʼize uŋse ɓaadaŋ. ");
INSERT INTO moz_vpl VALUES ("AC15_32","074_15_32","ACT","15","32","32","Ziid ti Silas geŋ kane nebiyagi, a zemɓa an an dʼeele kooke tʼurzi ɓaadaŋ kono an di koone zakiɗi a urzi zaapu kʼaddaŋ a Isa. ");
INSERT INTO moz_vpl VALUES ("AC15_33","074_15_33","ACT","15","33","33","An di likke onniyto ɓaadaŋ aŋgeŋ me, saŋ maŋ zemɓa an diʼn igibo wo an di ruute, anʼde: «Kun di-kama ti toose kʼume ɗoŋ un igibo me.»  ");
INSERT INTO moz_vpl VALUES ("AC15_34","074_15_34","ACT","15","34","34","Wo Silas geŋ i-di tʼize uŋse, yʼa lekke me. ");
INSERT INTO moz_vpl VALUES ("AC15_35","074_15_35","ACT","15","35","35","Aame geŋ Pool ti Barnabas an dʼuupo a Antiyos, ti zemɓa ɓaadaŋ oŋgo an di dooyiso wo an di kazita Rabila Majjaanawa a urzi kʼono Galmeega. ");
INSERT INTO moz_vpl VALUES ("AC15_36","074_15_36","ACT","15","36","36","Onniyto miibi kʼita maŋ Pool yi di ruute Barnabas, yʼede: «In ti kime kʼita, in di wollo zemɓa adda geegiryagi pay ɗoŋ in an gizito ono Galmeega, an isiyo mummino koo maŋ a urzi Raazaŋ me.» ");
INSERT INTO moz_vpl VALUES ("AC15_37","074_15_37","ACT","15","37","37","Barnabas yi dehu yʼa di waake Zaŋ wede sundí soo Markus ti kane. ");
INSERT INTO moz_vpl VALUES ("AC15_38","074_15_38","ACT","15","38","38","Wo ɗe ki Pool maŋ yi ki dehu Zaŋ yi kʼette ye ti kane me, kono yoŋ ti siiɗo Pampili yʼan diʼn iilo, a naabadaŋ yʼan kiʼn nuugo ye. ");
INSERT INTO moz_vpl VALUES ("AC15_39","074_15_39","ACT","15","39","39","A ume geŋ niikiytadaŋ tʼa guune zakiɗi, iŋkino an a-tʼîhinte. Barnabas yʼa wiike Markus an di-gili adda tooko, an dʼiŋgile ki siiɗo Siipire. ");
INSERT INTO moz_vpl VALUES ("AC15_40","074_15_40","ACT","15","40","40","Wo Pool yʼa-wiike Silas, maŋ zemɓa an tunde Galmeega kono beekadí tʼa koone kane, saŋ an dʼiŋgile. ");
INSERT INTO moz_vpl VALUES ("AC15_41","074_15_41","ACT","15","41","41","Pool yʼan izire siiɗo Siiri ti Silisi pay, yʼan dʼeeliyo kooke a ɗoŋ ogiysito ti suma kʼIsa a ume tuuku toŋ maŋ. ");
INSERT INTO moz_vpl VALUES ("AC16_1","074_16_1","ACT","16","1","1","Saŋ maŋ Pool yʼa tʼiide Derbe wo soŋ ki Listire. A ume geŋ i dʼede sanallusu kʼIsa sundí Timote, meedí todʼte Yawudowo ti ziipe addutú a Isa, wo meegí yoŋ Girek. ");
INSERT INTO moz_vpl VALUES ("AC16_2","074_16_2","ACT","16","2","2","Yo Timote zemɓa ɗoŋ i lekkiyo a Listire ti Ikoniyoŋ an yi tamma. ");
INSERT INTO moz_vpl VALUES ("AC16_3","074_16_3","ACT","16","3","3","Pool yi dehu yʼa ti yʼ waake ti yode. Iŋkino maŋ yi di wilɗa ponde kono Yawudiyagi ɗoŋ i lekkiyo a siiɗiyagi gen̰n̰o geŋ an zuune pay meegí yoŋ Girek me. ");
INSERT INTO moz_vpl VALUES ("AC16_4","074_16_4","ACT","16","4","4","Aame Timote yi-ti wilɗa ponde maŋ, an dʼettiyo geeger ti geeger, an an di kazita a zemɓa ɗoŋ i ziipe addaŋ a Isa, munɗa wede kane ɗoŋ zina kʼIsa ti ɗoŋ dokkiyo a Zeruzalem an dihe, wo kane an an di rootiyo an dʼozire eego a munɗa geŋ me. ");
INSERT INTO moz_vpl VALUES ("AC16_5","074_16_5","ACT","16","5","5","Wo kane ɗoŋ ogiysito ti suma kʼIsa geŋ an dʼooniyo toogo ɓaadaŋ a urzi zaapu kʼadde a Isa me, wo onniyo ti onniyo an dʼaagulu kʼaagulu. ");
INSERT INTO moz_vpl VALUES ("AC16_6","074_16_6","ACT","16","6","6","Saŋ maŋ tiŋ geŋ an dehu an tʼette ki siiɗo kʼAazi an kizitey ono Raa, miŋ Unde Kamilen̰ tʼan tʼiigire kʼettiyo me. Iŋkino an dʼiŋgile, an di diipiɗa siiɗo Pirizi ti Galat. ");
INSERT INTO moz_vpl VALUES ("AC16_7","074_16_7","ACT","16","7","7","Aame an iiney goppoŋ ti siiɗo Mizi maŋ, an dehu an tʼette siiɗo Bitini, wo ki ume gen̰n̰o toŋ Unde kʼIsa tʼan di-tuuge kʼettiyo me. ");
INSERT INTO moz_vpl VALUES ("AC16_8","074_16_8","ACT","16","8","8","Iŋkino maŋ siiɗo Mizi an ti diipiɗa, an dʼiŋgile ki biza bar ki geeger Tirowas. ");
INSERT INTO moz_vpl VALUES ("AC16_9","074_16_9","ACT","16","9","9","An di-ɗiige aŋgen̰n̰o, a diɗɗo maŋ Pool i-dʼiide munɗa aa suniye, yi wolliyo wedusu ti siiɗo Maseduwan yi tʼîhira a ɗaanadí wo yi di yʼ tondiyo tʼoɓe bey, yʼede: «Ki ti doopiɗi tʼen̰n̰o ki siiɗo Maseduwan, kʼay di-noogey kotok!» ");
INSERT INTO moz_vpl VALUES ("AC16_10","074_16_10","ACT","16","10","10","Aame Pool yi wulle munɗa wede i-iide aa suniye gen̰n̰o maŋ, kesiko kaye ay dihe urzi kʼettiyo ki Maseduwan kono kaye ay zuune Raa yʼayni waaku ay di kizitey Rabila Majjaanawa a ɗoŋ siiɗo gettiyo. ");
INSERT INTO moz_vpl VALUES ("AC16_11","074_16_11","ACT","16","11","11","Ti Tirowas geŋ ay dʼuune tooko ay di-gili, ay dʼiŋgile ɗelele ki siiɗo ere a diine kʼahu sundutú Samotiras, wo soggo maŋ ay dʼiiney a biza bar ki geeger Nayapoli. ");
INSERT INTO moz_vpl VALUES ("AC16_12","074_16_12","ACT","16","12","12","Ti Nayapoli ay dʼiŋgile ki Pilip, todʼte geeger meeda ki siiɗo Maseduwan, ɗoŋ Romeŋ ɓaadaŋ an lekkiyo adda. Adda geeger gette ay di likke onniyto. ");
INSERT INTO moz_vpl VALUES ("AC16_13","074_16_13","ACT","16","13","13","A onniyo ere ki puukiyo Yawudiyagi maŋ tʼadda geeger ay tʼuɗɗe, ay dʼiŋgile biza kʼooye, ay elkiyo ay tʼooney ume Yawudiyagi ge dʼogiyso ki tondiyo Raa. A ume geŋ ay dʼuuney erayi an tʼugiye, kaye toŋ ay di gunɗite ti kane wo ay an di gizite ono Raa. ");
INSERT INTO moz_vpl VALUES ("AC16_14","074_16_14","ACT","16","14","14","Erewo soo ti diinayaŋ sundutú Lidi, todʼte ti geeger Tiyatir, todʼ tʼisiyo suuk ki juwa zooyatú oon̰e wo todʼ tʼottilso a Raa. Tʼay diʼn ollige koɗec koɗec wo Galmeega yi-dʼize adda kʼaddutú, ono Pool geŋ itadaŋ tʼanni zuune, tʼa ziipe addutú a Isa. ");
INSERT INTO moz_vpl VALUES ("AC16_15","074_16_15","ACT","16","15","15","Saŋ todʼ tʼa-zuyye batem ti ɗoŋ ɓoytú pay, maŋ tʼay diʼn wiike kino, tʼede: «Aame kun zuune nuŋ ni ziipe addó a Galmeega ki kotto maŋ, kun tʼedi kun lekka di nuuno.» Wo todʼ tʼa ziiɗa zakiɗi, ay dʼiyye. ");
INSERT INTO moz_vpl VALUES ("AC16_16","074_16_16","ACT","16","16","16","Onniyo soo ay tʼette kʼume tondiyo Raa maŋ, i dʼede uto koŋso ɓulowo tʼay diʼn uuna, tode gette i-dʼede siitan ettú ti di kazita sulɗi ɗoŋ etto. A munɗa wede tʼan ooɗibe ita a ɗuwo geŋ, galmaawutú an dʼooniyo soŋko ɓaadaŋ. ");
INSERT INTO moz_vpl VALUES ("AC16_17","074_16_17","ACT","16","17","17","Tʼa iise daaniya Pool ti kaye, ti rootiyo ti golla awwa, ti dʼeesiyo: «Ɗoŋ eŋ kane ɗoŋ naabo ki Raa goole a jiire pay! An un kaza urzi wede Raa yi dehu yʼun diʼn utte.» ");
INSERT INTO moz_vpl VALUES ("AC16_18","074_16_18","ACT","16","18","18","Onniyto ɓaadaŋ todʼtiŋ a ita kane, maŋ onniyo soo Pool addí a-tiire, yʼa-gime kʼita wo yi-di ruute a siitan ere a ekki erewo gette, yʼede: «Ti suma ere kʼIsa Almasi ni di rooto, mi tʼaɗɗo tʼekkʼerewo te!» A kaamiki siitan tʼa tʼuɗɗe tʼekkʼerewo te. ");
INSERT INTO moz_vpl VALUES ("AC16_19","074_16_19","ACT","16","19","19","Aame galmaawutú an wolliyo munɗa wede an ziipe elkiyadaŋ ekki tode an kʼooniyo ye baa maŋ, an tiʼn ziɗɗe Pool ti Silas, an dʼan tʼiide ki bere ɗoŋ duuru a ɗaana ɗoŋ booro. ");
INSERT INTO moz_vpl VALUES ("AC16_20","074_16_20","ACT","16","20","20","An dʼan tʼiide kʼume ɗoŋ deero booro Romeŋ, an di ruute, anʼde: «Kane ɗuwo eŋ Yawudiyagi wo an ti lettiyo siiɗadey. ");
INSERT INTO moz_vpl VALUES ("AC16_21","074_16_21","ACT","16","21","21","An dooyiso urzi kʼoogiradaŋ, sulɗi ɗoŋ kaye Romeŋ ay kʼede urzi ay ki dʼoyye, ay ki daane ye.» ");
INSERT INTO moz_vpl VALUES ("AC16_22","074_16_22","ACT","16","22","22","Wo kane ɗoŋ duuru pay i tʼugiye geŋ an dʼiizi gulkuwo ti Pool wo Silas, wo kane deero booro Romeŋ an an di ruute, anʼde: «Kallagaŋ kun tʼoɗɗipo wo kunʼni kosso ti karre.» ");
INSERT INTO moz_vpl VALUES ("AC16_23","074_16_23","ACT","16","23","23","Aame an tiʼn girpipe maŋ, an diʼn iɓi daŋgay, wo an i-di ruute a wede boohiyo ɗoŋ daŋgay, anʼde: «Ɗoŋ eŋ kiʼni booho koɗuwo.» ");
INSERT INTO moz_vpl VALUES ("AC16_24","074_16_24","ACT","16","24","24","Aame wede boohiyo an i ti ruute iŋkino maŋ, kane geŋ yʼan dʼan tʼiide kʼadda daŋgay ere kʼadda wo zoŋɗaŋ yi-tʼele adda poole. ");
INSERT INTO moz_vpl VALUES ("AC16_25","074_16_25","ACT","16","25","25","A diɗɗo meeda maŋ Pool ti Silas an tondiyo Raa, an dʼôoro an tamma Raa, wo ɗoŋ daŋgay ti doolo an diʼn ollige. ");
INSERT INTO moz_vpl VALUES ("AC16_26","074_16_26","ACT","16","26","26","A kaamiki, siiɗo tʼa iise ŋoŋŋirso, moŋgali ɗoŋ kʼeesiyo ɓoy daŋgay a ŋuŋŋire, wo boha binɗani pay toŋ a kaamiki a tʼihinte waŋ waŋ, wo ziŋziri a zoŋ ɗoŋ daŋgay pay a-dimɓe. ");
INSERT INTO moz_vpl VALUES ("AC16_27","074_16_27","ACT","16","27","27","Maŋ wede boohiyo geŋ yʼa iddira, yʼa tʼinne, yi wolliyo boha ohinte waŋ waŋ, yʼelkiyo ɗoŋ daŋgay an tʼumbe. Iŋkino maŋ yʼaa tʼiiɗiba seebir, yi dehu yʼa-kiira tuddí. ");
INSERT INTO moz_vpl VALUES ("AC16_28","074_16_28","ACT","16","28","28","Wo Pool yʼa iɗili ti golla awwa, yʼede: «Ay! Kʼoolo, ki kʼiira tuddá ye. Kaye pay ede.» ");
INSERT INTO moz_vpl VALUES ("AC16_29","074_16_29","ACT","16","29","29","Iŋkino maŋ wede geŋ yʼa tunde, yʼede: «Kun oo kʼeeli biŋge ɗo.» An i eelo maŋ, kesiko yi-tʼiide kʼadda, yi ŋoŋŋirso burbur, yʼa iire a zoŋ ki Pool ti Silas. ");
INSERT INTO moz_vpl VALUES ("AC16_30","074_16_30","ACT","16","30","30","Saŋ maŋ tʼadda daŋgay yʼan diʼn uɗɗe wo yʼanni tunde, yʼede: «Kuneʼŋ, nʼaase mummino nʼa tʼoone uttiyo te?» ");
INSERT INTO moz_vpl VALUES ("AC16_31","074_16_31","ACT","16","31","31","Kane an i-di ruute, anʼde: «Ki zaapo addá a Galmeega Isa wo kʼa tʼoona uttiyo, kee ti ɗoŋ ɓoozá pay.» ");
INSERT INTO moz_vpl VALUES ("AC16_32","074_16_32","ACT","16","32","32","Maŋ an i-di gizite ono Galmeega a yode wo a ɗoŋ adda ɓoozí pay. ");
INSERT INTO moz_vpl VALUES ("AC16_33","074_16_33","ACT","16","33","33","A peeɗo gettiyo batum a diɗɗo meeda, wede boohiyo yʼa tiʼn wiike yʼan tʼupile kunɗayzaŋ, maŋ a kaamiki an ti yʼ zuyye batem, yode ti ɗoŋ adda ɓoozí pay. ");
INSERT INTO moz_vpl VALUES ("AC16_34","074_16_34","ACT","16","34","34","Saŋ maŋ Pool ti Silas yʼan dʼan dʼaahe ɓoozí yʼan dʼeele omɓo, wo yoŋ ulbí uŋse ɓaadaŋ ti ɗoŋ ɓoozí pay kono an ziipe addaŋ a Raa. ");
INSERT INTO moz_vpl VALUES ("AC16_35","074_16_35","ACT","16","35","35","Wo aame ume i tʼumpile maŋ, deero booro Romeŋ an dʼigibo guumiyagi an i-di ruute wede boohiyo, anʼde: «Ti daŋgay kʼan aɗɗe Pool ti Silas me.» ");
INSERT INTO moz_vpl VALUES ("AC16_36","074_16_36","ACT","16","36","36","Maŋ wede boohiyo yʼa iide yi di ruute a Pool, yʼede: «Kʼollo, deero booro an igibo anʼde, nʼun tiʼn aɗɗo. Aŋkeŋ kun tʼaɗɗo, kun eŋgilo ti toose.» ");
INSERT INTO moz_vpl VALUES ("AC16_37","074_16_37","ACT","16","37","37","Wo Pool yʼan di ruute guumiyagi, yʼede: «An ay diʼn gusse a ɗaana ɗuwo pay daa kʼollige kʼonamey miŋ, para maŋ kayeʼŋ ɗoŋ ti siiɗo Romeŋ. An ay diʼn iɓi daŋgay, wo aŋkeŋ an dehu an ay dʼeeze kaŋ ombiɗe maŋ, i kʼise ye. Iŋkino maŋ edi kane batum an ay diʼn aɗɗa.» ");
INSERT INTO moz_vpl VALUES ("AC16_38","074_16_38","ACT","16","38","38","Maŋ guumiyagi an iideʼŋ, an an di ruute a deero booro iŋkino. Aame an zuune kaciŋ Pool ti Silas kane ɗoŋ ti siiɗo Romeŋ too maŋ, orgiso tʼanni ziiɗa. ");
INSERT INTO moz_vpl VALUES ("AC16_39","074_16_39","ACT","16","39","39","Iŋkino kane batum an dʼiide an an tʼize tambobino, maŋ ti daŋgay an diʼn uɗɗe wo an an di ruute, anʼde: «Tʼadda geeger kun tʼaɗɗo.» ");
INSERT INTO moz_vpl VALUES ("AC16_40","074_16_40","ACT","16","40","40","Aame ti daŋgay an tʼuɗɗe maŋ, Pool ti Silas an tʼiide ki ɓoy Lidi, a ume geŋ an tiʼn wulle zemɓa ɗoŋ i ziipe addaŋ a Isa wo an an dʼeele kooke, saŋ an tʼiiziga an dʼiŋgile. ");
INSERT INTO moz_vpl VALUES ("AC17_1","074_17_1","ACT","17","1","1","Pool ti Silas an iŋgile ti geeger Pilip maŋ, an tʼuɗɗe ti geeger kʼAmpipoli ti Apoloni. Maŋ an dʼiiney a geeger Tessaloni, a ume geŋ i dʼede ɓoy wede Yawudiyagi ge dooyiso. ");
INSERT INTO moz_vpl VALUES ("AC17_2","074_17_2","ACT","17","2","2","Wo Pool aa yi dʼisiyo daayum, yʼa tʼiide kʼadda ɓoy gen̰n̰o. Adda suuk aɗo geŋ a onniyo ere ki puukiyo Yawudiyagi maŋ, an di niikutu ti kane ɗoŋ adda a urzi kʼono ɗoŋ an riiŋe ti kaaga adda mattup ki Raa. ");
INSERT INTO moz_vpl VALUES ("AC17_3","074_17_3","ACT","17","3","3","Pool yʼan di kazita yʼan di sekin̰so keren̰, yi dʼeesiyo: «Mattup ki Raa ti ruute, i dehu Almasi yʼa dabira, yʼa tʼinda, wo yʼa-balɗa ti diine ɗoŋ unto me. Wo Almasi Raa yi biire geŋ, yoŋ Isa wede nʼun kazita.» ");
INSERT INTO moz_vpl VALUES ("AC17_4","074_17_4","ACT","17","4","4","I dʼede Yawudiyagi oŋgo ono geŋ anʼni ziiɗa, an a-tʼiide a ita Pool ti Silas. Wo ɗoŋ Girek ɓaadaŋ an ottilso a Raa, ti erayi ɓaadaŋ ɗoŋ sundaŋ ti môolo toŋ maŋ, an a-tʼiide ti kane. ");
INSERT INTO moz_vpl VALUES ("AC17_5","074_17_5","ACT","17","5","5","Wo ɗe kane Yawudiyagi ɗoŋ i ki ziipe addaŋ a Isa ye, an di gulɓike ɓaadaŋ. Iŋkino maŋ an iideʼŋ an di wiiko ɗoŋ bita i ɗerilsito a urziyagi geŋ, an dʼiide ɓaadaŋ, an an tʼelite ono an dʼiise tarkuuse. Saŋ an tʼiide ki ɓoy Zason kono Pool ti Silas an tiʼn seɗɗe, an an diʼn tʼette ki ɗaana ɗoŋ duuru. ");
INSERT INTO moz_vpl VALUES ("AC17_6","074_17_6","ACT","17","6","6","Wo ɗe an kiʼn uune ye, iŋkino maŋ an di ziiɗa Zason ti zemɓa miibi ɗoŋ i ziipe addaŋ a Isa. An dʼan tʼiide ɗaana ɗoŋ deero ki geeger, wo an dʼiise ɗollite, anʼde: «Kane ɗuwo eŋ ɗoŋ duniya pay an tiʼn digge, aŋkeŋ an iina di kine! ");
INSERT INTO moz_vpl VALUES ("AC17_7","074_17_7","ACT","17","7","7","Zason yʼa tiʼn ziiɗa di yode, wo kane ɗoŋ pay geŋ an ki dehu an ki daane oogoro ki mozigo goole ki Romeŋ ye, anʼde i dʼede mozigo goole ti doolo ede, sundí Isa.» ");
INSERT INTO moz_vpl VALUES ("AC17_8","074_17_8","ACT","17","8","8","Aame ɗoŋ duuru ti ɗoŋ deero ki geeger an illiga ono gen̰n̰o maŋ, addaŋ a litte. ");
INSERT INTO moz_vpl VALUES ("AC17_9","074_17_9","ACT","17","9","9","Iŋkino maŋ kane ɗoŋ deero geŋ an di tunde munɗa, maŋ Zason ti zemɓa oŋgo an dʼiiɗi beezaŋ an an dʼele ɗoo miŋ, an an dʼiize kollo. ");
INSERT INTO moz_vpl VALUES ("AC17_10","074_17_10","ACT","17","10","10","A diɗɗo maŋ kesiko zemɓa an diʼn unzile Pool ti Silas me, an dʼiŋgile ki geeger Beere. Aame an iiney maŋ an tʼiide kʼadda ɓoy wede Yawudiyagi ge dooyiso. ");
INSERT INTO moz_vpl VALUES ("AC17_11","074_17_11","ACT","17","11","11","Kane Yawudiyagi ɗoŋ a Beere geŋ elkisadaŋ ede a jiire ɗoŋ a Tessaloni, an dʼollige Rabila Majjaanawa tʼadde soo. Onniyo ti onniyo an di gariya ono ɗoŋ an riiŋe ti kaaga adda mattup ki Raa, kono an dehu an di suune ono Pool yi rootiyo geŋ ɗerec kunuŋ, mummino me. ");
INSERT INTO moz_vpl VALUES ("AC17_12","074_17_12","ACT","17","12","12","Ɗoŋ ɓaadaŋ ti diinayaŋ an di ziipe addaŋ a Isa, wo erayi ɗoŋ Girek sundaŋ ti môolo ti kuuli ɓaadaŋ pây, an di ziipe addaŋ a Isa. ");
INSERT INTO moz_vpl VALUES ("AC17_13","074_17_13","ACT","17","13","13","Wo ɗe aame Yawudiyagi ɗoŋ ki Tessaloni an illiga Pool yi kazita ono Raa a geeger Beere maŋ, an dʼiido an an tʼelite ono a ɗoŋ duuru, an dʼiise tarkuuse aŋgen̰n̰o toŋ maŋ. ");
INSERT INTO moz_vpl VALUES ("AC17_14","074_17_14","ACT","17","14","14","Kesiko zemɓa ɗoŋ i ziipe addaŋ a Isa an di yʼigibe Pool ki biza bar, wo Silas ti Timote an dʼuupe a Beere. ");
INSERT INTO moz_vpl VALUES ("AC17_15","074_17_15","ACT","17","15","15","Zemɓa ɗoŋ iide agisa ki Pool geŋ, an aa yʼigibo bini geeger ki Aten. Wo aame an iiney maŋ, yʼan di ruute a ɗoŋ kʼagisadí, yʼede: «Aame kun ti gima maŋ, kun an di rootoy aŋ kaŋ Silas ti Timote geŋ, kesiko an diʼn tʼoona a en̰n̰o.» Maŋ kane an di-gime ki Beere. ");
INSERT INTO moz_vpl VALUES ("AC17_16","074_17_16","ACT","17","16","16","Aame Pool yi delliyo Silas ti Timote a Aten geŋ, yi wolliyo maŋ geeger gette i tʼûune ti loŋgayi ɗaŋŋal, maŋ i ki dʼize uŋse ye, addí a litte. ");
INSERT INTO moz_vpl VALUES ("AC17_17","074_17_17","ACT","17","17","17","Iŋkino maŋ yi dʼettiyo kʼadda ɓoy wede Yawudiyagi ge dooyiso, an di niikiyto ti Yawudiyagi wo ti ɗoŋ Yawudiyagi ye an ottilso a Raa. Wo a bere ɗoŋ duuru toŋ, an di niikiyto daayum ti ɗuwo ɗoŋ i lekkiyo aŋgen̰n̰o. ");
INSERT INTO moz_vpl VALUES ("AC17_18","074_17_18","ACT","17","18","18","A ume geŋ i dʼede ɗoŋ ede kane ɗoŋ suuniyo kʼono, oŋgo an daaniya ita wede suuniyo kʼono sundí Epikuris, oŋgo a ita wede suuniyo kʼono sundí Zeno, an di niikiyto ti Pool. Wo yo yi kazita Rabila Majjaanawa kʼIsa wo a urzi balɗiyadí. Aame ɗuwo an illiga iŋkino maŋ, ɗoŋ oŋgo an di ruute, anʼde: «Yi ɓakkiya toŋ moo me?» Wo ɗoŋ oŋgo anʼde: «Yi kazita ono raayagi ɗoŋ a siiɗo kine ye.» ");
INSERT INTO moz_vpl VALUES ("AC17_19","074_17_19","ACT","17","19","19","Iŋkino maŋ an ti yʼ wiike an di-tʼiide kʼekki mokkolo ere daayum ɗoŋ deero siiɗo an tôwwo onamaŋ, wo an di ruute, anʼde: «Urzi kʼonamá ki dooyiso aware eŋ, kaye ay di suune itadaŋ ko? ");
INSERT INTO moz_vpl VALUES ("AC17_20","074_17_20","ACT","17","20","20","Kee kʼay kazita sulɗi ɗoŋ ay kiʼn suune ye, wo aŋkeŋ ay dehu ay di suune koɗuwo i-kaza munɗa me.» ");
INSERT INTO moz_vpl VALUES ("AC17_21","074_17_21","ACT","17","21","21","An rootiyo iŋkino kono ɗoŋ geeger kʼAten pay ti torgagi ɗoŋ i lekkiyo adda siiɗo toŋ, an lekkiyo ti tôwwo taaya ɗaŋŋal wo a ollige ki rabila ere aware. ");
INSERT INTO moz_vpl VALUES ("AC17_22","074_17_22","ACT","17","22","22","Iŋkino maŋ Pool yʼa tʼiiziga a ɗaana deero ɗoŋ siiɗo, wo yʼan di ruute yʼede: «Kune ɗoŋ geeger kʼAten no, a sulɗi pay geŋ ni wolliyo maŋ kun seeɗu zakiɗi miŋ a urzi raayaguŋ. ");
INSERT INTO moz_vpl VALUES ("AC17_23","074_17_23","ACT","17","23","23","Aame ni sooru adda geegirguŋ ette ni wolliyo sulɗi ɓaadaŋ aa raayaguŋ ɗoŋ kun dʼottilso eego, wo ni wulle ume seɗeke soo geŋ raaŋiya eegoʼŋ: “Ki raayusu wede in ki yʼ suune ye.” Iŋkino maŋ kun ollo, nuŋ nʼun di kaza ono ki raayusu wede kun i-dʼottilso wo kun ki yʼ suune ye en̰n̰o. ");
INSERT INTO moz_vpl VALUES ("AC17_24","074_17_24","ACT","17","24","24","Raa wede ikkima duniya ti sulɗi pay ɗoŋ adda geŋ, yoŋ Galmeega ki kandaane ti siiɗo. Yoŋ yi ki lekkiyo ye adda ɓoyɗi ɗoŋ ɗuwo an okkime ti beezaŋ me. ");
INSERT INTO moz_vpl VALUES ("AC17_25","074_17_25","ACT","17","25","25","Wo yi ki dehu ɗuwo an i gi di naabe ɗo ye, yoŋ munɗa tuuku toŋ yi ki dehu ye, kono yode ɗaŋŋal wede in eliyo puukiyo ere in di lekkiyo ti sulɗi ɗoŋ pay me. ");
INSERT INTO moz_vpl VALUES ("AC17_26","074_17_26","ACT","17","26","26","Wo yoŋ Raa yi dʼikkima wedusu soo, wo tʼurzi yode geŋ ita ɗuwo pay ette tʼa iido kono an di lekke a siiɗo pay. Ozzine yʼa ti yʼ ɗikkiɗa, wo yʼan tʼîhinte ƴirwagi ki siiɗiyagi ɗoŋ an di lekka. ");
INSERT INTO moz_vpl VALUES ("AC17_27","074_17_27","ACT","17","27","27","Raa yʼize iŋkino kono ɗuwo an di yʼ dehe, kaŋ totirso toŋ maŋ an di yʼ tʼoone, kono geŋ ki kotto yoŋ dokki ye ti wede tuuku ti diinayiŋ me. ");
INSERT INTO moz_vpl VALUES ("AC17_28","074_17_28","ACT","17","28","28","Geŋ ono eŋ in suune: “Tʼurzi yode kine in di puukiyo, in di sooru, wo in di lekkiyo.” Aakede ɗoŋ suuniyo kʼono oŋgo ti diinaguŋ toŋ anʼde: “Kine in iido ti Raa.” ");
INSERT INTO moz_vpl VALUES ("AC17_29","074_17_29","ACT","17","29","29","Iŋkino aa kine in iido ti Raa geŋ, in ki dʼelke Raa aa yoŋ loŋgusu wede ɗuwo an okkime ki dap, ki maala gurus ise ki moŋgali ti tirɗikadaŋ gen̰n̰o ye. ");
INSERT INTO moz_vpl VALUES ("AC17_30","074_17_30","ACT","17","30","30","Aha iŋkino ye, ti kaaga ɗuwo Raa an ki yʼ suune ye, wo yʼa dihe yi-ki tiʼn tʼele daŋgay ye. Wo aŋkeŋ yi waaku ɗuwo pay tʼume tuuku toŋ maŋ an di-kime lekkiyadaŋ. ");
INSERT INTO moz_vpl VALUES ("AC17_31","074_17_31","ACT","17","31","31","Geŋ Raa yi biire onniyo soo yʼa-ɗekka booro a ɗoŋ duniya pay, wo yʼisiyo iŋkino tʼurzi wede ede yi biire a ɗekka booro ere ki diine me. Yoŋ geŋ wede yʼa ti yʼ bilɗe ti diine ɗoŋ unto, geŋ munɗa wede i-kaza yode geŋ wede Raa yi yʼ biire.» ");
INSERT INTO moz_vpl VALUES ("AC17_32","074_17_32","ACT","17","32","32","Aame ɗoŋ i tʼugiye geŋ an illiga Pool yi ruute a urzi kʼunto ti balɗiya maŋ, ɗoŋ oŋgo an dʼiise okko maadayí wo ɗoŋ oŋgo an i di ruute, anʼde: «Kaye ay dehu soŋŋo maŋ onamaŋ geŋ ay diʼn olliga ki koɗuwo kollo.» ");
INSERT INTO moz_vpl VALUES ("AC17_33","074_17_33","ACT","17","33","33","Iŋkino maŋ Pool ɗoŋ i tʼugiye yiʼn iili, yʼa iŋgile. ");
INSERT INTO moz_vpl VALUES ("AC17_34","074_17_34","ACT","17","34","34","Wo ɗoŋ oŋgo an aa tʼiide ti yode, an di ziipe addaŋ a Isa. Ti diinayaŋ Denis, yoŋ wede ti diine deero siiɗo, wo erewo sundutú Damaris, wo ɗoŋ ti doolo toŋ ede. ");
INSERT INTO moz_vpl VALUES ("AC18_1","074_18_1","ACT","18","1","1","Saŋ maŋ Pool ti Aten yʼa tʼiiziga, yʼa tʼiide geeger Korent. ");
INSERT INTO moz_vpl VALUES ("AC18_2","074_18_2","ACT","18","2","2","A Korent geŋ yi dʼuune Yawudusu sundí Akilas an yʼehe a siiɗo Pontus, wo yʼaaniya ti siiɗo kʼItali kane ti eddí sundutú Pirisil, kono Kilood mozigo goole ki Romeŋ yi dʼize oogoro a Yawudiyagi pay an tʼaɗɗe ti geeger Room te. Maŋ Pool yʼa-ti giƴƴe ti kane. ");
INSERT INTO moz_vpl VALUES ("AC18_3","074_18_3","ACT","18","3","3","Wo yoŋ naabadí aa ki Akilas geŋ, yi lekkiyo ti kane an di naabiya ƴeppiyo tanda ki binɗani ti kane kaŋ soo. ");
INSERT INTO moz_vpl VALUES ("AC18_4","074_18_4","ACT","18","4","4","Daayum a onniyo ere ki puukiyo Yawudiyagi maŋ, Pool yi-tʼettiyo yi kazita adda ɓoy wede Yawudiyagi ge dooyiso, yi niikiyto ti Yawudiyagi wo ti ɗoŋ Girek, wo yi dehu an di-kimo a urzi kʼono Raa. ");
INSERT INTO moz_vpl VALUES ("AC18_5","074_18_5","ACT","18","5","5","Aame Silas ti Timote an iina ti Maseduwan maŋ, Pool yʼa iili peeɗadí pay a kazita kʼono Raa, yʼan di kazita a Yawudiyagi, yʼede Isa yoŋ Almasi Raa yi biire. ");
INSERT INTO moz_vpl VALUES ("AC18_6","074_18_6","ACT","18","6","6","Wo kane Yawudiyagi an di-tuuge, an dʼiise kalɗitadí. Iŋkino maŋ Pool yʼa-rittige kallagí wo yʼan di ruute, yʼede: «Nuŋ sibe ti golladó ni ti yʼ ɗikke puuzaguŋ tʼoopa a egguŋ, nuŋ adda ye. Ti aŋki eŋ nuŋ ni tʼette ki tukki ɗoŋ Yawudiyagi ye.» ");
INSERT INTO moz_vpl VALUES ("AC18_7","074_18_7","ACT","18","7","7","Maŋ Pool ti ume geŋ yʼa tʼuɗɗe, yʼa tʼiide di wede sundí Titiyus Zistus, yoŋ geŋ yʼottilso a Raa, ɓoozí ita waaya ti ɓoy wede Yawudiyagi ge dooyiso me. ");
INSERT INTO moz_vpl VALUES ("AC18_8","074_18_8","ACT","18","8","8","Aame geŋ goole ɓoy wede Yawudiyagi ge dooyiso, sundí Kirisipus, yʼa ziipe addí a Galmeega ti ɗoŋ ɓoozí pay. Ɗoŋ geeger Korent ɗoŋ illiga ono Pool toŋ, ɓaadaŋ an di ziipe addaŋ a Isa wo an di zuyye batem. ");
INSERT INTO moz_vpl VALUES ("AC18_9","074_18_9","ACT","18","9","9","Onniyo soo a diɗɗo maŋ Pool i-dʼiido munɗa aa suniye, wo Galmeega yi di ruute, yʼede: «Kee kʼorgiɗe ye a ɗoŋ eŋ me, ki kazita ono Raa me kʼanniga ye. ");
INSERT INTO moz_vpl VALUES ("AC18_10","074_18_10","ACT","18","10","10","Nuŋ ti kee, wenɗa soo toŋ yʼa-ga da botta ye kʼisiyo kʼulsu me, kono adda geeger ette nuŋ ɗoŋzóʼŋ ɓaadaŋ.» ");
INSERT INTO moz_vpl VALUES ("AC18_11","074_18_11","ACT","18","11","11","Iŋkino maŋ Pool yʼa likke adda geeger Korent ozzine ti tere zoot, yʼa duuyite ono Raa a ɗoŋ pay. ");
INSERT INTO moz_vpl VALUES ("AC18_12","074_18_12","ACT","18","12","12","Aame Galiyoŋ yoŋ Romeŋ goole siiɗo ki Akayi geŋ, kane Yawudiyagi an di gitte onamaŋ kaŋ soo an di seeɗa Pool. An yi ziiɗa maŋ, an di-tʼiide kʼume deero booro, ");
INSERT INTO moz_vpl VALUES ("AC18_13","074_18_13","ACT","18","13","13","wo an di ruute, anʼde: «Wede eŋ yi tiʼn argu ɗuwo an dʼottile a Raa tʼurzi wede ti doolo aa ki oogoro ti ki rootiyo ye.» ");
INSERT INTO moz_vpl VALUES ("AC18_14","074_18_14","ACT","18","14","14","Paraʼŋ Pool yi dehu yʼa tʼihina bizí yʼa roote, miŋ Galiyoŋ yʼan di ruute, yʼede: «Kune Yawudiyagi no, aame wede eŋ yʼize munɗa wede ulsu, koo ise yi ti daggiya ɗuwo maŋ, kesiko booro nʼun tʼise. ");
INSERT INTO moz_vpl VALUES ("AC18_15","074_18_15","ACT","18","15","15","Wo ɗe kun niikiyto a urzi dooyiso, a sumɓiyagi ɗuwo wo a urzi kʼoogiraguŋ maŋ, geŋ a wollo kune baa, nuŋ ni kʼaane ni ki koone booro ki sulɗi gen̰n̰o ye.» ");
INSERT INTO moz_vpl VALUES ("AC18_16","074_18_16","ACT","18","16","16","Wo tʼume booro Galiyoŋ yʼan diʼn igibe. ");
INSERT INTO moz_vpl VALUES ("AC18_17","074_18_17","ACT","18","17","17","Iŋkino maŋ kane ɗoŋ duuru geŋ, goole ɓoy wede Yawudiyagi ge dooyiso sundí Susten, an di yʼ ziiɗa, an di yʼ gusse a ɗaana ɗoŋ booro, wo ɗe Galiyoŋ yʼa tʼiiɗiba eedí. ");
INSERT INTO moz_vpl VALUES ("AC18_18","074_18_18","ACT","18","18","18","Pool yʼa likke onniyto ɓaadaŋ sey a Korent me, saŋ zemɓa yiʼn iili, yʼa tʼiide biza bar ki geeger Saŋkire, an a-giƴƴe ti Pirisil wo Akilas. A ume geŋ eedí yʼa-gûuke, kono yi ruute yi-dʼisa munɗa a Raa wo aŋkeŋ yʼa ti ɗiŋge baa. Saŋ an di-gili adda tooko, an dʼeŋgile ki siiɗo Siiri. ");
INSERT INTO moz_vpl VALUES ("AC18_19","074_18_19","ACT","18","19","19","An iiney a geeger kʼEpez maŋ, Pirisil ti Akilas Pool yiʼn iili aŋgen̰n̰o, wo yoŋ yʼa tʼiide kʼadda ɓoy wede Yawudiyagi ge dooyiso, an di niikiyto ti kane Yawudiyagi. ");
INSERT INTO moz_vpl VALUES ("AC18_20","074_18_20","ACT","18","20","20","Kane an di yʼ tunde yʼa-lekke ti kane, miŋ yoŋ yʼede: «Aha, nuŋ ni ki lekka ye.» ");
INSERT INTO moz_vpl VALUES ("AC18_21","074_18_21","ACT","18","21","21","Wo yʼan diʼn iili, yʼa ruute yʼede: «Raa yi dehu maŋ, saŋ nʼa kimo.» Wo yʼa iŋgile kʼEpez ti tooko. ");
INSERT INTO moz_vpl VALUES ("AC18_22","074_18_22","ACT","18","22","22","Aame Pool yʼiiney a geeger Sezare maŋ, yʼa tʼiide ki poone ki Zeruzalem yʼa tʼeeso ɗoŋ ogiyso ti suma kʼIsa, saŋ yʼa-ɗiige ki geeger kʼAntiyos siiɗo Siiri. ");
INSERT INTO moz_vpl VALUES ("AC18_23","074_18_23","ACT","18","23","23","A Antiyos yi likke onniyto miibi, saŋ yʼa-gime yi tʼuɗɗe ti siiɗo Galat, yʼa tûukey siiɗo Pirizi, yʼan dʼeelite kooke a kane pay sanalliyagi kʼIsa. ");
INSERT INTO moz_vpl VALUES ("AC18_24","074_18_24","ACT","18","24","24","A ume geŋ i dʼede Yawudusu sundí Apolos, yoŋ an yʼehe a geeger kʼAlegzandiri, yʼa iina Epez. Yoŋ ono ɗoŋ an riiŋe ti kaaga adda mattup ki Raa, yiʼni suune koɗuwo wo yi rootiyto beehiye. ");
INSERT INTO moz_vpl VALUES ("AC18_25","074_18_25","ACT","18","25","25","A urzi Galmeega geŋ ɗuwo an yi duuye ɓaadaŋ, yi kazita tʼadde soo, yi dooyiso ti ɗerec a urzi kʼIsa me, wo yi suune suyyiso batem ere ki Zaŋ ɗaŋŋal. ");
INSERT INTO moz_vpl VALUES ("AC18_26","074_18_26","ACT","18","26","26","Adda ɓoy wede Yawudiyagi ge dooyiso, yi kazita daa kʼorgiso ono Raa me. Wo aame Pirisil ti Akilas an yʼilliga maŋ, an ti yʼ wiike ti kane, an i-di gizite koɗuwo ɗerec ki Raa te. ");
INSERT INTO moz_vpl VALUES ("AC18_27","074_18_27","ACT","18","27","27","Saŋ maŋ Apolos yʼa dihe yʼa tʼette ki siiɗo kʼAkayi, iŋkino maŋ zemɓa an i-dʼeele kooke, wo an an di riiŋe mattup a sanalliyagi kʼIsa a siiɗo kʼAkayi kono an di yʼ seeɗa bey sire. Aame yʼiiney a ummey maŋ, an tʼize beehiye ɓaadaŋ a kane ɗoŋ i ziipe addaŋ a Isa tʼurzi beeko ere ki Raa me. ");
INSERT INTO moz_vpl VALUES ("AC18_28","074_18_28","ACT","18","28","28","Ti Yawudiyagi an di niikiyto, yʼan di gize keren̰ tʼurzi kʼono ɗoŋ an riiŋe ti kaaga adda mattup ki Raa: Isa yoŋ Almasi Raa yi biire. Iŋkino maŋ a elkisadaŋ gette yʼan di ruute a ɗaana ɗuwo pay, yʼede: «Kune kun digge.» ");
INSERT INTO moz_vpl VALUES ("AC19_1","074_19_1","ACT","19","1","1","Aame Apolos yo a Korent geŋ, Pool yi-tʼuɗɗe ti siiɗo kʼAazi ere adda moŋgali, yʼa iiney Epez. Aŋgeŋ an dʼikkima ti sanalliyagi kʼIsa oŋgoŋ, ");
INSERT INTO moz_vpl VALUES ("AC19_2","074_19_2","ACT","19","2","2","wo yʼanni tunde, yʼede: «Aame kun ziipe adduguŋ a Isa geŋ, Unde Kamilen̰ kun uune ɗey ko?» Maŋ kane an diʼn gime onamí, anʼde: «Kaye ay kʼilliga ye Unde Kamilen̰ ede toŋ maŋ.» ");
INSERT INTO moz_vpl VALUES ("AC19_3","074_19_3","ACT","19","3","3","Iŋkino maŋ Pool yʼanni tunde, yʼede: «Suyyiso batem ere tuuku kun uune te?» Kane an diʼn gime onamí, anʼde: «Ay uune suyyiso batem tʼurzi dooyiso ere ki Zaŋ.» ");
INSERT INTO moz_vpl VALUES ("AC19_4","074_19_4","ACT","19","4","4","Pool yʼan di ruute, yʼede: «Ti kaaga Zaŋ yi zuyye batem ɗoŋ kʼIzirayel kono a kize an di-kime lekkiyadaŋ, wo soŋ yʼan di rootiyo an zaapo addaŋ a wede etto kʼitadí, yoŋ Isa.» ");
INSERT INTO moz_vpl VALUES ("AC19_5","074_19_5","ACT","19","5","5","Aame an illiga iŋkino maŋ, an di zuyye batem ti suma Galmeega Isa. ");
INSERT INTO moz_vpl VALUES ("AC19_6","074_19_6","ACT","19","6","6","Pool yʼan di ziipe bey a eedaŋ, wo an dʼuune Unde Kamilen̰. Iŋkino maŋ an dʼiise orbe tʼono ɗoŋ doolo, wo an di rootiyto ono ɗoŋ Raa yʼigibo. ");
INSERT INTO moz_vpl VALUES ("AC19_7","074_19_7","ACT","19","7","7","Kane pay ɗoŋ i zuyye batem geŋ kuuli suma koomat makumu sire. ");
INSERT INTO moz_vpl VALUES ("AC19_8","074_19_8","ACT","19","8","8","Adda tere aɗo geŋ, daayum Pool yi-tʼettiyo kʼadda ɓoy wede Yawudiyagi ge dooyiso, yi rootiso daa kʼorgiso. Yi kazita urzi Moziko Raa, yi dehu yʼan tiʼn kimo kʼurzi gen̰n̰o ɗoŋ i yʼollige me. ");
INSERT INTO moz_vpl VALUES ("AC19_9","074_19_9","ACT","19","9","9","Wo ɗe Yawudiyagi oŋgo an ki dehu an ki yʼolliga ye, an di-tuuge ki zaapu kʼaddaŋ a Isa me, a dooyisadí ere a urzi Galmeega gette an di yʼokko maade a ɗaana ɗuwo pay. Iŋkino maŋ Pool yʼan diʼn iili, yʼa wiike kane sanalliyagi kʼIsa, yi diʼn dooyiso daayum adda ɓoy ki lokkon ki wede soo sundí Tiranus. ");
INSERT INTO moz_vpl VALUES ("AC19_10","074_19_10","ACT","19","10","10","Geŋ yʼanni duuye ozzine sire, iŋkino maŋ kane pay ɗoŋ siiɗo kʼAazi, Yawudiyagi ti ɗoŋ Yawudiyagi ye, an dʼilliga ono Galmeega me. ");
INSERT INTO moz_vpl VALUES ("AC19_11","074_19_11","ACT","19","11","11","Raa yi dʼisiyo sulɗi kʼarmika ɗoŋ kʼa seeɗa giggirá tʼurzi Pool. ");
INSERT INTO moz_vpl VALUES ("AC19_12","074_19_12","ACT","19","12","12","Iŋkino maŋ an dʼamɓu kalle koo ise buuɗe koo maŋ i butte tukki Pool, saŋ anʼtiyo an an bottiyo a tukki ɗoŋ kʼeeni, maŋ kane geŋ an dʼooniyo bee, wo kane siitanɗani toŋ an tʼaɗɗiya ti eedaŋ me. ");
INSERT INTO moz_vpl VALUES ("AC19_13","074_19_13","ACT","19","13","13","A ume geŋ i dʼede Yawudiyagi an sooru ti zindaŋ an dʼettiyo ume ti ume, an di lommite siitanɗani ti tukki ɗoŋ kʼeeni. Iŋkino an diʼn nîime lommite ti suma Galmeega Isa pay, a siitanɗani wede tuuku toŋ yi dʼeesiyo: «Ti suma kʼIsa wede Pool yi-kazita, ni rootiyo kun tʼaɗɗo!» ");
INSERT INTO moz_vpl VALUES ("AC19_14","074_19_14","ACT","19","14","14","Ɗoŋ isiyo iŋkino geŋ kane in̰n̰i sarat ki Seba, yoŋ Yawudusu ti diine deero ɗoŋ seɗeke. ");
INSERT INTO moz_vpl VALUES ("AC19_15","074_19_15","ACT","19","15","15","Onniyo soo siitan tʼan di ruute, tʼede: «Isa ni yʼ suune, wo Pool toŋ ni yʼ suune, wo ɗe kune miŋ kune aŋ wee wee?» ");
INSERT INTO moz_vpl VALUES ("AC19_16","074_19_16","ACT","19","16","16","Wo wede i-dʼede siitan a eedí geŋ yʼa tʼiiziga, yʼanni zikke, yʼiide yʼan tiʼn tiiza pay kono yoŋ yi jiire kane, yʼan dʼize ulsu, an dʼukkite bontilin̰ tʼadda ɓoozí me, tuddaŋ kunɗayi jerem. ");
INSERT INTO moz_vpl VALUES ("AC19_17","074_19_17","ACT","19","17","17","A munɗa wede ize geŋ, ɗoŋ pay kʼEpez, Yawudiyagi ti ɗoŋ Yawudiyagi ye an illiga maŋ, orgiso tʼanni ziiɗa pay wo an dʼimme gooliko ere ki suma Galmeega Isa. ");
INSERT INTO moz_vpl VALUES ("AC19_18","074_19_18","ACT","19","18","18","Ɗoŋ ɓaadaŋ ti diine ɗoŋ i ziipe addaŋ a Isa an dʼettiyo an tʼooɗibe addaŋ, wo an tondiyo tambobino a ɗaana ɗuwo pay a olɗikadaŋ ere an ize gette. ");
INSERT INTO moz_vpl VALUES ("AC19_19","074_19_19","ACT","19","19","19","Wo ti diine ɗoŋ i sokiyto ɗinɗoriyo geŋ, ɗoŋ ɓaadaŋ an di ziki mattupiyagi ki ɗinɗoriyagaŋ, an tʼigge a ɗaana ɗuwo pay. An di-gize zooye mattupiyagi geŋ suma tamma dupu ada paat. ");
INSERT INTO moz_vpl VALUES ("AC19_20","074_19_20","ACT","19","20","20","Geŋ iŋkino ti toogo ere ki Galmeega, ono Raa i dʼettiyo ɗaana ki ɗaana ti toogo ere i ceeriyo ɓaadaŋ. ");
INSERT INTO moz_vpl VALUES ("AC19_21","074_19_21","ACT","19","21","21","Aame sulɗi geŋ i tʼiŋgile maŋ, Pool tʼurzi kʼUnde Raa yʼa dihe yʼa tʼette Zeruzalem, wo ki poone yʼa aɗɗe ti siiɗo Maseduwan, yʼa tôokey Akayi. Wo yʼa ruute, yʼede: «Nʼiiney Zeruzalem maŋ, i dehu nʼa aaney a geeger Room pây.» ");
INSERT INTO moz_vpl VALUES ("AC19_22","074_19_22","ACT","19","22","22","Iŋkino maŋ yi dʼigibe ki ɗaanadí ɗoŋ noogiyadí sire, Timote ti Erasta an dʼiŋgile ki Maseduwan, wo yode batum yʼa likke onniyto miibi a siiɗo kʼAazi me. ");
INSERT INTO moz_vpl VALUES ("AC19_23","074_19_23","ACT","19","23","23","Aame geŋ ɗoŋ kʼEpez an dʼiiziga tarkuuse ɓaadaŋ ki kulkuwo a urzi Galmeega. ");
INSERT INTO moz_vpl VALUES ("AC19_24","074_19_24","ACT","19","24","24","A ume geŋ i dʼede wede sundí Demetirus, yoŋ wede naabo maala yi dʼokkimte ɓoyɗi sun̰n̰i sun̰n̰i ki maala gurus, i deeƴiso ɓoy wede goole ki raayawa sundutú Artemis, ɗoŋ pay an dʼottilso. Iŋkino maŋ Demetirus ti ɗoŋ naabadí an dʼooniyo soŋko ɓaadaŋ ti naabadaŋ gette. ");
INSERT INTO moz_vpl VALUES ("AC19_25","074_19_25","ACT","19","25","25","Onniyo soo yʼan ugiye ɗoŋ naabadí ti ɗoŋ an naabiya kaŋ soo geŋ, yʼan di ruute, yʼede: «Laŋziyagi ki nuŋ, kun suune kine in tʼize ɗoŋ bey miŋ ti naabadiŋ ettiyo. ");
INSERT INTO moz_vpl VALUES ("AC19_26","074_19_26","ACT","19","26","26","Wo aŋkeŋ kun ollige wo kun wolliyo munɗa wede isiyo eŋ me. Yo Pool geŋ ɗoŋ ɓaadaŋ yiʼn tiʼn kama kʼurzi yode, yʼan di rootiyo, yʼede: “Raayagi ɗoŋ ɗuwo an okkime ti beezaŋ geŋ, kane raayagi ye.” Yʼisiyo iŋkino a en̰n̰o ɗaŋŋal ye, wo a omagi ɓaadaŋ ki siiɗo kʼAazi pay. ");
INSERT INTO moz_vpl VALUES ("AC19_27","074_19_27","ACT","19","27","27","Naabo yode gette tʼiida ki ɗaana maŋ, ɗuwo an di-kiigira naabadiŋ te, wo naabo kine ɗaŋŋal ye, an di kiigira ɓoy raayawa ere meeda sundutú Artemis, a tʼisa aa munɗa ki bita. Iŋkino maŋ meedikatú tʼa dagga, todʼte raayawa ere ɗuwo pay adda siiɗo kʼAazi an i-dʼottilso, wo adda duniya pay ette.» ");
INSERT INTO moz_vpl VALUES ("AC19_28","074_19_28","ACT","19","28","28","Aame kane ɗoŋ naabo pay an illiga ono ɗoŋ Demetirus yi ruute gen̰n̰o maŋ, an di kulkuwe, an dʼiise ɗollite, anʼde: «Raayawa Artemis ki ɗoŋ kʼEpez, todʼte meeda!» ");
INSERT INTO moz_vpl VALUES ("AC19_29","074_19_29","ACT","19","29","29","Taŋ booloŋ maŋ ɗoŋ duuru eedaŋ tʼa îide, kane ɗoŋ geeger pay geŋ an di gulkuwe, wo an tiʼn ziɗɗe Gayus ti Aristarko me, kane ti Maseduwan, an iido ti Pool kaŋ soo. An dʼan tʼiide ki bere ɗoŋ duuru. ");
INSERT INTO moz_vpl VALUES ("AC19_30","074_19_30","ACT","19","30","30","Iŋkino maŋ Pool yi dehu yʼa ette ki ɗaana ɗoŋ duuru yʼa rootey ono, wo kane sanalliyagi kʼIsa an i di-tuuge. ");
INSERT INTO moz_vpl VALUES ("AC19_31","074_19_31","ACT","19","31","31","Wo kane laŋziyagi Pool geŋ, ɗoŋ deero ki naabiyagi adda siiɗo kʼAazi toŋ, an i-dʼigibo a yode anʼde, yʼetta ye ki bere ɗoŋ duuru me. ");
INSERT INTO moz_vpl VALUES ("AC19_32","074_19_32","ACT","19","32","32","A ume geŋ a iizi tarkuuse ɓaadaŋ sey adda diine ɗoŋ duuru me, ɗoŋ oŋgo an ɗollite ken̰n̰o, ɗoŋ soŋ an ɗollite kʼummey, wo ɗoŋ oŋgo ɓaadaŋ urzi an ugiye ki munɗa toŋ an ki suune ye. ");
INSERT INTO moz_vpl VALUES ("AC19_33","074_19_33","ACT","19","33","33","Iŋkino maŋ i dʼede wede sundí Alegzandire, yo kane Yawudiyagi oŋgoŋ an di yʼ ŋaaƴu ki ɗaana yʼa roote ono a ɗuwo, wo ɗoŋ oŋgo ti diine ɗoŋ duuru an i di tʼîide taaya a urzi kʼono gen̰n̰o. Iŋkino yʼan dʼize likuw ti beezí, yi dehu yʼan di roote a ɗoŋ duuru geŋ me. ");
INSERT INTO moz_vpl VALUES ("AC19_34","074_19_34","ACT","19","34","34","Wo ɗe aame kane ɗoŋ kʼEpez geŋ an zuune Alegzandire Yawudusu maŋ, an dʼiise ɗollite pay onamaŋ kaŋ soo suma peeɗo sire, anʼde: «Raayawa Artemis ki ɗoŋ kʼEpez, todʼte meeda!» ");
INSERT INTO moz_vpl VALUES ("AC19_35","074_19_35","ACT","19","35","35","An iɗilti kee maŋ, i dʼede wedusu yoŋ wede raaŋiya ki sulɗi pay adda geeger geŋ, yʼa iine yʼan inniga, wo yʼan di ruute, yʼede: «Kune ɗoŋ kʼEpez geŋ, ɗuwo pay an suune kine ɗoŋ geeger kʼEpez, kine ɗoŋ boohiyo ɓoy kʼArtemis todʼte meeda, wo ki mokkilsatú ere iiro ti kandaane. ");
INSERT INTO moz_vpl VALUES ("AC19_36","074_19_36","ACT","19","36","36","Geŋ wenɗa soo toŋ a niike umbo, iŋkino maŋ kun tʼasso wo kun tʼelko koɗuwo a munɗa wede kun dehu kun dʼise me. ");
INSERT INTO moz_vpl VALUES ("AC19_37","074_19_37","ACT","19","37","37","Ɗuwo eŋ kun tiʼn ziɗɗo ken̰n̰o, an un kʼuugiro munɗa tʼadda ɓoy raayawa ye, wo an ki gilɗite raayawa kine ye. ");
INSERT INTO moz_vpl VALUES ("AC19_38","074_19_38","ACT","19","38","38","Wo aame Demetirus ti ɗoŋ an naabiya kaŋ soo geŋ an dʼede ono a tukki wenɗa maŋ, onniyo booro ede, an dʼette kʼume ɗoŋ ɗekkiyo booro, an an di tʼîde taaya. ");
INSERT INTO moz_vpl VALUES ("AC19_39","074_19_39","ACT","19","39","39","Wo un dʼede munɗa ti doolo toŋ maŋ, an di tonde ɗoŋ duuru ɗoŋ i wolliyo urzi kʼoogoro, an diʼn okkima ono me. ");
INSERT INTO moz_vpl VALUES ("AC19_40","074_19_40","ACT","19","40","40","Aame kun kʼooli ye maŋ, in tʼoona ono, Romeŋ an tʼeesa kine in kulkiso ti kane a ogiyso ere aŋki ette. Iŋkino a ogiysadiŋ ette urzi in ki tʼoona ye, in an di roota addaŋ a-tʼassa me.» Aame wede geŋ yʼa ti ɗiŋge onamí maŋ, yʼan di ruute a ɗoŋ duuru, yʼede: «Kun ti teepo.» ");
INSERT INTO moz_vpl VALUES ("AC20_1","074_20_1","ACT","20","1","1","Aame ɗoŋ kʼEpez kulkuwadaŋ i tʼisse maŋ, Pool sanalliyagi kʼIsa yʼan ugiye yʼan dʼeele kooke. Maŋ yʼan tʼize toose, yiʼn iili, yʼa iŋgile ki siiɗo Maseduwan. ");
INSERT INTO moz_vpl VALUES ("AC20_2","074_20_2","ACT","20","2","2","Aame yi doopiɗe Maseduwan geŋ, sanalliyagi ɗoŋ yʼooniyo a ɗaanadí, yʼan dʼeeliyo kooke ɓaadaŋ. Saŋ yʼa iiney a siiɗo Gires, ");
INSERT INTO moz_vpl VALUES ("AC20_3","074_20_3","ACT","20","3","3","aŋgeŋ yʼa likke tere aɗo. Saŋ maŋ yʼa dihe yi di kili adda tooko, yʼa eŋgile ki siiɗo Siiri, wo maŋ yʼa illiga kane Yawudiyagi an i-tʼikke a urzi. Iŋkino maŋ yʼa dihe yʼa-tooye yʼa aɗɗe ti Maseduwan. ");
INSERT INTO moz_vpl VALUES ("AC20_4","074_20_4","ACT","20","4","4","Kane ɗoŋ a itadí geŋ, kane Sopater ulo ki Pirus ti geeger Beere, Aristarko wo Segondus ti geeger Tessaloni, Gayus ti geeger Derbe, wo Timote, Tisik wo Tiropim kane aɗo geŋ ti siiɗo kʼAazi. ");
INSERT INTO moz_vpl VALUES ("AC20_5","074_20_5","ACT","20","5","5","Kane geŋ an ay dʼuugume, an dʼiŋgile an ay diʼn delley a geeger Tirowas. ");
INSERT INTO moz_vpl VALUES ("AC20_6","074_20_6","ACT","20","6","6","Wo kayeʼŋ tarnaape mappa daa kʼorme ay dʼize a geeger Pilip. Aame onniyto tarnaape mappa daa kʼorme ti tʼiŋgile maŋ, ay di gili adda tooko, ti geeger Pilip ay dʼiŋgile. Onniyo paat ki ɗaana maŋ, saŋ ɗoŋzey ay diʼn uuney a Tirowas, aŋgeŋ ay dʼize onniyo sarat. ");
INSERT INTO moz_vpl VALUES ("AC20_7","074_20_7","ACT","20","7","7","A onniyo ere ki puukiyo Yawudiyagi a tukki lohe maŋ, ay tʼugiye ay dʼiimi kaŋ soo mappa wede i-kaza tudde kʼIsa me. Wo kono soggo yo Pool yʼeŋgila geŋ, yʼan di gizite ono a zemɓa, yʼa gizite bini diɗɗo meeda. ");
INSERT INTO moz_vpl VALUES ("AC20_8","074_20_8","ACT","20","8","8","Adda biino ere tʼawwa tʼekki bakatú kaye ay tʼugiye geŋ, lampiyagi ɓaadaŋ oyyisito. ");
INSERT INTO moz_vpl VALUES ("AC20_9","074_20_9","ACT","20","9","9","Aame geŋ i dʼede ulo sundí Itus yi-guune a pineetir, yʼollige Pool yi kazita. Wo yo Pool geŋ yi kʼôhire ye, yi kazita yi kazita, maŋ ulo geŋ edayí i ziiɗa moone, yʼa udige kuy. Iŋkino tʼawwa ti ɓoy wede kʼaɗuwe geŋ yi-tʼuubo, yʼa iire siiɗo. Wo i dʼede wede ede yi yʼiiziga maŋ, yʼinda. ");
INSERT INTO moz_vpl VALUES ("AC20_10","074_20_10","ACT","20","10","10","Iŋkino maŋ kesiko Pool yi-ti ɗiige, yʼa iide kʼume kʼulo gen̰n̰o, yʼaa dʼuttile yʼa ti yʼ ziiɗa giggirí, wo yʼa ruute, yʼede: «Ulbuguŋ un tʼooɗe ye, uloʼŋ puukiyadí to ede.» ");
INSERT INTO moz_vpl VALUES ("AC20_11","074_20_11","ACT","20","11","11","Saŋ maŋ Pool yʼa-gili kʼawwa kʼumayí, yʼa tʼumɓe mappa, yʼan di ɓurkite an tʼiimi, wo Pool yʼa iise kazita sey bini ume yʼa tʼumpile. Saŋ maŋ yʼa iŋgile. ");
INSERT INTO moz_vpl VALUES ("AC20_12","074_20_12","ACT","20","12","12","Wo yo obulsu geŋ aame an ti yʼumɓe zeere yi biygile maŋ, an di yʼigibe a ɓoozí, wo kane ɗuwo pay geŋ addaŋ a tʼudige kollo. ");
INSERT INTO moz_vpl VALUES ("AC20_13","074_20_13","ACT","20","13","13","Saŋ maŋ kaye ay yi-dʼuugume a Pool me, ay di-gili adda tooko, ay dʼiŋgile ki geeger kʼAssos, ume ay di yʼ delley aa yoŋ yi dihe, kono yi dehu yʼa ozire ti zoŋɗí. ");
INSERT INTO moz_vpl VALUES ("AC20_14","074_20_14","ACT","20","14","14","Geŋ a Assos Pool yʼay diʼn uuney, maŋ pay kaŋ soo ay di-gili adda tooko, ay dʼiŋgile geeger Mitilen. ");
INSERT INTO moz_vpl VALUES ("AC20_15","074_20_15","ACT","20","15","15","Ti Mitilen ay dʼiŋgile, soggo ay dʼiiney a siiɗo ere a diine kʼahu sundutú Kiyos. Onniyo sirwe maŋ ay dʼiiney a siiɗo ere a diine kʼahu sey sundutú Samos, wo onniyo kʼaɗuwe ay dʼiiney a geeger ki Mile. ");
INSERT INTO moz_vpl VALUES ("AC20_16","074_20_16","ACT","20","16","16","Urzi kʼEpez ay dʼiili, ay dʼiŋgile tʼurzizey kono Pool yi ki dehu yi kʼôhira a Epez, kono yi gi di tʼôssa a siiɗo kʼAazi ye. Yi dehu yʼa aaney kesiko a Zeruzalem, yʼa dʼaaney a tarnaape Pantekot ki Yawudiyagi. ");
INSERT INTO moz_vpl VALUES ("AC20_17","074_20_17","ACT","20","17","17","Aame ay iiney a Mile maŋ, Pool yi dʼigibe wedusu ki Epez yʼan di kizo a ɗoŋ dokkiyoɗoŋ ogiyso ti suma kʼIsa, yʼede: «Kunʼdo, kun di tʼoona a Mile.» ");
INSERT INTO moz_vpl VALUES ("AC20_18","074_20_18","ACT","20","18","18","Aame ɗoŋ dokkiyo an iina a sirpadí maŋ, Pool yʼan di ruute, yʼede: «Kun ollo, kune kun ti suune lekkiyo ere ki nuuno te, kono nuŋ ni likke a diinaguŋ ti onniyo ere ki poone nʼiina adda siiɗo kʼAazi me. ");
INSERT INTO moz_vpl VALUES ("AC20_19","074_20_19","ACT","20","19","19","Nuŋ ni niibe a Galmeega a diinaguŋ me ti ottilso ɓaadaŋ, ti môolo wo ti dabar ere ki Yawudiyagi kane an o koniyo eego. ");
INSERT INTO moz_vpl VALUES ("AC20_20","074_20_20","ACT","20","20","20","Kun suune nuŋ nʼun ti gizite, wo nʼun tiʼn duuye pay, munɗa umbo nʼun kʼiŋga ye, wede aase beehiye a kune me, ise a ɗaana ɗuwo pay, ise adda ɓoyɗuguŋ toŋ maŋ. ");
INSERT INTO moz_vpl VALUES ("AC20_21","074_20_21","ACT","20","21","21","Nuŋ nʼan gizite a Yawudiyagi wo a ɗoŋ Yawudiyagi ye, an di-kime lekkiyadaŋ a ɗaana Raa wo an zaape addaŋ a Galmeegiŋ Isa Almasi. ");
INSERT INTO moz_vpl VALUES ("AC20_22","074_20_22","ACT","20","22","22","Wo aŋkeŋ nʼeŋgile ki Zeruzalem, kono nuŋ i ni dokkiyo Unde Kamilen̰ ni dʼoyyiso, wo ni ki suune ye munɗa wede a ummey o aaney a eedó me. ");
INSERT INTO moz_vpl VALUES ("AC20_23","074_20_23","ACT","20","23","23","Wo adda geegiryagi ɗoŋ pay nʼettiyo geŋ, Unde Kamilen̰ tʼo kaza daŋgay ti dabar ɓaadaŋ an ni delliyo. ");
INSERT INTO moz_vpl VALUES ("AC20_24","074_20_24","ACT","20","24","24","Wo nuŋ lekkiyadó a duniya ette i ki nʼoon̰iso ye. Munɗa wede i nʼoon̰isoʼŋ, naabo ere Galmeega Isa yʼo ele gettiyo, nʼa ti naabe bini ɗaŋgutú: nʼa kizite urzi Rabila Majjaanawa, mummino i-kaza Raa yoŋ wede beeko me. ");
INSERT INTO moz_vpl VALUES ("AC20_25","074_20_25","ACT","20","25","25","Ɗerec, kun suune ni likke a diine kune pay, nʼun di gizite urzi Moziko Raa, wo ti aŋki ki ɗaana eŋ nuŋ ni-suune kun ki nʼ wolla ye baa. ");
INSERT INTO moz_vpl VALUES ("AC20_26","074_20_26","ACT","20","26","26","Kono kamo kun ollo koɗuwo ti aŋki nʼun di rooto, aame wede yi digga tʼurzi Raazí maŋ, nuŋ adda ye, ");
INSERT INTO moz_vpl VALUES ("AC20_27","074_20_27","ACT","20","27","27","kono nʼun ti gizite pay munɗa wede Raa yʼilke ti poone yʼaasa me, munɗa umbo nʼun kʼiŋga ye. ");
INSERT INTO moz_vpl VALUES ("AC20_28","074_20_28","ACT","20","28","28","Iŋkino maŋ kun koona mentikagi a urzi lekkiyaguŋ, wo a tukki torɗo pay ere ki Raa ogiyso ti suma kʼIsa. Tode gette Unde Kamilen̰ tʼun tʼele kun diʼn dokke, kun tʼelso aa damɓami ɗoŋ Raa yʼiwila tʼurzi puuzo kʼUlí Isa. ");
INSERT INTO moz_vpl VALUES ("AC20_29","074_20_29","ACT","20","29","29","Nuŋ ni suune, aame nʼun iza umbo maŋ ɗoŋ ulpi an tʼetta diinaguŋ, an un dʼisa ulsu aa sullibagi an tʼettiyo adda diine torɗo. ");
INSERT INTO moz_vpl VALUES ("AC20_30","074_20_30","ACT","20","30","30","Wo ɗoŋ oŋgo ti diinaguŋ toŋ an di dooya rabila ere kʼa tʼeese ɗerec, an di roon̰a adde sanalliyagi oŋgo, an diʼn daana. ");
INSERT INTO moz_vpl VALUES ("AC20_31","074_20_31","ACT","20","31","31","Iŋkino maŋ kun lekko zeere, wo kun elko: aame nuŋ di kune adda kʼozzine aɗo geŋ, diɗɗo wo on̰n̰u nʼa-tʼîile toŋ ni kʼiili ye, wede tuuku ti diinaguŋ tʼeeliyo kooke me. ");
INSERT INTO moz_vpl VALUES ("AC20_32","074_20_32","ACT","20","32","32","Wo aŋkeŋ nuŋ nʼun diʼn oolo a bey Raa, wo a onamí ɗoŋ a urzi beekadí. Kane ono Raa geŋ an un diʼn isa ɗoŋ toogo a urzi zaapu kʼadduguŋ a Isa, wo tʼurzi kʼono Raa kun tʼooney sulɗi ɗoŋ Raa yi boohiyo a ɗoŋzí pay. ");
INSERT INTO moz_vpl VALUES ("AC20_33","074_20_33","ACT","20","33","33","Nuŋ ni ki ziipe ye addó a maala gurus, a dap, ise a kalle wenɗa soo toŋ maŋ. ");
INSERT INTO moz_vpl VALUES ("AC20_34","074_20_34","ACT","20","34","34","Kune batum kun suune, nuŋ ni niibe ti beezó, ni dʼooniyo munɗa a lekkiyadó te wo ti ɗoŋ pay a itadó. ");
INSERT INTO moz_vpl VALUES ("AC20_35","074_20_35","ACT","20","35","35","A sulɗi ɗoŋ pay nʼize geŋ, nʼun gizite beehiye in di naabe in di nooge ɗoŋ an kʼede munɗa ye, wo in elko a ono ɗoŋ Galmeega Isa yi ruute, yʼede: “Uŋsuwo ɓaadaŋ a jiire a wede yʼeliyo munɗa, ti wede an i eliyo munɗa.”» ");
INSERT INTO moz_vpl VALUES ("AC20_36","074_20_36","ACT","20","36","36","Aame Pool yʼa ti ɗiŋge onamí maŋ, yʼa dikke ti kane pay wo yʼa tunde Raa. ");
INSERT INTO moz_vpl VALUES ("AC20_37","074_20_37","ACT","20","37","37","Iŋkino maŋ kane pay an dʼiise môolo, wo wede tuuku toŋ yi di yʼ seeɗu giggirí yop, yi-dʼeeziyo dʼeeziyo kono an ki tʼikkima ye baa. ");
INSERT INTO moz_vpl VALUES ("AC20_38","074_20_38","ACT","20","38","38","Kane an tʼize sommagi dondoŋ a onamí ɗoŋ yi ruute, yʼede: «Ti aŋki ki ɗaana eŋ, nuŋ kun ki nʼ wolla ye baa» geŋ me. Saŋ maŋ an aa di yʼigibe bini yʼa di-gili adda tooko. ");
INSERT INTO moz_vpl VALUES ("AC21_1","074_21_1","ACT","21","1","1","Aame zemɓa ayʼn iilo maŋ, ti tooko ay dʼiŋgile ɗelele ki geeger Kos. Soggo maŋ ay dʼiŋgile ay dʼiiney a geeger Rood, wo tiŋ geŋ ay di ɗiige biza bar ki geeger Patara. ");
INSERT INTO moz_vpl VALUES ("AC21_2","074_21_2","ACT","21","2","2","Aŋgeŋ ay dʼuune tooko ti doolo tʼamɓe ki siiɗo Pinisi, ay di-gili adda tooko gettiyo, ay dʼiŋgile. ");
INSERT INTO moz_vpl VALUES ("AC21_3","074_21_3","ACT","21","3","3","A eŋgilsadey gette, siiɗo ere a diine kʼahu sundutú Siipire gette, ay di wulle ki kese beezey geelo, iŋkino maŋ ay dʼiŋgile ki siiɗo Siiri. Ay iiney a geeger Tir maŋ, ay di ɗiige kono an di-ɗeggite sulɗi suuk ɗoŋ adda tooko aŋgen̰n̰o. ");
INSERT INTO moz_vpl VALUES ("AC21_4","074_21_4","ACT","21","4","4","A ume geŋ ay dʼuune sanalliyagi, ay di likke ti kane onniyo sarat. Unde Kamilen̰ tʼan di gize a munɗa wede i-aaney a Pool a Zeruzalem me, iŋkino maŋ a Pool an i di ruute, anʼde: «Kee kʼette ye ki Zeruzalem me.» ");
INSERT INTO moz_vpl VALUES ("AC21_5","074_21_5","ACT","21","5","5","Aame îide onniyo sarat maŋ ay tʼiiziga, wo zemɓa ti erayzaŋ ti in̰n̰izaŋ pay an ay diʼn igibe bini ay tʼuɗɗe ti geeger. Maŋ ay dʼiiney biza bar, aŋgeŋ ay tʼuttile ay tunde Raa. ");
INSERT INTO moz_vpl VALUES ("AC21_6","074_21_6","ACT","21","6","6","Saŋ ay a-ti ziɗɗe bey ti tuddey, maŋ ay di-gili adda tooko, wo kane an di-gime ki ɓoyɗizaŋ. ");
INSERT INTO moz_vpl VALUES ("AC21_7","074_21_7","ACT","21","7","7","Kaye torguwadey ere adda kʼahu ti Tir ay a-ti ɗiŋge a geeger Petolmayi. Aŋgeŋ zemɓa ay diʼn iisite, wo di kane ay dʼinne onniyo soo. ");
INSERT INTO moz_vpl VALUES ("AC21_8","074_21_8","ACT","21","8","8","Soggo maŋ ay dʼiŋgile, ay dʼiiney a geeger Sezare, aŋgeŋ ay tʼiide a ɓoy ki Pilip wede kazita Rabila Majjaanawa, ay di ɗiige di yode, ay di likke aŋgen̰n̰o. Yode wede ti diine ɗoŋ sarat an biire a Zeruzalem. ");
INSERT INTO moz_vpl VALUES ("AC21_9","074_21_9","ACT","21","9","9","Yo wede geŋ i-dʼede in̰n̰i konazi piɗe, kane geŋ an rootiyto ono ɗoŋ Raa yʼagisa. ");
INSERT INTO moz_vpl VALUES ("AC21_10","074_21_10","ACT","21","10","10","Aŋgeŋ ay likke onniyto ɓaadaŋ, maŋ nebi sundí Agabus yʼa dʼiina ti siiɗo Ziide. ");
INSERT INTO moz_vpl VALUES ("AC21_11","074_21_11","ACT","21","11","11","Yʼiido yʼay diʼn uuna, yʼa tʼumɓe ser wede ki Pool geŋ, yʼa-gitte zoŋ ti bey ki yode batum, wo yʼa ruute, yʼede: «En̰n̰o ono ɗoŋ Unde Kamilen̰ ti rootiyo: Wede ser eŋ, Yawudiyagi an ti yʼ kettey kino a Zeruzalem me, wo an an di yʼ tʼeley a bey ɗoŋ Yawudiyagi ye.» ");
INSERT INTO moz_vpl VALUES ("AC21_12","074_21_12","ACT","21","12","12","Aame kaye ti zemɓa ɗoŋ a Sezare pay ay illiga iŋkino maŋ, ay yi dʼoɓe bey a Pool kono ki Zeruzalem yʼa kʼette ye. ");
INSERT INTO moz_vpl VALUES ("AC21_13","074_21_13","ACT","21","13","13","Iŋkino Pool yʼa ruute, yʼede: «Ki moo me kun môolo me, geŋ kun oo ti ɗekkiyo biza kʼulbó? Nuŋ nʼiyye ki kettisadó ɗaŋŋal ye, wo soŋ nʼiyye nʼa tʼindey a Zeruzalem kono suma Galmeega Isa geŋ me.» ");
INSERT INTO moz_vpl VALUES ("AC21_14","074_21_14","ACT","21","14","14","Kaye onamey yi-tuuge geŋ, iŋkino maŋ ay gi di giɗɗima ye, wo ayʼde: «Galmeega yi tʼiso munɗa wede yi dehu me.» ");
INSERT INTO moz_vpl VALUES ("AC21_15","074_21_15","ACT","21","15","15","Aame ay inne onniyo miibi a Sezare maŋ, ay tʼikkima tuddey, ay tʼiizigo ay di-gili ki Zeruzalem. ");
INSERT INTO moz_vpl VALUES ("AC21_16","074_21_16","ACT","21","16","16","Sanalliyagi miibi ti Sezare an aynʼigibe, an ay diʼn tʼiide di wede sundí Nanson, yoŋ ti siiɗo Siipire, ti diine ɗoŋ ti poone i ziipe addaŋ a Isa too. Geŋ di yode ay di ɗiige, ay dʼinne me. ");
INSERT INTO moz_vpl VALUES ("AC21_17","074_21_17","ACT","21","17","17","Aame ay iiney a Zeruzalem geŋ, zemɓa an ay diʼn ziiɗa tʼulbe uŋse. ");
INSERT INTO moz_vpl VALUES ("AC21_18","074_21_18","ACT","21","18","18","Wo soggo maŋ Pool ti kaye pây ay tʼiide wolliyo Zak a ɓoozí, wo di yode geŋ ay diʼn uune kane pay ɗoŋ dokkiyo ki ɗoŋ ogiyso ti suma kʼIsa an tʼugiye. ");
INSERT INTO moz_vpl VALUES ("AC21_19","074_21_19","ACT","21","19","19","Aame ay tiʼn iisite maŋ, Pool yʼan tʼîide taaya soo soo a sulɗi ɗoŋ pay Raa yʼize tʼurzi naabo yode a diine ɗoŋ Yawudiyagi ye. ");
INSERT INTO moz_vpl VALUES ("AC21_20","074_21_20","ACT","21","20","20","Aame an tʼilliga onamí maŋ, kane pay an dʼimme Raa. Saŋ an i di ruute a Pool, anʼde: «Leemadey, kee ki wollo ɗo, Yawudiyagi dupiyagi miibi ɗoŋ i ziipe addaŋ a Isa wo i seeɗu zakiɗi a urzi kʼoogoro Muusa me. ");
INSERT INTO moz_vpl VALUES ("AC21_21","074_21_21","ACT","21","21","21","Kaciŋ kane an illiga oniyapi a tukki kee me, anʼde kee ki kazita a Yawudiyagi pay ɗoŋ i lekkiyo a diine ɗoŋ Yawudiyagi ye, an dʼooli urzi kʼoogoro Muusa me. Kee kʼede ponde a in̰n̰izaŋ an ki walɗa ye, wo urzi kʼoogoro Yawudiyagi an ki daane ye. ");
INSERT INTO moz_vpl VALUES ("AC21_22","074_21_22","ACT","21","22","22","Aŋkeŋ in dʼise mummino? Ɗerec, daa niiku kane an dʼolliga kee a en̰n̰o me. ");
INSERT INTO moz_vpl VALUES ("AC21_23","074_21_23","ACT","21","23","23","Iŋkino maŋ munɗa wede ay a roota geŋ, kʼa tʼiso. I dʼede a eŋ kuuli kane piɗe an ruute an i-dʼisa munɗa a Raa. ");
INSERT INTO moz_vpl VALUES ("AC21_24","074_21_24","ACT","21","24","24","Kʼa tʼodo kʼume kʼaade ti kane, tudduguŋ kun ti tʼisoy kamilen̰ a ɗaana Raa, wo kʼan dʼeloy soŋkadaŋ ere ki seɗeke te, kono an di kôokey eedaŋ. Iŋkino maŋ ɗuwo pay an suuna ono ɗoŋ pay an rootiyo a tukki kee geŋ ɗerec ye, wo kee toŋ lekkiyadá a-tʼette a urzi kʼoogoro Muusa kay. ");
INSERT INTO moz_vpl VALUES ("AC21_25","074_21_25","ACT","21","25","25","Wo kane Yawudiyagi ye ɗoŋ an ziipe addaŋ a Isa geŋ, ay an riiŋe mattup a munɗa wede ay dehu me: an ki dʼaaɗi ye sey wede an eliyo seɗeke a loŋgayi me, puuzo toŋ ulu an kʼoomi ye, sey wede ki seysu inda puuzadí ti kʼuɗɗe ye an kʼaaɗi ye, ise boliyo toŋ ulu an dʼooli.» ");
INSERT INTO moz_vpl VALUES ("AC21_26","074_21_26","ACT","21","26","26","Iŋkino Pool yʼa iyye a onamaŋ, soggo maŋ kane kuuli piɗe geŋ yʼa tiʼn wiike, an tʼiide kʼume kʼaade kono an ti tʼiso tuddaŋ kamilen̰ a ɗaana Raa. Maŋ yi-tʼiide booro Ɓoy Raa, yʼan di rooto ɗoŋ seɗeke onniyo ere tuddaŋ tʼa tʼisa kamilen̰ a ɗaana Raa tʼa ɗaŋga, wo wede tuuku toŋ yʼa tʼela seɗikadí seɗikadí me. ");
INSERT INTO moz_vpl VALUES ("AC21_27","074_21_27","ACT","21","27","27","A ɗaŋgu kʼonniyo sarat geŋ Pool yo a booro Ɓoy Raa, wo kane Yawudiyagi ɗoŋ iido ti siiɗo kʼAazi an di yʼ wulle, maŋ an an tʼelite ono a ɗoŋ duuru pay, wo Pool an di yʼ ziiɗa. ");
INSERT INTO moz_vpl VALUES ("AC21_28","074_21_28","ACT","21","28","28","An dʼiise ɗollite, anʼde: «Kun okki kune ɗoŋ kʼIzirayel geŋ me! En̰n̰o wedusu wede i kazita munɗa wede ulsu me, a ume tuuku wo a wede tuuku toŋ maŋ, a tukki kine Yawudiyagi, a tukkʼoogoro Muusa wo a tukki ɓoy en̰n̰o. Wo aŋkeŋ ɗoŋ Yawudiyagi ye toŋ yʼan dʼan tʼiido ki Ɓoy Raa en̰n̰o, iŋkino ume kamilen̰ eŋ an ti yʼize ganigi a ɗaana Raa me.» ");
INSERT INTO moz_vpl VALUES ("AC21_29","074_21_29","ACT","21","29","29","Kane an rootiyo iŋkino kono an wullo Tiropim kʼEpez ti Pool adda geeger gettiyo, an elkiyo Pool yi ti yʼele adda booro Ɓoy Raa. ");
INSERT INTO moz_vpl VALUES ("AC21_30","074_21_30","ACT","21","30","30","Adda geeger pay gette ɗoŋ an dʼiise tarkuuse gorɗoŋ, ɗoŋ tʼume tuuku toŋ an dʼokko kʼadda, Pool ɗuwo an di yʼ ziiɗa an di yʼuɗɗe tʼadda booro Ɓoy Raa me, wo kesiko boha an a-tʼippite. ");
INSERT INTO moz_vpl VALUES ("AC21_31","074_21_31","ACT","21","31","31","An dehu an di yʼ tʼîde, maŋ ɗoŋ soŋ an dʼukke an i-di gizo a goole kʼasigiryagi meeda zoot ki Romeŋ, anʼde: «Ɗoŋ pay ki Zeruzalem an isiyo tarkuuse.» ");
INSERT INTO moz_vpl VALUES ("AC21_32","074_21_32","ACT","21","32","32","Kesiko yo goole geŋ yi wiiko deero kʼasigiryagi ti doolo, ti asigiryagi a itadaŋ an dʼukko kʼume ɗoŋ duuru. Aame an wulle goole kʼasigiryagi pay wo ti asigiryagi a itadí maŋ, Pool an di yʼiili ti kossiyadí me. ");
INSERT INTO moz_vpl VALUES ("AC21_33","074_21_33","ACT","21","33","33","Iŋkino maŋ goole kʼasigiryagi pay yʼaa dʼiide sirpa Pool, yʼa yi ziiɗa wo yʼan di ruute a asigiryagi an ti yʼ kettito ti ziŋziri sire, wo yʼa tunde, yʼede: «Wede eŋ yoŋ wee wee, wo yʼize moo me?» ");
INSERT INTO moz_vpl VALUES ("AC21_34","074_21_34","ACT","21","34","34","Wo ɗe adda diine ɗoŋ duuru geŋ wede tuuku toŋ yi ɗollite kʼeedí, kʼeedí. Wo goole kʼasigiryagi pay geŋ yi-ki tʼollige ye munɗa an rootiyo me, kono tarkuuse ɓaadaŋ. Iŋkino yʼan di ruute a asigiryagi, Pool an di-tʼodo kʼadda ɓoy wede zakiɗi. ");
INSERT INTO moz_vpl VALUES ("AC21_35","074_21_35","ACT","21","35","35","Aame Pool yʼiiney a biza ɓoy aame koliyto maŋ, kane asigiryagi an a-ti yʼumɓe kono ɗoŋ duuru an dehu an i-dʼise ulsu. ");
INSERT INTO moz_vpl VALUES ("AC21_36","074_21_36","ACT","21","36","36","Wo kane ɗoŋ duuru pay geŋ an yi daaniya ti ɗollite, anʼde: «Ki yʼôodo! Ki yʼôodo!» ");
INSERT INTO moz_vpl VALUES ("AC21_37","074_21_37","ACT","21","37","37","Aame Pool an dehu an ti yʼ tʼele adda ɓoy wede zakiɗi geŋ, yi di ruute a goole kʼasigiryagi pay, yʼede: «Tambobino ɗoo, nʼa-ɗeege bizó kay ko?» Maŋ yo goole geŋ yʼa yi tunde, yʼede: «Ono Girek ki suune ko? ");
INSERT INTO moz_vpl VALUES ("AC21_38","074_21_38","ACT","21","38","38","Kee ti siiɗo Misir ye ko? Kee wede goppo goppoŋ eŋ ki tʼuɗɗe balɗa ti ɗoŋ dupu piɗe a itadá, kee ye ko?» ");
INSERT INTO moz_vpl VALUES ("AC21_39","074_21_39","ACT","21","39","39","Pool yi di ruute, yʼede: «Nuŋ Yawudusu an ehe a Tarsi siiɗo Silisi, nuŋ wede ti siiɗo ki geeger ere i-dʼede suma. Kʼo tʼele urzi maŋ, nʼan di roote a ɗoŋ duuru.» ");
INSERT INTO moz_vpl VALUES ("AC21_40","074_21_40","ACT","21","40","40","Iŋkino maŋ goole kʼasigiryagi pay yi-dʼele urzi. Pool yʼa tʼîhira a ume koliyto, yʼan dʼize likuw ti beezí kono ɗuwo an dʼanniga. Ɗoŋ pay an dʼinniga, maŋ Pool yʼan dʼiise rootiyo tʼono ɗoŋ kʼEber, yʼede: ");
INSERT INTO moz_vpl VALUES ("AC22_1","074_22_1","ACT","22","1","1","«Maawi ki nuŋ, zemɓa ki nuŋ, aŋkeŋ kun ollo munɗa wede nʼa roote me, kono tuddó geŋ bizó nʼa ti yʼ ɗeege kay.» ");
INSERT INTO moz_vpl VALUES ("AC22_2","074_22_2","ACT","22","2","2","Aame an illiga Pool yʼan rootiyo tʼono ɗoŋ kʼEber maŋ, an dʼinda kuy. Iŋkino maŋ yo Pool yʼa ruute, yʼede: ");
INSERT 