﻿USE sofia;
DROP TABLE IF EXISTS sofia.mopNT_vpl;
CREATE TABLE mopNT_vpl (
  verseID VARCHAR(16) NOT NULL PRIMARY KEY,
  canon_order VARCHAR(12) NOT NULL,
  book VARCHAR(3) NOT NULL,
  chapter VARCHAR(3) NOT NULL,
  startVerse VARCHAR(3) NOT NULL,
  endVerse VARCHAR(3) NOT NULL,
  verseText TEXT CHARACTER SET UTF8 NOT NULL) ENGINE=MyISAM;
LOCK TABLES mopNT_vpl WRITE;
INSERT INTO mopNT_vpl VALUES ("MT1_1","070_1_1","MAT","1","1","1","Le'ec ada' u c'aba'oo' a jujun tuul u uchben mamaa' a Jesucristojo. Le'ec u uchben mamaa' ala'aji, aj rey David y aj Abraham. ");
INSERT INTO mopNT_vpl VALUES ("MT1_2","070_1_2","MAT","1","2","2","U mejen aj Abrahama, aj Isaac u c'aba'. U mejen aj Isaaca, aj Jacob u c'aba'. U mejen aj Jacobo, aj Juda u c'aba'. Yanoo' u sucu'un u yitz'in aj Juda. ");
INSERT INTO mopNT_vpl VALUES ("MT1_3","070_1_3","MAT","1","3","3","U mejen aj Judaja, aj Fares y aj Zara u c'aba'oo'. Ixna' Tamar u c'aba'oo' u na'. U mejen aj Farese, aj Esrom u c'aba'. U mejen aj Esromo, aj Aram u c'aba'. ");
INSERT INTO mopNT_vpl VALUES ("MT1_4","070_1_4","MAT","1","4","4","U mejen aj Arama, aj Aminadab u c'aba'. U mejen aj Aminadaba, aj Naason u c'aba'. U mejen aj Naasono, aj Salmon u c'aba'. ");
INSERT INTO mopNT_vpl VALUES ("MT1_5","070_1_5","MAT","1","5","5","U mejen aj Salmono, aj Booz u c'aba'. Le'ec u na' aj Boozo, ixna' Rahab u c'aba'. U mejen aj Boozo, aj Obed u c'aba'. Le'ec u na' aj Obede, ixna' Rut u c'aba'. U mejen aj Obede, aj Isai u c'aba'. ");
INSERT INTO mopNT_vpl VALUES ("MT1_6","070_1_6","MAT","1","6","6","U mejen aj Isaiji, le'ec aj rey Davidi. U mejen aj rey Davidi, aj Salomon u c'aba'. Le'ec u na' aj Salomono, le'ec u yütan aj quimen Urias. ");
INSERT INTO mopNT_vpl VALUES ("MT1_7","070_1_7","MAT","1","7","7","U mejen aj Salomono, aj Roboam u c'aba'. U mejen aj Roboama, aj Abias u c'aba'. U mejen aj Abiasa, aj Asa u c'aba'. ");
INSERT INTO mopNT_vpl VALUES ("MT1_8","070_1_8","MAT","1","8","8","U mejen aj Asaja, aj Josafat u c'aba'. U mejen aj Josafata, aj Joram u c'aba'. U mejen aj Jorama, aj Uzias u c'aba'. ");
INSERT INTO mopNT_vpl VALUES ("MT1_9","070_1_9","MAT","1","9","9","U mejen aj Uziasa, aj Jotam u c'aba'. U mejen aj Jotama, aj Acaz u c'aba'. U mejen aj Acaza, aj Ezequias u c'aba'. ");
INSERT INTO mopNT_vpl VALUES ("MT1_10","070_1_10","MAT","1","10","10","U mejen aj Ezequiasa, aj Manases u c'aba'. U mejen aj Manasese, aj Amon u c'aba'. U mejen aj Amono, aj Josias u c'aba'. ");
INSERT INTO mopNT_vpl VALUES ("MT1_11","070_1_11","MAT","1","11","11","U mejen aj Josiasa, aj Jeconias u c'aba'. Yanoo' u sucu'un u yitz'in aj Jeconiasa. Tu q'uinil ti cuxa'anoo' ala'oo'o, müchboo' aj Israel u menoo' aj Babiloniajili. Bensaboo' tu c'asil aj Israel ich cuenta Babilonia. ");
INSERT INTO mopNT_vpl VALUES ("MT1_12","070_1_12","MAT","1","12","12","Le'ec ti bensaboo' aj Israel ich cuenta Babiloniaja, baala'oo' u c'aba' a jujun tuul u uchben mamaa' a Jesusu. U mejen aj Jeconiasa, aj Salatiel u c'aba'. U mejen aj Salatiele, aj Zorobabel u c'aba'. ");
INSERT INTO mopNT_vpl VALUES ("MT1_13","070_1_13","MAT","1","13","13","U mejen aj Zorobabele, aj Abiud u c'aba'. U mejen aj Abiudu, aj Eliaquim u c'aba'. U mejen aj Eliaquimi, aj Azor u c'aba'. ");
INSERT INTO mopNT_vpl VALUES ("MT1_14","070_1_14","MAT","1","14","14","U mejen aj Azoro, aj Sadoc u c'aba'. U mejen aj Sadoco, aj Aquim u c'aba'. U mejen aj Aquimi, aj Eliud u c'aba'. ");
INSERT INTO mopNT_vpl VALUES ("MT1_15","070_1_15","MAT","1","15","15","U mejen aj Eliudu, aj Eleazar u c'aba'. U mejen aj Eleazara, aj Matan u c'aba'. U mejen aj Matana, aj Jacob u c'aba'. ");
INSERT INTO mopNT_vpl VALUES ("MT1_16","070_1_16","MAT","1","16","16","U mejen aj Jacobo, aj Jose u c'aba'. Le'ec aj Jose abe'e, le'ec u yicham ixna' Mariaja. Le'ec ixna' Mariaja, u na' a Jesusu. —Cristo,— cu t'anoo' ti'i. ");
INSERT INTO mopNT_vpl VALUES ("MT1_17","070_1_17","MAT","1","17","17","Ti baalo'o, yan catorce tuuloo' u uchben mamaa' a Jesus a caji etel aj Abraham y jobi etel aj Davidi. Yan ilic catorce tuuloo' u uchben mamaa' a Jesus a caji etel aj Davidi, y jobi etel a bensaboo' aj Israel ich cuenta Babilonia. Yan ilic catorce tuuloo' u uchben mamaa' a Jesus a caji etel ti bensaboo' aj Israel ich cuenta Babilonia, y jobi etel ti yanaji a Jesusu. ");
INSERT INTO mopNT_vpl VALUES ("MT1_18","070_1_18","MAT","1","18","18","Pues te'i. Wa'ye' u yaalbül c'u' a mani ti yanaji a Jesucristojo. Ix Maria u c'aba' u na' a Jesusu. Ix Mariaja, ac c'aata'an u men aj Joseje. Le'ec ti ix chu' to ix Mariaja, ti ma'ax to ch'a'büc u men aj Joseje, eeltabi ti ba'la'an. Abe'e, ti'i u Püsüc'al a Dioso. ");
INSERT INTO mopNT_vpl VALUES ("MT1_19","070_1_19","MAT","1","19","19","C'aata'an ix Maria u men aj Joseje. Toj u na'at aj Joseje. Ma' u c'ati ca' na'tabüc c'u' ca'a tan u p'ütic ix Mariaja. Suductzil ti'i ix Maria, mentücü, u c'atiintaj cuchi u p'ütü' tu qui'il ich mucul. ");
INSERT INTO mopNT_vpl VALUES ("MT1_20","070_1_20","MAT","1","20","20","Le'ec ti tan to u tuclic c'u' a ca' u bete'e, chiclaji ti'i ichil u nümül jun tuul u yaj xa'num a Dios ti ca'ana. —Jose, inchech u mam aj quimen rey Davidi. Ma' a saactic a ch'aa' ix Maria ti'i a wütan. Le'ec u yal a bel u ca'a ti yantal ti'iji, yancunbi ti'i u men u Püsüc'al a Dioso,— cu t'an u yaj xa'num a Dios ti ca'an ti'iji. ");
INSERT INTO mopNT_vpl VALUES ("MT1_21","070_1_21","MAT","1","21","21","—Yantal u ca'a u yal xidal. Jesus u c'aba' ca' a tz'aa' u men bel u cu sa'altoo' ca' joc'ocoo' ichil u sip'il boon a cristiano a ti'iji. U nu'cul a t'an Jesusu, sa'alil,— cu t'an u yaj xa'num a Dios ti ca'an ti'iji. ");
INSERT INTO mopNT_vpl VALUES ("MT1_22","070_1_22","MAT","1","22","22","Uchi tulacal abe'e, ti'i ca' jajac u t'an a Noochtzil a aalbi u men jun tuul u yadaj u t'an a Dios uchi yoc'ol a Cristojo. ");
INSERT INTO mopNT_vpl VALUES ("MT1_23","070_1_23","MAT","1","23","23","—U'yeene'ex, jun tuul ix chu'u, bel u ca'a ti yantal u yal xidal. Le'ec ti yanaca, bel u ca'a chiitbil ti Emanuel. “Dios que'en tiqui wetel,” cu t'an a t'an abe'e.— Baalo' ti tz'iiba'an uchi yoc'ol a Cristojo. ");
INSERT INTO mopNT_vpl VALUES ("MT1_24","070_1_24","MAT","1","24","24","Le'ec ti aji aj Jose ti wüyülü, u tz'ocsaj c'u' a aalbi ti'i u men u yaj xa'num a Dios ti ca'ana. U ch'a'aj u yütan. ");
INSERT INTO mopNT_vpl VALUES ("MT1_25","070_1_25","MAT","1","25","25","C'u' betiqui, ma' cüjlaji etel ix Maria asto ti yanaji u yal xidal. U tz'aj u c'aba' a tz'ub ti Jesus. ");
INSERT INTO mopNT_vpl VALUES ("MT2_1","070_2_1","MAT","2","1","1","Pues te'i. Le'ec ti yanaji a Jesus ich caj Belen cuenta Judeaja, que'en aj Herodes ti reyil te'i. Taloo' joq'ueeb q'uin a winic a walacoo' u cambal yoc'ol u cuentajil a xülaba. C'ochoo' ich caj Jerusalen u cüxtoo' a Jesusu. ");
INSERT INTO mopNT_vpl VALUES ("MT2_2","070_2_2","MAT","2","2","2","—¿Tuba que'en u reyoo' aj Israel a yanaji tunu? Ti wilaj u xülabil ti que'eno'on joq'ueeb q'uin. Talo'on ti xontal tu taan ti tz'oques u yanil,— cu t'anoo' a walacoo' u cambal yoc'ol u cuentajil a xülaba. ");
INSERT INTO mopNT_vpl VALUES ("MT2_3","070_2_3","MAT","2","3","3","Le'ec ca' u yubaj abe' aj rey Herodese, jaq'ui u yool. Jac'oo' ilic u yool a caj Jerusalene. ");
INSERT INTO mopNT_vpl VALUES ("MT2_4","070_2_4","MAT","2","4","4","Le'ec a reye, u püyajoo' u noochiloo' u yaj mansaj t'an a cristiano ti'i a Dioso. U püyajoo' ilic u yaj ca'ansajil u ley aj Moisese. U c'aataj ti'ijoo' tuba u yantal a Cristojo. ");
INSERT INTO mopNT_vpl VALUES ("MT2_5","070_2_5","MAT","2","5","5","—Yantal u ca'a ala'i ichil aj tz'i' caj Belen tu cuenta Judea,— cu t'anoo' ti'i. —Baalo' ilic u tz'iibtaj a winic u yadaj u t'an a Dios uchi,— cu t'anoo'. ");
INSERT INTO mopNT_vpl VALUES ("MT2_6","070_2_6","MAT","2","6","6","—Le'ec aj tz'i' caj Belen tu cuenta Judeaja, yan u c'abeetil tu yaamoo' u chucaan a caj cuenta Judeaja. Te'i u yantal a rey a bel u cu tücaa'too' a cristiano a tene, le'ecoo' aj Israele,— cu t'an u t'an a Dios a tz'iiba'ana. ");
INSERT INTO mopNT_vpl VALUES ("MT2_7","070_2_7","MAT","2","7","7","Pues te'i. Püyboo' a winic abe' a walacoo' u cambal yoc'ol u cuentajil a xülaba. Püyboo' ca' talacoo' ich mucul ti sut etel aj Herodese. U c'aataj ti'ijoo' biq'uini ti chiclaji a xülab a tan u ye'ic ti yanaji a Cristojo. U yadajoo' ti'i. ");
INSERT INTO mopNT_vpl VALUES ("MT2_8","070_2_8","MAT","2","8","8","—Ca' xique'ex a qui' cüxte tuba que'en a tz'ubu. Le'ec ca' a cüxte'exe, ca' talaque'ex a tzolo' ten. In c'ati ilic xan in beel ti xontal in tz'oques u yanil ala'aji,— cu t'an aj Herodes ti'ijoo'o. U tücaa'tajoo' ich caj Belen. ");
INSERT INTO mopNT_vpl VALUES ("MT2_9","070_2_9","MAT","2","9","9","Pues te'i. Binoo' jabix u yadaj a reye. Le'ec a xülab u yilajoo' tuba taloo' joq'ueeb q'uini, tan u beel taanil asto ti wa'laji yoc'ol u cuuchil a tz'ubu. ");
INSERT INTO mopNT_vpl VALUES ("MT2_10","070_2_10","MAT","2","10","10","Le'ec ca' u yilajoo' a xülaba, qui'oo' u yool tu jajil. ");
INSERT INTO mopNT_vpl VALUES ("MT2_11","070_2_11","MAT","2","11","11","Le'ec ti ocoo' ich naj, u yilajoo' a tz'ub etel u na', le'ec ix Mariaja. Xonlajoo'. U tz'ocsajoo' u yanil a Jesusu. U jebajoo' u cuch tuba tanoo' u talesic a sij-oolo. U tz'ajoo' a sij-ool ti'iji. U tz'ajoo' a orojo. U tz'ajoo' a jabix pomo. U tz'ajoo' a jabix boc u c'aba' mirraja. ");
INSERT INTO mopNT_vpl VALUES ("MT2_12","070_2_12","MAT","2","12","12","Pues te'i. Le'ec ti tanoo' u wüyül a walacoo' u cambal yoc'ol u cuentajil a xülaba, aalbi ti'ijoo' ich nümül ti ma' u ca' usc'aloo' etel aj rey Herodes. Joc'oo'. Usc'ajoo' ti ulaac' bej tac tu caal. ");
INSERT INTO mopNT_vpl VALUES ("MT2_13","070_2_13","MAT","2","13","13","Le'ec ti binoo'o, chiclaji jun tuul u yaj xa'num a Dios ti ca'an ti'i aj Jose ich nümül. —Liq'uen. Benes a tz'ub u yet'oc u na' tu cuenta Egipto. Te'i a muquique'ex a bajil asto in ca' adic te'ex. Le'ec aj rey Herodese, bel u ca'a u yaalte u cüxte a tz'ub ti'i u quimsical,— cu t'an u yaj xa'num a Dios ti ca'an ti'i aj Joseje. ");
INSERT INTO mopNT_vpl VALUES ("MT2_14","070_2_14","MAT","2","14","14","Ti'i ilic a ac'ü' abe'e, liq'ui aj Joseje. Joq'ui te'i. Caji u benes a tz'ub u yet'oc u na' ich cuenta Egipto. ");
INSERT INTO mopNT_vpl VALUES ("MT2_15","070_2_15","MAT","2","15","15","Culajoo' te'i ich cuenta Egipto asto ti quimi aj rey Herodese. Baalo' ti jajtal u ca'a u t'an a Noochtzil a aalbi u men jun tuul u yadaj u t'an a Dios uchi. —In püyaj in mejen ca' joc'oc cuenta Egipto,— cu t'an a Dios ti tz'iiba'an. ");
INSERT INTO mopNT_vpl VALUES ("MT2_16","070_2_16","MAT","2","16","16","Pues te'i. Le'ec aj Herodese, u yeeltaj ti tusbi u menoo' a walacoo' u cambal yoc'ol u cuentajil a xülaba. Tz'iicaji tu jajil. U tücaa'taj quimsabüloo' tulacal aj meen tz'ub a xidal a que'enoo' ich caj Belen tac etel a nütz'a'anoo' tzeel a caja. Quimsaboo' a tz'ub a ca' p'e jaab yanoo' ti'i wa ma'ax to u müch'ü' a ca' p'e jaab u men u yadajoo' a walacoo' u cambal yoc'ol u cuentajil a xülab ti ca' p'e jaab tun chiclac a xülab abe'e. ");
INSERT INTO mopNT_vpl VALUES ("MT2_17","070_2_17","MAT","2","17","17","Baalo' ti jajaji u t'an a Dios u yadaj aj Jeremias le'ec jun tuul u yadaj u t'an a Dios uchi. ");
INSERT INTO mopNT_vpl VALUES ("MT2_18","070_2_18","MAT","2","18","18","—U'yajbi u choconaquil a cristiano ich caj Rama. Naach u yawatoo' ti tanoo' u yoc'ol. Le'ecoo' ix ch'up aj Israele, tanoo' u yoc'ticoo' u yal. Ma' u c'ati jetz'tal u yool u men quimsaboo' u yal,— cu t'an a t'an u tz'iibtaj aj Jeremiasa. ");
INSERT INTO mopNT_vpl VALUES ("MT2_19","070_2_19","MAT","2","19","19","Pues te'i. Le'ec ti quimi aj rey Herodese, chiclaji jun tuul u yaj xa'num a Dios ti ca'an ti'i aj Jose ichil u nümül. Que'en to aj Jose ich cuenta Egipto. ");
INSERT INTO mopNT_vpl VALUES ("MT2_20","070_2_20","MAT","2","20","20","—Liq'uen. Benes a tz'ub u yet'oc u na' ich cuenta Israel tucaye'. Le'ec a mac u c'atiintaj u quimes a tz'ub biq'uin ado'o, quimi,— cu t'an u yaj xa'num a Dios ti ca'an ti'iji. ");
INSERT INTO mopNT_vpl VALUES ("MT2_21","070_2_21","MAT","2","21","21","Liq'ui aj Joseje. Caji u ca' benes a tz'ub u yet'oc u na' ich cuenta Israel tucaye'il. ");
INSERT INTO mopNT_vpl VALUES ("MT2_22","070_2_22","MAT","2","22","22","C'u' betiqui, u yubaj ti que'en aj Arquelao ti rey cuenta Judea tu jel u tat, le'ec aj quimen Herodese. Saac aj Jose ca' xi'ic te'i. Aalbi ti'i ich nümül ti sabeensil u beel te'i, mentücü, bini ich cuenta Galilea ichil ilic u cuenta Israel. ");
INSERT INTO mopNT_vpl VALUES ("MT2_23","070_2_23","MAT","2","23","23","Bini ti cuntal ichil jun p'eel caj u c'aba' Nazaret. Baalo' ti jajaji u t'an a Dios u tz'iibtaj a winic u yadaj u t'an a Dios uchi. —Aalbül u ca'a ti Nazareno ala'aji,— cu t'an a t'an a tz'iiba'an u men te'i culaji ichil a caj abe'e. ");
INSERT INTO mopNT_vpl VALUES ("MT3_1","070_3_1","MAT","3","1","1","Pues te'i. Le'ec ti que'en to a Jesus ich caj Nazarete, caji aj Juan aj tz'aj ocja' ti t'an ich p'atal lu'um tu cuenta Judea. ");
INSERT INTO mopNT_vpl VALUES ("MT3_2","070_3_2","MAT","3","2","2","—Jele'ex a tucul. Tz'ocse'ex a Dioso. Watac tun u q'uinil u tücaa' a Dioso,— cu t'an aj Juan ti'ijoo' a cristianojo. ");
INSERT INTO mopNT_vpl VALUES ("MT3_3","070_3_3","MAT","3","3","3","Tzicbalbi aj Juan ti baala' u men aj Isaiasa, le'ec jun tuul u yadaj u t'an a Dios uchi: —Le'ec ada' u t'an jun tuul a tan u t'an ichil a p'atal lu'umu. Tojquinte'ex a na'at ca' a c'üme'ex a Noochtzil jabix tane'ex a tojquintic a beje,— cu t'an aj Isaiasa. ");
INSERT INTO mopNT_vpl VALUES ("MT3_4","070_3_4","MAT","3","4","4","Otzil u yilbil u noc' aj Juana. Chen betaja'an etel u tzo'otzel a baalche' u c'aba' camello. Chen u xetel q'uewel u c'ax u nüc'. Le'ec u janala, jabix aj saac' a walac u jantabülü. Walac ilic u jantic u c'a' a cab a walac u cüxtic ich che'. ");
INSERT INTO mopNT_vpl VALUES ("MT3_5","070_3_5","MAT","3","5","5","Binoo' a cristiano etel aj Juana. Yan a taloo' ich caj Jerusalen. Yan a taloo' ca'ax tubajac tu cuenta Judea. Yan a taloo' ca'ax tubajac tu chi' a noja' Jordan. C'ochoo' etel aj Juan. ");
INSERT INTO mopNT_vpl VALUES ("MT3_6","070_3_6","MAT","3","6","6","Le'ec ca' u tzolajoo' u sip'il a jujun tuul tu taan aj Juana, tz'aboo' ti ocja' ich noja' Jordan u men aj Juan. ");
INSERT INTO mopNT_vpl VALUES ("MT3_7","070_3_7","MAT","3","7","7","Aj Juana, u yilaj ti tanoo' u c'ochol u c'ümoo' a ocja' a yaab a fariseo u c'aba'oo' u na'at y a saduceo u c'aba'oo' u na'ata. U tze'ectajoo' ti chich. —Inche'exe, top c'ase'ex jabixe'ex a cana. ¿Mac u yadaj te'ex ti'i ca' talaque'ex yoc'lal ma' a c'ümique'ex u tz'iiquil a Dios a wataca?— cu t'an aj Juan ti'ijoo'o. ");
INSERT INTO mopNT_vpl VALUES ("MT3_8","070_3_8","MAT","3","8","8","—Bete'ex a qui' ti'i ca' chiclac ti jela'ane'ex a tucul. ");
INSERT INTO mopNT_vpl VALUES ("MT3_9","070_3_9","MAT","3","9","9","Ma' a wadique'ex ta bajil ti c'üma'ane'ex chen u men u mame'ex aj quimen Abraham. Tan in wadic te'ex. Le'ec a Dioso, jede'ec u paatal u su'tesic a tunich ada' ca' su'tuc ti'i u mamoo' aj Abraham,— cu t'an ti'ijoo'. ");
INSERT INTO mopNT_vpl VALUES ("MT3_10","070_3_10","MAT","3","10","10","—Inche'exe, jabixe'ex jun teec ti che'e. Paac' u ca'a a baat ti'i u ch'üquical a che'e. Tulacal boon a che' a ma' ta'ach u tz'eec ti quich'pan u wichi, bel u ca'a ch'ücbül. Bel u ca'a pulbul ich c'aac',— cu t'an aj Juan ti'ijoo'o. ");
INSERT INTO mopNT_vpl VALUES ("MT3_11","070_3_11","MAT","3","11","11","Pues te'i. Tan u t'an eteloo' a cristiano aj Juana. —Inene, walac in tz'eeque'ex ti ocja' etel ja' u men a jelaje'ex a tucul a tz'aje'ex a wool a tz'ocse'ex a Dioso. Watac jun tuul a mas nooch u wichil u meyaj tin wich inene. Ma' chucul in yanil ma'ax ti'i in ch'a'ical u cayte. Bel u cu tz'a'e'ex jabix ti ocja' pero chen etel u Püsüc'al a Dioso, y etel jabix c'aac',— cu t'an aj Juana. ");
INSERT INTO mopNT_vpl VALUES ("MT3_12","070_3_12","MAT","3","12","12","—Ala'aji, jabix mac a que'en u lupbeeb tu c'ü' ti'i u pulu' u nec' a püc'aal ti ca'nal. Baalo' ti walac u yuusbul u men a iq'ui, ca' joc'oc u c'asil. Bel u cu taac'te u nec' tu cuuchil, pero le'ec u pacha, bel u ca'a chubul ichil a c'aac' a ma' yan q'uin u tupul,— cu t'an aj Juan ti'ijoo'o. ");
INSERT INTO mopNT_vpl VALUES ("MT3_13","070_3_13","MAT","3","13","13","Pues te'i. Joq'ui a Jesus ich cuenta Galilea. Bini ti a noja' Jordan tuba que'en aj Juana. U c'atiintaj ca' tz'abüc ti ocja' u men aj Juan. ");
INSERT INTO mopNT_vpl VALUES ("MT3_14","070_3_14","MAT","3","14","14","Ma' cuchi u c'ati aj Juan u tz'aa' ti ocja'. —Mas qui' ca' a tz'a'een ti ocja' inene. Ma' cuchi inen ca' in tz'a'eech ti ocja'i,— cu t'an aj Juan ti'iji. ");
INSERT INTO mopNT_vpl VALUES ("MT3_15","070_3_15","MAT","3","15","15","—C'ümü ti baalo' a tz'a'een ti ocja' aleebili. Yan ti betic tulacal a jabix u c'ati a Dioso,— cu t'an a Jesus ti'iji. Aj Juana, u c'ümaj u tz'aa' ti ocja' a Jesusu. ");
INSERT INTO mopNT_vpl VALUES ("MT3_16","070_3_16","MAT","3","16","16","Le'ec ca' u c'ümaj a ocja' a Jesusu, joq'ui ich ja'. Jeebi a ca'ana. Le'ec aj Juana, u yilaj u yemel u Püsüc'al a Dios jabix paloma tac yoc'ol a Jesusu. ");
INSERT INTO mopNT_vpl VALUES ("MT3_17","070_3_17","MAT","3","17","17","U yubaj a t'an a tali ti ca'ana. —Le'ec ada' in Mejen. Yaj in wu'yi. Top qui' in wool etel,— cu t'an a t'an ti ca'ana. ");
INSERT INTO mopNT_vpl VALUES ("MT4_1","070_4_1","MAT","4","1","1","Pues te'i. Bensabi a Jesus u men u Püsüc'al a Dios ichil a p'atal lu'um ti'i ca' yaaltabüc emsabül u yool u men a quisini. ");
INSERT INTO mopNT_vpl VALUES ("MT4_2","070_4_2","MAT","4","2","2","Cuarenta q'uin cuarenta ac'ü' u p'ütaj a janal a Jesusu. Tan u suq'uin. Pachili, wi'ijaji a Jesusu. ");
INSERT INTO mopNT_vpl VALUES ("MT4_3","070_4_3","MAT","4","3","3","C'ochi etel a Jesus aj emsaj-oolo, le'ec a quisini.— Wa jaj ti le'ec inchech u Mejenech a Dioso, su'tes a tunich ada' ti panili,— cu t'an ti'i a Jesusu. ");
INSERT INTO mopNT_vpl VALUES ("MT4_4","070_4_4","MAT","4","4","4","—Baala' ti tz'iiba'an,— cu t'an a Jesus ti'iji. —“Ma' chen etel pan cuxa'an a cristianoji. Yan ilic u tz'ocsic tulacal a t'an a walac u yadic a Dioso,” cu t'an a t'an a tz'iiba'ana,— cu t'an a Jesusu. ");
INSERT INTO mopNT_vpl VALUES ("MT4_5","070_4_5","MAT","4","5","5","Pues te'i. Le'ec a quisini, u bensaj a Jesus ich caj Jerusalen. U tz'aj a Jesus tac pol naj tu yotoch a Dioso. ");
INSERT INTO mopNT_vpl VALUES ("MT4_6","070_4_6","MAT","4","6","6","—Wa jaj ti u Mejenech a Dioso, pulu a bajil tac ti lu'um. Ma' ta yajtal u men baala' ti tz'iiba'an,— cu t'an a quisini. —“Le'ec a Dioso, bel u cu tz'aa' ti'ijoo' u yaj xa'num ti ca'an ca' u cününteechoo'. Bel a ca'a cününbül u menoo' ti'i ma' a t'ochic a woc tuwich tunich,” cu t'an a t'an a tz'iiba'ana,— cu t'an a quisin ti'i a Jesusu. ");
INSERT INTO mopNT_vpl VALUES ("MT4_7","070_4_7","MAT","4","7","7","—Tz'iiba'an ilic ti baala',— cu t'an a Jesusu. —“Ma' qui' a yaaltic a wila' u patalil a Noochtzili, le'ec a Dioso,” cu t'an a t'an a tz'iiba'ana,— cu t'an a Jesusu. ");
INSERT INTO mopNT_vpl VALUES ("MT4_8","070_4_8","MAT","4","8","8","Pues te'i. Le'ec a quisini, u bensaj a Jesus tac tu pol a witz a top ca'nala. U ye'aj ti'i tulacal boon a caj a yan yoc'olcab tac etel u quich'panil. ");
INSERT INTO mopNT_vpl VALUES ("MT4_9","070_4_9","MAT","4","9","9","—Bel in quin laj siji' tech tulacal ada'a, wa cuchi ca' xonlaquech a c'ajseen,— cu t'an a quisin ti'iji. ");
INSERT INTO mopNT_vpl VALUES ("MT4_10","070_4_10","MAT","4","10","10","—Baala' ti tz'iiba'an,— cu t'an a Jesusu. —“C'ajes a Noochtzili, le'ec a Diosil. Jadi' ala'i ca' a c'ajese,” cu t'an a t'an a tz'iiba'ana, mentücü, joq'uen wa'ye' quisin,— cu t'an a Jesus ti'iji. ");
INSERT INTO mopNT_vpl VALUES ("MT4_11","070_4_11","MAT","4","11","11","Pues te'i. Joq'ui a quisini. C'ochoo' u yaj xa'num a Dios ti ca'ana, U yaantajoo' a Jesusu. ");
INSERT INTO mopNT_vpl VALUES ("MT4_12","070_4_12","MAT","4","12","12","Pues te'i. Le'ec ca' u yubaj ti müchbi aj Juana, joq'ui a Jesus ich cuenta Judea. Ca' bini ich cuenta Galilea. ");
INSERT INTO mopNT_vpl VALUES ("MT4_13","070_4_13","MAT","4","13","13","Le'ec ti c'ochi te'i, ca' joq'ui ich caj Nazaret. Bini ti cuntal ich caj Capernaum. Chi' laguna que'en a caj abe'e. Te'i walac u c'ümic u bajil u cuentajil u lu'um u mamoo' aj quimen Zabulon etel u cuentajil u lu'um u mamoo' aj quimen Neftaliji. ");
INSERT INTO mopNT_vpl VALUES ("MT4_14","070_4_14","MAT","4","14","14","Baalo' ti jajaji u t'an Dios u yadaj aj Isaiasa, le'ec jun tuul u yadaj u t'an a Dios uchi. ");
INSERT INTO mopNT_vpl VALUES ("MT4_15","070_4_15","MAT","4","15","15","—Yanoo' a cristiano ichil u lu'um u mamoo' aj quimen Zabulon. Yanoo' a cristiano ichil u lu'um u mamoo' aj quimen Neftali. Yanoo' a nütz'a'an chi' ja'. Yanoo' a que'en junxeel a noja' Jordan. Yanoo' tu cuenta Galilea a ti'ijoo' a ma' Israele. ");
INSERT INTO mopNT_vpl VALUES ("MT4_16","070_4_16","MAT","4","16","16","Le'ecoo' a cristiano abe'e, que'enoo' ich jabix ac'ü'ü. U yilajoo' a jabix a top sasili. Le'ec a pula'anoo'o, que'enoo' tu benil a c'asili, bete cuenta tincaaloo' u paac'too' u quimil y u beeloo' ich c'asil. Yanaji jabix a sasil ti'ijoo',— cu t'an a t'an a tz'iiba'ana. ");
INSERT INTO mopNT_vpl VALUES ("MT4_17","070_4_17","MAT","4","17","17","Le'ec ti c'ochi a Jesus ich caj Capernaumu, caji u yadü' u pectzil. —Jele'ex a tucul. Tz'ocse'ex a Dioso. Watac tun u q'uinil u tücaa' a Dioso,— cu t'an a Jesus ti'ijoo' a cristianojo. ");
INSERT INTO mopNT_vpl VALUES ("MT4_18","070_4_18","MAT","4","18","18","Pues te'i. Le'ec ti tan u manül a Jesus tu chi' a laguna u c'aba' Galileaja, u yilaj ca' tuul a winiqui, u yitz'in u sucu'unoo' u bajil. Le'ec aj Simono, —aj Pedro,— cu t'anoo' ti'i. Le'ec u yitz'ini, aj Andres u c'aba'. Tanoo' u pulic ich ja' u chinchor ti'al u müchicaloo' a cüyü. Aj jooc'oo' a ca' tuulu. ");
INSERT INTO mopNT_vpl VALUES ("MT4_19","070_4_19","MAT","4","19","19","—Co'ne'ex tin pach. Bel in quin yee' te'ex biqui ca' a müche'ex a cristiano jabix ilic ti walaque'ex a müchic a cüyü,— cu t'an a Jesusu. ");
INSERT INTO mopNT_vpl VALUES ("MT4_20","070_4_20","MAT","4","20","20","Tu seebal u p'ütajoo' u chinchor. Binoo' tu pach a Jesusu. ");
INSERT INTO mopNT_vpl VALUES ("MT4_21","070_4_21","MAT","4","21","21","Caji ti ca' manül a Jesus tu chi' a lagunaja. U ca' ilajoo' ulaac' ca' tuul a winiqui. U yitz'in u sucu'unoo' ilic u bajil. Le'ec a ca' tuulu, u mejenoo' aj Zebedeo, le'ec aj Jacobo, u yet'oc u yitz'in le'ec aj Juana. Ichil u barco u tat que'enoo'. Tanoo' u yutzquintic u chinchor u yet'oc u tat. Pues te'i. A Jesusu, u püyajoo' a ca' tuulu. ");
INSERT INTO mopNT_vpl VALUES ("MT4_22","070_4_22","MAT","4","22","22","Tu seebal joc'oo' ichil a barco tuba que'en u tat. Binoo' tu pach a Jesusu. ");
INSERT INTO mopNT_vpl VALUES ("MT4_23","070_4_23","MAT","4","23","23","Pues te'i. Mani a Jesus tulacal tubajac cuenta Galilea. U ca'ansajoo' a cristiano ichil boon a naj tuba walacoo' u much'tal u c'ajesoo' a Dioso. U yadaj ti'ijoo' u pectzil yoc'ol biqui ca' uchuc u tücaa' a Dioso. U ch'anesajoo' ilic tulacal a boon p'eel u wich a c'oja'anil a yan ti'i a cristianojo. ");
INSERT INTO mopNT_vpl VALUES ("MT4_24","070_4_24","MAT","4","24","24","Eeltabi u patalil a Jesus tulacal tubajac cuenta Siria. U talesajoo' tulacal a c'oja'an etel a Jesusu. Yaaboo' u wich u c'oja'anil u c'uxuquil. Yan a que'en a c'ac'asba'al tu yoolo. Yan a walac u yoom u chi' u men c'ac'as c'oja'anil. Yan a sotmen u büq'uele. U ch'anesajoo'. ");
INSERT INTO mopNT_vpl VALUES ("MT4_25","070_4_25","MAT","4","25","25","Mil u yaabil a cristiano a tücünacoo' tu pach a Jesusu. Yan a taloo' cuenta Galilea. Yan a taloo' cuenta Decapolis. Yan a taloo' caj Jerusalen. Yan a taloo' cuenta Judea. Yan a taloo' junxeel a noja' Jordan. ");
INSERT INTO mopNT_vpl VALUES ("MT5_1","070_5_1","MAT","5","1","1","Pues te'i. Le'ec a Jesusu, u yilajoo' boon u yaabil a cristianojo, mentücü, naq'ui tuwich witz. Tinlaji te'i. Le'ecoo' boon u yaj tz'ocsaj t'ana, naatz'oo' tu tzeel. ");
INSERT INTO mopNT_vpl VALUES ("MT5_2","070_5_2","MAT","5","2","2","Caji u ca'ansoo' u yaj tz'ocsaj t'an. ");
INSERT INTO mopNT_vpl VALUES ("MT5_3","070_5_3","MAT","5","3","3","—Boon tuule'ex a ac a weele'ex ti ma'ax to jumbelaque'ex a na'at etel a Dioso, qui'e'ex cuchi a wool, u men ti'i a jabixe'exe, yane'ex a cuuchil ti ca'an,— cu t'an a Jesus ti'ijoo' u yaj tz'ocsaj t'an. ");
INSERT INTO mopNT_vpl VALUES ("MT5_4","070_5_4","MAT","5","4","4","—Boon tuule'ex a yaje'ex a wool u men a sip'il a yan yoc'olcaba, qui'e'ex cuchi a wool, u men ti'i a jabixe'exe, bel u ca'a tz'abül te'ex a jetz'a'an-oolili,— cu t'an a Jesusu. ");
INSERT INTO mopNT_vpl VALUES ("MT5_5","070_5_5","MAT","5","5","5","—Boon tuule'ex a ma' ta'ache'ex a choq'uic a bajile'ex ca' yanac jadi' jabix a c'ate'exe, qui'e'ex cuchi a wool, u men ti'i a jabixe'exe, p'aatül u ca'a te'ex a yoc'olcaba,— cu t'an a Jesusu. ");
INSERT INTO mopNT_vpl VALUES ("MT5_6","070_5_6","MAT","5","6","6","—Boon tuule'ex a c'ate'ex a toj na'at jabix cuchi wi'ije'ex wa uc'aje'ex ti'iji, qui'e'ex cuchi a wool, u men ti'i a jabixe'exe, bel u ca'a tz'abül a toj na'at te'exe,— cu t'an a Jesusu. ");
INSERT INTO mopNT_vpl VALUES ("MT5_7","070_5_7","MAT","5","7","7","—Boon tuule'ex a walaque'ex a ch'a'ic u yotzilil a maca, qui'e'ex cuchi a wool, u men le'ec a walac u ch'a'ic u yotzilil a maca, bel ilic u ca'a ch'a'bül u yotzilil,— cu t'an a Jesus ti'ijoo' u yaj tz'ocsaj t'an. ");
INSERT INTO mopNT_vpl VALUES ("MT5_8","070_5_8","MAT","5","8","8","—Boon tuule'ex a tane'ex a tz'ocsic Dios tulacale'ex a woolo, qui'e'ex cuchi a wool, u men le'ec a jabixe'exe, bele'ex a ca'a a wila' a Dioso,— cu t'an a Jesusu. ");
INSERT INTO mopNT_vpl VALUES ("MT5_9","070_5_9","MAT","5","9","9","—Boon tuule'ex a walaque'ex a jetz'cunaj-oolo, qui'e'ex cuchi a wool, u men le'ec a jabixe'exe, bele'ex a ca'a aalbül ti u mejene'ex a Dioso,— cu t'an a Jesusu. ");
INSERT INTO mopNT_vpl VALUES ("MT5_10","070_5_10","MAT","5","10","10","—Boon tuule'ex a tane'ex a c'ümic a yaj yoc'lal a toj na'ata, qui'e'ex cuchi a wool, u men ti'i a jabixe'exe, yane'ex a cuuchil ti ca'an,— cu t'an a Jesusu. ");
INSERT INTO mopNT_vpl VALUES ("MT5_11","070_5_11","MAT","5","11","11","—Boon tuule'ex a tane'ex a p'a'asbül wa yajcunbul, wa tan u yaalbül a c'as ta woc'ole'ex ti ma' yan u jajili, pero chen u men tene'exe, qui'e'ex cuchi a wool,— cu t'an a Jesusu. ");
INSERT INTO mopNT_vpl VALUES ("MT5_12","070_5_12","MAT","5","12","12","—Qui'aque'ex a wool tu jajil u men yan ti yaab a qui' te'ex a taac'a'an ich ca'an. Jabix ilic ti tan u betabül a yaj te'exe, baalo' ilic a betabi ti'ijoo' boon tuul u yadajoo' u t'an a Dios uchiji,— cu t'an a Jesus ti'ijoo' u yaj tz'ocsaj t'an. ");
INSERT INTO mopNT_vpl VALUES ("MT5_13","070_5_13","MAT","5","13","13","—Pues te'i. Jabix ilic a taab a walac u ch'ooch'quintic a janal ti'i ma' u jomol c'astala, baalo' ilic inche'exe. Tane'ex a c'ütic u wich a c'as yoc'olcaba. C'u' betiqui, ca' joboc u ch'ooch'il a taaba, ¿biqui ca' yanac u ch'ooch'il tucaye'? Ma' ca' yan u c'abeetil. Jadi' walac u pulbul y u wa'wa'che'bel,— cu t'an a Jesusu. ");
INSERT INTO mopNT_vpl VALUES ("MT5_14","070_5_14","MAT","5","14","14","—Inche'exe, jabixe'ex jun p'eel sasil ti'ijoo' a cristiano yoc'olcab. Le'ec a caj a que'en pol witzi, ma' muctzil ta wichi,— cu t'an a Jesus ti'ijoo' u yaj tz'ocsaj t'an. ");
INSERT INTO mopNT_vpl VALUES ("MT5_15","070_5_15","MAT","5","15","15","—Ma' ta'achoo' u t'übic a c'aac' ti'i ca' u tz'aa'oo' yalam cajon. Walacoo' u tz'eec tu cuuchil ti'i ca' u sasilcunte boon a yan ich naj. Baalo' ilic cuchi inche'exe, jabixe'ex a c'aac' abe'e,— cu t'an a Jesusu. ");
INSERT INTO mopNT_vpl VALUES ("MT5_16","070_5_16","MAT","5","16","16","—Yane'ex a sasilcuntic u wich a cristiano yoc'olcab ti'i ca' u yiloo' a quich'pan meyaj a tane'ex a betiqui. Ti baalo'o, a cristianojoo' abe'e, beloo' u cu yadü' u qui'il ti Tate'ex a que'en ti ca'ana,— cu t'an a Jesusu. ");
INSERT INTO mopNT_vpl VALUES ("MT5_17","070_5_17","MAT","5","17","17","—Pues te'i. Ma' a tuclique'ex wa udeen in jobes a ley u tz'iibtaj aj Moisesi. Ma'ax a tuclique'ex wa udeen in tupu' u t'an boon tuul u yadajoo' u t'an a Dios uchi. Ma' udeen ti'i ca' in tupu'i. Udeen ti'i ca' in jajcunte wa ti'i ca' in chicbes u jajil,— cu t'an a Jesusu. ");
INSERT INTO mopNT_vpl VALUES ("MT5_18","070_5_18","MAT","5","18","18","—Tan in wadic te'ex u jajil. Ma' tu tupbul ma'ax jun cuul a t'an ichil a ley abe'e, asto ti u jobeeb a yoc'olcab etel a ca'ana,— cu t'an a Jesusu. ");
INSERT INTO mopNT_vpl VALUES ("MT5_19","070_5_19","MAT","5","19","19","—Le'ec mac ca' u ca'balcunte u muc' a leye, ca'ax ma' top yaab u muc' a ley abe'e, y ca' u ca'ansoo' a cristiano ti baalo'o, le'ec mac a tan u betic abe'e, bel u ca'a aalbül ti ma'ax c'u' aj beel ala'i tu cuenta a Dioso. C'u' betiqui, mac ca' u tz'oques a ley y ca' u ca'ansoo' a cristiano ti baalo'o, ala'aji, bel u ca'a aalbül ti top c'abeet tu cuenta a Dioso,— cu t'an a Jesusu. ");
INSERT INTO mopNT_vpl VALUES ("MT5_20","070_5_20","MAT","5","20","20","—Le'ecoo' u yaj ca'ansajil u ley aj Moises u yet'ocoo' a fariseo u c'aba'oo' u na'ata, top que'enoo' u yool u tz'oques u t'an a Dioso. C'u' betiqui, wa ma' mas toje'ex a na'at tuwichoo' u na'at u yaj ca'ansajil u ley aj Moisese, u yet'ocoo' a fariseojo, ma' yan q'uin a woc'ole'ex tu cuenta a Dioso,— cu t'an a Jesusu. ");
INSERT INTO mopNT_vpl VALUES ("MT5_21","070_5_21","MAT","5","21","21","—Pues te'i. A wu'yaje'ex ti aalbi ti'ijoo' ti uchben mamaa' ti ma' u quimsicoo' u yetcristianojil. Le'ec mac a ca' uchuc u quimsaja, tz'abül u ca'a ichil u sip'il,— cu t'an a Jesusu. ");
INSERT INTO mopNT_vpl VALUES ("MT5_22","070_5_22","MAT","5","22","22","—C'u' betiqui, tan in wadic te'ex. Tulacal a mac a ca'ax chen tz'iic ti'i u yet'oco, sabeensil u tz'abül ichil u sip'il. Le'ec mac ca' u p'a'aste u yet'oco, sabeensil u bensabül tu taanoo' u yaabil aj il sip'ili. Le'ec mac ca' u yadü' tu c'asil ti pula'an u yet-hermanojili, sabeensil u beel ichil a infierno tuba yan a c'aac'a,— cu t'an a Jesusu. ");
INSERT INTO mopNT_vpl VALUES ("MT5_23","070_5_23","MAT","5","23","23","—Jujun tuule'exe, le'ec ti que'ene'ex a tz'aa' a sij-ool ti'i a Dioso, uchac u c'aal te'ex ti yane'ex a sip'il ti'i ulaac' a hermanojo. ");
INSERT INTO mopNT_vpl VALUES ("MT5_24","070_5_24","MAT","5","24","24","Se' p'üte'ex a sij-ool te'i jabix tu taan a Dioso. Ca' xique'ex a tojquinte a sip'il etel a hermano ca' tun talaque'ex a tz'aa' a sij-oolo,— cu t'an a Jesusu. ");
INSERT INTO mopNT_vpl VALUES ("MT5_25","070_5_25","MAT","5","25","25","—Le'ec ti tan to u beel u tzole'ex yotoch caj aj tzolo, seebte'ex a bajil a wemes u yool. Wa ma'a, bel u cu bense'ex tu taan aj il sip'ili. Le'ec aj il sip'ili, bel u cu c'ube'ex ti'i a soldadojo. Bel u cu c'üle'ex ich cuarto. ");
INSERT INTO mopNT_vpl VALUES ("MT5_26","070_5_26","MAT","5","26","26","Tan in wadic te'ex u jajil. Ma' ta joc'ole'ex te'i asto a bo'tique'ex a multa. Ma'ax jun p'e centavo bel u ca'a emsabül te'ex,— cu t'an a Jesusu. ");
INSERT INTO mopNT_vpl VALUES ("MT5_27","070_5_27","MAT","5","27","27","—Pues te'i. A wu'yaje'ex ti aalbi ti'ijoo' ti uchben mamaa' ti ma' u cüjtaloo' etel a ca'ax macaca. ");
INSERT INTO mopNT_vpl VALUES ("MT5_28","070_5_28","MAT","5","28","28","C'u' betiqui, baala' in t'an inene. Tulacal a jujun tuulu, ca'ax chen tan u tz'i'lic a cüjtal etel ix ch'up ti tan u cha'antiqui, ac u betaj tun ichil u püsüc'al,— cu t'an a Jesusu. ");
INSERT INTO mopNT_vpl VALUES ("MT5_29","070_5_29","MAT","5","29","29","—Uchac tane'ex a cüxtic a sip'il chen etel c'u' a tane'ex a cha'antic jabix cuchi u nec' a wich ta waj seeb ta waj toj tan u tz'eec te'ex ca' a cüxte'ex a sip'ili. P'üte'ex a cha'antic jabix cuchi tane'ex a joc'sic u nec' a wichi, y a pule'exe. Mas toj jabix cuchi ca' sa'tüc te'ex jun cuul u nec' a wich tuwich ca' culaque'ex ti ca' cuul u nec' a wich y pulbule'ex a ca'a ichil a infiernojo,— cu t'an a Jesusu. ");
INSERT INTO mopNT_vpl VALUES ("MT5_30","070_5_30","MAT","5","30","30","—Wa cuchi tane'ex a cüxtic a sip'il chen etel c'u' a tane'ex a betiqui, jabix cuchi a waj seeb c'ü'e'ex a waj toj a tan u tz'eec te'ex ca' a cüxte'ex a sip'ili, mas qui' cuchi a ch'üquique'ex y ca' a pule'ex. Mas toj cuchi ca' sa'tüc te'ex jun p'eel a c'ü' tuwich ca' culaque'ex ti ca' p'eel a c'ü' y pulbule'ex a ca'a ichil a infiernojo,— cu t'an a Jesusu. ");
INSERT INTO mopNT_vpl VALUES ("MT5_31","070_5_31","MAT","5","31","31","—Pues te'i. Aalbi ilic ti'ijoo' ti uchben mamaa' a t'an ada'a. “Le'ec mac u c'ati u p'ütü' u yütana, yan u tz'iibtic u ju'umil ca' u tz'aa' ti'i ti'i u p'ütical,” cu t'an ti'ijoo' uchi,— cu t'an a Jesusu. ");
INSERT INTO mopNT_vpl VALUES ("MT5_32","070_5_32","MAT","5","32","32","—C'u' betiqui, baala' in t'an inene. Le'ec a tan u p'ütic u yütana, tan u tz'eec ti'i u yütan ca' u cüxte u sip'il, le'ec ca' cüjlac etel ulaac'. C'u' betiqui, wa cuchi cüjlaji u yütan etel ulaac'a, jede'ec cuchi u paatal u p'ütiqui. Le'ec mac ca' u yütante a ac p'üta'an u men u yichama, tan ilic u cüxtic u sip'il ala'aji, le'ec a cüjtala,— cu t'an a Jesusu. ");
INSERT INTO mopNT_vpl VALUES ("MT5_33","070_5_33","MAT","5","33","33","—Pues te'i. A wu'yaje'ex ti aalbi ilic ti'ijoo' ti uchben mamaa' a t'an ada'a. “Le'ec ti tane'ex a tz'eec a t'an a bete'ex jun p'eel ba'ala, ma' a c'ajsique'ex u c'aba' Dios ichil a t'ane'ex wa chen tus. Bete'ex c'u' a wadaje'ex a betic tu taan a Noochtzili,” cu t'an ti'ijoo' uchi,— cu t'an a Jesusu. ");
INSERT INTO mopNT_vpl VALUES ("MT5_34","070_5_34","MAT","5","34","34","—C'u' betiqui, baala' in t'an inene. Ma' a c'ajsique'ex a ma'ax c'u'i ichile'ex a t'an ti'i ca' chiclac wa jaj. Ma' a c'ajsique'ex a ca'an ichile'ex a t'an ti'i ca' chiclac wa jaj u men le'ec a ca'ana, le'ec u tintaan a Dioso,— cu t'an a Jesusu. ");
INSERT INTO mopNT_vpl VALUES ("MT5_35","070_5_35","MAT","5","35","35","—Ma'ax a c'ajsique'ex a yoc'olcab ichile'ex a t'an ti'i ca' chiclac wa jaj u men le'ec a yoc'olcaba, u cuuchil u yoc a Dioso. Ma'ax a c'ajsique'ex a caj Jerusalen ichile'ex a t'an ti'i ca' chiclac wa jaj u men le'ec a caj Jerusalene, u cuuchil a noxi' rey, le'ec a Dioso,— cu t'an a Jesusu. ");
INSERT INTO mopNT_vpl VALUES ("MT5_36","070_5_36","MAT","5","36","36","—Ma'ax a c'ajsique'ex ma'ax a pol xan ichile'ex a t'an ti'i ca' chiclac wa jaj u men ma' yane'ex a muc' a su'tesic ma'ax jun xiit a tzo'otzel ca' p'aatüc ti süc wa box,— cu t'an a Jesusu. ");
INSERT INTO mopNT_vpl VALUES ("MT5_37","070_5_37","MAT","5","37","37","—Le'ec biq'uin a c'ate'ex a wadü' a le'eque, jadi' ade'ex a le'ec iliqui. Le'ec biq'uin a c'ate'ex a wadü' a ma'a, jadi' ade'ex a ma' iliqui. Ti baalo'o, ma' u yantal u chucaan a t'ana, le'ec a walac u tal etel a quisini,— cu t'an a Jesusu. ");
INSERT INTO mopNT_vpl VALUES ("MT5_38","070_5_38","MAT","5","38","38","—Pues te'i. A wu'yaje'ex ti aalbi ilic ti'ijoo' ti uchben mamaa' a t'an ada'a. “Le'ec u cüxtaj u sip'il ti ca' u tucaj u nec' u wich ulaac' maca, yan ilic u tucbul u nec' u wich tu jelil. Le'ec u cüxtaj u sip'il ti ca' u tochaj u coj ulaac' maca, yan ilic u tochbol u coj tu jelil,” cu t'an ti'ijoo' uchi,— cu t'an a Jesusu. ");
INSERT INTO mopNT_vpl VALUES ("MT5_39","070_5_39","MAT","5","39","39","—C'u' betiqui, baala' in t'an inene. Cha'e'ex u beticoo' a c'as te'ex a mac a c'asa. Le'ec mac ca' u jütz'ü' a p'u'uc tu yaj toj tu yaj seebe, sute'ex a junxeele, ti'i ca' ilic u jütz'ü',— cu t'an a Jesusu. ");
INSERT INTO mopNT_vpl VALUES ("MT5_40","070_5_40","MAT","5","40","40","—Wa yan mac a bini tu taan aj il sip'il ti'i ca' u toco' jun tziil a noc'o, cha'a ti'i ca' u toco' ulaac',— cu t'an a Jesusu. ");
INSERT INTO mopNT_vpl VALUES ("MT5_41","070_5_41","MAT","5","41","41","—Wa yan mac u tz'aa' te'ex ca' a cuche'ex u cuch jun p'e kilometro y media, cuche'ex jun p'e kilometro y media manal,— cu t'an a Jesusu. ");
INSERT INTO mopNT_vpl VALUES ("MT5_42","070_5_42","MAT","5","42","42","—Mac a tan u matic a c'u' te'exe, tz'aje'ex ti'i. Mac a tan u maantic a c'u' te'exe, tz'aje'ex ilic ti'i,— cu t'an a Jesusu. ");
INSERT INTO mopNT_vpl VALUES ("MT5_43","070_5_43","MAT","5","43","43","—Pues te'i. A wu'yaje'ex ti aalbi ilic ti'ijoo' ti uchben mamaa' a t'an ada'a. “Yacunte a wet'oc. Motzinte a wettz'iiquil,” cu t'an ti'ijoo' uchi,— cu t'an a Jesusu. ");
INSERT INTO mopNT_vpl VALUES ("MT5_44","070_5_44","MAT","5","44","44","—C'u' betiqui, baala' in t'an inene. Yacunte'exoo' a tz'iic te'exe. C'ajes a Dios yoc'oloo' a tanoo' u betic te'ex a yaja,— cu t'an a Jesusu. ");
INSERT INTO mopNT_vpl VALUES ("MT5_45","070_5_45","MAT","5","45","45","—Ca' a bete'ex a baalo'o, chica'an ti inche'ex u mejene'ex a Dios ti ca'an u men baalo' ilic a walac u betic ala'aji. Walac u tz'eec u sac a q'uin yoc'ol a toj u na'at y yoc'ol a ma' toj u na'ata. Walac ilic u tz'eec ca' uchuc a ja' yoc'ol a toj u na'at y yoc'ol a ma' toj u na'ata,— cu t'an a Jesusu. ");
INSERT INTO mopNT_vpl VALUES ("MT5_46","070_5_46","MAT","5","46","46","—Wa cuchi jadi' a yajoo' u yube'ex a tane'ex a yacuntiqui, ma' tu yaalbül a qui'ile'ex u men a Dioso. Baalo' ilic a walacoo' u betic a cristiano a jabixoo' a motztziloo' aj mol taq'uin ti'i a gobiernojo. Chen walacoo' u yacuntic a qui'oo' etele,— cu t'an a Jesusu. ");
INSERT INTO mopNT_vpl VALUES ("MT5_47","070_5_47","MAT","5","47","47","—Wa cuchi jadi' a wetqui'ile'ex a walaque'ex a tziquiqui, ¿c'u' ti qui'il a tane'ex a betic a ma' ta'ach u betic a ca'ax macaca? Le'ecoo' a ma' u yeeloo' a Dioso, baalo' ilic a walacoo' u betiqui,— cu t'an a Jesusu. ");
INSERT INTO mopNT_vpl VALUES ("MT5_48","070_5_48","MAT","5","48","48","—Tojquinte'ex a na'at tu jajil u men le'ec a Tate'ex a que'en ti ca'ana, toj tu jajil,— cu t'an a Jesusu. ");
INSERT INTO mopNT_vpl VALUES ("MT6_1","070_6_1","MAT","6","1","1","—Pues te'i. Cününte'ex a bajil ti tane'ex a betic a qui' ti'i ma' a betique'ex chen ti'i ca' ilbic u menoo' a cristianojo. Wa cuchi ca' a bete'ex a qui' chen ti'i ca' ilbic ti baalo'o, ma' tu tz'abüle'ex a naal tu jel abe' u men a Tate'ex a que'en ti ca'ana,— cu t'an a Jesusu. ");
INSERT INTO mopNT_vpl VALUES ("MT6_2","070_6_2","MAT","6","2","2","—Le'ec ti tane'ex a tz'eec a sij-oolo, ma' a pecsique'ex a ma'ax c'u'i ti'i ca' aalbüc a qui'ile'ex jabix ti walacoo' u betic aj cho'o. Aj cho'o, walacoo' u betic abe' ichil boon a naj tuba walacoo' u much'tal a cristiano u c'ajes a Dioso, y walacoo' ilic u betic abe' ti calle. Tan in wadic te'ex u jajil. Ac u c'ümajoo' tun u jel a c'u' a walacoo' u betiqui. Le'ec u yaalbüloo' u qui'il u menoo' a cristianojo, le'ec u jel,— cu t'an a Jesusu. ");
INSERT INTO mopNT_vpl VALUES ("MT6_3","070_6_3","MAT","6","3","3","—Ma' baalo' ca' a tz'a'e'ex a sij-ool inche'exi. Le'ec ti tane'ex a tz'eec a sij-oolo, tz'aje'ex ti ma'ax mac u yeel jabix cuchi jun p'eel a c'ü'ü, ma' u yeel c'u' a tan u betic ulaac' jun p'eel a c'ü'ü, u men muca'an,— cu t'an a Jesusu. ");
INSERT INTO mopNT_vpl VALUES ("MT6_4","070_6_4","MAT","6","4","4","—Ti baalo'o, tane'ex a tz'eec a sij-ool ich mucul. Le'ec a Tate'exe, tan u yilic c'u' a tane'ex a betic ich muculu. Tulacal mac, bel u cu yila' ti tz'abüc te'ex u jel,— cu t'an a Jesusu. ");
INSERT INTO mopNT_vpl VALUES ("MT6_5","070_6_5","MAT","6","5","5","—Pues te'i. Le'ec ti tane'ex a t'an etel a Dioso, ma' a betique'ex jabix ti walacoo' u betic aj cho'o. Top qui' tu wichoo' ala'oo' u wa'tal ti t'an etel Dios ichil boon a naj tuba walacoo' u much'tal a cristiano u c'ajes a Dioso, wa xan tu xuuc' a calle chen ti'i ca' ilbic u menoo' a cristianojo. Tan in wadic te'ex u jajil. Ac u c'ümajoo' tun u jel a c'u' a walacoo' u betiqui, le'ec u yaalbüloo' u qui'il,— cu t'an a Jesusu. ");
INSERT INTO mopNT_vpl VALUES ("MT6_6","070_6_6","MAT","6","6","6","—Inche'exe, ma' a t'ane'ex etel Dios jabix tu t'anoo' ala'oo'o. Le'ec ti bele'ex a ca'a ti t'an etel a Dioso, oquene'ex ichil a wotoch. C'üle'ex a puertaja. Te'i a t'ane'ex etel a Dioso. Ma' ta'ach u yilbil a Dioso. Tan u yilic c'u' a walac u yuchul ich mucul. Tulacal mac, bel u cu yila' ti tz'abüc te'ex u jel,— cu t'an a Jesusu. ");
INSERT INTO mopNT_vpl VALUES ("MT6_7","070_6_7","MAT","6","7","7","—Le'ec ti tane'ex a t'an etel a Dioso, ma' a wadique'ex a t'an a le'ec ti le'ec a ma'ax c'u' aj beel jabix a walacoo' u yadic a ma' u yeeloo' a Dioso. Tu t'an ala'oo'o, beloo' u ca'a u'yajbül u men u yaabil u t'an,— cu t'an a Jesusu. ");
INSERT INTO mopNT_vpl VALUES ("MT6_8","070_6_8","MAT","6","8","8","—Ma' a betique'ex a jabix ala'oo'o, u men le'ec a Tate'exe, ac u yeel c'u' a c'abeet te'ex le'ec ti ma'ax to a c'aate'ex ti'iji,— cu t'an a Jesusu. ");
INSERT INTO mopNT_vpl VALUES ("MT6_9","070_6_9","MAT","6","9","9","—Le'ec ti tane'ex a t'an etel a Dioso, ade'ex a jabix ada'a,— cu t'an a Jesusu. —Tat a que'enech ti ca'an, ti c'ati cuchi ca' tz'ocsabüc u yanil a c'aba'. ");
INSERT INTO mopNT_vpl VALUES ("MT6_10","070_6_10","MAT","6","10","10","Ca' talaquech wa'ye' ti tücaa'. Tan cuchi a tz'ocsabül wa'ye' yoc'olcab jabix ilic ti walac a tz'ocsabül ti ca'an. ");
INSERT INTO mopNT_vpl VALUES ("MT6_11","070_6_11","MAT","6","11","11","Tz'a to'on ti janal sansamal. ");
INSERT INTO mopNT_vpl VALUES ("MT6_12","070_6_12","MAT","6","12","12","Sa'tes ti sip'il u men ti sa'tesaj ti'ijoo' mac u betajoo' to'on a c'asa. ");
INSERT INTO mopNT_vpl VALUES ("MT6_13","070_6_13","MAT","6","13","13","Ma' a cha'ic ca' talac emsabül ti wool ca' ti bete' a c'asa. Sa'alto'on ti'i ma' ti cho'bol u men a c'asa. Inchech a reye. Yan a muc'. Nooch a yanil. Ma' yan q'uin u jobol. Baalo' ca' a wade'ex,— cu t'an a Jesusu. ");
INSERT INTO mopNT_vpl VALUES ("MT6_14","070_6_14","MAT","6","14","14","—Wa cuchi ca' a sa'tese'ex u sip'il a mac u betaj te'ex a c'asa, bel ilic u cu sa'tese'ex a sip'il a Tate'ex ti ca'an. ");
INSERT INTO mopNT_vpl VALUES ("MT6_15","070_6_15","MAT","6","15","15","C'u' betiqui, wa ma' ta sa'tesique'ex u sip'il ulaac' mac, ma' ilic tu sa'tesabüle'ex a sip'il inche'ex u men a Tate'ex ti ca'an,— cu t'an a Jesusu. ");
INSERT INTO mopNT_vpl VALUES ("MT6_16","070_6_16","MAT","6","16","16","—Pues te'i. Le'ec ca' a p'üte'ex a janal ti'i a suq'uini, ma' a betique'ex a wich jabix yaje'ex a wool jabix a walacoo' u betic aj cho'o. Ala'oo'o, walacoo' u betic u wich jabix top yajoo' u yool chen ti'i ca' chiclac ti'ijoo' a cristiano ti tanoo' u suq'uin. Tan in wadic te'ex u jajil. Ac u c'ümajoo' tun u jel a c'u' a walacoo' u betiqui, le'ec u yaalbüloo' u qui'il,— cu t'an a Jesusu. ");
INSERT INTO mopNT_vpl VALUES ("MT6_17","070_6_17","MAT","6","17","17","—Inche'exe, ma' a betique'ex a jabix ala'oo'o. Le'ec ca' a p'üte'ex a janal ti tane'ex a suq'uini, utzquinte'ex a tzo'otzel. Po'e'ex a wich. ");
INSERT INTO mopNT_vpl VALUES ("MT6_18","070_6_18","MAT","6","18","18","Ti baalo'o, ma' chica'an ti'ijoo' a cristiano wa tane'ex a suq'uin. Jadi' chica'an ti'i a Tate'exe. Ma' ta'ach u yilbil a Dioso. Tan u yilic c'u' a walac u yuchul ich mucul. Tulacal mac, bel u cu yila' ti tz'abüc te'ex u jel,— cu t'an a Jesusu. ");
INSERT INTO mopNT_vpl VALUES ("MT6_19","070_6_19","MAT","6","19","19","—Pues te'i. Ma' a taac'tique'ex a ayic'alil wa'ye' yoc'olcab tuba walac u jantabül u men ix moc'oc' wa u men itz. Wa'ye'e, jede'ecoo' u yocol aj xuuch' u xuuch'teje,— cu t'an a Jesusu. ");
INSERT INTO mopNT_vpl VALUES ("MT6_20","070_6_20","MAT","6","20","20","—Taac'te'ex a ayic'alil ich ca'an. Te'i ma' yan ix moc'oc' ma'ax itz ti'i u jantical. Ma' yan q'uin u yocol aj xuuch' te'i ti xuuch',— cu t'an a Jesusu. ");
INSERT INTO mopNT_vpl VALUES ("MT6_21","070_6_21","MAT","6","21","21","—Taac'te'ex ti ca'an u men le'ec tuba que'ene'ex a ayic'alili, te'i ilic que'ene'ex a wool,— cu t'an a Jesusu. ");
INSERT INTO mopNT_vpl VALUES ("MT6_22","070_6_22","MAT","6","22","22","—Pues te'i. U men u nec' u wich a maca, chica'an u benil. Le'ec ti sasil u nec' u wichi, chica'an ti'i tulacal u benil. ");
INSERT INTO mopNT_vpl VALUES ("MT6_23","070_6_23","MAT","6","23","23","Le'ec ti ma' qui' u nec' u wichi, ma' ilic chica'an u benil. Baalo' ilic etel u na'at. Wa ma' qui' u na'ata, top yaab u sip'il jabix cuchi que'en ich ac'ü'ü. Top ac'ü' ac'ü' tu jajil tuba que'en,— cu t'an a Jesusu. ");
INSERT INTO mopNT_vpl VALUES ("MT6_24","070_6_24","MAT","6","24","24","—Pues te'i. Jun tuul aj meyaja, ma' tu paatal u betic u meyaj ti ca' tuul u tz'ulil. Motz ti'i a jun tuulu, y yaj u yubi ulaac' a jun tuulu. Wa ma'a, bel u cu tz'aa' u yool tu pach a jun tuulu, y bel u cu motzinte ulaac' a jun tuulu. Ma' ilic tu paatal a tz'eeque'ex a wool ich ca' xeel, tu pach a Dioso, y tu pach a taq'uini,— cu t'an a Jesusu. ");
INSERT INTO mopNT_vpl VALUES ("MT6_25","070_6_25","MAT","6","25","25","—Pues te'i. U men c'u' in wadaj to te'ex yoc'ol ma' tu paatale'ex a tz'eec a wool ich ca' xeele, tan in wadic te'ex. Ma' a top tuclique'ex tuba u talel a janale'ex a wuc'ule'ex ti'i a cuxtale'exe. Ma'ax a top tuclique'ex tuba u talel a noq'ue'ex ti'i a tz'eeque'ex ta woc'ol. Le'ec a cuxtale'exe, ma' jadi' a janale'exi, ma'ax jadi' a noq'ue'exi,— cu t'an a Jesusu. ");
INSERT INTO mopNT_vpl VALUES ("MT6_26","070_6_26","MAT","6","26","26","—Tucle'ex u cuxtaloo' a ch'iich'i. Ma' ta'achoo' u pac', ma'axoo' u joch. Ma' yanoo' u ranchojil u nül. C'u' betiqui, walacoo' u tzeenbel u men a Tate'ex a que'en ti ca'ana. Mas c'atiintzile'ex inche'ex tuwichoo' a ch'iich'i,— cu t'an a Jesusu. ");
INSERT INTO mopNT_vpl VALUES ("MT6_27","070_6_27","MAT","6","27","27","—Ma'ax mac ta yaame'ex jede'ec u sützic u bajil ma'ax ox naab chen tanil u tuclic,— cu t'an a Jesusu. ");
INSERT INTO mopNT_vpl VALUES ("MT6_28","070_6_28","MAT","6","28","28","—Wa ma' patale'ex a bete' abe'e, ¿c'u' ca'a top tane'ex a tuclic biqui ca' yanaque'ex a noc'? Tucle'ex biqui ti walac u ch'iil a top' ich che'e. Ma' ta'ach u meyaj, ma'ax u jitic u noc',— cu t'an a Jesusu. ");
INSERT INTO mopNT_vpl VALUES ("MT6_29","070_6_29","MAT","6","29","29","—Tan in wadic te'ex. Le'ec ti yan a noc' a top quich'pan yoc'ol aj rey Salomon uchiji, ma' yan u quich'panil jabix jun p'eel top'o,— cu t'an a Jesusu. ");
INSERT INTO mopNT_vpl VALUES ("MT6_30","070_6_30","MAT","6","30","30","—Le'ec a top' abe'e, cuxa'an tu cuuchil aleebe. Samala, bel u ca'a pulbul ich c'aac'. Le'ec a Dioso, u tz'aj u quich'panil a top' abe'e, y jun p'e rato ilic cuxa'an. Mas que'en u yool a Dios u tz'aa' te'ex a noc' tuwich u tz'eec u quich'panil a top'o. Ma' top que'ene'ex a wool tu pach a Dioso. Top que'ene'ex to a wool tu pach a yoc'olcaba,— cu t'an a Jesusu. ");
INSERT INTO mopNT_vpl VALUES ("MT6_31","070_6_31","MAT","6","31","31","—Ma' a top tuclique'ex c'u' a c'abeet te'exe. Ma' a wadique'ex ta bajil: “¿Tuba ti cüxtic ti janal? ¿Tuba ti cüxtic ti wuc'ul? ¿Tuba ti cüxtic ti noc'?” Ma' a tuclique'ex ti baalo',— cu t'an a Jesusu. ");
INSERT INTO mopNT_vpl VALUES ("MT6_32","070_6_32","MAT","6","32","32","—Le'ecoo' a cristiano a ma' ti'i a Dioso, top walacoo' u tuclic c'u' a c'abeet ti'ijoo'o. Ma' cuchi baalo'e'ex inche'exi. Le'ec a Tate'ex ti ca'ana, ac u yeel tun ti laj c'abeet te'ex tulacal abe'e,— cu t'an a Jesusu. ");
INSERT INTO mopNT_vpl VALUES ("MT6_33","070_6_33","MAT","6","33","33","—Inche'exe, payanbej ca' a tucle'ex biqui'il u c'ati a Dioso. Tucle'ex a toj na'at jabix u c'ati. Jede'ec ilic u tz'abül te'ex tulacal a c'u' a c'abeet te'exe,— cu t'an a Jesusu. ");
INSERT INTO mopNT_vpl VALUES ("MT6_34","070_6_34","MAT","6","34","34","—Ma' a top tuclique'ex a c'u' a bel u ca'a ti uchul tu samalili. Ichil a jun p'e q'uini, walac u yantal ti chucul a c'as ti'i ma' a tuclique'ex a c'as a yantal u ca'a tu samalili,— cu t'an a Jesusu. ");
INSERT INTO mopNT_vpl VALUES ("MT7_1","070_7_1","MAT","7","1","1","—Pues te'i. Ma' a tz'eeque'ex a mac ichil u sip'ili. Ti baalo'o, ma' ta tz'abüle'ex ichile'ex a sip'il. ");
INSERT INTO mopNT_vpl VALUES ("MT7_2","070_7_2","MAT","7","2","2","Jabix ilic ti walaque'ex a il sip'il, baalo' ilic ti bel u ca'a ilbil a te'exe. Jabix ilic ti walaque'ex a tz'eeque, baalo' ilic ti bel u ca'a tz'abül te'ex,— cu t'an a Jesusu. ");
INSERT INTO mopNT_vpl VALUES ("MT7_3","070_7_3","MAT","7","3","3","—¿C'u' ca'a tan a wilic u sip'il a hermano bete cuenta tan a wilic tz'etz'eec a ta'lu'um ichil u nec' u wichi? Uxtun incheche, ma' ta'ach a tz'eec ta wool ti nooch a sip'il bete cuenta jabix noxi' che' a que'en ichil u nec' a wich,— cu t'an a Jesusu. ");
INSERT INTO mopNT_vpl VALUES ("MT7_4","070_7_4","MAT","7","4","4","—¿C'u' betiqui, baala' walac a wadic ti'i a hermanojo. “Cha'a in joc'sic abe' a jabix ta'lu'um a que'en ichil u nec' a wich,” queech ti'i y yan jabix a noxi' che' ichil a teche. ¿C'u' ca'a ma' saaquech a wadü' a jabix abe' ti'iji?— cu t'an a Jesusu. ");
INSERT INTO mopNT_vpl VALUES ("MT7_5","070_7_5","MAT","7","5","5","—Incheche, chen aj cho'ech. Payanbej joq'ues abe' a jabix a noxi' che' a que'en ichil u nec' a wich. Pachili, jede'ec a wilic ti qui' biqui ca' a joq'ues abe' a jabix a ta'lu'um a que'en ichil u nec' u wich a hermanojo,— cu t'an a Jesus yoc'oloo' u sip'il. ");
INSERT INTO mopNT_vpl VALUES ("MT7_6","070_7_6","MAT","7","6","6","—Pues te'i. Le'ec a quich'pan a ti'i a Dioso, ma' a tz'eeque'ex ti'ijoo' a jabix peq'ue. Bic xicoo' u sutoo' u bajil y ca' u puloo' u bajil ta woc'ole'ex. Ma'ax a tz'eeque'ex a top quich'pan ta wu'yique'ex ti'ijoo' a jabix eq'uene. Bic xicoo' u wa'che'te,— cu t'an a Jesus yoc'ol u yaalbül a quich'pan ti'ijoo' a ma' u c'atoo' u yubi. ");
INSERT INTO mopNT_vpl VALUES ("MT7_7","070_7_7","MAT","7","7","7","—Pues te'i. Tanaque'ex a c'aatic y bel u ca'a tz'abül te'ex u men a Dioso. Tanaque'ex a cüxtic c'u' a c'ate'ex etel a Dioso, y bele'ex a ca'a a cüxte. Tanaque'ex a jabix boojtic a jabix puerta tuba a c'ate'ex a beel y bel u ca'a jebbel te'ex,— cu t'an a Jesusu. ");
INSERT INTO mopNT_vpl VALUES ("MT7_8","070_7_8","MAT","7","8","8","—Tan in wadic te'ex abe'e, u men tulacal a jujun tuul a tan ti tan u c'aatiqui, tan u c'ümic. Le'ec a tan ti tan u cüxtiqui, tan u cüxtic. Le'ec a tan ti tan u boojtic a puertaja, tan u jebbel ti'i,— cu t'an a Jesusu. ");
INSERT INTO mopNT_vpl VALUES ("MT7_9","070_7_9","MAT","7","9","9","—Ma' yan a winic a jede'ec u tz'eec a tunich ti'i u mejen wa pan a tan u c'aatbül ti'iji. ");
INSERT INTO mopNT_vpl VALUES ("MT7_10","070_7_10","MAT","7","10","10","Ma'ax tu tz'eec a can wa tan u c'aatbül ti'i aj ch'ilama,— cu t'an a Jesusu. ");
INSERT INTO mopNT_vpl VALUES ("MT7_11","070_7_11","MAT","7","11","11","—Ca'ax walaque'ex a cüxtic a sip'il, a weele'ex biqui ca' a tz'a'e'ex a quich'pan sij-ool ti'ije'ex a mejen. ¿Ma' wa mas que'en u yool a Tate'ex a que'en ti ca'an u tz'aa' a qui' ti'i a mac a tan u c'aatiqui?— cu t'an a Jesusu. ");
INSERT INTO mopNT_vpl VALUES ("MT7_12","070_7_12","MAT","7","12","12","—Le'ec biqui'il a c'ate'ex cuchi ca' betabüc te'exe, yan ilic a betique'ex ti baalo' ti'ijoo' a cristianojo. Ti baalo'o, ac tane'ex a tz'ocsic a ley u tz'iibtaj aj Moisese, y a t'an u tz'iibtajoo' boon tuul u yadajoo' u t'an a Dios uchi,— cu t'an a Jesusu. ");
INSERT INTO mopNT_vpl VALUES ("MT7_13","070_7_13","MAT","7","13","13","—Pues te'i. Tz'aje'ex a wool a wocole'ex ichil a jabix puerta a tz'itz'i' u taan. Yan ulaac' a jabix puerta a nooch u taana. Ma' yaj a ximbal tu benil a puerta abe'e. C'u' betiqui, walac u beel ich c'asil. Yaaboo' a tanoo' u yocol te'i,— cu t'an a Jesusu. ");
INSERT INTO mopNT_vpl VALUES ("MT7_14","070_7_14","MAT","7","14","14","—Le'ec a jabix bej a walac u beel ti'i u puertajil a cuxtal a ma' yan q'uin u jobolo, c'üs yaj a beel tuwichi. Tz'itz'i' u taan jabix a puerta abe'e. Ma' yaab mac walacoo' u cüxtic abe'e,— cu t'an a Jesusu. ");
INSERT INTO mopNT_vpl VALUES ("MT7_15","070_7_15","MAT","7","15","15","—Pues te'i. Cününte'ex a bajil ti'i ma' a cho'bole'ex u menoo' a tanoo' u tz'eec u bajil jabixoo' u yaj meyaj a Dioso, pero chenoo' u tus. Walacoo' u tz'eec u bajil jabix qui'oo' jabix a carnerojo. C'u' betiqui, c'asoo' jabix a baalumu,— cu t'an a Jesusu. ");
INSERT INTO mopNT_vpl VALUES ("MT7_16","070_7_16","MAT","7","16","16","—Bele'ex a ca'a a weelte biqui'iloo' u na'at ala'oo' etel c'u' a walac u yantal u menoo'. A q'ui'ixi, ma' yan q'uin u wichintic ix tzusu. Ma' ta wuxique'ex te'i. Ma'ax u wich a che'e, ma' tu yuxbul tuwich a laja,— cu t'an a Jesusu. ");
INSERT INTO mopNT_vpl VALUES ("MT7_17","070_7_17","MAT","7","17","17","—Tulacal a che' a qui'i, qui' ilic u wich. Tulacal a che' a ma' qui'i, ma' ilic qui' u wich. ");
INSERT INTO mopNT_vpl VALUES ("MT7_18","070_7_18","MAT","7","18","18","Le'ec a che' a qui'i, ma' tu wichintic a c'asa. Ma'ax a che' a c'asa, ma' tu wichintic a qui'i,— cu t'an a Jesusu. ");
INSERT INTO mopNT_vpl VALUES ("MT7_19","070_7_19","MAT","7","19","19","—Tulacal a che' a ma' ta'ach u tz'eec u wich a qui'i, walac u ch'ücbül. Walac u pulbul ich c'aac',— cu t'an a Jesusu. ");
INSERT INTO mopNT_vpl VALUES ("MT7_20","070_7_20","MAT","7","20","20","—Baalo' ilic a tanoo' u tz'eec u bajil jabixoo' u yaj meyaj a Dioso, pero chenoo' u tus. Chica'an biqui'iloo' u na'at etel c'u' a walac u yantal u menoo',— cu t'an a Jesusu. ");
INSERT INTO mopNT_vpl VALUES ("MT7_21","070_7_21","MAT","7","21","21","—Pues te'i. Le'ec a tanoo' u yadic ten Noochil, Noochil, ma' tulacaloo' ala'oo' a ocoloo' u ca'a tu cuenta a Dioso. Jadi' a tanoo' u betic a jabix u c'ati in Tat a que'en ti ca'ana, jadi' a ocoloo' u ca'a,— cu t'an a Jesusu. ");
INSERT INTO mopNT_vpl VALUES ("MT7_22","070_7_22","MAT","7","22","22","—Ti a q'uin abe' ti tanoo' u yocol te'i, yanoo' a beloo' u cu yadü' ten a t'an a jabix ada'a. “Noochil, Noochil, ti wadaj a pectzil etel u yanil a c'aba'. Ti joc'sajoo' a c'ac'asba'al tu yool a mac etel ilic a c'aba'. Yaab a milagro ti betaj etel ilic a c'aba',” cu t'anacoo' ten,— cu t'an a Jesusu. ");
INSERT INTO mopNT_vpl VALUES ("MT7_23","070_7_23","MAT","7","23","23","—“Ma'ax jun sut in wilaje'ex ti tene'ex. Joq'uene'ex tin tzeel. Chen c'as a walaque'ex a betiqui,” queenac ti'ijoo',— cu t'an a Jesusu. ");
INSERT INTO mopNT_vpl VALUES ("MT7_24","070_7_24","MAT","7","24","24","—Pues te'i. Tulacal mac a walacoo' u yubic in t'an, y walacoo' u betic c'u' a walac in wadiqui, ala'oo'o, jabix a mac a patal, le'ec u betaj a naj etel tunich. Tunich ilic u cuuch a naj yoc'ol ca' yanac u muc',— cu t'an a Jesusu. ");
INSERT INTO mopNT_vpl VALUES ("MT7_25","070_7_25","MAT","7","25","25","—Caji a ja' a c'a'ama. Tudi tuba que'en a naja. Tan ilic a iq'ui. C'u' betiqui, ma' u pecsaj a naji. Ma' pulbi u men betabi yoc'ol tunich,— cu t'an a Jesus ti'i a tanoo' u tz'ocsaja. ");
INSERT INTO mopNT_vpl VALUES ("MT7_26","070_7_26","MAT","7","26","26","—Tulacal mac a walacoo' u yubic in t'an pero ma' ta'achoo' u tz'ocsiqui, ala'oo'o, jabix mac a ma' u yeel, le'ec u betaj a naj etel tunich. Jadi' ch'ich' u cuuchil a naja,— cu t'an a Jesusu. ");
INSERT INTO mopNT_vpl VALUES ("MT7_27","070_7_27","MAT","7","27","27","—Caji a ja' a c'a'ama. Tudi tuba que'en a naja. Tan ilic a iq'ui. U pecsaj a naja. C'axi. Jumpul juubi a naja,— cu t'an a Jesus ti tan u tzicbaltic a ma' tanoo' u tz'ocsaj. ");
INSERT INTO mopNT_vpl VALUES ("MT7_28","070_7_28","MAT","7","28","28","Le'ec ti jobi u yadic tulacal a t'an abe' a Jesusu, chen sa'too' u yool a cristiano u men biqui ti walac u ca'ansaj. ");
INSERT INTO mopNT_vpl VALUES ("MT7_29","070_7_29","MAT","7","29","29","A Jesusu, u ca'ansajoo' jabix ilic tu ca'ansaj jun tuul a top u yeele. Le'ecoo' u yaj ca'ansajil u ley aj Moisese, ma' ta'achoo' u ca'ansaj jabix a Jesusu. ");
INSERT INTO mopNT_vpl VALUES ("MT8_1","070_8_1","MAT","8","1","1","Pues te'i. Le'ec ti emi a Jesus tuwich witz, mil u yaabil a cristiano a tücünacoo' tu pach. ");
INSERT INTO mopNT_vpl VALUES ("MT8_2","070_8_2","MAT","8","2","2","Naatz'i jun tuul a winic tu tzeel a Jesusu. Top tan u tu'ujtal u büq'uel u men u c'oja'anil. Xonlaji tu taan a Jesusu. —Noochil, wa qui' ta wich a ch'anesiquene, jede'ec u paatal a ch'anesiquen,— cu t'an ti'i a Jesusu. ");
INSERT INTO mopNT_vpl VALUES ("MT8_3","070_8_3","MAT","8","3","3","Le'ec a Jesusu, u tz'aj u c'ü' yoc'ol a winiqui. —In c'ati,— cu t'an ti'i. —Ch'aneech tun,— cu t'an a Jesusu. Tu seebal ac ch'ani a winiqui. ");
INSERT INTO mopNT_vpl VALUES ("MT8_4","070_8_4","MAT","8","4","4","—U'yeen. Ma' a wadic ti'i ma'ax mac c'u' a mani teche,— cu t'an a Jesus ti'iji. —Jadi' ca' xiquech etel u yaj mansaj t'an a cristiano ti'i a Dioso. Ye'e a bajil ti'i, y tz'a ti'i a Dios a sij-ool jabix ilic ti tz'iiba'an ichil a ley u tz'iibtaj aj Moisese. Te'i u yilicoo' ti ch'aneech,— cu t'an a Jesusu. ");
INSERT INTO mopNT_vpl VALUES ("MT8_5","070_8_5","MAT","8","5","5","Pues te'i. Le'ec ti tan u yoc'ol a Jesus ich caj Capernaum, naatz'i jun tuul u noochiloo' a soldado tu tzeel. U c'aataj ti'i a Jesusu. ");
INSERT INTO mopNT_vpl VALUES ("MT8_6","070_8_6","MAT","8","6","6","—Noochil, coya'an ti que'en in waj meyaj ich naj. Sotmen u büq'uel. Top tan u yubic u yajil,— cu t'an ti'i a Jesusu. ");
INSERT INTO mopNT_vpl VALUES ("MT8_7","070_8_7","MAT","8","7","7","—Jede'ec in beel in ch'anese,— cu t'an a Jesus ti'iji. ");
INSERT INTO mopNT_vpl VALUES ("MT8_8","070_8_8","MAT","8","8","8","C'u' betiqui, baala' u yadaj u noochiloo' a soldadojo. —Noochil, ma' chucul in yanil ti'i ca' xiquech ichil in wotoch. Chucul ca' a tz'aa' a t'an, y bel u ca'a ti ch'anül in waj meyaj,— cu t'an ti'i a Jesusu. ");
INSERT INTO mopNT_vpl VALUES ("MT8_9","070_8_9","MAT","8","9","9","—Yan ilic in noochil mac walac u tücaa'tiquen. Yanoo' ilic a soldado a walac in tücaa'tiqui. Walac in wadic ti'i a jun tuul ca' xi'ic, y walac u beel. Walac in wadic ti'i ulaac' a jun tuul ca' talac, y walac u talel. Walac in wadic ti'i in waj meyaj ca' u bete' a c'u' taca, y walac u betic,— cu t'an u noochiloo' a soldadojo. ");
INSERT INTO mopNT_vpl VALUES ("MT8_10","070_8_10","MAT","8","10","10","Le'ec ti ca' u yubaj abe' a Jesusu, sa'ti u yool. U yadaj ti'ijoo' a cristiano a que'en tu pacha: —Tan in wadic te'ex u jajil. Yanoo' in wetcaal a yanoo' u yool tin pacha. C'u' betiqui, ma'ax tuba cuenta Israel in cüxtaj jun tuul ti wetcaal a top que'en u yool tin pach tu jajil jabix a soldado abe'e,— cu t'an a Jesus ti'ijoo' a cristianojo. ");
INSERT INTO mopNT_vpl VALUES ("MT8_11","070_8_11","MAT","8","11","11","—Tan in wadic te'ex. Yanoo' xan a watacoo' joq'ueeb q'uin oqueeb q'uin a beloo' u ca'a pach mesa ti janal u yet'ocoo' aj Abraham, aj Isaac, aj Jacob tu cuenta a Dioso,— cu t'an a Jesusu. ");
INSERT INTO mopNT_vpl VALUES ("MT8_12","070_8_12","MAT","8","12","12","—C'u' betiqui, yaaboo' aj Israel a ocoloo' u ca'a cuchi pero ma'. Beloo' u ca'a pulbul ich ac'ü'il. Te'i u yoc'oloo' u jürütlemacoo' xan u coj u men u yajil,— cu t'an a Jesusu. ");
INSERT INTO mopNT_vpl VALUES ("MT8_13","070_8_13","MAT","8","13","13","—Ca' xiquech ta wotoch. Ch'ani a waj meyaj u men a tz'ocsaj ti patalen in ch'anes,— cu t'an a Jesus ti'i u noochiloo' a soldadojo. Le'ec ti ca' u yadaj abe' a Jesusu, ch'ani aj meyaj abe'e. ");
INSERT INTO mopNT_vpl VALUES ("MT8_14","070_8_14","MAT","8","14","14","Pues te'i. Oqui a Jesus ichil u yotoch aj Pedrojo. U yilaj u yixa'an aj Pedro te'i. Que'en ti cama u men c'oja'an. Tan u chücüwil. ");
INSERT INTO mopNT_vpl VALUES ("MT8_15","070_8_15","MAT","8","15","15","U tülaj u c'ü' a nooch'upu. Mani u chücüwil. Liq'ui a nooch'upu. U tz'ajoo' u janal u yaj sutiloo'. ");
INSERT INTO mopNT_vpl VALUES ("MT8_16","070_8_16","MAT","8","16","16","Pues te'i. Le'ec ti oqui a q'uini, c'ochesaboo' etel a Jesus yaab tuul a yan a c'ac'asba'al tu yooloo'. A Jesusu, chen etel u t'an u joc'sajoo' a c'ac'asba'al tu yooloo'. U ch'anesajoo' ilic boon tuul a c'oja'ana. ");
INSERT INTO mopNT_vpl VALUES ("MT8_17","070_8_17","MAT","8","17","17","Baalo' ti jajaji u t'an aj Isaiasa, le'ec jun tuul u yadaj u t'an a Dios uchi. —U tz'aj u muc' ti q'uiq'uel. U ch'anesaj ti c'oja'anil,— cu t'an aj Isaias biq'uin ado'o. ");
INSERT INTO mopNT_vpl VALUES ("MT8_18","070_8_18","MAT","8","18","18","Pues te'i. Le'ec a Jesusu, u yilaj ti top yaab a cristiano a much'a'anoo' tu tzeel. —Co'ne'ex junxeel a lagunaja,— cu t'an ti'ijoo' u yaj cambal. ");
INSERT INTO mopNT_vpl VALUES ("MT8_19","070_8_19","MAT","8","19","19","Naatz'i tu tzeel a Jesus jun tuul u yaj ca'ansajil u ley aj Moisese. —Maestro, le'ec a tuba ca' xiqueche, bel in ca'a ta pach,— cu t'an ti'i a Jesusu. ");
INSERT INTO mopNT_vpl VALUES ("MT8_20","070_8_20","MAT","8","20","20","—Le'ec a ch'umaca, yan u ch'e'en. Le'ec a ch'iich'i, yan u c'u'. C'u' betic inen a yanajeen ti cristianojili, ma' yan ten ti baalo'. Ma' yan ma'ax tuba u paatal in coytal ti jedel,— cu t'an a Jesus ti'i a winic abe'e. ");
INSERT INTO mopNT_vpl VALUES ("MT8_21","070_8_21","MAT","8","21","21","—Noochil, se' chaa' in beel tin wotoch. Quimic to in tata, ca' talaquen ta pach,— cu t'an ulaac' a jun tuul u yaj tz'ocsaj t'an ti'i a Jesusu. ");
INSERT INTO mopNT_vpl VALUES ("MT8_22","070_8_22","MAT","8","22","22","—Co'ox tin pach incheche. Le'ec a ma' ta'achoo' u c'ajsic a Dioso, jabix quimenoo' ti'i a Dioso. Mas toj u muquicoo' a chucul quimene,— cu t'an a Jesus ti'i ti uchi u nuuc. ");
INSERT INTO mopNT_vpl VALUES ("MT8_23","070_8_23","MAT","8","23","23","Pues te'i. Oqui a Jesus ichil a barco u yet'ocoo' u yaj cambal. ");
INSERT INTO mopNT_vpl VALUES ("MT8_24","070_8_24","MAT","8","24","24","Caji a ic' a top chich ti'ijoo' taan a lagunaja. Top tz'iic a ja'a. Caji ti tudel a barcojo. Le'ec a Jesusu, tan u wüyül. ");
INSERT INTO mopNT_vpl VALUES ("MT8_25","070_8_25","MAT","8","25","25","Le'ecoo' u yaj cambala, u yajsajoo' a Jesusu. —Noochil, sa'alto'on. Tan u budel a barcojo,— cu t'anoo' ti'i a Jesusu. ");
INSERT INTO mopNT_vpl VALUES ("MT8_26","070_8_26","MAT","8","26","26","—¿C'u' ca'a saaque'ex? Top ma' que'ene'ex a wool tu pach Dios tu jajil,— cu t'an a Jesus ti'ijoo'o. Liq'ui a Jesusu. U yadaj ti'i a ic' y a ja' ca' jetz'lac. Mani a ic' a chichi. Jetz'laji a ja'a. Quich'pan ti p'aati. ");
INSERT INTO mopNT_vpl VALUES ("MT8_27","070_8_27","MAT","8","27","27","Sa'too' u yool u yaj cambal u men c'u' a maniji. —¿C'u' ti winiquil a jabix ada'a? Ca'ax ic' ca'ax ja', walac u tz'ocsabül ala'aji,— cu t'anoo' tu bajil. ");
INSERT INTO mopNT_vpl VALUES ("MT8_28","070_8_28","MAT","8","28","28","Pues te'i. Le'ec ti c'ochi a Jesus junxeel a laguna tu cuenta Gadaraja, joc'oo' ca' tuul a winic tuba walacoo' u mucbul a quimene. Que'en a c'ac'asba'al tu yooloo'. Ma'ax mac patal u manül te'i u menoo' u tz'iiquil. Binoo' u c'ümü' a Jesusu. ");
INSERT INTO mopNT_vpl VALUES ("MT8_29","070_8_29","MAT","8","29","29","—¿C'u' a t'an to'on? Inchech u Mejen a Dioso. ¿Taleech wa a tz'aa' to'on a yaj ti ma'ax to c'ochoc u q'uinili?— cu t'anoo' ti'i a Jesus ti chichi. ");
INSERT INTO mopNT_vpl VALUES ("MT8_30","070_8_30","MAT","8","30","30","Ma' top naach te'i que'enoo' ti yaab a eq'uen a tanoo' u janal. ");
INSERT INTO mopNT_vpl VALUES ("MT8_31","070_8_31","MAT","8","31","31","—Wa ca' a joc'so'on wa'ye'e, tücaa'to'on tu yaamoo' a eq'uen ado'o,— cu t'anoo' a c'ac'asba'al ti'i a Jesusu. ");
INSERT INTO mopNT_vpl VALUES ("MT8_32","070_8_32","MAT","8","32","32","—Ca' xique'ex,— cu t'an a Jesus ti'ijoo' a c'ac'asba'ala. Joc'oo' a c'ac'asba'al tu yool a ca' tuul a winic abe'e. Binoo' yaam a eq'uene. Tu seebal joc'oo' ti alca' ti chich a eq'uene. Emoo' tuba c'üs toj wa'an a witzi. Ocoo' ichil a ja'a. Quimoo' ichil a ja'a. ");
INSERT INTO mopNT_vpl VALUES ("MT8_33","070_8_33","MAT","8","33","33","Pues te'i. Joc'oo' ti alca' ti chich u yaj cananiloo' a eq'uene. Ocoo' ich caj. U yadajoo' tulacal a c'u' a maniji. U yadajoo' u pectzil le'ec a c'u' a mani ti'ijoo' a yan a c'ac'asba'al tu yooloo'. ");
INSERT INTO mopNT_vpl VALUES ("MT8_34","070_8_34","MAT","8","34","34","Tulacal a mac ichil a caj abe'e, binoo' u yila' a Jesusu. Le'ec ca' u yilajoo' ala'aji, u yadajoo' ti'i ca' joc'oc. ");
INSERT INTO mopNT_vpl VALUES ("MT9_1","070_9_1","MAT","9","1","1","Pues te'i. Ca' oqui a Jesus ich barco. Ca' bini junxeel a lagunaja. Ca' c'ochi ich caj Capernaum tuba walac u cuntal. ");
INSERT INTO mopNT_vpl VALUES ("MT9_2","070_9_2","MAT","9","2","2","C'ochesabi a jun tuul u menoo' a winiqui. Sotmen u büq'uel. Ma' ta'ach u peec. Coya'an ti que'en tuwich u coytaan. Chica'an ti'i a Jesus ti tanoo' u tz'ocsic ti patal u ch'anes a sotmen u büq'uele. —Qui'ac a wool. Sa'tesabi a sip'il,— cu t'an a Jesus ti'i a c'oja'ana. ");
INSERT INTO mopNT_vpl VALUES ("MT9_3","070_9_3","MAT","9","3","3","Yanoo' u yaj ca'ansajil u ley aj Moises te'i. —A winic ada'a, tan u yadic ti sa'tesabi u sip'il a maca. Tan u maclant'antic a Dios ti baalo',— cu t'anoo' ala'oo' tu bajil yoc'ol a Jesusu. ");
INSERT INTO mopNT_vpl VALUES ("MT9_4","070_9_4","MAT","9","4","4","Le'ec a Jesusu, u yeel c'u' a tanoo' u tucliqui. —¿C'u' ca'a tane'ex a tuclic a c'as tin woc'ol?— cu t'an a Jesus ti'ijoo'o. ");
INSERT INTO mopNT_vpl VALUES ("MT9_5","070_9_5","MAT","9","5","5","—Ma' yaj ca' in wadü' ti sa'tesabi u sip'ili, u men ma' chica'an wa jaj in t'an. C'u' betiqui, yaj ca' in wadü': “Liq'uen. Uchuc a ximbal,” u men te'i u chictal wa jaj in t'an,— cu t'an a Jesusu. ");
INSERT INTO mopNT_vpl VALUES ("MT9_6","070_9_6","MAT","9","6","6","—Inene, yanajeen ti cristianojil. Ti'i ca' a weelte'ex ti yan in yanil in sa'tes sip'il wa'ye' yoc'olcab, bel in quin ch'anes a c'oja'ana,— cu t'an a Jesus ti'ijoo'o. —Wa'len. Molo a coytaan. Ca' xiquech ta wotoch,— cu t'an a Jesus ti'i a winic a sotmen u büq'uele. ");
INSERT INTO mopNT_vpl VALUES ("MT9_7","070_9_7","MAT","9","7","7","Wa'laji a winic abe'e. Bini tu yotoch. ");
INSERT INTO mopNT_vpl VALUES ("MT9_8","070_9_8","MAT","9","8","8","Le'ec u yaabil a cristiano a que'en te'iji, le'ec ca' u yilaj u yuchul a baalo'o, sa'too' u yool. U yadajoo' u qui'il a Dios u men le'ec a Dioso, u tz'aj u yanil jun tuul winic ca' u bete' ti baalo'. ");
INSERT INTO mopNT_vpl VALUES ("MT9_9","070_9_9","MAT","9","9","9","Pues te'i. Le'ec ti tan u mas beel a Jesusu, u yilaj jun tuul a winiqui, aj Mateo u c'aba'. Tina'an ti que'en ala'i tu cuuchil tuba walac u molic a taq'uin ti'i a gobiernojo. —Co'ox tin pach,— cu t'an a Jesus ti'iji. Liq'ui. Bini tu pach a Jesusu. ");
INSERT INTO mopNT_vpl VALUES ("MT9_10","070_9_10","MAT","9","10","10","Pues te'i. Le'ec a Jesus u yet'ocoo' u yaj cambala, que'enoo' pach mesa ti janal ichil u yotoch aj Mateojo. C'ochoo' ti yaab a yanoo' u yanil ti mol taq'uin ti'i a gobierno u yet'ocoo' a yanoo' u sip'ili. C'ochoo' ilic pach mesa etel a Jesus ti janal. ");
INSERT INTO mopNT_vpl VALUES ("MT9_11","070_9_11","MAT","9","11","11","Le'ecoo' a fariseo u c'aba'oo' u na'ata, u yilajoo' ti tina'an a Jesus tu yaamoo' ala'oo'o. —¿C'u' ca'a que'en ti janal a maestroje'ex tu yaamoo' a yanoo' u yanil ti mol taq'uin ti'i a gobierno u yet'ocoo' a yanoo' u sip'ili?— cu t'anoo' ti'i u yaj cambal a Jesusu. ");
INSERT INTO mopNT_vpl VALUES ("MT9_12","070_9_12","MAT","9","12","12","Le'ec a Jesusu, u yubajoo' u t'an. U nuuctajoo'. —Ma' c'abeet aj tzücyaj ti'ijoo' a muc'a'ana, pero c'abeet ti'ijoo' a c'oja'ana,— cu t'an a Jesus ti'ijoo' a fariseo u c'aba'oo' u na'ata. ");
INSERT INTO mopNT_vpl VALUES ("MT9_13","070_9_13","MAT","9","13","13","—Ca' xique'ex a cünü' u nu'cul a t'an ada'a. “Mas qui' tin wich a ch'a'ique'ex u yotzilil a maca, tuwich ca' a tz'a'e'ex ten a sij-oolo,” cu t'an a Dioso,— cu t'an a Jesusu. —Ma' taleen ti'i ca' in wadü' ti'ijoo' a cristiano a tojoo' u na'at ca' u jeloo' u tucul ca' tun u tucloo' a tojo. Taleen ti'i ca' in wadü' abe' ti'ijoo' a yanoo' u sip'ili,— cu t'an a Jesus ti'ijoo'o. ");
INSERT INTO mopNT_vpl VALUES ("MT9_14","070_9_14","MAT","9","14","14","Pues te'i. C'ochoo' u yaj cambal aj Juan aj tz'aj ocja' etel a Jesusu. —Ino'ono, yaab sut ti walac ti p'ütic a janal ti'i ti suq'uin. Baalo' ilic a walacoo' u betic a fariseo u c'aba'oo' u na'ata. ¿C'u' ca'a ma' ta'achoo' u suq'uin a waj cambal?— cu t'anoo' ti'i a Jesusu. ");
INSERT INTO mopNT_vpl VALUES ("MT9_15","070_9_15","MAT","9","15","15","—Le'ec ti que'en to a winic a tz'oqui u beel tu yaamoo' u yaj sutili, ¿jede'ecoo' wa u p'aatül ti yajoo' u yool aj sutili? C'ochol u ca'a u q'uinil le'ec ti bel u ca'a joc'sabül a winic a tz'oqui u beel tu yaamoo'o. Ti a q'uin abe'e, beloo' u ca'a ti suq'uin u men joc'sabi ala'aji,— cu t'an a Jesus ti'ijoo'o. ");
INSERT INTO mopNT_vpl VALUES ("MT9_16","070_9_16","MAT","9","16","16","—Pues te'i. Ma'ax mac walac u püc'ültic a uchben noc' etel a tumul noc'o. A tumul noc'o, walac u coomtal ta wichi. Wa cuchi ca' u betoo' ti baalo', bel u cu tzili' a uchben a tumulbene. P'aatül u ca'a ti mas nooch u tzililal a uchbene,— cu t'an a Jesusu. ");
INSERT INTO mopNT_vpl VALUES ("MT9_17","070_9_17","MAT","9","17","17","—Ma'ax walac u tz'abül tumul vino ichil u cuuchil a betabi etel uchben q'uewel. Walac u betabaanül u bolsajil vino etel q'uewel. Wa cuchi ca' tz'abüc ti baalo', tanil u sip'il a tumul vinojo, bel u ca'a ti jeetel a uchben q'uewele. Tooxol u ca'a cuchi a vinojo, y c'astal u ca'a cuchi a q'uewele. Yan u tz'abül a tumul vino ichil u cuuchil a betabi etel tumul q'uewel. Ti baalo'o, ma' tu jeetel a q'uewele. Ma'ax tu tooxol a vinojo,— cu t'an a Jesus ich mucult'an. ");
INSERT INTO mopNT_vpl VALUES ("MT9_18","070_9_18","MAT","9","18","18","Pues te'i. Tan to u t'an a Jesus ti c'ochi jun tuul a winic a nooch u wichil u meyaj. Xonlaji tu taan. —Le'ec in wix chu'u, quimi to. C'u' betiqui, ca' talaquech tin wetel. Tz'a a c'ü' yoc'ol y bel u ca'a ti cuxtal,— cu t'an a winic ti'i a Jesusu. ");
INSERT INTO mopNT_vpl VALUES ("MT9_19","070_9_19","MAT","9","19","19","Wa'laji a Jesusu. Caji ti beel tu pach a winic u yet'ocoo' u yaj cambal. ");
INSERT INTO mopNT_vpl VALUES ("MT9_20","070_9_20","MAT","9","20","20","Pues te'i. Jun tuul ix ch'upu, tan ti tan u joc'ol u q'uiq'uel le'ec u uju. Doce jaab tan ti tan ti'i. Naatz'i tu pach a Jesusu. U tülaj u chi' u noc' a Jesusu. ");
INSERT INTO mopNT_vpl VALUES ("MT9_21","070_9_21","MAT","9","21","21","U betaj abe'e, u men u tuclaj ti jadi' yan u tülic u chi' u noc' a Jesus ti'i ca' ch'anüc. ");
INSERT INTO mopNT_vpl VALUES ("MT9_22","070_9_22","MAT","9","22","22","U sutaj u bajil a Jesusu. Le'ec ca' u yilaj a nooch'upu, u yadaj ti'i: —Qui'ac a wool, nooch'up. A tz'ocsaj ti patalen in ch'aneseech, mentücü, ch'aneech tun,— cu t'an a Jesus ti'iji. Tu seebal ch'ani a nooch'upu. ");
INSERT INTO mopNT_vpl VALUES ("MT9_23","070_9_23","MAT","9","23","23","Pues te'i. C'ochi a Jesus tu yotoch a winic a nooch u wichil u meyaja. U yilajoo' a tanoo' u yuustic a xoolo. U yilajoo' ilic a tanoo' u choconaquil yoc'lal a quimene. ");
INSERT INTO mopNT_vpl VALUES ("MT9_24","070_9_24","MAT","9","24","24","—Joq'uene'ex. Ma' quimen ix chu'i. Chen tan u wüyül,— cu t'an a Jesus ti'ijoo'o. U che'ejtajoo' a Jesusu. ");
INSERT INTO mopNT_vpl VALUES ("MT9_25","070_9_25","MAT","9","25","25","Le'ec ti joc'saboo' ich naj, oqui a Jesusu. U müchaj u c'ü' ix chu'u. Liq'ui ix chu'u. ");
INSERT INTO mopNT_vpl VALUES ("MT9_26","070_9_26","MAT","9","26","26","T'iit'i u pectzil tulacal tuba te'i yoc'ol tulacal a c'u' a maniji. ");
INSERT INTO mopNT_vpl VALUES ("MT9_27","070_9_27","MAT","9","27","27","Pues te'i. Joq'ui a Jesusu. Tan u ca' beel. Yan ca' tuul a ch'oopo, tücünacoo' tu pach a Jesusu. —Inchech u mamech aj quimen rey David a tan u paac'baanülü. Ch'a'a ti wotzilil,— cu t'an a ch'oop a ca' tuul ti chich ti'i a Jesusu. Tan ti tanoo' u yadic ti tanoo' u beel. ");
INSERT INTO mopNT_vpl VALUES ("MT9_28","070_9_28","MAT","9","28","28","Le'ec ti oqui ich naj a Jesusu, c'ochoo' a ch'oop abe' etele. —¿Tane'ex wa a tz'ocsic ti jede'ec ilic u paatal in betic a c'u' a tane'ex a c'aatiqui?— cu t'an a Jesus ti'ijoo'o. —Tan, Noochil,— cu t'anoo' ti'i. ");
INSERT INTO mopNT_vpl VALUES ("MT9_29","070_9_29","MAT","9","29","29","Pues te'i. U tülajoo' u wich. —Ch'ane'ex u men a tz'ocsaje'ex ti patalen in ch'anese'ex,— cu t'an a Jesus ti'i a ca' tuulu. ");
INSERT INTO mopNT_vpl VALUES ("MT9_30","070_9_30","MAT","9","30","30","Sasilaji u wich a ca' tuulu. —Ma' a cha'ique'ex u yeeltabül jumpul c'u' a mani te'exe,— cu t'an a Jesus ti'ijoo' a ca' tuulu. ");
INSERT INTO mopNT_vpl VALUES ("MT9_31","070_9_31","MAT","9","31","31","C'u' betiqui, le'ec ti joc'oo' te'i, u yadajoo' ilic u pectzil tulacal tubajac te'i yoc'ol c'u' u betaj a Jesus ti'ijoo'o. ");
INSERT INTO mopNT_vpl VALUES ("MT9_32","070_9_32","MAT","9","32","32","Pues te'i. Le'ec ti tanoo' to u joc'ol a ca' tuulu, c'ochesabi jun tuul a ma' ta'ach u t'an a yan a c'ac'asba'al tu yoolo. ");
INSERT INTO mopNT_vpl VALUES ("MT9_33","070_9_33","MAT","9","33","33","Le'ec ti joc'sabi a c'ac'asba'al tu yool a ma' ta'ach u t'ana, caji ti t'an. Sa'too' u yool u yaabil a cristiano a que'enoo' te'iji. —Ma'ax jun sut ilbic u yuchul a jabix ada' cuenta Israel,— cu t'anoo'. ");
INSERT INTO mopNT_vpl VALUES ("MT9_34","070_9_34","MAT","9","34","34","—Chen u men yan u muc' u noochiloo' a c'ac'asba'al etel a Jesusu, patal u joq'uesoo' a c'ac'asba'ala,— cu t'anoo' a fariseo u c'aba'oo' u na'ata. ");
INSERT INTO mopNT_vpl VALUES ("MT9_35","070_9_35","MAT","9","35","35","Pues te'i. Mani a Jesus ichil tulacal a boon a caj a aldea a yan te'iji. U ca'ansajoo' a cristiano ichil boon a naj tuba walacoo' u much'tal u c'ajes a Dioso. U yadaj ti'ijoo' u pectzil yoc'ol biqui ti walac u tücaa' a Dioso. U ch'anesaj ilic tulacal a boon p'eel u wich a c'oja'anil a yana. ");
INSERT INTO mopNT_vpl VALUES ("MT9_36","070_9_36","MAT","9","36","36","Le'ec ca' u yilajoo' u yaabil a cristiano a Jesusu, otziloo' tu wich u men ma' jetz'a'anoo' u yool y ma' pataloo' u yaante u bajil. Ala'oo'o, jabixoo' a carnero a ma' yanoo' u yaj cananili. ");
INSERT INTO mopNT_vpl VALUES ("MT9_37","070_9_37","MAT","9","37","37","Le'ec ca' u yilajoo' a cristiano ti baalo'o, u yadaj a mucult'an ada' ti'ijoo' u yaj cambal. —Top nooch a colo, y qui' tun u jochbol. C'u' betiqui, top ma' yanoo' aj jocho, ");
INSERT INTO mopNT_vpl VALUES ("MT9_38","070_9_38","MAT","9","38","38","mentücü, c'aate'ex ti'i u yumul a col ca' u tücaa'too' ti mas yaab aj joch ti'i u jochical a colo,— cu t'an a Jesus yoc'ol ca' aalbüc u pectzil a Dioso. ");
INSERT INTO mopNT_vpl VALUES ("MT10_1","070_10_1","MAT","10","1","1","Pues te'i. Le'ec a Jesusu, u püyaj a doce tuul u yaj cambal tu tzeel. U tz'aj ti'ijoo' u muq'uil ti'i u joc'sicoo' a c'ac'asba'al tu yool a maca. U tz'aj ilic ti'ijoo' u muq'uil ti'i u ch'anesic tulacal a boon p'eel u wich a c'oja'anili. ");
INSERT INTO mopNT_vpl VALUES ("MT10_2","070_10_2","MAT","10","2","2","Le'ec ada' u c'aba' a doce tuul u yaj cambal a Jesusu. Le'ec a jun tuulu, Simon u c'aba'. —Pedro,— cu t'anoo' ti'i. Ulaac' a jun tuulu, Andres u c'aba'. U sucu'un u yitz'inoo' u bajil etel aj Pedrojo. Ulaac'a, aj Jacob etel aj Juan. U sucu'un u yitz'inoo' xan u bajil. Zebedeo u c'aba'oo' u tat. ");
INSERT INTO mopNT_vpl VALUES ("MT10_3","070_10_3","MAT","10","3","3","Ulaac'oo'o, aj Felipe, aj Bartolome y aj Tomas. Ulaac'a, aj Mateo u c'aba'. Yan u yanil ti mol taq'uin ti'i a gobiernojo. Ulaac'a, Jacob u c'aba', le'ec u mejen aj Alfeo. Ulaac'a, Lebeo u c'aba'. —Tadeo,— cu t'anoo' ti'i. ");
INSERT INTO mopNT_vpl VALUES ("MT10_4","070_10_4","MAT","10","4","4","Ulaac'a, Simon u c'aba'. Politico ala'aji. Cananista u c'aba' a jun muuch' abe'e. Ulaac'a, Judas Iscariote u c'aba'. Le'ec ilic ala'aji, u tzolaj a Jesusu. ");
INSERT INTO mopNT_vpl VALUES ("MT10_5","070_10_5","MAT","10","5","5","Pues te'i. Le'ec a doce tuul abe'e, bel u ca'a tücaa'büloo' u men a Jesusu. —Ma' a beele'ex tu yaamoo' a ma' Israele,— cu t'an ti'ijoo'. —Ma' a wocole'ex ichil boon u caal aj Samariajil. ");
INSERT INTO mopNT_vpl VALUES ("MT10_6","070_10_6","MAT","10","6","6","Jadi' ca' xique'ex eteloo' ti wetcaal aj Israele. Sa'too' ala'oo' jabix a carnero a sa'tala,— cu t'an a Jesusu. ");
INSERT INTO mopNT_vpl VALUES ("MT10_7","070_10_7","MAT","10","7","7","—Le'ec ti tane'ex a manülü, ade'ex ti'ijoo' u pectzil a Dioso. “C'ochi u yorajil u tücaa' a Dioso,” que'exac ti'ijoo',— cu t'an a Jesusu. ");
INSERT INTO mopNT_vpl VALUES ("MT10_8","070_10_8","MAT","10","8","8","—Ch'anese'exoo' a c'oja'ana. Ca' a cuxquinte'exoo' a quimene. Ch'anese'exoo' a tan u tu'ujtal u büq'uel u men u c'oja'anili. Joq'uese'exoo' a c'ac'asba'al tu yool a maca. Ma'ax boon u tool ti tz'abi te'ex a muc'. Ma'ax boon u tool xan ti bele'ex a ca'a ti tz'ücyaj,— cu t'an a Jesus ti'ijoo' a doce tuulu. ");
INSERT INTO mopNT_vpl VALUES ("MT10_9","070_10_9","MAT","10","9","9","—Ma' a bensique'ex a taq'uini. ");
INSERT INTO mopNT_vpl VALUES ("MT10_10","070_10_10","MAT","10","10","10","Ma' a bensique'ex a salbec ti tane'ex a beele. Ma'ax a bensique'ex ulaac' a noc'. Ma'ax a bensique'ex ulaac' a zapato. Ma'ax a bensique'ex a xoolte' u men le'ec mac a tan u meyaja, yan u c'ümic u naal,— cu t'an a Jesusu. ");
INSERT INTO mopNT_vpl VALUES ("MT10_11","070_10_11","MAT","10","11","11","—Le'ec ca' ocoque'ex ich caj wa ich aldeaja, cüxte'ex mac a qui' u na'ata. Te'i a posadoje'ex etele. Te'i a cuntale'ex asto u jobol a meyaje'ex ichil a caj abe'e,— cu t'an a Jesusu. ");
INSERT INTO mopNT_vpl VALUES ("MT10_12","070_10_12","MAT","10","12","12","—Le'ec ti ocoque'ex ichil a naja, qui'qui't'ante'ex. ");
INSERT INTO mopNT_vpl VALUES ("MT10_13","070_10_13","MAT","10","13","13","Wa qui' a posadoje'ex etele, te'i u yantal a qui' a c'aataje'ex yoc'ol. Wa ma'a, ma' tu cuntal a qui' a c'aataje'ex yoc'oloo' te'iji. Jadi' ta wetele'ex u cuntal,— cu t'an a Jesusu. ");
INSERT INTO mopNT_vpl VALUES ("MT10_14","070_10_14","MAT","10","14","14","—Uchac yan a ma' tu c'ümique'ex ma'ax tu yubique'ex a t'an. Le'ec ti tane'ex a joc'ol ichil a naj abe'e, wa ichil a caj abe'e, liijte'ex u ta'lu'umil a woc ca' c'axüc ti'i u p'isoo',— cu t'an a Jesus ti'ijoo' u yaj cambal. ");
INSERT INTO mopNT_vpl VALUES ("MT10_15","070_10_15","MAT","10","15","15","—Tan in wadic te'ex u jajil. Le'ec ca' c'ochoc u q'uinil u tz'abül a sip'ili, mas yaj ti bel u ca'a tz'abüloo' u sip'il ichil a caj abe'e, tuwich ti bel u ca'a tz'abüloo' u sip'il a c'ac'as cristiano ichil a uchben caj Sodoma etel a caj Gomorraja,— cu t'an a Jesusu. ");
INSERT INTO mopNT_vpl VALUES ("MT10_16","070_10_16","MAT","10","16","16","—Pues te'i. Tan in tücaa'tique'ex tu yaamoo' a ma' u yeeloo' a Dios jabix cuchi tan in tücaa'tic a carnero tu yaamoo' a baalumu. U men tan in tücaa'tique'ex ti baalo'o, yane'ex a cuntal ti seebe'ex a wool jabix a cana. Yan ilic a cuntale'ex ti ma' ta yajcuntique'ex a ma'ax c'u'i jabix ilic a palomaja,— cu t'an a Jesusu. ");
INSERT INTO mopNT_vpl VALUES ("MT10_17","070_10_17","MAT","10","17","17","—Cününte'ex a bajil. Bele'ex a ca'a c'ubbul ti'ijoo' a noochoo' u wichil u meyaj u men tane'ex a tz'ocsiquen. Beloo' u cu jütz'e'ex etel jatz' ichil boon a naj tuba walacoo' u much'tal u c'ajes a Dioso,— cu t'an a Jesusu. ");
INSERT INTO mopNT_vpl VALUES ("MT10_18","070_10_18","MAT","10","18","18","—Bele'ex a ca'a bensabül tu taan a gobernador y tu taan a rey chen u men tane'ex a tz'ocsiquen. Bele'ex a ca'a a wadü' in t'an ti'ijoo' y ti'ijoo' a ma' Israele,— cu t'an a Jesusu. ");
INSERT INTO mopNT_vpl VALUES ("MT10_19","070_10_19","MAT","10","19","19","—Le'ec ti tane'ex a c'ubbul ti'ijoo'o, ma' a top tuclique'ex c'u' a bele'ex a ca'a a wadü' wa biqui ca' a wade'ex. Bel u ca'a tz'abül te'ex c'u' a bele'ex a ca'a a wadü' le'ec ti que'ene'ex tu taanoo',— cu t'an a Jesus ti'ijoo'o. ");
INSERT INTO mopNT_vpl VALUES ("MT10_20","070_10_20","MAT","10","20","20","—Ma' le'ec inche'ex a bele'ex a ca'a ti t'an chen ti baalo'i. Le'ec u Püsüc'al a Tate'ex ti ca'ana, le'ec a bel u cu tz'aa' te'ex c'u' a bele'ex a ca'a a wadü',— cu t'an a Jesusu. ");
INSERT INTO mopNT_vpl VALUES ("MT10_21","070_10_21","MAT","10","21","21","—Yan a winic a bel u cu c'ubu' u yitz'in wa u sucu'un ti'i ca' quimsabüc tin woc'lal. Yan ilic a tattzil a bel u cu c'ubu' u mejen ti'i ca' quimsabüc. Yan ilic a mejentzil a bel u cu tz'aa' ca' quimsabücoo' u na' u tat,— cu t'an a Jesusu. ");
INSERT INTO mopNT_vpl VALUES ("MT10_22","070_10_22","MAT","10","22","22","—Chen u men tene'exe, bele'ex a ca'a motzinbil u men tulacaloo'. Le'ec mac ca' u muc'yajte a yaj abe' tac tu jobeebe, bel u ca'a sa'albül,— cu t'an a Jesusu. ");
INSERT INTO mopNT_vpl VALUES ("MT10_23","070_10_23","MAT","10","23","23","—Le'ec ti tanoo' u tz'eec te'ex a yaja, puutz'ene'ex cajil caj. Tan in wadic te'ex u jajil. Ma'ax to laj manüque'ex ichil tulacal a boon a caj cuenta Israel ti ca' uduquen inen a yanajeen ti cristianojil,— cu t'an a Jesusu. ");
INSERT INTO mopNT_vpl VALUES ("MT10_24","070_10_24","MAT","10","24","24","—Le'ec aj cambala, ma' mas yaab u yeel tuwich u maestroji. Ma'ax aj q'uexbil mozojo, ma' tu mansic u yumil,— cu t'an a Jesusu. ");
INSERT INTO mopNT_vpl VALUES ("MT10_25","070_10_25","MAT","10","25","25","—Le'ec aj cambala, jadi' u paatal ti quettal u yeel etel u maestro. Baalo' ilic aj q'uexbil mozojo, ma' tu c'ümic a mas qui' tuwich u yumili. Inen jabix jun tuul a tattzili. Inche'exe, jabixe'ex in mejen. Wa aalbi ti inen u noochiloo' a c'ac'asba'ala, mas jede'eque'ex a maclant'anbül u men inche'ex in wet'oc,— cu t'an a Jesusu. ");
INSERT INTO mopNT_vpl VALUES ("MT10_26","070_10_26","MAT","10","26","26","—Pues te'i. Ma' a saactique'exoo' a beloo' u cu tz'aa' te'ex a yaj u men ma' yan c'u' a muca'an a ma' tu chictal. Ma'ax c'u' a betabi ich mucul wa ma' tu yeeltabül,— cu t'an a Jesusu. ");
INSERT INTO mopNT_vpl VALUES ("MT10_27","070_10_27","MAT","10","27","27","—Le'ec c'u' a tan in wadic te'ex ich muculu, ca' a wade'ex ti chica'an. Le'ec c'u' a tane'ex a wu'yic ich jabix jisilt'ana, ca' a wade'ex ti chich,— cu t'an a Jesusu. ");
INSERT INTO mopNT_vpl VALUES ("MT10_28","070_10_28","MAT","10","28","28","—Ma' a saactale'ex ti'ijoo' a cristianojo. Ala'oo'o, jadi' u paataloo' u quimse'ex. Ma' tu paataloo' u quimse'ex a püsüc'al. Yan a saactique'ex a Dioso. Ala'aji, u paatal u pulique'ex a büq'uel a püsüc'al ichil a infierno etel a quisini,— cu t'an a Jesusu. ");
INSERT INTO mopNT_vpl VALUES ("MT10_29","070_10_29","MAT","10","29","29","—Walac u conbol ca' tuul aj meen ch'iich' yoc'ol jun p'e centavo. C'u' betiqui, ma'ax jun tuul ch'iich' a jede'ec u quimil wa ma' u c'ati a Tate'ex ti ca'an,— cu t'an a Jesusu. ");
INSERT INTO mopNT_vpl VALUES ("MT10_30","070_10_30","MAT","10","30","31","—C'u' betiqui, mas c'atiintzile'ex tuwich aj meen ch'iich' a yaaba, asto boon xiit a tzo'otzel a yan ta pole'exe, xoca'an xan, mentücü, ma' u jac'üle'ex a wool,— cu t'an a Jesusu. ");
INSERT INTO mopNT_vpl VALUES ("MT10_32","070_10_32","MAT","10","32","32","—Pues te'i. Tulacal a mac a walac u yadic tu taanoo' a cristiano ti u c'üm-ooltajene, bel ilic in quin wadü' ti'i in Tat ti ca'an ti u c'üm-ooltajene,— cu t'an a Jesusu. ");
INSERT INTO mopNT_vpl VALUES ("MT10_33","070_10_33","MAT","10","33","33","—Le'ec mac ca' u yadü' tu taanoo' a cristiano ti ma' u c'üm-ooltajene, bel ilic in quin wadü' ti'i in Tat ti ca'an ti ma' u c'üm-ooltajene,— cu t'an a Jesusu. ");
INSERT INTO mopNT_vpl VALUES ("MT10_34","070_10_34","MAT","10","34","34","—Pues te'i. Ma' a tuclique'ex wa taleen in tz'aa' ti qui'oo' tu bajil a cristiano yoc'olcabi. Ma' tu yantal a jetz'a'an-oolil tu bajiloo' yoc'olcab u men taleeni. Yantal u ca'a a p'isbaj u men taleen,— cu t'an a Jesusu. ");
INSERT INTO mopNT_vpl VALUES ("MT10_35","070_10_35","MAT","10","35","35","—U men taleene, ma' qui' a winic etel u tat, ma'ax ix ch'up etel u na', ma'ax le'ecoo' a üli'tzili,— cu t'an a Jesusu. ");
INSERT INTO mopNT_vpl VALUES ("MT10_36","070_10_36","MAT","10","36","36","—P'aatül u ca'a ti le'ec a mas tz'iic ti'i a maca, le'ec ilic u familia,— cu t'an a Jesusu. ");
INSERT INTO mopNT_vpl VALUES ("MT10_37","070_10_37","MAT","10","37","37","—Le'ec mac a yaj u yubi u na' u tat mas que inene, ma' yan biqui ca' u c'üm-oolteen tu jajil. Le'ec mac a yaj u yuboo' u mejen mas que inene, ma' yan biqui ca' u c'üm-oolteen tu jajil,— cu t'an a Jesusu. ");
INSERT INTO mopNT_vpl VALUES ("MT10_38","070_10_38","MAT","10","38","38","—Le'ec mac a ma' tu paatal u muc'yajte boon a yaj a tan u tz'abül ti'i u men tan u tz'ocsiquen jabix cuchi tan u bensic u cruz ti tan u beel tin pacha, ma' yan biqui ca' u c'üm-oolteen tu jajil,— cu t'an a Jesusu. ");
INSERT INTO mopNT_vpl VALUES ("MT10_39","070_10_39","MAT","10","39","39","—Le'ec mac a top que'en u yool tu pach u cuxtal yoc'olcaba, sa'tül u ca'a u cuxtal ti ca'an. Le'ec mac jabix ca' u p'ütü' u cuxtal yoc'olcab tanil u tz'ocsiquene, bel u cu cüxte u cuxtal ti ca'an,— cu t'an a Jesusu. ");
INSERT INTO mopNT_vpl VALUES ("MT10_40","070_10_40","MAT","10","40","40","—Pues te'i. Le'ec mac ca' u c'üme'ex a t'ana, tan ilic u c'ümiquen. Tanil u c'ümiquene, tan ilic u c'ümic mac u tücaa'tajen,— cu t'an a Jesus ti'ijoo' u yaj cambal. ");
INSERT INTO mopNT_vpl VALUES ("MT10_41","070_10_41","MAT","10","41","41","—Yan a tan u yadic u t'an a Dioso. Chen u men tan u yadic u t'an a Dioso, c'ümbi u men ulaac'. Le'ec mac u c'ümaja, bel u cu c'ümü' u naal ti quet etel a mac u yadaj u t'an a Dioso,— cu t'an a Jesusu. —Yan ulaac' a mac a toj u na'ata. Chen u men toj u na'ata, c'ümbi u men ulaac'. Le'ec mac u c'ümaja, bel u cu c'ümü' u naal ti quet etel a toj u na'ata,— cu t'an a Jesusu. ");
INSERT INTO mopNT_vpl VALUES ("MT10_42","070_10_42","MAT","10","42","42","—Yan ulaac' a mac u c'ümajen to. Chen u men in waj tz'ocsaj t'ana, aantabi jabix tz'abi ti'i jun p'e pote a siis ja'a. Tan in wadic te'ex u jajil. Le'ec mac u tz'aj ti'i a anat abe'e, bel u ca'a tz'abül u naal,— cu t'an a Jesusu. ");
INSERT INTO mopNT_vpl VALUES ("MT11_1","070_11_1","MAT","11","1","1","Pues te'i. Le'ec a Jesusu, jobi u yadic c'u' a yan u beticoo' a doce tuul u yaj cambala. U tücaa'tajoo' tuba u beeloo'. Joc'oo' te'i. Binoo'. Joq'ui ilic a Jesus te'i. Bini ti ca'ansaj y ti t'an ichil boon a caj a nütz'a'an te'i. ");
INSERT INTO mopNT_vpl VALUES ("MT11_2","070_11_2","MAT","11","2","2","Pues te'i. Le'ec aj Juan aj tz'aj ocja'a, que'en ti presojil. Le'ec ca' u yubaj c'u' a tan u betic a Cristo aj Juana, yan u yaj cambal u tücaa'tajoo' etel. ");
INSERT INTO mopNT_vpl VALUES ("MT11_3","070_11_3","MAT","11","3","3","—¿Inchech wa a mac a tan ti paac'tiqui, wa yan ti paac'tic ulaac'?— cu t'anoo' ti'i a Jesusu. ");
INSERT INTO mopNT_vpl VALUES ("MT11_4","070_11_4","MAT","11","4","4","—Ca' usc'aque'ex etel aj Juan. Ade'ex ti'i c'u' a tane'ex a wu'yic a wiliqui,— cu t'an a Jesus ti uchi u nuuc. ");
INSERT INTO mopNT_vpl VALUES ("MT11_5","070_11_5","MAT","11","5","5","—Tanoo' u sasilcunbul u wich a ch'oopo. Le'ecoo' a ma' qui'oo' u ximbala, tanoo' u ximbal tucaye'il. Tanoo' u ch'anesabül a tan u tu'ujtal u büq'uel u men u c'oja'anili. Tanoo' u jeebbel u xiquin a cooco. Tanoo' u ca' cuxtal a quimene. Tan u yaalbül u qui'il pectzil a Dios ti'ijoo' a otzili,— cu t'an a Jesus ti'ijoo' u yaj cambal aj Juana. ");
INSERT INTO mopNT_vpl VALUES ("MT11_6","070_11_6","MAT","11","6","6","—Qui' u yool mac a ma' siq'ui u yool tin wetel,— cu t'an a Jesus ti'ijoo'o. ");
INSERT INTO mopNT_vpl VALUES ("MT11_7","070_11_7","MAT","11","7","7","Pues te'i. Le'ec ti tanoo' u yusc'al tu pach u yaj xa'num aj Juana, caji a Jesus u tzicbalte aj Juan eteloo' a cristianojo. —¿C'u' a bine'ex a wila' ich p'atal lu'um? ¿Bine'ex wa a wila' a pocche' a tan u pecsabül u men ic'? Ma' bine'ex a wila' abe'e,— cu t'an a Jesusu. ");
INSERT INTO mopNT_vpl VALUES ("MT11_8","070_11_8","MAT","11","8","8","—¿C'u' a bine'ex a wila'? ¿Bine'ex wa a wila' a winic a top quich'pan u noc'o? Le'ecoo' a quich'pan u noc' a top qui' u cuxtaloo'o, que'enoo' ichil u yotoch a reye. Ma' ta wilique'exoo' ichil a p'atal lu'umu,— cu t'an a Jesus ti'ijoo' a cristianojo. ");
INSERT INTO mopNT_vpl VALUES ("MT11_9","070_11_9","MAT","11","9","9","—¿C'u' a bine'ex a wila'? ¿Bine'ex wa a wila' jun tuul a tan u yadic u t'an a Dioso? Le'ec, bine'ex a wila' jun tuul a tan u yadic u t'an a Dioso. Tan in wadic te'ex. Le'ec aj Juan abe'e, mas nooch u wichil u meyaj tuwich boon tuul u yadajoo' u t'an a Dios uchi,— cu t'an a Jesusu. ");
INSERT INTO mopNT_vpl VALUES ("MT11_10","070_11_10","MAT","11","10","10","—Baala' ti tz'iiba'an yoc'ol ala'aji,— cu t'an a Jesusu. —“Inene, tan in tücaa'tic in waj xa'num taanil. Bel u cu tojquinte a cristiano ti'i ca' u c'ümeechoo',” cu t'an a Dios ti'i a Cristojo. Baalo' ti tz'iiba'an,— cu t'an a Jesusu. ");
INSERT INTO mopNT_vpl VALUES ("MT11_11","070_11_11","MAT","11","11","11","—Tan in wadic te'ex u jajil. Ma' yan a winic a yanaji yoc'olcab a mas qui' a tz'abi u bete' tuwich aj Juan aj tz'aj ocja'a. C'u' betiqui, ca' yanacoo' a hermanojo, que'enoo' tu c'ü' a Dioso. Ca'ax ma' nooch u wichil u meyaj jun tuul a hermano tu yaamoo' u chucaan a hermanojo, mas nooch u wichil u meyaj tuwich aj Juan,— cu t'an a Jesusu. ");
INSERT INTO mopNT_vpl VALUES ("MT11_12","070_11_12","MAT","11","12","12","—Tac tu q'uinil ti caji ti t'an aj Juana, y tac leeb tan ti tan ilic u c'ümic a yaj u cuenta a Dios ti ca'ana. Le'ecoo' a tz'iiqui, tanoo' cuchi u c'ütic u wich etel muc' a que'enoo' u yool ti ocolo,— cu t'an a Jesusu. ");
INSERT INTO mopNT_vpl VALUES ("MT11_13","070_11_13","MAT","11","13","13","—Tulacaloo' a boon tuul u yadajoo' u t'an a Dios uchi y etel a ley u tz'iibtaj aj Moisese, u tzicbaltajoo' u q'uinil u tücaa'bül a mac u men a Dioso, asto ti c'ochi aj Juan aj tz'aj ocja'a. Ala'aji, u yada' u yadic abe'e,— cu t'an a Jesusu. ");
INSERT INTO mopNT_vpl VALUES ("MT11_14","070_11_14","MAT","11","14","14","—Wa' qui' ta wiche'ex a tz'ocsiqui, le'ec aj Juana, le'ec ilic aj Elias a aalbi ti watac to,— cu t'an a Jesusu. ");
INSERT INTO mopNT_vpl VALUES ("MT11_15","070_11_15","MAT","11","15","15","—Le'ec mac a patal u yubi in t'ana, yan u tz'eec tu yool,— cu t'an a Jesusu. ");
INSERT INTO mopNT_vpl VALUES ("MT11_16","070_11_16","MAT","11","16","16","—¿C'u' a qui' ca' in wadü' te'ex ti'i ca' chiclac te'ex biqui'iloo' u na'at a cristiano a cuxa'anoo' to aleebe? Ala'oo'o, jabix ca' muuch'oo' ti tz'ub a tina'anoo' chumuc caj. Jun muuch'u, tanoo' u t'an ti chich etel ulaac' a jun muuch'u,— cu t'an a Jesusu. ");
INSERT INTO mopNT_vpl VALUES ("MT11_17","070_11_17","MAT","11","17","17","—“Ti wuustaj a xool ich jabix baxül tz'ocolbeel. C'u' betiqui, ma' a c'atiintaje'ex. Ma' uche'ex a woc'ot. Uchi ti woc'ol ti'i cuchi yaj-oolal ich jabix baxül quimene. Ma'ax ti baalo', ma' a c'atiintaje'ex. Ma' uche'ex a woc'ol,” cu t'anoo' a jun muuch' ti'i ulaac' a jun muuch'u,— cu t'an a Jesusu. ");
INSERT INTO mopNT_vpl VALUES ("MT11_18","070_11_18","MAT","11","18","18","—Baalo' ilic a betabi ti'i aj Juan y ten xan. Le'ec ti caji ti meyaj aj Juana, ma' uchi u janal. Ma'ax uchi u yuc'ul. “Yan a c'ac'asba'al tu yool,” cu t'anoo',— cu t'an a Jesusu. ");
INSERT INTO mopNT_vpl VALUES ("MT11_19","070_11_19","MAT","11","19","19","—Inene, yanajeen ti cristianojil. Walac in janal in wuc'ul,— cu t'an a Jesusu. —“Jac' ti'i a janala. Walac u caalül,” cu t'anoo' tin woc'ol. “Walac u yet'octicoo' a yanoo' u yanil ti mol taq'uin ti'i a gobierno u yet'ocoo' a mac a top yanoo' u sip'il,” cu t'anoo' tin woc'ol,— cu t'an a Jesusu. —C'u' betiqui, etel c'u' a tanoo' u betic a tanoo' u tz'ocsic a Dioso, chica'an ti toj u na'at a Dioso,— cu t'an a Jesusu. ");
INSERT INTO mopNT_vpl VALUES ("MT11_20","070_11_20","MAT","11","20","20","Pues te'i. Caji a Jesus u yadü' a c'as a beloo' u cu c'ümü' a caj tuba u betaj manal jun jatz a boon a milagro u betaja. Ma' ilic u jelajoo' u tucul ta wichi. ");
INSERT INTO mopNT_vpl VALUES ("MT11_21","070_11_21","MAT","11","21","21","—Top yaj a watac ti'i a caj Corazini. Top yaj a watac ti'i a caj Betsaida,— cu t'an a Jesusu. —Wa cuchi betabi ich caj Tiro ich caj Sidon boon a milagro a betabi ich caj Corazin ich caj Betsaidaja, uchi tun cuchi u jeloo' u tucul. U tz'ajoo' cuchi u costal ti'ijoo' u noc'. U tz'ajoo' cuchi a ta'an tu pol u men u yajil u yool eteloo' u sip'il jabix ti sucoo' u bete',— cu t'an a Jesusu. ");
INSERT INTO mopNT_vpl VALUES ("MT11_22","070_11_22","MAT","11","22","22","—Tan in wadic te'ex. Le'ec ca' c'ochoc u q'uinil u tz'abül a sip'il tu jobeeb a yoc'olcaba, mas yaj ti bel u ca'a tz'abül ti'ijoo' tuwich u tz'abül ti'ijoo' ich caj Tiro ich caj Sidon,— cu t'an a Jesusu. ");
INSERT INTO mopNT_vpl VALUES ("MT11_23","070_11_23","MAT","11","23","23","—Uxtun a caj Capernaum. Tanoo' u tuclic u nac'ül ti ca'an, pero pulbuloo' u ca'a tac ichil u cuuchil a pula'ana,— cu t'an a Jesusu. —Wa cuchi betabi ichil a c'ac'as caj Sodoma boon a milagro a betabi ich caj Capernaum, yan to cuchi a caj Sodoma tac leeb,— cu t'an a Jesusu. ");
INSERT INTO mopNT_vpl VALUES ("MT11_24","070_11_24","MAT","11","24","24","—Tan in wadic te'ex. Le'ec ca' c'ochoc u q'uinil u tz'abül a sip'il tu jobeeb a yoc'olcaba, mas yaj ti bel u ca'a tz'abül ti'ijoo' tuwich u tz'abül ti'ijoo' ich caj Sodoma,— cu t'an a Jesusu. ");
INSERT INTO mopNT_vpl VALUES ("MT11_25","070_11_25","MAT","11","25","25","Pues te'i. Baala' ilic u yadaj a Jesus ti a q'uin abe'e. —Tat, inchech u Noochil a ca'an y a yoc'olcaba. Bo'tic tech a mucaj a jajil t'an ti'i ma' u ch'a'icoo' u tojil a top seeb u yool etel a top patal. C'u' betiqui, a ye'aj abe' ti'ijoo' a walacoo' u tz'eec u yool ta pach jabix a tz'ub a walac u tz'ocsaj t'ana,— cu t'an a Jesusu. ");
INSERT INTO mopNT_vpl VALUES ("MT11_26","070_11_26","MAT","11","26","26","—Tat, a tz'aj ti baalo' u men baalo' a qui' ta wichi,— cu t'an a Jesus ti'i a Tattzili. ");
INSERT INTO mopNT_vpl VALUES ("MT11_27","070_11_27","MAT","11","27","27","—Pues te'i. Tz'abi tulacal tin c'ü' u men in Tat,— cu t'an a Jesus ti'ijoo' u yaj cambal. —Inen a Mejentzili. Ma'ax mac u yeelen, jadi' a Tattzili. Ma'ax le'ec a Tattzili, ma'ax mac u yeel. Chen inen y etel boon mac a qui' tin wich ca' in yee' ti'ijoo' a Tattzili,— cu t'an a Jesusu. ");
INSERT INTO mopNT_vpl VALUES ("MT11_28","070_11_28","MAT","11","28","28","—Boon tuule'ex a tane'ex a meyaj ti'i a sa'alticale'ex a bajili, tz'aje'ex a wool tin pach tuwich cuchi ti chen tane'ex a yaaltic a tz'oques a top yaj u tz'ocsabülü, jabix cuchi tane'ex a cuchic a top ala. Tin wetel yan a jedel ti'i a meyaj abe'e,— cu t'an a Jesusu. ");
INSERT INTO mopNT_vpl VALUES ("MT11_29","070_11_29","MAT","11","29","29","—Tz'aje'ex a wool tin pach jabix ti walac u c'üxbüloo' a wacax tu bajil ti'i u beticaloo' a meyaja. Uchuque'ex a cambal tin wetel. Inene, qui'en etel tulacal mac. Ma' ta'ach in betic in yanil. Tin wetel a cüxtique'ex a jetz'a'an-oolil u men walac in joc'sic a mac ichil u sip'ili,— cu t'an a Jesusu. ");
INSERT INTO mopNT_vpl VALUES ("MT11_30","070_11_30","MAT","11","30","30","—Le'ec ti que'ene'ex tin wetele, jabix cuchi c'üxa'ano'on tiqui bajili. Ma' yaj in tz'ocsabül. Ma' yaj u betabül in meyaji,— cu t'an a Jesusu. ");
INSERT INTO mopNT_vpl VALUES ("MT12_1","070_12_1","MAT","12","1","1","Pues te'i. Ma' top uchi u yadü' abe'e, ti tan u manül a Jesus ich col tu q'uinil a jedele. Wi'ijoo' u yaj cambal. Cajoo' u jiribte tz'etz'eec u semilla harinaja. Cajoo' u jante. ");
INSERT INTO mopNT_vpl VALUES ("MT12_2","070_12_2","MAT","12","2","2","Le'ecoo' a fariseo u c'aba'oo' u na'ata, u yilajoo' c'u' a tanoo' u betiqui. —Iloo' a waj cambal,— cu t'anoo' ti'i a Jesusu. —Tanoo' u betic c'u' a ma' qui' u betabül tu q'uinil a jedele,— cu t'anoo' ti'i. ");
INSERT INTO mopNT_vpl VALUES ("MT12_3","070_12_3","MAT","12","3","3","—¿C'u' ca'a tane'ex a wadic abe'e? A xocaje'ex c'u' u betaj aj quimen rey David u yet'ocoo' u yetmanül le'ec ti wi'ijoo'o,— cu t'an a Jesus ti'ijoo' ti uchi u nuuc. ");
INSERT INTO mopNT_vpl VALUES ("MT12_4","070_12_4","MAT","12","4","4","—Oqui aj David ichil u yotoch a Dioso,— cu t'an a Jesusu. —U molaj a waj harina a tz'abi ti'i a Dioso. U tz'aj ti'ijoo' u yetmanül. U laj jantajoo' a waj harinaja. Ma' qui' tu c'axül ti'i a ley ca' jantabüc a waj harina abe' u men ala'aji, ma'ax u menoo' u yetmanül. Jadi' tz'aja'an ti'i u yaj mansaj t'an a cristiano ti'i a Dios ca' u jante a waj harina abe'e. Le'ec aj David abe'e, ma' u yaj mansaj t'an a cristiano ti'i a Diosi,— cu t'an a Jesusu. ");
INSERT INTO mopNT_vpl VALUES ("MT12_5","070_12_5","MAT","12","5","5","—Uxtun u yaj mansaj t'an a cristiano ti'i a Dioso. Walacoo' u meyaj tu q'uinil a jedele. Ma' tanoo' u tz'ocsic u yanil u q'uinil a jedel ichil u yotoch a Dios ti baalo'o. Ma' ilic tanoo' u cüxtic u sip'il ti baalo'o. A xocaje'ex abe' ichil a ley u tz'iibtaj aj Moisese,— cu t'an a Jesus ti'ijoo' a fariseo u c'aba'oo' u na'ata. ");
INSERT INTO mopNT_vpl VALUES ("MT12_6","070_12_6","MAT","12","6","6","—Tan in wadic te'ex. Que'en a mas nooch u yanil tuwich u yotoch a Dios ta yaame'ex wa'ye'e,— cu t'an a Jesusu. ");
INSERT INTO mopNT_vpl VALUES ("MT12_7","070_12_7","MAT","12","7","7","—“Mas qui' tin wich a ch'a'ique'ex u yotzilil a mac tuwich a tz'eeque'ex ten a sij-oolo,” cu t'an a Dioso. Wa cuchi a weeltaje'ex u nu'cul a t'an abe' u yadaj a Dioso, ma' cuchi a wadaje'ex ti u cüxtajoo' u sip'il in waj cambal le'ec ti ma' yanoo' u sip'ili,— cu t'an a Jesus ti'ijoo' a fariseo u c'aba'oo' u na'ata. ");
INSERT INTO mopNT_vpl VALUES ("MT12_8","070_12_8","MAT","12","8","8","—U paatal in wadic ti yan a mas nooch u yanil tuwich u yotoch Dios wa'ye'e, u men le'ec inen a yanajeen ti cristianojili, yan in yanil ti tücaa' ca'ax tu q'uinil jedel,— cu t'an a Jesusu. ");
INSERT INTO mopNT_vpl VALUES ("MT12_9","070_12_9","MAT","12","9","9","Pues te'i. Le'ec ti jobi u tzicbal ich col a Jesusu, bini ichil a naj tuba walacoo' u much'tal u c'ajes a Dioso. ");
INSERT INTO mopNT_vpl VALUES ("MT12_10","070_12_10","MAT","12","10","10","Yan te'i jun tuul a winic a mooch' u c'ü'. —¿Qui' wa tu c'axül ti'i a ley ca' ch'anesabüc a mac tu q'uinil a jedele?— cu t'anoo' ti'i a Jesusu. Chen u c'aatajoo' ti'i wa qui' u men u c'atoo' u cüxte u sip'il a Jesus ti'i ca' u tzoloo'. ");
INSERT INTO mopNT_vpl VALUES ("MT12_11","070_12_11","MAT","12","11","11","—Uchac yan jun tuul a winic ta yaame'ex a yan jun tuul u carnero. Wa cuchi ca' c'axüc u carnero ich ch'e'en tu q'uinil a jedele, ¿ma' wa jede'ec u müchic y u joc'siqui?— cu t'an a Jesus ti'ijoo'o. ");
INSERT INTO mopNT_vpl VALUES ("MT12_12","070_12_12","MAT","12","12","12","—Mas yan u c'abeetil a winic tuwich a carnerojo, mentücü, qui' tu c'axül ti'i a ley u betabül a qui' tu q'uinil a jedele,— cu t'an a Jesusu. ");
INSERT INTO mopNT_vpl VALUES ("MT12_13","070_12_13","MAT","12","13","13","—Sützü a c'ü',— cu t'an a Jesus ti'i a winiqui. U sützaj u c'ü'. Ch'ani. Quetaji etel ulaac' u c'ü'. ");
INSERT INTO mopNT_vpl VALUES ("MT12_14","070_12_14","MAT","12","14","14","Pues te'i. Joc'oo' a fariseo u c'aba'oo' u na'ata. Much'lajoo' tu bajil u tucloo' biqui ca' u müchoo' y u quimsoo' a Jesusu. ");
INSERT INTO mopNT_vpl VALUES ("MT12_15","070_12_15","MAT","12","15","15","Pues te'i. Le'ec a Jesusu, u yeel c'u' a tanoo' u tucliqui, mentücü, joq'ui te'i. Bini. Yaaboo' a cristiano a tücünacoo' tu pach a Jesusu. U laj ch'anesajoo' boon a c'oja'an a yan tu yaamoo'o. ");
INSERT INTO mopNT_vpl VALUES ("MT12_16","070_12_16","MAT","12","16","16","—Ma' a beele'ex a wadü' maquen ti'ijoo' a cristianojo,— cu t'an a Jesus ti'ijoo' a que'enoo' tu pacha. ");
INSERT INTO mopNT_vpl VALUES ("MT12_17","070_12_17","MAT","12","17","17","Baalo' ti jajaji u t'an aj Isaiasa, le'ec jun tuul u yadaj u t'an a Dios uchi. ");
INSERT INTO mopNT_vpl VALUES ("MT12_18","070_12_18","MAT","12","18","18","Baala' u yadaj ala'aji: —“Ile'ex in waj meyaj le'ec mac in yeetaj. Yaj in wu'yi ala'aji. Top qui' in wool etel,” cu t'an a Dioso. “Bel in quin tz'aa' in Püsüc'al etel ala'aji. Bel u cu yadü' a toj na'at ti'ijoo' a ma' u yeelenoo',” cu t'an a Dioso. ");
INSERT INTO mopNT_vpl VALUES ("MT12_19","070_12_19","MAT","12","19","19","“Ma' tu p'ujsic a mac etel t'an. Ma'ax u yawat ti chich. Ma'ax mac jede'ec u yubic u chichich t'an ti calle,” cu t'an a Dioso. ");
INSERT INTO mopNT_vpl VALUES ("MT12_20","070_12_20","MAT","12","20","20","“Ma' tu ma'ma'alcuntic a ma' yan u muc' jabix u yoc nül a yajcunbiji,” cu t'an a Dios yoc'ol u ch'a'bül u yotzilil a mac u men a Cristojo. “Ma'ax tu coch jobsic a chen tz'etz'eec u chichil u yool jabix u mechajil lampara a watac u tupul,” cu t'an a Dioso. “Ma' tu jobsic abe' asto u tz'eec ca' uchuc u ganar a toj yoc'ol a c'asa,” cu t'an a Dioso. ");
INSERT INTO mopNT_vpl VALUES ("MT12_21","070_12_21","MAT","12","21","21","“Etel ala'aji, yantal u ca'a u noj-ool a ma' Israele,” cu t'an a Dioso,— cu t'an aj Isaias biq'uin ado'o. ");
INSERT INTO mopNT_vpl VALUES ("MT12_22","070_12_22","MAT","12","22","22","Pues te'i. C'ochesabi etel Jesus jun tuul a winic a ch'oop, y bes, y yan a c'ac'asba'al tu yoolo. U ch'anesaj a winiqui. Patal tun ti t'an y ti cha'an. ");
INSERT INTO mopNT_vpl VALUES ("MT12_23","070_12_23","MAT","12","23","23","Tulacaloo' a cristianojo, sa'too' u yool. —¿Ma' wa le'ec ala'i u yaj Sa'alil a cristianojo, le'ec u mam aj quimen rey David a tan u paac'bülü?— cu t'anoo' tu bajil. ");
INSERT INTO mopNT_vpl VALUES ("MT12_24","070_12_24","MAT","12","24","24","U'yajbi c'u' a tanoo' u yadic a cristiano abe' u men a fariseo u c'aba'oo' u na'ata. —Ichil u yool a winic ada' que'en a quisini, le'ec u noochiloo' a c'ac'asba'ala, mentücü, patal u joq'ues a c'ac'asba'al tu yool a maca,— cu t'anoo' a fariseo yoc'ol a Jesusu. ");
INSERT INTO mopNT_vpl VALUES ("MT12_25","070_12_25","MAT","12","25","25","Pues te'i. Le'ec a Jesusu, u yeel c'u' a tanoo' u tucliqui. —Le'ec ti tz'iicoo' a cristiano tu bajiloo' tu cuenta jun tuul a reye, jobol u ca'a u cuenta a rey abe'e. Baalo' ilic etel a caj wa etel a naja. Wa tz'iicoo' a cristiano tu bajiloo' te'iji, p'aatül u ca'a ti weca'anoo',— cu t'an a Jesusu. ");
INSERT INTO mopNT_vpl VALUES ("MT12_26","070_12_26","MAT","12","26","26","—Wa cuchi le'ec ilic a quisin a tan u joc'sicoo' a c'ac'asba'ala, ma' qui'oo' tu bajil. Wa cuchi ca' u betoo' ti baalo'o, jobol u ca'a u cuenta a quisini,— cu t'an a Jesusu. ");
INSERT INTO mopNT_vpl VALUES ("MT12_27","070_12_27","MAT","12","27","27","—¿Wa cuchi jaj ti tan in joc'sic a c'ac'asba'al etel u muc' a quisini, uxtun a wet'oque'ex? ¿Etel ilic wa u muc' a quisini, tanoo' u joc'sic a c'ac'asba'ala? Le'ec ilic ala'oo'o, beloo' u cu yee' ti ma' toj a t'ane'ex,— cu t'an a Jesus ti'ijoo' a fariseo u c'aba'oo' u na'ata. ");
INSERT INTO mopNT_vpl VALUES ("MT12_28","070_12_28","MAT","12","28","28","—C'u' betiqui, wa jaj ti tan in joc'sic a c'ac'asba'al etel u muc' u Püsüc'al a Dioso, jaj ilic ti c'ochi u q'uinil u tücaa'bül a mac u men a Dioso,— cu t'an a Jesusu. ");
INSERT INTO mopNT_vpl VALUES ("MT12_29","070_12_29","MAT","12","29","29","—Ma' yan biqui u yocol a mac ichil u yotoch a mac a yaab u muc' ti'i u toco' c'u' a yan ti'i chen ti baalo'. Payanbej yan u c'üxic a yaab u muc'u. Pachili, jede'ec u paatal u yocol ichil u yotoch u toco' c'u' a yan ti'iji,— cu t'an a Jesus yoc'ol ti tan u joc'sic a mac yalam u muc' a quisini. ");
INSERT INTO mopNT_vpl VALUES ("MT12_30","070_12_30","MAT","12","30","30","—Le'ec mac a ma' que'en u yool tin pacha, tz'iic ten. Le'ec mac a ma' tan u yaantiquene, tan u c'ütic u wich in meyaj, ");
INSERT INTO mopNT_vpl VALUES ("MT12_31","070_12_31","MAT","12","31","31","mentücü, tan in wadic te'ex ti sabeensil c'u' a tane'ex a betiqui, le'ec ca' a wade'ex ti yan a quisin tin wool. Tulacal a sip'il y a maclant'an a tanoo' u betic a cristianojo, jede'ec u sa'tesabül ti'ijoo'o. C'u' betiqui, ca' u maclant'antoo' u Püsüc'al a Dioso, ma' yan q'uin u sa'tesabül ti'ijoo',— cu t'an a Jesusu. ");
INSERT INTO mopNT_vpl VALUES ("MT12_32","070_12_32","MAT","12","32","32","—Inene, yanajeen ti cristianojil. Mac ca' u yadü' a c'as tin woc'olo, jede'ec u sa'tesabül ti'iji. C'u' betiqui, ca' u yadü' a c'as yoc'ol u Püsüc'al a Dioso, ma' tu sa'tesabül ti'i ma'ax wa'ye' yoc'olcab, ma'ax ti'i a yoc'olcab a tumulbene,— cu t'an a Jesusu. ");
INSERT INTO mopNT_vpl VALUES ("MT12_33","070_12_33","MAT","12","33","33","—Pues te'i. Le'ec a che' a quich'pana, quich'pan ilic u wich. Le'ec a che' a ma' qui'i, ma' ilic quich'pan u wich. Etel u wich a che'e, chica'an biqui'il u yoc,— cu t'an a Jesusu. ");
INSERT INTO mopNT_vpl VALUES ("MT12_34","070_12_34","MAT","12","34","34","—Inche'exe, top c'ase'ex jabixe'ex u yal a cana. ¿Biqui ca' paataque'ex a wadü' a qui'i, ti top c'ase'ex a na'at? Jabix ilic u na'at a maca, baalo' ilic u t'an,— cu t'an a Jesus ti'ijoo' a fariseo u c'aba'oo' u na'ata. ");
INSERT INTO mopNT_vpl VALUES ("MT12_35","070_12_35","MAT","12","35","35","—Le'ec a winic a qui'i, walac u yadic a qui' u men qui' u na'at. Le'ec a winic a c'asa, walac u yadic a c'as u men c'as u na'at,— cu t'an a Jesusu. ");
INSERT INTO mopNT_vpl VALUES ("MT12_36","070_12_36","MAT","12","36","36","—Tan in wadic te'ex. Le'ec ca' c'ochoc u q'uinil u tz'abül a sip'ili, jujun tuul a cristianojo, beloo' u cu yadü' c'u' ca'a u yadajoo' tulacal a jujun cuul a t'an a ma'ax c'u' aj beele,— cu t'an a Jesusu. ");
INSERT INTO mopNT_vpl VALUES ("MT12_37","070_12_37","MAT","12","37","37","—Yoc'lal a t'ane'exe, bele'ex a ca'a c'ümbül. Yoc'lal ilic a t'ane'exe, bele'ex a ca'a pulbul,— cu t'an a Jesusu. ");
INSERT INTO mopNT_vpl VALUES ("MT12_38","070_12_38","MAT","12","38","38","Pues te'i. Que'en ilic etel a Jesus u yaj ca'ansajil u ley aj Moises u yet'ocoo' a fariseo u c'aba'oo' u na'ata. —Maestro,— cu t'anoo' ti'i a Jesusu. —Ti c'ati cuchi ti wila' a betic c'u'ac ti'i ca' chiclac to'on a yanil,— cu t'anoo' ti'i. ");
INSERT INTO mopNT_vpl VALUES ("MT12_39","070_12_39","MAT","12","39","39","—Aleebe top c'asoo' a cristianojo. Ca'ax c'u'ac u betoo'. U p'ütajoo' u c'ajsic a Dios ti ca'an ti'i ca' u c'ajesoo' a ca'ax c'u'ac ti diosili. Le'ec a jabix ala'oo'o, walacoo' u c'aatic ca' betabüc c'u'ac ti'i ca' chiclac u yanil,— cu t'an a Jesusu. —Ma' tu ye'bel ti'ijoo' a milagro a jabix u c'atoo'o. Jadi' a jabix u betaj aj Jonasa, jadi' bel u ca'a ye'bel ti'ijoo'. Le'ec aj Jonas abe'e, u yadaj u t'an a Dios uchi,— cu t'an a Jesusu. ");
INSERT INTO mopNT_vpl VALUES ("MT12_40","070_12_40","MAT","12","40","40","—Jabix ilic ti culaji aj Jonas ox p'e q'uin ox p'e ac'ü' ichil u nüc' a noxi' cüyü, baalo' ilic bel in ca'a ti cuntal ox p'e q'uin ox p'e ac'ü' ichil a lu'umu. Inene, yanajeen ti cristianojil,— cu t'an a Jesusu. ");
INSERT INTO mopNT_vpl VALUES ("MT12_41","070_12_41","MAT","12","41","41","—Le'ec ca' c'ochoc u q'uinil u tz'abül a sip'ili, wa'taloo' u ca'a a cristiano ti'i ca' ilbicoo' u sip'il a jujun tuulu. Wa'taloo' ilic u ca'a a cristiano a cuxa'anoo' to aleebe tu yaamoo',— cu t'an a Jesusu. —Wa'taloo' ilic u ca'a a cristiano a taloo' ich caj Ninive u yadoo' u sip'il a cristiano a cuxa'anoo' to aleebe. le'ecoo' ich caj Ninive, u jelajoo' u tucul u men a c'u' a aalbi ti'ijoo' u men aj Jonasa. Ca'ax yan jun tuul wa'ye' ta yaame'ex a mas nooch u yanil tuwich aj Jonasa, ma' ta'ache'ex a tz'ocsic u t'an,— cu t'an a Jesusu. ");
INSERT INTO mopNT_vpl VALUES ("MT12_42","070_12_42","MAT","12","42","42","—Le'ec ca' c'ochoc u q'uinil u tz'abül a sip'ili, wa'tal ilic u ca'a ix reina a tali mas naach ti a sur uchi. Bel u cu yadoo' u sip'il a cristiano a cuxa'anoo' to aleebe. Ca'ax boon naach que'en u caal, bini ix reina abe' u yubi u patalil aj rey Salomon biq'uin ado'o. Ca'ax yan jun tuul wa'ye' ta yaame'ex a mas nooch u yanil tuwich aj Salomono, ma' ta'ache'ex a tz'ocsic u t'an,— cu t'an a Jesusu. ");
INSERT INTO mopNT_vpl VALUES ("MT12_43","070_12_43","MAT","12","43","43","—Pues te'i. Le'ec ca' joc'oc a c'ac'asba'al ichil u yool a maca, walac u manül ichil a tiquin lu'um ti'i ca' u cüxte tuba u jedel. Le'ec ti ma' tan u cüxtic tuba u jedele, ");
INSERT INTO mopNT_vpl VALUES ("MT12_44","070_12_44","MAT","12","44","44","walac u yadic tu bajil: “Bel in ca'a ti ca' usc'al tin pach tin cuuchil tuba joq'ueen,” cu t'anac tu bajil,— cu t'an a Jesusu. —Le'ec ti c'ochi tuba yaax culajiji, ma'ax c'u' yan te'i. Chen qui' miisa'an. Qui' mola'an u cuuchil. Le'ec abe' u cuuchili, le'ec u püsüc'al a maca,— cu t'an a Jesusu. ");
INSERT INTO mopNT_vpl VALUES ("MT12_45","070_12_45","MAT","12","45","45","—Le'ec ca' u yila' ti baalo'o, walac u beel u cüxte siete tuul ulaac' a c'ac'asba'al a mas c'as tuwich ala'aji. Tulacaloo' walacoo' u yocol te'i ti cuntal. Mas c'as ti p'aati a winic tuwich ti yaax culaji. Baalo' ti bel u ca'a ti uchul ti'ijoo' a c'ac'as cristiano a cuxa'anoo' to aleebe,— cu t'an a Jesusu. ");
INSERT INTO mopNT_vpl VALUES ("MT12_46","070_12_46","MAT","12","46","46","Pues te'i. Tan to u t'an a Jesus eteloo' a cristiano ti c'ochi u na' u yet'ocoo' u yitz'in. Wa'lajoo' pach naj. U c'atoo' cuchi tzicbal etel a Jesusu. ");
INSERT INTO mopNT_vpl VALUES ("MT12_47","070_12_47","MAT","12","47","47","—Wa'anoo' ti que'en a na' u yet'ocoo' a witz'in pach naj. U c'atoo' cuchi tzicbal ta wetel,— cu t'an a jun tuul ti'i a Jesusu. ");
INSERT INTO mopNT_vpl VALUES ("MT12_48","070_12_48","MAT","12","48","48","—Ta t'an incheche, ¿mac in na'? ¿Macoo' in witz'in?— cu t'an a Jesus ti'i a winic a uchi u tzolo. ");
INSERT INTO mopNT_vpl VALUES ("MT12_49","070_12_49","MAT","12","49","49","U tich'ajoo' u yaj cambal tu c'ü'. —Jeda' in na'. Jada'oo' in witz'in,— cu t'an. ");
INSERT INTO mopNT_vpl VALUES ("MT12_50","070_12_50","MAT","12","50","50","—Le'ec mac a walacoo' u betic jabix u c'ati in Tat ti ca'ana, le'ecoo' in witz'in, le'ecoo' in na',— cu t'an a Jesusu. ");
INSERT INTO mopNT_vpl VALUES ("MT13_1","070_13_1","MAT","13","1","1","Pues te'i. Ti ilic a q'uin abe'e, joq'ui a Jesus ich naj. Bini ti tintal tu chi' a lagunaja. ");
INSERT INTO mopNT_vpl VALUES ("MT13_2","070_13_2","MAT","13","2","2","Top yaab a cristiano a much'lajoo' tu tzeele, mentücü, oqui ichil a barcojo. Tinlaji te'i ti ca'ansaj. Tulacaloo' a cristiano a much'a'anoo' te'iji, wa'anoo' ti que'en chi' a lagunaja. ");
INSERT INTO mopNT_vpl VALUES ("MT13_3","070_13_3","MAT","13","3","3","Yaab u yadaj a Jesus ti'ijoo'o, pero chen ich mucult'an. —Jun tuul a winiqui, bini ti pac'. ");
INSERT INTO mopNT_vpl VALUES ("MT13_4","070_13_4","MAT","13","4","4","Le'ec ti tan u pac'a, yan a semilla a c'axi tuwich bej. C'ochoo' a ch'iich'i. U molajoo' a semilla abe'e,— cu t'an a Jesusu. ");
INSERT INTO mopNT_vpl VALUES ("MT13_5","070_13_5","MAT","13","5","5","—Yan a püc'bi tuba ma' pim a lu'umu, yan a tunich yalama. Joq'ui ti jomol u men ma' pim a lu'umu,— cu t'an a Jesusu. ");
INSERT INTO mopNT_vpl VALUES ("MT13_6","070_13_6","MAT","13","6","6","—Le'ec ti chücüjaji a q'uini, wochmi u le' u men ma' yan u can. Tiqui,— cu t'an a Jesusu. ");
INSERT INTO mopNT_vpl VALUES ("MT13_7","070_13_7","MAT","13","7","7","—Yan a püc'bi tuba yan a jabix a c'ünchiimi. Le'ec ti tan u ch'iil a püc'aala, ch'iji ilic a jabix a c'ünchiimi. U c'ascuntaj a püc'aala,— cu t'an a Jesusu. ");
INSERT INTO mopNT_vpl VALUES ("MT13_8","070_13_8","MAT","13","8","8","—Yan a püc'bi ichil a lu'um a quich'pana. Qui' u ch'iil a püc'aal te'i. U tz'aj u wich. Yan u tz'aj cien sut mas yaab tuwich a boon a püc'bijil. Yan u tz'aj sesenta sut mas yaab. Yan u tz'aj treinta sut mas yaab,— cu t'an a Jesusu. ");
INSERT INTO mopNT_vpl VALUES ("MT13_9","070_13_9","MAT","13","9","9","—Le'ec mac patal u yubi in t'ana, yan u tz'eec tu yool,— cu t'an a Jesusu. ");
INSERT INTO mopNT_vpl VALUES ("MT13_10","070_13_10","MAT","13","10","10","Pues te'i. Naatz'oo' u yaj cambal tu tzeel a Jesusu. —¿C'u' ca'a tan a t'an eteloo' ich mucult'an?— cu t'anoo' ti'i. ");
INSERT INTO mopNT_vpl VALUES ("MT13_11","070_13_11","MAT","13","11","11","—Tz'abi te'ex ca' a ch'a'e'ex u tojil yoc'ol biqui ti tan tun u tücaa' a Dioso. Ma' tz'abi abe' ti'ijoo' ulaac' a cristianoji,— cu t'an a Jesus ti'ijoo' ti uchi u nuuc. ");
INSERT INTO mopNT_vpl VALUES ("MT13_12","070_13_12","MAT","13","12","12","—Le'ec mac u c'ümaj a jaja, bel u ca'a tz'abül ti'i ca' u yeelte a jaj ti mas yaab. P'aatül u ca'a ti yaab a jaj u yeele. Le'ec mac a ma' u c'ümaj a jaja, bel u ca'a tochol ti'i boon a jaj u yeele,— cu t'an a Jesusu. ");
INSERT INTO mopNT_vpl VALUES ("MT13_13","070_13_13","MAT","13","13","13","—Baalo' ti yan, mentücü, tan in t'an ti'ijoo' ich mucult'an. Tanoo' u cha'antic pero ma' ta'achoo' u yilic. Tanoo' u yubic. C'u' betiqui, ma' ta'achoo' u yeeltic, ma'ax u ch'a'icoo' u tojil,— cu t'an a Jesusu. ");
INSERT INTO mopNT_vpl VALUES ("MT13_14","070_13_14","MAT","13","14","14","—Le'ec aj Isaiasa, jun tuul u yadaj u t'an a Dios uchi. Jajaji u t'an yoc'ol ala'oo'o. “Tu jajil bele'ex a ca'a a wu'yi. C'u' betiqui, ma' yan q'uin a ch'a'ique'ex u tojil. Tu jajil bele'ex a ca'a a cha'ante. C'u' betiqui, ma' yan q'uin a wilique'ex,” cu t'an aj Isaiasa. ");
INSERT INTO mopNT_vpl VALUES ("MT13_15","070_13_15","MAT","13","15","15","“Le'ecoo' a cristiano ada'a, chichaji u pol yoc'ol c'u' a ti'i a Dioso. P'aatoo' ti coocoo' u xiq'uin ti'i u yubical. U mutzajoo' u wich ti'i ma' u cha'anoo' etel u wich, ma'ax u yubicoo' etel u xiquin ma'ax u ch'a'icoo' u tojil ti'i ma' u c'üm-ooltiquenoo' ti'i ca' in ch'anesoo', cu t'an a Dioso,” cu t'an aj Isaiasa,— cu t'an a Jesusu. ");
INSERT INTO mopNT_vpl VALUES ("MT13_16","070_13_16","MAT","13","16","16","—Qui'e'ex cuchi a wool u men tane'ex a wilic. Tane'ex a wu'yic,— cu t'an a Jesusu. ");
INSERT INTO mopNT_vpl VALUES ("MT13_17","070_13_17","MAT","13","17","17","—Tan in wadic te'ex u jajil. Yanoo' u yadajoo' u t'an a Dios uchi u yet'ocoo' a toj u na'ata, u c'atiintajoo' cuchi u yila' c'u' a tane'ex a wiliqui, pero ma' yan biqui. U c'atiintajoo' u yubi c'u' a tane'ex a wu'yiqui, pero ma' yan biqui,— cu t'an a Jesusu. ");
INSERT INTO mopNT_vpl VALUES ("MT13_18","070_13_18","MAT","13","18","18","—Pues te'i. Le'ec ada' u nu'cul a mucult'an in wadaj yoc'ol aj pac'a,— cu t'an a Jesusu. ");
INSERT INTO mopNT_vpl VALUES ("MT13_19","070_13_19","MAT","13","19","19","—Ala'aji, tan u yadic u pectzil a Dios yoc'ol biqui ti walac u tücaa' a Dioso, jabix cuchi tan u püq'uic a semilla ichil u tucul a maca. C'u' betiqui, ma' tan u ch'a'bül u tojil, mentücü, walac u c'ochol a quisin u toco' a t'an a püc'bi cuchi ichil u tuculu. Le'ec abe' u nu'cul boon a semilla a c'axi ti bej,— cu t'an a Jesusu. ");
INSERT INTO mopNT_vpl VALUES ("MT13_20","070_13_20","MAT","13","20","20","—Le'ec a semilla a püc'bi tuba jay a lu'umu, yan a tunich yalama, le'ec jabix a winic a jabix püc'bi u t'an a Dios ichil u püsüc'al. Tu jomolil u c'ümaj. Qui' u yool,— cu t'an a Jesusu. ");
INSERT INTO mopNT_vpl VALUES ("MT13_21","070_13_21","MAT","13","21","21","—C'u' betiqui, jabix ilic ti ma' yan u can a püc'aal a püc'bi tuba yan a tunich yalama, baalo' ilic ala'aji. Jadi' jun p'e rato ilic bel u cu tz'oques. Le'ec ca' yanac a yaja, wa ca' tz'abüc ti'i a yaj u men in t'ana, jomol u p'ütic u tz'ocsic in t'an,— cu t'an a Jesusu. ");
INSERT INTO mopNT_vpl VALUES ("MT13_22","070_13_22","MAT","13","22","22","—Le'ec a jabix a semilla a püc'bi tuba yan a jabix a c'ünchiimi, le'ec abe' jabix a mac u yubaj u t'an a Dioso. U c'ümaj. Pachili, top que'en u yool tu pach a jabix a c'u' a ti'i a yoc'olcaba. Top qui' u yool etel u ayic'alil. U men abe'e, tan u joc'ol ti'i ti ma'ax c'u' ti qui'il a jabix u c'ati a Dios a tan u yantal ti'iji,— cu t'an a Jesusu. ");
INSERT INTO mopNT_vpl VALUES ("MT13_23","070_13_23","MAT","13","23","23","—Le'ec a jabix a semilla a püc'bi tuba quich'pan a lu'umu, le'ec abe'e, jabix a mac u yubaj u t'an a Dioso. U ch'a'aj u tojil. Ti'i ala'aji, walac u yantal a qui'ili. Tan u yantal u qui'il jabix a püc'aal a tan u tz'eec u wich a cien cuulu, wa a sesenta cuulu, wa a treinta cuulu,— cu t'an a Jesusu. ");
INSERT INTO mopNT_vpl VALUES ("MT13_24","070_13_24","MAT","13","24","24","Pues te'i. Le'ec a Jesusu, u yadaj ulaac' a mucult'an ti'ijoo' a cristianojo. —Le'ec biqui ti walac u tücaa' a Dioso, c'üs quet etel a t'an ada'a. Jun tuul a winiqui, u püc'aj u col etel a semilla a quich'pana,— cu t'an a Jesusu. ");
INSERT INTO mopNT_vpl VALUES ("MT13_25","070_13_25","MAT","13","25","25","—Le'ec ti tanoo' u wüyül a cristianojo, c'ochi u yettz'iiquil u yumil a colo. Tu yaam a semilla a püc'baaniji, u püc'aj a pocche'e, ca' tun bini,— cu t'an a Jesusu. ");
INSERT INTO mopNT_vpl VALUES ("MT13_26","070_13_26","MAT","13","26","26","—Caji ti ch'iil a pocche' etel a püc'aala. Caji to ti joc'ol u wich. Chiclaji ti yan a pocche' tu yaam a püc'aala,— cu t'an a Jesusu. ");
INSERT INTO mopNT_vpl VALUES ("MT13_27","070_13_27","MAT","13","27","27","—Le'ecoo' u yaj meyaja, c'ochoo' etel u yumil a colo. “Noochwinic, ¿ma' wa quich'pan a semilla a püc'aja? ¿C'u' ca'a yan a pocche' tu yaama?” cu t'anoo' ti'i,— cu t'an a Jesusu. ");
INSERT INTO mopNT_vpl VALUES ("MT13_28","070_13_28","MAT","13","28","28","—“Püc'bi te'i u men in wettz'iiquil,” cu t'an u yumil a colo. “¿A c'ati wa ca' xico'on ti jotzo' a pocche'e?” cu t'anoo' ti'i,— cu t'an a Jesusu. ");
INSERT INTO mopNT_vpl VALUES ("MT13_29","070_13_29","MAT","13","29","29","—“Ma' beele'ex a jotzo'. Sabeensil u jotzbol a püc'aal etele,” cu t'an ti'ijoo' u yaj meyaj,— cu t'an a Jesusu. ");
INSERT INTO mopNT_vpl VALUES ("MT13_30","070_13_30","MAT","13","30","30","—“Cha'e'ex u ch'iil asto ti qui'ac u ch'ücbül. Le'ec ca' c'ochoc u q'uinili, bel in quin wadü' ti'ijoo' in waj meyaj ca' u much'quintoo' a pocche' abe'e, ca' u c'üxoo' ti jujun chee ti'i ca' chuwbuc. Le'ec u wich a püc'aala, bel u ca'a taacbül ichil in rancho,” cu t'an u yumil a colo,— cu t'an a Jesus yoc'ol biqui ti walac u tücaa' a Dioso. ");
INSERT INTO mopNT_vpl VALUES ("MT13_31","070_13_31","MAT","13","31","31","Pues te'i. Le'ec a Jesusu, u yadaj ulaac' a mucult'an ti'ijoo' a cristianojo. —Le'ec biqui ti walac u tücaa' a Dioso, c'üs quet etel jun cuul u nec'ix mostazaja. Jun tuul a winiqui, u püc'aj a jun cuul abe' ichil u cuuch u püc'aal,— cu t'an a Jesusu. ");
INSERT INTO mopNT_vpl VALUES ("MT13_32","070_13_32","MAT","13","32","32","—U nec' ix mostazaja, mas tz'itz'i' tuwich ulaac' a püc'aala. C'u' betiqui, ti jobi u ch'iil, le'ec a mas nooch tuwich ulaac' a pocche'e. C'üs jabix che' ti ch'ijiji. Walacoo' u c'ochol a ch'iich' u betoo' u c'u' tu yaam u c'ü',— cu t'an a Jesus yoc'ol biqui ti walac u tücaa' a Dioso. ");
INSERT INTO mopNT_vpl VALUES ("MT13_33","070_13_33","MAT","13","33","33","Pues te'i. Le'ec a Jesusu, u yadaj ulaac' a mucult'an ti'ijoo' a cristianojo. —Le'ec biqui ti walac u tücaa' a Dioso, c'üs quet etel biqui ti walac u yaabtal a levaduraja. Jun tuul a nooch'upu, u much'quintaj jabix jun xoot' costal ti harina ti'i u betical a pana. U tz'aj a levadura ichil ti'i ca' u xaabte u bajil tulacal ichil,— cu t'an a Jesusu. ");
INSERT INTO mopNT_vpl VALUES ("MT13_34","070_13_34","MAT","13","34","34","Pues te'i. Tulacal abe' u yadaj a Jesus ti'ijoo' a cristiano ich mucult'an. Ma'ax c'u' a wa ma' u yadaj ti'ijoo' ich mucult'an. ");
INSERT INTO mopNT_vpl VALUES ("MT13_35","070_13_35","MAT","13","35","35","Te'i jajaji u t'an jun tuul u yadaj u t'an a Dios uchi. —“Le'ec ca' c'ochoc u q'uinili, bel in quin wadü' c'u' a muca'an asto ti u cajeeb a yoc'olcaba. Bel in quin wadü' abe' ich mucult'an,” cu t'an a Dioso,— cu t'an a jun tuul abe'e. ");
INSERT INTO mopNT_vpl VALUES ("MT13_36","070_13_36","MAT","13","36","36","Pues te'i. Joq'ui a Jesus tu yaamoo' u yaabil a cristianojo. Oqui ich naj. C'ochoo' u yaj cambal etel. —Adü to'on u nu'cul a mucult'an yoc'ol a pocche' a püc'bi tu yaam a püc'aala,— cu t'anoo' ti'i a Jesusu. ");
INSERT INTO mopNT_vpl VALUES ("MT13_37","070_13_37","MAT","13","37","37","—Le'ec mac tan u püq'uic a quich'pan semillaja, inen le'ec a yanajeen ti cristianojil,— cu t'an a Jesusu. ");
INSERT INTO mopNT_vpl VALUES ("MT13_38","070_13_38","MAT","13","38","38","—Le'ec a jabix a col abe'e, le'ec a yoc'olcaba. Le'ec a jabix a semilla a quich'pan abe'e, le'ecoo' a cristiano a ti'i a Dioso. Le'ec a jabix a pocche'e, le'ecoo' a cristiano a ti'i a quisini,— cu t'an a Jesusu. ");
INSERT INTO mopNT_vpl VALUES ("MT13_39","070_13_39","MAT","13","39","39","—Le'ec u yettz'iiquil u yumil a colo, le'ec u püc'aj a pocche' te'i. Ala'aji, a quisini. Le'ec a jabix u q'uinil u much'quinbeeb a püc'aala, le'ec u q'uinil u jobeeb a yoc'olcaba. Le'ecoo' a jabix in waj meyaja, le'ecoo' u yaj xa'num a Dios ti ca'ana,— cu t'an a Jesusu. ");
INSERT INTO mopNT_vpl VALUES ("MT13_40","070_13_40","MAT","13","40","40","—Jabix ilic ti much'quinbi a pocche' y chuwi ich c'aac', baalo' ilic a bel u ca'a ti uchul ti'i u jobeeb a yoc'olcaba,— cu t'an a Jesusu. ");
INSERT INTO mopNT_vpl VALUES ("MT13_41","070_13_41","MAT","13","41","41","—Le'ec inen a yanajeen ti cristianojili, bel in quin tücaa'te u yaj xa'num a Dios ti ca'ana. Beloo' u cu much'quinte y beloo' u cu joq'ues ichil in cuenta boon tuul mac a walacoo' u tz'eec ca' betabüc a c'as u yet'ocoo' a walacoo' u betic a c'asa,— cu t'an a Jesusu. ");
INSERT INTO mopNT_vpl VALUES ("MT13_42","070_13_42","MAT","13","42","42","—Beloo' u ca'a pulbul ichil a c'aac' a top chücüj u yoox u menoo' u yaj xa'num a Dios ti ca'ana. Te'i u yoc'oloo' y jürütlemacoo' xan u coj u menoo' u yajil,— cu t'an a Jesusu. ");
INSERT INTO mopNT_vpl VALUES ("MT13_43","070_13_43","MAT","13","43","43","—Pues te'i. Le'ec ti pulboo' te'i, le'ecoo' a toj u na'ata, beloo' u ca'a ti chictal u sasilil jabix ilic u sac a q'uin tu cuentajoo' ti Tat. Le'ec mac patal u yubi in t'ana, yan u tz'eec tu yool,— cu t'an a Jesusu. ");
INSERT INTO mopNT_vpl VALUES ("MT13_44","070_13_44","MAT","13","44","44","—Pues te'i. Le'ec biqui ti walac u tücaa' a Dioso, c'üs quet etel a mucult'an ada'a. C'üs quet etel jabix c'u'ac a top co'oj u tool a muca'an ich lu'umu. Cüxtabi u men jun tuul winic y te'i ilic u ca' mucaj. Top qui' u yool. Bini u cono' tulacal a c'u' a yan ti'iji, ti'i ca' yanac u tool a lu'umu. U q'uexaj a lu'um abe' ti'i ca' p'aatüc ti'i abe' a top co'oj u toolo,— cu t'an a Jesus yoc'ol biqui ti walac u tücaa' a Dioso. ");
INSERT INTO mopNT_vpl VALUES ("MT13_45","070_13_45","MAT","13","45","45","—Pues te'i. Le'ec biqui ti walac u tücaa' a Dioso, c'üs quet etel a mucult'an ada'a. Jun tuul aj men negociojo, tan u manül u q'uexe' a c'aap a quich'pana,— cu t'an a Jesusu. ");
INSERT INTO mopNT_vpl VALUES ("MT13_46","070_13_46","MAT","13","46","46","—Jun p'eel q'uin u cüxtaj jun cuul a top co'oj u toolo. Bini u cono' tulacal a c'u' a yan ti'iji, ti'i ca' yanac u tool a c'aap abe'e. U q'uexaj,— cu t'an a Jesusu. ");
INSERT INTO mopNT_vpl VALUES ("MT13_47","070_13_47","MAT","13","47","47","—Pues te'i. Le'ec biqui ti walac u tücaa' a Dioso, c'üs quet etel a mucult'an ada'a. C'üs quet etel a chinchor a pulbi ich ja' ti'i müch cüy. Müchbi a cüy a yaab paay u wichi,— cu t'an a Jesusu. ");
INSERT INTO mopNT_vpl VALUES ("MT13_48","070_13_48","MAT","13","48","48","Le'ec ti tudi u müchbeeb a cüy abe'e, jiilbi chi' ja' u menoo' a winiqui. Tinlajoo' u yeete a quich'pan cüyü. U tz'ajoo' ichil u cuuchil. Boon a cüy a ma' qui'i, u pulajoo',— cu t'an a Jesusu. ");
INSERT INTO mopNT_vpl VALUES ("MT13_49","070_13_49","MAT","13","49","49","—Baalo' ti bel u ca'a ti uchul ti'i u jobeeb a yoc'olcaba. Udeloo' u ca'a u yaj xa'num a Dios ti ca'ana. Beloo' u cu joq'ues tu bajil a c'as etel a toj u na'ata. ");
INSERT INTO mopNT_vpl VALUES ("MT13_50","070_13_50","MAT","13","50","50","Le'ecoo' a c'asa, beloo' u ca'a pulbul ichil a c'aac' a top chücüj u yoox u menoo' u yaj xa'num a Dios ti ca'ana. Te'i u yoc'oloo' y jürütlemacoo' u coj u menoo' u yajil,— cu t'an a Jesusu. ");
INSERT INTO mopNT_vpl VALUES ("MT13_51","070_13_51","MAT","13","51","51","—Pues te'i. ¿A ch'a'aje'ex wa u tojil tulacal a t'an in wadaj to te'exe?— cu t'an a Jesus ti'ijoo' u yaj cambal. —Ti ch'a'aj u tojil,— cu t'anoo' ti'i. ");
INSERT INTO mopNT_vpl VALUES ("MT13_52","070_13_52","MAT","13","52","52","—Tulacaloo' u yaj ca'ansajil u ley aj Moises a ocoo' ti'i in waj cambala, tanoo' u cünic biqui ti walac u tücaa' a Dioso. Ala'oo'o, jabixoo' u yumil a naja. Le'ec u t'an Dios u yeele, jabix u ayic'alili. Tu yaam u ayic'alil walac u joc'sic a c'u' a tumulben etel a c'u' a uchbene,— cu t'an a Jesusu. ");
INSERT INTO mopNT_vpl VALUES ("MT13_53","070_13_53","MAT","13","53","53","Pues te'i. Le'ec ti jobi u yadic tulacal a mucult'an abe'e, joq'ui te'i a Jesusu. ");
INSERT INTO mopNT_vpl VALUES ("MT13_54","070_13_54","MAT","13","54","54","Bini tuba ch'iji. U ca'ansajoo' a cristiano ichil a naj tuba walacoo' u much'tal u c'ajes a Dioso. Sa'too' u yool a cristianojo. —¿Tuba u cünaj a c'u' u yeele? ¿Tuba u cünaj u bete' a milagrojo?— cu t'anoo' tu bajil. ");
INSERT INTO mopNT_vpl VALUES ("MT13_55","070_13_55","MAT","13","55","55","—¿Ma' wa le'ec ala'i u mejen aj carpinterojo? ¿Ma' wa ix Maria u c'aba' u na'? ¿Ma' wa le'ecoo' u yitz'in, le'ec aj Jacob, aj Jose, aj Simon, aj Judasa?— cu t'anoo' tu bajil. ");
INSERT INTO mopNT_vpl VALUES ("MT13_56","070_13_56","MAT","13","56","56","—¿Ma' wa que'enoo' ich caj u yix ch'upul itz'in a Jesusu? ¿Tuba tali ala'i ti'i ca' u cünü' boon u yeele?— cu t'anoo' tu bajil. ");
INSERT INTO mopNT_vpl VALUES ("MT13_57","070_13_57","MAT","13","57","57","Ma' c'ocha'anoo' tu wich ti top patal a Jesusu. —Le'ec a tz'abi u yanil u yadü' u t'an a Dioso, walac u tz'ocsabül u yanil ca'ax tubajac. C'u' betiqui, ichil u caal wa ichil u yotocho, ma' ta'ach u tz'ocsabül u yanil,— cu t'an a Jesus ti'ijoo'o. ");
INSERT INTO mopNT_vpl VALUES ("MT13_58","070_13_58","MAT","13","58","58","Ma' u betaj ti yaab a milagro te'i u men ma' u c'atiintajoo' u tz'oques u t'an. ");
INSERT INTO mopNT_vpl VALUES ("MT14_1","070_14_1","MAT","14","1","1","Pues te'i. Ti a q'uin abe'e, que'en aj Herodes ti gobernadoril cuenta Galilea. U yubaj c'u' a tan u betic a Jesusu. ");
INSERT INTO mopNT_vpl VALUES ("MT14_2","070_14_2","MAT","14","2","2","—Le'ec a Jesusu, le'ec ilic aj Juan aj tz'aj ocja'a. Ca' cuxquinbi tu yaam a quimene, mentücü, yan u muc' u bete' a milagrojo,— cu t'an aj Herodes ti'ijoo' u yaj meyaj. ");
INSERT INTO mopNT_vpl VALUES ("MT14_3","070_14_3","MAT","14","3","4","Baalo' u betaj aj Herodes ti'i aj Juan biq'uin ado'o. Le'ec aj Herodese, u ch'a'aj ixna' Herodiasa. U yütan aj Felipe abe'e. Aj Felipeje, u yitz'in aj Herodes. —Ma' qui' a ch'a'ic a mu',— cu t'an aj Juan ti'iji, mentücü, u tücaa'taj müchbül. C'üxbi aj Juana. Tz'abi ti presojil. ");
INSERT INTO mopNT_vpl VALUES ("MT14_5","070_14_5","MAT","14","5","5","Ca'ax u c'ati u quimes aj Juana, saac aj Herodes ti'ijoo' a cristianojo. Ala'oo'o, walacoo' u tz'ocsic ti le'ec aj Juana, jun tuul a walac u yadic u t'an a Dioso. ");
INSERT INTO mopNT_vpl VALUES ("MT14_6","070_14_6","MAT","14","6","6","Pues te'i. C'ochi u q'uinil u q'uinc'aba' aj Herodese. Uchi u yoc'ot u yal ixna' Herodias tu taanoo' aj sutil te'i. Qui' u yool aj Herodes ti uchi u yoc'ot ala'aji. ");
INSERT INTO mopNT_vpl VALUES ("MT14_7","070_14_7","MAT","14","7","7","U tz'aj u t'an ti'i ix chu' ca' u tz'aa' ti'i le'ec a c'u' u c'ati u c'aateje. ");
INSERT INTO mopNT_vpl VALUES ("MT14_8","070_14_8","MAT","14","8","8","Le'ec u na'a, u yadaj ti'i c'u' a cu c'aateje. —Ca' tz'aa' ten wa'ye' tuwich noxi' plato u pol aj Juan aj tz'aj ocja'a,— cu t'an ix chu' ti'i aj Herodese. ");
INSERT INTO mopNT_vpl VALUES ("MT14_9","070_14_9","MAT","14","9","9","Yajaji u yool a reye. C'u' betiqui, chen u men u tz'aj u t'an tu taanoo' u yaj sutil, u yadaj ca' tz'abüc ti'i c'u' a tan u c'aatic ix chu'u. ");
INSERT INTO mopNT_vpl VALUES ("MT14_10","070_14_10","MAT","14","10","10","U tücaa'taj ca' ch'ücbüc u cal aj Juan ich preso. ");
INSERT INTO mopNT_vpl VALUES ("MT14_11","070_14_11","MAT","14","11","11","Talesabi u pol tuwich noxi' plato. Tz'abi ti'i ix chu'u. U bensaj ti'i u na'. ");
INSERT INTO mopNT_vpl VALUES ("MT14_12","070_14_12","MAT","14","12","12","Le'ecoo' u yaj cambal aj Juana, c'ochoo' u ch'aa' u büq'uel. U mucajoo'. Binoo' etel a Jesusu. U tzolajoo' c'u' a maniji. ");
INSERT INTO mopNT_vpl VALUES ("MT14_13","070_14_13","MAT","14","13","13","Pues te'i. Le'ec ca' u yubaj abe' a Jesusu, joq'ui te'i. Oqui ich barco. Bini ichil a p'atal lu'um tuba ma' yanoo' a cristianojo. C'u' betic a cristianojo, u yubajoo' tuba tan u beel a Jesusu. Joc'oo' ichil boon a caj a yan te'iji. Binoo' ti oc tac tuba tan u beel a Jesusu. ");
INSERT INTO mopNT_vpl VALUES ("MT14_14","070_14_14","MAT","14","14","14","Pues te'i. Joq'ui a Jesus ichil a barcojo. Bini chi' a ja'a. U yilaj u yaabil a cristiano te'iji. U ch'a'ajoo' u yotzilil. U ch'anesajoo' boon tuul a c'oja'an a yan tu yaamoo'o. ");
INSERT INTO mopNT_vpl VALUES ("MT14_15","070_14_15","MAT","14","15","15","Tan u yocol a q'uini. Naatz'oo' u yaj cambal tu tzeel. —P'atal lu'um tuba que'eno'on. Ma'ax mac a yan wa'ye'e. Mani tun a q'uini, mentücü, tücaa'too' u yaabil a crisitano ich aldea u q'uexoo' u janal,— cu t'anoo' u yaj cambal ti'i a Jesusu. ");
INSERT INTO mopNT_vpl VALUES ("MT14_16","070_14_16","MAT","14","16","16","—Ma' tzajoo' u beeli,— cu t'an a Jesusu. —Inche'ex ca' a tz'a'e'exoo' u janal,— cu t'an a Jesusu. ");
INSERT INTO mopNT_vpl VALUES ("MT14_17","070_14_17","MAT","14","17","17","—Jadi' cinco cuul pan y ca' tuul aj ch'ilam a yan wa'ye'e,— cu t'anoo' ti'i a Jesusu. ");
INSERT INTO mopNT_vpl VALUES ("MT14_18","070_14_18","MAT","14","18","18","—Tales ten wa'ye',— cu t'an ti'ijoo'. ");
INSERT INTO mopNT_vpl VALUES ("MT14_19","070_14_19","MAT","14","19","19","Le'ec a Jesusu, u yadaj ti'ijoo' u yaabil a cristiano ca' tinlacoo' tuwich a su'ucu. U müchaj a cinco cuul pan etel a ca' tuul aj ch'ilama. U cha'antaj a ca'ana. U c'ajsaj a Dios yoc'ol a janala. U meen xet'aj. U tz'aj a pan ti'ijoo' u yaj cambal. U t'oxajoo' ti'i a cristianojo. ");
INSERT INTO mopNT_vpl VALUES ("MT14_20","070_14_20","MAT","14","20","20","Laj janoo', y na'ajnoo'. Le'ecoo' u yaj cambala, u tudesajoo' doce cuul a nucuch xac etel u yaabil u yada' a janala. ");
INSERT INTO mopNT_vpl VALUES ("MT14_21","070_14_21","MAT","14","21","21","Le'ec boon a janoo'o, jabix cinco mil tuul ti winic. Ma' xoca'anoo' ix ch'up eteloo' a tz'ubi. ");
INSERT INTO mopNT_vpl VALUES ("MT14_22","070_14_22","MAT","14","22","22","Pues te'i. Le'ec a Jesusu, u yadaj ti'ijoo' u yaj cambal ca' ococoo' ich barco ca' paye' xicoo' junxeel a lagunaja. Ala'aji, bel u cu yadü' ti'ijoo' u yaabil a cristiano ca' usc'acoo'. ");
INSERT INTO mopNT_vpl VALUES ("MT14_23","070_14_23","MAT","14","23","23","Le'ec ti jobi u yadic ti'ijoo' a cristiano ca' usc'acoo'o, naq'ui a Jesus pol witz tu junal ti t'an etel a Dioso. Le'ec ti oqui a ac'ü'ü, te'i ilic que'en tu junal. ");
INSERT INTO mopNT_vpl VALUES ("MT14_24","070_14_24","MAT","14","24","24","Le'ec a barcojo, ac naachaji tun chi' ja'. Tan u jütz'bül a barco u men u tz'iiquil a ja'a, u men tu toja'an ic' tanoo' u beel. ");
INSERT INTO mopNT_vpl VALUES ("MT14_25","070_14_25","MAT","14","25","25","Le'ec ti ac'ü' to u sastala, tan u c'ochol a Jesus eteloo' u yaj cambal. Tan u ximbal yoc'ol a ja'a. ");
INSERT INTO mopNT_vpl VALUES ("MT14_26","070_14_26","MAT","14","26","26","Le'ecoo' u yaj cambala, u yilajoo' ti tan u ximbal a Jesus yoc'ol a ja'a. Jac'oo' u yool tu jajil. —Jedo' a pixana,— cu t'anoo' tu bajil. Uchoo' u yawat u menoo' u saaquil. ");
INSERT INTO mopNT_vpl VALUES ("MT14_27","070_14_27","MAT","14","27","27","Tu seebal uchi u t'an a Jesus eteloo'o. —Chichcunte'ex a wool. Ma' a saactale'ex. Inen ilic,— cu t'an a Jesus ti'ijoo'o. ");
INSERT INTO mopNT_vpl VALUES ("MT14_28","070_14_28","MAT","14","28","28","—Noochil, wa jaj ti le'ec incheche, adü ca' talaquen ta wetel,— cu t'an aj Pedro ti'iji. ");
INSERT INTO mopNT_vpl VALUES ("MT14_29","070_14_29","MAT","14","29","29","—Co'on,— cu t'an ti'i aj Pedrojo. Joq'ui aj Pedro ichil a barcojo. Caji ti ximbal tuwich a ja'a. Tan u beel etel a Jesusu. ");
INSERT INTO mopNT_vpl VALUES ("MT14_30","070_14_30","MAT","14","30","30","C'u' betiqui, u yilaj ti top tan a iq'ui. Saacaji. Caji ti joomol ichil a ja'a. —Noochil, sa'alteen,— cu t'an ti'i ti chich. ");
INSERT INTO mopNT_vpl VALUES ("MT14_31","070_14_31","MAT","14","31","31","Le'ec a Jesusu, u jan müchtaj etel u c'ü'. —Tz'etz'eec ilic que'en a wool pach a Dioso. ¿C'u' ca'a saacajeech?— cu t'an a Jesus ti'iji. ");
INSERT INTO mopNT_vpl VALUES ("MT14_32","070_14_32","MAT","14","32","32","Le'ec ti ocoo' ichil a barcojo, mani a iq'ui. ");
INSERT INTO mopNT_vpl VALUES ("MT14_33","070_14_33","MAT","14","33","33","Le'ecoo' a que'en ichil a barcojo, xonlajoo' tu taan a Jesusu. —Tu jajil inchech u Mejenech a Dioso,— cu t'anoo' ti'i. ");
INSERT INTO mopNT_vpl VALUES ("MT14_34","070_14_34","MAT","14","34","34","Pues te'i. Le'ec ti manoo' junxeel a ja'a, c'ochoo' tuba que'en a jooc u c'aba' Genesaret. ");
INSERT INTO mopNT_vpl VALUES ("MT14_35","070_14_35","MAT","14","35","35","Le'ecoo' a que'enoo' te'iji, le'ec ca' u c'aj-ooltajoo' u wich a Jesusu, u tücaa'tajoo' u pectzil ca'ax tubajac te'i ca' talesabücoo' boon tuul a c'oja'ana. ");
INSERT INTO mopNT_vpl VALUES ("MT14_36","070_14_36","MAT","14","36","36","U c'aatajoo' ti'i ca' u cha'oo' u tülic ca'ax jadi' u chi' u noc' ti'i ca' ch'anücoo'. Le'ec boon tuul u tülaja, ch'anesaboo'. ");
INSERT INTO mopNT_vpl VALUES ("MT15_1","070_15_1","MAT","15","1","1","Pues te'i. C'ochoo' etel a Jesus a fariseo u c'aba'oo' u na'at u yet'ocoo' u yaj ca'ansajil u ley aj Moisese. Taloo' ala'oo' ich caj Jerusalen. ");
INSERT INTO mopNT_vpl VALUES ("MT15_2","070_15_2","MAT","15","2","2","—Le'ecoo' a waj cambala, ¿c'u' ca'a ma' ta'achoo' u tz'ocsic a p'ütbi to'on u menoo' a uchben cristianojo?— cu t'anoo' ti'i a Jesusu. —Le'ec ti tanoo' u p'o'ic u c'ü' ti'i ca' xicoo' ti janala, ma' ta'achoo' u qui' p'o'ic u c'ü' jabix u yadajoo' a uchben cristiano ca' ti bete',— cu t'anoo' ti'i a Jesusu. ");
INSERT INTO mopNT_vpl VALUES ("MT15_3","070_15_3","MAT","15","3","3","—Uxtun inche'exe, ¿c'u' ca'a a p'ütaje'ex a tz'ocsic u t'an a Dios ti'i a tz'ocsicale'ex a c'u' u p'ütajoo' a uchbene?— cu t'an a Jesus ti'ijoo'o. ");
INSERT INTO mopNT_vpl VALUES ("MT15_4","070_15_4","MAT","15","4","4","—“Tz'oques u yanil a na' a tat,” cu t'an a Dioso. “Le'ec mac ca' u yadü' a c'as yoc'ol u na' u tata, yan u quimsabül,” cu t'an a Dioso,— cu t'an a Jesus ti'ijoo'o. ");
INSERT INTO mopNT_vpl VALUES ("MT15_5","070_15_5","MAT","15","5","5","—C'u' betiqui, ma' baalo' a t'ane'exi. Le'ec ti walac u c'ochol u na' u tat a mac u c'aate ti'i ca' aantabücü, baala' a walaque'ex a wadiqui. “Wa ca' u yadü' ti'i u na' u tat ti ac sijibi tun ti'i a Dios le'ec c'u' a tanoo' u c'aatic ca' aantabücoo' etele, ");
INSERT INTO mopNT_vpl VALUES ("MT15_6","070_15_6","MAT","15","6","6","ma' tzaj u yaanticoo' u na' u tat etel a c'u' a tanoo' u c'aatiqui,” que'ex,— cu t'an a Jesusu. —Ti baalo'o, chen yoc'lal a c'u' u p'ütajoo' a uchbene, a tz'aje'ex jabix ma' yan u yanil u t'an a Dioso,— cu t'an a Jesusu. ");
INSERT INTO mopNT_vpl VALUES ("MT15_7","070_15_7","MAT","15","7","7","—Aj cho'e'ex, toj u yadaj aj Isaias ta woc'ole'ex,— cu t'an a Jesusu. ");
INSERT INTO mopNT_vpl VALUES ("MT15_8","070_15_8","MAT","15","8","8","—“Le'ec a cristiano ada'a, walacoo' u yadic jabix tanoo' u tz'ocsic in yanil. C'u' betiqui, naach que'en u tucul,” cu t'an a Dioso. ");
INSERT INTO mopNT_vpl VALUES ("MT15_9","070_15_9","MAT","15","9","9","“Ma'ax c'u' aj beel ti tanoo' u c'ajsiquen. Walacoo' u ca'ansic a cristiano etel a t'an a chen cuxquinbi u menoo' a cristianojo,” cu t'an a Dioso. Baalo' u yadaj aj Isaias ta woc'ole'exe,— cu t'an a Jesusu. ");
INSERT INTO mopNT_vpl VALUES ("MT15_10","070_15_10","MAT","15","10","10","Pues te'i. Le'ec a Jesusu, u püyajoo' a cristiano ca' jiisicoo' tu tzeel. —U'yeene'ex y ch'a'e'ex u tojil,— cu t'an a Jesus ti'ijoo'o. ");
INSERT INTO mopNT_vpl VALUES ("MT15_11","070_15_11","MAT","15","11","11","—Ma' le'ec a walac u yocol ichil u chi' walac u c'ascuntic u na'at a maca. Le'ec a walac u joc'ol ichil u chi' a maca, le'ec a walac u c'ascunaja,— cu t'an a Jesusu. ");
INSERT INTO mopNT_vpl VALUES ("MT15_12","070_15_12","MAT","15","12","12","Pues te'i. Naatz'oo' u yaj cambal tu tzeel. —¿Ma' wa a weel ti tz'iicajoo' a fariseo u c'aba'oo' u na'at le'ec ca' u yubajoo' a t'an a wadaj to ti'ijoo'o?— cu t'anoo' ti'i a Jesusu. ");
INSERT INTO mopNT_vpl VALUES ("MT15_13","070_15_13","MAT","15","13","13","—Tulacal a püc'aal a ma' in Tat u püc'aja, bel u ca'a jotz'bol,— cu t'an a Jesus yoc'ol a ley u tz'aj a Dioso, y a ley u cuxquintaj a cristianojo. ");
INSERT INTO mopNT_vpl VALUES ("MT15_14","070_15_14","MAT","15","14","14","—P'ütoo' ti'i. Ala'oo'o, jabix a ch'oop a tan u bensic u yetch'oopili. Le'ec ti tan u bensabül a ch'oop u men u yetch'oopili, beloo' u ca'a ti c'axül ich ch'e'en tu ca' tuulil,— cu t'an a Jesus ti'ijoo' u yaj cambal. ");
INSERT INTO mopNT_vpl VALUES ("MT15_15","070_15_15","MAT","15","15","15","Pues te'i. Le'ec aj Pedrojo, u c'aataj ti'i a Jesusu. —Adü to'on u nu'cul a mucult'an a wadaj yoc'ol c'u' a walac u c'ascuntic u na'at a maca,— cu t'an ti'i. ");
INSERT INTO mopNT_vpl VALUES ("MT15_16","070_15_16","MAT","15","16","16","—¿Ma'ax wa inche'ex a ch'a'e'ex u tojil?— cu t'an a Jesusu. ");
INSERT INTO mopNT_vpl VALUES ("MT15_17","070_15_17","MAT","15","17","17","—¿Ma' wa chica'an te'ex? Le'ec a walac u yocol ichil u chi' a maca, walac u beel ichil u nüc' ca' tun chen walac u manül,— cu t'an a Jesusu. ");
INSERT INTO mopNT_vpl VALUES ("MT15_18","070_15_18","MAT","15","18","18","—C'u' betiqui, le'ec a walac u joc'ol ichil u chi' a maca, tan u talel ichil u püsüc'al. Le'ec abe' walac u c'ascuntic u na'at a maca,— cu t'an a Jesusu. ");
INSERT INTO mopNT_vpl VALUES ("MT15_19","070_15_19","MAT","15","19","19","—Ichil u püsüc'al a maca, walac u tal a c'ac'as tuculu. Te'i walac u tal a tucul ti quimsaj. Te'i walac u tal a tucul ti cüjtal etel ca'ax macac, etel tulacal a c'ac'as tucul a jabix abe'e. Te'i walac u tal a tucul ti xuuch', ti tzol yoc'ol tus, ti maclant'an,— cu t'an a Jesusu. ");
INSERT INTO mopNT_vpl VALUES ("MT15_20","070_15_20","MAT","15","20","20","—Le'ec a jabix abe'e, walac u c'ascuntic u na'at a maca. Le'ec ca' janüc ti ma' p'o'a'an u c'ü' a mac jabix u yadajoo' a fariseo u c'aba'oo' u na'ata, ma' tu c'ascuntic u na'ati,— cu t'an a Jesusu. ");
INSERT INTO mopNT_vpl VALUES ("MT15_21","070_15_21","MAT","15","21","21","Pues te'i. Joq'ui a Jesusu. Bini ich cuenta Tiro y Sidon. ");
INSERT INTO mopNT_vpl VALUES ("MT15_22","070_15_22","MAT","15","22","22","Jun tuul a nooch'up te'iji, c'ochi etel a Jesusu. Ix cananea ala'aji, u men te'i u caal. —Noochil, inchech u mam aj quimen rey David a tan u paac'bül. Ch'a'a in wotzilil. Que'en a c'ac'asba'al tu yool in wix chu'u. Top tan u c'ümic a yaj u men a c'ac'asba'al abe'e,— cu t'an ti'i a Jesus ti chich. ");
INSERT INTO mopNT_vpl VALUES ("MT15_23","070_15_23","MAT","15","23","23","Le'ec a Jesusu, ma' uchi u nuuc jumpul. Naatz'oo' u yaj cambal tu tzeel a Jesusu. —Adü ti'i ix ch'up ada' ca' xi'ic. Top choconac tiqui pach,— cu t'anoo' ti'i a Jesusu. ");
INSERT INTO mopNT_vpl VALUES ("MT15_24","070_15_24","MAT","15","24","24","—Jadi' tücaa'been ti'ijoo' aj Israel le'ec a jabix carnero a sa'taloo'o,— cu t'an a Jesus ti uchi u nuuc. ");
INSERT INTO mopNT_vpl VALUES ("MT15_25","070_15_25","MAT","15","25","25","Naatz'i a nooch'upu. Xonlaji tu taan. —Noochil, aanteen,— cu t'an ti'i a Jesusu. ");
INSERT INTO mopNT_vpl VALUES ("MT15_26","070_15_26","MAT","15","26","26","—Ma' toj ca' tocboc a waj ti'i a tz'ub ca' pulbuc ti'i a peq'ui,— cu t'an a Jesus ti'i u men ma' Israel ala'aji. ");
INSERT INTO mopNT_vpl VALUES ("MT15_27","070_15_27","MAT","15","27","27","—Jaj a t'an, Noochil. C'u' betiqui, yalam u mesa u yumil walac u c'axül u xeex a waja. Walac u c'ochol u pec' u jante,— cu t'an a nooch'upu. ");
INSERT INTO mopNT_vpl VALUES ("MT15_28","070_15_28","MAT","15","28","28","—Nooch'up, top tan a tz'ocsic tu jajil ti patalen, mentücü, ca' uchuc tech jabix ilic a c'ati,— cu t'an a Jesus ti'iji. Tu seebal joq'ui a c'ac'asba'al tu yool u yala. Ch'ani. ");
INSERT INTO mopNT_vpl VALUES ("MT15_29","070_15_29","MAT","15","29","29","Pues te'i. Joq'ui a Jesusu. Caji ti manül jalchi' a laguna Galilea. Naq'ui tuwich witz. Tinlaji te'i. ");
INSERT INTO mopNT_vpl VALUES ("MT15_30","070_15_30","MAT","15","30","30","Yaaboo' a cristiano a nac'oo' tu pacha. U c'ochesajoo' a ma' qui'oo' u ximbala, a ma' chuculoo' u c'ü' wa u yoc, a ch'oopoo', a besoo', tulacal. Tz'aboo' tu taan a Jesusu. U ch'anesajoo'. ");
INSERT INTO mopNT_vpl VALUES ("MT15_31","070_15_31","MAT","15","31","31","Sa'too' u yool a cristiano ca' u yilajoo' ti tanoo' u t'an a bese, ti chuculajoo' u c'ü' u yoc a ma' yanoo' u c'ü' wa u yoco, ti tanoo' u ximbal a ma' qui'oo' u ximbala, ti tanoo' u cha'an a ch'oopo. U yadajoo' u qui'il u Diosil u caal aj Israele. ");
INSERT INTO mopNT_vpl VALUES ("MT15_32","070_15_32","MAT","15","32","32","Pues te'i. Le'ec a Jesusu, u püyajoo' u yaj cambal. —Otziloo' tin wich a cristiano ada'a. Ox p'e q'uin que'enoo' tin wetel y ma'ax c'u' a yan ca' u jantoo'. Ma' in c'ati cuchi in tücaa'too' ca' usc'acoo' ti wi'ijoo'. Bic xicoo' ti sücquimil taniloo' u yusc'al,— cu t'an a Jesus ti'ijoo' u yaj cambal. ");
INSERT INTO mopNT_vpl VALUES ("MT15_33","070_15_33","MAT","15","33","33","—Que'eno'on ich p'atal lu'um. Ino'ono, ¿tuba ca' ti cüxte ti chucul a janal ti'i ca' ti tzeentoo' u yaabil a cristiano ada'a?— cu t'anoo' ti'i a Jesusu. ");
INSERT INTO mopNT_vpl VALUES ("MT15_34","070_15_34","MAT","15","34","34","—¿Boon cuul a pan a yan te'exe?— cu t'an a Jesus ti'ijoo'o. —Siete cuul a pan a yana, y tz'etz'eec ilic aj meen ch'ilam,— cu t'anoo' ti'i a Jesusu. ");
INSERT INTO mopNT_vpl VALUES ("MT15_35","070_15_35","MAT","15","35","35","U yadaj ca' tinlacoo' a cristiano ti lu'um. ");
INSERT INTO mopNT_vpl VALUES ("MT15_36","070_15_36","MAT","15","36","36","U müchaj a siete cuul a pan etel aj meen ch'ilama. Le'ec ca' u tz'aj a bo'tic ti'i a Dioso, u meen xet'aj. U tz'aj ti'ijoo' u yaj cambal. Le'ecoo' u yaj cambala, u t'oxajoo' ti'i a cristianojo. ");
INSERT INTO mopNT_vpl VALUES ("MT15_37","070_15_37","MAT","15","37","37","Laj janoo' y na'ajnoo'. Le'ecoo' u yaj cambala, u tudesajoo' siete cuul a xac etel u yaabil u yada' a janal a meen xet'a'ana. ");
INSERT INTO mopNT_vpl VALUES ("MT15_38","070_15_38","MAT","15","38","38","Le'ec boon a janoo'o, jabix cuatro mil tuul ti winic. Ma' xoca'anoo' ix ch'up etel a tz'ubu. ");
INSERT INTO mopNT_vpl VALUES ("MT15_39","070_15_39","MAT","15","39","39","Pues te'i. Le'ec a Jesusu, u tücaa'tajoo' a cristiano ca' usc'acoo', ca' tun oqui ichil a barcojo. Bini tu cuenta Magdala. ");
INSERT INTO mopNT_vpl VALUES ("MT16_1","070_16_1","MAT","16","1","1","Pues te'i. C'ochoo' etel a Jesus a fariseo u c'aba'oo' u na'at u yet'ocoo' a saduceo u c'aba'oo' u na'ata. Ti'i u yilicaloo' wa patal a Jesusu, u c'aatajoo' ti'i ca' u bete' a milagro ti ca'an. ");
INSERT INTO mopNT_vpl VALUES ("MT16_2","070_16_2","MAT","16","2","2","—Le'ec ti tane'ex a wilic ti chüc a ca'an ti ocq'uini, walaque'ex a wadic ti quich'pan a q'uin a wataca,— cu t'an a Jesus ti'ijoo'o. ");
INSERT INTO mopNT_vpl VALUES ("MT16_3","070_16_3","MAT","16","3","3","—Le'ec ti tane'ex a wilic ti chüc a ca'an ti jatz'ca' y box a muyala, walaque'ex a wadic ti aleebe, watac a ja'a,— cu t'an a Jesusu. —Aj cho'e'ex, a weele'ex biqui ca' a na'te u wich a ca'ana. C'u' betiqui, ma' a weele'ex biqui ca' a na'te c'u' a tan u ye'ic u p'is yoc'ol u q'uinil a wataca, le'ec a mas c'abeete,— cu t'an a Jesusu. ");
INSERT INTO mopNT_vpl VALUES ("MT16_4","070_16_4","MAT","16","4","4","—Aleebe top c'asoo' a cristianojo. Ca'ax c'u'ac u betoo'. U p'ütajoo' u c'ajsic a Dios ti ca'an ti'i ca' u c'ajesoo' a ca'ax c'u'ac ti diosili. Le'ec a jabix ala'oo'o, walacoo' u c'aatic ca' betabüc c'u'ac ti'i ca' chiclac in yanil,— cu t'an a Jesusu. —Ma' tu ye'bel ti'ijoo' a milagro a jabix u c'atoo'o. Jadi' a jabix a c'u' a uchi ti'i aj Jonasa, jadi' bel u ca'a ye'bel ti'ijoo'o,— cu t'an a Jesus ti'ijoo'o. Le'ec ti jobi u yadic abe'e, joq'ui a Jesus tu yaamoo'. Bini u yet'ocoo' u yaj cambal. ");
INSERT INTO mopNT_vpl VALUES ("MT16_5","070_16_5","MAT","16","5","5","Pues te'i. Tuboo' ti'i u yaj cambal u ch'a'icoo' u pan. C'ochoo' junxeel a ja'a. ");
INSERT INTO mopNT_vpl VALUES ("MT16_6","070_16_6","MAT","16","6","6","—Cününte'ex a bajil ti'i ma' a cho'bole'ex u men u levadura a fariseo etel a saduceo u c'aba'oo' u na'ata,— cu t'an a Jesus ti'ijoo'o. ");
INSERT INTO mopNT_vpl VALUES ("MT16_7","070_16_7","MAT","16","7","7","Le'ecoo' u yaj cambala, cajoo' u tzicbalte a t'an abe' tu bajiloo'. —U yadaj wal abe' u men ma' ti bensaj a pan tiqui pach,— cu t'anoo' tu bajil. ");
INSERT INTO mopNT_vpl VALUES ("MT16_8","070_16_8","MAT","16","8","8","A Jesusu, u yeel c'u' a tanoo' u yadic tu bajiloo'. —¿C'u' ca'a tane'ex a tzicbaltic ta bajile'ex ti ma' yan te'ex a pana? Top tz'etz'eec ilic que'ene'ex a wool tu pach a Dioso,— cu t'an a Jesus ti'ijoo'o. ");
INSERT INTO mopNT_vpl VALUES ("MT16_9","070_16_9","MAT","16","9","9","—¿Ma' wa ta'ache'ex a ch'a'ic u tojil? ¿Ma' wa cüja'an te'ex boon cuul ti xac u yaabil u yada' a pan a molaje'ex le'ec ti tzeenboo' cinco mil tuul ti winic etel cinco cuul a pana?— cu t'an a Jesus ti'ijoo' u yaj cambal ti'i ma' u tuclicoo' tuba u talel a janala. ");
INSERT INTO mopNT_vpl VALUES ("MT16_10","070_16_10","MAT","16","10","10","—¿Ma' wa c'üja'an te'ex boon cuul ti xac u yaabil u yada' a pan a molaje'ex le'ec ti tzeenboo' cuatro mil tuul ti winic etel siete cuul a pana?— cu t'an a Jesus ti'ijoo'o. ");
INSERT INTO mopNT_vpl VALUES ("MT16_11","070_16_11","MAT","16","11","11","—¿C'u' ca'a ma' tane'ex a ch'a'ic u tojil ti ma' tan in tzicbaltic a pana? Cününte'ex a bajil ti'i ma' a cho'bole'ex u men u levadura a fariseo etel a saduceo u c'aba'oo' u na'ata,— cu t'an a Jesus ti'ijoo'o. ");
INSERT INTO mopNT_vpl VALUES ("MT16_12","070_16_12","MAT","16","12","12","Ti baalo'o, u ch'a'ajoo' u tojil. Ma' tan u yadic ti'ijoo' ca' u cününtoo' u bajil ti'i ma' u cho'boloo' u men a levadura a walac u tz'abül ich pani. Le'ec a c'u' a walacoo' u ye'ic a fariseo etel a saduceo u c'aba'oo' u na'ata, le'ec a tan u tzicbalbülü. ");
INSERT INTO mopNT_vpl VALUES ("MT16_13","070_16_13","MAT","16","13","13","Pues te'i. C'ochi a Jesus ichil u cuenta a Cesarea de Filipojo. —Inene, yanajeen ti cristianojil. ¿Mac winiquilen ti walacoo' u yadic a cristiano tin woc'ol?— cu t'an a Jesus ti'ijoo' u yaj cambala. ");
INSERT INTO mopNT_vpl VALUES ("MT16_14","070_16_14","MAT","16","14","14","—Yan a walacoo' u yadic ti le'ec inchech aj Juan aj tz'aj ocja' a ca' cuxlajiji,— cu t'anoo' ti'i. —Yanoo' ulaac' a walacoo' u yadic ti le'ec inchech a uchben winic aj Eliasa. Ulaac' tucaye' walacoo' u yadic ti le'ec inchech a uchben winic aj Jeremias wa ulaac' a jun tuul u yadaj u t'an a Dios uchi,— cu t'anoo' ti'i a Jesusu. ");
INSERT INTO mopNT_vpl VALUES ("MT16_15","070_16_15","MAT","16","15","15","—Uxtun inche'exe. ¿Mac winiquilen ti walaque'ex a wadic?— cu t'an ti'ijoo'. ");
INSERT INTO mopNT_vpl VALUES ("MT16_16","070_16_16","MAT","16","16","16","—Inchech u yaj Sa'alil a cristianojo, le'ec u Mejen a Dios a cuxa'ana,— cu t'an aj Simon Pedro ti'iji. ");
INSERT INTO mopNT_vpl VALUES ("MT16_17","070_16_17","MAT","16","17","17","—Inchech aj Simon u mejen aj Jonasa. Qui'qui't'anbeech. Ma' le'ec a cristiano u ye'aj tech maqueni. Le'ec in Tat a que'en ti ca'ana, le'ec u ye'aj tech abe'e,— cu t'an a Jesus ti'iji. ");
INSERT INTO mopNT_vpl VALUES ("MT16_18","070_16_18","MAT","16","18","18","—Tan in wadic tech. Inchech aj Pedrojo. Tz'i' tunich u nu'cul a c'aba'. Tuwich a noxi' tunich ada'a, bel in quin yancunte boonoo' a tene, jabix cuchi tan in wa'cuntic a c'unaj te'i. Ca'ax boon u yaabil a c'as a yana, ma' tu paatal u jubu' a jabix a c'unaj abe'e,— cu t'an a Jesusu. ");
INSERT INTO mopNT_vpl VALUES ("MT16_19","070_16_19","MAT","16","19","19","—Bel in quin tz'aa' tech jabix u llavejil ti'i a jebic ca' ococoo' a cristiano ti tücaa'bül u men a Dioso. Le'ec a c'u' a bel a ca'a a c'ülü' yoc'olcab, bel ilic u ca'a c'ülbül ti ca'an. Le'ec a c'u' a bel a ca'a a chaa' yoc'olcab, bel ilic u ca'a cha'bül ti ca'an,— cu t'an a Jesusu. ");
INSERT INTO mopNT_vpl VALUES ("MT16_20","070_16_20","MAT","16","20","20","U yadaj ti'ijoo' u yaj cambal ti ma' u beloo' u yadü' ti le'ec ilic ala'i a Cristo le'ec u yaj Sa'alil a cristianojo. ");
INSERT INTO mopNT_vpl VALUES ("MT16_21","070_16_21","MAT","16","21","21","Pues te'i. Ti'i ilic a q'uin abe'e, caji a Jesus u yadü' ti chica'an ti'ijoo' u yaj cambal ti yan u beel ich caj Jerusalen. —Te'i yaab a yaj a bel u ca'a betabül ten u menoo' a nucuch winiqui, u yet'ocoo' u noochiloo' u yaj mansaj t'an a cristiano ti'i a Dios eteloo' u yaj ca'ansajil u ley aj Moisese. Bel in ca'a quimsabül. Ca' cuxquinbil in ca'a tu yox p'eel q'uin,— cu t'an a Jesus ti'ijoo'o. ");
INSERT INTO mopNT_vpl VALUES ("MT16_22","070_16_22","MAT","16","22","22","Pues te'i. Le'ec aj Pedrojo, u joc'saj a Jesus tu junal. —Noochil, Dios ca' u cününteech. Ma' tu yuchul tech jabix a wadaja,— cu t'an aj Pedro ti'ijil. ");
INSERT INTO mopNT_vpl VALUES ("MT16_23","070_16_23","MAT","16","23","23","Le'ec a Jesusu, u sutaj u bajil. —Xen quisin. Chen walac a yaaltic a cho'een. Ma' qui' ta wich a jabix u c'ati a Dioso, chen a jabix u c'atoo' a cristianojo,— cu t'an a Jesus ti'i aj Pedrojo. ");
INSERT INTO mopNT_vpl VALUES ("MT16_24","070_16_24","MAT","16","24","24","Pues te'i. —Wa yan mac u c'ati u c'üm-oolteene, yan u p'ütic u betic c'u' a qui' tu wich u bete' wa'ye' yoc'olcab. Yan u c'ümic boon a yaj a tan u tz'abül ti'i u men tan u tz'ocsiquen. Ti baalo'o, tan u betic jabix a mac a tan u ch'a'ic u cruz ti'i u quimsabül tuwichi. Le'ec a jabix abe' a qui' ca' talac tin pacha,— cu t'an a Jesus ti'ijoo' u yaj cambal. ");
INSERT INTO mopNT_vpl VALUES ("MT16_25","070_16_25","MAT","16","25","25","—Le'ec mac u c'ati u sa'alte u cuxtal wa'ye'e, sa'tül u ca'a u cuxtal ti ca'an. Uchac u sa'tül u cuxtal a mac u men que'en u yool tin pach, bel u cu cüxte u cuxtal ti ca'an,— cu t'an a Jesusu. ");
INSERT INTO mopNT_vpl VALUES ("MT16_26","070_16_26","MAT","16","26","26","—¿C'u' aj beel ti'i a mac ca'ax u naalte cuchi tulacal a yoc'olcaba, y ca' quimic ti ma' c'üma'an u men a Dioso? ¿C'u' a jede'ec u paatal u tz'eec ti'i u c'ümbeebal u men Dios?— cu t'an a Jesusu. ");
INSERT INTO mopNT_vpl VALUES ("MT16_27","070_16_27","MAT","16","27","27","—Le'ec inen a yanajeen ti cristianojili, ca' wataquen in wet'ocoo' u yaj xa'num a Dios ti ca'ana. Ca' wataquen etel u muc' in Tat. Bel in quin wusq'uinte u jel a c'u' u betajoo' tulacal a jujun tuul a cristianojo,— cu t'an a Jesusu. ");
INSERT INTO mopNT_vpl VALUES ("MT16_28","070_16_28","MAT","16","28","28","—Tan in wadic te'ex u jajil. Yan a jujun tuule'ex a wa'ane'ex wa'ye' a ma' ta quimile'ex asto a wilique'ex in ca' chictal etel in yanil ti tücaa'. Inene, yanajeen ti cristianojil,— cu t'an a Jesusu. ");
INSERT INTO mopNT_vpl VALUES ("MT17_1","070_17_1","MAT","17","1","1","Pues te'i. Seis q'uin manüc a t'an abe' u yadaj a Jesusu, naq'ui tuwich a witz a top ca'nala. U bensajoo' aj Pedro, aj Jacob, y aj Juan tu pacha. Aj Juan y aj Jacobo, u sucu'un u yitz'inoo' u bajil. Que'enoo' tu junal. ");
INSERT INTO mopNT_vpl VALUES ("MT17_2","070_17_2","MAT","17","2","2","Jeeli u cha'an a Jesus tu taanoo'. Sasilaji u wich jabix q'uini. Süc sücaji u noc' jabix u sac a q'uini. ");
INSERT INTO mopNT_vpl VALUES ("MT17_3","070_17_3","MAT","17","3","3","Chiclajoo' aj Moises etel aj Elias ti'ijoo' a ox tuulu. Aj Moises etel aj Eliasa, tanoo' u t'an etel a Jesusu. ");
INSERT INTO mopNT_vpl VALUES ("MT17_4","070_17_4","MAT","17","4","4","—Noochil, qui' ti que'eno'on wa'ye'. Wa qui' ta wichi, bel ti ca'a ti bete' ox cuul a tz'i' naj ti'i bo'oy. Jun cuulu, tech. Jun cuul ti'i aj Moises, y jun cuul ti'i aj Eliasa,— cu t'an aj Pedro ti'i a Jesusu. ");
INSERT INTO mopNT_vpl VALUES ("MT17_5","070_17_5","MAT","17","5","5","Le'ec ti tan to u yadic abe' aj Pedrojo, emi a muyal a top sasil yoc'oloo' tac ti lu'um. Que'enoo' ich muyal ala'oo'. Uchi a t'an ichil a muyala. —Le'ec ada' in Mejen. Yaj in wu'yi. Top qui' in wool etel. U'ye'ex u t'an,— cu t'an a t'an ichil a muyala. ");
INSERT INTO mopNT_vpl VALUES ("MT17_6","070_17_6","MAT","17","6","6","Le'ec ca' u yubajoo' a t'an abe'e, xonlajoo'. Top saacajoo'. ");
INSERT INTO mopNT_vpl VALUES ("MT17_7","070_17_7","MAT","17","7","7","C'ochi a Jesus tu tzeeloo'. U tülajoo'. —Liq'uene'ex. Ma' a saactale'ex,— cu t'an a Jesusu. ");
INSERT INTO mopNT_vpl VALUES ("MT17_8","070_17_8","MAT","17","8","8","Le'ec ca' u lic'sajoo' u polo, u yilajoo' ti jadi' a Jesus a yan te'iji, ma'ax mac ulaac'. ");
INSERT INTO mopNT_vpl VALUES ("MT17_9","070_17_9","MAT","17","9","9","Pues te'i. Tanoo' u yemel tuwich a witzi. —Ma' a wadique'ex ti'i ma'ax mac le'ec a c'u' a wilaje'ex asto ti ca' cuxlaquen tu yaamoo' a quimen a yanajeen ti cristianojili,— cu t'an a Jesus ti'ijoo'o. ");
INSERT INTO mopNT_vpl VALUES ("MT17_10","070_17_10","MAT","17","10","10","Pues te'i. Le'ecoo' u yaj cambala, u c'aatajoo' ti'i. —Le'ecoo' u yaj ca'ansajil u ley aj Moisese, ¿c'u' ca'a walacoo' u yadic ti yan u yudel payanbej aj Eliasa?— cu t'anoo' ti'i. ");
INSERT INTO mopNT_vpl VALUES ("MT17_11","070_17_11","MAT","17","11","11","—Jajoo' u t'an ti yan u yudel payanbej aj Elias u tojquinte tulacal,— cu t'an a Jesusu. ");
INSERT INTO mopNT_vpl VALUES ("MT17_12","070_17_12","MAT","17","12","12","—Tan in wadic te'ex. Ac udi tun aj Eliasa. Ma' eeltabi wa le'ec. U betajoo' a ca'ax c'u'ac a qui'oo' tu wich u betoo' ti'iji. Baalo' ilic xan inene. Beloo' ilic u cu bete' a yaj ten a yanajeen ti cristianojili,— cu t'an a Jesus ti'ijoo'o. ");
INSERT INTO mopNT_vpl VALUES ("MT17_13","070_17_13","MAT","17","13","13","Le'ecoo' u yaj cambal a Jesusu, u ch'a'ajoo' u tojil u t'an. U yeeltajoo' ti le'ec aj Elias a tan u tzicbalbülü, le'ec ilic aj Juan aj tz'aj ocja'a. ");
INSERT INTO mopNT_vpl VALUES ("MT17_14","070_17_14","MAT","17","14","14","Pues te'i. Le'ec ti emoo' tuwich witz, c'ochoo' tuba que'enoo' u yaabil a cristianojo. C'ochi jun tuul a winiqui. Xonlaji tu taan a Jesusu. ");
INSERT INTO mopNT_vpl VALUES ("MT17_15","070_17_15","MAT","17","15","15","—Noochwinic,— cu t'an ti'i a Jesusu. —Ch'a'a u yotzilil in mejen. Walac u tz'abül ti'i ca' sücquimic. Top tan u c'ümic a yaj tu jajil. Walac u boch c'axül ich c'aac' wa ich ja',— cu t'an ti'i a Jesusu. ");
INSERT INTO mopNT_vpl VALUES ("MT17_16","070_17_16","MAT","17","16","16","—In talesaj eteloo' a waj cambal y ma' paatajoo' u ch'anes,— cu t'an ti'i a Jesusu. ");
INSERT INTO mopNT_vpl VALUES ("MT17_17","070_17_17","MAT","17","17","17","A Jesusu, u nuuctajoo' etel u muc' u t'an. —Top ma' que'ene'ex a wool tu jajil tu pach a Dioso. Top que'en to a woole'ex tu pach a uchbene,— cu t'an a Jesus ti'ijoo'o. —¿Boon q'uin to yan in cuntal ta yaame'ex y muc'yajtique'ex,— cu t'an a Jesus ti'ijoo'o. —Tales a mejen,— cu t'an a Jesus ti'i a winiqui. ");
INSERT INTO mopNT_vpl VALUES ("MT17_18","070_17_18","MAT","17","18","18","Le'ec a Jesusu, u yadaj ti'i a c'ac'asba'al ca' joc'oc. Joq'ui tu yool a tz'ubu. Tu seebal ch'ani. ");
INSERT INTO mopNT_vpl VALUES ("MT17_19","070_17_19","MAT","17","19","19","Pues te'i. Le'ec ti que'en a Jesus tu junal, c'ochoo' u yaj cambal etel. —¿C'u' ca'a ma' paatajo'on ti joq'ues a c'ac'asba'al abe'e?— cu t'anoo' ti'i. ");
INSERT INTO mopNT_vpl VALUES ("MT17_20","070_17_20","MAT","17","20","20","—Top ma' que'ene'ex a wool tu pach a Dios tu jajil, mentücü, ma' paataje'ex a joq'ues,— cu t'an a Jesus ti'ijoo'o. —Tan in wadic te'ex u jajil. Wa cuchi jabix jun cuul u nec' ix mostazaja, que'ene'ex a wool pach a Dioso, qui' cuchi. Jede'ec cuchi u paatal a wadic ti'i a witz ada'a: “Jiisen tacan,” que'ex cuchi ti'i. Bel u ca'a ti jiisil. Ma'ax c'u' cuchi a ma' tu paatale'ex a betiqui,— cu t'an a Jesus ti'ijoo'o. ");
INSERT INTO mopNT_vpl VALUES ("MT17_21","070_17_21","MAT","17","21","21","—C'u' betiqui, a c'ac'asba'al a jabix abe'e, chücyajil u joc'sabül. Jadi' cuchi wa tane'ex a boch c'ajsic a Dios yoc'ol u joc'ol etel a p'ütique'ex a janal ti suq'uini, jede'ec cuchi u joc'ol,— cu t'an a Jesus ti'ijoo'o. ");
INSERT INTO mopNT_vpl VALUES ("MT17_22","070_17_22","MAT","17","22","22","Pues te'i. Que'en to a Jesus ich cuenta Galilea u yet'ocoo' u yaj cambal. —Inene, yanajeen ti cristianojil. Bel in ca'a c'ubbul tu c'ü'oo' a cristianojo,— cu t'an a Jesus ti'ijoo'o. ");
INSERT INTO mopNT_vpl VALUES ("MT17_23","070_17_23","MAT","17","23","23","—Beloo' u cu quimseen. Bel in ca'a ca' cuxquinbil tu yox p'eel q'uin,— cu t'an ti'ijoo'. U men a t'an abe'e, top yajajoo' u yool. ");
INSERT INTO mopNT_vpl VALUES ("MT17_24","070_17_24","MAT","17","24","24","Pues te'i. C'ochoo' ich caj Capernaum a Jesus u yet'ocoo' u yaj cambala. Chiitbi aj Pedro u menoo' a winic a walacoo' u molic a taq'uin ti'i u yotoch a Dioso. —¿Walac wa u bo'tic a taq'uin a tan u molbol ti'i u yotoch a Dios a maestroje'exe?— cu t'anoo' ti'i. ");
INSERT INTO mopNT_vpl VALUES ("MT17_25","070_17_25","MAT","17","25","25","—Walac,— cu t'an aj Pedro ti'ijoo'o. Le'ec ti c'ochi aj Pedro ich naj, c'aatbi ti'i u men a Jesusu. —Simon, biqui'il a tucul?— cu t'an a Jesus ti'iji. —¿Mac etel walac u molic a taq'uin a reye, eteloo' u yet'oc tu bajil, wa eteloo' ulaac' mac?— cu t'an a Jesus ti'iji. ");
INSERT INTO mopNT_vpl VALUES ("MT17_26","070_17_26","MAT","17","26","26","—Eteloo' ulaac' mac,— cu t'an aj Pedro ti uchi u nuuc. —Ti baalo' u yet'ocoo'o, ma' tzaj u bo'ticoo' a taq'uini,— cu t'an a Jesus ich mucult'an yoc'ol tanil u bo'tic a tan u molbol ti'i u yotoch a Dioso. ");
INSERT INTO mopNT_vpl VALUES ("MT17_27","070_17_27","MAT","17","27","27","—C'u' betiqui, ma' ti c'ati ti p'ujesoo', mentücü, ca' xiquech chi' a ja'a. Tzümü a jooc te'i. Le'ec aj ch'ilam a ca' paye' joocteje, te'i a cüxtic a taq'uin ichil u chi' a chucul u bo'tic a c'u' a tanoo' u c'aatic to'ono. Tz'a a taq'uin abe' ti'ijoo' ti'i a bo'tic a tene, y a teche,— cu t'an a Jesus ti'i aj Pedrojo. ");
INSERT INTO mopNT_vpl VALUES ("MT18_1","070_18_1","MAT","18","1","1","Pues te'i. Ti'i ilic a q'uin abe'e, binoo' u yaj cambal u c'aate ti'i. —¿Mac a mas nooch u wichil u meyaj tiqui yaam ti a q'uin ti bel u ca'a ti tücaa' a Dioso?— cu t'anoo' ti'i. ");
INSERT INTO mopNT_vpl VALUES ("MT18_2","070_18_2","MAT","18","2","2","Le'ec a Jesusu, u püyaj a tz'ub ca' xi'ic tu taanoo' u yaj cambal. ");
INSERT INTO mopNT_vpl VALUES ("MT18_3","070_18_3","MAT","18","3","3","—Tan in wadic te'ex u jajil. Wa ma' ta p'ütique'ex a uchben tucul ca' tun a tz'ocse'ex a Dios jabix ilic ti walac u tz'ocsaj t'an a tz'ubu, ma' ta wocole'ex tuba tan u tücaa' a Dioso,— cu t'an a Jesus ti'ijoo'o. ");
INSERT INTO mopNT_vpl VALUES ("MT18_4","070_18_4","MAT","18","4","4","—Le'ec mac ca' u bete' u bajil jabix cuchi ma'ax c'u' u wich jabix ilic a tz'ub ada'a, le'ec ala'i a mas nooch u wichil u meyaj tuba tan u tücaa' a Dioso,— cu t'an a Jesus ti'ijoo'o. ");
INSERT INTO mopNT_vpl VALUES ("MT18_5","070_18_5","MAT","18","5","5","—Le'ec mac ca' u yaante jun tuul a tz'ub a jabix ada' u men tan u tz'ocsiquene, tan ilic u yaantiquen. ");
INSERT INTO mopNT_vpl VALUES ("MT18_6","070_18_6","MAT","18","6","6","C'u' betiqui, wa yan mac ca' u yemes u yool ti'i u cüxtical u sip'ili, top c'as a tan u betiqui. Mas qui' cuchi ca' c'üxbüc a noxi' ca' tu cal ca' pulbuc ich c'ac'naab. Te'i u quimil cuchi tuwich u betic abe'e,— cu t'an a Jesusu. ");
INSERT INTO mopNT_vpl VALUES ("MT18_7","070_18_7","MAT","18","7","7","—Pues te'i. Top walac u yaaltabül emsabül u yool a mac ti'i ca' u cüxte u sip'ili, mentücü, top yaj a beloo' u cu c'ümü' a cristiano yoc'olcaba. Yan u yaaltabül emsabül u yool a maca. C'u' betiqui, top yaj a bel u cu c'ümü' a tan u yaaltic u yemes u yool ulaac'a,— cu t'an a Jesusu. ");
INSERT INTO mopNT_vpl VALUES ("MT18_8","070_18_8","MAT","18","8","8","—Pues te'i. Uchac tane'ex a cüxtic a sip'il chen etel c'u' a tane'ex a betic wa etel tuba tane'ex a beel jabix cuchi a c'ü'e'ex wa jabix cuchi a woque'ex a tan u tz'eec te'ex ca' a cüxte'ex a sip'il. Mas qui' ma' a ca' betique'ex abe'e, wa ma' a ca' beele'ex te'i, jabix cuchi a ch'üquique'ex a c'ü' wa a woc y a pule'ex. Mas toj cuchi ca' a culpachte a sip'il ti'i ca' a c'üme'ex a cuxtala. Mas qui' cuchi a c'ümique'ex a cuxtal ti jadi' yan te'ex jabix cuchi jun tziit ilic a c'ü' wa jun tziit ilic a woc tuwich a pulbule'ex ich c'aac' ti yan ca' tziit a c'ü' wa ca' tziit a woc. Ma' yan q'uin u tupul a c'aac' abe'e,— cu t'an a Jesusu. ");
INSERT INTO mopNT_vpl VALUES ("MT18_9","070_18_9","MAT","18","9","9","—Wa cuchi tane'ex a cüxtic a sip'il chen etel c'u' a tane'ex a cha'antiqui, jabix cuchi u nec' a wich a tan u tz'eec ca' a cüxte'ex a sip'ili, mas qui' cuchi a p'ütique'ex a cha'antic abe'e, jabix cuchi a joc'saje'ex u nec' a wich abe'e, y a pulaje'ex. Mas toj cuchi a c'ümique'ex a cuxtal ti jun cuul ilic u nec' a wiche'ex tuwich ca' pulbuque'ex ichil a infierno tuba yan a c'aac' ti yan ca' cuul u nec' a wiche'exe,— cu t'an a Jesusu. ");
INSERT INTO mopNT_vpl VALUES ("MT18_10","070_18_10","MAT","18","10","10","—Pues te'i. Cününte'ex a bajil ti'i ma' a betique'ex jabix ma'ax c'u' u yeel jun tuul a wettz'ocsaj t'ane'ex a jabix a tz'ub ada'a,— cu t'an a Jesus ti'ijoo' u yaj cambal. —Tan in wadic te'ex. Le'ecoo' u yaj xa'num a Dios ti ca'an a tanoo' u cününtic a jujun tuul ala'oo'o, tan ti tanoo' u yilic u wich in Tat ti ca'an,— cu t'an a Jesus ti'ijoo'o. ");
INSERT INTO mopNT_vpl VALUES ("MT18_11","070_18_11","MAT","18","11","11","—Le'ec inen a yanajeen ti cristianojili, udeen ti'i ca' in sa'alte a mac a sa'ti ti'i a Dioso,— cu t'an a Jesusu. ");
INSERT INTO mopNT_vpl VALUES ("MT18_12","070_18_12","MAT","18","12","12","Pues te'i. Jun tuul a winiqui, yan u carnero cien tuul. Wa cuchi ca' sa'tüc ti'i a jun tuulu, ¿c'u' a bel u cu bete'? ¿Biqui'ile'ex a tucul? Bel u cu p'ütoo' a noventa y nueve tuul tuba tanoo' u janala. Bel u ca'a tuwich witz u cüxte a sa'tala,— cu t'an a Jesusu. ");
INSERT INTO mopNT_vpl VALUES ("MT18_13","070_18_13","MAT","18","13","13","—Tan in wadic te'ex u jajil. Wa cuchi ca' u cüxteje, mas qui' cuchi u yool etel a jun tuul abe'e, tuwich etel a noventa y nueve tuul a ma' sa'too'o,— cu t'an a Jesusu. ");
INSERT INTO mopNT_vpl VALUES ("MT18_14","070_18_14","MAT","18","14","14","—Baalo' ilic in Tat ti ca'ana. Ma' u c'ati ca' sa'tüc ma'ax jun tuul aj tz'ocsaj t'an a que'en u yool tin pach jabix a tz'ub ada'a,— cu t'an a Jesusu. ");
INSERT INTO mopNT_vpl VALUES ("MT18_15","070_18_15","MAT","18","15","15","—Pues te'i. Uchac u cüxtic u sip'il jun tuul a hermano ta wetel. Ca' xiquech etel. Le'ec ti que'enech ta junal etel ala'aji, adü ti'i u sip'il. Wa cuchi ca' u yubi a t'ana, a sa'altaj cuchi a hermanojo,— cu t'an a Jesusu. ");
INSERT INTO mopNT_vpl VALUES ("MT18_16","070_18_16","MAT","18","16","16","—C'u' betiqui, wa cuchi ma' tu yubic a t'ana, yan a bensic jun tuul wa ca' tuul ta pach ti tan a ca' beel etel. Ti baalo'o, yan ca' tuul wa ox tuul a testigo yoc'ol tulacal a t'an a aalbiji,— cu t'an a Jesusu. ");
INSERT INTO mopNT_vpl VALUES ("MT18_17","070_18_17","MAT","18","17","17","—Wa cuchi ma'ax u t'an ala'oo'o, ma' tu yubiqui, adü ti'ijoo' a jun muuch' a hermano tuba much'a'anoo'o. Wa cuchi ma' tu yubic u t'an a jun muuch' a hermanojo, yane'ex a wilic ala'i jabix jun tuul a ma' u yeel a Dioso. Yane'ex a wilic ala'i jabix ti walac u yilbil jun tuul motztzil a yan u yanil u molo' a taq'uin ti'i a gobiernojo,— cu t'an a Jesusu. ");
INSERT INTO mopNT_vpl VALUES ("MT18_18","070_18_18","MAT","18","18","18","—Tan in wadic te'ex u jajil. Le'ec a c'u' a ca' tz'aa'e'ex yoc'olcaba, tz'abül ilic u ca'a ti ca'an. Le'ec a c'u' a ca' a chaa'e'ex yoc'olcaba, cha'bül ilic u ca'a ti ca'an,— cu t'an a Jesusu. ");
INSERT INTO mopNT_vpl VALUES ("MT18_19","070_18_19","MAT","18","19","19","—Tan in wadic te'ex tucaye'il. Wa cuchi quetoo' u tucul yoc'ol jun p'eel ba'al ca' tuul ta yaame'ex yoc'olcab ti tane'ex a c'aatiqui, bel u ca'a tz'abül ti'ijoo' u men in Tat ti ca'an,— cu t'an a Jesusu. ");
INSERT INTO mopNT_vpl VALUES ("MT18_20","070_18_20","MAT","18","20","20","—Bel u ca'a tz'abül ti'ijoo' u men le'ec tuba much'a'anoo' ca' tuul wa ox tuul ti'i u c'ajsiquene, te'i ilic que'enen tu yaamoo',— cu t'an a Jesusu. ");
INSERT INTO mopNT_vpl VALUES ("MT18_21","070_18_21","MAT","18","21","21","Pues te'i. C'ochi aj Pedro tu tzeel a Jesusu. —Noochil, le'ec ti tan ti tan u cüxtic u sip'il jun tuul a hermano tin wetele, ¿boon sut ca' in sa'tes ti'iji? ¿Chucul wa a siete sutu?— cu t'an aj Pedro ti'i a Jesusu. ");
INSERT INTO mopNT_vpl VALUES ("MT18_22","070_18_22","MAT","18","22","22","—Tan in wadic tech. Ma' chucul a siete suti. Setenta sut ti siete ca' a sa'tese,— cu t'an a Jesusu. ");
INSERT INTO mopNT_vpl VALUES ("MT18_23","070_18_23","MAT","18","23","23","—Bel in quin tzicbalte tz'eecac yoc'ol abe'e. Le'ec biqui ti walac u tücaa' a Dioso, c'üs jabix jun tuul a reye. U c'ati u yila' u cuentajil u naal y u p'ax u yaj meyajoo',— cu t'an a Jesusu. ");
INSERT INTO mopNT_vpl VALUES ("MT18_24","070_18_24","MAT","18","24","24","—Le'ec ti caji u yila'a, c'ochesabi jun tuul a top yaab u p'ax tu jajil,— cu t'an a Jesusu. ");
INSERT INTO mopNT_vpl VALUES ("MT18_25","070_18_25","MAT","18","25","25","—Ma' paataji u bo'te u p'ax. Le'ec u noochili, u yadaj ca' conboc ala'i u yet'oc u yütan eteloo' u mejen etel tulacal a c'u' a yan ti'i yoc'lal u p'ax,— cu t'an a Jesusu. ");
INSERT INTO mopNT_vpl VALUES ("MT18_26","070_18_26","MAT","18","26","26","—Xonlaji u yaj meyaj tu taan. “Noochil, se' paac'teen. Jede'ec in bo'tic tulacal,” cu t'an u yaj meyaj ti'iji,— cu t'an a Jesusu. ");
INSERT INTO mopNT_vpl VALUES ("MT18_27","070_18_27","MAT","18","27","27","—Otzilaji tu wich a rey u yaj meyaj abe'e. U sa'tesaj ti'i tulacal u p'ax,— cu t'an a Jesusu. ");
INSERT INTO mopNT_vpl VALUES ("MT18_28","070_18_28","MAT","18","28","28","—Tanil u yusc'al aj meyaj abe'e, u c'ümaj u yetmeyaj. Yan u p'ax ilic xan ala'i ti'iji, pero chen tz'etz'eec. U müchaj. U bit'aj tu cal. “Bo'te ten a p'ax,” cu t'an ti'i,— cu t'an a Jesusu. ");
INSERT INTO mopNT_vpl VALUES ("MT18_29","070_18_29","MAT","18","29","29","—Xonlaji u yetmeyaj tu taan. “Se' paac'teen. Jede'ec in bo'tic tulacal,” cu t'an u yetmeyaj ti'i,— cu t'an a Jesusu. ");
INSERT INTO mopNT_vpl VALUES ("MT18_30","070_18_30","MAT","18","30","30","—Ma' u c'ümaji. U tz'aj ti presojil asto u cüxtic y ca' u bo'te tulacal u p'ax,— cu t'an a Jesusu. ");
INSERT INTO mopNT_vpl VALUES ("MT18_31","070_18_31","MAT","18","31","31","—Pues te'i. Le'ecoo' u chucaan u yetmeyaja, u yilajoo' c'u' u betaj. Top yajajoo' u yool. Binoo' etel a reye. U tzolajoo' c'u' u betaj,— cu t'an a Jesusu. ");
INSERT INTO mopNT_vpl VALUES ("MT18_32","070_18_32","MAT","18","32","32","—Püybi u men a reye. “Top c'asech incheche,” cu t'an ti'i u yaj meyaj. “Le'ec boon u yaabil a p'axa, in sa'tesaj tech. In sa'tesaj chen u men a c'aataj ten,” cu t'an a rey ti'iji,— cu t'an a Jesusu. ");
INSERT INTO mopNT_vpl VALUES ("MT18_33","070_18_33","MAT","18","33","33","—“Jabix ilic cuchi ca' in ch'a'aj a wotzilil incheche, baalo' ilic cuchi ca' a ch'a'aj u yotzilil a wetmeyaj,” cu t'an a rey ti'iji. ");
INSERT INTO mopNT_vpl VALUES ("MT18_34","070_18_34","MAT","18","34","34","—Tz'iic a reye. U c'ubaj ala'i ti'ijoo' aj cünün preso ti'i ca' tz'abüc a yaj ti'i asto u cüxtic y ca' u bo'te tulacal u p'ax,— cu t'an a Jesusu. ");
INSERT INTO mopNT_vpl VALUES ("MT18_35","070_18_35","MAT","18","35","35","—Baalo' ilic a bel u cu bete' in Tat ti ca'an ti'i tulacal a jujun tuule'ex wa ma' a sa'tesique'ex ti'i a hermano tulacale'ex a wool a püsüc'al,— cu t'an a Jesusu. ");
INSERT INTO mopNT_vpl VALUES ("MT19_1","070_19_1","MAT","19","1","1","Pues te'i. Le'ec ti jobi u yadic a t'an abe' a Jesusu, joq'ui ich cuenta Galilea. Bini ich cuenta Judea tac junxeel a noja' Jordan tu joq'ueeb q'uin. ");
INSERT INTO mopNT_vpl VALUES ("MT19_2","070_19_2","MAT","19","2","2","Top yaab a cristiano a tücünacoo' tu pach. U ch'anesajoo' a cristiano abe' te'i. ");
INSERT INTO mopNT_vpl VALUES ("MT19_3","070_19_3","MAT","19","3","3","C'ochoo' etel a Jesus a fariseo u c'aba'oo' u na'ata. U c'atoo' u yila' wa patal a Jesusu. —¿Qui' wa tu c'axül ti'i a ley ca' u p'ütü' u yütan a winic ca'ax yan ca'ax ma' yan u sip'il u yütan?— cu t'anoo' ti'i a Jesusu. ");
INSERT INTO mopNT_vpl VALUES ("MT19_4","070_19_4","MAT","19","4","4","—A xocaje'ex ti le'ec mac u betaj a cristiano tu cajeebe, u betaj jun tuul winic jun tuul ix ch'up,— cu t'an a Jesus ti uchi u nuuc. ");
INSERT INTO mopNT_vpl VALUES ("MT19_5","070_19_5","MAT","19","5","5","—Le'ec ilic u betajoo' ala'oo'o, u yadaj: “U men baalo' ti yan, le'ec a winiqui, yan u p'ütic u na' u tat ca' u yet'octe u yütan. Le'ec a ca' tuulu, p'aatül u ca'a ti jun tuul ilicoo' tun tu bajil,” cu t'an a Dioso,— cu t'an a Jesusu. ");
INSERT INTO mopNT_vpl VALUES ("MT19_6","070_19_6","MAT","19","6","6","—Ti baalo'o, ma' ca' ca' tuuloo' tu bajili. Jun tuul ilicoo' tu bajil. Le'ec a c'u' a lüc'cunbi u men a Dioso, ma' qui' u jüpbül u men cristiano,— cu t'an a Jesus ti'ijoo'o. ");
INSERT INTO mopNT_vpl VALUES ("MT19_7","070_19_7","MAT","19","7","7","—Wa baalo' ti yan, ¿c'u' ca'a u yadaj aj Moises ca' tz'abüc u ju'umil u yütan a mac ti'i u p'üticaloo' u bajil?— cu t'anoo' a fariseo u c'aba'oo' u na'at ti'i a Jesusu. ");
INSERT INTO mopNT_vpl VALUES ("MT19_8","070_19_8","MAT","19","8","8","—Chen u men top tzimine'ex, cha'be'ex ca' a p'üte'ex a wütane'ex u men aj Moisese. C'u' betiqui, tu cajeebe, ma' baalo' ti yani,— cu t'an a Jesus ti'ijoo'o. ");
INSERT INTO mopNT_vpl VALUES ("MT19_9","070_19_9","MAT","19","9","9","—Tan in wadic te'ex. Le'ec a winic ca' u p'ütü' u yütan ca' tun u cüxte ulaac' u yütana, chen tan u cüjtal. C'u' betiqui, wa ca' u yeelte ti cüjlaji u yütan etel ulaac'a, u paatal u p'ütic. Baalo' ilic etel ix ch'up a p'ütbiji. Mac ca' u ch'aa' ti'i u yütana, chen tan u cüjtal etel,— cu t'an a Jesusu. ");
INSERT INTO mopNT_vpl VALUES ("MT19_10","070_19_10","MAT","19","10","10","Pues te'i. Le'ecoo' u yaj cambal a Jesusu, uchoo' u nuuc. —Wa baalo' ti yan ti'i a winic etel u yütana, mas qui' jumpul ma' u cüxtic u yütan a maca,— cu t'anoo' ti'i a Jesusu. ");
INSERT INTO mopNT_vpl VALUES ("MT19_11","070_19_11","MAT","19","11","11","—Ma' tulacaloo' a winic a jede'ec u paatal u c'ümoo' a t'an a wadaje'ex to. Jadi' mac a tz'abi ti'i ca' u c'ümü' abe'e, jadi' a patal u c'ümiqui,— cu t'an a Jesus ti'ijoo'o. ");
INSERT INTO mopNT_vpl VALUES ("MT19_12","070_19_12","MAT","19","12","12","—Yanoo' a winic u bel ti'ijoo' ti yanajoo' ti ma' yan biqui u yütan. Yanoo' ulaac' a winic a betabi ti'ijoo' u men cristiano ti ma' yan biqui u yütan. Yanoo' ulaac' tucaye' a ma' tu yütanoo' chen u men ma' u c'atoo'o, ti'i ca' paatacoo' u betic u meyaj a Dios tulacaloo' u yool. Le'ec mac patal u c'ümic a t'an abe'e, yan u c'ümic,— cu t'an a Jesus ti'ijoo'o. ");
INSERT INTO mopNT_vpl VALUES ("MT19_13","070_19_13","MAT","19","13","13","Pues te'i. C'ochesaboo' a tz'ub etel a Jesus ti'i ca' u tz'aa' u c'ü' yoc'oloo' ti'i ca' u c'ajes a Dios yoc'oloo'. Le'ecoo' u yaj cambal a Jesusu, u tze'ectajoo' a tanoo' u c'ochesic a tz'ub u men ma' qui'oo' tu wich. ");
INSERT INTO mopNT_vpl VALUES ("MT19_14","070_19_14","MAT","19","14","14","—Cha'aj u taleloo' a tz'ub tin wetele. Ma' a c'üticoo' u wich. Le'ec boon tuul a walacoo' u tz'ocsiquen jabix ilic ti walacoo' u tz'ocsaj t'an a tz'ub ala'oo'o, le'ec a ocoloo' u ca'a tu cuenta a Dioso,— cu t'an a Jesus ti'ijoo' u yaj cambala. ");
INSERT INTO mopNT_vpl VALUES ("MT19_15","070_19_15","MAT","19","15","15","U tz'aj u c'ü' yoc'oloo' ca' tun joq'ui a Jesus te'i. Bini. ");
INSERT INTO mopNT_vpl VALUES ("MT19_16","070_19_16","MAT","19","16","16","Pues te'i. C'ochi jun tuul a winic etel a Jesusu. —Maestro, top qui'ech. ¿C'u' a qui' ca' in bete' ti'i ca' in naalte a cuxtal a ma' yan q'uin u jobolo?— cu t'an a Jesusu. ");
INSERT INTO mopNT_vpl VALUES ("MT19_17","070_19_17","MAT","19","17","17","—¿C'u' ca'a tan a wadic ti qui'en? Jadi' yan jun tuul a qui'i, le'ec a Dioso. Wa cuchi a c'ati a c'ümü' a cuxtala, tz'oques a ley u tz'iibtaj aj Moisese,— cu t'an a Jesus ti'iji. ");
INSERT INTO mopNT_vpl VALUES ("MT19_18","070_19_18","MAT","19","18","18","—¿Biqui'il a tz'iiba'an ichil u ley aj Moises ca' in tz'oquese?— cu t'an ti'i a Jesusu. —Ma' beel ti quimsaj. Ma' beel ti cüjtal etel ca'ax macac. Ma' beel ti xuuch'. Ma' beel ti tzol etel tus. ");
INSERT INTO mopNT_vpl VALUES ("MT19_19","070_19_19","MAT","19","19","19","Tz'oquesoo' u yanil a na' a tat. Yacunte a wet'oc jabix ilic ti yaj a wu'yi a bajil ta bajil,— cu t'an a Jesus ti'iji. ");
INSERT INTO mopNT_vpl VALUES ("MT19_20","070_19_20","MAT","19","20","20","—In tz'ocsaj tun tulacal abe'e. ¿C'u' a yan to in betiqui?— cu t'an a winic ti'i a Jesusu. ");
INSERT INTO mopNT_vpl VALUES ("MT19_21","070_19_21","MAT","19","21","21","—Wa cuchi a c'ati ti toj a na'at tu jajili, ca' xiquech ta wotoch. Cono c'u' a yan teche. T'oxo abe' ti'ijoo' a otzili. Baalo' ti yantal u ca'a a ayic'alil ti ca'an. Ca' tun ca' talaquech tin pach,— cu t'an a Jesus ti'iji. ");
INSERT INTO mopNT_vpl VALUES ("MT19_22","070_19_22","MAT","19","22","22","Le'ec ca' u yubaj abe' a winiqui, yajaji u yool. Bini u men top yaab u ayic'alil. ");
INSERT INTO mopNT_vpl VALUES ("MT19_23","070_19_23","MAT","19","23","23","—Pues te'i. Tan in wadic te'ex u jajil. Chücyajil u yocol tu c'ü' a Dios a winic a yan u ayic'alil yoc'olcab,— cu t'an a Jesus ti'ijoo' u yaj cambal. ");
INSERT INTO mopNT_vpl VALUES ("MT19_24","070_19_24","MAT","19","24","24","—Tan ilic in wadic te'ex. Ma' yan biqui a mansique'ex jun tuul a noxi' baalche' u c'aba' camello tu potolal a puutzu. Mas chücyajil tucaye'il ca' ococ jun tuul ayic'al tu c'ü' a Dioso,— cu t'an a Jesusu. ");
INSERT INTO mopNT_vpl VALUES ("MT19_25","070_19_25","MAT","19","25","25","Le'ec ca' u yubajoo' a t'an abe' u yaj cambala, sa'too' u yool. —Wa ma' tu paatal u sa'albül a ayic'ala, ma'ax mac wal a bel u ca'a sa'albülü,— cu t'anoo'. ");
INSERT INTO mopNT_vpl VALUES ("MT19_26","070_19_26","MAT","19","26","26","Le'ec a Jesusu, u cha'antajoo' u yaj cambal. —Le'ecoo' a cristianojo, ma' tu paataloo' u sa'altoo' u bajil. C'u' betiqui, a Dioso, u paatal u betic tulacal,— cu t'an a Jesus ti'ijoo'o. ");
INSERT INTO mopNT_vpl VALUES ("MT19_27","070_19_27","MAT","19","27","27","U men aalbi ti'i a winic ca' u p'ütü' tulacal y ca' tun xi'ic tu pach a Jesusu, uchi u t'an aj Pedrojo. —Ila ino'ono, ti p'ütaj tulacal y jeda'o'on ta pach. U men ti p'ütaj abe'e, ¿c'u' a bel ti ca'a ti naalte?— cu t'an aj Pedro ti'i a Jesusu. ");
INSERT INTO mopNT_vpl VALUES ("MT19_28","070_19_28","MAT","19","28","28","—Tan in wadic te'ex u jajil. Le'ec ti betabüc ti tumulben a yoc'olcaba, nooch in yanil ti tinlaquen tuwich in tintaan inen a yanajeen ti cristianojil. Le'ec boon tuule'ex a que'ene'ex tin pacha, bele'ex ilic a ca'a ti tintal tuwich doce p'eel a tintaana. Bele'ex a ca'a a tz'a'oo' u sip'il ti wetcaal aj Israel a doce muuch'oo' tu bajil,— cu t'an a Jesus ti'ijoo' u yaj cambal. ");
INSERT INTO mopNT_vpl VALUES ("MT19_29","070_19_29","MAT","19","29","29","—Tulacal a jujun tuul u se' p'ütajoo' u yotoch, wa u sucu'un, wa u yitz'in, wa u quic, wa u tat, wa u na', wa u yütan, wa u mejen, wa u yal, wa u cuuchil chen ti'i u tz'ocsicalenoo'o, beloo' u cu c'ümü' ti mas yaab u qui'il a Dioso. Beloo' ilic u cu c'ümü' a cuxtal a ma' yan q'uin u jobol,— cu t'an a Jesusu. ");
INSERT INTO mopNT_vpl VALUES ("MT19_30","070_19_30","MAT","19","30","30","—Yan ti yaab a jabix taanil que'en wa'ye' u men u meyaja. Tu yaamoo' abe'e, yanoo' a beloo' u ca'a ti cuntal pachil tu cuenta a Dioso. Yan ilic ti yaab a pachil que'enoo' wa'ye' a taanil u beeloo' te'iji,— cu t'an a Jesusu. ");
INSERT INTO mopNT_vpl VALUES ("MT20_1","070_20_1","MAT","20","1","1","—Pues te'i. Le'ec biqui ti walac u tücaa' a Dioso, jabix a winic a yan u colo. Le'ec ti sasajiji, bini u cüxtoo' u yaj meyaj ti'i ca' xicoo' ti meyaj ichil u col,— cu t'an a Jesusu. ");
INSERT INTO mopNT_vpl VALUES ("MT20_2","070_20_2","MAT","20","2","2","—Le'ecoo' aj meyaja, u c'üm-ooltajoo' jun p'eel a taq'uin a ca' u naaltoo' ti a q'uini. U tücaa'tajoo' ichil u col,— cu t'an a Jesusu. ");
INSERT INTO mopNT_vpl VALUES ("MT20_3","070_20_3","MAT","20","3","3","—Jabix wal a las nueve ti jatz'ca'a, ca' bini chumuc caj tucaye' u yumil a colo. U yilajoo' a chen wa'anoo' te'iji,— cu t'an a Jesusu. ");
INSERT INTO mopNT_vpl VALUES ("MT20_4","070_20_4","MAT","20","4","4","—“Ca' xique'ex ti meyaj ichil in col. Jede'ec in bo'tique'ex ti toj,” cu t'an u yumil a colo,— cu t'an a Jesusu. —Binoo' te'i. ");
INSERT INTO mopNT_vpl VALUES ("MT20_5","070_20_5","MAT","20","5","5","Baalo' ilic u ca' betaj etel ulaac' ti chunq'uin. Baalo' ilic u ca' betaj ti jabix wal a las tres ti a ocq'uini,— cu t'an a Jesusu. ");
INSERT INTO mopNT_vpl VALUES ("MT20_6","070_20_6","MAT","20","6","6","—Ca' bini u yumil a col chumuc caj jabix wal a las cinco ti a ocq'uini. U cüxtajoo' ilic a wa'anoo' te'iji. “¿C'u' ca'a wa'ane'ex wa'ye' tulacal a q'uini? ¿Ma' wa yane'ex a meyaj?” cu t'an ti'ijoo',— cu t'an a Jesusu. ");
INSERT INTO mopNT_vpl VALUES ("MT20_7","070_20_7","MAT","20","7","7","—“Wa'ano'on wa'ye' u men ma'ax mac u tz'aj to'on a meyaja,” cu t'anoo' ti'i. “Ca' xique'ex ti meyaj ichil in col. Jede'ec in bo'tique'ex ti toj,” cu t'an ti'ijoo',— cu t'an a Jesusu. ");
INSERT INTO mopNT_vpl VALUES ("MT20_8","070_20_8","MAT","20","8","8","—Le'ec ti oqui a q'uini, u yadaj ti'i u yaj cananil u col ca' u püyoo' u yaj meyaj ca' u bo'too'. Yan u caal ti bo'ol etel a pachil c'ochoo',— cu t'an a Jesusu. ");
INSERT INTO mopNT_vpl VALUES ("MT20_9","070_20_9","MAT","20","9","9","—Le'ec ti c'ochoo' a tz'aboo' u meyaj a las cinco ti a ocq'uini, tz'abi ti'i a jujun tuuloo' jujun p'eel a taq'uini,— cu t'an a Jesusu. ");
INSERT INTO mopNT_vpl VALUES ("MT20_10","070_20_10","MAT","20","10","10","—Le'ec ti c'ochoo' a payanbej tz'aboo' u meyaj ti jatz'ca'a, u tuclajoo' ti jede'ecoo' u c'ümic u naal ti manal. C'u' betiqui, jujun p'eel ilic a taq'uin a tz'abi ti'ijoo'o,— cu t'an a Jesusu. ");
INSERT INTO mopNT_vpl VALUES ("MT20_11","070_20_11","MAT","20","11","11","—Le'ec ca' u c'ümajoo' u naal, cajoo' u p'a'aste u yumil a colo,— cu t'an a Jesusu. ");
INSERT INTO mopNT_vpl VALUES ("MT20_12","070_20_12","MAT","20","12","12","—“Le'ec a c'ochoo' pachili, jadi' jun p'e hora ilic uchoo' u meyaj. Ino'ono, tulacal q'uin uchi ti meyaj. Ti muc'yajtaj u chücüjil a q'uini,” cu t'anoo',— cu t'an a Jesusu. ");
INSERT INTO mopNT_vpl VALUES ("MT20_13","070_20_13","MAT","20","13","13","—“Amigo,” cu t'an u yumil a col ti'i jun tuul tu yaamoo'. —“Ma' in cho'ajechi. ¿Ma' wa ti c'üm-ooltaj yoc'ol ca' uchuc a meyaj yoc'ol a jun p'eel a taq'uini?” cu t'an ti'i,— cu t'an a Jesusu. ");
INSERT INTO mopNT_vpl VALUES ("MT20_14","070_20_14","MAT","20","14","14","—“Ch'a'a a naal a teche. Ca' xiquech. In c'ati ilic in tz'aa' ti'ijoo' a c'ochoo' pachil jabix ilic in tz'aj teche,” cu t'an u yumil a col ti'iji,— cu t'an a Jesusu. ");
INSERT INTO mopNT_vpl VALUES ("MT20_15","070_20_15","MAT","20","15","15","—“¿Ma' wa jede'ec u paatal in betic c'u' in c'ati etel a c'u' a tene? ¿C'as wa ta wich u men qui' in püsüc'al,” cu t'an u yumil a col ti'iji,— cu t'an a Jesusu. ");
INSERT INTO mopNT_vpl VALUES ("MT20_16","070_20_16","MAT","20","16","16","—Baalo' ti walac u tücaa' a Dioso. Le'ec a pachili, bel u ca'a taanil. Le'ec a taanili, bel u ca'a pachil, u men yan ti yaab a jabix püyboo' ca' ococoo' tu cuenta a Dioso. C'u' betiqui, ma' yan ti yaab a yeeta'ana,— cu t'an a Jesusu. ");
INSERT INTO mopNT_vpl VALUES ("MT20_17","070_20_17","MAT","20","17","17","Pues te'i. Le'ec ti tan u beel a Jesus tu benil a caj Jerusalene, u bensajoo' a doce tuul u yaj cambal tzeel bej. ");
INSERT INTO mopNT_vpl VALUES ("MT20_18","070_20_18","MAT","20","18","18","—Ile'ex. Tan ti beel ich caj Jerusalen. Le'ec inen a yanajeen ti cristianojili, bel in ca'a c'ubbul ti'ijoo' u noochiloo' u yaj mansaj t'an a cristiano ti'i a Dioso, u yet'ocoo' u yaj ca'ansajil u ley aj Moisese,— cu t'an a Jesusu. —Beloo' u cu yadü' in quimsabül. ");
INSERT INTO mopNT_vpl VALUES ("MT20_19","070_20_19","MAT","20","19","19","Beloo' u cu c'ubeen ti'ijoo' a ma' Israele. Le'ecoo' a ma' Israele, beloo' u cu p'a'asteen. Beloo' u cu jütz'een etel jatz'. Beloo' u cu quimseen tuwich cruz. Bel in ca'a ca' cuxquinbil tu yox p'e q'uin,— cu t'an a Jesusu. ");
INSERT INTO mopNT_vpl VALUES ("MT20_20","070_20_20","MAT","20","20","20","Pues te'i. C'ochi tu taan a Jesus u na' aj Juan y aj Jacobo, le'ecoo' u mejen aj Zebedeojo. Que'enoo' u yal etel. Xonlaji tu taan. —Bete ten jun p'eel qui'il,— cu t'an ti'i. ");
INSERT INTO mopNT_vpl VALUES ("MT20_21","070_20_21","MAT","20","21","21","—¿C'u' a c'ati ca' in bete',— cu t'an a Jesus ti'iji. —Tz'a ti chuculoo' u noochil u wichil u meyaj in wal a ca' tuul ada'a, ca' tinlacoo' ta tzeel le'ec ti ocoquech ti reyil, jujun tuul a ta tzeele,— cu t'an a nooch'up ti'iji. ");
INSERT INTO mopNT_vpl VALUES ("MT20_22","070_20_22","MAT","20","22","22","—Ma' a weele'ex c'u' a tane'ex a c'aatiqui,— cu t'an a Jesus ti'ijoo'o. —¿Jede'ec wa u paatale'ex a c'ümic a yaj a bel in quin c'ümü'ü, jabix cuchi tane'ex a wuq'uic a top yaj a yan ichil in pote a bel in quin wuc'u'u, wa xan jabix cuchi a c'ümique'ex a ocja' ichil a top yaj jabix a bel in quin c'ümü'ü?— cu t'an a Jesus ti'ijoo'o. —Jede'eque,— cu t'anoo' ti'i. ");
INSERT INTO mopNT_vpl VALUES ("MT20_23","070_20_23","MAT","20","23","23","—Bele'ex a ca'a a wuc'u' u ba'al in pote wa bele'ex a ca'a a c'ümü' in wocja' jabix ilic a bel in quin c'ümü'ü. C'u' betiqui, a tintal tin tzeele, ma' inen jaj teni. Le'ec mac a bel u ca'a ti tintal te'i, ac yeeta'an tun u men in Tat,— cu t'an a Jesus ti'ijoo'o. ");
INSERT INTO mopNT_vpl VALUES ("MT20_24","070_20_24","MAT","20","24","24","Pues te'i. Le'ec ca' u yubajoo' abe' a diez tuul u chucaan u yaj cambala, tz'iicajoo' etel a ca' tuulu. ");
INSERT INTO mopNT_vpl VALUES ("MT20_25","070_20_25","MAT","20","25","25","Le'ec a Jesusu, u püyajoo' u yaj cambal tu tzeel. —Inche'exe, a weele'ex. Le'ec boon u noochiloo' a ma' Israele, walacoo' u betic u yanil tu yaamoo' a boon a que'enoo' tu c'ü'ü. Le'ecoo' a tz'aboo' u yanil u men u noochiloo'o, top walacoo' u betic u yanil ti tücaa',— cu t'an a Jesusu. ");
INSERT INTO mopNT_vpl VALUES ("MT20_26","070_20_26","MAT","20","26","26","—Ma' qui' ca' yanac ti baalo' ta yaame'ex. Le'ec mac ta yaame'ex u c'ati ti nooch u wichil u meyaja, yan u yaanticoo' a chucaane'ex ta bajili,— cu t'an a Jesusu. ");
INSERT INTO mopNT_vpl VALUES ("MT20_27","070_20_27","MAT","20","27","27","—Le'ec mac u c'ati ti top nooch u wichil u meyaj tucaye'il ta yaame'exe, yan u betic u bajil jabix jumpul ma' nooch u wichil u meyaj. Yan u mas aanticoo' a chucaane'ex ta bajil,— cu t'an a Jesusu. ");
INSERT INTO mopNT_vpl VALUES ("MT20_28","070_20_28","MAT","20","28","28","—Yan u betic a jabix ilic a walac in betic inen a yanajeen ti cristianojili. Ma' taleen ti'i ca' aantabüqueni. Taleen ti'i anat. Taleen ti'i ca' in c'ubu' in cuxtal ti'i ca' in sa'altoo' a yaaba,— cu t'an a Jesusu. ");
INSERT INTO mopNT_vpl VALUES ("MT20_29","070_20_29","MAT","20","29","29","Pues te'i. Le'ec ti tanoo' u joc'ol ich caj Jerico a Jesus u yet'ocoo' u yaj cambala, top yaaboo' a cristiano a que'enoo' tu pacha. ");
INSERT INTO mopNT_vpl VALUES ("MT20_30","070_20_30","MAT","20","30","30","Yan ilic ca' tuul a winic tina'an tzeel bej. Ch'oopoo' u wich. Le'ec ca' u yubajoo' ti tan u manül a Jesus te'i, cajoo' ti t'an ti chich. —Ch'a'a ti wotzilil. Incheche, u mamech aj quimen rey David a tan u paac'baanülü,— cu t'an a ca' tuul ti chich. ");
INSERT INTO mopNT_vpl VALUES ("MT20_31","070_20_31","MAT","20","31","31","Q'ue'yajboo' u men u yaabil a cristianojo. —Top lo'peeque'ex,— cu t'anoo' ti'i a ca' tuulu. C'u' betiqui, cajoo' ti t'an ti mas yaab ti chich a ca' tuulu. —Noochil, ch'a'a ti wotzilil. Incheche, u mamech aj quimen rey David a tan u paacbaanülü,— cu t'an a ca' tuul ti chich. ");
INSERT INTO mopNT_vpl VALUES ("MT20_32","070_20_32","MAT","20","32","32","Wa'laji a Jesusu. U püyajoo' a ca' tuulu. —¿C'u' a c'ate'ex ca' in bete'?— cu t'an a Jesus ti'ijoo'o. ");
INSERT INTO mopNT_vpl VALUES ("MT20_33","070_20_33","MAT","20","33","33","—Noochil, ch'anes ti wich,— cu t'an a ca' tuul ti'iji. ");
INSERT INTO mopNT_vpl VALUES ("MT20_34","070_20_34","MAT","20","34","34","Ch'aboo' u yotzilil u men a Jesusu. Tülboo' u wich. Tu seebal uchoo' u cha'an. Binoo' tu pach a Jesusu. ");
INSERT INTO mopNT_vpl VALUES ("MT21_1","070_21_1","MAT","21","1","1","Pues te'i. Le'ec ti nütz'ünacoo' ti a caj Jerusalene, c'ochoo' ti a caj Betfage a que'en tuwich a witz u c'aba' Olivos. Le'ec a Jesusu, u c'ati u tücaa'te ca' tuul u yaj cambal ichil aj meen caja. ");
INSERT INTO mopNT_vpl VALUES ("MT21_2","070_21_2","MAT","21","2","2","—Ca' xique'ex ichil a caj ada'a. Tanile'ex a wocol ichil a caja, bele'ex a ca'a a cüxte a tzimin a c'üxa'an te'i. Te'i ilic que'en u yal etel. Pitoo'. Talesoo' ten wa'ye',— cu t'an a Jesus ti'ijoo'o. ");
INSERT INTO mopNT_vpl VALUES ("MT21_3","070_21_3","MAT","21","3","3","—Uchac u c'aatbül te'ex c'u' ca'a ti tane'ex a pitic. “C'abeetoo' ti'i a Noochtzili,” que'exac ti'iji. Tu seebal bel u cu cha'e'ex a bensicoo',— cu t'an a Jesus ti'i a ca' tuulu. ");
INSERT INTO mopNT_vpl VALUES ("MT21_4","070_21_4","MAT","21","4","4","Baalo' ti jajaji u t'an jun tuul u yadaj u t'an a Dios uchi. ");
INSERT INTO mopNT_vpl VALUES ("MT21_5","070_21_5","MAT","21","5","5","—“Adü ti'ijoo' a cristiano ich caj Sion,” cu t'an a Dios yoc'ol a caj Jerusalene. “Ile'ex, wataque'ex a rey. Ma' tan u betic u yanil. Que'en tu pach tzimin, aj nene' tzimin,”— cu t'an a mac u yadaj u t'an a Dios uchi. ");
INSERT INTO mopNT_vpl VALUES ("MT21_6","070_21_6","MAT","21","6","6","Binoo' ca' tuul u yaj cambal a Jesus u ch'a'oo' a tzimini. U betajoo' a jabix ilic a aalbi ti'ijoo' u men a Jesusu. ");
INSERT INTO mopNT_vpl VALUES ("MT21_7","070_21_7","MAT","21","7","7","U talesajoo' a tzimin tac etel u yala. U xit'ajoo' u noc' yoc'ol. Tinlaji a Jesus tu pach. ");
INSERT INTO mopNT_vpl VALUES ("MT21_8","070_21_8","MAT","21","8","8","Le'ecoo' u yaabil a cristianojo, u xit'ajoo' u noc' ti lu'um ti bej. Ulaac'oo'o, u ch'ücajoo' u le' tac a che'e. U tz'ajoo' ti bej. ");
INSERT INTO mopNT_vpl VALUES ("MT21_9","070_21_9","MAT","21","9","9","Yaaboo' a cristiano a que'en tu taan a Jesusu. Yaaboo' ilic a que'enoo' tu pacha. Tanoo' u t'an ti chich ti tanoo' u beel. —Top qui' u mam aj quimen rey David a tan u paac'baanülü. Ti c'ati Dios ca' u tz'aa' u qui'il u yool u yaj tücaa' le'ec a tan to u yudel. Top qui' a Dioso,— cu t'anoo' a cristiano ti chich. ");
INSERT INTO mopNT_vpl VALUES ("MT21_10","070_21_10","MAT","21","10","10","Le'ec ti oqui a Jesus ich caj Jerusalene, liq'ui a caj u yila'. —¿Mac abe'e?— cu t'anoo' tu bajil. ");
INSERT INTO mopNT_vpl VALUES ("MT21_11","070_21_11","MAT","21","11","11","—Le'ec abe' a Jesusu. Ch'iji ich caj Nazaret cuenta Galilea. Walac u yadic u t'an a Dioso,— cu t'anoo' a cristiano ti uchoo' u nuuc. ");
INSERT INTO mopNT_vpl VALUES ("MT21_12","070_21_12","MAT","21","12","12","Pues te'i. Oqui a Jesus ichil u yotoch a Dioso. U laj tooltajoo' boon a tanoo' u conol y q'uex te'iji. U piquixc'ü'tajoo' u mesajil a tanoo' u jüp taq'uin. U piquixc'ü'tajoo' ilic u silla a tanoo' u con paloma. ");
INSERT INTO mopNT_vpl VALUES ("MT21_13","070_21_13","MAT","21","13","13","—Baalo' ti tz'iiba'an ichil u ju'um a Dioso. “Aalbül u ca'a ti le'ec in wotocho, le'ec u cuuchil in c'ajsabeeb. C'u' betic inche'exe, tane'ex a betic ti chen u cuuchiloo' aj xuuch' in wotocho,” cu t'an a t'an a tz'iiba'ana,— cu t'an a Jesusu. ");
INSERT INTO mopNT_vpl VALUES ("MT21_14","070_21_14","MAT","21","14","14","Pues te'i. C'ochesaboo' a ch'oop y a ma' pataloo' ti ximbal etel a Jesus ichil u yotoch a Dioso. Ch'anesaboo'. ");
INSERT INTO mopNT_vpl VALUES ("MT21_15","070_21_15","MAT","21","15","15","Le'ecoo' u noochil u yaj mansaj t'an a cristiano ti'i a Dioso, u yet'ocoo' u yaj ca'ansajil u ley aj Moisese, u yilajoo' a quich'pan meyaj a tan u betic a Jesus te'i. U yubajoo' ilic u t'anoo' a tz'ub a tanoo' u t'an ti chich ichil u yotoch a Dioso. —Ade'ex u qui'il u mam aj quimen rey David a tan u paac'baanülü,— cu t'anoo' a tz'ub ti chichi. Tz'iicajoo' a noochoo' u wichil u meyaj abe'e. ");
INSERT INTO mopNT_vpl VALUES ("MT21_16","070_21_16","MAT","21","16","16","—¿Ma' wa tan a wu'yic c'u' a tanoo' u yadic a tz'ubu?— cu t'anoo' ti'i a Jesusu. —Tan,— cu t'an a Jesus ti'ijoo'o. —A xocaje'ex tuba tz'iiba'an ti baala': “A tz'aj ti'ijoo' a tz'ub etel a tanoo' to u chu' ca' u yadoo' a qui'il ti toj,” cu t'an a t'an a tz'iiba'an ichil u ju'um a Dioso,— cu t'an a Jesusu. ");
INSERT INTO mopNT_vpl VALUES ("MT21_17","070_21_17","MAT","21","17","17","Pues te'i. Joq'ui a Jesus tu yaamoo'. Bini pach caj tac ich aldea Betania ti posado. ");
INSERT INTO mopNT_vpl VALUES ("MT21_18","070_21_18","MAT","21","18","18","Le'ec ti sasajiji, tan u ca' beel a Jesus ich caj. Wi'ij ala'aji. ");
INSERT INTO mopNT_vpl VALUES ("MT21_19","070_21_19","MAT","21","19","19","U yilaj a che' higo a que'en tu chi' a beje. Bini cuchi u yuxu' tz'etz'eecac u wich. C'u' betiqui, chen u le' a yana. Ma' yan u wich. U yadaj ti ma' tu ca' yantal u wich a che'e. Tu seebal tiqui a che'e. ");
INSERT INTO mopNT_vpl VALUES ("MT21_20","070_21_20","MAT","21","20","20","Pues te'i. Le'ec ca' u yilajoo' ti jomol tiqui a che'e, sa'too' u yool u yaj cambal. —¿Biqui ti top jomol tiqui a che' higo ada'a?— cu t'anoo' tu bajil. ");
INSERT INTO mopNT_vpl VALUES ("MT21_21","070_21_21","MAT","21","21","21","—Tan in wadic te'ex u jajil. Wa cuchi tane'ex a tz'ocsic a Dios tu jajil ca' uchuc a c'u' a tane'ex a c'aatiqui, y ma' yan q'uin a tuclique'ex wa ma' u yuchulu, bel u ca'a ti uchul. Ma' cuchi jadi' jede'ec u paatale'ex a betic ti'i a che' higo ada'a, le'ec a c'u' a uchi ti'iji. Jede'ec ilic cuchi a wadique'ex ca' joc'sabüc a witz ada'a, ca' pulbuc ich c'ac'naab y uchul ilic u ca'a cuchi,— cu t'an a Jesusu. ");
INSERT INTO mopNT_vpl VALUES ("MT21_22","070_21_22","MAT","21","22","22","—Le'ec a tulacal a c'u' a bele'ex a ca'a a c'aate ti'i a Dioso, bele'ex a ca'a a c'ümü' wa cuchi tane'ex a tz'ocsic a Dios tu jajili,— cu t'an a Jesusu. ");
INSERT INTO mopNT_vpl VALUES ("MT21_23","070_21_23","MAT","21","23","23","Pues te'i. Oqui a Jesus ichil u yotoch a Dioso. Tan u ca'ansicoo' a cristiano te'i. C'ochoo' etel a Jesus u noochiloo' u yaj mansaj t'an a cristiano ti'i a Dios u yet'ocoo' a nucuch winiqui. —¿C'u' a yanil ca' a bete' a jabix a tan a betiqui? ¿Mac u tz'aj tech a meyaj?— cu t'anoo' ti'i a Jesusu. ");
INSERT INTO mopNT_vpl VALUES ("MT21_24","070_21_24","MAT","21","24","24","—Bel ilic in quin c'aate te'ex jun p'eel a t'ana. Wa cuchi ca' a nuucte'ex ten, bel ilic in quin wadü' te'ex mac u tz'aj in yanil tanil in betic c'u' a tan in betiqui,— cu t'an a Jesus ti'ijoo'o. ");
INSERT INTO mopNT_vpl VALUES ("MT21_25","070_21_25","MAT","21","25","25","—¿Mac aj etel tali u yanil aj Juan ti tz'aj ocja'? Ade'ex ten wa etel Dios wa etel cristiano,— cu t'an a Jesus ti'ijoo'o. Cajoo' u tzicbalte abe' tu bajil. —Wa ca' ti wadü' wa ti'i Dios a ocja' u tz'aj aj Juana, bel u cu c'aate to'on c'u' ca'a ma' ti tz'ocsaj,— cu t'anoo' tu bajil. ");
INSERT INTO mopNT_vpl VALUES ("MT21_26","070_21_26","MAT","21","26","26","—Wa ca' ti wadü' wa ti'i a cristianojo, saaco'on ti'ijoo' u yaabil a cristiano u men tanoo' u laj tz'ocsic ti u yadaj u t'an a Dios aj Juana,— cu t'anoo' tu bajil. ");
INSERT INTO mopNT_vpl VALUES ("MT21_27","070_21_27","MAT","21","27","27","—Ma' ti weel biqui'il u yanil aj Juana,— cu t'anoo' ti'i a Jesus ti uchoo' u nuuc. —Y ma' xan tin wadic te'ex c'u' in yanil in bete' c'u' a walac in betiqui,— cu t'an a Jesus ti'ijoo'o. ");
INSERT INTO mopNT_vpl VALUES ("MT21_28","070_21_28","MAT","21","28","28","—Pues te'i. ¿Biqui'ile'ex a tucul yoc'ol a t'an ada'a?— cu t'an a Jesusu. —Jun tuul a winiqui, yan u mejen ca' tuul. Bini etel u mejen a jun tuulu. “Ca' xiquech ti meyaj ich col,” cu t'an ti'i a jun tuulu,— cu t'an a Jesusu. ");
INSERT INTO mopNT_vpl VALUES ("MT21_29","070_21_29","MAT","21","29","29","—“Ma' in c'ati beel,” cu t'an ti uchi u nuuc. Mas pachili, u jelaj u tucul. Bini ilic ich col,— cu t'an a Jesusu. ");
INSERT INTO mopNT_vpl VALUES ("MT21_30","070_21_30","MAT","21","30","30","—Bini a tattzil etel u mejen ulaac' a jun tuulu. Baalo' ilic u yadaj ti'i. “Jede'ec in beel inene, noochwinic,” cu t'an ti uchi u nuuc. C'u' betiqui, ma' ilic bini,— cu t'an a Jesusu. ");
INSERT INTO mopNT_vpl VALUES ("MT21_31","070_21_31","MAT","21","31","31","—¿Mac tu yaam abe'e, u betaj a jabix u c'ati u tata?— cu t'an a Jesus ti'ijoo' a noochoo' u wichil u meyaja. —Le'ec abe' a payanbej aalbi ti'iji,— cu t'anoo' ti'i a Jesusu. —Tan in wadic te'ex u jajil. Le'ec a yanoo' u yanil ti mol taq'uin ti'i a gobierno u yet'ocoo' a c'ac'as ix ch'upu, le'ec a mas jede'ecoo' u yocol tu cuenta a Dios ta wiche'ex inche'exe,— cu t'an a Jesus ti'ijoo' a noochoo' u wichil u meyaja. ");
INSERT INTO mopNT_vpl VALUES ("MT21_32","070_21_32","MAT","21","32","32","—Le'ec aj Juan aj tz'aj ocja'a, c'ochi ta wetele'ex u yee' te'ex biqui'il a toj na'ata. Ma' a tz'ocsaje'ex u t'an. C'u' betiqui, a yanoo' u yanil ti mol taq'uin ti'i a gobierno u yet'ocoo' a c'ac'as ix ch'upu, u tz'ocsajoo' u t'an. Ca'ax a wilaje'ex ti tanoo' u tz'ocsic aj Juan ala'oo'o, ma' a jelaje'ex a tucul a tz'ocse'ex aj Juan inche'exe,— cu t'an a Jesus ti'ijoo'o. ");
INSERT INTO mopNT_vpl VALUES ("MT21_33","070_21_33","MAT","21","33","33","—Pues te'i. U'ye'ex ulaac' a mucult'ana. Jun tuul a ayic'ala, u püc'aj u cuuch püc'aal. U cotaj. U betaj c'u' aj etel u joc'sic u c'a' u wich a püc'aala. U betaj ilic jun p'eel a rancho a ca'nal ti'i u cününbeeb a püc'aala. U tz'aj ti maanil u cuuch a püc'aala. Yan u tz'abül ti'i tz'etz'eecac u wich ti'i u tool u maanbeeb. Bini u yumil ichil ulaac' a lu'umu,— cu t'an a Jesusu. ");
INSERT INTO mopNT_vpl VALUES ("MT21_34","070_21_34","MAT","21","34","34","—Le'ec ti watac u q'uinil u tücül u wich a püc'aala, le'ec u yumil u cuuch a püc'aala, u tücaa'taj u yaj meyaj ti'i ca' u c'ümü' tz'etz'eecac tanil u maanbül u cuuch a püc'aala,— cu t'an a Jesusu. ");
INSERT INTO mopNT_vpl VALUES ("MT21_35","070_21_35","MAT","21","35","35","—Müchboo' u men a tanoo' u maan. Jütz'bi a jun tuul u menoo'. Quimsabi ulaac'. P'up'uchch'inbi ulaac' etel tunich,— cu t'an a Jesusu. ");
INSERT INTO mopNT_vpl VALUES ("MT21_36","070_21_36","MAT","21","36","36","—Le'ec u yumil a püc'aala, u ca' tücaa'tajoo' ulaac' u yaj meyaj ti mas yaab. Baalo' ilic a betabi ti'ijoo'o,— cu t'an a Jesusu. ");
INSERT INTO mopNT_vpl VALUES ("MT21_37","070_21_37","MAT","21","37","37","—Mas pachili, u tücaa'taj u mejen eteloo' a tanoo' u maantic u cuuch u püc'aala. “Jede'ecoo' u tz'ocsic u yanil in mejene,” cu t'an tu bajil,— cu t'an a Jesusu. ");
INSERT INTO mopNT_vpl VALUES ("MT21_38","070_21_38","MAT","21","38","38","—Pues te'i. Le'ecoo' aj maana, u yilajoo' u mejen u yumil a püc'aala. “Le'ec ado' u mejen u yumil a püc'aala. Co'ne'ex ti quimes, ca' p'aatüc to'on u cuuchil a püc'aala,” cu t'anoo' tu bajil,— cu t'an a Jesusu. ");
INSERT INTO mopNT_vpl VALUES ("MT21_39","070_21_39","MAT","21","39","39","—U müchajoo'. U bensajoo' pach cot. U quimsajoo',— cu t'an a Jesusu. ");
INSERT INTO mopNT_vpl VALUES ("MT21_40","070_21_40","MAT","21","40","40","—Pues te'i. Le'ec ca' c'ochoc u yumil u cuuch a püc'aala, ¿c'u' a bel u cu bete' ti'ijoo' a tanoo' u maana?— cu t'an a Jesus ti'ijoo' a cristianojo. ");
INSERT INTO mopNT_vpl VALUES ("MT21_41","070_21_41","MAT","21","41","41","—Ma' tu ch'a'icoo' u yotzilil a c'ac'as cristiano abe'e. Bel u cu quimesoo'. Pachili, bel u cu tz'aa' u cuuch u püc'aal ti'ijoo' a jede'ecoo' u bo'tic u tool u maanbeeb ti c'ochoc u q'uinili,— cu t'anoo' ti'i a Jesusu. ");
INSERT INTO mopNT_vpl VALUES ("MT21_42","070_21_42","MAT","21","42","42","—A xocaje'ex ichil u ju'um a Dios a t'an ada' a bel to in quin wadü' te'exe,— cu t'an a Jesus ti'ijoo'o. —“Le'ec a jun cuul a tunich a ma' u c'atiintajoo' cuchi aj men naja, culaji ilic ti'i u wa'taan a naja. Le'ec a Noochtzil u tz'aj ca' culac ti baalo'. Top quich'pan tiqui wich c'u' u betaja.” Baalo' ti tz'iiba'an,— cu t'an a Jesusu. ");
INSERT INTO mopNT_vpl VALUES ("MT21_43","070_21_43","MAT","21","43","43","—Tan in wadic te'ex. Le'ec inche'ex jabixe'ex aj maan u cuuch püc'aala. Le'ec u cuuch u püc'aala, le'ec jabix u qui'il a Dioso. Bel u ca'a tocbol te'ex. Bel u ca'a tz'abül ti'ijoo' ulaac' a cristiano a jede'ecoo' u tz'eec u wichi,— cu t'an a Jesus ti'ijoo'o. ");
INSERT INTO mopNT_vpl VALUES ("MT21_44","070_21_44","MAT","21","44","44","—Inen jabix a tunich a ma' u c'atiintajoo' aj men naja. Le'ec mac ca' c'axüc yoc'ol a tunich abe'e, bel u ca'a ti jabix caachül. Le'ec mac aj yoc'ol u c'axül a tunich abe'e, bel u ca'a ti jabix p'uuyul jumpul u men u sip'il,— cu t'an a Jesusu. ");
INSERT INTO mopNT_vpl VALUES ("MT21_45","070_21_45","MAT","21","45","45","Pues te'i. Le'ecoo' u noochil u yaj mansaj t'an a cristiano ti'i a Dioso, u yet'ocoo' a fariseo u c'aba'oo' u na'ata, u na'tajoo' ti tanoo' ilic u tzicbalbül ichil a mucult'an abe'e. ");
INSERT INTO mopNT_vpl VALUES ("MT21_46","070_21_46","MAT","21","46","46","U c'atiintajoo' cuchi u müchü' a Jesusu. C'u' betiqui, u yaabil a cristianojo, walacoo' u tz'ocsic ti tan u yadic u t'an a Dios a Jesusu, mentücü, saacoo' u müchü'. ");
INSERT INTO mopNT_vpl VALUES ("MT22_1","070_22_1","MAT","22","1","1","Pues te'i. Le'ec a Jesusu, u ca' adaj a mucult'an ti'ijoo' a cristianojo. ");
INSERT INTO mopNT_vpl VALUES ("MT22_2","070_22_2","MAT","22","2","2","—Le'ec biqui ti walac u tücaa' a Dioso, c'üs quet etel a rey a bel u cu tz'aa' uc'ul ti'ijoo' u yaj sutil ti tan u tz'ocolbeel u mejen,— cu t'an a Jesusu. ");
INSERT INTO mopNT_vpl VALUES ("MT22_3","070_22_3","MAT","22","3","3","—U tücaa'tajoo' u yaj meyaj u püyoo' a chiita'anoo' ti emel ti uc'ul etel aj tz'ocolbeele. C'u' betiqui, ma' u c'atoo' c'ochol,— cu t'an a Jesusu. ");
INSERT INTO mopNT_vpl VALUES ("MT22_4","070_22_4","MAT","22","4","4","—“U'yeene'ex. Quimsaboo' a wacaxa. Quimsaboo' ilic u yal a wacax a quelemoo'o. Utzquinbi a janala. Utzquinbi tulacal. Ca' talaque'ex ti fiesta ti'i a tz'ocolbeele,” que'exac ti'ijoo' a chiita'ana,” cu t'an a rey ti'ijoo' ulaac' u yaj meyaj,— cu t'an a Jesusu. ");
INSERT INTO mopNT_vpl VALUES ("MT22_5","070_22_5","MAT","22","5","5","—C'u' betiqui, a chiita'anoo'o, u betajoo' jabix ma' c'u' u t'anoo' ti'iji. Chen binoo' tuba u c'atoo'. Jun tuulu, bini ich col. Ulaac' a jun tuulu, bini ti conol,— cu t'an a Jesusu. ");
INSERT INTO mopNT_vpl VALUES ("MT22_6","070_22_6","MAT","22","6","6","—Le'ecoo' u chucaana, u müchajoo' u yaj meyaj a reye. U p'a'astajoo'. Yan u quimsajoo'o,— cu t'an a Jesusu. ");
INSERT INTO mopNT_vpl VALUES ("MT22_7","070_22_7","MAT","22","7","7","—Top tz'iicaji a reye. U tücaa'tajoo' u soldado. U quimsajoo' aj quimsaj abe'e. U chuwajoo' u caal,— cu t'an a Jesusu. ");
INSERT INTO mopNT_vpl VALUES ("MT22_8","070_22_8","MAT","22","8","8","—“Le'ec a janal etel aj tz'ocolbeele, listo tun. C'u' betiqui, a chiita'anoo'o, ma' u c'atoo' c'ochol,” cu t'an a rey ti'ijoo' u yaj meyaj,— cu t'an a Jesusu. ");
INSERT INTO mopNT_vpl VALUES ("MT22_9","070_22_9","MAT","22","9","9","—“U men ma' u c'atoo' c'ochol a chiitboo'o, ca' xique'ex ti calle. Chiite'ex boon a ca' a cüxte'ex te'i ca' c'ochocoo' ti fiesta,” cu t'an a rey ti'ijoo' u yaj meyaj,— cu t'an a Jesusu. ");
INSERT INTO mopNT_vpl VALUES ("MT22_10","070_22_10","MAT","22","10","10","—Binoo' u yaj meyaj abe' ti calle. U chiitajoo' boon tuul u cüxtajoo' te'i ca'ax qui' u na'at ca'ax c'as u na'at. Baalo' ti tudi a naj eteloo' u yaj sutil aj tz'ocolbeele,— cu t'an a Jesusu. ");
INSERT INTO mopNT_vpl VALUES ("MT22_11","070_22_11","MAT","22","11","11","Pues te'i. C'ochi a rey u yiloo' u yaj sutil. U yilaj jun tuul a winic a ma' yan u noq'uil a fiesta yoc'ol,— cu t'an a Jesusu. ");
INSERT INTO mopNT_vpl VALUES ("MT22_12","070_22_12","MAT","22","12","12","—Amigo, ¿biqui ti oqueech wa'ye' ti ma' yan tech u noq'uil a fiestaja?” cu t'an a rey ti'iji. Ma' yan u t'an a winiqui,— cu t'an a Jesusu. ");
INSERT INTO mopNT_vpl VALUES ("MT22_13","070_22_13","MAT","22","13","13","—“C'üxü u c'ü' u yoc. Joq'uese'ex wa'ye'. Pule'ex ich ac'ü'il pach naj. Le'ecoo' a cristiano pach naja, beloo' u ca'a ti oc'ol. Jürütlemacoo' xan u ca'a u coj u menoo' u yajil,” cu t'an a rey ti'ijoo' a tanoo' u cününtic aj sutili,— cu t'an a Jesusu. ");
INSERT INTO mopNT_vpl VALUES ("MT22_14","070_22_14","MAT","22","14","14","—Uchul u ca'a ti baalo' u men yan ti yaab a chiita'an ti'i ca' ococoo'o. C'u' betiqui, ma' yan ti yaab a yeeta'an ti'i ca' ococoo'o,— cu t'an a Jesusu. ");
INSERT INTO mopNT_vpl VALUES ("MT22_15","070_22_15","MAT","22","15","15","Pues te'i. Muchlajoo' a fariseo u c'aba'oo' u na'at tu junal u tzicbaltoo' tu bajil biqui ca' u cho'oo' a Jesus etel ilic a c'u' a tan u yadiqui. ");
INSERT INTO mopNT_vpl VALUES ("MT22_16","070_22_16","MAT","22","16","16","Le'ecoo' u yaj cambal a fariseo u yet'ocoo' a herodiano u c'aba'oo' u na'ata, tücaa'boo' etel a Jesusu. —Maestro, ti weel. Walac a wadic a jaja. Walac a ye'ic u jajil yoc'ol biqui u c'ati a Dioso. Ma' yan a saaquil. Ma' ta'ach a tz'eec ti cuenta wa nooch u wichil u meyaj a maca, wa ma',— cu t'anoo' ti'i a Jesusu. ");
INSERT INTO mopNT_vpl VALUES ("MT22_17","070_22_17","MAT","22","17","17","—¿Biqui'il a tucul? Adü to'on wa yan ti tz'eec a taq'uin a walac u tücaa'tic ca' molboc a rey Cesara, wa ma',— cu t'anoo' ti'i a Jesusu. ");
INSERT INTO mopNT_vpl VALUES ("MT22_18","070_22_18","MAT","22","18","18","Le'ec a Jesusu, u yeel. Chen ti'i u cho'icaloo' ti tanoo' u c'aatic ti'i. —¿C'u' ca'a tane'ex a yaaltic a wila' wa patalen? Inche'exe, aj cho'e'ex,— cu t'an a Jesus ti'ijoo'o. ");
INSERT INTO mopNT_vpl VALUES ("MT22_19","070_22_19","MAT","22","19","19","—Ye'e'ex ten a taq'uin a walac u tücaa'tic molbol a reye,— cu t'an a Jesus ti'ijoo'o. U talesajoo' a taq'uin jun p'eele. ");
INSERT INTO mopNT_vpl VALUES ("MT22_20","070_22_20","MAT","22","20","20","—¿Mac aj ich a que'en tuwichi? ¿Mac ti'i a c'aba' a que'en te'iji?— cu t'an a Jesus ti'ijoo'o. ");
INSERT INTO mopNT_vpl VALUES ("MT22_21","070_22_21","MAT","22","21","21","—Le'ec a reye,— cu t'anoo' ti'i. —Ca' tz'aa' ti'i a rey le'ec a c'u' a ti'i a reye. Ca' tz'aa' ti'i a Dios le'ec a c'u' a ti'i a Dioso,— cu t'an a Jesus ti'ijoo'o. ");
INSERT INTO mopNT_vpl VALUES ("MT22_22","070_22_22","MAT","22","22","22","Le'ec ca' u yubajoo' abe'e, sa'too' u yool. Joc'oo' te'i. Binoo'. ");
INSERT INTO mopNT_vpl VALUES ("MT22_23","070_22_23","MAT","22","23","23","Pues te'i. Ti'i ilic a q'uin abe'e, c'ochoo' etel a Jesus a saduceo u c'aba'oo' u na'ata. Ala'oo'o, ma' ta'achoo' u tz'ocsic wa ca' cuxtal u ca'a a quimene. U c'aatajoo' ti'i. ");
INSERT INTO mopNT_vpl VALUES ("MT22_24","070_22_24","MAT","22","24","24","—Maestro, baala' u yadaj aj Moisese: “Wa cuchi ca' quimic a mac ti ma' yan u mejene, le'ec u yitz'ini, yan u yütantic u mu' ca' yanac jun tuulac u mejen jabix u mejen a quimene,” cu t'an aj Moisese,— cu t'anoo' a saduceo ti'i a Jesusu. ");
INSERT INTO mopNT_vpl VALUES ("MT22_25","070_22_25","MAT","22","25","25","—Pues te'i. Tiqui yaam yanaji siete tuul a winiqui, u yitz'inoo' u bajil. U cüxtaj u yütan a sucu'untzili. Quimi ti ma' yanaji u mejen. P'aati u yütan a quimen ti'i u yitz'in,— cu t'anoo' a saduceojo. ");
INSERT INTO mopNT_vpl VALUES ("MT22_26","070_22_26","MAT","22","26","26","—Quimi ilic ala'aji, y ma' yanaji u mejen. P'aati u yütan ti'i a mas itz'intzili. Baalo' ilic a uchi ti'ijoo' tu siete tuulili. Laj quimoo'. ");
INSERT INTO mopNT_vpl VALUES ("MT22_27","070_22_27","MAT","22","27","27","Mas pachili, quimi ilic a nooch'upu,— cu t'anoo' a saduceo ti'i a Jesusu. ");
INSERT INTO mopNT_vpl VALUES ("MT22_28","070_22_28","MAT","22","28","28","—Pues te'i. Le'ec ti ca' cuxlacoo' a quimene, ¿mac tu yaam a siete tuul u yicham a nooch'up abe'e? Tulacal a siete tuulu, u laj ichamtaj ala'aji,— cu t'anoo' a saduceo ti'i a Jesusu. ");
INSERT INTO mopNT_vpl VALUES ("MT22_29","070_22_29","MAT","22","29","29","—Ma' toje'ex a t'an u men ma' a weele'ex u t'an a Dioso, ma'ax u muc' a Dioso,— cu t'an a Jesus ti'ijoo' ti uchi u nuuc. ");
INSERT INTO mopNT_vpl VALUES ("MT22_30","070_22_30","MAT","22","30","30","—Le'ec ca' cuxlac a quimene, ma' tu tz'abül u yütan, ma'ax u yicham, p'aatüloo' u ca'a jabix ilic u yaj xa'num a Dios ti ca'ana,— cu t'an a Jesus ti'ijoo'o. ");
INSERT INTO mopNT_vpl VALUES ("MT22_31","070_22_31","MAT","22","31","31","—Pues te'i. Uxtun a ca' cuxtal tu yaamoo' a quimene. A xocaje'ex u t'an a Dios a tz'iiba'an te'exe,— cu t'an a Jesus ti'ijoo' a saduceo u c'aba'oo' u na'ata. ");
INSERT INTO mopNT_vpl VALUES ("MT22_32","070_22_32","MAT","22","32","32","—“Inen u Dios aj Abraham. Inen u Dios aj Isaac. Inen u Dios aj Jacob,” cu t'an a Dioso. Baalo' ti tz'iiba'an,— cu t'an a Jesusu. —Ca'ax uchben quimen ala'oo'o, le'ec a Dioso, ma' u Diosil a quimene. Ala'aji, u Diosil a cuxa'ana, mentücü, yan a ca' cuxtal tu yaamoo' a quimene,— cu t'an a Jesus ti'ijoo' a saduceojo. ");
INSERT INTO mopNT_vpl VALUES ("MT22_33","070_22_33","MAT","22","33","33","Sa'too' u yool u yaabil a cristiano etel c'u' a tan u ye'ic a Jesusu. ");
INSERT INTO mopNT_vpl VALUES ("MT22_34","070_22_34","MAT","22","34","34","Pues te'i. Le'ecoo' a fariseo u c'aba'oo' u na'ata, u yubajoo' ti ma' ca' paatajoo' a saduceo u nuucte a Jesusu. Much'lajoo' tu bajil a fariseojo. ");
INSERT INTO mopNT_vpl VALUES ("MT22_35","070_22_35","MAT","22","35","35","Tu yaamoo' ala'oo'o, yan u yaj ca'ansajil u ley aj Moisese. Jun tuul tu yaamoo' abe'e, u c'aataj ti'i a Jesus ti'i ca' u yila' wa patal u nuucte. ");
INSERT INTO mopNT_vpl VALUES ("MT22_36","070_22_36","MAT","22","36","36","—Maestro,— cu t'an ti'i a Jesusu. —¿C'u' ti leyil a mas c'abeet tu yaam u chucaan a ley u tz'iibtaj aj Moisese?— cu t'an ti'i a Jesusu. ");
INSERT INTO mopNT_vpl VALUES ("MT22_37","070_22_37","MAT","22","37","37","—Yan a yacuntic a Noochtzil le'ec a Dios tulacal a püsüc'al, tulacal a wool, y tulacal a tucul,— cu t'an a Jesus ti'iji. ");
INSERT INTO mopNT_vpl VALUES ("MT22_38","070_22_38","MAT","22","38","38","—Le'ec abe' a ley a mas c'abeete. ");
INSERT INTO mopNT_vpl VALUES ("MT22_39","070_22_39","MAT","22","39","39","Le'ec u ca' p'eel a leye, c'üs quet u c'abeetil etel. Jabix ilic ti yaj a wu'yi a bajil ta bajili, baalo' ilic yan a yacuntic a wet'oc,— cu t'an a Jesusu. ");
INSERT INTO mopNT_vpl VALUES ("MT22_40","070_22_40","MAT","22","40","40","—Le'ec u chucaan a ley u tz'iibtaj aj Moises etel a t'an u tz'iibtaj a cristiano u yadajoo' u t'an a Dios uchiji, laj tz'iiba'an ti'i u yaantical u tz'ocsabül a ca' p'eel a ley abe'e,— cu t'an a Jesus ti'i a winiqui. ");
INSERT INTO mopNT_vpl VALUES ("MT22_41","070_22_41","MAT","22","41","41","Pues te'i. Le'ec a Jesusu, u c'aataj ti'ijoo' a fariseo u c'aba'oo' u na'at le'ec ti much'a'anoo' to tu bajil. ");
INSERT INTO mopNT_vpl VALUES ("MT22_42","070_22_42","MAT","22","42","42","—¿Biqui'ile'ex a tucul yoc'ol a Cristojo? ¿Mac u uchben mamaa'?— cu t'an a Jesus ti'ijoo' a fariseojo. —Le'ec aj quimen rey Davidi, le'ec u uchben mamaa',— cu t'anoo' ti'i. ");
INSERT INTO mopNT_vpl VALUES ("MT22_43","070_22_43","MAT","22","43","43","—Tz'abi ti'i aj David u men u Püsüc'al a Dios ca' u yadü' Noochil yoc'ol a Cristojo. Wa cuchi chen u mam aj David ala'aji, ¿c'u' ca'a u tzicbaltaj jabix u Noochil ala'aji?— cu t'an a Jesus ti'ijoo'o. ");
INSERT INTO mopNT_vpl VALUES ("MT22_44","070_22_44","MAT","22","44","44","—Baala' u yadaj aj Davidi: “Le'ec a Dios a Noochtzili, u yadaj ti'i in Noochil ca' tinlac tu yaj toj tu yaj seeb c'ü' u men u yanil asto u cho'icoo' a tz'iic ti'iji. P'aatüloo' u ca'a jabix yalam u yoc,” cu t'an u t'an a Dios a tz'iiba'an u men aj Davidi,— cu t'an a Jesusu. ");
INSERT INTO mopNT_vpl VALUES ("MT22_45","070_22_45","MAT","22","45","45","—“In Noochil,” cu t'an aj David ti tan u tzicbaltic a Cristojo. Wa cuchi jadi' u mam aj David a Cristojo, ¿c'u' ca'a u tzicbaltaj ala'i jabix u Noochil?— cu t'an a Jesus ti'ijoo' a fariseo u c'aba'oo' u na'ata. ");
INSERT INTO mopNT_vpl VALUES ("MT22_46","070_22_46","MAT","22","46","46","Ma'ax mac paataji u nuucte ma'ax etel jun cuul t'an. Ti'i ilic a q'uin abe'e, u p'ütajoo' u c'aate a t'an etel a Jesusu. Saacajoo' u mas c'aatoo' ti'iji. ");
INSERT INTO mopNT_vpl VALUES ("MT23_1","070_23_1","MAT","23","1","1","Pues te'i. Le'ec a Jesusu, uchi u t'an eteloo' u yaj cambal u yet'ocoo' u chucaan a cristianojo. ");
INSERT INTO mopNT_vpl VALUES ("MT23_2","070_23_2","MAT","23","2","2","—Le'ecoo' u yaj ca'ansajil u ley aj Moises u yet'ocoo' a fariseo u c'aba'oo' u na'ata, walacoo' u ye'ic u t'an aj Moises, mentücü, ");
INSERT INTO mopNT_vpl VALUES ("MT23_3","070_23_3","MAT","23","3","3","tz'ocse'ex c'u' a walacoo' u yadic te'exe. C'u' betiqui, ma' a betique'ex c'u' a walacoo' u betiqui. Ala'oo'o, ma' ta'achoo' u tz'ocsic c'u' a walacoo' u yadiqui,— cu t'an a Jesus ti'ijoo'o. ");
INSERT INTO mopNT_vpl VALUES ("MT23_4","070_23_4","MAT","23","4","4","—Walacoo' u tz'eec a ley a chücyajil u tz'ocsabül, jabix cuchi tanoo' u tz'eec a cuch a top ala. Walacoo' u tz'eec ca' cuchbuc abe' u menoo' a cristianojo. C'u' betic ala'oo'o, ma' ta'achoo' u tz'eec a anata, ma'ax etel jun tziit u yal u c'ü',— cu t'an a Jesusu. ");
INSERT INTO mopNT_vpl VALUES ("MT23_5","070_23_5","MAT","23","5","5","—Tulacal a c'u' a walacoo' u betiqui, chen ti'i ca' ilbic u menoo' a cristianojo. Chen ti'i u yilbeebal, walacoo' u betic ti top nooch a tz'i' cajon tuba taac'a'an a tz'etz'eecac u t'an a Dios a walacoo' u c'üxic tu c'ü' y tu polo. Chen ti'i u yilbeebal, walacoo' u betic ti top chawac u toot u noc',— cu t'an a Jesusu. ");
INSERT INTO mopNT_vpl VALUES ("MT23_6","070_23_6","MAT","23","6","6","—Top qui'oo' tu wich a tintal tac taanil tu cuuchil a nooch u wichil u meyaj ti tan a fiesta wa ichil a naj tuba walacoo' u much'tal a cristiano u c'ajes a Dioso,— cu t'an a Jesusu. ");
INSERT INTO mopNT_vpl VALUES ("MT23_7","070_23_7","MAT","23","7","7","—Top qui'oo' tu xiquin ca' chiitbicoo' chumuc caj. Qui'oo' tu xiquin ca' aalbüc noochil ti'ijoo'o,— cu t'an a Jesusu. ");
INSERT INTO mopNT_vpl VALUES ("MT23_8","070_23_8","MAT","23","8","8","—C'u' betiqui, ma' qui' ca' aalbüc te'ex a noochil u men jun tuul ilic a noochile'ex a yana. Tulacale'ex inche'exe, a sucu'une'ex a witz'ine'ex a bajil,— cu t'an a Jesus ti'ijoo'o. ");
INSERT INTO mopNT_vpl VALUES ("MT23_9","070_23_9","MAT","23","9","9","—Ma' a chiitique'ex a winic jabix a tate'ex yoc'olcab u men jadi' jun tuul ilic a Tate'ex a yana, le'ec a que'en ti ca'ana,— cu t'an a Jesusu. ");
INSERT INTO mopNT_vpl VALUES ("MT23_10","070_23_10","MAT","23","10","10","—Ma' ilic qui' ca' aalbüc te'ex ti maestroje'ex u men jun tuul ilic a maestroje'ex a yana, le'ec a Cristojo,— cu t'an a Jesusu. ");
INSERT INTO mopNT_vpl VALUES ("MT23_11","070_23_11","MAT","23","11","11","—Le'ec a mas nooch u wichil u meyaj ta yaame'exe, le'ec a top walac u yanata,— cu t'an a Jesusu. ");
INSERT INTO mopNT_vpl VALUES ("MT23_12","070_23_12","MAT","23","12","12","—Le'ec a tan u tz'eec u bajil jabix cuchi top nooch u wichil u meyaja, bel u ca'a tz'abül ti'i ti jumpul ma' nooch u wichil u meyaji. Le'ec a tan u tz'eec u bajil jabix cuchi top ma' nooch u wichil u meyaja, bel u ca'a tz'abül ti'i ti nooch u wichil u meyaj,— cu t'an a Jesusu. ");
INSERT INTO mopNT_vpl VALUES ("MT23_13","070_23_13","MAT","23","13","13","—Pues te'i. Top yaj a bele'ex a ca'a a c'ümü' boon tuule'ex u yaj ca'ansajil u ley aj Moises a wet'oque'ex a fariseo u c'aba'oo' u na'ata. Inche'exe, aj cho'e'ex. Ma' ta'ache'ex a cha'ic u yocol a mac tu c'ü' a Dioso, jabix cuchi a c'ülaje'ex u puertajili. Ma' a c'ate'ex ocol inche'exe. Ma'ax tane'ex a cha'ic u yocol a mac a tan cuchi u yocolo,— cu t'an a Jesusu. ");
INSERT INTO mopNT_vpl VALUES ("MT23_14","070_23_14","MAT","23","14","14","—Top yaj a bele'ex a ca'a a c'ümü' boon tuule'ex u yaj ca'ansajil u ley aj Moises a wet'oque'ex a fariseo u c'aba'oo' u na'ata. Inche'exe, aj cho'e'ex. Walaque'ex a toquic u yotoch ix ma'ichama. Chawac u pach a t'ane'ex ti tane'ex a t'an etel a Dioso, chen ti'i ca' ilbique'ex u menoo' a cristiano jabix top qui' ti que'ene'ex etel a Dioso. Mas yaje'ex a sip'il ti bel u ca'a tz'abül te'ex,— cu t'an a Jesusu. ");
INSERT INTO mopNT_vpl VALUES ("MT23_15","070_23_15","MAT","23","15","15","—Top yaj a bele'ex a ca'a a c'ümü' boon tuule'ex u yaj ca'ansajil u ley aj Moises a wet'oque'ex a fariseo u c'aba'oo' u na'ata. Inche'exe, aj cho'e'ex. Chen ti'i ca' yanac jun tuul a waj cambale'exe, jede'eque'ex a beel tac junxeel a c'ac'naab wa junxeel ulaac' a lu'umu. Le'ec ti walac u yantale'ex a waj cambale'exe, walaque'ex a tz'eec ti'i ca' p'aatüc ti jabix ca' sut manal u c'asil ta wiche'ex inche'exe,— cu t'an a Jesus ti'ijoo'o. ");
INSERT INTO mopNT_vpl VALUES ("MT23_16","070_23_16","MAT","23","16","16","—Top yaj a bele'ex a ca'a a c'ümü' inche'exe. Chen toj a tane'ex a ye'ic cuchiji, y ma' a weele'ex jabixe'ex jun tuul aj ch'a'bej a ch'oopo. “Wa yan mac ca' u c'ajes u yotoch a Dios ichil u t'an ti tan u tz'eec u t'an u bete' a c'u'aca, ma'ax c'u' aj beel u t'an,” que'ex. “C'u' betiqui, wa ca' u c'ajes a oro a que'en ichil u yotoch a Dios ichil u t'an ti tan u tz'eec u t'an u bete' a c'u'aca, yan u betic,” que'ex,— cu t'an a Jesus ti'ijoo' a fariseojo. ");
INSERT INTO mopNT_vpl VALUES ("MT23_17","070_23_17","MAT","23","17","17","—Top tontoje'ex. Ma' ta'ache'ex a ch'a'ic u tojil. ¿C'u' a jabix mas nooch u yanili, le'ec wa a orojo, wa le'ec u yotoch a Dios a walac u tz'eec jabix u yanil a orojo?— cu t'an a Jesus ti'ijoo'o. ");
INSERT INTO mopNT_vpl VALUES ("MT23_18","070_23_18","MAT","23","18","18","—“Wa yan mac ca' u c'ajes u cuuchil u chuwbul a sij-ool ti'i Dios ichil u t'an ti tan u tz'eec u t'an u bete' a c'u'aca, ma'ax c'u' aj beel u t'an,” que'ex. “C'u' betiqui, wa ca' u c'ajes a sij-ool a tan u chuwul te'iji, yan u betic c'u' u yadaja,” que'ex,— cu t'an a Jesusu. ");
INSERT INTO mopNT_vpl VALUES ("MT23_19","070_23_19","MAT","23","19","19","—Jabixe'ex ch'oopo, u men ma' ta'ache'ex a ch'a'ic u tojil. C'u' a jabix mas nooch u yanili, le'ec wa a sij-oolo, wa le'ec u cuuchil u chuwbul a sij-oolo, u men walac u tz'eec a jabix u yanil a sij-oolo?— cu t'an a Jesus ti'ijoo' a fariseojo. ");
INSERT INTO mopNT_vpl VALUES ("MT23_20","070_23_20","MAT","23","20","20","—Ti baalo'o, le'ec mac a tan u c'ajsic u cuuchil u chuwbul a sij-ool ti'i a Dios ichil u t'an ti tan u tz'eec u t'an u bete' a c'u'aca, tan ilic u c'ajsic tulacal a c'u' a yan tuwichi,— cu t'an a Jesus ti'ijoo' a fariseojo. ");
INSERT INTO mopNT_vpl VALUES ("MT23_21","070_23_21","MAT","23","21","21","—Le'ec mac a tan u c'ajsic u yotoch a Dios ichil u t'an ti tan u tz'eec u t'an u bete' a c'u'aca, tan ilic u c'ajsic a Dios a que'en te'iji,— cu t'an a Jesusu. ");
INSERT INTO mopNT_vpl VALUES ("MT23_22","070_23_22","MAT","23","22","22","—Le'ec mac a tan u c'ajsic a ca'an ichil u t'an ti tan u tz'eec u t'an u bete' a c'u'aca, tan ilic u c'ajsic u tintaan a Dios y a Dios a tina'an te'iji,— cu t'an a Jesusu. ");
INSERT INTO mopNT_vpl VALUES ("MT23_23","070_23_23","MAT","23","23","23","—Top yaj a bele'ex a ca'a a c'ümü' boon tuule'ex u yaj ca'ansajil u ley aj Moises a wet'oque'ex a fariseo u c'aba'oo' u na'ata. Inche'exe, aj cho'e'ex. Ca'ax u xaac' janal jabix yerbabuena, anis y comino, walaque'ex a jützic ich diez p'uuch. Walaque'ex a tz'eec jun p'uuch ti'i a Dioso, ca' p'aatüc nueve p'uuch te'ex. C'u' betiqui, le'ec a mas c'abeete, ma' ta'ache'ex a betic. Tane'ex cuchi a betic a tojo. Tane'ex cuchi a ch'a'ic u yotzilil a maca. Tane'ex cuchi a tz'ocsic a Dioso. Tane'ex cuchi a betic tulacal abe'e, y ma' qui' a p'ütique'ex a betic a tz'etz'eec a tane'ex ilic a betiqui,— cu t'an a Jesus ti'ijoo' a fariseojo. ");
INSERT INTO mopNT_vpl VALUES ("MT23_24","070_23_24","MAT","23","24","24","—Chen toj a tane'ex a ye'ic cuchiji, y ma' a weele'ex jabixe'ex jun tuul aj ch'a'bej a ch'oopo. Walaque'ex a betic c'u' a ma' top c'abeete. C'u' betiqui, le'ec a top c'abeete, ma' ta'ache'ex a betic. Walaque'ex a betic jabix cuchi tane'ex a tziiltic a us ti'i ma' a nuq'uique'ex ichile'ex a wuc'ul, y jabix cuchi tane'ex a nuq'uic a noxi' baalche' u c'aba' camello ichili,— cu t'an a Jesus ti'ijoo'o. ");
INSERT INTO mopNT_vpl VALUES ("MT23_25","070_23_25","MAT","23","25","25","—Top yaj a bele'ex a ca'a a c'ümü' boon tuule'ex u yaj ca'ansajil u ley aj Moises a wet'oque'ex a fariseo u c'aba'oo' u na'ata. Inche'exe, aj cho'e'ex. Walaque'ex a tz'eec a bajile'ex jabix top qui'e'ex. C'u' betiqui, ichile'ex a püsüc'ala, chen aj xuuch'e'ex. Top jaq'ue'ex ichile'ex a püsüc'al. Walaque'ex a betic jabix tane'ex a p'o'ic u pach a pote y a platojo. C'u' betiqui, chen c'as a ichili,— cu t'an a Jesus ti'ijoo' a fariseojo. ");
INSERT INTO mopNT_vpl VALUES ("MT23_26","070_23_26","MAT","23","26","26","—Le'eque'ex a fariseoje'exe, jabixe'ex ch'oopo, u men ma' ta'ache'ex a ch'a'ic u tojil. Payanbej p'o'e'ex a jabix a ichile'ex a pote a platojo. Ti baalo'o, p'aatül u ca'a ti p'o'a'an ilic a tu pacha,— cu t'an a Jesus ti'ijoo'o. ");
INSERT INTO mopNT_vpl VALUES ("MT23_27","070_23_27","MAT","23","27","27","—Top yaj a bele'ex a ca'a a c'ümü' boon tuule'ex u yaj ca'ansajil u ley aj Moisese, a wet'oque'ex a fariseo u c'aba'oo' u na'ata. Inche'exe, aj cho'e'ex. Inche'exe, jabixe'ex u cuuchil tuba mucbi a quimene. Bona'an etel c'uta'an. Quich'pan ca' a wila'. C'u' betic ichili, chen u baq'uel quimen a yana. Chen ca'ax c'u'ac ti c'asil a yan te'iji,— cu t'an a Jesus ti'ijoo' a fariseojo. ");
INSERT INTO mopNT_vpl VALUES ("MT23_28","070_23_28","MAT","23","28","28","—Baalo' ilic inche'exe, top toje'ex a na'at ca' u yiloo' a cristianojo. C'u' betic ichile'ex a püsüc'ala, chen aj cho'e'ex. Chen c'as a yan te'iji,— cu t'an a Jesus ti'ijoo'o. ");
INSERT INTO mopNT_vpl VALUES ("MT23_29","070_23_29","MAT","23","29","29","—Top yaj a bele'ex a ca'a a c'ümü' boon tuule'ex u yaj ca'ansajil u ley aj Moisese, a wet'oque'ex a fariseo u c'aba'oo' u na'ata. Inche'exe, aj cho'e'ex. Walaque'ex a wutzquintic u cuuchil a quimen u yadajoo' u t'an a Dios uchi. Walaque'ex ilic a betic ti mas quich'pan u cuuchil a quimen a tojoo' u na'ata,— cu t'an a Jesus ti'ijoo'o. ");
INSERT INTO mopNT_vpl VALUES ("MT23_30","070_23_30","MAT","23","30","30","—“Ino'ono, wa cuchi cuxa'ano'on ti a q'uin ti quimsaboo' mac u yadajoo' u t'an a Dios uchiji, ma' cuchi ti wet'octajoo' ti uchben mamaa' ti quimes,” que'ex,— cu t'an a Jesus ti'ijoo' a fariseojo. ");
INSERT INTO mopNT_vpl VALUES ("MT23_31","070_23_31","MAT","23","31","31","—Ti baalo'o, tane'ex ilic a wadic ti le'ec inche'exe, u mame'ex boon tuul u quimsajoo' mac u yadajoo' u t'an a Dios uchi,— cu t'an a Jesus ti'ijoo'o. ");
INSERT INTO mopNT_vpl VALUES ("MT23_32","070_23_32","MAT","23","32","32","—Bele'ex a ca'a a chuculbes a sip'il a jabix u cajsajoo' a uchben mama'e'exe,— cu t'an a Jesus ti'ijoo' a fariseojo. ");
INSERT INTO mopNT_vpl VALUES ("MT23_33","070_23_33","MAT","23","33","33","—Inche'exe, jabixe'ex can u men a c'asile'exe. Inche'exe, jabixe'ex u yal can. ¿C'u' a bele'ex a ca'a a bete' ti'i a joc'sicale'ex a bajil ichile'ex a sip'il ti'i ma' a beele'ex ichil a infiernojo?— cu t'an a Jesus ti'ijoo' a fariseojo. ");
INSERT INTO mopNT_vpl VALUES ("MT23_34","070_23_34","MAT","23","34","34","—U men baalo' ti yan, bel in quin tücaa'te ta yaame'ex mac bel u cu yadü' in t'an te'ex. Bel in quin tücaa'te ta yaame'ex mac u yeel a jaja. Bel in quin tücaa'te ta yaame'ex u yaj ca'ansajil in t'an. Yan tu yaamoo' a chen bele'ex a ca'a a quimes ti baalo'o. Yan ilic tu yaamoo' a bele'ex a ca'a a quimes tuwich cruz. Yan ulaac' tucaye' a bele'ex a ca'a a jütz'ü' etel jatz' ichil boon a naj tuba walaque'ex a much'tal a c'ajse'ex a Dioso. Yan ilic ulaac' tucaye' a bele'ex a ca'a a tz'aa' a yaj ti'ijoo' cajil caj,— cu t'an a Jesus ti'ijoo' a fariseojo. ");
INSERT INTO mopNT_vpl VALUES ("MT23_35","070_23_35","MAT","23","35","35","—Tanil in tücaa'ticoo' ala'oo' te'ex ti baalo'o, p'aatül u ca'a jabix inche'ex ilic a quimsaje'ex boon tuul a toj u na'at a quimsaboo' yoc'olcab. Le'ec a payanbej quimsabiji, le'ec aj Abele. Toj u na'at ala'aji. Le'ec u yada' a quimsabiji, le'ec aj Zacariasa, le'ec u mejen aj Berequiasa. A quimsaje'ex ala'i tu yaam tuba walac u chuwbul a baalche' y tu taan a naj tuba walac u mansabül u t'an a cristiano ti'i a Dioso,— cu t'an a Jesus ti'ijoo' a fariseojo. ");
INSERT INTO mopNT_vpl VALUES ("MT23_36","070_23_36","MAT","23","36","36","—Tan in wadic te'ex u jajil. Inche'ex a cuxa'ane'ex aleebe, bele'ex a ca'a a bo'te tulacal a sip'il abe'e,— cu t'an a Jesus ti'ijoo'o. ");
INSERT INTO mopNT_vpl VALUES ("MT23_37","070_23_37","MAT","23","37","37","—Pues te'i. Le'eque'ex a cristiano ich caj Jerusalen, top walaque'ex a quimsic mac a tan u yadic u t'an a Dioso. Top walaque'ex a p'up'uchch'inticoo' ti'i ca' quimicoo' mac a tücaa'bi ta wetele'ex u men a Dioso. Boon sut in c'atiintaj cuchi in sa'alte'ex jabix jun tuul ixna' cax a walac u much'quintic u yal yalam u xic. C'u' betiqui, ma' a c'atiintaje'ex,— cu t'an a Jesus yoc'ol a caj Jerusalene. ");
INSERT INTO mopNT_vpl VALUES ("MT23_38","070_23_38","MAT","23","38","38","—U'ye'ex. Ma' tan u ca' cününbüle'ex a wotoch u men a Diosi,— cu t'an a Jesusu. ");
INSERT INTO mopNT_vpl VALUES ("MT23_39","070_23_39","MAT","23","39","39","—Inen tan in wadic te'ex. U men ma' tane'ex a ca' cününbül, seeba'an ma' ta ca' ilique'ex in wich tucaye'il asto ti ca' a wade'ex u qui'il u yaj tücaa' a Noochtzil a ca' uduc ta wetele'ex,— cu t'an a Jesus yoc'ol a caj Jerusalene. ");
INSERT INTO mopNT_vpl VALUES ("MT24_1","070_24_1","MAT","24","1","1","Pues te'i. Joq'ui a Jesus ichil u yotoch a Dioso. Tan to u beel a Jesus ti naatz'oo' u yaj cambal u yee'oo' u quich'panil a boon cuul a naj u yotoch a Dioso. ");
INSERT INTO mopNT_vpl VALUES ("MT24_2","070_24_2","MAT","24","2","2","—Tan in wadic te'ex u jajil. Ichil tulacal a naj ada' a tane'ex a wiliqui, ma'ax jun cuul a tunich a cuntal u ca'a yoc'ol u yet'oc. Laj bel u ca'a yojbol,— cu t'an a Jesus ti uchi u nuuc. ");
INSERT INTO mopNT_vpl VALUES ("MT24_3","070_24_3","MAT","24","3","3","Pues te'i. Le'ec ti tina'an a Jesus tuwich a witz u c'aba' Olivo, c'ochoo' u yaj cambal etel. Ma'ax mac ulaac' a que'enoo' te'iji. —Adü to'on biq'uin u yojbol u yotoch a Dioso. ¿C'u' u p'is ti ca' wataquech tucaye', y ti watac u jobol a yoc'olcaba?— cu t'anoo' u yaj cambal ti'iji. ");
INSERT INTO mopNT_vpl VALUES ("MT24_4","070_24_4","MAT","24","4","4","—Cününte'ex a bajil ti'i ma' a tz'ocsique'ex u tus a ma'ax maca,— cu t'an a Jesus ti uchi u nuuc. ");
INSERT INTO mopNT_vpl VALUES ("MT24_5","070_24_5","MAT","24","5","5","—Yan a watacoo'o. Beloo' u cu tz'aa' u bajil ti jabixenoo'. “Inen a Cristojo,” cu t'anacoo' ala'oo'. Beloo' u cu tusu' a yaaba,— cu t'an a Jesusu. ");
INSERT INTO mopNT_vpl VALUES ("MT24_6","070_24_6","MAT","24","6","6","—Bele'ex a ca'a a wu'yi ti tan a noxi' guerraja. Bele'ex a ca'a a wu'yi ti watac ilic ulaac' a noxi' guerraja. Ma' u jac'üle'ex a wool. Yan u yuchul abe'e, pero ma'ax to c'ochoc u jobeeb,— cu t'an a Jesus ti'ijoo' u yaj cambala. ");
INSERT INTO mopNT_vpl VALUES ("MT24_7","070_24_7","MAT","24","7","7","—Bel u ca'a ti p'isbaj a noxi' caj etel ulaac' a noxi' caja. Bel ilic u ca'a u tz'aa' a p'isbaj jun tuul a rey etel ulaac' a reye,— cu t'an a Jesusu. —Yantal u ca'a a wi'ijil yaab ca'ax tubajac. Yaaboo' a cristiano a beloo' u cu c'ümü' a c'ac'as c'oja'anil yaab ca'ax tubajac. Yantal u ca'a a yuc'laj yaab ca'ax tubajac,— cu t'an a Jesusu. ");
INSERT INTO mopNT_vpl VALUES ("MT24_8","070_24_8","MAT","24","8","8","—Tulacal abe'e, chen u cajeeb a yaj a wataca,— cu t'an a Jesusu. ");
INSERT INTO mopNT_vpl VALUES ("MT24_9","070_24_9","MAT","24","9","9","—Pues te'i. Bele'ex a ca'a c'ubbul ti'i ca' yajcunbuque'ex wa ti'i ca' quimsabüque'ex. U men tene'exe, bele'ex a ca'a motzinbil u men tulacal a yoc'olcaba,— cu t'an a Jesus ti'ijoo' u yaj cambala. ");
INSERT INTO mopNT_vpl VALUES ("MT24_10","070_24_10","MAT","24","10","10","—Ti'i ilic a q'uin abe'e, yaaboo' a beloo' u cu p'üteen. Beloo' u cu tzolo' u yet-hermanojil. Beloo' u cu motzinte u yet-hermanojil,— cu t'an a Jesusu. ");
INSERT INTO mopNT_vpl VALUES ("MT24_11","070_24_11","MAT","24","11","11","—Yantal ilic u ca'a yaab mac a tanoo' u yadic ti tanoo' u yadic in t'an. C'u' betiqui, chenoo' u tus. Beloo' u cu cho' a yaaba,— cu t'an a Jesusu. ");
INSERT INTO mopNT_vpl VALUES ("MT24_12","070_24_12","MAT","24","12","12","—U men top bel u ca'a ti tza'cül a sip'il ca'ax tubajac yoc'olcaba, u yaabil a hermanojo, ma' ca' yaj u yuboo' u bajil,— cu t'an a Jesusu. ");
INSERT INTO mopNT_vpl VALUES ("MT24_13","070_24_13","MAT","24","13","13","—Le'ec mac ca' u muc'yajte tac tu jobeebe, bel u ca'a sa'albül,— cu t'an a Jesusu. ");
INSERT INTO mopNT_vpl VALUES ("MT24_14","070_24_14","MAT","24","14","14","—Le'ec u pectzil a Dios yoc'ol biqui ca' ococ a mac tu c'ü' a Dioso, yan u yaalbül tulacal tubajac yoc'olcab ti'i ca' u'yajbüc u menoo' a cristianojo. Le'ec ti u'yajbiji, jobol u ca'a a yoc'olcaba,— cu t'an a Jesusu. ");
INSERT INTO mopNT_vpl VALUES ("MT24_15","070_24_15","MAT","24","15","15","Pues te'i. —Le'ec mac ca' u xoco' a bel to in quin tz'iibteje, in c'ati cuchi ca' u ch'aa' u tojil,— cu t'an aj Mateo, le'ec mac u tz'iibtaj ada'a. —Le'ec aj Daniele, u yadaj u t'an a Dios uchi,— cu t'an a Jesusu. —U yadaj ti bel u ca'a ti uchul a top c'as ichil jun p'eel cuuchil a ti'i a Dioso. Baalo' u yadaj aj Daniele,— cu t'an a Jesusu. —Le'ec ti tane'ex a wilic u yuchul a c'u' u tzicbaltaj aj Daniele, ");
INSERT INTO mopNT_vpl VALUES ("MT24_16","070_24_16","MAT","24","16","16","le'ec a que'enoo' ich cuenta Judeaja, yanoo' u puutz'ul yaam witz,— cu t'an a Jesusu. ");
INSERT INTO mopNT_vpl VALUES ("MT24_17","070_24_17","MAT","24","17","17","—Le'ec a que'en pach naja, ma' qui' u beel ichil u yotoch ti'i u molical a c'u' a ti'iji. Sabeensil u müchbül. Jadi' qui' u puutz'ul,— cu t'an a Jesusu. ");
INSERT INTO mopNT_vpl VALUES ("MT24_18","070_24_18","MAT","24","18","18","—Le'ec a que'en ich colo, ma' qui' ma'ax u beel u molo' u noc' u joc'saj ti caji ti meyaj. Jadi' qui' u puutz'ul,— cu t'an a Jesusu. ");
INSERT INTO mopNT_vpl VALUES ("MT24_19","070_24_19","MAT","24","19","19","—Yaj ti c'axül u ca'a ti'ijoo' ix ch'up a watac u yal u yet'ocoo' a tanoo' u tz'aj chu' ti a q'uin abe'e, u men ma' tu paataloo' ti puutz'ul,— cu t'an a Jesusu. ");
INSERT INTO mopNT_vpl VALUES ("MT24_20","070_24_20","MAT","24","20","20","—C'aate'ex ti'i a Dios yoc'ol ma' a puutz'ule'ex tu q'uinil a ja'ja'ili, ma'ax tu q'uinil a jedele, yoc'ol ca' paataque'ex ti puutz'ul,— cu t'an a Jesusu. ");
INSERT INTO mopNT_vpl VALUES ("MT24_21","070_24_21","MAT","24","21","21","—Le'ec a yaj a yantal u ca'a ti'i a q'uin abe'e, ma'ax jun sut uchuc ti top yaj ti baalo' asto ti yaax yanaji a yoc'olcab y tac leeb,— cu t'an a Jesusu. —Ma'ax tu ca' yantal tu pach abe'e,— cu t'an a Jesusu. ");
INSERT INTO mopNT_vpl VALUES ("MT24_22","070_24_22","MAT","24","22","22","—Le'ec a Dioso, u tz'aj ti ma' yaab q'uin ca' uchuc a yaj abe'e. Wa cuchi ma' u tz'aj ti baalo'o, ma'ax cuchi mac ti cristianojil jede'ec u muc'yajtiqui. C'u' betic a Dioso, u ch'a'ajoo' u yotzilil a yeeta'anoo'o, mentücü, u tz'aj ti ma' yaab q'uin ca' uchuc a yaj abe'e,— cu t'an a Jesusu. ");
INSERT INTO mopNT_vpl VALUES ("MT24_23","070_24_23","MAT","24","23","23","—Pues te'i. Ti a q'uin abe'e, wa yan mac ca' u yadü' te'ex ti wa'ye' que'en a Cristo wa tedo' que'ene, ma' a tz'ocsique'ex u t'an,— cu t'an a Jesusu. ");
INSERT INTO mopNT_vpl VALUES ("MT24_24","070_24_24","MAT","24","24","24","—Yanoo' a beloo' u cu yadü' u bajil ti Cristojoo' ala'oo', pero chenoo' u tus. Yanoo' a beloo' u cu yadü' ti tücaa'boo' u men a Dioso, pero chenoo' u tus. Beloo' u cu bete' a noxi' milagro ti yaab ti'i u p'is ti jajoo' u t'an chen ti'i u cho'icoo' a cristianojo. Wa cuchi yan biquiji, cho'bol u ca'a cuchi a yeeta'anoo' ilic xan,— cu t'an a Jesus ti'ijoo' u yaj cambala. ");
INSERT INTO mopNT_vpl VALUES ("MT24_25","070_24_25","MAT","24","25","25","—Ac in wadaj tun te'ex ada'a, le'ec ti ma'ax to uchuc ti'i ma' a cho'bole'ex,— cu t'an a Jesus ti'ijoo' u yaj cambala. ");
INSERT INTO mopNT_vpl VALUES ("MT24_26","070_24_26","MAT","24","26","26","—Ti baalo'o, wa ca' aalbüc te'ex ti que'enen ichil a p'atal lu'umu, ma' a beele'ex te'i. Wa ca' aalbüc te'ex ti muca'anen ichil jun cuul a naja, ma' a tz'ocsique'exoo' u t'an,— cu t'an a Jesusu. ");
INSERT INTO mopNT_vpl VALUES ("MT24_27","070_24_27","MAT","24","27","27","—Jabix ilic ti chica'an oqueeb q'uin ti tan a lemlem joq'ueeb q'uini, baalo' ilic ti chica'anen le'ec ca' uduquen tucaye'il a yanajeen ti cristianojil,— cu t'an a Jesusu. ");
INSERT INTO mopNT_vpl VALUES ("MT24_28","070_24_28","MAT","24","28","28","—Le'ec tuba yan a quimene, te'i walacoo' u much'tal aj ch'omo,— cu t'an a Jesus ich mucult'an. ");
INSERT INTO mopNT_vpl VALUES ("MT24_29","070_24_29","MAT","24","29","29","—Pues te'i. Le'ec ti mani to a top yaj abe' in wadaj ti watac yoc'olcaba, ac'ü'tal u ca'a a q'uini. Cuntal u ca'a ti ma' ca' yan u sac a uju. C'axül u ca'a a xülaba. Pecsabül u ca'a a c'u' a yan cuchi u muc' ti ca'ana,— cu t'an a Jesusu. ");
INSERT INTO mopNT_vpl VALUES ("MT24_30","070_24_30","MAT","24","30","30","—Pachil abe'e, chictal u ca'a u p'is ti ca'an ti ca' wataquen tucaye'il a yanajeen ti cristianojili. Tulacaloo' a cristiano yoc'olcaba, beloo' u ca'a ti oc'ol ti tanoo' u tuclic c'u' a watac yoc'oloo'. Beloo' u cu yileen a yanajeen ti cristianojili. Que'enen tuwich a muyala. Tan in wudel etel tulacal in muc' in yanil,— cu t'an a Jesus ti'ijoo' u yaj cambala. ");
INSERT INTO mopNT_vpl VALUES ("MT24_31","070_24_31","MAT","24","31","31","—Le'ec ti uchuc u peec a corneta ti top chichi, le'ecoo' u yaj xa'num a Dios ti ca'ana, bel in quin tücaa'too'. Beloo' u ca'a ti norte, ti sur, ti oqueeb q'uin, ti joq'ueeb q'uin tulacal tubajac u much'quintoo' tin wetel a yeeta'anoo'o,— cu t'an a Jesus ti'ijoo'o. ");
INSERT INTO mopNT_vpl VALUES ("MT24_32","070_24_32","MAT","24","32","32","—Pues te'i. Etel a chimunu, chica'an in t'an yoc'ol c'u' in c'ati ca' a weelte'exe. Walac u jelmel a chimunu, ca' tun joc'oc u c'uuc'. Le'ec ca' a wile'ex ti tan tun u yantal u le'e, a weele'ex ti nütz'a'an a ja'ja'ili. ");
INSERT INTO mopNT_vpl VALUES ("MT24_33","070_24_33","MAT","24","33","33","Baalo' ilic etel u p'is a tan u ye'ic ti watac u jobeebe. Le'ec ti tane'ex a wilic ti tan u yuchul tulacal u p'is abe'e, a weele'ex ti nütz'a'an u jobeeb jabix que'en tun chi' naj,— cu t'an a Jesusu. ");
INSERT INTO mopNT_vpl VALUES ("MT24_34","070_24_34","MAT","24","34","34","—Tan in wadic te'ex u jajil. Yanoo' a cristiano a cuxa'anoo' ti caac ye'bel u p'is. Ala'oo'o, beloo' u cu yila' u jobeeb,— cu t'an a Jesusu. ");
INSERT INTO mopNT_vpl VALUES ("MT24_35","070_24_35","MAT","24","35","35","—Le'ec a ca'an etel a yoc'olcaba, bel u ca'a ti jobol. C'u' betiqui, in t'an inene, ma' tu chen jobol ti baalo'. Bel u ca'a ti jajtal,— cu t'an a Jesus ti'ijoo' u yaj cambala. ");
INSERT INTO mopNT_vpl VALUES ("MT24_36","070_24_36","MAT","24","36","36","—Pues te'i. Ma'ax mac u yeel biq'uin u c'ochol u q'uinil ma'ax u yorajil in ca' udel. Ma'ax u yaj xa'num a Dios ti ca'ana, ma' u yeeloo' xan. Ma'ax u Mejen a Dioso, ma' u yeel. Jadi' a Tattzil u yeele,— cu t'an a Jesusu. ");
INSERT INTO mopNT_vpl VALUES ("MT24_37","070_24_37","MAT","24","37","37","—Jabix ilic u betajoo' ti'i u q'uinil ti cuxa'an to aj Noeje, baalo' ilic beloo' u cu bete' a cristiano ti nütz'ünac in wudel a yanajeen ti cristianojili,— cu t'an a Jesus ti'ijoo' u yaj cambala. ");
INSERT INTO mopNT_vpl VALUES ("MT24_38","070_24_38","MAT","24","38","38","—Le'ec ti ma'ax to tuduc a yoc'olcab ti ja'a, tanoo' u janal. Tanoo' u yuc'ul. Tanoo' u cüxtic u yütan y u yicham. Baalo' a tanoo' u betic asto ti c'ochi u q'uinil u yocol aj Noe ichil a barcojo,— cu t'an a Jesusu. ");
INSERT INTO mopNT_vpl VALUES ("MT24_39","070_24_39","MAT","24","39","39","—Ma' u yeeltajoo' tu jajil ti bel u ca'a ti jobol a yoc'olcab asto ti tudi ti ja' y quimoo'. Baalo' ilic a uchul u ca'a asto ti ca' uduquen a yanajeen ti cristianojili,— cu t'an a Jesusu. ");
INSERT INTO mopNT_vpl VALUES ("MT24_40","070_24_40","MAT","24","40","40","—Ti a q'uin abe'e, que'en ca' tuul a winic ich col. Jun tuulu, bel u ca'a ch'a'bül. Ulaac' a jun tuulu, p'aatül u ca'a,— cu t'an a Jesusu. ");
INSERT INTO mopNT_vpl VALUES ("MT24_41","070_24_41","MAT","24","41","41","—Ca' tuul ix ch'upu, tanoo' u juch'. Jun tuulu, bel u ca'a ch'a'bül. Ulaac' a jun tuulu, p'aatül u ca'a,— cu t'an a Jesusu. ");
INSERT INTO mopNT_vpl VALUES ("MT24_42","070_24_42","MAT","24","42","42","—Inen a Noochile'ex. Ma' a weele'ex c'u' ti q'uinil in ca' udel, mentücü, cününte'ex a bajil,— cu t'an a Jesus ti'ijoo' u yaj cambala. ");
INSERT INTO mopNT_vpl VALUES ("MT24_43","070_24_43","MAT","24","43","43","—Inche'exe, a weele'ex. Wa cuchi u yeel u yumil a naj c'u' ti horajil u c'ochol aj xuuch'u, jede'ec cuchi u cününtiqui. Ma' cuchi tu cha'ic u yocoloo' aj xuuch'u,— cu t'an a Jesusu. ");
INSERT INTO mopNT_vpl VALUES ("MT24_44","070_24_44","MAT","24","44","44","—Baalo' ilic cuchi inche'exe. Listoje'ex ilic cuchi. Le'ec ti ma' tane'ex a paac'tiquene, chen a wilique'exe, jeda'en a yanajeen ti cristianojil,— cu t'an a Jesus ti'ijoo' u yaj cambala. ");
INSERT INTO mopNT_vpl VALUES ("MT24_45","070_24_45","MAT","24","45","45","—Pues te'i. Le'ec mac a tan in tzicbaltiqui, le'ec mac aj meyaj aj tz'ocsaj t'an a seeb u yool a jede'ec u tz'abül ti nooch u wichil u meyaj u men u tz'ulil. Bel u ca'a u cününte u yotoch u tz'ulil. Bel u cu tz'aa' a janal tu yorajil,— cu t'an a Jesusu. ");
INSERT INTO mopNT_vpl VALUES ("MT24_46","070_24_46","MAT","24","46","46","—Qui' u yool aj meyaj a tan ilic u meyaj le'ec ca' c'ochoc u tz'ulil,— cu t'an a Jesusu. ");
INSERT INTO mopNT_vpl VALUES ("MT24_47","070_24_47","MAT","24","47","47","—Tan in wadic te'ex u jajil. Bel u ca'a tz'abül ti'i ti nooch u wichil u meyaj ti'i ca' u cününte tulacal a c'u' a yan ti'i u tz'ulili,— cu t'an a Jesus ti'ijoo' u yaj cambala. ");
INSERT INTO mopNT_vpl VALUES ("MT24_48","070_24_48","MAT","24","48","48","—C'u' betiqui, uchac baala' ca' u yadü' aj meyaj abe' a c'as u na'ata: “Ma' tu jomol udel in tz'ulil,” cu t'anac tu bajil,— cu t'an a Jesusu. ");
INSERT INTO mopNT_vpl VALUES ("MT24_49","070_24_49","MAT","24","49","49","—Caji u jütz'oo' u yetmeyaj. Caji u yet'octoo' a cüla'an ti tanoo' u janal u yuc'ulu. ");
INSERT INTO mopNT_vpl VALUES ("MT24_50","070_24_50","MAT","24","50","50","Le'ec u tz'ulil aj meyaj abe'e, c'ochol u ca'a tu q'uinil le'ec ti ma' tan u paac'bül. C'ochol u ca'a ti'i a hora ti ma' u yeel u yaj meyaj abe'e,— cu t'an a Jesusu. ");
INSERT INTO mopNT_vpl VALUES ("MT24_51","070_24_51","MAT","24","51","51","—Bel u cu tz'aa' u sip'il ti top yaj. Bel u cu tücaa'te ala'i tu yaamoo' aj cho' ti'i ca' tz'abüc u sip'il ti quet eteloo'. Te'i u yoc'oloo' a cristianojo. Jürütlemacoo' u coj u men u yajil,— cu t'an a Jesus ti'ijoo' u yaj cambala. ");
INSERT INTO mopNT_vpl VALUES ("MT25_1","070_25_1","MAT","25","1","1","—Pues te'i. Le'ec biqui ti walac u tücaa' a Dioso, c'üs quet etel diez tuul ix chu'u. U bensajoo' u lampara a jujun tuulu. Binoo' u cümü' aj tz'ocolbeele,— cu t'an a Jesus ti'ijoo' u yaj cambala. ");
INSERT INTO mopNT_vpl VALUES ("MT25_2","070_25_2","MAT","25","2","2","—Cinco tuul ix chu' abe'e, ma' seeboo' u yooli. Ulaac' a cinco tuulu, seeboo' u yool,— cu t'an a Jesusu. ");
INSERT INTO mopNT_vpl VALUES ("MT25_3","070_25_3","MAT","25","3","3","—Le'ec ca' u bensajoo' u lampara a cinco tuul a ma' seeboo' u yoolo, ma' u bensajoo' u chucaan u ba'al u lampara,— cu t'an a Jesusu. ");
INSERT INTO mopNT_vpl VALUES ("MT25_4","070_25_4","MAT","25","4","4","—Le'ec a seeboo' u yoolo, u bensajoo' u chucaan u ba'al u lamparaja,— cu t'an a Jesus ti'ijoo' u yaj cambala. ");
INSERT INTO mopNT_vpl VALUES ("MT25_5","070_25_5","MAT","25","5","5","—Top xanaji aj tz'ocolbeele. Emoo' u wüyül a diez tuul ti ix chu'u. ");
INSERT INTO mopNT_vpl VALUES ("MT25_6","070_25_6","MAT","25","6","6","Uchi jun p'eel a t'an chumuc ac'ü'. “U'ye'ex, watac aj tz'ocolbeele. Ca' xique'ex a c'ümü,” cu t'an a t'ana,— cu t'an a Jesusu. ");
INSERT INTO mopNT_vpl VALUES ("MT25_7","070_25_7","MAT","25","7","7","—Lic'oo' tulacaloo' ix chu' abe'e. U yutzquintajoo' u lampara,— cu t'an a Jesusu. ");
INSERT INTO mopNT_vpl VALUES ("MT25_8","070_25_8","MAT","25","8","8","—“Tz'a to'on tz'etz'eecac u ba'al a lamparaje'ex. A to'ono, tan tun u tupul,” cu t'anoo' a cinco tuul a ma' seeboo' u yool ti'ijoo' a seeboo' u yoolo,— cu t'an a Jesusu. ");
INSERT INTO mopNT_vpl VALUES ("MT25_9","070_25_9","MAT","25","9","9","—“Ma' yan biqui ti tz'eec te'ex. Uchac ma' tu chucultal a to'ono. Ca' xique'ex a q'uexe' a te'ex ich conol,” cu t'anoo' ti'i a ma' seeboo' u yoolo,— cu t'an a Jesusu. ");
INSERT INTO mopNT_vpl VALUES ("MT25_10","070_25_10","MAT","25","10","10","—Le'ec ti que'enoo' u q'uexe' a ti'iji, udi aj tz'ocolbeele. Le'ec a listojoo'o, ocoo' ti quet etel aj tz'ocolbeel ti janal. C'ülbi a puertaja,— cu t'an a Jesusu. ");
INSERT INTO mopNT_vpl VALUES ("MT25_11","070_25_11","MAT","25","11","11","—Pachili, udoo' ix chu' a binoo' u q'uexe' u ba'al u lamparaja. “Noochil, noochil, jebe to'on a puertaja,” cu t'anoo' ix chu' abe'e,— cu t'an a Jesusu. ");
INSERT INTO mopNT_vpl VALUES ("MT25_12","070_25_12","MAT","25","12","12","—“Tan in wadic te'ex u jajil. Ma' in weel maque'ex inche'exe,” cu t'an ti'ijoo' ix chu' abe' ti uchi u nuuc,— cu t'an a Jesusu. ");
INSERT INTO mopNT_vpl VALUES ("MT25_13","070_25_13","MAT","25","13","13","—U men bel u ca'a ti uchul ti baalo', tan in wadic te'ex. Cününte'ex a bajil. Ma' a weele'ex c'u' ti q'uinil ma'ax c'u' ti horajil in ca' udel inen a yanajeen ti cristianojil,— cu t'an a Jesus ti'ijoo' u yaj cambala. ");
INSERT INTO mopNT_vpl VALUES ("MT25_14","070_25_14","MAT","25","14","14","—Pues te'i. Le'ec biqui ti walac u tücaa' a Dioso, c'üs quet etel a winic a bel u ca'a ti naach y ca' usc'al u ca'a tu q'uinil. Le'ec ti ma'ax to xi'iqui, u püyajoo' u yaj meyaj. U tz'aj ti'ijoo' a jujun tuul u taq'uin ca' u meyajtoo',— cu t'an a Jesusu. ");
INSERT INTO mopNT_vpl VALUES ("MT25_15","070_25_15","MAT","25","15","15","—Ti'i a jun tuulu, u tz'aj cinco mil p'eel a taq'uini. Ti'i ulaac' a jun tuulu, u tz'aj dos mil. Ti'i ulaac'a, u tz'aj mil. Tz'abi ti'ijoo' tu p'is jabix a pataloo' u meyajteje, ca' tun bini a winiqui,— cu t'an a Jesusu. ");
INSERT INTO mopNT_vpl VALUES ("MT25_16","070_25_16","MAT","25","16","16","—Pues te'i. Le'ec aj meyaj u c'ümaj a cinco mil p'eel a taq'uini, bini ti jomol ti men negocio. U naaltaj ulaac' a cinco mil p'eel a taq'uini,— cu t'an a Jesusu. ");
INSERT INTO mopNT_vpl VALUES ("MT25_17","070_25_17","MAT","25","17","17","—Baalo' ilic u betaj aj meyaj u c'ümaj a dos mil p'eel a taq'uini. U naaltaj ulaac' a dos mil,— cu t'an a Jesusu. ");
INSERT INTO mopNT_vpl VALUES ("MT25_18","070_25_18","MAT","25","18","18","—C'u' betiqui, aj meyaj u c'ümaj a mili, ma' uchi u meyaj etel. U paantaj a ch'e'ene. Te'i u mucaj u taq'uin u tz'ulil,— cu t'an a Jesusu. ");
INSERT INTO mopNT_vpl VALUES ("MT25_19","070_25_19","MAT","25","19","19","—Pues te'i. Yaab q'uin xanaji u tz'uliloo' aj meyaj abe'e, ca' tun usc'aji tucaye'il. U püyajoo' u yaj meyaj ti'i ca' u yila' c'u' u betajoo' etel u taq'uin,— cu t'an a Jesus ti'ijoo' u yaj cambala. ");
INSERT INTO mopNT_vpl VALUES ("MT25_20","070_25_20","MAT","25","20","20","—Le'ec a tz'abi ti'i a cinco mil p'eel a taq'uini, c'ochi etel u tz'ulil. U talesaj a taq'uin a tz'abi ti'i etel u chucaan a cinco mili. “Noochil, a tz'aj ten cinco mil p'eel a taq'uini, y jeda' cinco mil p'eel u naal,” cu t'an ti'i u tz'ulil,— cu t'an a Jesusu. ");
INSERT INTO mopNT_vpl VALUES ("MT25_21","070_25_21","MAT","25","21","21","—“Incheche, walac a betic a qui'i. Noj-ooltzilech ti meyaj. Qui' a betaj tene. A betaj a qui' etel a tz'etz'eeque, mentücü, bel in quin tz'aa' ti nooch u wichil a meyaj. Oquen a c'ümü' a qui' tin wetel,” cu t'an u tz'ulil,— cu t'an a Jesusu. ");
INSERT INTO mopNT_vpl VALUES ("MT25_22","070_25_22","MAT","25","22","22","—Le'ec a tz'abi ti'i a dos mil p'eel a taq'uini, c'ochi etel u tz'ulil. “Noochil, a tz'aj ten dos mil p'eel a taq'uini, y jeda' dos mil p'eel u naal,” cu t'an ti'i u tz'ulil,— cu t'an a Jesusu. ");
INSERT INTO mopNT_vpl VALUES ("MT25_23","070_25_23","MAT","25","23","23","—“Incheche, walac a betic a qui'i. Noj-ooltzilech ti meyaj. Qui' a betaj tene. A betaj a qui' etel a tz'etz'eeque, mentücü, bel in quin tz'aa' ti nooch u wichil a meyaj. Oquen a c'ümü' a qui' tin wetel,” cu t'an u tz'ulil,— cu t'an a Jesusu. ");
INSERT INTO mopNT_vpl VALUES ("MT25_24","070_25_24","MAT","25","24","24","—Le'ec a tz'abi ti'i a mil p'eel a taq'uini, c'ochi etel u tz'ulil. “Noochil, in weel ti ma' ta'ach a ch'a'ic u yotzilil a maca. Walac a jochic c'u' a ma' a püc'aja. Walac a ch'a'ic u wich a püc'aal a ma' a wuustaji,” cu t'an ti'i u tz'ulil,— cu t'an a Jesusu. ");
INSERT INTO mopNT_vpl VALUES ("MT25_25","070_25_25","MAT","25","25","25","—“U men baala' a na'ata, saaquen tech. Bineen in mucu' ich lu'um a taq'uin a tz'aj tene. Jeda' a boon a taq'uin a teche,” cu t'an ti'i u tz'ulil,— cu t'an a Jesusu. ");
INSERT INTO mopNT_vpl VALUES ("MT25_26","070_25_26","MAT","25","26","26","—“Top c'asech. Top sacanech,” cu t'an u tz'ulil ti'i u yaj meyaj. “A weel ti walac in jochic c'u' a ma' in püc'aj. A weel ti walac in molic u wich a püc'aal a ma' in wuustaji,” cu t'an ti'i u yaj meyaj,— cu t'an a Jesusu. ");
INSERT INTO mopNT_vpl VALUES ("MT25_27","070_25_27","MAT","25","27","27","—“A tz'aj cuchi in taq'uin ti maanil ti'i ca' yanac u naal,” cu t'an u tz'ulil,— cu t'an a Jesusu. ");
INSERT INTO mopNT_vpl VALUES ("MT25_28","070_25_28","MAT","25","28","28","—“Toco ti'i a taq'uini. Tz'a ti'i a uchi u naal cinco mil yoc'ol a cinco mil p'eel a taq'uini,” cu t'an u tz'ulil,— cu t'an a Jesusu. ");
INSERT INTO mopNT_vpl VALUES ("MT25_29","070_25_29","MAT","25","29","29","—Yan u yuchul ti baalo' u men mac a yanaji ti'i ti yaaba, bel u ca'a tz'abül ti'i u chucaan ti mas yaab. Le'ec mac a ma' yanaji ti'i ma'ax tz'etz'eec u chucaana, tocbol u ca'a ti'i c'u' a yan ti'iji,— cu t'an a Jesusu. ");
INSERT INTO mopNT_vpl VALUES ("MT25_30","070_25_30","MAT","25","30","30","—“Ma'ax c'u' aj beel aj meyaj ada'a. Pulu pach naj ichil a ac'ü'ü. Te'i beloo' u ca'a ti oc'ol a cristianojo. Jürütlemacoo' xan u ca'a u coj u men u yajil,” cu t'an u tz'ulil— cu t'an a Jesusu. ");
INSERT INTO mopNT_vpl VALUES ("MT25_31","070_25_31","MAT","25","31","31","—Pues te'i. Inene, yanajeen ti cristianojil. Le'ec ca' uduquen tucaye'il, udel in ca'a etel in yanil. Udel in ca'a etel tulacaloo' u yaj xa'num a Dios ti ca'ana. Ti a q'uin abe'e, udel in ca'a ti tintal ti reyil ti tücaa',— cu t'an a Jesusu. ");
INSERT INTO mopNT_vpl VALUES ("MT25_32","070_25_32","MAT","25","32","32","—Bel u ca'a much'quinbil tulacaloo' a cristiano tin taan. Bel in quin jüpoo' tu bajil jabix ti walac u jüpbüloo' a carnero etel a cabro tu bajil u men u yaj cananili,— cu t'an a Jesusu. ");
INSERT INTO mopNT_vpl VALUES ("MT25_33","070_25_33","MAT","25","33","33","—Le'ec a jun muuch' a cristianojo, jabix a carnero abe'e, bel in quin tz'aa' tin waj toj tin waj seeb c'ü'. Le'ec ulaac' a jun muuch'u, jabix a cabrojo, bel in quin tz'aa' tu junal tin tzeel,— cu t'an a Jesusu. ");
INSERT INTO mopNT_vpl VALUES ("MT25_34","070_25_34","MAT","25","34","34","—Reyen ti a q'uin abe'e. Bel in quin wadü' ti'ijoo' a que'en tin waj toj tin waj seeb c'ü'ü: “Qui'qui't'anbe'ex u men in Tat. C'üme'ex a cuuchile'ex tu cuenta a Dioso. Taac'a'an te'ex le'ec ti yaax yanaji a yoc'olcaba,” quenac ti'ijoo' a que'en tin waj toj tin waj seeb c'ü',— cu t'an a Jesusu. ");
INSERT INTO mopNT_vpl VALUES ("MT25_35","070_25_35","MAT","25","35","35","—“Le'ec ti wi'ijene, a tz'aje'ex ten in janal. Le'ec ti uc'ajene, a tz'aje'ex ten in wuc'ul. Le'ec ti ma'ax mac u yeel in wichi, a tz'aje'ex ten in posado,” quenac ti'ijoo',— cu t'an a Jesusu. ");
INSERT INTO mopNT_vpl VALUES ("MT25_36","070_25_36","MAT","25","36","36","—“Le'ec ti ma' yan in noc'o, a tz'aje'ex ten. Le'ec ti c'oja'anene, a waantajene'ex. Le'ec ti que'enen ti presojili, a sutintajen,” quenac ti'ijoo' a que'en tin waj toj tin waj seeb c'ü',— cu t'an a Jesusu. ");
INSERT INTO mopNT_vpl VALUES ("MT25_37","070_25_37","MAT","25","37","37","—Baala' tu nuuctiquenoo' a toj u na'at abe'e: “Noochil, ¿biq'uini ca' ti wilajech ti wi'ijech y ti tzeentajech? ¿Biq'uini ca' ti wilajech ti uc'ajech y ti tz'aj tech a wuc'ul? ");
INSERT INTO mopNT_vpl VALUES ("MT25_38","070_25_38","MAT","25","38","38","¿Biq'uini ca' ti wilajech ti ma' eeltzilech y ti tz'aj a posado? ¿Biq'uini ca' ti wilajech ti ma' yan a noc' y ti tz'aj a noc'? ");
INSERT INTO mopNT_vpl VALUES ("MT25_39","070_25_39","MAT","25","39","39","¿Biq'uini ca' ti wilajech ti c'oja'anech wa que'enech ti presojil y talo'on ti sutintech?” cu t'anacoo' ten a tojoo' u na'ata,— cu t'an a Jesusu. ");
INSERT INTO mopNT_vpl VALUES ("MT25_40","070_25_40","MAT","25","40","40","—“Tan in wadic te'ex u jajil. Le'ec ca' a betaje'ex a baalo' ti'i jun tuul in hermano a ca'ax jumpul ma' yan u yanili, a betaje'ex ilic a baalo' ten,” quenac ti'ijoo' a que'enoo' tin waj toj tin waj seeb c'ü' ti que'enen ti reyil,— cu t'an a Jesus ti'ijoo' u yaj cambala. ");
INSERT INTO mopNT_vpl VALUES ("MT25_41","070_25_41","MAT","25","41","41","—Pachili, bel in quin wadü' ti'ijoo' ulaac' a jun muuch'u: “Joq'uene'ex tin tzeel. Pula'ane'ex. Ca' xique'ex ichil a c'aac' a ma' yan q'uin u tupulu. Utzquinaja'an a c'aac' abe' ti'ijoo' a quisin u yet'ocoo' u yaj xa'num,” quenac ti'ijoo' ulaac' a jun muuch' abe'e,— cu t'an a Jesusu. ");
INSERT INTO mopNT_vpl VALUES ("MT25_42","070_25_42","MAT","25","42","42","—“Le'ec ti wi'ijene, ma' a tz'aje'ex ten in janal. Le'ec ti uc'ajene, ma' a tz'aje'ex ten in wuc'ul. ");
INSERT INTO mopNT_vpl VALUES ("MT25_43","070_25_43","MAT","25","43","43","Le'ec ti ma'ax mac u yeel in wichi, ma' a tz'aje'ex ten in posado. Le'ec ti ma' yan in noc'o, ma' a tz'aje'ex ten. Le'ec ti c'oja'anene, wa que'enen ti presojili, ma' a sutintajene'ex,” quenac ti'ijoo' ulaac' a jun muuch' abe'e,— cu t'an a Jesus ti'ijoo' u yaj cambala. ");
INSERT INTO mopNT_vpl VALUES ("MT25_44","070_25_44","MAT","25","44","44","—Baalo' ilic tu nuuctiquenoo' ala'oo'o: “Noochil, ¿biq'uini ca' ti wilajech ti wi'ijech, wa ti uc'ajech, wa ti ma' yan a cuuch, wa ti ma' yan a noc' wa ti c'oja'anech, wa ti que'enech ti presojil y ma' ti waantajech?” cu t'anacoo' ten,— cu t'an a Jesusu. ");
INSERT INTO mopNT_vpl VALUES ("MT25_45","070_25_45","MAT","25","45","45","—“Tan in wadic te'ex u jajil. Le'ec ti ma' a betaje'ex a baalo' ti'i jun tuul in hermano a ca'ax jumpul ma' nooch u wichil u meyaja, ma'ax a betaje'ex a baalo' tene,” quenac ti'ijoo',— cu t'an a Jesusu. ");
INSERT INTO mopNT_vpl VALUES ("MT25_46","070_25_46","MAT","25","46","46","—Beloo' u ca'a ala'oo' u bo'too' u sip'il ichil a yaj a ma' yan q'uin u jobolo. C'u' betiqui, a tojoo' u na'ata, beloo' u cu c'ümü' a cuxtal a ma' yan q'uin u jobolo,— cu t'an a Jesus ti'ijoo' u yaj cambala. ");
INSERT INTO mopNT_vpl VALUES ("MT26_1","070_26_1","MAT","26","1","1","Pues te'i. Le'ec a Jesusu, jobi to u yadic c'u' a bel u cu bete' tu jobeeb. Caji u yadü' ulaac' a t'an ti'ijoo' u yaj cambal. ");
INSERT INTO mopNT_vpl VALUES ("MT26_2","070_26_2","MAT","26","2","2","—Inche'exe, a weele'ex. Ca' p'e q'uin to u beel ca' c'ochoc u q'uinil a fiesta ti tan u c'ajsabül biq'uin ti mani u yaj xa'num a Dios ti ca'an yoc'oloo' ti uchben mamaa'. Le'ec inen a yanajeen ti cristianojili, bel in ca'a c'ubbul ti'i ca' quimsabüquen tuwich cruz— cu t'an ti'ijoo'. ");
INSERT INTO mopNT_vpl VALUES ("MT26_3","070_26_3","MAT","26","3","3","Pues te'i. Ichil u yotoch aj Caifas much'lajoo' u noochiloo' u yaj mansaj t'an a cristiano ti'i a Dios u yet'ocoo' u yaj ca'ansajil u ley aj Moises eteloo' a nucuch winiqui. Le'ec aj Caifas abe'e, le'ec a mas nooch u wichil u meyaj tu yaamoo' u chucaan u yaj mansaj t'an a cristiano ti'i a Dioso. ");
INSERT INTO mopNT_vpl VALUES ("MT26_4","070_26_4","MAT","26","4","4","Le'ec a much'a'anoo'o, tanoo' u tzicbaltic biqui ca' u müchoo' a Jesus ich mucul ti'i ca' u quimsoo'. ");
INSERT INTO mopNT_vpl VALUES ("MT26_5","070_26_5","MAT","26","5","5","—Ma' qui' u müchbül ti tan to a fiestaja. Sabeensil u liq'uiloo' u tz'iiquil u yaabil a cristianojo,— cu t'anoo' tu bajil. ");
INSERT INTO mopNT_vpl VALUES ("MT26_6","070_26_6","MAT","26","6","6","Pues te'i. Que'en a Jesus ichil a tz'i' caj Betania. Que'en ichil u yotoch aj Simono. Biq'uin ado'o, tan u tu'ujtal u büq'uel aj Simon u men a c'oja'anil abe'e. ");
INSERT INTO mopNT_vpl VALUES ("MT26_7","070_26_7","MAT","26","7","7","C'ochi etel a Jesus jun tuul a nooch'upu. U talesaj jun p'eel a tz'i' p'uul a betabi etel a tunich u c'aba' alabastro. Tuda'an a p'uul abe' etel a boc a top co'oj u toolo. Le'ec ti que'en a Jesus chi' mesaja, u toxaj a boc tu pol. ");
INSERT INTO mopNT_vpl VALUES ("MT26_8","070_26_8","MAT","26","8","8","Pues te'i. Le'ec ca' u yilajoo' c'u' u betaj a nooch'upu, tz'iicajoo' u yaj cambal a Jesusu. —¿C'u' ca'a najilcunbi a boco? ");
INSERT INTO mopNT_vpl VALUES ("MT26_9","070_26_9","MAT","26","9","9","Conbi cuchi a boc abe' ti co'oj u tool. T'oxbi cuchi u tool ti'ijoo' a otzili,— cu t'anoo' u yaj cambal a Jesusu. ");
INSERT INTO mopNT_vpl VALUES ("MT26_10","070_26_10","MAT","26","10","10","Pues te'i. Le'ec a Jesusu, u yeel c'u' a tanoo' u yadiqui. —¿C'u' ca'a tane'ex a yajcuntic u yool a nooch'upu? Top quich'pan c'u' u betaj tene,— cu t'an a Jesus ti'ijoo' u yaj cambala. ");
INSERT INTO mopNT_vpl VALUES ("MT26_11","070_26_11","MAT","26","11","11","—Que'en a otzil ta yaame'ex tulacal a q'uini. C'u' betic inene, ma' tulacal q'uin cuntal in ca'a ta yaame'exi,— cu t'an a Jesus ti'ijoo'o. ");
INSERT INTO mopNT_vpl VALUES ("MT26_12","070_26_12","MAT","26","12","12","—Le'ec a boc a toxbi tin woc'olo, toxbi tin woc'ol ti'i in mucbeebal,— cu t'an a Jesusu. ");
INSERT INTO mopNT_vpl VALUES ("MT26_13","070_26_13","MAT","26","13","13","—Tan in wadic te'ex u jajil. Tulacal tubajac yoc'olcab tuba tan u yaalbül u pectzil a Dioso, bel u ca'a c'ajsabül a qui' u betaj ten a nooch'upu,— cu t'an a Jesus ti'ijoo' u yaj cambal. ");
INSERT INTO mopNT_vpl VALUES ("MT26_14","070_26_14","MAT","26","14","14","Pues te'i. Jun tuul tu yaam a doce tuul u yaj cambal a Jesusu, aj Judas Iscariote u c'aba'. Bini ala'i eteloo' u noochil u yaj mansaj t'an a cristiano ti'i a Dioso. ");
INSERT INTO mopNT_vpl VALUES ("MT26_15","070_26_15","MAT","26","15","15","—¿Boon a ca' tz'a'e'ex ten ti'i in tzolical te'ex a Jesusu?— cu t'an ti'ijoo'. —Treinta p'eel a taq'uin a plataja,— cu t'anoo' ti'i aj Judasa. ");
INSERT INTO mopNT_vpl VALUES ("MT26_16","070_26_16","MAT","26","16","16","Ti'i ilic a q'uin abe'e, caji aj Judas u cüxte c'u' ti q'uinil mas qui' ca' u tzolo' a Jesusu. ");
INSERT INTO mopNT_vpl VALUES ("MT26_17","070_26_17","MAT","26","17","17","Pues te'i. C'ochi u paye' q'uinil a fiesta ti ma' ta'ach u jantabül a pan a yan u levadurajili. Naatz'oo' u yaj cambal tu tzeel a Jesusu. —¿Tuba a c'ati ca' xico'on ti wutzquinte tech a janal u c'ajsabeeb ti mani u yaj xa'num a Dios ti ca'an yoc'oloo' ti uchben mamaa' uchi?— cu t'anoo' ti'i a Jesusu. ");
INSERT INTO mopNT_vpl VALUES ("MT26_18","070_26_18","MAT","26","18","18","—Ca' xique'ex ich caj etel jun tuul a winiqui. “Nütz'a'an u yorajil in quimsabül. Inen in wet'ocoo' in waj cambal, bel ti ca'a ti janal ichil a wotoch u c'ajsabeeb ti mani u yaj xa'num a Dios ti ca'an yoc'oloo' ti uchben mamaa' uchi, cu t'an tech a maestrojo,” que'exac ti'i a winic abe'e,— cu t'an a Jesusu. ");
INSERT INTO mopNT_vpl VALUES ("MT26_19","070_26_19","MAT","26","19","19","Le'ecoo' u yaj cambala, u betajoo' jabix ilic a aalbi ti'ijoo'o. U yutzquintajoo' a janala. ");
INSERT INTO mopNT_vpl VALUES ("MT26_20","070_26_20","MAT","26","20","20","Pues te'i. Ti'i ilic a ac'ü' abe'e, que'en a Jesus pach mesa ti janal eteloo' a doce tuul u yaj cambal. ");
INSERT INTO mopNT_vpl VALUES ("MT26_21","070_26_21","MAT","26","21","21","—Tan in wadic te'ex u jajil. Jun tuul ta yaame'exe, bel u cu tzoleen,— cu t'an a Jesus ti'ijoo' ti tanoo' to u janal. ");
INSERT INTO mopNT_vpl VALUES ("MT26_22","070_26_22","MAT","26","22","22","Top yajajoo' u yool. Jujun tuulil, cajoo' u c'aate ti'i. —Noochil, ¿inen wa abe'e?— cu t'an a jujun tuul ti'iji. ");
INSERT INTO mopNT_vpl VALUES ("MT26_23","070_26_23","MAT","26","23","23","—Le'ec mac a tan u comon janal tin wetele, le'ec bel u cu tzoleen,— cu t'an a Jesusu. ");
INSERT INTO mopNT_vpl VALUES ("MT26_24","070_26_24","MAT","26","24","24","—Jabix ilic ti tz'iiba'an ichil u ju'um a Dioso, le'ec a bel u ca'a ti uchul ten a yanajeen ti cristianojili. C'u' betiqui, mas top yaj a bel u cu c'ümü' a winic a bel u cu tzoleene. Mas qui' cuchi ti'i wa ma' yanaji u men a yaj a bel u cu c'ümü',— cu t'an a Jesus ti'ijoo' u yaj cambal. ");
INSERT INTO mopNT_vpl VALUES ("MT26_25","070_26_25","MAT","26","25","25","—Maestro, ¿inen wa abe'e?— cu t'an aj Judasa, le'ec mac a bel u ca'a ti tzolo. —Inchech abe'e,— cu t'an a Jesus ti'iji. ");
INSERT INTO mopNT_vpl VALUES ("MT26_26","070_26_26","MAT","26","26","26","Pues te'i. Le'ec ti tanoo' u janala, u ch'a'aj a waj harina a Jesusu. U c'ajsaj a Dios yoc'olo. U xet'aj. U tz'aj ti'ijoo' u yaj cambal. —Jeda'. Jante'ex. Le'ec ada' in büq'uel ti'i a c'ajsicalene'exe,— cu t'an ti'ijoo'. ");
INSERT INTO mopNT_vpl VALUES ("MT26_27","070_26_27","MAT","26","27","27","U molaj jun p'e pote a uc'ulu. Le'ec ca' u c'ajsaj a Dios yoc'olo, u tz'aj ti'ijoo' u yaj cambal.— Uq'ue'ex ada' tulacale'exe. ");
INSERT INTO mopNT_vpl VALUES ("MT26_28","070_26_28","MAT","26","28","28","Le'ec in q'uiq'uele, bel u ca'a ti joc'ol ca' quimsabüquen. Etel in quimeebala, bel u ca'a ti yantal u muc' a tumul t'ana, mentücü, bel u ca'a sa'tesabül u sip'il a yaaba. Le'ec a uc'ul ada'a, in q'uiq'uel ti'i a c'ajsicalene'ex,— cu t'an a Jesusu. ");
INSERT INTO mopNT_vpl VALUES ("MT26_29","070_26_29","MAT","26","29","29","—Tan in wadic te'ex. Ma' tin ca' uq'uic u c'a' a uvaja, asto u c'ochol u q'uinil in wuq'uic a tumulben le'ec ca' much'laque'ex tu cuenta in Tat,— cu t'an a Jesusu. ");
INSERT INTO mopNT_vpl VALUES ("MT26_30","070_26_30","MAT","26","30","30","Pues te'i. Le'ec ti jobi u c'üyic jun p'eel a c'ay ti'i a Dioso, joc'oo te'i. Binoo' tuwich a witz Olivo. ");
INSERT INTO mopNT_vpl VALUES ("MT26_31","070_26_31","MAT","26","31","31","Pues te'i. Uchi u t'an a Jesusu. —Etel c'u' a bel in quin c'ümü'ü, tulacale'ex, bele'ex a ca'a a p'üteen ti'i ilic a ac'ü' ada'a. Baalo' ilic ti tz'iiba'an. “Bel in quin yajcunte u yaj cananil a carnerojo. Le'ecoo' a carnerojo, beloo' u ca'a ti weequel,” cu t'an a t'an a tz'iiba'ana,— cu t'an a Jesusu. ");
INSERT INTO mopNT_vpl VALUES ("MT26_32","070_26_32","MAT","26","32","32","—Le'ec ca' cuxlaquen tucaye'ili, c'ochol in ca'a payanbej ta wiche'ex cuenta Galilea,— cu t'an a Jesus ti'ijoo' u yaj cambala. ");
INSERT INTO mopNT_vpl VALUES ("MT26_33","070_26_33","MAT","26","33","33","—Ca'ax u p'üteechoo' tulacaloo' u men c'u' a bel a ca'a a c'ümü'ü, inene, ma' yan q'uin in p'ütiquech,— cu t'an aj Pedro ti'i a Jesusu. ");
INSERT INTO mopNT_vpl VALUES ("MT26_34","070_26_34","MAT","26","34","34","—Tan in wadic tech u jajil. Ti'i ilic a ac'ü' ada'a, ti ma'ax to uchuc u yawat aj t'ele, ac ox sut tun a wadü' ti ma' a weel in wich,— cu t'an a Jesus ti'i aj Pedrojo. ");
INSERT INTO mopNT_vpl VALUES ("MT26_35","070_26_35","MAT","26","35","35","—Ca'ax in wetquimilech, ma' tin wadic wa ma' in weel a wich,— cu t'an aj Pedro ti'i a Jesusu. Baalo' ilic u yadajoo' u chucaan u yaj cambal. ");
INSERT INTO mopNT_vpl VALUES ("MT26_36","070_26_36","MAT","26","36","36","Pues te'i. Bini a Jesus u yet'ocoo' u yaj cambal ichil jun p'eel cuuchil u c'aba' Getsemani. —Tinlene'ex wa'ye'. Bel in ca'a tedo' ti t'an etel a Dioso,— cu t'an a Jesus ti'ijoo' u yaj cambala. ");
INSERT INTO mopNT_vpl VALUES ("MT26_37","070_26_37","MAT","26","37","37","U bensaj aj Pedrojo, u yet'ocoo' a ca' tuul u mejen aj Zebedeo tu pach. Caji ti yajtal u yool a Jesus tu jajili. Caji u yubi u yajil a yaj a watac yoc'olo. ");
INSERT INTO mopNT_vpl VALUES ("MT26_38","070_26_38","MAT","26","38","38","—Tin wu'yic inene, jabix watac in quimil u men u yajil in wool. Wa'ye' a cuntale'ex. P'ixa'anaque'ex a wich jabixen iliqui,— cu t'an a Jesus ti'ijoo' a ox tuulu. ");
INSERT INTO mopNT_vpl VALUES ("MT26_39","070_26_39","MAT","26","39","39","Ca' bini mas tz'etz'eec tucaye'. Xonlaji te'i. —Tat, wa yan biquiji, tz'a ten ti ma' tin c'ümic a yaj a wataca. C'u' betiqui, mas toj a betic a jabix ilic a c'ati incheche. Ma' chen le'ec a jabix in c'ati ineni,— cu t'an a Jesus ti'i a Tattzili. ");
INSERT INTO mopNT_vpl VALUES ("MT26_40","070_26_40","MAT","26","40","40","Ca' usc'aji a Jesus eteloo' u yaj cambal a ox tuulu. Ca' u yilaja, tanoo' u wüyül. —¿Ma' wa patale'ex ti p'ixtal jabixen ca'ax jun p'e hora?— cu t'an ti'i aj Pedrojo. ");
INSERT INTO mopNT_vpl VALUES ("MT26_41","070_26_41","MAT","26","41","41","—P'ixa'anaque'ex a wich jabixen iliqui. C'aate'ex ti'i a Dios ti'i ma' u yemsabüle'ex a wool a bete'ex a c'asa. Yane'ex a wool a bete'ex cuchi, pero ma' yane'ex a muc',— cu t'an a Jesus ti'ijoo'o. ");
INSERT INTO mopNT_vpl VALUES ("MT26_42","070_26_42","MAT","26","42","42","Ca' bini tucaye' a Jesusu. Ca' xonlaji tucaye'. —Tat, wa cuchi yan biqui ti ma' in c'ümic a yaj a wataca, qui' cuchi. C'u' betiqui, bete a jabix ilic a c'ati incheche,— cu t'an a Jesus ti'i a Tattzili. ");
INSERT INTO mopNT_vpl VALUES ("MT26_43","070_26_43","MAT","26","43","43","Ca' usc'aji tucaye'il a Jesus eteloo' u yaj cambal a ox tuulu. Ca' u yilaja, tanoo' u wüyül tucaye'il. Top qui'oo' u yemel u wüyül. ");
INSERT INTO mopNT_vpl VALUES ("MT26_44","070_26_44","MAT","26","44","44","Ca' joq'ui tu yaamoo' tucaye'il. Ca' bini. U ca' adaj tu yox sut a jabix ilic u yaax adaj ti'i a Tattzili. ");
INSERT INTO mopNT_vpl VALUES ("MT26_45","070_26_45","MAT","26","45","45","Ca' usc'aji tucaye'il a Jesus eteloo' u yaj cambal a ox tuulu. —¿C'u' ca'a tan ti tane'ex a wüyül, y tane'ex a jedel? U'yeex. Inene, yanajeen ti cristianojil. Aleebe c'ochi u yorajil in c'ubbul ti'ijoo' a yanoo' u sip'ili,— cu t'an a Jesus ti'ijoo'o. ");
INSERT INTO mopNT_vpl VALUES ("MT26_46","070_26_46","MAT","26","46","46","—Liq'uene'ex. Co'ne'ex ti c'ümoo'. Ile'ex, watac a mac a bel u cu c'ubeen ti'ijoo'o,— cu t'an a Jesusu. ");
INSERT INTO mopNT_vpl VALUES ("MT26_47","070_26_47","MAT","26","47","47","Pues te'i. Tan to u t'an a Jesus ti udi aj Judasa. Le'ec ala'aji, jun tuul tu yaamoo' a doce tuul u yaj cambal a Jesusu. U yetc'ocholoo', jun muuch' ti cristiano. Yan a yanoo' u maasca' y a yanoo' u che' tu c'ü'. Tücaa'boo' u menoo' u noochil u yaj mansaj t'an a cristiano ti'i a Dios u yet'ocoo' a nucuch winiqui. ");
INSERT INTO mopNT_vpl VALUES ("MT26_48","070_26_48","MAT","26","48","48","Le'ec ti ma'ax to c'ochocoo'o, albi ti'ijoo' u men aj Judas biqui ca' u na'too' maqui a Jesusu. —Le'ec mac a ca' in wutzinte ti tan in dioostiqui, le'ec ala'i a winic a c'ate'exe. Ca' a müche'ex,— cu t'an ti'ijoo'. ");
INSERT INTO mopNT_vpl VALUES ("MT26_49","070_26_49","MAT","26","49","49","Tu jomolil c'ochi aj Judas etel a Jesusu. —Dioos Maestro,— cu t'an ti'i. U yutzintaj. ");
INSERT INTO mopNT_vpl VALUES ("MT26_50","070_26_50","MAT","26","50","50","—Amigo, bete c'u' a taleech a bete',— cu t'an a Jesus ti'i aj Judasa. C'ochoo' a cristianojo. U müchajoo' a Jesusu. ");
INSERT INTO mopNT_vpl VALUES ("MT26_51","070_26_51","MAT","26","51","51","Pues te'i. Jun tuul u yaj cambal a Jesusu, u joc'saj u maasca'. U jan ch'üctaj u xiquin u yaj meyaj a jun tuul a mas nooch u wichil u meyaj tu yaamoo' u yaj mansaj t'an a cristiano ti'i a Dioso. ");
INSERT INTO mopNT_vpl VALUES ("MT26_52","070_26_52","MAT","26","52","52","—P'ütü. Tz'a a maasca' ichil u pix. Tulacal a mac a walac u p'isbaj etel maasca'a, bel ilic u ca'a quimsabül etel maasca',— cu t'an a Jesus ti'iji. ");
INSERT INTO mopNT_vpl VALUES ("MT26_53","070_26_53","MAT","26","53","53","—¿Ma' wa jede'ec cuchi in c'aatic ti'i in Tat ca' u yaanteen? Jede'ec cuchi u jomol tücaa'ticoo' manal doce muuch' u yaj xa'num ti ca'an ti'i cuchi u sa'alticalen,— cu t'an a Jesus ti'i u yaj cambal abe'e. ");
INSERT INTO mopNT_vpl VALUES ("MT26_54","070_26_54","MAT","26","54","54","—C'u' betiqui, wa cuchi ca' in c'aate ti'i in Tat ti baalo'o, ¿biqui ca' jajac u t'an Dios a tz'iiba'an tin woc'olo?— cu t'an a Jesus ti'iji. ");
INSERT INTO mopNT_vpl VALUES ("MT26_55","070_26_55","MAT","26","55","55","Pues te'i. Uchi u t'an a Jesus eteloo' u yetc'ochol aj Judasa. —¿Tale'ex wa a mücheen etel maasca' y etel che' jabixen cuchi jun tuul aj xuuch'u?— cu t'an a Jesus ti'ijoo'o. —Sansamal tina'anen in ca'ansoo' a cristiano ichil u yotoch a Dioso, y ma' a müchajene'ex te'i,— cu t'an a Jesus ti'ijoo'o. ");
INSERT INTO mopNT_vpl VALUES ("MT26_56","070_26_56","MAT","26","56","56","—C'u' betiqui, yan a betique'ex tulacal a c'u' a tane'ex a betic aleebe ti'i ca' jajac u t'an a Dios a tz'iiba'an u menoo' mac u yadaj u t'an a Dios uchi,— cu t'an a Jesus ti'ijoo'o. P'ütbi a Jesus u menoo' u yaj cambala. Puutz'oo'. ");
INSERT INTO mopNT_vpl VALUES ("MT26_57","070_26_57","MAT","26","57","57","Pues te'i. Le'ecoo' a mac u müchaj a Jesusu, u bensajoo' etel aj Caifasa. Le'ec aj Caifas abe'e, le'ec a mas nooch u wichil u meyaj tu yaamoo' u yaj mansaj t'an a cristiano ti'i a Dioso. Te'i ilic much'a'anoo' u yaj ca'ansajil u ley aj Moisese, u yet'ocoo' a nucuch winiqui. ");
INSERT INTO mopNT_vpl VALUES ("MT26_58","070_26_58","MAT","26","58","58","Pues te'i. Le'ec ti binoo' te'iji, naach tücünac aj Pedro tu pachoo', asto ti c'ochi tu chi' u cotil u yotoch aj Caifasa. Le'ec ti oqui ich coto, tinlaji tu yaamoo' a soldado u yila' c'u' a bel u ca'a ti manül ti'i a Jesusu. ");
INSERT INTO mopNT_vpl VALUES ("MT26_59","070_26_59","MAT","26","59","59","Pues te'i. Le'ecoo' u noochil u yaj mansaj t'an a cristiano ti'i a Dios u yet'ocoo' a nucuch winic a much'a'anoo' te'iji, u yaaltajoo' u cüxte mac ca' u tzolo' a Jesus yoc'ol tus ti'i ca' quimsabücü. ");
INSERT INTO mopNT_vpl VALUES ("MT26_60","070_26_60","MAT","26","60","60","C'u' betiqui, ca'ax yaaboo' a c'ochoo' ti tusu, ma' yan tu yaamoo' a quetoo' u t'ana. Tu yada' c'ochoo' a ca' tuulu. ");
INSERT INTO mopNT_vpl VALUES ("MT26_61","070_26_61","MAT","26","61","61","—“U paatal in jobsic u yotoch a Dios y in ca' betic ich ox p'e q'uin,” cu t'an a winic ada'a,— cu t'an a ca' tuulu. ");
INSERT INTO mopNT_vpl VALUES ("MT26_62","070_26_62","MAT","26","62","62","Le'ec a mas nooch u wichil u meyaj tu yaamoo' u yaj mansaj t'an a cristiano ti'i a Dioso, wa'laji. —¿C'u' ca'a ma tan a nuuctic mac tan u tzoliquech? ¿C'u' abe' a tan u yaalbül ta woc'olo?— cu t'an ti'i a Jesusu. ");
INSERT INTO mopNT_vpl VALUES ("MT26_63","070_26_63","MAT","26","63","63","Ma' tan u nuuc a Jesusi. —Etel u c'aba' a Dios a cuxa'ana, tan in c'aatic tech. Adü to'on wa le'ec inchech u yaj Sa'alil a cristianojo, u Mejen a Dioso,— cu t'an a nooch u wichil u meyaj ti'iji. ");
INSERT INTO mopNT_vpl VALUES ("MT26_64","070_26_64","MAT","26","64","64","—Inen,— cu t'an a Jesusu. —Tan in wadic te'ex. Ti a q'uin a wataca, bele'ex a ca'a a wileen a yanajeen ti cristianojil ti tina'anen tu yaj toj tu yaj seeb c'ü' a Dios a yaab u muc'u. Bele'ex a ca'a a wila' ti que'enen yoc'ol muyal ti tan in wemel,— cu t'an a Jesus ti'ijoo'o. ");
INSERT INTO mopNT_vpl VALUES ("MT26_65","070_26_65","MAT","26","65","65","Le'ec ca' u yubaj abe' a mas nooch u wichil u meyaj tu yaamoo' u yaj mansaj t'an a cristiano ti'i a Dioso, u tzilaj u noc' u men c'u' u yadaj a Jesusu. —Aleebe chiclaji ten ti u maclant'antaj a Dioso,— cu t'an ala'i yoc'ol a Jesusu. —¿C'u' aj beel ulaac' aj tzolo? A wu'yaje'ex ilic ti tan u maclant'an a Jesusu,— cu t'an ti'ijoo'. ");
INSERT INTO mopNT_vpl VALUES ("MT26_66","070_26_66","MAT","26","66","66","—¿Biqui ta t'ane'ex?— cu t'an ti'ijoo'. —Top nooch u sip'il. Qui' ca' quimsabüc,— cu t'anoo' ti'i ti uchoo' u nuuc. ");
INSERT INTO mopNT_vpl VALUES ("MT26_67","070_26_67","MAT","26","67","67","U tuubtajoo' u wich. Moch'a'anoo' u c'ü' ca' u pa'loxtajoo'. Yanoo' ulaac' wücha'anoo' u c'ü' ca' u pa'loxtajoo' u wich ich mucul. ");
INSERT INTO mopNT_vpl VALUES ("MT26_68","070_26_68","MAT","26","68","68","—Wa jaj ti le'ec inchech u yaj Sa'alil a cristianojo, na'te maqui u jütz'ajech. Adü to'on mac u jütz'ajech,— cu t'anoo' mac tanoo' u pa'loxtic u wich ich mucul. ");
INSERT INTO mopNT_vpl VALUES ("MT26_69","070_26_69","MAT","26","69","69","Pues te'i. Tina'an ti que'en aj Pedro pach naj ich cot. C'ochi jun tuul ix meyaj etel. —Inchech ilic u yaj cambal a Jesus a tali cuenta Galilea,— cu t'an ti'i aj Pedrojo. ");
INSERT INTO mopNT_vpl VALUES ("MT26_70","070_26_70","MAT","26","70","70","Tu taan tulacaloo' u yadaj ti ma' le'equi. —Ma' in weel c'u' a tan a wadiqui,— cu t'an ti'i ix meyaj abe'e. ");
INSERT INTO mopNT_vpl VALUES ("MT26_71","070_26_71","MAT","26","71","71","Joq'ui aj Pedro te'i. Bini tuba que'en u chi' a coto. Ilbi u men ulaac' jun tuul ix meyaja. —Le'ec ilic a winic ada'a, tücünac tu pach a Jesus a tali ich caj Nazaret,— cu t'an ix ch'up abe' ti'ijoo' a wa'anoo' te'iji. ");
INSERT INTO mopNT_vpl VALUES ("MT26_72","070_26_72","MAT","26","72","72","Tu jajil u yadaj u t'an ti ma' u yeel u wich a Jesusu. —Ma'ax jun sut ti c'aj — oolte ti bajil etel a winic abe'e,— cu t'an ti'ijoo'. ");
INSERT INTO mopNT_vpl VALUES ("MT26_73","070_26_73","MAT","26","73","73","Sansamijac tucaye'ili, naatz'oo' tu tzeel aj Pedro a que'enoo' te'iji. —Tu jajil inchech jun tuul u yet'oc ala'aji. Chica'an etel a t'an,— cu t'anoo' ti'i aj Pedrojo. ");
INSERT INTO mopNT_vpl VALUES ("MT26_74","070_26_74","MAT","26","74","74","—U yeel a Dios ti jaj in t'an ti ma'ax jun sut ti c'aj-oolte ti bajil etel a winic abe'e,— cu t'an aj Pedro ti'ijoo'o. Tu seebal uchi u yawat aj t'ele. ");
INSERT INTO mopNT_vpl VALUES ("MT26_75","070_26_75","MAT","26","75","75","C'aji ti'i aj Pedro u t'an a Jesus u yadaj ti ma'ax to müchbüc. —Le'ec ti ma'ax to uchuc u yawat aj t'ele, ac ox sut tun a wadü' ti ma' a weel in wich,— cu t'an a Jesus ti'i biq'uin ado'o. Joq'ui te'i aj Pedrojo. Bini. Top uchi u yoc'ol tu jajil. ");
INSERT INTO mopNT_vpl VALUES ("MT27_1","070_27_1","MAT","27","1","1","Pues te'i. Le'ec ti sasajiji, much'lajoo' tulacaloo' u noochiloo' u yaj mansaj t'an a cristiano ti'i a Dios u yet'ocoo' a nucuch winiqui. U tzicbaltajoo' biqui ca' quimsabüc a Jesusu. ");
INSERT INTO mopNT_vpl VALUES ("MT27_2","070_27_2","MAT","27","2","2","C'üxa'an a Jesus ca' u bensajoo' etel aj gobernador Pilato. U c'ubajoo' ti'i. ");
INSERT INTO mopNT_vpl VALUES ("MT27_3","070_27_3","MAT","27","3","3","Pues te'i. Le'ec aj Judasa, le'ec u tzolaj a Jesusu. Le'ec ca' u yilaj ti bel u ca'a quimsabül a Jesusu, yajaji u yool. U jelaj u tucul. Ca' bini eteloo' u noochiloo' u yaj mansaj t'an a cristiano ti'i a Dios u yet'ocoo' a nucuch winiqui. U ca' bensaj a treinta p'eel a taq'uin plata ti'ijoo'o, ");
INSERT INTO mopNT_vpl VALUES ("MT27_4","070_27_4","MAT","27","4","4","—In cüxtaj in sip'il. In tzolaj ca' quimsabüc a ma' yan u sip'ili,— cu t'an ti'ijoo'. —¿C'u' ti t'an ti'i ino'ono? Inchech jaj tech,— cu t'anoo' ti'i aj Judasa. ");
INSERT INTO mopNT_vpl VALUES ("MT27_5","070_27_5","MAT","27","5","5","U wejchintaj a taq'uin ichil u yotoch a Dioso. Joq'ui te'i. Bini u chuyquinte u bajil ti'i u quimeeb. ");
INSERT INTO mopNT_vpl VALUES ("MT27_6","070_27_6","MAT","27","6","6","Pues te'i. Le'ecoo' u noochil u yaj mansaj t'an a cristiano ti'i a Dioso, u molajoo' a plataja. —Ma' qui' ca' ti tz'aa' tu yaam a taq'uin a tz'abi ti'i a Dioso. Le'ec a taq'uin ada'a, ac bo'la'an ti'i u quimeeb a maca,— cu t'anoo' tu bajil. ");
INSERT INTO mopNT_vpl VALUES ("MT27_7","070_27_7","MAT","27","7","7","Cajoo' u tzicbalte c'u' a beloo' u cu bete' etel a taq'uin abe'e. U q'uexajoo' a lu'um etel aj pütbal ti'i ca' yanac tuba u mucbuloo' a ma' Jerusalenoo'o. ");
INSERT INTO mopNT_vpl VALUES ("MT27_8","070_27_8","MAT","27","8","8","—A lu'um a q'uexbi etel q'uic',— cu t'anoo' yoc'ol a lu'um abe' tac leeb u men q'uexbi etel a taq'uin abe'e. ");
INSERT INTO mopNT_vpl VALUES ("MT27_9","070_27_9","MAT","27","9","9","Baala' ti jajaji u t'an aj Jeremiasa, le'ec jun tuul u yadaj u t'an a Dios uchi. —Yanoo' tu yaam aj Israele, u c'ümajoo' ti treinta p'eel a taq'uin plata u tool a jun tuulu. U ch'a'ajoo' a taq'uin abe'e. ");
INSERT INTO mopNT_vpl VALUES ("MT27_10","070_27_10","MAT","27","10","10","Etel a taq'uin abe'e, u q'uexajoo' a lu'um etel aj pütbal jabix ilic u yadaj ca' in bete' a Noochtzili,— cu t'an aj Jeremias uchi. ");
INSERT INTO mopNT_vpl VALUES ("MT27_11","070_27_11","MAT","27","11","11","Pues te'i. C'ochesabi a Jesus tu taan a gobernadoro. —¿Inchech wa u reyoo' aj Israele?— cu t'an a gobernador ti'iji. —Inen,— cu t'an a Jesus ti'iji. ");
INSERT INTO mopNT_vpl VALUES ("MT27_12","070_27_12","MAT","27","12","12","C'u' betiqui, le'ec ti tan u tzolbol u menoo' u noochiloo' u yaj mansaj t'an a cristiano ti'i a Dios u yet'ocoo' a nucuch winiqui, ma' uchi u nuuc a Jesusu. ");
INSERT INTO mopNT_vpl VALUES ("MT27_13","070_27_13","MAT","27","13","13","—¿Ma' wa tan a wu'yic boon a tanoo' u tzolic ta woc'olo? ¿C'u' ca'a ma' tan a nuuc?— cu t'an a gobernador ti'i a Jesusu. ");
INSERT INTO mopNT_vpl VALUES ("MT27_14","070_27_14","MAT","27","14","14","Ma'ax jun cuul a t'an u nuuctaj yoc'ol boon a sip'il u yadajoo' yoc'ol. Top sa'ti u yool a gobernador u men abe'e. ");
INSERT INTO mopNT_vpl VALUES ("MT27_15","070_27_15","MAT","27","15","15","Pues te'i. Le'ec ti tan a fiesta abe'e, suc a gobernador u cha'ic ti'ijoo' a cristiano jun tuul ca' joc'oc ti presojil. Walac u cha'ic mac a qui' tu wichoo' a cristiano ca' joc'oco. ");
INSERT INTO mopNT_vpl VALUES ("MT27_16","070_27_16","MAT","27","16","16","Jun tuul tu yaamoo' aj preso ti a q'uin abe'e, aj Barrabas u c'aba'. Top nooch u sip'il. ");
INSERT INTO mopNT_vpl VALUES ("MT27_17","070_27_17","MAT","27","17","17","Le'ec ti much'a'anoo' a cristianojo, aj Pilatojo, u c'aataj ti'ijoo'. —¿Mac a c'ate'ex ca' in chaa' te'ex? ¿A c'ate'ex wa aj Barrabasa, wa a c'ate'ex a Jesus le'ec a walacoo' u yadic ti Cristo?— cu t'an aj Pilato ti'ijoo'o. ");
INSERT INTO mopNT_vpl VALUES ("MT27_18","070_27_18","MAT","27","18","18","U yeel ti chen u men u xüc-ooliloo' a nucuch winic ti'i a Jesusu, u c'ubajoo' ti'iji. ");
INSERT INTO mopNT_vpl VALUES ("MT27_19","070_27_19","MAT","27","19","19","Ma' jadi' abe'e. Le'ec ti tinlaji aj Pilato tuba walac u yil sip'ili, tücaa'bi jun p'eel a t'an ti'i u men u yütan. —Ma' a betic ma'ax c'u'i ti'i a winic abe'e. Toj u na'at. Top yaj in c'ümaj aleebe ich nümül yoc'lal a winic abe'e,— cu t'an u yütan aj Pilato ti'iji. ");
INSERT INTO mopNT_vpl VALUES ("MT27_20","070_27_20","MAT","27","20","20","Pues te'i. Le'ecoo' u noochiloo' u yaj mansaj t'an a cristiano ti'i a Dios u yet'ocoo' a nucuch winiqui, u choct'antajoo' a cristiano ca' u c'aatoo' ca' cha'büc aj Barrabasa. U choct'antajoo' ilic xan ca' u c'aatoo' ca' quimsabüc a Jesusu. ");
INSERT INTO mopNT_vpl VALUES ("MT27_21","070_27_21","MAT","27","21","21","—¿Mac tu yaam a ca' tuul abe' a c'ate'ex ca' in chaa' te'exe?— cu t'an a gobernador ti'ijoo' tucaye'il. —Cha'a to'on aj Barrabasa,— cu t'anoo' ti'i. ");
INSERT INTO mopNT_vpl VALUES ("MT27_22","070_27_22","MAT","27","22","22","—¿C'u' a c'ate'ex ca' in bete' etel a Jesus a walacoo' u yadic ti Cristojo?— cu t'an aj Pilato ti'ijoo'o. —Adü ca' tz'abüc tuwich cruz,— cu t'anoo' tulacaloo' ti'iji. ");
INSERT INTO mopNT_vpl VALUES ("MT27_23","070_27_23","MAT","27","23","23","—¿C'u' ca'a? ¿C'u' ti sip'ilil u betaj?— cu t'an aj Pilato ti'ijoo'o. Cajoo' u yadü' ti chich: —Adü ca' tz'abüc tuwich cruz,— cu t'anoo' ti chich. ");
INSERT INTO mopNT_vpl VALUES ("MT27_24","070_27_24","MAT","27","24","24","Le'ec aj Pilatojo, u na'taj ti ma' tu paatal u jelicoo' u tucul. Chen tanoo' u mas tz'iictal a cristianojo. U ch'a'aj a ja'a. U p'o'aj u c'ü' tu taanoo' tulacal a cristiano ti'i u ye'ical ti ma' yan u sip'il ti'i a Jesusu. —Ma' yan in sip'il ti'i a winic ada'a. Toj u na'at. Te'ex a sip'il ti bel u ca'a quimsabül. Inche'ex jaj te'ex,— cu t'an aj Pilato ti'ijoo' a cristianojo. ");
INSERT INTO mopNT_vpl VALUES ("MT27_25","070_27_25","MAT","27","25","25","—Wa sip'il ti'i ca' quimsabüc a Jesusu, to'on y ti'ijoo' ti mejen,— cu t'anoo' tulacaloo' a cristiano ti uchoo' u nuuc. ");
INSERT INTO mopNT_vpl VALUES ("MT27_26","070_27_26","MAT","27","26","26","Pues te'i. U cha'aj aj Barrabas ti'ijoo'o. U tz'aj ca' jütz'büc a Jesus etel jatz' ca' tun u c'ubaj ti'i ca' quimsabüc tuwich cruz. ");
INSERT INTO mopNT_vpl VALUES ("MT27_27","070_27_27","MAT","27","27","27","Pues te'i. Le'ecoo' u soldado a gobernadoro, u yocsajoo' a Jesus yotoch caj. U much'quintajoo' u chucaan a soldado tuba que'en a Jesusu. ");
INSERT INTO mopNT_vpl VALUES ("MT27_28","070_27_28","MAT","27","28","28","U joc'sajoo' u noc' a Jesusu. U tz'ajoo' a chüc noc' yoc'ol jabix cuchi rey ala'aji. ");
INSERT INTO mopNT_vpl VALUES ("MT27_29","070_27_29","MAT","27","29","29","U copajoo' a q'ui'ix ca' p'aatüc jabix a corona. U tz'ajoo' tu pol. U tz'ajoo' a tz'i' che' tu c'ü' tu yaj toj tu yaj seeb jabix cuchi u p'is ti rey ala'aji. Cajoo' u p'a'aste. Xonlajoo' tu taan. —Inchech u reyoo' aj Israele. Qui'ac a wool,— cu t'anoo' ti'i a Jesusu. ");
INSERT INTO mopNT_vpl VALUES ("MT27_30","070_27_30","MAT","27","30","30","U tuubtajoo' a Jesusu. U tocaj ti'i a tz'i' che'e. U jütz'aj u pol etel. ");
INSERT INTO mopNT_vpl VALUES ("MT27_31","070_27_31","MAT","27","31","31","Le'ec ti jobi u p'a'asticoo'o, u joc'sajoo' a chüc noc' a que'en yoc'olo. U ca' tz'ajoo' u noc' ilic. U bensajoo' ti'i u tz'eecaloo' tuwich cruz. ");
INSERT INTO mopNT_vpl VALUES ("MT27_32","070_27_32","MAT","27","32","32","Pues te'i. Yan jun tuul a winiqui, aj Simon u c'aba'. Cirene u caal ala'aji. Le'ec ti tan u bensabül a Jesus pach caja, u c'ümajoo' ala'aji. U tz'ajoo' ti'i ca' u c'oochte u cruz a Jesusu. ");
INSERT INTO mopNT_vpl VALUES ("MT27_33","070_27_33","MAT","27","33","33","Pues te'i. C'ochoo' ichil jun p'eel cuuchil Golgota u c'aba'. U pol quimen u nu'cul a t'an abe'e. ");
INSERT INTO mopNT_vpl VALUES ("MT27_34","070_27_34","MAT","27","34","34","U tz'ajoo' cuchi ti'i ca' u yuc'u' a vino a xaaba'an etel a c'aja. Le'ec ca' u yaaltaja, ma' u yuc'aji. ");
INSERT INTO mopNT_vpl VALUES ("MT27_35","070_27_35","MAT","27","35","35","Le'ec ca' u tz'ajoo' a Jesus tuwich u cruz, u tz'ajoo' a bul a soldado ti'i ca' u t'oxoo' u noc' tu bajil. Baalo' ti jajaji u t'an mac u yadaj u t'an a Dios uchi. —U xet'ajoo' in noc' tu bajiloo'. U tz'ajoo' bul yoc'ol in noc',— cu t'an a t'an a tz'iiba'ana. ");
INSERT INTO mopNT_vpl VALUES ("MT27_36","070_27_36","MAT","27","36","36","Pachili, tinlajoo' u cününte a Jesusu. ");
INSERT INTO mopNT_vpl VALUES ("MT27_37","070_27_37","MAT","27","37","37","Yoc'ol u pol u tz'ajoo' jun p'eel ba'al tuba tz'iiba'an u sip'il a Jesusu. —Le'ec ada' a Jesusu, u reyoo' aj Israele,— cu t'an a t'an a tz'iiba'ana. ");
INSERT INTO mopNT_vpl VALUES ("MT27_38","070_27_38","MAT","27","38","38","Pues te'i. Tz'abi ilic ca' tuul aj xuuch' tuwich cruz, jujun tuul jujun xeel a Jesusu. ");
INSERT INTO mopNT_vpl VALUES ("MT27_39","070_27_39","MAT","27","39","39","Pues te'i. Le'ec a tanoo' u manül te'iji, u yuuc'tajoo' u pol ti tanoo' u p'a'astic a Jesusu. ");
INSERT INTO mopNT_vpl VALUES ("MT27_40","070_27_40","MAT","27","40","40","—Wa jede'ec u paatal a yojic u yotoch a Dios y a ca' wa'cunte ich ox p'e q'uini, sa'alte a bajil. Wa u Mejenech a Dioso, joq'uen tuwich a cruzu,— cu t'anoo' ti tanoo' u p'a'as. ");
INSERT INTO mopNT_vpl VALUES ("MT27_41","070_27_41","MAT","27","41","41","Pues te'i. Tanoo' ilic u p'a'astic a Jesus u noochiloo' u yaj mansaj t'an a cristiano ti'i a Dios u yet'ocoo' u yaj ca'ansajil u ley aj Moises eteloo' a nucuch winiqui. ");
INSERT INTO mopNT_vpl VALUES ("MT27_42","070_27_42","MAT","27","42","42","—Ca wilic. U sa'altaj ulaac'oo' a maca, pero ma' patal u sa'altic u bajil. Ila ti rey cuchi ino'on aj Israelo'ono. Wa cuchi jede'ec u joc'ol tuwich a cruzu, jede'ec cuchi ti tz'ocsic ala'aji,— cu t'anoo' tu bajil yoc'ol a Jesusu. ");
INSERT INTO mopNT_vpl VALUES ("MT27_43","070_27_43","MAT","27","43","43","—Que'en u yool tu pach a Dioso. Wa cuchi yajtzil u men a Dioso, jede'ec cuchi u sa'albül u men u yadaj u bajil ti u Mejen a Dioso,— cu t'anoo' ala'oo' tu bajil. ");
INSERT INTO mopNT_vpl VALUES ("MT27_44","070_27_44","MAT","27","44","44","Baalo' ilic ti p'a'asbi a Jesus u menoo' aj xuuch' a que'enoo' tuwich u cruz tu tzeele. ");
INSERT INTO mopNT_vpl VALUES ("MT27_45","070_27_45","MAT","27","45","45","Pues te'i. Jabix wal chuunq'uin ti ma' ca' chica'an u sac a q'uin yoc'olcab asto ti jabix wal a las tres ti a ocq'uini. ");
INSERT INTO mopNT_vpl VALUES ("MT27_46","070_27_46","MAT","27","46","46","Jabix a las tres ti ocq'uini, uchi u t'an ti chich a Jesusu. —Eli, Eli, lama sabactani,— cu t'an a Jesusu. —In Dios, in Dios, ¿c'u' ca'a a p'ütiquen?— cu t'an a t'an abe'e. ");
INSERT INTO mopNT_vpl VALUES ("MT27_47","070_27_47","MAT","27","47","47","Pues te'i. Yan a wa'anoo' te'iji. U yubajoo' c'u' u yadaj a Jesusu. —Le'ec a winic ada'a, tan u püyic aj quimen Eliasa, le'ec mac u yadaj u t'an a Dios uchi,— cu t'anoo' tu bajil. ");
INSERT INTO mopNT_vpl VALUES ("MT27_48","070_27_48","MAT","27","48","48","Jun tuul tu yaamoo'o, joq'ui ti alca'. U molaj jun p'eel ba'al jabix tümünü. U tzümaj ichil a vino a top ema'an u toolo. U tz'aj tu ni' a bequech che'e. U tz'aj tu chi' a Jesus ca' u yuc'u'. ");
INSERT INTO mopNT_vpl VALUES ("MT27_49","070_27_49","MAT","27","49","49","—Pa'te ti wilic wa ca' uduc aj Elias u sa'alte,— cu t'anoo' u chucaan tu bajil. ");
INSERT INTO mopNT_vpl VALUES ("MT27_50","070_27_50","MAT","27","50","50","Uchi u yawat ti chich a Jesus tucaye'ili. Quimi. ");
INSERT INTO mopNT_vpl VALUES ("MT27_51","070_27_51","MAT","27","51","51","Le'ec ti quimi a Jesusu, tziili a noc' a xit'a'an ti'i u colocche'il a ichil u yotoch a Dioso. Caji u tziilil yoc'ol tac yalam. P'aati ca' xeet. Uchi a yuc'laja. Buuji a tunichi. ");
INSERT INTO mopNT_vpl VALUES ("MT27_52","070_27_52","MAT","27","52","52","Pues te'i. Jeebi ilic tuba muca'anoo' a quimene. Tu yaamoo' boon a quimen a ti'i a Dioso, yaaboo' a ca' cuxlajoo' tucaye'il. ");
INSERT INTO mopNT_vpl VALUES ("MT27_53","070_27_53","MAT","27","53","53","Ti'i ilic a q'uin ti ca' cuxlaji a Jesus tucaye'ili, joc'oo' ala'oo' tuba muca'anoo'. Ocoo' ichil a caj Jerusalene. Ilboo' u men a yaaba. ");
INSERT INTO mopNT_vpl VALUES ("MT27_54","070_27_54","MAT","27","54","54","Pues te'i. Le'ec u noochiloo' a soldado u yet'ocoo' a soldado a tanoo' u cününtic a Jesusu, u yilajoo' ti uchi a yuc'laja. U yilajoo' tulacal a c'u' a tan u yuchulu. Jac'oo' u yool tu jajil. —Tu jajil ti le'ec ala'aji, u Mejen Dios,— cu t'anoo' tu bajil. ");
INSERT INTO mopNT_vpl VALUES ("MT27_55","070_27_55","MAT","27","55","55","Pues te'i. Que'enoo' ilic ix ch'up ti yaab te'iji. Tanoo' u cha'antic ti naach. Tücünacoo' tu pach a Jesus ti joq'ui cuenta Galilea biq'uin ado'o. Walacoo' u yaantic a Jesus biq'uin ado'o. ");
INSERT INTO mopNT_vpl VALUES ("MT27_56","070_27_56","MAT","27","56","56","Tu yaamoo' ala'oo' que'en ixna' Maria Magdalena u yet'ocoo' ixna' Maria le'ec u na' aj Jacob y aj Joseje, etel u na' u mejenoo' aj Zebedeojo. ");
INSERT INTO mopNT_vpl VALUES ("MT27_57","070_27_57","MAT","27","57","57","Pues te'i. Yan jun tuul a ayic'ala, Jose u c'aba'. Arimatea u c'aba' u caal. Que'en ilic u yool tu pach a Jesus aj Jose abe'e. Le'ec ti watac u yocol a q'uini, bini aj Jose etel aj gobernador Pilatojo. ");
INSERT INTO mopNT_vpl VALUES ("MT27_58","070_27_58","MAT","27","58","58","U c'aataj u büq'uel a Jesus ca' tz'abüc ti'iji, ti'i ca' u mucu'. Aalbi u tz'abül ti'i u men aj Pilatojo. ");
INSERT INTO mopNT_vpl VALUES ("MT27_59","070_27_59","MAT","27","59","59","Aj Joseje, u yemsaj u büq'uel a Jesusu. U bülaj etel süc noc' a tumulben to. ");
INSERT INTO mopNT_vpl VALUES ("MT27_60","070_27_60","MAT","27","60","60","Aj Joseje, ac paana'an u ch'e'en ichil a tunich tuba cuchi u mucbul. Paataji to. U coyquintaj a Jesus te'iji. U c'oc'lesaj a noxi' tunich ti'i u c'ülbical u chi' a ch'e'ene. Joq'ui te'i. Bini. ");
INSERT INTO mopNT_vpl VALUES ("MT27_61","070_27_61","MAT","27","61","61","Tina'anoo' ilic tuba mucbi a Jesus ixna' Maria Magdalena u yet'oc ulaac' ix Mariaja. ");
INSERT INTO mopNT_vpl VALUES ("MT27_62","070_27_62","MAT","27","62","62","Pues te'i. Quimsabi a Jesus tu q'uinil u yutzquinbil tulacal a c'u' a c'abeet ti'i u q'uinil jedel. Tu samalili, c'ochoo' etel aj Pilato u noochiloo' u yaj mansaj t'an a cristiano ti'i a Dios u yet'ocoo' a fariseo u c'aba'oo' u na'ata. ");
INSERT INTO mopNT_vpl VALUES ("MT27_63","070_27_63","MAT","27","63","63","—Noochil, c'üja'an to'on u t'an aj cho' abe' ti cuxa'an to. “Ca' manüc a ox p'e q'uini, bel in ca'a ti ca' cuxtal,” cu t'an aj cho'o,— cu t'anoo' ti'i aj Pilatojo. ");
INSERT INTO mopNT_vpl VALUES ("MT27_64","070_27_64","MAT","27","64","64","—U men u yadaj ti baalo'o, adü ca' cününbüc ox p'e q'uin u cuuchil tuba mucbi. Sabeensil u c'ocholoo' u yaj cambal u xuuch'too' u büq'uel. Pachili, beloo' u cu yadü' ti'ijoo' a cristiano ti ca' cuxlaji tu yaamoo' a quimene. Mas yaab a beloo' u ca'a tusbul u menoo' u t'an tuwich boon tuul a ac tusboo' tun,— cu t'anoo' ti'i aj Pilatojo. ");
INSERT INTO mopNT_vpl VALUES ("MT27_65","070_27_65","MAT","27","65","65","—Jeda'oo' a soldadojo. Ca' xique'ex a bete' tulacal a c'u' a patale'ex a bete' ti'i ma' u yocol a ma'ax mac te'iji,— cu t'an aj Pilato ti'ijoo'o. ");
INSERT INTO mopNT_vpl VALUES ("MT27_66","070_27_66","MAT","27","66","66","Joc'oo' te'i. Binoo' tuba mucbi a Jesusu. U tz'ajoo' jun p'eel u p'is tuwich a tunich a que'en tu chi' a che'ene. Ti baalo'o, chica'an wa yan mac ca' u tülü' a tunichi. Te'i u p'ütajoo' a soldado ca' cününbüc. ");
INSERT INTO mopNT_vpl VALUES ("MT28_1","070_28_1","MAT","28","1","1","Pues te'i. Mani a sabadojo. Tan to u sasiltal ti domingo. Le'ec ixna' Maria Magdalena u yet'oc ulaac' ix Mariaja, ca' binoo' u cha'ante tuba mucbi a Jesusu. ");
INSERT INTO mopNT_vpl VALUES ("MT28_2","070_28_2","MAT","28","2","2","Ca' u yilajoo'o, uchi a yuc'laj ti top chich u men emi ti ca'an jun tuul u yaj xa'num a Dioso. U jisaj a tunich a que'en tu chi' a ch'e'ene. Tinlaji yoc'ol. ");
INSERT INTO mopNT_vpl VALUES ("MT28_3","070_28_3","MAT","28","3","3","Naach u sac u wich jabix a lemleme. Top süc süc tu jajil u noc'o. ");
INSERT INTO mopNT_vpl VALUES ("MT28_4","070_28_4","MAT","28","4","4","Tzützülnacoo' a soldado u menoo' u saaquil ti'iji. Sücquimoo'. ");
INSERT INTO mopNT_vpl VALUES ("MT28_5","070_28_5","MAT","28","5","5","C'u' betiqui, uchi u tzicbal u yaj xa'num a Dios ti ca'an eteloo' a nooch'upu. —Ma' u jaq'üle'ex a wool. In weel ti ude'ex a cüxte'ex a Jesus a quimsabi tuwich cruzu,— cu t'an ti'ijoo' ix ch'upu. ");
INSERT INTO mopNT_vpl VALUES ("MT28_6","070_28_6","MAT","28","6","6","—Ma' wa'ye' que'eni. Ca' cuxlaji jabix ilic u yadaja. Co'ne'ex wa'ye' a wila' u cuuchil tuba coyquinbi,— cu t'an ti'ijoo' ix ch'upu. ");
INSERT INTO mopNT_vpl VALUES ("MT28_7","070_28_7","MAT","28","7","7","—Joboque'ex a wiliqui, xene'ex tu jomolil a wade'ex ti'ijoo' u yaj cambal ti ca' cuxlaji tu yaamoo' a quimene. Ade'ex ti'ijoo' ti c'ochol u ca'a payanbej tuwichoo' cuenta Galilea. Te'i u yilicoo'. Jadi' a t'an ada' a yan in wadic te'exe,— cu t'an u yaj xa'num a Dios ti ca'an ti'ijoo' ix ch'upu. ");
INSERT INTO mopNT_vpl VALUES ("MT28_8","070_28_8","MAT","28","8","8","Pues te'i. Joc'oo' tuba mucbi a quimene. C'üs saacoo' to, pero top qui'oo' u yool. Alca'oo' u beel ti'i u tzoloo' ti'i u yaj cambal a Jesusu. ");
INSERT INTO mopNT_vpl VALUES ("MT28_9","070_28_9","MAT","28","9","9","Ca' u yilajoo'o, c'ümboo' u men a Jesusu. —Dioos,— cu t'an a Jesus ti'ijoo'o. Le'ec ti c'ochoo' etel a Jesusu, xonlajoo' tu taan. U tz'ajoo' u c'ü' yoc'ol u yoc a Jesusu. Baalo' ti tanoo' u tz'ocsic u yanil a Jesusu. ");
INSERT INTO mopNT_vpl VALUES ("MT28_10","070_28_10","MAT","28","10","10","—Ca' manüc a saaquile'ex. Ca' xique'ex a wadü' ti'ijoo' in hermano ca' xicoo' cuenta Galilea. Te'i u yiliquenoo',— cu t'an a Jesus ti'ijoo'o. ");
INSERT INTO mopNT_vpl VALUES ("MT28_11","070_28_11","MAT","28","11","11","Pues te'i. Tu yaamoo' a soldado a tanoo' cuchi u cününtic tuba mucbi a Jesusu, yan a binoo' u yadü' u pectzil ich caj Jerusalen. Tanoo' to u beel ti bej ix ch'up ti c'ochoo' a soldado eteloo' u noochiloo' u yaj mansaj t'an a cristiano ti'i a Dioso. U yadajoo' ti'i tulacal a c'u' a maniji. ");
INSERT INTO mopNT_vpl VALUES ("MT28_12","070_28_12","MAT","28","12","12","Pues te'i. Much'lajoo' u noochiloo' u yaj mansaj t'an a cristiano ti'i a Dios u yet'ocoo' a nucuch winiqui. U tzicbaltajoo' tu bajil c'u' a beloo' u cu bete'. U tz'ajoo' a taq'uin ti yaab ti'ijoo' a soldado ti'i ca' u yadoo' a tusu. ");
INSERT INTO mopNT_vpl VALUES ("MT28_13","070_28_13","MAT","28","13","13","—Ade'ex ti'ijoo' a cristiano ti c'ochoo' u yaj cambal ti acü'ü. Le'ec ti tane'ex a wüyülü, u xuuch'tajoo' u büq'uel a quimene. ");
INSERT INTO mopNT_vpl VALUES ("MT28_14","070_28_14","MAT","28","14","14","Wa cuchi ca' u yubi abe' a gobernadoro, jede'ec ti sa'altique'ex ti'i ma' u tz'abüle'ex a sip'il,— cu t'anoo' ti'i a soldadojo. ");
INSERT INTO mopNT_vpl VALUES ("MT28_15","070_28_15","MAT","28","15","15","Pues te'i. Le'ecoo' a soldadojo, u c'ümajoo' a taq'uini. U yadajoo' a jabix ilic a aalbi ti'ijoo'o. Tac leeb tan ti tan u yaalbül a tus abe' tu yaamoo' aj Israele. ");
INSERT INTO mopNT_vpl VALUES ("MT28_16","070_28_16","MAT","28","16","16","Pues te'i. Binoo' a once tuul u yaj cambal ich cuenta Galilea. Binoo' tuwich a witz tuba aalbi ti'ijoo' u men a Jesusu. ");
INSERT INTO mopNT_vpl VALUES ("MT28_17","070_28_17","MAT","28","17","17","Le'ec ca' u yilajoo' a Jesusu, xonlajoo' tu taan ca' u ye'oo' ti nooch u yanil. C'u' betiqui, yan a ca' p'eel u yool u tuculu. ");
INSERT INTO mopNT_vpl VALUES ("MT28_18","070_28_18","MAT","28","18","18","Naatz'i a Jesus eteloo'o. —Tz'abi ten ti top nooch in yanil yoc'ol tulacal ti ca'an y yoc'olcab,— cu t'an a Jesusu. ");
INSERT INTO mopNT_vpl VALUES ("MT28_19","070_28_19","MAT","28","19","19","—U men nooch in yanili, ca' xique'ex tulacal tubajac yoc'olcab. Ade'ex in pectzil ti'ijoo' tulacal mac ti'i ca' yaabac boon tuul a tanoo' u tz'ocsiquen. Tz'aje'exoo' ala'oo' ti ocja' etel u c'aba' a Tattzili, a Mejentzili, y u Püsüc'al a Dioso,— cu t'an a Jesus ti'ijoo' u yaj cambala. ");
INSERT INTO mopNT_vpl VALUES ("MT28_20","070_28_20","MAT","28","20","20","—Ye'e'ex ti'ijoo' ala'oo' ca' u laj tz'oques tulacal a t'an in wadaj te'exe. U'yeene'ex. Que'en ti que'enen ta wetele'ex asto tu jobeeb a yoc'olcaba,— cu t'an a Jesus ti'ijoo' u yaj cambal. Wa'ye' jobi u tz'iib aj Mateojo.");
INSERT INTO mopNT_vpl VALUES ("MK1_1","071_1_1","MRK","1","1","1","Wa'ye' u caal u yaalbül a qui'il t'an, le'ec biqui ti culaji wa'ye' yoc'olcab a Jesucristo u Mejen a Dioso. ");
INSERT INTO mopNT_vpl VALUES ("MK1_2","071_1_2","MRK","1","2","2","Jun tuul tu yaamoo' boon u yadaj u t'an a Dios uchiji, aj Isaias u c'aba'. Baala' u tz'iibtaj yoc'ol c'u' u yadaj a Dios ti'i a Cristojo: —Inene, tan in tücaa'tic in waj xa'num ta taan. Bel u cu tojquinte a cristiano ti'i ca' u c'ümeechoo',— cu t'an a Dios ti'i a Cristojo. ");
INSERT INTO mopNT_vpl VALUES ("MK1_3","071_1_3","MRK","1","3","3","—Le'ec ada' u t'an a jun tuul a uchi u t'an ichil a p'atal lu'umu. “Tojquinte'ex a na'at ca' a c'üme'ex a Noochtzil jabix cuchi tane'ex a tojquintic a beje,” cu t'an ala'aji,— cu t'an a Dioso. Baalo' u tz'iibtaj aj Isaias yoc'ol aj Juan aj tz'aj ocja'a. ");
INSERT INTO mopNT_vpl VALUES ("MK1_4","071_1_4","MRK","1","4","4","Pues te'i. Le'ec aj Juan aj tz'aj ocja'a, caji ti t'an ich p'atal lu'um. U yadaj ti'ijoo' a cristiano ca' u c'ümoo' a ocja'a. Le'ec a ocja' abe'e, u p'is ca' u jelajoo' u tucul, y sa'tesabi u sip'il u men a Dioso. ");
INSERT INTO mopNT_vpl VALUES ("MK1_5","071_1_5","MRK","1","5","5","Binoo' a cristiano etel aj Juan u c'ümoo' a ocja'a. Taloo' tulacal tubajac cuenta Judea. Yaab ilic a cristiano ichil a caj Jerusalene, c'ochoo' etel aj Juana. Le'ec ca' u tzolaj u sip'il a jujun tuulu, tz'aboo' ti ocja' ich noja' Jordan u men aj Juana. ");
INSERT INTO mopNT_vpl VALUES ("MK1_6","071_1_6","MRK","1","6","6","Pues te'i. Otzil u yilbil u noc' aj Juana. Chen betaja'an etel u tzo'otzel a baalche' u c'aba' camello. Chen u xet'el q'uewel u c'ax u nüc'. Le'ec u janala, jabix aj saac' a walac u jantabülü. Walac ilic u jantic u c'a' cab a walac u cüxtic ich che'. ");
INSERT INTO mopNT_vpl VALUES ("MK1_7","071_1_7","MRK","1","7","7","—Watac jun tuul a mas nooch u wichil u meyaj tin wich inene. Ma' chucul in yanil ma'ax ti'i in xontal in joq'ues u zapato,— cu t'an aj Juana. ");
INSERT INTO mopNT_vpl VALUES ("MK1_8","071_1_8","MRK","1","8","8","—Inene, walac in tz'eeque'ex ti ocja' etel ja'. C'u' betic ala'aji, bel u cu tz'a'e'ex jabix ti ocja' pero chen etel u Püsüc'al a Dioso,— cu t'an aj Juan ti'ijoo' a cristianojo. ");
INSERT INTO mopNT_vpl VALUES ("MK1_9","071_1_9","MRK","1","9","9","Pues te'i. Joq'ui a Jesus ich caj Nazaret a que'en ich cuenta Galilea. Bini etel aj Juana. Tz'abi ti ocja' a Jesus ich noja' Jordan u men aj Juana. ");
INSERT INTO mopNT_vpl VALUES ("MK1_10","071_1_10","MRK","1","10","10","Le'ec ti joq'ui a Jesus ichil a ja'a, tu jomolil u yilaj ti jabix jeebi a ca'ana. U yilaj u yemel u Püsüc'al a Dios jabix paloma. Emi tac yoc'ol a Jesusu. ");
INSERT INTO mopNT_vpl VALUES ("MK1_11","071_1_11","MRK","1","11","11","Uchi a t'an ti ca'ana. —Inchech in Mejen. Yaj in wu'yeech. Qui' in wool ta wetel,— cu t'an a t'an ti ca'ana. ");
INSERT INTO mopNT_vpl VALUES ("MK1_12","071_1_12","MRK","1","12","12","Pues te'i. Tu jomolil tz'abi ti'i a Jesus u men u Püsüc'al a Dios ca' xi'ic ichil a p'atal lu'umu. ");
INSERT INTO mopNT_vpl VALUES ("MK1_13","071_1_13","MRK","1","13","13","Cuarenta q'uin que'en te'i a Jesusu. Chen u cuuchil baalche' tuba que'en. Tan u yaaltabül emsabül u yool ca' u bete' a c'as a Jesus u men a quisini. Pachil abe'e, c'ochoo' u yaj xa'num a Dios ti ca'ana. U yaantajoo' a Jesusu. ");
INSERT INTO mopNT_vpl VALUES ("MK1_14","071_1_14","MRK","1","14","14","Pues te'i. Le'ec ti müchbi aj Juan u men a reye, bini a Jesus ich cuenta Galilea. Tan u yadic u pectzil Dios ti'ijoo' a cristiano te'iji. ");
INSERT INTO mopNT_vpl VALUES ("MK1_15","071_1_15","MRK","1","15","15","—C'ochi u q'uinil u caal ti tücaa' a Dioso. Jele'ex a tucul. Tucle'ex a quich'pan tuculu. Tz'ocse'ex u t'an a Dioso,— cu t'an a Jesusu. ");
INSERT INTO mopNT_vpl VALUES ("MK1_16","071_1_16","MRK","1","16","16","Pues te'i. Tan u manül a Jesus tu chi' a laguna u c'aba' Galileaja. U yilaj aj Simon u yet'oc aj Andres. U yitz'inoo' u sucu'unoo' u bajil. Tanoo' u pulic ich ja' a chinchor ti'i müch ch'ilam. Aj jooc'oo' a ca' tuulu. ");
INSERT INTO mopNT_vpl VALUES ("MK1_17","071_1_17","MRK","1","17","17","—Ca' talaque'ex tin wetel. Bel in quin yee' te'ex biqui ca' a müche'ex a cristiano jabix ilic ti walaque'ex a müchic a ch'ilama,— cu t'an a Jesus ti'ijoo'o. ");
INSERT INTO mopNT_vpl VALUES ("MK1_18","071_1_18","MRK","1","18","18","Tu seebal u p'ütajoo' u müchbeeb a ch'ilama. Binoo' tu pach a Jesusu. ");
INSERT INTO mopNT_vpl VALUES ("MK1_19","071_1_19","MRK","1","19","19","Pues te'i. Caji ti mas beel a Jesus tu chi' a lagunaja. U yilajoo' ulaac' ca' tuul a winiqui. U yitz'inoo' u sucu'unoo' ilic u bajil. Le'ec a ca' tuulu, u mejenoo' aj Zebedeojo. Aj Jacob y aj Juan u c'aba'oo'. Que'enoo' ichil a barcojo. Tanoo' u yutzquintic a chinchor ti müch ch'ilam u yet'ocoo' u tat. ");
INSERT INTO mopNT_vpl VALUES ("MK1_20","071_1_20","MRK","1","20","20","Tu seebal u püyajoo' a ca' tuul a Jesusu. U p'ütajoo' u tat ichil a barco eteloo' u yaj meyaj. Binoo' tu pach a Jesusu. ");
INSERT INTO mopNT_vpl VALUES ("MK1_21","071_1_21","MRK","1","21","21","Pues te'i. Bini a Jesus ich caj Capernaum u yet'ocoo' a que'enoo' tu pacha. Le'ec ti c'ochi u q'uinil a jedele, oqui a Jesus ichil a naj tuba walacoo' u much'tal u c'ajesoo' a Dioso. U ca'ansajoo' a cristiano a much'a'anoo' te'iji. ");
INSERT INTO mopNT_vpl VALUES ("MK1_22","071_1_22","MRK","1","22","22","Sa'too' u yool a cristiano abe' u men biqui ti walac u ca'ansaj. Ala'aji, u ca'ansajoo' jabix ilic tu ca'ansaj jun tuul a top yaab u yeele. Le'ecoo' u yaj ca'ansajil u ley aj Moisese, ma' ta'achoo' u ca'ansaj jabix a Jesusu. ");
INSERT INTO mopNT_vpl VALUES ("MK1_23","071_1_23","MRK","1","23","23","Pues te'i. Jun tuul a winiqui, yan a c'ac'asba'al tu yool. Que'en ala'i tu yaamoo' a que'en ichil a naj abe' u c'ajesoo' a Dioso. ");
INSERT INTO mopNT_vpl VALUES ("MK1_24","071_1_24","MRK","1","24","24","—P'üto'on. Ma' c'u' a t'an to'oni, Jesus. Incheche, Nazaret taleech. ¿Taleech wa a jobso'on? In weel a wich. Incheche, u Mejenech a Dioso,— cu t'an ti'i a Jesus ti chichi. ");
INSERT INTO mopNT_vpl VALUES ("MK1_25","071_1_25","MRK","1","25","25","Le'ec a Jesusu, u q'ue'yaj a c'ac'asba'ala. —Ma' t'an,— cu t'an a Jesus ti'iji. —Joq'uen tu yool a winiqui,— cu t'an ti'i. ");
INSERT INTO mopNT_vpl VALUES ("MK1_26","071_1_26","MRK","1","26","26","Sücquimi a winic u men a c'ac'asba'ala. Tan u peec tac u yoc u c'ü'ü. Uchi u yawat ti chich ca' tun joq'ui tu yool a winiqui. ");
INSERT INTO mopNT_vpl VALUES ("MK1_27","071_1_27","MRK","1","27","27","Sa'too' u yool a cristiano a que'en te'iji, mentücü, cajoo' ti t'an tu bajiloo'. —¿Biqui yanil abe'e? Top jumpaay u t'an a Jesusu. Etel u yanil walac ilic u tücaa'tic a c'ac'asba'al, y walac u tz'ocsabül u t'an,— cu t'anoo' a cristiano tu bajili. ");
INSERT INTO mopNT_vpl VALUES ("MK1_28","071_1_28","MRK","1","28","28","Tu jomolil eeltabi c'u' u betaj a Jesus tulacal tubajac ti nütz'a'an ich cuenta Galilea. ");
INSERT INTO mopNT_vpl VALUES ("MK1_29","071_1_29","MRK","1","29","29","Pues te'i. Joq'ui a Jesus ichil a naj abe' tuba much'a'anoo' a cristianojo. Bini tu yotoch aj Simon y aj Andres. Que'enoo' ilic aj Jacob y aj Juan tu pach a Jesusu. ");
INSERT INTO mopNT_vpl VALUES ("MK1_30","071_1_30","MRK","1","30","30","Que'en ti cama u yixa'an aj Simon u men c'oja'an. Tan u chücüwil. Tu seebal u yadajoo' ti'i a Jesus c'u' a yan ti'i a nooch'up abe'e. ");
INSERT INTO mopNT_vpl VALUES ("MK1_31","071_1_31","MRK","1","31","31","Bini a Jesus etel a nooch'up abe'e. U müchaj tu c'ü'. U lic'saj. Tu seebal mani u chücüwil. U tzeentajoo' u yaj sutil. ");
INSERT INTO mopNT_vpl VALUES ("MK1_32","071_1_32","MRK","1","32","32","Pues te'i. Le'ec ti oqui a q'uini, c'ochesaboo' etel a Jesus boon tuul a c'oja'an u yet'ocoo' boon tuul a yan a c'ac'asba'al tu yoolo. ");
INSERT INTO mopNT_vpl VALUES ("MK1_33","071_1_33","MRK","1","33","33","But'a'anoo' tulacal a caj chi' naj tuba que'en a Jesusu. ");
INSERT INTO mopNT_vpl VALUES ("MK1_34","071_1_34","MRK","1","34","34","Le'ec a Jesusu, u ch'anesajoo' ti yaab a c'oja'ana. Ca'ax c'u'ac ti c'oja'anil, u ch'anesaj. U joc'sajoo' a c'ac'asba'al tu yool a yaaba. Ma' u cha'ajoo' ca' uchuc u t'an a c'ac'asba'al u men u yeeloo' maqui ala'aji. ");
INSERT INTO mopNT_vpl VALUES ("MK1_35","071_1_35","MRK","1","35","35","Pues te'i. Ac'ü' to ma'ax to sasac ti liq'ui a Jesusu. Bini tuba ma'ax mac a yana. Uchi u t'an etel a Dios te'iji. ");
INSERT INTO mopNT_vpl VALUES ("MK1_36","071_1_36","MRK","1","36","36","Le'ec ti liq'ui aj Simon eteloo' u yet'oco, binoo' u cüxte tuba que'en a Jesusu. ");
INSERT INTO mopNT_vpl VALUES ("MK1_37","071_1_37","MRK","1","37","37","Le'ec ca' u cüxtajoo'o, u yadajoo' ti'i: —Top yaab mac tanoo' u cüxtiquech,— cu t'anoo' ti'i. ");
INSERT INTO mopNT_vpl VALUES ("MK1_38","071_1_38","MRK","1","38","38","—Co'ne'ex ti t'an ichil boon ulaac' a caj wa'ye' jabix ilic ti betaj ich caj Capernaum. Le'ec in meyaj ti udeen wa'ye',— cu t'an a Jesusu. ");
INSERT INTO mopNT_vpl VALUES ("MK1_39","071_1_39","MRK","1","39","39","Mani tulacal tubajac cuenta Galilea. Uchi u t'an ichil boon a naj tuba walacoo' u much'tal a cristiano u c'ajes a Dioso. U joc'sajoo' a c'ac'asba'al tu yool a cristianojo. ");
INSERT INTO mopNT_vpl VALUES ("MK1_40","071_1_40","MRK","1","40","40","Pues te'i. Naatz'i jun tuul a winic tu tzeel a Jesusu. Top tan u tu'ujtal u büq'uel u men u c'oja'anil. Xonlaji tu taan a Jesusu. —Wa qui' ta wich a ch'anesiquen, jede'ec u paatal a ch'anesiquen,— cu t'an ti'i a Jesusu. ");
INSERT INTO mopNT_vpl VALUES ("MK1_41","071_1_41","MRK","1","41","41","Otzil a winic tu wich a Jesusu. U tz'aj u c'ü' yoc'ol a winiqui. —In c'ati,— cu t'an ti'i. —Ch'aneech tun,— cu t'an a Jesus ti'iji. ");
INSERT INTO mopNT_vpl VALUES ("MK1_42","071_1_42","MRK","1","42","42","Tu seebal ch'ani a winiqui. Ma' ca' c'oja'an. ");
INSERT INTO mopNT_vpl VALUES ("MK1_43","071_1_43","MRK","1","43","43","Le'ec ti ma'ax to tücaa'büc a winic u men a Jesusu, u yadaj ti'i tu jajil: ");
INSERT INTO mopNT_vpl VALUES ("MK1_44","071_1_44","MRK","1","44","44","—Ma' a wadic ti'i ma'ax mac c'u' a mani tech,— cu t'an a Jesus ti'iji. —Jadi' ca' xiquech etel u yaj mansaj t'an a cristiano ti'i a Dioso. Ye'e a bajil ti'i, y tz'a ilic ti'i a Dios a sij-ool jabix ilic ti tz'iiba'an ichil a ley u tz'iibtaj aj Moisese. Te'i u yilicoo' ti ch'aneech,— cu t'an a Jesusu. ");
INSERT INTO mopNT_vpl VALUES ("MK1_45","071_1_45","MRK","1","45","45","Le'ec ti bini a winiqui, caji u tzicbalte ti'i ca'ax macac biqui ti ch'anesabi u men a Jesusu. U t'it'aj u pectzil ti yaab, mentücü, ma' ca' yan biqui u yocol a Jesus ichil a caj ti chica'an. Culaji ich aldea. C'ochoo' a cristiano etel a Jesusu. Taloo' tulacal tubajac. ");
INSERT INTO mopNT_vpl VALUES ("MK2_1","071_2_1","MRK","2","1","1","Pues te'i. Tu pach ma' eela'an boon q'uin, usc'aji a Jesus ich caj Capernaum. Eeltabi ti cuma'an ala'aji. ");
INSERT INTO mopNT_vpl VALUES ("MK2_2","071_2_2","MRK","2","2","2","Much'lajoo' ti yaab a cristiano etel. But'a'anoo' a cristiano ich naj, y pach naja, chen tanoo' u nüt'ic u bajil u menoo' u yaabil. Le'ec a Jesusu, tan u yadic u t'an Dios ti'ijoo' a cristiano abe'e. ");
INSERT INTO mopNT_vpl VALUES ("MK2_3","071_2_3","MRK","2","3","3","C'ochesabi u men cuatro tuul ti winic jun tuul a sotmen u büq'uel a ma' ta'ach u peeque. ");
INSERT INTO mopNT_vpl VALUES ("MK2_4","071_2_4","MRK","2","4","4","Ma' pataloo' ti ocol ich naj u men top yaab a cristianojo, mentücü, nac'oo' pol naj etel a c'oja'ana, u men quet u pol a naja. U potajoo' u pol a naj yoc'ol a Jesusu. Le'ec a c'oja'ana, coya'an ti que'en tuwich u coytaan. U yemsajoo' tu taan a Jesusu. ");
INSERT INTO mopNT_vpl VALUES ("MK2_5","071_2_5","MRK","2","5","5","Le'ec a Jesusu, u yilaj ti que'enoo' u yool tu pach ala'i ti'i ca' u ch'anes a sotmen u büq'uele. —Sa'tesabi a sip'il,— cu t'an a Jesus ti'i a c'oja'ana. ");
INSERT INTO mopNT_vpl VALUES ("MK2_6","071_2_6","MRK","2","6","6","Pues te'i. Yanoo' u yaj ca'ansajil u ley aj Moises a tina'anoo' te'iji. Cajoo' u tucle c'u' u nu'cul u yadaj a Jesusu. ");
INSERT INTO mopNT_vpl VALUES ("MK2_7","071_2_7","MRK","2","7","7","—Le'ec a winic ada'a, ¿c'u' ca'a u yadaj ti sa'tesabi u sip'il a c'oja'ana? Tan u maclant'antic a Dioso. Ma'ax mac a patal u sa'tes a sip'ili, jadi' a Dioso,— cu t'anoo' tu bajil yoc'ol a Jesusu. ");
INSERT INTO mopNT_vpl VALUES ("MK2_8","071_2_8","MRK","2","8","8","Pues te'i. Le'ec a Jesusu, tu seebal u yeeltaj c'u' a tanoo' u tucliqui. —¿C'u' ca'a tane'ex a tuclic ti baalo'?— cu t'an ti'ijoo'. ");
INSERT INTO mopNT_vpl VALUES ("MK2_9","071_2_9","MRK","2","9","9","—Ma' yaj ca' in wadü' ti sa'tesabi u sip'il a c'oja'an ada' a ma' ta'ach u peeque, u men ma' chica'an wa jaj in t'an. C'u' betiqui, yaj ca' in wadü': “Liq'uen. Molo a coytaan. Uchuc a ximbal,” u men te'i u chictal wa jaj in t'an,— cu t'an a Jesus ti'ijoo'o. ");
INSERT INTO mopNT_vpl VALUES ("MK2_10","071_2_10","MRK","2","10","10","—Inene, yanajeen ti cristianojil. Ti'i ca' a weelte'ex ti yan in yanil in sa'tes sip'il wa'ye' yoc'olcab, bel in quin ch'anes a c'oja'ana,— cu t'an a Jesus ti'ijoo'o. ");
INSERT INTO mopNT_vpl VALUES ("MK2_11","071_2_11","MRK","2","11","11","—Wa'len. Molo a coytaan. Ca' xiquech ta wotoch,— cu t'an a Jesus ti'i a winic a sotmen u büq'uele. ");
INSERT INTO mopNT_vpl VALUES ("MK2_12","071_2_12","MRK","2","12","12","Wa'laji a winic abe'e. Tu seebal u molaj u coytaan. Joq'ui tu taanoo' a que'en te'iji. Bini. Sa'too' u yool tulacaloo' a cristiano etel c'u' a maniji. U yadajoo' u qui'il a Dioso. —Ma'ax jun sut ti wilaj a jabix ado'o,— cu t'anoo'. ");
INSERT INTO mopNT_vpl VALUES ("MK2_13","071_2_13","MRK","2","13","13","Pues te'i. Ca' bini a Jesus tucaye' tu chi' a lagunaja. Tulacaloo' a cristianojo, much'lajoo' etel. U ca'ansajoo'. ");
INSERT INTO mopNT_vpl VALUES ("MK2_14","071_2_14","MRK","2","14","14","Le'ec ti tan u ca' beel a Jesusu, u yilaj aj Levi, le'ec u mejen aj Alfeojo. Tina'an ti que'en aj Levi tu cuuchil tuba walac u molic a taq'uin ti'i a gobiernojo. —Co'ox tin pach,— cu t'an a Jesus ti'iji. Liq'ui. Bini tu pach a Jesusu. ");
INSERT INTO mopNT_vpl VALUES ("MK2_15","071_2_15","MRK","2","15","15","Pues te'i. Pach mesa que'enoo' a Jesus u yet'ocoo' u yaj cambal ichil u yotoch aj Leviji. Yaaboo' ilic aj mol taq'uin ti'i a gobierno u yet'ocoo' a yanoo' u sip'il a que'enoo' ilic te'i ti janal etel a Jesusu. ");
INSERT INTO mopNT_vpl VALUES ("MK2_16","071_2_16","MRK","2","16","16","Ilbi a Jesus ti tan u janal eteloo' aj mol taq'uin u yet'ocoo' a yanoo' u sip'ili. Le'ecoo' u yaj ca'ansajil u ley aj Moises u yet'ocoo' a fariseo u c'aba'oo u na'ata, le'ec u yilajoo' abe'e. —¿C'u' ca'a que'en ti janal ti uc'ul ala'i tu yaamoo' aj mol taq'uin ti'i a gobierno u yet'ocoo' a yanoo' u sip'ili?— cu t'anoo' ti'i u yaj cambal a Jesusu. ");
INSERT INTO mopNT_vpl VALUES ("MK2_17","071_2_17","MRK","2","17","17","Le'ec a Jesusu, u yubajoo' u t'an. U nuuctajoo'. —Ma' c'abeet aj tz'ücyaj ti'ijoo' a muc'a'ani, pero c'abeet ti'ijoo' a c'oja'ana. Ma' taleen ti'i in wadü' ti'ijoo' a cristiano a tojoo' u na'at ca' u jeloo' u tucul ca' tun u tucloo' a toji. Taleen in wadü' abe' ti'ijoo' a yanoo' u sip'ili,— cu t'an a Jesus ti'ijoo'o. ");
INSERT INTO mopNT_vpl VALUES ("MK2_18","071_2_18","MRK","2","18","18","Pues te'i. Le'ecoo' u yaj cambal aj Juan aj tz'aj ocja'a, ma' tanoo' u janali. Tanoo' u suq'uin. Baalo' ilic a tanoo' u betic u yaj cambal a fariseo u c'aba'oo' u na'ata. C'ochoo' a cristiano u c'aate ti'i a Jesusu. —Walacoo' u p'ütic a janal ti'i u suq'uin u yaj cambaloo' aj Juan aj tz'aj ocja' u yet'ocoo' u yaj cambaloo' a fariseo u c'aba'oo' u na'ata. ¿C'u' ca'a ma' ta'achoo' u suq'uin a waj cambal incheche?— cu t'anoo' ti'i a Jesusu. ");
INSERT INTO mopNT_vpl VALUES ("MK2_19","071_2_19","MRK","2","19","19","Le'ec a Jesusu, u yadaj a mucult'an ti'ijoo' yoc'ol ma' tu paataloo' u p'üticoo' a janal ti que'en to eteloo'. —Le'ec ti que'en to aj tz'ocolbeel tu yaamoo' u yaj sutili, ¿jede'ecoo' wa u paatal u p'ütic a janal ca' tun uchucoo' u suq'uin a emoo' ti uc'ul etele? Le'ec ti que'en to aj tz'ocolbeel eteloo'o, ma' tu paataloo' u suq'uin,— cu t'an a Jesus ti'ijoo'o. ");
INSERT INTO mopNT_vpl VALUES ("MK2_20","071_2_20","MRK","2","20","20","—Watac u q'uinil le'ec ti bel u ca'a joc'sabül aj tz'ocolbeel tu yaamoo'. Ti a q'uin abe'e, beloo' u ca'a ti suq'uin,— cu t'an a Jesus ti'ijoo'o. ");
INSERT INTO mopNT_vpl VALUES ("MK2_21","071_2_21","MRK","2","21","21","—Pues te'i. Ma'ax mac walac u püc'ültic a uchben noc' etel a tumul noc'o. A tumul noc'o, walac u coomtal ta wichi. Wa cuchi ca' u betoo' ti baalo', bel u cu tzili' a uchben a tumulbene. P'aatül u ca'a ti mas nooch u tzililal a uchbene,— cu t'an a Jesusu. ");
INSERT INTO mopNT_vpl VALUES ("MK2_22","071_2_22","MRK","2","22","22","—Ma'ax walac u tz'abül tumul vino ichil u cuuchil a betabi etel uchben q'uewel. Walac u betabaanül u bolsajil vino etel q'uewel. Wa cuchi ca' tz'abüc ti baalo'o, tanil u tzaquesic u bajil a tumul vinojo, bel u ca'a ti jeetel a uchben q'uewele. Yan u tz'abül a tumul vino ichil u cuuchil a betabi etel tumul q'uewel,— cu t'an a Jesus ich mucult'an. ");
INSERT INTO mopNT_vpl VALUES ("MK2_23","071_2_23","MRK","2","23","23","Pues te'i. Jun p'eel q'uin tan u manül a Jesus eteloo' u yaj cambal ich col. U q'uinil jedel a q'uin abe'e. Wi'ijoo' u yaj cambal a Jesusu. Cajoo' u jiribte tz'etz'eec u semilla harina ti tanoo' u manül. ");
INSERT INTO mopNT_vpl VALUES ("MK2_24","071_2_24","MRK","2","24","24","—Iloo' a waj cambal,— cu t'anoo' a fariseo u c'aba'oo' u na'at ti'i a Jesusu. —¿C'u' ca'a tanoo' u betic c'u' a ma' qui' u betabül tu q'uinil a jedele?— cu t'anoo' ti'i. ");
INSERT INTO mopNT_vpl VALUES ("MK2_25","071_2_25","MRK","2","25","25","—¿C'u' ca'a tane'ex a wadic abe'e? A xocaje'ex c'u' u betaj aj quimen rey David u yet'ocoo' u yetmanül le'ec ti wi'ijoo',— cu t'an a Jesus ti'ijoo'o. ");
INSERT INTO mopNT_vpl VALUES ("MK2_26","071_2_26","MRK","2","26","26","—Le'ec ti mas nooch u wichil u meyaj aj Abiatar tuwichoo' u chucaan u yaj mansaj t'an a cristiano ti'i a Dioso, oqui aj David ichil u yotoch a Dioso,— cu t'an a Jesusu. —U molaj a waj harina a tz'abi ti'i a Dioso. U tz'aj ti'ijoo' u yetmanül. U laj jantajoo' a waj harinaja. Ma' qui' tu c'axül ti'i a ley ca' jantabüc a waj harina abe' u men a ca'ax macaqui. Jadi' tz'abi u men Dios ca' u jante a waj harina abe' u yaj mansaj t'an a cristiano ti'i a Dioso. Le'ec aj David abe'e, ma' u yaj mansaj t'an a cristiano ti'i a Diosi,— cu t'an a Jesusu. ");
INSERT INTO mopNT_vpl VALUES ("MK2_27","071_2_27","MRK","2","27","27","—Le'ec a Dioso, u betaj u q'uinil a jedel ti'i u yaantical a winiqui. Ma' u betaj a winic chen ti'i ca' u tz'oques u q'uinil a jedel jabix a tane'ex a wadiqui,— cu t'an a Jesusu. ");
INSERT INTO mopNT_vpl VALUES ("MK2_28","071_2_28","MRK","2","28","28","—Le'ec inen a yanajeen ti cristianojili, yan in yanil ti tücaa' ca'ax tu q'uinil jedel,— cu t'an a Jesusu. ");
INSERT INTO mopNT_vpl VALUES ("MK3_1","071_3_1","MRK","3","1","1","Pues te'i. Oqui a Jesus ichil a naj tuba walacoo' u much'tal a cristiano u c'ajes a Dioso. Tu yaamoo' a cristiano a much'a'anoo' te'iji, yan jun tuul a winic a mooch u c'ü'ü. ");
INSERT INTO mopNT_vpl VALUES ("MK3_2","071_3_2","MRK","3","2","2","Tan u cha'anbül a Jesus ti'i ca' ilbic wa ca' u ch'anes a mac tu q'uinil a jedel ti'i ca' paatacoo' u tzolo' ala'aji. ");
INSERT INTO mopNT_vpl VALUES ("MK3_3","071_3_3","MRK","3","3","3","—Wa'len taanil,— cu t'an a Jesus ti'i a winic a mooch u c'ü'ü. ");
INSERT INTO mopNT_vpl VALUES ("MK3_4","071_3_4","MRK","3","4","4","—¿Biqui'il a qui' tu c'axül ti'i a ley ti u q'uinil a jedel ta t'ane'exe, wa ti betic a qui'i, wa ti betic a c'asa? ¿Qui' wa ca' ti sa'alte u cuxtal a maca, wa ca' ti quimes ala'i ti u q'uinil a jedele?— cu t'an a Jesusu. Ma'ax mac a uchoo' u nuuc. ");
INSERT INTO mopNT_vpl VALUES ("MK3_5","071_3_5","MRK","3","5","5","Tz'iic a Jesus ti'ijoo' a cristiano te'i ti tan u cha'anticoo' tulacaloo'. Yaj u yool u men top chichoo' u pol. —Sützü a c'ü',— cu t'an ti'i a winiqui. U sützaj u c'ü'. Ch'ani. ");
INSERT INTO mopNT_vpl VALUES ("MK3_6","071_3_6","MRK","3","6","6","Pues te'i. Joc'oo' a fariseo u c'aba'oo' u na'ata. Much'lajoo' eteloo' aj herodiano u c'aba'oo' u na'at. Cajoo' u tucle biqui ca' u quimesoo' a Jesusu. ");
INSERT INTO mopNT_vpl VALUES ("MK3_7","071_3_7","MRK","3","7","7","Pues te'i. Joq'ui a Jesusu. Bini tu chi' a laguna u yet'ocoo' u yaj cambal. Yaaboo' a cristiano a taloo' cuenta Galilea cuenta Judeaja, tücünacoo' tu pach a Jesusu. ");
INSERT INTO mopNT_vpl VALUES ("MK3_8","071_3_8","MRK","3","8","8","Yanoo' ilic a taloo' ich caj Jerusalen, taloo' cuenta Idumea, taloo' junxeel a noja' Jordan tu joq'ueeb q'uin, taloo' ma' naach ti a caj Tiro a caj Sidon. Top mani tu pach u yaabil a cristianojo. C'ochoo' etel a Jesus u men u yubajoo' tulacal a c'u' u betaj ala'aji. ");
INSERT INTO mopNT_vpl VALUES ("MK3_9","071_3_9","MRK","3","9","9","—Ca' xique'ex a cüxte jun p'eel a barco tuba u paatal in wocol wa ca' caac u nüt'eenoo' a cristianojo. Top yaaboo' tu bajil,— cu t'an a Jesus ti'ijoo' u yaj cambala. ");
INSERT INTO mopNT_vpl VALUES ("MK3_10","071_3_10","MRK","3","10","10","Sabeensil u nüt'bül u men ac u ch'anesaj a yaaba, y tulacal boon u chucaan a c'oja'ana, tanoo' u tutulca'tic u bajil ti'i ca' u tüloo' ala'i ti'i ca' ch'anücoo'. ");
INSERT INTO mopNT_vpl VALUES ("MK3_11","071_3_11","MRK","3","11","11","Le'ec ca' ilbic a Jesus u menoo' a yan a c'ac'asba'al tu yoolo, walacoo' u c'ochol y xontal tu taan ala'aji. —Incheche, u Mejenech a Dioso,— cu t'anoo' ti chich. ");
INSERT INTO mopNT_vpl VALUES ("MK3_12","071_3_12","MRK","3","12","12","Le'ec a Jesusu, walac u tze'ecticoo'. —Ma' a wadique'ex mac winiquilen,— cu t'an ti'ijoo'. ");
INSERT INTO mopNT_vpl VALUES ("MK3_13","071_3_13","MRK","3","13","13","Pues te'i. Naq'ui a Jesus tuwich witz. Le'ec a jujun tuul u c'atiintaj cuchi u yocol ti'i u yaj cambala, u püyaj ca' talac etel. C'ochoo' etel. ");
INSERT INTO mopNT_vpl VALUES ("MK3_14","071_3_14","MRK","3","14","14","U yeetajoo' doce tuul ti'i ca' culacoo' etel, y ti'i ca' u tücaa'too' u yadoo' u t'an a Dioso, y ");
INSERT INTO mopNT_vpl VALUES ("MK3_15","071_3_15","MRK","3","15","15","ti'i ca' u tz'a'oo' u yanil ti'i u ch'anesicoo' a c'oja'ana, y ti'i u joc'sicoo' a c'ac'asba'al tu yool a maca. ");
INSERT INTO mopNT_vpl VALUES ("MK3_16","071_3_16","MRK","3","16","16","U yeetaj aj Simono. U tz'aj u c'aba' ti Pedro. ");
INSERT INTO mopNT_vpl VALUES ("MK3_17","071_3_17","MRK","3","17","17","U yeetajoo' ilic aj Jacob etel aj Juana. U yitz'inoo' u sucu'unoo' u bajil. Zebedeo u c'aba'oo' u tat. U tz'ajoo' u c'aba' a ca' tuul abe' ti aj Boanerges u men top chichoo' u t'an. —U mejenoo' chaac,— cu t'an a t'an abe'e. ");
INSERT INTO mopNT_vpl VALUES ("MK3_18","071_3_18","MRK","3","18","18","U yeetajoo' aj Andres, aj Felipe, aj Bartolome, aj Mateo, aj Tomas, y ulaac' aj Jacobo. Le'ec aj Jacob abe'e, le'ec u mejen aj Alfeojo. U yeetaj aj Tadeojo. U yeetaj ilic aj Simono. Cananista u c'aba' u na'at ala'aji. ");
INSERT INTO mopNT_vpl VALUES ("MK3_19","071_3_19","MRK","3","19","19","U yeetaj ilic aj Judas Iscarioteje. Le'ec ilic ala'aji, u tzolaj a Jesusu. Pues te'i. Ca' oqui a Jesus ich naj tuba tan u posado. ");
INSERT INTO mopNT_vpl VALUES ("MK3_20","071_3_20","MRK","3","20","20","Ca' much'lajoo' a cristiano te'i tucaye' asto ti ma' yan ma'ax u q'uinil ti janal a Jesus u yet'ocoo' u yaj cambal. ");
INSERT INTO mopNT_vpl VALUES ("MK3_21","071_3_21","MRK","3","21","21","U'yajbi c'u' a tan u manül ti'i a Jesus u men u familia. —Ma' qui' u pol,— cu t'anoo' tu bajil. Binoo' u müchü'. ");
INSERT INTO mopNT_vpl VALUES ("MK3_22","071_3_22","MRK","3","22","22","Pues te'i. C'ochoo' etel a Jesus u yaj ca'ansajil u ley aj Moises a taloo' ich caj Jerusalen. —Que'en tu yool a Jesus a quisini, le'ec u noochiloo' a c'ac'asba'ala, mentücü, patal u joq'ues a c'ac'asba'al tu yool a maca,— cu t'anoo' ala'oo'. ");
INSERT INTO mopNT_vpl VALUES ("MK3_23","071_3_23","MRK","3","23","23","Le'ec a Jesusu, u püyajoo' a cristiano tu tzeel. Caji ti t'an eteloo' ich mucult'an. —¿Biqui ca' joc'sabüc a quisin tu yool a mac u men ilic a quisin abe'e? Ma' yan biqui,— cu t'an a Jesusu. ");
INSERT INTO mopNT_vpl VALUES ("MK3_24","071_3_24","MRK","3","24","24","—Le'ec a gobierno tuba tz'iicoo' tu bajil a noochoo' u wichil u meyaja, jobol u ca'a jumpul a gobierno abe'e,— cu t'an a Jesusu. ");
INSERT INTO mopNT_vpl VALUES ("MK3_25","071_3_25","MRK","3","25","25","—Baalo' ilic etel a naja. Wa tz'iicoo' a cristiano tu bajiloo' te'iji, p'aatül u ca'a ti weca'anoo',— cu t'an a Jesusu. ");
INSERT INTO mopNT_vpl VALUES ("MK3_26","071_3_26","MRK","3","26","26","—Wa cuchi tz'iicaji a quisin tu bajil, y caji u loxo' u bajil, ma' tu paatal u betic a ma'ax c'u'iji. Jobol u ca'a,— cu t'an a Jesusu. ");
INSERT INTO mopNT_vpl VALUES ("MK3_27","071_3_27","MRK","3","27","27","—Ma' yan biqui u yocol a mac ichil u yotoch a mac a yaab u muc' ti'i u toco' c'u' a yan ti'i chen ti baalo'. Payanbej yan u c'üxic a yaab u muc'u. Pachili, jede'ec u paatal u yocol ichil u yotoch u toco' c'u' a yan te'iji,— cu t'an a Jesus ich mucult'an yoc'ol u joc'sic a mac tu c'ü' a quisini. ");
INSERT INTO mopNT_vpl VALUES ("MK3_28","071_3_28","MRK","3","28","28","—Pues te'i. Tan in wadic te'ex u jajil. Tulacal a boon p'eel u wich a sip'il a walacoo' u cüxtic a cristianojo, jede'ec u paatal u sa'tesabül ti'ijoo'o. Baalo' ilic etel a maclant'an a boon a walacoo' u yadiqui, jede'ec u paatal u sa'tesabül ti'ijoo'o,— cu t'an a Jesusu. ");
INSERT INTO mopNT_vpl VALUES ("MK3_29","071_3_29","MRK","3","29","29","—C'u' betiqui, mac ca' u maclant'ante u Püsüc'al a Dioso, ma' yan q'uin u sa'tesabül ti'i. Ala'aji, u cüxtaj u sip'il jumpul,— cu t'an a Jesusu. ");
INSERT INTO mopNT_vpl VALUES ("MK3_30","071_3_30","MRK","3","30","30","U yadaj abe' a Jesus u men le'ecoo' u yaj ca'ansajil u ley aj Moisese, u yadajoo' ti yan a c'ac'asba'al tu yool a Jesusu. ");
INSERT INTO mopNT_vpl VALUES ("MK3_31","071_3_31","MRK","3","31","31","Pues te'i. C'ochi u na' u yet'ocoo' u yitz'in a Jesusu. Wa'an ti que'enoo' pach naj. U tücaa'tajoo' ca' püybüc a Jesusu. ");
INSERT INTO mopNT_vpl VALUES ("MK3_32","071_3_32","MRK","3","32","32","Tina'an ti que'enoo' a cristiano tu xoy a Jesusu. —Que'en a na' u yet'ocoo' a witz'in pach naj. Tanoo' u c'aatic ca' xiquech eteloo',— cu t'anoo' ti'i a Jesusu. ");
INSERT INTO mopNT_vpl VALUES ("MK3_33","071_3_33","MRK","3","33","33","—¿Mac in na'? ¿Macoo' in witz'in ta t'ane'exe?— cu t'an a Jesus ti'ijoo'o. ");
INSERT INTO mopNT_vpl VALUES ("MK3_34","071_3_34","MRK","3","34","34","U laj cha'antajoo' a tina'anoo' tu tzeel. —Ile'ex in na'. Ile'exoo' in witz'in,— cu t'an a Jesusu. ");
INSERT INTO mopNT_vpl VALUES ("MK3_35","071_3_35","MRK","3","35","35","—Le'ec mac a walac u betic a jabix u c'ati a Dioso, le'ecoo' in na' in witz'in,— cu t'an a Jesusu. ");
INSERT INTO mopNT_vpl VALUES ("MK4_1","071_4_1","MRK","4","1","1","Pues te'i. Le'ec a Jesusu, que'en tucaye' tu chi' a lagunaja. Caji u ca'ansoo' a cristianojo. Mani tu pach u yaabil a cristiano a much'lajoo' etel, mentücü, oqui ichil a barco a que'en tuwich a ja'a. Tinlaji te'i ti ca'ansaj. Le'ecoo' a cristiano a much'a'anoo'o, que'enoo' tu chi' a ja'a. ");
INSERT INTO mopNT_vpl VALUES ("MK4_2","071_4_2","MRK","4","2","2","Yaab u yadaj a Jesus ti'ijoo'o, pero chen ich mucult'an. ");
INSERT INTO mopNT_vpl VALUES ("MK4_3","071_4_3","MRK","4","3","3","—U'yeene'ex. Jun tuul a winiqui, bini ti pac',— cu t'an ti'ijoo'. ");
INSERT INTO mopNT_vpl VALUES ("MK4_4","071_4_4","MRK","4","4","4","—Le'ec ti tan u pac'a, yan a semilla a c'axi tuwich bej. C'ochoo' a ch'iich'i. U molajoo' a semilla abe'e,— cu t'an a Jesusu. ");
INSERT INTO mopNT_vpl VALUES ("MK4_5","071_4_5","MRK","4","5","5","—Yan a püc'bi tuba ma' pim a lu'umu, yan a tunich yalama, Joq'ui ti jomol u men ma' pim a lu'umu,— cu t'an a Jesusu. ");
INSERT INTO mopNT_vpl VALUES ("MK4_6","071_4_6","MRK","4","6","6","—Le'ec ti chücüjaji a q'uini, wochmi u le' u men ma' yan u can,— cu t'an a Jesusu. ");
INSERT INTO mopNT_vpl VALUES ("MK4_7","071_4_7","MRK","4","7","7","—Yan a püc'bi tuba yan a jabix a c'ünchiimi. Le'ec ti tan u ch'iil a püc'aala, ch'iji ilic a jabix a c'ünchiimi. U c'ascuntaj a püc'aala,— cu t'an a Jesusu. ");
INSERT INTO mopNT_vpl VALUES ("MK4_8","071_4_8","MRK","4","8","8","—Yan a püc'bi ichil a lu'um a quich'pana. Qui' u ch'iil te'i. U tz'aj u wich. Yan u tz'aj treinta sut mas yaab tuwich a boon a püc'biji. Yan u tz'aj sesenta sut mas yaab. Yan u tz'aj cien sut mas yaab,— cu t'an a Jesusu. ");
INSERT INTO mopNT_vpl VALUES ("MK4_9","071_4_9","MRK","4","9","9","—Le'ec mac a patal u yubi in t'ana, yan u tz'eec tu yool,— cu t'an a Jesusu. ");
INSERT INTO mopNT_vpl VALUES ("MK4_10","071_4_10","MRK","4","10","10","Pues te'i. Le'ec ti que'en a Jesus tu junal eteloo' a doce tuul u yaj cambal y eteloo' u chucaan u yaj tz'ocsaj t'ana, u c'aatajoo' ti'i a Jesus yoc'ol a mucult'ana. ");
INSERT INTO mopNT_vpl VALUES ("MK4_11","071_4_11","MRK","4","11","11","—Tz'abi te'ex ca' a ch'a'e'ex u tojil biqui ti tan tun u tücaa' a Dioso. Ma' tz'abi abe' ti'ijoo' ulaac' a cristianoji, mentücü, chen ich mucult'an walac in t'an eteloo',— cu t'an a Jesusu. ");
INSERT INTO mopNT_vpl VALUES ("MK4_12","071_4_12","MRK","4","12","12","—Ti baalo'o, tu jajil tanoo' u cha'antic, pero ma' ta'achoo' u yilic. Tu jajil tanoo' u yubic, pero ma' ta'achoo' u ch'a'ic u tojil ma'ax u tz'eecoo' u yool tu pach a Dioso, y u sa'tesabüloo' u sip'il,— cu t'an a Jesusu. ");
INSERT INTO mopNT_vpl VALUES ("MK4_13","071_4_13","MRK","4","13","13","—Pues te'i. ¿Ma' wa tane'ex a ch'a'ic u tojil a mucult'an in wadaj ti'ijoo' a cristianojo? Wa ma' ta ch'a'ique'ex u tojil abe'e, ¿biqui ca' a ch'a'e'ex u tojil tulacal a mucult'ana?— cu t'an a Jesus ti'ijoo'o. ");
INSERT INTO mopNT_vpl VALUES ("MK4_14","071_4_14","MRK","4","14","14","—Le'ec a jabix aj pac'a, le'ec mac a tan u yadic u t'an a Dios ti'i ulaac' jabix cuchi tan u püq'uic a semilla te'iji,— cu t'an a Jesusu. ");
INSERT INTO mopNT_vpl VALUES ("MK4_15","071_4_15","MRK","4","15","15","—Le'ec a jabix a semilla a c'axi ti beje, le'ec abe' a cristiano u yubajoo' u t'an a Dioso. Jadi' u yubajoo' ti c'ochi a quisin u tz'aa' ti'ijoo' ca' tubuc ti'ijoo' u t'an Dios jabix cuchi tan u toquic u t'an Dios a aalbi ti'ijoo'o,— cu t'an a Jesusu. ");
INSERT INTO mopNT_vpl VALUES ("MK4_16","071_4_16","MRK","4","16","16","—Le'ec a jabix a semilla a püc'bi tuba ma' pim a lu'um u men a tunich yalama, le'ec abe' jabix a cristiano u yubajoo' u t'an a Dioso. Tu jomolil u c'ümajoo' u t'an. Qui'oo' u yool,— cu t'an a Jesusu. ");
INSERT INTO mopNT_vpl VALUES ("MK4_17","071_4_17","MRK","4","17","17","—C'u' betiqui, jabix ilic ti ma' yan u can a püc'aal a püc'bi tuba ma' pim a lu'um u men a tunich yalama, baalo' ilic ala'oo'o. Jadi' tz'etz'eec walacoo' u tz'ocsiqui. Le'ec ca' yanac a yaja, wa ca' tz'abüc ti'ijoo' a yaj u men in t'ana, jomol u p'üticoo' u tz'ocsic in t'an,— cu t'an a Jesusu. ");
INSERT INTO mopNT_vpl VALUES ("MK4_18","071_4_18","MRK","4","18","18","—Le'ec a jabix a semilla a püc'bi tuba yan a jabix a c'ünchiimi, le'ec abe' jabix a mac u yubajoo' u t'an a Dioso,— cu t'an a Jesusu. ");
INSERT INTO mopNT_vpl VALUES ("MK4_19","071_4_19","MRK","4","19","19","—Top que'enoo' u yool tu pach a jabix a c'u' a ti'i a yoc'olcaba. Top qui'oo' u yool etel u ayic'alil. Top jac'oo' ti'i a ba'al a ma' ti'i a Dioso. U men abe'e, tan u joc'ol ti'ijoo' ti ma'ax c'u' ti qui'il a jabix u c'ati a Dios a tan u yantal ti'ijoo'o,— cu t'an a Jesusu. ");
INSERT INTO mopNT_vpl VALUES ("MK4_20","071_4_20","MRK","4","20","20","—Le'ec a jabix a semilla a püc'bi tuba quich'pan a lu'umu, le'ec abe' jabix a mac u yubajoo' u t'an a Dioso. U c'ümajoo'. Ti'i ala'oo'o, walac u yantal a qui'ili. Tan u yantal u qui'il jabix a püc'aal a tan u tz'eec u wich a treinta cuulu, wa a sesenta cuulu, wa a cien cuulu,— cu t'an a Jesusu. ");
INSERT INTO mopNT_vpl VALUES ("MK4_21","071_4_21","MRK","4","21","21","—Pues te'i. Ma' ta'ach u t'übbül a c'aac' ti'i u tz'abül yalam a cajono, ma'ax ti'i u tz'abül yalam cama. Walac u t'übbül a c'aac' ti'i u tz'abül tu cuuchil,— cu t'an a Jesusu. ");
INSERT INTO mopNT_vpl VALUES ("MK4_22","071_4_22","MRK","4","22","22","—Ma' yan a ba'al a muca'an a wa ma' bel u ca'a ti chictal pachili. Baalo' ilic a t'an a muca'ana, bel u ca'a u'yajbül pachil,— cu t'an a Jesusu. ");
INSERT INTO mopNT_vpl VALUES ("MK4_23","071_4_23","MRK","4","23","23","—Le'ec mac patal u yubi in t'ana, yan u tz'eec tu yool,— cu t'an a Jesusu. ");
INSERT INTO mopNT_vpl VALUES ("MK4_24","071_4_24","MRK","4","24","24","—Tz'aje'ex ta wool c'u' a tane'ex a wu'yiqui. Le'ec boon a walaque'ex a tz'eec ti'i ulaac'a, baalo' ilic bel u ca'a tz'abül te'ex u jel. Bel ilic u ca'a tz'abül te'ex u chucaan xan,— cu t'an a Jesusu. ");
INSERT INTO mopNT_vpl VALUES ("MK4_25","071_4_25","MRK","4","25","25","—Le'ec mac u c'ümaj a jaja, bel u ca'a tz'abül ti'i ti mas yaab ca' u yeelte a jaja. P'aatül u ca'a ti yaab a jaj u yeele. Le'ec mac a ma' u c'ümaj a jaja, bel u ca'a tocbol ti'i boon a jaj u yeele,— cu t'an a Jesusu. ");
INSERT INTO mopNT_vpl VALUES ("MK4_26","071_4_26","MRK","4","26","26","—Pues te'i. Le'ec biqui ti walac u tücaa' a Dioso, le'ec jabix a winic u püc'aj u col,— cu t'an a Jesusu. ");
INSERT INTO mopNT_vpl VALUES ("MK4_27","071_4_27","MRK","4","27","27","—Ti ac'ü' tan u wüyül a winiqui. Ti q'uin p'ixa'an. Ma' tan u tuclic biqui ti walac u ch'iil a semillaja. Chen walac u joc'ol u yoc a semillaja. Walac u ch'iil. A winiqui, ma' u yeel biqui,— cu t'an a Jesusu. ");
INSERT INTO mopNT_vpl VALUES ("MK4_28","071_4_28","MRK","4","28","28","—Walac u ch'iil u men a lu'umu. Payanbej u joc'ol u yoc, ca' tun u top', y tu yada' u joc'ol u wich,— cu t'an a Jesusu. ");
INSERT INTO mopNT_vpl VALUES ("MK4_29","071_4_29","MRK","4","29","29","—Le'ec ti tiquin u wich a püc'aala, tu jomolil walac u tücaa'bül aj jochoo' u men a winiqui, u men c'ochi u q'uinil a jocho,— cu t'an a Jesus ich mucult'an yoc'ol biqui ti walac u tücaa' a Dioso. ");
INSERT INTO mopNT_vpl VALUES ("MK4_30","071_4_30","MRK","4","30","30","—Pues te'i. ¿C'u' a qui' ca' in wadü' ti'i ca' chiclac biqui ti walac u tücaa' a Dioso? Le'ec a mucult'an ada' a c'üs quet etele,— cu t'an a Jesusu. ");
INSERT INTO mopNT_vpl VALUES ("MK4_31","071_4_31","MRK","4","31","31","—Le'ec biqui ti walac u tücaa' a Dioso, c'üs quet etel jun cuul u nec' ix mostazaja. Le'ec ti tan u püc'bül ix mostazaja, mas tz'itz'i' tuwich u chucaan a püc'aala,— cu t'an a Jesusu. ");
INSERT INTO mopNT_vpl VALUES ("MK4_32","071_4_32","MRK","4","32","32","—C'u' betiqui, le'ec ti püc'a'ana, walac u ch'iil asto ti mas nooch tuwich u chucaan a püc'aala. Nooch u c'ü'. Le'ecoo' a ch'iich'i, walacoo' u betic u c'u' yalam u bo'oy,— cu t'an a Jesusu. ");
INSERT INTO mopNT_vpl VALUES ("MK4_33","071_4_33","MRK","4","33","33","Pues te'i. Yaab a muculta'an a jabix abe' u yadaj a Jesus ti tan u yadic u t'an a Dios ti'ijoo' a cristianojo. Jadi' u yadaj a boon a jede'ec cuchi u paataloo' u yubiji. ");
INSERT INTO mopNT_vpl VALUES ("MK4_34","071_4_34","MRK","4","34","34","Ma'ax c'u' u yadaj ti'ijoo' wa ma' ich mucult'an. Le'ec ti que'en tu junal eteloo' u yaj cambala, u yadaj u nu'cul tulacal a mucult'an ti'ijoo'o. ");
INSERT INTO mopNT_vpl VALUES ("MK4_35","071_4_35","MRK","4","35","35","Pues te'i. Oqui a q'uin ti'i ilic a q'uin abe'e. —Co'ne'ex tac junxeel a lagunaja,— cu t'an a Jesus ti'ijoo' u yaj cambala. ");
INSERT INTO mopNT_vpl VALUES ("MK4_36","071_4_36","MRK","4","36","36","Le'ecoo' u yaj cambala, u p'ütajoo' a cristiano a much'a'anoo' te'i chi' ja'. Ocoo' ichil a barco tuba que'en a Jesusu. Binoo'. Binoo' ilic tu pach a barco abe' ma' eela'an boon cuul ulaac' a barcojo. ");
INSERT INTO mopNT_vpl VALUES ("MK4_37","071_4_37","MRK","4","37","37","Caji a ic' a top chich ti'ijoo' taan a lagunaja. Top tz'iic a ja'a. Caji ti ocol a ja' ichil a barcojo. Caji ti tudel. ");
INSERT INTO mopNT_vpl VALUES ("MK4_38","071_4_38","MRK","4","38","38","Pues te'i. Tan u wüyül a Jesus tu jo'ol a barcojo. Que'en u pol tuwich jun p'eel c'aampol. Lic'sabi u menoo' u yaj cambal. —Maestro, ¿ma'ax c'u'i wa tech ti watac ti quimil?— cu t'anoo' ti'i a Jesusu. ");
INSERT INTO mopNT_vpl VALUES ("MK4_39","071_4_39","MRK","4","39","39","Liq'ui a Jesusu. U yadaj ti'i a ic' y a ja' ca' jetz'lac. —Ma' peec. Etz'len,— cu t'an. Mani a iq'ui. Etz'laji a ja' tu jajil. ");
INSERT INTO mopNT_vpl VALUES ("MK4_40","071_4_40","MRK","4","40","40","—¿C'u' ca'a saaque'ex? Top ma' que'ene'ex a wool tu pach a Dios tu jajili,— cu t'an a Jesus ti'ijoo'o. ");
INSERT INTO mopNT_vpl VALUES ("MK4_41","071_4_41","MRK","4","41","41","Saacoo' tu jajil. —¿C'u' tun ti winiquil a jabix ada'a? Ca'ax ic' ca'ax ja', walac u tz'ocsabül ala'aji,— cu t'anoo' tu bajil. ");
INSERT INTO mopNT_vpl VALUES ("MK5_1","071_5_1","MRK","5","1","1","Pues te'i. C'ochi a Jesus u yet'ocoo' u yaj cambal junxeel a laguna tu cuenta Gadaraja. ");
INSERT INTO mopNT_vpl VALUES ("MK5_2","071_5_2","MRK","5","2","2","Le'ec ti joq'ui a Jesus ichil a barcojo, c'ümbi u men a winic a joq'ui tuba walacoo' u mucbul a quimene. Yan a c'ac'asba'al tu yool. ");
INSERT INTO mopNT_vpl VALUES ("MK5_3","071_5_3","MRK","5","3","3","Walac u cuntal tuba muca'anoo' a quimene. Ma'ax mac patal u c'üxü' ala'aji, ma'ax etel cadena. ");
INSERT INTO mopNT_vpl VALUES ("MK5_4","071_5_4","MRK","5","4","4","Yaab sut c'üxbi tu c'ü' tu yoc etel cadena u menoo' a cristianojo. C'u' betiqui, chen u t'upaj a cadena abe' a que'en tu c'ü' y tu yoc. Ma'ax mac a chucul u muc' u muc'yajte u muc' a winic abe'e. ");
INSERT INTO mopNT_vpl VALUES ("MK5_5","071_5_5","MRK","5","5","5","Ti q'uin ti ac'ü' walac u manül ala'i tuba muca'anoo' a quimen y tuwich witz. Walac u yawat. Walac u xotic u bajil etel tunich. ");
INSERT INTO mopNT_vpl VALUES ("MK5_6","071_5_6","MRK","5","6","6","Pues te'i. Naach to que'en ala'aji, le'ec ca' u yilaj a Jesusu. Alca' ti c'ochi etel. Xonlaji tu taan. ");
INSERT INTO mopNT_vpl VALUES ("MK5_7","071_5_7","MRK","5","7","7","—Jesus, c'u' a t'an ten. Inchech u Mejen a Dios ti ca'an a top nooch u yanil. Etel u c'aba' a Dios tan in wadic tech. Ma' a tz'eec ten a yaja,— cu t'an ti'i a Jesus ti chich. ");
INSERT INTO mopNT_vpl VALUES ("MK5_8","071_5_8","MRK","5","8","8","U yadaj abe' u men aalbi ti'i u men a Jesusu: —Incheche, c'ac'asba'alech. Joq'uen tu yool a winiqui,— cu t'an a Jesus ti'iji. ");
INSERT INTO mopNT_vpl VALUES ("MK5_9","071_5_9","MRK","5","9","9","—¿Mac a c'aba' incheche?— cu t'an a Jesus ti'i a c'ac'asba'ala. —Le'ec in c'aba' inene, jun muuch' u men top yaabo'on tiqui bajil,— cu t'an ti'i a Jesusu. ");
INSERT INTO mopNT_vpl VALUES ("MK5_10","071_5_10","MRK","5","10","10","U c'aataj ti'i a Jesus tulacal u yool ti ma' u tolbol pach caj. ");
INSERT INTO mopNT_vpl VALUES ("MK5_11","071_5_11","MRK","5","11","11","Pues te'i. Nütz'a'an que'enoo' a eq'uen a tanoo' u janal tuwich witz. ");
INSERT INTO mopNT_vpl VALUES ("MK5_12","071_5_12","MRK","5","12","12","Le'ecoo' a c'ac'asba'ala, u c'aatajoo' ti'i a Jesusu. —Tücaa'to'on ca' ococo'on tu yaamoo' a eq'uen ado'o,— cu t'anoo' ti'i. ");
INSERT INTO mopNT_vpl VALUES ("MK5_13","071_5_13","MRK","5","13","13","U cha'aj ca' xicoo' te'i. Joc'oo' a c'ac'asba'al ichil u yool a winiqui. Binoo' tu yaam a eq'uene. Jabix wal dos mil tuul ti eq'uen a yan te'iji. Joc'oo' ti alca' ti chich a eq'uene. Emoo' tuba c'üs toj wa'an a witzi. Ocoo' ichil a ja'a. Jüc'moo' te'i. Quimoo'. ");
INSERT INTO mopNT_vpl VALUES ("MK5_14","071_5_14","MRK","5","14","14","Pues te'i. Le'ecoo' a winic a tanoo' u cününtic a eq'uene, joc'oo' ti alca'. U yadajoo' ich caj ich aldea c'u' a mani chi' a ja'a. C'ochoo' a cristiano u yila' c'u' a maniji. ");
INSERT INTO mopNT_vpl VALUES ("MK5_15","071_5_15","MRK","5","15","15","C'ochoo' etel a Jesusu. U yilajoo' a winic a joc'oo' a c'ac'asba'al ichil u yoolo. Tina'an ti que'en ala'aji. Yan a noc' yoc'ol. Toj u yool a winic abe' a yanoo' a c'ac'asba'al tu yool biq'uin ado'o. Jac'oo' u yool a cristianojo. ");
INSERT INTO mopNT_vpl VALUES ("MK5_16","071_5_16","MRK","5","16","16","Le'ecoo' u yilaj c'u' a maniji, u yadajoo' ti'i a cristiano c'u' a mani ti'i a winic a yanoo' a c'ac'asba'al tu yool biq'uin ado'o. U yadajoo' ilic c'u' a mani ti'ijoo' a eq'uene. ");
INSERT INTO mopNT_vpl VALUES ("MK5_17","071_5_17","MRK","5","17","17","Le'ecoo' a cristianojo, cajoo' u yadü' ti'i a Jesus ca' joc'oc tu caaloo'. ");
INSERT INTO mopNT_vpl VALUES ("MK5_18","071_5_18","MRK","5","18","18","Tan to u yocol ich barco a Jesusu. —In c'ati cuchi beel ta pach,— cu t'an a winic a joc'saboo' a c'ac'asba'al tu yool ti'i a Jesusu. ");
INSERT INTO mopNT_vpl VALUES ("MK5_19","071_5_19","MRK","5","19","19","Le'ec a Jesusu, ma' u cha'aj a winic ca' xi'ic tu pacha. —Ca' xiquech ta wotoch tuba que'enoo' a wet'oc. Adü ti'ijoo' boon a qui'il u betaj tech a Noochtzili, y biqui ti ca' u ch'a'aj a wotzilili,— cu t'an a Jesus ti'iji. ");
INSERT INTO mopNT_vpl VALUES ("MK5_20","071_5_20","MRK","5","20","20","Bini a winiqui. Tulacal tuba ichil a diez p'eel ti caj caji u yadü' boon a qui' a betabi ti'i u men a Jesusu. Sa'too' u yool boon tuul u yubajoo' u t'an. ");
INSERT INTO mopNT_vpl VALUES ("MK5_21","071_5_21","MRK","5","21","21","Pues te'i. Usc'aji a Jesus junxeel a laguna tucaye' ichil a barcojo. Que'en a Jesus ti lu'um chi' ja' ti much'lajoo' ti yaab a cristiano tu tzeele. ");
INSERT INTO mopNT_vpl VALUES ("MK5_22","071_5_22","MRK","5","22","22","Pues te'i. Jun tuul a winiqui, aj Jairo u c'aba'. Ala'aji, walac u tücaa' ichil a naj tuba walacoo' u much'tal a cristiano u c'ajes a Dios te'iji. C'ochi a winic abe' etel a Jesusu. Le'ec ca' u yilaj a Jesusu, xonlaji tu taan. ");
INSERT INTO mopNT_vpl VALUES ("MK5_23","071_5_23","MRK","5","23","23","—Yan jun tuul in wix chu'. Watac u quimil. Co'ox tin pach. Tz'a a c'ü' yoc'ol ti'i ca' ch'anüc ti'i ma' u quimil,— cu t'an ti'i a Jesusu. ");
INSERT INTO mopNT_vpl VALUES ("MK5_24","071_5_24","MRK","5","24","24","Bini tu pach a winiqui. Tücünacoo' ilic u yaabil a cristiano tu pach a Jesusu. Tanoo' u nüt'ic u bajil ti tanoo' u beel. ");
INSERT INTO mopNT_vpl VALUES ("MK5_25","071_5_25","MRK","5","25","25","Pues te'i. Jun tuul ix ch'upu, doce jaab tan ti tan u joc'ol u q'uiq'uel le'ec u uju. ");
INSERT INTO mopNT_vpl VALUES ("MK5_26","071_5_26","MRK","5","26","26","Yaab a yaj u c'ümaj u menoo' aj ilmaj ti tan u yaaltabül tz'ücbül. U sütaj tulacal u taq'uin eteloo', y ma' ch'ani. Jadi' mas chichaji u c'oja'anil. ");
INSERT INTO mopNT_vpl VALUES ("MK5_27","071_5_27","MRK","5","27","27","U yubaj c'u' a walac u betic a Jesusu. U mucaj u bajil tu yaamoo' a cristiano ti tan u c'ochol tu pach a Jesus ti ma' u yilbil. U tülaj u noc' a Jesusu. ");
INSERT INTO mopNT_vpl VALUES ("MK5_28","071_5_28","MRK","5","28","28","U betaj abe' u men u tuclaj ti jadi' yan u tülic u chi' u noc' a Jesus ti'i ca' ch'anüc. ");
INSERT INTO mopNT_vpl VALUES ("MK5_29","071_5_29","MRK","5","29","29","Tu seebal weet'i u joc'ol u q'uiq'uel. Chen u yubaj ichil u bajil ti ch'ani. ");
INSERT INTO mopNT_vpl VALUES ("MK5_30","071_5_30","MRK","5","30","30","Pues te'i. Le'ec a Jesusu, u yubaj ichil u bajil ti ch'ani a mac etel ilic u muc' ala'aji. Que'en ala'i tu yaamoo' u yaabil a cristianojo. Tu seebal u sutaj u bajil. —¿Mac u tülaj in noc'?— cu t'an a Jesusu. ");
INSERT INTO mopNT_vpl VALUES ("MK5_31","071_5_31","MRK","5","31","31","—¿Ma' wa tan a wilicoo' u yaabil a cristiano a tanoo' u nüt'iquech? ¿C'u' ca'a tan a wadic: “¿Mac u tülajen?”?— cu t'anoo' u yaj cambal ti'iji. ");
INSERT INTO mopNT_vpl VALUES ("MK5_32","071_5_32","MRK","5","32","32","Tan u cha'anticoo' a cristiano a Jesus u yila' mac u tülaj u noc'. ");
INSERT INTO mopNT_vpl VALUES ("MK5_33","071_5_33","MRK","5","33","33","Le'ec a nooch'upu, u yeel ti ch'anesabi u men a Jesusu. Tzützülnac u men u saaquil ti c'ochi tu taan. Xonlaji te'i. U yadaj ti'i u jajil tulacal c'u' u betaja. ");
INSERT INTO mopNT_vpl VALUES ("MK5_34","071_5_34","MRK","5","34","34","—Nooch'up, a tz'ocsaj ti patalen in ch'aneseech, mentücü, ch'aneech tun. Jetz'cunte a wool y usq'uen. Ma' ta ca' c'ümic a c'oja'anil abe' tucaye',— cu t'an a Jesus ti'iji. ");
INSERT INTO mopNT_vpl VALUES ("MK5_35","071_5_35","MRK","5","35","35","Pues te'i. Tan to u t'an a Jesus ti'i ti c'ochoo' a winic a taloo' tu yotoch aj Jairojo. —Quimi tun a mejen. Ma' a mas tuc'sic u yool a bensic ta pach a Maestrojo,— cu t'anoo' ti'i aj Jairojo. ");
INSERT INTO mopNT_vpl VALUES ("MK5_36","071_5_36","MRK","5","36","36","Le'ec a Jesusu, ma' u tz'aj tu yool c'u' u yadajoo' ti'i aj Jairojo. —Ma' u jac'ül a wool yoc'oloo' u t'an. Tz'a a wool tin pach,— cu t'an ti'i aj Jairojo. ");
INSERT INTO mopNT_vpl VALUES ("MK5_37","071_5_37","MRK","5","37","37","Ma' u cha'aj ma'ax mac ca' xi'ic etel. Aj Pedro, aj Jacob etel aj Juana, jadi' u cha'aj ca' xi'ic tu pach tu yotoch aj Jairojo. Le'ec aj Juan etel aj Jacobo, u yitz'inoo' u sucu'unoo' u bajil. ");
INSERT INTO mopNT_vpl VALUES ("MK5_38","071_5_38","MRK","5","38","38","C'ochoo' tu yotoch aj Jairojo. Le'ec a Jesusu, u yilaj ti tanoo' u choconaquil. Le'ecoo' a cristianojo, tanoo' u yoc'ol. Tanoo' u yoc'tic a quimen ti chichi. ");
INSERT INTO mopNT_vpl VALUES ("MK5_39","071_5_39","MRK","5","39","39","Oqui a Jesus ich naj. —¿C'u' ca'a tane'ex a choconaquil? ¿C'u' ca'a tane'ex a woc'ol? Ma' quimen a tz'ubi. Chen tan u wüyül,— cu t'an a Jesus ti'ijoo' a cristianojo. ");
INSERT INTO mopNT_vpl VALUES ("MK5_40","071_5_40","MRK","5","40","40","U che'ejtajoo' a Jesusu. Joc'saboo' pach naj u men a Jesusu. U püyajoo' u na' u tat a tz'ubu, u yet'ocoo' a ox tuul u yaj cambala. Ocoo' tuba que'en a quimene. ");
INSERT INTO mopNT_vpl VALUES ("MK5_41","071_5_41","MRK","5","41","41","U müchaj a tz'ub tu c'ü'. —Talita cumi,— cu t'an ti'i ichil ilic u t'an. —Tz'i' chu', tan in wadic tech. Liq'uen,— cu t'an a t'an abe'e. ");
INSERT INTO mopNT_vpl VALUES ("MK5_42","071_5_42","MRK","5","42","42","Tu seebal liq'ui ix chu'u. Caji ti ximbal. Doce jaab yan ti'i. Sa'too' u yool tu jajil u na' u tata. ");
INSERT INTO mopNT_vpl VALUES ("MK5_43","071_5_43","MRK","5","43","43","U yadaj ti'ijoo' tu jajil ti ma' u tz'eecoo' ti eeltabül c'u' a mani te'iji. U yadaj ilic ti'ijoo' ca' u tzeente a tz'ubu. ");
INSERT INTO mopNT_vpl VALUES ("MK6_1","071_6_1","MRK","6","1","1","Pues te'i. Le'ec a Jesusu, joq'ui te'i. Bini tu caal u yet'ocoo' u yaj cambal. ");
INSERT INTO mopNT_vpl VALUES ("MK6_2","071_6_2","MRK","6","2","2","Tu q'uinil a jedele, caji u ca'ansoo' a cristiano te'i ichil a naj tuba walacoo' u much'tal u c'ajes a Dioso. Yaab mac u yubajoo' u t'an a Jesus te'iji. Sa'too' u yool. —Le'ec a winic ada'a, ¿tuba u cünaj c'u' a tan u ye'iqui? ¿C'u' u wich u patalil a tz'abi ti'iji? ¿Biqui ti walac u betic a milagrojo?— cu t'anoo' a cristiano tu bajili. ");
INSERT INTO mopNT_vpl VALUES ("MK6_3","071_6_3","MRK","6","3","3","—¿Ma' wa le'ec ala'i aj carpinterojo? Ma' wa le'ec ala'i u yal ixna' Mariaja? ¿Ma' wa le'ec ala'i u sucu'unoo' aj Jacob, aj Jose, aj Judas y aj Simono? ¿Ma' wa culajoo' u yix ch'upulitz'in tiqui yaam?— cu t'anoo' a cristiano tu bajili. Ma' c'ocha'anoo' tu wich ti top patal a Jesusu. ");
INSERT INTO mopNT_vpl VALUES ("MK6_4","071_6_4","MRK","6","4","4","—Le'ec a tz'abi u yanil u yadü' u t'an a Dioso, walac u tz'ocsabül u yanil ca'ax tubajac. C'u' betiqui, ichil u caal wa tu yaamoo' u yet'oc wa xan ichil ilic u yotoch, ma' ta'ach u tz'ocsabül u yanil,— cu t'an a Jesus ti'ijoo'o. ");
INSERT INTO mopNT_vpl VALUES ("MK6_5","071_6_5","MRK","6","5","5","Ma' yan biqui u betic a milagro te'iji. Jadi' u tz'aj u c'ü' yoc'ol jabix wal ox tuul wa cuatro tuul a c'oja'ana, y u ch'anesajoo'. ");
INSERT INTO mopNT_vpl VALUES ("MK6_6","071_6_6","MRK","6","6","6","Sa'ti u yool a Jesus u men top ma' ta'achoo' u tz'ocsic u t'an. Joq'ui te'i. Tan u manül ich aldea u ca'ansoo' a cristianojo. ");
INSERT INTO mopNT_vpl VALUES ("MK6_7","071_6_7","MRK","6","7","7","Pues te'i. Le'ec a Jesusu, u püyajoo' a doce tuul u yaj cambal tu tz'eele. Ca'ca' tuulil tu bajiloo' ti bel u cu tücaa'too' ti t'an. U tz'aj ti'ijoo' u patalil ti'i ca' u joq'ueseoo' a c'ac'asba'al tu yool a maca. ");
INSERT INTO mopNT_vpl VALUES ("MK6_8","071_6_8","MRK","6","8","8","—Ma' a bensique'ex a ma'ax c'u'i ti tane'ex a beele. Jadi' qui' a bensique'ex a xoolte'. Ma' a bensique'ex a janala, ma'ax a ba'aya, ma'ax a taq'uin ichil u cuchbeeb,— cu t'an a Jesus ti'ijoo' u yaj cambala. ");
INSERT INTO mopNT_vpl VALUES ("MK6_9","071_6_9","MRK","6","9","9","—Tz'a'e'ex a zapato, pero ma' a bensique'ex ulaac' a noc',— cu t'an a Jesus ti'ijoo'o. ");
INSERT INTO mopNT_vpl VALUES ("MK6_10","071_6_10","MRK","6","10","10","—Le'ec tuba ca' ocoque'ex ti posado, te'i ilic yane'ex a cuntal. Le'ec ti jobe'ex a meyaj ichil a caja, ichil ilic a naj abe' a joc'ole'ex,— cu t'an a Jesus ti'ijoo'o. ");
INSERT INTO mopNT_vpl VALUES ("MK6_11","071_6_11","MRK","6","11","11","—Le'ec tuba ma' u c'atoo' u tz'a'e'ex a posadojo, ma'ax u c'atoo' u yubi a t'ane'exe, joq'uene'ex te'i. Le'ec ti tane'ex a joc'ol, liijte'ex u ta'lu'umil a woc ca' c'axüc. Le'ec abe' u p'is ti ma' qui' u betajoo' te'exe. Tan in wadic te'ex u jajil. Le'ec ca' c'ochoc u q'uinil u tz'abül sip'il, mas yaj tu tz'abüloo' u sip'il ichil a caj abe' tuwich u tz'abüloo' u sip'il a c'ac'as cristiano ichil a uchben caj Sodoma a caj Gomorraja,— cu t'an a Jesusu. ");
INSERT INTO mopNT_vpl VALUES ("MK6_12","071_6_12","MRK","6","12","12","Pues te'i. Binoo' a doce tuulu. U yadajoo' ti'i a cristiano ca' u jeloo' u tucul ca' u tucloo' a quich'pan tuculu. ");
INSERT INTO mopNT_vpl VALUES ("MK6_13","071_6_13","MRK","6","13","13","U joc'sajoo' a c'ac'asba'al tu yool a yaaba. U tz'ajoo' u c'a' olivo yoc'ol a c'oja'an a yaaba, y u ch'anesajoo'. ");
INSERT INTO mopNT_vpl VALUES ("MK6_14","071_6_14","MRK","6","14","14","Pues te'i. Le'ec aj Herodese, rey. U yubaj c'u' a tan u betic a Jesusu, u men tan u tzicbalbül ca'ax tubajac. —Le'ec a Jesusu, le'ec ilic aj Juan aj tz'aj ocja'a. Ca' cuxquinbi tu yaam a quimene, mentücü, yan u muc' u bete' a milagrojo,— cu t'an aj Herodese. ");
INSERT INTO mopNT_vpl VALUES ("MK6_15","071_6_15","MRK","6","15","15","Yanoo' ulaac' a tanoo' u yadic ti le'ec a Jesusu, le'ec ilic aj Eliasa, le'ec jun tuul u yadaj u t'an a Dios uchi. Yanoo' ulaac' a tanoo' u yadic ti le'ec a Jesusu, jun tuul a tan u yadic u t'an a Dios jabix ilic u yadajoo' u t'an a Dios a uchben cristianojo. ");
INSERT INTO mopNT_vpl VALUES ("MK6_16","071_6_16","MRK","6","16","16","C'u' betiqui, ca' u yubaj c'u' a tan u betic a Jesus aj Herodese, u yadaj: —Le'ec abe' aj Juan aj tz'aj ocja'a. Inen in ch'ücaj u cal, pero ca' cuxlaji tucaye',— cu t'an aj Herodese. ");
INSERT INTO mopNT_vpl VALUES ("MK6_17","071_6_17","MRK","6","17","18","Pues te'i. Baala' u betaj aj Herodes ti'i aj Juan biq'uin ado'o. Le'ec aj Herodese, u ch'a'aj ixna' Herodiasa. U yütan aj Felipe abe'e. Aj Felipeje, u yitz'in aj Herodese. —Ma' qui' a ch'a'ic a mu',— cu t'an aj Juan ti'iji, mentücü, u tücaa'taj müchbül. Tz'abi ti presojil. ");
INSERT INTO mopNT_vpl VALUES ("MK6_19","071_6_19","MRK","6","19","19","U men u yadaj ti baalo' aj Juana, tz'iic ixna' Herodias etele. U c'atiintaj cuchi u quimes aj Juana, pero ma' yan biqui, ");
INSERT INTO mopNT_vpl VALUES ("MK6_20","071_6_20","MRK","6","20","20","u men saac aj Herodes ti'i aj Juana. Aj Herodese, u yeel ti toj u na'at aj Juana. U yeel ilic ti jun tuul u yaj meyaj a Dios ala'aji, mentücü, ma' u cha'aj ca' yajcunbuc aj Juan u men ixna' Herodiasa. Aj Herodese, top walac u caal u tucle u sip'il ti tan u yubic u t'an aj Juana. Ca'ax walac u tuclic u sip'il, top qui' tu xiquin u yubi u t'an aj Juana. ");
INSERT INTO mopNT_vpl VALUES ("MK6_21","071_6_21","MRK","6","21","21","Pues te'i. Baala' ti yanaji biqui ca' u quimes aj Juan ixna' Herodiasa. C'ochi u q'uinc'aba' aj Herodese. U betaj a fiestaja. Püyboo' ca' talacoo' ti fiesta a nucuch winic a walacoo' u tücaa' ich cuenta Galilea u yet'ocoo' u noochiloo' a soldado eteloo' a nucuch ayic'aloo' ich cuenta Galilea. ");
INSERT INTO mopNT_vpl VALUES ("MK6_22","071_6_22","MRK","6","22","22","Uchi u yoc'ot u yal ixna' Herodias tu taanoo' a much'a'anoo' te'iji. Qui' u yool aj Herodes etel biqui ti uchi u yoc'ot. Qui'oo' ilic u yool u yaj sutiloo'. —C'aate ten c'u' a c'ati. Jede'ec in tz'eec tech,— cu t'an a rey ti'i ix chu' abe'e. ");
INSERT INTO mopNT_vpl VALUES ("MK6_23","071_6_23","MRK","6","23","23","U tz'aj u t'an ti'i ix chu'u. —C'aate ten le'ec a c'u' a c'atiji. Jede'ec in tz'eec tech asto ti jun jatz in ayic'alil,— cu t'an aj Herodes ti'iji. ");
INSERT INTO mopNT_vpl VALUES ("MK6_24","071_6_24","MRK","6","24","24","Pues te'i. Bini ix chu' u c'aate ti'i u na'. —¿C'u' a qui' ca' in c'aate?— cu t'an ti'i u na'. —C'aate ca' ch'ücbüc u cal aj Juan aj tz'aj ocja' ca' tz'abüc tech u pol,— cu t'an u na' ti'iji. ");
INSERT INTO mopNT_vpl VALUES ("MK6_25","071_6_25","MRK","6","25","25","Tu seebal ca' usc'aji ix chu' abe' etel aj Herodese. —In c'ati cuchi ca' a tz'aa' ten aleebili tuwich noxi' plato u pol aj Juan aj tz'aj ocja',— cu t'an ix chu' ti'iji. ");
INSERT INTO mopNT_vpl VALUES ("MK6_26","071_6_26","MRK","6","26","26","Top yajaji u yool a reye. C'u' betiqui, chen u men u tz'aj u t'an tu taanoo' u yaj sutil, ma' u c'ati u jele' u t'an ti'i ix chu' abe'e. ");
INSERT INTO mopNT_vpl VALUES ("MK6_27","071_6_27","MRK","6","27","27","Tu seebal u tücaa'taj jun tuul a soldado le'ec a walac u cününtic a te'iji, ti'i ca' u tales u pol aj Juana. Bini a soldadojo. U ch'ücaj u cal aj Juan ich preso. ");
INSERT INTO mopNT_vpl VALUES ("MK6_28","071_6_28","MRK","6","28","28","U talesaj u pol aj Juan tuwich noxi' plato. U tz'aj ti'i ix chu'u. Le'ec ix chu'u, u tz'aj ti'i u na'. ");
INSERT INTO mopNT_vpl VALUES ("MK6_29","071_6_29","MRK","6","29","29","Le'ecoo' u yaj cambal aj Juana, u yubajoo' c'u' a betabi ti'iji. C'ochoo' tuba que'en. U ch'a'ajoo' u büq'uel. U mucajoo'. ");
INSERT INTO mopNT_vpl VALUES ("MK6_30","071_6_30","MRK","6","30","30","Pues te'i. Le'ecoo' u yaj xa'num a Jesusu, joboo' u betic u xa'num. Usc'ajoo' etel a Jesusu. U yadajoo' ti'i a Jesus tulacal a c'u' u betajoo' y u ye'ajoo'. ");
INSERT INTO mopNT_vpl VALUES ("MK6_31","071_6_31","MRK","6","31","31","—Co'ne'ex tiqui junal ich p'atal lu'um ti jedel tz'etz'eecac,— cu t'an a Jesus ti'ijoo' u yaj xa'num. Yanoo' u beel tu junaloo' u men top talac xicoo' a cristiano a tanoo' u chiitic a Jesusu. Ma' yan ma'ax u yorajiloo' u janal u menoo' u yaj sutil. ");
INSERT INTO mopNT_vpl VALUES ("MK6_32","071_6_32","MRK","6","32","32","Joc'oo' te'i. Ocoo' ichil a barcojo. Binoo' tuba ma' yanoo' a cristianojo. ");
INSERT INTO mopNT_vpl VALUES ("MK6_33","071_6_33","MRK","6","33","33","Pues te'i. Le'ecoo' a cristianojo, u yilajoo' ti tanoo' u beel. U yeeloo' maqui ala'oo'o. Joc'oo' ichil boon a caj a yan te'iji. Alca' ti binoo' tuba tanoo' u beel a Jesus eteloo' u yaj cambal. C'ochoo' a cristiano te'i payanbej. ");
INSERT INTO mopNT_vpl VALUES ("MK6_34","071_6_34","MRK","6","34","34","Pues te'i. Le'ec ti c'ochi te'i a Jesusu, u yilajoo' u yaabil a cristiano a much'a'anoo' te'iji. Otziloo' tu wich. Le'ecoo' a cristianojo, jabixoo' a carnero a ma' yanoo' u yaj cananil ti'i u ch'a'beebaloo' u benil. Caji a Jesus u ca'ansoo' a cristiano ti yaab. ");
INSERT INTO mopNT_vpl VALUES ("MK6_35","071_6_35","MRK","6","35","35","Le'ec ti tan u yocol a q'uini, naatz'oo' u yaj cambal tu tzeel a Jesusu. —P'atal lu'um tuba que'eno'on. Ma'ax mac a yan wa'ye'e. Bini tun a q'uini, ");
INSERT INTO mopNT_vpl VALUES ("MK6_36","071_6_36","MRK","6","36","36","mentücü, tücaa'too' u yaabil a cristiano ca' xi'icoo' u q'uexoo' u janal ich aldea nütz'a'an wa'ye',— cu t'anoo' ti'i a Jesusu. ");
INSERT INTO mopNT_vpl VALUES ("MK6_37","071_6_37","MRK","6","37","37","—Inche'ex ca' tz'a'e'exoo' u janal,— cu t'an a Jesusu. —¿A c'ati wa ca' xico'on ti q'uex pan y ca' ti tzeentoo'? Yan u meyaj a mac nueve uj ti'i ca' yanac u tool boon a pan a c'abeet ti'ijoo'o,— cu t'anoo' ti'i a Jesusu. ");
INSERT INTO mopNT_vpl VALUES ("MK6_38","071_6_38","MRK","6","38","38","—¿Boon cuul a pan a yan te'exe? Ca' xique'ex a wila',— cu t'an a Jesus ti'ijoo' u yaj cambal. Le'ec ca' u yilajoo' boon cuul a yana, u yadajoo': —Jadi' cinco cuul a yana, y ca' tuul aj ch'ilam,— cu t'anoo' ti'i a Jesusu. ");
INSERT INTO mopNT_vpl VALUES ("MK6_39","071_6_39","MRK","6","39","39","—Jüp'e'ex a bajil, y tinlene'ex tulacale'ex tacan tuba que'en a su'uquili,— cu t'an a Jesus ti'ijoo' a cristianojo. ");
INSERT INTO mopNT_vpl VALUES ("MK6_40","071_6_40","MRK","6","40","40","Jujun muuch'oo' tu bajil ti tinlajoo' a cristianojo. Yan a jujun muuch' a cien tuulu. Yan a jujun muuch' a cincuenta tuulu. ");
INSERT INTO mopNT_vpl VALUES ("MK6_41","071_6_41","MRK","6","41","41","Le'ec a Jesusu, u müchaj a cinco cuul ti pan etel a ca' tuul aj ch'ilama. U cha'antaj a ca'ana. U c'ajsaj a Dios yoc'ol a janala. U meen xet'aj a pana. U tz'aj ti'ijoo' u yaj cambal ti'i ca' u t'oxoo' ti'ijoo' a cristianojo. U meen xet'aj ilic a ca' tuul aj ch'ilam ti'i ca' t'oxboc ti'i tulacaloo'. ");
INSERT INTO mopNT_vpl VALUES ("MK6_42","071_6_42","MRK","6","42","42","Laj janoo' y na'ajnoo'. ");
INSERT INTO mopNT_vpl VALUES ("MK6_43","071_6_43","MRK","6","43","43","Le'ecoo' u yaj cambala, u tudesajoo' doce cuul a nucuch xac etel u yaabil u yada' a pan y etel u yada' aj ch'ilama. ");
INSERT INTO mopNT_vpl VALUES ("MK6_44","071_6_44","MRK","6","44","44","Cinco mil tuul ti winic a janoo'o. Ma' xoca'anoo' ix ch'up eteloo' a tz'ubi. ");
INSERT INTO mopNT_vpl VALUES ("MK6_45","071_6_45","MRK","6","45","45","Pues te'i. Tu seebal a Jesusu, u yadaj ti'ijoo' u yaj cambal ca' ococoo' ich barco ca' paye' xicoo' junxeel a laguna ich caj Betsaida. Ala'aji, bel u cu yadü' ti'ijoo' u yaabil a cristiano ca' usc'acoo'. ");
INSERT INTO mopNT_vpl VALUES ("MK6_46","071_6_46","MRK","6","46","46","Le'ec ti jobi u yadic ti'ijoo' a cristiano ca' usc'acoo'o, naq'ui a Jesus tuwich witz ti t'an etel a Dioso. ");
INSERT INTO mopNT_vpl VALUES ("MK6_47","071_6_47","MRK","6","47","47","Le'ec ti oqui a ac'ü'ü, naachaji tun a barco chi' ja'a. Tu junal que'en a Jesus ti lu'umil. ");
INSERT INTO mopNT_vpl VALUES ("MK6_48","071_6_48","MRK","6","48","48","U yilajoo' u yaj cambal. Tanoo' u tz'eec u muc' ti'i u beel a barcojo, pero tan u c'ütbüloo' u beel u men a ic' a tan u talel taanil. Le'ec ti jatz'ca' to ti qui'i, watac u c'ochol a Jesus eteloo' u yaj cambal. Tan u ximbal yoc'ol a ja'a. Watac u mansic a barcojo. ");
INSERT INTO mopNT_vpl VALUES ("MK6_49","071_6_49","MRK","6","49","49","C'u' betiqui, ilbi u menoo' u yaj cambal ti tan u ximbal yoc'ol a ja'a. Tu t'anoo' ala'oo'o, pixan a tanoo' u yiliqui. Uchoo' u yawat ti chich. ");
INSERT INTO mopNT_vpl VALUES ("MK6_50","071_6_50","MRK","6","50","50","U laj ilajoo' ala'aji. Jac'oo' u yool tu jajil. Uchi u t'an a Jesus ti jomol eteloo'. —Chichcunte'ex a wool. Ma' a saactale'ex. Inen ilic,— cu t'an a Jesus ti'ijoo'o. ");
INSERT INTO mopNT_vpl VALUES ("MK6_51","071_6_51","MRK","6","51","51","Oqui a Jesus ichil a barco tuba que'enoo'o. Mani a iq'ui. Chen sa'too' u yool u yaj cambal tu jajil, ");
INSERT INTO mopNT_vpl VALUES ("MK6_52","071_6_52","MRK","6","52","52","u men ma' u ch'a'ajoo' u tojil yoc'ol c'u' a tan u ye'ic a milagro u betaj a Jesus etel a pana. Chichoo' to u pol. ");
INSERT INTO mopNT_vpl VALUES ("MK6_53","071_6_53","MRK","6","53","53","Pues te'i. Le'ec ti manoo' junxeel a ja'a, c'ochoo' tuba que'en a jooc u c'aba' Genesaret. U c'üxajoo' a barco tu chi' a ja'a. ");
INSERT INTO mopNT_vpl VALUES ("MK6_54","071_6_54","MRK","6","54","54","Le'ec ti joc'oo' ichil a barcojo, tu seebal c'aj-oolbi u wich a Jesus u menoo' a que'enoo' te'iji. ");
INSERT INTO mopNT_vpl VALUES ("MK6_55","071_6_55","MRK","6","55","55","Joc'oo' ti alca' a cristiano tulacal tubajac te'i. Cajoo' u benes boon a c'oja'an tuwich u cama tuba tanoo' u yubic ti tan u beel a Jesusu. ");
INSERT INTO mopNT_vpl VALUES ("MK6_56","071_6_56","MRK","6","56","56","Le'ec tulacal tuba tan u manül a Jesusu, wa meen caj, wa nucuch caj, wa aldea, te'i tanoo' u coyquintic a c'oja'an chi' bej a cristianojo. Tanoo' u c'aatic ti'i a Jesus ca' cha'büc u tüloo' ca'ax u chi' u noc' ti'i ca' ch'anücoo'. Le'ec boon tuul u tülajoo'o, ch'anesaboo'. ");
INSERT INTO mopNT_vpl VALUES ("MK7_1","071_7_1","MRK","7","1","1","Pues te'i. C'ochoo' etel a Jesus a fariseo u c'aba'oo' u na'at u yet'ocoo' u yaj ca'ansajil u ley aj Moisese. Taloo' ala'oo' ich caj Jerusalen. ");
INSERT INTO mopNT_vpl VALUES ("MK7_2","071_7_2","MRK","7","2","2","U yilajoo' jujun tuul tu yaamoo' u yaj cambal a Jesus a tanoo' u janal y jumpaay biqui u p'o'ajoo' u c'ü'. Ma' u p'o'ajoo' u c'ü' jabix ti sucoo' a fariseo u p'oo'. ");
INSERT INTO mopNT_vpl VALUES ("MK7_3","071_7_3","MRK","7","3","3","Le'ecoo' a fariseo u c'aba'oo' u na'at y c'üs tulacaloo' u chucaan aj Israele, ma' ta'achoo' u janal wa ma' u p'o'icoo' u c'ü' jabix ca' u yadajoo' a uchben cristiano ca' u p'oo'. ");
INSERT INTO mopNT_vpl VALUES ("MK7_4","071_7_4","MRK","7","4","4","Baalo' ilic walacoo' u betic ti tanoo' u yusc'al ti q'uex. Ma' ta'achoo' u janal wa ma' tu p'o'icoo' u c'ü'. Yan ti yaab ulaac' a c'u'ac a walacoo' u betic a p'ütbi ti'ijoo' u menoo' a uchben cristianojo. Yan biqui ti walacoo' u p'o'ic a pote, a cum luc', y a cum fierrojo. Yan ilic biqui ti walacoo' u p'o'ic a che' camaja. P'ütboo' ti'i u bete' abe' u menoo' a uchben cristianojo. Pues te'i. Le'ecoo' a fariseo u c'aba'oo' u na'at u yet'ocoo' u yaj ca'ansajil u ley aj Moisese, u c'aatajoo' ti'i a Jesusu. ");
INSERT INTO mopNT_vpl VALUES ("MK7_5","071_7_5","MRK","7","5","5","—¿C'u' ca'a ma' ta'achoo' u tz'ocsic u t'an a uchben cristiano a waj cambaloo'o? Tanoo' u janal ti ma' p'o'a'anoo' u c'ü' jabix ti suco'on ti p'oo',— cu t'anoo' ti'i a Jesusu. ");
INSERT INTO mopNT_vpl VALUES ("MK7_6","071_7_6","MRK","7","6","6","—Aj cho'e'ex, toj u tz'iibtaj aj Isaias ta woc'ole'exe,— cu t'an a Jesus ti uchi u nuuc. —“Le'ec a cristiano ada'a, walacoo' u yadic jabix tanoo' u tz'ocsic in yanil, pero chen pach u yool. ");
INSERT INTO mopNT_vpl VALUES ("MK7_7","071_7_7","MRK","7","7","7","Ma'ax c'u' aj beel ti tanoo' u c'ajsiquen. Walacoo' u ca'ansic a cristiano etel a t'an a chen cuxquinbi u menoo' a cristianojo,” cu t'an a Dioso. Baalo' u tz'iibtaj aj Isaias ta woc'ole'exe,— cu t'an a Jesusu. ");
INSERT INTO mopNT_vpl VALUES ("MK7_8","071_7_8","MRK","7","8","8","—Inche'exe, a p'ütaje'ex a tz'ocsic u t'an a Dioso. Chen tane'ex a tz'ocsic a t'an a cuxquinbi u menoo' a uchben cristianojo, jabix biqui ta p'o'ique'ex a cum y a poteje. Yan ti yaab ulaac' a c'u'ac tac a jabix abe' a walaque'ex a betiqui,— cu t'an a Jesus ti'ijoo'o. ");
INSERT INTO mopNT_vpl VALUES ("MK7_9","071_7_9","MRK","7","9","9","—Tu jajil tane'ex a p'ütic a tz'ocsic u t'an Dios ti'i a tz'ocsicale'ex a c'u' u p'ütajoo' a uchbene,— cu t'an a Jesus ti'ijoo'o. ");
INSERT INTO mopNT_vpl VALUES ("MK7_10","071_7_10","MRK","7","10","10","—“Tz'oques u yanil a na' a tat. Le'ec mac ca' u yadü' a c'as yoc'ol u na' u tata, yan u quimsabül,” cu t'an aj Moisese,— cu t'an a Jesusu. ");
INSERT INTO mopNT_vpl VALUES ("MK7_11","071_7_11","MRK","7","11","11","—C'u' betiqui, ma' baala' a t'ane'exi. Le'ec ti walac u c'ochol u na' u tat a mac u c'aate ti'i ca' aantabücü, baala' a walaque'ex a wadiqui: “Wa ca' u yadü' ti'i u na' u tat ti ac sijibi tun ti'i a Dios le'ec a c'u' a tanoo' u c'aatic ca' aantabüc etele, ");
INSERT INTO mopNT_vpl VALUES ("MK7_12","071_7_12","MRK","7","12","12","ma' ta'ache'ex a cha'ic u yaanticoo' u na' u tat etel.” Baalo' a walaque'ex a wadiqui,— cu t'an a Jesusu. ");
INSERT INTO mopNT_vpl VALUES ("MK7_13","071_7_13","MRK","7","13","13","—Ti baalo'o, chen yoc'lal a c'u' a uchbene, a tz'aje'ex jabix ma' yan u yanil u t'an a Dioso,— cu t'an a Jesusu. —Yan ti yaab a jabix abe' a walaque'ex a betiqui,— cu t'an a Jesusu. ");
INSERT INTO mopNT_vpl VALUES ("MK7_14","071_7_14","MRK","7","14","14","Pues te'i. Le'ec a Jesusu, u püyajoo' a cristiano ca' jiisicoo' tu tzeel tucaye'. —U'yeene'ex tulacale'ex. Ch'a'e'ex u tojil in t'an,— cu t'an a Jesus ti'ijoo'o. ");
INSERT INTO mopNT_vpl VALUES ("MK7_15","071_7_15","MRK","7","15","15","—Ma' yan ma'ax c'u'i a walac u yocol ichil u chi' a jede'ec u paatal u c'ascuntic u na'at jun tuul a maqui. Le'ec a walac u joc'ol ichil u chi' a maca, le'ec walac u c'ascuntic u na'at,— cu t'an a Jesusu. ");
INSERT INTO mopNT_vpl VALUES ("MK7_16","071_7_16","MRK","7","16","16","—Le'ec mac a jede'ec u paatal u yubi in t'ana, yan u tz'eec tu yool,— cu t'an a Jesusu. ");
INSERT INTO mopNT_vpl VALUES ("MK7_17","071_7_17","MRK","7","17","17","Pues te'i. Joq'ui a Jesus tu yaamoo' u yaabil a cristianojo. Oqui ich naj. Le'ec ti que'en te'iji, c'aatbi ti'i u nu'cul a mucult'an abe' u menoo' u yaj cambala. ");
INSERT INTO mopNT_vpl VALUES ("MK7_18","071_7_18","MRK","7","18","18","—¿Ma' wa ta'ache'ex a ch'a'ic u tojil jabixoo' ulaac' a cristianojo? ¿Ma' wa chica'an te'ex? Le'ec a c'u' a walac u yocol ichil u chi' a maca, ma' yan biqui u c'ascuntic u na'at,— cu t'an a Jesusu. ");
INSERT INTO mopNT_vpl VALUES ("MK7_19","071_7_19","MRK","7","19","19","—Ma' ta'ach u beel ichil u na'ati. Chen walac u beel ichil u nüc' ca' tun manüc,— cu t'an a Jesusu. Etel ti ca' u yadaj abe' a Jesusu, u ye'aj ti tulacal a janala, qui'. ");
INSERT INTO mopNT_vpl VALUES ("MK7_20","071_7_20","MRK","7","20","20","—Le'ec a walac u joc'ol ichil u chi' a maca, le'ec walac u c'ascuntic u na'at a maca,— cu t'an a Jesusu. ");
INSERT INTO mopNT_vpl VALUES ("MK7_21","071_7_21","MRK","7","21","21","—Ichil u püsüc'al a maca, te'i walac u tal a c'ac'as tuculu. Te'i walac u tal a tucul ti cüjtal etel ca'ax macac ca'ax yan u yütan wa u yicham, ca'ax ma' yan. Te'i walac u tal a tucul ti quimsaj, ");
INSERT INTO mopNT_vpl VALUES ("MK7_22","071_7_22","MRK","7","22","22","ti xuuch', ti jaq'uintic tulacal a c'u'aca. Te'i walac u talel a tucul ti'i u betabeeb a c'asil na'ata, a tucul ti cho', a tucul ti'i u betabeeb a ma'su'tala. Te'i ichil u püsüc'al a mac walac u tal a tucul ti tz'i'lic c'u' a ti'i ulaac'a, a tucul ti maclant'an, a tucul ti top betic u winiquil. Te'i walac u tal a tucul ti betic jabix ma' yan u na'at,— cu t'an a Jesusu. ");
INSERT INTO mopNT_vpl VALUES ("MK7_23","071_7_23","MRK","7","23","23","—Tulacal a c'as a jabix abe'e, walac u tal ichil u püsüc'al a maca, y walac u c'ascuntic u na'at,— cu t'an a Jesusu. ");
INSERT INTO mopNT_vpl VALUES ("MK7_24","071_7_24","MRK","7","24","24","Pues te'i. Joq'ui a Jesusu. Bini ich cuenta Tiro y Sidon. Culaji ichil a naj te'iji. Ma' u c'ati cuchi ca' eeltabüc ti que'en te'i, pero ma' yan biqui u muquic u bajil. ");
INSERT INTO mopNT_vpl VALUES ("MK7_25","071_7_25","MRK","7","25","25","U'yajbi ti que'en te'i u men jun tuul a nooch'up a yan a c'ac'asba'al tu yool u yal. Tu seebal bini etel a Jesusu. Xonlaji tu taan. ");
INSERT INTO mopNT_vpl VALUES ("MK7_26","071_7_26","MRK","7","26","26","Ma' Israel a nooch'up abe'e. Sirofenicia u c'aba' u caal. U c'aataj ti'i a Jesus ca' u joq'ues a c'ac'asba'al a que'en tu yool u yal. ");
INSERT INTO mopNT_vpl VALUES ("MK7_27","071_7_27","MRK","7","27","27","Le'ec a Jesusu, ich mucult'an u nuuctaj a nooch'up ti se' yan u yaanticoo' u yetcaal aj Israele. —Ma' toj ca' tocbocoo' u waj a tz'ub ca' pulbuc ti'ijoo' a peq'ue,— cu t'an a Jesus ti'i u men ma' Israel ala'aji. ");
INSERT INTO mopNT_vpl VALUES ("MK7_28","071_7_28","MRK","7","28","28","—Jaj a t'an, Noochil. C'u' betiqui, le'ecoo' a pec' a que'en yalam a mesaja, walacoo' u jantic u xeex u waj a tan u c'axül tu chi' a tz'ubu,— cu t'an a nooch'up ti'iji, u men u c'ati ilic ca' aantabüc ala'i ca'ax ma' chucul Israel. ");
INSERT INTO mopNT_vpl VALUES ("MK7_29","071_7_29","MRK","7","29","29","—Qui' ti ca' a nuuctajen. Joq'ui a c'ac'asba'al tu yool a wal. Ca' xiquech ta wotoch,— cu t'an a Jesus ti'i a nooch'upu. ");
INSERT INTO mopNT_vpl VALUES ("MK7_30","071_7_30","MRK","7","30","30","Le'ec ti c'ochi tu yotoch a nooch'upu, u yilaj u yal. Coya'an ti que'en tu cama. Ma' ca' yan a c'ac'asba'al tu yoolo. ");
INSERT INTO mopNT_vpl VALUES ("MK7_31","071_7_31","MRK","7","31","31","Pues te'i. Joq'ui a Jesus ich cuenta Tiro. Mani ich cuenta Sidon, ca' tun mani ichil a cuenta tuba yan diez p'eel ti caj. C'ochi tu chi' a laguna Galilea. ");
INSERT INTO mopNT_vpl VALUES ("MK7_32","071_7_32","MRK","7","32","32","C'ochesabi ti'i te'i jun tuul a winic a cooc y ma' patal ti t'an. C'aatbi ti'i ca' u tz'aa' u c'ü' yoc'ol a winic ti'i ca' u ch'anes. ");
INSERT INTO mopNT_vpl VALUES ("MK7_33","071_7_33","MRK","7","33","33","Le'ec a Jesusu, u joc'saj a winic tu yaamoo' a cristianojo. Le'ec ti que'en tu junal etel a winiqui, u tz'aj u ni' u c'ü' ichil u xiquin ca' tun uchi u tuub. U tülaj u yac' a winic etel. ");
INSERT INTO mopNT_vpl VALUES ("MK7_34","071_7_34","MRK","7","34","34","U cha'antaj a ca'an a Jesusu. U cha'aj u yic'. —EFATA,— cu t'an ti'i a winiqui. —Jebe,— cu t'an a t'an abe'e. ");
INSERT INTO mopNT_vpl VALUES ("MK7_35","071_7_35","MRK","7","35","35","Jeebi u xiquin a winiqui. Qui'aji u t'an. Caji ti t'an ti toj. ");
INSERT INTO mopNT_vpl VALUES ("MK7_36","071_7_36","MRK","7","36","36","—Ma' a wadique'ex ti'i ma'ax mac c'u' a maniji,— cu t'an a Jesus ti'ijoo' a cristianojo. C'u' betiqui, le'ec boon sut a walac u yadic abe' a Jesus ti'ijoo' a cristianojo, mas que'enoo' u yool u yadü' c'u' a walac u betiqui. ");
INSERT INTO mopNT_vpl VALUES ("MK7_37","071_7_37","MRK","7","37","37","Sa'too' u yool tu jajil a cristianojo. —Tulacal a c'u' a walac u betic a Jesusu, walac u betic ti qui'. Ca'ax cooc a maca, walac u jebic u xiquin. Ca'ax bes, walac u qui'cuntic u t'an,— cu t'anoo' a cristianojo. ");
INSERT INTO mopNT_vpl VALUES ("MK8_1","071_8_1","MRK","8","1","1","Pues te'i. Ma' top xanac tu pach abe'e, ca' muchq'uinboo' ti yaab a cristiano etel a Jesusu. Ma' yan c'u' a ca' u jantoo'. Le'ec a Jesusu, u püyajoo' u yaj cambal tu tzeel. ");
INSERT INTO mopNT_vpl VALUES ("MK8_2","071_8_2","MRK","8","2","2","—Otziloo' tin wich a cristiano ada'a. Ox p'e q'uin que'enoo' tin wetel, y ma'ax c'u' a yan ca' u jantoo',— cu t'an a Jesus ti'ijoo' u yaj cambala. ");
INSERT INTO mopNT_vpl VALUES ("MK8_3","071_8_3","MRK","8","3","3","—Wa cuchi ca' in tücaa'too' ca' usc'acoo' ti wi'ijoo'o, uchac u sücquimiloo' ti bej. Yan tu yaamoo' a taloo' ti naach,— cu t'an a Jesusu. ");
INSERT INTO mopNT_vpl VALUES ("MK8_4","071_8_4","MRK","8","4","4","—Que'eno'on ich p'atal lu'um. ¿Tuba ca' ti cüxte ti chucul a janal ti'i ca' ti tzeentoo' a cristiano ada'a?— cu t'anoo' u yaj cambal ti uchoo' u nuuc. ");
INSERT INTO mopNT_vpl VALUES ("MK8_5","071_8_5","MRK","8","5","5","—¿Boon cuul a pan a yan te'exe,— cu t'an a Jesus ti'ijoo'o. —Siete cuul,— cu t'anoo' ti'i. ");
INSERT INTO mopNT_vpl VALUES ("MK8_6","071_8_6","MRK","8","6","6","U yadaj ca' tinlacoo' a cristiano ti lu'um. U müchaj a siete cuul a pana. Le'ec ca' u tz'aj a bo'tic ti'i a Dioso, u meen xet'aj. U tz'aj ti'ijoo' u yaj cambal ti'i ca' u t'oxoo' ti'ijoo' boon a cristianojo. U t'oxajoo' ti'i a cristianojo. ");
INSERT INTO mopNT_vpl VALUES ("MK8_7","071_8_7","MRK","8","7","7","Yan ilic tz'etz'eec aj meen ch'ilama. Le'ec ca' u c'ajsaj a Dios yoc'ol abe' a Jesusu, u yadaj ca' t'oxboc ti'ijoo' a cristianojo. ");
INSERT INTO mopNT_vpl VALUES ("MK8_8","071_8_8","MRK","8","8","8","Laj janoo' y na'ajnoo'. U tudesajoo' siete cuul a nucuch xac etel u yaabil u yada' a janala. ");
INSERT INTO mopNT_vpl VALUES ("MK8_9","071_8_9","MRK","8","9","9","Jabix cuatro mil tuul a janoo'o. ");
INSERT INTO mopNT_vpl VALUES ("MK8_10","071_8_10","MRK","8","10","10","Le'ec ca' u tücaa'tajoo' a cristiano a Jesus ca' usc'acoo'o, oqui ichil a barco u yet'ocoo' u yaj cambal. Binoo' tu cuenta Dalmanuta. ");
INSERT INTO mopNT_vpl VALUES ("MK8_11","071_8_11","MRK","8","11","11","Pues te'i. C'ochoo' a fariseo u c'aba'oo' u na'at etel a Jesusu. Cajoo' u c'aate ti'i ca' u bete' c'u'ac ti ca'an ti'i ca' u yiloo' wa patal. ");
INSERT INTO mopNT_vpl VALUES ("MK8_12","071_8_12","MRK","8","12","12","Yajaji u yool a Jesus tu jajili. —Le'ecoo' a cristiano aleebe, ¿c'u' ca'a walacoo' u c'aatic ca' in bete' c'u'ac ti'i ca' chiclac ti yan in yanili? Tan in wadic te'ex u jajil. Ma' tu ye'bel ti'ijoo' a milagro a jabix u c'atoo'o,— cu t'an a Jesusu. ");
INSERT INTO mopNT_vpl VALUES ("MK8_13","071_8_13","MRK","8","13","13","Le'ec ti jobi u yadic abe'e, joq'ui a Jesus tu yaamoo'o. Ca' oqui ichil a barcojo. Ca' bini junxeel a laguna tucaye'. ");
INSERT INTO mopNT_vpl VALUES ("MK8_14","071_8_14","MRK","8","14","14","Pues te'i. Tubboo' ti'i u yaj cambal a Jesus ca' u bensoo' a pan tu pacha. Jadi' jun cuul ilic a pan a yan eteloo' ichil a barcojo. ");
INSERT INTO mopNT_vpl VALUES ("MK8_15","071_8_15","MRK","8","15","15","—Cününte'ex a bajil ti'i ma' a cho'bole'ex u men u levadura a fariseo u c'aba'oo' u na'at u yet'ocoo' aj Herodese,— cu t'an a Jesus ti'ijoo'o. ");
INSERT INTO mopNT_vpl VALUES ("MK8_16","071_8_16","MRK","8","16","16","Caji tzicbalbül a t'an abe' u menoo' u yaj cambal. —U yadaj wal abe' u men ma' yan a pan tiqui wetele,— cu t'anoo' tu bajil. ");
INSERT INTO mopNT_vpl VALUES ("MK8_17","071_8_17","MRK","8","17","17","A Jesusu, u yeel c'u' a tanoo' u yadic tu bajiloo'o. —¿C'u' ca'a tane'ex a tzicbal ta bajile'ex ti ma' yan te'ex a pana? ¿Ma' wa ta'ache'ex a ch'a'ic u tojil? ¿Ma' wa chica'an te'ex? ¿Chich ilique'ex wa a pol?— cu t'an a Jesus ti'ijoo'o. ");
INSERT INTO mopNT_vpl VALUES ("MK8_18","071_8_18","MRK","8","18","18","—Yane'ex a wich. ¿C'u' ca'a ma' ta'ache'ex a cha'an? Yane'ex a xiquin. ¿C'u' ca'a ma' ta'ache'ex a wu'yic in t'an? ¿Ma' wa c'üja'an te'ex?— cu t'an a Jesus ti'ijoo' u yaj cambala. ");
INSERT INTO mopNT_vpl VALUES ("MK8_19","071_8_19","MRK","8","19","19","—¿Boon cuul ti xac u yada' a pan a molaje'ex le'ec ca' in meen xet'aj cinco cuul a pan ti'i in tzeenticaloo' cinco mil tuul ti winic uchi?— cu t'an ti'ijoo'. —Doce cuul,— cu t'anoo' ti'i a Jesusu. ");
INSERT INTO mopNT_vpl VALUES ("MK8_20","071_8_20","MRK","8","20","20","—¿Boon cuul ti xac u yada' a pan a molaje'ex le'ec ca' in tzeentajoo' a cuatro mil tuulu?— cu t'an ti'ijoo'. —Siete cuul,— cu t'anoo' ti'i. ");
INSERT INTO mopNT_vpl VALUES ("MK8_21","071_8_21","MRK","8","21","21","—¿Ma' wa ta'ache'ex a ch'a'ic u tojil in t'an tac leeb?— cu t'an a Jesus ti'ijoo' u yaj cambala. ");
INSERT INTO mopNT_vpl VALUES ("MK8_22","071_8_22","MRK","8","22","22","Pues te'i. C'ochoo' ich caj Betsaida. C'ochesabi jun tuul a winic a ch'oop etel a Jesus u menoo' a cristianojo. —Tülü a ch'oop ti'i ca' ch'anüc,— cu t'anoo' a cristiano ti'i a Jesusu. ");
INSERT INTO mopNT_vpl VALUES ("MK8_23","071_8_23","MRK","8","23","23","U müchaj a ch'oop tu c'ü'ü. U bensaj pach caj. U tuubtaj u nec' u wich ca' tun u tz'aj u c'ü' yoc'ol a winiqui. —¿Patalech wa ti cha'an aleebe?— cu t'an a Jesus ti'iji. ");
INSERT INTO mopNT_vpl VALUES ("MK8_24","071_8_24","MRK","8","24","24","Caji ti cha'an a winiqui. —Tan in wilicoo' a cristianojo. Jabix che' ti tan in wilicoo', pero chen u men tanoo' u ximbal, tan in wadic ti cristiano ala'oo',— cu t'an a winiqui. ");
INSERT INTO mopNT_vpl VALUES ("MK8_25","071_8_25","MRK","8","25","25","Le'ec a Jesusu, u ca' tz'aj u c'ü' yoc'ol u wich a winiqui. Uchi u qui' cha'an a winiqui. Ch'ani u wich. Paataji u cha'an ti qui'. ");
INSERT INTO mopNT_vpl VALUES ("MK8_26","071_8_26","MRK","8","26","26","—Ca' xiquech ta wotoch, pero ma' a manül ich caj ti tan a beel. Ma'ax a se' adic c'u' a mani tech ti'ijoo',— cu t'an a Jesus ti'iji. ");
INSERT INTO mopNT_vpl VALUES ("MK8_27","071_8_27","MRK","8","27","27","Pues te'i. Tan u manül a Jesus u yet'ocoo' u yaj cambal ichil boon a caj a que'en ich cuenta Cesarea de Filipo. Le'ec ti tanoo' u manülü, u c'aatajoo' ti'i u yaj cambal. —¿Biqui'iloo' u tucul a cristianojo? ¿Mac winiquilen ti walacoo' u yadiqui?— cu t'an a Jesus ti'ijoo' u yaj cambala. ");
INSERT INTO mopNT_vpl VALUES ("MK8_28","071_8_28","MRK","8","28","28","—Yan a walacoo' u yadic ti le'ec inchech aj Juan aj tz'aj ocja'a,— cu t'anoo' ti'i. —Yanoo' ulaac' a walacoo' u yadic ti le'ec inchech a uchben cristiano aj Eliasa. Ulaac' tucaye' walacoo' u yadic ti le'ec inchech ulaac' a jun tuul u yadaj u t'an a Dios uchiji,— cu t'anoo' ti'i a Jesusu. ");
INSERT INTO mopNT_vpl VALUES ("MK8_29","071_8_29","MRK","8","29","29","—Uxtun inche'exe. ¿Mac winiquilen ti walaque'ex a wadic?— cu t'an ti'ijoo'o. —Inchech u yaj Sa'alil a cristianojo,— cu t'an aj Pedro ti'iji. ");
INSERT INTO mopNT_vpl VALUES ("MK8_30","071_8_30","MRK","8","30","30","—Ma' a se' adique'ex abe' ti'i ma'ax mac,— cu t'an a Jesus ti'ijoo'o. ");
INSERT INTO mopNT_vpl VALUES ("MK8_31","071_8_31","MRK","8","31","31","Pues te'i. Caji a Jesus u yadü' ti'ijoo' u yaj cambal c'u' a bel u ca'a betabül ti'iji. —Inene, yanajeen ti cristianojil. Yan in c'ümic ti yaab a yaja,— cu t'an. —Bel in ca'a culpachbül u menoo' ti wetcaal a winic a nucuch u wichili. Beloo' ilic u ca'a u bete' ten ti baalo' u noochiloo' u yaj mansaj t'an a cristiano ti'i a Dioso. Baalo' ilic xan beloo' u cu bete' ten boon tuul u yaj ca'ansajil u ley aj Moisese. Yan in quimsabül. Yan ilic in ca' cuxtal tucaye'il tu yox p'eel q'uin,— cu t'an a Jesus ti'ijoo' u yaj cambala. ");
INSERT INTO mopNT_vpl VALUES ("MK8_32","071_8_32","MRK","8","32","32","Chica'an u t'an ca' u yadaj abe' ti'ijoo' u yaj cambal. Pues te'i. Joc'sabi a Jesus tu junal u men aj Pedrojo. Caji tze'ecbel a Jesus u men. ");
INSERT INTO mopNT_vpl VALUES ("MK8_33","071_8_33","MRK","8","33","33","Le'ec a Jesusu, u sutaj u bajil. U cha'antajoo' u chucaan u yaj cambal. —Xen quisin. Ma' qui' ta wich a jabix u c'ati a Dioso, chen a jabix u c'atoo' a cristianojo,— cu t'an a Jesus ti'i aj Pedrojo. ");
INSERT INTO mopNT_vpl VALUES ("MK8_34","071_8_34","MRK","8","34","34","Pues te'i. Le'ec a Jesusu, u püyajoo' u yaabil a cristiano u yet'ocoo' u yaj cambala, ca' talacoo' tu tzeel. —Wa yan mac u c'ati u c'ümeene, yan u p'ütic u betic c'u' a qui' tu wich u betic wa'ye' yoc'olcaba. Yan u c'ümic boon a yaj a tan u tz'abül ti'i u men tan u tz'ocsiquene. Ti baalo', tan u betic jabix a mac a tan u bensic u cruz ti'i u quimsabül tuwichi. Le'ec a jabix abe' a qui' ca' talac tin pacha,— cu t'an a Jesusu. ");
INSERT INTO mopNT_vpl VALUES ("MK8_35","071_8_35","MRK","8","35","35","—Le'ec mac u c'ati u sa'alte u qui'il u cuxtal wa'ye'e, sa'tül u ca'a ti'i. Uchac u sa'tül u cuxtal a mac u men que'en u yool tin pach etel ilic u men tan u yadic u t'an a Dioso, bel u cu sa'alte u cuxtal,— cu t'an a Jesusu. ");
INSERT INTO mopNT_vpl VALUES ("MK8_36","071_8_36","MRK","8","36","36","—¿C'u' aj beel ti'i a mac ca'ax u na'alte cuchi tulacal a yoc'olcaba, y ca' quimic ti ma' c'üma'an u men a Dioso?— cu t'an a Jesusu. ");
INSERT INTO mopNT_vpl VALUES ("MK8_37","071_8_37","MRK","8","37","37","—¿Wa xan c'u' aj jede'ec u paatal u tz'eec a mac ti'i ca' tz'abüc u cuxtal tucaye'il,— cu t'an a Jesusu. ");
INSERT INTO mopNT_vpl VALUES ("MK8_38","071_8_38","MRK","8","38","38","—Aleebe top c'asoo' u na'at a cristianojo. U p'ütajoo' u c'ajsic a Dios ti ca'ana, ti'i ca' u c'ajesoo' a ca'ax c'u'ac ti diosili. Wa yan mac a sudac tene, wa sudac u men in t'ana, baalo' ilic le'ec ti ca' uduquen tucaye'il, sudaquen ti'iji. Inene, yanajeen ti cristianojil. Ca' wataquen tucaye' etel u muc' in Tat ti ca'an. Ca' wataquen eteloo' u yaj xa'num a Dios ti ca'ana,— cu t'an a Jesus ti'ijoo' a cristianojo. ");
INSERT INTO mopNT_vpl VALUES ("MK9_1","071_9_1","MRK","9","1","1","—Tan in wadic te'ex u jajil. Yan a jujun tuule'ex a wa'ane'ex wa'ye' a ma' ta quimile'ex asto a wilique'ex biqui ti walac u tücaa' a Dios etel muc'u,— cu t'an a Jesusu. ");
INSERT INTO mopNT_vpl VALUES ("MK9_2","071_9_2","MRK","9","2","2","Pues te'i. Seis q'uin manüc a t'an abe' u yadaj a Jesusu, naq'ui tuwich a witz a top ca'nala. U bensajoo' aj Pedro, aj Jacob y aj Juan tu pacha. Que'enoo' tu junal. Jeeli u cha'an tu taanoo'. ");
INSERT INTO mopNT_vpl VALUES ("MK9_3","071_9_3","MRK","9","3","3","Süc sücaji u noc' tu jajil. Ma'ax mac ix p'o' patal u süccunte a noc' jabix ti sücaji a ti'i a Jesusu. ");
INSERT INTO mopNT_vpl VALUES ("MK9_4","071_9_4","MRK","9","4","4","Chiclajoo' aj Elias etel aj Moises ti'ijoo' a ox tuulu. Aj Elias aj Moisese, tanoo' u t'an etel a Jesusu. ");
INSERT INTO mopNT_vpl VALUES ("MK9_5","071_9_5","MRK","9","5","5","—Maestro, qui' ti que'eno'on wa'ye'. Bel ti ca'a ti bete' ox cuul a tz'i' naj ti'i bo'oy. Jun cuulu, tech. Jun cuul ti'i aj Moisese, y jun cuul ti'i aj Eliasa,— cu t'an aj Pedrojo. ");
INSERT INTO mopNT_vpl VALUES ("MK9_6","071_9_6","MRK","9","6","6","Chen u yadaj ti baalo' u men ma' u yeel c'u' a qui' ca' u yadü' u men saacoo' tu jajil. ");
INSERT INTO mopNT_vpl VALUES ("MK9_7","071_9_7","MRK","9","7","7","Emi a muyal yoc'oloo'. Uchi a t'an ichil a muyala. —Le'ec ada' in Mejen. Yaj in wu'yi. U'ye'ex u t'an,— cu t'an a t'an ichil a muyala. ");
INSERT INTO mopNT_vpl VALUES ("MK9_8","071_9_8","MRK","9","8","8","Uchoo' u cha'an ti jomol. U yilajoo' ti ma'ax mac a que'en te'i eteloo'o. Jadi' a Jesusu. ");
INSERT INTO mopNT_vpl VALUES ("MK9_9","071_9_9","MRK","9","9","9","Pues te'i. Tanoo' u yemel tuwich a witzi. —Ma' a se' adique'ex ti'i ma'ax mac le'ec a c'u' a wilaje'ex asto ti ca' cuxlaquen tu yaamoo' a quimen inen a yanajeen ti cristianojili,— cu t'an a Jesus ti'ijoo'o. ");
INSERT INTO mopNT_vpl VALUES ("MK9_10","071_9_10","MRK","9","10","10","Tz'ocsabi u t'an u men a ox tuulu. C'u' betiqui, u c'aatajoo' tu bajil u nu'cul a t'an abe' u ca' cuxtal tu yaamoo' a quimene. ");
INSERT INTO mopNT_vpl VALUES ("MK9_11","071_9_11","MRK","9","11","11","—Le'ecoo' u yaj ca'ansajil u ley aj Moisese, ¿c'u' ca'a walacoo' u yadic ti yan u ca' udel payanbej a uchben cristiano aj Elias u c'aba'a, ca' tun ca' uduc u yaj Sa'alil a cristianojo?— cu t'anoo' a ox tuul ti'i a Jesusu. ");
INSERT INTO mopNT_vpl VALUES ("MK9_12","071_9_12","MRK","9","12","13","—Jajoo' u t'an. Yan u yudel payanbej aj Elias u tojquinte tulacal. Tan in wadic te'ex. Ac udi tun aj Eliasa. U betajoo' a ca'ax c'u'ac a qui'oo' tu wich u betoo' ti'i jabix ilic ti ac tz'iiba'an ichil u ju'um a Dios ti bel u ca'a betabül ti'iji,— cu t'an a Jesusu. —Uxtun inen a yanajeen ti cristianojili, tz'iiba'an ilic tin woc'ol ti bel u ca'a betabül ten a ca'ax c'u'ac ti yajili. Ma' tu tz'ocsabül in yanil,— cu t'an a Jesus ti'i a ox tuul u yaj cambala. ");
INSERT INTO mopNT_vpl VALUES ("MK9_14","071_9_14","MRK","9","14","14","Pues te'i. Le'ec ti emoo' tac eteloo' u chucaan u yaj cambala, u yilajoo' ti much'a'anoo' ti yaab a cristiano eteloo' u yaj cambal. Yanoo' ilic u yaj ca'ansajil u ley aj Moises te'i. Ala'oo'o, tanoo' u yaaltic u tojquintoo' u yaj cambal a Jesus etel t'an. ");
INSERT INTO mopNT_vpl VALUES ("MK9_15","071_9_15","MRK","9","15","15","Le'ec ti ilbi a Jesus u menoo' tulacal a cristiano abe'e, sa'too' u yool tu jajil. Tu seebal joc'oo' ti alca' ti'i u beeloo' u chiite a Jesusu. ");
INSERT INTO mopNT_vpl VALUES ("MK9_16","071_9_16","MRK","9","16","16","—¿C'u' a tane'ex a tzicbaltic ta bajile'exe?— cu t'an a Jesus ti'ijoo'o. ");
INSERT INTO mopNT_vpl VALUES ("MK9_17","071_9_17","MRK","9","17","17","Nuucbi a Jesus u men jun tuul tu yaamoo' u yaabil a cristianojo. —Maestro,— cu t'an ti'i. —In talesaj in mejen ca' a qui'cunte ten. Yan a c'ac'asba'al tu yoolo. Bes u men a c'ac'asba'al abe'e,— cu t'an ti'i a Jesusu. ");
INSERT INTO mopNT_vpl VALUES ("MK9_18","071_9_18","MRK","9","18","18","—Ca'ax tuba tan u manül in mejene, walac u müchbül u pulbul ti lu'um u men a c'ac'asba'al abe'e. Walac u yoom u chi' a tz'ubu. Jürütlemac u coj. Walac u chichtal. In c'aataj ti'ijoo' a waj cambal ca' u joq'uesoo' a c'ac'asba'al a que'en tu yoolo, pero ma' paatajoo' u joq'ues,— cu t'an ti'i a Jesusu. ");
INSERT INTO mopNT_vpl VALUES ("MK9_19","071_9_19","MRK","9","19","19","—Top ma' que'ene'ex a wool tu jajil tu pach a Dioso,— cu t'an a Jesusu. —¿Boon q'uin to yan in cuntal ta yaame'exe? ¿Boon q'uin to yan in muc'yajte'ex? Tales a tz'ubu,— cu t'an a Jesusu. ");
INSERT INTO mopNT_vpl VALUES ("MK9_20","071_9_20","MRK","9","20","20","C'ochesabi a tz'ub etel a Jesusu. Le'ec ti ilbi a Jesus u men a c'ac'asba'ala, tu seebal süquimi a tz'ub u mene. C'axi ti lu'um. Caji u cocles u bajil ti lu'um. Tan u yoom u chi'. ");
INSERT INTO mopNT_vpl VALUES ("MK9_21","071_9_21","MRK","9","21","21","—¿Biq'uini ti caji u c'ümü' a jabix ada'a?— cu t'an a Jesus ti'i u tat a tz'ubu. —Le'ec ti nene' to,— cu t'an ti'i. ");
INSERT INTO mopNT_vpl VALUES ("MK9_22","071_9_22","MRK","9","22","22","—Yaab sut u pulaj a tz'ub ich c'aac' wa ich ja' ti'i ca' u quimes. Wa jede'ec a paatal a ch'anesic a tz'ubu, ch'a'a ti wotzilil. Aanto'on,— cu t'an u tat a tz'ub ti'i a Jesusu. ");
INSERT INTO mopNT_vpl VALUES ("MK9_23","071_9_23","MRK","9","23","23","—¿C'u' ca'a tan a wadic wa jede'ec in paatala? Le'ec mac a que'en u yool tu pach Dios tu jajili, jede'ec u paatal u betic tulacal,— cu t'an a Jesus ti'iji. ");
INSERT INTO mopNT_vpl VALUES ("MK9_24","071_9_24","MRK","9","24","24","Tu seebal uchi u t'an ti chich u tat a tz'ubu. —Que'en in wool tu pach a Dioso. Aanteen ti'i ca' in mas tz'aa' in wool tu pach,— cu t'an ti'i a Jesusu. ");
INSERT INTO mopNT_vpl VALUES ("MK9_25","071_9_25","MRK","9","25","25","Pues te'i. Alca' ti tanoo' u much'tal a cristianojo. Le'ec ca' u yilaj abe' a Jesusu, u tze'ectaj a c'ac'asba'ala. —Incheche, c'ac'asba'alech. Walac a bescunticoo' a cristianojo. Walac a coocquinticoo'. Tan in wadic tech. Joq'uen ichil u yool a tz'ubu. Ma' ca' ocol te'i tucaye',— cu t'an ti'i a c'ac'asba'al abe'e. ");
INSERT INTO mopNT_vpl VALUES ("MK9_26","071_9_26","MRK","9","26","26","Uchi u yawat ti chich a c'ac'asba'ala. Ca' sücquimi a tz'ub u mene, ca' tun joq'ui. P'aati a tz'ub jabix quimene, mentücü. —Quimen,— cu t'anoo' u yaabil a cristianojo. ");
INSERT INTO mopNT_vpl VALUES ("MK9_27","071_9_27","MRK","9","27","27","Le'ec a Jesusu, u müchaj a tz'ub tu c'ü'ü. U lic'saj. Wa'laji a tz'ubu. ");
INSERT INTO mopNT_vpl VALUES ("MK9_28","071_9_28","MRK","9","28","28","Pues te'i. Oqui a Jesus ich naj. Tu junal que'enoo' ti c'aatbi ti'i u menoo' u yaj cambal. —¿C'u' ca'a ma' paatajo'on ti joq'ues a c'ac'asba'al abe'e?— cu t'anoo' ti'i. ");
INSERT INTO mopNT_vpl VALUES ("MK9_29","071_9_29","MRK","9","29","29","—Le'ec a c'ac'asba'al a jabix abe'e, ma' ta'ach u joc'ol tu yool a mac wa ma' tane'ex a boch c'ajsic a Dios yoc'ol etel a p'ütique'ex a janal ti suq'uin,— cu t'an a Jesus ti'ijoo'o. ");
INSERT INTO mopNT_vpl VALUES ("MK9_30","071_9_30","MRK","9","30","31","Pues te'i. Joq'ui a Jesusu. Tan u manül ich cuenta Galilea u yet'ocoo' u yaj cambal. Tan u ca'ansicoo' u yaj cambal, mentücü, ma' u c'ati cuchi ca' eeltabüc ti tanoo' u manül te'i bic talacoo' ti yaab. —Inene, yanajeen ti cristianojil. Bel in ca'a c'ubbul tu c'ü'oo' a cristianojo. Bel in ca'a quimsabül u menoo'. Ox p'e q'uin quimenen ti bel in ca'a ca' cuxquinbil tucaye',— cu t'an ti'ijoo' u yaj cambal. ");
INSERT INTO mopNT_vpl VALUES ("MK9_32","071_9_32","MRK","9","32","32","Ma' u ch'a'ajoo' u tojil u t'an. Saacoo' u c'aate ti'i a Jesus c'u' u nu'cul a t'an abe'e. ");
INSERT INTO mopNT_vpl VALUES ("MK9_33","071_9_33","MRK","9","33","33","Pues te'i. C'ochi a Jesus ich caj Capernaum u yet'ocoo' u yaj cambal. Le'ec ti ocoo' ich naja, u c'aatajoo' ti'i u yaj cambal. —Le'ec ti que'eno'on to ti bej, ¿c'u' a tane'ex a tzicbaltiqui?— cu t'an ti'ijoo'. ");
INSERT INTO mopNT_vpl VALUES ("MK9_34","071_9_34","MRK","9","34","34","Ma' uchoo' u nuuc u men le'ec ti que'enoo' ti bej, u tzicbaltajoo' mac a mas nooch u wichil u meyaj tu yaamoo'o. ");
INSERT INTO mopNT_vpl VALUES ("MK9_35","071_9_35","MRK","9","35","35","Tinlaji a Jesusu. U püyajoo' a doce tuul u yaj cambal tu tzeele. —Wa yan mac u c'ati ca' yanac ti mas nooch u wichil u meyaj tuwichoo' u chucaana, yan u tz'eec u bajil jabix jumpul ma'ax c'u' u wich u meyaj. Yan u yaanticoo' tulacal,— cu t'an a Jesus ti'ijoo'o. ");
INSERT INTO mopNT_vpl VALUES ("MK9_36","071_9_36","MRK","9","36","36","U püyaj a tz'ubu. U tz'aj tu taanoo' u yaj cambal. U meectaj a tz'ubu. ");
INSERT INTO mopNT_vpl VALUES ("MK9_37","071_9_37","MRK","9","37","37","—A tz'uboo'o, walacoo' u tz'ocsaj t'an. Le'ec mac ca' u yaante jun tuul u men que'en u yool tin pach jabix a tz'ub ada'a, tan ilic u yaantiquen. Tanil u yaantiquen ti baalo'o, ma' chen inen a tan u yaantiqueni. Tan ilic u yaantic mac u tücaa'tajen,— cu t'an a Jesusu. ");
INSERT INTO mopNT_vpl VALUES ("MK9_38","071_9_38","MRK","9","38","38","Pues te'i. —Noochil, yan jun tuul a winiqui, etel ilic a c'aba' walac u joc'sic a c'ac'asba'al tu yool a maca. Ti wilaj abe'e. Ma' tücünac ala'i ta pach tiqui wetel, mentücü, ti wadaj ti'i ti ma' u betic ti baalo',— cu t'an aj Juan ti'i a Jesusu. ");
INSERT INTO mopNT_vpl VALUES ("MK9_39","071_9_39","MRK","9","39","39","—Ma' a wa'cuntique'ex u betic abe'e. Le'ec mac a tan u betic a milagro etel in c'aba'a, ma' tu paatal u moch beel u yadü' a c'as tin woc'ol,— cu t'an a Jesusu. ");
INSERT INTO mopNT_vpl VALUES ("MK9_40","071_9_40","MRK","9","40","40","—Le'ec mac a ma' tz'iic to'ono, ala'aji, qui' u yool tiqui wetel,— cu t'an a Jesusu. ");
INSERT INTO mopNT_vpl VALUES ("MK9_41","071_9_41","MRK","9","41","41","—Le'ec mac ca' u tz'aa' te'ex ca'ax chen jun p'e pote a siis ja' chen u men que'ene'ex a wool tin pacha, tan u yanat. Tan in wadic te'ex u jajil. Le'ec mac u tz'aj a siis ja' abe'e, bel u cu c'ümü' u jel,— cu t'an a Jesusu. ");
INSERT INTO mopNT_vpl VALUES ("MK9_42","071_9_42","MRK","9","42","42","—Pues te'i. Le'ec mac a tan u yemsic u yool ca' u cüxte u sip'il jun tuul a tan u tz'ocsiquen jabix ti walac u tz'ocsaj t'an a tz'ub ada'a, top c'as a tan u betiqui. Le'ec a tan u betic a c'as abe'e, mas qui' cuchi ca' c'üxbüc a noxi' ca' tu cal ca' pulbuc ich c'ac'naab ti'i ma' u betic abe'e,— cu t'an a Jesus ti'ijoo' u yaj cambala. ");
INSERT INTO mopNT_vpl VALUES ("MK9_43","071_9_43","MRK","9","43","43","—Wa cuchi tane'ex a cüxtic a sip'il chen etel c'u' a tane'ex a betiqui, jabix cuchi a c'ü'e'ex a tan u tz'eec te'ex ca' a cüxte'ex a sip'ili, mas qui' cuchi ca' a p'üte'ex a betic abe'e, bete cuenta a ch'ücaje'ex a c'ü'. Mas toj cuchi ca' a c'üme'ex a cuxtal jumpul etel jun p'eel ilic a c'ü' tuwich ca' culaque'ex ti ca' p'eel a c'ü' y pulbule'ex a ca'a ichil a infiernojo. Ma' yan q'uin u tupbul a c'aac' te'iji,— cu t'an a Jesusu. ");
INSERT INTO mopNT_vpl VALUES ("MK9_44","071_9_44","MRK","9","44","44","—Le'ec ix nocol a walac u janal te'iji, ma' yan q'uin u quimil, ma'ax u tupbul a c'aac' te'iji,— cu t'an a Jesusu. ");
INSERT INTO mopNT_vpl VALUES ("MK9_45","071_9_45","MRK","9","45","45","—Wa cuchi tane'ex a cüxtic a sip'il chen etel tuba walaque'ex a beel jabix cuchi a woque'ex a tan u tz'eec te'ex ca' a cüxte'ex a sip'ili, mas qui' cuchi ca' a p'üte'ex a beel te'i, bete cuenta a ch'ücaje'ex a woc. Mas toj cuchi ca' a c'üme'ex a cuxtal jumpul etel jun tziit ilic a woc tuwich ca' culaque'ex ti ca' tziit a woc y ca' pulbuque'ex ichil a infiernojo. Ma' yan q'uin u tupbul a c'aac' te'iji,— cu t'an a Jesusu. ");
INSERT INTO mopNT_vpl VALUES ("MK9_46","071_9_46","MRK","9","46","46","—Le'ec ix nocol a walac u janal te'iji, ma' yan q'uin u quimil, ma'ax u tupbul a c'aac' te'iji,— cu t'an a Jesusu. ");
INSERT INTO mopNT_vpl VALUES ("MK9_47","071_9_47","MRK","9","47","47","—Wa cuchi tane'ex a cüxtic a sip'il chen etel c'u' a tane'ex a cha'antiqui, jabix cuchi u nec' a wich a tan u tz'eec te'ex ca' a cüxte'ex a sip'ili, mas qui' cuchi a p'ütique'ex a cha'antique'ex abe'e, bete cuenta a joc'saje'ex u nec' a wich abe'e. Mas toj cuchi ca' ocoque'ex tu cuenta Dios etel jun cuul ilic u nec' a wich tuwich ca' culaque'ex ti ca' cuul u nec' a wich y pulbule'ex a ca'a ichil a infiernojo,— cu t'an a Jesusu. ");
INSERT INTO mopNT_vpl VALUES ("MK9_48","071_9_48","MRK","9","48","48","—Le'ec ix nocol a walac u janal te'iji, ma' yan q'uin u quimil, ma'ax u tupbul a c'aac' te'iji,— cu t'an a Jesusu. ");
INSERT INTO mopNT_vpl VALUES ("MK9_49","071_9_49","MRK","9","49","49","—Tulacaloo', bel u ca'a tz'abül a c'aac' tuwichoo' jabix ilic ti walac u tz'abül a taab tuwich a baalche' a walac u chuwbul tu taan a Dios ti tan u tz'abül ti'i,— cu t'an a Jesusu. ");
INSERT INTO mopNT_vpl VALUES ("MK9_50","071_9_50","MRK","9","50","50","—Le'ec a taaba, qui'. C'u' betiqui, ca' joboc u ch'ooch'il a taaba, ¿biqui ca' ch'ooch'ac tucaye'? Yane'ex a cuntal ti toje'ex a na'at jabix cuchi inche'ex a taab a ma' jobi u ch'ooch'ili. Jetz'a'anaque'ex ilic a wool ta bajile'ex,— cu t'an a Jesus ti'ijoo' u yaj cambala. ");
INSERT INTO mopNT_vpl VALUES ("MK10_1","071_10_1","MRK","10","1","1","Pues te'i. Joq'ui ich caj Capernaum a Jesusu. Bini ich cuenta Judea. Bini junxeel a noja' Jordan tu joq'eeb q'uin. Top yaab a cristiano a tücünacoo' tu pach tucaye'il. Caji u ca'ansoo' jabix ilic ti walac u betic ti walac u c'ocholoo' a cristiano etele. ");
INSERT INTO mopNT_vpl VALUES ("MK10_2","071_10_2","MRK","10","2","2","Pues te'i. Naatz'oo' a fariseo u c'aba'oo' u na'at etel a Jesusu. U c'atoo' u yila' wa patal a Jesusu. —¿Qui' wa tu c'axül ti'i a ley u tz'iibtaj aj Moises ca' u p'ütü' u yütan a winiqui?— cu t'an ti'i a Jesusu. ");
INSERT INTO mopNT_vpl VALUES ("MK10_3","071_10_3","MRK","10","3","3","—¿C'u' u yadaj aj Moises ichil a ley u tz'iibtaj ca' a bete'exe?— cu t'an a Jesus ti'ijoo' ti uchi u nuuc. ");
INSERT INTO mopNT_vpl VALUES ("MK10_4","071_10_4","MRK","10","4","4","—Le'ec aj Moisese, u cha'aj a mac ca' u p'ütü' u yütan. Jadi' yan u tz'iibtic u ju'umil u yütan ti'i u p'ütical,— cu t'anoo' ti'i a Jesusu. ");
INSERT INTO mopNT_vpl VALUES ("MK10_5","071_10_5","MRK","10","5","5","—Top chiche'ex a pol, mentüc u tz'iibtaj ti baalo' aj Moisese. ");
INSERT INTO mopNT_vpl VALUES ("MK10_6","071_10_6","MRK","10","6","6","Le'ec ti yaax betabi a yoc'olcab u men a Dioso, u betaj jun tuul ti winic jun tuul ti ix ch'up,— cu t'an a Jesusu. ");
INSERT INTO mopNT_vpl VALUES ("MK10_7","071_10_7","MRK","10","7","7","—“U men baalo' ti yan, le'ec a winiqui, yan u p'ütic u na' u tat ti'i ca' u yet'octe u yütan. ");
INSERT INTO mopNT_vpl VALUES ("MK10_8","071_10_8","MRK","10","8","8","Le'ec a ca' tuulu, p'aatül u ca'a ti jun tuul ilicoo' tun tu bajil. Ti baalo'o, ma' ca' ca' tuuloo' tu bajili. Jun tuul ilicoo' tu bajil. ");
INSERT INTO mopNT_vpl VALUES ("MK10_9","071_10_9","MRK","10","9","9","Le'ec a c'u' a lüc'cunbi u men a Dioso, ma' qui' u jüp'bül u men cristiano,” cu t'an a Dioso,— cu t'an a Jesus ti'ijoo' a fariseo u c'aba'oo' u na'ata. ");
INSERT INTO mopNT_vpl VALUES ("MK10_10","071_10_10","MRK","10","10","10","Pues te'i. Oqui a Jesus ich naj u yet'ocoo' u yaj cambal. C'aatbi ti'i tucaye' yoc'ol abe' u menoo' u yaj cambal. ");
INSERT INTO mopNT_vpl VALUES ("MK10_11","071_10_11","MRK","10","11","11","—Le'ec a winic ca' u p'ütü' u yütan ca' tun u cüxte ulaac' u yütana, chen tan u cüjtal etel,— cu t'an a Jesusu. ");
INSERT INTO mopNT_vpl VALUES ("MK10_12","071_10_12","MRK","10","12","12","—Le'ec ix ch'up ca' u p'ütü' u yicham ca' tun u cüxte ulaac' u yichama, chen tan u cüjtal etel,— cu t'an a Jesusu. ");
INSERT INTO mopNT_vpl VALUES ("MK10_13","071_10_13","MRK","10","13","13","Pues te'i. C'ochesaboo' a tz'ub etel a Jesus ti'i ca' u qui'qui't'antoo'. Le'ecoo' u yaj cambal a Jesusu, u tze'ectajoo' a tanoo' u c'ochesic a tz'ubu, u men ma' qui'oo' tu wich. ");
INSERT INTO mopNT_vpl VALUES ("MK10_14","071_10_14","MRK","10","14","14","Tz'iicaji a Jesus ca' u yilaj c'u' a tanoo' u betic u yaj cambala. —Cha'aj u taleloo' a tz'ub tin wetel. Ma' c'üticoo' u wich. Le'ec boon tuul a walacoo' u tz'ocsaj t'an jabix ala'oo'o, le'ec a ocoloo' u ca'a tu cuenta a Dioso,— cu t'an a Jesus ti'ijoo' u yaj cambala. ");
INSERT INTO mopNT_vpl VALUES ("MK10_15","071_10_15","MRK","10","15","15","—Tan in wadic te'ex u jajil. Mac a ma' u c'ati u c'üm-oolte a Dios jabix ilic ti walac u tz'ocsaj t'an a tz'ubu, le'ec a ma' tu yocol tu cuenta a Dioso,— cu t'an a Jesus ti'ijoo'o. ");
INSERT INTO mopNT_vpl VALUES ("MK10_16","071_10_16","MRK","10","16","16","U meectajoo' jujun tuulil a tz'ub a Jesusu. U tz'aj u c'ü' yoc'oloo', y u c'ajsaj a Dios yoc'oloo'. ");
INSERT INTO mopNT_vpl VALUES ("MK10_17","071_10_17","MRK","10","17","17","Pues te'i. Tan cuchi u joc'ol te'i a Jesus ti c'ochi ti alca' jun tuul a winic etel. Xonlaji tu taan. —Maestro, top qui'ech. ¿C'u' a yan in betic ti'i ca' in naalte a cuxtal a ma' yan q'uin u jobolo?— cu t'an ti'i a Jesusu. ");
INSERT INTO mopNT_vpl VALUES ("MK10_18","071_10_18","MRK","10","18","18","—¿C'u' ca'a tan a wadic ti qui'en? Ma' yan mac a qui'i, jadi' a Dioso,— cu t'an a Jesus ti'iji. ");
INSERT INTO mopNT_vpl VALUES ("MK10_19","071_10_19","MRK","10","19","19","—A weel c'u' a tz'iiba'an ichil a ley u men aj Moisese. “Ma' beel ti cüjtal etel a ca'ax macaca. Ma' beel ti quimsaj. Ma' beel ti xuuch'. Ma' beel ti tzol etel tus. Ma' beel ti cho'. Tz'oques u yanil a na' a tat,” cu t'an a leye,— cu t'an a Jesusu. ");
INSERT INTO mopNT_vpl VALUES ("MK10_20","071_10_20","MRK","10","20","20","—Maestro, in laj tz'ocsaj tulacal abe' asto ti tz'uben to y tac leeb,— cu t'an a winiqui. ");
INSERT INTO mopNT_vpl VALUES ("MK10_21","071_10_21","MRK","10","21","21","A Jesusu, u cha'antaj a winiqui. Yaj u yubi. —Yan to jun p'eel c'u' a ma' a tz'ocsaja. Ca' xiquech a cono' tulacal a c'u' a yan teche. T'oxo u tool ti'ijoo' a otzili. Ca' a bete' ti baalo'o, bel u ca'a ti yantal tech a ayic'alil ti ca'an. Ca' tun talaquech tin pach,— cu t'an a Jesus ti'iji. ");
INSERT INTO mopNT_vpl VALUES ("MK10_22","071_10_22","MRK","10","22","22","Le'ec ca' u yubaj abe'e, ma' ca' qui' u yool a winiqui. Yaj u yool ti bini u men top yaab u ayic'alil. ");
INSERT INTO mopNT_vpl VALUES ("MK10_23","071_10_23","MRK","10","23","23","Pues te'i. A Jesusu, u cha'antajoo' a que'en tu xoyo. —Chücyajil u yocol tu c'ü' a Dios a winic a yan u ayic'alil yoc'olcaba,— cu t'an a Jesus ti'ijoo' u yaj cambala. ");
INSERT INTO mopNT_vpl VALUES ("MK10_24","071_10_24","MRK","10","24","24","Sa'too' u yool u yaj cambal ca' u yubajoo' a t'an abe'e. —In waj cambale'ex,— cu t'an a Jesus ti'ijoo'o. —Chücyajil u yocol tu c'ü' a Dios a winic a yan u ayic'alil yoc'olcaba,— cu t'an a Jesus ti'ijoo' u yaj cambala. ");
INSERT INTO mopNT_vpl VALUES ("MK10_25","071_10_25","MRK","10","25","25","—Ma' yan biqui u manül jun tuul a noxi' baalche' u c'aba' camello tu potolal a puutzu, u men noxi' ta wichi. Mas top yaj tucaye'il ca' ococ jun tuul ayic'al tu c'ü' a Dios tuwich u mansabül a camello tu potolal a puutzu,— cu t'an a Jesusu. ");
INSERT INTO mopNT_vpl VALUES ("MK10_26","071_10_26","MRK","10","26","26","Top sa'too' u yool u yaj cambal tu jajil. —Entonces ma' tu sa'albül a ayic'ala, y wa ma' tu paatal u sa'albül a ayic'ala, ma'ax mac wal a bel u ca'a sa'albülü,— cu t'anoo'. ");
INSERT INTO mopNT_vpl VALUES ("MK10_27","071_10_27","MRK","10","27","27","Le'ec a Jesusu, u cha'antajoo' u yaj cambal. —Le'ecoo' a cristianojo, ma' yan biqui u mansic a camello tu potolal a puutzu, pero ma' baalo' etel a Diosi. Le'ec a Dioso, u paatal u betic tulacal asto ti u sa'altical a ayic'al xan,— cu t'an a Jesus ti'ijoo'o. ");
INSERT INTO mopNT_vpl VALUES ("MK10_28","071_10_28","MRK","10","28","28","—Uxtun ino'ono, ¿c'u' a bel ti ca'a ti c'ümü' u men ti p'ütaj tulacal ti'i ca' xico'on ta pach jabix ilic a wadaj ti'i a ayic'ala?— cu t'an aj Pedro ti'i u men c'u' u yadaj a Jesus ti'i a winiqui. ");
INSERT INTO mopNT_vpl VALUES ("MK10_29","071_10_29","MRK","10","29","29","—Tan in wadic te'ex u jajil. Tulacal a jujun tuul u p'ütajoo' u yotoch chen ti'i u tz'ocsicalenoo'o, y ti'i u yadicaloo' u pectzil a Dioso, beloo' u cu c'ümü' ti mas yaab u qui'il a Dios wa'ye' yoc'olcaba. Baalo' ilic mac u p'ütaj u sucu'un, wa u quic, wa u yitz'in, wa u na', wa u tat, wa u mejen, wa u yal, wa u cuuchil chen ti'i ca' u tz'ocsicalenoo' y ti'i u yadicaloo' u pectzil a Dioso, ");
INSERT INTO mopNT_vpl VALUES ("MK10_30","071_10_30","MRK","10","30","30","beloo' ilic u cu c'ümü' ti mas yaab u qui'il a Dios wa'ye' yoc'olcaba. Bel u ca'a ti joc'ol ti'ijoo' jabix yan ti yaab u yotochoo' ti posado, jabix yan ti yaab cuchi u jeloo' u sucu'un, u jeloo' u quic, u jeloo' u yitz'in, u na', u mejen, u yal, u cuuchil. C'u' betiqui, beloo' ilic u ca'a betabül ti'ijoo' a yaja. Beloo' ilic u ca'a u c'ümoo' a cuxtal a ma' yan q'uin u jobol tu q'uinil a wataca,— cu t'an a Jesusu. ");
INSERT INTO mopNT_vpl VALUES ("MK10_31","071_10_31","MRK","10","31","31","—Yan ti yaab a jabix taanil que'en wa'ye' u men u meyaj. Tu yaamoo' abe'e, yanoo' a beloo' u ca'a ti cuntal pachil tu cuenta a Dioso. Yan ilic ti yaab a pachil que'en wa'ye' a taanil u beel te'iji,— cu t'an a Jesusu. ");
INSERT INTO mopNT_vpl VALUES ("MK10_32","071_10_32","MRK","10","32","32","Pues te'i. Le'ec a Jesusu, que'en ti bej u yet'ocoo' u yaj cambal. Tanoo' u beel ich caj Jerusalen. Le'ec a Jesus aj ch'a'beje. Sa'too' u yool u yaj cambal u men tan u ca' beel Jerusalen u men te'i motztzil. Yanoo' ulaac' a que'enoo' tu pach a Jesusu, pero saacoo'. A Jesusu, u ca' püyajoo' u yaj cambal ca' joc'oc tu yaamoo' u chucaan a cristiano ca' xicoo' tu junal etel ala'aji. Caji u yadü' ti'ijoo' c'u' a bel u ca'a ti uchul ti'iji. ");
INSERT INTO mopNT_vpl VALUES ("MK10_33","071_10_33","MRK","10","33","33","—U'ye'ex. Tan ti beel ich caj Jerusalen. Le'ec inen a yanajeen ti cristianojili, bel in ca'a c'ubbul ti'ijoo' u noochiloo' u yaj mansaj t'an a cristiano ti'i a Dioso, u yet'ocoo' u yaj ca'ansajil u ley aj Moisese,— cu t'an a Jesusu. —Beloo' u cu yadü' in quimil. Le'ec ala'oo'o, beloo' u cu c'ubeen ti'ijoo' a ma' Israele,— cu t'an a Jesus ti'ijoo' u yaj cambala. ");
INSERT INTO mopNT_vpl VALUES ("MK10_34","071_10_34","MRK","10","34","34","—Le'ecoo' a ma' Israele, beloo' u cu p'a'asteen. Beloo' u cu tuubteen. Beloo' u cu jütz'een etel jatz'. Beloo' u cu quimseen. Bel in ca'a ti ca' cuxtal tu yox p'eel q'uin,— cu t'an a Jesusu. ");
INSERT INTO mopNT_vpl VALUES ("MK10_35","071_10_35","MRK","10","35","35","Pues te'i. Le'ec aj Jacob etel aj Juana, u yitz'inoo' u sucu'unoo' u bajil. Zebedeo u c'aba'oo' u tat. C'ochoo' a ca' tuul abe' etel a Jesusu. —Maestro, ti c'ati cuchi ca' a tz'aa' to'on le'ec a c'u' a bel ti ca'a ti c'aate teche,— cu t'anoo' ti'i a Jesusu. ");
INSERT INTO mopNT_vpl VALUES ("MK10_36","071_10_36","MRK","10","36","36","—¿C'u' a c'ate'ex ca' in tz'aa' te'exe?— cu t'an ti'ijoo'. ");
INSERT INTO mopNT_vpl VALUES ("MK10_37","071_10_37","MRK","10","37","37","—Tz'a to'on ti chucul ti yanil ti'i ca' tinlaco'on ta tzeel le'ec ti ocoquech ti reyili. Jujun tuulo'on jujun xeelech,— cu t'anoo' ti'i a Jesusu. ");
INSERT INTO mopNT_vpl VALUES ("MK10_38","071_10_38","MRK","10","38","38","—Ma' a weele'ex c'u' a tane'ex a c'aatiqui,— cu t'an a Jesus ti'ijoo'o. —¿Jede'ec wa u paatale'ex a c'ümic a yaj a bel in quin c'ümü'ü, jabix cuchi tane'ex a wuq'uic a top yaj a yan ichil in pote a bel in quin wuc'u'u, wa xan jabix cuchi a c'ümique'ex a ocja' ichil a top yaj jabix a bel in quin c'üm'ü?— cu t'an a Jesus ti'ijoo'o. ");
INSERT INTO mopNT_vpl VALUES ("MK10_39","071_10_39","MRK","10","39","39","—Jede'eque,— cu t'anoo' ti'i. —Bele'ex a ca'a a wuc'u' u ba'al in pote wa bele'ex a ca'a a c'ümü' in wocja' jabix ilic a bel in quin c'ümü'ü,— cu t'an a Jesusu. ");
INSERT INTO mopNT_vpl VALUES ("MK10_40","071_10_40","MRK","10","40","40","—C'u' betiqui, a tintal tin tzeele, ma' inen jaj teni. Le'ec mac a bel u ca'a ti tintal te'i, ac yeeta'an tun,— cu t'an a Jesus ti'i a ca' tuul u yaj cambala. ");
INSERT INTO mopNT_vpl VALUES ("MK10_41","071_10_41","MRK","10","41","41","Pues te'i. Le'ec ca' u yubajoo' c'u' u c'aatajoo' aj Jacob y aj Juana, cajoo' ti tz'iictal a diez tuul u chucaan u yaj cambala. ");
INSERT INTO mopNT_vpl VALUES ("MK10_42","071_10_42","MRK","10","42","42","Le'ec a Jesusu, u püyajoo' u yaj cambal tu tzeel. —Inche'exe, a weele'ex. Le'ec boon tuul a ma' Israel a noochoo' u wichil u meyaja, walacoo' u betic u yanil tu yaamoo' a que'en tu c'ü'ü. Le'ecoo' a tz'aboo' u yanil u men u noochiloo'o, top walacoo' u betic u yanil ti tücaa',— cu t'an a Jesus ti'ijoo'o. ");
INSERT INTO mopNT_vpl VALUES ("MK10_43","071_10_43","MRK","10","43","43","—Ma' qui' ca' yanac ti baalo' ta yaame'exe. Le'ec mac ta yaame'ex u c'ati ti nooch u wichil u meyaja, yan u yaanticoo' u chucaan etel tulacal,— cu t'an a Jesusu. ");
INSERT INTO mopNT_vpl VALUES ("MK10_44","071_10_44","MRK","10","44","44","—Le'ec mac u c'ati ti top nooch u wichil u meyaj tucaye'il ta yaame'exe, yan u betic u bajil jabix jumpul ma' nooch u wichil u meyaj. Yan u mas aanticoo' tulacal,— cu t'an a Jesusu. ");
INSERT INTO mopNT_vpl VALUES ("MK10_45","071_10_45","MRK","10","45","45","—Yan u betic jabix ilic a walac in betic inen a yanajeen ti cristianojili. Ma' taleen ti'i ca' aantabüqueni. Taleen ti'i anat. Taleen ti'i ca' in c'ubu' in cuxtal ti'i ca' in sa'altoo' a yaaba,— cu t'an a Jesusu. ");
INSERT INTO mopNT_vpl VALUES ("MK10_46","071_10_46","MRK","10","46","46","Pues te'i. C'ochi a Jesus ich caj Jerico u yet'ocoo' u yaj cambal. Le'ec ti tanoo' u joc'ol ichil a caja, top yaaboo' a cristiano a tücünacoo' tu pacha. Tina'an ti que'en chi' bej jun tuul a ch'oopo. Aj Bartimeo u c'aba' a winic abe'e. Aj Timeo u c'aba' u tat. ");
INSERT INTO mopNT_vpl VALUES ("MK10_47","071_10_47","MRK","10","47","47","Le'ec ca' u yubaj ti tan u manül te'i a Jesus a tali Nazarete, caji ti t'an ti chich. —Jesus, inchech u mam aj quimen rey David a tan u paac'baanülü. Ch'a'a in wotzilil,— cu t'an ti chich. ");
INSERT INTO mopNT_vpl VALUES ("MK10_48","071_10_48","MRK","10","48","48","—Top lo'peequech,— cu t'anoo' a pimil cristiano ti'iji. C'u' betiqui, jadi' u pul-ooltaj u yadic ti mas yaab. —Inchech u mam aj quimen rey David a tan u paac'baanülü. Ch'a'a in wotzilil,— cu t'an ti chich. ");
INSERT INTO mopNT_vpl VALUES ("MK10_49","071_10_49","MRK","10","49","49","Wa'laji a Jesusu. U yadaj ca' püybüc a winiqui. —P'ütü a saaquili. Liq'uen. Tan u püyiquech,— cu t'anoo' ti'i a ch'oopo. ");
INSERT INTO mopNT_vpl VALUES ("MK10_50","071_10_50","MRK","10","50","50","U jan joc'saj u lichpach. Wa'laji ti jomol. Bini etel a Jesusu. ");
INSERT INTO mopNT_vpl VALUES ("MK10_51","071_10_51","MRK","10","51","51","—¿C'u' a c'ati ca' in bete' tech?— cu t'an a Jesus ti'iji. —Noochil, in c'ati cuchi ca' sasilac in wich,— cu t'an a ch'oop ti'iji. ");
INSERT INTO mopNT_vpl VALUES ("MK10_52","071_10_52","MRK","10","52","52","—A tz'ocsaj ti patalen in ch'aneseech, mentücü, ch'aneech. Ca' xiquech tuba a c'ati,— cu t'an a Jesus ti'iji. Tu seebal uchi u cha'an. Caji ti beel tu pach a Jesus ti bej. ");
INSERT INTO mopNT_vpl VALUES ("MK11_1","071_11_1","MRK","11","1","1","Pues te'i. Le'ec ti nütz'ünacoo' ti a caj Jerusalene, c'ochoo' ti a caj Betfage a caj Betania a que'en tuwich a witz u c'aba' Olivos. Le'ec a Jesusu, u c'ati u tücaa'te ca' tuul u yaj cambal ichil a nene' caja. ");
INSERT INTO mopNT_vpl VALUES ("MK11_2","071_11_2","MRK","11","2","2","—Ca' xique'ex ichil a caj a que'en tiqui taana. Le'ec ti tane'ex to a wocol ichil a caja, bele'ex a ca'a a cüxte a tzimin a tz'itz'i' to c'üxa'an te'i. Ma'ax to mac tinlac tu pach. Piti. Tales wa'ye',— cu t'an ti'i a ca' tuulu. ");
INSERT INTO mopNT_vpl VALUES ("MK11_3","071_11_3","MRK","11","3","3","—Wa mac ca' u c'aate te'ex c'u' ca'a ti tane'ex a pitiqui, baala' ca' a nuucte'ex: “C'abeet ti'i a Noochtzili. Bel u cu yusq'uinte ti jomol,” que'exac ti'i,— cu t'an a Jesusu. ");
INSERT INTO mopNT_vpl VALUES ("MK11_4","071_11_4","MRK","11","4","4","Pues te'i. Binoo' a ca' tuulu. U cüxtajoo' a tz'i tzimin a c'üxa'an chi' naj ti bej. U pitajoo'. ");
INSERT INTO mopNT_vpl VALUES ("MK11_5","071_11_5","MRK","11","5","5","Tu yaamoo' a cristiano a wa'anoo' te'iji, yanoo' u c'aataj ti'i. —¿C'u' ca'a tane'ex a pitic a tz'i' tzimini?— cu t'anoo' ti'i a ca' tuulu. ");
INSERT INTO mopNT_vpl VALUES ("MK11_6","071_11_6","MRK","11","6","6","U yadajoo' ti'i a jabix ilic a aalbi ti'ijoo' u men a Jesusu, mentücü, u cha'ajoo' ca' u bensoo' a tz'i' tzimini. ");
INSERT INTO mopNT_vpl VALUES ("MK11_7","071_11_7","MRK","11","7","7","U talesajoo' a tz'i' tzimin etel a Jesusu. U xit'ajoo' u noc' yoc'ol. Tinlaji a Jesus tu pach. ");
INSERT INTO mopNT_vpl VALUES ("MK11_8","071_11_8","MRK","11","8","8","Yaaboo' a cristianojo, u xit'ajoo' u noc' ti lu'um ti bej. Ulaac'oo'o, u ch'ücajoo' u le' tac a che'e. U tz'ajoo' ti bej. ");
INSERT INTO mopNT_vpl VALUES ("MK11_9","071_11_9","MRK","11","9","9","Le'ecoo' a cristiano a que'enoo' tu taan a Jesus eteloo' a cristiano a que'enoo' tu pacha, tanoo' u t'an ti chich ti tanoo' u beel. —Ti c'ati Dios ca' u tz'aa' u qui'il u yool u yaj tücaa', le'ec a tan to u yudel. ");
INSERT INTO mopNT_vpl VALUES ("MK11_10","071_11_10","MRK","11","10","10","Le'ec a rey a wataca, cuntal u ca'a ti qui' a cristiano etele. Bel u cu bete' jabix u betaj ti uchben mamaa' le'ec aj rey Davidi. Ade'ex u qui'il a Dioso,— cu t'anoo' a cristiano ti chichi. ");
INSERT INTO mopNT_vpl VALUES ("MK11_11","071_11_11","MRK","11","11","11","Pues te'i. Le'ec ti oqui a Jesus ich caj Jerusalen, oqui ichil u yotoch a Dioso. U laj cha'antaj tulacal a c'u' a yan ichili. Mani tun a q'uini, mentücü, joq'ui te'i. Bini ti posado ich caj Betania u yet'ocoo' u yaj cambal. ");
INSERT INTO mopNT_vpl VALUES ("MK11_12","071_11_12","MRK","11","12","12","Pues te'i. Le'ec ti joc'oo' ich caj Betania tu samalili, wi'ij a Jesusu. ");
INSERT INTO mopNT_vpl VALUES ("MK11_13","071_11_13","MRK","11","13","13","U yilaj a che' higo a que'en ti naacha. Yan tun u le', mentücü, yan cuchi u wich. Bini u yila' wa yan u wich. Le'ec ti c'ochi te'iji, u yilaj ti ma' yan u wich. Jadi' u le' a yana. Ma'ax to c'ochoc u q'uinil u wich a che' higo cuchi. ");
INSERT INTO mopNT_vpl VALUES ("MK11_14","071_11_14","MRK","11","14","14","—Jumpul ma'ax mac a bel u cu jante a wich,— cu t'an ti'i a che'e. U'yajbi u t'an u menoo' u yaj cambal. ");
INSERT INTO mopNT_vpl VALUES ("MK11_15","071_11_15","MRK","11","15","15","Pues te'i. Oqui a Jesus ichil u yotoch a Dioso. Caji u tooltoo' boon a tanoo' u conol y q'uex te'i. U piquixc'ü'tajoo' u mesajil a tanoo' u jüp' taq'uini. U piquixc'ü'tajoo' ilic u silla a tanoo' u con paloma. ");
INSERT INTO mopNT_vpl VALUES ("MK11_16","071_11_16","MRK","11","16","16","Le'ec a yanoo' u cuch a tanoo' u tz'eec u benil ichil u yotoch a Dioso, ma' u cha'ajoo' u manül te'i u men ma' bej ta wichi. ");
INSERT INTO mopNT_vpl VALUES ("MK11_17","071_11_17","MRK","11","17","17","Caji u ca'ansoo' a cristiano a Jesusu. —Baala' ti tz'iiba'an ichil u ju'um a Dioso. “Aalbül u ca'a ti le'ec in wotocho, le'ec u cuuchil in c'ajsabeeb u men tulacal a caj yoc'olcaba. C'u' betic inche'exe, tane'ex a betic ti chen u cuuchiloo' aj xuuch' in wotoch,” cu t'an a t'an a tz'iiba'ana,— cu t'an a Jesusu. ");
INSERT INTO mopNT_vpl VALUES ("MK11_18","071_11_18","MRK","11","18","18","Pues te'i. Le'ecoo' u noochil u yaj mansaj t'an a cristiano ti'i a Dioso, u yet'ocoo' u yaj ca'ansajil u ley aj Moisese, u yubajoo' c'u' u yadaj a Jesusu. Cajoo' u cüxte biqui ca' u quimes a Jesusu. Saacoo' ti'i a Jesus u men tulacaloo' a cristianojo, sa'too' u yool u yuboo' u t'an a Jesusu. ");
INSERT INTO mopNT_vpl VALUES ("MK11_19","071_11_19","MRK","11","19","19","Le'ec ti oqui a q'uini, joq'ui a Jesus ich caj u yet'ocoo' u yaj cambal. ");
INSERT INTO mopNT_vpl VALUES ("MK11_20","071_11_20","MRK","11","20","20","Pues te'i. Ti jatz'ca'a, tanoo' u yusc'al ich caj Jerusalen. Le'ec ti que'enoo' to ti bej, u yilajoo' a che' higo a aalbi ti'i ti ma' tu ca' tz'eec u wich u men a Jesusu. Tiquin tun a che' tac tu can. ");
INSERT INTO mopNT_vpl VALUES ("MK11_21","071_11_21","MRK","11","21","21","C'aji ti'i aj Pedro c'u' u yadaj a Jesus ti'i a che' biq'uin ado'o. —Noochil, ila a che' ado'o. A wadaj a t'an yoc'ol a che' ado'o, y tiqui tun,— cu t'an aj Pedro ti'iji. ");
INSERT INTO mopNT_vpl VALUES ("MK11_22","071_11_22","MRK","11","22","22","—Tanaque'ex cuchi a tz'ocsic a Dios tu jajil. ");
INSERT INTO mopNT_vpl VALUES ("MK11_23","071_11_23","MRK","11","23","23","Tan in wadic te'ex u jajil. Uchac yan mac ca' u yadü' ti'i a witz ada'a, ca' joc'sabüc ca' pulbuc ich c'ac'naab. Wa cuchi ma' yan q'uin u tuclic ti wa ma' u yuchulu, chen tan u tuclic ti bel u ca'a ti uchul c'u' u yadaja, bel u ca'a betabül c'u' u yadaja,— cu t'an a Jesus ti'ijoo' u yaj cambala. ");
INSERT INTO mopNT_vpl VALUES ("MK11_24","071_11_24","MRK","11","24","24","—U men baalo' ti yan, tan in wadic te'ex. Tulacal a c'u' a tane'ex a c'aatic ti'i a Dioso, tz'ocse'ex ti bele'ex a ca'a a c'ümü', y bele'ex a ca'a a c'ümü',— cu t'an a Jesusu. ");
INSERT INTO mopNT_vpl VALUES ("MK11_25","071_11_25","MRK","11","25","25","—Le'ec ti tane'ex a t'an etel a Dioso, wa yan mac a yan u sip'il te'exe, sa'tese'ex ti'i. Ca' a bete'ex ti baalo'o, jede'ec ilic u sa'tesic te'ex a sip'il a Tate'ex a que'en ti ca'ana,— cu t'an a Jesusu. ");
INSERT INTO mopNT_vpl VALUES ("MK11_26","071_11_26","MRK","11","26","26","—C'u' betiqui, wa ma' ta sa'tesique'ex u sip'il ulaac'a, ma' ilic tu sa'tesabüle'ex a sip'il inche'ex u men a Tate'ex ti ca'an,— cu t'an a Jesusu. ");
INSERT INTO mopNT_vpl VALUES ("MK11_27","071_11_27","MRK","11","27","27","Pues te'i. Ca' oqui a Jesus ich caj Jerusalen. Tan u ximbal ichil u yotoch a Dioso, ti c'ochoo' u noochil u yaj mansaj t'an a cristiano ti'i a Dios u yet'ocoo' u yaj ca'ansajil u ley aj Moises eteloo' a nucuch winiqui. ");
INSERT INTO mopNT_vpl VALUES ("MK11_28","071_11_28","MRK","11","28","28","—¿C'u' a yanil ca' a bete' a jabix a tan a betiqui? ¿Mac u tz'aj tech a yanil a bete' abe'e?— cu t'anoo' ti'i a Jesusu. ");
INSERT INTO mopNT_vpl VALUES ("MK11_29","071_11_29","MRK","11","29","29","—Bel in quin c'aate te'ex jun p'eel a t'ana. Wa cuchi ca' a nuucte'ex tene, bel ilic in quin wadü' te'ex mac u tz'aj in yanil tanil in betic c'u' a tan in betiqui,— cu t'an a Jesus ti'ijoo'o. ");
INSERT INTO mopNT_vpl VALUES ("MK11_30","071_11_30","MRK","11","30","30","—Le'ec a ocja' u tz'aj aj Juana, ¿ti'i Dios wa, wa ti'i cristiano? Ade'ex ten,— cu t'an a Jesus ti'ijoo'o. ");
INSERT INTO mopNT_vpl VALUES ("MK11_31","071_11_31","MRK","11","31","31","Cajoo' u tzicbalte abe' tu bajiloo'. —Wa ca' ti wadü' wa ti'i Dios a ocja' u tz'aj aj Juana, bel u cu c'aate to'on c'u' ca'a ma' ti tz'ocsaj,— cu t'anoo' tu bajil. ");
INSERT INTO mopNT_vpl VALUES ("MK11_32","071_11_32","MRK","11","32","32","—Wa ca' ti wadü' wa ti'i a cristianojo, ma' qui',— cu t'anoo' u men saacoo' ti'i u yaabil a cristiano u men tanoo' u tz'ocsic a cristiano ti le'ec aj Juana, tu jajil jun tuul u yadaj u t'an a Dioso. ");
INSERT INTO mopNT_vpl VALUES ("MK11_33","071_11_33","MRK","11","33","33","—Ma' ti weel biqui'il u yanil aj Juana,— cu t'anoo' ti'i a Jesus ti uchoo' u nuucu. —Y ma' xan tin wadic te'ex c'u' in yanil in bete' c'u' a walac in betiqui,— cu t'an a Jesus ti'ijoo'o. ");
INSERT INTO mopNT_vpl VALUES ("MK12_1","071_12_1","MRK","12","1","1","Pues te'i. Le'ec a Jesusu, caji u yadü' a mucult'an ti'ijoo' a cristianojo. —Jun tuul a winiqui, u püc'aj u cuuch u püc'aal. U cotaj. U betaj c'u' aj etel u joc'sic u c'a' u wich a püc'aala. U betaj ilic jun p'eel a rancho a ca'nal ti'i u cününbeeb a püc'aala. U tz'aj ti maanil u cuuch a püc'aala. Yan u tz'abül ti'i tz'etz'eecac u wich ti'i u tool u maanbeeb. Bini u yumil ichil ulaac' a lu'umu,— cu t'an a Jesusu. ");
INSERT INTO mopNT_vpl VALUES ("MK12_2","071_12_2","MRK","12","2","2","—Le'ec ti c'ochi u q'uinil u c'ümic tz'eecac u wich u püc'aal le'ec u tool u maanbeebe, u tücaa'taj jun tuul u yaj meyaj eteloo',— cu t'an a Jesusu. ");
INSERT INTO mopNT_vpl VALUES ("MK12_3","071_12_3","MRK","12","3","3","—C'u' betiqui, u müchajoo' u yaj meyaj u yumil u cuuch a püc'aala. U jütz'ajoo'. Ma'ax c'u' u tz'ajoo' ti'iji. Chen u tz'ajoo' ti'i ca' usc'ac ti baalo',— cu t'an a Jesusu. ");
INSERT INTO mopNT_vpl VALUES ("MK12_4","071_12_4","MRK","12","4","4","—U ca' tücaa'taj ulaac' jun tuul u yaj meyaj u yumil u cuuch a püc'aala. U yajcuntajoo' ala'i tu pol. U betajoo' a c'as ti'iji,— cu t'an a Jesusu. ");
INSERT INTO mopNT_vpl VALUES ("MK12_5","071_12_5","MRK","12","5","5","—Tücaa'bi ulaac' tucaye'. U quimsajoo'. Baalo' ilic a uchi ti'i ulaac'oo'o. Yan u jütz'ajoo'. Yan u quimsajoo',— cu t'an a Jesusu. ");
INSERT INTO mopNT_vpl VALUES ("MK12_6","071_12_6","MRK","12","6","6","—Ti'i u yumil a colo, yan to jun tuul ulaac' a bel u cu tücaa'te eteloo' tu yada'. Ala'aji, u mejen. Yajtzil. “Jede'ecoo' u tz'ocsic u yanil in mejen,” cu t'an tu bajil,— cu t'an a Jesusu. ");
INSERT INTO mopNT_vpl VALUES ("MK12_7","071_12_7","MRK","12","7","7","—Pues te'i. “Le'ec ada' u mejen u yumil u cuuch a püc'aala,” cu t'anoo' aj maan cuuch püc'aal tu bajil. “Co'ne'ex ti quimes ca' p'aatüc to'on u cuuchil a püc'aala,” cu t'anoo' tu bajil,— cu t'an a Jesusu. ");
INSERT INTO mopNT_vpl VALUES ("MK12_8","071_12_8","MRK","12","8","8","—U müchajoo'. U quimsajoo'. U pulajoo' pach cot. ");
INSERT INTO mopNT_vpl VALUES ("MK12_9","071_12_9","MRK","12","9","9","¿C'u' a bel u ca'a betabül ti'ijoo' u men u yumil u cuuchil a püc'aala? Bel u ca'a ti c'ochol u quimesoo' a tanoo' u maantic u cuuchil a püc'aala. Bel u cu tz'aa' ti'i ulaac' ca' u maante,— cu t'an a Jesus ich mucult'an yoc'ol c'u' u betajoo' ti'i u yaj tücaa' a Dioso. ");
INSERT INTO mopNT_vpl VALUES ("MK12_10","071_12_10","MRK","12","10","10","—A xocaje'ex ichil u ju'um a Dios a t'an ada' a bel to in quin wadü' te'exe,— cu t'an a Jesus ti'ijoo'o. —“Le'ec a jun cuul a tunich a ma' u c'atiintajoo' cuchi aj men naja, culaji ilic ti'i u wa'taan a naja. ");
INSERT INTO mopNT_vpl VALUES ("MK12_11","071_12_11","MRK","12","11","11","Le'ec a Noochtzil u tz'aj ca' culac ti baalo'. Top quich'pan tiqui wich c'u' u betaja.” Baalo' ti tz'iiba'an,— cu t'an a Jesusu. ");
INSERT INTO mopNT_vpl VALUES ("MK12_12","071_12_12","MRK","12","12","12","Pues te'i. Le'ecoo' u noochil u yaj mansaj t'an a cristiano ti'i a Dios u yet'ocoo' u yaj ca'ansajil u ley aj Moises eteloo' a nucuch winiqui, u na'tajoo' ti le'ec ilic ala'oo' a tanoo' u tzicbalbül jabix aj maan cuuch püc'aaloo' ichil a mucult'an u yadaj a Jesusu. U c'atiintajoo' cuchi müchü' a Jesusu. C'u' betiqui, saacoo' ti'i u chucaan a cristianojo, mentücü, joc'oo' te'i. Binoo'. ");
INSERT INTO mopNT_vpl VALUES ("MK12_13","071_12_13","MRK","12","13","13","Pues te'i. Yan jujun tuul tu yaamoo' a fariseo etel a herodiano u c'aba'oo' u na'ata, tücaa'boo' ca' xicoo' etel a Jesusu. U c'atiintajoo' cuchi u cho' a Jesus etel ilic a c'u' a tan u yadiqui. ");
INSERT INTO mopNT_vpl VALUES ("MK12_14","071_12_14","MRK","12","14","14","C'ochoo' etel a Jesusu. —Maestro, ti weel ti walac a wadic a jaja. Ma' ta'ach a tz'eec ti cuenta wa nooch u wichil u meyaj a maca, wa ma'a. Walac a ye'ic u jajil yoc'ol biqui u c'ati a Dioso. ¿Yan wa ti bo'tic a taq'uin a walac u tücaa'tic c'aatbül u men a rey Cesara, wa ma'? ");
INSERT INTO mopNT_vpl VALUES ("MK12_15","071_12_15","MRK","12","15","15","¿Qui' wa ca' ti bo'te wa ma' qui'?— cu t'anoo' ti'i a Jesusu. Le'ec a Jesusu, u yeel ti chen tanoo' u cho'. —¿C'u' ca'a tane'ex a yaaltic a wila' wa patalen? Tales ten a taq'uin ti'i ca' in wila',— cu t'an a Jesus ti'ijoo'o. ");
INSERT INTO mopNT_vpl VALUES ("MK12_16","071_12_16","MRK","12","16","16","U talesajoo' a taq'uin jun p'eele. —¿Mac aj ich a que'en tuwichi? ¿Mac ti'i a c'aba' a que'en te'iji?— cu t'an ti'ijoo'. —Le'ec a reye,— cu t'anoo' ti'i. ");
INSERT INTO mopNT_vpl VALUES ("MK12_17","071_12_17","MRK","12","17","17","—Ca' tz'aa' ti'i a rey le'ec a c'u' a ti'i a reye. Ca' tz'aa' ti'i a Dios le'ec a c'u' a ti'i a Dioso,— cu t'an a Jesus ti'ijoo'o. Sa'too' u yool tu jajil u men biqui ti nuucboo'. ");
INSERT INTO mopNT_vpl VALUES ("MK12_18","071_12_18","MRK","12","18","18","Pues te'i. C'ochoo' etel a Jesus a saduceo u c'aba'oo' u na'ata. Ala'oo'o, ma' ta'achoo' u tz'ocsic wa ca' cuxtal u ca'a a quimene. U c'aatajoo' ti'i. ");
INSERT INTO mopNT_vpl VALUES ("MK12_19","071_12_19","MRK","12","19","19","—Maestro, le'ec aj Moisese, baala' u tz'iibtaj to'on: “Le'ec ca' u cüxte u yütan a winic ca' tun quimic ti ma' yan u mejene, le'ec u yitz'in a quimene, yan u yütantic u mu' ca' yanac jun tuulac u mejen jabix u mejen a quimene.” Baalo' u tz'iibtaj to'on aj Moisese,— cu t'anoo' ti'i a Jesusu. ");
INSERT INTO mopNT_vpl VALUES ("MK12_20","071_12_20","MRK","12","20","20","—Pues te'i. Yan siete tuul a winiqui, u yitz'inoo' u bajil. U cüxtaj u yütan a jun tuulu. Quimi ti ma' yanaji u mejen. ");
INSERT INTO mopNT_vpl VALUES ("MK12_21","071_12_21","MRK","12","21","21","Le'ec u yitz'ini, u yütantaj u mu'. Quimi ilic ti ma' yan u mejen. Baalo' ilic ulaac' u yitz'ini. ");
INSERT INTO mopNT_vpl VALUES ("MK12_22","071_12_22","MRK","12","22","22","Baalo' ilic a uchi ti'i a siete tuulu. Laj quimoo' ti ma' yanajoo' u mejen. Mas pachili, quimi ilic a nooch'upu,— cu t'anoo' ti'i a Jesusu. ");
INSERT INTO mopNT_vpl VALUES ("MK12_23","071_12_23","MRK","12","23","23","—Pues te'i. Le'ec ti ca' cuxlacoo' a quimene, ¿mac tu yaam a siete tuul u yicham a nooch'up abe'e? Tulacal a siete tuulu, u laj ichamtaj ala'aji,— cu t'anoo' a saduceo u c'aba'oo' u na'at ti'i a Jesusu. ");
INSERT INTO mopNT_vpl VALUES ("MK12_24","071_12_24","MRK","12","24","24","—Ma' toje'ex a t'an u men ma' a weele'ex u t'an a Dioso, ma'ax u muc' a Dioso,— cu t'an a Jesus ti'ijoo' ti uchi u nuuc. ");
INSERT INTO mopNT_vpl VALUES ("MK12_25","071_12_25","MRK","12","25","25","—Le'ec ca' cuxlac a quimene, ma' tu tz'abül u yütan, ma'ax u yicham. P'aatüloo' u ca'a jabix ilic u yaj xa'num a Dios ti ca'ana,— cu t'an a Jesus ti'ijoo'o. ");
INSERT INTO mopNT_vpl VALUES ("MK12_26","071_12_26","MRK","12","26","26","—Pues te'i. ¿Uxtun a ca' cuxtal tu yaamoo' a quimene? A xocaje'ex tuba tz'iiba'an u men aj Moises tuba t'üba'an a pocche' u men a c'aac'a. “Inen u Dios aj Abrahama. Inen u Dios aj Isaaca. Inen u Dios aj Jacobo,” cu t'an a Dios ti'i aj Moisese. Baalo' ti tz'iiba'an te'i,— cu t'an a Jesus ti'ijoo'o. ");
INSERT INTO mopNT_vpl VALUES ("MK12_27","071_12_27","MRK","12","27","27","—Ca'ax uchben quimen ala'oo'o, le'ec a Dioso, ma' u Diosil a quimeni. Ala'aji, u Diosil a cuxa'ana, mentücü, yan a ca' cuxtal tu yaamoo' a quimene. Top ma' toje'ex a t'an yoc'ol abe'e,— cu t'an a Jesus ti'ijoo' a saduceo u c'aba'oo' u na'ata. ");
INSERT INTO mopNT_vpl VALUES ("MK12_28","071_12_28","MRK","12","28","28","Pues te'i. Naatz'i etel a Jesus jun tuul u yaj ca'ansajil u ley aj Moisese. U yubaj c'u' u yadajoo' a saduceo u c'aba'oo' u na'at ti'i a Jesusu, y biqui ti nuucboo' ti qui' u men a Jesusu. —¿C'u' ti leyil a mas c'abeet tu yaam u chucaan a ley u tz'iibtaj aj Moisese?— cu t'an ti'i a Jesusu. ");
INSERT INTO mopNT_vpl VALUES ("MK12_29","071_12_29","MRK","12","29","29","—Le'ec a ley a mas c'abeete, le'ec ada'a. “Tulacale'ex aj Israele, u'yeene'ex. Le'ec a Noochtzili, le'ec ti Dios. Jun tuul ilic tu bajil a Noochtzili. ");
INSERT INTO mopNT_vpl VALUES ("MK12_30","071_12_30","MRK","12","30","30","Yane'ex ti yacuntic a Noochtzili le'ec ti Dios tulacal ti püsüc'al, tulacal ti wool, tulacal ti tucul, y tulacal ti muc'.” Le'ec abe' a ley a mas c'abeete,— cu t'an a Jesus ti'iji. ");
INSERT INTO mopNT_vpl VALUES ("MK12_31","071_12_31","MRK","12","31","31","—Le'ec u ca' p'eel a leye, le'ec ada'a. “Jabix ilic ti yaj a wu'yi a bajil ta bajili, baalo' ilic ti yan a yacuntic a wet'oc.” Ma' yan a ley a mas c'abeet tuwich abe'e,— cu t'an a Jesus ti'iji. ");
INSERT INTO mopNT_vpl VALUES ("MK12_32","071_12_32","MRK","12","32","32","—Maestro, qui' a wadaj. Jaj ti jun tuul ilic tu bajil a Noochtzili. Ma' yan ulaac'. Jadi' ala'aji. ");
INSERT INTO mopNT_vpl VALUES ("MK12_33","071_12_33","MRK","12","33","33","Yan ti yacuntic ala'i tulacal ti püsüc'al, tulacal ti tucul, y tulacal ti muc'. Yan ilic ti yacuntic ti wet'oc jabix ilic ti yaj ti wu'yi ti bajil tiqui bajil. Mas c'abeet abe' tuwich u tz'abül tulacal a boon u wich a sij-ool ti'i a Dios ca'ax a chuwen sij-oolo,— cu t'an u yaj ca'ansajil u ley aj Moises ti'i a Jesusu. ");
INSERT INTO mopNT_vpl VALUES ("MK12_34","071_12_34","MRK","12","34","34","Le'ec a Jesusu, u yubaj ti nuucbi ti qui'. —Ma' top yaab to u beel ti'i ca' c'ümbüquech u men a Dioso,— cu t'an a Jesus ti'iji. Pachil abe'e, saacoo' u mas c'aate ti'i a Jesusu. ");
INSERT INTO mopNT_vpl VALUES ("MK12_35","071_12_35","MRK","12","35","35","Pues te'i. Tan to u t'an a Jesus ichil u yotoch a Dioso. —Le'ecoo' u yaj ca'ansajil u ley aj Moisese, ¿c'u' ca'a walacoo' u yadic ti le'ec a Cristojo, u mam aj quimen rey Davidi?— cu t'an a Jesusu. ");
INSERT INTO mopNT_vpl VALUES ("MK12_36","071_12_36","MRK","12","36","36","—Tz'abi ti'i aj David u men u Püsüc'al a Dios ca' u yadü' ti baala': “Le'ec a Dios a Noochtzili, u yadaj ti'i in Noochil ca' tinlac tu yaj toj tu yaj seeb c'ü' u men u yanil asto u cho'icoo' a tz'iic ti'iji. P'aatüloo' u ca'a jabix yalam u yoc,” cu t'an u t'an a Dios a tz'iiba'an u men aj Davidi,— cu t'an a Jesusu. ");
INSERT INTO mopNT_vpl VALUES ("MK12_37","071_12_37","MRK","12","37","37","—“In Noochil,” cu t'an aj David yoc'ol a Cristojo. Wa cuchi jadi' u mam aj David a Cristojo, ¿c'u' ca'a u tzicbaltaj ala'i jabix u Noochil?— cu t'an a Jesusu. Le'ecoo' u yaabil a cristiano a much'a'anoo' te'iji, qui'oo' u yool u yuboo' u t'an a Jesusu. ");
INSERT INTO mopNT_vpl VALUES ("MK12_38","071_12_38","MRK","12","38","38","Pues te'i. Tan ilic u ca'ansicoo' a cristianojo. —Cününte'ex a bajil ti'i ma' a cho'bole'ex u men boon u yaj ca'ansajil u ley aj Moises a qui'oo' tu wich u tz'eec a noc' a chawac ti'i ca' chiclac jabix noochoo' u wichil u meyaj. Top qui'oo' tu xiquin ca' chiitbic chumuc caj jabix noochoo' u wichil u meyaj. ");
INSERT INTO mopNT_vpl VALUES ("MK12_39","071_12_39","MRK","12","39","39","Top qui'oo' tu wich a tintal taanil, jabix noochoo' u wichil u meyaj ichil a naj tuba walacoo' u much'tal a cristiano u c'ajes a Dioso. Qui'oo' tu wich u beel ti tintal tuwich u cuuchil a nooch u wichil u meyaj ichil a fiestaja,— cu t'an a Jesusu. ");
INSERT INTO mopNT_vpl VALUES ("MK12_40","071_12_40","MRK","12","40","40","—Walacoo' u toquic u yotoch ix ma'ichama. Chawacoo' u pach u t'an ti tanoo' u t'an etel a Dioso, chen ti'i ca' ilbicoo' u men a cristiano jabix top qui'oo' ti que'en etel a Dioso. Mas yaj u sip'il ti bel u ca'a tz'abül ti'ijoo',— cu t'an a Jesusu. ");
INSERT INTO mopNT_vpl VALUES ("MK12_41","071_12_41","MRK","12","41","41","Pues te'i. Ichil u yotoch a Dioso, yan u c'ümbeeb a taq'uin a walac u tz'abül ti'i sij-oolo. Ma' naach te'i tinlaji a Jesusu. U yilajoo' a cristiano ti tanoo' u tz'eec a taq'uin ichil u c'ümbeebe. U yilajoo' a ayic'al ti tanoo' u tz'eec ti yaab u sij-ool ichili. ");
INSERT INTO mopNT_vpl VALUES ("MK12_42","071_12_42","MRK","12","42","42","C'ochi jun tuul otzil ix ma'icham. U sijaj ca' p'eel meen taq'uini. Jabix wal jun p'e centavo u muc' a ca' p'eel meen taq'uin abe'e. ");
INSERT INTO mopNT_vpl VALUES ("MK12_43","071_12_43","MRK","12","43","43","Le'ec a Jesusu, u püyajoo' u yaj cambal tu tzeel. —Tan in wadic te'ex u jajil. Le'ec a otzil ix ma'icham ado'o, u tz'aj ti mas yaab tuwichoo' tulacal u chucaan a tanoo' u tz'eec a taq'uin ichil u c'ümbeebe,— cu t'an a Jesusu. ");
INSERT INTO mopNT_vpl VALUES ("MK12_44","071_12_44","MRK","12","44","44","—Ala'oo'o, tz'etz'eec ilic u tz'ajoo' ichil u yaabil a yan ti'ijoo'o. C'u' betiqui, ix ch'up ado'o, otzil. U laj tz'aj boon a taq'uin a yan ti'i ti u cuxtal,— cu t'an a Jesusu. ");
INSERT INTO mopNT_vpl VALUES ("MK13_1","071_13_1","MRK","13","1","1","Pues te'i. Tan u joc'ol a Jesus ichil u yotoch a Dioso. —Ila Maestro,— cu t'an jun tuul u yaj cambal ti'i. —Top nucuch u tunichil a naj ada'a. Top quich'pan a naja,— cu t'an ti'i a Jesusu. ");
INSERT INTO mopNT_vpl VALUES ("MK13_2","071_13_2","MRK","13","2","2","—Ichil tulacal a naj ada' a tane'ex a wiliqui, ma'ax jun cuul a tunich a cuntal u ca'a yoc'ol u yet'oc. Laj bel u ca'a yojbol,— cu t'an a Jesus ti'ijoo'o. ");
INSERT INTO mopNT_vpl VALUES ("MK13_3","071_13_3","MRK","13","3","3","Pues te'i. Le'ec ti tina'an a Jesus tuwich a witz u c'aba' Olivojo, naatz'oo' aj Pedro, aj Jacob, aj Juan y aj Andres etel. Que'enoo' tu junal. ");
INSERT INTO mopNT_vpl VALUES ("MK13_4","071_13_4","MRK","13","4","4","—Adü to'on biq'uin to u yoojol u yotoch a Dioso. ¿C'u'i u p'is ti ca' uchuc tulacal abe'e?— cu t'anoo' ti'i a Jesusu. ");
INSERT INTO mopNT_vpl VALUES ("MK13_5","071_13_5","MRK","13","5","5","—Cününte'ex a bajil ti'i ma' a tz'ocsique'ex u tus a ma'ax maca,— cu t'an a Jesus ti caji u nuuctoo'. ");
INSERT INTO mopNT_vpl VALUES ("MK13_6","071_13_6","MRK","13","6","6","—Yan a watacoo'o. Beloo' u cu tz'aa' u bajil jabixenoo'. “Inen a Cristojo,” cu t'anacoo' ala'oo'. Beloo' u cu tusu' a yaaba,— cu t'an a Jesusu. ");
INSERT INTO mopNT_vpl VALUES ("MK13_7","071_13_7","MRK","13","7","7","—Bele'ex a ca'a a wu'yi ti tan a noxi' guerraja. Bele'ex a ca'a a wu'yi ti watac ilic ulaac' a noxi' guerraja. Ma' u jac'üle'ex a wool. Yan u yuchul abe'e, pero ma'ax to c'ochoc u q'uinil u jobeeb,— cu t'an a Jesus ti'ijoo' u yaj cambala. ");
INSERT INTO mopNT_vpl VALUES ("MK13_8","071_13_8","MRK","13","8","8","—Bel u ca'a ti p'isbaj a noxi' caj etel ulaac' a noxi' caja. Bel ilic u ca'a u tz'aa' a p'isbaj jun tuul a rey etel ulaac' a reye,— cu t'an a Jesusu. —Yantal u ca'a a yuc'laj yaab tubajaca. Yantal u ca'a a wi'ijili. Yaaboo' a cristiano a beloo' u cu c'ümü' a c'ac'as c'oja'anil yaab tubajaca,— cu t'an a Jesusu. —Tulacal abe'e, chen u cajeeb a yaj a wataca,— cu t'an. ");
INSERT INTO mopNT_vpl VALUES ("MK13_9","071_13_9","MRK","13","9","9","Cününte'ex a bajil. Bele'ex a ca'a c'ubbul ti'ijoo' a noochoo' u wichil u meyaj u men tane'ex a tz'ocsiquen. Bele'ex a ca'a jütz'bül etel jatz' ichil a naj tuba walacoo' u much'tal ti wetcaal ti'i u c'ajes a Dioso. Bele'ex a ca'a bensabül tu taan a gobernadoro, y tu taan a rey chen u men tane'ex a tz'ocsiquen. Bele'ex a ca'a a wadü' in t'an ti'ijoo',— cu t'an a Jesusu. ");
INSERT INTO mopNT_vpl VALUES ("MK13_10","071_13_10","MRK","13","10","10","—Le'ec u pectzil a Dioso, yan u yaalbül tulacal tubajac yoc'olcab,— cu t'an. ");
INSERT INTO mopNT_vpl VALUES ("MK13_11","071_13_11","MRK","13","11","11","—Pues te'i. Le'ec ti tane'ex a bensabül ti'i ca' ilbic wa yane'ex a sip'il, y le'ec ti tane'ex a c'ubbul ti'ijoo' a noochoo' u wichil u meyaj, ma' a tuclique'ex c'u' a bele'ex a ca'a a wadü'. Le'ec ti tan u c'aatbül a chi'i, ade'ex c'u' a bel u ca'a tz'abül te'ex u men a Dioso. Ma' le'ec inche'ex a bele'ex a ca'a ti nuuc. Le'ec u Püsüc'al a Dios a bel u ca'a ti nuucu,— cu t'an a Jesus ti'ijoo' u yaj cambala. ");
INSERT INTO mopNT_vpl VALUES ("MK13_12","071_13_12","MRK","13","12","12","—Le'ec a winiqui, bel u cu c'ubu' u yitz'in wa u sucu'un ti'i ca' quimsabüc tin woc'lal. Le'ec ilic u tata, bel u cu c'ubu' u mejen ti'i ca' quimsabüc. Le'ec ilic u mejene, bel u cu tz'aa' ca' quimsabücoo' u na' u tat,— cu t'an a Jesusu. ");
INSERT INTO mopNT_vpl VALUES ("MK13_13","071_13_13","MRK","13","13","13","—Chen u men tene'exe, bele'ex a ca'a motzinbil u men tulacaloo' a cristianojo. Le'ec mac ca' u muc'yajte a yaj abe' asto tu jobeebe, bel u ca'a sa'albül,— cu t'an a Jesusu. ");
INSERT INTO mopNT_vpl VALUES ("MK13_14","071_13_14","MRK","13","14","14","—Pues te'i. Le'ec mac ca' u xoco' a bel to in quin tz'iibteje, in c'ati cuchi ca' u ch'aa' u tojil,— cu t'an aj Marcoso, le'ec mac u tz'iibtaj ada'a. —Le'ec ti tane'ex a wilic ti que'en a top c'as tuba ma' cuchi que'eni, le'ec a que'en ich cuenta Judeaja, yan u puutz'ul yaam witz,— cu t'an a Jesusu. ");
INSERT INTO mopNT_vpl VALUES ("MK13_15","071_13_15","MRK","13","15","15","—Le'ec a que'en pach naja, ma' qui' u beel ichil u yotoch ti'i u molical a c'u' a ti'iji. Sabeensil u müchbül. Jadi' qui' u puutz'ul,— cu t'an a Jesusu. ");
INSERT INTO mopNT_vpl VALUES ("MK13_16","071_13_16","MRK","13","16","16","—Le'ec a que'en ich colo, ma' qui' ma'ax u beel u molo' u noc' u joc'saj ti caji ti meyaj. Jadi' qui' u puutz'ul,— cu t'an a Jesusu. ");
INSERT INTO mopNT_vpl VALUES ("MK13_17","071_13_17","MRK","13","17","17","—Yaj ti c'axül u ca'a ti'ijoo' ix ch'up a watac u yal u yet'ocoo' a tanoo' u tz'aj chu' ti a q'uin abe'e, u men ma' tu paataloo' ti puutz'ul,— cu t'an a Jesusu. ");
INSERT INTO mopNT_vpl VALUES ("MK13_18","071_13_18","MRK","13","18","18","—C'aate'ex ti'i a Dios yoc'ol ma' a puutz'ule'ex tu q'uinil a ja'ja'ili, ti'i ca' paataque'ex ti puutz'ul,— cu t'an a Jesusu. ");
INSERT INTO mopNT_vpl VALUES ("MK13_19","071_13_19","MRK","13","19","19","—Le'ec a yaj a yantal u ca'a ti'i a q'uin abe'e, ma'ax jun sut uchuc ti top yaj ti baalo' asto ti yaax betabi a yoc'olcab u men Dios y tac leeb. Ma'ax tu ca' yantal tu pach abe'e,— cu t'an a Jesusu. ");
INSERT INTO mopNT_vpl VALUES ("MK13_20","071_13_20","MRK","13","20","20","—Wa cuchi ma' u tz'eec a Noochtzil ti ma' yaab u q'uinil u yuchul a yaj abe'e, ma'ax cuchi mac ti cristianojil jede'ec u muc'yajtiqui. C'u' betiqui, u ch'a'ajoo' u yotzilil a yeeta'anoo'o, mentücü, u tz'aj ti ma' yaab u q'uinil u yuchul a yaj abe'e,— cu t'an a Jesusu. ");
INSERT INTO mopNT_vpl VALUES ("MK13_21","071_13_21","MRK","13","21","21","—Pues te'i. Ti a q'uin abe'e, wa yan mac ca' u yadü' te'ex ti wa'ye' que'en a Cristo wa tedo' que'ene, ma' a tz'ocsique'ex u t'an,— cu t'an a Jesusu. ");
INSERT INTO mopNT_vpl VALUES ("MK13_22","071_13_22","MRK","13","22","22","—Yanoo' a beloo' u cu yadü' u bajil ti Cristo ala'oo'o, pero chenoo' u tus. Yanoo' a beloo' u cu yadü' ti tücaa'boo' u men a Dioso, pero chenoo' u tus. Beloo' u cu bete' a milagro ti yaab ti'i u p'is ti jajoo' u t'an chen ti'i u cho'icaloo' a cristianojo. Wa cuchi yan biquiji, cho'bol u ca'a cuchi a yeeta'anoo' ilic xan,— cu t'an a Jesus ti'ijoo' u yaj cambala. ");
INSERT INTO mopNT_vpl VALUES ("MK13_23","071_13_23","MRK","13","23","23","—Cününte'ex a bajil. Ac in wadaj tun te'ex ada' le'ec ti ma'ax to uchuc ti'i ma' a cho'bole'ex,— cu t'an a Jesus ti'ijoo' u yaj cambala. ");
INSERT INTO mopNT_vpl VALUES ("MK13_24","071_13_24","MRK","13","24","24","—Pues te'i. Ti a q'uin abe' ti mani to a top yaj in wadaj ti watac yoc'olcaba, ac'ü'tal u ca'a a q'uini. Cuntal u ca'a ti ma' ca' yan u sac a uju. ");
INSERT INTO mopNT_vpl VALUES ("MK13_25","071_13_25","MRK","13","25","25","C'axül u ca'a a xülaba. Pecsabül u ca'a u muc' u nu'cul a ca'ana,— cu t'an a Jesusu. ");
INSERT INTO mopNT_vpl VALUES ("MK13_26","071_13_26","MRK","13","26","26","—Tu q'uinil abe'e, beloo' u cu yileen a yanajeen ti cristianojili. Tan in wudel ich muyal. Top yaab in muc'. Top yaab in yanil ti a q'uin abe'e,— cu t'an a Jesusu. ");
INSERT INTO mopNT_vpl VALUES ("MK13_27","071_13_27","MRK","13","27","27","—Bel in quin tücaa'too' u yaj xa'num a Dios ti ca'an ca' xicoo' u much'quintoo' a yeeta'anoo' tin wetel. Beloo' u ca'a ti norte. Beloo' u ca'a ti sur, ti joq'ueeb q'uin y ti oqueeb q'uin ti'i u much'quintoo' ala'oo'o. Beloo' u ca'a tulacal tubajac yoc'olcab y ca'an u much'quintoo'. ");
INSERT INTO mopNT_vpl VALUES ("MK13_28","071_13_28","MRK","13","28","28","Pues te'i. Etel a chimunu, chica'an in t'an yoc'ol c'u' in c'ati ca' a weelte'exe. Walac u jelmel a chimunu, ca' tun joc'oc u c'uuc'. Le'ec ca' a wile'ex ti tan tun u yantal u le'e, a weele'ex ti nütz'a'an a ja'ja'ili,— cu t'an a Jesus ti'ijoo'o. ");
INSERT INTO mopNT_vpl VALUES ("MK13_29","071_13_29","MRK","13","29","29","—Baalo' ilic etel u p'is a tan u ye'ic ti watac u jobeebe. Le'ec ti tane'ex a wilic ti tan u yuchul u p'is abe'e, a weele'ex ti nütz'a'an u jobeeb jabix que'en tun chi' naj,— cu t'an a Jesusu. ");
INSERT INTO mopNT_vpl VALUES ("MK13_30","071_13_30","MRK","13","30","30","—Tan in wadic te'ex u jajil. Yanoo' a cristiano a cuxa'anoo' ti caac ye'bel u p'is. Yanoo' tu yaamoo' a beloo' u cu yila' u jobeeb,— cu t'an a Jesusu. ");
INSERT INTO mopNT_vpl VALUES ("MK13_31","071_13_31","MRK","13","31","31","—Le'ec a ca'an etel a yoc'olcaba, bel u ca'a ti jobol. C'u' betiqui, in t'an inene, ma' tu chen jobol ti baalo'. Bel u ca'a ti jajtal,— cu t'an a Jesus ti'ijoo' u yaj cambala. ");
INSERT INTO mopNT_vpl VALUES ("MK13_32","071_13_32","MRK","13","32","32","—Pues te'i. Ma'ax mac u yeel biq'uin u c'ochol u q'uinil ma'ax u yorajil in ca' udel. Ma'ax u yaj xa'num a Dios ti ca'ana, ma' u yeeloo' xan. Ma'ax u Mejen a Dioso, ma' u yeel. Jadi' a Tattzil u yeele,— cu t'an a Jesusu. ");
INSERT INTO mopNT_vpl VALUES ("MK13_33","071_13_33","MRK","13","33","33","—Inen a Noochile'ex. Ma' a weele'ex c'u' ti q'uinil in ca' udel, mentücü, tanaque'ex a cününtic a bajil, y tanaque'ex a t'an etel a Dioso,— cu t'an a Jesusu. ");
INSERT INTO mopNT_vpl VALUES ("MK13_34","071_13_34","MRK","13","34","34","—Le'ec a c'u' in wadaj to te'exe, c'üs quet etel jun tuul a winic u p'ütaj u yotocho. Que'en ich ulaac' lu'um. Le'ec ti que'en to ichil u yotocho, u tz'ajoo' u yanil a jujun tuul u yaj meyaj ti'i ca' u betoo' u meyaj a tz'aboo' ti'iji. Le'ec a yan u meyaj u cününtic u chi' a naja, aalbi ti'i ca' u cününte ti qui',— cu t'an a Jesusu. ");
INSERT INTO mopNT_vpl VALUES ("MK13_35","071_13_35","MRK","13","35","35","—Inen jabix a winic abe' u p'ütaj u yotocho, mentücü, cününte'ex a bajil. Ma' a weele'ex biq'uin ti ca' uduquen, wa ti ocq'uin, wa chumuc ac'ü', wa ma'ax to sasac, wa sasaji tun. ");
INSERT INTO mopNT_vpl VALUES ("MK13_36","071_13_36","MRK","13","36","36","Uchac chen a wilique'exe, ac udeen tun y in cüxtique'ex ti tane'ex a wüyül,— cu t'an a Jesusu. ");
INSERT INTO mopNT_vpl VALUES ("MK13_37","071_13_37","MRK","13","37","37","—Le'ec a c'u' a tan in wadic te'exe, tan ilic in wadic ti'i tulacaloo'. Paac'teene'ex,— cu t'an a Jesus ti'ijoo' u yaj cambala. ");
INSERT INTO mopNT_vpl VALUES ("MK14_1","071_14_1","MRK","14","1","1","Pues te'i. Ca' p'e q'uin to u beel ca' c'ochoc u q'uinil a fiesta ti tan u c'ajsabül biq'uin ti mani u yaj xa'num a Dios ti ca'an yoc'oloo' aj Israele. Le'ec ilic u q'uinil a fiesta ti ma' ta'ach u jantabül a pan a yan u levadurajili. Ti ilic a q'uin abe'e, le'ecoo' u noochil u yaj mansaj t'an a cristiano ti'i a Dioso, u yet'ocoo' u yaj ca'ansajil u ley aj Moisese, tanoo' u tuclic biqui ca' u müchoo' ich mucul a Jesus ti'i ca' u quimesoo'. ");
INSERT INTO mopNT_vpl VALUES ("MK14_2","071_14_2","MRK","14","2","2","—Ma' qui' u müchbül ti tan to a fiestaja. Sabeensil u liq'uiloo' u tz'iiquil u yaabil a cristianojo,— cu t'anoo' tu bajil. ");
INSERT INTO mopNT_vpl VALUES ("MK14_3","071_14_3","MRK","14","3","3","Pues te'i. Le'ec a Jesusu, que'en ichil u yotoch aj Simon ichil a tz'i' caj Betaniaja. Biq'uin ado'o, tan u tu'ujtal u büq'uel aj Simon u men a c'oja'anil abe'e. Le'ec ti que'en a Jesus chi' mesa ti janal, c'ochi jun tuul a nooch'upu. U talesaj jun p'eel a tz'i' p'uulu. Betabi etel a tunich u c'aba' alabastro. Tuda'an a p'uul abe' etel a boc a nardo u c'aba' a top co'oj u toolo. U cüchaj a tz'i' p'uulu. U toxaj a boc tu pol a Jesusu. ");
INSERT INTO mopNT_vpl VALUES ("MK14_4","071_14_4","MRK","14","4","4","Pues te'i. Le'ec ti ilbi c'u' u betaj a nooch'upu, yan a tz'iicajoo'. —¿C'u' ca'a najilcunbi a boco? ");
INSERT INTO mopNT_vpl VALUES ("MK14_5","071_14_5","MRK","14","5","5","Conbi cuchi a boc abe' ti manal tres ciento u tool cuchi. T'oxbi cuchi u tool ti'ijoo' a otzili,— cu t'anoo' tu bajil. Cajoo' u maclant'ante a nooch'upu. ");
INSERT INTO mopNT_vpl VALUES ("MK14_6","071_14_6","MRK","14","6","6","—P'üte'ex. ¿C'u' ca'a tane'ex a yajcuntic u yool a nooch'upu? Top quich'pan c'u' u betaj tene,— cu t'an u yaalbüloo' u men a Jesusu. ");
INSERT INTO mopNT_vpl VALUES ("MK14_7","071_14_7","MRK","14","7","7","—Que'en a otzil ta yaame'ex tulacal a q'uini. Biq'uin a c'ate'exe, jede'ec u paatale'ex a waanticoo'. C'u' betic inene, ma' tulacal q'uin cuntal in ca'a ta yaame'exe,— cu t'an u yaalbüloo'. ");
INSERT INTO mopNT_vpl VALUES ("MK14_8","071_14_8","MRK","14","8","8","—Le'ec a nooch'up ada'a, u betaj c'u' a patal u bete'e. Le'ec a boc a toxbi tin woc'olo, paye' toxbi tin woc'ol ti'i in mucbeebal,— cu t'an u yaalbüloo'. ");
INSERT INTO mopNT_vpl VALUES ("MK14_9","071_14_9","MRK","14","9","9","—Tan in wadic te'ex u jajil. Tulacal tubajac yoc'olcab tuba tan u yaalbül u pectzil a Dioso, bel u ca'a c'ajsabül a qui' u betaj ten a nooch'upu,— cu t'an u yaalbüloo' u men a Jesusu. ");
INSERT INTO mopNT_vpl VALUES ("MK14_10","071_14_10","MRK","14","10","10","Pues te'i. Jun tuul a winiqui, Judas Iscariote u c'aba'. Ala'aji, jun tuul tu yaam a doce tuuloo' u yaj cambal a Jesusu. Bini ala'i eteloo' u noochil u yaj mansaj t'an a cristiano ti'i a Dioso. Bini te'i ti'i u tzolo' a Jesus ti'ijoo'o. ");
INSERT INTO mopNT_vpl VALUES ("MK14_11","071_14_11","MRK","14","11","11","Le'ec ca' u yubajoo' u t'an ala'aji, qui'ajoo' u yool. U tz'ajoo' u t'an ti'i ca' bo'tabüc ala'aji. Caji aj Judas u cüxte biq'uin ti qui' u tzolic a Jesus ti ma' yaaboo' a cristiano tu tzeele. ");
INSERT INTO mopNT_vpl VALUES ("MK14_12","071_14_12","MRK","14","12","12","Pues te'i. C'ochi u paye' q'uinil a fiesta ti ma' ta'ach u jantabül a pan a yan u levadurajili. Ti a q'uin abe'e, walac u quimsabül a carnero ti'i u c'ajsabeebal ti mani u yaj xa'num a Dios ti ca'an yoc'oloo' uchi. —¿Tuba a c'ati ca' xico'on ti utzquinte tech a janal u c'ajsabeeb ti mani u yaj xa'num a Dios ti ca'an yoc'oloo' ti uchben mamaa' uchi?— cu t'anoo' u yaj cambal ti'i a Jesusu. ");
INSERT INTO mopNT_vpl VALUES ("MK14_13","071_14_13","MRK","14","13","13","—Ca' xique'ex ich caj,— cu t'an a Jesus ti'ijoo' ca' tuul u yaj cambala. —Le'ec ti que'ene'ex te'i, bele'ex a ca'a a c'ümü' jun tuul a winic a tan u c'oochtic jun cuul p'uul ti ja'. Xene'ex tu pach ala'aji,— cu t'an ti'ijoo'. ");
INSERT INTO mopNT_vpl VALUES ("MK14_14","071_14_14","MRK","14","14","14","—Le'ec tuba u yocol ala'aji, chiite'ex u yumil a naja. “¿Tuba que'en u cuartojil a posado tuba bel in quin jante u janalil a fiesta eteloo' in waj cambal?, cu t'an a maestro tech,” que'exac ti'i u yumil a naja,— cu t'an a Jesus ti'ijoo' a ca' tuul u yaj cambala. ");
INSERT INTO mopNT_vpl VALUES ("MK14_15","071_14_15","MRK","14","15","15","—Bel u ca'a u yee' te'ex jun p'eel a noxi' cuarto ti u ca' tzaam a naja. Ac yan tun u cuuchil a janal te'iji, y listo tun. Te'i ca' a wutzquinte'ex ti janal,— cu t'an a Jesusu. ");
INSERT INTO mopNT_vpl VALUES ("MK14_16","071_14_16","MRK","14","16","16","Pues te'i. Binoo' a ca' tuul ich caj. U cüxtajoo' jabix ilic a aalboo' ti'iji. U yutzquintajoo' a janala. ");
INSERT INTO mopNT_vpl VALUES ("MK14_17","071_14_17","MRK","14","17","17","Le'ec ti oqui a ac'ü'ü, c'ochi te'i a Jesus u yet'ocoo' a doce tuul u yaj cambala. ");
INSERT INTO mopNT_vpl VALUES ("MK14_18","071_14_18","MRK","14","18","18","Le'ec ti que'enoo' chi' mesa ti janala, u yadaj a Jesusu: —Tan in wadic te'ex u jajil. Jun tuul ta yaame'exe, bel u cu tzoleen. Ala'aji, tan ilic u janal tiqui yaam,— cu t'an a Jesusu. ");
INSERT INTO mopNT_vpl VALUES ("MK14_19","071_14_19","MRK","14","19","19","Yajajoo' u yool. Jujun tuulil, cajoo' u c'aate ti'i. —¿Inen wa abe'e?— cu t'an a jujun tuul ti'iji. ");
INSERT INTO mopNT_vpl VALUES ("MK14_20","071_14_20","MRK","14","20","20","—Le'ec mac a tan in tzicbaltiqui, jun tuul ta yaame'ex a doce tuule'ex a tan u comon janal tin wetele. Ala'aji, bel u cu tzoleen,— cu t'an a Jesusu. ");
INSERT INTO mopNT_vpl VALUES ("MK14_21","071_14_21","MRK","14","21","21","—Bel u ca'a ti uchul ten a yanajeen ti cristianojil jabix ilic ti tz'iiba'an ichil u ju'um a Dioso. C'u' betiqui, top yaj a bel u cu c'ümü' a winic a bel u cu tzoleene. Mas qui' cuchi ti'i wa ma' yanaji u men a yaj a bel u cu c'ümü'ü,— cu t'an a Jesus ti'ijoo' u yaj cambala. ");
INSERT INTO mopNT_vpl VALUES ("MK14_22","071_14_22","MRK","14","22","22","Pues te'i. Le'ec ti tanoo' u janala, u molaj a waj harina a Jesusu. U c'ajsaj a Dios yoc'ol a waj harinaja. U xet'aj. U tz'aj ti'ijoo' u yaj cambal. —Jeda'. Jante'ex. Le'ec ada' in büq'uel ti'i a c'ajsicalene'ex,— cu t'an ti'ijoo'. ");
INSERT INTO mopNT_vpl VALUES ("MK14_23","071_14_23","MRK","14","23","23","U molaj jun p'e pote a uc'ulu. Le'ec ca' u c'ajsaj a Dios yoc'olo, u tz'aj ti'ijoo' u yaj cambal. Tulacaloo' u yaj cambala, u yuc'ajoo' abe'e. ");
INSERT INTO mopNT_vpl VALUES ("MK14_24","071_14_24","MRK","14","24","24","—Le'ec in q'uiq'uele, bel u ca'a ti joc'ol ca' quimsabüquen. Etel in quimeebala, bel u ca'a ti yantal u muc' a tumul t'ana. Le'ec a uc'ul ada'a, in q'uiq'uel ti'i a c'ajsicalene'ex,— cu t'an a Jesus ti'ijoo'o. ");
INSERT INTO mopNT_vpl VALUES ("MK14_25","071_14_25","MRK","14","25","25","—Tan in wadic te'ex u jajil. Ma' tin ca' uq'uic u c'a' a uvaja, asto u c'ochol u q'uinil in wuq'uic a tumulben to ichil u cuenta in Tat,— cu t'an a Jesusu. ");
INSERT INTO mopNT_vpl VALUES ("MK14_26","071_14_26","MRK","14","26","26","Pues te'i. Le'ec ti jobi u c'üyic jun p'eel a c'ay ti'i a Dioso, joc'oo' te'i. Binoo' tuwich a witz Olivo. ");
INSERT INTO mopNT_vpl VALUES ("MK14_27","071_14_27","MRK","14","27","27","Pues te'i. Uchi u t'an a Jesusu. —Etel c'u' a bel in quin c'ümü'ü, tulacale'ex, bele'ex a ca'a a p'üteen. Baalo' ilic ti tz'iiba'an. “Bel in quin yajcunte u yaj cananil a carnerojo. Le'ecoo' a carnerojo, beloo' u ca'a ti weequel,” cu t'an a t'an a tz'iiba'ana,— cu t'an a Jesusu. ");
INSERT INTO mopNT_vpl VALUES ("MK14_28","071_14_28","MRK","14","28","28","—Le'ec ca' cuxlaquen tucaye'ili, c'ochol in ca'a payanbej ta wiche'ex cuenta Galilea,— cu t'an a Jesus ti'ijoo' u yaj cambala. ");
INSERT INTO mopNT_vpl VALUES ("MK14_29","071_14_29","MRK","14","29","29","—Ca'ax u p'üteechoo' tulacaloo' u men c'u' a bel a ca'a a c'ümü'ü, inene, ma' yan q'uin in p'ütiquech,— cu t'an aj Pedro ti uchi u nuuc. ");
INSERT INTO mopNT_vpl VALUES ("MK14_30","071_14_30","MRK","14","30","30","—Tan in wadic tech u jajil. Ti'i ilic a ac'ü' ada' ti ma'ax to uchuc u yawat aj t'el ca' sutu, ac ox sut tun a wadü' ti ma' a weel in wich,— cu t'an a Jesus ti'i aj Pedrojo. ");
INSERT INTO mopNT_vpl VALUES ("MK14_31","071_14_31","MRK","14","31","31","—Ca'ax in wetquimilech, ma' tin wadic wa ma' in weel a wich,— cu t'an aj Pedro tulacal u yool u püsüc'al ti'i a Jesusu. Baalo' ilic u laj adajoo' u chucaan u yaj cambal a Jesusu. ");
INSERT INTO mopNT_vpl VALUES ("MK14_32","071_14_32","MRK","14","32","32","Pues te'i. Bini a Jesus u yet'ocoo' u yaj cambal ichil jun p'eel cuuchil u c'aba' Getsemani. —Tinlene'ex wa'ye'. Bel in ca'a ti t'an etel a Dioso,— cu t'an a Jesus ti'ijoo'o. ");
INSERT INTO mopNT_vpl VALUES ("MK14_33","071_14_33","MRK","14","33","33","U bensaj aj Pedro, aj Jacob, y aj Juan tu pacha. Caji ti yajtal u yool tu jajil. Caji u yubi u yajil a yaj a watac yoc'olo. ");
INSERT INTO mopNT_vpl VALUES ("MK14_34","071_14_34","MRK","14","34","34","—Tin wu'yic inene, jabix watac in quimil u men u yajil in wool. Wa'ye' a cuntale'ex. P'ixa'anaque'ex a wich,— cu t'an a Jesus ti'ijoo' a ox tuulu. ");
INSERT INTO mopNT_vpl VALUES ("MK14_35","071_14_35","MRK","14","35","35","Ca' bini mas tz'etz'eec tucaye'. Xonlaji ti lu'um. Caji u c'aate ti'i a Tattzil wa yan biqui ca' tz'abüc ti'i ti ma' u c'ümic a yaj a watac yoc'olo. ");
INSERT INTO mopNT_vpl VALUES ("MK14_36","071_14_36","MRK","14","36","36","—Tat, jede'ec u laj paatal a betic tulacal a c'u' taca. Tz'a ten ti ma' tin c'ümic a yaj a wataca. C'u' betiqui, mas toj a betic a jabix ilic a c'ati incheche, ma' chen le'ec a jabix in c'ati ineni,— cu t'an a Jesus ti'i a Tattzili. ");
INSERT INTO mopNT_vpl VALUES ("MK14_37","071_14_37","MRK","14","37","37","Ca' usc'aji a Jesus eteloo' u yaj cambal a ox tuulu. Ca' u yilaja, tanoo' u wüyül. —Simon, ¿tan wa a wüyül? ¿Ma' wa tu paatal a p'ixtal ma'ax jun p'e hora?— cu t'an ti'i aj Pedrojo. ");
INSERT INTO mopNT_vpl VALUES ("MK14_38","071_14_38","MRK","14","38","38","—P'ixa'anaque'ex a wich. C'aate'ex ti'i a Dios ti'i ma' u yemsabüle'ex a wool a bete'ex a c'asa. Yane'ex a wool a bete'ex cuchi, pero ma' yane'ex a muc',— cu t'an a Jesus ti'ijoo'o. ");
INSERT INTO mopNT_vpl VALUES ("MK14_39","071_14_39","MRK","14","39","39","Ca' bini tucaye' a Jesusu. Ca' uchi u t'an etel a Tattzili. Quet ilic u yadaj ti'i jabix ilic u paye' adaj ti'iji. ");
INSERT INTO mopNT_vpl VALUES ("MK14_40","071_14_40","MRK","14","40","40","Ca' usc'aji tucaye'il a Jesus eteloo' u yaj cambal a ox tuulu. Ca' u yilaja, tanoo' u wüyül tucaye'il. Top qui'oo' u yemel u wüyül. Ma' u yeeloo' biqui ca' u nuuctoo' a Jesusu. ");
INSERT INTO mopNT_vpl VALUES ("MK14_41","071_14_41","MRK","14","41","41","A Jesusu, ca' bini tucaye'il. Ca' usc'aji tu yox sut eteloo' u yaj cambal. —¿C'u' ca'a tane'ex to a wüyül, tane'ex to a jedel? Chucul tun. U'ye'ex. Inene, yanajeen ti cristianojil. Aleebe c'ochi u yorajil in c'ubbul ti'ijoo' a yanoo' u sip'ili,— cu t'an a Jesusu. ");
INSERT INTO mopNT_vpl VALUES ("MK14_42","071_14_42","MRK","14","42","42","—Liq'uene'ex. Co'ne'ex ti c'ümoo'. Ile'ex, watac a mac a bel u cu c'ubeen ti'ijoo'o,— cu t'an a Jesusu. ");
INSERT INTO mopNT_vpl VALUES ("MK14_43","071_14_43","MRK","14","43","43","Pues te'i. Tan to u t'an a Jesus ti udi aj Judasa. Le'ec ala'aji, jun tuul tu yaamoo' a doce tuul u yaj cambal a Jesusu. U yetc'ocholoo', jun muuch' ti cristiano. Yan a yanoo' u maasca' y a yanoo' u che' tu c'ü'. Tücaa'boo' u menoo' u noochil u yaj mansaj t'an a cristiano ti'i a Dioso, u yet'ocoo' u yaj ca'ansajil u ley aj Moises eteloo' a nucuch winiqui. ");
INSERT INTO mopNT_vpl VALUES ("MK14_44","071_14_44","MRK","14","44","44","Le'ec ti ma'ax to c'ochocoo'o, aalbi ti'ijoo' u men aj Judas biqui ca' u na'too' maqui a Jesusu. —Le'ec mac a ca' in wutzinte ti tan in dioostiqui, le'ec ala'i a winic a c'ate'exe. Müche'ex. Ma' a cha'ique'ex u beel. Bense'ex ala'i ta pache'ex,— cu t'an aj Judasa. ");
INSERT INTO mopNT_vpl VALUES ("MK14_45","071_14_45","MRK","14","45","45","Tu seebal c'ochi aj Judas etel a Jesusu. —Maestro,— cu t'an ti'i a Jesusu. U yutzintaj. ");
INSERT INTO mopNT_vpl VALUES ("MK14_46","071_14_46","MRK","14","46","46","Müchbi a Jesus u menoo' a cristianojo. ");
INSERT INTO mopNT_vpl VALUES ("MK14_47","071_14_47","MRK","14","47","47","Pues te'i. Jun tuul tu yaamoo' u yaj cambal a Jesus a wa'anoo' te'iji, u joc'saj u maasca'. U jan ch'üctaj u yaj meyaj a winic a mas nooch u wichil u meyaj tu yaamoo' u yaj mansaj t'an a cristiano ti'i a Dioso. Ch'ücbi tu xiquin. ");
INSERT INTO mopNT_vpl VALUES ("MK14_48","071_14_48","MRK","14","48","48","—¿Tale'ex wa a mücheen etel maasca' y etel che' jabixen cuchi jun tuul aj xuuch'u?— cu t'an a Jesus ti'ijoo' a c'ochoo' to. ");
INSERT INTO mopNT_vpl VALUES ("MK14_49","071_14_49","MRK","14","49","49","—Sansamal que'enen in ca'ansoo' a cristiano ichil u yotoch a Dioso, y ma' a müchajene'ex te'i,— cu t'an a Jesus ti'ijoo'o. —C'u' betiqui, yan a betique'ex tulacal a c'u' a tane'ex a betic aleebe ti'i ca' jajac u t'an a Dios a tz'iiba'ana,— cu t'an a Jesus ti'ijoo'o. ");
INSERT INTO mopNT_vpl VALUES ("MK14_50","071_14_50","MRK","14","50","50","p'ütbi a Jesus u menoo' u yaj cambala. Puutz'oo'. ");
INSERT INTO mopNT_vpl VALUES ("MK14_51","071_14_51","MRK","14","51","51","Pues te'i. Jun tuul a ch'ajomo, caji ti beel tu pach a Jesusu. Jadi' jun tziil a süc noc' a que'en yoc'ol a ch'ajom abe'e. Le'ecoo' ilic mac u müchaj a Jesusu, u yaaltajoo' ilic u müchü' a ch'ajomo. ");
INSERT INTO mopNT_vpl VALUES ("MK14_52","071_14_52","MRK","14","52","52","Ala'aji, u p'ütaj a süc noc' a que'en yoc'olo. Joq'ui ti alca'. Ma' noc' ti puutz'i. ");
INSERT INTO mopNT_vpl VALUES ("MK14_53","071_14_53","MRK","14","53","53","Pues te'i. Le'ecoo' a mac u müchaj a Jesusu, u bensajoo' etel a mas nooch u wichil u meyaj tu yaamoo' u yaj mansaj t'an a cristiano ti'i a Dioso. Te'i ilic much'a'anoo' tulacaloo' u noochil u yaj mansaj t'an a cristiano ti'i a Dioso, u yet'ocoo' a nucuch winic eteloo' u yaj ca'ansajil u ley aj Moisese. ");
INSERT INTO mopNT_vpl VALUES ("MK14_54","071_14_54","MRK","14","54","54","Pues te'i. Le'ec ti binoo' te'iji, naach tücünac aj Pedro tu pachoo'. Oqui ilic tac ichil u cotil u yotoch aj mansaj t'an abe' a mas nooch u wichil u meyaja. Tinlaji tu yaamoo' a soldadojo. Tan u q'uiich chi' c'aac'. ");
INSERT INTO mopNT_vpl VALUES ("MK14_55","071_14_55","MRK","14","55","55","Pues te'i. Le'ecoo' u noochil u yaj mansaj t'an a cristiano ti'i a Dios u yet'ocoo' a nucuch winic a much'a'anoo' te'iji, u yaaltajoo' u cüxte mac ca' u tzolo' a Jesus ti'i ca' quimsabüc. C'u' betiqui, ma' u cüxtajoo' a jabix u c'atoo'o. ");
INSERT INTO mopNT_vpl VALUES ("MK14_56","071_14_56","MRK","14","56","56","Ca'ax yaaboo' a c'ochoo' ti tusu, ma' yan tu yaamoo' a quetoo' u t'ana. ");
INSERT INTO mopNT_vpl VALUES ("MK14_57","071_14_57","MRK","14","57","57","Yanoo' a wa'lajoo' ti tus yoc'ol a Jesusu. ");
INSERT INTO mopNT_vpl VALUES ("MK14_58","071_14_58","MRK","14","58","58","—“Bel in quin jobes u yotoch a Dios a betabi u men cristianojo. Ich ox p'e q'uin bel in quin bete' ulaac' le'ec a ma' betaja'an u men cristianoji,” cu t'an a winic ada'a,— cu t'anoo'. —Ino'ono, ti wu'yaj c'a' u yadaj abe'e,— cu t'anoo' ala'oo'. ");
INSERT INTO mopNT_vpl VALUES ("MK14_59","071_14_59","MRK","14","59","59","Ca'ax baalo' u yadajoo'o, ma' quetoo' u t'an yoc'ol a Jesusu. ");
INSERT INTO mopNT_vpl VALUES ("MK14_60","071_14_60","MRK","14","60","60","Pues te'i. Le'ec a mas nooch u wichil u meyaj tu yaamoo' u yaj mansaj t'an a cristiano ti'i a Dioso, wa'laji chumuquil. —¿C'u' ca'a ma' tan a nuuctic mac tan u tzoliquech? ¿C'u' abe' a tan u yaalbül ta woc'olo?— cu t'an ti'i a Jesusu. ");
INSERT INTO mopNT_vpl VALUES ("MK14_61","071_14_61","MRK","14","61","61","Ma'ax c'u' u yadaj a Jesusu. Ma' u nuuctajoo'i. Aj mansaj t'an abe'e, u ca' c'aataj ti'i a Jesusu. —¿Inchech wa u yaj Sa'alil a cristianojo, u Mejenech a mac a top qui' ti ca'ana?— cu t'an ti'i a Jesusu. ");
INSERT INTO mopNT_vpl VALUES ("MK14_62","071_14_62","MRK","14","62","62","—Inen,— cu t'an a Jesusu. —Bele'ex a ca'a a wileen a yanajeen ti cristianojil ti tina'anen tu yaj toj tu yaj seeb c'ü' a Dios a yaab u muc'u. Bele'ex ilic a ca'a a wila' ti tan in wemel etel a muyala,— cu t'an a Jesus ti'ijoo'o. ");
INSERT INTO mopNT_vpl VALUES ("MK14_63","071_14_63","MRK","14","63","63","Le'ec ca' u yubaj abe' a mas nooch u wichil u meyaj tu yaamoo' u yaj mansaj t'an a cristiano ti'i a Dioso, u tzilaj u noc'. —¿C'u' aj beel ulaac' aj tzolo? ");
INSERT INTO mopNT_vpl VALUES ("MK14_64","071_14_64","MRK","14","64","64","A wu'yaje'ex ilic ti tan u maclant'an a Jesusu,— cu t'an ti'ijoo'. —¿Biqui'ile'ex a tucul yoc'ol a t'an u yadaja?— cu t'an ti'ijoo'. —Top nooch u sip'il. Qui' ca' quimsabüc,— cu t'anoo' ti'i ti uchoo' u nuuc. ");
INSERT INTO mopNT_vpl VALUES ("MK14_65","071_14_65","MRK","14","65","65","Tu yaamoo' a que'enoo' te'iji, yan a cajoo' u tuubte u wich a Jesusu. U tepajoo' u wich a Jesus etel noc'. Moch'a'anoo' u c'ü' ca' u pa'loxtajoo'. —Na'te maqui u jütz'ajech,— cu t'anoo' ti'i. Ca' c'ubbi ti'ijoo' a soldadojo. U jütz'ajoo' a Jesus ti tanoo' u ca' müchic ala'aji. ");
INSERT INTO mopNT_vpl VALUES ("MK14_66","071_14_66","MRK","14","66","66","Pues te'i. Tina'an ti que'en aj Pedro pach naj ich cot. Jun tuul ix meyaj ti'i a winic a mas nooch u wichil u meyaj tu yaamoo' u yaj mansaj t'an a cristiano ti'i a Dioso, mani te'i. ");
INSERT INTO mopNT_vpl VALUES ("MK14_67","071_14_67","MRK","14","67","67","U yilaj aj Pedro ti tan u q'uiich chi' c'aac'. U cha'antaj aj Pedrojo. —Inchech ilic u yaj cambal a Jesus a tali caj Nazaret,— cu t'an ti'i aj Pedrojo. ");
INSERT INTO mopNT_vpl VALUES ("MK14_68","071_14_68","MRK","14","68","68","U yadaj ti ma' le'equi. —Ma' in weel c'u' a tan a wadiqui, ma'ax tan in ch'a'ic u tojil a t'an,— cu t'an aj Pedro ti'iji. Joq'ui te'i aj Pedrojo. Bini tuba que'en u chi' a coto. Uchi u yawat aj t'ele. ");
INSERT INTO mopNT_vpl VALUES ("MK14_69","071_14_69","MRK","14","69","69","Ilbi u men ix meyaja. Caji tzolbol ti'ijoo' a que'en te'iji. —Inchech jun tuul u yet'oc a Jesusu,— cu t'an ti'i. ");
INSERT INTO mopNT_vpl VALUES ("MK14_70","071_14_70","MRK","14","70","70","Aj Pedrojo, u ca' adaj ti ma' u yeel a Jesusu. Sansamijac tu pach abe'e, ca' chiitbi aj Pedro u menoo' a que'en te'iji. —Tu jajil inchech jun tuul u yet'oc ala'aji, u men aj Galileajilech ilic,— cu t'anoo' ti'i. ");
INSERT INTO mopNT_vpl VALUES ("MK14_71","071_14_71","MRK","14","71","71","—U yeel a Dios ti jaj in t'an ti ma'ax jun sut ti c'aj-oolte ti bajil etel a winic abe' a tane'ex a wadiqui,— cu t'an aj Pedro ti'ijoo'o. ");
INSERT INTO mopNT_vpl VALUES ("MK14_72","071_14_72","MRK","14","72","72","Tu seebal uchi u yawat u ca' sut aj t'ele. C'aji ti'i aj Pedro u t'an a Jesus u yadaj ti ma'ax to müchbüc. —Le'ec ti ma'ax to uchuc u yawat u ca' sut aj t'ele, ac ox sut tun a wadü' ti ma' a weel in wich,— cu t'an a Jesus ti'iji. Le'ec ti c'aji ti'i abe'e, uchi u yoc'ol. ");
INSERT INTO mopNT_vpl VALUES ("MK15_1","071_15_1","MRK","15","1","1","Pues te'i. Le'ec ti sasajiji, much'lajoo' tu seebal u noochiloo' u yaj mansaj t'an a cristiano ti'i a Dios u yet'ocoo' a nucuch winic eteloo' u yaj ca'ansajil u ley aj Moisese. Le'ecoo' u chucaan a walacoo' u much'tal eteloo' ala'oo'o, much'lajoo' ilic xan. U tzicbaltajoo' c'u' a ca' u betoo' etel a Jesusu. U c'üxajoo' a Jesusu. U bensajoo' etel aj gobernador Pilatojo. U c'ubajoo' ti'i. ");
INSERT INTO mopNT_vpl VALUES ("MK15_2","071_15_2","MRK","15","2","2","—¿Inchech wa u reyoo' aj Israele?— cu t'an aj Pilato ti'iji. —Inen,— cu t'an a Jesus ti'iji. ");
INSERT INTO mopNT_vpl VALUES ("MK15_3","071_15_3","MRK","15","3","3","Yaab biqui ti tzolbi a Jesus u menoo' u noochiloo' u yaj mansaj t'an a cristiano ti'i a Dioso. ");
INSERT INTO mopNT_vpl VALUES ("MK15_4","071_15_4","MRK","15","4","4","—¿Ma' wa bel a ca'a a nuuctoo'? U'yi boon a tanoo' u tzolic ta woc'olo,— cu t'an aj Pilato ti'i a Jesusu. ");
INSERT INTO mopNT_vpl VALUES ("MK15_5","071_15_5","MRK","15","5","5","Ma' u ca' nuuctaj a ma'ax c'u'i a Jesusu. Sa'ti u yool aj Pilato u men abe'e. ");
INSERT INTO mopNT_vpl VALUES ("MK15_6","071_15_6","MRK","15","6","6","Pues te'i. Le'ec ti tan a fiesta abe'e, suc aj Pilato u cha'ic ti'ijoo' a cristiano jun tuul ca' joc'oc ti presojil. Walac u cha'ic mac a ca' u c'aatoo' a cristiano ca' joc'oco. ");
INSERT INTO mopNT_vpl VALUES ("MK15_7","071_15_7","MRK","15","7","7","Aj Barrabas u c'aba' a jun tuul a que'en ti presojil eteloo' u chucaan a boon tuul u yaaltajoo' u joq'ues a gobiernojo. Ala'aji, u quimsaj a mac ti tanoo' u yaaltic u joq'ues a gobiernojo. ");
INSERT INTO mopNT_vpl VALUES ("MK15_8","071_15_8","MRK","15","8","8","Pues te'i. C'ochoo' a cristiano etel aj Pilatojo. Cajoo' u c'aate ti'i ca' u bete' a jabix ilic ti suc u bete' ti'i a jun p'eel a q'uin abe'e. ");
INSERT INTO mopNT_vpl VALUES ("MK15_9","071_15_9","MRK","15","9","9","—¿Ma' wa qui' ta wiche'ex ca' in cha'e'ex a reyile'ex aj Israele'exe?— cu t'an aj Pilato ti'ijoo' a cristianojo. ");
INSERT INTO mopNT_vpl VALUES ("MK15_10","071_15_10","MRK","15","10","10","U yeel ti chen u men u xüc-ooliloo' u noochiloo' u yaj mansaj t'an a cristiano ti'i a Dioso, u c'ubajoo' a Jesus ti'iji. ");
INSERT INTO mopNT_vpl VALUES ("MK15_11","071_15_11","MRK","15","11","11","Le'ecoo' u noochiloo' u yaj mansaj t'an a cristiano ti'i a Dioso, u choct'antajoo' a cristiano ca' cha'büc aj Barrabas u men aj Pilatojo, y ma' le'ec a Jesus jabix u c'ati aj Pilatojo. ");
INSERT INTO mopNT_vpl VALUES ("MK15_12","071_15_12","MRK","15","12","12","—¿C'u' a c'ate'ex ca' in bete' etel a mac a walaque'ex a chiitic jabix a reye'ex aj Israele'exe?— cu t'an aj Pilato ti'ijoo'o. ");
INSERT INTO mopNT_vpl VALUES ("MK15_13","071_15_13","MRK","15","13","13","—Adü ca' tz'abüc tuwich cruz,— cu t'anoo' a cristiano ti'i tucaye'il. ");
INSERT INTO mopNT_vpl VALUES ("MK15_14","071_15_14","MRK","15","14","14","—¿C'u' aj yoc'lal? ¿C'u' ti sip'ilil u betaj?— cu t'an aj Pilato ti'ijoo'o. —Adü ca' tz'abüc tuwich cruz,— cu t'anoo' ti chich yaab sut. ");
INSERT INTO mopNT_vpl VALUES ("MK15_15","071_15_15","MRK","15","15","15","Aj Pilatojo, u c'ati cuchi u jetz'cuntoo' u yool a cristianojo, mentücü, u cha'aj aj Barrabas ti'ijoo'o. U tz'aj ca' jütz'büc a Jesus etel jatz' ca' tun u c'ubaj ti'i ca' quimsabüc tuwich cruz. ");
INSERT INTO mopNT_vpl VALUES ("MK15_16","071_15_16","MRK","15","16","16","Pues te'i. Le'ecoo' a soldadojo, u yocsajoo' a Jesus yotoch caj. U much'quintajoo' u chucaan a soldado tuba que'en a Jesusu. ");
INSERT INTO mopNT_vpl VALUES ("MK15_17","071_15_17","MRK","15","17","17","U tz'ajoo' a noc' a jabix u color ix yames yoc'ol a Jesusu, ca' ilbic jabix rey ala'aji. U copajoo' a q'ui'ixi, ca' p'aatüc jabix corona. U tz'ajoo' tu pol a Jesusu. ");
INSERT INTO mopNT_vpl VALUES ("MK15_18","071_15_18","MRK","15","18","18","Cajoo' u yadü' ti'i a Jesusu: —Inchech u reyoo' aj Israele. Qui'ac a wool,— cu t'anoo' ti'i a Jesusu. ");
INSERT INTO mopNT_vpl VALUES ("MK15_19","071_15_19","MRK","15","19","19","U jütz'ajoo' a Jesus tu pol etel a bequech che'e. U tuubtajoo' a Jesusu. Xonlajoo' tu taan jabix cuchi tanoo' u tz'ocsic u yanil a Jesusu. ");
INSERT INTO mopNT_vpl VALUES ("MK15_20","071_15_20","MRK","15","20","20","Le'ec ti jobi u p'a'asticoo'o, u joc'sajoo' a noc' u tz'ajoo' yoc'olo. U ca' tz'ajoo' u noc' a ti'i iliqui. U bensajoo' a Jesus ti'i u tz'eecaloo' tuwich cruz. ");
INSERT INTO mopNT_vpl VALUES ("MK15_21","071_15_21","MRK","15","21","21","Pues te'i. Yan jun tuul a winiqui, aj Simon u c'aba'. Aj Alejandro y aj Rufo u c'aba'oo' u mejen. Cirene u c'aba' u caal aj Simono. Joq'ui to ich aldea. C'ümbi ti bej tuba tan u bensabül a Jesusu. Müchbi u menoo' a soldadojo. Tz'abi ti'i ca' u c'oochte u cruz a Jesusu. ");
INSERT INTO mopNT_vpl VALUES ("MK15_22","071_15_22","MRK","15","22","22","Pues te'i. Le'ecoo' a soldadojo, u bensajoo' a Jesus ichil jun p'eel cuuchil Golgota u c'aba'. U pol quimen u nu'cul a t'an abe'e. ");
INSERT INTO mopNT_vpl VALUES ("MK15_23","071_15_23","MRK","15","23","23","U tz'ajoo' cuchi ti'i ca' u yuc'u' a vino a xaaba'an etel u c'a' a pocche' u c'aba' mirra ti'i ma' top u yubic a yaja. C'u' betiqui, ma' u yuc'aji. ");
INSERT INTO mopNT_vpl VALUES ("MK15_24","071_15_24","MRK","15","24","24","U tz'ajoo' a Jesus tuwich cruz. U tz'ajoo' a bul a soldado ti'i ca' u t'oxoo' u noc' a Jesus tu bajiloo'o. ");
INSERT INTO mopNT_vpl VALUES ("MK15_25","071_15_25","MRK","15","25","25","A las nueve ti jatz'ca', tz'abi a Jesus tuwich u cruzil u menoo'o. ");
INSERT INTO mopNT_vpl VALUES ("MK15_26","071_15_26","MRK","15","26","26","—U reyoo' aj Israel,— cu t'an a t'an a tz'iiba'an yoc'ol a Jesus tuba tz'iiba'an cuchi u sip'il. ");
INSERT INTO mopNT_vpl VALUES ("MK15_27","071_15_27","MRK","15","27","27","Pues te'i. Tz'aboo' ilic ca' tuul aj xuuch' tuwich cruz. Jujun tuul tuwich u cruzil jujun xeel a Jesusu. ");
INSERT INTO mopNT_vpl VALUES ("MK15_28","071_15_28","MRK","15","28","28","Baalo' ti jajaji u t'an a Dios tuba tz'iiba'an ti bel u ca'a xocbol tu yaamoo' a yan u sip'il jabix cuchi yan ilic u sip'il ala'aji. ");
INSERT INTO mopNT_vpl VALUES ("MK15_29","071_15_29","MRK","15","29","29","Pues te'i. Le'ec a tanoo' u manül te'iji, u yuuc'tajoo' u pol ti tanoo' u p'a'astic a Jesusu. —Le'ec acana' a tan a cüxtiqui. Wa jede'ec u paatal a yojic u yotoch a Dios y a ca' wa'cuntic ich ox p'e q'uini, ");
INSERT INTO mopNT_vpl VALUES ("MK15_30","071_15_30","MRK","15","30","30","sa'alte a bajil. Joq'uen tuwich a cruzu,— cu t'anoo' ti tanoo' u p'a'as. ");
INSERT INTO mopNT_vpl VALUES ("MK15_31","071_15_31","MRK","15","31","31","Pues te'i. Tanoo' ilic u p'a'astic a Jesus u noochiloo' u yaj mansaj t'an a cristiano ti'i a Dios u yet'ocoo' u yaj ca'ansajil u ley aj Moisese. —Ca wilic. U sa'altaj ulaac'oo' a maca, pero ma' patal u sa'alte u bajil,— cu t'anoo' tu bajil. ");
INSERT INTO mopNT_vpl VALUES ("MK15_32","071_15_32","MRK","15","32","32","—Wa cuchi le'ec, u yaj Sa'alil a cristianojo, wa cuchi le'ec, ti rey ino'on aj Israelo'ono, jede'ec cuchi u joc'ol tuwich a cruzu. Ti baalo'o, jede'ec cuchi ti wiliqui. Jede'ec ilic cuchi ti tz'ocsiqui,— cu t'anoo' tu bajil. P'a'asbi ilic a Jesus u menoo' a que'enoo' tuwich u cruz tu tzeele. ");
INSERT INTO mopNT_vpl VALUES ("MK15_33","071_15_33","MRK","15","33","33","Pues te'i. Jabix wal chuunq'uin ac'ü'aji a yoc'olcab asto ti jabix wal a las tres ti ocq'uini. ");
INSERT INTO mopNT_vpl VALUES ("MK15_34","071_15_34","MRK","15","34","34","Jabix a las tres ti ocq'uini, uchi u t'an ti chich a Jesusu. —¿Eloi, Eloi, lama sabactani?— cu t'an a Jesusu. —In Dios, in Dios, ¿c'u' ca'a a p'ütiquen?— cu t'an a t'an abe'e. ");
INSERT INTO mopNT_vpl VALUES ("MK15_35","071_15_35","MRK","15","35","35","Pues te'i. Yan a wa'anoo' te'iji. U yubajoo' c'u' u yadaj a Jesusu. —U'ye'ex. Tan u püyic aj quimen Eliasa,— cu t'anoo' tu bajil. ");
INSERT INTO mopNT_vpl VALUES ("MK15_36","071_15_36","MRK","15","36","36","Jun tuul tu yaamoo'o, joq'ui ti alca. U molaj jun p'eel ba'al jabix tümünü. U tzümaj ichil a vino a top ema'an u toolo. U tz'aj tu ni' a bequech che'e. U tz'aj tu chi' a Jesus ca' u yuc'u'. —Pa'te ti wilic wa ca' uduc aj Elias u joq'ues tuwich a cruzu,— cu t'an ala'aji. ");
INSERT INTO mopNT_vpl VALUES ("MK15_37","071_15_37","MRK","15","37","37","Uchi u t'an ti chich a Jesusu. Quimi. ");
INSERT INTO mopNT_vpl VALUES ("MK15_38","071_15_38","MRK","15","38","38","Tzili a noc' a xit'a'an ti'i u colocche'il a ichil u yotoch a Dioso. Caji u tziilil yoc'ol tac yalam. P'aati ca' xeet. ");
INSERT INTO mopNT_vpl VALUES ("MK15_39","071_15_39","MRK","15","39","39","Pues te'i. Le'ec u noochiloo' a soldadojo, wa'an ti que'en tu taan a Jesusu. Le'ec ca' u yilaj biqui ti quimiji, u yadaj: —Tu jajil le'ec a winic ada'a, u Mejen Dios,— cu t'an. ");
INSERT INTO mopNT_vpl VALUES ("MK15_40","071_15_40","MRK","15","40","40","Pues te'i. Que'enoo' ilic ix ch'up te'i a tanoo' u cha'antic a Jesus ti naacha. Tu yaamoo' ala'oo' que'en ixna' Maria Magdalena u yet'oc ixna' Maria le'ec u na'oo' aj Jacob a ma' yaab u jaab etel aj Joseje. Que'en ilic te'i ixna' Salome. ");
INSERT INTO mopNT_vpl VALUES ("MK15_41","071_15_41","MRK","15","41","41","Le'ec ti que'en to a Jesus ich cuenta Galileaja, tücünacoo' ix ch'up abe' tu pacha. Walacoo' u yaantic. Tanoo' ilic u cha'antic a Jesus ti naach ulaac'oo' ix ch'up u yetc'ocholoo' a Jesus ti bini ich caj Jerusalen. ");
INSERT INTO mopNT_vpl VALUES ("MK15_42","071_15_42","MRK","15","42","42","Pues te'i. Le'ec a q'uin ti quimsabi a Jesusu, u q'uinil u yutzquinbil tulacal a c'u'ac tac ti'i u q'uinil jedel, u men samalac yan u q'uinil a jedele. Watac u yocol a q'uini, ");
INSERT INTO mopNT_vpl VALUES ("MK15_43","071_15_43","MRK","15","43","43","ti bini etel aj Pilato jun tuul u c'aate u büq'uel a Jesus ca' tz'abüc ti'i ti'i ca' u mucu'. Le'ec a chichaji u yool u c'aate ti baalo', le'ec aj Jose a tala'an ich caj Arimatea. Ala'aji, jun tuul tu yaamoo' a nucuch winiqui. Top walac u tz'ocsabül u yanil aj Joseje. Tan ilic u paac'tic u c'ochol u q'uinil u tücaa' a Dioso. ");
INSERT INTO mopNT_vpl VALUES ("MK15_44","071_15_44","MRK","15","44","44","Sa'ti u yool aj Pilato ca' u yubaj ti ac quimi tun a Jesusu, u men top jomol. U püyaj u noochiloo' a soldadojo. U c'aataj ti'i wa quimi tun a Jesusu. ");
INSERT INTO mopNT_vpl VALUES ("MK15_45","071_15_45","MRK","15","45","45","Le'ec ca' u yubaj etel u noochiloo' a soldado ti quimi tun a Jesusu, u yadaj ca' cha'büc u büq'uel ti'i aj Joseje. ");
INSERT INTO mopNT_vpl VALUES ("MK15_46","071_15_46","MRK","15","46","46","Aj Joseje, u q'uexaj a süc noc' a top quich'pana. U yemsaj u büq'uel a Jesusu. U bülaj etel a süc noc' abe'e. Yan a tunich te'i tuba paanbi a tz'i' cuarto ichil ti'i u cuuchil u mucbeeb a quimene. U coyquintaj a Jesus te'iji. U c'oc'lesaj a tunich tu chi' ti'i u c'ülbeeb. ");
INSERT INTO mopNT_vpl VALUES ("MK15_47","071_15_47","MRK","15","47","47","Ilbi tuba mucbi u men ixna' Maria Magdalena u yet'oc ixna' Maria le'ec u na' ulaac' aj Joseje. ");
INSERT INTO mopNT_vpl VALUES ("MK16_1","071_16_1","MRK","16","1","1","Pues te'i. Mani tun u q'uinil a jedele. Le'ec ixna' Maria Magdalena u yet'ocoo' ixna' Maria le'ec u na' aj Jacob etel ixna' Salomeje, u q'uexajoo' a boc ti'i u beeloo' u tz'aa' yoc'ol a Jesusu. ");
INSERT INTO mopNT_vpl VALUES ("MK16_2","071_16_2","MRK","16","2","2","Sasaji tun ti qui' ti Domingo ti binoo' tuba mucbi a Jesusu. ");
INSERT INTO mopNT_vpl VALUES ("MK16_3","071_16_3","MRK","16","3","3","Tanoo' u c'aatic tu bajil mac ca' u joq'ues a tunich tu chi' tuba mucbi a Jesusu. ");
INSERT INTO mopNT_vpl VALUES ("MK16_4","071_16_4","MRK","16","4","4","Ca' u yilaja, ac c'oc'lesaja'an a noxi' tunich abe'e. ");
INSERT INTO mopNT_vpl VALUES ("MK16_5","071_16_5","MRK","16","5","5","Ocoo' ichil a cuarto a paana'an ich tunich tuba mucbi a Jesusu. U yilajoo' a ch'ajom tina'an tu yaj toj tu yaj seeb c'ü'. Süc y chawac u noc'. Sa'too' u yool. ");
INSERT INTO mopNT_vpl VALUES ("MK16_6","071_16_6","MRK","16","6","6","—Ma' u jac'üle'ex a wool,— cu t'an a ch'ajom ti'ijoo'o. —Tane'ex a cüxtic a Jesus a ch'iji ich caj Nazaret. Quimsabi ala'i tuwich cruz. Ca' cuxlaji. Ma' wa'ye' que'eni,— cu t'an a ch'ajom ti'ijoo'o. —Ile'ex tuba coyquinbi ");
INSERT INTO mopNT_vpl VALUES ("MK16_7","071_16_7","MRK","16","7","7","ca' tun xique'ex a wadü' ti'i aj Pedro u yet'ocoo' u chucaan u yaj cambal a Jesus ti bel u ca'a a Jesus taaniloo' ich cuenta Galilea. “Te'i a wilique'ex ala'aji, jabix ilic u yadaj te'exe,” que'exac ti'ijoo',— cu t'an ti'ijoo' ix ch'upu. ");
INSERT INTO mopNT_vpl VALUES ("MK16_8","071_16_8","MRK","16","8","8","Pues te'i. Joc'oo' tuba mucbi a Jesusu. Tzützülnacoo' y sa'too' u yool, mentücü, binoo' ti alca'. Ma' u yadaj a ma'ax c'u'i ti'i ma'ax mac u menoo' u saaquil. ");
INSERT INTO mopNT_vpl VALUES ("MK16_9","071_16_9","MRK","16","9","9","Pues te'i. Jatz'ca' ti qui' ti Domingo ti ca' cuxlaji a Jesusu. Payanbej u ye'aj u bajil ti'i ixna' Maria Magdalena. Joc'sabi siete tuul a c'ac'asba'al tu yool a nooch'up abe' u men a Jesus uchi. ");
INSERT INTO mopNT_vpl VALUES ("MK16_10","071_16_10","MRK","16","10","10","Bini a nooch'up abe' u yadü' u pectzil ti'ijoo' u yetmanül a Jesusu. Tanoo' u yoc'ol ala'oo' ti udi a nooch'upu. Tanoo' u yoc'tic a quimene. ");
INSERT INTO mopNT_vpl VALUES ("MK16_11","071_16_11","MRK","16","11","11","Le'ec ca' u yubajoo' ti ca' cuxlaji a Jesus y ilbi u men a nooch'up abe'e, ma' u tz'ocsajoo' u t'ani. ");
INSERT INTO mopNT_vpl VALUES ("MK16_12","071_16_12","MRK","16","12","12","Pues te'i. Jumpaay u wich ti chiclaji a Jesus ti'ijoo' ca' tuul u yaj cambal a tanoo' u beel ich aldeaja. ");
INSERT INTO mopNT_vpl VALUES ("MK16_13","071_16_13","MRK","16","13","13","Usc'ajoo' a ca' tuul abe' u yadü' u pectzil ti'ijoo' u chucaan u yaj cambal a Jesusu. Ma'ax ala'oo'o, ma' tz'ocsaboo' u t'an. ");
INSERT INTO mopNT_vpl VALUES ("MK16_14","071_16_14","MRK","16","14","14","Pues te'i. Mas pachili, que'enoo' a once tuul u yaj cambal a Jesus pach mesa ti janal. Chiclaji a Jesus ti'ijoo'o. U tze'ectajoo' u yaj cambal u men ma' tanoo' u tz'ocsaj t'an. Top chichoo' u pol u tz'oquesoo' mac u yilaj ti ca' cuxlaji a Jesusu. ");
INSERT INTO mopNT_vpl VALUES ("MK16_15","071_16_15","MRK","16","15","15","—Ca' xique'ex tulacal tubajac yoc'olcab. Ade'ex ti'ijoo' tulacal a mac biqui ca' sa'albücoo',— cu t'an a Jesus ti'ijoo'o. ");
INSERT INTO mopNT_vpl VALUES ("MK16_16","071_16_16","MRK","16","16","16","—Le'ec mac ca' u tz'oques y ca' u c'ümü' a ocja'a, bel u ca'a sa'albül. Le'ec mac a ma' tu tz'ocsiqui, bel u ca'a pulbul ichil a infiernojo,— cu t'an a Jesusu. ");
INSERT INTO mopNT_vpl VALUES ("MK16_17","071_16_17","MRK","16","17","17","—Le'ecoo' aj tz'ocsaj t'ana, baala' u p'is a beloo' u cu bete' etel in c'aba' ti'i ca' chiclac u jajiloo' u t'an. Beloo' u cu joq'ues a c'ac'asba'al tu yool a maca. Beloo' u ca'a ti t'an ichil a t'an a jujumpaay u wich a ma' u yeele,— cu t'an a Jesusu. ");
INSERT INTO mopNT_vpl VALUES ("MK16_18","071_16_18","MRK","16","18","18","—Beloo' u cu müchü' a cana. Wa cuchi ca' u yuc'oo' a venenojo, ma' tu yubicoo' u q'uinam. Beloo' u cu tz'aa' u c'ü' yoc'oloo' a c'oja'ana, y beloo' u ca'a ti ch'anül,— cu t'an a Jesus ti'ijoo' u yaj cambala. ");
INSERT INTO mopNT_vpl VALUES ("MK16_19","071_16_19","MRK","16","19","19","Pues te'i. Le'ec ti jobi a Jesus ti tzicbal eteloo'o, nac'sabi ti ca'an. Tinlaji tu yaj toj tu yaj seeb c'ü' a Dios u men u yanil. ");
INSERT INTO mopNT_vpl VALUES ("MK16_20","071_16_20","MRK","16","20","20","Binoo' u yaj cambal tulacal tubajac yoc'olcab. U yadajoo' u pectzil a Dios ti'ijoo' a cristianojo. Aantaboo' u men a Noochtzili. Ye'bi ti jajoo' u t'an etel u p'is, le'ec a milagro u betajoo'o. Wa'ye' jobi a t'ana.");
INSERT INTO mopNT_vpl VALUES ("LK1_1","072_1_1","LUK","1","1","1","Yanoo' mac u tz'iibtajoo' c'u' u betaj etel c'u' u c'ümaj a Cristo ti que'en tiqui yaama. ");
INSERT INTO mopNT_vpl VALUES ("LK1_2","072_1_2","LUK","1","2","2","Jabix ilic ti aalbi to'on, baalo' ilic ca' u tz'iibtajoo'. Aalbi to'on abe' u men mac u yilajoo' c'u' a uchi tac tu cajeebe. Ala'oo'o, u yadajoo' ilic u pectzil a Dioso. ");
INSERT INTO mopNT_vpl VALUES ("LK1_3","072_1_3","LUK","1","3","3","Le'ec tulacal a c'u' u yadajoo' biq'uin ado' yoc'ol c'u' a maniji, in tz'aj tin wool. Noochwinic Teofilo, in c'ati ilic xan in tz'iibte tech u tojil yoc'ol a Cristojo. ");
INSERT INTO mopNT_vpl VALUES ("LK1_4","072_1_4","LUK","1","4","4","Ti baalo'o, jede'ec a ch'a'ic u tojil biqui ti uchi tulacal a c'u' a aalbi teche. ");
INSERT INTO mopNT_vpl VALUES ("LK1_5","072_1_5","LUK","1","5","5","Pues te'i. Uchi yan jun tuul a winiqui, aj Zacarias u c'aba'. Ala'aji, le'ec jun tuul tu yaam a jun muuch' a walacoo' u mansic u t'an a cristiano ti'i a Dioso. Abias u c'aba' a jun muuch'oo' abe'e. Ti a q'uin abe'e, que'en aj Herodes ti reyil tu caal aj Zacariasa. Cuenta Judea u c'aba' u caal aj Zacariasa. Le'ec u yütan aj Zacariasa, ixna' Elisabet u c'aba'. Le'ec u yaj uchben mamaa' ixna' Elisabete, aj Aaron u c'aba'. Le'ec aj Aaron abe'e, u tatoo' aj mansaj t'an a cristiano ti'i a Dioso. ");
INSERT INTO mopNT_vpl VALUES ("LK1_6","072_1_6","LUK","1","6","6","Tu yilic a Dioso, tojoo' u na'at aj Zacarias etel ixna' Elisabete. Walacoo' u tz'ocsic tulacal a boon u ley y u t'an a Dioso. ");
INSERT INTO mopNT_vpl VALUES ("LK1_7","072_1_7","LUK","1","7","7","C'u' betiqui, ma' yan ma'ax jun tuul u mejen. Ma' tu paatal u yantal u yal ixna' Elisabete. Top yaab tun u jaab a ca' tuulu. ");
INSERT INTO mopNT_vpl VALUES ("LK1_8","072_1_8","LUK","1","8","8","Pues te'i. C'ochi u q'uinil u betic u meyaj a jun muuch' aj mansaj t'an a cristiano ti'i a Dioso. Te'i que'en aj Zacarias tu yaamoo' ala'oo'o. ");
INSERT INTO mopNT_vpl VALUES ("LK1_9","072_1_9","LUK","1","9","9","Sucoo' u baxülte a bul ti'i u ye'icaloo' u wich u meyaj tu betic a jujun tuul u yaj mansaj t'an a cristiano ti'i a Dioso. Le'ec aj Zacariasa, ye'bi ti'i etel bul ca' ococ ichil u yotoch a Noochtzil u chuwu' a pomo. ");
INSERT INTO mopNT_vpl VALUES ("LK1_10","072_1_10","LUK","1","10","10","Tulacaloo' aj Israele, que'enoo' pach naj ti c'ochi u yorajil u chuwbul a pomo. Tanoo' u t'an etel a Dios te'iji. ");
INSERT INTO mopNT_vpl VALUES ("LK1_11","072_1_11","LUK","1","11","11","Ichil a naj abe' que'en u mesajil tuba walac u chuwbul a pomo. Te'i que'en aj Zacarias ti chiclaji ti'i jun tuul u yaj xa'num a Dios ti ca'an tu yaj toj tu yaj seeb c'ü'. ");
INSERT INTO mopNT_vpl VALUES ("LK1_12","072_1_12","LUK","1","12","12","Le'ec ca' u yilaj ala'aji, jaq'ui u yool. Saacaji tu jajil. ");
INSERT INTO mopNT_vpl VALUES ("LK1_13","072_1_13","LUK","1","13","13","—Zacarias, ma' a saactal. U'yajbi c'u' a c'aataj ti'i a Dioso,— cu t'an u yaj xa'num a Dios ti ca'an ti'iji. —Le'ec a wütan ixna' Elisabete, bel u ca'a ti yantal u yal. Aj Juan u c'aba' ca' a tz'aa' a xidal abe'e,— cu t'an ti'i. ");
INSERT INTO mopNT_vpl VALUES ("LK1_14","072_1_14","LUK","1","14","14","—Bel u ca'a ti qui'tal a wool tu jajil. Yanoo' a beloo' u ca'a ti qui'tal u yool u men yanaji ala'aji,— cu t'an u yaj xa'num a Dioso. ");
INSERT INTO mopNT_vpl VALUES ("LK1_15","072_1_15","LUK","1","15","15","—Ocol u ca'a ti ma'lo' winic tu taan a Noochtzili. Ma' tu yuq'uic a vinojo, y ma' tu yuq'uic tulacal a ba'al a walac u caalesaj,— cu t'an. —Bel u ca'a ti ocol u Püsüc'al a Dios ichil u püsüc'al le'ec ti que'en to ichil u nüc' u na',— cu t'an ti'i aj Zacariasa. ");
INSERT INTO mopNT_vpl VALUES ("LK1_16","072_1_16","LUK","1","16","16","—Yanoo' aj Israel a beloo' u ca'a aantabül u men aj Juan ca' jumbelacoo' u tucul etel a Noochtzil le'ec u Diosiloo',— cu t'an. ");
INSERT INTO mopNT_vpl VALUES ("LK1_17","072_1_17","LUK","1","17","17","—Le'ec aj Juana, paye' bel u ca'a u yadü' u pectzil a Noochtzil ca' tun c'ochoc a Noochtzili,— cu t'an. —Tz'abi u Püsüc'al a Dios y u patalil ti'i aj Eliasa, le'ec jun tuul u yadaj u t'an a Dios uchi. Bel ilic u ca'a tz'abül a jabix abe' ti'i aj Juan ti'i ca' u qui'cuntoo' u yool boon a tattzil eteloo' u mejene,— cu t'an. —Etel ilic abe'e, bel u cu yaantoo' a ma' qui'oo' u na'at ca' joc'oc ti tojoo' u na'at. Bel ilic u cu tojquintoo' u na'at a cristiano ti'i ca' u c'ümoo' a Noochtzili,— cu t'an u yaj xa'num a Dios ti ca'an ti'i aj Zacariasa. ");
INSERT INTO mopNT_vpl VALUES ("LK1_18","072_1_18","LUK","1","18","18","—¿Biqui ca' in weelte wa jaj ti uchul u ca'a c'u' a wadaj tene,— cu t'an aj Zacariasa. —Noochwiniquen tun ti qui'. Yaab ilic u jaab in wütan. ¿Biqui ca' yanac u yal?— cu t'an aj Zacarias ti'iji. ");
INSERT INTO mopNT_vpl VALUES ("LK1_19","072_1_19","LUK","1","19","19","—Inene, aj Gabrielen. Walac in meyaj jiil tu taan a Dioso. U tücaa'tajen ta wetel ti tzicbal y ti'i in wadic tech a qui'il t'an in wadaja,— cu t'an ti'i aj Zacariasa. ");
INSERT INTO mopNT_vpl VALUES ("LK1_20","072_1_20","LUK","1","20","20","—U'yi in t'an. Bestal a ca'a. Ma' tu paatal a t'an asto u c'ochol u q'uinil u yantal a mejen jabix ca' in wadaj u men ma' a tz'ocsaj in t'an. Ca' c'ochoc u q'uinili, bel u ca'a ti uchul a c'u' in wadaja,— cu t'an aj Gabriel ti'iji. ");
INSERT INTO mopNT_vpl VALUES ("LK1_21","072_1_21","LUK","1","21","21","Pues te'i. Le'ecoo' a cristianojo, tanoo' u paac'tic u joc'ol aj Zacarias ichil u yotoch a Dioso. Sa'too' u yool u men top xanaji. ");
INSERT INTO mopNT_vpl VALUES ("LK1_22","072_1_22","LUK","1","22","22","Le'ec ti joq'ui aj Zacariasa, besaji tun. Ma' ca' patal ti t'an eteloo'. U na'tajoo' ti u yilaj c'u'ac ichil a jabix nümül ichil u yotoch a Dioso. U pecsaj u c'ü' ti'ijoo', pero culaji ti bes ala'aji. ");
INSERT INTO mopNT_vpl VALUES ("LK1_23","072_1_23","LUK","1","23","23","Le'ec ti mani u q'uinil u meyaj te'iji, usc'aji tu yotoch. ");
INSERT INTO mopNT_vpl VALUES ("LK1_24","072_1_24","LUK","1","24","24","Pachil abe'e, ba'la'anaji u yütan, le'ec ixna' Elisabete. Cinco uj u mucaj u bajil a nooch'upu. ");
INSERT INTO mopNT_vpl VALUES ("LK1_25","072_1_25","LUK","1","25","25","—Le'ec a Noochtzili, u yaantajen, mentücü, ba'la'anajeen. U yilajen tu qui'il. Aleebe ma' tin ca' p'a'asbül tucaye'il u menoo' a cristianojo,— cu t'an tu bajil. ");
INSERT INTO mopNT_vpl VALUES ("LK1_26","072_1_26","LUK","1","26","26","Pues te'i. Le'ec aj Gabriele, u yaj xa'num a Dios ti ca'ana. Seis uj ba'la'anac ixna' Elisabet ti tücaa'bi aj Gabriel tucaye' u men a Dios ca' xi'ic ich caj Nazaret. Que'en tu cuenta Galilea a caj abe'e. ");
INSERT INTO mopNT_vpl VALUES ("LK1_27","072_1_27","LUK","1","27","27","Te'i que'en jun tuul ix chu'u, ix Maria u c'aba'. Aj Gabriele, yan u yadic u xa'numbeeb ti'i. Ix chu' to ix Mariaja. Ma' yan a winic ti'iji, pero ac c'aata'an u men aj Jose. Le'ec u uchben mamaa' aj Joseje, le'ec aj rey Davidi. ");
INSERT INTO mopNT_vpl VALUES ("LK1_28","072_1_28","LUK","1","28","28","Pues te'i. C'ochi u yaj xa'num a Dios ti ca'an etel ix Mariaja. —Qui'ac a wool,— cu t'an aj Gabriel ti'iji. —Tan u yiliquech tu qui'il a Noochtzili. Tz'abi tech mas qui'il tuwichoo' tulacal u chucaan ix ch'upu,— cu t'an ti'i. ");
INSERT INTO mopNT_vpl VALUES ("LK1_29","072_1_29","LUK","1","29","29","C'u' betiqui, sa'ti u yool ix Maria u men c'u' a aalbi ti'iji. Caji u tucle c'u' u nu'cul a t'an a aalbi ti'iji. ");
INSERT INTO mopNT_vpl VALUES ("LK1_30","072_1_30","LUK","1","30","30","—Maria, ma' u jac'ül a wool. Qui' u yool a Dios ta wetel,— cu t'an u yaj xa'num a Dios ti ca'an ti'iji. ");
INSERT INTO mopNT_vpl VALUES ("LK1_31","072_1_31","LUK","1","31","31","—U'yi in t'an. Bel a ca'a ti ba'la'antal. Bel u ca'a ti yantal a wal xidal. Jesus u c'aba' ca' a tz'aa',— cu t'an u yaj xa'num a Dios ti ca'an ti'i ix Mariaja. ");
INSERT INTO mopNT_vpl VALUES ("LK1_32","072_1_32","LUK","1","32","32","—Yaabtal u ca'a u patalil tu jajil. Bel u ca'a aalbül ti le'ec, u Mejen a Dios ti ca'ana. Tz'abül u ca'a ti reyil tu jel u uchben mamaa' aj rey David u men a Noochtzil a Dioso,— cu t'an ti'i ix chu'u. ");
INSERT INTO mopNT_vpl VALUES ("LK1_33","072_1_33","LUK","1","33","33","—Ma' yan q'uin u jobol u tücaa'ticoo' aj Israel a Jesusu. Ocol u ca'a ti reyil jumpul,— cu t'an u yaj xa'num a Dios ti ca'an ti'iji. ");
INSERT INTO mopNT_vpl VALUES ("LK1_34","072_1_34","LUK","1","34","34","—¿Biqui ca' uchuc abe'e? Ma' yan in wicham,— cu t'an ix Maria ti'i u yaj xa'num a Dios ti ca'ana. ");
INSERT INTO mopNT_vpl VALUES ("LK1_35","072_1_35","LUK","1","35","35","—Watac u Püsüc'al a Dios ta wetel. Jabix ti walac u tz'eec u bo'oy a muyal yoc'ol a c'u'aca, baalo' ilic ti watac u muc' a Dios ta woc'ol. Le'ec a wal a yantal u ca'aja, bel u ca'a tzicbalbül ti baalo': “Ma' yan u sip'il ala'aji. U Mejen a Dios ala'aji.” ");
INSERT INTO mopNT_vpl VALUES ("LK1_36","072_1_36","LUK","1","36","36","Uxtun a wet'oc ixna' Elisabete. Yaab tun u jaab, pero yantal u ca'a u yal xidal. Seis meses tun ba'la'anac ca'ax walacoo' u yadic ti ma' ta'ach u yal,— cu t'an ti'i ix Mariaja. ");
INSERT INTO mopNT_vpl VALUES ("LK1_37","072_1_37","LUK","1","37","37","—Ma' yan c'u' a ma' patal u bete' a Dioso,— cu t'an. ");
INSERT INTO mopNT_vpl VALUES ("LK1_38","072_1_38","LUK","1","38","38","—Que'enen tu c'ü' a Noochtzili. Ca' uchuc ten a jabix ilic a wadaja,— cu t'an ix Mariaja. Pachil abe'e, bini u yaj xa'num a Dios ti ca'ana. ");
INSERT INTO mopNT_vpl VALUES ("LK1_39","072_1_39","LUK","1","39","39","Pues te'i. Ma' xanaji tu caal ix Mariaja. Tu seebal bini ich jun p'eel caj tu cuenta Judea. Top witz tuba que'en a caj abe'e. ");
INSERT INTO mopNT_vpl VALUES ("LK1_40","072_1_40","LUK","1","40","40","Le'ec ti c'ochi ichil u yotoch aj Zacariasa, u tz'aj a tzic ti'i ixna' Elisabete. ");
INSERT INTO mopNT_vpl VALUES ("LK1_41","072_1_41","LUK","1","41","41","Le'ec ca' u yubaj c'u' u yadaj ix Maria ixna' Elisabete, uchi u peec u yal ichil u nüc'. Oqui u Püsüc'al a Dios ichil u püsüc'al ixna' Elisabete. ");
INSERT INTO mopNT_vpl VALUES ("LK1_42","072_1_42","LUK","1","42","42","—Tz'abi tech a mas qui' tuwich tulacaloo' u chucaan ix ch'up u men a Dioso,— cu t'an ixna' Elisabete. —Qui'qui't'anbi ilic a wal ichil a nüc',— cu t'an ti'i ix Maria ti chich. ");
INSERT INTO mopNT_vpl VALUES ("LK1_43","072_1_43","LUK","1","43","43","—¿C'u' ca'a tz'abi ten a qui'il ada'a, ti'i ca' u sutiinteen u na' in Noochil, le'ec a Cristojo?— cu t'an ixna' Elisabete. ");
INSERT INTO mopNT_vpl VALUES ("LK1_44","072_1_44","LUK","1","44","44","—Le'ec ti ca' a tzicajene, uchi u peec a nene' ichil in nüc' u men u qui'il u yool,— cu t'an ixna' Elisabete. ");
INSERT INTO mopNT_vpl VALUES ("LK1_45","072_1_45","LUK","1","45","45","—U men a tz'ocsaj ti bel u ca'a ti uchul c'u' a aalbi tech u men a Noochtzili, qui' a wool,— cu t'an ixna' Elisabete. ");
INSERT INTO mopNT_vpl VALUES ("LK1_46","072_1_46","LUK","1","46","46","Uchi u t'an ix Mariaja. —Tulacal in wool tan in wadic u qui'il a Noochtzili,— cu t'an. ");
INSERT INTO mopNT_vpl VALUES ("LK1_47","072_1_47","LUK","1","47","47","—Mani tu pach u qui'il in wool etel Dios le'ec in waj Sa'alil,— cu t'an. ");
INSERT INTO mopNT_vpl VALUES ("LK1_48","072_1_48","LUK","1","48","48","—Inen u yix meyaj. U yilaj in wotzilil. Bel u ca'a aalbül in qui'il u menoo' a cristiano tac tu jobeeb a yoc'olcab u men yantal u ca'a a Cristo tin wetel,— cu t'an. ");
INSERT INTO mopNT_vpl VALUES ("LK1_49","072_1_49","LUK","1","49","49","—Yan u muc' a Dioso. Ma' yan a c'as etel ala'aji. Top qui' u betaj tene,— cu t'an. ");
INSERT INTO mopNT_vpl VALUES ("LK1_50","072_1_50","LUK","1","50","50","—Ma' yan q'uin u p'ütic u ch'a'ic u yotzilil boon tuul a saac ca' yanac u sip'il etel a Dioso,— cu t'an. ");
INSERT INTO mopNT_vpl VALUES ("LK1_51","072_1_51","LUK","1","51","51","—Chica'an u muc' a Dios etel a c'u' u betaja. Chica'an u muc' etel ca' u wecajoo' tu c'asil boon tuul a walacoo' u tuclic jabix top yanoo' u na'ata,— cu t'an ix Mariaja. ");
INSERT INTO mopNT_vpl VALUES ("LK1_52","072_1_52","LUK","1","52","52","—Chica'an u muc' a Dios ti ca' u joc'sajoo' ti reyil a reye. U tz'ajoo' ti nooch u wichil u meyaj mac a ma' cuchi nooch u wichil u meyaja,— cu t'an. ");
INSERT INTO mopNT_vpl VALUES ("LK1_53","072_1_53","LUK","1","53","53","—Le'ec a Dioso, u tz'ajoo' a quich'pan janal ti'ijoo' a wi'ijoo'o. U yusq'uintajoo' tu pach a ayic'al ti ma'ax c'u' a yanoo' ti'iji,— cu t'an. ");
INSERT INTO mopNT_vpl VALUES ("LK1_54","072_1_54","LUK","1","54","54","—Chica'an u muc' le'ec ca' u yaantajoo' aj Israel, le'ec u yaj meyaj. Le'ec a Dioso, u yadaj u tz'eec a qui'il ti'ijoo' ti uchben mamaa'. Ma' tubbi ti'iji,— cu t'an ix Mariaja. ");
INSERT INTO mopNT_vpl VALUES ("LK1_55","072_1_55","LUK","1","55","55","—Le'ec a qui'il u yadaj u tz'eeque, u yadaj ti'i ti uchben mamaa' aj Abraham eteloo' tulacal u mam. Ma' tu tubul ti'i jumpul,— cu t'an ix Maria ti'i ixna' Elisabete. ");
INSERT INTO mopNT_vpl VALUES ("LK1_56","072_1_56","LUK","1","56","56","Te'i culaji ti sut ix Maria etel ixna' Elisabet jabix wal ox p'e uj. Pachili, usc'aji tu yotoch. ");
INSERT INTO mopNT_vpl VALUES ("LK1_57","072_1_57","LUK","1","57","57","Pues te'i. C'ochi u q'uinil u yantal u yal ixna' Elisabete. Yanaji u yal xidal. ");
INSERT INTO mopNT_vpl VALUES ("LK1_58","072_1_58","LUK","1","58","58","Baalo' ti ch'a'bi u yotzilil ixna' Elisabet u men a Noochtzili, le'ec ti yanaji u yal. Qui' u yool ixna' Elisabete. Le'ecoo' a chucul u yet'ocoo' eteloo' u yettzeele, qui'oo' ilic u yool ala'oo' ca' u yubajoo' abe'e. ");
INSERT INTO mopNT_vpl VALUES ("LK1_59","072_1_59","LUK","1","59","59","C'ochoo' ala'oo' le'ec ti yan ocho q'uin ti'i a tz'ubu. C'ochoo' u tz'aa' u p'is tu yot'el a tz'ubu. Circuncision u c'aba' abe'e. U c'atiintajoo' u tz'aa' u c'aba' a tz'ub ti Zacarias jabix ilic u c'aba' u tat. ");
INSERT INTO mopNT_vpl VALUES ("LK1_60","072_1_60","LUK","1","60","60","C'u' betiqui, ma' cha'boo' u betic ti baalo' u men u na' a tz'ubu. —Ma' baalo' u c'aba'i. Aj Juan u c'aba',— cu t'an u na'. ");
INSERT INTO mopNT_vpl VALUES ("LK1_61","072_1_61","LUK","1","61","61","—Ma' yan ma'ax jun tuul a wet'oc aj Juan u c'aba',— cu t'anoo' ti'i. ");
INSERT INTO mopNT_vpl VALUES ("LK1_62","072_1_62","LUK","1","62","62","U ye'ajoo' u c'ü' ti'i u tat ca' u c'aatoo' ti'i mac u c'aba' a tz'ubu. ");
INSERT INTO mopNT_vpl VALUES ("LK1_63","072_1_63","LUK","1","63","63","Le'ec u tata, u pecsaj u c'ü' ti'i ca' talesabüc a ju'umu. Uchi u tz'iib tuwich. —Aj Juan u c'aba' a tz'ubu,— cu t'an a t'an u tz'iibtaja. Sa'too' u yool ala'oo' u men u c'aba' a tz'ubu. ");
INSERT INTO mopNT_vpl VALUES ("LK1_64","072_1_64","LUK","1","64","64","Bes aj Zacariasa. Le'ec ca' u tz'iibtaj u c'aba' a tz'ubu, jeebi u t'an. Caji u yadü' u qui'il a Dioso. ");
INSERT INTO mopNT_vpl VALUES ("LK1_65","072_1_65","LUK","1","65","65","Mas sa'too' u yool u yettzeel u men c'u' a uchiji. Weequi u pectzil yoc'ol abe' ca'ax tubajac yaam witz tu cuenta Judea. ");
INSERT INTO mopNT_vpl VALUES ("LK1_66","072_1_66","LUK","1","66","66","Tulacal a boon u yubajoo' abe'e, u tz'ajoo' tu yool. —¿C'u' ti meyajil a bel u ca'a u bete' ti winicac a tz'ub abe'e?— cu t'anoo' tu bajil u men chica'an ti'ijoo' ti qui'qui't'ana'an a tz'ub abe' u men a Noochtzili. ");
INSERT INTO mopNT_vpl VALUES ("LK1_67","072_1_67","LUK","1","67","67","Pues te'i. Le'ec u tat a tz'ubu, aj Zacarias u c'aba'. Oqui u Püsüc'al a Dios ichil u püsüc'al ala'aji. Caji ti t'an aj Zacariasa. ");
INSERT INTO mopNT_vpl VALUES ("LK1_68","072_1_68","LUK","1","68","68","—Top qui' a Noochtzili. Ala'aji, ti Dios ino'on aj Israelo'ono. U ch'a'aj ti wotzilil. U tz'aj biqui ca' sa'albüco'on,— cu t'an. ");
INSERT INTO mopNT_vpl VALUES ("LK1_69","072_1_69","LUK","1","69","69","—U tücaa'taj to'on jun tuul aj Sa'alil a yan u muc'u. Ala'aji, jun tuul tu yaam boon u mam aj quimen rey Davidi. U betaj u meyaj a Dios aj Davidi,— cu t'an aj Zacariasa. ");
INSERT INTO mopNT_vpl VALUES ("LK1_70","072_1_70","LUK","1","70","70","—Ac aalbi u pectzil aj Sa'alil abe' u men boon tuul u yadajoo' u t'an a Dios uchi,— cu t'an. ");
INSERT INTO mopNT_vpl VALUES ("LK1_71","072_1_71","LUK","1","71","71","—Aalbi to'on ti bel ti ca'a joc'sabül tu c'ü' ti wettz'iiquil. Bel ti ca'a joc'sabül tu c'ü' boon a tanoo' u motzintico'on,— cu t'an. ");
INSERT INTO mopNT_vpl VALUES ("LK1_72","072_1_72","LUK","1","72","72","—Bel u cu ch'aa' ti wotzilil a Dios jabix ilic ca' u yadaj ti'ijoo' ti uchben mamaa'. Le'ec a Dioso, bel u cu c'ajes u t'an u yadaj ti'ijoo' ti uchben mamaa',— cu t'an. ");
INSERT INTO mopNT_vpl VALUES ("LK1_73","072_1_73","LUK","1","73","73","—Le'ec a t'an abe'e, le'ec a t'an a aalbi ti'i ti uchben mamaa' aj Abrahama,— cu t'an. ");
INSERT INTO mopNT_vpl VALUES ("LK1_74","072_1_74","LUK","1","74","74","—Aalbi ti'i ti bel ti ca'a sa'albül tu c'ü' ti wettz'iiquil ti'i ca' ti bete' u meyaj a Dios ti ma' saaco'on,— cu t'an aj Zacariasa. ");
INSERT INTO mopNT_vpl VALUES ("LK1_75","072_1_75","LUK","1","75","75","—Le'ec a Dioso, bel u cu tz'aa' ti ma' yan ti sip'il y toj ti na'at ti tan ti betic a meyaj abe' boon q'uin cuxa'ano'on,— cu t'an. ");
INSERT INTO mopNT_vpl VALUES ("LK1_76","072_1_76","LUK","1","76","76","—Pues te'i. Incheche, tz'ub, bel a ca'a tzicbalbül ti le'ec incheche, walac a wadic u t'an a Dios ti ca'ana. Bel a ca'a taanil a tojquintoo' u na'at a cristiano ca' u c'ümoo' a Noochtzili,— cu t'an aj Zacarias ti'i u mejen. ");
INSERT INTO mopNT_vpl VALUES ("LK1_77","072_1_77","LUK","1","77","77","—Bel a ca'a a yee' ti'ijoo' ti wetcaal biqui ca' sa'albücoo' ala'oo'o, le'ec ca' sa'tesabücoo' u sip'ili,— cu t'an. ");
INSERT INTO mopNT_vpl VALUES ("LK1_78","072_1_78","LUK","1","78","78","—Chen u men u c'ati u ch'aa' ti wotzilil tu jajil a Dioso, tan u ye'ic biqui ca' sa'albüco'on. Ma' tu p'ütic u ye'ic abe'e, asto tu jobeeb, le'ec ca' joc'oc ti ca'an ca' uduc wa'ye' tucaye' a Cristojo, le'ec mac walac u sasilcuntic u na'at a mac etel a jaja,— cu t'an. ");
INSERT INTO mopNT_vpl VALUES ("LK1_79","072_1_79","LUK","1","79","79","—Bel u cu yee' ti'ijoo' tuba u tz'eecoo' u yool jabix tan u tz'eec a sasil ti'ijoo' mac a que'en ich jabix ac'ü' tuba tan u paac'tic u quimil. Bel u cu yee' to'on biqui ca' qui'aco'on etel a Dioso,— cu t'an aj Zacariasa. ");
INSERT INTO mopNT_vpl VALUES ("LK1_80","072_1_80","LUK","1","80","80","Pues te'i. Tan u ch'iil a tz'ubu. Tan u yaabtal u na'at. Que'en ich p'atal lu'um asto ti c'ochi u q'uinil u caal u meyaj tu yaam u yetcaal aj Israele. ");
INSERT INTO mopNT_vpl VALUES ("LK2_1","072_2_1","LUK","2","1","1","Pues te'i. Ti a q'uin abe' ti yanaji aj Juana, tz'abi a ley u men a reye. Aj Augusto u c'aba' a rey abe'e. U yadaj ca' xocboc a cristiano boon tuul a yan tu cuenta ala'aji. ");
INSERT INTO mopNT_vpl VALUES ("LK2_2","072_2_2","LUK","2","2","2","Le'ec abe' u paye' sut u xocbol a cristiano ti que'en aj Cirenio ti gobernador tu cuenta Siria. ");
INSERT INTO mopNT_vpl VALUES ("LK2_3","072_2_3","LUK","2","3","3","Binoo' a cristiano jujun tuul tu caal u uchben mamaa' ti'i ca' xocboc boon tuul a yana. ");
INSERT INTO mopNT_vpl VALUES ("LK2_4","072_2_4","LUK","2","4","4","Pues te'i. Que'en aj Jose ich caj Nazaret tu cuenta Galilea. Joq'ui te'i. Bini ich caj Belen tu cuenta Judea. Le'ec a caj abe' u caal aj quimen rey Davidi, le'ec u uchben mamaa' aj Joseje. ");
INSERT INTO mopNT_vpl VALUES ("LK2_5","072_2_5","LUK","2","5","5","Bini te'i aj Jose u yet'oc ix Maria ti'i ca' xocbocoo'. C'aata'an ix Maria u men aj Joseje. Seeba'an u yantal u yal ix Mariaja. ");
INSERT INTO mopNT_vpl VALUES ("LK2_6","072_2_6","LUK","2","6","6","Le'ec ti que'enoo' ich caj Belen, c'ochi u q'uinil u yantal u yal ix Mariaja. ");
INSERT INTO mopNT_vpl VALUES ("LK2_7","072_2_7","LUK","2","7","7","Yanaji u yaax al xidal. U tepaj a tz'ub ich noc'. U coyquintaj ichil u cuuchil u janal tzimin. Ma' yanoo' u cuuchil tuba walac u tz'abül a posadojo. ");
INSERT INTO mopNT_vpl VALUES ("LK2_8","072_2_8","LUK","2","8","8","Pues te'i. Ma' naach que'enoo' a winic a tanoo' u cününtic u yalac' ich chüc'an. Carnero u c'aba'oo' u yalac'. Ac'ü' tun. ");
INSERT INTO mopNT_vpl VALUES ("LK2_9","072_2_9","LUK","2","9","9","Chen u yilajoo'o, tich'boo' u men u sac a Noochtzili. Jeda' que'en jun tuul u yaj xa'num a Dios ti ca'ana. Jac'oo' u yool. ");
INSERT INTO mopNT_vpl VALUES ("LK2_10","072_2_10","LUK","2","10","10","—Ma' u jac'üle'ex a wool,— cu t'an u yaj xa'num a Dios ti ca'ana. —U'ye'ex in t'an. Taleen in wadü' te'ex jun p'eel a t'an a bel u cu qui'cuntoo' u yool tulacaloo' a cristiano tu jajil,— cu t'an ti'ijoo'. ");
INSERT INTO mopNT_vpl VALUES ("LK2_11","072_2_11","LUK","2","11","11","—Aleebe yanaji jun tuul ichil u caal aj quimen rey David. A tz'ub abe'e, a waj Sa'alile'ex. Ala'aji, le'ec a Cristojo, le'ec a Noochtzili,— cu t'an ti'ijoo'. ");
INSERT INTO mopNT_vpl VALUES ("LK2_12","072_2_12","LUK","2","12","12","—Baala' ca' a weelte'ex wa jaj ti le'ec. Bele'ex a ca'a a cüxte a tz'ub a tepa'an ti noc'o. Coya'an ti que'en ichil u cuuchil u janal tzimin,— cu t'an u yaj xa'num a Dios ti ca'ana. ");
INSERT INTO mopNT_vpl VALUES ("LK2_13","072_2_13","LUK","2","13","13","Tu seebal mani tu pach u yaabil u yaj xa'num a Dios ti ca'an a chiclajoo'o. Que'enoo' tu tzeel aj xa'num a yaax chiclajiji. Tanoo' u yadic u qui'il a Dioso. ");
INSERT INTO mopNT_vpl VALUES ("LK2_14","072_2_14","LUK","2","14","14","—Nooch u yanil a Dios a que'en ti ca'ana. Jetz'a'anoo' u yool a cristiano yoc'olcab le'ec boon tuul qui' u yool a Dios eteloo'o,— cu t'anoo'. ");
INSERT INTO mopNT_vpl VALUES ("LK2_15","072_2_15","LUK","2","15","15","Pues te'i. Le'ec ti usc'ajoo' ti ca'an u yaj xa'num a Dioso, cajoo' ti tzicbal tu bajil a winicoo' abe'e. Tanoo' u cününtic u yalac. —Co'ne'ex ti sut ich caj Belen. Ca' ti wila' c'u' a mani te'i jabix ilic u yadaj to'on a Noochtzili,— cu t'anoo' tu bajil. ");
INSERT INTO mopNT_vpl VALUES ("LK2_16","072_2_16","LUK","2","16","16","Binoo' ti chich. U cüxtajoo' ix Maria u yet'oc aj Joseje. U cüxtajoo' ilic a tz'ub a coya'an ichil u cuuchil u janal tzimin. ");
INSERT INTO mopNT_vpl VALUES ("LK2_17","072_2_17","LUK","2","17","17","Le'ec ca' u yilajoo' ti jabix ilic ti aalboo' ti'iji, u yadajoo' ti'i tulacal a c'u' a aalbi ti'ijoo' yoc'ol a tz'ub abe' u men u yaj xa'num a Dios ti ca'ana. ");
INSERT INTO mopNT_vpl VALUES ("LK2_18","072_2_18","LUK","2","18","18","Le'ec tulacal mac u yubaj c'u' u yadajoo' u yaj cananiloo' a carnerojo, sa'too' u yool. ");
INSERT INTO mopNT_vpl VALUES ("LK2_19","072_2_19","LUK","2","19","19","C'u' betic ix Mariaja, u tz'aj tu yool c'u' u yubaj. Caji u tucle u nu'cul a t'an abe' u yadajoo'o. ");
INSERT INTO mopNT_vpl VALUES ("LK2_20","072_2_20","LUK","2","20","20","Usc'ajoo' u yaj cananiloo' a carnerojo. Tanoo' u yadic u qui'il a Dios ti tanoo' u beel. Le'ec a c'u' u yilajoo' y u yubajoo'o, laj quet ilic jabix ilic ti aalbi ti'ijoo'. ");
INSERT INTO mopNT_vpl VALUES ("LK2_21","072_2_21","LUK","2","21","21","Pues te'i. Le'ec ti ocho q'uin yan ti'i a tz'ubu, xotbi u yot'el jabix ilic ti sucoo' u bete'. Circuncision u c'aba' abe'e. Jesus u c'aba' a tz'abi ti'i a tz'ub jabix ilic ti ca' u yadaj u yaj xa'num a Dios ti ca'ana, le'ec ti ma'ax to ba'la'anac ix Mariaja. ");
INSERT INTO mopNT_vpl VALUES ("LK2_22","072_2_22","LUK","2","22","22","Pues te'i. Tz'iiba'an ichil a ley u tz'iibtaj aj Moises c'u' a yan u betic ix ch'up a yanaji u yal. Le'ec ti c'ochi u q'uinil u betic abe'e, bini aj Jose etel ix Maria ich caj Jerusalen. U bensajoo' a tz'ub tu yotoch a Dios ti'i u c'ubu' ala'i ti'i a Noochtzili. ");
INSERT INTO mopNT_vpl VALUES ("LK2_23","072_2_23","LUK","2","23","23","Baala' ti tz'iiba'an ichil u ley a Noochtzili: —Tulacal a boon a yaax al xidala, ti'i a Noochtzili,— cu t'an a t'an a tz'iiba'ana. ");
INSERT INTO mopNT_vpl VALUES ("LK2_24","072_2_24","LUK","2","24","24","Binoo' ilic te'i ti'i ca' u quimes a baalche' ti'i u sij-ool ix Maria ti'i a Dios jabix ilic ti tz'iiba'an ichil u ley a Noochtzili. Le'ec a baalche' abe'e, ca' tuul tzutzuy wa ca' tuul meen palomaja. ");
INSERT INTO mopNT_vpl VALUES ("LK2_25","072_2_25","LUK","2","25","25","Pues te'i. Yan jun tuul a winiqui, aj Simeon u c'aba'. Que'en ich caj Jerusalen ala'aji. Toj u na'at. Walac u tz'ocsic a Dios tulacal u yool. Tan u paac'tic u yaj Sa'aliloo' aj Israel. Que'en u Püsüc'al a Dios ichil u püsüc'al aj Simeono. ");
INSERT INTO mopNT_vpl VALUES ("LK2_26","072_2_26","LUK","2","26","26","Aalbi ti'i u men u Püsüc'al a Dios ti ma' tu se' quimil asto u yilic a Cristojo. Le'ec a Cristojo, le'ec a tücaa'bi u men a Noochtzili. ");
INSERT INTO mopNT_vpl VALUES ("LK2_27","072_2_27","LUK","2","27","27","Le'ec u Püsüc'al a Dioso, u tz'aj ti'i aj Simeon ca' xi'ic ichil u yotoch a Dioso. Pues te'i. Le'ec u na' u tat a tz'ubu, u bensajoo' a nene' Jesus ichil u yotoch a Dios ti'i ca' u betoo' ti'i c'u' a tz'iiba'an ichil a leye. ");
INSERT INTO mopNT_vpl VALUES ("LK2_28","072_2_28","LUK","2","28","28","Le'ec aj Simeono, u meectaj a tz'ubu. Caji u yadü' u qui'il a Dioso. ");
INSERT INTO mopNT_vpl VALUES ("LK2_29","072_2_29","LUK","2","29","29","—Noochil, inen a waj meyaj. Aleebe jetz'a'an in wool ca' quimiquen. Chiclaji c'u' a wadaj tene,— cu t'an aj Simeon ti'i a Dioso. ");
INSERT INTO mopNT_vpl VALUES ("LK2_30","072_2_30","LUK","2","30","30","—In wilaj tin wichil mac a tücaa'taj ca' u sa'alte a cristianojo. ");
INSERT INTO mopNT_vpl VALUES ("LK2_31","072_2_31","LUK","2","31","31","Tu taan tulacal a cristiano yoc'olcaba, tan a tz'eec biqui ca' sa'albücoo',— cu t'an. ");
INSERT INTO mopNT_vpl VALUES ("LK2_32","072_2_32","LUK","2","32","32","—Le'ec a tz'ub ada'a, jabix jun p'eel a sasili. Bel u cu sasilcunte u na'at a cristiano a ma' Israeloo'o. Le'ec ala'i a qui'il a yancuntaj tu yaamoo' aj Israele. Tech a cristianojoo' aj Israele,— cu t'an ti'i a Dioso. ");
INSERT INTO mopNT_vpl VALUES ("LK2_33","072_2_33","LUK","2","33","33","Pues te'i. Sa'too' u yool u na' u tat ti aalbi abe' yoc'ol a tz'ubu. ");
INSERT INTO mopNT_vpl VALUES ("LK2_34","072_2_34","LUK","2","34","34","Le'ec aj Simeono, u qui'qui't'antajoo' u na' u tat a tz'ubu. —Yeetbi a tz'ub ada' u men a Dioso. Yanoo' aj Israel a p'aatüloo' u ca'a ti pula'anoo'. Yanoo' xan a p'aatüloo' u ca'a ti sa'ala'anoo' u men ala'aji. Ala'aji, u p'is a jabix u c'ati a Dioso. C'u' betiqui, bel u ca'a culpachbül u men yaab mac,— cu t'an aj Simeon ti'i ix Mariaja. ");
INSERT INTO mopNT_vpl VALUES ("LK2_35","072_2_35","LUK","2","35","35","—Bel u ca'a ti chictal biqui'il u na'at a yaab a cristianojo. Bel u ca'a ti yajtal a wool jabix cuchi tan a lombol etel maasca',— cu t'an aj Simeon ti'i ix Mariaja. ");
INSERT INTO mopNT_vpl VALUES ("LK2_36","072_2_36","LUK","2","36","36","Pues te'i. Yan jun tuul a nooch'up a walac u yadic u t'an a Dioso, ixna' Ana u c'aba'. Le'ec u tata, aj Fanuel u c'aba'. Aj Aser u c'aba' u uchben mamaa'. Top yaab u jaab a nooch'up abe'e. Jadi' siete jaab tz'oca'an u beel ala'aji. ");
INSERT INTO mopNT_vpl VALUES ("LK2_37","072_2_37","LUK","2","37","37","Ochenta y cuatro jaab culaji ti ix ma'ichami. Ma' ta'ach u joc'ol ichil u yotoch a Dioso. Walac u p'ütic a janal ca' tun uchuc u suq'uin. Walac u t'an etel a Dioso. Ti q'uin ti ac'ü' walac u betic abe'e. ");
INSERT INTO mopNT_vpl VALUES ("LK2_38","072_2_38","LUK","2","38","38","C'ochi ilic a nooch'up abe' tu tzeeloo' u na' u tat a tz'ub ti tan to u t'an aj Simeon eteloo'o. A nooch'upu, u yadaj a bo'tic ti'i a Dioso. U yadaj ilic u pectzil a tz'ub ti'ijoo' boon tuul a que'enoo' ich caj Jerusalen a tanoo' u paac'tic u sa'albüloo'o. ");
INSERT INTO mopNT_vpl VALUES ("LK2_39","072_2_39","LUK","2","39","39","Pues te'i. Joboo' u betic tulacal boon a tz'iiba'an ichil u ley a Noochtzili. Usc'ajoo' aj Jose etel ix Maria etel a nene' tu caala, le'ec a caj Nazaret tu cuenta Galilea. ");
INSERT INTO mopNT_vpl VALUES ("LK2_40","072_2_40","LUK","2","40","40","Tan u ch'iil a tz'ubu. Yanaji u muc'. Yaabaji u na'at. Tan u yaantabül u men a Dioso. ");
INSERT INTO mopNT_vpl VALUES ("LK2_41","072_2_41","LUK","2","41","41","Pues te'i. Le'ec u na' u tat a Jesusu, amal jaab walacoo' u beel u yiloo' a fiesta ich caj Jerusalen. Le'ec a fiesta abe'e, le'ec u c'ajsabeeb ti mani u yaj xa'num a Dios ti ca'an yoc'oloo' uchi. ");
INSERT INTO mopNT_vpl VALUES ("LK2_42","072_2_42","LUK","2","42","42","Le'ec ti yan doce jaab ti'i a Jesusu, binoo' ilic xan u yila' a fiesta abe'e, jabix ilic ti sucoo' u bete'e. ");
INSERT INTO mopNT_vpl VALUES ("LK2_43","072_2_43","LUK","2","43","43","Le'ec ti jobi a fiestaja, tanoo' u yusc'al tu caal. Tz'ub to a Jesusu. P'aati ich caj Jerusalen. Le'ecoo' u na' u tata, ma' u yeeloo' wa p'aati te'i. ");
INSERT INTO mopNT_vpl VALUES ("LK2_44","072_2_44","LUK","2","44","44","Tanoo' u tuclic ti que'en a Jesus tu yaamoo' a cristiano a que'enoo' ti beje. Jun p'e q'uin u muc' u ximbaltaloo'o. Pachili, u yaaltajoo' u cüxte a Jesus tu yaamoo' u yetbeel, le'ec u chucul u yet'ocoo' y u yettzeeloo'. ");
INSERT INTO mopNT_vpl VALUES ("LK2_45","072_2_45","LUK","2","45","45","Ma' ilic u cüxtajoo' te'i, mentücü, usc'ajoo' ich caj Jerusalen u yaaltoo' u cüxte te'i. ");
INSERT INTO mopNT_vpl VALUES ("LK2_46","072_2_46","LUK","2","46","46","Tu yox p'eel q'uin u cüxtajoo' a Jesusu. Tina'an ti que'en tu yaamoo' a maestro ichil u yotoch a Dioso. Tan u yubicoo' u t'an y tan u c'aaticoo' u chi'. ");
INSERT INTO mopNT_vpl VALUES ("LK2_47","072_2_47","LUK","2","47","47","Tulacal boon u yubajoo' a Jesusu, sa'too' u yool. Top yaab u tucul. Patal u nuuctoo'. ");
INSERT INTO mopNT_vpl VALUES ("LK2_48","072_2_48","LUK","2","48","48","Sa'too' u yool u na' u tat ca' u yilajoo' te'i. —Yum, ¿c'u' ca'a a betaj to'on ti baalo'? Inen etel a tata, jac'a'an ti wool ti tan ti manül ti cüxteech,— cu t'an u na' ti'iji. ");
INSERT INTO mopNT_vpl VALUES ("LK2_49","072_2_49","LUK","2","49","49","—¿C'u' ca'a tane'ex a manül a cüxteen? ¿Ma' wa a weele'ex ti jede'ec in cuntal ichil u yotoch in Tata?— cu t'an a Jesus ti'ijoo'o. ");
INSERT INTO mopNT_vpl VALUES ("LK2_50","072_2_50","LUK","2","50","50","Ma' u ch'a'ajoo' u tojil c'u' a aalboo' ti'iji. ");
INSERT INTO mopNT_vpl VALUES ("LK2_51","072_2_51","LUK","2","51","51","Pues te'i. Bini a Jesus tu pachoo' tac ich caj Nazaret. Walac u tz'ocsicoo' u t'an. Le'ec u na'a, u tz'aj tu yool tulacal a c'u' a maniji. ");
INSERT INTO mopNT_vpl VALUES ("LK2_52","072_2_52","LUK","2","52","52","Pues te'i. Ch'iji a Jesusu. Mas yaabaji u na'at. Qui' u yool a Dios etele. Qui'oo' ilic xan u yool a cristiano etele. ");
INSERT INTO mopNT_vpl VALUES ("LK3_1","072_3_1","LUK","3","1","1","Pues te'i. Quince jaab tun ococ aj Tiberio ti reyil. Ti'i ilic a q'uin abe'e, que'en aj Poncio Pilato ti gobernadoril tu cuenta Judea. Que'en aj Herodes ti gobernadoril tu cuenta Galilea. Que'en u yitz'in le'ec aj Felipe ti gobernadoril tu cuenta Iturea cuenta Traconite. Que'en aj Lisanias ti gobernadoril tu cuenta Abilinia. ");
INSERT INTO mopNT_vpl VALUES ("LK3_2","072_3_2","LUK","3","2","2","Le'ecoo' a mas nooch u wichil u meyaj tu yaamoo' u yaj mansaj t'an a cristiano ti'i a Dioso, le'ec aj Anas etel aj Caifasa. Ti'i ilic a q'uin abe'e, udi u pectzil a Dios etel aj Juana, le'ec u mejen aj Zacariasa. Que'en aj Juan ich p'atal lu'um. ");
INSERT INTO mopNT_vpl VALUES ("LK3_3","072_3_3","LUK","3","3","3","Joq'ui te'i. Bini ti t'an tulacal tuba tu chi' a noja' Jordana. U yadaj ti'ijoo' a cristiano ca' u c'ümoo' a ocja'a. Le'ec abe' u p'is ca' u jelajoo' u tucul, y sa'tesaboo' u sip'il u men a Dioso. ");
INSERT INTO mopNT_vpl VALUES ("LK3_4","072_3_4","LUK","3","4","4","Baala' ti tz'iiba'an yoc'ol aj Juan u men aj Isaiasa, le'ec jun tuul u yadaj u t'an a Dios uchi: —Le'ec ada' u t'an jun tuul mac ich p'atal lu'um. “Tojquinte'ex a na'at ca' a c'üm-oolte'ex a Noochtzili, jabix cuchi tane'ex a tojquintic a beje,” cu t'an. ");
INSERT INTO mopNT_vpl VALUES ("LK3_5","072_3_5","LUK","3","5","5","“Yan u buut'bul a jooco. Yan u paanbül a witzi. Yan u tojquinbil tuba ma' toj. Quetcunte a bej a ma' quet u wichi,” cu t'an. ");
INSERT INTO mopNT_vpl VALUES ("LK3_6","072_3_6","LUK","3","6","6","“Tulacaloo' a cristiano yoc'olcaba, beloo' u cu yeelte biqui ca' sa'albücoo' u men a Dioso,” cu t'an a jun tuul mac ich p'atal lu'umu,— cu t'an a t'an a tz'iiba'an u men aj Isaias yoc'ol aj Juana. ");
INSERT INTO mopNT_vpl VALUES ("LK3_7","072_3_7","LUK","3","7","7","Pues te'i. Yaaboo' a cristiano a c'ochoo' etel aj Juana. U c'atoo' u c'ümoo' a ocja'a. —Inche'exe, top c'ase'ex jabixe'ex u yal can. ¿Mac u yadaj te'ex ca' talaque'ex ti'i ma' a c'ümique'ex u tz'iiquil a Dioso?— cu t'an aj Juan ti'ijoo'o. ");
INSERT INTO mopNT_vpl VALUES ("LK3_8","072_3_8","LUK","3","8","8","—Bete'ex a qui'i, ti'i ca' chiclac ti jela'ane'ex a tucul. Ma' a wadique'ex ta bajil wa c'üma'ane'ex chen u men u mame'ex aj quimen Abraham. Tan in wadic te'ex. Le'ec a Dioso, jede'ec u paatal u su'tesic ca'ax le'ec boon a tunich ada' ca' p'aatüc ti'i u mamoo' aj Abraham,— cu t'an ti'ijoo'. ");
INSERT INTO mopNT_vpl VALUES ("LK3_9","072_3_9","LUK","3","9","9","—Inche'exe, jabixe'ex a che'e. Paac' u ca'a a baat ti'i u ch'ücbeeb. Tulacal boon a che' a ma' quich'pan u wichi, bel u ca'a ch'ücbül. Bel u ca'a pulbul ich c'aac',— cu t'an aj Juana. ");
INSERT INTO mopNT_vpl VALUES ("LK3_10","072_3_10","LUK","3","10","10","—Ti baalo'o, ¿c'u' a ca' ti bete'e?— cu t'anoo' a cristiano ti'i aj Juana. ");
INSERT INTO mopNT_vpl VALUES ("LK3_11","072_3_11","LUK","3","11","11","—Le'ec mac a yan ti'i ca' tziil u noc'o, yan u tz'eec jun tziilac ti'i mac a ma'ax jun tziil a yan ti'iji. Baalo' ilic ti yan u jützic u janal a mac a yan ti'iji,— cu t'an aj Juan ti uchi u nuuc. ");
INSERT INTO mopNT_vpl VALUES ("LK3_12","072_3_12","LUK","3","12","12","C'ochoo' aj mol taq'uin ti'i a gobiernojo. U c'atoo' cuchi ca' tz'abücoo' u yocja' u men aj Juan. U c'aatajoo' ti'i aj Juan. —Maestro, ¿c'u' a yan ti betic ino'ono?— cu t'anoo' ti'i. ");
INSERT INTO mopNT_vpl VALUES ("LK3_13","072_3_13","LUK","3","13","13","—Ma' a molique'ex a taq'uin ti manal tuwich boon a tz'aja'an a molique'exe,— cu t'an aj Juan ti'ijoo'o. ");
INSERT INTO mopNT_vpl VALUES ("LK3_14","072_3_14","LUK","3","14","14","—Uxtun ino'ono, ¿c'u' a yan ti betic ino'ono?— cu t'anoo' a soldado ti'iji. —Ma' a toquique'ex c'u' a yan ti'i ulaac'a, ma'ax etel muc' ma'ax etel tus. Jetz'a'anaque'ex a wool etel a naal,— cu t'an ti'ijoo' a soldadojo. ");
INSERT INTO mopNT_vpl VALUES ("LK3_15","072_3_15","LUK","3","15","15","Pues te'i. Le'ecoo' a cristianojo, tanoo' u paac'tic u chictal a Cristo ti jomol. —Uchac aj Juan a Cristojo,— cu t'anoo' a cristianojo. ");
INSERT INTO mopNT_vpl VALUES ("LK3_16","072_3_16","LUK","3","16","16","Uchi u nuuc aj Juana. —Inene, walac in tz'eeque'ex ti ocja' chen etel ja',— cu t'an. —Watac jun tuul a mas nooch u meyaj tin wichi. Ma' chucul in yanil ma'ax ti'i ca' in joq'ues u cayte. Bel u cu tz'a'e'ex ti ocja', pero chen etel u Püsüc'al a Dioso, y etel jabix c'aac',— cu t'an. ");
INSERT INTO mopNT_vpl VALUES ("LK3_17","072_3_17","LUK","3","17","17","—Ala'aji, jabix mac a que'en a pala tu c'ü' ti'i u pulical u semilla a harina ti ca'nal. Baalo' tu yuusbul u men a iq'ui, ca' joc'oc u c'asil. Bel u cu taac'te u semilla harina a quich'pana, pero le'ec u pacha, bel u ca'a chuwbul ichil a c'aac' a ma' yan q'uin u tupulu,— cu t'an aj Juan ti'ijoo'o. ");
INSERT INTO mopNT_vpl VALUES ("LK3_18","072_3_18","LUK","3","18","18","Pues te'i. Ma' jadi' abe' u yadaji. Chawac u pach u tzicbal aj Juana. U yadaj u qui'il u t'an a Dios ti'ijoo' a cristianojo. ");
INSERT INTO mopNT_vpl VALUES ("LK3_19","072_3_19","LUK","3","19","19","C'u' betiqui, u tze'ectaj aj gobernador Herodese, u men u ch'a'aj u mu', le'ec ix Herodiasa. Ala'aji, u yütan u yitz'in. U tze'ectaj ilic yoc'ol boon ulaac' a c'as u betaja. ");
INSERT INTO mopNT_vpl VALUES ("LK3_20","072_3_20","LUK","3","20","20","U betaj ulaac' a c'as aj Herodese, le'ec ca' u tz'aj aj Juan ti presojil. ");
INSERT INTO mopNT_vpl VALUES ("LK3_21","072_3_21","LUK","3","21","21","Pues te'i. Le'ec ti ma'ax to tz'abüc aj Juan ti presojili, tan u tz'eec ti ocja' tulacaloo' a cristianojo. Ti a q'uin abe'e, u tz'aj ilic a Jesus ti ocja'. Le'ec ti jobi ti ocja' a Jesusu, tan to u t'an ala'i etel a Dios le'ec ti jeebi a ca'ana. ");
INSERT INTO mopNT_vpl VALUES ("LK3_22","072_3_22","LUK","3","22","22","Te'i chiclaji jabix paloma u Püsüc'al a Dioso. Emi yoc'ol a Jesusu. Uchi a t'an ti ca'ana. —Inchech in Mejenech. Yaj in wu'yeech. Qui' in wool ta wetel,— cu t'an a t'an ti ca'ana. ");
INSERT INTO mopNT_vpl VALUES ("LK3_23","072_3_23","LUK","3","23","23","Pues te'i. Jabix wal treinta jaab yan ti'i a Jesus ti caji ti manül u yadü' u pectzil a Dioso. —A Jesusu, u mejen aj Jose,— cu t'anoo' a cristianojo, pero chen u tuclajoo' ti baalo'. Le'ec u tat aj Joseje, aj Eli u c'aba'. ");
INSERT INTO mopNT_vpl VALUES ("LK3_24","072_3_24","LUK","3","24","24","U tat aj Eliji, aj Matat u c'aba'. U tat aj Matata, aj Levi u c'aba'. U tat aj Leviji, aj Melqui u c'aba'. U tat aj Melquiji, aj Jana u c'aba'. U tat aj Janaja, aj Jose u c'aba'. ");
INSERT INTO mopNT_vpl VALUES ("LK3_25","072_3_25","LUK","3","25","25","U tat aj Joseje, aj Matatias u c'aba'. U tat aj Matatiasa, aj Amos u c'aba'. U tat aj Amoso, aj Nahum u c'aba'. U tat aj Nahumu, aj Esli u c'aba'. U tat aj Esliji, aj Nagai u c'aba'. ");
INSERT INTO mopNT_vpl VALUES ("LK3_26","072_3_26","LUK","3","26","26","U tat aj Nagaiji, aj Maat u c'aba'. U tat aj Maata, aj Matatias u c'aba'. U tat aj Matatiasa, aj Semei u c'aba'. U tat aj Semeiji, aj Jose u c'aba'. U tat aj Joseje, aj Juda u c'aba'. ");
INSERT INTO mopNT_vpl VALUES ("LK3_27","072_3_27","LUK","3","27","27","U tat aj Judaja, aj Joana u c'aba'. U tat aj Joanaja, aj Resa u c'aba'. U tat aj Resaja, aj Zorobabel u c'aba'. U tat aj Zorobabele, aj Salatiel u c'aba'. U tat aj Salatiele, aj Neri u c'aba'. ");
INSERT INTO mopNT_vpl VALUES ("LK3_28","072_3_28","LUK","3","28","28","U tat aj Neriji, aj Melqui u c'aba'. U tat aj Melquiji, aj Adi u c'aba'. U tat aj Adiji, aj Cosam u c'aba'. U tat aj Cosama, aj Elmodam u c'aba'. U tat aj Elmodama, aj Er u c'aba'. ");
INSERT INTO mopNT_vpl VALUES ("LK3_29","072_3_29","LUK","3","29","29","U tat aj Ere, aj Josue u c'aba'. U tat aj Josueje, aj Eliezer u c'aba'. U tat aj Eliezere, aj Jorim u c'aba'. U tat aj Jorimi, aj Matat u c'aba'. ");
INSERT INTO mopNT_vpl VALUES ("LK3_30","072_3_30","LUK","3","30","30","U tat aj Matata, aj Levi u c'aba'. U tat aj Leviji, aj Simeon u c'aba'. U tat aj Simeono, aj Juda u c'aba'. U tat aj Judaja, aj Jose u c'aba'. U tat aj Joseje, aj Jonan u c'aba'. U tat aj Jonana, aj Eliaquim u c'aba'. ");
INSERT INTO mopNT_vpl VALUES ("LK3_31","072_3_31","LUK","3","31","31","U tat aj Eliaquimi, aj Melea u c'aba'. U tat aj Meleaja, aj Mainan u c'aba'. U tat aj Mainana, aj Matata u c'aba'. U tat aj Matataja, aj Natan u c'aba'. ");
INSERT INTO mopNT_vpl VALUES ("LK3_32","072_3_32","LUK","3","32","32","U tat aj Natana, aj David u c'aba'. U tat aj Davidi, aj Isai u c'aba'. U tat aj Isaiji, aj Obed u c'aba'. U tat aj Obede, aj Booz u c'aba'. U tat aj Boozo, aj Salmon u c'aba'. U tat aj Salmono, aj Naason u c'aba'. ");
INSERT INTO mopNT_vpl VALUES ("LK3_33","072_3_33","LUK","3","33","33","U tat aj Naasono, aj Aminadab u c'aba'. U tat aj Aminadaba, aj Aram u c'aba'. U tat aj Arama, aj Esrom u c'aba'. U tat aj Esromo, aj Fares u c'aba'. U tat aj Farese, aj Juda u c'aba'. ");
INSERT INTO mopNT_vpl VALUES ("LK3_34","072_3_34","LUK","3","34","34","U tat aj Judaja, aj Jacob u c'aba'. U tat aj Jacobo, aj Isaac u c'aba'. U tat aj Isaaca, aj Abraham u c'aba'. U tat aj Abrahama, aj Tare u c'aba'. U tat aj Tareje, aj Nacor u c'aba'. ");
INSERT INTO mopNT_vpl VALUES ("LK3_35","072_3_35","LUK","3","35","35","U tat aj Nacoro, aj Serug u c'aba'. U tat aj Serugu, aj Ragau u c'aba'. U tat aj Ragauju, aj Peleg u c'aba'. U tat aj Pelegue, aj Heber u c'aba'. U tat aj Hebere, aj Sala u c'aba'. ");
INSERT INTO mopNT_vpl VALUES ("LK3_36","072_3_36","LUK","3","36","36","U tat aj Salaja, aj Cainan u c'aba'. U tat aj Cainana, aj Arfaxad u c'aba'. U tat aj Arfaxada, aj Sem u c'aba'. U tat aj Seme, aj Noe u c'aba'. U tat aj Noeje, aj Lamec u c'aba'. ");
INSERT INTO mopNT_vpl VALUES ("LK3_37","072_3_37","LUK","3","37","37","U tat aj Lameque, aj Matusalen u c'aba'. U tat aj Matusalene, aj Enoc u c'aba'. U tat aj Enoco, aj Jared u c'aba'. U tat aj Jarede, aj Mahalaleel u c'aba'. U tat aj Mahalaleele, aj Cainan u c'aba'. ");
INSERT INTO mopNT_vpl VALUES ("LK3_38","072_3_38","LUK","3","38","38","U tat aj Cainana, aj Enos u c'aba'. U tat aj Enoso, aj Set u c'aba'. U tat aj Sete, aj Adan u c'aba'. U tat aj Adana, le'ec a Dioso. ");
INSERT INTO mopNT_vpl VALUES ("LK4_1","072_4_1","LUK","4","1","1","Pues te'i. Yan u Püsüc'al a Dios ichil u püsüc'al a Jesus ti joq'ui chi' a noja' Jordana. Bensabi u men u Püsüc'al a Dios ichil a p'atal lu'umu. ");
INSERT INTO mopNT_vpl VALUES ("LK4_2","072_4_2","LUK","4","2","2","Le'ec a quisini, tan u yaaltic u yemes u yool a Jesus ca' u bete' a c'asa. Cuarenta q'uin que'en te'i a Jesusu, y ma' uchi u janali. Pachili, wi'ijaji a Jesusu. ");
INSERT INTO mopNT_vpl VALUES ("LK4_3","072_4_3","LUK","4","3","3","—Wa jaj ti inchech u Mejenech a Dioso, adü ti'i a tunich ada' ca' su'tuc ti panil,— cu t'an a quisin ti'i a Jesusu. ");
INSERT INTO mopNT_vpl VALUES ("LK4_4","072_4_4","LUK","4","4","4","—Baala' ti tz'iiba'an,— cu t'an a Jesus ti'iji. —Ma' chen etel pan cuxa'an a cristianoji. Yan ilic u tz'ocsic tulacal u t'an a Dioso,— cu t'an ti'i a quisini. ");
INSERT INTO mopNT_vpl VALUES ("LK4_5","072_4_5","LUK","4","5","5","Pues te'i. Le'ec a quisini, u bensaj a Jesus tac tu pol a witz a top ca'nala. Ich jun p'e rato ilic u ye'aj ti'i tulacal boon a caj a yan yoc'olcaba. ");
INSERT INTO mopNT_vpl VALUES ("LK4_6","072_4_6","LUK","4","6","6","—Bel in quin manes ta cuenta tulacal abe'e, tac etel boon u qui'il. Tz'abi ten abe'e, y jede'ec u paatal in sijic ti'i mac in c'ati,— cu t'an a quisin ti'i a Jesusu. ");
INSERT INTO mopNT_vpl VALUES ("LK4_7","072_4_7","LUK","4","7","7","—Wa cuchi ca' xonlaquech tin taan a tz'aa' ten a tziqui, jede'ec in tz'eec tech tulacal abe'e,— cu t'an a quisin ti'iji. ");
INSERT INTO mopNT_vpl VALUES ("LK4_8","072_4_8","LUK","4","8","8","—Baala' ti tz'iiba'an ichil u ju'um a Dioso,— cu t'an a Jesusu. —“C'ajes a Noochtzili, le'ec a Dios. Jadi' ti'i ala'i ca' a tz'aa' a tziqui.” Baala' ti tz'iiba'an,— cu t'an a Jesus ti'iji. ");
INSERT INTO mopNT_vpl VALUES ("LK4_9","072_4_9","LUK","4","9","9","Pues te'i. Le'ec a quisini, u bensaj a Jesus ich caj Jerusalene. U tz'aj a Jesus tac tu pol u yotoch a Dioso. —Wa jaj ti le'ec inchech u Mejenech a Dioso, pulu a bajil tac ti lu'um. ");
INSERT INTO mopNT_vpl VALUES ("LK4_10","072_4_10","LUK","4","10","10","Ma' ta yajtal u men baala' ti tz'iiba'an,— cu t'an a quisini. —Le'ec a Dioso, bel u cu tz'aa' ti'ijoo' u yaj xa'num ti ca'an ca' u cününteechoo',— cu t'an a quisini. ");
INSERT INTO mopNT_vpl VALUES ("LK4_11","072_4_11","LUK","4","11","11","—Tz'iiba'an ilic ti bel a ca'a cününbül ti'i ma' a t'ochic a woc tuwich tunich,— cu t'an a quisin ti'i a Jesusu. ");
INSERT INTO mopNT_vpl VALUES ("LK4_12","072_4_12","LUK","4","12","12","Tz'iiba'an ilic ti baala',— cu t'an a Jesusu. —Ma' qui' a yaaltic a wila' u patalil a Noochtzili, le'ec a Dioso,— cu t'an a Jesus ti'i a quisini. ");
INSERT INTO mopNT_vpl VALUES ("LK4_13","072_4_13","LUK","4","13","13","Le'ec ti jobi u yaaltic u yemes u yool a Jesusu, bini a quisin u paac'te u c'ochol u q'uinil u ca' yaaltic tucaye'il. ");
INSERT INTO mopNT_vpl VALUES ("LK4_14","072_4_14","LUK","4","14","14","Pues te'i. Usc'aji a Jesus tu cuenta Galileaja. Tan u yaantabül u men u Püsüc'al a Dioso. Tzicbalbi a Jesus tulacal tuba te'iji. ");
INSERT INTO mopNT_vpl VALUES ("LK4_15","072_4_15","LUK","4","15","15","Walac u beel ti t'an a Jesus ichil boon a naj tuba walacoo' u much'tal aj Israel u c'ajes a Dioso. Tulacaloo'o, u yadajoo' u qui'il a Jesusu. ");
INSERT INTO mopNT_vpl VALUES ("LK4_16","072_4_16","LUK","4","16","16","Pues te'i. C'ochi a Jesus ich caj Nazaret tuba ch'iji. Tu q'uinil a jedele, oqui a Jesus ichil a naj tuba walacoo' u much'tal aj Israel u c'ajes a Dioso. Suc a Jesus u bete' ti baalo'. Wa'laji te'i ti xoc. ");
INSERT INTO mopNT_vpl VALUES ("LK4_17","072_4_17","LUK","4","17","17","Le'ec u ju'um a Dios a tz'iiba'an u men aj Isaiasa, tz'abi ti'i u xoco'. Aj Isaiasa, le'ec jun tuul u yadaj u t'an a Dios uchiji. U jebaj a ju'um abe' a Jesusu. U cüxtaj tuba tz'iiba'an ti baala': ");
INSERT INTO mopNT_vpl VALUES ("LK4_18","072_4_18","LUK","4","18","18","—Le'ec u Püsüc'al a Noochtzili, que'en tin wetel u men yeeta'anen ti'i ca' in wadü' a quich'pan t'an ti'ijoo' a otzili. U tücaa'tajen in waantoo' a yajoo' u yoolo. U tücaa'tajen ti'i ca' in wadü' ti cha'a'anoo' cuchi a mücha'anoo'o, y ca' uchucoo' u cha'an a ch'oopo. U tücaa'tajen ti'i ca' in joq'uesoo' mac a tanoo' u c'ümic a yaj tu c'ü' mac a tan u tz'aj yajili. ");
INSERT INTO mopNT_vpl VALUES ("LK4_19","072_4_19","LUK","4","19","19","U tücaa'tajen ti'i ca' in wadoo' ti'i u q'uinil ca' u yadaj a Dios u c'ümicoo' a qui'i. Baalo' u tz'iibtaj aj Isaiasa,— cu t'an a Jesusu. ");
INSERT INTO mopNT_vpl VALUES ("LK4_20","072_4_20","LUK","4","20","20","Le'ec ti jobi u xoquic abe'e, u c'ülaj u ju'um a Dioso. U yusq'uintaj a ju'um ti'i u yaj cananili. Tinlaji a Jesusu. Tulacal boon a cristiano a que'en te'i tuba walacoo' u c'ajsic a Dioso, tanoo' u cha'antic a Jesusu. ");
INSERT INTO mopNT_vpl VALUES ("LK4_21","072_4_21","LUK","4","21","21","Caji ti t'an a Jesus eteloo'o. —Aleebe caji tun ti uchul ta taane'ex a c'u' in xocaj te'exe,— cu t'an a Jesus ti'ijoo'o. ");
INSERT INTO mopNT_vpl VALUES ("LK4_22","072_4_22","LUK","4","22","22","Pues te'i. Le'ec boon a cristiano a much'a'anoo' te'iji, u laj adajoo' u qui'il a Jesusu. Sa'too' u yool u men a qui'il t'an u yadaja. —¿Ma' wa le'ec ala'i u mejen aj Joseje?— cu t'anoo' tu bajil. ");
INSERT INTO mopNT_vpl VALUES ("LK4_23","072_4_23","LUK","4","23","23","—Uchac tun a wadique'ex ten a t'an ada'a,— cu t'an a Jesusu. —“Aj tz'ücyajech, ca' se' tz'ücü a bajil,” que'ex wal tene, yoc'ol ca' in bete' a milagro ta yaame'ex tuba ch'ijeene. Uchac tun a wadique'ex ilic a t'an ada'a: “Ti wu'yaj c'u' a betaj ich caj Capernaum. Bete ilic a jabix abe' wa'ye' ichil a caal,” que'ex wal tene,— cu t'an a Jesusu. ");
INSERT INTO mopNT_vpl VALUES ("LK4_24","072_4_24","LUK","4","24","24","—Tan in wadic te'ex u jajil. Le'ec mac a tan u yadic u t'an a Dioso, ma' ta'ach u tz'ocsabül u yanil u menoo' u yetcaal,— cu t'an a Jesusu. ");
INSERT INTO mopNT_vpl VALUES ("LK4_25","072_4_25","LUK","4","25","25","—Aj Eliasa, jun tuul aj Israel u yadaj u t'an a Dios uchiji. Yanoo' ix ma'icham tu cuenta Israel ti cuxa'an to aj Eliasa. Ox p'e jaab etel tancooch ma' uchi a ja'a. Yan a wi'ijil tulacal tuba cuenta Israele,— cu t'an a Jesusu. ");
INSERT INTO mopNT_vpl VALUES ("LK4_26","072_4_26","LUK","4","26","26","—Ma' tücaa'bi aj Elias ca' xi'ic u yaantoo' ix ma'icham cuenta Israeli. Tücaa'bi ala'i ich caj Sarepta tu cuenta Sidon. Te'i u yaantaj jun tuul ix ma'icham,— cu t'an a Jesus ti'ijoo'o. ");
INSERT INTO mopNT_vpl VALUES ("LK4_27","072_4_27","LUK","4","27","27","—Baalo' ilic ti cuxa'an to aj Eliseojo, le'ec jun tuul aj Israel u yadaj u t'an a Dios uchiji. Yanoo' a tan u tu'ujtal u büq'uel u men u c'oja'anil tu cuenta Israel ti a q'uin abe'e. Ma'ax jun tuul tu yaamoo' aj Israel a ch'anesabiji. Jadi' aj Naaman a tali cuenta Siria, jadi' a ch'anesabi,— cu t'an a Jesusu. ");
INSERT INTO mopNT_vpl VALUES ("LK4_28","072_4_28","LUK","4","28","28","Le'ec ca' u yubajoo' abe'e, lic'oo' u tz'iiquil tulacaloo' a cristiano a much'a'anoo' u c'ajes a Dios te'iji. ");
INSERT INTO mopNT_vpl VALUES ("LK4_29","072_4_29","LUK","4","29","29","Lic'oo' a cristianojo. U joc'sajoo' a Jesus tu pach caj tu c'asil. Que'en a caj abe' tuwich witz. U bensajoo' ala'i tuba toj wa'an a witzi. U c'atiintajoo' u lench'inte a Jesus tac yalam witz. ");
INSERT INTO mopNT_vpl VALUES ("LK4_30","072_4_30","LUK","4","30","30","C'u' betiqui, mani a Jesus chumucoo' a cristianojo. Bini. ");
INSERT INTO mopNT_vpl VALUES ("LK4_31","072_4_31","LUK","4","31","31","Pues te'i. Bini a Jesus ich caj Capernaum tu cuenta Galilea. Tan u ca'ansicoo' a cristiano a que'en te'i tu q'uinil a jedele. ");
INSERT INTO mopNT_vpl VALUES ("LK4_32","072_4_32","LUK","4","32","32","Sa'too' u yool ti tanoo' u ca'ansabül u men a Jesusu, u men chica'an ti u yeel c'u' a tan u ye'iqui. ");
INSERT INTO mopNT_vpl VALUES ("LK4_33","072_4_33","LUK","4","33","33","Pues te'i. Jun tuul a winiqui, yan a c'ac'asba'al ichil u yoolo. Que'en a winic abe' tu yaamoo' a much'a'anoo' u c'ajes a Dioso. Uchi u t'an ti chich a winic abe'e. ");
INSERT INTO mopNT_vpl VALUES ("LK4_34","072_4_34","LUK","4","34","34","—P'üto'on. Ma' c'u' a t'an to'oni. Inchech a Jesusu. Nazaret taleech. ¿Taleech wa a jobso'on? In weel a wich. Incheche, u Mejenech Dios,— cu t'an ti'i a Jesusu. ");
INSERT INTO mopNT_vpl VALUES ("LK4_35","072_4_35","LUK","4","35","35","—Ma' a t'an,— cu t'an a Jesus ti'iji. —Joq'uen ichil u yool a winiqui,— cu t'an ti'i. Le'ec a c'ac'asba'ala, u c'atsaj a winic ti lu'um tu taanoo' a cristianojo. Ma' u yajcuntaj a winiqui. Chen joq'ui ichil u yool ala'aji. ");
INSERT INTO mopNT_vpl VALUES ("LK4_36","072_4_36","LUK","4","36","36","Sa'too' u yool a cristiano a que'enoo' te'iji. Cajoo' ti t'an tu bajiloo'. —¿C'u' tun ti winiquil ada'a? Etel u patalil y etel u muc' walac u joc'sicoo' a c'ac'asba'ala, y walacoo' u joc'ol ichil u yool a maca,— cu t'anoo' tu bajil. ");
INSERT INTO mopNT_vpl VALUES ("LK4_37","072_4_37","LUK","4","37","37","Tzicbalbi a Jesus tulacal tuba te'iji. ");
INSERT INTO mopNT_vpl VALUES ("LK4_38","072_4_38","LUK","4","38","38","Pues te'i. Joq'ui a Jesus ichil a naj abe' tuba much'a'anoo' a cristianojo. Bini tu yotoch aj Simon. C'oja'an u yixa'an aj Simono. Tan u chücüwil ti chich. C'aatbi ti'i a Jesus ca' u yaante a nooch'upu. ");
INSERT INTO mopNT_vpl VALUES ("LK4_39","072_4_39","LUK","4","39","39","Bini ti wa'tal tzeel a c'oja'ana. U yadaj ca' manüc u chücüwil. Mani ti'i. Tu seebal liq'ui a nooch'upu. U tz'ajoo' u janal u yaj sutiloo'. ");
INSERT INTO mopNT_vpl VALUES ("LK4_40","072_4_40","LUK","4","40","40","Pues te'i. Tan u yocol a q'uini. Tulacal a maca, u bensajoo' u c'oja'an etel a Jesusu. Yaab u wich u c'oja'aniloo' a yana. Le'ec a Jesusu, u tz'aj u c'ü' yoc'ol a jujun tuul a c'oja'ana. U ch'anesajoo'. ");
INSERT INTO mopNT_vpl VALUES ("LK4_41","072_4_41","LUK","4","41","41","Yanoo' ilic a c'ac'asba'al a joc'saboo' ichil u yool a cristianojo. —Incheche, u Mejenech Dios,— cu t'anoo' a c'ac'asba'al ti chich ti'i a Jesusu. C'u' betiqui, ma' ta'ach u cha'ic u t'an a c'ac'asba'ala, u men le'ec a c'ac'asba'ala, u yeeloo' ti le'ec a Jesusu, le'ec u yaj Sa'alil a cristianojo. ");
INSERT INTO mopNT_vpl VALUES ("LK4_42","072_4_42","LUK","4","42","42","Pues te'i. Le'ec ti sasajiji, joq'ui a Jesusu. Bini tuba ma' yanoo' a cristianojo. Le'ecoo' a cristianojo, cajoo' u cüxte a Jesusu. Le'ec ca' u cüxtajoo'o, ma' u c'atiintajoo' u chaa' ca' xi'ic a Jesusu. ");
INSERT INTO mopNT_vpl VALUES ("LK4_43","072_4_43","LUK","4","43","43","—Yan ilic in beel ichil ulaac' a caja. Yan ilic in wadic ti'ijoo' a cristiano te'i a qui'il t'an yoc'ol biqui ti tan tun u tücaa' a Dioso,— cu t'an a Jesus ti'ijoo'o. —Tücaa'been in bete' ti baalo',— cu t'an ti'ijoo'. ");
INSERT INTO mopNT_vpl VALUES ("LK4_44","072_4_44","LUK","4","44","44","Tan ti tan u manül a Jesus tulacal tuba cuenta Galilea. Walac u beel ti t'an ichil boon a naj tuba walacoo' u much'tal a cristiano u c'ajes a Dioso. ");
INSERT INTO mopNT_vpl VALUES ("LK5_1","072_5_1","LUK","5","1","1","Pues te'i. Jun p'eel q'uin wa'an ti que'en a Jesus chi' a laguna u c'aba' Genesaret. Yanoo' a cristiano te'iji. Tanoo' u tutulca'tic u bajil ti'i ca' mas naatz'ücoo' tu tzeel a Jesus ti'i u yubicaloo' u tzicbaltic u t'an a Dioso. ");
INSERT INTO mopNT_vpl VALUES ("LK5_2","072_5_2","LUK","5","2","2","Le'ec a Jesusu, u yilaj ca' cuul a barco chi' a ja'a. Le'ecoo' a mac a walacoo' u jooc' ichili, joc'a'anoo' ichil a barco abe'e. Tanoo' u p'o'ic u chinchor walaquil u müch ch'ilam. ");
INSERT INTO mopNT_vpl VALUES ("LK5_3","072_5_3","LUK","5","3","3","Oqui a Jesus ichil jun cuul a barcojo. Ti'i aj Simon a barco abe'e. —Jisi tz'etz'eecac ich ja',— cu t'an a Jesus ti'iji. Tinlaji a Jesus ichil a barco ti'i u ca'ansicoo' a cristiano a que'en chi' a ja'a. ");
INSERT INTO mopNT_vpl VALUES ("LK5_4","072_5_4","LUK","5","4","4","Pues te'i. Jobi ti t'an a Jesus eteloo' a cristianojo. —Benes a barco ich tamil,— cu t'an a Jesus ti'i aj Simono. —Te'i a tzümique'ex a chinchor walaquile'ex a müch ch'ilam,— cu t'an a Jesus ti'ijoo' boon tuul a que'en ichil a barcojo. ");
INSERT INTO mopNT_vpl VALUES ("LK5_5","072_5_5","LUK","5","5","5","—Noochwinic,— cu t'an aj Simon ti'i a Jesusu. —Uchi ti meyaj ti chich tulacal a ac'ü'ü, pero ma'ax c'u' ti müch'aja. C'u' betiqui, u men tan a wadic to'ono, bel ti ca'a ti yaalte,— cu t'an aj Simon ti'i a Jesusu. ");
INSERT INTO mopNT_vpl VALUES ("LK5_6","072_5_6","LUK","5","6","6","U tz'ajoo' ich ja' walaquiloo' u müch ch'ilam. Caji ti t'uupul a chinchor abe' u men u yaabil aj ch'ilama. ");
INSERT INTO mopNT_vpl VALUES ("LK5_7","072_5_7","LUK","5","7","7","U ye'ajoo' u c'ü' ti'ijoo' u yet'oc ichil ulaac' a barco ca' talacoo' aantabül. C'ochoo' ala'oo'. U tudesajoo' a barco tu ca' cuulil. Watac u budel a barco u men u yaabil aj ch'ilama. ");
INSERT INTO mopNT_vpl VALUES ("LK5_8","072_5_8","LUK","5","8","8","Le'ec ca' u yilaj c'u' a uchiji, xonlaji aj Simon Pedro tu taan a Jesusu. —Noochil, ma' u naj ca' culaquech tin tzeele. Top walac in cüxtic in sip'il,— cu t'an aj Simon ti'i a Jesusu. ");
INSERT INTO mopNT_vpl VALUES ("LK5_9","072_5_9","LUK","5","9","9","U yadaj abe'e, u men sa'ti u yool etel boon aj ch'ilam u müchajoo'o. Sa'too' ilic u yool boon tuul a que'enoo' etel aj Simono. ");
INSERT INTO mopNT_vpl VALUES ("LK5_10","072_5_10","LUK","5","10","10","Sa'too' ilic u yool aj Jacob y aj Juan le'ecoo' u mejen aj Zebedeojo. Le'ecoo' a ca' tuul abe'e, walacoo' u comon meyaj etel aj Simon. —Ma' u jac'ül a wool,— cu t'an a Jesus ti'i aj Simono. —Jabix ilic ca' a müchajoo' to aj ch'ilama, leeb a caal a müchoo' a cristiano ca' xicoo' tu c'ü' a Dioso,— cu t'an a Jesus ti'iji. ");
INSERT INTO mopNT_vpl VALUES ("LK5_11","072_5_11","LUK","5","11","11","Le'ec ca' u c'ochesajoo' a barco chi' a ja'a, u p'ütajoo' tulacaloo' u nu'cul u meyaj. Binoo' tu pach a Jesusu. ");
INSERT INTO mopNT_vpl VALUES ("LK5_12","072_5_12","LUK","5","12","12","Pues te'i. Le'ec ti que'en a Jesus ichil jun p'eel a caja, c'ochi jun tuul a winic etel. Top tan u tu'ujtal u büq'uel u men u c'oja'anil. Le'ec ca' u yilaj a Jesusu, xonlaji tu taan. U c'aataj ti'i a Jesus ca' aantabüc. —Noochil, wa qui' ta wich a ch'anesiquene, jede'ec u paatal a ch'anesiquen,— cu t'an ti'i a Jesusu. ");
INSERT INTO mopNT_vpl VALUES ("LK5_13","072_5_13","LUK","5","13","13","Le'ec a Jesusu, u tz'aj u c'ü' yoc'ol a winiqui. —In c'ati,— cu t'an ti'i. —Ch'aneech tun,— cu t'an a Jesusu. Tu seebal ch'ani a winiqui. ");
INSERT INTO mopNT_vpl VALUES ("LK5_14","072_5_14","LUK","5","14","14","—Ma' a wadic ti'i ma'ax mac wa in qui'cuntajech,— cu t'an a Jesus ti'iji. —Jadi' ca' xiquech etel u yaj mansaj t'an a cristiano ti'i a Dioso. Ye'e a bajil ti'i, y tz'a ti'i a Dios a sij-ool a jabix ilic ti tz'iiba'an ichil a ley u tz'iibtaj aj Moisese. Te'i u yilicoo' ti ch'aneech,— cu t'an a Jesusu. ");
INSERT INTO mopNT_vpl VALUES ("LK5_15","072_5_15","LUK","5","15","15","C'u' betiqui, t'iit'i ti mas yaab u pectzil etel c'u' u betaj ti'i a winiqui. Mas yaabajoo' a cristiano a walacoo' u much'tal u yuboo' u t'an. C'ochoo' ilic ti'i ca' ch'anesabücoo'. ");
INSERT INTO mopNT_vpl VALUES ("LK5_16","072_5_16","LUK","5","16","16","Le'ec a Jesusu, boch walac u beel tu junal tuba ma' yanoo' a cristiano ti t'an etel a Dioso. ");
INSERT INTO mopNT_vpl VALUES ("LK5_17","072_5_17","LUK","5","17","17","Pues te'i. Jun p'eel q'uin tan u ca'ansicoo' a cristiano a Jesusu. Te'i tina'anoo' a fariseo u c'aba'oo' u na'ata. Te'i ilic que'enoo' u yaj ca'ansajil u ley aj Moisese. Te' tala'anoo' ala'oo' ichil tulacal a caj cuenta Galilea cuenta Judeaja. Yanoo' ilic a taloo' ich caj Jerusalen xan. Yan u muc' a Dios etel a Noochtzil ti'i u ch'anesicoo' a c'oja'ana. ");
INSERT INTO mopNT_vpl VALUES ("LK5_18","072_5_18","LUK","5","18","18","C'ochoo' ulaac' a winiqui. Tanoo' u cuchic jun tuul a winic a sotmen u büq'uel a ma' ta'ach u peeque. Coya'an ti que'en tuwich u coytaan. U yaaltajoo' u c'oches a c'oja'an tu taan a Jesusu. ");
INSERT INTO mopNT_vpl VALUES ("LK5_19","072_5_19","LUK","5","19","19","Top yaab a cristiano a much'a'anoo' te'iji. Ma' u cüxtajoo' biqui ca' u c'oches a c'oja'an tu tzeel a Jesusu. Ta wich quet u pol a naja, nac'oo' pol naj etel a c'oja'ana. U potajoo' u pol a naja. Te'i u yemsajoo' a c'oja'an tac etel u coytaan tu taan a Jesusu. ");
INSERT INTO mopNT_vpl VALUES ("LK5_20","072_5_20","LUK","5","20","20","Le'ec a Jesusu, u yilaj ti que'enoo' u yool tu pach ala'i ti'i ca' u ch'anes a sotmen u büq'uele. —Sa'tesabi a sip'il,— cu t'an a Jesus ti'iji. ");
INSERT INTO mopNT_vpl VALUES ("LK5_21","072_5_21","LUK","5","21","21","Le'ecoo' a fariseo u c'aba'oo' u na'at u yet'ocoo' u yaj ca'ansajil u ley aj Moisese, cajoo' u yadü': —Tan u maclant'antic a Dioso. Ma'ax mac jede'ec u paatal u sa'tesic a sip'ili, jadi' a Dioso,— cu t'anoo' tu bajil. ");
INSERT INTO mopNT_vpl VALUES ("LK5_22","072_5_22","LUK","5","22","22","A Jesusu, u na'taj c'u' a tanoo' u tucliqui. —¿C'u' ca'a tane'ex a tuclic abe'e?— cu t'an a Jesus ti'ijoo'o. ");
INSERT INTO mopNT_vpl VALUES ("LK5_23","072_5_23","LUK","5","23","23","—Ma' yaj ca' in wadü' ti sa'tesabi u sip'il u men ma' chica'an wa jaj ti sa'tesabi ti'i. C'u' betiqui, yaj ca' in wadü' ca' wa'lac. Ca' uchuc u ximbal u men te'i u chictal wa jaj in t'an,— cu t'an a Jesusu. ");
INSERT INTO mopNT_vpl VALUES ("LK5_24","072_5_24","LUK","5","24","24","—Inene, yanajeen ti cristianojil. Wa ca' in ch'anes ala'aji, chica'an te'ex ti patalen ti sa'tesaj sip'il wa'ye' yoc'olcab,— cu t'an a Jesus ti'ijoo'o. —Tan in wadic tech. Wa'len. Molo a coytaan. Ca' xiquech ta wotoch,— cu t'an ti'i a winic a sotmen u büq'uele. ");
INSERT INTO mopNT_vpl VALUES ("LK5_25","072_5_25","LUK","5","25","25","Coya'an ti que'en a sotmen u büq'uel taan a cristianojo. Tu seebal wa'laji. U molaj u coytaan. Caji ti usc'al tu yotoch. Tan u yadic u qui'il a Dios ti tan u beele. ");
INSERT INTO mopNT_vpl VALUES ("LK5_26","072_5_26","LUK","5","26","26","Sa'too' u yool a cristiano etel c'u' a maniji. U yadajoo' u qui'il a Dioso. Saacajoo' tu jajil. —Top jumpaay ti wilaj aleebe,— cu t'anoo'. ");
INSERT INTO mopNT_vpl VALUES ("LK5_27","072_5_27","LUK","5","27","27","Pues te'i. Mas pachili, joq'ui te'i a Jesusu. Le'ec ti tan u beele, u yilaj aj Leviji. Ala'aji, jun tuul aj mol taq'uin ti'i a gobiernojo. Tina'an ti que'en tu cuuchil tuba walac u meyaj. —Co'ox tin pach,— cu t'an a Jesus ti'iji. ");
INSERT INTO mopNT_vpl VALUES ("LK5_28","072_5_28","LUK","5","28","28","U p'ütaj a meyaj a tan u betiqui. Liq'ui. Bini tu pach a Jesusu. ");
INSERT INTO mopNT_vpl VALUES ("LK5_29","072_5_29","LUK","5","29","29","Pues te'i. Le'ec aj Leviji, u betaj a fiesta ichil u yotoch ti'i a Jesusu. Nooch a fiesta u betaja. Much'lajoo' ti yaab aj mol taq'uin ti'i a gobiernojo. Much'lajoo' ilic ti yaab ulaac' mac. Que'enoo' ti janal pach mesa. ");
INSERT INTO mopNT_vpl VALUES ("LK5_30","072_5_30","LUK","5","30","30","Ilbi a Jesus tu yaamoo' u men a fariseo u c'aba'oo' u na'at u yet'ocoo' u yaj ca'ansajil u ley aj Moisese. Fariseojoo' ilic ala'oo'o. Cajoo' u p'a'astoo' u yaj cambal a Jesusu. —¿C'u' ca'a tane'ex a janal a wuc'ul eteloo' aj mol taq'uin ti'i a gobiernojo, u yet'ocoo' a top yanoo' u sip'ili?— cu t'anoo' ti'i u yaj cambal a Jesusu. ");
INSERT INTO mopNT_vpl VALUES ("LK5_31","072_5_31","LUK","5","31","31","—Ma' c'abeet aj tz'ücyaj ti'ijoo' a muc'a'ani, pero c'abeet ti'ijoo' a c'oja'ana,— cu t'an a Jesus ti'ijoo' ti uchi u nuuc. ");
INSERT INTO mopNT_vpl VALUES ("LK5_32","072_5_32","LUK","5","32","32","—Ma' taleen ti'i ca' in wadü' ti'ijoo' a cristiano a tojoo' u na'at ca' u jeloo' u tucul ca' tun u tucloo' a tojo. Taleen ti'i ca' in wadü' abe' ti'ijoo' a yanoo' u sip'ili,— cu t'an a Jesus ti'ijoo'o. ");
INSERT INTO mopNT_vpl VALUES ("LK5_33","072_5_33","LUK","5","33","33","Pues te'i. —Le'ecoo' u yaj cambal aj Juan aj tz'aj ocja'a, yaab sut ti walacoo' u p'ütic a janal ti'i ca' uchucoo' u suq'uin. Walacoo' ilic u t'an ti yaab etel a Dioso,— cu t'anoo' ti'i a Jesusu. —Baalo' ilic ti walacoo' u betic u yaj cambaloo' boon a fariseo u c'aba'oo' u na'ata. C'u' betiqui, a waj cambaloo' incheche, walacoo' u janal u yuc'ul. ¿C'u' ca'a?— cu t'anoo' ti'i a Jesusu. ");
INSERT INTO mopNT_vpl VALUES ("LK5_34","072_5_34","LUK","5","34","34","—Ma' tu paatale'ex a tz'eec ti'ijoo' mac a emi ti uc'ul etel aj tz'ocolbeel ca' u p'ütoo' u janal ca' tun uchucoo' u suq'uin le'ec ti que'en to aj tz'ocolbeel tu yaamoo',— cu t'an a Jesus ti uchi u nuucticoo'o. ");
INSERT INTO mopNT_vpl VALUES ("LK5_35","072_5_35","LUK","5","35","35","—C'u' betiqui, watac u q'uinil, le'ec ti bel u ca'a joc'sabül aj tz'ocolbeel tu yaamoo' u yaj sutili. Ti a q'uin abe'e, beloo' u ca'a ti suq'uin,— cu t'an a Jesus ti'ijoo'o. ");
INSERT INTO mopNT_vpl VALUES ("LK5_36","072_5_36","LUK","5","36","36","Pues te'i. Uchi ilic u t'an a Jesus ti'ijoo' ich mucult'an yoc'ol biqui ti ma' qui' tu cuntal a tumulben to etel a uchben a sucoo' u bete'e. —Ma'ax mac walac u tz'eec a tumul noc' ti'i u püc'ülbeeb a uchben noc'o,— cu t'an a Jesusu. —Wa cuchi ca' u betoo' ti baalo'o, bel u cu tzili' a tumul noc' tuba u joc'sic u püc'ülbeebe, y ma' qui' tu joc'ol a li' noq'ui,— cu t'an ti'ijoo' ich mucult'an. ");
INSERT INTO mopNT_vpl VALUES ("LK5_37","072_5_37","LUK","5","37","37","—Ma'ax walac u tz'abül tumul vino ichil u cuuchil a betabi etel uchben q'uewel,— cu t'an. —Wa cuchi ca' tz'abüc ti baalo'o, tanil u tzaquesic u bajil a tumul vinojo, bel u ca'a ti jeetel a uchben q'uewele. Tooxol u ca'a cuchi a vinojo, y c'astal u ca'a cuchi a q'uewele,— cu t'an a Jesus ti'ijoo' ich mucult'an. ");
INSERT INTO mopNT_vpl VALUES ("LK5_38","072_5_38","LUK","5","38","38","—Yan u tz'abül a tumul vino ichil u cuuchil a betabi etel tumul q'uewel,— cu t'an a Jesusu. ");
INSERT INTO mopNT_vpl VALUES ("LK5_39","072_5_39","LUK","5","39","39","—Ma'ax le'ec mac u yaaltaj a uchben vinojo, ma' tu c'atiintic u yuc'u' a tumulben to. “Mas qui' a uchbene,” cu t'anac cuchi,— cu t'an a Jesus ti'ijoo' ich mucult'an. ");
INSERT INTO mopNT_vpl VALUES ("LK6_1","072_6_1","LUK","6","1","1","Pues te'i. Jun p'eel q'uin tan u manül a Jesus eteloo' u yaj cambal ich col. U q'uinil jedel a q'uin abe'e. Wi'ijoo' u yaj cambal a Jesusu. U jirip'tajoo' tz'etz'eec u semilla a harinaja. U jüjüxc'ü'tajoo' ti'i ca' joc'oc u pach. U jantajoo'. ");
INSERT INTO mopNT_vpl VALUES ("LK6_2","072_6_2","LUK","6","2","2","C'u' betiqui, yanoo' a fariseo u c'aba'oo' u na'at te'iji. —¿C'u' ca'a tane'ex a betic c'u' a ma' qui' u betabül tu q'uinil a jedele?— cu t'anoo' ti'i u yaj cambal a Jesusu. ");
INSERT INTO mopNT_vpl VALUES ("LK6_3","072_6_3","LUK","6","3","3","—¿Ma' wa a xocaje'ex c'u' u betaj aj quimen rey David u yet'ocoo' u yetmanül ti wi'ijoo'o?— cu t'an a Jesus ti'ijoo' ti uchi u nuuc. ");
INSERT INTO mopNT_vpl VALUES ("LK6_4","072_6_4","LUK","6","4","4","—Oqui aj David ichil u yotoch a Dioso,— cu t'an a Jesusu. —U molaj a waj harina a tz'abi ti'i a Dioso. U tz'aj ti'ijoo' u yetmanül. U laj jantajoo' a waj harinaja. Le'ec a Dioso, u tz'aj ca' jantabüc a waj harina abe' jadi' u menoo' u yaj mansaj t'an a cristiano ti'i a Dioso. Ala'aji, ma' u yaj mansaj t'an a cristiano ti'i a Diosi,— cu t'an a Jesus ti'ijoo'o. ");
INSERT INTO mopNT_vpl VALUES ("LK6_5","072_6_5","LUK","6","5","5","—Inene, yanajeen ti cristianojil. Yan in yanil ti tücaa' ca'ax tu q'uinil jedel,— cu t'an a Jesusu. ");
INSERT INTO mopNT_vpl VALUES ("LK6_6","072_6_6","LUK","6","6","6","Pues te'i. Ti ulaac' u q'uinil a jedele, oqui a Jesus ichil jun cuul naj tuba walacoo' u much'tal aj Israel u c'ajes a Dioso. Tan u ca'ansicoo' te'i. Tu yaam a much'a'anoo' te'iji, yan jun tuul a winic a mooch u c'ü'ü. ");
INSERT INTO mopNT_vpl VALUES ("LK6_7","072_6_7","LUK","6","7","7","Le'ecoo' u yaj ca'ansajil u ley aj Moises u yet'ocoo' a fariseo u c'aba'oo' u na'ata, tanoo' u cha'antic a Jesusu. U c'atoo' u yila' wa ca' u ch'anes a mac tu q'uinil a jedel ti'i ca' paatac u yadoo' ti yan u sip'il a Jesusu. ");
INSERT INTO mopNT_vpl VALUES ("LK6_8","072_6_8","LUK","6","8","8","C'u' betic a Jesusu, u yeel c'u' a tanoo' u tucliqui. —Wa'len chumuquil,— cu t'an a Jesus ti'i a winic a mooch u c'ü'ü. Liq'ui. Wa'laji te'i. ");
INSERT INTO mopNT_vpl VALUES ("LK6_9","072_6_9","LUK","6","9","9","—Bel in quin c'aate te'ex jun p'eel a t'ana,— cu t'an a Jesus ti'ijoo' a tanoo' u cha'ana. —¿Biqui'il a qui' tu c'axül ti'i a ley ti u q'uinil a jedele, wa ti'i ti betical a qui'i, wa ti'i ti betical a c'asa? ¿Qui' wa ca' ti sa'alte u cuxtal a maca, wa ca' ti quimes ala'i ti u q'uinil a jedele?— cu t'an a Jesus ti'ijoo'o. ");
INSERT INTO mopNT_vpl VALUES ("LK6_10","072_6_10","LUK","6","10","10","Le'ec a Jesusu, u sutaj u wich u cha'antoo' tulacaloo'. —Sützü a c'ü',— cu t'an ti'i a winiqui. U sützaj u c'ü'. Ch'ani. ");
INSERT INTO mopNT_vpl VALUES ("LK6_11","072_6_11","LUK","6","11","11","Lic'oo' u tz'iiquil ala'oo' tu jajil. Cajoo' u tzicbalte c'u' a cu betoo' ti'i a Jesusu. ");
INSERT INTO mopNT_vpl VALUES ("LK6_12","072_6_12","LUK","6","12","12","Pues te'i. Ma' top uchi manüc u q'uinil abe' ti naq'ui a Jesus tuwich witz ti t'an etel a Dioso. U mansaj a ac'ü' ti t'an te'i. ");
INSERT INTO mopNT_vpl VALUES ("LK6_13","072_6_13","LUK","6","13","13","Le'ec ti sasajiji, u püyajoo' boon u yaj cambal. Tu yaamoo' ala'oo'o, u yeetaj doce tuul. —Inche'ex in waj xa'num,— cu t'an ti'ijoo' a doce tuulu. ");
INSERT INTO mopNT_vpl VALUES ("LK6_14","072_6_14","LUK","6","14","14","Yeetbi aj Simono. U tz'aj u c'aba' ti aj Pedro. Yeetbi aj Andres, le'ec u yitz'in aj Simono. Yeetboo' aj Jacobo, aj Juana, aj Felipeje, aj Bartolomeje, ");
INSERT INTO mopNT_vpl VALUES ("LK6_15","072_6_15","LUK","6","15","15","aj Mateojo, aj Tomasa, y ulaac' aj Jacobo. Le'ec aj Jacob abe'e, le'ec u mejen aj Alfeojo. Yeetbi ilic ulaac' aj Simono. —Cananista,— cu t'anoo' ti'i aj Simon abe'e. ");
INSERT INTO mopNT_vpl VALUES ("LK6_16","072_6_16","LUK","6","16","16","Yeetbi ilic aj Judasa, le'ec u mejen aj Jacobo. Yeetbi ilic aj Judas Iscarioteje, le'ec mac u tzolaj a Jesusu. ");
INSERT INTO mopNT_vpl VALUES ("LK6_17","072_6_17","LUK","6","17","17","Pues te'i. a Jesusu, emi tuwich a witz abe' u yet'ocoo' a doce tuulu. Wa'laji tuba quet a lu'umu. Top yaaboo' u yaj cambal a que'enoo' te'iji. Mani tu pach u yaabil a cristiano a much'a'anoo' tu yaam. Yan a taloo' cuenta Judeaja. Yan a taloo' ich caj Jerusalen. Yan a taloo' chi' c'ac'naab ich caj Tiro caj Sidon. C'ochoo' u yuboo' u t'an a Jesusu. C'ochoo' ilic a c'oja'an ti tz'ücbülü. ");
INSERT INTO mopNT_vpl VALUES ("LK6_18","072_6_18","LUK","6","18","18","Baalo' ilic boon a yan a c'ac'asba'al tu yooloo', joc'sabi ti'ijoo'. ");
INSERT INTO mopNT_vpl VALUES ("LK6_19","072_6_19","LUK","6","19","19","Tulacaloo' a cristiano a much'a'anoo' te'iji, tanoo' u yaaltic u tülü' a Jesusu. Tan u ch'anesicoo' tulacal ala'oo' etel u patalil. ");
INSERT INTO mopNT_vpl VALUES ("LK6_20","072_6_20","LUK","6","20","20","Pues te'i. Le'ec a Jesusu, u cha'antajoo' u yaj cambal. —Le'ec boone'ex a otzile'exe, qui'e'ex cuchi a wool. Yan te'ex a cuuchil ichil u cuenta a Dioso,— cu t'an a Jesus ti'ijoo' u yaj cambala. ");
INSERT INTO mopNT_vpl VALUES ("LK6_21","072_6_21","LUK","6","21","21","—Le'ec boone'ex a jabix wi'ije'ex ti'i c'u' a ti'i a Dios aleebe, qui'e'ex cuchi a wool. Bel u ca'a tz'abül te'ex ti chucul te'ex,— cu t'an a Jesus ti'ijoo'o. —Le'ec boone'ex a tane'ex a woc'ol aleebe, qui'e'ex cuchi a wool. Bele'ex a ca'a ti che'ej,— cu t'an a Jesus ti'ijoo' u yaj cambala. ");
INSERT INTO mopNT_vpl VALUES ("LK6_22","072_6_22","LUK","6","22","22","—Le'ec ti motztzile'ex u menoo' a cristianojo, qui'e'ex cuchi a wool. Baalo' ilic le'ec ti tane'ex a joc'sabül tu yaamoo' ala'oo'o. Baalo' ilic ti tane'ex a p'a'asbül, y tan u yaalbül ti c'ase'ex a c'aba' tin woc'lal inen a yanajeen ti cristianojili,— cu t'an a Jesus ti'ijoo'o. ");
INSERT INTO mopNT_vpl VALUES ("LK6_23","072_6_23","LUK","6","23","23","—Qui'aque'ex a wool tu q'uinil u yuchul a c'as abe' te'exe. Uchuque'ex a siit u men u qui'ile'ex a wool. Bete'ex abe'e, u men yan ti yaab a qui'il te'ex a taaca'an ti ca'an. Le'ecoo' u uchben mamaa' a cristiano abe' a tanoo' u betic te'ex a c'asa, u betajoo' ilic a c'as a jabix abe' ti'ijoo' a winic u yadajoo' u t'an a Dios uchi,— cu t'an a Jesus ti'ijoo' u yaj cambal. ");
INSERT INTO mopNT_vpl VALUES ("LK6_24","072_6_24","LUK","6","24","24","—C'u' betiqui, yaj a bele'ex a ca'a a c'ümü' boon tuule'ex a ayic'ale'exe. A c'ümaje'ex tun a qui'i,— cu t'an a Jesusu. ");
INSERT INTO mopNT_vpl VALUES ("LK6_25","072_6_25","LUK","6","25","25","—Yaj a bele'ex a ca'a a c'ümü' boon tuule'ex a na'aje'exe. Bele'ex a ca'a ti wi'ijtal. Yaj a bele'ex a ca'a a c'ümü' boon tuule'ex a tane'ex a che'ej aleebe. Bel u ca'a ti yajtal a woole'ex. Bele'ex a ca'a ti oc'ol,— cu t'an a Jesusu. ");
INSERT INTO mopNT_vpl VALUES ("LK6_26","072_6_26","LUK","6","26","26","—Yaj a bele'ex a ca'a a c'ümü' boon tuule'ex a tane'ex a tzicbalbül ti qui'e'ex u men tulacaloo' a cristianojo. Le'ecoo' u uchben mamaa'oo' abe'e, u tzicbaltajoo' ilic u qui'il boon tuul u tz'ajoo' u bajil jabix tanoo' u yadic u t'an a Dioso, pero chenoo' u tus,— cu t'an a Jesusu. ");
INSERT INTO mopNT_vpl VALUES ("LK6_27","072_6_27","LUK","6","27","27","—Pues te'i. Tan in wadic te'ex boone'ex a walaque'ex a wu'yic in t'ana. Yacunte'ex boon a tz'iic te'exe. Yan a betique'ex a qui' ti'ijoo' boon a walacoo' u motzintique'exe,— cu t'an a Jesusu. ");
INSERT INTO mopNT_vpl VALUES ("LK6_28","072_6_28","LUK","6","28","28","—Qui'qui't'ante'exoo' mac walacoo' u p'a'astique'ex. C'ajese'ex a Dios yoc'oloo' boon a walacoo' u betic te'ex a c'asa,— cu t'an a Jesusu. ");
INSERT INTO mopNT_vpl VALUES ("LK6_29","072_6_29","LUK","6","29","29","—Le'ec mac ca' u jütz'ü' a p'u'ucu, sutu a junxeele, ca' u jütz'ü'. Wa yan mac ca' u ch'aa' a noc' jun tziili, ma' a wet'ic ti'i u ch'a'ic jun tziil ulaac',— cu t'an a Jesusu. ");
INSERT INTO mopNT_vpl VALUES ("LK6_30","072_6_30","LUK","6","30","30","—Le'ec mac tan u matic c'u' a yan te'exe, tz'a'e'ex ti'i. Le'ec a mac ca' u toco' a c'u' teche, ma' a beele'ex ti yaab sut a c'aate'ex ca' u yusq'uinte abe'e,— cu t'an a Jesusu. ");
INSERT INTO mopNT_vpl VALUES ("LK6_31","072_6_31","LUK","6","31","31","—Jabix ilic a c'ate'ex ca' betabüc te'exe, baalo' ilic a yan a betique'ex ti'ijoo'o,— cu t'an a Jesusu. ");
INSERT INTO mopNT_vpl VALUES ("LK6_32","072_6_32","LUK","6","32","32","—Pues te'i. Wa cuchi jadi' a yajoo' u yube'ex a tane'ex a yacuntiqui, ma' tane'ex a betic a qui'il ti baalo'i. Le'ecoo' a que'enoo' ilic ichil u sip'ili, walacoo' ilic u betic ti baalo',— cu t'an a Jesusu. ");
INSERT INTO mopNT_vpl VALUES ("LK6_33","072_6_33","LUK","6","33","33","—Wa cuchi jadi' ti'ijoo' boon a walacoo' u betic te'ex a qui' tane'ex a betic a qui'i, ma' tane'ex a betic a qui'il ti baalo'i. Le'ecoo' a que'enoo' ilic ichil u sip'ili, walacoo' ilic u betic ti baalo',— cu t'an a Jesusu. ");
INSERT INTO mopNT_vpl VALUES ("LK6_34","072_6_34","LUK","6","34","34","—Wa cuchi jadi' ti'ijoo' a walacoo' u yusq'uintic u jel a taq'uin a walaque'ex a tz'eec u maantoo'o, ma' tane'ex a betic a qui'il ti baalo'i. Le'ecoo' a que'enoo' ilic ichil u sip'ili, walacoo' ilic u tz'eec ti maanil a taq'uin ti'ijoo' a walacoo' u yusq'uintic u jel tucaye'il,— cu t'an a Jesusu. ");
INSERT INTO mopNT_vpl VALUES ("LK6_35","072_6_35","LUK","6","35","35","—Yacunte'exoo' mac a tz'iicoo' te'exe. Yan a betique'ex qui'il ti'ijoo'. Yan a tz'eeque'ex ti maanil a taq'uin ti'ijoo', pero ma' tzaj a tuclique'ex wa bel u ca'a usq'uinbil te'ex u jel. Ca' a bete'ex ti baalo'o, bel u ca'a tz'abül te'ex a qui'il ti yaab u men a Dioso. Bel ilic u ca'a ti chictal ti le'ec inche'ex u mejen a Dios ti ca'ana. Ala'aji, walac ilic u ch'a'ic u yotzililoo' boon a ma' ta'achoo' u tz'eec a bo'tiqui, u yet'ocoo' boon a c'ac'as cristianojo,— cu t'an a Jesusu. ");
INSERT INTO mopNT_vpl VALUES ("LK6_36","072_6_36","LUK","6","36","36","—Yan a ch'a'ique'ex u yotzilil a maca, jabix ilic ti walac u ch'a'bül u yotzilil a mac u men a Tate'ex a que'en ti ca'ana,— cu t'an a Jesusu. ");
INSERT INTO mopNT_vpl VALUES ("LK6_37","072_6_37","LUK","6","37","37","—Pues te'i. Ma' a yaaltique'ex a cüxtic wa u cüxtaj u sip'il a maca. Ti baalo'o, ma' tu yaaltabül cüxtabül wa a cüxtaje'ex a sip'il inche'exe. Ma' a tz'eeque'ex a mac ichil u sip'ili. Ti baalo'o, ma' ta tz'abüle'ex ichil a sip'il. Sa'tese'ex u sip'il a maca. Ti baalo'o, bel u ca'a sa'tesabül a sip'ile'ex,— cu t'an a Jesusu. ");
INSERT INTO mopNT_vpl VALUES ("LK6_38","072_6_38","LUK","6","38","38","—Sije'ex c'u' a c'abeet ti'i ulaac'a. Ti baalo'o, bel u ca'a sijibil te'ex u men a Dioso. Le'ec ti bel u ca'a p'isbil c'u' a bel u ca'a sijibil te'exe, bel u ca'a but'bul ti chich ichil u p'isbeeb. Bel u ca'a tintinjütz'bül ti'i ca' ococ u chucaan. Tudel u ca'a asto ti tan u manül tu pach u men u yaabil. Baalo' ti bel u ca'a sijibil te'exe. Jabix ilic ti walaque'ex a p'isic c'u' a tane'ex a sijiqui, baalo' ilic ti bel u ca'a p'isbil c'u' a bel u ca'a sijibil te'exe,— cu t'an a Jesusu. ");
INSERT INTO mopNT_vpl VALUES ("LK6_39","072_6_39","LUK","6","39","39","Pues te'i. Uchi u t'an a Jesus eteloo' ich mucult'an yoc'ol mac a tan u yadic a ma' u yeel c'u'iji. —Jun tuul a ch'oopo, ma' tu paatal u bensic u yetch'oopil. Wa ca' u betoo' ti baalo', beloo' u ca'a ti c'axül ich ch'e'en tu ca' tuulil,— cu t'an a Jesusu. ");
INSERT INTO mopNT_vpl VALUES ("LK6_40","072_6_40","LUK","6","40","40","—Ma'ax mac aj cambal u yeel a mas yaab tuwich u maestro. C'u' betiqui, le'ec ti joboo' u ye'bel ti'i boon u yeel a maestrojo, jadi' quet u yeeloo' etel a maestrojo,— cu t'an a Jesusu. ");
INSERT INTO mopNT_vpl VALUES ("LK6_41","072_6_41","LUK","6","41","41","—¿C'u' ca'a tan a wilic u sip'il a hermano bete cuenta tan a wilic tz'etz'eec a ta'lu'um ichil u nec' u wichi? Uxtun incheche, ma' ta'ach a tz'eec ta wool ti nooch a sip'il incheche, bete cuenta jabix noxi' che' a que'en ichil u nec' a wich,— cu t'an a Jesus yoc'oloo' u sip'il. ");
INSERT INTO mopNT_vpl VALUES ("LK6_42","072_6_42","LUK","6","42","42","—Incheche, ma' ta'ach a wilic a jabix a noxi' che' a que'en ichil u nec' a wich,— cu t'an. —C'u' betiqui, baala' walac a wadic ti'i a hermanojo. “Hermano,” queech. “Cha'a in joc'sic abe' a jabix ta'lu'um a que'en ichil u nec' a wich,” queech ti'i. ¿C'u' ca'a ma' saaquech a wadü' a jabix abe' ti'iji?— cu t'an. —Incheche, chen aj cho'ech. Payanbej joq'ues abe' a jabix noxi' che' a que'en ichil u nec' a wich. Pachili, jede'ec a wilic ti qui' biqui ca' a joq'ues abe' a jabix ta'lu'um a que'en ichil u nec' u wich a hermanojo,— cu t'an a Jesus yoc'oloo' u sip'il. ");
INSERT INTO mopNT_vpl VALUES ("LK6_43","072_6_43","LUK","6","43","43","—Pues te'i. Le'ec a cristianojo, jabix ilic a che'e. Le'ec a che' a quich'pana, ma' tu tz'eec u wich ti c'as. Ma'ax a c'ac'as che'e, ma' tu tz'eec u wich a quich'pana,— cu t'an a Jesusu. ");
INSERT INTO mopNT_vpl VALUES ("LK6_44","072_6_44","LUK","6","44","44","—Etel u wich a che'e, chica'an biqui'il a che'e. Ma' tu wichintic a chimun a q'ui'ixi. Ma'ax tu wichinbil ix tz'us u men a q'ui'ix pocche'e,— cu t'an a Jesusu. ");
INSERT INTO mopNT_vpl VALUES ("LK6_45","072_6_45","LUK","6","45","45","—Le'ec a qui'il winiqui, walac u betic a qui' u men u qui'il u na'at. Le'ec a c'ac'as winiqui, walac u betic a c'as u men u c'asil u na'at. Chica'an biqui'il u na'at a mac etel u t'an,— cu t'an a Jesusu. ");
INSERT INTO mopNT_vpl VALUES ("LK6_46","072_6_46","LUK","6","46","46","—Pues te'i. “Noochil, Noochil,” que'ex ten. ¿C'u' ca'a walaque'ex a chiitiquen ti baalo', pero ma' ta'ache'ex a betic c'u' a walac in wadiqui?— cu t'an a Jesusu. ");
INSERT INTO mopNT_vpl VALUES ("LK6_47","072_6_47","LUK","6","47","47","—Tulacal a mac a walacoo' u c'ochol tin wetele, y a walacoo' u yubic in t'ana, y a walacoo' u betic c'u' a walac in wadiqui, ala'oo'o, ");
INSERT INTO mopNT_vpl VALUES ("LK6_48","072_6_48","LUK","6","48","48","jabix a mac a tan u men naj etel tunich. U paantaj ti tam tac yoc'ol jun p'eel tunich. Yoc'ol a tunich abe'e, caji u tzaamte a tunich ti'i u colocche'il a naja. Le'ec ti tuda'an a ja'a, cu'unquinbi a lu'um u men u yoc a ja'a. C'u' betiqui, ma' u pecsaj a naji, u men qui' betaja'an yoc'ol a tunichi,— cu t'an a Jesus ich mucult'an. ");
INSERT INTO mopNT_vpl VALUES ("LK6_49","072_6_49","LUK","6","49","49","—Uxtun mac a walacoo' u yubic in t'an pero ma' ta'achoo' u tz'ocsiqui. Ala'oo'o, jabix ilic a winic a tan u men naj etel tunich xan. C'u' betiqui, ma' u paantaj ma'ax tz'etz'eec tuba u cajsaj a naja. Jadi' yoc'ol lu'um u tz'aj a tunichi. Le'ec ti cu'unaji a lu'um u men u yoc a ja'a, c'axi a naj ti jomol. Jumpul c'asaji a naja,— cu t'an a Jesus ich mucult'an. ");
INSERT INTO mopNT_vpl VALUES ("LK7_1","072_7_1","LUK","7","1","1","Pues te'i. Le'ec ti jobi ti t'an a Jesus eteloo' a cristianojo, joq'ui te'i. Bini ich caj Capernaum. ");
INSERT INTO mopNT_vpl VALUES ("LK7_2","072_7_2","LUK","7","2","2","Que'en u noochiloo' a soldado te'i. Yan u yaj meyaj jun tuul, c'oja'an. Top c'abeet ti'i. Watac u quimil. ");
INSERT INTO mopNT_vpl VALUES ("LK7_3","072_7_3","LUK","7","3","3","Le'ec a soldado abe'e, u yubaj u pectzil a Jesusu. U tücaa'tajoo' a nucuch winic ti'i aj Israel ti'i ca' u püyü' a Jesusu. U c'ati ca' u c'aatoo' ti'i a Jesus ca' talac qui'cunbul u yaj meyaj. ");
INSERT INTO mopNT_vpl VALUES ("LK7_4","072_7_4","LUK","7","4","4","Le'ec ti c'ochoo' etel a Jesusu, u yadajoo' ti'i tulacaloo' u yool. —Qui' a waantic a soldado abe'e,— cu t'anoo' ti'i a Jesusu. ");
INSERT INTO mopNT_vpl VALUES ("LK7_5","072_7_5","LUK","7","5","5","—Qui' u yool a soldado abe' eteloo' ti wetcaal aj Israele. U betaj to'on a naj tuba walac ti much'tal ti c'ajes a Dioso,— cu t'anoo' ti'i a Jesusu. ");
INSERT INTO mopNT_vpl VALUES ("LK7_6","072_7_6","LUK","7","6","6","Pues te'i. Bini a Jesus tu pachoo'. Le'ec ti chema' c'ochoc a Jesus tu yotoch a soldado abe'e, cümbi u menoo' ulaac' u yaj xa'num a soldadojo. Le'ec ala'oo'o, u amigo a soldadojo. Baala' a tücaa'boo' u yadü' ti'i a Jesusu: —“Noochil, ma' in mas tuc'sic a wool. Ma' chucul in yanil ti'i ca' talaquech ichil in wotoch,” cu t'an a soldadojo,— cu t'anoo' ti'i a Jesusu. ");
INSERT INTO mopNT_vpl VALUES ("LK7_7","072_7_7","LUK","7","7","7","—“Ma'ax u naj xan ca' xiquen ta wetel. Jadi' adü ca' qui'ac in waj meyaj, y bel u ca'a ti ch'anül,” cu t'an a soldadojo,— cu t'anoo' ti'i a Jesusu. ");
INSERT INTO mopNT_vpl VALUES ("LK7_8","072_7_8","LUK","7","8","8","—“Yan ilic in noochil. Walac u tücaa'tiquen. Yanoo' ilic a soldado a walac in tücaa'tiqui. Walac in wadic ti'i a jun tuul ca' xi'ic, y walac u beel. Walac in wadic ti'i ulaac' ca' talac, y walac u talel. Walac in wadic ti'i in waj meyaj ca' u bete' a c'u'aca, y walac u betic abe'e,” cu t'an a soldadojo,— cu t'anoo' u amigo a soldado ti'i a Jesusu. ");
INSERT INTO mopNT_vpl VALUES ("LK7_9","072_7_9","LUK","7","9","9","Le'ec ti aalbi abe' ti'i a Jesusu, sa'ti u yool u men u t'an a soldado abe'e. U sutaj u bajil ti t'an eteloo' a cristiano a tücünacoo' tu pach. —Tan in wadic te'ex. Ca'ax boon tuul in wetcaal a que'enoo' u yool tin pacha, ma'ax tuba cuenta Israel in cüxtaj jun tuul ti wetcaal a top que'en u yool tin pach tu jajil jabix a soldado abe'e,— cu t'an a Jesus ti'ijoo' a cristianojo. ");
INSERT INTO mopNT_vpl VALUES ("LK7_10","072_7_10","LUK","7","10","10","Le'ec boon tuul a tücaa'boo' u men u noochil a soldadojo, u p'ütajoo' a Jesus ti bej. Usc'ajoo' tu yotoch a soldado abe' tucaye'il. U yilajoo' u yaj meyaj a soldado abe' te'i. Ch'ana'an tun. ");
INSERT INTO mopNT_vpl VALUES ("LK7_11","072_7_11","LUK","7","11","11","Pues te'i. Bini a Jesus ti jun p'eel a caj Nain u c'aba'. Tücünacoo' u yaj cambal tu pach. Yanoo' ilic ti yaab a cristiano tu pach ala'aji. ");
INSERT INTO mopNT_vpl VALUES ("LK7_12","072_7_12","LUK","7","12","12","Tanoo' to u c'ochol tu chi' a cot a que'en tu xoy a caj abe'e. Tan ilic u joc'sabül ich caj jun tuul a quimene. Le'ec u na' a quimene, ix ma'icham. Ma' yan ulaac' u yal. Jadi' a quimen abe'e. Yanoo' a cristiano a taloo' ich caj a tücünacoo' tu pach ix ma'icham abe'e. ");
INSERT INTO mopNT_vpl VALUES ("LK7_13","072_7_13","LUK","7","13","13","Le'ec ca' u yilaj ix ma'icham a Noochtzili, otzil tu wich. —Ma' a woc'ol,— cu t'an a Jesus ti'iji. ");
INSERT INTO mopNT_vpl VALUES ("LK7_14","072_7_14","LUK","7","14","14","Naatz'i a Jesus tu tzeel a quimene. U tülaj u cuuchil tuba tan u c'oochbol. Wa'lajoo' aj mucsaja. —Tan in wadic tech, tz'ub. Liq'uen,— cu t'an a Jesus ti'i a quimen ch'ajomo. ");
INSERT INTO mopNT_vpl VALUES ("LK7_15","072_7_15","LUK","7","15","15","Tinlaji a quimene. Caji ti t'an. Le'ec a Jesusu, u c'ubaj a ch'ajom ti'i u na'. ");
INSERT INTO mopNT_vpl VALUES ("LK7_16","072_7_16","LUK","7","16","16","Jac'oo' u yool tulacaloo'. Cajoo' u yadü' u qui'il a Dioso. —Chiclaji tiqui yaam jun tuul a top patal a walac u yadic u t'an a Dioso,— cu t'anoo'. —Ino'on aj Israelo'ono, ti'ijo'on Dios. U ch'a'aj ti wotzilil,— cu t'anoo' a que'enoo' te'iji. ");
INSERT INTO mopNT_vpl VALUES ("LK7_17","072_7_17","LUK","7","17","17","Tzicbalbi tulacal tuba cuenta Judea c'u' u betaj a Jesusu. Tzicbalbi ilic ca'ax tubajac ma' naach cuenta Judea. ");
INSERT INTO mopNT_vpl VALUES ("LK7_18","072_7_18","LUK","7","18","18","Pues te'i. Le'ecoo' u yaj cambal aj Juan aj tz'aj ocja'a, u tzolajoo' ti'i c'u' a walac u betic a Jesusu. ");
INSERT INTO mopNT_vpl VALUES ("LK7_19","072_7_19","LUK","7","19","19","Le'ec aj Juana, u püyajoo' ca' tuul u yaj cambal. —Ca' xique'ex a c'aate ti'i a Jesus wa le'ec aj Sa'alil ala'i a tan ti paac'tiqui, wa yan ti paac'tic ulaac',— cu t'an aj Juan ti'i a ca' tuulu. ");
INSERT INTO mopNT_vpl VALUES ("LK7_20","072_7_20","LUK","7","20","20","Le'ec ti c'ochoo' a ca' tuul etel a Jesusu, u yadajoo' u t'an aj Juan ti'iji. —Le'ec aj Juan aj tz'aj ocja'a, u tücaa'tajo'on ta wetel. ¿Inchech wa aj Sa'alil a tan ti paac'tiqui, wa yan ti paac'tic ulaac'?— cu t'an a ca' tuul ti'i a Jesusu. ");
INSERT INTO mopNT_vpl VALUES ("LK7_21","072_7_21","LUK","7","21","21","Ti'i ilic a hora abe' a Jesusu, u ch'anesajoo' ti yaab a c'oja'ana, ca'ax top yaj u c'oja'anil. U joc'sajoo' a c'ac'asba'al tu yooloo' a maca. U sasilcuntajoo' u wich a ch'oopo. ");
INSERT INTO mopNT_vpl VALUES ("LK7_22","072_7_22","LUK","7","22","22","Le'ec ti jobi u betic abe' a Jesusu, u nuuctajoo' u yaj cambal aj Juana. —Ca' usc'aque'ex etel aj Juan a wade'ex ti'i c'u' a wilaje'ex y c'u' a wu'yaje'exe,— cu t'an. —Tanoo' u sasilcunbul u wich a ch'oopo. Le'ecoo' a ch'etec u yoco, tanoo' u ximbal tucaye'il. Tanoo' u ch'anesabül a tan u tu'ujtal u büq'uel u men u c'oja'anili. Tanoo' u jeebbel u xiquin a cooco. Tanoo' u ca' cuxtal a quimene. Tan u yaalbül u qui'il pectzil a Dios ti'ijoo' a otzili,— cu t'an a Jesus ti'ijoo' a ca' tuulu. ");
INSERT INTO mopNT_vpl VALUES ("LK7_23","072_7_23","LUK","7","23","23","—Qui' u yool mac a ma' siq'ui u yool tene,— cu t'an a Jesus ti'ijoo' a ca' tuulu. ");
INSERT INTO mopNT_vpl VALUES ("LK7_24","072_7_24","LUK","7","24","24","Pues te'i. Le'ec ti usc'ajoo' tu pach u yaj xa'num aj Juana, caji a Jesus u tzicbalte aj Juan eteloo' a cristianojo. —¿C'u' a bine'ex a wila' ich p'atal lu'um? ¿Bine'ex wa a wila' a pocche' a tan u pecsabül u men ic'? Ma' bine'ex a wila' abe'e,— cu t'an a Jesusu. ");
INSERT INTO mopNT_vpl VALUES ("LK7_25","072_7_25","LUK","7","25","25","—¿C'u' a bine'ex a wila'? ¿Bine'ex wa a wila' a winic a top quich'pan u noc'o? Le'ecoo' a quich'pan u noc' a top qui' u cuxtaloo'o, que'enoo' ichil u yotoch a reye. Ma' ta wilique'exoo' ichil a p'atal lu'umi,— cu t'an a Jesus ti'ijoo' a cristianojo. ");
INSERT INTO mopNT_vpl VALUES ("LK7_26","072_7_26","LUK","7","26","26","—¿C'u' a bine'ex a wila'? ¿Bine'ex wa a wila' jun tuul a tan u yadic u t'an a Dioso? Le'ec, bine'ex a wila' jun tuul a tan u yadic u t'an a Dioso. Tan in wadic te'ex. Le'ec aj Juan abe'e, mas nooch u wichil u meyaj tuwich boon tuul u yadajoo' u t'an a Dios uchi,— cu t'an a Jesusu. ");
INSERT INTO mopNT_vpl VALUES ("LK7_27","072_7_27","LUK","7","27","27","—Bel in quin wadü' te'ex c'u' a tz'iiba'an yoc'ol ala'aji,— cu t'an a Jesusu. —“Inene, tan in tücaa'tic in waj xa'num ta taan. Bel u cu tojquinte a cristiano ti'i ca' u c'ümeechoo',” cu t'an a Dioso. Baalo' ti tz'iiba'an,— cu t'an a Jesusu. ");
INSERT INTO mopNT_vpl VALUES ("LK7_28","072_7_28","LUK","7","28","28","—Tan in wadic te'ex. Ma' yan a winic a yanaji yoc'olcab a mas nooch u wichil u meyaj tuwich aj Juan aj tz'aj ocja'a,— cu t'an a Jesusu. —C'u' betiqui, ca' yanacoo' a hermanojo, que'enoo' tu c'ü' a Dioso. Ca'ax ma' nooch u wichil u meyaj jun tuul a hermano tu yaamoo' u chucaan a hermanojo, mas nooch u wichil u meyaj xan tuwich aj Juana,— cu t'an a Jesusu. ");
INSERT INTO mopNT_vpl VALUES ("LK7_29","072_7_29","LUK","7","29","29","—Le'ecoo' a ca'ax macac u yet'ocoo' aj mol taq'uin ti'i a gobiernojo, le'ec ca' u yubajoo' u pectzil aj Juana, u c'ümajoo' a ocja'a. Ti baalo'o, u ye'ajoo' ti toj a tan u betic a Dioso,— cu t'an a Jesusu. ");
INSERT INTO mopNT_vpl VALUES ("LK7_30","072_7_30","LUK","7","30","30","—C'u' betiqui, a fariseo u c'aba'oo' u na'ata, u yet'ocoo' u yaj ca'ansajil u ley aj Moisese, ma' u c'ümajoo' a ocja' etel aj Juana. Ti baalo'o, ma' u c'ümajoo' c'u' u c'ati u bete' a Dios eteloo'o,— cu t'an. ");
INSERT INTO mopNT_vpl VALUES ("LK7_31","072_7_31","LUK","7","31","31","—¿C'u' a qui' ca' in wadü' te'ex ti'i ca' chiclac te'ex biqui'iloo' u na'at a cristiano a cuxa'anoo' to aleebe? ¿C'u' aj etel jede'ecoo' in quetiqui?— cu t'an a Jesusu. ");
INSERT INTO mopNT_vpl VALUES ("LK7_32","072_7_32","LUK","7","32","32","—Ala'oo'o, jabix ca' muuch' a tz'ub a tina'anoo' chumuc caj. Jun muuch'u, tanoo' u t'an ti chich etel ulaac' a jun muuch'u. “Ti wuustaj a xool jabix ich baxül tz'ocolbeele. C'u' betiqui, ma' a c'atiintaje'exe. Ma' uche'ex a woc'ot. Uchi ti woc'ol jabix ich baxül quimili. Ma'ax ti baalo'o, ma' a c'atiintaje'ex xan. Ma' uche'ex a woc'ol,” cu t'anoo' a jun muuch'u,— cu t'an a Jesusu. ");
INSERT INTO mopNT_vpl VALUES ("LK7_33","072_7_33","LUK","7","33","33","—Baalo' ilicoo' a cristiano aleebe. Le'ec ti caji ti meyaj aj Juan aj tz'aj ocja'a, ma' u jantaj a janala. Ma'ax u yuc'aj a vinojo. “Yan a c'ac'asba'al tu yool,” que'ex,— cu t'an a Jesusu. ");
INSERT INTO mopNT_vpl VALUES ("LK7_34","072_7_34","LUK","7","34","34","—Inene, yanajeen ti cristianojil. Walac in janal in wuc'ul,— cu t'an a Jesusu. —“Jac' ti'i a janala,” que'ex tin woc'ol. “Walac u caalül. Walac u yet'octicoo' aj mol taq'uin ti'i a gobierno u yet'ocoo' a mac a top yanoo' u sip'ili,” que'ex tin woc'ol,— cu t'an a Jesusu. ");
INSERT INTO mopNT_vpl VALUES ("LK7_35","072_7_35","LUK","7","35","35","—C'u' betiqui, etel c'u' a tanoo' u betic a tanoo' u tz'ocsic a Dioso, chica'an ti toj u na'at a Dioso,— cu t'an a Jesusu. ");
INSERT INTO mopNT_vpl VALUES ("LK7_36","072_7_36","LUK","7","36","36","Pues te'i. Chiitbi a Jesus u men jun tuul a fariseo u c'aba' u na'at ca' xi'ic ti janal etel. Oqui a Jesus ichil u yotoch ala'aji. U cüxtaj u cuuch pach mesa. ");
INSERT INTO mopNT_vpl VALUES ("LK7_37","072_7_37","LUK","7","37","37","Pues te'i. Ichil a caj abe'e, jun tuul tu yaamoo' ix ch'up a walacoo' u cüjtal etel a ca'ax macaca, u yubaj ti que'en a Jesus pach mesa ichil u yotoch a fariseo u c'aba' u na'ata. U talesaj a tz'i' p'uul tuda'an ti boc. Betabi a p'uul abe' etel a tunich u c'aba' alabastro. ");
INSERT INTO mopNT_vpl VALUES ("LK7_38","072_7_38","LUK","7","38","38","C'ochi tu tojil u yoc tuba que'en a Jesusu. Tan u yoc'ol ix ch'up abe'e. Caji ti t'aaj u c'a' u wich yoc'ol u yoc a Jesusu. U chowaj etel u tzo'otzel. U yutzintaj u yoc a Jesusu. U tz'aj a boc tuwich u yoc. ");
INSERT INTO mopNT_vpl VALUES ("LK7_39","072_7_39","LUK","7","39","39","Le'ec mac u chiitaj a Jesus ti janala, fariseo u c'aba' u na'at. Le'ec ca' u yilaj c'u' a tan u betabül ti'i a Jesusu, caji u tucle: —Wa cuchi tu jajil walac u yadic u t'an a Dios a Jesusu, u na'taj cuchi mac ix ch'upil tan u tülic u yoc. Yaab u sip'il ix ch'up ado'o,— cu t'an a winic abe' tu bajili. ");
INSERT INTO mopNT_vpl VALUES ("LK7_40","072_7_40","LUK","7","40","40","—Simon, yan c'u' a yan in wadic tech,— cu t'an a Jesus ti'i u yumil a naja. —Adü ten, maestro,— cu t'an aj Simon ti'i a Jesusu. ");
INSERT INTO mopNT_vpl VALUES ("LK7_41","072_7_41","LUK","7","41","41","—Jun tuul a winiqui, walac u tz'eec u taq'uin ti maanil. Ca' tuul a uchi u maan taq'uin etele. Jun tuulu, u maantaj quinientos dolar. Ulaac' a jun tuulu, u maantaj cincuenta dolar,— cu t'an a Jesus ich mucult'an ti'i a fariseojo. ");
INSERT INTO mopNT_vpl VALUES ("LK7_42","072_7_42","LUK","7","42","42","—Ma' pataloo' u bo'te u p'ax tu ca' tuulil. Le'ec a winiqui, u ch'a'ajoo' u yotzilil. U sijajoo' ti'i ti baalo'. ¿Mac tu yaam a ca' tuul aj maan taq'uin a bel u cu mas yacunte u yumil a taq'uin abe'e?— cu t'an a Jesus ti'i aj Simono. ");
INSERT INTO mopNT_vpl VALUES ("LK7_43","072_7_43","LUK","7","43","43","—Tin tuclic inene, le'ec a mas yaab u p'ax a sijibi ti'iji, le'ec a mas bel u cu yacunte a winiqui,— cu t'an aj Simono. —A nuuctajen ti toj,— cu t'an a Jesus ti'iji. ");
INSERT INTO mopNT_vpl VALUES ("LK7_44","072_7_44","LUK","7","44","44","Le'ec a Jesusu, u sutaj u bajil u cha'antaj ix ch'upu. —Ila ix ch'up ada'a,— cu t'an a Jesus ti'i aj Simono. —Le'ec ti oqueen ichil a wotocho, ma' a tz'aj ten a ja' ti'i in p'o'ical in woc jabix ti suco'on ti bete'. C'u' betiqui, ix ch'up ada'a, u ch'ulaj in woc etel u c'a' u wich. U cho'aj in woc etel u tzo'otzel,— cu t'an a Jesus ti'i aj Simono. ");
INSERT INTO mopNT_vpl VALUES ("LK7_45","072_7_45","LUK","7","45","45","—Ma' a wutzintajen jabix ti suco'on ti bete'. C'u' betiqui, uchucal in wudel wa'ye'e, tan ti tan u yutzintic in woc ix ch'up ada'a,— cu t'an a Jesusu. ");
INSERT INTO mopNT_vpl VALUES ("LK7_46","072_7_46","LUK","7","46","46","—Ma' a tz'aj a boc tin poli. C'u' betic ix ch'upu, u tz'aj a boc a top co'oj u tool yoc'ol in woc,— cu t'an a Jesus ti'i aj Simono. ");
INSERT INTO mopNT_vpl VALUES ("LK7_47","072_7_47","LUK","7","47","47","—Tan in wadic tech. Etel a c'u' u betaj tene, chica'an ti top yaj u yubeen ix ch'upu. U men top yaj u yubeene, chica'an ilic ti sa'tesabi ti'i u sip'il ca'ax yaab. C'u' betiqui, mac a ma' yaab u sip'ili, ma' ilic yaj u yubi ti yaab mac a uchi u sa'tesaj sip'ili,— cu t'an a Jesusu. ");
INSERT INTO mopNT_vpl VALUES ("LK7_48","072_7_48","LUK","7","48","48","—Sa'tesabi a sip'il,— cu t'an a Jesus ti'i ix ch'upu. ");
INSERT INTO mopNT_vpl VALUES ("LK7_49","072_7_49","LUK","7","49","49","Le'ecoo' u chucaan aj sutil a que'enoo' chi' mesa etel a Jesusu, cajoo' u tucle c'u' u yadaj a Jesusu. —¿C'u' u wich a winic ada'a? Walac ilic u sa'tesaj sip'il,— cu t'anoo' tu bajil. ");
INSERT INTO mopNT_vpl VALUES ("LK7_50","072_7_50","LUK","7","50","50","—A tz'ocsaj ti patalen in sa'alteech, mentücü, sa'ala'anech. Jetz'a'anac a wool. Ca' xiquech,— cu t'an a Jesus ti'i ix ch'upu. ");
INSERT INTO mopNT_vpl VALUES ("LK8_1","072_8_1","LUK","8","1","1","Pues te'i. Tan u manül a Jesus ich caj ich aldea. Tan u t'an te'i. U yadaj ti'ijoo' a qui'il t'an, le'ec biqui ti tan tun u tücaa' a Dioso. Le'ecoo' a doce tuul u yaj cambala, tücünacoo' tu pach a Jesusu. ");
INSERT INTO mopNT_vpl VALUES ("LK8_2","072_8_2","LUK","8","2","2","Tücünacoo' ilic ix ch'up tu pach a Jesusu. Le'ecoo' ix ch'up abe'e, le'ec a joc'saboo' a c'ac'asba'al ichiloo' u yool etel a ch'anesaboo' u c'oja'anili. Tu yaamoo' abe' que'en ix Maria. —Ix Magdalena,— cu t'anoo' ti'i. Joc'sabi siete tuul a c'ac'asba'al ichil u yool ala'aji. ");
INSERT INTO mopNT_vpl VALUES ("LK8_3","072_8_3","LUK","8","3","3","Tu yaamoo' ilic ix ch'up abe'e, yan jun tuulu, ix Juana u c'aba'. Le'ec u yicham ala'aji, aj Chuza u c'aba'. Walac u meyaj ichil u yotoch aj rey Herodes. Le'ec ulaac' ix ch'up a que'en pach a Jesusu, ix Susana u c'aba'. Yanoo' ilic ulaac'. Walacoo' u yaantic a Jesus etel c'u' a yanoo' ti'iji. ");
INSERT INTO mopNT_vpl VALUES ("LK8_4","072_8_4","LUK","8","4","4","Pues te'i. Much'lajoo' ti yaab a cristiano etel a Jesusu. Taloo' cajil caj. Caji ti t'an a Jesus ich mucult'an. ");
INSERT INTO mopNT_vpl VALUES ("LK8_5","072_8_5","LUK","8","5","5","—Jun tuul a winiqui, bini ti pac'. Le'ec ti tan u pac', yan a semilla a c'axi tuwich bej. Wa'che'bi a semilla abe'e. C'ochoo' a ch'iich'i. U jantajoo' a semilla abe'e,— cu t'an a Jesus ich mucult'an. ");
INSERT INTO mopNT_vpl VALUES ("LK8_6","072_8_6","LUK","8","6","6","—Yan a püc'bi tuba ma' pim a lu'umu. Yan a tunich yalama. Le'ec ti tan u ch'iili, tiqui u men ma' yan u ja'il,— cu t'an a Jesusu. ");
INSERT INTO mopNT_vpl VALUES ("LK8_7","072_8_7","LUK","8","7","7","—Yan a püc'bi tuba yan a jabix a c'ünchiimi. Le'ec ti tan u ch'iil a püc'aala, ch'iji ilic a jabix a c'ünchiimi. U c'ascuntaj a püc'aala,— cu t'an a Jesusu. ");
INSERT INTO mopNT_vpl VALUES ("LK8_8","072_8_8","LUK","8","8","8","—Yan a püc'bi ichil a lu'um a siisi. Qui' u ch'iil a püc'aal te'iji. U tz'aj u wich. U tz'aj cien sut mas yaab u wich tuwich boon semilla a püc'biji,— cu t'an a Jesusu. Le'ec ti jobi u yadic a mucult'an abe'e, uchi u t'an ti chich a Jesusu. —Le'ec mac patal u yubi in t'ana, yan u tz'eec tu yool,— cu t'an a Jesusu. ");
INSERT INTO mopNT_vpl VALUES ("LK8_9","072_8_9","LUK","8","9","9","Pues te'i. Le'ecoo' u yaj cambal a Jesusu, u c'aatajoo' ti'i c'u' a walac u yadic a mucult'an abe'e. ");
INSERT INTO mopNT_vpl VALUES ("LK8_10","072_8_10","LUK","8","10","10","—Tz'abi te'ex ca' a ch'a'e'ex u tojil yoc'ol biqui ti tan tun u tücaa' a Dioso. Le'ecoo' ulaac' a cristianojo, jadi' ich mucult'an tanoo' u yubic. Ti baalo'o, ca'ax tanoo' u cha'an, ma' tanoo' u yilic. Ca'ax tanoo' u yubic a t'ana, ma' tanoo' u ch'a'ic u tojil,— cu t'an a Jesus ti'ijoo' u yaj cambala. ");
INSERT INTO mopNT_vpl VALUES ("LK8_11","072_8_11","LUK","8","11","11","—Pues te'i. Le'ec ada' u nu'cul a mucult'an in wadaj to. Le'ec jabix a semillaja, le'ec abe'e, jabix u t'an a Dioso,— cu t'an a Jesusu. ");
INSERT INTO mopNT_vpl VALUES ("LK8_12","072_8_12","LUK","8","12","12","—Le'ec jabix a semilla a c'axi ti beje, le'ec abe'e, jabixoo' a cristiano a aalbi ti'ijoo' u t'an a Dioso. C'ochi a quisin eteloo'o. U tocaj ti'ijoo' u t'an a Dios u yubajoo' ti'i ma' u tz'ocsicoo' abe'e, ti'i ma' u sa'albüloo',— cu t'an a Jesusu. ");
INSERT INTO mopNT_vpl VALUES ("LK8_13","072_8_13","LUK","8","13","13","—Le'ec jabix a semilla a püc'bi tuwich a tunichi, le'ec abe'e, jabixoo' a cristiano a aalbi ti'ijoo' u t'an a Dioso,— cu t'an. —Qui'oo' u yool u yubi a t'an abe'e. U c'ümajoo'. C'u' betic ala'oo'o, jabix a püc'aal a ma' yan u can. Ma' ta'achoo' u muc'yaj. Jun p'e rato ilic tan u tz'ocsic. Le'ec ca' u c'ümoo' a yaja, walacoo' u p'ütic u tz'ocsic u t'an a Dioso,— cu t'an a Jesusu. ");
INSERT INTO mopNT_vpl VALUES ("LK8_14","072_8_14","LUK","8","14","14","—Le'ec jabix a semilla a püc'bi tuba yan a jabix a c'ünchiimi, le'ec abe'e, jabixoo' a cristiano a aalbi ti'ijoo' u t'an a Dioso,— cu t'an. —U c'ümajoo' a t'an abe'e. Pachili, top que'enoo' u yool tu pach a jabix a c'u' a ti'i a yoc'olcaba. Top que'enoo' u yool tu pach u ayic'alil. Top que'enoo' u yool tu pach a c'u' a qui'oo' tu wich u beticoo' yoc'olcab. U men abe'e, tan u joc'ol ti'ijoo' ti ma'ax c'u' ti qui'il a tan u yantal ti'ijoo'o,— cu t'an a Jesusu. ");
INSERT INTO mopNT_vpl VALUES ("LK8_15","072_8_15","LUK","8","15","15","—Le'ec jabix a semilla a püc'bi tuba siis a lu'umu, le'ec abe'e, jabixoo' a cristiano a aalbi ti'ijoo' u t'an a Dioso,— cu t'an. —U c'ümajoo' a t'an abe'e. Qui'oo' u na'at. Ma' ta'achoo' u p'ütic u tz'ocsic a t'an abe'e. Ma' ta'achoo' u tuc'ul u yool, mentücü, walac u yaabtal a qui'il u menoo',— cu t'an a Jesusu. ");
INSERT INTO mopNT_vpl VALUES ("LK8_16","072_8_16","LUK","8","16","16","—Pues te'i. Le'ec ca' u t'übaj a lamparaja, ma'ax mac walac u nocquintic a c'u'ac yoc'ol ti'i ma' u chictal u saqui. Ma'ax walac u tz'eec abe' yalam cama. Walac u tz'eec abe' tu cuuchil. Ti baalo'o, sasil u wich mac a oqui ich naj u men a lampara abe'e,— cu t'an a Jesus ich mucult'an yoc'ol ma' ti muquic c'u' a tan ti tz'ocsiqui. ");
INSERT INTO mopNT_vpl VALUES ("LK8_17","072_8_17","LUK","8","17","17","—Ma' yan a c'u' a muca'an a wa ma' tu chictala. Baalo' ilic a t'an a muca'ana, bel ilic u ca'a u'yajbül. Laj bel u ca'a eeltabül,— cu t'an a Jesusu. ");
INSERT INTO mopNT_vpl VALUES ("LK8_18","072_8_18","LUK","8","18","18","—U men laj bel u ca'a eeltabülü, tz'aje'ex ta wool c'u' a tane'ex a wu'yiqui. Le'ec mac u yeel a tz'etz'eeque, bel u ca'a tz'abül ti'i ca' u yeelte ti mas yaab. Le'ec mac a tan u tuclic ti u yeele, pero ma'ax c'u' u yeele, bel u ca'a tocbol ti'i c'u' a tan u tuclic ti u yeele,— cu t'an a Jesusu. ");
INSERT INTO mopNT_vpl VALUES ("LK8_19","072_8_19","LUK","8","19","19","Pues te'i. Le'ec u na' u yet'ocoo' u yitz'in a Jesusu, c'ochoo' ti sut etel. C'u' betiqui, ma' tu paataloo' u beel tu tzeel ala'i u men u yaabil a cristiano a much'a'anoo' te'iji. ");
INSERT INTO mopNT_vpl VALUES ("LK8_20","072_8_20","LUK","8","20","20","—Udi a na' u yet'ocoo' a witz'in. Wa'an ti que'enoo' pach naj. U c'atoo' sut ta wetel,— cu t'an u yaalbül a Jesusu. ");
INSERT INTO mopNT_vpl VALUES ("LK8_21","072_8_21","LUK","8","21","21","—Tulacal mac a walacoo' u yubic u t'an a Dioso, y walacoo' u betic c'u' a tanoo' u yubiqui, ala'oo'o, in na' in witz'inoo',— cu t'an a Jesus ti'ijoo' a cristianojo. ");
INSERT INTO mopNT_vpl VALUES ("LK8_22","072_8_22","LUK","8","22","22","Pues te'i. Jun p'eel q'uin oqui a Jesus ich barco u yet'ocoo' u yaj cambal. —Co'ne'ex tac junxeel a lagunaja,— cu t'an ti'ijoo'. Joc'oo' te'i. Cajoo' ti beel junxeel a ja'a. ");
INSERT INTO mopNT_vpl VALUES ("LK8_23","072_8_23","LUK","8","23","23","Le'ec ti tanoo' u beele, emi u wüyül a Jesusu. Caji a ic' ti chich ti'ijoo' tuwich a lagunaja. Caji ti tudel a barcojo. Sabeensil u budel. ");
INSERT INTO mopNT_vpl VALUES ("LK8_24","072_8_24","LUK","8","24","24","Binoo' u yajes a Jesusu. —Noochil, Noochil,— cu t'anoo' ti'i a Jesusu. —Tan u budel a barcojo,— cu t'anoo' ti'i. Liq'ui a Jesusu. U chichich chiitaj a ic' y a ja'a. Mani a chichil iq'ui. Jetz'laji a ja'a. Quich'pan ti p'aati. ");
INSERT INTO mopNT_vpl VALUES ("LK8_25","072_8_25","LUK","8","25","25","—¿C'u' ca'a ma' que'ene'ex a wool pach a Dios tu jajili?— cu t'an a Jesus ti'ijoo'o. Jac'oo' u yool. Sa'too' u yool u men c'u' a maniji. —¿C'u' u wich a winic ada'a? Ca'ax ic' ca'ax ja' walac u tz'ocsabül ala'aji. Walac u yuchul jabix ilic ti walac u yadiqui,— cu t'anoo' tu bajil. ");
INSERT INTO mopNT_vpl VALUES ("LK8_26","072_8_26","LUK","8","26","26","Pues te'i. C'ochoo' ich barco chi' ja' tuba que'enoo' a cristiano u c'aba' Gadareno. Junxeel a laguna abe'e, te'i que'en a cuenta Galileaja. ");
INSERT INTO mopNT_vpl VALUES ("LK8_27","072_8_27","LUK","8","27","27","Le'ec ti tan u joc'ol a Jesus ich barcojo, c'ümbi u men jun tuul winic. Te'i que'en u caal a winic abe'e. Yanoo' a c'ac'asba'al ichil u yool ala'aji. Uchi caac ti manül ti aj ma'noc'. Ma' ta'ach u cuntal ich naj. Walac u cuntal tuba walac u mucbul a quimene. ");
INSERT INTO mopNT_vpl VALUES ("LK8_28","072_8_28","LUK","8","28","28","Le'ec ca' u yilaj a Jesus a winic abe'e, uchi u yawat ti chich. Xonlaji tu taan a Jesusu. —Jesus, ma' c'u' a t'an teni. Inchech u Mejen a Dios ti ca'an a top nooch u yanili. Ca' a bete' ten jun p'eel qui'il. Ma' a tz'eec ten a yaja,— cu t'an a c'ac'asba'al a que'en ichil u yool a winic ti'i a Jesus ti chichi. ");
INSERT INTO mopNT_vpl VALUES ("LK8_29","072_8_29","LUK","8","29","29","U yadaj abe' u men aalbi ti'i u men a Jesus ca' joc'oc ichil u yool a winiqui. Biq'uin ado'o, yaab sut oqui a c'ac'asba'al ichil u yool a winiqui. Walac u c'üxbül a winic tu c'ü' tu yoc ti cadena u menoo' a cristianojo. C'u' betiqui, walac u t'upic a cadenaja. Walac u bensabül a winic abe' u men a c'ac'asba'al ichil a p'atal lu'umu. ");
INSERT INTO mopNT_vpl VALUES ("LK8_30","072_8_30","LUK","8","30","30","—¿Mac a c'aba' incheche?— cu t'an a Jesus ti'iji. —Jun muuch' in c'aba',— cu t'an ti'i. U yadaj abe' u men u yaabil a c'ac'asba'al a oca'an ichil u yool a winiqui. ");
INSERT INTO mopNT_vpl VALUES ("LK8_31","072_8_31","LUK","8","31","31","—Ca' a bete' to'on jun p'eel qui'il. Ma' a tücaa'tico'on ich c'asil,— cu t'anoo' a c'ac'asba'al ti'i a Jesusu. ");
INSERT INTO mopNT_vpl VALUES ("LK8_32","072_8_32","LUK","8","32","32","Pues te'i. Ma' naach te'i que'enoo' a pimil eq'uen a tanoo' u janal tuwich witz. Le'ecoo' a c'ac'asba'ala, u c'aatajoo' ti'i a Jesus ca' tücaa'bücoo' tu yaam a eq'uen abe'e. U cha'aj ca' xicoo' te'i. ");
INSERT INTO mopNT_vpl VALUES ("LK8_33","072_8_33","LUK","8","33","33","Joc'oo' a c'ac'asba'al ichil u yool a winiqui. Binoo' tu yaam a eq'uene. Joc'oo' ti alca' ti chich a eq'uene. Emoo' tuba c'üs toj wa'an a witzi. Ocoo' ichil a ja'a. Jüc'moo' te'i. Quimoo'. ");
INSERT INTO mopNT_vpl VALUES ("LK8_34","072_8_34","LUK","8","34","34","Pues te'i. Le'ecoo' aj cünün eq'uene, u yilajoo' c'u' a uchiji. Joc'oo' ti alca'. U yadajoo' ich caj ich aldea c'u' a uchi chi' a ja'a. ");
INSERT INTO mopNT_vpl VALUES ("LK8_35","072_8_35","LUK","8","35","35","C'ochoo' a cristiano u yila' c'u' a uchiji. C'ochoo' etel a Jesusu. U yilajoo' a winic a joc'oo' a c'ac'asba'al ichil u yoolo. Tina'an ti que'en ala'i taan a Jesusu. Yan tun u noc'. Tojaji u yool a winiqui. Jac'oo' u yool a cristianojo. ");
INSERT INTO mopNT_vpl VALUES ("LK8_36","072_8_36","LUK","8","36","36","Le'ecoo' aj cünün eq'uene, u yilajoo' c'u' a maniji. C'ochoo' ala'oo'o. U yadajoo' ti'i a cristiano biqui ti joc'saboo' a c'ac'asba'al ichil u yool a winiqui. ");
INSERT INTO mopNT_vpl VALUES ("LK8_37","072_8_37","LUK","8","37","37","Pachil abe'e, tulacaloo' a cristiano a taloo' cuenta Gadaraja, u yadajoo' ti'i a Jesus ca' joc'oc ala'i te'i. U yadajoo' abe' u men top saacoo' tu jajil. Ca' oqui a Jesus ich barcojo. Caji ti usc'al. ");
INSERT INTO mopNT_vpl VALUES ("LK8_38","072_8_38","LUK","8","38","38","Pues te'i. Le'ec a winic a joc'saboo' a c'ac'asba'al ichil u yoolo, u c'aataj ca' xi'ic tu pach a Jesusu. Le'ec a Jesusu, ma' u cha'aj ca' talac tu pach. ");
INSERT INTO mopNT_vpl VALUES ("LK8_39","072_8_39","LUK","8","39","39","—Ca' xiquech ta wotoch. Adü ti'ijoo' tulacal a cristiano c'u' u betaj tech a Dioso,— cu t'an a Jesus ti'iji. Bini a winiqui. Tulacal tuba ich caj u yadaj boon a qui' a betabi ti'i u men a Jesusu. ");
INSERT INTO mopNT_vpl VALUES ("LK8_40","072_8_40","LUK","8","40","40","Pues te'i. Le'ec a Jesusu, usc'aji tu pach junxeel a lagunaja. C'ümbi tu qui'il u menoo' a cristiano a much'a'anoo' te'iji. Laj que'enoo' te'i u paac'te u yudel. ");
INSERT INTO mopNT_vpl VALUES ("LK8_41","072_8_41","LUK","8","41","41","Pues te'i. Jun tuul a winiqui, aj Jairo u c'aba'. Aj tücaa' ichil a naj tuba walacoo' u much'tal aj Israel u c'ajes a Dios ichil a caj abe'e. C'ochi a winic abe' etel a Jesusu. Xonlaji tu taan. U c'aataj ti'i a Jesus wa ma' tu beel tu yotoch. ");
INSERT INTO mopNT_vpl VALUES ("LK8_42","072_8_42","LUK","8","42","42","Jun tuul ilic u mejen yan. Ix chu' abe'e. Doce jaab yan ti'i. Watac u quimil. Pues te'i. Le'ec a Jesusu, que'en to tu benil u yotoch a winiqui. Top tan u nüt'bül a Jesus u menoo' u yaabil a cristiano a tücünac tu pacha. ");
INSERT INTO mopNT_vpl VALUES ("LK8_43","072_8_43","LUK","8","43","43","Yanoo' ilic ix ch'up tu yaamoo'o. Jun tuulu, doce jaab tan ti tan u joc'ol u q'uiq'uel le'ec u uju. Jobi u sütic u taq'uin etel aj ilmaj. Ma'ax mac paataji u ch'anes. ");
INSERT INTO mopNT_vpl VALUES ("LK8_44","072_8_44","LUK","8","44","44","Naatz'i ala'i tu pach a Jesusu. U tülaj u chi' u noc' a Jesusu. Ch'ani. Ma' tan u ca' joc'ol u q'uiq'uel. ");
INSERT INTO mopNT_vpl VALUES ("LK8_45","072_8_45","LUK","8","45","45","—¿Mac u tülajen?— cu t'an a Jesusu. —Ma' ineni,— cu t'anoo' tulacaloo' a cristianojo. —Noochil, xooya'anech u men u yaabil a cristianojo. Laj tanoo' u nüt'iquech. ¿C'u' ca'a tan a c'aatic mac u tülajech?— cu t'an aj Pedro eteloo' u yet'oc ti'i a Jesusu. ");
INSERT INTO mopNT_vpl VALUES ("LK8_46","072_8_46","LUK","8","46","46","—Yan mac u tülajen. In weeltaj abe'e, le'ec ti joq'ui in muc' tz'etz'eecac ti'i u ch'aneeb,— cu t'an a Jesusu. ");
INSERT INTO mopNT_vpl VALUES ("LK8_47","072_8_47","LUK","8","47","47","Le'ec a nooch'upu, u na'taj ti ma' muca'an c'u' u betaja. Tzützülnac a nooch'upu. Xonlaji tu taan a Jesusu. Tu taan tulacaloo' a cristianojo, u yadaj ti'i c'u' ca'a u tülic u noc' ala'aji, y biqui ti ch'ani. ");
INSERT INTO mopNT_vpl VALUES ("LK8_48","072_8_48","LUK","8","48","48","—Nooch'up, a tz'ocsaj ti patalen in ch'aneseech, mentücü, ch'aneech tun. Jetz'a'anac a wool. U paatal a wusc'al,— cu t'an a Jesus ti'iji. ");
INSERT INTO mopNT_vpl VALUES ("LK8_49","072_8_49","LUK","8","49","49","Pues te'i. Tan to u t'an a Jesus etel a nooch'upu, ti c'ochi jun tuul aj xa'num a tali tu yotoch aj Jairojo. —Quimi tun a mejen. Ma' a mas tuc'sic u yool a maestrojo,— cu t'an ti'i aj Jairojo. ");
INSERT INTO mopNT_vpl VALUES ("LK8_50","072_8_50","LUK","8","50","50","Le'ec a Jesusu, u yubaj c'u' a aalbi ti'i aj Jairojo. —Ma' u jac'ül a wool. Tz'a a wool tin pach, y bel u ca'a ti ca' qui'tal,— cu t'an a Jesus ti'i aj Jairojo. ");
INSERT INTO mopNT_vpl VALUES ("LK8_51","072_8_51","LUK","8","51","51","Le'ec ti c'ochi tu yotoch ala'aji, ma' u cha'aj ma'ax mac ca' ococ etel. Jadi' aj Pedro, aj Jacob, aj Juan etel u na' u tat a tz'ubu, jadi' a ocoo' tu pacha. ");
INSERT INTO mopNT_vpl VALUES ("LK8_52","072_8_52","LUK","8","52","52","Tulacaloo' a que'en te'iji, tanoo' u yoc'ol. Naach u yawat u yoc'too' a quimene. —Ma' a woc'ole'ex. Ma' quimen ala'aji. Jadi' tan u wüyül,— cu t'an a Jesus ti'ijoo'o. ");
INSERT INTO mopNT_vpl VALUES ("LK8_53","072_8_53","LUK","8","53","53","U che'ejtajoo' a Jesusu. U yeeloo' ti quimen ix chu'u. ");
INSERT INTO mopNT_vpl VALUES ("LK8_54","072_8_54","LUK","8","54","54","Le'ec a Jesusu, u müchaj ix chu' tu c'ü'. —Liq'uen tz'ub,— cu t'an ti'i ti chich. ");
INSERT INTO mopNT_vpl VALUES ("LK8_55","072_8_55","LUK","8","55","55","Ca' cuxlaji ix chu'u. Liq'ui. Le'ec a Jesusu, u yadaj ca' tz'abüc u janal ix chu'u. ");
INSERT INTO mopNT_vpl VALUES ("LK8_56","072_8_56","LUK","8","56","56","Sa'too' u yool u na' u tat ix chu'u. —Ma' a wadique'ex ti'i ma'ax mac c'u' a mani wa'ye'e,— cu t'an a Jesus ti'ijoo'o. ");
INSERT INTO mopNT_vpl VALUES ("LK9_1","072_9_1","LUK","9","1","1","Pues te'i. Le'ec a Jesusu, u püyajoo' u yaj cambal a doce tuul tu tzeele. U tz'aj ti'ijoo' u patalil ti'i ca' u joq'uesoo' a c'ac'asba'al ichil u yool a maca, y ti'i u ch'anesicoo' a c'oja'ana. ");
INSERT INTO mopNT_vpl VALUES ("LK9_2","072_9_2","LUK","9","2","2","Bel u cu tücaa'too' ca' xicoo' u yadü' ti'ijoo' a cristiano biqui ti tan tun u tücaa' a Dioso. Beloo' ilic u ca'a u ch'anesoo' a c'oja'ana. ");
INSERT INTO mopNT_vpl VALUES ("LK9_3","072_9_3","LUK","9","3","3","—Ma' a bensique'ex a ma'ax c'u'i ti tane'ex a beele. Ma' a bensique'ex a xoolte'e, ma'ax a salbeque. Ma' a bensique'ex a janala, ma'ax a taq'uini. Ma'ax a bensique'ex ulaac' a noc',— cu t'an a Jesusu. ");
INSERT INTO mopNT_vpl VALUES ("LK9_4","072_9_4","LUK","9","4","4","—Le'ec tuba ca' ocoque'ex ti posado, te'i yane'ex a jedel. Le'ec ti tane'ex a joc'ol ichil a caja, ichil ilic a naj abe' a joc'ole'ex,— cu t'an a Jesus ti'ijoo'o. ");
INSERT INTO mopNT_vpl VALUES ("LK9_5","072_9_5","LUK","9","5","5","—Tuba ma' a c'ate'ex c'ümbülü, le'ec ti tane'ex a joc'ol te'i, liijte'ex u ta'lu'umil a woc ca' c'axüc. Le'ec abe' u p'is ti ma' qui' u betajoo' te'exe,— cu t'an a Jesusu. ");
INSERT INTO mopNT_vpl VALUES ("LK9_6","072_9_6","LUK","9","6","6","Joc'oo' te'i u yaj cambal a Jesusu. Binoo' ichil a caj tulacal tuba. U yadajoo' u pectzil a Dios te'iji. U ch'anesajoo' a c'oja'ana. ");
INSERT INTO mopNT_vpl VALUES ("LK9_7","072_9_7","LUK","9","7","7","Pues te'i. Le'ec aj Herodese, que'en ti gobernadoril cuenta Galilea. U yubaj tulacal a c'u' a tan u betabül tu cuenta ala'i u men a Jesusu. Sa'ti u yool ala'i u men yan a tanoo' u yadic ti ca' cuxlaji aj Juan aj tz'aj ocja'a. ");
INSERT INTO mopNT_vpl VALUES ("LK9_8","072_9_8","LUK","9","8","8","Yanoo' ulaac' a tanoo' u yadic ti chiclaji aj Eliasa, le'ec jun tuul u yadaj u t'an a Dios uchi. Yanoo' ulaac' a tanoo' u yadic ti ca' cuxlaji jun tuul a uchben winic u yadaj u t'an a Dios uchi. ");
INSERT INTO mopNT_vpl VALUES ("LK9_9","072_9_9","LUK","9","9","9","—Inen in tücaa'taj ca' ch'ücbüc u cal aj Juan biq'uin ado'o. ¿Mac winiquil abe' a tan u betic a top yaab a tan in wu'yiqui?— cu t'an aj Herodese. U c'atiintaj cuchi u yila' a Jesusu. ");
INSERT INTO mopNT_vpl VALUES ("LK9_10","072_9_10","LUK","9","10","10","Pues te'i. Le'ec ti jobi u beticoo' u xa'numbeeb u yaj cambal a Jesusu, ca' much'lajoo' etel. U yadajoo' ti'i a Jesus tulacal a c'u' u betajoo'o. Bensaboo' u men a Jesus ich tz'i' caj Betsaida u c'aba'. ");
INSERT INTO mopNT_vpl VALUES ("LK9_11","072_9_11","LUK","9","11","11","Le'ecoo' u yaabil a cristianojo, u yubajoo' tuba bini a Jesusu. C'ochoo' u cüxte. C'ümboo' tu qui'il u men a Jesusu. Aalbi ti'ijoo' biqui ti tan tun u tücaa' a Dios u men a Jesusu. Ch'anesaboo' boon tuul a c'oja'an tu yaamoo'o. ");
INSERT INTO mopNT_vpl VALUES ("LK9_12","072_9_12","LUK","9","12","12","Pues te'i. Watac u yocol a q'uini. Naatz'oo' etel a Jesus a doce tuul u yaj cambala. —Adü ti'ijoo' a cristiano ca' xi'icoo' u cüxtoo' u posado eteloo' u janal ichil tulacal a aldea a nütz'a'an wa'ye'e. Que'eno'on ich p'atal lu'um. Ma'ax c'u' a yan wa'ye'e,— cu t'anoo' u yaj cambal ti'i a Jesusu. ");
INSERT INTO mopNT_vpl VALUES ("LK9_13","072_9_13","LUK","9","13","13","—Inche'ex ca' a tz'a'e'exoo' u janal,— cu t'an a Jesusu. —Jadi' cinco cuul pan etel ca' tuul aj ch'ilam a yan to'ono. Ma' yan ulaac'. ¿A c'ati wa ca' xico'on ti q'uex janal ti'ijoo' tulacaloo' a cristiano ado'o?— cu t'anoo' ti'i a Jesusu. ");
INSERT INTO mopNT_vpl VALUES ("LK9_14","072_9_14","LUK","9","14","14","Yan wal cinco mil tuul ti winic te'i. —Ade'ex ti'ijoo' a cristiano ca' tinlacoo' ich jujun muuch'oo'. Jabix wal cincuenta tuul ichil a jujun muuch'u,— cu t'an a Jesus ti'ijoo' u yaj cambala. ");
INSERT INTO mopNT_vpl VALUES ("LK9_15","072_9_15","LUK","9","15","15","U yadajoo' ti'i a cristiano ti baalo'. Laj tinlajoo'. ");
INSERT INTO mopNT_vpl VALUES ("LK9_16","072_9_16","LUK","9","16","16","Le'ec a Jesusu, u müchaj a cinco cuul a pan etel a ca' tuul aj ch'ilama. U cha'antaj a ca'ana. U c'ajsaj a Dios yoc'ol a janala. U meen xet'aj a pan etel aj ch'ilama. U tz'aj ti'ijoo' u yaj cambal ca' u t'oxoo' ti'ijoo' a cristianojo. ");
INSERT INTO mopNT_vpl VALUES ("LK9_17","072_9_17","LUK","9","17","17","Laj janoo'. Na'ajnoo'. Le'ecoo' u yaj cambala, u tudesajoo' doce cuul a nucuch xac etel u yada' a janala. ");
INSERT INTO mopNT_vpl VALUES ("LK9_18","072_9_18","LUK","9","18","18","Pues te'i. Jun p'eel q'uin tu junaloo' que'en a Jesus u yet'ocoo' u yaj cambal. Tan u t'an a Jesus etel a Dioso. —¿Mac winiquilen ti walacoo' u yadic a cristiano tin woc'ol?— cu t'an a Jesus ti'ijoo' u yaj cambala. ");
INSERT INTO mopNT_vpl VALUES ("LK9_19","072_9_19","LUK","9","19","19","—Yan a walacoo' u yadic ti le'ec inchech aj Juan aj tz'aj ocja'a,— cu t'anoo'. —Yanoo' ulaac' a walacoo' u yadic ti le'ec inchech aj Eliasa. Ulaac' tucaye' walacoo' u yadic ti le'ec incheche, jun tuul a uchben winic a ca' cuxlaji a walac u yadic u t'an a Dios uchi,— cu t'anoo' ti'i a Jesusu. ");
INSERT INTO mopNT_vpl VALUES ("LK9_20","072_9_20","LUK","9","20","20","—Uxtun inche'exe, ¿mac winiquilen ti walaque'ex a wadic?— cu t'an a Jesus ti'ijoo'o. —Incheche, Cristojech, u yaj Sa'alilech a cristiano a tücaa'beech u men a Dioso,— cu t'an aj Pedro ti'iji. ");
INSERT INTO mopNT_vpl VALUES ("LK9_21","072_9_21","LUK","9","21","21","—Ma' a wadique'ex abe' ti'i ma'ax mac,— cu t'an a Jesus ti'ijoo' tu jajil. ");
INSERT INTO mopNT_vpl VALUES ("LK9_22","072_9_22","LUK","9","22","22","—Pues te'i. Inene, yanajeen ti cristianojil. Yan in c'ümic ti yaab a yaja,— cu t'an ti'ijoo' u yaj cambal. —Bel in ca'a culpachbül u menoo' ti wetcaal a walacoo' u tücaa'. Bel ilic u ca'a u culpachteen u noochiloo' u yaj mansaj t'an a cristiano ti'i a Dioso. Baalo' ilic beloo' u cu bete' ten boon tuul u yaj ca'ansajil u ley aj Moisese. Yan in quimsabül. Yan ilic in ca' cuxtal tucaye'il ti'i u yox p'e q'uin,— cu t'an a Jesus ti'ijoo' u yaj cambala. ");
INSERT INTO mopNT_vpl VALUES ("LK9_23","072_9_23","LUK","9","23","23","Pues te'i. Uchi u t'an a Jesus etel tulacaloo' a cristianojo. —Wa yan mac u c'ati u c'ümeen ti'i u noochili, yan u p'ütic u betic c'u' a qui' tu wich u betic wa'ye' yoc'olcab. Sansamal yan u muc'yajtic boon a yaj a tan u tz'abül ti'i u men tan u tz'ocsiquen. Ti baalo'o, tan u betic jabix a mac a tan u bensic u cruz ti'i ca' quimsabüc tuwich. Le'ec a jabix abe' a qui' ca' talac tin pacha,— cu t'an a Jesusu. ");
INSERT INTO mopNT_vpl VALUES ("LK9_24","072_9_24","LUK","9","24","24","—Le'ec mac u c'ati u sa'alte u cuxtal wa'ye'e, sa'tül u ca'a u cuxtal ti ca'an. Uchac u sa'tül u cuxtal a mac yoc'olcab u men que'en u yool tin pach, bel u cu sa'alte u cuxtal ti ca'an,— cu t'an a Jesusu. ");
INSERT INTO mopNT_vpl VALUES ("LK9_25","072_9_25","LUK","9","25","25","—¿C'u' aj beel ti'i a mac ca'ax u naalte cuchi tulacal a yoc'olcab y ca' quimic ti ma' c'üma'an u men Dios?— cu t'an a Jesusu. ");
INSERT INTO mopNT_vpl VALUES ("LK9_26","072_9_26","LUK","9","26","26","—Wa yan mac a sudac tene, wa xan sudac ti'i in t'an, baalo' ilic le'ec ti ca' uduquen tucaye'ili, sudaquen ilic ti'i. Inene, yanajeen ti cristianojil. Ca' wataquen etel in muc' y etel u muc' a Tattzili, y etel u muc' u yaj xa'num a Dios ti ca'ana. ");
INSERT INTO mopNT_vpl VALUES ("LK9_27","072_9_27","LUK","9","27","27","Tan in wadic te'ex u jajil. Yan mac ta yaame'ex a ma' tu quimiloo' asto u yilicoo' biqui ti walac u tücaa' a Dioso,— cu t'an a Jesusu. ");
INSERT INTO mopNT_vpl VALUES ("LK9_28","072_9_28","LUK","9","28","28","Pues te'i. Jabix wal ocho q'uin manüc a t'an abe' u yadaj a Jesusu, naq'ui tuwich witz ti t'an etel a Tattzili. U bensaj aj Pedro, aj Juan y aj Jacob tu pacha. ");
INSERT INTO mopNT_vpl VALUES ("LK9_29","072_9_29","LUK","9","29","29","Le'ec ti tan u t'an a Jesus etel a Tattzili, jeeli u cha'an. Naach u sac u noc' tu jajil. ");
INSERT INTO mopNT_vpl VALUES ("LK9_30","072_9_30","LUK","9","30","30","Te'i chiclaji ca' tuul a winiqui, aj Moises etel aj Eliasa. Tanoo' u tzicbal etel a Jesusu. ");
INSERT INTO mopNT_vpl VALUES ("LK9_31","072_9_31","LUK","9","31","31","Naachoo' ilic u sac a ca' tuulu. Tanoo' u tzicbaltic u pectzil u quimeeb a Jesusu. Uchul u ca'a abe' ich caj Jerusalen. ");
INSERT INTO mopNT_vpl VALUES ("LK9_32","072_9_32","LUK","9","32","32","Pues te'i. Ca'ax top tan cuchi u yemel u wüyül aj Pedro eteloo' u yet'oc a ca' tuulu, ma' wiinoo'i. U yilajoo' u sac a Jesusu. U yilajoo' a ca' tuul a wa'an ti que'enoo' tzeel a Jesusu. ");
INSERT INTO mopNT_vpl VALUES ("LK9_33","072_9_33","LUK","9","33","33","Le'ec ti cajoo' ti joc'ol a ca' tuul tu tzeel a Jesusu, uchi u t'an aj Pedrojo. —Maestro, qui' ti que'eno'on wa'ye'. ¿Ma' wa qui' ca' ti bete' ox cuul a tz'i' naj ti'i bo'oy? Jun cuulu, tech. Jun cuul ti'i aj Moises, y jun cuul ti'i aj Eliasa,— cu t'an aj Pedrojo. Chen u jan adaj abe'e. Ma' u yeel u tojil c'u' u yadaja. ");
INSERT INTO mopNT_vpl VALUES ("LK9_34","072_9_34","LUK","9","34","34","Le'ec ti tan to u yadic abe' aj Pedrojo, emi a muyal yoc'oloo'o. Laj que'enoo' ich muyal. Saacajoo' u yaj cambal a Jesus ti tan u yemel a muyal yoc'oloo'o. ");
INSERT INTO mopNT_vpl VALUES ("LK9_35","072_9_35","LUK","9","35","35","U yubajoo' a t'an ichil a muyala. —Le'ec ada'a, in Mejen. Yaj in wu'yi. U'ye'ex u t'an,— cu t'an a t'an ichil a muyala. ");
INSERT INTO mopNT_vpl VALUES ("LK9_36","072_9_36","LUK","9","36","36","Le'ec ti uchi a t'an abe'e, u yilajoo' a Jesusu. Tu junal que'en. Ma' u yadajoo' ti'i ma'ax mac c'u' u yilajoo'o, asto ti bini a Jesus ti ca'ana. ");
INSERT INTO mopNT_vpl VALUES ("LK9_37","072_9_37","LUK","9","37","37","Pues te'i. Tu samalil to emoo' tuwich witz. C'ümbi u menoo' u yaabil a cristianojo. ");
INSERT INTO mopNT_vpl VALUES ("LK9_38","072_9_38","LUK","9","38","38","Jun tuul winic a que'en tu yaamoo' a cristiano a much'a'anoo' te'iji, u c'aataj ti'i a Jesusu. —Maestro, bete ten jun p'eel qui'il. Ch'a'a u yotzilil in mejen. Jadi' ada' in mejene. Ma' yan ulaac',— cu t'an a winic abe' ti chich ti'i a Jesusu. ");
INSERT INTO mopNT_vpl VALUES ("LK9_39","072_9_39","LUK","9","39","39","—Yan q'uin ti walac u yoc'ol a c'ac'asba'al ichil u yoolo. Walac u yawat. Walac u tz'eec a sücquimil ti'iji. Walac u yoom u chi'. Walac u yajcuntic in mejen. C'üs ma' ta'ach u p'ütic in mejen,— cu t'an a winiqui. ");
INSERT INTO mopNT_vpl VALUES ("LK9_40","072_9_40","LUK","9","40","40","—In c'aataj ti'ijoo' a waj cambal ca' u joq'uesoo' a c'ac'asba'al a que'en ichil u yoolo. C'u' betiqui, ma' pataloo',— cu t'an ti'i a Jesusu. ");
INSERT INTO mopNT_vpl VALUES ("LK9_41","072_9_41","LUK","9","41","41","—Top ma' que'ene'ex a wool tu jajil tu pach a Dioso. Top que'en to a woole'ex tu pach a uchbene,— cu t'an a Jesus ti'ijoo' u yaj cambala. —¿Boon q'uin to yan in cuntal ta yaame'ex y muc'yajte'ex?— cu t'an a Jesus ti'ijoo'o. —Tales a mejen,— cu t'an a Jesus ti'i a winiqui. ");
INSERT INTO mopNT_vpl VALUES ("LK9_42","072_9_42","LUK","9","42","42","Tanil u naatz'ül u mejen a winiqui, c'atsabi u men a c'ac'asba'ala. Caji ti süquimil. Le'ec a Jesusu, u chichich chiitaj a c'ac'asba'ala. U ch'anesaj a tz'ubu. U c'ubaj ti'i u tat tucaye'il. ");
INSERT INTO mopNT_vpl VALUES ("LK9_43","072_9_43","LUK","9","43","43","Sa'too' u yool tulacaloo' a cristiano ca' u yilajoo' u patalil a Dioso. Pues te'i. Le'ecoo' a cristiano abe'e, tanoo' to u tuclic tulacal a c'u' u betaj a Jesus ti uchi u t'an eteloo' u yaj cambal. ");
INSERT INTO mopNT_vpl VALUES ("LK9_44","072_9_44","LUK","9","44","44","—Tz'a ta woole'ex c'u' a bel in quin wadü' te'exe. Inene, yanajeen ti cristianojil. Bel in ca'a c'ubbul tu c'ü'oo' a cristianojo,— cu t'an a Jesus ti'ijoo' u yaj cambala. ");
INSERT INTO mopNT_vpl VALUES ("LK9_45","072_9_45","LUK","9","45","45","Ma' u ch'a'ajoo' u tojil u t'an. Muca'an u nu'cul a t'an abe' ti'ijoo'o, mentücü, ma' pataloo' u ch'a' u tojil. Saacoo' u yaj cambal u c'aate ti'i a Jesus c'u' u nu'cul a t'an abe'e. ");
INSERT INTO mopNT_vpl VALUES ("LK9_46","072_9_46","LUK","9","46","46","Pues te'i. Le'ecoo' u yaj cambal a Jesusu, tanoo' u p'ujsic u bajil etel t'an yoc'ol mac a mas nooch u wichil u meyaj tu yaamoo'o. ");
INSERT INTO mopNT_vpl VALUES ("LK9_47","072_9_47","LUK","9","47","47","Le'ec a Jesusu, u yeel c'u' a tanoo' u tucliqui. U püyaj jun tuul a tz'ubu. U tz'aj tu tzeel. ");
INSERT INTO mopNT_vpl VALUES ("LK9_48","072_9_48","LUK","9","48","48","—Le'ec mac ca' u yaante a jabix tz'ub ada' a tan u tz'ocsiquen chen u men tan u tz'ocsiquene, tan ilic u yaantiquen. Tanil u yaantiquene, tan ilic u yaantic mac u tücaa'tajen. Ti baalo'o, le'ec mac ta yaame'ex a tan u betic jabix ma'ax c'u' u yeele, le'ec, aj ch'a'bej ta yaame'ex,— cu t'an a Jesus ti'ijoo' u yaj cambala. ");
INSERT INTO mopNT_vpl VALUES ("LK9_49","072_9_49","LUK","9","49","49","Pues te'i. Uchi u nuuc aj Juana. —Noochil, biq'uin ado'o, jun tuul a winiqui, etel ilic a c'aba' walac u joc'sic a c'ac'asba'al ichil u yool a maca. Ti wilaj abe'e. Ma' tücünac ala'i ta pach tiqui wetel, mentücü, ti wadaj ti'i ti ma' u betic ti baalo',— cu t'an aj Juan ti'i a Jesusu. ");
INSERT INTO mopNT_vpl VALUES ("LK9_50","072_9_50","LUK","9","50","50","—Ma' a wet'ique'ex u betic abe'e. Le'ec mac a ma' tz'iic ta wetele'exe, ala'aji, qui' u yool ta wetele'ex,— cu t'an a Jesusu. ");
INSERT INTO mopNT_vpl VALUES ("LK9_51","072_9_51","LUK","9","51","51","Pues te'i. Le'ec ti tan u naatz'ül u q'uinil u beel a Jesus ti ca'ana, u tz'aj u yool ti beel ich caj Jerusalen. ");
INSERT INTO mopNT_vpl VALUES ("LK9_52","072_9_52","LUK","9","52","52","U tücaa'tajoo' u yaj xa'num ca' xi'ic taanil ich jun p'eel tz'i' caj. Que'en tu cuenta Samaria a caj abe'e. U c'atiintajoo' u paye' cüxte u posado a Jesusu. ");
INSERT INTO mopNT_vpl VALUES ("LK9_53","072_9_53","LUK","9","53","53","C'u' betiqui, ma' u c'atiintaj tz'abül a posado ti'i a Jesus u men tan u beel ich caj Jerusalen. ");
INSERT INTO mopNT_vpl VALUES ("LK9_54","072_9_54","LUK","9","54","54","Le'ec aj Jacob etel aj Juana, u yeeltaj c'u' a maniji. —Noochil, ¿ma' wa qui' ca' ti c'aate ca' c'axüc a c'aac' ti ca'an ca' quimsabücoo' jabix ilic u betaj aj Elias uchiji? Ala'aji, jun tuul u yadaj u t'an a Dios uchi,— cu t'anoo' ti'i a Jesusu. ");
INSERT INTO mopNT_vpl VALUES ("LK9_55","072_9_55","LUK","9","55","55","A Jesusu, u sutaj u bajil u tojquintoo'. —Ma' a weele'ex biqui'il u tucul u Püsüc'al a Dios a que'en ta wetele'exe,— cu t'an ti'ijoo'. ");
INSERT INTO mopNT_vpl VALUES ("LK9_56","072_9_56","LUK","9","56","56","—Inene, yanajeen ti cristianojil. Ma' taleen ti'i in quimesoo' a cristianoji. Taleen ti'i in sa'alticaloo',— cu t'an ti'ijoo'. Joc'oo' te'i. Binoo' ich ulaac' caj. ");
INSERT INTO mopNT_vpl VALUES ("LK9_57","072_9_57","LUK","9","57","57","Pues te'i. Le'ec ti tanoo' u beele, baala' u yadaj jun tuul a winiqui. —Le'ec a tuba ca' xiqueche, bel in ca'a ta pach,— cu t'an ti'i a Jesusu. ");
INSERT INTO mopNT_vpl VALUES ("LK9_58","072_9_58","LUK","9","58","58","—Le'ec a ch'umaca, yan u cuuchil ich tunich. Le'ec a ch'iich'i, yan u c'u'. C'u' betiqui, inen a yanajeen ti cristianojili, ma' yan in cuuchil. Ma' yan ma'ax tuba u paatal in coytal ti jedel,— cu t'an a Jesus ti'iji. ");
INSERT INTO mopNT_vpl VALUES ("LK9_59","072_9_59","LUK","9","59","59","—Co'ox tin pach,— cu t'an a Jesus ti'i ulaac' a winiqui. —Noochil, se' cha'a in beel tin wotoch. Quimic to in tata, ca' talaquen ta pach,— cu t'an a winic ti'i a Jesusu. ");
INSERT INTO mopNT_vpl VALUES ("LK9_60","072_9_60","LUK","9","60","60","—Le'ec a ma' ta'achoo' u c'ajsic a Dioso, jabix quimenoo' ti'i a Dioso. Mas toj ca' culacoo' ala'oo' u mucoo' a quimene,— cu t'an a Jesus ti'iji. —Incheche, ca' xiquech a wadü' u pectzil a Dios ti'ijoo' a cristianojo,— cu t'an a Jesusu. ");
INSERT INTO mopNT_vpl VALUES ("LK9_61","072_9_61","LUK","9","61","61","Baalo' u yadaj ulaac' a jun tuulu. —Noochil, bel in ca'a ta pach, pero se' cha'a in beel in wadü' a se' beel ti'ijoo' in familiaja,— cu t'an ulaac' a jun tuul ti'i a Jesusu. ");
INSERT INTO mopNT_vpl VALUES ("LK9_62","072_9_62","LUK","9","62","62","—Le'ec a caji ti meyaj a tan ti tan u cha'an tu pacha, chen tan u c'atiintic a uchben u p'ütaja. Ala'aji, ma'ax c'u' aj beel ti'i a Dioso,— cu t'an a Jesus ti'i a winic abe'e. ");
INSERT INTO mopNT_vpl VALUES ("LK10_1","072_10_1","LUK","10","1","1","Pues te'i. Tz'abi u yanil a setenta tuul ulaac' u men a Jesusu. Bel u cu tücaa'too' taanil ichil tulacal a caj a aldea tuba c'ochol u ca'a a Jesusu. Ca'ca' tuul ti beloo' u ca'a ala'oo'o. ");
INSERT INTO mopNT_vpl VALUES ("LK10_2","072_10_2","LUK","10","2","2","—Top nooch a colo, pero top ma' yanoo' aj meyaja. C'aate'ex ti'i u yumil a col ca' u tücaa'te ti mas yaab u yaj meyaj ca' xi'icoo' ti joch,— cu t'an a Jesus ich mucult'an yoc'ol u tücaa'bül ti mas yaab mac ca' u yadoo' u pectzil a Dioso. ");
INSERT INTO mopNT_vpl VALUES ("LK10_3","072_10_3","LUK","10","3","3","—Bele'ex a ca'a, pero se' u'ye'ex in t'an. Inche'exe, jabixe'ex a carnerojo. Tan in tücaa'tique'ex tu yaamoo' a jabix baalumu,— cu t'an a Jesusu. ");
INSERT INTO mopNT_vpl VALUES ("LK10_4","072_10_4","LUK","10","4","4","—Ma' a bensique'ex a taq'uin ma'ax u cuuchil a taq'uini, ma'ax a cayte. Le'ec ti que'ene'ex ti bej, xene'ex jun tatz. Ma' a wa'tale'ex a chiite a ma'ax maca,— cu t'an a Jesusu. ");
INSERT INTO mopNT_vpl VALUES ("LK10_5","072_10_5","LUK","10","5","5","—Le'ec ca' ocoque'ex ichil a naja, payanbej qui'qui't'ante'ex. “Jetz'a'anaque'ex a wool wa'ye',” que'exac ti'ijoo' a que'en te'iji,— cu t'an a Jesusu. ");
INSERT INTO mopNT_vpl VALUES ("LK10_6","072_10_6","LUK","10","6","6","—Wa yan mac te'i a qui' tu wich a jetz'a'an-oolili, tz'abül u ca'a ti'ijoo' a jabix ilic a c'aataj yoc'oloo'. Wa ma'a, ma' tu tz'abüloo' ti'i,— cu t'an a Jesusu. ");
INSERT INTO mopNT_vpl VALUES ("LK10_7","072_10_7","LUK","10","7","7","—Ichil ilic a naj tuba a c'ümbüle'exe, te'i a jedele'ex. Ca' a jante'ex, ca' a wuq'ue'ex c'u' a ca' tz'abüc te'ex te'iji, u men le'ec aj meyaja, yan u c'ümic u naal. Ma' a beele'ex chi'chi'najil a yaalte'ex a posadojo,— cu t'an a Jesusu. ");
INSERT INTO mopNT_vpl VALUES ("LK10_8","072_10_8","LUK","10","8","8","—Le'ec ca' ocoque'ex ichil a caja, wa ca' u c'üme'exe, jante'ex c'u' a ca' tz'abüc te'exe,— cu t'an a Jesusu. ");
INSERT INTO mopNT_vpl VALUES ("LK10_9","072_10_9","LUK","10","9","9","—Ch'anese'exoo' a c'oja'an te'iji. “Nütz'a'an tun u q'uinil u tücaa' a Dioso,” que'exac ti'ijoo',— cu t'an a Jesusu. ");
INSERT INTO mopNT_vpl VALUES ("LK10_10","072_10_10","LUK","10","10","10","—C'u' betiqui, le'ec ca' ocoque'ex ichil a caj y ma' u c'atoo' u c'üme'exe, manene'ex ti calle. ");
INSERT INTO mopNT_vpl VALUES ("LK10_11","072_10_11","LUK","10","11","11","“Tan ti liijtic ti woc ca' c'axüc u ta'lu'umil ilic a caj ca' p'aatüc ti'i u p'is ti'i ca' u yee' ti ma' a c'ate'ex a c'ümo'on. C'u' betiqui, ch'a'e'ex u tojil. Nütz'a'an tun u q'uinil u tücaa' a Dioso,” que'exac ti'ijoo',— cu t'an a Jesusu. ");
INSERT INTO mopNT_vpl VALUES ("LK10_12","072_10_12","LUK","10","12","12","—Tan in wadic te'ex u jajil. Ca' c'ochoc u q'uinil u tz'abül a sip'ili, bel u ca'a tz'abül u sip'il ti mas yaj a caj abe'e, tuwich ti bel u ca'a tz'abül u sip'il a c'ac'as caj Sodoma,— cu t'an a Jesusu. ");
INSERT INTO mopNT_vpl VALUES ("LK10_13","072_10_13","LUK","10","13","13","—Pues te'i. Top yaj a watac ti'i a caj Corazini. Top yaj a watac ti'i a caj Betsaidaja. Wa cuchi betabi ich caj Tiro ich caj Sidon boon a milagro a betabi ich caj Corazin ich caj Betsaidaja, uchi tun cuchi u jeloo' u tucul. U tz'ajoo' cuchi u costal ti'ijoo' u noc'. U tz'ajoo' cuchi a ta'an tu pol u men u yajil u yool u menoo' u sip'il jabix ti sucoo' u bete'e. Tina'anoo' cuchi te'i,— cu t'an a Jesusu. ");
INSERT INTO mopNT_vpl VALUES ("LK10_14","072_10_14","LUK","10","14","14","—Le'ec ca' c'ochoc u q'uinil u tz'abül a sip'ili, bel u ca'a tz'abüloo' u sip'il ti mas yaj tuwich ti tz'abüc ti'ijoo' ich caj Tiro ich caj Sidon,— cu t'an a Jesusu. ");
INSERT INTO mopNT_vpl VALUES ("LK10_15","072_10_15","LUK","10","15","15","—Uxtun a caj Capernaumu. Tanoo' u tuclic ti beloo' u ca'a ti nac'ül ti ca'an, pero pulbuloo' u ca'a tac ichil a infiernojo,— cu t'an a Jesusu. ");
INSERT INTO mopNT_vpl VALUES ("LK10_16","072_10_16","LUK","10","16","16","—Pues te'i. Bel in quin tücaa'te'ex taanil,— cu t'an a Jesus ti'i a setenta tuulu. —Le'ec mac ca' u yubi a t'ane'exe, tan ilic u yubic in t'an inene. Le'ec mac ca' u culpachte'exe, tan ilic u culpachtiquen inene. Wa ca' u culpachteene, tan ilic u culpachtic mac u tücaa'tajen,— cu t'an a Jesus ti'ijoo' a setenta tuul u yaj cambala. Binoo' u bete' a c'u' a aalboo' ti'iji. ");
INSERT INTO mopNT_vpl VALUES ("LK10_17","072_10_17","LUK","10","17","17","Pues te'i. Le'ec ti usc'ajoo' tucaye' a setenta tuul etel a Jesusu, qui'oo' u yool. —Noochil, ca'ax c'ac'asba'al, walac u tz'ocsic ti t'an le'ec ti tan ti c'ajsic a c'aba',— cu t'anoo' a setenta tuul ti'i a Jesusu. ");
INSERT INTO mopNT_vpl VALUES ("LK10_18","072_10_18","LUK","10","18","18","—In wilaj u c'axül a quisin ti ca'an jabix u yemel a lemleme,— cu t'an a Jesus ti uchi u nuuc. ");
INSERT INTO mopNT_vpl VALUES ("LK10_19","072_10_19","LUK","10","19","19","—U'ye'ex in t'an. In tz'aj te'ex a patalil ti'i a wa'che'ticale'ex a can y a sina'ana. In tz'aj ilic te'ex a yanil yoc'ol a quisin le'ec ti wettz'iiquil. Ma'ax c'u' jede'ec u yajcuntique'ex,— cu t'an u yaalbüloo' u men a Jesusu. ");
INSERT INTO mopNT_vpl VALUES ("LK10_20","072_10_20","LUK","10","20","20","—Le'ec a c'ac'asba'ala, yan u tz'ocsique'ex a t'an. Ma' cuchi qui' ca' qui'aque'ex a wool chen u men a muq'ue'ex yoc'ol a c'ac'asba'ala. Mas qui' cuchi ti qui'e'ex a wool u men tz'iiba'ane'ex a c'aba' ti ca'an,— cu t'an a Jesus ti'i a setenta tuulu. ");
INSERT INTO mopNT_vpl VALUES ("LK10_21","072_10_21","LUK","10","21","21","Pues te'i. Le'ec ti jobi u yadic abe'e, tz'abi u qui'il u yool a Jesus u men u Püsüc'al a Dioso. —Tat, inchech u Noochil a ca'an etel a yoc'olcaba. Bo'tic tech a mucaj a jajil t'an ti'i ma' u ch'a'icoo' u tojil a top seeb u yool etel a top patal. C'u' betiqui, a ye'aj abe' ti'ijoo' a walacoo' u tz'eec u yool ta pach jabix a tz'ub a walac u tz'ocsaj t'ana. Tat, a tz'aj ti baalo' u men baalo' a qui' ta wichi,— cu t'an a Jesus ti'i a Tattzili. ");
INSERT INTO mopNT_vpl VALUES ("LK10_22","072_10_22","LUK","10","22","22","—Pues te'i. Tz'abi tulacal a ba'al tin c'ü' u men in Tat,— cu t'an a Jesus ti'ijoo' u yaj cambala. —Ma'ax mac u yeel maqui a Mejentzili, jadi' a Tattzili. Ma'ax le'ec a Tattzili, ma'ax mac u yeel. Jadi' a Mejentzil etel boon a qui' tu wich a Mejentzil ca' u yee' ti'ijoo' a Tattzili,— cu t'an a Jesusu. ");
INSERT INTO mopNT_vpl VALUES ("LK10_23","072_10_23","LUK","10","23","23","Pues te'i. Le'ec a Jesusu, u sutaj u bajil u cha'antoo' u yaj cambal. —Qui'oo' u yool a mac a tanoo' u yilic a jabix a tane'ex a wiliqui,— cu t'an a Jesus ti'ijoo' u yaj cambala. ");
INSERT INTO mopNT_vpl VALUES ("LK10_24","072_10_24","LUK","10","24","24","—Tan in wadic te'ex. Yanoo' a uchben cristiano u yadajoo' u t'an a Dios u yet'ocoo' a reye, u c'atiintajoo' u yila' c'u' a tane'ex a wiliqui. C'u' betiqui, ma' u yilajoo'. U c'atiintajoo' ilic u yubi c'u' a tane'ex a wu'yiqui, pero ma' u yubajoo',— cu t'an a Jesusu. ");
INSERT INTO mopNT_vpl VALUES ("LK10_25","072_10_25","LUK","10","25","25","Pues te'i. Jun tuul u yaj ca'ansajil u ley aj Moisese, naatz'i tu tzeel a Jesusu. U c'atiintaj u yubi wa patal a Jesusu. —¿Maestro, c'u' a qui' ca' in bete' ti'i in c'ümical a cuxtal a ma' yan q'uin u jobolo?— cu t'an ti'i a Jesusu. ");
INSERT INTO mopNT_vpl VALUES ("LK10_26","072_10_26","LUK","10","26","26","—¿C'u' a tz'iiba'an ichil a leye? ¿C'u' a tucul yoc'ol abe'e?— cu t'an a Jesus ti uchi u nuucu. ");
INSERT INTO mopNT_vpl VALUES ("LK10_27","072_10_27","LUK","10","27","27","—Yan a yacuntic a Noochtzil le'ec a Dios tulacal a püsüc'al, tulacal a wool, tulacal a muc' y tulacal a tucul. Jabix ilic yaj a wu'yi a bajil ta bajil, baalo' ilic yan a yacuntic a wet'oc,— cu t'an a winic ti'i a Jesusu. ");
INSERT INTO mopNT_vpl VALUES ("LK10_28","072_10_28","LUK","10","28","28","—Toj ca' a nuuctajen. Ca' a bete' ti jabix ca' a wadaja, yan tech a cuxtal abe'e,— cu t'an a Jesusu. ");
INSERT INTO mopNT_vpl VALUES ("LK10_29","072_10_29","LUK","10","29","29","C'u' betic a winiqui, u c'ati u joq'ues u bajil ichil u sip'il, mentücü, u ca' c'aataj ti'i a Jesusu. —¿Mac abe' in wet'oco?— cu t'an ti'i a Jesusu. ");
INSERT INTO mopNT_vpl VALUES ("LK10_30","072_10_30","LUK","10","30","30","Uchi u nuuc a Jesusu. —Jun tuul a winiqui, joq'ui ich caj Jerusalen. Tan u beel ich caj Jerico. Müchbi ala'i u menoo' aj xuuch'u. U pitajoo' u noc'. U jütz'ajoo'. Watac u quimil ca' u p'ütajoo' te'i,— cu t'an a Jesusu. ");
INSERT INTO mopNT_vpl VALUES ("LK10_31","072_10_31","LUK","10","31","31","—Pues te'i. Uchi ti baala' ti ti'i ilic a bej abe'e, bini jun tuul u yaj mansaj t'an a cristiano ti'i a Dioso. Te'i ilic que'en a winic a yajcunbiji. Le'ec ca' u yilaj a yajcunbiji, u xooytaj,— cu t'an a Jesusu. ");
INSERT INTO mopNT_vpl VALUES ("LK10_32","072_10_32","LUK","10","32","32","—Baalo' ilic jun tuul u mam aj Leviji. Le'ec ca' c'ochi te'iji, u cha'antaj a yajcunbiji. U xooytaj ilic xan,— cu t'an. ");
INSERT INTO mopNT_vpl VALUES ("LK10_33","072_10_33","LUK","10","33","33","—Jun tuul aj Samariajili, tan u manül ti bej. Le'ec ti c'ochi te'iji, u yilaj ilic a yajcunbiji. C'u' betiqui, le'ec ca' u yilaja, u ch'a'aj u yotzilil ca'ax motztziloo' aj Samariajil u menoo' aj Israele,— cu t'an a Jesusu. ");
INSERT INTO mopNT_vpl VALUES ("LK10_34","072_10_34","LUK","10","34","34","—Bini tu tzeel. U toxaj aceite olivo y vino tuwich boon u ch'acalil. U tepaj. U tz'aj pach u tzimin. U bensaj ti a naj tuba walac u tz'abül a posadojo. U cününtaj te'i,— cu t'an. ");
INSERT INTO mopNT_vpl VALUES ("LK10_35","072_10_35","LUK","10","35","35","—Tu samalili, u tz'aj ti'i u yumil a naj a taq'uin u muc' ca' p'e q'uin ti meyajili. “Cününte a yajcunbiji. Wa ca' a sütü' ti mas yaab a taq'uin yoc'olo, jede'ec in wusq'uintic u jel ti ca' uduquen tucaye'il,” cu t'an ti'i u yumil a naja,— cu t'an a Jesusu. ");
INSERT INTO mopNT_vpl VALUES ("LK10_36","072_10_36","LUK","10","36","36","—¿Biqui'il a tucul? ¿Mac tu yaamoo' a ox tuul abe'e, u yet'octaj a winic a yajcunbi u menoo' aj xuuch'u?— cu t'an a Jesusu. ");
INSERT INTO mopNT_vpl VALUES ("LK10_37","072_10_37","LUK","10","37","37","—Le'ec mac u ch'a'aj u yotzilili,— cu t'an ti'i a Jesusu. —Jabix ilic u betaj aj Samariajili, baalo' ilic ca' a bete' incheche,— cu t'an a Jesus ti'iji. ");
INSERT INTO mopNT_vpl VALUES ("LK10_38","072_10_38","LUK","10","38","38","Pues te'i. Joq'ui te'i a Jesus u yet'ocoo' u yaj cambala. Tanoo' u beel ich caj Jerusalen. C'ochoo' ich jun p'eel aldea. Yan jun tuul a nooch'up te'iji, ix Marta u c'aba'. U c'ümajoo' a Jesus eteloo' u yaj cambal ti posado ichil u yotocho. ");
INSERT INTO mopNT_vpl VALUES ("LK10_39","072_10_39","LUK","10","39","39","Le'ec u yitz'in ix Martaja, ix Maria u c'aba'. Tinlaji ix Maria u yubi u t'an a Jesusu. ");
INSERT INTO mopNT_vpl VALUES ("LK10_40","072_10_40","LUK","10","40","40","Naj u ch'aa' boon a ca' u bete' ix Marta etel a janala. Bini etel a Jesusu. —Noochil, ¿qui' wa ta wich ti p'aateen tin junal in bete' a janal u men in witz'in? Adü ti'i ca' talac u yaanteen,— cu t'an ti'i a Jesusu. ");
INSERT INTO mopNT_vpl VALUES ("LK10_41","072_10_41","LUK","10","41","41","—Marta, Marta, top naj a ch'aa' boon a ca' a bete'e,— cu t'an a Jesusu. ");
INSERT INTO mopNT_vpl VALUES ("LK10_42","072_10_42","LUK","10","42","42","—Jadi' a jun p'eel a top c'abeete, le'ec a jabix a tan u betic ix Mariaja. Ma' tu tocbol ti'i abe'e,— cu t'an a Jesusu. ");
INSERT INTO mopNT_vpl VALUES ("LK11_1","072_11_1","LUK","11","1","1","Pues te'i. Jun p'eel q'uin tan u t'an etel Dios a Jesus tuba que'ene. Jobi ti t'an a Jesusu. —Noochil,— cu t'an jun tuul u yaj cambal ti'i. —Ye'e to'on biqui ca' uchuc ti t'an etel Dios jabix ilic u ye'aj aj Juan ti'ijoo' u yaj cambala,— cu t'an ti'i. ");
INSERT INTO mopNT_vpl VALUES ("LK11_2","072_11_2","LUK","11","2","2","—Le'ec ti tane'ex a t'an etel a Dioso, baala' ca' a wade'ex,— cu t'an a Jesus ti'ijoo'o. —Tat a que'enech ti ca'ana, ti c'ati cuchi ca' tz'ocsabüc u yanil a c'aba'. Ca' talaquech wa'ye' ti tücaa'. Jabix ilic ti tan u tz'ocsabül a t'an ti ca'ana, baalo' ilic ti c'ati ca' tz'ocsabüc wa'ye' yoc'olcab. ");
INSERT INTO mopNT_vpl VALUES ("LK11_3","072_11_3","LUK","11","3","3","Tz'a to'on ti janal sansamal. ");
INSERT INTO mopNT_vpl VALUES ("LK11_4","072_11_4","LUK","11","4","4","Sa'tes ti sip'il u men ti sa'tesaj ti'i tulacal a jujun tuul mac u betaj to'on a c'asa. Ma' a cha'ic ca' talac emsabül ti wool ca' ti bete' a c'asa. Baalo' ca' a wade'ex,— cu t'an a Jesusu. ");
INSERT INTO mopNT_vpl VALUES ("LK11_5","072_11_5","LUK","11","5","5","—Pues te'i. Jun tuul ta yaame'exe, uchac u beel etel u amigo chumuc ac'ü' u c'aate tz'etz'eecac a waja. “Inen a amigo. In paaytic tech tz'etz'eecac a waja. ");
INSERT INTO mopNT_vpl VALUES ("LK11_6","072_11_6","LUK","11","6","6","C'ochi to ti posado tin wetel jun tuul in amigo a tan u viaje. Ma'ax c'u' yan ca' in tz'aa' u jante,” queech cuchi ti'i,— cu t'an a Jesus ti'ijoo' u yaj cambala. ");
INSERT INTO mopNT_vpl VALUES ("LK11_7","072_11_7","LUK","11","7","7","—Uchac u nuuctiquech ich naj ti baala': “Ma' a tuc'sic in wool. C'üla'an tun a puertaja. Tan ti wüyül tulacalo'on etel in mejen. Ma' yan biqui in liq'uil in tz'aa' tech a c'u' a c'atiji,” cu t'an cuchi a amigo tech,— cu t'an a Jesusu. ");
INSERT INTO mopNT_vpl VALUES ("LK11_8","072_11_8","LUK","11","8","8","—Tan in wadic te'ex. Ca'ax ma' u c'ati u liq'uil u tz'aa' ti'i u amigojo, u men tan ti tan u c'aatiqui, bel u ca'a ti liq'uil u tz'aa' ti'i c'u' u c'ati,— cu t'an a Jesusu. ");
INSERT INTO mopNT_vpl VALUES ("LK11_9","072_11_9","LUK","11","9","9","—Tan in wadic te'ex. Le'ec ti tane'ex a c'ajsic a Dioso, ma' a p'ütique'ex a c'aatic, y bel u ca'a tz'abül te'ex. Ma' a p'ütique'ex a cüxtic, y bele'ex a ca'a a cüxte. Ma' a p'ütique'ex a dioos chi' naj, y bel u ca'a jebbel te'ex,— cu t'an a Jesusu. ");
INSERT INTO mopNT_vpl VALUES ("LK11_10","072_11_10","LUK","11","10","10","—Baalo' ti yan u men tulacal a mac a tan ti tan u c'aatiqui, tan u c'ümic. Tulacal a mac a tan ti tan u cüxtic, walac u cüxtic. Tulacal a mac a tan ti tan u dioos chi' naja, bel u ca'a jebbel ti'i,— cu t'an a Jesusu. ");
INSERT INTO mopNT_vpl VALUES ("LK11_11","072_11_11","LUK","11","11","11","—¿Le'ec boone'ex a tattzile'exe, wa ca' c'aatbüc te'ex a pan u men a mejene'exe, jede'eque'ex wa a tz'eec ti'i a tunichi? ¿Wa ca' c'aatbüc te'ex aj ch'ilama, jede'eque'ex wa a tz'eec a can tu jel aj ch'ilama? ");
INSERT INTO mopNT_vpl VALUES ("LK11_12","072_11_12","LUK","11","12","12","¿Wa ca' c'aatbüc te'ex u je' aj caxa, jede'eque'ex wa a tz'eec ti'i a sina'ana?— cu t'an a Jesus ti'ijoo' u yaj cambala. ");
INSERT INTO mopNT_vpl VALUES ("LK11_13","072_11_13","LUK","11","13","13","—Inche'exe, ca'ax c'as a na'ate'ex, a weele'ex ilic biqui ca' a tz'aa'e'ex a quich'pan sij-ool ti'ijoo' a mejene'exe. Uxtun a Tattzil a que'en ti ca'ana, mas top que'en u yool u tz'aa' u Püsüc'al ti'ijoo' mac tanoo' u c'aatic,— cu t'an a Jesusu. ");
INSERT INTO mopNT_vpl VALUES ("LK11_14","072_11_14","LUK","11","14","14","Pues te'i. Le'ec a Jesusu, u joc'saj a c'ac'asba'al ichil u yool a winic a bese. Le'ec ti joq'ui a c'ac'asba'ala, caji ti t'an a winiqui. Sa'too' u yool a cristianojo. ");
INSERT INTO mopNT_vpl VALUES ("LK11_15","072_11_15","LUK","11","15","15","—Patal u joq'ues a c'ac'asba'al chen etel u muc' u noochiloo' a c'ac'asba'ala,— cu t'anoo' a jujun tuul tu yaamoo' a cristianojo. ");
INSERT INTO mopNT_vpl VALUES ("LK11_16","072_11_16","LUK","11","16","16","Yanoo' ulaac' tu yaamoo' a cristianojo, u c'atoo' u yila' wa patal a Jesusu. U c'aatajoo' ti'i a Jesus ca' u bete' a milagro ti ca'ana. ");
INSERT INTO mopNT_vpl VALUES ("LK11_17","072_11_17","LUK","11","17","17","Le'ec a Jesusu, u yeel c'u' a tanoo' u tucliqui. —Le'ec ti tz'iicoo' a cristiano tu bajil ichil jun p'eel a caja, c'astal u ca'a jumpul a caja. Baalo' ilic boon tuul ichil jun p'eel a familiaja. Wa ca' tz'iicacoo' tu bajili, p'aatül u ca'a ti weca'anoo',— cu t'an a Jesusu. ");
INSERT INTO mopNT_vpl VALUES ("LK11_18","072_11_18","LUK","11","18","18","—Baalo' ilic etel a quisini. Wa cuchi tz'iicoo' tu bajili, joboloo' ilic cuchi u ca'a a quisini. Tane'ex a wadic ti tan in joc'sic a c'ac'asba'al etel u muc' a quisini,— cu t'an a Jesusu. ");
INSERT INTO mopNT_vpl VALUES ("LK11_19","072_11_19","LUK","11","19","19","—¿Wa cuchi jaj ti tan in joc'sic a c'ac'asba'al etel u muc' u noochiloo' a c'ac'asba'ala, uxtun a wet'oque'ex?— cu t'an a Jesus ti'ijoo' a fariseo u c'aba'oo' u na'ata. —¿Etel ilic wa u muc' a quisin tanoo' u joc'sic a c'ac'asba'ala? Le'ec ilic ala'oo', beloo' u cu yee' ti ma' toje'ex a t'ani,— cu t'an a Jesusu. ");
INSERT INTO mopNT_vpl VALUES ("LK11_20","072_11_20","LUK","11","20","20","—C'u' betiqui, wa jaj ti tan in joc'sic a c'ac'asba'al etel u muc' a Dioso, jaj ilic ti c'ochi u q'uinil u tücaa' a Dioso,— cu t'an a Jesusu. ");
INSERT INTO mopNT_vpl VALUES ("LK11_21","072_11_21","LUK","11","21","21","—Le'ec a quisini, yaab u muc'. Yan ti'i tulacal a c'u' aj etel u cününtical u yotoch. Qui' cününa'an tulacal a c'u' a yan ichil u yotocho,— cu t'an a Jesusu. ");
INSERT INTO mopNT_vpl VALUES ("LK11_22","072_11_22","LUK","11","22","22","—C'u' betiqui, le'ec ca' c'ochoc mac a mas yaab u muc' ti p'isbaj etele, le'ec a mas yaab u muc'u, le'ec a bel u ca'a ti paatala. Le'ec a mas yaab u muc'u, bel u cu toco' ti'i le'ec a c'u' aj etel u tuclaj u cününtic u yotoch. Bel ilic u cu t'oxo' c'u' a ca' u toco' ichil a naj ti'ijoo' u yet'ocoo',— cu t'an a Jesus yoc'ol ti walac u joc'sic a mac tu c'ü' a quisini. ");
INSERT INTO mopNT_vpl VALUES ("LK11_23","072_11_23","LUK","11","23","23","—Le'ec mac a ma' que'en u yool tin pacha, tz'iic ten. Le'ec mac a ma' tan u yaantiquene, tan u wet'ic in meyaj,— cu t'an a Jesusu. ");
INSERT INTO mopNT_vpl VALUES ("LK11_24","072_11_24","LUK","11","24","24","—Pues te'i. Le'ec ca' joc'oc a c'ac'asba'al ichil u yool a maca, walac u manül ichil a tiquin lu'um ti'i ca' u cüxte tuba u jedel. Le'ec ti ma' tan u cüxtic tuba u jedele, walac u yadic tu bajil: “Bel in ca'a ti usc'al tin pach tin cuuchil tuba joq'ueen,” cu t'an tu bajil,— cu t'an a Jesusu. ");
INSERT INTO mopNT_vpl VALUES ("LK11_25","072_11_25","LUK","11","25","25","—Le'ec ca' c'ochoc te'i, u cüxtaj ti jabix miisa'an, qui' mola'an u cuuchil, le'ec u püsüc'al a maca,— cu t'an a Jesusu. ");
INSERT INTO mopNT_vpl VALUES ("LK11_26","072_11_26","LUK","11","26","26","—Le'ec ca' u yila' ti baalo', walac u beel u cüxte siete tuul ulaac' a c'ac'asba'al a mas c'as tuwich ala'aji. Tulacaloo' walacoo' u laj ocol te'i ti cuntal. Mas c'as ti p'aati a winic tuwich ti yaax culaji,— cu t'an a Jesusu. ");
INSERT INTO mopNT_vpl VALUES ("LK11_27","072_11_27","LUK","11","27","27","Pues te'i. Tan to u t'an a Jesus ti uchi u t'an ti chich jun tuul a nooch'up tu yaamoo' a cristianojo. —Qui' u yool a nooch'up mac u yancuntajech y u ch'ijsajeche,— cu t'an a nooch'up abe' ti chichi. ");
INSERT INTO mopNT_vpl VALUES ("LK11_28","072_11_28","LUK","11","28","28","—Mas toj ca' a wadü' ti qui'oo' u yool boon tuul a walacoo' u yubic u t'an a Dioso, y walacoo' u tz'ocsic c'u' a tanoo' u yubiqui,— cu t'an a Jesusu. ");
INSERT INTO mopNT_vpl VALUES ("LK11_29","072_11_29","LUK","11","29","29","Pues te'i. Tanoo' u mas much'tal a cristiano tu tzeel a Jesusu. —Top c'asoo' u na'at a cristiano aleebe. Chen u c'atoo' u yila' in betic a milagro ca' chiclac maquen. C'u' betiqui, ma' tu ye'bel ti'ijoo' a milagro jabix u c'atoo'o. Jadi' a jabix u betaj aj Jonasa, jadi' a beloo' u ca'a ye'bel ti'iji,— cu t'an a Jesusu. ");
INSERT INTO mopNT_vpl VALUES ("LK11_30","072_11_30","LUK","11","30","30","—Etel c'u' u c'ümaj aj Jonasa, chica'an ti'ijoo' a cristiano ich caj Ninive ti Dios u tücaa'taj. Inene, yanajeen ti cristianojil. Etel c'u' a bel in quin c'ümü'ü, chictal ilic u ca'a ti'ijoo' a cristiano aleebe ti Dios u tücaa'tajen ti'i ca' u tz'ocseenoo',— cu t'an a Jesusu. ");
INSERT INTO mopNT_vpl VALUES ("LK11_31","072_11_31","LUK","11","31","31","—Le'ec ca' c'ochoc u q'uinil u tz'abül a sip'ili, wa'taloo' u ca'a a cristiano jujun tuulil ti'i ca' ilbicoo' u sip'il. Wa'taloo' ilic u ca'a a cristiano a cuxa'anoo' to aleebe tu yaamoo',— cu t'an a Jesusu. —Wa'tal ilic u ca'a ix reina a tali mas naach ti a sur biq'uin ado'o. Bel u cu yadoo' u sip'il a cristiano a cuxa'anoo' to aleebe. Ca'ax boon u naachil a caja, bini ix reina abe' u yubi u patalil aj rey Salomon biq'uin ado'o. Ca'ax yan jun tuul wa'ye' ta yaame'ex a mas nooch u wichil u meyaj tuwich aj Salomono, ma' ta'ache'ex a tz'ocsic u t'an,— cu t'an a Jesusu. ");
INSERT INTO mopNT_vpl VALUES ("LK11_32","072_11_32","LUK","11","32","32","—Le'ec ca' c'ochoc u q'uinil u yilbil a sip'ili, wa'taloo' ilic u ca'a a cristiano a taloo' ti'i a caj Ninive u yadoo' u sip'il a cristiano a cuxa'anoo' to aleebe. Ala'oo'o, u jelajoo' u tucul u men a c'u' a aalbi ti'ijoo' u men aj Jonasa. Ca'ax yan jun tuul wa'ye' ta yaame'ex a mas nooch u wichil u meyaj tuwich aj Jonasa, ma' ta'ache'ex a tz'ocsic u t'an,— cu t'an a Jesusu. ");
INSERT INTO mopNT_vpl VALUES ("LK11_33","072_11_33","LUK","11","33","33","—Pues te'i. Ma'ax mac walac u t'übic a lampara ca' tun u mucu'. Ma'ax tu tz'eec yalam cajon ti'i ma' u chictal u sac. Walac u tz'eec abe' tu cuuchil. Ti baalo'o, sasil u wich a mac a oqui ich naj u men a lampara abe'e,— cu t'an a Jesusu. ");
INSERT INTO mopNT_vpl VALUES ("LK11_34","072_11_34","LUK","11","34","34","—U nec' u wich a maca, jabix u lamparajili. Ti sasil u nec' u wichi, sasil u benil. Le'ec ti ma' qui' u nec' u wichi, que'en ich jabix ac'ü'ü. Baalo' ilic etel u na'at a maca. Wa tojo, toj a bel u cu bete'e. Wa ma' tojo, ma' toj a bel u cu bete'e,— cu t'an a Jesusu. ");
INSERT INTO mopNT_vpl VALUES ("LK11_35","072_11_35","LUK","11","35","35","—Cününte'ex a bajil ti'i ma' u joc'ol te'ex ti ma' toj a na'ate'ex bete cuenta jabix ch'oop u nec' a wiche'exe. ");
INSERT INTO mopNT_vpl VALUES ("LK11_36","072_11_36","LUK","11","36","36","Wa toje'ex a na'ata, inche'exe, jabixe'ex a cuarto a sasilcunbi tulacal a ichil a ma' yan a bo'oy te'iji. Tojaji a na'at tu jajil jabix ilic a cuarto a sasilaji u men u sac a lamparaja,— cu t'an a Jesusu. ");
INSERT INTO mopNT_vpl VALUES ("LK11_37","072_11_37","LUK","11","37","37","Pues te'i. Tan to u t'an a Jesus ti chiitbi u men a fariseo u c'aba' u na'at ca' xi'ic ti janal etel. Bini tu pach. U cüxtaj u cuuch tu pach mesa. ");
INSERT INTO mopNT_vpl VALUES ("LK11_38","072_11_38","LUK","11","38","38","Le'ec a fariseo u c'aba' u na'ata, sa'ti u yool ca' u yilaj ti ma' u qui' p'o'aj u c'ü' a Jesus ti caji ti janal jabix ti sucoo' u bete'e. ");
INSERT INTO mopNT_vpl VALUES ("LK11_39","072_11_39","LUK","11","39","39","—Le'ec inche'ex a fariseo u c'aba' a na'ate'exe, walaque'ex a p'o'ic jabix u pach a pote etel a platojo, pero ¿uxtun a ichili? Chen jac' a walaque'ex a tucliqui. Chen c'as a na'ate'ex,— cu t'an a Noochtzil ti'i a fariseojo. ");
INSERT INTO mopNT_vpl VALUES ("LK11_40","072_11_40","LUK","11","40","40","—Top nane'ex. Dios u betaj a wot'ele'ex. ¿Ma' wa le'ec ilic u betaj tulacal a ichili,— cu t'an a Jesusu. ");
INSERT INTO mopNT_vpl VALUES ("LK11_41","072_11_41","LUK","11","41","41","—Tojaque'ex a na'at ca' a tz'a'e'ex a sij-oolo. Ca' a bete'ex ti baalo'o, laj tojaji tulacal te'ex,— cu t'an a Jesusu. ");
INSERT INTO mopNT_vpl VALUES ("LK11_42","072_11_42","LUK","11","42","42","—Yaj a bele'ex a ca'a a c'ümü' a fariseo u c'aba' a na'ate'exe. Qui' ti walaque'ex a tz'eec ti'i u sij-ool a Dios jun muuch' ca' p'aatüc nueve muuch' te'exe. baalo' walaque'ex a betic etel tulacal a c'u' a yan te'ex tac etel a yerba, a ruda, y tulacal u chucaan a pocche' a walac u jantabülü. C'u' betiqui, tubbi te'ex a betique'ex a tojo. Tubbi ilic te'ex a yacuntique'ex a Dioso. Yan a betique'ex a tojo. Yan ilic a yacunte'ex a Dioso, y ma' a p'ütique'ex a tz'eec u sij-ool a Dioso,— cu t'an a Jesusu. ");
INSERT INTO mopNT_vpl VALUES ("LK11_43","072_11_43","LUK","11","43","43","—Yaj a bele'ex a ca'a a c'ümü' a fariseo u c'aba' a na'ate'exe. Le'ec ti walaque'ex a wocol ichil boon a naj tuba walac u c'ajsabül a Dioso, jadi' tuba quich'pan a cuuchili, jadi' te'i a c'ate'ex a tintal jabix top nooch u wichile'ex a meyaj. Jadi' qui' ta xiquine'ex ca' chiitbique'ex ti calle jabix nooch u wichile'ex a meyaj,— cu t'an a Jesusu. ");
INSERT INTO mopNT_vpl VALUES ("LK11_44","072_11_44","LUK","11","44","44","—Yaj a bele'ex a ca'a a c'ümü' a fariseo u c'aba' a na'ate'exe. Inche'exe, aj cho'e'ex. Inche'exe, jabixe'ex u cuuchil a quimen a ma' chica'ana. Ca' manüc a winic te'iji, ma' u yeel wa yan a c'asa,— cu t'an a Jesusu. ");
INSERT INTO mopNT_vpl VALUES ("LK11_45","072_11_45","LUK","11","45","45","Pues te'i. Jun tuul u yaj ca'ansajil u ley aj Moisese, u nuuctaj a Jesusu. —Maestro, tanil a wadic a t'an abe'e, tan ilic a que'yico'on,— cu t'an ti'i. ");
INSERT INTO mopNT_vpl VALUES ("LK11_46","072_11_46","LUK","11","46","46","—Yaj ilic a bele'ex a ca'a a c'ümü' u yaj ca'ansajile'ex u ley aj Moisese. Top chich a ley a walaque'ex a tz'eec ti'ijoo' a cristianojo. Tane'ex a tz'eec a ley ti'ijoo' jabix cuchi tane'ex a tz'eec a cuch a top al ca' u cuchoo'. C'u' betic inche'exe, ma' ta'ache'ex a waanticoo' u ch'uuyte ma'ax etel jun tziit u yale'ex a cü',— cu t'an a Jesusu. ");
INSERT INTO mopNT_vpl VALUES ("LK11_47","072_11_47","LUK","11","47","47","—Yaj a bele'ex a ca'a a c'ümü'. Walaque'ex a betic u cuuchil a uchben quimen u yadajoo' u t'an a Dioso. Ala'oo'o, quimsaboo' u men a uchben mamaa'e'ex,— cu t'an a Jesusu. ");
INSERT INTO mopNT_vpl VALUES ("LK11_48","072_11_48","LUK","11","48","48","—Etel c'u' a walaque'ex a betiqui, chica'an ti qui'e'ex a wool etel c'u' u betajoo' a uchben mamaa'e'ex ti'ijoo' boon u yadajoo' u t'an a Dios uchi. Quimsaboo' u men ala'oo'o. Inche'exe, walaque'ex a betic u cuuchil tuba mucboo',— cu t'an a Jesus ti'ijoo' u yaj ca'ansajil u ley aj Moisese. ");
INSERT INTO mopNT_vpl VALUES ("LK11_49","072_11_49","LUK","11","49","49","—Le'ec a Dioso, yaab u yeele. Baala' u yadaj: “Bel in quin tücaa'too' mac a walacoo' u yadic in t'an ti'ijoo'o. Tu yaamoo' ala'oo'o, yan a beloo' u ca'a quimsabül. Yan a beloo' u ca'a yajcunbul,” cu t'an a Dioso,— cu t'an a Jesusu. ");
INSERT INTO mopNT_vpl VALUES ("LK11_50","072_11_50","LUK","11","50","50","—Le'ec boone'ex a cuxa'ane'ex aleebe, u yadaj abe' a Dioso, ti'i ca' p'aatüc jabix inche'ex ilic a quimsaje'ex boon tuul u yadaj u t'an a Dios tac tu cajeeb tac leeb,— cu t'an a Jesusu. ");
INSERT INTO mopNT_vpl VALUES ("LK11_51","072_11_51","LUK","11","51","51","—Le'ec a paye' quimsabiji, le'ec aj Abele. Le'ec u yada' a quimsabiji, le'ec aj Zacariasa. Quimsabi ala'i tu yaam tuba walac u chuwbul a baalche' y tu taan a naj tuba walac u mansabül u t'an a cristiano ti'i a Dioso. Tan in wadic te'ex u jajil. A sip'ile'ex ti quimoo' tulacal ala'oo'o. Inche'ex a cuxa'ane'ex aleebe, bele'ex a ca'a a bo'te a sip'il abe'e,— cu t'an a Jesusu. ");
INSERT INTO mopNT_vpl VALUES ("LK11_52","072_11_52","LUK","11","52","52","—Yaj a bele'ex a ca'a a c'ümü' u yaj ca'ansajile'ex u ley aj Moisese. A mucaje'ex a jajil t'an jabix a c'ülaje'ex abe' ich naj. Ma' a c'ümaje'ex abe' a jajil t'ana. Walaque'ex a yaaltic a wet'e' mac u c'ati u c'ümü' abe'e,— cu t'an a Jesusu. ");
INSERT INTO mopNT_vpl VALUES ("LK11_53","072_11_53","LUK","11","53","53","Pues te'i. Jobi ti t'an a Jesusu. Joq'ui te'i. Le'ecoo' a fariseo u c'aba'oo' u na'at eteloo' u yaj ca'ansajil u ley aj Moisese, choconacoo' u c'aate a jujumpaay ti'i a Jesusu. U yaaltajoo' u c'aate ti'i a Jesus ca' nuucbucoo' ti jomol. ");
INSERT INTO mopNT_vpl VALUES ("LK11_54","072_11_54","LUK","11","54","54","Tanoo' u paac'tic ca' nuucbucoo' ti ma' toj, ti'i ca' u cüxtoo' u sip'il a Jesusu. ");
INSERT INTO mopNT_vpl VALUES ("LK12_1","072_12_1","LUK","12","1","1","Pues te'i. Le'ec ti choconacoo' ala'oo' etel a Jesusu, mani tu pach u yaabil a cristiano a much'lajoo'o. Tanoo' u puch'ic u bajil u men u yaabil. Le'ec a Jesusu, payanbej caji ti t'an eteloo' u yaj cambal. —Cününte'ex a bajil ti'i ma' a betique'ex a jabix a walacoo' u betic a fariseo u c'aba'oo' u na'ata. Ala'oo'o, chen pach u yool ti walacoo' u betic a c'u'aca,— cu t'an a Jesusu. ");
INSERT INTO mopNT_vpl VALUES ("LK12_2","072_12_2","LUK","12","2","2","—Ma' yan a muca'an a ma' tu chictala. Ma'ax c'u' a betabi ich mucul wa ma' tu yeeltabül,— cu t'an a Jesusu. ");
INSERT INTO mopNT_vpl VALUES ("LK12_3","072_12_3","LUK","12","3","3","—Tulacal a c'u' a walaque'ex a wadic ich mucul jabix ich ac'ü'ü, bel u ca'a eeltabül ich jabix a sasil u men tulacal mac. Le'ec a mucult'an a walaque'ex a wadic ich jisilt'an ichil a cuarto tuba ma' ta'ach u yubajbülü, bel u ca'a eeltabül jabix cuchi tan u yaalbül ti chich pol naj,— cu t'an a Jesusu. ");
INSERT INTO mopNT_vpl VALUES ("LK12_4","072_12_4","LUK","12","4","4","—Pues te'i. Inche'exe, in amigoje'ex. Tan in wadic te'ex. Ma' a saactique'ex a cristianojo. Ala'oo'o, pataloo' u quimes a cristianojo. Ma' ca' yan ulaac' c'u' a jede'ecoo' u paatal u betic te'exe,— cu t'an a Jesusu. ");
INSERT INTO mopNT_vpl VALUES ("LK12_5","072_12_5","LUK","12","5","5","—Bel in quin wadü' te'ex mac a yan a saactique'exe. Yan a saactique'ex a Dioso. Ma' jadi' u paatal u quimsique'exe. Patal ilic u pule'ex ichil a infiernojo. Tan in wadic te'ex u jajil. Saacte'ex ala'aji,— cu t'an a Jesusu. ");
INSERT INTO mopNT_vpl VALUES ("LK12_6","072_12_6","LUK","12","6","6","—Walac u conbol cinco tuul aj meen ch'iich' yoc'ol ca' p'e centavo y ma'ax jun tuul a tubsabi u men a Dioso,— cu t'an a Jesusu. ");
INSERT INTO mopNT_vpl VALUES ("LK12_7","072_12_7","LUK","12","7","7","—Mas c'atiintzile'ex tuwich jun muuch' ti aj meen ch'iich'. Ma' jadi' abe'e, xoca'an ilic boon xiit a tzo'otzel a yan ta pole'ex. Ma' u jac'üle'ex a wool,— cu t'an a Jesusu. ");
INSERT INTO mopNT_vpl VALUES ("LK12_8","072_12_8","LUK","12","8","8","—Pues te'i. Tan ilic in wadic te'ex. Tulacal a mac walac u yadic tu taanoo' a cristiano ti u c'üm-ooltajene, bel ilic in quin wadoo' ti'i u yaj xa'num a Dios ti ca'an ti u c'üm-ooltajen a yanajeen ti cristianojili,— cu t'an a Jesusu. ");
INSERT INTO mopNT_vpl VALUES ("LK12_9","072_12_9","LUK","12","9","9","—Le'ec mac ca' u yadü' ti'ijoo' a cristiano ti ma' u c'üm-ooltajene, bel ilic u ca'a aalbül ti'ijoo' u yaj xa'num a Dios ti ca'an ti ma' ilic c'üma'an ala'aji,— cu t'an a Jesusu. ");
INSERT INTO mopNT_vpl VALUES ("LK12_10","072_12_10","LUK","12","10","10","—Tulacal a mac ca' u yadü' a c'as tin woc'ol a yanajeen ti cristianojili, jede'ec u paatal u sa'tesabül ti'i. C'u' betiqui, wa ca' u maclant'ante u Püsüc'al a Dioso, ma' tu sa'tesabül ti'i jumpul,— cu t'an a Jesusu. ");
INSERT INTO mopNT_vpl VALUES ("LK12_11","072_12_11","LUK","12","11","11","—Uchac a bensabüle'ex tu c'asil tu taanoo' aj ch'a'bej ichil boon a naj tuba walac u c'ajsabül a Dioso. Uchac a bensabüle'ex tu taan a alcalde wa ulaac' a nooch u wichil u meyaja. Ma' u jac'üle'ex a wool biqui ca' a nuucte'exoo'o, y c'u' a bele'ex a ca'a a wadü'ü,— cu t'an a Jesusu. ");
INSERT INTO mopNT_vpl VALUES ("LK12_12","072_12_12","LUK","12","12","12","—Le'ec ca' c'ochoc u yorajil u c'aatbüle'ex a chi'i, le'ec u Püsüc'al a Dioso, bel u cu yee' te'ex c'u' a bele'ex a ca'a a wadü'ü,— cu t'an a Jesus ti'ijoo' u yaj cambala. ");
INSERT INTO mopNT_vpl VALUES ("LK12_13","072_12_13","LUK","12","13","13","Pues te'i. Uchi u t'an jun tuul tu yaamoo' a cristianojo. —Maestro, adü ti'i in sucu'un ca' u jützü' ten u ayic'alil in quimen tat,— cu t'an ti'i a Jesusu. ");
INSERT INTO mopNT_vpl VALUES ("LK12_14","072_12_14","LUK","12","14","14","—Ila noochwinic. ¿Mac u tz'aj ten in meyaj ti il sip'il ti'i ca' in jützü' a jabix a c'atiji?— cu t'an a Jesusu. ");
INSERT INTO mopNT_vpl VALUES ("LK12_15","072_12_15","LUK","12","15","15","—Cününte'ex a bajil. Ile'ex ti ma' a bele'ex ti c'axül ichil a sip'il le'ec ca' a tz'i'le'ex a c'u' a yan ti'i ulaac'a. U cuxtal a maca, ma' que'en etel u yaabil u ayic'alili,— cu t'an a Jesusu. ");
INSERT INTO mopNT_vpl VALUES ("LK12_16","072_12_16","LUK","12","16","16","Pues te'i. Caji ti t'an a Jesus ich mucult'an eteloo'o. —Jun tuul a ayic'ala, yan u col. Qui'aji. Top yaab u wich u tz'aj. ");
INSERT INTO mopNT_vpl VALUES ("LK12_17","072_12_17","LUK","12","17","17","“C'u' a quin bete' aleebe? Ma' ca' yan tuba in taactic u wich in col,” cu t'an tu bajil,— cu t'an a Jesusu. ");
INSERT INTO mopNT_vpl VALUES ("LK12_18","072_12_18","LUK","12","18","18","—“Baala' a bel in quin bete'e. Bel in quin jubu' boon in rancho a yana. Bel in quin bete' abe' ti mas nooch. Te'i in taactic u wich in col, tulacal,” cu t'an tu bajil. ");
INSERT INTO mopNT_vpl VALUES ("LK12_19","072_12_19","LUK","12","19","19","“Pachil abe'e, bel in quin wadü' tin bajil: Taaca'an ten ti yaab u wich a colo. Ma' eela'an boon jaab u muc' ten. Bel in ca'a ti jedel, ti janal, ti uc'ul. Qui' in wool tin bajil,” cu t'an tu bajil,— cu t'an a Jesusu. ");
INSERT INTO mopNT_vpl VALUES ("LK12_20","072_12_20","LUK","12","20","20","—“Top nanech,” cu t'an a Dios ti'iji. “Leeb ti ac'ü' a quimil. ¿Uxtun tulacal a c'u' a taactaj? ¿Mac ti'i a p'ütic?” cu t'an u yaalbül u men a Dioso,— cu t'an a Jesusu. ");
INSERT INTO mopNT_vpl VALUES ("LK12_21","072_12_21","LUK","12","21","21","—Baalo' ilic tulacal a mac a tan u betic u ayic'alil wa'ye' yoc'olcab, y ma' yan jabix u ayic'alil etel a Dioso,— cu t'an a Jesusu. ");
INSERT INTO mopNT_vpl VALUES ("LK12_22","072_12_22","LUK","12","22","22","—Pues te'i. U men c'u' in wadaj to te'ex yoc'ol a ayic'ala, tan in wadic te'ex. Ma' a top tuclique'ex tuba u talel a janale'ex ti'i a cuxtale'ex. Ma'ax a top tuclique'ex tuba u talel a noq'ue'ex ti'i a tz'eeque'ex ta woc'ol,— cu t'an a Jesus ti'ijoo' u yaj cambala. ");
INSERT INTO mopNT_vpl VALUES ("LK12_23","072_12_23","LUK","12","23","23","—Le'ec a cuxtala, ma' jadi' a janali, ma'ax xan jadi' a noc'o,— cu t'an a Jesusu. ");
INSERT INTO mopNT_vpl VALUES ("LK12_24","072_12_24","LUK","12","24","24","—Tucle'ex u cuxtal aj ch'omo. Ma' ta'ach u pac', ma'ax u joch. Ma' yan u ranchojil u nül. C'u' betiqui, walac u tzeenbel u men a Dioso. Mas c'atiintzile'ex inche'ex tuwichoo' a ch'iich'i,— cu t'an a Jesusu. ");
INSERT INTO mopNT_vpl VALUES ("LK12_25","072_12_25","LUK","12","25","25","—Ma'ax mac ta yaame'ex jede'ec u sützic u bajil ma'ax ox naab chen etel u tucul,— cu t'an a Jesusu. ");
INSERT INTO mopNT_vpl VALUES ("LK12_26","072_12_26","LUK","12","26","26","—Wa ma' ta paatale'ex a sützü' a bajile'ex y ma' cuchi yaj u betabül abe'e, ¿c'u' ca'a top tane'ex a tuclic c'u'ac ulaac' ichile'ex a cuxtal jabix a janale'ex etele'ex a noc'o?— cu t'an a Jesus ti'ijoo' u yaj cambala. ");
INSERT INTO mopNT_vpl VALUES ("LK12_27","072_12_27","LUK","12","27","27","—Tucle'ex biqui ti walac u ch'iil a top'o. Ma' ta'ach u meyaj ma'ax u jitic a noc'o. Tan in wadic te'ex. Le'ec ti yan u noc' a top quich'pan yoc'ol aj quimen rey Salomono, ma' tu quetic u quich'panil a top' abe'e,— cu t'an a Jesusu. ");
INSERT INTO mopNT_vpl VALUES ("LK12_28","072_12_28","LUK","12","28","28","—Le'ec a top' abe'e, cuxa'an tu cuuchil aleebe. Samala, pulbi ich c'aac'. Le'ec a Dioso, u tz'aj u quich'panil y jun p'e rato ilic cuxa'an. Mas que'en u yool a Dios u tz'aa' te'ex a noc' tuwich u tz'eec u quich'panil a top'o. Que'ene'ex a wool tu pach a noc', y ma' top que'ene'ex a wool tu pach a Dioso,— cu t'an a Jesusu. ");
INSERT INTO mopNT_vpl VALUES ("LK12_29","072_12_29","LUK","12","29","29","—Ma' a tz'eeque'ex a wool tu pach a janal etel a wuc'ul. Ma' a tuclique'ex abe'e. ");
INSERT INTO mopNT_vpl VALUES ("LK12_30","072_12_30","LUK","12","30","30","Tulacal a cristiano yoc'olcaba, que'enoo' u yool tu pach a janal etel a uc'ulu. Le'ec a Tate'exe, u yeel ti c'abeet te'ex a janal etel a uc'ul abe'e,— cu t'an a Jesus ti'ijoo' u yaj cambala. ");
INSERT INTO mopNT_vpl VALUES ("LK12_31","072_12_31","LUK","12","31","31","—Inche'exe, payanbej ca' a tucle'ex biqui'il u c'ati a Dioso, y bel u ca'a tz'abül te'ex tulacal abe' a c'u' a c'abeet te'exe,— cu t'an a Jesusu. ");
INSERT INTO mopNT_vpl VALUES ("LK12_32","072_12_32","LUK","12","32","32","—Pues te'i. Ma' a saactale'ex a jun muuch'e'ex a ma' yaabe'ex ta bajil. Qui' tu wich a Tate'ex ca' u tz'aa' a cuuchile'ex etel,— cu t'an a Jesusu. ");
INSERT INTO mopNT_vpl VALUES ("LK12_33","072_12_33","LUK","12","33","33","—Cone'ex c'u' a yan te'exe. T'oxe'ex u tool ti'i a mac a ma'ax c'u' a yan ti'iji. Ti baalo'o, tan u yantal te'ex u cuuchil taq'uin a ma' yan q'uin u jobol etel a ayic'alile'ex ti ca'an a ma' yan q'uin u jobol. Ma' yan q'uin u c'ochol aj xuuch' te'i ma'ax ix moc'oc',— cu t'an a Jesus ti'ijoo' u yaj cambala. ");
INSERT INTO mopNT_vpl VALUES ("LK12_34","072_12_34","LUK","12","34","34","—Baalo' ca' a bete'ex, u men le'ec tuba que'ene'ex a ayic'alili, te'i ilic que'ene'ex a wool,— cu t'an a Jesusu. ");
INSERT INTO mopNT_vpl VALUES ("LK12_35","072_12_35","LUK","12","35","36","—Tz'aje'ex a bajil jabix jun tuul aj meyaj ti tan u paac'tic u yusc'al u tz'ulil ti il tz'ocolbeel. Qui' c'üxa'an u c'ax u nüc' ti'i ca' u bete' u meyaj aj meyaj abe'e. T'üba'an u lampara. Le'ec ca' c'ochoc u tz'ulil u boojte a puertaja, paac' u ca'a u jebe' ti'i,— cu t'an a Jesusu. ");
INSERT INTO mopNT_vpl VALUES ("LK12_37","072_12_37","LUK","12","37","37","—Le'ecoo' u yaj meyaja, qui'oo' u yool ti cüxtaboo' u men u tz'ulil ti p'ixa'anoo' u paac'te u c'ochol. Tan in wadic te'ex u jajil. Le'ec u tz'ulili, bel u cu tz'aa' u c'ax u nüc' tu bajil ti'i ca' uchuc u meyaj. Bel u cu tz'aa'oo' u yaj meyaj pach mesa. Bel u ca'a ti c'ochol u tz'a'oo' u janal,— cu t'an a Jesusu. ");
INSERT INTO mopNT_vpl VALUES ("LK12_38","072_12_38","LUK","12","38","38","—Uchac u c'ochol u tz'ulil le'ec ti ma'ax to c'ochoc a chumuc ac'ü'ü. Uchac u c'ochol ti mana'an a chumuc ac'ü'ü. Wa ca' cüxtabücoo' aj meyaj ti pixa'anoo'o, qui'oo' u yool,— cu t'an a Jesusu. ");
INSERT INTO mopNT_vpl VALUES ("LK12_39","072_12_39","LUK","12","39","39","—Ch'a'e'ex u tojil ada'a. Wa cuchi u yeel c'u' ti horajil u c'ochol aj xuuch' u yumil a naja, pixa'an cuchi ala'aji. Ma' cuchi tu cha'ic u yocol,— cu t'an a Jesusu. ");
INSERT INTO mopNT_vpl VALUES ("LK12_40","072_12_40","LUK","12","40","40","—Baalo' ilic cuchi inche'exe. Listoje'ex ilic cuchi. Le'ec ti ma' cuchi tane'ex a paac'tiquene, chen a wilique'exe, jeda'en a yanajeen ti cristianojili,— cu t'an a Jesus ti'ijoo' u yaj cambala. ");
INSERT INTO mopNT_vpl VALUES ("LK12_41","072_12_41","LUK","12","41","41","Pues te'i. —Noochil, ¿tan wa a wadic a mucult'an abe' to'on wa ti'i tulacaloo'?— cu t'an aj Pedro ti'iji. ");
INSERT INTO mopNT_vpl VALUES ("LK12_42","072_12_42","LUK","12","42","42","—Le'ec a mac a tan in tzicbaltiqui, le'ec mac aj meyaj aj tz'ocsaj t'an a seeb u yool a jede'ec u tz'abül ti nooch u wichil u meyaj u men u tz'ulil. Bel u ca'a u cününte u yotoch u tz'ulil. Bel u cu tz'aa' u janal tu yorajil,— cu t'an a Jesusu. ");
INSERT INTO mopNT_vpl VALUES ("LK12_43","072_12_43","LUK","12","43","43","—Qui' u yool aj meyaj a tan ilic u meyaj le'ec ca' uduc u tz'ulil. ");
INSERT INTO mopNT_vpl VALUES ("LK12_44","072_12_44","LUK","12","44","44","Tan in wadic te'ex u jajil. Bel u ca'a tz'abül ti'i ti nooch u wichil u meyaj. Bel u cu cününte tulacal a c'u' a yan ti'i u tz'ulili,— cu t'an a Jesus ti'ijoo' u yaj cambala. ");
INSERT INTO mopNT_vpl VALUES ("LK12_45","072_12_45","LUK","12","45","45","—C'u' betiqui, uchac baala' ca' u yadü' u yaj meyaj abe'e: “Ma' tu jomol udel in tz'ulil,” cu t'an tu bajil. Caji u jütz'oo' aj meyaja, ti winic, ti ix ch'up. Caji ti janal, ti uc'ul, ti caalül,— cu t'an a Jesusu. ");
INSERT INTO mopNT_vpl VALUES ("LK12_46","072_12_46","LUK","12","46","46","—Le'ec u tz'ulil aj meyaj abe'e, udel u ca'a tu q'uinil le'ec ti ma' tan u paac'bül. Udel u ca'a ti u yorajil ti ma' u yeel u yaj meyaj abe'e. Bel u ca'a tz'abül ichil u sip'il. Tz'abül u ca'a tu yaamoo' a ma' ta'achoo' u tz'ocsaja,— cu t'an a Jesusu. ");
INSERT INTO mopNT_vpl VALUES ("LK12_47","072_12_47","LUK","12","47","47","—Le'ec aj meyaja, u yeel c'u' u c'ati u tz'ulili. C'u' betiqui, ma' u listartaj u bajil, ma'ax u betaj abe'e. Bel u ca'a tz'abül u sip'il ti top yaj. ");
INSERT INTO mopNT_vpl VALUES ("LK12_48","072_12_48","LUK","12","48","48","C'u' betiqui, yan ulaac' a ma' u yeel c'u' u c'ati u tz'ulili, mentücü, u betaj a ma' qui'i. Ala'aji, ma' top yaj ti bel u ca'a tz'abül u sip'il u men ma' u yeel ta wichi. Le'ec a mac u yeel a yaaba, yan u betic a yaaba. Baalo' ilic etel a cristianojo. Le'ec ca' u tz'aa' a yaab ti'i a maca, bel u cu c'atiinte u c'ümü' u jel ti mas yaab tucaye'il ca' usq'uinbic ti'iji,— cu t'an a Jesus yoc'ol u betic u meyaj a mac ti chuculu. ");
INSERT INTO mopNT_vpl VALUES ("LK12_49","072_12_49","LUK","12","49","49","—Pues te'i. Taleen in tz'aa' jabix a c'aac' ichil a yoc'olcaba, le'ec ca' u jüp'oo' u bajil a c'üma'an etel a pula'ana. In c'ati cuchi ti ac t'üba'an a jabix c'aac' abe'e,— cu t'an a Jesusu. ");
INSERT INTO mopNT_vpl VALUES ("LK12_50","072_12_50","LUK","12","50","50","—C'u' betiqui, se' yan in c'ümic c'u' a bel in ca'a in c'ümü'. Naj in ch'aa' wa ac in mansaj. ");
INSERT INTO mopNT_vpl VALUES ("LK12_51","072_12_51","LUK","12","51","51","¿Tane'ex wa a tuclic ti taleen in tz'aa' ti qui'oo' tu bajil a cristiano yoc'olcab? Taleen ma' ti'i in tz'eecal ti qui'oo' tu bajil a cristianoji. Tan in wadic te'ex. Taleen in tz'aa' ca' u jüp'oo' u bajil,— cu t'an a Jesusu. ");
INSERT INTO mopNT_vpl VALUES ("LK12_52","072_12_52","LUK","12","52","52","—P'aatül u ca'a ti ma' jumbeloo' u tucul a cinco tuul ichil a jun cuul a naja. Ma' jumbeloo' a ox tuul etel a ca' tuulu. Ma'ax jumbeloo' a ca' tuul etel a ox tuulu. Baalo' ti caal u ca'a,— cu t'an a Jesusu. ");
INSERT INTO mopNT_vpl VALUES ("LK12_53","072_12_53","LUK","12","53","53","—Ma' jumbel u tucul u tat etel u mejen, ma'ax u mejen etel u tat. Ma' jumbel u tucul u na' etel u yal, ma'ax u yal etel u na'. Ma' jumbel u tucul a nooch'up etel u yütan u yal ma'ax le'ec a ütantzil abe' etel a nooch'up abe'e,— cu t'an a Jesusu. ");
INSERT INTO mopNT_vpl VALUES ("LK12_54","072_12_54","LUK","12","54","54","—Pues te'i. Tanil a wilique'ex ti tan u nac'ül a muyal tu yoqueeb a q'uini, “Watac a ja'a,” que'ex ti jomol y walac u yuchul,— cu t'an a Jesus ti'ijoo' u yaabil a cristianojo. ");
INSERT INTO mopNT_vpl VALUES ("LK12_55","072_12_55","LUK","12","55","55","—Le'ec ca' a wile'ex ti tan u talel a ic' tu tojil a suru, “leeb a q'uini,” que'ex y walac u yuchul,— cu t'an ti'ijoo'. ");
INSERT INTO mopNT_vpl VALUES ("LK12_56","072_12_56","LUK","12","56","56","—Inche'exe, aj cho'e'ex. A weele'ex u p'is a c'u' a watac yoc'olcaba. ¿C'u' ca'a ma' a weele'ex u p'is ti udi a Cristo yoc'olcab?— cu t'an a Jesusu. ");
INSERT INTO mopNT_vpl VALUES ("LK12_57","072_12_57","LUK","12","57","57","—Pues te'i. ¿C'u' ca'a ma' patale'ex a tucle ta junale'ex biqui'il a tojo? ");
INSERT INTO mopNT_vpl VALUES ("LK12_58","072_12_58","LUK","12","58","58","Le'ec ti tan to u bensique'ex tu taan a alcalde aj tzolo, yaalte'ex a wemes u yool aj tzolo. Wa ma'a, bel u cu bense'ex tu taan aj il sip'il. Le'ec aj il sip'ili, bel u cu c'ube'ex ti'i a soldadojo. Le'ec a soldadojo, bel u cu tz'a'e'ex ich cuarto. ");
INSERT INTO mopNT_vpl VALUES ("LK12_59","072_12_59","LUK","12","59","59","Tan in wadic te'ex. Ma' ta joc'ole'ex te'i asto a bo'tique'ex a multa. Ma'ax jun p'e centavo u yemel,— cu t'an a Jesusu. ");
INSERT INTO mopNT_vpl VALUES ("LK13_1","072_13_1","LUK","13","1","1","Pues te'i. Ti'i ilic a q'uin abe'e, que'en tu yaamoo' a cristiano mac u yadaj ti'i a Jesus c'u' u c'ümajoo' aj Galileanojoo'o. Le'ec ti tanoo' u quimsic a baalche' ti'i u sij-oolticaloo' ti'i a Dioso, quimsaboo' ilic ala'oo' u men aj gobernador Pilatojo. Xaabbi u q'uiq'uel ala'oo' etel a sij-oolo. ");
INSERT INTO mopNT_vpl VALUES ("LK13_2","072_13_2","LUK","13","2","2","—¿Tane'ex wa a tuclic ti mas yaab u sip'il aj Galileanojoo' abe' tuwichoo' u chucaan aj Galileanojiloo' u men c'u' u c'ümajoo'?— cu t'an a Jesus ti uchi u nuucu. ");
INSERT INTO mopNT_vpl VALUES ("LK13_3","072_13_3","LUK","13","3","3","—Inen tan in wadic te'ex. Ma' mas yanoo' u sip'il tuwichoo' u chucaani. C'u' betiqui, wa ma' ta jelique'ex a tuculu, bele'ex ilic a ca'a ti quimil, y bele'ex a ca'a ichil a c'asili,— cu t'an ti'ijoo'. ");
INSERT INTO mopNT_vpl VALUES ("LK13_4","072_13_4","LUK","13","4","4","—Uxtun a diez y ocho tuul a quimoo' le'ec ti c'axi a ca'nal naj yoc'oloo'o. Que'en tu tzeel a cuxlinja' Siloe abe'e. ¿Tane'ex wa a tuclic ti mas yaaboo' u sip'il ala'oo' tuwichoo' u chucaan a cristiano ich caj Jerusalen u men c'u' u c'ümajoo'o? ");
INSERT INTO mopNT_vpl VALUES ("LK13_5","072_13_5","LUK","13","5","5","Tan in wadic te'ex. Ma' mas yanoo' u sip'il tuwichoo' u chucaani. C'u' betiqui, wa ma' ta jelique'ex a tuculu, bele'ex ilic a ca'a ti quimil, y bele'ex a ca'a ichil a c'asili,— cu t'an ti'ijoo'. ");
INSERT INTO mopNT_vpl VALUES ("LK13_6","072_13_6","LUK","13","6","6","Pues te'i. Le'ec a Jesusu, u yadaj a mucult'an ti'ijoo' a cristianojo. —Jun tuul a winiqui, u tz'aj ca' püc'büc jun teec a che' higuera ichil u cuuch u püc'aal. C'ochi u yuxu' u wich. Ma' yan. ");
INSERT INTO mopNT_vpl VALUES ("LK13_7","072_13_7","LUK","13","7","7","“Ox p'e jaab caaquen ti talel in wila' u wich a che' higuera ada'a, y ma' yan. Ch'ücü. ¿C'u' aj beel ca' u jobes u muc' a lu'umu?” cu t'an ti'i u yaj meyaj,— cu t'an a Jesusu. ");
INSERT INTO mopNT_vpl VALUES ("LK13_8","072_13_8","LUK","13","8","8","—“Noochwinic, mas qui' ti'ijac to jun p'e jaab ti ch'üquic. Bel in quin paante u xooc ca' tun in tz'aa' u ta' baalche' te'i. ");
INSERT INTO mopNT_vpl VALUES ("LK13_9","072_13_9","LUK","13","9","9","Wa ca' u tz'aa' u wich ti a jaab a wataca, qui'. Wa ma'a, qui' ca' a tz'aa' ca' ch'ücbüc,” cu t'an u yaj meyaj ti'iji,— cu t'an a Jesus ich mucult'an ti'ijoo' a cristianojo. ");
INSERT INTO mopNT_vpl VALUES ("LK13_10","072_13_10","LUK","13","10","10","Pues te'i. Tan u t'an a Jesus ichil a naj tuba walacoo' u much'tal a cristiano u c'ajes a Dioso. U q'uinil jedel a q'uin abe'e. ");
INSERT INTO mopNT_vpl VALUES ("LK13_11","072_13_11","LUK","13","11","11","Tu yaamoo' a winic a nooch'up a much'a'anoo' te'iji, yan jun tuul a nooch'up a diez y ocho jaab ococ a c'ac'asba'al ichil u yoolo. Nococ u pach u men a c'ac'asba'ala. Ma' patal ti wa'tal ti toj. ");
INSERT INTO mopNT_vpl VALUES ("LK13_12","072_13_12","LUK","13","12","12","A Jesusu, u yilaj a nooch'upu. U püyaj tu tzeel. —Nooch'up, qui'aquech,— cu t'an ti'i. ");
INSERT INTO mopNT_vpl VALUES ("LK13_13","072_13_13","LUK","13","13","13","U tz'aj u c'ü' yoc'ol. Tu seebal tojaji u pach. Caji u yadü' u qui'il a Dios a nooch'upu. ");
INSERT INTO mopNT_vpl VALUES ("LK13_14","072_13_14","LUK","13","14","14","C'u' betiqui, siq'ui u yool u yaj cananil a naj abe' tuba walac u c'ajsabül a Dioso. Siq'ui u yool u men ch'anesabi a nooch'up tu q'uinil jedel u men a Jesusu. —Seis p'eel q'uin u q'uinil a meyaja. Ca' talaque'ex tu q'uinil abe' ti'i ca' ch'anüque'ex. Ma' tu q'uinil jedel a tz'ücbüli,— cu t'an a winic abe' ti'ijoo' a cristianojo. ");
INSERT INTO mopNT_vpl VALUES ("LK13_15","072_13_15","LUK","13","15","15","Uchi u nuuc a Noochtzili. —Inche'exe, aj cho'e'ex. Tulacale'ex walaque'ex a pitic u c'ax a wacax wa a tzimin a c'üxa'an yalam bo'oy tu q'uinil ilic a jedele. Walaque'ex a bensic ti uc'ul,— cu t'an a Jesusu. ");
INSERT INTO mopNT_vpl VALUES ("LK13_16","072_13_16","LUK","13","16","16","—Le'ec a nooch'up ada'a, le'ec jun tuul u mam ti uchben mamaa' aj Abraham. Diez y ocho jaab jabix c'üxa'an u men a quisin ti'i ma' u toj wa'tal a nooch'up ada'a. ¿Ma' wa qui' ca' in joc'saj tu c'ü' a quisin tu q'uinil a jedele?— cu t'an a Jesusu. ");
INSERT INTO mopNT_vpl VALUES ("LK13_17","072_13_17","LUK","13","17","17","Le'ec ca' u yadaj abe'e, sudacajoo' boon a tz'iicoo' ti'i a Jesusu. Tulacaloo' u chucaan a cristianojo, qui'oo' u yool u men a quich'pan meyaj a walac u betiqui. ");
INSERT INTO mopNT_vpl VALUES ("LK13_18","072_13_18","LUK","13","18","18","Pues te'i. Caji ti t'an a Jesus eteloo' a cristianojo. —¿C'u' a qui' ca' in wadü' te'ex ti'i ca' a ch'a'e'ex u tojil yoc'ol biqui ti walac u tücaa' a Dioso? ¿C'u' a c'üs quet etel abe'e?— cu t'an a Jesus ti'ijoo'o. ");
INSERT INTO mopNT_vpl VALUES ("LK13_19","072_13_19","LUK","13","19","19","—Le'ec biqui ti walac u tücaa' a Dioso, c'üs quet etel jun cuul u nec' ix mostazaja. Jun tuul a winiqui, u püc'aj abe' ichil u cuuch u püc'aala. Ch'iji ix mostaza te'i. Chawac u yoc. Le'ecoo' a ch'iich'i, u betajoo' u c'u' tu c'ü',— cu t'an a Jesusu. ");
INSERT INTO mopNT_vpl VALUES ("LK13_20","072_13_20","LUK","13","20","20","—Pues te'i. ¿C'u' a c'üs quet etel biqui ti walac u tücaa' a Dioso? ");
INSERT INTO mopNT_vpl VALUES ("LK13_21","072_13_21","LUK","13","21","21","C'üs quet etel biqui ti walac u yaabtal a levaduraja. Jun tuul a nooch'upu, u xaabtaj abe' ichil jabix jun xoot costal a harina ca' u xaabte u bajil tulacal ichil,— cu t'an a Jesusu. ");
INSERT INTO mopNT_vpl VALUES ("LK13_22","072_13_22","LUK","13","22","22","Pues te'i. Tan u manül a Jesus ich caj ich aldea tu benil a caj Jerusalen. Tan u yadic u t'an a Dios ti'ijoo' a cristianojo. ");
INSERT INTO mopNT_vpl VALUES ("LK13_23","072_13_23","LUK","13","23","23","—¿Noochwinic, yaaboo' wa a cristiano a beloo' u ca'a sa'albülü, wa ma'?— cu t'an a jun tuul ti'iji. ");
INSERT INTO mopNT_vpl VALUES ("LK13_24","072_13_24","LUK","13","24","24","—Tz'aje'ex a wool ti ocol ichil a jabix puerta a tz'i'tz'i' u taan. Inen, tan in wadic te'ex. Yanoo' a beloo' u cu yaalte a ocolo, pero ma' tu paataloo',— cu t'an a Jesus ti'ijoo'o. ");
INSERT INTO mopNT_vpl VALUES ("LK13_25","072_13_25","LUK","13","25","25","—Jun p'eel q'uin bel u ca'a ti liq'uil u yumil a naj u c'ülü' a puertaja. Uchac a c'ochole'ex ti a q'uin abe' a boojte'ex a puertaja. Bele'ex a ca'a a wadü': “Noochwinic, jebe to'on a puertaja,” que'exac ti'i. Bel u ca'a u nuucte'ex ti baala': “Ma' in weele'ex a wich. Ma'ax in weel tuba tale'ex,” cu t'anac te'ex. ");
INSERT INTO mopNT_vpl VALUES ("LK13_26","072_13_26","LUK","13","26","26","Bele'ex a ca'a a nuucte: “Uchi ti comon janal ti wuc'ul ta wetel. A wadaj a pectzil ti'ijoo' a cristiano tu callejil ti caal,” que'exac ti'i. ");
INSERT INTO mopNT_vpl VALUES ("LK13_27","072_13_27","LUK","13","27","27","C'u' betiqui, bel u cu nuucte'ex ti baala': “Inene, tan in wadic te'ex. Ma' in weele'ex a wich. Ma'ax in weel tuba tale'ex. Joq'uene'ex wa'ye' inche'ex a walaque'ex a betic a c'asa,” cu t'anac te'ex,— cu t'an a Jesus ti'ijoo' a cristianojo. ");
INSERT INTO mopNT_vpl VALUES ("LK13_28","072_13_28","LUK","13","28","28","—Bele'ex a ca'a ti oc'ol. Bel u ca'a ti jürüt'e'ex a coj le'ec ca' a wile'ex u yocol aj Abraham, aj Isaac, aj Jacob y tulacal boon u yadaj u t'an a Dios uchi. Ocoloo' u ca'a ala'oo' tu cuenta a Dioso, pero inche'exe, bele'ex a ca'a joc'sabül,— cu t'an a Jesusu. ");
INSERT INTO mopNT_vpl VALUES ("LK13_29","072_13_29","LUK","13","29","29","—Watacoo' a cristiano joq'ueeb q'uin. Watacoo' oqueeb q'uin. Watacoo' ti norte y ti sur. Much'taloo' u ca'a pach mesa tu cuenta a Dioso,— cu t'an a Jesusu. ");
INSERT INTO mopNT_vpl VALUES ("LK13_30","072_13_30","LUK","13","30","30","—U'yeene'ex. Yan jujun tuul a ma' nooch u wichil u meyaj wa'ye' a bel u ca'a tz'abül ti nooch u wichil u meyaj ti ca'an. Yan ilic a jujun tuul a nooch u wichil u meyaj wa'ye' a ma' nooch u wichil u meyaj te'i,— cu t'an a Jesusu. ");
INSERT INTO mopNT_vpl VALUES ("LK13_31","072_13_31","LUK","13","31","31","Pues te'i. Ti a q'uin abe'e, yanoo' a fariseo u c'aba' u na'at a c'ochoo' etel a Jesusu. —Joq'uen wa'ye'. U c'ati u quimseech aj rey Herodes,— cu t'anoo' ti'i a Jesusu. ");
INSERT INTO mopNT_vpl VALUES ("LK13_32","072_13_32","LUK","13","32","32","—Le'ec aj rey Herodese, jabix ch'umac. Top aj cho'. Ca' xique'ex etel ala'aji. Baala' ca' a wade'ex ti'i: “Aleebe tan ti tan in joc'sic a c'ac'asba'al ichil u yool a maca. Tan ilic in ch'anesic a c'oja'ana. Baalo' ilic a bel in quin bete' samal. Ti'i u yox p'eel q'uin in jobsic in meyaj, cu t'an a Jesusu,” que'exac ti'i,— cu t'an a Jesus ti'ijoo' a fariseojo. ");
INSERT INTO mopNT_vpl VALUES ("LK13_33","072_13_33","LUK","13","33","33","—Ca'ax u c'ati u quimseen, bel in ca'a aleebe, samal, ca'be u men ma' yan biqui ca' quimsabüc jun tuul a tan u yadic u t'an a Dios wa ma' ich caj Jerusalen,— cu t'an a Jesusu. ");
INSERT INTO mopNT_vpl VALUES ("LK13_34","072_13_34","LUK","13","34","34","—Pues te'i. Le'eque'ex a cristiano ich caj Jerusalen, top walaque'ex a quimsic mac a tan u yadic u t'an a Dioso. Top walaque'ex a p'up'uchch'inticoo' ti'i ca' quimicoo' mac a tücaa'boo' ta wetele'ex u men a Dioso. Boon sut in c'atiintaj cuchi in sa'alte'ex jabix jun tuul ixna' cax a walac u much'quintic u yal yalam u xic. C'u' betiqui, ma' a c'atiintaje'ex,— cu t'an a Jesus yoc'ol a caj Jerusalene. ");
INSERT INTO mopNT_vpl VALUES ("LK13_35","072_13_35","LUK","13","35","35","—U'ye'ex. Ma' tan u ca' cününbüle'ex a wotoch u men a Diosi. Inen tan in wadic te'ex. Ma' ta ca' ilique'ex in wich tucaye'il asto ti ca' a wade'ex u qui'il u yaj tücaa' a Noochtzil a tücaa'bi ta wetele'exe. Le'ec ti ca' a wade'ex u qui'il ala'aji, bele'ex a ca'a a wila' in wich,— cu t'an a Jesus yoc'ol a caj Jerusalene. ");
INSERT INTO mopNT_vpl VALUES ("LK14_1","072_14_1","LUK","14","1","2","Pues te'i. Jun p'eel u q'uinil a jedele, que'en a Jesus ti janal etel jun tuul a nooch u wichil u meyaj. Fariseo u c'aba' u na'at ala'aji. Yan jun tuul a winic te'iji, top sip'a'an tu jajil. Le'ecoo' a fariseo u c'aba'oo' u na'ata, top tanoo' u tz'eec ti cuenta a Jesus ti'i ca' u yiloo' wa ca' u ch'anes a winic ti'i u q'uinil a jedel ti'i ca' u cho'oo'. ");
INSERT INTO mopNT_vpl VALUES ("LK14_3","072_14_3","LUK","14","3","3","Caji ti t'an a Jesus eteloo' u yaj ca'ansajil u ley aj Moises u yet'ocoo' a fariseo u c'aba'oo' u na'ata. —¿Qui' wa tu c'axül ti'i a ley ca' ch'anesabüc a mac ti'i u q'uinil a jedele, wa ma' qui'?— cu t'an a Jesus ti'ijoo'o. ");
INSERT INTO mopNT_vpl VALUES ("LK14_4","072_14_4","LUK","14","4","4","C'u' betiqui, ma' uchoo' u nuuc. Pachili, u müchaj a c'oja'ana. U ch'anesaj. U yadaj ti'i ca' xi'ic. ");
INSERT INTO mopNT_vpl VALUES ("LK14_5","072_14_5","LUK","14","5","5","—¿Wa ca' c'axüc a tzimin wa a wacax ichil a ch'e'ene, mac ta yaame'ex ma' tu jan joc'sic ca'ax tu q'uinil a jedele?— cu t'an a Jesus ti'ijoo'o. ");
INSERT INTO mopNT_vpl VALUES ("LK14_6","072_14_6","LUK","14","6","6","Ma' paatajoo' u nuucte. ");
INSERT INTO mopNT_vpl VALUES ("LK14_7","072_14_7","LUK","14","7","7","Pues te'i. Le'ec a Jesusu, u yilaj ti tanoo' u cüxtic a quich'pan cuuchil boon a chiita'anoo' ti janal ti'i ca' tuclabüc jabix noochoo' u wichil u meyaj. U yadajoo' u tojil ti'i ich mucult'an. ");
INSERT INTO mopNT_vpl VALUES ("LK14_8","072_14_8","LUK","14","8","8","—Le'ec ca' chiitbique'ex ti'i jun p'eel tz'ocolbeele, ma' a beele'ex ti tintal tuwich a quich'pan cuuchili. Uchac chiitbi ilic a mas nooch u wichil u meyaj ta wiche'exe,— cu t'an a Jesusu. ");
INSERT INTO mopNT_vpl VALUES ("LK14_9","072_14_9","LUK","14","9","9","—Bel u ca'a aalbül te'ex u men u yumil a tz'ocolbeele: “Joq'uen wa'ye'. Bel u ca'a ti tintal a winic ada' wa'ye'e,” cu t'anac te'ex. Sudactale'ex a ca'a ca' xique'ex ti tintal tuba ma' qui' ta wiche'ex,— cu t'an a Jesusu. ");
INSERT INTO mopNT_vpl VALUES ("LK14_10","072_14_10","LUK","14","10","10","—C'u' betiqui, le'ec ca' chiitbique'ex ti janal, tinlene'ex tuba walacoo' u tintal a ma' noochoo' u wichil u meyaja. Le'ec ca' c'ochoc mac u chiitaje'ex, uchac u yadic te'ex ca' tinlaque'ex tuba mas quich'pan. Ti baalo'o, tulacal boon a c'ochoo' ti janal te'iji, beloo' u cu yila' jabix nooch u wichil a meyaje'exe,— cu t'an a Jesusu. ");
INSERT INTO mopNT_vpl VALUES ("LK14_11","072_14_11","LUK","14","11","11","—Tulacal mac a walac u tz'eec u bajil jabix nooch u wichil u meyaja, bel u ca'a ti joc'ol ti'i ti ma' nooch u wichil u meyaja. Le'ec mac ca' u tz'aa' u bajil jabix ma' nooch u wichil u meyaja, bel u ca'a tz'abül ti'i ti nooch u wichil u meyaj,— cu t'an a Jesusu. ");
INSERT INTO mopNT_vpl VALUES ("LK14_12","072_14_12","LUK","14","12","12","Pues te'i. Uchi u t'an a Jesus etel a mac u chiitaj ca' talac ti janal. —Le'ec ti tan a betic a fiestaja, ma' a chiiticoo' ca' talacoo' a amigojoo', ma'ax a witz'in, ma'ax chucul a wet'oc, ma'ax a wettzeel a ayic'ala. Jede'ecoo' u yusq'uintic u jel ti ca' u chiiteechoo' ca' xiquech ti janal eteloo',— cu t'an a Jesus ti'iji. ");
INSERT INTO mopNT_vpl VALUES ("LK14_13","072_14_13","LUK","14","13","13","—C'u' betiqui, le'ec ti tan a betic a fiestaja, chiitoo' ca' talacoo' a otzili, a but c'ü'ü, a ma' qui' u ximbala, a ch'oopo. ");
INSERT INTO mopNT_vpl VALUES ("LK14_14","072_14_14","LUK","14","14","14","Bete ti baalo' y bel u ca'a ti qui'tal a wool. Ala'oo'o, ma' tu paataloo' u yusq'uin u jel. Bel u ca'a usq'uinbil u jel u men a Dios tu q'uinil u ca' cuxtal tucaye'il a tojoo' u na'ata,— cu t'an a Jesus ti'i mac u chiitaj ca' talac ti janal. ");
INSERT INTO mopNT_vpl VALUES ("LK14_15","072_14_15","LUK","14","15","15","Pues te'i. Le'ec ca' u yubaj c'u' u yadaj a Jesusu, uchi u t'an jun tuul a que'en pach mesa ti janal etel. —Qui' u yool mac a bel u ca'a ti janal tu cuenta a Dioso,— cu t'an ti'i a Jesusu. ");
INSERT INTO mopNT_vpl VALUES ("LK14_16","072_14_16","LUK","14","16","16","—Jun tuul a winiqui, u c'atiintaj u bete' a fiestaja. Chiitboo' a yaab ca' u yiloo' a fiesta abe'e,— cu t'an a Jesusu. ");
INSERT INTO mopNT_vpl VALUES ("LK14_17","072_14_17","LUK","14","17","17","—C'ochi u q'uinil a fiesta abe'e. U tücaa'taj u yaj xa'num ca' u püyoo' boon a chiita'ana. “Ca' c'ochoque'ex ti'i a fiestaja. C'ochi u yorajil,” cu t'an ti'ijoo',— cu t'an a Jesusu. ");
INSERT INTO mopNT_vpl VALUES ("LK14_18","072_14_18","LUK","14","18","18","—C'u' betiqui, laj cajoo' u yadü' ti ma' tu paataloo' u beel. “In q'uexaj to a lu'umu. Bel to in ca'a in wila'. Adü ti'i ca' u sa'tes ten. Ma' bel in ca'a ti c'ochol,” cu t'an a jun tuulu,— cu t'an a Jesusu. ");
INSERT INTO mopNT_vpl VALUES ("LK14_19","072_14_19","LUK","14","19","19","—C'ochi etel ulaac' a jun tuulu. “In q'uexaj to diez tuul a wacax a walacoo' u meyaj. Bel to in quin yaaltoo'. Adü ti'i ca' u sa'tes ten. Ma' bel in ca'a ti c'ochol,” cu t'an ulaac' a jun tuulu,— cu t'an a Jesusu. ");
INSERT INTO mopNT_vpl VALUES ("LK14_20","072_14_20","LUK","14","20","20","—C'ochi etel ulaac' a jun tuulu. “In cüxtaj to in wütan, mentücü, ma' yan biqui in c'ochol,” cu t'an a jun tuul abe'e,— cu t'an a Jesusu. ");
INSERT INTO mopNT_vpl VALUES ("LK14_21","072_14_21","LUK","14","21","21","—Le'ec aj xa'num abe'e, usc'aji tu pach u yadü' ti'i u tz'ulil c'u' a aalbi ti'iji. Tz'iicaji u tz'ulil. “Ca' xiquech ti jomol ich caj ti calle y ti bej ca' a püyoo' a otzili, a butoo' u c'ü', a ma' qui'oo' u ximbala, a ch'oopoo'o,” cu t'an u tz'ulil ti'iji,— cu t'an a Jesusu. ");
INSERT INTO mopNT_vpl VALUES ("LK14_22","072_14_22","LUK","14","22","22","—“Noochwinic, püyboo' jabix ilic a wadaja, pero yanoo' to a cuuchil te'iji,” cu t'an u yaj xa'num ti'iji. ");
INSERT INTO mopNT_vpl VALUES ("LK14_23","072_14_23","LUK","14","23","23","“Ca' xiquech ti a carretera y ti ulaac' a beje. Talesoo' a cristiano ca' tuduc a cuuchil pach mesaja. ");
INSERT INTO mopNT_vpl VALUES ("LK14_24","072_14_24","LUK","14","24","24","Inen tan in wadic tech. Ma'ax jun tuul tu yaamoo' boon a winic a chiita'an biq'uin ado' a bel u cu yaalte in janal,” cu t'an u tz'ulil ti'iji,— cu t'an a Jesus ich mucult'an yoc'ol biqui ca' c'ümbüc a mac u men a Dioso. ");
INSERT INTO mopNT_vpl VALUES ("LK14_25","072_14_25","LUK","14","25","25","Pues te'i. Yaab a cristiano a tücünacoo' tu pach a Jesus ti tan u beele. U sutaj u bajil ti t'an eteloo'. ");
INSERT INTO mopNT_vpl VALUES ("LK14_26","072_14_26","LUK","14","26","26","—Wa yan mac u c'ati u c'ümeene, yan u c'atiintiquen tu jajil. Yan u mas c'atiintiquen tuwich tulacal ulaac', ca'ax u tat, u na' u yütan, u mejen, u sucu'un, u quic, u yitz'in, tac etel u cuxtal ilic ala'aji. Wa ma' tu betic ti baalo'o, ma' tu paatal u yocol ti'i in waj tz'ocsaj t'an,— cu t'an a Jesusu. ");
INSERT INTO mopNT_vpl VALUES ("LK14_27","072_14_27","LUK","14","27","27","—Le'ec mac a ma' tu paatal u muc'yajte boon a yaj a tan u tz'abül ti'i u men tan u tz'ocsiquen jabix cuchi tan u bensic u cruz ti tan u beel tin pacha, ma' ilic tu paatal u yocol tin waj tz'ocsaj t'an,— cu t'an a Jesusu. ");
INSERT INTO mopNT_vpl VALUES ("LK14_28","072_14_28","LUK","14","28","28","—Le'ec ti tane'ex a c'atiintic a bete' a noxi' naja, ¿mac ta yaame'ex a ma' ta'ach u tintal u tucle u tool a naj wa chucul ti'iji?— cu t'an a Jesusu. ");
INSERT INTO mopNT_vpl VALUES ("LK14_29","072_14_29","LUK","14","29","29","—Wa ma' tu betic ti baalo'o, le'ec ti caac u bete' a naja, uchac ma' tu paatal u jobes. Tulacal mac ca' u yila' ti baalo'o, beloo' u cu p'a'aste. ");
INSERT INTO mopNT_vpl VALUES ("LK14_30","072_14_30","LUK","14","30","30","“Ca wilic. Ma' ilic paataji a winic u bete' a naja,” cu t'anacoo',— cu t'an a Jesus yoc'ol mac u c'ati ocol ti'i u yaj tz'ocsaj t'ana. ");
INSERT INTO mopNT_vpl VALUES ("LK14_31","072_14_31","LUK","14","31","31","—Baalo' ilic a reye. Le'ec ti tan u tuclic a p'isbaj etel ulaac' a reye, yan u paye' tintal u tucloo' wa jede'ec u paatal ti ganara. Uchac yan diez mil tuul u soldadojo. Uchac yan veinte mil tuul u soldado u yettz'iiquil a wataca. ");
INSERT INTO mopNT_vpl VALUES ("LK14_32","072_14_32","LUK","14","32","32","Wa ma' jede'ec u paatal ti ganara, le'ec ti naach to que'en u yettz'iiquili, bel u cu tücaa'te ca' emsabüc u yool ca' qui'ac etel,— cu t'an a Jesusu. ");
INSERT INTO mopNT_vpl VALUES ("LK14_33","072_14_33","LUK","14","33","33","—Baalo' ilic etel mac u c'ati ocol ti'i in waj tz'ocsaj t'an. Yan u tz'eec u yool tin pach tu jajil jabix tan u p'ütic tulacal a c'u' ulaac' a yan ti'iji. Wa ma'a, ma' tu paatal u yocol ti'i in waj tz'ocsaj t'an,— cu t'an a Jesusu. ");
INSERT INTO mopNT_vpl VALUES ("LK14_34","072_14_34","LUK","14","34","34","—Ala'oo'o, jabix a taaba. Le'ec a taaba, qui', pero ca' joboc u ch'ooch'ili, ¿biqui ca' ti tz'aa' u ch'ooch'il tucaye'il? ");
INSERT INTO mopNT_vpl VALUES ("LK14_35","072_14_35","LUK","14","35","35","Ma' yan u c'abeetil ma'ax xan ti'i u tz'ac lu'um. Chen walac u pulbul. Le'ec mac jede'ec u paatal u ch'a'ic u tojili, ca' u ch'aa' u tojil,— cu t'an a Jesus ti'ijoo' a cristiano u men ma'ax c'u' aj beel mac ca' u c'ümü' ala'i ca' tun u p'ütü' tucaye'il. ");
INSERT INTO mopNT_vpl VALUES ("LK15_1","072_15_1","LUK","15","1","1","Pues te'i. Jun p'eel q'uin much'lajoo' ti yaab aj mol taq'uin ti'i a gobiernojo, u yet'ocoo' a top yaab u sip'ili. Tanoo' u naatz'ül u yubi u t'an a Jesusu. ");
INSERT INTO mopNT_vpl VALUES ("LK15_2","072_15_2","LUK","15","2","2","Le'ecoo' a fariseo u c'aba'oo' u na'ata, u yet'ocoo' u yaj ca'ansajil u ley aj Moisese, cajoo' ti p'a'as. —Le'ec a winic ada'a, top walac u c'ümicoo' a yanoo' u sip'ili. Walac u janal eteloo',— cu t'anoo'. ");
INSERT INTO mopNT_vpl VALUES ("LK15_3","072_15_3","LUK","15","3","3","U men u yadajoo' abe'e, nuucboo' ich mucult'an u men a Jesusu. ");
INSERT INTO mopNT_vpl VALUES ("LK15_4","072_15_4","LUK","15","4","4","—Jun tuul a winiqui, yan u carnero cien tuul. Wa cuchi ca' sa'tüc ti'i a jun tuulu, bel u cu p'ütoo' a noventa y nueve tuul tuba tanoo' u janal. Bel u ca'a u cüxte a jun tuul a sa'ti asto u cüxtic. Tulacal a jujun tuule'exe, jede'eque'ex ilic a betic ti baalo',— cu t'an a Jesusu. ");
INSERT INTO mopNT_vpl VALUES ("LK15_5","072_15_5","LUK","15","5","5","—Le'ec ca' u cüxte a sa'tiji, qui' u yool. Bel u ca'a u c'oochte. ");
INSERT INTO mopNT_vpl VALUES ("LK15_6","072_15_6","LUK","15","6","6","Le'ec ca' c'ochoc tu yotocho, bel u cu püyoo' u amigojoo' eteloo' u yettzeel. “Qui'aque'ex ilic a wool inche'exe. In cüxtaj a carnero a sa'ti tene,” cu t'an ti'ijoo',— cu t'an a Jesusu. ");
INSERT INTO mopNT_vpl VALUES ("LK15_7","072_15_7","LUK","15","7","7","—Inen tan in wadic te'ex. Le'ec ca' u jele' u tucul u p'ütü' u bete' a c'as jun tuul a yan u sip'il jabix ala'oo' a que'en tin tzeele, walac u yantal a qui'-oolal ti ca'an tu jajil. Mas qui'oo' u yool etel a jun tuul abe'e, tuwich etel a noventa y nueve tuul a tojoo' u na'at a ma' tzaj u jelicoo' u tucul,— cu t'an a Jesus ti'ijoo'o. ");
INSERT INTO mopNT_vpl VALUES ("LK15_8","072_15_8","LUK","15","8","8","—Pues te'i. Jun tuul ix ch'upu, yan u taq'uin diez p'eel, Wa cuchi ca' sa'tüc ti'i a jun p'eele, bel u cu tübü' a lampara ti'i ca' sasilac a ich naja. Bel u cu miiste a ichnaja. Bel u cu tz'a' u yool u cüxte asto u cüxtic. ¿Ma' wa baalo'?— cu t'an a Jesusu. ");
INSERT INTO mopNT_vpl VALUES ("LK15_9","072_15_9","LUK","15","9","9","—Le'ec ca' u cüxteje, bel u cu püyoo' u amigo eteloo' u yettzeel. “Qui'aque'ex ilic a wool inche'exe. In cüxtaj in taq'uin a sa'tiji,” cu t'an ti'ijoo'. ");
INSERT INTO mopNT_vpl VALUES ("LK15_10","072_15_10","LUK","15","10","10","Inen tan in wadic te'ex. baalo' ilic ti walac u qui'taloo' u yool u yaj xa'num a Dios ti ca'an le'ec ca' tojac u na'at jun tuul a yan u sip'il jabix ala'oo' a que'en tin tzeel,— cu t'an a Jesusu. ");
INSERT INTO mopNT_vpl VALUES ("LK15_11","072_15_11","LUK","15","11","11","—Pues te'i. Jun tuul a winiqui, yan u mejen ca' tuul. ");
INSERT INTO mopNT_vpl VALUES ("LK15_12","072_15_12","LUK","15","12","12","“Tat,” cu t'an a itz'intzil ti'i u tata. “Tz'a ten boon a ayic'alil a bel u ca'a ti p'aatül tene,” cu t'an ti'i u tat. U t'oxaj u ayic'alil ti'ijoo' u mejen,— cu t'an a Jesusu. ");
INSERT INTO mopNT_vpl VALUES ("LK15_13","072_15_13","LUK","15","13","13","—Ma' top yaab q'uin a manüc ti ca' u much'quintaj u ayic'alil a itz'intzili. Joq'ui te'i. Bini ti ulaac' caj ti naach. U sütaj u taq'uin tanil u betic a ca'ax c'u'ac ti c'asili. ");
INSERT INTO mopNT_vpl VALUES ("LK15_14","072_15_14","LUK","15","14","14","Le'ec ti jobi tulacal u taq'uini, caji a wi'ijil tu jajil ichil a caj abe'e. A itz'intzili, caji u yubi u yajil a wi'ijili, ");
INSERT INTO mopNT_vpl VALUES ("LK15_15","072_15_15","LUK","15","15","15","mentücü, u cüxtaj u naal etel jun tuul a que'en te'iji. Tücaa'bi ichil u cuuch meyaj ti tzen eq'uen. ");
INSERT INTO mopNT_vpl VALUES ("LK15_16","072_15_16","LUK","15","16","16","U c'atiintaj ilic cuchi u jante a jabix bitz a tan u tz'eec ca' u jantoo' a eq'uene. C'u' betiqui, ma'ax c'u' a tz'abi ti'iji. ");
INSERT INTO mopNT_vpl VALUES ("LK15_17","072_15_17","LUK","15","17","17","Pues te'i. C'aji u winiquil a itz'intzili. “Yanoo' u yaj meyaj in tata. Ma' pataloo' u jante boon a walacoo' u tz'abül ti'iji. C'u' betiqui, wa'ye' tan in quimil u men wi'ijil,” cu t'an tu bajil. ");
INSERT INTO mopNT_vpl VALUES ("LK15_18","072_15_18","LUK","15","18","18","“Bel in ca'a ti joc'ol wa'ye'. Bel in ca'a etel in tat. Bel in quin wadü' ti'i: “Tat, yan in sip'il ti'i a Dioso. Yan ilic in sip'il tech. ");
INSERT INTO mopNT_vpl VALUES ("LK15_19","072_15_19","LUK","15","19","19","Ma' qui' ca' a wileen jabixen a mejene. Mas qui' ca' a wileen jabixen jun tuul a waj meyaja. Baalo' ca' in wadü' ti'i,” cu t'an tu bajil,— cu t'an a Jesusu. ");
INSERT INTO mopNT_vpl VALUES ("LK15_20","072_15_20","LUK","15","20","20","—Pues te'i. Joq'ui. Bini etel u tat. Naach to que'en ma' c'ochoc ti ilbi u men u tat. Qui'aji u yool u tat. Alca' ti bini u c'ümü' u mejen. U meectaj. U yutzintaj,— cu t'an a Jesusu. ");
INSERT INTO mopNT_vpl VALUES ("LK15_21","072_15_21","LUK","15","21","21","—“Tat, yan in sip'il ti'i a Dioso. Yan ilic in sip'il tech. Ma' qui' ca' a wileen jabixen a mejene,” cu t'an ti'i u tat. ");
INSERT INTO mopNT_vpl VALUES ("LK15_22","072_15_22","LUK","15","22","22","“Tales a noc' a quich'pana. Sebac. Cünü ti'i. Tz'a u tz'üpütc'ü' tu c'ü'ü. Cünü u zapato tu yoc,” cu t'an u tat ti'i u yaj meyaj. ");
INSERT INTO mopNT_vpl VALUES ("LK15_23","072_15_23","LUK","15","23","23","“Tales aj meen wacax ti quelemcuntaj ti'i fiesta. Quimes. Co'ne'ex ti janal. Co'ne'ex ti bete' a fiestaja. ");
INSERT INTO mopNT_vpl VALUES ("LK15_24","072_15_24","LUK","15","24","24","Le'ec in mejen ada'a, jabix quimen tene, pero ca' cuxlaji. Sa'ti biq'uin ado'o, pero ca' udi,” cu t'an u tat. Cajoo' u bete' a fiestaja,— cu t'an a Jesusu. ");
INSERT INTO mopNT_vpl VALUES ("LK15_25","072_15_25","LUK","15","25","25","—Pues te'i. Que'en to ich col a sucu'untzili. Le'ec ti tan u yusc'ala, naatz'i tu tzeel a naja. U yubaj a sono. Tan a ocoto. ");
INSERT INTO mopNT_vpl VALUES ("LK15_26","072_15_26","LUK","15","26","26","Le'ec a sucu'untzili, u püyaj jun tuul aj meyaja. “¿C'u' a tan u manülü?” cu t'an ti'i. ");
INSERT INTO mopNT_vpl VALUES ("LK15_27","072_15_27","LUK","15","27","27","“Udi a witz'in. Qui' u yool a tat ti udi. Ma' c'oja'ani. U tz'aj ti quimsabül aj meen wacax a quelemcunbiji,” cu t'an ti'i. ");
INSERT INTO mopNT_vpl VALUES ("LK15_28","072_15_28","LUK","15","28","28","C'u' betiqui, tz'iicaji a sucu'untzili. Ma' u c'ati ocol ich naj. Joq'ui a tattzil pach naja. U yaaltaj u qui'cunte u yool. ");
INSERT INTO mopNT_vpl VALUES ("LK15_29","072_15_29","LUK","15","29","29","“C'aac tech boon jaab uchuc in meyaj ta wetel. Ma'ax jun sut wa ma' in tz'ocsaj a t'an. C'u' betiqui, ma' a tz'aj ten ma'ax jun tuul a cabro ti'i in betical a fiesta eteloo' in amigo,” cu t'an ti'i u tat ti uchi u nuuc. ");
INSERT INTO mopNT_vpl VALUES ("LK15_30","072_15_30","LUK","15","30","30","“C'u' betiqui, le'ec ti udi a mejen abe'e, a tz'aj ti quimsabül aj meen wacax a quelemcunbiji. Ala'aji, chen u sütaj a ayic'alil etel ix c'ac'as ch'up,” cu t'an ti'i u tat. ");
INSERT INTO mopNT_vpl VALUES ("LK15_31","072_15_31","LUK","15","31","31","“Yum, que'en ti que'enech tin wetel. Tulacal a c'u' a yan tene, tech,” cu t'an a tattzili. ");
INSERT INTO mopNT_vpl VALUES ("LK15_32","072_15_32","LUK","15","32","32","“Yan ti betic a fiestaja. Yan u qui'tal ti wool. Le'ec a witz'ini, jabix quimen to'ono, pero ca' cuxlaji. Sa'ti biq'uin ado'o, pero ca' udi,” cu t'an u tat ti'i u mejen,— cu t'an a Jesus yoc'ol u c'üm-oolbaanül a Dios u menoo' a mac a yanoo' u sip'il jabix ala'oo' a que'enoo' tu tzeele. ");
INSERT INTO mopNT_vpl VALUES ("LK16_1","072_16_1","LUK","16","1","1","Pues te'i. Uchi ilic u t'an a Jesus eteloo' u yaj cambala. —Jun tuul a ayic'ala, yan u yaj cananiloo' u yaj meyaj. Le'ec aj canan abe'e, tzolbi ti'i u tz'ulil ti tan u sütic u ayic'alil u tz'ulil,— cu t'an a Jesus ti'ijoo' u yaj cambala. ");
INSERT INTO mopNT_vpl VALUES ("LK16_2","072_16_2","LUK","16","2","2","—Le'ec u tz'ulili, u püyaj aj canan abe'e. “Yan a c'u' a aalbi ten ta woc'olo. Tz'iibte ten boon in ayic'alil in tz'aj tech ca' a cününteje. Bel a ca'a ti joc'ol ichil a meyaj,” cu t'an ti'i. ");
INSERT INTO mopNT_vpl VALUES ("LK16_3","072_16_3","LUK","16","3","3","“Le'ec in tz'ulili, tan u joc'siquen ichil in meyaj. ¿C'u' a yan in betic aleebe?” cu t'an aj canan abe' tu bajili. “Ma' yan in muc' ti'i in wocol ichil a meyaj jabix a paan lu'umu. Top sudaquen ca' manüquen ti matan taq'uin,” cu t'an tu bajil. ");
INSERT INTO mopNT_vpl VALUES ("LK16_4","072_16_4","LUK","16","4","4","“In weel c'u' a ca' in bete' ca' u c'ümeenoo' a cristiano ti posado le'ec ca' joc'oquen ichil in meyaj,” cu t'an tu bajil,— cu t'an a Jesusu. ");
INSERT INTO mopNT_vpl VALUES ("LK16_5","072_16_5","LUK","16","5","5","Jujun tuulil u püyajoo' boon a yanoo' u p'ax etel u tz'ulili. “¿Boon u yaabil a p'ax etel in tz'ulil?” cu t'an ti'i a jun tuulu. ");
INSERT INTO mopNT_vpl VALUES ("LK16_6","072_16_6","LUK","16","6","6","“Le'ec in p'ax inene, cien lata ti aceite olivo,” cu t'an ti'i. “Tales u ju'umil a p'ax. Tinlen. Seebte a bajil. Cincuenta lata ilic a p'ax ca' a tz'iibte,” cu t'an ti'i. ");
INSERT INTO mopNT_vpl VALUES ("LK16_7","072_16_7","LUK","16","7","7","“¿Boon u yaabil a p'ax incheche?” cu t'an ti'i ulaac' a jun tuulu. “Cien p'is u semilla a harina in p'ax inene,” cu t'an ti'i. “Tales u ju'umil a p'ax. Tz'iibte ti jadi' ochenta p'is a p'ax,” cu t'an ti'i. ");
INSERT INTO mopNT_vpl VALUES ("LK16_8","072_16_8","LUK","16","8","8","“Top patalech a cho'en,” cu t'an u tz'ulil ti'i u yaj cananil u meyaj abe' u men top seeb u yool. Le'ecoo' a cristiano yoc'olcaba, mas seeboo' u yool u bete' c'u' a ti'i a yoc'olcab tuwichoo' a cristiano a ti'i a Dios ca' u betoo' c'u' a ti'i a ca'ana,— cu t'an a Jesusu. ");
INSERT INTO mopNT_vpl VALUES ("LK16_9","072_16_9","LUK","16","9","9","—Inen tan in wadic te'ex,— cu t'an ti'ijoo' u yaj cambal. —Ca' a yancunte'ex a amigojoo' tanil a waanticale'exoo' etel c'u' a yan te'ex yoc'olcaba. Le'ec ca' joboc a cuxtale'ex wa'ye' yoc'olcaba, bele'ex a ca'a c'ümbül u menoo' ichil a cuuchile'ex a ma' yan q'uin u jobolo,— cu t'an a Jesus ti'ijoo' u yaj cambala. ");
INSERT INTO mopNT_vpl VALUES ("LK16_10","072_16_10","LUK","16","10","10","—Le'ec mac tan u betic a toj etel a tz'etz'eeque, etel a yaaba, jede'ec ilic u betic a tojo. Baalo' ilic mac a tan u betic a ma' toj etel a tz'etz'eeque, etel a yaaba, jede'ec ilic u betic ti ma' toj,— cu t'an a Jesusu. ");
INSERT INTO mopNT_vpl VALUES ("LK16_11","072_16_11","LUK","16","11","11","—Wa cuchi ma' a betaje'ex a toj etel a ayic'alil yoc'olcaba, ¿mac ca' u tz'aa' te'ex a jajil ayic'alil le'ec a walac u tal ti ca'ana?— cu t'an a Jesusu. ");
INSERT INTO mopNT_vpl VALUES ("LK16_12","072_16_12","LUK","16","12","12","—Wa cuchi ma' a betaje'ex a toj etel u ayic'alil ulaac' mac a tz'abi ta c'ü'e'exe, ¿mac ca' u tz'aa' te'ex a ayic'alil a te'ex ilic a tali ti ca'ana?— cu t'an a Jesusu. ");
INSERT INTO mopNT_vpl VALUES ("LK16_13","072_16_13","LUK","16","13","13","—Jun tuul aj meyaja, ma' tu paatal u betic u meyaj ti qui' ti ca' tuul u tz'ulil. Wa ma' motz ti'i a jun tuul y yaj u yubi ulaac' a jun tuulu, bel u cu tz'aa' u yool tu pach a jun tuulu, y bel u cu motzinte ulaac' a jun tuulu. Ma' tu paatal a tz'eeque'ex a wool ich ca' xeel tu pach a Dioso, y tu pach a taq'uini,— cu t'an a Jesusu. ");
INSERT INTO mopNT_vpl VALUES ("LK16_14","072_16_14","LUK","16","14","14","Pues te'i. Le'ecoo' a fariseo u c'aba'oo' u na'ata, u yubajoo' tulacal a t'an abe'e. Ala'oo'o, top que'enoo' u yool tu pach a taq'uini. U ye'ajoo' etel u wich ti ma' c'ocha'anoo' tu xiquin u t'an a Jesusu. ");
INSERT INTO mopNT_vpl VALUES ("LK16_15","072_16_15","LUK","16","15","15","—Inche'exe, walaque'ex a tz'eec a bajil jabix toje'ex a na'at tu taanoo' a cristianojo,— cu t'an a Jesusu. —C'u' betic a Dioso, u yeel biqui yanile'ex a püsüc'al. Top qui' tu wich a cristiano u tz'eec u bajil jabix top u yeele, pero top ma' qui' tu wich a Dios a baalo'o,— cu t'an a Jesusu. ");
INSERT INTO mopNT_vpl VALUES ("LK16_16","072_16_16","LUK","16","16","16","—Pues te'i. Le'ec a ley u tz'iibtaj aj Moises etel boon a t'an u tz'iibtajoo' mac u yadajoo' u t'an a Dios uchiji, yan u c'abeetil asto ti jobi u meyaj aj Juan aj tz'aj ocja'a. Tu pach abe'e, caji aalbül a qui'il t'an le'ec biqui ti walac u tücaa' a Dioso. Tulacaloo' a cristianojo, tanoo' u tutulca'tic u bajil ti'i ca' ococ tu c'ü' a Dioso,— cu t'an a Jesusu. ");
INSERT INTO mopNT_vpl VALUES ("LK16_17","072_16_17","LUK","16","17","17","—Mas yaj u joc'sabül u muc' ca'ax jun p'eel t'an ichil a ley u tz'iibtaj aj Moises tuwich u jobsabül tulacal a yoc'olcab tac etel a ca'ana,— cu t'an a Jesusu. ");
INSERT INTO mopNT_vpl VALUES ("LK16_18","072_16_18","LUK","16","18","18","—Pues te'i. Tulacal a mac ca' u p'ütü' u yütan ca' u cüxte ulaac' u yütana, chen tan u c'ac'as cüjtal etel. Tulacal a mac ca' u ch'aa' ix ch'up a p'ütbi u men u yichama, chen tan ilic u c'ac'as cüjtal etel,— cu t'an a Jesusu. ");
INSERT INTO mopNT_vpl VALUES ("LK16_19","072_16_19","LUK","16","19","19","—Pues te'i. Yan jun tuul a winiqui, ayic'al. Yan u noc' a jabix u color ix yamese. Yan a pimi. Co'oj abe'e. Qui' a walac u jantic sansamal,— cu t'an a Jesusu. ");
INSERT INTO mopNT_vpl VALUES ("LK16_20","072_16_20","LUK","16","20","20","—Yan ilic jun tuul a otzili, aj Lazaro u c'aba'. Coyquinbi tu chi' u cotil u yotoch a ayic'al abe'e. Top yaab a xoox yoc'olo. ");
INSERT INTO mopNT_vpl VALUES ("LK16_21","072_16_21","LUK","16","21","21","U c'atiintaj cuchi ca' tzeenbec etel u yada' u janal a ayic'ala. Le'ecoo' a peq'ue, walacoo' u c'ochol u leetzte u xoox,— cu t'an a Jesusu. ");
INSERT INTO mopNT_vpl VALUES ("LK16_22","072_16_22","LUK","16","22","22","—Quimi a otzil winiqui. Bensabi u pixan tu cuuchil etel aj quimen Abraham u menoo' u yaj xa'num a Dios ti ca'ana. Quimi ilic a ayic'ala. Mucbi,— cu t'an a Jesusu. ");
INSERT INTO mopNT_vpl VALUES ("LK16_23","072_16_23","LUK","16","23","23","—Tan u c'ümic a yaj ichil u cuuchil a pula'ana. Uchi u cha'an ti naach. U yilaj tuba que'en aj Abrahama. U yilaj ilic aj Lazaro etele,— cu t'an a Jesusu. ");
INSERT INTO mopNT_vpl VALUES ("LK16_24","072_16_24","LUK","16","24","24","—“Mamaa' Abraham,” cu t'an ti chich. “Ch'a'a in wotzilil. Tücaa'te aj Lazaro ca' u tzümü' ca'ax bibiila' u ni' u c'ü' ich ja' ca' u tz'aa' tin wac'. Top tan in c'ümic a yaj ichil a c'aac' ada'a,” cu t'an ti'i aj Abrahama,— cu t'an a Jesusu. ");
INSERT INTO mopNT_vpl VALUES ("LK16_25","072_16_25","LUK","16","25","25","—“Yum, c'aac tech ti qui' a c'ümaj ti cuxa'anech to. C'aac tech boon a yaj u c'ümaj aj Lazarojo. C'u' betic aleebe, tan u c'ümic a qui' wa'ye' y incheche, tan a c'ümic a yaja,” cu t'an aj Abraham ti'iji,— cu t'an a Jesusu. ");
INSERT INTO mopNT_vpl VALUES ("LK16_26","072_16_26","LUK","16","26","26","—“Ma' jadi' abe'e, yan a noxi' ch'e'en tiqui yaama. Ti baalo'o, ma'ax mac jede'ec u paatal ti manül ta wetel ca'ax u c'atoo'. Ma'ax tu paatal u joc'ol tuba que'enech ti'i ca' manücoo' wa'ye',” cu t'an aj Abrahama,— cu t'an a Jesusu. ");
INSERT INTO mopNT_vpl VALUES ("LK16_27","072_16_27","LUK","16","27","27","—“Mamaa', wa ma' yan biqui u talele, tücaa'te tu yotoch in tat. ");
INSERT INTO mopNT_vpl VALUES ("LK16_28","072_16_28","LUK","16","28","28","Yan cinco tuul in sucu'un in witz'in xidal. In c'ati cuchi ca' xi'ic aalbül ti'ijoo' ti'i ma' u taleloo' ichil a c'asil ada'a,” cu t'an ti'i aj Abrahama,— cu t'an a Jesusu. ");
INSERT INTO mopNT_vpl VALUES ("LK16_29","072_16_29","LUK","16","29","29","—“Yan a t'an a tz'iiba'an u men aj Moises eteloo' boon u yadajoo' u t'an a Dios uchiji. Etel a c'u' a tz'iiba'an u men ala'oo'o, jede'ecoo' u yeeltiqui,” cu t'an aj Abraham ti'iji. ");
INSERT INTO mopNT_vpl VALUES ("LK16_30","072_16_30","LUK","16","30","30","“Mamaa' Abraham, ma' tu yubicoo'. C'u' betiqui, wa ca' xi'ic jun tuulac a ca' cuxlaji tu yaamoo' a quimene, jede'ec u jelicoo' u tuculu,” cu t'an u yaalbül aj Abrahama,— cu t'an a Jesusu. ");
INSERT INTO mopNT_vpl VALUES ("LK16_31","072_16_31","LUK","16","31","31","—“Wa ma' tu yubicoo' u t'an aj Moises eteloo' boon u yadajoo' u t'an a Dios uchiji, ma'ax tu jelicoo' u tucul wa ca' cuxlac jun tuulac tu yaamoo' a quimene,” cu t'an aj Abraham ti'iji,— cu t'an a Jesusu. ");
INSERT INTO mopNT_vpl VALUES ("LK17_1","072_17_1","LUK","17","1","1","—Pues te'i. Yan ti yan a cristiano a bel u cu yaalte u yemese'ex a wool ca' a bete'ex a c'asa. Top yaj a bel u cu c'ümü' mac tan u betic abe'e,— cu t'an a Jesus ti'ijoo' u yaj tz'ocsaj t'an. ");
INSERT INTO mopNT_vpl VALUES ("LK17_2","072_17_2","LUK","17","2","2","—Mas qui' cuchi ca' c'üxbüc a noxi' ca' tu cal ca' pulbuc ich c'ac'naab yoc'ol ma' u yemsic u yool ca' u cüxte u sip'il jun tuul u c'ümaj to u t'an a Dioso,— cu t'an a Jesusu. ");
INSERT INTO mopNT_vpl VALUES ("LK17_3","072_17_3","LUK","17","3","3","—Cününte'ex a bajil. Wa ca' u cüxte u sip'il ulaac' a hermano ta wetele, tze'ecte. Wa ca' u jele' u tuculu, sa'tes u sip'il. ");
INSERT INTO mopNT_vpl VALUES ("LK17_4","072_17_4","LUK","17","4","4","Ca'ax u cüxte u sip'il ta wetel siete sutac, le'ec a jujun sut ca' u c'aate, yan a sa'tesic ti'i ti'i ilic a q'uin abe'e,— cu t'an a Jesus ti'ijoo' u yaj tz'ocsaj t'ana. ");
INSERT INTO mopNT_vpl VALUES ("LK17_5","072_17_5","LUK","17","5","5","Pues te'i. —Ca' tz'a to'on ti mas que'enac ti wool ta pach,— cu t'anoo' u yaj xa'num ti'i a Noochtzili. ");
INSERT INTO mopNT_vpl VALUES ("LK17_6","072_17_6","LUK","17","6","6","—Wa cuchi ca'ax jabix u nec' ix mostaza, baalo' ilic cuchi que'ene'ex a wool pach a Dioso, qui' cuchi. Jede'ec cuchi u paatale'ex a tücaa'tic a che' a jabix ada' ca' jotz'boc ca' püc'büc ich c'ac'naab, y jede'ec u yuchulu,— cu t'an a Jesusu. ");
INSERT INTO mopNT_vpl VALUES ("LK17_7","072_17_7","LUK","17","7","7","—Pues te'i. Uchac yan jun tuul ta yaame'ex a yan u q'uexbil mozo. Uchac tan u paan lu'um. Uchac tan u cünün carnero. Le'ec ca' usc'ac ichil u meyaja, ¿mac ta yaame'ex jede'ec u yadic ti'i ca' manüc ti jomol pach mesa ti janal? ");
INSERT INTO mopNT_vpl VALUES ("LK17_8","072_17_8","LUK","17","8","8","Ma' wa baala' ca' u yadü' ti'i: “Utzquinte in janal. Jele a noc'. Tales in janal. Le'ec ca' joboquen ti janal ti uc'ulu, ca' tun janüquech,” cu t'an ti'i,— cu t'an a Jesusu. ");
INSERT INTO mopNT_vpl VALUES ("LK17_9","072_17_9","LUK","17","9","9","—Ma' tu yadic bo'tic ti'i u mozo u men u betaj jadi' a c'u' a aalbi ti'iji,— cu t'an a Jesusu. ");
INSERT INTO mopNT_vpl VALUES ("LK17_10","072_17_10","LUK","17","10","10","—Baalo' ilic inche'exe. Le'ec ca' joboc a betique'ex tulacal a c'u' a aalbi te'exe, yan a wadique'ex: “Ino'ono, jabix ca'ax c'u'ac ti aj meyajilo'ono. Jadi' c'u' a tz'abi to'on ca' ti bete'e, jadi' ti betaj,” que'exac,— cu t'an a Jesus ti'ijoo' u yaj cambala. ");
INSERT INTO mopNT_vpl VALUES ("LK17_11","072_17_11","LUK","17","11","11","Pues te'i. Que'en a Jesus tu benil Jerusalen tu yaam u cuenta Galilea etel u cuenta Samariaja. ");
INSERT INTO mopNT_vpl VALUES ("LK17_12","072_17_12","LUK","17","12","12","Le'ec ti c'ochi ichil jun p'eel a aldeaja, c'ümbi u men diez tuul a c'oja'ana. Tanoo' u tu'ujtal u büq'uel u menoo' u c'oja'anil. Wa'lajoo' ti naach ti t'an etel. ");
INSERT INTO mopNT_vpl VALUES ("LK17_13","072_17_13","LUK","17","13","13","—Jesus, Maestro, ch'a'a ti wotzilil,— cu t'anoo' ti'i ti chich. ");
INSERT INTO mopNT_vpl VALUES ("LK17_14","072_17_14","LUK","17","14","14","Ilboo' u men a Jesusu. —Xene'ex a yee' a bajile'ex ti'ijoo' u yaj mansaj t'an a cristiano ti'i a Dioso,— cu t'an ti'ijoo'. Taniloo' u beele, ch'anoo'. ");
INSERT INTO mopNT_vpl VALUES ("LK17_15","072_17_15","LUK","17","15","15","Jun tuul tu yaamoo' a diez tuulu, u yilaj ti ch'ani. Joq'ui tu yaamoo'. Usc'aji tu pach. Chich u t'an ti tan u yadic u qui'il a Dioso. ");
INSERT INTO mopNT_vpl VALUES ("LK17_16","072_17_16","LUK","17","16","16","Xonlaji tu taan a Jesusu. U yemsaj u wich ti lu'um. U yadaj a bo'tic ti'i a Jesusu. Le'ec a ch'aniji, jun tuul aj Samariajil, y motztziloo' aj Samariajil u menoo' aj Israele. ");
INSERT INTO mopNT_vpl VALUES ("LK17_17","072_17_17","LUK","17","17","17","—¿Ma' wa diez tuule'ex a ch'ane'exe? ¿Tuba que'en u chucaan a nueve tuulu?— cu t'an a Jesus ti'iji. ");
INSERT INTO mopNT_vpl VALUES ("LK17_18","072_17_18","LUK","17","18","18","—¿Ma' wa yan ulaac' tu yaamoo' u c'atiintajoo' u yusc'al tu pach u yadü' u qui'il a Dioso? Jadi' a tali ich ulaac' a caja, jadi' u tz'aj a bo'tiqui,— cu t'an a Jesusu. ");
INSERT INTO mopNT_vpl VALUES ("LK17_19","072_17_19","LUK","17","19","19","—U men a tz'ocsaj ti patalene, ch'aneech. Liq'uen. U paatal a beele,— cu t'an a Jesus ti'i a xona'an tu taana. ");
INSERT INTO mopNT_vpl VALUES ("LK17_20","072_17_20","LUK","17","20","20","Pues te'i. Le'ecoo' a fariseo u c'aba'oo' u na'ata, u c'aatajoo' ti'i a Jesus biq'uin to u c'ochol u q'uinil u caal ti tücaa' a Dioso. —Ma' ta wilique'ex u p'is le'ec biq'uin u c'ochol u q'uinil u caal ti tücaa' a Dioso,— cu t'an a Jesus ti uchi u nuuc. ");
INSERT INTO mopNT_vpl VALUES ("LK17_21","072_17_21","LUK","17","21","21","—U'ye'ex in t'an. Ma' bel u ca'a aalbül wa wa'ye' que'en wa tac tedo' que'en u men caji tun ti tücaa' ta yaame'ex,— cu t'an a Jesusu. ");
INSERT INTO mopNT_vpl VALUES ("LK17_22","072_17_22","LUK","17","22","22","—Pues te'i. C'ochol u ca'a u q'uinil ti bele'ex a ca'a a c'atiinteen a yanajeen ti cristianojil ta yaame'ex jabix aleebe, pero ma' tu paatal,— cu t'an a Jesus ti'ijoo' u yaj cambala. ");
INSERT INTO mopNT_vpl VALUES ("LK17_23","072_17_23","LUK","17","23","23","—Bel u ca'a aalbül te'ex ti tedo' que'en wa xan wa'ye' que'en. Ma' a beele'ex te'i, ma'ax a tz'ocsique'exoo' u t'an. ");
INSERT INTO mopNT_vpl VALUES ("LK17_24","072_17_24","LUK","17","24","24","Le'ec ti tan u c'aac' a lemleme, ti naach chica'an u sac tuwich a yoc'olcaba. Baalo' ilic ti chiclaquen a yanajeen ti cristianojil tu q'uinil in wudele,— cu t'an a Jesusu. ");
INSERT INTO mopNT_vpl VALUES ("LK17_25","072_17_25","LUK","17","25","25","—C'u' betiqui, payanbej yan in c'ümic ti yaab a yaja. Yan ilic in culpachbül u menoo' a cristiano a cuxa'anoo' aleebe,— cu t'an a Jesusu. ");
INSERT INTO mopNT_vpl VALUES ("LK17_26","072_17_26","LUK","17","26","26","—Jabix ilic u betajoo' ti a q'uin ti cuxa'an to aj Noeje, baalo' ilic a beloo' u cu bete' a cristiano ti nütz'ünac u q'uinil in wudel a yanajeen ti cristianojili. ");
INSERT INTO mopNT_vpl VALUES ("LK17_27","072_17_27","LUK","17","27","27","Tanoo' u janal. Tanoo' u yuc'ul. Tanoo' u cüxtic u yicham y u yütan, asto ti c'ochi u q'uinil u yocol aj Noe ichil a barcojo. Tudi a yoc'olcab etel ja'a, y laj jobsaboo',— cu t'an a Jesusu. ");
INSERT INTO mopNT_vpl VALUES ("LK17_28","072_17_28","LUK","17","28","28","—Baalo' ilic xan u betajoo' ti'i u q'uinil ti cuxa'an to aj Loto. Tanoo' u janal. Tanoo' u yuc'ul. Tanoo' u q'uex. Tanoo' u conol. Tanoo' u pac'. Tanoo' u men naj. ");
INSERT INTO mopNT_vpl VALUES ("LK17_29","072_17_29","LUK","17","29","29","C'u' betiqui, le'ec tu q'uinil ti joq'ui aj Lot ich caj Sodomaja, tali a c'aac' etel a azufre ti ca'ana. Laj jobsaboo'. ");
INSERT INTO mopNT_vpl VALUES ("LK17_30","072_17_30","LUK","17","30","30","Baalo' ilic ti beloo' u ca'a u bete' a cristiano asto ti c'ochoc u q'uinil in chictal a yanajeen ti cristianojil,— cu t'an a Jesus ti'ijoo' u yaj cambala. ");
INSERT INTO mopNT_vpl VALUES ("LK17_31","072_17_31","LUK","17","31","31","—Le'ec mac a que'en pach naj tu q'uinil abe'e, ma' qui' ca' xi'ic ichil u yotoch u molo' a c'u' ti'iji. Sabeensil u müchbül. Jadi' qui' u puutz'ul. Baalo' ilic mac a que'en ich col. Ma' qui' ca' usc'ac tu yotoch u molo' a c'u' ti'iji,— cu t'an a Jesusu. ");
INSERT INTO mopNT_vpl VALUES ("LK17_32","072_17_32","LUK","17","32","32","—C'aac te'ex ti quimi u yütan aj Lot u men u sutaj u bajil ti cha'an tu pach. ");
INSERT INTO mopNT_vpl VALUES ("LK17_33","072_17_33","LUK","17","33","33","Le'ec mac a top yaj u yubi u cuxtal wa'ye'e, bel u ca'a ti sa'tül u cuxtal ti ca'an. Le'ec mac a ma' tan u yacuntic u cuxtal wa'ye' tin woc'lala, bel u cu sa'alte u cuxtal ti ca'an,— cu t'an a Jesus ti'ijoo' u yaj cambala. ");
INSERT INTO mopNT_vpl VALUES ("LK17_34","072_17_34","LUK","17","34","34","—Inen tan in wadic te'ex. Ti'i ilic a ac'ü' abe' a tan in wadiqui, coya'anac ca' tuul a winic ichil jun p'eel a camaja. Jun tuulu, bel u ca'a ch'a'bül. Ulaac' a jun tuulu, p'aatül u ca'a. ");
INSERT INTO mopNT_vpl VALUES ("LK17_35","072_17_35","LUK","17","35","35","Ca' tuul ix ch'upu, tanoo' u juch'. Jun tuulu, bel u ca'a ch'a'bül. Ulaac' a jun tuulu, p'aatül u ca'a. ");
INSERT INTO mopNT_vpl VALUES ("LK17_36","072_17_36","LUK","17","36","36","Ca' tuul a winiqui, que'enoo' ich col. Jun tuulu, bel u ca'a ch'a'bül. Ulaac' a jun tuulu, p'aatül u ca'a,— cu t'an a Jesus ti'ijoo' u yaj cambala. ");
INSERT INTO mopNT_vpl VALUES ("LK17_37","072_17_37","LUK","17","37","37","—Noochil, ¿tuba u yuchul abe'e?— cu t'anoo' u yaj cambal ti'iji. —Uchul u ca'a ca'ax tubajac jabix ilic a mucult'an ada' yoc'ol aj ch'omo. Le'ec tuba yan a quimene, te'i tu much'taloo' aj ch'omo,— cu t'an a Jesus ti'ijoo' ti uchi u nuuc. ");
INSERT INTO mopNT_vpl VALUES ("LK18_1","072_18_1","LUK","18","1","1","Pues te'i. Le'ec a Jesusu, u yadaj a mucult'an ti'ijoo' u yaj cambal ti'i ca' u cünoo' ti ma' u tuc'uloo' u yool u c'aate ti'i a Dios le'ec a c'u' a tanoo' u c'aatiqui. ");
INSERT INTO mopNT_vpl VALUES ("LK18_2","072_18_2","LUK","18","2","2","—Yan jun tuul aj il sip'il ichil a jun p'eel a caja. Ma' yan c'u' u cuenta ti'i a Dioso, ma'ax ti'i a ca'ax macaca,— cu t'an a Jesusu. ");
INSERT INTO mopNT_vpl VALUES ("LK18_3","072_18_3","LUK","18","3","3","—Yan ilic jun tuul ix ma'icham ichil a caj abe'e. Walac u boch c'ochol etel aj il sip'il ti tzol. U c'ati cuchi ca' tojquinbic u na'at mac a tan u betic a c'as ti'iji. ");
INSERT INTO mopNT_vpl VALUES ("LK18_4","072_18_4","LUK","18","4","4","Yaab q'uin tan u beel te'i. C'u' betiqui, ma' u c'ati u yaante ix ma'icham aj il sip'ili. Pachili, u tuclaj aj il sip'il ti baala': “Ma' yan c'u' u cuenta ten a ma'ax macaca, ma'ax Dios. ");
INSERT INTO mopNT_vpl VALUES ("LK18_5","072_18_5","LUK","18","5","5","C'u' betiqui, top tan u tuc'sic in wool ix ma'icham ada'a. Bel in quin tojquinte ti'i. Wa ma'a, ma' tu jobol u tuc'sic in wool tanil u boch udel,” cu t'an tu bajil,— cu t'an a Jesusu. ");
INSERT INTO mopNT_vpl VALUES ("LK18_6","072_18_6","LUK","18","6","6","—Tz'aje'ex ta wool biqui'il u t'an aj il sip'il abe' a ma' toj u na'ata,— cu t'an a Noochtzili. ");
INSERT INTO mopNT_vpl VALUES ("LK18_7","072_18_7","LUK","18","7","7","—Le'ec a Dioso, ¿ma' wa jede'ec ilic u tojquintic ti'ijoo' a yeeta'an c'u' a tanoo' u boch c'aatic ti'i ti q'uin ti ac'ü'ü?— cu t'an a Jesusu. ");
INSERT INTO mopNT_vpl VALUES ("LK18_8","072_18_8","LUK","18","8","8","—Inen tan in wadic te'ex. Bel u cu tojquinte ti'ijoo' ti jomol. C'u' betiqui, le'ec ca' uduquen a yanajeen ti cristianojil wa'ye' yoc'olcaba, ¿jede'ec wa in cüxtic ti yanoo' a tanoo' u tz'ocsic a Dioso?— cu t'an a Jesusu. ");
INSERT INTO mopNT_vpl VALUES ("LK18_9","072_18_9","LUK","18","9","9","Pues te'i. Yanoo' a cristiano jabix tojoo' u na'at tu tuclicoo' u bajil. Walacoo' u motzintic u yetcristianojil. Aalbi a mucult'an ti'ijoo' u men a Jesusu. ");
INSERT INTO mopNT_vpl VALUES ("LK18_10","072_18_10","LUK","18","10","10","—Ca' tuul a winiqui, ocoo' ichil u yotoch Dios u c'ajes a Dioso. Jun tuulu, fariseo u c'aba' u na'at. Ulaac' a jun tuulu, aj mol taq'uin ti'i a gobiernojo. Motztziloo' aj mol taq'uin abe' u menoo' u yetcaal. ");
INSERT INTO mopNT_vpl VALUES ("LK18_11","072_18_11","LUK","18","11","11","Le'ec a fariseojo, wa'laji u c'ajes a Dioso, pero chen u c'ajsaj u qui'il u bajil. “Dios, bo'tic tech ti ma' jabixenoo' ulaac' a cristianoji. Ma' ta'ach in cho'. Ma' ta'ach in betic a ma' tojo. Ma' ta'ach in cüjtal etel a ca'ax macaca. Ma'ax xan c'asen jabix a winic ado' aj mol taq'uini. ");
INSERT INTO mopNT_vpl VALUES ("LK18_12","072_18_12","LUK","18","12","12","Inene, walac in p'ütic a janal ti'i in suq'uin ca' sut ti a semanaja. Walac in sijic tech a sij-oolo, jun muuch' tu yaam a diez ichil a tulacal a c'u' a walac u yantal tene,” cu t'an ti'i a Dioso,— cu t'an a Jesusu. ");
INSERT INTO mopNT_vpl VALUES ("LK18_13","072_18_13","LUK","18","13","13","—Pues te'i. Le'ec aj mol taq'uin ti'i a gobiernojo, wa'laji ti naach. Ma' uchi u cha'an ti ca'an. Tan ti tan u jütz'ic u taan u men u yajil u yool. “Dios, top yan in sip'il. Ca' ch'aa' in wotzilil. Sa'tes ten,” cu t'an,— cu t'an a Jesusu. ");
INSERT INTO mopNT_vpl VALUES ("LK18_14","072_18_14","LUK","18","14","14","—Inen tan in wadic te'ex. Le'ec a winic abe'e, c'üma'an ti usc'aji tu yotoch. Le'ec ulaac'a, ma' c'ümbi u t'an, u men mac a walac u tz'eec u bajil jabix top patala, bel u ca'a ti joc'ol ti'i jabix ma' yan u patalil. Le'ec mac a walac u tz'eec u bajil jabix ma' nooch u wichil u meyaja, bel u ca'a tz'abül ti nooch u wichil u meyaj,— cu t'an a Jesusu. ");
INSERT INTO mopNT_vpl VALUES ("LK18_15","072_18_15","LUK","18","15","15","Pues te'i. C'ochesaboo' a tz'ub etel a Jesus ti'i ca' qui'qui't'anbücoo'o. Le'ecoo' u yaj cambal a Jesusu, u yilajoo' ti tanoo' u c'ochesabül. Ma' qui'oo' tu wich. U tze'ectajoo' a tanoo' u c'ochesaj tz'ubu. ");
INSERT INTO mopNT_vpl VALUES ("LK18_16","072_18_16","LUK","18","16","16","C'u' betic a Jesusu, u püyajoo' a tz'ub etele. —Cha'a u taleloo' a tz'ub tin wetele. Ma' a wet'icoo'. Le'ec boon tuul a walacoo' u tz'ocsaj t'an jabixoo' a tz'ub ada'a, le'ec a ocoloo' u ca'a tu cuenta a Dioso,— cu t'an a Jesus ti'ijoo' u yaj cambala. ");
INSERT INTO mopNT_vpl VALUES ("LK18_17","072_18_17","LUK","18","17","17","—Tan in wadic te'ex u jajil. Le'ec mac ma' u c'ati u c'üm-oolte a Dios jabix ilic tu c'üm-oolbol u men a tz'ubu, ma' ilic tu yocol tu cuenta a Dioso,— cu t'an a Jesusu. ");
INSERT INTO mopNT_vpl VALUES ("LK18_18","072_18_18","LUK","18","18","18","Pues te'i. —Maestro, top qui'ech. ¿C'u' a yan in betic ti'i ca' in naalte a cuxtal a ma' yan q'uin u jobolo?— cu t'an jun tuul a nooch u wichil u meyaj ti'i a Jesusu. ");
INSERT INTO mopNT_vpl VALUES ("LK18_19","072_18_19","LUK","18","19","19","—¿C'u' ca'a tan a wadic ti qui'en? Ma' yan mac a qui'i, jadi' a Dioso,— cu t'an a Jesus ti'iji. ");
INSERT INTO mopNT_vpl VALUES ("LK18_20","072_18_20","LUK","18","20","20","—A weel c'u' a tz'iiba'an ichil a ley u men aj Moisese. “Ma' beel ti cüjtal etel ca'ax macac. Ma' beel ti quimsaj. Ma' beel ti xuuch'. Ma' a tz'eec u sip'il a wet'oc etel tus. Tz'oques u yanil a na' a tat,” cu t'an a leye,— cu t'an a Jesus ti'iji. ");
INSERT INTO mopNT_vpl VALUES ("LK18_21","072_18_21","LUK","18","21","21","—In laj tz'ocsaj tulacal abe' ichil in tz'ubil y tac leeb,— cu t'an a winic a nooch u wichil u meyaj ti'i a Jesusu. ");
INSERT INTO mopNT_vpl VALUES ("LK18_22","072_18_22","LUK","18","22","22","Le'ec ca' u yubaj u t'an a winiqui, uchi u nuuc a Jesusu. —Yan to a jun p'eel a ma' a tz'oquese. Ca' xiquech a cono' tulacal a c'u' a yan teche. T'oxo u tool ti'ijoo' a otzili. Ca' a bete' ti baalo'o, bel u ca'a ti yantal tech a ayic'alil ti ca'ana. Ca' tun talaquech tin pach,— cu t'an a Jesus ti'iji. ");
INSERT INTO mopNT_vpl VALUES ("LK18_23","072_18_23","LUK","18","23","23","Le'ec ca' u yubaj abe'e, yajaji u yool a winiqui. Top yaab u ayic'alil. ");
INSERT INTO mopNT_vpl VALUES ("LK18_24","072_18_24","LUK","18","24","24","Le'ec a Jesusu, u cha'antaj a winiqui. —Chücyajil u yocol tu c'ü' a Dios a mac a yan u ayic'alil yoc'olcab,— cu t'an a Jesusu. ");
INSERT INTO mopNT_vpl VALUES ("LK18_25","072_18_25","LUK","18","25","25","—Ma' yan biqui u manül jun tuul noxi' baalche' camello u c'aba' tu potolal a puutzu. Mas ma' yan biqui tucaye'il ca' ococ jun tuul ayic'al a que'en u yool pach u taq'uin tu c'ü' a Dioso,— cu t'an a Jesusu. ");
INSERT INTO mopNT_vpl VALUES ("LK18_26","072_18_26","LUK","18","26","26","—Wa ma' tu paatal u sa'albül a ayic'ala, ma'ax mac wal a bel u ca'a sa'albülü,— cu t'anoo' ca' u yubajoo' u t'an a Jesusu. ");
INSERT INTO mopNT_vpl VALUES ("LK18_27","072_18_27","LUK","18","27","27","—Le'ec c'u' a ma' patal u bete' jun tuul a winiqui, a Dioso, patal u bete',— cu t'an a Jesus ti uchi u nuuc. ");
INSERT INTO mopNT_vpl VALUES ("LK18_28","072_18_28","LUK","18","28","28","—Ino'ono, ti p'ütaj tulacal a c'u' to'ono, ti'i ca' que'enaco'on ta pach,— cu t'an aj Pedro ti'i u men c'u' a aalbi ti'i a ayic'ala. ");
INSERT INTO mopNT_vpl VALUES ("LK18_29","072_18_29","LUK","18","29","30","—Tan in wadic te'ex u jajil. Le'ec mac tan u se' p'ütic u yotoch wa u yütan ti'i u tz'ocsic a Dioso, bel u cu c'ümü' ti mas yaab u qui'il a Dios wa'ye' yoc'olcab. Bel ilic u cu c'ümü' a cuxtal a ma' yan q'uin u jobol tu q'uinil a wataca. Baalo' ilic etel mac a tan u se' p'ütic u sucu'un, u yitz'in, u na', u tat, u mejen, bel ilic u cu c'ümü' abe'e,— cu t'an a Jesusu. ");
INSERT INTO mopNT_vpl VALUES ("LK18_31","072_18_31","LUK","18","31","31","Pues te'i. Le'ec a Jesusu, u püyajoo' a doce tuul tu junaloo'o. —U'ye'ex in t'an. Aleebe bel ti ca'a ich caj Jerusalen,— cu t'an ti'ijoo'. —Inene, yanajeen ti cristianojil. Bel u ca'a ti uchul ten tulacal a c'u' a tz'iiba'an u menoo' a uchben cristiano u yadajoo' u t'an a Dioso,— cu t'an ti'ijoo'. ");
INSERT INTO mopNT_vpl VALUES ("LK18_32","072_18_32","LUK","18","32","32","—Bel in ca'a c'ubbul ti'ijoo' a ma' Israele. Beloo' u cu p'a'asteen. Beloo' u cu bete' a yan ma' yan tene. Beloo' u cu tuubteen. ");
INSERT INTO mopNT_vpl VALUES ("LK18_33","072_18_33","LUK","18","33","33","Beloo' u cu jütz'een etel jatz'. Beloo' u cu quimseen. Tu yox p'e q'uini, bel in ca'a ti ca' cuxtal tucaye'il,— cu t'an a Jesus ti'ijoo' u yaj cambala. ");
INSERT INTO mopNT_vpl VALUES ("LK18_34","072_18_34","LUK","18","34","34","C'u' betiqui, ma' u ch'a'ajoo' u tojil u t'an ma'ax jun cuul. Muca'an u nu'cul u t'an ti'ijoo'. ");
INSERT INTO mopNT_vpl VALUES ("LK18_35","072_18_35","LUK","18","35","35","Pues te'i. Tan to u c'ochol a Jesus chi' caj Jerico. Te'i tina'an tzeel bej jun tuul a ch'oopo. Tan u matan taq'uin. ");
INSERT INTO mopNT_vpl VALUES ("LK18_36","072_18_36","LUK","18","36","36","U yubaj ti top yaab a tanoo' u manül ti bej. U c'aataj c'u' a tan u manülü. ");
INSERT INTO mopNT_vpl VALUES ("LK18_37","072_18_37","LUK","18","37","37","—Le'ec a Jesus a tali Nazarete, le'ec a tan u manülü,— cu t'an u yaalbül. ");
INSERT INTO mopNT_vpl VALUES ("LK18_38","072_18_38","LUK","18","38","38","—Jesus, inchech u mam aj quimen rey David a tan u paac'baanülü. Ch'a'a in wotzilil,— cu t'an ti chich. ");
INSERT INTO mopNT_vpl VALUES ("LK18_39","072_18_39","LUK","18","39","39","—Top lo'peequech,— cu t'anoo' a tanoo' u beel mas taanil tuwich a Jesusu. C'u' betiqui, jadi' u pul-ooltaj u yadic ti mas yaab. —Inchech u mam aj quimen rey David a tan u paac'baanülü. Ch'a'a in wotzilil,— cu t'an ti chich. ");
INSERT INTO mopNT_vpl VALUES ("LK18_40","072_18_40","LUK","18","40","41","Wa'laji a Jesusu. U yadaj ca' talesabüc a ch'oopo. —¿C'u' a c'ati ca' in bete' teche?— cu t'an ti'i a ch'oop le'ec ti c'ochesabi tu tzeele. —Noochil, in c'ati cuchi ca' sasilac in wich,— cu t'an a ch'oopo. ");
INSERT INTO mopNT_vpl VALUES ("LK18_42","072_18_42","LUK","18","42","42","—Jeebi a wich. Uchuc a cha'an. Ch'aneech u men a tz'ocsaj ti patalen— cu t'an a Jesus ti'iji. ");
INSERT INTO mopNT_vpl VALUES ("LK18_43","072_18_43","LUK","18","43","43","Sasilaji u wich tu seebal. Caji ti beel tu pach a Jesusu. Tan u yadic u qui'il a Dios ti tan u beele. Le'ec ca' u yilajoo' abe'e, cajoo' u yadü' u qui'il a Dios tulacaloo' a cristianojo. ");
INSERT INTO mopNT_vpl VALUES ("LK19_1","072_19_1","LUK","19","1","1","Pues te'i. Oqui a Jesus ich caj Jerico. Tützmaan cuchi ti tan u beel. ");
INSERT INTO mopNT_vpl VALUES ("LK19_2","072_19_2","LUK","19","2","2","Jun tuul a winic a que'en te'iji, aj Zaqueo u c'aba'. Ala'aji, u noochiloo' aj mol taq'uin ti'i a gobiernojo. Ayic'al ala'aji. ");
INSERT INTO mopNT_vpl VALUES ("LK19_3","072_19_3","LUK","19","3","3","U c'atiintaj u yila' u wich a Jesusu. Ma' yan biqui u yilic u menoo' a cristianojo, u men top coom u wa'an. ");
INSERT INTO mopNT_vpl VALUES ("LK19_4","072_19_4","LUK","19","4","4","Bini ti alca' taanil. Naq'ui tuwich jun teec che' yoc'ol u yilic a Jesus ti ca' manüc te'i. ");
INSERT INTO mopNT_vpl VALUES ("LK19_5","072_19_5","LUK","19","5","5","Le'ec ti c'ochi a Jesus culic a che' abe'e, uchi u cha'an ti ca'nal. —Zaqueo, seebte a bajil. Emen. Bel in ca'a ti posado ichil a wotoch aleebe,— cu t'an ti'i. ");
INSERT INTO mopNT_vpl VALUES ("LK19_6","072_19_6","LUK","19","6","6","Le'ec aj Zaqueojo, emi ti jomol tuwich a che'e. Qui' u yool ca' u c'ümaj a Jesusu. ");
INSERT INTO mopNT_vpl VALUES ("LK19_7","072_19_7","LUK","19","7","7","Le'ec ca' u yilajoo' abe' a cristianojo, cajoo' ti p'a'as. —Ca wilic. Bini ti posado etel a winic a top yaab u sip'ili,— cu t'anoo' tu bajil. ");
INSERT INTO mopNT_vpl VALUES ("LK19_8","072_19_8","LUK","19","8","8","Pues te'i. Wa'laji aj Zaqueojo. —U'yi in t'an Noochil. Bel in ca'a in siji' jun jatz in ayic'alil ti'ijoo' a otzili. Inene, aj mol taq'uinen ti'i a gobiernojo. Wa in molaj a taq'uin ti manal tuwich c'u' a tz'abi ten in molo'o, bel in quin wusq'uinte ti'i cuatro sut u yaabil u jel,— cu t'an ti'i a Noochtzili. ");
INSERT INTO mopNT_vpl VALUES ("LK19_9","072_19_9","LUK","19","9","9","—Aleebe yan a sa'ala'an ichil a naj ada'a, u men incheche, u mamech ilic aj Abraham. ");
INSERT INTO mopNT_vpl VALUES ("LK19_10","072_19_10","LUK","19","10","10","Inene, yanajeen ti cristianojil. Taleen in cüxte ti'i ca' in sa'alte mac a pula'ana,— cu t'an a Jesusu. ");
INSERT INTO mopNT_vpl VALUES ("LK19_11","072_19_11","LUK","19","11","11","Pues te'i. Le'ec ca' u'yajbi u t'an a Jesus yoc'ol aj Zaqueojo, caji a Jesus u yadü' ti'ijoo' a mucult'ana. Caji u yadoo' a mucult'an abe' u men ma' naach que'en a caj Jerusalen etel u men tanoo' u tuclic ti seeba'an u yocol a Dios ti reyil yoc'olcab. ");
INSERT INTO mopNT_vpl VALUES ("LK19_12","072_19_12","LUK","19","12","12","U men abe'e, u yadaj a mucult'an ada' ti'ijoo'o: —Jun tuul a noochwiniqui, nooch u wichil u meyaj. Püybi ich naachil caj ti'i ca' tz'abüc ti reyil. Le'ec ca' tz'abüc ti reyili, bel u ca'a ti usc'al,— cu t'an a Jesus ich mucult'ana. ");
INSERT INTO mopNT_vpl VALUES ("LK19_13","072_19_13","LUK","19","13","13","—Yan diez tuul u yaj meyaj a noochwinic abe'e. Le'ec ti ma'ax to xi'iqui, u püyajoo' u yaj meyaj. Ti'i a jujun tuulu, u tz'aj jujun p'eel a taq'uin a nooch u wichi. “Bete'ex a negocio etel a taq'uin ada'a, asto ti ca' usc'aquen,” cu t'an ti'ijoo',— cu t'an a Jesusu. ");
INSERT INTO mopNT_vpl VALUES ("LK19_14","072_19_14","LUK","19","14","14","—Pues te'i. Motztzil a noochwinic abe' u menoo' u yetcaala. U tücaa'tajoo' u yaj xa'num tu pach a noochwinic ti'i ca' u yadoo' ti ma' u c'atoo' ca' tücaa'bücoo' u men a noochwiniqui,— cu t'an a Jesusu. ");
INSERT INTO mopNT_vpl VALUES ("LK19_15","072_19_15","LUK","19","15","15","—Pues te'i. Tz'abi ti reyil a noochwiniqui. Usc'aji tu caal. U püyajoo' u yaj meyaj, le'ec a boon tuul a tz'aboo' u taq'uin ti men negocio. U c'ati u yeelte boon u naaltaj a jujun tuul etel a negocio u betajoo' etel u taq'uini,— cu t'an a Jesusu. ");
INSERT INTO mopNT_vpl VALUES ("LK19_16","072_19_16","LUK","19","16","16","—C'ochi a jun tuulu. “Noochwinic, yanaji diez sut u chucaan a taq'uin a tz'aj tene,” cu t'an ti'i. ");
INSERT INTO mopNT_vpl VALUES ("LK19_17","072_19_17","LUK","19","17","17","“Qui' a betaja. Quich'pan aj meyajech. Qui' a betaj etel a tz'etz'eeque, mentücü, bel in quin tz'aa' a meyaj. Bel a ca'a ti tücaa' ichil a diez p'eel ti caja.” cu t'an ti'i,— cu t'an a Jesus ich mucult'an. ");
INSERT INTO mopNT_vpl VALUES ("LK19_18","072_19_18","LUK","19","18","18","—C'ochi ulaac' a jun tuulu. “Noochwinic, yanaji cinco sut u chucaan a taq'uin a tz'aj tene,” cu t'an ti'i. ");
INSERT INTO mopNT_vpl VALUES ("LK19_19","072_19_19","LUK","19","19","19","“Bel in quin tz'aa' a meyaj. Bel a ca'a ti tücaa' ichil a cinco p'eel ti caja,” cu t'an ti'i,— cu t'an a Jesusu. ");
INSERT INTO mopNT_vpl VALUES ("LK19_20","072_19_20","LUK","19","20","20","—C'ochi ulaac' a jun tuulu. “Noochwinic, jeda' a taq'uin a tz'aj tene. In tepaj etel paño ca' tun in taactaj. ");
INSERT INTO mopNT_vpl VALUES ("LK19_21","072_19_21","LUK","19","21","21","In betaj abe' u men saaquen tech. Ma' ta'ach a ch'a'ic u yotzilil a maca. Walac a molic c'u' a ma' a p'ütaja. Walac a jochic u wich c'u' a ma' a püc'aja,” cu t'an u yaj meyaj ti'i,— cu t'an a Jesus ich mucult'ana. ");
INSERT INTO mopNT_vpl VALUES ("LK19_22","072_19_22","LUK","19","22","22","—“C'ac'as aj meyajech. Etel ilic a c'u' a wadaja, bel in quin yee' ti yan a sip'il. A weel ti ma' ta'ach in ch'a'ic u yotzilil a maca. A weel ti walac in molic a c'u' a ma' in p'ütaj. A weel ti walac in jochic u wich a c'u' a ma' in püc'aj. ");
INSERT INTO mopNT_vpl VALUES ("LK19_23","072_19_23","LUK","19","23","23","A weel tulacal abe'e, mentücü, ¿c'u' ca'a ma' a tz'aj in taq'uin ti maanil? Ti baalo'o, ca' c'ochoquene, in c'ümaj cuchi in taq'uin tac etel u naal,” cu t'an ti'i u yaj meyaj,— cu t'an a Jesusu. ");
INSERT INTO mopNT_vpl VALUES ("LK19_24","072_19_24","LUK","19","24","24","—“Toco ti'i a taq'uin in tz'aj ti'i. Tz'a ti'i a yanaji ti'i a diez sut mas yaaba,” cu t'an ti'ijoo' a que'en te'iji,— cu t'an a Jesusu. ");
INSERT INTO mopNT_vpl VALUES ("LK19_25","072_19_25","LUK","19","25","25","—“Noochwinic, ac yan tun ti'i diez sut mas yaab,” cu t'anoo' ti'i,— cu t'an a Jesusu. ");
INSERT INTO mopNT_vpl VALUES ("LK19_26","072_19_26","LUK","19","26","26","—“U'ye'ex in t'an. Tulacal mac a yanaji ti'i ti yaaba, bel u ca'a tz'abül ti'i u chucaan ti mas yaab. Le'ec mac a ma' yanaji ti'i ma'ax tz'etz'eec u chucaana, tocbol u ca'a ti'i c'u' a yan ti'iji. ");
INSERT INTO mopNT_vpl VALUES ("LK19_27","072_19_27","LUK","19","27","27","Uxtun boon a tz'iicoo' tene. Ma' u c'atoo' ca' ocoquen ti reyil. Talesoo' ten. Quimesoo' wa'ye' tin taan,” cu t'an a noochwiniqui,— cu t'an a Jesus ich mucult'ana. ");
INSERT INTO mopNT_vpl VALUES ("LK19_28","072_19_28","LUK","19","28","28","Pues te'i. Le'ec ti jobi u yadic abe'e, joq'ui te'i a Jesusu. Ch'a'bej ti tan u beel ich caj Jerusalen. ");
INSERT INTO mopNT_vpl VALUES ("LK19_29","072_19_29","LUK","19","29","29","Ti bej que'en a caj Betfage etel a caj Betania. Que'en tuwich witz u c'aba' Olivo a ca' p'eel a caj abe'e. Le'ec ti nütz'a'an u c'ochol te'i, u tücaa'tajoo' ca' tuul u yaj cambal ich caj. ");
INSERT INTO mopNT_vpl VALUES ("LK19_30","072_19_30","LUK","19","30","30","—Ca' xique'ex ichil a caj a que'en tiqui taan. Le'ec ti tane'ex a wocol ichil a caja, bele'ex a ca'a a cüxte a tzimin a tz'i'tz'i' to c'üxa'an te'i. Ma'ax to mac tinlac tu pach. Piti. Tales wa'ye',— cu t'an ti'i a ca' tuulu. ");
INSERT INTO mopNT_vpl VALUES ("LK19_31","072_19_31","LUK","19","31","31","—Wa mac ca' u c'aate te'ex c'u' ca'a ti tane'ex a pitiqui, baala' ca' a nuucte'ex: “C'abeet ti'i a Noochtzili,” que'exac ti'i,— cu t'an a Jesusu. ");
INSERT INTO mopNT_vpl VALUES ("LK19_32","072_19_32","LUK","19","32","32","Binoo' a tücaa'boo'o. U cüxtajoo' jabix ilic ti aalboo' ti'iji. ");
INSERT INTO mopNT_vpl VALUES ("LK19_33","072_19_33","LUK","19","33","33","Le'ec ti tanoo' u pitic a tz'i' tzimini, c'aatboo' ti'i u men u yumil. —¿C'u' ca'a ti tane'ex a pitic a tz'i' tzimini?— cu t'anoo' u yaalbül. ");
INSERT INTO mopNT_vpl VALUES ("LK19_34","072_19_34","LUK","19","34","34","—C'abeet ti'i a Noochtzili,— cu t'anoo' ti'i. ");
INSERT INTO mopNT_vpl VALUES ("LK19_35","072_19_35","LUK","19","35","35","U bensajoo' ti'i a Jesusu. Le'ecoo' u yaj cambala, u tz'ajoo' u noc' tu pach a tz'i' tzimin ti'i ca' tinlac a Jesus yoc'olo. ");
INSERT INTO mopNT_vpl VALUES ("LK19_36","072_19_36","LUK","19","36","36","Le'ec ti tan u beel a Jesus pach a tz'i' tzimini, le'ecoo' a cristianojo, u xit'ajoo' u noc' ti lu'um ti bej tuba u manül a Jesusu. ");
INSERT INTO mopNT_vpl VALUES ("LK19_37","072_19_37","LUK","19","37","37","Tanoo' u yemel tuwich a witz Olivo a natz' chi' caj Jerusalene. Tulacaloo' u yaabil u yaj tz'ocsaj t'an a que'enoo' etele, qui'oo' u yool. Cajoo' u yadü' u qui'il a Dios ti chich u men boon a milagro u yilajoo' u betic a Jesusu. ");
INSERT INTO mopNT_vpl VALUES ("LK19_38","072_19_38","LUK","19","38","38","—Qui' u yool a rey ada' a tan u yudel etel u muc' a Noochtzili. Jetz'a'an u yool a Dios ti ca'ana. Top qui' u na'at a Dios ti ca'ana,— cu t'anoo' ti chich. ");
INSERT INTO mopNT_vpl VALUES ("LK19_39","072_19_39","LUK","19","39","39","Yanoo' a fariseo u c'aba'oo' u na'at tu yaamoo' a cristiano abe'e. —Maestro, adoo' ti'i a waj tz'ocsaj t'an ti'i ma' u yadicoo' abe'e,— cu t'anoo' ti'i a Jesusu. ");
INSERT INTO mopNT_vpl VALUES ("LK19_40","072_19_40","LUK","19","40","40","—Tan in wadic te'ex. Wa cuchi ca' u p'ütoo' a t'an ala'oo'o, le'ec ilic a tunichi, bel cuchi u ca'a ti t'an ti chich,— cu t'an a Jesus ti uchi u nuuc. ");
INSERT INTO mopNT_vpl VALUES ("LK19_41","072_19_41","LUK","19","41","41","Pues te'i. Le'ec ti naatz'oo' chi' caja, u yilaj a caj a Jesusu. Uchi u yoc'ol u men ma' c'ümbi u t'an te'i. ");
INSERT INTO mopNT_vpl VALUES ("LK19_42","072_19_42","LUK","19","42","42","—Wa cuchi u yeel a caj aleebe biqui ca' qui'acoo' etel a Dioso, qui' cuchi. C'u' betiqui, muca'an ti'ijoo',— cu t'an yoc'ol a caja. ");
INSERT INTO mopNT_vpl VALUES ("LK19_43","072_19_43","LUK","19","43","43","—Watac u q'uinil ti bel u ca'a xooybol a caj u men u yettz'iiquili. Beloo' u ca'a u bete' a cot tulacal tu xooy tuba u muquicoo' u bajil u yettz'iiquil ichil a p'isbaja. C'üla'ane'ex chen ichil. ");
INSERT INTO mopNT_vpl VALUES ("LK19_44","072_19_44","LUK","19","44","44","Beloo' u cu jubu' a caja. Beloo' u cu quimes a cristiano te'iji. Ma' tu p'üticoo' ma'ax jun cuul a tunich ti tzaama'ana. Uchul u ca'a abe' u men ma' u yeeltajoo' c'u' ti q'uinil u yudel a Cristo ti sut eteloo'o,— cu t'an a Jesus yoc'ol a caja. ");
INSERT INTO mopNT_vpl VALUES ("LK19_45","072_19_45","LUK","19","45","45","Pues te'i. Oqui a Jesus ichil u yotoch a Dioso. Caji u tooltoo' boon a tanoo' u conol te'i. ");
INSERT INTO mopNT_vpl VALUES ("LK19_46","072_19_46","LUK","19","46","46","—Baala' ti tz'iiba'an ichil u ju'um a Dioso. “In wotocho, u cuuchil in c'ajsabeeb. C'u' betiqui, a betaje'ex ti chen u cuuchiloo' aj xuuch' in wotoch,” cu t'an a Dioso. Baalo' ti tz'iiba'an,— cu t'an a Jesus ti'ijoo' mac tan u tooltiqui. ");
INSERT INTO mopNT_vpl VALUES ("LK19_47","072_19_47","LUK","19","47","47","Pues te'i. Sansamal tan u ca'ansicoo' a cristiano ichil u yotoch a Dioso. Le'ecoo' u noochil u yaj mansaj t'an a cristiano ti'i a Dioso, u yet'ocoo' u yaj ca'ansajil u ley aj Moises eteloo' a nucuch winic u yaj cananiloo' a caja, u c'atiintajoo' cuchi u quimes a Jesusu. ");
INSERT INTO mopNT_vpl VALUES ("LK19_48","072_19_48","LUK","19","48","48","C'u' betiqui, ma' tanoo' u cüxtic c'u' a ca' u betoo' ti'iji, u men tulacaloo' a cristianojo, que'enoo' te'i u yuboo' tulacal a c'u' a tan u yadiqui. ");
INSERT INTO mopNT_vpl VALUES ("LK20_1","072_20_1","LUK","20","1","1","Pues te'i. Jun p'eel q'uin que'en a Jesus ichil u yotoch a Dioso. Tan u ca'ansicoo' a cristiano te'iji. Tan u yadic ti'ijoo' u pectzil a Dioso. Naatz'oo' tu tzeel a Jesus u noochiloo' u yaj mansaj t'an a cristiano ti'i a Dios u yet'ocoo' u yaj ca'ansajil u ley aj Moises eteloo' a nucuch winiqui. ");
INSERT INTO mopNT_vpl VALUES ("LK20_2","072_20_2","LUK","20","2","2","—Adü to'on c'u' u wichil a meyaj ti tan a betic c'u' a tan a betiqui. ¿Mac u tz'aj a meyaj?— cu t'anoo' ti'i a Jesusu. ");
INSERT INTO mopNT_vpl VALUES ("LK20_3","072_20_3","LUK","20","3","3","—Se' bel ilic in quin c'aate te'ex jun p'el a t'ana, ca' tun in nuucte'ex. ");
INSERT INTO mopNT_vpl VALUES ("LK20_4","072_20_4","LUK","20","4","4","Le'ec a ocja' u tz'aj aj Juana, ade'ex ten wa ti'i Dios wa ti'i cristiano,— cu t'an a Jesus ti'ijoo'o. ");
INSERT INTO mopNT_vpl VALUES ("LK20_5","072_20_5","LUK","20","5","5","Cajoo' u tzicbalte abe' tu bajil. —Wa ca' ti wadü' wa ti'i Dios a ocja' u tz'aj aj Juana, bel u cu c'aate to'on c'u' ca'a ma' ti tz'ocsaj,— cu t'anoo' tu bajil. ");
INSERT INTO mopNT_vpl VALUES ("LK20_6","072_20_6","LUK","20","6","6","—Wa ca' ti wadü' wa ti'i cristianojo, beloo' u cu p'up'uchch'into'on tulacaloo' a cristianojo, u men tanoo' u tz'ocsic ti u t'an Dios u yadaj aj Juana,— cu t'anoo' tu bajil. ");
INSERT INTO mopNT_vpl VALUES ("LK20_7","072_20_7","LUK","20","7","7","—Ma' ti weel mac ti'i a ocja' u betaj aj Juana,— cu t'anoo' ti uchoo' u nuuc. ");
INSERT INTO mopNT_vpl VALUES ("LK20_8","072_20_8","LUK","20","8","8","—Ma' ilic xan tin wadic te'ex mac u tz'aj in meyaj ti'i ca' in bete' c'u' a walac in betiqui,— cu t'an a Jesus ti'ijoo'o. ");
INSERT INTO mopNT_vpl VALUES ("LK20_9","072_20_9","LUK","20","9","9","Pues te'i. Caji u yadü' ti'ijoo' a cristiano jun p'eel a mucult'ana. —Jun tuul a winiqui, u püc'aj u cuuch a püc'aala, ca' tun u tz'aj ti maanil. Yan u tz'abül ti'i tz'etz'eecac u wich ti'i u tool u maanbeeb. Bini a winic ichil ulaac' caj ti naach. Te'i xanaji,— cu t'an a Jesus ich mucult'an. ");
INSERT INTO mopNT_vpl VALUES ("LK20_10","072_20_10","LUK","20","10","10","—Le'ec ti c'ochi u q'uinili, u tücaa'taj jun tuul u yaj meyaj ca' xi'icoo' etel a tanoo' u maan cuuch püc'aala. U c'atiintaj cuchi ca' tz'abüc ti'i tz'eecac u wich u püc'aal tanil u maanbül u cuuchil. C'u' betiqui, müchbi y jütz'bi u yaj meyaj u menoo' a tanoo' u maan lu'umu. Ma'ax c'u' a tz'abi ti'iji. Chen tücaa'bi ca' usc'ac ti baalo',— cu t'an a Jesusu. ");
INSERT INTO mopNT_vpl VALUES ("LK20_11","072_20_11","LUK","20","11","11","—U ca' tücaa'taj ulaac' jun tuul u yaj meyaj. Jütz'bi ilic xan ala'aji. Betabi a c'as ti'iji. Ma'ax c'u' a tz'abi ti'iji. Chen tücaa'bi ca' usc'ac ti baalo',— cu t'an a Jesusu. ");
INSERT INTO mopNT_vpl VALUES ("LK20_12","072_20_12","LUK","20","12","12","—U tücaa'taj u yox tuul u yaj meyaj. Yajcunbi ilic xan. Tulca'bi pach cot u menoo',— cu t'an a Jesusu. ");
INSERT INTO mopNT_vpl VALUES ("LK20_13","072_20_13","LUK","20","13","13","—“¿C'u' a qui' ca' in bete' aleebe? Bel in quin tücaa'te in mejen. Yaj in wu'yi ala'aji. Jede'ecoo' wal u tz'ocsic u yanil in mejene,” cu t'an u yumil u cuuch a püc'aal tu bajili,— cu t'an a Jesusu. ");
INSERT INTO mopNT_vpl VALUES ("LK20_14","072_20_14","LUK","20","14","14","—C'u' betiqui, ilbi u mejen u menoo' a tanoo' u maantic u cuuch a püc'aala. U yadajoo' tu bajil: “P'aatül u ca'a u cuuch a püc'aal ti'i ala'aji. Co'ne'ex ti quimes. Ti baalo'o, p'aatül u ca'a to'on u cuuchil a püc'aala,” cu t'anoo' tu bajil,— cu t'an a Jesusu. ");
INSERT INTO mopNT_vpl VALUES ("LK20_15","072_20_15","LUK","20","15","15","—U joc'sajoo' tu pach u cuuch a püc'aala. U quimsajoo' te'i. ¿C'u' a ca' betabücoo' ti'i u men u yumil u cuuchil a püc'aala?— cu t'an a Jesusu. ");
INSERT INTO mopNT_vpl VALUES ("LK20_16","072_20_16","LUK","20","16","16","—Bel u ca'a ti c'ochol u quimesoo' a tanoo' u maan cuuch püc'aala. Bel u cu tz'aa' u cuuchil u püc'aal ti'i ulaac' ca' u maante,— cu t'an a Jesus ich mucult'an yoc'ol c'u' u betajoo' ti'i u yaj tücaa' a Dioso. —Ti c'ati a Dios ca' u tz'aa' ti ma' u yuchul a jabix a wadaja,— cu t'anoo' a mac u yubajoo' a t'an abe'e. ");
INSERT INTO mopNT_vpl VALUES ("LK20_17","072_20_17","LUK","20","17","17","Le'ec a Jesusu, u cha'antajoo'. —¿C'u' a walac u yadic te'ex a t'an ada' a tz'iiba'an ichil u ju'um a Dioso?— cu t'an ti'ijoo'. —“Le'ec a jun cuul a tunich a ma' u c'atiintajoo' cuchi, culaji ilic ti'i u wa'taan a naja,” cu t'an a t'an a tz'iiba'ana. ");
INSERT INTO mopNT_vpl VALUES ("LK20_18","072_20_18","LUK","20","18","18","Tulacal a mac ca' c'axüc tuwich a tunich abe'e, bel u ca'a yajcunbul. C'u' betiqui, ca' c'axüc a tunich abe' yoc'ol a maca, bel u ca'a pechmesabül,— cu t'an a Jesus ich mucult'an yoc'ol u bajil. ");
INSERT INTO mopNT_vpl VALUES ("LK20_19","072_20_19","LUK","20","19","19","Pues te'i. Le'ecoo' u yaj ca'ansajil u ley aj Moisese, u yet'ocoo' u noochiloo' u yaj mansaj t'an a cristiano ti'i a Dioso, u ch'a'ajoo' u tojil a mucult'an abe' u yadaj a Jesus ti le'ecoo' ilic ala'oo' a tanoo' u tzicbalbülü, mentücü, u c'atiintajoo' cuchi u müchü' a Jesus ti ilic a q'uin abe'e. C'u' betiqui, saacoo' ti'i a cristianojo. ");
INSERT INTO mopNT_vpl VALUES ("LK20_20","072_20_20","LUK","20","20","20","Cajoo' u paac'te biq'uin ti jede'ecoo' u cho'ic a Jesusu. U tücaa'tajoo' a winic etel a Jesusu. U betajoo' jabix tojoo' u na'at, chen ti'i ca' emsabüc u yool a Jesus ti'i ca' u yadü' a ma' tojo. Le'ec ca' u yadü' a ma' tojo, beloo' u cu müchü' a Jesusu. Beloo' u cu c'ubu' tu c'ü' a gobernadoro. ");
INSERT INTO mopNT_vpl VALUES ("LK20_21","072_20_21","LUK","20","21","21","—Maestro, ti weel ti toj a walac a wadiqui, y toj a walac a ye'iqui. Walac a betic ti quet ti'i tulacal a maca. Walac a ye'ic u jajil biqui'il u c'ati a Dioso. ");
INSERT INTO mopNT_vpl VALUES ("LK20_22","072_20_22","LUK","20","22","22","¿Yan wa ti bo'tic a taq'uin a walac u tücaa'bül molbol u men aj rey Cesara, wa ma'?— cu t'anoo' ti'i a Jesusu. ");
INSERT INTO mopNT_vpl VALUES ("LK20_23","072_20_23","LUK","20","23","23","Pues te'i. Le'ec a Jesusu, u na'taj a ma' toj a tanoo' u betiqui. —¿C'u' ca'a tane'ex a yaaltic a cho'een?— cu t'an a Jesusu. ");
INSERT INTO mopNT_vpl VALUES ("LK20_24","072_20_24","LUK","20","24","24","—Ye'e ten a taq'uini. ¿Mac aj ich a que'en tuwichi? ¿Mac ti'i a c'aba' a que'en te'iji?— cu t'an ti'ijoo'. —Ti'i a reye,— cu t'anoo' ti'i. ");
INSERT INTO mopNT_vpl VALUES ("LK20_25","072_20_25","LUK","20","25","25","—Ca' tz'aa' ti'i a rey le'ec a c'u' a ti'i a reye. Ca' tz'aa' ti'i a Dios le'ec a c'u' a ti'i a Dioso,— cu t'an a Jesus ti'ijoo'o. ");
INSERT INTO mopNT_vpl VALUES ("LK20_26","072_20_26","LUK","20","26","26","Ti baalo'o, ma' paatajoo' u cho' a Jesus tu taanoo' a cristianojo. Jadi' sa'too' u yool ca' u yubajoo' biqui ti nuucboo'. P'aatoo' ti ma' yanoo' u t'an. ");
INSERT INTO mopNT_vpl VALUES ("LK20_27","072_20_27","LUK","20","27","27","Pues te'i. Le'ec a saduceo u c'aba'oo' u na'ata, c'ochoo' etel a Jesusu. Walacoo' u tz'ocsic ti ma' tu ca' cuxtal a maca. ");
INSERT INTO mopNT_vpl VALUES ("LK20_28","072_20_28","LUK","20","28","28","Cajoo' ti tzicbal etel a Jesusu. —Maestro, le'ec aj Moisese, u tz'iibtaj to'on jun p'eel a ley ti baala': “Wa ca' quimic jun tuul winic ti ma'ax jun tuul u mejene, yan u ch'a'bül u yütan a quimen u men a itz'intzili, yoc'ol ca' yanac jun tuulac u mejen bete cuenta u mejen a quimene.” Baalo' u tz'iibtaj to'on aj Moisese,— cu t'anoo' ti'i a Jesusu. ");
INSERT INTO mopNT_vpl VALUES ("LK20_29","072_20_29","LUK","20","29","29","—Pues te'i. Yan siete tuul a winiqui, u sucu'un u yitz'inoo' u bajil. U cüxtaj u yütan a jun tuulu. Quimi ti ma' yan u mejen. ");
INSERT INTO mopNT_vpl VALUES ("LK20_30","072_20_30","LUK","20","30","30","Le'ec u yitz'ini, u yütantaj u mu'. Quimi ilic ti ma' yan u mejen. ");
INSERT INTO mopNT_vpl VALUES ("LK20_31","072_20_31","LUK","20","31","31","Baalo' ilic ulaac' u yitz'ini, asto ti ca' u yichamtaj tu siete tuuliloo'. Laj quimoo' ti ma' yanoo' u mejen. ");
INSERT INTO mopNT_vpl VALUES ("LK20_32","072_20_32","LUK","20","32","32","Mas pachili, quimi ilic a nooch'upu. ");
INSERT INTO mopNT_vpl VALUES ("LK20_33","072_20_33","LUK","20","33","33","Le'ec ti ca' cuxlacoo' a quimene, ¿mac u yicham a nooch'up abe' tu yaamoo' a siete tuulu? Tulacal a siete tuulu, u laj ichamtaj ala'aji,— cu t'anoo' a saduceo ti'i a Jesusu. ");
INSERT INTO mopNT_vpl VALUES ("LK20_34","072_20_34","LUK","20","34","34","—Aleebe, tanoo' u cüxtic u yütan a winiqui, y tanoo' u tz'abül ix chu' ti icham xan. ");
INSERT INTO mopNT_vpl VALUES ("LK20_35","072_20_35","LUK","20","35","35","C'u' betiqui, le'ec boon tuul a qui' tu wich a Dios ca' cuxlacoo' tu yaam a quimene, ca' tun u c'ümoo' a cuxtala, ala'oo'o, ma' tu yütanoo', y ma' tu yichamoo' te'i, ");
INSERT INTO mopNT_vpl VALUES ("LK20_36","072_20_36","LUK","20","36","36","u men ma' tu ca' quimiloo'. P'aatüloo' u ca'a ti jabix quet eteloo' u yaj xa'num a Dios ti ca'ana. U mejenoo' Dios ala'oo'o, u men ca' cuxtaloo' u ca'a tucaye'il,— cu t'an a Jesusu. ");
INSERT INTO mopNT_vpl VALUES ("LK20_37","072_20_37","LUK","20","37","37","—Pues te'i. Aj Moises ilic, u ye'aj ti ca' cuxtal u ca'a a quimene. Tu yaam u tz'iib aj Moisese, u tzicbaltaj a pocche' tuba t'üba'an a c'aac'a. Te'i ilic u tz'iibtaj ti le'ec a Noochtzili, le'ec u Dios aj Abrahama. Le'ec ilic u Dios aj Isaaca. Le'ec ilic xan u Dios aj Jacobo,— cu t'an a Jesusu. ");
INSERT INTO mopNT_vpl VALUES ("LK20_38","072_20_38","LUK","20","38","38","—Ca'ax uchben quimen ala'oo'o, le'ec a Dioso, ma' u diosiloo' a quimeni. Ala'aji, u Diosiloo' a cuxa'ana, mentücü, yan a ca' cuxtal tu yaamoo' a quimene,— cu t'an a Jesusu. ");
INSERT INTO mopNT_vpl VALUES ("LK20_39","072_20_39","LUK","20","39","39","—Maestro, top toj a t'an a wadaja,— cu t'anoo' a jujun tuul tu yaamoo' u yaj ca'ansajil u ley aj Moisese. ");
INSERT INTO mopNT_vpl VALUES ("LK20_40","072_20_40","LUK","20","40","40","Le'ecoo' ala'oo'o, saacajoo' u ca' c'aate ti'i a Jesus ulaac' a t'ana. ");
INSERT INTO mopNT_vpl VALUES ("LK20_41","072_20_41","LUK","20","41","41","Pues te'i. Le'ec a Jesusu, u c'aataj jun p'eel a t'an ti'ijoo'o. —¿C'u' ca'a walac u yaalbül ti le'ec a Cristojo, u mam aj quimen rey David?— cu t'an a Jesusu. ");
INSERT INTO mopNT_vpl VALUES ("LK20_42","072_20_42","LUK","20","42","42","—Ichil u ju'um a Dios a Salmo u c'aba'a, baala' ti tz'iiba'an u men ilic aj David abe'e: “Le'ec a Dios a Noochtzili, u yadaj ti'i in Noochil ca' tinlac tu yaj toj tu yaj seeb c'ü' u men u yanil ");
INSERT INTO mopNT_vpl VALUES ("LK20_43","072_20_43","LUK","20","43","43","asto u cho'icoo' a tz'iic ti'iji. P'aatüloo' u ca'a jabix yalam u yoc,” cu t'an u t'an a Dios a tz'iiba'an u men aj Davidi. ");
INSERT INTO mopNT_vpl VALUES ("LK20_44","072_20_44","LUK","20","44","44","“In Noochil,” cu t'an aj David yoc'ol a Cristojo. Wa cuchi jadi' u mam aj David a Cristojo, ¿c'u' ca'a u tzicbaltaj ala'i jabix u Noochil?— cu t'an a Jesusu. ");
INSERT INTO mopNT_vpl VALUES ("LK20_45","072_20_45","LUK","20","45","45","Pues te'i. Tu taan tulacaloo' a cristianojo, uchi u t'an a Jesus eteloo' u yaj cambal. ");
INSERT INTO mopNT_vpl VALUES ("LK20_46","072_20_46","LUK","20","46","46","—Cününte'ex a bajil. Ma' a beele'ex etel boon u yaj ca'ansajil u ley aj Moises a qui'oo' tu wich u tz'eec a noc' a chawac ti'i ca' chiclac jabix noochoo' u wichil u meyaja. Top qui'oo' tu wich ti walac u tz'abüloo' a tzic ti'i chumuc caj jabix noochoo' u wichil u meyaja. Top qui'oo' tu wich a silla a quich'pan jabix noochoo' u wichil u meyaj ichil boon a naj tuba walacoo' u much'tal a cristiano u c'ajes a Dioso. Qui'oo' tu wich u beel ti tintal tuwich u cuuchil a mac a nooch u wichil u meyaj ichil a fiestaja,— cu t'an a Jesusu. ");
INSERT INTO mopNT_vpl VALUES ("LK20_47","072_20_47","LUK","20","47","47","—Walacoo' u toquic u yotoch ix ma'ichama. Chawac u pach u t'an ti tan u t'an etel a Dioso, chen ti'i ca' ilbic u menoo' a cristiano jabix top qui' ti que'en etel a Dioso. Mas yaj u sip'il ti bel u ca'a tz'abül ti'ijoo',— cu t'an a Jesusu. ");
INSERT INTO mopNT_vpl VALUES ("LK21_1","072_21_1","LUK","21","1","1","Pues te'i. Que'en a Jesus ichil u yotoch a Dioso. U yilajoo' a ayic'al ti tanoo' u tz'eec a sij-ool ichil u taacbeeb a taq'uini. ");
INSERT INTO mopNT_vpl VALUES ("LK21_2","072_21_2","LUK","21","2","2","U yilaj ilic xan jun tuul otzil ix ma'icham. U sijaj ca' p'eel aj meen taq'uini. ");
INSERT INTO mopNT_vpl VALUES ("LK21_3","072_21_3","LUK","21","3","3","—Tan in wadic te'ex u jajil. Le'ec a otzil ix ma'icham ada'a, u tz'aj ti mas yaab tuwichoo' tulacal u chucaan,— cu t'an a Jesusu. ");
INSERT INTO mopNT_vpl VALUES ("LK21_4","072_21_4","LUK","21","4","4","—Ala'oo'o, tz'eec ilic u tz'ajoo' ichil u yaabil a yan ti'ijoo'o. C'u' betic ix ch'up ado'o, otzil. U laj tz'aj tulacal a c'u' a yan ti'i ti'i u nu'cul u cuxtal,— cu t'an a Jesusu. ");
INSERT INTO mopNT_vpl VALUES ("LK21_5","072_21_5","LUK","21","5","5","Pues te'i. Yanoo' a cristianojo, u yadajoo' ti quich'pan u yotoch a Dioso. U tzicbaltajoo' biqui'il u quich'panil, biqui a tunich ichili, y biqui'il a sij-ool te'iji. Le'ec ca' u yubaj a Jesus c'u' u yadajoo'o, uchi u t'an. ");
INSERT INTO mopNT_vpl VALUES ("LK21_6","072_21_6","LUK","21","6","6","—Watac u q'uinil le'ec ti tulacal a c'u' a tane'ex a cha'antiqui, laj bel u ca'a yojbol. Ma' tu cuntal ma'ax jun cuul a tunich tzaama'an yoc'ol u yet'oco,— cu t'an a Jesusu. ");
INSERT INTO mopNT_vpl VALUES ("LK21_7","072_21_7","LUK","21","7","7","Pues te'i. —Maestro, ¿biq'uin to u yuchul abe'e? ¿C'u' u p'is ti watac u q'uinil u yuchul abe'e?— cu t'anoo' ti'i. ");
INSERT INTO mopNT_vpl VALUES ("LK21_8","072_21_8","LUK","21","8","8","—Cününte'ex a bajil ti'i ma' a tz'ocsique'ex a tusu. Yan a watacoo'o. Beloo' u cu tz'aa' u bajil jabixenoo'o. “Inen a Cristo,” cu t'anacoo' ala'oo'o. “C'ochi u q'uinil u ca' udel a Cristojo,” cu t'anacoo' ulaac'a. Ma' a tz'ocsique'exoo' u t'an,— cu t'an a Jesus ti'ijoo'o. ");
INSERT INTO mopNT_vpl VALUES ("LK21_9","072_21_9","LUK","21","9","9","—Bele'ex a ca'a a wu'yi ti tan a nooch guerraja. Tan ilic a p'isbaj ichil a jun p'eel a caja. Ma' u jac'üle'ex a wool. Yan u yuchul abe' payanbej. Ma' jiil tu pach abe' u c'ochol u q'uinil u jobol tulacal,— cu t'an a Jesusu. ");
INSERT INTO mopNT_vpl VALUES ("LK21_10","072_21_10","LUK","21","10","10","—Bel u ca'a ti p'isbaj a noxi' caj etel ulaac' a noxi' caja. Bel ilic u ca'a u tz'aa' a p'isbaj jun tuul a rey etel ulaac' a reye,— cu t'an a Jesusu. ");
INSERT INTO mopNT_vpl VALUES ("LK21_11","072_21_11","LUK","21","11","11","—Bel u ca'a ti yantal a yuc'laj a chichi. Bel u ca'a ti yantal a wi'ijil tubajac taca. Bel u ca'a ti yantal a c'ac'as c'oja'anil tubajac taca. Ilbil u ca'a a c'u' tac ti ca'an a bel u ca'a ti jac'saj-oolo. Te'i ilic u yilicoo' u p'is a top nooch ti jobol u ca'a a yoc'olcaba,— cu t'an a Jesusu. ");
INSERT INTO mopNT_vpl VALUES ("LK21_12","072_21_12","LUK","21","12","12","—C'u' betiqui, le'ec ti ma'ax to laj uchuc tulacal abe'e, bele'ex a ca'a müchbül. Bel u ca'a betabül te'ex a yaja. Bele'ex a ca'a bensabül ichil boon a naj tuba walacoo' u much'tal u c'ajes a Dioso. Bele'ex a ca'a tz'abül ichil a sip'il chen u men que'ene'ex a wool tin pach. Beloo' u cu tz'a'e'ex ti presojil. Bele'ex a ca'a bensabül tu taanoo' a rey y tu taanoo' a gobernador u men que'ene'ex a wool tin pach,— cu t'an a Jesusu. ");
INSERT INTO mopNT_vpl VALUES ("LK21_13","072_21_13","LUK","21","13","13","—Ti'i a q'uin ti bensabüque'ex tu taanoo' ala'oo'o, te'i a wadique'ex in qui'il. ");
INSERT INTO mopNT_vpl VALUES ("LK21_14","072_21_14","LUK","21","14","14","Aleebe tz'aje'ex ta wool ti ma' a se' tuclique'ex biqui ca' a nuucte'exoo'. ");
INSERT INTO mopNT_vpl VALUES ("LK21_15","072_21_15","LUK","21","15","15","Inen bel in quin tz'a'e'ex a na'at biqui ca' a nuuctoo'. Le'ec a tz'iic ta wetele'exe, ma' tu paataloo' u xotique'ex a t'an. Ma'ax tu paataloo' u yadic ti tus a bele'ex a ca'a a wadü',— cu t'an a Jesus ti'ijoo'o. ");
INSERT INTO mopNT_vpl VALUES ("LK21_16","072_21_16","LUK","21","16","16","—Bele'ex a ca'a c'ubbul ti'ijoo' a tz'iic te'ex u menoo' a na' a tate'ex, a witz'ine'ex, a wet'oque'ex, a amigoje'ex. Yan ta yaame'ex a bele'ex a ca'a quimsabül u menoo' a tz'iic te'exe,— cu t'an a Jesusu. ");
INSERT INTO mopNT_vpl VALUES ("LK21_17","072_21_17","LUK","21","17","17","—Bele'ex a ca'a motzinbil u men tulacaloo' u men que'ene'ex a wool tin pach. ");
INSERT INTO mopNT_vpl VALUES ("LK21_18","072_21_18","LUK","21","18","18","C'u' betic a Dioso, tan u cününtique'ex bete cuenta ma'ax jun xiit a tzo'otzele'ex a bel u ca'a ti sa'tül jumpulu. ");
INSERT INTO mopNT_vpl VALUES ("LK21_19","072_21_19","LUK","21","19","19","Wa ca' a muc'yajtique'ex a yaj abe'e, bele'ex a ca'a a c'ümü' a cuxtala,— cu t'an a Jesusu. ");
INSERT INTO mopNT_vpl VALUES ("LK21_20","072_21_20","LUK","21","20","20","—Pues te'i. Ca' a wile'ex ti tan u xooybol ti soldado a caj Jerusalene, a weele'ex ti ma' yaab q'uin to u beel ca' c'ascunbuc a caja,— cu t'an a Jesusu. ");
INSERT INTO mopNT_vpl VALUES ("LK21_21","072_21_21","LUK","21","21","21","—Le'ec ca' c'ochocoo' a soldado te'iji, yan u puutz'uloo' yaam witz boon a que'enoo' cuenta Judeaja. Le'ec a que'enoo' ichil a caj Jerusalene, yan u joc'oloo. Le'ec a que'enoo' ich aldeaja, ma' qui' ca' ococoo' ich caj Jerusalen,— cu t'an a Jesusu. ");
INSERT INTO mopNT_vpl VALUES ("LK21_22","072_21_22","LUK","21","22","22","—Le'ec a q'uin abe'e, u q'uinil u yusq'uinbil u jel a c'as u betajoo'o. Bel u ca'a ti uchul tulacal a c'u' a tz'iiba'an yoc'ol a caja. ");
INSERT INTO mopNT_vpl VALUES ("LK21_23","072_21_23","LUK","21","23","23","Yaj ti c'axül u ca'a ti'ijoo' ix ch'up a watac u yal u yet'ocoo' a tanoo' u tz'aj chu' ti a q'uin abe'e, u men ma' tu paataloo' ti puutz'ul. Top yaj a bel u ca'a ti yantal cuenta Israel. Yaj ti bel u cu joq'ues u tz'iiquil a Dios yoc'ol a cristiano wa'ye'e,— cu t'an a Jesusu. ");
INSERT INTO mopNT_vpl VALUES ("LK21_24","072_21_24","LUK","21","24","24","—Yan a beloo' u ca'a quimsabül u men maasca'. Yan a beloo' u ca'a bensabül tulacal tubajac yoc'olcaba. Le'ecoo' a ma' Israele, beloo' u ca'a ti cuntal ichil a caj Jerusalen asto ti ca' c'ochoc u q'uinil u joc'oloo' te'i,— cu t'an a Jesusu. ");
INSERT INTO mopNT_vpl VALUES ("LK21_25","072_21_25","LUK","21","25","25","—Pues te'i. Yantal u ca'a jun p'eel u p'is tuwich a q'uin a uj a xülaba. Jac'üloo' u ca'a u yool a cristiano yoc'olcab u men u juum y u tz'iiquil a c'ac'naaba. ");
INSERT INTO mopNT_vpl VALUES ("LK21_26","072_21_26","LUK","21","26","26","Le'ec ca' u tucloo' a yaj a watac yoc'olcaba, yan a beloo' u ca'a ti süquimil u menoo' u saaquil tanil u yilic u peec a ca'ana,— cu t'an a Jesusu. ");
INSERT INTO mopNT_vpl VALUES ("LK21_27","072_21_27","LUK","21","27","27","—Pachil abe'e, beloo' u cu yileen inen a yanajeen ti cristianojili. Wataquen ich muyal etel muc'. Top nooch in yanil ca' uduquen. ");
INSERT INTO mopNT_vpl VALUES ("LK21_28","072_21_28","LUK","21","28","28","Le'ec ca' a wile'ex u caal ti uchul a c'u' in wadaj tojo, cha'ante'ex a ca'an u men u qui'ile'ex a woolo. Nütz'a'an u q'uinil a ch'a'büle'ex,— cu t'an a Jesusu. ");
INSERT INTO mopNT_vpl VALUES ("LK21_29","072_21_29","LUK","21","29","29","Pues te'i. U yadaj ti'ijoo' jun p'eel a mucult'ana. —Tucle'ex a chimun y tulacal a che'e. ");
INSERT INTO mopNT_vpl VALUES ("LK21_30","072_21_30","LUK","21","30","30","Le'ec ca' a wile'ex ti ac yan u le' tucaye'ili, a weele'ex ti nütz'a'an a ja'ja'ili. ");
INSERT INTO mopNT_vpl VALUES ("LK21_31","072_21_31","LUK","21","31","31","Baalo' ilic etel u p'is a tan u ye'ic ti watac u jobeebe. Le'ec ti tane'ex a wilic ti tan u yuchul u p'is abe'e, a weele'ex ti nütz'a'an u q'uinil u yudel a Dios ti tücaa',— cu t'an a Jesusu. ");
INSERT INTO mopNT_vpl VALUES ("LK21_32","072_21_32","LUK","21","32","32","—Tan in wadic te'ex u jajil. Tu yaamoo' a cristiano a cuxa'anoo' ti caji ti uchul u p'is abe'e, yan a beloo' u cu yila' u jobeebe. ");
INSERT INTO mopNT_vpl VALUES ("LK21_33","072_21_33","LUK","21","33","33","Le'ec a ca'an etel a yoc'olcaba, bel u ca'a ti jobol. C'u' betic in t'an inene, ma' tu chen jobol ti baalo'i. Bel u ca'a ti jajtal,— cu t'an a Jesusu. ");
INSERT INTO mopNT_vpl VALUES ("LK21_34","072_21_34","LUK","21","34","34","—Cününte'ex a bajil ti'i ma' que'enaque'ex a wool pach a fiestaja, a caalülü, y a c'u'ac tac a yan yoc'olcaba. Wa ma' a cününtique'ex a bajili, chen a wilique'exe, c'ochi tun u q'uinil abe' in tzicbaltaj jabix ilic a ch'iich' a chen u yubiqui, ac c'axa'an ichil a t'inc'aana,— cu t'an a Jesusu. ");
INSERT INTO mopNT_vpl VALUES ("LK21_35","072_21_35","LUK","21","35","35","—Uchul u ca'a c'u' a bel u ca'a ti uchul ti a q'uin abe' ti'ijoo' tulacal a boon a cristiano tulacal tubajac yoc'olcaba. ");
INSERT INTO mopNT_vpl VALUES ("LK21_36","072_21_36","LUK","21","36","36","Cününte'ex a bajil tulacal a q'uini. C'ajese'ex a Dios yoc'ol ma' a c'ümique'ex a boon a yaj in wadaj te'ex y yoc'ol ma' yane'ex a saaquil ca' talaque'ex tin taan a yanajeen ti cristianojili,— cu t'an a Jesusu. ");
INSERT INTO mopNT_vpl VALUES ("LK21_37","072_21_37","LUK","21","37","37","Pues te'i. Sansamal tan u ca'ansaj a Jesus ichil u yotoch a Dioso. Ti ac'ü' walac u joc'ol ich caj u beel ti wüyül tuwich a witz u c'aba' Olivo. ");
INSERT INTO mopNT_vpl VALUES ("LK21_38","072_21_38","LUK","21","38","38","Chen u sastala, ac que'enoo' a cristiano u yuboo' u t'an a Jesusu. ");
INSERT INTO mopNT_vpl VALUES ("LK22_1","072_22_1","LUK","22","1","1","Pues te'i. Nütz'a'an u q'uinil a fiesta le'ec ti ma' ta'ach u jantabül a pan a yan u levadurajili. Le'ec u c'aba' a fiesta abe'e, le'ec u c'ajsabül biq'uin ti mani u yaj xa'num a Dios ti ca'an yoc'oloo'. ");
INSERT INTO mopNT_vpl VALUES ("LK22_2","072_22_2","LUK","22","2","2","Ti ilic a q'uin abe'e, le'ecoo' u noochil u yaj mansaj t'an a cristiano ti'i a Dios u yet'ocoo' u yaj ca'ansajil u ley aj Moisese, tanoo' u tuclic biqui ca' u quimes a Jesusu. Saacoo' ti'i u yaabil a cristianojo. ");
INSERT INTO mopNT_vpl VALUES ("LK22_3","072_22_3","LUK","22","3","3","Pues te'i. Oqui a quisin ichil u yool aj Judasa. Iscariote u ch'ibal ala'aji. Doce tuuloo' tu bajil u yaj cambal a Jesus etel ala'aji. ");
INSERT INTO mopNT_vpl VALUES ("LK22_4","072_22_4","LUK","22","4","4","Bini ti tzicbal eteloo' u noochil u yaj mansaj t'an a cristiano ti'i a Dios u yet'ocoo' u noochiloo' u yaj cananil u yotoch a Dioso. U tzicbaltaj biqui ti jede'ec u paatal u c'ubic a Jesus ti'ijoo'o. ");
INSERT INTO mopNT_vpl VALUES ("LK22_5","072_22_5","LUK","22","5","5","Qui'oo' u yool. U yadajoo' ti'i ti beloo' u ca'a u bo'te. ");
INSERT INTO mopNT_vpl VALUES ("LK22_6","072_22_6","LUK","22","6","6","Aj Judasa, u c'ümajoo' u t'an. Caji u yila' biq'uin qui' ca' u tzolo' a Jesus le'ec ti ma' yaaboo' a cristiano etele. ");
INSERT INTO mopNT_vpl VALUES ("LK22_7","072_22_7","LUK","22","7","7","Pues te'i. C'ochi u q'uinil a fiesta le'ec ti ma' ta'ach u jantabül a pan a yan u levadurajili. Ti a q'uin abe'e, walac u quimsabül a carnero ti'i u c'ajsabeebal ti mani u yaj xa'num a Dios ti ca'an yoc'oloo' uchi. ");
INSERT INTO mopNT_vpl VALUES ("LK22_8","072_22_8","LUK","22","8","8","—Ca' xique'ex a wutzquinte to'on a janal ti'i a fiesta ca' ti jante,— cu t'an a Jesus ti'ijoo' aj Pedro etel aj Juana. ");
INSERT INTO mopNT_vpl VALUES ("LK22_9","072_22_9","LUK","22","9","9","—¿Tuba a c'ati ca' xico'on ti wutzquinte?— cu t'anoo' ti'i. ");
INSERT INTO mopNT_vpl VALUES ("LK22_10","072_22_10","LUK","22","10","10","—U'ye'ex in t'an. Le'ec ca' ocoque'ex ich caj, bele'ex a ca'a a c'ümü' jun tuul a winiqui. Tan u c'oochtic jun p'e p'uul a ja'a. Xene'ex tu pach tac ichil a naj tuba u yocolo. ");
INSERT INTO mopNT_vpl VALUES ("LK22_11","072_22_11","LUK","22","11","11","“¿Tuba que'en u cuartojil a posado tuba bel in quin jante u janalil a fiesta eteloo' in waj cambal? cu t'an a Maestro teche,” que'exac ti'i u yumil a naja,— cu t'an a Jesus ti'ijoo' a ca' tuulu. ");
INSERT INTO mopNT_vpl VALUES ("LK22_12","072_22_12","LUK","22","12","12","—Bel u cu yee' te'ex jun p'eel a noxi' cuarto ti u ca' tzaam a naja. Ac yan tun u cuuchil a janal te'iji. Te'i a wutzquintique'ex ti janal,— cu t'an a Jesusu. ");
INSERT INTO mopNT_vpl VALUES ("LK22_13","072_22_13","LUK","22","13","13","Binoo'. U cüxtajoo' jabix ilic a aalboo' ti'iji. U yutzquintajoo' a janala. ");
INSERT INTO mopNT_vpl VALUES ("LK22_14","072_22_14","LUK","22","14","14","Pues te'i. Le'ec ti c'ochi u yorajil a janala, que'en pach mesa a Jesus u yet'ocoo' u yaj cambal. ");
INSERT INTO mopNT_vpl VALUES ("LK22_15","072_22_15","LUK","22","15","15","—Top que'en in wool in jante u janalil a fiesta ada' ta wetele'ex ti ma'ax to quimsabüquen,— cu t'an a Jesus ti'ijoo'o. ");
INSERT INTO mopNT_vpl VALUES ("LK22_16","072_22_16","LUK","22","16","16","—Tan in wadic te'ex. Le'ec a fiesta ada'a, chen u p'is a chucul fiesta a uchul u ca'a tu cuenta a Dioso. Ma' tin ca' jantic ada' tucaye'il asto u yuchul u chucul u jajil tu cuenta a Dioso,— cu t'an a Jesusu. ");
INSERT INTO mopNT_vpl VALUES ("LK22_17","072_22_17","LUK","22","17","17","U müchaj a poteje. U yadaj a bo'tic ti'i a Dioso. —Jeda'. T'oxo ta bajile'ex. ");
INSERT INTO mopNT_vpl VALUES ("LK22_18","072_22_18","LUK","22","18","18","Tan in wadic te'ex. Ma' tin ca' uq'uic u c'a' a uvaja, asto u c'ochol u q'uinil u tücaa' a Dios yoc'olcab,— cu t'an a Jesusu. ");
INSERT INTO mopNT_vpl VALUES ("LK22_19","072_22_19","LUK","22","19","19","U ch'a'aj a waj harinaja. U yadaj a bo'tic ti'i a Dioso. U xet'aj. U tz'aj ti'ijoo' u yaj cambal. —Le'ec ada' in büq'uel a bel u ca'a yajcunbul ta woc'lale'exe. Tanaque'ex a betic ada'a, ti'i in c'ajsabeebal,— cu t'an a Jesusu. ");
INSERT INTO mopNT_vpl VALUES ("LK22_20","072_22_20","LUK","22","20","20","Le'ec ti jobi a janala, baalo' ilic u betaj etel a uc'ulu. —Le'ec a uc'ul ada'a, le'ec u p'is a tumul t'an a tz'abi te'exe. Yan u muc' a tumul t'an abe'e, u men in q'uiq'uel le'ec ca' quimsabüquene,— cu t'an a Jesusu. ");
INSERT INTO mopNT_vpl VALUES ("LK22_21","072_22_21","LUK","22","21","21","—Pues te'i. Tan in wadic te'ex. Le'ec mac a bel u cu c'ubeen ti'ijoo' a tz'iic tene, wa'ye' que'en pach mesa ti janal tiqui wetel,— cu t'an a Jesus ti'ijoo' u yaj cambala. ");
INSERT INTO mopNT_vpl VALUES ("LK22_22","072_22_22","LUK","22","22","22","Le'ec inen a yanajeen ti cristianojili, bel in ca'a in c'ümü' c'u' a tz'abi ten ca' in c'ümü'ü. Ca'ax tz'abi ca' in c'ümü' abe'e, top yaj a bel u cu c'ümü' a winic a bel u cu tzoleen ti'i ca' quimsabüquen,— cu t'an a Jesusu. ");
INSERT INTO mopNT_vpl VALUES ("LK22_23","072_22_23","LUK","22","23","23","Le'ecoo' u yaj cambala, cajoo' u c'aate tu bajil mac tu yamoo' bel u cu bete' abe'e. ");
INSERT INTO mopNT_vpl VALUES ("LK22_24","072_22_24","LUK","22","24","24","Pues te'i. Le'ecoo' u yaj cambala, cajoo' u p'ujes u bajil ti t'an yoc'ol mac a mas nooch u wichil u meyaj tu yaamoo'o. ");
INSERT INTO mopNT_vpl VALUES ("LK22_25","072_22_25","LUK","22","25","25","—Le'ecoo' a rey yoc'olcaba, walacoo' u betic ti top noochoo' u yubi u bajil ti'ijoo' a cristianojo. “Ma'lo' winic,” cu t'anoo' ti'i a noochoo' u wichil u meyaja,— cu t'an a Jesusu. ");
INSERT INTO mopNT_vpl VALUES ("LK22_26","072_22_26","LUK","22","26","26","—Ma' qui' ca' a bete'ex ti baalo'. Le'ec cuchi mac a nooch u wichil u meyaj ta yaame'exe, yan u betic jabix ma' noochi. Le'ec mac a tan u tücaa' ta yaame'exe, yan u tz'eec u bajil ti anat jabix mozotzili,— cu t'an a Jesusu. ");
INSERT INTO mopNT_vpl VALUES ("LK22_27","072_22_27","LUK","22","27","27","—¿Mac a mas nooch u yanili, le'ec wa a que'en pach mesa ti janala, wa le'ec a tz'abi ti t'ox janal? Le'ec a que'en pach mesa, le'ec a mas noocho. C'u' betiqui, que'enen ta yaame'ex jabix jun tuul a tan u yanat jabix mozotzili,— cu t'an a Jesusu. ");
INSERT INTO mopNT_vpl VALUES ("LK22_28","072_22_28","LUK","22","28","28","—Pues te'i. Inche'exe, que'ene'ex tin wetel le'ec ca' in c'ümaj a yaj boon in c'ümaj tunu. ");
INSERT INTO mopNT_vpl VALUES ("LK22_29","072_22_29","LUK","22","29","29","Le'ec in Tata, u tz'aj ten ca' uchuc in tücaa'. Baalo' ilic a tan in tz'eec te'exe. Bele'ex ilic a ca'a ti tücaa'. ");
INSERT INTO mopNT_vpl VALUES ("LK22_30","072_22_30","LUK","22","30","30","Ti baalo'o, bele'ex a ca'a ti janal ti uc'ul tin wetel le'ec ca' c'ochoque'ex tin cuentaja. Tan ilic in tz'eec te'ex a meyaj. Bele'ex a ca'a a tücaa'too' aj Israel a doce muuch'oo' tu bajili,— cu t'an a Jesusu. ");
INSERT INTO mopNT_vpl VALUES ("LK22_31","072_22_31","LUK","22","31","31","—Pues te'i. Simon, u'yi in t'an. Le'ec a quisini, u c'aataj ti'i Dios ca' u yaalteex ca' u yila' wa tu jajil que'ene'ex a wool tu pach a Dioso. Bel u cu bete' te'ex jabix ca' u chaachte a semilla a harina ca' u yila' wa yan u quich'panili. ");
INSERT INTO mopNT_vpl VALUES ("LK22_32","072_22_32","LUK","22","32","32","C'u' betiqui, in c'ajsaj a Dios ta woc'ol ti'i ma' a ch'a'ic u joc'ol a wool tu pach a Dioso. Le'ec ca' c'aac a winiquil a tz'oques a Dioso, tz'ajoo' u muc' u t'an a hermanojo,— cu t'an a Jesus ti'i aj Simono. ");
INSERT INTO mopNT_vpl VALUES ("LK22_33","072_22_33","LUK","22","33","33","—Noochil, paac' in ca'a in beel ta pach ca'ax xiquen ti presojil, ca'ax xiquen ti quimsabül,— cu t'an aj Simon Pedro ti'iji. ");
INSERT INTO mopNT_vpl VALUES ("LK22_34","072_22_34","LUK","22","34","34","—Pedro, tan in wadic tech. Aleebe ox sut bel a ca'a a wadü' ti ma' a weel in wich ca' tun uchuc u yawat aj t'ele,— cu t'an a Jesusu. ");
INSERT INTO mopNT_vpl VALUES ("LK22_35","072_22_35","LUK","22","35","35","—Pues te'i. Le'ec ca' in tücaa'taje'ex biq'uin ado'o, in wadaj te'ex ti ma' a bensique'ex a taq'uini, ma'ax u cuuchil a taq'uini, ma'ax a cayte. Le'ec ti bine'exe, ¿yan wa c'u' a c'abeet te'ex a ma' a yanaji te'ex?— cu t'an a Jesus ti'ijoo' u yaj cambala. —Ma' yan,— cu t'anoo' ti uchoo' u nuuc. ");
INSERT INTO mopNT_vpl VALUES ("LK22_36","072_22_36","LUK","22","36","36","—Aleebe tan in wadic te'ex. Le'ec mac a yan u taq'uini, yan u bensic tu pach. Yan ilic u bensic u cuuchil u taq'uini. Le'ec mac a ma' yan u maasca'a, yan u conic u chaqueta ti'i ca' u q'uexe' u maasca'. ");
INSERT INTO mopNT_vpl VALUES ("LK22_37","072_22_37","LUK","22","37","37","Aleebe tan in wadic te'ex abe' u men yan u yuchul ten a c'u' a tz'iiba'an ichil u ju'um a Dioso. “Tz'abi tu yaamoo' aj c'ac'as cristiano bete cuenta c'ac'as cristiano ilic ala'aji,” cu t'an u ju'um a Dios yoc'ol a Cristojo,— cu t'an a Jesusu. ");
INSERT INTO mopNT_vpl VALUES ("LK22_38","072_22_38","LUK","22","38","38","—Ila Noochil. Jeda' ca' tziit a maasca'a,— cu t'anoo' ti'i. —Chucul,— cu t'an ti'ijoo'. ");
INSERT INTO mopNT_vpl VALUES ("LK22_39","072_22_39","LUK","22","39","39","Pues te'i. Joq'ui a Jesus pach naja. Bini ti a witz u c'aba' Olivo tuba walac u boch bel. Tücünacoo' u yaj cambal tu pach. ");
INSERT INTO mopNT_vpl VALUES ("LK22_40","072_22_40","LUK","22","40","40","Le'ec ti c'ochi te'iji, u yadaj ti'ijoo' u yaj cambal: —Tanaque'ex a t'an etel Dios ti'i ma' u yemele'ex a wool a bete'ex a c'asa,— cu t'an ti'ijoo'. ");
INSERT INTO mopNT_vpl VALUES ("LK22_41","072_22_41","LUK","22","41","41","Bini tu junal jabix wal jun p'e c'aan mas naach. Xonlaji te'i ti t'an etel a Dioso. ");
INSERT INTO mopNT_vpl VALUES ("LK22_42","072_22_42","LUK","22","42","42","—Tat, wa a c'atiji, ma' cha'ic in c'ümic a yaj a watac tin woc'ol. C'u' betiqui, ma' a betic a jabix in c'ati inene. Bete jabix a c'ati incheche,— cu t'an a Jesus ti'i a Tattzili. ");
INSERT INTO mopNT_vpl VALUES ("LK22_43","072_22_43","LUK","22","43","43","Chiclaji jun tuul u yaj xa'num a Dios ti ca'an tu tzeele. Chichcunbi u yool a Jesusu. ");
INSERT INTO mopNT_vpl VALUES ("LK22_44","072_22_44","LUK","22","44","44","Pues te'i. Yaj u yool a Jesusu, mentücü, mas u tz'aj u muc' u yool ti t'an etel a Dioso. Nooch a jujun t'aaj u quilcab a tan u t'aaj ti lu'um jabix u t'aaj a q'uiq'ui. ");
INSERT INTO mopNT_vpl VALUES ("LK22_45","072_22_45","LUK","22","45","45","Le'ec ti jobi ti t'an etel a Dioso, liq'ui. Usc'aji eteloo' u yaj cambal. Ca' u yilajoo'o, tanoo' u wüyül u men u yajiloo' u yool. ");
INSERT INTO mopNT_vpl VALUES ("LK22_46","072_22_46","LUK","22","46","46","—¿C'u' ca'a tane'ex a wüyül? Liq'uene'ex. Tanaque'ex a t'an etel Dios ti'i ma' u yemsabüle'ex a wool a bete'ex a c'asa,— cu t'an ti'ijoo' u yaj cambal. ");
INSERT INTO mopNT_vpl VALUES ("LK22_47","072_22_47","LUK","22","47","47","Pues te'i. Tan to u t'an a Jesus ti c'ochoo' u yaabil a cristianojo. Tanoo' u c'ochesabül u men a jun tuulu, aj Judas u c'aba'. Ala'aji, jun tuul tu yaamoo' a doce tuuloo' u yaj cambal a Jesusu. Naatz'i tu tzeel a Jesus u yutzinte jabix ti sucoo' u bete'. ");
INSERT INTO mopNT_vpl VALUES ("LK22_48","072_22_48","LUK","22","48","48","—Judas, ¿bel wa a ca'a a c'ubeen ca' yajcunbuquen a yanajeen ti cristianojil chen etel a wutzintiquin?— cu t'an a Jesus ti'iji. ");
INSERT INTO mopNT_vpl VALUES ("LK22_49","072_22_49","LUK","22","49","49","Pues te'i. U yaj cambal a Jesusu, u na'tajoo' c'u' a bel u ca'a ti uchulu. —Noochil, ¿a c'ati wa ca' in tz'aa' ti'ijoo' ti maasca'?— cu t'anoo' ti'i a Jesusu. ");
INSERT INTO mopNT_vpl VALUES ("LK22_50","072_22_50","LUK","22","50","50","Jun tuul u yaj cambala, u jan ch'üctaj jun tuul u yaj meyaj a winic a mas nooch u wichil u meyaj tu yaamoo' u yaj mansaj t'an a cristiano ti'i a Dioso. Ch'ücbi u xiquin tu yaj toj tu yaj seeb. ");
INSERT INTO mopNT_vpl VALUES ("LK22_51","072_22_51","LUK","22","51","51","—P'ütü a maasca',— cu t'an u yaalbül u men a Jesusu. Tülbi u xiquin a ch'ücbiji. Ch'anesabi. ");
INSERT INTO mopNT_vpl VALUES ("LK22_52","072_22_52","LUK","22","52","52","Pues te'i. Tu yaam a c'ochoo' u müchü' a Jesusu, que'enoo' u noochil u yaj mansaj t'an a cristiano ti'i a Dioso. Te'i ilic que'en u noochiloo' u yaj cananil u yotoch a Dios eteloo' a nucuch winic ti'i a caja. —¿Ude'ex wa etel maasca' etel che' jabix cuchi ude'ex a müchü' aj xuuch'u?— cu t'an a Jesus ti'ijoo'o. ");
INSERT INTO mopNT_vpl VALUES ("LK22_53","072_22_53","LUK","22","53","53","—Le'ec ti que'enen ta yaame'ex sansamal ichil u yotoch a Dioso, ma' a müchajene'exi. C'u' betic aleebe, c'ochi u yorajil te'ex etel u yorajil ti'i a quisin a walac u tücaa' ichil a jabix ac'ü'ü,— cu t'an a Jesusu. ");
INSERT INTO mopNT_vpl VALUES ("LK22_54","072_22_54","LUK","22","54","54","Pues te'i. U müchajoo' a Jesusu. Cajoo' u benes tu yotoch a winic a mas nooch u wichil u meyaj tu yaamoo' u yaj mansaj t'an a cristiano ti'i a Dioso. Naach tücünac aj Pedro tu pacha. ");
INSERT INTO mopNT_vpl VALUES ("LK22_55","072_22_55","LUK","22","55","55","Le'ec ti c'ochoo'o, yan u t'übajoo' a c'aac' chumuc a coto. Tinlajoo' tu xoy a c'aac'a. Tinlaji ilic xan aj Pedro tu yaamoo'o. ");
INSERT INTO mopNT_vpl VALUES ("LK22_56","072_22_56","LUK","22","56","56","Ilbi aj Pedro u men jun tuul ix meyaj te'i. Chica'an aj Pedro u men u sac a c'aac' tuba tina'an. U cha'antaj ti qui' u wich. —Le'ec a winic ada'a, u yet'oc a Jesusu,— cu t'an ix meyaja. ");
INSERT INTO mopNT_vpl VALUES ("LK22_57","072_22_57","LUK","22","57","57","U yadaj ti ma' le'equi. —Nooch'up, ma' in weel u wich ala'aji,— cu t'an aj Pedrojo. ");
INSERT INTO mopNT_vpl VALUES ("LK22_58","072_22_58","LUK","22","58","58","Ma' xan tu pach abe'e, ilbi u men ulaac' a jun tuulu. —Inchech jun tuul u yet'oc a Jesusu,— cu t'an ti'i. —U'yeen, ma' ineni,— cu t'an aj Pedrojo. ");
INSERT INTO mopNT_vpl VALUES ("LK22_59","072_22_59","LUK","22","59","59","Jabix wal jun p'e hora manüc ti ca' u yadaj tulacal u yool a jun tuulu: —Tu jajil que'en a winic ada' etel a Jesus biq'uin ado'o. Chica'an u men aj Galilea ilic ala'aji,— cu t'an a jun tuul abe'e. ");
INSERT INTO mopNT_vpl VALUES ("LK22_60","072_22_60","LUK","22","60","60","—U'yeen, ma' in weel c'u' a tan a wadiqui,— cu t'an aj Pedrojo. Le'ec ti tan to u t'an aj Pedrojo, uchi u yawat aj t'ele. ");
INSERT INTO mopNT_vpl VALUES ("LK22_61","072_22_61","LUK","22","61","61","Le'ec a Noochtzili, u sutaj u bajil u cha'ante aj Pedrojo. C'aji ti'i aj Pedro u t'an a Noochtzil a aalbi ti'iji. —Aleebe ox sut bel a ca'a a wadü' ti ma' a weel in wich ca' tun uchuc u yawat aj t'ele,— cu t'an a Jesus ti'i biq'uin ado'o. ");
INSERT INTO mopNT_vpl VALUES ("LK22_62","072_22_62","LUK","22","62","62","Joq'ui te'i aj Pedrojo. Uchi u yoc'ol tu jajil u men a c'u' u betaja. ");
INSERT INTO mopNT_vpl VALUES ("LK22_63","072_22_63","LUK","22","63","63","Pues te'i. P'a'asbi y jütz'bi a Jesus u menoo' a winic a tanoo' u canana. ");
INSERT INTO mopNT_vpl VALUES ("LK22_64","072_22_64","LUK","22","64","64","U tepajoo' u wich a Jesus etel noc'. —Na'te mac u jütz'ajech. Adü to'on,— cu t'anoo' ti'i. ");
INSERT INTO mopNT_vpl VALUES ("LK22_65","072_22_65","LUK","22","65","65","U p'a'astajoo' a Jesus ti yaaba. ");
INSERT INTO mopNT_vpl VALUES ("LK22_66","072_22_66","LUK","22","66","66","Pues te'i. Le'ec ti sasajiji, much'lajoo' a nucuch winiqui, u yet'ocoo' u noochiloo' u yaj mansaj t'an a cristiano ti'i a Dios eteloo' u yaj ca'ansajil u ley aj Moisese. Bensabi a Jesus tu taanoo'o. ");
INSERT INTO mopNT_vpl VALUES ("LK22_67","072_22_67","LUK","22","67","67","—Wa le'ec inchech a Cristo le'ec u yaj Sa'alil a cristianojo, adü to'on,— cu t'anoo' ti'i. —Wa ca' in wadü' te'exe, ma' ta tz'ocsiquene'ex,— cu t'an ti'ijoo'. ");
INSERT INTO mopNT_vpl VALUES ("LK22_68","072_22_68","LUK","22","68","68","—Wa ca' in c'aate te'ex jun p'eelac a t'ana, ma' ta nuuctiquene'exi, y ma' ta cha'iquene'ex. ");
INSERT INTO mopNT_vpl VALUES ("LK22_69","072_22_69","LUK","22","69","69","Le'ec inen a yanajeen ti cristianojili, seeba'an in beel ti tintal tu yaj toj tu yaj seeb c'ü' a Dioso. Yaab u muc' ala'aji,— cu t'an a Jesusu. ");
INSERT INTO mopNT_vpl VALUES ("LK22_70","072_22_70","LUK","22","70","70","—¿Inchech wa u Mejen a Dioso?— cu t'anoo' ti'i u men c'u' u yadaja. —Le'equen. Jaje'ex a t'an,— cu t'an a Jesusu. ");
INSERT INTO mopNT_vpl VALUES ("LK22_71","072_22_71","LUK","22","71","71","—¿C'u' aj beel to'on ulaac' mac ca' u tzolo' to'on u sip'il. Ti wu'yaj u yadic ti le'ec ala'aji, le'ec u Mejen a Dioso,— cu t'anoo' tu bajil. ");
INSERT INTO mopNT_vpl VALUES ("LK23_1","072_23_1","LUK","23","1","1","Pues te'i. Wa'lajoo' tulacaloo' ala'oo'o. U bensajoo' a Jesus tu taan aj gobernador Pilatojo. ");
INSERT INTO mopNT_vpl VALUES ("LK23_2","072_23_2","LUK","23","2","2","Cajoo' u tzolo' a Jesusu. —Ti cüxtaj a winic ada' ti tan u c'ascuntic u na'at a boon a caja. Tan u yaalbül ti ma' qui' ca' bolboc c'u' a tan u c'aatic a rey cuenta Romaja. Tan u yadic u bajil ti Cristojil. Tanil u yadic abe'e, tan u yadic ti le'ec ti rey,— cu t'anoo' ti'i a gobernadoro. ");
INSERT INTO mopNT_vpl VALUES ("LK23_3","072_23_3","LUK","23","3","3","—¿Inchech wa u reyoo' aj Israele?— cu t'an aj Pilato ti'i a Jesusu. —Le'equen. Jaj a t'an,— cu t'an a Jesus ti uchi u nuuc. ");
INSERT INTO mopNT_vpl VALUES ("LK23_4","072_23_4","LUK","23","4","4","—Ma' in cüxtaj u sip'il a winic ada'i,— cu t'an aj Pilato ti'ijoo' u noochiloo' u yaj mansaj t'an a cristiano ti'i a Dios u yet'ocoo' u yaabil a cristianojo. ");
INSERT INTO mopNT_vpl VALUES ("LK23_5","072_23_5","LUK","23","5","5","Mas chichoo' u t'an a cristianojo. —Walac u p'ujsicoo' a cristianojo. Walac u ca'ansicoo' tulacal tubajac cuenta Judeaja. Tac cuenta Galilea tac wa'ye' walac u betic abe'e,— cu t'anoo' ti'i aj Pilatojo. ");
INSERT INTO mopNT_vpl VALUES ("LK23_6","072_23_6","LUK","23","6","6","Pues te'i. Le'ec ca' u yubaj abe' aj Pilatojo, u c'aataj ti'ijoo' wa Galilea tali a Jesusu. ");
INSERT INTO mopNT_vpl VALUES ("LK23_7","072_23_7","LUK","23","7","7","Le'ec ca' u yeeltaj ti te'i u caal tu cuenta aj gobernador Herodese, u tücaa'taj a Jesus etele. Ti'i ilic a q'uin abe'e, tan u sut aj Herodes te'i ilic ich caj Jerusalen. ");
INSERT INTO mopNT_vpl VALUES ("LK23_8","072_23_8","LUK","23","8","8","Le'ec ca' u yilaj a Jesus aj Herodese, qui' u yool. Uchi ilic u c'atiinte u yila' u wich a Jesus u men boon a c'u' u yubaj yoc'ol. U c'atiintaj cuchi u yila' ca' u bete' a milagro a Jesusu. ");
INSERT INTO mopNT_vpl VALUES ("LK23_9","072_23_9","LUK","23","9","9","Chawac u pach u t'an ti tan u c'aatic u chi' a Jesusu. C'u' betiqui, ma' uchi u nuuc a Jesusu. ");
INSERT INTO mopNT_vpl VALUES ("LK23_10","072_23_10","LUK","23","10","10","Pues te'i. Le'ec u noochiloo' u yaj mansaj t'an a cristiano ti'i a Dios eteloo' boon u yaj ca'ansajil u ley aj Moisese, wa'anoo' te'i. Chichoo' u t'an u menoo' u tz'iiquil ti tanoo' u tzolic a Jesusu. ");
INSERT INTO mopNT_vpl VALUES ("LK23_11","072_23_11","LUK","23","11","11","Pues te'i. Le'ec aj Herodes eteloo' u soldadojo, ma' u tz'ocsajoo' u yanil a Jesus ma'ax tz'etz'eeque. U p'a'astajoo'. U tz'ajoo' a noc' jabix u noc' a rey yoc'olo. U ca' tücaa'taj ca' xi'ic etel aj Pilato. ");
INSERT INTO mopNT_vpl VALUES ("LK23_12","072_23_12","LUK","23","12","12","Biq'uin ado'o, tz'iicoo' tu bajil aj Herodes etel aj Pilatojo. C'u' betiqui, ti'i a q'uin abe'e, qui'ajoo' tu bajil, u men c'u' u betajoo' ti'i a Jesusu. ");
INSERT INTO mopNT_vpl VALUES ("LK23_13","072_23_13","LUK","23","13","13","Pues te'i. Aj Pilatojo, u yadaj ca' u much'quintoo' u bajil u noochiloo' u yaj mansaj t'an a cristiano ti'i a Dios eteloo' a nucuch winic eteloo' u chucaan a cristiano xan. ");
INSERT INTO mopNT_vpl VALUES ("LK23_14","072_23_14","LUK","23","14","14","—A talesaje'ex ten a winic ada'a. “Tan u c'ascunticoo' u na'at a boon a caja,” que'ex ten. In c'aataj u chi' ta taane'ex. U'yeene'ex. Ma' in cüxtaj ma'ax jun p'eel u sip'il a jabix a wadaje'exe,— cu t'an aj Pilatojo. ");
INSERT INTO mopNT_vpl VALUES ("LK23_15","072_23_15","LUK","23","15","15","—Ma'ax aj Herodes, ma' u cüxtaj u sip'ili, mentücü, u ca' tücaa'taj wa'ye'. U'yeene'ex. Ma'ax c'u' u betaj ca' quimsabücü, ");
INSERT INTO mopNT_vpl VALUES ("LK23_16","072_23_16","LUK","23","16","16","mentücü, bel in quin jütz'ü' ca' tun in chaa',— cu t'an aj Pilatojo. ");
INSERT INTO mopNT_vpl VALUES ("LK23_17","072_23_17","LUK","23","17","17","Ti tan a fiesta abe'e, walac u cha'bül jun tuul preso, mentüc u yadaj abe'e. ");
INSERT INTO mopNT_vpl VALUES ("LK23_18","072_23_18","LUK","23","18","18","Tulacaloo' a cristianojo, ich quetil u yadajoo' ti chich: —Quimes a winic ada'a. Cha'a to'on aj Barrabasa,— cu t'anoo'. ");
INSERT INTO mopNT_vpl VALUES ("LK23_19","072_23_19","LUK","23","19","19","Tz'abi ti presojil aj Barrabas u men u yaaltaj u joq'ues a gobierno ich Jerusalen etel u men uchi u quimsaj. ");
INSERT INTO mopNT_vpl VALUES ("LK23_20","072_23_20","LUK","23","20","20","Aj Pilatojo, u c'ati cuchi u chaa' a Jesusu, mentücü ca' caji ti t'an eteloo' a cristianojo. ");
INSERT INTO mopNT_vpl VALUES ("LK23_21","072_23_21","LUK","23","21","21","—Tz'a tuwich cruz. Tz'a tuwich cruz,— cu t'anoo' ti'i ti chich. ");
INSERT INTO mopNT_vpl VALUES ("LK23_22","072_23_22","LUK","23","22","22","—¿C'u' ca'a baalo' a c'ate'exe? ¿C'u' ti sip'ilil u betaja? Ma' in cüxtaj ma'ax c'u' u betaj ca' quimsabücü, mentücü, bel in quin jütz'ü' ca' tun in chaa',— cu t'an aj Pilato ti'ijoo' tu yox sut. ");
INSERT INTO mopNT_vpl VALUES ("LK23_23","072_23_23","LUK","23","23","23","Le'ecoo' a cristianojo, top u c'atoo' ca' quimsabüc. Tan ti tanoo' u yadic ti chich ca' quimsabüc tuwich cruz. Yanaji u tz'ocsicoo' u t'an, ");
INSERT INTO mopNT_vpl VALUES ("LK23_24","072_23_24","LUK","23","24","24","mentüc aj Pilatojo, u yadaj ca' quimsabüc jabix u c'atoo'. ");
INSERT INTO mopNT_vpl VALUES ("LK23_25","072_23_25","LUK","23","25","25","Le'ec a winic aj Barrabas a tz'abi ti presojil u men u yaaltaj u joq'ues a gobierno etel u men uchi u quimsaja, u cha'aj ca' joc'oc. U yadaj ca' quimsabüc a Jesus jabix u c'atoo' a cristianojo. ");
INSERT INTO mopNT_vpl VALUES ("LK23_26","072_23_26","LUK","23","26","26","Pues te'i. Yan jun tuul a winiqui, aj Simon u c'aba'. Cirene u caal ala'aji. Joq'ui to ich aldea. Tan to u c'ochol ich caj Jerusalen ti tan u bensabül a Jesusu. Müchbi aj Simono. Tz'abi ti'i ca' u c'oochte u cruz a Jesusu. Tu pach a Jesus que'en ala'aji. ");
INSERT INTO mopNT_vpl VALUES ("LK23_27","072_23_27","LUK","23","27","27","Pues te'i. Mani tu pach u yaabil a cristiano a tücünacoo' tu pacha. Yaaboo' ix ch'up te'i a tanoo' u yoc'tic a Jesusu. ");
INSERT INTO mopNT_vpl VALUES ("LK23_28","072_23_28","LUK","23","28","28","Le'ec a Jesusu, u sutaj u bajil ti t'an eteloo'. —Nooch'upe'ex a que'ene'ex Jerusalen, ma' a woc'tiquene'ex. Oc'te'ex a bajil. Uchuque'ex a woc'ol yoc'lale'ex a wal,— cu t'an a Jesusu. ");
INSERT INTO mopNT_vpl VALUES ("LK23_29","072_23_29","LUK","23","29","29","—U'yeene'ex. Watac to u q'uinil ti beloo' u cu yadü' ti mas qui' u yool ix ma' alil ch'upu. Mas qui' u yool a ma'ax jun sut uchuc u yal etel a ma'ax jun sut uchuc u ch'ijsaja,— cu t'an a Jesus ti'ijoo'o. ");
INSERT INTO mopNT_vpl VALUES ("LK23_30","072_23_30","LUK","23","30","30","—Ti a q'uin abe'e, le'ecoo' a cristianojo, beloo' u cu c'atiinte ca' puch'bucoo' u men a noxi' witzi. Beloo' u cu c'atiinte ca' buuybucoo' u men aj meen witzi. ");
INSERT INTO mopNT_vpl VALUES ("LK23_31","072_23_31","LUK","23","31","31","Inen jabixen aj cuxul che'e. A caja, jabix a che' a tiquini. Chücyajil u chuwul a che' a cuxulu, ¿uxtun a tiquini?— cu t'an a Jesus ich mucult'an ti'ijoo' a nooch'up yoc'ol a yaj a watac yoc'oloo' u menoo' u sip'il. ");
INSERT INTO mopNT_vpl VALUES ("LK23_32","072_23_32","LUK","23","32","32","Pues te'i. Tan u bensabül ca' tuul a preso tu pach a Jesus ti'i ca' quimicoo' ich quetil. ");
INSERT INTO mopNT_vpl VALUES ("LK23_33","072_23_33","LUK","23","33","33","Le'ec ti c'ochoo' ti a witz Calvario u c'aba'a, u tz'ajoo' a Jesus tuwich u cruzili. U tz'ajoo' ilic a ca' tuul tuwichoo' u cruzili, jujun tuuloo' tuwich cruz. Tz'abi a jujun tuul jujun xeel a Jesusu. ");
INSERT INTO mopNT_vpl VALUES ("LK23_34","072_23_34","LUK","23","34","34","Pues te'i. Baala' u yadaj a Jesusu: —Tat, sa'tesoo' ti'i mac tanoo' u betic ten a yaja, u men ma' u yeeloo' c'u' a tanoo' u betiqui,— cu t'an a Jesusu. U baxültajoo' a bul yoc'ol u noc' a Jesus ti'i ca' u t'oxo' tu bajil. ");
INSERT INTO mopNT_vpl VALUES ("LK23_35","072_23_35","LUK","23","35","35","Wa'anoo' a cristiano te'i ti cha'an. Le'ec a boon a noochoo' u wichil u meyaja, u p'a'astajoo' a Jesusu. —U sa'altajoo' tac ulaac' a maca. Aleebe ca' u sa'alte u bajil wa jaj ti Cristo ala'aji, wa yeeta'an u men a Dioso,— cu t'anoo' a noochoo' u wichil u meyaja. ");
INSERT INTO mopNT_vpl VALUES ("LK23_36","072_23_36","LUK","23","36","36","P'a'asbi ilic u menoo' a soldadojo. Naatz'oo' tu tzeel. U tz'aj a vino a top ema'an u tool ti'i ca' u yuc'u'u. ");
INSERT INTO mopNT_vpl VALUES ("LK23_37","072_23_37","LUK","23","37","37","—Wa inchech u reyoo' aj Israele, sa'alte a bajil,— cu t'anoo' ti'i. ");
INSERT INTO mopNT_vpl VALUES ("LK23_38","072_23_38","LUK","23","38","38","—Le'ec ada' u reyoo' aj Israele,— cu t'an a t'an a tz'iiba'an yoc'ol a Jesusu, bete cuenta le'ec u sip'il. Ich ox paay t'an tz'iiba'an, griego, latin, y hebreo. Tz'abi tac tu pol u cruz. ");
INSERT INTO mopNT_vpl VALUES ("LK23_39","072_23_39","LUK","23","39","39","Pues te'i. P'a'asbi a Jesus u men jun tuul a c'ac'as winic a que'en tuwich u cruzil tu tzeele. —Wa Cristojeche, sa'alte a bajil. Sa'alto'on ilic xan,— cu t'an ti'i. ");
INSERT INTO mopNT_vpl VALUES ("LK23_40","072_23_40","LUK","23","40","40","C'u' betiqui, tze'ecbi u men ulaac' a jun tuulu. —¿Ma' wa ta'ach a saactic a Dioso? Quet yaj a tan ti c'ümic etel a winic ada'a. ");
INSERT INTO mopNT_vpl VALUES ("LK23_41","072_23_41","LUK","23","41","41","Toj a tan ti c'ümic ino'ono, u men tan ti bo'tic ti sip'il. C'u' betiqui, ma'ax c'u' u sip'il a winic ada'a,— cu t'an a jun tuul abe' ti'i u yet'oco. ");
INSERT INTO mopNT_vpl VALUES ("LK23_42","072_23_42","LUK","23","42","42","—Jesus, le'ec ca' ocoquech ti reyil, c'ajseen,— cu t'an a jun tuul abe'e. ");
INSERT INTO mopNT_vpl VALUES ("LK23_43","072_23_43","LUK","23","43","43","—Tan in wadic tech u jajil. Leeb a beel tin pach ichil u cuuchil a tojoo' u na'ata,— cu t'an a Jesus ti'i a jun tuul abe'e. ");
INSERT INTO mopNT_vpl VALUES ("LK23_44","072_23_44","LUK","23","44","45","Pues te'i. Jabix wal chuunq'uin tupi a q'uini. Ma' ca' chica'an u sac asto ti jabix wal a las tres ti a ocq'uini. Tziili jumpul a noc' a xit'a'an ti'i u colocche'il a cuarto ichil u yotoch a Dioso. ");
INSERT INTO mopNT_vpl VALUES ("LK23_46","072_23_46","LUK","23","46","46","Uchi u t'an ti chich a Jesusu. —Tat, tan in c'ubic tech in püsüc'al,— cu t'an ti chich. Le'ec ca' u yadaj a t'an abe'e, quimi. ");
INSERT INTO mopNT_vpl VALUES ("LK23_47","072_23_47","LUK","23","47","47","Pues te'i. Le'ec u noochiloo' a soldadojo, le'ec ca' u yilaj c'u' a maniji, u yadaj u qui'il a Dioso. —Tu jajil toj u na'at a winic ada'a,— cu t'an. ");
INSERT INTO mopNT_vpl VALUES ("LK23_48","072_23_48","LUK","23","48","48","Tulacaloo' u yaabil a cristiano a much'a'anoo' te'i u yila' c'u' a maniji, ti joboo' u yilic tulacal a c'u' a uchiji, usc'ajoo' tu yotoch. Tanoo' u jütz'ic u taan ti tanoo' u beel u men u yajiloo' u yool. ");
INSERT INTO mopNT_vpl VALUES ("LK23_49","072_23_49","LUK","23","49","49","Tulacaloo' u yet'oc a Jesus u yet'ocoo' a nooch'up a tücünacoo' tu pach ti tali Galileaja, wa'anoo' ti naach ti cha'an. U yilajoo' c'u' a maniji. ");
INSERT INTO mopNT_vpl VALUES ("LK23_50","072_23_50","LUK","23","50","50","Pues te'i. Yan jun tuul a winiqui, aj Jose u c'aba'. Arimatea u c'aba' u caal. Que'en tu cuenta Judea a caj abe'e. Ala'aji, jun tuul aj Israel a nooch u wichil u meyaja. Qui'il winic abe'e. Toj u na'at. ");
INSERT INTO mopNT_vpl VALUES ("LK23_51","072_23_51","LUK","23","51","51","Ma' jumbel u tucul ala'i eteloo' u chucaan a nucuch winic yoc'ol a Jesusi. Ma'ax qui' u yool etel c'u' u betajoo' ti'i a Jesusu. Ala'aji, tan u paac'tic u caal ti tücaa' a Dioso. ");
INSERT INTO mopNT_vpl VALUES ("LK23_52","072_23_52","LUK","23","52","52","Bini a winic abe' etel aj Pilatojo. U c'aataj ca' tz'abüc ti'i u büq'uel a Jesusu. ");
INSERT INTO mopNT_vpl VALUES ("LK23_53","072_23_53","LUK","23","53","53","U yemsaj a Jesus tuwich cruz. U bülaj etel a süc noc'o. U coyquintaj ich naj tunich, le'ec a paanbi to ti'i u cuuchil a quimene. Ma'ax mac a mucbuc te'iji. ");
INSERT INTO mopNT_vpl VALUES ("LK23_54","072_23_54","LUK","23","54","54","Le'ec a q'uin ti quimsabi a Jesusu, le'ec u q'uinil u se' utzquinbil a c'u' a c'abeet ti'i u q'uinil a jedel a tan to u caala. ");
INSERT INTO mopNT_vpl VALUES ("LK23_55","072_23_55","LUK","23","55","55","Pues te'i. Le'ecoo' ix ch'up a tücünacoo' tu pach a Jesus ti tali Galilea biq'uin ado'o, binoo' ilic tu pach aj Jose le'ec ca' u mucaj a Jesusu. U yilajoo' abe' a naj tunich tuba bel u ca'a mucbul a quimene. U yilajoo' ilic biqui ti coyquinbi a Jesus ");
INSERT INTO mopNT_vpl VALUES ("LK23_56","072_23_56","LUK","23","56","56","ca' tun usc'ajoo' tu yotoch. U yutzquintajoo' a boc ti'i a quimene. Pues te'i. Uchoo' u jedel ix ch'up abe' tu q'uinil a jedel jabix ilic ti tz'iiba'an ichil a leye. ");
INSERT INTO mopNT_vpl VALUES ("LK24_1","072_24_1","LUK","24","1","1","Pues te'i. Tan u jaabül a yoc'olcab ti Domingo. Binoo' a nooch'up ti a naj tunichi. Tanoo' u bensic a boc u yutzquintajoo'o. ");
INSERT INTO mopNT_vpl VALUES ("LK24_2","072_24_2","LUK","24","2","2","Le'ec ti c'ochoo'o, u yilajoo' ti ac c'oc'lesaja'an a tunich a que'en tu chi' a naj tunich tuba mucbi a Jesusu. ");
INSERT INTO mopNT_vpl VALUES ("LK24_3","072_24_3","LUK","24","3","3","Ocoo' ichil a naj tunichi. Ma' u cüxtajoo' u büq'uel a Noochtzil Jesus te'iji. ");
INSERT INTO mopNT_vpl VALUES ("LK24_4","072_24_4","LUK","24","4","4","Sa'too' u yool u men abe'e. Tu seebal chiclajoo' ca' tuul a winic te'iji. Naach u sac u noc' a ca' tuulu. ");
INSERT INTO mopNT_vpl VALUES ("LK24_5","072_24_5","LUK","24","5","5","Jac'oo' u yool ix ch'upu. U chincuntajoo' u pol. —¿C'u' ca'a tane'ex a yaaltic a cüxte a cuxlaji tu yaamoo' a quimene?— cu t'anoo' ti'i a nooch'upu. ");
INSERT INTO mopNT_vpl VALUES ("LK24_6","072_24_6","LUK","24","6","6","—Ma' wa'ye' que'eni. Ca' cuxlaji. Ca' c'aac te'ex c'u' u yadaj te'ex le'ec ti que'en to cuenta Galilea. ");
INSERT INTO mopNT_vpl VALUES ("LK24_7","072_24_7","LUK","24","7","7","U yadaj te'ex ti le'ec ala'i a yanaji ti cristianojili, yan u c'ubbul tu c'ü'oo' a yanoo' u sip'il ti'i a Dioso. Yan u quimsabül tuwich cruz. Yan ilic u ca' cuxtal tu yox p'eel q'uin. Baalo' u yadaj te'ex,— cu t'anoo' ti'i a nooch'upu. ");
INSERT INTO mopNT_vpl VALUES ("LK24_8","072_24_8","LUK","24","8","8","C'ajchinbil ti'ijoo' u t'an a Jesusu. ");
INSERT INTO mopNT_vpl VALUES ("LK24_9","072_24_9","LUK","24","9","9","Pues te'i. Joc'oo' ichil a naj tunichi. Binoo' tuba much'ca'aloo' a once tuul eteloo' u chucaan aj tz'ocsaj t'ana. Le'ecoo' a nooch'upu, u yadajoo' ti'i tulacal a c'u' a maniji. ");
INSERT INTO mopNT_vpl VALUES ("LK24_10","072_24_10","LUK","24","10","10","Le'ecoo' ix ch'up u yilajoo' abe'e, le'ec ixna' Maria Magdalena etel ixna' Juana, ixna' Maria le'ec u na' aj Jacobo, y ulaac'oo' ix ch'upu. U laj adajoo' c'u' a maniji. ");
INSERT INTO mopNT_vpl VALUES ("LK24_11","072_24_11","LUK","24","11","11","Le'ec boon tuul u yubajoo' u t'an ix ch'upu, chen cuenta tu t'anoo'. Ma' u tz'ocsajoo' u t'ani. ");
INSERT INTO mopNT_vpl VALUES ("LK24_12","072_24_12","LUK","24","12","12","C'u' betiqui, liq'ui aj Pedrojo. Bini ti alca' u yila' a naj tunichi. Le'ec ti uchi u cha'an ichili, jadi' a noc' u tepbeeb u yilaj te'i. Le'ec ti tan u beele, sa'ti u yool etel a c'u' u yilaja. ");
INSERT INTO mopNT_vpl VALUES ("LK24_13","072_24_13","LUK","24","13","13","Pues te'i. Ti'i ilic a q'uin abe'e, tanoo' u beel ich caj Emaus ca' tuul u yaj cambal a Jesusu. Jabix wal once kilometro u naachil tu tzeel a caj Jerusalen. ");
INSERT INTO mopNT_vpl VALUES ("LK24_14","072_24_14","LUK","24","14","14","Le'ec a ca' tuulu, tanoo' u tzicbaltic tulacal a c'u' a mani ti tanoo' u beel. ");
INSERT INTO mopNT_vpl VALUES ("LK24_15","072_24_15","LUK","24","15","15","Naatz'i a Jesus tu tzeeloo' ti tanoo' u tzicbaltic abe'e. U yet'octajoo' ti bej. ");
INSERT INTO mopNT_vpl VALUES ("LK24_16","072_24_16","LUK","24","16","16","Ma' tz'abi ti'ijoo' ca' u c'aj-ooltoo' u wich a Jesusu. ");
INSERT INTO mopNT_vpl VALUES ("LK24_17","072_24_17","LUK","24","17","17","—¿C'u' a tane'ex a tzicbaltiqui? ¿C'u' ca'a yaje'ex a wool?— cu t'an ti'ijoo' a ca' tuulu. ");
INSERT INTO mopNT_vpl VALUES ("LK24_18","072_24_18","LUK","24","18","18","Jun tuulu, aj Cleofas u c'aba'. U nuuctaj a Jesusu. —Chen wal inchech a tan a sut ich caj Jerusalen a ma' a weel c'u' a mani te'iji,— cu t'an ti'i a Jesusu. ");
INSERT INTO mopNT_vpl VALUES ("LK24_19","072_24_19","LUK","24","19","19","—¿C'u' a mani te'iji?— cu t'an ti'ijoo'. —Le'ec a c'u' a mani ti'i a Jesus a tali ich caj Nazaret. Ala'aji, le'ec jun tuul u yadaj u t'an a Dioso. Top quich'pan u yadaj y u betaj tu taan a Dios y tu taan tulacaloo' a cristianojo,— cu t'an aj Cleofas ti'iji. ");
INSERT INTO mopNT_vpl VALUES ("LK24_20","072_24_20","LUK","24","20","20","—Le'ecoo' u noochil aj mansaj t'an to'on ti'i a Dios u yet'ocoo' a nucuch winic ti'i a caja, u c'ubajoo' a Jesus ti'i ca' aalbüc u quimil ca' tun quimsabi tuwich cruz,— cu t'an ti'i a Jesusu. ");
INSERT INTO mopNT_vpl VALUES ("LK24_21","072_24_21","LUK","24","21","21","—Ti tuclaj ino'on ti le'ec a Jesusu, bel cuchi u ca'a u sa'alto'on boono'on aj Israele. Ox p'e q'uin tun uchuc abe'e, ");
INSERT INTO mopNT_vpl VALUES ("LK24_22","072_24_22","LUK","24","22","22","y aleebe u sa'tesajoo' ti wool ix ch'up a que'enoo' tiqui yaama. Le'ec ti tan u jaabül a yoc'olcaba, que'enoo' tuba mucbi a Jesusu,— cu t'an. ");
INSERT INTO mopNT_vpl VALUES ("LK24_23","072_24_23","LUK","24","23","23","—Ma' u cüxtajoo' a Jesusi. Le'ec ti usc'ajoo', u yadajoo' to'on ti ca' u yilajoo' u yaj xa'num a Dios ti ca'an ich jabix nümül. Aalbi ti'ijoo' ti ca' cuxlaji a Jesusu,— cu t'an. ");
INSERT INTO mopNT_vpl VALUES ("LK24_24","072_24_24","LUK","24","24","24","—Yan tiqui yaam a binoo' u yila' a naj tunich tuba mucbi a Jesusu. Ca' u yilajoo' a naj tunichi, quet ilic jabix u yadajoo' a nooch'upu. C'u' betiqui, ma' u yilajoo' a Jesus a binoo' te'iji,— cu t'an ti'i a Jesusu. ");
INSERT INTO mopNT_vpl VALUES ("LK24_25","072_24_25","LUK","24","25","25","—Top chiche'ex a pol. Top chücyajil ti walaque'ex a tz'ocsic tulacal a c'u' u tz'iibtajoo' boon tuul u yadajoo' u t'an a Dios uchi,— cu t'an a Jesus ti'ijoo'o. ");
INSERT INTO mopNT_vpl VALUES ("LK24_26","072_24_26","LUK","24","26","26","—Le'ec a Cristojo, yan u c'ümic a yaj u c'ümaja. Yan ilic u c'ümic u yanil ti ca'an,— cu t'an a Jesusu. ");
INSERT INTO mopNT_vpl VALUES ("LK24_27","072_24_27","LUK","24","27","27","U tzicbaltaj ti'ijoo' biqui'il a tz'iiba'an yoc'ol ilic u bajil ichil u ju'um a Dioso. Caji etel c'u' u tz'iibtaj aj Moises y etel c'u' a tz'iiba'an u men boon tuul u yadajoo' u t'an a Dios uchi. ");
INSERT INTO mopNT_vpl VALUES ("LK24_28","072_24_28","LUK","24","28","28","Pues te'i. Cajoo' ti naatz'ül ti a caj tuba tanoo' u beele. Le'ec a Jesusu, u betaj jabix mas naach tuba u beel ala'aji. ");
INSERT INTO mopNT_vpl VALUES ("LK24_29","072_24_29","LUK","24","29","29","C'u' betic ala'oo'o, ma' u cha'ajoo' ca' mas xi'ic. —Culen tiqui wetel. Watac u yocol a ac'ü'ü. Mani tun a q'uini,— cu t'anoo' ti'i. Culaji eteloo'. ");
INSERT INTO mopNT_vpl VALUES ("LK24_30","072_24_30","LUK","24","30","30","Pues te'i. Le'ec ti que'en pach mesa eteloo'o, u ch'a'aj a waja. U c'ajsaj a Dios yoc'ol. U xet'aj. U tz'aj ti'ijoo'. ");
INSERT INTO mopNT_vpl VALUES ("LK24_31","072_24_31","LUK","24","31","31","Tz'abi ti'ijoo' ca' u c'aj-oolte u wich a Jesusu. Jadi' ca' u c'aj-ooltajoo' u wichi, sütchinbil te'i. ");
INSERT INTO mopNT_vpl VALUES ("LK24_32","072_24_32","LUK","24","32","32","—Le'ec ti tan u tzicbaltic u t'an a Dios tiqui wetel ti beje, ti wu'yaj ti jabix top qui' u yool ti püsüc'ala,— cu t'anoo' tu bajil. ");
INSERT INTO mopNT_vpl VALUES ("LK24_33","072_24_33","LUK","24","33","33","Tu seebal lic'oo' pach mesa. Usc'ajoo' ich caj Jerusalen. Le'ec ti c'ochoo'o, u cüxtajoo' ti much'a'anoo' a once tuul eteloo' u chucaan a tanoo' u tz'ocsaj t'ana. ");
INSERT INTO mopNT_vpl VALUES ("LK24_34","072_24_34","LUK","24","34","34","—Tu jajil ca' cuxlaji a Noochtzili,— cu t'anoo' u yaalbül a ca' tuulu. —U ye'aj u bajil ti'i aj Simon,— cu t'anoo' u yaalbül. ");
INSERT INTO mopNT_vpl VALUES ("LK24_35","072_24_35","LUK","24","35","35","Le'ec a ca' tuulu, u yadaj ti'ijoo' c'u' a mani ti'ijoo' ti beje, biqui ca' u c'aj-ooltajoo' u wich a Jesus ti tan u xet'ic a waja. ");
INSERT INTO mopNT_vpl VALUES ("LK24_36","072_24_36","LUK","24","36","36","Pues te'i. Tanoo' to u yadic abe' a ca' tuulu, ti ca' u ye'aj u bajil a Jesus ti'ijoo'o. U dioostajoo' a much'a'anoo' te'iji. —Jetz'a'anaque'ex a wool,— cu t'an ti'ijoo'. ");
INSERT INTO mopNT_vpl VALUES ("LK24_37","072_24_37","LUK","24","37","37","C'u' betiqui, jac'oo' u yool. Saacajoo'. Tanoo' u tuclic ti chen pixan a tanoo' u yiliqui. ");
INSERT INTO mopNT_vpl VALUES ("LK24_38","072_24_38","LUK","24","38","38","—¿C'u' ca'a jac'a'ane'ex a wool? ¿C'u' ca'a top tane'ex a tucul? ");
INSERT INTO mopNT_vpl VALUES ("LK24_39","072_24_39","LUK","24","39","39","Ile'ex in c'ü' in woc ti le'ec inen ilic a Jesus a tane'ex a wiliqui. Tülene'ex. Cha'antene'ex. Le'ec a pixana, ma' yan u büq'uel u baquel a jabix a tane'ex a wilic a yan tene,— cu t'an a Jesus ti'ijoo'o. ");
INSERT INTO mopNT_vpl VALUES ("LK24_40","072_24_40","LUK","24","40","40","Le'ec ca' u yadaj abe' ti'ijoo'o, u ye'aj u c'ü' u yoc ti'ijoo'. ");
INSERT INTO mopNT_vpl VALUES ("LK24_41","072_24_41","LUK","24","41","41","Qui'oo' u yool, pero sa'too' ilic u yool u men ma'ax to u tz'oquesoo' wa le'ec tu jajil. —¿Yan wa a janal wa'ye'e?— cu t'an ti'ijoo'. ");
INSERT INTO mopNT_vpl VALUES ("LK24_42","072_24_42","LUK","24","42","42","U tz'ajoo' ti'i tz'eec a c'aac'a'an ch'ilama, y a caba. ");
INSERT INTO mopNT_vpl VALUES ("LK24_43","072_24_43","LUK","24","43","43","U müchaj. U jantaj tu taanoo'. ");
INSERT INTO mopNT_vpl VALUES ("LK24_44","072_24_44","LUK","24","44","44","—Le'ec a c'u' a betabi tene, le'ec in wadaj te'ex ti que'enen to ta yaame'exe. “Tulacal a c'u' a tz'iiba'an tin woc'ol ichil a ley u tz'iibtaj aj Moisese, ichil u tz'iib boon tuul u yadaj u t'an a Dios uchi etel a tz'iiba'an tin woc'ol ichil a Salmojo, yan u yuchul ten,” queen te'ex biq'uin ado'o,— cu t'an a Jesus ti'ijoo'o. ");
INSERT INTO mopNT_vpl VALUES ("LK24_45","072_24_45","LUK","24","45","45","Mas pachili, u tz'aj ti'ijoo' ca' u ch'a'oo' u tojil u t'an a Dioso. ");
INSERT INTO mopNT_vpl VALUES ("LK24_46","072_24_46","LUK","24","46","46","—Tz'iiba'an ichil u ju'um a Dios ti yan u c'ümic a yaj a Cristojo, y ti'i u yox p'eel q'uin, yan u ca' cuxtal tu yaamoo' a quimene,— cu t'an a Jesus ti'ijoo'o. ");
INSERT INTO mopNT_vpl VALUES ("LK24_47","072_24_47","LUK","24","47","47","—Inene, Cristojen. Tan in wadic te'ex. Yan u yaalbül ti'ijoo' a cristiano ca' u jeloo' u tucul ti'i ca' sa'tesabücoo' u sip'il. Yan u caal aalbül abe' ich caj Jerusalen ca' tun aalbüc tulacal tubajac yoc'olcab,— cu t'an a Jesus ti'ijoo'o. ");
INSERT INTO mopNT_vpl VALUES ("LK24_48","072_24_48","LUK","24","48","48","—Inche'exe, testigoje'ex yoc'ol abe'e. ");
INSERT INTO mopNT_vpl VALUES ("LK24_49","072_24_49","LUK","24","49","49","U'yeene'ex. Bel in quin tücaa'te te'ex c'u' u yadaj u tz'eec te'ex in Tata, le'ec u Püsüc'al. C'u' betiqui, ca' culaque'ex ich caj asto u yudel u Püsüc'al a Dios ti'i ca' u tz'aa'e'ex u muc' a t'an. Ti ca'an tali a muc' abe'e,— cu t'an a Jesus ti'ijoo'o. ");
INSERT INTO mopNT_vpl VALUES ("LK24_50","072_24_50","LUK","24","50","50","Pues te'i. Le'ec a Jesusu, u bensajoo' u yaj tz'ocsaj t'an ma' naach ti a caj Betaniaja. U nac'saj u c'ü'. U qui'qui't'antajoo'. ");
INSERT INTO mopNT_vpl VALUES ("LK24_51","072_24_51","LUK","24","51","51","Le'ec ti tan to u qui'qui't'anticoo'o, joq'ui tu yaamoo'. Bensabi ti ca'an. ");
INSERT INTO mopNT_vpl VALUES ("LK24_52","072_24_52","LUK","24","52","52","Pues te'i. U ye'ajoo' ti top nooch u yanil a Jesus ca' tun usc'ajoo' ich caj Jerusalen. Top qui'oo' u yool tu jajil ti tanoo' u yusc'al. ");
INSERT INTO mopNT_vpl VALUES ("LK24_53","072_24_53","LUK","24","53","53","Boch que'enoo' ichil u yotoch a Dios u yadicoo' u qui'il a Dioso. Wa'ye' jobi a t'ana.");
INSERT INTO mopNT_vpl VALUES ("JN1_1","073_1_1","JHN","1","1","1","Le'ec ti ma'ax to betabüc a yoc'olcaba, yan jun tuul. T'an u c'aba'. Le'ec a T'an abe'e, te'i que'en etel a Dioso. Le'ec a T'an abe'e, le'ec a Dioso. ");
INSERT INTO mopNT_vpl VALUES ("JN1_2","073_1_2","JHN","1","2","2","Le'ec ilic abe'e, te'i que'en etel Dios le'ec ti ma'ax to betabüc a yoc'olcaba. ");
INSERT INTO mopNT_vpl VALUES ("JN1_3","073_1_3","JHN","1","3","3","Le'ec a Dioso, u tz'aj ti'i ala'i ca' u bete' tulacal a c'u' a yana. Ma' yan c'u' ulaac' a wa ma' u betaja. U laj betaj. ");
INSERT INTO mopNT_vpl VALUES ("JN1_4","073_1_4","JHN","1","4","4","Etel ala'i yan a cuxtala. Le'ec a cuxtal abe'e, walac u ye'ic a jaj ti'ijoo' a cristianojo. Tan u sasilcuntic u tucul a maca. ");
INSERT INTO mopNT_vpl VALUES ("JN1_5","073_1_5","JHN","1","5","5","Le'ec a sasil abe'e, tan u ye'ic a jaj ti'ijoo' a cristianojo. Tan u sasilcuntic u wich a ac'ü'ü. Le'ec a ac'ü' abe'e, ma' tu paatal u tupic u wich a sasili, le'ec a jaj a chiclaji ti'i a maca. ");
INSERT INTO mopNT_vpl VALUES ("JN1_6","073_1_6","JHN","1","6","6","Pues te'i. Yan jun tuul a winiqui, aj Juan u c'aba'. Tücaa'bi u men a Dioso. ");
INSERT INTO mopNT_vpl VALUES ("JN1_7","073_1_7","JHN","1","7","7","Tücaa'bi ti'i u betic u testigojil tu pach a sasil abe'e. Ti baalo'o, tulacaloo' u paataloo' u tz'ocsic u t'an aj Juan ti tan u tzicbaltic mac walac u sasilcuntic u tucul a cristianojo. ");
INSERT INTO mopNT_vpl VALUES ("JN1_8","073_1_8","JHN","1","8","8","Aj Juana, ma' le'ec a mac a walac u sasilcunaji. Ala'aji, jadi' u testigojil. ");
INSERT INTO mopNT_vpl VALUES ("JN1_9","073_1_9","JHN","1","9","9","Pues te'i. Le'ec a jajil sasil abe'e, udi wa'ye' yoc'olcab. Le'ec abe'e, walac u sasilcuntic u tucul tulacal a mac tanil u yadic a jaj ti'ijoo'o. ");
INSERT INTO mopNT_vpl VALUES ("JN1_10","073_1_10","JHN","1","10","10","Wa'ye' que'en ala'i yoc'olcab. Le'ec, u betaj a yoc'olcaba. C'u' betiqui, ma' c'üm-oolbi u menoo' a cristiano yoc'olcaba. ");
INSERT INTO mopNT_vpl VALUES ("JN1_11","073_1_11","JHN","1","11","11","Udi ichil u caal. Ma' c'üm-oolbi u menoo' u yetcaal. ");
INSERT INTO mopNT_vpl VALUES ("JN1_12","073_1_12","JHN","1","12","12","C'u' betiqui, le'ec boon a jujun tuul u c'üm —ooltaj ala'aji, u tz'aj ti'ijoo' ca' ococoo' ti'i u mejen a Dioso. Jadi' yan u tz'ocsabül u t'an mac a walac u sasilcunaj tucul ti'i ca' sa'albücoo'. ");
INSERT INTO mopNT_vpl VALUES ("JN1_13","073_1_13","JHN","1","13","13","Le'ec boon tuul a uchoo' u tz'ocsaja, yanajoo' tucaye'il, pero ma' jabix ti walac u yantal a cristianoji. Ma' yanajoo' tucaye'il u men cristianoji. Yanajoo' tucaye'il u men a Dioso. ");
INSERT INTO mopNT_vpl VALUES ("JN1_14","073_1_14","JHN","1","14","14","Pues te'i. Le'ec a T'an a que'en etel a Dioso, yanaji ti cristianojil. Culaji tiqui yaam. Le'ec ala'aji, jadi' a qui' a walac u betiqui. Jadi' a jaj a walac u yadiqui. Ti wilaj u patalil. Le'ec ilic u patalil abe'e, le'ec a tz'abi ti'i u men u Tata, le'ec a Dioso, u men u Mejen a jun tuul ilic tu bajil ta wichi. ");
INSERT INTO mopNT_vpl VALUES ("JN1_15","073_1_15","JHN","1","15","15","Pues te'i. Aj Juana, u ye'aj a winic abe' ti'ijoo' a cristianojo. —Le'ec ada' a winic in wadaj te'ex le'ec ti ca' in wadaj: “Le'ec mac a watac pachili, mas nooch u wichil u meyaj tin wich u men le'ec ti ma'ax to yanaquene, ac yan ilic a winic abe'e,” queen te'ex,— cu t'an aj Juana. ");
INSERT INTO mopNT_vpl VALUES ("JN1_16","073_1_16","JHN","1","16","16","Pues te'i. Etel u yaabil u qui'il a Cristojo, u tz'aj to'on a qui'il y a mas qui'il. ");
INSERT INTO mopNT_vpl VALUES ("JN1_17","073_1_17","JHN","1","17","17","Le'ec a Dioso, u tz'aj u ley ti'i aj Moises ca' u tz'aa' ti'ijoo' a cristianojo. Chen walac u ye'ic a sip'il a leye. C'u' betiqui, etel a yaj u c'ümaj a Jesucristojo, tan u ch'a'bül u yotzilil a cristianojo. U ye'aj to'on a jaja. ");
INSERT INTO mopNT_vpl VALUES ("JN1_18","073_1_18","JHN","1","18","18","Ma'ax mac u yila' a Dioso. C'u' betiqui, le'ec u Mejen a Tattzil a jun tuul ilic tu bajil a que'en tu tzeele, le'ec u yadaj u pectzil biqui yanil a Dioso. ");
INSERT INTO mopNT_vpl VALUES ("JN1_19","073_1_19","JHN","1","19","19","Pues te'i. Jun p'eel q'uin le'ecoo' a nucuch winic ti'ijoo' aj Israele, u tücaa'tajoo' u yaj mansaj t'an a cristiano ti'i a Dioso, u yet'ocoo' u mamoo' aj Levi u c'aatoo' u chi' aj Juana. Joc'oo' ti quet ich caj Jerusalen. Binoo' etel aj Juan. —¿Mac winiquilech?— cu t'anoo' ti'i aj Juana. Uchi u nuuc aj Juana. ");
INSERT INTO mopNT_vpl VALUES ("JN1_20","073_1_20","JHN","1","20","20","U yadaj ti'ijoo' u tojil. Ma' u mucaj u t'ani. —Inene, ma' u yaj Sa'alilen a cristianoji,— cu t'an ti'ijoo'. ");
INSERT INTO mopNT_vpl VALUES ("JN1_21","073_1_21","JHN","1","21","21","—¿Maquech tun ti baalo'? ¿Aj quimen Eliasech wa?— cu t'anoo' ti'i aj Juana. —Ma' ineni,— cu t'an ti'ijoo'. —¿Inchech wa a winic u yadaj aj quimen Moises uchi ti wataca?— cu t'anoo' ti'i. —Ma',— cu t'an. ");
INSERT INTO mopNT_vpl VALUES ("JN1_22","073_1_22","JHN","1","22","22","Pachili, u c'aatajoo' ti'i: —¿Maquech tun ti baalo'? Adü to'on ti'i ca' ti wadü' a t'an ti'i mac u tücaa'tajo'ono. ¿C'u' a t'an yoc'lal a bajil?— cu t'anoo' ti'i aj Juana. ");
INSERT INTO mopNT_vpl VALUES ("JN1_23","073_1_23","JHN","1","23","23","Uchi u nuuc aj Juana. —Inen jun tuul a tan in t'an ich p'atal lu'um. “Listarte'ex a bajil ca' a c'üm-oolte'ex a Noochtzili,” queen jabix ilic u yadaj aj quimen Elias le'ec u yadaj u t'an a Dios uchi,— cu t'an aj Juan ti'ijoo'o. ");
INSERT INTO mopNT_vpl VALUES ("JN1_24","073_1_24","JHN","1","24","24","Le'ecoo' a tücaa'boo'o, tücaa'boo' u menoo' a fariseo u c'aba'oo' u na'ata. ");
INSERT INTO mopNT_vpl VALUES ("JN1_25","073_1_25","JHN","1","25","25","U c'aatajoo' ti'i: —Incheche, ma' u yaj Sa'alilech a cristianoji, ma'axech aj quimen Elias, ma'axech jun tuul a winic u yadaj aj Moises ti wataca. Ti baalo'o, ¿c'u' ca'a tan a tz'aj ocja'?— cu t'anoo' ti'i. ");
INSERT INTO mopNT_vpl VALUES ("JN1_26","073_1_26","JHN","1","26","26","—Etel ja' tan in tz'aj ocja',— cu t'an aj Juana. —Yan jun tuul ta yaame'ex a ma' a weele'ex u wichi. ");
INSERT INTO mopNT_vpl VALUES ("JN1_27","073_1_27","JHN","1","27","27","Ala'aji, pachil to u ye'ic u bajil. Inene, ma' chucul in yanil ma'ax tin joc'sic u cayte ala'aji,— cu t'an aj Juan ti'ijoo'o. ");
INSERT INTO mopNT_vpl VALUES ("JN1_28","073_1_28","JHN","1","28","28","A t'an ada'a, aalbaani ich caj Betabara a que'en junxeel a noja' Jordan tu tojil a joq'ueeb q'uini. Te'i u tz'aj ti ocja' a cristiano aj Juana. ");
INSERT INTO mopNT_vpl VALUES ("JN1_29","073_1_29","JHN","1","29","29","Pues te'i. Tu samalili, aj Juana, u yilaj a Jesusu. Tan u talel. —Ile'ex,— cu t'an aj Juan ti'ijoo' a cristianojo. —Jedo' a winiqui. Jabix ilic ti walac u quimsabül a carnero ti'i sij-ool ti'i a Dioso, baalo' ilic bel u ca'a betabül ti'i a winic ado' u men ilic a Dioso. Bel u cu bo'te u pach u sip'il a yoc'olcab etel u cuxtala,— cu t'an. ");
INSERT INTO mopNT_vpl VALUES ("JN1_30","073_1_30","JHN","1","30","30","—Le'ec ada' a winic in tzicbaltaj le'ec ti ca' in wadaj te'ex ti watac jun tuul a winic pachili. Mas nooch u wichil u meyaj tin wich, u men le'ec ti ma'ax to yanaquene, ac yan ilic ala'aji,— cu t'an. ");
INSERT INTO mopNT_vpl VALUES ("JN1_31","073_1_31","JHN","1","31","31","—Biq'uin ado'o, ma' in weel wa le'ec ilic ala'i u yaj Sa'alil a cristianojo. C'u' betiqui, taleen in tz'aa' ti ocja' a cristiano ti'i ca' eeltabüc ala'i u menoo' aj Israele,— cu t'an aj Juana. ");
INSERT INTO mopNT_vpl VALUES ("JN1_32","073_1_32","JHN","1","32","32","—In wilaj u yemel tuwich ca'an u Püsüc'al Dios jabix jun tuul palomaja. Culaji yoc'ol a Jesusu,— cu t'an aj Juana. ");
INSERT INTO mopNT_vpl VALUES ("JN1_33","073_1_33","JHN","1","33","33","—Biq'uin ado'o, ma' in weel wa le'ec, ala'aji. Le'ec mac u tücaa'tajen ti tz'aj ocja'a, u yadaj ten: “Bel a ca'a a wila' u yemel u Püsüc'al Dios yoc'ol a jun tuulu. Te'i u cuntal. Le'ec ilic a jun tuul abe'e, bel u cu tz'aa'oo' a cristiano ti ocja', pero etel u Püsüc'al a Dioso,” cu t'an ten,— cu t'an aj Juana. ");
INSERT INTO mopNT_vpl VALUES ("JN1_34","073_1_34","JHN","1","34","34","—Inene, in wilaj u yemel u Püsüc'al a Dios yoc'ol ala'aji. In wadaj ti le'ec a winic ado'o, u Mejen a Dioso,— cu t'an aj Juana. ");
INSERT INTO mopNT_vpl VALUES ("JN1_35","073_1_35","JHN","1","35","35","Pues te'i. Tu ca'bejili, te'i que'en aj Juan tucaye' u yet'oc ca' tuul u yaj cambal. ");
INSERT INTO mopNT_vpl VALUES ("JN1_36","073_1_36","JHN","1","36","36","U yilaj ti tan u ca' manül a Jesusu. —Ile'ex,— cu t'an ti'i a ca' tuulu. —Jedo' a winiqui. Jabix ilic ti walac u quimsabül a carnero ti'i sij-ool ti'i a Dioso, baalo' ilic a bel u ca'a betabül ti'i a winic ado' u men a Dioso,— cu t'an aj Juan ti'ijoo'o. ");
INSERT INTO mopNT_vpl VALUES ("JN1_37","073_1_37","JHN","1","37","37","Le'ec a ca' tuul u yaj cambala, u yubajoo' c'u' u yadaj aj Juana. Binoo' tu pach a Jesusu. ");
INSERT INTO mopNT_vpl VALUES ("JN1_38","073_1_38","JHN","1","38","38","Le'ec a Jesusu, u sutaj u bajil u cha'antoo' a ca' tuul a c'ochoo' to tu pacha. —¿C'u' a tane'ex a cüxtiqui?— cu t'an ti'ijoo'. —¿Tuba cuma'anech Rabi?— cu t'anoo' ti'i. Maestro u nu'cul a Rabiji. ");
INSERT INTO mopNT_vpl VALUES ("JN1_39","073_1_39","JHN","1","39","39","—Co'ne'ex ti wila' tuba cuma'anen,— cu t'an ti'ijoo'. Binoo' tu pach. U yilajoo' tuba cuma'an. U men a las cuatro tun, u mansajoo' u yada' a q'uin te'i. ");
INSERT INTO mopNT_vpl VALUES ("JN1_40","073_1_40","JHN","1","40","40","Pues te'i. Jun tuul tu yaam a ca' tuulu, aj Andres u c'aba'. U yubaj u t'an aj Juana, y bini tu pach a Jesusu. Aj Andrese, u yitz'in aj Simon Pedro. ");
INSERT INTO mopNT_vpl VALUES ("JN1_41","073_1_41","JHN","1","41","41","Tu seebal u cüxtaj u sucu'un le'ec aj Simon Pedrojo. —Ti cüxtaj a Mesiasa, le'ec u yaj Sa'alil a cristianojo,— cu t'an aj Andres ti'i u sucu'un. Ichil a t'an griegojo, Cristo u nu'cul a Mesiasa. ");
INSERT INTO mopNT_vpl VALUES ("JN1_42","073_1_42","JHN","1","42","42","Le'ec aj Andrese, u c'ochesaj u sucu'un etel a Jesusu. Cha'anbi aj Simon u men a Jesusu. —Incheche, aj Simon u mejen aj Jonas,— cu t'an a Jesus ti'iji. —Aleebe, “Cefas,” cu t'anacoo' tech,— cu t'an ti'i aj Simono. U nu'cul abe'e, Pedro wa xan tunich. ");
INSERT INTO mopNT_vpl VALUES ("JN1_43","073_1_43","JHN","1","43","43","Pues te'i. Tu yoxejili, caji ti beel a Jesus tu cuenta Galilea. U cüxtaj aj Felipeje. —Co'on tin pach,— cu t'an ti'i. ");
INSERT INTO mopNT_vpl VALUES ("JN1_44","073_1_44","JHN","1","44","44","Betsaida u c'aba' u caal aj Felipeje. Te'i ilic u caal aj Andres etel aj Pedrojo. ");
INSERT INTO mopNT_vpl VALUES ("JN1_45","073_1_45","JHN","1","45","45","Le'ec aj Felipeje, u cüxtaj aj Natanaele. —Ti cüxtaj a Cristo a tz'iiba'an ichil u ley a Dios u men aj Moisese,— cu t'an ti'i aj Natanaele. —Tz'iiba'an ilic ichil a ju'um u tz'iibtajoo' boon u yadaj u t'an a Dios uchi. Le'ec abe'e, le'ec a Jesus a tali caj Nazaret. Le'ec abe'e, u mejen aj Joseje,— cu t'an aj Felipe ti'i aj Natanaele. ");
INSERT INTO mopNT_vpl VALUES ("JN1_46","073_1_46","JHN","1","46","46","—Ma' yan a c'u' a qui' a jede'ec u joc'ol ichil a caj Nazarete,— cu t'an aj Natanael ti'iji. —Co'ox ti wila',— cu t'an aj Felipe ti'iji. ");
INSERT INTO mopNT_vpl VALUES ("JN1_47","073_1_47","JHN","1","47","47","Le'ec a Jesusu, u yilaj ti tan u c'ochol aj Natanael etel. Caji u tzicbalte aj Natanael. —Ila. Le'ec ada' aj Natanaele, jun tuul aj Israel a top qui' u na'ata,— cu t'an a Jesusu. ");
INSERT INTO mopNT_vpl VALUES ("JN1_48","073_1_48","JHN","1","48","48","—¿Biqui ca' a c'aj-ooltajen?— cu t'an aj Natanael ti'iji. —Le'ec ti que'enech to yalam a chimun ma'ax to u püyeech aj Felipeje, in wilajech te'i,— cu t'an a Jesusu. ");
INSERT INTO mopNT_vpl VALUES ("JN1_49","073_1_49","JHN","1","49","49","—Maestro, incheche, u Mejenech Dios. Inchech u reyoo' boon aj Israele,— cu t'an aj Natanael ti'iji. ");
INSERT INTO mopNT_vpl VALUES ("JN1_50","073_1_50","JHN","1","50","50","—¿Tan wa a tz'eec a wool tin pach chen u men in wadaj tech in wilajech yalam a chimunu?— cu t'an a Jesus ti'iji. —Bel to a ca'a a wila' a mas yaaba, u men tan a tz'ocsiquen,— cu t'an a Jesusu. ");
INSERT INTO mopNT_vpl VALUES ("JN1_51","073_1_51","JHN","1","51","51","—Bel u ca'a ti uchul c'u' a bel in quin wadü' te'exe. Bele'ex a ca'a a wila' ti jeebi a ca'ana. Bele'ex a ca'a a wiloo' u yaj xa'num a Dios ti ca'ana. Tanoo' u yemel y tanoo' u nac'ül tin woc'ol inen a yanajeen ti cristianojili,— cu t'an a Jesus ti'i aj Natanaele. ");
INSERT INTO mopNT_vpl VALUES ("JN2_1","073_2_1","JHN","2","1","1","Pues te'i. Ox p'e q'uin aalbüc a t'an abe' ti uchi u tz'ocolbeel jun tuul mac ich caj Cana tu cuenta Galilea. Le'ec u na' a Jesusu, que'en ti a fiestaja. ");
INSERT INTO mopNT_vpl VALUES ("JN2_2","073_2_2","JHN","2","2","2","Chiitboo' ilic a Jesus u yet'ocoo' u yaj cambal ca' c'ochocoo' etel aj tz'ocolbeel ti uc'ul. ");
INSERT INTO mopNT_vpl VALUES ("JN2_3","073_2_3","JHN","2","3","3","Jobi a vinojo. —Ma' ca' yan a vinojo,— cu t'an u na' a Jesus ti'i a Jesusu. ");
INSERT INTO mopNT_vpl VALUES ("JN2_4","073_2_4","JHN","2","4","4","—Ma' c'u' a cuenta ti'i abe' inchechi, na'. Ma'ax to c'ochoc u yorajil in betic in meyaj,— cu t'an a Jesus ti'iji. ");
INSERT INTO mopNT_vpl VALUES ("JN2_5","073_2_5","JHN","2","5","5","—Bete'ex tulacal a c'u' a bel u cu yadü' te'ex a Jesusu,— cu t'an u na' a Jesus ti'ijoo' aj t'ox janala. ");
INSERT INTO mopNT_vpl VALUES ("JN2_6","073_2_6","JHN","2","6","6","Pues te'i. Yan seis cuul aj pütbil p'uul tina'an te'i. U ba'al a jede'ec u ch'a'ic a jujun cuulu, ciento wa ciento cincuenta botello ti ja'. Le'ec u c'abeetil a p'uulu, ti'i u taacbeeb a ja' ti'i u p'o'bol a c'u' taca. Tz'iiba'an ichiloo' u ley biqui ca' u p'oo' tulacal. ");
INSERT INTO mopNT_vpl VALUES ("JN2_7","073_2_7","JHN","2","7","7","—Tudese'ex a p'uul ti ja,— cu t'an a Jesus ti'ijoo' aj t'ox janala. U tudesajoo' lacchi'. ");
INSERT INTO mopNT_vpl VALUES ("JN2_8","073_2_8","JHN","2","8","8","—Aleebe lupe'ex. Bense'ex ti'i u polil a tz'ocolbeele,— cu t'an a Jesus ti'ijoo'o. U bensajoo'. ");
INSERT INTO mopNT_vpl VALUES ("JN2_9","073_2_9","JHN","2","9","9","Le'ec u polil a tz'ocolbeele, u yaaltaj a ja' a su'ti ti vinojili. Ma' u yeel tuba tali, pero le'ecoo' aj t'ox janala, u yeeloo'. Le'ec u polil a tz'ocolbeele, u püyaj a tan u tz'ocolbeele. ");
INSERT INTO mopNT_vpl VALUES ("JN2_10","073_2_10","JHN","2","10","10","—Tulacal a maca, walacoo' u t'oxic a quich'pan vino payanbeje,— cu t'an ti'i aj tz'ocolbeele. —Pachili, le'ec ti ac yaab a uc'baanüc u menoo' aj sutili, walac u t'oxbol a ma' jiil qui'i. C'u' betiqui, a taactaj a quich'pan vino ti'i ca' a t'oxo' pachil,— cu t'an ti'i aj tz'ocolbeele. ");
INSERT INTO mopNT_vpl VALUES ("JN2_11","073_2_11","JHN","2","11","11","Le'ec a milagro ada'a, le'ec u yaax betaj a Jesusu. Eeltabi ti yan u patalil. Le'ecoo' u yaj cambala, u mas tz'ajoo' u yool tu pach. Betabi a milagro abe' ich caj Cana tu cuenta Galilea. ");
INSERT INTO mopNT_vpl VALUES ("JN2_12","073_2_12","JHN","2","12","12","Pues te'i. Bini a Jesus ich caj Capernaum u yet'ocoo' u na' eteloo' u yitz'in eteloo' u yaj cambal. Ma' yaab q'uin culajoo' te'i. ");
INSERT INTO mopNT_vpl VALUES ("JN2_13","073_2_13","JHN","2","13","13","Pues te'i. Watac u q'uinil u fiestajiloo' aj Israele. Walacoo' u c'ajsic biq'uin ti mani u yaj xa'num a Dios ti ca'an yoc'oloo'o, mentücü bini a Jesus ich caj Jerusalene. ");
INSERT INTO mopNT_vpl VALUES ("JN2_14","073_2_14","JHN","2","14","14","Ichil u yotoch a Dioso, yanoo' aj men negocio. Tanoo' u con wacax, carnero, y paloma. Yanoo' a tina'anoo' ti jüp' taq'uin. Ilboo' u men a Jesusu. ");
INSERT INTO mopNT_vpl VALUES ("JN2_15","073_2_15","JHN","2","15","15","Pues te'i. U betaj a jatz' etel c'aan. U laj tooltajoo' tulacaloo' abe' pach naj tac eteloo' u carnero y u wacax. U wejch'intaj ti lu'um u taq'uin mac a tanoo' u jüp' taq'uini. U piquixc'ü'tajoo' u mesajil. ");
INSERT INTO mopNT_vpl VALUES ("JN2_16","073_2_16","JHN","2","16","16","—Joq'uese'ex a paloma pach naj,— cu t'an ti'ijoo' aj con palomaja. —Ma' a su'tesique'ex u yotoch in Tat ti'i u cuuchoo' aj conolo,— cu t'an ti'ijoo'. ");
INSERT INTO mopNT_vpl VALUES ("JN2_17","073_2_17","JHN","2","17","17","Pues te'i. Le'ecoo' u yaj cambala, c'üja'an ti'ijoo' c'u' a walac u yadic u ju'um a Dios yoc'ol a Cristojo. —U men top c'ocha'an tu wich u yotoch a Dioso, u c'ümaj a yaja,— cu t'an a t'an ichil u ju'um a Dios yoc'ol a Cristojo. ");
INSERT INTO mopNT_vpl VALUES ("JN2_18","073_2_18","JHN","2","18","18","Pues te'i. —¿C'u' ti milagrojil a ca' a bete' ti'i ca' ti tz'oques ti tech a cuenta u toolboloo' boon a toolboo' ti baalo'o?— cu t'anoo' a nucuch winic ti'iji. ");
INSERT INTO mopNT_vpl VALUES ("JN2_19","073_2_19","JHN","2","19","19","—Jobse'ex u yotoch Dios ada'a. Ich ox p'e q'uin in ca' wa'cuntiqui,— cu t'an a Jesus ti'ijoo'o. ");
INSERT INTO mopNT_vpl VALUES ("JN2_20","073_2_20","JHN","2","20","20","—Cuarenta y seis jaab ti paataji u yotoch a Dioso. Incheche, ma' tu paatal a wa'cuntic ich ox p'e q'uin,— cu t'anoo' a nucuch winic ti'iji. ");
INSERT INTO mopNT_vpl VALUES ("JN2_21","073_2_21","JHN","2","21","21","C'u' betiqui, le'ec u yotoch Dios a tan u tzicbaltic a Jesusu, ma' le'ec a c'unaji. Le'ec u yotoch Dios a tan u tzicbaltiqui, le'ec ilic u büq'uel. ");
INSERT INTO mopNT_vpl VALUES ("JN2_22","073_2_22","JHN","2","22","22","Le'ec ti ca' cuxlaji a Jesus tucaye' tu yaamoo' a quimene, le'ecoo' u yaj cambala, c'ajoo' ti'i a t'an abe' yoc'ol u yotoch Dios u yadaj a Jesusu. U men c'ajoo' ti'iji, u mas tz'ajoo' u yool u tz'oques u ju'um Dios y u tz'oques c'u' u yadaj a Jesusu. ");
INSERT INTO mopNT_vpl VALUES ("JN2_23","073_2_23","JHN","2","23","23","Pues te'i. Le'ec a Jesusu, que'en to ich caj Jerusalen ti'i a fiesta le'ec ti tan u c'ajsabül biq'uin ti mani u yaj xa'num a Dios ti ca'an yoc'oloo'o. Le'ec ti ca' u yilajoo' boon a milagro u betaja, u tz'ocsajoo' ti le'ec ala'aji, le'ec ilic u yaj Sa'alil a cristianojo. ");
INSERT INTO mopNT_vpl VALUES ("JN2_24","073_2_24","JHN","2","24","24","C'u' betic a Jesusu, ma' ta'ach u noj-ooltic a ma'ax maca, ");
INSERT INTO mopNT_vpl VALUES ("JN2_25","073_2_25","JHN","2","25","25","u men u laj eel u tucul u püsüc'al a jujun tuul ti cristianojo. U men ac u yeel biqui yanil a cristianojo, ma'ax c'u' aj beel ca' talac jun tuul u yadü' ti'i biqui yanil a maca. ");
INSERT INTO mopNT_vpl VALUES ("JN3_1","073_3_1","JHN","3","1","1","Pues te'i. Yan jun tuul a winiqui, aj Nicodemo u c'aba'. Ala'aji, jun tuul tu yaamoo' a nucuch winiqui. Fariseo u c'aba' u na'at a walac u tz'ocsiqui. ");
INSERT INTO mopNT_vpl VALUES ("JN3_2","073_3_2","JHN","3","2","2","Jun p'eel ac'ü' c'ochi aj Nicodemo etel a Jesusu. —Maestro,— cu t'an ti'i a Jesusu. —Ti weel ti le'ec a Dioso, u tücaa'tajech ti'i ca' a ca'anso'on. Ma'ax mac u paatal u betic a milagro a jabix a tan a betiqui, jadi' a walac u yaantabül u men a Dioso,— cu t'an ti'i. ");
INSERT INTO mopNT_vpl VALUES ("JN3_3","073_3_3","JHN","3","3","3","—Bel in quin wadü' tech u jajil,— cu t'an a Jesus ti uchi u nuuc. —Wa ma' tu ca' yantal tucaye' a maca, ma' tu beel tu cuenta a Dioso,— cu t'an ti'i. ");
INSERT INTO mopNT_vpl VALUES ("JN3_4","073_3_4","JHN","3","4","4","—¿Biqui ca' yanac tucaye' a noochwiniqui?— cu t'an aj Nicodemo ti'iji. —Ma' tu paatal u ca' ocol u ca' sut ichil u na' ti'i ca' cuxlac tucaye'il u ca' sut,— cu t'an ti'i. ");
INSERT INTO mopNT_vpl VALUES ("JN3_5","073_3_5","JHN","3","5","5","—Bel in quin wadü' tech u jajil,— cu t'an a Jesus ti uchi u nuuc tucaye'. —Wa ma' tu yantal a mac etel ja' y etel u Püsüc'al a Dioso, ma' tu yoc'ol ichil u cuenta a Dioso,— cu t'an ti'i. ");
INSERT INTO mopNT_vpl VALUES ("JN3_6","073_3_6","JHN","3","6","6","—Le'ecoo' a cristianojo, jadi' jede'ec u paataloo' u yancuntic a cristianojo. Le'ec u Püsüc'al a Dioso, walac u tz'eec a cuxtal etel Dios a ma' yan q'uin u jobolo,— cu t'an ti'i. ");
INSERT INTO mopNT_vpl VALUES ("JN3_7","073_3_7","JHN","3","7","7","—Ma' u sa'tül a wool etel ca' in wadaj tech ti yan u ca' yantal u ca' sut a maca,— cu t'an ti'i. ");
INSERT INTO mopNT_vpl VALUES ("JN3_8","073_3_8","JHN","3","8","8","—Le'ec a iq'ui, walac u manül tuba u c'ati. Walac a wu'yic u juum. C'u' betiqui, ma' a weel tuba tan u talel ma'ax tuba tan u ca' beel. Baalo' ilic ti ma' ta weeltic biqui ti tan u yancunbul a mac u men u Püsüc'al a Dioso, ti'i ca' p'aatüc ti cuxa'an ti'i a Dioso,— cu t'an a Jesusu. ");
INSERT INTO mopNT_vpl VALUES ("JN3_9","073_3_9","JHN","3","9","9","—Ma' ta'ach in ch'a'ic u tojil a t'an abe'e,— cu t'an aj Nicodemo ti'iji. ");
INSERT INTO mopNT_vpl VALUES ("JN3_10","073_3_10","JHN","3","10","10","—Incheche, jun tuulech ti maestro ti'ijoo' aj Israel,— cu t'an a Jesusu. —Jede'ec cuchi u paatal a ch'a'ic u tojil a t'an ada'a,— cu t'an a Jesus ti'iji. ");
INSERT INTO mopNT_vpl VALUES ("JN3_11","073_3_11","JHN","3","11","11","—Tan in wadic tech u jajil,— cu t'an a Jesus ti'iji. —Tan ti wadic te'ex le'ec a c'u' ti weele. Testigojo'on yoc'ol c'u' ti wilaja. C'u' betic inche'exe, ma' tane'ex a c'ümic ti t'an,— cu t'an a Jesusu. ");
INSERT INTO mopNT_vpl VALUES ("JN3_12","073_3_12","JHN","3","12","12","—Tan in tzicbaltic biqui yanil a yoc'olcab te'exe, y ma' tane'ex a tz'ocsic. Wa ca' in tzicbalte biqui yanil a ca'ana, ma' ilic ta tz'ocsique'ex,— cu t'an a Jesusu. ");
INSERT INTO mopNT_vpl VALUES ("JN3_13","073_3_13","JHN","3","13","13","—Ma'ax mac a naq'ui ti ca'an. Jadi' mac a emi ti ca'an. Abe'e, inen a yanajeen ti cristianojil. Ich ca'an que'en in cuuchil,— cu t'an. ");
INSERT INTO mopNT_vpl VALUES ("JN3_14","073_3_14","JHN","3","14","14","Le'ec aj Moisese, u betaj jun p'eel a jabix can etel fierro. U nac'saj ti ca'nal ichil a p'atal lu'umu. Baalo' ilic yan u tz'abül ti ca'nal a Cristojo, le'ec a yanaji ti cristianojili. ");
INSERT INTO mopNT_vpl VALUES ("JN3_15","073_3_15","JHN","3","15","15","U men tz'abi ti ca'nala, tulacal mac a bel u cu tz'aa' u yool tu pach ala'aji, bel u ca'a tz'abül ti'i a cuxtal a ma' yan q'uin u jobolo. ");
INSERT INTO mopNT_vpl VALUES ("JN3_16","073_3_16","JHN","3","16","16","Pues te'i. A Dioso, top yaj u yuboo' a cristiano yoc'olcaba, mentücü, u c'ubaj u Mejen a jun tuul ilic tu bajili. Ti baalo'o, tulacal a mac a que'en u yool tu pach u Mejen a Dioso, ma' pula'anoo'i. Tz'abi ti'ijoo' a cuxtal a ma' yan q'uin u jobolo. ");
INSERT INTO mopNT_vpl VALUES ("JN3_17","073_3_17","JHN","3","17","17","Le'ec a Dioso, u tücaa'taj u Mejen ichil a yoc'olcab ma' ti'i ca' tz'abüc a cristiano yoc'olcab ichil u sip'ili. U tücaa'taj ca' sa'albüc a cristiano yoc'olcab u men u Mejene. ");
INSERT INTO mopNT_vpl VALUES ("JN3_18","073_3_18","JHN","3","18","18","Le'ec mac a que'en u yool tu pach u Mejen a Dioso, ma' pula'anoo'i. Le'ec mac a ma' que'en u yool tu pach ala'aji, ac ila'an tun ti yan u sip'il u men ma' u tz'aj u yool tu pach a jun tuul ilic tu bajil u Mejen a Dioso. ");
INSERT INTO mopNT_vpl VALUES ("JN3_19","073_3_19","JHN","3","19","19","Bel in quin yee' biqui ti walac u yilbil a sip'ili. Le'ec a jun tuul jabix a sasil a walac u ye'ic biqui'il u tucul a cristianojo, udi yoc'olcab. Le'ecoo' a cristianojo, chen walacoo' u betic a c'asa, mentücü, ma' u c'atoo' a sasil abe'e. Jadi' qui'oo' tu wich a jabix ac'ü'ü, le'ec a na'at a ma' tojo. ");
INSERT INTO mopNT_vpl VALUES ("JN3_20","073_3_20","JHN","3","20","20","Tulacal mac a walac u betic a c'asa, motz ti'i a sasil abe'e. Ma' ta'ach u c'ochol tuba que'en a sasil abe' u men ma' u c'ati ca' eeltabüc u sip'il. ");
INSERT INTO mopNT_vpl VALUES ("JN3_21","073_3_21","JHN","3","21","21","C'u' betiqui, le'ec mac walac u betic a tojo, bel u ca'a ti c'ochol tuba que'en a sasil abe'e. U c'ati ca' chiclac ti qui' ti le'ec a c'u' a walac u betiqui, le'ec a qui' tu wich a Dioso. ");
INSERT INTO mopNT_vpl VALUES ("JN3_22","073_3_22","JHN","3","22","22","Pues te'i. Pachili, joq'ui a Jesus ich caj Jerusalen u yet'ocoo' u yaj cambal. Binoo' ichil aj meen caj tu cuenta Judea. U tz'ajoo' a ocja'a. Ma' culajoo' ti xan te'iji. ");
INSERT INTO mopNT_vpl VALUES ("JN3_23","073_3_23","JHN","3","23","23","Le'ec aj Juana, tan ilic u tz'aj ocja' ichil jun p'eel cuuchil Enon u c'aba' u men yan ti yaab a cuxlinja' te'iji. Ma' naach te'i que'en a caj Salim. Tanoo' u c'ochol a cristianojo. Tanoo' u tz'abül u yocja'. ");
INSERT INTO mopNT_vpl VALUES ("JN3_24","073_3_24","JHN","3","24","24","Ma'ax to tz'abüc aj Juan ti presojil ti tan u yuchul abe'e. ");
INSERT INTO mopNT_vpl VALUES ("JN3_25","073_3_25","JHN","3","25","25","Pues te'i. Cajoo' u yaalte u tojquin u t'an tu bajil u yaj cambaloo' aj Juan eteloo' u chucaan aj Israel yoc'ol c'u' ti ocja'il a mas c'abeete. ");
INSERT INTO mopNT_vpl VALUES ("JN3_26","073_3_26","JHN","3","26","26","Naatz'oo' u yaj cambal aj Juan tu tzeele. —Maestro,— cu t'anoo' ti'i. —Le'ec a Jesus a que'en ta wetel junxeel noja' Jordan biq'uin ado'o, le'ec ilic a tan ti tan a tzicbaltiqui, ala'aji, tan ilic u tz'aj ocja'. Tulacaloo' a cristianojo, tanoo' u beel etel,— cu t'anoo' ti'i. ");
INSERT INTO mopNT_vpl VALUES ("JN3_27","073_3_27","JHN","3","27","27","—Ma'ax c'u' ti qui'il a yan ti'i a mac wa ma' tz'abi ti'i u men a Dioso,— cu t'an aj Juan ti'ijoo'o. ");
INSERT INTO mopNT_vpl VALUES ("JN3_28","073_3_28","JHN","3","28","28","—In wadaj ti ma' inen u yaj Sa'alil a cristianoji. Inche'ex ilic in testigo yoc'ol abe'e. Inene, chen paye' tücaa'been taanil in wadü' u pectzil ala'aji,— cu t'an aj Juana. ");
INSERT INTO mopNT_vpl VALUES ("JN3_29","073_3_29","JHN","3","29","29","—Le'ec a Jesusu, jabix aj tz'ocolbeele. Le'ecoo' a boon a que'en tu pacha, jabix ütantziloo'o. Le'ec mac a tan u yantal u yütana, le'ec aj tz'ocolbeele. Le'ec u yet'oc aj tz'ocolbeel a chen que'en te'i ti sut ti'i u yubic u t'ana, top qui' u yool u men tan u yubic u t'an. Baalo' ti yan, mentücü aleebe, top qui' in wool u men a cristianojo, tanoo' u tz'eec u yool tu pach a Jesusu, bete cuenta tan u yantal u yütan aj tz'ocolbeele,— cu t'an aj Juana. ");
INSERT INTO mopNT_vpl VALUES ("JN3_30","073_3_30","JHN","3","30","30","—Ala'aji, yan u yaabtal u yanil. Inene, yan u yemel in yanil,— cu t'an aj Juana. ");
INSERT INTO mopNT_vpl VALUES ("JN3_31","073_3_31","JHN","3","31","31","Pues te'i. Le'ec a Jesusu, te' tala'an ti ca'an, mentücü, mas nooch u wichil u meyaj yoc'olcab. Le'ec a que'en yoc'olcaba, jadi' a yoc'olcab u yeele. Jadi' u paatal u tzicbaltic a yoc'olcaba, pero le'ec a te' tala'an ti ca'ana, le'ec a mas nooch u wichil u meyaj yoc'olcab. ");
INSERT INTO mopNT_vpl VALUES ("JN3_32","073_3_32","JHN","3","32","32","Ala'aji, walac u yadic c'u' u yilaj c'u' u yubaja. C'u' betiqui, ma'ax mac walac u c'ümic u t'an. ");
INSERT INTO mopNT_vpl VALUES ("JN3_33","073_3_33","JHN","3","33","33","Le'ec mac ca' u c'ümü' u t'an a Cristojo, tanil u tz'ocsic u t'ana, tan u ye'ic ti jaj u t'an a Dioso. ");
INSERT INTO mopNT_vpl VALUES ("JN3_34","073_3_34","JHN","3","34","34","Tan u ye'ic ti baalo' u men le'ec a Jesusu, walac u yadic u t'an a Dioso. Dios u tücaa'taj ala'aji, y u laj tz'aj u Püsüc'al ti'i. ");
INSERT INTO mopNT_vpl VALUES ("JN3_35","073_3_35","JHN","3","35","35","Le'ec a Tattzili, yaj u yubi a Mejentzili. Tulacal a c'u' a yan yoc'olcaba, laj tz'abi ti'i u men a Tattzili. ");
INSERT INTO mopNT_vpl VALUES ("JN3_36","073_3_36","JHN","3","36","36","Le'ec mac a que'en u yool tu pach a Mejentzili, yan ti'i a cuxtal a ma' yan q'uin u jobolo. Le'ec mac a ma' tan u tz'ocsic a Mejentzili, ma' tu c'ümic a cuxtal abe'e. Le'ec u tz'iiquil a Dioso, jumpul p'aatül u ca'a yoc'oloo'. ");
INSERT INTO mopNT_vpl VALUES ("JN4_1","073_4_1","JHN","4","1","1","Pues te'i. Yaab a cristianojo, tan u tz'abüloo' u yocja' ti'i ca' ococoo' ti'i u yaj cambal a Jesusu. Ma' top yaab a tan u tz'eec ti ocja' aj Juani. Le'ecoo' a fariseo u c'aba'oo' u na'ata, u yubajoo' abe'e. U yeeltaj a Jesus ti eeltabi c'u' a tan u yuchulu. ");
INSERT INTO mopNT_vpl VALUES ("JN4_2","073_4_2","JHN","4","2","2","C'u' betic a Jesusu, ma' uchi u tz'aj ocja'i. Jadi' u yaj cambal a uchoo' u tz'aj ocja'a. ");
INSERT INTO mopNT_vpl VALUES ("JN4_3","073_4_3","JHN","4","3","3","Le'ec ca' u yeeltaj c'u' u yubajoo' a fariseojo, a Jesusu, joq'ui tu cuenta Judea. Tan u ca' beel tu cuenta Galilea. ");
INSERT INTO mopNT_vpl VALUES ("JN4_4","073_4_4","JHN","4","4","4","Yan u manül tu cuenta Samaria. ");
INSERT INTO mopNT_vpl VALUES ("JN4_5","073_4_5","JHN","4","5","5","Pues te'i. C'ochi chi' caj Sicar tu cuenta Samaria. Ma' naach te'i que'en a lu'um u tz'aj aj Jacob ti'i u mejene, le'ec aj Joseje. Ala'oo'o, uchben quimenoo'. ");
INSERT INTO mopNT_vpl VALUES ("JN4_6","073_4_6","JHN","4","6","6","Te'i que'en a ch'e'en u paantaj aj Jacobo. Ca'ni a Jesus u men a ximbala. Tinlaji tu tzeel a ch'e'en abe'e. Jabix wal chuunq'uin. ");
INSERT INTO mopNT_vpl VALUES ("JN4_7","073_4_7","JHN","4","7","8","Binoo' u yaj cambal ich caj ti q'uex janal. Pues te'i. C'ochi jun tuul ix ch'up ti ch'aa' ja'. Ala'aji, ix Samariajil. —Tz'a ten tz'etz'eecac a ja'a,— cu t'an a Jesus ti'iji. ");
INSERT INTO mopNT_vpl VALUES ("JN4_9","073_4_9","JHN","4","9","9","Le'ecoo' aj Israele, ma' ta'achoo' u ch'a'ic u bajil ich qui'il eteloo' aj Samariajili, mentücü, baala' ti nuucbi a Jesusu: —Incheche, aj Israelech. Inene, ix Samariajen. ¿C'u' ca'a tan a c'aatic ten a wuc'ul?— cu t'an ix Samariajil ti'iji. ");
INSERT INTO mopNT_vpl VALUES ("JN4_10","073_4_10","JHN","4","10","10","—Wa cuchi a weel u sij-ool a Dioso, wa cuchi a weel mac tan u c'aatic tech u yuc'ulu, a c'aataj cuchi ti'i. U tz'aj cuchi tech a cuxlinja'a,— cu t'an a Jesus ti'i ti uchi u nuuc. ");
INSERT INTO mopNT_vpl VALUES ("JN4_11","073_4_11","JHN","4","11","11","—Noochwinic,— cu t'an ix ch'up ti'iji. —Ma' yan tech u lupbeeb a ja'a. Tam a ch'e'ene. ¿Tuba a cüxtic a cuxlinja' abe'e?— cu t'an ti'i. ");
INSERT INTO mopNT_vpl VALUES ("JN4_12","073_4_12","JHN","4","12","12","—¿Mas yaab wa a tucul tuwich ti uchben mamaa' aj Jacob? Ala'aji, u p'ütaj to'on a ch'e'en ada'a. Wa'ye' uchi u yuc'ul eteloo' u mejen eteloo' u yalac',— cu t'an ix ch'upu. ");
INSERT INTO mopNT_vpl VALUES ("JN4_13","073_4_13","JHN","4","13","13","—Le'ec mac walac u yuq'uic a ja' ada'a, yan u ca' uc'ajtal tucaye'il,— cu t'an a Jesus ti'iji. ");
INSERT INTO mopNT_vpl VALUES ("JN4_14","073_4_14","JHN","4","14","14","—C'u' betiqui, le'ec mac ca' u yuc'u' a ja' a bel in quin tz'aa' ti'iji, ma' tu ca' uc'ajtal jumpul. Le'ec a ja' a bel in quin tz'aa' ti'iji, ichil ilic u püsüc'al ala'aji, bel u ca'a ti su'tul ti jabix a cuxlinja'a. Bel u cu tz'aa' a cuxtal ti'i a ma' yan q'uin u jobolo,— cu t'an a Jesus ti'iji. ");
INSERT INTO mopNT_vpl VALUES ("JN4_15","073_4_15","JHN","4","15","15","—Noochwinic,— cu t'an ix ch'up ti'iji. —Tz'a ten a ja' abe'e. Ti baalo'o, ma' tin ca' uc'ajtal. Ma'ax tin ca' c'ochol wa'ye' ti ch'aa' ja',— cu t'an ti'i. ");
INSERT INTO mopNT_vpl VALUES ("JN4_16","073_4_16","JHN","4","16","16","—Ca' xiquech a püyü' a wicham y ca' talaque'ex wa'ye',— cu t'an a Jesus ti'iji. ");
INSERT INTO mopNT_vpl VALUES ("JN4_17","073_4_17","JHN","4","17","17","—Ma' yan in wicham,— cu t'an ix ch'up ti'iji. —Le'ec ti tan a wadic ti ma' yan a wichama, tan a wadic a jaja,— cu t'an a Jesus ti'iji. ");
INSERT INTO mopNT_vpl VALUES ("JN4_18","073_4_18","JHN","4","18","18","—C'u' betiqui, cinco tuul a winic a wichamtaj, y le'ec a que'en ta wetel aleebe, ma' a wichami. Jaj a wadaj tene,— cu t'an a Jesus ti'iji. ");
INSERT INTO mopNT_vpl VALUES ("JN4_19","073_4_19","JHN","4","19","19","—Noochwinic, tin t'an inene, inchech jun tuul a walac a wadic u t'an a Dioso,— cu t'an ix ch'up ti'iji. ");
INSERT INTO mopNT_vpl VALUES ("JN4_20","073_4_20","JHN","4","20","20","—Le'ecoo' ti uchben mamaa' aj Samariajoo'o, u c'ajsajoo' a Dios tuwich a witz ada'a. Le'eque'ex aj Israele'exe, walaque'ex a wadic jadi' ich caj Jerusalen yan u c'ajsabül a Dioso,— cu t'an ix ch'up ti'i a Jesusu. ");
INSERT INTO mopNT_vpl VALUES ("JN4_21","073_4_21","JHN","4","21","21","—Ix ch'up, tz'oques in t'an. Watac u c'ochol u q'uinil ti bel u ca'a c'ajsabül a Tattzil pero ma' tuwich a witz ada'a, ma'ax ich Jerusalen,— cu t'an ti'i. ");
INSERT INTO mopNT_vpl VALUES ("JN4_22","073_4_22","JHN","4","22","22","—Inche'ex aj Samariajile'exe, walaque'ex a c'ajsic le'ec a c'u' a ma' a weele'exe. Le'ec u sa'albül a mac yoc'olcaba, etel aj Israel caji, mentücü, ino'on aj Israelo'ono, ti weel c'u' a walac ti c'ajsiqui,— cu t'an a Jesusu. ");
INSERT INTO mopNT_vpl VALUES ("JN4_23","073_4_23","JHN","4","23","23","—C'u' betiqui, watac u q'uinil y caji tun le'ec ti tulacaloo' a tanoo' u c'ajsic a Dios tu jajili, beloo' u cu c'ajes ichil u yool u püsüc'al. Beloo' u cu c'ajes etel u jajil. A Tattzili, baalo' u c'ati ca' c'ajsabüc,— cu t'an a Jesus ti'i ix ch'upu. ");
INSERT INTO mopNT_vpl VALUES ("JN4_24","073_4_24","JHN","4","24","24","—Le'ec a Dioso, jabix iq'ui. Le'ec mac tan u c'ajsic a Dioso, yan u c'ajsic ichil u yool u püsüc'al. Yan u c'ajsic etel u jajil,— cu t'an a Jesusu. ");
INSERT INTO mopNT_vpl VALUES ("JN4_25","073_4_25","JHN","4","25","25","—In weel ti watac u yaj Sa'alil a cristianojo, Cristo u c'aba'. Ca' uduc ala'aji, bel u cu yadü' to'on tulacal,— cu t'an ix ch'up ti'iji. ");
INSERT INTO mopNT_vpl VALUES ("JN4_26","073_4_26","JHN","4","26","26","—Inen abe' a tan a wadiquene,— cu t'an a Jesus ti'iji. ");
INSERT INTO mopNT_vpl VALUES ("JN4_27","073_4_27","JHN","4","27","27","Pues te'i. C'ochoo' u yaj cambal tucaye' tuba que'en a Jesusu. Sa'too' u yool ca' u yilajoo' ti tan u tzicbal a Jesus etel jun tuul ix ch'up. C'u' betiqui, ma'ax mac u c'aataj ti'i ix ch'up c'u' u c'ati. Ma'ax u c'aataj ti'i a Jesus c'u' a tan u yadic ti'iji. ");
INSERT INTO mopNT_vpl VALUES ("JN4_28","073_4_28","JHN","4","28","28","Pues te'i. Ix ch'upu, u p'ütaj u p'uul chi' ch'e'en. Usc'aji ich caj u püyoo' u yetcaal. ");
INSERT INTO mopNT_vpl VALUES ("JN4_29","073_4_29","JHN","4","29","29","—Co'ne'ex a wila' a winic u yadaj ten tulacal a c'u' in betaja. ¿Ma' wa le'ec abe' u yaj Sa'alil a cristianojo?— cu t'an ix ch'up ti'ijoo'o. ");
INSERT INTO mopNT_vpl VALUES ("JN4_30","073_4_30","JHN","4","30","30","Joc'oo' ichil a caja. Binoo' tuba que'en a Jesusu. ");
INSERT INTO mopNT_vpl VALUES ("JN4_31","073_4_31","JHN","4","31","31","Pues te'i. —Janen Maestro,— cu t'anoo' u yaj cambal a Jesus ti'i ti bini ix ch'upu. ");
INSERT INTO mopNT_vpl VALUES ("JN4_32","073_4_32","JHN","4","32","32","—Yan in janal ti'i ca' in jante a ma' a weele'exe,— cu t'an a Jesus ti'ijoo'o. ");
INSERT INTO mopNT_vpl VALUES ("JN4_33","073_4_33","JHN","4","33","33","Ca' u yubajoo' abe' u yaj cambaloo'o, u yadajoo' tu bajil: —¿Yan wa mac u talesaj u janal?— cu t'anoo' tu bajil. ");
INSERT INTO mopNT_vpl VALUES ("JN4_34","073_4_34","JHN","4","34","34","—A janal abe'e, le'ec a meyaj a tan in betic ti tan in betic c'u' u c'ati mac u tücaa'tajen, y ca' in jobes u meyaj,— cu t'an a Jesusu. ");
INSERT INTO mopNT_vpl VALUES ("JN4_35","073_4_35","JHN","4","35","35","—Ma' a wadique'ex ti cuatro uj to u beel ca' c'ochoc u q'uinil a jocho. Ile'ex a cristiano ado'o. Jabix col ala'oo' a ac tiquin tun a ac qui' u jochbol u men listojoo' u c'ümü' in t'an,— cu t'an a Jesusu. ");
INSERT INTO mopNT_vpl VALUES ("JN4_36","073_4_36","JHN","4","36","36","—Le'ec a walac u jocho, yan u naal. Tan u much'quinticoo' a cristiano jabix tan u much'quintic u wich püc'aal ti'i ca' u c'ümoo' a cuxtal a ma' yan q'uin u jobolo. Qui'oo' u yool etel a cuxtal abe' a beloo' u cu c'ümü'ü. Qui' ilic u yool mac u yaax adaj u t'an a Dios ti'ijoo' jabix cuchi u püc'aj a semilla te'iji,— cu t'an a Jesusu. ");
INSERT INTO mopNT_vpl VALUES ("JN4_37","073_4_37","JHN","4","37","37","—Jumpaay aj pac'a, y jumpaay aj jocho, jabix ilic a t'an a walacoo' u yadic a cristianojo. “Jun tuul walac u pac'. Ulaac' walac u joch,” cu t'anoo' a cristianojo,— cu t'an a Jesusu. ");
INSERT INTO mopNT_vpl VALUES ("JN4_38","073_4_38","JHN","4","38","38","—In tücaa'taje'ex ca' a bete'ex a meyaj jabix tane'ex a jochic a c'u' a ma' a meyajtaje'exe. Ulaac'oo' u meyajtajoo'. Inche'exe, c'oche'ex a jocho' le'ec a c'u' u meyajtajoo'o,— cu t'an a Jesusu. ");
INSERT INTO mopNT_vpl VALUES ("JN4_39","073_4_39","JHN","4","39","39","Pues te'i. —U yadaj ten tulacal a c'u' in betaja,— cu t'an ix ch'up ti'ijoo' u yetcaal. U men a t'an abe'e, yaaboo' aj Samariajil a taloo' ich caj Sicar, u tz'ajoo' u yool tu pach a Jesusu. ");
INSERT INTO mopNT_vpl VALUES ("JN4_40","073_4_40","JHN","4","40","40","Le'ec ti c'ochoo' etel a Jesusu, u yadajoo' ti'i ca' se' culac eteloo'. Ca' p'e q'uin culaji eteloo'. ");
INSERT INTO mopNT_vpl VALUES ("JN4_41","073_4_41","JHN","4","41","41","Le'ec ca' u yubajoo' u t'an a Jesusu, yaaboo' u chucaan aj Samariajili, u tz'ajoo' u yool tu pach. ");
INSERT INTO mopNT_vpl VALUES ("JN4_42","073_4_42","JHN","4","42","42","—Aleebe ma' jadi' u men c'u' a wadaj to'on tan ti tz'ocsic ala'aji. Aleebe ino'on ilic xan ti wu'yaj u t'an. Ti weel ti le'ec ala'aji, tu jajil u yaj Sa'alil a cristianojo,— cu t'anoo' ti'i a nooch'upu. ");
INSERT INTO mopNT_vpl VALUES ("JN4_43","073_4_43","JHN","4","43","43","Pues te'i. Mani a ca' p'e q'uini. Joq'ui te'i. Tan u beel tu cuenta Galilea. ");
INSERT INTO mopNT_vpl VALUES ("JN4_44","073_4_44","JHN","4","44","44","—Le'ec mac a tan u yadic u t'an a Dioso, ma' ta'ach u tz'ocsabül u yanil tuba ch'iji,— cu t'an a Jesusu. ");
INSERT INTO mopNT_vpl VALUES ("JN4_45","073_4_45","JHN","4","45","45","Le'ec ti c'ochi ichil u cuenta Galileaja, c'ümbi ich qui'il u menoo' u yetcaal aj Galileajoo'o. Le'ec ti que'en to a Jesus u yila' a fiesta ich caj Jerusalene, ilbi tulacal c'u' u betaj u men ala'oo' a taloo' ilic u yila' a fiestaja. ");
INSERT INTO mopNT_vpl VALUES ("JN4_46","073_4_46","JHN","4","46","46","Pues te'i. Ca' c'ochi tucaye' ich caj Cana tu cuenta Galilea. Ichil a caj ada'a, u su'tesaj a ja' ti vinojil ti a q'uin a maniji. Pues te'i. Ich caj Capernaum que'en jun tuul u yaj meyaj a gobiernojo. C'oja'an u mejen. ");
INSERT INTO mopNT_vpl VALUES ("JN4_47","073_4_47","JHN","4","47","47","Le'ec ca' u yubaj ti joq'ui a Jesus tu cuenta Judea y c'ochi tu cuenta Galilea, bini u c'aate ti'i a Jesus ca' xi'ic tz'ücbül u mejen. Watac u quimil u mejen. ");
INSERT INTO mopNT_vpl VALUES ("JN4_48","073_4_48","JHN","4","48","48","Le'ec ca' u yubaj abe' a Jesusu, u yadaj ti'i: —Jadi' yoc'ol a wilique'ex in betic a milagro wa ulaac' a c'u'aca, jadi' ti baalo' a c'ate'ex a tz'aa' a wool tin pach. Ma' qui' ti baalo',— cu t'an ti'i. ");
INSERT INTO mopNT_vpl VALUES ("JN4_49","073_4_49","JHN","4","49","49","—Noochwinic,— cu t'an u yaj meyaj a gobierno ti'iji. —Seebte a bajil. Co'ox. Watac u quimil,— cu t'an ti'i. ");
INSERT INTO mopNT_vpl VALUES ("JN4_50","073_4_50","JHN","4","50","50","—Usq'uen ta wotoch. Tan u qui'tal a mejen,— cu t'an a Jesus ti'iji. Le'ec a winiqui, u tz'ocsaj u t'an a Jesusu. Usc'aji. ");
INSERT INTO mopNT_vpl VALUES ("JN4_51","073_4_51","JHN","4","51","51","C'ümbi ti bej u menoo' u yaj meyaj. —Aleebe tan u qui'tal a mejen,— cu t'anoo' ti'i a winiqui. ");
INSERT INTO mopNT_vpl VALUES ("JN4_52","073_4_52","JHN","4","52","52","—¿C'u' ti horajil caji ti ch'anül?— cu t'an a winic ti uchi u nuuc. —Jo'deeji a la una ti q'uin mani u chücüwil,— cu t'anoo' ti'i. ");
INSERT INTO mopNT_vpl VALUES ("JN4_53","073_4_53","JHN","4","53","53","Le'ec a tattzili, u yeel ti baalo' ilic u yorajil ti tan u tzicbal etel a Jesusu. —Tan u qui'tal a mejen,— cu t'an u yaalbül. Le'ec ilic ala'i etel tulacaloo' u familiaja, u laj tz'ajoo' u yool tu pach a Jesusu. ");
INSERT INTO mopNT_vpl VALUES ("JN4_54","073_4_54","JHN","4","54","54","Le'ec ada' u ca' p'eel a milagro u betaj a Jesus tu cuenta Galilea. U betaj abe'e, le'ec ti tali cuenta Judea, ca' c'ochi tucaye' cuenta Galilea. ");
INSERT INTO mopNT_vpl VALUES ("JN5_1","073_5_1","JHN","5","1","1","Pues te'i. C'ochi u q'uinil u fiestajil aj Israele, mentücü, bini a Jesus ich caj Jerusalen. ");
INSERT INTO mopNT_vpl VALUES ("JN5_2","073_5_2","JHN","5","2","2","Cota'an a caj Jerusalene. Jun p'eel u puertajil a caj abe'e, Carnero u c'aba'. Yan u cuuchil a ichquil ich caj ma' naach ti a puertaja. Ichil a t'an hebreojo, Betesda u c'aba'. Yan cinco cuul a naj chen ti'ijoo' aj bo'oy te'iji. ");
INSERT INTO mopNT_vpl VALUES ("JN5_3","073_5_3","JHN","5","3","3","Ichil a bo'oy abe'e, coya'an u yaabil a c'oja'ana. Yanoo' a ch'oopo, a mooch u yoco, a sotmen u büq'uele. Tanoo' u paac'tic u caal ti peec a ja'a. ");
INSERT INTO mopNT_vpl VALUES ("JN5_4","073_5_4","JHN","5","4","4","Yan q'uin ti walac u yemel tuwich ja' jun tuul u yaj xa'num a Dios ti ca'an u peques u wich a ja' te'iji. Le'ec ca' uchuc u peec u wich a ja'a, jadi' a c'oja'an a yaax walac u yocol ichili, jadi' a walac u ch'anül u c'oja'anil ca'ax c'u'ac ti c'oja'anil a yan ti'iji. ");
INSERT INTO mopNT_vpl VALUES ("JN5_5","073_5_5","JHN","5","5","5","Te'i que'en jun tuul a winiqui. Treinta y ocho jaab c'oja'anac. ");
INSERT INTO mopNT_vpl VALUES ("JN5_6","073_5_6","JHN","5","6","6","Le'ec a Jesusu, u yilaj a winic abe' a coya'an te'iji. U yeel ti top uchi caac u c'oja'anil. —¿A c'ati wa ch'anül?— cu t'an a Jesus ti'iji. ");
INSERT INTO mopNT_vpl VALUES ("JN5_7","073_5_7","JHN","5","7","7","—Noochwinic,— cu t'an a c'oja'an ti'iji. —Le'ec ti walac u peec a ja'a, ma' yan mac ca' u tz'aa'een ichil a ja'a. Le'ec ti tan in yaaltic a beele, ulaac' mac walac u paye' ocol tin wich,— cu t'an a c'oja'an ti'i a Jesusu. ");
INSERT INTO mopNT_vpl VALUES ("JN5_8","073_5_8","JHN","5","8","8","—Liq'uen. Molo a coytaan. Uchuc a ximbal,— cu t'an a Jesus ti'iji. ");
INSERT INTO mopNT_vpl VALUES ("JN5_9","073_5_9","JHN","5","9","9","Tu jomolil ch'ani a winiqui. U molaj u coytaan. Caji ti ximbal. C'u' betiqui, ch'anesabi tu q'uinil a jedele. ");
INSERT INTO mopNT_vpl VALUES ("JN5_10","073_5_10","JHN","5","10","10","—Aleebe u q'uinil jedel. Ma' qui' tu c'axül ti'i a ley ca' a benes a coytaan,— cu t'an u yaalbül u menoo' a nucuch winiqui. ");
INSERT INTO mopNT_vpl VALUES ("JN5_11","073_5_11","JHN","5","11","11","—Le'ec mac u ch'anesajen, u yadaj ten ca' in molo' in coytaan ca' uchuc in ximbal,— cu t'an ti uchi u nuuc. ");
INSERT INTO mopNT_vpl VALUES ("JN5_12","073_5_12","JHN","5","12","12","—¿Mac u yadaj tech ca' a molo' a coytaan ca' uchuc a ximbal?— cu t'anoo' ti'i a winiqui. ");
INSERT INTO mopNT_vpl VALUES ("JN5_13","073_5_13","JHN","5","13","13","C'u' betic a winiqui, ma' u yeel mac u ch'anesaj. Ac joc'a'an a Jesus te'i u men top yaaboo' a cristiano te'iji. ");
INSERT INTO mopNT_vpl VALUES ("JN5_14","073_5_14","JHN","5","14","14","Pachili, a Jesusu, u ca' cüxtaj a winic abe' ichil u yotoch a Dioso. —Ila, ch'aneech. Ma' a ca' beel a cüxte a sip'il ti'i ma' a c'axül ichil a mas yaj tuwich biq'uin ado'o,— cu t'an a Jesus ti'iji. ");
INSERT INTO mopNT_vpl VALUES ("JN5_15","073_5_15","JHN","5","15","15","Bini a winiqui. U yadaj ti'ijoo' a nucuch winic ti ch'anesabi u men a Jesusu. ");
INSERT INTO mopNT_vpl VALUES ("JN5_16","073_5_16","JHN","5","16","16","Le'ecoo' a nucuch winiqui, cajoo' u tucle a c'as yoc'ol a Jesus u men tu q'uinil jedel top walac u tz'ücyaj jabix u betaj ti'i a winic abe'e. U c'atiintajoo' u quimes a Jesusu. ");
INSERT INTO mopNT_vpl VALUES ("JN5_17","073_5_17","JHN","5","17","17","—Le'ec in Tata, tan to u meyaj tac leeb. Tan ilic in meyaj inene,— cu t'an a Jesus ti'ijoo' ti uchi u nuuc. ");
INSERT INTO mopNT_vpl VALUES ("JN5_18","073_5_18","JHN","5","18","18","Le'ecoo' a nucuch winiqui, u mas c'atiintajoo' u quimes ala'aji. Ma' jadi' u betaj c'u' a ma' qui' u betabül tu q'uinil a jedeli. Mas tz'iicoo' u men u yadaj ti Dios u Tat. Le'ec ca' u yadaj abe'e, u tz'aj u bajil ti quet etel a Dioso. ");
INSERT INTO mopNT_vpl VALUES ("JN5_19","073_5_19","JHN","5","19","19","Pues te'i. Le'ec a Jesusu, u nuuctajoo'. —Bel in quin wadü' te'ex u jajil. Le'ec u Mejen a Dioso, ma'ax c'u' a walac u betic tu junali. Jadi' walac u betic c'u' a tan u yilic u betic u Tata. Le'ec biqui ti walac u betic a Tattzili, baalo' ilic walac u betic ala'aji,— cu t'an a Jesusu. ");
INSERT INTO mopNT_vpl VALUES ("JN5_20","073_5_20","JHN","5","20","20","—Le'ec a Tattzili, yaj u yubi u Mejen. Walac u ye'ic ti'i u Mejen tulacal a c'u' a tan u betiqui. Bel u cu yee' ti'i u Mejen a meyaj a mas yaj u betabül ti'i ca' sa'tüque'ex a wool,— cu t'an a Jesusu. ");
INSERT INTO mopNT_vpl VALUES ("JN5_21","073_5_21","JHN","5","21","21","—Jabix ilic ti walac u ca' cuxquintic a quimen a Tattzili, baalo' ilic a Mejentzili. Bel u cu tz'aa' u cuxtal a maca. C'u' betiqui, jadi' jabix u c'ati a Mejentzili, jadi' a bel u cu bete',— cu t'an a Jesusu. ");
INSERT INTO mopNT_vpl VALUES ("JN5_22","073_5_22","JHN","5","22","22","—Le'ec a Tattzili, ma' ta'ach u tz'eec a mac ichil u sip'ili, u men u tz'aj ti'i u Mejen ca' u tz'aa' a sip'ili. ");
INSERT INTO mopNT_vpl VALUES ("JN5_23","073_5_23","JHN","5","23","23","U tz'aj a meyaj abe' ti'i u Mejen ti'i ca' tz'ocsabüc u yanil u Mejen u men tulacaloo' a maca, jabix ilic ti walac u tz'ocsabül u yanil a Tattzili,— cu t'an a Jesusu. —Le'ec mac a ma' tan u tz'ocsic u yanil u Mejene, ma' ilic tan u tz'ocsic u yanil a Tattzili, u men le'ec u tücaa'taj,— cu t'an a Jesusu. ");
INSERT INTO mopNT_vpl VALUES ("JN5_24","073_5_24","JHN","5","24","24","—Bel in quin wadü' te'ex u jajil. Le'ec mac tan u yubic in t'ana, y tan u tz'ocsic mac u tücaa'tajene, yan ti'i a cuxtal a ma' yan q'uin u jobol. Ma' tu tz'abül ich u sip'il u men joq'ui tun ichil u benil a c'asili. Que'en tun tu benil a cuxtal a ma' yan q'uin u jobolo,— cu t'an a Jesusu. ");
INSERT INTO mopNT_vpl VALUES ("JN5_25","073_5_25","JHN","5","25","25","—Bel in quin wadü' te'ex u jajil. Watac u q'uinil y caji tun ti le'ec boon a ma' u yeeloo' a Dioso, beloo' u cu yubi u t'an u Mejen a Dioso. Le'ec boon a beloo' u cu c'üm-oolte u t'ana, bel u ca'a tz'abül ti'ijoo' a cuxtala,— cu t'an a Jesusu. ");
INSERT INTO mopNT_vpl VALUES ("JN5_26","073_5_26","JHN","5","26","26","—Jabix ilic ti yan u patalil u tz'aa' a cuxtal a Tattzili, baalo' ilic u tz'aj ti'i u Mejen ca' u tz'aa' a cuxtal ala'aji,— cu t'an a Jesusu. ");
INSERT INTO mopNT_vpl VALUES ("JN5_27","073_5_27","JHN","5","27","27","—Tz'abi ilic ti'i ca' u tz'aa' a mac ichil u sip'ili, u men le'ec a Mejentzili, yanaji ti cristianojil,— cu t'an a Jesusu. ");
INSERT INTO mopNT_vpl VALUES ("JN5_28","073_5_28","JHN","5","28","28","—Ma' u sa'tüle'ex a wool u men c'u' in wadaja. Watac u q'uinil le'ec ti tulacal boon a quimene, beloo' u cu yubi u t'an a Mejentzili,— cu t'an a Jesusu. ");
INSERT INTO mopNT_vpl VALUES ("JN5_29","073_5_29","JHN","5","29","29","—Beloo' u ca'a ti liq'uil. Le'ec boon u betaj a qui'i, ichil a ca' cuxtal abe'e, beloo' u cu c'ümü' a cuxtal a ma' yan q'uin u jobolo. Le'ec boon u betajoo' a c'asa, ichil a ca' cuxtal abe'e, beloo' u ca'a tz'abül ichil u sip'il,— cu t'an a Jesusu. ");
INSERT INTO mopNT_vpl VALUES ("JN5_30","073_5_30","JHN","5","30","30","—Pues te'i. Inene, ma' patalen in bete' a ma'ax c'u'i tin junala. Jabix ilic ti walac u yaalbül tene, baalo' ilic ti walac in wilic tulacal a ba'ala. Ma' tin wadic wa qui' c'u' a ma' qui'i, wa xan ma' qui' c'u' a qui'i, u men ma' tan in betic jadi' jabix in c'atiji. Tan in betic jabix u c'ati a mac u tücaa'tajene,— cu t'an a Jesusu. ");
INSERT INTO mopNT_vpl VALUES ("JN5_31","073_5_31","JHN","5","31","31","—Wa jadi' inen in testigo tin bajili, ma' chica'an wa jaj in t'an,— cu t'an a Jesusu. ");
INSERT INTO mopNT_vpl VALUES ("JN5_32","073_5_32","JHN","5","32","32","—C'u' betiqui, yan ulaac' jun tuul in testigo. In weel ti jaj u t'an ala'i tin woc'ol,— cu t'an a Jesusu. ");
INSERT INTO mopNT_vpl VALUES ("JN5_33","073_5_33","JHN","5","33","33","—Inche'exe, a tücaa'taje'ex c'aatbül ti'i aj Juan aj tz'aj ocja' maqui ala'aji. U yadaj te'ex a jaj tin woc'olo,— cu t'an a Jesus ti'ijoo' u yetcaala. ");
INSERT INTO mopNT_vpl VALUES ("JN5_34","073_5_34","JHN","5","34","34","—C'u' betiqui, ma' noja'an in wool etel u t'an a cristiano ti'i in testigo u men cristiano ta wichi. C'u' betiqui, tan in wadic ada' yoc'ol in testigo aj Juan ti'i ca' a tz'ocse'ex a jabix u yadaj ti'i ca' sa'albüque'ex ca' xique'ex ti ca'an,— cu t'an a Jesusu. ");
INSERT INTO mopNT_vpl VALUES ("JN5_35","073_5_35","JHN","5","35","35","—Jabix jun cuul a lampara a t'üba'an a tan u tz'eec u saca, baalo' ti que'en aj Juana. U ye'aj a jaja. Inche'exe, qui'e'ex a wool jun p'e rato ichil a jabix u sac abe'e, le'ec a jaj u yadaj aj Juana,— cu t'an a Jesusu. ");
INSERT INTO mopNT_vpl VALUES ("JN5_36","073_5_36","JHN","5","36","36","—Yan in testigo a mas nooch tuwich aj Juana. Le'ec a testigo abe'e, le'ec a milagro a walac in betiqui. Tz'abi ten in bete' abe' u men a Tattzili. U men a milagro abe'e, chica'an ti le'ec a Tattzili, u tücaa'tajen,— cu t'an a Jesusu. ");
INSERT INTO mopNT_vpl VALUES ("JN5_37","073_5_37","JHN","5","37","37","—Le'ec ilic a Tattzili, le'ec in testigo. Inche'exe, ma' a wu'yaje'ex u t'an. Ma'ax a wilaje'ex u wich. ");
INSERT INTO mopNT_vpl VALUES ("JN5_38","073_5_38","JHN","5","38","38","Ma'ax a tz'aje'ex ta wool u t'an Dios a tz'iiba'ana, mentücü, ma' tane'ex a tz'ocsic mac a tücaa'bi u men a Tattzili,— cu t'an a Jesusu. ");
INSERT INTO mopNT_vpl VALUES ("JN5_39","073_5_39","JHN","5","39","39","—Inche'exe, walaque'ex a qui' xoquic u ju'um Dios chen u men walaque'ex a tuclic ti ichil a xoc abe'e, yan te'ex a cuxtal a ma' yan q'uin u jobolo. C'u' betiqui, inen a walac u tzicbaltiquen a ju'um abe'e, ");
INSERT INTO mopNT_vpl VALUES ("JN5_40","073_5_40","JHN","5","40","40","y ma' a c'ate'ex a c'üm-oolteen ti'i ca' a c'üme'ex a cuxtal abe'e,— cu t'an a Jesusu. ");
INSERT INTO mopNT_vpl VALUES ("JN5_41","073_5_41","JHN","5","41","41","—In wadaj a baalo'o, ma' ti'i ca' aalbüc in qui'il u menoo' a cristianoji,— cu t'an a Jesusu. ");
INSERT INTO mopNT_vpl VALUES ("JN5_42","073_5_42","JHN","5","42","42","—C'u' betiqui, in weel ti ma' yaj a wu'ye'ex a Dioso. ");
INSERT INTO mopNT_vpl VALUES ("JN5_43","073_5_43","JHN","5","43","43","Tücaa'been u men in Tat, y ma' tane'ex a c'üm-ooltiquen. C'u' betiqui, ca' talac ulaac' mac u tz'aa' tu bajil ilic tu junal jabix top yaab u yeele, bele'ex a ca'a a c'ümü',— cu t'an a Jesus ti'ijoo' a cristianojo. ");
INSERT INTO mopNT_vpl VALUES ("JN5_44","073_5_44","JHN","5","44","44","—Inche'exe, top qui'e'ex ta xiquin ca' a wu'ye'ex u yaalbül te'ex ti qui'e'ex u menoo' a cristianojo. C'u' betiqui, ma' ta'ache'ex a cüxtic c'u' a ca' a bete'ex ti'i ca' aalbüc te'ex ti qui'e'ex u men a jun tuul ilic tu bajil a Dioso. U men abe'e, ma' tu paatale'ex a tz'ocsiquen,— cu t'an a Jesusu. ");
INSERT INTO mopNT_vpl VALUES ("JN5_45","073_5_45","JHN","5","45","45","—Ma' a tuclique'ex wa bel in quin tzole'ex ti'i a Tattzili. Que'ene'ex a wool tu pach u t'an aj quimen Moises ti'i cu sa'alte'ex cuchi. Le'ec ilic ala'aji, tan u tzolique'ex ti'i a Tattzili,— cu t'an a Jesusu. ");
INSERT INTO mopNT_vpl VALUES ("JN5_46","073_5_46","JHN","5","46","46","—Wa cuchi a tz'ocsaje'ex u t'an aj Moisese, a tz'ocsajene'ex ilic cuchi u men ala'aji, u tzicbaltajen ichil u tz'iib,— cu t'an a Jesusu. ");
INSERT INTO mopNT_vpl VALUES ("JN5_47","073_5_47","JHN","5","47","47","—C'u' betiqui, wa ma' ta'ache'ex a tz'ocsic a t'an a tz'iiba'an u men aj Moisese, ¿biqui ca' paatac a tz'ocsique'ex in t'an inene?— cu t'an a Jesus ti'ijoo' u yetcaal aj Israele. ");
INSERT INTO mopNT_vpl VALUES ("JN6_1","073_6_1","JHN","6","1","1","Pues te'i. Joq'ui a Jesus te'iji. U mansaj a laguna Galileaja. Ca' p'eel u c'aba' a lagunaja, Tiberias y Galilea. ");
INSERT INTO mopNT_vpl VALUES ("JN6_2","073_6_2","JHN","6","2","2","Tücünacoo' u yaabil a cristiano tu pach a Jesusu, u men u yilajoo' boon a milagro u betaj ti tan u tz'üquic a c'oja'ana. ");
INSERT INTO mopNT_vpl VALUES ("JN6_3","073_6_3","JHN","6","3","3","Naq'ui a Jesus tuwich witz ti tintal u yet'ocoo' u yaj cambal. ");
INSERT INTO mopNT_vpl VALUES ("JN6_4","073_6_4","JHN","6","4","4","Nütz'ünac u q'uinil u fiestajoo' aj Israel le'ec ti tan u c'ajsabül biq'uin ti mani u yaj xa'num Dios ti ca'an yoc'oloo'. ");
INSERT INTO mopNT_vpl VALUES ("JN6_5","073_6_5","JHN","6","5","5","Le'ec a Jesusu, u yilajoo' u yaabil a cristianojo. Tanoo' u c'ochol etel. —¿Tuba ti q'uexic a janal ca' ti tz'aa' ti'ijoo' a cristiano ada'oo'o?— cu t'an a Jesus ti'i jun tuul u yaj cambal le'ec aj Felipeje. ");
INSERT INTO mopNT_vpl VALUES ("JN6_6","073_6_6","JHN","6","6","6","Jadi' u c'aataj ti'i u men u c'ati u yubi biqui ti ca' uchuc u nuuc aj Felipeje. Ala'aji, u yeel c'u' a bel u cu bete'e. ");
INSERT INTO mopNT_vpl VALUES ("JN6_7","073_6_7","JHN","6","7","7","—Ca'ax u meyaj a mac manal nueve uj, ma' chucul ti'i u q'uexic a pan ti'i ca' tz'abüc tz'etz'etac ti'i a jujun tuulu,— cu t'an aj Felipe ti'i ti uchi u nuuc. ");
INSERT INTO mopNT_vpl VALUES ("JN6_8","073_6_8","JHN","6","8","8","Pues te'i. Yan jun tuul u yaj cambal a Jesusu, Andres u c'aba'. Ala'aji, u yitz'in aj Simon Pedro. ");
INSERT INTO mopNT_vpl VALUES ("JN6_9","073_6_9","JHN","6","9","9","—Wa'ye' que'en jun tuul a tz'ubu. Yan cinco cuul a pan etele. Betaja'an etel u harinajil cebada. Yan ilic ca' tuul aj meen ch'ilam etele. C'u' betiqui, ¿c'u' aj beel ti'ijoo' u yaabil a cristianojo?— cu t'an aj Andres ti'i a Jesusu. ");
INSERT INTO mopNT_vpl VALUES ("JN6_10","073_6_10","JHN","6","10","10","—Adü ti'ijoo' a cristiano ca' tinlacoo'o,— cu t'an a Jesusu. Su'uquil u wich a lu'um te'iji. Tinlajoo'. Jabix wal cinco mil tuul ti winic a yana. ");
INSERT INTO mopNT_vpl VALUES ("JN6_11","073_6_11","JHN","6","11","11","Le'ec a Jesusu, u laj ch'a'aj a pana. U yadaj a bo'tic ti'i a Dios yoc'ol a pana, ca' tun u tz'aj ti'ijoo' u yaj cambal ca' u t'oxoo' ti'ijoo' a tina'ana. Baalo' ilic u betaj etel aj meen ch'ilama. U tz'aj ti'ijoo' a janal le'ec boon u c'atoo' u jante. ");
INSERT INTO mopNT_vpl VALUES ("JN6_12","073_6_12","JHN","6","12","12","Le'ec ti na'ajnoo', u yadaj ti'ijoo' u yaj cambal: —Molo u yada' a janal ti'i ma' u najiltal,— cu t'an a Jesusu. ");
INSERT INTO mopNT_vpl VALUES ("JN6_13","073_6_13","JHN","6","13","13","Pues te'i. U molajoo'. Doce cuul ti nucuch xac u tudesajoo' etel u yada' a cinco cuul pan a betabi etel u harinajil cebada. ");
INSERT INTO mopNT_vpl VALUES ("JN6_14","073_6_14","JHN","6","14","14","Le'ecoo' a cristianojo, u yilajoo' a milagro u betaj a Jesusu. —Tu jajil ala'aji, le'ec a tan ti paac'tic u yudel wa'ye' yoc'olcab ti'i ca' u yadü' to'on u t'an a Dioso,— cu t'anoo' tu bajil. ");
INSERT INTO mopNT_vpl VALUES ("JN6_15","073_6_15","JHN","6","15","15","Pues te'i. Le'ec a Jesusu, u na'taj ti bel u ca'a chocbol ti reyil u menoo' a cristianojo, mentücü joq'ui tu yaamoo'. Mas naq'ui tuwich witz tu junal. ");
INSERT INTO mopNT_vpl VALUES ("JN6_16","073_6_16","JHN","6","16","16","Pues te'i. Oqui a q'uini. Binoo' chi' ja' u yaj cambal. ");
INSERT INTO mopNT_vpl VALUES ("JN6_17","073_6_17","JHN","6","17","17","Ocoo' ichil a barcojo. Cajoo' ti beel junxeel ja' ich caj Capernaum. Oqui a ac'ü'ü, y ma'ax to c'ochoc a Jesus eteloo'o. ");
INSERT INTO mopNT_vpl VALUES ("JN6_18","073_6_18","JHN","6","18","18","Tz'iicaji a ja' u men chich a iq'ui. ");
INSERT INTO mopNT_vpl VALUES ("JN6_19","073_6_19","JHN","6","19","19","Le'ec ti c'ochoo' cinco wa seis kilometro u naachil chi' a ja'a, u yilajoo' a Jesusu. Tan u ximbal yoc'ol a ja'a. Watac u c'ochol tu tzeel a barcojo. Jac'oo' u yool. ");
INSERT INTO mopNT_vpl VALUES ("JN6_20","073_6_20","JHN","6","20","20","—Inen. Ma' a saactale'ex,— cu t'an a Jesus ti'ijoo'o. ");
INSERT INTO mopNT_vpl VALUES ("JN6_21","073_6_21","JHN","6","21","21","Qui'ajoo' u yool. U cha'ajoo' u yocol ichil a barcojo. Tu seebal c'ochi a barco chi' ja' tuba tanoo' u beele. ");
INSERT INTO mopNT_vpl VALUES ("JN6_22","073_6_22","JHN","6","22","22","Pues te'i. Ti sasaji tu samalili, que'enoo' to a cristiano chi' ja' tuba janoo'o. U yeeloo' le'ec ti c'ochoo' te'iji, jadi' jun cuul ilic a barco a yana. U yeeloo' ilic xan ti ma' oqui a Jesus tu yaamoo' u yaj cambal ichil a barco ti binoo'o. ");
INSERT INTO mopNT_vpl VALUES ("JN6_23","073_6_23","JHN","6","23","23","C'u' betiqui, yaab a barco a tali caj Tiberias, c'ochi to ma' naach tuba janoo' le'ec ti c'ajsabi a Dios yoc'ol a pan u men a Jesusu. ");
INSERT INTO mopNT_vpl VALUES ("JN6_24","073_6_24","JHN","6","24","24","Le'ecoo' a cristianojo, ca' u yilajoo' ti ma' que'en te'i a Jesusu, ma'ax u yaj cambaloo'o, ocoo' ichil boon a barco a c'ochi to. Binoo' u cüxte a Jesus junxeel ja' ich caj Capernaum. ");
INSERT INTO mopNT_vpl VALUES ("JN6_25","073_6_25","JHN","6","25","25","Pues te'i. C'ochoo' junxeel a ja'a. U cüxtajoo' a Jesus te'iji. —Maestro, ¿biq'uini ti udeech wa'ye'?— cu t'anoo' ti'i. ");
INSERT INTO mopNT_vpl VALUES ("JN6_26","073_6_26","JHN","6","26","26","—Bel in quin wadü' te'ex u jajil. Tane'ex a cüxtiquen ma' u men a wilaje'ex a milagroji. Tane'ex a cüxtiquen u men qui' jane'ex etel a pana,— cu t'an a Jesus ti uchi u nuuc. ");
INSERT INTO mopNT_vpl VALUES ("JN6_27","073_6_27","JHN","6","27","27","—Yan a meyaje'ex, pero ma' chenac ti a janal a walac u joboli. Uchuque'ex a meyaj yoc'ol a janal a ma' yan q'uin u jobolo, le'ec a walac u tz'eec a cuxtal a ma' yan q'uin u jobolo. Inene, yanajeen ti cristianojil. Walac in tz'eec a janal abe'e. Le'ec a Dios a Tattzili, u tz'aj ten ca' in tz'aa' a janal abe'e,— cu t'an a Jesusu. ");
INSERT INTO mopNT_vpl VALUES ("JN6_28","073_6_28","JHN","6","28","28","—¿C'u' ti qui'il a yan ti betic le'ec a qui' tu wich a Dioso?— cu t'anoo' ti'i a Jesusu. ");
INSERT INTO mopNT_vpl VALUES ("JN6_29","073_6_29","JHN","6","29","29","—Le'ec a c'u' a qui' tu wich Dios ca' a bete'exe, ca' a tz'ocse'ex a mac a tücaa'bi u men a Dioso,— cu t'an a Jesusu. ");
INSERT INTO mopNT_vpl VALUES ("JN6_30","073_6_30","JHN","6","30","30","—¿C'u' ti milagrojil a bel a ca'a a bete' ti'i ca' ti tz'ocseech? ¿C'u' a bel a ca'a a bete'?— cu t'anoo' ti'i a Jesusu. ");
INSERT INTO mopNT_vpl VALUES ("JN6_31","073_6_31","JHN","6","31","31","—Le'ec ti que'enoo' to ich p'atal lu'um ti uchben mamaa'a, tz'aboo' u janal u men a Dioso. Mana u c'aba' a janal abe'e,— cu t'anoo' a cristianojo. —“U tz'aj ti'ijoo' a janal a tali ti ca'an ca' u jantoo'o,” cu t'an a t'an a tz'iibbi ichil u ju'um a Dioso,— cu t'anoo' a cristianojo. ");
INSERT INTO mopNT_vpl VALUES ("JN6_32","073_6_32","JHN","6","32","32","—Bel in quin wadü' te'ex u jajil. Ma' aj Moises u tz'aj a janal a tali ti ca'ani. Le'ec in Tata, tan u tz'eec a jajil janal a tali ti ca'ana,— cu t'an a Jesusu. ");
INSERT INTO mopNT_vpl VALUES ("JN6_33","073_6_33","JHN","6","33","33","—Le'ec a janal a tan u tz'eec a Dioso, le'ec a mac a emi ti ca'ana. Ala'aji, walac u tz'eec a cuxtal a ma' yan q'uin u jobol ti'i a jujun tuul yoc'olcaba,— cu t'an a Jesusu. ");
INSERT INTO mopNT_vpl VALUES ("JN6_34","073_6_34","JHN","6","34","34","—Noochwinic, tz'a to'on a janal abe' tulacal a q'uini,— cu t'anoo' ti'i a Jesusu. ");
INSERT INTO mopNT_vpl VALUES ("JN6_35","073_6_35","JHN","6","35","35","—Inen a janal abe' a walac u tz'eec a cuxtal a ma' yan q'uin u jobolo. Le'ec mac ca' u c'üm-oolteene, ala'aji, jabix mac a na'ajni jumpul u men ac u cüxtaj a janal le'ec ca' u c'üm-ooltajen. Ac u cüxtaj u yuc'ul ca' u tz'aj u yool tin pach,— cu t'an a Jesusu. ");
INSERT INTO mopNT_vpl VALUES ("JN6_36","073_6_36","JHN","6","36","36","—Ma' ta'ache'ex a tz'ocsiquen ca'ax a wilajene'ex jabix ilic in wadaj te'ex biq'uin ado'o,— cu t'an a Jesusu. ");
INSERT INTO mopNT_vpl VALUES ("JN6_37","073_6_37","JHN","6","37","37","—Tulacal mac a tanoo' u tz'abül ten u men a Tattzili, bel u cu c'üm-oolteen. Le'ec boon a tanoo' u c'üm-ooltiquene, ma' tin pulic,— cu t'an a Jesusu. ");
INSERT INTO mopNT_vpl VALUES ("JN6_38","073_6_38","JHN","6","38","38","—Inene, emeen ti ca'an ma' ti'i ca' in bete' chen a jabix in c'atiji. Emeen ti'i in betical jabix u c'ati mac u tücaa'tajen,— cu t'an a Jesusu. ");
INSERT INTO mopNT_vpl VALUES ("JN6_39","073_6_39","JHN","6","39","39","—Le'ec mac u tücaa'tajene, ma' u c'ati ca' in pulu' ma'ax jun tuul tu yaamoo' tulacal boon u tz'aj tene. U c'ati ca' in cuxquintoo' tu jobeeb a yoc'olcaba,— cu t'an a Jesusu. ");
INSERT INTO mopNT_vpl VALUES ("JN6_40","073_6_40","JHN","6","40","40","—Le'ec tulacal mac a tan u na'tiquene, y tan ilic xan u tz'eec u yool tin pacha, yan ti'i a cuxtal a ma' yan q'uin u jobolo, u men baalo' u c'ati in Tata. Inen bel in quin cuxquintoo' ala'a'oo' ti u jobeeb a yoc'olcaba,— cu t'an a Jesusu. ");
INSERT INTO mopNT_vpl VALUES ("JN6_41","073_6_41","JHN","6","41","41","Pues te'i. Le'ecoo' aj Israele, cajoo' ti p'a'as pach u pol a Jesusu. Ma' qui'oo' tu xiquin ti ca' u yadaj ti le'ec ilic ala'aji, le'ec a janal a emi ti ca'ana. ");
INSERT INTO mopNT_vpl VALUES ("JN6_42","073_6_42","JHN","6","42","42","—¿Ma' wa le'ec a Jesusu, le'ec u mejen aj Joseje? Ti weeloo' u wich u na' u tat. ¿C'u' ca'a tan u yadic ala'i ti emi ti ca'an?— cu t'anoo' tu bajil. ");
INSERT INTO mopNT_vpl VALUES ("JN6_43","073_6_43","JHN","6","43","43","—Ma' a wadique'ex abe' ta bajile'exe,— cu t'an a Jesus ti'ijoo'o. ");
INSERT INTO mopNT_vpl VALUES ("JN6_44","073_6_44","JHN","6","44","44","—Ma'ax mac u paatal u tz'eec u yool tin pach wa ma' püybi u men a Tattzili. Ala'aji, u tücaa'tajen. Inene, bel in quin ca' cuxquinte boon a que'en u yool tin pach ti u jobeeb a yoc'olcaba,— cu t'an a Jesusu. ");
INSERT INTO mopNT_vpl VALUES ("JN6_45","073_6_45","JHN","6","45","45","—“Tulacaloo' ala'oo'o, beloo' u ca'a ca'ansabül u men a Dioso,” cu t'an jun tuul u tz'iibtaj u t'an a Dios uchiji. Tulacal mac u yubaj y u cünaj ti baalo' etel a Tattzili, bel u cu tz'aa' u yool tin pach,— cu t'an a Jesusu. ");
INSERT INTO mopNT_vpl VALUES ("JN6_46","073_6_46","JHN","6","46","46","—Ma' tan in wadic wa yan mac u yilaj a Tattzili. Jadi' mac a tali etel a Dioso, jadi' u yilaj a Tattzili,— cu t'an a Jesusu. ");
INSERT INTO mopNT_vpl VALUES ("JN6_47","073_6_47","JHN","6","47","47","—Bel in quin wadü' te'ex u jajil. Le'ec mac a que'en u yool tin pacha, yan ti'i a cuxtal a ma' yan q'uin u jobolo,— cu t'an a Jesusu. ");
INSERT INTO mopNT_vpl VALUES ("JN6_48","073_6_48","JHN","6","48","48","—Inene, jabixen a janal a walac u tz'eec a cuxtal a ma' yan q'uin u jobolo,— cu t'an a Jesusu. ");
INSERT INTO mopNT_vpl VALUES ("JN6_49","073_6_49","JHN","6","49","49","—Le'ecoo' a mamaa'e'exe, u jantajoo' a janal a mana u c'aba' ich p'atal lu'umu. C'u' betiqui, quimoo' ilic ala'oo',— cu t'an a Jesusu. ");
INSERT INTO mopNT_vpl VALUES ("JN6_50","073_6_50","JHN","6","50","50","—Le'ec a janal a tan in wadiqui, le'ec a emi ti ca'ana. Wa mac ca' u janteje, ma' tu p'aatül ti pula'an,— cu t'an a Jesusu. ");
INSERT INTO mopNT_vpl VALUES ("JN6_51","073_6_51","JHN","6","51","51","—Inen a cuxa'an janal abe' a emi ti ca'ana. Wa mac ca' u jante a janal abe'e, bel u ca'a ti cuxtal jumpul. Le'ec a jabix janal a bel in ca'a in c'ubu' ti'i u cuxtal a mac yoc'olcaba, le'ec in büq'uele,— cu t'an a Jesusu. ");
INSERT INTO mopNT_vpl VALUES ("JN6_52","073_6_52","JHN","6","52","52","Pues te'i. Le'ecoo' aj Israele, cajoo' u p'ujes u bajil etel t'an. —Le'ec a winic abe'e, ¿biqui ca' u tz'aa' to'on u büq'uel ca' ti jante?— cu t'anoo' tu bajil. ");
INSERT INTO mopNT_vpl VALUES ("JN6_53","073_6_53","JHN","6","53","53","—Bel in quin wadü' te'ex u jajil,— cu t'an a Jesus ti'ijoo'o. —Yane'ex a tz'eec a wool tin pach tu jajil bete cuenta tane'ex cuchi a jantic in büq'uel y tane'ex cuchi a wuq'uic in q'uiq'uel a yanajeen ti cristianojili. Wa ma' ta tz'eeque'ex a wool tin pach tu jajil ti baalo'o, ma' yan te'ex a cuxtala,— cu t'an a Jesusu. ");
INSERT INTO mopNT_vpl VALUES ("JN6_54","073_6_54","JHN","6","54","54","—Le'ec mac jabix ca' u jante in büq'uel ca' u yucu' in q'uiq'uele, yan ti'i a cuxtal a ma' yan q'uin u jobol. Inene, bel in quin ca' cuxquinte ti u jobeeb a yoc'olcaba,— cu t'an a Jesusu. ");
INSERT INTO mopNT_vpl VALUES ("JN6_55","073_6_55","JHN","6","55","55","—Le'ec in büq'uel in q'uiq'uele, jabix janal y uc'ul tu jajil,— cu t'an a Jesusu. ");
INSERT INTO mopNT_vpl VALUES ("JN6_56","073_6_56","JHN","6","56","56","—Le'ec mac ca' u c'üm-oolteen jabix cuchi ca' u jante in büq'uel ca' u yuc'u' in q'uiq'uele, que'en tin wetel. Inene, que'enen ilic etel ala'aji,— cu t'an a Jesusu. ");
INSERT INTO mopNT_vpl VALUES ("JN6_57","073_6_57","JHN","6","57","57","—Le'ec a Tattzili, cuxa'an. U tücaa'tajen. Jabix ilic ti cuxa'anen u men u muc' a Tattzili, baalo' ilic mac jabix ca' u janteene, bel u ca'a ti cuxtal u men in muc' inene,— cu t'an a Jesusu. ");
INSERT INTO mopNT_vpl VALUES ("JN6_58","073_6_58","JHN","6","58","58","—Le'ec jabix a janal a tan in wadiqui, le'ec mac a emi ti ca'ana. Ma' le'ec jabix a janal u jantajoo' a uchben mamaa'i. Ala'oo'o, quimoo' ilic. Le'ec mac ca' u jante a janal a tan in wadiqui, bel u ca'a ti cuxtal jumpul,— cu t'an a Jesusu. ");
INSERT INTO mopNT_vpl VALUES ("JN6_59","073_6_59","JHN","6","59","59","Baalo' u t'an a Jesus ti tan u ca'ansicoo' a cristiano ichil a naj tuba much'a'anoo' u yetcaal u c'ajes Dios ich caj Capernaum. ");
INSERT INTO mopNT_vpl VALUES ("JN6_60","073_6_60","JHN","6","60","60","Pues te'i. Yanoo' a tan u cambal etel a Jesusu. Le'ec ca' u yubajoo' c'u' u yadaj ichil a naj tuba walaquil a much'tala, u yadajoo' tu bajil: —Yaj u c'ümbül c'u' a tan u yadiqui. ¿Mac ca' paatac u c'ümü' u t'an?— cu t'anoo' tu bajil. ");
INSERT INTO mopNT_vpl VALUES ("JN6_61","073_6_61","JHN","6","61","61","C'u' betic a Jesusu, u yeel c'u' a tanoo' u yadic tu bajili. —Ma' qui' u tz'ocsabül u t'an,— cu t'anoo' tu bajil. —¿Ma' wa qui' ta xiquine'ex c'u' in wadaj te'exe?— cu t'an ti'ijoo'. ");
INSERT INTO mopNT_vpl VALUES ("JN6_62","073_6_62","JHN","6","62","62","—¿Uxtun wa cuchi ca' a wile'ex in ca' nac'ül tuba taleen a yanajeen ti cristianojili? ¿C'as ilic wa ca' c'axüc te'ex abe'e?— cu t'an a Jesusu. ");
INSERT INTO mopNT_vpl VALUES ("JN6_63","073_6_63","JHN","6","63","63","—Le'ec u Püsüc'al a Dioso, walac u tz'eec a cuxtal a ma' yan q'uin u jobolo. Le'ecoo' a cristianojo, ma' tu paataloo' u tz'eec a cuxtal abe'e. Le'ec a t'an in wadaj te'exe, ti'i Dios. A t'an abe'e, walac u tz'eec a cuxtala. ");
INSERT INTO mopNT_vpl VALUES ("JN6_64","073_6_64","JHN","6","64","64","C'u' betiqui, yanoo' ta yaame'ex a ma' ta'achoo' u tz'ocsaja,— cu t'an a Jesusu. Ac tu cajeebal, a Jesusu, u yeel mac a ma' que'enoo' u yool tu pacha. A Jesusu, bel u ca'a c'ubbul ti'ijoo' a tz'iic ti'iji. U yeel mac bel u cu bete' abe'e. ");
INSERT INTO mopNT_vpl VALUES ("JN6_65","073_6_65","JHN","6","65","65","—“Ma'ax mac u paatal u tz'eec u yool tin pach wa ma' tz'abi ti'i u men a Tattzili,” queen te'ex u men ta yaame'ex que'enoo' a ma' ta'achoo' u tz'ocsiquen,— cu t'an a Jesusu. ");
INSERT INTO mopNT_vpl VALUES ("JN6_66","073_6_66","JHN","6","66","66","Le'ec ca' u yubajoo' u yadic a Jesus ti baalo'o, yaaboo' a tücünacoo' tu pacha, u p'ütajoo'. ");
INSERT INTO mopNT_vpl VALUES ("JN6_67","073_6_67","JHN","6","67","67","—¿Bele'ex wa a ca'a a p'üteen jabix ala'oo'o?— cu t'an a Jesus ti'ijoo' a doce tuulu. ");
INSERT INTO mopNT_vpl VALUES ("JN6_68","073_6_68","JHN","6","68","68","—Noochil, ¿mac etel ti beel? Ta wetel yan a t'an ti'i a cuxtal a ma' yan q'uin u jobolo,— cu t'an aj Simon Pedro ti'i ti uchi u nuuc. ");
INSERT INTO mopNT_vpl VALUES ("JN6_69","073_6_69","JHN","6","69","69","—Ino'ono, walac ti tz'ocsic a t'an. Ti weel ti le'ec incheche, u yaj Sa'alilech a cristianojo. Incheche, u Mejenech a Dios a cuxa'ana,— cu t'an ti'i a Jesusu. ");
INSERT INTO mopNT_vpl VALUES ("JN6_70","073_6_70","JHN","6","70","70","—Inen in yeetaje'ex a doce tuule'ex ta bajili. Jun tuul a que'en ta yaame'exe, yan a c'ac'asba'al tu yoolo,— cu t'an a Jesusu. ");
INSERT INTO mopNT_vpl VALUES ("JN6_71","073_6_71","JHN","6","71","71","Tan u tzicbaltic aj Judas le'ec u mejen aj Simon Iscarioteje. Tac etel aj Judas, doce tuuloo' tu bajil. Ala'aji, bel u ca'a u c'ubu' a Jesus ti'ijoo' a tz'iic ti'iji. ");
INSERT INTO mopNT_vpl VALUES ("JN7_1","073_7_1","JHN","7","1","1","Pues te'i. Caji ti manül a Jesus tulacal tubajac tu cuenta Galilea. Ma' u c'atiintaj manül tu cuenta Judea u menoo' u yetcaal aj Israel a noochoo' u wichil u meyaj a que'enoo' te'iji. U c'atoo' u quimes. ");
INSERT INTO mopNT_vpl VALUES ("JN7_2","073_7_2","JHN","7","2","2","Watac u q'uinil u fiestajoo' aj Israel le'ec ti walacoo' u men champa. ");
INSERT INTO mopNT_vpl VALUES ("JN7_3","073_7_3","JHN","7","3","3","—Joq'uen wa'ye'. Ca' xiquech a wila' a fiesta tu cuenta Judea,— cu t'anoo' u yitz'in ti'i a Jesusu. —Ti baalo'o, le'ecoo' a walac u tz'ocsiquech te'iji, beloo' u cu yila' c'u' a walac a betiqui,— cu t'anoo' ti'i. ");
INSERT INTO mopNT_vpl VALUES ("JN7_4","073_7_4","JHN","7","4","4","—Le'ec mac u c'ati ti eeltzil u meyaja, ma' tu betic ich mucul. Walac a betic a milagrojo. Ca' xiquech tu taanoo' a cristiano yoc'olcab,— cu t'anoo' u yitz'in ti'i. ");
INSERT INTO mopNT_vpl VALUES ("JN7_5","073_7_5","JHN","7","5","5","U yadajoo' abe' u yitz'ini, u men ma'ax ala'oo', ma' ilic que'enoo' u yool tu pach a Jesusu. ");
INSERT INTO mopNT_vpl VALUES ("JN7_6","073_7_6","JHN","7","6","6","—Ma'ax to c'ochoc u yorajil in beel te'i. Inche'exe, u paatale'ex a beel ti a fiesta biq'uin ti a c'ate'ex a beele,— cu t'an a Jesusu. ");
INSERT INTO mopNT_vpl VALUES ("JN7_7","073_7_7","JHN","7","7","7","—Ma' tu paatal a motzinbile'ex u menoo' a cristiano yoc'olcaba. Tanoo' u motzintiquen u men walac in wadic ti c'as a tanoo' u betiqui,— cu t'an a Jesus ti'ijoo' u yitz'ini. ");
INSERT INTO mopNT_vpl VALUES ("JN7_8","073_7_8","JHN","7","8","8","—Inche'exe, ca' xique'ex ti a fiestaja. Inene, ma' se' bel in ca'a u men ma'ax to c'ochoc u yorajil in beel,— cu t'an a Jesus ti'ijoo' u yitz'in. ");
INSERT INTO mopNT_vpl VALUES ("JN7_9","073_7_9","JHN","7","9","9","Le'ec ca' u yadaj a t'an abe'e, p'aati te'i tu cuenta Galilea a Jesusu. ");
INSERT INTO mopNT_vpl VALUES ("JN7_10","073_7_10","JHN","7","10","10","Pues te'i. Ac binoo' tun u yitz'in ti a fiesta ti bini ilic te'i ala'aji. Ma' chica'an ti bini. Bini ti mucul. ");
INSERT INTO mopNT_vpl VALUES ("JN7_11","073_7_11","JHN","7","11","11","Le'ecoo' a nucuch winiqui, tanoo' u yaaltic u cüxte a Jesus ichil a fiestaja. —¿Tuba que'en ala'aji?— cu t'anoo'. ");
INSERT INTO mopNT_vpl VALUES ("JN7_12","073_7_12","JHN","7","12","12","Le'ecoo' a cristianojo, yaab a tanoo' u jisilt'an yoc'ol a Jesusu. —Qui'il winic a Jesusu,— cu t'anoo' a yaab ichil a jisilt'ana. —Ma' le'equi. Chen tan u tusic a cristianojo,— cu t'anoo' ulaac' ich jisilt'an. ");
INSERT INTO mopNT_vpl VALUES ("JN7_13","073_7_13","JHN","7","13","13","C'u' betiqui, saacoo' ti'i a nucuch winiqui, mentücü, ma'ax mac a uchi u t'an ti chica'an yoc'ol a Jesusu. ");
INSERT INTO mopNT_vpl VALUES ("JN7_14","073_7_14","JHN","7","14","14","Pues te'i. Mani tun chumuc a boon u q'uinil a fiestaja. Le'ec a Jesusu, oqui ichil u yotoch a Dioso. Caji ti ca'ansaj te'i. ");
INSERT INTO mopNT_vpl VALUES ("JN7_15","073_7_15","JHN","7","15","15","Sa'too' u yool a nucuch winic te'iji. —¿Biqui ti top yaab u yeel a winic ada'a? Ma' culaji ichil a escuelaja,— cu t'anoo' tu bajil. ");
INSERT INTO mopNT_vpl VALUES ("JN7_16","073_7_16","JHN","7","16","16","—Le'ec c'u' a tan in wadiqui, ma' tin junal in cuxquintaji. Te' tali etel mac u tücaa'tajen,— cu t'an a Jesus ti uchi u nuuc. ");
INSERT INTO mopNT_vpl VALUES ("JN7_17","073_7_17","JHN","7","17","17","—Le'ec mac a que'en u yool u bete' a c'u' u c'ati a Dioso, bel u cu na'te wa inen in cuxquintaj a t'an ada'a, wa tali etel Dios,— cu t'an a Jesusu. ");
INSERT INTO mopNT_vpl VALUES ("JN7_18","073_7_18","JHN","7","18","18","—Le'ec mac a walac u cuxquintic u t'an tu junal, jadi' tan u c'atiintic u yaalbül u qui'il tu junal. C'u' betiqui, le'ec mac u c'ati ca' aalbüc u qui'il mac u tücaa'taja, ala'aji, toj u na'at. Ma' tan u tusi,— cu t'an a Jesusu. ");
INSERT INTO mopNT_vpl VALUES ("JN7_19","073_7_19","JHN","7","19","19","—Le'ec aj quimen Moisese, u p'ütaj te'ex a ley u tz'aj a Dioso. C'u' betiqui, ma' ta'ache'ex a tz'ocsic a ley abe'e. ¿C'u' ca'a tane'ex a c'atiintic a quimseen?— cu t'an a Jesus ti'ijoo'o. ");
INSERT INTO mopNT_vpl VALUES ("JN7_20","073_7_20","JHN","7","20","20","—Incheche, yan a c'ac'asba'al ta wool. Ma'ax mac a tanoo' u c'atiintic u quimseech,— cu t'anoo' a cristiano ti uchi u nuuc. ");
INSERT INTO mopNT_vpl VALUES ("JN7_21","073_7_21","JHN","7","21","21","—In betaj a milagro tu q'uinil jedele, mentücü, sa'te'ex a wool,— cu t'an a Jesusu. ");
INSERT INTO mopNT_vpl VALUES ("JN7_22","073_7_22","JHN","7","22","22","—Le'ec aj quimen Moisese, u p'ütaj te'ex ca' a xote'ex a wot'el ti'i ca' p'aatüc u p'is. Circuncision u c'aba'. Ma' aj Moises u cajsaj abe'e, pero yanaji eteloo' u uchben mamaa'. Walaque'ex a betic a circuncision ti'ijoo' a xidal tz'ub ca'ax ti u q'uinil jedel,— cu t'an a Jesusu. ");
INSERT INTO mopNT_vpl VALUES ("JN7_23","073_7_23","JHN","7","23","23","—Yane'ex a tz'eec a circuncision ti'ijoo' a xidal tz'ub ca'ax tu q'uinil jedel ti'i ma' u c'axül ti c'as ti'i a ley u tz'iibtaj aj Moisese. ¿C'u' ca'a tz'iique'ex ten u men tu q'uinil jedel in tz'ücaj a winiqui?— cu t'an a Jesusu. ");
INSERT INTO mopNT_vpl VALUES ("JN7_24","073_7_24","JHN","7","24","24","—Ma' se' tz'eeque'ex u sip'il a mac ti ma'ax to a wile'ex wa toj u betaj. Yane'ex a wilic u sip'il ti toj,— cu t'an a Jesusu. ");
INSERT INTO mopNT_vpl VALUES ("JN7_25","073_7_25","JHN","7","25","25","Pues te'i. Yanoo' ilic aj cajil Jerusalen tu yaamoo' a tanoo' u yubic u t'an a Jesusu. U chucaana, tala'anoo' ca'ax tubajac. —¿Ma' wa le'ec a winic ada' a tanoo' u yaaltic u cüxte ti'i ca' u quimesoo'?— cu t'anoo' aj cajil tu bajiloo'o. ");
INSERT INTO mopNT_vpl VALUES ("JN7_26","073_7_26","JHN","7","26","26","—Tan u t'an a Jesus wa'ye' tu taanoo' a cristianojo. Le'ecoo' a tz'iic ti'iji, ma'ax c'u' a tanoo' u yadic ti'iji. Uchac le'ecoo' a nucuch winiqui, u yeeltajoo' ti jaj ti le'ec u yaj Sa'alil a cristianojo,— cu t'anoo' aj cajil Jerusalen tu bajiloo'o. ");
INSERT INTO mopNT_vpl VALUES ("JN7_27","073_7_27","JHN","7","27","27","—C'u' betiqui, ti weel tuba que'en u caal a winic ada'a. Le'ec ca' chiclac u yaj Sa'alil a cristianojo, ma'ax mac ca' u yeelte tuba que'en u caal,— cu t'anoo' tu bajil. ");
INSERT INTO mopNT_vpl VALUES ("JN7_28","073_7_28","JHN","7","28","28","Tan to u t'an a Jesus ichil u yotoch a Dioso. Le'ec ca' u yubajoo' u t'an a cristiano a Jesusu, u yadaj ti chich: —Inche'exe, a weele'ex in wich. A weele'ex in caal. C'u' betiqui, tücaa'been. Le'ec mac u tücaa'tajene, cuxa'an tu jajil. Ma' a weele'ex ala'aji,— cu t'an a Jesusu. ");
INSERT INTO mopNT_vpl VALUES ("JN7_29","073_7_29","JHN","7","29","29","—Inen in weel ala'aji, u men te'i taleen etel. Le'ec u tücaa'tajen,— cu t'an a Jesusu. ");
INSERT INTO mopNT_vpl VALUES ("JN7_30","073_7_30","JHN","7","30","30","Pues te'i. Ca' u yubajoo' abe'e, u yaaltajoo' u müchü' a Jesusu. C'u' betiqui, ma'ax mac u müchaj u men ma'ax to c'ochoc u yorajil u müchbül. ");
INSERT INTO mopNT_vpl VALUES ("JN7_31","073_7_31","JHN","7","31","31","Yaaboo' ilic a cristiano u tz'ajoo' u yool tu pacha. Ala'oo'o, cajoo' ti t'an eteloo' a ma' que'enoo' u yool tu pacha. —Tane'ex a tuclic ti ma' le'ec a Jesus u yaj Sa'alil a cristianojo. Le'ec ca' chiclac mac a tane'ex a tuclic ti le'ec u yaj Sa'alil a cristianojo, ¿biqui'il u wich a milagro a tane'ex a tuclic u betic a ma' u bete' a Jesusu?— cu t'anoo' ti'ijoo' a ma' tanoo' u tz'ocsaja. ");
INSERT INTO mopNT_vpl VALUES ("JN7_32","073_7_32","JHN","7","32","32","Pues te'i. Le'ecoo' a fariseo u c'aba'oo' u na'ata, u yubajoo' ti tan u yaalbül u menoo' a cristiano ti le'ec a Jesus u yaj Sa'alil a cristianojo. Le'ecoo' a fariseo u yet'ocoo' u noochiloo' u yaj mansaj t'an a cristiano ti'i a Dioso, le'ec ca' u yubajoo' abe'e, u tücaa'tajoo' a winic a jabix soldadojoo' a walacoo' u cününtic u yotoch a Dios ca' u müchoo' a Jesusu. ");
INSERT INTO mopNT_vpl VALUES ("JN7_33","073_7_33","JHN","7","33","33","—Inene, bel to in ca'a ti cuntal tz'etz'eecac wa'ye' ca' tun usc'aquen etel mac u tücaa'tajen,— cu t'an a Jesusu. ");
INSERT INTO mopNT_vpl VALUES ("JN7_34","073_7_34","JHN","7","34","34","—Bele'ex a ca'a a yaalte a cüxteen. Ma' ta cüxtiquene'ex. Ma' tu paatale'ex a c'ochol tuba in beel,— cu t'an a Jesus ti'ijoo'o. ");
INSERT INTO mopNT_vpl VALUES ("JN7_35","073_7_35","JHN","7","35","35","—Le'ec a winic ada'a, ¿tuba tan u tuclic u beel tuba ma' tu paatal ti cüxtic? ¿Tan wa u tuclic u beel eteloo' ti wetcaal aj Israel a weca'anoo' tu yaamoo' aj Griegojo? ¿Tan wa u tuclic u ca'ansicoo' aj Griegojo, — cu t'anoo' a nucuch winic tu bajiloo'. ");
INSERT INTO mopNT_vpl VALUES ("JN7_36","073_7_36","JHN","7","36","36","—“Bele'ex a ca'a a yaalte a cüxteen. Ma' ta cüxtiquene'ex. Ma' tu paatale'ex a c'ochol tuba in beel,” cu t'an to'on. ¿Ma' eela'an c'u' u nu'cul u t'an?— cu t'anoo' tu bajil. ");
INSERT INTO mopNT_vpl VALUES ("JN7_37","073_7_37","JHN","7","37","37","Pues te'i. C'ochi u q'uinil u yada' a fiestaja. Le'ec a q'uin abe' a mas noocho. Wa'laji a Jesus ti t'an ti chich ti'ijoo' a cristianojo. —Wa yan mac a jabix uc'aj ti'i a Dioso, ca' talac tin wetel ti uc'ul,— cu t'an a Jesus ti chich. ");
INSERT INTO mopNT_vpl VALUES ("JN7_38","073_7_38","JHN","7","38","38","—Baala' ti tz'iiba'an ichil u ju'um a Dios yoc'ol mac a que'en u yool tin pacha. “Tu püsüc'al a cristiano abe'e, te'i ti te'i bel u ca'a ti joc'ol a jabix cuxlinja' a tan u yoco. Le'ec a cuxlinja' abe'e, le'ec a cuxtal a ma' yan q'uin u jobol,” cu t'an u t'an a Dioso,— cu t'an a Jesusu. ");
INSERT INTO mopNT_vpl VALUES ("JN7_39","073_7_39","JHN","7","39","39","Le'ec a Jesusu, tanil u tzicbaltic a cuxlinja'a, tan u tzicbaltic u c'ümbül u Püsüc'al a Dios u men boon a que'enoo' u yool tu pach ala'aji. C'u' betiqui, ma'ax to tz'abüc u Püsüc'al a Dios ti'ijoo'o, u men ma'ax to nac'üc ti ca'an a Jesusu. ");
INSERT INTO mopNT_vpl VALUES ("JN7_40","073_7_40","JHN","7","40","40","Pues te'i. Le'ec ca' u yubajoo' a t'an abe'e, yaab u yadajoo': —Tu jajil le'ec a winic ada'a, le'ec walac u yadic u t'an a Dios a tan ti paac'tiqui,— cu t'anoo'. ");
INSERT INTO mopNT_vpl VALUES ("JN7_41","073_7_41","JHN","7","41","41","—Le'ec ada' u yaj Sa'alil a cristianojo,— cu t'anoo' ulaac'. C'u' betiqui, yanoo' ulaac' tucaye'il u yadajoo': —¿Biqui ca' yanac tu cuenta Galilea u yaj Sa'alil a cristianojo?— cu t'anoo'. ");
INSERT INTO mopNT_vpl VALUES ("JN7_42","073_7_42","JHN","7","42","42","—Tz'iiba'an ichil u ju'um Dios ti le'ec u yaj Sa'alil a cristianojo, jun tuul u mam aj quimen rey David. Bel u ca'a ti yantal ich caj Belen le'ec ilic u caal aj Davidi,— cu t'anoo'. ");
INSERT INTO mopNT_vpl VALUES ("JN7_43","073_7_43","JHN","7","43","43","Ti Baalo'o, ma' jumbeloo' u tucul a cristiano yoc'ol wa u yaj Sa'alil a cristiano a Jesus wa ma'a. ");
INSERT INTO mopNT_vpl VALUES ("JN7_44","073_7_44","JHN","7","44","44","Yan u c'atiintajoo' cuchi ca' müchbüc a Jesusu. C'u' betiqui, ma'ax mac u müchaj. ");
INSERT INTO mopNT_vpl VALUES ("JN7_45","073_7_45","JHN","7","45","45","Pues te'i. Le'ecoo' a winic a jabix soldadojoo' a walacoo' u cününtic u yotoch a Dioso, usc'ajoo' tu pach tuba que'enoo' u noochiloo' u yaj mansaj t'an a cristiano ti'i a Dioso. Te'i ilic que'enoo' a fariseo u c'aba'oo' u na'ata. —¿C'u' ca'a ma' a talesaje'ex a Jesusu?— cu t'anoo' ti'i. ");
INSERT INTO mopNT_vpl VALUES ("JN7_46","073_7_46","JHN","7","46","46","—Ma' yan mac walac u yadic a jabix a walac u yadic a Jesusu,— cu t'anoo' a jabix soldadojoo'o. ");
INSERT INTO mopNT_vpl VALUES ("JN7_47","073_7_47","JHN","7","47","47","—¿U chowaje'ex wa jabix ilic ti walac u chowicoo' a cristianojo?— cu t'anoo' a fariseo ti'ijoo'o. ");
INSERT INTO mopNT_vpl VALUES ("JN7_48","073_7_48","JHN","7","48","48","—Le'ecoo' a nucuch winic etel boono'on a fariseojo'ono, ma' ti tz'aj ti wool tu pach a Jesusi,— cu t'anoo' a fariseojo. ");
INSERT INTO mopNT_vpl VALUES ("JN7_49","073_7_49","JHN","7","49","49","—Le'ecoo' u yaabil a cristianojo, ma'ax c'u' u yeeloo' yoc'ol u ju'um a Dioso. Chen pula'anoo',— cu t'anoo' a fariseo ti'ijoo' a jabix soldadojoo'o. ");
INSERT INTO mopNT_vpl VALUES ("JN7_50","073_7_50","JHN","7","50","50","Le'ec aj Nicodemojo, le'ec jun tuul tu yaamoo' a fariseo u c'aba'oo' u na'ata. Bini ti sut etel a Jesus biq'uin ado'o. ");
INSERT INTO mopNT_vpl VALUES ("JN7_51","073_7_51","JHN","7","51","51","—Le'ec ti ley ino'on aj Israelo'ono, ma' ta'ach u cha'ic u tz'abül u sip'il wa ma' se' nac'sabi u yubi wa yan u sip'il,— cu t'an aj Nicodemo ti'ijoo'o. ");
INSERT INTO mopNT_vpl VALUES ("JN7_52","073_7_52","JHN","7","52","52","—Incheche, ¿aj Galileajilech wa jabixech ilic a Jesusu?— cu t'anoo' ti'i aj Nicodemojo. —Xoco ichil u ju'um a Dios a wila' ti ma' yan a Galileajil a watac u yadü' u t'an a Dioso,— cu t'anoo' ti'i aj Nicodemojo. ");
INSERT INTO mopNT_vpl VALUES ("JN7_53","073_7_53","JHN","7","53","53","Pues te'i. Laj usc'ajoo' tu yotoch. ");
INSERT INTO mopNT_vpl VALUES ("JN8_1","073_8_1","JHN","8","1","1","Pues te'i. Bini a Jesus tuwich a witz u c'aba' Olivojo. ");
INSERT INTO mopNT_vpl VALUES ("JN8_2","073_8_2","JHN","8","2","2","Tu samalil ti jatz'ca' le'ec ti tan u sastala, usc'aji a Jesus ichil u yotoch a Dioso. Tulacaloo' a cristianojo, much'lajoo' tu tzeel. Tinlaji ala'aji. Caji ti ca'ansaj. ");
INSERT INTO mopNT_vpl VALUES ("JN8_3","073_8_3","JHN","8","3","3","Le'ecoo' u yaj ca'ansajil u ley aj Moises u yet'ocoo' a fariseo u c'aba'oo' u na'ata, u c'ochesajoo' jun tuul ix ch'up. U wa'cuntajoo' tu taan a cristianojo. Müchbi ix ch'up abe' ti tan u betic a suductzil etel u yicham u yetixch'upili. ");
INSERT INTO mopNT_vpl VALUES ("JN8_4","073_8_4","JHN","8","4","4","—Maestro,— cu t'anoo' ti'i a Jesusu. —Ix ch'up ada'a, müchbi ti tan u betic a suductzil etel u yicham u yetixch'upili,— cu t'anoo' ti'i. ");
INSERT INTO mopNT_vpl VALUES ("JN8_5","073_8_5","JHN","8","5","5","—Tz'iiba'an ichil u ley aj Moises ti yan u p'up'uchch'inbil etel tunich ca' quimsabüc yoc'lal u sip'il. Uxtun incheche, ¿biqui'il a t'an yoc'lal a sip'il abe'e?— cu t'anoo' ti'i a Jesusu. ");
INSERT INTO mopNT_vpl VALUES ("JN8_6","073_8_6","JHN","8","6","6","Jadi' u yadajoo' abe'e, chen ti'i ca' u yaaltoo' u cho' ti'i ca' u cüxtoo' u sip'il a Jesusu. Chinlaji a Jesus ti tz'iib etel u ni' u c'ü' tuwich a lu'umu. ");
INSERT INTO mopNT_vpl VALUES ("JN8_7","073_8_7","JHN","8","7","7","Tan ti tanoo' u c'aatic ti'i. Tinlaji ti toj a Jesusu. —Le'ec a mac a ma' yan u sip'il ta yaame'exe, le'ec yan u cajsic a ch'ini,— cu t'an a Jesus ti'ijoo'o. ");
INSERT INTO mopNT_vpl VALUES ("JN8_8","073_8_8","JHN","8","8","8","Ca' chinlaji a Jesus tucaye' ti tz'iib etel u ni' u c'ü' tuwich a lu'umu. ");
INSERT INTO mopNT_vpl VALUES ("JN8_9","073_8_9","JHN","8","9","9","C'u' betiqui, le'ec ca' u yubajoo' abe'e, cajoo' ti joc'ol jujun tuulil le'ec a mas noochwinic payanbej asto ti joq'ui u yada'. P'aati a Jesus te'i etel ix ch'up a wa'an tu taana. ");
INSERT INTO mopNT_vpl VALUES ("JN8_10","073_8_10","JHN","8","10","10","Toj tinlaji a Jesus tucaye'ili. —Ix ch'up, ¿tuba que'enoo' aj tzolo? ¿Ma'ax mac wa u tz'aj a sip'il?— cu t'an a Jesus ti'iji. ");
INSERT INTO mopNT_vpl VALUES ("JN8_11","073_8_11","JHN","8","11","11","¿Ma'ax mac, noochwinic,— cu t'an ix ch'upu. —Ma'ax inen, ma' tin tz'eec a sip'il. Ca' xiquech. Ma' ca' beel a cüxte a sip'ili,— cu t'an a Jesus ti'iji. ");
INSERT INTO mopNT_vpl VALUES ("JN8_12","073_8_12","JHN","8","12","12","Pues te'i. Caji a Jesus ti t'an eteloo' a cristiano tucaye'ili. —Inene, u sasililen a cristiano yoc'olcab u men walac in tojquinticoo' u na'at jabix cuchi tan in sasilcuntiqui. Le'ec mac a que'en u yool tin pacha, ma' que'en to ichil u sip'il jabix que'en ichil a ac'ü'ü. Que'en tun ichil a jabix sasili. Yan ti'i a cuxtal a ma' yan q'uin u jobolo,— cu t'an a Jesusu. ");
INSERT INTO mopNT_vpl VALUES ("JN8_13","073_8_13","JHN","8","13","13","—Incheche, ta junal a testigo a bajil. Ma' yan u muc' a t'an ti baalo',— cu t'anoo' a fariseo u c'aba'oo' u na'at ti'i a Jesusu. ");
INSERT INTO mopNT_vpl VALUES ("JN8_14","073_8_14","JHN","8","14","14","—Ca'ax tin junal in testigo in bajil, jaj in t'an. Inen in weel tuba taleen, y te'i in ca' beel. C'u' betic inche'exe, ma' a weele'ex tuba taleen ma'ax tuba in ca' beel,— cu t'an a Jesus ti uchi u nuucu. ");
INSERT INTO mopNT_vpl VALUES ("JN8_15","073_8_15","JHN","8","15","15","—Tane'ex a tz'eec a bajil jabixe'ex aj il sip'il jadi' u men etel c'u' a tane'ex a wiliqui. Ma'ax mac a tan in tz'eec ichil u sip'ili,— cu t'an a Jesusu. ");
INSERT INTO mopNT_vpl VALUES ("JN8_16","073_8_16","JHN","8","16","16","—Wa cuchi tan in wilic a sip'ili, tan cuchi in wilic ti jaj u men ma' cuchi tin junal bel in quin wila' a sip'ili. Le'ec mac u tücaa'tajene, le'ec cuchi in wet'oc ti tan in wilic a sip'ili,— cu t'an a Jesusu. ");
INSERT INTO mopNT_vpl VALUES ("JN8_17","073_8_17","JHN","8","17","17","—Ichil a ley a te'exe, tz'iiba'an ti wa yan ca' tuul a testigojo, jaj u t'an,— cu t'an a Jesusu. ");
INSERT INTO mopNT_vpl VALUES ("JN8_18","073_8_18","JHN","8","18","18","—Inene, in testigo in bajil. Le'ec a Tattzil u tücaa'tajene, le'ec ilic in testigo xan,— cu t'an a Jesus ti'ijoo'o. ");
INSERT INTO mopNT_vpl VALUES ("JN8_19","073_8_19","JHN","8","19","19","—¿Tuba que'en a Tat?— cu t'anoo' ti'i etel a c'u' u yadaja. —Inche'exe, ma' a weelene'ex, ma'ax a weele'ex in Tat. Wa cuchi a weele'ex maquen inene, a weele'ex ilic cuchi in Tat,— cu t'an a Jesus ti'ijoo'o. ");
INSERT INTO mopNT_vpl VALUES ("JN8_20","073_8_20","JHN","8","20","20","Le'ec a Jesusu, u yadaj a t'an abe' ichil a cuarto tuba yan u taacbeeb a taq'uini. Tan u ca'ansaj ichil u yotoch a Dioso. C'u' betiqui, ma'ax mac u müchaj ala'aji, u men ma'ax to c'ochoc u yorajil u müchbül. ");
INSERT INTO mopNT_vpl VALUES ("JN8_21","073_8_21","JHN","8","21","21","Pues te'i. Ca' caji ti t'an a Jesus eteloo' ulaac' sut. —Inene, bel in ca'a. Inche'exe, bele'ex a ca'a a yaalte a cüxteen. Bele'ex a ca'a ti quimil ichile'ex a sip'il. Tuba bel in ca'a inene, ma' yan biqui ca' xique'ex,— cu t'an a Jesusu. ");
INSERT INTO mopNT_vpl VALUES ("JN8_22","073_8_22","JHN","8","22","22","—Tan u yadic ti ma' yan biqui ca' xico'on tuba u beel ala'aji. ¿Tan wa u tuclic u quimes u bajil?— cu t'anoo' u chucaan aj Israel tu bajiloo'o. ");
INSERT INTO mopNT_vpl VALUES ("JN8_23","073_8_23","JHN","8","23","23","—Inche'exe, wa'ye' yalam tala'ane'ex. Inene, ca'nal tala'anen. Inche'exe, ti'ije'ex wa'ye' yoc'olcab. Inene, ma' ti'ijen yoc'olcabi,— cu t'an a Jesusu. ");
INSERT INTO mopNT_vpl VALUES ("JN8_24","073_8_24","JHN","8","24","24","—In wadaj te'ex ti bele'ex a ca'a ti quimil ichile'ex a sip'il. Wa ma' ta tz'ocsique'ex maquen ti tan in wadic in bajili, bele'ex a ca'a ti quimil ichile'ex a sip'il,— cu t'an a Jesus ti'ijoo'o. ");
INSERT INTO mopNT_vpl VALUES ("JN8_25","073_8_25","JHN","8","25","25","—¿Maquech incheche?— cu t'anoo' ti'i a Jesusu. —Jabix ilic in wadaj te'ex biq'uin ado' y tac leeb,— cu t'an a Jesus ti'ijoo'o. ");
INSERT INTO mopNT_vpl VALUES ("JN8_26","073_8_26","JHN","8","26","26","—Inene, yan ti yaab c'u' a yan in wadic ta woc'ole'exe. Yan ilic ti yaab c'u' a yan in ye'ic te'ex le'ec a ma' qui' a betaje'exe. Le'ec mac u tücaa'tajene, jaj a walac u yadiqui. Inene, walac in ca' adic ti'ijoo' a cristiano yoc'olcab le'ec a c'u' in wu'yaj u yadaj,— cu t'an a Jesusu. ");
INSERT INTO mopNT_vpl VALUES ("JN8_27","073_8_27","JHN","8","27","27","Ma' u ch'a'ajoo' u tojil u t'an a Jesus ti tan u tzicbaltic a Tattzili, ");
INSERT INTO mopNT_vpl VALUES ("JN8_28","073_8_28","JHN","8","28","28","mentücü, u yadaj ti'ijoo': —Le'ec ca' a nac'se'ex tuwich u cruzil a yanaji ti cristianojili, bele'ex a ca'a a weelte ti le'ec mac a yanaji ti cristianojili, le'ec ilic inene. Bele'ex a ca'a a weelte ti ma'ax c'u' a walac in betic wa ma' tz'abi in muc' in betical. Jadi' walac in wadic c'u' u yadaj ten a Tattzili,— cu t'an a Jesusu. ");
INSERT INTO mopNT_vpl VALUES ("JN8_29","073_8_29","JHN","8","29","29","—Le'ec mac u tücaa'tajene, que'en ilic tin wetel. Ma' u p'ütajen tin junal u men ma' ta'ach in p'ütic in betic c'u' a qui' tu wich ala'i ca' in bete'e,— cu t'an a Jesusu. ");
INSERT INTO mopNT_vpl VALUES ("JN8_30","073_8_30","JHN","8","30","30","Tanil u yadic abe'e, yaaboo' a cajoo' u tz'aa' u yool tu pach a Jesusu. ");
INSERT INTO mopNT_vpl VALUES ("JN8_31","073_8_31","JHN","8","31","31","Pues te'i. Le'ec a Jesusu, caji ti t'an eteloo' a nucuch winic a boon a cajoo' to u tz'aa' u yool tu pach ala'aji. —Ma' a p'ütique'ex a tz'ocsic in t'an. Ti baalo'o, inche'ex in waj cambal tu jajil,— cu t'an ti'ijoo'. ");
INSERT INTO mopNT_vpl VALUES ("JN8_32","073_8_32","JHN","8","32","32","—Ti baalo'o, bele'ex a ca'a a weelte a jajil t'ana. Le'ec a jajil t'ana, bel u cu tz'a' te'ex ca' cha'büque'ex,— cu t'an a Jesus ti'ijoo'o. ");
INSERT INTO mopNT_vpl VALUES ("JN8_33","073_8_33","JHN","8","33","33","—Ino'on u mamo'on ti uchben mamaa' aj Abraham. Ma'ax jun sut culajo'on ti q'uexbil mozojo'on. ¿C'u' ca'a tan a wadic to'on ti bel ti ca'a cha'bül?— cu t'anoo' ti'i a Jesusu. ");
INSERT INTO mopNT_vpl VALUES ("JN8_34","073_8_34","JHN","8","34","34","—Bel in quin wadü' te'ex u jajil,— cu t'an a Jesus ti uchi u nuucu. —Tulacal boon mac a walac u yantal u sip'ili, laj mücha'anoo' u men u sip'il. Le'ec u sip'ili, le'ec u yumil,— cu t'an a Jesusu. ");
INSERT INTO mopNT_vpl VALUES ("JN8_35","073_8_35","JHN","8","35","35","—Le'ec a q'uexbil mozo a yan u yumil ti jabix in wadaja, ma' u familia u yumil a naji. Jadi' a Mejentzili, jadi' a chucul u yet'oc u yumil a naja,— cu t'an a Jesusu. ");
INSERT INTO mopNT_vpl VALUES ("JN8_36","073_8_36","JHN","8","36","36","—Wa le'ec a Mejentzil a ca' u chaa' a q'uexbil mozojo, cha'bi jumpul,— cu t'an a Jesus yoc'ol u joc'sic a mac ichil u sip'ili. ");
INSERT INTO mopNT_vpl VALUES ("JN8_37","073_8_37","JHN","8","37","37","—In weel ti inche'exe, u mame'ex ti uchben mamaa' aj Abraham. C'u' betiqui, tane'ex a c'atiintic a quimseen u men ma' qui' ta xiquine'ex in t'an,— cu t'an a Jesusu. ");
INSERT INTO mopNT_vpl VALUES ("JN8_38","073_8_38","JHN","8","38","38","—Inene, tan in wadic c'u' in cünaj etel in Tat. Baalo' ilic inche'exe, tane'ex a betic c'u' a cünaje'ex etel a tate'exe,— cu t'an a Jesusu. ");
INSERT INTO mopNT_vpl VALUES ("JN8_39","073_8_39","JHN","8","39","39","—Le'ec ti tat ino'ono, le'ec ti uchben mamaa' aj Abraham,— cu t'anoo' ti'i a Jesus ti uchoo' u nuucu. —Wa cuchi u mejene'ex aj quimen Abrahama, walaque'ex cuchi a betic a jabix u betaj aj Abrahama,— cu t'an a Jesus ti'ijoo'o. ");
INSERT INTO mopNT_vpl VALUES ("JN8_40","073_8_40","JHN","8","40","40","—C'u' betiqui, tane'ex a c'atiintic a quimseen u men in wadaj te'ex a jajil t'an in wu'yaj etel a Dioso. Ma' u betaj ti baalo' aj Abrahami,— cu t'an a Jesusu. ");
INSERT INTO mopNT_vpl VALUES ("JN8_41","073_8_41","JHN","8","41","41","—Inche'exe, walaque'ex a betic a jabix u betaj a tate'exe,— cu t'an a Jesusu. —Ino'ono, ma' molbilo'oni. Yan ti tat jun tuul, jadi' a Dioso,— cu t'anoo' ti'i a Jesusu. ");
INSERT INTO mopNT_vpl VALUES ("JN8_42","073_8_42","JHN","8","42","42","—Wa cuchi Dios a Tate'exe, tane'ex cuchi a c'atiintiquen u men te' tala'anen etel a Dioso. Udeen wa'ye' pero ma' chen udeeni. Tücaa'been,— cu t'an a Jesus ti'ijoo'o. ");
INSERT INTO mopNT_vpl VALUES ("JN8_43","073_8_43","JHN","8","43","43","—¿Ma' wa a weele'ex c'u' ca'a ti ma' tane'ex a ch'a'ic u tojil in t'an? Ma' tane'ex a ch'a'ic u tojil u men ma' qui' ta xiquine'ex,— cu t'an a Jesus ti'ijoo'o. ");
INSERT INTO mopNT_vpl VALUES ("JN8_44","073_8_44","JHN","8","44","44","—Le'ec a tate'exe, le'ec a quisini. Jadi' a c'ate'ex a bete' c'u' u c'ati a tate'exe. Aj quimsaj ala'i le'ec ti yaax betabi a yoc'olcab y tac leeb. Ma' qui' tu xiquin a jaja, u men ma' yan a jaj etele. Le'ec ti tan u tusu, tan ilic u yadic jabix ti suc u yadü'ü. Ala'aji, aj tus bete cuenta u tat aj tus u men le'ec u yaax cajsaj,— cu t'an a Jesusu. ");
INSERT INTO mopNT_vpl VALUES ("JN8_45","073_8_45","JHN","8","45","45","—C'u' betiqui, u men tan in wadic a jajil t'ana, ma' ta'ache'ex a tz'ocsic in t'an,— cu t'an a Jesusu. ");
INSERT INTO mopNT_vpl VALUES ("JN8_46","073_8_46","JHN","8","46","46","—¿Mac ta yaame'ex u paatal u yadic c'u' a ma' qui' in betaja? ¿Wa tan in wadic te'ex u jajili, c'u' ca'a ma' ta'ache'ex a tz'ocsic in t'an?— cu t'an a Jesus ti'ijoo'o. ");
INSERT INTO mopNT_vpl VALUES ("JN8_47","073_8_47","JHN","8","47","47","—Le'ec mac a ti'i a Dioso, walac u tz'ocsic u t'an a Dioso. Ma' ta'ache'ex a tz'ocsic u t'an a Dioso, u men ma' ti'ije'ex Dios,— cu t'an a Jesusu. ");
INSERT INTO mopNT_vpl VALUES ("JN8_48","073_8_48","JHN","8","48","48","Pues te'i. —Ca wilic. Jaj ti tan ti wadic ti incheche, aj c'ac'as winiquech jabixech aj Samariajili. Jaj ti yan a c'ac'asba'al ta wool,— cu t'anoo' a nucuch winic ti'i a Jesusu. ");
INSERT INTO mopNT_vpl VALUES ("JN8_49","073_8_49","JHN","8","49","49","—Inene, ma' yan a c'ac'asba'al tin wooli. C'u' betiqui, walac in tz'ocsic u yanil in Tat. Inche'exe, ma' ta'ache'ex a tz'ocsic in yanil,— cu t'an a Jesus ti'ijoo'o. ");
INSERT INTO mopNT_vpl VALUES ("JN8_50","073_8_50","JHN","8","50","50","—C'u' betiqui, ma' tan in betic a c'u' tac chen ti'i ca' aalbüc in qui'ili. Yan jun tuul, tan u c'atiintic ca' aalbüc in qui'il. Ala'aji, u yeel ti toj in na'at,— cu t'an a Jesusu. ");
INSERT INTO mopNT_vpl VALUES ("JN8_51","073_8_51","JHN","8","51","51","—Bel in quin wadü' te'ex u jajil. Le'ec mac walac u tz'ocsic in t'ana, ma' yan q'uin u quimil,— cu t'an a Jesusu. ");
INSERT INTO mopNT_vpl VALUES ("JN8_52","073_8_52","JHN","8","52","52","—Ti weel aleebe tu jajil ti yan a c'ac'asba'al ta wool,— cu t'anoo' ti'i a Jesusu. —Quimi aj Abrahama. Quimoo' ilic boon u yadajoo' u t'an a Dios uchiji. “Le'ec mac walac u tz'ocsic in t'ana, ma' yan q'uin u quimil,” queech,— cu t'anoo' a nucuch winiqui. ");
INSERT INTO mopNT_vpl VALUES ("JN8_53","073_8_53","JHN","8","53","53","—¿Mas noochech wa ta tuclic a bajil tuwich ti uchben mamaa' aj Abraham? Quimi ala'aji. Quimoo' ilic boon u yadajoo' u t'an a Dios uchi. ¿Mac winiquilech ti tan a tuclic a bajil?— cu t'anoo' u chucaan aj Israel ti'iji. ");
INSERT INTO mopNT_vpl VALUES ("JN8_54","073_8_54","JHN","8","54","54","—Wa ca' in wadü' in patalil tin bajili, ma' yan u muc' in t'an. In Tat walac u ye'ic in patalil. Le'ec ilic ala'aji, tane'ex a wadic ti le'ec a Diose'ex,— cu t'an a Jesus ti uchi u nuuc. ");
INSERT INTO mopNT_vpl VALUES ("JN8_55","073_8_55","JHN","8","55","55","—C'u' betiqui, ma' a weele'ex ala'aji. Inene, in laj eel biqui yanil a Dioso. Wa cuchi ca' in wadü' ti ma' in weel ala'aji, bel cuchi u ca'a ti joc'ol ten ti aj tusen jabixe'ex iliqui. C'u' betiqui, in weel ala'aji. Walac in tz'ocsic u t'an,— cu t'an a Jesus ti'ijoo'o. ");
INSERT INTO mopNT_vpl VALUES ("JN8_56","073_8_56","JHN","8","56","56","—Le'ec ti uchben mamaa' aj Abrahama, qui' u yool ca' u yeeltaj ti bel u ca'a u yila' u q'uinil in wudel wa'ye'. U yilaj. Qui' u yool,— cu t'an a Jesusu. ");
INSERT INTO mopNT_vpl VALUES ("JN8_57","073_8_57","JHN","8","57","57","—Incheche, ma'ax to a müchü' ma'ax cincuenta jaab. ¿Biqui ca' a wilaj aj Abrahama?— cu t'anoo' a nucuch winic ti'iji. ");
INSERT INTO mopNT_vpl VALUES ("JN8_58","073_8_58","JHN","8","58","58","—Bel in quin wadü' te'ex u jajil. Le'ec ti ma'ax to yanac aj Abrahama, yanen ilic,— cu t'an a Jesus ti'ijoo'o. ");
INSERT INTO mopNT_vpl VALUES ("JN8_59","073_8_59","JHN","8","59","59","Pues te'i. A cristianojo, u molajoo' a tunich ti'i ca' u p'up'uchch'inte a Jesusu. C'u' betic ala'aji, u mucaj u bajil. Mani tu yaamoo'. Joq'ui ichil u yotoch a Dioso. ");
INSERT INTO mopNT_vpl VALUES ("JN9_1","073_9_1","JHN","9","1","1","Pues te'i. Le'ec ti tan u manül a Jesusu, u yilaj jun tuul a winiqui. Ch'oop ti yanaji. ");
INSERT INTO mopNT_vpl VALUES ("JN9_2","073_9_2","JHN","9","2","2","—Maestro,— cu t'anoo' u yaj cambal a Jesus ti'iji. —¿U men wa u sip'il u na' u tat wa u men u sip'il ilic ala'i ti ch'oop ti yanaji?— cu t'anoo' ti'i. ");
INSERT INTO mopNT_vpl VALUES ("JN9_3","073_9_3","JHN","9","3","3","—Yanaji ti ch'oop ma' u men u sip'il ilic ala'aji, ma'ax u men u sip'il u na' u tat. Yanaji ti ch'oop ti'i ca' chiclac u muc' u meyaj a Dios yoc'olo,— cu t'an a Jesusu. ");
INSERT INTO mopNT_vpl VALUES ("JN9_4","073_9_4","JHN","9","4","4","—Yan ti betic u meyaj mac u tücaa'tajen le'ec ti yan to a q'uin to'ono. Joboc u q'uinil ti'i a maca, ma' tu ca' paatal ti meyaj,— cu t'an a Jesusu. ");
INSERT INTO mopNT_vpl VALUES ("JN9_5","073_9_5","JHN","9","5","5","—Le'ec boon q'uin que'enen wa'ye' yoc'olcaba, inen u sasilil a yoc'olcab, u men tan in ye'ic a jaja, le'ec in meyaj,— cu t'an a Jesusu. ");
INSERT INTO mopNT_vpl VALUES ("JN9_6","073_9_6","JHN","9","6","6","Pues te'i. Uchi u tuub tuwich a lu'umu. U xaabtaj a luc' etel u tuubu. U mansaj yoc'ol u cuuchil u wich a ch'oopo. ");
INSERT INTO mopNT_vpl VALUES ("JN9_7","073_9_7","JHN","9","7","7","—Ca' xiquech a p'o' a wich ichil u cuuch ja' u c'aba' Siloe,— cu t'an a Jesus ti'iji. U nu'cul a t'an Siloeje, tücaa'bi. Bini a winiqui, U p'o'aj u wich. Ch'ani. Tan tun u cha'an ti usc'aji. ");
INSERT INTO mopNT_vpl VALUES ("JN9_8","073_9_8","JHN","9","8","8","Ilbi u menoo' u yettzeel y u menoo' boon u c'aj-ooloo' u wich ti aj matan taq'uin. —¿Ma' wa le'ec a winic ada' a walac u tintal ti matan taq'uin biq'uin ado'o?— cu t'anoo' tu bajil. ");
INSERT INTO mopNT_vpl VALUES ("JN9_9","073_9_9","JHN","9","9","9","Yan u yadaj ti le'ec. —Ma' le'equi. Chen jabix quet u cha'an etele,— cu t'anoo' ulaac'. —Inen a ch'oop biq'uin ado' a tane'ex a wadiqui,— cu t'an a winiqui. ");
INSERT INTO mopNT_vpl VALUES ("JN9_10","073_9_10","JHN","9","10","10","—¿Biqui ti jeebi a wich?— cu t'anoo' ti'i. ");
INSERT INTO mopNT_vpl VALUES ("JN9_11","073_9_11","JHN","9","11","11","—Jun tuul a winiqui, Jesus u c'aba'. U betaj a luc'u. U tz'aj yoc'ol in wich. “Ca' xiquech a p'o' a wich ich ja' Siloe,” cu t'an ten. Bineen. In p'o'aj in wich. Uchi in cha'an,— cu t'an a winic ti uchi u nuuc. ");
INSERT INTO mopNT_vpl VALUES ("JN9_12","073_9_12","JHN","9","12","12","—¿Tuba que'en ala'aji?— cu t'anoo' ti'i. —Ma' in weel tuba que'en,— cu t'an a winiqui. ");
INSERT INTO mopNT_vpl VALUES ("JN9_13","073_9_13","JHN","9","13","13","Pues te'i. U bensajoo' a winic a ch'oop biq'uin ado' tu taanoo' a fariseo u c'aba'oo' u na'ata. ");
INSERT INTO mopNT_vpl VALUES ("JN9_14","073_9_14","JHN","9","14","14","Ti'i u q'uinil jedel utzquinbi a luc'u. A Jesusu, u ch'anesaj u wich a winic etele. ");
INSERT INTO mopNT_vpl VALUES ("JN9_15","073_9_15","JHN","9","15","15","Le'ecoo' a fariseo u c'aba'oo' u na'ata, u c'aatajoo' ti'i biqui ti jeebi u wich. —U tz'aj luc' yoc'ol in wich. In p'o'aj. Uchi in cha'an,— cu t'an a winic ti'ijoo'o. ");
INSERT INTO mopNT_vpl VALUES ("JN9_16","073_9_16","JHN","9","16","16","—Le'ec a Jesusu, ma' Dios u tücaa'taji, u men ma' ta'ach u tz'ocsic u q'uinil a jedele,— cu t'anoo' jun jatz a fariseo u c'aba'oo' u na'at. —Wa cuchi yan u sip'il a Jesusu, ma' cuchi yan biqui ca' u bete' a milagro jabix abe'e,— cu t'anoo' ulaac' a jun jatza. Ma' quetoo' u tuculi. ");
INSERT INTO mopNT_vpl VALUES ("JN9_17","073_9_17","JHN","9","17","17","U ca' c'aatajoo' ti'i a ch'oop ti culajiji: —¿C'u' a t'an inchech yoc'ol ti ca' u jebaj a wichi?— cu t'anoo' ti'i. —Le'ec ala'aji, jun tuul a tan u yadic u t'an a Dioso,— cu t'an a winic ti'ijoo'o. ");
INSERT INTO mopNT_vpl VALUES ("JN9_18","073_9_18","JHN","9","18","18","C'u' betiqui, le'ecoo' a nucuch winiqui, ma' u tz'ocsajoo' wa jaj ti ch'oop a winiqui, y jeebi u wich. U püyajoo' u na' u tat a winic a jeebi u wich. ");
INSERT INTO mopNT_vpl VALUES ("JN9_19","073_9_19","JHN","9","19","19","—¿Le'ec wa ada' a mejen a walaque'ex a wadic ti ch'oop ti yanaji? ¿Biqui ti walac u cha'an aleebe?— cu t'anoo' ti'i. ");
INSERT INTO mopNT_vpl VALUES ("JN9_20","073_9_20","JHN","9","20","20","—Ti weel ala'aji, ti mejen. Ti weel ti ch'oop ti yanaji. ");
INSERT INTO mopNT_vpl VALUES ("JN9_21","073_9_21","JHN","9","21","21","C'u' betiqui, biqui ti patal ti cha'an aleebe, ma' ti weel. Ma'ax ti weel mac u jebaj u wich. C'aate'ex ti'i. Chucul u jaab u yadic c'u' a mani ti'iji,— cu t'anoo' u na' u tat ti'ijoo' a nucuch winiqui. ");
INSERT INTO mopNT_vpl VALUES ("JN9_22","073_9_22","JHN","9","22","22","Le'ecoo' u na' u tata, u yadajoo' ti baalo', u men saacoo' ti'i a nucuch winiqui. Le'ecoo' a nucuch winiqui, ac u yadajoo' tu bajil: —Beloo' u ca'a joc'sabül ichil u yotoch Dios boon tuuloo' a cristiano a walacoo' u yadic ti le'ec a Jesusu, le'ec u yaj Sa'alil a cristianojo,— cu t'anoo' tu bajil. ");
INSERT INTO mopNT_vpl VALUES ("JN9_23","073_9_23","JHN","9","23","23","Baalo' u yadajoo', mentücü, le'ecoo' u na' u tata, u yadajoo' ti chucul u jaab u c'aatoo' ti'i. ");
INSERT INTO mopNT_vpl VALUES ("JN9_24","073_9_24","JHN","9","24","24","Pues te'i. U püyajoo' u ca' sut a winic a ch'oop ti culaji. —Adü u qui'il a Dios a que'en ti ca'ana. Ino'ono, ti weel ti yan u sip'il a Jesusu,— cu t'anoo' a nucuch winic ti'i a winiqui. ");
INSERT INTO mopNT_vpl VALUES ("JN9_25","073_9_25","JHN","9","25","25","—Inene, ma' in weel wa yan u sip'il a Jesusu. Le'ec c'u' in weele, biq'uin ado'o, ch'oopen. Aleebe tan in cha'an,— cu t'an a winic ti uchi u nuuc. ");
INSERT INTO mopNT_vpl VALUES ("JN9_26","073_9_26","JHN","9","26","26","—¿C'u' u betaj teche? ¿Biqui ca' u jebaj a wich?— cu t'anoo' ti'i a winiqui. ");
INSERT INTO mopNT_vpl VALUES ("JN9_27","073_9_27","JHN","9","27","27","—In wadaj tun te'ex, y ma' a c'atiintaje'ex a wu'yi. ¿C'u' ca'a a c'ate'ex a wu'yi tucaye'il? ¿A c'ate'ex wa a tz'a'e'ex a wool tu pach ala'aji?— cu t'an a winic ti uchi u nuuc. ");
INSERT INTO mopNT_vpl VALUES ("JN9_28","073_9_28","JHN","9","28","28","Le'ecoo' a nucuch winiqui, u p'a'astajoo' a winiqui. —Incheche, que'en a wool tu pach ala'aji. Ino'ono, que'en ti wool tu pach u t'an aj Moises,— cu t'anoo' ti'i a winiqui. ");
INSERT INTO mopNT_vpl VALUES ("JN9_29","073_9_29","JHN","9","29","29","—Ino'ono, ti weel ti uchi u t'an a Dios etel aj Moisese. A winic abe'e, ma'ax ti weel tuba tali,— cu t'anoo' a nucuch winiqui. ");
INSERT INTO mopNT_vpl VALUES ("JN9_30","073_9_30","JHN","9","30","30","—Top jumpaay abe'e. Inche'exe, ma' a weele'ex tuba tali. C'u' betiqui, u jebaj in wich,— cu t'an a winiqui. ");
INSERT INTO mopNT_vpl VALUES ("JN9_31","073_9_31","JHN","9","31","31","—Tulacalo'on ti weel. Le'ec mac a yan u sip'ili, ca'ax uchuc u t'an etel a Dioso, ma' tu yubajbül,— cu t'an a winiqui. —C'u' betiqui, le'ec a walac u c'ajsic a Dioso, y walac u betic c'u' u c'atiji, walac u yubajbül u t'an,— cu t'an a winiqui. ");
INSERT INTO mopNT_vpl VALUES ("JN9_32","073_9_32","JHN","9","32","32","—Le'ec ti yaax yanaji a yoc'olcab y tac leeb ma'ax jun sut u'yajbüc ti ch'anesabi a yanaji ti ch'oopo,— cu t'an a winiqui. ");
INSERT INTO mopNT_vpl VALUES ("JN9_33","073_9_33","JHN","9","33","33","—Wa cuchi ma' tali etel Dios a winic abe'e, ma' cuchi tu paatal u bete' a ma'ax c'u'iji,— cu t'anoo' u yaalbül a nucuch winiqui. ");
INSERT INTO mopNT_vpl VALUES ("JN9_34","073_9_34","JHN","9","34","34","—Incheche, ch'oop ti yanajeech u men yaab a sip'il. ¿Inchech wa ca' a ca'anso'on?— cu t'anoo' ti'i a winic ti uchoo' u nuucu. U tooltajoo' pach naj. ");
INSERT INTO mopNT_vpl VALUES ("JN9_35","073_9_35","JHN","9","35","35","Pues te'i. Le'ec a Jesusu, u yubaj ti toolbi a winiqui. U cüxtaj. —¿Que'en wa a wool tu pach u Mejen a Dioso?— cu t'an ti'i a winiqui. ");
INSERT INTO mopNT_vpl VALUES ("JN9_36","073_9_36","JHN","9","36","36","—¿Maqui abe'e, noochwinic? In c'ati cuchi in tz'aa' in wool tu pach,— cu t'an a winic ti uchi u nuuc. ");
INSERT INTO mopNT_vpl VALUES ("JN9_37","073_9_37","JHN","9","37","37","—A winic abe'e, le'ec u ch'anesajech, le'ec ilic inen a tan in tzicbal ta wetel,— cu t'an a Jesus ti'iji. ");
INSERT INTO mopNT_vpl VALUES ("JN9_38","073_9_38","JHN","9","38","38","—Noochil, que'en in wool ta pach,— cu t'an a winiqui. Xonlaji tu taan a Jesusu. ");
INSERT INTO mopNT_vpl VALUES ("JN9_39","073_9_39","JHN","9","39","39","—Taleen ti'i ca' chiclac biqui yanil a cristiano a qui' a ma' qui'i,— cu t'an a Jesusu. —Le'ec boon tuul u yeeloo' ti ma' c'üma'anoo' u men a Dioso, bete cuenta jabix ch'oopoo'o, bel u ca'a tz'abül ti'ijoo' ca' u yeeltoo' a jaja. Le'ec boon tuul a chen tanoo' u tuclic ti c'üma'anoo' u men a Dioso, bel u ca'a tz'abül ti'ijoo' ti ma' u yeeloo' a jaja, bete cuenta p'aatüloo' u ca'a jabix ch'oopoo',— cu t'an a Jesusu. ");
INSERT INTO mopNT_vpl VALUES ("JN9_40","073_9_40","JHN","9","40","40","Pues te'i. Yanoo' a winic tu tzeel a Jesusu. Fariseo u c'aba'oo' u na'at. U yubajoo' a t'an abe'e. —¿Ch'oopo'on wa ti baalo'? ¿Bel wa ti ca'a ti weelte a jaja?— cu t'anoo' ti'i a Jesusu. ");
INSERT INTO mopNT_vpl VALUES ("JN9_41","073_9_41","JHN","9","41","41","—Wa cuchi a weele'ex ti ma' c'üma'ane'ex u men a Dioso, bete cuenta jabix ch'oope'ex, ma' cuchi ta cuntale'ex ichil a sip'il. C'u' betiqui, tane'ex a wadic ti jabix chica'an te'ex a jaja, mentücü, que'ene'ex ichil a sip'il,— cu t'an a Jesus ti'ijoo'o. ");
INSERT INTO mopNT_vpl VALUES ("JN10_1","073_10_1","JHN","10","1","1","—Pues te'i. Bel in quin wadü' te'ex u jajil. Walac u cününbül a carnero ich cot ti ac'ü'. Le'ec mac a ma' ta'ach u yocol chi' a coto, chen u cüxtaj ulaac' biqui ca' ococo, ala'aji, aj xuuch',— cu t'an a Jesusu. ");
INSERT INTO mopNT_vpl VALUES ("JN10_2","073_10_2","JHN","10","2","2","—C'u' betiqui, le'ec mac a walac u yocol chi' a coto, le'ec u yaj cananil a carnerojo,— cu t'an a Jesusu. ");
INSERT INTO mopNT_vpl VALUES ("JN10_3","073_10_3","JHN","10","3","3","—Le'ec aj cünün chi' coto, bel u cu jebe' ca' ococ u yaj cananil a carnerojo. Ala'aji, walac u püyic u carnero etel u c'aba'. Eeltzil u t'an u menoo' u yalac'. Walac u ch'a'ic u beniloo' pach cot,— cu t'an a Jesusu. ");
INSERT INTO mopNT_vpl VALUES ("JN10_4","073_10_4","JHN","10","4","4","—Le'ec ti joc'oo' tulacal boon a ti'iji, walac u beel taanil ala'aji. Tücünacoo' a carnero tu pach u men u yeeloo' u t'an,— cu t'an a Jesusu. ");
INSERT INTO mopNT_vpl VALUES ("JN10_5","073_10_5","JHN","10","5","5","—Ma' tu beeloo' tu pach a ca'ax macaqui. Beloo' u ca'a ti puutz'ul tu taan abe' u men ma' u yeeloo' u t'an,— cu t'an a Jesusu. ");
INSERT INTO mopNT_vpl VALUES ("JN10_6","073_10_6","JHN","10","6","6","Pues te'i. Le'ec boon u yubajoo' a mucult'an abe' u yadaj a Jesusu, ma' u ch'a'ajoo' u tojil, ");
INSERT INTO mopNT_vpl VALUES ("JN10_7","073_10_7","JHN","10","7","7","mentücü, caji ti tzicbal a Jesus tucaye'il eteloo'o. —Bel in quin wadü' te'ex u jajil. Inene, jabixen u chi' a cot tuba que'enoo' a carnerojo,— cu t'an a Jesusu. ");
INSERT INTO mopNT_vpl VALUES ("JN10_8","073_10_8","JHN","10","8","8","—Le'ec boon a payanbej c'ochi tin taana, le'ecoo' aj xuuch'u. C'u' betiqui, le'ecoo' a carnerojo, ma' u tz'ocsajoo' u t'an aj xuuch'u,— cu t'an a Jesusu. ");
INSERT INTO mopNT_vpl VALUES ("JN10_9","073_10_9","JHN","10","9","9","—Inen jabixen u chi' a coto. Wa yan mac u c'ati ocol tu chi' a coto, yan u tz'eec u yool tin pach. Bel u ca'a sa'albül. Bel u cu c'ümü' a cuxtal a ma' yan q'uin u jobolo. Jabix ilic ti cününa'an a carnero ti tan u yocol y u joc'ol u cüxte u janala, baalo' ilic ala'oo'o,— cu t'an a Jesusu. ");
INSERT INTO mopNT_vpl VALUES ("JN10_10","073_10_10","JHN","10","10","10","—Le'ec aj xuuch'u, jadi' walac u c'ochol ti xuuch'. Walac u c'ochol ti quimes y ti c'ascunaj. Inene, udeen ti'i ca' u c'ümoo' a cuxtal a ma' yan q'uin u jobolo. Udeen ti'i ca' u c'ümoo' u yaabil a qui' ichil a cuxtal abe'e,— cu t'an a Jesusu. ");
INSERT INTO mopNT_vpl VALUES ("JN10_11","073_10_11","JHN","10","11","11","—Inene, jabixen u yaj quich'pan cananil a carnerojo. Le'ec u yaj quich'pan cananil a carnerojo, walac u c'ubic u cuxtal yoc'ol u sa'altic a carnerojo,— cu t'an a Jesusu. ");
INSERT INTO mopNT_vpl VALUES ("JN10_12","073_10_12","JHN","10","12","12","—Le'ec mac a tan u naal y ma' chucul u yaj cananili, ma' ti'i a carnerojo. Le'ec ca' u yila' ti watac a baalumu, bel u ca'a u p'ütü' a carnero a ma' chucul u yaj cananili. Bel u ca'a ti puutz'ul. Le'ec a baalumu, bel u cu pulu' u bajil yoc'ol a carnerojo. Beloo' u ca'a ti weequel,— cu t'an a Jesusu. ");
INSERT INTO mopNT_vpl VALUES ("JN10_13","073_10_13","JHN","10","13","13","—Le'ec u yaj cananili, bel u ca'a ti puutz'ul u men chen tan u naal. Ma' c'u' u t'an ti'i a carneroji,— cu t'an a Jesusu. ");
INSERT INTO mopNT_vpl VALUES ("JN10_14","073_10_14","JHN","10","14","14","—Inene, jabixen u yaj quich'pan cananil a carnerojo. Jabix ilic in weel mac a tene, y u yeelenoo' ala'oo'o, ");
INSERT INTO mopNT_vpl VALUES ("JN10_15","073_10_15","JHN","10","15","15","baalo' ilic ti le'ec a Tattzili, u yeel in wich y le'ec inene, in weel a Tattzili. Inene, bel in quin c'ubu' in cuxtal yoc'ol in sa'altic a cristiano jabix a walac u betic u yaj quich'pan cananil a carnerojo,— cu t'an a Jesusu. ");
INSERT INTO mopNT_vpl VALUES ("JN10_16","073_10_16","JHN","10","16","16","—Le'ec boon a que'en tin wetele, tan in cününtic jabix ti walac u cününbül a carnero ich cot u men u yaj cananili. Yanoo' ten ulaac' a cristiano a ma' Israeloo'o. Ala'oo'o, jabix ulaac' in carnerojo. Yan in talesicoo'. Beloo' u cu tz'oques in t'an. Baalo' ti bel u ca'a ti p'aatül ti jun muuch' ilic a tene, y jun tuul ilic u yaj cananil,— cu t'an a Jesusu. ");
INSERT INTO mopNT_vpl VALUES ("JN10_17","073_10_17","JHN","10","17","17","—Le'ec a Tattzili, yaj u yubeen u men bel in quin bete' a jabix u c'ati le'ec ca' in c'ubu' in cuxtal ca' quimsabüquen ti'i ca' cuxlaquen tucaye'il,— cu t'an a Jesusu. ");
INSERT INTO mopNT_vpl VALUES ("JN10_18","073_10_18","JHN","10","18","18","—Ma' yan mac ca' u quimseen. C'u' betic inene, tan in c'ubic in bajil ca' quimsabüquen u men in c'ati. Chucul in patalil in tz'eec in bajil ti quimil. Chucul ilic in patalil in tz'eec in bajil ti cuxtal tucaye'il. Le'ec a Tattzili, u tücaa'tajen in bete' ti baalo',— cu t'an a Jesusu. ");
INSERT INTO mopNT_vpl VALUES ("JN10_19","073_10_19","JHN","10","19","19","Pues te'i. A nucuch winiqui, ca' u yubajoo' a t'an abe'e, ma' jumbeloo' u tuculi. ");
INSERT INTO mopNT_vpl VALUES ("JN10_20","073_10_20","JHN","10","20","20","—Yan a c'ac'asba'al tu yool. Ma' qui' u pol. ¿C'u' aj beel ca' ti wu'yi u t'an?— cu t'anoo' jun jatz a nucuch winiqui. ");
INSERT INTO mopNT_vpl VALUES ("JN10_21","073_10_21","JHN","10","21","21","—Ma',— cu t'anoo' ulaac' a jun jatz a nucuch winiqui. —Le'ec mac a yan a c'ac'asba'al tu yoolo, ma' tu paatal u yadic a t'an a jabix abe'e. ¿Biqui ca' paatac a c'ac'asba'al u sasilcunte u wich a ch'oopo?— cu t'anoo' ala'oo'. ");
INSERT INTO mopNT_vpl VALUES ("JN10_22","073_10_22","JHN","10","22","22","Pues te'i. C'ochi u q'uinil a fiesta ich Jerusalene, ti tan u c'ajsabül le'ec ti qui'qui't'anbi u yotoch Dios uchi. ");
INSERT INTO mopNT_vpl VALUES ("JN10_23","073_10_23","JHN","10","23","23","Tan u q'uinil a siisi. Chen tan u manül a Jesus ichil jun p'eel cuarto ichil u yotoch a Dioso. Salomon u c'aba' a cuarto abe'e. ");
INSERT INTO mopNT_vpl VALUES ("JN10_24","073_10_24","JHN","10","24","24","Le'ecoo' a nucuch winiqui, wa'lajoo' tulacal tu xooy a Jesusu. —¿C'u' ca'a ma' tan a wadic to'on u tojil mac winiquilech? Wa inchech u yaj Sa'alil a cristianojo, adü to'on ti chica'an,— cu t'anoo' ti'i a Jesusu. ");
INSERT INTO mopNT_vpl VALUES ("JN10_25","073_10_25","JHN","10","25","25","—In wadaj te'ex y ma' a tz'ocsaje'ex in t'an. Le'ec c'u' a walac in betic etel u muc' in Tata, le'ec in testigo,— cu t'an a Jesus ti uchi u nuuc. ");
INSERT INTO mopNT_vpl VALUES ("JN10_26","073_10_26","JHN","10","26","26","—C'u' betiqui, ma' ta'ache'ex a tz'ocsic in t'an u men ma' tene'ex, jabix ilic in wadaj yoc'ol a carnerojo,— cu t'an a Jesusu. ");
INSERT INTO mopNT_vpl VALUES ("JN10_27","073_10_27","JHN","10","27","27","—Le'ec boon a tene, u yeeloo' in t'an. Inene, in weeloo'. Walacoo' u tz'ocsic in t'an jabix ilic in wadaj yoc'ol a carnerojo,— cu t'an a Jesusu. ");
INSERT INTO mopNT_vpl VALUES ("JN10_28","073_10_28","JHN","10","28","28","—Walac in tz'eec ti'ijoo' a cuxtal a ma' yan q'uin u jobolo. Ma' yan q'uin u p'aatül ti pula'anoo'. Ma'ax mac jede'ec u paatal u toco' ten ala'oo'o,— cu t'an a Jesusu. ");
INSERT INTO mopNT_vpl VALUES ("JN10_29","073_10_29","JHN","10","29","29","—In Tata, u sijaj ten ala'oo'o. Mas nooch u yanil tuwich tulacal a c'u' a yana. Ma'ax mac jede'ec u paatal u toco' ala'oo' tu c'ü' a Tattzili,— cu t'an a Jesusu. ");
INSERT INTO mopNT_vpl VALUES ("JN10_30","073_10_30","JHN","10","30","30","—Le'ec inen etel a Tattzili, jun tuul ilico'on tiqui bajil,— cu t'an a Jesusu. ");
INSERT INTO mopNT_vpl VALUES ("JN10_31","073_10_31","JHN","10","31","31","Pues te'i. Le'ecoo' a nucuch winiqui, u molajoo' a tunich tucaye' ti'i ca' u p'up'uchch'inte a Jesusu. ");
INSERT INTO mopNT_vpl VALUES ("JN10_32","073_10_32","JHN","10","32","32","—Yan ti yaab a quich'pan meyaj in betaj etel u muc' in Tat ta taane'ex. ¿C'u' ti quich'pan meyajil in betaj a ma' qui' ta wiche'ex ti bele'ex a ca'a a wusq'uinte u jel etel ti bele'ex a ca'a a quimseen etel tunich?— cu t'an a Jesus ti uchi u nuucu. ");
INSERT INTO mopNT_vpl VALUES ("JN10_33","073_10_33","JHN","10","33","33","—Bel ti ca'a ti p'up'uchch'inteech ma' u men etel a quich'pan meyaj a betaji. Bel ti ca'a ti p'up'uchch'inteech u men a maclant'antaj a Dioso. Incheche, cristianojech y tan a tz'eec a bajil jabixech Dios,— cu t'anoo' a nucuch winic ti'i a Jesusu. ");
INSERT INTO mopNT_vpl VALUES ("JN10_34","073_10_34","JHN","10","34","34","—“Diose'ex inche'exe,” cu t'an a Dioso. Baalo' ti tz'iiba'an ichil a ley a te'exe, le'ec u ju'um a Dioso,— cu t'an a Jesus ti uchi u nuuc. ");
INSERT INTO mopNT_vpl VALUES ("JN10_35","073_10_35","JHN","10","35","36","—Le'ec u ju'um a Dioso, ma' yan biqui ca' joc'oc ti tusil. Inene, tz'abi in muc', y tücaa'been wa'ye' yoc'olcab u men a Tattzili. Le'ec boon a tz'abi ti'ijoo' u t'an a Dioso, aalbi ti'ijoo' ti diosoo'. Tane'ex a wadic ti in maclant'antaj a Dios ca' in wadaj ti inen u Mejen a Dioso. ¿C'u' ca'a a wadaje'ex ti baalo'?— cu t'an a Jesusu. ");
INSERT INTO mopNT_vpl VALUES ("JN10_37","073_10_37","JHN","10","37","37","—Wa cuchi ma' tan in betic u meyaj in Tata, ma' cuchi qui' a tz'ocsiquene'ex,— cu t'an a Jesusu. ");
INSERT INTO mopNT_vpl VALUES ("JN10_38","073_10_38","JHN","10","38","38","—C'u' betiqui, tan in betic a meyaj abe'e. Ca'ax ma' a c'ate'ex a tz'ocseen yoc'lal in t'an, tz'ocseen yoc'lal a meyaj a walac in betiqui. Wa ca' a bete'ex ti baalo'o, bele'ex a ca'a a ch'aa' u tojil ti le'ec a Tattzili, jun quet in wetel y le'ec inene, jun queten etel a Tattzili,— cu t'an a Jesusu. ");
INSERT INTO mopNT_vpl VALUES ("JN10_39","073_10_39","JHN","10","39","39","U ca' yaaltajoo' u müchü' a Jesusu. C'u' betiqui, joq'ui tu yaamoo'. ");
INSERT INTO mopNT_vpl VALUES ("JN10_40","073_10_40","JHN","10","40","40","A Jesusu, bini junxeel a noja' Jordan tojil joq'ueeb q'uin tac tuba uchi u tz'aj ocja' aj Juan uchiji. Te'i culaji a Jesusu. ");
INSERT INTO mopNT_vpl VALUES ("JN10_41","073_10_41","JHN","10","41","41","Yaaboo' a c'ochoo' etele. —Le'ec aj Juana, ma' u betaj a milagroji. C'u' betiqui, tulacal c'u' u yadaj yoc'ol a Jesusu, jaj,— cu t'anoo'. ");
INSERT INTO mopNT_vpl VALUES ("JN10_42","073_10_42","JHN","10","42","42","Yaaboo' u tz'ajoo' u yool tu pach a Jesus te'iji. ");
INSERT INTO mopNT_vpl VALUES ("JN11_1","073_11_1","JHN","11","1","1","Pues te'i. Yan jun tuul a c'oja'ana, aj Lazaro u c'aba'. Betania u c'aba' u caal. Te'i ilic u caal ix Maria u yet'oc u quic ix Martaja. ");
INSERT INTO mopNT_vpl VALUES ("JN11_2","073_11_2","JHN","11","2","2","Le'ec ilic ix Maria abe'e, le'ec u toxaj a boc tu yoc a Noochtzil biq'uin ado'o. U cho'aj etel u tzo'otzel. Itz'intzil aj Lazaro u men ala'oo'o. ");
INSERT INTO mopNT_vpl VALUES ("JN11_3","073_11_3","JHN","11","3","3","Le'ecoo' ix Maria etel ix Martaja, u tücaa'tajoo' u pectzil ti'i a Jesusu. —Noochil, c'oja'an a winic a yaj a wu'yi,— cu t'anoo' ti'i. ");
INSERT INTO mopNT_vpl VALUES ("JN11_4","073_11_4","JHN","11","4","4","Le'ec ca' u yubaj abe' a Jesusu, u yadaj: —Le'ec u nu'cul a c'oja'anil abe'e, ma' ti'i u quimeebal aj Lazaroji. Chen u men a c'oja'anil abe'e, chictal u ca'a u muc' a Dioso. Bel ilic u ca'a ti chictal u muc' u Mejen a Dioso,— cu t'an a Jesusu. ");
INSERT INTO mopNT_vpl VALUES ("JN11_5","073_11_5","JHN","11","5","5","Pues te'i. Le'ec a Jesusu, yaj u yuboo' ix Marta etel ix Maria etel aj Lazarojo. ");
INSERT INTO mopNT_vpl VALUES ("JN11_6","073_11_6","JHN","11","6","6","Le'ec ca' u yubaj a Jesus ti c'oja'an ala'aji, ma' se' bini u yila'i. P'aati ilic te'i ulaac' ca' p'e q'uin. ");
INSERT INTO mopNT_vpl VALUES ("JN11_7","073_11_7","JHN","11","7","7","Mani a ca' p'e q'uini. —Co'ne'ex ich cuenta Judea tucaye'il,— cu t'an a Jesus ti'ijoo' u yaj cambala. ");
INSERT INTO mopNT_vpl VALUES ("JN11_8","073_11_8","JHN","11","8","8","—Maestro,— cu t'anoo' u yaj cambal ti'i. —Ti a q'uin a maniji, le'ecoo' a nucuch winiqui, u yaaltajoo' u p'up'uchch'inteech etel tunich y ¿tan wa a tuclic a ca' beel te'i tucaye'il?— cu t'anoo' ti'i. ");
INSERT INTO mopNT_vpl VALUES ("JN11_9","073_11_9","JHN","11","9","9","—Doce hora yan ichil a jujun p'e q'uini. Le'ec ti tan u ximbal a mac ti q'uini, ma' tu t'ochic u yoc u men chica'an u wich u men a q'uini,— cu t'an a Jesus ti uchi u nuuc. ");
INSERT INTO mopNT_vpl VALUES ("JN11_10","073_11_10","JHN","11","10","10","—C'u' betiqui, le'ec ti tan u ximbal ichil a ac'ü'ü, bel u ca'a u t'ocho' u yoc u men ma' chica'an u wich,— cu t'an a Jesusu. ");
INSERT INTO mopNT_vpl VALUES ("JN11_11","073_11_11","JHN","11","11","11","Le'ec ti jobi u yadic abe'e, u yadaj ti'ijoo' u yaj cambal: —Le'ec ti amigo Lazarojo, emi tun u wüyül. C'u' betiqui, bel in ca'a in wajes,— cu t'an a Jesus ti'ijoo'o. ");
INSERT INTO mopNT_vpl VALUES ("JN11_12","073_11_12","JHN","11","12","12","—Noochil, wa emi u wüyül, bel u ca'a ti ch'anül,— cu t'anoo' u yaj cambal ti'i. ");
INSERT INTO mopNT_vpl VALUES ("JN11_13","073_11_13","JHN","11","13","13","C'u' betic a Jesusu, u yadaj ti quimi, y ala'oo'o, u tuclajoo' ti chen tan u yadic ti uchi u wüyül. ");
INSERT INTO mopNT_vpl VALUES ("JN11_14","073_11_14","JHN","11","14","14","Pachili, chiclaji u t'an a Jesus ti'ijoo'o. —Quimen aj Lazarojo,— cu t'an ti'ijoo'. ");
INSERT INTO mopNT_vpl VALUES ("JN11_15","073_11_15","JHN","11","15","15","—Qui' in wool ti ma' que'enen te'i, yoc'ol mas qui' ca' joc'oc te'ex ti'i a mas tz'ocsiquene'ex. Co'ne'ex te'i,— cu t'an a Jesus ti'ijoo' u yaj cambala. ");
INSERT INTO mopNT_vpl VALUES ("JN11_16","073_11_16","JHN","11","16","16","—Co'ne'ex tu pach a Jesusu. Ti wetquimilac te'i,— cu t'an aj Tomas ti'ijoo' u chucaan u yaj cambala. Le'ec aj Tomasa, —C'uj,— cu t'anoo' ti'i. ");
INSERT INTO mopNT_vpl VALUES ("JN11_17","073_11_17","JHN","11","17","17","Pues te'i. Le'ec ti c'ochi te'i a Jesusu, u yubaj ti cuatro q'uin tun muucuc aj Lazarojo. ");
INSERT INTO mopNT_vpl VALUES ("JN11_18","073_11_18","JHN","11","18","18","Ma' naach tzeel Jerusalen que'en a caj Betaniaja, u caal a quimene. Jabix wal ox p'e kilometro u yaam. ");
INSERT INTO mopNT_vpl VALUES ("JN11_19","073_11_19","JHN","11","19","19","C'ochoo' sutinbil ix Marta etel ix Maria u menoo' u yetcaal a tala'anoo' Jerusalene. U c'atoo' u qui'cuntoo' u yool u men quimoo' u yitz'in. ");
INSERT INTO mopNT_vpl VALUES ("JN11_20","073_11_20","JHN","11","20","20","Le'ec ca' u yubaj ix Marta ti watac a Jesusu, bini u c'ümü'. Le'ec ix Mariaja, tina'an ilic ich naj. ");
INSERT INTO mopNT_vpl VALUES ("JN11_21","073_11_21","JHN","11","21","21","—Noochil, wa cuchi que'enech wa'ye'e, ma' cuchi quimi in witz'ini,— cu t'an ix Marta ti'i a Jesusu. ");
INSERT INTO mopNT_vpl VALUES ("JN11_22","073_11_22","JHN","11","22","22","—In weel ti tulacal c'u' a walac a c'aatic ti'i a Dioso, walac u tz'eec tech,— cu t'an ti'i a Jesusu. ");
INSERT INTO mopNT_vpl VALUES ("JN11_23","073_11_23","JHN","11","23","23","—Bel u ca'a ti ca' cuxtal a witz'in,— cu t'an a Jesus ti'iji. ");
INSERT INTO mopNT_vpl VALUES ("JN11_24","073_11_24","JHN","11","24","24","—In weel ti bel u ca'a ti liq'uil tu q'uinil u ca' cuxquinbil a quimen tu jobeeb a yoc'olcaba,— cu t'an ix Marta ti'iji. ");
INSERT INTO mopNT_vpl VALUES ("JN11_25","073_11_25","JHN","11","25","25","—Inen ilic bel in quin ca' cuxquinte a quimene. Le'ec mac a que'en u yool tin pacha, ca'ax quimic bel ilic u ca'a ti ca' cuxtal,— cu t'an a Jesusu. ");
INSERT INTO mopNT_vpl VALUES ("JN11_26","073_11_26","JHN","11","26","26","—Le'ec boon a cuxa'an a que'en u yool tin pacha, ma' yan q'uin u quimil jumpul. ¿Walac wa a tz'ocsic abe'e?— cu t'an a Jesus ti'i ix Martaja. ");
INSERT INTO mopNT_vpl VALUES ("JN11_27","073_11_27","JHN","11","27","27","—Walac Noochil. Walac in tz'ocsic ti le'ec incheche, le'ec u yaj Sa'alil a cristianojo. Le'ec incheche, le'ec u Mejen Dios a walac u yaalbül ti udel u ca'a wa'ye' yoc'olcaba,— cu t'an ix Marta ti'iji. ");
INSERT INTO mopNT_vpl VALUES ("JN11_28","073_11_28","JHN","11","28","28","Pues te'i. Le'ec ti jobi u yadic abe' ix Martaja, usc'aji tu pach u püyü' ix Mariaja. —Udi a Maestrojo. Tan u püyiquech,— cu t'an ti'i ich jisilt'an. ");
INSERT INTO mopNT_vpl VALUES ("JN11_29","073_11_29","JHN","11","29","29","Le'ec ca' u yubaj abe'e, liq'ui ti jomol. Bini u yila' a Jesusu. ");
INSERT INTO mopNT_vpl VALUES ("JN11_30","073_11_30","JHN","11","30","30","Ma'ax to ococ a Jesus ichil a caja. Que'en to te'i tuba p'ütbi u men ix Marta. ");
INSERT INTO mopNT_vpl VALUES ("JN11_31","073_11_31","JHN","11","31","31","Le'ecoo' u yaj sutil a tanoo' u chichcunaj-oolo, le'ec ca' u yilajoo' ti liq'ui ti jomol y bini pach naj ix Mariaja, binoo' tu pach. U tuclajoo' ti bel u ca'a u yoc'te a quimen tuba mucbi. ");
INSERT INTO mopNT_vpl VALUES ("JN11_32","073_11_32","JHN","11","32","32","Le'ec ti c'ochi ix Maria tuba que'en a Jesusu, xonlaji tu taan. —Noochil, wa cuchi que'enech wa'ye'e, ma' cuchi quimi in witz'in,— cu t'an ti'i. ");
INSERT INTO mopNT_vpl VALUES ("JN11_33","073_11_33","JHN","11","33","33","Le'ec a Jesusu, u yilaj ti tan u yoc'ol. Tanoo' ilic u yoc'ol boon aj Israel a que'enoo' tu pach ix Mariaja. Yajaji u yool u püsüc'al a Jesusu. ");
INSERT INTO mopNT_vpl VALUES ("JN11_34","073_11_34","JHN","11","34","34","—¿Tuba mucbi?— cu t'an a Jesusu. —Noochil, co'on a wila',— cu t'anoo' ti'i. ");
INSERT INTO mopNT_vpl VALUES ("JN11_35","073_11_35","JHN","11","35","35","Uchi u yoc'ol a Jesusu. ");
INSERT INTO mopNT_vpl VALUES ("JN11_36","073_11_36","JHN","11","36","36","—Ile'ex, top yaj u yubi a quimene,— cu t'anoo' aj sutil a que'enoo' tu pach ix Mariaja. ");
INSERT INTO mopNT_vpl VALUES ("JN11_37","073_11_37","JHN","11","37","37","—Ala'aji, u sasilcuntaj u wich a ch'oopo. ¿Ma' wa cuchi yan c'u' u betaj yoc'ol ma' cuchi quimi aj Lazarojo?— cu t'anoo' ulaac' aj Israel tu yaamoo'o. ");
INSERT INTO mopNT_vpl VALUES ("JN11_38","073_11_38","JHN","11","38","38","Pues te'i. C'ochi a Jesus tuba mucbi a quimene. Ca' yajaji u yool u püsüc'al tucaye'il. Naj tunich abe' tuba mucbi. C'üla'an u chi' etel noxi' tunich. ");
INSERT INTO mopNT_vpl VALUES ("JN11_39","073_11_39","JHN","11","39","39","—Joq'uese'ex a tunichi,— cu t'an a Jesusu. —Noochil, tu'uj tun u boc. Cuatro q'uin tun muucuc,— cu t'an ix Marta le'ec u quic a quimen ti'iji. ");
INSERT INTO mopNT_vpl VALUES ("JN11_40","073_11_40","JHN","11","40","40","—Ma' wa in wadaj tech wa que'en a wool tin pacha, bel a ca'a a wila' u muc' a Dioso,— cu t'an a Jesus ti'iji. ");
INSERT INTO mopNT_vpl VALUES ("JN11_41","073_11_41","JHN","11","41","41","U joc'sajoo' a tunichi. Le'ec a Jesusu, u cha'antaj a ca'ana. —Bo'tic Tat. A wu'yaj in t'an,— cu t'an a Jesusu. ");
INSERT INTO mopNT_vpl VALUES ("JN11_42","073_11_42","JHN","11","42","42","—In weel ti tulacal q'uin walac a wu'yic in t'an. C'u' betiqui, in wadaj abe' u menoo' a cristiano a que'enoo' wa'ye'e, ti'i ca' u tz'ocsoo' ti a tücaa'tajen,— cu t'an a Jesusu. ");
INSERT INTO mopNT_vpl VALUES ("JN11_43","073_11_43","JHN","11","43","43","Le'ec ti jobi u yadic abe'e, u yadaj ti chich: —Lazaro, liq'uen. Co'on,— cu t'an. ");
INSERT INTO mopNT_vpl VALUES ("JN11_44","073_11_44","JHN","11","44","44","Joq'ui a quimene. Büla'an u c'ü' u yoc etel noc'. Tepa'an u wich etel noc'. —Wüch'e'ex aj Lazarojo,— cu t'an a Jesus ti'ijoo'o. ");
INSERT INTO mopNT_vpl VALUES ("JN11_45","073_11_45","JHN","11","45","45","Pues te'i. Le'ecoo' aj Israel a tücünacoo' tu pach ix Mariaja, u yilajoo' c'u' u betaj a Jesusu. Yaaboo' tu yaam ala'oo'o, u tz'ajoo' u yool tu pach a Jesusu. ");
INSERT INTO mopNT_vpl VALUES ("JN11_46","073_11_46","JHN","11","46","46","C'u' betiqui, yan tu yaamoo' a binoo' etel a fariseo u c'aba'oo' u na'ata. U tzolajoo' ti'i c'u' u betaj a Jesusu. ");
INSERT INTO mopNT_vpl VALUES ("JN11_47","073_11_47","JHN","11","47","47","Pues te'i. Le'ecoo' u noochil u yaj mansaj t'an a cristiano ti'i a Dioso, u yet'ocoo' a fariseo u c'aba'oo' u na'ata, u yadajoo' ca' much'lacoo'. —¿C'u' a ca' ti bete'? Top walac u betic a milagro a winic abe'e,— cu t'anoo' tu bajil. ");
INSERT INTO mopNT_vpl VALUES ("JN11_48","073_11_48","JHN","11","48","48","—Wa ca' ti chaa' u mas betic ti baalo'o, tulacaloo' beloo' u cu tz'aa' u yool tu pach ala'aji. Jede'ec wal u tz'eec u bajil jabix rey. Pachili, watacoo' aj Romanojoo' tu c'asil. Beloo' u ca'a u jubu' ti cuuchil, le'ec u yotoch a Dioso. Beloo' ilic u ca'a u c'ascunte ti caal,— cu t'anoo' tu bajil. ");
INSERT INTO mopNT_vpl VALUES ("JN11_49","073_11_49","JHN","11","49","49","Pues te'i. Yan jun tuul tu yaamoo', aj Caifas u c'aba'. Ala'aji, mas nooch u wichil u meyaj tu yaamoo' u yaj mansaj t'an a cristiano ti'i a Dioso. —Inche'exe, ma'ax c'u' a weele'ex,— cu t'an ti'ijoo'. ");
INSERT INTO mopNT_vpl VALUES ("JN11_50","073_11_50","JHN","11","50","50","—Ma' wa chica'an te'ex ti mas qui' to'on ca' quimsabüc jun tuul a winic ti u jel a caj ti'i ma' u c'ascunbul tulacal a caja,— cu t'an aj Caifas ti'ijoo'o. ");
INSERT INTO mopNT_vpl VALUES ("JN11_51","073_11_51","JHN","11","51","51","Ma' chen tu junal u tuclaj abe'i. Tz'abi ti'i aj Caifas u men Dios ca' u yadü' abe'e, u men le'ec ala'i a mas nooch u wichil u meyaj tu yaamoo' u yaj mansaj t'an a cristiano ti'i a Dioso. Tanil u yadic abe'e, u yadaj c'u' a uchul u ca'aja. Le'ec a Jesusu, bel u ca'a ti quimil yoc'lal a caja. ");
INSERT INTO mopNT_vpl VALUES ("JN11_52","073_11_52","JHN","11","52","52","Ma' jadi' yoc'ol a caj bel u ca'a ti quimil. Bel u ca'a ti quimil ti'i ca' much'quinbic boon a ti'i a Dioso, le'ec a weca'anoo'o. ");
INSERT INTO mopNT_vpl VALUES ("JN11_53","073_11_53","JHN","11","53","53","Ti a q'uin abe'e, le'ecoo' a nucuch winiqui, cajoo' u tucle biqui ca' quimsabüc a Jesusu. ");
INSERT INTO mopNT_vpl VALUES ("JN11_54","073_11_54","JHN","11","54","54","Pues te'i. A Jesusu, u yeel c'u' u c'atoo' u bete', mentücü, ma' u ca' ye'aj u bajil ti tan u manül ich cuenta Judea. Joq'ui te'i. Bini ich caj Efrain. Tu chi' a p'atal lu'um que'en a caj abe'e. Culaji te'i u yet'ocoo' u yaj cambal. ");
INSERT INTO mopNT_vpl VALUES ("JN11_55","073_11_55","JHN","11","55","55","Pues te'i. Watac u q'uinil u fiestajoo' aj Israel le'ec ti tan u c'ajsabül biq'uin mani u yaj xa'num Dios ti ca'an yoc'oloo' uchi. Yaaboo' aj aldeajili, tanoo' u paye' beel ich Jerusalen le'ec ti ma'ax to c'ochoc u q'uinil a fiestaja. Tanoo' u paye' beel ti'i ca' u yutzquintoo' u bajil jabix ti sucoo' u bete' ti'i ca' paatac u yiloo' a fiestaja. ");
INSERT INTO mopNT_vpl VALUES ("JN11_56","073_11_56","JHN","11","56","56","Ala'oo'o, chen tu qui'il tanoo' ilic u cüxtic tuba que'en a Jesusu. Tanoo' u c'aatic tu bajil ichil u yotoch a Dioso. —¿Biqui'il a tucule'ex? ¿Jede'ec wa u talel ti a fiestaja?— cu t'anoo' a taloo' ich aldea tu bajili. ");
INSERT INTO mopNT_vpl VALUES ("JN11_57","073_11_57","JHN","11","57","57","Pues te'i. Le'ecoo' u noochil u yaj mansaj t'an a cristiano ti'i Dios u yet'ocoo' a fariseo u c'aba'oo' u na'ata, u tz'ajoo' a leye. —Wa yan mac u yeel tuba que'en ala'aji, yan u talel u tzoloo',— cu t'anoo'. Ti baalo'o, bel u ca'a müchbül. ");
INSERT INTO mopNT_vpl VALUES ("JN12_1","073_12_1","JHN","12","1","1","Pues te'i. Seis q'uin to u beel ca' c'ochoc u q'uinil u fiestajoo' aj Israel le'ec ti tan u c'ajsabül biq'uin mani u yaj xa'num Dios ti ca'an yoc'oloo' uchi. C'ochi a Jesus ich caj Betania, le'ec u caal aj Lazarojo, le'ec ilic a cuxquinbi tu yaamoo' a quimen u men a Jesus biq'uin ado'o. ");
INSERT INTO mopNT_vpl VALUES ("JN12_2","073_12_2","JHN","12","2","2","U tz'ajoo' a janal yoc'lal a Jesus u men u qui'iloo' u yool. Ix Marta, u t'oxaj a janala. Le'ec aj Lazarojo, que'en pach mesa tu yaamoo' le'ec tuba que'en a Jesusu. ");
INSERT INTO mopNT_vpl VALUES ("JN12_3","073_12_3","JHN","12","3","3","Le'ec ix Mariaja, u talesaj jabix jun p'e libra a boco. Nardo u c'aba' a boco. Ma' yan u xaab. Co'oj abe'e. U tz'aj a boc yoc'ol u yoc a Jesusu. U cho'aj u yoc etel u tzo'otzel. Top jüc'ünac u boc a boc ichil a naja. ");
INSERT INTO mopNT_vpl VALUES ("JN12_4","073_12_4","JHN","12","4","4","Pues te'i. Jun tuul u yaj cambal a Jesusu, aj Judas Iscariote u c'aba'. Aj Simon u c'aba' u tat. Bel u ca'a u tzolo' a Jesus aj Judasa. ");
INSERT INTO mopNT_vpl VALUES ("JN12_5","073_12_5","JHN","12","5","5","—Mas qui' cuchi wa cuchi conbi a boc ada' yoc'ol tres ciento p'eel ti taq'uin le'ec u muc' a tres ciento q'uin ti meyaj, y tz'abi cuchi u tool ti'ijoo' a otzili,— cu t'an aj Judasa. ");
INSERT INTO mopNT_vpl VALUES ("JN12_6","073_12_6","JHN","12","6","6","Ma' u yadaj u men u qui'il ti'i a otzili. U yadaj u men aj xuuch' ala'aji. Ala'aji, u yaj cananil u bolsajil a taq'uin ti'ijoo' a Jesus y u chucaan u yaj cambala. Walac u xuuch'tic u ba'al. ");
INSERT INTO mopNT_vpl VALUES ("JN12_7","073_12_7","JHN","12","7","7","—P'ütü a wadic abe' yoc'ol a boco. U tz'aj a boc ada' tin woc'ol aleebe, bete cuenta u paye' tz'aj tin woc'ol ti'i in mucbeeb,— cu t'an a Jesusu. ");
INSERT INTO mopNT_vpl VALUES ("JN12_8","073_12_8","JHN","12","8","8","—Tulacal q'uin yan a otzil wa'ye'e. C'u' betiqui, ma' jumpul que'enen ta yaame'ex jabix ti que'enen aleebe,— cu t'an a Jesusu. ");
INSERT INTO mopNT_vpl VALUES ("JN12_9","073_12_9","JHN","12","9","9","Pues te'i. Le'ec ti ca' u yubajoo' ti que'en ich Betania a Jesusu, c'ochoo' ti yaab a que'en ich Jerusalen etel. Ma' jadi' u men a Jesus c'ochoo' u yila'i. C'ochoo' ilic u yila' aj Lazaro, le'ec a ca' cuxquinbi tu yaamoo' a quimene. ");
INSERT INTO mopNT_vpl VALUES ("JN12_10","073_12_10","JHN","12","10","10","Le'ecoo' u noochil u yaj mansaj t'an a cristiano ti'i a Dioso, u yadajoo' tu bajil ca' quimsabüc aj Lazaro etel a Jesusu. ");
INSERT INTO mopNT_vpl VALUES ("JN12_11","073_12_11","JHN","12","11","11","U c'atoo' u quimes aj Lazaro chen u men yoc'lal ala'aji, yaaboo' aj Israele, tanoo' u p'ütic a uchbene. Tanoo' u tz'eec u yool tu pach a Jesusu. ");
INSERT INTO mopNT_vpl VALUES ("JN12_12","073_12_12","JHN","12","12","12","Pues te'i. Tu samalil, yaaboo' a cristiano a c'ochoo' tun ti fiesta ich Jerusalen, u yubajoo' ti watac a Jesusu. ");
INSERT INTO mopNT_vpl VALUES ("JN12_13","073_12_13","JHN","12","13","13","U ch'ücajoo' u c'ü' a che' a jabix u le' ch'ibi. Binoo' u c'ümü'. —Top qui' a Dioso,— cu t'anoo' ti chich. —Ti c'ati a Dios ca' u tz'aa' u qui'il u yool u yaj tücaa', le'ec a tan to u yudel. Ala'aji, u reyoo' aj Israele,— cu t'anoo' ti chich. ");
INSERT INTO mopNT_vpl VALUES ("JN12_14","073_12_14","JHN","12","14","14","Le'ec a Jesusu, u cüxtaj aj tz'i' tzimini. Naq'ui tu pach jabix ilic ti tz'iiba'an ichil u ju'um a Dioso. ");
INSERT INTO mopNT_vpl VALUES ("JN12_15","073_12_15","JHN","12","15","15","—Ma' u beel ti jac'üle'ex a wool caj Sion. Ile'ex a rey. Watac. Tinca'al pach tz'i' tzimin,— cu t'an a t'an a tz'iiba'an ichil u ju'um a Dioso. ");
INSERT INTO mopNT_vpl VALUES ("JN12_16","073_12_16","JHN","12","16","16","Payanbej ma' u ch'a'ajoo' u tojil abe' u yaj cambaloo'o. C'u' betiqui, le'ec ti bini ti ca'an a Jesusu, c'ajoo' ti'i ti tz'iiba'an ichil u ju'um Dios ti bel u ca'a ti nac'ül pach tz'i' tzimin jabix ilic ti ca' u betaj biq'uin ado'o. ");
INSERT INTO mopNT_vpl VALUES ("JN12_17","073_12_17","JHN","12","17","17","Pues te'i. Biq'uin ado'o, le'ec ti ca' cuxquinbi tucaye' aj Lazarojo, yaaboo' a cristianojo, que'enoo' tu pach a Jesusu. Ala'oo'o, u wecajoo' u pectzil c'u' u betaj a Jesus ti'i aj Lazarojo. ");
INSERT INTO mopNT_vpl VALUES ("JN12_18","073_12_18","JHN","12","18","18","Le'ecoo' u yaabil a cristiano abe' a binoo' u c'ümü' a Jesusu, binoo' u c'ümü' u men u yubajoo' c'u' u betaj a Jesus biq'uin ado'o. ");
INSERT INTO mopNT_vpl VALUES ("JN12_19","073_12_19","JHN","12","19","19","Le'ecoo' a fariseo u c'aba'oo' u na'ata, le'ec ca' u yilajoo' u beeloo' a cristianojo, cajoo' ti tzicbal tu bajil. —Tan u joc'ol to'on ti ma'ax c'u' a jede'ec u paatal ti betic ca'ax boon ti yaaltic ti wet'e' u meyaj a Jesusu. Ile'ex, tulacal a cristiano yoc'olcaba, binoo' tu pach a Jesusu,— cu t'anoo' tu bajil. ");
INSERT INTO mopNT_vpl VALUES ("JN12_20","073_12_20","JHN","12","20","20","Pues te'i. Yanoo' aj Griego tu yaamoo' boon a binoo' u c'ajes a Dios ti a fiesta ich caj Jerusalen. ");
INSERT INTO mopNT_vpl VALUES ("JN12_21","073_12_21","JHN","12","21","21","C'ochoo' ala'oo' etel aj Felipeje, le'ec jun tuul u yaj cambal a Jesusu. Betsaida ich cuenta Galilea u caal aj Felipeje. —Noochwinic, ti c'ati ti chiite a Jesusu,— cu t'anoo' ti'i aj Felipeje. ");
INSERT INTO mopNT_vpl VALUES ("JN12_22","073_12_22","JHN","12","22","22","Aj Felipeje, bini u yadü' ti'i aj Andres. Binoo' a ca' tuul u yadü' ti'i a Jesusu. ");
INSERT INTO mopNT_vpl VALUES ("JN12_23","073_12_23","JHN","12","23","23","—Inene, yanajeen ti cristianojil. C'ochi u yorajil in wocol ichil in meyaj a top nooch u wichil u yanili,— cu t'an a Jesus ti uchi u nuucu. ");
INSERT INTO mopNT_vpl VALUES ("JN12_24","073_12_24","JHN","12","24","24","—Bel in qiun wadü' te'ex u jajil. Le'ec u semilla a harinaja, yan u püc'bül ichil a lu'um jabix quimene. Wa ma'a, jadi' jun cuul ilic tu p'aatül. C'u' betiqui, wa ca' püc'bücü, bel u cu tz'aa' u wich,— cu t'an ti'ijoo'. ");
INSERT INTO mopNT_vpl VALUES ("JN12_25","073_12_25","JHN","12","25","25","—Le'ec mac a mas yaj u yubi u cuxtal wa'ye' yoc'olcab tin wichi, bel u ca'a ti sa'tül ti'i a cuxtal a ma' yan q'uin u jobol. Le'ec mac a ma' tan u yacuntic u cuxtal wa'ye' yoc'olcab tin woc'lala, tan u cününtic u cuxtal a ma' yan q'uin u jobolo,— cu t'an a Jesusu. ");
INSERT INTO mopNT_vpl VALUES ("JN12_26","073_12_26","JHN","12","26","26","—Le'ec mac u c'ati u bete' in meyaja, yan u tz'ocsic in t'an. Ti baalo'o, le'ec tuba in beel inene, te'i ilic u beel in waj anatil le'ec ca' c'ochoc u q'uinil. Le'ec mac walac u yaantiquene, bel u ca'a aantabül u men in Tat,— cu t'an a Jesusu. ");
INSERT INTO mopNT_vpl VALUES ("JN12_27","073_12_27","JHN","12","27","27","—Pues te'i. Aleebe ma' jetz'a'an in wooli. ¿C'u' a ca' in wadü'ü? ¿Qui' wa ca' in wadü' a jabix ada'a?: “Tat, sa'alteen ti'i ma' in c'ümic c'u' a watac tin woc'ol aleebe.” Ma' qui' ca' in wadü' ti baalo' u men taleen ti'i ca' in c'ümü' c'u' a watac tin woc'ol aleebe,— cu t'an a Jesusu. ");
INSERT INTO mopNT_vpl VALUES ("JN12_28","073_12_28","JHN","12","28","28","—Tat, ye'e biqui'il a muc' ti'ijoo',— cu t'an a Jesusu. Pachili, u yubajoo' jun p'eel a t'an a tan u talel ti ca'ana. —In ye'aj biqui'il in muc' biq'uin ado'o, y bel in quin yee' biqui'il in muc' tucaye'il,— cu t'an a t'an abe'e. ");
INSERT INTO mopNT_vpl VALUES ("JN12_29","073_12_29","JHN","12","29","29","Le'ec boon u yaabil a que'en te'iji, u yubajoo' a t'an abe'e. —Uchi u peec a chaaca,— cu t'anoo'. —Jun tuul u yaj xa'num a Dios ti ca'ana, uchi u t'an etel a Jesusu,— cu t'anoo' ulaac'. ");
INSERT INTO mopNT_vpl VALUES ("JN12_30","073_12_30","JHN","12","30","30","—Uchi u peec a t'an abe' ti'i ca' a wu'ye'ex, ma' ti'i ca' in wu'yi inene,— cu t'an a Jesusu. ");
INSERT INTO mopNT_vpl VALUES ("JN12_31","073_12_31","JHN","12","31","31","—Aleebe c'ochi u yorajil ca' chiclac boon a qui' u yool etel a sip'il wa'ye' yoc'olcab. Aleebe caal u ca'a joc'sabül a quisin a walac u tücaa' ichil a yoc'olcaba,— cu t'an a Jesusu. ");
INSERT INTO mopNT_vpl VALUES ("JN12_32","073_12_32","JHN","12","32","32","—Inene, le'ec ti tz'abüquen tuwich a cruzu, bel in quin wadü' ichil u püsüc'al tulacal a cristiano ca' u tz'a'oo' u yool tin pach,— cu t'an a Jesusu. ");
INSERT INTO mopNT_vpl VALUES ("JN12_33","073_12_33","JHN","12","33","33","U yadaj abe' ti'i ca' chiclac ti bel u ca'a quimsabül tuwich cruz. ");
INSERT INTO mopNT_vpl VALUES ("JN12_34","073_12_34","JHN","12","34","34","Uchi u nuuc u yaabil a cristianojo. —Ichil u ju'um a Dioso, ti cünaj ti le'ec u yaj Sa'alil a cristianojo, cuxa'an jumpul. Ma' tu quimil. ¿C'u' ca'a tan a wadic ti le'ec abe' a yanaji ti cristianojili, yan u tz'abül tuwich cruz ti'i ca' quimsabüc? ¿Mac abe' a yanaji ti cristianojil a tan a wadiqui?— cu t'an u yaalbül a Jesusu. ");
INSERT INTO mopNT_vpl VALUES ("JN12_35","073_12_35","JHN","12","35","35","—Le'ec mac a walac u tojquinaj na'at jabix a sasili, jun p'e rato ilic bel u ca'a ti cuntal ta yaame'ex. Yan a tz'ocsique'ex ala'i le'ec ti que'en to ta yaame'ex ti'i ma' u yocol te'ex jabix a ac'ü'ü. Le'ec mac a tan u manül ichil a ac'ü'ü, ma' u yeel tuba tan u beel,— cu t'an a Jesusu. ");
INSERT INTO mopNT_vpl VALUES ("JN12_36","073_12_36","JHN","12","36","36","—Tz'aje'ex a wool tu pach a sasil abe' le'ec ti que'en to ta yaame'exe. Ti baalo'o, p'aatüle'ex a ca'a jabix u yet'oque'ex a sasil abe'e,— cu t'an a Jesusu. Pues te'i. Le'ec ti jobi u yadic abe' a Jesusu, joq'ui te'i. U mucaj u bajil tuwichoo'. ");
INSERT INTO mopNT_vpl VALUES ("JN12_37","073_12_37","JHN","12","37","37","Ca'ax boon a milagro u betaj tu taanoo' ala'oo'o, ma' u tz'ajoo' u yool tu pach ala'aji. ");
INSERT INTO mopNT_vpl VALUES ("JN12_38","073_12_38","JHN","12","38","38","Jabix ilic u yadaj aj Isaiasa, le'ec jun tuul u yadaj u t'an a Dios uchiji, baalo' ilic u betajoo'o. —Noochil, ma'ax mac u tz'ocsaj a pectzil ti wadaja. Ma'ax mac u ch'a'aj u tojil c'u' u betaj a Noochtzili,— cu t'an aj Isaiasa. ");
INSERT INTO mopNT_vpl VALUES ("JN12_39","073_12_39","JHN","12","39","39","Tz'iiba'an tun ti baalo', mentücü, ma' tu paataloo' u tz'oques. Yan ulaac' a tz'iiba'an u men aj Isaiasa. ");
INSERT INTO mopNT_vpl VALUES ("JN12_40","073_12_40","JHN","12","40","40","—Le'ec a Dioso, u betaj jabix u ch'oopquintajoo' u wich a cristianojo. U tz'aj ti chichoo' u pol ti'i ma' u ch'a'icoo' u tojil a c'u' a tanoo' u yiliqui, ma'ax u tojil a c'u' a tanoo' u yubiqui. Ti baalo', ma' tu tz'eecoo' u yool tu pach ti'i ca' aantabücoo',— cu t'an a t'an u tz'iibtaj aj Isaiasa. ");
INSERT INTO mopNT_vpl VALUES ("JN12_41","073_12_41","JHN","12","41","41","Le'ec aj Isaiasa, u yadaj abe' u men ac u yilaj ich jabix nümül u muc' a Jesusu, y u tzicbaltaj ilic ala'i uchi. ");
INSERT INTO mopNT_vpl VALUES ("JN12_42","073_12_42","JHN","12","42","42","Ca'ax baalo' ti tz'iiba'an, yanoo' aj Israel u yet'ocoo' a nucuch winiqui, u tz'ajoo' u yool tu pach a Jesusu. C'u' betiqui, ma' ta'achoo' u yadic ti walacoo' u tz'ocsic a Jesus u men saacoo' ti'i a fariseo u c'aba'oo' u na'at ca' joc'sabücoo' jumpul ichil u yotoch a Dioso. ");
INSERT INTO mopNT_vpl VALUES ("JN12_43","073_12_43","JHN","12","43","43","Top tanoo' u tuclic c'u' a tan u yadic a cristianojo, mentücü, tanoo' u tz'ocsic a Dios ich mucul. Ma' tanoo' u tuclic wa jabix bel u ca'a aalbül u qui'il u men a Diosi. ");
INSERT INTO mopNT_vpl VALUES ("JN12_44","073_12_44","JHN","12","44","44","Pues te'i. —Le'ec mac a que'en u yool tin pach inene, que'en ilic u yool tu pach mac u tücaa'tajen,— cu t'an a Jesus ti chichi. ");
INSERT INTO mopNT_vpl VALUES ("JN12_45","073_12_45","JHN","12","45","45","—Le'ecoo' mac tanoo' u cha'antiquene, ma' jadi' inen a tanoo' u cha'antiqui. Tanoo' ilic u cha'antic mac u tücaa'tajen,— cu t'an a Jesus ti chichi. ");
INSERT INTO mopNT_vpl VALUES ("JN12_46","073_12_46","JHN","12","46","46","—Udeen wa'ye' yoc'olcab ti'i ca' in sasilcunte u na'at a maca. Le'ec mac a que'en u yool tin pacha, ma' tu cuntal u na'at ichil a ac'ü'ü,— cu t'an a Jesus ti chichi. ");
INSERT INTO mopNT_vpl VALUES ("JN12_47","073_12_47","JHN","12","47","47","—C'u' betiqui, wa yan mac a tan u yubic in t'an, pero ma' u c'ati u tz'oquese, ma' ac tan ilic in tz'eec ichil u sip'ili. Udeen ma' ti'i in tz'eecal a cristiano yoc'olcab ichil u sip'ili. Udeen ti'i ca' in sa'alte a cristiano yoc'olcaba,— cu t'an a Jesus ti chichi. ");
INSERT INTO mopNT_vpl VALUES ("JN12_48","073_12_48","JHN","12","48","48","—Le'ec mac ma' u c'ati u c'üm-oolteene, y ma'ax u c'ati u tz'oques in t'ana, yan u tz'abül ichil u sip'il ala'aji. Le'ec boon a t'an in wadaja, le'ec bel u cu tz'a' u sip'il tu yada' a yoc'olcaba,— cu t'an a Jesus ti chichi. ");
INSERT INTO mopNT_vpl VALUES ("JN12_49","073_12_49","JHN","12","49","49","—Baalo' ti yan u men le'ec a Tattzili, u tücaa'tajen. Le'ec, u yadaj ten c'u' a quin wadü'ü. Ma' etel in muc' inen a tan in wadiqui,— cu t'an a Jesus ti chichi. ");
INSERT INTO mopNT_vpl VALUES ("JN12_50","073_12_50","JHN","12","50","50","—Jadi' walac in wadic a c'u' u c'ati a Tattzil ca' in wadü'ü, u men in weel ti le'ec a Tattzili, u tz'aj u muc' u t'an. Etel u t'an yan u muc' ti'i u tz'eec a cuxtal a ma' yan q'uin u jobolo,— cu t'an a Jesus ti chichi. ");
INSERT INTO mopNT_vpl VALUES ("JN13_1","073_13_1","JHN","13","1","1","Pues te'i. Nütz'ünac u c'ochol u q'uinil u fiestajiloo' aj Israel le'ec ti walac u c'ajsabül biq'uin mani u yaj xa'num Dios ti ca'an yoc'oloo' uchi. Le'ec a Jesusu, u yeel ti c'ochi u yorajil u joc'ol yoc'olcab ca' xi'ic etel a Tattzili. Yaj u yuboo' boon a mac a que'enoo' u yool tu pach ala'aji, le'ec a que'enoo' wa'ye' yoc'olcaba. C'ochi u yorajil u ye'icoo' ti'ijoo' ti top yaj u yuboo'. ");
INSERT INTO mopNT_vpl VALUES ("JN13_2","073_13_2","JHN","13","2","2","Pues te'i. Le'ec a Jesus u yet'ocoo' u yaj cambala, tanoo' u janal ti a ocq'uini. Le'ec aj Judas Iscarioteje, u mejen aj Simon. Tz'abi tun ichil u pol u men a quisin ca' u tzolo' a Jesusu. ");
INSERT INTO mopNT_vpl VALUES ("JN13_3","073_13_3","JHN","13","3","3","Pues te'i. Le'ec a Jesusu, u yeel ti tz'abi ichil u c'ü' u men a Tattzil tulacal a c'u' a yana. U yeel ti te'i tali etel a Dioso. U yeel ilic ti ca' bel u ca'a etel a Dioso. ");
INSERT INTO mopNT_vpl VALUES ("JN13_4","073_13_4","JHN","13","4","4","Pues te'i. Tanoo' to u janal ti a ocq'uini. Joq'ui a Jesus tu chi' a mesaja. U joc'saj jun yaal u noc'. Xit'a'an a toalla ca' u c'üxaj tu nüc' ti'i ma' u bonic u noc'. ");
INSERT INTO mopNT_vpl VALUES ("JN13_5","073_13_5","JHN","13","5","5","U toxaj a ja' ichil a palanganaja. Caji u p'o'oo' u yoc u yaj cambal. Caji u choo' u yocoo' etel a toalla a c'üxa'an tu nüc'ü. ");
INSERT INTO mopNT_vpl VALUES ("JN13_6","073_13_6","JHN","13","6","6","Naatz'i tu tzeel aj Simon Pedrojo. —Noochil, ¿bel wa a ca'a a p'oo' in woc?— cu t'an aj Pedro ti'iji. ");
INSERT INTO mopNT_vpl VALUES ("JN13_7","073_13_7","JHN","13","7","7","—Ma' a weel c'u' a tan in betic aleebe. C'u' betiqui, mas pachili, bel a ca'a a ch'aa' u tojil,— cu t'an a Jesus ti uchi u nuuc. ");
INSERT INTO mopNT_vpl VALUES ("JN13_8","073_13_8","JHN","13","8","8","—Ma' yan q'uin a p'o'ic in woc,— cu t'an aj Pedro ti'iji. —Wa ma' tin p'o'iqui, ma' ta p'aatül tin wet'oquech,— cu t'an a Jesus ti'iji. ");
INSERT INTO mopNT_vpl VALUES ("JN13_9","073_13_9","JHN","13","9","9","—Noochil, ma' jadi' in woc a ca' a p'oo'i. P'o' in c'ü' y p'o' in pol,— cu t'an aj Simon Pedro yoc'lal ca' culac ti'i u yet'oc. ");
INSERT INTO mopNT_vpl VALUES ("JN13_10","073_13_10","JHN","13","10","10","—Le'ec a ucha'an u ichquili, jadi' u yoc a yan u ca' p'o'bolo. U noochili, ac p'o'a'an. Inche'exe, ucha'ane'ex a wichquil. Ma' yan a c'as ta woc'ole'exe, pero ma' tulacale'exi,— cu t'an a Jesusu. ");
INSERT INTO mopNT_vpl VALUES ("JN13_11","073_13_11","JHN","13","11","11","U yadaj ti ma' tulacaloo' a ma' yan c'as yoc'oloo', u men u yeel mac a bel u ca'a ti tzolo. ");
INSERT INTO mopNT_vpl VALUES ("JN13_12","073_13_12","JHN","13","12","12","Pues te'i. Jobi u p'o'boloo' u yoc u men a Jesusu. Le'ec a Jesusu, u tz'aj u noc' tucaye'il. Ca' bini pach mesa tucaye'. —¿A ch'a'aje'ex wa u tojil c'u' in betaj to te'exe?— cu t'an a Jesus ti'ijoo'o. ");
INSERT INTO mopNT_vpl VALUES ("JN13_13","073_13_13","JHN","13","13","13","—“Maestro wa Noochil,” que'ex ten. Qui' ti walaque'ex a wadic ti baalo' u men jaj,— cu t'an a Jesusu. ");
INSERT INTO mopNT_vpl VALUES ("JN13_14","073_13_14","JHN","13","14","14","—Inen a Noochile'ex. Inen a Maestroje'ex. C'u' betiqui, in p'o'aje'ex a woc. Yan ilic a p'o'ique'ex a woc ta bajile'ex. ");
INSERT INTO mopNT_vpl VALUES ("JN13_15","073_13_15","JHN","13","15","15","Abe'e, u p'is in betaj te'ex ti'i ca' a waante'ex a bajil biqui ca' culaque'ex. Ca' a bete'ex ta bajil a jabix ilic in betaj te'exe,— cu t'an a Jesusu. ");
INSERT INTO mopNT_vpl VALUES ("JN13_16","073_13_16","JHN","13","16","16","—Tan in wadic te'ex u jajil. Le'ec a tz'ulili, mas nooch u wichil u meyaj tuwich u yaj meyaj. Le'ec a tan u tücaa'a, mas nooch u wichil u meyaj tuwich u yaj tücaa',— cu t'an a Jesusu. ");
INSERT INTO mopNT_vpl VALUES ("JN13_17","073_13_17","JHN","13","17","17","—Aleebe a weele'ex abe'e. Wa ca' a tz'ocse'ex abe'e, p'aatüle'ex a ca'a ti qui'e'ex a wool,— cu t'an a Jesusu. ");
INSERT INTO mopNT_vpl VALUES ("JN13_18","073_13_18","JHN","13","18","18","—Pues te'i. Tan in wadic te'ex abe'e, pero ma' ti'i tulacale'exi,— cu t'an a Jesus ti'ijoo' a doce tuulu. —In weele'ex ti qui' biqui yanile'ex a püsüc'al. In yeetaje'ex. C'u' betiqui, yan u yuchul c'u' a tz'iiba'an ichil u ju'um a Dioso. “Le'ec in wetjanala, le'ec u tzolajen.” Baalo' ti tz'iiba'an ichil u ju'um a Dioso,— cu t'an a Jesusu. ");
INSERT INTO mopNT_vpl VALUES ("JN13_19","073_13_19","JHN","13","19","19","—Tan in wadic te'ex abe'e, pero ma'ax to tzolboquen. Le'ec ca' a wile'ex u yuchul abe'e, bele'ex a ca'a a mas tz'oques ti inen u yaj Sa'alil a cristianojo,— cu t'an. ");
INSERT INTO mopNT_vpl VALUES ("JN13_20","073_13_20","JHN","13","20","20","—Tan in wadic te'ex u jajil. Le'ec mac tan u c'ümic u t'an a mac a tan in tücaa'tiqui, tan ilic u c'ümiquen. Tanil u c'ümiquene, tan ilic u c'ümic mac u tücaa'tajen,— cu t'an a Jesusu. ");
INSERT INTO mopNT_vpl VALUES ("JN13_21","073_13_21","JHN","13","21","21","Pues te'i. Le'ec ti jobi u yadü' abe' a Jesusu, ma' jetz'a'an u yooli. —Tan in wadic te'ex u jajil. Jun tuul ta yaame'ex, bel u ca'a u tzoleen,— cu t'an a Jesusu. ");
INSERT INTO mopNT_vpl VALUES ("JN13_22","073_13_22","JHN","13","22","22","Le'ecoo' u yaj cambala, u cha'antajoo' u bajil. Ma' u yeeloo' mac tu yaamoo' a tan u yadic a Jesusu. ");
INSERT INTO mopNT_vpl VALUES ("JN13_23","073_13_23","JHN","13","23","23","Pues te'i. Jun tuul u yaj cambal a top yajtzil u men a Jesusu, que'en tu tzeel ti janal. ");
INSERT INTO mopNT_vpl VALUES ("JN13_24","073_13_24","JHN","13","24","24","Le'ec aj Simon Pedrojo, etel u c'ü' u püyaj a yajtzili. —Caate ti'i mac a bel u ca'a ti tzolo,— cu t'an ti'i. ");
INSERT INTO mopNT_vpl VALUES ("JN13_25","073_13_25","JHN","13","25","25","Naatz'i tu tzeel a Jesus a yajtzil abe'e. —Noochil, ¿mac abe'e?— cu t'an ti'i. ");
INSERT INTO mopNT_vpl VALUES ("JN13_26","073_13_26","JHN","13","26","26","—Bel in quin tzümü' a jun choc' a janal ada'a. Le'ec mac ti'i in tz'eeque, le'ec,— cu t'an a Jesusu. Le'ec ti ca' u betaj abe'e, u tz'aj ti'i aj Judas Iscariote u mejen aj Simon. ");
INSERT INTO mopNT_vpl VALUES ("JN13_27","073_13_27","JHN","13","27","27","Le'ec ca' u c'ümaj a janal aj Judasa, oqui aj Satanas ichil u yoolo. —Bete ti jomol c'u' a bel a ca'a a bete'e,— cu t'an a Jesus ti'iji. ");
INSERT INTO mopNT_vpl VALUES ("JN13_28","073_13_28","JHN","13","28","28","Le'ecoo' a que'en pach mesaja, ma' u yeeloo' c'u' ca'a ti aalbi ti'i ti baalo'. ");
INSERT INTO mopNT_vpl VALUES ("JN13_29","073_13_29","JHN","13","29","29","Aj taac' taq'uin aj Judasa, mentücü, yan tu yaamoo' u tuclajoo' ti uchac tücaa'bi u q'uexe' c'u' a c'abeet ti'ijoo' ti'i a fiestaja. Yanoo' ulaac' u tuclajoo' ti uchac tücaa'bi ca' u siji' c'u'ac ti'i a otzili. ");
INSERT INTO mopNT_vpl VALUES ("JN13_30","073_13_30","JHN","13","30","30","Jadi' u c'ümaj a janal ti joq'ui te'i aj Judasa. Oqui tun a ac'ü'ü. ");
INSERT INTO mopNT_vpl VALUES ("JN13_31","073_13_31","JHN","13","31","31","Pues te'i. Le'ec ti joq'ui aj Judasa, caji ti t'an a Jesusu. —Inene, yanajeen ti cristianojil. Aleebe bel u ca'a ilbil in muc' le'ec ti joc'oquen wa'ye' yoc'olcab. Bel ilic u ca'a ti chictal u muc' a Dios in men inene,— cu t'an a Jesusu. ");
INSERT INTO mopNT_vpl VALUES ("JN13_32","073_13_32","JHN","13","32","32","—U men bel in quin yee' u muc' a Dioso, le'ec ilic a Dioso, bel u cu yee' in muc'. Bel u ca'a u yee' ti jomol,— cu t'an a Jesusu. ");
INSERT INTO mopNT_vpl VALUES ("JN13_33","073_13_33","JHN","13","33","33","—Pues te'i. Inche'exe, jabixe'ex in mejene. Inene, ma' xantal in ca'a ta yaame'exi. Bele'ex a ca'a a yaalte a cüxteen. Jabix ilic in wadaj ti'ijoo' ti wetcaal aj Israele, baalo' ilic yan in wadic te'ex. Le'ec tuba in beele, ma' tu paatale'ex a beel,— cu t'an a Jesus ti'ijoo' u yaj cambala. ");
INSERT INTO mopNT_vpl VALUES ("JN13_34","073_13_34","JHN","13","34","34","—Bel in quin tz'aa' te'ex ulaac' a ley a tumulben tojo. Le'ec a ley abe'e, yacunte'ex a bajil. Jabix ilic ca' in yacuntaje'exe, baalo' ilic yan a yacuntique'ex a bajil,— cu t'an a Jesusu. ");
INSERT INTO mopNT_vpl VALUES ("JN13_35","073_13_35","JHN","13","35","35","—Wa ca' a yacunte'ex a bajil ta bajile'exe, tulacaloo' a cristianojo, beloo' u cu yeelte ti le'ec inche'exe, le'ec in waj cambale'ex,— cu t'an a Jesusu. ");
INSERT INTO mopNT_vpl VALUES ("JN13_36","073_13_36","JHN","13","36","36","Pues te'i. —Noochil, ¿tuba bel a ca'a?— cu t'an aj Simon Pedro ti uchi u nuuc. —Le'ec tuba in beel inene, ma' tu paatal a beel tin pach aleebe. C'u' betiqui, mas pachil bel a ca'a tin pach,— cu t'an a Jesusu. ");
INSERT INTO mopNT_vpl VALUES ("JN13_37","073_13_37","JHN","13","37","37","—Noochil, ¿c'u' ca'a ma' tin paatal in beel ta pach aleebe? Ca'ax quimiquen ta woc'lal, listojen,— cu t'an aj Pedrojo. ");
INSERT INTO mopNT_vpl VALUES ("JN13_38","073_13_38","JHN","13","38","38","—Ma' bel a ca'a a tz'aa' a bajil ti quimsabül tin woc'oli,— cu t'an a Jesusu. —Tan in wadic tech u jajil. Bel a ca'a a wadü' ox sut ti ma' a weel in wich. Joboc a wadic abe'e, bel u ca'a ti awat aj t'ele,— cu t'an a Jesusu. ");
INSERT INTO mopNT_vpl VALUES ("JN14_1","073_14_1","JHN","14","1","1","—Pues te'i. Jetz'a'anaque'ex a wool. Que'ene'ex tun a wool tu pach a Dioso. Que'enaque'ex ilic a wool tin pach inene,— cu t'an a Jesusu. ");
INSERT INTO mopNT_vpl VALUES ("JN14_2","073_14_2","JHN","14","2","2","—Ichil u yotoch in Tat ti ca'ana, yan ti yaab tuba u cuntal a maca. Wa cuchi ma' baalo' ti yana, ma' cuchi tan in wadic te'ex ti yan. Bel in ca'a in wutzquinte'ex a cuuchil,— cu t'an a Jesusu. ");
INSERT INTO mopNT_vpl VALUES ("JN14_3","073_14_3","JHN","14","3","3","—Le'ec ca' xiquen in wutzquinte'ex a cuuchili, ca' wataquen in ch'a'e'ex. Ti baalo'o, le'ec tuba que'enene, te'i ilic a beele'ex,— cu t'an a Jesusu. ");
INSERT INTO mopNT_vpl VALUES ("JN14_4","073_14_4","JHN","14","4","4","—Inche'exe, a weele'ex tuba bel in ca'a. A weele'ex ilic biqui ca' c'ochoque'ex te'i,— cu t'an a Jesusu. ");
INSERT INTO mopNT_vpl VALUES ("JN14_5","073_14_5","JHN","14","5","5","—Noochil, ma' ti weel tuba bel a ca'a. ¿Biqui ca' ti weelte u benil?— cu t'an aj Tomas ti'iji. ");
INSERT INTO mopNT_vpl VALUES ("JN14_6","073_14_6","JHN","14","6","6","—Inen u benil a mac ca' xi'ic etel a Dioso. Tin wetel yan a jajil t'ana. Tin wetel yan a cuxtal a ma' yan q'uin u jobolo. Ma' yan biqui u paatal u beel a mac etel a Tattzili, wa ma' in men inene,— cu t'an a Jesusu. ");
INSERT INTO mopNT_vpl VALUES ("JN14_7","073_14_7","JHN","14","7","7","—Chen tz'etz'eec a weelene'ex, y baalo' ilic ti a weele'ex in Tata. C'u' betic aleebe, bele'ex a ca'a a ch'aa' u tojil yoc'ol in Tata. A wilaje'ex ala'aji,— cu t'an a Jesusu. ");
INSERT INTO mopNT_vpl VALUES ("JN14_8","073_14_8","JHN","14","8","8","—Noochil, ye'e to'on a Tattzili, y chuculo'on ti'i,— cu t'an aj Felipe ti'iji. ");
INSERT INTO mopNT_vpl VALUES ("JN14_9","073_14_9","JHN","14","9","9","—Felipe, yaab q'uin que'enen ta yaame'ex y ¿ma'ax to wa a weelteen?— cu t'an a Jesusu. —Le'ec mac u yilajen, u yilaj biqui'il a Tattzili. ¿C'u' ca'a tan a c'aatic ca' yee'bec te'ex a Tattzili?— cu t'an a Jesusu. ");
INSERT INTO mopNT_vpl VALUES ("JN14_10","073_14_10","JHN","14","10","10","—¿Ma' wa ta'ach a tz'ocsic ti le'ec inene, jun tuul iliquen etel a Tattzili, y le'ec a Tattzili, jun tuul ilic tin wetel? Le'ec boon a t'an a walac in wadic te'exe, ma' chen inen tin junal walac in wadic. Le'ec a Tattzil a que'en ichil in püsüc'ala, le'ec, tan u betic u meyaj,— cu t'an a Jesusu. ");
INSERT INTO mopNT_vpl VALUES ("JN14_11","073_14_11","JHN","14","11","11","—Tz'ocse'ex in t'an. Le'ec inene, jun tuul iliquen etel a Tattzili. Le'ec a Tattzili, jun tuul ilic tin wetel. Wa ma' ta tz'ocsique'ex abe' etel c'u' a tan in wadiqui, tz'ocse'ex abe' etel c'u' a walac in betiqui,— cu t'an a Jesusu. ");
INSERT INTO mopNT_vpl VALUES ("JN14_12","073_14_12","JHN","14","12","12","—Pues te'i. Tan in wadic te'ex u jajil. Le'ec mac a que'en u yool tin pacha, bel ilic u cu bete' a jabix a walac in betiqui. Ma' jadi' abe' a beloo' u cu bete'i. Beloo' u cu bete' a mas quich'pan tucaye'ili, u men c'u' a bel u ca'a ti uchul u men bel in ca'a etel a Tattzili,— cu t'an a Jesusu. ");
INSERT INTO mopNT_vpl VALUES ("JN14_13","073_14_13","JHN","14","13","13","—Le'ec a c'u' a tane'ex a c'atiintiqui, bele'ex a ca'a a c'aate ti'i a Tattzil etel in c'aba'a. Inene, bel in quin tz'aa' te'ex ti'i ca' chiclac u qui'il in Tat,— cu t'an a Jesusu. ");
INSERT INTO mopNT_vpl VALUES ("JN14_14","073_14_14","JHN","14","14","14","—Bel in quin tz'aa' te'ex le'ec a c'u' a bele'ex a ca'a a c'aate etel in c'aba',— cu t'an a Jesusu. ");
INSERT INTO mopNT_vpl VALUES ("JN14_15","073_14_15","JHN","14","15","15","—Pues te'i. Wa yaj a wu'yeene'ex, tz'ocse'ex in t'an, ");
INSERT INTO mopNT_vpl VALUES ("JN14_16","073_14_16","JHN","14","16","16","y bel in quin c'aate ti'i a Tattzili. Le'ec ala'aji, bel u cu tz'aa' te'ex ulaac' a waj anatile'ex ti'i ca' culac ta wetele'ex jumpul. Le'ec ala'aji, le'ec u Püsüc'al a Dioso. Walac u ye'ic a jaja,— cu t'an a Jesusu. ");
INSERT INTO mopNT_vpl VALUES ("JN14_17","073_14_17","JHN","14","17","17","—Le'ecoo' u chucaan a cristianojo, ma' ta'achoo' u yilic ma'ax u yeeloo' biqui'il u Püsüc'al a Dioso, mentücü, ma' yan biqui u c'ümicoo'. Inche'exe, a weele'ex u Püsüc'al a Dioso, u men que'en ta yaame'ex, y bel u ca'a ti p'aatül ta wetele'ex,— cu t'an a Jesusu. ");
INSERT INTO mopNT_vpl VALUES ("JN14_18","073_14_18","JHN","14","18","18","—Pues te'i. Le'ec ca' xiquene, ma' bel in quin p'üte'ex jumpuli. Ca' wataquen tucaye'il ta wetele'ex,— cu t'an a Jesusu. ");
INSERT INTO mopNT_vpl VALUES ("JN14_19","073_14_19","JHN","14","19","19","—Tz'etz'eec to u beel, ma' tu ca' iliquenoo' a cristiano yoc'olcaba. C'u' betiqui, bele'ex a ca'a a wileen. U men cuxa'anen jumpul, bele'ex ilic a ca'a a c'ümü' a cuxtal abe'e,— cu t'an a Jesusu. ");
INSERT INTO mopNT_vpl VALUES ("JN14_20","073_14_20","JHN","14","20","20","—Ti u q'uinil a cümique'ex a cuxtal abe'e, bele'ex a ca'a a ch'aa' u tojil ti jun tuul iliquen etel in Tat. Bele'ex a ca'a a ch'aa' u tojil ti jun tuul ilique'ex tin wetel y jun tuul iliquen ta wetele'ex,— cu t'an a Jesusu. ");
INSERT INTO mopNT_vpl VALUES ("JN14_21","073_14_21","JHN","14","21","21","—Le'ec mac u yeel in t'an y walac u tz'ocsiquen, ala'aji, yaj u yubeen. U men yaj u yubeen, yajtzil u men in Tat. Baalo' ilic inene, yaj in wu'yi. Bel in quin yee' in bajil ti'i,— cu t'an a Jesusu. ");
INSERT INTO mopNT_vpl VALUES ("JN14_22","073_14_22","JHN","14","22","22","—Noochil, ¿biqui ca' a yee' a bajil to'on y ma' ti'ijoo' ulaac' a cristiano yoc'olcaba?— cu t'an aj Judas ti'iji. Aj Judas abe'e, ma' le'ec aj Judas Iscarioteje. ");
INSERT INTO mopNT_vpl VALUES ("JN14_23","073_14_23","JHN","14","23","23","—Le'ec mac a walac u yacuntiquene, bel u cu tz'oques in t'an. Bel u ca'a yacunbul ala'i u men in Tat. Inen in wet'oc in Tata, bel ti ca'a ti c'ochol ti cuntal etel ala'aji,— cu t'an a Jesusu. ");
INSERT INTO mopNT_vpl VALUES ("JN14_24","073_14_24","JHN","14","24","24","—Le'ec mac a ma' yaj u yubeene, ma' ta'ach u tz'ocsic in t'an. Le'ec a pectzil a tane'ex a wu'yiqui, ma' in pectzili. Le'ec abe'e, u pectzil a Tattzili, le'ec mac u tücaa'tajen,— cu t'an a Jesusu. ");
INSERT INTO mopNT_vpl VALUES ("JN14_25","073_14_25","JHN","14","25","25","—Pues te'i. In wadaj te'ex tulacal abe' aleebe le'ec ti que'enen to ta yaame'exe,— cu t'an a Jesusu. ");
INSERT INTO mopNT_vpl VALUES ("JN14_26","073_14_26","JHN","14","26","26","—C'u' betiqui, le'ec a Tattzili, bel u cu tücaa'te te'ex u Püsüc'al etel in c'aba'. Le'ec u Püsüc'al a Dioso, le'ec a waj anatil. Bel u cu yee' te'ex tulacal. Bel u cu c'ajes te'ex tulacal boon in wadaj te'exe,— cu t'an a Jesusu. ");
INSERT INTO mopNT_vpl VALUES ("JN14_27","073_14_27","JHN","14","27","27","—Pues te'i. Tan in tz'eec te'ex ca' jetz'a'anaque'ex a wool. Le'ec u jetz'a'anil in wool inene, le'ec a tan in tz'eec ca' yanac te'exe, ma' jabix a jetz'a'an-oolil a yan yoc'olcabi. Jetz'a'anaque'ex a wool. Ma' u jac'üle'ex a wool,— cu t'an a Jesusu. ");
INSERT INTO mopNT_vpl VALUES ("JN14_28","073_14_28","JHN","14","28","28","—“Bel in ca'a. Ca' wataquen ta wetele'ex tucaye'il,” queen te'ex sami. A wu'yaje'ex in wadic abe'e. Wa cuchi yaj a wu'yeene'exe, qui'e'ex cuchi a wool ca' a wu'ye'ex ti bel in ca'a etel a Tattzil u men mas nooch u yanil tin wich,— cu t'an a Jesusu. ");
INSERT INTO mopNT_vpl VALUES ("JN14_29","073_14_29","JHN","14","29","29","—Aleebe in wadaj te'ex abe'e, pero ma'ax to uchuc. Le'ec ca' uchuc tulacal abe' a c'u' in wadaja, bele'ex a ca'a a mas tz'oques in t'an,— cu t'an a Jesusu. ");
INSERT INTO mopNT_vpl VALUES ("JN14_30","073_14_30","JHN","14","30","30","—Ma' yan biqui in xantal ti top adü' te'ex. Le'ec a quisini, walac u tücaa' yoc'olcab. Watac ala'aji. Ma' yan u muc' u tücaa'teen,— cu t'an a Jesusu. ");
INSERT INTO mopNT_vpl VALUES ("JN14_31","073_14_31","JHN","14","31","31","—Inene, walac in betic a jabix ilic u yadaj ten a Tattzili. Ti baalo'o, chica'an ti'ijoo' a cristiano yoc'olcab ti yaj in wu'yi a Tattzili. Co'ne'ex,— cu t'an a Jesus ti'ijoo' u yaj cambala. ");
INSERT INTO mopNT_vpl VALUES ("JN15_1","073_15_1","JHN","15","1","1","—Pues te'i. Le'ec inene, jabixen u xooc a uvaja. Le'ec in Tata, jabix le'ec a mac a tan u cününtic a uva ti qui',— cu t'an a Jesusu. ");
INSERT INTO mopNT_vpl VALUES ("JN15_2","073_15_2","JHN","15","2","2","—Le'ec boon u yaq'ueel a ma' ta'ach u tz'eec u wichi, walac u queectic, y walac u joc'sic. Le'ec boon a walac u tz'eec u wichi, walac u xotic boon a ma' qui' tu yaam ti'i ca' u tz'aa' ti mas yaab u wich,— cu t'an a Jesusu. ");
INSERT INTO mopNT_vpl VALUES ("JN15_3","073_15_3","JHN","15","3","3","—Inche'exe, etel in t'an in wadaj te'ex, ac utzquinaja'ane'ex tun. Ma' ca' yan a c'as ta woc'ole'exe, mentücü, inche'exe, jabixe'ex u yaq'ueel a uvaja,— cu t'an. ");
INSERT INTO mopNT_vpl VALUES ("JN15_4","073_15_4","JHN","15","4","4","—Jujun tuule'ex yan a tz'eec a tucul ti quet tin wetel. Inene, jede'ec in tz'eec in muc' te'exe. Le'ec u yaq'ueele, ma' tu tz'eec u wich wa ma' quet etel u xooc. Baalo' ilic inche'exe, wa ma' ta tz'eeque'ex a tucul ti quet tin wetele, ma' tu yantal te'ex a qui'il jabix u c'ati a Tattzili,— cu t'an a Jesusu. ");
INSERT INTO mopNT_vpl VALUES ("JN15_5","073_15_5","JHN","15","5","5","—Inene, jabixen u xooc a uvaja. Inche'exe, jabixe'ex u yaq'ueele. Le'ec mac a tan u tz'eec u tucul ti quet tin wetel y inen a tan in tz'eec in muc' ti'i ala'i jabix u yaq'ueel etel u xooc, le'ec a bel u ca'a ti yantal ti'i u yaabil a qui'ili. Wa ma' ta tz'eeque'ex a tucul ti quet tin wetel jabix u yaq'ueel etel u xooco, ma' ta paatale'ex a betic a ma'ax c'u'iji,— cu t'an a Jesusu. ");
INSERT INTO mopNT_vpl VALUES ("JN15_6","073_15_6","JHN","15","6","6","—Le'ec mac u p'ütaj u tz'eec u tucul ti quet tin wetele, bel u ca'a joc'sabül jabix ilic u yaq'ueel a uva a ma' qui'i. Walac u tiquil. Walac u much'quinbil y u pulbul ichil a c'aac'a. Te'i walac u chuul,— cu t'an a Jesusu. ");
INSERT INTO mopNT_vpl VALUES ("JN15_7","073_15_7","JHN","15","7","7","—Wa que'ene'ex a tucul ti quet tin wetel y ma' tubbi te'ex in t'an, c'aate'ex c'u' a c'ate'exe, y bel u ca'a tz'abül te'ex,— cu t'an a Jesusu. ");
INSERT INTO mopNT_vpl VALUES ("JN15_8","073_15_8","JHN","15","8","8","—Le'ec ti tane'ex a betic u yaabil a qui'ili, walac u yaalbül u qui'il a Tattzili. Ti baalo'o, chica'an ti inche'ex in waj cambale'ex,— cu t'an a Jesusu. ");
INSERT INTO mopNT_vpl VALUES ("JN15_9","073_15_9","JHN","15","9","9","—Pues te'i. Jabix ilic ti yaj u yubeen a Tattzili, baalo' ilic ti yaj in wu'ye'ex. Ma' a p'ütique'ex a yacuntiquen,— cu t'an a Jesusu. ");
INSERT INTO mopNT_vpl VALUES ("JN15_10","073_15_10","JHN","15","10","10","—Wa ca' a tz'ocse'ex in t'ana, yaj in wu'ye'ex. Baalo' ilic walac in tz'ocsic u t'an in Tat y yajtzilen u men,— cu t'an a Jesusu. ");
INSERT INTO mopNT_vpl VALUES ("JN15_11","073_15_11","JHN","15","11","11","—In wadaj te'ex tulacal abe'e, ti'i ca' p'aatüc u qui'il in wool ta wetele'ex, y ti'i ca' manüc tu pach u qui'ile'ex a wool,— cu t'an a Jesusu. ");
INSERT INTO mopNT_vpl VALUES ("JN15_12","073_15_12","JHN","15","12","12","—Pues te'i. Bel in quin wadü' te'ex c'u' a yan a betique'exe. Yacunte'ex a bajil ta bajile'ex jabix ilic ti walac in yacuntique'ex inene,— cu t'an a Jesusu. ");
INSERT INTO mopNT_vpl VALUES ("JN15_13","073_15_13","JHN","15","13","13","—Le'ec mac u c'ubaj u bajil ca' quimsabüc yoc'ol u sa'altical u cuxtal u yet'oco, yaj u yubi u yet'oc tu jajil. Ma' yan biqui ca' mas paatac u yacunte u yet'oc,— cu t'an a Jesusu. ");
INSERT INTO mopNT_vpl VALUES ("JN15_14","073_15_14","JHN","15","14","14","—Inche'exe, in wet'oque'ex wa ca' a bete'ex c'u' a walac in wadiqui,— cu t'an a Jesusu. ");
INSERT INTO mopNT_vpl VALUES ("JN15_15","073_15_15","JHN","15","15","15","—Jun tuul aj meyaja, ma' u yeel c'u' a tan u betic u tz'ulili. C'u' betiqui, in laj ye'aj te'ex tulacal a boon in wu'yaj etel in Tata. In wadaj te'ex tulacal, mentücü, ma' tin ca' chiitique'ex jabixe'ex in waj meyaji, pero jabixe'ex in wet'oc,— cu t'an a Jesusu. ");
INSERT INTO mopNT_vpl VALUES ("JN15_16","073_15_16","JHN","15","16","16","—Inche'exe, ma' a yeetajene'exi. Inen in yeetaje'ex. In tücaa'taje'ex ca' a bete'ex u yaabil a qui'ili. A qui'il a tane'ex a betiqui, ma' tu moch jobol. Tulacal a c'u' a walaque'ex a c'aatic ti'i a Tattzil etel in c'aba'a, bel u cu tz'aa' te'ex, u men boon a qui'il a tane'ex a betiqui,— cu t'an a Jesusu. ");
INSERT INTO mopNT_vpl VALUES ("JN15_17","073_15_17","JHN","15","17","17","—Le'ec a c'u' a yan a betique'exe, yan a yacuntique'ex a bajil ta bajile'exe,— cu t'an a Jesusu. ");
INSERT INTO mopNT_vpl VALUES ("JN15_18","073_15_18","JHN","15","18","18","—Pues te'i. Wa tan u motzintique'ex u chucaan a cristiano yoc'olcaba, a weele'ex ilic ti payanbej u motzintajenoo' inene,— cu t'an a Jesusu. ");
INSERT INTO mopNT_vpl VALUES ("JN15_19","073_15_19","JHN","15","19","19","—Le'ecoo' u chucaan a cristiano yoc'olcaba, yaj u yuboo' u bajil. Wa cuchi jumbel a tucule'ex eteloo' a cristiano abe'e, yajtzile'ex cuchi u menoo'. C'u' betiqui, ma' jumbel a tucule'ex etel u chucaan a cristiano yoc'olcab u men in yeetaje'ex tu yaamoo' ala'oo'o. Yoc'ol abe'e, motztzile'ex u menoo' u chucaan a cristiano yoc'olcaba,— cu t'an a Jesusu. ");
INSERT INTO mopNT_vpl VALUES ("JN15_20","073_15_20","JHN","15","20","20","—C'ajese'ex a t'an in wadaj te'exe. “Ma' mas nooch u wichil u meyaj jun tuul aj meyaj tuwich u tz'ulili,” queen te'ex. Wa u betajoo' ten a c'asa, beloo' ilic u cu bete' te'ex a c'asa. Wa u tz'ocsajoo' in t'an inene, beloo' ilic u cu tz'ocse'ex a t'an inche'exe,— cu t'an a Jesusu. ");
INSERT INTO mopNT_vpl VALUES ("JN15_21","073_15_21","JHN","15","21","21","—C'u' betiqui, tulacal a c'u' a beloo' u cu bete' te'exe, beloo' u cu bete' u men tane'ex a tz'ocsiquen. Beloo' u cu bete' abe' u men ma' u yeeloo' biqui'il a Tattzili, le'ec mac u tücaa'tajene,— cu t'an a Jesusu. ");
INSERT INTO mopNT_vpl VALUES ("JN15_22","073_15_22","JHN","15","22","22","—Pues te'i. Wa cuchi ma' taleen in wadoo' ti'i c'u' u c'ati a Dioso, ma' cuchi yanoo' u sip'il. C'u' betiqui, taleen, mentücü, ma' yan biqui u yadicoo' ti ma' yanoo' u sip'il,— cu t'an a Jesusu. ");
INSERT INTO mopNT_vpl VALUES ("JN15_23","073_15_23","JHN","15","23","23","—Le'ec mac tan u motzintiquene, tan ilic u motzintic in Tat,— cu t'an a Jesusu. ");
INSERT INTO mopNT_vpl VALUES ("JN15_24","073_15_24","JHN","15","24","24","—Wa cuchi ma' in betaj a milagro tu yaamoo'o, ma' cuchi yanoo' u sip'il. Ma'ax mac u betaj a jabix in betaj inene. C'u' betiqui, u yilajoo' c'u' in betaj, y u motzintajenoo'. U motzintajoo' ilic in Tata,— cu t'an a Jesusu. ");
INSERT INTO mopNT_vpl VALUES ("JN15_25","073_15_25","JHN","15","25","25","—C'u' betiqui, yan u yuchul ti baalo' u men baala' ti tz'iiba'an ichil u ju'um a Dioso: “U motzintajenoo' ti ma' yan c'u' aj etel,” cu t'an a t'an a tz'iiba'an ichil u ju'um a Dioso,— cu t'an a Jesusu. ");
INSERT INTO mopNT_vpl VALUES ("JN15_26","073_15_26","JHN","15","26","26","—Pues te'i. Le'ec ca' xiquen etel a Tattzili, bel in quin tücaa'te ta wetele'ex a waj anatile'ex, le'ec u Püsüc'al a Dioso. Walac u ye'ic a jaja. Te'i u talel etel a Tattzili. Bel u ca'a u tzicbalteen,— cu t'an a Jesusu. ");
INSERT INTO mopNT_vpl VALUES ("JN15_27","073_15_27","JHN","15","27","27","—Baalo' ilic inche'exe, bele'ex ilic a ca'a a tzicbalteen, u men que'ene'ex tin wetel ti u cajeeb ti cajeen in tzicbalte a Dioso,— cu t'an a Jesusu. ");
INSERT INTO mopNT_vpl VALUES ("JN16_1","073_16_1","JHN","16","1","1","—Pues te'i. In wadaj te'ex tulacal abe' ti'i ma' a p'ütiquene'ex,— cu t'an a Jesusu. ");
INSERT INTO mopNT_vpl VALUES ("JN16_2","073_16_2","JHN","16","2","2","—Bele'ex a ca'a joc'sabül ichil boon a naj tuba walacoo' u much'tal ti wetcaal u c'ajesoo' a Dioso. Watac u q'uinil ti le'ec mac a tan u quimsique'exe, bel u cu tucle ti tan u betic u meyaj a Dios ti tan u quimsique'ex,— cu t'an a Jesusu. ");
INSERT INTO mopNT_vpl VALUES ("JN16_3","073_16_3","JHN","16","3","3","—Beloo' u cu bete' ti baalo' u men ma' u yeeloo' biqui'il a Tattzili, ma'ax u yeelenoo',— cu t'an a Jesusu. ");
INSERT INTO mopNT_vpl VALUES ("JN16_4","073_16_4","JHN","16","4","4","—In wadaj te'ex tulacal abe'e. Ti baalo'o, le'ec ca' c'ochoc u yorajil u yuchul, bel u ca'a ti c'aal te'ex ti le'ec abe' in wadaj te'ex ti wataca,— cu t'an a Jesusu. —Pues te'i. Le'ec ti caje'ex a wet'octeene, ma' in wadaj te'ex c'u' a watac ta woc'ole'ex u men que'enen to ta yaame'ex,— cu t'an a Jesusu. ");
INSERT INTO mopNT_vpl VALUES ("JN16_5","073_16_5","JHN","16","5","5","—C'u' betic aleebe, bel in ca'a etel mac u tücaa'tajen. Ma'ax mac ta yaame'exe, tan u c'aatic ten tuba bel in ca'a,— cu t'an a Jesusu. ");
INSERT INTO mopNT_vpl VALUES ("JN16_6","073_16_6","JHN","16","6","6","—Aleebe u men in wadaj te'ex ti bel in ca'a, yajaje'ex a wool. ");
INSERT INTO mopNT_vpl VALUES ("JN16_7","073_16_7","JHN","16","7","7","Tan in wadic te'ex u jajil. Mas qui' te'ex ca' xiquen. Wa ma' tin beele, ma' tu yudel ta wetele'ex a waj anatil, le'ec u Püsüc'al a Dioso. C'u' betiqui, ca' xiquene, bel in quin tücaa'te ala'i ta wetele'exe,— cu t'an a Jesusu. ");
INSERT INTO mopNT_vpl VALUES ("JN16_8","073_16_8","JHN","16","8","8","—Le'ec ca' uduc u Püsüc'al a Dioso, bel u cu yee' ti'ijoo' a cristiano ti yanoo' u sip'il. Bel ilic u cu yee' ti'ijoo' ti toj in na'at. Bel ilic u cu yee' ti'ijoo' ti tz'abüloo' u ca'a ichiloo' u sip'il xan,— cu t'an a Jesusu. ");
INSERT INTO mopNT_vpl VALUES ("JN16_9","073_16_9","JHN","16","9","9","—Bel u ca'a yee'beloo' u sip'il u men ma' que'enoo' u yool tin pach,— cu t'an a Jesusu. ");
INSERT INTO mopNT_vpl VALUES ("JN16_10","073_16_10","JHN","16","10","10","—Bel u ca'a yee'beloo' ti'i a cristiano ti toj in na'at u men bel in ca'a etel a Tattzili, y ma' ta ca' iliquene'ex,— cu t'an a Jesusu. ");
INSERT INTO mopNT_vpl VALUES ("JN16_11","073_16_11","JHN","16","11","11","—Bel u ca'a yee'beloo' ti'i a cristiano ti beloo' u ca'a tz'abül ichiloo' u sip'il, u men le'ec a quisin a walac u tücaa' yoc'olcaba, ac ila'an tun ti yan u sip'il ala'i u men aj il sip'ili,— cu t'an a Jesusu. ");
INSERT INTO mopNT_vpl VALUES ("JN16_12","073_16_12","JHN","16","12","12","—Pues te'i. Yan ti yaab c'u' a yan to in c'ati cuchi in wadü' te'exe. C'u' betiqui, ma' ta paatale'ex a ch'a'ic u tojil aleebe,— cu t'an a Jesusu. ");
INSERT INTO mopNT_vpl VALUES ("JN16_13","073_16_13","JHN","16","13","13","—Le'ec u Püsüc'al a Dioso, walac u ye'ic a jaja. Le'ec ca' uduc ala'i ta yaame'exe, bel u cu yee' te'ex tulacal a jaja. Ma' u yanil a bel u cu yadü'ü. Bel u cu yadü' tulacal a boon a aalbi ti'iji. Bel u cu yadü' te'ex c'u' a watac yoc'olcab,— cu t'an a Jesusu. ");
INSERT INTO mopNT_vpl VALUES ("JN16_14","073_16_14","JHN","16","14","14","—Bel u cu yadü' in qui'il, u men bel u cu yubi c'u' a tan in wadiqui, ca' tun u yadü' te'exe,— cu t'an a Jesusu. ");
INSERT INTO mopNT_vpl VALUES ("JN16_15","073_16_15","JHN","16","15","15","—Tulacal c'u' a yan ti'i a Tattzili, ten, mentücü, in wadaj te'ex ti le'ec u Püsüc'al a Dioso, bel u cu yubi tin wetel, y bel u cu yadü' te'ex,— cu t'an a Jesusu. ");
INSERT INTO mopNT_vpl VALUES ("JN16_16","073_16_16","JHN","16","16","16","—Pues te'i. Tz'etz'eec to u beel ti ma' ta wiliquene'ex. Tz'etz'eec mas pachili, bele'ex a ca'a a wileen tucaye'il u men bel in ca'a etel a Tattzili,— cu t'an a Jesusu. ");
INSERT INTO mopNT_vpl VALUES ("JN16_17","073_16_17","JHN","16","17","17","Yanoo' tu yaam u yaj cambal, u c'aatajoo' tu bajil. —¿C'u' u nu'cul a tan u yadic to'ono?— cu t'anoo' tu bajil. —“Tz'etz'eec to u beel ti ma' ta wiliquene'ex. Tz'etz'eec mas pachili, bele'ex a ca'a a wileen tucaye'il u men bel in ca'a etel a Tattzili,” cu t'an to'on,— cu t'anoo' tu bajil. ");
INSERT INTO mopNT_vpl VALUES ("JN16_18","073_16_18","JHN","16","18","18","—¿C'u' a tan u yadic to'on a tz'etz'eec to u beele? Ma' eela'an c'u' a tan u yadic to'ono,— cu t'anoo' tu bajil. ");
INSERT INTO mopNT_vpl VALUES ("JN16_19","073_16_19","JHN","16","19","19","Le'ec a Jesusu, u yeel ti u c'atoo' cuchi u c'aate ti'i c'u' a tan u yadiqui. —¿Tane'ex wa a c'aatic ta bajile'ex u nu'cul a c'u' in wadaja? “Tz'etz'eec to u beel ti ma' ta wiliquene'ex. Tz'etz'eec mas pachili, bele'ex a ca'a a wileen tucaye'il,” queen te'ex,— cu t'an a Jesusu. ");
INSERT INTO mopNT_vpl VALUES ("JN16_20","073_16_20","JHN","16","20","20","—Tan in wadic te'ex u jajil. Bele'ex a ca'a ti oc'ol u men ma' ta wiliquene'ex. Bel u ca'a ti yajtal a woole'ex. Le'ecoo' u chucaan a cristiano yoc'olcaba, bel u ca'a ti qui'taloo' u yool, u men ma' tanoo' u yiliquen. C'u' betiqui, le'ec u yajil a woole'exe, bel u ca'a ti manül. Qui'tal u ca'a a woole'ex,— cu t'an a Jesusu. ");
INSERT INTO mopNT_vpl VALUES ("JN16_21","073_16_21","JHN","16","21","21","—Le'ec ti tan to u yantal u yal a nooch'upu, yaj u yool u men c'ochi u yorajil u c'ümü' a yaja. C'u' betiqui, le'ec ti yanac u yala, walac u tubul ti'i u yajil. Qui' u yool etel u yal,— cu t'an a Jesusu. ");
INSERT INTO mopNT_vpl VALUES ("JN16_22","073_16_22","JHN","16","22","22","—Baalo' ilic inche'exe. Yaj a woole'ex aleebe. C'u' betiqui, bel in quin wile'ex tucaye'il, mentücü, bel u ca'a ti qui'tal a woole'ex. Ma'ax mac jede'ec u paatal u joc'sic u qui'ile'ex a wool ti a q'uin abe'e,— cu t'an a Jesusu. ");
INSERT INTO mopNT_vpl VALUES ("JN16_23","073_16_23","JHN","16","23","23","—Ti a q'uin abe'e, ma' bele'ex a ca'a a c'aate ten a ma'ax c'u'iji. Tan in wadic te'ex u jajil. Le'ec a Tattzili, bel u cu tz'aa' te'ex le'ec a c'u' a walaque'ex a c'aatic ti'i etel in c'aba',— cu t'an a Jesusu. ");
INSERT INTO mopNT_vpl VALUES ("JN16_24","073_16_24","JHN","16","24","24","—Tac leeb ma'ax c'u' a c'aataje'ex etel in c'aba'. Tan ti tanaque'ex a c'aatic ti'i c'u' a c'ate'exe, ti'i ca' qui'aque'ex a wool tu jajil,— cu t'an a Jesusu. ");
INSERT INTO mopNT_vpl VALUES ("JN16_25","073_16_25","JHN","16","25","25","—Pues te'i. Tulacal ada' in wadaj te'ex ich mucult'an. C'ochol u ca'a u q'uinil ti ma' tin ca' t'an ich mucult'an. Bel in quin wadü' te'ex etel a t'an a chica'an u nu'cul yoc'ol a Tattzili,— cu t'an a Jesusu. ");
INSERT INTO mopNT_vpl VALUES ("JN16_26","073_16_26","JHN","16","26","26","—Ti a q'uin abe'e, bele'ex a ca'a a c'aate ti'i a Tattzil etel in c'aba', y bel u ca'a tz'abül te'ex. Ma' tan in wadic te'ex ti bel in quin wadü' ti'i a Tattzil ca' u tz'aa' te'ex c'u' a tane'ex a c'aatiqui,— cu t'an a Jesusu. ");
INSERT INTO mopNT_vpl VALUES ("JN16_27","073_16_27","JHN","16","27","27","—Ma' tin c'aatic ti'i u men ma' tzaj. Le'ec a Tattzili, yaj ilic u yube'ex xan. Yajtzile'ex u men walaque'ex a yacuntiquen, y u men a tz'ocsaje'ex ti te' taleen etel a Tattzili,— cu t'an a Jesusu. ");
INSERT INTO mopNT_vpl VALUES ("JN16_28","073_16_28","JHN","16","28","28","—Te' taleen etel a Tattzili, y udeen wa'ye' yoc'olcab. Bel in ca'a ti joc'ol wa'ye' yoc'olcab. Ca' bel in ca'a etel a Tattzili,— cu t'an a Jesusu. ");
INSERT INTO mopNT_vpl VALUES ("JN16_29","073_16_29","JHN","16","29","29","—Aleebe chica'an a t'an. Ma' tan a t'an ich mucult'an,— cu t'anoo' u yaj cambal ti'i a Jesusu. ");
INSERT INTO mopNT_vpl VALUES ("JN16_30","073_16_30","JHN","16","30","30","—Aleebe ti weel ti le'ec incheche, a weel tulacal. Ma'ax mac tzaj u yadic tech c'u' a bel u cu c'aate u men a weel tun c'u' a bel u cu c'aate tech. U men abe'e, walac ti tz'ocsic ti te' tala'anech etel a Dioso,— cu t'anoo' u yaj cambal ti'i. ");
INSERT INTO mopNT_vpl VALUES ("JN16_31","073_16_31","JHN","16","31","31","—¿Tane'ex wa a tz'ocsiquen aleebe?— cu t'an a Jesus ti uchi u nuuc. ");
INSERT INTO mopNT_vpl VALUES ("JN16_32","073_16_32","JHN","16","32","32","—Watac u c'ochol u yorajil ti bele'ex a ca'a wecbel jujun tuulil ta wotoche'ex. Bele'ex a ca'a a p'üteen tin junal. C'u' betiqui, ma' que'enen tin junali. Le'ec a Tattzili, que'en tin wetel,— cu t'an a Jesusu. ");
INSERT INTO mopNT_vpl VALUES ("JN16_33","073_16_33","JHN","16","33","33","—In wadaj te'ex ti baalo' ti'i ca' jetz'lac a woole'ex tin wetel. Le'ecoo' u chucaan a cristiano yoc'olcaba, beloo' u cu yajcunte'ex. C'u' betiqui, ma' a saactale'ex. Inene, in cho'aj a quisin a walac u tücaa' yoc'olcab,— cu t'an a Jesusu. ");
INSERT INTO mopNT_vpl VALUES ("JN17_1","073_17_1","JHN","17","1","1","Pues te'i. Le'ec ti jobi u yadic abe' ti'ijoo' u yaj cambala, u cha'antaj a ca'an a Jesusu. —Tat,— cu t'an ti'i a Tattzili. —C'ochi u yorajil. Ye'e ti nooch u wichil in meyaj ti'i ca' in yee' ti top nooch a yanil incheche,— cu t'an a Mejentzili. ");
INSERT INTO mopNT_vpl VALUES ("JN17_2","073_17_2","JHN","17","2","2","—Bete ti baalo', u men a tz'aj tulacaloo' a cristiano tin c'ü'. Inene, walac in tz'eec a cuxtal a ma' yan q'uin u jobol ti'ijoo' boon tuul a tz'aj tene,— cu t'an a Mejentzil ti'i a Tattzili. ");
INSERT INTO mopNT_vpl VALUES ("JN17_3","073_17_3","JHN","17","3","3","—Ti ca' u c'ümoo' a cuxtal a ma' yan q'uin u jobolo, yan u tz'ocsiquechoo',— cu t'an a Jesus ti'i a Tattzili. —Yan ilic u tz'ocsiquenoo'. Jesucristojen. Jadi' inchech a Dios tu jajili. Inchech a tücaa'tajen,— cu t'an a Jesusu. ");
INSERT INTO mopNT_vpl VALUES ("JN17_4","073_17_4","JHN","17","4","4","—Le'ec ca' in betaj a meyaj a tz'aj ten ca' in bete'e, in ye'aj a yanil wa'ye' yoc'olcab,— cu t'an a Jesusu. ");
INSERT INTO mopNT_vpl VALUES ("JN17_5","073_17_5","JHN","17","5","5","—Aleebe Tat, tz'a ten in meyaj tucaye' ti ca'an jabix ilic a yan ten le'ec ti que'enen to ta wetel ti ma'ax to betabüc a yoc'olcaba,— cu t'an a Jesusu. ");
INSERT INTO mopNT_vpl VALUES ("JN17_6","073_17_6","JHN","17","6","6","—In ye'aj biqui'il a na'at ti'ijoo' boon a cristiano yoc'olcab a yeetaj ti'i a tz'aa' tene. Le'ec ala'oo'o, techoo', y a tz'ajoo' ten. U tz'ocsajoo' a t'an,— cu t'an a Jesusu. ");
INSERT INTO mopNT_vpl VALUES ("JN17_7","073_17_7","JHN","17","7","7","—Aleebe u yeeloo' ti le'ec in patalil a tz'aj tene, tali ta wetel,— cu t'an a Jesusu. ");
INSERT INTO mopNT_vpl VALUES ("JN17_8","073_17_8","JHN","17","8","8","—In wadaj ti'ijoo' a t'an a wadaj tene. U c'ümajoo', mentücü, u yeeloo' ti jaj ti taleen ta wetel. Walacoo' u tz'ocsic ti le'ec incheche, a tücaa'tajen,— cu t'an a Jesus ti'i a Tattzili. ");
INSERT INTO mopNT_vpl VALUES ("JN17_9","073_17_9","JHN","17","9","9","—Tan in c'aatic tech yoc'ol ala'oo'o. Ma' tan in c'aatic tech yoc'ol tulacal a cristiano yoc'olcabi. Jadi' tan in c'aatic yoc'ol boon a tz'aj ten. Ala'oo'o, techoo', ");
INSERT INTO mopNT_vpl VALUES ("JN17_10","073_17_10","JHN","17","10","10","y tulacal boon a tene, comon to'on ilic xan. Walacoo' u ye'ic ti top nooch u wichil in meyaj,— cu t'an a Jesusu. ");
INSERT INTO mopNT_vpl VALUES ("JN17_11","073_17_11","JHN","17","11","11","—Wataquen ta wetel. C'u' betic ala'oo'o, p'aatüloo' u ca'a wa'ye' yoc'olcab. Inene, ma'. Tat, toj a na'at jumpul. Cününtoo' boon tuul a tz'aj ten etel a muc' ti'i ca' p'aatücoo' ti jumbeloo' u na'at jabixo'on iliqui,— cu t'an a Jesusu. ");
INSERT INTO mopNT_vpl VALUES ("JN17_12","073_17_12","JHN","17","12","12","—Le'ec ti que'enen to tu yaamoo' boon tuul a tz'aj tene, in cününtajoo' etel a muc'. Laj que'enoo' ta c'ü'. Ma' yan a sa'tiji. Jadi' a jun tuul a joq'uiji. U beel ilic ti'i ti yan u joc'ol ta c'ü' ti'i ca' manüc jabix ilic ti ac tz'iiba'an ichil a ju'um a teche,— cu t'an a Jesusu. ");
INSERT INTO mopNT_vpl VALUES ("JN17_13","073_17_13","JHN","17","13","13","—C'u' betic aleebe, wataquen ta wetel,— cu t'an a Jesusu. —Tan in wadic tech tulacal abe'e, le'ec ti que'enen to wa'ye' yoc'olcaba, ti'i ca' qui'acoo' u yool jumpul a boon a ten etel a qui'-oolal a jabix a yan tene,— cu t'an a Jesus ti'i u Tata. ");
INSERT INTO mopNT_vpl VALUES ("JN17_14","073_17_14","JHN","17","14","14","—In wadaj a pectzil ti'ijoo'. C'u' betiqui, motztziloo' u men u chucaan a cristiano yoc'olcaba, u men ma' jumbeloo' u tucul etel ala'oo'o. Baalo' ilic inene, ma' jumbel in tucul etel u chucaan a cristianojo,— cu t'an a Jesusu. ");
INSERT INTO mopNT_vpl VALUES ("JN17_15","073_17_15","JHN","17","15","15","—Ma' tan in c'aatic tech ca' a joq'uesoo' yoc'olcab boon a tz'aj teni. Jadi' tan in c'aatic tech ca' a cününtoo' ti'i ma' u ti'albüloo' u men a quisini,— cu t'an a Jesus ti'i u Tata. ");
INSERT INTO mopNT_vpl VALUES ("JN17_16","073_17_16","JHN","17","16","16","—Ma' jumbeloo' u tucul etel u chucaan a cristiano yoc'olcaba, jabix ilic inen a ma' jumbel in tucul etel u chucaan a cristianojo,— cu t'an a Jesusu. ");
INSERT INTO mopNT_vpl VALUES ("JN17_17","073_17_17","JHN","17","17","17","—Tojquintoo' u na'at etel a jajil t'ana. Le'ec a pectzili, le'ec a jajil t'ana,— cu t'an a Jesusu. ");
INSERT INTO mopNT_vpl VALUES ("JN17_18","073_17_18","JHN","17","18","18","—Jabix ilic ca' a tücaa'tajen in bete' c'u' a c'ati wa'ye' yoc'olcaba, baalo' ilic ca' in tücaa'tajoo' tu yaamoo' a cristiano yoc'olcab boon a tz'aj tene,— cu t'an a Jesusu. ");
INSERT INTO mopNT_vpl VALUES ("JN17_19","073_17_19","JHN","17","19","19","—Yoc'lal boon a tz'aj tene, in tz'aj in wool tu pach a meyaj a tz'aj ten. Ti baalo'o, beloo' u ca'a ti tojtal u na'at u men a jaja,— cu t'an a Jesus ti'i a Tattzili. ");
INSERT INTO mopNT_vpl VALUES ("JN17_20","073_17_20","JHN","17","20","20","—Pues te'i. Tan in c'aatic tech ca' tz'abüc a qui' ma' jadi' ti'ijoo' in waj cambal ada'oo'i. Yanoo' ulaac' mac beloo' to u cu tz'aa' u yool tin pach u menoo' u t'an in waj cambal. Tan ilic in c'aatic tech yoc'ol ala'oo'o,— cu t'an a Jesus ti'i u Tata. ");
INSERT INTO mopNT_vpl VALUES ("JN17_21","073_17_21","JHN","17","21","21","—In c'ati ca' culacoo' ti jumbelacoo' tu bajil. Tat, jabix ilic ti jumbelech tin wetel y jumbelen ta wetel, in c'ati ca' culacoo' jabix jumbeloo' ilic tu bajil tiqui wetel. Ti baalo'o, le'ecoo' u chucaan a cristiano yoc'olcaba, beloo' u cu tz'oques ti inchech a tücaa'tajen,— cu t'an a Jesusu. ");
INSERT INTO mopNT_vpl VALUES ("JN17_22","073_17_22","JHN","17","22","22","—Le'ec ilic a meyaj a nooch u wichil a tz'aj ten ti'i ca' in bete'e, le'ec ilic in tz'aj ti'ijoo' ti'i ca' u betoo'o, ti'i ca' culacoo' ti jumbeloo' ilic tu bajil jabix ilic inen ta wetele,— cu t'an a Jesus ti'i u Tata. ");
INSERT INTO mopNT_vpl VALUES ("JN17_23","073_17_23","JHN","17","23","23","—Inene, jumbelen ilic eteloo'. Incheche, jumbelech ilic tin wetel. Ti baalo'o, beloo' u ca'a ti cuntal ti jumbeloo' ilic tu bajil tu jajil. Le'ec ti jumbeloo' ti baalo'o, le'ecoo' u chucaan a cristiano yoc'olcaba, beloo' u cu yeelte ti inchech a tücaa'tajen. Beloo' u cu yeelte ti jabix ilic ti yaj a wu'yeene, baalo' ilic ti yaj a wu'yoo' boon a tz'aj tene,— cu t'an a Jesusu. ");
INSERT INTO mopNT_vpl VALUES ("JN17_24","073_17_24","JHN","17","24","24","—Tat, le'ec a boon tuul a tz'aj tene, in c'ati cuchi ti que'enoo' tin wetel le'ec tuba que'enen ti'i ca' u yiloo' in muc' a tz'aj tene. Yaj a wu'yeen, le'ec ti ma'ax to betabüc a yoc'olcaba,— cu t'an a Jesusu. ");
INSERT INTO mopNT_vpl VALUES ("JN17_25","073_17_25","JHN","17","25","25","—Tat, toj a na'at. Le'ecoo' u chucaan a cristiano yoc'olcaba, ma' u yeelechoo'i. C'u' betic inene, in weelech. Le'ec boon a tz'aj tene, walacoo' u tz'ocsic ti le'ec incheche, a tücaa'tajen,— cu t'an a Jesusu. ");
INSERT INTO mopNT_vpl VALUES ("JN17_26","073_17_26","JHN","17","26","26","—In ye'aj ti'ijoo' biqui'il a na'at, y tan ti tan ilic in ye'ic ti'ijoo'. Tanil u cünicoo' biqui ti yaj a wu'yeene, beloo' u cu mas yacunte u bajil tu bajiloo', y p'aatül in ca'a ti jumbelen ilic eteloo',— cu t'an a Jesus ti'i a Tattzili. ");
INSERT INTO mopNT_vpl VALUES ("JN18_1","073_18_1","JHN","18","1","1","Pues te'i. Le'ec ti jobi u c'ajsic a Dioso, a Jesus u yet'ocoo' u yaj cambala, binoo' junxeel a ja' a Cedron u c'aba'a. Yan u cuuch a püc'aal te'i. Ocoo' ichil. ");
INSERT INTO mopNT_vpl VALUES ("JN18_2","073_18_2","JHN","18","2","2","Le'ec aj Judas u tzolaj a Jesusu, u yeel ilic u cuuch a püc'aal abe'e, u men yaab sut c'ochoo' te'i a Jesus eteloo' u yaj cambala. ");
INSERT INTO mopNT_vpl VALUES ("JN18_3","073_18_3","JHN","18","3","3","Pues te'i. C'ochoo' te'i aj Judas u yet'ocoo' u yaabil a soldadojo. Yanoo' ilic a jabix soldado a walacoo' u cününtic u yotoch a Dios a tücünacoo' tu pach aj Judasa. Laj tücaa'boo' u menoo' u noochil u yaj mansaj t'an a cristiano ti'i Dios u yet'ocoo' a fariseo u c'aba'oo' u na'ata. C'ochoo' eteloo' u lampara, eteloo' u tücte' a t'üba'ana, y eteloo' c'u' a c'abeet ti'ijoo' ti p'isbaj. ");
INSERT INTO mopNT_vpl VALUES ("JN18_4","073_18_4","JHN","18","4","4","A Jesusu, u yeel tulacal a c'u' a bel u cu c'ümü'ü. Bini u c'ümoo'o. —¿Mac a tane'ex a cüxtiqui?— cu t'an ti'ijoo'. ");
INSERT INTO mopNT_vpl VALUES ("JN18_5","073_18_5","JHN","18","5","5","—Le'ec a Jesus a tala'an ich caj Nazarete,— cu t'anoo' ti'i ti uchoo' u nuuc. —Inen abe'e,— cu t'an a Jesus ti'ijoo'o. Le'ec aj Judas u tzolaj a Jesusu, que'en tu yaamoo' a c'ochoo' to. ");
INSERT INTO mopNT_vpl VALUES ("JN18_6","073_18_6","JHN","18","6","6","Le'ec ti ca' u yadaj ti inen abe'e, binoo' ti cuculpach, y c'axoo' ti lu'um. ");
INSERT INTO mopNT_vpl VALUES ("JN18_7","073_18_7","JHN","18","7","7","—¿Mac a tane'ex a cüxtiqui?— cu t'an ti'ijoo' tucaye'il. —Le'ec a Jesus a tala'an ich caj Nazarete,— cu t'anoo' ti'i. ");
INSERT INTO mopNT_vpl VALUES ("JN18_8","073_18_8","JHN","18","8","8","—In wadaj te'ex ti inen abe'e. Wa chen inen a tane'ex a cüxtiquene, cha'oo' u beel a winic ada'a,— cu t'an a Jesus ti uchi u nuuc. ");
INSERT INTO mopNT_vpl VALUES ("JN18_9","073_18_9","JHN","18","9","9","U nuuctajoo' ti'i ca' cha'bücoo' u yaj cambal, ti'i ca' manüc c'u' u yadaj ti'i a Tattzil sami. —Le'ec boon a tz'aj tene, laj que'enoo' ta c'ü'. Ma' yan a joq'ui ta c'ü',— cu t'an ti'i a Tattzil sami. ");
INSERT INTO mopNT_vpl VALUES ("JN18_10","073_18_10","JHN","18","10","10","Pues te'i. Yan jun tuul a winiqui, aj Malco u c'aba'. U yetc'ocholoo' a soldadojo. Le'ec ala'aji, walac u meyaj ichil u yotoch a winic a mas nooch u wichil u meyaj tu yaamoo' u yaj mansaj t'an a cristiano ti'i a Dioso. Yan a maasca' etel aj Simon Pedrojo. U joc'saj. U jan ch'üctaj u xiq'uin tu yaj toj tu yaj seeb c'ü' a winic abe'e. ");
INSERT INTO mopNT_vpl VALUES ("JN18_11","073_18_11","JHN","18","11","11","—Tz'a a maasca' ichil u pix. Mas qui' ca' in c'ümü' c'u' a tan u tz'eec ten a Tattzil ca' in c'ümü'ü,— cu t'an a Jesus ti'i aj Pedrojo. ");
INSERT INTO mopNT_vpl VALUES ("JN18_12","073_18_12","JHN","18","12","12","Pues te'i. Le'ecoo' u yaabil a soldado u yet'ocoo' u noochil eteloo' a jabix soldado u yaj cananil u yotoch a Dioso, u müchajoo' a Jesusu. U c'üxajoo'. ");
INSERT INTO mopNT_vpl VALUES ("JN18_13","073_18_13","JHN","18","13","13","Payanbej u bensajoo' etel aj Anas u men le'ec a noochwinic abe'e, le'ec u ja'an aj Caifasa. Le'ec aj Caifasa, mas nooch u wichil u meyaj tu yaamoo' u yaj mansaj t'an a cristiano ti'i a Dioso. ");
INSERT INTO mopNT_vpl VALUES ("JN18_14","073_18_14","JHN","18","14","14","Le'ec ilic aj Caifas abe'e, le'ec u yadaj biq'uin ado' ti mas qui' ca' quimsabüc jun tuul a winic ti u jel a caja. ");
INSERT INTO mopNT_vpl VALUES ("JN18_15","073_18_15","JHN","18","15","15","Pues te'i. Le'ec aj Simon Pedrojo, tücünac ich mucul tu pach a Jesusu. Baalo' ilic xan u men ulaac' jun tuul u yaj cambal a Jesusu. Eeltzil ala'i u men a winic a mas nooch u wichil u meyaj tu yaamoo' u yaj mansaj t'an a cristiano ti'i a Dioso. U men eeltzili, oqui aj cambal abe' etel a Jesus ichil u cotil u yotoch a noochwiniqui. ");
INSERT INTO mopNT_vpl VALUES ("JN18_16","073_18_16","JHN","18","16","16","C'u' betiqui, p'aati aj Pedro tu pach u chi' a coto. Le'ec aj cambal a eeltzil abe'e, bini ti tzicbal etel ix meyaj a tan u cününtic u chi' a coto. U yocsaj aj Pedrojo. ");
INSERT INTO mopNT_vpl VALUES ("JN18_17","073_18_17","JHN","18","17","17","—¿Ma' wa le'ec inchech jun tuul u yaj cambal a winic abe'e?— cu t'an u yaalbül aj Pedro u men ix meyaj a walac u cününtic u chi' a coto. —Ma' ineni,— cu t'an ti'i. ");
INSERT INTO mopNT_vpl VALUES ("JN18_18","073_18_18","JHN","18","18","18","Pues te'i. Top tan a siisi. Le'ecoo' aj meyaj u yet'ocoo' a jabix soldado u yaj cananil u yotoch a Dioso, u t'übajoo' a c'aac'a. Wa'anoo' te'i ti q'uiich. Le'ec aj Pedrojo, wa'an ilic tu yaamoo' ti q'uiich. ");
INSERT INTO mopNT_vpl VALUES ("JN18_19","073_18_19","JHN","18","19","19","Pues te'i. Le'ec a winic a mas nooch u wichil u meyaj tu yaamoo' u yaj mansaj t'an a cristiano ti'i a Dioso, caji u c'aate ti'i a Jesus u pectzil u yaj cambaloo', y a t'an boon u yadaja. ");
INSERT INTO mopNT_vpl VALUES ("JN18_20","073_18_20","JHN","18","20","20","—Uchi in t'an tu taanoo' a cristianojo. Walac in t'an ichil boon a naj tuba walacoo' u much'tal ti wetcaal u c'ajes a Dioso, y ichil u yotoch a Dioso. Tulacaloo' ti wetcaal, walacoo' u much'tal te'i. Ma'ax c'u' in wadaj ich muculu,— cu t'an a Jesus ti'i a noochwinic abe'e. ");
INSERT INTO mopNT_vpl VALUES ("JN18_21","073_18_21","JHN","18","21","21","—¿C'u' ca'a tan a c'aatic ten? C'aatoo' ti'i boon u yubaj in t'an c'u' in wadaja. U yeeloo' c'u' in wadaja,— cu t'an a Jesusu. ");
INSERT INTO mopNT_vpl VALUES ("JN18_22","073_18_22","JHN","18","22","22","Pa'loxbi u wich a Jesus etel c'u' u yadaj u men jun tuul a jabix soldado u yaj cananil u yotoch a Dios a que'en tu tzeele. —¿Baalo' wa ca' a nuucte ala'aji? Ala'aji, mas nooch u wichil u meyaj tu yaamoo' u yaj mansaj t'an a cristiano ti'i a Dioso,— cu t'an ti'i a Jesusu. ");
INSERT INTO mopNT_vpl VALUES ("JN18_23","073_18_23","JHN","18","23","23","—Wa ma' toj in t'ana, adü ti'i tulacaloo' a que'enoo' wa'ye' c'u' a ma' tojo. Wa toj in t'ana, ¿c'u' ca'a tan a jütz'iquen?— cu t'an a Jesus ti'iji. ");
INSERT INTO mopNT_vpl VALUES ("JN18_24","073_18_24","JHN","18","24","24","Pues te'i. Le'ec aj Anasa, u tücaa'taj a Jesus etel aj Caifasa, le'ec a mas nooch u wichil u meyaj tu yaamoo' u yaj mansaj t'an a cristiano ti'i a Dioso. C'üxa'an to a Jesusu. ");
INSERT INTO mopNT_vpl VALUES ("JN18_25","073_18_25","JHN","18","25","25","Pues te'i. Wa'an ti que'en aj Pedro ti q'uiich. Le'ecoo' u chucaan a que'enoo' te'iji, u c'aatajoo' ti'i. —¿Ma' wa le'ec inchech jun tuul u yaj cambal a Jesusu?— cu t'anoo' ti'i. —Ma', ma' ineni,— cu t'an ti'ijoo'. ");
INSERT INTO mopNT_vpl VALUES ("JN18_26","073_18_26","JHN","18","26","26","Te'i que'en jun tuul a walac u meyaj ichil u yotoch a winic a mas nooch u wichil u meyaj tu yaamoo' u yaj mansaj t'an a cristiano ti'i a Dioso. Aj meyaj abe'e, u chucul u yet'oc a ch'ücbi u xiquin u men aj Pedrojo. —¿Ma' wa in wilajech ichil u cuuch a püc'aal etel a Jesusu?— cu t'an ti'i aj Pedrojo. ");
INSERT INTO mopNT_vpl VALUES ("JN18_27","073_18_27","JHN","18","27","27","Aj Pedrojo, u yadaj ti ma' le'ec tucaye'ili. Tu seebal uchi u yawat aj t'ele. ");
INSERT INTO mopNT_vpl VALUES ("JN18_28","073_18_28","JHN","18","28","28","Pues te'i. U joc'sajoo' a Jesus ichil u yotoch aj Caifasa. U bensajoo' tu yotoch caj tuba que'en a gobernadoro. Top jatz'ca' to. Ala'oo'o, ma' ocoo' ichil u yotoch caji. Watac u fiestajiloo' u caal le'ec biq'uin ti walacoo' u c'ajsic biq'uin mani u yaj xa'num Dios ti ca'an yoc'oloo' uchi. Wa cuchi ocoo' ichil u yotoch caj, ma' cuchi tu paataloo' u janal ichil a fiesta abe'e. ");
INSERT INTO mopNT_vpl VALUES ("JN18_29","073_18_29","JHN","18","29","29","U men ma' ocoo'o, joq'ui aj gobernador Pilato ti t'an eteloo'. —Tzole'ex ten c'u' u sip'il a winic ada'a,— cu t'an ti'ijoo'. ");
INSERT INTO mopNT_vpl VALUES ("JN18_30","073_18_30","JHN","18","30","30","—Wa cuchi ma' yan u sip'ili, ma' cuchi ti talesaj tech,— cu t'anoo' ti'i. ");
INSERT INTO mopNT_vpl VALUES ("JN18_31","073_18_31","JHN","18","31","31","—Bense'ex inche'exe. Ca' a wile'ex biqui ti ca' a bete'ex jabix ti tz'iiba'an ichile'ex a ley a te'exe,— cu t'an aj Pilato ti'ijoo'o. —Ma' yan biqui ca' ti quimes a mac u men a ley incheche. Jadi' inchech jaj tech wa u quimil wa ma',— cu t'anoo' aj Israel ti'iji. ");
INSERT INTO mopNT_vpl VALUES ("JN18_32","073_18_32","JHN","18","32","32","Uchi abe' ti'i ca' manüc jabix ilic u yadaj a Jesus yoc'ol biqui ti bel u ca'a quimsabül tuwich u cruzil, y ma' ta'ach u quimsabül a mac u menoo' aj Israel tuwich cruz. ");
INSERT INTO mopNT_vpl VALUES ("JN18_33","073_18_33","JHN","18","33","33","Pues te'i. Oqui aj Pilato ichil u yotoch caj tucaye'il. U yadaj ca' c'ochesabüc a Jesusu. —¿Inchech wa u reyoo' aj Israele?— cu t'an u yaalbül a Jesusu. ");
INSERT INTO mopNT_vpl VALUES ("JN18_34","073_18_34","JHN","18","34","34","—¿Chen wa inchech tan a c'aatic ta junal, wa xan yan ulaac' mac u yadaj tech tin woc'ol?— cu t'an a Jesus ti uchi u nuucu. ");
INSERT INTO mopNT_vpl VALUES ("JN18_35","073_18_35","JHN","18","35","35","—Inene, ma' a tuclic ti aj Israelen. Le'ecoo' ilic a wetcaal eteloo' u noochil u yaj mansaj t'an a cristiano ti'i a Dioso, le'ecoo' ilic u c'ubajech ten. ¿C'u' a sip'il?— cu t'an aj Pilato ti'iji. ");
INSERT INTO mopNT_vpl VALUES ("JN18_36","073_18_36","JHN","18","36","36","—Inene, reyen, pero ma' ti'i a wa'ye' yoc'olcabi,— cu t'an a Jesusu. —Wa cuchi reyen yoc'olcaba, le'ec boon a cristiano a tene, jede'ecoo' cuchi u p'isbaj ti'i ma' in müchbül u menoo' aj Israele. C'u' betiqui, ma' reyen ti'i a yoc'olcabi,— cu t'an a Jesus ti uchi u nuucu. ");
INSERT INTO mopNT_vpl VALUES ("JN18_37","073_18_37","JHN","18","37","37","—Reyech inchech ti baalo',— cu t'an aj Pilato ti'iji. —Reyen ilic, jabix ilic ti tan a wadiqui. Yanajeen ti'i ca' in yee' a jaja, mentücü, udeen wa'ye' yoc'olcab. Boon a walac u tz'ocsic a jaja, walac u yubic in t'an,— cu t'an a Jesus ti'iji. ");
INSERT INTO mopNT_vpl VALUES ("JN18_38","073_18_38","JHN","18","38","38","—¿C'u' a jaja? Ma'ax c'u'i,— cu t'an aj Pilato ti'iji. Pues te'i. Le'ec ti jobi u yadic abe'e, joq'ui pach naj aj Pilato tuba que'enoo' aj Israele. —Ma' ilic in cüxtaj u sip'il ala'aji,— cu t'an aj Pilatojo. ");
INSERT INTO mopNT_vpl VALUES ("JN18_39","073_18_39","JHN","18","39","39","—C'u' betiqui, le'ec ti tane'ex a fiesta ti tane'ex a c'ajsic biq'uin ti mani u yaj xa'num Dios ti ca'an yoc'ol a uchben mamaa'e'exe, suque'ex ca' in chaa' jun tuul a preso te'exe. ¿Ma' wa qui' ta wiche'ex ca' in cha'e'ex a reyile'ex aj Israel?— cu t'an aj Pilato ti'ijoo'o. ");
INSERT INTO mopNT_vpl VALUES ("JN18_40","073_18_40","JHN","18","40","40","—Ma' ti c'ati ca' a chaa' a Jesusu. Ti c'ati ca' cha'büc aj Barrabasa,— cu t'anoo' ti'i ti chich. Le'ec aj Barrabasa, aj xuuch'. ");
INSERT INTO mopNT_vpl VALUES ("JN19_1","073_19_1","JHN","19","1","1","Pues te'i. Le'ec aj Pilatojo, u tz'aj ti jütz'bül a Jesus etel jatz'. ");
INSERT INTO mopNT_vpl VALUES ("JN19_2","073_19_2","JHN","19","2","2","Le'ecoo' a soldadojo, u jit'ajoo' a q'ui'ix ca' culac jabix corona. U tz'ajoo' tu pol a Jesusu. U tz'ajoo' a noc' a jabix u color ix yames yoc'ol a Jesusu. ");
INSERT INTO mopNT_vpl VALUES ("JN19_3","073_19_3","JHN","19","3","3","Binoo' tu taan a Jesus a soldadojo. —Inchech u reyoo' aj Israel. Ca' qui'ac a wool,— cu t'anoo' ti'i. Le'ecoo' a soldadojo, u loxajoo' a Jesusu. ");
INSERT INTO mopNT_vpl VALUES ("JN19_4","073_19_4","JHN","19","4","4","Pues te'i. Le'ec aj Pilatojo, ca' joq'ui u yila' a cristiano pach naj. —Ile'ex. Bel in quin tales a Jesus ta taane'ex ti'i ca' a wile'ex ti ma' in cüxtaj u sip'il,— cu t'an aj Pilato ti'ijoo'o. ");
INSERT INTO mopNT_vpl VALUES ("JN19_5","073_19_5","JHN","19","5","5","Pues te'i. Joq'ui a Jesus pach naj. Que'en a corona q'ui'ix tu pol. Que'en a noc' a jabix u color ix yames tu pach. —Ile'ex a winiqui,— cu t'an aj Pilato ti'ijoo'o. ");
INSERT INTO mopNT_vpl VALUES ("JN19_6","073_19_6","JHN","19","6","6","Le'ec u noochiloo' u yaj mansaj t'an a cristiano ti'i a Dioso, u yet'ocoo' a jabix soldado u yaj cananil u yotoch a Dioso, le'ec ca' u yilajoo' a Jesusu, cajoo' ti t'an ti chich. —Tz'a tuwich cruz. Tz'a tuwich cruz,— cu t'anoo' ti chich. —Ch'a'e'ex inche'ex a winic ada'a. Tz'aje'ex tuwich cruz. Ti'i ten inene, ma' yan u sip'il,— cu t'an aj Pilato ti'ijoo'o. ");
INSERT INTO mopNT_vpl VALUES ("JN19_7","073_19_7","JHN","19","7","7","—Yan to'on a leye. Ichil a ley abe'e, yan u quimil u men u tz'aj u bajil jabix u Mejen a Dioso,— cu t'anoo' ti'i. ");
INSERT INTO mopNT_vpl VALUES ("JN19_8","073_19_8","JHN","19","8","8","Le'ec ca' u yubaj c'u' u yadajoo' yoc'ol a Jesusu, mas saacaji aj Pilatojo. ");
INSERT INTO mopNT_vpl VALUES ("JN19_9","073_19_9","JHN","19","9","9","Oqui tucaye' ichil u yotoch caj. —¿Tuba tala'anech incheche?— cu t'an ti'i a Jesusu. C'u' betiqui, ma' uchi u nuuc a Jesusu. ");
INSERT INTO mopNT_vpl VALUES ("JN19_10","073_19_10","JHN","19","10","10","—¿Ma' wa bel a ca'a a nuucteen? ¿Ma' wa a weel ti yan in muc' in cha'eech ca' xiquech? Yan ilic in muc' in tz'a'eech ca' quimsabüquech tuwich a cruzil,— cu t'an aj Pilato ti'i u men ma' uchi u nuuc. ");
INSERT INTO mopNT_vpl VALUES ("JN19_11","073_19_11","JHN","19","11","11","—Incheche, ma' yan a muc' a tücaa'teen, wa cuchi ma' tz'abi tech u men a Dioso,— cu t'an a Jesus ti'i aj Pilatojo. —U men abe'e, le'ec mac u c'ubajen teche, le'ec a mas nooch u sip'ili,— cu t'an a Jesusu. ");
INSERT INTO mopNT_vpl VALUES ("JN19_12","073_19_12","JHN","19","12","12","Le'ec ca' u yubaj abe' aj Pilatojo, caji u cüxte biqui ca' u chaa' a Jesus ca' xi'ic. —Wa ca' chaa' u beel a Jesusu, ma' u yet'oquech a rey cuenta Romaji,— cu t'anoo' aj Israel ti chichi. —Ala'aji, tan u tz'eec u bajil jabix rey. Le'ec boon a walac u tz'eec u bajil ti reyili, le'ec u yettz'iiquil a rey cuenta Romaja,— cu t'anoo' aj Israel ti chichi. ");
INSERT INTO mopNT_vpl VALUES ("JN19_13","073_19_13","JHN","19","13","13","Le'ec ca' u yubaj abe' aj Pilatojo, u bensaj a Jesus pach naj. Tinlaji aj Pilato tu silla tuba walac u yil sip'il. Tusa'an tunich u c'aba' a te'iji. Gabata u c'aba' a te'i ichil a t'an hebreojo. ");
INSERT INTO mopNT_vpl VALUES ("JN19_14","073_19_14","JHN","19","14","14","C'ochi a chuunq'uini. Samalac yan a fiesta le'ec ti tan u c'ajsabül biq'uin ti mani u yaj xa'num Dios ti ca'an yoc'oloo' uchiji. Pues te'i. —Jeda'e'ex a rey, le'ec a Jesusu,— cu t'an aj Pilato ti'ijoo' aj Israele. ");
INSERT INTO mopNT_vpl VALUES ("JN19_15","073_19_15","JHN","19","15","15","—Quimes, quimes. Tz'a tuwich u cruzil,— cu t'anoo' ti chich. —¿Jede'ec wa in tz'eeque'ex a rey tuwich u cruzil?— cu t'an aj Pilato ti'ijoo'o. —Le'ec a rey cuenta Romaja, le'ec walac u tücaa'tico'on. Le'ec a Jesusu, ma' ti reyi,— cu t'anoo' u noochiloo' u yaj mansaj t'an a cristiano ti'i a Dioso. ");
INSERT INTO mopNT_vpl VALUES ("JN19_16","073_19_16","JHN","19","16","16","Aj Pilatojo, u c'ubaj a Jesus ti'ijoo' ti'i ca' tz'abüc tuwich u cruzil. ");
INSERT INTO mopNT_vpl VALUES ("JN19_17","073_19_17","JHN","19","17","17","Pues te'i. U bensajoo'. Tan u c'oochtic u cruzil ti joq'ui pach naj a Jesusu. U pol quimen u c'aba' tuba tan u bensabül. Golgota u c'aba' a te'i ichil a t'an hebreojo. ");
INSERT INTO mopNT_vpl VALUES ("JN19_18","073_19_18","JHN","19","18","18","Te'i u tz'ajoo' a Jesus tuwich u cruzil. U tz'ajoo' ilic ca' tuul ti preso tuwich cruz a jujun tuul jujun xeel a Jesusu. P'aati a Jesus chumuquil. ");
INSERT INTO mopNT_vpl VALUES ("JN19_19","073_19_19","JHN","19","19","19","Pues te'i. Uchi u tz'iib aj Pilatojo. —A Jesusu, tala'an ich caj Nazaret. Ala'aji, u reyoo' aj Israel,— cu t'an a t'an a tz'iiba'an jabix cuchi u sip'il ala'aji. U tz'ajoo' c'u' u tz'iibtaj tuwich u cruzil a Jesusu. ");
INSERT INTO mopNT_vpl VALUES ("JN19_20","073_19_20","JHN","19","20","20","Yanoo' aj Israel u xocajoo' a tz'iib abe'e, u men ma' naach chi' caj tuba tz'abi a Jesus tuwich u cruzili. Ox paay u wich a t'an a tz'iiba'ana, hebreo etel latin etel griego. ");
INSERT INTO mopNT_vpl VALUES ("JN19_21","073_19_21","JHN","19","21","21","Le'ecoo' u noochil u yaj mansaj t'an a cristiano ti'i a Dioso, u yadajoo' ti'i aj Pilato: —Ma' toj a tz'iibtaji. A tz'iibtaj ti le'ec ala'aji, ti rey ino'on aj Israelo'ono. Mas toj ca' a tz'iibte “Inen u reyoo' aj Israele, cu t'an a winic ada'a.” Baalo' ca' a tz'iibte yoc'ol a Jesusu,— cu t'anoo' aj Israel ti'iji. ");
INSERT INTO mopNT_vpl VALUES ("JN19_22","073_19_22","JHN","19","22","22","—Le'ec a c'u' in tz'iibtaja, p'aati ti baalo',— cu t'an aj Pilato ti uchi u nuuc. ");
INSERT INTO mopNT_vpl VALUES ("JN19_23","073_19_23","JHN","19","23","23","Pues te'i. Le'ecoo' a soldadojo, le'ec ti joboo' u tz'eec a Jesus tuwich u cruzili, cajoo' u t'oxo' u noc' a Jesus ti cuatro xeet'. Jujun xeet' ti a jujun tuul a soldadojo. C'u' betiqui, top quich'pan jun tziil u noc'o. Jit'a'an ich jun tuutz. Ma' yan u chuyulal. ");
INSERT INTO mopNT_vpl VALUES ("JN19_24","073_19_24","JHN","19","24","24","—Ma' qui' ca' ti tzili'. Co'ne'ex ti baxül bul, ca' ti wile'ex mac ca' u ti'alte,— cu t'anoo' tu bajil. Uchi ti baalo' jabix ilic ti tz'iiba'an ichil u ju'um a Dioso. —U xet'ajoo' in noc' tu bajiloo'. U baxültaj a bul yoc'lal in noc',— cu t'an a t'an a tz'iiba'an ichil u ju'um a Dioso. ");
INSERT INTO mopNT_vpl VALUES ("JN19_25","073_19_25","JHN","19","25","25","Le'ecoo' a soldadojo, u betajoo' ilic ti baalo'. Pues te'i. Nütz'a'an tzeel u cruz a Jesusu, te'i wa'anoo' u na', u quic u na', ixna' Maria le'ec u yütan aj Cleofas y ixna' Maria Magdalena. ");
INSERT INTO mopNT_vpl VALUES ("JN19_26","073_19_26","JHN","19","26","26","Le'ec a Jesusu, u yilaj nütz'a'an ti wa'an u na' te'i u yet'oc u yaj cambal a top yaj u yubi. Le'ec ca' u yilajoo'o, u yadaj ti'i u na': —Nooch'up, c'ümü in waj cambal ado' jabix ilic a wal,— cu t'an ti'i u na'. ");
INSERT INTO mopNT_vpl VALUES ("JN19_27","073_19_27","JHN","19","27","27","Ca' tun u yadaj ti'i u yaj cambal: —Cününte ala'i jabix ilic a na',— cu t'an ti'i. Aj cambal abe'e, ti'i ilic a q'uin abe'e, u bensaj u na' a Jesus tu pach tu yotoch. ");
INSERT INTO mopNT_vpl VALUES ("JN19_28","073_19_28","JHN","19","28","28","Pues te'i. Pachili, le'ec a Jesusu, u yeel ti jobi u bete' u meyaj. —Uc'ajen,— cu t'an ti'i ca' uchuc jabix ilic ti tz'iiba'an ichil u ju'um a Dioso. ");
INSERT INTO mopNT_vpl VALUES ("JN19_29","073_19_29","JHN","19","29","29","Yan a p'uul te'i. Tuda'an etel a vino a top ema'an u toolo. U tudesajoo' jun p'eel ba'al a jabix tümün etel a vino abe'e. U tz'ajoo' tu ni' che' u c'aba' hisopo. U tz'ajoo' tu chi' a Jesusu. ");
INSERT INTO mopNT_vpl VALUES ("JN19_30","073_19_30","JHN","19","30","30","—Jobi tun in meyaj,— cu t'an a Jesus le'ec ti jobi u yuq'uic a vino abe' a tz'abi ti'iji. U chincuntaj u pol. Quimi. ");
INSERT INTO mopNT_vpl VALUES ("JN19_31","073_19_31","JHN","19","31","31","Pues te'i. Samalac yan a fiestaja. Ma' u c'atoo' ca' culacoo' a winic tuwich u cruzil ti u q'uinil a jedel abe'e, u men nojq'uin tu jajil. Le'ecoo' aj Israele, u c'aatajoo' ti'i aj Pilato ca' cüchbücoo' u yoc a winic yoc'ol ca' quimicoo' ti jomol ti'i ca' paatacoo' u yemsic. ");
INSERT INTO mopNT_vpl VALUES ("JN19_32","073_19_32","JHN","19","32","32","Pues te'i. C'ochoo' a soldadojo. U cüchajoo' u yoc a jun tuulu. Baalo' ilic u betajoo' ti'i ulaac' a jun tuulu. Que'enoo' tuwich u cruzil a jujun tuulu. ");
INSERT INTO mopNT_vpl VALUES ("JN19_33","073_19_33","JHN","19","33","33","C'u' betiqui, le'ec ti c'ochoo' etel a Jesusu, u yilajoo' ti quimen tun, mentücü, ma' u cüchajoo' u yoc. ");
INSERT INTO mopNT_vpl VALUES ("JN19_34","073_19_34","JHN","19","34","34","Jun tuul a soldadojo, jadi' u lomaj a Jesus tu tzeel u nüc'ü. Tu seebal joq'ui a q'uic' etel a ja'a. ");
INSERT INTO mopNT_vpl VALUES ("JN19_35","073_19_35","JHN","19","35","35","Le'ec a mac u yilaj abe'e, testigo yoc'ol abe'e. Jaj u t'an. U yeel ti jaj a tan u yadic ti'i ca' a tz'ocse'exe. ");
INSERT INTO mopNT_vpl VALUES ("JN19_36","073_19_36","JHN","19","36","36","Uchi ti baalo' ti'i ca' uchuc jabix ilic ti tz'iiba'an ichil u ju'um a Dioso. —Ma'ax jun tziit u baquel a bel u ca'a cüchbülü,— cu t'an a t'an a tz'iiba'an ichil u ju'um a Dioso. ");
INSERT INTO mopNT_vpl VALUES ("JN19_37","073_19_37","JHN","19","37","37","—Beloo' u cu cha'ante a winic abe'e, le'ec u lomajoo'o,— cu t'an ulaac' a t'an a tz'iiba'ana. ");
INSERT INTO mopNT_vpl VALUES ("JN19_38","073_19_38","JHN","19","38","38","Pues te'i. Le'ec aj Jose a tala'an ich caj Arimateaja, que'en u yool tu pach a Jesus chen ich mucul u men saac ti'ijoo' u chucaan aj Israele. U c'aataj ti'i aj Pilato ca' tz'abüc ti'i ca' u ch'aa' u büq'uel a Jesusu. Le'ec aj Pilatojo, u tz'aj ti'i. ");
INSERT INTO mopNT_vpl VALUES ("JN19_39","073_19_39","JHN","19","39","39","C'ochi ilic aj Nicodemojo. Le'ec ala'aji, u sutintaj a Jesus ti ac'ü' biq'uin ado'o. U talesaj jabix wal jun p'e quintal a boco. Mirra xaaba'an aloes u c'aba' u talesaja. ");
INSERT INTO mopNT_vpl VALUES ("JN19_40","073_19_40","JHN","19","40","40","U ch'a'ajoo' u büq'uel a Jesusu. U bülajoo' etel süc noc' etel a boc jabix ilic ti sucoo' u bete' aj Israele. ");
INSERT INTO mopNT_vpl VALUES ("JN19_41","073_19_41","JHN","19","41","41","Le'ec tuba quimsabi a Jesus tuwich u cruzili, nütz'a'an te'iji, yan u cuuch a püc'aala. Ichil abe' que'en jun p'eel a naj tunich ti'i a quimene. Tumul betabi to. Ma'ax mac a muucuc ichili. ");
INSERT INTO mopNT_vpl VALUES ("JN19_42","073_19_42","JHN","19","42","42","U coyquintajoo' u büq'uel a Jesus te'i u men nütz'a'an ta wichi, etel u men top nütz'a'an u yocol a q'uini. Le'ec ca' ococ a q'uini, ac caji tun u q'uinil a jedel ti'ijoo'o. ");
INSERT INTO mopNT_vpl VALUES ("JN20_1","073_20_1","JHN","20","1","1","Pues te'i. Jatz'ca' ti Domingo ma'ax to sasac, c'ochi ixna' Maria Magdalena ti a naj tunich tuba mucbi a Jesusu. U yilaj ti joc'a'an a tunichi, le'ec u c'al u chi' a naj tunichi, ");
INSERT INTO mopNT_vpl VALUES ("JN20_2","073_20_2","JHN","20","2","2","mentücü, joq'ui ti alca'. Bini etel aj Simon Pedro y etel aj cambal a yajtzil u men a Jesusu. —U joc'sajoo' a Noochtzil ichil a naj tunich tuba mucbiji. Ma' ti weel tuba u coyquintajoo',— cu t'an ixna' Maria ti'ijoo'o. ");
INSERT INTO mopNT_vpl VALUES ("JN20_3","073_20_3","JHN","20","3","3","Joq'ui aj Pedro u yet'oc aj cambal abe'e. Cajoo' ti beel ti'i a naj tunich tuba mucbi a Jesusu. ");
INSERT INTO mopNT_vpl VALUES ("JN20_4","073_20_4","JHN","20","4","4","Tanoo' u yalca. Le'ec aj cambal abe'e, mas chich u yalca' tuwich aj Pedro. Payanbej c'ochi yanil a naj tunich abe'e. ");
INSERT INTO mopNT_vpl VALUES ("JN20_5","073_20_5","JHN","20","5","5","T'uchlaji u cha'ante ichil. U yilaj a noc' u tepbeeb a Jesusu, que'en ichil. C'u' betiqui, ma' oqui ichil. ");
INSERT INTO mopNT_vpl VALUES ("JN20_6","073_20_6","JHN","20","6","6","Pues te'i. C'ochi aj Simon Pedro pachil. Oqui tac ichil a naj tunich tuba mucbi a Jesusu. U yilaj a noc' u tepbeeb a Jesus te'iji. ");
INSERT INTO mopNT_vpl VALUES ("JN20_7","073_20_7","JHN","20","7","7","U yilaj ti ma' que'en u tepbeeb u pol etel u chucaan a noc'o. Wutza'an ti que'en tu junal. ");
INSERT INTO mopNT_vpl VALUES ("JN20_8","073_20_8","JHN","20","8","8","Le'ec aj cambal a payanbej c'ochi ti a naj tunichi, oqui ilic ichil tu pach aj Pedrojo. Le'ec a oqui pachili, u tz'ocsaj ti ca' cuxlaji a Jesus u men c'u' u yilaja. ");
INSERT INTO mopNT_vpl VALUES ("JN20_9","073_20_9","JHN","20","9","9","Asto uchi tac ti a q'uin abe'e, ma' u ch'a'ajoo' u tojil c'u' a tz'iiba'an ichil u ju'um a Dios ti yan u ca' cuxtal a Jesus tu yaamoo' a quimene. ");
INSERT INTO mopNT_vpl VALUES ("JN20_10","073_20_10","JHN","20","10","10","Pachili, usc'ajoo' tu yotoch aj cambal abe'e. ");
INSERT INTO mopNT_vpl VALUES ("JN20_11","073_20_11","JHN","20","11","11","Pues te'i. Le'ec ixna' Mariaja, tan u yoc'ol te'i pach a naj tunich tuba mucbi a Jesusu. Tan ilic u yoc'ol ti t'uchlaji u cha'ante a ichili. ");
INSERT INTO mopNT_vpl VALUES ("JN20_12","073_20_12","JHN","20","12","12","U yilaj ca' tuul u yaj xa'num a Dios ti ca'an a tina'an tuba culaji a Jesusu. Sücoo' u noc'. Jun tuul tuba culaji u pol. Jun tuul tuba culaji u yoc. ");
INSERT INTO mopNT_vpl VALUES ("JN20_13","073_20_13","JHN","20","13","13","—Nooch'up, ¿c'u' ca'a tan a woc'ol?— cu t'anoo' ti'i. —U men u ch'a'ajoo' in Noochil, y ma' in weel tuba u coyquintajoo',— cu t'an ti'ijoo'. ");
INSERT INTO mopNT_vpl VALUES ("JN20_14","073_20_14","JHN","20","14","14","Le'ec ti jobi u yadic abe'e, u sutaj u bajil a nooch'upu. U yilaj a Jesusu. Wa'an ti que'en. C'u' betiqui, ma' u c'aj-ooltaj u wich. ");
INSERT INTO mopNT_vpl VALUES ("JN20_15","073_20_15","JHN","20","15","15","—Nooch'up, ¿c'u' ca'a tan a woc'ol? ¿Mac a tan a cüxtiqui?— cu t'an a Jesus ti'iji. Ix Mariaja, u tuclaj ti le'ec ala'aji, aj cünün cuuch püc'aal te'i. —Noochwinic, wa inchech a ch'a'aj a quimene, adü ten tuba a coyquintaj. Inene, bel in quin ch'aa',— cu t'an ti'i a winiqui. ");
INSERT INTO mopNT_vpl VALUES ("JN20_16","073_20_16","JHN","20","16","16","—Maria,— cu t'an a Jesus ti'iji. U sutaj u bajil u cha'ante a Jesusu. Caji ti t'an ichil a t'an hebreojo. —Raboni,— cu t'an ti'i a Jesusu. Le'ec u nu'cul a t'an abe'e, —maestro,— cu t'an ti'i. ");
INSERT INTO mopNT_vpl VALUES ("JN20_17","073_20_17","JHN","20","17","17","—Ma' a müchiquen u men ma'ax to nac'üquen etel a Tattzili. Ca' xiquech a wadü' ti'ijoo' in wet'oc: “Bel in ca'a ti nac'ül etel in Tat inene, le'ec ilic a Tat incheche, y le'ec ilic u Tat ala'oo'o. Le'ec in Tata, le'ec ilic in Dios inene, le'ec ilic a Dios incheche, y le'ec ilic u Dios ala'oo'o.” Baalo' ca' a wadü' ti'ijoo',— cu t'an a Jesus ti'iji. ");
INSERT INTO mopNT_vpl VALUES ("JN20_18","073_20_18","JHN","20","18","18","Le'ec ixna' Maria Magdalenaja, bini eteloo' u yaj cambal a Jesusu. —In wilaj a Noochtzili,— cu t'an ti'ijoo'. U yadaj ti'ijoo' tulacal boon a aalbi ti'iji. ");
INSERT INTO mopNT_vpl VALUES ("JN20_19","073_20_19","JHN","20","19","19","Pues te'i. Ti'i ilic a Domingo abe'e, te'i que'enoo' u yaj cambal a Jesus ichil jun p'eel cuartojo. Ocq'uin tun. C'üla'an a puerta u men u saaquil ti'ijoo' u yetcaal aj Israele. C'ochi a Jesusu. Chen u yilajoo'o, ac wa'an tu yaamoo'. —Jetz'a'anaque'ex a wool,— cu t'an ti'ijoo' u men baalo' ti walac u chiiticoo'. ");
INSERT INTO mopNT_vpl VALUES ("JN20_20","073_20_20","JHN","20","20","20","Le'ec ti jobi u yadic abe'e, u ye'aj ti'ijoo' u p'is tu c'ü' y tu tzeel u nüc' tuba yajcunbi. Le'ec ca' u yilajoo' abe'e, qui'oo' u yool u men u yilajoo' a Noochtzili. ");
INSERT INTO mopNT_vpl VALUES ("JN20_21","073_20_21","JHN","20","21","21","—Jetz'a'anaque'ex a wool,— cu t'an a Jesus ti'ijoo' tucaye'il. —Jabix ilic ca' u tücaa'tajen a Tattzili, baalo' ilic tan in tücaa'tique'ex aleebe,— cu t'an ti'ijoo'. ");
INSERT INTO mopNT_vpl VALUES ("JN20_22","073_20_22","JHN","20","22","22","Le'ec ti jobi u yadic abe'e, u yuustaj u yic' yoc'oloo' u yaj cambal. —C'üme'ex u Püsüc'al a Dioso,— cu t'an ti'ijoo' u yaj cambal. ");
INSERT INTO mopNT_vpl VALUES ("JN20_23","073_20_23","JHN","20","23","23","—Inche'exe, wa ca' a sa'tese'ex u sip'il a maca, ac sa'tesabi ti'i ala'aji. Wa ma' ta sa'tesique'ex u sip'il a maca, ma' sa'tesabi ti'i,— cu t'an a Jesus ti'ijoo'o. ");
INSERT INTO mopNT_vpl VALUES ("JN20_24","073_20_24","JHN","20","24","24","Pues te'i. Le'ec aj Tomasa, —C'uj,— cu t'anoo' ti'i. Ala'aji, u yaj cambal a Jesus jabix ilic u chucaan a once tuulu. Ma' que'en ala'i eteloo' ti c'ochi a Jesus tu yaamoo'o. ");
INSERT INTO mopNT_vpl VALUES ("JN20_25","073_20_25","JHN","20","25","25","—Ti wilaj a Noochtzili,— cu t'an u yaalbül aj Tomas u menoo' u chucaan u yaj cambal a Jesusu. —Wa ma' tin wilic u p'is a clavo tu c'ü'ü, y in juquic u ni' in c'ü' ichili, ma' tin tz'ocsic. Wa ma' tin juquic in c'ü' ichil u p'is tu tzeel u nüc'ü, ma' tin tz'ocsic,— cu t'an aj Tomas ti'ijoo'o. ");
INSERT INTO mopNT_vpl VALUES ("JN20_26","073_20_26","JHN","20","26","26","Pues te'i. Ocho q'uin manüc ti ca' much'lajoo' tucaye'il u yaj cambal a Jesus ich naja. Que'en aj Tomas tu yaamoo'o. C'üla'an a puertaja. C'ochi a Jesusu. Chen u yilajoo'o, ac wa'an tu yaamoo'. —Jetz'a'anaque'ex a wool,— cu t'an ti'ijoo' jabix ti walac u chiiticoo'. ");
INSERT INTO mopNT_vpl VALUES ("JN20_27","073_20_27","JHN","20","27","27","—Ila in c'ü',— cu t'an ti'i aj Tomasa. —Jucu u ni' a c'ü' ichil. Jucu a c'ü' ichil a potol tu tzeel in nüc'. Ma' a betic wa ma' tan a tz'ocsic. Tz'oques ti ca' cuxlajeen,— cu t'an a Jesus ti'i aj Tomasa. ");
INSERT INTO mopNT_vpl VALUES ("JN20_28","073_20_28","JHN","20","28","28","—In Noochil, inchech in Dios,— cu t'an ti'i. ");
INSERT INTO mopNT_vpl VALUES ("JN20_29","073_20_29","JHN","20","29","29","—A tz'ocsaj u men a wilajen. Qui'oo' u yool boon tuul tanoo' u tz'ocsiquen ca'ax ma' u yilajoo' in wich,— cu t'an a Jesusu. ");
INSERT INTO mopNT_vpl VALUES ("JN20_30","073_20_30","JHN","20","30","30","Pues te'i. Yaab ulaac' a milagro u betaj a Jesus tu taanoo' u yaj cambal a ma' tz'iiba'an ichil a ju'um ada'a. ");
INSERT INTO mopNT_vpl VALUES ("JN20_31","073_20_31","JHN","20","31","31","C'u' betiqui, le'ec boon a milagro a tz'iiba'an wa'ye'e, tz'iiba'an ti'i ca' a tz'ocse'ex ti le'ec a Jesusu, le'ec u yaj Sa'alil a cristianojo. Ala'aji, u Mejen a Dioso. Ca' a tz'ocse'ex ti baalo', yan te'ex a cuxtal a ma' yan q'uin u jobol u men que'ene'ex a wool tu pach a Jesusu. ");
INSERT INTO mopNT_vpl VALUES ("JN21_1","073_21_1","JHN","21","1","1","Pues te'i. U ca' ye'aj u bajil a Jesus ti'ijoo' u yaj cambal tucaye'il chi' a laguna u c'aba' Tiberias. Baala' ca' u ye'aj u bajil. ");
INSERT INTO mopNT_vpl VALUES ("JN21_2","073_21_2","JHN","21","2","2","Le'ec aj Simon Pedrojo, que'en etel aj Tomasa. —C'uj,— cu t'anoo' ti'i aj Tomasa. Que'en ilic te'i aj Natanael a tala'an ich caj Cana a que'en ich cuenta Galilea. Que'enoo' ilic te'i u mejenoo' aj Zebedeo u yet'oc ca' tuul ulaac' u yaj cambal a Jesusu. ");
INSERT INTO mopNT_vpl VALUES ("JN21_3","073_21_3","JHN","21","3","3","—Bel in ca'a ti jooc',— cu t'an aj Simon Pedro ti'ijoo'o. —Bel ilic ti ca'a ta pach,— cu t'anoo' ti'i. Binoo'. Ocoo' ichil a barcojo. C'u' betiqui, tulacal ac'ü' ma'ax jun tuul u jooc'tajoo'. ");
INSERT INTO mopNT_vpl VALUES ("JN21_4","073_21_4","JHN","21","4","4","Pues te'i. Tan to u jaabül a yoc'olcaba. Wa'an ti que'en a Jesus chi' a ja'a. Le'ecoo' u yaj cambala, ma' u yeeloo' wa le'ec. ");
INSERT INTO mopNT_vpl VALUES ("JN21_5","073_21_5","JHN","21","5","5","—Dioos. ¿Uche'ex wa a jooc'? ¿Paataje'ex wa?— cu t'an a Jesus ti'ijoo'o. —Ma'. Ma' yan,— cu t'anoo' ti'i. ");
INSERT INTO mopNT_vpl VALUES ("JN21_6","073_21_6","JHN","21","6","6","Yan ti'ijoo' a chinchor walaquil u müch ch'ilam. —Tz'aje'ex ich ja' tu yaj toj tu yaj seeb a barco a chinchoro. Te'i a müchique'ex aj ch'ilama,— cu t'an a Jesus ti'ijoo'o. U tz'ajoo' te'i. Le'ec ca' u yaaltajoo' u ch'uyte u müchbeeb aj ch'ilama, ma' pataloo' u yoques ich barco u men u yaabil aj ch'ilama. ");
INSERT INTO mopNT_vpl VALUES ("JN21_7","073_21_7","JHN","21","7","7","Le'ec u yaj cambal a Jesus a top yajtzili, u yadaj ti'i aj Pedro: —Le'ec ado' a Noochtzili,— cu t'an. Aj Simon Pedrojo, aj pitnoc' ti tan u meyaj. Ca' u yubaj ti ala'i a Noochtzili, u tz'aj u noc' yoc'ol ca' tun u pulaj u bajil ti baxülja' tac chi' a ja'a. ");
INSERT INTO mopNT_vpl VALUES ("JN21_8","073_21_8","JHN","21","8","8","Le'ecoo' u chucaan u yaj cambal a Jesusu, ich barco c'ochoo' tu chi' a ja'a. Ma' naach chi' ja' que'en a barcojo. Jabix wal cuatro c'aan u naachil. Tanoo' u jiiltic a chinchor ti tanoo' u beele. Tuda'an a chinchoro. ");
INSERT INTO mopNT_vpl VALUES ("JN21_9","073_21_9","JHN","21","9","9","Pues te'i. Le'ec ti c'ochoo' tu chi' a ja'a, u yilajoo' a c'aac' te'iji. T'üba'an etel chuuc. Tan u c'aac'tic aj ch'ilama. Yan a pan te'iji. ");
INSERT INTO mopNT_vpl VALUES ("JN21_10","073_21_10","JHN","21","10","10","—Talese'ex ca' tuul ox tuulac aj ch'ilam a müchaje'ex tojo,— cu t'an a Jesus ti'ijoo'o. ");
INSERT INTO mopNT_vpl VALUES ("JN21_11","073_21_11","JHN","21","11","11","Pues te'i. Le'ec aj Simon Pedrojo, ca' oqui ichil a barcojo. U jiiltaj a chinchor tu chi' a ja'a. Yan ciento cincuenta y tres tuul aj nucuch ch'ilam ichili, pero ma' t'uupi a chinchoro. ");
INSERT INTO mopNT_vpl VALUES ("JN21_12","073_21_12","JHN","21","12","12","Pues te'i. —Co'ne'ex ti janal,— cu t'an a Jesus ti'ijoo'o. Ma'ax mac tu yaamoo' u c'aataj mac ala'aji, u men u yeeloo' ti le'ec a Noochtzili. ");
INSERT INTO mopNT_vpl VALUES ("JN21_13","073_21_13","JHN","21","13","13","C'ochi a Jesus tu chi' a c'aac'a. U müchaj a pana. U t'oxaj ti'ijoo'. Baalo' ilic u betaj etel aj ch'ilama. ");
INSERT INTO mopNT_vpl VALUES ("JN21_14","073_21_14","JHN","21","14","14","Le'ec abe' u yox sut u yee' u bajil a Jesus ti'ijoo' u yaj cambal ti ca' cuxlaji tu yaamoo' a quimene. ");
INSERT INTO mopNT_vpl VALUES ("JN21_15","073_21_15","JHN","21","15","15","Pues te'i. Le'ec ti joboo' ti janala, caji ti t'an a Jesus etel aj Simon Pedrojo. —Simon, u mejenech aj Jonas, ¿mas yaj wa a wu'yeen tuwichoo' ala'oo'o?— cu t'an a Jesus ti'iji. —Baalo' Noochil, a weel ti ti wet'oc ti bajil,— cu t'an ti'i. —Cününtoo' boon a cajoo' to u tz'ocseene, jabix ilic ti walac u cününbül a tz'i' carnerojo,— cu t'an a Jesusu. ");
INSERT INTO mopNT_vpl VALUES ("JN21_16","073_21_16","JHN","21","16","16","U ca' sut u c'aataj ti'i. —Simon, u mejenech aj Jonas, ¿yaj wa a wu'yeen?— cu t'an a Jesus ti'iji. —Baalo' Noochil, a weel ti ti wet'oc ti bajil,— cu t'an ti'i. —Cününtoo' boon a walacoo' u tz'ocsiquene, jabix ti walac u cününbül a carnerojo,— cu t'an a Jesus ti'iji. ");
INSERT INTO mopNT_vpl VALUES ("JN21_17","073_21_17","JHN","21","17","17","U yox sut u c'aataj ti'i. —Simon, u mejenech aj Jonas, ¿ti wet'oc wa ti bajil?— cu t'an ti'i. Yajaji u yool aj Pedro u men c'aatbi ti'i ox sut wa yaj u yubi a Jesusu. —Noochil, a weel tulacal. A weel ti ti wet'oc ti bajil,— cu t'an ti'i a Jesusu. —Cününtoo' boon a walac u tz'ocsiquene, jabix ti walac u cününbül a carnerojo,— cu t'an a Jesus ti'iji. ");
INSERT INTO mopNT_vpl VALUES ("JN21_18","073_21_18","JHN","21","18","18","—Tan in wadic tech u jajil. Le'ec ti ch'ajomech tojo, a jelaj a bajil ca' tun bineech le'ec a tuba a c'ati a beele. C'u' betiqui, le'ec ti noochwinicaquech ti qui'i, bel a ca'a a sützü' a c'ü'ü. Ulaac' mac bel u cu jelech. Bel a ca'a bensabül le'ec a tuba ma' a c'ati a beele,— cu t'an a Jesus ti'i aj Pedrojo. ");
INSERT INTO mopNT_vpl VALUES ("JN21_19","073_21_19","JHN","21","19","19","U yadaj abe'e, ti'i ca' u yee' ti'i biqui ti bel u ca'a ti quimil. Ichil u quimeeb, bel u cu yee' u qui'il a Dioso. Jobi u yadic abe'e. —Co'ox tin pach,— cu t'an a Jesus ti'i aj Pedrojo. ");
INSERT INTO mopNT_vpl VALUES ("JN21_20","073_21_20","JHN","21","20","20","Pues te'i. Le'ec aj Pedrojo, uchi u cha'an tu pach. U yilaj ti tücünac aj cambal a top yajtzil u men a Jesus tu pachoo'o. Le'ec aj cambal abe'e, le'ec ilic a nütz'a'an ti janal ti ocq'uin tu tzeel a Jesus biq'uin ado'o. —Noochil, ¿mac bel u cu tzoleech?— cu t'an ilic a yajtzil abe' ti'i a Jesus biq'uin ado'o. ");
INSERT INTO mopNT_vpl VALUES ("JN21_21","073_21_21","JHN","21","21","21","Pues te'i. Le'ec aj Pedrojo, le'ec ca' u yilaj ala'aji, u yadaj ti'i a Jesusu: —Noochil, ¿uxtun a winic ado'o? ¿Biqui tun ti bel u ca'a ti quimil ala'aji?— cu t'an ti'i a Jesusu. ");
INSERT INTO mopNT_vpl VALUES ("JN21_22","073_21_22","JHN","21","22","22","—Wa qui' tin wich ca' culac ala'i asto ti ca' uduquen tucaye'ili, ¿c'u' a t'an ti'i? Co'ox tin pach,— cu t'an a Jesus ti'i aj Pedrojo. ");
INSERT INTO mopNT_vpl VALUES ("JN21_23","073_21_23","JHN","21","23","23","Pues te'i. T'iit'i u pectzil tu yaamoo' boon a que'enoo' u yool tu pach a Jesus ti ma' tu quimil aj cambal abe'e. C'u' betiqui, ma' baalo' u yadaji. —Wa qui' tin wich ca' culac ala'i asto ti ca' uduquen tucaye'ili, ¿c'u' a t'an ti'i?— cu t'an a Jesusu. Jadi' u yadaja. ");
INSERT INTO mopNT_vpl VALUES ("JN21_24","073_21_24","JHN","21","24","24","Pues te'i. Le'ec ilic aj cambal abe'e, le'ec ilic tan u ye'ic c'u' u yilaja. Le'ec ilic u tz'iibtaj a ju'um ada'a. Ti weel ti jaj u t'an. ");
INSERT INTO mopNT_vpl VALUES ("JN21_25","073_21_25","JHN","21","25","25","Yan ti yaab ulaac' a c'u' u betaj a Jesus a ma' tz'iiba'an wa'ye'e. Wa cuchi laj tz'iiba'an tulacal a boon u betaj a Jesusu, tin tuclic inene, ma' cuchi yan u chuuchil wa'ye' yoc'olcab. Wa'ye' jobi u tz'iib aj Juana.");
INSERT INTO mopNT_vpl VALUES ("AC1_1","074_1_1","ACT","1","1","1","Noochwinic Teofilo, in tz'iibtaj tech a ju'um biq'uin ado'o. Ichil abe'e, in tz'iibtaj tech tulacal a c'u' a caji u bete' y u yee' a Jesusu, ");
INSERT INTO mopNT_vpl VALUES ("AC1_2","074_1_2","ACT","1","2","2","asto ti c'ochi u q'uinil u ch'a'bül a Jesus ti ca'ana. Ac yeeta'anoo' tun u yaj xa'num u men a Jesusu. Le'ec ti tan u joc'olo, u yadaj ti'ijoo' c'u' a yan u beticoo'o. Albi ti'i a Jesus a t'an abe' u men u Püsüc'al a Dioso. ");
INSERT INTO mopNT_vpl VALUES ("AC1_3","074_1_3","ACT","1","3","3","Le'ec a Jesusu, u c'ümaj a yaja. Quimi. Le'ec ti ca' cuxlajiji, bini eteloo' u yaj xa'num. U yilajoo' ti cuxa'an tucaye'. Yaab c'u' u betaj a Jesus yoc'ol ca' u yeeltoo' ti cuxa'an tu jajil. Cuarenta q'uin que'en tu yaamoo'. Tan u tzicbaltic biqui ti walac u tücaa' a Dioso. ");
INSERT INTO mopNT_vpl VALUES ("AC1_4","074_1_4","ACT","1","4","4","Le'ec a Jesusu, le'ec ti que'en tu yaamoo' u yaj xa'numu, u yadaj ti'ijoo' ca' culacoo' ichil a caj Jerusalen. —Te'i a paac'tique'ex a jun tuul a watac jabix u yadaj a Tattzili. Baalo' ilic in wadaj te'ex biq'uin ado'o,— cu t'an a Jesus ti'ijoo'o. ");
INSERT INTO mopNT_vpl VALUES ("AC1_5","074_1_5","ACT","1","5","5","—Le'ec aj Juana, uchi u tz'aj ocja' chen etel ja' pero seeba'an u c'ochol u q'uinil ti bele'ex a ca'a a c'ümü' u Püsüc'al a Dios jabix uche'ex a wocja' etel,— cu t'an a Jesus ti'ijoo' u yaj xa'num. ");
INSERT INTO mopNT_vpl VALUES ("AC1_6","074_1_6","ACT","1","6","6","Pues te'i. Le'ec ti much'a'anoo' etel a Jesus u yaj xa'numu, u c'aatajoo' ti'i a Jesusu. —Ti Noochil, mücha'ano'on aj Israelo'on u menoo' ti wettz'iiquil. ¿Bel wa a ca'a a joc'soo' tiqui yaam aleebe?— cu t'anoo' ti'i a Jesusu. ");
INSERT INTO mopNT_vpl VALUES ("AC1_7","074_1_7","ACT","1","7","7","—Inche'exe, ma' yan c'u' ca'a ca' a weelte'ex u q'uinil u yuchul c'u' a tane'ex a c'aatiqui, ma'ax u yorajil biq'uin u yuchul. Abe'e, le'ec jaj ti'i a Tattzili. Ac yeeta'an u q'uinil u men ala'i c'u' a uchul u ca'aja,— cu t'an a Jesus ti'ijoo' u yaj xa'num. ");
INSERT INTO mopNT_vpl VALUES ("AC1_8","074_1_8","ACT","1","8","8","—Yan a c'u' a mas tzaj ca' a weelte'exe,— cu t'an a Jesus ti'ijoo' ala'oo'o. —Le'ec ca' c'ochoc u Püsüc'al a Dios ta wetele'exe, tz'abül u ca'a u muq'ue'ex a t'an ti'i ca' a tzicbalteene'ex ti'i boon a que'en ich caj Jerusalen, tulacal cuenta Judea, cuenta Samaria y tulacal tubajac yoc'olcab,— cu t'an a Jesusu. ");
INSERT INTO mopNT_vpl VALUES ("AC1_9","074_1_9","ACT","1","9","9","Le'ec ti jobi u yadic abe'e, ch'a'bi ti ca'an a Jesusu. Le'ecoo' u yaj xa'numu, u yilajoo' ti tan u nac'ül a Jesusu. Tanoo' u cha'an asto ti mu'yi ich muyal. ");
INSERT INTO mopNT_vpl VALUES ("AC1_10","074_1_10","ACT","1","10","10","Le'ec ti tanoo' to u cha'antic a ca'an tuba mu'yi a Jesusu, ca' u yilajoo'o, jeda' tu tzeeloo' ca' tuul u yaj xa'num a Dios a tali ti ca'ana. Le'ec u noc' a ca' tuulu, süc tu jajil. ");
INSERT INTO mopNT_vpl VALUES ("AC1_11","074_1_11","ACT","1","11","11","' —Inche'ex a winic aj Galileajile'exe, ¿c'u' ca'a ti wa'ane'ex wa'ye'? ¿C'u' ca'a tane'ex a cha'antic a ca'ana? Ma' qui' c'u' a tane'ex a betiqui,— cu t'an a ca' tuul ti'ijoo' u yaj xa'num a Jesusu. —Joc'sabi a Jesus ta yaame'exe. Bini ti ca'an. Jabix ilic ca' a wilaje'ex ti bini ti ca'ana, baalo' ilic ca' ilbic ti ca' watac a Jesus tucaye'e,— cu t'an a ca' tuul ti'ijoo'. Despuese, binoo'. ");
INSERT INTO mopNT_vpl VALUES ("AC1_12","074_1_12","ACT","1","12","12","Pues te'i. Joc'oo' u yaj xa'num a Jesus tuwich a witz u c'aba' Olivos. Usc'ajoo' ich caj Jerusalen. Ma' yan jun p'e kilometro u naachil ti a caj abe'e. ");
INSERT INTO mopNT_vpl VALUES ("AC1_13","074_1_13","ACT","1","13","13","Le'ec ti ocoo' ichil a caja, binoo' ti a cuarto ich u ca' tzaam a naj tuba tanoo' u posado. Le'ec a que'enoo' te'iji, le'ec aj Pedro, aj Jacobo, aj Juan, aj Andres, aj Felipe, aj Tomas, aj Bartolome, aj Mateo, etel u chucaan, le'ec u mejen aj Alfeo, le'ec aj Jacobo. Yan ulaac', le'ec aj Simon Cananista etel aj Judas le'ec u yitz'in aj Jacobo. ");
INSERT INTO mopNT_vpl VALUES ("AC1_14","074_1_14","ACT","1","14","14","Tu yaamoo' abe'e, que'enoo' a nooch'upu. Tu yaamoo' a nooch'up que'en ixna' Maria le'ec u na' a Jesusu. Te'i que'enoo' u yitz'in a Jesus tu yaamoo'o. Jumbeloo' u tucul tulacaloo' abe'e. Tanoo' u t'an etel a Dios ti ca'ana. ");
INSERT INTO mopNT_vpl VALUES ("AC1_15","074_1_15","ACT","1","15","15","Pues te'i. Jun p'eel q'uin le'ec ti que'enoo' te'iji, much'a'anoo' ciento veinte tuuloo' u yet'oc. Wa'laji aj Pedro tu yaamoo'o. ");
INSERT INTO mopNT_vpl VALUES ("AC1_16","074_1_16","ACT","1","16","16","—Hermanoje'ex,— cu t'an ti'ijoo'. —Yan u yuchul c'u' a tz'iiba'an ichil u ju'um a Dioso. Uchi aj quimen Davidi, u tz'iibtaj c'u' a albi ti'i u men u Püsüc'al a Dioso. U tz'iibtaj c'u' a bel u cu bete' aj Judasa. Aj Judasa, u yaantajoo' a mac u müchajoo' a Jesusu,— cu t'an aj Pedro ti'ijoo'o. ");
INSERT INTO mopNT_vpl VALUES ("AC1_17","074_1_17","ACT","1","17","17","—Le'ec aj Judasa, ti wetmeyaj u men yeetbi jabix ilic ino'ono,— cu t'an. ");
INSERT INTO mopNT_vpl VALUES ("AC1_18","074_1_18","ACT","1","18","18","—Le'ec aj Judasa, u conaj a Jesusu. Etel a taq'uin u c'ümaja, q'uexbi a lu'umu. Püca'an ti c'axi aj Judas ti lu'umu. Jeeti u nüc'. Joq'ui u chulunta',— cu t'an. ");
INSERT INTO mopNT_vpl VALUES ("AC1_19","074_1_19","ACT","1","19","19","—Le'ec ti ca' u yubajoo' aj caj Jerusalene, u tz'ajoo' u c'aba' a lu'um abe' ti Aceldama ichiloo' u t'an. Le'ec u nu'cul a t'an abe'e, “tuba joq'ui u q'uiq'uel a maca,”— cu t'an aj Pedrojo. ");
INSERT INTO mopNT_vpl VALUES ("AC1_20","074_1_20","ACT","1","20","20","—Tz'iiba'an ichil a ju'um Salmos ichil u ju'um a Dios yoc'ol c'u' a mani ti'i aj Judas ti baala': “Bel u ca'a p'ütbül u yotoch ti ma' yan u ba'al. Ma'ax jun tuul bel u ca'a ti cuntal te'i.” Tz'iiba'an ulaac' ti baala': “Ulaac' mac bel u cu bete' u meyaj.” Baalo' ti tz'iiba'an yoc'ol aj Judas,— cu t'an aj Pedrojo, ");
INSERT INTO mopNT_vpl VALUES ("AC1_21","074_1_21","ACT","1","21","22","—mentücü, yan ti yeetic u jel aj Judasa. Le'ec abe'e, bel u cu yadü' ti ca' cuxlaji tun a Jesus tucaye'il jabix ilic ti walac ti wadic ino'ono,— cu t'an aj Pedrojo. —Le'ec a jun tuul a yan ti yeetiqui, le'ec a mac a que'en tiqui yaam ti tan u manül ti Noochil a Jesus tiqui wetel. Que'en tiqui yaam le'ec ti ca' u c'ümaj a ocja' a Jesus u men aj Juan le'ec ti caji ti t'an a Jesusu. Que'en ti que'en tiqui yaam asto ti bini ti ca'an a Jesusu,— cu t'an aj Pedrojo. ");
INSERT INTO mopNT_vpl VALUES ("AC1_23","074_1_23","ACT","1","23","23","Ich yaabil u cüxtajoo' ca' tuul: aj Jose etel aj Matias. Aj Joseje, yan ca' p'eel ulaac' u c'aba' ti'i: Barsabas y Justo. ");
INSERT INTO mopNT_vpl VALUES ("AC1_24","074_1_24","ACT","1","24","25","Cajoo' ti t'an a hermano etel a Dios ti ca'ana. —Ti Noochil,— cu t'anoo' ti'i a Dioso. —A weel biqui yanil u püsüc'al tulacal a cristianojo. Wa'ye' que'en ca' tuul a winiqui. Ye'e to'on mac a c'ati ca' ococ tu yaj xa'num a Jesus ti'i u betical jabix u meyaj aj Judasa. Aj Judasa, u cüxtaj u sip'il. Bini ich c'aac' u bo'te u sip'il,— cu t'anoo'. ");
INSERT INTO mopNT_vpl VALUES ("AC1_26","074_1_26","ACT","1","26","26","Uchoo' u baxül bul ti'i ca' u yiloo' mac a ocol u ca'a ti'i u jel aj Judasa. Le'ec aj Matiasa, uchi u ganar. Ti baalo' oqui tu yaj xa'num a Jesus eteloo' u chucaan a once tuulu. ");
INSERT INTO mopNT_vpl VALUES ("AC2_1","074_2_1","ACT","2","1","1","Pues te'i. Much'a'anoo' ich jun p'eel ilic cuuch boonoo' a hermano ti'i u q'uinil a fiesta u c'aba' Pentecostes. ");
INSERT INTO mopNT_vpl VALUES ("AC2_2","074_2_2","ACT","2","2","2","Chen u yubajoo'o, yan a c'u'i uchi u peec ti ca'an jabix u juum a iq'ui. Chich u peec abe' ti oqui ichil a naj tuba tina'anoo'o. ");
INSERT INTO mopNT_vpl VALUES ("AC2_3","074_2_3","ACT","2","3","3","Ca' u yilajoo'o, ac yan jabix aj tz'i' c'aac' yoc'ol u pol a jujun tuulu. ");
INSERT INTO mopNT_vpl VALUES ("AC2_4","074_2_4","ACT","2","4","4","Baalo' ti oqui u Püsüc'al a Dios ichil u püsüc'al boon a que'enoo' te'iji. Le'ec ti tz'abi c'u' a ca' u yadoo' a jujun tuul u men u Püsüc'al a Dioso, cajoo' u yadü' a t'an a jujumpaay u wich a ma' u yeeloo'o. ");
INSERT INTO mopNT_vpl VALUES ("AC2_5","074_2_5","ACT","2","5","5","Pues te'i. Yanoo' aj Israel ichil a caj Jerusalen ti a q'uin ti uchi ti baalo'o. Ala'oo'o, jujumpaayoo' u caal ca'ax tubajac yoc'olcab. Walacoo' u tz'ocsic a Dios tulacaloo' u yoolo. ");
INSERT INTO mopNT_vpl VALUES ("AC2_6","074_2_6","ACT","2","6","6","Ala'oo'o, le'ec ti ca' u yubajoo' u peec abe'e, much'lajoo' ti yaab. Tu yaamoo' a tanoo' u cha'ana, yan a taloo' ti naacha. Jujumpaayoo' u wich u t'an. Sa'too' u yool a c'ochoo' tojo, u men le'ec boon a walacoo' u tz'ocsic a Jesusu, tanoo' u tzicbal ichil ilic u t'an a jujun tuul jabix ti walacoo' u yadic a tala'anoo' tubajac. ");
INSERT INTO mopNT_vpl VALUES ("AC2_7","074_2_7","ACT","2","7","7","Sa'too' u yool tu jajil u men c'u' a tanoo' u yubiqui. Tanoo' u cha'an. —Ile'ex, le'ecoo' a tanoo' u t'an, laj Galileanojiloo',— cu t'anoo' tu bajil. ");
INSERT INTO mopNT_vpl VALUES ("AC2_8","074_2_8","ACT","2","8","8","—¿Biqui ti baalo'? Tanoo' u t'an ichil ti t'an ino'on tuba yanajo'on. Jujumpaay u wich ti t'an,— cu t'anoo' u yaabil a cristianojo. ");
INSERT INTO mopNT_vpl VALUES ("AC2_9","074_2_9","ACT","2","9","10","—Tiqui yaam yan a taloo' cuenta Partia,— cu t'anoo'. —Yan a taloo' cuenta Media. Yan a taloo' cuenta Elam, cuenta Mesopotamia, cuenta Judea, cuenta Capadocia, cuenta Ponto, cuenta Asia, cuenta Frigia, cuenta Panfilia, cuenta Egipto. Tiqui yaam yan a taloo' ma' naach caj Cirene. Que'en ich cuenta Africa a caj abe'e. Tiqui yaam yan a taloo' caj Roma, le'ec aj Israeloo'. Tu yaamoo' abe'e, yanoo' a chen u tz'ajoo' u bajil ti aj Israeloo'o,— cu t'anoo' u yaabil a cristiano tu bajil. ");
INSERT INTO mopNT_vpl VALUES ("AC2_11","074_2_11","ACT","2","11","11","—Yan a taloo' cuenta Creta, cuenta Arabia. Tulacalo'on, tan ti wu'yicoo' u yaj xa'num a Jesus ti tanoo' u t'an ichil ti t'an ino'ono. Tanoo' u tzicbaltic u milagro a Dioso, le'ec a boon u betaja,— cu t'anoo' u yaabil a cristiano tu bajili. ");
INSERT INTO mopNT_vpl VALUES ("AC2_12","074_2_12","ACT","2","12","12","Sa'too' u yool tulacaloo' a cristianojo. Ma' u yeeloo' c'u' a cu tucloo'o. Le'ecoo' u yaabili, tanoo' u c'aatic tu bajil: —¿C'u' u nu'cul a tan u yuchulu?— cu t'anoo'. ");
INSERT INTO mopNT_vpl VALUES ("AC2_13","074_2_13","ACT","2","13","13","Yanoo' ulaac' tu yaamoo' a cristianojo, cajoo' ti baxült'an. —Cüla'anoo',— cu t'anoo' abe' yoc'oloo' a hermanojo. ");
INSERT INTO mopNT_vpl VALUES ("AC2_14","074_2_14","ACT","2","14","14","Pues te'i. Wa'laji aj Pedro u yet'ocoo' a once tuulu. Chich u t'an ti caji ti t'an eteloo' boon a tanoo' u cha'ana. —In wetcaale'ex aj Israel etel boone'ex a tane'ex a sut ichil a caj Jerusalen, u'ye'ex in t'an le'ec a c'u' a bel in quin wadü' te'exe,— cu t'an aj Pedrojo. ");
INSERT INTO mopNT_vpl VALUES ("AC2_15","074_2_15","ACT","2","15","15","—Ino'ono, ma' cüla'ano'on jabix a tane'ex a wadiqui, u men a las nueve ti jatzca' to,— cu t'an aj Pedrojo. ");
INSERT INTO mopNT_vpl VALUES ("AC2_16","074_2_16","ACT","2","16","16","—Le'ec a c'u' u yadaj aj quimen Joele, le'ec a tan u manülü. Ala'aji, le'ec jun tuul u yadaj u t'an a Dios uchi,— cu t'an aj Pedrojo. —Baala' u yadaj ala'aji: ");
INSERT INTO mopNT_vpl VALUES ("AC2_17","074_2_17","ACT","2","17","17","“Le'ec ti watac u q'uinil u jobol a yoc'olcaba, bel in ca'a in tücaa'te in Püsüc'al ichiloo' u püsüc'al a cristianojo, cu t'an a Dioso,” cu t'an aj Joele. “Ti'i a q'uin abe'e, beloo' u cu yadü' in t'an a mejene'ex ca'ax xidal ca'ax ix ch'up, cu t'an a Dioso. Le'ecoo' a ch'ajomo, bel in quin yee' ti'ijoo' c'u' in c'ati ich jabix nümül. Pixa'anoo' y tanoo' u yilic. Le'ecoo' a noochwiniqui, bel in ca'a ti tzicbal eteloo' ichil u nümül, cu t'an a Dioso. ");
INSERT INTO mopNT_vpl VALUES ("AC2_18","074_2_18","ACT","2","18","18","Ti'i a q'uin abe'e, le'ec ti watac u jobol a yoc'olcaba, bel in quin tücaa'te in püsüc'al ichiloo' u püsüc'al a boon a walacoo' u tz'ocsiquen ca'ax winic ca'ax ix ch'up. Beloo' u cu yadoo' le'ec a c'u' a bel in quin wadü' ti'ijoo', cu t'an a Dioso. ");
INSERT INTO mopNT_vpl VALUES ("AC2_19","074_2_19","ACT","2","19","19","Bel in quin yee' in milagro ti ca'an. Bel in quin yee' u p'is yoc'olcab. Le'ec abe'e, q'uic', c'aac', y butz, cu t'an a Dioso. ");
INSERT INTO mopNT_vpl VALUES ("AC2_20","074_2_20","ACT","2","20","20","Bel u ca'a ti tupul a q'uini. Bel u ca'a ti chüctal a uj jabix q'uiq'ui. Mas pachil watac a Noochtzil u tz'aa' ichil u sip'il a cristianojo. Sabeensil u wichil c'u' a uchul u ca'a ti a q'uin abe'e, cu t'an a Dioso. ");
INSERT INTO mopNT_vpl VALUES ("AC2_21","074_2_21","ACT","2","21","21","Tulacal a mac ca' u c'aate ti'i a Noochtzil ca' sa'tesabüc u sip'ili, bel u ca'a sa'albül, cu t'an a Dioso.” Baalo' u yadaj aj Joel uchi,— cu t'an aj Pedro ti'ijoo' u yaabil a cristianojo. ");
INSERT INTO mopNT_vpl VALUES ("AC2_22","074_2_22","ACT","2","22","22","—In wetcaale'ex aj Israel, u'ye'ex in t'an,— cu t'an aj Pedrojo. —Tan in tzicbaltic a Jesusu, le'ec a tali caj Nazaret. Ala'aji, u betaj a milagro etel u muc' a Dioso. Sa'too' u yool etel c'u' a tan u betic a Jesus biq'uin ado'o. Etel c'u' u betaja, u ye'aj to'on u yanil,— cu t'an aj Pedrojo. —U betaj tulacal abe' tiqui yaam. A weele'ex ti qui' abe'e,— cu t'an aj Pedrojo. ");
INSERT INTO mopNT_vpl VALUES ("AC2_23","074_2_23","ACT","2","23","23","—Le'ec a Jesusu, c'ubbi te'ex biq'uin ado' u men le'ec a Dioso, u c'ati u bete' ti baalo'. Le'ec a Dioso, u yeel c'u' a bele'ex a ca'a a bete' ti'i a Jesusu, y a betaje'ex xan. Inche'exe, a c'ubaje'ex a Jesus ti'ijoo' a c'ac'as cristiano le'ecoo' a ma' Israel ti'i ca' tz'abüc tuwich u cruzil. Baalo' ti quimsabi a Jesus a mene'exe,— cu t'an aj Pedro ti'ijoo'o. ");
INSERT INTO mopNT_vpl VALUES ("AC2_24","074_2_24","ACT","2","24","24","—Le'ec a Dioso, u ca' cuxquintaj a Jesusu. Cuxquinbi a Jesusu, u men ma' yan biqui u p'aatül ti quimen,— cu t'an aj Pedrojo. ");
INSERT INTO mopNT_vpl VALUES ("AC2_25","074_2_25","ACT","2","25","25","—Aj Davidi, uchi tun u tz'iibte c'u' u yadajoo' tu bajil a Cristo etel a Tattzili. “In weel ti tulacal a q'uin que'en in Noochil tin wetele. Te'i que'en tin waj toj tin waj seeb c'ü', mentücü, ma' tin saactal, cu t'an a Cristojo. ");
INSERT INTO mopNT_vpl VALUES ("AC2_26","074_2_26","ACT","2","26","26","Qui' in wool u men abe'e. Bel in quin tzicbalte u qui'il in wool, u men in weel le'ec ti quimiquene, bel in ca'a ti ca' cuxtal, cu t'an a Cristo ti'i a Tattzili. ");
INSERT INTO mopNT_vpl VALUES ("AC2_27","074_2_27","ACT","2","27","27","In weel ti ma' ta p'ütic in püsüc'al tu yaamoo' a quimene, ma'ax ta cha'ic u tu'ujtal u büq'uel a waj qui'il Mejen. ");
INSERT INTO mopNT_vpl VALUES ("AC2_28","074_2_28","ACT","2","28","28","Bel a ca'a a ca' tz'aa' ten in cuxtal tucaye'. Le'ec ti ca' uduquen ta wetele, bel a ca'a a siji' ten jun p'eel qui'-oolal a mani tu pacha, cu t'an a Cristojo.” Baalo' u yadaj aj Davidi,— cu t'an aj Pedro ti'ijoo' u yaabil a cristianojo. ");
INSERT INTO mopNT_vpl VALUES ("AC2_29","074_2_29","ACT","2","29","29","—Pues te'i. In wetcaale'ex, le'ec aj Davidi, le'ec ti uchben mamaa'. Tulacalo'on ti weel ti uchi quimic ala'aji. U mucajoo' y chica'an to'on tac leeb tuba muca'an,— cu t'an aj Pedrojo. ");
INSERT INTO mopNT_vpl VALUES ("AC2_30","074_2_30","ACT","2","30","30","—Le'ec aj Davidi, le'ec jun tuul u yadü' u t'an a Dios uchiji. U tz'aj tu yool c'u' u yadaj a Dios ti'iji. Le'ec a Dioso, u yadaj ti'i aj David tu jajil ti le'ec u mam jun tuulu, u ti'al ca' u sa'altoo' a cristianojo. Bel u ca'a ti ocol ti reyil tu jel aj David. ");
INSERT INTO mopNT_vpl VALUES ("AC2_31","074_2_31","ACT","2","31","31","Payanbej u yeeltaj abe' aj Davidi. U tzicbaltaj biqui ti ca' cuxlac u yaj Sa'alil a cristianojo, mentücü, u yadaj ma' u p'aatül u püsüc'al tu yaamoo' a quimene, ma'ax u tu'ujtal u büq'uel,— cu t'an aj Pedro ti'ijoo' u yaabil a cristianojo. ");
INSERT INTO mopNT_vpl VALUES ("AC2_32","074_2_32","ACT","2","32","32","—Aj Davidi, yoc'lal Jesus uchi u t'an. Ino'ono, u yaj xa'numo'on a Jesusu. Ti wilaj ala'aji, mentüc ino'ono, u paatal ti wadic te'ex tu jajil ti ca' cuxlaji u men a Dioso,— cu t'an aj Pedrojo. ");
INSERT INTO mopNT_vpl VALUES ("AC2_33","074_2_33","ACT","2","33","33","—Nac'sabi ti ca'an a Jesus u men u muc' a Dioso. Te'i c'ubbi u Püsüc'al a Dios ti'i a Jesus jabix u yadaj a Tattzili. A Jesusu, u tücaa'taj u Püsüc'al a Dios ichil a yoc'olcaba, mentücü, a wu'yaje'ex y a wilaje'ex jabix ti jeeli u wich ti t'an samiji,— cu t'an aj Pedrojo. ");
INSERT INTO mopNT_vpl VALUES ("AC2_34","074_2_34","ACT","2","34","34","—Ma' naq'ui ti ca'an aj David tac etel u büq'ueli, pero baala' u yadaj yoc'ol a Jesusu: “Le'ec a Dioso, u yadaj ti'i in Noochil: Tinlen wa'ye' tin waj toj tin waj seeb c'ü' ");
INSERT INTO mopNT_vpl VALUES ("AC2_35","074_2_35","ACT","2","35","35","asto u cho'boloo' a tz'iic teche. P'aatüloo' u ca'a jabix yalam a woco, cu t'an a Dios ti'i in Noochil.” Baalo' u yadaj aj Davidi,— cu t'an aj Pedrojo, ");
INSERT INTO mopNT_vpl VALUES ("AC2_36","074_2_36","ACT","2","36","36","—mentüc in wetcaale'ex aj Israele, tan in wadic te'ex tu jajil. A tz'aje'ex a Jesus tuwich u cruzili. C'u' betiqui, le'ec a Dioso, u ca' cuxquintaj a Jesus ti'i ca' p'aatüc ti'i ti Noochil y ti'i ti waj Sa'alil,— cu t'an aj Pedro ti'ijoo' u yaabil a cristianojo. ");
INSERT INTO mopNT_vpl VALUES ("AC2_37","074_2_37","ACT","2","37","37","Pues te'i. Le'ec ti ca' u yubajoo' u t'an aj Pedrojo, yajajoo' u yool tu jajil. —Ti wetcaal, ¿c'u' a ca' ti bete'e?— cu t'anoo' ti'i aj Pedro eteloo' u chucaan u yaj xa'num a Jesusu. ");
INSERT INTO mopNT_vpl VALUES ("AC2_38","074_2_38","ACT","2","38","38","—Le'ec a jujun tuule'exe, yan a jelique'ex a tucul ti'i ca' a tucle'ex a quich'pan tuculu. Yan a c'ümique'ex a ocja'a, ti'i ca' u yiloo' a cristiano ti walaque'ex a tz'ocsic a Jesusu. Baalo' ca' a bete'ex y bel u ca'a sa'tesabüle'ex a sip'il jumpul u men Dios y le'ec a Dioso, bel u cu siji' te'ex u Püsüc'al,— cu t'an aj Pedro ti'ijoo' a boon a tanoo' u cha'an. ");
INSERT INTO mopNT_vpl VALUES ("AC2_39","074_2_39","ACT","2","39","39","—Le'ec a sij-ool abe'e, u c'ati u siji' te'ex y ti'ijoo' a mejene'ex y ti'ijoo' a mac a que'en ti naacha, le'ec boon a cristiano a yeetboo' u men a Dioso,— cu t'an aj Pedrojo. ");
INSERT INTO mopNT_vpl VALUES ("AC2_40","074_2_40","ACT","2","40","40","Ma' jadi' abe' u yadaji. Chawac u pach u t'an aj Pedrojo. U yadaj ti'ijoo' u yaabil a cristiano c'u' a qui' cu betoo'o. —Sa'alte'ex a bajil. Ma' a ca' cuntale'ex ichile'ex a sip'il. ¿C'u' aj beel ca' c'axüque'ex ichil a sip'il tu yaamoo' a c'ac'as cristianojo?— cu t'an aj Pedrojo. ");
INSERT INTO mopNT_vpl VALUES ("AC2_41","074_2_41","ACT","2","41","41","Le'ec tulacal boon u tz'ocsaj u t'an aj Pedrojo, u c'ümajoo' a ocja'a. Ti a q'uin abe'e, jabix tres mil tuul cajoo' u tz'oques a Jesusu. ");
INSERT INTO mopNT_vpl VALUES ("AC2_42","074_2_42","ACT","2","42","42","Tan ti tanoo' u yubic u t'anoo' u yaj xa'num a Jesusu. Qui'oo' tu bajil. Much'a'anoo' tu bajil ti walacoo' u janal y ti t'an etel a Dios a que'en ti ca'ana. ");
INSERT INTO mopNT_vpl VALUES ("AC2_43","074_2_43","ACT","2","43","43","Pues te'i. Sa'too' u yool tulacaloo' a cristiano ich caja. Yaab a milagro u betajoo' u yaj xa'num a Jesusu. ");
INSERT INTO mopNT_vpl VALUES ("AC2_44","074_2_44","ACT","2","44","44","Tulacaloo' a boon a walacoo' u tz'ocsic a Jesusu, walacoo' u much'tal. Tulacal a c'u' a yanoo' ti'iji, walacoo' u sijic tu bajil. ");
INSERT INTO mopNT_vpl VALUES ("AC2_45","074_2_45","ACT","2","45","45","Walacoo' u conic u lu'um, u yotoch y c'u' a yan ti'ijoo'o, y walacoo' u sijic u tool ti'i a mac tu yaamoo' a ma' yan a ma'ax c'u'i ti'iji. ");
INSERT INTO mopNT_vpl VALUES ("AC2_46","074_2_46","ACT","2","46","46","Sansamal walacoo' u much'tal u c'ajes Dios ichil u yotoch a Dioso. Walacoo' u much'tal ichiloo' u yotoch a jujun tuul ti janala. Qui'oo' u yool u men jumbeloo' u tucul. ");
INSERT INTO mopNT_vpl VALUES ("AC2_47","074_2_47","ACT","2","47","47","Tanoo' u yadic u qui'il a Dioso. Le'ecoo' u yaabil a cristianojo, qui'oo' etel boon a hermanojo. Sansamal a Noochtzili, tan u yaabcuntic boon a hermano etel boon a tan u sa'altiqui. ");
INSERT INTO mopNT_vpl VALUES ("AC3_1","074_3_1","ACT","3","1","1","Pues te'i. Le'ecoo' u yaabil a cristianojo, walacoo' u t'an etel a Dios a que'en ti ca'an a las tres ti ocq'uin. Jun p'eel q'uin ti a hora abe'e, binoo' aj Pedro u yet'oc aj Juan ichil u yotoch a Dioso. ");
INSERT INTO mopNT_vpl VALUES ("AC3_2","074_3_2","ACT","3","2","2","Le'ec ti tanoo' u c'ochol ti u puertajil u yotoch a Dioso, c'ochesabi te'i jun tuul a winic a ma' patal ti ximbal. Mooch u yoc ti yanaji. Walac u c'ochesabül sansamal tu chi' u yotoch a Dioso, ti jun p'eel puerta Quich'pan Puerta u c'aba'. Te'i walac u matan taq'uin a mooch u yoc etel boon a walacoo' u yocol ichil u yotoch a Dioso. ");
INSERT INTO mopNT_vpl VALUES ("AC3_3","074_3_3","ACT","3","3","3","Le'ec a mooch u yoco, u yilajoo' ti tanoo' u yocol ichil u yotoch a Dios aj Pedro u yet'oc aj Juana. U c'aataj a taq'uin ti'i a ca' tuulu. ");
INSERT INTO mopNT_vpl VALUES ("AC3_4","074_3_4","ACT","3","4","4","U cha'antajoo' a mooch u yoc aj Pedro etel aj Juana. —Cha'anto'on a wila',— cu t'an aj Pedro ti'iji. ");
INSERT INTO mopNT_vpl VALUES ("AC3_5","074_3_5","ACT","3","5","5","U cha'antajoo'. Tan u paac'tic a bel u ca'a sijibil ti'iji. ");
INSERT INTO mopNT_vpl VALUES ("AC3_6","074_3_6","ACT","3","6","6","—Ma' yan ti taq'uin,— cu t'an aj Pedrojo, —pero bel ti ca'a ti waanteech. Etel u muc' a Jesucristo le'ec a tali Nazaret tan in wadic tech. Wa'len. Uchuc a ximbal,— cu t'an aj Pedro ti'iji. ");
INSERT INTO mopNT_vpl VALUES ("AC3_7","074_3_7","ACT","3","7","7","Aj Pedrojo, u müchaj tu yaj toj tu yaj seeb c'ü'. U wa'cuntaj. Tu seebal qui'aji u yoc. Yanaji u muc' u cal u yoc. ");
INSERT INTO mopNT_vpl VALUES ("AC3_8","074_3_8","ACT","3","8","8","Uchi u siit ti wa'laji. Caji ti ximbal. Oqui ichil u yotoch a Dios u yet'ocoo' aj Pedro etel aj Juana. Tan u ximbal. Tan u siit. Tan u yadic u qui'il a Dioso. ");
INSERT INTO mopNT_vpl VALUES ("AC3_9","074_3_9","ACT","3","9","9","Tulacal mac, u yilaj ti tan u ximbal. U yubajoo' ti tan u yadic u qui'il a Dioso. ");
INSERT INTO mopNT_vpl VALUES ("AC3_10","074_3_10","ACT","3","10","10","U c'aj-ooltajoo' u wich a moocho. —Ado'o, le'ec a jun tuul a tina'an tu chi' jun p'eel u puertajil u yotoch a Dios u c'aba' Quich'pan Puerta ti matan taq'uin sansamal,— cu t'anoo' a cristiano tu bajili. Tanoo' u cha'an. Sa'too' u yool u men ch'ani u yoc a winiqui. ");
INSERT INTO mopNT_vpl VALUES ("AC3_11","074_3_11","ACT","3","11","11","Pues te'i. Aj Pedro u yet'oc aj Juana, que'en ichil u yotoch Dios ich jun p'eel cuarto u c'aba' aj Salomon. Tücünac ilic a ch'anesabi tu pach a ca' tuulu. Top meeca'anoo' u men. Jomol ti much'lajoo' a cristiano te'iji. Sa'too' u yool a cristiano u men c'u' a maniji. ");
INSERT INTO mopNT_vpl VALUES ("AC3_12","074_3_12","ACT","3","12","12","Le'ec ti ca' u yilaj ti tanoo' u much'tal a cristiano aj Pedrojo, u yadaj ti'ijoo': —In wetcaale'ex aj Israel,— cu t'an aj Pedrojo. —¿C'u' ca'a sa'te'ex a wool u men c'u' a maniji? Ma' ti ch'anesaj a winic chen etel u muc' ti t'ani, ma'ax chen u men ma'lo' winico'on,— cu t'an aj Pedrojo. ");
INSERT INTO mopNT_vpl VALUES ("AC3_13","074_3_13","ACT","3","13","13","—Le'ec ti Dioso, le'ec u Diosil ti uchben mamaa'oo' aj Abraham, aj Isaac, aj Jacob y tulacal u chucaan ti uchben mamaa'. Le'ec a Dioso, u tz'aj u yanil u Mejen le'ec a Jesusu. Inche'exe, a c'ubaje'ex a Jesus ti'i aj Pilato, le'ec a gobernadoro,— cu t'an aj Pedro ti'ijoo' u yaabil a cristianojo. —Aj Pilatojo, u c'aatiintaj cuchi u chaa' a Jesusu, pero ma' a cha'aje'ex u betic ti baalo',— cu t'an aj Pedrojo. ");
INSERT INTO mopNT_vpl VALUES ("AC3_14","074_3_14","ACT","3","14","14","—Ma' a c'aataje'ex ca' joc'oc a Jesusu. Ala'aji, yeeta'an u men Dios. Toj u na'at, pero inche'exe, ma' a c'aataje'ex ca' cha'büqui. A c'aataje'ex ca' joc'oc ti presojil jun tuul aj quimsaj,— cu t'an aj Pedrojo. ");
INSERT INTO mopNT_vpl VALUES ("AC3_15","074_3_15","ACT","3","15","15","—Inche'exe, a quimsaje'ex aj tz'aj cuxtala. Le'ec a Dioso, u ca' cuxquintaj a Jesusu. Jaj abe'e, u men ti wilaj a Jesus ti ca' cuxa'an tucaye',— cu t'an aj Pedro ti'ijoo' u yaabil a cristianojo. ");
INSERT INTO mopNT_vpl VALUES ("AC3_16","074_3_16","ACT","3","16","16","—A winic ada'a, le'ec a mooch u yoc a tane'ex a cha'antiqui, ch'ani u men Dios u men ino'ono, walac ti tz'ocsic u yanil a Jesusu. Walac ti tz'ocsic u t'an a Jesusu, mentücü, ch'ani ti qui' a winiqui. A weele'ex u wich. Chica'an ti ch'ani,— cu t'an aj Pedrojo. ");
INSERT INTO mopNT_vpl VALUES ("AC3_17","074_3_17","ACT","3","17","17","—Pues te'i. In wetcaale'ex, in weel ti le'ec inche'ex eteloo' a nucuch winiqui, a quimsaje'ex a Jesus u men ma' a weele'ex c'u' a tane'ex a betiqui,— cu t'an aj Pedrojo. ");
INSERT INTO mopNT_vpl VALUES ("AC3_18","074_3_18","ACT","3","18","18","—Payanbej Dios u yadaj ti'ijoo' a uchben boon a walac u yadic u t'an a Dios uchi ca' u tz'iibte ichil u ju'um ti bel u ca'a u c'ümü' a yaj u yaj Sa'alil a cristianojo. Jabix ti tz'iiba'ana, baalo' u c'ümaja,— cu t'an aj Pedrojo. ");
INSERT INTO mopNT_vpl VALUES ("AC3_19","074_3_19","ACT","3","19","19","—Jele'ex a tucul. Tucle'ex a quich'pan tuculul. Tz'aje'ex a wool ti'i a Dios ti'i ca' u sa'tese'ex a sip'il. Ti baalo'o, bel u ca'a ti nojtale'ex u yool a püsüc'al u men ti Noochil,— cu t'an aj Pedrojo. ");
INSERT INTO mopNT_vpl VALUES ("AC3_20","074_3_20","ACT","3","20","20","—Bete'ex ti baalo' y le'ec a Dioso, bel u cu ca' tücaa'te a Jesus ta wetele'exe. Le'ec a Jesusu, le'ec u yaj Sa'alil a cristianojo. Ala'aji, yeetbi uchi ti'i ca' u sa'alto'on,— cu t'an aj Pedrojo. ");
INSERT INTO mopNT_vpl VALUES ("AC3_21","074_3_21","ACT","3","21","21","—Le'ec a Jesusu, yan u cuntal ti ca'an asto u c'ochol u q'uinil u yemel u yutzquinte tulacal boon a yan yoc'olcab jabix u yadaj a Dioso. Tz'iiba'an c'u' u yadaj a Dios u menoo' boon a walacoo' u yadic u t'an a Dios uchi,— cu t'an aj Pedrojo. ");
INSERT INTO mopNT_vpl VALUES ("AC3_22","074_3_22","ACT","3","22","22","—Baala' u yadaj aj quimen Moises ti'ijoo' ti uchben mamaa': “Le'ec a Dioso, bel u cu yeete jun tuul tu yaamoo' ti wetcaal ti'i cu yadü' u t'an a Dioso, jabix ca' u yeetajene,” cu t'an aj Moisese. “Yan a tz'ocsique'ex tulacal a c'u' a bel u cu yadü' te'exe. ");
INSERT INTO mopNT_vpl VALUES ("AC3_23","074_3_23","ACT","3","23","23","Tulacal a mac ma' ta'ach u tz'ocsic u t'an a winic abe'e, bel u ca'a ti quimil ichil u sip'il. Ma' tu cuntal tu yaamoo' a cristiano a walac u tz'ocsic a Dioso.” Baalo' u yadaj aj Moisese,— cu t'an aj Pedrojo. ");
INSERT INTO mopNT_vpl VALUES ("AC3_24","074_3_24","ACT","3","24","24","—Tulacal a mac u yadaj u t'an a Dios uchiji, payanbej aj quimen Samuel, despues le'ec boon u chucaan a jujun tuul a yanajoo' pachili, u yadajoo' c'u' a tan u yuchul jabix ti tane'ex a wilic aleebe,— cu t'an aj Pedrojo. ");
INSERT INTO mopNT_vpl VALUES ("AC3_25","074_3_25","ACT","3","25","25","—Ino'on aj Israelo'ono, u mamo'on a uchben cristiano le'ec boon u yadaj u t'an a Dios uchiji. Le'ec a c'u' u yadaj Dios ti'ijoo' ti uchben mamaa'a, le'ec a bel u cu bete' aleebe. “Yaaboo' a cristiano a bel u ca'a sa'albül ichil a jujun p'eel u wich a t'an yoc'olcab u men a mam,” cu t'an a Dios ti'i ti uchben mamaa' le'ec aj Abraham yoc'ol a Cristojo,— cu t'an aj Pedrojo. ");
INSERT INTO mopNT_vpl VALUES ("AC3_26","074_3_26","ACT","3","26","26","—Le'ec a Dioso, u yeetaj u Mejen. Payanbej u tücaa'taj tiqui yaam aj Israelo'on ca' u sa'alto'on ca' ti pütü' ti betic a c'asil jujun tuulili,— cu t'an aj Pedro ti'ijoo' a cristianojo. ");
INSERT INTO mopNT_vpl VALUES ("AC4_1","074_4_1","ACT","4","1","1","Pues te'i. Le'ec aj Pedro u yet'oc aj Juana, tan to u tzicbal eteloo' a cristiano ti c'ochoo' u yaj mansaj t'an a cristiano ti'i a Dioso. C'ochoo' ilic te'i u polil boon a walacoo' u cününtic u yotoch a Dios u yet'ocoo' a cristiano a saduceo u c'aba'oo' u na'ata. ");
INSERT INTO mopNT_vpl VALUES ("AC4_2","074_4_2","ACT","4","2","2","Tulacaloo' a c'ochoo' tojo, tz'iicoo' ti'i aj Pedro etel aj Juan u men tanoo' u tzicbal eteloo' a cristianojo. Aj Pedro etel aj Juana, tanoo' u tzicbaltic ti'ijoo' a cristianojo, ti ca' cuxlajoo' u ca'a a quimene. —Jabix ti cuxlaji a Jesusu, baalo' ti ca' cuxlacoo' a quimene,— cu t'anoo' a ca' tuulu. ");
INSERT INTO mopNT_vpl VALUES ("AC4_3","074_4_3","ACT","4","3","3","Müchboo' aj Pedro etel aj Juan u menoo' a nucuch winic a tz'iicoo'o. Ocq'uin tun. Ma' ca' yan biqui u yilbiloo' u sip'il. U tz'ajoo' ich cuarto asto tu samalil. ");
INSERT INTO mopNT_vpl VALUES ("AC4_4","074_4_4","ACT","4","4","4","C'u' betiqui, yan tu yaamoo' a cristiano u yubajoo' u t'an a ca' tuulu, u tz'ocsajoo'. Baalo' ti yaabajoo' a hermanojo. Yan jabix cinco mil tuul ti chen winic a uchoo' u tz'ocsaja. ");
INSERT INTO mopNT_vpl VALUES ("AC4_5","074_4_5","ACT","4","5","5","Pues te'i. Ti u samalili, much'lajoo' ich caj Jerusalen a nucuch winicoo' ti'i a caja, u yet'ocoo' a nucuch winic ti'i u yotoch a Dioso, u yet'ocoo' u yaj ca'ansajil u ley aj Moisese. ");
INSERT INTO mopNT_vpl VALUES ("AC4_6","074_4_6","ACT","4","6","6","Tu yaamoo' que'en ilic aj Anas, le'ec a mas nooch u wichil u meyaj tu yaamoo' u yaj mansaj t'an a cristiano ti'i a Dioso. Tu yaamoo' que'en ilic aj Caifas u yet'ocoo' aj Juan etel aj Alejandro. Tu yaamoo' que'en ilic u yet'ocoo' u noochil u yaj mansaj t'an a cristiano ti'i a Dioso. ");
INSERT INTO mopNT_vpl VALUES ("AC4_7","074_4_7","ACT","4","7","7","U püyajoo' aj Pedro etel aj Juan ca' talac tu taanoo'. U c'aatajoo' u chi' a ca' tuulu. —¿C'u' u wichil a meyaje'ex? ¿Mac u tücaa'taje'ex a bete'ex a jabix a tane'ex a betiqui?— cu t'anoo' ti'i a ca' tuulu. ");
INSERT INTO mopNT_vpl VALUES ("AC4_8","074_4_8","ACT","4","8","8","U men que'en u Püsüc'al a Dios ichil u püsüc'al aj Pedrojo, baala' ti uchi u nuuc. —U nucuch winiquile'ex caj etele'ex u nucuch winiquile'ex u yotoch Dios,— cu t'an aj Pedrojo. ");
INSERT INTO mopNT_vpl VALUES ("AC4_9","074_4_9","ACT","4","9","9","—¿Tane'ex wa a c'aatic ti chi' yoc'ol a qui'il u c'ümaj a mooch u yoco, le'ec biqui ti ch'aniji?— cu t'an aj Pedro ti'ijoo' a nucuch winiqui. ");
INSERT INTO mopNT_vpl VALUES ("AC4_10","074_4_10","ACT","4","10","10","—Bel ti ca'a ti wadü' te'ex tulacale'ex etel tulacal ti wetcaal aj Israele. Ca' a wu'ye'ex u tojil. Le'ec a Jesucristojo, te' tala'an Nazaret. Inche'exe, a tz'aje'ex tuwich u cruzil. Te'i quimi ala'aji, pero le'ec a Dioso, u ca' cuxquintaj a Jesus tu yaamoo' a quimene. Le'ec ala'aji, u ch'anesaj u yoc a moocho, le'ec a wa'ye' que'en wa'an ta taane'exe,— cu t'an aj Pedro ti'ijoo' a nucuch winiqui. ");
INSERT INTO mopNT_vpl VALUES ("AC4_11","074_4_11","ACT","4","11","11","—Le'ec a Jesusu, jabix jun p'eel tunich. Inche'exe, jabixe'ex aj men naj. “Ma' qui' a tunich ada'a,” que'ex pero a tunich ada'a, oqui ti mas yan u meyaj tuwich u chucaan,— cu t'an aj Pedrojo. ");
INSERT INTO mopNT_vpl VALUES ("AC4_12","074_4_12","ACT","4","12","12","—Ma' yan ulaac' a mac patal u sa'alte a cristianojo. Jadi' a Jesusu. Ma' yan ulaac' a mac tu yaamoo' a cristiano yoc'olcab a tz'abi u yanil u men Dios ti'i ca' sa'albüc,— cu t'an aj Pedro ti'ijoo' a nucuch winiqui. ");
INSERT INTO mopNT_vpl VALUES ("AC4_13","074_4_13","ACT","4","13","13","Pues te'i. Le'ecoo' a nucuch winiqui, u yilajoo' ti ma' saac aj Pedro ma'ax aj Juana. U yeeltajoo' ti ma' ucha'anoo' u escuela a ca' tuulu. Chen jabix ca'ax macac ti winiquiloo'o. Ma' noochoo' u wichil u meyaj. Sa'too' u yool a nucuch winiqui. Despuese, c'ajoo' ti'i a nucuch winic ti u yaj cambal Jesus a ca' tuulu. ");
INSERT INTO mopNT_vpl VALUES ("AC4_14","074_4_14","ACT","4","14","14","Le'ecoo' a nucuch winiqui, u yilajoo' a winic a ch'aniji. Wa'an ti que'en te'i etel a ca' tuulu, mentücü, ma' pataloo' u cüxte u sip'il a ca' tuul yoc'ol c'u' u betajoo' ti'i a winiqui. ");
INSERT INTO mopNT_vpl VALUES ("AC4_15","074_4_15","ACT","4","15","15","U se' joc'sajoo' aj Pedro etel aj Juan pach naj ca' tun cajoo' u tzicbalte tu bajil a nucuch winiqui. ");
INSERT INTO mopNT_vpl VALUES ("AC4_16","074_4_16","ACT","4","16","16","—¿C'u' a bel ti ca'a ti bete' ti'i a ca' tuulu? Tu jajil nooch milagro u betajoo' ti'i a moocho. Tulacal ichil a caj Jerusalen u yeeloo', mentücü, ma' patalo'on ti wadü' ti chen u tus a ca' tuulu,— cu t'anoo' a nucuch winic tu bajili. ");
INSERT INTO mopNT_vpl VALUES ("AC4_17","074_4_17","ACT","4","17","17","—Co'ne'ex ti wadoo' ti'i u tojil ti ma' u mas tzicbalticoo' a Jesus ti'i a ma'ax maca. Ti baalo'o, ma' tu mas t'iit'il u pectzil,— cu t'anoo' tu bajil. ");
INSERT INTO mopNT_vpl VALUES ("AC4_18","074_4_18","ACT","4","18","18","U ca' ocsajoo' aj Pedro etel aj Juana. —Ma' a tzicbaltique'ex ma'ax a ye'ique'ex 