﻿USE sofia;
DROP TABLE IF EXISTS sofia.moa_vpl;
CREATE TABLE moa_vpl (
  verseID VARCHAR(16) NOT NULL PRIMARY KEY,
  canon_order VARCHAR(12) NOT NULL,
  book VARCHAR(3) NOT NULL,
  chapter VARCHAR(3) NOT NULL,
  startVerse VARCHAR(3) NOT NULL,
  endVerse VARCHAR(3) NOT NULL,
  verseText TEXT CHARACTER SET UTF8 NOT NULL) ENGINE=MyISAM;
LOCK TABLES moa_vpl WRITE;
INSERT INTO moa_vpl VALUES ("MT1_1","070_1_1","MAT","1","1","1","Zesu Krisi ‑gbɔɔ mu 'ɛ 'wole‑ ‑gɛ. Zesu ‑o 'ke Davidi 'nranɛ‑ 'le. 'Bhɛɛ‑ ‑e ‑yaa 'ke Abraamu 'trɔnkala 'le. ");
INSERT INTO moa_vpl VALUES ("MT1_2","070_1_2","MAT","1","2","2","Abraamu Izaki ‑yaa; Izaki Zakɔbu ‑yaa; 'bhɛɛ‑ Zakɔbu Zuda 'pegee 'bhɛ nɛɛnɛ‑ 'gwlaan‑ mu 'ɛ 'yaa‑. ");
INSERT INTO moa_vpl VALUES ("MT1_3","070_1_3","MAT","1","3","3","Zuda Farɛsi 'pegee Zera ‑yaa ‑a na Tamaa ta; Farɛsi Esrɔn ‑yaa; 'bhɛɛ‑ Esrɔn Ramu ‑yaa; ");
INSERT INTO moa_vpl VALUES ("MT1_4","070_1_4","MAT","1","4","4","Aramu Aminadabu ‑yaa; 'bhɛɛ‑ Aminadabu Naasɔn ‑yaa; Naasɔn Salimɔ ‑yaa. ");
INSERT INTO moa_vpl VALUES ("MT1_5","070_1_5","MAT","1","5","5","Salimɔ Boazi ‑yaa Raabu ta; Boazi Obɛdi ‑yaa Ruti ta; 'bhɛɛ‑ Obɛdi Izai 'yaa‑; ");
INSERT INTO moa_vpl VALUES ("MT1_6","070_1_6","MAT","1","6","6","Izai ‑bhleŋgbe Davidi 'yaa‑; 'bhɛɛ‑ Davidi Salomɔ 'yaa‑ le 'la 'bhɛ ‑yaa 'elwale ‑sɔ Uri 'na 'le 'bhɛ ta. ");
INSERT INTO moa_vpl VALUES ("MT1_7","070_1_7","MAT","1","7","7","Salomɔ Roboamu ‑yaa; 'bhɛɛ‑ Roboamu Abia ‑yaa; Abia Azafi ‑yaa. ");
INSERT INTO moa_vpl VALUES ("MT1_8","070_1_8","MAT","1","8","8","Aza Zozafati 'yaa‑; 'bhɛɛ‑ Zozafati Zoramu 'yaa‑; Zoramu Oziasi ‑yaa; ");
INSERT INTO moa_vpl VALUES ("MT1_9","070_1_9","MAT","1","9","9","Oziasi Zoatamu ‑yaa; 'bhɛɛ‑ Zoatamu Akazi ‑yaa; Akazi Ezekiasi ‑yaa; ");
INSERT INTO moa_vpl VALUES ("MT1_10","070_1_10","MAT","1","10","10","Ezekiasi Manase 'yaa‑; 'bhɛɛ‑ Manase Amɔ 'yaa‑; Amɔ Zoziasi ‑yaa; ");
INSERT INTO moa_vpl VALUES ("MT1_11","070_1_11","MAT","1","11","11","Zoziasi ꞊kla Zekoniasi 'pegee 'bhɛ nɛɛnɛ‑ 'gwlaan‑ mu 'ɛ dɛ 'le; 'bhɛ ꞊kla ‑o ‑ja Izraɛli mu 'ɛ 'le luya 'yi Babilɔni 'waati 'la ba 'bhɛɛ‑ ba. ");
INSERT INTO moa_vpl VALUES ("MT1_12","070_1_12","MAT","1","12","12","Izraɛli mu 'ɛ dale blaan luya 'yi Babilɔni, 'ke Zekoniasi Salatiɛli 'yale‑; 'bhɛɛ‑ Salatiɛli Zorobabɛli 'yaa‑; ");
INSERT INTO moa_vpl VALUES ("MT1_13","070_1_13","MAT","1","13","13","Zorobabɛli Abiudi 'yaa‑; 'bhɛɛ‑ Abiubi Eliakimu 'yaa‑; Eliakimu Azɔɔ ‑yaa; ");
INSERT INTO moa_vpl VALUES ("MT1_14","070_1_14","MAT","1","14","14","Azɔɔ Sadɔki ‑yaa; 'bhɛɛ‑ Sadɔki Akimu ‑yaa; Akimu Eliudi ‑yaa; ");
INSERT INTO moa_vpl VALUES ("MT1_15","070_1_15","MAT","1","15","15","Eliudi Eleazaa 'yaa‑; 'Bhɛɛ‑ Eleazaa Matani 'yaa‑; Matani Zakɔbu ‑yaa; ");
INSERT INTO moa_vpl VALUES ("MT1_16","070_1_16","MAT","1","16","16","Zakɔbu Zozɛfu ‑yaa; 'bhɛɛ‑ Zozɛfu ꞊kla 'ke Mari ꞊nɔɔ 'le. Mari ꞊kla 'ke Zesu nɛɛ 'le. 'Bhɛɛ‑ ‑o Zesu 'tɔkpaa‑ Krisi: 'Bhɛ 'yi ‑le dɔɔ ‑Waanbhaa' mɛɛ 'la zan makwan‑. ");
INSERT INTO moa_vpl VALUES ("MT1_17","070_1_17","MAT","1","17","17","'Kee‑ san *Abraamu ma, 'bhɛɛ‑ 'kee‑ nu 'tɛnlɛ‑ Davidi ma, 'flan vu ta yiziɛ ‑le ‑o pleŋ‑. 'Bhɛɛ‑ 'kee‑ san Davidi ma, 'kee‑ nu 'tɛnlɛ‑ Izraɛli mu 'ɛ gele ma luya 'yi Babilɔni, 'flan vu ta yiziɛ ‑le ‑o pleŋ‑. 'Bhɛɛ‑ 'kee‑ san 'bhɛ 'waati 'ɛ ma, 'kee‑ nu 'tɛnlɛ‑ Zesu Krisi 'yale‑ ma, 'bhɛ ꞊kla 'ezin‑ 'flan vu ta yiziɛ. ");
INSERT INTO moa_vpl VALUES ("MT1_18","070_1_18","MAT","1","18","18","Zesu Krisi ‑yaa gɔnɛ‑ 'lɛɛ‑ 'bhɛɛ‑ gbɛɛn‑. Zozɛfu dɔle ‑yaa Zesu nɛɛ Mari zi. 'Sani‑ ‑o nu 'fɛ klɛlɛ do 'waati 'la ba, 'ke Mari kpɛ 'sile Lii 'Weŋ 'ɛ ‑glɔɔya' 'ɛ 'le. ");
INSERT INTO moa_vpl VALUES ("MT1_19","070_1_19","MAT","1","19","19","'Bhɛ ya 'ɛ 'yi, ‑a ‑nɔɔ Zozɛfu 'laa ‑yaa ‑a zi 'bhii‑ 'bhɛ 'a 'tɔsiɛ‑ mɔkpɛn' 'yrɛ ma kpataakpa, ‑amasrɔyi 'bhɛ 'yaa‑ 'ke mɛɛ wlan do 'le. 'Bhɛla‑ ‑yile, 'ke 'bhɛ 'a 'lɛdulale dɔɔ 'bhɛ bhɛleya gole‑ ‑a ma gaanyi'. ");
INSERT INTO moa_vpl VALUES ("MT1_20","070_1_20","MAT","1","20","20","'Bhɛ 'yaa‑ 'bhɛ 'kpeelɛdan 'zi bhla 'la ba 'bhɛ ‑za 'ɛ ma, 'bhɛɛ‑ 'bhɛ 'yaa‑ yi pla ‑yrekpaa' do, 'ke gbiŋ do 'klale 'bhɛ 'yrɛ ba. 'Bhɛɛ‑ 'ke ‑Waanbhaa' a ‑mlɛkɛ' do 'a 'pele 'bhɛ ni gbiŋ 'ɛ na dɔɔ: «Davidi 'nranɛ‑ Zozɛfu, 'yaa ‑gblaanlɛ' Mari 'sile‑ ma 'e 'na 'le; ‑amasrɔyi ‑a kpɛle ‑o 'ke ‑nɛ 'la 'le bhe, 'bhɛ da 'zi Lii 'Weŋ 'ɛ ‑glɔɔya' 'ɛ 'bhɛɛ‑ ba. ");
INSERT INTO moa_vpl VALUES ("MT1_21","070_1_21","MAT","1","21","21","‑E nu ‑a yalɛ 'ke ‑nɛ 'gwlaan‑ do 'le, 'bhɛɛ‑ 'e nu 'bhɛ 'tɔkpalɛ Zesu, 'bhɛ 'yi ‑le dɔɔ Mɛɛ ‑Bhee Mi, ‑amasrɔyi 'yele‑ nu ‑a 'si mu 'ɛ golɛ waa ‑za 'yɔɔ‑ mu 'ɛ 'yi.» ");
INSERT INTO moa_vpl VALUES ("MT1_22","070_1_22","MAT","1","22","22","'Bhɛ ‑za mu 'lɛɛ‑ 'kpɛn ꞊kla, 'kooko‑ Mɛɛzan ‑jan 'la ꞊kpaa ‑a ‑lɛla' janwo mi Ezai 'lii 'elwale gban ‑sɔ 'bhɛ 'lɛsɔ‑. ");
INSERT INTO moa_vpl VALUES ("MT1_23","070_1_23","MAT","1","23","23","'Bhɛ ‑jan 'ɛ 'bhɛ ‑le ‑gɛ: ‑Ka 'ka 'yrɛkpa doo! ‑Gblanɛ 'la 'ke yaa 'gwlaan‑ dɔ, ‑e nu kpɛ 'silɛ‑, 'bhɛɛ‑ ‑e nu ‑a yalɛ 'ke ‑nɛ 'gwlaan‑ do 'le. ‑O nu 'bhɛ 'tɔkpalɛ Emanuɛli.» ('Bhɛ 'yi ‑le dɔɔ ‑Waanbhaa' ‑o ‑kɔɔ' ba.) ");
INSERT INTO moa_vpl VALUES ("MT1_24","070_1_24","MAT","1","24","24","Zozɛfu bwele, Mɛɛzan a ‑mlɛkɛ' 'ɛ 'bhɛ ‑jan 'la ꞊woa ‑a ni 'kee‑ 'bhɛ 'yizaklɛle. 'Bhɛ ya 'ɛ 'yi, 'kee‑ Mari 'sile ‑a na 'le. ");
INSERT INTO moa_vpl VALUES ("MT1_25","070_1_25","MAT","1","25","25","'Duŋ‑ Zozɛfu 'pegee Mari 'laa 'fɛ klɛlɛ do 'ke 'bhɛ ge 'tɛnlɛ‑ 'bhɛ 'nɛ 'gwlaan‑ 'ɛ 'yale‑ ma. Zozɛfu ‑nɛ 'ɛ 'tɔkpaa‑ Zesu. ");
INSERT INTO moa_vpl VALUES ("MT2_1","070_2_1","MAT","2","1","1","Zesu ꞊yaa Bɛtelɛmu, Zude 'klɛɛn 'ɛ 'yi ‑wa 'nɛ do ta 'waati 'la ba, 'ke ‑bhleŋgbe Erɔdi 'yaale‑ ‑o Izraɛli mu 'ɛ 'wiiŋ‑. ‑A yale blaan, 'ke ‑zadɔ' mu ‑lɛdo' dale‑ ‑yretɛbhɛ ‑wlɛnyrɛ' ꞊nɔɔ, 'bhɛɛ‑ 'ke ‑o nule‑ Zeruzalɛmu. ‑O ‑yaa laflɛ' 'yi mlɛklɛnnɛ mu 'ɛ 'taawogbɛya 'ɛ 'bhɛɛ‑ daan. ");
INSERT INTO moa_vpl VALUES ("MT2_2","070_2_2","MAT","2","2","2","‑O bhɔle Zeruzalɛmu, 'ke ‑o mɛɛ mu ‑lrɔkpale dɔɔ: «‑O ‑nɛ 'la 'yaa‑ 'bhɛɛ‑ 'kee‑ nu klɛlɛ 'ke Zuufu mu a ‑bhleŋgbe 'le ‑yoo 'naa ɛɛ? 'Wa ‑tɔɔmasie mlɛklɛnnɛ do ‑ya ‑yretɛbhɛ ‑wlɛnyrɛ' ꞊nɔɔ, 'bhɛla‑ ‑yile 'o ꞊nwa ‑a gbayrɛ nɔɔ‑.» ");
INSERT INTO moa_vpl VALUES ("MT2_3","070_2_3","MAT","2","3","3","‑Bhleŋgbe Erɔdi 'bhɛ ‑jan 'ɛ 'male‑, 'ke 'yee‑ 'pegee Zeruzalɛmu mu 'ɛ 'kpɛn zrubatɛdɔle. ");
INSERT INTO moa_vpl VALUES ("MT2_4","070_2_4","MAT","2","4","4","'Bhɛ ya 'ɛ 'yi, 'kee‑ 'sraka 'lɛna mu ‑lɛɛ mu 'ɛ 'pegee 'Toŋ daan mu 'ɛ 'kpɛn 'siile, 'bhɛɛ‑ 'kee‑ 'mu ‑lrɔkpale dɔɔ: «‑Waanbhaa' Mɛɛ ‑Bhee Mi ‑Kpɔsɔɔ 'la ‑yaa' ‑janwoa, ‑e nu yalɛ yrɛ 'ɛ ‑dela nɔɔ‑ ɛɛ?» ");
INSERT INTO moa_vpl VALUES ("MT2_5","070_2_5","MAT","2","5","5","'Bhɛ klɛle 'tɛ, 'ke ‑wa ‑lɛkunle ‑a ni dɔɔ: «‑E nu yalɛ Bɛtelɛmu, Zude 'klɛɛn 'ɛ 'yi ‑wa 'nɛ do ta. ‑Amasrɔyi ‑Waanbhaa' ‑lɛla' janwo mi do ‑jan 'lɛɛ‑ yɔɔndia‑ ‑a ba zayi' 'elwale gban ‑sɔ dɔɔ: ");
INSERT INTO moa_vpl VALUES ("MT2_6","070_2_6","MAT","2","6","6","‹'Bhi Bɛtelɛmu ‑wa 'la ‑yoo Zude 'klɛɛn 'ɛ 'yi bhe! 'Yoo‑ 'ke Zude 'klɛɛn 'ɛ 'yi ‑wa mu 'ɛ 'kpɛn ba ‑wa 'fiɛntrɔnnɛ 'le 'dɛ! ‑Amasrɔyi 'e ba mi do nu klɛlɛ ‑kuŋlii do 'le, 'bhɛɛ‑ 'bhɛ ‑le nu 'an Izraɛli 'si mu 'ɛ 'lɛdɔɔlɛ zi ‑lrele' ta 'bhii‑ ‑bhlaa gooba mi do ‑yaa' ‑bhlaa mu 'ɛ 'lɛdɔɔ‑ gɔnɛ‑ 'la gbɛɛn‑.›» ");
INSERT INTO moa_vpl VALUES ("MT2_7","070_2_7","MAT","2","7","7","'Bhɛ klɛle 'tɛ, 'ke Erɔdi 'woo‑ ‑zadɔ' mu 'ɛ 'siile gaanyi', 'bhɛɛ‑ 'ke ‑yoo ‑lrɔkpale mlɛklɛn‑ 'ɛ 'pwɛla‑ 'waati 'la ba 'bhɛ ma. 'Bhɛɛ‑ 'ke ‑o 'bhɛ 'waati 'ɛ 'pele 'a ni. ");
INSERT INTO moa_vpl VALUES ("MT2_8","070_2_8","MAT","2","8","8","'Bhɛ blaan, 'ke ‑ya pele‑ ‑o ni 'kaa: «‑Ka ge 'yee‑ ‑nɛ 'ɛ malrɔkpa kplankplan Bɛtelɛmu; 'ke 'kaa ꞊ya, ‑ka nu 'ŋ 'kpeelɛkan, 'kooko‑ 'mi 'gbu ge 'ezin‑ ‑a gbalɛ.» ");
INSERT INTO moa_vpl VALUES ("MT2_9","070_2_9","MAT","2","9","9","‑O yanle ‑bhleŋgbe Erɔdi 'wojan‑ 'ɛ malele, 'ke ‑o gele‑. ‑O ‑yaa 'taa 'ɛ ta bhla 'la ba, 'ke ‑o ‑yrɛkpale 'yee‑ mlɛklɛn‑ do 'kpɔ 'la ‑wa ꞊ya 'elwale ‑yretɛbhɛ ‑wlɛnyrɛ' ꞊nɔɔ 'bhɛ ma. 'Bhɛ dɔle ‑yaa ‑o trala. 'Duŋ‑ 'bhɛ 'bhɔle‑ ‑nɛ 'yiɛntɛnnɛ 'ɛ 'yaa‑ 'fɛ 'la ꞊la 'bhɛ trala, 'ke 'bhɛ dulale. ");
INSERT INTO moa_vpl VALUES ("MT2_10","070_2_10","MAT","2","10","10","'Bhɛ klɛle 'tɛ, ‑o ‑yrɛkpale mlɛklɛn‑ 'ɛ ma 'ke ‑o zru 'kpaale 'egbɛnɛle. ");
INSERT INTO moa_vpl VALUES ("MT2_11","070_2_11","MAT","2","11","11","'Bhɛ ya 'ɛ 'yi, 'ke ‑o wlale‑ 'bhɛ 'fɛ 'ɛ ꞊la, 'bhɛɛ‑ 'ke ‑o ‑nɛ 'yiɛntɛnnɛ 'ɛ 'yele ‑a nɛɛ Mari 'kɔɔ. 'Bhɛ klɛle 'tɛ, 'ke ‑woo 'kpɔ zɛnle‑ 'trɛ ma, 'bhɛɛ‑ 'ke ‑o ‑nɛ 'yiɛntɛnnɛ 'ɛ gbale‑. 'Bhɛ blaan, 'ke ‑woo ta 'kwe mu 'ɛ 'liigole, 'bhɛɛ‑ 'ke ‑o glaan' mu 'nale‑ 'bhɛ ni: ‑Can 'pegee ‑lasiklɔɔ ‑gblɛn 'nrale‑ ‑glɔɔn plɛ: ansansi 'pegee miri. ");
INSERT INTO moa_vpl VALUES ("MT2_12","070_2_12","MAT","2","12","12","'Bhɛ blaan, 'ke ‑Waanbhaa' ‑o 'kpeelɛkanle gbiŋ na 'kaa waa niinalɛ ‑o ‑zanta' Erɔdi ba 'ezin‑. 'Bhɛla ‑zayile, ‑o niina‑ bhla 'ɛ zi ‑o ba 'klɛɛn 'ɛ 'yi, ‑o zi ‑bhɛɛke' ꞊sia. ");
INSERT INTO moa_vpl VALUES ("MT2_13","070_2_13","MAT","2","13","13","‑Zadɔ' mu 'ɛ gele blaan, 'ke Mɛɛzan a ‑mlɛkɛ' do 'pwɛle‑ Zozɛfu ba 'ezin‑ gbiŋ na, 'bhɛɛ‑ 'ke 'bhɛ 'a 'pele ‑a ni dɔɔ: «'E 'wlɛn‑, ‑nɛ 'yiɛntɛnnɛ 'ɛ 'pegee ‑a nɛɛ 'kun, 'bhɛɛ‑ ‑ka blasaan‑ 'ke 'ka ge Ezipu 'klɛɛn 'ɛ 'yi; bo ‑a ꞊nɔɔ ye ‑sɔ 'fɔke 'mi 'a ꞊pia 'e ni 'e nu yi 'la 'le, 'bhɛɛ‑ 'ka nu. ‑Amasrɔyi Erɔdi nu ‑nɛ 'yiɛntɛnnɛ 'ɛ ziglinlɛ ‑a dɛ zayi'.» ");
INSERT INTO moa_vpl VALUES ("MT2_14","070_2_14","MAT","2","14","14","'Bhɛ klɛle 'tɛ, Zozɛfu bwele‑, 'kee‑ ‑nɛ 'ɛ 'pegee ‑a nɛɛ 'kunle, 'bhɛɛ‑ 'ke ‑o gele‑ Ezipu 'klɛɛn 'ɛ 'yi ‑bi 'ɛ zi. ");
INSERT INTO moa_vpl VALUES ("MT2_15","070_2_15","MAT","2","15","15","‑E ꞊bwa Ezipu 'klɛɛn 'ɛ 'yi, 'ke 'bhɛ ge 'tɛnlɛ‑ Erɔdi gale ma. 'Bhɛ ‑za 'ɛ Mɛɛzan ‑lɛla' janwo mi Oze ‑jan 'la ꞊woa 'bhɛ 'lɛswa꞊. 'Bhɛ ‑jan 'ɛ 'yaa‑ dɔɔ: «'Mi 'ŋ gbe 'ɛ 'siila‑ 'kaa ‑e go Ezipu 'klɛɛn 'ɛ 'yi.» ");
INSERT INTO moa_vpl VALUES ("MT2_16","070_2_16","MAT","2","16","16","Erɔdi 'a 'yele 'bhii‑ ‑zadɔ' mu 'ɛ ‑dawli' ꞊kpaa ‑a gbɛ ta, 'ke ‑ya zrupliile 'egbɛnɛle. ‑Ayile 'kee‑ mɛɛ mu winbɔle 'kaa 'mu ge Bɛtelɛmu ‑wa 'ɛ 'pegee 'bhɛ kpɛ ma ‑wa mu 'ɛ ta, 'kooko‑ ‑nɛ 'gwlaan‑ mu 'la 'kpɛn lɛɛ ‑o lɛɛ do 'pegee lɛɛ plɛ pleŋ‑ ‑o 'mu 'kpɛn dɛ. 'Bhɛ lɛɛ ‑lii yɛkɛ‑ 'ɛ 'yaa‑ ‑bɛŋgo' ‑zadɔ' mu 'ɛ mlɛklɛnnɛ mu 'ɛ ꞊ya 'waati 'la ba 'bhɛ blaan lɛɛ ‑lii yɛkɛ‑ 'ɛ 'bhɛɛ‑ 'le. ");
INSERT INTO moa_vpl VALUES ("MT2_17","070_2_17","MAT","2","17","17","'Bhɛ ya 'ɛ 'yi, Erɔdi klɛza ‑yɔɔ 'ɛ 'bhɛ ‑Waanbhaa' ‑lɛla' janwo mi Zeremi 'wojan‑ 'ɛ 'lɛswa꞊. ");
INSERT INTO moa_vpl VALUES ("MT2_18","070_2_18","MAT","2","18","18","Zeremi ‑jan 'la ꞊woa 'elwale gban ‑sɔ 'bhɛ ‑le ‑gɛ: «'O 'trɔn ‑o ‑gbekanwli mu 'pegee 'dimi ma wisiwli ‑gbɛnɛ mu ma Rama ‑wa 'ɛ ta. Rasɛli ‑le ‑a ‑nɛ mu 'ɛ wisi' zii', 'bhɛɛ‑ yaa ‑o dɔle‑ ‑a ‑la 'ke ‑wa taga; ‑amasrɔyi ‑a ‑nɛ mu 'ɛ ‑gaa.» ");
INSERT INTO moa_vpl VALUES ("MT2_19","070_2_19","MAT","2","19","19","Erɔdi gale blaan, 'ke Mɛɛzan ‑Waanbhaa' a ‑mlɛkɛ' do 'pwɛle Zozɛfu ba gbiŋ na Ezipu 'klɛɛn 'ɛ 'yi. ");
INSERT INTO moa_vpl VALUES ("MT2_20","070_2_20","MAT","2","20","20","‑E pe Zozɛfu ni dɔɔ: «'E 'wlɛn‑, ‑nɛ 'ɛ 'pegee ‑a nɛɛ 'kun, 'bhɛɛ‑ 'ka niina‑ 'ka ‑zan Izraɛli 'ɛ 'klɛɛn 'yi, ‑amasrɔyi mɛɛ 'la zan mu ‑yaa ‑nɛ 'ɛ dɛyrɛ ‑glin 'zi, 'mu 'laa ‑o ‑li 'mu 'yrɛ ma.» ");
INSERT INTO moa_vpl VALUES ("MT2_21","070_2_21","MAT","2","21","21","'Bhɛ klɛle 'tɛ, 'ke Zozɛfu 'e 'wlɛnle‑, 'kee‑ ‑nɛ 'ɛ 'pegee ‑a nɛɛ 'kunle, 'bhɛɛ‑ 'kee‑ niinale ‑a ‑zanta' Izraɛli 'klɛɛn 'ɛ 'yi. ");
INSERT INTO moa_vpl VALUES ("MT2_22","070_2_22","MAT","2","22","22","'Duŋ‑ ‑o bhɔle Izraɛli 'klɛɛn 'ɛ 'yi; 'bhɛɛ‑ Zozɛfu 'a 'male‑ 'kaa Arikelausi ‑yalaa' ‑a dɛ Erɔdi a ‑bhleŋgbeya yaayrɛ 'ɛ ꞊nɔɔ Zude 'klɛɛn 'ɛ ta, 'ke ‑gblaan 'klale ‑a ‑yi 'bhɛ 'klɛɛn 'ɛ 'yi gele ma. 'Bhɛ ya 'ɛ 'yi, 'ke ‑Waanbhaa' 'a 'kpeelɛkanle gbiŋ na 'kaa yaa gelɛ Zude 'klɛɛn 'ɛ 'yi, 'bhɛɛ‑ 'duŋ‑ ‑e ge Galile 'klɛɛn 'ɛ 'yi. ");
INSERT INTO moa_vpl VALUES ("MT2_23","070_2_23","MAT","2","23","23","'Bhɛla‑ ‑yile, ‑e ‑ja yaalɛ Galile 'klɛɛn 'yi ‑wa 'nɛ do ta: ‑O ‑yaa 'bhɛ ‑wa 'ɛ sii Nazarɛti. ‑Ayile, ‑Waanbhaa' ‑lɛla' ‑janwo' mi 'ɛ 'wojan‑ 'ɛ 'lɛswa꞊ ‑gee' dɔɔ: «‑O nu a 'siilɛ‑ Nazarɛti mi.» ");
INSERT INTO moa_vpl VALUES ("MT3_1","070_3_1","MAT","3","1","1","Zozɛfu 'pegee ‑a na Mari, 'bhɛɛ‑ 'bhɛ 'nɛ 'ɛ, ‑o 'yaa‑ 'waati 'la ba Nazarɛti, 'ke Mɛɛ Wiiŋfɛ' Mi Zaan 'pwɛle ‑a ‑yi Zude 'klɛɛn 'ɛ 'yi ‑kpe 'ɛ ta, 'bhɛɛ‑ 'kee‑ ‑Waanbhaa' a ‑jan 'ɛ 'wole‑ 'sanle 'tɛ. ");
INSERT INTO moa_vpl VALUES ("MT3_2","070_3_2","MAT","3","2","2","‑E ‑yaa pe 'zi mɛɛ mu 'ɛ ni dɔɔ: «‑Ka 'ploo‑ ‑za 'yɔɔ‑ klɛle ma, 'bhɛɛ‑ ‑ka 'ka zru 'niina‑ ‑Waanbhaa' ba, 'ke 'ka 'ka taawogbɛya 'ɛ mabɔɔ. ‑Amasrɔyi laanima ‑Waanbhaa' 'ɛ ‑yaa' ‑bhleŋgbeya 'yaa‑ bhla 'ɛ ꞊bhwa ‑wa ‑din.» ");
INSERT INTO moa_vpl VALUES ("MT3_3","070_3_3","MAT","3","3","3","‑Waanbhaa' ‑lɛla' janwo mi Ezai ‑janwoa 'yee‑ Zaan 'la ba zayi' 'elwale gban ‑sɔ dɔɔ: «Mɛɛ do ‑le ‑toorodɔ 'zi ‑kpe 'ɛ ta 'kaa: ‑Ka Mɛɛzan a zibhɛ 'ɛ 'lɛmagaan, ‑kaa 'taawo‑ zibhɛ mu 'ɛ 'lɛdɔɔ‑!» ");
INSERT INTO moa_vpl VALUES ("MT3_4","070_3_4","MAT","3","4","4","'Bhɛ klɛgbɛya 'ɛ 'yi, Mɛɛ Wiiŋfɛ' Mi Zaan ta dunɛ‑ 'ɛ 'tanle‑ ‑yaa 'ke 'yɔɔnma 'ciɛ‑ 'le, 'bhɛɛ‑ wi 'flɛ 'sɛntru do dɔle‑ ‑yaa ‑a 'saanla; ‑e ‑yaa 'siesie‑ ‑gama mu 'pegee ‑bɔn 'yi ‑zrɔ 'yrɔn mu ‑la bhle. ");
INSERT INTO moa_vpl VALUES ("MT3_5","070_3_5","MAT","3","5","5","'Bhɛ 'yi bhe, Zeruzalɛmu mu oo, Zude 'klɛɛn 'yi mu 'kpɛn oo, 'bhɛ 'pegee Zrudɛn yue ta mu, ‑o 'kpɛn 'yaa‑ nu 'zi ‑a ba. ");
INSERT INTO moa_vpl VALUES ("MT3_6","070_3_6","MAT","3","6","6","'Ke ‑o ‑yaa yan ‑waa' ‑za 'yɔɔ‑ mu 'ɛ 'pelele kpataakpa mɔkpɛn' 'yrɛ ma, 'bhɛɛ‑ Zaan ‑yaa ‑o wiiŋfɛ' Zrudɛn yue 'ɛ ba 'tɛ. ");
INSERT INTO moa_vpl VALUES ("MT3_7","070_3_7","MAT","3","7","7","'Duŋ‑, Zaan 'a 'yele‑ 'bhii‑ Farizi mu ‑bebe 'pegee Saduse mu ‑bebe ‑yaa nu 'zi 'mu wiiŋfɛyrɛ nɔɔ‑ ‑a ba, 'ke ‑ya pele‑ 'mu ni dɔɔ: «‑Bhlu 'plalu mɛɛ mu! ‑Dele pe 'ka ni dɔɔ 'ka blasan‑ ‑Waanbhaa' a yran 'la ‑yoo zan bhe 'bhɛ 'lɛɛ‑ ɛɛ? ");
INSERT INTO moa_vpl VALUES ("MT3_8","070_3_8","MAT","3","8","8","‑Kaa zrɔn doo 'ka klɛza mu 'ɛ ma 'bhii‑ 'ka 'ka zru ‑niinaa' ‑Waanbhaa' ba, 'bhɛɛ‑ 'ka 'ploola‑ ‑za 'yɔɔ‑ klɛle ma. ");
INSERT INTO moa_vpl VALUES ("MT3_9","070_3_9","MAT","3","9","9","'Ka 'laa bolɛ ‑a pele ma 'ka 'gbu 'kpee dɔɔ: ‹'O mɔɔ ‑gbɔɔ ‑le 'ke Abraamu 'le 'dɛ.› ‑Amasrɔyi 'mi pe 'ka ni 'ŋ 'sɔwɛɛ ma dɔɔ ‑Waanbhaa' sɔ vlɛ mu 'la bhe ‑o mabɔɔle, 'bhɛɛ‑ ‑yoo klɛ 'ke Abraamu 'kpee yi mu 'le. ");
INSERT INTO moa_vpl VALUES ("MT3_10","070_3_10","MAT","3","10","10","'Bhɛ ya 'ɛ 'yi, ‑Waanbhaa' a poo 'ɛ 'lɛkpale ‑o, 'bhɛɛ‑ ‑yoo zan ‑yri diiŋ mu 'ɛ takanlɛ 'ke ‑ya san ‑o 'sɛnɛ ma. 'Ke ‑yri diiŋ 'oo ‑yri diiŋ 'la bhɛ 'laa 'bhɛ bhaa ‑lrele' klɛlɛ, ‑e nu 'bhɛ takanlɛ 'bhɛɛ‑ ‑e 'bhɛ blin 'tɛ 'yi. ");
INSERT INTO moa_vpl VALUES ("MT3_11","070_3_11","MAT","3","11","11","'Ka 'ka 'taawogbɛya 'ɛ maniilawoa, 'bhɛla‑ ‑yile 'mi ‑o 'ka 'wiiŋfɛ zii' 'ke ‑yi 'le. 'Duŋ‑ mɛɛ 'la 'bhɛ ‑o zan 'mi blaan, 'bhɛ zan 'ɛ ‑glɔɔ 'yiya‑ 'mi ni, ‑a ‑gaale' laa ‑o 'mi ba 'ke 'mi 'a gaan ma ‑sawla mu 'ɛ go. 'Yele‑ nu 'ka 'wiiŋfɛlɛ 'ke Lii 'Weŋ 'ɛ 'pegee 'tɛ 'le. ");
INSERT INTO moa_vpl VALUES ("MT3_12","070_3_12","MAT","3","12","12","‑Siɛn do ‑o ‑a 'kɔɔ. ‑E nu ‑mlɔ bhɛ mu 'pegee ‑mlɔ ‑gboo mu 'ɛ bapianlɛ, 'bhɛɛ‑ ‑yoo go 'eke‑ ma. ‑E nu ‑mlɔ bhɛ mu 'ɛ 'klalɛ‑ bɔtɔ 'yi, 'bhɛɛ‑ ‑e nu ‑mlɔ ‑gboo mu 'ɛ 'kpacielɛ 'tɛ 'la 'ke ‑yaa ‑lii ‑titi 'bhɛ 'yi.» ");
INSERT INTO moa_vpl VALUES ("MT3_13","070_3_13","MAT","3","13","13","‑Yrekpaa' do, Zesu ‑daa Galile 'trɛ 'ɛ ta, 'bhɛɛ‑ ‑e ꞊nwa Zrudɛn yue 'ɛ ta. 'Bhɛɛ‑ ‑ya mabɛɛnna Zaan ‑din, 'kooko‑ 'bhɛ 'a 'wiiŋfɛ ‑yi 'ɛ ba. ");
INSERT INTO moa_vpl VALUES ("MT3_14","070_3_14","MAT","3","14","14","'Bhɛ klɛle 'tɛ, 'ke Zaan 'e ‑gbɛdɔle ‑a 'wiiŋfɛle ma ‑yi 'ɛ ba, 'bhɛɛ‑ 'ke 'bhɛ 'a 'pele ‑a ni dɔɔ: «'Mi ‑le ‑yaa sɔ bi 'ke 'ŋ ge 'e ba 'bhɛɛ‑ 'ye 'ŋ 'wiiŋfɛ‑, 'bhɛɛ‑ 'bhi ‑le zan 'e 'wiiŋfɛlɛ 'mi ba ɛɛ?» ");
INSERT INTO moa_vpl VALUES ("MT3_15","070_3_15","MAT","3","15","15","'Bhɛ klɛle 'tɛ, 'ke Zesu 'a 'pele ‑a ni dɔɔ: «Dɔ ‑a klɛle 'la ‑zɔn. ‑Amasrɔyi, 'o nu 'sɔlɛ‑ ‑Waanbhaa' zru maza 'ɛ 'kpɛn 'lɛsɔle 'bhɛɛ‑ gbɛɛn‑ ‑gee'.» 'Bhɛ ya 'ɛ 'yi, 'ke Zaan dɔle‑ Zesu 'wiiŋfɛle ‑la. ");
INSERT INTO moa_vpl VALUES ("MT3_16","070_3_16","MAT","3","16","16","‑E yanle, 'ke Zesu 'pwɛle ‑yi 'ɛ ba. 'Bhɛ yrɛ do 'kpɔ 'ɛ ꞊nɔɔ bhe, 'ke laflɛ' 'liigole, 'bhɛɛ‑ 'ke Zesu 'yrɛkpale ‑Waanbhaa' Lii 'ɛ ma; 'bhɛ ‑zinaa' 'a ta 'bhii‑ ‑bhooladɔ maannɛ‑ do gbɛɛn‑. ");
INSERT INTO moa_vpl VALUES ("MT3_17","070_3_17","MAT","3","17","17","'Bhɛɛ‑ 'ke ‑weli' do dale‑ laanima, 'ke 'bhɛ 'a 'pele dɔɔ: «'Ŋ gbe 'la ‑za sɔ 'ŋ ni 'egbɛnɛle 'yele‑ ‑gɛ, 'yele‑ 'ŋ zrukpalaa 'egbɛnɛle.» ");
INSERT INTO moa_vpl VALUES ("MT4_1","070_4_1","MAT","4","1","1","'Bhɛ blaan, 'ke Lii 'Weŋ 'ɛ gele‑ 'ke Zesu 'le ‑kpe 'ɛ ta, 'kooko‑ ‑Setran' 'a 'yidan‑, 'bhɛɛ‑ ‑ya balaa' ‑za 'yɔɔ‑ 'yi. ");
INSERT INTO moa_vpl VALUES ("MT4_2","070_4_2","MAT","4","2","2","Zesu ‑yrekpaa' mia plɛ 'pegee ‑bi mia plɛ ꞊kla 'ke yaa pɛ 'kedo‑ 'kpɔ bhle. 'Bhɛɛ‑ gbɔn 'a ꞊dia. ");
INSERT INTO moa_vpl VALUES ("MT4_3","070_4_3","MAT","4","3","3","'Bhɛ 'yi, 'ke ‑Setran' 'e 'mabɛɛnle Zesu ‑din, 'bhɛɛ‑ 'ke ‑ya pele‑ ‑a ni dɔɔ: «'Ke 'yoo‑ 'ke ‑Waanbhaa' Gbe 'ɛ 'le, ‑a pe kpoti mu 'la bhe ‑o ni dɔɔ ‑woo mabɔɔ 'bhɛɛ‑ ‑o klɛ 'ke pɛle mu 'le» ");
INSERT INTO moa_vpl VALUES ("MT4_4","070_4_4","MAT","4","4","4","'Bhɛ klɛle 'tɛ, 'ke Zesu 'a zikpale ‑a ni dɔɔ: «‑A yɔɔndɛle ‑o ‑Waanbhaa' 'a 'Sɛwɛ 'ɛ 'yi dɔɔ: ‹Bhaaplɛŋ ‑si 'ɛ ‑daŋ' 'laa ‑o 'ke pɛle do ‑kplɛnnɛ' 'le; 'duŋ‑ ‑jan mu 'la 'kpɛn da ‑Waanbhaa' ‑lii 'mu ‑le ‑si na bhaaplɛŋ ni 'ezin‑.›» ");
INSERT INTO moa_vpl VALUES ("MT4_5","070_4_5","MAT","4","5","5","'Bhɛ blaan, 'ke ‑Setran' Zesu 'sile, 'kee‑ gele‑ 'kɛle‑ Zeruzalɛmu ‑Waanbhaa' a ‑wa 'weŋ 'ɛ ta; 'bhɛɛ‑ 'ke ‑ya 'kpale ‑Waanbhaa' *Gba 'Fɛ ‑Gbɛnɛ 'ɛ 'wiiŋ‑. ");
INSERT INTO moa_vpl VALUES ("MT4_6","070_4_6","MAT","4","6","6","'Bhɛɛ‑ 'ke ‑ya pele‑ ‑a ni dɔɔ: «'Kee‑ 'yoo‑ 'ke ‑Waanbhaa' Gbe 'ɛ ‑le, 'ploo 'e 'gbu ma 'bhɛɛ‑ 'e balaa' 'trɛ ma. ‑Amasrɔyi ‑a yɔɔndɛle ‑o Waanbhaa' a 'Sɛwɛ 'yi dɔɔ: ‹‑Waanbhaa' nu ‑yaa' ‑mlɛkɛ' mu 'ɛ winbɔlɛ 'e ‑zayi'. 'Bhɛɛ‑ ‑o nu 'e binalɛ ‑o gbɛ ‑yi, 'kooko‑ 'e gaan madiŋ 'laa wo vlɛ ma.›» ");
INSERT INTO moa_vpl VALUES ("MT4_7","070_4_7","MAT","4","7","7","Zesu 'a zikpaa‑ ‑a ni dɔɔ: «‑A yɔɔndɛle ‑o ‑Waanbhaa' a 'Sɛwɛ 'ɛ 'yi 'ezin‑ dɔɔ: ‹'Yaa Mɛɛzan ‑Waanbhaa' ‑yidanlɛ.›» ");
INSERT INTO moa_vpl VALUES ("MT4_8","070_4_8","MAT","4","8","8","'Bhɛ blaan, 'ke ‑Setran' gele‑ 'kɛle‑ 'ezin‑ vlɛ gɔɔn 'trole‑ do 'wiiŋ‑, 'bhɛɛ‑ 'kee‑ 'drunyan ta ‑bhleŋgbe 'klɛɛn mu 'ɛ 'kpɛn 'pegee 'mu 'lreleya mu 'ɛ 'kpɛn zrɔnle‑ ‑a ni. ");
INSERT INTO moa_vpl VALUES ("MT4_9","070_4_9","MAT","4","9","9","'Bhɛɛ‑ ‑e pe Zesu ni 'tɛ dɔɔ: «'Ŋ nu 'bhɛ ‑bhleŋgbe 'klɛɛn mu 'ɛ 'kpɛn 'nalɛ‑ 'e ni, 'kooko‑ 'e yalaa' ‑o wiiŋ, 'ke 'yee 'kpɔ ꞊zian 'ŋ 'lɛɛ, 'bhɛɛ‑ 'ke 'ye 'ŋ ‑gbaa 'bhii‑ 'yaa‑ ‑waanbhaa'.» ");
INSERT INTO moa_vpl VALUES ("MT4_10","070_4_10","MAT","4","10","10","'Bhɛ klɛle 'tɛ, 'ke Zesu 'a 'pele 'a ni dɔɔ: «'E 'pleŋgo‑ 'ŋ ma ‑Setran'! ‑Amasrɔyi, ‑a yɔɔndɛle ‑o ‑Waanbhaa' a 'Sɛwɛ 'yi 'kaa: ‹Bhaaplɛŋ Mɛɛzan do ‑kplɛnnɛ' ‑la gba, 'bhɛɛ‑ 'yaa ‑Waanbhaa' ‑bhɛɛke' do 'kpɔ gbalɛ 'yee‑ blaan.›» ");
INSERT INTO moa_vpl VALUES ("MT4_11","070_4_11","MAT","4","11","11","'Bhɛ klɛle 'tɛ, 'ke ‑Setran' 'ploole Zesu ma. 'Bhɛɛ‑ 'ke ‑mlɛkɛ' mu nule‑ 'yee‑ Zesu ‑din, 'bhɛɛ‑ 'ke ‑wa gbale‑ ‑a maza ‑yaa pɛ 'la ma 'bhɛ ba. ");
INSERT INTO moa_vpl VALUES ("MT4_12","070_4_12","MAT","4","12","12","Zesu 'a 'male‑ 'kaa ‑o Mɛɛ Wiiŋfɛ' Mi Zaan ꞊kwan, 'bhɛɛ‑ ‑wa ꞊bwa ‑kaso 'yi, 'kee‑ gole‑ Zude 'klɛɛn 'ɛ 'yi, 'bhɛɛ‑ 'kee‑ nule‑ Nazarɛti ‑wa 'ɛ ta Galile 'trɛ 'ɛ ta. ");
INSERT INTO moa_vpl VALUES ("MT4_13","070_4_13","MAT","4","13","13","'Duŋ‑ yaa bolɛ Nazarɛti, ‑e ‑ja bolɛ Kapɛnɔmu ‑wa 'ɛ ta. 'Bhɛ ‑wa 'ɛ 'bhɛ ‑o Galile ‑draa 'ɛ bhoŋla yrɛ 'ɛ ꞊nɔɔ, Zabulɔn 'pegee Nɛfitali 'klɛɛn mu 'ɛ 'yi. ");
INSERT INTO moa_vpl VALUES ("MT4_14","070_4_14","MAT","4","14","14","'Bhɛ klɛgbɛya 'ɛ 'yi, ‑Waanbhaa' ‑lɛla' janwo mi Ezai 'wojan‑ mu 'ɛ 'lɛswa꞊; 'yee‑ Ezai 'a ꞊pia 'elwale ‑sɔ dɔɔ: ");
INSERT INTO moa_vpl VALUES ("MT4_15","070_4_15","MAT","4","15","15","«'Ka mu Zabulɔn 'klɛɛn 'yi mu, 'ka mu Nɛfitali mu, 'ka mu ‑draa bhoŋla mu, 'bhɛ 'pegee 'ka mu Zrudɛn yue ta mu, 'bhɛɛ‑ 'ka mu Zrudɛn yue ‑zanta' mu 'ɛ, 'bhɛ 'pegee 'ka mu Zuufu kle mu 'la 'ka ‑o Galile 'klɛɛn gbɛ do 'ɛ 'yi bhe! ");
INSERT INTO moa_vpl VALUES ("MT4_16","070_4_16","MAT","4","16","16","'Ka mu 'si mu 'la 'yaa‑ ‑gblo 'yi, 'ka nu 'tɛbhile ‑gbɛnɛ do yelɛ! Mɛɛ 'la zan mu yaale ‑o ga 'klɛɛn a ‑gblo 'ɛ 'yi, 'tɛbhile do nu ‑bhilɛ' ‑o ta!» ");
INSERT INTO moa_vpl VALUES ("MT4_17","070_4_17","MAT","4","17","17","‑A 'san 'bhɛ yi 'ɛ ma, Zesu ‑Waanbhaa' a ‑jan 'ɛ 'wole‑ ‑saan. ‑E ‑yaa pe 'zi mɛɛ mu 'ɛ ni dɔɔ: «‑Ka 'ploo ‑za 'yɔɔ‑ mu klɛle ma, 'bhɛɛ‑ 'ka 'ka zru niina‑ ‑Waanbhaa' ba, ‑amasrɔyi ‑Waanbhaa' a ‑bhleŋgbeya 'yaa‑ bhla 'ɛ ꞊bhwa 'ka ‑din!» ");
INSERT INTO moa_vpl VALUES ("MT4_18","070_4_18","MAT","4","18","18","Zesu 'yaa‑ 'taawo zii' Galile ‑draa 'ɛ bhoŋla bhla 'la ba, 'kee‑ Simɔ 'la ‑o ‑yaa 'bhɛ sii Piɛri 'bhɛ 'pegee 'bhɛ nɛɛnɛ‑ Andre 'yele. ‑O ‑yaa kaadɛ yrɔ bɔ 'zi ‑draa 'ɛ ba, ‑amasrɔyi ‑o ‑yaa 'ke kaadɛ mu 'le. ");
INSERT INTO moa_vpl VALUES ("MT4_19","070_4_19","MAT","4","19","19","Zesu ‑o ‑siila dɔɔ: «‑Ka nu dɔ 'ŋ zi, 'bhɛɛ‑ 'ŋ nu 'ka klɛlɛ mɛɛ ‑bebe 'kun mu 'le 'bhii‑ 'ka kaa ‑bebe mu kun gɔnɛ‑ 'la gbɛɛn‑.» ");
INSERT INTO moa_vpl VALUES ("MT4_20","070_4_20","MAT","4","20","20","'Bhɛ klɛle 'tɛ, 'ke ‑o 'ploole blaale‑ ‑waa' kaadɛ yrɔ mu 'ɛ ma, 'bhɛɛ‑ 'ke ‑o gele‑ dɔlɛ Zesu zi. ");
INSERT INTO moa_vpl VALUES ("MT4_21","070_4_21","MAT","4","21","21","Zesu 'bhɔle‑ ‑a ‑lɛɛ sa 'egbɔɔnle, 'kee‑ nɛɛnɛ‑ ma do plɛ ‑bhɛɛke' 'yele, Zaki 'pegee 'bhɛ nɛɛnɛ‑ Zaan; 'mu 'yaa‑ Zebede gbe plɛ ‑la ‑le. ‑O mɛɛ plɛ 'pegee ‑o dɛ Zebede ‑yaa ‑waa' kaadɛ yrɔ mu 'ɛ magaan 'zi ‑waa' ‑yitakoŋ 'ɛ 'yi. ");
INSERT INTO moa_vpl VALUES ("MT4_22","070_4_22","MAT","4","22","22","Zesu ‑o 'siile‑, 'ke ‑o nule‑ dɔlɛ blaale‑ 'bhɛ zi, 'bhɛɛ‑ 'ke ‑woo dɛ 'tole 'a nɔɔ‑ ye ‑yitakoŋ 'ɛ 'yi. ");
INSERT INTO moa_vpl VALUES ("MT4_23","070_4_23","MAT","4","23","23","Zesu 'yaa‑ ge 'zi Galile 'trɛ ta yrɛkpɛn‑ ꞊nɔɔ; ‑e ‑yaa mɛɛ mu daan 'zi ‑Waanbhaa' a ‑jan 'ɛ 'le Zuufu mu daanfɛ' mu 'ɛ ꞊la, ‑e ‑yaa ‑Waanbhaa' a ‑bhleŋgbeya ma ‑jan 'nrale‑ 'ɛ 'wo zii'; 'bhɛ 'pegee ‑e ‑yaa gadɛ mu 'ɛ 'kpɛn ‑glɔɔn 'pegee ‑sɔŋzan' mu 'ɛ 'kpɛn 'bhee zii'. ");
INSERT INTO moa_vpl VALUES ("MT4_24","070_4_24","MAT","4","24","24","‑A 'tɔbhɔleya 'ɛ 'yaa‑ zɛn 'zi Siri 'klɛɛn 'ɛ 'kpɛn 'yi. 'Bhɛ ya 'ɛ 'yi, ‑o ‑yaa zan gadɛ mu 'ɛ 'kpɛn ‑glɔɔn 'le ‑a ba, 'bhɛ 'pegee ‑yrɛn 'ɛ 'kpɛn ‑glɔɔn ‑yaa mɛɛ 'la zan mu ta: ‑Kwanii' mu oo, ‑sɔɔnsɔɔndɛ mu oo, 'bhɛ 'pegee ‑flugba mu. Zesu ‑o ma ga mu 'ɛ 'kpɛn ‑gwa. ");
INSERT INTO moa_vpl VALUES ("MT4_25","070_4_25","MAT","4","25","25","'Bhɛla‑ ‑yile, ‑zamaa' 'srɛ ‑bebe ‑yaa ‑a zi: Galile 'klɛɛn 'yi mu oo, ‑wa vu 'klale‑ ke ba mu oo, Zeruzalɛmu mu oo, Zude 'klɛɛn 'yi mu oo, 'bhɛ 'pegee Zrudɛn yue ‑zanta' mu 'kpɛn. ");
INSERT INTO moa_vpl VALUES ("MT5_1","070_5_1","MAT","5","1","1","Zesu ‑zamaa' 'srɛ 'ɛ 'yele‑, 'kee‑ gele‑ yaalɛ vlɛ gɔɔn do 'wiiŋ‑. 'Bhɛɛ‑ ‑yaa' ‑klaŋlanɛ mu 'ɛ ‑woo mabɛɛnna ‑a ‑din, ");
INSERT INTO moa_vpl VALUES ("MT5_2","070_5_2","MAT","5","2","2","'bhɛɛ‑ ‑yoo daanle ‑saan ‑za ‑bebe mu 'lɛɛ‑ 'le. ");
INSERT INTO moa_vpl VALUES ("MT5_3","070_5_3","MAT","5","3","3","Zesu pe ‑o ni dɔɔ: «Mɛɛ 'la zan mu 'gbu 'a 'yaango‑ 'bhii‑ waa ‑o 'ke ‑zake' 'le ‑Waanbhaa' ‑yrɛ 'yi, ‑waa' pɛ ‑yinra'! ‑Amasrɔyi ‑waa' pɛ ‑le 'ke laanima ‑Waanbhaa' ‑bhleŋgbeya ‑wa 'ɛ 'le. ");
INSERT INTO moa_vpl VALUES ("MT5_4","070_5_4","MAT","5","4","4","Mɛɛ 'la zan mu ‑o wisi' zii', ‑waa' pɛ ‑yinra'! ‑Amasrɔyi ‑Waanbhaa' nu ‑o tagalɛ. ");
INSERT INTO moa_vpl VALUES ("MT5_5","070_5_5","MAT","5","5","5","Mɛɛ 'la zan mu ‑yi ‑o 'edɔɔle, ‑waa' pɛ ‑yinra'! ‑Amasrɔyi ‑Waanbhaa' nu 'trɛ 'ɛ 'nalɛ‑ ‑o ni ‑o 'ciɛn 'le. ");
INSERT INTO moa_vpl VALUES ("MT5_6","070_5_6","MAT","5","6","6","‑A ‑lrɔ ‑o mɛɛ la zan mu ma 'bhii‑ ‑lɛdɔɔleya klɛ bhaaplɛŋ mu pleŋ‑, ‑waa' pɛ ‑yinra'! ‑Amasrɔyi pɛ 'la 'lrɔ ‑o ma, ‑Waanbhaa' nu 'bhɛ 'nalɛ‑ ‑o ni. ");
INSERT INTO moa_vpl VALUES ("MT5_7","070_5_7","MAT","5","7","7","Mɛɛ ‑yrɛnkla' mɛɛ 'la zan mu ma, ‑waa' pɛ ‑yinra'! ‑Amasrɔyi ‑o ‑yrɛn nu 'klalɛ‑ ‑Waanbhaa' ma! ");
INSERT INTO moa_vpl VALUES ("MT5_8","070_5_8","MAT","5","8","8","Mɛɛ 'la zan mu 'kpee 'fleele‑ ‑o, ‑waa' pɛ ‑yinra'! ‑Amasrɔyi ‑o nu ‑Waanbhaa' yelɛ! ");
INSERT INTO moa_vpl VALUES ("MT5_9","070_5_9","MAT","5","9","9","Mɛɛ 'la zan mu yilabla wla ‑o 'pegee ‑o yaayɔɔn' mu pleŋ‑, ‑waa' pɛ ‑yinra'! ‑Amasrɔyi ‑Waanbhaa' nu ‑o 'siilɛ‑ ‑a gbe mu! ");
INSERT INTO moa_vpl VALUES ("MT5_10","070_5_10","MAT","5","10","10","‑O ‑yrɛnkpa' zii' mɛɛ 'la zan mu ta ‑Waanbhaa' a ‑lɛdɔɔleya 'ɛ ‑zayi', ‑waa' pɛ ‑yinra'! ‑Amasrɔyi ‑waa' pɛ ‑le nu klɛlɛ laanima ‑Waanbhaa' a ‑bhleŋgbeya ‑wa 'ɛ 'le! ");
INSERT INTO moa_vpl VALUES ("MT5_11","070_5_11","MAT","5","11","11","«'Ke mɛɛ mu 'ka ‑zwanwoa oo, 'ke ‑o ‑yrɛn 'ɛ 'kpɛn ‑glɔɔn ꞊kpaa 'ka ta oo; 'bhɛ 'pegee 'ke ‑o bhla 'ɛ 'kpɛn ‑glɔɔn ꞊kpaa 'ka ma, 'mi ‑zayi', 'kaa‑ pɛ ‑yinra'! ");
INSERT INTO moa_vpl VALUES ("MT5_12","070_5_12","MAT","5","12","12","'Ka zrukpaale klɛ, 'bhɛɛ‑ 'ka 'yilabla 'wole‑ klɛ; ‑amasrɔyi 'bhɛ ‑trɔn ‑gbɛnɛ do ‑o 'ka 'magbɛn‑ 'zi ‑Waanbhaa' ba laanima. ‑O ‑yrɛnkpaa ‑Waanbhaa' ‑lɛla' janwo mu 'la ꞊nwa 'ka 'lɛɛ 'mu ta 'bhɛɛ‑ gbɛɛn‑.» ");
INSERT INTO moa_vpl VALUES ("MT5_13","070_5_13","MAT","5","13","13","«'Ka mu ‑le 'drunyan 'ɛ 'yi wɛ 'le. 'Ke wɛ 'ɛ 'nranleya 'ɛ ‑gwa ‑a ‑yi, 'ka sɔ ‑a ‑nraleya 'ɛ drɛɛkpale 'a ma 'nale‑ ɛɛ? Yaa klɛ ‑za 'ke 'yanwopɛ 'le ‑li mɛɛ ma, 'fɔke ‑e bo blinle ‑la ma 'pɛɛlii‑, 'bhɛɛ‑ mɛɛ mu 'taawo‑ ‑a ta. ");
INSERT INTO moa_vpl VALUES ("MT5_14","070_5_14","MAT","5","14","14","'Ka mu ‑le 'ke 'drunyan 'ɛ ta 'tɛbhile 'le. 'Ke ‑wa do dɔle‑ ‑o vlɛ gɔɔn do 'wiiŋ‑ waa sɔ ‑a gaanle‑ mɛɛ mu ma. ");
INSERT INTO moa_vpl VALUES ("MT5_15","070_5_15","MAT","5","15","15","'Bhɛɛ‑ waa ‑laŋbha do bhi 'bhɛɛ‑ ‑wa dulaa' 'gboŋgbo do ‑la. ‑O ‑laŋbha 'bhile‑ 'ɛ duŋ laanima, 'kooko‑ ‑e bhi 'fɛ 'ɛ ꞊la mu 'ɛ 'kpɛn ta 'weŋ. ");
INSERT INTO moa_vpl VALUES ("MT5_16","070_5_16","MAT","5","16","16","'Bhɛ ya 'ɛ 'yi, ‑ka ‑bhi 'bhii‑ 'tɛbhile gbɛɛn‑ mɛɛ mu ‑yrɛ ma. 'Ke 'bhɛ ꞊kla, 'ke ‑o 'ka klɛza ‑lrele' mu 'ɛ ꞊ya, ‑o nu 'ka Dɛ laanima ‑Waanbhaa' 'ɛ 'tɔbhɔlɛ.» ");
INSERT INTO moa_vpl VALUES ("MT5_17","070_5_17","MAT","5","17","17","Zesu pe ‑o ni 'ezin‑ dɔɔ: «Yaa klɛlɛ 'ka 'ni 'bhii‑ 'mi ꞊nwa Moizi a 'Toŋ 'ɛ 'pegee ‑Waanbhaa' ‑lɛla' janwo mu 'ɛ ‑waa' mɛɛ daangbɛya mu 'ɛ 'yisiɛlɛ! 'Naa 'nulɛ‑ ‑o ‑yisiɛyrɛ ꞊nɔɔ, 'duŋ‑ 'ŋ ꞊nwa ‑o ‑lɛsɔyrɛ ‑la ꞊nɔɔ. ");
INSERT INTO moa_vpl VALUES ("MT5_18","070_5_18","MAT","5","18","18","'Mi pe 'ka ni wlan 'ɛ ni dɔɔ 'ali‑ 'ke 'trɛ 'pegee laflɛ' ꞊kaan, 'kee‑ kpa 'yee‑ 'toŋ 'ɛ 'sɛwɛ 'ɛ yɔɔnnɛ‑ 'fiɛntrɔnnɛ do ta, ‑a do 'kpɔ 'laa nu golɛ ‑a ba, 'sani‑ ‑za mu 'ɛ 'kpɛn 'lɛsɔle pleŋ‑. ");
INSERT INTO moa_vpl VALUES ("MT5_19","070_5_19","MAT","5","19","19","'Bhɛla‑ ‑yile, 'ke mɛɛ 'la zan 'toŋ mu 'ɛ 'yisiɛla, 'ali‑ 'kee‑ ꞊kla ‑o ba 'toŋ 'fiɛntrɔnnɛ 'gbu 'ɛ 'bhɛɛ‑ 'le; 'bhɛɛ‑ 'ke ‑ya ‑pia mɛɛ ‑bhɛɛke' mu ni 'kaa 'mu 'toŋ 'ɛ 'yisiɛ‑ 'bhii‑ 'yee‑ 'gbu gbɛɛn‑; ‑o nu a pelɛ 'bhɛɛ‑ zan 'ɛ ma mɛɛ 'fiɛntrɔnnɛ laanima ‑Waanbhaa' ‑bhleŋgbeya ‑wa 'ɛ ta. 'Duŋ‑ 'ke mɛɛ 'la zan 'Toŋ 'ɛ 'klɔsikun, 'bhɛɛ‑ 'kee‑ mɛɛ ‑vin mu 'ɛ daan 'yee‑ 'Toŋ 'ɛ 'le, ‑o nu a pelɛ 'bhɛɛ‑ zan 'ɛ ma mɛɛ gblaan laanima ‑Waanbhaa' ‑bhleŋgbeya ‑wa 'ɛ ta. ");
INSERT INTO moa_vpl VALUES ("MT5_20","070_5_20","MAT","5","20","20","'Bhɛ 'yi, 'mi pe 'ka ni dɔɔ 'ke 'kaa‑ ‑lɛdɔɔleya 'ɛ 'yi laa yalɛ 'Toŋ daan mu 'pegee Farizi mu 'ɛ ‑waa' pɛ ‑lɛdɔɔleya 'ɛ ni, 'ka 'laa nu 'sɔlɛ‑ gele‑ laanima ‑Waanbhaa' ‑bhleŋgbeya ‑wa 'ɛ ta.» ");
INSERT INTO moa_vpl VALUES ("MT5_21","070_5_21","MAT","5","21","21","«'Kaa ꞊maa dɔɔ ‑a pele ‑o Moizi a 'toŋ mu 'ɛ 'yi ‑kɔɔ' ‑gbɔɔ mu ni dɔɔ: ‹Yaa mɛɛ dɛlɛ;› 'ke mɛɛ 'la zan mɛɛ ꞊dia, 'kiti ‑o 'bhɛ zan ma. ");
INSERT INTO moa_vpl VALUES ("MT5_22","070_5_22","MAT","5","22","22","'Mi 'duŋ‑ pe 'ka ni dɔɔ: 'Ke mɛɛ 'la zan 'e zrupliila ‑a nɛɛnɛ‑ do ma, 'bhɛ zan ‑o 'ke gepɛ 'le ‑klu ta. 'Ke mɛɛ 'la zan 'a nɛɛnɛ‑ do ‑zwanwoa dɔɔ: ‹‑Zadɔkle,› 'bhɛ zan ‑o 'ke gepɛ 'le Zuufu mu a 'kitikan mɛɛ gblaan ‑lɛdo' 'ɛ ba. 'Bhɛɛ‑ 'ke mɛɛ 'la zan 'a ꞊pia 'bhɛ nɛɛnɛ‑ do ni 'ezin‑ dɔɔ: ‹‑Kwanii'›, 'bhɛ zan ‑o 'ke blinpɛ 'le ‑jranama 'tɛ 'ɛ 'yi. ");
INSERT INTO moa_vpl VALUES ("MT5_23","070_5_23","MAT","5","23","23","'Kee ꞊nwa ‑Waanbhaa' gbalɛ 'sraka gopɛ 'la 'le, 'bhɛɛ‑ 'kee dulale ‑o bhla 'la ba 'srakagoyrɛ 'ɛ ‑din, 'bhɛɛ‑ 'kee‑ ‑dwa 'e 'kpee dɔɔ ‑za do ‑o 'bhi 'pegee 'e nɛɛnɛ‑ do pleŋ‑, ");
INSERT INTO moa_vpl VALUES ("MT5_24","070_5_24","MAT","5","24","24","'ploo‑ 'yaa‑ 'sraka gopɛ 'ɛ ma 'srakagoyrɛ 'ɛ ‑din, 'bhɛɛ‑ ge 'e nɛɛnɛ‑ 'ɛ ba 'elwale 'pe, 'kooko‑ 'ka kpa do ma; 'bhɛ blaan, nu ‑Waanbhaa' gba 'e ꞊nwa ‑a gbalɛ 'sraka gopɛ 'la 'le 'bhɛ 'le. ");
INSERT INTO moa_vpl VALUES ("MT5_25","070_5_25","MAT","5","25","25","«'Ke mɛɛ do a ca ‑o 'e ma, 'bhɛɛ‑ 'ke ‑yoo ge 'zi 'e 'le ‑klu ta 'bhɛ ma, 'bhi 'pegee 'yee‑ mɛɛ 'ɛ ‑ka 'kpa do ma zi 'ɛ 'lii, 'sani‑ 'ka 'wlale‑ pleŋ‑ ‑klu 'ɛ ta. 'Ke 'yaa 'bhɛ klɛlɛ, 'kee‑ ‑ja 'e 'kpalɛ‑ 'kitikan mi 'ɛ 'kɔɔ; 'bhɛ nu 'e 'lɛnalɛ ‑kasofɛ gooba mu 'ɛ ni, 'bhɛɛ‑ 'mu 'e bɔ ‑kaso 'yi. ");
INSERT INTO moa_vpl VALUES ("MT5_26","070_5_26","MAT","5","26","26","'Ke 'bhɛ ꞊kla, 'mi pe 'e ni wlan 'ɛ ni dɔɔ: 'Sani‑ 'e 'pwɛle‑ pleŋ‑ 'bhɛ ‑kaso 'ɛ 'yi; ‑yaa' ca 'la ‑yoo 'e ma 'e nu 'bhɛ ‑gɔli' 'ɛ 'kpɛn gbawolɛ 'ke 'bhɛ ge 'tɛnlɛ‑ ‑a ‑vin ‑gɔli' bhɛ do 'kpɔ 'ɛ ma.» ");
INSERT INTO moa_vpl VALUES ("MT5_27","070_5_27","MAT","5","27","27","«'Kaa ꞊maa dɔɔ ‑a pele ‑o Moizi a 'toŋ mu 'ɛ 'yi 'kaa: ‹'Yaa ‑yanbhɔɔya klɛlɛ.› ");
INSERT INTO moa_vpl VALUES ("MT5_28","070_5_28","MAT","5","28","28","'Duŋ‑ 'mi pe 'ka ni dɔɔ: 'Ke mɛɛ 'oo mɛɛ 'la zan le do ‑glinna, 'bhɛɛ‑ 'ke ‑a ‑yrɛbhwa 'bhɛ 'zi, ‑e ‑yanbhɔɔya ‑la ꞊kla gban 'bhɛ gbɛɛn‑ bhe ‑Waanbhaa' ‑yrɛ 'yi. ");
INSERT INTO moa_vpl VALUES ("MT5_29","070_5_29","MAT","5","29","29","'Kee‑ gbɛ ‑yiɛ' ta ‑yrɛbhɛ' ‑le ‑a wla 'zi 'e zi 'bhɛɛ‑ 'e baa‑ 'zi ‑za 'yɔɔ‑ 'yi, ‑a ‑yro, 'bhɛɛ‑ 'ya blin 'e ma 'egbɔɔnle. 'Kee‑ ‑ja ‑Waanbhaa' ba 'e 'yrɛbhɛ‑ gbɛ do 'le, 'bhɛ mabhaabhɔ 'ke ‑woo 'e 'gbutru 'ɛ 'kpɛn blin ‑jranama 'tɛ 'ɛ 'yi. ");
INSERT INTO moa_vpl VALUES ("MT5_30","070_5_30","MAT","5","30","30","'Kee gbɛ ‑yiɛ' ‑le ‑a wla 'zi 'e zi 'bhɛɛ‑ 'e baa‑ 'zi ‑za 'yɔɔ‑ 'yi, ‑a takan' 'bhɛɛ‑ 'ya blin 'e ma 'egbɔɔnle. 'Kee dɔpɛ do winbwa‑ ‑a ‑yi 'bhɛ mabhaabhɔ, 'ke ‑woo 'e 'gbutru 'ɛ 'kpɛn blin ‑jranama 'tɛ 'ɛ 'yi.» ");
INSERT INTO moa_vpl VALUES ("MT5_31","070_5_31","MAT","5","31","31","«‑A pele ‑o 'ezin‑ 'yee‑ Moizi a 'toŋ mu 'ɛ 'yi dɔɔ: ‹'Ke mɛɛ 'la zan ‑o ‑a zi 'bhii‑ ‑e 'ploo‑ ‑a na ma, ‑e gwlɛnna yaa‑ 'kan 'sɛwɛdɛ, 'bhɛɛ‑ ‑e 'bhɛ na ‑a na 'ɛ ni.› ");
INSERT INTO moa_vpl VALUES ("MT5_32","070_5_32","MAT","5","32","32","'Duŋ‑ mi pe 'ka ni dɔɔ: 'Ke mɛɛ 'la zan na 'laa gwlɛn ‑glinlɛ', 'bhɛɛ‑ 'kee‑ ‑ploola 'bhɛ ma, ‑yoo 'bhɛ bɔ 'zi gwlɛn ‑glin zi ‑la ta bhe. 'Duŋ‑ 'ke ‑o ‑ploola le 'la ma, 'bhɛɛ‑ 'ke 'bhi 'gwlaan‑ 'la 'bhɛ ꞊sia 'e 'na 'le, 'yoo‑ ‑yanbhɔɔya ‑la klɛ 'zi 'bhɛ gbɛɛn‑ bhe.» ");
INSERT INTO moa_vpl VALUES ("MT5_33","070_5_33","MAT","5","33","33","Zesu pe ‑o ni 'ezin‑ dɔɔ: «'Kaa ꞊maa dɔɔ ‑wa ꞊pia ‑kɔɔ' ‑gbɔɔ mu 'ɛ ni dɔɔ: ‹'Ke 'yee 'siɛnwoa‑ pɛ 'la ma 'yaa 'bhɛ 'siɛnwoza 'ɛ 'tolɛ‑ ye, 'duŋ‑ 'yee 'siɛnwoa‑ pɛ 'la ma ‑Waanbhaa' ‑yrɛ ma, 'bhɛ 'lɛsɔ.› ");
INSERT INTO moa_vpl VALUES ("MT5_34","070_5_34","MAT","5","34","34","'Duŋ‑ mi pe 'ka ni dɔɔ: 'Ka 'laa 'ka 'siɛnwolɛ pɛ 'kedo‑ 'kpɔ ma: 'Ka 'laa 'ka 'siɛnwolɛ laflɛ' ma, ‑amasrɔyi ‑Waanbhaa' a ‑bhleŋgbeya yaayrɛ ‑le 'ke laflɛ' 'ɛ 'bhɛɛ‑ 'le; ");
INSERT INTO moa_vpl VALUES ("MT5_35","070_5_35","MAT","5","35","35","'ka 'laa 'ka 'siɛnwolɛ 'trɛ ma, ‑amasrɔyi ‑Waanbhaa' gaankpapɛ ‑le 'ke 'trɛ 'ɛ 'bhɛɛ‑ 'le; 'ka 'laa 'ka 'siɛnwolɛ Zeruzalɛmu ma, ‑amasrɔyi ‑bhleŋgbe ‑gbɛnɛ 'ɛ 'yela‑ a ‑wa ‑le 'kɛle‑. ");
INSERT INTO moa_vpl VALUES ("MT5_36","070_5_36","MAT","5","36","36","'Yaa 'e 'siɛnwolɛ 'e ŋgblo 'ɛ ma, ‑amasrɔyi 'yaa sɔ 'e winbhɛ mu 'ɛ do 'kpɔ klɛle‑ 'epu 'pegee 'etile. ");
INSERT INTO moa_vpl VALUES ("MT5_37","070_5_37","MAT","5","37","37","'Kaa ‹‑Aani'› bo 'kaa‑ ‹‑Aani'› 'le, 'bhɛɛ‑ 'kaa‑ ‹'Yooye‑› bo 'kaa‑ ‹'Yooye‑› 'le. 'Ke 'ka pɛ 'la ꞊kpaa 'bhɛ ‑jan 'ɛ ma, 'bhɛ da ‑Setran' ‑la ba.» ");
INSERT INTO moa_vpl VALUES ("MT5_38","070_5_38","MAT","5","38","38","Zesu pe ‑o ni 'ezin‑ dɔɔ: «'Kaa ꞊maa dɔɔ ‑wa ꞊pia dɔɔ: ‹'Ke mɛɛ do 'e 'yrɛbhɛ‑ do ꞊pwan, ‑o nu 'bhɛ zan 'ɛ 'yrɛbhɛ‑ do 'pɔnlɛ‑ 'ezin‑; 'bhɛɛ‑ 'ke mɛɛ do 'e 'sɔnbhɛ‑ do 'ciɛnna‑, ‑o nu 'bhɛ zan 'ɛ 'sɔnbhɛ‑ do 'ciɛnlɛ‑ 'ezin‑.› ");
INSERT INTO moa_vpl VALUES ("MT5_39","070_5_39","MAT","5","39","39","'Duŋ‑ 'mi pe 'ka ni dɔɔ: 'Ka 'laa ‑za 'yɔɔ‑ ‑zigolɛ ‑za 'yɔɔ‑ 'le 'eke‑ ma. 'Ke mɛɛ do 'e ꞊zwan 'e gbɛ ‑yiɛ' ta 'trɔn 'ɛ ta, 'e gbɛ ‑koo ta 'trɔn 'ɛ 'bhɛ dɔ ‑a ni 'bhɛɛ‑ ‑e 'bhɛ zɔn. ");
INSERT INTO moa_vpl VALUES ("MT5_40","070_5_40","MAT","5","40","40","'Ke mɛɛ do ‑a zi 'bhii‑ ‑e ge 'e 'le ‑klu ta 'e ta dunɛ‑ 'ɛ 'si zayi', ‑a 'to 'bhɛɛ‑ ‑e 'yaa‑ dunɛ‑ tralapɛ 'ɛ si 'ezin‑. ");
INSERT INTO moa_vpl VALUES ("MT5_41","070_5_41","MAT","5","41","41","'Ke mɛɛ do 'a ꞊pia 'e ni 'kaa ‑e ‑yaa' 'kwe do 'si kpaŋma, 'bhɛɛ‑ 'e 'taawo‑ 'kɛle‑ 'kilo do ta, ‑yaa' 'kwe 'ɛ 'si, 'bhɛɛ‑ 'e 'kilo plɛ ta 'taawo‑ 'kɛle‑. ");
INSERT INTO moa_vpl VALUES ("MT5_42","070_5_42","MAT","5","42","42","'Ke mɛɛ pɛ do ‑yrɛwoa 'e ma, 'bhɛ pɛ 'ɛ 'na 'bhɛ zan 'ɛ ni; 'bhɛɛ‑ 'ke mɛɛ do ‑o ‑a zi 'bhii‑ ‑e pɛ do ca si 'e 'kɔɔ, 'yaa 'bhɛ ‑gbɛdɔlɛ ‑a ma.» ");
INSERT INTO moa_vpl VALUES ("MT5_43","070_5_43","MAT","5","43","43","Zesu pe ‑o ni 'ezin‑ dɔɔ: «'Kaa ꞊maa dɔɔ ‑wa ꞊pia dɔɔ: ‹'E ‑vindo' mi ‑za 'sɔ 'e ni, 'bhɛɛ‑ 'e 'sɔɔnnii 'ɛ 'bhɛ vɛnsi' 'e yin 'lii.› ");
INSERT INTO moa_vpl VALUES ("MT5_44","070_5_44","MAT","5","44","44","'Duŋ‑ 'mi pe 'ka ni dɔɔ: 'Ka 'sɔɔnnii mu 'ɛ ‑za 'sɔ 'ka ni; 'bhɛɛ‑ ‑ka 'ka 'seriwo mɛɛ 'la zan mu ‑yrɛnkpa' 'ka ta 'mu a ‑za ma. ");
INSERT INTO moa_vpl VALUES ("MT5_45","070_5_45","MAT","5","45","45","'Ke 'bhɛ ꞊kla, 'ka nu klɛlɛ 'ka Dɛ 'la ‑yoo laflɛ' 'yi laanima 'bhɛ 'nɛ mu 'le. ‑Amasrɔyi ‑e ‑yaa' ‑yretɛbhɛ 'ɛ bhi mɛɛ ‑yɔɔ' mu 'pegee mɛɛ wlan mu ta gɔnɛ‑ 'la gbɛɛn‑; ‑e la ban mɛɛ ‑lɛdɔɔle mu 'pegee mɛɛ ‑lɛbiile mu ta 'bhɛɛ‑ gbɛɛn‑ 'ezin‑. ");
INSERT INTO moa_vpl VALUES ("MT5_46","070_5_46","MAT","5","46","46","'Ke 'ka ‑za 'sɔ mɛɛ 'la zan mu ni, 'bhɛɛ‑ 'ke 'bhɛ zan mu 'te ‑la ‑za 'sɔ 'ka mu ni. 'Ka nu ‑trɔn 'ɛ ‑dela 'srɔɔwolɛ ‑Waanbhaa' 'kɔɔ 'bhɛ ma ɛɛ? 'Ali‑ 'nisrakun mu 'ɛ 'mu 'a klɛ 'bhɛɛ‑ gbɛɛn‑. ");
INSERT INTO moa_vpl VALUES ("MT5_47","070_5_47","MAT","5","47","47","'Ke 'ka 'ka nɛɛnɛ‑ mu 'te ‑la 'pubɔ‑, 'ka gole ‑o mɛɛ ‑vin mu 'ɛ ‑o ma 'nale‑ ɛɛ? 'Ali‑ mɛɛ 'la zan mu laa ‑Waanbhaa' dɔ, 'mu 'a klɛ 'bhɛɛ‑ gbɛɛn‑. ");
INSERT INTO moa_vpl VALUES ("MT5_48","070_5_48","MAT","5","48","48","'Ka 'lɛsɔle klɛ ‑za 'kpɛn 'yi, 'bhii‑ 'ka Dɛ 'la ‑yoo laanima 'bhɛ 'lɛsɔle ‑o gɔnɛ‑ 'la gbɛɛn‑.» ");
INSERT INTO moa_vpl VALUES ("MT6_1","070_6_1","MAT","6","1","1","«‑Ka 'ka 'yrɛkpa 'ka 'gbu ba 'elrele, 'ke 'ka 'laa 'kaa‑ ‑Waanbhaa' ‑lɛɛgblaanya 'ɛ 'yi 'taawoza 'ɛ klɛ bhaaplɛŋ mu ‑yrɛ ta, 'kooko‑ mɔkpɛn' 'yrɛbhɔ 'ka zi, 'bhɛɛ‑ ‑o 'ka 'tɔbhɔ. 'Ke 'kaa ꞊kla 'bhɛ gbɛɛn‑ bhe, 'ka 'laa nu 'bhɛ ma 'trɔn‑ ‑srɔɔwolɛ 'ka Dɛ ‑Waanbhaa' 'la ‑yoo laanima 'bhɛ 'kɔɔ.» ");
INSERT INTO moa_vpl VALUES ("MT6_2","070_6_2","MAT","6","2","2","«'Ke 'yoo‑ pɛ do 'nale‑ 'kɔɔfleŋzan mu ni, 'yaa woŋwoŋzɛnlɛ 'bhii‑ mɛɛ ‑yrɛkɔɔza klɛ mu a klɛ gɔnɛ‑ 'la gbɛɛn‑ Zuufu mu daanfɛ' mu 'ɛ 'pegee 'pɛɛlii‑ ‑gbleba mu 'ɛ ta. ‑O 'bhɛ klɛ 'bhɛ gbɛɛn‑ bhe, 'kooko‑ mɛɛ mu ‑o 'tɔbhɔ mɔkpɛn' 'yrɛ ma. 'Mi pe 'ka ni wlan 'ɛ ni dɔɔ ‑woo klɛza mu 'ɛ ma ‑trɔn 'srɔɔwoa‑ gban. ");
INSERT INTO moa_vpl VALUES ("MT6_3","070_6_3","MAT","6","3","3","'Duŋ‑ 'bhi, 'ke 'yoo‑ pɛ do 'nale‑ 'kɔɔfleŋzan mu ni, 'e gbɛ ‑yiɛ' ‑o ‑za 'la klɛ 'zi 'e gbɛ ‑koo' ‑za 'laa dɔlɛ 'bhɛ 'yi. ");
INSERT INTO moa_vpl VALUES ("MT6_4","070_6_4","MAT","6","4","4","'Bhɛ klɛgbɛya 'ɛ 'yi, 'e pɛ 'la 'bhɛ 'naa‑ bhe, 'bhɛ tagaanle bo. 'Bhɛɛ‑ 'e Dɛ ‑Waanbhaa' 'la 'yrɛ ‑o 'e ‑za 'la klɛ 'zi gaanyi' 'bhɛ ma, 'bhɛ nu 'bhɛ ‑za 'ɛ ma ‑trɔn 'nalɛ‑ 'e ni.» ");
INSERT INTO moa_vpl VALUES ("MT6_5","070_6_5","MAT","6","5","5","Zesu pe ‑o ni 'ezin‑ dɔɔ: «'Ke 'ka ‑o 'ka 'seriwo zii', 'ka 'laa klɛlɛ 'bhii‑ mɛɛ ‑yrɛkɔɔza klɛ mu 'ɛ gbɛɛn‑: 'Seriwole sɔ ‑o ni ‑o dulalele Zuufu mu daanfɛ' mu 'ɛ ꞊la, 'bhɛ 'pegee ‑gbleba mu 'ɛ 'lɛzi‑, 'kooko‑ mɔkpɛn' 'yrɛkpa‑ ‑o ma, 'bhɛɛ‑ ‑woo 'tɔbhɔ‑. 'Mi pe 'ka ni wlan 'ɛ ni dɔɔ ‑woo klɛza mu 'ɛ ma ‑trɔn 'srɔɔwoa‑ gban. ");
INSERT INTO moa_vpl VALUES ("MT6_6","070_6_6","MAT","6","6","6","'Duŋ‑ 'bhi, 'ke 'yoo‑ 'e 'seriwole, wla 'e yi 'fɛkpee 'ɛ ꞊la, 'bhɛɛ‑ 'fɛ 'ɛ 'liitan 'e ta. 'Bhɛɛ‑ 'e 'seriwo 'e Dɛ ‑Waanbhaa' 'la ‑yoo gaanyi' 'bhɛ ni; 'bhɛɛ‑ 'yee‑ 'la 'e ‑za 'la klɛ 'zi gaanyi' 'bhɛ ye bhe, ‑e nu 'bhɛ ma ‑trɔn 'nalɛ‑ 'e ni.» ");
INSERT INTO moa_vpl VALUES ("MT6_7","070_6_7","MAT","6","7","7","«'Ke 'ka ‑o 'ka 'seriwo zii', 'ka 'laa bɔlɛ ‑jan do 'kpɔ ta 'ebebele 'bhii‑ mɛɛ 'la zan mu laa ‑Waanbhaa' dɔ 'mu 'a klɛ gɔnɛ‑ 'la gbɛɛn‑: ‑O 'kpee ma 'ke ‑o ꞊bwa ‑jan do ta 'ebebele, 'bhɛɛ‑ ‑Waanbhaa' nu ‑waa' 'seri 'ɛ 'lɛkunlɛ. ");
INSERT INTO moa_vpl VALUES ("MT6_8","070_6_8","MAT","6","8","8","'Ka 'laa klɛlɛ 'bhii‑ 'woo‑ mu gbɛɛn‑. ‑Amasrɔyi 'ka maza ‑o pɛ 'la ma, 'ka Dɛ ‑Waanbhaa' 'bhɛ dɔ gban 'elwale 'sani‑ ‑a ‑yrɛwole ‑lɛɛ. ");
INSERT INTO moa_vpl VALUES ("MT6_9","070_6_9","MAT","6","9","9","'Ke 'ka ‑o 'ka 'seriwo zii', ‑kaa pe gɔnɛ‑ 'lɛɛ‑ gbɛɛn‑ dɔɔ: ‹‑O Dɛ ‑Waanbhaa' 'la ‑yoo laanima, bhaa mɔkpɛn' 'e 'tɔ 'weŋ 'ɛ 'bhɔ. ");
INSERT INTO moa_vpl VALUES ("MT6_10","070_6_10","MAT","6","10","10","Bhaa 'yaa‑ ‑bhleŋgbeya 'yaa‑ yi 'ɛ 'bhɔ; bhaa 'trɛ ta mu 'ɛ ‑woo 'e zru maza klɛ 'bhii‑ ‑wa klɛ gɔnɛ‑ 'la gbɛɛn‑ laanima. ");
INSERT INTO moa_vpl VALUES ("MT6_11","070_6_11","MAT","6","11","11","'O gba ‑zɔn 'o 'le pɛle ba. ");
INSERT INTO moa_vpl VALUES ("MT6_12","070_6_12","MAT","6","12","12","'O ‑za 'yɔɔ‑ mu 'la ꞊kla, ‑o ‑sroma 'yan 'bhii‑ mɛɛ 'la zan mu ‑za 'yɔɔ‑ klɛ 'o ni, 'o 'mu a ‑sroma yan gɔnɛ‑ 'la gbɛɛn‑. ");
INSERT INTO moa_vpl VALUES ("MT6_13","070_6_13","MAT","6","13","13","'Yaa 'tolɛ‑ 'ke ‑Setran' 'o 'yidan‑, 'bhɛɛ‑ ‑yoo 'o bɔ ‑za 'yɔɔ‑ 'yi. 'Duŋ‑ 'o go ‑Setran' 'kɔɔ. ‑Amasrɔyi 'bhi ‑le a pɛ ‑le 'ke ‑bhleŋgbeya 'pegee ‑glɔɔya', 'bhɛɛ‑ 'tɔbhɔleya 'le ‑yikpɛnsee ta. Amiina!› ");
INSERT INTO moa_vpl VALUES ("MT6_14","070_6_14","MAT","6","14","14","«Wlan 'ɛ ni, 'ke mɛɛ ‑bhɛɛke' mu ‑za 'yɔɔ‑ ꞊kla 'ka ni, 'bhɛɛ‑ 'ke 'ka ‑waa' ‑sroma 'ɛ ‑yaan, 'ka Dɛ ‑Waanbhaa' 'la ‑yoo laanima 'bhɛ nu 'ka mu a ‑sroma 'yanlɛ‑ 'ezin‑. ");
INSERT INTO moa_vpl VALUES ("MT6_15","070_6_15","MAT","6","15","15","'Duŋ‑ 'ke 'ka 'laa mɛɛ ‑bhɛɛke' mu a ‑sroma 'yanlɛ‑, 'ka Dɛ 'la ‑yoo laanima 'bhɛ laa nu 'ka mu a pɛ ‑sroma 'ɛ 'yanlɛ‑ 'ezin‑.» ");
INSERT INTO moa_vpl VALUES ("MT6_16","070_6_16","MAT","6","16","16","«'Ke 'ka ‑o 'suŋ 'yi, 'ka 'laa 'ka wlɛyisriwolɛ 'bhii‑ mɛɛ ‑yrɛkɔɔza klɛ mu 'ɛ gbɛɛn‑: ‑Woo wlɛyisriwo 'eyɔɔle, 'kooko‑ mɔkpɛn' 'a 'yaango‑ 'bhii‑ ‑woo 'suŋwla zii'. 'Mi pe 'ka ni wlan 'ɛ ni dɔɔ ‑woo klɛza mu 'ɛ ma ‑trɔn ‑srɔɔwoa gban. ");
INSERT INTO moa_vpl VALUES ("MT6_17","070_6_17","MAT","6","17","17","'Bhi 'duŋ‑, 'ke 'yoo‑ 'suŋ 'yi, 'e 'fɛ 'gbu 'elrele, 'bhɛɛ‑ ‑lasiklɔɔ ‑gblɛn 'nrale‑ 'kla 'e 'gbu ta, ");
INSERT INTO moa_vpl VALUES ("MT6_18","070_6_18","MAT","6","18","18","'kooko‑ mɛɛ mu laa nu ‑a 'yaangolɛ 'bhii‑ 'yoo‑ 'suŋ 'yi. 'Duŋ‑ 'e Dɛ ‑Waanbhaa' do ‑kplɛn 'la ‑ya ꞊nɔɔ gaanyi' ye bhe, 'bhɛɛ‑ 'yee‑ Dɛ ‑Waanbhaa' 'la 'kee‑ gaanyiza ye bhe, 'yele‑ nu ‑a ma ‑trɔn 'nalɛ‑ 'e ni.» ");
INSERT INTO moa_vpl VALUES ("MT6_19","070_6_19","MAT","6","19","19","«'Ka 'laa ‑naflo mu zrɛdɔlɛ 'ka 'gbu ni 'trɛ ta ‑gɛ. ‑Amasrɔyi ‑can 'pegee ‑wlɛnnɛ' mu sɔ ‑o 'siɛle, 'bhɛɛ‑ ‑faannii' mu sɔ nule‑ 'kaa 'fɛ 'ɛ 'liikoŋ mu 'ɛ 'siɛlɛ‑ 'bhɛɛ‑ ‑o 'kaa‑ ‑naflo mu 'ɛ faan. ");
INSERT INTO moa_vpl VALUES ("MT6_20","070_6_20","MAT","6","20","20","‑Ka ‑naflo mu 'ɛ zrɛdɔ 'ka 'gbu ni laflɛ' 'yi; ‑wlɛnnɛ' mu 'pegee ‑can mu laa ‑o 'bhɛ ꞊nɔɔ ye bhe 'ke ‑o 'mu siɛ, 'bhɛɛ‑ ‑faannii' mu laa sɔ 'kaa‑ 'fɛ 'liikoŋ mu 'ɛ 'siɛle, 'bhɛɛ‑ ‑o 'kaa‑ ‑naflo mu 'ɛ faan. ");
INSERT INTO moa_vpl VALUES ("MT6_21","070_6_21","MAT","6","21","21","‑Amasrɔyi 'yaa‑ ‑naflo 'ɛ ‑yoo yrɛ 'la ꞊nɔɔ, 'e zru bole ‑o 'bhɛɛ‑ yrɛ ꞊nɔɔ 'ɛ ta.» ");
INSERT INTO moa_vpl VALUES ("MT6_22","070_6_22","MAT","6","22","22","«‑Kɔɔ' 'yrɛbhɛ‑ mu 'ɛ ‑woo ‑kɔɔ' 'flɛ ta 'tɛbhile ‑la ‑le. 'Kee‑ 'yrɛbhɛ‑ mu 'ɛ ‑woo kplankplan, 'e 'flɛ 'ɛ 'kpɛn takanle ‑o 'weŋ. ");
INSERT INTO moa_vpl VALUES ("MT6_23","070_6_23","MAT","6","23","23","'Duŋ‑ 'kee 'yrɛbhɛ‑ mu 'ɛ waa ‑o kplankplan, 'e 'flɛ 'kpɛn ‑o ‑gblo 'yi. 'Kee 'yi 'tɛbhile 'ɛ 'bhɛ ‑o 'ke ‑gblo 'le, 'yoo‑ ‑gblo ti ‑gbɛnɛ ‑la ‑yi.» ");
INSERT INTO moa_vpl VALUES ("MT6_24","070_6_24","MAT","6","24","24","«Mɛɛ do laa sɔ yewole ‑kuŋlii plɛ ni 'eke‑ zi. 'Kee‑ 'bhɛ ꞊kla, ‑a do vɛn nu 'silɛ‑ ‑a yin 'lii, 'bhɛɛ‑ ‑a ‑bhɛɛke' do 'ɛ ‑za sɔ a ni. 'Ke ‑a lii biile ‑o ‑a do 'yi, ‑e nu ‑a ‑bhɛɛke' do 'ɛ mavɛɛlɛ. 'Bhɛ ya 'ɛ 'yi, 'ka 'laa sɔ klɛle‑ ‑Waanbhaa' a lu 'le, 'bhɛɛ‑ 'ka klɛ ‑gɔli' a lu 'le 'ezin‑.» ");
INSERT INTO moa_vpl VALUES ("MT6_25","070_6_25","MAT","6","25","25","«'Bhɛla‑ ‑zayile, 'mi pe 'ka ni dɔɔ 'ka 'laa 'ka 'si 'ɛ yiɛnkanlɛ: 'kee‑ ꞊kla 'ka 'le pɛle 'le oo, 'kee‑ ‑kla 'ka 'mi yi 'le oo, 'bhɛ 'pegee 'ka nu pɛ mu 'la 'klalɛ‑ 'ka ta, 'ka 'laa 'mu do 'kpɔ ‑za yiɛnkanlɛ. 'Bhɛ 'yi, ‑kɔɔ' ‑si 'ɛ 'bhɛ mabhaa laa bhɔ pɛbhle ta ɛɛ? 'Bhɛɛ‑ ‑kɔɔ' 'flɛ 'ɛ mabhaa laa bhɔ ‑kɔɔ' tapɛ mu ta ɛɛ? ");
INSERT INTO moa_vpl VALUES ("MT6_26","070_6_26","MAT","6","26","26","‑Ka laanima maannɛ‑ mu 'ɛ ‑glin doo. Waa pɛbhɛ bɔ, 'bhɛɛ‑ waa pɛ bhaa kan; 'bhɛ 'pegee waa pɛle zrɛdɔ, 'duŋ‑ 'ka Dɛ 'la ‑yoo laanima 'bhɛ ‑o ‑lɛbɔ'. 'Ka mu mabhaa 'laa bhɔ maannɛ‑ mu ta ɛɛ? ");
INSERT INTO moa_vpl VALUES ("MT6_27","070_6_27","MAT","6","27","27","'Ka ‑de 'gbu ‑le sɔ ‑a ‑si 'ɛ baan' sa 'klale 'a ba, ‑a 'kpee yiɛnkanle 'ɛ ma ɛɛ?» ");
INSERT INTO moa_vpl VALUES ("MT6_28","070_6_28","MAT","6","28","28","«‑Mɛla ma, 'bhɛɛ‑ 'ka ‑o dunɛ‑ mu yiɛnkan' zii' ɛɛ? ‑Ka 'ka 'yrɛkpa ‑bɔn ‑bi mu 'ɛ 'pwɛgbɛya 'ɛ ta doo: Waa sɔ yewole, 'bhɛɛ‑ waa sɔ dunɛ‑ mu 'tanle. ");
INSERT INTO moa_vpl VALUES ("MT6_29","070_6_29","MAT","6","29","29","'Bhɛɛ‑ 'duŋ‑, 'mi pe 'ka ni dɔɔ: 'Ali‑ ‑bhleŋgbe Salomɔ ‑yaa yaa 'tɔbhɔleya 'ɛ 'kpɛn 'yi, ‑a ‑baale' ‑lreleya laa 'kanlɛ‑ 'woo‑ ‑bɔn ‑bi mu 'ɛ ‑o ta. ");
INSERT INTO moa_vpl VALUES ("MT6_30","070_6_30","MAT","6","30","30","‑Bɔn mu 'la ‑woo ‑zɔn gba la, 'bhɛɛ‑ ‑o nu ‑o ‑yrolɛ' too, 'bhɛɛ‑ ‑woo blin 'tɛ 'yi, 'ke ‑Waanbhaa' ‑o baa 'elrele; yaa nu 'ka mu ‑baalɛ' 'elrele 'ke 'bhɛ kan ‑waa' pɛ ‑baagbɛya 'ɛ ta ɛɛ? 'Kaa‑ 'kpaleya 'ɛ ‑a ‑yi 'bhɛ ‑o 'fiɛntrɔnnɛ 'dɛ! ");
INSERT INTO moa_vpl VALUES ("MT6_31","070_6_31","MAT","6","31","31","'Bhɛ ya 'ɛ 'yi, 'ka 'laa ‑za 'kedo‑ 'kpɔ yiɛnkanlɛ, 'bhɛɛ‑ 'ka 'laa 'pelɛ‑ dɔɔ: ‹'O nu ‑mɛla bhlelɛ, 'bhɛɛ‑ 'o nu ‑mɛla milɛ ɛɛ? 'Bhɛ 'pegee 'o nu ‑mɛ pɛ ‑la 'klalɛ‑ 'o ta ɛɛ?› ");
INSERT INTO moa_vpl VALUES ("MT6_32","070_6_32","MAT","6","32","32","Mɛɛ 'la zan mu laa ‑Waanbhaa' dɔ, 'mu ‑le 'woo‑ ‑za mu 'la bhe 'mu ziglin. 'Ka Dɛ 'la ‑yoo laanima ‑a 'gbu 'a 'yaango‑ 'bhii‑ 'ka maza ‑o 'woo‑ pɛ mu 'ɛ ma. ");
INSERT INTO moa_vpl VALUES ("MT6_33","070_6_33","MAT","6","33","33","‑Ka ‑Waanbhaa' a ‑bhleŋgbeya 'ɛ 'pegee 'ka 'lɛdɔɔleya ‑a ‑yrɛ 'yi 'mu ‑la yiɛnkan' 'elwale 'pe. 'Ke 'ka 'bhɛ ꞊kla, 'bhɛɛ‑ ‑e nu 'ka gbalɛ 'bhɛ pɛ mu 'ɛ 'kpɛn ba. ");
INSERT INTO moa_vpl VALUES ("MT6_34","070_6_34","MAT","6","34","34","'Ka 'laa too ‑za yiɛnkanlɛ ‑zɔn. ‑Amasrɔyi 'ka nu 'ŋgami 'bhɛɛke 'srɔɔwolɛ too. 'Bhɛ 'yi, yi 'ɛ 'kpɛn 'pegee 'bhɛ 'yi za ‑le.» ");
INSERT INTO moa_vpl VALUES ("MT7_1","070_7_1","MAT","7","1","1","«'Ka 'laa mɛɛ ‑bhɛɛke' mu 'tɔ 'yɔɔ‑ pelɛ, 'kooko‑ waa nu 'ka mu 'tɔ 'yɔɔ‑ pelɛ 'ezin‑. ");
INSERT INTO moa_vpl VALUES ("MT7_2","070_7_2","MAT","7","2","2","'Ka mɛɛ ‑bhɛɛke' 'tɔ 'yɔɔ‑ pe gɔnɛ‑ 'la gbɛɛn‑, ‑o nu 'ka mu 'tɔ 'yɔɔ‑ pelɛ 'bhɛɛ‑ gbɛɛn‑. 'Ka mɛɛ mu kun gɔnɛ‑ 'la gbɛɛn‑, ‑o nu 'ka mu 'kunlɛ‑ 'bhɛɛ‑ gbɛɛn‑. ");
INSERT INTO moa_vpl VALUES ("MT7_3","070_7_3","MAT","7","3","3","‑Yrikpu' 'la 'bhɛ ‑o 'e 'gbu 'yrɛ 'ɛ ba 'yaa 'bhɛ ye, 'fɔ ‑gaa 'klenɛ 'la 'bhɛ ‑o 'e nɛɛnɛ‑ 'ɛ 'yrɛ 'ɛ ba 'e 'bhɛɛ‑ ye ɛɛ? ");
INSERT INTO moa_vpl VALUES ("MT7_4","070_7_4","MAT","7","4","4","'E sɔ a pele‑ 'nale‑ ‑a ma 'e nɛɛnɛ‑ 'ɛ ni dɔɔ: ‹‑A 'to 'mi 'e 'yrɛ ba ‑gaa 'klenɛ 'ɛ go›. 'Duŋ‑ 'ke ‑yrikpu' do ‑o 'bhi 'gbu 'yrɛ 'ɛ ba ɛɛ? ");
INSERT INTO moa_vpl VALUES ("MT7_5","070_7_5","MAT","7","5","5","Mɛɛ ‑yrɛkɔɔza klɛ mi, 'e 'gbu 'yrɛ ba ‑yrikpu' 'ɛ go 'elwale 'pe, 'bhɛɛ‑ 'kee yrɛ ma ꞊ya, 'e sɔ 'e nɛɛnɛ‑ 'ɛ 'yrɛ ba ‑gaa 'klenɛ 'ɛ gole‑ 'tɛ.» ");
INSERT INTO moa_vpl VALUES ("MT7_6","070_7_6","MAT","7","6","6","«'Ka 'laa ‑Waanbhaa' a pɛ 'weŋ mu 'ɛ gbɛkpalɛ mɛɛ zru ‑yɔɔ' mu 'kɔɔ, 'kebhlaale, ‑e klɛ 'bhii‑ 'ke 'ka wi ‑lrele' ‑naa ‑gbaan' mu ni, 'bhɛɛ‑ boolazi ‑o yran 'ka 'gbu ma. 'Bhɛ 'yi, pɛ mu 'la 'gbu ‑za mu ‑o 'ka 'kɔɔ 'eglɔɔle 'ka 'laa 'mu blinlɛ ꞊swa mu ni, 'kooko‑ waa nu 'taawolɛ ‑o ta 'trɛ ma.» ");
INSERT INTO moa_vpl VALUES ("MT7_7","070_7_7","MAT","7","7","7","«‑Ka pɛ ‑yrɛwo' ‑Waanbhaa' ma, 'bhɛɛ‑ e nu 'bhɛ 'nalɛ‑ 'ka ni; 'ke 'ka pɛ 'la ziglinna ‑a ba, 'ka nu 'bhɛ 'srɔɔwolɛ. ‑Ka kɔkɔdɛ ‑a ta, 'bhɛɛ‑ ‑e nu ‑yaa' 'fɛ 'ɛ 'liigolɛ 'ka ni. ");
INSERT INTO moa_vpl VALUES ("MT7_8","070_7_8","MAT","7","8","8","‑Amasrɔyi 'ke mɛɛ 'oo mɛɛ 'la zan pɛ ‑yrɛwoa ‑a ma, 'bhɛ zan nu 'bhɛ pɛ 'ɛ 'srɔɔwolɛ ‑a 'kɔɔ. 'Ke mɛɛ 'la zan pɛ 'la ziglinna ‑a ba, 'bhɛ zan nu 'bhɛ 'srɔɔwolɛ; 'bhɛɛ‑ 'ke 'bhi 'la kɔkɔdia ‑yaa' 'fɛ 'liikoŋ 'ɛ ta, ‑e nu 'bhɛ ‑liigolɛ 'e ni. ");
INSERT INTO moa_vpl VALUES ("MT7_9","070_7_9","MAT","7","9","9","'Ka ba mɛɛ 'gbu 'ɛ ‑de 'gbu ‑le sɔ kpoti 'nale‑ ‑a 'gbu 'nɛ 'ɛ ni 'ke 'bhɛ 'bluu 'yrɛwoa‑ ‑a ma ɛɛ? ");
INSERT INTO moa_vpl VALUES ("MT7_10","070_7_10","MAT","7","10","10","'Bhɛɛ‑ 'ezin‑, ‑de 'gbu ‑le sɔ mlɛ do 'kpale 'bhɛ 'gbu 'nɛ 'ɛ 'kɔɔ 'ke 'bhɛ kaa do ‑yrɛwoa ‑a ma ɛɛ? ");
INSERT INTO moa_vpl VALUES ("MT7_11","070_7_11","MAT","7","11","11","'Ka mɛɛ ‑yɔɔ mu, 'ke 'ka mu sɔ pɛ wlan mu 'nale‑ 'ka 'nɛ mu 'ɛ ni, ‑mɛla ma 'bhɛɛ‑ 'ka Dɛ 'la ‑yoo laanima 'bhɛ 'laa nu 'sɔlɛ‑ 'ke 'ka pɛ ‑lrele' mu 'la ‑yrɛwoa ‑a ma 'mu 'nale‑ 'ka ni ɛɛ? ");
INSERT INTO moa_vpl VALUES ("MT7_12","070_7_12","MAT","7","12","12","'Kaa‑ zi 'bhii‑ mɛɛ ‑bhɛɛke' mu ‑za 'oo ‑za 'la klɛ 'ka ni, 'ka mu 'ezin‑ ‑ka 'bhɛ 'yansi za klɛ ‑o ni. Moizi a 'toŋ mu 'ɛ 'bhɛɛ‑ ‑jan mu 'ɛ ꞊woa, 'bhɛɛ‑ ‑Waanbhaa' ‑lɛla' janwo mu 'ɛ 'mu 'bhɛɛ‑ do 'kpɔ 'ɛ ꞊woa 'ezin‑.» ");
INSERT INTO moa_vpl VALUES ("MT7_13","070_7_13","MAT","7","13","13","«‑Ka wla ‑Waanbhaa' ba wlayrɛ kprɛnɛ‑ 'ɛ 'bhɛɛ‑ ꞊nɔɔ. ‑Amasrɔyi ‑Jranama 'wlayrɛ‑ ‑lii 'ɛ ‑yoo 'egbɛnɛle; 'bhɛɛ‑ zibhɛ 'la ge ‑a ꞊nɔɔ, 'bhɛ ‑laata' ‑o 'egbɛnɛle. ‑Ayile mɛɛ ‑bebe ge 'bhɛɛ‑ zi 'ɛ zi. ");
INSERT INTO moa_vpl VALUES ("MT7_14","070_7_14","MAT","7","14","14","'Duŋ‑ bole ‑yrɛ ma ‑si 'ɛ 'bhɛ 'wlayrɛ‑ ‑lii 'ɛ ‑yoo kprɛnɛ‑, 'bhɛ ꞊nɔɔ zibhɛ 'ɛ ‑yoo kprɛ; 'bhɛla‑ ‑yile mɛɛ ‑bebe 'laa 'bhɛ zi 'ɛ si.» ");
INSERT INTO moa_vpl VALUES ("MT7_15","070_7_15","MAT","7","15","15","Zesu pe ‑o ni 'ezin‑ dɔɔ: «‑Ka 'ka 'yrɛkpa 'ka 'gbu ba bhla ma ‑Waanbhaa' ‑lɛla' janwo mu 'ɛ ‑zayi'! ‑O nu 'ka ba ‑o ‑yi ‑dɔɔ 'le 'bhii‑ ‑bhlaa mu gbɛɛn‑, 'duŋ‑ ‑o 'gbu 'kpee, ‑woo 'ke srɔpɛ mu ‑la ‑le. ");
INSERT INTO moa_vpl VALUES ("MT7_16","070_7_16","MAT","7","16","16","'Ka sɔ ‑o dɔle‑ ‑o klɛza mu ‑la ma; 'bhii‑ 'ka sɔ ‑yri diiŋ 'ɛ dɔle‑ ‑a bhaa ma gɔnɛ‑ 'la gbɛɛn‑. 'Ka sɔ ‑lomliŋ' bhaa 'kanle daanlɛrɛ diiŋ mu 'yi ɛɛ, taa‑ 'ka sɔ 'maŋgloo bhaa 'kanle ‑zulɛrɛ diiŋ mu 'yi ɛɛ? ");
INSERT INTO moa_vpl VALUES ("MT7_17","070_7_17","MAT","7","17","17","‑Yri diiŋ wlan bhaa ‑lrele' mu ‑la klɛ, 'bhɛɛ‑ ‑yri diiŋ ‑yɔɔ' bhaa ‑yɔɔ' mu ‑la klɛ. ");
INSERT INTO moa_vpl VALUES ("MT7_18","070_7_18","MAT","7","18","18","‑Yri diiŋ wlan laa sɔ bhaa ‑yɔɔ' mu klɛle‑, 'bhɛ klɛgbɛya do 'ɛ 'yi, ‑yri diiŋ 'yɔɔ‑ laa sɔ bhaa ‑lrele' mu klɛle‑. ");
INSERT INTO moa_vpl VALUES ("MT7_19","070_7_19","MAT","7","19","19","'Ke ‑yri diiŋ 'oo ‑yri diiŋ 'la 'bhɛ 'laa 'bhɛ bhaa ‑lrele' klɛ, ‑o nu 'bhɛ takanlɛ, 'bhɛɛ‑ ‑wa blin 'tɛ 'ɛ 'yi. ");
INSERT INTO moa_vpl VALUES ("MT7_20","070_7_20","MAT","7","20","20","'Bhɛ 'yi, 'ka ‑yri diiŋ 'ɛ dɔ ‑a bhaa ma gɔnɛ‑ 'la gbɛɛn‑, 'ka nu bhla ma ‑Waanbhaa' ‑lɛla' janwo mu 'ɛ dɔlɛ ‑o klɛza mu 'ɛ ma 'bhɛɛ‑ gbɛɛn‑.» ");
INSERT INTO moa_vpl VALUES ("MT7_21","070_7_21","MAT","7","21","21","Zesu pe ‑o ni 'ezin‑ dɔɔ: «Mɛɛ 'la zan mu 'kpɛn 'mi sii 'kaa: ‹Mɛɛzan, Mɛɛzan›, ‑o 'kpɛn 'laa nu gelɛ laanima ‑bhleŋgbeya ‑wa 'ɛ ta; 'ke yaa 'e go mɛɛ 'la zan mu 'ŋ Dɛ 'la ‑yoo laanima 'bhɛ zru maza klɛ 'bhɛ zan mu do ‑kplɛn ba. ");
INSERT INTO moa_vpl VALUES ("MT7_22","070_7_22","MAT","7","22","22","'Kitikan yi ‑gbɛnɛ 'ɛ 'le, mɛɛ ‑bebe mu nu a pelɛ 'ŋ ni dɔɔ: ‹Mɛɛzan, Mɛɛzan, 'o mɔɔ ‑Waanbhaa' ‑lɛlajanwoa 'e 'tɔ 'yi, 'o 'zina mu ‑gbian mɛɛ mu zi 'e 'tɔ 'ɛ 'yi, 'bhɛɛ‑ 'o 'sɔle‑ maza ‑bebe ꞊kla 'e 'tɔ 'ɛ 'yi.› ");
INSERT INTO moa_vpl VALUES ("MT7_23","070_7_23","MAT","7","23","23","'Ke ‑o 'bhɛ ꞊pia, 'ŋ nu a zikpalɛ ‑o ni dɔɔ: ‹'Naa 'ka dɔlɛ ‑lido'; ‑ka 'ka 'pleŋgo‑ 'ŋ ma 'egbɔɔnle, ‑za 'yɔɔ‑ klɛ mu.›» ");
INSERT INTO moa_vpl VALUES ("MT7_24","070_7_24","MAT","7","24","24","Zesu pe ‑o ni 'ezin‑ dɔɔ: «'Bhɛ ya 'ɛ 'yi, 'ke mɛɛ 'la zan 'ŋ 'wojan‑ mu 'lɛɛ‑ ꞊maa, 'bhɛɛ‑ 'ke ‑yoo ‑yizakla, 'bhɛ zan 'ɛ ‑yoo 'bhii‑ mɛɛ yikanle do 'la ‑yaa' 'fɛ 'ɛ ‑dwa vlɛ ‑saa ‑glɔɔ do ta. ");
INSERT INTO moa_vpl VALUES ("MT7_25","070_7_25","MAT","7","25","25","La ‑gbɛnɛ do ‑baan, 'bhɛɛ‑ tɔ mu 'ɛ ꞊kaan, 'bhɛ 'pegee la 'yi 'ɛ paa 'fɛ 'ɛ ma 'kee‑ bɛɛnle‑; 'duŋ‑ 'fɛ 'ɛ yaa 'klalɛ‑; ‑amasrɔyi 'fɛ 'ɛ gaan bɔle ‑yaa vlɛ ‑saa ‑glɔɔ 'ɛ ta. ");
INSERT INTO moa_vpl VALUES ("MT7_26","070_7_26","MAT","7","26","26","'Bhɛ klɛgbɛya do 'ɛ gbɛɛn‑, 'ke mɛɛ 'la zan 'ŋ 'wojan‑ mu 'la bhe ‑o ꞊maa, 'bhɛɛ‑ 'ke yaa ‑o ‑yizaklɛlɛ, ‑yoo 'bhii‑ ‑zadɔkle mɛɛ 'la 'bhɛ 'bhɛ a 'fɛ do ‑dwa ‑yrɛntrɛ' 'yi. ");
INSERT INTO moa_vpl VALUES ("MT7_27","070_7_27","MAT","7","27","27","La ‑gbɛnɛ do ‑baan, 'bhɛɛ‑ tɔ mu 'ɛ ꞊kaan, 'bhɛ 'pegee ‑ploo ‑gbɛnɛ do ‑kaan, 'bhɛɛ‑ la 'yi 'ɛ ꞊paa 'fɛ 'ɛ ma, 'kee‑ bɛɛnle‑, 'kee‑ 'klaale, 'bhɛɛ‑ ‑e ꞊wia 'feŋfeŋ.» ");
INSERT INTO moa_vpl VALUES ("MT7_28","070_7_28","MAT","7","28","28","Zesu 'yanle‑ ‑zamaa' 'ɛ daanlele, 'ke ‑o 'kpɛn 'liibhaale ‑o ma ‑yaa' mɛɛ daangbɛya 'ɛ ma. ");
INSERT INTO moa_vpl VALUES ("MT7_29","070_7_29","MAT","7","29","29","‑Amasrɔyi yaa mɛɛ mu 'ɛ daanlɛ 'bhii‑ ‑waa' 'Toŋ daan mu 'ɛ ‑waa' daangbɛya 'ɛ gbɛɛn‑. ‑Yoo ‑daanna 'bhii‑ 'seŋzan‑. ");
INSERT INTO moa_vpl VALUES ("MT8_1","070_8_1","MAT","8","1","1","Zesu gole vlɛ gɔɔn 'ɛ 'wiiŋ‑, 'ke ‑zamaa' 'saa do dɔle‑ ‑a zi. ");
INSERT INTO moa_vpl VALUES ("MT8_2","070_8_2","MAT","8","2","2","‑Woo ‑yrɛkpa', 'ke ‑kpaandɛ' mi do 'e 'mabɛɛnle ‑a ‑din, 'bhɛɛ‑ 'ke 'bhɛ 'e 'kpɔ zɛnle‑ ‑a 'lɛɛ, 'bhɛɛ‑ 'ke 'bhɛ 'a 'pele 'a ni dɔɔ: «'Ŋ Zan, 'kee‑ ‑swa 'e ni, 'e sɔ 'ŋ 'bheele.» ");
INSERT INTO moa_vpl VALUES ("MT8_3","070_8_3","MAT","8","3","3","'Bhɛ 'yi 'tɛ, 'ke Zesu 'e gbɛ 'trole ‑a ba ‑yrɛ ta; 'bhɛɛ‑ 'ke 'bhɛ 'e gbɛ 'kpale ‑a ma, 'bhɛɛ‑ 'ke 'bhɛ 'a pele‑ 'a ni dɔɔ: «'Ŋ 'yoo‑ ‑a zi 'bhii‑ 'e 'bhee, bhaa 'e 'flɛ bakan' 'weŋ!» 'Bhɛ yrɛ do 'ɛ ꞊nɔɔ bhe, 'ke ‑yaa' ‑kpaan 'ɛ gole‑ ‑a ma, 'bhɛɛ‑ 'ke ‑a 'flɛ bakanle 'weŋ. ");
INSERT INTO moa_vpl VALUES ("MT8_4","070_8_4","MAT","8","4","4","'Bhɛ blaan, 'ke Zesu 'a 'pele 'a ni dɔɔ: «'E 'trɔnkpa 'elrele 'ŋ ni: 'Yaa 'e 'bheeza‑ 'ɛ 'pelɛ‑ mɛɛ ‑bhɛɛke' do 'kpɔ ni. Ge 'sraka 'lɛna mi 'ɛ ba, 'bhɛɛ‑ ‑yee' maglin‑ doo, 'bhɛɛ‑ Moizi 'sraka 'la goza ꞊pia ‑kpaandɛ' mu ‑bheeza' 'ɛ 'yi, 'bhɛ go, 'kooko‑ mɔkpɛn' nu 'a 'yaango‑ 'bhii‑ 'e 'bheela‑.» ");
INSERT INTO moa_vpl VALUES ("MT8_5","070_8_5","MAT","8","5","5","Zesu 'bhɔle‑ Kapɛnɔmu, 'ke Romɛ mu a ‑srwase' mu ‑kuŋlii do 'e 'mabɛɛnle ‑a ‑din, 'bhɛɛ‑ ");
INSERT INTO moa_vpl VALUES ("MT8_6","070_8_6","MAT","8","6","6","'ke 'bhɛ 'a 'pele‑ ‑a ni dɔɔ: «'Ŋ Zan, ga ‑o 'an yewonɛ 'ɛ do ma, 'bhɛɛ‑ ‑a yilale ‑o 'fɛ 'lɛ ma; ‑a dɔpɛ mu 'ɛ 'kpɛn ‑gaa ‑a ma, 'bhɛɛ‑ yaa sɔ 'taawole, ‑ayile ‑yoo ‑yrɛnbhle' zii' 'ebebele.» ");
INSERT INTO moa_vpl VALUES ("MT8_7","070_8_7","MAT","8","7","7","'Bhɛ klɛle 'tɛ, 'ke Zesu 'a 'pele 'a ni dɔɔ: «'Mi 'gbu nu gelɛ ‑a ‑bheelɛ' 'e ba ‑lɛ ma.» ");
INSERT INTO moa_vpl VALUES ("MT8_8","070_8_8","MAT","8","8","8","'Bhɛ ꞊nɔɔ bhe, 'ke 'yee‑ ‑srwase' mu ‑kuŋlii 'ɛ ‑ya pele‑ Zesu ni dɔɔ: «'Ŋ Zan, 'mi Romɛ mi, ‑a ‑gaale' laa ‑o 'ŋ ba 'kee‑ nu 'mi ba. 'Duŋ‑ ‑jangɔ' do 'kpɔ 'wo, 'bhɛɛ‑ 'an yewonɛ 'ɛ nu ‑bheelɛ'. ");
INSERT INTO moa_vpl VALUES ("MT8_9","070_8_9","MAT","8","9","9","'Duŋ‑ 'woo‑ ‑a ꞊nɔɔ bhe oo, 'mi 'gbu ta ‑kuŋlii mu ‑o 'ke mɛɛ 'ke mu 'le, 'bhɛɛ‑ 'ŋ 'yoo‑ ‑srwase' 'ke mu ta ‑kuŋlii 'le. 'An pe ‑a do ni: ‹Ge!› 'Bhɛɛ‑ 'bhɛ ge; 'an pe ‑a ‑bhɛɛke' do ni: ‹Nu ‑gɛ!› 'Bhɛɛ‑ 'bhɛ nu; 'an pe 'an yewonɛ 'ɛ do ni: ‹‑Za 'lɛɛ‑ klɛ!› 'Bhɛɛ‑ 'bhɛ 'bhɛ klɛ.» ");
INSERT INTO moa_vpl VALUES ("MT8_10","070_8_10","MAT","8","10","10","Zesu 'a 'liijan‑ 'ɛ 'male‑, 'bhɛɛ‑ 'bhɛ 'liibhaa‑ 'bhɛ ma, 'ke 'bhɛ 'a 'pele 'bhɛ a ‑klaŋlanɛ mu 'ɛ ni dɔɔ: «'Naa 'bhɛ mɛɛ ‑glɔɔn 'yelɛ‑ ‑lido' 'ke 'bhɛ 'e kpa ‑Waanbhaa' 'yi 'egbɛnɛle 'bhii‑ mɛɛ 'lɛɛ‑ gbɛɛn‑, 'ali‑ 'kee‑ kpa Izraɛli 'klɛɛn 'kpɛn ta. ");
INSERT INTO moa_vpl VALUES ("MT8_11","070_8_11","MAT","8","11","11","'Mi pe 'ka ni 'ezin‑ dɔɔ: Mɛɛ ‑bebe nu dalɛ ‑yretɛbhɛ ‑wlɛnyrɛ' 'pegee ‑yretɛbhɛ baayrɛ ꞊nɔɔ, 'bhɛɛ‑ ‑o nu gelɛ pɛbhlelɛ 'eke‑ zi ‑tabali do ta ‑o 'pegee Abraamu oo, Izaki oo, 'bhɛɛ‑ Zakɔbu mu 'le laanima ‑bhleŋgbeya ‑wa 'ɛ ta. ");
INSERT INTO moa_vpl VALUES ("MT8_12","070_8_12","MAT","8","12","12","'Duŋ‑ 'yee‑ ‑bhleŋgbeya 'tɔ 'ɛ ‑yoo mɛɛ 'la zan mu ma, ‑o nu 'mu blinlɛ 'pɛɛlii‑ ‑gblo ‑gbɛnɛ 'ɛ 'yi. 'Bhɛ ꞊nɔɔ bhe, ‑o nu wisilɛ, 'bhɛɛ‑ ‑zadɔwɛɛ 'ɛ 'kɔɔ, ‑o nu ‑o gbɛnɛbhɛ mu 'ɛ 'sɔnkpalɛ.» ");
INSERT INTO moa_vpl VALUES ("MT8_13","070_8_13","MAT","8","13","13","'Bhɛ blaan, 'ke Zesu 'a 'pele ‑srwase' mu ‑kuŋlii 'ɛ ni dɔɔ: «Ge 'e ba ‑lɛ ma. 'Yee ꞊kpaa ‑Waanbhaa' 'yi gɔnɛ‑ 'la gbɛɛn‑, ‑e nu 'bhɛɛ‑ 'wlata‑ za klɛlɛ 'e ni.» 'Bhɛ klɛle 'tɛ, 'ke ‑srwase' mu ‑kuŋlii 'ɛ ‑yaa' yewonɛ 'ɛ 'bheele 'bhɛ 'waati do 'kpɔ 'ɛ ba. ");
INSERT INTO moa_vpl VALUES ("MT8_14","070_8_14","MAT","8","14","14","Zesu ‑ja Piɛri ba ‑lɛ ma, 'bhɛɛ‑ ‑e Piɛri boole yilale ꞊ya: 'Bhɛ 'flɛ 'yi 'yaa‑ ‑la 'zi. ");
INSERT INTO moa_vpl VALUES ("MT8_15","070_8_15","MAT","8","15","15","Zesu 'e gbɛ yanle ‑a ma, 'ke ‑a 'flɛ 'yi 'la ga 'ɛ gole‑; 'ke ‑ya ‑wlɛnle', 'bhɛɛ‑ 'kee‑ Zesu ‑lɛwɛɛ' kpo klɛle‑. ");
INSERT INTO moa_vpl VALUES ("MT8_16","070_8_16","MAT","8","16","16","Yromazi bhɔle, 'ke ‑o nule‑ 'zina mu ‑yaa mɛɛ 'la zan mu zi 'mu 'le ‑a ni. ‑E 'woo‑ 'zina mu 'ɛ ꞊gbian 'woo‑ mɛɛ mu 'ɛ zi, 'bhɛ 'pegee ‑e gadɛ mu ‑vin mu 'ɛ 'kpɛn 'bheela‑ ‑a ‑liijan' do 'kpɔ 'ɛ 'le. ");
INSERT INTO moa_vpl VALUES ("MT8_17","070_8_17","MAT","8","17","17","‑Yaa' mɛɛ ‑bheeza' 'ɛ 'bhɛ ‑Waanbhaa' ‑lɛla' janwo mi Ezai jan 'la ꞊woa 'elwale gban ‑sɔ 'bhɛ 'lɛswa꞊: 'Bhɛ 'a ‑pia dɔɔ: «‑Yoo' ta ‑yrɛn mu 'ɛ 'kpɛn ‑gwa, 'bhɛ 'pegee ‑yoo ma ga mu 'ɛ ‑gwa.» ");
INSERT INTO moa_vpl VALUES ("MT8_18","070_8_18","MAT","8","18","18","Zesu ‑zamaa' do yele‑ ‑a zi, 'ke ‑ya pele‑ ‑yaa' ‑klaŋlanɛ mu 'ɛ ni dɔɔ ‑o 'kan ‑draa 'yrɛ gbɛ do 'ɛ ta. ");
INSERT INTO moa_vpl VALUES ("MT8_19","070_8_19","MAT","8","19","19","'Bhɛ ya 'ɛ 'yi, 'ke 'Toŋ daan mi do 'a 'pele 'a ni dɔɔ: «'O Daan mi, 'ŋ nu gelɛ 'e zi yrɛkpɛn‑ ꞊nɔɔ.» ");
INSERT INTO moa_vpl VALUES ("MT8_20","070_8_20","MAT","8","20","20","'Bhɛ klɛle 'tɛ, 'ke Zesu 'a 'pele ‑a ni 'kaa: «‑Gbɛŋgbɛni mu yila‑ ‑gluu mu ‑o, 'bhɛ 'pegee maannɛ‑ mu yi 'fɛ mu ‑o, 'duŋ‑ yilayrɛ 'pegee ‑yitrɛ' yrɛ do 'kpɔ 'laa ‑o Bhaaplɛŋ Gbe 'ɛ 'kɔɔ.» ");
INSERT INTO moa_vpl VALUES ("MT8_21","070_8_21","MAT","8","21","21","‑Yaa' ‑klaŋlanɛ mu 'ɛ do pe ‑a ni dɔɔ: «'Ŋ Zan, ‑a 'to 'ke 'ŋ ge 'ŋ dɛ bin 'pe, 'bhɛɛ‑ 'ŋ nu klɛlɛ 'yaa‑ ‑klaŋlanɛ mu 'ɛ do 'le.» ");
INSERT INTO moa_vpl VALUES ("MT8_22","070_8_22","MAT","8","22","22","Zesu pe ‑a ni dɔɔ: «'Bhi nu dɔ 'ŋ zi, 'bhɛɛ‑ mɛɛ gbaa mu 'to 'ke ‑o ‑waa' gbaa mu 'ɛ bin.» ");
INSERT INTO moa_vpl VALUES ("MT8_23","070_8_23","MAT","8","23","23","Zesu 'pegee ‑yaa' ‑klaŋlanɛ mu 'ɛ ‑o ‑saan ‑yitakoŋ 'ɛ 'yi ‑yi 'ɛ ba. ");
INSERT INTO moa_vpl VALUES ("MT8_24","070_8_24","MAT","8","24","24","‑O ‑yaa ‑draa 'ɛ takan' zii' ‑yitakoŋ 'ɛ 'yi 'waati 'la ba, ‑woo ‑yrɛkpa', 'ke ‑ploo ‑gbɛnɛ do 'kanle‑ 'sanle. 'Bhɛɛ‑ ‑yi 'pɔɔ mu 'ɛ 'yaa‑ zan 'kpalɛ‑ ‑yitakoŋ 'ɛ ta. 'Duŋ‑ Zesu 'yaa‑ yidɛ 'zi 'bhɛ bhla 'ɛ ba. ");
INSERT INTO moa_vpl VALUES ("MT8_25","070_8_25","MAT","8","25","25","'Bhɛ klɛle 'tɛ, 'ke ‑yaa' ‑klaŋlanɛ mu 'ɛ ‑woo mabɛɛnle 'a ‑din, 'bhɛɛ‑ 'ke ‑wa bwele‑ 'kaa: «'O Zan, 'woo‑ zan galɛ, 'o go ‑za 'yi!» ");
INSERT INTO moa_vpl VALUES ("MT8_26","070_8_26","MAT","8","26","26","'Bhɛ ya 'ɛ 'yi, 'ke Zesu 'a 'pele ‑o ni dɔɔ: «‑Mɛle ꞊kla 'ka ‑o ‑gblaan 'zi ɛɛ? ‑Mɛle ꞊kla 'bhɛɛ‑ 'kaa‑ 'kpaleya 'ɛ ‑Waanbhaa' 'yi 'bhɛ 'lɛbole ‑o ɛɛ?» 'Bhɛ 'yi, 'ke Zesu 'e 'wlɛnle‑ 'tɛ, 'bhɛɛ‑ 'kee‑ 'pɛɛnle‑ ‑ploo 'ɛ 'pegee ‑draa 'yi 'ɛ ta. 'Bhɛ klɛle 'tɛ, 'ke ‑ploo 'ɛ makpaale, 'bhɛɛ‑ 'ke ‑yi 'ɛ 'yrɛ ta dɔle‑ siiŋ 'egbɛnɛle. ");
INSERT INTO moa_vpl VALUES ("MT8_27","070_8_27","MAT","8","27","27","‑Ayile, ‑yaa' ‑klaŋlanɛ mu 'ɛ 'kpɛn 'kpeelɛnia ‑o ma, 'bhɛɛ‑ 'ke ‑wa pele‑ dɔɔ: «Mɛɛ ‑glɔɔn 'ɛ ‑de 'gbu ‑le mɛɛ 'lɛɛ‑ 'le ɛɛ? 'Ali‑ ‑ploo mu 'pegee ‑draa 'yi 'ɛ 'mu 'a 'weli‑ ma, 'bhɛɛ‑ 'mu 'a ‑liijan' ‑lɛdɔ' ‑a ma.» ");
INSERT INTO moa_vpl VALUES ("MT8_28","070_8_28","MAT","8","28","28","‑O bhɔle ‑draa 'yrɛ gbɛ do 'ɛ ta, Gadara mu a 'klɛɛn 'yi, 'ke mɛɛ plɛ dale‑ mɛɛ bu mu 'ɛ ta, 'ke 'mu 'nule Zesu 'lɛpalɛ. 'Zina ‑yaa ‑o zi, ‑asiikɔɔ mɛɛ 'kedo‑ 'kpɔ 'laa ‑yaa dɔ 'kanle‑ ‑la mɛɛ binyrɛ 'ɛ ꞊nɔɔ zi 'ɛ 'lii. ");
INSERT INTO moa_vpl VALUES ("MT8_29","070_8_29","MAT","8","29","29","‑O 'pɛɛnle‑ ‑saan 'eglɔɔle dɔɔ: «‑Waanbhaa' Gbe, 'yoo‑ ‑mɛla zi 'o 'kɔɔ ɛɛ? 'O mɔɔ ta ‑yrɛnkpa' 'waati 'ɛ 'bhɛ 'laa bhɔlɛ ‑li, 'bhɛɛ‑ 'e ꞊nwa ‑yrɛnkpalɛ 'o ta ɛɛ?» ");
INSERT INTO moa_vpl VALUES ("MT8_30","070_8_30","MAT","8","30","30","'Bhɛ 'waati do 'kpɔ 'ɛ ba, ꞊swa 'lɛ ‑gbɛnɛ do ‑yaa pɛbhle 'zi ‑o ma 'egbɔɔnle sa. ");
INSERT INTO moa_vpl VALUES ("MT8_31","070_8_31","MAT","8","31","31","'Bhɛ klɛle 'tɛ, 'zina mu 'la 'yaa‑ 'woo‑ mɛɛ plɛ 'ɛ zi, ‑o ‑sromabwa Zesu ni dɔɔ: «'Ke 'yoo ꞊gbian mɛɛ plɛ 'lɛɛ‑ zi, ‑a 'to 'o ge wla ꞊swa 'lɛdo‑ 'la laale bhe 'mu 'yi!» ");
INSERT INTO moa_vpl VALUES ("MT8_32","070_8_32","MAT","8","32","32","'Bhɛ klɛle 'tɛ, 'ke Zesu 'a 'pele ‑o ni 'kaa: «‑Ka ge 'bhɛ klɛ!» ‑Ayile, 'woo‑ 'zina mu 'ɛ gole 'yee‑ mɛɛ plɛ 'ɛ zi, 'ke ‑o gele‑ wlalɛ 'swanɛ 'lɛdo‑ 'ɛ 'yi. 'Bhɛ klɛlɛ 'tɛ, 'ke 'swanɛ 'lɛdo‑ 'ɛ dale‑ blasanlele vlɛ gɔɔn 'ɛ 'wiiŋ‑, 'bhɛɛ‑ ‑o 'kpɛn ꞊nwa baalɛ ‑yi 'ɛ ba, 'bhɛɛ‑ ‑o ‑gaa. ");
INSERT INTO moa_vpl VALUES ("MT8_33","070_8_33","MAT","8","33","33","'Bhɛ ya 'ɛ 'yi, 'ke 'woo‑ 'swanɛ mu 'ɛ gooba mu 'ɛ ‑o blasanle, 'bhɛɛ‑ 'ke ‑o gele‑ blaale‑ ‑wa la. ‑O bhɔle 'bhɛ ꞊nɔɔ bhe, 'ke ‑o 'zina zan plɛ 'ɛ ‑waa' ‑za 'pegee 'swanɛ mu 'ɛ dɛza 'ɛ 'kpɛn 'yigɔɔnle ‑waa' ‑wa 'ɛ ta mu 'ɛ ni. ");
INSERT INTO moa_vpl VALUES ("MT8_34","070_8_34","MAT","8","34","34","‑Ayile, 'ke ‑wa 'ɛ ta mu 'ɛ 'kpɛn 'pwɛle, 'ke ‑o 'nule Zesu ba ‑yrɛ ta. ‑O bhɔle ‑a ‑din, 'ke ‑o ‑sromabɔle ‑a ni dɔɔ ‑e go ‑waa' 'klɛɛn 'ɛ 'yi. ");
INSERT INTO moa_vpl VALUES ("MT9_1","070_9_1","MAT","9","1","1","'Bhɛ blaan, 'ke Zesu 'sanle ‑yitakoŋ 'ɛ 'yi, 'bhɛɛ‑ 'kee‑ niinale ‑a ba ‑wa la. ");
INSERT INTO moa_vpl VALUES ("MT9_2","070_9_2","MAT","9","2","2","'Bhɛ klɛle 'tɛ, 'ke ‑o nule‑ ‑flugba do 'le ‑a ni yrɔ do 'yi. Zesu 'a 'yaangole 'bhii‑ gadɛ mi 'ɛ madɔ mu 'ɛ ‑woo ‑kpaa ‑a ‑yi, 'ke ‑ya pele‑ gadɛ mi 'ɛ ni dɔɔ: «'Ŋ 'nɛ, 'e zru dɔ 'eglɔɔle, 'ŋ 'yaa‑ ‑za 'yɔɔ‑ mu 'ɛ 'kpɛn ‑sroma ‑yaan.» ");
INSERT INTO moa_vpl VALUES ("MT9_3","070_9_3","MAT","9","3","3","'Bhɛ 'yi bhe 'tɛ, 'ke 'Toŋ daan mu 'ɛ 'ke mu 'a 'pele 'mu 'gbu 'kpee dɔɔ: «Mɛɛ 'lɛɛ‑ ‑yoo ‑Waanbhaa' 'tɔsiɛ zii'!» ");
INSERT INTO moa_vpl VALUES ("MT9_4","070_9_4","MAT","9","4","4","Zesu ‑o 'kpeejan‑ mu 'ɛ dɔle 'ke ‑ya pele‑ ‑o ni dɔɔ: «‑Mɛle ꞊kla 'bhɛɛ‑ 'ka 'kpeejan‑ mu 'ɛ ‑woo 'eyɔɔle ɛɛ? ");
INSERT INTO moa_vpl VALUES ("MT9_5","070_9_5","MAT","9","5","5","'Woo‑ ‑za plɛ 'gbu 'lɛɛ‑ ‑o ‑de 'gbu ‑le 'eglɔɔle ɛɛ? 'Ke 'an pe gadɛ mi 'ɛ ni dɔɔ: ‹'Ŋ 'yaa‑ ‑za 'yɔɔ‑ mu 'ɛ ma ‑sroma ‑yaan› Taa‑ 'ke 'an pe ‑a ni dɔɔ: ‹'E 'wlɛn‑, 'bhɛɛ‑ 'taawo ɛɛ?› ");
INSERT INTO moa_vpl VALUES ("MT9_6","070_9_6","MAT","9","6","6","'Duŋ‑ 'ŋ 'yoo‑ ‑a zi 'bhii‑ 'kaa 'yaango‑ dɔɔ 'bhɛ 'seŋ ‑o Bhaaplɛŋ Gbe 'ɛ ni 'trɛ ta ‑gɛ 'kee‑ bhaaplɛŋ mu a ‑za 'yɔɔ‑ mu ma ‑sroma yan.» ‑Ayile 'ke ‑ya pele‑ 'bhɛ ni dɔɔ: «'E 'wlɛn‑, 'e 'yila‑ yrɔ 'ɛ 'si, 'bhɛɛ‑ ge 'e ba ‑lɛ ma!» ");
INSERT INTO moa_vpl VALUES ("MT9_7","070_9_7","MAT","9","7","7","'Bhɛ klɛle 'tɛ, 'ke ‑flugba 'ɛ ‑ya ‑wlɛnle', 'bhɛɛ‑ 'kee‑ gele‑ ‑a ba ‑lɛ ma. ");
INSERT INTO moa_vpl VALUES ("MT9_8","070_9_8","MAT","9","8","8","‑Zamaa' 'ɛ 'yrɛkpale ‑flugba 'ɛ 'bheele‑ ma, 'ke ‑gblaan 'klale ‑o ‑yi, 'bhɛla‑ ‑yile, 'ke ‑o ‑Waanbhaa' 'tɔbhɔle 'bhɛ 'seŋ ‑glɔɔn 'ɛ 'naza‑ 'ɛ 'yi bhaaplɛŋ mu ni 'bhɛ ma. ");
INSERT INTO moa_vpl VALUES ("MT9_9","070_9_9","MAT","9","9","9","'Bhɛ blaan, Zesu 'yaa‑ ge 'zi bhla 'la ba, 'ke ‑a ‑yrɛkpale mɛɛ do yaale ma 'nisra gbawo 'fɛ 'ɛ ꞊la: ‑O ‑yaa 'bhɛ sii Matie. 'Bhɛ 'nɔɔ‑ bhe, 'ke ‑ya pelɛ 'bhɛ ni dɔɔ: «Nu dɔ 'ŋ zi!» Matie 'e 'wlɛnle‑ 'kee‑ gele‑ dɔlɛ Zesu zi. ");
INSERT INTO moa_vpl VALUES ("MT9_10","070_9_10","MAT","9","10","10","'Bhɛ blaan, Zesu 'pegee ‑yaa' ‑klaŋlanɛ mu 'ɛ 'yaa‑ pɛbhle 'zi Matie ba 'fɛ 'ɛ ꞊la. 'Bhɛ ꞊nɔɔ bhe, Zesu 'pegee 'nisrakun mu ‑bebe 'pegee mɛɛ 'joo 'yɔɔ‑ ‑bhɛɛke' mu ‑yaa pɛbhle 'zi 'eke‑ ta. ");
INSERT INTO moa_vpl VALUES ("MT9_11","070_9_11","MAT","9","11","11","Farizi mu 'ɛ ‑o ‑yrɛkpale 'bhɛ ma 'tɛ, 'ke ‑wa pele‑ Zesu a ‑klaŋlanɛ mu 'ɛ ni dɔɔ: «‑Mɛle ꞊kla 'bhɛɛ‑ 'ka daan mi 'ɛ 'pegee 'nisrakun mu 'ɛ, 'bhɛɛ‑ mɛɛ 'joo 'yɔɔ‑ mu 'ɛ ‑woo pɛbhle 'zi 'eke‑ ta ɛɛ?» ");
INSERT INTO moa_vpl VALUES ("MT9_12","070_9_12","MAT","9","12","12","Zesu 'trɔnbɔle ‑o wojan 'ɛ 'yi, 'ke ‑ya pele‑ dɔɔ: «Mɛɛ 'klɛnyawole mu maza laa ‑o ‑laanɛkpa mi ma; 'ke yaa 'e go gadɛ mu ba. ");
INSERT INTO moa_vpl VALUES ("MT9_13","070_9_13","MAT","9","13","13","‑Waanbhaa' ‑yaa' ‑jangɔ' do 'kpɔ 'la ꞊woa dɔɔ: ‹'Ŋ maza laa ‑o 'sraka do 'kpɔ ma 'ke ya 'e go mɛɛ ‑yrɛnklale 'ŋ ma 'bhɛ ba;› ‑ka ge 'bhɛ ‑jan 'ɛ 'yima, 'bhɛɛ‑ ‑kaa daan. ‑Amasrɔyi 'naa 'nulɛ‑ mɛɛ 'la zan mu 'mu 'gbu ye 'bhii‑ mɛɛ ‑lɛdɔɔle mu 'mu 'siiyrɛ‑ nɔɔ‑, 'duŋ‑ 'ŋ ꞊nwa ‑za 'yɔɔ‑ klɛ mu ‑la 'siilɛ‑.» ");
INSERT INTO moa_vpl VALUES ("MT9_14","070_9_14","MAT","9","14","14","‑Yrekpaa' do, 'ke Mɛɛ Wiiŋfɛ' Mi Zaan a ‑klaŋlanɛ mu 'ɛ 'nule Zesu ba, 'bhɛɛ‑ 'ke ‑wa ‑lrɔkpale dɔɔ: «‑Mɛle ꞊kla 'o mɔɔ 'pegee Farizi mu 'ɛ 'o 'suŋwla 'ebebele, 'bhɛɛ‑ 'yaa‑ pɛ ‑klaŋlanɛ mu 'ɛ waa 'suŋwla‑ ɛɛ?» ");
INSERT INTO moa_vpl VALUES ("MT9_15","070_9_15","MAT","9","15","15","'Bhɛɛ‑, Zesu 'bhɛ ‑jan 'ɛ zikpaa‑ ‑o ni dɔɔ: «'Ka mu 'gbu 'kpee ma, le dɔyrɛ nɔɔ‑ mu 'ɛ ‑o sɔ ‑o wlɛyisriwole 'ke le ‑nɔɔ 'ɛ 'yoo ‑o ‑din 'waati 'la ba ɛɛ? 'Yooye‑ 'bhɛ 'la sɔ klɛle! 'Duŋ‑ 'ke le ‑nɔɔ 'ɛ ‑gwa ‑o ‑din bhla 'la ba, 'bhɛɛ‑ ‑o nu 'suŋwlalɛ 'tɛ.» ");
INSERT INTO moa_vpl VALUES ("MT9_16","070_9_16","MAT","9","16","16","«Waa sɔ dunɛ‑ gwe ‑yisrale 'ke sɔpee' drɛɛ 'le; 'kebhlaale, sɔpee' drɛɛ 'ɛ 'wlayrɛ‑ nɔɔ‑ 'eke‑ ta, ‑e dunɛ‑ gwe 'ɛ 'bhɛ sɔ 'ɛ glaan; 'bhɛɛ‑ ‑e 'peedɛ‑ 'egbɛnɛle 'ke 'bhɛ kan ‑a 'peedɛyrɛ ꞊lwa 'ɛ ta. ");
INSERT INTO moa_vpl VALUES ("MT9_17","070_9_17","MAT","9","17","17","'Bhɛɛ‑ waa ‑wɛɛn drɛɛ kla wi 'flɛ 'floko gwe mu 'yi; 'ke 'bhɛ ꞊kla wi 'flɛ 'floko gwe mu 'ɛ ‑o 'peedɛ‑, 'bhɛɛ‑ ‑o ‑yi ‑wɛɛn 'ɛ klalaa', 'bhɛɛ‑ ‑e klɛ 'ke 'siɛ pɛ 'le. 'Duŋ‑ ‑o ‑wɛɛn drɛɛ kla wi 'flɛ 'floko drɛɛ mu ‑la ‑yi, 'bhɛɛ‑ waa sɔ 'eke‑ 'siɛle.» ");
INSERT INTO moa_vpl VALUES ("MT9_18","070_9_18","MAT","9","18","18","Zesu 'yaa‑ 'bhɛ ‑jan mu 'ɛ 'wo zii' ‑o ni bhla 'la ba, 'ke Zuufu mu 'ɛ ‑waa' ‑kuŋlii do nule‑ Zesu ba, 'bhɛɛ‑ 'ke ‑ya 'kpɔ zɛnle‑ Zesu 'lɛɛ. 'Bhɛɛ‑ ‑e pe dɔɔ: «'Ŋ 'lu 'nɛ 'ɛ ꞊kla 'ke 'siɛle, 'bhɛ ꞊nɔɔ 'laa ‑mɔlɛ' ‑li, nu ge 'e gbɛkpa' ‑a ma, 'bhɛɛ‑ ‑e bwe gale ba.» ");
INSERT INTO moa_vpl VALUES ("MT9_19","070_9_19","MAT","9","19","19","Zesu 'e 'wlɛnle‑, 'ke ‑o 'pegee ‑yaa' ‑klaŋlanɛ mu 'ɛ dɔle‑ mɛɛ 'ɛ zi. ");
INSERT INTO moa_vpl VALUES ("MT9_20","070_9_20","MAT","9","20","20","'Duŋ‑, le do ‑yaa ‑zamaa' 'ɛ 'pleŋ‑, 'bhɛ lɛɛ vu ta plɛ ‑le yaa bhe, 'ke yaa ‑yito' 'ɛ 'lɛ 'laa kan. 'Bhɛ le 'ɛ ꞊nwa Zesu ‑zanta' yrɛtɛtɛ, 'ke ‑ya gbɛ yanle‑ 'bhɛ ta dunɛ‑ gbɔɔn 'ɛ ma. ");
INSERT INTO moa_vpl VALUES ("MT9_21","070_9_21","MAT","9","21","21","‑E ‑yaa pe 'zi ‑a 'gbu 'kpee dɔɔ: «'Ali‑ 'ke 'ŋ 'yaa‑ sɔ 'ŋ gbɛ yanle sa ‑a ta dunɛ‑ 'ɛ ma, 'ŋ 'yaa‑ nu ‑bheelɛ'.» ");
INSERT INTO moa_vpl VALUES ("MT9_22","070_9_22","MAT","9","22","22","Zesu 'e 'yrɛkpale ‑a ‑zanta', 'kee‑ 'yee‑ le 'ɛ 'yele, 'bhɛɛ‑ ‑e pe 'bhɛ ni dɔɔ: «'E zru dɔ 'eglɔɔle, 'ŋ lu! 'Yee 'kpalawoa mi 'yi bhe 'e 'bheela‑.» 'Bhɛ yrɛ do 'kpɔ 'ɛ ꞊nɔɔ bhe, 'ke 'yee‑ le 'ɛ 'bheele. ");
INSERT INTO moa_vpl VALUES ("MT9_23","070_9_23","MAT","9","23","23","Zesu 'bhɔle‑ Zuufu mu 'ɛ ‑waa' ‑kuŋlii 'ɛ ba, 'kee‑ bheela ‑gofɛn' 'pɛn mu 'pegee ‑zamaa' 'srɛ do yele‑. ‑O ‑yaa wisi' zii' 'eglɔɔle ‑asiikɔɔ mɛɛ laa ‑yaa sɔ jan 'male. ");
INSERT INTO moa_vpl VALUES ("MT9_24","070_9_24","MAT","9","24","24","'Bhɛ 'yi, 'ke Zesu 'a 'pele ‑o ni dɔɔ: «‑Ka 'pwɛ, ‑nɛ ‑gblanɛ 'ɛ yaa galɛ, 'duŋ‑ ‑yoo yidɛ 'zi.» ‑Ayile, 'ke mɛɛ mu 'ɛ ‑o 'sɔnsile Zesu ma. ");
INSERT INTO moa_vpl VALUES ("MT9_25","070_9_25","MAT","9","25","25","‑Zamaa' 'ɛ 'pwɛle‑ blaan 'pɛɛlii‑, 'ke Zesu 'wlale 'fɛ 'ɛ ꞊la, 'bhɛɛ‑ 'kee‑ ‑nɛ ‑gblanɛ 'ɛ 'kunle 'bhɛ gbɛ ma, 'ke 'bhɛ bwele‑ gale ba, 'bhɛɛ‑ 'ke 'bhɛ 'e 'wlɛnle. ");
INSERT INTO moa_vpl VALUES ("MT9_26","070_9_26","MAT","9","26","26","'Bhɛ ‑nɛ ‑gblanɛ 'ɛ bweza 'ɛ gale ba, 'bhɛ ꞊zian 'yee‑ 'klɛɛn 'ɛ 'yi yrɛkpɛn‑ ꞊nɔɔ. ");
INSERT INTO moa_vpl VALUES ("MT9_27","070_9_27","MAT","9","27","27","'Bhɛ blaan, 'ke Zesu gele‑ yrɛ ‑bhɛɛke' do ꞊nɔɔ. ‑E ‑yaa 'bhɛ yrɛ 'ɛ ꞊nɔɔ bhe, 'ke ‑yrɛ 'wile‑ mi plɛ 'taawole 'sanle ‑a zi, 'bhɛɛ‑ 'ke 'mu 'a pe 'eglɔɔle dɔɔ: «Davidi 'nranɛ‑, 'o 'yrɛnkla 'e ma!» ");
INSERT INTO moa_vpl VALUES ("MT9_28","070_9_28","MAT","9","28","28","Zesu 'bhɔle‑ ‑a ba ‑lɛ ma, 'ke 'woo‑ ‑yrɛ 'wi mi plɛ ‑woo mabɛɛnle 'a ‑din, 'bhɛɛ‑ 'ke ‑yoo ‑lrɔkpale dɔɔ: «'Ka 'gbu 'kpee ma 'mi sɔ 'ka 'bheele ɛɛ?» 'Bhɛɛ‑ ‑o pe ‑a ni: «‑Aani' 'o Zan.» ");
INSERT INTO moa_vpl VALUES ("MT9_29","070_9_29","MAT","9","29","29","'Bhɛ klɛle 'tɛ, 'ke Zesu 'e gbɛ 'kpale ‑o ‑yrɛbhɛ' mu 'ɛ ta, 'bhɛɛ‑ 'ke ‑ya pele‑ ‑o ni dɔɔ: «Bhaa 'ka 'bhee‑ 'bhii‑ 'ka 'ka ꞊kpaa 'mi 'yi gɔnɛ‑ 'la gbɛɛn‑ bhe.» ");
INSERT INTO moa_vpl VALUES ("MT9_30","070_9_30","MAT","9","30","30","'Bhɛɛ‑ ‑o ‑yrɛbhɛ' mu 'ɛ 'liiploola. ‑Ayile, Zesu ‑o ‑lɛmazwan 'eglɔɔle 'ke ‑ya pe ‑o ni dɔɔ: «'Ka 'laa 'ka 'bheeza‑ 'ɛ 'yipelɛ mɛɛ 'kedo‑ 'kpɔ ni.» ");
INSERT INTO moa_vpl VALUES ("MT9_31","070_9_31","MAT","9","31","31","'Duŋ‑ ‑o 'pwɛle‑ blaan 'pɛɛlii‑, 'ke ‑wa 'tɔbhɔleya 'ɛ zɛnle‑ 'klɛɛn 'ɛ 'yi yrɛkpɛn‑ ꞊nɔɔ. ");
INSERT INTO moa_vpl VALUES ("MT9_32","070_9_32","MAT","9","32","32","‑O ‑yaa ge 'zi 'waati 'la ba, 'ke ‑o nule‑ mɛɛ do 'le Zesu ba. 'Bhɛ mɛɛ 'ɛ 'bhɛ 'laa ‑yaa sɔ ‑wele', ‑amasrɔyi 'bhobho 'yaa‑ 'bhɛ 'lɛ ta. ");
INSERT INTO moa_vpl VALUES ("MT9_33","070_9_33","MAT","9","33","33","'Bhɛ yrɛ do 'ɛ ꞊nɔɔ bhe, 'ke Zesu 'yee‑ 'bhobho lii 'ɛ ‑gbinle' ‑a zi, 'bhɛɛ‑ 'kee‑ ‑janwole 'sanle. ‑Ayile, ‑zamaa' 'ɛ 'kpeelɛnia ‑o ma, 'bhɛɛ‑ ‑o ‑yaa 'pe 'zi 'kaa: «'Waa 'bhɛ 'yansi ‑za yelɛ ‑lido' Izraɛli 'klɛɛn 'ɛ 'yi ‑gɛ!» ");
INSERT INTO moa_vpl VALUES ("MT9_34","070_9_34","MAT","9","34","34","'Duŋ‑ Farizi mu 'ɛ 'yaa‑ pe 'zi dɔɔ: «‑Setran' mu ‑kuŋlii 'gbu 'ɛ 'bhɛ ‑le 'zina mu ‑gbin 'seŋ 'na zii' ‑a ni!» ");
INSERT INTO moa_vpl VALUES ("MT9_35","070_9_35","MAT","9","35","35","Zesu 'yaa‑ ge ‑wa ‑gbɛnɛ 'pegee ‑wa 'nɛ mu 'ɛ 'kpɛn ta. ‑E ‑yaa mɛɛ mu daan ‑Waanbhaa' a ‑jan 'ɛ 'le Zuufu mu daanfɛ' mu 'ɛ ꞊la; 'bhɛɛ‑ ‑e ‑yaa ‑bhleŋgbeya ‑wa 'ɛ ma jan ‑nrale' 'ɛ 'wo zii', 'bhɛ 'pegee ‑e ‑yaa gadɛ mu 'ɛ 'kpɛn ‑glɔɔn 'pegee ‑sɔŋzan' mu 'ɛ 'bhee zii'. ");
INSERT INTO moa_vpl VALUES ("MT9_36","070_9_36","MAT","9","36","36","Zesu ‑zamaa' 'ɛ 'yele, 'ke mɛɛ mu 'ɛ 'yrɛnklale ‑a ma, ‑amasrɔyi ‑o 'trɛbhɔle ‑yaa, 'bhɛ 'pegee ‑o ‑gblɔzi' gale ‑yaa 'bhii‑ ‑bhlaa mu 'la ‑o gooba mi laa ‑o ta. ");
INSERT INTO moa_vpl VALUES ("MT9_37","070_9_37","MAT","9","37","37","'Bhɛ ya 'ɛ 'yi, 'ke ‑ya pele‑ ‑yaa' ‑klaŋlanɛ mu 'ɛ ni dɔɔ: «‑Waanbhaa' a ye 'ɛ ‑yoo 'bhii‑ ‑mlɔ gba ‑gbɛnɛ do 'la 'tranle‑ ‑o, 'bhɛɛ‑ 'duŋ‑ yewonɛ mu laa ‑o 'ebebele 'ke ‑wa kan, 'bhɛɛ‑ ‑wa wla zrɛ 'yi. ");
INSERT INTO moa_vpl VALUES ("MT9_38","070_9_38","MAT","9","38","38","'Bhɛla‑ ‑yile, ‑ka ‑sromabɔ gbazan 'ɛ ni, 'kooko‑ ‑e sɔ yewonɛ ‑bebe 'winbɔle ‑mlɔ 'ɛ 'kan yrɛ ꞊nɔɔ, 'bhɛɛ‑ ‑wa wla zrɛ 'yi.» ");
INSERT INTO moa_vpl VALUES ("MT10_1","070_10_1","MAT","10","1","1","'Bhɛ blaan, 'ke Zesu ‑yaa' ‑klaŋlanɛ vu ta plɛ 'ɛ 'siile, 'kee‑ 'zina mu ‑gbin 'seŋ 'nale‑ ‑o ni, 'bhɛ 'pegee ‑e mɛɛ mu ma ga mu 'ɛ 'kpɛn ‑glɔɔn, 'bhɛɛ‑ ‑sɔŋzan' mu 'ɛ 'kpɛn 'bhee 'seŋ ꞊naa ‑o ni. ");
INSERT INTO moa_vpl VALUES ("MT10_2","070_10_2","MAT","10","2","2","‑E ‑yaa' ‑klaŋlanɛ vu ta plɛ 'la ꞊kla ‑yaa ‑*winbɔwo mu 'le, 'mu 'tɔ ‑le ‑gɛ: Simɔ 'la ‑o 'bhɛ 'tɔkpaa‑ Piɛri, 'bhɛ 'pegee 'bhɛ nɛɛnɛ‑ Andre; 'bhɛɛ‑ Zebede gbe plɛ 'ɛ Zaki 'pegee 'bhɛ nɛɛnɛ‑ Zaan; ");
INSERT INTO moa_vpl VALUES ("MT10_3","070_10_3","MAT","10","3","3","Filipu 'pegee Batremi; Toma 'pegee 'nisrakun mi Matie; Alife gbe Zaki 'pegee Tade; ");
INSERT INTO moa_vpl VALUES ("MT10_4","070_10_4","MAT","10","4","4","Simɔ 'la 'yaa‑ 'bhɛ a 'klɛɛn ‑vavadɛ 'ke 'bhɛ kan pɛ 'kpɛn ta, 'bhɛ 'pegee Zudasi Isikariɔti 'la ‑dawli' ꞊kpaa Zesu gbɛ ta, 'bhɛɛ‑ ‑e 'bhɛ ꞊naa 'bhɛ 'sɔɔnnii mu ni boolazi. ");
INSERT INTO moa_vpl VALUES ("MT10_5","070_10_5","MAT","10","5","5","Zesu ‑yaa' ‑klaŋlanɛ vu ta plɛ 'ɛ 'winbwa‑, 'bhɛɛ‑ ‑yoo ‑liala dɔɔ: «'Ka 'laa gelɛ Zuufu kle mu ba, 'bhɛɛ‑ 'ka 'laa gelɛ Samari 'klɛɛn 'yi ‑wa mu 'ɛ ta. ");
INSERT INTO moa_vpl VALUES ("MT10_6","070_10_6","MAT","10","6","6","'Duŋ‑ ‑ka ge Izraɛli 'si mu ‑la ba 'elwale 'pe: 'Wole‑ 'bhii‑ ‑bhlaa mu 'la ꞊nia 'mu 'le. ");
INSERT INTO moa_vpl VALUES ("MT10_7","070_10_7","MAT","10","7","7","'Ke 'ka ‑o ge 'zi 'kaa‑ 'taa 'ɛ ta, ‑ka ge ‑a pelele mɛɛ mu 'ɛ ni dɔɔ: ‹Laanima ‑Bhleŋgbeya 'yaa‑ bhla 'ɛ ꞊bhwa ‑wa ‑din.› ");
INSERT INTO moa_vpl VALUES ("MT10_8","070_10_8","MAT","10","8","8","‑Ka gadɛ mu ‑bhee', 'bhɛɛ‑ ‑ka gbaa mu bwe gale ba; ‑ka ‑kpaandɛ' mu ma ‑kpaan 'ɛ go, 'bhɛɛ‑ ‑o 'flɛ mu 'ɛ bakan 'weŋ, 'bhɛ 'pegee ‑ka 'zina ‑gbin mɛɛ mu zi. 'Ka pɛ 'la 'srɔɔwoa‑ bhaama, ‑kaa na 'ezin‑ mɛɛ ‑bhɛɛke' mu ni bhaama. ");
INSERT INTO moa_vpl VALUES ("MT10_9","070_10_9","MAT","10","9","9","'Ka 'laa ‑gɔli' do 'kpɔ bɔlɛ 'ka 'wiiŋ‑. ");
INSERT INTO moa_vpl VALUES ("MT10_10","070_10_10","MAT","10","10","10","'Ka 'laa gbɛn ta ge 'pepe dɔ 'kpɔ 'silɛ‑, 'bhɛ 'pegee 'ka 'laa dunɛ‑ tabɔɔ dunɛ‑ 'silɛ‑; 'bhɛɛ‑ 'ka 'laa ‑sawla mu 'pegee 'ka 'taawo 'beni do 'kpɔ 'silɛ‑. 'Duŋ‑ yewo mi 'ɛ ‑e ‑yaa pɛ pɛle ‑srɔɔwo' ‑e yewo 'zi mɛɛ 'la zan mu ni 'mu ‑la 'kɔɔ.» ");
INSERT INTO moa_vpl VALUES ("MT10_11","070_10_11","MAT","10","11","11","«'Ke 'ka ꞊bhwa ‑wa 'oo ‑wa 'la ta: 'kee‑ ꞊kla ‑wa ‑gbɛnɛ do 'le oo, 'kee‑ ꞊kla ‑wa 'nɛ do 'le oo, ‑ka 'ka zeti‑ mi kplankplan do ‑glin 'elwale 'pe, 'bhɛɛ‑ 'ke 'ka 'bhɛ ꞊ya, ‑ka bo ‑a ba 'ke 'bhɛ ge 'tɛnlɛ‑ 'ka gele ma. ");
INSERT INTO moa_vpl VALUES ("MT10_12","070_10_12","MAT","10","12","12","'Ke 'ka ‑o 'wlale‑ 'fɛ do ‑la, ‑ka 'ka 'dumawo 'bhɛ 'fa ꞊la mu 'ɛ ni dɔɔ: ‹Bhaa 'ka bo 'edɔɔle.› ");
INSERT INTO moa_vpl VALUES ("MT10_13","070_10_13","MAT","10","13","13","'Ke 'bhɛ 'fɛ 'ɛ ꞊la mu 'ɛ ‑dwa ‑a ‑la 'ka bo ‑o ba, 'kaa‑ yilabla 'duma 'ɛ bo 'bhɛ 'fa mu 'ɛ ta; 'duŋ‑ 'ke waa dɔlɛ a ‑la 'ke 'ka bo ‑o ba, ‑ka 'kaa‑ 'duma 'ɛ go ‑o ta. ");
INSERT INTO moa_vpl VALUES ("MT10_14","070_10_14","MAT","10","14","14","'Ke 'fɛ do ‑la mu 'ɛ 'pegee ‑wa do ta mu 'ɛ, waa dɔlɛ ‑a ‑la 'ke ‑o 'ka 'cieya‑ si, 'bhɛɛ‑ 'ke waa dɔlɛ ‑a ‑la 'ke ‑woo 'trɔnkpa‑ 'ka 'wojan‑ mu 'ɛ ꞊la, 'ka 'pwɛ bhla zi 'bhɛ 'fɛ 'ɛ ꞊la, 'bhɛ 'pegee 'ka go bhla zi 'bhɛ ‑wa 'ɛ ta, ‑ka 'ka gaan mazɔn 'ke 'ka 'ka gaan ma bwegblɛn‑ 'ɛ go; 'bhɛ nu klɛlɛ 'bhɛ yrɛ 'ɛ ꞊nɔɔ mu 'ɛ ‑waa' ‑za 'yɔɔ‑ 'ɛ ma ‑tɔɔmasie 'le. ");
INSERT INTO moa_vpl VALUES ("MT10_15","070_10_15","MAT","10","15","15","'Mi pe 'ka ni wlan 'ɛ ni dɔɔ: ‑Waanbhaa' a 'kitikan yi ‑gbɛnɛ 'ɛ 'le, 'yee‑ ‑wa 'ɛ ta mu 'ɛ, ‑o ta ‑yrɛn 'ɛ 'yɔɔ‑ nu ‑yiyalɛ Sodɔmu mu 'pegee Gomɔɔ mu ta ‑yrɛn 'ɛ ni.» ");
INSERT INTO moa_vpl VALUES ("MT10_16","070_10_16","MAT","10","16","16","Zesu pe 'ezin‑ ‑o ni dɔɔ: «‑Ka 'ka 'trɔnbadɔ doo! 'Ŋ 'yoo‑ 'ka 'winlabɔ 'zi 'taa ta ‑gɛ bhe, 'ka nu klɛlɛ 'bhii‑ ‑bhlaa mu klɛ srɔpɛ mu pleŋ‑ gɔnɛ‑ 'la gbɛɛn‑ 'bhɛɛ‑ ‑gbɛɛn. 'Bhɛ ya 'ɛ 'yi, ‑ka 'ka 'yrɛkpa 'ka 'gbu ba 'elrele 'bhii‑ mlɛ mu gbɛɛn‑, 'bhɛɛ‑ 'ka 'yi klɛ 'edɔɔle 'bhii‑ ‑bhooladɔ maannɛ‑ mu gbɛɛn‑. ");
INSERT INTO moa_vpl VALUES ("MT10_17","070_10_17","MAT","10","17","17","‑Ka 'ka 'yrɛkpa 'ka 'gbu ba mɛɛ mu 'ɛ ma, ‑amasrɔyi mɛɛ mu nu gelɛ 'ka 'le ‑klu ta, 'bhɛɛ‑ ‑o nu 'ka tafɛlɛ 'ke gbaŋbhlɛ mu 'le ‑waa' daanfɛ' mu 'ɛ ꞊la. ");
INSERT INTO moa_vpl VALUES ("MT10_18","070_10_18","MAT","10","18","18","‑O nu gelɛ 'ka 'le ‑janmatii mu 'pegee ‑bhleŋgbe mu ba 'mi 'tɔ 'ɛ ‑zayi', 'duŋ‑ 'ka nu klɛlɛ 'ŋ 'srɛ mu 'le 'bhɛ ‑bhleŋgbe mu 'ɛ 'pegee 'drunyan 'yi mu 'ɛ 'yrɛ ꞊la. ");
INSERT INTO moa_vpl VALUES ("MT10_19","070_10_19","MAT","10","19","19","'Ke ‑o ‑ja 'ka 'le ‑klu ta, 'ka nu ‑jan yɛkɛ‑ 'la 'wolɛ‑, 'bhɛ 'pegee 'ka nu ‑a wolɛ gɔnɛ‑ 'la gbɛɛn‑, 'ka 'laa 'bhɛ do 'kpɔ yiɛnkanlɛ. 'Ka nu ‑jan mu 'la 'wolɛ‑ ‑o ‑yrɛ ma, ‑Waanbhaa' nu 'bhɛ 'kpalɛ‑ 'ka 'lii 'bhɛ yrɛ do 'kpɔ 'ɛ ꞊nɔɔ bhe. ");
INSERT INTO moa_vpl VALUES ("MT10_20","070_10_20","MAT","10","20","20","'Bhɛ ‑jan mu 'ɛ 'mu 'laa nu dalɛ 'ka mu 'gbu 'kpee, 'duŋ‑ 'ka Dɛ ‑Waanbhaa' Lii 'ɛ 'bhɛ nu 'ka 'wojan‑ 'ɛ 'kpalɛ‑ 'ka 'lii.» ");
INSERT INTO moa_vpl VALUES ("MT10_21","070_10_21","MAT","10","21","21","Nɛɛnɛ‑ ma do mu nu ‑dawli' 'kpalɛ‑ 'eke‑ gbɛ ta, 'bhɛɛ‑ ‑woo 'eke‑ na mɛɛ mu ni 'bhɛɛ‑ ‑woo dɛ. 'Bhɛɛ‑ ‑nɛ dɛ mu nu ‑a klɛlɛ ‑o 'gbu 'kpee yi mu ni 'bhɛɛ‑ gbɛɛn‑ 'ezin‑. ‑Nɛ mu nu ‑wlɛnlɛ' ‑o yapɛ mu 'ɛ ma 'bhɛɛ‑ ‑o 'mu dɛ. ");
INSERT INTO moa_vpl VALUES ("MT10_22","070_10_22","MAT","10","22","22","'Ka vɛn nu 'silɛ‑ mɔkpɛn' yin ‑lii 'mi 'tɔ 'ɛ ‑zayi'; 'duŋ‑ 'ke mɛɛ 'la zan 'bhɛ ‑yrɛn mu 'ɛ 'yikwan꞊ 'ke 'bhɛ ge 'tɛnlɛ‑ ‑a ‑lɛyanle ma, 'bhɛ zan nu golɛ ‑za 'yi. ");
INSERT INTO moa_vpl VALUES ("MT10_23","070_10_23","MAT","10","23","23","'Ke mɛɛ mu ‑yrɛnkpaa 'ka ta ‑wa do ta, ‑ka blasan‑, 'bhɛɛ‑ ‑ka ge ‑wa 'bhɛɛke do ta. 'Mi pe 'ka ni wlan 'ɛ ni dɔɔ: 'Sani 'ka nu yanlɛ 'kaanlele Izraɛli ‑wa mu 'ɛ 'kpɛn ta, 'ke Bhaaplɛŋ Gbe 'ɛ ꞊nwa gban. ");
INSERT INTO moa_vpl VALUES ("MT10_24","070_10_24","MAT","10","24","24","«‑Laklu 'nɛ do gblaan 'yi 'laa ya ‑a daan mi 'ɛ ni, 'bhɛɛ‑ yewonɛ do gblaan ‑yi 'laa ya ‑a ‑kuŋlii 'ɛ ni. ");
INSERT INTO moa_vpl VALUES ("MT10_25","070_10_25","MAT","10","25","25","'Ke ‑za 'la ꞊tian ‑laklunɛ daan mi 'ɛ ma, 'bhɛɛ‑ 'yansi za ‑le nu 'tɛnlɛ‑ ‑laklunɛ 'ɛ ma 'ezin‑. 'Bhɛ klɛgbɛya do 'ɛ 'yi, ‑za 'la ꞊tian 'yee‑ ‑kuŋlii 'ɛ ma, 'bhɛɛ‑ 'yansi za ‑le nu 'tɛnlɛ‑ ‑yaa' yewonɛ 'ɛ ma 'ezin‑. 'Ke ‑o 'fɛzan‑ 'ɛ 'gbu 'tɔkpaa‑ dɔɔ Bɛɛzebuli ('bhɛ 'yi ‑le ‑Setran'), waa nu 'sɔlɛ‑ 'tɔ 'yɔɔ‑ ‑glɔɔn 'ɛ ‑dela 'kpale 'fɛ 'ɛ ꞊la mu 'ɛ ma 'ezin‑ ɛɛ?» ");
INSERT INTO moa_vpl VALUES ("MT10_26","070_10_26","MAT","10","26","26","Zesu pe ‑o ni 'ezin‑ dɔɔ: «'Ka 'laa ‑gblaanlɛ' bhaaplɛŋ mu ‑lɛɛ. ‑Amasrɔyi 'ke 'bhɛ 'waati 'ɛ ꞊bhwa, pɛ 'oo pɛ 'la magaanle ‑o, 'bhɛ 'kpɛn ta nu 'pwɛlɛ‑, 'bhɛɛ‑ mɔkpɛn' nu ‑zadɔlɛ gaanyiza 'tɔle‑ gaanyiza 'bhɛ 'yi. ");
INSERT INTO moa_vpl VALUES ("MT10_27","070_10_27","MAT","10","27","27","'Ŋ 'yoo‑ ‑jan 'la 'wo zii' 'ka ni ‑gɛ ‑gblo 'yi, ‑ka ge 'bhɛ 'wo ‑yrekpaa' kpataakpa; 'bhɛɛ‑ 'ŋ 'yoo‑ swɛŋswɛŋ 'yi ‑jan 'la 'wo zii' 'ka 'trɔn 'yi ‑gɛ, ‑ka ge 'bhɛ ‑toorodɔ 'eglɔɔle 'pɛɛlii‑ mɔkpɛn' 'yrɛ ma. ");
INSERT INTO moa_vpl VALUES ("MT10_28","070_10_28","MAT","10","28","28","Mɛɛ 'la zan mu sɔ mɛɛ dɛle‑, 'ke waa sɔ mɛɛ lii 'ɛ dɛle‑, 'ka 'laa ‑gblaanlɛ' 'mu 'lɛɛ. 'Duŋ‑ ‑Waanbhaa' 'la sɔ mɛɛ niigole ‑a ‑yi, 'bhɛɛ‑ 'bhɛ 'seŋ ‑o ‑a ni 'kee‑ 'ka lii 'ɛ bɔ ‑jranama 'tɛ 'ɛ 'yi, ‑ka ‑gblaan' 'bhɛɛ‑ 'lɛɛ‑. ");
INSERT INTO moa_vpl VALUES ("MT10_29","070_10_29","MAT","10","29","29","Waa ‑o 'vonɛ plɛ gɔn zi ‑gɔli' 'taŋbha do ma ɛɛ? 'Duŋ‑ ‑o do 'kpɔ 'laa sɔ ‑baale' 'trɛ ma, 'ke 'bhɛ 'laa klɛlɛ 'ka Dɛ ‑Waanbhaa' zru maza 'le. ");
INSERT INTO moa_vpl VALUES ("MT10_30","070_10_30","MAT","10","30","30","'Ali‑ 'ka mu, ‑Waanbhaa' 'ka 'winbhɛ‑ mu 'ɛ 'kpɛn 'liidɔ‑. ");
INSERT INTO moa_vpl VALUES ("MT10_31","070_10_31","MAT","10","31","31","'Bhɛ ya 'ɛ 'yi, 'ka 'laa ‑gblaanlɛ'. 'Ka mu mabhaabhɔ 'vonɛ 'saa mu ta.» ");
INSERT INTO moa_vpl VALUES ("MT10_32","070_10_32","MAT","10","32","32","Zesu pe ‑o ni 'ezin‑ dɔɔ: «'Ke mɛɛ 'la zan 'a ꞊pia 'kaa 'bhɛ ‑o 'an pɛ mɛɛ 'le mɔkpɛn' 'yrɛ ma kpataakpa, 'mi nu 'ezin‑ 'bhɛ zan 'ɛ dɔlɛ 'an pɛ mɛɛ 'le 'ŋ Dɛ 'la ‑yoo laanima 'bhɛ 'yrɛ ꞊la. ");
INSERT INTO moa_vpl VALUES ("MT10_33","070_10_33","MAT","10","33","33","'Duŋ‑ 'ke mɛɛ 'la zan 'e ‑baŋgwa 'mi 'yi mɔkpɛn' 'yrɛ ma kpataakpa, 'mi nu 'ezin‑ 'ŋ ‑baŋgolɛ 'bhɛ zan 'ɛ 'yi 'ŋ Dɛ 'la ‑yoo laanima 'bhɛ ‑yrɛ ꞊la.» ");
INSERT INTO moa_vpl VALUES ("MT10_34","070_10_34","MAT","10","34","34","Zesu pe ‑o ni 'ezin‑ dɔɔ: «Yaa klɛlɛ 'ka ni 'bhii‑ 'ŋ ꞊nwa boleya ‑dɔɔ 'nalɛ‑ 'ka ni 'trɛ 'lɛɛ‑ ta ‑gɛ. 'Naa 'nulɛ‑ boleya ‑dɔɔ 'nulɛ‑ 'ka ni, 'duŋ‑ 'ŋ ꞊nwa 'ka 'pleŋ‑ 'siɛyrɛ‑ ‑la nɔɔ‑. ");
INSERT INTO moa_vpl VALUES ("MT10_35","070_10_35","MAT","10","35","35","'Ŋ ꞊nwa mɛɛ do 'pegee ‑a dɛ pleŋ‑ 'siɛyrɛ‑ ‑la nɔɔ‑, 'bhɛ 'pegee 'ŋ ꞊nwa ‑nɛ ‑gblanɛ do 'pegee ‑a nɛɛ pleŋ‑ 'siɛlɛ‑; 'bhɛɛ‑ 'ezin‑ 'ŋ ꞊nwa 'bhɛɛ‑ 'yansi za klɛlɛ le drɛɛ do 'pegee 'bhɛ 'naale‑ pleŋ‑ 'ezin‑. ");
INSERT INTO moa_vpl VALUES ("MT10_36","070_10_36","MAT","10","36","36","Mɛɛ do 'sɔɔnnii mu nu klɛlɛ ‑a 'gbu ba 'fa ‑la mu ‑la ‑le.» ");
INSERT INTO moa_vpl VALUES ("MT10_37","070_10_37","MAT","10","37","37","«'Ke mɛɛ 'la zan dɛ 'pegee ‑a nɛɛ ‑za sɔ a ni 'ke 'bhɛ kan 'mi ta, 'mi a pɛ laa 'bhɛ zan 'ɛ 'le. 'Bhɛɛ‑ 'ke mɛɛ 'la zan gbe 'pegee 'bhɛ 'lu ‑za sɔ a ni 'ke 'bhɛ kan 'mi ta, 'mi a pɛ laa 'bhɛ zan 'ɛ 'le 'ezin‑. ");
INSERT INTO moa_vpl VALUES ("MT10_38","070_10_38","MAT","10","38","38","'Ke mɛɛ 'la zan ‑o ‑a zi 'bhii‑ ‑e klɛ 'ŋ zi mi 'le, ‑ya niigo ‑a 'gbu 'si 'ɛ 'yi 'elwale 'pe, 'bhɛɛ‑ ‑e dɔ ‑yrɛnbhlele ꞊la 'mi ‑zayi', 'ke 'bhɛ ꞊kla, 'bhɛɛ‑ ‑e nu dɔlɛ 'mi zi 'tɛ. ");
INSERT INTO moa_vpl VALUES ("MT10_39","070_10_39","MAT","10","39","39","'Ke mɛɛ 'la zan ‑o ‑a zi 'bhii‑ ‑ya 'gbu ‑si 'ɛ go ‑za 'yi, ‑e nu bloolɛ ‑a ‑yi; 'duŋ‑ 'ke mɛɛ 'la zan 'e 'niigwa‑ ‑a 'gbu ꞊si 'ɛ 'yi 'mi ‑zayi', 'bhɛ zan nu 'bhɛ 'srɔɔwo gbɛ drɛɛwolɛ.» ");
INSERT INTO moa_vpl VALUES ("MT10_40","070_10_40","MAT","10","40","40","Zesu pe ‑o ni 'ezin‑ dɔɔ: «'Ke mɛɛ 'la zan 'ka ꞊kwan 'elrele, 'bhɛ zan 'ɛ, 'bhɛ 'mi ‑la ꞊kwan 'elrele bhe; 'bhɛɛ‑ 'bhɛ zan 'ɛ 'bhɛ 'mi 'winbɔ mi 'ɛ 'bhɛɛ‑ ꞊kwan 'elrele bhe 'ezin‑. ");
INSERT INTO moa_vpl VALUES ("MT10_41","070_10_41","MAT","10","41","41","'Ke mɛɛ 'la zan ‑Waanbhaa' ‑lɛla' janwo mi do ꞊kwan 'elrele ‑yaa' ‑Waanbhaa' ‑lɛla' janwoleya 'ɛ ma, ‑Waanbhaa' nu ‑trɔn 'la 'nalɛ‑ ‑a ‑lɛla' janwo mu 'ɛ ni, ‑e nu 'bhɛɛ‑ 'yansi ‑trɔn 'nalɛ‑ 'bhɛ zan 'ɛ ni 'ezin‑. 'Bhɛɛ‑ 'ke mɛɛ 'la zan mɛɛ ‑lɛdɔɔle do ꞊kwan 'elrele ‑yaa' ‑lɛdɔɔleya 'ɛ ma ‑Waanbhaa' ‑yrɛ 'yi, ‑Waanbhaa' nu ‑trɔn 'la 'nalɛ‑ mɛɛ ‑lɛdɔɔle mu 'ɛ ni, ‑e nu 'bhɛɛ‑ 'yansi ‑trɔn 'nalɛ‑ 'bhɛ zan 'ɛ ni. ");
INSERT INTO moa_vpl VALUES ("MT10_42","070_10_42","MAT","10","42","42","'Mi pe 'ka ni wlan 'ɛ ni dɔɔ: 'Ke mɛɛ 'la zan ‑yi ‑dɔɔ 'paayan꞊ do ‑naa 'an ‑klaŋlanɛ mu 'lɛɛ‑ ‑o ba mi 'fiɛntrɔnnɛ 'gbu 'ɛ ni, ‑yaa' ‑klaŋlanɛya 'ɛ ma, 'bhɛ zan nu 'bhɛ ma ‑trɔn 'srɔɔwolɛ.» ");
INSERT INTO moa_vpl VALUES ("MT11_1","070_11_1","MAT","11","1","1","Zesu 'yanle‑ ‑yaa' ‑klaŋlanɛ vu ta plɛ 'ɛ daanlele 'bhɛ ‑jan mu 'ɛ 'le, 'kee‑ gele‑ ‑Waanbhaa' a ‑jan 'ɛ 'wolɛ‑ 'bhɛ ꞊nɔɔ ‑wa mu 'ɛ ta. ");
INSERT INTO moa_vpl VALUES ("MT11_2","070_11_2","MAT","11","2","2","'Duŋ‑ Mɛɛ Wiiŋfɛ' Mi Zaan ‑yaa ‑kaso 'yi, 'bhɛɛ‑ ‑e Zesu Krisi klɛza mu 'ɛ 'male‑; 'kee‑ ‑yaa' ‑klaŋlanɛ mu 'ɛ 'ke mu 'winbɔle Zesu ba ");
INSERT INTO moa_vpl VALUES ("MT11_3","070_11_3","MAT","11","3","3","dɔɔ 'mu ge ‑a ‑lrɔkpa' dɔɔ: «'Bhi ‑le 'ke 'o 'yri 'yaa‑ mɛɛ 'la zan nule ta 'bhɛ 'le, taa‑ 'woo‑ 'yrikpa mɛɛ ‑bhɛɛke' do ta 'ezin‑ ɛɛ?» ");
INSERT INTO moa_vpl VALUES ("MT11_4","070_11_4","MAT","11","4","4","'Bhɛ klɛle 'tɛ, 'ke Zesu 'a 'zikpale ‑o ni dɔɔ: «'Ka ‑yrɛ ‑o ‑za mu 'la ma, 'bhɛ 'pegee 'ka 'trɔn ‑o ‑jan mu 'la 'yi, ‑ka ge 'mu 'yigɔɔn‑ Zaan ni, ");
INSERT INTO moa_vpl VALUES ("MT11_5","070_11_5","MAT","11","5","5","‑ka 'ka 'yrɛkpa ‑gɛ doo: ‑Yrɛ 'wi mu ‑o yrɛ ma ye 'zi, gaan 'siɛle‑ mu ‑o 'taawo zii', ‑kpaan ‑o go 'zi ‑kpaandɛ' mu ma, 'trɔn 'wile‑ mu 'trɔn 'lii mu ‑o 'ploo zii', 'bhɛɛ‑ ‑o ‑jan ma zii'. 'Bhɛɛ‑ gbaa mu ‑o bwe 'zi gale ba, 'bhɛ 'pegee ‑o ‑Jan 'Nrale‑ 'ɛ 'wo zii' ‑yrɛnbhɔdɛ mu ni. ");
INSERT INTO moa_vpl VALUES ("MT11_6","070_11_6","MAT","11","6","6","'Ke 'naa klɛlɛ mɛɛ 'la zan baa‑ pɛ 'le ‑za 'yɔɔ‑ 'yi, 'bhɛ zan a pɛ ‑yinra'.» ");
INSERT INTO moa_vpl VALUES ("MT11_7","070_11_7","MAT","11","7","7","Mɛɛ Wiiŋfɛ' Mi Zaan a ‑klaŋlanɛ mu 'ɛ gele blaan, 'ke Zesu ‑janwole 'sanle Zaan ba zayi' ‑zamaa' mu 'ɛ ni dɔɔ: «'Ka ‑ja ‑mɛla ‑glinlɛ' ‑kpe 'ɛ ta ɛɛ? 'Ka ‑ja to diiŋ do ‑la ‑glinlɛ' 'ke ‑ploo ‑o 'bhɛ bɛɛn 'zi ɛɛ? 'Yooye‑, 'ka 'laa gelɛ 'bhɛ ‑glinle' ma. ");
INSERT INTO moa_vpl VALUES ("MT11_8","070_11_8","MAT","11","8","8","'Bhɛɛ‑ 'ka ‑ja ‑mɛla ‑glinlɛ' ɛɛ? 'Ka ‑ja mɛɛ ‑baale' ‑lrele' do ‑la ‑glinlɛ' ɛɛ? 'ŊŊ‑! ‑Amasrɔyi mɛɛ 'la zan mu 'mu baa 'elrele ‑o 'mu ye ‑bhleŋgbe mu ‑la ba 'fa ꞊la. ");
INSERT INTO moa_vpl VALUES ("MT11_9","070_11_9","MAT","11","9","9","'Bhɛɛ‑ ka ‑ja ‑mɛla ‑glinlɛ' ɛɛ? 'Ka ‑ja ‑Waanbhaa' a ‑lɛla' janwo mi do ‑la ‑glinlɛ' ɛɛ? ‑Aani', wlan 'ɛ ni, ‑yoo 'ke ‑Waanbhaa' ‑lɛla' janwo mi do 'le kpataakpa. 'Bhɛɛ‑ drɔɔn' ‑a gblaan ‑yiya' ‑Waanbhaa' ‑lɛla' janwo mi do ni. ");
INSERT INTO moa_vpl VALUES ("MT11_10","070_11_10","MAT","11","10","10","‑Amasrɔyi ‑a yɔɔndɛle ‑o 'yela‑ ba zayi' ‑Waanbhaa' a 'Sɛwɛ 'ɛ 'yi dɔɔ: ‹'E 'yrɛkpa doo! 'Mi nu 'an ‑janwo' mi 'ɛ 'winbɔlɛ 'e 'lɛɛ, 'bhɛ nu 'e 'lɛɛ zi 'ɛ 'lɛmagaanlɛ.›» ");
INSERT INTO moa_vpl VALUES ("MT11_11","070_11_11","MAT","11","11","11","«'Mi pe 'ka ni wlan 'ɛ ni dɔɔ: ‑O bhaaplɛŋ mu 'la ꞊yaa ‑le mu ta 'mu ba, 'mu do 'kpɔ gblaan 'yi 'laa ya Mɛɛ Wiiŋfɛ' Mi Zaan ni 'Duŋ‑ laanima ‑bhleŋgbeya ‑wa 'ɛ ta mɛɛ 'fiɛntrɔnnɛ 'ɛ 'bhɛ gblaan 'yiya‑ 'yee‑ Zaan ni. ");
INSERT INTO moa_vpl VALUES ("MT11_12","070_11_12","MAT","11","12","12","Mɛɛ Wiiŋfɛ' Mi Zaan ‑Jan 'Nrale‑ 'ɛ 'wole‑ zisaan‑ 'kee‑ san 'bhɛ 'waati 'ɛ ma, 'ke 'bhɛ nu 'tɛnlɛ‑ ‑zɔn ma, laanima ‑bhleŋgbeya 'ɛ ꞊kla 'ke faŋgan‑ maza ‑la ‑le. 'Bhɛɛ‑ mɛɛ 'la zan mu dɔ 'eglɔɔle 'yee‑ ‑bhleŋgbeya 'ɛ sɔ klɛle‑ 'mu ‑le a pɛ 'le. ");
INSERT INTO moa_vpl VALUES ("MT11_13","070_11_13","MAT","11","13","13","'Bhɛ ya 'ɛ 'yi, ‑Waanbhaa' ‑lɛla' janwo mu 'ɛ 'pegee Moizi a 'toŋ mu 'ɛ ‑o ‑Waanbhaa' a ‑bhleŋgbeya yaaza 'ɛ ꞊woa, 'ke 'bhɛ nu 'tɛnlɛ‑ 'yee‑ Mɛɛ Wiiŋfɛ' Mi Zaan a pɛ 'waati 'ɛ ma. ");
INSERT INTO moa_vpl VALUES ("MT11_14","070_11_14","MAT","11","14","14","'Bhɛɛ‑ 'ke 'ka ‑o ‑a zi 'bhii‑ 'kaa 'yima, ‑kaa 'yaango‑ dɔɔ Eli 'la ‑Waanbhaa' ‑lɛla' janwo mu 'ɛ ‑wa nuza 'ɛ ꞊pia bi 'elwale ‑sɔ 'yee‑ Zaan ‑le 'bhɛ 'le. ");
INSERT INTO moa_vpl VALUES ("MT11_15","070_11_15","MAT","11","15","15","'Ke ‑a ‑yima' 'trɔn ‑o mɛɛ 'la zan ŋgblo ma, ‑ya 'yima!» ");
INSERT INTO moa_vpl VALUES ("MT11_16","070_11_16","MAT","11","16","16","«'Ŋ sɔ ‑zɔn bhaaplɛŋ mu 'ɛ danle‑ ‑mɛla ma ɛɛ? ‑Woo 'bhii‑ ‑nɛ 'ke mu 'la 'yaale‑ ‑o ‑zabla' ‑kpan mu 'ɛ ta; 'bhɛɛ‑ ‑woo ‑nɛ 'bhɛɛke mu 'sii zii' dɔɔ: ");
INSERT INTO moa_vpl VALUES ("MT11_17","070_11_17","MAT","11","17","17","‹'O 'srokpaa‑ 'ka ni ‑gofɛn' 'yi, 'bhɛɛ‑ 'ka 'laa 'srotanlɛ! 'O bheela wisi' 'sro mu ꞊kpaa, 'bhɛɛ‑ 'ka 'laa wisilɛ!›» ");
INSERT INTO moa_vpl VALUES ("MT11_18","070_11_18","MAT","11","18","18","«Zaan ꞊nwa 'ka ba, 'bhɛɛ‑ yaa ‑yaa pɛbhle, 'bhɛ 'pegee yaa ‑yaa ‑yi mi. 'Bhɛɛ‑ mɛɛ mu 'ɛ ‑wa ꞊pia a ma dɔɔ: ‹'Zina do ‑o ‑a zi.› ");
INSERT INTO moa_vpl VALUES ("MT11_19","070_11_19","MAT","11","19","19","'Bhɛ blaan, Bhaaplɛŋ Gbe 'ɛ 'bhɛ ꞊nwa, 'bhɛɛ‑ 'bhɛ 'yaa‑ pɛbhle, 'bhɛɛ‑ 'bhɛ 'yaa‑ ‑yi mi. 'Bhɛɛ‑ mɛɛ mu 'ɛ pe 'bhɛ ma dɔɔ: ‹Mɛɛ 'lɛɛ‑ bole ‑o pɛbhlele 'pegee ‑wɛɛn 'mile‑ ‑la ma; 'bhɛɛ‑ ‑e bhɛgwlɛnya ‑kpaa 'nisrakun mu 'pegee mɛɛ 'joo 'yɔɔ‑ ‑bhɛɛke' mu ‑la ma!› 'Duŋ‑ ‑o ‑Waanbhaa' a ‑zadɔleya 'ɛ dɔ bhaaplɛŋ klɛza mu ‑la ma.» ");
INSERT INTO moa_vpl VALUES ("MT11_20","070_11_20","MAT","11","20","20","'Bhɛ blaan, Zesu 'sɔle‑ maza ‑bebe ꞊kla ‑wa mu 'la ta, ‑e ‑lale' ‑saan 'bhɛ ‑wa mu 'ɛ ta mu 'ɛ ta. ‑Amasrɔyi 'bhɛ ‑wa mu 'ɛ ta mu 'ɛ waa ‑o zru mu 'ɛ 'niinalɛ ‑Waanbhaa' ba ‑titi 'ke ‑woo 'taawogbɛya 'ɛ mabɔɔ. ");
INSERT INTO moa_vpl VALUES ("MT11_21","070_11_21","MAT","11","21","21","Zesu pe 'ezin‑ dɔɔ: «'Ka ta ‑yrɛn! Korazɛn ‑wa ‑la mu 'pegee Bɛtisaida ‑wa ‑la mu! ‑Amasrɔyi 'ŋ 'sɔle‑ maza mu 'la ꞊kla 'ka ba, 'kee‑ 'kpa bi 'ŋ 'bhɛ 'yansi 'sɔle‑ maza mu 'ɛ ꞊kla bi Tiri 'pegee Sidɔn ‑wa mu 'ɛ ta, 'ke ‑zɔn 'laa 'bhɛ 'le 'ke 'bhɛ ‑wa mu 'ɛ ta mu 'ɛ ‑o ‑bɔtɔ kplɛ mu ꞊klaa gban ‑o ta, 'bhɛɛ‑ 'ke ‑o ‑pɛɛ ‑kaan gban ‑o ma, 'kooko‑ ‑wa zrɔn 'bhii‑ ‑o ‑ploola waa ‑za 'yɔɔ‑ mu 'ɛ ma, 'bhɛɛ‑ ‑woo zru mu 'ɛ 'niinaa‑ ‑Waanbhaa' ba, 'bhɛɛ‑ ‑woo 'taawogbɛya 'ɛ mabɔɔla. ");
INSERT INTO moa_vpl VALUES ("MT11_22","070_11_22","MAT","11","22","22","'Bhɛla‑ ‑yile, 'mi pe 'ka ni dɔɔ: ‑Waanbhaa' a 'kitikan yi 'ɛ 'le, Tiri 'pegee Sidɔn ‑wa mu 'ɛ ta mu 'ɛ ‑o ta ‑yrɛn 'ɛ yaa nu klɛlɛ 'eyɔɔle 'bhii‑ 'kaa‑ pɛ 'ɛ gbɛɛn‑. ");
INSERT INTO moa_vpl VALUES ("MT11_23","070_11_23","MAT","11","23","23","'Bhɛɛ‑ 'ka mu Kapɛnɔmu ‑wa la mu, ‑yoo 'ka ni 'bhii‑ 'ka nu 'sɔlɛ‑ 'ka ‑wlɛnle', 'bhɛɛ‑ 'ka ge 'tɛnlɛ‑ laflɛ' ma ɛɛ? ‑Waanbhaa' nu 'ka mazinalɛ, 'bhɛɛ‑ 'ka nu gelɛ ‑jranama 'tɛ 'ɛ 'yi. ‑Amasrɔyi 'ŋ 'sɔle‑ maza mu 'la ꞊kla 'ka ba, 'kee‑ 'kpa bi 'ŋ 'bhɛ 'yansi 'sɔle‑ maza klɛ Sodɔmu ‑wa 'ɛ ta, 'bhɛ ‑wa 'ɛ 'yaa‑ nu bolɛ ye 'kee‑ nu 'tɛnlɛ‑ ‑zɔn ma. ");
INSERT INTO moa_vpl VALUES ("MT11_24","070_11_24","MAT","11","24","24","'Bhɛla‑ ‑yile, 'mi pe 'ka ni dɔɔ: ‑Waanbhaa' a 'kitikan yi 'ɛ 'le, 'ka ta ‑yrɛn 'ɛ 'yi nu yalɛ Sodɔmu ‑wa ‑la mu 'ɛ ta ‑yrɛn 'ɛ 'bhɛ ni.» ");
INSERT INTO moa_vpl VALUES ("MT11_25","070_11_25","MAT","11","25","25","'Bhɛ 'waati 'ɛ ba, 'ke Zesu 'a 'seriwole 'sanle, 'bhɛɛ‑ ‑e pe dɔɔ: «'E! 'Ŋ Dɛ, 'trɛ 'pegee laflɛ' Zan, 'e wlan 'ɛ ‑gaanna ‑zadɔ' mu 'pegee mɛɛ yikanle mu ma, 'bhɛɛ‑ 'ya zrɔnlawoa ‑nɛ 'fiɛntrɔnnɛ mu ni, 'mi 'e 'pubɔ‑ 'bhɛ ma. ");
INSERT INTO moa_vpl VALUES ("MT11_26","070_11_26","MAT","11","26","26","Wlan ‑le 'bhɛ 'le, 'Ŋ Dɛ ‑Waanbhaa', ‑e ‑swa 'e zru ni 'ke 'ya klɛ 'bhɛɛ‑ gbɛɛn‑.» ");
INSERT INTO moa_vpl VALUES ("MT11_27","070_11_27","MAT","11","27","27","«'Ŋ Dɛ ‑Waanbhaa ‑za 'kpɛn gbɛkpaa‑ 'ŋ 'kɔɔ. Mɛɛ 'kedo‑ 'kpɔ 'laa Bhaaplɛŋ Gbe 'ɛ dɔ, 'ke yaa 'e go ‑a Dɛ do ‑kplɛn ba. 'Bhɛɛ‑ mɛɛ 'kedo‑ 'kpɔ 'laa ‑nɛ Dɛ 'ɛ dɔ, 'ke yaa 'e go ‑a Gbe 'pegee ‑a Gbe 'ɛ ‑a Dɛ ‑zrɔnna mɛɛ 'la zan mu ni 'mu ‑la ba.» ");
INSERT INTO moa_vpl VALUES ("MT11_28","070_11_28","MAT","11","28","28","«‑Ka nu 'mi ba, 'ka mu 'la 'kpɛn 'trɛbhwa꞊ 'kwe kpiŋle mu 'silele, 'bhɛɛ‑ 'mi nu ‑yitrɛle nalɛ 'ka ni. ");
INSERT INTO moa_vpl VALUES ("MT11_29","070_11_29","MAT","11","29","29","‑Ka nu 'mi a pɛ 'kwe 'ɛ 'si, 'bhɛɛ‑ ‑kaa 'to 'ŋ 'ka daan doo, ‑amasrɔyi 'ŋ 'yi ‑o 'edɔɔle, 'bhɛɛ‑ 'mi 'ŋ 'gbu mazinaa, 'bhɛ 'yi, 'ka nu ‑yitrɛle kplankplan ‑srɔɔwolɛ 'mi ba. ");
INSERT INTO moa_vpl VALUES ("MT11_30","070_11_30","MAT","11","30","30","'Wlan 'ɛ ni, 'an pɛ ye 'ɛ yaa la, 'bhɛɛ‑ 'an pɛ 'kwe 'ɛ kpiŋ laa ‑o.» ");
INSERT INTO moa_vpl VALUES ("MT12_1","070_12_1","MAT","12","1","1","'Bhɛ blaan, ‑yitrɛ' yi do ma, Zesu 'pegee ‑yaa' ‑klaŋlanɛ mu 'ɛ 'yaa‑ 'kan zii' gba do 'yi. 'Bhɛɛ‑ gbɔn ‑yaa ‑yaa' ‑klaŋlanɛ mu 'ɛ dɛ 'zi; ‑ayile 'ke ‑o pɛbhaa 'ke mu 'ɛ 'kanle‑ 'sanle 'bhɛɛ‑ 'ke ‑o 'mu bhle. ");
INSERT INTO moa_vpl VALUES ("MT12_2","070_12_2","MAT","12","2","2","'Bhɛ klɛle 'tɛ, Farizi mu 'ɛ ‑woo yele 'bhɛ pɛbhaa mu 'ɛ 'kan yrɛ ꞊nɔɔ, 'ke ‑wa pele‑ Zesu ni dɔɔ: «'E 'yrɛkpa 'yaa‑ ‑klaŋlanɛ mu 'ɛ ta doo, ‑kɔɔa' a 'toŋ mu 'ɛ ta waa ‑za 'la klɛ ‑yitrɛ' yi ma, 'woo‑ mu ‑o 'bhɛɛ‑ klɛ 'zi!» ");
INSERT INTO moa_vpl VALUES ("MT12_3","070_12_3","MAT","12","3","3","'Bhɛ 'yi 'tɛ, 'ke Zesu ‑o ‑lrɔkpale dɔɔ: «Yi do ta, gbɔn ‑bhleŋgbe Davidi 'pegee ‑a zi mu 'ɛ ꞊dia, 'bhɛɛ‑ pɛle dɔ 'kpɔ 'laa ‑yaa ‑o 'kɔɔ. ‑E ‑za 'la ꞊kla 'ka 'laa 'bhɛ tapelɛ ‑lido' ɛɛ? ");
INSERT INTO moa_vpl VALUES ("MT12_4","070_12_4","MAT","12","4","4","'Ŋ bhe, ‑e ‑ja wlalɛ ‑Waanbhaa' 'fɛ 'ɛ ꞊la. 'Bhɛɛ‑ ‑o 'sraka ‑gwa 'bluu mu 'la 'le ‑Waanbhaa' ni, 'yee‑ Davidi 'pegee ‑a zi mu 'ɛ ‑o 'bhɛ 'bluu mu 'ɛ ꞊bhla. 'Duŋ‑ ‑kɔɔa' 'toŋ mu 'ɛ ta, yaa dɔ mɛɛ ‑bhɛɛke' do 'kpɔ 'kpee 'ke 'bhɛ 'woo‑ 'bluu mu 'ɛ bhle; 'ke yaa 'e go 'sraka 'lɛna mu do ‑kplɛn ba. ");
INSERT INTO moa_vpl VALUES ("MT12_5","070_12_5","MAT","12","5","5","'Bhɛɛ‑ 'ka 'laa ‑jan 'lɛɛ‑ 'bhɛ tapelɛ ‑lido' 'ezin‑ Moizi a 'toŋ 'sɛwɛ 'ɛ 'yi ɛɛ dɔɔ: ‹'Ke 'sraka 'lɛna mu 'la ‑waa' yewo yi ꞊kla ‑yitrɛ' yi ma, ‑wa ‑yisiɛ'; 'bhɛɛ‑ 'duŋ‑, waa ‑kpan balaa' ‑o ta 'bhɛ ‑zayi'.› ");
INSERT INTO moa_vpl VALUES ("MT12_6","070_12_6","MAT","12","6","6","'Duŋ‑ 'mi pe 'ka ni dɔɔ ‑za 'la 'bhɛ ‑o ‑gɛ 'bhɛ gblaan ‑yiya' ‑Waanbhaa' Gba 'Fɛ ‑Gbɛnɛ 'ɛ ni! ");
INSERT INTO moa_vpl VALUES ("MT12_7","070_12_7","MAT","12","7","7","‑Waanbhaa' 'a ꞊pia ‑yaa' 'Sɛwɛ 'ɛ 'yi dɔɔ: ‹'Ŋ maza laa ‑o 'sraka 'kedo‑ 'kpɔ ma, 'ke yaa 'e go mɛɛ ‑yrɛnklale ma 'ŋ ma 'bhɛ ba.› 'Ke 'ka 'bhɛ ‑jan 'la bhe 'bhɛ 'yimaa‑ 'gbu 'elrele bi, 'ka 'laa ‑yaa nu ‑lalɛ' mɛɛ 'la zan mu 'laa ‑za 'yɔɔ‑ klɛlɛ 'mu ta. ");
INSERT INTO moa_vpl VALUES ("MT12_8","070_12_8","MAT","12","8","8","'Bhɛ ya 'ɛ 'yi, Bhaaplɛŋ Gbe 'ɛ 'bhɛ ‑le ‑yitrɛ' 'yi 'ɛ Zan 'ɛ 'le.» ");
INSERT INTO moa_vpl VALUES ("MT12_9","070_12_9","MAT","12","9","9","'Bhɛ blaan, 'ke Zesu gele‑ wlalɛ ‑waa' Zuufu mu daanfɛ' 'ɛ do ‑la. ");
INSERT INTO moa_vpl VALUES ("MT12_10","070_12_10","MAT","12","10","10","Mɛɛ gbɛ 'kwlanle‑ do ‑yaa' 'bhɛ ꞊nɔɔ ye. 'Duŋ‑ 'yee‑ Zuufu mu daanfɛ' 'ɛ ꞊la mɛɛ mu 'ɛ 'yaa‑ ‑a zi 'bhii‑ ‑o ‑layrɛ' ‑srɔɔwo' Zesu ta, 'bhɛla‑ ‑yile 'ke ‑wa ‑lrɔkpale dɔɔ: «‑Kɔɔa' 'toŋ 'ɛ ta mɛɛ sɔ mɛɛ ‑bhɛɛke' 'bheele ‑yitrɛ' yi ma ɛɛ?» ");
INSERT INTO moa_vpl VALUES ("MT12_11","070_12_11","MAT","12","11","11","'Bhɛ klɛle 'tɛ, 'ke Zesu ‑o ‑lrɔkpale dɔɔ: «'Ke ‑bhlaa do 'kpɔ ‑o 'ka do 'kɔɔ, 'bhɛɛ‑ ‑yitrɛ' yi do ma, 'ke 'bhɛ ‑bhlaa do 'kpɔ 'ɛ ‑ja bɔlɛ ‑klɔŋ gbɔɔn do 'yi; 'bhɛ ‑bhlaa 'ɛ zan 'ɛ yaa nu gelɛ ‑a 'pwɛlɛ‑ ‑klɔŋ 'ɛ 'yi ɛɛ? ");
INSERT INTO moa_vpl VALUES ("MT12_12","070_12_12","MAT","12","12","12","'Bhɛɛ‑ 'duŋ‑, bhaaplɛŋ do mabhaabhɔ ‑bhlaa do ta. ‑Ayile, ‑kɔɔa' 'toŋ 'ɛ ta mɛɛ sɔ ‑za 'wlan klɛle‑ mɛɛ ‑bhɛɛke' ni ‑yitrɛ' yi 'ɛ ma.» ");
INSERT INTO moa_vpl VALUES ("MT12_13","070_12_13","MAT","12","13","13","'Bhɛ klɛle 'tɛ, 'ke Zesu 'a 'pele mɛɛ gbɛ 'kwlanle‑ 'ɛ ni dɔɔ: «'E gbɛ 'ɛ 'yisrɔn!» 'Bhɛɛ‑ 'ke ‑ya gbɛ 'ɛ 'yisrɔnle, 'bhɛɛ‑ 'ke 'bhɛ dɔɔle‑ 'bhii‑ ‑a ‑vin do mi 'ɛ gbɛɛn‑. ");
INSERT INTO moa_vpl VALUES ("MT12_14","070_12_14","MAT","12","14","14","'Bhɛ ya 'ɛ 'yi, 'ke Farizi mu 'ɛ 'pwɛle, 'bhɛɛ‑ ‑o ‑yaa nu 'sɔlɛ‑ Zesu 'kunle gɔnɛ‑ 'la gbɛɛn‑ 'bhɛɛ‑ ‑wa dɛ, 'ke ‑woo 'eke‑ yele‑ 'bhɛ ‑za 'ɛ 'yi. ");
INSERT INTO moa_vpl VALUES ("MT12_15","070_12_15","MAT","12","15","15","'Duŋ‑, Zesu ‑o wojan 'ɛ 'male‑, 'ke ‑ya pleŋgole 'bhɛ yrɛ 'ɛ ma. ‑Zamaa' 'srɛ do ‑ja ‑a zi ‑a geyrɛ 'ɛ ꞊nɔɔ; 'bhɛɛ‑ ‑e gadɛ mu 'ɛ 'kpɛn 'bheela‑. ");
INSERT INTO moa_vpl VALUES ("MT12_16","070_12_16","MAT","12","16","16","'Bhɛɛ‑ 'duŋ‑, ‑e ‑yaa ‑o ‑lɛmazɔn 'zi 'eglɔɔle 'kaadɔɔ‑ waa a tapwɛlɛ. ");
INSERT INTO moa_vpl VALUES ("MT12_17","070_12_17","MAT","12","17","17","'Bhɛ klɛgbɛya do 'ɛ 'yi, ‑Waanbhaa' ‑lɛla' janwo mi Ezai ‑jan 'la ꞊woa 'elwale gban 'bhɛ 'lɛswa‑; ‑ya ꞊pia dɔɔ: ");
INSERT INTO moa_vpl VALUES ("MT12_18","070_12_18","MAT","12","18","18","«‑Waanbhaa' pe dɔɔ 'mi 'an yewonɛ 'la makwan‑ 'yele‑ ‑gɛ. ‑A ‑za sɔ 'ŋ ni 'egbɛnɛle, 'bhɛɛ‑ ‑yoo 'ŋ zrukpalaa. 'Ŋ nu 'ŋ Lii 'Weŋ 'ɛ zinalɛ ‑a ta, 'bhɛɛ‑ ‑e nu ‑lɛdɔɔleya maza ‑jan ‑la wolɛ 'klɛɛn 'ɛ 'kpɛn 'yi 'si mu 'ɛ ni. ");
INSERT INTO moa_vpl VALUES ("MT12_19","070_12_19","MAT","12","19","19","Yaa nu zaabɔlɛ mɛɛ 'kedo‑ 'kpɔ 'le, 'bhɛɛ‑ yaa nu ‑gbekanlɛ 'eglɔɔle. Waa nu a ‑weli' 'ɛ malɛ ‑gbleba mu ta. ");
INSERT INTO moa_vpl VALUES ("MT12_20","070_12_20","MAT","12","20","20","To diiŋ 'la 'bhɛ 'klule‑ ‑o, yaa nu 'bhɛ 'ciɛnlɛ‑. 'Bhɛɛ‑ ‑laŋbha 'la 'bhɛ 'bhile‑ 'ɛ ‑yoo 'fiɛntrɔnnɛ, yaa nu 'bhɛ 'liilɛ‑. ‑E nu a klɛlɛ 'bhɛɛ‑ gbɛɛn‑ 'sani‑ 'ke ‑Waanbhaa' a ‑lɛdɔɔleya 'ɛ kpa pɛ 'kpɛn 'wiiŋ‑. ");
INSERT INTO moa_vpl VALUES ("MT12_21","070_12_21","MAT","12","21","21","'Bhɛ ya 'ɛ 'yi, 'klɛɛn mu 'ɛ 'kpɛn 'yri nu bolɛ 'yela‑ ta.» ");
INSERT INTO moa_vpl VALUES ("MT12_22","070_12_22","MAT","12","22","22","'Bhɛ 'yi bhe, 'ke mɛɛ 'ke mu nule‑ gadɛ mi do 'le Zesu ba. 'Zina ‑yaa 'bhɛ zi, 'bhɛla‑ ‑yile ‑e ‑yaa 'ke 'bhobho 'le, 'bhɛɛ‑ ‑a ‑yrɛ 'wile‑ ‑yaa. 'Bhɛ yrɛ do 'ɛ ꞊nɔɔ bhe, 'ke Zesu 'a 'bheele, 'bhɛɛ‑ 'kee‑ ‑janwole, 'bhɛ 'pegee 'kee‑ ‑yrɛ ma yele‑. ");
INSERT INTO moa_vpl VALUES ("MT12_23","070_12_23","MAT","12","23","23","'Bhɛ 'yi 'tɛ, 'ke ‑zamaa' 'ɛ 'kpɛn 'kpeelɛnile ‑o ma, 'bhɛɛ‑ 'ke ‑woo 'eke‑ ‑lrɔkpale dɔɔ: «‑Bhleŋgbe Davidi 'nranɛ‑ 'ɛ 'yele‑ 'laa ‑gɛ ɛɛ?» ");
INSERT INTO moa_vpl VALUES ("MT12_24","070_12_24","MAT","12","24","24","'Bhɛɛ‑ 'duŋ‑, Farizi mu 'ɛ 'trɔnbɔle ‑o wojan mu 'ɛ 'yi, 'ke 'mu 'a pele‑ dɔɔ: «Bɛɛzebuli ('bhɛ 'yi ‑le 'zina mu ‑kuŋlii gblaan), 'bhɛ ‑le 'zina mu ‑gbin 'seŋ 'na zii' mɛɛ 'lɛɛ‑ ni!» ");
INSERT INTO moa_vpl VALUES ("MT12_25","070_12_25","MAT","12","25","25","'Bhɛ klɛle 'tɛ, Zesu ‑o 'kpeejan‑ mu 'ɛ dɔle 'ke ‑ya pele‑ ‑o ni dɔɔ: «'Ke ‑bhleŋgbe do a 'klɛɛn 'yi mu ‑yiciɛnle ‑o, 'bhɛɛ‑ 'ke ‑o gwledan 'eke‑ ba, 'bhɛ 'klɛɛn 'ɛ nu 'siɛlɛ‑. 'Bhɛɛ‑ 'kee‑ ꞊kla ‑wa do ta mu 'le 'oo, 'kee‑ ꞊kla 'fɛ do ‑la mu 'le 'oo, 'ke ‑o ‑yiciɛnle ‑o, 'bhɛɛ‑ 'ke ‑o gwledan 'eke‑ ba, 'bhɛ ‑wa 'ɛ yaa nu ‑mɔlɛ', 'bhɛɛ‑ 'bhɛ 'fɛ 'ɛ yaa nu ‑mɔlɛ' 'ezin‑. ");
INSERT INTO moa_vpl VALUES ("MT12_26","070_12_26","MAT","12","26","26","'Ke ‑Setran' ‑o ‑a 'gbu ‑gbin 'zi, ‑yoo gwledan 'zi ‑a 'gbu ‑la ba bhe. 'Bhɛ klɛgbɛya 'ɛ 'yi, ‑yaa' ‑bhleŋgbeya 'ɛ nu ‑mɔlɛ' 'nale‑ ma ɛɛ? ");
INSERT INTO moa_vpl VALUES ("MT12_27","070_12_27","MAT","12","27","27","'Ke ‑Setran' 'zina mu ‑gbin 'seŋ 'na zii' 'mi ni; ‑dele 'zina mu ‑gbin 'seŋ 'na zii' 'kaa‑ pɛ mɛɛ mu 'ɛ ni 'ɛ? 'Ka 'gbu a pɛ mɛɛ mu 'ɛ 'mu ‑le nu ‑kpan 'kpaalɛ‑ 'ka 'lii 'bhɛ ma. ");
INSERT INTO moa_vpl VALUES ("MT12_28","070_12_28","MAT","12","28","28","'Duŋ‑ 'ke 'ŋ 'yoo‑ 'zina mu ‑gbin 'zi mɛɛ mu zi ‑Waanbhaa' Lii 'ɛ 'bhɛ ‑la 'seŋ ta, ‑kaa 'yaango‑ 'bhii‑ ‑Waanbhaa' a ‑bhleŋgbeya ‑yoo 'ka 'pleŋ‑.» ");
INSERT INTO moa_vpl VALUES ("MT12_29","070_12_29","MAT","12","29","29","Zesu pe 'ezin‑ dɔɔ: «Mɛɛ 'kedo‑ 'kpɔ 'laa sɔ gele‑ pɛ 'silɛ‑ faŋgan‑ ma mɛɛ do ba 'fa ꞊la, 'ke yaa 'bhɛ faŋgan‑ ma mɛɛ 'ɛ gbɛtabɔlɛ bhlɛ 'le 'elwale 'pe; 'kee‑ ‑yaan 'bhɛ gbɛtabɔlele 'waati 'la ba, 'bhɛɛ‑ ‑e sɔ 'bhɛ a 'fa ‑la pɛ mu 'ɛ 'sile 'tɛ. ");
INSERT INTO moa_vpl VALUES ("MT12_30","070_12_30","MAT","12","30","30","'Ke mɛɛ 'la zan laa ‑o 'mi ba, 'bhɛ zan ‑wlɛnle' ‑o 'mi ma, 'bhɛɛ‑ 'ke mɛɛ 'la zan laa nulɛ bhɔlɛ 'ŋ ba mɛɛ mu ‑lɛkpalele 'eke‑ ta, 'bhɛ zan 'ɛ ‑o piilaa' mi ‑la ‑le 'eke‑ ma. ");
INSERT INTO moa_vpl VALUES ("MT12_31","070_12_31","MAT","12","31","31","'Bhɛla‑ ‑zayile, 'mi pe 'ka ni 'ŋ 'sɔwɛɛ‑ ma dɔɔ: 'Ke bhaaplɛŋ mu ‑za 'yɔɔ‑ 'oo ‑za 'yɔɔ‑ 'la ꞊kla, 'bhɛ 'pegee 'ke ‑o ‑jan 'yɔɔ‑ 'la ꞊woa, ‑Waanbhaa' nu 'bhɛ mu ma ‑sroma 'yanlɛ‑; 'duŋ‑ 'ke mɛɛ 'la zan Lii 'Weŋ 'ɛ ma ‑jan 'yɔɔ‑ ꞊woa, ‑Waanbhaa' laa nu 'bhɛ zan a ‑sroma 'yanlɛ‑. ");
INSERT INTO moa_vpl VALUES ("MT12_32","070_12_32","MAT","12","32","32","'Ke mɛɛ 'la zan Bhaaplɛŋ 'ɛ Gbe 'ɛ ma jan 'yɔɔ‑ ꞊woa ‑Waanbhaa' nu 'bhɛ zan a ‑sroma 'yanlɛ‑; 'duŋ‑ 'ke mɛɛ 'la zan Lii 'Weŋ 'ɛ ma jan ‑yɔɔ ꞊woa, 'kee‑ ꞊kla ‑zɔn oo, 'kee‑ ꞊kla too oo, ‑Waanbhaa' laa nu 'bhɛ zan a ‑sroma 'yanlɛ‑ ‑titi.» ");
INSERT INTO moa_vpl VALUES ("MT12_33","070_12_33","MAT","12","33","33","Zesu pe 'ezin‑ dɔɔ: «'Bhɛ ‑ya 'ɛ 'yi bhe, ‑yri diiŋ ‑lrele' ‑le bhaa ‑lrele' klɛ, 'bhɛɛ‑ ‑yri diiŋ ‑yɔɔ' ‑le bhaa ‑yɔɔ' klɛ. ‑Amasrɔyi ‑o ‑yri diiŋ 'ɛ dɔ ‑a bhaa ‑la ma. ");
INSERT INTO moa_vpl VALUES ("MT12_34","070_12_34","MAT","12","34","34","‑Bhlu 'plalu 'si mu! 'Ka ‑o 'eyɔɔle 'gbu 'dɛ, 'ka sɔ ‑jan 'wlan mu wole‑ 'nale‑ ɛɛ? ‑Amasrɔyi ‑jan yɛkɛ‑ 'la ‑yoo 'e 'kpee, 'e 'lii 'bhɛɛ‑ yɛkɛ‑ wo. ");
INSERT INTO moa_vpl VALUES ("MT12_35","070_12_35","MAT","12","35","35","'Bhɛ ya 'ɛ 'yi, mɛɛ 'kpee 'lrele‑ ‑liijan' ‑o 'elrele, 'bhɛɛ‑ mɛɛ 'kpee 'yɔɔ‑ ‑liijan' ‑o 'eyɔɔle. ");
INSERT INTO moa_vpl VALUES ("MT12_36","070_12_36","MAT","12","36","36","'Mi 'a pe 'ka ni dɔɔ ‑Waanbhaa' a 'kitikan 'yi 'ɛ 'le, bhaaplɛŋ mu nu ‑o bhaama jan 'tɔle‑ bhaama jan 'la ꞊woa, 'mu 'kpɛn 'yaanpelɛ. ");
INSERT INTO moa_vpl VALUES ("MT12_37","070_12_37","MAT","12","37","37","‑Amasrɔyi, ‑Waanbhaa' a ‑kpan 'laa nu baalɛ 'e ta 'e 'gbu 'liiwli‑ ‑la ma, 'bhɛɛ‑ ‑yaa' ‑kpan nu baalɛ 'e ta 'e 'gbu 'liiwli‑ ‑la ma 'ezin‑.» ");
INSERT INTO moa_vpl VALUES ("MT12_38","070_12_38","MAT","12","38","38","'Bhɛ klɛle 'tɛ, 'ke 'Toŋ Daan mu 'ɛ 'pegee Farizi 'ke mu 'a 'pele Zesu ni dɔɔ: «'O Daan mi, 'woo‑ ‑a zi 'bhii‑ 'e 'sɔle‑ maza do klɛ 'o 'yrɛ ma ‑gɛ doo.» ");
INSERT INTO moa_vpl VALUES ("MT12_39","070_12_39","MAT","12","39","39","Zesu pe ‑o ni 'tɛ 'kaa: «‑Zɔn mɛɛ mu 'ɛ ‑woo 'eyɔɔle, 'bhɛɛ‑ ‑o zru laa ‑o do ‑Waanbhaa' ni. ‑Wa zi 'bhii‑ 'ŋ 'sɔle‑ maza do klɛ ‑o ni, 'duŋ‑ 'naa nu 'sɔle‑ maza 'kedo‑ 'kpɔ klɛlɛ ‑o ‑yrɛ ma, 'ke yaa 'e go ‑Waanbhaa' ‑lɛla' janwo mi Zonasi a pɛ 'sɔle‑ maza do 'kpɔ 'ɛ ba. ");
INSERT INTO moa_vpl VALUES ("MT12_40","070_12_40","MAT","12","40","40","Zonasi ‑yrekpaa' yaga 'pegee ‑bi yaga ꞊kla kaa ‑gbɛnɛ 'ɛ 'kpee gɔnɛ‑ 'la gbɛɛn‑, Bhaaplɛŋ Gbe 'ɛ nu ‑yrekpaa' yaga 'pegee ‑bi yaga klɛlɛ 'trɛ ꞊la 'bhɛɛ‑ gbɛɛn‑. ");
INSERT INTO moa_vpl VALUES ("MT12_41","070_12_41","MAT","12","41","41","‑Ayile, ‑Waanbhaa' a 'kitikan yi 'ɛ 'le, Ninivu ‑wa la mu 'ɛ nu ‑wlɛnlɛ' ‑zɔn mɛɛ mu 'ɛ 'kaama‑, 'bhɛɛ‑ ‑o nu ‑kpan baalɛ ‑o ta. Amasrɔyi 'woo‑ Ninivu ‑wa la mu 'ɛ ‑o Zonasi 'wojan‑ mu 'ɛ 'male‑, 'ke ‑o 'ploole waa ‑za 'yɔɔ‑ mu 'ɛ ma, 'bhɛɛ‑ 'ke ‑woo zru 'niinale ‑Waanbhaa' ba. 'Bhɛɛ‑ 'duŋ‑, mɛɛ 'la zan ‑o ‑zɔn ‑gɛ 'bhɛ gblaan ‑yiya' Zonasi ni, 'bhɛɛ‑ 'ka 'laa ‑a zi 'ke 'ka 'ka kpa 'bhɛ ‑yi. ");
INSERT INTO moa_vpl VALUES ("MT12_42","070_12_42","MAT","12","42","42","'Bhɛ klɛgbɛya do 'ɛ 'yi bhe, 'yee‑ 'kitikan yi do 'kpɔ 'ɛ ma, ‑bhleŋgbe le Seba nu ‑wlɛnlɛ' ‑zɔn mɛɛ mu 'lɛɛ‑ 'kaama‑, 'bhɛɛ‑ ‑e nu ‑kpan baalɛ ‑o ta. ‑Amasrɔyi ‑e ‑daa 'trɛ ta 'klɛɛn gbɔɔn do 'yi, 'bhɛɛ‑ ‑e ꞊nwa ‑a 'trɔnkpalɛ Salomɔ a ‑zadɔ' ma jan mu 'ɛ ꞊la. 'Bhɛɛ‑ 'duŋ‑, mɛɛ 'la zan ‑o ‑gɛ 'bhɛ gblaan ‑yiya' Salomɔ ni.» ");
INSERT INTO moa_vpl VALUES ("MT12_43","070_12_43","MAT","12","43","43","Zesu pe ‑o ni 'ezin‑ dɔɔ: «'Ke lii ‑yɔɔ' 'ɛ ‑gwa mɛɛ do zi, ‑e ge yrɛ ‑kpaa mu 'ɛ ꞊nɔɔ, ‑a ‑yitrɛ' yrɛ ‑glin zayi'. 'Bhɛɛ‑ 'duŋ‑, 'ke yaa ‑yitrɛ' yrɛ yelɛ, ");
INSERT INTO moa_vpl VALUES ("MT12_44","070_12_44","MAT","12","44","44","‑ya pe dɔɔ: ‹'Ŋ ‑gwa 'fɛ 'la ꞊la, 'ŋ gele‑ niinalɛ 'bhɛ ꞊la.› 'Bhɛɛ‑ 'kee‑ ꞊nwa ‑a ‑la, ‑ya ‑la 'fleŋ‑ ye, 'bhɛɛ‑ ‑a ‑la gole ‑o, 'bhɛ 'pegee ‑a ‑la pɛ mu 'ɛ 'kpɛn 'lɛmagaanle ‑o 'elrele. 'Duŋ‑ mɛɛ 'kedo‑ 'kpɔ 'laa ‑o ‑a ‑la. ");
INSERT INTO moa_vpl VALUES ("MT12_45","070_12_45","MAT","12","45","45","'Bhɛ ya 'ɛ 'yi, ‑e ge lii ‑yɔɔ' 'bhɛɛke 'srwaplɛ‑ 'siilɛ‑; 'bhɛ 'mu ‑yɔɔ' ‑yiya' ‑a ‑lwa mi 'ɛ ni; 'bhɛɛ‑ ‑o nu wlalɛ 'eke‑ zi 'yee‑ 'fɛ 'ɛ ꞊la, 'bhɛɛ‑ ‑wa klɛ ‑o yi 'fɛ 'le. ‑Ayile 'yee‑ mɛɛ 'ɛ 'taawogbɛya drɛɛ, 'bhɛ 'yɔɔ‑ ‑yiya' ‑a 'taawogbɛya gwe mi 'ɛ ni. 'Bhɛla‑ 'yansi za ‑le nu klɛlɛ ‑zɔn mɛɛ ‑yɔɔ' mu 'ɛ ni.» ");
INSERT INTO moa_vpl VALUES ("MT12_46","070_12_46","MAT","12","46","46","Zesu 'yaa‑ ‑janwo' zii' ‑li bhla 'la ba ‑zamaa' ‑gbɛnɛ 'ɛ ni, 'ke ‑a nɛɛ 'pegee ‑a nɛɛnɛ‑ mu 'ɛ 'nule dulalɛ ‑e ‑yaa 'fɛ 'la ꞊la 'bhɛ 'lɛ ma. 'Bhɛɛ‑ ‑o ‑yaa zi 'bhii‑ ‑o ‑janwo' 'a ni. ");
INSERT INTO moa_vpl VALUES ("MT12_47","070_12_47","MAT","12","47","47","'Bhɛ klɛle 'tɛ, 'ke mɛɛ do 'a 'pele Zesu ni dɔɔ: «Dula‑ doo, 'e nɛɛ 'pegee 'e nɛɛnɛ‑ mu 'ɛ ‑woo 'pɛɛlii‑, 'bhɛɛ‑ ‑wa zi 'bhii‑ ‑o ‑janwo' 'e ni.» ");
INSERT INTO moa_vpl VALUES ("MT12_48","070_12_48","MAT","12","48","48","'Bhɛ 'yi, 'ke Zesu 'a 'pele 'bhɛ zan 'ɛ ni dɔɔ: «‑Ka 'ka 'trɔnbadɔ doo, ‑de mu ‑le 'ŋ nɛɛ 'pegee 'ŋ nɛɛnɛ‑ mu 'le ɛɛ?» ");
INSERT INTO moa_vpl VALUES ("MT12_49","070_12_49","MAT","12","49","49","'Bhɛ klɛle 'tɛ, 'kee‑ yaa ‑klaŋlanɛ mu 'ɛ zrɔnle‑ ‑a gbɛ 'le, 'bhɛɛ‑ 'ke ‑ya pele‑ dɔɔ: «'E 'yrɛkpa ‑gɛ doo! 'Ŋ nɛɛ 'pegee 'ŋ nɛɛnɛ‑ mu 'ɛ 'wole‑ ‑gɛ. ");
INSERT INTO moa_vpl VALUES ("MT12_50","070_12_50","MAT","12","50","50","‑Amasrɔyi, 'ke mɛɛ 'oo mɛɛ 'la zan 'ŋ Dɛ 'la ‑yoo laanima 'bhɛ zru maza ‑kla, 'bhɛ zan ‑le 'ŋ nɛɛnɛ‑ 'gwlaan‑ 'pegee 'ŋ nɛɛnɛ‑ le 'bhɛɛ‑ 'ŋ nɛɛ 'le 'ezin‑.» ");
INSERT INTO moa_vpl VALUES ("MT13_1","070_13_1","MAT","13","1","1","'Bhɛ blaan boolazi, 'yee‑ ‑yrekpaa' do 'ɛ 'le, 'ke Zesu 'pwɛle 'fɛ 'ɛ ꞊la, 'bhɛɛ‑ 'kee‑ gele‑ yaalɛ wɛyi‑ 'ɛ 'lɛ ma. ");
INSERT INTO moa_vpl VALUES ("MT13_2","070_13_2","MAT","13","2","2","‑Zamaa' ‑gbɛnɛ do 'pa gbɛ ‑yɔɔ' 'ɛ 'kɔɔ ‑a ta, 'kee‑ gele‑ yaalɛ ‑yitakoŋ do 'yi ‑yi 'ɛ ta. ‑Zamaa' 'kpɛn dulale ‑yaa wɛyi‑ 'ɛ gɔɔna. ");
INSERT INTO moa_vpl VALUES ("MT13_3","070_13_3","MAT","13","3","3","'Bhɛ 'yi 'tɛ, 'ke ‑yoo daanle ‑za ‑bebe mu 'le ‑gɔɔn mu 'yi. ‑E pe ‑o ni dɔɔ: ");
INSERT INTO moa_vpl VALUES ("MT13_4","070_13_4","MAT","13","4","4","«Pɛbhɛ bɔ mi do ‑ja pɛbhɛ bɔyrɛ nɔɔ‑ ‑yaa gbabhɛ 'ɛ ta. ‑E ‑yaa pɛbhɛ mu 'ɛ 'wian zii' bhla 'la ba ‑yaa' gbabhɛ 'ɛ ta, 'ke pɛbhɛ mu 'ɛ 'lɛdo‑ 'klaale zibhɛ 'ɛ 'lɛzi‑. 'Bhɛ klɛle 'tɛ, 'ke maannɛ‑ mu 'ɛ 'nule 'bhɛ mu bhlelɛ. ");
INSERT INTO moa_vpl VALUES ("MT13_5","070_13_5","MAT","13","5","5","Pɛbhɛ mu 'ɛ 'bhɛɛke 'lɛdo‑ ‑klalaa' vlɛ gloglo mu 'yi, 'bhɛɛ‑ 'trɛ kplankplan laa ‑yaa ‑o ‑la. ‑O ꞊bhwa blaale‑ 'bhɛ 'trɛ sanɛ‑ 'ɛ ta. ");
INSERT INTO moa_vpl VALUES ("MT13_6","070_13_6","MAT","13","6","6","'Duŋ‑ vlɛ mu 'ɛ 'kɔɔ, waa 'sɔlɛ‑ ‑o 'sɛnɛ mu gbaanle‑ 'trɛ 'yi 'egbɔɔnle. ‑Ayile ‑yretɛ' 'bhile‑ ‑o ta, 'ke ‑o 'kpɛn gale‑. ");
INSERT INTO moa_vpl VALUES ("MT13_7","070_13_7","MAT","13","7","7","'Ezin‑, pɛbhɛ mu 'ɛ 'bhɛɛke 'lɛdo‑ ‑klalaa' lɛrɛ mu 'yi. Lɛrɛ mu 'ɛ ꞊bhwa, 'bhɛɛ‑ ‑woo ꞊dia 'ke ‑o lii mu 'ɛ 'le. ");
INSERT INTO moa_vpl VALUES ("MT13_8","070_13_8","MAT","13","8","8","'Bhɛɛ‑ 'duŋ‑, pɛbhɛ mu 'ɛ 'ke mu ‑ja 'klaalɛ‑ 'trɛ ti ‑lrele' ‑yi. ‑Ayile ‑o ꞊bhwa, 'bhɛɛ‑ ‑woo bhaa ‑kla: pɛbhɛ 'ɛ diiŋ do 'bhɛ bhaa ‑kɛmɛ do ꞊kla, ‑o diiŋ ‑bhɛɛke' do 'bhɛ bhaa mia yaga ꞊kla, 'bhɛɛ‑ ‑o diiŋ ‑bhɛɛke' do 'bhɛ bhaa mia do bhɛ vu ꞊kla. ");
INSERT INTO moa_vpl VALUES ("MT13_9","070_13_9","MAT","13","9","9","'Ke 'ka 'trɔn mu sɔ ‑jan 'yimale, ‑kaa ‑yima'!» ");
INSERT INTO moa_vpl VALUES ("MT13_10","070_13_10","MAT","13","10","10","Zesu a ‑klaŋlanɛ mu 'ɛ ‑woo mabɛɛnna ‑a ‑din, 'bhɛɛ‑ ‑wa ‑lrɔkpaa dɔɔ: «‑Mɛla ma 'bhɛɛ‑ 'yoo‑ ‑janwo' zii' ‑o ni ‑gɔɔn mu 'yi ɛɛ?» ");
INSERT INTO moa_vpl VALUES ("MT13_11","070_13_11","MAT","13","11","11","Zesu 'a zikpaa‑ ‑o ni dɔɔ: «‑Waanbhaa' 'yaa‑ laanima ‑bhleŋgbeya gaanyiza mu 'ɛ tapwɛla 'ka mu ni, 'duŋ‑ yaa ‑o tapwɛlɛ 'woo‑ mu ni. ");
INSERT INTO moa_vpl VALUES ("MT13_12","070_13_12","MAT","13","12","12","‑Amasrɔyi, 'ke mɛɛ 'la zan ‑jan 'yima‑, 'bhɛ zan ‑o 'bhii‑ pɛ ‑o mɛɛ 'la zan 'kɔɔ, 'bhɛla‑ ‑yile ‑o nu pɛ baan' 'nalɛ‑ 'bhɛ zan 'ɛ ni, 'bhɛɛ‑ ‑a 'kɔɔ pa. 'Duŋ‑ pɛ 'kedo‑ 'kpɔ 'laa ‑o mɛɛ 'la zan 'kɔɔ, pɛ sanɛ‑ 'gbu 'la 'bhɛ ‑o ‑a 'kɔɔ, ‑o nu 'bhɛ 'kunlɛ‑. ");
INSERT INTO moa_vpl VALUES ("MT13_13","070_13_13","MAT","13","13","13","'Bhɛla‑ ‑zayile, 'ŋ 'yoo‑ ‑janwo' zii' ‑o ni ‑gɔɔn mu 'yi. ‑Amasrɔyi ‑o ‑yrɛbhɛ' mu ‑o, 'bhɛɛ‑ waa yrɛ ma ye, ‑o 'trɔn mu ‑o, 'bhɛɛ‑ waa ‑jan ma, 'bhɛ 'pegee waa ‑jan 'yima‑. ");
INSERT INTO moa_vpl VALUES ("MT13_14","070_13_14","MAT","13","14","14","'Bhɛ klɛgbɛya 'ɛ 'yi, ‑Waanbhaa' ‑jan 'la ‑kpaa ‑a ‑lɛla' janwo mi Ezai 'lii 'elwale ‑sɔ 'bhɛ 'lɛswa꞊; 'bhɛ ‑jan 'ɛ 'bhɛ ‑le ‑gɛ dɔɔ: ‹'Ka nu ‑jan 'malɛ‑, 'duŋ‑ 'ka 'laa nu ‑a ‑yimalɛ; 'ka nu 'ka 'yrɛkpalɛ ‑a ta, 'duŋ‑ 'ka 'laa nu ‑a yelɛ ‑titi. ");
INSERT INTO moa_vpl VALUES ("MT13_15","070_13_15","MAT","13","15","15","‑Amasrɔyi, mɛɛ mu 'lɛɛ‑ ‑woo zru ‑yɔɔya' ꞊kla, 'bhɛɛ‑ ‑woo 'trɔn 'yidwa‑ 'eglɔɔle, 'bhɛ 'pegee ‑woo ‑yrɛ 'liitaan‑, ‑o 'bhɛ ꞊kla 'bhɛ gbɛɛn‑ bhe, 'kooko‑ waa yrɛ ma ye ‑o ‑yrɛbhɛ' mu 'ɛ 'le, 'bhɛ 'pegee waa ‑jan ma ‑o 'trɔn mu 'ɛ 'le, 'bhɛɛ‑ waa ‑jan 'yima‑ ‑o zru mu 'ɛ 'le, 'bhɛɛ‑ 'kooko‑ waa nu ‑o zru mu 'ɛ 'niinalɛ 'mi ‑Waanbhaa' ba, 'bhɛɛ‑ 'mi ‑o go ‑za 'yi. ");
INSERT INTO moa_vpl VALUES ("MT13_16","070_13_16","MAT","13","16","16","«'Duŋ‑ 'kaa‑ pɛ ‑yinra', ‑amasrɔyi 'ka 'yrɛbhɛ‑ mu 'ɛ yrɛ ma ye, 'bhɛɛ‑ 'ka 'trɔn mu ‑jan ma. ");
INSERT INTO moa_vpl VALUES ("MT13_17","070_13_17","MAT","13","17","17","'Mi pe 'ka ni wlan 'ɛ ni dɔɔ: ‑Waanbhaa' ‑lɛla' janwo mu ‑bebe 'pegee ‑yaa' mɛɛ ‑lɛdɔɔle mu ‑bebe 'yaa‑ zi 'bhii‑ ‑o ‑yrɛkpa' 'ka 'yrɛ ‑o pɛ 'la ma 'bhɛ ma, 'bhɛɛ‑ waa 'bhɛ 'yelɛ‑. 'Bhɛɛ‑ ‑o ‑yaa ‑a zi 'bhii‑ 'ka mu ‑o ‑jan 'la 'bhɛ 'ma zii' ‑o 'bhɛ 'ma, 'duŋ‑ waa 'bhɛ 'malɛ‑.» ");
INSERT INTO moa_vpl VALUES ("MT13_18","070_13_18","MAT","13","18","18","«‑Ka 'ka 'trɔnbadɔ doo, pɛbhɛ bɔ mi 'ɛ ma ‑gɔɔn 'ɛ 'yi ‑le ‑gɛ: ");
INSERT INTO moa_vpl VALUES ("MT13_19","070_13_19","MAT","13","19","19","'Ke mɛɛ 'oo mɛɛ 'la zan ‑Waanbhaa' a ‑bhleŋgbeya ‑wa 'ɛ ma jan 'ɛ ꞊maa, 'bhɛɛ‑ 'ke yaa ‑yimalɛ, 'bhɛ 'yi ‑le dɔɔ ‑Waanbhaa' ‑jan 'la 'bhɛ 'yaa‑ ‑a zru 'ɛ 'yi, ‑Setran' ꞊nwa 'bhɛ 'kpɛn golɛ. 'Bhɛ klɛgbɛya do 'kpɔ 'ɛ 'yi, ‑yoo 'bhii‑ pɛbhɛ mu 'la 'klalaa zibhɛ 'ɛ 'lɛzi‑ 'mu gbɛɛn‑. ");
INSERT INTO moa_vpl VALUES ("MT13_20","070_13_20","MAT","13","20","21","Pɛbhɛ mu 'la 'klalaa‑ vlɛ gloglo mu 'ɛ 'yi, 'bhɛɛ‑ 'ke waa 'sɔlɛ‑ ‑o 'sɛnɛ gbaanle‑ 'trɛ 'yi 'egbɔɔnle, 'bhɛ 'yi ‑le dɔɔ 'ke mɛɛ 'la zan 'kee‑ ‑Waanbhaa' a ‑jan 'ɛ ꞊maa, ‑e dɔ ‑a ‑la 'bhɛ yrɛ do 'ɛ ꞊nɔɔ bhe ‑a zrukpaale 'le. 'Duŋ‑ yaa mɔ 'bhɛ zi. ‑Amasrɔyi, 'ke mɛɛ mu ‑yrɛnkpale ‑saan ‑a ta, 'bhɛ 'pegee 'ke ‑wa ‑yrɛbatɛdɔle ‑saan ‑Waanbhaa' a ‑jan 'ɛ ‑zayi' bhla 'la ba, ‑e ploo 'bhɛ yrɛ do 'ɛ ꞊nɔɔ bhe ‑a 'kpale ma ‑Waanbhaa' 'yi. ");
INSERT INTO moa_vpl VALUES ("MT13_22","070_13_22","MAT","13","22","22","Pɛbhɛ mu 'la 'klalaa‑ daanlɛrɛ mu 'ɛ 'yi, 'bhɛ 'yi ‑le dɔɔ 'ke mɛɛ 'la zan 'kee‑ ‑Waanbhaa' a ‑jan 'ɛ ꞊maa, 'duŋ‑ 'drunyan ta pɛ mu 'ŋgami 'la ‑yoo ‑a ma, 'bhɛɛ‑ ‑naflo pɛ mu 'flɛn 'la mɛɛ ‑yini' 'mu 'laa to 'kee‑ ‑Waanbhaa' a ‑jan 'ɛ 'yizaklɛ, 'bhɛɛ‑ ‑wa ‑dewo' ‑a 'gbu 'kpee. ");
INSERT INTO moa_vpl VALUES ("MT13_23","070_13_23","MAT","13","23","23","Pɛbhɛ mu 'la 'klalaa‑ 'trɛ ti 'yi, 'bhɛ 'yi ‑le dɔɔ mɛɛ 'la zan 'kee‑ ‑Waanbhaa' ‑jan 'ɛ ꞊maa, ‑ya ‑yima', 'bhɛɛ‑ ‑ya ‑yizaklɛ. ‑Yoo 'bhii‑ pɛbhɛ diiŋ 'la ‑ya bhaa ‑kɛmɛ do klɛ, 'bhɛɛ‑ ‑a ‑bhɛɛke' diiŋ 'bhɛ bhaa mia yaga klɛ, 'bhɛɛ‑ ‑a ‑bhɛɛke' diiŋ 'ɛ 'bhɛ bhaa mia do bhɛ vu klɛ.» ");
INSERT INTO moa_vpl VALUES ("MT13_24","070_13_24","MAT","13","24","24","'Bhɛ blaan, 'ke Zesu ‑gɔɔn do bɔle‑ ‑o ni 'ezin‑, 'bhɛɛ‑ ‑e pe dɔɔ: «Laanima ‑Bhleŋgbeya ‑wa 'ɛ ‑yoo 'bhii‑ mɛɛ do 'la ‑e pɛbhɛ ‑lrele' ꞊bwa ‑yaa' gba 'ɛ 'yi. ");
INSERT INTO moa_vpl VALUES ("MT13_25","070_13_25","MAT","13","25","25","'Duŋ‑ ‑bi do zi mɔkpɛn' 'yaa‑ yi pla 'waati 'la ba, 'ke ‑a ‑sɔɔnnii' 'ɛ 'nule ‑bɔn 'yɔɔ‑ bhɛ bɔlɛ ‑yaa' gba 'ɛ 'yi pɛbhɛ ‑lrele' mu 'ɛ 'pleŋ‑, 'bhɛɛ‑ 'kee‑ jilale. ");
INSERT INTO moa_vpl VALUES ("MT13_26","070_13_26","MAT","13","26","26","'Bhɛɛ‑ pɛbhɛ ‑lrele' mu 'ɛ 'pegee ‑bɔn 'yɔɔ‑ mu 'ɛ ‑o ꞊bhwa 'eke‑ zi, 'bhɛɛ‑ ‑o gbaandia‑. 'Duŋ‑ pɛbhɛ ‑lrele' diiŋ mu 'ɛ ‑woo bhaa ꞊kla. ");
INSERT INTO moa_vpl VALUES ("MT13_27","070_13_27","MAT","13","27","27","Gbazan 'ɛ ‑yaa' yewonɛ mu 'ɛ ꞊nwa ‑a ‑lrɔkpalɛ dɔɔ: ‹‑O Zan, 'e pɛbhɛ ‑lrele' mu ‑la ꞊bwa 'yaa‑ gba 'ɛ 'yi, ‑bɔn 'yɔɔ‑ mu 'la ‑woo ‑a ‑yi ‑o ‑daa 'naa ɛɛ?› ");
INSERT INTO moa_vpl VALUES ("MT13_28","070_13_28","MAT","13","28","28","Gbazan 'ɛ pe ‑o ni dɔɔ: ‹'Ŋ 'sɔɔnnii do ‑le 'bhɛ ꞊kla.› ‑Yaa' yewonɛ mu 'ɛ ‑wa ‑lrɔkpaa 'ezin‑ dɔɔ: ‹꞊Ya zi 'bhii‑ 'o ge ‑bɔn 'yɔɔ‑ mu 'ɛ 'yro ɛɛ?› ");
INSERT INTO moa_vpl VALUES ("MT13_29","070_13_29","MAT","13","29","29","‑E pe ‑o ni dɔɔ: ‹'Yooye‑, ‑amasrɔyi 'ke 'kaa ꞊pia 'ka ‑o ‑bɔn 'yɔɔ‑ mu 'ɛ 'yrole, 'ka nu pɛbhɛ ‑lrele' diiŋ mu 'ɛ 'yrolɛ‑ 'ezin‑. ");
INSERT INTO moa_vpl VALUES ("MT13_30","070_13_30","MAT","13","30","30","‑Ka ‑o 'to 'eke‑ 'yi 'ke 'bhɛ ge 'tɛnlɛ‑ pɛbhɛ ‑lrele' diiŋ mu 'ɛ bhaa 'tranle‑ ma. 'Bhɛɛ‑ ‑o 'kan bhla 'ɛ zi, 'ŋ nu a pelɛ ‑o bhaa 'kan mu 'ɛ ni dɔɔ: ‑Ka ‑bɔn 'yɔɔ‑ mu 'ɛ yro 'pe, 'bhɛɛ‑ ‑ka ‑o yre 'bhii‑ ‑gaa dri mu gbɛɛn‑, 'bhɛɛ‑ ‑ka ‑o kpacie 'tɛ 'yi. 'Bhɛ blaan, 'bhɛɛ‑ 'ka pɛbhɛ ‑lrele' mu 'ɛ bhaa mu 'ɛ kan 'bhɛɛ‑ 'ka ‑o zrɛdɔ.›» ");
INSERT INTO moa_vpl VALUES ("MT13_31","070_13_31","MAT","13","31","31","Zesu ‑gɔɔn 'bhɛɛke do ꞊bwa ‑o ni 'ezin‑ dɔɔ: «*Laanima ‑Bhleŋgbeya ‑wa 'ɛ ‑yoo 'bhii‑ mutaadi 'bhɛ 'fiɛntrɔnnɛ do 'la 'ke mɛɛ do 'a ꞊sia, 'bhɛɛ‑ ‑ya ꞊bwa ‑yaa' gba 'ɛ 'yi. ");
INSERT INTO moa_vpl VALUES ("MT13_32","070_13_32","MAT","13","32","32","'Yela‑ 'fiɛntrɔnnɛ 'yiya‑ pɛbhɛ mu 'ɛ 'kpɛn ni; 'duŋ‑ 'kee‑ ꞊bhwa, ‑a diiŋ 'ɛ 'trole‑ kan ‑ziɛnbhɛ' gba 'ɛ 'yi ‑yri diiŋ mu 'ɛ 'kpɛn ta, ‑e klɛ ‑yri diiŋ ‑gbɛnɛ do 'le. 'Bhɛɛ‑ maannɛ‑ mu 'ɛ nu ‑o yifɛ' mu 'kpalɛ‑ ‑a gbɛ mu 'ɛ 'yi.» ");
INSERT INTO moa_vpl VALUES ("MT13_33","070_13_33","MAT","13","33","33","Zesu ‑gɔɔn 'bhɛɛke do ꞊bwa ‑o ni 'ezin‑ dɔɔ: «*Laanima ‑Bhleŋgbeya ‑wa 'ɛ 'pwɛle‑ ‑o 'ke 'bluu ‑pɛɛ wlɛn 'sɛkɛ 'la 'ke le do 'a ꞊sia, 'bhɛɛ‑ ‑yoo 'pegee 'bluu pii kilo mia do bhɛ 'soo 'yizaala 'eke‑ ba. ‑Yoo ‑yizaala 'ke 'bhɛ ge 'tɛnlɛ‑ 'bluu ‑pɛɛ 'ɛ 'kpɛn 'wlɛnle‑ ma.» ");
INSERT INTO moa_vpl VALUES ("MT13_34","070_13_34","MAT","13","34","34","Zesu ‑jan mu 'ɛ 'kpɛn ꞊woa ‑zamaa' 'ɛ ni ‑gɔɔn mu ‑la ‑yi. Yaa ‑yaa ‑jan sanɛ‑ wo ‑o ni 'ke yaa ‑gɔɔn bɔ 'bhɛ zi. ");
INSERT INTO moa_vpl VALUES ("MT13_35","070_13_35","MAT","13","35","35","‑E ‑yaa klɛ 'bhɛ gbɛɛn‑ bhe, 'kooko‑ ‑Waanbhaa' ‑lɛla' janwo mi 'ɛ 'wojan‑ 'ɛ 'lɛsɔ‑; 'bhɛ ‑jan 'ɛ 'bhɛ ‑le ‑gɛ: «'Ŋ nu ‑jan mu wolɛ ‑o ni ‑gɔɔn mu ‑la ‑yi, 'ŋ pɛ mu 'la tagaanle ꞊twa bhaaplɛŋ mu ma 'kee‑ 'san 'drunyan klɛ yi 'ɛ ma, 'ŋ nu 'mu 'pelɛ‑ ‑o ni kpataakpa.» ");
INSERT INTO moa_vpl VALUES ("MT13_36","070_13_36","MAT","13","36","36","'Bhɛ 'yi bhe, 'ke Zesu a 'pele ‑zamaa' 'ɛ ni 'kaa ‑o ge ‑o ba ‑lɛ ma. 'Bhɛ blaan, 'ke 'yee‑ 'gbu gele‑ ‑a ba 'fɛ 'lɛ ma. 'Bhɛ klɛle 'tɛ, 'ke ‑yaa' ‑klaŋlanɛ mu 'ɛ ‑woo mabɛɛnle 'a ‑din, 'bhɛɛ‑ 'ke ‑wa pele‑ ‑a ni dɔɔ: «Gba 'ɛ 'yi ‑bɔn 'yɔɔ‑ ma ‑gɔɔn 'ɛ 'yipe 'o ni.» ");
INSERT INTO moa_vpl VALUES ("MT13_37","070_13_37","MAT","13","37","37","'Bhɛ 'yi 'tɛ, 'ke Zesu 'a zikpale ‑o ni dɔɔ: «Mɛɛ 'la zan pɛbhɛ ‑lrele' 'ɛ bɔ, 'bhɛ ‑le 'ke Bhaaplɛŋ Gbe 'ɛ 'le; ");
INSERT INTO moa_vpl VALUES ("MT13_38","070_13_38","MAT","13","38","38","Gba 'ɛ 'bhɛ ‑le 'ke 'drunyan 'ɛ 'le; pɛbhɛ ‑lrele' mu 'ɛ 'mu ‑le 'ke mɛɛ 'la zan ꞊kla 'ke ‑Waanbhaa' a ‑bhleŋgbeya ‑wa 'ɛ ta mu 'ɛ 'le; 'bhɛɛ‑ ‑bɔn 'yɔɔ‑ mu 'ɛ 'mu ‑le 'ke mɛɛ 'la zan mu ‑o 'ke ‑Setran' ‑a mɛɛ mu 'le; ");
INSERT INTO moa_vpl VALUES ("MT13_39","070_13_39","MAT","13","39","39","‑a ‑sɔɔnnii' 'la 'bhɛ ‑bɔn 'yɔɔ‑ 'ɛ bɔ bhe, 'bhɛ ‑le 'ke ‑Setran' 'le; pɛbhaa ‑lrele' 'kan bhla 'ɛ, 'bhɛ ‑le 'ke 'drunyan 'lɛyan yi 'ɛ 'le; pɛbhaa 'kan mu 'ɛ 'mu ‑le 'ke ‑Waanbhaa' a ‑mlɛkɛ' mu 'ɛ 'le. ");
INSERT INTO moa_vpl VALUES ("MT13_40","070_13_40","MAT","13","40","40","‑O ‑bɔn 'yɔɔ‑ 'ɛ yro, 'bhɛɛ‑ ‑wa blin 'tɛ 'ɛ 'yi; 'bhɛɛ‑ 'yansi za nu klɛlɛ 'bhɛɛ‑ gbɛɛn‑ 'drunyan 'lɛyan yi 'ɛ 'le. ");
INSERT INTO moa_vpl VALUES ("MT13_41","070_13_41","MAT","13","41","41","Bhaaplɛŋ Gbe 'ɛ nu ‑yaa' ‑mlɛkɛ' mu 'ɛ 'winbɔlɛ, 'bhɛɛ‑ mɛɛ 'la zan mu 'kpɛn mɛɛ ‑bhɛɛke' mu balaa' ‑za 'yɔɔ‑ 'yi, 'bhɛɛ‑ ‑o 'gbu ‑za 'yɔɔ‑ klɛ 'ezin‑, ‑o nu 'bhɛ zan mu 'ɛ 'kpɛn golɛ ‑Waanbhaa' ‑bhleŋgbeya ‑wa 'ɛ ta. ");
INSERT INTO moa_vpl VALUES ("MT13_42","070_13_42","MAT","13","42","42","'Bhɛɛ‑ ‑o nu ‑o 'kpɛn blinlɛ 'tɛ ‑gluu ‑gbɛnɛ 'ɛ 'yi. 'Bhɛ ꞊nɔɔ ye, ‑o nu wisilɛ, 'bhɛ 'pegee ‑o nu ‑o gbɛnɛbhɛ mu 'ɛ 'sɔnkpalɛ ‑ ‑zadɔwɛɛ 'ɛ 'kɔɔ.» ");
INSERT INTO moa_vpl VALUES ("MT13_43","070_13_43","MAT","13","43","43","'Bhɛɛ‑ 'duŋ‑, mɛɛ 'la zan mu ‑lɛdɔɔle ‑o ‑Waanbhaa' ‑yrɛ 'yi, ‑o nu ‑bhilɛ' 'peŋpeŋ 'bhii‑ ‑yretɛbhɛ gbɛɛn‑ ‑o Dɛ a ‑bhleŋgbeya ‑wa 'ɛ ta. 'Ke 'ka 'trɔn mu sɔ ‑jan 'yi 'male ‑kaa ‑yima'. ");
INSERT INTO moa_vpl VALUES ("MT13_44","070_13_44","MAT","13","44","44","«Laanima ‑Bhleŋgbeya 'ɛ ‑wa ‑yoo 'ezin‑ 'bhii‑ ‑o ‑naflo do 'la ‑gaanna gba do 'yi. Mɛɛ 'la zan 'yee‑ ‑naflo 'ɛ ꞊ya, 'bhɛ 'a gaan gbɛ drɛɛwoa‑ 'yee‑ gba 'ɛ 'yi 'ezin‑. ‑A zrukpaa' gbɛ ‑yɔɔ 'ɛ 'kɔɔ, ‑e ‑ja ‑a 'kɔɔpɛ‑ mu 'ɛ 'kpɛn gɔnlɛ, 'bhɛɛ‑ ‑e ‑nwa 'yee‑ gba 'ɛ 'lɔlɛ‑.» ");
INSERT INTO moa_vpl VALUES ("MT13_45","070_13_45","MAT","13","45","45","«Laanima ‑Bhleŋgbeya ‑wa 'ɛ 'yoo‑ 'ezin‑ 'bhii‑ pɛgɔn mi do 'la ‑yoo ‑gbɛɛfiŋ 'lrele‑ mu ziglin‑ 'zi. ");
INSERT INTO moa_vpl VALUES ("MT13_46","070_13_46","MAT","13","46","46","'Kee‑ ‑gbɛɛfiŋ 'plɛɛle‑ do ‑ya, ‑e ge ‑a 'kɔɔpɛ‑ mu 'ɛ 'kpɛn gɔnlɛ, 'bhɛɛ‑ ‑e nu 'yee‑ ‑gbɛɛfiŋ 'ɛ 'lɔlɛ‑.» ");
INSERT INTO moa_vpl VALUES ("MT13_47","070_13_47","MAT","13","47","47","«Laanima ‑Bhleŋgbeya ‑wa 'ɛ ‑yoo 'bhii‑ kaadɛ yrɔ 'la ‑wa ꞊bwa ‑yi 'ɛ ba; 'bhɛɛ‑ 'bhɛ kaa ‑glɔɔn mu 'ɛ 'kpɛn ꞊kwan‑. ");
INSERT INTO moa_vpl VALUES ("MT13_48","070_13_48","MAT","13","48","48","'Ke kaadɛ yrɔ 'ɛ 'paa‑ bhla 'la ba kaa 'le, 'bhɛɛ‑ ‑wa glaan ‑yi 'ɛ bhoŋla. 'Bhɛ blaan, ‑o yalaa' 'bhɛɛ‑ ‑o kaa mu 'ɛ bago: ‑O kaa ‑lrele' mu 'ɛ 'mu kla ciɛ ‑nɛ mu 'yi, 'bhɛɛ‑ 'kɛ mu 'la ‑woo 'eyɔɔle, ‑o 'mu blin ‑yi 'ɛ ba. ");
INSERT INTO moa_vpl VALUES ("MT13_49","070_13_49","MAT","13","49","49","'Bhɛɛ‑ 'yansi ‑za nu klɛlɛ 'drunyan 'lɛyan yi 'ɛ 'le. ‑Waanbhaa' a ‑mlɛkɛ' mu 'ɛ nu mɛɛ ‑yɔɔ' mu 'ɛ 'pleŋgolɛ mɛɛ wlan mu 'ɛ ma. ");
INSERT INTO moa_vpl VALUES ("MT13_50","070_13_50","MAT","13","50","50","‑Ayile, ‑o nu 'woo‑ mɛɛ ‑yɔɔ' mu 'ɛ blinlɛ 'tɛ ‑gluu ‑gbɛnɛ 'ɛ 'yi. 'Bhɛ ꞊nɔɔ ye, ‑o nu wisilɛ, 'bhɛ 'pegee ‑o nu ‑o gbɛnɛbhɛ mu 'ɛ 'sɔnkpalɛ ‑ ‑zadɔwɛɛ 'ɛ 'kɔɔ.» ");
INSERT INTO moa_vpl VALUES ("MT13_51","070_13_51","MAT","13","51","51","Zesu ‑yaa' ‑klaŋlanɛ mu 'ɛ ꞊lrɔkpaa' dɔɔ: «'Ka 'woo‑ ‑gɔɔn mu 'ɛ 'kpɛn 'yimaa‑ ɛɛ?» 'Bhɛɛ‑ ‑wa ‑lɛkwan ‑a ni dɔɔ: «‑Aani'!» ");
INSERT INTO moa_vpl VALUES ("MT13_52","070_13_52","MAT","13","52","52","'Bhɛ klɛle 'tɛ, 'ke ‑ya pele‑ ‑o ni dɔɔ: «'Ke 'Toŋ daan mi 'tɔle‑ 'Toŋ daan mi 'la ꞊kla 'ke ‑Waanbhaa' a ‑bhleŋgbeya ‑klaŋlanɛ 'le, ‑yoo 'bhii‑ 'fɛzan‑ 'la ‑e ‑naflo drɛɛ mu 'ɛ 'pegee ‑naflo gwe mu 'ɛ si ‑yaa' ‑naflo bɔ ‑koonɛ 'ɛ 'yi.» ");
INSERT INTO moa_vpl VALUES ("MT13_53","070_13_53","MAT","13","53","53","Zesu 'yanle‑ 'woo‑ ‑gɔɔn mu 'ɛ bɔlele, 'kee‑ gele‑ yrɛ ‑bhɛɛke' do nɔɔ‑. ");
INSERT INTO moa_vpl VALUES ("MT13_54","070_13_54","MAT","13","54","54","'Bhɛ 'nɔɔ‑ bhe, 'kee‑ gele‑ Nazarɛti, Galile 'klɛɛn 'yi ‑wa 'nɛ do ta, ‑wa ‑trola 'bhɛɛ‑ ‑wa 'ɛ ta. ‑E ‑yaa mɛɛ mu 'ɛ daan 'zi ‑Waanbhaa' a ‑jan 'ɛ 'le Zuufu mu daanfɛ' 'ɛ ꞊la. 'Bhɛɛ‑ ‑e ‑yaa mɛɛ 'la zan mu daan 'zi 'mu 'kpɛn 'kpeelɛnia 'mu ma. 'Bhɛla‑ ‑yile, ‑o ‑yaa 'eke‑ ‑lrɔkpa' zii' dɔɔ: «‑E 'bhɛ ‑zadɔleya 'lɛɛ‑ 'ɛ 'srɔɔwoa‑ ‑dela 'kɔɔ, 'bhɛɛ‑ ‑dele 'bhɛ 'sɔle‑ maza mu 'ɛ klɛ 'seŋ 'na zii' ‑a ni ɛɛ? ");
INSERT INTO moa_vpl VALUES ("MT13_55","070_13_55","MAT","13","55","55","'Fɛ 'wiiŋkpa mi 'ɛ gbe 'ɛ 'yele‑ 'laa 'kɛle‑ ɛɛ? Mari gbe 'ɛ yaa 'kɛle‑ ɛɛ? 'Bhɛɛ‑ Zaki 'pegee Zozɛfu, 'bhɛɛ‑ Simɔ 'pegee Zudi 'laa ‑o 'ke ‑a nɛɛnɛ‑ 'gwlaan‑ mu 'ɛ 'le ɛɛ? ");
INSERT INTO moa_vpl VALUES ("MT13_56","070_13_56","MAT","13","56","56","'Bhɛɛ‑ ‑a nɛɛnɛ‑ le mu 'ɛ 'kpɛn 'laa ‑o ‑kɔɔ' ba ‑gɛ ɛɛ? ‑E 'bhɛ ‑za mu 'lɛɛ‑ 'kpɛn klɛ 'seŋ 'ɛ 'srɔɔwoa‑ 'naa ɛɛ?» ");
INSERT INTO moa_vpl VALUES ("MT13_57","070_13_57","MAT","13","57","57","'Bhɛ ya 'ɛ 'yi, waa 'sɔlɛ‑ ‑o 'kpale Zesu 'yi. ‑Ayile Zesu pe ‑o ni dɔɔ: «Mɔkpɛn' ‑Waanbhaa' ‑lɛla' janwo mi 'ɛ 'lɛdɔ‑ ‑a ma yrɛkpɛn‑ ꞊nɔɔ, 'ke yaa 'e go ‑a 'gbu ba ‑wa la mu 'pegee ‑a ba 'fa ꞊la ‑la mu ba.» ");
INSERT INTO moa_vpl VALUES ("MT13_58","070_13_58","MAT","13","58","58","Waa ‑o 'kpalawolɛ ‑a ‑yi Nazarɛti ‑wa 'ɛ ta, yaa 'sɔle‑ maza mu ‑bebe klɛle‑ 'bhɛ ꞊nɔɔ. ");
INSERT INTO moa_vpl VALUES ("MT14_1","070_14_1","MAT","14","1","1","'Bhɛ 'waati 'ɛ ba, ‑Bhleŋgbe Erɔdi gbe do 'la ‑o ‑yaa 'bhɛ sii Erɔdi Antipasi, 'bhɛ 'yaale‑ ‑yaa Galile 'klɛɛn 'ɛ 'wiiŋ‑; 'bhɛɛ‑ 'bhɛ Zesu 'tɔbhɔleya 'ɛ ꞊maa 'tɛ. ");
INSERT INTO moa_vpl VALUES ("MT14_2","070_14_2","MAT","14","2","2","'Bhɛ ya 'ɛ 'yi, 'ke ‑ya pele‑ ‑yaa' yewonɛ mu 'ɛ ni dɔɔ: «Mɛɛ Wiiŋfɛ' Mi Zaan ‑le 'kɛle‑! ‑E ‑bwela gale ba. 'Bhɛla‑ ‑zayile 'sɔle‑ maza mu klɛ 'seŋ ‑o ‑a 'kɔɔ.» ");
INSERT INTO moa_vpl VALUES ("MT14_3","070_14_3","MAT","14","3","3","Mɛɛ Wiiŋfɛ' Mi Zaan ‑gaa gɔnɛ‑ 'lɛɛ‑ 'bhɛɛ‑ gbɛɛn‑. 'Yee‑ Erɔdi Antipasi 'gbu 'a ꞊pia mɛɛ mu ni 'kaa ‑o Zaan 'kun, 'bhɛɛ‑ ‑wa yre, 'bhɛɛ‑ ‑wa bɔ ‑kaso 'yi. 'Bhɛ 'saan‑ 'yee‑ Erɔdi nɛɛnɛ‑ Filipu 'na Erodiadi ‑la ta. ");
INSERT INTO moa_vpl VALUES ("MT14_4","070_14_4","MAT","14","4","4","'Yee‑ Erɔdi ‑yaa ‑a zi 'bhii‑ ‑ya nɛɛnɛ‑ 'na klɛ ‑a na 'le, 'bhɛɛ‑ Zaan 'a ꞊pia ‑a ni dɔɔ: «'Yaa Erodiadi klɛlɛ 'kee 'na 'le, ‑amasrɔyi 'e nɛɛnɛ‑ Filipu 'na ‑le 'kɛle‑.» ");
INSERT INTO moa_vpl VALUES ("MT14_5","070_14_5","MAT","14","5","5","'Bhɛ ya 'ɛ 'yi, Erɔdi ‑yaa Zaan dɛyrɛ ‑la ‑glin 'zi. 'Duŋ‑ ‑e ‑yaa ‑gblaan 'zi ‑zamaa' 'ɛ 'lɛɛ‑, ‑amasrɔyi ‑o 'kpɛn 'kpee ma, Mɛɛ Wiiŋfɛ' Mi Zaan ‑yaa 'ke ‑Waanbhaa' ‑lɛla' janwo mi do ‑la ‑le. ");
INSERT INTO moa_vpl VALUES ("MT14_6","070_14_6","MAT","14","6","6","'Duŋ‑ 'yee‑ Erɔdi 'ya yi ma 'fɛti 'ɛ 'bhɔle‑, 'ke Erodiadi 'lunɛ 'ɛ 'srotanle 'fɛti 'ɛ ta mu 'ɛ 'kpɛn 'yrɛ ma. 'Bhɛɛ‑ 'ke ‑a ‑za 'sɔle‑ Erɔdi ni. ");
INSERT INTO moa_vpl VALUES ("MT14_7","070_14_7","MAT","14","7","7","‑Ayile, 'ke 'yee‑ Erɔdi 'a 'gbu 'liiwli‑ 'nale‑ ‑gblanɛ 'ɛ ni dɔɔ 'ke 'bhɛ pɛ 'oo pɛ 'la 'yrɛwoa‑ ‑a ma, ‑e nu 'bhɛ 'nalɛ‑ 'bhɛ ni. ");
INSERT INTO moa_vpl VALUES ("MT14_8","070_14_8","MAT","14","8","8","'Bhɛ klɛle 'tɛ, 'ke ‑gblanɛ 'ɛ nɛɛ 'ɛ ‑ya 'kpale ‑a ‑lii dɔɔ ‑ya pe Erɔdi ni dɔɔ: «Mɛɛ Wiiŋfɛ' Mi Zaan ŋgblo 'ɛ 'na 'ŋ ni pɛle ‑koo do ta ‑gɛ.» ");
INSERT INTO moa_vpl VALUES ("MT14_9","070_14_9","MAT","14","9","9","'Bhɛ ‑za 'ɛ 'bhɛ 'yee‑ ‑bhleŋgbe Erɔdi 'wlɛyisriwoa, 'duŋ‑ ‑ya 'gbu 'liiwli‑ 'la ꞊naa ‑gblanɛ 'ɛ ni ‑yaa' 'fɛti 'ɛ ta mu 'ɛ 'kpɛn 'yrɛ ma, yaa ‑yaa sɔ ‑a ‑baŋgole 'bhɛ ‑za 'ɛ klɛle ma. ‑Ayile, 'ke ‑ya pele‑ mɛɛ mu ni dɔɔ 'mu ge Zaan ŋgblo 'ɛ 'kan, 'bhɛɛ‑ ‑o nu 'bhɛ 'le ‑a ni. ");
INSERT INTO moa_vpl VALUES ("MT14_10","070_14_10","MAT","14","10","10","'Bhɛ klɛle 'tɛ, 'kee‑ mɛɛ mu winbɔle 'yee‑ Mɛɛ Wiiŋfɛ' Mi Zaan ŋgblo 'ɛ 'kanyrɛ‑ nɔɔ‑ ‑kaso 'ɛ 'yi 'bhɛɛ‑ ‑o nu 'bhɛ 'le. ");
INSERT INTO moa_vpl VALUES ("MT14_11","070_14_11","MAT","14","11","11","‑O Zaan ŋgblo 'ɛ ꞊kpaa pɛ ‑koo do ta, 'bhɛɛ‑ ‑o ꞊nwa 'ke 'bhɛ 'le, 'ke ‑wa 'nale‑ ‑gblanɛ 'ɛ ni; 'bhɛɛ‑ ‑gblanɛ 'ɛ 'bhɛ ꞊sia, 'bhɛɛ‑ ‑e 'bhɛ 'naa‑ ‑a nɛɛ ni. ");
INSERT INTO moa_vpl VALUES ("MT14_12","070_14_12","MAT","14","12","12","'Bhɛ blaan, 'ke Zaan a ‑klaŋlanɛ mu 'ɛ 'nule ‑a gbaa 'ɛ 'silɛ‑, 'bhɛɛ‑ ‑o ‑ja ‑a binlɛ. 'Bhɛ blaan 'ezin‑, 'ke ‑o gele‑ 'bhɛ ‑za 'ɛ 'kpɛn 'yigɔɔnlɛ Zesu ni. ");
INSERT INTO moa_vpl VALUES ("MT14_13","070_14_13","MAT","14","13","13","Zesu 'bhɛ ‑za 'ɛ 'male‑, 'kee‑ gole‑ 'bhɛ yrɛ 'ɛ ꞊nɔɔ, 'bhɛɛ‑ 'kee‑ ‑a do ‑kplɛnnɛ' gele‑ ‑yitakoŋ do 'yi ‑bɔn 'yi yrɛ do nɔɔ‑. 'Duŋ‑ ‑zamaa' mu 'ɛ ‑wa geyrɛ 'ɛ 'male‑, 'ke ‑o gele‑ ‑a zi 'bhɛ yrɛ 'ɛ ꞊nɔɔ ye. ‑O ‑daa ‑o ‑din ‑wa mu 'ɛ ta, 'bhɛɛ‑ ‑o ꞊nwa ‑a zi ‑o gaan ma wɛyi‑ 'ɛ 'lɛzi‑. ");
INSERT INTO moa_vpl VALUES ("MT14_14","070_14_14","MAT","14","14","14","Zesu 'pwɛle‑ ‑yitakoŋ 'ɛ 'yi, 'ke ‑a ‑yrɛkpale ‑zamaa' ‑gbɛnɛ do ma. ‑O ‑yrɛnklaa ‑a ma, 'bhɛɛ‑ ‑e ‑waa' gadɛ mu 'ɛ 'bheele‑ ‑saan. ");
INSERT INTO moa_vpl VALUES ("MT14_15","070_14_15","MAT","14","15","15","Yromazi bhɔle, 'ke Zesu a ‑klaŋlanɛ mu 'ɛ 'nule 'a ‑din, 'bhɛɛ‑ 'ke ‑wa pele‑ ‑a ni dɔɔ: «‑Kɔɔ' ‑o ‑bɔn drɛyi' ‑gɛ, 'bhɛɛ‑ 'waati ꞊bhwa gba 'egbɔɔnle. ‑A pe mɛɛ mu 'ɛ 'kpɛn ni 'kaa ‑o ge ‑o le pɛle mu ‑lɔ ‑wa mu 'ɛ ta.» ");
INSERT INTO moa_vpl VALUES ("MT14_16","070_14_16","MAT","14","16","16","'Bhɛ klɛle 'tɛ, 'ke Zesu 'a zikpale ‑o ni dɔɔ: «‑O maza laa ‑o 'ke ‑o ge ‑o 'gbu 'bhle pɛle ‑lɔlɛ', 'ka mu 'gbu pɛle na ‑o ni.» ");
INSERT INTO moa_vpl VALUES ("MT14_17","070_14_17","MAT","14","17","17","'Bhɛɛ‑ 'duŋ‑, ‑o pe Zesu ni dɔɔ: «'bluu 'yri 'soo 'pegee kaa plɛ 'kpɔ ‑le 'o mɔɔ 'kɔɔ ‑gɛ.» ");
INSERT INTO moa_vpl VALUES ("MT14_18","070_14_18","MAT","14","18","18","'Bhɛ 'yi 'tɛ, 'ke ‑ya pele‑ ‑o ni dɔɔ: «‑Ka nu 'ke ‑o ‑le 'ŋ ni ‑gɛ.» ");
INSERT INTO moa_vpl VALUES ("MT14_19","070_14_19","MAT","14","19","19","'Bhɛ blaan, 'ke Zesu 'a 'pele ‑zamaa' 'ɛ ni 'kaa ‑o yala‑ ‑bɔn 'ɛ ta 'trɛ ma; 'kee‑ 'bluu 'soo 'ɛ 'pegee kaa plɛ 'ɛ 'sile, 'bhɛɛ‑ ‑ya ‑yrɛkpale laanima, 'kee‑ ‑Waanbhaa' 'pubɔ‑ 'seriwole 'bhɛ ma. 'Bhɛ blaan, 'kee‑ 'bluu mu 'ɛ takanle kplokplo. ‑E yanle 'bhɛ 'le, 'ke ‑yoo 'kpale ‑yaa' ‑klaŋlanɛ mu 'ɛ 'kɔɔ, 'ke ‑ya pele‑ ‑o ni dɔɔ ‑woo ‑yiciɛn' mɛɛ mu 'ɛ ma. ");
INSERT INTO moa_vpl VALUES ("MT14_20","070_14_20","MAT","14","20","20","Mɛɛ mu 'ɛ 'kpɛn pɛbhla‑, 'bhɛɛ‑ ‑o kpɛdwa‑. 'Bhɛ blaan, 'ke Zesu a ‑klaŋlanɛ mu 'ɛ ‑o ciɛ ‑nɛ vu ta plɛ 'pale ‑o blaan 'bluu kpu mu 'ɛ 'le. ");
INSERT INTO moa_vpl VALUES ("MT14_21","070_14_21","MAT","14","21","21","Mɛɛ 'la zan mu pɛ 'ɛ ꞊bhla ‑o ‑yaa mɛɛ 'waa 'soo, le mu 'pegee ‑nɛ mu laa ‑yaa 'bhɛ mɛɛ ‑lii 'ɛ ba. ");
INSERT INTO moa_vpl VALUES ("MT14_22","070_14_22","MAT","14","22","22","'Bhɛ blaan yrɛ do 'ɛ ꞊nɔɔ bhe, 'ke Zesu 'a 'pele ‑yaa' ‑klaŋlanɛ mu 'ɛ ni 'kaa ‑o 'kan ‑a ‑lɛɛ ‑sɔ ‑yitakoŋ 'ɛ 'yi, ‑yi 'yrɛ gbɛ do 'ɛ ta. 'Bhɛɛ‑ 'yee‑ 'gbu ꞊bwa ‑o ‑zanta', 'kooko‑ ‑e yan 'ploolele mɛɛ mu 'ɛ 'kpɛn ma. ");
INSERT INTO moa_vpl VALUES ("MT14_23","070_14_23","MAT","14","23","23","‑E yanle 'ploolele ‑zamaa' 'ɛ ma, 'kee‑ gele‑ ‑a 'seriwolɛ vlɛ gɔɔn do 'wiiŋ‑. ‑Bi 'ɛ ꞊pwa ‑a do ‑kplɛnnɛ' ma 'bhɛ yrɛ 'ɛ ꞊nɔɔ ye. ");
INSERT INTO moa_vpl VALUES ("MT14_24","070_14_24","MAT","14","24","24","'Bhɛ 'waati 'ɛ ba, 'ke ‑yitakoŋ 'ɛ ‑ya pleŋgwa‑ gban 'egbɔɔnle sa ‑yaa' ‑klaŋlanɛ mu 'ɛ 'le ‑yi 'ɛ ta. 'Duŋ‑ ‑ploo ‑gbɛnɛ do ‑yaa 'kan zii' ‑yi 'ɛ ta 'kee‑ nu ‑yitakoŋ 'ɛ ba ‑yrɛ ta, ‑ayile ‑yi 'pɔɔ mu 'ɛ 'yaa‑ 'pa zii' ‑yitakoŋ 'ɛ ma. ");
INSERT INTO moa_vpl VALUES ("MT14_25","070_14_25","MAT","14","25","25","Maagwlɛn ‑we bhla ꞊lwa 'ɛ ba bhɔle, 'ke Zesu 'taawole 'sanle ‑yi 'ɛ ta 'bhii‑ ‑e ‑yaa 'trɛ 'kpaa‑ ta, 'kee‑ nu ‑o ba ‑yrɛ ta. ");
INSERT INTO moa_vpl VALUES ("MT14_26","070_14_26","MAT","14","26","26","‑Yaa' ‑klaŋlanɛ mu 'ɛ ‑yrɛkpale ‑a ma 'taawoyrɛ nɔɔ‑ ‑yi 'ɛ ta, 'ke ‑gblaan ‑gbɛnɛ do 'klale ‑o ‑yi, 'bhɛɛ‑ 'ke ‑wa pele‑ 'eke‑ ni dɔɔ: «Mɛɛ jiɛlii do ‑le 'kɛle‑!» ‑Ayile, 'ke ‑o ‑gblaan ma gbe mu 'kanle‑ 'sanle. ");
INSERT INTO moa_vpl VALUES ("MT14_27","070_14_27","MAT","14","27","27","'Duŋ‑ Zesu pe ‑o ni 'bhɛ yrɛ do 'ɛ ꞊nɔɔ bhe blaale‑ dɔɔ: «‑Ka 'ka zrudɔ 'eglɔɔle, 'mi ‑le 'kɛle‑, 'ka 'laa ‑gblaanlɛ'!» ");
INSERT INTO moa_vpl VALUES ("MT14_28","070_14_28","MAT","14","28","28","'Bhɛ klɛle 'tɛ, 'ke Piɛri 'a 'pele ‑a ni dɔɔ: «Mɛɛzan, 'ke 'bhi ‑le 'kɛle‑, ‑a pe 'ŋ ni 'ŋ ge 'e ba ‑yrɛ ta ye 'ke 'ŋ 'taawo‑ ‑yi 'ɛ ta.» ");
INSERT INTO moa_vpl VALUES ("MT14_29","070_14_29","MAT","14","29","29","Zesu 'a zikpaa‑ ‑a ni dɔɔ: «Nu!» 'Bhɛ klɛle 'tɛ, 'ke Piɛri zinale ‑yitakoŋ 'ɛ 'yi, 'kee‑ 'taawole 'sanle ‑yi 'ɛ ta 'kee‑ ge Zesu ba ‑yrɛ ta. ");
INSERT INTO moa_vpl VALUES ("MT14_30","070_14_30","MAT","14","30","30","'Duŋ‑ ‑ya yelawoa 'bhii‑ ‑ploo 'ɛ 'yaa‑ 'kan zii' 'eglɔɔle, 'ke ‑gblaan 'klale 'a ‑yi, 'bhɛɛ‑ 'kee‑ wlale 'sanle‑ ‑yi 'ɛ ꞊la. ‑Ayile, 'kee‑ ‑gbekanle dɔɔ: «Mɛɛzan, 'ŋ go ‑za 'yi ‑gɛ!» ");
INSERT INTO moa_vpl VALUES ("MT14_31","070_14_31","MAT","14","31","31","'Bhɛ klɛle 'tɛ, 'ke Zesu 'e gbɛ 'trole ‑a ba ‑yrɛ ta, 'bhɛɛ‑ 'ke 'bhɛ 'a 'kunle 'bhɛ yrɛ do 'ɛ ꞊nɔɔ bhe, 'bhɛɛ‑ 'ke 'bhɛ 'a 'pele‑ 'a ni dɔɔ: «‑Mɛle ‑kla 'yaa 'e kpa 'egbɛnɛle 'mi 'yi ɛɛ? 'Bhɛɛ‑ ‑mɛle ꞊kla 'yee 'kpee ꞊kla plɛ 'mi ma ɛɛ?» ");
INSERT INTO moa_vpl VALUES ("MT14_32","070_14_32","MAT","14","32","32","Zesu 'pegee Piɛri ‑saan ‑yitakoŋ 'ɛ 'yi, 'bhɛɛ‑ 'ke ‑ploo 'kanle‑ 'ɛ dulale. ");
INSERT INTO moa_vpl VALUES ("MT14_33","070_14_33","MAT","14","33","33","'Bhɛ 'yi 'tɛ, Zesu a ‑klaŋlanɛ mu 'la 'yaa‑ ‑yitakoŋ 'ɛ 'yi, ‑wa ꞊gbaa ‑o 'kpɔ zɛnlele ‑a ‑lɛɛ, 'bhɛɛ‑ 'ke ‑wa pele‑ ‑a ni dɔɔ: «Wlan 'ɛ ni, 'yoo‑ 'ke ‑Waanbhaa' Gbe 'ɛ 'le kpataakpa!» ");
INSERT INTO moa_vpl VALUES ("MT14_34","070_14_34","MAT","14","34","34","Zesu 'pegee ‑yaa' ‑klaŋlanɛ mu 'ɛ 'yanle‑ ‑draa 'yi 'ɛ takanlele, 'ke ‑o zinale Zenezarɛti 'klɛɛn 'ɛ 'yi. ");
INSERT INTO moa_vpl VALUES ("MT14_35","070_14_35","MAT","14","35","35","'Bhɛ ꞊nɔɔ mɛɛ mu 'ɛ ‑o Zesu madɔle, 'ke ‑wa nuza 'ɛ zɛnle‑ yrɛkpɛn‑ ꞊nɔɔ, 'bhɛɛ‑ 'ke ‑o nule‑ gadɛ mu 'ɛ 'kpɛn 'le ‑a ni. ");
INSERT INTO moa_vpl VALUES ("MT14_36","070_14_36","MAT","14","36","36","'Bhɛ gadɛ mu 'ɛ 'yaa‑ ‑sromabɔ 'zi Zesu ni dɔɔ ‑ya 'to 'ke ‑o sɔ ‑o gbɛ yanle‑ ‑a ta dunɛ‑ gbɔɔn 'ɛ ma. Gadɛ mu 'la 'kpɛn 'bhɛ ꞊kla 'mu 'bheela‑. ");
INSERT INTO moa_vpl VALUES ("MT15_1","070_15_1","MAT","15","1","1","Farizi mu 'ke mu 'pegee 'Toŋ daan mu 'ke mu ‑daa Zeruzalɛmu, 'bhɛɛ‑ ‑o ꞊nwa Zesu 'lrɔkpalɛ dɔɔ: ");
INSERT INTO moa_vpl VALUES ("MT15_2","070_15_2","MAT","15","2","2","«‑Mɛle ꞊kla 'bhɛɛ‑ 'yaa‑ ‑klaŋlanɛ mu 'ɛ ‑woo ‑kɔɔ' ‑gbɔɔ mu 'si ta za mu 'la ꞊twa ‑kɔɔ' ni 'mu 'yisiɛ zii' ɛɛ? ‑Amasrɔyi ‑kɔɔa' 'si ta za mu 'ɛ ma, ‑woo gbɛ mafɛ gɔnɛ‑ 'la gbɛɛn‑, 'woo‑ mu laa ‑o gbɛ mafɛ 'bhɛ gbɛɛn‑, 'bhɛɛ‑ ‑o pɛbhle.» ");
INSERT INTO moa_vpl VALUES ("MT15_3","070_15_3","MAT","15","3","3","'Bhɛ klɛle 'tɛ, 'ke Zesu 'a 'lɛkunle ‑o ni dɔɔ: «'Bhɛɛ‑ 'ka mu, ‑mɛle ꞊kla 'bhɛɛ‑ 'ka mu ‑Waanbhaa' a 'toŋ 'ɛ 'yisiɛ‑ 'kaa bhaaplɛŋ mu ‑si ta za mu ‑klɔsikun zayi' ɛɛ? ");
INSERT INTO moa_vpl VALUES ("MT15_4","070_15_4","MAT","15","4","4","‑Amasrɔyi, ‑Waanbhaa' 'a ꞊pia dɔɔ: ‹'E dɛ 'pegee 'e nɛɛ ‑lɛdɔ' ‑a ma, 'bhɛɛ‑ 'ke mɛɛ 'la zan 'bhɛ dɛ 'pegee 'bhɛ nɛɛ 'daŋganwoa 'bhɛ zan 'ɛ 'bhɛ ‑o 'ke dɛpɛ 'le.› ");
INSERT INTO moa_vpl VALUES ("MT15_5","070_15_5","MAT","15","5","5","'Bhɛɛ‑ 'duŋ‑, 'ka mu pe dɔɔ 'ke mɛɛ do 'a ꞊pia 'bhɛ dɛ 'pegee 'bhɛ nɛɛ ni dɔɔ: ‹'Ŋ 'yaa‑ nu bhɔlɛ 'ka ba 'ŋ 'kɔɔpɛ‑ mu 'la 'le, 'ŋ 'mu ꞊naa ‑Waanbhaa' ni›, 'ke 'bhɛ ꞊kla, 'bhɛ zan 'ɛ maza laa ‑o ‑li 'ke 'bhɛ bhɔ 'bhɛ dɛ 'pegee 'bhɛ nɛɛ ba. ");
INSERT INTO moa_vpl VALUES ("MT15_6","070_15_6","MAT","15","6","6","'Bhɛ klɛgbɛya 'ɛ 'yi bhe, 'ka ‑Waanbhaa' a ‑jan 'ɛ 'lɛgaa‑ 'kaa‑ bhaaplɛŋ mu 'si ta za mu ‑klɔsikun zayi'. ");
INSERT INTO moa_vpl VALUES ("MT15_7","070_15_7","MAT","15","7","7","Mɛɛ ‑yrɛkɔɔza klɛ mu! 'Zoo 'yaa‑ ‑Waanbhaa' ‑lɛla' janwo mi Ezai zi ‑e ‑jan 'la ꞊woa 'ka ba zayi' dɔɔ: ");
INSERT INTO moa_vpl VALUES ("MT15_8","070_15_8","MAT","15","8","8","‑Waanbhaa' pe 'kaa: ‹'An mɛɛ mu 'lɛɛ‑ ‑woo 'ŋ 'lɛdɔ‑ a ma ‑o ‑liiwli' ‑la ‑le. 'Duŋ‑ ‑o zru pleŋgole ‑o 'ŋ ma 'egbɔɔnle. ");
INSERT INTO moa_vpl VALUES ("MT15_9","070_15_9","MAT","15","9","9","‑Woo 'ŋ gba 'zi bhaama, ‑amasrɔyi ‑o mɛɛ mu daan 'ke bhaaplɛŋ mu a 'toŋ 'te ‑la ‑le.›» ");
INSERT INTO moa_vpl VALUES ("MT15_10","070_15_10","MAT","15","10","10","Zesu ‑zamaa' 'ɛ 'siile ‑a ba ‑yrɛ ta, 'ke ‑ya pele‑ ‑o ni dɔɔ: «'Ŋ ‑jan 'la 'wo zii' ‑gɛ, ‑ka 'ka 'trɔnkpa 'a ‑la 'elrele, 'bhɛɛ‑ ‑kaa ‑yima': ");
INSERT INTO moa_vpl VALUES ("MT15_11","070_15_11","MAT","15","11","11","‑O pelɛ 'la 'wla zii' mɛɛ ‑lii, 'bhɛ 'laa 'a 'kpee 'ɛ 'triŋdɔ‑, 'duŋ‑ ‑jan 'la da 'zi ‑a 'gbu 'lii 'bhɛ ‑le ‑a 'kpee 'triŋdɔ‑.» ");
INSERT INTO moa_vpl VALUES ("MT15_12","070_15_12","MAT","15","12","12","'Bhɛ ꞊nɔɔ bhe, 'ke ‑yaa' ‑klaŋlanɛ mu 'ɛ ‑woo mabɛɛnle ‑a ‑din, 'bhɛɛ‑ 'ke ‑wa pele‑ ‑a ni dɔɔ: «'Ya 'yaango‑ 'bhii‑ 'e ꞊wlaa Farizi mu 'ɛ 'yi 'e 'wojan‑ mu 'ɛ 'le ɛɛ?» ");
INSERT INTO moa_vpl VALUES ("MT15_13","070_15_13","MAT","15","13","13","'Bhɛ klɛle 'tɛ, 'ke ‑ya pele‑ ‑o ni 'kaa: «‑Yri diiŋ 'oo ‑yri diiŋ 'la 'ŋ Dɛ 'la ‑yoo laanima yaa 'bhɛ 'sɔlɛ‑, ‑e nu 'bhɛ 'yrolɛ‑. ");
INSERT INTO moa_vpl VALUES ("MT15_14","070_15_14","MAT","15","14","14","‑Ka ‑o 'to 'srɔ: ‑Woo 'bhii‑ mɛɛ ‑yrɛ 'wi mu 'la 'ke ‑woo 'eke‑ ‑lɛdɔɔ' 'zi. 'Duŋ‑ 'ke mɛɛ ‑yrɛ 'wi mi do ‑o ‑yrɛ 'wi mi ‑bhɛɛke' do ‑lɛdɔɔ' 'zi, ‑o mɛɛ plɛ nu bɔlɛ ‑gluu do 'yi.» ");
INSERT INTO moa_vpl VALUES ("MT15_15","070_15_15","MAT","15","15","15","'Bhɛ 'yi bhe, 'ke Piɛri 'a 'pele dɔɔ: «'Bhɛ ‑gɔɔn 'la bhe, 'bhɛ 'yipe 'o ni doo.» ");
INSERT INTO moa_vpl VALUES ("MT15_16","070_15_16","MAT","15","16","16","'Bhɛ klɛle 'tɛ, 'ke Zesu 'a 'pele 'a ni dɔɔ: «'Ka mu 'ezin‑, 'ka mu 'laa sɔ 'bhɛ ‑jan 'ɛ 'yimale ɛɛ? ");
INSERT INTO moa_vpl VALUES ("MT15_17","070_15_17","MAT","15","17","17","'Ka 'laa 'yaango‑ 'bhii‑ pɛ 'oo pɛ 'la wla bhaaplɛŋ ‑lii ‑e 'kan ‑a vi 'ɛ 'yi, 'bhɛɛ‑ ‑e klɛ 'ke blinpɛ 'le boolazi. ");
INSERT INTO moa_vpl VALUES ("MT15_18","070_15_18","MAT","15","18","18","'Duŋ‑, ‑jan 'la 'bhɛ pwɛ bhaaplɛŋ ‑lii, 'bhɛ ‑daa 'pe ‑a 'gbu 'kpee, 'bhɛɛ‑ 'bhɛ ‑le bhaaplɛŋ 'kpee 'triŋdɔ‑. ");
INSERT INTO moa_vpl VALUES ("MT15_19","070_15_19","MAT","15","19","19","‑Amasrɔyi, ‑za 'yɔɔ‑ mu 'lɛɛ‑ 'wole‑ da bhaaplɛŋ 'kpee: Mɛɛ dɛ zru oo, ‑yanbhɔɔya zru oo, ‑faan zru oo, bhla pe zru oo, mɛɛ ‑bhɛɛke' 'tɔsiɛle zru, 'bhɛ 'pegee ‑Waanbhaa 'tɔsiɛle. ");
INSERT INTO moa_vpl VALUES ("MT15_20","070_15_20","MAT","15","20","20","'Woo pɛ mu 'la bhe 'wole‑ bhaaplɛŋ 'kpee 'triŋdɔ‑; 'duŋ‑ 'ke mɛɛ 'la zan laa 'bhɛ gbɛ mafɛlɛ 'bhii‑ ‑wa klɛ gɔnɛ‑ 'la gbɛɛn‑ ‑kɔɔa' 'si ta za 'ɛ ma, 'bhɛɛ‑ ‑e pɛbhla‑; 'bhɛ ‑za 'ɛ 'bhɛ 'laa 'bhɛ zan 'kpee 'triŋdɔ‑.» ");
INSERT INTO moa_vpl VALUES ("MT15_21","070_15_21","MAT","15","21","21","'Bhɛ blaan, Zesu ‑gwa 'bhɛ yrɛ 'ɛ ꞊nɔɔ, 'bhɛɛ‑ ‑e ‑ja Tiri ‑wa 'ɛ 'pegee Sidɔn ‑wa 'ɛ ‑woo 'klɛɛn 'la 'yi 'bhɛ 'yi. ");
INSERT INTO moa_vpl VALUES ("MT15_22","070_15_22","MAT","15","22","22","‑Woo ‑yrɛkpale 'tɛ, 'ke Kanaa 'klɛɛn 'yi le do 'la 'bhɛ 'yaa‑ 'bhɛ yrɛ 'ɛ ꞊nɔɔ ye, 'bhɛ 'nule 'tɛnlɛ‑ Zesu ma, 'bhɛɛ‑ 'bhɛ ‑gbekaan dɔɔ: «Mɛɛzan, Davidi 'nranɛ‑, 'ŋ 'yrɛnkla 'e ma. 'Zina ‑o ‑yrɛnkpa' zii' 'eyɔɔle 'ŋ 'lunɛ 'ɛ ta.» ");
INSERT INTO moa_vpl VALUES ("MT15_23","070_15_23","MAT","15","23","23","'Duŋ‑ Zesu 'laa ‑za 'kedo‑ 'kpɔ 'lɛkunlɛ a ni. 'Bhɛla‑ ‑yile, ‑yaa' ‑klaŋlanɛ mu 'ɛ ‑o nule‑ ‑a ‑din, 'ke ‑wa pele‑ ‑a ni dɔɔ: «Le 'lɛɛ‑ ‑gbin ‑kɔɔ' 'zi doo, ‑amasrɔyi ‑yoo ‑gbekan' zii' ‑kɔɔ' zi.» ");
INSERT INTO moa_vpl VALUES ("MT15_24","070_15_24","MAT","15","24","24","'Bhɛ klɛle 'tɛ, 'ke Zesu 'a zikpale ‑o ni dɔɔ: «Mɛɛ 'la zan mu ‑o 'bhii‑ ‑bhlaa mu 'la ꞊nia Izraɛli mu 'ɛ ba ‑Waanbhaa' 'ŋ 'winbwa‑ 'mu ‑la 'te ba.» ");
INSERT INTO moa_vpl VALUES ("MT15_25","070_15_25","MAT","15","25","25","'Bhɛ 'yi bhe, 'ke 'yee‑ Kanaa le 'ɛ 'nule ‑a 'kpɔ zɛnlɛ Zesu 'lɛɛ, 'bhɛɛ‑ 'ke ‑ya pele‑ 'kaa: «Mɛɛzan, nu bhɔ 'ŋ ba!» ");
INSERT INTO moa_vpl VALUES ("MT15_26","070_15_26","MAT","15","26","26","'Bhɛ 'yi 'tɛ, 'ke Zesu 'a 'pele ‑a ni dɔɔ: «'Kee pɛle ꞊kwan ‑nɛ mu 'ɛ 'kɔɔ, 'bhɛɛ‑ 'ke ‑ya ‑blinna ‑gbaan' mu ni, 'bhɛ 'laa lele.» ");
INSERT INTO moa_vpl VALUES ("MT15_27","070_15_27","MAT","15","27","27","'Yee‑ le 'ɛ pe 'ezin‑ Zesu ni dɔɔ: «Wlan ‑le 'bhɛ 'le Mɛɛzan, 'duŋ‑ ‑gbaannɛ mu 'ɛ ‑woo zan mu blaan pɛle piinɛ‑ mu 'la ‑balaa' 'trɛ ma 'mu ‑la bhle!» ");
INSERT INTO moa_vpl VALUES ("MT15_28","070_15_28","MAT","15","28","28","'Bhɛ klɛle 'tɛ, 'ke Zesu 'a 'pele ‑a ni dɔɔ: «'E le! 'Yee ꞊kpaa 'egbɛnɛle 'le mi 'yi! Bhaa 'yoo‑ pɛ 'la zi, ‑Waanbhaa' 'bhɛɛ‑ 'na 'e ni.» 'Bhɛ 'yi 'tɛ, 'ke Zesu 'a 'lunɛ 'ɛ bheele' 'bhɛ 'waati do 'kpɔ 'ɛ ba. ");
INSERT INTO moa_vpl VALUES ("MT15_29","070_15_29","MAT","15","29","29","'Bhɛ blaan, Zesu ‑gwa 'bhɛ yrɛ 'ɛ ꞊nɔɔ, 'kee‑ gele‑ Galile ‑draa 'ɛ 'lɛ ma. ‑E ‑ja yaalɛ vlɛ gɔɔn do 'wiiŋ‑. ");
INSERT INTO moa_vpl VALUES ("MT15_30","070_15_30","MAT","15","30","30","'Bhɛ klɛle 'tɛ, 'ke ‑zamaa' ‑bebe 'nule‑ 'palɛ‑ ‑a ta. ‑O ꞊nwa 'ke mɛɛ gaan 'siɛle‑ mu oo, mɛɛ ‑yrɛ 'wile‑ mu oo, ‑flugba mu oo, 'bhobho mu 'pegee gadɛ mu ‑glɔɔn ‑bebe 'le ‑a ni. ‑O 'mu 'kpɛn 'yilaa‑ ‑a gaan ma, 'bhɛɛ‑ ‑yoo ‑bheela. ");
INSERT INTO moa_vpl VALUES ("MT15_31","070_15_31","MAT","15","31","31","Mɛɛ mu 'ɛ ‑o 'bhobho mu ‑bheeyrɛ' yelawoa 'ke 'mu ‑janwo', 'bhɛ 'pegee ‑o ‑flugba mu 'taawole ꞊ya, 'bhɛɛ‑ ‑o mɛɛ gaan 'siɛle‑ mu ‑bheele' ꞊ya, 'bhɛ 'pegee ‑o mɛɛ ‑yrɛ 'wile‑ mu ‑yrɛ 'liiplooyrɛ 'la ꞊ya 'ke 'mu yrɛ ma ye, 'bhɛ ‑o 'kpɛn 'kpeelɛnia ‑o ma. 'Bhɛla‑ ‑yile, ‑o ‑yaa Izraɛli mu a ‑Waanbhaa' 'ɛ 'tɔbhɔ zii'. ");
INSERT INTO moa_vpl VALUES ("MT15_32","070_15_32","MAT","15","32","32","Zesu ‑yaa' ‑klaŋlanɛ mu 'ɛ 'siila‑, 'bhɛɛ‑ ‑e pe ‑o ni dɔɔ: «Mɛɛ mu 'lɛɛ‑ ‑o ‑yrɛnkla' zii' 'ŋ ma, ‑amasrɔyi ‑o ‑yrekpaa' yaga ‑le ‑gɛ 'ke ‑woo 'ŋ zi, 'bhɛɛ‑ pɛle 'kedo‑ 'kpɔ 'laa ‑o 'kɔɔ. 'Naa ‑o ‑a zi 'ke ‑o ge ‑o 'kpee 'fleŋ‑ 'le ‑o ba ‑lɛ ma. ‑Amasrɔyi ‑o sɔ baale' ‑o ge bhla 'ɛ zi zi 'ɛ 'lii gbɔn 'ɛ 'kɔɔ.» ");
INSERT INTO moa_vpl VALUES ("MT15_33","070_15_33","MAT","15","33","33","'Bhɛ klɛle 'tɛ, 'ke ‑yaa' ‑klaŋlanɛ mu 'ɛ ‑wa ‑lrɔkpale dɔɔ: «'O nu 'sɔlɛ‑ mɛɛ mu 'lɛɛ‑ 'kpɛn 'lɛbɔ‑ pɛle ‑srɔɔwolɛ 'bhɛ ‑bɔn drɛyi' yrɛ 'lɛɛ‑ ꞊nɔɔ 'naa‑ ma ɛɛ?» ");
INSERT INTO moa_vpl VALUES ("MT15_34","070_15_34","MAT","15","34","34","Zesu ‑o ‑lrɔkpaa dɔɔ: «'bluu 'wɛɛ‑ ‑le 'ka 'kɔɔ ɛɛ?» 'Bhɛɛ‑ ‑o pe ‑a ni dɔɔ: «'Srwaplɛ‑, 'bhɛɛ‑ kaa 'fiɛntrɔnnɛ 'ke mu.» ");
INSERT INTO moa_vpl VALUES ("MT15_35","070_15_35","MAT","15","35","35","'Bhɛ 'yi 'tɛ, 'ke Zesu 'a 'pele ‑zamaa' 'ɛ ni dɔɔ ‑o yala‑ 'trɛ ma. ");
INSERT INTO moa_vpl VALUES ("MT15_36","070_15_36","MAT","15","36","36","'Bhɛɛ‑ 'kee‑ 'bluu 'yri 'srwaplɛ‑ 'ɛ 'pegee kaa mu 'ɛ 'sile, 'bhɛɛ‑ 'kee‑ ‑Waanbhaa' 'pubɔle 'mu ma. 'Bhɛ blaan, 'ke ‑yoo takanle kplokplo, 'bhɛɛ‑ 'ke ‑yoo 'kpale ‑yaa' ‑klaŋlanɛ mu 'ɛ 'kɔɔ‑, 'bhɛɛ‑ 'ke 'mu ‑o ‑yiciɛnle mɛɛ mu 'ɛ ma. ");
INSERT INTO moa_vpl VALUES ("MT15_37","070_15_37","MAT","15","37","37","‑O 'kpɛn pɛbhla‑, 'bhɛɛ‑ ‑o kpɛdwa‑. 'Bhɛɛ‑ ‑o ciɛ ‑nɛ ꞊yan 'srwaplɛ‑ ‑la ‑paa 'ke 'bluu kpu ‑vin mu 'la ꞊bwa ‑o blaan 'mu 'le. ");
INSERT INTO moa_vpl VALUES ("MT15_38","070_15_38","MAT","15","38","38","Mɛɛ 'waa yiziɛ ‑le pɛ 'ɛ ꞊bhla, 'ke 'bhɛ 'laa kpa le mu 'ɛ 'pegee ‑nɛ mu 'ɛ ta. ");
INSERT INTO moa_vpl VALUES ("MT15_39","070_15_39","MAT","15","39","39","‑O yanle pɛ 'ɛ 'bhlelele, 'ke Zesu 'ploole ‑zamaa' mu 'ɛ ma 'kaa ‑o ge ‑o ba. 'Bhɛ blaan, 'ke 'yee‑ 'gbu bɔle‑ ‑yitakoŋ do 'yi, 'bhɛɛ‑ 'kee‑ gele‑ Magadan ba 'klɛɛn 'ɛ 'yi. ");
INSERT INTO moa_vpl VALUES ("MT16_1","070_16_1","MAT","16","1","1","‑Yrekpaa' do, Farizi mu 'ɛ 'pegee Saduse mu 'ɛ ‑o ꞊nwa ‑jan bhee bɔlɛ Zesu 'lɛɛ. ‑O pe a ni dɔɔ: «'Kee‑ da Laanima ‑Waanbhaa' 'gbu 'ɛ ba, 'bhɛ 'wlata‑ 'tɔɔmasie do zrɔn 'o ni 'sɔle‑ maza do klɛlele 'o 'yrɛ ma ‑gɛ doo.» ");
INSERT INTO moa_vpl VALUES ("MT16_2","070_16_2","MAT","16","2","2","'Bhɛ 'yi 'tɛ, 'ke Zesu 'a zikpale ‑o ni dɔɔ: «'Ke yromazi ‑yretɛbhɛ baa‑ bhla ꞊bhwa, 'bhɛɛ‑ 'ke 'ka laflɛ' 'tranle ꞊ya, 'kaa pe dɔɔ: ‹Yrɛ ma 'kanle nu klɛlɛ 'elrele too›. ");
INSERT INTO moa_vpl VALUES ("MT16_3","070_16_3","MAT","16","3","3","'Bhɛɛ‑ zrwan 'tutu 'ɛ zi, 'ke 'ka laflɛ' 'ɛ tilale ꞊ya, 'kaa pe dɔɔ: ‹La nu banlɛ ‑zɔn›. 'Bhɛ klɛgbɛya 'ɛ gbɛɛn‑ bhe, 'ka sɔ laflɛ' ma ‑tɔɔmasie mu 'ɛ 'yidɔle, 'bhɛɛ‑ 'ka 'laa sɔ ‑Waanbhaa' a pɛ 'waati mu 'ɛ ‑tɔɔmasie 'yidɔle ɛɛ? ");
INSERT INTO moa_vpl VALUES ("MT16_4","070_16_4","MAT","16","4","4","'Saanigɛ mu 'ɛ ‑woo 'eyɔɔle, 'bhɛɛ‑ ‑o zru laa ‑o do ‑Waanbhaa' ni. ‑Wa zi 'bhii‑ ‑o 'sɔle‑ maza do klɛ ‑o ‑yrɛ ma, 'duŋ‑ waa nu 'sɔle‑ maza ‑bhɛɛke' do 'kpɔ klɛlɛ ‑o ‑yrɛ ma, 'ke yaa 'e go Zonasi a pɛ 'ɛ ba.» 'Bhɛ blaan, 'kee‑ jilale, 'bhɛɛ‑ 'ke ‑yoo dulale 'tole ‑o dulayrɛ 'ɛ ꞊nɔɔ. ");
INSERT INTO moa_vpl VALUES ("MT16_5","070_16_5","MAT","16","5","5","‑O ‑yaa 'kan zii' bhla 'la ba ‑draa 'yrɛ gbɛ do 'ɛ ta, 'bluu 'sile‑ ꞊nia Zesu a ‑klaŋlanɛ mu 'ɛ 'kpee. ");
INSERT INTO moa_vpl VALUES ("MT16_6","070_16_6","MAT","16","6","6","Zesu pe ‑o ni dɔɔ: «‑Ka 'ka 'yrɛkpa 'ka 'gbu ba 'elrele. 'Ka 'laa 'tolɛ‑ 'ke Farizi mu 'ɛ 'pegee Saduse mu 'ɛ ‑waa' 'bluu ‑pɛɛ 'wlɛn 'sɛkɛ 'ɛ ‑e 'ka 'yini‑.» ");
INSERT INTO moa_vpl VALUES ("MT16_7","070_16_7","MAT","16","7","7","'Bhɛ 'yi bhe, 'ke ‑yaa' ‑klaŋlanɛ mu 'ɛ ‑wa pele 'sanle ‑o 'gbu 'kpee dɔɔ: «'Bluu 'sile‑ 'la ꞊nia ‑kɔɔ' 'kpee ‑e 'bhɛɛ‑ ma ‑janwo' zii' bhe.» ");
INSERT INTO moa_vpl VALUES ("MT16_8","070_16_8","MAT","16","8","8","Zesu ‑o 'kpeejan‑ 'ɛ dɔle, 'ke ‑ya pele‑ ‑o ni dɔɔ: «'E! Mɛɛ mu, ‑mɛle ꞊kla 'ka ‑o 'ka 'kpeelɛdan 'zi 'bhɛ gbɛɛn‑ ɛɛ 'ke 'kaa pe dɔɔ 'ka 'laa 'bluu 'la 'silɛ‑ 'bhɛla‑ ‑zayi' 'ŋ ‑janwo' zii' 'bhɛ gbɛɛn‑ bhe ɛɛ? 'Kaa‑ 'kpaleya 'ɛ ‑yoo 'fiɛntrɔnnɛ 'dɛ! ");
INSERT INTO moa_vpl VALUES ("MT16_9","070_16_9","MAT","16","9","9","'Ka 'laa 'bhɛ 'yimalɛ ‑li ɛɛ? 'Ŋ 'bluu 'soo 'la takaan‑ kplokplo mɛɛ 'waa 'soo 'ɛ ma, 'bhɛɛ‑ 'ka ciɛ ‑nɛ ꞊yan yɛkɛ‑ 'la ꞊paa ‑o blaan 'bluu kpu mu 'ɛ 'le, 'bhɛ ‑za 'ɛ ‑gwa gban ‑gun 'ka 'kpee ɛɛ? ");
INSERT INTO moa_vpl VALUES ("MT16_10","070_16_10","MAT","16","10","10","'Bhɛɛ‑ 'ŋ 'bluu 'srwaplɛ‑ 'la takaan‑ mɛɛ 'waa yiziɛ 'ɛ ma, 'bhɛ 'pegee 'ka ciɛ ‑nɛ ꞊yan yɛkɛ‑ 'la ꞊paa ‑o blaan 'bluu kpu mu 'ɛ 'le, 'bhɛ ‑za 'ɛ ‑gwa gban ‑gun 'ka 'kpee 'ezin‑ ɛɛ? ");
INSERT INTO moa_vpl VALUES ("MT16_11","070_16_11","MAT","16","11","11","'Ka 'laa 'yimalɛ dɔɔ 'naa ‑yaa ‑we 'zi 'bluu ‑zeze 'gbu 'le. ‑Ka 'ka 'yrɛkpa 'ka 'gbu ba 'elrele! 'Ka 'laa 'tolɛ‑ 'ke Farizi mu 'ɛ 'pegee Saduse mu 'ɛ ‑waa' 'bluu ‑pɛɛ 'wlɛn 'sɛkɛ 'ɛ ‑e 'ka 'yini.» ");
INSERT INTO moa_vpl VALUES ("MT16_12","070_16_12","MAT","16","12","12","'Bhɛ klɛle 'tɛ, 'ke ‑yaa' ‑klaŋlanɛ mu 'ɛ ‑wa ‑yimale dɔɔ yaa pelɛ ‑o ni 'kaa ‑woo ‑yrɛkpa' ‑o 'gbu ba 'elrele 'bluu ‑pɛɛ 'wlɛn 'sɛkɛ ‑zeze 'gbu ma, 'duŋ‑ ‑e ‑yaa pe 'zi ‑o ni dɔɔ ‑woo 'gbu 'kun 'elrele Farizi mu 'ɛ 'pegeeSaduse mu 'ɛ ‑waa' mɛɛ daangbɛya ‑yɔɔ' 'ɛ 'bhɛɛ‑ ma. ");
INSERT INTO moa_vpl VALUES ("MT16_13","070_16_13","MAT","16","13","13","'Bhɛ blaan, 'ke Zesu gele‑ 'klɛɛn 'la ‑yoo Sezare Filipu ‑wa 'ɛ ‑din 'bhɛ 'yi. ‑O bhɔle 'bhɛ ꞊nɔɔ, 'kee‑ ‑yaa' ‑klaŋlanɛ mu 'ɛ 'lrɔkpale dɔɔ: «Mɛɛ mu 'ɛ ‑woo Bhaaplɛŋ Gbe 'ɛ 'kun zii' mɛɛ ‑glɔɔn 'ɛ ‑dela ‑le ɛɛ?» ");
INSERT INTO moa_vpl VALUES ("MT16_14","070_16_14","MAT","16","14","14","'Bhɛ klɛle 'tɛ, 'ke ‑wa ‑lɛkunle ‑a ni dɔɔ: «Mɛɛ 'ke mu pe dɔɔ 'yoo‑ 'ke Mɛɛ Wiiŋfɛ' Mi Zaan 'le, 'bhɛɛ‑ ‑a 'ke mu pe dɔɔ Eli ‑le 'e 'le, 'bhɛɛ‑ ‑a ‑bhɛɛke' mu pe 'ezin‑ dɔɔ 'ke 'yaa klɛlɛ Zeremi 'le, 'yoo‑ 'ke ‑Waanbhaa' ‑lɛla' janwo mi 'ɛ do 'le.» ");
INSERT INTO moa_vpl VALUES ("MT16_15","070_16_15","MAT","16","15","15","'Bhɛ 'yi, 'ke Zesu ‑o ‑lrɔkpale dɔɔ: «'Bhɛɛ‑ 'ka mu 'gbu 'lɛɛ‑, 'ka mu pe 'ŋ ma 'nale‑ ɛɛ?» ");
INSERT INTO moa_vpl VALUES ("MT16_16","070_16_16","MAT","16","16","16","'Bhɛ klɛle 'tɛ, 'ke Simɔ Piɛri 'a 'lɛkunle 'a ni dɔɔ: «'Yoo‑ 'ke Mɛɛ ‑Bhee Mi ‑Kpɔsɔɔ 'gbu 'ɛ 'bhɛɛ‑ 'le, ‑Waanbhaa' 'la ‑ya ‑yrɛ ma, 'bhi ‑le 'ke ‑a Gbe 'ɛ 'le.» ");
INSERT INTO moa_vpl VALUES ("MT16_17","070_16_17","MAT","16","17","17","'Bhɛ 'yi 'tɛ, 'ke Zesu 'a 'pele 'a ni 'tɛ dɔɔ: «Zonasi gbe Piɛri, 'yaa‑ pɛ ‑yinra'! ‑Amasrɔyi 'e wlan ma jan 'la ꞊woa bhe, bhaaplɛŋ 'kedo‑ 'kpɔ laa 'bhɛ 'kpalɛ‑ 'e 'lii, 'ke yaa 'e go 'ŋ Dɛ 'la ‑yoo laanima 'bhɛ do ‑kplɛn ba. ");
INSERT INTO moa_vpl VALUES ("MT16_18","070_16_18","MAT","16","18","18","'Bhɛɛ‑ 'mi pe 'e ni dɔɔ: ‑Woo 'e sii Piɛri, 'bhɛ 'yi ‑le dɔɔ vlɛ, 'bhɛɛ‑ 'duŋ‑, 'mi nu 'ke mɛɛ 'la zan mu 'mu ꞊kpaa 'mi 'yi 'mu ‑lɛdo' 'ɛ gaan bɔlɛ vlɛ 'la ta, 'bhi ‑le 'bhɛ 'le. 'Ali‑ ga 'fuu 'laa nu 'sɔlɛ‑ 'bhɛ ta. ");
INSERT INTO moa_vpl VALUES ("MT16_19","070_16_19","MAT","16","19","19","'Ŋ nu laanima ‑bhleŋgbeya ‑wa 'ɛ 'gborobhɛ mu 'ɛ gbɛkpalɛ 'e 'kɔɔ‑: 'Kee pɛ 'la 'yrela‑ 'trɛ ta ‑gɛ, ‑o nu 'bhɛɛ‑ 'yrelɛ‑ laflɛ' 'yi; 'duŋ‑ 'kee‑ pɛ 'la 'ploola‑ 'trɛ ta ‑gɛ, ‑o nu 'bhɛɛ‑ 'ploolɛ‑ laflɛ' 'yi 'ezin‑.» ");
INSERT INTO moa_vpl VALUES ("MT16_20","070_16_20","MAT","16","20","20","'Bhɛ blaan, 'ke Zesu ‑yaa' ‑klaŋlanɛ mu 'ɛ 'lɛmazɔnle dɔɔ waa pelɛ mɛɛ ‑bhɛɛke' do 'kpɔ ni 'kaa 'yoo‑ 'ke Mɛɛ ‑Bhee Mi ‑Kpɔsɔɔ 'ɛ 'bhɛɛ‑ 'le. ");
INSERT INTO moa_vpl VALUES ("MT16_21","070_16_21","MAT","16","21","21","‑A 'san 'bhɛ yi 'ɛ ma, Zesu 'a 'lɛɛ za mu 'ɛ ma janwole ‑saan kpataakpa ‑yaa' ‑klaŋlanɛ mu 'ɛ ni, 'ke ‑ya pe ‑o ni dɔɔ: «‑A ‑lɛdulale ‑o ‑Waanbhaa 'kɔɔ 'ke 'ŋ ge Zeruzalɛmu, 'bhɛɛ‑ 'gwlaan‑ gblaan mu 'ɛ 'pegee *'Sraka 'lɛna ‑kuŋlii mu 'ɛ, 'bhɛɛ‑ *'Toŋ daan mu 'ɛ, ‑o ‑yrɛnkpa' 'mi ta 'ebebele 'bhɛ ꞊nɔɔ. 'Bhɛɛ‑ ‑o nu 'ŋ dɛlɛ 'tɛ, 'duŋ‑ 'ŋ nu bwelɛ gale ba 'ŋ gale blaan ‑yrekpaa' yaga mi ma.» ");
INSERT INTO moa_vpl VALUES ("MT16_22","070_16_22","MAT","16","22","22","'Bhɛ klɛle 'tɛ, 'ke Piɛri Zesu 'siile mɛɛ mu 'ɛ 'yrɛ ‑gɔma', 'bhɛɛ‑ 'kee‑ ‑lale' 'sanle Zesu ta dɔɔ: «Bhaa 'bhɛ 'kan 'e ma 'egbɔɔnle, Mɛɛzan! 'Yooye‑ 'bhɛ ‑za 'lɛɛ‑, yaa nu 'tɛnlɛ‑ 'e ma ‑titi!» ");
INSERT INTO moa_vpl VALUES ("MT16_23","070_16_23","MAT","16","23","23","'Duŋ‑ Zesu 'e 'lɛklale Piɛri ta, 'ke ‑ya pele‑ ‑a ni dɔɔ: «'E 'pleŋgo‑ 'ŋ ma 'egbɔɔnle, ‑Setran'! 'Yoo‑ 'ŋ baayrɛ ‑la ‑glin 'zi ‑za 'yɔɔ‑ 'yi, ‑amasrɔyi 'e 'kpeejan‑ mu 'ɛ waa da ‑Waanbhaa' ba, 'duŋ‑ ‑woo bhaaplɛŋ 'kpeejan‑ mu ‑la ‑le.» ");
INSERT INTO moa_vpl VALUES ("MT16_24","070_16_24","MAT","16","24","24","'Bhɛ ya 'ɛ 'yi, Zesu pe ‑yaa' ‑klaŋlanɛ mu 'ɛ ni dɔɔ: «'Ke mɛɛ 'la zan ‑a zi 'bhii‑ ‑e klɛ 'ŋ zi mi 'le, ‑ya niigo ‑a 'gbu 'si ‑ɛ 'yi 'elwale 'pe, 'bhɛɛ‑ ‑e dɔ ‑yrɛnbhlele ꞊la, 'ke 'bhɛ ꞊kla, 'bhɛɛ‑ 'bhɛ zan nu dɔ 'ŋ zi. ");
INSERT INTO moa_vpl VALUES ("MT16_25","070_16_25","MAT","16","25","25","‑Ayile, 'ke mɛɛ 'la zan ‑a zi 'bhii‑ ‑ya 'gbu 'si 'ɛ go ‑za 'yi, 'bhɛ zan nu bloolɛ 'bhɛ ꞊si 'ɛ 'yi. 'Duŋ‑ 'ke mɛɛ la zan 'e zru ‑gwa ‑a 'gbu 'si 'ɛ ni 'mi ‑zayi', 'bhɛ zan nu 'bhɛ ꞊si 'ɛ 'srɔɔwo gbɛ drɛɛwolɛ. ");
INSERT INTO moa_vpl VALUES ("MT16_26","070_16_26","MAT","16","26","26","'Ke mɛɛ do 'trɛ ta pɛ mu 'ɛ 'kpɛn 'srɔɔwoa‑, 'bhɛɛ‑ 'ke yaa ‑Waanbhaa ba bole ‑yrɛ ‑si 'ɛ ‑srɔɔwolɛ, 'bhɛ 'trɔn‑ ꞊kla ‑a ma ‑mɛla ‑le ɛɛ? 'Bhɛɛ‑ 'ke bhaaplɛŋ do ‑bloola ‑a 'gbu 'si 'ɛ 'yi, ‑e sɔ ‑a tagbawole ‑mɛla ‑le 'bhɛɛ‑ ‑ya ‑srɔɔwo' gbɛ drɛɛwo ɛɛ? ");
INSERT INTO moa_vpl VALUES ("MT16_27","070_16_27","MAT","16","27","27","'Bhɛ ya 'ɛ 'yi, Bhaaplɛŋ Gbe 'ɛ 'pegee ‑mlɛkɛ' mu nu nulɛ yi do ta ‑a Dɛ a 'tɔbhɔleya 'ɛ 'yi, 'bhɛɛ‑ mɔkpɛn' do do ‑za yɛkɛ‑ 'la ꞊kla, ‑e nu 'bhɛɛ‑ wlata za nalɛ ‑o 'kpɛn do do ni. ");
INSERT INTO moa_vpl VALUES ("MT16_28","070_16_28","MAT","16","28","28","'Mi pe 'ka ni wlan 'ɛ ni kpataakpa 'kaa mɛɛ 'la zan mu 'kpɛn ‑o ‑gɛ ‑zɔn, ‑o 'ke mu laa nu galɛ 'sani‑ Bhaaplɛŋ Gbe 'ɛ 'nule‑ pleŋ‑ 'bhii‑ ‑bhleŋgbe do.» ");
INSERT INTO moa_vpl VALUES ("MT17_1","070_17_1","MAT","17","1","1","'Bhɛ blaan ‑yrekpaa' 'srwado‑ mi ma, 'ke Zesu Piɛri 'bhɛɛ‑ Zaki 'pegee 'bhɛ nɛɛnɛ‑ Zaan 'siile, 'bhɛɛ‑ 'ke ‑o mɛɛ yiziɛ 'kpɔ gele‑ mɛɛ mu 'ɛ 'yrɛ ‑gɔma' vlɛ gɔɔn 'trole‑ do 'wiiŋ‑. ");
INSERT INTO moa_vpl VALUES ("MT17_2","070_17_2","MAT","17","2","2","'Bhɛ ꞊nɔɔ bhe, 'ke Zesu 'a dɔgbɛya 'ɛ mabɔɔle ‑o ‑yrɛ ma: ‑A wlɛyi' 'yaa‑ ‑bhi 'zi 'bhii‑ ‑yretɛ' 'bhigbɛya, 'bhɛɛ‑ ‑a ta dunɛ‑ mu 'ɛ 'fleela‑ 'epu ‑yrayrale 'bhii‑ 'tɛbhile gbɛɛn‑. ");
INSERT INTO moa_vpl VALUES ("MT17_3","070_17_3","MAT","17","3","3","'Bhɛɛ‑ 'woo‑ Zesu a ‑klaŋlanɛ yaga 'ɛ ‑woo ‑yrɛkpale 'tɛ, 'ke ‑o Moizi 'pegee Eli 'yele Zesu ‑din, 'ke 'mu ‑o ‑balo klɛ 'zi Zesu 'le. ");
INSERT INTO moa_vpl VALUES ("MT17_4","070_17_4","MAT","17","4","4","'Bhɛ klɛle 'tɛ, 'ke Piɛri 'a 'pele Zesu ni dɔɔ: «Mɛɛzan, 'o klɛlawoa ‑gɛ bhe 'bhɛ 'lrela‑. 'Kee‑ ‑swa 'e ni, 'ŋ 'yoo‑ ‑a zi 'bhii‑ 'ŋ 'kpaanɛ yaga dɔ ‑gɛ: 'Bhi a pɛ do, Moizi a pɛ do 'bhɛɛ‑ Eli a pɛ do.» ");
INSERT INTO moa_vpl VALUES ("MT17_5","070_17_5","MAT","17","5","5","‑E ‑yaa 'bhɛ ‑jan 'ɛ 'wo zii' 'waati 'la ba, 'ke laflɛ' ‑gblɛn 'fleele‑ 'pu do nule‑ 'kpalɛ‑ ‑o ta, 'bhɛɛ‑ 'ke ‑o ‑weli' do male‑ 'bhɛ laflɛ' ‑gblɛn 'ɛ 'yi dɔɔ: «'Ŋ Gbe 'la 'ke ‑a ‑za sɔ 'ŋ ni 'egbɛnɛle 'yele‑ ‑gɛ, 'yele‑ 'ŋ zrukpalaa 'egbɛnɛle 'ezin‑, ‑ka 'ka 'trɔnkpa ‑a wojan mu 'ɛ ꞊la 'elrele.» ");
INSERT INTO moa_vpl VALUES ("MT17_6","070_17_6","MAT","17","6","6","‑Yaa' ‑klaŋlanɛ mu 'ɛ ‑o 'bhɛ ‑weli' 'ɛ 'male‑, 'ke ‑o baale' ‑o zru ta 'trɛ ma ‑gblaan 'ɛ 'kɔɔ. ");
INSERT INTO moa_vpl VALUES ("MT17_7","070_17_7","MAT","17","7","7","'Bhɛ klɛle 'tɛ, 'ke Zesu 'e 'mabɛɛnle ‑o ‑din, 'bhɛɛ‑ 'ke ‑ya gbɛ yanle‑ ‑o ma 'ke ‑ya pe ‑o ni dɔɔ: «'Ka 'laa ‑gblaanlɛ', ‑ka 'ka 'wlɛn‑.» ");
INSERT INTO moa_vpl VALUES ("MT17_8","070_17_8","MAT","17","8","8","'Bhɛɛ‑ ‑woo ŋgblo ‑lawlɛnle 'tɛ, waa ‑bhɛɛke' 'yelɛ‑ 'ke yaa 'e go Zesu do ‑kplɛnnɛ' ba. ");
INSERT INTO moa_vpl VALUES ("MT17_9","070_17_9","MAT","17","9","9","‑O zina bhla 'ɛ zi vlɛ gɔɔn 'ɛ 'wiiŋ‑, 'ke Zesu ‑o ‑lɛmazɔnle‑ dɔɔ: «'Ka pɛ 'la ꞊ya bhe, 'ka 'laa 'bhɛ 'pelɛ‑ mɛɛ 'kedo‑ 'kpɔ ni 'sani‑ Bhaaplɛŋ Gbe 'ɛ bwele pleŋ‑ gale ba.» ");
INSERT INTO moa_vpl VALUES ("MT17_10","070_17_10","MAT","17","10","10","Zesu a ‑klaŋlanɛ mu 'ɛ ‑wa ‑lrɔkpaa dɔɔ: «‑Mɛle ‑kla 'bhɛɛ‑ 'Toŋ daan mu 'ɛ pe 'kaa ‑Waanbhaa' 'lɛla janwo mi Eli ‑le nu nulɛ Mɛɛ ‑Bhee Mi ‑kpɔsɔɔ 'ɛ 'lɛɛ 'elwale 'pe ɛɛ?» ");
INSERT INTO moa_vpl VALUES ("MT17_11","070_17_11","MAT","17","11","11","Zesu pe ‑o ni dɔɔ: «Wlan ‑le 'bhɛ 'le, Eli nu nulɛ pɛ mu 'kpɛn 'lɛmagaanlɛ 'elwale 'pe. ");
INSERT INTO moa_vpl VALUES ("MT17_12","070_17_12","MAT","17","12","12","'Duŋ‑ 'mi pe 'ka ni dɔɔ Eli ꞊nwa gban, 'bhɛɛ‑ mɛɛ mu 'ɛ waa ‑a madɔlɛ, 'bhɛɛ‑ ‑za yɛkɛ‑ 'la klɛle ꞊swa ‑o ni ‑o 'bhɛɛ‑ ꞊kla ‑a ni. ‑O ‑yrɛn 'ɛ 'kpɛn ‑glɔɔn ‑kpaa ‑a ta. 'Bhɛ klɛgbɛya do 'ɛ 'yi, mɛɛ mu 'ɛ ‑o nu ‑yrɛnkpalɛ Bhaaplɛŋ Gbe 'ɛ 'gbu ta 'bhɛɛ‑ gbɛɛn‑.» ");
INSERT INTO moa_vpl VALUES ("MT17_13","070_17_13","MAT","17","13","13","'Bhɛ klɛle 'tɛ, 'ke ‑yaa' ‑klaŋlanɛ mu 'ɛ ‑wa ‑yimale dɔɔ ‑e ‑yaa ‑we 'zi 'ke Mɛɛ Wiiŋfɛ' Mi Zaan ‑la ‑le. ");
INSERT INTO moa_vpl VALUES ("MT17_14","070_17_14","MAT","17","14","14","‑O bhɔle ‑zamaa' 'ɛ ‑din bhla 'la ba, 'ke mɛɛ do nule‑ baalɛ 'bhɛ 'kpɔ ta Zesu 'lɛɛ, 'bhɛɛ‑ 'ke 'bhɛ 'a 'pele dɔɔ: ");
INSERT INTO moa_vpl VALUES ("MT17_15","070_17_15","MAT","17","15","15","«Mɛɛzan, 'ŋ 'nɛ 'ɛ 'yrɛnkla 'e ma. ‑Sɔɔnsɔɔn ‑o ‑a ‑yi, 'bhɛɛ‑ 'ke 'bhɛ ‑sɔɔnsɔɔn 'ɛ balaa' 'a ta, ‑ya bɔ 'waati 'ke ba 'tɛ 'yi, 'bhɛɛ‑ 'waati 'ke ba 'ezin‑ ‑ya balaa' ‑yi ba. ");
INSERT INTO moa_vpl VALUES ("MT17_16","070_17_16","MAT","17","16","16","'Ŋ ꞊nwa 'kɛle‑ 'yaa‑ ‑klaŋlanɛ mu 'ɛ ni, 'bhɛɛ‑ waa 'sɔlɛ‑ ‑a ‑bheele'.» ");
INSERT INTO moa_vpl VALUES ("MT17_17","070_17_17","MAT","17","17","17","'Bhɛ klɛle 'tɛ, 'ke Zesu 'a 'pele ‑yaa' ‑klaŋlanɛ mu 'ɛ ni dɔɔ: «'E! Mɛɛ mu, 'ka mu 'la 'ka 'laa 'ka kpa ‑Waanbhaa' 'yi, 'bhɛɛ‑ 'ka mɛɛ 'kpee 'yɔɔ‑ mu. ‑A ‑vinbwa 'waati 'wɛɛ‑ 'bhɛɛ‑ 'ŋ bo 'ka 'pleŋ‑ ɛɛ? 'Waati 'wɛɛ‑ ‑le ꞊bwa, 'bhɛɛ‑ 'ŋ nu yanlɛ 'ka 'kwe 'sile‑ 'ɛ 'le ɛɛ? ‑Ka nu ‑nɛ 'ɛ 'le 'ŋ ni ‑gɛ doo!» ");
INSERT INTO moa_vpl VALUES ("MT17_18","070_17_18","MAT","17","18","18","'Bhɛ klɛle 'tɛ, 'ke Zesu 'yranle 'yee‑ 'zina 'ɛ zi, 'kee‑ gole‑ ‑nɛ ‑zwannɛ 'ɛ zi. 'Bhɛɛ‑ 'ke 'bhɛ 'bheele 'bhɛ yrɛ do 'ɛ ꞊nɔɔ bhe. ");
INSERT INTO moa_vpl VALUES ("MT17_19","070_17_19","MAT","17","19","19","'Bhɛ 'ɛ 'yi 'tɛ, 'ke Zesu a ‑klaŋlanɛ mu 'ɛ ‑o nule‑ ‑a ‑din mɛɛ mu 'ɛ 'yrɛ ‑gɔma', 'bhɛɛ‑ 'ke ‑wa ‑lrɔkpale dɔɔ: «‑Mɛle ꞊kla 'bhɛɛ‑ 'o mɔɔ laa 'sɔlɛ‑ 'yee‑ 'zina 'ɛ ‑gbinle' ‑nɛ 'ɛ zi ɛɛ?» ");
INSERT INTO moa_vpl VALUES ("MT17_20","070_17_20","MAT","17","20","20","Zesu 'a 'lɛkwan‑ ‑o ni dɔɔ: «'Ka gbɛ laa 'sɔlɛ‑ ‑a ‑gbinle' ta, ‑amasrɔyi 'ka 'laa 'ka 'kpalɛ‑ ‑Waanbhaa' 'yi 'egbɛnɛle. 'Mi pe 'ka ni wlan 'ɛ ni dɔɔ 'ke 'kaa‑ 'kpaleya 'ɛ ‑Waanbhaa' 'yi, 'bhɛ ‑o bi 'bhii‑ mutaadi bhɛ do gbɛɛn‑, 'ali‑ 'ka nu a pelɛ vlɛ gɔɔn 'lɛɛ‑ ni dɔɔ ‑e ‑yro ‑a gbaanyrɛ 'ɛ 'lɛɛ‑ ꞊nɔɔ, 'bhɛɛ‑ ‑e ge gbaan laale, ‑e nu 'bhɛ 'kpɛn klɛlɛ 'ka 'weli‑ ta. 'Bhɛɛ‑ 'ka ‑bali 'laa nu wolɛ ‑za 'kedo‑ 'kpɔ klɛle ma.» ");
INSERT INTO moa_vpl VALUES ("MT17_21","070_17_21","MAT","17","21","21","'Duŋ‑ 'zina ‑glɔɔn 'lɛɛ‑ 'bhɛ 'laa sɔ gole‑ mɛɛ zi, 'fɔke 'ka 'ka 'seriwoa ‑Waanbhaa' ni 'bhɛɛ‑ 'ke 'ka 'suŋwlaa‑. ");
INSERT INTO moa_vpl VALUES ("MT17_22","070_17_22","MAT","17","22","22","‑Yrekpaa' do, Zesu 'pegee ‑yaa' ‑klaŋlanɛ mu 'ɛ 'kpɛn 'klale‑ ‑yaa 'eke‑ ba Galile 'klɛɛn 'ɛ 'yi. 'Bhɛɛ‑ 'ke ‑ya pele‑ ‑o ni dɔɔ: «‑O nu Bhaaplɛŋ Gbe 'ɛ 'lɛnalɛ mɛɛ mu ni, ");
INSERT INTO moa_vpl VALUES ("MT17_23","070_17_23","MAT","17","23","23","'bhɛɛ‑ 'mu nu ‑a dɛlɛ, 'bhɛɛ‑ 'duŋ‑, ‑a gale blaan ‑yrekpaa' yaga mi ma, ‑e nu bwelɛ gale ba.» 'Bhɛ yrɛ do 'ɛ ꞊nɔɔ bhe, 'ke wisi' ‑gbɔɔ dɔle‑ ‑o ‑yrɛ ta. ");
INSERT INTO moa_vpl VALUES ("MT17_24","070_17_24","MAT","17","24","24","Zesu 'pegee ‑yaa' ‑klaŋlanɛ mu 'ɛ ‑o bhɔle Kapɛnɔmu ‑wa 'ɛ ta, 'ke *‑Waanbhaa' Gba 'Fɛ ‑Gbɛnɛ 'ɛ ꞊la 'nisrakun mu 'ɛ ‑woo mabɛɛnle Piɛri ‑din, 'bhɛɛ‑ 'ke ‑wa 'lrɔkpale dɔɔ: «'Kaa‑ pɛ Daan mi 'ɛ 'bhɛ ‑Waanbhaa' Gba 'Fɛ ‑Gbɛnɛ 'ɛ ma 'nisra 'ɛ gbawo taa‑ yaa ‑a gbawo ɛɛ?» ");
INSERT INTO moa_vpl VALUES ("MT17_25","070_17_25","MAT","17","25","25","'Bhɛ klɛle 'tɛ, 'ke Piɛri 'a 'pele dɔɔ: «‑Aani', ‑ya gbawo.» Piɛri ‑yaa zan wlalɛ 'fɛ 'ɛ ꞊la, 'ke Zesu 'a 'lrɔkpale dɔɔ: «'Bhi 'kpee ma ‑de mu 'gbu ‑le 'nisra gbawo 'drunyan 'lɛɛ‑ 'yi ‑bhleŋgbe mu 'ɛ ni ɛɛ? ‑Wa 'nɛ mu taa‑ 'cie mu ɛɛ?» ");
INSERT INTO moa_vpl VALUES ("MT17_26","070_17_26","MAT","17","26","26","Piɛri 'a zikpaa‑ ‑a ni dɔɔ: «'Cie mu ‑le ‑a gbawo.» ‑Ayile, 'ke Zesu 'a 'pele 'a ni dɔɔ: «‑Wa 'nɛ mu laa ‑o 'yee‑ 'nisra 'ɛ gbawo mu 'le bi. ");
INSERT INTO moa_vpl VALUES ("MT17_27","070_17_27","MAT","17","27","27","'Duŋ‑ 'waa ‑a zi 'bhii‑ 'o klɛ ‑o baapɛ mu 'le ‑za 'yɔɔ‑ 'yi. 'Bhɛla‑ ‑zayile, ge wɛyi‑ 'ɛ 'lɛ ma, 'bhɛɛ‑ 'yaa‑ 'duŋleŋ 'ɛ blin ‑yi 'ɛ ba, 'kee‑ kaa ꞊lwa mi 'la ꞊kwan 'bhɛ ‑glaan', 'bhɛɛ‑ 'ya kun. 'Bhɛ blaan, ‑a ‑lii 'ploo‑, 'bhɛɛ‑ 'e nu ‑gɔli' 'taŋbha do yelɛ ‑a ‑lii; 'bhɛ ‑gɔli' 'taŋbha do 'ɛ 'bhɛ ‑le nu 'sɔlɛ‑ 'o mɛɛ plɛ a pɛ 'nisra 'ɛ gbawole. ‑A 'si 'bhɛɛ‑ 'e ge 'mi 'pegee 'bhi a 'nisra 'ɛ gbawolɛ 'kɛle‑.» ");
INSERT INTO moa_vpl VALUES ("MT18_1","070_18_1","MAT","18","1","1","'Bhɛ 'waati 'ɛ ba, 'ke Zesu a ‑klaŋlanɛ mu 'ɛ 'nule ‑a ‑din, 'bhɛɛ‑ 'ke ‑wa ‑lrɔkpale dɔɔ: «‑De 'gbu ‑la gblaan 'yiya‑ mɔkpɛn' ni laanima ‑bhleŋgbeya ‑wa 'ɛ ta ɛɛ?» ");
INSERT INTO moa_vpl VALUES ("MT18_2","070_18_2","MAT","18","2","2","'Bhɛ 'yi 'tɛ, 'ke Zesu ‑nɛ 'fiɛntrɔnnɛ do 'siile, 'bhɛɛ‑ 'kee‑ 'bhɛ dulale ‑o pleŋ‑, ");
INSERT INTO moa_vpl VALUES ("MT18_3","070_18_3","MAT","18","3","3","'bhɛɛ‑ 'ke ‑ya pele dɔɔ: «'Mi pe 'ka ni wlan 'ɛ ni dɔɔ 'ke 'ka 'laa 'ka 'taawogbɛya 'ɛ niinalɛ, 'bhɛɛ‑ 'ka klɛ 'bhii‑ ‑nɛ 'fiɛntrɔnnɛ mu gbɛɛn‑, 'ka 'laa nu gelɛ ‑titi laanima ‑bhleŋgbeya ‑wa 'ɛ ta. ");
INSERT INTO moa_vpl VALUES ("MT18_4","070_18_4","MAT","18","4","4","'Bhɛla‑ ‑zayile, 'ke mɛɛ 'la zan 'bhɛ 'gbu mavɛɛla, 'bhɛɛ‑ ‑e ‑kla 'bhii‑ ‑nɛ 'fiɛntrɔnnɛ 'lɛɛ‑ gbɛɛn‑, 'bhɛ zan 'ɛ 'bhɛ ‑la gblaan nu ‑yiyalɛ mɔkpɛn' ni laanima ‑bhleŋgbeya ‑wa 'ɛ ta. ");
INSERT INTO moa_vpl VALUES ("MT18_5","070_18_5","MAT","18","5","5","'Bhɛɛ‑ 'ke mɛɛ 'oo mɛɛ 'la zan ‑nɛ do 'kpɔ 'cieya‑ ꞊kla 'mi 'tɔ 'ɛ ‑zayi' 'bhii‑ ‑nɛ 'lɛɛ‑ gbɛɛn‑, 'bhɛ zan 'ɛ 'bhɛ 'mi 'gbu ‑la 'cieya‑ ꞊kla 'bhɛ gbɛɛn‑ bhe.» ");
INSERT INTO moa_vpl VALUES ("MT18_6","070_18_6","MAT","18","6","6","Zesu pe ‑o ni 'ezin‑ dɔɔ: «‑Nɛ mu 'la ‑woo ꞊kpaa 'mi 'yi, 'ke mɛɛ 'la zan ‑o do 'kpɔ ‑balaa' ‑za 'yɔɔ‑ 'yi, 'ke ‑o vlɛ ‑kpuŋ ‑gbɛnɛ do ‑yrela bi 'bhɛ zan 'ɛ bhlɔ ma, 'bhɛɛ‑ 'ke ‑o ‑ja ‑a blinlɛ wɛyi‑ ba, 'bhɛ mabhaa ‑yaa nu bhɔlɛ 'bhɛ zan 'ɛ ma. ");
INSERT INTO moa_vpl VALUES ("MT18_7","070_18_7","MAT","18","7","7","‑Klɔlɔɔ' ‑o 'drunyan 'yi mu 'ɛ ma ‑waa' mɛɛ mu baaza ‑za ‑yɔɔ' mu 'yi 'bhɛ ‑zayi'. Mɛɛ mu baaza 'ɛ ‑za ‑yɔɔ' 'ɛ 'yi, ‑saawole laa ‑o 'bhɛ ma. 'Duŋ‑ mɛɛ 'la zan klɛ mɛɛ ‑bhɛɛke' mu baapɛ 'le ‑za 'yɔɔ‑ 'yi, ‑klɔlɔɔ' ‑o 'bhɛ zan ta.» ");
INSERT INTO moa_vpl VALUES ("MT18_8","070_18_8","MAT","18","8","8","«'Kee‑ ꞊kla 'e gbɛ do ‑la ‑zayi' oo, 'kee‑ ꞊kla 'e gaan do ‑la ‑zayi' oo, 'bhɛɛ‑ 'e baa‑ 'zi ‑za 'yɔɔ‑ 'yi, ‑o takan', 'bhɛɛ‑ ‑o blin 'e ma 'egbɔɔnle. 'Kee ‑ja 'e gbɛ do 'pegee 'e gaan do 'le ‑Waanbhaa' ba bole ‑yrɛ ma ‑si yrɛ 'ɛ ꞊nɔɔ, 'bhɛ mabhaabhɔ 'e ma, 'ke ‑woo 'e ‑blinna 'e gbɛ plɛ 'pegee 'e gaan plɛ 'le 'tɛ 'la yaa lii ‑titi 'bhɛ 'yi. ");
INSERT INTO moa_vpl VALUES ("MT18_9","070_18_9","MAT","18","9","9","'Bhɛɛ‑ 'kee‑ 'yrɛbhɛ‑ do ‑le 'a 'wla zii' 'e zi 'bhɛɛ‑ 'e baa‑ 'zi ‑za 'yɔɔ‑ 'yi, ‑a ‑yro 'bhɛɛ‑ ‑a blin 'e ma 'egbɔɔnle. 'Kee ‑ja 'e 'yrɛ gbɛ do 'le ‑Waanbhaa' ba bole ‑yrɛ ma ‑si yrɛ 'ɛ ꞊nɔɔ 'bhɛ mabhaabhɔ 'e ma, 'ke ‑woo 'e ‑blinna ‑jranama 'tɛ 'ɛ 'yi 'e 'yrɛbhɛ‑ plɛ 'ɛ 'le.» ");
INSERT INTO moa_vpl VALUES ("MT18_10","070_18_10","MAT","18","10","10","Zesu pe 'ezin‑ dɔɔ: «‑Ka 'ka 'yrɛkpa 'ka 'gbu ba 'elrele, 'kooko‑ 'ka 'laa 'woo‑ ‑nɛ 'fiɛntrɔnnɛ mu 'la bhe ‑o do 'kpɔ mavɛɛ; ‑amasrɔyi ‑waa' ‑mlɛkɛ' mu 'la ‑woo laanima ‑o dulale ‑o yikpɛn‑ ta 'ŋ Dɛ ‑yrɛ ꞊la. ");
INSERT INTO moa_vpl VALUES ("MT18_11","070_18_11","MAT","18","11","11","‑Amasrɔyi Bhaaplɛŋ Gbe 'ɛ ꞊nwa mɛɛ 'la zan mu nile ‑yaa, 'mu 'la go zayi' ‑za 'yi.» ");
INSERT INTO moa_vpl VALUES ("MT18_12","070_18_12","MAT","18","12","12","«'Bhɛɛ‑ 'ka mu pe 'nale‑ ɛɛ? 'Ke ‑bhlaa ‑kɛmɛ (100) do ‑o mɛɛ do 'kɔɔ, 'bhɛɛ‑ 'ke ‑a do 'kpɔ ꞊nia ‑o ba, yaa nu ‑a ‑vin mia yiziɛ bhɛ vu ta 'srwayiziɛ 'ɛ 'tolɛ‑ vlɛ gɔɔn 'ɛ 'wiiŋ‑, 'bhɛɛ‑ ‑e ge ‑a do 'kpɔ 'la ꞊nia 'bhɛ ziglinlɛ ɛɛ? ");
INSERT INTO moa_vpl VALUES ("MT18_13","070_18_13","MAT","18","13","13","'Kee‑ 'yee‑ ‑bhlaa do 'la ꞊nia 'bhɛ ꞊ya, 'mi pe 'ka ni wlan 'ɛ ni dɔɔ 'bhɛ nu ‑a zrukpaalɛ 'egbɛnɛle 'ke 'bhɛ kan ‑a ‑vin mia yiziɛ bhɛ vu ta 'srwayiziɛ 'la 'mu 'laa 'nilɛ‑ 'mu ta. ");
INSERT INTO moa_vpl VALUES ("MT18_14","070_18_14","MAT","18","14","14","'Bhɛ ya 'ɛ 'yi, 'ka Dɛ ‑Waanbhaa' 'la ‑yoo laanima yaa‑ zi 'bhii‑ 'woo‑ ‑nɛ mu 'la bhe ‑o do 'kpɔ ni ‑o ba.» ");
INSERT INTO moa_vpl VALUES ("MT18_15","070_18_15","MAT","18","15","15","«'Kee nɛɛnɛ‑ do ‑za 'yɔɔ‑ do ꞊kla 'e ni, ge ‑a ba, 'bhɛɛ‑ 'ka mɛɛ plɛ 'pleŋ‑, 'e ‑yaa' ‑za 'yɔɔ‑ 'ɛ zrɔn ‑a ni. 'Ke ‑ya 'trɔnkpaa‑ 'e 'wojan‑ 'ɛ ꞊la, 'bhɛɛ‑ 'kee‑ ‑yaa' ‑za 'yɔɔ‑ 'ɛ ‑dwa, 'e nu 'e nɛɛnɛ‑ 'ɛ bɔ gbɛ drɛɛwolɛ ‑Waanbhaa' a zi 'ɛ ta. ");
INSERT INTO moa_vpl VALUES ("MT18_16","070_18_16","MAT","18","16","16","'Duŋ‑ 'ke yaa dɔlɛ a ‑la 'ke ‑ya 'trɔnkpa‑ 'e 'wojan‑ 'ɛ ꞊la, 'bhɛɛ‑ 'ke yaa ‑yaa ‑za 'yɔɔ‑ 'ɛ dɔlɛ, 'kee‑ ꞊kla mɛɛ do 'le oo, 'kee‑ ꞊kla mɛɛ plɛ 'le oo, 'mu 'sii‑, 'kooko‑ 'ka 'ka 'pleŋza‑ 'ɛ yan mɛɛ plɛ 'pegee mɛɛ yaga ‑yrɛ ma 'bhii‑ 'ka 'srɛ mu 'le. ");
INSERT INTO moa_vpl VALUES ("MT18_17","070_18_17","MAT","18","17","17","'Duŋ‑ 'ke yaa dɔlɛ a ‑la 'ke ‑ya 'trɔnkpa‑ 'mu 'wojan‑ 'ɛ ꞊la, ‑a pe 'kaa‑ Zesu 'yi mu ‑lɛdo' 'ɛ 'yrɛ ma 'ezin‑; 'bhɛɛ‑ 'duŋ‑ 'ke yaa dɔlɛ ‑a ‑la 'ke ‑ya 'trɔnkpa‑ 'mu 'wojan‑ 'ɛ ꞊la, 'bhɛ zan 'ɛ klɛ 'e 'yrɛ 'yi 'bhii‑ mɛɛ 'la zan laa ‑Waanbhaa' dɔ, 'bhɛɛ‑ ‑a 'kun 'bhii‑ 'nisrakun mi do gbɛɛn‑. ");
INSERT INTO moa_vpl VALUES ("MT18_18","070_18_18","MAT","18","18","18","«'Mi pe 'ka ni wlan 'ɛ ni dɔɔ: 'Ke 'ka pɛ 'oo pɛ 'la 'yrela‑ 'trɛ ta ‑gɛ, ‑o nu 'bhɛ pɛ 'ɛ 'yrelɛ‑ laanima laflɛ' 'yi 'ezin‑. 'Bhɛɛ‑ 'ke 'ka pɛ 'oo pɛ 'la 'ploola‑ 'trɛ ta ‑gɛ, ‑o nu 'bhɛ pɛ 'ɛ 'ploolɛ‑ laanima laflɛ' 'yi 'ezin‑.» ");
INSERT INTO moa_vpl VALUES ("MT18_19","070_18_19","MAT","18","19","19","«'Mi pe 'ka ni 'ezin‑ wlan 'ɛ ni dɔɔ 'ke 'ka ba mɛɛ plɛ ꞊kpaa do ma 'trɛ ta ‑gɛ pɛ do 'la ‑yrɛwo' zayi' ‑waa' 'seri 'yi, 'ŋ Dɛ ‑Waanbhaa' 'la ‑yoo laanima 'bhɛ nu 'bhɛ pɛ 'ɛ 'nalɛ‑ ‑o ni. ");
INSERT INTO moa_vpl VALUES ("MT18_20","070_18_20","MAT","18","20","20","‑Amasrɔyi, 'kee‑ ꞊kla mɛɛ plɛ oo, 'kee‑ ꞊kla mɛɛ yaga oo, 'ke ‑o ꞊klaa 'eke‑ ba 'mi 'tɔ 'ɛ 'yi 'ŋ nu klɛlɛ ‑o pleŋ‑.» ");
INSERT INTO moa_vpl VALUES ("MT18_21","070_18_21","MAT","18","21","21","'Bhɛ klɛle 'tɛ, 'ke Piɛri 'nule Zesu ‑din, 'bhɛɛ‑ 'kee‑ 'bhɛ ꞊lrɔkpale dɔɔ: «Mɛɛzan, yi 'oo yi 'ke 'ŋ nɛɛnɛ‑ do bole ‑o ‑za 'yɔɔ‑ klɛle ma 'ŋ ni, 'ŋ sɔ ‑yaa' ‑za 'yɔɔ‑ 'ɛ ‑sroma 'yanle gaan ‑wɛɛ' ‑a ma ɛɛ? 'Ŋ ‑yaa' ‑sroma 'yan gaan 'srwaplɛ‑ ‑a ma ɛɛ?» ");
INSERT INTO moa_vpl VALUES ("MT18_22","070_18_22","MAT","18","22","22","'Bhɛ 'yi bhe, 'ke Zesu 'a zikpale ‑a ni dɔɔ: «'Yooye‑, 'naa 'pelɛ‑ 'e ni dɔɔ 'e ‑yaa' ‑za 'yɔɔ‑ 'ɛ ‑sroma 'yan gaan 'srwaplɛ‑ 'kpɔ, 'duŋ‑ 'mi pe 'e ni dɔɔ ‑yaa' ‑za 'yɔɔ‑ 'ɛ ‑sroma 'yan gaan mia yaga 'bhɛ vu ‑lɛdulayrɛ 'srwaplɛ‑. ");
INSERT INTO moa_vpl VALUES ("MT18_23","070_18_23","MAT","18","23","23","'Bhɛla‑ ‑zayile, 'mi pe 'ka ni 'ezin‑ dɔɔ laanima ‑bhleŋgbeya ‑wa 'ɛ 'pwɛle‑ ‑o 'ke ‑bhleŋgbe do a ‑za ‑le: 'Yee‑ ‑bhleŋgbe 'ɛ 'yaa‑ ‑a zi 'bhii‑ ‑yaa' ca mu ‑yaa ‑yaa' yewonɛ mu 'la ma, ‑e 'bhɛ ca mu 'ɛ 'liidɔ‑, 'bhɛɛ‑ 'mu 'bhɛ ca mu 'ɛ gbawo ‑a ni. ");
INSERT INTO moa_vpl VALUES ("MT18_24","070_18_24","MAT","18","24","24","‑E 'bhɛ ca za mu 'ɛ zisanle, 'ke ‑o nule‑ ‑yaa' 'fa ꞊la yewonɛ 'ɛ do 'le ‑a ni. ‑Yaa' 'mliyɔn ‑bebe ca ‑yaa 'bhɛ ma. ");
INSERT INTO moa_vpl VALUES ("MT18_25","070_18_25","MAT","18","25","25","'Duŋ‑ 'bhɛ ca 'ɛ gbawo ‑gɔli' 'laa ‑yaa 'bhɛ yewonɛ 'ɛ 'kɔɔ. 'Bhɛla‑ ‑yile, a zan pe dɔɔ 'bhɛ ‑o 'yee‑ gɔnle‑ 'bhii lu do, 'bhɛ 'pegee ‑a na oo, ‑a ‑nɛ mu oo, 'bhɛɛ‑ ‑a 'kɔɔpɛ‑ mu 'ɛ 'kpɛn, ‑yaa' ca 'ɛ gbawopɛ 'le. ");
INSERT INTO moa_vpl VALUES ("MT18_26","070_18_26","MAT","18","26","26","'Bhɛ klɛle 'tɛ, 'ke 'yee‑ yewonɛ 'ɛ baale' ‑a 'kpɔ ta ‑a zan 'ɛ 'lɛɛ, 'bhɛɛ‑ 'kee‑ ‑sromabɔle 'bhɛ ni dɔɔ: ‹'Ŋ Zan, 'e zrubakpala 'ŋ zi, 'ŋ nu 'yaa‑ ca 'ɛ 'kpɛn gbawolɛ 'e ni!› ");
INSERT INTO moa_vpl VALUES ("MT18_27","070_18_27","MAT","18","27","27","‑Ayile, ‑a ‑yrɛnklale ‑a zan ma, 'ke 'bhɛ ‑yaa' ca gbawoza 'ɛ 'saawole, 'bhɛɛ‑ 'ke 'bhɛ 'ploole ‑a ma.» ");
INSERT INTO moa_vpl VALUES ("MT18_28","070_18_28","MAT","18","28","28","«'Duŋ‑, 'yee‑ yewonɛ 'ɛ 'e 'pwɛle‑ ‑a zan ba 'fɛ 'ɛ ꞊la, 'ke ‑a ‑lɛpale ‑yaa' yewoyɔɔn 'ɛ do 'le. Yaa denie ‑gɔli' 'taŋbha ‑kɛmɛ do ca 'la 'yaa‑ 'bhɛ ma bhe, ‑e 'bhɛ ꞊kwan 'bhɛ blina‑, 'bhɛɛ‑ ‑e ‑yaa zan 'bhɛ ‑dewolɛ, 'bhɛɛ‑ ‑e pe 'bhɛ ni dɔɔ: ‹'An ca 'la ‑yoo 'e ma ‑a gbawo 'ŋ ni!› ");
INSERT INTO moa_vpl VALUES ("MT18_29","070_18_29","MAT","18","29","29","'Bhɛ ya 'ɛ 'yi, 'ke ‑yaa' yewoyɔɔn 'ɛ 'bhɛ baale' 'bhɛ 'kpɔ ta ‑a ‑lɛɛ, 'bhɛɛ‑ 'ke 'bhɛ ‑sromabɔle ‑a ni dɔɔ: ‹'E zrubakpala 'ŋ zi, 'ŋ nu 'yaa‑ 'ɛ gbawolɛ 'e ni!› ");
INSERT INTO moa_vpl VALUES ("MT18_30","070_18_30","MAT","18","30","30","'Duŋ‑, 'yee‑ laa dɔlɛ 'bhɛ ꞊la; ‑ayile 'ke ‑ya yewoyɔɔn 'ɛ bɔle‑ ‑kaso 'yi 'sani‑ 'ke 'bhɛ yan ‑yaa' ca 'ɛ gbawolele. ");
INSERT INTO moa_vpl VALUES ("MT18_31","070_18_31","MAT","18","31","31","‑Yaa' yewoyɔɔn ‑vin mu 'ɛ 'mu 'a klɛgbɛya 'ɛ 'yele‑, 'ke 'mu 'mu 'wlɛyisriwole ‑a ‑la gbɛ ‑yɔɔ 'ɛ 'kɔɔ 'mu ma. 'Bhɛɛ‑ 'ke 'mu gele‑ 'bhɛ ‑za 'ɛ 'kpɛn 'yigɔɔnlɛ ‑o ‑kuŋlii 'ɛ ni. ");
INSERT INTO moa_vpl VALUES ("MT18_32","070_18_32","MAT","18","32","32","'Bhɛ klɛle 'tɛ, 'ke ‑o ‑kuŋlii 'ɛ 'bhɛ 'yee‑ yewonɛ 'ɛ 'siile, 'bhɛɛ‑ 'ke 'bhɛ 'a 'pele ‑a ni dɔɔ: ‹Mɛɛ 'kpee 'yɔɔ‑! 'Mi 'yaa‑ ca mu 'ɛ 'kpɛn mazatwa 'e ‑sroma 'la ꞊bwa 'ŋ ni 'bhɛ ‑zayi'. ");
INSERT INTO moa_vpl VALUES ("MT18_33","070_18_33","MAT","18","33","33","'Bhi 'yrɛnklaa‑ 'mi ma gɔnɛ‑ 'la gbɛɛn‑, 'e yewoyɔɔn 'ɛ 'yrɛn 'yaa‑ sɔ 'klale 'bhi ma 'bhɛɛ‑ gbɛɛn‑ 'ezin‑.› ");
INSERT INTO moa_vpl VALUES ("MT18_34","070_18_34","MAT","18","34","34","'Bhɛ ya 'ɛ 'yi bhe, ‑a ‑kuŋlii 'ɛ zruplii‑ gbɛ ‑yɔɔ' 'ɛ 'kɔɔ 'kee‑ 'yee‑ yewonɛ 'ɛ 'kpale mɛɛ 'la zan mu ‑yaa nu ‑yrɛnkpalɛ ‑a ta ‑kaso 'yi 'mu 'kɔɔ, 'sani‑ ‑e yan ‑yaa pɛ ca 'ɛ 'kpɛn gbawole 'le. ");
INSERT INTO moa_vpl VALUES ("MT18_35","070_18_35","MAT","18","35","35","«'Ŋ Dɛ ‑Waanbhaa' 'la ‑yoo laanima, ‑e nu 'ka 'kunlɛ‑ 'eyɔɔle 'bhɛɛ‑ gbɛɛn‑, 'ke 'ka 'kpɛn do do laa 'eke‑ a ‑sroma 'yanlɛ‑ 'ka zru 'ɛ 'kpɛn 'le.» ");
INSERT INTO moa_vpl VALUES ("MT19_1","070_19_1","MAT","19","1","1","Zesu 'yanle‑ 'bhɛ jan mu 'ɛ 'wolele, 'kee‑ gole‑ Galile 'klɛɛn 'ɛ 'yi, 'bhɛɛ‑ 'kee‑ gele‑ Zude 'klɛɛn gbɛ do 'la ‑yoo Zrudɛn yue 'ɛ 'yrɛ gbɛ do 'ɛ ta 'bhɛ 'yi. ");
INSERT INTO moa_vpl VALUES ("MT19_2","070_19_2","MAT","19","2","2","'Bhɛ ꞊nɔɔ bhe 'ezin‑, 'ke ‑zamaa' 'srɛ mu dɔle‑ ‑a zi; 'bhɛɛ‑ 'kee‑ 'mu a gadɛ mu 'ɛ bheele'. ");
INSERT INTO moa_vpl VALUES ("MT19_3","070_19_3","MAT","19","3","3","'Bhɛ yrɛ 'ɛ ꞊nɔɔ bhe, 'ke Farizi mu 'ke mu nule‑ ‑a ‑din, 'bhɛɛ‑ 'ke ‑wa ‑lrɔkpale ‑jan bhee bɔ zayi' ‑a ‑lɛɛ dɔɔ: «‑Kɔɔ' a 'toŋ 'ɛ ta, mɛɛ do sɔ 'ploole ‑a na ma 'ke 'bhɛ ‑za 'tɔle‑ ‑za ꞊kla ɛɛ?» ");
INSERT INTO moa_vpl VALUES ("MT19_4","070_19_4","MAT","19","4","4","'Bhɛ klɛle 'tɛ, 'ke Zesu ‑o ‑lrɔkpale dɔɔ: «'Ka 'laa ‑jan 'lɛɛ‑ 'bhɛ tapelɛ ‑Waanbhaa' a 'Sɛwɛ 'ɛ 'yi ɛɛ? ‑E pe 'kaa: ‹'Drunyan zisan' bhla 'ɛ zi, ‑Waanbhaa' 'gwlaan‑ 'pegee le ꞊kla;› ");
INSERT INTO moa_vpl VALUES ("MT19_5","070_19_5","MAT","19","5","5","'bhɛɛ‑ ‑e pe dɔɔ: ‹'Bhɛla‑ ‑zayile 'gwlaan‑ nu golɛ ‑a dɛ 'pegee ‑a nɛɛ ‑din, 'bhɛɛ‑ ‑o 'pegee ‑a na nu 'kpalɛ‑ do ma, 'bhɛɛ‑ ‑o mɛɛ plɛ nu klɛlɛ mɛɛ do 'kpɔ 'le.› ");
INSERT INTO moa_vpl VALUES ("MT19_6","070_19_6","MAT","19","6","6","'Bhɛ klɛgbɛya 'ɛ 'yi, waa nu klɛ ‑li mɛɛ plɛ, 'duŋ‑ ‑o nu klɛlɛ mɛɛ do 'kpɔ ‑la ‑le. ‑Waanbhaa' pɛ plɛ 'la ꞊kpaa 'eke‑ ma do, ‑yoo 'ke ‑za 'le 'ke bhaaplɛŋ 'laa ‑o go 'eke‑ ma.» ");
INSERT INTO moa_vpl VALUES ("MT19_7","070_19_7","MAT","19","7","7","'Bhɛ 'yi 'tɛ, 'ke *Farizi mu 'ɛ ‑o Zesu ꞊lrɔkpale 'kaadɔɔ‑: «‑Mɛle ꞊kla 'bhɛɛ‑ *Moizi 'a ꞊pia dɔɔ 'ke mɛɛ do ‑o ‑a zi 'bhii‑ ‑e gwlɛnna yaa‑ 'kan 'yee‑ 'pegee ‑a na pleŋ‑, ‑e 'bhɛ 'sɛwɛ 'kpa ‑a na 'kɔɔ, 'bhɛɛ‑ ‑e ploo 'bhɛ ma ɛɛ?» ");
INSERT INTO moa_vpl VALUES ("MT19_8","070_19_8","MAT","19","8","8","'Bhɛ klɛle 'tɛ, 'ke Zesu 'a 'pele ‑o ni dɔɔ: «'Ka zru ‑yɔɔya' ‑la ma, 'bhɛɛ‑ Moizi 'a ꞊pia 'ka ni 'ka 'ploo‑ 'ka 'na mu 'ɛ ma; 'kebhlaale, 'drunyan zisan' bhla 'ɛ zi yaa ‑yaa 'bhɛ gbɛɛn‑ ‑gee'. ");
INSERT INTO moa_vpl VALUES ("MT19_9","070_19_9","MAT","19","9","9","'Duŋ‑ 'mi pe 'ka ni dɔɔ: 'Ke mɛɛ 'la zan na laa gwlɛn ‑glinlɛ', 'ke 'bhɛ zan 'ɛ 'ploola‑ 'bhɛ 'na 'ɛ ma, 'bhɛɛ‑ 'kee‑ le ‑bhɛɛke' 'yalaa‑, 'bhɛ zan 'ɛ ‑e ‑yanbhɔɔya ‑la ꞊kla 'bhɛ gbɛɛn‑ bhe.» ");
INSERT INTO moa_vpl VALUES ("MT19_10","070_19_10","MAT","19","10","10","'Bhɛ klɛle 'tɛ, 'ke ‑yaa' ‑klaŋlanɛ mu 'ɛ ‑wa pele‑ ‑a ni dɔɔ: «'Ke 'gwlaan‑ do 'pegee ‑a na pleŋza ‑o 'bhɛɛ‑ gbɛɛn‑ bhe, ‑trɔn 'laa ‑o gwlɛnna yaale 'ɛ ma.» ");
INSERT INTO moa_vpl VALUES ("MT19_11","070_19_11","MAT","19","11","11","‑Ayile, 'ke Zesu 'a zikpale ‑o ni 'kaa: «Mɔkpɛn' 'laa sɔ dɔle‑ 'bhɛ ‑jan ‑glɔɔn 'lɛɛ‑ ꞊la, 'ke yaa 'e go ‑Waanbhaa' 'bhɛ 'seŋ ꞊naa mɛɛ mu 'la zan mu ni, 'mu ‑la ba. ");
INSERT INTO moa_vpl VALUES ("MT19_12","070_19_12","MAT","19","12","12","'Bhɛ ya 'ɛ 'yi, mɛɛ 'ke mu laa sɔ le 'sile, 'bhɛ ‑za 'ɛ ‑daa ‑a 'san ‑o ya yi ma. ‑A 'ke mu laa sɔ le 'sile, ‑amasrɔyi ‑woo 'gwlaan‑ ‑trɔ mu 'le. 'Bhɛɛ‑ mɛɛ 'ke mu 'ezin‑, waa dɔ ‑a ꞊la 'ke ‑o ‑le si laanima ‑bhleŋgbeya ‑wa 'ɛ 'bhɛ ‑za 'yi. 'Ke mɛɛ 'la zan sɔ ‑jan 'lɛɛ‑ 'yimale ‑ya ‑yima'!» ");
INSERT INTO moa_vpl VALUES ("MT19_13","070_19_13","MAT","19","13","13","Mɛɛ 'ke mu ‑nwa ‑nɛ 'ke mu 'le Zesu ni, 'kooko‑ ‑ya gbɛkpa' 'mu ma, 'bhɛɛ‑ ‑ya 'seriwo 'mu ma. 'Duŋ‑ ‑yaa' ‑klaŋlanɛ mu 'ɛ 'yranna‑ 'bhɛ zan mu 'ɛ zi. ");
INSERT INTO moa_vpl VALUES ("MT19_14","070_19_14","MAT","19","14","14","'Bhɛ 'yi 'tɛ, 'ke Zesu 'a 'pele ‑yaa' ‑klaŋlanɛ mu 'ɛ ni dɔɔ: «‑Kaa 'to 'ke ‑nɛ 'fiɛntrɔnnɛ mu 'ɛ nu 'ŋ ba, 'ka 'laa 'bhɛ 'saawolɛ ‑o 'kɔɔ dɔɔ waa nulɛ 'mi ba. ‑Amasrɔyi mɛɛ 'la zan mu ‑o 'bhii‑ ‑nɛ 'fiɛntrɔnnɛ mu 'lɛɛ‑ gbɛɛn‑, 'wole‑ nu gelɛ laanima ‑bhleŋgbeya ‑wa 'ɛ ta.» ");
INSERT INTO moa_vpl VALUES ("MT19_15","070_19_15","MAT","19","15","15","'Bhɛ blaan, 'ke Zesu 'e gbɛ 'kpale 'woo‑ ‑nɛ mu 'ɛ ma, 'bhɛɛ‑ 'kee‑ gele‑ yrɛ ‑bhɛɛke' do ꞊nɔɔ. ");
INSERT INTO moa_vpl VALUES ("MT19_16","070_19_16","MAT","19","16","16","Mɛɛ do 'e 'mabɛɛnna Zesu ‑din, 'bhɛɛ‑ ‑ya ꞊lrɔkpaa dɔɔ: «'O Daan mi, 'ŋ sɔ ‑mɛ za ‑lrele' 'gbu ‑la klɛle‑, 'bhɛɛ‑ 'ŋ ‑Waanbhaa' ba bole ‑yrɛ ma ‑si 'la ‑daŋ' 'laa ‑o ‑a ma 'bhɛ 'srɔɔwo‑ ɛɛ?» ");
INSERT INTO moa_vpl VALUES ("MT19_17","070_19_17","MAT","19","17","17","'Bhɛ 'yi 'tɛ, 'ke Zesu 'a 'pele ‑a ni 'kaa: «‑Mɛle ꞊kla 'bhɛɛ‑ 'yoo‑ 'ŋ ꞊lrɔkpa' zii' ‑za 'wlan za ma ɛɛ? ‑Waanbhaa' do ‑kplɛn ‑le 'ewlanle. 'Ke 'ya ꞊pia ‑e gele‑ bole ‑yrɛ ma ‑si yrɛ 'ɛ ꞊nɔɔ, 'toŋ mu 'ɛ 'klɔsikun.» ");
INSERT INTO moa_vpl VALUES ("MT19_18","070_19_18","MAT","19","18","18","'Yee‑ mɛɛ pe Zesu dɔɔ: «'Toŋ mu 'ɛ ‑dele ɛɛ?» 'Bhɛɛ‑ Zesu 'a 'lɛkwan‑ ‑a ni dɔɔ 'woo‑ 'toŋ mu 'ɛ 'wole‑ ‑gɛ: «'Yaa mɛɛ dɛlɛ; 'yaa ‑yanbhɔɔya klɛlɛ, 'yaa ‑faanwolɛ, 'bhɛ 'pegee 'yaa bhla 'kpalɛ‑ mɛɛ 'kedo‑ 'kpɔ ma; ");
INSERT INTO moa_vpl VALUES ("MT19_19","070_19_19","MAT","19","19","19","'bhɛɛ‑ 'yee dɛ 'pegee 'e nɛɛ ‑lɛdɔ' ‑a ma; 'bhɛ 'pegee 'e ‑vindo' mi ‑za 'sɔ 'e ni 'bhii‑ 'e ‑za sɔ 'e 'gbu ni gɔnɛ‑ 'la gbɛɛn‑.» ");
INSERT INTO moa_vpl VALUES ("MT19_20","070_19_20","MAT","19","20","20","'Duŋ‑ 'yee‑ ‑zwannɛ 'e pe Zesu ni 'kaa: «'Ŋ 'bhɛ 'toŋ mu 'la bhe 'mu 'kpɛn 'klɔsikwan gban, 'ŋ sɔ ‑a ‑dela 'klɔsikunle 'ezin‑ ɛɛ?» ");
INSERT INTO moa_vpl VALUES ("MT19_21","070_19_21","MAT","19","21","21","'Bhɛ klɛle 'tɛ, 'ke Zesu 'a 'pele ‑a ni dɔɔ: «'Kee 'yoo‑ ‑a zi 'bhii‑ 'e 'lɛsɔle klɛ, ge 'e 'kɔɔpɛ‑ mu 'ɛ 'kpɛn gɔn, 'bhɛɛ‑ ‑o ma ‑gɔli' 'ɛ 'na 'kɔɔfleŋzan mu ni. 'Kee 'bhɛ ꞊kla, 'bhɛɛ‑ 'yaa‑ ‑naflo ‑bebe nu klɛlɛ laflɛ' 'yi. 'Bhɛ blaan, nu dɔ 'ŋ zi 'tɛ.» ");
INSERT INTO moa_vpl VALUES ("MT19_22","070_19_22","MAT","19","22","22","'Duŋ‑ 'yee‑ ‑zwannɛ 'ɛ ‑e 'bhɛ ‑jan mu 'ɛ 'male‑, 'kee‑ gele‑ ‑a wlɛyisriwole 'le, ‑amasrɔyi naflo ‑bebe ‑yaa 'kɔɔ. ");
INSERT INTO moa_vpl VALUES ("MT19_23","070_19_23","MAT","19","23","23","'Bhɛ 'yi 'tɛ, 'ke Zesu 'a 'pele ‑yaa' ‑klaŋlanɛ mu 'ɛ ni dɔɔ: «'Mi pe 'ka ni wlan 'ɛ ni dɔɔ: ‑Naflo zan do gele la laanima ‑bhleŋgbeya ‑wa 'ɛ ta 'dɛ. ");
INSERT INTO moa_vpl VALUES ("MT19_24","070_19_24","MAT","19","24","24","'Bhɛɛ‑ 'mi 'a pe 'ka ni 'ezin‑ dɔɔ: ‑Naflo zan do gele laanima ‑bhleŋgbeya ‑wa 'ɛ ta 'bhɛ 'lale‑ 'yiya‑ 'ke 'bhɛ kan 'yɔɔnma do 'kanle‑ ma ‑mlɛsiɛnnɛ do ‑gluu zi 'bhɛ ta.» ");
INSERT INTO moa_vpl VALUES ("MT19_25","070_19_25","MAT","19","25","25","Zesu a ‑klaŋlanɛ mu 'ɛ, ‑o 'bhɛ ‑jan 'ɛ 'male‑, 'ke ‑o 'kpeelɛnile ‑o ma, 'bhɛɛ‑ 'ke ‑wa pele‑ dɔɔ: «‑De 'gbu ‑le sɔ gole‑ ‑za 'yi ɛɛ?» ");
INSERT INTO moa_vpl VALUES ("MT19_26","070_19_26","MAT","19","26","26","Zesu 'e 'yrɛkpale ‑o ta, 'ke ‑ya pele‑ ‑o ni dɔɔ: «'Bhɛ ‑za 'ɛ klɛ 'seŋ 'laa ‑o bhaaplɛŋ mu ni. 'Duŋ‑ ‑za 'kpɛn 'seŋ ‑o ‑Waanbhaa' ni.» ");
INSERT INTO moa_vpl VALUES ("MT19_27","070_19_27","MAT","19","27","27","'Bhɛ klɛle 'tɛ, 'ke Piɛri 'a 'pele Zesu ni dɔɔ: «'E 'yrɛkpa ‑gɛ, 'o mɔɔ ‑ploola pɛ 'kpɛn ma, 'bhɛɛ‑ ‑o ꞊nwa 'e zi, 'o mɔɔ nu ‑mɛ ‑trɔn ‑la ‑srɔɔwolɛ 'bhɛ ma ɛɛ?» ");
INSERT INTO moa_vpl VALUES ("MT19_28","070_19_28","MAT","19","28","28","'Bhɛ klɛle 'tɛ, 'ke Zesu 'a 'pele ‑o ni dɔɔ: «'Mi pe 'ka ni wlan 'ɛ ni dɔɔ: 'Ke *Bhaaplɛŋ Gbe 'ɛ 'yalaa‑ yi ‑nɛ 'la ta ‑yaa' 'tɔbhɔ ma ‑bhleŋgbe 'yaakpe‑ 'ɛ ta 'drunyan drɛɛ 'ɛ 'yi, 'ka mu mɛɛ vu ta plɛ 'la 'yaa‑ 'ŋ zi yrɛkpɛn‑ ꞊nɔɔ, ‑o nu ‑bhleŋgbeya 'yaakpe‑ mu nalɛ 'ka 'kpɛn do do ni, 'bhɛɛ‑ 'ka nu Izraɛli ‑gbaa vu ta plɛ 'ɛ 'kitikanlɛ. ");
INSERT INTO moa_vpl VALUES ("MT19_29","070_19_29","MAT","19","29","29","'Bhɛɛ‑ 'duŋ‑, 'ke mɛɛ 'la zan ‑yaa' 'fɛ mu oo, ‑a nɛɛnɛ‑ 'gwlaan‑ mu 'pegee ‑a nɛɛnɛ‑ le mu oo, ‑a dɛ 'pegee ‑a nɛɛ oo, ‑a ‑nɛ mu 'pegee ‑yaa' gba mu 'kpɛn ꞊twa ‑a nɔɔ‑ 'mi ‑zayi', 'bhɛ zan nu 'bhɛ yɛkɛ‑ maza ‑glɔɔn ‑kɛmɛ do ‑srɔɔwolɛ, 'bhɛɛ‑ ‑a 'ciɛn nu klɛlɛ 'ke ‑Waanbhaa' ba bole ‑yrɛ ma ‑si 'la ‑daŋ' 'laa ‑o 'bhɛ ma 'bhɛɛ‑ 'le. ");
INSERT INTO moa_vpl VALUES ("MT19_30","070_19_30","MAT","19","30","30","'Duŋ‑, mɛɛ 'la zan mu ‑o ‑zɔn zilɛɛ‑ mu 'le, 'mu ‑bebe nu klɛlɛ ‑zanta' mu 'le too; 'bhɛɛ‑ mɛɛ 'la zan mu ‑o ‑zɔn ‑zanta' mu 'le, 'mu ‑bebe mu nu klɛlɛ zilɛɛ‑ mu 'le too.» ");
INSERT INTO moa_vpl VALUES ("MT20_1","070_20_1","MAT","20","1","1","Zesu pe 'ezin‑ dɔɔ: «Laanima ‑Bhleŋgbeya ‑wa 'ɛ 'pwɛle‑ ‑o 'ke gbazan do a ‑za ‑la ‑le. 'Yee‑ gbazan 'ɛ 'pwɛla‑ zrwan 'tutu 'ɛ zi, 'kooko‑ ‑e sɔ yewonɛ mu 'kunle, 'bhɛɛ‑ 'mu ge yewolɛ ‑yaa' ‑drɔɔ gba 'ɛ ta. ");
INSERT INTO moa_vpl VALUES ("MT20_2","070_20_2","MAT","20","2","2","'Yee‑ 'pegee yewonɛ mu 'ɛ ‑bɛŋgwa ‑yrekpaa' do ta ye ‑sra 'ɛ 'bhɛ ma, 'bhɛ 'yaa‑ denie ‑gɔli' 'taŋbha do. 'Bhɛ 'yi 'ke ‑yoo winbɔle yewo yrɛ nɔɔ‑ ‑yaa' ‑drɔɔ gba 'ɛ 'yi. ");
INSERT INTO moa_vpl VALUES ("MT20_3","070_20_3","MAT","20","3","3","'Bhɛ blaan, ‑yretɛbhɛ gwlɛn ‑wlɛn bhla 'ɛ zi, 'ke 'yee‑ gbazan 'ɛ ge gbɛ drɛɛwole ‑wa 'kpee ‑kpan 'ɛ ta 'ezin‑, 'bhɛɛ‑ 'kee‑ yewonɛ 'bhɛɛke mu yele‑: 'Mu 'laa ‑yaa ye 'kedo‑ 'kpɔ 'wo zii'. ");
INSERT INTO moa_vpl VALUES ("MT20_4","070_20_4","MAT","20","4","4","‑Ayile, 'ke gbazan 'ɛ ‑ya pele‑ ‑o ni dɔɔ: ‹'Ka mu ge 'ezin‑ yewo 'an ‑drɔɔ gba 'ɛ ta, 'bhɛɛ‑ 'ŋ nu ‑yrekpaa' do ta ‑sra 'nalɛ‑ 'ka ni.› ");
INSERT INTO moa_vpl VALUES ("MT20_5","070_20_5","MAT","20","5","5","'Bhɛ klɛle 'tɛ, 'ke 'bhɛ yewonɛ mu 'ɛ ‑o gele‑ gba 'ɛ ta. ‑Yrekpaa' bhɔle, 'ke gbazan 'ɛ gele‑ 'ezin‑ ‑wa 'ɛ 'kpee, yewonɛ mu baan' ‑glin yrɛ nɔɔ‑; 'bhɛɛ‑ ‑yretɛbhɛ bhlɔ bii bhla 'ɛ zi, 'ke ‑ya klɛle‑ 'bhɛ klɛgbɛya do 'ɛ 'yi. ");
INSERT INTO moa_vpl VALUES ("MT20_6","070_20_6","MAT","20","6","6","‑Yretɛbhɛ baa‑ 'waati 'ɛ ba, 'ke gbazan 'ɛ ge gbɛ drɛɛwole 'ezin‑ ‑wa 'kpee ‑kpan 'ɛ ta, 'kee‑ yewonɛ mu 'ɛ 'ke mu yele‑. 'Bhɛ klɛle 'ke ‑yoo ‑lrɔkpale dɔɔ: ‹'Kee‑ 'san zrwanzi 'ɛ ma, 'ke 'bhɛ nu 'tɛnlɛ‑ yromazi 'ɛ ma, ‑mɛle ꞊kla 'bhɛɛ‑ 'ka dulale ‑o ‑gɛ 'ke 'ka 'laa ye 'kedo‑ 'kpɔ wo ɛɛ?› ");
INSERT INTO moa_vpl VALUES ("MT20_7","070_20_7","MAT","20","7","7","'Bhɛ ya 'ɛ 'yi, 'ke ‑wa ‑lɛkunle gbazan 'ɛ ni 'kaa: ‹Mɛɛ 'kedo‑ 'kpɔ 'laa ye nalɛ ‑o ni.› 'Bhɛɛ‑ 'ke ‑ya pele‑ ‑o ni dɔɔ: ‹'Ka mu ge 'ezin‑ yewo 'an ‑drɔɔ gba 'ɛ ta!›» ");
INSERT INTO moa_vpl VALUES ("MT20_8","070_20_8","MAT","20","8","8","«Yromazi bhɔle, 'ke gbazan 'ɛ ‑ya pele‑ ‑yaa' yewonɛ mu ‑kuŋlii 'ɛ ni dɔɔ: ‹Yewonɛ mu 'ɛ 'sii, 'bhɛɛ‑ ‑o 'kpɛn gbawo do do 'kee‑ san mɛɛ 'la zan mu ‑nwa boolazi 'mu ma, 'kee‑ ge 'tɛnlɛ‑ mɛɛ ‑lwa mu 'ɛ ma.› ");
INSERT INTO moa_vpl VALUES ("MT20_9","070_20_9","MAT","20","9","9","Yromazi ‑yretɛbhɛ baa‑ bhla zi mɛɛ mu 'ɛ 'nule‑, 'ke ‑o 'kpɛn do do ‑yrekpaa' do ta ‑sra ‑srɔɔwole. ");
INSERT INTO moa_vpl VALUES ("MT20_10","070_20_10","MAT","20","10","10","'Bhɛ blaan, zrwan 'tutu zi mu 'ɛ, 'mu 'bhɛ 'yele‑, 'mu 'kpee ma, 'mu ‑sra 'ɛ 'yaa‑ 'kanlɛ‑ boolazi mu 'ɛ 'mu a pɛ ‑sra 'ɛ ta. 'Duŋ‑ ‑o 'kpɛn do do ‑yrekpaa' do ta ‑sra ‑la ‑srɔɔwoa. ");
INSERT INTO moa_vpl VALUES ("MT20_11","070_20_11","MAT","20","11","11","'Bhɛ mu 'bhɛ ‑yrekpaa' do ta ‑sra 'ɛ ‑srɔɔwole, 'bhɛ 'lalawoa ‑o ma, ‑o gbazan 'ɛ 'tɔpia‑ ‑o ‑lɛla'. ");
INSERT INTO moa_vpl VALUES ("MT20_12","070_20_12","MAT","20","12","12","'Bhɛɛ‑ 'ke wa pele‑ dɔɔ: ‹Yewonɛ mu 'lɛɛ‑ 'mu ꞊nwa ‑yretɛbhɛ baale blaan, 'bhɛɛ‑ ‑o yewoa‑ 'waati sanɛ‑ 'gbu ‑la ba, 'bhɛɛ‑ 'yoo 'kpɛn 'sra‑ 'ɛ ꞊kla do. 'O mɔɔ 'duŋ‑ 'o ‑yrekpaa' do 'ɛ ‑gaa 'o 'trɛbhɔlele ye 'ɛ 'kɔɔ ‑yretɛbhɛ ‑bhile' 'ɛ ꞊la.› ");
INSERT INTO moa_vpl VALUES ("MT20_13","070_20_13","MAT","20","13","13","'Bhɛ klɛle 'tɛ, 'ke gbazan 'ɛ ‑ya zikpale ‑o do ni dɔɔ: ‹'Ŋ 'bhɛgwlɛn‑, 'naa 'e tabhlelɛ, 'bhi 'pegee 'mi 'laa ‑bɛŋgolɛ ‑yrekpaa' do ta ‑sra ‑la ma ɛɛ? ");
INSERT INTO moa_vpl VALUES ("MT20_14","070_20_14","MAT","20","14","14","'Yaa‑ ‑sra 'ɛ 'kun ‑gɛ 'bhɛɛ‑ ge 'e ba. 'Ŋ ‑sra yɛkɛ‑ 'la 'naa‑ 'e ni, 'ŋ 'yoo‑ ‑a zi 'bhii‑ 'ŋ 'bhɛɛ‑ yɛkɛ‑ 'na mɛɛ la zan yewoa‑ boolazi 'bhɛ ni 'ezin‑. ");
INSERT INTO moa_vpl VALUES ("MT20_15","070_20_15","MAT","20","15","15","'Ke pɛ 'la klɛle ‑swa 'ŋ ni 'ŋ 'kɔɔpɛ‑ mu 'ɛ 'le, 'naa sɔ 'bhɛ klɛle‑ ɛɛ? Taa‑ 'yee ‑tɛɛkpa' zii' 'ŋ ma 'an wlanya 'ɛ ‑za 'yi ɛɛ?›» ");
INSERT INTO moa_vpl VALUES ("MT20_16","070_20_16","MAT","20","16","16","'Bhɛ klɛgbɛya 'ɛ 'yi, Zesu pe 'ezin‑ dɔɔ: «Mɛɛ 'la zan mu ‑o ‑zɔn ‑zanta' mu 'le, 'mu ‑le nu klɛlɛ zilɛɛ‑ mu 'le too; 'bhɛɛ‑ mɛɛ 'la zan mu ‑o zilɛɛ‑ mu 'le ‑zɔn, 'mu ‑le nu klɛlɛ ‑zanta' mu 'le too.» ");
INSERT INTO moa_vpl VALUES ("MT20_17","070_20_17","MAT","20","17","17","Zesu 'yaa‑ Zeruzalɛmu 'taa 'ɛ ta bhla 'la ba, 'kee‑ yaa ‑klaŋlanɛ mu 'ɛ 'siile 'edaŋma, 'bhɛɛ‑ 'ke ‑ya pele‑ ‑o ni dɔɔ: ");
INSERT INTO moa_vpl VALUES ("MT20_18","070_20_18","MAT","20","18","18","«‑Ka 'ka 'trɔnbadɔ doo, ‑kɔɔ' gelawo zii' Zeruzalɛmu ‑gɛ bhe, ‑o nu Bhaaplɛŋ Gbe 'ɛ 'lɛnalɛ 'sraka 'lɛna ‑kuŋlii mu 'ɛ 'pegee 'Toŋ daan mu 'ɛ ni, 'bhɛɛ‑ 'mu nu a pelɛ 'kaa ‑wa dɛ. ");
INSERT INTO moa_vpl VALUES ("MT20_19","070_20_19","MAT","20","19","19","‑O nu a ‑lɛnalɛ Zuufu kle mu 'ɛ ni, 'bhɛɛ‑ 'mu nu 'sɔnsilɛ ‑a ma, 'bhɛɛ‑ 'mu nu ‑a zita zɔnlɛ 'ke gbaŋbhlɛ 'le; 'bhɛ blaan, 'mu nu a gbaanlɛ ‑yrigbɛɛle do ta. 'Duŋ‑, ‑a gale blaan ‑yrekpaa' yaga mi ma, ‑e nu bwelɛ gale ba.» ");
INSERT INTO moa_vpl VALUES ("MT20_20","070_20_20","MAT","20","20","20","'Bhɛ klɛle 'tɛ, 'ke Zebede 'na, Zaki 'pegee Zaan nɛɛ 'ɛ, 'bhɛ 'e 'mabɛɛnle Zesu ‑din, 'ke ‑ya 'kpɔ zɛnle‑ Zesu 'lɛɛ, 'bhɛɛ‑ 'kee‑ ‑za do ‑yrɛwole 'bhɛ ma. ");
INSERT INTO moa_vpl VALUES ("MT20_21","070_20_21","MAT","20","21","21","Zesu pe ‑a ni dɔɔ: «'Yoo‑ ‑mɛ pɛ ‑la zi ɛɛ?» ‑Ayile, 'ke ‑ya pele‑ Zesu ni dɔɔ: «'E 'liiwli‑ na 'ŋ ni 'bhɛ ta dɔɔ 'kee ‑ja yaalɛ 'waati 'la ba 'yaa‑ ‑bhleŋgbeya yaayrɛ 'ɛ 'nɔɔ‑, dɔ ‑a ‑la 'ke 'ŋ gbe plɛ 'lɛɛ‑ ‑a do yalaa' 'e gbɛyiɛ ta, 'bhɛɛ‑ ‑a ‑bhɛɛke' do 'ɛ 'bhɛ yalaa' 'e gbɛkoo‑ ta.» ");
INSERT INTO moa_vpl VALUES ("MT20_22","070_20_22","MAT","20","22","22","'Bhɛ ya 'ɛ 'yi, 'ke Zesu 'a 'pele dɔɔ: «'Ka ‑o pɛ 'la 'yrɛwo zii' 'ŋ ma 'ka 'laa 'bhɛ dɔ. 'Ŋ nu ‑yrɛn pɛyan‑ do 'la 'bhɛ milɛ 'ka sɔ 'bhɛ 'mile‑ ɛɛ?» ‑Wa ‑lɛkwan Zesu ni dɔɔ: «‑Aani'! 'O mɔɔ sɔ 'bhɛ 'mile.» ");
INSERT INTO moa_vpl VALUES ("MT20_23","070_20_23","MAT","20","23","23","'Bhɛ klɛlɛ 'tɛ, 'ke Zesu 'a 'pele ‑o ni dɔɔ: «Wlan ‑le 'bhɛ 'le, 'ŋ nu ‑yrɛn pɛyan‑ do 'la 'milɛ‑ 'ka nu 'sɔlɛ‑ 'bhɛ 'ke 'milɛ‑. 'Duŋ‑ 'ŋ gbɛyiɛ ta yaayrɛ oo, 'ŋ gbɛkoo‑ ta yaayrɛ oo, 'mi 'laa ‑o 'bhɛ 'na mi 'le. 'Ŋ Dɛ ‑Waanbhaa' ‑le 'bhɛ yaayrɛ mu 'ɛ ‑lɛmagaanna gban mɛɛ 'la zan mu ni, ‑e nu 'mu 'nalɛ‑ 'bhɛɛ‑ zan mu ‑la ni.» ");
INSERT INTO moa_vpl VALUES ("MT20_24","070_20_24","MAT","20","24","24","Zesu a ‑klaŋlanɛ mu ‑vin vu 'ɛ 'bhɛ ‑jan 'ɛ 'male‑, 'ke ‑woo zrupliile 'woo‑ nɛɛnɛ‑ ma plɛ 'ɛ ma. ");
INSERT INTO moa_vpl VALUES ("MT20_25","070_20_25","MAT","20","25","25","'Bhɛla‑ ‑yile, 'ke Zesu ‑o 'kpɛn 'siile, 'bhɛɛ‑ 'ke ‑ya pele‑ ‑o ni dɔɔ: «'Kaa 'yaango‑ dɔɔ 'drunyan 'lɛɛ‑ 'yi mɛɛ gblaan mu 'ɛ 'kpaale‑ ‑o ‑waa' mɛɛ mu 'ɛ 'wiiŋ‑, 'bhɛɛ‑ ‑o mɛɛ mu ŋgblo kpalaa' ‑o ꞊la. ");
INSERT INTO moa_vpl VALUES ("MT20_26","070_20_26","MAT","20","26","26","'Duŋ‑, 'ka mu laa 'bhɛ 'yansi za klɛlɛ 'ka 'pleŋ‑. 'Ke mɛɛ 'la zan ‑a zi 'bhii‑ ‑e klɛ 'ka ta mɛɛ gblaan 'le, 'bhɛ zan 'ɛ klɛ 'kaa‑ yewonɛ 'le. ");
INSERT INTO moa_vpl VALUES ("MT20_27","070_20_27","MAT","20","27","27","'Bhɛɛ‑ 'ke mɛɛ 'la zan ‑a zi 'bhii‑ ‑e klɛ 'ka 'kpɛn 'lɛɛ mi 'le, 'bhɛ zan 'ɛ klɛ 'kaa‑ lu 'le. ");
INSERT INTO moa_vpl VALUES ("MT20_28","070_20_28","MAT","20","28","28","'Bhɛ klɛgbɛya do 'yi bhe, Bhaaplɛŋ Gbe 'ɛ yaa nulɛ mɛɛ mu klɛlɛ ‑yaa' yewonɛ mu 'le, 'duŋ‑ ‑e ꞊nwa ‑a 'gbu klɛlɛ mɔkpɛn' a yewonɛ 'le, 'bhɛ 'pegee 'ke ‑ya 'gbu 'si 'ɛ klɛ 'ke mɛɛ ‑bebe tagbawo pɛ 'le ‑Waanbhaa' ni.» ");
INSERT INTO moa_vpl VALUES ("MT20_29","070_20_29","MAT","20","29","29","‑O gole Zeriko ‑wa 'ɛ 'kpee, 'ke ‑zamaa' 'srɛ do dɔle‑ ‑o zi. ");
INSERT INTO moa_vpl VALUES ("MT20_30","070_20_30","MAT","20","30","30","'Bhɛ ꞊nɔɔ bhe, ‑yrɛ 'wi mi plɛ yaale ‑yaa zi 'ɛ 'lɛzi‑, 'bhɛɛ‑ 'mu 'a male 'kaa Zesu yaa‑ 'kan zii', 'ke 'mu ‑gbekanle 'ke ‑wa pe dɔɔ: «Mɛɛzan, Davidi 'nranɛ‑, 'o 'yrɛnkla 'e ma!» ");
INSERT INTO moa_vpl VALUES ("MT20_31","070_20_31","MAT","20","31","31","'Duŋ‑, ‑zamaa' 'ɛ 'yaa‑ ‑yran 'zi ‑o zi dɔɔ ‑woo taga. 'Bhɛɛ‑ drɔɔn', ‑o ‑yaa ‑gbekan' zii' 'ezin‑ 'eglɔɔle dɔɔ: «Mɛɛzan, Davidi 'nranɛ‑, 'o 'yrɛnkla 'e ma!» ");
INSERT INTO moa_vpl VALUES ("MT20_32","070_20_32","MAT","20","32","32","'Bhɛ klɛle 'tɛ, 'ke Zesu dulale, 'ke ‑yoo 'siile, 'bhɛɛ‑ 'ke ‑yoo ‑lrɔkpale dɔɔ: «'Kaa‑ zi 'bhii‑ 'ŋ ‑mɛ pɛ za 'gbu ‑la klɛ 'ka ni ɛɛ?» ");
INSERT INTO moa_vpl VALUES ("MT20_33","070_20_33","MAT","20","33","33","‑Wa ‑lɛkwan Zesu ni dɔɔ: «Mɛɛzan, ‑a klɛ 'bhɛɛ‑ 'o 'yrɛ 'liiploo‑, 'bhɛɛ‑ 'o yrɛ ma ye.» ");
INSERT INTO moa_vpl VALUES ("MT20_34","070_20_34","MAT","20","34","34","'Bhɛ 'yi bhe, 'ke ‑o ‑yrɛnklale Zesu ma, 'bhɛɛ‑ 'ke ‑ya gbɛ 'kpale ‑o ‑yrɛ mu 'ɛ ta. 'Bhɛ yrɛ do 'ɛ ꞊nɔɔ bhe, 'ke ‑o ‑yrɛ 'liiploole, 'bhɛɛ‑ 'ke ‑o dɔle‑ Zesu zi. ");
INSERT INTO moa_vpl VALUES ("MT21_1","070_21_1","MAT","21","1","1","Zesu 'pegee ‑yaa' ‑klaŋlanɛ mu 'ɛ ꞊bhwa Zeruzalɛmu ‑wa 'ɛ ‑din ‑wa 'nɛ do 'la ‑o ‑yaa 'bhɛ sii Bɛtifaze 'bhɛ ta. 'Bhɛ ‑wa 'nɛ 'ɛ 'yaa‑ vlɛ gɔɔn 'la kpɛ ‑la ‑o ‑yaa 'bhɛ sii ‹Olivi diiŋ vlɛ gɔɔn›. 'Bhɛɛ‑ 'kee‑ ‑yaa' ‑klaŋlanɛ plɛ winbɔle ‑o ‑lɛɛ dɔɔ: ");
INSERT INTO moa_vpl VALUES ("MT21_2","070_21_2","MAT","21","2","2","«‑Ka ge 'ka 'lɛɛ ‑wa 'nɛ 'la bhe 'bhɛ ta; 'ke 'ka ꞊bhwa ‑a ꞊nɔɔ ‑gun, 'ka nu ‑soofali da do ‑yrele' yelɛ ‑yri diiŋ do ma; 'bhɛɛ‑ ‑a ‑nɛ do dulale ‑o ‑a ‑din. ‑Ka ‑o 'ploo‑, 'bhɛɛ‑ 'ka nu 'ke ‑o ‑le. ");
INSERT INTO moa_vpl VALUES ("MT21_3","070_21_3","MAT","21","3","3","'Ke mɛɛ 'la zan 'ka 'lrɔkpaa‑, 'kaa pe 'bhɛ zan 'ɛ ni dɔɔ: ‹Mɛɛzan maza ‑dwa ‑o ma.› 'Ke 'bhɛ ꞊kla, 'bhɛ yrɛ do 'ɛ ꞊nɔɔ bhe, ‑e nu dɔlɛ ‑a ‑la 'ke 'ka nu ‑o ‑le.» ");
INSERT INTO moa_vpl VALUES ("MT21_4","070_21_4","MAT","21","4","4","'Duŋ‑ 'bhɛ ꞊kla 'bhɛɛ‑ klɛgbɛya do 'ɛ 'yi, 'kooko‑ ‑Waanbhaa' ‑lɛla' janwo mi 'ɛ ‑jan 'la ꞊woa 'elwale gban 'bhɛ 'lɛsɔ‑; ‑ya ꞊pia dɔɔ: ");
INSERT INTO moa_vpl VALUES ("MT21_5","070_21_5","MAT","21","5","5","«‑Kaa pe Zeruzalɛmu ‑wa 'ɛ ta mu 'ɛ ni 'kaa: ‑Ka 'ka ‑yrɛkpa' doo, 'kaa ‑bhleŋgbe 'yidɔɔ‑ bhabha 'ɛ ‑yoo zan, ‑a yaale ‑o ‑soofali 'nɛ do ta, ‑soofali da do 'kpee ‑nɛ.» ");
INSERT INTO moa_vpl VALUES ("MT21_6","070_21_6","MAT","21","6","6","‑Yaa' ‑klaŋlanɛ plɛ 'ɛ ‑o gele, ‑ya ꞊pia ‑o ni ‑o ‑za 'la klɛ 'ke ‑o 'bhɛ klɛle‑. ");
INSERT INTO moa_vpl VALUES ("MT21_7","070_21_7","MAT","21","7","7","‑Ayile, 'ke ‑o nule‑ ‑soofali da 'pegee 'bhɛ 'nɛ 'ɛ 'le. 'Bhɛɛ‑ 'ke ‑woo ta dunɛ‑ tralapɛ mu 'ɛ gole‑, 'bhɛɛ‑ 'ke ‑o 'mu 'kpaale ‑soofali mu 'ɛ ta. 'Bhɛɛ‑ 'ke ‑o Zesu 'yaale 'bhɛ do ta. ");
INSERT INTO moa_vpl VALUES ("MT21_8","070_21_8","MAT","21","8","8","'Bhɛ klɛgbɛya do 'ɛ 'yi, ‑zamaa' 'ɛ 'pleŋ‑ mɛɛ ‑bebe 'mu ta dunɛ‑ tralapɛ mu 'ɛ ‑gwa, 'bhɛɛ‑ ‑o 'mu ‑kpalaa' zibhɛ 'ɛ 'lii; mɛɛ 'ke mu ‑yri ‑laa mu ‑kaan, 'bhɛɛ‑ 'mu 'bhɛ mu ‑kpalaa' zibhɛ 'ɛ 'lii 'ezin‑. ");
INSERT INTO moa_vpl VALUES ("MT21_9","070_21_9","MAT","21","9","9","'Bhɛ klɛle 'tɛ, 'ke ‑zamaa' 'ɛ 'lɛdo‑ 'kanle ‑a ‑lɛɛ, 'bhɛɛ‑ 'ke ‑a ‑lɛ ‑vindo' 'ɛ dɔle‑ ‑a zi, 'bhɛɛ‑ 'ke ‑woo ‑weli' mu 'ɛ 'wlɛnle‑ 'eke‑ zi 'ke ‑wa pe dɔɔ: «Ozana! Davidi 'nranɛ‑ 'ɛ ‑yaa' pɛ ‑le 'ke 'tɔbhɔleya 'le! Mɛɛ 'la zan ‑o zan Mɛɛzan 'tɔ 'ɛ 'yi, bhaa ‑Waanbhaa' 'e ‑dɔɔbo'! ‑Waanbhaa' a 'tɔbhɔleya 'ɛ ‑yoo yikpɛnsee ta laflɛ' 'yi!» ");
INSERT INTO moa_vpl VALUES ("MT21_10","070_21_10","MAT","21","10","10","Zesu 'wla bhla 'ɛ zi Zeruzalɛmu, ‑wa 'ɛ ta mu 'ɛ 'kpɛn 'yaa‑ ‑o gaan ta. 'Bhɛɛ‑ mɛɛ mu 'ɛ 'yaa‑ 'eke‑ ‑lrɔkpa' zii' dɔɔ: «‑Dele mɛɛ 'lɛɛ‑ 'le ɛɛ?» ");
INSERT INTO moa_vpl VALUES ("MT21_11","070_21_11","MAT","21","11","11","‑Zamaa' 'ɛ 'yaa‑ 'lɛkun zii' ‑o ni dɔɔ: «‑Waanbhaa' ‑lɛla' janwo mi Zesu ‑le. ‑E da Nazarɛti, Galile 'klɛɛn 'ɛ 'yi ‑wa 'nɛ do ta.» ");
INSERT INTO moa_vpl VALUES ("MT21_12","070_21_12","MAT","21","12","12","Zesu ‑ja wlalɛ ‑Waanbhaa' Gba 'Fɛ ‑Gbɛnɛ 'ɛ ꞊la, 'kee‑ pɛgɔn mu 'ɛ 'pegee pɛlɔ‑ mu 'ɛ 'kpɛn ‑gbinle' ‑a ‑la. ‑E ‑gɔli' tabɔɔ mu 'ɛ ‑waa' ‑tabali mu 'pegee kpro gɔn mu 'ɛ 'yaakpe‑ mu 'ɛ 'kpɛn 'lɛbhulaa. ");
INSERT INTO moa_vpl VALUES ("MT21_13","070_21_13","MAT","21","13","13","'Bhɛ blaan, 'ke ‑ya pele‑ ‑o ni dɔɔ: «‑Waanbhaa' pe ‑yaa' 'Sɛwɛ 'ɛ 'yi dɔɔ: ‹‑O nu 'a pelɛ 'an 'fɛ 'ɛ ma 'seriwofɛ.› 'Bhɛɛ‑ 'ka mu 'a ꞊kla 'ke ‑faannii' mu gaan 'fɛ 'le.» ");
INSERT INTO moa_vpl VALUES ("MT21_14","070_21_14","MAT","21","14","14","‑Yrɛ 'wi mu 'pegee gaan 'siɛ mu 'ke mu ꞊nwa Zesu ‑din ‑Waanbhaa' Gba 'Fɛ ‑Gbɛnɛ 'ɛ ꞊la, 'bhɛɛ‑ ‑yoo 'kpɛn 'bheela‑. ");
INSERT INTO moa_vpl VALUES ("MT21_15","070_21_15","MAT","21","15","15","'Duŋ‑ 'sraka 'lɛna ‑kuŋlii mu 'ɛ 'pegee 'Toŋ daan mu 'ɛ ‑o Zesu a 'sɔle‑ maza mu 'ɛ 'yele‑, 'bhɛ 'pegee ‑wa male 'kaa ‑nɛ 'ke mu ‑yaa pe 'zi dɔɔ: «Davidi 'nranɛ‑ ‑yaa' pɛ ‑le 'ke 'tɔbhɔleya 'ɛ 'le», 'ke ‑woo zrupliile 'a ma. ");
INSERT INTO moa_vpl VALUES ("MT21_16","070_21_16","MAT","21","16","16","‑Ayile, 'ke ‑wa pele‑ Zesu ni dɔɔ: «'E 'trɔn ‑o ‑o wojan 'ɛ ma ɛɛ?» Zesu 'bhɛ zikpaa‑ ‑o ni dɔɔ: «‑Aani'! 'An ꞊maa. 'Ka 'laa ‑Waanbhaa' a 'Sɛwɛ 'ɛ 'yi ‑jangɔ' 'lɛɛ tapelɛ ‑lido' ɛɛ? ‑A yɔɔndɛle ‑o dɔɔ: ‹'Ya ꞊kla 'bhɛɛ‑ ‑nɛ 'fiɛntrɔnnɛ mu 'pegee ‑nɛ 'yiɛntɛnnɛ mu ‑o 'ŋ 'tɔbhɔ zii'.›» ");
INSERT INTO moa_vpl VALUES ("MT21_17","070_21_17","MAT","21","17","17","'Bhɛ blaan, 'ke ‑yoo 'tole ‑o dulayrɛ 'ɛ ꞊nɔɔ ye, 'kee‑ gole ‑wa 'ɛ 'kpee, 'bhɛɛ‑ 'kee‑ gele‑ Betani ‑wa 'nɛ 'ɛ ta. 'Bhɛɛ‑ ‑e ꞊yia 'bhɛɛ‑ ꞊nɔɔ ye 'bhɛ ‑bi 'ɛ zi. ");
INSERT INTO moa_vpl VALUES ("MT21_18","070_21_18","MAT","21","18","18","'Bhɛ ta tooklin‑ yi 'le zrwan 'ɛ zi, Zesu 'niina‑ bhla zi Zeruzalɛmu, 'ke gbɔn 'a dɛle‑. ");
INSERT INTO moa_vpl VALUES ("MT21_19","070_21_19","MAT","21","19","19","'Bhɛ klɛle 'tɛ, 'kee‑ figi diiŋ do yele‑ zibhɛ 'ɛ 'trɔn ta, 'bhɛɛ‑ 'ke ‑ya mabɛɛnle 'bhɛ ‑din. Yaa 'bhɛ bhaa 'kedo‑ 'kpɔ 'yelɛ‑ 'bhɛ 'yi, 'ke yaa 'e go 'bhɛ 'laa 'te ba. ‑Ayile, 'ke ‑ya pele‑ 'bhɛ ni dɔɔ: «'Yaa nu 'e bhaa klɛlɛ ‑li 'kee‑ 'san ‑zɔn ma!» 'Bhɛ yrɛ do 'ɛ ꞊nɔɔ bhe, 'ke figi diiŋ 'ɛ gale‑. ");
INSERT INTO moa_vpl VALUES ("MT21_20","070_21_20","MAT","21","20","20","Zesu a ‑klaŋlanɛ mu 'ɛ ‑o 'bhɛ 'yele‑, 'ke ‑o 'kpeelɛnile ‑o ma. ‑Ayile, 'ke ‑o Zesu 'lrɔkpale dɔɔ: «‑E ꞊kla 'nale‑ 'bhɛɛ‑ figi diiŋ 'lɛɛ‑ ‑gaa yrɛ do 'kpɔ 'ɛ ꞊nɔɔ ‑gun ɛɛ?» ");
INSERT INTO moa_vpl VALUES ("MT21_21","070_21_21","MAT","21","21","21","'Bhɛ klɛle 'tɛ, 'ke ‑ya 'lɛkunle ‑o ni dɔɔ: «'Mi pe 'ka ni 'ŋ 'sɔwɛɛ‑ 'ɛ ma dɔɔ 'ke 'ka 'ka ꞊kpaa ‑Waanbhaa' 'yi, 'bhɛɛ‑ 'ke 'ka zru ꞊kla do ‑a ni, 'ka nu 'sɔlɛ‑ 'ŋ ‑za 'la ꞊kla figi diiŋ 'lɛɛ‑ ni 'bhɛ 'yansi za klɛle‑, 'bhɛɛ‑ drɔɔn', 'ka nu 'sɔlɛ‑ a pele‑ vlɛ gɔɔn 'la bhe 'bhɛ ni dɔɔ: ‹‑Yro 'e gbaanyrɛ 'ɛ ꞊nɔɔ, 'bhɛɛ‑ ge bɔ wɛyi‑ 'ɛ ba.› 'Bhɛɛ‑ 'bhɛ nu klɛle‑ 'te. ");
INSERT INTO moa_vpl VALUES ("MT21_22","070_21_22","MAT","21","22","22","'Ke 'ka 'ka ꞊kpaa ‑Waanbhaa' 'yi, 'ke 'ka pɛ 'tɔle‑ pɛ 'bhɛ 'yrɛwoa‑ ‑a ma 'seri 'yi, 'ka nu 'bhɛ 'srɔɔwolɛ.» ");
INSERT INTO moa_vpl VALUES ("MT21_23","070_21_23","MAT","21","23","23","Zesu ‑ja wlalɛ ‑Waanbhaa' Gba 'Fɛ ‑Gbɛnɛ 'ɛ ꞊la, 'bhɛɛ‑ ‑e mɛɛ mu daanle ‑saan ‑Waanbhaa' a ‑jan 'ɛ 'le. ‑E ‑yaa ‑o daan 'zi 'waati 'la ba, 'ke 'sraka 'lɛna mu ‑kuŋlii mu 'ɛ 'pegee Zuufu mu a 'gwlaan‑ gblaan mu 'ɛ ‑o nule‑ ‑a pelɛ ‑a ni dɔɔ: «‑De 'gbu ‑le pe 'e ni dɔɔ 'e ‑za mu 'lɛɛ‑ klɛ ɛɛ? 'Bhɛɛ‑ ‑de 'gbu ‑le ‑o klɛ 'seŋ ꞊naa 'e ni ɛɛ?» ");
INSERT INTO moa_vpl VALUES ("MT21_24","070_21_24","MAT","21","24","24","Zesu pe ‑o ni dɔɔ: «'Mi 'ezin‑ 'ŋ 'yoo‑ zan ‑za do 'kpɔ 'yilrɔkpalɛ 'ka ma, 'bhɛɛ‑ 'ke 'ka 'bhɛ 'lɛkwan‑ 'ŋ ni, mɛɛ 'la zan ‑za mu 'lɛɛ‑ klɛ 'seŋ ꞊naa 'ŋ ni, 'ŋ nu 'bhɛ zan 'ɛ 'tɔ 'ɛ 'kanlɛ‑ 'ka ni. ");
INSERT INTO moa_vpl VALUES ("MT21_25","070_21_25","MAT","21","25","25","‑Dele Mɛɛ Wiiŋfɛ' Mi Zaan 'winbwa‑ mɛɛ mu wiiŋfɛyrɛ nɔɔ‑, ‑Waanbhaa' taa‑ bhaaplɛŋ mu ɛɛ?» 'Bhɛ ya 'ɛ 'yi bhe, 'ke ‑o zaabɔle 'sanle 'eke‑ pleŋ‑ 'ke ‑wa pe dɔɔ: «'Ke 'wa 'lɛkwan‑ ‑a ni 'kaa ‑Waanbhaa' ‑le 'a 'winbwa‑, ‑e nu 'o 'lrɔkpalɛ dɔɔ: ‹‑Mɛla ma 'ka 'laa 'ka 'kpalɛ‑ ‑a ‑yi ɛɛ?› ");
INSERT INTO moa_vpl VALUES ("MT21_26","070_21_26","MAT","21","26","26","'Bhɛɛ‑ 'ke 'wa 'lɛkwan‑ ‑a ni dɔɔ: ‹Bhaaplɛŋ mu ‑le 'a 'winbwa‑, 'woo‑ ‑gblaan 'zi ‑zamaa' 'ɛ 'lɛɛ.› ‑Amasrɔyi mɔkpɛn' 'kpee ma 'yee‑ Mɛɛ Wiiŋfɛ' Mi Zaan ‑yaa 'ke ‑Waanbhaa' ‑lɛla' janwo mi do 'le.» ");
INSERT INTO moa_vpl VALUES ("MT21_27","070_21_27","MAT","21","27","27","‑Ayile, 'ke ‑wa ‑lɛkunle Zesu ni dɔɔ: «'Waa 'bhɛ zan 'ɛ dɔ.» 'Bhɛɛ‑ Zesu 'bhɛ zikpaa‑ ‑o ni dɔɔ: «'Mi 'duŋ‑, mɛɛ 'la zan ‑za mu 'lɛɛ‑ klɛ 'seŋ ꞊naa 'mi ni, 'naa nu 'bhɛ zan 'ɛ 'tɔkanlɛ 'ka ni.» ");
INSERT INTO moa_vpl VALUES ("MT21_28","070_21_28","MAT","21","28","28","Zesu pe 'ezin‑ dɔɔ: «'Ka mu 'a pe ‑za 'lɛɛ‑ 'bhɛ ma 'nale‑ ɛɛ?» Mɛɛ do gbe ‑yaa plɛ, 'bhɛɛ‑ ‑ya ‑pia ‑a gbe ‑lwa mi 'ɛ ni dɔɔ: «'Ŋ gbe ge yewo ‑zɔn 'an ‑drɔɔ gba 'ɛ ta. ");
INSERT INTO moa_vpl VALUES ("MT21_29","070_21_29","MAT","21","29","29","A gbe ‑lwa mi 'ɛ 'bhɛ 'a 'lɛkwan‑ ‑a ni dɔɔ: ‹'Naa ‑o gele‑›. 'Duŋ‑ boolazi bhɔle, 'ke ‑zadɔwɛɛ dɔle 'bhɛ ma, 'ke 'bhɛ 'bhɛ zru niinale, 'bhɛɛ‑ 'ke 'bhɛ gele‑ ‑drɔɔ gba 'ɛ ta. ");
INSERT INTO moa_vpl VALUES ("MT21_30","070_21_30","MAT","21","30","30","'Bhɛ klɛgbɛya do 'ɛ 'yi, 'yee‑ mɛɛ do 'ɛ ‑ya ‑pia ‑a gbe plɛ mi 'ɛ ni dɔɔ 'bhɛ ge ‑yaa' ‑drɔɔ gba 'ɛ ta. 'Bhɛ yrɛ do 'ɛ ꞊nɔɔ bhe, 'bhɛ pe ‑a ni dɔɔ: ‹'Ŋ dɛ, 'ŋ nu gelɛ›. 'Duŋ‑ 'bhɛ 'laa gelɛ gba 'ɛ ta ‑titi. ");
INSERT INTO moa_vpl VALUES ("MT21_31","070_21_31","MAT","21","31","31","'Woo‑ gbe plɛ 'la bhe ‑o ‑de 'gbu ‑le ‑o dɛ 'ɛ zru maza ꞊kla ɛɛ?» ‑Wa ‑lɛkwan Zesu ni dɔɔ: «‑A gbe ‑lwa mi 'ɛ 'bhɛ ‑le.» ‑Ayile, 'ke ‑ya pele ‑o ni 'kaa: «'Mi pe 'ka ni 'ŋ 'sɔwɛɛ‑ ma dɔɔ 'nisrakun mu 'ɛ 'pegee gwlɛn ‑glin le mu 'ɛ 'mu ‑le nu wlalɛ 'ka 'lɛɛ ‑Waanbhaa' a ‑bhleŋgbeya ‑wa 'ɛ ta. ");
INSERT INTO moa_vpl VALUES ("MT21_32","070_21_32","MAT","21","32","32","‑Amasrɔyi Mɛɛ Wiiŋfɛ' Mi Zaan ꞊nwa ‑lɛdɔɔleya zibhɛ 'ɛ zrɔnlɛ 'ka ni, 'bhɛɛ‑ 'ka 'laa 'ka 'kpalɛ‑ ‑a ‑yi; 'duŋ‑ 'nisrakun mu 'pegee gwlɛn ‑glin le mu 'mu ‑le 'e ‑kpaa ‑a ‑yi. 'Bhɛɛ‑ 'duŋ‑, 'kaa 'yelawoa 'bhii‑ 'nisrakun mu 'ɛ ‑woo ‑kpaa Mɛɛ Wiiŋfɛ' Mi Zaan 'yi, ‑mɛle ꞊kla 'bhɛɛ‑ 'ka 'laa 'ka zru niinalɛ 'bhɛɛ‑ 'ka 'ka kpa ‑a ‑yi ɛɛ?» ");
INSERT INTO moa_vpl VALUES ("MT21_33","070_21_33","MAT","21","33","33","Zesu pe 'ezin‑ dɔɔ: «‑Ka 'ka 'trɔnbadɔ 'ezin‑ ‑gɔɔn 'lɛɛ‑ 'bhɛ ꞊la doo: Gbakpa' mi do ‑drɔɔ gba do ‑kpaa. 'Bhɛɛ‑ ‑e 'jasa do ꞊bwa gba 'ɛ zi, 'bhɛ 'pegee ‑e ‑drɔɔ 'yigo‑ ‑gluu dɔ ‑kaan, 'bhɛɛ‑ ‑e 'kpaanɛ do ‑dwa 'kpata‑ do wiiŋ‑ gba 'ɛ gooba yala‑ mi 'ɛ 'yaayrɛ‑ 'le. 'Bhɛ blaan, 'kee‑ 'yee‑ ‑drɔɔ gba 'ɛ gbɛkpale gba 'ɛ 'yikpa yetanɛ mu 'ɛ 'kɔɔ. 'Bhɛ blaan, 'kee‑ gele‑ 'taa do ta. ");
INSERT INTO moa_vpl VALUES ("MT21_34","070_21_34","MAT","21","34","34","‑Drɔɔ bhaa 'kan bhla 'ɛ 'bhɔle‑ 'e ‑din, 'ke gbazan 'ɛ ‑e ‑yaa' 'fɛ 'ɛ ꞊la yewonɛ mu 'ɛ winbɔle ‑yaa' ‑drɔɔ gba ‑yikpa' yetanɛ 'ɛ mu 'ɛ ba, ‑yaa' pɛ ‑drɔɔ bhaa 'si zayi'. ");
INSERT INTO moa_vpl VALUES ("MT21_35","070_21_35","MAT","21","35","35","'Bhɛ 'duŋ‑, 'woo‑ ‑drɔɔ gba la yetanɛ mu 'ɛ ‑o gbazan 'ɛ ‑yaa' yewonɛ mu 'ɛ 'kunle, 'ke ‑wa do zita zɔnle‑; 'bhɛɛ‑ 'ke ‑wa ‑bhɛɛke' do 'ɛ dɛle‑, 'bhɛɛ‑ 'ke ‑o ‑wa yaga mi 'ɛ dɛle‑ kpoti 'le. ");
INSERT INTO moa_vpl VALUES ("MT21_36","070_21_36","MAT","21","36","36","'Bhɛ blaan, 'ke gbazan 'ɛ ‑e ‑yaa' yewonɛ mu 'ɛ ‑bhɛɛke' mu winbɔle 'woo‑ ‑drɔɔ gba la yetanɛ mu 'ɛ zi. 'Bhɛ mu ‑bebe 'yi 'yaa‑ ya ‑a ‑lwa mu 'ɛ ni. 'Duŋ‑ 'woo‑ ‑drɔɔ gba la yetanɛ mu 'ɛ ‑o 'mu ꞊kwan 'eyɔɔle 'ezin‑ 'bhii‑ ‑a ‑lwa mu 'ɛ gbɛɛn‑. ");
INSERT INTO moa_vpl VALUES ("MT21_37","070_21_37","MAT","21","37","37","'Bhɛ 'yi, 'ke gbazan 'ɛ ‑ya pele‑ dɔɔ: ‹'Ke 'mi 'ŋ gbe 'ɛ 'winbwa‑ ‑o ta, ‑o nu ‑gasikpalɛ 'bhɛ 'lɛɛ.› ‑Ayile, 'kee‑ 'bhɛ 'winbɔle ‑o ta 'tɛ. ");
INSERT INTO moa_vpl VALUES ("MT21_38","070_21_38","MAT","21","38","38","'Duŋ‑, 'woo‑ ‑drɔɔ gba la yetanɛ mu 'ɛ ‑o gbazan 'ɛ gbe 'ɛ 'yele‑, 'ke ‑wa pele‑ 'eke‑ ni dɔɔ: ‹Gba 'ɛ nu bolɛ mɛɛ 'lɛɛ‑ 'yela‑ ni boolazi 'ke ‑a 'ciɛn 'le. ‑Kɔɔ' 'a dɛ, 'bhɛɛ‑ ‑a 'ciɛn 'ɛ bo ‑kɔɔ' ni!› ");
INSERT INTO moa_vpl VALUES ("MT21_39","070_21_39","MAT","21","39","39","'Bhɛ klɛle 'tɛ, 'ke ‑o 'bhɛ 'kunle, 'bhɛɛ‑ 'ke ‑o gele‑ 'kɛle‑ ‑drɔɔ gba 'ɛ ‑gɔma', 'bhɛɛ‑ 'ke ‑o 'bhɛ dɛle‑.» ");
INSERT INTO moa_vpl VALUES ("MT21_40","070_21_40","MAT","21","40","40","Zesu ‑o ‑lrɔkpaa dɔɔ: «'Ke gbazan 'ɛ ꞊nwa yi 'la 'le ‑o ta, ‑e nu ‑mɛ za ‑la klɛlɛ 'woo‑ ‑drɔɔ gba la yetanɛ mu 'ɛ ni ɛɛ?» ");
INSERT INTO moa_vpl VALUES ("MT21_41","070_21_41","MAT","21","41","41","'Bhɛ ꞊nɔɔ bhe 'ke mɛɛ mu 'ɛ ‑wa ‑lɛkunle Zesu ni dɔɔ: «‑O ‑yrɛn 'laa nu 'klalɛ‑ gbazan 'ɛ ma, 'bhɛɛ‑ 'bhɛ nu ‑a pelɛ dɔɔ ‑woo 'kpɛn dɛ; 'bhɛɛ‑ ‑e nu ‑yaa' ‑drɔɔ gba 'ɛ gbɛkpalɛ ‑drɔɔ gba la yetanɛ ‑bhɛɛke' zru ‑lrele' mu ‑la 'kɔɔ; 'kooko‑ 'ke ‑drɔɔ bhaa 'kan bhla 'ɛ ꞊bhwa, 'mu ‑yaa pɛ drɔɔ bhaa na ‑a ni.» ");
INSERT INTO moa_vpl VALUES ("MT21_42","070_21_42","MAT","21","42","42","'Bhɛɛ‑ Zesu mɛɛ mu 'ɛ 'lrɔkpa gbɛ drɛɛwoa‑ 'ezin‑ dɔɔ: «‑Jan 'la ‑yoo ‑Waanbhaa' a 'Sɛwɛ 'ɛ 'yi 'ka 'laa 'bhɛ tapelɛ ‑lido' ɛɛ? 'Bhɛ ‑jan 'ɛ 'bhɛ ‑le dɔɔ: ‹'Fɛ dɔ mu 'ɛ ‑o kpoti 'la ‑blinna 'fɛ dɔ bhla 'ɛ 'zi, 'bhɛ ‑le ꞊kla 'ke 'fɛgwlɛ‑ 'ɛ gaan ‑la vlɛ ‑kpuŋ ‑gbɛnɛ 'gbu 'ɛ 'le, 'bhɛɛ‑ 'bhɛ ‑le 'fɛ 'ɛ 'kpɛn 'yikun‑. 'Bhɛ ‑za 'ɛ ‑daa Mɛɛzan ‑la ba, 'bhɛɛ‑ ‑yoo ‑kɔɔ' mu ‑yrɛ 'yi 'kpeelɛni maza do 'le.› ");
INSERT INTO moa_vpl VALUES ("MT21_43","070_21_43","MAT","21","43","43","«'Bhɛla‑ ‑zayile, ‑Waanbhaa' nu ‑yaa' ‑bhleŋgbeya ‑wa 'ɛ 'kunlɛ‑ 'ka mu 'kɔɔ, 'bhɛɛ‑ ‑e nu ‑a nalɛ 'si 'bhɛɛke mu ni. 'Bhɛ 'si mu 'ɛ 'mu nu taawolɛ 'yee‑ ‑Waanbhaa' a zi 'ɛ ta, 'bhɛɛ‑ 'mu nu ‑a zru maza klɛlɛ. ");
INSERT INTO moa_vpl VALUES ("MT21_44","070_21_44","MAT","21","44","44","'Ke mɛɛ 'oo mɛɛ 'la zan ‑balaa' 'yee‑ vlɛ 'lɛɛ‑ ta, 'bhɛ zan 'ɛ nu klɛlɛ 'bhii‑ 'ke 'trɛ gbɔ ‑balaa' 'trɛ ma, ‑e wi gɔnɛ‑ 'la gbɛɛn‑ 'krokro; 'bhɛɛ‑ 'ke 'yee‑ vlɛ 'ɛ 'lɛɛ‑ ‑balaa' mɛɛ 'oo mɛɛ 'la zan ta, 'bhɛ zan 'ɛ nu klɛlɛ 'bhii‑ ‑a ‑lwa mi 'ɛ 'wigbɛya 'ɛ gbɛɛn‑.» ");
INSERT INTO moa_vpl VALUES ("MT21_45","070_21_45","MAT","21","45","45","'Sraka 'lɛna ‑kuŋlii mu 'ɛ 'pegee Farizi mu 'ɛ ‑o Zesu ‑a ‑gɔɔn mu 'ɛ 'male‑, 'ke ‑wa 'yaangole 'bhii‑ 'bhɛ 'yaa‑ 'wo ‑la ma ‑gɔɔn mu bɔ 'zi 'bhɛ gbɛɛn‑ bhe. ");
INSERT INTO moa_vpl VALUES ("MT21_46","070_21_46","MAT","21","46","46","‑Ayile, ‑o gbɛ ‑yaa nu 'sɔlɛ‑ Zesu 'kunle ma gɔnɛ‑ 'la gbɛɛn‑, 'ke ‑o 'bhɛ ‑glinle' 'sanle. 'Duŋ‑ ‑o ‑yaa ‑gblaan 'zi ‑zamaa' mu 'ɛ 'lɛɛ, ‑amasrɔyi ‑o 'kpɛn 'yaa‑ Zesu 'kun zii' 'bhii‑ ‑Waanbhaa' ‑lɛla' janwo mi do 'le. ");
INSERT INTO moa_vpl VALUES ("MT22_1","070_22_1","MAT","22","1","1","Zesu ‑jan ‑bebe ꞊woa mɛɛ mu 'ɛ ni 'ezin‑ ‑gɔɔn mu 'yi. ‑E pe ‑o ni dɔɔ: ");
INSERT INTO moa_vpl VALUES ("MT22_2","070_22_2","MAT","22","2","2","«Laanima ‑Bhleŋgbeya ‑wa ‑a 'pwɛle‑ ‑o 'ezin‑ ‑za 'lɛɛ‑ 'bhɛɛ‑ 'le: ‑Bhleŋgbe do 'a gbe na dɔ 'fɛti 'ɛ ta pɛ 'ɛ ꞊kla. ");
INSERT INTO moa_vpl VALUES ("MT22_3","070_22_3","MAT","22","3","3","'Bhɛɛ‑ 'kee‑ ‑yaa' 'fɛ 'ɛ ꞊la yewonɛ mu 'ɛ winbɔle mɛɛ mu 'siiyrɛ‑ nɔɔ‑ 'kaa 'mu nu 'yee‑ ledɔyrɛ nɔɔ‑ 'fɛti 'ɛ ta, 'duŋ‑ 'bhɛ mɛɛ mu 'ɛ waa dɔlɛ ‑a ‑la 'ke ‑o nu. ");
INSERT INTO moa_vpl VALUES ("MT22_4","070_22_4","MAT","22","4","4","'Bhɛ klɛle 'tɛ, 'kee‑ ‑yaa' yewonɛ 'bhɛɛke mu winbɔle 'kaa 'mu ge ‑a pe mɛɛ mu 'ɛ ni dɔɔ: ‹'Ŋ dri mu 'ɛ 'pegee 'an wi blaale mu 'ɛ ꞊dia, 'bhɛɛ‑ 'ŋ ꞊yaan ‑o kpo 'ɛ klɛlele. Pɛle 'ɛ ꞊maa, ‑ka nu 'ŋ gbe na dɔ 'fɛti 'ɛ ta!› ");
INSERT INTO moa_vpl VALUES ("MT22_5","070_22_5","MAT","22","5","5","'Duŋ‑ 'bhɛ mɛɛ mu 'ɛ 'ezin‑, ‑o do 'kpɔ 'laa ‑o 'siiza‑ ‑bhleŋgbe 'ɛ 'kɔɔ 'bhɛ bɔlɛ ‑klɔsi 'yi, 'bhɛɛ‑ ‑o 'kpɛn ‑ja ‑waa' yewoyrɛ nɔɔ‑: ‑O do ‑ja 'bhɛ ba gba la, ‑a ‑bhɛɛke' do ‑ja 'bhɛ a pɛ gɔnyrɛ ꞊nɔɔ; ");
INSERT INTO moa_vpl VALUES ("MT22_6","070_22_6","MAT","22","6","6","'bhɛɛ‑ ‑o ‑vin mu 'ɛ 'mu ꞊klaa ‑bhleŋgbe 'ɛ ‑yaa' yewonɛ mu 'ɛ ta, 'bhɛɛ‑ ‑o ‑yrɛn 'ɛ 'kpɛn ‑glɔɔn ‑kpaa 'mu ta, 'bhɛɛ‑ ‑o 'mu ꞊dia. ");
INSERT INTO moa_vpl VALUES ("MT22_7","070_22_7","MAT","22","7","7","'Bhɛ klɛle 'tɛ, 'ke ‑bhleŋgbe 'ɛ ‑ya zrupliile, 'kee‑ yaa ‑srwase' mu 'ɛ 'winbɔle 'kaa 'mu ge 'woo‑ mɛɛ dɛ mu 'ɛ 'kpɛn dɛ, 'bhɛɛ‑ ‑o 'mu a ‑wa 'ɛ 'kpacie. ");
INSERT INTO moa_vpl VALUES ("MT22_8","070_22_8","MAT","22","8","8","‑O yanle kpo 'ɛ klɛlele, 'ke ‑ya pele‑ ‑yaa' yewonɛ mu 'ɛ ni dɔɔ: ‹Le dɔ 'fɛti 'ɛ ta pɛle 'ɛ ꞊maa, ‑o mɛɛ 'la zan mu 'siila‑ 'yee‑ pɛle 'ɛ ma, ‑a ‑gaale' laa ‑yaa ‑o ba 'ke ‑wa bhle. ");
INSERT INTO moa_vpl VALUES ("MT22_9","070_22_9","MAT","22","9","9","‑Ka ge 'duŋ‑ ‑wa 'ɛ 'kpee ‑gbleba ‑gbɛnɛ mu 'ɛ ta, 'bhɛɛ‑ 'ke 'ka 'lɛpaa‑ mɛɛ 'oo mɛɛ 'la 'le, ‑ka 'bhɛ 'sii‑ pɛle 'ɛ ma.› ");
INSERT INTO moa_vpl VALUES ("MT22_10","070_22_10","MAT","22","10","10","'Bhɛ ya 'ɛ 'yi bhe, ‑bhleŋgbe 'ɛ ‑yaa' yewonɛ mu 'ɛ ‑ja ‑wa 'ɛ 'kpee ‑gbleba ‑gbɛnɛ mu 'ɛ ta, 'bhɛɛ‑ mɛɛ 'tɔle‑ mɛɛ ‑o 'mu 'siila‑; 'e pe mɛɛ wlan mu oo, 'e pe mɛɛ ‑yɔɔ' mu oo, ‑o 'kpɛn ꞊nwa, ‑asiikɔɔ 'fɛti klɛ 'fɛ 'ɛ ꞊paa 'ke mɛɛ mu 'ɛ 'le.» ");
INSERT INTO moa_vpl VALUES ("MT22_11","070_22_11","MAT","22","11","11","«'Bhɛ klɛle 'tɛ, 'ke ‑bhleŋgbe 'ɛ 'wlale 'fɛti klɛ 'fɛ 'ɛ ꞊la mɛɛ mu 'ɛ taglin‑ zayi'. 'Bhɛɛ‑, 'ke ‑a ‑yrɛkpale mɛɛ do ma ‑o pleŋ‑, 'bhɛɛ‑ le dɔyrɛ nɔɔ‑ 'fɛti 'ɛ ta dunɛ‑ 'laa ‑yaa 'bhɛ mɛɛ 'ɛ ta. ");
INSERT INTO moa_vpl VALUES ("MT22_12","070_22_12","MAT","22","12","12","‑E pe 'bhɛ mɛɛ 'ɛ ni dɔɔ: ‹'Ŋ 'bhɛgwlɛn‑, ‑e ꞊kla 'nale‑ 'bhɛɛ‑ 'e ꞊wlaa gɛ, 'bhɛɛ‑ 'fɛti ta dunɛ‑ 'laa ‑o 'e ta ɛɛ?› 'Yee‑ mɛɛ 'ɛ tagale ꞊bwa ‑a yaalele. ");
INSERT INTO moa_vpl VALUES ("MT22_13","070_22_13","MAT","22","13","13","‑Ayile, 'ke ‑bhleŋgbe 'ɛ ‑ya pele‑ ‑yaa' yewonɛ mu 'ɛ ni dɔɔ: ‹‑Kaa gbɛ 'pegee ‑a gaan mu 'ɛ tabɔ 'ke bhlɛ 'le, 'bhɛɛ‑ ‑kaa blin 'pɛɛlii‑ laale ‑gblo 'ɛ 'yi. ‑E nu wisilɛ 'bhɛ 'pegee ‑e nu ‑a gbɛnɛbhɛ mu 'ɛ 'sɔnkpalɛ 'bhɛɛ‑ ꞊nɔɔ ‑zadɔwɛɛ 'ɛ 'kɔɔ.› ");
INSERT INTO moa_vpl VALUES ("MT22_14","070_22_14","MAT","22","14","14","‑Amasrɔyi, ‑Waanbhaa' mɛɛ ‑bebe 'siila‑, 'duŋ‑ ‑e mɛɛ sanɛ‑ ‑la makwan‑.» ");
INSERT INTO moa_vpl VALUES ("MT22_15","070_22_15","MAT","22","15","15","Farizi mu 'ɛ ‑o ‑ja 'eke‑ yelɛ. ‑O ‑yaa nu 'sɔlɛ‑ Zesu 'kunle gɔnɛ‑ 'la gbɛɛn‑ ‑a 'gbu 'liiwli‑ ma, ‑woo 'eke‑ ꞊ya 'bhɛɛ‑ ‑zayi', 'bhɛɛ‑ ‑o ꞊kpaa do ma 'bhɛ ta. ");
INSERT INTO moa_vpl VALUES ("MT22_16","070_22_16","MAT","22","16","16","‑Ayile, 'ke ‑woo zi mu 'ɛ 'ke mu 'pegee Erɔdi zi mɛɛ ‑lɛdo' 'ke mu winbɔle Zesu 'lrɔkpa yrɛ nɔɔ‑ 'kaa: «'O Daan mi, 'wa 'yaango‑ 'bhii‑ 'e wlan pe, 'bhɛɛ‑ 'e mɛɛ mu daan ‑Waanbhaa' zi 'ɛ ta 'taawogbɛya 'ɛ 'bhɛɛ‑ 'le wlan 'ɛ ma, 'bhɛ 'pegee 'yaa gblaan mɛɛ 'kedo‑ 'kpɔ 'lɛɛ, 'bhɛɛ‑ 'yaa mɛɛ mu bago. ");
INSERT INTO moa_vpl VALUES ("MT22_17","070_22_17","MAT","22","17","17","'Duŋ‑, 'bhi pe ‑za 'lɛɛ‑ 'bhɛ 'yi 'nale‑ ɛɛ? ‑Kɔɔa' 'toŋ 'ɛ ta, kɔɔ' sɔ Romɛ mu 'ɛ ‑waa' ‑bhleŋgbe ‑gbɛnɛ Sezaa 'ɛ ‑yaa' 'nisra 'ɛ gbawole ɛɛ?» ");
INSERT INTO moa_vpl VALUES ("MT22_18","070_22_18","MAT","22","18","18","'Duŋ‑ Zesu ‑waa' ‑dawli' 'ɛ dɔle 'ke ‑ya pele‑ ‑o ni dɔɔ: «Mɛɛ ‑yrɛkɔɔza klɛ mu, ‑mɛle ꞊kla 'bhɛɛ‑ 'ka ‑o ‑jan bhee 'kpaa zii' 'ŋ 'lɛɛ ɛɛ? ");
INSERT INTO moa_vpl VALUES ("MT22_19","070_22_19","MAT","22","19","19","‑Ka 'yee‑ 'nisra gbawo denie ‑gɔli' 'taŋbha do zrɔn 'ŋ ni ‑gɛ doo!» 'Bhɛ klɛle 'tɛ, 'ke ‑o 'bhɛ 'taŋbha 'ɛ do zrɔnle‑ ‑a ni. ");
INSERT INTO moa_vpl VALUES ("MT22_20","070_22_20","MAT","22","20","20","‑Ayile, 'ke ‑yoo ‑lrɔkpale dɔɔ: «‑De 'gbu ‑la ŋgblo lii 'pegee ‑a 'tɔ yɔɔn 'kpaale‑ ‑le 'yee‑ ‑gɔli' 'taŋbha 'lɛɛ‑ ta ‑gɛ ɛɛ?» ");
INSERT INTO moa_vpl VALUES ("MT22_21","070_22_21","MAT","22","21","21","‑Wa ‑lɛkwan ‑a ni dɔɔ: «‑Bhleŋgbe Sezaa ŋgblo lii 'pegee ‑a 'tɔ yɔɔn 'kpaale ‑le 'kɛle‑.» ‑Ayile, 'ke Zesu a 'pele ‑o ni dɔɔ: «Sezaa a pɛ ‑o 'kɛla 'le ‑ka 'bhɛɛ‑ gbawo 'bhɛ ni, 'bhɛɛ‑ ‑Waanbhaa' a pɛ ‑o 'kɛla 'le ‑ka 'bhɛɛ‑ 'na 'bhɛ ni 'ezin‑.» ");
INSERT INTO moa_vpl VALUES ("MT22_22","070_22_22","MAT","22","22","22","'Woo‑ mɛɛ mu 'ɛ ‑o Zesu 'wojan‑ 'ɛ 'male‑, 'ke ‑o 'kpeelɛnile ‑o ma, 'bhɛɛ‑ 'ke ‑o jilale. ");
INSERT INTO moa_vpl VALUES ("MT22_23","070_22_23","MAT","22","23","23","'Bhɛ ‑yrekpaa' do 'kpɔ 'ɛ 'le, mɛɛ 'ke mu ꞊nwa Zesu ba; ‑o ‑yaa ‑o sii Saduse mu. 'Woo‑ Saduse mu 'ɛ 'wole‑ 'a pe dɔɔ 'ke mɛɛ ‑gaa, yaa sɔ bwele‑ gale ba. ");
INSERT INTO moa_vpl VALUES ("MT22_24","070_22_24","MAT","22","24","24","‑O Zesu 'lrɔkpaa‑ dɔɔ: «'O Daan mi, Moizi 'a ꞊pia 'o ni 'kaa: ‹'Ke 'gwlaan‑ do ‑gaa, 'bhɛɛ‑ 'ke yaa ‑nɛ 'yalɛ‑ ‑a na 'ɛ ta, ‑a gaanzidɔ 'ɛ sɔ ‑a na glaanle 'ɛ 'yaale; 'kooko‑ 'bhɛ ‑nɛ mu 'la 'yale ‑a na 'ɛ ta, ‑wa 'tɔkpa‑ 'mu ma.› ");
INSERT INTO moa_vpl VALUES ("MT22_25","070_22_25","MAT","22","25","25","'Bhɛ 'laa 'sanlɛ‑ bhaama: Dɛ ‑nɛ ma 'gwlaan‑ 'srwaplɛ‑ ‑yaa 'o ba ‑gɛ. ‑O 'naagwlɛn‑ 'ɛ 'bhɛ le do ‑yalaa', 'duŋ‑ 'bhɛ 'laa ‑nɛ 'srɔɔwolɛ 'bhɛ le 'ɛ ta, 'bhɛɛ‑ 'bhɛ ‑gaa. 'Bhɛɛ‑ 'bhɛ a pɛ gaanzidɔ 'ɛ 'bhɛ ‑a na glaanle 'ɛ ꞊sia 'bhɛ 'na 'le. ");
INSERT INTO moa_vpl VALUES ("MT22_26","070_22_26","MAT","22","26","26","'Duŋ‑ 'ezin‑, ‑a gaanzidɔ 'ɛ oo, 'bhɛ a pɛ zitɛn' oo, 'ke 'bhɛ ge 'tɛnlɛ‑ ‑o nɛɛnɛ‑ 'srwaplɛ‑ mi 'ɛ ma, ‑o 'kpɛn a pɛ 'ɛ ꞊kla 'bhɛɛ‑ gbɛɛn‑ 'ezin‑. ");
INSERT INTO moa_vpl VALUES ("MT22_27","070_22_27","MAT","22","27","27","‑O 'kpɛn gale blaan, 'ke le mi 'ɛ 'gbu gale‑ 'ezin‑. ");
INSERT INTO moa_vpl VALUES ("MT22_28","070_22_28","MAT","22","28","28","'Bhɛ ya 'ɛ 'yi, 'ke gbaa mu bwe yi ꞊bhwa gale ba yi 'la 'le, ‑o ‑de 'gbu ‑le a pɛ nu klɛlɛ 'ke 'yee‑ le 'ɛ 'le ɛɛ? ‑Amasrɔyi 'yee ‑le 'ɛ ‑e ꞊kla ‑o 'kpɛn 'na 'le do do.» ");
INSERT INTO moa_vpl VALUES ("MT22_29","070_22_29","MAT","22","29","29","'Bhɛ klɛle 'tɛ, 'ke Zesu 'a 'lɛkunle ‑o ni dɔɔ: «'Ka 'yinia‑ 'gbu 'egbɛnɛle, ‑amasrɔyi 'kee‑ kpa ‑Waanbhaa' a 'Sɛwɛ 'ɛ ta oo, 'kee‑ kpa ‑Waanbhaa' a ‑glɔɔya' 'ɛ ta oo, 'ka 'laa ‑o do 'kpɔ dɔ. ");
INSERT INTO moa_vpl VALUES ("MT22_30","070_22_30","MAT","22","30","30","Wlan 'ɛ ni, 'ke gbaa mu ‑bwela gale ba yi 'la 'le, 'gwlaan‑ mu laa nu le mu 'silɛ‑ ‑li, 'bhɛɛ‑ le mu laa nu yaalɛ ‑li 'gwlaan‑ mu 'kɔɔ, 'duŋ‑ ‑o nu bolɛ 'bhii‑ ‑mlɛkɛ' mu a pɛ bogbɛya 'ɛ gbɛɛn‑ laflɛ' 'yi! ");
INSERT INTO moa_vpl VALUES ("MT22_31","070_22_31","MAT","22","31","31","Drɔɔn', gbaa mu bweza 'ɛ gale ba ‑Waanbhaa' ‑jan 'la ꞊woa 'ka ni 'bhɛ ba zayi', 'ka 'laa 'bhɛ tapelɛ ‑lido' ‑yaa' 'Sɛwɛ 'yi ɛɛ? ");
INSERT INTO moa_vpl VALUES ("MT22_32","070_22_32","MAT","22","32","32","‑E pe dɔɔ: ‹'Mi 'le 'ke Abraamu oo, Izaki oo, 'bhɛ 'pegee Zakɔbu mu a ‑Waanbhaa' 'le.› ‑Waanbhaa' laa ‑o 'ke mɛɛ gbaa mu a ‑Waanbhaa' 'le, 'duŋ‑ ‑yoo 'ke mɛɛ yrɛ male mu ‑la ‑Waanbhaa' 'le.» ");
INSERT INTO moa_vpl VALUES ("MT22_33","070_22_33","MAT","22","33","33","‑Zamaa' mu 'la 'yaa‑ ‑o 'trɔnkpa zii' 'yee‑ Zesu ni, ‑e 'mu 'kpɛn 'liibhaala 'mu ma ‑yaa' mɛɛ daangbɛya 'ɛ ma. ");
INSERT INTO moa_vpl VALUES ("MT22_34","070_22_34","MAT","22","34","34","Farizi mu 'ɛ ‑wa malawoa 'kaa Zesu a ‑jan ‑dwa Saduse mu 'ɛ gbɛ ‑yi, 'ke ‑woo ‑lɛkpale 'eke‑ ta. ");
INSERT INTO moa_vpl VALUES ("MT22_35","070_22_35","MAT","22","35","35","'Bhɛ ya 'ɛ 'yi bhe, ‑o do 'la 'bhɛ 'yaa‑ 'ke 'Toŋ daan mi 'le 'bhɛ 'yaa‑ zi 'bhii‑ 'bhɛ ‑jan bhee bɔ Zesu 'lɛɛ, 'bhɛɛ‑ ‑e 'bhɛ kun 'bhɛ 'gbu 'liiwli‑ ma; ‑ayile 'kee‑ Zesu 'lrɔkpale dɔɔ: ");
INSERT INTO moa_vpl VALUES ("MT22_36","070_22_36","MAT","22","36","36","«'O Daan mi, 'toŋ 'ɛ ‑de 'gbu ‑la ‑za ‑glɔɔ 'yiya‑ 'toŋ ‑vin mu 'ɛ ni ɛɛ?» ");
INSERT INTO moa_vpl VALUES ("MT22_37","070_22_37","MAT","22","37","37","Zesu 'bhɛ 'lɛkwan‑ ‑a ni dɔɔ: «‹'Yaa‑ Mɛɛzan ‑Waanbhaa' 'ɛ ‑za 'sɔ 'e ni 'e zru oo, 'e 'nii‑ oo, 'pegee 'e 'kpeejan‑ 'ɛ 'kpɛn 'le.› ");
INSERT INTO moa_vpl VALUES ("MT22_38","070_22_38","MAT","22","38","38","'Bhɛ ‑le 'ke 'toŋ ꞊lwa mi 'ɛ 'pegee 'toŋ 'la ‑za ‑o 'eglɔɔle 'bhɛ 'le. ");
INSERT INTO moa_vpl VALUES ("MT22_39","070_22_39","MAT","22","39","39","‑A 'kɛla tɛn 'bhɛ zi, 'bhɛɛ‑ 'ke ‑o 'pegee 'bhɛ ‑o do 'bhɛ ‑le ‑gɛ: ‹'E ‑vindo' mi ‑za 'sɔ 'e ni 'bhii‑ 'e 'gbu ‑za sɔ 'e 'gbu ni gɔnɛ‑ 'la gbɛɛn‑.› ");
INSERT INTO moa_vpl VALUES ("MT22_40","070_22_40","MAT","22","40","40","Moizi a 'toŋ mu 'ɛ 'kpɛn 'pegee ‑Waanbhaa' ‑lɛla' janwo mu 'ɛ kli gbaanle ‑o 'woo‑ 'toŋ plɛ 'la bhe 'wola‑ ta.» ");
INSERT INTO moa_vpl VALUES ("MT22_41","070_22_41","MAT","22","41","41","Farizi mu 'ɛ ‑o 'lɛkpale ‑yaa 'eke‑ ta, 'bhɛɛ‑ 'ke Zesu ‑za do ‑yilrɔkpale ‑o ma dɔɔ: ");
INSERT INTO moa_vpl VALUES ("MT22_42","070_22_42","MAT","22","42","42","«Mɛɛ ‑Bhee Mi ‑kpɔsɔɔ Krisi 'ɛ, 'ka ‑mɛla dan 'ka 'kpee ‑a ba zayi' ɛɛ? 'Bhɛɛ‑ ‑dela ‑nranɛ ‑le 'kɛle‑ ɛɛ?» ‑O 'bhɛ 'lɛkwan‑ Zesu ni dɔɔ: «Davidi ‑la 'nranɛ‑ ‑le 'kɛle‑.» ");
INSERT INTO moa_vpl VALUES ("MT22_43","070_22_43","MAT","22","43","43","'Bhɛ 'yi bhe, 'ke Zesu ‑o ‑lrɔkpale dɔɔ: «Lii 'Weŋ ‑glɔɔya' 'ɛ 'yaa‑ Davidi ta 'waati 'la ba, ‑mɛla ma 'bhɛɛ‑ ‑a 'gbu Krisi 'siila‑ Mɛɛzan ɛɛ? 'Bhɛɛ‑ Lii 'Weŋ ‑glɔɔya' 'ɛ 'le ‑ya ꞊pia dɔɔ: ");
INSERT INTO moa_vpl VALUES ("MT22_44","070_22_44","MAT","22","44","44","‹Mɛɛzan ‑Waanbhaa' 'a ꞊pia 'an Mɛɛzan 'ɛ ni dɔɔ nu yala‑ 'tɔbhɔ ma yaayrɛ 'ɛ ꞊nɔɔ 'ŋ ‑din ‑gɛ, 'sani‑ 'mi 'e 'sɔɔnnii mu 'ɛ 'kpɛn ŋgblo kpalaa' 'e gaan ꞊la.›» ");
INSERT INTO moa_vpl VALUES ("MT22_45","070_22_45","MAT","22","45","45","«'Ke Davidi 'gbu Krisi 'siila‑ ‹Mɛɛzan›. 'Bhɛɛ‑ ‑e sɔ klɛle‑ ‑a ‑nranɛ 'le 'nale ɛɛ?» ");
INSERT INTO moa_vpl VALUES ("MT22_46","070_22_46","MAT","22","46","46","'Woo Farizi mu 'ɛ do 'kpɔ 'laa 'sɔlɛ‑ 'bhɛ ‑jan 'ɛ 'lɛkunle 'a ni. ‑A 'san 'bhɛ yi 'ɛ ma, yaa dɔlɛ ‑o 'kedo‑ 'kpɔ 'kpee 'ke 'bhɛ 'a 'lrɔkpale 'ezin‑. ");
INSERT INTO moa_vpl VALUES ("MT23_1","070_23_1","MAT","23","1","1","Zesu ‑janwoa ‑zamaa' 'srɛ mu 'pegee ‑yaa' ‑klaŋlanɛ mu 'ɛ ni. ‑E pe dɔɔ: ");
INSERT INTO moa_vpl VALUES ("MT23_2","070_23_2","MAT","23","2","2","«'Toŋ daan mu 'ɛ 'pegee Farizi mu 'ɛ 'wole‑ Moizi blaantazɛn mu 'ɛ 'le 'ke ‑o mɛɛ mu daan 'bhɛ a 'toŋ mu 'ɛ 'le. ");
INSERT INTO moa_vpl VALUES ("MT23_3","070_23_3","MAT","23","3","3","‑O pe 'ka ‑za 'la klɛ, ‑ka 'bhɛ 'kpɛn klɛ, 'bhɛɛ‑ ‑ka 'taawo ‑waa' mɛɛ daangbɛya 'ɛ zi. 'Duŋ‑ 'ka 'laa 'taawolɛ 'bhii‑ ‑o 'taawogbɛya 'ɛ gbɛɛn‑. ‑Amasrɔyi ‑o 'ka daan ‑za 'la 'le 'woo‑ 'gbu 'laa 'bhɛ klɛ. ");
INSERT INTO moa_vpl VALUES ("MT23_4","070_23_4","MAT","23","4","4","‑O 'kwe kpiŋle ‑gbɛnɛ mu yre 'bhɛɛ‑ ‑o 'mu dɔ mɛɛ mu 'ɛ 'wiiŋ‑, 'bhɛɛ‑ 'duŋ‑ waa dɔ ‑a ‑la 'ke ‑o bhɔ 'mu ba 'bhɛ 'kwe mu 'ɛ sanɛ‑ 'silele. ");
INSERT INTO moa_vpl VALUES ("MT23_5","070_23_5","MAT","23","5","5","'Ke ‑o ‑za 'oo ‑za 'la klɛle‑, ‑woo 'gbu zrɔn mɛɛ mu ni. 'Bhɛla‑ ‑zayile, ‑o 'sɛwɛbhɛ mu 'la yre wi 'flɛ mu 'yi, 'bhɛɛ‑ ‑wa 'kpa ‑o ‑mlɛlii' 'pegee ‑o gbɛ ma, 'woo‑ Farizi mu 'ɛ 'pegee 'Toŋ daan mu 'ɛ ‑o waa pɛ mu 'ɛ 'laata‑ dɛ 'egbɛnɛle, 'bhɛɛ‑ ‑o waa dunɛ‑ gbɔɔn mu 'ɛ 'lɛma‑ mu 'ɛ tro 'egbɔɔnle. ");
INSERT INTO moa_vpl VALUES ("MT23_6","070_23_6","MAT","23","6","6","'Bhɛɛ‑ pɛbhleyrɛ ‑gbɛnɛ mu 'ɛ 'pegee Zuufu mu daanfɛ' mu 'ɛ ꞊la zilɛɛ‑ yaayrɛ mu 'ɛ makunle sɔ 'wola‑ ni. ");
INSERT INTO moa_vpl VALUES ("MT23_7","070_23_7","MAT","23","7","7","'Bhɛɛ‑ 'ezin‑, 'ke ‑woo ‑wa 'kpee ‑kpan mu 'ɛ ta, 'bhɛ sɔ ‑o ni 'ke mɛɛ mu ‑o 'pubɔ‑, 'bhɛ 'ke ‑woo sii ‹'O daan mi, 'o daan mi›. ");
INSERT INTO moa_vpl VALUES ("MT23_8","070_23_8","MAT","23","8","8","'Duŋ‑ 'ka mu, 'ka 'laa 'tolɛ‑ 'ke mɛɛ mu 'ka sii ‹'O daan mi›, ‑amasrɔyi 'ka 'kpɛn ‑o nɛɛnɛ‑ ma do mu 'le, 'bhɛɛ‑ 'ka daan mi ‑o do 'kpɔ. ");
INSERT INTO moa_vpl VALUES ("MT23_9","070_23_9","MAT","23","9","9","'Ka 'laa mɛɛ 'kedo‑ 'kpɔ 'siilɛ‑ 'trɛ ta ‑gɛ 'ka dɛ, ‑amasrɔyi 'ka Dɛ ‑bhɛɛke' do 'laa ‑o 'ka Dɛ ‑Waanbhaa' 'la do ‑kplɛn ‑o laanima laflɛ' 'yi 'bhɛ blaan. ");
INSERT INTO moa_vpl VALUES ("MT23_10","070_23_10","MAT","23","10","10","'Bhɛɛ‑ 'ezin‑, 'ka 'laa 'tolɛ‑ 'ke mɛɛ mu 'a pe 'ka ma ‹‑kuŋlii›, ‑amasrɔyi Krisi do ‑kplɛn ‑le 'ka ‑kuŋlii 'ɛ 'le. ");
INSERT INTO moa_vpl VALUES ("MT23_11","070_23_11","MAT","23","11","11","'Ka ba mɛɛ gblaan 'ɛ, 'bhɛ klɛ 'ka 'kpɛn a yewonɛ 'le. ");
INSERT INTO moa_vpl VALUES ("MT23_12","070_23_12","MAT","23","12","12","'Ke mɛɛ 'oo mɛɛ 'la zan 'bhɛ 'gbu magbaandia ‑Waanbhaa' nu 'bhɛ zan 'ɛ mazinalɛ, 'duŋ‑ 'ke mɛɛ 'la zan 'bhɛ 'gbu mazinaa, ‑Waanbhaa' nu 'bhɛ zan 'ɛ magbaandɛlɛ.» ");
INSERT INTO moa_vpl VALUES ("MT23_13","070_23_13","MAT","23","13","13","«'Ka ta ‑yrɛn! 'Ka mu 'Toŋ daan mu 'ɛ 'pegee 'ka mu Farizi mu 'ɛ, 'bhɛɛ‑ 'ka mu mɛɛ ‑yrɛkɔɔza klɛ mu! ‑Amasrɔyi 'ka laanima ‑bhleŋgbeya ‑wa ta zi 'ɛ 'liitan‑ mɛɛ mu ‑lɛɛ. 'Ka mu 'gbu 'laa wla ‑a nɔɔ‑, 'bhɛɛ‑ mɛɛ 'la zan mu ‑o ‑a zi 'bhii‑ 'mu 'wla ‑a nɔɔ‑, 'ka 'laa to 'bhɛɛ‑ 'mu wla.» ");
INSERT INTO moa_vpl VALUES ("MT23_14","070_23_14","MAT","23","14","14","«'Ka ta ‑yrɛn! 'Ka mu 'Toŋ daan mu 'ɛ 'pegee 'ka mu Farizi mu 'ɛ, 'bhɛɛ‑ 'ka mu mɛɛ ‑yrɛkɔɔza klɛ mu! ‑Amasrɔyi 'ka glaanle mu 'ɛ 'kɔɔpɛ‑ mu 'ɛ 'kpɛn 'kun, 'bhɛɛ‑ 'ka mɔ 'ka 'seriwole zi 'ka 'gbu zrɔn zayi' mɛɛ mu ni. 'Bhɛla‑ ‑zayile ‑o nu 'ka mu 'kitikanlɛ 'eyɔɔle 'ke 'bhɛ kan mɛɛ ‑vin mu 'ɛ ta.» ");
INSERT INTO moa_vpl VALUES ("MT23_15","070_23_15","MAT","23","15","15","«'Ka ta ‑yrɛn! 'Ka mu 'Toŋ daan mu 'pegee Farizi mu mu, 'ka mu mɛɛ mu ‑yrɛkɔɔza klɛ! ‑Amasrɔyi 'ka ge 'taa ta yrɛkpɛn‑ ꞊nɔɔ 'trɛ ta 'pegee wɛyi‑ ta, 'kooko‑ 'ka mɛɛ do wla 'kaa‑ Zuufu mu a 'seri 'ɛ 'yi. 'Ke 'ka mɛɛ do ꞊wlaa 'kaa‑ 'seri 'ɛ 'yi, 'ka 'bhɛ zan 'ɛ mabɔɔ 'bhɛɛ‑ ‑e klɛ ‑jranama 'nɛ 'le 'kee‑ klɛ 'eyɔɔle 'ke 'bhɛ kan 'ka mu 'gbu ta ‑glɔɔn plɛ.» ");
INSERT INTO moa_vpl VALUES ("MT23_16","070_23_16","MAT","23","16","16","«'Ka ta ‑yrɛn! 'Ka mu, mɛɛ ‑lɛdɔɔ' mu ‑yrɛ 'wile‑ mu! 'Ka pe dɔɔ: ‹'Ke mɛɛ do 'e 'siɛnwoa‑ *‑Waanbhaa' Gba 'Fɛ ‑Gbɛnɛ 'ɛ ma, 'bhɛ 'laa ‑o ‑zake' 'le; 'duŋ‑ 'ke ‑ya 'siɛnwoa‑ ‑Waanbhaa' Gba 'Fɛ ‑Gbɛnɛ ꞊la ‑can 'ɛ ma, 'kaa‑ pe dɔɔ 'bhɛ zan 'e 'siɛnwoa‑ pɛ 'la ma ‑e 'bhɛ 'yizaklɛ kpaŋma.› ");
INSERT INTO moa_vpl VALUES ("MT23_17","070_23_17","MAT","23","17","17","‑Zadɔkle mu, 'bhɛ 'pegee mɛɛ ‑yrɛ 'wile‑ mu! ‑Can 'pegee ‑Waanbhaa' Gba 'Fɛ ‑Gbɛnɛ 'ɛ, 'woo‑ pɛ plɛ 'ɛ ba, ‑o ‑de 'gbu ‑la gblaan ‑yiya' ‑a do ni ɛɛ? ‑Can 'ɛ taa‑ ‑Waanbhaa' Gba 'Fɛ ‑Gbɛnɛ 'la 'bhɛ 'yee‑ ‑can 'ɛ klɛ 'weŋ ‑Waanbhaa' a pɛ 'le bhe ɛɛ? ");
INSERT INTO moa_vpl VALUES ("MT23_18","070_23_18","MAT","23","18","18","'Ka mu pe 'ezin‑ dɔɔ 'ke mɛɛ do 'e 'siɛnwoa‑ 'srakagoyrɛ 'ɛ ma, 'bhɛ 'laa ‑o ‑zake' 'le; 'duŋ‑ 'ke ‑ya 'siɛnwoa‑ 'sraka gopɛ 'la ‑yoo 'srakagoyrɛ 'ɛ ꞊nɔɔ, 'kaa‑ pe dɔɔ 'bhɛ zan 'e 'siɛnwoa‑ pɛ 'la ma, ‑e 'bhɛ 'yizaklɛ kpaŋma. ");
INSERT INTO moa_vpl VALUES ("MT23_19","070_23_19","MAT","23","19","19","Mɛɛ ‑yrɛ 'wile‑ mu, 'woo‑ pɛ plɛ 'ɛ ‑a ‑de 'gbu ‑la gblaan ‑yiya' ‑a do ni ɛɛ? 'Sraka gopɛ 'ɛ taa‑ 'srakagoyrɛ 'la 'bhɛ 'sraka gopɛ 'ɛ klɛ 'weŋ ‑Waanbhaa' a pɛ 'le bhe ɛɛ? ");
INSERT INTO moa_vpl VALUES ("MT23_20","070_23_20","MAT","23","20","20","'Ke mɛɛ 'la zan 'e 'siɛnwoa‑ 'srakagoyrɛ 'ɛ ma, 'bhɛ zan 'e 'siɛnwoa‑ 'yee‑ 'srakagoyrɛ 'ɛ 'pegee ‑a ta pɛ mu 'ɛ 'kpɛn ‑la ma; ");
INSERT INTO moa_vpl VALUES ("MT23_21","070_23_21","MAT","23","21","21","'ke mɛɛ 'la zan 'e 'siɛnwoa ‑Waanbhaa' Gba 'Fɛ ‑Gbɛnɛ 'ɛ ma, 'bhɛ zan 'e 'siɛnwoa‑ ‑Waanbhaa' Gba 'Fɛ ‑Gbɛnɛ 'ɛ 'pegee ‑Waanbhaa' 'la 'bhɛ ‑o ‑a zan 'le ‑o plɛ ‑kpɛn ‑la ma bhe. ");
INSERT INTO moa_vpl VALUES ("MT23_22","070_23_22","MAT","23","22","22","'Bhɛɛ‑ 'ke mɛɛ 'la zan 'e 'siɛnwoa‑ laflɛ' ma, 'bhɛ zan 'bhɛ 'siɛnwoa‑ ‑Waanbhaa' a ‑bhleŋgbeya 'yaakpe‑ 'ɛ 'pegee ‑Waanbhaa' 'gbu ‑la ma bhe.» ");
INSERT INTO moa_vpl VALUES ("MT23_23","070_23_23","MAT","23","23","23","«'Ka ta ‑yrɛn! 'Ka mu 'Toŋ daan mu 'ɛ 'pegee 'ka mu Farizi mu 'ɛ, 'bhɛɛ‑ 'ka mu mɛɛ ‑yrɛkɔɔza klɛ mu! 'Ka 'kaa‑ ‑ziɛn klɛ ‑laanɛ' mu 'ɛ 'pegee ‑ziɛnbhɛ' 'fiɛntrɔnnɛ mu 'ɛ ‑lɛdulayrɛ vu mi 'ɛ 'bhɛɛ‑ 'na ‑Waanbhaa' ni. 'Duŋ‑ ‑za mu 'la ‑za ‑o 'eglɔɔle 'toŋ mu 'ɛ ta, 'bhii‑ ‑lɛdɔɔleya, mɛɛ ‑yrɛnklale mɛɛ ma, 'bhɛ 'pegee 'e zru bole do ‑Waanbhaa' ni, 'ka 'ka 'yrɛzigblaan 'bhɛ ‑za mu 'ɛ klɛle ma. ");
INSERT INTO moa_vpl VALUES ("MT23_24","070_23_24","MAT","23","24","24","'Ka mu 'la 'ka ‑o zi zrɔn pɛ 'le mɛɛ mu ni, 'ka mu 'gbu 'yrɛ 'wile‑ ‑o! 'Ka 'ka 'gbu 'mi yi 'ɛ tayroo, 'bhɛɛ‑ 'ka 'laa to 'ke ‑o muvuŋ ‑nɛ 'fiɛntrɔnnɛ do 'kpɔ ye ‑a ba. 'Bhɛɛ‑ 'duŋ‑, pɛ 'la wla 'ka 'kpee 'bhɛ ‑o 'bhii‑ 'yɔɔnma 'gbutru do gbɛɛn‑, 'bhɛɛ‑ 'ka 'bhɛ 'kpɛn miin.» ");
INSERT INTO moa_vpl VALUES ("MT23_25","070_23_25","MAT","23","25","25","«'Ka ta ‑yrɛn! 'Ka mu 'Toŋ daan mu 'ɛ 'pegee 'ka mu Farizi mu 'ɛ, 'bhɛɛ‑ 'ka mu mɛɛ ‑yrɛkɔɔza klɛ mu! ‑Amasrɔyi 'ka 'kaa ‑yi 'mipɛ‑ mu 'ɛ 'pegee 'kaa pɛbhle 'tasa mu 'ɛ maflee 'elrele, 'bhɛɛ‑ 'duŋ‑, ‑o 'pale‑ ‑o 'ke 'kaa‑ ‑faan pɛ mu 'pegee 'ka pɛ mu 'la ꞊kwan mɛɛ mu 'kɔɔ kpaŋma 'mu ‑la ‑le. ");
INSERT INTO moa_vpl VALUES ("MT23_26","070_23_26","MAT","23","26","26","Farizi mi ‑yrɛ 'wile‑! 'Yaa‑ ‑yi 'mipɛ‑ 'pegee 'yaa‑ pɛbhle 'tasa mu 'ɛ 'yifɛ 'elwale 'pe, 'bhɛɛ‑ ‑a ma nu 'fleelɛ‑ 'tɛ.» ");
INSERT INTO moa_vpl VALUES ("MT23_27","070_23_27","MAT","23","27","27","«'Ka ta ‑yrɛn! 'Ka mu 'Toŋ daan mu 'ɛ 'pegee 'ka mu Farizi mu 'ɛ, 'bhɛɛ‑ 'ka mu mɛɛ ‑yrɛkɔɔza klɛ mu! 'Ka ‑o 'bhii‑ bu 'fleele‑ mu gbɛɛn‑; ‑o ma lele 'pɛɛlii‑, 'duŋ‑ ‑o 'kpee 'ɛ 'pale‑ ‑o 'ke mɛɛ gbaa bhɛlɛ' mu 'pegee pɛ bɔnle ‑glɔɔn 'ɛ 'kpɛn ‑la ‑le. ");
INSERT INTO moa_vpl VALUES ("MT23_28","070_23_28","MAT","23","28","28","'Ka mu 'gbu 'duŋ‑, 'ka ‑o mɛɛ ‑yrɛ 'yi mɛɛ ‑lɛdɔɔle mu 'le, 'duŋ‑ 'ka 'kpee, 'ka mɛɛ ‑yrɛkɔɔza 'te ‑la klɛ 'bhɛ 'pegee ‑za 'yɔɔ‑.» ");
INSERT INTO moa_vpl VALUES ("MT23_29","070_23_29","MAT","23","29","29","«'Ka ta ‑yrɛn! 'Ka mu 'Toŋ daan mu 'ɛ 'pegee 'ka mu Farizi mu 'ɛ, 'bhɛɛ‑ 'ka mu mɛɛ ‑yrɛkɔɔza klɛ mu! 'Ka bu ‑lrele' mu dɔ ‑Waanbhaa' ‑lɛla' janwo mu 'la ‑gaa 'mu ni, 'bhɛɛ‑ mɛɛ ‑lɛdɔɔle mu 'la ‑gaa 'ka 'mu bu mu 'ɛ mabaa. ");
INSERT INTO moa_vpl VALUES ("MT23_30","070_23_30","MAT","23","30","30","'Bhɛɛ‑ 'kaa pe dɔɔ: ‹'Ke 'o klɛ bi 'o ‑gbɔɔ mu a pɛ 'waati 'ɛ ba 'elwaleta, 'waa ‑yaa nu 'kpalɛ‑ ‑o ba 'bhɛɛ‑ 'o ‑Waanbhaa' ‑lɛla' janwo mu 'ɛ dɛ.› ");
INSERT INTO moa_vpl VALUES ("MT23_31","070_23_31","MAT","23","31","31","'Bhɛ klɛgbɛya 'ɛ 'yi, 'ka 'gbu 'a 'yaango‑ dɔɔ mɛɛ 'la zan mu ‑Waanbhaa' ‑lɛla' janwo mu 'ɛ ꞊dia 'ka ‑o 'bhɛ zan mu 'ɛ 'kpee yi mu 'le. ");
INSERT INTO moa_vpl VALUES ("MT23_32","070_23_32","MAT","23","32","32","'Ka ‑gbɔɔ mu ‑za 'la klɛle zisaan‑, 'ka mu 'bhɛ ‑vin 'ɛ 'lɛyan. ");
INSERT INTO moa_vpl VALUES ("MT23_33","070_23_33","MAT","23","33","33","'Ka mu mlɛ ‑yɔɔ' 'plalu mɛɛ mu, 'bhɛɛ‑ 'ka mu ‑bhlu 'plalu mɛɛ mu, 'ka 'kpee ma 'ka nu golɛ ‑jranama 'tɛ ‑kpan 'ɛ 'yi ɛɛ? ");
INSERT INTO moa_vpl VALUES ("MT23_34","070_23_34","MAT","23","34","34","'Bhɛla‑ ‑zayile, ‑ka 'ka 'trɔnbadɔ doo, 'ŋ nu ‑Waanbhaa' ‑lɛla' janwo mu 'winbɔlɛ 'ka ba, 'bhɛ 'pegee ‑zadɔ' mu, 'bhɛɛ‑ 'Toŋ daan mu. 'Ka nu ‑a 'ke mu dɛlɛ, 'bhɛɛ‑ 'ka nu ‑a 'ke mu gbaanlɛ ‑yrigbɛɛle ta. 'Bhɛɛ‑ 'ka nu ‑a 'ke mu tafɛlɛ gbaŋbhlɛ mu 'le 'kaa‑ Zuufu mu daanfɛ' mu 'ɛ ꞊la; 'bhɛɛ‑ 'ka nu ‑yrɛnkpalɛ ‑o ta ‑wa 'tɔle‑ ‑wa 'bhɛ ta. ");
INSERT INTO moa_vpl VALUES ("MT23_35","070_23_35","MAT","23","35","35","'Bhɛ 'yi 'tɛ, 'bhɛɛ‑ 'ka 'pliila‑ mɛɛ mu 'la 'kpɛn ma ‑o dɛlele 'trɛ ta ‑gɛ, 'mu dɛza 'kiti 'ɛ balaa' 'ka ta; 'kee‑ san mɛɛ ‑lɛdɔɔle Abɛli dɛle 'ɛ ma, 'bhɛɛ‑ 'kee‑ nu 'tɛnlɛ‑ 'ka Berekia gbe Zakari 'la ꞊dia ‑Waanbhaa' gbayrɛ 'ɛ 'pegee 'srakagoyrɛ 'ɛ 'pleŋ‑ 'bhɛ ma. ");
INSERT INTO moa_vpl VALUES ("MT23_36","070_23_36","MAT","23","36","36","'Mi 'a pe 'ka ni 'ŋ 'sɔwɛɛ‑ ma dɔɔ ‑o mɛɛ 'la zan mu 'kpɛn ꞊dia, 'mu dɛza 'kiti 'ɛ nu baalɛ ‑zɔn mu 'ɛ ta.» ");
INSERT INTO moa_vpl VALUES ("MT23_37","070_23_37","MAT","23","37","37","Zesu pe 'ezin‑ dɔɔ: «'Ee, Zeruzalɛmu mu! 'Ee, Zeruzalɛmu mu! 'Ka mu 'la 'ka ‑Waanbhaa' ‑lɛla' janwo mu 'ɛ dɛ, 'bhɛɛ‑ 'ke ‑Waanbhaa' mɛɛ 'la zan mu 'winbwa‑ 'ka ba, 'ka kpoti pa 'mu ma! 'Naa 'a klɛlɛ gaan ‑wɛɛ' 'ke 'ŋ 'ka 'lɛkpale ‑yidanlɛ 'eke‑ ta 'bhii‑ maa nɛɛ do ‑a ‑nɛ mu 'ɛ 'lɛkpa‑ 'eke‑ ta gɔnɛ‑ 'la gbɛɛn‑ ‑a gbɛŋroŋ‑ mu 'ɛ ꞊la. 'Bhɛɛ‑ 'duŋ‑ 'ka 'laa dɔlɛ 'bhɛ ꞊la ‑titi. ");
INSERT INTO moa_vpl VALUES ("MT23_38","070_23_38","MAT","23","38","38","‑Ka 'ka 'yrɛkpa ‑gɛ doo! 'Kaa‑ ‑Waanbhaa' Gba 'Fɛ ‑Gbɛnɛ 'ɛ 'yee‑ ‑Waanbhaa' 'gbu nu golɛ 'bhɛ ꞊la. ");
INSERT INTO moa_vpl VALUES ("MT23_39","070_23_39","MAT","23","39","39","‑Amasrɔyi, 'mi pe 'ka ni dɔɔ: 'ka 'laa nu 'ŋ yelɛ ‑li 'kee‑ san ‑zɔn ma, 'ke 'bhɛ ge 'tɛnlɛ‑ 'ka nu ‑a pelɛ yi 'la 'le dɔɔ: ‹Mɛɛ 'la zan ‑o zan Mɛɛzan 'tɔ 'ɛ 'yi, bhaa ‑Waanbhaa' 'e ‑dɔɔbo'!›» ");
INSERT INTO moa_vpl VALUES ("MT24_1","070_24_1","MAT","24","1","1","Zesu 'pwɛ bhla 'ɛ zi ‑Waanbhaa' Gba 'Fɛ ‑Gbɛnɛ 'ɛ ꞊la, 'ke yaa ‑klaŋlanɛ mu 'ɛ ‑woo mabɛɛnle ‑a ‑din, 'bhɛɛ‑ 'ke ‑wa pele‑ ‑a ni dɔɔ ‑e ‑Waanbhaa' Gba 'Fɛ ‑Gbɛnɛ gwlɛ 'ɛ dɔgbɛya mu 'ɛ ‑glin doo. ");
INSERT INTO moa_vpl VALUES ("MT24_2","070_24_2","MAT","24","2","2","'Duŋ‑ ‑e pe ‑o ni dɔɔ: «'Ka 'yrɛ ‑o 'fɛgwlɛ‑ dɔgbɛya ‑gbɛnɛ ‑gbɛnɛ mu 'la ma ‑gɛ bhe, 'mi pe 'ka ni wlan 'ɛ ni dɔɔ 'fɛ 'lɛɛ‑ 'kpɛn nu ‑wilɛ', 'bhɛɛ‑ ‑a ‑yi vlɛ ‑kpuŋ mu 'ɛ 'kpɛn nu 'klaalɛ‑, 'bhɛɛ‑ ‑o 'kedo‑ 'kpɔ 'kpaale‑ laa nu bolɛ 'eke‑ ta ‑gɛ.» ");
INSERT INTO moa_vpl VALUES ("MT24_3","070_24_3","MAT","24","3","3","Zesu 'yalaa‑ Olivi diiŋ vlɛ gɔɔn 'ɛ 'wiiŋ‑. 'Bhɛɛ‑ 'ke ‑yaa' ‑klaŋlanɛ mu 'ɛ 'te 'mu 'e mabɛɛnle ‑a ‑din, 'bhɛɛ‑ 'ke ‑wa ‑lrɔkpale dɔɔ: «*‑Waanbhaa' Gba 'Fɛ ‑Gbɛnɛ 'ɛ 'siɛ 'waati 'ɛ nu klɛlɛ 'waati 'ɛ ‑dela ba ɛɛ? 'Bhɛɛ‑ 'e 'nu yi 'ɛ 'pegee 'drunyan 'yan yi 'ɛ ‑o ‑tɔɔmasie nu klɛlɛ ‑mɛla ‑le ɛɛ?» ");
INSERT INTO moa_vpl VALUES ("MT24_4","070_24_4","MAT","24","4","4","'Bhɛ klɛle 'tɛ, 'ke Zesu 'a 'lɛkunle ‑o ni dɔɔ: «‑Ka 'ka 'yrɛkpa 'ka 'gbu ba 'elrele, 'kooko‑ mɛɛ 'kedo‑ 'kpɔ 'laa 'ka 'yini‑. ");
INSERT INTO moa_vpl VALUES ("MT24_5","070_24_5","MAT","24","5","5","‑Amasrɔyi mɛɛ ‑bebe nu nulɛ, 'bhɛɛ‑ ‑o nu 'ŋ 'tɔ 'ɛ 'kpalɛ‑ ‑o 'gbu ma, 'ke ‑wa pe ‑o 'gbu ma 'kaa: ‹'Mi 'gbu ‑le 'ke Mɛɛ ‑Bhee mi ‑kpɔsɔɔ Krisi 'gbu 'ɛ 'le!› 'Bhɛ klɛgbɛya 'ɛ 'yi, ‑o nu mɛɛ ‑bebe 'yinilɛ. ");
INSERT INTO moa_vpl VALUES ("MT24_6","070_24_6","MAT","24","6","6","'Ka nu gwledanwli mu malɛ 'ka ‑din, 'bhɛɛ‑ 'ka nu yrɛ gbɔɔn ꞊nɔɔ gwledanwli mu malɛ. ‑Ka dɔ klɛn 'ke 'ka 'laa gblaan 'dɛ, ‑amasrɔyi ‑a ‑lɛdulale ‑o dɔɔ 'bhɛ ‑za mu 'la bhe 'mu ‑le nu bhɔlɛ 'elwale pe, 'duŋ‑ 'bhɛ 'laa nu klɛlɛ 'ke 'drunyan 'yan 'waati 'ɛ 'le. ");
INSERT INTO moa_vpl VALUES ("MT24_7","070_24_7","MAT","24","7","7","'Klɛɛn do ‑yi mu nu gwledanlɛ 'klɛɛn 'bhɛɛke 'yi mu 'ɛ ba, 'bhɛɛ‑ ‑bhleŋgbe do a 'klɛɛn 'yi mu nu 'wlɛnlɛ‑ ‑bhleŋgbe 'bhɛɛke do a 'klɛɛn 'yi mu 'ɛ 'kaama‑, 'bhɛɛ‑ ‑o gwledan 'eke‑ ba. ‑Gu mu nu dɔlɛ, 'bhɛ 'pegee 'trɛ nu bɛɛnlɛ 'trɛ ta yrɛ ‑bebe ꞊nɔɔ. ");
INSERT INTO moa_vpl VALUES ("MT24_8","070_24_8","MAT","24","8","8","'Duŋ‑ 'bhɛ 'kpɛn nu klɛlɛ 'trɛbhɔ mu 'ɛ zisanyrɛ ‑la ‑le, 'bhii‑ 'ke le do ‑bla ꞊zian ‑a ta ‑e ‑yrɛnbhle gɔnɛ‑ 'la gbɛɛn‑. ");
INSERT INTO moa_vpl VALUES ("MT24_9","070_24_9","MAT","24","9","9","'Bhɛ ya 'ɛ 'yi bhe, mɛɛ mu nu 'ka 'lɛnalɛ mɛɛ ‑bhɛɛke' mu ni, 'kooko‑ 'mu ‑yrɛnkpa' 'ka ta, 'bhɛɛ‑ 'mu 'ka dɛ. 'Ka vɛn nu 'silɛ‑ 'klɛɛn 'kpɛn 'yi mu yin 'lii 'mi 'tɔ 'ɛ ‑zayi'. ");
INSERT INTO moa_vpl VALUES ("MT24_10","070_24_10","MAT","24","10","10","'Bhɛ 'waati do 'kpɔ 'ɛ ba, mɛɛ ‑bebe nu 'ploolɛ‑ 'o 'kpale‑ ma ‑Waanbhaa' 'yi. ‑O nu ‑dawli' 'kpalɛ‑ 'eke‑ gbɛ ta, 'bhɛɛ‑ ‑o vɛn nu 'silɛ‑ 'eke‑ yin 'lii. ");
INSERT INTO moa_vpl VALUES ("MT24_11","070_24_11","MAT","24","11","11","Bhla ma ‑Waanbhaa' ‑lɛla' janwo mu ‑bebe mu nu 'pwɛlɛ‑ ‑a ‑yi, 'bhɛɛ‑ 'mu nu mɛɛ ‑bebe 'yinilɛ. ");
INSERT INTO moa_vpl VALUES ("MT24_12","070_24_12","MAT","24","12","12","‑Za 'yɔɔ‑ 'pa gbɛ ‑yɔɔ' 'ɛ 'kɔɔ, 'sɔniya ‑lɛ nu galɛ mɛɛ ‑bebe zru ba. ");
INSERT INTO moa_vpl VALUES ("MT24_13","070_24_13","MAT","24","13","13","'Bhɛɛ‑ 'duŋ‑, 'ke mɛɛ 'la zan ‑Waanbhaa' a ‑za 'ɛ 'yikwan꞊ 'ke 'bhɛ ge 'tɛnlɛ‑ ‑a ‑lɛyanle ma, 'bhɛ zan nu golɛ ‑za 'yi. ");
INSERT INTO moa_vpl VALUES ("MT24_14","070_24_14","MAT","24","14","14","‑O nu ‑bhleŋgbeya ‑wa 'ɛ ma ‑Jan ‑Nrale' 'lɛɛ 'bhɛ 'wole‑ zɛnlɛ 'drunyan 'ɛ 'yi yrɛkpɛn‑ ꞊nɔɔ, 'kooko‑ 'klɛɛn 'kpɛn 'yi mu 'ɛ ‑Waanbhaa' a ‑jan 'ɛ ma. 'Ke 'bhɛ ꞊kla, 'bhɛɛ‑ 'drunyan 'yan yi 'ɛ nu bhɔlɛ 'tɛ.» ");
INSERT INTO moa_vpl VALUES ("MT24_15","070_24_15","MAT","24","15","15","«'Ka nu ‑o pɛ 'la sii ‹Pɛ ‑yɔɔ'› 'bhɛ dulale yelɛ ‑Waanbhaa' Gba 'Fɛ ‑Gbɛnɛ 'ɛ ꞊la 'kee‑ 'bhɛ 'triŋdɔ‑. ‑Waanbhaa' ‑lɛla' ‑janwo' mi Daniɛli ‑a ba ‑janwoa 'elwale ‑sɔ. 'Ke 'bhɛ ꞊kla 'waati 'la ba, 'ke mɛɛ 'la zan ‑o 'sɛwɛ 'lɛɛ‑ tape 'zi, 'bhɛ zan 'a 'yima 'elrele. ");
INSERT INTO moa_vpl VALUES ("MT24_16","070_24_16","MAT","24","16","16","'Bhɛ ya 'ɛ 'yi, 'ke mɛɛ 'la zan mu ꞊kla Zude 'klɛɛn 'ɛ 'yi, 'mu blasan‑ 'mu 'lɛɛ ye vlɛ gɔɔn mu 'ɛ ba yrɛ ta; ");
INSERT INTO moa_vpl VALUES ("MT24_17","070_24_17","MAT","24","17","17","'ke mɛɛ 'la zan ꞊kla 'bhɛ a 'fɛ 'ɛ 'wiiŋ‑, 'bhɛ zan laa zinalɛ, 'kee‑ ge wlalɛ ‑yaa' 'fɛ 'ɛ ꞊la ‑yaa' pɛ mu 'si zayi'. ");
INSERT INTO moa_vpl VALUES ("MT24_18","070_24_18","MAT","24","18","18","'Bhɛɛ‑ 'ke mɛɛ 'la zan ꞊kla gba la, 'bhɛ zan laa pelɛ ‑e nule‑ ‑a ‑zanta' ‑wa la ‑yaa' dunɛ‑ tralapɛ 'si zayi'. ");
INSERT INTO moa_vpl VALUES ("MT24_19","070_24_19","MAT","24","19","19","Le mu 'la kpɛle nu klɛlɛ, 'bhɛ 'pegee le mu 'la 'nɛ mu nu klɛlɛ ‑yɔn ma 'bhɛ 'waati 'ɛ ba, 'mu 'nisɛ‑ ‑yrɛn ma! ");
INSERT INTO moa_vpl VALUES ("MT24_20","070_24_20","MAT","24","20","20","‑Ka 'ka 'seriwo ‑Waanbhaa' ni, 'kooko‑ 'ka blasan‑ yi 'ɛ yaa klɛlɛ ‑niinii' 'kpa bhla zi, 'bhɛ 'pegee ‑yitrɛ' yi ma. ");
INSERT INTO moa_vpl VALUES ("MT24_21","070_24_21","MAT","24","21","21","‑Amasrɔyi, 'bhɛ 'waati 'ɛ ba, bhaaplɛŋ mu nu ‑yrɛn ‑bebe 'bhlelɛ‑. ‑A 'san ‑Waanbhaa' 'drunyan klɛ 'ke 'bhɛ nu 'tɛnlɛ‑ ‑zɔn ma, bhaaplɛŋ mu laa 'bhɛ ‑yrɛn ‑glɔɔn mu 'ɛ bhlelɛ ‑lido', 'bhɛɛ‑ waa nu 'bhɛ 'yansi ‑yrɛnbhlelɛ ‑titi 'ezin‑. ");
INSERT INTO moa_vpl VALUES ("MT24_22","070_24_22","MAT","24","22","22","'Ke ‑Waanbhaa' laa 'woo‑ ‑yrɛnbhle' yi mu 'ɛ 'ke 'kanlɛ‑ ‑o ‑lii, mɛɛ 'kedo‑ 'kpɔ 'laa ‑yaa nu golɛ ‑za 'yi. 'Duŋ‑ ‑Waanbhaa' mɛɛ 'la zan mu makwan‑ gban 'mu ‑zayi', ‑e 'yee‑ ‑yrɛnbhle' yi mu 'ɛ 'ke 'kaan‑ ‑o ‑lii.» ");
INSERT INTO moa_vpl VALUES ("MT24_23","070_24_23","MAT","24","23","23","«'Ke mɛɛ do 'a ꞊pia 'ka ni dɔɔ: ‹‑Ka 'ka 'yrɛkpa doo, Mɛɛ ‑Bhee Mi ‑kpɔsɔɔ Krisi 'ɛ ‑yoo ‑gɛ!› 'Bhɛɛ‑ 'ke mɛɛ ‑bhɛɛke' 'a ꞊pia 'ka ni dɔɔ: ‹‑Ka 'ka 'yrɛkpa doo, ‑yoo laale!› 'Ka 'laa 'ka 'kpalɛ‑ 'bhɛ 'yi. ");
INSERT INTO moa_vpl VALUES ("MT24_24","070_24_24","MAT","24","24","24","‑Amasrɔyi bhla ma mɛɛ ‑bhee mi Krisi mu 'pegee bhla ma ‑Waanbhaa' ‑lɛla' janwo mu nu nulɛ, 'bhɛɛ‑ ‑o nu 'sɔle‑ maza ‑gbɛnɛ mu 'pegee 'kpeelɛni maza mu klɛlɛ, 'kooko‑ 'ke 'bhɛ sɔ klɛle‑, 'bhɛɛ‑ ‑o gbɛsɔ ‑Waanbhaa' mɛɛ 'la zan mu makwan‑ gban 'mu ‑yinile ta. ");
INSERT INTO moa_vpl VALUES ("MT24_25","070_24_25","MAT","24","25","25","‑Ka 'ka 'trɔnkpa 'ŋ ni 'dɛ! 'Ŋ 'ka 'kpeelɛkan ma jan ‑la ꞊woa bhe. ");
INSERT INTO moa_vpl VALUES ("MT24_26","070_24_26","MAT","24","26","26","«'Ke ‑wa ‑pia 'ka ni dɔɔ: ‹‑Ka 'ka 'yrɛkpa Mɛɛ ‑Bhee Mi ‑kpɔsɔɔ Krisi 'ɛ ‑yoo ‑kpe 'ɛ ta›. 'Ka 'laa gelɛ 'bhɛ ꞊nɔɔ; 'bhɛɛ‑ 'ke mɛɛ 'ke mu 'a ꞊pia 'ka ni dɔɔ: ‹‑Ka 'ka 'yrɛkpa, ‑a gaanle ‑o 'fɛ do ‑la, 'ka 'laa 'ka 'kpalɛ‑ 'bhɛ 'yi›. ");
INSERT INTO moa_vpl VALUES ("MT24_27","070_24_27","MAT","24","27","27","La 'a 'yrɛbɔ‑ laflɛ' 'yi gɔnɛ‑ 'la gbɛɛn‑ 'bhɛɛ‑ mɔkpɛn' 'a ye yrɛkpɛn‑ ꞊nɔɔ, Bhaaplɛŋ Gbe 'ɛ nu nule 'ɛ nu klɛlɛ 'bhɛɛ‑ gbɛɛn‑ blaale‑. ");
INSERT INTO moa_vpl VALUES ("MT24_28","070_24_28","MAT","24","28","28","'Ke pɛ do gbaa ‑o yrɛ 'la ꞊nɔɔ, gbotakwe mu ‑o ‑lɛkpa' 'eke‑ ta 'bhɛ yrɛ 'ɛ 'bhɛɛ‑ ꞊nɔɔ.» ");
INSERT INTO moa_vpl VALUES ("MT24_29","070_24_29","MAT","24","29","29","Zesu pe ‑o ni 'ezin‑ dɔɔ: «'Bhɛ ‑yrɛn mu 'ɛ 'kanle‑ blaan blaale‑, ‑gblo nu 'kpalɛ‑ ‑yretɛbhɛ ta, laanima mlɛ 'ɛ yaa nu ‑bhilɛ' ‑li. ‑Ayile laanima mlɛklɛn‑ mu 'ɛ ‑o nu baalɛ 'trɛ ma, 'bhɛɛ‑ laflɛ' 'yi ‑glɔɔya' mu 'ɛ ‑o 'kpɛn nu bɛɛnlɛ. ");
INSERT INTO moa_vpl VALUES ("MT24_30","070_24_30","MAT","24","30","30","'Bhɛ blaanta, Bhaaplɛŋ Gbe 'ɛ 'nuza‑ 'ɛ ma ‑tɔɔmasie 'ɛ nu 'pwɛlɛ‑ ‑a ‑yi laflɛ' 'yi; 'bhɛɛ‑ 'trɛ ta 'si mu 'ɛ 'kpɛn nu 'dimi ma wisilɛ; 'ke 'bhɛ ꞊kla, ‑o 'kpɛn 'yrɛ nu 'kpalɛ‑ Bhaaplɛŋ Gbe 'ɛ 'nule‑ ma laflɛ' ‑gblɛn mu 'ɛ ta, 'kee‑ da laflɛ' 'yi laanima ‑yaa' ‑glɔɔya' 'pegee ‑yaa' 'tɔbhɔleya 'ɛ 'yi. ");
INSERT INTO moa_vpl VALUES ("MT24_31","070_24_31","MAT","24","31","31","'Ke 'ka ‑Waanbhaa' a ‑klɛloŋ' 'ɛ 'pɛnwli‑ ꞊maa bhla 'la ba, Bhaaplɛŋ Gbe 'ɛ nu ‑yaa' ‑mlɛkɛ' yiziɛ 'ɛ 'winbɔlɛ 'drunyan 'ɛ 'yi, ‑e mɛɛ 'la zan mu makwan‑ 'elwale gban 'drunyan zeŋ yiziɛ 'ɛ ta, ‑e nu 'mu ‑lɛkpalɛ 'eke‑ ta: 'Ke 'bhɛ kpa ‑yretɛbhɛ ‑wlɛnyrɛ' 'pegee ‑yretɛbhɛ baayrɛ mu ta oo, 'bhɛ 'pegee 'trɛ 'pegee laflɛ' ‑daŋma' mɛɛ mu 'kpɛn ta.» ");
INSERT INTO moa_vpl VALUES ("MT24_32","070_24_32","MAT","24","32","32","Zesu pe 'ezin‑ dɔɔ: «'Ka sɔ za ‑la daanle‑ figi diiŋ 'ɛ ma, ‑ka 'bhɛ 'yima 'elrele. 'Ke figi diiŋ 'ɛ ‑ya gbɛ mu 'ɛ yidia‑, 'bhɛ 'pegee 'ke ‑a ‑laa mu 'ɛ 'tɔɔnna‑ bhla 'la ba, 'kaa 'yaango‑ dɔɔ ‑a bhaa 'kan bhla ꞊bhwa 'e ‑din. ");
INSERT INTO moa_vpl VALUES ("MT24_33","070_24_33","MAT","24","33","33","'Bhɛ klɛgbɛya do 'ɛ 'yi, 'ke 'ka 'yrɛkpaa‑ ‑za mu 'la bhe ‑o klɛle ma 'waati 'la ba, ‑kaa 'yaango‑ dɔɔ Bhaaplɛŋ Gbe 'ɛ nu yi 'ɛ ꞊bhwa ‑wa ‑din. ");
INSERT INTO moa_vpl VALUES ("MT24_34","070_24_34","MAT","24","34","34","'Mi pe 'ka ni wlan 'ɛ ni dɔɔ ‑zɔn mɛɛ mu 'lɛɛ‑ ‑o 'kpɛn 'laa nu klɛlɛ 'ke siɛle', 'sani‑ ‑za mu 'lɛɛ‑ 'kpɛn klɛle pleŋ‑. ");
INSERT INTO moa_vpl VALUES ("MT24_35","070_24_35","MAT","24","35","35","Laflɛ' 'pegee 'trɛ mu nu 'kanlɛ‑, 'duŋ‑ 'an pɛ ‑jan mu 'ɛ waa nu 'kanlɛ‑ ‑titi.» ");
INSERT INTO moa_vpl VALUES ("MT24_36","070_24_36","MAT","24","36","36","Zesu pe 'ezin‑ dɔɔ: «Mɛɛ 'kedo‑ 'kpɔ 'laa 'drunyan 'yan yi 'ɛ 'pegee ‑a 'waati 'ɛ dɔ. 'Kee‑ kpa laflɛ' 'yi ‑mlɛkɛ' mu ta oo, 'kee‑ kpa Bhaaplɛŋ Gbe 'ɛ 'gbu ta oo, ‑o 'kedo‑ 'kpɔ 'laa 'bhɛ yi 'ɛ dɔ 'ke yaa 'e go ‑Waanbhaa' do ‑kplɛn ba. ");
INSERT INTO moa_vpl VALUES ("MT24_37","070_24_37","MAT","24","37","37","‑Za 'la ꞊kla Noe a pɛ 'waati 'ɛ ba, 'bhɛɛ‑ 'yansi ‑za nu klɛlɛ 'ezin‑ Bhaaplɛŋ Gbe 'ɛ nu yi 'ɛ 'le. ");
INSERT INTO moa_vpl VALUES ("MT24_38","070_24_38","MAT","24","38","38","‑Amasrɔyi, la gblɔ ‑gbɛnɛ 'ɛ banle ‑lɛɛ 'waati 'ɛ ba, bhaaplɛŋ mu bole ‑yaa pɛbhlele 'pegee ‑wɛɛn 'mile‑ mu ‑la ma, ‑o ‑yaa le mu si, 'bhɛ 'pegee ‑o ‑yaa ‑o ‑lu mu na gwlɛn ni. ‑O ꞊bwa 'bhɛɛ‑ ‑za mu 'ɛ klɛle ma 'ke 'bhɛ ge 'tɛnlɛ‑ Noe 'wlale‑ ma ‑yitakoŋ ‑gbɛnɛ 'ɛ 'yi. ");
INSERT INTO moa_vpl VALUES ("MT24_39","070_24_39","MAT","24","39","39","Waa ‑za 'kedo‑ 'kpɔ yiɛnkanlɛ 'ke 'bhɛ ge 'tɛnlɛ‑ la gblɔ ‑gbɛnɛ 'ɛ banle ma. 'Bhɛɛ‑, 'bhɛ ‑yi 'ɛ 'bhɛ ‑o 'kpɛn 'wloola‑; 'bhɛɛ‑ ‑za 'ɛ 'yansi za nu klɛlɛ Bhaaplɛŋ Gbe 'ɛ 'nu yi 'ɛ 'le. ");
INSERT INTO moa_vpl VALUES ("MT24_40","070_24_40","MAT","24","40","40","'Bhɛ 'waati 'ɛ ba, mɛɛ plɛ nu klɛlɛ gba do ta, ‑o nu ‑a do 'silɛ‑, 'bhɛɛ‑ ‑a do bo. ");
INSERT INTO moa_vpl VALUES ("MT24_41","070_24_41","MAT","24","41","41","Le plɛ nu klɛlɛ pɛbhɛ zɔn yrɛ ꞊nɔɔ ‑wee do 'yi, ‑o nu ‑a do 'silɛ‑, 'bhɛɛ‑ ‑a do bo. ");
INSERT INTO moa_vpl VALUES ("MT24_42","070_24_42","MAT","24","42","42","'Ka 'yri 'laa golɛ 'ka 'gbu ‑za 'le, ‑amasrɔyi 'ka 'laa 'kaa‑ Mɛɛzan 'ɛ nu 'yi 'ɛ dɔ. ");
INSERT INTO moa_vpl VALUES ("MT24_43","070_24_43","MAT","24","43","43","‑Ka 'bhɛ ‑za 'lɛɛ‑ 'yima kplankplan dɔɔ: 'Ke 'fɛzan‑ do ‑yaa ‑faannii' 'ɛ nu 'waati 'ɛ dɔ ‑bi 'ɛ zi, yaa ‑yaa nu yidɛlɛ ‑titi, 'bhɛɛ‑ ‑ya to 'ke ‑faannii' 'ɛ wla ‑yaa' 'fɛ 'ɛ ꞊la. ");
INSERT INTO moa_vpl VALUES ("MT24_44","070_24_44","MAT","24","44","44","'Bhɛla‑ ‑zayile, 'ka mu 'ezin‑, 'ka 'yrisriwole bo, ‑amasrɔyi 'ka 'yri 'laa nu klɛlɛ Bhaaplɛŋ Gbe 'ɛ ta 'waati 'la ba ‑e nu nulɛ 'bhɛɛ‑ 'waati 'ɛ ba.» ");
INSERT INTO moa_vpl VALUES ("MT24_45","070_24_45","MAT","24","45","45","«‑Ka klɛ 'bhii‑ yewonɛ zru 'lrele‑ do. ‑A yikanle ‑yaa, 'bhɛɛ‑ ‑a zan 'bhɛ a 'fɛ 'ɛ ꞊la yewonɛ ‑vin mu 'ɛ gbɛkpaa‑ ‑a 'kɔɔ. 'Bhɛɛ‑ 'bhɛ pe ‑a ni dɔɔ ‑e pɛle na 'mu ni pɛbhle 'waati 'ɛ 'kpɛn ba. ");
INSERT INTO moa_vpl VALUES ("MT24_46","070_24_46","MAT","24","46","46","'Ke 'yee‑ yewonɛ 'ɛ ‑a zan 'ɛ ꞊nwa 'waati 'la ba, 'bhɛɛ‑ 'ke 'bhɛ ꞊bhwa ‑a ta 'bhɛ ye 'la gbɛkpaa‑ ‑a ‑kɔɔ 'bhɛ klɛle ma, ‑yaa' pɛ ‑yi nu ‑nralɛ'! ");
INSERT INTO moa_vpl VALUES ("MT24_47","070_24_47","MAT","24","47","47","Mi pe 'ka ni wlan 'ɛ ni dɔɔ 'fɛzan‑ 'ɛ nu 'bhɛ 'kɔɔpɛ‑ mu 'ɛ 'kpɛn gbɛkpalɛ ‑a 'kɔɔ. ");
INSERT INTO moa_vpl VALUES ("MT24_48","070_24_48","MAT","24","48","48","'Duŋ‑ 'ke yewonɛ 'yɔɔ‑ 'ɛ ‑ya ꞊pia ‑a 'gbu 'kpee dɔɔ: ‹'Ŋ zan 'ɛ yaa nu nulɛ 'saanibhe.› ");
INSERT INTO moa_vpl VALUES ("MT24_49","070_24_49","MAT","24","49","49","Bhɛɛ‑ 'kee‑ ‑dwa ‑a ‑vin yewonɛ mu 'ɛ tafɛle ma, 'bhɛɛ‑ 'kee‑ ꞊bwa pɛbhlele 'pegee ‑wɛɛn 'mile‑ ma ‑wɛɛn 'mi mu zi. ");
INSERT INTO moa_vpl VALUES ("MT24_50","070_24_50","MAT","24","50","50","'Ke 'bhɛ ꞊kla, 'fɛzan‑ 'nu yi 'pegee 'bhɛ 'nu 'waati 'ɛ nu 'klalɛ‑ 'yee‑ yewonɛ 'yɔɔ‑ 'ɛ ba, ‑amasrɔyi ‑a yri laa ‑o 'bhɛ ta, 'bhɛɛ‑ yaa 'bhɛ 'nu 'waati 'ɛ dɔ. ");
INSERT INTO moa_vpl VALUES ("MT24_51","070_24_51","MAT","24","51","51","'Bhɛ klɛgbɛya 'ɛ gbɛɛn‑ bhe, 'fɛzan‑ 'ɛ nu ‑yrɛnkpalɛ ‑a ta, 'bhɛɛ‑ 'bhɛ nu ‑a bɔlɛ yrɛ 'la 'ke mɛɛ ‑yrɛkɔɔza klɛ mu ‑o 'bhɛ ꞊nɔɔ 'bhɛ 'yi. 'Bhɛ yrɛ 'ɛ ꞊nɔɔ mɛɛ ‑bebe nu wisilɛ, 'ke ‑woo gbɛnɛbhɛ mu 'ɛ 'sɔnkpa‑ ‑zadɔwɛɛ 'kɔɔ.» ");
INSERT INTO moa_vpl VALUES ("MT25_1","070_25_1","MAT","25","1","1","'Bhɛ blaan, 'ke Zesu ‑gɔɔn do bɔle‑ ‑o ni dɔɔ: «‑Waanbhaa' a ‑bhleŋgbeya 'ɛ ‑yoo 'bhii‑ ‑gblanɛ vu 'la ‑o ‑waa' ‑laŋbha mu 'ɛ ꞊sia ‑bi 'ɛ zi, 'bhɛɛ‑ ‑o pe do dɔɔ ‑woo gele‑ le drɛɛ ‑nɔɔ 'ɛ 'lɛpayrɛ ꞊nɔɔ. ");
INSERT INTO moa_vpl VALUES ("MT25_2","070_25_2","MAT","25","2","2","'Woo‑ ‑gblanɛ vu 'ɛ, ‑a 'soo yikanle laa ‑yaa, 'bhɛɛ‑ ‑a ‑vin 'soo 'ɛ 'mu yikanle ‑yaa. ");
INSERT INTO moa_vpl VALUES ("MT25_3","070_25_3","MAT","25","3","3","‑Gblanɛ mu 'la yikanle laa ‑yaa 'bhɛ mu 'mu a ‑laŋbha mu 'ɛ ꞊sia, 'bhɛɛ‑ waa 'tɛyi 'bhɛɛke 'kpalɛ‑ ‑o gbɛ ‑din buteli mu 'yi. ");
INSERT INTO moa_vpl VALUES ("MT25_4","070_25_4","MAT","25","4","4","'Bhɛɛ‑ 'duŋ‑, ‑a ‑vin ‑gblanɛ yikanle 'soo 'ɛ 'bhɛ mu 'mu a ‑laŋbha 'yi 'tɛyi 'bhɛɛke mu ‑kpaa 'mu gbɛ ‑din buteli mu 'yi. ");
INSERT INTO moa_vpl VALUES ("MT25_5","070_25_5","MAT","25","5","5","Le drɛɛ ‑nɔɔ 'ɛ yaa ‑yaa zan veŋ‑, ‑ayile 'ke yi 'kpale 'woo‑ ‑gblanɛ vu 'ɛ 'yrɛ ta, 'bhɛɛ‑ 'ke ‑o 'kpɛn yidɛle.» ");
INSERT INTO moa_vpl VALUES ("MT25_6","070_25_6","MAT","25","6","6","«'Bhɛ klɛle 'tɛ, blaŋdrɛyi 'bhɔle‑, 'ke ‑o ‑gbekanwli do male‑ dɔɔ: ‹‑Ka 'ka 'yrɛkpa le ‑nɔɔ 'ɛ 'pwɛla‑ ‑a ‑yi! 'Ka 'pwɛ 'bhɛɛ‑ ‑ka ge ‑a ‑lɛpayrɛ 'ɛ nɔɔ‑!› ");
INSERT INTO moa_vpl VALUES ("MT25_7","070_25_7","MAT","25","7","7","'Bhɛ 'yi 'tɛ, 'ke 'woo‑ ‑gblanɛ vu 'ɛ ‑o bwele‑ yi 'ɛ pla, 'bhɛɛ‑ 'ke ‑o ‑waa' ‑laŋbha mu 'ɛ 'bhile‑ 'sanle. ");
INSERT INTO moa_vpl VALUES ("MT25_8","070_25_8","MAT","25","8","8","'Bhɛɛ‑ ‑gblanɛ mu 'la yikanle laa ‑yaa 'mu pe ‑gblanɛ yikanle mu 'ɛ ni dɔɔ: ‹‑Ka 'o gba 'kaa‑ 'tɛyi 'ɛ 'ke ba; ‑amasrɔyi 'waa‑ ‑laŋbha mu 'ɛ ‑woo ‑lii 'zi.› ");
INSERT INTO moa_vpl VALUES ("MT25_9","070_25_9","MAT","25","9","9","'Duŋ‑, 'ke ‑gblanɛ yikanle mu 'ɛ 'mu 'a zikpale ‑o ni dɔɔ: ‹'Yooye‑, 'waa‑ 'tɛyi 'ɛ yaa nu 'sɔlɛ‑ 'o mɔɔ 'pegee 'ka mu mabhɔle. ‑Ka ge 'kaa‑ pɛ 'tɛyi 'lɔ 'tɛyi gɔn mu 'ɛ ba.› ");
INSERT INTO moa_vpl VALUES ("MT25_10","070_25_10","MAT","25","10","10","'Bhɛ klɛle 'tɛ, 'woo‑ ‑gblanɛ mu 'la yikanle laa ‑yaa ‑o ‑yaa ge 'zi bhla 'la ba ‑waa' pɛ 'tɛyi 'lɔ yrɛ nɔɔ‑, 'ke le ‑nɔɔ 'ɛ 'nule. ‑Gblanɛ 'soo 'la 'mu ‑lɛbɛŋgole ‑yaa, le ‑nɔɔ 'ɛ 'pegee 'mu ꞊wlaa le drɛɛ dɔ 'fɛ 'ɛ ꞊la, 'bhɛɛ‑ ‑o 'fɛ 'ɛ 'lii 'ɛ ꞊taan ‑o ‑zanta'. ");
INSERT INTO moa_vpl VALUES ("MT25_11","070_25_11","MAT","25","11","11","'Waati sa 'kanle, 'ke ‑gblanɛ 'soo 'la yikanle laa ‑yaa 'mu 'nule, 'bhɛɛ‑ 'ke 'mu le drɛɛ ‑nɔɔ 'ɛ 'siile dɔɔ: ‹'O zan, 'o zan, 'fɛ 'ɛ 'liigo‑ 'o ni!› ");
INSERT INTO moa_vpl VALUES ("MT25_12","070_25_12","MAT","25","12","12","'Duŋ‑ 'yee‑ le drɛɛ nɔɔ‑ 'ɛ ‑ya zikpaa‑ ‑o ni dɔɔ: ‹'Ŋ 'sɔwɛɛ‑ ma 'mi pe 'ka ni 'naa 'ka dɔ!›» ");
INSERT INTO moa_vpl VALUES ("MT25_13","070_25_13","MAT","25","13","13","Zesu pe ‑yaa' ‑klaŋlanɛ mu 'ɛ ni dɔɔ: «'Bhɛ klɛgbɛya do 'ɛ gbɛɛn‑, 'ka mu ‑yri 'laa golɛ 'ka 'gbu ‑za 'le, ‑amasrɔyi 'ka 'laa *Bhaaplɛŋ Gbe 'ɛ ‑a nu yi 'pegee ‑a nu 'waati 'ɛ dɔ.» ");
INSERT INTO moa_vpl VALUES ("MT25_14","070_25_14","MAT","25","14","14","«‑Waanbhaa' a ‑bhleŋgbeya 'ɛ ‑yoo 'bhii‑ 'fɛzan‑ do a ‑za. ‑A ge bhla zi 'taa do ta, ‑e ‑yaa' yewonɛ mu 'ɛ 'siila‑, 'bhɛɛ‑ ‑ya 'kɔɔpɛ‑ mu 'ɛ gbɛkpaa‑ 'mu 'kɔɔ. ");
INSERT INTO moa_vpl VALUES ("MT25_15","070_25_15","MAT","25","15","15","‑E ‑gɔli' 'taŋbha 'pu ‑kɛmɛ 'soo ꞊naa ‑a ‑lwa mi 'ɛ ni. 'Bhɛɛ‑ ‑ya ‑naa ‑a plɛ mi 'ɛ ni ‑gɔli' 'taŋbha 'pu ‑kɛmɛ plɛ; 'bhɛɛ‑ ‑ya ‑naa ‑a yaga mi 'ɛ ni ‑gɔli' 'taŋbha 'pu ‑kɛmɛ do. ‑O 'kpɛn do do 'seŋ 'yaa‑ sɔ ‑za yɛkɛ‑ 'la klɛle ta, 'fɛzan‑ 'ɛ ‑e 'bhɛɛ‑ yɛkɛ‑ ‑gɔli' 'yiciɛnna ‑o 'kpɛn ma do do. 'Bhɛ blaan, 'kee‑ gele‑ ‑yaa' 'taa 'ɛ ta 'tɛ. ");
INSERT INTO moa_vpl VALUES ("MT25_16","070_25_16","MAT","25","16","16","'Bhɛ ya 'ɛ 'yi, yewonɛ 'la 'bhɛ ‑gɔli' 'taŋbha ‑kɛmɛ 'soo 'ɛ 'srɔɔwoa‑, 'bhɛ ‑ja yewolɛ 'ke ‑yaa' ‑gɔli' 'ɛ 'le, 'bhɛɛ‑ 'ke 'bhɛ ‑gɔli' 'taŋbha 'bhɛɛke ‑kɛmɛ 'soo ‑trɔn 'kpale ‑yaa' ‑kɛmɛ 'soo ꞊lwa 'ɛ ma. ");
INSERT INTO moa_vpl VALUES ("MT25_17","070_25_17","MAT","25","17","17","'Bhɛɛ‑ yewonɛ 'la 'bhɛ ‑gɔli' 'taŋbha ‑kɛmɛ plɛ 'ɛ 'srɔɔwoa‑, 'bhɛ yewoa‑ 'bhɛ klɛgbɛya do 'ɛ 'yi, 'bhɛɛ‑ 'ke 'bhɛ ‑gɔli' 'taŋbha ‑kɛmɛ plɛ ‑trɔn 'srɔɔwole. ");
INSERT INTO moa_vpl VALUES ("MT25_18","070_25_18","MAT","25","18","18","'Duŋ‑, yewonɛ 'la 'bhɛ ‑gɔli' 'taŋbha ‑kɛmɛ do 'ɛ 'srɔɔwoa‑, 'bhɛ ‑ja ‑gluu do 'kanlɛ‑, 'bhɛɛ‑ 'ke ‑ya zan a ‑gɔli' 'ɛ magaanle 'bhɛ ‑gluu 'ɛ 'yi.» ");
INSERT INTO moa_vpl VALUES ("MT25_19","070_25_19","MAT","25","19","19","«'Bhɛ blaan ‑mɔle', 'ke 'woo‑ yewonɛ mu 'ɛ ‑o zan dale‑ 'bhɛ a 'taa 'ɛ ta; 'bhɛɛ‑ 'ke 'bhɛ ‑o 'kpɛn 'siile, 'kooko‑ ‑e ‑gɔli' mu 'la gbɛkpaa‑ ‑o ‑kɔɔ ‑o nu 'bhɛ mu blaanta janwo a ni. ");
INSERT INTO moa_vpl VALUES ("MT25_20","070_25_20","MAT","25","20","20","'Bhɛ 'yi 'tɛ, ‑yaa' yewonɛ 'la 'bhɛ ‑gɔli' 'taŋbha ‑kɛmɛ 'soo 'ɛ 'srɔɔwoa‑, 'ke 'bhɛ 'e 'mabɛɛnle ‑o zan 'ɛ ‑din, 'bhɛɛ‑ 'bhɛ ‑gɔli' 'taŋbha ‑kɛmɛ 'soo 'bhɛɛke ꞊la 'srɔɔwoa‑, 'ke 'bhɛ 'mu zrɔnle‑ ‑o zan ni 'ke ‑ya pe dɔɔ: ‹'Ŋ Zan, 'e ‑gɔli' 'taŋbha ‑kɛmɛ 'soo 'la gbɛkpaa‑ 'ŋ 'kɔɔ 'bhɛ 'pegee 'an 'bhɛɛke ‑kɛmɛ 'soo 'la 'srɔɔwoa‑ ‑a ma ‑trɔn 'le 'wole‑ ‑gɛ.› ");
INSERT INTO moa_vpl VALUES ("MT25_21","070_25_21","MAT","25","21","21","'Bhɛ klɛle 'tɛ, 'ke ‑a zan 'a 'pele 'a ni dɔɔ: ‹'E ‑za 'lrele‑ ꞊kla 'bhɛ 'le. Yewonɛ wlan 'bhɛ 'pegee yewonɛ 'la zru ‑o do 'ŋ ni. 'E zru ꞊kla do 'mi ni ‑za 'fiɛntrɔnnɛ mu yi gɔnɛ‑ 'la gbɛɛn‑, 'mi nu ‑za ‑gbɛnɛ mu gbɛkpalɛ 'e 'kɔɔ 'bhɛɛ‑ gbɛɛn‑. Nu ‑gɛ 'bhɛɛ‑ 'bhi 'pegee 'mi 'woo‑ zrukpala 'eke‑ zi.› ");
INSERT INTO moa_vpl VALUES ("MT25_22","070_25_22","MAT","25","22","22","'Bhɛ blaan, yewonɛ 'la 'bhɛ ‑gɔli' 'taŋbha ‑kɛmɛ plɛ 'ɛ 'srɔɔwoa‑, 'bhɛ 'e ‑mabɛɛnle ‑o zan 'ɛ ‑din, 'ke ‑ya pele‑ dɔɔ: ‹'Ŋ zan, 'e ‑gɔli' 'taŋbha ‑kɛmɛ plɛ 'la gbɛkpaa‑ 'ŋ 'kɔɔ, 'bhɛ 'pegee 'an 'bhɛɛke ‑kɛmɛ plɛ 'la 'srɔɔwoa‑ ‑a ma ‑trɔn 'le 'wole‑ ‑gɛ.› ");
INSERT INTO moa_vpl VALUES ("MT25_23","070_25_23","MAT","25","23","23","'Bhɛ 'yi bhe, 'ke ‑a zan 'a 'pele a ni dɔɔ: ‹'E ‑za 'lrele‑ ꞊kla 'bhɛ 'le. Yewonɛ wlan 'bhɛ 'pegee yewonɛ 'la zru ‑o do 'ŋ ni. 'E zru ꞊kla do 'ŋ ni ‑za 'fiɛntrɔnnɛ mu 'yi, ‑ayile 'ŋ nu ‑za ‑gbɛnɛ mu gbɛkpalɛ 'e 'kɔɔ. Nu ‑gɛ 'bhɛɛ‑ 'bhi 'pegee 'mi 'woo‑ zrukpala 'eke‑ zi.› ");
INSERT INTO moa_vpl VALUES ("MT25_24","070_25_24","MAT","25","24","24","'Bhɛ blaan, yewonɛ 'la 'bhɛ ‑gɔli' 'taŋbha ‑kɛmɛ do 'ɛ 'srɔɔwoa‑, 'bhɛ 'e 'mabɛɛnle ‑o zan 'ɛ ‑din 'ke ‑ya pele‑ dɔɔ: ‹'Ŋ zan, 'an 'yaango‑ 'bhii‑ 'yoo‑ mɛɛ ‑glɔɔ do 'le, 'bhɛɛ‑ 'yaa pɛbhɛ bɔlɛ yrɛ 'la ꞊nɔɔ, 'e pɛbhɛ kan 'bhɛɛ‑ yrɛ 'ɛ ꞊nɔɔ; 'bhɛ 'pegee 'yaa ‑yri 'sɔlɛ‑ yrɛ 'la ꞊nɔɔ, 'e ‑yri bhaa kan 'bhɛɛ‑ yrɛ 'ɛ ꞊nɔɔ. ");
INSERT INTO moa_vpl VALUES ("MT25_25","070_25_25","MAT","25","25","25","'Ŋ ‑gblaanlawoa 'e 'lɛɛ, ‑ayile 'ŋ ‑ja 'yaa‑ ‑gɔli' 'ɛ magaanlɛ 'trɛ ꞊la. 'Yaa‑ ‑gɔli' 'ɛ 'yele‑ ‑gɛ.› ");
INSERT INTO moa_vpl VALUES ("MT25_26","070_25_26","MAT","25","26","26","'Bhɛ klɛle 'tɛ, 'ke ‑a zan 'a 'pele ‑a ni dɔɔ: ‹Yewonɛ 'yɔɔ‑, 'bhɛɛ‑ lrwanii‑. 'Ya 'yaango‑ 'bhii‑ 'naa pɛbhɛ bɔlɛ yrɛ 'la ꞊nɔɔ 'ŋ pɛbhɛ kan 'bhɛɛ‑ ꞊nɔɔ; 'bhɛɛ‑ 'naa ‑yri 'sɔlɛ‑ yrɛ 'la ꞊nɔɔ 'ŋ ‑yri bhaa kan 'bhɛɛ‑ ꞊nɔɔ. ");
INSERT INTO moa_vpl VALUES ("MT25_27","070_25_27","MAT","25","27","27","‑Mɛla ma 'bhɛɛ‑ 'yaa gelɛ 'an ‑gɔli' 'ɛ 'kpalɛ‑ ‑gɔli' magaan 'fɛ 'ɛ ꞊la, 'bhɛɛ‑ 'ke 'ŋ 'yaa‑ da, 'ŋ 'yaa‑ sɔ ‑a 'sile 'bhɛ 'pegee ‑a ma ‑trɔn 'ɛ 'le! ");
INSERT INTO moa_vpl VALUES ("MT25_28","070_25_28","MAT","25","28","28","‑Kaa 'kɔɔpɛ‑ ‑gɔli' 'taŋbha ‑kɛmɛ do 'ɛ 'kun, 'bhɛɛ‑ ka 'bhɛ 'na ‑gɔli' 'taŋbha ‑kɛmɛ 'soo ‑o mɛɛ 'la zan ‑kɔɔ 'bhɛ ni. ");
INSERT INTO moa_vpl VALUES ("MT25_29","070_25_29","MAT","25","29","29","‑Amasrɔyi, pɛ ‑o mɛɛ 'la zan 'kɔɔ, ‑o nu ‑a 'kɔɔpɛ‑ 'ɛ baankpalɛ, 'kooko‑ ‑a 'kɔɔ pa. 'Bhɛɛ‑ 'duŋ‑, pɛ 'kedo‑ 'kpɔ 'laa ‑o mɛɛ 'la zan 'kɔɔ, ‑o nu a 'kɔɔpɛ‑ sanɛ‑ 'gbu 'ɛ 'kunlɛ‑ a 'kɔɔ. ");
INSERT INTO moa_vpl VALUES ("MT25_30","070_25_30","MAT","25","30","30","‑Ka 'yee‑ yewonɛ 'la yaa ‑za 'kedo‑ 'yanwo‑ mɛɛ ma, ‑kaa 'kun, 'bhɛɛ‑ ‑kaa blin 'pɛɛlii‑ ‑gblo 'ɛ 'yi. 'Bhɛɛ‑ ꞊nɔɔ, ‑e nu wisilɛ, 'ke ‑ya gbɛnɛbhɛ mu 'ɛ 'sɔnkpa‑ ‑zadɔwɛɛ 'ɛ 'kɔɔ.›» ");
INSERT INTO moa_vpl VALUES ("MT25_31","070_25_31","MAT","25","31","31","Zesu pe 'ezin‑ dɔɔ: «'Ke Bhaaplɛŋ Gbe 'ɛ ꞊nwa ‑yaa' 'tɔbhɔleya 'ɛ 'yi yi 'la 'le, 'yee‑ 'pegee ‑yaa' ‑mlɛkɛ' mu 'ɛ 'kpɛn 'le ‑a zi, ‑e nu yaalɛ ‑yaa' ‑bhleŋgbe 'tɔbhɔ ma 'yaakpe‑ 'ɛ ta. ");
INSERT INTO moa_vpl VALUES ("MT25_32","070_25_32","MAT","25","32","32","'Bhɛ ya 'ɛ 'yi, 'trɛ ta 'si mu 'ɛ 'kpɛn 'lɛkpale nu klɛlɛ 'eke‑ ta ‑a ‑lɛ ma. 'Bhɛɛ‑ ‑e nu bhaaplɛŋ mu 'ɛ bagolɛ 'bhii‑ ‑bhlaa gooba mi 'ɛ ‑e ‑bhlaa mu 'ɛ 'pleŋgo‑ bhoo mu 'ɛ ma gɔnɛ‑ 'la gbɛɛn‑ 'bhɛɛ‑ gbɛɛn‑. ");
INSERT INTO moa_vpl VALUES ("MT25_33","070_25_33","MAT","25","33","33","Bhaaplɛŋ Gbe 'ɛ ‑e nu ‑bhlaa mu 'ɛ 'kpalɛ‑ ‑a gbɛ ‑yiɛ' ta, 'bhɛɛ‑ ‑e nu bhoo mu 'ɛ 'kpalɛ‑ ‑a gbɛ ‑koo ta. ");
INSERT INTO moa_vpl VALUES ("MT25_34","070_25_34","MAT","25","34","34","'Ke 'bhɛ ꞊kla, ‑bhleŋgbe 'ɛ nu a pelɛ mɛɛ 'la zan mu ‑o ‑a gbɛ ‑yiɛ' ta 'mu ni dɔɔ: ‹‑Ka nu 'ka mu 'la 'ŋ Dɛ 'ka 'dumawoa. 'Bhɛɛ‑ 'ka 'ciɛn klɛ ‑Waanbhaa' ‑bhleŋgbeya ‑wa 'la magaanna 'ka ni, 'kee‑ san 'drunyan zibɔ 'waati 'ɛ ma ‑a 'kɔɔ 'bhɛɛ‑ 'le. ");
INSERT INTO moa_vpl VALUES ("MT25_35","070_25_35","MAT","25","35","35","‑Amasrɔyi, gbɔn 'ŋ ꞊dia, 'bhɛɛ‑ 'ka pɛle ‑naa 'ŋ ni; ‑yi 'mi ‑lrɔ 'ŋ ꞊dia, 'bhɛɛ‑ 'ka ‑yi ‑naa 'ŋ ni, 'ŋ 'yaa‑ 'cie 'le 'ka ba, 'bhɛɛ‑ 'ka 'ŋ 'cieya‑ ꞊kla. ");
INSERT INTO moa_vpl VALUES ("MT25_36","070_25_36","MAT","25","36","36","'Ŋ ta fleŋ‑ ‑yaa, 'bhɛɛ‑ 'ka dunɛ‑ ꞊klaa 'ŋ ta. Ga ‑yaa 'ŋ ma, 'bhɛɛ‑ 'ka 'ŋ ‑gblakwan. 'Ŋ 'yaa‑ ‑kaso 'yi 'bhɛɛ‑ 'ka ‑ja 'ŋ taglinlɛ.› ");
INSERT INTO moa_vpl VALUES ("MT25_37","070_25_37","MAT","25","37","37","'Bhɛ klɛle 'tɛ, mɛɛ ‑lɛdɔɔle mu 'ɛ 'mu nu ‑a mabɔlɛ ‑a ni 'tɛ dɔɔ: ‹Mɛɛzan, gbɔn ‑yaa 'e dɛ 'zi 'waati 'ɛ ‑dela ba 'bhɛɛ‑ 'o pɛle ‑naa 'ɛ ni ɛɛ? 'Bhɛɛ‑ 'yi 'mi ‑lrɔ ‑yaa' 'e ma 'waati 'ɛ ‑dela ba, 'bhɛɛ‑ 'o ‑yi ‑naa 'e ni ɛɛ? ");
INSERT INTO moa_vpl VALUES ("MT25_38","070_25_38","MAT","25","38","38","'Woo 'e ꞊ya 'cie 'le 'waati 'ɛ ‑dela ba, 'bhɛɛ‑ 'woo‑ 'e cieya‑ ꞊kla ɛɛ? 'E ta fleŋ‑ ‑yaa 'waati 'ɛ ‑dela ba, 'bhɛɛ‑ 'o dunɛ‑ ꞊klaa 'e ta ɛɛ? ");
INSERT INTO moa_vpl VALUES ("MT25_39","070_25_39","MAT","25","39","39","'Woo 'e ꞊ya 'ke ga ‑o 'e ma 'waati 'ɛ ‑dela ba, 'bhɛ 'pegee 'woo‑ 'e ꞊ya ‑kaso 'yi 'waati 'ɛ ‑dela ba, 'bhɛɛ‑ 'o ‑ja 'e taglinlɛ ɛɛ?› ");
INSERT INTO moa_vpl VALUES ("MT25_40","070_25_40","MAT","25","40","40","'Bhɛ ya 'ɛ 'yi, ‑bhleŋgbe 'ɛ nu ‑a zikpalɛ ‑o ni dɔɔ: ‹'Mi pe 'ka ni wlan 'ɛ ni dɔɔ: 'Waati 'oo 'waati 'la ba 'ke 'ka ‑za 'wlan ꞊kla 'ŋ nɛɛnɛ‑ mu 'lɛɛ‑ ‑o 'fiɛntrɔnnɛ do 'kpɔ ni, 'ka 'bhɛ ꞊kla 'mi ‑la ni bhe.› ");
INSERT INTO moa_vpl VALUES ("MT25_41","070_25_41","MAT","25","41","41","«'Bhɛ blaan, ‑bhleŋgbe 'ɛ nu a pelɛ ‑e mɛɛ 'la zan mu ‑kpaa ‑a gbɛ ‑koo ta 'mu ni dɔɔ: ‹‑Ka 'ka 'pleŋgo‑ 'ŋ ma, 'daŋgan ma mɛɛ mu! ‑Ka ge bɔ 'tɛ 'la yaa lii ‑titi 'bhɛ 'yi, ‑wa ‑lɛswan ‑Setran' a ‑mlɛkɛ' mu 'ɛ 'mu ‑la 'kaama‑. ");
INSERT INTO moa_vpl VALUES ("MT25_42","070_25_42","MAT","25","42","42","‑Amasrɔyi, gbɔn ‑yaa 'ŋ dɛ 'zi, 'bhɛɛ‑ 'ka 'laa pɛle nalɛ 'ŋ ni; ‑yi 'mi ‑lrɔ 'ŋ ꞊dia, 'bhɛɛ‑ 'ka 'laa ‑yi 'nalɛ‑ 'ŋ ni. ");
INSERT INTO moa_vpl VALUES ("MT25_43","070_25_43","MAT","25","43","43","'Ŋ 'yaa‑ 'cie 'le 'ka ba, 'bhɛɛ‑ 'ka 'laa 'ŋ 'cieya‑ klɛlɛ. 'Ŋ ta fleŋ‑ 'yaa‑, 'bhɛɛ‑ 'ka 'laa dunɛ‑ 'klalɛ‑ 'ŋ ta. Ga ‑yaa 'ŋ ma 'bhɛ 'pegee 'ŋ 'yaa‑ ‑kaso 'yi, 'bhɛɛ‑ 'ka 'laa gelɛ 'ŋ taglinlɛ.› ");
INSERT INTO moa_vpl VALUES ("MT25_44","070_25_44","MAT","25","44","44","'Ke 'bhɛ ꞊kla, ‑o nu a mabɔlɛ ‑a ni dɔɔ: ‹Mɛɛzan, 'bhɛ ‑za mu 'ɛ 'kpɛn ꞊kla 'waati 'ɛ ‑dela ba ɛɛ? Gbɔn ‑yaa 'e dɛ 'zi oo, ‑yi 'mi ‑lrɔ ‑yaa 'e dɛ 'zi oo, 'e 'yaa‑ 'ke 'cie 'le oo, 'e ta fleŋ‑ ‑yaa oo, ga ‑yaa 'e ma 'bhɛ 'pegee 'e 'yaa‑ ‑kaso 'yi oo, 'mu 'kpɛn ꞊kla 'waati 'ɛ ‑dela ba ɛɛ?› ");
INSERT INTO moa_vpl VALUES ("MT25_45","070_25_45","MAT","25","45","45","'Bhɛ ya 'ɛ 'yi, ‑bhleŋgbe 'ɛ nu ‑a ‑lɛkunlɛ ‑o ni 'tɛ dɔɔ: ‹'Mi pe 'ka ni wlan 'ɛ ni dɔɔ: 'Waati 'oo 'waati 'la ba, 'ke 'ka 'laa ‑za 'wlan klɛlɛ 'woo‑ ‑nɛ 'fiɛntrɔnnɛ mu 'la bhe ‑o do 'kpɔ ni, 'ka 'laa 'bhɛ klɛlɛ 'mi ‑la ni.› ");
INSERT INTO moa_vpl VALUES ("MT25_46","070_25_46","MAT","25","46","46","‑Ayile, 'woo‑ gbɛ ‑koo ta mu 'ɛ, ‑o nu gelɛ ‑kaso 'la 'ke ‑daŋ' 'laa ‑o 'bhɛ ma 'bhɛ 'yi, 'bhɛɛ‑ gbɛ ‑yiɛ' ta mu 'ɛ 'mu nu gelɛ ‑Waanbhaa' ba bole ‑yrɛ ma ‑si 'la ‑daŋ' 'laa ‑o 'bhɛ ma, 'bhɛ yrɛ 'ɛ ꞊nɔɔ.» ");
INSERT INTO moa_vpl VALUES ("MT26_1","070_26_1","MAT","26","1","1","Zesu 'yanle‑ 'bhɛ ‑jan mu 'ɛ 'kpɛn 'wolele, 'ke ‑ya pele‑ ‑yaa' ‑klaŋlanɛ mu 'ɛ ni dɔɔ: ");
INSERT INTO moa_vpl VALUES ("MT26_2","070_26_2","MAT","26","2","2","«'Kaa 'yaango‑ dɔɔ ‑a ‑vinbwa ‑yrekpaa' plɛ 'bhɛɛ‑ *Paki 'fɛti yi 'ɛ bhɔ. 'Bhɛɛ‑ ‑o nu Bhaaplɛŋ Gbe 'ɛ 'lɛnalɛ mɛɛ mu ni, 'kooko‑ ‑wa gbaan ‑yrigbɛɛle do ta.» ");
INSERT INTO moa_vpl VALUES ("MT26_3","070_26_3","MAT","26","3","3","'Bhɛ klɛle 'tɛ, 'ke *'sraka 'lɛna ‑kuŋlii mu 'ɛ 'pegee Zuufu 'si mu 'ɛ waa 'gwlaan‑ gblaan mu 'ɛ ‑woo ‑lɛkpale 'eke‑ ta 'sraka 'lɛna mu a ‑kuŋlii gblaan 'ɛ 'bhɛ a ‑gbeŋ 'ɛ 'yi: 'Bhɛ 'sraka 'lɛna mu a ‑kuŋlii gblaan 'ɛ 'tɔ ‑le ‑yaa Kaifu. ");
INSERT INTO moa_vpl VALUES ("MT26_4","070_26_4","MAT","26","4","4","‑O 'kpɛn 'a ꞊kpaa do dɔɔ ‑o nu Zesu 'kunlɛ‑ ‑dawli' ma 'bhɛɛ‑ ‑wa dɛ. ");
INSERT INTO moa_vpl VALUES ("MT26_5","070_26_5","MAT","26","5","5","'Duŋ‑ ‑o pe 'eke‑ ni dɔɔ: «'Kɔɔ‑ 'laa ‑a 'kunlɛ‑ 'fɛti yi 'ɛ ma, 'kebhlaale, mɛɛ mu 'ɛ ‑o nu 'wlɛnlɛ‑ 'eke‑ ma 'bhɛɛ‑ ‑o 'fɛti 'ɛ 'siɛ.» ");
INSERT INTO moa_vpl VALUES ("MT26_6","070_26_6","MAT","26","6","6","Zesu 'yaa‑ Betani ‑wa 'ɛ ta, 'bhɛɛ‑ Simɔ 'la ‑e 'bhɛ ma ‑kpaan 'ɛ ‑gwa, ‑e ‑yaa 'bhɛ ba 'fɛ 'ɛ ꞊la 'waati 'la ba, ");
INSERT INTO moa_vpl VALUES ("MT26_7","070_26_7","MAT","26","7","7","'ke le do 'e 'mabɛɛnle 'a ‑din 'ke ‑lasiklɔɔ ‑gblɛn 'nrale‑ alibatri buteli do 'le 'bhɛ 'kɔɔ: ‑lasiklɔɔ 'plɛɛle‑ 'yaa‑ 'kɛle‑. 'Bhɛɛ‑ Zesu 'yaa‑ pɛbhle 'zi 'waati 'la ba, 'ke 'yee‑ le 'ɛ ‑e 'bhɛ ‑lasiklɔɔ 'ɛ 'klaale Zesu 'wiiŋ‑. ");
INSERT INTO moa_vpl VALUES ("MT26_8","070_26_8","MAT","26","8","8","'Bhɛ klɛle 'tɛ, Zesu a ‑klaŋlanɛ mu 'ɛ 'yrɛkpale 'bhɛ ma, 'ke ‑woo zrupliile, 'bhɛɛ‑ 'ke ‑wa pele‑ dɔɔ: «Pɛ 'siɛgbɛya 'la ‑gee' bhe 'bhɛ win ‑o ‑mɛla ‑le ɛɛ? ");
INSERT INTO moa_vpl VALUES ("MT26_9","070_26_9","MAT","26","9","9","‑O ‑yaa sɔ 'yee‑ ‑lasiklɔɔ 'lɛɛ‑ gɔnle‑ 'plɛɛ 'lrele‑ 'le, 'bhɛɛ‑ ‑wa ma ‑gɔli' 'ɛ na 'kɔɔfleŋzan mu ni!» ");
INSERT INTO moa_vpl VALUES ("MT26_10","070_26_10","MAT","26","10","10","'Bhɛ klɛle 'tɛ, 'ke Zesu 'a 'yaangole 'bhii‑ ‑o ‑yaa 'bhɛ ‑jan ‑glɔɔn 'ɛ 'wo zii', 'ke ‑ya pele‑ ‑o ni dɔɔ: «‑Mɛle ꞊kla 'bhɛɛ‑ 'ka ‑o le ‑nɛ 'lɛɛ‑ 'ɛ zrubatɛdɔ zii' ɛɛ? ‑E ‑za 'wlan ‑la ꞊kla 'ŋ ni bhe. ");
INSERT INTO moa_vpl VALUES ("MT26_11","070_26_11","MAT","26","11","11","‑Amasrɔyi yi 'oo yi, 'kɔɔfleŋzan mu ‑o 'ka 'pleŋ‑; 'duŋ‑ 'mi 'laa ‑o 'ka 'pleŋ‑ yikpɛnsee ta. ");
INSERT INTO moa_vpl VALUES ("MT26_12","070_26_12","MAT","26","12","12","Le 'ɛ ‑e ‑lasiklɔɔ 'la ꞊klaa 'ŋ 'flɛ ma ‑gɛ, ‑e ‑yaan 'bhɛ klɛle 'le 'sani‑ 'ŋ gbaa bin 'waati 'ɛ 'bhɔle‑ pleŋ‑. ");
INSERT INTO moa_vpl VALUES ("MT26_13","070_26_13","MAT","26","13","13","'Mi pe 'ka ni wlan 'ɛ ni dɔɔ 'ke ‑o ‑Jan 'Nrale‑ 'lɛɛ‑ 'wole‑ 'ɛ ꞊zian yrɛ 'oo 'yrɛ 'la ꞊nɔɔ, le 'lɛɛ‑ klɛza 'ɛ nu bolɛ mɛɛ mu 'kpee ‑jan ma ‑gɔɔn 'le.» ");
INSERT INTO moa_vpl VALUES ("MT26_14","070_26_14","MAT","26","14","14","'Bhɛ blaan, Zesu a ‑klaŋlanɛ vu ta plɛ 'ɛ ba, ‑o ‑yaa ‑a 'kɛla sii Zudasi Isikariɔti, 'bhɛ ‑ja 'Sraka 'lɛna mu ‑kuŋlii mu 'ɛ ba, ");
INSERT INTO moa_vpl VALUES ("MT26_15","070_26_15","MAT","26","15","15","'bhɛɛ‑ 'ke ‑yoo ‑lrɔkpale dɔɔ: «'Ka nu ‑mɛ pɛ 'gbu ‑la nalɛ 'ŋ ni 'ke 'ŋ Zesu 'lɛnaa‑ 'ka ni ɛɛ?» 'Bhɛ klɛle 'tɛ, 'ke 'mu ‑gɔli' 'taŋbha mia do 'bhɛ vu 'nale‑ ‑a ni. ");
INSERT INTO moa_vpl VALUES ("MT26_16","070_26_16","MAT","26","16","16","‑A 'san 'bhɛ yi 'ɛ ma, Zudasi gbɛ ‑yaa nu 'sɔlɛ‑ Zesu ta gɔnɛ‑ 'la gbɛɛn‑, 'bhɛɛ‑ ‑ya ‑lɛna' ‑o ni, ‑e ‑yaa 'bhɛɛ‑ 'waati kplankplan 'ɛ ‑glin 'zi. ");
INSERT INTO moa_vpl VALUES ("MT26_17","070_26_17","MAT","26","17","17","Paki 'fɛti 'ɛ 'yrekpaa‑ ‑lwa mi 'ɛ ma, ‑o ‑yaa 'bluu 'la bhle, waa ‑yaa 'bluu ‑pɛɛ 'wlɛn 'sɛkɛ kla 'bhɛ ‑pɛɛ 'ɛ ba. 'Bhɛ ‑yrekpaa' do 'ɛ 'le, 'ke Zesu a ‑klaŋlanɛ mu 'ɛ 'nule ‑a ‑lrɔkpalɛ dɔɔ: «꞊Ya zi 'bhii‑ 'o 'fɛti 'ɛ ta kpo 'ɛ klɛ 'naa‑ ma ɛɛ?» ");
INSERT INTO moa_vpl VALUES ("MT26_18","070_26_18","MAT","26","18","18","Zesu mɛɛ do 'tɔ ꞊kaan ‑o ni, 'bhɛɛ‑ ‑ya ꞊pia ‑o ni dɔɔ: «‑Ka ge ‑wa 'ɛ 'kpee 'yee‑ mɛɛ 'ɛ ba, 'bhɛɛ‑ 'kaa pe a ni dɔɔ: ‹'O Daan mi 'ɛ pe dɔɔ ‑yaa' pɛ 'waati 'ɛ ꞊bhwa, 'yee‑ 'pegee ‑yaa' ‑klaŋlanɛ mu 'ɛ nu ‑waa' Paki 'fɛti ta pɛ 'ɛ 'bhlelɛ‑ 'bhi ‑la ba ‑gɛ.›» ");
INSERT INTO moa_vpl VALUES ("MT26_19","070_26_19","MAT","26","19","19","'Bhɛ yi 'tɛ, Zesu 'a ꞊pia ‑yaa' ‑klaŋlanɛ mu 'ɛ ni 'kaa ‑o ‑za 'la klɛ, ‑o 'bhɛɛ‑ ꞊kla. 'Bhɛɛ‑ ‑o ‑ja *Paki 'fɛti ta kpo 'ɛ klɛlɛ. ");
INSERT INTO moa_vpl VALUES ("MT26_20","070_26_20","MAT","26","20","20","Yromazi bhɔle, 'ke Zesu 'pegee ‑yaa' ‑klaŋlanɛ vu ta plɛ 'ɛ, ‑o pɛ 'ɛ 'bhlele‑ 'sanle. ");
INSERT INTO moa_vpl VALUES ("MT26_21","070_26_21","MAT","26","21","21","‑O ‑yaa pɛ 'ɛ 'bhle zii' 'waati 'la ba, 'ke Zesu 'a 'pele ‑o ni dɔɔ: «'Mi pe 'ka ni 'ŋ 'sɔwɛɛ‑ ma dɔɔ: 'Ka do nu 'ŋ 'lɛnalɛ mɛɛ mu ni.» ");
INSERT INTO moa_vpl VALUES ("MT26_22","070_26_22","MAT","26","22","22","'Bhɛ klɛlɛ 'tɛ, 'ke ‑yaa' ‑klaŋlanɛ mu 'ɛ ‑woo wlɛyisriwole 'egbɛnɛle, 'bhɛɛ‑ 'ke ‑wa ‑lrɔkpale 'sanle do do dɔɔ: «Mɛɛzan, 'mi ‑le 'kɛle‑ ɛɛ?» ");
INSERT INTO moa_vpl VALUES ("MT26_23","070_26_23","MAT","26","23","23","Zesu 'a zikpaa‑ ‑o ni dɔɔ: «'Ke mɛɛ 'la zan 'e gbɛ ꞊wlaa 'ŋ gbɛ 'ɛ ta pɛ ‑koo 'ɛ 'yi, 'bhɛ zan ‑le nu ‑dawli' 'kpalɛ‑ 'ŋ gbɛ ta, 'bhɛɛ‑ ‑yoo 'ŋ 'lɛna‑ mɛɛ mu ni. ");
INSERT INTO moa_vpl VALUES ("MT26_24","070_26_24","MAT","26","24","24","Bhaaplɛŋ Gbe 'ɛ nu galɛ 'bhii‑ ‑a yɔɔndɛle ‑o gɔnɛ‑ 'la gbɛɛn‑ ‑a ba zayi' ‑Waanbhaa a 'Sɛwɛ 'ɛ 'yi. 'Duŋ‑ mɛɛ 'la zan nu ‑dawli' 'kpalɛ‑ ‑a gbɛ ta, 'bhɛɛ‑ ‑ya ‑lɛna' mɛɛ mu ni, ‑klɔlɔɔ' ‑o 'bhɛ zan 'ɛ ma. 'Ke 'bhɛ zan laa ‑yaa ya bi 'bhɛ mabhaa ‑yaa nu bhɔlɛ 'bhɛ zan 'ɛ 'gbu ma.» ");
INSERT INTO moa_vpl VALUES ("MT26_25","070_26_25","MAT","26","25","25","'Bhɛ klɛle 'tɛ, Zudasi 'la 'bhɛ 'yaa‑ nu ‑dawli' 'kpalɛ‑ ‑a gbɛ ta, 'bhɛɛ ‑ya ‑lɛna' mɛɛ mu ni, 'bhɛ ‑jan 'ɛ 'sile‑ 'kee‑ Zesu 'lrɔkpale dɔɔ: «'O Daan mi, 'mi ‑le 'kɛle‑ ɛɛ?» ‑Ayile, 'ke Zesu 'a 'lɛkunle ‑a ni dɔɔ: «'E 'gbu 'yela‑ ꞊pia bhe.» ");
INSERT INTO moa_vpl VALUES ("MT26_26","070_26_26","MAT","26","26","26","‑O ‑yaa pɛbhle 'zi 'waati 'la ba, Zesu 'bluu do ꞊sia, 'bhɛɛ‑ ‑e ‑Waanbhaa' 'pubwa‑ 'bhɛ ma, 'bhɛɛ‑ ‑ya takaan‑ kplokplo. 'Bhɛ blaan, 'ke ‑ya 'kpale ‑yaa' ‑klaŋlanɛ mu 'ɛ 'kɔɔ, 'bhɛɛ‑ 'ke ‑ya pele‑ ‑o ni dɔɔ: «‑Ka 'bluu 'lɛɛ‑ 'si 'bhɛɛ‑ ‑kaa bhle, 'ŋ 'flɛ ‑le 'kɛle‑.» ");
INSERT INTO moa_vpl VALUES ("MT26_27","070_26_27","MAT","26","27","27","'Bhɛ blaan, 'kee‑ ‑drɔɔ 'paayan꞊ do 'sile, 'bhɛɛ‑ 'kee‑ ‑Waanbhaa' 'pubɔle 'bhɛ ma. 'Bhɛ blaan, 'ke ‑ya 'kpale ‑yaa' ‑klaŋlanɛ mu 'ɛ 'kɔɔ, 'bhɛɛ‑ 'ke ‑ya pele‑ ‑o ni dɔɔ: «'Ka 'kpɛn a 'ke 'mi do do. ");
INSERT INTO moa_vpl VALUES ("MT26_28","070_26_28","MAT","26","28","28","‑Amasrɔyi, 'kɛlɛɛ‑ 'ŋ yiɛn ‑le 'kɛle‑, ‑Waanbhaa' *‑bhoolaya drɛɛ 'la ‑dwa 'yee‑ 'gbu 'pegee bhaaplɛŋ mu 'pleŋ‑ 'bhɛ ma ‑tɔɔmasie yiɛn ‑le 'kɛle‑. 'Yee‑ yiɛn 'lɛɛ‑ 'klalaa‑ mɛɛ ‑bebe ‑la 'kaama‑, ‑waa' ‑za 'yɔɔ‑ mu 'ɛ ma 'sroma‑ 'yan zayi'. ");
INSERT INTO moa_vpl VALUES ("MT26_29","070_26_29","MAT","26","29","29","'Mi pe 'ka ni 'kee‑ 'san ‑zɔn ma, 'naa nu ‑drɔɔ 'lɛɛ‑ 'bhɛɛke 'milɛ‑ ‑li 'ka 'le, 'ke 'bhɛ ge 'tɛnlɛ‑ yi 'la ma 'ke 'mi 'pegee 'ka mu nu ‑a mi gbɛ drɛɛwolɛ 'ŋ Dɛ a ‑bhleŋgbeya ‑wa 'ɛ ta.» ");
INSERT INTO moa_vpl VALUES ("MT26_30","070_26_30","MAT","26","30","30","'Bhɛ blaan, Zesu 'pegee ‑yaa' ‑klaŋlanɛ mu 'ɛ ‑o ‑Waanbhaa' 'tɔbhɔ ma 'sro mu ꞊kpaa, 'bhɛɛ‑ ‑o ‑wlɛnle', 'ke ‑o gele‑ Olivi diiŋ vlɛ gɔɔn 'ɛ 'wiiŋ‑. ");
INSERT INTO moa_vpl VALUES ("MT26_31","070_26_31","MAT","26","31","31","Zesu pe ‑yaa' ‑klaŋlanɛ mu 'ɛ ni dɔɔ: «‑Zɔn ‑bi 'lɛɛ‑ zi, 'ka 'kpɛn nu 'kanlɛ‑ 'eke‑ ma, 'bhɛɛ‑ 'ka 'ŋ do ‑kplɛn to ‑a ꞊nɔɔ. ‑Amasrɔyi, ‑a yɔɔndɛle ‑o ‑Waanbhaa' 'a 'Sɛwɛ 'yi 'kaa: ‹'Ŋ nu ‑bhlaa gooba mi 'ɛ dɛlɛ, 'bhɛɛ‑ ‑bhlaa 'lɛdo‑ 'ɛ ‑o nu 'kanlɛ‑ 'eke‑ ma.› ");
INSERT INTO moa_vpl VALUES ("MT26_32","070_26_32","MAT","26","32","32","'Duŋ‑ 'ke 'ŋ ‑bwela gale ba 'waati 'la ba, 'ŋ nu 'kanlɛ‑ 'ka 'lɛɛ Galile 'klɛɛn 'ɛ 'yi.» ");
INSERT INTO moa_vpl VALUES ("MT26_33","070_26_33","MAT","26","33","33","'Bhɛ klɛle 'tɛ, 'ke Piɛri 'a 'pele ‑a ni dɔɔ: «'Ali‑ 'ke mɔkpɛn' ꞊kaan 'eke‑ ma, 'bhɛɛ‑ ‑woo 'e ꞊twa ‑a nɔɔ‑, 'mi 'laa nu 'e 'tolɛ‑ ‑a nɔɔ‑ ‑titi.» ");
INSERT INTO moa_vpl VALUES ("MT26_34","070_26_34","MAT","26","34","34","'Bhɛ 'yi 'tɛ, 'ke Zesu 'a zikpale 'yee Piɛri ni dɔɔ: «'Mi pe 'e ni 'ŋ 'sɔwɛɛ‑ ma dɔɔ: 'Sani‑ maagwlɛn ‑we bhla 'ɛ 'pleŋ‑ ‑bi 'gbu 'lɛɛ zi, 'e nu 'e 'lɛmadɔlɛ 'eglɔɔle gaan yaga 'mi ma 'kaa 'yaa 'mi dɔ.» ");
INSERT INTO moa_vpl VALUES ("MT26_35","070_26_35","MAT","26","35","35","'Bhɛ 'yi, Piɛri pe ‑a ni dɔɔ: «'Ali‑ 'ke ‑wa ꞊pia dɔɔ ‑woo 'mi 'pegee 'bhi dɛle‑ 'eke‑ zi, 'naa nu 'ŋ 'lɛmadɔlɛ 'eglɔɔle 'e ma ‑titi 'kaa 'naa 'e dɔ.» 'Bhɛ 'nɔɔ‑ bhe, Zesu a ‑klaŋlanɛ mu 'ɛ 'kpɛn 'a ꞊pia Piɛri a pɛ pegbɛya do 'ɛ 'bhɛɛ‑ gbɛɛn‑. ");
INSERT INTO moa_vpl VALUES ("MT26_36","070_26_36","MAT","26","36","36","'Bhɛ blaan, 'ke Zesu 'pegee ‑yaa' ‑klaŋlanɛ mu 'ɛ ‑o gele‑ yrɛ do nɔɔ‑, ‑o ‑yaa 'bhɛ yrɛ 'ɛ sii: Zɛtisemane. 'Bhɛɛ‑ ‑e pe ‑o ni dɔɔ: «‑Ka yala‑ ‑gɛ, 'ŋ gele‑ 'ŋ 'seriwolɛ laale ‑sɔ.» ");
INSERT INTO moa_vpl VALUES ("MT26_37","070_26_37","MAT","26","37","37","‑A ge bhla 'ɛ zi 'bhɛ ꞊nɔɔ, ‑e ‑ja Piɛri 'pegee Zebede gbe plɛ 'ɛ 'le ‑a zi. ‑Ya wlɛyisriwoa, 'bhɛɛ‑ ‑a blina‑ yiɛndwa‑. ");
INSERT INTO moa_vpl VALUES ("MT26_38","070_26_38","MAT","26","38","38","‑Ayile, 'ke ‑ya pele‑ ‑a madɔ mu 'ɛ ni 'tɛ dɔɔ: «'Ŋ 'blina‑ yiɛn ‑o 'klekle 'ke 'bhɛ ge 'tɛnlɛ‑ 'ŋ gale ma: ‑ka bo 'ŋ ‑din ‑gɛ 'bhɛɛ‑ ‑kɔɔ' bo ‑kɔɔ' 'yrɛ ma.» ");
INSERT INTO moa_vpl VALUES ("MT26_39","070_26_39","MAT","26","39","39","'Bhɛ 'klɛle‑ 'tɛ, ‑e gele ‑a ‑lɛɛ sa, ‑ya 'kpɔ ꞊zian, 'bhɛɛ‑ ya ŋgblo zinaa' ‑a ‑la, 'bhɛɛ‑ ‑ya 'seriwole ꞊saan ‑Waanbhaa' ni dɔɔ: «'Ŋ Dɛ, 'kee‑ sɔ ‑a klɛle‑ 'bhɛɛ‑ ‑yrɛn pɛyan‑ do 'la bhe ‑e kan 'ŋ ma 'egbɔɔnle, 'bhɛ klɛ! 'Bhɛɛ‑ 'duŋ‑, 'naa ‑o ‑a zi 'bhii‑ 'e 'mi zru maza klɛ, 'duŋ‑ 'e 'gbu zru maza ‑la klɛ.» ");
INSERT INTO moa_vpl VALUES ("MT26_40","070_26_40","MAT","26","40","40","'Bhɛ blaan, 'kee‑ nule‑ ‑yaa' ‑klaŋlanɛ yaga 'ɛ taglinlɛ, 'bhɛɛ‑ 'kee‑ bhɔle‑ ‑o ta 'ke ‑woo yi pla. ‑Ayile, 'ke ‑ya pele‑ Piɛri ni dɔɔ: «'Ka 'laa 'sɔlɛ‑ 'ke 'ka bo 'ka 'yrɛ ma 'waati sa ba 'mi 'le ɛɛ? ");
INSERT INTO moa_vpl VALUES ("MT26_41","070_26_41","MAT","26","41","41","‑Ka bo 'ka 'yrɛ ma, 'bhɛɛ‑ ‑ka 'ka 'seriwo, 'kooko‑ ‑Setran' 'laa nu 'ka yidanlɛ, 'bhɛɛ‑ ‑e 'ka balaa' ‑za 'yɔɔ‑ 'yi. Bhaaplɛŋ nii‑ 'ɛ ‑ya zi 'bhii‑ ‑e ‑za 'wlan ‑la klɛ, 'duŋ‑ 'bhɛ klɛ faŋgan‑ 'laa ‑o ‑a ta.» ");
INSERT INTO moa_vpl VALUES ("MT26_42","070_26_42","MAT","26","42","42","'Ezin‑, 'ke Zesu 'e 'pleŋgo‑ gbɛ plɛ mi wole‑ ‑o ma, 'bhɛɛ‑ 'ke ‑ya 'seriwole ‑Waanbhaa' ni dɔɔ: «'Ŋ Dɛ, 'kee‑ sɔ ‑a klɛle‑ 'bhɛɛ‑ ‑yrɛn pɛyan‑ do 'la bhe ‑e kan 'ŋ ma 'egbɔɔnle, 'bhɛɛ 'naa 'a mi! Bhaa 'e zru maza klɛ.» ");
INSERT INTO moa_vpl VALUES ("MT26_43","070_26_43","MAT","26","43","43","‑E ‑nwa 'ezin‑ pwɛlɛ ‑yaa ‑klaŋlanɛ mu 'ɛ ta, 'kee‑ bhɔle‑ ‑o ta 'ke ‑woo yi pla; ‑amasrɔyi yi 'ɛ gbiŋ 'ɛ 'kɔɔ ‑o ‑yrɛ ta, waa ‑yaa sɔ bole‑ ‑o ‑yrɛ ma. ");
INSERT INTO moa_vpl VALUES ("MT26_44","070_26_44","MAT","26","44","44","Zesu gole ‑o ‑din, 'kee‑ gele ‑a 'seriwo gbɛ gaan yaga mi 'ɛ klɛlɛ 'kee‑ bɔ 'yee ‑jan do 'kpɔ 'ɛ ta. ");
INSERT INTO moa_vpl VALUES ("MT26_45","070_26_45","MAT","26","45","45","'Bhɛ blaan, 'kee‑ nu gbɛ drɛɛwole ‑yaa ‑klaŋlanɛ mu 'ɛ ta, 'bhɛɛ‑ 'ke ‑ya pele‑ ‑o ni dɔɔ: «'Ka ‑o yidɛ 'zi ‑li ɛɛ, 'bhɛɛ‑ 'ka ‑o 'ka 'yitrɛ zi ɛɛ? ‑Ka 'ka 'yrɛkpa, 'ŋ 'kun 'waati 'ɛ ꞊bhwa 'e ‑din. 'Bhɛɛ‑ ‑o nu Bhaaplɛŋ Gbe 'ɛ 'lɛnalɛ ‑za 'yɔɔ‑ klɛ mu 'ɛ ni. ");
INSERT INTO moa_vpl VALUES ("MT26_46","070_26_46","MAT","26","46","46","‑Ka 'ka 'wlɛn‑, ‑kɔɔ' ge! ‑Ka 'ka 'yrɛkpa laale doo, mɛɛ 'la zan ‑o zan ‑dawli' 'kpalɛ‑ 'ŋ gbɛ ta, 'bhɛɛ‑ ‑ye 'ŋ 'lɛna ‑za 'yɔɔ‑ klɛ mu 'ɛ ni, 'yele‑ zan laale.» ");
INSERT INTO moa_vpl VALUES ("MT26_47","070_26_47","MAT","26","47","47","Zesu 'yaa‑ ‑janwo' zii' ‑li 'waati 'la ba, 'ke Zudasi, ‑yaa' ‑klaŋlanɛ vu ta plɛ 'ɛ do nule‑ 'ke ‑zamaa' 'srɛ do 'le ‑a zi. ‑Gɔkuŋ' mu 'pegee 'beni mu ‑yaa 'mu 'kɔɔ. 'Sraka 'lɛna ‑kuŋlii mu 'ɛ 'pegee Zuufu mu a 'gwlaan‑ gblaan mu 'ɛ 'mu ‑le ‑o winbwa‑. ");
INSERT INTO moa_vpl VALUES ("MT26_48","070_26_48","MAT","26","48","48","Zudasi 'la 'bhɛ 'yaa‑ nu ‑dawli' 'kpalɛ‑ Zesu gbɛ ta, 'bhɛ 'a 'kun ‑tɔɔmasie do ‑pia ‑a 'kun mu 'ɛ ni dɔɔ: «'Ke 'ŋ mɛɛ 'la zan 'pubwa‑ ‑a ‑tuubɔlele, 'yele‑ 'kɛle‑. ‑Kaa 'kun.» ");
INSERT INTO moa_vpl VALUES ("MT26_49","070_26_49","MAT","26","49","49","'Bhɛ klɛle 'tɛ, 'ke Zudasi 'nule blaale‑ Zesu ‑din, 'bhɛɛ‑ 'ke ‑ya pele‑ dɔɔ: «'E 'yia‑, 'o Daan mi!» 'Bhɛɛ‑ 'ke ‑ya ‑tuubɔle. ");
INSERT INTO moa_vpl VALUES ("MT26_50","070_26_50","MAT","26","50","50","'Bhɛ 'yi 'tɛ, 'ke Zesu 'a 'pele Zudasi ni dɔɔ: «'Ŋ 'bhɛgwlɛn‑, 'e ꞊nwa ‑za 'la klɛyrɛ nɔɔ‑ ‑a klɛ.» ‑Ayile, 'ke mɛɛ ‑vin mu 'ɛ ‑woo mabɛɛnle Zesu ‑din, 'ke ‑woo gbɛkpale 'a ta, 'bhɛɛ‑ 'ke ‑wa 'kunle. ");
INSERT INTO moa_vpl VALUES ("MT26_51","070_26_51","MAT","26","51","51","'Bhɛ klɛle 'tɛ, 'ke Zesu a ‑klaŋlanɛ mu 'ɛ do 'bhɛ a ‑gɔkuŋ' 'ɛ 'yrole 'bhɛ 'bhoo‑ 'yi, 'kee‑ 'sraka 'lɛna mu ‑kuŋlii gblaan 'ɛ 'bhɛ a yewonɛ 'ɛ do 'trɔn takanle. ");
INSERT INTO moa_vpl VALUES ("MT26_52","070_26_52","MAT","26","52","52","'Bhɛ ꞊nɔɔ bhe, 'ke Zesu 'a 'pele ‑yaa' ‑klaŋlanɛ 'ɛ ni dɔɔ: «'Yaa‑ ‑gɔkuŋ' 'ɛ ꞊wla ‑a ‑bhoo 'ɛ 'yi, ‑amasrɔyi 'ke mɛɛ 'la zan mu 'kpɛn ‑gɔkuŋ' ꞊sia mɛɛ 'kaama‑, ‑o nu 'bhɛ zan mu 'ɛ dɛlɛ 'ke ‑gɔkuŋ' ‑la ‑le. ");
INSERT INTO moa_vpl VALUES ("MT26_53","070_26_53","MAT","26","53","53","'Yaa 'yaango‑ 'bhii‑ 'ŋ sɔ a pele‑ 'ŋ Dɛ ni ‑e nu 'bhɔ 'ŋ ba, 'bhɛɛ‑ ‑e sɔ ‑mlɛkɛ' ‑srwase' ‑lɛdulayrɛ vu ta plɛ ‑gbɛnɛ 'kpale 'ŋ ni 'saanibhe ɛɛ? ");
INSERT INTO moa_vpl VALUES ("MT26_54","070_26_54","MAT","26","54","54","'Duŋ‑ 'ke 'ŋ 'bhɛ ꞊kla, ‑za mu 'la yɔɔndɛle ‑lɛdulale ‑o ‑Waanbhaa' a 'Sɛwɛ 'ɛ 'yi 'kaa 'mu nu klɛlɛ, 'mu 'lɛ nu 'sɔlɛ‑ 'nale‑ ‑a ma ɛɛ?» ");
INSERT INTO moa_vpl VALUES ("MT26_55","070_26_55","MAT","26","55","55","'Bhɛ blaan, 'ke Zesu 'a 'pele ‑zamaa' 'ɛ ni dɔɔ: «‑Faannii' ‑le 'ŋ 'le ɛɛ 'bhɛɛ‑ 'ka ꞊nwa 'ŋ 'kunyrɛ‑ nɔɔ‑ ‑gɔkuŋ' mu 'pegee 'beni mu 'le 'ka 'kɔɔ ɛɛ? Yi 'oo yi, 'ŋ 'yaa‑ mɛɛ mu daan ‑Waanbhaa' Gba 'Fɛ ‑Gbɛnɛ 'ɛ ꞊la, 'bhɛɛ‑ 'ka 'laa 'ŋ 'kunlɛ‑. ");
INSERT INTO moa_vpl VALUES ("MT26_56","070_26_56","MAT","26","56","56","'Duŋ‑ ‑Waanbhaa' ‑lɛla' janwo mu 'ɛ 'wojan‑ mu 'la yɔɔndɛle ‑o 'yee‑ ‑Waanbhaa' a 'Sɛwɛ 'ɛ 'yi, ‑za mu 'lɛɛ‑ 'kpɛn ꞊kla 'mu ‑la ‑lɛsɔ' zayi' ‑zɔn.» 'Bhɛ yrɛ do 'ɛ ꞊nɔɔ bhe, 'ke ‑yaa' ‑klaŋlanɛ mu 'ɛ 'kpɛn 'kanle 'eke‑ ma, 'bhɛɛ‑ 'ke ‑wa do ‑kplɛn 'tole 'a nɔɔ‑ mɛɛ mu 'ɛ 'kɔɔ. ");
INSERT INTO moa_vpl VALUES ("MT26_57","070_26_57","MAT","26","57","57","Zesu 'kun mu 'ɛ ‑ja 'kɛle‑ ‑waa' 'sraka 'lɛna mu ‑kuŋlii gblaan Kaifu ba. 'Toŋ daan mu 'ɛ 'pegee 'gwlaan‑ gblaan mu 'ɛ 'kpɛn 'lɛkpale ‑yaa 'eke‑ ta 'yee‑ Kaifu ba ‑lɛ ma. ");
INSERT INTO moa_vpl VALUES ("MT26_58","070_26_58","MAT","26","58","58","‑O ge bhla 'ɛ zi Zesu 'le 'bhɛ ꞊nɔɔ, Piɛri ‑yaa zan ‑o ‑zanta' 'egbɔɔnle. ‑E ‑wlaa ‑gbeŋ 'ɛ 'yi, 'bhɛɛ‑ 'kee‑ yaale' 'fɛ gooba mu 'ɛ ‑din, 'kooko‑ ‑za 'ɛ 'lɛyanle gɔnɛ‑ 'la gbɛɛn‑ ‑e 'bhɛ ye. ");
INSERT INTO moa_vpl VALUES ("MT26_59","070_26_59","MAT","26","59","59","'Sraka 'lɛna mu ‑kuŋlii mu 'ɛ 'pegee ‑waa' 'seri ta za 'kitikan mɛɛ gblaan ‑lɛdo' 'ɛ 'kpɛn 'yaa‑ bhla 'kpayrɛ‑ ‑glin 'zi Zesu ma, 'kooko‑ 'ke ‑kpan 'ɛ balaa' ‑a ta, 'bhɛɛ‑ ‑wa dɛ. ");
INSERT INTO moa_vpl VALUES ("MT26_60","070_26_60","MAT","26","60","60","Bhla ma mɛɛ ‑bebe ꞊nwa 'mu zijanwolɛ ‑a 'kaama‑, 'duŋ‑ 'woo‑ Zuufu mu a 'seri ta za 'kitikan mu 'ɛ waa ‑jan 'kedo‑ 'kpɔ 'yelɛ‑ 'ke 'bhɛ klɛ ‑a dɛ win 'le. ‑O 'kpɛn 'kanle‑ blaan, 'ke mɛɛ plɛ nule‑ ‑a pelɛ dɔɔ: ");
INSERT INTO moa_vpl VALUES ("MT26_61","070_26_61","MAT","26","61","61","«Mɛɛ 'lɛɛ‑ ‑ya ‑pia dɔɔ ‑e sɔ ‑Waanbhaa' Gba 'Fɛ ‑Gbɛnɛ 'ɛ 'wile‑ 'bhɛɛ‑ ‑ya dɔ gbɛ drɛɛwo ‑yrekpaa' yaga ‑la.» ");
INSERT INTO moa_vpl VALUES ("MT26_62","070_26_62","MAT","26","62","62","'Bhɛ klɛle 'tɛ, 'ke 'sraka 'lɛna ‑kuŋlii gblaan 'ɛ ‑ya ‑wlɛnle', 'bhɛɛ‑ 'kee‑ Zesu 'lrɔkpale dɔɔ: «Mɛɛ mu 'ɛ ‑woo ‑jan mu 'la 'kpɛn 'wo zii' 'e ma 'bhi pe 'nale‑ ɛɛ?» ");
INSERT INTO moa_vpl VALUES ("MT26_63","070_26_63","MAT","26","63","63","'Bhɛ 'yi 'tɛ, 'ke Zesu tagale bole‑. ‑Ayile, 'ke *'sraka 'lɛna ‑kuŋlii gblaan 'ɛ ‑ya pele‑ ‑a ni dɔɔ: «'Kee‑ kpa 'mi 'pegee ‑Waanbhaa' 'la ‑ya ‑yrɛ ma 'bhɛ ta, 'mi ‑o 'e 'lrɔkpa zii' 'kaa 'ya pe 'o ni kpataakpa 'ke 'bhi ‑le 'ke Mɛɛ ‑Bhee Mi ‑Kpɔsɔɔ Krisi 'ɛ 'le 'bhɛ 'pegee 'ke 'bhi ‑le ‑Waanbhaa' Gbe 'ɛ 'le.» ");
INSERT INTO moa_vpl VALUES ("MT26_64","070_26_64","MAT","26","64","64","Zesu pe ‑a ni dɔɔ: «'Yele‑ ꞊daa 'e 'gbu 'lii bhe. 'Mi 'duŋ‑ pe 'ka ni 'ezin‑ dɔɔ 'kee‑ 'san ‑zɔn ma, 'ka nu Bhaaplɛŋ Gbe 'ɛ 'yaale‑ yelɛ ‑Waanbhaa' ‑glɔɔ 'ɛ ‑din 'tɔbhɔ ma yaayrɛ 'ɛ ꞊nɔɔ. 'Bhɛɛ‑ 'ka nu ‑a yelɛ ‑a nuyrɛ nɔɔ‑ laflɛ' ‑gblɛn mu 'ɛ 'yi mu 'ɛ ta, 'kee‑ da laflɛ' 'yi.» ");
INSERT INTO moa_vpl VALUES ("MT26_65","070_26_65","MAT","26","65","65","'Bhɛ ꞊nɔɔ bhe, 'ke 'sraka 'lɛna ‑kuŋlii gblaan 'ɛ ‑ya 'gbu ta dunɛ‑ 'ɛ 'peedɛle, 'bhɛɛ‑ 'ke ‑ya pele‑ dɔɔ: «‑E ‑Waanbhaa' 'tɔsiɛla! ‑Kɔɔ' maza ‑o ‑li mɛɛ ‑bhɛɛke' 'srɛya‑ klɛle ma ɛɛ? ‑E ‑yaan ‑Waanbhaa' 'tɔsiɛ ma jan 'la 'wolele bhe, 'ka 'laa 'bhɛ 'malɛ‑ ɛɛ? 'Ka mu pe 'bhɛ 'yi 'nale‑ ɛɛ?» ");
INSERT INTO moa_vpl VALUES ("MT26_66","070_26_66","MAT","26","66","66","'Bhɛɛ‑ ‑o 'kpɛn 'bhɛ 'lɛkwan‑ 'eke‑ zi dɔɔ: «‑Yoo 'ke dɛ pɛ 'le.» ");
INSERT INTO moa_vpl VALUES ("MT26_67","070_26_67","MAT","26","67","67","'Bhɛ ꞊nɔɔ bhe, 'ke ‑woo ‑liile' mu 'klale ‑a wlɛyi', 'bhɛɛ‑ 'ke ‑wa zɔnle‑ ‑o gbɛkpuŋ‑ mu 'ɛ 'le. ‑A 'ke mu ‑yaa ‑a 'trɔn zɔn 'zi 'ke ‑wa ‑lrɔkpa' dɔɔ: ");
INSERT INTO moa_vpl VALUES ("MT26_68","070_26_68","MAT","26","68","68","«Mɛɛ ‑Bhee Mi ‑Kpɔsɔɔ Krisi, 'e 'kpee ma ‑de 'gbu ‑le 'e ꞊zwan ɛɛ?» ");
INSERT INTO moa_vpl VALUES ("MT26_69","070_26_69","MAT","26","69","69","'Bhɛ ‑za mu 'ɛ klɛ 'waati 'ɛ ba, Piɛri 'yaale‑ ‑yaa 'pɛɛlii‑ *'sraka 'lɛna ‑kuŋlii gblaan 'ɛ 'bhɛ a ‑gbeŋ 'ɛ 'yi. ‑Ayile, 'ke 'bhɛ a 'fɛ 'ɛ ꞊la yewo le 'ɛ do 'e 'mabɛɛnle 'yee‑ Piɛri ‑din, 'bhɛɛ‑ 'ke 'bhɛ 'a 'lrɔkpale dɔɔ: «'Bhi 'gbu 'lɛɛ‑, 'e 'yaa‑ 'yee‑ Galile 'klɛɛn 'ɛ 'yi mi Zesu 'ɛ zi.» ");
INSERT INTO moa_vpl VALUES ("MT26_70","070_26_70","MAT","26","70","70","'Duŋ‑, Piɛri 'e 'lɛmadwa 'eglɔɔle 'bhɛ ma mɔkpɛn 'yrɛ ma, 'bhɛɛ‑ 'ke ‑ya pele‑ dɔɔ: «'Yoo‑ ‑we 'zi mɛɛ 'la zan 'le bhe, 'naa 'bhɛ dɔ.» ");
INSERT INTO moa_vpl VALUES ("MT26_71","070_26_71","MAT","26","71","71","'Bhɛ klɛle 'tɛ, 'ke 'yee‑ Piɛri gele 'sanle ‑gbeŋ 'ɛ 'lii ba ‑yrɛta', 'bhɛɛ‑ 'ke 'bhɛ 'fɛ 'ɛ ꞊la yewo le ‑bhɛɛke' do 'a 'yele. 'Bhɛɛ‑ 'ke 'bhɛ 'a 'pele 'bhɛ ‑din mu 'ɛ ni dɔɔ: «Mɛɛ 'lɛɛ‑ 'yaa‑ 'yee‑ Nazarɛti mi Zesu 'ɛ zi.» ");
INSERT INTO moa_vpl VALUES ("MT26_72","070_26_72","MAT","26","72","72","'Bhɛ ꞊nɔɔ bhe 'ezin‑, 'ke Piɛri 'a 'lɛmadɔle 'eglɔɔle 'bhɛ ‑jan 'ɛ ta, 'kee‑ bhaa bhlele‑ dɔɔ: «'Mi 'pegee 'ŋ 'sɔwɛɛ‑ 'gbu 'ɛ ta, 'naa 'yee‑ mɛɛ 'la bhe ‑a dɔ.» ");
INSERT INTO moa_vpl VALUES ("MT26_73","070_26_73","MAT","26","73","73","'Bhɛ blaan 'waati sa, 'ke 'fɛ ‑gbeŋ 'yi mu 'ɛ ‑woo mabɛɛnle Piɛri ‑din, 'bhɛɛ‑ 'ke ‑wa pele‑ ‑a ni dɔɔ: «Wlan 'gbu 'ɛ ni, 'yoo‑ 'ke Zesu zi mu 'ɛ do 'le. ‑Amasrɔyi 'woo‑ 'e dɔ 'yaa‑ ‑janwo' gbɛya 'bhɛɛ‑ ma.» ");
INSERT INTO moa_vpl VALUES ("MT26_74","070_26_74","MAT","26","74","74","'Bhɛ klɛle 'tɛ, 'ke Piɛri bhaa bhlele 'sanle, 'ke ‑ya pe dɔɔ: «'Ke 'ŋ bhla ꞊pia, bhaa 'ŋ ga. 'Naa 'yee‑ mɛɛ 'la bhe ‑a dɔ 'sekeseke!» 'Bhɛ 'waati do 'kpɔ 'ɛ ba, 'ke maagwlɛn ‑wele'. ");
INSERT INTO moa_vpl VALUES ("MT26_75","070_26_75","MAT","26","75","75","'Bhɛ klɛle 'tɛ, Zesu ‑jan 'la ꞊woa 'yee‑ Piɛri ni 'elwale gban ‑sɔ, 'ke 'bhɛ dɔle‑ ‑a 'kpee, Zesu 'a ꞊pia ‑a ni dɔɔ: «'Sani‑ maagwlɛn ‑weli' pleŋ‑ ‑zɔn, 'e nu 'e 'lɛmadɔlɛ 'eglɔɔle 'mi ma gaan yaga 'kaa 'yaa 'mi dɔ.» Piɛri 'pwɛle‑ 'pɛɛlii‑, 'kee‑ wisile 'ebebele. ");
INSERT INTO moa_vpl VALUES ("MT27_1","070_27_1","MAT","27","1","1","Zrwan 'ɛ zi, 'ke 'sraka 'lɛna ‑kuŋlii mu 'ɛ 'pegee Zuufu mu 'ɛ ‑waa' 'gwlaan‑ gblaan mu 'ɛ ‑woo ‑lɛkpale 'eke‑ ta, 'bhɛɛ‑ 'ke ‑o 'kpɛn 'a 'kpale do ma 'kaa ‑o Zesu dɛ. ");
INSERT INTO moa_vpl VALUES ("MT27_2","070_27_2","MAT","27","2","2","‑Ayile, 'ke ‑wa gbɛ ta ‑yrele', 'bhɛɛ‑ 'ke ‑o gele‑ 'kɛle‑ ‑janmatii Pilati ba. ");
INSERT INTO moa_vpl VALUES ("MT27_3","070_27_3","MAT","27","3","3","Zudasi 'la ‑dawli' ꞊kpaa Zesu gbɛ ta, 'bhɛɛ‑ ‑ya ‑lɛnaa mɛɛ mu 'ɛ ni, 'a 'yele‑ 'bhii‑ ‑o ‑kpan ‑balaa' Zesu ta 'kaa ‑wa dɛ, 'ke ‑zadɔwɛɛ dɔle‑ ‑a ma. ‑Ayile, 'kee‑ gele‑ ‑gɔli' 'taŋbha mia do bhɛ vu 'ɛ 'niinalɛ *'sraka 'lɛna ‑kuŋlii mu 'ɛ 'pegee Zuufu mu 'ɛ ‑waa' 'gwlaan‑ gblaan mu 'ɛ ma. ");
INSERT INTO moa_vpl VALUES ("MT27_4","070_27_4","MAT","27","4","4","‑Ya ꞊pia ‑o ni dɔɔ: «'Ŋ ‑za 'yɔɔ‑ ‑kla mɛɛ 'la zan laa ‑za 'yɔɔ‑ do 'kpɔ klɛlɛ 'bhɛ 'lɛnalele 'ka ni!» ‑Ayile, 'ke ‑wa ‑lɛkunle ‑a ni dɔɔ: «'O mɔɔ a za 'laa ‑o 'bhɛ 'yi, 'e 'gbu a ‑za ‑le 'bhɛ 'le.» ");
INSERT INTO moa_vpl VALUES ("MT27_5","070_27_5","MAT","27","5","5","'Bhɛ klɛle 'tɛ, 'ke Zudasi ‑gɔli' 'taŋbha mu 'ɛ 'wianle 'trɛ ma ‑Waanbhaa' Gba 'Fɛ ‑Gbɛnɛ 'ɛ ꞊la, 'bhɛɛ‑ 'kee‑ 'pwɛle. 'Bhɛ blaan, 'kee‑ gele‑ ‑a 'gbu duŋlɛ ‑yri diiŋ do 'yi. ");
INSERT INTO moa_vpl VALUES ("MT27_6","070_27_6","MAT","27","6","6","'Bhɛ 'yi bhe, 'ke 'sraka 'lɛna ‑kuŋlii mu 'ɛ ‑o ‑gɔli' 'taŋbha mu 'ɛ 'wloole 'trɛ ma, 'bhɛɛ‑ 'ke ‑wa pele‑ dɔɔ: «'Waa‑ 'toŋ 'ɛ ta, 'waa sɔ ‑gɔli' 'lɛɛ‑ bɔle‑ ‑Waanbhaa' Gba 'Fɛ ‑Gbɛnɛ 'ɛ ꞊la ‑gɔli' bɔ ‑koo 'ɛ 'yi, ‑amasrɔyi mɛɛ yiɛn ma ‑gɔli' ‑le.» ");
INSERT INTO moa_vpl VALUES ("MT27_7","070_27_7","MAT","27","7","7","‑O yanle 'a 'kpalele do ma, 'ke ‑wa pele‑ dɔɔ ‑o gbɔdɔ mi 'ɛ 'bhɛ a 'trɛ 'ɛ 'lɔle 'yee‑ ‑gɔli' 'ɛ 'le, 'bhɛɛ‑ ‑o 'bhɛ 'trɛ 'ɛ klɛ 'cie mu binyrɛ 'le. ");
INSERT INTO moa_vpl VALUES ("MT27_8","070_27_8","MAT","27","8","8","'Bhɛla‑ ‑zayile, 'kee‑ 'san 'bhɛ yi 'ɛ ma, 'kee‑ nu 'tɛnlɛ‑ ‑zɔn ma, ‑o 'bhɛ 'trɛ 'ɛ sii dɔɔ: «Yiɛn ma 'trɛ.» ");
INSERT INTO moa_vpl VALUES ("MT27_9","070_27_9","MAT","27","9","9","'Bhɛ klɛgbɛya 'ɛ 'yi, ‑Waanbhaa' ‑lɛla' janwo mi Zeremi jan mu 'la ꞊woa 'elwale ‑sɔ 'mu 'lɛswa꞊, ‑ya ‑pia dɔɔ: «‑O ‑gɔli' 'taŋbha mia do bhɛ vu ꞊sia. Izraɛli mu 'ɛ ‑wa 'plɛɛ ꞊kaan 'bhɛɛ‑ ‑gɔli' 'lii yɛkɛ‑ 'ɛ 'le. ");
INSERT INTO moa_vpl VALUES ("MT27_10","070_27_10","MAT","27","10","10","'Bhɛɛ‑ ‑o gbɔdɔ mi 'ɛ ‑yaa' 'trɛ 'ɛ ꞊lwa 'ke 'bhɛ ‑gɔli' 'ɛ 'le, 'bhii‑ Mɛɛzan 'a ꞊pia 'mi ni pe gbɛya 'la yi.» ");
INSERT INTO moa_vpl VALUES ("MT27_11","070_27_11","MAT","27","11","11","Mɛɛ mu 'ɛ ‑o ‑ja Zesu 'le ‑janmatii Pilati ba. 'Bhɛɛ‑ ‑janmatii Pilati 'a 'lrɔkpaa dɔɔ: «'Bhi ‑le 'ke Zuufu mu 'ɛ ‑waa' ‑bhleŋgbe 'ɛ 'le ɛɛ?» Zesu pe ‑a ni dɔɔ: «'E 'gbu 'yela‑ ꞊pia bhe.» ");
INSERT INTO moa_vpl VALUES ("MT27_12","070_27_12","MAT","27","12","12","'Bhɛ blaan, 'sraka 'lɛna ‑kuŋlii mu 'ɛ 'pegee 'gwlaan‑ gblaan mu 'ɛ ‑o bhla ‑bebe ꞊kpaa ‑a ma, 'duŋ‑ yaa 'mu 'kedo‑ 'kpɔ mabɔlɛ. ");
INSERT INTO moa_vpl VALUES ("MT27_13","070_27_13","MAT","27","13","13","'Bhɛ klɛle 'tɛ, 'ke Pilati 'a 'pele 'a ni dɔɔ: «‑O bhla mu 'la 'kpɛn 'kpa zii' 'e ma bhe 'e 'trɔn 'laa 'mu 'yi ɛɛ?» ");
INSERT INTO moa_vpl VALUES ("MT27_14","070_27_14","MAT","27","14","14","'Duŋ‑ Zesu 'laa 'mu 'kedo‑ 'kpɔ zilakpalɛ ‑a ni bhe, 'bhɛ 'a 'kpeelɛnia ‑a ma 'egbɛnɛle. ");
INSERT INTO moa_vpl VALUES ("MT27_15","070_27_15","MAT","27","15","15","Lɛɛ 'oo lɛɛ, Paki 'fɛti 'ɛ ta, ‑janmatii Pilati ta pɛ ‑le ‑yaa 'ke 'ploolele ‑kaso yi mi do ma, 'kɛla 'ke ‑zamaa' 'ɛ 'yaa‑ 'bhɛ ‑za pe, ‑e 'yaa‑ ploo 'bhɛɛ‑ ma ‑o ni. ");
INSERT INTO moa_vpl VALUES ("MT27_16","070_27_16","MAT","27","16","16","'Bhɛ 'waati 'ɛ ba, ‑waa' ‑kaso 'yi mi do ‑yaa, ‑o ‑yaa 'bhɛ sii Barabasi. Mɔkpɛn' 'yaa‑ 'bhɛ dɔ 'bhɛ klɛza ‑yɔɔ' mu 'ɛ ma. ");
INSERT INTO moa_vpl VALUES ("MT27_17","070_27_17","MAT","27","17","17","Pilati ‑zamaa' 'ɛ 'lrɔkpaa‑ dɔɔ: «'Kaa‑ zi 'bhii‑ 'ŋ 'ploo‑ 'ka ni 'woo‑ mɛɛ plɛ 'ɛ ‑dela ma ɛɛ, Barabasi taa‑ Zesu, ‑o 'bhɛ 'la sii Mɛɛ ‑Bhee mi ‑Kpɔsɔɔ Krisi ɛɛ?» ");
INSERT INTO moa_vpl VALUES ("MT27_18","070_27_18","MAT","27","18","18","'Yee‑ Pilati 'gbu 'yaa‑ 'yaango‑ dɔɔ mɛɛ mu 'ɛ 'yaa‑ zranlawo zii' Zesu ma, 'bhɛla‑ ‑zayile ‑o ꞊nwa 'bhɛ ‑lɛnalɛ ‑a ni. ");
INSERT INTO moa_vpl VALUES ("MT27_19","070_27_19","MAT","27","19","19","'Duŋ‑ Pilati 'yaale‑ ‑yaa 'waati 'la ba 'kitikanyrɛ 'ɛ ꞊nɔɔ, 'ke ‑a na mɛɛ do winbɔle ‑a ta 'kaa 'bhɛ ge ‑jan 'lɛɛ‑ 'yikla 'a ‑kɔɔ dɔɔ: «Mɛɛ 'la bhe, yaa ‑za 'yɔɔ‑ do 'kpɔ klɛlɛ, 'bhɛla‑ ‑zayile 'yaa ‑za 'yɔɔ‑ do 'kpɔ klɛlɛ ‑a ni, ‑amasrɔyi 'ŋ ‑yrɛn ‑bebe ‑bhla ‑a ‑zayi' ‑zɔn gbiŋ na.» ");
INSERT INTO moa_vpl VALUES ("MT27_20","070_27_20","MAT","27","20","20","'Bhɛ bhla 'ɛ ba, 'sraka 'lɛna mu ‑kuŋlii mu 'ɛ 'pegee 'gwlaan‑ gblaan mu 'ɛ 'yaa‑ wla 'zi ‑zamaa' 'ɛ zi dɔɔ ‑wa pe Pilati ni dɔɔ 'bhɛ 'ploo‑ Barabasi ‑la ma, 'bhɛɛ‑ ‑ya pe ‑o Zesu dɛ. ");
INSERT INTO moa_vpl VALUES ("MT27_21","070_27_21","MAT","27","21","21","'Bhɛ 'yi 'tɛ, 'ke ‑janmatii Pilati ‑o ‑lrɔkpa' gbɛ drɛɛwole 'ezin‑ dɔɔ: «'Kaa‑ zi 'bhii‑ 'ŋ 'ploo‑ 'woo‑ mɛɛ plɛ 'ɛ ‑dela ma 'ka ni?» ‑O 'kpɛn 'a 'lɛkwan‑ ‑a ni dɔɔ: «Barabasi!» ");
INSERT INTO moa_vpl VALUES ("MT27_22","070_27_22","MAT","27","22","22","'Bhɛɛ‑ Pilati ‑o ‑lrɔkpaa 'ezin‑ dɔɔ: «'Ŋ nu ‑mɛ za ‑la klɛlɛ Zesu 'la 'ka 'bhɛ sii Mɛɛ ‑Bhee Mi ‑Kpɔsɔɔ Krisi 'bhɛ ni ɛɛ?» ‑O 'kpɛn 'a 'lɛkwan‑ dɔɔ: «‑Kaa gbaan ‑yrigbɛɛle 'ɛ ta, 'bhɛɛ‑ ‑e ga!» ");
INSERT INTO moa_vpl VALUES ("MT27_23","070_27_23","MAT","27","23","23","Pilati ‑o ‑lrɔkpaa 'ezin‑ dɔɔ: «‑E ‑mɛ ‑za 'yɔɔ‑ ‑la kla ɛɛ?» 'Duŋ‑ ‑o ‑gbekaan 'ezin‑ 'eglɔɔle 'kaa: «‑Kaa gbaan ‑yrigbɛɛle 'ɛ ta, 'bhɛɛ‑ ‑e ga!» ");
INSERT INTO moa_vpl VALUES ("MT27_24","070_27_24","MAT","27","24","24","'Yee‑ Pilati 'a 'yele‑ 'bhii‑ yaa ‑yaa sɔ ‑za 'kedo‑ 'kpɔ klɛlɛ 'ezin‑, 'bhɛ 'pegee mɛɛ mu 'ɛ zru baan' 'yaa‑ ‑wlɛn 'zi, 'kee‑ ‑yi 'sile, 'ke ‑ya gbɛ mafɛle mɔkpɛn' 'yrɛ ma, 'bhɛɛ‑ 'ke ‑ya pele‑ dɔɔ: «'Mi 'naa ‑o 'ŋ gaan bɔle‑ mɛɛ ‑lɛdɔɔle 'lɛɛ‑ ‑a dɛza 'ɛ 'yi! 'Ka 'gbu 'kɔɔ za ‑le!» ");
INSERT INTO moa_vpl VALUES ("MT27_25","070_27_25","MAT","27","25","25","'Bhɛ klɛle 'tɛ, 'ke ‑o 'kpɛn 'a 'lɛkunle 'eke‑ zi dɔɔ: «'Kee‑ ‑gaa oo, bhaa ‑a gale ‑kpan 'ɛ bala‑ 'o mɔɔ 'pegee 'o 'nɛ mu 'ɛ ta!» ");
INSERT INTO moa_vpl VALUES ("MT27_26","070_27_26","MAT","27","26","26","'Bhɛ klɛgbɛya 'ɛ 'yi, 'ke Pilati 'ploole Barabasi ma ‑o ni; 'bhɛɛ‑ ‑e pe mɛɛ mu ni 'kaa 'mu Zesu zita zɔn 'ke gbaŋbhlɛ 'le; 'bhɛ blaan, 'ke ‑ya 'kpale ‑o 'kɔɔ 'kaa ‑o ge ‑a gbaan ‑yrigbɛɛle do ta. ");
INSERT INTO moa_vpl VALUES ("MT27_27","070_27_27","MAT","27","27","27","‑Janmatii Pilati a ‑srwase' mu 'ɛ ‑ja Zesu 'le ‑yaa 'fɛkpee yrɛ 'la mɛɛ mu kla 'eke‑ ba a ꞊nɔɔ 'bhɛɛ‑ ꞊la; 'bhɛɛ‑ 'ke ‑srwase' 'lɛ ‑gbɛnɛ do 'ɛ 'kpɛn 'yaale ‑a zi. ");
INSERT INTO moa_vpl VALUES ("MT27_28","070_27_28","MAT","27","28","28","‑O Zesu tapɛ mu 'ɛ ‑gwa, 'ke ‑o dunɛ‑ tralapɛ 'tɛn gbɔɔn do 'klale ‑a ta. ");
INSERT INTO moa_vpl VALUES ("MT27_29","070_27_29","MAT","27","29","29","'Bhɛ blaan, 'ke ‑o lɛrɛ zuŋgbhlɛ do 'tanle 'bhii‑ ‑bhleŋgbe ŋgblo ma ‑can 'faa do gbɛɛn‑, 'ke ‑o 'bhɛ bɔle‑ ‑a ŋgblo 'ɛ ma. 'Bhɛ trala, 'ke ‑o togɔ do 'kpale ‑a gbɛ ‑yiɛ' 'lii 'bhii‑ ‑bhleŋgbe do 'kɔɔ 'beni do gbɛɛn‑; 'bhɛɛ‑ 'ke ‑woo 'kpɔ zɛnle‑ ‑a ‑lɛɛ, 'ke ‑o 'sɔnsi‑ 'a ma, 'bhɛɛ‑ 'ke ‑wa pe ‑a ni dɔɔ: «'E 'yia‑, Zuufu mu a ‑bhleŋgbe!» ");
INSERT INTO moa_vpl VALUES ("MT27_30","070_27_30","MAT","27","30","30","‑Woo ‑liile' mu ꞊klaa ‑a ta, 'bhɛɛ‑ ‑wa 'kɔɔ togɔ 'ɛ ꞊sia, 'ke ‑wa zɔn ‑a 'wiiŋ‑ 'bhɛ 'le. ");
INSERT INTO moa_vpl VALUES ("MT27_31","070_27_31","MAT","27","31","31","‑O yanle 'sɔnsile 'le ‑a ma, 'ke ‑o dunɛ‑ tralapɛ 'tɛn gbɔɔn 'ɛ gole‑ ‑a ta, 'bhɛɛ‑ 'ke ‑wa tapɛ ‑lwa mu 'ɛ 'klale ‑a ta. 'Bhɛ blaan, 'ke ‑o gele‑ ‑a gbaanlɛ ‑yrigbɛɛle 'ɛ ta. ");
INSERT INTO moa_vpl VALUES ("MT27_32","070_27_32","MAT","27","32","32","‑Srwase' mu 'ɛ 'pwɛ bhla 'ɛ zi ‑janmatii 'ɛ ‑yaa' 'fɛ 'ɛ ꞊la Zesu 'le, 'ke ‑o ‑lɛpale Sirɛni ‑wa 'ɛ ta mɛɛ do 'le, ‑o ‑yaa 'bhɛ sii Simɔ. 'Bhɛ klɛle 'tɛ, 'ke ‑srwase' mu 'ɛ ‑wa pele‑ 'bhɛ Simɔ 'ɛ ni 'kaa 'bhɛ Zesu gbaan ‑yrigbɛɛle 'ɛ 'si kpaŋma. ");
INSERT INTO moa_vpl VALUES ("MT27_33","070_27_33","MAT","27","33","33","‑O bhɔle yrɛ 'la ‑o 'bhɛ sii Gɔligota ('bhɛ 'yi ‑le dɔɔ mɛɛ ŋgblo bhɛlɛ' yrɛ), ");
INSERT INTO moa_vpl VALUES ("MT27_34","070_27_34","MAT","27","34","34","'ke ‑o ‑laanɛ' 'yi yiɛnle do 'pegee ‑drɔɔ 'yizaale, 'bhɛɛ‑ 'ke ‑o 'bhɛ 'nale 'a ni, ('kooko‑ 'kee‑ 'bhɛ ꞊mia, yaa ga 'ɛ 'lale‑ tadɔ). 'Duŋ‑ ‑e 'bhɛ ‑yi 'ɛ danle ‑a nrɛ ma, yaa dɔlɛ 'bhɛ 'mile‑ ‑la. ");
INSERT INTO moa_vpl VALUES ("MT27_35","070_27_35","MAT","27","35","35","'Bhɛ blaan, 'ke ‑wa gbaanle‑ ‑yrigbɛɛle 'ɛ ta, 'ke ‑o 'tete dɔle‑ ‑a tapɛ mu 'ɛ ta, 'bhɛɛ‑ 'ke ‑o 'mu ‑yiciɛnle 'eke‑ ma. 'Bhɛ klɛgbɛya 'ɛ 'yi bhe, ‑Waanbhaa' ‑lɛla' janwo mi 'ɛ 'wojan‑ 'ɛ 'lɛswa꞊, 'bhɛ 'a ꞊pia dɔɔ: «‑O 'tete ‑dwa 'ŋ tapɛ mu 'ɛ ta, 'bhɛɛ‑ ‑woo ‑yiciɛnna 'eke‑ ma.» ");
INSERT INTO moa_vpl VALUES ("MT27_36","070_27_36","MAT","27","36","36","'Bhɛ blaan, 'ke ‑o ‑yaale' ‑a gooba 'bhɛ yrɛ 'ɛ ꞊nɔɔ ye. ");
INSERT INTO moa_vpl VALUES ("MT27_37","070_27_37","MAT","27","37","37","‑Wa ꞊dia win 'la ma bhe, ‑o 'bhɛ ‑yɔɔndia ‑yripeenɛ do ta, 'bhɛɛ‑ ‑o 'bhɛ ‑gbaanna ‑a ŋgblo 'ɛ tralayrɛ 'ɛ ꞊nɔɔ, 'bhɛ 'yaa‑ dɔɔ: «Mɛɛ 'lɛɛ‑ 'yele‑ 'ke Zesu 'le, Zuufu mu a ‑bhleŋgbe 'ɛ.» ");
INSERT INTO moa_vpl VALUES ("MT27_38","070_27_38","MAT","27","38","38","'Ezin‑, ‑o ‑faannii' plɛ ‑gbaanna ‑yrigbɛɛle plɛ ta Zesu ‑din: ‑A do ‑yaa ‑a gbɛ ‑yiɛ' ta, 'bhɛɛ‑ ‑a ‑bhɛɛke' do 'ɛ 'yaa‑ ‑a gbɛ ‑koo ta. ");
INSERT INTO moa_vpl VALUES ("MT27_39","070_27_39","MAT","27","39","39","Mɛɛ 'la zan mu ‑yaa 'kan zii' Zesu gbaanyrɛ 'ɛ ‑din, 'mu 'yaa‑ a glin 'ke 'mu 'mu ŋgblo bɛɛn, 'bhɛɛ‑ 'ke ‑wa ‑zwanwo'. ");
INSERT INTO moa_vpl VALUES ("MT27_40","070_27_40","MAT","27","40","40","'Bhɛɛ‑ ‑o ‑yaa pe dɔɔ: «'Bhi 'laa 'pelɛ‑ 'kaa 'e sɔ ‑Waanbhaa' Gba 'Fɛ ‑Gbɛnɛ 'ɛ 'wile‑, 'bhɛɛ‑ 'ya dɔ gbɛ drɛɛwo ‑yrekpaa' yaga ‑la ɛɛ? 'Kee‑ 'yoo‑ 'ke ‑Waanbhaa' Gbe 'ɛ 'le, 'e 'gbu 'bhee ‑zɔn, 'bhɛɛ‑ zina‑ ‑yrigbɛɛle 'ɛ ta doo.» ");
INSERT INTO moa_vpl VALUES ("MT27_41","070_27_41","MAT","27","41","41","'Bhɛ klɛgbɛya do 'ɛ 'yi, 'sraka 'lɛna ‑kuŋlii mu 'ɛ 'pegee 'Toŋ daan mu 'ɛ, 'bhɛɛ‑ 'gwlaan‑ gblaan mu 'ɛ, ‑o 'kpɛn 'yaa‑ Zesu malrɔgo 'zi 'ke ‑wa pe dɔɔ: ");
INSERT INTO moa_vpl VALUES ("MT27_42","070_27_42","MAT","27","42","42","«‑E mɛɛ ‑bhɛɛke' mu 'ɛ ‑gwa ‑za 'yi, 'bhɛɛ‑ yaa sɔ ‑a 'gbu gole ‑za 'yi! 'Ke ‑yoo 'ke Izraɛli mu a ‑bhleŋgbe 'le, ‑e zina‑ 'saanibhe doo ‑yrigbɛɛle 'ɛ ta; 'kee‑ 'bhɛ ꞊kla, 'o nu 'o 'kpalɛ‑ ‑a ‑yi. ");
INSERT INTO moa_vpl VALUES ("MT27_43","070_27_43","MAT","27","43","43","‑Ya 'gbu gbɛkpaa‑ ‑Waanbhaa' 'kɔɔ, 'bhɛɛ‑ ‑ya ‑pia dɔɔ: ‹'Ŋ 'yoo‑ 'ke ‑Waanbhaa' Gbe 'le!› 'Bhɛɛ‑ 'ke ‑a ‑za sɔ ‑Waanbhaa' ni 'bhɛ nu 'a go 'saanibhe ‑za 'yi doo!» ");
INSERT INTO moa_vpl VALUES ("MT27_44","070_27_44","MAT","27","44","44","Mɛɛ dɛ mi plɛ 'la gbaanle ‑yaa ‑a ‑din ‑yrigbɛɛle plɛ 'ɛ ta, 'mu 'yaa‑ ‑a ‑zwanwo' zii' 'bhɛ klɛgbɛya do 'ɛ gbɛɛn‑ 'ezin‑. ");
INSERT INTO moa_vpl VALUES ("MT27_45","070_27_45","MAT","27","45","45","'Kee‑ san ‑yrekpaa' ma, 'bhɛɛ‑ 'kee‑ ge 'tɛnlɛ‑ yromazi ‑yretɛbhɛ yanyan 'ɛ ma, ‑gblo ‑gbɛnɛ ‑kpaa 'trɛ 'ɛ ta yrɛkpɛn‑ ꞊nɔɔ. ");
INSERT INTO moa_vpl VALUES ("MT27_46","070_27_46","MAT","27","46","46","'Yee‑ yromazi ‑yretɛbhɛ yanyan 'ɛ 'bhɔ bhla 'ɛ 'e ‑din, 'ke Zesu ‑gbekanle 'eglɔɔle dɔɔ: «Eli, Eli, lama sabatani?» 'Bhɛ 'yi ‑le dɔɔ: «'An ‑Waanbhaa', 'an ‑Waanbhaa', ‑mɛle ꞊kla 'bhɛɛ‑ 'ye 'ŋ do ‑kplɛn ꞊twa ‑a nɔɔ‑ ɛɛ?» ");
INSERT INTO moa_vpl VALUES ("MT27_47","070_27_47","MAT","27","47","47","Mɛɛ 'la zan mu ‑yaa ‑a ‑din 'bhɛ 'waati 'ɛ ba, 'mu 'a ‑gbekanwli 'ɛ 'male, 'ke 'mu 'a pele‑ dɔɔ: «‑Ka 'ka 'trɔnbadɔ doo, ‑yoo Eli 'sii zii'!» ");
INSERT INTO moa_vpl VALUES ("MT27_48","070_27_48","MAT","27","48","48","'Bhɛ klɛle 'tɛ, 'ke ‑o do gele blaale‑ ‑nɛ 'yiɛntɛnnɛ 'fɛ ‑gblaŋluu ‑fɔlu' ‑fɔlu' 'ɛ 'silɛ‑, 'kee‑ 'bhɛ 'pale 'ke ‑wɛɛn yue 'tɔnle‑ 'le. 'Kee‑ 'bhɛ 'yrele togɔ gbɔɔn do yin 'lii, 'bhɛɛ‑ 'kee‑ 'bhɛ 'wlale Zesu 'lii 'kaa 'bhɛ 'bhɛ 'mi. ");
INSERT INTO moa_vpl VALUES ("MT27_49","070_27_49","MAT","27","49","49","'Duŋ‑ ‑a ‑vin mu 'ɛ pe dɔɔ: «'Kɔɔ‑ dula‑ doo, ‑dɔke' Eli nu nulɛ a golɛ ‑za 'yi oo!» ");
INSERT INTO moa_vpl VALUES ("MT27_50","070_27_50","MAT","27","50","50","Zesu ‑gbekan' gbɛ drɛɛwoa‑ 'eglɔɔle 'ezin‑, 'ke ‑a niigole ‑a ‑yi. ");
INSERT INTO moa_vpl VALUES ("MT27_51","070_27_51","MAT","27","51","51","'Bhɛ 'waati do 'kpɔ 'ɛ ba, sɔgbɛ ‑gbɛnɛ 'la duŋle ‑yaa ‑Waanbhaa' Gba 'Fɛ ‑Gbɛnɛ 'ɛ 'kpee yrɛ 'la ‑o ‑yaa 'bhɛ sii «Yrɛ 'weŋ 'weŋ» 'bhɛ꞊la, 'bhɛ 'peedia‑ plɛ 'kee‑ da laanima, 'kee‑ nu 'tɛnlɛ‑ 'traa. 'Bhɛ klɛlɛ 'tɛ, 'ke 'trɛ bɛɛnle‑, 'bhɛɛ‑ 'ke vlɛ ‑saa mu 'ɛ ‑o ‑wile'. ");
INSERT INTO moa_vpl VALUES ("MT27_52","070_27_52","MAT","27","52","52","Mɛɛ bu mu 'ɛ 'liigwa‑, 'bhɛɛ‑ mɛɛ ‑lɛdɔɔle mu 'la ‑gaa 'elwale gban ‑sɔ, 'mu ‑bebe ‑bwela gale ba. ");
INSERT INTO moa_vpl VALUES ("MT27_53","070_27_53","MAT","27","53","53","'Bhɛɛ‑ ‑o ‑pwɛla bu mu 'ɛ 'yi Zesu bwele 'ɛ blaan gale ba, 'ke ‑o nule‑ Zeruzalɛmu ‑wa 'ɛ 'kpee. Mɛɛ ‑bebe ‑o ꞊ya. ");
INSERT INTO moa_vpl VALUES ("MT27_54","070_27_54","MAT","27","54","54","'Bhɛ klɛle 'tɛ, ‑srwase' ‑kuŋlii 'ɛ 'pegee ‑srwase' ‑vin mu 'la 'yaa‑ Zesu gooba 'ke ‑yoo ‑yrigbɛɛle 'ɛ ta, ‑o 'trɛ bɛɛnyrɛ 'la ꞊ya, 'bhɛ 'pegee ‑za mu 'la 'kpɛn ꞊kla ‑o ‑yrɛ ma, 'bhɛla‑ ‑zayi' ‑gblaan ‑gbɛnɛ ꞊klaa ‑o ‑yi. 'Bhɛɛ‑ 'ke ‑wa pele‑ 'eke‑ ni dɔɔ: «Mɛɛ 'lɛɛ‑ 'yaa‑ 'ke ‑Waanbhaa' Gbe kpataakpa 'gbu 'ɛ 'bhɛɛ‑ 'le!» ");
INSERT INTO moa_vpl VALUES ("MT27_55","070_27_55","MAT","27","55","55","Le 'srɛ mu 'la 'yaa‑ zi Galile 'trɛ 'ɛ ta 'ke 'mu bhɔ a ba, 'bhɛɛ‑ 'ke 'mu ꞊nwa ‑a zi Zeruzalɛmu, 'mu 'yaa‑ ‑a gbaa 'ɛ taglin‑ 'zi bhlɔ gbɔɔn ma. ");
INSERT INTO moa_vpl VALUES ("MT27_56","070_27_56","MAT","27","56","56","'Woo‑ le mu 'ɛ 'ke mu ‑la 'tɔ ‑le ‑gɛ: Mari 'la da Magidala ‑wa 'ɛ ta, Zaki 'pegee Zozɛfu nɛɛ Mari, 'bhɛɛ‑ Zebede gbe plɛ 'ɛ Zaki 'pegee Zaan nɛɛ. ");
INSERT INTO moa_vpl VALUES ("MT27_57","070_27_57","MAT","27","57","57","Yromazi bhɔle, 'ke pɛzan do dale‑ Arimate ‑wa 'ɛ ta, ‑o ‑yaa 'bhɛ sii Zozɛfu, 'bhɛɛ‑ 'bhɛ 'yaa‑ Zesu a ‑klaŋlanɛ mu 'ɛ do 'le. ");
INSERT INTO moa_vpl VALUES ("MT27_58","070_27_58","MAT","27","58","58","'Bhɛ 'yi, 'kee‑ gele‑ 'tɛ Zesu gbaa 'ɛ 'yrɛwolɛ ‑janmatii Pilati ma. ‑Ayile, 'ke Pilati dɔle‑ gbaa 'ɛ 'nale‑ ‑la ‑a ni. ");
INSERT INTO moa_vpl VALUES ("MT27_59","070_27_59","MAT","27","59","59","'Bhɛ ya 'ɛ 'yi, 'kee‑ gbaa 'ɛ 'sile, 'bhɛɛ‑ 'kee‑ sɔ drɛɛ 'pu 'peŋpeŋ do 'kpale 'bhɛ ma. ");
INSERT INTO moa_vpl VALUES ("MT27_60","070_27_60","MAT","27","60","60","'Bhɛ blaan, 'kee‑ gele‑ ‑a binlɛ bu ‑gluu drɛɛ do 'yi. 'Yee‑ Zozɛfu 'gbu ‑le mɛɛ mu ꞊sia 'kaa 'mu 'bhɛ bu ‑gluu 'ɛ 'kwlee‑ ‑a ni vlɛ ‑saa do 'yi. ‑E yanle 'kee‑ vlɛ ‑kpuŋ ‑gbɛnɛ do ‑bhlile', 'bhɛɛ‑ 'kee‑ bu ‑gluu 'ɛ 'liitanle 'bhɛ 'le. 'Bhɛ blaan, 'kee‑ jilale. ");
INSERT INTO moa_vpl VALUES ("MT27_61","070_27_61","MAT","27","61","61","'Bhɛ 'waati 'ɛ ba, Mari 'la 'yaa‑ da Magidala ‑wa 'ɛ ta, 'bhɛ 'pegee 'bhɛ 'too‑ Mari do 'ɛ, 'mu 'yaale ‑yaa bu 'ɛ 'lɛma‑. ");
INSERT INTO moa_vpl VALUES ("MT27_62","070_27_62","MAT","27","62","62","'Bhɛ ta tooklin‑ 'ɛ 'yi 'le, ‑yitrɛ' yi 'ɛ ma pɛ mu 'ɛ magaanle blaan, 'ke 'sraka 'lɛna ‑kuŋlii mu 'ɛ 'pegee Farizi mu 'ɛ ‑o gele‑ 'eke‑ zi Pilati ba. ");
INSERT INTO moa_vpl VALUES ("MT27_63","070_27_63","MAT","27","63","63","'Bhɛɛ‑ 'ke ‑wa pele‑ Pilati ni dɔɔ: «'O zan, 'yee‑ bhlanii‑ 'la bhe, ‑e ‑yaa ‑a ‑yrɛ ma 'waati 'la ba, ‑ya ꞊pia dɔɔ ‑e nu bwelɛ gale ba, ‑a gale blaan ‑yrekpaa' yaga mi ma. 'Bhɛ ‑jan 'ɛ 'bhɛ ‑o ‑li 'o 'kpee. ");
INSERT INTO moa_vpl VALUES ("MT27_64","070_27_64","MAT","27","64","64","‑Ayile, ‑a pe ‑srwase' mu ni dɔɔ ‑o bo ‑a bu 'ɛ gooba ‑yrekpaa' yaga ta, 'kooko‑ ‑yaa' ‑klaŋlanɛ mu 'ɛ waa nu nulɛ ‑a gbaa 'ɛ 'faanlɛ‑, 'bhɛɛ‑ ‑wa pe ‑kɔɔa' mɛɛ mu 'ɛ ni dɔɔ: ‹‑E ‑bwela gale ba.› 'Ke 'bhɛ ꞊kla, 'bhɛ bhla 'ɛ gblaan 'yi nu yalɛ ‑e bhla ‑lwa mi 'la ꞊pia 'bhɛ ni.» ");
INSERT INTO moa_vpl VALUES ("MT27_65","070_27_65","MAT","27","65","65","'Bhɛ klɛle 'tɛ, 'ke Pilati 'a 'pele ‑o ni dɔɔ: «‑Srwase' 'ke mu ‑le ‑gɛ, ‑ka mu 'si ‑a gooba yaaza 'yi. ‑Ka ge 'bhɛɛ‑ ‑kaa pe mɛɛ mu ni 'mu bo a bu 'ɛ gooba 'bhii‑ ‑e sɔ 'ka ni gɔnɛ‑ 'la gbɛɛn‑.» ");
INSERT INTO moa_vpl VALUES ("MT27_66","070_27_66","MAT","27","66","66","'Bhɛɛ‑ 'ke ‑o gele‑ yaalɛ 'tɛ ‑a bu 'ɛ gooba. ‑O Romɛ mu a ‑bhleŋgbe ‑gbɛnɛ 'ɛ, 'bhɛ gbɛ blaan yɔɔn ‑kpalaa' bu ‑gluu 'ɛ 'liitan vlɛ ‑kpuŋ 'ɛ ta, 'bhɛɛ‑ ‑o piibhɛ kpɛlɛ‑ ‑gbɛnɛ do ‑yrela 'bhɛ ta. 'Bhɛ blaan, 'ke ‑srwase' mu 'ɛ 'yaale bu 'ɛ gooba. ");
INSERT INTO moa_vpl VALUES ("MT28_1","070_28_1","MAT","28","1","1","‑Yitrɛ' yi 'ɛ ta tooklin‑ yi 'ɛ 'le, 'kaŋgɔplɛ 'ɛ ma, zrwan 'tutu 'ɛ 'zi, 'ke Mari 'la 'yaa‑ da Magidala ‑wa 'ɛ ta, 'bhɛ 'pegee 'bhɛ 'too‑ Mari, gele‑ bu ‑gluu 'ɛ taglinlɛ. ");
INSERT INTO moa_vpl VALUES ("MT28_2","070_28_2","MAT","28","2","2","'Bhɛ 'waati do 'kpɔ 'ɛ ba, 'ke 'trɛ bɛɛnle‑ faŋgan‑ ma, 'bhɛɛ‑ 'ke Mɛɛzan ‑Waanbhaa' a ‑mlɛkɛ' do zinale 'kee‑ da laflɛ' ma. 'Bhɛɛ‑ 'kee‑ bu ‑gluu 'ɛ 'liitan vlɛ ‑kpuŋ ‑gbɛnɛ 'ɛ 'bhlile‑ bu ‑gluu 'ɛ ‑gɔma', 'bhɛɛ‑ 'kee‑ yaale' 'bhɛ vlɛ ‑kpuŋ 'ɛ ta. ");
INSERT INTO moa_vpl VALUES ("MT28_3","070_28_3","MAT","28","3","3","'Yee‑ ‑mlɛkɛ' 'ɛ wlɛyi' 'ɛ 'yaa‑ ‑bhi 'zi ‑yrayra 'bhii‑ mlɛklɛnnɛ do ‑bhigbɛya 'ɛ gbɛɛn‑, 'bhɛɛ‑ ‑a ta dunɛ‑ 'ɛ 'yaa‑ flee 'epu 'peŋpeŋle 'bhii‑ 'kwlɛn‑ ‑buu' 'fleegbɛya gbɛɛn‑. ");
INSERT INTO moa_vpl VALUES ("MT28_4","070_28_4","MAT","28","4","4","‑Ayile, ‑gblaan 'kla gbɛ ‑yɔɔ 'ɛ 'kɔɔ bu 'ɛ gooba mu 'ɛ 'yi, 'ke ‑o bɛɛnle 'sanle ‑kpakpa, 'bhɛɛ‑ 'ke ‑o 'srinle 'bhii‑ ‑o ‑gaa. ");
INSERT INTO moa_vpl VALUES ("MT28_5","070_28_5","MAT","28","5","5","'Bhɛ klɛle 'tɛ, 'ke ‑mlɛkɛ' 'ɛ ‑ya pele‑ le mu 'la ꞊nwa bu 'ɛ taglinyrɛ 'ɛ nɔɔ‑ 'mu ni dɔɔ: «'Ka mu laa ‑gblaanlɛ'! 'An 'yaango‑ ‑o Zesu 'la ‑gbaanna ‑yrigbɛɛle 'ɛ ta, 'ka ‑o 'bhɛɛ‑ ‑gliŋ 'zi. ");
INSERT INTO moa_vpl VALUES ("MT28_6","070_28_6","MAT","28","6","6","Yaa ‑o ‑li ‑gɛ. ‑E ‑bwela gale ba 'bhii‑ ‑ya ‑pia 'ka ni gɔnɛ‑ 'la gbɛɛn‑. ‑Ka nu ‑a gbaa 'kpayrɛ‑ 'ɛ ‑glin ‑gɛ doo. ");
INSERT INTO moa_vpl VALUES ("MT28_7","070_28_7","MAT","28","7","7","'Bhɛɛ‑ ‑ka ge blaale‑ ‑a pe ‑yaa' ‑klaŋlanɛ mu 'ɛ ni dɔɔ ‑e ‑bwela gale ba, 'bhɛɛ‑ ‑e 'kan zii' 'ka 'lɛɛ ‑sɔ Galile 'klɛɛn 'ɛ 'yi. 'Ka nu ‑a yelɛ 'bhɛɛ‑ ꞊nɔɔ ye. 'Ŋ ꞊nwa ‑jan 'la 'wolɛ‑ 'ka ni 'bhɛ ‑le bhe.» ");
INSERT INTO moa_vpl VALUES ("MT28_8","070_28_8","MAT","28","8","8","'Bhɛ klɛle 'tɛ, 'ke 'woo‑ le mu 'ɛ ‑o gole‑ blaale‑ bu 'ɛ ‑din, 'ke ‑o blasanle, 'bhɛɛ‑ 'ke ‑o gele‑ 'yee‑ ‑Jan 'Nrale‑ 'ɛ 'pelɛ‑ Zesu a ‑klaŋlanɛ mu 'ɛ ni. ‑Gblaan 'pegee yilabla ‑gbɛnɛ do ‑yaa ‑o zru ba. ");
INSERT INTO moa_vpl VALUES ("MT28_9","070_28_9","MAT","28","9","9","‑O nu bhla 'ɛ zi, Zesu bewza 'ɛ 'woyrɛ‑ nɔɔ‑, 'ke Zesu 'klale ‑o ba blaale‑, 'bhɛɛ‑ 'ke 'bhɛ ‑o 'pubɔle dɔɔ: «'Ka 'ŋ ‑kɛna!» 'Bhɛ klɛle 'tɛ, 'ke 'woo‑ le mu 'ɛ ‑woo mabɛɛnle Zesu ‑din, 'bhɛɛ‑ 'ke ‑wa gbale‑ ‑o 'kpɔ zɛnlele ‑a ‑lɛɛ, 'bhɛɛ‑ 'ke ‑woo gbɛ mu kpa ‑a gaan ma. ");
INSERT INTO moa_vpl VALUES ("MT28_10","070_28_10","MAT","28","10","10","'Bhɛ 'yi 'tɛ, 'ke Zesu 'a 'pele‑ ‑o ni dɔɔ: «'Ka 'laa ‑gblaanlɛ'! ‑Ka ge a pe 'ŋ nɛɛnɛ‑ mu 'ɛ ni 'kaa ‑o ge Galile 'klɛɛn 'yi: ‑O nu 'ŋ 'yelɛ‑ 'bhɛɛ‑ ꞊nɔɔ ye.» ");
INSERT INTO moa_vpl VALUES ("MT28_11","070_28_11","MAT","28","11","11","Le mu 'ɛ 'yaa‑ ge 'zi 'waati 'la ba Zesu a ‑klaŋlanɛ mu 'ɛ ta, 'ke ‑srwase' mu 'la ‑o ꞊bwa Zesu bu 'ɛ gooba, 'mu 'ke mu gele‑ ‑wa 'ɛ 'kpee, 'bhɛɛ‑ ‑za mu 'la 'kpɛn ꞊kla ‑o ‑yrɛ ma, ‑o 'mu 'kpɛn 'yigɔɔnna 'sraka 'lɛna ‑kuŋlii mu 'ɛ ni. ");
INSERT INTO moa_vpl VALUES ("MT28_12","070_28_12","MAT","28","12","12","‑Ayile, 'ke 'woo‑ *'sraka 'lɛna ‑kuŋlii mu 'ɛ 'pegee 'gwlaan‑ gblaan mu 'ɛ ‑woo ‑lɛkpale 'eke‑ ta. 'Bhɛɛ‑ ‑o 'kpale do ma, 'ke ‑o ‑gɔli' kpu ‑gbɛnɛ do wlale‑ ‑srwase' mu 'ɛ gbɛ ꞊la. ");
INSERT INTO moa_vpl VALUES ("MT28_13","070_28_13","MAT","28","13","13","'Bhɛɛ‑ 'ke ‑o 'mu 'lɛmazɔnle dɔɔ: «‑Ka ge ‑a pe dɔɔ 'o 'yaa‑ yi pla 'waati 'la ba ‑bi 'ɛ zi, ‑yaa' ‑klaŋlanɛ mu 'ɛ ꞊nwa ‑a gbaa 'ɛ faanlɛ‑. ");
INSERT INTO moa_vpl VALUES ("MT28_14","070_28_14","MAT","28","14","14","'Ali‑ 'ke ‑janmatii Pilati 'trɔnbwa‑ 'yee‑ ‑za 'ɛ 'yi, 'o mɔɔ 'gbu nu ‑janwole a ni, 'bhɛɛ‑ 'o 'ka ŋgblo go ‑za 'yi.» ");
INSERT INTO moa_vpl VALUES ("MT28_15","070_28_15","MAT","28","15","15","'Bhɛ klɛle 'tɛ, 'ke ‑srwase' mu 'ɛ ‑o ‑gɔli' 'ɛ 'sile, 'bhɛɛ‑ *'sraka 'lɛna ‑kuŋlii' mu 'ɛ 'pegee 'gwlaan‑ gblaan mu 'ɛ ‑wa ‑pia ‑o ni ‑o ‑za yɛkɛ‑ 'la 'bhɛ klɛ ‑o 'bhɛɛ‑ ꞊kla. ‑Ayile, 'kee‑ san 'bhɛ yi 'ɛ ma, 'kee‑ nu 'tɛnlɛ‑ ‑zɔn ma, 'bhɛ ‑jan 'ɛ ꞊zian Zuufu mu 'ɛ 'kpɛn 'trɔn 'yi. ");
INSERT INTO moa_vpl VALUES ("MT28_16","070_28_16","MAT","28","16","16","Zesu a ‑klaŋlanɛ ‑vin vu ta do 'ɛ (‑amasrɔyi Zudasi 'la 'yaa‑ ‑o vu ta plɛ mi 'ɛ le, bhɛ 'bhɛ 'gbu ꞊dia) ‑ja Galile 'klɛɛn 'yi vlɛ gɔɔn do 'la ‑e 'bhɛ ‑zrɔnna ‑o ni 'bhɛɛ‑ 'wiiŋ‑. ");
INSERT INTO moa_vpl VALUES ("MT28_17","070_28_17","MAT","28","17","17","‑O Zesu 'yele‑, 'ke ‑woo 'kpɔ zɛnle‑ ‑a ‑lɛɛ, 'bhɛɛ‑ 'ke ‑wa gbale‑ ‑o 'seriwolele. 'Duŋ‑ ‑o 'ke mu laa 'mu 'kpalɛ‑ ‑a ‑yi 'bhii‑ 'yele‑ 'kɛle‑. ");
INSERT INTO moa_vpl VALUES ("MT28_18","070_28_18","MAT","28","18","18","'Bhɛ 'yi 'tɛ, 'ke Zesu 'e 'mabɛɛnle ‑o ‑din, 'ke ‑ya pele‑ ‑o ni dɔɔ: «‑Waanbhaa' ‑glɔɔya' 'kpɛn ꞊naa 'ŋ ni laflɛ' 'pegee 'trɛ ta. ");
INSERT INTO moa_vpl VALUES ("MT28_19","070_28_19","MAT","28","19","19","‑Ka ge 'klɛɛn 'kpɛn 'yi mu 'ɛ ta, 'bhɛɛ‑ ‑ka ‑o klɛ 'an ‑klaŋlanɛ mu 'le. ‑Ka ‑o wiiŋfɛ' ‑yi ba ‑kɔɔ' Dɛ ‑Waanbhaa' 'pegee ‑a Gbe, 'bhɛɛ‑ Lii 'Weŋ 'ɛ 'tɔ 'yi. ");
INSERT INTO moa_vpl VALUES ("MT28_20","070_28_20","MAT","28","20","20","'Bhɛɛ‑ 'mi 'ka mu ‑daanna ‑jan 'oo ‑jan mu 'la 'le, ‑ka ‑o daan 'mu 'kpɛn ta 'taawolele. ‑Kaa 'yaango‑ dɔɔ 'ŋ 'yoo‑ 'ka ba yikpɛnsee ta, 'ke 'bhɛ ge 'tɛnlɛ‑ 'drunyan 'yan yi ma.»");
INSERT INTO moa_vpl VALUES ("MK1_1","071_1_1","MRK","1","1","1","‑Waanbhaa' Gbe Zesu Krisi ma ‑Jan ‑Nrale' 'ɛ zisaan‑ gɔnɛ‑ 'lɛɛ‑ 'bhɛɛ‑ gbɛɛn‑. ");
INSERT INTO moa_vpl VALUES ("MK1_2","071_1_2","MRK","1","2","2","‑A yɔɔndɛle ‑o ‑Waanbhaa' ‑lɛla' janwo mi Ezai a 'sɛwɛ 'ɛ 'yi dɔɔ: «'E 'trɔnbadɔ doo, 'mi ‑Waanbhaa' nu 'an ‑toorodɔ mi 'ɛ 'winbɔlɛ 'e 'lɛɛ zi magaan zayi'. ");
INSERT INTO moa_vpl VALUES ("MK1_3","071_1_3","MRK","1","3","3","‑Yoo 'ke mɛɛ 'la zan ‑o ‑gbekan zii' 'eglɔɔle ‑kpe 'ɛ ta 'ke ‑ya pe mɛɛ mu 'ɛ ni dɔɔ. ‑Ka Mɛɛzan a zi 'ɛ magaan, ‑ka ‑yaa' zibhɛ mu 'ɛ 'lɛdɔɔ‑!» ");
INSERT INTO moa_vpl VALUES ("MK1_4","071_1_4","MRK","1","4","4","'Bhɛ klɛgbɛya do 'ɛ 'yi, Mɛɛ Wiiŋfɛ' Mi Zaan ꞊nwa, ‑e ‑yaa ‑kpe 'ɛ ta, 'bhɛɛ‑ ‑e ‑yaa mɛɛ mu 'ɛ wiiŋfɛ' zii' ‑yi ba. 'Ke ‑yoo wiiŋfɛle bhla 'la ba, ‑e ‑yaa pe ‑o ni dɔɔ: «‑Ka 'ka 'taawogbɛya mu 'ɛ maniina 'ke 'ka 'ploo ‑za 'yɔɔ‑ klɛle ma; 'bhɛɛ‑ 'ŋ 'ka 'wiiŋfɛ‑ 'tɛ ‑yi 'ɛ ba; 'kooko‑ ‑Waanbhaa' 'kaa‑ ‑za 'yɔɔ‑ mu 'ɛ 'sroma‑ yan!» ");
INSERT INTO moa_vpl VALUES ("MK1_5","071_1_5","MRK","1","5","5","Zude 'klɛɛn 'ɛ 'yi mɛɛ mu 'ɛ 'kpɛn 'pegee Zeruzalɛmu mu 'ɛ 'kpɛn 'yaa‑ ge 'zi 'yee‑ Zaan ba. 'Ke ‑o ‑yaa yan ‑waa' ‑za 'yɔɔ‑ mu 'ɛ 'pelele mɔkpɛn' 'yrɛ ma, 'bhɛɛ‑ ‑e ‑yaa ‑o wiiŋfɛ 'tɛ Zrudɛn yue 'ɛ ba. ");
INSERT INTO moa_vpl VALUES ("MK1_6","071_1_6","MRK","1","6","6","'Yee‑ Zaan ta dunɛ‑ 'ɛ 'tanle‑ ‑yaa 'ke 'yɔɔnma 'ciɛ‑ 'le, 'bhɛɛ‑ 'flɛ 'sɛntru do dɔle ‑yaa ‑a 'saanla. ‑E ‑yaa ‑a 'gbu 'lɛbɔ‑ 'ke 'siesie‑ ‑gama 'pegee ‑bɔn 'yi ‑zrɔ 'yrɔn mu 'le. ");
INSERT INTO moa_vpl VALUES ("MK1_7","071_1_7","MRK","1","7","7","‑E ‑yaa ‑jan 'lɛɛ‑ 'bhɛɛ‑ 'wo zii' mɛɛ mu 'ɛ ni dɔɔ: «Mɛɛ 'la zan nu nulɛ 'mi blaan, 'bhɛ 'sɔle‑ ‑yiya' 'mi ni, 'ali‑ ‑a wlɛyi' laa ‑o 'mi wlɛyi' ta 'ke 'mi 'ŋ makulaa 'bhɛɛ‑ 'an gaan ma ‑sawla bhlɛ mu 'ɛ ploo, 'bhii‑ lu mu 'a klɛ gɔnɛ‑ 'la gbɛɛn‑ bhe. ");
INSERT INTO moa_vpl VALUES ("MK1_8","071_1_8","MRK","1","8","8","'Mi ‑o 'ka 'wiiŋfɛ zii' ‑yi ba, 'duŋ‑ 'yee‑ nu 'ka 'palɛ 'ke Lii 'Weŋ 'ɛ 'le.» ");
INSERT INTO moa_vpl VALUES ("MK1_9","071_1_9","MRK","1","9","9","'Bhɛ 'waati 'ɛ ba, Zesu ‑daa Galile 'trɛ ta ‑wa do ta, ‑o ‑yaa 'bhɛ sii Nazarɛti, 'bhɛɛ‑ ‑e ꞊nwa Mɛɛ Wiiŋfɛ' Mi Zaan ba ‑a wiiŋfɛ' zayi' Zrudɛn yue 'ɛ ba. ");
INSERT INTO moa_vpl VALUES ("MK1_10","071_1_10","MRK","1","10","10","'E ‑yaa pwɛ zii' ‑yi 'ɛ ba bhla 'la ba, 'kee‑ laflɛ' 'liiploole yele‑, 'bhɛɛ‑ 'ke Lii 'Weŋ 'ɛ zinale ‑a ta 'bhii‑ ‑bhooladɔ maannɛ‑ do gbɛɛn‑. ");
INSERT INTO moa_vpl VALUES ("MK1_11","071_1_11","MRK","1","11","11","'Bhɛ yrɛ do 'ɛ ꞊nɔɔ bhe, 'ke ‑weli' do dale‑ laanima 'ke 'bhɛ 'a 'pele dɔɔ: «'Bhi ‑le 'ke 'ŋ gbe 'la ‑za sɔ 'ŋ ni 'egbɛnɛle 'bhɛ 'le, 'bhɛɛ‑ 'bhi ‑le 'ŋ zrukpalaa kpataakpa.» ");
INSERT INTO moa_vpl VALUES ("MK1_12","071_1_12","MRK","1","12","12","'Bhɛ blaan yrɛ do 'kpɔ 'ɛ ꞊nɔɔ bhe, 'ke Lii 'Weŋ 'ɛ gele‑ Zesu 'le ‑kpe 'ɛ ta. ");
INSERT INTO moa_vpl VALUES ("MK1_13","071_1_13","MRK","1","13","13","'Bhɛɛ‑ ‑e ‑yrekpaa' mia plɛ 'ke ‑bi mia plɛ ‑la ‑gaa 'bhɛ ꞊nɔɔ ye, 'bhɛɛ‑ ‑Setran' 'a 'yidaan‑ 'bhɛ 'waati 'ɛ ba. ‑E ‑yaa ‑bɔn 'yi wi mu 'ɛ 'pleŋ‑, 'bhɛɛ‑ ‑Waanbhaa' a ‑mlɛkɛ' mu 'ɛ ꞊bhwa ‑a ba. ");
INSERT INTO moa_vpl VALUES ("MK1_14","071_1_14","MRK","1","14","14","‑O Mɛɛ Wiiŋfɛ' Mi Zaan 'kunle‑, 'bhɛɛ‑ ‑o yanle ‑a bɔlele ‑kaso 'yi, 'ke Zesu gele‑ ‑Waanbhaa' a ‑Jan 'Nrale‑ 'ɛ 'wolɛ‑ Galile 'trɛ 'ɛ ta. ");
INSERT INTO moa_vpl VALUES ("MK1_15","071_1_15","MRK","1","15","15","‑E ‑yaa ‑jan 'lɛɛ‑ 'bhɛɛ‑ 'wo zii' mɛɛ mu 'ɛ ni dɔɔ: «'Waati 'ɛ 'lɛswa꞊, ‑Waanbhaa' a ‑bhleŋgbeya 'ɛ ꞊bhwa 'ka ‑din, ‑ka 'ka zru niina‑ 'ke 'ka 'ploo‑ ‑za 'yɔɔ‑ klɛle ma, 'bhɛɛ‑ ‑ka 'ka 'kpa ‑Jan 'Nrale‑ 'ɛ 'yi.» ");
INSERT INTO moa_vpl VALUES ("MK1_16","071_1_16","MRK","1","16","16","'Bhɛ blaanta, ‑e ‑yaa 'kan zii' bhla 'la ba Galile ‑draa 'ɛ 'lɛzi‑, 'kee‑ Simɔ 'pegee 'bhɛ 'nwagwlɛn‑ Andre 'yele yrɔ bɔ yrɛ ꞊nɔɔ ‑draa 'ɛ ba; ‑amasrɔyi ‑o ‑yaa 'ke kaadɛ mu 'le. ");
INSERT INTO moa_vpl VALUES ("MK1_17","071_1_17","MRK","1","17","17","Zesu pe ‑o ni dɔɔ: «‑Ka nu dɔ 'ŋ zi, 'bhɛɛ‑ 'ŋ nu 'ka klɛlɛ 'ke mɛɛ mu 'kun mu 'le 'bhii‑ 'ka kaa mu kun gɔnɛ‑ 'la gbɛɛn‑.» ");
INSERT INTO moa_vpl VALUES ("MK1_18","071_1_18","MRK","1","18","18","'Bhɛ yrɛ do 'ɛ ꞊nɔɔ bhe, 'ke ‑o 'ploole ‑waa' kaadɛ yrɔ mu 'ɛ ma, 'ke ‑o gele‑ dɔlɛ ‑a zi. ");
INSERT INTO moa_vpl VALUES ("MK1_19","071_1_19","MRK","1","19","19","‑O 'bhɔle‑ 'ezin‑ sa ‑o 'lɛɛ‑, 'ke Zesu Zebede gbe plɛ 'ɛ 'yele‑, Zaki 'pegee 'bhɛ 'nwagwlɛn‑ Zaan. ‑O ‑yaa' ‑yitakoŋ do 'yi 'ke ‑o waa kaadɛ yrɔ mu 'ɛ magaan. ");
INSERT INTO moa_vpl VALUES ("MK1_20","071_1_20","MRK","1","20","20","'Bhɛ yrɛ do 'ɛ ꞊nɔɔ bhe 'tɛ, 'kee‑ 'mu 'siile. 'Ke 'bhɛ mu 'mu dɛ Zebede 'pegee 'bhɛ a yewonɛ mu 'ɛ 'tole ‑yitakoŋ 'ɛ 'yi, 'ke 'mu gele‑ dɔlɛ ‑a zi. ");
INSERT INTO moa_vpl VALUES ("MK1_21","071_1_21","MRK","1","21","21","'Bhɛ blaan, 'ke Zesu 'pegee ‑yaa' *‑klaŋlanɛ mu 'ɛ ‑o gele‑ Kapɛnɔmu ‑wa 'ɛ ta. 'Bhɛɛ‑ ‑yitrɛ' yi 'ɛ 'bhɔle‑, 'kee‑ gele wlalɛ Zuufu mu a daanfɛ' 'ɛ ꞊la. 'Bhɛɛ‑ 'kee‑ mɛɛ mu 'ɛ daanle 'sanle. ");
INSERT INTO moa_vpl VALUES ("MK1_22","071_1_22","MRK","1","22","22","Mɛɛ 'la zan ‑yaa 'mu 'trɔnkpa zii' ‑a ni, ‑e 'mu 'kpeelɛnia 'mu ma ‑yaa' mɛɛ daangbɛya 'ɛ 'le. ‑Amasrɔyi yaa ‑yaa ‑o daan 'zi 'bhii‑ *'Toŋ Daan mu 'ɛ ‑waa' mɛɛ daangbɛya 'ɛ gbɛɛn‑, 'duŋ‑ ‑e ‑yaa ‑o daan 'zi 'bhii‑ 'seŋ ‑o mɛɛ 'la zan 'kɔɔ. ");
INSERT INTO moa_vpl VALUES ("MK1_23","071_1_23","MRK","1","23","23","'Bhɛ yrɛ do 'ɛ ꞊nɔɔ bhe, 'ke lii ‑yɔɔ' zan do 'pwɛle ‑a ‑yi ‑o pleŋ‑ Zuufu mu a daanfɛ' 'ɛ ꞊la, 'bhɛɛ‑ 'ke 'bhɛ ‑gbekanle 'sanle 'kree 'ke 'bhɛ 'a pe dɔɔ: ");
INSERT INTO moa_vpl VALUES ("MK1_24","071_1_24","MRK","1","24","24","«‑Mɛle 'o mɔɔ 'pegee 'bhi 'pleŋ‑ Nazarɛti mi Zesu? 'E ꞊nwa 'o 'niyrɛ‑ ‑la nɔɔ‑ ɛɛ? Mi 'e dɔ kpataakpa, 'bhi ‑le 'ke Mɛɛ 'Weŋ 'la ‑daa ‑Waanbhaa' ba 'bhɛ 'le!» ");
INSERT INTO moa_vpl VALUES ("MK1_25","071_1_25","MRK","1","25","25","Zesu 'pɛɛnna‑ 'yee‑ lii ‑yɔɔ' 'ɛ ta dɔɔ: «'E taga, 'bhɛɛ‑ 'e go mɛɛ 'lɛɛ‑ zi 'saanibhe!» ");
INSERT INTO moa_vpl VALUES ("MK1_26","071_1_26","MRK","1","26","26","'Bhɛ klɛle 'tɛ, lii ‑yɔɔ' 'ɛ go bhla 'ɛ zi, 'kee‑ mɛɛ 'ɛ bɛɛnle‑ ‑kpakpa 'kee‑ ‑gbekanle 'eglɔɔle. ");
INSERT INTO moa_vpl VALUES ("MK1_27","071_1_27","MRK","1","27","27","Mɛɛ mu 'ɛ ‑o 'kpɛn 'liibhaala ‑o ma, 'fɔke ‑woo 'eke‑ ‑lrɔkpale ‑saan dɔɔ: «‑Mɛ pɛ ‑za ‑le ‑gee' ɛɛ? ‑Mɛ pɛ mɛɛ daangbɛya drɛɛ 'ɛ ‑dele ‑gee' 'seŋ 'le! 'Ali‑ ‑a drɔɔn' ‑janwo' lii ‑yɔɔ' mu ni faŋgan‑ ma, 'bhɛɛ 'mu 'a 'weli‑ ma!» ");
INSERT INTO moa_vpl VALUES ("MK1_28","071_1_28","MRK","1","28","28","'Bhɛ yrɛ do 'ɛ ꞊nɔɔ bhe, 'ke Zesu 'tɔbhɔleya 'ɛ zɛnle‑ Galile 'klɛɛn 'ɛ 'kpɛn 'yi. ");
INSERT INTO moa_vpl VALUES ("MK1_29","071_1_29","MRK","1","29","29","‑O 'pwɛle‑ *Zuufu mu a daanfɛ' 'ɛ ꞊la, 'ke 'yee‑ 'pegee Zaki 'bhɛɛ‑ Zaan ‑o gele‑ Simɔ 'pegee Andre mu ba 'fɛ 'lɛ ma. ");
INSERT INTO moa_vpl VALUES ("MK1_30","071_1_30","MRK","1","30","30","Simɔ boole yilale ‑yaa, 'bhɛ 'flɛ 'yi 'yaa‑ ‑la 'zi. 'Bhɛ yrɛ do 'ɛ ꞊nɔɔ bhe 'tɛ, 'ke ‑o 'bhɛ a gaza 'ɛ pele Zesu ni. ");
INSERT INTO moa_vpl VALUES ("MK1_31","071_1_31","MRK","1","31","31","Zesu 'e 'mabɛɛnle ‑a ‑din, 'ke ‑ya 'kunle ‑a gbɛ ma, 'bhɛɛ‑ 'ke ‑ya 'lawlɛnle. 'Bhɛ 'waati do 'kpɔ 'ɛ ba, 'ke ‑yaa' 'flɛ 'yila ga 'ɛ gole‑ ‑a ma, 'bhɛɛ‑ 'ke ‑yoo ‑lɛwɛɛ' kpo klɛle‑. ");
INSERT INTO moa_vpl VALUES ("MK1_32","071_1_32","MRK","1","32","32","'Bhɛ yroma 'ɛ zi, ‑yretɛbhɛ baale' blaan, 'ke ‑waa' ‑wa 'ɛ ta mu 'ɛ 'nule ‑waa' gadɛ mu 'ɛ 'kpɛn 'pegee 'zina mu 'yaa‑ mɛɛ mu 'la zan zi 'mu 'le Zesu ni. ");
INSERT INTO moa_vpl VALUES ("MK1_33","071_1_33","MRK","1","33","33","‑Wa 'ɛ ta mu 'ɛ 'kpɛn ‑o ‑lɛkpaa 'fɛ 'ɛ 'lɛ ma. ");
INSERT INTO moa_vpl VALUES ("MK1_34","071_1_34","MRK","1","34","34","‑Ga ‑glɔɔn 'oo ga ‑glɔɔn 'la 'yaa‑ mɛɛ mu 'ɛ ma, Zesu 'mu 'kpɛn 'bheela‑. 'Bhɛɛ‑ 'ezin‑, ‑e 'zina ‑bebe ꞊gbian mɛɛ mu zi, yaa ‑yaa dɔ 'zi 'a ‑la 'ke 'zina mu 'ɛ ‑janwo' yrɛ ‑srɔɔwo' ‑a 'kɔɔ, ‑amasrɔyi ‑e ‑yaa 'ke mɛɛ ‑glɔɔn 'la 'le 'mu 'yaa‑ 'bhɛ dɔ. ");
INSERT INTO moa_vpl VALUES ("MK1_35","071_1_35","MRK","1","35","35","Zrwan 'tutu 'ɛ zi, 'sani‑ yrɛ ma 'kanle‑ pleŋ‑, Zesu 'e 'wlɛnle‑, 'kee‑ 'pwɛle 'fɛ 'ɛ ꞊la, 'bhɛɛ‑ 'kee‑ gele‑ ‑a 'seriwolɛ ‑bɔn 'yi yrɛ do ꞊nɔɔ. ");
INSERT INTO moa_vpl VALUES ("MK1_36","071_1_36","MRK","1","36","36","'Bhɛ blaan sa, 'ke Simɔ 'pegee mɛɛ 'la zan mu ‑yaa 'yee‑ Zesu zi, 'mu gele‑ ‑a ziglinlɛ 'tɛ. ");
INSERT INTO moa_vpl VALUES ("MK1_37","071_1_37","MRK","1","37","37","'Bhɛɛ‑ 'mu 'tɛnle‑ ‑a ma 'tɛ, 'ke ‑wa pele‑ ‑a ni dɔɔ: «Mɔkpɛn' ‑o 'e ‑glin 'zi.» ");
INSERT INTO moa_vpl VALUES ("MK1_38","071_1_38","MRK","1","38","38","'Bhɛ klɛle 'tɛ, 'ke ‑ya pele‑ ‑o ni dɔɔ: «‑Kɔɔ' ge yrɛ ‑bhɛɛke' ꞊nɔɔ, kpɛma ‑wa mu 'ɛ ta, 'kooko‑ 'ŋ ‑Waanbhaa ‑a ‑jan 'ɛ 'ke 'wo 'ezin‑ 'mu ꞊nɔɔ ye. ‑Amasrɔyi 'ŋ ꞊nwa 'bhɛɛ‑ 'kaama‑ 'trɛ 'lɛɛ‑ ta.» ");
INSERT INTO moa_vpl VALUES ("MK1_39","071_1_39","MRK","1","39","39","'Bhɛ 'yi bhe, 'kee‑ gele‑ ‑Waanbhaa' a ‑jan 'ɛ 'wolɛ‑ Zuufu mu a daanfɛ' mu 'ɛ ꞊la Galile 'klɛɛn 'yi yrɛkpɛn‑ ꞊nɔɔ, 'bhɛɛ‑ 'kee‑ 'zina mu gbin mɛɛ mu zi. ");
INSERT INTO moa_vpl VALUES ("MK1_40","071_1_40","MRK","1","40","40","‑Kpaandɛ' mi do 'e 'mabɛɛnna Zesu ‑din, 'ke ‑ya 'kpɔ zɛnle‑ Zesu ‑lɛɛ, 'bhɛɛ‑ 'kee‑ ‑sromabɔle 'bhɛ ni dɔɔ: «'Kee‑ ꞊swa 'e ni, 'e sɔ 'ŋ 'bheele.» ");
INSERT INTO moa_vpl VALUES ("MK1_41","071_1_41","MRK","1","41","41","‑A ‑yrɛn 'kpɛn ꞊klaa Zesu ma, 'ke 'bhɛ 'e gbɛ 'trole ‑a ba, 'ke 'bhɛ 'e gbɛ 'kpale ‑a ma, 'bhɛɛ‑ 'ke 'bhɛ 'a pele‑ ‑a ni 'kaa: «'Ŋ ‑yoo ‑a zi 'bhii‑ 'e 'bhee‑.» ");
INSERT INTO moa_vpl VALUES ("MK1_42","071_1_42","MRK","1","42","42","'Bhɛ yrɛ do 'kpɔ 'ɛ ꞊nɔɔ bhe, 'ke ‑a ma ‑kpaan 'ɛ gole‑, 'ke ‑a 'flɛ klɛle‑ 'weŋ. ");
INSERT INTO moa_vpl VALUES ("MK1_43","071_1_43","MRK","1","43","43","'Bhɛɛ‑ Zesu 'yaa‑ 'ploo zii' 'a ma bhla 'la ba 'ke ‑ya ‑lɛmazɔnle dɔɔ: ");
INSERT INTO moa_vpl VALUES ("MK1_44","071_1_44","MRK","1","44","44","«'E 'gbu 'klɔsikun 'dɛ, 'yaa 'bhɛ ‑jan 'ɛ 'wolɛ‑ mɛɛ 'kedo‑ 'kpɔ ni. 'Duŋ‑ ge 'sraka 'lɛna mi 'ɛ ba, 'bhɛɛ‑ 'yee‑ maglin‑ doo, 'bhɛɛ‑ *Moizi 'sraka 'la goza ꞊pia ‑kpaandɛ' mu ‑bheeza' 'ɛ 'yi, 'bhɛ 'sraka 'ɛ go, 'kooko‑ 'ya zrɔn mɔkpɛn' ni 'bhii‑ 'yaa‑ ‑kpaan 'ɛ ‑gwa.» ");
INSERT INTO moa_vpl VALUES ("MK1_45","071_1_45","MRK","1","45","45","'Duŋ‑ 'yee‑ mɛɛ 'ɛ gele, 'ke ‑ya ‑bheeza' 'ɛ 'woŋwoŋzɛnle, ‑asiikɔɔ Zesu 'laa ‑yaa sɔ wlale ‑li ‑wa 'kedo‑ 'kpee mɛɛ mu 'ɛ yrɛ ma. ‑Ayile ‑e ꞊bwa ‑bɔn 'ɛ 'yi, 'bhɛɛ‑ mɛɛ mu 'ɛ 'yaa‑ da 'zi yrɛkpɛn‑ ꞊nɔɔ 'ke ‑o ge 'tɛnlɛ‑ a ma 'bhɛ ꞊nɔɔ ye. ");
INSERT INTO moa_vpl VALUES ("MK2_1","071_2_1","MRK","2","1","1","‑Yrekpaa' 'dama 'kanle‑ blaan, 'ke Zesu 'nule 'ezin‑ Kapɛnɔmu. Mɛɛ mu 'ɛ ‑wa male 'kaa ‑yoo 'fɛ 'lɛ ma, ");
INSERT INTO moa_vpl VALUES ("MK2_2","071_2_2","MRK","2","2","2","'ke mɛɛ 'srɛ 'lɛdo‑ nule‑ ‑o 'lɛkpalɛ 'eke‑ ta 'fɛ 'ɛ ꞊la ‑a zi, ‑asiikɔɔ 'kanyrɛ‑ laa ‑yaa sɔ ‑srɔɔwole 'fɛ 'ɛ 'lii. 'Bhɛɛ‑ Zesu 'yaa‑ ‑Waanbhaa' a ‑jan 'ɛ 'wo zii' ‑o ni. ");
INSERT INTO moa_vpl VALUES ("MK2_3","071_2_3","MRK","2","3","3","'Bhɛ ꞊nɔɔ bhe, 'ke mɛɛ yiziɛ nule‑ ‑flugba do 'le ‑a ba yrɔ do 'yi. ");
INSERT INTO moa_vpl VALUES ("MK2_4","071_2_4","MRK","2","4","4","'Bhɛ mɛɛ mu 'ɛ waa 'sɔlɛ‑ gele‑ 'tɛnlɛ‑ Zesu ma ‑trɛɛ, 'ke ‑wa zrɔn 'bhɛ ni ‑zamaa' 'ɛ 'kɔɔ. 'Bhɛla‑ ‑yile, 'ke ‑woo wlayrɛ do klɛle‑ 'yee‑ Zesu 'yaa‑ 'fɛ 'la ꞊la 'bhɛ 'wiiŋ‑. 'Bhɛɛ‑ 'ke ‑o ‑flugba' 'ɛ 'pegee ‑a 'yila‑ yrɔ 'ɛ zinale 'bhɛ yrɛ 'ɛ ꞊nɔɔ bhlɛ ma. ");
INSERT INTO moa_vpl VALUES ("MK2_5","071_2_5","MRK","2","5","5","Zesu 'a 'yele‑ 'bhii‑ ‑woo ‑kpaa ‑a 'yi, 'bhii‑ ‑e sɔ ‑flugba 'ɛ 'bheele, 'ke ‑ya 'pele 'yee‑ ‑flugba 'ɛ ni 'kaa: «'Ŋ 'nɛ, 'ŋ 'yaa‑ ‑za 'yɔɔ‑ mu 'ɛ ‑sroma ‑yaan.» ");
INSERT INTO moa_vpl VALUES ("MK2_6","071_2_6","MRK","2","6","6","'Bhɛ ꞊nɔɔ bhe, 'Toŋ daan mu 'la 'yaale‑ ‑yaa 'fɛ 'ɛ ꞊la ‑zamaa' 'ɛ 'pleŋ‑ 'ke 'mu 'a pele‑ 'mu 'kpee 'tɛ dɔɔ: ");
INSERT INTO moa_vpl VALUES ("MK2_7","071_2_7","MRK","2","7","7","«‑Mɛle ‑kla 'bhɛɛ‑ 'gwlaan‑ 'lɛɛ‑ ‑yoo ‑janwo' zii' ‑gee' ɛɛ? ‑E ‑Waanbhaa' 'tɔsiɛ ma jan ‑la wo 'zi bhe. Bhaaplɛŋ 'ɛ ‑de 'gbu ‑le sɔ mɛɛ mu a ‑za 'yɔɔ‑ mu ‑sroma 'yanle 'ke ya 'e go ‑Waanbhaa' do ‑kplɛn ba ɛɛ?» ");
INSERT INTO moa_vpl VALUES ("MK2_8","071_2_8","MRK","2","8","8","'Bhɛ yrɛ do 'ɛ ꞊nɔɔ bhe, 'ke Zesu ‑o 'kpeejan‑ 'ɛ dɔle‑. 'Bhɛɛ‑ 'ke ‑ya pele‑ ‑o ni 'kaa: «‑Mɛle ‑kla 'ka ‑o 'bhɛ ‑jan ‑glɔɔn 'ɛ dan 'zi 'ka 'kpee ɛɛ? ");
INSERT INTO moa_vpl VALUES ("MK2_9","071_2_9","MRK","2","9","9","'Woo‑ ‑za plɛ 'gbu 'lɛɛ‑ ‑o ‑dele 'edile ɛɛ, ‑a pele ‑flugba 'ɛ ni dɔɔ 'ŋ ‑yaa' ‑za 'yɔɔ mu 'ɛ ‑sroma ‑yaan taa‑ ‑a pele ‑a ni dɔɔ ‑ya ‑wlɛn ɛɛ, 'bhɛɛ‑ ‑e 'taawo‑ ɛɛ? ");
INSERT INTO moa_vpl VALUES ("MK2_10","071_2_10","MRK","2","10","10","'Duŋ‑ 'ŋ 'yoo‑ ‑a zi 'kaa‑ 'yaango‑ 'bhii‑ ‑za 'yɔɔ‑ mu ‑sroma 'yan 'seŋ ‑o 'mi Bhaaplɛŋ Gbe 'ɛ ni 'trɛ 'ɛ ta ‑gɛ.» 'Bhɛ 'yi 'ke ‑ya pele‑ ‑flugba' 'ɛ ni dɔɔ: ");
INSERT INTO moa_vpl VALUES ("MK2_11","071_2_11","MRK","2","11","11","«'Mi 'gbu pe ni dɔɔ: 'E 'wlɛn‑, 'e 'yila‑ yrɔ 'ɛ 'si, 'bhɛɛ‑ ge 'e ba ‑lɛ ma!» ");
INSERT INTO moa_vpl VALUES ("MK2_12","071_2_12","MRK","2","12","12","'Bhɛ yrɛ do 'ɛ ꞊nɔɔ bhe, 'ke ‑flugba 'ɛ ‑ya ‑wlɛnle', 'ke ‑ya yila‑ yrɔ 'ɛ binale, 'bhɛɛ‑ 'kee‑ 'pwɛle mɔkpɛn' 'yrɛ ma. ‑O 'kpɛn 'liibhaa gbɛ ‑yɔɔ 'ɛ 'kɔɔ ‑o ma 'ke ‑o ‑Waanbhaa' 'tɔbhɔle, 'ke ‑wa pe dɔɔ: «'Waa 'bhɛ ‑za 'lɛɛ 'bhɛ 'yansi klɛyrɛ yelɛ ‑lido'.» ");
INSERT INTO moa_vpl VALUES ("MK2_13","071_2_13","MRK","2","13","13","'Bhɛ blaan, 'ke Zesu gele‑ 'ezin‑ Galile ‑draa 'ɛ 'lɛ ma. 'Bhɛɛ‑ 'ke eyee‑ ‑zamaa' 'srɛ ‑gbɛnɛ do 'ɛ 'kpɛn gele‑ ‑a zi 'bhɛ ꞊nɔɔ ye; 'bhɛɛ‑ ‑e ꞊bwa 'bhɛ mɛɛ mu 'ɛ daanle ma. ");
INSERT INTO moa_vpl VALUES ("MK2_14","071_2_14","MRK","2","14","14","‑A 'kan bhla 'ɛ zi, 'ke ‑a ‑yrɛkpale Alife gbe Levi 'yaale‑ ma 'nisra gbawo 'fɛ 'ɛ ꞊la. ‑E pe 'bhɛ ni 'kaa: «Nu dɔ 'ŋ zi!» 'Bhɛɛ‑ 'ke Levi 'e 'wlɛnle‑, 'kee‑ gele‑ dɔlɛ Zesu zi. ");
INSERT INTO moa_vpl VALUES ("MK2_15","071_2_15","MRK","2","15","15","'Bhɛ 'yi bhe 'tɛ, 'ke Zesu gele‑ pɛbhlelɛ 'yee‑ Levi a 'fɛ 'ɛ ꞊la. 'Nisrakun mu ‑bebe 'pegee mɛɛ 'joo 'yɔɔ‑ 'ke mu 'pegee 'yee‑, 'bhɛɛ‑ ‑yaa' ‑klaŋlanɛ mu 'ɛ 'yaa‑ pɛbhle 'zi 'eke‑ zi, ‑amasrɔyi ‑o 'srɛ 'ɛ dɔle ‑yaa zi. ");
INSERT INTO moa_vpl VALUES ("MK2_16","071_2_16","MRK","2","16","16","'Duŋ‑ 'Toŋ daan mu 'la 'yaa‑ Farizi mu ‑lɛdo' 'ɛ ba, 'mu 'yrɛkpale Zesu ma pɛleyrɛ 'ɛ ꞊nɔɔ 'ke 'nisrakun mu 'ɛ 'pegee mɛɛ 'joo 'yɔɔ‑ mu 'ɛ 'le, 'ke ‑wa pele‑ ‑yaa' ‑klaŋlanɛ mu 'ɛ ni 'kaa: «‑Mɛle ꞊kla 'bhɛɛ‑ 'ka daan mi 'ɛ 'pegee 'nisrakun mu 'ɛ, 'bhɛɛ‑ mɛɛ 'joo 'yɔɔ‑ mu 'ɛ ‑woo pɛbhle 'zi 'eke‑ ta ɛɛ?» ");
INSERT INTO moa_vpl VALUES ("MK2_17","071_2_17","MRK","2","17","17","Zesu ‑o wojan 'ɛ 'male, 'ke ‑ya pele‑ ‑o ni dɔɔ: «Mɛɛ 'klɛnyawole mu maza laa ‑o ‑laanɛkpa mi ma, 'fɔ gadɛ mu. 'Naa 'nulɛ‑ mɛɛ 'la zan mu ‑o 'gbu ye 'bhii‑ mɛɛ ‑lɛdɔɔle mu 'mu 'siiyrɛ‑ ꞊nɔɔ, 'duŋ‑ 'mi ꞊nwa mɛɛ 'la zan mu 'mu 'gbu ye 'bhii‑ ‑za 'yɔɔ‑ klɛ mu 'mu ‑la 'siiyrɛ‑ nɔɔ‑.» ");
INSERT INTO moa_vpl VALUES ("MK2_18","071_2_18","MRK","2","18","18","Yi do ta, Mɛɛ Wiiŋfɛ' Mi Zaan a ‑klaŋlanɛ mu 'ɛ 'pegee Farizi mu 'ɛ 'yaa‑ 'suŋ 'yi. 'Bhɛɛ‑ mɛɛ 'ke mu ꞊nwa Zesu ‑lrɔkpalɛ dɔɔ: «‑Mɛle ꞊kla 'bhɛɛ‑ Zaan a pɛ ‑klaŋlanɛ mu 'ɛ 'pegee Farizi mu 'ɛ ‑waa' ‑klaŋlanɛ mu 'ɛ ‑woo 'suŋ 'yi, 'bhɛɛ‑ 'duŋ‑ 'yaa‑ pɛ ‑klaŋlanɛ mu 'ɛ waa ‑o 'suŋ 'yi ɛɛ?» ");
INSERT INTO moa_vpl VALUES ("MK2_19","071_2_19","MRK","2","19","19","Zesu 'a zikpaa‑ ‑o ni dɔɔ: «Le drɛɛ ‑nɔɔ 'ɛ 'bhɛgwlɛn‑ mu 'ɛ sɔ 'suŋwlale 'ke le drɛɛ ‑nɔɔ 'ɛ 'bhɛ ‑o ‑o ‑din 'waati 'la ba ɛɛ? Waa sɔ 'bhɛ klɛle‑, 'ke le drɛɛ ‑nɔɔ 'ɛ 'bhɛ ‑o ‑o ‑din 'waati 'la ba, waa sɔ 'suŋwlale. ");
INSERT INTO moa_vpl VALUES ("MK2_20","071_2_20","MRK","2","20","20","'Duŋ‑ 'bhɛ 'waati ‑o zan bhɔlɛ, 'ke le drɛɛ ‑nɔɔ 'ɛ gole ‑yaan ‑o ‑din. 'Bhɛ 'waati 'ɛ ba, ‑o nu 'suŋwlalɛ 'tɛ.» ");
INSERT INTO moa_vpl VALUES ("MK2_21","071_2_21","MRK","2","21","21","«Mɛɛ do 'kpɔ 'laa sɔ dunɛ‑ gwe ‑yisrale 'ke sɔpee' drɛɛ 'le. 'Kee‑ 'bhɛ ꞊kla, sɔpee' drɛɛ 'ɛ 'wlayrɛ‑ nɔɔ‑ 'eke‑ ta, ‑e nu dunɛ‑ gwe 'ɛ 'bhɛ sɔ 'ɛ ‑glaanlɛ' 'bhɛɛ‑ ‑e 'bhɛ 'peedɛ‑. 'Bhɛɛ‑ dunɛ‑ gwe 'ɛ nu 'peedɛlɛ 'ezin‑, 'ke 'bhɛ kan ‑a 'peedɛyrɛ ‑lwa 'ɛ ta. ");
INSERT INTO moa_vpl VALUES ("MK2_22","071_2_22","MRK","2","22","22","'Ezin‑, mɛɛ 'kedo‑ 'kpɔ 'laa sɔ ‑wɛɛn drɛɛ 'klale wi 'flɛ 'floko gwe mu 'yi, 'bhɛɛ‑ ‑e 'mu 'liitan‑. 'Kee‑ 'bhɛ ꞊kla, ‑wɛɛn drɛɛ 'ɛ 'pliiyrɛ‑ nɔɔ‑, ‑e nu 'floko gwe mu 'ɛ 'peedɛlɛ, 'bhɛɛ‑ 'yee‑ ‑wɛɛn 'ɛ klalaa' 'trɛ ma. 'Duŋ‑ ‑o ‑wɛɛn drɛɛ 'ɛ 'kla wi 'flɛ 'floko drɛɛ mu ‑la ‑yi.» ");
INSERT INTO moa_vpl VALUES ("MK2_23","071_2_23","MRK","2","23","23","‑Yitrɛ' yi do ma, Zesu 'pegee mɛɛ 'ke mu ‑yaa 'kan zii' ble gba mu 'yi. 'Bhɛ ꞊nɔɔ bhe, 'ke ‑yaa' ‑klaŋlanɛ mu 'ɛ ‑o dɔle‑ ble ‑vlɔ mu 'la 'yaa‑ zibhɛ 'ɛ 'trɔn ta 'mu bhɛ mu 'ɛ 'srɔnle‑ ma, 'ke ‑o 'mu ‑glɔɔ ‑o 'kɔɔ, 'bhɛɛ‑ ‑o 'mu bhɛ mu 'ɛ bhle. ");
INSERT INTO moa_vpl VALUES ("MK2_24","071_2_24","MRK","2","24","24","'Bhɛ klɛle 'tɛ, 'ke Farizi mu 'ɛ ‑wa pele‑ Zesu ni dɔɔ: «'E 'yrɛkpa, ‑mɛle ꞊kla 'bhɛɛ‑ 'yaa‑ ‑klaŋlanɛ mu 'ɛ ‑woo ble bhɛ mu 'ɛ 'srɔn zii' 'ke ‑woo bhle ɛɛ? 'Bhɛɛ‑ 'duŋ‑, ‑kɔɔa' 'toŋ 'ɛ ta, waa 'bhɛ ‑za ‑glɔɔn 'ɛ klɛ ‑yitrɛ' yi ma.» ");
INSERT INTO moa_vpl VALUES ("MK2_25","071_2_25","MRK","2","25","25","'Bhɛ ꞊nɔɔ bhe, 'ke Zesu 'a zikpale ‑o ni dɔɔ: «‑Bhleŋgbe Davidi ‑za 'la ꞊kla 'elwale ‑sɔ, 'ka mu laa 'bhɛ ‑za 'ɛ tapelɛ ‑lido' ɛɛ? 'Ŋ bhe, ‑yrekpaa' do, gbɔn 'yee Davidi 'gbu 'pegee ‑a zi mɛɛ mu 'ɛ ꞊dia, 'bhɛɛ‑ pɛle 'kedo‑ 'kpɔ 'laa ‑yaa ‑o 'kɔɔ. ");
INSERT INTO moa_vpl VALUES ("MK2_26","071_2_26","MRK","2","26","26","'Bhɛ 'waati 'ɛ ba, Abiataa ‑le ‑yaa 'ke 'sraka 'lɛna mu a ‑kuŋlii gblaan 'ɛ 'le. ‑O 'bluu mu 'la ‑gwa 'ke sraka 'le ‑Waanbhaa' ni, ‑kɔɔa' 'toŋ 'ɛ ta, mɛɛ ‑bhɛɛke' do 'kpɔ 'laa ‑yaa sɔ 'mu bhlele' 'ke ‑yaa 'e go 'sraka 'lɛna mu do ‑kplɛn ba. 'Duŋ‑ 'yee‑ Davidi ꞊wlaa ‑Waanbhaa' gba 'fɛ 'ɛ ꞊la, 'bhɛɛ‑ ‑e 'bhɛ 'bluu mu 'ɛ ꞊bhla, 'bhɛɛ‑ ‑ya 'ke ꞊naa ‑a zi mu 'ɛ ni.» ");
INSERT INTO moa_vpl VALUES ("MK2_27","071_2_27","MRK","2","27","27","'Bhɛ blaan, Zesu pe ‑o ni 'ezin‑ 'kaa: «‑Waanbhaa' ‑yitrɛ' yi 'ɛ ꞊kla bhaaplɛŋ ‑la ‑nrayiza 'yi, 'duŋ‑ yaa bhaaplɛŋ klɛlɛ ‑yitrɛ' yi ‑zayi'. ");
INSERT INTO moa_vpl VALUES ("MK2_28","071_2_28","MRK","2","28","28","'Bhɛla‑ ‑yile, Bhaaplɛŋ Gbe 'ɛ 'bhɛ ‑le 'ke ‑yitrɛ' yi 'ɛ zan 'le.» ");
INSERT INTO moa_vpl VALUES ("MK3_1","071_3_1","MRK","3","1","1","Zesu wla gbɛ drɛɛwoa‑ *Zuufu mu daanfɛ' 'ɛ ꞊la. Mɛɛ gbɛ 'kwlanle‑ do ‑yaa 'bhɛ yrɛ 'ɛ ꞊nɔɔ ye. ");
INSERT INTO moa_vpl VALUES ("MK3_2","071_3_2","MRK","3","2","2","Farizi mu 'ɛ 'yaa‑ Zesu klɔsikun zii', 'kooko‑ 'kee‑ 'bhɛ mɛɛ gbɛ 'kwlanle‑ 'ɛ 'bheela‑ ‑yitrɛ' yi 'ɛ ma, 'bhɛɛ‑ ‑o la ‑a ta dɔɔ yaa ‑yitrɛ' yi 'toŋ 'ɛ 'klɔsikunlɛ. ");
INSERT INTO moa_vpl VALUES ("MK3_3","071_3_3","MRK","3","3","3","Zesu pe mɛɛ gbɛ 'kwlanle‑ 'ɛ ni: «'E 'wlɛn‑, 'bhɛɛ‑ nu dula‑ mɔkpɛn' 'pleŋ‑ ‑gɛ!» ");
INSERT INTO moa_vpl VALUES ("MK3_4","071_3_4","MRK","3","4","4","'Bhɛ blaan, 'ke Zesu ‑o ‑lrɔkpale dɔɔ: «‑Yitrɛ' yi 'ɛ ma, ‑a 'seŋ ‑o mɛɛ ni 'kee‑ ‑za 'wlan klɛ mɛɛ ni taa‑ 'kee‑ ‑za 'yɔɔ‑ klɛ mɛɛ ni ɛɛ, 'bhɛɛ‑ ‑a 'seŋ ‑o ‑a ni 'kee‑ mɛɛ go ‑za 'yi taa‑ 'ke ‑ya to 'bhɛɛ‑ ‑e ga ɛɛ?» ‑O ‑kpɛn tagale ꞊bwa. ");
INSERT INTO moa_vpl VALUES ("MK3_5","071_3_5","MRK","3","5","5","'Bhɛ 'yi 'tɛ, 'ke ‑ya ‑yrɛ 'mliŋgole ‑o ta ‑a zrupliile 'le. 'Bhɛɛ‑ 'ke ‑ya wlɛyisriwole ‑o zru ‑yɔɔya' 'ɛ ma. 'Bhɛ klɛle 'tɛ, 'ke ‑ya 'pele‑ mɛɛ gbɛ 'kwlanle‑ 'ɛ ni: «'E gbɛ 'ɛ 'yisrɔn!» 'Ke ‑ya 'yisrɔnle, 'bhɛɛ‑ 'kee‑ ‑bheele'. ");
INSERT INTO moa_vpl VALUES ("MK3_6","071_3_6","MRK","3","6","6","Farizi mu 'ɛ 'pwɛle‑ Zuufu mu a daanfɛ' 'ɛ ꞊la, 'bhɛ yrɛ do 'ɛ ꞊nɔɔ bhe, 'ke ‑o 'pegee ‑bhleŋgbe Erɔdi Antipasi a mɛɛ ‑lɛdo' 'ɛ ‑woo ‑lɛkpale 'eke‑ ta, 'bhɛɛ‑ ‑woo 'eke‑ ꞊ya Zesu dɛza 'ɛ 'yi. ");
INSERT INTO moa_vpl VALUES ("MK3_7","071_3_7","MRK","3","7","7","'Bhɛ blaan, 'ke Zesu 'pegee ‑yaa' ‑klaŋlanɛ mu 'ɛ ‑o gele‑ Galile ‑draa 'ɛ ba ‑yrɛ ta. 'Bhɛ 'yi 'tɛ, 'ke ‑zamaa' 'srɛ ‑gbɛnɛ do gele‑ ‑o zi 'bhɛ ꞊nɔɔ ye. Mɛɛ 'ke mu ‑daa Galile 'klɛɛn 'ɛ 'yi, ‑a 'ke mu ‑daa Zude, ");
INSERT INTO moa_vpl VALUES ("MK3_8","071_3_8","MRK","3","8","8","‑a 'ke mu ‑daa Zeruzalɛmu, ‑a 'ke mu ‑daa Idume, ‑a 'ke mu ‑daa Zrudɛn yue ba ‑yrɛta' ‑wa mu 'ɛ ta, ‑a 'ke mu ‑daa 'fɔ Tiri 'pegee Sidɔn 'trɛ mu 'ɛ ‑din ‑wa mu 'ɛ ta. 'Bhɛ ‑zamaa' 'srɛ ‑gbɛnɛ do 'lɛɛ‑ ꞊nwa Zesu ‑glinlɛ', ‑amasrɔyi, ‑e ‑za mu 'la 'kpɛn ꞊kla, ‑o 'mu ꞊maa. ");
INSERT INTO moa_vpl VALUES ("MK3_9","071_3_9","MRK","3","9","9","Zesu pe ‑yaa' ‑klaŋlanɛ mu 'ɛ ni 'kaa ‑o ‑yitakoŋ 'nɛ do mabɛɛn ‑a ‑din ‑zamaa' 'ɛ ‑zayi', 'kooko‑ mɛɛ mu 'ɛ waa nu 'palɛ‑ 'ŋ ta. ");
INSERT INTO moa_vpl VALUES ("MK3_10","071_3_10","MRK","3","10","10","Wlan 'ɛ ni, Zesu 'yaa‑ mɛɛ ‑bebe 'la 'bhee zii' bhe, ‑asiikɔɔ ga ‑yaa mɛɛ 'la za mu 'kpɛn ma, 'mu 'yaa‑ 'pa zii' ‑a ta 'mu gbɛ yan zayi' ‑a ma. ");
INSERT INTO moa_vpl VALUES ("MK3_11","071_3_11","MRK","3","11","11","Lii ‑yɔɔ' mu ‑yaa mɛɛ 'la zan mu zi, 'ke 'mu 'yaa‑ ‑a ye, 'mu ‑yaa nu 'mu 'kpɔ zɛnlɛ ‑a ‑lɛɛ, 'bhɛɛ‑ 'bhɛ mu ‑yaa ‑gbekan' 'ke ‑wa pe dɔɔ: «'Bhi ‑le 'ke ‑Waanbhaa' Gbe 'ɛ 'le.» ");
INSERT INTO moa_vpl VALUES ("MK3_12","071_3_12","MRK","3","12","12","'Duŋ‑ Zesu 'yaa‑ ‑yran 'zi ‑o zi 'eglɔɔle dɔɔ: «'Ka 'laa 'ŋ ta 'pwɛlɛ‑ dɔɔ 'mi ‑le 'ke *‑Waanbhaa' Gbe 'ɛ 'le.» ");
INSERT INTO moa_vpl VALUES ("MK3_13","071_3_13","MRK","3","13","13","'Bhɛ blaanta, 'ke Zesu gele‑ 'sanlɛ‑ vlɛ gɔɔn do wiiŋ‑, 'bhɛɛ‑ ‑e ‑yaa mɛɛ 'la zan mu zi, ‑e 'mu 'siila‑; 'bhɛɛ‑ 'mu ꞊nwa ‑a ba. ");
INSERT INTO moa_vpl VALUES ("MK3_14","071_3_14","MRK","3","14","14","‑E mɛɛ vu ta plɛ ‑la makwan‑ ‑o ba, 'kooko‑ 'mu bo a ‑din. ");
INSERT INTO moa_vpl VALUES ("MK3_15","071_3_15","MRK","3","15","15","'Bhɛɛ‑ 'kee‑ sɔ 'bhɛ mu 'winbɔle ‑Waanbhaa' a ‑jan 'woyrɛ‑ nɔɔ‑, 'bhɛɛ‑ ‑e 'seŋ ꞊naa 'mu ni 'ke 'mu 'zina mu ‑gbin mɛɛ mu zi. ");
INSERT INTO moa_vpl VALUES ("MK3_16","071_3_16","MRK","3","16","16","‑E mɛɛ vu ta plɛ 'la makwan‑ 'mu 'tɔ ‑le ‑gɛ: Simɔ, ‑e 'bhɛ 'tɔkpaa‑ Piɛri, ");
INSERT INTO moa_vpl VALUES ("MK3_17","071_3_17","MRK","3","17","17","'bhɛɛ‑ Zebede gbe plɛ Zaki 'pegee 'bhɛ ꞊nwagwlɛn Zaan, ‑e 'mu 'tɔkpaa‑ 'ezin‑ Boanɛɛgɛzi, 'bhɛ 'yile‑: ‑gblaŋ' gbe mu. ");
INSERT INTO moa_vpl VALUES ("MK3_18","071_3_18","MRK","3","18","18","'Bhɛɛ‑ Andre 'pegee Filipu, Batremi 'pegee Matie, Toma 'pegee Alife gbe Zaki, Tade 'pegee Simɔ ('bhɛ 'la 'bhɛ 'yaa‑ 'bhɛ a 'klɛɛn ‑vavadɛ bhe), ");
INSERT INTO moa_vpl VALUES ("MK3_19","071_3_19","MRK","3","19","19","'bhɛɛ‑ Zuda Isikariɔti, 'yee‑ 'la 'yaa nu Zesu 'lɛnalɛ 'bhɛ 'sɔɔnnii mu 'ɛ ni. ");
INSERT INTO moa_vpl VALUES ("MK3_20","071_3_20","MRK","3","20","20","'Bhɛ blaan, 'ke Zesu 'pegee ‑yaa' ‑klaŋlanɛ mu 'ɛ ‑o nule‑ 'fɛ 'lɛ ma, 'ke ‑zamaa' do nule‑ ‑o zi 'ezin‑, ‑asiikɔɔ ‑waa ‑yaa pɛbhleyrɛ ‑srɔɔwo' ‑o 'kɔɔ. ");
INSERT INTO moa_vpl VALUES ("MK3_21","071_3_21","MRK","3","21","21","'Bhɛ klɛle 'tɛ, ‑yaa' 'fa ‑la mu 'ɛ 'mu 'bhɛ 'male‑, 'ke 'mu gele‑ ‑a 'kunyrɛ‑ nɔɔ‑, ‑amasrɔyi ‑o ‑yaa pe 'zi 'kaa ‑a ŋgblo ‑wlɛnna. ");
INSERT INTO moa_vpl VALUES ("MK3_22","071_3_22","MRK","3","22","22","'Toŋ daan mu 'la ‑daa Zeruzalɛmu, 'mu 'yaa‑ pe 'zi dɔɔ: «Bɛɛzebuli, ('bhɛ 'yi ‑le 'zina mu ‑kuŋlii' gblaan), 'bhɛ ‑le 'yee‑ Zesu zi. 'Bhɛɛ‑ 'bhɛ ‑le 'zina mu ‑gbin 'seŋ na zii' ‑a ni.» ");
INSERT INTO moa_vpl VALUES ("MK3_23","071_3_23","MRK","3","23","23","'Bhɛ 'yi 'tɛ, 'ke Zesu ‑o 'siile‑, 'bhɛɛ‑ 'kee‑ ‑janwole 'o ni ‑gɔɔn mu 'yi gɔnɛ‑ 'lɛɛ‑ 'bhɛɛ‑ gbɛɛn‑ dɔɔ: «‑Setran' sɔ ‑a 'gbu ‑gbinle' 'nale‑ ‑a ma ɛɛ? ");
INSERT INTO moa_vpl VALUES ("MK3_24","071_3_24","MRK","3","24","24","'Ke ‑bhleŋgbe do a 'klɛɛn 'yi mɛɛ mu 'ɛ gwledan 'eke‑ ba, 'bhɛ ‑bhleŋgbe 'klɛɛn 'ɛ yaa sɔ ‑mɔle'. ");
INSERT INTO moa_vpl VALUES ("MK3_25","071_3_25","MRK","3","25","25","'Bhɛɛ‑ 'ke 'fɛ do ‑la mu gwledan 'eke‑ ba, 'bhɛ 'fɛ 'ɛ wi. ");
INSERT INTO moa_vpl VALUES ("MK3_26","071_3_26","MRK","3","26","26","'Bhɛ klɛgbɛya do 'ɛ 'yi, 'ke ‑Setran' 'wlɛnna‑ ‑a 'gbu ma, 'bhɛɛ‑ 'kee‑ gwledan ‑a 'gbu ba; 'yee‑ ‑Setran' 'gbu ‑a ‑glɔɔya' 'ɛ yaa sɔ ‑mɔle', 'bhɛɛ‑ ‑e yan.» ");
INSERT INTO moa_vpl VALUES ("MK3_27","071_3_27","MRK","3","27","27","«'Ke mɛɛ do ‑o ‑a zi 'bhii‑ ‑e ge wla faŋgan‑ mɛɛ do ba 'fa ꞊la, 'bhɛɛ‑ ‑e 'bhɛ 'kɔɔpɛ‑ mu faan, 'ŋ bhe, ‑e 'bhɛ mɛɛ 'ɛ gbɛ 'pegee 'bhɛ gaan mu 'ɛ yre 'pe. 'Bhɛɛ‑ 'kee‑ ‑yaan 'bhɛ yrelele 'pe, 'bhɛɛ‑ ‑a gbɛsɔ 'bhɛ faŋgan‑ mɛɛ 'ɛ 'bhɛ a 'fa ‑la pɛ mu 'ɛ 'faanle ta. ");
INSERT INTO moa_vpl VALUES ("MK3_28","071_3_28","MRK","3","28","28","Wlan 'ɛ ni, 'mi pe 'ka ni dɔɔ: ‑Waanbhaa' nu bhaaplɛŋ mu a ‑za 'yɔɔ‑ mu 'ɛ 'kpɛn ‑sroma 'yanlɛ‑, 'ke 'bhɛ ge 'kpalɛ‑ ‑wa 'tɔsiɛ ma jan 'mu 'la 'kpɛn ꞊woa 'mu ta. ");
INSERT INTO moa_vpl VALUES ("MK3_29","071_3_29","MRK","3","29","29","'Duŋ‑ 'ke 'bhi 'la ꞊jan 'yɔɔ‑ ꞊woa Lii 'Weŋ 'ɛ ma, ‑Waanbhaa' laa nu 'bhɛ ‑za 'yɔɔ‑ 'ɛ 'sroma‑ 'yanle ‑titi, ‑amasrɔyi 'bhɛ ‑za 'yɔɔ‑ 'kwe 'ɛ nu bolɛ 'e wiiŋ‑ 'yikpɛnsee ta.» ");
INSERT INTO moa_vpl VALUES ("MK3_30","071_3_30","MRK","3","30","30","Zesu ‑janwoa 'Toŋ daan mu 'ɛ ni 'bhɛ gbɛɛn‑ bhe, ‑amasrɔyi 'mu 'yaa‑ pe 'zi dɔɔ lii ‑yɔɔ' ‑o ‑a zi. ");
INSERT INTO moa_vpl VALUES ("MK3_31","071_3_31","MRK","3","31","31","Zesu 'yaa‑ bhla 'la ba 'bhɛ yrɛ 'ɛ ꞊nɔɔ, 'ke ‑a nɛɛ 'pegee ‑a ꞊nwagwlɛn' mu 'ɛ 'nule. ‑O ‑dulaa' 'pɛɛlii‑, 'bhɛɛ‑ 'ke ‑o mɛɛ winbɔle ‑a 'siiyrɛ‑ nɔɔ‑. ");
INSERT INTO moa_vpl VALUES ("MK3_32","071_3_32","MRK","3","32","32","‑Zamaa' 'mliŋgole yaale ‑yaa 'yee‑ Zesu zi, 'bhɛɛ‑ ‑wa ꞊pia ‑a ni dɔɔ: «Dula‑ doo, 'e nɛɛ 'pegee 'e ꞊nwagwlɛn' mu 'ɛ, 'bhɛɛ‑ 'e 'nwale‑ mu 'ɛ ‑woo 'pɛɛlii‑. 'Bhɛɛ‑ ‑o maza 'e ma.» ");
INSERT INTO moa_vpl VALUES ("MK3_33","071_3_33","MRK","3","33","33","Zesu 'a zikpaa‑ ‑o ni dɔɔ: «‑Dele 'ke 'ŋ nɛɛ 'pegee 'ŋ nɛɛnɛ‑ mu 'ɛ 'le ɛɛ?» ");
INSERT INTO moa_vpl VALUES ("MK3_34","071_3_34","MRK","3","34","34","'Ezin‑ 'ke ‑ya ‑yrɛ 'mliŋgole ‑a zi mɛɛ mu 'ɛ ta, 'bhɛɛ‑ 'ke ‑ya pele‑ 'kaa: «'Ŋ nɛɛ 'pegee 'ŋ nɛɛnɛ‑ mu 'ɛ 'wole‑ ‑gɛ. ");
INSERT INTO moa_vpl VALUES ("MK3_35","071_3_35","MRK","3","35","35","Wlan 'ɛ ni, 'ke mɛɛ 'oo mɛɛ 'la ‑Waanbhaa' zru maza klɛ, 'bhɛ zan ‑le 'ke 'ŋ nɛɛ 'pegee 'ŋ nɛɛnɛ‑, 'bhɛɛ‑ 'ŋ nɛɛ ‑nɛ le 'ɛ 'le.» ");
INSERT INTO moa_vpl VALUES ("MK4_1","071_4_1","MRK","4","1","1","'Ezin‑, Zesu ‑dwa mɛɛ mu 'ɛ daanle ma Galile ‑draa 'ɛ gɔɔna. 'Bhɛɛ‑ ‑zamaa' 'srɛ ‑gbɛnɛ do ꞊nwa 'mliŋgolɛ a zi, ‑asiikɔɔ ‑e ‑ja yaalɛ ‑yitakoŋ do 'yi, 'bhɛ ‑yaa ‑yi 'ɛ ta, 'bhɛɛ‑ ‑zamaa' 'ɛ 'yaale‑ ‑yaa ‑yi 'ɛ gɔɔna. ");
INSERT INTO moa_vpl VALUES ("MK4_2","071_4_2","MRK","4","2","2","‑E ‑yaa ‑o daan 'zi ‑za ‑bebe 'le ‑gɔɔn mu ‑la ‑yi, 'bhɛɛ‑ ‑e ‑yaa ‑o daan 'zi bhla 'la ba ‑ya ꞊pia ‑o ni dɔɔ: ");
INSERT INTO moa_vpl VALUES ("MK4_3","071_4_3","MRK","4","3","3","«‑Ka 'ka 'trɔnkpa 'ŋ ni doo: Pɛbhɛ bɔ mi do ‑ja pɛbhɛ bɔyrɛ nɔɔ‑. ");
INSERT INTO moa_vpl VALUES ("MK4_4","071_4_4","MRK","4","4","4","‑E ‑yaa pɛbhɛ mu 'ɛ bɔ 'zi bhla 'la ba ‑yaa' gbabhɛ 'ɛ ta, 'ke pɛbhɛ mu 'ɛ 'lɛdo‑ 'klaale zibhɛ 'ɛ 'lɛzi‑, maannɛ‑ mu 'ɛ ‑daa 'ke 'bhɛ mu 'mu 'bhlele. ");
INSERT INTO moa_vpl VALUES ("MK4_5","071_4_5","MRK","4","5","5","‑A ‑lɛ ‑bhɛɛke' do ‑klalaa' vlɛ gloglo mu 'yi, 'bhɛɛ‑ 'trɛ kplankplan laa ‑yaa ‑o ‑la. Pɛbhɛ mu 'ɛ ‑o ꞊bhwa ‑gun blaale‑, 'duŋ‑ ‑o 'sɛnɛ 'laa gelɛ 'trɛ 'yi 'egbɔɔnle. ");
INSERT INTO moa_vpl VALUES ("MK4_6","071_4_6","MRK","4","6","6","‑Yretɛ' 'pɛɛnle‑ ‑saan bhla 'la ba, 'ke ‑yoo diiŋ ‑nɛ mu 'ɛ dɛle‑, 'ke ‑o gale‑; ‑amasrɔyi ‑o 'sɛnɛ mu 'ɛ waa geyrɛ ‑srɔɔwolɛ 'trɛ 'yi 'egbɔɔnle vlɛ mu 'ɛ 'kɔɔ. ");
INSERT INTO moa_vpl VALUES ("MK4_7","071_4_7","MRK","4","7","7","Pɛbhɛ mu 'ɛ 'lɛdo‑ ‑klalaa' lɛrɛ mu 'ɛ yi. ‑O 'pegee lɛrɛ mu 'ɛ ꞊bhwa 'eke‑ zi, 'ke lɛrɛ 'mu 'ɛ 'kpale ‑o ta, 'bhɛɛ‑ 'ke 'mu ‑o ‑dewole. 'Bhɛɛ‑ waa 'sɔlɛ‑ ‑o bhaa klɛle‑. ");
INSERT INTO moa_vpl VALUES ("MK4_8","071_4_8","MRK","4","8","8","Pɛbhɛ 'ɛ 'lɛdo‑ ‑ja ‑klalaa' 'trɛ ti 'yi. 'Bhɛɛ‑ ‑o ꞊bhwa 'elrele, 'ke ‑o gbaandɛle, 'bhɛɛ‑ 'ke ‑woo ‑bhaale'. ‑O diiŋ do 'bhɛ bhaa mia do bhɛ vu ꞊kla, ‑o diiŋ ‑bhɛɛke' do 'bhɛ bhaa mia yaga ꞊kla, 'bhɛɛ‑ ‑o diiŋ ‑lɛ ‑vindo' 'ɛ 'bhɛ bhaa ‑kɛmɛ do ꞊kla.» ");
INSERT INTO moa_vpl VALUES ("MK4_9","071_4_9","MRK","4","9","9","Zesu 'pe ‑o ni dɔɔ: «'Ke ‑a ‑yima' 'trɔn ‑o mɛɛ 'la zan ŋgblo ma, ‑ya ‑yima'!» ");
INSERT INTO moa_vpl VALUES ("MK4_10","071_4_10","MRK","4","10","10","Zesu 'e 'pleŋgwa‑ ‑zamaa' 'ɛ ma bhla 'la ba, mɛɛ 'la zan mu 'mliŋgole ‑yaa ‑a zi 'mu 'pegee ‑yaa' *‑klaŋlanɛ vu ta plɛ 'ɛ 'mu 'a ‑lrɔkpaa dɔɔ: «‑Gɔɔn mu 'ɛ 'yi ‑o 'nale‑ ɛɛ?» ");
INSERT INTO moa_vpl VALUES ("MK4_11","071_4_11","MRK","4","11","11","'Bhɛ klɛle 'tɛ, ke Zesu 'a zikpale ‑o ni dɔɔ: «'Ka mu 'la 'ka ‑o 'ka 'trɔnkpa zii' 'ŋ ni, ‑Waanbhaa' ‑yaa' ‑bhleŋgbeya gaanyiza mu 'ɛ dɔleya 'ɛ ꞊naa 'ka mu ‑la ni. 'Duŋ‑ mɛɛ ‑vin mu 'ɛ, 'ŋ ‑za mu 'ɛ kpɛn wo 'mu ni ‑gɔɔn mu ‑la ‑yi, ");
INSERT INTO moa_vpl VALUES ("MK4_12","071_4_12","MRK","4","12","12","'kooko‑, ‹'ke ‑woo ‑yrɛkpaa ‑o ta 'elrele, waa sɔ ‑o yele‑, 'bhɛɛ‑ 'ke ‑woo ꞊maa ‑o 'trɔn 'le, waa sɔ ‑o ‑yimale; 'kebhlaale waa nu ‑o zru niinalɛ ‑Waanbhaa' ba, 'bhɛɛ‑ 'bhɛ 'laa ‑waa' ‑za 'yɔɔ‑ mu 'ɛ ‑sroma yan.›» ");
INSERT INTO moa_vpl VALUES ("MK4_13","071_4_13","MRK","4","13","13","Zesu pe ‑o ni dɔɔ: «'Ka 'laa ‑gɔɔn 'lɛɛ‑ 'bhɛ 'yimalɛ ɛɛ? 'Bhɛɛ‑ 'ka nu ‑gɔɔn ‑vin mu 'ɛ 'yimalɛ 'nale‑ ‑a ma ɛɛ?» ");
INSERT INTO moa_vpl VALUES ("MK4_14","071_4_14","MRK","4","14","14","Pɛbhɛ bɔ mi 'ɛ 'bhɛ ‑o 'bhii‑ mɛɛ 'la zan ‑Waanbhaa' a ‑jan 'ɛ bɔ. ");
INSERT INTO moa_vpl VALUES ("MK4_15","071_4_15","MRK","4","15","15","Pɛbhɛ mu 'la ‑klalaa' zibhɛ 'ɛ 'lɛzi‑ 'bhɛ 'yi ‑le dɔɔ mɛɛ 'la zan mu ‑Waanbhaa' a ‑jan 'ɛ ꞊maa, 'bhɛɛ‑ 'ke ‑Setran' 'nule 'bhɛ yrɛ do 'ɛ ꞊nɔɔ bhe blaale‑, ‑o 'bhɛ ‑jan 'la ꞊kpaa ‑o 'kpee 'bhɛ golɛ. ");
INSERT INTO moa_vpl VALUES ("MK4_16","071_4_16","MRK","4","16","16","'Bhɛ klɛgbɛya 'ɛ 'yi, pɛbhɛ ‑bhɛɛke' mu 'la ‑klalaa' vlɛ gloglo mu 'ɛ 'yi, 'bhɛ mu ‑o 'bhii‑ mɛɛ 'la zan mu 'ke ‑o ‑Waanbhaa' a ‑jan ꞊maa, ‑o dɔ ‑a ꞊la 'bhɛ yrɛ do 'ɛ ꞊nɔɔ bhe blaale‑ 'ke ‑o zrukpaale 'le. ");
INSERT INTO moa_vpl VALUES ("MK4_17","071_4_17","MRK","4","17","17","'Duŋ‑ ‑Waanbhaa' a ‑jan 'ɛ 'bhɛ 'laa 'bhɛ 'sɛnɛ gbaan ‑o zru 'ɛ 'yi. ‑Woo kpa 'bhɛ 'yi 'waati sa ba, 'bhɛɛ‑ 'ke ‑woo 'trɛbhɔle ‑saan, 'bhɛ 'pegee 'ke ‑o ‑yrɛnkpale ‑saan ‑o ta bhla 'la ba ‑Waanbhaa' a ‑jan 'ɛ ‑zayi', 'bhɛ yrɛ do 'ɛ ꞊nɔɔ bhe ‑o ploo a ma. ");
INSERT INTO moa_vpl VALUES ("MK4_18","071_4_18","MRK","4","18","18","Mɛɛ 'ke mu ‑o 'bhii‑ lɛrɛ mu 'la pɛbhɛ mu 'ɛ ‑klalaa' 'mu 'yi. 'Ke ‑o ‑Waanbhaa' a ‑jan 'ɛ ꞊maa ‑o dɔ ‑a ꞊la. ");
INSERT INTO moa_vpl VALUES ("MK4_19","071_4_19","MRK","4","19","19","'Bhɛɛ‑ ‑o blina‑ yiɛn bo yikpɛn‑ ta 'drunyan 'lɛɛ‑ 'yi pɛ mu 'ɛ ‑zayi'. ‑O bhla ma ‑naflo mu ‑glin, 'bhɛ 'pegee ‑o zru bhɔle klɛ pɛ ‑glɔɔn 'ɛ 'kpɛn ma, ‑Waanbhaa' a ‑jan 'ɛ yaa boyrɛ ‑srɔɔwo' ‑o zru 'ɛ 'yi, 'bhɛɛ‑ 'bhɛ 'laa ‑za 'kedo‑ 'kpɔ 'yanwo‑ ‑o ma. ");
INSERT INTO moa_vpl VALUES ("MK4_20","071_4_20","MRK","4","20","20","Mɛɛ 'ke mu ‑o 'bhii‑ 'trɛ ti ‑lrele' 'la 'ke pɛbhɛ mu 'ɛ ‑klalaa' 'bhɛ ta. 'Ke ‑o ‑Waanbhaa' a ‑jan 'ɛ ꞊maa, ‑o dɔ a ꞊la, 'bhɛɛ‑ ‑o 'bhɛ 'yizaklɛ: Mɛɛ 'ke mu 'bhɛ 'yi za ‑lrele' klɛ ‑glɔɔn mia do 'bhɛ vu, mɛɛ ‑bhɛɛke' mu 'bhɛ 'yizaklɛ ‑glɔɔn mia yaga, 'bhɛɛ‑ mɛɛ ‑bhɛɛke' mu 'bhɛ 'yizaklɛ ‑glɔɔn ‑kɛmɛ do. ");
INSERT INTO moa_vpl VALUES ("MK4_21","071_4_21","MRK","4","21","21","'Bhɛ blaan, 'ke Zesu ‑o ‑lrɔkpale 'kaa: «‑Laŋbha 'bhile‑ 'ɛ ‑wa dulaa' 'gboŋgbo ‑la ‑la taa‑ mɛɛ yilapɛ ‑la ꞊la ɛɛ? 'Ŋ bhe 'tɛ ‑wa duŋ ‑laŋbha duŋyrɛ 'ɛ 'bhɛɛ‑ ꞊nɔɔ laanima. ");
INSERT INTO moa_vpl VALUES ("MK4_22","071_4_22","MRK","4","22","22","‑Amasrɔyi, pɛ 'oo pɛ 'la gaanle ‑o, 'bhɛ nu 'pwɛlɛ‑ 'tɛbhile ba ‑yrekpaa' do, 'bhɛɛ‑ gaanyiza 'tɔle‑ gaanyiza, 'bhɛ ta nu 'pwɛlɛ‑ 'pɛɛlii‑ mɔkpɛn' 'yrɛ ma. ");
INSERT INTO moa_vpl VALUES ("MK4_23","071_4_23","MRK","4","23","23","'Ke ‑a ‑yima' 'trɔn mɛɛ 'la zan ŋgblo ma, ‑ya ‑yima'.» ");
INSERT INTO moa_vpl VALUES ("MK4_24","071_4_24","MRK","4","24","24","Zesu pe ‑o ni 'ezin‑ dɔɔ: «'Ka ‑o 'kɛla 'ma zii' 'ŋ 'lii, ‑ka 'bhɛɛ‑ ‑za 'kun 'elrele. 'Ka pɛ yɛkɛ‑ 'la na mɛɛ ni, ‑o nu 'bhɛɛ‑ yɛkɛ‑ 'nalɛ 'ka ni, 'bhɛɛ‑ ‑wa baankpa a ta 'ka ni. ");
INSERT INTO moa_vpl VALUES ("MK4_25","071_4_25","MRK","4","25","25","'Bhɛ klɛgbɛya 'ɛ 'yi, 'ke pɛ ‑o mɛɛ 'la zan 'kɔɔ, ‑o nu pɛ baan' 'nalɛ‑ 'bhɛ zan ni. 'Duŋ‑ 'ke pɛ 'ke 'laa ‑o mɛɛ 'la zan 'kɔɔ, 'bhɛ zan laa nu ‑za 'kedo‑ ‑srɔɔwolɛ; 'ali‑ pɛ sanɛ‑ 'la 'bhɛ ‑o ‑a 'kɔɔ, ‑o nu 'bhɛ 'kunlɛ‑.» ");
INSERT INTO moa_vpl VALUES ("MK4_26","071_4_26","MRK","4","26","26","Zesu pe ‑o ni 'ezin‑ 'kaa: «‑Waanbhaa' a ‑bhleŋgbeya 'ɛ 'yoo‑ ‑gee' a ma: Mɛɛ do pɛbhɛ ꞊bwa ‑yaa' gbabhɛ 'ɛ ta. ");
INSERT INTO moa_vpl VALUES ("MK4_27","071_4_27","MRK","4","27","27","'Kee‑ yidia‑ oo, 'kee‑ ꞊bwa ‑a ‑yrɛ ma oo, ‑bi zi 'pegee ‑yrekpaa', pɛbhɛ 'ɛ bhɔ, 'bhɛɛ‑ ‑e gbaandɛ gɔnɛ‑ 'la gbɛɛn‑ yaa 'bhɛ do 'kpɔ 'yaango‑. ");
INSERT INTO moa_vpl VALUES ("MK4_28","071_4_28","MRK","4","28","28","'Trɛ 'ɛ ‑ya ya 'ke pɛdiiŋ 'ɛ 'le 'pe, 'bhɛɛ‑ pɛdiiŋ 'ɛ gbaandɛ, 'bhɛɛ‑ ‑ya ‑vlɔ mu klɛ 'bhɛ blaan, 'bhɛɛ‑ ‑a ‑lɛyan' 'ke ‑a bhɛ mu 'ɛ 'sɔlele ‑a ‑vlɔ mu 'ɛ ma boolazi. ");
INSERT INTO moa_vpl VALUES ("MK4_29","071_4_29","MRK","4","29","29","'Ke ‑o ‑tranna bhla 'la ba, mɛɛ mu ‑gɔŋlɔ si 'bhɛɛ‑ ‑woo kan, ‑amasrɔyi ‑o 'kan 'waati 'ɛ ꞊bhwa.» ");
INSERT INTO moa_vpl VALUES ("MK4_30","071_4_30","MRK","4","30","30","Zesu pe ‑o ni 'ezin‑ dɔɔ: «‑O ‑sɔ ‑Waanbhaa' ‑bhleŋgbeya 'ɛ danle‑ ‑mɛla ma 'ezin‑ ɛɛ? Taa‑ ‑o sɔ ‑a zrɔnle‑ ‑gɔɔn ‑glɔɔn 'ɛ ‑dela ma 'ezin‑ ɛɛ?» ");
INSERT INTO moa_vpl VALUES ("MK4_31","071_4_31","MRK","4","31","31","‑Waanbhaa' ‑bhleŋgbeya ‑yoo 'tɛ 'bhii‑ mutaadi bhɛ do gbɛɛn‑, 'ke ‑wa ꞊bwa 'trɛ 'ɛ 'yi, 'yela‑ 'fiɛntrɔnnɛ 'yiya‑ 'trɛ 'ɛ ta pɛbhɛ mu 'ɛ 'kpɛn ni. ");
INSERT INTO moa_vpl VALUES ("MK4_32","071_4_32","MRK","4","32","32","'Ke ‑o ‑yaan ‑a bɔlele bhla 'la ba, 'kee‑ ꞊bhwa ‑e tro 'bhɛɛ‑ ‑a diiŋ 'ɛ kan ‑ziɛnbhɛ' gba 'ɛ 'yi pɛdiiŋ mu 'ɛ 'kpɛn ta, ‑a gbɛ mu 'ɛ ‑woo ‑yidɛ', ‑asiikɔɔ gba la maannɛ‑ mu sɔ 'mu 'fɛ 'kpalɛ‑ ‑a ‑laa mu 'ɛ 'yi. ");
INSERT INTO moa_vpl VALUES ("MK4_33","071_4_33","MRK","4","33","33","Zesu 'yaa‑ ‑Waanbhaa' a jan 'ɛ 'wo zii' ‑o ni ‑gɔɔn ‑bebe 'yi 'bhii‑ 'kɛla bhe 'bhɛ gbɛɛn‑. ‑O ‑yaa sɔ ‑Waanbhaa' a ‑jan yɛkɛ‑ 'la 'yimale, ‑e ‑yaa 'bhɛɛ‑ wlata ‑gɔɔn bɔ 'zi ‑o ni. ");
INSERT INTO moa_vpl VALUES ("MK4_34","071_4_34","MRK","4","34","34","Yaa ‑yaa ‑jan sanɛ‑ ‑wo ‑o ni, 'ke yaa ‑gɔɔn bɔ 'bhɛ zi. 'Duŋ‑ 'ke ‑o 'pegee ‑yaa' ‑klaŋlanɛ mu 'ɛ 'gbansaan 'te ‑yaa klɛ 'waati 'la ba, ‑e ‑yaa 'bhɛ ‑gɔɔn mu 'ɛ 'kpɛn ‑yipe' 'mu ni. ");
INSERT INTO moa_vpl VALUES ("MK4_35","071_4_35","MRK","4","35","35","'Bhɛ ‑yrekpaa' do 'ɛ 'le yroma 'ɛ zi, Zesu pe ‑yaa' *‑klaŋlanɛ mu 'ɛ ni dɔɔ: «‑Kɔɔ' 'kan ‑draa 'yrɛ gbɛ do 'ɛ ta.» ");
INSERT INTO moa_vpl VALUES ("MK4_36","071_4_36","MRK","4","36","36","‑O ꞊gwa ‑zamaa' 'ɛ ‑din bhla 'la ba, 'yee‑ Zesu 'yaale‑ ‑yaa gban ‑yitakoŋ 'la yi, ‑yaa' ‑klaŋlanɛ mu 'ɛ ‑ja 'kɛle‑ 'bhɛɛ‑ ‑yitakoŋ do 'kpɔ 'ɛ 'bhɛɛ‑ 'yi. ‑Yitakoŋ 'bhɛɛke mu ‑yaa ge 'zi ‑o zi 'ezin‑. ");
INSERT INTO moa_vpl VALUES ("MK4_37","071_4_37","MRK","4","37","37","‑O ‑yaa 'bhɛ 'yi bhe 'tɛ, 'ke ‑ploo ‑gbɛnɛ do 'kanle‑ 'sanle, 'bhɛɛ‑ 'bhɛ 'yaa‑ ‑yipɔɔ' mu 'ɛ 'kla zii' ‑yitakoŋ 'ɛ 'yi, ‑asiikɔɔ 'bhɛ 'yaa‑ zan 'palɛ‑ 'ke ‑yi 'ɛ' le. ");
INSERT INTO moa_vpl VALUES ("MK4_38","071_4_38","MRK","4","38","38","'Bhɛ bhla 'ɛ ba, Zesu 'yaa‑ yidɛ 'zi ‑yitakoŋ 'ɛ 'yi ‑o ‑zanta', ŋgblo 'kpa ‑piti 'ɛ ta. ‑Wa bwele 'tɛ, 'ke ‑wa pele‑ ‑a ni 'kaa: «'O daan mi, 'woo‑ zan galawolɛ ‑yi 'ɛ ba, 'yaa 'bhɛ yiɛnkan ɛɛ?» ");
INSERT INTO moa_vpl VALUES ("MK4_39","071_4_39","MRK","4","39","39","Zesu bwele 'tɛ, 'kee‑ ‑yranle' ‑ploo 'ɛ zi, 'bhɛɛ‑ 'ke ‑ya pele‑ ‑draa 'yi 'ɛ ni dɔɔ: «'Bhɛ 'swa‑ 'bhɛ 'yi ‑gee', 'kpala!» 'Bhɛ klɛle 'tɛ, 'ke ‑ploo 'kanle‑ 'ɛ dulale, 'bhɛɛ‑ 'ke pɛ 'ɛ 'kpɛn 'kpaale siiŋ. ");
INSERT INTO moa_vpl VALUES ("MK4_40","071_4_40","MRK","4","40","40","'Bhɛɛ‑ Zesu pe ‑yaa' ‑klaŋlanɛ mu 'ɛ ni dɔɔ: «‑Mɛle ꞊kla 'bhɛɛ‑ 'ka ‑o ‑gblaan 'zi ‑gee' ɛɛ? ‑E ꞊kla 'nale‑ 'bhɛɛ‑ 'ka 'laa 'ka kpa 'mi 'yi ɛɛ?» ");
INSERT INTO moa_vpl VALUES ("MK4_41","071_4_41","MRK","4","41","41","'Bhɛ ꞊nɔɔ bhe, 'ke ‑gblaan ‑gbɛnɛ do 'klale ‑yaa' ‑klaŋlanɛ mu 'ɛ 'yi, 'bhɛɛ‑ 'ke ‑wa pele‑ 'eke‑ ni dɔɔ: «'E! Mɛɛ ‑glɔɔn 'ɛ ‑dele mɛɛ 'lɛɛ‑ 'le ɛɛ? 'Ali‑ ‑ploo 'pegee 'yi 'mu 'kpɛn 'a 'weli‑ ma.» ");
INSERT INTO moa_vpl VALUES ("MK5_1","071_5_1","MRK","5","1","1","'Bhɛ blaan, 'ke Zesu 'pegee ‑yaa' ‑klaŋlanɛ mu 'ɛ ‑o 'bhɔle‑ Galile ‑draa 'ɛ 'yrɛ gbɛ do 'ɛ ta, Gadara mu 'ɛ ‑waa' 'klɛɛn 'ɛ 'yi. ");
INSERT INTO moa_vpl VALUES ("MK5_2","071_5_2","MRK","5","2","2","Zesu zinale ‑yitakoŋ 'ɛ 'yi, 'bhɛ yrɛ do 'ɛ ꞊nɔɔ bhe, 'ke mɛɛ do 'pwɛle ‑a ‑yi 'kee‑ da mɛɛ bu mu 'ɛ ta, 'bhɛɛ‑ ‑e ꞊nwa 'yee‑ Zesu ‑lɛpalɛ. Zina 'yaa‑ ‑a zi. ");
INSERT INTO moa_vpl VALUES ("MK5_3","071_5_3","MRK","5","3","3","‑E ‑yaa yi mɛɛ bu mu 'ɛ ta, 'bhɛɛ‑ mɛɛ 'kedo‑ 'kpɔ faŋgan‑ 'laa ‑yaa sɔ 'a ‑yrele' ta ‑li, 'ali‑ 'kee‑ ‑yaa klɛ piibhɛ kpɛlɛ‑ mu 'le. ");
INSERT INTO moa_vpl VALUES ("MK5_4","071_5_4","MRK","5","4","4","‑Amasrɔyi ‑sɔ, ‑o piibhɛ 'gbluŋ mu ꞊bwa a gaan mu 'ɛ ma, 'bhɛɛ‑ ‑wa gbɛ ta ‑yrela' 'ke piibhɛ kpɛlɛ‑ mu 'le. 'Duŋ‑ ‑e 'bhɛ piibhɛ 'gbluŋ mu 'ɛ ‑gwa ‑a gaan mu 'ɛ ma, 'bhɛɛ‑ ‑ya gbɛ ma piibhɛ kpɛlɛ‑ mu 'ɛ ‑kplɔɔkplɔɔdwa, 'bhɛɛ‑ ‑e 'mu takaan‑; 'bhɛ 'pegee ‑ya gaan ma piibhɛ 'gbluŋ mu 'ɛ 'kpɛn 'ciɛnna‑. Mɛɛ 'kedo‑ 'kpɔ gbɛ laa ‑yaa sɔ ‑li ‑a 'kunle‑ ta. ");
INSERT INTO moa_vpl VALUES ("MK5_5","071_5_5","MRK","5","5","5","'Waati 'ɛ 'kpɛn ba, ‑bi zi oo, ‑yrekpaa' oo, ‑e ‑yaa kanaa' bu mu 'ɛ ta, 'bhɛ 'pegee vlɛ gɔɔn mu 'ɛ 'wiiŋ‑, 'kee‑ ge gbekanlele, 'bhɛɛ‑ 'kee‑ ge a 'gbu madiŋwole 'le ‑sɔ vlɛ mu 'ɛ ma. ");
INSERT INTO moa_vpl VALUES ("MK5_6","071_5_6","MRK","5","6","6","‑A ‑yrɛkpale Zesu ma 'egbɔɔnle 'te, 'kee‑ gele‑ blasanlele 'bhɛ ba ‑yrɛ ta ye, 'bhɛɛ‑ 'kee‑ 'bhɛ gbale‑ ‑a 'kpɔ zɛnlele 'bhɛ 'lɛɛ. ");
INSERT INTO moa_vpl VALUES ("MK5_7","071_5_7","MRK","5","7","7","'Bhɛɛ‑ 'kee‑ ‑gbekanle 'ke ‑ya pele‑ 'bhɛ ni dɔɔ: «‑Mɛle 'o 'pegee 'bhi 'pleŋ‑ ɛɛ laanima *‑Waanbhaa' Gbe Zesu, 'ŋ mazato ‑Waanbhaa' 'tɔ 'ɛ ‑zayi', 'bhɛɛ‑ 'yaa ‑yrɛnkpalɛ 'ŋ ta.» ");
INSERT INTO moa_vpl VALUES ("MK5_8","071_5_8","MRK","5","8","8","‑E ‑janwoa 'bhɛ gbɛɛn‑ bhe, ‑amasrɔyi Zesu 'a ꞊pia lii ‑yɔɔ' 'ɛ ni 'elwale 'pe dɔɔ ‑e go 'yee‑ mɛɛ 'ɛ zi. ");
INSERT INTO moa_vpl VALUES ("MK5_9","071_5_9","MRK","5","9","9","'Bhɛɛ‑ Zesu 'yee‑ mɛɛ 'ɛ 'lrɔkpaa dɔɔ: «‑Wo 'e sii 'nale ɛɛ?» 'Ke ‑ya pele‑ dɔɔ: «‑Wo 'ŋ sii ‹‑zamaa' 'srɛ, ‑amasrɔyi 'woo‑ 'ebebele.›» ");
INSERT INTO moa_vpl VALUES ("MK5_10","071_5_10","MRK","5","10","10","'Bhɛ 'yi 'tɛ, 'kee‑ ‑sromabɔle Zesu ni 'ebebele dɔɔ: «'E 'zoole‑, 'yaa 'o ‑gbinlɛ' 'klɛɛn 'lɛɛ‑ 'yi.» ");
INSERT INTO moa_vpl VALUES ("MK5_11","071_5_11","MRK","5","11","11","'Bhɛ 'waati 'ɛ ba, ꞊swa 'lɛ ‑gbɛnɛ do ‑yaa pɛbhle 'zi gɔɔn 'ɛ 'wiiŋ‑. ");
INSERT INTO moa_vpl VALUES ("MK5_12","071_5_12","MRK","5","12","12","Lii ‑yɔɔ' mu 'ɛ ‑sromabwa Zesu ni dɔɔ: «'Ke 'yoo ‑gbian mɛɛ 'lɛɛ‑ zi ‑a 'to 'o ge wla ꞊swa mu 'la bhe ‑o 'yi.» ");
INSERT INTO moa_vpl VALUES ("MK5_13","071_5_13","MRK","5","13","13","Zesu ‑dwa 'bhɛ ꞊la ‑o ni. 'Bhɛ klɛle 'tɛ, 'ke ‑o gole‑ mɛɛ 'ɛ zi, 'bhɛɛ‑ 'ke ‑o gele‑ wlalɛ ꞊swa mu 'ɛ 'yi. 'Bhɛ 'yi 'tɛ, 'woo‑ ꞊swa 'lɛdo‑ 'ɛ ‑o ‑daa blasanlele vlɛ gɔɔn 'ɛ 'wiiŋ‑, 'ke ‑o nule‑ baalɛ ‑draa 'ɛ ba, 'bhɛɛ‑ 'ke ‑o 'kpɛn gale‑. ‑O ‑yaa bhɔ ꞊swa 'waa plɛ ‑din. ");
INSERT INTO moa_vpl VALUES ("MK5_14","071_5_14","MRK","5","14","14","'Bhɛ klɛle 'tɛ, 'ke ‑o gooba mu 'ɛ 'kanle 'eke‑ ma, 'bhɛɛ‑ 'ke ‑o gele‑ 'bhɛ ‑za 'ɛ 'woŋwoŋzɛnlɛ 'bhɛ ꞊nɔɔ ‑wa 'ɛ 'pegee gba la ‑wa 'nɛ mu 'ɛ ta. Mɛɛ mu 'ɛ ꞊nwa 'tɛ 'bhɛ ‑za 'ɛ yrɛglinlɛ. ");
INSERT INTO moa_vpl VALUES ("MK5_15","071_5_15","MRK","5","15","15","‑O bhɔle Zesu ‑din, 'ke ‑o lii ‑yɔɔ' 'srɛ 'yaa‑ mɛɛ 'la zan zi 'bhɛ 'yele. 'Bhɛ 'yaale‑ ‑yaa, 'bhɛɛ‑ dunɛ‑ 'klale‑ ‑yaa 'bhɛ ta, 'bhɛ 'pegee 'bhɛ ‑yrɛbakpaale ‑yaa. ‑O ‑yrɛkpalawoa 'bhɛ 'bheele‑ ma, 'ke ‑gblaan 'klale ‑o ‑yi. ");
INSERT INTO moa_vpl VALUES ("MK5_16","071_5_16","MRK","5","16","16","Mɛɛ 'la zan mu 'a ꞊ya Zesu zi, 'bhɛɛ‑ 'ke 'mu 'yee‑ ‑za 'ɛ 'kpɛn klɛyrɛ ꞊ya, ‑za 'la ꞊kla 'yee‑ lii ‑yɔɔ' zan 'ɛ ni, 'bhɛ 'pegee ‑za 'la ꞊kla ꞊swa mu 'ɛ ni 'ezin‑, 'mu 'bhɛ ‑za 'ɛ 'kpɛn 'yigɔɔnna 'woo‑ yrɛ ma ꞊nɔɔ ‑glin mu 'ɛ ni. ");
INSERT INTO moa_vpl VALUES ("MK5_17","071_5_17","MRK","5","17","17","'Bhɛ klɛle 'tɛ, 'ke ‑o ‑sromabɔle Zesu ni dɔɔ 'bhɛ go ‑waa' 'trɛ 'ɛ ta. ");
INSERT INTO moa_vpl VALUES ("MK5_18","071_5_18","MRK","5","18","18","Zesu 'san bhla 'ɛ zi ‑yitakoŋ 'ɛ 'yi, 'ke lii ‑yɔɔ' 'ɛ 'yaa‑ mɛɛ 'la zan zi, ‑e ‑sromabɔle 'sanle Zesu ni dɔɔ ‑e bole‑ 'bhɛ zi. ");
INSERT INTO moa_vpl VALUES ("MK5_19","071_5_19","MRK","5","19","19","Zesu 'laa dɔle 'bhɛ ꞊la ‑a ni, ‑ya ꞊pia ‑a ni drɔɔn' dɔɔ: «Ge 'e ba 'fɛ 'lɛ ma 'yaa‑ mɛɛ mu 'ɛ ba, 'bhɛɛ‑ Mɛɛzan ‑Waanbhaa' ‑za 'wlan 'la ꞊kla 'e ni, 'bhɛ 'pegee 'e 'yrɛnklaa‑ ‑a ma gɔnɛ‑ 'la gbɛɛn‑ bhe, 'bhɛ 'kpɛn 'yipe‑ ‑o ni.» ");
INSERT INTO moa_vpl VALUES ("MK5_20","071_5_20","MRK","5","20","20","'Yee‑ mɛɛ 'ɛ gele 'tɛ, 'kee‑ Zesu ‑za 'la ꞊kla ‑a ni 'bhɛ 'woŋwoŋzɛnle 'yee‑ 'klɛɛn do 'ɛ 'yi ‑wa vu 'ɛ 'kpɛn ta. Mɛɛ 'la zan mu 'kpɛn Zesu klɛza 'ɛ ꞊maa, ‑o 'kpeelɛnia ‑o ma. ");
INSERT INTO moa_vpl VALUES ("MK5_21","071_5_21","MRK","5","21","21","'Bhɛ ‑blaan, Zesu 'pegee ‑yaa' ‑klaŋlanɛ mu 'ɛ ‑o ‑draa 'ɛ takaan‑ ‑yitakoŋ 'ɛ 'yi, 'bhɛɛ‑ ‑o nu gbɛ drɛɛwoa‑ ‑draa 'ɛ 'yrɛ gbɛ do 'ɛ ta. ‑O bhɔle ‑draa 'ɛ bhoŋla, 'ke ‑zamaa' 'srɛ do 'klale ‑o zi. ");
INSERT INTO moa_vpl VALUES ("MK5_22","071_5_22","MRK","5","22","22","'Bhɛ klɛle 'tɛ, 'ke Zuufu mu daanfɛ' 'ɛ ꞊la ‑kuŋlii' mu 'ɛ do nule‑, ‑o ‑yaa 'bhɛ sii Zailusi. 'Bhɛ Zesu 'yele‑, 'kee‑ baale' 'bhɛ gaan ma. ");
INSERT INTO moa_vpl VALUES ("MK5_23","071_5_23","MRK","5","23","23","'Bhɛɛ‑ 'ke 'bhɛ ‑sromabɔle 'yee‑ Zesu ni dɔɔ: «'Ŋ 'lunɛ 'ɛ 'lɛ ‑o zan 'kpaalɛ‑, nu ge 'ŋ ba, 'bhɛɛ‑ 'yee‑ gbɛ 'kpa ‑a ma, 'kooko‑ ‑e bhee.» ");
INSERT INTO moa_vpl VALUES ("MK5_24","071_5_24","MRK","5","24","24","'Bhɛ 'yi 'tɛ, 'ke ‑o 'pegee Zesu gele‑ 'eke‑ zi ‑a ba ‑lɛ ma. ‑O ‑yaa ge 'zi bhla 'la ba ‑a ba ‑lɛ ma, ‑zamaa' 'srɛ do 'la dɔle ‑yaa ‑a zi 'mu 'yaa‑ 'klin zii' 'eke‑ ta gbɛ 'ɛ 'kpɛn zi ‑a ma. ");
INSERT INTO moa_vpl VALUES ("MK5_25","071_5_25","MRK","5","25","25","Le do ‑yaa ‑zamaa' 'ɛ 'pleŋ‑, ‑a lɛɛ vu ta plɛ 'ke yaa ‑yito' 'ɛ 'lɛ 'laa kan. ");
INSERT INTO moa_vpl VALUES ("MK5_26","071_5_26","MRK","5","26","26","‑E ꞊mwa ‑a ‑laanɛkpale ma, 'bhɛɛ‑ 'bhɛ ꞊kla 'trɛbhɔle. ‑A 'kɔɔ ‑gɔli' 'ɛ 'kpɛn 'yaan‑ 'ke yaa 'klɛnyawo. Drɔɔn' yaa ga 'ɛ baan' ‑le ‑yaa 'kla zii' ‑a ba. ");
INSERT INTO moa_vpl VALUES ("MK5_27","071_5_27","MRK","5","27","28","‑E Zesu a ‑za 'ɛ 'male‑, 'ke ‑ya pele‑ ‑a 'kpee dɔɔ: «'Ke 'ŋ ꞊swa 'ŋ gbɛ yanle‑ sa ‑a ta dunɛ‑ 'ɛ ma, 'ŋ nu ‑bheelɛ'.» 'Bhɛ 'yi 'tɛ, 'kee‑ nule‑ wlalɛ ‑zamaa' 'ɛ 'pleŋ‑ Zesu ‑zanta', 'bhɛɛ‑ 'ke ‑ya gbɛ yanle‑ 'bhɛ ta dunɛ‑ 'ɛ ma. ");
INSERT INTO moa_vpl VALUES ("MK5_29","071_5_29","MRK","5","29","29","'Bhɛ yrɛ do 'ɛ ꞊nɔɔ bhe, 'ke yaa ‑yito' 'ɛ 'lɛkanle 'te; 'bhɛɛ‑ 'kee‑ ‑bheele' yaa ga 'ɛ 'yi. ");
INSERT INTO moa_vpl VALUES ("MK5_30","071_5_30","MRK","5","30","30","'Bhɛ yrɛ do 'kpɔ 'ɛ ꞊nɔɔ bhe, 'ke Zesu 'a 'yaangole ‑a 'flɛ 'yi 'bhii‑ 'sɔleya faŋgan‑ do ‑pwɛla ‑a ‑yi. ‑Ya ‑lɛklale ‑zamaa' 'ɛ ta, 'ke ‑yoo ‑lrɔkpale dɔɔ: «‑De ‑le ‑yaan 'ŋ ta dunɛ‑ ma ɛɛ?» ");
INSERT INTO moa_vpl VALUES ("MK5_31","071_5_31","MRK","5","31","31","‑Yaa' ‑klaŋlanɛ mu 'ɛ ‑wa ‑lɛkwan a ni dɔɔ: «'E 'yrɛ 'laa ‑o ‑zamaa' 'ɛ 'klinle‑ ma 'e zi, 'bhɛɛ‑ 'yoo 'o 'lrɔkpa zii' dɔɔ ‑dele ‑yaan 'e ma ɛɛ?» ");
INSERT INTO moa_vpl VALUES ("MK5_32","071_5_32","MRK","5","32","32","'Duŋ‑ Zesu 'a 'yrɛ 'mliŋwoa‑ ‑a zi mu 'ɛ ta, 'kooko‑ mɛɛ 'la zan ‑yaan ‑a ma ‑e 'bhɛ zan ye. ");
INSERT INTO moa_vpl VALUES ("MK5_33","071_5_33","MRK","5","33","33","'Yee‑ le 'ɛ 'yaa‑ bɛɛn 'zi gblaan 'ɛ 'kɔɔ ‑kpakpa. ‑E ‑nwa ‑a 'kpɔ zɛnlɛ Zesu 'lɛɛ, 'bhɛɛ‑ ‑e ‑za 'la ꞊kla ‑e 'bhɛ 'kpɛn wlan꞊pia Zesu ni. ");
INSERT INTO moa_vpl VALUES ("MK5_34","071_5_34","MRK","5","34","34","Zesu pe ‑a ni dɔɔ: «'Ŋ 'lunɛ, 'yee 'kpalawoa 'mi 'yi bhe, 'e ‑gwa ‑za 'yi, ge 'e ba yilabla ta! Bhaa 'yaa‑ ga 'ɛ yaa niinalɛ 'e ma 'ezin‑.» ");
INSERT INTO moa_vpl VALUES ("MK5_35","071_5_35","MRK","5","35","35","Zesu 'yaa‑ 'bhɛ ‑jan 'ɛ 'wo zii' bhla 'la ba, 'ke mɛɛ 'ke mu dale‑ Zuufu mu daanfɛ' 'ɛ ‑kuŋlii' Zailusi ba ‑lɛ ma, 'bhɛɛ‑ 'ke ‑wa pele‑ ‑a ni dɔɔ: «'E 'lunɛ 'ɛ ꞊kla 'ke siɛle', 'yaa ‑kɔɔ' daan mi 'ɛ 'trɛbhɔlɛ 'ezin‑.» ");
INSERT INTO moa_vpl VALUES ("MK5_36","071_5_36","MRK","5","36","36","'Duŋ‑ Zesu 'laa 'bhɛ ‑jan 'ɛ bɔlɛ ‑klɔsi 'yi, 'ke ‑ya pele‑ Zuufu mu daanfɛ' ‑kuŋlii 'ɛ ni dɔɔ: «'Yaa ‑gblaanlɛ', 'e 'kpa 'mi 'yi drɔŋ.» ");
INSERT INTO moa_vpl VALUES ("MK5_37","071_5_37","MRK","5","37","37","‑O ge bhla 'ɛ zi 'yee‑ Zuufu mu daanfɛ' ‑kuŋlii 'ɛ ba, Zesu 'laa dɔlɛ ‑a ‑la 'ke mɛɛ 'kedo‑ 'kpɔ ge ‑o zi, 'ke ya 'e go Piɛri, 'bhɛɛ‑ Zaki 'pegee 'bhɛ 'nwagwlɛn‑ Zaan ba. ");
INSERT INTO moa_vpl VALUES ("MK5_38","071_5_38","MRK","5","38","38","‑O bhɔle Zuufu mu daanfɛ' ‑kuŋlii 'ɛ ba, 'ke Zesu ‑zamaa' do yele‑ 'ke ‑woo ‑we 'zi 'zoozoo‑, 'bhɛ 'pegee mɛɛ 'ke mu ‑yaa wisi' zii' 'ke ‑o ‑gbekan' 'eglɔɔle. ");
INSERT INTO moa_vpl VALUES ("MK5_39","071_5_39","MRK","5","39","39","‑E wlale 'fɛ 'ɛ ꞊la, 'ke ‑ya pele‑ ‑o ni dɔɔ: «‑Mɛle ꞊kla 'bhɛɛ‑ 'ka ‑o ‑we 'zi ‑gee' 'zoozoo‑ ɛɛ, 'bhɛɛ‑ 'ka ‑o wisi' zii' ɛɛ? ‑Nɛ 'ɛ yaa galɛ, ‑yoo yi pla.» ");
INSERT INTO moa_vpl VALUES ("MK5_40","071_5_40","MRK","5","40","40","'Bhɛ klɛle 'tɛ, 'ke 'bhɛ mɛɛ mu 'ɛ 'sɔnsile Zesu ma. ‑Ayile, 'ke ‑yoo 'kpɛn 'pwɛle 'pɛɛlii‑. 'Kee‑ ‑nɛ dɛ 'pegee ‑nɛ 'ɛ nɛɛ, 'bhɛɛ‑ mɛɛ 'la zan mu ꞊nwa ‑a zi 'mu 'te ‑la 'tole 'a zi. 'Bhɛɛ‑ 'ke ‑o gele‑ ‑nɛ gbaa 'ɛ 'yilayrɛ 'ɛ ꞊nɔɔ. ");
INSERT INTO moa_vpl VALUES ("MK5_41","071_5_41","MRK","5","41","41","‑E ‑nɛ 'ɛ ꞊kwan 'bhɛ gbɛ ma 'ke ‑ya 'siile 'kaa: «Talita kumi! » 'Bhɛ 'yile‑: «‑Gblanɛ, 'mi pe 'e ni dɔɔ 'e 'wlɛn‑!» ");
INSERT INTO moa_vpl VALUES ("MK5_42","071_5_42","MRK","5","42","42","'Bhɛ yrɛ do 'kpɔ 'ɛ ꞊nɔɔ bhe, 'ke ‑gblanɛ 'ɛ bwele‑ gale ba, 'ke ‑ya ‑wlɛnle', 'bhɛɛ‑ 'kee‑ 'taawole 'sanle. ‑A lɛɛ ‑yaa vu ta plɛ. Mɛɛ mu 'ɛ ‑o ‑gblanɛ 'ɛ bwele yele gale ba, 'ke ‑o liibhaale ‑o ma 'kee‑ kan a ‑daŋ' ta. ");
INSERT INTO moa_vpl VALUES ("MK5_43","071_5_43","MRK","5","43","43","'Bhɛ blaan, 'ke Zesu ‑o ‑lɛmazɔnle‑ dɔɔ waa 'bhɛ ‑za 'ɛ 'pelɛ‑ mɛɛ 'kedo‑ 'kpɔ ni. 'Bhɛɛ‑ ‑e pe ‑o ni ‑o pɛle na ‑gblanɛ 'ɛ ni. ");
INSERT INTO moa_vpl VALUES ("MK6_1","071_6_1","MRK","6","1","1","Zesu gole 'bhɛ yrɛ 'ɛ 'nɔɔ‑, 'kee‑ gele‑ ‑a 'tro ‑wa 'ɛ ta. ");
INSERT INTO moa_vpl VALUES ("MK6_2","071_6_2","MRK","6","2","2","*‑Yitrɛ' yi 'ɛ 'bhɔle‑, 'kee‑ mɛɛ mu 'ɛ daanle 'sanle *Zuufu mu daanfɛ' 'ɛ ꞊la. Mɛɛ 'srɛ 'la 'yaa‑ 'mu 'trɔnkpa zii' ‑a ni, ‑e 'mu 'kpɛn 'kpeelɛnia, 'bhɛɛ‑ 'ke 'mu 'a 'pele dɔɔ: «'Ee! ‑E 'bhɛ ‑za mu 'lɛɛ‑ 'kpɛn ‑daanna ‑dela ba ɛɛ? ‑Zadɔleya 'la ‑ya 'kɔɔ, 'bhɛ 'pegee ‑e 'sɔle‑ maza mu 'la klɛ 'zi, ‑dele 'bhɛ 'sɔle‑ maza mu 'ɛ klɛ 'seŋ 'na zii' ‑a ni ɛɛ? ");
INSERT INTO moa_vpl VALUES ("MK6_3","071_6_3","MRK","6","3","3","Mari gbe 'fɛ 'wiiŋkpa mi 'ɛ yaa 'kɛle‑ ɛɛ? Zaki 'pegee Zose, 'bhɛɛ‑ Zude 'pegee Simɔ 'naagwlɛn‑ 'ɛ ‑yaa 'kɛle‑ ɛɛ? 'Bhɛɛ‑ ‑a nɛɛnɛ‑ le mu 'ɛ waa ‑o 'kɔɔ ba ‑gɛ ɛɛ?» ‑O 'kpeejan‑ mu 'ɛ ma, waa 'sɔlɛ‑ ‑o 'kpale ‑a ‑yi. ");
INSERT INTO moa_vpl VALUES ("MK6_4","071_6_4","MRK","6","4","4","‑Ayile, 'ke Zesu 'a 'pele ‑o ni 'kaa: «‑O ‑Waanbhaa' ‑lɛla' janwo mi 'ɛ ‑lɛdɔ' a ma yrɛkpɛn‑ ꞊nɔɔ, 'fɔke ya 'e go ‑a 'gbu da ‑wa 'la ta 'mu ꞊nɔɔ mu 'ɛ ba, 'bhɛ 'pegee ‑a dɛ mu, 'bhɛɛ‑ ‑yaa' 'fa ‑la mu 'ɛ ba.» ");
INSERT INTO moa_vpl VALUES ("MK6_5","071_6_5","MRK","6","5","5","Waa ‑o 'kpalawolɛ Zesu 'yi ‑a 'gbu da ‑wa 'ɛ ta, yaa 'sɔlɛ‑ 'sɔle‑ maza ‑bebe klɛlɛ 'bhɛ ꞊nɔɔ; 'ke yaa 'e go ‑ya gbɛ ‑kpaa gadɛ mu 'dama 'la ta 'mu ba, 'bhɛɛ‑ 'mu 'bheela‑. ");
INSERT INTO moa_vpl VALUES ("MK6_6","071_6_6","MRK","6","6","6","Waa ‑o 'kpalawolɛ ‑a ‑yi bhe, 'bhɛ 'a 'kpeelɛnia ‑a ma. Zesu ‑ja 'kaanlɛ‑ Nazarɛti kpɛ ma ‑wa mu 'ɛ ta 'kee‑ ge mɛɛ mu 'ɛ daanlele ‑Waanbhaa' a ‑jan 'ɛ 'le. ");
INSERT INTO moa_vpl VALUES ("MK6_7","071_6_7","MRK","6","7","7","Zesu ‑yaa' *‑klaŋlanɛ vu ta plɛ 'ɛ 'siila‑ ‑a ‑din, 'bhɛɛ‑ 'ke ‑yoo winbɔle 'sanle plɛ plɛ 'kaa ‑o ge ‑Jan 'Nrale‑ 'ɛ 'woyrɛ‑ 'ɛ nɔɔ‑; 'bhɛɛ‑ 'kee‑ 'seŋ 'nale ‑o ni 'ke ‑o lii ‑yɔɔ' mu ‑gbin mɛɛ mu zi. ");
INSERT INTO moa_vpl VALUES ("MK6_8","071_6_8","MRK","6","8","9","'Bhɛɛ‑ ‑e pe ‑o ni dɔɔ: «'Ka ‑o gelawo zii' gbɛn 'ɛ ta bhe, 'ka 'laa pɛle 'pegee gbɛn ta ge 'pepe 'silɛ‑, 'bhɛɛ‑ 'ka 'laa ‑gɔli' do 'kpɔ bɔlɛ 'ka 'wiiŋ‑, 'bhɛ 'pegee 'ka 'laa dunɛ‑ plɛ 'klalɛ‑ 'ka ta. 'Duŋ‑ ‑ka 'ka 'taawo 'beni mu 'si, 'bhɛɛ‑ ‑ka ‑sawla 'wla 'ka gaan ma.» ");
INSERT INTO moa_vpl VALUES ("MK6_10","071_6_10","MRK","6","10","10","‑E pe ‑o ni 'ezin‑: «'Ke 'ka ꞊bhwa ‑wa 'la ta, 'bhɛɛ‑ 'ke ‑o 'ka 'cieya‑ ꞊kla 'fɛ 'la ꞊la, ‑ka bo 'bhɛɛ‑ ꞊la, 'ke 'bhɛ ge 'tɛnlɛ‑ 'ka jilale ma. ");
INSERT INTO moa_vpl VALUES ("MK6_11","071_6_11","MRK","6","11","11","'Bhɛɛ‑ 'ke waa 'ka 'kunlɛ‑ 'elrele, 'bhɛ 'pegee 'ke waa ‑o 'trɔnkpalɛ 'ka 'wojan‑ mu 'ɛ ꞊la yrɛ 'la ꞊nɔɔ, 'ke 'ka ‑o go 'zi bhla 'la ba 'bhɛ yrɛ 'ɛ 'nɔɔ‑, ‑ka 'ka gaan mazɔn 'bhɛ yrɛ 'ɛ ꞊nɔɔ, 'ke 'ka 'ka gaan ma bwegblɛn‑ mu 'ɛ 'kpɛn go. 'Bhɛ nu klɛlɛ 'bhɛ yrɛ 'ɛ ꞊nɔɔ mu 'ɛ ‑waa' ‑za 'yɔɔ‑ 'ɛ ma 'tɔɔmasie 'le.» ");
INSERT INTO moa_vpl VALUES ("MK6_12","071_6_12","MRK","6","12","12","‑Yaa' ‑klaŋlanɛ vu ta plɛ 'ɛ ‑o ‑ja 'bhɛɛ‑ 'yi 'tɛ, 'bhɛɛ‑ ‑o ‑yaa pe 'zi mɛɛ mu 'ɛ ni dɔɔ: «‑Ka 'ka 'taawogbɛya 'ɛ 'niina‑ 'ke 'ka 'ploo‑ ‑za 'yɔɔ‑ klɛle ma!» ");
INSERT INTO moa_vpl VALUES ("MK6_13","071_6_13","MRK","6","13","13","‑O 'zina ‑bebe ꞊gbian mɛɛ mu zi. ‑O gadɛ mu ‑bebe 'srola‑ 'ke ‑yrɔn 'le, 'bhɛɛ‑ ‑o 'mu 'bheela‑. ");
INSERT INTO moa_vpl VALUES ("MK6_14","071_6_14","MRK","6","14","14","'Bhɛ 'waati 'ɛ ba, ‑Bhleŋgbe Erɔdi Antipasi Zesu 'tɔ 'ɛ ꞊maa, ‑amasrɔyi ‑o ‑yaa 'bhɛ 'tɔbhɔ zii' yrɛkpɛn‑ ꞊nɔɔ. Mɛɛ 'ke mu ‑yaa pe 'zi dɔɔ: «Mɛɛ Wiiŋfɛ' Mi Zaan ‑le ‑bwela gale ba, 'bhɛla‑ ‑yile 'sɔle‑ maza mu klɛ ‑glɔɔya' ‑o ‑a 'kɔɔ.» ");
INSERT INTO moa_vpl VALUES ("MK6_15","071_6_15","MRK","6","15","15","Mɛɛ 'ke mu ‑yaa 'pe zi dɔɔ: «Eli ‑le». ‑A 'ke mu ‑yaa 'pe 'ezin‑ dɔɔ: «‑Waanbhaa' ‑lɛla' janwo mi do ‑le 'bhii‑ 'elwaleta ‑Waanbhaa' ‑lɛla' ‑janwo' mu 'ɛ gbɛɛn‑.» ");
INSERT INTO moa_vpl VALUES ("MK6_16","071_6_16","MRK","6","16","16","'Yee‑ ‑bhleŋgbe Erɔdi Antipasi 'bhɛ ‑jan mu 'ɛ 'male‑, 'ke ‑ya pele‑ 'kaa: «'An ꞊pia mɛɛ mu 'ɛ ni dɔɔ ‑o Zaan 'la ŋgblo 'kan, 'bhɛ ‑le 'kɛle‑». ");
INSERT INTO moa_vpl VALUES ("MK6_17","071_6_17","MRK","6","17","18","‑Za 'la ꞊kla 'bhɛɛ‑ *Erɔdi 'a ꞊pia mɛɛ mu 'ɛ ni dɔɔ ‑o Zaan ŋgblo 'ɛ kan' 'bhɛ ‑le ‑gɛ: 'Yee‑ Erɔdi Antipasi ‑a 'gbu nɛɛnɛ‑ Filipu 'na Erodiadi ꞊sia 'ke ‑a na 'le. 'Bhɛ 'yi 'tɛ, 'ke Zaan 'a 'pele ‑a ni dɔɔ: «'Ke 'yee 'gbu nɛɛnɛ‑ na ꞊kla 'kee 'na 'le, 'bhɛ 'laa ‑o 'ke ‑za 'lrele‑ 'le.» 'Bhɛ klɛle 'tɛ, 'ke 'yee‑ Erɔdi mɛɛ mu winbɔle Zaan 'kunyrɛ‑ nɔɔ‑, 'bhɛɛ‑ 'ke ‑wa bɔle‑ ‑kaso 'yi. ");
INSERT INTO moa_vpl VALUES ("MK6_19","071_6_19","MRK","6","19","19","Erodiadi zrupliile ‑yaa Zaan ma 'bhɛ ‑zayi', 'bhɛɛ‑ ‑e ‑yaa 'bhɛ dɛyrɛ ‑la ‑glin 'zi, 'duŋ‑ ‑a gbɛ laa 'sɔlɛ‑ ‑lido' 'bhɛ dɛle ta. ");
INSERT INTO moa_vpl VALUES ("MK6_20","071_6_20","MRK","6","20","20","‑Amasrɔyi Erɔdi ‑yaa ‑gasikpa Zaan 'lɛɛ 'egbɛnɛle. 'Bhɛɛ‑ ‑a 'gbu 'yaa‑ 'yaango‑ 'bhii‑ Zaan ‑o 'ke mɛɛ ‑lɛdɔɔle 'le, 'bhɛ 'pegee mɛɛ 'weŋ do 'le, 'bhɛɛ‑ ‑e ‑yaa 'bhɛ tagbin. 'Kee‑ ‑yaa Zaan 'wojan‑ 'ɛ ma, ‑a zru ba 'tɛ 'yaa‑ dɔ. 'Bhɛɛ‑ 'duŋ‑, 'bhɛ 'yaa‑ sɔ ‑a ni 'ke ‑ya 'trɔnkpa‑ Zaan ni. ");
INSERT INTO moa_vpl VALUES ("MK6_21","071_6_21","MRK","6","21","21","'Duŋ‑ ‑yrekpaa' do, 'ke Erodiadi ‑a pɛ ‑za ‑zigo' yi 'ɛ 'bhɔle. 'Bhɛ yi 'ɛ 'yaa‑ 'ke ‑bhleŋgbe Erɔdi 'ya lɛɛ ‑zabla' yi 'ɛ 'bhɛɛ‑ 'le. Erɔdi pɛ ‑koo ‑gbɛnɛ do ꞊kla. ‑E ‑yaa' mɛɛ gblaan mu oo, ‑srwase' ‑kuŋlii mu oo, 'bhɛ 'pegee Galile 'klɛɛn 'ɛ 'yi mɛɛ gblaan mu 'ɛ 'kpɛn 'siila‑ 'bhɛ ma. ");
INSERT INTO moa_vpl VALUES ("MK6_22","071_6_22","MRK","6","22","22","Erodiadi 'gbu 'lu ‑gblanɛ 'ɛ 'wlale‑ 'fɛti klɛ 'fɛ 'ɛ ꞊la, 'kee‑ 'srotanle 'sanle. ‑E ꞊swa 'gbu Erɔdi 'pegee ‑yaa' 'cie mu 'ɛ ni. 'Yee‑ ‑bhleŋgbe Erɔdi pe 'bhɛ 'yi 'tɛ gblanɛ 'ɛ ni dɔɔ: «'Kee pɛ 'la 'yrɛwoa‑ 'ŋ ma, 'ŋ nu 'bhɛɛ‑ 'nalɛ‑ 'e ni.» ");
INSERT INTO moa_vpl VALUES ("MK6_23","071_6_23","MRK","6","23","23","‑Ya 'siɛnwoa‑ 'gbu ‑gblanɛ 'ɛ ni dɔɔ: «'Kee pɛ 'oo pɛ 'la 'yrɛwoa‑ 'ŋ ma, 'ŋ nu 'bhɛ 'nalɛ‑ 'e ni, 'ali‑ 'kee‑ ꞊kla 'an ‑bhleŋgbe 'klɛɛn 'ɛ gbɛ do 'le oo, 'ŋ nu dɔlɛ 'bhɛ 'nale‑ ꞊la 'e ni.» ");
INSERT INTO moa_vpl VALUES ("MK6_24","071_6_24","MRK","6","24","24","'Bhɛ klɛle 'tɛ, 'ke ‑gblanɛ 'ɛ 'pwɛle 'pɛɛlii‑, 'kee‑ gele‑ ‑a nɛɛ ‑lrɔkpalɛ dɔɔ: «'Ŋ ‑mɛ pɛ ‑za 'gbu ‑la 'yrɛwo ‑a ma ɛɛ?» ‑A nɛɛ pe a ni dɔɔ: «‑A pe 'ŋ 'yoo‑ Mɛɛ Wiiŋfɛ' Mi Zaan ŋgblo 'ɛ 'bhɛɛ‑ zi.» ");
INSERT INTO moa_vpl VALUES ("MK6_25","071_6_25","MRK","6","25","25","'Bhɛ 'yi 'tɛ, 'ke ‑gblanɛ 'ɛ 'niinale blaale‑ 'fɛ 'ɛ ꞊la, 'ke ‑ya pele‑ ‑bhleŋgbe 'ɛ ni: «'Ŋ 'yoo‑ ‑a zi 'bhii‑ 'e Mɛɛ Wiiŋfɛ' Mi Zaan ŋgblo 'ɛ 'bhɛɛ‑ 'kan, 'bhɛɛ‑ 'ya na 'ŋ ni pɛle ‑koo do ta 'saanibhe.» ");
INSERT INTO moa_vpl VALUES ("MK6_26","071_6_26","MRK","6","26","26","'Bhɛ ‑jan 'ɛ 'bhɛ 'yee‑ ‑bhleŋgbe 'ɛ ta ꞊kla suŋ 'egbɛnɛle. 'Duŋ‑ ‑ya 'siɛnlawoa gban ‑jan 'la 'bhɛ ta ‑gblanɛ 'ɛ ni, yaa 'cie mu 'ɛ 'yrɛ ma, yaa ‑yaa sɔ a ‑gbɛdɔle 'bhɛ klɛle ma. ");
INSERT INTO moa_vpl VALUES ("MK6_27","071_6_27","MRK","6","27","27","'Bhɛ yrɛ do 'ɛ ꞊nɔɔ bhe, 'ke ‑ya gooba ‑srwase' mu 'ɛ do winbɔle 'kaa 'bhɛ ge Zaan ŋgblo 'ɛ 'kan, 'bhɛɛ‑ 'bhɛ nu 'kɛle‑ ‑a ni. ");
INSERT INTO moa_vpl VALUES ("MK6_28","071_6_28","MRK","6","28","28","‑Srwase' mi 'ɛ ‑ja Zaan ŋgblo 'ɛ 'kanlɛ‑ ‑kaso 'fɛ 'ɛ ꞊la, 'kee‑ nule‑ 'bhɛ 'le pɛle ‑koo do ta. 'Kee‑ 'bhɛ 'nale ‑gblanɛ 'ɛ ni. 'Bhɛɛ‑ 'ke ‑gblanɛ 'ɛ 'bhɛ 'kpale 'bhɛ nɛɛ 'kɔɔ. ");
INSERT INTO moa_vpl VALUES ("MK6_29","071_6_29","MRK","6","29","29","Zaan ‑a ‑klaŋlanɛ mu 'ɛ 'bhɛ 'male‑, 'ke ‑o nule‑ ‑a gbaa 'ɛ 'silɛ‑, 'bhɛɛ‑ 'ke ‑o gele‑ ‑a binlɛ. ");
INSERT INTO moa_vpl VALUES ("MK6_30","071_6_30","MRK","6","30","30","Zesu a winbɔwo mu 'ɛ dale blaan ‑waa' 'taa 'ɛ ta, 'ke ‑woo ‑lɛkpale 'eke‑ ta 'yee‑ Zesu ‑din, 'bhɛɛ‑ 'ke ‑o ‑za mu 'la 'kpɛn ꞊kla 'bhɛ 'pegee ‑o mɛɛ mu ‑daanna ‑za mu 'la 'kpɛn 'le, 'mu 'yigɔɔnle ‑a ni. ");
INSERT INTO moa_vpl VALUES ("MK6_31","071_6_31","MRK","6","31","31","Zesu pe ‑o ni 'kaa: «‑Kɔɔ' go ‑gɛ, 'bhɛɛ‑ ‑kɔɔ' ge 'edaŋma ‑kɔɔ' 'yitrɛlɛ sa ‑kpe ta yrɛ do ꞊nɔɔ.» Zesu ‑janwoa 'bhɛ gbɛɛn‑ bhe, ‑amasrɔyi mɛɛ ‑bebe 'yaa‑ nu 'zi ‑o ba 'ke ‑o ge 'waati 'ɛ 'kpɛn ba, ‑asiikɔɔ Zesu 'pegee ‑yaa' ‑klaŋlanɛ mu 'ɛ waa ‑yaa pɛbhleyrɛ ‑srɔɔwo ‑o 'kɔɔ. ");
INSERT INTO moa_vpl VALUES ("MK6_32","071_6_32","MRK","6","32","32","'Bhɛ 'yi, ‑O ‑saan ‑yitakoŋ do 'yi, 'bhɛɛ‑ 'ke ‑o ‑yi 'ɛ takanle, 'bhɛɛ‑ 'ke ‑o 'gbansaan 'te gele‑ ‑kpe 'ɛ ta yrɛ do ꞊nɔɔ. ");
INSERT INTO moa_vpl VALUES ("MK6_33","071_6_33","MRK","6","33","33","'Duŋ‑ mɛɛ ‑bebe ‑o ꞊ya, ‑o ge bhla 'ɛ zi ‑yitakoŋ 'ɛ 'yi, 'bhɛɛ‑ ‑woo madwa‑. 'Bhɛla‑ ‑yile, 'bhɛ mu ‑daa ‑wa mu 'ɛ 'kpɛn ta, 'bhɛɛ‑ 'mu blasaan‑, 'ke 'mu gele‑ zɛnlɛ blaale‑ 'yee‑ Zesu 'pegee ‑yaa' ‑klaŋlanɛ mu 'ɛ 'lɛɛ ‑o ‑yaa ge 'zi yrɛ 'la ꞊nɔɔ 'bhɛ ꞊nɔɔ. ");
INSERT INTO moa_vpl VALUES ("MK6_34","071_6_34","MRK","6","34","34","Zesu zinale ‑yitakoŋ 'ɛ 'yi, 'kee‑ ‑zamaa' ‑gbɛnɛ 'ɛ yele‑. 'Bhɛɛ‑ ‑o ‑yrɛnklaa ‑a ma. ‑Amasrɔyi ‑o ‑yaa 'bhii‑ ‑bhlaa mu 'la ‑o gooba mi laa ‑o ta. 'Bhɛ 'yi 'tɛ, 'ke ‑yoo ‑o daanle 'sanle ‑za ‑bebe 'le. ");
INSERT INTO moa_vpl VALUES ("MK6_35","071_6_35","MRK","6","35","35","‑E ꞊bwa mɛɛ mu 'ɛ daanle ma, 'bhɛɛ‑ 'waati 'ɛ ꞊bhwa 'egbɔɔnle. ‑Ayile, ‑yaa' ‑klaŋlanɛ mu 'ɛ ‑woo mabɛɛnle ‑a ‑din, 'ke ‑wa pele‑ ‑a ni: «'E 'yrɛkpa, ‑kɔɔ' ‑o ‑bɔn drɛyi' ‑a ma 'dɛ! 'Bhɛɛ‑ 'waati 'ɛ ꞊bhwa gban 'egbɔɔnle; ");
INSERT INTO moa_vpl VALUES ("MK6_36","071_6_36","MRK","6","36","36","‑a pe mɛɛ mu 'lɛɛ‑ ni 'kaa ‑o ge pɛle mu ‑lɔyrɛ' ‑glin ‑bɔn 'yi ‑wa mu 'pegee ‑kɔɔ' ‑din ‑wa mu 'ɛ ta.» ");
INSERT INTO moa_vpl VALUES ("MK6_37","071_6_37","MRK","6","37","37","'Bhɛ 'yi 'tɛ, 'ke Zesu 'a pele ‑o ni dɔɔ: «'Ka mu 'gbu pɛle na ‑o ni!» 'Bhɛɛ‑ ‑o pe ‑a ni 'ezin‑ dɔɔ: «'Ali‑ 'ke 'o denie ‑gɔli' 'taŋbha ‑kɛmɛ plɛ pɛ 'bluu ꞊lwa, 'bhɛɛ‑ 'ke 'o 'bhɛ ꞊naa 'woo‑ mɛɛ mu 'lɛɛ‑ ni, 'bhɛ sɔ ‑o mabhɔle ɛɛ?» ");
INSERT INTO moa_vpl VALUES ("MK6_38","071_6_38","MRK","6","38","38","'Bhɛ klɛle 'tɛ, 'ke Zesu ‑o ‑lrɔkpale 'kaa: «'bluu 'wɛɛ‑ ‑le 'ka 'kɔɔ ɛɛ? ‑Ka ge ‑a ‑glin doo.» ‑O gele 'eke‑ ‑lrɔkpalɛ 'ke ‑o nule‑ ‑a pelɛ ‑a ni: «'bluu 'soo 'pegee kaa plɛ.» ");
INSERT INTO moa_vpl VALUES ("MK6_39","071_6_39","MRK","6","39","39","'Bhɛ 'yi 'tɛ, 'ke Zesu 'a 'pele ‑yaa' ‑klaŋlanɛ mu 'ɛ ni dɔɔ: «‑Kaa pe mɛɛ mu 'ɛ ni dɔɔ ‑o yala‑ ‑bɔn ‑dɔɔ 'ɛ ta ‑lɛ ma ‑lɛ ma!» ");
INSERT INTO moa_vpl VALUES ("MK6_40","071_6_40","MRK","6","40","40","'Bhɛɛ‑ mɛɛ mu 'ɛ ‑yalaa' ‑lɛ ma ‑kɛmɛ do do 'pegee mia plɛ bhɛ vu vu. ");
INSERT INTO moa_vpl VALUES ("MK6_41","071_6_41","MRK","6","41","41","'Bhɛ klɛle 'tɛ, 'ke Zesu 'bluu 'soo 'ɛ 'pegee kaa plɛ ‑o 'kunle ‑a 'kɔɔ, 'ke ‑ya ‑yrɛ 'kpale laanima, 'bhɛɛ‑ 'kee‑ ‑Waanbhaa' 'pubɔle pɛle 'ɛ ma. 'Bhɛ blaanta, 'kee‑ 'bluu mu 'ɛ takanle kplokplo, 'ke ‑yoo 'kpale ‑yaa' ‑klaŋlanɛ mu 'ɛ 'kɔɔ 'kaa ‑woo ‑yiciɛn' ‑zamaa' 'ɛ ma. 'Bhɛ klɛgbɛya do 'ɛ yi, 'kee‑ kaa plɛ 'ɛ 'yiciɛnle ‑o 'kpɛn ma. ");
INSERT INTO moa_vpl VALUES ("MK6_42","071_6_42","MRK","6","42","42","Mɛɛ mu 'ɛ 'kpɛn pɛbhla‑, 'bhɛɛ‑ ‑o kpɛdwa‑. ");
INSERT INTO moa_vpl VALUES ("MK6_43","071_6_43","MRK","6","43","43","‑O yanle pɛ 'ɛ 'bhlelele, 'bluu 'lɛkpu‑ mu 'pegee kaa mu 'la ꞊bwa ‑o blaan, 'mu ciɛ ‑nɛ ꞊yan vu ta plɛ ‑paa. ");
INSERT INTO moa_vpl VALUES ("MK6_44","071_6_44","MRK","6","44","44","Mɛɛ mu 'la 'kpɛn 'yee‑ pɛ 'ɛ ꞊bhla, 'mu 'yaa 'gwlaan‑ 'waa 'soo (5.000); le mu 'pegee ‑nɛ mu laa ‑yaa 'bhɛ mɛɛ ‑lii 'ɛ ba. ");
INSERT INTO moa_vpl VALUES ("MK6_45","071_6_45","MRK","6","45","45","'Bhɛ ‑za mu 'ɛ 'kanle‑ ‑gun bhe, Zesu 'a ꞊pia ‑yaa' ‑klaŋlanɛ mu 'ɛ ni 'kaa ‑o ge 'san ‑yitakoŋ 'ɛ 'yi kpaŋma. ‑E ‑yaa zi 'bhii‑ ‑o 'kan 'a ‑lɛɛ ‑sɔ ‑draa 'yrɛ gbɛ do 'ɛ ta, Bɛtisaida ‑wa 'ɛ ba ‑yrɛ 'ɛ ta. 'Bhɛ 'waati 'ɛ ba, 'yee‑ 'gbu nu 'ploolɛ‑ ‑zamaa' 'ɛ ma 'kaa ‑o ge ‑o ba ‑lɛ ma. ");
INSERT INTO moa_vpl VALUES ("MK6_46","071_6_46","MRK","6","46","46","Zesu 'yanle‑ 'ploolele ‑zamaa' 'ɛ ma, 'kee‑ gele‑ ‑a 'seriwolɛ gɔɔn do wiiŋ‑. ");
INSERT INTO moa_vpl VALUES ("MK6_47","071_6_47","MRK","6","47","47","‑Bi ꞊pwa 'waati 'la ba, ‑yaa' ‑klaŋlanɛ mu 'ɛ 'yaa‑ ‑yitakoŋ 'ɛ 'yi, ‑yi 'ɛ drɛyi', 'bhɛɛ‑ 'yee‑ Zesu do ‑kplɛn ‑yaa 'trɛ ma. ");
INSERT INTO moa_vpl VALUES ("MK6_48","071_6_48","MRK","6","48","48","Zesu 'a ꞊ya 'bhii ‑yaa ‑klaŋlanɛ mu 'ɛ gbɛzikaan ‑yitakoŋ 'ɛ 'bhɔle‑ ma, ‑amasrɔyi ‑ploo 'ɛ 'yaa‑ 'kan zii' 'kee‑ nu ‑o ba ‑yrɛ ta. 'Bhɛ klɛle 'tɛ, zrwanzi maa gwlɛn ‑we bhla ꞊lwa 'ɛ ba, 'kee‑ 'taawole 'sanle ‑yi 'ɛ ta 'kee‑ nu ‑o ba ‑yrɛ ta, ‑e ‑yaa zan drɔɔn' 'kanlɛ‑ ‑o ta. ");
INSERT INTO moa_vpl VALUES ("MK6_49","071_6_49","MRK","6","49","49","‑Wa yele 'taawoyrɛ 'ɛ ꞊nɔɔ ‑yi 'ɛ ta, ‑e ꞊kla ‑o ni 'bhii‑ jiɛlii do ‑le ‑yaa 'kɛle‑, ‑ayile 'ke ‑o ‑gbekanle 'sanle. ");
INSERT INTO moa_vpl VALUES ("MK6_50","071_6_50","MRK","6","50","50","‑Amasrɔyi, ‑o 'kpɛn 'a ꞊ya, 'bhɛɛ‑ ‑gblaan ꞊klaa ‑o ‑yi. 'Bhɛ yrɛ do 'ɛ ꞊nɔɔ bhe, 'ke ‑ya pele‑ ‑o ni 'kaa: «‑Ka 'ka zrudɔ 'eglɔɔle, 'mi ‑le 'kɛle‑, 'ka 'laa ‑gblaanlɛ'.» ");
INSERT INTO moa_vpl VALUES ("MK6_51","071_6_51","MRK","6","51","51","'Bhɛ blaan, 'kee‑ 'sanle ‑o zi ‑yitakoŋ 'ɛ 'yi, 'ke ‑ploo 'kanle‑ 'ɛ dulale. ‑Yaa' ‑klaŋlanɛ mu 'ɛ 'liibhaala ‑o ma 'kee‑ kan ‑a ‑daŋ' ta. ");
INSERT INTO moa_vpl VALUES ("MK6_52","071_6_52","MRK","6","52","52","‑Amasrɔyi, ‑e 'sɔle‑ maza 'la ꞊kla ‑o ‑yrɛ ma 'bluu 'yiciɛnyrɛ 'ɛ ꞊nɔɔ, ‑waa 'bhɛ ‑yi 'malɛ‑ ‑li bi, ‑woo 'trɔn 'yi ‑dwa 'eglɔɔle 'bhɛ 'yimale ma. ");
INSERT INTO moa_vpl VALUES ("MK6_53","071_6_53","MRK","6","53","53","Zesu 'pegee ‑yaa' ‑klaŋlanɛ mu 'ɛ 'yanle ‑draa 'ɛ takanlele bhla 'la ba, 'ke ‑o zinale ‑draa ‑yrɛ gbɛ do 'ɛ ta Zenezarɛti 'trɛ 'ɛ ta, 'bhɛɛ‑ ‑o ‑yitakoŋ 'ɛ 'yrela‑ ‑yi 'ɛ 'lɛzi‑. ");
INSERT INTO moa_vpl VALUES ("MK6_54","071_6_54","MRK","6","54","54","‑O zinale ‑gun ‑yitakoŋ 'ɛ 'yi, 'ke mɛɛ mu 'ɛ ‑o Zesu madɔle 'bhɛ yrɛ do 'ɛ ꞊nɔɔ bhe. ");
INSERT INTO moa_vpl VALUES ("MK6_55","071_6_55","MRK","6","55","55","'Bhɛ klɛle 'tɛ, 'ke mɛɛ mu 'ɛ gele‑ Zesu 'nuza‑ 'ɛ woŋwoŋzɛnlɛ 'klɛɛn 'ɛ 'yi yrɛkpɛn‑ ꞊nɔɔ. 'Bhɛɛ‑ mɛɛ mu 'ɛ 'yaa‑ zan gadɛ mu 'ɛ 'le ‑a ni 'mu 'yila ‑saa mu 'ɛ ta. 'Ke ‑o ‑yaa ma 'kaa ‑yoo yrɛ 'oo yrɛ 'la ꞊nɔɔ, ‑o ‑yaa ge ‑a zi 'bhɛɛ‑ ꞊nɔɔ ye. ");
INSERT INTO moa_vpl VALUES ("MK6_56","071_6_56","MRK","6","56","56","'Kee‑ ‑yaa bhɔ yrɛ 'oo yrɛ 'la ꞊nɔɔ, ‑wa gblaan mu ta oo, ‑wa 'fiɛntrɔnnɛ mu ta oo, ‑bɔn 'yi ‑wanɛ' mu ta oo, mɛɛ mu 'ɛ 'yaa‑ nu ‑waa' gadɛ mu 'ɛ 'lɛkpalɛ ‑kpan mu 'ɛ ta, 'bhɛɛ‑ ‑o ‑yaa ‑sromabɔ Zesu ni dɔɔ: «‑A 'to 'ke 'waa‑ gadɛ mu 'ɛ ‑woo gbɛ yan sa ‑yaa' dunɛ‑ tralapɛ 'ɛ ma.» Gadɛ mu 'la 'kpɛn 'mu gbɛ ‑yaan 'bhɛ ma, 'mu 'kpɛn 'bheela‑. ");
INSERT INTO moa_vpl VALUES ("MK7_1","071_7_1","MRK","7","1","1","Farizi mu 'ɛ 'pegee *'Toŋ daan mu 'ke mu ‑daa Zeruzalɛmu. 'Bhɛɛ‑ ‑o 'pegee Farizi mu 'ɛ ‑ja ‑o ‑lɛkpalɛ Zesu zi. ");
INSERT INTO moa_vpl VALUES ("MK7_2","071_7_2","MRK","7","2","2","‑O ‑yaa' *‑klaŋlanɛ mu 'ɛ 'klɔsikwan, 'bhɛɛ‑ ‑wa ꞊ya 'bhii‑ 'ke 'mu ‑o pɛbhlele, 'mu 'laa ‑yaa 'mu gbɛ mafɛ 'bhii‑ ‑wa klɛ gɔnɛ‑ 'la gbɛɛn‑ Zuufu mu a 'sinii ta za 'ɛ ma. ");
INSERT INTO moa_vpl VALUES ("MK7_3","071_7_3","MRK","7","3","3","Wlan 'ɛ ni, Farizi mu 'ɛ 'pegee Zuufu ‑vin mu 'ɛ 'kpɛn waa ‑yaa sɔ pɛbhlele, 'ke ‑waa ‑o gbɛ mafɛlɛ 'elwale 'pe, 'bhii‑ ‑o ‑yaa klɛ gɔnɛ‑ 'la gbɛɛn‑ ‑o ‑gbɔɔ mu a 'sinii ta za 'ɛ ma. ");
INSERT INTO moa_vpl VALUES ("MK7_4","071_7_4","MRK","7","4","4","'Bhɛ klɛgbɛya do 'ɛ 'yi, 'ke ‑o ‑daa 'plɛɛ 'yi, waa sɔ pɛbhlele, 'ke waa ‑o gbɛ mafɛlɛ 'elwale pe. ‑O ‑gbɔɔ mu ‑o 'sinii ta za ‑bhɛɛke' ‑bebe ꞊twa ‑o ni, 'bhɛɛ‑ ‑o 'mu 'klɔsikun: 'bhɛ 'ke mu ‑le 'bhii‑ ‑waa' ‑yi 'mipɛ‑ mu ‑yifɛgbɛya 'pegee ‑waa' 'trɛgbɔ‑, 'bhɛɛ‑ ‑waa' piibhɛgbɔ mu ‑yifɛgbɛya. ");
INSERT INTO moa_vpl VALUES ("MK7_5","071_7_5","MRK","7","5","5","'Bhɛla ‑zayi' ‑le, Farizi mu 'ɛ 'pegee 'Toŋ Daan mu 'ɛ ‑o Zesu 'lrɔkpaa‑ dɔɔ: «‑Mɛle ꞊kla 'bhɛɛ‑ ‑yaa' pɛ ‑klaŋlanɛ mu 'ɛ waa ‑o 'taawo zii' ‑kɔɔ' ‑gbɔɔ mu a 'sinii ta za mu 'ɛ ta ɛɛ? ‑Mɛle ꞊kla 'bhɛɛ‑ waa ‑o gbɛ mafɛ 'bhii‑ ‑wa klɛ gɔnɛ‑ 'la gbɛɛn‑ ‑kɔɔa' 'sinii ta za 'ɛ ma ɛɛ?» ");
INSERT INTO moa_vpl VALUES ("MK7_6","071_7_6","MRK","7","6","6","Zesu 'a zikpaa‑ ‑o ni 'tɛ dɔɔ: «Mɛɛ ‑yrɛkɔɔza klɛ mu, ‑Waanbhaa' ‑lɛla' janwo mi Ezai ‑jan 'la ꞊woa 'ka ba zayi' 'elwale ‑sɔ, 'bhɛ ꞊kla 'ke wlan 'le. ‑A yɔɔndɛle ‑o ‑a 'kɔɔ 'kaa ‑Waanbhaa' pe dɔɔ: ‹Mɛɛ mu 'lɛɛ‑ ‑woo 'ŋ 'lɛdɔ‑ ‑a ma ‑o ‑liijan' mu 'te ‑la ‑le; 'duŋ‑ ‑o zru mu 'ɛ 'pleŋgole ‑o 'ŋ ma. ");
INSERT INTO moa_vpl VALUES ("MK7_7","071_7_7","MRK","7","7","7","‑Woo 'ŋ gba bhaama, ‑amasrɔyi ‑o mɛɛ mu daan 'ke bhaaplɛŋ mu a 'sinii ta za mu ‑la ‑le.›» ");
INSERT INTO moa_vpl VALUES ("MK7_8","071_7_8","MRK","7","8","8","Zesu pe ‑o ni dɔɔ: «'Ka ‑Waanbhaa' a pɛ 'toŋ mu 'ɛ to ‑a nɔɔ‑, 'bhɛɛ‑ 'ka bhaaplɛŋ mu a 'si ta za mu ‑la ‑klɔsikun.» ");
INSERT INTO moa_vpl VALUES ("MK7_9","071_7_9","MRK","7","9","9","‑E pe ‑o ni 'ezin‑ 'kaa: «'Ka 'ka ‑baŋgo' ‑Waanbhaa' pɛ 'toŋ 'gbu 'ɛ 'yi kpataakpa, 'bhɛɛ‑ 'ka 'kaa‑ 'sinii ta za mu ‑la 'klɔsikun. ");
INSERT INTO moa_vpl VALUES ("MK7_10","071_7_10","MRK","7","10","10","Wlan 'ɛ ni, Moizi pe dɔɔ: ‹'E dɛ 'pegee 'e nɛɛ ‑lɛdɔ' ‑o ma 'elrele›. 'Bhɛɛ‑ ‑ya ꞊pia 'ezin‑ dɔɔ: ‹'Ke mɛɛ 'la zan ‑a dɛ 'pegee ‑a nɛɛ 'daŋganwoa, 'bhɛ zan ‑o 'ke dɛpɛ 'le›. ");
INSERT INTO moa_vpl VALUES ("MK7_11","071_7_11","MRK","7","11","11","'Bhɛɛ‑ 'ka mu 'bhɛ ‑jan 'ɛ maniinaa 'ke 'kaa pe dɔɔ 'ke mɛɛ do 'a ꞊pia ‑a dɛ 'pegee ‑a nɛɛ ni 'kaa ‹'Ŋ 'yaa‑ nu bhɔlɛ 'ka ba 'ŋ 'kɔɔpɛ‑ 'la 'le, 'bhɛ ꞊kla 'ke 'kɔɔban 'le ('bhɛ 'yi ‑le ‑o pɛ 'la ꞊naa ‑Waanbhaa' ni)›. ");
INSERT INTO moa_vpl VALUES ("MK7_12","071_7_12","MRK","7","12","12","'Bhɛ klɛgbɛya 'ɛ 'yi, 'ka 'bhɛ zan 'ɛ ŋgblo 'ɛ siɛ, 'bhɛɛ‑ yaa sɔ ‑a 'gbu 'srɔɔwole 'ke ‑ya 'kɔɔpɛ‑ na ‑a dɛ 'pegee ‑a nɛɛ ni ‑li ‑titi. ");
INSERT INTO moa_vpl VALUES ("MK7_13","071_7_13","MRK","7","13","13","'Bhɛ klɛgbɛya ‑glɔɔn 'ɛ gbɛɛn‑ bhe, 'kaa‑ 'sinii ta za mu 'ɛ ma, ‑Waanbhaa' a ‑jan 'ɛ 'yiga‑ mɛɛ mu 'ɛ ‑yrɛ 'yi. 'Ka 'bhɛɛ‑ 'yansi za ‑glɔɔn ‑bebe klɛ!» ");
INSERT INTO moa_vpl VALUES ("MK7_14","071_7_14","MRK","7","14","14","Zesu ‑zamaa' 'ɛ 'sii gbɛ drɛɛwoa‑ 'ezin‑, 'ke ‑ya pele‑ ‑o ni dɔɔ: «'Ka 'kpɛn, ‑ka 'ka 'trɔnbadɔ doo, 'bhɛɛ‑ ‑ka ‑jan 'lɛɛ‑ 'yima! ");
INSERT INTO moa_vpl VALUES ("MK7_15","071_7_15","MRK","7","15","15","Pɛle 'kedo‑ 'kpɔ 'laa sɔ wlale‑ mɛɛ 'kpee, 'bhɛɛ‑ 'bhɛ 'a 'kpee 'triŋdɔ‑. 'Duŋ‑ pɛ 'la da bhaaplɛŋ 'gbu 'kpee, 'bhɛ ‑le ‑a 'gbu 'kpee 'triŋdɔ‑ ‑Waanbhaa' ‑yrɛ 'yi. ");
INSERT INTO moa_vpl VALUES ("MK7_16","071_7_16","MRK","7","16","16","'Ke ‑jan 'lɛɛ‑ ‑yima' 'trɔn ‑o mɛɛ 'la zan ŋgblo ma, ‑ya ‑yima'.» ");
INSERT INTO moa_vpl VALUES ("MK7_17","071_7_17","MRK","7","17","17","Zesu ‑gwa ‑zamaa' 'ɛ ‑din, 'bhɛɛ‑ ‑e ‑ja wlalɛ 'fɛ 'ɛ ꞊la 'waati 'la ba, 'ke ‑yaa' ‑klaŋlanɛ mu 'ɛ ‑o 'yee‑ ‑gɔɔn 'ɛ 'yilrɔkpale 'a ma. ");
INSERT INTO moa_vpl VALUES ("MK7_18","071_7_18","MRK","7","18","18","'Bhɛ klɛle 'tɛ, 'ke Zesu 'a 'pele ‑o ni dɔɔ: «'Ka mu 'ezin‑, 'ka mu laa 'bhɛ 'yima‑ ɛɛ? 'Ka mu 'laa 'yaango‑ 'bhii‑ 'pɛɛlii‑ pɛ 'kedo‑ 'kpɔ 'laa sɔ wlale‑ mɛɛ 'kpee 'bhɛɛ‑ ‑ya 'kpee 'triŋdɔ‑ ɛɛ? ");
INSERT INTO moa_vpl VALUES ("MK7_19","071_7_19","MRK","7","19","19","‑Amasrɔyi, pɛle laa wla mɛɛ zru 'ɛ 'yi, ‑e ge mɛɛ vi 'ɛ 'bhɛɛ‑ 'yi; 'bhɛɛ‑ ‑e klɛ 'ke blinpɛ 'le boolazi.» (Zesu 'bhɛ ‑jan 'lɛɛ‑ 'woa‑ win 'la ma 'bhɛ 'yi ‑le dɔɔ: Mɛɛ sɔ pɛle 'tɔle‑ pɛ 'bhɛ 'bhlele.) ");
INSERT INTO moa_vpl VALUES ("MK7_20","071_7_20","MRK","7","20","20","‑E pe ‑o ni 'ezin‑ dɔɔ: «Pɛ 'la mɛɛ 'kpee 'triŋdɔ‑ ‑Waanbhaa' ‑yrɛ 'yi, 'bhɛ da 'e 'gbu zru 'ɛ 'bhɛɛ‑ 'yi. ");
INSERT INTO moa_vpl VALUES ("MK7_21","071_7_21","MRK","7","21","21","‑Amasrɔyi, 'kpeejan‑ ‑yɔɔ' mu 'ɛ 'kpɛn da bhaaplɛŋ 'gbu zru 'ɛ 'bhɛɛ‑ 'yi 'bhii‑ 'kɛ mu 'lɛɛ gbɛɛn‑: 'joo 'yɔɔ‑ oo, ‑faan zru oo, mɛɛ dɛ zru oo, ");
INSERT INTO moa_vpl VALUES ("MK7_22","071_7_22","MRK","7","22","22","‑yanbhɔɔya zru oo, ‑naflo zru oo, yiɛnya oo, ‑dawliya oo, 'taawogbɛya ‑yɔɔ' oo, zranwole oo, mɛɛ 'tɔsiɛle oo, 'e 'gbu magbaandɛle oo, 'bhɛ 'pegee ‑zadɔkleya. ");
INSERT INTO moa_vpl VALUES ("MK7_23","071_7_23","MRK","7","23","23","'Bhɛ ‑za 'yɔɔ‑ mu 'la bhe, 'mu ‑la 'kpɛn da mɛɛ zru 'ɛ 'yi, 'bhɛɛ‑ 'mu ‑le mɛɛ 'kpee 'triŋdɔ‑.» ");
INSERT INTO moa_vpl VALUES ("MK7_24","071_7_24","MRK","7","24","24","Zesu gole 'bhɛ yrɛ 'ɛ ꞊nɔɔ, 'kee‑ gele Tiri 'klɛɛn 'ɛ 'yi. ‑E bhɔle 'bhɛ ꞊nɔɔ, 'kee‑ gele‑ wlalɛ 'fɛ do ‑la; 'bhɛɛ‑ yaa ‑yaa zi 'bhii‑ mɛɛ 'kedo‑ 'kpɔ 'a 'yaango‑ 'bhii‑ ‑yoo 'bhɛ 'fɛ 'ɛ ꞊la; 'duŋ‑ ‑a tagaanle laa bolɛ. ");
INSERT INTO moa_vpl VALUES ("MK7_25","071_7_25","MRK","7","25","25","‑Amasrɔyi, lii 'yɔɔ‑ ‑yaa le do ‑lunɛ' do zi. 'Bhɛ yrɛ do 'ɛ ꞊nɔɔ bhe, le 'ɛ ‑ya 'male‑ 'kaa Zesu ꞊nwa, 'kee‑ gele‑ baalɛ Zesu gaan ma. ");
INSERT INTO moa_vpl VALUES ("MK7_26","071_7_26","MRK","7","26","26","'Bhɛ le 'ɛ 'bhɛ 'laa ‑yaa 'ke Zuufu le 'le, 'bhɛ ‑yaa da Sirofenisi 'klɛɛn 'ɛ 'yi. ‑E ‑sromabwa Zesu ni dɔɔ 'bhɛ lii 'yɔɔ‑ 'ɛ ‑gbin ‑a ‑lunɛ' 'ɛ zi. ");
INSERT INTO moa_vpl VALUES ("MK7_27","071_7_27","MRK","7","27","27","'Bhɛɛ‑ 'duŋ‑, Zesu pe ‑a ni dɔɔ: «‑A 'to ‑nɛ mu 'ɛ pɛbhle 'pe 'bhɛɛ‑ ‑o kpɛdɔ. ‑Amasrɔyi, 'kee ‑nɛ mu a pɛbhle ꞊sia ‑o ‑la, 'bhɛɛ‑ 'ya ‑blinna ‑gbaan' mu 'ɛ ni, 'bhɛ 'laa lele.» ");
INSERT INTO moa_vpl VALUES ("MK7_28","071_7_28","MRK","7","28","28","'Yee‑ le 'ɛ pe Zesu ni dɔɔ: «'Bhɛ ‑o 'ke wlan 'le Mɛɛzan, 'bhɛɛ‑ 'duŋ‑, 'ke ‑nɛ mu ‑o pɛbhle 'zi, ‑gbaan' mu 'ɛ ‑o pɛ piinɛ‑ mu 'la balaa' ‑nɛ mu 'ɛ 'kɔɔ pɛbhle ‑tabali 'ɛ ꞊la 'trɛ ma, 'mu 'bhɛ mu ‑la bhle.» ");
INSERT INTO moa_vpl VALUES ("MK7_29","071_7_29","MRK","7","29","29","'Bhɛ 'yi 'tɛ, 'ke Zesu 'a 'pele ‑a ni dɔɔ: «Le ‑nɛ, 'e ‑jan 'la ꞊woa bhe, 'bhɛ ‑zayi', ge 'e ba ‑lɛ ma; lii ‑yɔɔ' 'ɛ ‑gwa 'e 'lunɛ 'ɛ zi.» ");
INSERT INTO moa_vpl VALUES ("MK7_30","071_7_30","MRK","7","30","30","'Yee‑ le 'ɛ 'nule‑ ‑a ba ‑lɛ ma 'tɛ, 'kee‑ bhɔle‑ ‑a ‑lunɛ' 'ɛ 'yila‑ le ta ‑saa 'ɛ ta. 'Bhɛ bhla 'ɛ ba 'ke lii 'yɔɔ‑ 'ɛ ‑gwa gban 'bhɛ zi. ");
INSERT INTO moa_vpl VALUES ("MK7_31","071_7_31","MRK","7","31","31","Zesu gole Tiri 'klɛɛn 'ɛ 'yi, 'kee‑ 'kanle Sidɔn ‑wa 'ɛ ta, 'bhɛɛ‑ ‑e ‑yaa zan bhla 'la ba Galile ‑draa 'ɛ ba ‑yrɛ ta, 'kee 'kanle ‑wa vu ‑o 'klɛɛn 'la 'yi 'bhɛ 'yi. ");
INSERT INTO moa_vpl VALUES ("MK7_32","071_7_32","MRK","7","32","32","Mɛɛ 'ke mu ‑nwa 'ke 'bhobho 'trɔn 'wile do 'le ‑a ba. 'Bhɛɛ‑ 'ke ‑o ‑sromabɔle ‑a ni dɔɔ ‑ya gbɛ 'kpa 'bhɛ 'bhobho 'trɔn 'wile‑ mi 'ɛ ma, 'bhɛɛ‑ 'bhɛ bhee. ");
INSERT INTO moa_vpl VALUES ("MK7_33","071_7_33","MRK","7","33","33","'Bhɛ klɛle 'tɛ, 'ke Zesu 'bhobho 'trɔn 'wile‑ 'ɛ pleŋgole ‑zamaa' 'ɛ ma, 'kee‑ gele‑ 'kɛle‑ 'edaŋma. 'Bhɛɛ‑ 'ke ‑ya gbɛ ‑nɛbhɛ' plɛ wlale‑ 'bhɛ 'trɔn mu 'ɛ 'yi. 'Bhɛɛ, 'ke ‑ya ‑liile' bɔle‑ ‑a gbɛ ‑nɛbhɛ' do ma, 'bhɛɛ‑ 'kee‑ 'bhɛ ‑zwanle' 'yee‑ 'bhobho 'ɛ nrɛ 'ɛ ma. ");
INSERT INTO moa_vpl VALUES ("MK7_34","071_7_34","MRK","7","34","34","'Bhɛ blaan, 'ke Zesu 'e 'yrɛkpale laanima, 'ke ‑ya 'trɛle 'eglɔɔle, 'bhɛɛ‑ 'ke ‑ya pele‑ dɔɔ: «Efata!» 'Bhɛ 'yile 'kaa: «‑Ka 'ka 'liiploo‑!» ");
INSERT INTO moa_vpl VALUES ("MK7_35","071_7_35","MRK","7","35","35","'Bhɛ yrɛ do 'kpɔ 'ɛ ꞊nɔɔ bhe, 'ke 'yee‑ mɛɛ 'ɛ 'trɔn mu 'ɛ 'liiploole, 'ke ‑a nrɛ 'ɛ tagbiŋgole, 'bhɛɛ‑ 'kee‑ ‑jan 'wole 'sanle 'elrele. ");
INSERT INTO moa_vpl VALUES ("MK7_36","071_7_36","MRK","7","36","36","'Bhɛ blaan, 'ke Zesu 'nule mɛɛ mu 'ɛ ta, 'bhɛɛ‑ 'kee‑ 'yee‑ 'bhobho 'ɛ 'madɔ‑ mu 'ɛ 'kpɛn 'lɛmazɔnle 'kaa waa 'bhɛ ‑za 'ɛ 'yigɔɔnlɛ mɛɛ 'kedo‑ 'kpɔ ni. Drɔɔn' ‑yoo ‑lɛmalazwan bhe, 'woo‑ mɛɛ mu 'ɛ ‑ja ‑waa' mɛɛ 'ɛ 'bheeza‑ 'ɛ woŋwoŋ baan' zɛnlɛ yrɛkpɛn‑ ꞊nɔɔ. ");
INSERT INTO moa_vpl VALUES ("MK7_37","071_7_37","MRK","7","37","37","Mɛɛ mu 'ɛ ‑o 'kpɛn 'liibhaala ‑o ma 'kee kan a ‑daŋ' ta. 'Bhɛɛ‑ ‑o ‑yaa pe 'zi 'tɛ 'kaa: «Mɛɛ 'lɛɛ‑ klɛza mu 'ɛ 'kpɛn ‑o 'elrele. 'Bhɛɛ‑ ‑e sɔ ‑a klɛle‑ drɔɔn' 'bhɛɛ‑ 'trɔn 'wile‑ mu ‑jan ma, 'bhɛ 'pegee 'bhobho mu ‑janwo'.» ");
INSERT INTO moa_vpl VALUES ("MK8_1","071_8_1","MRK","8","1","1","'Bhɛ 'waati 'ɛ ba, ‑zamaa' 'srɛ ‑gbɛnɛ do ‑nwa ‑o ‑lɛkpalɛ ‑a zi 'ezin‑. 'Bhɛɛ‑ pɛle laa ‑yaa ‑o 'kɔɔ. 'Bhɛ klɛle 'tɛ, 'ke Zesu ‑yaa' ‑klaŋlanɛ mu 'ɛ 'siile, 'bhɛɛ‑ 'ke ‑ya pele‑ ‑o ni 'kaa: ");
INSERT INTO moa_vpl VALUES ("MK8_2","071_8_2","MRK","8","2","2","«Mɛɛ mu 'lɛɛ‑ ‑yrɛnkla' zii' 'ŋ ma, ‑amasrɔyi ‑o ‑yrekpaa' yaga ‑le ‑gɛ 'ke ‑woo ‑kɔɔ' zi, 'bhɛɛ‑ pɛle laa ‑o 'kɔɔ ‑li. ");
INSERT INTO moa_vpl VALUES ("MK8_3","071_8_3","MRK","8","3","3","'Ke 'ŋ 'ploola‑ ‑o ma ‑o gbɔndɛle 'ɛ 'le, ‑o ‑gblɔzi' nu galɛ ‑o ma ‑o ge bhla 'ɛ zi ‑o ba ‑wa la zi 'ɛ 'lii gbɔn 'ɛ 'kɔɔ. ‑Amasrɔyi ‑o ‑bebe ‑daa yrɛ gbɔɔn nɔɔ‑.» ");
INSERT INTO moa_vpl VALUES ("MK8_4","071_8_4","MRK","8","4","4","'Bhɛ 'yi 'tɛ, 'ke ‑yaa' ‑klaŋlanɛ mu 'ɛ ‑wa pele‑ ‑a ni 'kaa: «'O nu pɛle ‑srɔɔwolɛ yrɛ 'ɛ ‑dela nɔɔ‑ ‑gɛ, 'bhɛɛ‑ 'o pɛle na ‑o ni, 'bhɛɛ‑ ‑o kpɛdɔ ‑bɔn 'yi yrɛ 'lɛɛ‑ ꞊nɔɔ ɛɛ?» ");
INSERT INTO moa_vpl VALUES ("MK8_5","071_8_5","MRK","8","5","5","Zesu ‑o ‑lrɔkpale 'kaa: «'bluu 'wɛɛ‑ ‑le 'ka 'kɔɔ ɛɛ?» 'Ke ‑wa ‑lɛkunle a ni dɔɔ: «'Srwaplɛ‑.» ");
INSERT INTO moa_vpl VALUES ("MK8_6","071_8_6","MRK","8","6","6","'Bhɛ klɛle 'tɛ, 'ke ‑ya pele‑ ‑zamaa' 'ɛ ni ‑o yala‑ 'trɛ ma. 'Bhɛɛ‑ ‑e 'bluu 'srwaplɛ‑ 'ɛ 'sile‑, 'kee‑ ‑Waanbhaa' 'pubɔle 'mu ma, 'ke ‑yoo takanle 'bhɛɛ‑ 'ke ‑ya 'kpale ‑yaa' ‑klaŋlanɛ mu 'ɛ 'kɔɔ dɔɔ ‑woo ‑yiciɛn' ‑zamaa' 'ɛ ma. 'Bhɛɛ‑ 'ke 'mu 'bhɛ klɛle‑. ");
INSERT INTO moa_vpl VALUES ("MK8_7","071_8_7","MRK","8","7","7","Kaanɛ‑ 'ke mu ‑yaa ‑o 'kɔɔ 'ezin‑. Zesu ‑Waanbhaa' 'pubwa‑ 'bhɛ kaanɛ‑ mu 'ɛ ma, 'ke ‑ya pele‑ ‑yaa' ‑klaŋlanɛ mu 'ɛ ni 'kaa ‑woo ‑yiciɛn' mɛɛ mu 'ɛ ma 'ezin‑. ");
INSERT INTO moa_vpl VALUES ("MK8_8","071_8_8","MRK","8","8","8","‑O 'kpɛn pɛ 'ɛ ꞊bhla, 'bhɛɛ‑ ‑o kpɛdwa‑. Zesu a ‑klaŋlanɛ mu 'ɛ ‑o ciɛ ‑nɛ ꞊yan 'srwaplɛ‑ ‑la ‑paa 'ke 'bluu kpu mu 'la ꞊bwa ‑o blaan 'mu 'le. ");
INSERT INTO moa_vpl VALUES ("MK8_9","071_8_9","MRK","8","9","9","‑O ‑yaa bhɔ 'gwlaan‑ 'waa yiziɛ ‑din (4.000). ‑O yanle pɛbhlelele, 'ke Zesu 'ploole mɛɛ mu 'ɛ ma 'tɛ. ");
INSERT INTO moa_vpl VALUES ("MK8_10","071_8_10","MRK","8","10","10","'Bhɛ yrɛ do 'ɛ ꞊nɔɔ bhe, 'ke 'yee‑ 'pegee ‑yaa ‑klaŋlanɛ mu 'ɛ 'sanle ‑yitakoŋ 'ɛ 'yi, 'bhɛɛ‑ 'ke ‑o gele‑ Dalimanuta 'trɛ 'ɛ ta. ");
INSERT INTO moa_vpl VALUES ("MK8_11","071_8_11","MRK","8","11","11","‑O bhɔle 'bhɛ 'klɛɛn 'ɛ 'yi 'tɛ, 'ke Farizi mu 'ɛ 'nule‑ zaabɔlɛ Zesu 'lɛ ma. ‑O ‑yaa ‑a zi 'bhii‑ ‑o ‑jan bhee 'kpala ‑a ‑lɛɛ, 'bhɛɛ‑ 'ke ‑wa pele‑ ‑a ni dɔɔ: «‑Tɔɔmasie do klɛ 'ke 'bhɛ 'a zrɔn 'o ni 'bhii‑ 'e da ‑Waanbhaa' ba.» ");
INSERT INTO moa_vpl VALUES ("MK8_12","071_8_12","MRK","8","12","12","Zesu 'e 'trɛle ‑a nii‑ 'yi 'eglɔɔle, 'bhɛɛ‑ 'ke ‑ya pele‑ ‑o ni dɔɔ: «‑Mɛle ꞊kla 'bhɛɛ‑ 'saanigɛ mu 'ɛ ‑woo 'sɔle‑ maza do ‑yrɛ wo zii' ɛɛ? 'Mi pe 'ka ni 'ŋ 'sɔwɛɛ‑ ma 'kaa 'naa nu 'sɔle‑ maza do 'kpɔ klɛlɛ 'woo‑ 'saanigɛ mu 'lɛɛ‑ ‑yrɛ ma!» ");
INSERT INTO moa_vpl VALUES ("MK8_13","071_8_13","MRK","8","13","13","'Bhɛ blaan, 'kee‑ gole‑ Farizi mu 'ɛ ‑din, 'bhɛɛ‑ 'kee‑ 'sanle ‑yitakoŋ 'ɛ 'yi, 'kee‑ gele‑ 'ezin‑ ‑draa ‑yrɛ gbɛ do 'ɛ ta. ");
INSERT INTO moa_vpl VALUES ("MK8_14","071_8_14","MRK","8","14","14","'Bluu 'sile‑ ꞊nia Zesu a ‑klaŋlanɛ mu 'ɛ 'kpee, 'fɔ 'bluu do 'kpɔ ‑le ‑yaa ‑o 'kɔɔ ‑yitakoŋ 'ɛ 'yi. ");
INSERT INTO moa_vpl VALUES ("MK8_15","071_8_15","MRK","8","15","15","Zesu ‑jan 'lɛɛ‑ 'bhɛ 'kpankpanyaan ‑o ma dɔɔ: «‑Ka 'ka 'yrɛkpa 'ka 'gbu ba 'elrele, Farizi mu 'ɛ 'pegee *Erɔdi a 'bluu ‑pɛɛ 'wlɛn 'sɛkɛ 'ɛ ma.» ");
INSERT INTO moa_vpl VALUES ("MK8_16","071_8_16","MRK","8","16","16","'Bhɛ 'yi 'tɛ, 'ke ‑yaa' ‑klaŋlanɛ mu 'ɛ ‑zaabɔle 'sanle 'eke‑ ‑lɛ ma 'ke ‑wa pele‑ 'eke‑ ni dɔɔ: «'Waa 'bluu 'la 'silɛ‑ 'ebebele bhe, 'bhɛla‑ ‑yile ‑yoo ‑jan ‑glɔɔn 'lɛɛ‑ 'bhɛ 'wo zii' ɛɛ?» ");
INSERT INTO moa_vpl VALUES ("MK8_17","071_8_17","MRK","8","17","17","Zesu 'bhɛ yaangole, 'ke ‑yoo ‑lrɔkpale dɔɔ: «‑Mɛle ꞊kla 'bhɛɛ‑ 'ka ‑o zaabɔ 'zi 'ke 'kaa pe ‑mɛla ma 'bluu 'laa ‑o 'o 'kɔɔ ɛɛ? 'Ali‑ 'kee‑ 'tɛn ‑zɔn, 'ka 'laa 'mi klɛza mu 'ɛ 'yimalɛ ‑li ɛɛ? 'Ka 'trɔn 'yi 'eglɔɔle 'dɛ? ");
INSERT INTO moa_vpl VALUES ("MK8_18","071_8_18","MRK","8","18","18","'Ka 'yrɛbhɛ‑ mu ‑o, 'bhɛɛ‑ 'ka 'laa ‑yrɛ ma ye ɛɛ? 'Ka 'trɔn mu ‑o, 'bhɛɛ‑ 'ka 'laa ‑jan ma ɛɛ? 'Bhɛ 'laa ‑o ‑li 'ka 'kpee ɛɛ? ");
INSERT INTO moa_vpl VALUES ("MK8_19","071_8_19","MRK","8","19","19","'Ŋ 'bluu 'soo 'la takaan‑ mɛɛ 'waa 'soo (5.000) 'ɛ ma, ‑o kpu mu 'la ꞊bwa, 'ka ciɛ ‑nɛ ꞊yan 'wɛɛ‑ ‑la ‑paa 'ke ‑o ‑le ɛɛ?» ‑O pe dɔɔ: «Vu ta plɛ.» ");
INSERT INTO moa_vpl VALUES ("MK8_20","071_8_20","MRK","8","20","20","«'Bhɛɛ‑ 'ŋ 'bluu 'srwaplɛ‑ 'la takaan‑ mɛɛ 'waa yiziɛ 'ɛ ma, 'ka ciɛ ‑nɛ ꞊yan 'wɛɛ‑ ‑la ‑paa 'ke ‑o kpu mu 'la ꞊bwa 'mu 'le ɛɛ?» ‑O pe dɔɔ: «'Srwaplɛ‑.» ");
INSERT INTO moa_vpl VALUES ("MK8_21","071_8_21","MRK","8","21","21","'Bhɛ 'yi 'tɛ, 'ke ‑ya pele‑ ‑o ni dɔɔ: «'Ka 'laa ‑a 'yimalɛ ‑li ɛɛ?» ");
INSERT INTO moa_vpl VALUES ("MK8_22","071_8_22","MRK","8","22","22","Zesu 'pegee ‑yaa' ‑klaŋlanɛ mu 'ɛ ꞊nwa Bɛtisaida ‑wa 'ɛ ta. 'Bhɛɛ‑ 'ke mɛɛ mu 'ɛ 'nule ‑yrɛ 'wi mi do 'le Zesu ba, 'ke ‑o ‑sromabɔle ‑a ni 'kaa ‑ya gbɛ 'kpa 'bhɛ ma, 'bhɛɛ‑ ‑e 'bhɛ bhee. ");
INSERT INTO moa_vpl VALUES ("MK8_23","071_8_23","MRK","8","23","23","'Bhɛ klɛ le 'tɛ, 'ke Zesu ‑yrɛ 'wi mi 'ɛ 'kunle‑ 'bhɛ gbɛ ma, 'kee‑ gele‑ 'kɛle‑ ‑wa 'ɛ ‑zanta'. 'Bhɛɛ‑ 'ke ‑ya ‑liile' ‑glɔɔle' 'bhɛ 'yrɛbhɛ‑ mu 'ɛ ta, 'ke ‑ya gbɛ 'kpale 'mu ta, 'bhɛɛ‑ 'kee‑ 'bhɛ ‑lrɔkpale dɔɔ: «'E yrɛ ma ya ɛɛ?» ");
INSERT INTO moa_vpl VALUES ("MK8_24","071_8_24","MRK","8","24","24","‑Yrɛ 'wi mi 'ɛ ‑ya ‑yrɛ 'liiploola 'ke ‑ya pele‑ dɔɔ: «'Ŋ 'yrɛ ‑o mɛɛ mu ma, ‑woo 'bhii‑ ‑yri diiŋ mu gbɛɛn‑, ‑woo 'taawo zii'.» ");
INSERT INTO moa_vpl VALUES ("MK8_25","071_8_25","MRK","8","25","25","Zesu 'e gbɛ 'kpa gbɛ drɛɛwoa‑ 'ezin‑ 'yee‑ mɛɛ 'ɛ 'yrɛbhɛ‑ mu 'ɛ ta. 'Ke ‑ya ‑yrɛkpale ‑a ‑lɛɛ siiŋ, 'bhɛɛ‑ ‑e ‑bheela, kee‑ yrɛ ma 'yele 'weŋ. ");
INSERT INTO moa_vpl VALUES ("MK8_26","071_8_26","MRK","8","26","26","'Bhɛ blaanta 'tɛ, 'ke Zesu 'ploole ‑a ma, 'bhɛɛ‑ 'ke ‑ya pele‑ ‑a ni dɔɔ: «Ge 'e ba ‑lɛ ma, 'duŋ‑ 'yaa 'kanlɛ‑ ‑wa 'ɛ 'kpee.» ");
INSERT INTO moa_vpl VALUES ("MK8_27","071_8_27","MRK","8","27","27","Zesu 'pegee ‑yaa' *‑klaŋlanɛ mu 'ɛ ‑o ‑ja Sezare Filipu ‑din ‑wa mu 'ɛ ba ‑yrɛ ta. ‑O ‑yaa zi 'ɛ 'lii bhla 'la ba, 'ke ‑yoo ‑lrɔkpale 'tɛ 'kaa: «Mɛɛ mu 'ɛ ‑woo 'mi 'kun zii' mɛɛ ‑glɔɔn 'ɛ ‑dela ‑le ɛɛ?» ");
INSERT INTO moa_vpl VALUES ("MK8_28","071_8_28","MRK","8","28","28","‑Yaa' ‑klaŋlanɛ mu 'ɛ ‑wa ‑lɛkwan ‑a ni dɔɔ: «Mɛɛ 'ke mu pe 'yoo‑ 'ke Mɛɛ Wiiŋfɛ' Mi Zaan 'le, ‑a 'ke mu pe 'yoo‑ Eli 'le. 'Bhɛɛ‑ ‑a 'ke mu pe 'ezin‑ 'kaa 'yoo‑ ‑Waanbhaa' ‑lɛla' janwo mu 'ɛ do 'le.» ");
INSERT INTO moa_vpl VALUES ("MK8_29","071_8_29","MRK","8","29","29","Zesu ‑o ‑lrɔkpaa 'ezin‑ dɔɔ: «'Bhɛɛ‑ 'ka mu 'lɛɛ‑, 'ka mu 'kpee ma 'mi ‑o 'ke ‑dela ‑le ɛɛ?» Piɛri pe ‑a ni dɔɔ: «'Bhi ‑le Krisi 'le, ‑Waanbhaa' Mɛɛ ‑Bhee Mi ‑Kpɔsɔɔ 'gbu 'la ꞊kpaa 'bhɛ 'le.» ");
INSERT INTO moa_vpl VALUES ("MK8_30","071_8_30","MRK","8","30","30","'Bhɛ 'yi 'tɛ, 'ke Zesu ‑o ‑lɛmazɔnle 'eglɔɔle dɔɔ: «'Ka 'laa 'bhɛ 'pelɛ‑ mɛɛ 'kedo‑ ni.» ");
INSERT INTO moa_vpl VALUES ("MK8_31","071_8_31","MRK","8","31","31","'Bhɛ blaan, 'ke Zesu ‑yaa' ‑klaŋlanɛ mu 'ɛ daanle 'sanle gɔnɛ‑ 'lɛɛ‑ 'bhɛɛ‑ gbɛɛn‑ dɔɔ: «‑A ‑lɛdulale ‑o dɔɔ Bhaaplɛŋ Gbe 'ɛ nu ‑yrɛnbhlelɛ 'ebebele, Zuufu mu a 'gwlaan‑ gblaan mu 'ɛ, 'pegee'sraka 'lɛna ‑kuŋlii' mu 'ɛ, 'bhɛ 'pegee 'Toŋ daan mu 'ɛ nu ‑o ‑baŋgolɛ ‑a ‑yi. ‑O nu a klɛlɛ 'bhɛɛ‑ ‑wa dɛ, 'duŋ‑ ‑a gale blaan ‑yrekpaa' yaga mi ma, ‑e nu bwelɛ gale ba.» ");
INSERT INTO moa_vpl VALUES ("MK8_32","071_8_32","MRK","8","32","32","Zesu 'yaa‑ 'bhɛ ‑za mu 'ɛ 'wo zii' ‑o ni kpataakpa. ‑Ayile, 'ke Piɛri ‑a 'siile mɛɛ mu 'ɛ 'yrɛ ‑gɔma', 'bhɛɛ‑ 'ke ‑ya pele‑ Zesu ni dɔɔ: «'Yaa ‑janwolɛ 'bhɛ gbɛɛn‑ ‑gee'!» ");
INSERT INTO moa_vpl VALUES ("MK8_33","071_8_33","MRK","8","33","33","'Duŋ‑ Zesu 'niinale 'ke ‑ya ‑yrɛkpale ‑yaa' ‑klaŋlanɛ mu 'ɛ ta, 'kee‑ ‑lale' Piɛri ta, 'ke ya pele‑ 'bhɛ ni dɔɔ: «'E 'pleŋgo 'ŋ ma, ‑Setran' mɛɛ! ‑Amasrɔyi 'e 'kpeejan‑ mu 'ɛ waa ‑o 'ke ‑Waanbhaa' 'kpeejan‑ mu 'le, 'fɔ bhaaplɛŋ mu 'kpeejan‑ 'te.» ");
INSERT INTO moa_vpl VALUES ("MK8_34","071_8_34","MRK","8","34","34","'Bhɛ blaan, 'ke Zesu ‑zamaa' 'ɛ 'pegee ‑yaa' ‑klaŋlanɛ mu 'ɛ 'siile, 'bhɛɛ‑ 'ke ‑ya pele‑ ‑o ni dɔɔ: «'Ke mɛɛ 'la zan ‑a zi 'bhii ‑e klɛ 'ŋ zi mi 'le, ‑ya ‑baŋgo' ‑a 'gbu 'yi, ‑e yaa ‑yrigbɛɛle 'ɛ 'si, 'bhɛɛ‑ ‑e nu dɔ 'ŋ zi. ");
INSERT INTO moa_vpl VALUES ("MK8_35","071_8_35","MRK","8","35","35","‑Amasrɔyi, 'ke mɛɛ 'la zan ‑a zi 'bhii‑ ‑ya 'gbu ‑si 'ɛ go ‑za 'yi, 'bhɛ zan nu bloolɛ 'bhɛ 'si 'ɛ 'yi. 'Duŋ‑ 'ke mɛɛ la zan 'e zru ‑gwa 'bhɛ 'gbu 'si 'ɛ ni 'mi 'pegee ‑Jan 'Nrale‑ 'ɛ ‑zayi', 'bhɛ zan ‑si 'ɛ nu golɛ ‑za 'yi. ");
INSERT INTO moa_vpl VALUES ("MK8_36","071_8_36","MRK","8","36","36","'Ke mɛɛ do 'trɛ ta pɛ mu 'ɛ 'kpɛn 'srɔɔwoa‑, 'ke yaa ‑Waanbhaa ba bole ‑yrɛ ‑si 'ɛ 'srɔɔwolɛ, 'bhɛ ‑trɔn ‑o ma ‑mɛla ‑le ɛɛ? ");
INSERT INTO moa_vpl VALUES ("MK8_37","071_8_37","MRK","8","37","37","Bhaaplɛŋ sɔ ‑a 'gbu 'si 'ɛ tagbawole 'ke ‑mɛla ‑le ɛɛ? ");
INSERT INTO moa_vpl VALUES ("MK8_38","071_8_38","MRK","8","38","38","'Ke mɛɛ 'la zan ‑yralakpaa 'mi 'pegee 'an ‑jan mu 'ɛ 'lɛɛ ‑zɔn mɛɛ mu 'ɛ 'pleŋ‑, 'woo‑ 'la ‑o zru laa ‑o do ‑Waanbhaa' ni, 'bhɛɛ‑ ‑woo 'ke ‑za 'yɔɔ‑ klɛ mu 'le bhe. 'Bhɛ 'yi Bhaaplɛŋ Gbe 'ɛ nu yralakpalɛ 'bhɛ zan 'ɛ ‑lɛɛ, 'ke 'yee‑ 'pegee ‑mlɛkɛ' 'weŋ mu 'ɛ ꞊nwa yi 'la 'le ‑a Dɛ a 'tɔbhɔleya 'ɛ 'yi.» ");
INSERT INTO moa_vpl VALUES ("MK9_1","071_9_1","MRK","9","1","1","Zesu pe ‑o ni 'ezin‑ dɔɔ: «'Mi pe 'ka ni 'ŋ 'sɔwɛɛ‑ ma, 'ka mu 'la 'ka ‑o ‑gɛ ‑zɔn, 'ka 'ke gale pleŋ‑, 'mu nu ‑Waanbhaa' a ‑Bhleŋgbeya 'ɛ 'nule yelɛ ‑yaa' ‑glɔɔya' 'le.» ");
INSERT INTO moa_vpl VALUES ("MK9_2","071_9_2","MRK","9","2","2","‑Yrekpaa' 'srwado‑ 'kanle‑ blaan, 'ke Zesu Piɛri 'bhɛɛ‑ Zaki 'pegee Zaan 'sile, 'ke ‑o gele‑ 'edaŋma vlɛ gɔɔn 'trole‑ do wiiŋ‑, 'bhɛɛ‑ 'ke ‑ya dɔgbɛya 'ɛ mabɔɔle 'mu 'yrɛ ma. ");
INSERT INTO moa_vpl VALUES ("MK9_3","071_9_3","MRK","9","3","3","‑A ta dunɛ‑ mu 'ɛ 'fleela‑ 'epu 'peŋpeŋle. ‑O ꞊kla 'epule gɔnɛ‑ 'la gbɛɛn‑, 'bhɛ mɛɛ laa ‑srɔɔwo' 'trɛ 'lɛɛ‑ ta ‑gɛ 'ke 'bhɛ sɔ sɔ 'fɛle 'bhɛɛ‑ ‑ya flee 'bhii‑ ‑a ta dunɛ‑ mu 'ɛ 'fleegbɛya 'ɛ gbɛɛn‑. ");
INSERT INTO moa_vpl VALUES ("MK9_4","071_9_4","MRK","9","4","4","'Bhɛ yrɛ do 'ɛ ꞊nɔɔ bhe, ‑yaa' *‑klaŋlanɛ yaga 'ɛ 'mu 'elwaleta ‑Waanbhaa' ‑lɛla' janwo mi plɛ ꞊ya, Eli 'pegee *Moizi 'ke ‑woo ‑balo klɛ 'zi Zesu 'le. ");
INSERT INTO moa_vpl VALUES ("MK9_5","071_9_5","MRK","9","5","5","'Bhɛ klɛle 'tɛ, 'ke Piɛri 'a 'pele Zesu ni: «'O Daan mi, 'o klɛlawoa ‑gɛ 'bhɛ 'lrela‑ 'dɛ. 'O nu 'kpaanɛ yaga dɔlɛ, 'bhi a pɛ do, Moizi a pɛ do, 'bhɛɛ‑ Eli ‑a pɛ do.» ");
INSERT INTO moa_vpl VALUES ("MK9_6","071_9_6","MRK","9","6","6","Wlan 'ɛ ni, ‑e ‑yaa ‑jan yɛkɛ‑ 'gbu 'la wo, yaa ‑yaa 'bhɛ dɔ, ‑amasrɔyi ‑gblaan ‑yaa 'yee‑ 'pegee ‑klaŋlanɛ ‑vin plɛ 'ɛ ‑o ‑yi. ");
INSERT INTO moa_vpl VALUES ("MK9_7","071_9_7","MRK","9","7","7","Laflɛ' ‑gblɛn do ‑nwa ‑o trala, 'bhɛɛ‑ 'bhɛ lii 'ɛ ꞊kpaa ‑o ta. 'Ke ‑weli' do dale‑ 'bhɛ laflɛ' ‑gblɛn 'ɛ 'yi 'ke 'bhɛ 'a pele‑ dɔɔ: «'Ŋ Gbe 'la ‑za sɔ 'ŋ ni 'egbɛnɛle 'yele‑ ‑gɛ, ‑ka 'ka 'trɔnbadɔ ‑a ni 'elrele!» ");
INSERT INTO moa_vpl VALUES ("MK9_8","071_9_8","MRK","9","8","8","'Bhɛ yrɛ do 'ɛ ꞊nɔɔ bhe, 'ke ‑yaa' ‑klaŋlanɛ mu 'ɛ ‑woo ‑yrɛ 'mliŋgole ‑o 'zi, 'bhɛɛ‑ waa mɛɛ 'kedo‑ 'kpɔ 'yelɛ‑ 'ezin‑, 'ke yaa 'e go Zesu do ‑kplɛn ba. ");
INSERT INTO moa_vpl VALUES ("MK9_9","071_9_9","MRK","9","9","9","Zesu 'pegee ‑yaa' ‑klaŋlanɛ mu 'ɛ zina‑ bhla 'ɛ zi vlɛ gɔɔn 'ɛ 'wiiŋ‑, Zesu ‑o ‑lɛmazwan dɔɔ ‑o ‑za 'la ꞊ya waa 'bhɛ 'yigɔɔnlɛ mɛɛ 'kedo‑ 'kpɔ ni 'sani‑ 'yee‑ Bhaaplɛŋ Gbe 'ɛ bwele pleŋ‑ gale ba. ");
INSERT INTO moa_vpl VALUES ("MK9_10","071_9_10","MRK","9","10","10","'Bhɛ ‑jan 'ɛ ꞊bwa ‑yaa' ‑klaŋlanɛ mu 'ɛ 'kpee, 'duŋ‑ ‑o ‑yaa 'eke‑ ‑lrɔkpa dɔɔ: «‑Ya pelawoa 'kaa ‹'Kee‑ bwe gale›. 'Bhɛ 'yi ‑o 'nale‑ ɛɛ?» ");
INSERT INTO moa_vpl VALUES ("MK9_11","071_9_11","MRK","9","11","11","'Bhɛ blaan, 'ke Zesu a ‑klaŋlanɛ mu 'ɛ ‑wa 'lrɔkpale dɔɔ: «‑Mɛle ‑kla 'bhɛɛ‑ *'Toŋ daan mu 'ɛ ‑o pe dɔɔ Eli ‑le nu nulɛ 'elwale 'pe ɛɛ?» ");
INSERT INTO moa_vpl VALUES ("MK9_12","071_9_12","MRK","9","12","12","Zesu 'bhɛ ‑jan 'ɛ zikpaa‑ ‑o ni dɔɔ: «Wlan ‑le 'bhɛ 'le, Eli nu nulɛ 'elwale 'pe pɛ 'kpɛn 'kpalɛ‑ 'bhɛ 'kpayrɛ‑ nɔɔ‑, 'bhɛɛ‑ 'duŋ‑ ‑mɛle ꞊kla 'bhɛɛ‑ ‑a yɔɔndɛle ‑o 'ezin‑ dɔɔ *Bhaaplɛŋ Gbe 'ɛ nu ‑yrɛnbhlelɛ 'ebebele, 'bhɛɛ‑ ‑o nu ‑a mafinyanwolɛ ɛɛ? ");
INSERT INTO moa_vpl VALUES ("MK9_13","071_9_13","MRK","9","13","13","'Bhɛɛ‑ 'duŋ‑, 'mi pe 'ka ni dɔɔ Eli ꞊nwa gban, 'bhɛɛ‑ mɛɛ 'ke mu ‑yaa sɔ ‑yrɛn yɛkɛ‑ 'la 'kpale ‑a ta 'mu 'bhɛɛ‑ ꞊kla, 'bhii‑ ‑a yɔɔndɛle ‑o gɔnɛ‑ 'la gbɛɛn‑ ‑a ba zayi' ‑Waanbhaa' a 'Sɛwɛ 'ɛ 'yi bhe.» ");
INSERT INTO moa_vpl VALUES ("MK9_14","071_9_14","MRK","9","14","14","‑O bhɔle ‑klaŋlanɛ ‑vin mu 'ɛ ‑din, 'ke ‑o ‑zamaa' 'srɛ ‑gbɛnɛ do yele‑ 'mu zi, 'bhɛ 'pegee 'Toŋ daan mu 'ke mu ‑yaa zaabɔ 'zi 'woo‑ ‑klaŋlanɛ mu 'ɛ 'le. ");
INSERT INTO moa_vpl VALUES ("MK9_15","071_9_15","MRK","9","15","15","Zesu ꞊klaa ‑zamaa' 'ɛ ba, 'bhɛɛ‑ ‑wa yele, 'ke ‑o nule‑ ‑a ‑lɛpalɛ blasanlele, 'bhɛɛ‑ ‑wa 'pubwa‑. ");
INSERT INTO moa_vpl VALUES ("MK9_16","071_9_16","MRK","9","16","16","'Bhɛ klɛle 'tɛ, 'ke Zesu yaa ‑klaŋlanɛ mu 'ɛ ‑lrɔkpale 'kaa: «'Ka ‑o zaabɔ 'zi ‑mɛla ta ‑o ‑le ɛɛ?» ");
INSERT INTO moa_vpl VALUES ("MK9_17","071_9_17","MRK","9","17","17","‑Zamaa' 'ɛ 'pleŋ mɛɛ do 'a 'lɛkwan‑ ni dɔɔ: «'O Daan mi, 'ŋ ꞊nwa 'ke 'ŋ gbe 'ɛ 'le 'e ni, ‑amasrɔyi lii 'bhobho ‑o ‑a zi. ");
INSERT INTO moa_vpl VALUES ("MK9_18","071_9_18","MRK","9","18","18","'Ke lii ‑yɔɔ' 'ɛ ꞊pwa 'a ta yrɛ 'oo yrɛ 'la ꞊nɔɔ, ‑ya balaa' 'trɛ ma, 'bhɛɛ‑ 'ŋ gbe 'ɛ ‑ya ‑liile' pwɛ ‑a ‑lɛ ma, 'bhɛɛ‑ ‑ya 'sɔnbhɛ‑ mu 'ɛ kan 'eke‑ ta, 'bhɛɛ‑ ‑e dɔ zazraza. 'Ŋ 'sromabwa 'yaa‑ ‑klaŋlanɛ mu 'ɛ ni 'kaa ‑o 'yee‑ lii ‑yɔɔ' 'ɛ ‑gbin ‑a zi, 'bhɛɛ‑ waa 'sɔlɛ‑ 'bhɛ klɛle‑.» ");
INSERT INTO moa_vpl VALUES ("MK9_19","071_9_19","MRK","9","19","19","Zesu pe ‑yaa' ‑klaŋlanɛ mu 'ɛ ni dɔɔ: «'Ee! 'Ka mu, 'ka 'laa 'ka kpa ‑Waanbhaa' 'yi! ‑A ‑vinbwa 'waati 'wɛɛ‑ 'bhɛɛ‑ 'ŋ bo 'ka ‑din ɛɛ? ‑A ‑vinbwa 'waati 'wɛɛ‑ 'bhɛɛ‑ 'ŋ bo 'ka 'kwe 'sile‑ 'ɛ ma ɛɛ? ‑Ka nu ‑nɛ 'ɛ 'le 'ŋ ta ‑gɛ!» 'Bhɛɛ‑ ‑o ꞊nwa 'bhɛ 'le ‑a ni. ");
INSERT INTO moa_vpl VALUES ("MK9_20","071_9_20","MRK","9","20","20","Lii ‑yɔɔ' 'ɛ Zesu 'yele‑, 'bhɛ yrɛ do 'ɛ ꞊nɔɔ bhe, 'kee‑ ‑nɛ 'ɛ bɛɛnle‑ ‑kpakpa, 'ke 'bhɛ baale' 'trɛ ma, 'bhɛɛ‑ 'ke 'bhɛ ‑bhlile' 'sanle 'ke 'bhɛ 'liile‑ ‑dɔn 'ɛ pwɛ ‑sɔ 'bhɛ 'lɛ ma. ");
INSERT INTO moa_vpl VALUES ("MK9_21","071_9_21","MRK","9","21","21","Zesu ‑nɛ dɛ 'ɛ ‑lrɔkpaa 'kaa: «Lii ‑yɔɔ' 'lɛɛ‑ ‑yoo 'e gbe 'ɛ zi 'bhɛ ꞊nɔɔ ꞊mwa gban ɛɛ?» ‑Nɛ dɛ 'ɛ ‑ya ‑lɛkwan Zesu ni dɔɔ: «‑Ya zi ‑e 'san 'a matruŋnɛ 'le. ");
INSERT INTO moa_vpl VALUES ("MK9_22","071_9_22","MRK","9","22","22","'Bhɛɛ‑ 'waati 'ɛ 'ke ba, 'yee‑ lii ‑yɔɔ' 'ɛ ‑ya ꞊bwa 'tɛ 'yi 'bhɛ 'pegee ‑yi ba, 'kooko‑ ‑ya dɛ. 'Duŋ‑, 'o 'yrɛnkla 'e ma, 'kee sɔ ‑za do 'ke klɛle‑, 'e 'zoole‑, bhɔ 'o ba!» ");
INSERT INTO moa_vpl VALUES ("MK9_23","071_9_23","MRK","9","23","23","Zesu 'a zikpaa‑ ‑a ni dɔɔ: «‑Mɛle ꞊kla 'e pe 'kee sɔ ‑za do klɛle‑ ɛɛ? ‑Amasrɔyi 'ke mɛɛ 'la zan 'e ꞊kpaa ‑Waanbhaa' 'yi, ‑za 'kpɛn klɛ 'seŋ ‑o 'bhɛ zan 'ɛ ni.» ");
INSERT INTO moa_vpl VALUES ("MK9_24","071_9_24","MRK","9","24","24","'Bhɛ yrɛ do 'ɛ ꞊nɔɔ bhe, 'ke ‑nɛ dɛ 'ɛ ‑gbekanle, 'bhɛɛ‑ 'ke ‑ya pele‑ dɔɔ: «'Ŋ 'kpale‑ ‑o ‑Waanbhaa' 'yi, 'duŋ‑ nu bhɔ 'ŋ ba 'ke 'ye 'ŋ 'kpaleya 'ɛ 'ke kla a ba!» ");
INSERT INTO moa_vpl VALUES ("MK9_25","071_9_25","MRK","9","25","25","Zesu 'a 'yele‑ 'bhii‑ ‑zamaa' 'ɛ 'yaa‑ zan blasanlele ‑o ba ‑yrɛ ta, 'kee‑ 'pɛɛnle lii ‑yɔɔ' ta 'ke ‑ya pele‑ dɔɔ: «Lii 'bhobho, 'mi pe 'e ni go ‑nɛ 'lɛɛ‑ zi, 'bhɛɛ‑ 'yaa bɔlɛ 'ezin‑ ‑a zi 'sekeseke.» ");
INSERT INTO moa_vpl VALUES ("MK9_26","071_9_26","MRK","9","26","26","'Bhɛ klɛle 'tɛ, 'ke lii ‑yɔɔ' 'ɛ ‑gbekanle 'kree, 'bhɛɛ‑ 'kee‑ ‑nɛ 'ɛ bɛɛnle‑ 'eglɔɔle, 'bhɛɛ‑ 'kee‑ gole‑ ‑a zi. ‑Nɛ 'ɛ 'srinna‑ zazraza 'bhii gbaa, ‑asiikɔɔ mɛɛ ‑bebe ‑yaa pe 'zi dɔɔ ‑e ‑gaa. ");
INSERT INTO moa_vpl VALUES ("MK9_27","071_9_27","MRK","9","27","27","'Duŋ‑ Zesu ‑nɛ 'ɛ 'kunle ‑a gbɛ ma, 'kee‑ bhɔle‑ ‑a ba ‑a ‑wlɛnlele, 'bhɛɛ‑ 'kee‑ dulale ‑a gaan ta. ");
INSERT INTO moa_vpl VALUES ("MK9_28","071_9_28","MRK","9","28","28","Zesu 'bhɔle‑ blaan ‑a ba ‑lɛ ma, 'ke ‑yaa' ‑klaŋlanɛ mu 'ɛ ‑wa ‑lrɔkpale 'edaŋma dɔɔ: «‑Mɛle ꞊kla 'o mɔɔ 'fuu 'laa 'sɔlɛ‑ 'yee‑ lii ‑yɔɔ' 'ɛ ‑gbinle' ta ɛɛ?» ");
INSERT INTO moa_vpl VALUES ("MK9_29","071_9_29","MRK","9","29","29","'Bhɛɛ‑ Zesu 'a 'lɛkwan‑ ‑o ni dɔɔ: «'Ke yaa 'e go 'seriwole do ‑kplɛn ba, 'ka 'fuu 'laa sɔ 'bhɛ lii ‑yɔɔ' ‑glɔɔn 'lɛɛ‑ ‑gbinle' ta.» ");
INSERT INTO moa_vpl VALUES ("MK9_30","071_9_30","MRK","9","30","30","‑O gole 'bhɛ 'yrɛ 'ɛ ꞊nɔɔ, 'ke ‑o 'kanle Galile 'klɛɛn 'ɛ 'yi. Zesu 'laa ‑yaa ‑a zi 'bhii‑ mɛɛ mu 'ɛ ‑wa geyrɛ dɔ. ");
INSERT INTO moa_vpl VALUES ("MK9_31","071_9_31","MRK","9","31","31","‑Amasrɔyi, ‑e ‑yaa ‑a zi 'bhii‑ ‑e ‑yaa' ‑klaŋlanɛ mu 'ɛ daan ‑za ‑glɔɔn 'lɛɛ‑ 'bhɛɛ‑ 'le: «‑O nu Bhaaplɛŋ Gbe 'ɛ 'lɛnalɛ mɛɛ mu 'ɛ ni, 'bhɛɛ‑ 'mu 'a dɛ, 'bhɛɛ‑ ‑a gale blaan ‑yrekpaa' yaga mi ma, ‑e nu bwelɛ gale ba.» ");
INSERT INTO moa_vpl VALUES ("MK9_32","071_9_32","MRK","9","32","32","'Duŋ‑ ‑yaa' ‑klaŋlanɛ mu 'ɛ waa 'bhɛ ‑jan 'ɛ 'yimalɛ, ‑o ‑yaa ‑gblaan 'zi ‑a ‑lrɔkpale ma. ");
INSERT INTO moa_vpl VALUES ("MK9_33","071_9_33","MRK","9","33","33","Zesu 'pegee ‑yaa' * klaŋlanɛ mu 'ɛ ꞊wlaa Kapɛnɔmu. ‑O bhɔle 'fɛ 'ɛ ꞊la bhla 'la ba, 'kee‑ ‑yaa' ‑klaŋlanɛ mu 'ɛ ‑lrɔkpale 'tɛ 'kaa: «'Ka ‑yaa zaabɔ 'zi ‑mɛla ta zi 'ɛ 'lii ɛɛ?» ");
INSERT INTO moa_vpl VALUES ("MK9_34","071_9_34","MRK","9","34","34","'Duŋ‑ waa ‑welɛ'. ‑Amasrɔyi, ‑o ‑yaa zi 'ɛ 'lii bhla 'la ba ‑o zaabwa‑ 'eke‑ ‑lɛ ma dɔɔ ‑o ‑de 'gbu ‑le 'egblaanle ‑o ba ɛɛ. ");
INSERT INTO moa_vpl VALUES ("MK9_35","071_9_35","MRK","9","35","35","'Bhɛ klɛ le 'tɛ 'ke, Zesu 'yaale, 'kee‑ ‑yaa' ‑klaŋlanɛ vu ta plɛ 'ɛ 'siile, 'bhɛɛ‑ 'ke ‑ya pele‑ ‑o ni dɔɔ: «'Ke mɛɛ 'la zan ‑a zi 'bhii‑ ‑e klɛ mɔkpɛn' 'lɛɛ mi 'le, 'bhɛ zan klɛ 'pe ‑o 'kpɛn ‑zanta' mi ‑la ‑le, 'bhɛɛ‑ ‑e klɛ mɔkpɛn' a yewonɛ 'le.» ");
INSERT INTO moa_vpl VALUES ("MK9_36","071_9_36","MRK","9","36","36","'Bhɛɛ‑ ‑e ‑nɛ 'fiɛntrɔnnɛ do ꞊kwan, 'kee‑ 'bhɛ dulale ‑o pleŋ‑, 'bhɛɛ‑ 'ke ‑ya bɔle‑ ‑a gbɛ 'yi, 'ke ‑ya pele‑ ‑o ni 'kaa: ");
INSERT INTO moa_vpl VALUES ("MK9_37","071_9_37","MRK","9","37","37","«'Ke mɛɛ ‑o mɛɛ 'la zan ‑nɛ 'fiɛntrɔnnɛ 'lɛɛ‑ 'yansi do ꞊kwan 'elrele 'mi 'tɔ 'ɛ ‑zayi', 'bhɛ zan 'mi 'gbu ‑la ꞊kwan 'elrele bhe. 'Duŋ‑ 'ke mɛɛ 'la zan 'mi ꞊kwan 'elrele, 'bhɛ zan laa 'mi do ‑kplɛn 'kunlɛ‑ 'elrele, 'duŋ‑ mɛɛ 'la zan 'mi 'winbwa‑ ‑e 'bhɛɛ‑ ꞊kwan 'elrele 'ezin‑ bhe.» ");
INSERT INTO moa_vpl VALUES ("MK9_38","071_9_38","MRK","9","38","38","Zesu a ‑klaŋlanɛ 'la 'tɔ 'yaa Zaan, 'bhɛ pe Zesu ni dɔɔ: «'O Daan mi, 'o mɔɔ mɛɛ do ꞊ya 'ke ‑yoo 'zina mu ‑gbin 'zi mɛɛ 'ke mu zi 'e 'tɔ 'ɛ 'yi. 'O 'bhɛ mazapia ‑a ni, ‑amasrɔyi yaa ‑o ‑kɔɔa' mɛɛ 'ɛ do 'le.» ");
INSERT INTO moa_vpl VALUES ("MK9_39","071_9_39","MRK","9","39","39","'Duŋ‑, Zesu 'a zikpaa‑ ‑a ni dɔɔ: «'Ka 'laa 'bhɛ mazapelɛ ‑a ni, mɛɛ 'kedo‑ 'kpɔ 'laa sɔ 'sɔle‑ maza klɛle‑ 'mi 'tɔ 'ɛ 'yi, 'bhɛɛ‑ 'bhɛ blaan yrɛ do 'ɛ ꞊nɔɔ bhe, ‑e ge ‑jan 'yɔɔ‑ wolɛ 'mi ma. ");
INSERT INTO moa_vpl VALUES ("MK9_40","071_9_40","MRK","9","40","40","‑Amasrɔyi, 'ke mɛɛ 'la zan laa ‑o ‑kɔɔ' 'sɔɔnnii 'le, 'bhɛ zan ‑o ‑kɔɔ' 'yiɛnii ‑la ‑le. ");
INSERT INTO moa_vpl VALUES ("MK9_41","071_9_41","MRK","9","41","41","'Ke mɛɛ 'oo mɛɛ 'la zan ‑yi 'paayan꞊ do ꞊naa 'ka ni, ‑amasrɔyi 'ka ‑o Mɛɛ ‑Bhee ‑Kpɔsɔɔ Krisi a pɛ mɛɛ mu 'le bhe, 'mi pe 'ka ni wlan 'ɛ ni dɔɔ 'bhɛ zan nu 'bhɛ ma ‑trɔn 'srɔɔwolɛ.» ");
INSERT INTO moa_vpl VALUES ("MK9_42","071_9_42","MRK","9","42","42","Zesu pe ‑o ni 'ezin‑ dɔɔ: «‑Nɛ 'fiɛntrɔnnɛ mu 'la ‑woo ꞊kpaa 'mi 'yi, 'ke mɛɛ 'la zan 'a ꞊wlaa ‑o zi 'bhɛɛ‑ ‑o ‑balaa' ‑za 'yɔɔ 'yi, 'ke ‑o ‑yaa vlɛ ‑kpuŋ ‑gbɛnɛ do yre 'bhɛ zan 'ɛ bhlɔ ma, 'bhɛɛ‑ ‑wa blin wɛyi‑ 'ɛ ba, 'bhɛ mabhaa yaa nu bhɔlɛ bhɛ zan 'ɛ ma. ");
INSERT INTO moa_vpl VALUES ("MK9_43","071_9_43","MRK","9","43","43","'Kee gbɛ 'ɛ do ‑le 'a 'wla zii' 'e zi 'bhɛɛ‑ 'e baa‑ 'zi ‑za 'yɔɔ‑ 'yi, ‑a takan', 'bhɛɛ‑ 'ya go 'e ma. 'Kee ge 'e gbɛ do 'le bole ‑yrɛ ma ‑si 'ɛ 'yi, 'bhɛ mabhaabhɔ 'e ma 'ke 'bhɛ kan 'kee ge 'e gbɛ plɛ 'le ‑jranama 'tɛ 'la yaa lii ‑titi 'bhɛ 'yi 'bhɛ ta. ");
INSERT INTO moa_vpl VALUES ("MK9_44","071_9_44","MRK","9","44","44","‑A nɔɔ‑ ‑wlɛnnɛ' mu 'la gbaa mu 'ɛ bhle, waa ga ‑titi, 'bhɛɛ‑ ‑a ꞊nɔɔ 'tɛ 'ɛ yaa lii ‑titi. ");
INSERT INTO moa_vpl VALUES ("MK9_45","071_9_45","MRK","9","45","45","'Kee gaan do ‑le 'a 'wla zii' 'e zi 'bhɛɛ‑ 'e baa‑ 'zi ‑za 'yɔɔ‑ 'yi, ‑a takan' 'bhɛɛ‑ 'ya go 'e ma. 'Kee ge 'e gaan do 'le bole ‑yrɛ ‑si 'ɛ 'yi, 'bhɛ mabhaabhɔ 'e ma 'ke 'bhɛ 'kan 'kee ge 'e gaan plɛ 'le ‑jranama 'tɛ 'ɛ 'yi 'bhɛ ta. ");
INSERT INTO moa_vpl VALUES ("MK9_46","071_9_46","MRK","9","46","46","‑A nɔɔ‑ ‑wlɛnnɛ' mu 'la gbaa mu 'ɛ bhle, waa ga ‑titi, 'bhɛɛ‑ ‑a ꞊nɔɔ 'tɛ 'ɛ yaa lii ‑titi.» ");
INSERT INTO moa_vpl VALUES ("MK9_47","071_9_47","MRK","9","47","47","«'Bhɛɛ‑ 'kee 'yrɛbhɛ‑ do ‑le 'a wla zii' 'e zi 'bhɛɛ 'e baa‑ 'zi ‑za 'yɔɔ‑ 'yi, ‑a yro. 'Kee‑ ge 'e 'yrɛ gbɛ do 'le ‑Waanbhaa' a ‑Bhleŋgbeya ‑wa 'ɛ ta, 'bhɛ mabhaabhɔ 'e ma 'ke 'bhɛ kan 'ke ‑woo 'e blin ‑jranama 'tɛ 'ɛ 'yi 'e 'yrɛbhɛ plɛ 'le 'bhɛ ta. ");
INSERT INTO moa_vpl VALUES ("MK9_48","071_9_48","MRK","9","48","48","‑A nɔɔ‑ ‑wlɛnnɛ' mu 'la ‑o gbaa mu 'ɛ mu 'ɛ bhle, waa ga ‑titi, 'bhɛɛ‑ ‑a ꞊nɔɔ 'tɛ 'ɛ yaa lii ‑titi. ");
INSERT INTO moa_vpl VALUES ("MK9_49","071_9_49","MRK","9","49","49","Wlan 'ɛ ni, 'ka 'kpɛn do do nu 'kanlɛ‑ 'tɛ ‑yrɛn 'ɛ 'bhɛɛ‑ 'yi, 'bhɛɛ‑ 'ka nu golɛ ‑za ‑yi, 'bhɛɛ‑ 'ka bo 'ka ‑yrɛ ma yikpɛnsee ta 'bhii‑ 'ke ‑o wɛ ꞊kpaa wi ma gɔnɛ‑ 'la gbɛɛn‑, 'bhɛɛ‑ yaa bɔn ‑titi.» ");
INSERT INTO moa_vpl VALUES ("MK9_50","071_9_50","MRK","9","50","50","«Wɛ 'ɛ ‑yoo 'ke pɛ ‑lrele' do 'le, 'duŋ‑ 'ke ‑a ‑nraleya 'ɛ ‑gwa ‑a ‑yi, 'ka sɔ ‑a ‑nrale' ‑mɛ pɛ ‑la ‑le 'ezin‑ ɛɛ? 'Ka 'gbu 'yinra‑ 'bhii‑ wɛ gbɛɛn‑, 'bhɛɛ‑ ‑ka bo 'eke‑ 'yi yilabla 'yi.» ");
INSERT INTO moa_vpl VALUES ("MK10_1","071_10_1","MRK","10","1","1","Zesu 'pegee ‑yaa' *‑klaŋlanɛ mu 'ɛ ‑gwa 'bhɛ yrɛ 'ɛ ꞊nɔɔ, 'bhɛɛ‑ ‑o ‑ja Zude 'klɛɛn 'ɛ 'yi. 'Bhɛ blaan, ‑o ‑ja Zrudɛn yue ‑yrɛ gbɛ do 'ɛ ta. 'Ezin‑ 'ke ‑zamaa' 'srɛ do 'e 'lɛkpale ‑a zi, 'bhɛɛ‑ 'ke ‑yoo daanle 'sanle 'bhii‑ ‑ya klɛ 'taŋii gɔnɛ‑ 'la gbɛɛn‑. ");
INSERT INTO moa_vpl VALUES ("MK10_2","071_10_2","MRK","10","2","2","Farizi mu 'ke mu 'mu 'mabɛɛnna ‑a ‑din, 'bhɛɛ‑ 'mu ‑yaa zi 'bhii‑ 'mu ‑jan bhee bɔ ‑a ‑lɛɛ, ‑ayile 'ke 'mu 'a 'lrɔkpale 'tɛ dɔɔ: «‑Kɔɔa' 'toŋ 'ɛ ta, mɛɛ do sɔ 'ploole 'bhɛ na ma ɛɛ?» ");
INSERT INTO moa_vpl VALUES ("MK10_3","071_10_3","MRK","10","3","3","'Bhɛ 'yi 'tɛ, 'ke Zesu 'a zikpale ‑o ni ‑o ‑lrɔkpalele 'ezin‑ dɔɔ: «*Moizi 'toŋ ‑glɔɔn 'ɛ ‑dela yɔɔndia‑ 'ka ni ɛɛ?» ");
INSERT INTO moa_vpl VALUES ("MK10_4","071_10_4","MRK","10","4","4","‑Wa zikpaa‑ Zesu ni dɔɔ: «Moizi pe 'o ni 'kaa 'ke mɛɛ do ‑a zi 'bhii‑ ‑e 'ploo‑ ‑a na ma, ‑e gwlɛnna yaa‑ 'kan 'sɛwɛdɛ, 'bhɛɛ‑ ‑e 'bhɛ kpa ‑a na 'kɔɔ; 'ke 'bhɛ ꞊kla, 'bhɛɛ‑ ‑e sɔ 'ploole ‑a na ma 'tɛ.» ");
INSERT INTO moa_vpl VALUES ("MK10_5","071_10_5","MRK","10","5","5","'Bhɛ klɛle 'tɛ, 'ke Zesu 'a 'pele ‑o ni dɔɔ: «Moizi 'bhɛ 'toŋ ‑glɔɔn 'ɛ 'sɛwɛyɔɔndia 'ka ni, 'ka 'trɔn 'yi ‑glɔɔya' 'ɛ 'bhɛɛ‑ ma. ");
INSERT INTO moa_vpl VALUES ("MK10_6","071_10_6","MRK","10","6","6","'Kebhlaale, 'elwale ‑Waanbhaa' ‑yaa 'drunyan klɛ 'zi bhla 'la ba, ‑e 'gwlaan‑ 'pegee le ‑la ꞊kla. ");
INSERT INTO moa_vpl VALUES ("MK10_7","071_10_7","MRK","10","7","7","'Bhɛla‑ ‑zɛɛle, 'gwlaan‑ nu golɛ ‑a dɛ 'pegee ‑a nɛɛ ba 'fa ‑la, 'bhɛɛ‑ 'yee‑ 'pegee ‑a na nu bolɛ 'eke‑ 'yi. ");
INSERT INTO moa_vpl VALUES ("MK10_8","071_10_8","MRK","10","8","8","‑O mɛɛ plɛ nu 'kpalɛ‑ 'eke‑ ma, 'bhɛɛ‑ ‑o klɛ mɛɛ do, 'bhɛ klɛgbɛya 'ɛ 'yi, waa nu klɛlɛ ‑li mɛɛ plɛ 'fɔ mɛɛ do 'kpɔ. ");
INSERT INTO moa_vpl VALUES ("MK10_9","071_10_9","MRK","10","9","9","‑Waanbhaa' pɛ plɛ 'la ꞊kpaa 'eke‑ ma, 'bhɛɛ‑ ‑yoo ꞊kla do, mɛɛ 'kedo‑ 'kpɔ 'laa ‑o golɛ 'eke‑ ma.» ");
INSERT INTO moa_vpl VALUES ("MK10_10","071_10_10","MRK","10","10","10","'Bhɛ blaan, Zesu 'pegee ‑yaa' ‑klaŋlanɛ mu 'ɛ 'yaa‑ bhla 'la ba 'fɛ 'ɛ ꞊la, 'ke ‑wa ‑lrɔkpale 'ezin‑ ‑e ‑jan 'la ꞊woa 'bhɛ ma. ");
INSERT INTO moa_vpl VALUES ("MK10_11","071_10_11","MRK","10","11","11","Zesu 'a zikpaa‑ ‑o ni dɔɔ: «'Ke mɛɛ 'oo mɛɛ 'la zan ‑ploola ‑a na ma, 'bhɛɛ‑ ‑e le ‑bhɛɛke' ‑yalaa', ‑e ‑yanbhɔɔya ‑la ꞊kla ‑a 'na ‑lwa mi 'ɛ ba 'bhɛ gbɛɛn‑ bhe. ");
INSERT INTO moa_vpl VALUES ("MK10_12","071_10_12","MRK","10","12","12","'Bhɛɛ‑ 'ke le do ‑gwa ‑a ‑nɔɔ 'kɔɔ, 'kee‑ 'yalaa‑ 'gwlaan‑ ‑bhɛɛke' 'kɔɔ, ‑e ‑yanbhɔɔya ‑la ꞊kla bhɛ 'le bhe.» ");
INSERT INTO moa_vpl VALUES ("MK10_13","071_10_13","MRK","10","13","13","Mɛɛ 'ke mu ꞊nwa ‑nɛ 'fiɛntrɔnnɛ 'ke mu 'le Zesu ba, 'kooko‑ ‑ya gbɛ 'kpa 'mu ma, 'bhɛɛ‑ ‑e 'mu 'dumawo. 'Duŋ‑ ‑yaa' ‑klaŋlanɛ mu 'ɛ 'bhɛ mazapia 'bhɛ zan mu 'ɛ ni. ");
INSERT INTO moa_vpl VALUES ("MK10_14","071_10_14","MRK","10","14","14","Zesu ‑o yele 'bhɛ ‑za ‑glɔɔn 'ɛ klɛyrɛ 'ɛ nɔɔ‑, 'ke ‑ya zrupliile, 'bhɛɛ‑ 'ke ‑ya pele‑ ‑yaa' ‑klaŋlanɛ mu 'ɛ ni dɔɔ: «‑Kaa 'to 'ke ‑nɛ 'fiɛntrɔnnɛ mu 'ɛ nu 'ŋ ba, 'ka 'laa 'bhɛ 'yigalɛ ‑o 'kɔɔ. ‑Amasrɔyi mɛɛ 'la zan mu ‑o 'bhii‑ 'woo‑ ‑nɛ 'fiɛntrɔnnɛ mu 'lɛɛ‑ dɔgbɛya 'ɛ gbɛɛn‑, ‑Waanbhaa' a ‑bhleŋgbeya 'ɛ ‑yoo 'bhɛ zan mu ‑la pɛ 'le. ");
INSERT INTO moa_vpl VALUES ("MK10_15","071_10_15","MRK","10","15","15","'Mi 'a pe 'ka ni wlan 'ɛ ni dɔɔ 'ke mɛɛ 'la zan laa ‑Waanbhaa' a ‑bhleŋgbeya 'ɛ ‑za 'kunlɛ‑ 'bhii‑ ‑nɛ 'fiɛntrɔnnɛ do gbɛɛn‑, 'bhɛ zan laa nu 'sɔlɛ‑ gele‑ ‑a ꞊nɔɔ.» ");
INSERT INTO moa_vpl VALUES ("MK10_16","071_10_16","MRK","10","16","16","'Bhɛ blaan, 'ke Zesu ‑nɛ 'fiɛntrɔnnɛ mu 'ɛ 'kunle ‑a gbɛ ‑yi, 'ke ‑ya gbɛ 'kpale ‑o 'kpɛn ta do do 'bhɛɛ‑ 'ke ‑yoo 'dumawole. ");
INSERT INTO moa_vpl VALUES ("MK10_17","071_10_17","MRK","10","17","17","'Bhɛ blaan, Zesu 'pegee ‑yaa' ‑klaŋlanɛ mu 'ɛ 'yaa‑ zan dɔlɛ 'taa 'ɛ ta bhla 'la ba, 'ke mɛɛ do nule‑ blasanlele, 'ke ‑ya 'kpɔ zɛnle‑ Zesu gaan ma 'bhɛ 'lɛɛ, 'bhɛɛ‑ 'kee‑ 'bhɛ ‑lrɔkpale 'kaa: «Daan mi Wlan, 'ŋ ‑mɛ pɛ za 'gbu ‑la klɛ, 'bhɛɛ‑ ‑Waanbhaa' ba bole ‑si 'la ‑daŋ' 'laa ‑o ‑a ma, 'ŋ 'bhɛ 'srɔɔwo‑ ɛɛ?» ");
INSERT INTO moa_vpl VALUES ("MK10_18","071_10_18","MRK","10","18","18","Zesu 'a 'lɛkwan‑ ‑a ni dɔɔ: «‑Mɛle ꞊kla 'bhɛɛ‑ 'ya 'pe zii' 'mi ma dɔɔ‹Daan mi Wlan ɛɛ?› Mɛɛ 'kedo‑ 'kpɔ 'laa ‑o 'ewlanle, 'ke yaa 'e go ‑Waanbhaa' do ‑kplɛn ba.» ");
INSERT INTO moa_vpl VALUES ("MK10_19","071_10_19","MRK","10","19","19","«'E ‑Waanbhaa' a 'toŋ mu 'lɛɛ‑ dɔ ɛɛ? 'Kaa: ‹'Yaa mɛɛ dɛlɛ, 'yaa ‑yanbhɔɔya klɛlɛ, 'yaa ‑faanwolɛ, 'yaa bhla 'kpalɛ‑ 'e ‑vindo' mi ma, 'yaa mɛɛ mu 'kɔɔpɛ‑ 'silɛ‑ ‑dawli' ma, 'e dɛ 'pegee 'e nɛɛ ‑lɛdɔ' a ma.›» ");
INSERT INTO moa_vpl VALUES ("MK10_20","071_10_20","MRK","10","20","20","'Yee‑ mɛɛ 'ɛ ‑ya ‑lɛkwan Zesu ni 'tɛ dɔɔ: «'O Daan mi, 'ŋ 'bhɛ 'toŋ mu 'la bhe 'mu 'kpɛn ‑klɔsikunle ‑saan 'ŋ matrunya bhla zi ma.» ");
INSERT INTO moa_vpl VALUES ("MK10_21","071_10_21","MRK","10","21","21","Zesu 'e 'yrɛkpale ‑a ta, 'ke ‑a ba ‑za 'sɔle 'bhɛ ni 'egbɛnɛle. 'Bhɛɛ‑ 'bhɛ 'pe ‑a ni 'tɛ dɔɔ: «'Yaa ‑za do 'kpɔ ‑la klɛlɛ ‑li, 'bhɛ ‑le 'e 'kɔɔpɛ‑ mu 'ɛ gɔnlele; ge ‑o 'kpɛn gɔn, 'bhɛɛ‑ 'yoo‑ ma ‑gɔli' 'ɛ 'na 'kɔɔfleŋzan mu ni. 'Kee 'bhɛ ꞊kla, ‑naflo ‑bebe nu klɛlɛ 'e 'kɔɔ laflɛ' 'yi. 'Bhɛ blaan, 'bhɛɛ‑ 'e nu dɔlɛ 'mi zi 'tɛ!» ");
INSERT INTO moa_vpl VALUES ("MK10_22","071_10_22","MRK","10","22","22","'Yee‑ mɛɛ 'ɛ ‑e 'bhɛ ‑jan 'ɛ 'male‑, 'ke ‑a zrubatɛdɔle ‑a ma, 'bhɛɛ‑ 'kee‑ gele‑ ‑a wlɛyisriwolele, ‑amasrɔyi ‑naflo ‑bebe 'yaa‑ ‑a 'kɔɔ. ");
INSERT INTO moa_vpl VALUES ("MK10_23","071_10_23","MRK","10","23","23","Zesu 'e 'yrɛ 'mliŋgole ‑a zi mu 'ɛ ta, 'ke ‑ya pele‑ ‑yaa' ‑klaŋlanɛ mu 'ɛ ni dɔɔ: «‑Naflo mu ‑o mɛɛ 'la zan mu 'kɔɔ, ‑o gele la ‑Waanbhaa' a ‑bhleŋgbeya yrɛ 'ɛ ꞊nɔɔ 'dɛ!» ");
INSERT INTO moa_vpl VALUES ("MK10_24","071_10_24","MRK","10","24","24","'Bhɛ ‑jan 'ɛ 'bhɛ ‑yaa' ‑klaŋlanɛ mu 'ɛ 'kpeelɛnia ‑o ma. ‑Ayile 'ke ‑ya pele‑ ‑o ni 'ezin‑ 'kaa: «'Ŋ 'bhɛgwlɛn‑ mu, ‑Waanbhaa' a ‑bhleŋgbeya yrɛ 'ɛ ꞊nɔɔ gele la 'dɛ! ");
INSERT INTO moa_vpl VALUES ("MK10_25","071_10_25","MRK","10","25","25","'Yɔɔnma do 'kanle‑ ‑o 'edile ‑mlɛsiɛnnɛ do ‑gluu zi 'kee‑ kan pɛzan do gele ta ‑Waanbhaa' a ‑bhleŋgbeya yrɛ 'ɛ ꞊nɔɔ 'dɛ.» ");
INSERT INTO moa_vpl VALUES ("MK10_26","071_10_26","MRK","10","26","26","‑Yaa' ‑klaŋlanɛ mu 'ɛ 'kpeelɛni gbɛ ‑yɔɔ 'ɛ 'kɔɔ ‑o ma 'ezin‑, 'ke ‑woo 'eke‑ ‑lrɔkpale dɔɔ: «‑Dele sɔ gole‑ ‑za 'yi ɛɛ?» ");
INSERT INTO moa_vpl VALUES ("MK10_27","071_10_27","MRK","10","27","27","Zesu 'e 'yrɛkpaa‑ ‑o ta frii 'ke ‑ya pele‑ dɔɔ: «Bhaaplɛŋ mu ‑yrɛ 'yi, 'bhɛ 'laa sɔ klɛle‑, 'duŋ‑ ‑Waanbhaa' ‑yrɛ 'yi, 'bhɛ 'laa ‑o ‑za 'ke 'le. ‑Amasrɔyi, ‑za 'kpɛn klɛ 'seŋ ‑o ‑Waanbhaa' ni.» ");
INSERT INTO moa_vpl VALUES ("MK10_28","071_10_28","MRK","10","28","28","'Bhɛ klɛle 'tɛ, 'ke Piɛri 'a pele ‑a ni 'kaa: «'E 'trɔnbadɔ doo, 'o mɔɔ 'o 'niigwa‑ ‑za 'kpɛn 'yi, 'bhɛɛ‑ 'o ꞊nwa dɔlɛ 'e zi.» ");
INSERT INTO moa_vpl VALUES ("MK10_29","071_10_29","MRK","10","29","29","Zesu 'a zikpaa‑ ‑a ni dɔɔ: «'Mi pe 'ka ni wlan 'ɛ ni 'kaa: 'ke mɛɛ 'oo mɛɛ 'la zan ‑yaa' 'fɛ oo, ‑a nɛɛnɛ‑ 'gwlaan‑ mu oo, ‑a nɛɛnɛ‑ le mu oo, ‑a dɛ oo, ‑a nɛɛ oo, ‑a ‑nɛ mu 'pegee ‑yaa' gba mu 'ɛ 'kpɛn ꞊twa ‑a nɔɔ‑, 'mi 'pegee ‑Jan 'Nrale‑ 'ɛ ‑zayi', ");
INSERT INTO moa_vpl VALUES ("MK10_30","071_10_30","MRK","10","30","30","'bhɛ zan nu 'bhɛ pɛ mu 'ɛ 'kpɛn do do dulayrɛ ‑kɛmɛ do do ‑srɔɔwolɛ 'drunyan 'lɛɛ‑ 'yi. 'Kee‑ ꞊kla 'fɛ mu 'le oo, ‑a nɛɛnɛ‑ 'gwlaan‑ mu 'le oo, ‑a nɛɛnɛ‑ le mu 'le oo, ‑a nɛɛ mu 'le oo, ‑a ‑nɛ mu 'le oo, 'bhɛ 'pegee gba mu; 'duŋ‑ ‑o nu ‑yrɛnkpalɛ 'bhɛ zan 'ɛ ta 'pe. 'Bhɛɛ‑ ‑e nu ‑Waanbhaa' ba bole ‑yrɛ ma ‑si 'la ‑daŋ' 'laa ‑o 'bhɛ ma 'bhɛ 'srɔɔwolɛ 'drunyan 'la 'bhɛ ‑o zan bhe 'bhɛ 'yi 'tɛ. ");
INSERT INTO moa_vpl VALUES ("MK10_31","071_10_31","MRK","10","31","31","'Duŋ‑ mɛɛ 'la zan mu ‑o ‑zɔn zilɛɛ‑ mu 'le, 'mu ‑bebe nu klɛlɛ zizan‑ mu 'le boolazi, 'bhɛɛ‑ mɛɛ 'la zan mu ‑o ‑zɔn zizan‑ mu 'le, 'mu ‑bebe nu klɛlɛ zilɛɛ‑ mu 'le.» ");
INSERT INTO moa_vpl VALUES ("MK10_32","071_10_32","MRK","10","32","32","Zesu 'pegee ‑yaa' ‑klaŋlanɛ mu 'ɛ 'yaa‑ zi 'ɛ 'lii Zeruzalɛmu 'taa 'ɛ ta bhla 'la ba, 'yee‑ Zesu 'gbu dɔle ‑yaa ‑o ‑lɛɛ. Yaa ‑klaŋlanɛ mu 'ɛ blina‑ yiɛn ‑yaa, 'bhɛɛ‑ mɛɛ 'la zan mu dɔle ‑yaa ‑o zi ‑gblaan ‑yaa 'mu 'yi. 'Bhɛ 'yi 'tɛ, 'kee‑ ‑yaa' ‑klaŋlanɛ mu 'ɛ 'sii gbɛ drɛɛwole 'edaŋma, 'bhɛɛ‑ ‑za 'la 'yaa‑ nu 'tɛnlɛ‑ ‑a ma, ‑yoo 'kpeelɛkanle ‑saan 'bhɛ 'le. ");
INSERT INTO moa_vpl VALUES ("MK10_33","071_10_33","MRK","10","33","33","'E pe ‑o ni dɔɔ: «‑Ka 'ka 'trɔnbadɔ doo, ‑kɔɔ' ‑o gelawo zii' Zeruzalɛmu bhe ‑o nu *Bhaaplɛŋ Gbe 'ɛ 'lɛnalɛ 'sraka 'lɛna ‑kuŋlii' mu 'ɛ 'pegee 'Toŋ daan mu 'ɛ ni. 'Mu nu 'kiti baalɛ ‑a ta 'kaa ‑wa dɛ, 'bhɛɛ‑ 'mu nu ‑a ‑lɛnalɛ Zuufu kle mu ni. ");
INSERT INTO moa_vpl VALUES ("MK10_34","071_10_34","MRK","10","34","34","'Bhɛ mu nu ‑a malrɔgolɛ, 'mu nu 'mu ‑liile' 'klalɛ ‑a ta, 'mu nu a tafɛlɛ 'ke gbaŋbhlɛ 'le, 'bhɛɛ‑ 'mu nu ‑a dɛlɛ. 'Duŋ‑, ‑a gale blaan ‑yrekpaa' yaga mi ma, ‑e nu bwelɛ gale ba.» ");
INSERT INTO moa_vpl VALUES ("MK10_35","071_10_35","MRK","10","35","35","Zebede gbe Zaki 'pegee Zaan, ‑woo mabɛɛnna Zesu ‑din 'ke ‑wa pele‑ ‑a ni dɔɔ: «'O Daan mi, 'woo ‑a zi 'bhii‑ 'e pɛ do na 'o ni, dɔ 'bhɛ ꞊la 'o ni.» ");
INSERT INTO moa_vpl VALUES ("MK10_36","071_10_36","MRK","10","36","36","Zesu ‑o ‑lrɔkpaa 'kaa: «'Kaa‑ zi 'bhii‑ 'ŋ ‑mɛ pɛ ‑la na 'ka ni ɛɛ?» ");
INSERT INTO moa_vpl VALUES ("MK10_37","071_10_37","MRK","10","37","37","'Bhɛɛ‑ ‑wa zikpaa‑ Zesu ni dɔɔ: «'Kee ꞊ja bhla 'la ba 'yaa‑ ‑bhleŋgbeya 'tɔbhɔ ma yaayrɛ 'ɛ ꞊nɔɔ, 'e 'zoole‑, dɔ a ‑la 'ke ‑o mɛɛ plɛ 'ɛ do yalaa' 'e gbɛ ‑yiɛ' ta, 'bhɛɛ‑ ‑a do yalaa' 'e gbɛ ‑koo 'ɛ ta.» ");
INSERT INTO moa_vpl VALUES ("MK10_38","071_10_38","MRK","10","38","38","Zesu 'a 'lɛkwan‑ ‑o ni dɔɔ: «'Ka pɛ 'la 'yrɛwo zii' 'ka 'laa 'bhɛ 'gbu dɔ. ‑O nu ‑yrɛn gbɔ ‑glɔɔn 'la dɔlɛ 'ŋ 'wiiŋ‑, 'ka nu dɔlɛ a ‑la 'ke 'ka 'bhɛ 'ke si ɛɛ? Taa‑ 'ka nu 'sɔlɛ‑ dɔle‑ ‑a ‑la 'ke 'ka ga 'bhii‑ 'mi gagbɛya 'ɛ gbɛɛn‑ ɛɛ?» ");
INSERT INTO moa_vpl VALUES ("MK10_39","071_10_39","MRK","10","39","39","'Bhɛ ꞊nɔɔ bhe, 'ke ‑wa pele‑ 'kaa: «‑Aani', 'o mɔɔ faŋgan‑ nu 'sɔlɛ‑ 'bhɛ ta.» 'Bhɛ klɛle 'tɛ 'ke ‑ya pele‑ ‑o ni 'ezin‑ dɔɔ: «Wlan ‑le 'bhɛ 'le, 'ka nu 'ŋ ta ‑yrɛn gbɔ 'ɛ 'ke 'bhlelɛ‑, 'bhɛɛ‑ 'ŋ ta ‑yrɛn 'kpagbɛya 'ɛ, 'bhɛ 'ke nu klɛlɛ 'ka ta. ");
INSERT INTO moa_vpl VALUES ("MK10_40","071_10_40","MRK","10","40","40","'Duŋ‑ 'ŋ gbɛ ‑koo 'pegee 'ŋ gbɛ ‑yiɛ' 'yi yaayrɛ mu 'ɛ, 'mi 'laa ‑o 'ke 'mu 'na mi 'le. ‑Waanbhaa' 'bhɛ yaayrɛ mu 'ɛ 'lɛmagaanna mɛɛ 'la zan mu ni, ‑e nu ‑o nalɛ 'bhɛɛ‑ zan mu 'ɛ ni.» ");
INSERT INTO moa_vpl VALUES ("MK10_41","071_10_41","MRK","10","41","41","Zesu a ‑Klaŋlanɛ mu ‑vin vu 'ɛ 'trɔnbɔle 'bhɛ ‑jan 'ɛ 'yi, 'ke ‑woo zrupliile Zaki 'pegee Zaan ma. ");
INSERT INTO moa_vpl VALUES ("MK10_42","071_10_42","MRK","10","42","42","'Bhɛ klɛle 'tɛ, 'ke Zesu ‑o 'kpɛn 'siilɛ‑, 'ke ‑ya pele‑ ‑o ni 'kaa: «‑Ka 'ka 'trɔnbadɔ doo! 'Ka 'gbu 'a 'yaango‑ 'bhii‑ ‑o mɛɛ 'la zan mu kun 'bhii‑ mɛɛ mu ta ‑kuŋlii' mu 'drunyan 'lɛɛ‑ 'yi, 'bhɛ zan mu 'mu a ‑kuŋliiya 'ɛ klɛ 'drunyan 'lɛɛ‑ 'yi mu 'ɛ ta. 'Bhɛɛ‑ mɛɛ gblaan mu 'ɛ, 'bhɛ mu 'mu a gblaanya 'ɛ gbinkpa mɛɛ ‑bhɛɛke' mu ‑la ta. ");
INSERT INTO moa_vpl VALUES ("MK10_43","071_10_43","MRK","10","43","43","'Duŋ‑ 'ka mu, 'ka laa klɛlɛ 'ka pleŋ‑ 'bhɛ gbɛɛn‑ ‑gee'. Drɔɔn', 'ke mɛɛ 'la zan ‑a zi 'bhii‑ ‑e klɛ mɛɛ gblaan 'le 'ka ba, 'bhɛ zan 'ɛ klɛ 'ka 'kpɛn ‑a yewonɛ 'le. ");
INSERT INTO moa_vpl VALUES ("MK10_44","071_10_44","MRK","10","44","44","'Bhɛɛ‑ 'ke mɛɛ 'la zan ‑a zi 'bhii‑ 'bhɛ klɛ 'ka 'lɛɛ mi 'le 'ka ba ‑gɛ, 'bhɛ zan 'ɛ klɛ 'ka 'kpɛn ‑a lu 'le. ");
INSERT INTO moa_vpl VALUES ("MK10_45","071_10_45","MRK","10","45","45","'Bhɛ klɛgbɛya do 'yi bhe, Bhaaplɛŋ Gbe 'ɛ yaa nulɛ mɛɛ mu klɛlɛ ‑yaa' yewonɛ mu 'le, 'duŋ‑ ‑e ꞊nwa ‑a 'gbu klɛlɛ mɔkpɛn' a yewonɛ 'le, 'bhɛ 'pegee 'ke ‑ya 'gbu 'si 'ɛ klɛ 'ke mɛɛ ‑bebe tagbawopɛ 'le ‑Waanbhaa' ni.» ");
INSERT INTO moa_vpl VALUES ("MK10_46","071_10_46","MRK","10","46","46","Zesu 'pegee ‑yaa ‑klaŋlanɛ mu 'ɛ ꞊bhwa ‑wa do ta, ‑o ‑yaa 'bhɛ ‑wa 'ɛ sii Zeriko. 'Yee‑ Zesu 'pegee ‑yaa' ‑klaŋlanɛ mu 'ɛ, 'bhɛɛ‑ ‑zamaa' 'srɛ do ‑yaa zan golɛ Zeriko ‑wa 'ɛ 'kpee bhla 'la ba, ‑yrɛ 'wi mi do yaale ‑yaa zibhɛ 'ɛ 'trɔn ta, 'ke 'bhɛ 'e ‑yrɛwo' mɛɛ mu ma. ‑O ‑yaa 'bhɛ sii Batime, 'bhɛɛ‑ 'bhɛ dɛ 'tɔ ‑le ‑yaa Time. ");
INSERT INTO moa_vpl VALUES ("MK10_47","071_10_47","MRK","10","47","47","‑Ya male 'tɛ 'kaa Nazarɛti mi Zesu ‑le ‑yaa 'kan zii', 'kee‑ ‑gbekanle 'sanle 'ke ‑ya pe dɔɔ: «Davidi 'nranɛ‑ Zesu, 'ŋ 'yrɛnkla 'e ma!» ");
INSERT INTO moa_vpl VALUES ("MK10_48","071_10_48","MRK","10","48","48","'Bhɛ bhla 'ɛ ba, mɛɛ ‑bebe ‑yaa ‑a tagayrɛ ‑glin 'zi. Drɔɔn' ‑e ‑yaa gbe 'ɛ baan' ‑la 'kan zii' 'eglɔɔle 'kaa: «Davidi 'nranɛ‑, 'ŋ 'yrɛnkla 'e ma!» ");
INSERT INTO moa_vpl VALUES ("MK10_49","071_10_49","MRK","10","49","49","'Bhɛ 'yi 'tɛ, 'ke Zesu dulale, 'bhɛɛ‑ 'ke ‑ya pele‑ dɔɔ ‑wa 'sii 'bhɛɛ‑ ‑o nu 'kɛle‑ ‑a ni. ‑O 'yee‑ ‑yrɛ 'wi mi 'ɛ 'siile‑, 'ke ‑wa pele‑ ‑a ni dɔɔ: «'E zrudɔ 'eglɔɔle, 'e 'wlɛn‑, ‑yoo 'e 'sii zii'.» ");
INSERT INTO moa_vpl VALUES ("MK10_50","071_10_50","MRK","10","50","50","'Bhɛ klɛ le 'tɛ, ‑yrɛ 'wi mi 'ɛ ‑ya ta dunɛ‑ tralapɛ 'ɛ blinle‑ 'trɛ ma, 'kee‑ pinale 'sanle ‑a gaan ta, 'bhɛɛ‑ 'kee‑ gele‑ Zesu ba. ");
INSERT INTO moa_vpl VALUES ("MK10_51","071_10_51","MRK","10","51","51","‑E bhɔle Zesu ‑din, 'ke 'bhɛ 'a ‑lrɔkpale 'kaa: «'Yoo‑ ‑a zi 'bhii‑ 'ŋ ‑mɛ pɛ za ‑la klɛ 'e ni ɛɛ?» ‑Yrɛ 'wi mi 'ɛ pe ‑a ni: «'O Daan mi, ‑a klɛ 'bhɛɛ‑ 'ŋ yrɛ ma ye gbɛ drɛɛwo.» ");
INSERT INTO moa_vpl VALUES ("MK10_52","071_10_52","MRK","10","52","52","'Bhɛɛ‑ Zesu pe ‑a ni dɔɔ: «Ge! 'Yee 'kpalawoa 'mi 'yi bhe, 'e 'bheela‑!» 'Bhɛ yrɛ do 'ɛ ꞊nɔɔ bhe, 'kee‑ yrɛ ma yele‑, 'bhɛɛ‑ 'kee‑ dɔle‑ Zesu zi zi 'ɛ 'lii. ");
INSERT INTO moa_vpl VALUES ("MK11_1","071_11_1","MRK","11","1","1","Zesu 'pegee ‑yaa' ‑klaŋlanɛ mu 'ɛ ꞊bhwa Bɛtifaze 'pegee Betani ‑wa mu 'ɛ ‑din. 'Bhɛ ‑wa mu 'ɛ 'pleŋgole laa ‑yaa Zeruzalɛmu ma 'egbɔɔnle. ‑O ‑yaa 'waati 'la ba vlɛ gɔɔn 'la ‑wa sii ‹Olivi diiŋ vlɛ gɔɔn› 'bhɛ 'teŋla‑, 'ke Zesu ‑yaa' ‑klaŋlanɛ mu 'ɛ plɛ winbɔle‑ ‑o ‑lɛɛ. ");
INSERT INTO moa_vpl VALUES ("MK11_2","071_11_2","MRK","11","2","2","‑Ya ꞊pia ‑o ni dɔɔ: «‑Ka ge 'ka 'lɛɛ ‑wa 'la bhe ‑a ta, 'ka 'bhɔle‑ ‑gun ‑a nɔɔ‑, 'ka nu ‑soofalinɛ do 'yrele‑ yelɛ 'fɛ do ‑lɛ ma. Mɛɛ 'kedo‑ laa 'sanlɛ ‑lido' ‑a ta, ‑kaa 'ploo‑ 'bhɛɛ‑ 'ka nu 'kɛle‑ ‑gɛ. ");
INSERT INTO moa_vpl VALUES ("MK11_3","071_11_3","MRK","11","3","3","'Bhɛɛ‑ 'ke mɛɛ 'ke 'ka 'lrɔkpaa dɔɔ: ‹‑Mɛle ꞊kla 'bhɛɛ‑ 'ka ‑o ‑a 'ploo zii' ɛɛ?› 'Kaa‑ pe 'bhɛ zan 'ɛ ni dɔɔ: ‹Mɛɛzan ‑la maza ‑dwa ‑a ma. 'Ke 'bhɛ ꞊kla 'tɛ, ‑e nu dɔlɛ ‑a ‑la 'ke 'ka nu 'kɛle‑ ‑gɛ.›» ");
INSERT INTO moa_vpl VALUES ("MK11_4","071_11_4","MRK","11","4","4","‑Yaa' ‑klaŋlanɛ mu 'ɛ gele 'bhɛ 'yi 'tɛ, 'ke ‑o ‑soofalinɛ do ‑yrele' yele‑ 'pɛɛlii ‑gbleba 'ɛ 'lɛzi‑ 'fɛ do ‑lɛ ma, 'bhɛɛ‑ 'ke ‑wa 'ploole. ");
INSERT INTO moa_vpl VALUES ("MK11_5","071_11_5","MRK","11","5","5","Mɛɛ 'la zan mu ‑yaa 'bhɛ yrɛ 'ɛ ꞊nɔɔ, 'mu 'ke mu ‑o ‑lrɔkpaa 'kaa: «'E! 'Ka ‑o ‑mɛla klɛ 'zi bhe ɛɛ? ‑Mɛle ꞊kla 'bhɛɛ‑ 'ka ‑o ‑soofalinɛ 'la bhe ‑a 'ploo zii' ɛɛ?» ");
INSERT INTO moa_vpl VALUES ("MK11_6","071_11_6","MRK","11","6","6","‑Yaa' ‑klaŋlanɛ mu 'ɛ ‑wa ‑lɛkwan 'bhɛ zan mu 'ɛ ni 'bhii‑ Zesu 'a ꞊pia ‑o ni gɔnɛ‑ 'la gbɛɛn‑ bhe. 'Bhɛ klɛ 'le 'tɛ, 'ke 'bhɛ mɛɛ mu 'ɛ ‑soofalinɛ 'ɛ 'tole ‑o 'kɔɔ, 'ke ‑o nule‑ 'kɛle‑. ");
INSERT INTO moa_vpl VALUES ("MK11_7","071_11_7","MRK","11","7","7","‑O ‑nwa 'ke ‑soofalinɛ 'ɛ 'le Zesu ni, 'ke ‑o ‑waa' dunɛ‑ tralapɛ mu 'ɛ gole‑, 'bhɛɛ‑ 'ke ‑o 'mu 'kpaale ‑soofalinɛ 'ɛ kpoo ta, 'bhɛɛ‑ 'ke Zesu 'sanle 'bhɛ ‑soofalinɛ 'ɛ ta. ");
INSERT INTO moa_vpl VALUES ("MK11_8","071_11_8","MRK","11","8","8","Mɛɛ ‑bebe 'mu ta dunɛ‑ tralapɛ mu 'ɛ 'kpalaa‑ zibhɛ 'ɛ 'lii Zesu 'lɛɛ, 'bhɛɛ‑ ‑a 'ke mu ‑ja ‑bɔn 'yi ‑yri ‑dɔɔ 'laa mu 'kanlɛ‑ 'ke ‑o 'mu 'kpaale zibhɛ 'ɛ 'lii. ");
INSERT INTO moa_vpl VALUES ("MK11_9","071_11_9","MRK","11","9","9","Mɛɛ 'la zan mu dɔle ‑yaa Zesu 'lɛɛ, 'bhɛ 'pegee mɛɛ 'la zan mu dɔle ‑yaa zi, 'mu 'yaa‑ ‑gbekan' zii' 'bhɛɛ‑ 'ke ‑wa pe dɔɔ: «Ozana! Mɛɛ 'la zan ‑o zan Mɛɛzan 'tɔ 'ɛ 'yi, bhaa ‑Waanbhaa' 'bhɛ zan 'ɛ ‑dɔɔbo'! ");
INSERT INTO moa_vpl VALUES ("MK11_10","071_11_10","MRK","11","10","10","Bhaa ‑Waanbhaa' ‑kɔɔ' ‑gbɔɔ Davidi a ‑bhleŋgbeya 'la ‑yoo zan 'ezin‑ bhe, 'bhɛ ‑dɔɔbo'! Ozana laflɛ' 'ɛ 'yi yrɛkpɛn‑ ꞊nɔɔ!» ");
INSERT INTO moa_vpl VALUES ("MK11_11","071_11_11","MRK","11","11","11","Zesu bhɔle Zeruzalɛmu, 'kee‑ gele‑ wlalɛ *‑Waanbhaa' Gba 'Fɛ ‑Gbɛnɛ 'ɛ ꞊la. ‑E ‑yaan ‑a ‑yrɛ 'mliŋgolele pɛ mu 'ɛ 'kpɛn ta bhla 'la ba, 'ke 'yee‑ 'pegee ‑yaa' ‑klaŋlanɛ vu ta plɛ 'ɛ ‑o gele‑ Betani, ‑amasrɔyi ‑fitrii' 'kpale‑ ‑saan gban bi. ");
INSERT INTO moa_vpl VALUES ("MK11_12","071_11_12","MRK","11","12","12","'Bhɛ ta tooklin‑ yi 'ɛ 'le, ‑o go bhla 'ɛ zi Betani, 'ke gbɔn Zesu dɛle‑. ");
INSERT INTO moa_vpl VALUES ("MK11_13","071_11_13","MRK","11","13","13","‑E figi diiŋ do ꞊ya 'egbɔɔnle, 'bhɛ 'laa mu ‑yaa 'bhɛ ta. 'Bhɛ 'yi, 'kee‑ gele ‑a ‑yrɛkpalɛ 'bhɛ figi diiŋ 'ɛ 'yi 'bhɛ bhaa ‑glin ‑zayi'. 'Duŋ‑, ‑e bhɔle 'tɛ 'bhɛ ꞊la, yaa 'bhɛ bhaa 'kedo‑ 'kpɔ 'yelɛ‑ 'bhɛ 'yi. ‑Amasrɔyi figi diiŋ bhaa klɛ 'waati 'laa ‑yaa 'bhɛ 'le. ");
INSERT INTO moa_vpl VALUES ("MK11_14","071_11_14","MRK","11","14","14","'Bhɛ klɛle 'tɛ, 'ke ‑ya 'pele figi diiŋ 'ɛ ni: «Bhaa 'yaa‑ 'e bhaa klɛlɛ 'ezin‑ ‑titi!» ‑Yaa' ‑klaŋlanɛ mu 'ɛ 'trɔnbwa‑ 'bhɛ ‑jan 'ɛ 'yi. ");
INSERT INTO moa_vpl VALUES ("MK11_15","071_11_15","MRK","11","15","15","Zesu 'pegee ‑yaa' ‑klaŋlanɛ mu 'ɛ 'bhɔle‑ Zeruzalɛmu, 'kee‑ gele‑ wlalɛ ‑Waanbhaa' Gba 'Fɛ ‑Gbɛnɛ 'ɛ ꞊la. 'Bhɛɛ‑ 'kee‑ 'bhɛ ꞊nɔɔ pɛgɔn mu 'ɛ 'pegee pɛlɔ‑ mu 'ɛ ‑gbinle' 'sanle, 'kee‑ ‑gɔli' tabɔɔ mu 'ɛ waa ‑tabali mu 'ɛ 'lɛbhulale, 'bhɛɛ‑ 'kee‑ maannɛ‑ kpro gɔn mu 'ɛ 'mu 'yaakpe‑ mu 'ɛ 'lɛbhulale. ");
INSERT INTO moa_vpl VALUES ("MK11_16","071_11_16","MRK","11","16","16","Yaa 'tolɛ‑ 'ke mɛɛ 'kedo‑ 'kpɔ kan ‑Waanbhaa' Gba 'Fɛ ‑Gbɛnɛ 'ɛ ꞊la 'ke pɛ 'kedo‑ 'kpɔ 'le 'bhɛ 'kɔɔ. ");
INSERT INTO moa_vpl VALUES ("MK11_17","071_11_17","MRK","11","17","17","'Bhɛɛ‑ ‑yoo ‑daanna ‑jan 'lɛɛ‑ 'le dɔɔ: «‑A yɔɔndɛle laa ‑o ‑Waanbhaa' a 'Sɛwɛ 'ɛ 'yi 'kaa: ‑Waanbhaa' pe dɔɔ: ‹‑O nu 'an pɛ 'fɛ 'ɛ 'siilɛ‑ 'si mu 'ɛ 'kpɛn a 'seriwo 'fɛ.›» 'Bhɛɛ‑ Zesu 'a ꞊kpaa ‑a ta 'ezin‑ dɔɔ: «'Duŋ‑ 'ka mu 'a ꞊kla 'ke ‑faannii' mu magaan yrɛ 'le.» ");
INSERT INTO moa_vpl VALUES ("MK11_18","071_11_18","MRK","11","18","18","'Sraka 'lɛna ‑kuŋlii' mu 'ɛ 'pegee 'Toŋ daan mu 'ɛ ‑o 'bhɛ ‑jan 'ɛ 'male‑, 'ke ‑o Zesu dɛyrɛ ‑glinle' 'sanle. 'Bhɛɛ‑ 'duŋ‑, ‑o ‑yaa ‑gblaan 'ezin‑ ‑a ‑lɛɛ, ‑amasrɔyi ‑yaa' mɛɛ daangbɛya 'ɛ 'yaa‑ ‑zamaa' 'ɛ zru 'ɛ 'kun zii'. ");
INSERT INTO moa_vpl VALUES ("MK11_19","071_11_19","MRK","11","19","19","Yromazi bhɔle 'tɛ, 'ke Zesu 'pegee ‑yaa' ‑klaŋlanɛ mu 'ɛ gole‑ ‑wa 'ɛ 'kpee. ");
INSERT INTO moa_vpl VALUES ("MK11_20","071_11_20","MRK","11","20","20","Bhɛ ta tooklin‑ yi 'ɛ 'le zrwan 'tutu 'ɛ zi, Zesu 'pegee ‑yaa' ‑klaŋlanɛ mu 'ɛ 'kan bhla 'ɛ zi, 'ke ‑o ‑yrɛkpale figi diiŋ 'ɛ gale ma. 'Kee‑ san laanima, 'kee‑ ‑zinaa' 'traa. ");
INSERT INTO moa_vpl VALUES ("MK11_21","071_11_21","MRK","11","21","21","Zesu ‑jan 'la ꞊woa ‑yri diiŋ 'ɛ ni, 'bhɛ dɔle Piɛri 'kpee, 'ke ‑ya pele Zesu ni 'kaa: «'O Daan mi, 'e 'yrɛkpa, 'e figi diiŋ 'la 'daŋganwoa ‑e ‑gaa 'feŋfeŋ.» ");
INSERT INTO moa_vpl VALUES ("MK11_22","071_11_22","MRK","11","22","22","'Bhɛ klɛle 'tɛ, 'ke Zesu 'a 'pele ‑yaa' ‑klaŋlanɛ mu 'ɛ ni dɔɔ: «‑Ka 'ka 'kpa drɔŋ ‑Waanbhaa' ‑yi! ");
INSERT INTO moa_vpl VALUES ("MK11_23","071_11_23","MRK","11","23","23","'Mi 'gbu pe 'ka ni 'ŋ 'sɔwɛɛ‑ 'ɛ ma dɔɔ 'ke mɛɛ 'la zan laa zru klɛlɛ plɛ, 'bhɛɛ‑ 'duŋ‑, 'ke ‑ya ꞊kpaa ‑a ‑yi 'bhii‑ ‑e ‑jan 'la ꞊woa 'bhɛ 'yiza‑ sɔ klɛle‑, 'ali‑ 'ke 'bhɛ zan 'a ꞊pia vlɛ gɔɔn 'lɛɛ‑ ni 'kaa: ‹Go 'e dulayrɛ 'ɛ ꞊nɔɔ, 'bhɛɛ‑ ge bɔ wɛyi‑ 'ɛ ba›. 'Bhɛ ‑za 'ɛ 'bhɛ ‑le nu klɛlɛ 'bhɛ zan 'ɛ 'weli‑ ta. ");
INSERT INTO moa_vpl VALUES ("MK11_24","071_11_24","MRK","11","24","24","'Bhɛla‑ ‑zɛɛle, 'mi pe 'ka ni dɔɔ 'ke 'ka pɛ 'oo pɛ 'la 'yrɛwoa‑ ‑Waanbhaa' ma 'seri 'yi, ‑ka 'ka 'kpa 'a ‑yi 'bhii‑ 'ka 'bhɛ pɛ 'ɛ 'srɔɔwoa‑ gban, 'bhɛɛ‑ ‑e nu 'bhɛ 'nalɛ‑ 'ka ni 'tɛ. ");
INSERT INTO moa_vpl VALUES ("MK11_25","071_11_25","MRK","11","25","25","'Bhɛɛ‑ 'ke 'ka 'wlɛnna‑ 'ka 'seriwo zayi' ‑Waanbhaa' ni, 'bhɛɛ‑ 'kee‑ ‑dwa 'ka 'kpee 'bhii‑ mɛɛ 'ke ‑za 'yɔɔ‑ 'ke ꞊kla gban 'ka ni, ‑ka 'bhɛ zan a ‑sroma 'yan. ");
INSERT INTO moa_vpl VALUES ("MK11_26","071_11_26","MRK","11","26","26","'Duŋ‑, 'ke 'ka 'laa 'eke‑ a ‑sroma 'yanlɛ‑, 'ka Dɛ ‑Waanbhaa' 'la ‑yoo laanima, 'bhɛ 'laa nu 'ka mu a ‑sroma 'yanlɛ‑.» ");
INSERT INTO moa_vpl VALUES ("MK11_27","071_11_27","MRK","11","27","27","Zesu 'pegee ‑yaa' ‑klaŋlanɛ mu 'ɛ ‑o ge gbɛ drɛɛwoa‑ 'ezin‑ Zeruzalɛmu. Zesu 'yaa‑ 'kaan zii' bhla 'la ba ‑Waanbhaa' Gba 'Fɛ ‑Gbɛnɛ 'ɛ ꞊la, 'ke 'sraka 'lɛna ‑kuŋlii' mu 'ɛ 'pegee 'Toŋ daan mu 'ɛ, 'bhɛɛ‑ Zuufu mu a 'gwlaan‑ gblaan mu 'ɛ 'ke mu nule‑ 'tɛnlɛ‑ ‑a ma. ");
INSERT INTO moa_vpl VALUES ("MK11_28","071_11_28","MRK","11","28","28","'Bhɛɛ‑ 'ke ‑wa ‑lrɔkpale dɔɔ: «‑Dele 'bhɛ ‑za mu 'lɛɛ‑ klɛ 'seŋ ꞊naa 'e ni ɛɛ? 'Bhɛɛ‑ ‑dele ‑o klɛ ‑glɔɔya' ꞊naa 'e ni ɛɛ?» ");
INSERT INTO moa_vpl VALUES ("MK11_29","071_11_29","MRK","11","29","29","'Bhɛ klɛle 'tɛ, 'ke Zesu 'a 'lɛkunle ‑o ni 'kaa: «'Mi nu ‑jangɔ' do 'kpɔ ‑la ‑yilrɔkpalɛ 'ka ma, 'bhɛɛ‑ 'ke 'ka 'bhɛ 'lɛkwan‑ 'ŋ ni, mɛɛ 'la zan ‑za mu 'lɛɛ‑ klɛ 'seŋ ꞊naa 'ŋ ni, 'ŋ nu 'bhɛ 'tɔkanlɛ 'ka ni. ");
INSERT INTO moa_vpl VALUES ("MK11_30","071_11_30","MRK","11","30","30","'Bhɛ ‑jangɔ' do 'ɛ bhɛ ‑le ‑gɛ: ‑Dele Zaan 'winbwa‑ mɛɛ mu 'ɛ wiiŋfɛyrɛ nɔɔ‑ ‑yi ba, ‑Waanbhaa' taa‑ bhaaplɛŋ mu 'ɛ ɛɛ? ‑Ka 'bhɛ 'lɛkun 'ŋ ni doo!» ");
INSERT INTO moa_vpl VALUES ("MK11_31","071_11_31","MRK","11","31","31","'Duŋ‑ ‑o zaabɔle ꞊saan 'eke‑ ‑lɛ ma 'kaa: «'Ke 'wa 'lɛkwan‑ ‑a ni 'kaa ‑Waanbhaa' ‑le Zaan 'winbwa‑, ‑e nu 'o 'lrɔkpalɛ dɔɔ: ‹‑Mɛla ma 'ka 'laa 'ka 'kpalɛ‑ ‑a ‑yi ɛɛ?› ");
INSERT INTO moa_vpl VALUES ("MK11_32","071_11_32","MRK","11","32","32","'Bhɛɛ‑ 'o sɔ ‑a ‑lɛkunle ‑a ni dɔɔ: ‹Bhaaplɛŋ mu ‑le 'a 'winbwa‑ ɛɛ?› ‑O ‑yaa ‑gblaan 'zi ‑waa' mɛɛ mu 'ɛ 'lɛɛ, ‑amasrɔyi 'bhɛ mu 'kpɛn 'kpale‑ ‑yaa ‑a ‑yi 'bhii‑ Mɛɛ Wiiŋfɛ' Mi Zaan ‑yaa 'ke ‑Waanbhaa' ‑lɛla' janwo mi kpataakpa do ‑la ‑le.» ");
INSERT INTO moa_vpl VALUES ("MK11_33","071_11_33","MRK","11","33","33","'Bhɛ 'yi 'tɛ, 'ke ‑wa ‑lɛkunle Zesu ni dɔɔ: «'O mɔɔ laa 'bhɛ dɔ.» 'Bhɛɛ‑ Zesu pe ‑o ni 'ezin‑ dɔɔ: «'Mi 'duŋ‑, mɛɛ 'la zan ‑za mu 'lɛɛ‑ klɛ 'seŋ ꞊naa 'mi ni, 'mi laa nu 'bhɛ zan 'ɛ 'tɔkanlɛ 'ka ni.» ");
INSERT INTO moa_vpl VALUES ("MK12_1","071_12_1","MRK","12","1","1","'Bhɛ blaanta, 'ke Zesu ‑janwole 'sanle ‑o ni ‑gɔɔn mu 'yi. ‑E pe ‑o ni 'kaa: «Mɛɛ do ‑drɔɔ gba do ‑kpaa, ‑e 'jasa ꞊bwa 'bhɛ gba 'ɛ zi, 'bhɛɛ‑ ‑e ‑drɔɔ bhaa 'yigo‑ ‑gluu do ‑kaan, 'bhɛɛ‑ ‑e 'kpaanɛ do ‑dwa 'kpata‑ do wiiŋ‑ laanima gba 'ɛ gooba mi 'ɛ ‑yaa' pɛ 'le. 'Bhɛ blaan, 'kee‑ gba 'ɛ gbɛkpale yetanɛ mu 'ɛ 'kɔɔ 'kaa 'bhɛ mu 'e 'yrɛkpa 'a ba. 'Bhɛ blaan 'kee‑ gele‑ 'taa do ta. ");
INSERT INTO moa_vpl VALUES ("MK12_2","071_12_2","MRK","12","2","2","‑Drɔɔ bhaa 'kan bhla 'ɛ 'bhɔle‑, 'ke 'yee‑ gbazan 'ɛ ‑e ‑yaa' 'fa ‑la yewonɛ mu 'ɛ do 'winbɔle ‑yaa' yetanɛ mu 'ɛ ta, ‑yaa' pɛ ‑drɔɔ bhaa 'si zayi' 'woo‑ yetanɛ mu 'ɛ 'kɔɔ. ");
INSERT INTO moa_vpl VALUES ("MK12_3","071_12_3","MRK","12","3","3","'Bhɛ 'bhɔle‑ yetanɛ mu 'ɛ ta gba 'ɛ ta, 'ke ‑o 'bhɛ 'kunle, 'ke ‑o bhɛ tafɛle, 'bhɛɛ‑ 'ke ‑o 'ploole 'bhɛ 'kɔɔfleŋ‑ 'ɛ ma jafata. ");
INSERT INTO moa_vpl VALUES ("MK12_4","071_12_4","MRK","12","4","4","Gbazan 'ɛ ‑e ‑yaa' 'fa ‑la yewonɛ mu 'ɛ ‑bhɛɛke' do 'winbwa‑ 'ezin‑ 'o ta. 'Bhɛ 'bhɔle‑ gba 'ɛ ta ye, 'ke ‑o 'bhɛ 'saale 'bhɛ 'wiiŋ‑, 'bhɛɛ‑ 'ke ‑o 'bhɛ ‑zwanwole. ");
INSERT INTO moa_vpl VALUES ("MK12_5","071_12_5","MRK","12","5","5","'Bhɛ blaan, 'ke gbazan 'ɛ ‑e ‑yaa' 'fa ‑la yewonɛ mu 'ɛ 'bhɛɛke do winbɔle ‑o ta ye. 'Bhɛɛ‑ 'ke ‑o 'bhɛ dɛle‑. ‑Woo ‑bhɛɛke' ‑bebe mu ꞊kwan 'bhɛɛ‑ 'kungbɛya 'ɛ 'yi: ‑wa 'ke mu tafia꞊, 'bhɛɛ‑ ‑wa 'ke mu ꞊dia. ");
INSERT INTO moa_vpl VALUES ("MK12_6","071_12_6","MRK","12","6","6","Mɛɛ 'kedo‑ 'kpɔ 'laa bolɛ gbazan 'ɛ 'kɔɔ, 'ke yaa 'e ge ‑a gbe bhɛ do 'la ‑za ‑yaa sɔ ‑a ni 'egbɛnɛle 'bhɛ ba. ‑E 'bhɛ 'winbwa‑ 'woo‑ yetanɛ mu 'ɛ ta 'tɛ. ‑E ‑yaa pe 'zi ‑a 'kpee dɔɔ: ‹‑O nu ‑gasikpalɛ 'ŋ gbe 'ɛ 'bhɛ 'lɛɛ‑.› ");
INSERT INTO moa_vpl VALUES ("MK12_7","071_12_7","MRK","12","7","7","'Duŋ‑ ‑yetanɛ mu 'ɛ ‑o gbazan 'ɛ gbe 'ɛ 'yele‑ 'ke 'bhɛ ‑o zan, 'ke ‑wa pele 'eke‑ ni dɔɔ: ‹Gbazan 'ɛ 'ciɛn 'ɛ nu bolɛ mɛɛ 'la ni boolazi, 'yele‑ ‑gɛ, ‑kɔɔ 'a dɛ, 'bhɛɛ‑ gba 'ɛ bo ‑kɔɔ' ni.› ");
INSERT INTO moa_vpl VALUES ("MK12_8","071_12_8","MRK","12","8","8","‑O 'bhɛ 'kunle‑ 'tɛ, 'ke ‑o 'bhɛ dɛle‑, 'bhɛɛ‑ 'ke ‑wa gbaa 'ɛ blinle‑ ‑drɔɔ gba 'ɛ ‑zanta'.» ");
INSERT INTO moa_vpl VALUES ("MK12_9","071_12_9","MRK","12","9","9","'Bhɛ klɛle 'tɛ, 'ke Zesu ‑o ‑lrɔkpale dɔɔ: «'Ka 'kpee ma, 'ke ‑drɔɔ gbazan 'ɛ ꞊nwa, ‑e nu ‑mɛla klɛlɛ 'woo‑ ‑yetanɛ mu 'ɛ ni ɛɛ? 'Ŋ bhe, 'kee‑ ꞊nwa, ‑e nu ‑o dɛlɛ, 'bhɛɛ‑ ‑e ‑drɔɔ gba 'ɛ gbɛkpa ‑yetanɛ mu ‑bhɛɛke' mu 'kɔɔ. ");
INSERT INTO moa_vpl VALUES ("MK12_10","071_12_10","MRK","12","10","10","'Ka 'laa ‑jan 'lɛɛ‑ 'bhɛ tapelɛ ‑lido' ‑Waanbhaa' a 'Sɛwɛ 'ɛ 'yi yrɛ do nɔɔ‑ ɛɛ? 'Kaa: ‹Vlɛ 'la 'fɛdɔ‑ mu 'ɛ ‑wa ‑blinna, 'bhɛ ‑le ꞊kla 'ke 'fɛgwlɛ‑ 'ɛ gaan ꞊la vlɛ ‑kpuŋ 'lrele‑ 'gbu 'ɛ 'le. ");
INSERT INTO moa_vpl VALUES ("MK12_11","071_12_11","MRK","12","11","11","'Bhɛ ‑daa Mɛɛzan ‑Waanbhaa' ‑la ba. 'Bhɛɛ‑ 'bhɛ ꞊kla ‑kɔɔ' mu ‑yrɛ 'yi, ‑liibhaa' maza 'le.›» ");
INSERT INTO moa_vpl VALUES ("MK12_12","071_12_12","MRK","12","12","12","Zesu 'bhɛ ‑jan 'ɛ 'wolawoa bhe, Zuufu mu ‑kuŋlii mu 'ɛ 'yaa‑ ‑a 'kunyrɛ‑ ‑glin 'zi. ‑Amasrɔyi ‑wa 'yaangwa‑ 'bhii‑ Zesu 'bhɛ ‑gɔɔn ‑glɔɔn 'la bhe 'bhɛ ꞊bwa 'wo ‑la ma. 'Bhɛɛ‑ 'duŋ‑, ‑o ‑yaa ‑gblaanlawo zi 'ezin‑ ‑zamaa' 'ɛ 'lɛɛ bhe, ‑o Zesu ꞊twa ‑a nɔɔ‑ ye, 'bhɛɛ‑ ‑o ‑jilaa. ");
INSERT INTO moa_vpl VALUES ("MK12_13","071_12_13","MRK","12","13","13","‑O Farizi mu 'ɛ 'ke mu 'pegee ‑bhleŋgbe Erɔdi Antipasi a mɛɛ ‑lɛdo' 'ɛ 'ke mu 'winbwa‑ Zesu ba ‑jan bhee 'kpaa zayi' ‑a ‑lɛɛ, 'bhɛɛ‑ ‑wa kun ‑a 'gbu 'liijan‑ ma. ");
INSERT INTO moa_vpl VALUES ("MK12_14","071_12_14","MRK","12","14","14","'Bhɛ mɛɛ mu 'ɛ 'nule‑ 'tɛ, 'ke ‑wa pele‑ Zesu ni dɔɔ: «'O Daan mi, 'wa 'yaango‑ 'bhii‑ 'e wlan 'te ‑la pe, 'bhɛɛ‑ 'yaa gblaan mɛɛ 'kedo‑ 'kpɔ 'lɛɛ, ‑amasrɔyi 'yaa bhaaplɛŋ mu kun waa gblaanya ma, 'duŋ‑ 'taawogbɛya 'la sɔ ‑Waanbhaa' ni, 'yoo‑ daan 'bhɛɛ‑ 'le wlan 'ɛ ma. 'Woo‑ 'e 'lrɔkpale ‑za do ‑yi, ‑a pe 'o ni, ‑kɔɔa' 'toŋ 'ɛ ta, 'o sɔ ‑o Romɛ mu 'ɛ waa ‑Bhleŋgbe 'la sii Sezaa, 'bhɛ a 'nisra 'ɛ gbawole ɛɛ? 'Wa gbawo taa‑ 'waa gbawolɛ ɛɛ?» ");
INSERT INTO moa_vpl VALUES ("MK12_15","071_12_15","MRK","12","15","15","'Duŋ‑ Zesu 'yaa‑ ‑o dɔlawo 'bhii‑ ‑woo 'ke mɛɛ ‑yrɛkɔɔza klɛ mu 'la 'le bhe, 'ke ‑ya pele‑ ‑o ni dɔɔ: «‑Mɛle ꞊kla 'bhɛɛ‑ 'ka ‑o ‑jan bhee bɔ zii' 'ŋ 'lɛɛ ɛɛ? ‑Ka nu denie ‑gɔli' 'taŋbha do 'le 'ŋ ni 'bhɛɛ‑ 'an taglin‑ doo!» ");
INSERT INTO moa_vpl VALUES ("MK12_16","071_12_16","MRK","12","16","16","‑O nule 'bhɛ 'le ‑a ni 'tɛ, 'ke ‑yoo ‑lrɔkpale 'kaa: «‑Dela ŋgblo lii, 'bhɛ 'pegee ‑dela 'tɔ yɔɔndɛle ‑le 'taŋbha 'lɛɛ ta ‑gɛ ɛɛ?» ‑Wa zikpaa‑ ‑a ni dɔɔ: «Sezaa ‑le 'kɛle‑!» ");
INSERT INTO moa_vpl VALUES ("MK12_17","071_12_17","MRK","12","17","17","'Bhɛ klɛle 'tɛ, 'ke Zesu 'a 'pele ‑o ni dɔɔ: «Sezaa a pɛ ‑o 'kɛla 'le, ‑ka 'bhɛɛ‑ 'na 'bhɛ ni, 'bhɛɛ‑ ‑Waanbhaa a pɛ ‑o 'kɛla 'le, ‑ka 'bhɛɛ‑ 'na 'bhɛ ni!» 'Bhɛ ‑jan 'lɛkungbɛya 'ɛ 'bhɛ ‑o 'kpeelɛnia ‑o ma. ");
INSERT INTO moa_vpl VALUES ("MK12_18","071_12_18","MRK","12","18","18","‑O ‑yaa Zuufu mu ‑lɛdo' sii Saduse mu. Waa ‑yaa ‑o kpa ‑a ‑yi 'bhii‑ mɛɛ gbaa mu sɔ bwele‑ gale ba. 'Woo‑ Saduse mu 'ɛ 'ke mu ꞊nwa Zesu ba, 'bhɛɛ‑ ‑wa ‑lrɔkpaa dɔɔ: ");
INSERT INTO moa_vpl VALUES ("MK12_19","071_12_19","MRK","12","19","19","«'O Daan mi, Moizi 'toŋ 'lɛɛ‑ 'bhɛɛ‑ yɔɔndia‑ 'o ni 'kaa: 'Ke 'gwlaan‑ do ‑gaa, 'bhɛɛ‑ 'ke ‑ya na glaanle 'ɛ ꞊twa ‑a ‑zanta' 'ke yaa ‑nɛ yalɛ ‑li 'bhɛ ta. ‑A 'nwagwlɛn‑ nu 'bhɛ glaanle 'ɛ 'silɛ‑ 'bhɛ 'na 'le, 'kooko‑ 'bhɛ nu ‑nɛ mu 'la 'yalɛ‑ ‑a na 'ɛ ta, ‑wa 'tɔkpa‑ 'mu ma. ");
INSERT INTO moa_vpl VALUES ("MK12_20","071_12_20","MRK","12","20","20","'Bhɛ 'laa 'sanlɛ‑ bhaama, nɛɛnɛ‑ ma 'gwlaan‑ 'srwaplɛ‑ ‑yaa 'tɛ. ‑O 'naagwlɛn‑ le do ‑yalaa', 'bhɛ 'laa ‑nɛ 'yalɛ‑ 'bhɛ 'le 'ɛ ta 'ke 'bhɛ 'gbu gale‑. ");
INSERT INTO moa_vpl VALUES ("MK12_21","071_12_21","MRK","12","21","21","'Bhɛ gaanzidɔ 'ɛ, 'bhɛ 'yee‑ glaanle 'ɛ 'yalaa‑ 'ezin‑. 'Bhɛɛ‑ 'bhɛ 'laa ‑nɛ ‑srɔɔwolɛ 'yee‑ le 'ɛ ta 'ke 'bhɛ gale‑ 'ezin‑. ‑A gaanzidɔ 'gwlaan‑ yaga mi 'ɛ 'yee‑ ‑za do 'kpɔ 'ɛ 'bhɛ ‑le ꞊tian 'bhɛ ma 'ezin‑. ");
INSERT INTO moa_vpl VALUES ("MK12_22","071_12_22","MRK","12","22","22","'Woo‑ nɛɛnɛ‑ 'gwlaan‑ 'srwaplɛ‑ 'ɛ ‑o 'kpɛn 'a ꞊sia do do, 'bhɛɛ‑ ‑o ‑gaa, 'ke ‑waa ‑nɛ ya 'yee‑ le 'ɛ ta. ‑O 'kpɛn gale blaan, 'ke le mi 'ɛ 'gbu gale‑ 'ezin‑. ");
INSERT INTO moa_vpl VALUES ("MK12_23","071_12_23","MRK","12","23","23","Gbaa mu bwe yi 'ɛ 'le gale ba, le mi 'ɛ nu bolɛ ‑o ‑de 'gbu ‑la ni ɛɛ, ‑amasrɔyi ‑e ꞊kla ‑o 'kpɛn 'na 'le do do ɛɛ?» ");
INSERT INTO moa_vpl VALUES ("MK12_24","071_12_24","MRK","12","24","24","Zesu 'a zikpaa‑ ‑o ni dɔɔ: «'Ka ‑o 'ka 'yini‑ zii' 'egbɛnɛle, 'bhɛɛ‑ 'ka 'yi ‑o ni 'zi ‑za 'la ma 'ka 'bhɛ dɔ ɛɛ? ‑Jan mu 'la yɔɔndɛle ‑o ‑Waanbhaa' a 'Sɛwɛ 'ɛ 'yi, 'ka 'laa 'mu 'yima‑, 'bhɛɛ‑ 'ka 'laa ‑Waanbhaa' a ‑glɔɔya' 'ɛ dɔ. ");
INSERT INTO moa_vpl VALUES ("MK12_25","071_12_25","MRK","12","25","25","Wlan 'ɛ ni, 'ke gbaa mu ‑bwela gale ba yi 'la 'le, 'gwlaan‑ mu laa nu le mu 'silɛ‑ ‑li, 'bhɛɛ‑ le mu laa nu yaalɛ ‑li 'gwlaan‑ mu 'kɔɔ, 'duŋ‑ ‑o nu bolɛ 'bhii‑ ‑mlɛkɛ' mu a pɛ bogbɛya 'ɛ gbɛɛn‑ laflɛ' 'yi. ");
INSERT INTO moa_vpl VALUES ("MK12_26","071_12_26","MRK","12","26","26","'Bhɛɛ‑ gbaa mu bweza 'ɛ gale ba, 'ka 'laa 'bhɛ ‑za 'lɛɛ‑ tapelɛ ‑lido' Moizi ‑a 'sɛwɛ 'ɛ 'yi, ‑yri lunɛ‑ ‑za 'ɛ yɔɔndɛle ‑o yrɛ 'la ꞊nɔɔ bhe ɛɛ? ‑Waanbhaa' ‑jan 'lɛɛ‑ 'bhɛɛ‑ ꞊woa Moizi ni 'kaa: ‹'Mi ‑le 'ke Abraamu a ‑Waanbhaa' 'le, 'bhɛɛ‑ 'ŋ 'yoo‑ 'ke Izaki a ‑Waanbhaa' 'le, 'bhɛ 'pegee Zakɔbu a ‑Waanbhaa'.›» ");
INSERT INTO moa_vpl VALUES ("MK12_27","071_12_27","MRK","12","27","27","Zesu pe 'ezin‑ dɔɔ: «'Bhɛ ‑jan 'ɛ 'bhɛ 'a zrɔn ‑kɔɔ' ni 'bhii‑ ‑kɔɔ' ‑gbɔɔ mu 'la bhe ‑woo ‑o ‑yrɛ ma. 'Bhɛɛ‑ mɛɛ ‑yrɛmale mu ‑le ‑Waanbhaa' gba, mɛɛ gbaa mu laa 'bhɛ klɛ. 'Ke 'ka 'kpee ma, gbaa mu laa bwe gale ba, 'bhɛ bhla 'ɛ ba, 'ka 'yinile ‑o 'egbɛnɛle 'dɛ.» ");
INSERT INTO moa_vpl VALUES ("MK12_28","071_12_28","MRK","12","28","28","'Toŋ daan mi do Zesu 'pegee 'woo‑ mɛɛ mu 'ɛ ‑waa' zaabɔ wli 'ɛ ꞊maa. 'Bhɛ 'a ꞊ya 'bhii‑ Zesu ‑jan 'ɛ 'lɛkwan‑ 'elrele Saduse mu 'ɛ ni. 'Bhɛɛ‑ 'ke 'bhɛ 'e 'mabɛɛnle Zesu ‑din, 'ke 'bhɛ 'a 'lrɔkpale 'tɛ dɔɔ: «'Toŋ 'ɛ ‑dela ‑za 'gbu ‑o 'eglɔɔle ‑o 'kpɛn ba ɛɛ?» ");
INSERT INTO moa_vpl VALUES ("MK12_29","071_12_29","MRK","12","29","29","Zesu 'a zikpaa‑ ‑a ni dɔɔ: «'Toŋ 'la 'bhɛ ‑za 'gbu ‑o 'eglɔɔle 'bhɛ ‑le ‑gɛ: ‹Izraɛli mɛɛ mu, ‑ka 'ka 'trɔnbadɔ doo, Mɛɛzan ‑kɔɔa' ‑Waanbhaa' 'ɛ, 'bhɛ ‑le 'ke Mɛɛzan do ‑kplɛn 'le. ");
INSERT INTO moa_vpl VALUES ("MK12_30","071_12_30","MRK","12","30","30","'Yaa‑ Mɛɛzan ‑Waanbhaa 'ɛ, ‑za 'sɔ 'e ni 'e zru oo, 'e 'nii‑ oo, 'e 'kpeejan‑ oo, 'bhɛ 'pegee 'e faŋgan‑ 'ɛ 'kpɛn 'le.› ");
INSERT INTO moa_vpl VALUES ("MK12_31","071_12_31","MRK","12","31","31","'Toŋ 'la 'bhɛ tɛn 'bhɛ zi 'bhɛ ‑le ‑gɛ: ‹'E ‑vindo' mi ‑za 'sɔ 'e ni 'bhii‑ 'e 'gbu ‑za sɔ 'e 'gbu ni gɔnɛ‑ 'la gbɛɛn‑ bhe.› 'Toŋ 'bhɛɛke ‑za 'laa ‑o 'eglɔɔle 'ke 'bhɛ kan 'bhɛ 'toŋ plɛ 'la bhe 'mu ta.» ");
INSERT INTO moa_vpl VALUES ("MK12_32","071_12_32","MRK","12","32","32","'Bhɛ 'Toŋ daan mi 'ɛ pe Zesu ni 'tɛ dɔɔ: «'O Daan mi, 'bhɛ ‑o 'elrele, 'e wlan ‑la ‑pia 'bhɛ 'le bhe dɔɔ ‑Waanbhaa' ‑bhɛɛke' 'laa ‑o ‑Waanbhaa' blaan, 'ke yaa 'e go ‑a do ‑kplɛn ba. ");
INSERT INTO moa_vpl VALUES ("MK12_33","071_12_33","MRK","12","33","33","'Bhɛɛ‑ 'ke ‑Waanbhaa' ‑za sɔ mɛɛ ni ‑a zru oo, ‑a 'kpeejan‑ oo, 'bhɛɛ‑ ‑a faŋgan‑ 'ɛ 'kpɛn 'le, 'bhɛ 'pegee 'ke ‑a ‑vindo' mi ‑za sɔ ‑a 'gbu ni 'bhii‑ ‑a 'gbu gbɛɛn‑, 'bhɛ mabhaabhɔ wi 'kpaciele 'sraka mu 'pegee 'sraka 'ɛ ‑glɔɔn mu 'ɛ 'kpɛn ta ‑Waanbhaa' ‑yrɛ 'yi.» ");
INSERT INTO moa_vpl VALUES ("MK12_34","071_12_34","MRK","12","34","34","Zesu 'a 'yele‑ 'tɛ 'bhii‑ 'yee 'Toŋ daan mi 'ɛ ‑e ‑jan 'ɛ 'lɛkwan‑ yikan' 'le, 'ke ‑ya pele ‑a ni 'kaa: «‑Waanbhaa' a ‑bhleŋgbeya 'ɛ yaa ‑o ‑li 'e ma 'egbɔɔnle.» 'Bhɛ blaan, yaa dɔlɛ mɛɛ ‑bhɛɛke' 'kpee 'ke 'bhɛ Zesu 'liila‑ ‑a ‑lrɔkpalele 'ezin‑. ");
INSERT INTO moa_vpl VALUES ("MK12_35","071_12_35","MRK","12","35","35","Zesu 'yaa‑ mɛɛ mu 'ɛ daan 'zi bhla 'la ba ‑Waanbhaa' Gba 'Fɛ ‑Gbɛnɛ 'ɛ ꞊la, 'ke ‑yoo ‑lrɔkpale dɔɔ: «‑E ꞊kla 'nale‑ 'bhɛɛ‑ 'Toŋ daan mu 'ɛ ‑wa pe dɔɔ Mɛɛ ‑Bhee Mi ‑Kpɔsɔɔ 'ɛ ‑yoo 'ke Davidi 'nranɛ‑ ‑la 'le ɛɛ? ");
INSERT INTO moa_vpl VALUES ("MK12_36","071_12_36","MRK","12","36","36","‑Amasrɔyi Lii 'Weŋ 'ɛ ‑jan ꞊kpaa ‑Bhleŋgbe *Davidi 'gbu 'lii dɔɔ: ‹Mɛɛzan ‑Waanbhaa' 'a ꞊pia 'an pɛ Mɛɛzan 'ɛ ni dɔɔ: Yala‑ 'ŋ ‑din 'tɔbhɔ ma yaayrɛ 'ɛ ꞊nɔɔ, 'sani‑ 'ŋ yan 'e 'sɔɔnnii mu 'ɛ klɛlele 'e gaanlapɛ 'le.› ");
INSERT INTO moa_vpl VALUES ("MK12_37","071_12_37","MRK","12","37","37","'Ke Davidi 'gbu Mɛɛ ‑Bhee Mi ‑Kpɔsɔɔ Krisi sii ‹Mɛɛzan›. 'Bhɛɛ‑ ‑e sɔ klɛle 'ezin‑ ‑a ‑nranɛ 'le 'nale‑ ‑a ma ɛɛ?» ‑Zamaa' 'srɛ do 'la 'yaa‑ 'mu 'trɔnkpa zii' Zesu ni, bhɛ ‑jan mu 'ɛ 'yaa‑ 'sɔ zii' 'mu ni. ");
INSERT INTO moa_vpl VALUES ("MK12_38","071_12_38","MRK","12","38","38","Zesu 'yaa‑ mɛɛ mu 'ɛ daan 'zi bhla 'la ba ‑ya ꞊pia ‑o ni dɔɔ: «‑Ka 'ka 'gbu 'kun 'elrele 'Toŋ daan mu 'ɛ ma. 'Kaanle‑ sɔ ‑o ni dunɛ‑ gbɔɔn mu 'le ‑o ta, 'bhɛɛ‑ ‑e sɔ ‑o ni 'ke ‑woo 'pubɔ‑ 'elrele 'plɛɛ 'kpaan‑ mu 'ɛ ta. ");
INSERT INTO moa_vpl VALUES ("MK12_39","071_12_39","MRK","12","39","39","'Wole‑ zilɛɛ‑ yaayrɛ ‑lrele' mu 'ɛ makun Zuufu mu daanfɛ' mu 'ɛ ꞊la, 'bhɛ 'pegee pɛleyrɛ gblaan mu 'ɛ ꞊nɔɔ. ");
INSERT INTO moa_vpl VALUES ("MK12_40","071_12_40","MRK","12","40","40","‑O glaanle mu 'kɔɔpɛ‑ mu 'ɛ 'kpɛn yan ‑dawli' ma. 'Bhɛɛ‑ ‑o mɔ ‑o 'seriwole ma ‑Waanbhaa' ni ‑o 'gbu zrɔn zayi' mɛɛ mu ‑yrɛ ta. 'Bhɛla‑ ‑zayi', ‑o nu ‑o 'kitikanlɛ 'eyɔɔle 'ke 'bhɛ kan mɛɛ mu 'ɛ 'kpɛn ta ‑Waanbhaa' ba.» ");
INSERT INTO moa_vpl VALUES ("MK12_41","071_12_41","MRK","12","41","41","‑Waanbhaa' Gba 'Fɛ ‑Gbɛnɛ 'ɛ ꞊la, Zesu 'yaale‑ ‑lɛklale ‑yaa 'sraka go ‑gɔli' bɔ ‑koonɛ 'ɛ ta. 'Bhɛɛ‑ ‑e ‑yaa mɛɛ mu 'ɛ gbɛ zi ‑glin 'zi ‑waa' ‑gɔli' bɔgbɛya 'ɛ ma ‑koonɛ 'ɛ 'yi. Pɛzan ‑bebe 'yaa‑ ‑gɔli' ‑bebe bɔ 'zi 'yee‑ ‑koonɛ 'ɛ 'yi. ");
INSERT INTO moa_vpl VALUES ("MK12_42","071_12_42","MRK","12","42","42","'Bhɛ ꞊nɔɔ bhe, 'ke ‑yrɛn ma glaanle do nule‑, 'bhɛɛ‑ 'ke 'bhɛ ‑gɔli' piinɛ‑ plɛ bɔle‑ ‑koonɛ 'ɛ 'yi. 'Bhɛ mu laa ‑yaa 'taŋbha plɛ bhɔ. ");
INSERT INTO moa_vpl VALUES ("MK12_43","071_12_43","MRK","12","43","43","'Bhɛ klɛle 'tɛ, 'ke Zesu ‑yaa' ‑klaŋlanɛ mu 'ɛ 'siile, 'bhɛɛ‑ 'ke ‑ya pele ‑o ni dɔɔ: «'Mi pe 'ka ni 'ŋ 'sɔwɛɛ‑ 'ɛ ma dɔɔ glaanle 'kɔɔfleŋ‑ 'lɛɛ‑ ‑e ‑gɔli' yɛkɛ‑ 'la ꞊bwa ‑koonɛ 'ɛ 'yi, 'bhɛ 'yiya‑ mɛɛ ‑vin mu 'ɛ 'kpɛn ‑gɔli' yɛkɛ‑ 'la ꞊bwa 'bhɛ ni. ");
INSERT INTO moa_vpl VALUES ("MK12_44","071_12_44","MRK","12","44","44","‑Amasrɔyi mɛɛ ‑vin mu 'ɛ ‑o waa ‑naflo 'ɛ sa ‑la ꞊sia, 'bhɛɛ‑ ‑o 'bhɛ ꞊bwa 'ke 'sraka 'le. 'Duŋ‑ 'yee‑ glaanle 'lɛɛ‑, ‑ya 'tɔta‑ ‑gɔli' 'ɛ 'bhɛɛ‑ 'kpɛn ꞊naa 'ke 'sraka 'le. ‑Zake' 'laa bolɛ ‑a 'kɔɔ 'ezin‑, 'ali‑ 'ke 'bhɛ klɛ ‑yaa' pɛbhle ma pɛ 'le.» ");
INSERT INTO moa_vpl VALUES ("MK13_1","071_13_1","MRK","13","1","1","Zesu 'pwɛ bhla 'ɛ zi ‑Waanbhaa' Gba 'Fɛ ‑Gbɛnɛ 'ɛ ꞊la, 'ke ‑yaa' ‑klaŋlanɛ mu 'ɛ do 'a 'pele ‑a ni dɔɔ: «'O Daan mi, vlɛ ‑kpuŋ 'lrele‑ mu 'lɛɛ‑ 'pegee 'fɛgwlɛ‑ ‑gbɛnɛ mu 'lɛɛ‑ dɔgbɛya 'ɛ ‑glin doo!» ");
INSERT INTO moa_vpl VALUES ("MK13_2","071_13_2","MRK","13","2","2","Zesu 'a zikpaa‑ ‑a ni dɔɔ: «'E 'yrɛ ‑o 'bhɛ 'fɛ dɔgbɛya ‑gbɛnɛ ‑gbɛnɛ mu 'lɛɛ‑ ma ɛɛ? Yi do ta, ‑o nu 'fɛ mu 'lɛɛ‑ 'kpɛn 'wilɛ‑, 'bhɛɛ‑ ‑o nu vlɛ ‑kpuŋ mu 'ɛ 'kpɛn 'klaalɛ‑, 'bhɛɛ‑ 'woo‑ vlɛ ‑kpuŋ mu 'la ‑gɛ, ‑o do 'kpɔ 'laa nu bolɛ 'eke‑ ta ‑gɛ 'ke 'bhɛ 'laa balaa'.» ");
INSERT INTO moa_vpl VALUES ("MK13_3","071_13_3","MRK","13","3","3","'Bhɛ blaan, Zesu ‑ja yaalɛ Olivi diiŋ vlɛ gɔɔn 'ɛ ta, 'bhɛɛ‑ ‑ya ‑lɛklaa ‑Waanbhaa' Gba 'fɛ ‑Gbɛnɛ 'ɛ ba ‑yrɛ ta. Piɛri 'pegee Zaki, 'bhɛɛ‑ Zaan 'pegee Andre, 'bhɛ mu do ‑kplɛn ‑le 'yaa‑ ‑din, 'bhɛɛ‑ 'mu 'a ‑lrɔkpaa 'kaa: ");
INSERT INTO moa_vpl VALUES ("MK13_4","071_13_4","MRK","13","4","4","«'E ‑jan mu 'la ꞊woa bhe, 'ke 'bhɛ ‑za mu 'ɛ klɛ bhla 'ɛ ꞊bhwa 'o nu 'bhɛ dɔlɛ ‑tɔɔmasie 'ɛ ‑dela ma ɛɛ? 'Bhɛɛ‑ ‑o bhɔ 'waati 'ɛ 'bhɛ 'pe 'o ni.» ");
INSERT INTO moa_vpl VALUES ("MK13_5","071_13_5","MRK","13","5","5","'Bhɛ klɛle 'tɛ, 'ke Zesu ‑jan 'ɛ 'sile, 'bhɛɛ‑ 'ke ‑ya 'pele‑ 'sanle ‑o ni dɔɔ: «‑Ka 'ka 'gbu 'kun 'elrele, 'ke mɛɛ 'kedo‑ 'kpɔ 'laa 'ka 'yini‑. ");
INSERT INTO moa_vpl VALUES ("MK13_6","071_13_6","MRK","13","6","6","‑Amasrɔyi, mɛɛ ‑bebe nu nulɛ, 'mi 'tɔ 'ɛ 'yi, 'bhɛɛ‑ ‑o nu ‑a pelɛ dɔɔ 'wole‑ ‑Waanbhaa' Mɛɛ ‑Bhee Mi ‑Kpɔsɔɔ 'la 'kpa ‑janwoa, 'bhɛ 'le! 'Bhɛ klɛgbɛya 'ɛ 'yi, ‑o nu mɛɛ ‑bebe 'yinilɛ. ");
INSERT INTO moa_vpl VALUES ("MK13_7","071_13_7","MRK","13","7","7","'Ke 'ka 'ka ‑din gwledan wli ‑maa, 'bhɛ 'pegee 'ke 'ka yrɛ gbɔɔn ꞊nɔɔ gwledan wli mu ‑maa bhla 'la ba, 'ka 'laa ‑gblaanlɛ'. ‑Amasrɔyi ‑a ‑lɛdulale ‑o dɔɔ 'bhɛ ‑za mu 'ɛ 'mu ‑le nu klɛlɛ 'elwale 'pe. 'Duŋ‑ 'bhɛ 'laa nu klɛlɛ 'ke 'drunyan 'lɛyan bhla 'ɛ 'le. ");
INSERT INTO moa_vpl VALUES ("MK13_8","071_13_8","MRK","13","8","8","'Si do nu ‑wlɛnlɛ' 'si 'bhɛɛke do 'kaama‑, 'bhɛɛ‑ ‑bhleŋgbe do a 'klɛɛn 'yi mu nu ‑wlɛnlɛ' ‑bhleŋgbe 'bhɛɛke do a 'klɛɛn 'yi mu 'kaama‑. 'Trɛ nu bɛɛnlɛ, 'bhɛ 'pegee ‑gu mu nu dɔlɛ yrɛ ‑bebe ꞊nɔɔ. 'Bhɛ ‑za mu 'ɛ nu klɛlɛ ‑yrɛn mu 'ɛ zisanyrɛ 'le, 'bhii‑ 'ke le do ‑bla ꞊zian ‑a ta ‑e ‑yrɛnbhle' gɔnɛ‑ 'la gbɛɛn‑ bhe. ");
INSERT INTO moa_vpl VALUES ("MK13_9","071_13_9","MRK","13","9","9","'Duŋ‑, 'ka mu, ‑ka 'ka 'gbu 'kun 'elrele! ‑Amasrɔyi, mɛɛ mu nu gelɛ 'ka 'le ‑klu ta; ‑o nu 'ka tafɛlɛ 'ke gbaŋbhlɛ mu 'le Zuufu mu daanfɛ' mu 'ɛ ꞊la. ‑O nu gelɛ 'ka 'le ‑janmatii mu 'pegee ‑bhleŋgbe mu 'ɛ ba 'mi 'tɔ 'ɛ ‑zayi'. 'Ke 'bhɛ ꞊kla 'tɛ, 'ka nu klɛlɛ 'ŋ 'srɛ mu 'le 'bhɛ ‑yrɛ mu 'ɛ 'kpɛn ꞊nɔɔ. ");
INSERT INTO moa_vpl VALUES ("MK13_10","071_13_10","MRK","13","10","10","'Sani‑ 'drunyan 'yan bhla 'ɛ 'bhɔ, ‑yoo 'ke ‑za 'le 'ke 'an ‑Jan 'Nrale‑ 'ɛ ‑wa wo 'trɛ ta 'si mu 'ɛ 'kpɛn ni 'pe.» ");
INSERT INTO moa_vpl VALUES ("MK13_11","071_13_11","MRK","13","11","11","«'Ke ‑o 'ka ꞊kwan, 'bhɛɛ‑ 'ke ‑o ge 'zi 'ka 'le ‑klu ta 'ka 'kitikan zayi' bhla 'la ba, 'ka nu ‑jan yɛkɛ‑ 'la 'wolɛ‑, 'ka 'laa 'bhɛ yiɛnkanlɛ 'elwale 'pe. 'Duŋ‑ 'ke 'ka ꞊bhwa ye, ‑jan 'la ‑Waanbhaa' 'bhɛ dɔle‑ 'ka 'kpee 'ka 'kitikan bhla do 'kpɔ 'ɛ zi bhe, ‑ka 'bhɛɛ‑ 'wo. ‑Amasrɔyi 'bhɛ ‑jan 'ɛ 'bhɛ 'laa nu dalɛ 'ka mu 'gbu ba, 'duŋ‑ 'bhɛ nu dalɛ Lii 'Weŋ 'ɛ 'bhɛ a ‑glɔɔya' 'ɛ 'bhɛɛ‑ ba.» ");
INSERT INTO moa_vpl VALUES ("MK13_12","071_13_12","MRK","13","12","12","«Mɛɛ do nu ‑a nɛɛnɛ‑ do ‑lɛnalɛ mɛɛ mu ni 'bhɛɛ‑ 'mu 'bhɛ dɛ, 'bhɛɛ‑ ‑nɛ dɛ nu 'bhɛɛ‑ 'yansi za 'ɛ klɛlɛ 'bhɛ 'nɛ 'ɛ ni. ‑Nɛ mu nu ‑wlɛnlɛ' ‑o yapɛ mu 'ɛ 'kaama‑ 'bhɛɛ‑ ‑o 'mu dɛ. ");
INSERT INTO moa_vpl VALUES ("MK13_13","071_13_13","MRK","13","13","13","'Ka vɛn nu 'silɛ‑ mɔkpɛn' yin 'lii 'mi 'tɔ 'ɛ ‑zayi'. 'Duŋ‑ 'ke mɛɛ 'la zan 'bhɛ ‑yrɛn 'mu 'ɛ 'kpɛn 'yikwan꞊ 'ke 'bhɛ ge 'tɛnlɛ‑ ‑o ‑lɛyanle ma, 'bhɛ zan nu golɛ ‑za 'yi.» ");
INSERT INTO moa_vpl VALUES ("MK13_14","071_13_14","MRK","13","14","14","«Pɛ 'la vɛnsi ‑Waanbhaa' yin 'lii, 'ka nu 'bhɛ 'yaale‑ yelɛ *‑Waanbhaa' Gba 'Fɛ ‑Gbɛnɛ 'ɛ ꞊la 'ke ‑ya 'triŋdɔ‑. 'Ke mɛɛ 'la zan ‑o ‑jan 'lɛɛ tape 'zi, 'bhɛ zan dɔ klɛn 'ke ‑ya ‑yima' 'elrele. 'Bhɛ 'waati 'ɛ ba, 'ke mɛɛ 'la zan mu ꞊kla Zude 'klɛɛn 'ɛ 'yi, 'mu blasan‑ 'mu ‑lɛɛ vlɛ gɔɔn mu 'ɛ 'yi ye. ");
INSERT INTO moa_vpl VALUES ("MK13_15","071_13_15","MRK","13","15","15","'Bhɛ 'waati 'ɛ ba, 'ke mɛɛ 'la zan ‑o 'bhɛ a 'fɛ 'ɛ 'wiiŋ‑, 'bhɛ zan laa pelɛ dɔɔ 'bhɛ ‑o zinale, 'bhɛɛ‑ ‑e wlale‑ ‑yaa' 'fɛ 'ɛ ꞊la, ‑a maza ‑o pɛ 'la ma 'bhɛ 'si zayi'. ");
INSERT INTO moa_vpl VALUES ("MK13_16","071_13_16","MRK","13","16","16","'Bhɛɛ‑ 'ke mɛɛ 'la zan꞊kla 'bhɛ ba gba la 'bhɛ 'waati 'ɛ ba, 'bhɛ zan laa pelɛ dɔɔ ‑e niinale ‑a ba 'fɛ 'lɛ ma, ‑a ta dunɛ‑ tralapɛ 'si 'si zayi'. ");
INSERT INTO moa_vpl VALUES ("MK13_17","071_13_17","MRK","13","17","17","'Bhɛ yi mu 'ɛ 'le, 'ke le mu 'la kpɛle ꞊kla 'bhɛ 'waati 'ɛ ba, 'bhɛ 'pegee 'ke le mu 'la 'nɛ mu ꞊kla ‑yɔn ma, 'mu 'nisɛ‑ ‑yrɛn ma! ");
INSERT INTO moa_vpl VALUES ("MK13_18","071_13_18","MRK","13","18","18","‑Ka 'ka 'seriwo ‑Waanbhaa' ni, 'kooko‑ 'bhɛ 'waati 'ɛ yaa klɛ ‑niinii' 'kpa bhla zi. ");
INSERT INTO moa_vpl VALUES ("MK13_19","071_13_19","MRK","13","19","19","‑Amasrɔyi, 'bhɛ yi mu 'ɛ nu klɛlɛ 'eyɔɔle gɔnɛ‑ 'la gbɛɛn‑, ‑a 'san ‑Waanbhaa' 'drunyan klɛ 'ke 'bhɛ nu 'tɛnlɛ‑ ‑zɔn ma, 'bhɛ 'yansi ‑yrɛnbhle' gbɛya 'laa baalɛ ‑lido' bhaaplɛŋ mu ta 'bhɛ gbɛɛn‑. 'Bhɛɛ‑ 'kee‑ ge 'tɛnlɛ‑ 'drunyan 'lɛyanle ma, 'bhɛ 'yansi ‑yrɛn 'laa nu baalɛ ‑o ta. ");
INSERT INTO moa_vpl VALUES ("MK13_20","071_13_20","MRK","13","20","20","'Ke Mɛɛzan ‑Waanbhaa' laa 'bhɛ ‑yrɛn 'kpa yi mu 'ɛ 'ke 'kanlɛ‑ ‑o lii, mɛɛ 'kedo‑ 'kpɔ 'laa ‑yaa nu 'sɔlɛ‑ gole‑ ‑za 'yi. 'Duŋ‑ ‑e mɛɛ 'la zan mu makwan‑ gban ‑yaa pɛ mu 'le, ‑e 'yee‑ ‑yrɛn 'kpa yi mu 'ɛ 'ke 'kaan ‑o ‑lii, 'mu ‑la ‑zayi'. ");
INSERT INTO moa_vpl VALUES ("MK13_21","071_13_21","MRK","13","21","21","'Ke mɛɛ 'ke 'a ꞊pia 'ka ni bhla 'la ba 'kaa: ‹‑Ka 'ka 'yrɛkpa, Mɛɛ ‑Bhee Mi ‑Kpɔsɔɔ Krisi 'ɛ ‑yoo ‑gɛ›. 'Bhɛɛ‑ ‹‑Ka 'ka 'yrɛkpa, ‑yoo laale!› 'Ka 'laa 'ka 'kpalɛ‑ ‑a ‑yi. ");
INSERT INTO moa_vpl VALUES ("MK13_22","071_13_22","MRK","13","22","22","‑Amasrɔyi bhla ma mɛɛ mu nu ‑wlɛnlɛ', 'bhɛɛ‑ ‑o nu a pelɛ dɔɔ 'wole‑ 'ke mɛɛ ‑bhee mu ‑kpɔsɔɔ 'gbu 'ɛ 'le, 'bhɛɛ‑ bhla ma ‑Waanbhaa' ‑lɛla' janwo mu nu nulɛ 'ezin‑. ‑O nu 'sɔle‑ maza mu 'pegee 'kpeelɛni maza mu klɛlɛ, 'kooko‑ 'ke 'bhɛ sɔ klɛle‑, 'bhɛɛ‑ ‑o gbɛsɔ ‑Waanbhaa' mɛɛ 'la zan mu makwan‑ gban 'mu ‑yinile ta. ");
INSERT INTO moa_vpl VALUES ("MK13_23","071_13_23","MRK","13","23","23","'Ka mu, ‑ka 'ka 'yrɛkpa 'ka 'gbu ba 'elrele! 'Ŋ 'ka 'kpeelɛlakaan ‑gɛ bhe 'bhɛ ‑za mu 'ɛ 'kpɛn 'le.» ");
INSERT INTO moa_vpl VALUES ("MK13_24","071_13_24","MRK","13","24","24","«'Bhɛ yi mu 'ɛ 'le, 'bhɛ ‑yrɛn 'kpa yi mu 'ɛ 'kanle‑ blaan, ‑yretɛbhɛ laa nu ‑bhilɛ' ‑li, ‑e nu klɛlɛ 'ke ‑gblo 'le, 'bhɛɛ‑ mlɛ laa nu 'sɔlɛ‑ ‑bhile' 'ezin‑. ");
INSERT INTO moa_vpl VALUES ("MK13_25","071_13_25","MRK","13","25","25","'Bhɛɛ‑ mlɛklɛnnɛ mu 'ɛ nu baalɛ. ‑Glɔɔya' mu 'la laflɛ' 'yi pɛ mu kun 'bhɛɛ‑ waa sɔ baale', 'mu nu bɛɛnlɛ. ");
INSERT INTO moa_vpl VALUES ("MK13_26","071_13_26","MRK","13","26","26","'Bhɛ bhla 'ɛ ba 'tɛ, 'ka 'yrɛ nu 'kpalɛ‑ *Bhaaplɛŋ Gbe 'ɛ 'nule‑ ma laflɛ' ‑gblɛn mu 'ɛ 'yi, ‑yaa' ‑glɔɔya' ‑gbɛnɛ 'ɛ 'le, 'bhɛ pegee ‑a ‑lregbɛya ‑yrayra 'ɛ 'le. ");
INSERT INTO moa_vpl VALUES ("MK13_27","071_13_27","MRK","13","27","27","'Bhɛ klɛle 'tɛ, ‑e nu ‑yaa' ‑mlɛkɛ mu 'ɛ winbɔlɛ ‑e mɛɛ 'la zan mu makwan‑, 'mu ‑lɛkpayrɛ ꞊nɔɔ 'eke‑ ta, 'ke 'mu da ‑yretɛbhɛ ‑wlɛnyrɛ' 'pegee ‑a baayrɛ ꞊nɔɔ, 'bhɛɛ‑ 'ke 'bhɛ ge 'kpalɛ‑ laflɛ' 'pegee 'trɛ ‑daŋma' mu ta.» ");
INSERT INTO moa_vpl VALUES ("MK13_28","071_13_28","MRK","13","28","28","«‑Ka figi diiŋ 'ɛ 'klɔsikun doo, 'bhɛɛ‑ ‑ka ‑za daan ‑a ma: 'ke ‑a ‑yi 'ɛ 'paa‑ ‑a gbɛ mu 'ɛ 'yi, 'bhɛɛ‑ 'ke ‑a ‑laa mu 'ɛ 'tɔɔnle‑ ‑saan ‑a ta bhla 'la ba, 'kaa 'yaango‑ 'bhii‑ la ban bhla 'ɛ ꞊bhwa 'e ‑din. ");
INSERT INTO moa_vpl VALUES ("MK13_29","071_13_29","MRK","13","29","29","'Bhɛ klɛgbɛya do 'ɛ 'yi, 'ka mu 'ezin‑, 'ŋ ‑za mu 'la ꞊pia 'ka ni bhe, 'ke 'ka 'mu klɛle ‑ya bhla 'la ba, ‑kaa 'yaango‑ 'bhii‑ Bhaaplɛŋ Gbe 'ɛ 'nu bhla 'ɛ ꞊bhwa 'ka ‑din gban. ");
INSERT INTO moa_vpl VALUES ("MK13_30","071_13_30","MRK","13","30","30","'Mi pe 'ka ni 'ŋ 'sɔwɛɛ‑ 'ɛ ma dɔɔ: mɛɛ 'la zan mu ‑o ‑yrɛ ma ‑zɔn, ‑o 'kpɛn gale pleŋ‑, 'ke ‑za mu 'lɛɛ‑ 'kpɛn ꞊bhwa gban. ");
INSERT INTO moa_vpl VALUES ("MK13_31","071_13_31","MRK","13","31","31","Laflɛ' 'pegee 'trɛ nu 'kanlɛ‑ 'duŋ‑ 'an pɛ ‑jan mu 'ɛ waa nu 'kanlɛ‑ ‑titi.» ");
INSERT INTO moa_vpl VALUES ("MK13_32","071_13_32","MRK","13","32","32","Zesu pe 'ezin‑ dɔɔ: «‑Za mu 'lɛɛ‑ klɛ yi oo, ‑o klɛ 'waati oo, mɛɛ 'kedo‑ 'kpɔ 'laa 'mu dɔ. 'Kee‑ kpa laflɛ' 'yi ‑mlɛkɛ' 'pegee ‑Waanbhaa' Gbe 'gbu 'ɛ ta oo, ‑o 'kedo‑ 'kpɔ 'laa 'mu dɔ, 'ke yaa 'e go 'ŋ Dɛ ‑Waanbhaa' do ‑kplɛn ba. ");
INSERT INTO moa_vpl VALUES ("MK13_33","071_13_33","MRK","13","33","33","‑Ka 'ka 'yrɛkpa 'ka 'gbu ba 'elrele, 'ka 'yri 'laa golɛ 'ka 'gbu ‑za 'le, ‑amasrɔyi 'ka 'laa 'bhɛ 'waati 'bhɔ bhla 'ɛ dɔ. ");
INSERT INTO moa_vpl VALUES ("MK13_34","071_13_34","MRK","13","34","34","‑E nu klɛlɛ 'bhii‑ mɛɛ do geza gbɛn ta: ‑a ge bhla 'ɛ zi, ‑e ‑yaa' 'fɛ 'ɛ gbɛkpaa ‑yaa' 'fa ‑la yewonɛ mu 'ɛ 'kɔɔ. ‑E ye 'ɛ 'yiciɛnna ‑o 'kpɛn ma do do, 'bhɛɛ‑ ‑ya ꞊pia 'fɛ gooba mi 'ɛ ni dɔɔ 'bhɛ bo 'fɛ 'ɛ ‑klɔsikunle ma, 'bhɛɛ‑ 'bhɛ 'yri 'laa golɛ 'bhɛ 'gbu ‑za 'le. ");
INSERT INTO moa_vpl VALUES ("MK13_35","071_13_35","MRK","13","35","35","'Bhɛ gbɛɛn‑ bhe, 'ka mu 'gbu 'yri 'laa golɛ 'ka 'gbu ‑za 'le 'dɛ, ‑amasrɔyi 'ka 'laa 'fɛzan‑ 'ɛ 'niina‑ bhla 'ɛ dɔ, ‑e nu klɛlɛ yroma ‑la zi oo, blaŋdrɛyi oo, maagwlɛn ‑we bhla 'ɛ ba oo, 'bhɛ 'pegee zrwanzi, 'ka 'laa 'bhɛ dɔ. ");
INSERT INTO moa_vpl VALUES ("MK13_36","071_13_36","MRK","13","36","36","'Kee‑ ꞊nwa 'ka 'yibɛɛnnazi, bhaa yaa bhɔlɛ 'ka ta yi pla. ");
INSERT INTO moa_vpl VALUES ("MK13_37","071_13_37","MRK","13","37","37","'Mi 'kɛla 'wo zii' 'ka ni ‑gɛ, 'mi 'bhɛɛ‑ do 'kpɔ 'ɛ wo mɔkpɛn' ni dɔɔ: ‹'Ka 'yri 'laa golɛ 'ka 'gbu ‑za 'le.›» ");
INSERT INTO moa_vpl VALUES ("MK14_1","071_14_1","MRK","14","1","1","‑Yrekpaa' plɛ ‑yaa Paki 'fɛti yi 'ɛ 'lɛɛ, 'bhɛ 'pegee 'bluu mu 'la waa ‑yaa 'mu ‑pɛɛ 'ɛ wlɛn 'ke 'sɛkɛ 'le 'mu 'bhle 'fɛti 'ɛ. 'Sraka 'lɛna ‑kuŋlii' mu 'ɛ 'pegee 'Toŋ daan mu 'ɛ ‑o ‑yaa Zesu 'kunyrɛ‑ ‑glin 'zi ‑dawli' ma, 'bhɛɛ‑ ‑wa dɛ. ");
INSERT INTO moa_vpl VALUES ("MK14_2","071_14_2","MRK","14","2","2","'Duŋ‑, ‑o ‑yaa pe 'zi 'eke‑ ni 'kaa: «‑Kɔɔ' 'laa 'bhɛ klɛlɛ 'fɛti 'waati 'ɛ ba, 'kebhlaale ‑kɔɔa' mɛɛ mu 'ɛ nu ‑wlɛnlɛ' 'eke‑ ma.» ");
INSERT INTO moa_vpl VALUES ("MK14_3","071_14_3","MRK","14","3","3","'Bhɛ 'waati 'ɛ ba, Zesu 'pegee ‑yaa ‑klaŋlanɛ mu 'ɛ 'yaa‑ Betani ‑wa 'ɛ ta 'gwlaan‑ do a 'fɛ 'ɛ ꞊la; 'bhɛ 'tɔ ‑le ‑yaa Simɔ, 'bhɛɛ‑ ‑kpaan ‑yaa 'bhɛ ma ‑sɔ. ‑O ‑yaa pɛbhle 'zi 'waati 'la ba, 'ke le do nule‑ wlalɛ ‑o ta. Buteli bhlɔ gbɔɔn ‑lrele' do ‑yaa 'bhɛ le 'ɛ 'kɔɔ, 'bhɛ buteli 'ɛ klɛle ‑yaa 'ke 'vɛrɛ ‑glɔɔn 'la ‑o ‑yaa 'bhɛ sii alibatri 'bhɛɛ‑ 'le. ‑Lasiklɔɔ ‑gblɛn 'nrale‑ 'plɛɛle‑ do ‑le ‑yaa 'bhɛ buteli 'ɛ 'yi. 'Bhɛ 'yi 'tɛ, 'ke 'yee‑ le 'ɛ ‑e 'bhɛ buteli 'ɛ 'wile, 'bhɛɛ‑ 'ke ‑ya ‑yi ‑lasiklɔɔ 'ɛ 'klaale Zesu 'wiiŋ‑. ");
INSERT INTO moa_vpl VALUES ("MK14_4","071_14_4","MRK","14","4","4","Mɛɛ 'la zan mu ‑yaa 'bhɛ 'yrɛ 'ɛ ꞊nɔɔ ye, ‑o 'ke mu ‑o zrupliila, 'ke ‑wa pele‑ 'eke‑ ni dɔɔ: «Le 'lɛɛ ‑yoo ‑lasiklɔɔ ‑gblɛn 'nrale‑ 'lɛɛ 'siɛ zii' win 'ɛ ‑dela ma ɛɛ? ‑E 'bhɛ 'siɛ zii' bhaama ‑mɛla ma ɛɛ? ");
INSERT INTO moa_vpl VALUES ("MK14_5","071_14_5","MRK","14","5","5","‑O ‑yaa sɔ a gɔnle‑ denie ‑gɔli' 'taŋbha ‑kɛmɛ yaga (300) 'e tralapɛ 'le; 'bhɛɛ‑ ‑o 'bhɛ ‑gɔli' 'ɛ na 'kɔɔfleŋzan mu ni!» ‑O 'bhɛ le 'ɛ 'tɔpia‑ 'eyɔɔle. ");
INSERT INTO moa_vpl VALUES ("MK14_6","071_14_6","MRK","14","6","6","'Duŋ‑ Zesu 'a zikpaa‑ ‑o ni dɔɔ: «‑Kaa 'to 'srɔ! ‑Mɛle ꞊kla 'bhɛɛ‑ 'ka ‑o ‑a zrubatɛdɔ zii' ɛɛ? ‑E ‑za 'wlan ‑la ꞊kla 'ŋ ni bhe. ");
INSERT INTO moa_vpl VALUES ("MK14_7","071_14_7","MRK","14","7","7","‑Amasrɔyi, 'kɔɔfleŋzan mu ‑o 'ka 'pleŋ‑ yikpɛn ta, 'bhɛɛ‑ 'ke 'waati 'oo 'waati 'la ꞊swa 'ka ni, 'ka sɔ ‑za 'wlan klɛle‑ 'mu ni, 'duŋ‑ 'mi 'laa nu bolɛ 'ka ‑din 'waati 'ɛ 'kpɛn ba. ");
INSERT INTO moa_vpl VALUES ("MK14_8","071_14_8","MRK","14","8","8","Le 'lɛɛ gbɛswa‑ 'kɛla klɛle ta, ‑e 'bhɛɛ‑ ꞊kla. Drɔɔn', ‑e ‑yaan gban ‑lasiklɔɔ 'klalele 'ŋ gbaa 'ɛ ta ‑a binle ‑lɛɛ. ");
INSERT INTO moa_vpl VALUES ("MK14_9","071_14_9","MRK","14","9","9","'Mi 'gbu pe 'ka ni 'ŋ 'sɔwɛɛ‑ ma 'kaa 'ke ‑Jan 'Nrale‑ 'ɛ 'wole‑ ꞊zian yrɛ 'oo yrɛ 'la ꞊nɔɔ, 'drunyan 'ɛ 'kpɛn 'yi, ‑o nu le 'lɛɛ klɛza 'ɛ 'yigɔɔnlɛ 'bhɛ ꞊nɔɔ, 'kooko‑ 'yee‑ le 'ɛ ‑za dɔ mɛɛ mu 'ɛ 'kpee.» ");
INSERT INTO moa_vpl VALUES ("MK14_10","071_14_10","MRK","14","10","10","Zesu a ‑klaŋlanɛ vu ta plɛ mi 'la ‑o ‑yaa 'bhɛ sii Zuda Isikariɔti ‑ja 'tɛnlɛ‑ 'Sraka 'lɛna ‑kuŋlii mu 'ɛ ma, 'ke ‑ya pele‑ 'mu ni dɔɔ ‑ya zi 'bhii‑ ‑e Zesu 'lɛna ‑o ni. ");
INSERT INTO moa_vpl VALUES ("MK14_11","071_14_11","MRK","14","11","11","'Bhɛ ‑jan 'ɛ ꞊swa 'mu ni 'egbɛnɛle, ‑ayile 'ke 'mu 'a 'pele a ni dɔɔ 'mu nu ‑gɔli' 'nalɛ‑ ‑a ni. ‑A 'san 'bhɛ yi 'ɛ ma, Zudasi gbɛ ‑yaa nu 'sɔlɛ‑ Zesu 'kunle‑ ta gɔnɛ‑ 'la gbɛɛn‑, ‑e ‑yaa 'bhɛɛ‑ klɛ bhla ‑lrele' 'ɛ ‑glin 'zi. ");
INSERT INTO moa_vpl VALUES ("MK14_12","071_14_12","MRK","14","12","12","'Bluu 'la waa ‑yaa 'bhɛ ‑pɛɛ 'ɛ wlɛn 'ke 'sɛkɛ 'le, 'bhɛ 'bhle 'fɛti yi ‑lwa 'ɛ 'le, Zuufu mu 'ɛ 'yaa‑ ‑bhlaa gwlɛn bhlonɛ‑ mu ‑la dɛ, 'bhɛɛ‑ ‑woo klɛ 'ke 'sraka 'le ‑o gole 'ɛ luya 'yi 'bhɛ ‑zayi'. 'Bhɛ 'yi 'tɛ, Zesu a ‑klaŋlanɛ mu 'ɛ ‑wa ‑lrɔkpaa dɔɔ: «'Yoo‑ ‑a zi 'bhii‑ ‑kɔɔ' ge ‑kɔɔa' Paki 'fɛti 'ɛ ta kpo 'ɛ klɛ 'naa ma ɛɛ?» ");
INSERT INTO moa_vpl VALUES ("MK14_13","071_14_13","MRK","14","13","13","'Bhɛɛ‑ Zesu ‑yaa' ‑klaŋlanɛ plɛ winbwa‑, 'ke ‑ya pele‑ 'mu ni: «‑Ka ge ‑wa 'la bhe ‑a ta, 'ka 'lɛ nu 'palɛ‑ 'ke mɛɛ do 'le, ‑yi gbɔ do ‑o ‑a wiiŋ‑, ‑ka dɔ ‑a zi. ");
INSERT INTO moa_vpl VALUES ("MK14_14","071_14_14","MRK","14","14","14","'Kee‑ ‑ja wlalɛ 'fɛ 'la ꞊la, ‑ka wla ‑a zi 'bhɛ ꞊nɔɔ, 'bhɛɛ‑ ‑ka 'bhɛ 'fɛzan‑ 'ɛ lrɔkpa' dɔɔ: ‹'O Daan mi 'ɛ pe 'o nu 'e 'lrɔkpa dɔɔ 'yee‑ 'pegee ‑yaa' ‑klaŋlanɛ mu 'ɛ nu ‑waa' Paki 'fɛti 'ɛ ta pɛ 'ɛ 'bhlelɛ‑ 'fɛkpee 'la ꞊la 'bhɛ ‑o naa ‑a ma ɛɛ?› ");
INSERT INTO moa_vpl VALUES ("MK14_15","071_14_15","MRK","14","15","15","'Ke 'bhɛ ꞊kla, 'fɛzan‑ 'ɛ nu ‑yaa' 'saŋgaso 'kpee gblaan 'ɛ do zrɔnlɛ 'ka ni. 'Bhɛ magaanle ‑o 'elrele gban, 'bhɛ 'pegee mɛɛ mazadɔ pɛ yɛkɛ‑ 'la ma 'bhɛ ‑o 'bhɛ ꞊la. 'Ka nu ‑kɔɔa' pɛ Paki 'fɛti 'ɛ ta kpo 'ɛ klɛlɛ ‑kɔɔ' ni 'bhɛɛ‑ ꞊nɔɔ. ");
INSERT INTO moa_vpl VALUES ("MK14_16","071_14_16","MRK","14","16","16","‑Yaa' ‑klaŋlanɛ plɛ 'ɛ ‑o gele 'tɛ, 'ke ‑o wlale‑ ‑wa 'ɛ ta. ‑O ꞊bhwa pɛ mu 'ɛ 'kpɛn 'lɛsɔle ta 'bhii‑ Zesu 'a ꞊pia ‑o ni gɔnɛ‑ 'la gbɛɛn‑. 'Bhɛɛ‑ ‑o ‑waa pɛ 'fɛti ta kpo 'ɛ ꞊kla 'bhɛɛ‑ ꞊nɔɔ.» ");
INSERT INTO moa_vpl VALUES ("MK14_17","071_14_17","MRK","14","17","17","'Bhɛ blaan, Zesu a ‑klaŋlanɛ plɛ 'ɛ 'niinaa ‑o ‑zanta'. Yromazi bhɔle 'tɛ, 'ke 'yee‑ Zesu 'pegee ‑yaa' ‑klaŋlanɛ vu ta plɛ 'ɛ ‑o 'nule wlalɛ ‑wa 'ɛ 'kpee. ");
INSERT INTO moa_vpl VALUES ("MK14_18","071_14_18","MRK","14","18","18","‑O ‑yaa pɛle 'zi bhla 'la ba, 'ke Zesu 'a 'pele ‑o ni 'kaa: «'Mi pe 'ka ni 'ŋ 'sɔwɛɛ‑ 'gbu 'ɛ ma dɔɔ 'ka mu 'la 'ka 'pegee 'mi ‑o pɛbhle 'zi 'eke‑ zi ‑gɛ bhe, 'ka do nu ‑dawli' 'kpalɛ‑ 'ŋ gbɛ ta, 'bhɛɛ‑ ‑yoo 'ŋ 'lɛna mɛɛ mu ni.» ");
INSERT INTO moa_vpl VALUES ("MK14_19","071_14_19","MRK","14","19","19","‑Yaa' ‑klaŋlanɛ mu 'ɛ ‑woo wlɛyisriwoa, 'bhɛɛ‑ 'ke ‑wa ‑lrɔkpale 'sanle do do 'kaa: «'Mi ‑le 'kɛle‑ ɛɛ?» ");
INSERT INTO moa_vpl VALUES ("MK14_20","071_14_20","MRK","14","20","20","Zesu pe ‑o ni 'tɛ dɔɔ: «'Ka mɛɛ vu ta plɛ 'ɛ ba, 'ke mɛɛ 'la zan 'bhɛ gbɛ ꞊wlaa 'ŋ gbɛ ta pɛle ‑koo do 'kpɔ 'ɛ 'yi, 'bhɛ klɛ 'bhɛ zan 'bhɛ ‑le 'kɛle‑. ");
INSERT INTO moa_vpl VALUES ("MK14_21","071_14_21","MRK","14","21","21","Wlan 'ɛ ni, Bhaaplɛŋ Gbe 'ɛ ‑yoo zan galɛ 'bhii‑ ‑a yɔɔndɛle ‑o ‑a ba zayi' gɔnɛ‑ 'la gbɛɛn‑ ‑Waanbhaa' a 'Sɛwɛ 'ɛ 'yi. 'Duŋ‑ mɛɛ 'la zan nu ‑a ‑lɛnalɛ mɛɛ mu 'ɛ ni, 'bhɛɛ‑ ‑wa dɛ, 'bhɛ zan ta ‑yrɛn! 'Ali‑ 'ke waa ‑yaa 'bhɛ zan 'ɛ ya ‑titi, 'bhɛ mabhaa ‑yaa bhɔ 'bhɛ zan 'ɛ ma.» ");
INSERT INTO moa_vpl VALUES ("MK14_22","071_14_22","MRK","14","22","22","‑O ‑yaa pɛ 'ɛ 'bhle zii' bhla 'la ba, Zesu 'bluu 'ɛ 'sile‑, 'kee‑ ‑Waanbhaa' 'pubɔle ‑a ma, 'bhɛɛ‑ 'ke ‑ya takanle kplokplo. 'Bhɛ blaan, 'ke ‑ya nale‑ ‑yaa' ‑klaŋlanɛ mu 'ɛ ni, 'bhɛɛ‑ ‑e pe ‑o ni dɔɔ: «‑Kaa 'kun, 'ŋ 'flɛ 'ɛ 'yele‑ ‑gɛ.» ");
INSERT INTO moa_vpl VALUES ("MK14_23","071_14_23","MRK","14","23","23","'Bhɛ blaan, 'kee‑ ‑drɔɔ pɛyan‑ do 'sile, 'bhɛɛ‑ 'kee‑ ‑Waanbhaa' 'pubɔle 'bhɛ ma, 'kee‑ 'bhɛ 'kpale ‑o 'kɔɔ 'kaa ‑o 'kpɛn 'a 'ke 'mi do do. ");
INSERT INTO moa_vpl VALUES ("MK14_24","071_14_24","MRK","14","24","24","'Bhɛ klɛle 'tɛ, 'ke Zesu 'a 'pele ‑o ni dɔɔ: «'Ŋ yiɛn 'ɛ 'yele‑ ‑gɛ, ‑bhoolaya drɛɛ 'la ‑yoo ‑Waanbhaa' 'pegee bhaaplɛŋ mu pleŋ‑, yiɛn 'lɛɛ‑ 'bhɛ ‑le 'bhɛ ‑tɔɔmasie 'ɛ 'le, ‑e ‑klalaa', 'kooko‑ ‑e mɛɛ ‑bebe 'pegee ‑Waanbhaa' kpa do ma. ");
INSERT INTO moa_vpl VALUES ("MK14_25","071_14_25","MRK","14","25","25","'Mi pe 'ka ni wlan 'ɛ ni dɔɔ 'naa nu ‑drɔɔ 'bhɛɛke 'milɛ‑ 'ezin‑ 'sani‑ 'ŋ nu ‑drɔɔ drɛɛ 'la 'milɛ‑ ‑Waanbhaa' a ‑bhleŋgbeya ‑wa 'ɛ ta 'bhɛ 'waati 'ɛ 'bhɔle‑ pleŋ‑.» ");
INSERT INTO moa_vpl VALUES ("MK14_26","071_14_26","MRK","14","26","26","'O yanle ‑Waanbhaa' 'tɔbhɔ ma 'sro mu 'ɛ 'kpalele, 'ke ‑o 'pwɛle 'fɛ 'ɛ ꞊la, 'bhɛɛ‑ 'ke ‑o gele‑ Olivi diiŋ vlɛ gɔɔn 'ɛ 'wiiŋ‑. ");
INSERT INTO moa_vpl VALUES ("MK14_27","071_14_27","MRK","14","27","27","Zesu pe ‑yaa' ‑klaŋlanɛ mu 'ɛ ni dɔɔ: «'Ka 'kpɛn nu 'ŋ 'tolɛ‑ a ꞊nɔɔ, ‑amasrɔyi ‑a yɔɔndɛle ‑o ‑Waanbhaa' a 'Sɛwɛ 'ɛ 'yi 'kaa: ‹'Ŋ nu ‑bhlaa mu gooba mi 'ɛ dɛlɛ, 'bhɛɛ‑ ‑bhlaa mu 'ɛ nu 'kanlɛ‑ 'eke‑ ma jafata.›» ");
INSERT INTO moa_vpl VALUES ("MK14_28","071_14_28","MRK","14","28","28","Zesu pe ‑o ni 'ezin‑ 'kaa: «'Duŋ‑ 'ke 'ŋ ‑bwela gale ba 'waati 'la ba, 'ŋ nu 'kanlɛ‑ 'ka 'lɛɛ ‑sɔ Galile.» ");
INSERT INTO moa_vpl VALUES ("MK14_29","071_14_29","MRK","14","29","29","'Bhɛ ꞊nɔɔ bhe, 'ke Piɛri 'a 'pele 'a ni dɔɔ: «'Ali‑ 'ke mɛɛ ‑vin mu 'ɛ 'kpɛn blasaan‑, 'bhɛɛ‑ 'ke ‑woo 'e ꞊twa ‑a nɔɔ‑, 'mi 'naa nu 'e 'tolɛ‑ a ꞊nɔɔ ‑titi.» ");
INSERT INTO moa_vpl VALUES ("MK14_30","071_14_30","MRK","14","30","30","'Bhɛ klɛle 'tɛ, 'ke Zesu 'a zikpale ‑a ni dɔɔ: «'Mi pe 'e ni wlan 'ɛ ni dɔɔ: ‑zɔn ‑bi 'gbu 'lɛɛ zi, 'sani maagwlɛn ‑wegbɛ' plɛ mi 'ɛ 'pleŋ‑, 'e nu 'e 'lɛmadɔlɛ 'eglɔɔle 'mi ma ‑glɔɔn yaga 'kaa 'yaa mi dɔ.» ");
INSERT INTO moa_vpl VALUES ("MK14_31","071_14_31","MRK","14","31","31","'Bhɛɛ‑ 'duŋ‑, Piɛri 'bhɛ zikpaa‑ ‑a ni faŋgan‑ ma 'ezin‑ dɔɔ: «'Ali‑ 'kee‑ ꞊kla 'o 'pegee 'bhi dɛle 'le 'eke‑ 'yi, 'naa nu 'ŋ ‑baŋgolɛ 'e 'yi ‑titi.» ‑Klaŋlanɛ ‑vin mu 'ɛ 'kpɛn ‑dwa 'bhɛɛ‑ ‑jan yɛkɛ‑ do 'kpɔ 'ɛ ta. ");
INSERT INTO moa_vpl VALUES ("MK14_32","071_14_32","MRK","14","32","32","'Bhɛ blaan, Zesu 'pegee ‑yaa' ‑klaŋlanɛ mu 'ɛ ‑o ‑ja yrɛ do nɔɔ‑, ‑o ‑yaa 'bhɛ yrɛ 'ɛ sii Zɛtisemane. ‑O bhɔle 'bhɛ ꞊nɔɔ bhe 'tɛ, 'ke Zesu 'a 'pele ‑yaa' ‑klaŋlanɛ mu 'ɛ ni 'kaa: «‑Ka yala‑ ‑gɛ, 'ŋ gele‑ 'ŋ 'seriwolɛ laale.» ");
INSERT INTO moa_vpl VALUES ("MK14_33","071_14_33","MRK","14","33","33","‑A ge bhla 'ɛ zi, ‑e Piɛri 'pegee Zaki 'bhɛɛ‑ Zaan 'siila‑, 'bhɛɛ‑ 'mu ‑dwa ‑a zi. ‑Gblaan 'klale ‑saan ‑a ‑yi, 'bhɛɛ‑ ‑a blina‑ yiɛn ‑yaa. ");
INSERT INTO moa_vpl VALUES ("MK14_34","071_14_34","MRK","14","34","34","‑E pe ‑o ni dɔɔ: «'Ŋ 'blina‑ yiɛn ‑o 'klekle 'ke 'bhɛ ge 'tɛnlɛ‑ 'ŋ gale ma. ‑Ka bo 'ka 'yrɛ ma yrɛnɛ‑ 'lɛɛ‑ ꞊nɔɔ ‑gɛ!» ");
INSERT INTO moa_vpl VALUES ("MK14_35","071_14_35","MRK","14","35","35","‑Ya pleŋgole sa ‑o ma, 'kee‑ 'klaale ‑a 'kpɔ ta 'trɛ ma, 'bhɛɛ‑ 'ke ‑ya 'seriwole ‑Waanbhaa' ni 'kaa: «'Kee sɔ a klɛle‑, ‑yrɛnbhle' 'waati 'yɔɔ‑ 'lɛɛ 'kan 'ŋ ma 'egbɔɔnle.» ");
INSERT INTO moa_vpl VALUES ("MK14_36","071_14_36","MRK","14","36","36","‑E ‑yaa pe 'zi dɔɔ: «'Ŋ Dɛ, 'ŋ Dɛ, ‑za 'kpɛn klɛ 'seŋ ‑o 'e ni. ‑Yrɛn pɛyan‑ do 'la bhe ‑a pleŋgo 'ŋ ma. 'Duŋ‑ 'yaa 'mi zru maza klɛlɛ, 'e 'gbu ‑la zru maza klɛ.» ");
INSERT INTO moa_vpl VALUES ("MK14_37","071_14_37","MRK","14","37","37","'Bhɛ blaan, 'kee‑ nule‑ 'pwɛlɛ‑ ‑yaa' ‑klaŋlanɛ yaga 'ɛ ta, 'bhɛɛ‑ 'kee‑ bhɔle‑ 'mu ta yi pla. 'Bhɛ 'yi 'tɛ, 'kee‑ Piɛri bwele‑, 'bhɛɛ‑ 'ke ‑ya pele‑ 'bhɛ ni dɔɔ: «Simɔ, 'e yidɛ zii' ɛɛ? 'Yaa 'sɔlɛ‑ bole‑ 'e 'yrɛ ma 'ali‑ 'waati sanɛ‑ ba ɛɛ? ");
INSERT INTO moa_vpl VALUES ("MK14_38","071_14_38","MRK","14","38","38","‑Ka bo 'ka 'yrɛ ma, 'ke 'ka 'ka 'seriwo Waanbhaa' ni, 'kooko‑ ‑Setran' 'laa 'ka 'yidan‑, 'bhɛɛ‑ ‑e 'ka bɔ ‑za 'yɔɔ‑ 'yi. Bhaaplɛŋ zru ‑o ‑a zi 'bhii‑ ‑e ‑za 'wlan klɛ, 'duŋ‑ 'bhɛ yɛkɛ‑ faŋgan‑ 'laa ‑o 'ɛ ta.» ");
INSERT INTO moa_vpl VALUES ("MK14_39","071_14_39","MRK","14","39","39","‑Ya pleŋgo gbɛ drɛɛwoa‑ ‑o ma 'ezin‑, 'bhɛɛ‑ 'kee‑ bɔle‑ 'yee‑ ‑jan do 'kpɔ 'ɛ 'pele‑ ta ‑Waanbhaa' ni. ");
INSERT INTO moa_vpl VALUES ("MK14_40","071_14_40","MRK","14","40","40","‑E niina‑ gbɛ drɛɛwole 'ezin‑ ‑yaa' ‑klaŋlanɛ mu 'ɛ ta, 'kee‑ bhɔle‑ 'mu yidɛle ta; ‑amasrɔyi, yi 'ɛ gbinkpa' gbɛ ‑yɔɔ' 'ɛ 'kɔɔ ‑o ‑yrɛ ta, ‑jan 'la ‑o 'bhɛ pe Zesu ni, waa ‑yaa 'bhɛ dɔ. 'Bhɛɛ‑ ‑e ‑ja 'ezin‑ ‑a ‑zanta'. ");
INSERT INTO moa_vpl VALUES ("MK14_41","071_14_41","MRK","14","41","41","‑A nu gbɛ yaga mi 'ɛ ma ‑o ta, 'ke ‑ya pele‑ ‑o ni dɔɔ: «'Ka ‑o yidɛ 'zi ɛɛ, 'bhɛɛ‑ 'ka ‑o 'ka 'yitrɛ zii' ‑li ɛɛ? 'Bhɛ ꞊swa 'bhɛ 'yi, 'waati 'ɛ ꞊bhwa. ‑Ka 'ka 'yrɛkpa! ‑O nu ‑dawli' 'kpalɛ‑ Bhaaplɛŋ Gbe 'ɛ gbɛ ta, 'bhɛɛ‑ ‑wa 'lɛna ‑za 'yɔɔ‑ klɛ mu 'ɛ ni, 'bhɛ 'waati 'ɛ ꞊bhwa. ");
INSERT INTO moa_vpl VALUES ("MK14_42","071_14_42","MRK","14","42","42","‑Ka 'ka 'wlɛn‑, ‑kɔɔ' ge! ‑Ka 'ka 'yrɛkpa doo, mɛɛ 'la zan nu ‑dawli' 'kpalɛ‑ 'ŋ gbɛ ta, 'bhɛɛ‑ ‑yoo 'ŋ 'lɛna‑ mɛɛ mu ni, yaa ‑o ‑li ‑kɔɔ' ma 'egbɔɔnle.» ");
INSERT INTO moa_vpl VALUES ("MK14_43","071_14_43","MRK","14","43","43","Zesu 'yaa‑ 'bhɛ ‑jan 'ɛ 'wo zii' bhla 'la ba, 'ke Zuda 'pwɛle ‑a ‑yi. Zesu a klaŋlanɛ vu ta plɛ 'ɛ do ‑le ‑yaa 'kɛle‑. ‑Zamaa' 'srɛ ‑gbɛnɛ do ‑yaa ‑a zi, ‑gɔkuŋ' 'pegee 'beni mu 'le 'mu 'kɔɔ. 'Sraka 'lɛna ‑kuŋlii mu 'ɛ 'pegee 'Toŋ daan mu 'ɛ, 'bhɛɛ‑ ‑waa' 'gwlaan‑ gblaan mu 'ɛ 'mu ‑le ‑o winbwa‑ Zesu 'kunyrɛ‑ ꞊nɔɔ. ");
INSERT INTO moa_vpl VALUES ("MK14_44","071_14_44","MRK","14","44","44","'Yee‑ Zuda 'la ꞊kla Zesu 'lɛna mi 'le mɛɛ mu 'ɛ ni, ‑e Zesu 'kungbɛya ‑tɔɔmasie do ‑zrɔnna Zesu 'kun mu 'ɛ ni dɔɔ: «'Ke 'ŋ mɛɛ 'la zan ‑tuubwa 'yele‑ 'kɛle‑. ‑Kaa 'kun 'bhɛɛ‑ 'ka ge 'kɛle‑, 'duŋ‑ ‑ka 'ka 'yrɛkpa 'a ba 'elrele!» ");
INSERT INTO moa_vpl VALUES ("MK14_45","071_14_45","MRK","14","45","45","Zuda nule 'tɛ, 'ke ‑ya mabɛɛnle ‑gun Zesu ‑din, 'bhɛɛ‑ 'ke ‑ya pele‑ 'bhɛ ni dɔɔ: «'O Daan mi!» 'Bhɛ klɛle 'tɛ, 'kee‑ Zesu ‑tuubɔle. ");
INSERT INTO moa_vpl VALUES ("MK14_46","071_14_46","MRK","14","46","46","'Bhɛ klɛle 'tɛ, 'ke mɛɛ mu 'ɛ ‑o Zesu 'kunle. ");
INSERT INTO moa_vpl VALUES ("MK14_47","071_14_47","MRK","14","47","47","'Duŋ‑ ‑yaa' ‑klaŋlanɛ do 'bhɛ a ‑gɔkuŋ' 'ɛ 'pwɛle‑ 'bhɛ 'bhoo‑ 'ɛ 'yi, 'kee‑ 'sraka 'lɛna ‑kuŋlii gblaan 'ɛ 'bhɛ a 'fa ‑la yewonɛ mu 'ɛ do 'trɔnlaa do takanle. ");
INSERT INTO moa_vpl VALUES ("MK14_48","071_14_48","MRK","14","48","48","'Bhɛ klɛle 'tɛ, 'ke Zesu 'a 'pele ‑o ni 'kaa: «'Ka ꞊nwa 'ŋ 'kunyrɛ‑ ꞊nɔɔ ‑gɔkuŋ' 'pegee 'beni mu 'le 'ka 'kɔɔ, 'ŋ 'yoo‑ 'ke mɛɛ dɛ mi do ‑la ‑le ɛɛ? ");
INSERT INTO moa_vpl VALUES ("MK14_49","071_14_49","MRK","14","49","49","Yi 'oo yi, ‑kɔɔ 'yaa 'eke‑ 'yi, 'bhɛɛ‑ 'ŋ 'yaa‑ mɛɛ mu daan *‑Waanbhaa' Gba 'Fɛ ‑Gbɛnɛ 'ɛ ꞊la, ‑mɛle ꞊kla 'bhɛɛ‑ 'ka 'laa 'ŋ 'kunlɛ‑ 'bhɛ yrɛ 'ɛ꞊nɔɔ ɛɛ? 'Duŋ‑ ‑za 'lɛɛ‑ 'kpɛn ꞊kla, 'kooko‑ ‑Waanbhaa' ‑lɛla' janwo mu 'ɛ ‑o ‑jan mu 'la ꞊woa 'mi ba zayi' ‑Waanbhaa' a 'Sɛwɛ 'ɛ 'yi 'mu 'lɛsɔ‑.» ");
INSERT INTO moa_vpl VALUES ("MK14_50","071_14_50","MRK","14","50","50","'Bhɛ klɛle 'tɛ, 'ke ‑klaŋlanɛ mu 'ɛ 'kpɛn 'kanle 'eke‑ ma 'gbasaa gbasaa, 'ke ‑o Zesu do ‑kplɛn 'tole 'a ꞊nɔɔ. ");
INSERT INTO moa_vpl VALUES ("MK14_51","071_14_51","MRK","14","51","51","‑Zwannɛ do dɔle ‑yaa Zesu zi. Sɔ drɔŋ ‑la 'kanle‑ ‑yaa ‑a gbɛ ta. Mɛɛ mu 'ɛ ‑o 'bhɛ ꞊kwan 'ezin‑. ");
INSERT INTO moa_vpl VALUES ("MK14_52","071_14_52","MRK","14","52","52","'Duŋ‑ 'bhɛ 'ploole 'bhɛ ta sɔ 'ɛ ma ‑o 'kɔɔ‑, 'bhɛɛ‑ 'ke 'bhɛ blasanle 'bhɛ tafleŋ‑ 'ɛ 'le. ");
INSERT INTO moa_vpl VALUES ("MK14_53","071_14_53","MRK","14","53","53","‑O ‑ja 'ke Zesu 'le *'Sraka 'lɛna mu a ‑kuŋlii gblaan 'ɛ ba 'fɛ 'lɛ ma. 'Sraka 'lɛna mu ‑kuŋlii' mu 'ɛ 'pegee Zuufu mu 'ɛ ‑waa' 'gwlaan‑ gblaan mu 'ɛ, 'bhɛɛ‑ *'Toŋ Daan mu 'ɛ, ‑o 'kpɛn ‑ja ‑o 'lɛkpalɛ 'eke‑ ta 'bhɛ ꞊nɔɔ ye. ");
INSERT INTO moa_vpl VALUES ("MK14_54","071_14_54","MRK","14","54","54","Mɛɛ mu 'ɛ ‑yaa ge 'zi Zesu 'le bhla 'la ba 'sraka 'lɛna mu a ‑kuŋlii ‑gblaan' 'ɛ ba, Piɛri ‑yaa zan ‑o ‑zanta' 'egbɔɔnle. 'Bhɛɛ‑ 'kee‑ nule‑ wlalɛ 'yee‑ 'sraka 'lɛna mu a ‑kuŋlii gblaan 'bhɛ ‑a 'fɛ ‑gbeŋ 'ɛ 'yi. 'Bhɛ ꞊nɔɔ bhe, 'kee‑ gele‑ yaalɛ 'fɛ gooba mu 'ɛ ‑din ‑a magayrɛ nɔɔ‑ 'tɛ 'ɛ ‑din. ");
INSERT INTO moa_vpl VALUES ("MK14_55","071_14_55","MRK","14","55","55","'Sraka 'lɛna ‑kuŋlii mu 'ɛ 'pegee Zuufu mu a 'kitikan mɛɛ gblaan ‑lɛdo' 'ɛ ‑o 'kpɛn 'yaa‑ ‑jan 'bhɛɛke‑ do ‑glin 'zi Zesu 'kaama‑, 'kooko‑ 'bhɛ klɛ ‑a dɛ win 'le. 'Duŋ‑ waa ‑jan 'lɛdɔɔle 'kedo‑ 'male mɛɛ 'kedo‑ 'kpɔ 'lii Zesu ma. ");
INSERT INTO moa_vpl VALUES ("MK14_56","071_14_56","MRK","14","56","56","‑Amasrɔyi mɛɛ ‑bebe ‑yaa bhla 'kpa zii' Zesu ma, 'duŋ‑ ‑o 'kpɛn 'liijan‑ mu 'ɛ waa ‑yaa do. ");
INSERT INTO moa_vpl VALUES ("MK14_57","071_14_57","MRK","14","57","57","'Bhɛ klɛle‑ 'tɛ, 'ke ‑zamaa' 'ɛ 'pleŋ‑ mɛɛ 'ke mu ‑o ‑wlɛnle', 'bhɛɛ‑ 'ke ‑o bhla 'lɛɛ‑ 'bhɛɛ‑ 'kpale Zesu ma 'kaa: ");
INSERT INTO moa_vpl VALUES ("MK14_58","071_14_58","MRK","14","58","58","«'O mɔɔ 'gbu 'a ꞊maa ‑a ‑lii dɔɔ bhaaplɛŋ mu 'gbu ‑Waanbhaa' Gba 'Fɛ ‑Gbɛnɛ 'la ‑dwa 'mu gbɛ 'le, 'yee‑ 'gbu nu 'bhɛ 'wilɛ‑, 'bhɛɛ‑ ‑ya dɔ gbɛ drɛɛwo ‑yrekpaa' yaga ‑la; 'bhɛ 'laa nu klɛlɛ bhaaplɛŋ woye 'le.» ");
INSERT INTO moa_vpl VALUES ("MK14_59","071_14_59","MRK","14","59","59","'Ali‑ 'bhɛ ‑jan 'la bhe, 'bhɛ gole ‑yaa ‑jan ‑vin mu 'ɛ ma. ");
INSERT INTO moa_vpl VALUES ("MK14_60","071_14_60","MRK","14","60","60","'Bhɛ 'waati 'ɛ ba 'tɛ, 'ke *'sraka 'lɛna mu a ‑kuŋlii gblaan 'ɛ ‑ya ‑wlɛnle', 'kee‑ dulale ‑zamaa' 'ɛ 'pleŋ‑, 'bhɛɛ‑ 'kee‑ Zesu ‑lrɔkpale 'tɛ dɔɔ: «Mɛɛ mu 'ɛ ‑jan mu 'la 'kpɛn 'wo zii' 'e ma, 'bhi pe 'mu 'yi 'nale‑ ɛɛ?» ");
INSERT INTO moa_vpl VALUES ("MK14_61","071_14_61","MRK","14","61","61","'Duŋ‑ Zesu tagale ꞊bwa. 'Ezin‑ 'ke 'sraka 'lɛna mu a ‑kuŋlii gblaan 'ɛ ‑ya ‑lrɔkpa' gbɛ drɛɛwole dɔɔ: «'Bhi ‑le 'ke Mɛɛ ‑Bhee mi ‑kpɔsɔɔ Krisi 'ɛ 'le ɛɛ, 'bhɛ 'pegee 'o ‑Waanbhaa' 'la 'tɔbhɔ 'bhi ‑le 'bhɛ Gbe 'le ɛɛ?» ");
INSERT INTO moa_vpl VALUES ("MK14_62","071_14_62","MRK","14","62","62","'Bhɛ 'yi 'tɛ, 'ke Zesu 'a zikpale ‑a ni dɔɔ: «‑Aani', 'mi 'gbu ‑le 'bhɛ 'le. 'Bhɛɛ‑ 'duŋ‑, 'ka 'kpɛn 'yrɛ nu 'kpalɛ‑ Bhaaplɛŋ Gbe 'ɛ 'yaale‑ ma 'Seŋkpɛnzan ‑Waanbhaa' ‑din 'tɔbhɔ ma yaayrɛ 'ɛ ꞊nɔɔ. 'Bhɛɛ‑ 'ka nu ‑a yelɛ 'ezin‑ 'ke ‑yoo zan laflɛ' ‑gblɛn mu 'ɛ 'yi.» ");
INSERT INTO moa_vpl VALUES ("MK14_63","071_14_63","MRK","14","63","63","'Bhɛ ‑jan 'ɛ 'la gbɛ ‑yɔɔ' 'kɔɔ 'sraka 'lɛna mu a ‑kuŋlii gblaan 'ɛ ma, 'ke ‑ya 'gbu ta dunɛ‑ mu 'ɛ 'peedɛle, 'bhɛɛ‑ 'ke ‑ya pele‑ 'kaa: «‑Kɔɔ' maza ‑o ‑li mɛɛ ‑bhɛɛke' a 'srɛya‑ klɛle ma ɛɛ? ");
INSERT INTO moa_vpl VALUES ("MK14_64","071_14_64","MRK","14","64","64","‑E ‑Waanbhaa' 'tɔsiɛ ma jan 'la ꞊woa bhe, 'ka 'bhɛ ꞊maa ɛɛ, 'ka mu pe 'bhɛ 'yi 'nale‑ ɛɛ?» ‑O 'kpɛn ‑bɛŋgwa do ma 'ke ‑wa pele‑ 'kaa: «‑Yoo 'ke dɛpɛ 'le.» ");
INSERT INTO moa_vpl VALUES ("MK14_65","071_14_65","MRK","14","65","65","'Bhɛ yrɛ do 'ɛ ꞊nɔɔ bhe, 'ke mɛɛ 'ke mu ‑o ‑liile' 'klale‑ 'sanle Zesu ta, 'bhɛɛ‑ 'ke ‑o sɔgbɛ do ‑yrele' ‑a wlɛyi', 'ke ‑wa zɔn ‑sɔ ‑o gbɛkpuŋ‑ mu 'ɛ 'le, 'bhɛɛ‑ 'ke ‑wa ‑lrɔkpa' dɔɔ: «Mɛɛ 'la zan 'e ꞊zwan, 'bhɛ zan 'ɛ 'tɔkan 'o ni doo!» 'Bhɛɛ‑ 'fɛ gooba mu 'ɛ 'mu 'yaa‑ ‑a 'trɔnzɔn‑ 'zi 'ezin‑. ");
INSERT INTO moa_vpl VALUES ("MK14_66","071_14_66","MRK","14","66","66","Piɛri ‑yaa bhla 'la ba *'sraka 'lɛna mu a ‑kuŋlii gblaan 'ɛ ‑yaa' 'fɛ ‑gbeŋ 'ɛ 'yi 'trɛ ma, 'ke 'bhɛ a 'fɛ 'ɛ ꞊la yewo le 'ɛ do nule‑. ");
INSERT INTO moa_vpl VALUES ("MK14_67","071_14_67","MRK","14","67","67","'Bhɛ yewo le 'ɛ 'yee‑ Piɛri 'yele‑, 'ke ‑ya maga 'zi 'tɛ 'ɛ ma, 'ke 'bhɛ 'e 'yrɛkpale ‑a ta frii, 'bhɛɛ‑ 'ke 'bhɛ 'a 'pele ‑a ni: «'Bhi 'gbu 'ezin‑, 'e 'yaa‑ 'yee‑ Nazarɛti mi Zesu 'ɛ zi.» ");
INSERT INTO moa_vpl VALUES ("MK14_68","071_14_68","MRK","14","68","68","'Duŋ‑ Piɛri 'e 'lɛmadwa 'eglɔɔle 'ke ‑ya pele‑ dɔɔ: «Le ‑nɛ, 'e drɔɔn' ‑o ‑jan 'la 'wo zii' bhe, 'naa 'bhɛ dɔ, 'bhɛɛ‑ 'naa ‑o ‑a ‑yima' zii'.» 'Bhɛ blaan, 'kee‑ 'pwɛle, 'bhɛɛ‑ 'kee‑ gele‑ ‑gbeŋ 'ɛ 'lɛ ma. 'Bhɛɛ‑ 'ke maagwlɛn ‑wele' 'tɛ. ");
INSERT INTO moa_vpl VALUES ("MK14_69","071_14_69","MRK","14","69","69","'Yee‑ yewo le ‑nɛ do 'ɛ ‑e Piɛri 'yele‑ 'ezin‑, 'ke ‑ya pele‑ 'bhɛ ꞊nɔɔ mɛɛ mu 'ɛ 'yrɛ ma dɔɔ: «'Gwlaan‑ 'lɛɛ‑ ‑yoo 'woo‑ mɛɛ mu 'ɛ do 'le!» ");
INSERT INTO moa_vpl VALUES ("MK14_70","071_14_70","MRK","14","70","70","'Duŋ‑, 'ke Piɛri 'e 'lɛmadɔle 'eglɔɔle 'bhɛ ‑jan 'ɛ ma 'ezin‑. 'Bhɛ blaan boolazi sa bhɔle, 'ke ‑gbeŋ 'ɛ 'lɛ ma mu 'ɛ ‑wa pele‑ Piɛri ni 'kaa: «Wlan 'ɛ ni, 'bhi 'gbu 'lɛɛ‑ 'yoo‑ 'ke 'woo‑ mɛɛ mu 'ɛ do 'le, ‑amasrɔyi 'yoo‑ 'ezin‑ 'ke Galile 'mi 'le!» ");
INSERT INTO moa_vpl VALUES ("MK14_71","071_14_71","MRK","14","71","71","'Bhɛ 'yi 'tɛ, 'ke Piɛri ‑a 'pele dɔɔ: «Bhaa 'ŋ ga 'ke 'ŋ 'yoo‑ bhla pe 'zi! 'Mi 'pegee 'ŋ 'sɔwɛɛ‑ 'ɛ ta, 'ka ‑o ‑we 'zi mɛɛ 'la 'le, 'naa 'a dɔ ‑titi!» ");
INSERT INTO moa_vpl VALUES ("MK14_72","071_14_72","MRK","14","72","72","'Bhɛ 'waati do 'kpɔ 'ɛ ba 'te, 'ke maagwlɛn 'a 'we gbɛ plɛ mi klɛle‑, 'bhɛɛ‑ Zesu 'yee‑ Piɛri 'kpeelɛkaan ‑jan 'la 'le 'elwale, 'ke 'bhɛ dɔle‑ ‑a 'kpee. Zesu 'a ꞊pia ‑a ni 'elwale dɔɔ: «'Sani‑ maagwlɛn nu ‑welɛ' plɛ ‑zɔn, 'e nu 'e 'lɛmadɔlɛ 'eglɔɔle mi ma gaan yaga.» 'Bhɛɛ‑ 'yee‑ Piɛri wisile ‑saan. ");
INSERT INTO moa_vpl VALUES ("MK15_1","071_15_1","MRK","15","1","1","Zrwan 'tutu 'ɛ zi, Zuufu mu a 'kitikan mɛɛ gblaan ‑lɛdo' 'ɛ ‑o 'kpɛn ꞊klaa 'eke‑ ba: ‑o 'ke mu ‑yaa 'sraka 'lɛna ‑kuŋlii mu 'le, 'bhɛɛ‑ ‑a 'ke mu ‑yaa' Zuufu mu a 'gwlaan‑ gblaan mu 'le, 'bhɛɛ‑ ‑a 'ke mu ‑yaa 'Toŋ daan mu 'le. ‑Woo 'eke‑ ꞊ya 'yee‑ Zesu ba zayi'. ‑O yanle Zesu gbɛtabɔlele, 'ke ‑o gele‑ ‑a ‑lɛnalɛ Romɛ mu a ‑janmatii Pilati ni. ");
INSERT INTO moa_vpl VALUES ("MK15_2","071_15_2","MRK","15","2","2","‑O bhɔle Pilati ba, 'ke 'bhɛ Zesu 'lrɔkpale 'kaa: «'Bhi ‑le 'ke Zuufu mu 'ɛ waa ‑bhleŋgbe 'ɛ 'le ɛɛ?» Zesu 'a 'lɛkwan‑ ‑a ni 'kaa: «'E 'gbu 'yela‑ ꞊pia bhe.» ");
INSERT INTO moa_vpl VALUES ("MK15_3","071_15_3","MRK","15","3","3","'Duŋ‑ 'sraka 'lɛna ‑kuŋlii mu 'ɛ bhla ‑bebe ꞊kpaa Zesu ma 'bhɛ yrɛ 'ɛ ꞊nɔɔ ye. ");
INSERT INTO moa_vpl VALUES ("MK15_4","071_15_4","MRK","15","4","4","'Bhɛ klɛle 'tɛ, 'ke Pilati 'a 'lrɔkpale 'ezin‑ 'kaa: «‑Woo ‑jan ‑bebe 'la 'kpɛn 'wo zii' 'e ma bhe, 'e 'trɔn 'laa ‑o 'mu 'yi ɛɛ? 'Bhɛɛ‑ 'bhi 'laa ‑o ‑jan 'ke 'wole 'mu 'yi ɛɛ?» ");
INSERT INTO moa_vpl VALUES ("MK15_5","071_15_5","MRK","15","5","5","'Bhɛɛ‑ 'duŋ‑, Zesu 'laa ‑jan 'kedo‑ 'kpɔ 'lɛkunlɛ. 'Bhɛ tagagbɛya ‑glɔɔn 'ɛ 'bhɛ 'yee‑ Pilati 'kpeelɛnia ‑a ma. ");
INSERT INTO moa_vpl VALUES ("MK15_6","071_15_6","MRK","15","6","6","Lɛɛ 'oo lɛɛ, Zuufu mu a Paki 'fɛti 'ɛ ta, Pilati ‑yaa ploo ‑kaso 'yi mi do ma. 'Ke ‑zamaa' 'yaa‑ ‑kaso 'yi mi 'la 'yrɛwo‑ ‑a ma, ‑e ‑yaa ploo 'bhɛɛ‑ ma ‑o ni. ");
INSERT INTO moa_vpl VALUES ("MK15_7","071_15_7","MRK","15","7","7","'Bhɛ klɛgbɛya do 'ɛ 'yi, ‑o ‑yaa ‑kaso 'yi mi do sii Barabasi. ‑O 'bhɛ 'pegee 'bhɛ ‑vin ‑kala' mɛɛ 'ke mu ꞊bwa ‑kaso 'yi, ‑amasrɔyi ‑o ‑wlɛnna Romɛ mu 'ɛ ma, 'bhɛɛ‑ ‑o mɛɛ do ꞊dia. ");
INSERT INTO moa_vpl VALUES ("MK15_8","071_15_8","MRK","15","8","8","‑Zamaa' 'ɛ ‑ja Pilati ba ‑lɛ ma, 'ke ‑o ‑sromabɔle 'sanle ‑a ni dɔɔ ‑e 'ploo‑ ‑kaso 'yi mi do ma ‑o ni 'bhii‑ ‑e ‑yaa dɔ ‑a klɛle ‑la ‑o ni gɔnɛ‑ 'la gbɛɛn‑ lɛɛ 'oo lɛɛ. ");
INSERT INTO moa_vpl VALUES ("MK15_9","071_15_9","MRK","15","9","9","'Bhɛ 'yi 'tɛ, Pilati ‑o ‑lrɔkpaa dɔɔ: «'Kaa‑ zi 'bhii‑ 'ŋ 'ploo‑ Zuufu mu a ‑bhleŋgbe 'ɛ ma 'ka ni ɛɛ?» ");
INSERT INTO moa_vpl VALUES ("MK15_10","071_15_10","MRK","15","10","10","'Yee‑ Pilati 'gbu 'yaa‑ 'yaango‑ 'bhii‑ 'sraka 'lɛna ‑kuŋlii mu 'ɛ ‑o Zesu 'lɛnaa‑ ‑a ni, ‑amasrɔyi ‑o ‑yaa zranwo 'zi ‑a ba. ");
INSERT INTO moa_vpl VALUES ("MK15_11","071_15_11","MRK","15","11","11","'Duŋ‑ 'sraka 'lɛna ‑kuŋlii mu 'ɛ ‑wa ꞊wlaa ‑zamaa' 'ɛ zi dɔɔ ‑o ‑sromabɔ Pilati ni 'kaa 'bhɛ 'ploo‑ Barabasi ‑la ma ‑o ni, 'bhɛɛ‑ 'bhɛ 'laa 'ploolɛ‑ Zesu ma. ");
INSERT INTO moa_vpl VALUES ("MK15_12","071_15_12","MRK","15","12","12","Pilati ‑zamaa' 'ɛ 'lrɔkpa gbɛ drɛɛwoa‑ 'ezin‑ dɔɔ: «'Kaa‑ zi 'bhii‑ 'ŋ ‑mɛ za ‑la klɛ 'ka mɛɛ 'la zan sii ‹Zuufu mu a ‑bhleŋgbe› 'bhɛ ni ɛɛ?» ");
INSERT INTO moa_vpl VALUES ("MK15_13","071_15_13","MRK","15","13","13","‑O ‑pɛɛnna 'eke‑ zi dɔɔ: «‑A gbaan ‑yrigbɛɛle do ta, 'bhɛɛ‑ ‑e ga!» ");
INSERT INTO moa_vpl VALUES ("MK15_14","071_15_14","MRK","15","14","14","Pilati pe ‑o ni 'kaa: «‑E ‑za 'yɔɔ‑ ‑glɔɔn 'ɛ ‑dela ꞊kla ɛɛ?» 'Duŋ‑ ‑o ‑pɛɛnna 'eglɔɔle 'ezin‑ dɔɔ: «‑A gbaan ‑yrigbɛɛle do ta, 'bhɛɛ‑ ‑e ga!» ");
INSERT INTO moa_vpl VALUES ("MK15_15","071_15_15","MRK","15","15","15","'Bhɛ ꞊nɔɔ bhe 'tɛ, Pilati ‑yaa zi 'bhii‑ ‑e ‑zamaa' 'ɛ zru maza klɛ, ‑ayile, 'kee‑ 'ploole Barabasi ma ‑o ni 'tɛ. 'Bhɛɛ‑ ‑ya ꞊kla 'bhɛɛ‑ ‑o Zesu zita ꞊zwan 'ke gbaŋbhlɛ 'le, 'bhɛɛ‑ ‑e 'bhɛ ꞊kpaa ‑srwase' mu 'kɔɔ 'kaa ‑o ge ‑a gbaan ‑yrigbɛɛle do ta. ");
INSERT INTO moa_vpl VALUES ("MK15_16","071_15_16","MRK","15","16","16","'Bhɛ klɛle 'tɛ, 'ke ‑srwase' mu 'ɛ gele Zesu 'le ‑janmatii 'ɛ ‑yaa ‑gbeŋ ‑gbɛnɛ 'ɛ 'yi, 'bhɛɛ‑ 'ke ‑woo ‑vin ‑srwase' mu 'ɛ 'kpɛn 'siile. ");
INSERT INTO moa_vpl VALUES ("MK15_17","071_15_17","MRK","15","17","17","'Bhɛ ꞊nɔɔ bhe, 'ke ‑o dunɛ‑ gbɔɔn 'tɛn ‑klɛɛn' ‑klɛɛn' do 'klale ‑a ta, 'bhɛɛ‑ 'ke ‑o lɛrɛ zuŋgbhlɛ do 'tanle, 'bhɛɛ‑ 'ke ‑o 'bhɛ 'kpale ‑a wiiŋ‑ 'bhii ‑bhleŋgbe ŋgblo ma 'faa do. ");
INSERT INTO moa_vpl VALUES ("MK15_18","071_15_18","MRK","15","18","18","'Bhɛ blaan, 'ke ‑wa 'pubɔle 'sanle 'kaa: «'E 'yia‑, Zuufu mu a ‑bhleŋgbe!» ");
INSERT INTO moa_vpl VALUES ("MK15_19","071_15_19","MRK","15","19","19","'Bhɛɛ‑ ‑o ‑yaa zɔn 'zi ‑a wiiŋ‑ togɔ do 'le, 'ke ‑woo ‑liile' kla a ta, 'bhɛɛ‑ 'ke ‑woo 'kpɔ zɛn ‑a ‑lɛɛ 'bhii‑ ‑o ‑gasikpa zii' ‑a ma. ");
INSERT INTO moa_vpl VALUES ("MK15_20","071_15_20","MRK","15","20","20","‑O ‑yaan ‑a malrɔgolele bhla 'la ba, 'ke ‑o dunɛ‑ gbɔɔn 'tɛn ‑klɛɛn' ‑klɛɛn' 'ɛ gole ‑a ta, 'bhɛɛ‑ 'ke ‑wa 'gbu a dunɛ‑ mu 'ɛ 'klale ‑a ta. 'Bhɛ blaan, 'ke ‑o gele‑ 'kɛle‑ 'pɛɛlii‑ ‑a gbaan zayi' ‑yrigbɛɛle do ta. ");
INSERT INTO moa_vpl VALUES ("MK15_21","071_15_21","MRK","15","21","21","‑O ‑yaa ge 'zi Zesu gbaanlɛ ‑yrigbɛɛle 'ɛ ta bhla 'la ba, 'ke ‑o ‑lɛpale 'gwlaan‑ do 'le 'ke 'bhɛ ‑o da 'zi gba la. Sirɛni mi do ‑le ‑yaa 'bhɛ 'le, 'bhɛɛ‑ ‑o ‑yaa 'bhɛ sii Simɔ. Alɛzandri 'pegee Rufusi dɛ ‑le ‑yaa 'bhɛ 'le. 'Bhɛ 'kanle‑ ‑bɛŋlawoa ‑o 'kan zi 'ɛ 'lii, 'ke ‑srwase' mu 'ɛ ‑wa pele‑ 'bhɛ ni dɔɔ 'bhɛ Zesu gbaan ‑yrigbɛɛle 'kwe 'ɛ 'si kpaŋma. ");
INSERT INTO moa_vpl VALUES ("MK15_22","071_15_22","MRK","15","22","22","'Bhɛɛ‑ 'ke ‑o gele‑ Zesu 'le yrɛ do ꞊nɔɔ, ‑o ‑yaa 'bhɛ yrɛ 'ɛ sii Gɔligota, 'bhɛ 'yile‑ dɔɔ ‹mɛɛ ŋgblo bhɛlɛ' yrɛ.› ");
INSERT INTO moa_vpl VALUES ("MK15_23","071_15_23","MRK","15","23","23","‑O bhɔle 'bhɛ yrɛ 'ɛ ꞊nɔɔ 'tɛ, ‑o ‑yaa ‑laanɛ' 'la sii miri, ‑o 'bhɛ 'yizaala ‑drɔɔ 'tɔnle‑ ba, 'bhɛɛ‑ ‑o 'bhɛ 'nale‑ ‑yidaan Zesu ni, 'bhɛɛ‑ ‑ya ‑baŋgwa 'bhɛ 'mile‑ ma. ");
INSERT INTO moa_vpl VALUES ("MK15_24","071_15_24","MRK","15","24","24","‑O Zesu ‑gbaanna ‑yrigbɛɛle 'ɛ ta. 'Bhɛɛ‑ 'ke ‑o 'tete dɔle‑ ‑yaa' dunɛ‑ mu 'ɛ ta, 'kooko‑ ‑o 'kpɛn do do dɔ ‑o 'kɛla 'le ‑o 'bhɛ dɔ. ");
INSERT INTO moa_vpl VALUES ("MK15_25","071_15_25","MRK","15","25","25","‑O ‑yaan ‑a gbaanlele zrwanzi ‑yretɛbhɛ gwlɛn ‑wlɛn 'waati 'ɛ ba (nɛvɛɛ 'waati 'ɛ ba). ");
INSERT INTO moa_vpl VALUES ("MK15_26","071_15_26","MRK","15","26","26","‑O Zesu ꞊dia win 'la ma ‑yrigbɛɛle 'ɛ ta, ‑o 'bhɛ yɔɔndia‑ ‑yripeenɛ do ta, 'bhɛɛ‑ ‑o 'bhɛ ‑gbaanna ‑a ŋgblo 'ɛ trala ‑yri 'ɛ ta; 'bhɛɛ‑ 'bhɛ 'sɛwɛwole ‑yaa 'tɛ ‑gee' 'kaa: ");
INSERT INTO moa_vpl VALUES ("MK15_27","071_15_27","MRK","15","27","27","‑O mɛɛ dɛ mi plɛ ‑gbaanna ‑yrigbɛɛle ‑bhɛɛke' ta ‑a gbɛ plɛ 'ɛ ta: ‑A do ‑yaa ‑a gbɛ ‑yiɛ' 'yi, 'bhɛɛ‑ 'bhɛ ‑vindo' mi 'ɛ 'yaa‑ ‑a gbɛ ‑koo ta. ");
INSERT INTO moa_vpl VALUES ("MK15_28","071_15_28","MRK","15","28","28","'Bhɛ klɛgbɛya 'ɛ 'yi, ‑jan 'la yɔɔndɛle ‑yaa ‑Waanbhaa' a 'Sɛwɛ 'ɛ 'yi, 'bhɛ ‑jan 'ɛ 'lɛswa꞊, 'bhɛ ‑jan 'ɛ 'yaa‑ dɔɔ: «‑O 'yee‑ ‑kpaa ‑za 'yɔɔ‑ klɛ mu ba.» ");
INSERT INTO moa_vpl VALUES ("MK15_29","071_15_29","MRK","15","29","29","'Bhɛ blaan, mɛɛ 'la zan mu 'yaa‑ 'kan zii' 'bhɛ yrɛ 'ɛ ꞊nɔɔ, 'bhɛ mu ‑yaa Zesu ‑zwanwo' zii' 'ke ‑woo ŋgblo 'ɛ bɔ ‑sɔ 'kaa: «‑Ɔɔn 'ɔɔn‑! 'Bhi 'laa 'pelɛ‑ 'kaa 'e sɔ ‑Waanbhaa' Gba 'Fɛ ‑Gbɛnɛ 'ɛ 'wile, 'bhɛɛ‑ 'ya dɔ gbɛ drɛɛwo ‑yrekpaa' yaga ‑la ɛɛ? ");
INSERT INTO moa_vpl VALUES ("MK15_30","071_15_30","MRK","15","30","30","'E 'gbu 'si 'ɛ go 'ɛ ‑za 'yi, 'ke 'yee 'gbu go ‑yrigbɛɛle 'ɛ ta doo!» ");
INSERT INTO moa_vpl VALUES ("MK15_31","071_15_31","MRK","15","31","31","'Bhɛ klɛgbɛya do 'ɛ 'yi, 'sraka 'lɛna ‑kuŋlii mu 'ɛ 'pegee 'Toŋ daan mu 'ɛ 'yaa‑ Zesu malrɔgo 'zi 'ke ‑wa pe 'eke‑ ni ‑sɔ 'kaa: «‑E mɛɛ ‑bhɛɛke' mu ‑gwa ‑za 'yi, 'duŋ‑ yaa sɔ ‑a 'gbu gole‑ ‑za yi! ");
INSERT INTO moa_vpl VALUES ("MK15_32","071_15_32","MRK","15","32","32","Mɛɛ ‑Bhee Mi ‑kpɔsɔɔ Krisi, Izraɛli mu a ‑bhleŋgbe, zina‑ ‑zɔn ‑yrigbɛɛle 'ɛ ta! 'Ke 'o 'bhɛ ꞊ya, 'o nu 'o 'kpalɛ‑ ‑a ‑yi 'tɛ.» 'Bhɛɛ‑ 'ezin‑, mɛɛ plɛ 'la gbaanle ‑yaa' ‑a gbɛ ‑yrɛ plɛ 'ɛ ta, 'mu 'yaa‑ ‑a ‑zwanwo' zii'. ");
INSERT INTO moa_vpl VALUES ("MK15_33","071_15_33","MRK","15","33","33","'Kee‑ san ‑yrekpaa' ma, 'kee‑ ge 'tɛnlɛ‑ yromazi ‑yretɛbhɛ yanyan 'ɛ 'le (trwazɛɛ 'waati 'ɛ ba), ‑gblo ꞊kpaa 'trɛ 'ɛ 'kpɛn ta. ");
INSERT INTO moa_vpl VALUES ("MK15_34","071_15_34","MRK","15","34","34","'Bhɛɛ‑ yromazi ‑yretɛbhɛ yanyan 'ɛ 'bhɔle‑ 'te, 'ke Zesu ‑gbekanle 'eglɔɔle 'ke ‑ya pe dɔɔ: «Eloi, Eloi, lama sabatani!» 'Bhɛ 'yile‑ 'kaa: «'An ‑Waanbhaa', 'an ‑Waanbhaa', ‑mɛle ꞊kla 'ye 'ŋ do ‑kplɛnnɛ' ꞊twa ꞊nɔɔ ɛɛ?» ");
INSERT INTO moa_vpl VALUES ("MK15_35","071_15_35","MRK","15","35","35","Mɛɛ 'la zan mu dulale ‑yaa 'bhɛ yrɛ 'ɛ ꞊nɔɔ 'bhɛ 'waati 'ɛ ba, 'mu 'a ‑gbekanwli 'ɛ 'male‑, 'ke 'mu 'a 'pele dɔɔ: «‑Ka 'ka 'trɔnbadɔ doo, ‑yoo Eli 'sii zii' 'kaa 'bhɛ 'nu 'bhɔ 'a ba!» ");
INSERT INTO moa_vpl VALUES ("MK15_36","071_15_36","MRK","15","36","36","'Bhɛ klɛle 'tɛ, 'ke ‑o do blasanle, 'kee‑ ‑gblaŋluu' ‑fɔlu' ‑fɔlu' do 'sile, 'bhɛ 'yaa‑ 'bhii‑ ‑nɛ 'yiɛntɛnnɛ mu 'fɛ ‑gblaŋluu' do gbɛɛn‑. ‑E 'bhɛ ꞊wlaa ‑drɔɔ 'tɔnle‑ do ba, 'kee‑ 'bhɛ 'yrele togɔ do yin 'lii, 'bhɛɛ‑ 'kee‑ 'bhɛ dɔle‑ Zesu ta 'kaa 'bhɛ 'bhɛ mi, 'ke ‑ya pele‑ 'kaa: «'Kɔɔ‑ dula‑ doo, ‑dɔke' ‑kɔɔ' nu Eli 'yelɛ‑ 'ke 'bhɛ ‑o ‑a zina‑ 'zi ‑yrigbɛɛle 'ɛ ta oo!» ");
INSERT INTO moa_vpl VALUES ("MK15_37","071_15_37","MRK","15","37","37","'Duŋ‑ Zesu ‑gbekaan 'eglɔɔle, 'bhɛɛ‑ 'ke ‑a nii‑ 'ɛ gole‑ ‑a ‑yi. ");
INSERT INTO moa_vpl VALUES ("MK15_38","071_15_38","MRK","15","38","38","'Bhɛ 'waati do 'ɛ ba, sɔgbɛ ‑gbɛnɛ 'la 'yaa‑ ‑Waanbhaa' Gba 'Fɛ ‑Gbɛnɛ 'kpee 'ɛ 'yiciɛn‑ plɛ, 'ke 'bhɛ 'peedɛle plɛ 'kee‑ san laanima 'bhɛɛ‑ 'kee‑ nu 'tɛnlɛ‑ 'traa. ");
INSERT INTO moa_vpl VALUES ("MK15_39","071_15_39","MRK","15","39","39","Romɛ mu a ‑srwase' mu ‑kuŋlii 'la 'lɛklale ‑yaa Zesu ba ‑yrɛ ta, 'bhɛ 'a gagbɛya 'ɛ 'yele‑, 'ke 'bhɛ 'a 'pele 'kaa: «Wlan 'gbu 'ɛ ni, 'yee‑ mɛɛ 'lɛɛ‑ 'yaa‑ 'ke ‑Waanbhaa' Gbe 'gbu 'ɛ 'le kpataakpa!» ");
INSERT INTO moa_vpl VALUES ("MK15_40","071_15_40","MRK","15","40","40","Le mu 'ke mu dulale ‑yaa 'ezin‑ 'egbɔɔnle, 'ke ‑o Zesu taglin‑. Mari 'la 'yaa‑ da Magidala ‑wa 'ɛ ta, 'bhɛ 'pegee Mari 'la 'yaa‑ Zaki 'fiɛntrɔnnɛ mi 'pegee Zose nɛɛ 'le, 'bhɛɛ‑ Salome, 'mu ‑yaa 'woo‑ le mu 'ɛ ba. ");
INSERT INTO moa_vpl VALUES ("MK15_41","071_15_41","MRK","15","41","41","'Woo‑ le mu 'la bhe, 'wola‑ dɔle ‑yaa Zesu zi, ‑e ‑yaa 'waati 'la ba Galile 'klɛɛn 'ɛ 'yi 'ke ‑o bhɔ ‑a ba. 'Ezin‑ le 'srɛ 'bhɛɛke mu ‑yaa 'yee‑ 'yrɛ 'ɛ ꞊nɔɔ ye, 'mu 'yaa‑ mɛɛ 'la zan mu 'la ꞊nwa ‑a zi Zeruzalɛmu ‑wa 'ɛ ta, 'mu 'ke 'le. ");
INSERT INTO moa_vpl VALUES ("MK15_42","071_15_42","MRK","15","42","42","Yromazi ꞊bhwa gban. 'Bhɛ yi 'ɛ 'yaa‑ Zuufu mu a ‑yitrɛ' yi 'ɛ 'lɛmagaan yi 'le. ");
INSERT INTO moa_vpl VALUES ("MK15_43","071_15_43","MRK","15","43","43","‑Ayile, yromazi ‑fitrii' 'kpa bhla 'ɛ ba, 'ke Arimate mi Zozɛfu 'nule. Mɔkpɛn' 'yaa‑ ‑gasikpa 'yee‑ Zozɛfu 'ɛ 'lɛɛ, 'bhɛɛ‑ ‑e ‑yaa 'ezin‑ Zuufu mu a 'kitikan mɛɛ gblaan mu ‑lɛdo' 'ɛ ba. 'Yee‑ 'gbu 'yri 'yaa‑ Waanbhaa' a ‑bhleŋgbeya 'ɛ 'bhɛ bhla 'ɛ ta. 'Bhɛla‑ ‑yile, ‑ya zru dɔle‑ 'eglɔɔle, 'kee‑ gele‑ Zesu gbaa 'ɛ 'yrɛwolɛ Pilati ma, 'kaa ‑e gele‑ 'bhɛ binlɛ. ");
INSERT INTO moa_vpl VALUES ("MK15_44","071_15_44","MRK","15","44","44","Zesu galawoa ‑gun blaale‑, 'bhɛ 'yee‑ Pilati 'kpeelɛnia ‑a ma. 'Bhɛ 'yi 'tɛ, 'kee‑ mɛɛ winbɔle ‑srwase' mu ‑kuŋlii 'ɛ 'siiyrɛ‑ ꞊nɔɔ. 'Bhɛ 'nule‑, 'kee‑ 'bhɛ ‑lrɔkpale dɔɔ: «Zesu gale 'ɛ ꞊nɔɔ ꞊mwa gban ɛɛ?» ");
INSERT INTO moa_vpl VALUES ("MK15_45","071_15_45","MRK","15","45","45","'Bhɛ klɛle 'tɛ, 'ke ‑srwase' ‑kuŋlii 'ɛ ‑ya ‑lɛkunle 'a ni dɔɔ ‑a gale 'ɛ ꞊nɔɔ ꞊mwa gban. 'Bhɛ 'yi 'tɛ, 'ke ‑ya pele‑ Arimate mi Zozɛfu ni 'kaa 'bhɛ ge Zesu gbaa 'ɛ 'si. ");
INSERT INTO moa_vpl VALUES ("MK15_46","071_15_46","MRK","15","46","46","'Yee‑ Zozɛfu 'gbu sɔ 'pu do ꞊lwa. ‑E yanle Zesu gbaa 'ɛ golele ‑yrigbɛɛle 'ɛ ta, 'kee‑ 'bhɛ sɔ 'ɛ 'kpale Zesu gbaa 'ɛ ma. 'Bhɛɛ‑ ‑e bu ‑gluu 'la 'kwleela‑ 'elwale gban ‑sɔ vlɛ 'ɛ 'yi, 'kee‑ gele‑ Zesu gbaa 'ɛ 'kpaalɛ‑ 'bhɛ 'yi. ‑E yanle ‑a 'kpaalele 'bhɛ 'yi, 'kee‑ vlɛ ‑kpuŋ ‑gbɛnɛ do ‑bhlile', 'bhɛɛ‑ 'kee‑ bu 'ɛ 'liitanle 'bhɛ 'le. ");
INSERT INTO moa_vpl VALUES ("MK15_47","071_15_47","MRK","15","47","47","'Bhɛ bhla 'ɛ ba, Mari 'la 'yaa‑ da Magidala ‑wa la, 'bhɛ 'pegee Zose nɛɛ Mari, 'mu 'yaa‑ Zesu gbaa 'kpayrɛ‑ 'ɛ ‑glin 'zi. ");
INSERT INTO moa_vpl VALUES ("MK16_1","071_16_1","MRK","16","1","1","‑Yitrɛ' yi 'ɛ 'kanle‑ blaan, Mari 'la 'yaa‑ da Magidala ‑wa 'ɛ ta, 'bhɛ 'pegee Zaki 'pegee Salome nɛɛ Mari, ‑o gbaa ma 'sro ‑yrɔn ‑gblɛn 'nrale‑ 'ke mu ꞊lwa, 'kooko‑ ‑o ge Zesu gbaa 'ɛ masrolɛ 'mu 'le. ");
INSERT INTO moa_vpl VALUES ("MK16_2","071_16_2","MRK","16","2","2","'Kaŋgɔplɛ 'ɛ ma zrwan 'tutu 'ɛ zi, ‑yretɛbhɛ ‑wlɛn bhla 'ɛ ba, 'ke ‑o gele‑ bu 'ɛ taglinyrɛ꞊nɔɔ. ");
INSERT INTO moa_vpl VALUES ("MK16_3","071_16_3","MRK","16","3","3","‑O ge bhla 'ɛ zi, ‑o ‑yaa pe 'zi 'eke‑ ni dɔɔ: «‑Dele nu vlɛ ‑kpuŋ 'ɛ 'bhlilɛ‑ ‑kɔɔ' ni, 'bhɛɛ‑ ‑ya go bu ‑gluu 'ɛ 'lii ɛɛ?» ");
INSERT INTO moa_vpl VALUES ("MK16_4","071_16_4","MRK","16","4","4","‑O bhɔle Zesu bu 'ɛ ‑din, ‑wa taglinle, 'ke ‑o vlɛ ‑kpuŋ ‑gbɛnɛ 'ɛ 'bhlile‑ yele‑ ‑a 'lii 'ɛ ‑gɔma'. ");
INSERT INTO moa_vpl VALUES ("MK16_5","071_16_5","MRK","16","5","5","'Bhɛ klɛle 'tɛ, 'ke ‑o gele‑ wlalɛ bu ‑gluu 'ɛ zi, 'ke ‑o ‑zwannɛ do yaale yele‑ ‑o gbɛ ‑yiɛ' ta, dunɛ‑ 'pu 'peŋpeŋ gbɔɔn do ‑yaa 'bhɛ ta, 'bhɛɛ‑ 'ke ‑o 'klale ‑o 'gbu ta ‑gblaan ‑gbɛnɛ 'ɛ 'kɔɔ. ");
INSERT INTO moa_vpl VALUES ("MK16_6","071_16_6","MRK","16","6","6","'Duŋ‑ 'bhɛ pe ‑o ni dɔɔ: «'Ka 'laa ‑gblaanlɛ, ‑o Nazarɛti mi Zesu 'la ‑gbaanna ‑yrigbɛɛle 'ɛ ta, 'ka ‑o 'bhɛɛ‑ ‑glin zii' ɛɛ? ‑E ‑bwela gale ba, yaa ‑o ‑li ‑gɛ, ‑ka 'ka 'yrɛkpa ‑a gbaa 'kpaayrɛ‑ 'ɛ ꞊nɔɔ ‑gɛ doo. ");
INSERT INTO moa_vpl VALUES ("MK16_7","071_16_7","MRK","16","7","7","'Duŋ‑, 'ka mu ge a pe ‑yaa' ‑klaŋlanɛ mu 'ɛ 'pegee Piɛri ni 'kaa ‑e 'kan zii' 'ka 'lɛɛ ‑sɔ Galile. 'Ka nu a yelɛ 'bhɛɛ‑ ꞊nɔɔ 'bhii‑ ‑a 'gbu 'a ꞊pia 'ka ni gɔnɛ‑ 'la ‑gbɛɛn bhe.» ");
INSERT INTO moa_vpl VALUES ("MK16_8","071_16_8","MRK","16","8","8","'Woo‑ le mu 'ɛ 'pwele‑ 'tɛ bu ‑gluu 'ɛ zi, 'ke ‑o blasanle, ‑amasrɔyi ‑gblaan ‑gbɛnɛ 'ɛ 'kɔɔ srɛn ꞊wlaa ‑o ‑yi, 'bhɛɛ‑ ‑o ‑yaa bɛɛn 'zi. 'Duŋ‑ waa 'bhɛ 'pele mɛɛ 'kedo‑ 'kpɔ ni ‑gblaan 'ɛ 'kɔɔ. ");
INSERT INTO moa_vpl VALUES ("MK16_9","071_16_9","MRK","16","9","9","Zesu bwele blaan gale ba, 'kaŋgɔplɛ 'ɛ ma zrwan 'tutu 'ɛ zi, ‑e ‑pwɛla 'elwale 'pe Mari 'la 'yaa‑ da Magidala ‑wa 'ɛ ta 'bhɛɛ‑ ba. 'Yee‑ Zesu lii 'yɔɔ‑ 'srwaplɛ‑ ‑gwa 'bhɛɛ‑ zi 'elwale ‑sɔ. ");
INSERT INTO moa_vpl VALUES ("MK16_10","071_16_10","MRK","16","10","10","'Bhɛ le 'ɛ ‑ja 'bhɛ ‑jan 'ɛ 'yigɔɔnlɛ mɛɛ 'la zan mu ‑yaa Zesu zi 'mu ni; ‑e ꞊bhwa 'mu ta 'ke mu ta ‑o suŋ, 'bhɛɛ‑ 'mu 'yaa‑ wisi' zii'. ");
INSERT INTO moa_vpl VALUES ("MK16_11","071_16_11","MRK","16","11","11","'Duŋ‑ ‑wa malawoa 'kaa Zesu ‑bwela gale, 'bhɛɛ‑ ‑ya ‑yrɛ ma, 'bhɛ 'pegee 'yee‑ Mari 'gbu 'a ꞊ya kpataakpa, waa ‑o 'kpalɛ‑ ‑a ‑yi. ");
INSERT INTO moa_vpl VALUES ("MK16_12","071_16_12","MRK","16","12","12","'Bhɛ blaanta, Zesu 'pwɛla‑ ‑yaa' ‑klaŋlanɛ plɛ ba 'pwɛgbɛya ‑glɔɔn 'bhɛɛke do 'yi 'mu ge bhla 'ɛ zi ‑bɔn 'yi ‑wa do ta. ");
INSERT INTO moa_vpl VALUES ("MK16_13","071_16_13","MRK","16","13","13","'Bhɛ mɛɛ plɛ 'ɛ ꞊nwa 'bhɛ ‑jan 'ɛ 'yigɔɔnlɛ 'ezin‑ ‑klaŋlanɛ ‑vin mu 'ɛ ni, 'duŋ‑ waa ‑o 'kpalɛ‑ 'mu 'wojan‑ 'ɛ 'yi 'ezin‑ ‑titi. ");
INSERT INTO moa_vpl VALUES ("MK16_14","071_16_14","MRK","16","14","14","'Bhɛ blaan 'tɛ, 'ke Zesu 'pwɛle‑ ‑yaa' ‑klaŋlanɛ vu ta do 'ɛ ba, ‑waa' pɛbhle bhla 'ɛ zi. 'Bhɛɛ‑ 'kee‑ ‑lale' ‑o ta ‑waa' 'kpalekleya 'ɛ 'pegee ‑o zru dɔgbɛya ‑glɔɔ 'ɛ ma. ‑Amasrɔyi, mɛɛ 'la zan mu 'a 'yrɛmale 'ɛ ꞊ya ‑a bwele blaan gale ba, waa ‑o 'kpalɛ‑ 'mu 'wojan‑ 'ɛ 'yi. ");
INSERT INTO moa_vpl VALUES ("MK16_15","071_16_15","MRK","16","15","15","'Bhɛ 'kpɛn blaan 'tɛ, 'ke ‑ya pele‑ ‑o ni dɔɔ: «‑Ka ge 'drunyan 'ɛ 'yi yrɛkpɛn‑ ꞊nɔɔ, 'ke 'ka ge ‑Jan 'Nrale‑ 'ɛ 'wolele mɛɛ mu 'ɛ 'kpɛn ni. ");
INSERT INTO moa_vpl VALUES ("MK16_16","071_16_16","MRK","16","16","16","'Ke mɛɛ 'la zan 'e ꞊kpaa ‑a ‑yi, 'bhɛɛ‑ 'ke 'bhɛ zan ‑dwa ‑a ‑la 'ke ‑wa wiiŋfɛ ‑yi ba, 'bhɛ zan nu golɛ ‑za 'yi. 'Duŋ‑ 'ke mɛɛ 'la zan 'laa 'e 'kpalɛ‑ ‑a ‑yi, ‑Waanbhaa' a ‑kpan 'ɛ nu baalɛ 'bhɛ zan ta. ");
INSERT INTO moa_vpl VALUES ("MK16_17","071_16_17","MRK","16","17","17","'Mi nu 'sɔle‑ maza mu 'la klɛlɛ mɛɛ 'la zan mu nu ‑o 'kpalɛ‑ ‑Jan 'Nrale‑ 'ɛ 'yi 'mu gbɛ zi 'mu ‑le ‑gɛ: 'Mi 'gbu 'tɔ 'ɛ 'yi, ‑o nu 'zina mu ‑gbinlɛ' mɛɛ mu zi, 'bhɛɛ‑ ‑o nu wli drɛɛ mu 'pele. ");
INSERT INTO moa_vpl VALUES ("MK16_18","071_16_18","MRK","16","18","18","'Ke ‑o mlɛ mu ꞊kwan ‑o 'kɔɔ, 'bhɛɛ‑ 'ke ‑o mɛɛ dɛ ‑yi 'ke ꞊mia, ‑za 'yɔɔ‑ 'kedo‑ 'kpɔ 'laa nu klɛlɛ ‑o ni. ‑O nu ‑o gbɛ mu 'kpaalɛ‑ gadɛ mu ta 'bhɛɛ‑ 'mu nu ‑bheelɛ'.» ");
INSERT INTO moa_vpl VALUES ("MK16_19","071_16_19","MRK","16","19","19","Mɛɛzan Zesu 'yanle‑ 'bhɛ ‑jan mu 'ɛ 'wolele ‑o ni, 'ke ‑Waanbhaa' ‑a faŋgan‑ 'ɛ 'bhɛ 'a 'sile laanima, 'kee‑ gele‑ laflɛ' 'ɛ 'yi, 'bhɛɛ‑ ‑e ‑ja yaalɛ ‑Waanbhaa' ‑din 'tɔbhɔ ma yaayrɛ 'ɛ ꞊nɔɔ. ");
INSERT INTO moa_vpl VALUES ("MK16_20","071_16_20","MRK","16","20","20","‑Yaa' ‑klaŋlanɛ mu 'ɛ ‑ja 'tɛ ‑Jan 'Nrale‑ 'ɛ 'wolɛ‑ yrɛkpɛn‑ ꞊nɔɔ. Mɛɛzan Zesu 'yaa‑ bhɔ 'zi 'mu ba, 'kee‑ 'sɔle‑ maza mu klɛ ‑sɔ ‑o gbɛ zi. 'Bhɛ klɛgbɛya 'ɛ gbɛɛn‑ bhe, ‑e ‑yaa zrɔn 'bhii‑ ‑yaa' ‑klaŋlanɛ mu 'ɛ 'wojan‑ mu 'ɛ ‑woo 'ke wlan 'le.");
INSERT INTO moa_vpl VALUES ("LK1_1","072_1_1","LUK","1","1","1","'Ŋ 'bhɛgwlɛn‑ gblaan Teofili, mɛɛ ‑bebe 'sɛwɛdɛle 'la ‑saan ‑za mu 'la ꞊kla ‑kɔɔ' ba ‑gɛ bhe, 'mu ta, ");
INSERT INTO moa_vpl VALUES ("LK1_2","072_1_2","LUK","1","2","2","‑o 'bhɛ ‑za mu 'ɛ 'yigɔɔn 'zi 'ke ‑wa san 'yee‑ Zesu a ‑za mu 'ɛ zisaan‑ mɛɛ 'la zan mu 'yrɛ ma, 'bhɛɛ‑ 'ke ‑o ꞊kla ‑Waanbhaa' a ‑Jan 'ɛ 'wo mu 'le bhe 'mu 'wojan‑ mu 'ɛ ma. ");
INSERT INTO moa_vpl VALUES ("LK1_3","072_1_3","LUK","1","3","3","'Bhɛɛ‑ 'duŋ‑, 'mi 'gbu 'woo‑ ‑za mu 'ɛ kplankplan ‑yilrɔkpalawoa mɛɛ mu ma; ‑e ꞊swa 'mi ni 'ezin‑ 'ke 'mi 'woo‑ ‑za mu 'ɛ ‑yigɔɔn' 'e ni 'sɛwɛ ta, 'bhɛɛ‑ 'yoo‑ kpataakpa dɔ, 'bhi 'ŋ 'bhɛgwlɛn‑ gblaan Teofili, 'ke 'an san ‑o zisanyrɛ 'ɛ ma, 'bhɛɛ‑ 'ke ‑o dɔ 'eke‑ zi do do. ");
INSERT INTO moa_vpl VALUES ("LK1_4","072_1_4","LUK","1","4","4","'Ŋ 'bhɛ ꞊kla, 'kooko‑ ‑woo 'e ‑daanna ‑za mu 'la 'le Zesu ba zayi', 'e sɔ ‑o 'kpɛn wlan yrɛ dɔle‑. ");
INSERT INTO moa_vpl VALUES ("LK1_5","072_1_5","LUK","1","5","5","Erɔdi ‑yaa ‑bhleŋgbe 'le Zude 'klɛɛn 'ɛ yi bhla 'la ba, ‑o ‑yaa 'sraka 'lɛna mi do sii Zakari; ‑o ‑yaa 'sraka 'lɛna mu ‑lɛdo' 'la sii Abia ‑e 'yaa‑ 'mu ‑la do 'le. ‑O ‑yaa ‑a na sii Elizabɛti, 'bhɛɛ‑ 'bhɛ 'yaa‑ 'sraka 'lɛna mi ‑kuŋlii gblaan Aarɔn 'srɛ mu 'ɛ do 'le. ");
INSERT INTO moa_vpl VALUES ("LK1_6","072_1_6","LUK","1","6","6","Zakari pegee' ‑a na Elizabɛti, ‑o mɛɛ plɛ ‑lɛdɔɔle ‑yaa ‑Waanbhaa' ‑yrɛ 'yi, 'bhɛɛ‑ ‑o ‑yaa Mɛɛzan a 'toŋ mu 'ɛ 'kpɛn 'pegee ‑yaa' mɛɛ winbɔ jan mu 'ɛ 'kpɛn 'klɔsikun 'ke waa ‑za 'yɔɔ‑ ye ‑o zi. ");
INSERT INTO moa_vpl VALUES ("LK1_7","072_1_7","LUK","1","7","7","'Duŋ‑ ‑nɛ do 'kpɔ 'laa ‑yaa ‑o 'kɔɔ, ‑amasrɔyi Elizabɛti 'laa ‑yaa sɔ ‑nɛ 'yale, 'bhɛɛ‑ ‑o mɛɛ plɛ ‑krɔyawoa gban. ");
INSERT INTO moa_vpl VALUES ("LK1_8","072_1_8","LUK","1","8","8","‑Yrekpaa' do, 'sraka 'lɛna ye 'ɛ ꞊bhwa 'yee‑ Zakari a pɛ mɛɛ ‑lɛdo' 'ɛ ta. 'Bhɛla‑ ‑yile, ‑e ‑yaa ‑yaa' 'sraka 'lɛna ye 'ɛ 'wo zii' ‑Waanbhaa' Gba 'Fɛ ‑Gbɛnɛ 'ɛ ꞊la. ");
INSERT INTO moa_vpl VALUES ("LK1_9","072_1_9","LUK","1","9","9","'Bhɛɛ‑ 'sraka 'lɛna mu 'ɛ ‑waa' 'sinii ta za mu 'ɛ ma, ‑o 'yee‑ Zakari ‑la makwan‑ 'kaa‑ ‑e ge ‑lasiklɔɔ pii 'ɛ 'kpacie 'ke 'sraka 'le ‑Waanbhaa' ni Mɛɛzan Gba 'Fɛ ‑Gbɛnɛ 'ɛ ꞊la. ");
INSERT INTO moa_vpl VALUES ("LK1_10","072_1_10","LUK","1","10","10","'Bhɛ ‑lasiklɔɔ pii 'kpacie bhla 'ɛ ba, ‑zamaa' 'ɛ 'kpɛn ‑dulale ‑yaa 'pɛɛlii‑ 'ke ‑woo 'seriwo. ");
INSERT INTO moa_vpl VALUES ("LK1_11","072_1_11","LUK","1","11","11","'Bhɛ 'waati do 'kpɔ 'ɛ ba, 'ke Mɛɛzan ‑Waanbhaa' a ‑mlɛkɛ' 'ɛ do 'pwɛle 'yee‑ Zakari ba. 'Ke 'bhɛ ‑dulale ansansi 'kpacieyrɛ 'ɛ gbɛ ‑yiɛ' ta. ");
INSERT INTO moa_vpl VALUES ("LK1_12","072_1_12","LUK","1","12","12","Zakari 'a 'yele, 'ke 'bhɛ zrubatɛdɔle, 'bhɛɛ‑ 'ke yiɛnkanle 'bhɛ 'kpee. ");
INSERT INTO moa_vpl VALUES ("LK1_13","072_1_13","LUK","1","13","13","'Duŋ‑, ‑mlɛkɛ' 'ɛ ‑ya ‑pia ‑a ni dɔɔ: «'Yaa ‑gblaanlɛ' Zakari, ‑amasrɔyi ‑Waanbhaa' 'yaa‑ 'seri mu 'ɛ 'lɛkwan‑, ‑ayile 'e 'na Elizabɛti nu ‑a yalɛ 'ke ‑nɛ 'gwlaan‑ do 'le 'e ni; 'bhɛɛ‑ 'e nu 'bhɛ 'tɔkpalɛ Zaan. ");
INSERT INTO moa_vpl VALUES ("LK1_14","072_1_14","LUK","1","14","14","'Bhɛ ‑nɛ 'ɛ nu klɛlɛ 'e zrukpaapɛ ‑gbɛnɛ 'le, 'bhɛɛ‑ ‑a yaza 'ɛ nu mɛɛ ‑bebe zrukpaalɛ. ");
INSERT INTO moa_vpl VALUES ("LK1_15","072_1_15","LUK","1","15","15","Wlan 'ɛ ni, ‑e nu klɛlɛ mɛɛ gblaan do 'le Mɛɛzan ‑Waanbhaa' ‑yrɛ 'yi. Yaa nu ‑drɔɔ 'pegee ‑wɛɛn ‑glɔɔ 'kedo‑ 'kpɔ 'milɛ‑. ‑A nii‑ 'ɛ 'pale nu klɛlɛ 'ke *Lii 'Weŋ 'ɛ 'le 'ke 'bhɛ san ‑a ya bhla 'ɛ ma. ");
INSERT INTO moa_vpl VALUES ("LK1_16","072_1_16","LUK","1","16","16","‑E nu Izraɛli mɛɛ ‑bebe zru niinalɛ Mɛɛzan waa ‑Waanbhaa' 'ɛ ba. ");
INSERT INTO moa_vpl VALUES ("LK1_17","072_1_17","LUK","1","17","17","‑E nu 'taawolɛ ‑Waanbhaa' ‑lɛɛ Lii 'Weŋ ‑glɔɔya' yɛkɛ‑ 'la 'yaa‑ ‑Waanbhaa' *‑lɛla' janwo mi *Eli ta 'bhɛɛ‑ 'le. ‑E nu ‑nɛ dɛ mu 'pegee ‑o ‑nɛ mu zru klɛlɛ do, 'bhɛɛ‑ ‑e nu mɛɛ 'la zan mu ‑Waanbhaa' 'kafawo 'mu zru mu 'ɛ maniinalɛ, 'bhɛɛ 'mu nu klɛlɛ ‑zadɔ' mu 'le 'bhii‑ ‑ mɛɛ ‑lɛdɔɔle mu gbɛɛn‑. 'Bhɛ klɛgbɛya 'ɛ gbɛɛn‑ bhe, 'e nu 'si do magaanlɛ Mɛɛzan ‑Waanbhaa' ni.» ");
INSERT INTO moa_vpl VALUES ("LK1_18","072_1_18","LUK","1","18","18","'Bhɛ klɛle 'tɛ 'ke Zakari 'a 'pele ‑mlɛkɛ' 'ɛ ni dɔɔ: «'Ŋ nu ‑a 'yaangolɛ ‑mɛ pɛ ‑la ma 'bhii‑ 'e 'wojan‑ 'ɛ 'yiza‑ nu klɛlɛ ɛɛ? ‑Amasrɔyi 'mi 'pegee 'ŋ 'na 'ɛ 'o ‑krɔyawoa gban.» ");
INSERT INTO moa_vpl VALUES ("LK1_19","072_1_19","LUK","1","19","19","‑Mlɛkɛ' pe Zakari ni dɔɔ: «'Mi le 'ke Gabriɛli 'le, 'ŋ dulaa' ‑Waanbhaa' ‑lɛɛ 'bhɛɛ‑ 'an gba, 'yele‑ 'ŋ 'winbwa‑ 'kaa 'ŋ nu ‑jan 'nrale‑ 'lɛɛ‑ 'wo 'e ni. ");
INSERT INTO moa_vpl VALUES ("LK1_20","072_1_20","LUK","1","20","20","'Duŋ‑ 'ŋ 'wojan‑ mu 'lɛɛ‑ ‑o ‑yi za nu klɛlɛ kpataakpa 'ke 'bhɛ 'waati 'ɛ ꞊bhwa, 'bhɛɛ‑ 'yaa 'e 'kpalawolɛ 'yee‑ 'ŋ 'wojan‑ mu 'ɛ 'yi bhe, 'e nu klɛlɛ 'bhobho 'le 'ke 'bhɛ ge 'tɛnlɛ‑ ‑o ‑yizaklɛle 'ɛ ma.» ");
INSERT INTO moa_vpl VALUES ("LK1_21","072_1_21","LUK","1","21","21","'Bhɛ 'waati 'ɛ ba, ‑zamaa' 'ɛ ‑yaa Zakari 'magbɛn‑ 'zi 'pɛɛlii‑, ‑o 'kpeelɛnilele, 'bhɛɛ‑ ‑o ‑yaa 'eke‑ ‑lrɔkpa' zii' ‑a ‑mɔza' 'ɛ 'yi ‑Waanbhaa' Gba 'Fɛ ‑Gbɛnɛ 'ɛ ꞊la. ");
INSERT INTO moa_vpl VALUES ("LK1_22","072_1_22","LUK","1","22","22","‑E 'pwɛle‑ ‑Waanbhaa' Gba 'Fɛ ‑Gbɛnɛ 'ɛ꞊la, yaa 'sɔlɛ‑ ‑janwole ‑o ni. 'Bhɛla‑ ‑yile, 'ke ‑wa 'yaangole dɔɔ ‑e pɛ do ꞊ya ‑yrɛ zi yele 'yi 'fɛ 'ɛ ꞊la. ‑E ‑yaa ‑janwo zii' ‑o ni 'ke ‑a gbɛnɛbhɛ mu ‑la ‑le; 'bhɛɛ‑ ‑e ꞊bwa 'bhobho 'le. ");
INSERT INTO moa_vpl VALUES ("LK1_23","072_1_23","LUK","1","23","23","Zakari a yewo yi mu 'ɛ 'yanle‑ *‑Waanbhaa' a Gba 'Fɛ ‑Gbɛnɛ 'ɛ꞊la, 'kee‑ gele‑ ‑a ba ‑lɛ ma. ");
INSERT INTO moa_vpl VALUES ("LK1_24","072_1_24","LUK","1","24","24","'Bhɛ blaan 'waati sa 'kanle‑, 'ke ‑a na Elizabɛti kpɛ 'sile ‑a ma. 'Ke 'bhɛ 'bhɛ magaanle ‑yrala' 'ɛ 'kɔɔ ‑waa 'fɛ 'ɛ ꞊la mlɛ 'soo ta. 'Bhɛ 'yaa‑ pe 'zi dɔɔ: ");
INSERT INTO moa_vpl VALUES ("LK1_25","072_1_25","LUK","1","25","25","«Mɛɛzan ‑Waanbhaa', 'an ‑nɛ 'yaza‑ 'seri 'ɛ 'lɛkwan‑ 'tɛ. 'Bhɛɛ‑ ‑e ‑nɛ 'ya kle ‑yrala' 'ɛ ‑gwa 'ŋ ma mɛɛ mu pleŋ‑.» ");
INSERT INTO moa_vpl VALUES ("LK1_26","072_1_26","LUK","1","26","26","Elizabɛti kpɛ 'ɛ mlɛ 'srwado‑ mi ma, 'ke ‑Waanbhaa' ‑yaa ‑mlɛkɛ' Gabriɛli 'winbɔle Galile 'klɛɛn 'yi ‑wa 'nɛ do ta. ‑O ‑yaa 'bhɛ ‑wa 'ɛ sii Nazarɛti. ");
INSERT INTO moa_vpl VALUES ("LK1_27","072_1_27","LUK","1","27","27","'Bhɛ ‑wa 'ɛ ta ‑gblanɛ do 'tɔ 'yaa‑ Mari. 'Bhɛ 'laa ‑yaa 'gwlaan‑ a ‑za 'yaango‑, 'duŋ‑ 'gwlaan‑ do ‑dwa gban 'bhɛ zi. ‑O ‑yaa 'bhɛ 'gwlaan‑ 'ɛ sii Zozɛfu. 'Bhɛ ‑yaa 'ke ‑Bhleŋgbe *Davidi 'srɛ mu 'ɛ do 'le. ");
INSERT INTO moa_vpl VALUES ("LK1_28","072_1_28","LUK","1","28","28","'Bhɛ ya 'ɛ 'yi, 'ke ‑mlɛkɛ' 'ɛ 'wlale‑ 'yee‑ Mari ta 'fɛ 'ɛ ꞊la, 'ke ‑ya pele‑ ‑a ni dɔɔ: «'E 'yia‑ ɛɛ Mari, ‑Waanbhaa' ‑lia 'e ma! Mɛɛzan ‑ ‑o 'e zi.» ");
INSERT INTO moa_vpl VALUES ("LK1_29","072_1_29","LUK","1","29","29","'Bhɛ klɛle 'tɛ, 'ke Mari zrubatɛdɔle 'papa, 'bhɛɛ‑ 'ke ‑ya pele‑ ‑a 'kpee dɔɔ: «'Bhɛ 'pubɔ‑ 'lɛɛ‑ 'bhɛ 'yi ‑o 'nale‑ ɛɛ?» ");
INSERT INTO moa_vpl VALUES ("LK1_30","072_1_30","LUK","1","30","30","'Bhɛ 'yi 'tɛ, 'ke ‑mlɛkɛ' ‑ya pele‑ ‑a ni 'kaa: «'Yaa ‑gblaanlɛ' Mari, ‑amasrɔyi ‑Waanbhaa' ‑yaa ‑lileya 'ɛ ‑zrɔnna 'e ni. ");
INSERT INTO moa_vpl VALUES ("LK1_31","072_1_31","LUK","1","31","31","'E 'trɔnbadɔ doo: 'E nu kpɛ 'silɛ‑, 'bhɛɛ‑ 'e nu 'e 'yalɛ‑ 'ke ‑nɛ 'gwlaan‑ do 'le. 'E taa' 'a 'tɔkpa‑ Zesu. ");
INSERT INTO moa_vpl VALUES ("LK1_32","072_1_32","LUK","1","32","32","‑E nu klɛlɛ mɛɛ gblaan do 'le, 'bhɛɛ‑ ‑o nu ‑a 'siilɛ‑ laanima ‑Waanbhaa' Gbe. 'Bhɛɛ‑ Mɛɛzan ‑Waanbhaa' nu ‑a ‑taa ‑bhleŋgbe Davidi 'yaakpe‑ 'ɛ 'nalɛ‑ ‑a ni. ");
INSERT INTO moa_vpl VALUES ("LK1_33","072_1_33","LUK","1","33","33","‑E nu klɛlɛ ‑bhleŋgbe 'le Izraɛli mɛɛ mu 'ɛ 'wiiŋ‑ yikpɛnsee ta, 'bhɛɛ‑ ‑daŋ' 'laa nu klɛlɛ ‑yaa' ‑bhleŋgbeya 'ɛ ma.» ");
INSERT INTO moa_vpl VALUES ("LK1_34","072_1_34","LUK","1","34","34","'Bhɛ klɛle 'tɛ, 'ke Mari 'a 'pele 'yee‑ ‑mlɛkɛ' 'ɛ ni dɔɔ: «'Naa 'gwlaan‑ ‑za 'yaango‑, 'bhɛɛ‑ bhɛ sɔ klɛle 'nale ‑a ma ɛɛ?» ");
INSERT INTO moa_vpl VALUES ("LK1_35","072_1_35","LUK","1","35","35","'Bhɛ ꞊nɔɔ bhe, 'ke ‑mlɛkɛ' ‑ya pele‑ ‑a ni dɔɔ: «Lii 'Weŋ 'ɛ nu zinalɛ 'e ta, 'bhɛɛ‑ laanima ‑Waanbhaa' a ‑glɔɔya' 'ɛ nu 'kpalɛ‑ 'e ta 'bhii‑ pɛ do lii gbɛɛn‑. ‑Ayile 'e nu ‑nɛ 'la 'yalɛ‑ bhe, ‑e nu klɛlɛ 'weŋ, 'bhɛɛ‑ ‑o nu ‑a 'siilɛ‑ *‑Waanbhaa' Gbe. ");
INSERT INTO moa_vpl VALUES ("LK1_36","072_1_36","LUK","1","36","36","'E 'trɔnbadɔ doo: 'e ‑zru Elizabɛti, 'bhɛ a le gblaanya 'ɛ 'yi, 'bhɛ 'ezin‑, 'bhɛ kpɛle ‑o 'ke ‑nɛ 'gwlaan‑ do 'le. ‑O ‑yaa 'bhɛ 'la sii ‑nɛ 'ya kle, 'bhɛ kpɛ 'ɛ mlɛ 'srwado‑ ‑le ‑gɛ. ");
INSERT INTO moa_vpl VALUES ("LK1_37","072_1_37","LUK","1","37","37","‑Amasrɔyi ‑za 'kedo‑ 'kpɔ 'laa ‑Waanbhaa' ‑baliwo.» ");
INSERT INTO moa_vpl VALUES ("LK1_38","072_1_38","LUK","1","38","38","'Bhɛ klɛle 'tɛ, 'ke Mari 'a 'pele dɔɔ: «'Ŋ 'yoo‑ 'ke Mɛɛzan ‑Waanbhaa' a yewo le 'le, bhaa 'e 'wojan‑ 'ɛ klɛ 'ke wlan 'le.» 'Bhɛ blaan, 'ke ‑mlɛkɛ' 'ɛ gole‑ ‑a ‑din. ");
INSERT INTO moa_vpl VALUES ("LK1_39","072_1_39","LUK","1","39","39","'Bhɛ 'waati do 'kpɔ 'ɛ ba, 'ke Mari gele‑ blaale‑ ‑wa do ta. 'Bhɛ ‑wa 'ɛ 'yaa‑ Zude 'klɛɛn 'yi vlɛ gɔɔn mu 'ɛ ba ‑yrɛ ta. ");
INSERT INTO moa_vpl VALUES ("LK1_40","072_1_40","LUK","1","40","40","‑E bhɔle 'bhɛ ‑wa 'ɛ ta, 'kee‑ gele‑ wlalɛ Zakari ba 'fɛ 'ɛ ꞊la; 'bhɛɛ‑ 'kee‑ Elizabɛti 'pubɔle. ");
INSERT INTO moa_vpl VALUES ("LK1_41","072_1_41","LUK","1","41","41","Elizabɛti Mari a 'pubɔwli 'ɛ 'male‑ 'ke ‑a ‑nɛ 'ɛ 'klale 'bhɛ 'gbu ta ‑a 'kpee. 'Bhɛɛ‑ 'ke 'yee‑ Elizabɛti zru 'ɛ 'pale 'ke Lii 'Weŋ 'ɛ 'le. ");
INSERT INTO moa_vpl VALUES ("LK1_42","072_1_42","LUK","1","42","42","'Bhɛɛ‑ 'ke ‑ya pele‑ 'eglɔɔle dɔɔ: «'E 'dumawole ‑o ‑Waanbhaa 'kɔɔ le mu ba, 'bhɛɛ‑ ‑yaa' 'duma 'ɛ nu bolɛ 'e nu ‑nɛ 'la 'yalɛ‑ 'bhɛ ta. ");
INSERT INTO moa_vpl VALUES ("LK1_43","072_1_43","LUK","1","43","43","'Mi 'laa ‑o 'ke pɛ 'kedo‑ 'kpɔ 'le, 'bhɛɛ‑ ‑e ‑kla 'nale‑ 'bhɛɛ‑ 'ŋ Zan ‑Waanbhaa' nɛɛ 'ɛ ꞊nwa 'mi ba ɛɛ? ");
INSERT INTO moa_vpl VALUES ("LK1_44","072_1_44","LUK","1","44","44","'E 'trɔnbadɔ doo, 'mi 'yaa‑ 'pubɔwli 'ɛ 'male‑, 'ke 'ŋ 'kpee ‑nɛ 'ɛ ‑e 'klale ‑a 'gbu ta ‑a zrukpaa' 'ɛ 'kɔɔ. ");
INSERT INTO moa_vpl VALUES ("LK1_45","072_1_45","LUK","1","45","45","'Yaa‑ pɛ ‑le 'ke zrukpaa' 'le, 'bhi 'la 'bhi 'e ꞊kpaa ‑a ‑yi 'bhii‑ Mɛɛzan ‑Waanbhaa' ‑jan 'la ꞊woa 'e ni ‑e nu 'bhɛ 'yizaklɛlɛ.» ");
INSERT INTO moa_vpl VALUES ("LK1_46","072_1_46","LUK","1","46","46","Mari pe dɔɔ: «'Ŋ ‑ Mɛɛzan Waanbhaa' 'tɔbhɔ‑ 'ŋ zru 'ɛ 'kpɛn 'le. ");
INSERT INTO moa_vpl VALUES ("LK1_47","072_1_47","LUK","1","47","47","'Ŋ zrukpaale ‑o 'egbɛnɛle, 'ŋ 'Bhee mi ‑Waanbhaa' ‑srɔyi'. ");
INSERT INTO moa_vpl VALUES ("LK1_48","072_1_48","LUK","1","48","48","‑Amasrɔyi, ‑e ‑dwa ‑a ‑la 'ke ‑ya ‑yrɛkpa' ‑a ‑la, 'bhɛɛ‑ ‑e 'mi taglin, yaa yewo le ‑nɛ 'ɛ, 'mi a 'fiɛntrɔnnɛya 'ɛ 'yi. 'Bhɛla‑ ‑zayile 'kee‑ san ‑zɔn ma, 'ke 'bhɛ ge 'tɛnlɛ‑ 'drunyan 'yanle‑ ma, mɛɛ mu nu ‑a pelɛ 'mi ma dɔɔ 'bhi a pɛ ‑le 'ke zrukpaa' 'le. ");
INSERT INTO moa_vpl VALUES ("LK1_49","072_1_49","LUK","1","49","49","‑Amasrɔyi ‑Waanbhaa' ‑Glɔɔ, ‑e ‑za 'wlan ‑gbɛnɛ mu ꞊kla 'mi ni. ‑A 'tɔ 'ɛ ‑yoo 'weŋ. ");
INSERT INTO moa_vpl VALUES ("LK1_50","072_1_50","LUK","1","50","50","Mɛɛ 'la zan mu ‑gasikpa ‑a ‑lɛɛ, 'bhɛɛ‑ 'ke 'mu gblaan ‑a ‑lɛɛ, 'bhɛ zan mu 'ɛ ‑yrɛn nu 'klalɛ‑ ‑a ma 'waati 'ɛ 'kpɛn ba. ");
INSERT INTO moa_vpl VALUES ("LK1_51","072_1_51","LUK","1","51","51","‑E 'sɔle‑ maza ‑gbɛnɛ mu ꞊kla yaa ‑glɔɔya' 'ɛ 'le. Mɛɛ 'la zan mu ‑o 'gbu magbaandɛ ‑o 'kpee, ‑e 'bhɛ zan mu ‑piilaa' 'eke‑ ma. ");
INSERT INTO moa_vpl VALUES ("LK1_52","072_1_52","LUK","1","52","52","‑E bhleŋgbe mu ‑gwa ‑waa ‑bhleŋgbeya 'ɛ 'yi. 'Bhɛɛ‑ mɛɛ 'la zan mu 'mu 'gbu mazinaa, ‑e 'bhɛ zan mu 'ɛ ‑lawlɛnna. ");
INSERT INTO moa_vpl VALUES ("LK1_53","072_1_53","LUK","1","53","53","‑E gbɔndɛ mu 'kɔɔ 'paa‑ 'ke pɛ 'srɛ 'le, 'bhɛɛ‑ ‑e pɛzan mu ‑gbian ‑o 'kɔɔ 'fleŋ‑ mu 'le. ");
INSERT INTO moa_vpl VALUES ("LK1_54","072_1_54","LUK","1","54","54","‑E ‑nwa bhɔlɛ ‑yaa' yewonɛ mu Izraɛli mu 'ɛ ba, ‑ya ‑liiwli' 'la ‑naa dɔɔ ‑e nu ‑o ‑yrɛnklalɛ 'bhɛ 'la golɛ ‑li ‑a 'kpee. ");
INSERT INTO moa_vpl VALUES ("LK1_55","072_1_55","LUK","1","55","55","‑Ya ‑liiwli' ‑naa ‑kɔɔ' ‑gbɔɔ mu ni 'bhɛɛ‑ gbɛɛn‑, dɔɔ ‑kɔɔ' ‑gbɔɔ *Abraamu 'pegee 'bhɛ 'srɛ mu ‑yrɛn nu 'klalɛ ‑a ma ‑zɔn 'pegee yikpɛnsee ta.» ");
INSERT INTO moa_vpl VALUES ("LK1_56","072_1_56","LUK","1","56","56","Mari ‑yaan ‑yaa' 'sro 'ɛ 'kpalele, 'kee‑ bole‑ Elizabɛti ‑din mlɛ yaga ta. 'Bhɛ blaan, 'kee‑ nule‑ ‑a ba. ");
INSERT INTO moa_vpl VALUES ("LK1_57","072_1_57","LUK","1","57","57","Elizabɛti 'ya bhla 'ɛ 'bhɔle‑, 'ke ‑ya yale‑ 'ke ‑nɛ 'gwlaan‑ do 'le. ");
INSERT INTO moa_vpl VALUES ("LK1_58","072_1_58","LUK","1","58","58","Elizabɛti yaayɔɔn' mu 'ɛ 'pegee ‑a dɛ ‑nɛ mu 'ɛ ‑wa malawoa dɔɔ Mɛɛzan ‑Waanbhaa' ‑yaa mɛɛ ‑yrɛnklagbɛya 'ɛ ‑zrɔnna ‑a ni; 'bhɛla‑ ‑zayile ‑o 'kpɛn 'pegee 'yee‑ Elizabɛti zrukpaale ‑yaa. ");
INSERT INTO moa_vpl VALUES ("LK1_59","072_1_59","LUK","1","59","59","‑Nɛ 'yiɛntɛnnɛ 'ɛ 'yale‑ blaan ‑yrekpaa' 'srwaa‑ mi ma, ‑a dɛ mu ‑nwa ‑a wlalɛ 'klɛɛn 'yi 'tɛ. 'Bhɛɛ‑ ‑o ‑yaa zi 'bhii‑ ‑wa 'tookpa ‑a dɛ Zakari ma. ");
INSERT INTO moa_vpl VALUES ("LK1_60","072_1_60","LUK","1","60","60","'Duŋ‑ ‑nɛ 'ɛ nɛɛ pe dɔɔ: «'Yooye‑, ‑kɔɔ' 'a 'tɔkpa Zaan.» ");
INSERT INTO moa_vpl VALUES ("LK1_61","072_1_61","LUK","1","61","61","Mɛɛ mu 'ɛ pe Elizabɛti ni dɔɔ: «'Waa mɛɛ 'kedo‑ 'kpɔ sii 'bhɛ 'tɔ 'la bhe 'bhɛ ma 'yaa‑ 'fa ‑la mu 'ɛ ba.» ");
INSERT INTO moa_vpl VALUES ("LK1_62","072_1_62","LUK","1","62","62","'Bhɛ klɛle 'tɛ, 'ke ‑wa dɛ Zakari ‑lrɔkpale' ‑tɔɔmasie mu 'le dɔɔ 'bhɛ ‑a zi 'bhii‑ ‑wa 'sii‑ 'tɔ 'ɛ ‑dela ma 'tɛ; ‑amasrɔyi 'bhɛ ꞊kla 'ke 'bhobho 'le. ");
INSERT INTO moa_vpl VALUES ("LK1_63","072_1_63","LUK","1","63","63","'Bhɛla‑ ‑yile, 'ke a dɛ Zakari 'a 'pele mɛɛ mu 'ɛ ni dɔɔ ‑o 'sɛwɛ yɔɔndɛ ‑yripee' do na a ni. 'Bhɛɛ‑ 'ke ‑ya yɔɔndɛle 'bhɛ ta dɔɔ: «‑A 'tɔ ‑le Zaan.» ");
INSERT INTO moa_vpl VALUES ("LK1_64","072_1_64","LUK","1","64","64","'Bhɛ klɛle 'tɛ, 'ke ‑o 'kpɛn 'kpeelɛnile ‑o ma. 'Bhɛ 'waati do 'kpɔ 'ɛ ba, 'ke 'bhobho 'ɛ gole‑ 'yee‑ Zakari 'lɛ ta, 'bhɛɛ‑ 'kee‑ ‑janwole 'sanle 'kee‑ ‑Waanbhaa' 'tɔbhɔ‑. ");
INSERT INTO moa_vpl VALUES ("LK1_65","072_1_65","LUK","1","65","65","‑Ayile, 'ke ‑gblaan 'klale ‑a yaayɔɔn' mu 'ɛ 'kpɛn 'yi. 'Bhɛ ‑za 'ɛ 'bhɛ ‑le ꞊kla 'ke Zude vlɛ gɔɔn ‑yi mu 'ɛ 'kpɛn 'liijan‑ 'le. ");
INSERT INTO moa_vpl VALUES ("LK1_66","072_1_66","LUK","1","66","66","Mɛɛ 'la zan mu 'kpɛn 'yee‑ ‑za 'ɛ 'maa‑, 'mu 'yaa‑ 'mu 'kpeelɛdan 'zi 'ke ‑woo 'eke‑ ‑lrɔkpa' dɔɔ: «‑Nɛ 'lɛɛ‑ nu klɛlɛ 'ke mɛɛ ‑glɔɔn 'ɛ ‑de 'gbu ‑la ‑le ɛɛ?» ‑Amasrɔyi Mɛɛzan ‑Waanbhaa' ‑glɔɔya' 'ɛ 'yaa‑ ‑a ta. ");
INSERT INTO moa_vpl VALUES ("LK1_67","072_1_67","LUK","1","67","67","‑Nɛ 'ɛ dɛ Zakari 'pale‑ 'la 'yaa‑ 'ke Lii 'Weŋ 'ɛ 'le, 'kee‑ ‑Waanbhaa' ‑lɛlajanwole 'sanle 'sro do 'yi dɔɔ: ");
INSERT INTO moa_vpl VALUES ("LK1_68","072_1_68","LUK","1","68","68","«‑Kɔɔ' Mɛɛzan ‑Waanbhaa' 'tɔbhɔ, Izraɛli mɛɛ mu 'ɛ ‑waa' ‑Waanbhaa'. ‑Amasrɔyi ‑e ‑nwa bhɔlɛ ‑yaa' mɛɛ mu 'ɛ ba 'bhɛɛ‑ ‑yoo tagbawoa. ");
INSERT INTO moa_vpl VALUES ("LK1_69","072_1_69","LUK","1","69","69","‑Waanbhaa' ‑kɔɔ 'Bhee mi ‑glɔɔ do ‑kpa ‑kɔɔ' ni. 'Bhɛ da ‑yaa' yewonɛ ‑bhleŋgbe Davidi 'srɛ mu 'ɛ 'mu ‑la ba. ");
INSERT INTO moa_vpl VALUES ("LK1_70","072_1_70","LUK","1","70","70","‑Waanbhaa ‑lɛla' janwo mu 'weŋ mu 'ɛ 'mu ‑yaa' ‑janwoa 'elwale gban ‑sɔ. ");
INSERT INTO moa_vpl VALUES ("LK1_71","072_1_71","LUK","1","71","71","‑Ya ‑liiwli' ‑kpaa ‑o ‑lii dɔɔ ‑e nu ‑kɔɔ' 'Bhee mi do 'kpalɛ‑, 'bhɛ nu ‑kɔɔ' golɛ ‑kɔɔ' 'sɔɔnnii mu 'pegee ‑kɔɔ' vɛnsi mɛɛ 'la zan mu yin 'lii 'mu 'kɔɔ. ");
INSERT INTO moa_vpl VALUES ("LK1_72","072_1_72","LUK","1","72","72","‑Kɔɔ' ‑gbɔɔ mu ‑yrɛn nu 'klalɛ‑ ‑a ma, 'bhɛɛ‑ *‑bhoolaya 'weŋ la ‑yoo 'yee‑ ‑Waanbhaa 'pegee 'mu 'pleŋ‑, 'bhɛ ‑za 'laa nu golɛ ‑a 'kpee. ");
INSERT INTO moa_vpl VALUES ("LK1_73","072_1_73","LUK","1","73","73","‹‑Amasrɔyi ‑Waanbhaa' 'gbu 'e 'siɛnwoa‑ ‑a ‑liiwli' 'ɛ ta ‑kɔɔ' ‑gbɔɔ Abraamu ni kpataakpa,› ");
INSERT INTO moa_vpl VALUES ("LK1_74","072_1_74","LUK","1","74","74","dɔɔ ‑e nu ‑kɔɔ' golɛ ‑kɔɔ' 'sɔɔnnii mu 'ɛ 'kɔɔ; 'bhɛɛ‑ ‑e nu a klɛlɛ 'bhɛɛ‑ 'ke ‑kɔɔa' gba 'ke ‑gblaan 'le ‑kɔɔ' 'yi. ");
INSERT INTO moa_vpl VALUES ("LK1_75","072_1_75","LUK","1","75","75","'Bhɛɛ‑ ‑kɔɔ' klɛ 'weŋ, 'bhɛ 'pegee 'ke ‑kɔɔ' 'lɛdɔɔle klɛ ‑a ‑yrɛ 'yi ‑kɔɔa' 'taawogbɛya 'ɛ 'yi yi 'oo yi. ");
INSERT INTO moa_vpl VALUES ("LK1_76","072_1_76","LUK","1","76","76","'Bhɛ blaan 'ke Zakari ‑janwole ‑nɛ 'yiɛntɛnnɛ 'ɛ ni dɔɔ: 'Bhi 'ŋ 'nɛ, ‑o nu 'e 'siilɛ‑ laanima ‑Waanbhaa' a ‑lɛla' janwo mi. ‑Amasrɔyi 'e nu 'taawolɛ Mɛɛzan ‑Waanbhaa' ‑lɛɛ 'bhɛ a zibhɛ 'ɛ 'lɛmagaan zayi'. ");
INSERT INTO moa_vpl VALUES ("LK1_77","072_1_77","LUK","1","77","77","'Bhɛɛ‑ 'e nu a zrɔnlɛ ‑yaa' mɛɛ mu 'ɛ ni dɔɔ 'yee‑ Mɛɛzan ‑Waanbhaa' ‑le ‑o go ‑za yi 'kee‑ waa ‑za 'yɔɔ‑ mu 'ɛ 'sroma‑ yan. ");
INSERT INTO moa_vpl VALUES ("LK1_78","072_1_78","LUK","1","78","78","‑Amasrɔyi ‑kɔɔa' ‑Waanbhaa' 'ɛ ‑e mɛɛ ‑yrɛnkla', 'bhɛɛ‑ ‑yoo 'ewlanle. ‑E nu ‑kɔɔ' takanlɛ 'weŋ 'bhii‑ ‑yretɛ' 'bhigbɛya ‑a ‑wlɛn bhla zi. ");
INSERT INTO moa_vpl VALUES ("LK1_79","072_1_79","LUK","1","79","79","‑E nu ‑bhilɛ' mɛɛ 'la zan mu ‑o ‑gblo 'pegee ga lii 'ɛ zi 'mu ta, ‹'bhɛɛ‑ ‑e nu ‑kɔɔ' 'lɛdɔɔlɛ yilabla ma zi 'ɛ ta.›» ");
INSERT INTO moa_vpl VALUES ("LK1_80","072_1_80","LUK","1","80","80","‑Nɛ 'ɛ 'bhɛ 'yaa‑ gbaandɛ 'zi, 'bhɛɛ‑ ‑a nii‑ 'ɛ 'yaa‑ ge zi dɔlele ‑a ta 'eglɔɔle. ‑E ꞊bwa ‑kpe mu 'ɛ ta, 'ke 'bhɛ ge 'tɛnlɛ‑ ‑a 'pwɛ yi ma Izraɛli mu 'ɛ 'kpɛn 'yrɛ ma kpataakpa. ");
INSERT INTO moa_vpl VALUES ("LK2_1","072_2_1","LUK","2","1","1","'Waati do bhɔle, 'ke *Romɛ mu a ‑Bhleŋgbe ‑gbɛnɛ Sezaa Gitɛn 'a 'pele dɔɔ Romɛ mu a ‑bhleŋgbe 'klɛɛn 'ɛ zɛn yrɛ 'oo yrɛ 'la ꞊nɔɔ, ‑o 'bhɛ ꞊nɔɔ mu 'ɛ 'kpɛn 'tɔ 'sɛwɛdɛ 'bhɛɛ‑ ‑o 'mu nɔɔ. ");
INSERT INTO moa_vpl VALUES ("LK2_2","072_2_2","LUK","2","2","2","'Bhɛ ‑le ꞊kla Romɛ mu 'ɛ ‑waa' ‑bhleŋgbe 'klɛɛn 'ɛ 'yi mɛɛ mu 'tɔ dɛle 'pegee ‑o ‑nɔɔle' ꞊lwa mi 'ɛ 'le. ‑E ‑kla 'ke Kirinusi ‑o 'ke ‑janmatii 'le Siri 'klɛɛn 'ɛ ta. ");
INSERT INTO moa_vpl VALUES ("LK2_3","072_2_3","LUK","2","3","3","'Bhɛ ya 'ɛ 'yi, mɔkpɛn' 'yaa‑ ge 'zi 'mu 'tɔ 'sɛwɛdɛlɛ do do 'mu 'gbu 'ya ‑wa la. ");
INSERT INTO moa_vpl VALUES ("LK2_4","072_2_4","LUK","2","4","4","‑Ayile, 'ke Zozɛfu dale‑ Nazarɛti ‑wa 'ɛ ta Galile 'klɛɛn 'ɛ 'yi. 'Bhɛɛ‑ 'kee‑ nule‑ ‑a ‑taa ‑bhleŋgbe Davidi 'ya ‑wa 'ɛ ta. ‑O ‑yaa 'bhɛ ‑wa 'ɛ sii Bɛtelɛmu, 'bhɛɛ‑ 'bhɛ 'yaa‑ Zude 'klɛɛn 'ɛ 'yi. ");
INSERT INTO moa_vpl VALUES ("LK2_5","072_2_5","LUK","2","5","5","'Yee‑ 'pegee ‑a bhɛle Mari, ‑o ꞊nwa ‑o 'tɔ 'sɛwɛdɛlɛ 'bhɛɛ‑ ‑wa 'ɛ ta. 'Bhɛ 'waati 'ɛ ba, 'ke Mari kpɛle ‑o. ");
INSERT INTO moa_vpl VALUES ("LK2_6","072_2_6","LUK","2","6","6","‑O ‑yaa Bɛtelɛmu 'waati 'la ba, 'ke ‑a zina‑ bhla 'ɛ 'bhɔle. ");
INSERT INTO moa_vpl VALUES ("LK2_7","072_2_7","LUK","2","7","7","'Bhɛɛ‑ 'ke ‑ya yale‑ 'ke ‑nɛ 'gwlaan‑ do 'le, 'bhɛ ‑le ‑yaa 'ke ‑a ‑nɛ ꞊lwa mi 'ɛ 'le. 'Yee‑ Mari sɔ mu ꞊kpaa ‑a ‑nɛ 'ɛ ma, 'bhɛɛ‑ ‑ya ‑yilaa' dri mu a pɛbhle ‑koonɛ do 'yi. ‑Amasrɔyi waa yilayrɛ ‑srɔɔwolɛ 'cie mu yi 'fɛ 'ɛ ꞊la. ");
INSERT INTO moa_vpl VALUES ("LK2_8","072_2_8","LUK","2","8","8","‑Bhlaa gooba mu 'ke mu ‑yaa 'yee‑ 'klɛɛn do 'kpɔ 'ɛ 'yi Bɛtelɛmu ‑wa 'ɛ ‑din; 'bhɛ mu ‑yaa yi gba mu 'ɛ ta 'ke ‑woo ‑yrɛkpa' ‑waa' ‑bhlaa mu 'ɛ ba. ");
INSERT INTO moa_vpl VALUES ("LK2_9","072_2_9","LUK","2","9","9","'Bhɛ yi do 'kpɔ 'ɛ ‑bi 'ɛ zi, 'ke Mɛɛzan ‑Waanbhaa' a ‑mlɛkɛ' mu 'ɛ do 'pwɛle ‑o ba. 'Bhɛɛ‑ 'ke Mɛɛzan ‑Waanbhaa' a 'tɔbhɔleya 'ɛ 'bhile 'ɛ zɛnle‑ ‑o zi. 'Bhɛɛ‑ 'ke ‑gblaan ‑gbɛnɛ do 'klale ‑o ‑yi. ");
INSERT INTO moa_vpl VALUES ("LK2_10","072_2_10","LUK","2","10","10","'Duŋ‑, ‑mlɛkɛ' 'ɛ pe ‑o ni dɔɔ: «'Ka 'laa ‑gblaanlɛ', 'ŋ 'yoo‑ zan ‑jan 'nrale‑ do ‑la wolɛ 'ka ni, 'bhɛ nu Izraɛli mu 'ɛ 'kpɛn zrukpaalɛ. ");
INSERT INTO moa_vpl VALUES ("LK2_11","072_2_11","LUK","2","11","11","'Ka 'Bhee Mi 'ɛ ꞊yaa 'ka ni ‑zɔn ‑bi 'lɛɛ‑ zi, ‑bhleŋgbe Davidi a ‑wa 'ɛ ta. 'Yele‑ 'ke *Krisi 'le, 'bhɛɛ‑ 'yele‑ 'ke Mɛɛzan 'ɛ 'le. ");
INSERT INTO moa_vpl VALUES ("LK2_12","072_2_12","LUK","2","12","12","'Ka nu 'sɔlɛ‑ ‑a dɔle‑ ‑tɔɔmasie 'lɛɛ‑ 'bhɛɛ‑ ma: 'Ka nu ‑nɛ 'yiɛntɛnnɛ do yelɛ sɔ mu 'le 'a ma dri mu a pɛbhle ‑koonɛ' do 'yi.» ");
INSERT INTO moa_vpl VALUES ("LK2_13","072_2_13","LUK","2","13","13","'Bhɛ yrɛ do 'kpɔ 'ɛ ꞊nɔɔ bhe, 'ke ‑mlɛkɛ' 'saa do dale‑ laflɛ' 'yi, 'bhɛɛ‑ 'ke ‑o nule‑ 'kpalɛ‑ ‑a ‑lwa mi 'ɛ ba, 'bhɛɛ‑ 'ke ‑o ‑Waanbhaa' 'tɔbhɔle 'sanle 'ke ‑wa pe dɔɔ: ");
INSERT INTO moa_vpl VALUES ("LK2_14","072_2_14","LUK","2","14","14","«‑Ka laanima ‑Waanbhaa' 'ɛ 'tɔbhɔ, bhaa 'trɛ ta mu 'la ‑za sɔ a ni, ‑e yilabla 'na 'mu ni!» ");
INSERT INTO moa_vpl VALUES ("LK2_15","072_2_15","LUK","2","15","15","‑Mlɛkɛ' mu 'ɛ ‑o gole blaan 'woo‑ ‑bhlaa gooba mu 'ɛ ‑din, 'bhɛɛ‑ ‑o gele blaan laflɛ' 'yi, 'ke 'woo‑ ‑bhlaa gooba mu 'ɛ ‑wa pele‑ 'eke‑ 'ni dɔɔ: «‑Kɔɔ' ge Bɛtelɛmu, ‑za 'la ꞊kla ‑a ꞊nɔɔ ‑kɔɔ' ge 'bhɛ ꞊nɔɔ ‑glin doo, 'bhɛɛ‑ Mɛɛzan ‑za 'la 'zrɔnna‑ ‑kɔɔ' ni ‑kɔɔ' ge 'bhɛ ‑glin.» ");
INSERT INTO moa_vpl VALUES ("LK2_16","072_2_16","LUK","2","16","16","'Bhɛ klɛle 'tɛ, 'ke ‑o gele‑ blaale‑ Bɛtelɛmu, 'bhɛɛ‑ 'ke ‑o Mari 'pegee Zozɛfu 'yele, 'bhɛ 'pegee ‑nɛ 'yiɛntɛnnɛ 'ɛ 'yilale yele‑ dri mu a pɛbhle ‑koonɛ do 'yi. ");
INSERT INTO moa_vpl VALUES ("LK2_17","072_2_17","LUK","2","17","17","‑O ‑nɛ 'ɛ 'yele‑, ‑mlɛkɛ' mu 'ɛ ‑jan 'la ꞊woa ‑o ni 'yee‑ ‑nɛ 'ɛ ba zayi', 'ke ‑o 'bhɛ 'kpɛn 'yigɔɔnle. ");
INSERT INTO moa_vpl VALUES ("LK2_18","072_2_18","LUK","2","18","18","Mɛɛ 'la zan mu 'kpɛn ‑bhlaa gooba mu 'ɛ 'wojan‑ 'ɛ ꞊maa, 'mu 'kpɛn 'kpeelɛnia 'mu ma. ");
INSERT INTO moa_vpl VALUES ("LK2_19","072_2_19","LUK","2","19","19","'Bhɛɛ‑ 'duŋ‑ Mari ‑yaa 'bhɛ ‑za mu 'ɛ 'kpɛn 'kpa zii' ‑a 'kpee 'ke ‑ya 'kpeelɛdan 'mu ma. ");
INSERT INTO moa_vpl VALUES ("LK2_20","072_2_20","LUK","2","20","20","'Bhɛ blaan, 'ke ‑bhlaa gooba mu 'ɛ ‑o gele‑ ‑o ba ‑wa la. ‑O ge bhla 'ɛ zi, ‑o ‑yaa ‑Waanbhaa' 'tɔbhɔ ma 'sro mu 'kpa zii' ‑o pɛ 'la ma jan ‑maa, 'bhɛ 'pegee ‑o pɛ la ꞊ya 'mu 'kpɛn ‑zayi'. ‑Amasrɔyi ‑mlɛkɛ' 'ɛ ‑jan yɛkɛ‑ 'la ꞊woa ‑o ni, ‑o 'bhɛɛ‑ wlata za ꞊ya. ");
INSERT INTO moa_vpl VALUES ("LK2_21","072_2_21","LUK","2","21","21","‑Nɛ 'ɛ 'yaale‑ blaan ‑yrekpaa' 'srwaa‑ mi ma, 'ke ‑wa wlale‑ 'klɛɛn 'yi; 'ke ‑wa 'tɔkpale *Zesu. ‑Amasrɔyi ‑mlɛkɛ' do 'ɛ 'bhɛɛ‑ 'tɔ 'ɛ ꞊kpaa ‑a ma ‑a kpɛ 'sile‑ ‑lɛɛ. ");
INSERT INTO moa_vpl VALUES ("LK2_22","072_2_22","LUK","2","22","22","Mari klɛ gbɛ drɛɛ 'weŋ ‑Waanbhaa' gba zayi' 'bhɛ 'bhɔle, 'ke Zozɛfu 'pegee 'yee‑ Mari gele‑ ‑nɛ 'ɛ 'le Zeruzalɛmu ‑Waanbhaa Gba 'Fɛ ‑Gbɛnɛ 'ɛ꞊la, 'kooko‑ ‑wa gbɛkpa Mɛɛzan ‑Waanbhaa' 'kɔɔ. ");
INSERT INTO moa_vpl VALUES ("LK2_23","072_2_23","LUK","2","23","23","‑O 'bhɛ ꞊kla 'bhii‑ ‑a pele ‑o Mɛɛzan ‑Waanbhaa' a 'toŋ 'sɛwɛ 'ɛ 'yi gɔnɛ‑ 'la gbɛɛn‑ dɔɔ: «‑Nɛ 'gwlaan‑ ꞊lwa 'tɔle‑ 'gwlaan‑ ꞊lwa, ‑a 'kpa 'edaŋma Mɛɛzan ‑Waanbhaa' pɛ 'le, 'bhɛɛ‑ ‑e klɛ 'weŋ.» ");
INSERT INTO moa_vpl VALUES ("LK2_24","072_2_24","LUK","2","24","24","'Bhɛɛ‑ 'ezin‑, Mɛɛzan ‑Waanbhaa' a 'toŋ 'ɛ ‑e 'sraka 'la goza ꞊woa ‑ka 'bhɛ go ‑Waanbhaa' ni. «'Bhɛ 'sraka sɔ klɛle‑ 'ke kpro gwlɛn do 'pegee ‑a da do 'le, 'ke yaa klɛlɛ 'bhɛ 'le, ‑e klɛ ‑bhooladɔ maannɛ‑ bhlonɛ‑ plɛ 'le.» ");
INSERT INTO moa_vpl VALUES ("LK2_25","072_2_25","LUK","2","25","25","'Bhɛ 'yi 'tɛ, mɛɛ do ‑yaa Zeruzalɛmu ‑wa 'ɛ ta, ‑o ‑yaa 'bhɛ sii Simeɔn. ‑E ‑yaa 'ke mɛɛ wlan 'le, 'bhɛɛ‑ ‑e ‑yaa gblaan ‑Waanbhaa' ‑lɛɛ. ‑Waanbhaa' 'a 'liiwli‑ ‑naa mɛɛ ‑Bhee mi 'la 'naza‑ ta Izraɛli mu 'ɛ ni, 'yee‑ Simeɔn yri ‑yaa 'bhɛ 'nuza‑ 'ɛ ta. 'Bhɛɛ‑ *Lii 'Weŋ 'yaa‑ ‑a ta. ");
INSERT INTO moa_vpl VALUES ("LK2_26","072_2_26","LUK","2","26","26","'Bhɛɛ‑ 'bhɛ 'yee‑ Simeɔn 'kpeelɛkaan 'elwale gban ‑sɔ dɔɔ 'sani‑ ‑yaa' 'trɛ ta yanle pleŋ‑, ‑Waanbhaa' 'bhɛ 'liiwli‑ ‑naa mɛɛ ‑Bhee mi 'la 'naza‑ ta, ‑e nu 'bhɛ 'yelɛ‑. ");
INSERT INTO moa_vpl VALUES ("LK2_27","072_2_27","LUK","2","27","27","'Bhɛ ya 'ɛ 'yi, ‑Waanbhaa' Lii 'Weŋ 'bhɛ 'yee‑ Simeɔn 'lɛdɔɔla ‑Waanbhaa' Gba 'Fɛ ‑Gbɛnɛ 'ɛ ꞊la. 'Bhɛ 'waati do 'kpɔ 'ɛ ba 'ezin‑, Zesu 'yapɛ‑ mu 'ɛ ‑nwa Moizi a 'Toŋ 'ɛ ‑ya ‑pia ‑o ‑za 'la klɛ 'bhɛɛ‑ klɛlɛ ‑nɛ 'yiɛntɛnnɛ 'ɛ 'le 'yee‑ ‑Waanbhaa' Gba 'Fɛ ‑Gbɛnɛ 'ɛ ꞊la. ");
INSERT INTO moa_vpl VALUES ("LK2_28","072_2_28","LUK","2","28","28","'Bhɛ 'yi bhe, 'ke Simeɔn ‑nɛ 'ɛ 'kunle ‑a ‑kɔɔ 'bhɛɛ‑ 'kee‑ ‑Waanbhaa' 'pubɔle dɔɔ: ");
INSERT INTO moa_vpl VALUES ("LK2_29","072_2_29","LUK","2","29","29","«Mɛɛzan ‑Waanbhaa', ‑a 'to 'ke 'yaa‑ yewonɛ 'ɛ ‑yaa' pɛ 'trɛ ta yan yi 'ɛ bhɔ ‑a ma 'edɔɔle; ‑amasrɔyi 'yee‑ 'liiwli‑ 'la ꞊naa 'o ni 'bhɛ 'kla‑ wlan 'le ‑zɔn. ");
INSERT INTO moa_vpl VALUES ("LK2_30","072_2_30","LUK","2","30","30","‑Amasrɔyi 'mi 'yaa‑ Mɛɛ ‑Bhee Mi 'ɛ ꞊ya 'ŋ 'yrɛbhɛ‑ 'le ‑zɔn kpataakpa. ");
INSERT INTO moa_vpl VALUES ("LK2_31","072_2_31","LUK","2","31","31","'E Mɛɛ ‑Bhee Mi 'la 'lɛbɛŋgwa 'drunyan 'yi 'si mu 'ɛ 'kpɛn 'yrɛ ma. ");
INSERT INTO moa_vpl VALUES ("LK2_32","072_2_32","LUK","2","32","32","'Yele‑ 'tɛbhile 'ɛ 'le, 'bhɛɛ‑ 'yele‑ nu 'trɛ ta mu 'ɛ 'kpɛn 'yrɛ bakanlɛ, 'bhɛɛ‑ ‑woo' 'e dɔ. 'Bhɛɛ‑ ‑e nu 'tɔbhɔleya nalɛ 'yaa‑ Izraɛli mu 'ɛ ni 'ezin‑.» ");
INSERT INTO moa_vpl VALUES ("LK2_33","072_2_33","LUK","2","33","33","Simeɔn 'yaa‑ ‑jan mu 'la 'kpɛn 'wo zii' Zesu ba zayi' 'bhɛ 'yee‑ Zesu dɛ 'pegee ‑a nɛɛ 'kpeelɛnia. ");
INSERT INTO moa_vpl VALUES ("LK2_34","072_2_34","LUK","2","34","34","'Bhɛ blaan 'ke Simeɔn ‑o mɛɛ plɛ 'dumawole, 'bhɛɛ‑ 'ke ‑ya pele‑ Zesu nɛɛ Mari ni dɔɔ: «'E 'yrɛkpa doo! ‑Nɛ 'lɛɛ‑ nu klɛlɛ mɛɛ ‑bebe baapɛ 'le, 'bhɛɛ‑ ‑e nu klɛlɛ mɛɛ ‑bebe 'lawlɛnpɛ 'le Izraɛli 'klɛɛn 'lɛɛ‑ 'yi ‑gɛ. ‑E nu klɛlɛ ‑Waanbhaa' a mɛɛ 'kpeelɛkan pɛ 'le. 'Duŋ‑ mɛɛ ‑bebe nu ‑janwolɛ ‑a ma. ");
INSERT INTO moa_vpl VALUES ("LK2_35","072_2_35","LUK","2","35","35","‑E nu mɛɛ ‑bebe 'kpeejan‑ mu tapwɛlɛ. 'Bhɛɛ‑ 'bhi Mari, 'e zru 'ɛ nu ‑lalɛ' 'papa 'dimi do 'kɔɔ 'bhii‑ ‑wa ꞊pwan 'ke ‑dibhɛ' do 'le.» ");
INSERT INTO moa_vpl VALUES ("LK2_36","072_2_36","LUK","2","36","36","‑O ‑yaa ‑Waanbhaa' *‑lɛla' janwo le do sii Ani, 'bhɛɛ‑ ‑a dɛ 'tɔ ‑le ‑yaa Fanuɛli, Azɛɛ 'srɛ mu 'ɛ do. Loonɛ' gwegwe ‑le ‑yaa 'kɛle‑. ‑E ‑yaa ‑a ‑gbaakɔɔ' 'le, ‑amasrɔyi ‑a yaale blaan gwlɛnna lɛɛ 'srwaplɛ‑ ta, 'bhɛɛ‑ ‑a ‑nɔɔ ꞊kla siɛle'. ");
INSERT INTO moa_vpl VALUES ("LK2_37","072_2_37","LUK","2","37","37","‑A 'san 'bhɛ gale ma, yaa gwlɛn ‑bhɛɛke' 'silɛ‑ 'ezin‑. ‑A lɛɛ ‑yaa lɛɛ mia yiziɛ bhɛ yiziɛ. Yaa ‑yaa ‑a go *‑Waanbhaa' Gba 'Fɛ ‑Gbɛnɛ 'ɛ ꞊la, 'bhɛɛ‑ ‑e ‑yaa ‑Waanbhaa' gba ‑yrekpaa' 'pegee ‑bi zi; 'suŋwlale 'pegee 'seriwolele. ");
INSERT INTO moa_vpl VALUES ("LK2_38","072_2_38","LUK","2","38","38","'Yee‑ Ani ꞊nwa bhɔlɛ Zozɛfu 'pegee Mari 'bhɛɛ Zesu 'nɛ 'yiɛntɛnnɛ ta, 'mu 'yaa‑ ‑Waanbhaa' Gba 'Fɛ ‑Gbɛnɛ 'ɛ ꞊la 'waati do 'kpɔ 'la ba, 'kee‑ ‑Waanbhaa' 'pubɔle. 'Bhɛɛ‑ ‑e Zesu ‑nɛ 'yiɛntɛnnɛ 'ɛ 'bhɛ a ‑janwoa mɛɛ 'la zan mu 'kpɛn 'yri 'yaa‑ ‑a ta 'bhii‑ ‑Waanbhaa' nu Zeruzalɛmu‑wa 'ɛ ta mu 'ɛ tagbawolɛ 'mu ni. ");
INSERT INTO moa_vpl VALUES ("LK2_39","072_2_39","LUK","2","39","39","Zozɛfu 'pegee Mari 'yanle‑ Mɛɛzan ‑Waanbhaa' a 'toŋ mu 'ɛ ta za mu 'ɛ 'kpɛn klɛlele 'waati 'la ba, 'ke ‑o niinale ‑o ‑zanta' Zesu ‑nɛ 'yiɛntɛnnɛ 'ɛ 'le ‑o ba ‑wa la Nazarɛti Galile 'klɛɛn 'ɛ 'yi. ");
INSERT INTO moa_vpl VALUES ("LK2_40","072_2_40","LUK","2","40","40","‑Nɛ 'ɛ 'yaa‑ gbaandɛ 'zi, 'bhɛɛ‑ faŋgan‑ ‑yaa ‑a ta. ‑E ‑yaa klɛ 'zi ‑zadɔ' mi 'le, 'bhɛɛ‑ ‑Waanbhaa' ‑yaa 'bhɛ a wlanya 'ɛ zrɔn 'zi ‑a ni. ");
INSERT INTO moa_vpl VALUES ("LK2_41","072_2_41","LUK","2","41","41","Lɛɛ 'o lɛɛ, Zesu 'yapɛ‑ mu 'ɛ ‑yaa ge Zeruzalɛmu Paki 'fɛti 'ɛ ta. ");
INSERT INTO moa_vpl VALUES ("LK2_42","072_2_42","LUK","2","42","42","Zesu lɛɛ vu ta plɛ mi 'ɛ ma, 'ke ‑a dɛ 'pegee ‑a nɛɛ gele‑ 'yee‑ Paki 'fɛti 'ɛ ta 'bhii‑ ‑o ‑yaa klɛ gɔnɛ‑ 'la gbɛɛn‑ ‑o 'sinii ta za 'ɛ ma. ");
INSERT INTO moa_vpl VALUES ("LK2_43","072_2_43","LUK","2","43","43","'Fɛti 'ɛ 'yanle‑, 'ke 'yee‑ Zesu dɛ 'pegee ‑a nɛɛ nule‑ dɔlɛ ‑o ba ‑wa la Nazarɛti 'taa 'ɛ ta. 'Duŋ‑ Zesu bolawoa ‑o blaan' Zeruzalɛmu, ‑o za 'laa dɔlɛ 'bhɛ 'yi. ");
INSERT INTO moa_vpl VALUES ("LK2_44","072_2_44","LUK","2","44","44","'Woo‑ mu 'kpee ma, Zesu ꞊bwa ‑o 'pegee mɛɛ 'la zan mu ‑nwa 'eke‑ zi Zeruzalɛmu 'taa 'ɛ ta 'mu ‑la zi. ‑O yanle ‑yrekpaa' do ta 'taawolele bhla 'la ba, waa yelawolɛ, 'ke ‑o dɔle‑ ‑a ziglinle ma ‑o ‑bhoo mu 'pegee ‑o dɔ mu 'ɛ ba. ");
INSERT INTO moa_vpl VALUES ("LK2_45","072_2_45","LUK","2","45","45","'Duŋ‑ waa ‑a yelawolɛ yrɛ 'kedo‑ 'kpɔ ꞊nɔɔ bhe, 'ke ‑o niinale ‑o ‑zanta Zeruzalɛmu ‑a ziglinyrɛ nɔɔ‑. ");
INSERT INTO moa_vpl VALUES ("LK2_46","072_2_46","LUK","2","46","46","‑Wa ziglinna ‑yrekpaa' yaga ta, 'bhɛɛ‑ ‑a ‑yrekpaa' yaga mi 'ɛ ma, 'ke ‑o gele‑ ‑a yaale yelɛ *'Toŋ daan mu 'ɛ 'pleŋ‑ ‑Waanbhaa' Gba 'Fɛ ‑Gbɛnɛ 'ɛ ꞊la. ‑E ‑yaa ‑a 'trɔnkpa zii' 'mu 'wojan‑ mu 'ɛ ꞊la, 'bhɛɛ ‑e ‑yaa ‑za 'yilrɔkpa zii' 'mu ba zayi'. ");
INSERT INTO moa_vpl VALUES ("LK2_47","072_2_47","LUK","2","47","47","Mɛɛ 'la zan mu 'kpɛn 'yaa‑ 'mu 'trɔnkpa zii' ‑a ni 'bhɛ yrɛ 'ɛ ꞊nɔɔ, ‑e 'mu 'kpɛn 'kpeelɛnia 'mu ma, yaa ‑jan zikpagbɛya 'ɛ ma yikan' 'le. ");
INSERT INTO moa_vpl VALUES ("LK2_48","072_2_48","LUK","2","48","48","‑A dɛ 'pegee ‑a nɛɛ 'a 'yele‑, 'ke ‑o ‑liibhaale ‑o ma. 'Bhɛɛ‑ 'ke ‑a nɛɛ 'a 'pele ‑a ni dɔɔ: «'Ŋ 'nɛ, 'e ‑mɛ pɛ za ‑la ꞊kla ‑o ni ‑gee' bhe ɛɛ? 'E 'trɔnbadɔ doo, 'e dɛ 'pegee 'mi ‑o 'e ziglin‑ 'zi 'o blina‑ yiɛn 'le 'o ma.» ");
INSERT INTO moa_vpl VALUES ("LK2_49","072_2_49","LUK","2","49","49","'Bhɛ klɛle 'tɛ, 'ke ‑ya pele‑ ‑o ni dɔɔ: «‑Mɛle ꞊kla 'ka ‑o 'ŋ ziglin‑ 'zi ɛɛ? 'Ka 'laa 'yaango‑ 'bhii‑ ‑a ‑lɛdulale ‑o dɔɔ 'ŋ klɛ 'ŋ Dɛ ‑Waanbhaa' Gba 'Fɛ ‑Gbɛnɛ 'ɛ ꞊la ɛɛ?» ");
INSERT INTO moa_vpl VALUES ("LK2_50","072_2_50","LUK","2","50","50","'Duŋ‑ ‑a yapɛ mu 'ɛ 'mu 'laa ‑a wojan 'ɛ 'yimalɛ. ");
INSERT INTO moa_vpl VALUES ("LK2_51","072_2_51","LUK","2","51","51","'Bhɛ blaan, Zesu 'wlɛnle‑ 'ke ‑o 'pegee ‑a yapɛ mu 'ɛ niinale 'eke‑ zi ‑o ba Nazarɛti. ‑E ‑yaa 'mu wli ma. ‑A nɛɛ Mari ‑yaa 'bhɛ ‑za mu 'ɛ 'kpɛn kpa 'bhɛ 'kpee. ");
INSERT INTO moa_vpl VALUES ("LK2_52","072_2_52","LUK","2","52","52","Zesu 'yaa‑ gbaandɛ 'zi, bhɛɛ‑ a baan' 'yaa klɛ zi ‑zadɔ' mi 'le. 'Bhɛɛ‑ ‑a ‑za yaa sɔ ‑Waanbhaa' 'pegee bhaaplɛŋ mu ni 'ezin‑. ");
INSERT INTO moa_vpl VALUES ("LK3_1","072_3_1","LUK","3","1","1","‑Bhleŋgbe ‑gbɛnɛ Tiberi ‑yaa' 'bhɛ a ‑bhleŋgbeya lɛɛ vu ta 'soo mi 'ɛ 'yi 'waati 'la ba, Pɔnsi Pilati ‑yaa ‑janmatii 'le Zude 'klɛɛn 'ɛ ta. *Erɔdi ‑yaa ‑janmatii 'le Galile 'klɛɛn 'ɛ ta, 'bhɛɛ‑ ‑a nɛɛnɛ‑ Filipu ‑yaa ‑janmatii 'le Iture 'pegee Trakoniti 'klɛɛn mu 'ɛ ta. 'Bhɛɛ‑ Lizaniasi ‑yaa ‑janmatii 'le Abilɛni 'klɛɛn 'ɛ ta. ");
INSERT INTO moa_vpl VALUES ("LK3_2","072_3_2","LUK","3","2","2","Anasi 'pegee Kaifu ‑yaa 'sraka 'lɛna mu ‑kuŋlii gblaan mu 'le 'bhɛ bhla 'ɛ ba. 'Bhɛ 'waati 'ɛ ba, 'ke ‑Waanbhaa' ‑jan do wole‑ Zakari gbe Zaan ni ‑kpe 'ɛ ta. ");
INSERT INTO moa_vpl VALUES ("LK3_3","072_3_3","LUK","3","3","3","‑Ayile, 'ke Zaan 'wlɛnle, 'kee‑ gele‑ Zrudɛn yue 'ɛ 'lɛ zi 'klɛɛn mu 'ɛ 'kpɛn 'yi. ‑E ‑yaa pe 'zi mɛɛ mu 'ɛ ni dɔɔ: «‑Ka ploo ‑za 'yɔɔ‑ klɛle ma, 'bhɛ 'pegee ‑ka 'ka zru niina‑ ‑Waanbhaa ba, 'bhɛɛ‑ ‑o ‑ka 'ka 'wiiŋfɛ ‑yi ba. 'Ke 'ka 'bhɛ ꞊kla, ‑Waanbhaa' nu 'kaa‑ ‑za 'yɔɔ‑ mu 'ɛ ‑sroma 'yanlɛ‑.» ");
INSERT INTO moa_vpl VALUES ("LK3_4","072_3_4","LUK","3","4","4","'Bhɛ klɛgbɛya 'ɛ 'yi, ‑Waanbhaa' *‑lɛla' janwo mi Ezai Mɛɛ Wiiŋfɛ' Mi Zaan ma jan 'la ꞊woa 'bhɛ 'lɛswa꞊. Ezai 'a ꞊pia‑ 'elwale ‑sɔ dɔɔ: «Mɛɛ do ‑o ‑gbekan' zii' ‑kpe 'ɛ ta, 'ke ‑ya pe dɔɔ: ‑Ka Mɛɛzan ‑Waanbhaa' a zibhɛ 'ɛ 'lɛmagaan, ‑ka ‑yaa' zibhɛ mu 'ɛ 'lɛdɔɔ‑. ");
INSERT INTO moa_vpl VALUES ("LK3_5","072_3_5","LUK","3","5","5","‑O nu ‑gbaŋglo mu 'kpɛn 'liitanlɛ. 'Bhɛɛ‑ ‑o nu gɔɔn 'tɔle‑ gɔɔn 'mu 'kpɛn takpaalɛ. ‑O nu zi 'klule‑ mu 'ɛ 'kpɛn 'lɛdɔɔlɛ; 'bhɛɛ ‑o nu zibhɛ ‑yɔɔ' mu 'ɛ 'kpɛn 'liimagaanlɛ. ");
INSERT INTO moa_vpl VALUES ("LK3_6","072_3_6","LUK","3","6","6","'Ke 'bhɛ ꞊kla, bhaaplɛŋ 'kpɛn nu ‑Waanbhaa' a mɛɛ go gbɛya ‑za 'yi 'bhɛ 'yelɛ‑.» ");
INSERT INTO moa_vpl VALUES ("LK3_7","072_3_7","LUK","3","7","7","Mɛɛ 'la zan mu ‑yaa zan 'esrɛle ‑a ba 'mu 'wiiŋfɛ ‑zayi' ‑a 'kɔɔ ‑yi 'ɛ ba, 'yee‑ Zaan ‑yaa pe 'zi 'mu ni dɔɔ: «‑Bhlu 'plalu bhaaplɛŋ mu, 'bhɛɛ‑ ‑dawli' ma mɛɛ mu, ‑dele 'ka 'kpeelɛkaan dɔɔ 'ka 'blasan‑ ‑Waanbhaa' a 'kiti 'la ꞊bhwa ‑kɔɔ' ‑din bhe 'bhɛ 'lɛɛ ɛɛ? ");
INSERT INTO moa_vpl VALUES ("LK3_8","072_3_8","LUK","3","8","8","‑Kaa zrɔn 'ka klɛza mu 'ɛ ma 'bhii‑ 'ka 'ploola‑ ‑za 'yɔɔ‑ klɛle ma. 'Ka 'laa bolɛ ‑a 'pele‑ 'te ma 'ka 'gbu 'kpee dɔɔ: ‹'O mɔɔ ‑o 'ke Abraamu 'srɛ mu 'le.› 'Mi pe 'ka ni wlan 'ɛ ni dɔɔ ‑Waanbhaa' sɔ kpoti mu 'lɛɛ‑ maniinale 'ke Abraamu 'srɛ mu 'le! ");
INSERT INTO moa_vpl VALUES ("LK3_9","072_3_9","LUK","3","9","9","‑O ‑yri 'pɔ poo 'ɛ 'lɛkpaa꞊ gban, 'bhɛɛ‑ ‑woo zan ‑yri diiŋ mu 'ɛ takanlɛ 'kee‑ san ‑o 'sɛnɛ mu 'ɛ ma. 'Bhɛla‑ ‑yile 'ke ‑yri diiŋ 'la 'bhɛ 'laa 'bhɛ bhaa ‑lrele' klɛ, ‑o nu 'bhɛ takanlɛ 'bhɛɛ‑ ‑wa blin 'tɛ 'yi.» ");
INSERT INTO moa_vpl VALUES ("LK3_10","072_3_10","LUK","3","10","10","'Bhɛ ya 'ɛ 'yi, 'ke mɛɛ mu 'ɛ Zaan ‑lrɔkpale dɔɔ: «'O 'taawo‑ gɔnɛ‑ 'ɛ ‑dela gbɛɛn‑ 'ke 'bhɛ 'a zrɔn 'bhii‑ 'o 'ploola‑ ‑za 'yɔɔ‑ klɛle ma ɛɛ?» ");
INSERT INTO moa_vpl VALUES ("LK3_11","072_3_11","LUK","3","11","11","'Bhɛɛ‑ 'ke Zaan 'a 'pele ‑o ni dɔɔ: «'Ke dunɛ‑ plɛ ‑o mɛɛ 'la zan 'kɔɔ, 'bhɛ zan 'bhɛ do na ‑dunɛ 'laa ‑o mɛɛ 'la zan 'kɔɔ 'bhɛ ni. 'Bhɛɛ‑ 'ke pɛle ‑o mɛɛ 'la zan 'kɔɔ 'bhɛ zan 'bhɛ 'ke 'na pɛle 'kedo‑ 'kpɔ 'laa ‑o mɛɛ 'la zan 'kɔɔ 'bhɛ ni.» ");
INSERT INTO moa_vpl VALUES ("LK3_12","072_3_12","LUK","3","12","12","'Bhɛ yrɛ do 'ɛ ꞊nɔɔ bhe, 'ke 'nisrakun mu 'ke mu nule‑ ‑o wiiŋfɛ' ‑zayi' ‑yi ba Zaan 'kɔɔ, 'bhɛɛ‑ 'ke ‑o Zaan 'lrɔkpale dɔɔ: «'O mɔɔ ‑mɛ pɛ za 'gbu ‑la klɛ ɛɛ?» ");
INSERT INTO moa_vpl VALUES ("LK3_13","072_3_13","LUK","3","13","13","'Bhɛɛ‑, Zaan 'bhɛ zikpaa‑ ‑o ni dɔɔ: «'Ka 'laa 'nisra 'plɛɛ 'ɛ baan' 'klalɛ‑ ‑a ba. ‑A 'plɛɛ ‑o gɔnɛ‑ 'la gbɛɛn‑ ‑kaa 'to 'bhɛɛ‑ ta.» ");
INSERT INTO moa_vpl VALUES ("LK3_14","072_3_14","LUK","3","14","14","'Bhɛ blaan, 'ke 'srwase 'ke mu Zaan 'lrɔkpale 'ezin‑ dɔɔ: «'Bhɛɛ‑ 'o mɔɔ 'lɛɛ‑, 'o sɔ ‑mɛ pɛ za 'gbu ‑la klɛle‑ ɛɛ?» 'Bhɛ klɛle 'tɛ, 'ke Zaan 'a 'lɛkunle ‑o ni dɔɔ: «'Ka 'laa ‑gɔli' 'kunlɛ‑ mɛɛ mu 'kɔɔ kpaŋma, 'bhɛɛ‑ 'ka 'laa 'lalɛ‑ mɛɛ 'kedo‑ 'kpɔ ta bhla ma. ‑O ‑sra yɛkɛ‑ 'la na 'ka ni ‑ka 'ka zrukpala 'bhɛɛ‑ ma.» ");
INSERT INTO moa_vpl VALUES ("LK3_15","072_3_15","LUK","3","15","15","Izraɛli mu 'ɛ 'kpɛn 'yri 'yaa‑ Mɛɛ ‑Bhee Mi ‑kpɔsɔɔ Krisi 'ɛ 'nuza‑ 'ɛ ta. 'Bhɛɛ‑ ‑o 'kpɛn 'yaa‑ ‑a pe zi ‑o 'kpee dɔɔ ‑dɔke' Zaan ‑le 'kɛle‑ ‑o. ");
INSERT INTO moa_vpl VALUES ("LK3_16","072_3_16","LUK","3","16","16","‑Ayile, 'ke Zaan 'a 'pele ‑o 'kpɛn ni dɔɔ: «'Mi ‑o 'ka 'wiiŋfɛ zii' ‑yi ba, 'duŋ‑ mɛɛ do nu nulɛ 'mi blaan, 'bhɛ ‑glɔɔ 'yiya‑ 'mi ni. Yaa sɔ dɔle‑ 'mi 'gbu 'kpee 'ke 'mi 'a gaan ma ‑sawla bhlɛ mu 'ɛ 'ploole‑ ‑yidan'. 'Bhɛ zan 'ɛ 'bhɛ ‑le nu 'ka 'wiiŋfɛlɛ *Lii 'Weŋ 'pegee 'tɛ 'le. ");
INSERT INTO moa_vpl VALUES ("LK3_17","072_3_17","LUK","3","17","17","‑Mlɔ ꞊pian ‑siɛn do ‑o ‑a 'kɔɔ, ‑yoo zan mɛɛ wlan mu pleŋgolɛ mɛɛ ‑yɔɔ' mu ma, 'bhii‑ ‑o ‑mlɔ bhɛ mu 'ɛ 'pegee ‑mlɔ ‑gboo mu 'ɛ bapian gɔnɛ‑ 'la gbɛɛn‑. ‑E nu mɛɛ wlan mu 'ɛ 'kpalɛ‑ yrɛ ‑lrele' do nɔɔ‑ 'bhii‑ ‑o ‑mlɔ bhɛ mu 'kla beŋ 'yi gɔnɛ‑ 'la gbɛɛn‑. 'Bhɛɛ‑ ‑e nu mɛɛ ‑yɔɔ' mu 'ɛ 'krowolɛ 'bhii‑ ‑o ‑mlɔ ‑gboo mu 'ɛ blin 'tɛ 'la 'ke 'bhɛ 'laa lii ‑titi 'bhɛ 'yi gɔnɛ‑ 'la gbɛɛn‑.» ");
INSERT INTO moa_vpl VALUES ("LK3_18","072_3_18","LUK","3","18","18","Zaan ‑janwoa 'ebebele mɛɛ mu 'ɛ ni gɔnɛ‑ 'la bhe 'bhɛɛ‑ gbɛɛn‑ 'kee‑ zruwla ‑o 'kpee ‑Waanbhaa' a ‑Jan 'Nrale‑ 'ɛ ‑bebe 'wolele. ");
INSERT INTO moa_vpl VALUES ("LK3_19","072_3_19","LUK","3","19","19","'Duŋ‑ boolazi, Zaan 'a ꞊pia ‑janmatii Erɔdi ni dɔɔ 'bhɛ ‑Waanbhaa' a 'toŋ 'ɛ 'yisiɛla 'bhɛ 'bhɛ nɛɛnɛ‑ 'na Erodiadi klɛlawoa 'bhɛ 'na 'le bhe 'bhɛ ‑zayi'; 'bhɛ 'pegee 'bhɛ klɛza ‑yɔɔ ‑bebe 'bhɛɛke mu 'ɛ ‑zayi'. ");
INSERT INTO moa_vpl VALUES ("LK3_20","072_3_20","LUK","3","20","20","'Bhɛɛ‑ 'yee‑ Erɔdi Zaan 'kunlawoa, 'bhɛɛ‑ ‑e 'bhɛ ꞊bwa ‑kaso 'yi bhe, 'bhɛ 'a klɛza ‑yɔɔ' mu 'ɛ baankpaa꞊. ");
INSERT INTO moa_vpl VALUES ("LK3_21","072_3_21","LUK","3","21","21","‑Yrekpaa' do, mɛɛ mu 'ɛ 'kpɛn 'yaa‑ nu 'zi ‑o wiiŋfɛyrɛ nɔɔ‑ ‑yi ba Zaan 'kɔɔ. Zesu ꞊nwa 'bhɛɛ‑ 'yi 'tɛ ‑a wiiŋfɛyrɛ ꞊nɔɔ ‑yi ba Zaan 'kɔɔ 'ezin‑. 'Bhɛ bhla 'ɛ ba 'ke waa 'yee‑ Zaan bɔlɛ ‑li ‑kaso 'yi. Zesu 'yaa‑ ‑a 'seriwo zii' ‑a 'wiiŋfɛ bhla 'ɛ ba, 'ke laflɛ' 'liigole. ");
INSERT INTO moa_vpl VALUES ("LK3_22","072_3_22","LUK","3","22","22","'Bhɛɛ‑, 'ke *Lii 'Weŋ 'ɛ zinale ‑a ta 'bhii‑ ‑bhooladɔ maannɛ‑ do gbɛɛn‑. 'Bhɛɛ‑ 'ke ‑weli' do dale‑ laflɛ' 'yi 'ke 'bhɛ 'a 'pele dɔɔ: «'Bhi ‑le 'ke 'ŋ Gbe 'la ‑za sɔ 'ŋ ni 'egbɛnɛle 'bhɛ 'le, 'bhɛɛ‑ 'bhi ‑le 'ŋ zrukpalaa 'egbɛnɛle.» ");
INSERT INTO moa_vpl VALUES ("LK3_23","072_3_23","LUK","3","23","23","Zesu ‑yaa' ye 'ɛ 'wole‑ zisaan‑ 'waati 'la ba 'ke ‑a lɛɛ ‑o lɛɛ mia do bhɛ vu. Mɔkpɛn' 'yaa‑ kun 'bhii‑ Zozɛfu gbe. 'Bhɛɛ‑ Eli gbe ‑le ‑yaa 'ke Zozɛfu 'le. ");
INSERT INTO moa_vpl VALUES ("LK3_24","072_3_24","LUK","3","24","24","Mataati gbe ‑le ‑yaa 'ke Eli 'le, 'bhɛɛ‑ Levi gbe ‑le ‑yaa 'ke Mataati 'le. Mɛliki gbe ‑le ‑yaa 'ke Levi 'le; 'bhɛɛ‑ Zanai gbe ‑le ‑yaa 'ke Mɛliki 'le, Zozɛfu 'bhɛɛke do gbe ‑le ‑yaa 'ke Zanai 'le. ");
INSERT INTO moa_vpl VALUES ("LK3_25","072_3_25","LUK","3","25","25","Matatiasi gbe ‑le ‑yaa 'ke 'bhɛ Zozɛfu 'ɛ 'le; 'bhɛɛ‑ Amɔsi gbe ‑le ‑yaa 'ke Matatiasi 'le. Naumu gbe ‑le ‑yaa 'ke Amɔsi 'le; 'bhɛɛ‑ Esili gbe ‑le ‑yaa 'ke Naumu 'le. Nagayi gbe ‑le ‑yaa 'ke ‑Esili 'le. ");
INSERT INTO moa_vpl VALUES ("LK3_26","072_3_26","LUK","3","26","26","Maati gbe ‑le ‑yaa 'ke Nagayi 'le; 'bhɛɛ‑ Matatiasi gbe ‑yaa 'ke Maati 'le. Semeini gbe ‑le ‑yaa 'ke Matatiasi 'le; 'bhɛɛ‑ Yozɛsi gbe ‑le ‑yaa 'ke Semeini 'le. Zoda gbe‑le ‑yaa 'ke Yozɛsi 'le. ");
INSERT INTO moa_vpl VALUES ("LK3_27","072_3_27","LUK","3","27","27","Zoana gbe ‑le ‑yaa 'ke Zoda 'le; 'bhɛɛ‑ Reza gbe ‑le ‑yaa 'ke Zoana 'le. Zorobabɛli gbe ‑le ‑yaa 'ke Reza 'le; 'bhɛɛ‑ Salatiɛli gbe ‑le ‑yaa 'ke Zorobabɛli 'le. Neri gbe ‑le ‑yaa 'ke Salatiɛli 'le. ");
INSERT INTO moa_vpl VALUES ("LK3_28","072_3_28","LUK","3","28","28","Mɛliki gbe ‑le ‑yaa 'ke Neri 'le; 'bhɛɛ‑ Adi gbe ‑le ‑yaa 'ke Mɛliki 'le. Kosamu gbe ‑le ‑yaa 'ke Adi 'le; 'bhɛɛ‑ Elimadamu gbe ‑le ‑yaa 'ke Kosamu 'le. Eri gbe ‑le ‑yaa 'ke Elimadamu 'le. ");
INSERT INTO moa_vpl VALUES ("LK3_29","072_3_29","LUK","3","29","29","Zesu 'bhɛɛke do gbe ‑le ‑yaa 'ke Eliezɛɛ 'le; 'bhɛɛ‑ Eliezɛɛ gbe ‑le ‑yaa 'ke 'bhɛ Zesu 'bhɛɛke do 'ɛ 'le. Zorimu gbe ‑le ‑yaa 'ke Eliezɛɛ 'le; 'bhɛɛ‑ Mataati 'bhɛɛke do gbe ‑le ‑yaa 'ke Zorimu le. Levi gbe ‑le ‑yaa 'ke 'bhɛ Mataati 'ɛ 'le. ");
INSERT INTO moa_vpl VALUES ("LK3_30","072_3_30","LUK","3","30","30","Simeɔn gbe ‑le ‑yaa 'ke Levi 'le; 'bhɛɛ‑ Zuda gbe ‑le ‑yaa 'ke Simeɔn 'le. Zozɛfu yaga mi 'ɛ gbe ‑le ‑yaa 'ke Zuda 'le; 'bhɛɛ‑ Zonamu gbe ‑le ‑yaa 'ke 'bhɛ Zozɛfu yaga mi 'ɛ 'le. Eliakimu gbe ‑le ‑yaa 'ke Zonamu 'le. ");
INSERT INTO moa_vpl VALUES ("LK3_31","072_3_31","LUK","3","31","31","Melea gbe ‑le ‑yaa 'ke Eliakimu 'le; 'bhɛɛ‑ Mena gbe ‑le ‑yaa 'ke Matata 'le. Matata gbe ‑le ‑yaa 'ke Mena 'le; 'bhɛɛ‑ Natan gbe ‑le ‑yaa 'ke Matata 'le. Davidi gbe ‑le ‑yaa 'ke Natan 'le. ");
INSERT INTO moa_vpl VALUES ("LK3_32","072_3_32","LUK","3","32","32","Yese gbe ‑le ‑yaa 'ke Davidi 'le; 'bhɛɛ‑ Zobɛdi gbe ‑le ‑yaa 'ke Yese 'le. Boazi gbe ‑le ‑yaa 'ke Zobɛdi 'le; 'bhɛɛ‑ Salomɔ gbe ‑le ‑yaa 'ke Boazi 'le. Naasɔn gbe ‑le ‑yaa 'ke Salomɔ 'le. ");
INSERT INTO moa_vpl VALUES ("LK3_33","072_3_33","LUK","3","33","33","Aminadabu gbe ‑le ‑yaa 'ke Naasɔn 'le; 'bhɛɛ‑ Adimɛ gbe ‑le ‑yaa 'ke Aminadabu 'le. Arini gbe ‑le ‑yaa 'ke Adimɛ 'le; 'bhɛɛ‑ Esrɔn gbe ‑le ‑yaa 'ke Arini 'le. Farɛsi gbe ‑le ‑yaa 'ke Siromu 'le; 'bhɛɛ‑ Zuda 'bhɛɛke do gbe ‑le ‑yaa 'ke Farɛsi 'le. ");
INSERT INTO moa_vpl VALUES ("LK3_34","072_3_34","LUK","3","34","34","Zakɔbu gbe ‑le ‑yaa 'ke 'bhɛ Zuda 'bhɛɛke do 'ɛ 'le; 'bhɛɛ‑ Izaki gbe ‑le ‑yaa 'ke Zakɔbu 'le. Abraamu gbe ‑le ‑yaa 'ke Izaki 'le; 'bhɛɛ‑ Tera gbe ‑le ‑yaa 'ke Abraamu 'le. Nakɔɔ gbe ‑le ‑yaa 'ke Tera 'le. ");
INSERT INTO moa_vpl VALUES ("LK3_35","072_3_35","LUK","3","35","35","Seruki gbe ‑le ‑yaa 'ke Nakɔɔ 'le; 'bhɛɛ‑ Ragawu gbe ‑le ‑yaa 'ke Seruki 'le. Falɛki gbe ‑le ‑yaa 'ke Ragawu 'le; 'bhɛɛ‑ Ebɛri gbe ‑le ‑yaa 'ke Falɛki 'le. Sala gbe ‑le ‑yaa 'ke Ebɛri 'le. ");
INSERT INTO moa_vpl VALUES ("LK3_36","072_3_36","LUK","3","36","36","Kainamu gbe ‑le ‑yaa 'ke Sala 'le; 'bhɛɛ‑ Arifasadi gbe ‑le ‑yaa 'ke Kainamu 'le. Sɛmu gbe ‑le ‑yaa 'ke Arifasadi 'le; 'bhɛɛ‑ Noe gbe ‑le ‑yaa 'ke Sɛmu 'le. Lamɛki gbe ‑le ‑yaa 'ke Noe 'le. ");
INSERT INTO moa_vpl VALUES ("LK3_37","072_3_37","LUK","3","37","37","Metusala gbe ‑le ‑yaa 'ke Lamɛki 'le; 'bhɛɛ‑ Enɔki gbe ‑le ‑yaa 'ke Metusala 'le. Zarɛdi gbe ‑le ‑yaa 'ke Enɔki 'le; 'bhɛɛ‑ Maleliɛli gbe ‑le ‑yaa 'ke Zarɛdi 'le. Kainamu gbe ‑le ‑yaa 'ke Maleliɛli 'le. ");
INSERT INTO moa_vpl VALUES ("LK3_38","072_3_38","LUK","3","38","38","Enɔsi gbe ‑le ‑yaa 'ke Kainamu 'le; 'bhɛɛ‑ Sɛti gbe ‑le ‑yaa 'ke Enɔsi 'le. Adamu gbe ‑le ‑yaa 'ke Sɛti 'le; 'bhɛɛ‑ ‑Waanbhaa' Adamu ꞊kla. ");
INSERT INTO moa_vpl VALUES ("LK4_1","072_4_1","LUK","4","1","1","Zesu 'pale‑ ‑yaa 'ke *Lii 'Weŋ 'ɛ 'le ‑a da bhla 'ɛ zi Zrudɛn yue 'ɛ ta. 'Bhɛɛ‑ Lii 'Weŋ 'ɛ ‑e 'yee‑ Zesu 'sile 'kee‑ gele‑ 'kɛle‑ ‑kpe 'ɛ ta. ");
INSERT INTO moa_vpl VALUES ("LK4_2","072_4_2","LUK","4","2","2","‑Setran' 'ɛ 'a 'yidaan‑ 'bhɛ ‑kpe 'ɛ ta ‑yrekpaa' mia plɛ ta. Yaa pɛbhlelɛ 'bhɛ ‑yrekpaa' mia plɛ 'ɛ 'kpɛn ta. 'Bhɛ yi mu 'ɛ 'kanle‑ blaan, 'ke gbɔn Zesu dɛle‑. ");
INSERT INTO moa_vpl VALUES ("LK4_3","072_4_3","LUK","4","3","3","'Bhɛ klɛle 'tɛ, 'ke ‑Setran' 'a 'pele 'a ni dɔɔ: «'Ke 'yoo‑ 'ke ‑Waanbhaa' Gbe 'gbu 'ɛ 'le ‑a pe kpoti 'la bhe ‑a ni dɔɔ ‑ya mabɔɔ 'bhɛɛ‑ ‑e klɛ 'ke pɛbhle 'le doo.» ");
INSERT INTO moa_vpl VALUES ("LK4_4","072_4_4","LUK","4","4","4","Zesu 'a zikpaa꞊ ‑a ni dɔɔ: «‑Waanbhaa' pe ‑yaa' 'Sɛwɛ 'ɛ 'yi dɔɔ Bhaaplɛŋ a 'trɛ ta bole 'ɛ ‑daŋ' 'laa 'ke pɛbhlele do ‑kplɛn 'le.» ");
INSERT INTO moa_vpl VALUES ("LK4_5","072_4_5","LUK","4","5","5","'Bhɛ blaan, 'ke ‑Setran' gele‑ 'ke Zesu 'le laanima, 'bhɛɛ‑ 'kee‑ 'trɛ ta ‑bhleŋgbe 'klɛɛn mu 'ɛ 'kpɛn zrɔnle‑ ‑a ni 'waati sa ba. ");
INSERT INTO moa_vpl VALUES ("LK4_6","072_4_6","LUK","4","6","6","'Bhɛɛ‑ ‑e pe Zesu ni dɔɔ: «'Ŋ nu ‑glɔɔya' 'lɛɛ‑ 'kpɛn 'pegee ‑bhleŋgbe 'klɛɛn mu 'lɛɛ‑ ‑o ‑yi ‑naflo mu 'ɛ 'nalɛ‑ 'e ni. ‑Woo 'kpɛn gbɛkpaa‑ 'ŋ 'kɔɔ, 'ke ‑o nale ꞊swa 'ŋ ni mɛɛ 'la zan ni 'an na 'bhɛɛ‑ zan ni. ");
INSERT INTO moa_vpl VALUES ("LK4_7","072_4_7","LUK","4","7","7","‑Ayile 'ke 'yee 'kpɔ꞊zian 'ŋ ꞊la, 'bhɛɛ‑ 'kee 'mi꞊gbaa, 'ŋ nu ‑o 'kpɛn 'nalɛ‑ 'e ni.» ");
INSERT INTO moa_vpl VALUES ("LK4_8","072_4_8","LUK","4","8","8","'Bhɛ klɛle 'tɛ, 'ke Zesu 'a 'pele ‑a ni dɔɔ: «‑Waanbhaa' pe ‑yaa' 'Sɛwɛ 'ɛ 'yi 'ezin‑ dɔɔ: ‹'E 'kpɔ 'ɛ zɛn Mɛɛzan ‑Waanbhaa' do ‑kplɛn ‑la ‑lɛɛ 'bhɛɛ‑ 'ya gba›.» ");
INSERT INTO moa_vpl VALUES ("LK4_9","072_4_9","LUK","4","9","9","'Bhɛ blaan, 'ke ‑Setran' gele‑ Zesu 'le ‑Waanbhaa' Gba 'Fɛ ‑Gbɛnɛ 'ɛ 'wiiŋ‑ Zeruzalɛmu, 'bhɛɛ‑ 'ke ‑ya pele‑ ‑a ni dɔɔ: «'Ke 'yoo‑ wlan 'gbu 'ɛ ni *‑Waanbhaa' Gbe 'ɛ 'le, 'ploo‑ 'e 'gbu ma 'bhɛɛ‑ 'e balaa' 'trɛ ma. ‑Amasrɔyi ‑a yɔɔndɛle ‑o ‑Waanbhaa' a 'Sɛwɛ 'ɛ 'yi dɔɔ: ");
INSERT INTO moa_vpl VALUES ("LK4_10","072_4_10","LUK","4","10","10","‹‑Waanbhaa' nu ‑a pelɛ ‑yaa' ‑mlɛkɛ' mu 'ɛ ni 'kaa ‑woo ‑yrɛkpa' 'e ba.› ");
INSERT INTO moa_vpl VALUES ("LK4_11","072_4_11","LUK","4","11","11","'Bhɛɛ‑ ‑a yɔɔndɛle 'ezin‑ dɔɔ: ‹‑O nu 'e binalɛ ‑o 'kɔɔ, 'kooko‑ 'e gaan ma 'diŋ 'laa wo vlɛ ma.›» ");
INSERT INTO moa_vpl VALUES ("LK4_12","072_4_12","LUK","4","12","12","'Bhɛ klɛle 'tɛ, 'ke Zesu 'a 'pele ‑a ni dɔɔ: «‑A pele ‑o ‑Waanbhaa' a 'Sɛwɛ 'ɛ 'yi dɔɔ: ‹'Yaa Mɛɛzan 'yaa‑ ‑Waanbhaa' 'ɛ ‑yidanlɛ.›» ");
INSERT INTO moa_vpl VALUES ("LK4_13","072_4_13","LUK","4","13","13","‑Setran' 'yanle‑ Zesu 'yidanlele gbɛ 'ɛ 'kpɛn ma, 'ke ‑ya 'pleŋgole ‑a ma, 'sani‑ 'ke ‑a ‑yidan' bhla ‑lrele' ‑bhɛɛke' do bhɔ ‑a ‑kɔɔ 'ezin‑. ");
INSERT INTO moa_vpl VALUES ("LK4_14","072_4_14","LUK","4","14","14","'Bhɛ blaan, 'ke Zesu 'niinale Galile 'klɛɛn 'ɛ 'yi. ‑A 'pale‑ ‑yaa 'ke *Lii 'Weŋ 'ɛ ‑glɔɔya' 'le. 'Bhɛɛ‑ mɛɛ mu 'ɛ ‑wa 'tɔbhɔleya 'ɛ ꞊zian Galile 'klɛɛn 'ɛ 'yi yrɛkpɛn‑ ꞊nɔɔ. ");
INSERT INTO moa_vpl VALUES ("LK4_15","072_4_15","LUK","4","15","15","Zesu 'yaa‑ mɛɛ mu 'ɛ daan *Zuufu mu daanfɛ' mu 'ɛ ꞊la. ‑Ayile mɔkpɛn' 'yaa‑ ‑a 'tɔ wlan 'ɛ zɛn 'zi yrɛkpɛn‑ ꞊nɔɔ. ");
INSERT INTO moa_vpl VALUES ("LK4_16","072_4_16","LUK","4","16","16","'Bhɛ blaan, 'ke Zesu gele‑ Nazarɛti, ‑a 'tro ‑wa 'ɛ ta. 'Bhɛɛ‑ *‑yitrɛ' yi 'ɛ ma, 'kee‑ gele‑ wlalɛ *Zuufu mu daanfɛ' 'ɛ ꞊la, 'bhii‑ ‑e ‑yaa klɛ 'egwele gɔnɛ‑ 'la gbɛɛn‑. 'Bhɛ 'yi bhe, 'ke ‑ya ‑wlɛnle' ‑Waanbhaa' a 'Sɛwɛ tape zayi'. ");
INSERT INTO moa_vpl VALUES ("LK4_17","072_4_17","LUK","4","17","17","'Bhɛ klɛle 'tɛ, 'ke ‑o ‑Waanbhaa' *‑lɛla' janwo mi Ezai a 'sɛwɛ kpo 'ɛ 'kpale ‑a ‑kɔɔ. ‑E 'bhɛ 'sɛwɛ kpo 'ɛ 'yiploole 'kee‑ ‑jan 'lɛɛ‑ 'bhɛ tapele dɔɔ: ");
INSERT INTO moa_vpl VALUES ("LK4_18","072_4_18","LUK","4","18","18","«Mɛɛzan ‑Waanbhaa' lii 'ɛ ‑yoo 'ŋ ta, ‑yoo 'ŋ makwan‑ 'kaa 'ŋ nu ‑yaa' ‑Jan 'Nrale‑ 'ɛ 'wo ‑yrɛn ma mɛɛ mu 'ɛ ni, ‑yoo 'ŋ 'winbwa‑ 'kaa 'ŋ 'nu ‑kaso 'yi mu 'plooza‑ pe 'mu ni, 'bhɛɛ‑ 'ŋ 'nu ‑yrɛ 'wi mu ‑yrɛ 'liiploo‑; 'bhɛ 'pegee ‑o ‑yrɛnkpa' zii' mɛɛ 'la zan mu ta 'ŋ 'mu go ‑yrɛn 'yi. ");
INSERT INTO moa_vpl VALUES ("LK4_19","072_4_19","LUK","4","19","19","'Bhɛɛ‑ Mɛɛzan ‑Waanbhaa' 'ŋ 'winbwa‑ 'kaa 'ŋ nu mɛɛ mu 'kpeelɛkan ‑yaa' ‑za wlanya klɛle 'ɛ ma.» ");
INSERT INTO moa_vpl VALUES ("LK4_20","072_4_20","LUK","4","20","20","Zesu 'yanle‑ 'bhɛ ‑jan 'ɛ tapelele, 'kee‑ 'sɛwɛ kpo 'ɛ 'liitanle, 'bhɛɛ‑ 'kee‑ 'bhɛ 'kpale ‑o daanfɛ' 'ɛ ꞊la yewonɛ 'ɛ 'kɔɔ; 'bhɛɛ‑ 'kee‑ gele‑ yaalɛ. Zuufu mu a daanfɛ' 'ɛ ꞊la mɛɛ mu 'ɛ 'kpɛn 'yrɛkpale ‑yaa ‑a ta. ");
INSERT INTO moa_vpl VALUES ("LK4_21","072_4_21","LUK","4","21","21","‑Ayile, 'ke ‑ya pele 'sanle ‑o ni 'kaa: «'Ka 'ka 'trɔnkpaa‑ ‑Waanbhaa' a 'Sɛwɛ 'ɛ 'yi ‑jan 'la ꞊la bhe, 'bhɛ 'lɛswa꞊ ‑zɔn.» ");
INSERT INTO moa_vpl VALUES ("LK4_22","072_4_22","LUK","4","22","22","'Bhɛɛ‑ mɔkpɛn' 'yaa‑ Zesu a ‑jan 'wlan 'pe zii', 'bhɛɛ‑ ‑e ‑yaa mɛɛ mu ‑liibhaa' zii' ‑o ma ‑a ‑liijan' ‑gbɛnɛ ‑gbɛnɛ mu 'ɛ 'le. 'Bhɛɛ‑ ‑o yaa 'eke‑ ‑lrɔkpa' zii' dɔɔ: «Zozɛfu gbe 'ɛ yaa 'kɛle‑ ɛɛ?» ");
INSERT INTO moa_vpl VALUES ("LK4_23","072_4_23","LUK","4","23","23","'Bhɛ ya 'ɛ 'yi, 'ke Zesu 'a 'pele ‑o ni dɔɔ: «‑Dɔke' 'ka nu ‑gɔɔn 'lɛɛ‑ 'bhɛ bɔlɛ 'mi ma dɔɔ: ‹Mɛɛ ‑laanɛkpa mi, 'e 'gbu ma ga 'ɛ go 'pe.› 'Ka nu ‑a pelɛ 'ŋ ni 'ezin‑ dɔɔ: ‹'E ‑za mu 'la 'kpɛn ꞊kla Kapɛnɔmu, ‑o ‑yansi' za mu klɛ 'e 'gbu 'ya ‑wa 'ɛ ta ‑gɛ doo.›» ");
INSERT INTO moa_vpl VALUES ("LK4_24","072_4_24","LUK","4","24","24","'Bhɛ klɛle 'tɛ, ‑e pe ‑o ni 'ezin‑ dɔɔ: «'Mi pe 'ka ni 'ŋ 'sɔwɛɛ‑ ma dɔɔ waa ‑Waanbhaa' *‑lɛla' janwo mi do 'kpɔ 'lɛdɔ‑ ‑a ma ‑a 'gbu ba ‑wa ‑la. ");
INSERT INTO moa_vpl VALUES ("LK4_25","072_4_25","LUK","4","25","25","'Mi pe 'ka ni 'ŋ 'sɔwɛɛ‑ ma dɔɔ: ‑Waanbhaa' ‑lɛla' janwo mi Eli a pɛ 'waati 'ɛ ba, la laa banlɛ lɛɛ yaga 'ke mlɛ 'srwado‑ ta, 'bhɛ 'pegee ‑gu ‑gbɛnɛ 'la 'bhɛ ‑dwa, glaanle ‑bebe ‑yaa Izraɛli 'klɛɛn 'yi 'bhɛ 'waati 'ɛ ba. ");
INSERT INTO moa_vpl VALUES ("LK4_26","072_4_26","LUK","4","26","26","'Duŋ‑ ‑Waanbhaa' laa Eli 'winbɔlɛ 'woo‑ glaanle mu 'ɛ ‑o 'kedo‑ 'kpɔ ba, 'ke yaa 'e go Sidɔn 'klɛɛn 'ɛ 'yi glaanle do 'la 'yaa‑ Sarɛpita ‑wa 'ɛ ta 'bhɛɛ‑ ba. ");
INSERT INTO moa_vpl VALUES ("LK4_27","072_4_27","LUK","4","27","27","'Bhɛɛ‑ 'ezin‑ ‑Waanbhaa' ‑lɛla' janwo mi Elize a pɛ 'waati 'ɛ ba, ‑kpaandɛ' mu ‑bebe ‑yaa Izraɛli 'klɛɛn 'yi, 'duŋ‑ ‑o 'kedo‑ 'kpɔ ma ‑kpaan 'laa golɛ 'ke yaa 'e go Siri mi Naama do ‑kplɛn ba.» ");
INSERT INTO moa_vpl VALUES ("LK4_28","072_4_28","LUK","4","28","28","Mɛɛ 'la zan mu ‑yaa *Zuufu mu daanfɛ' 'ɛ ꞊la, 'mu 'kpɛn 'bhɛ ‑jan mu 'ɛ 'male, 'ke ‑woo zrupliile Zesu ma. ");
INSERT INTO moa_vpl VALUES ("LK4_29","072_4_29","LUK","4","29","29","'Bhɛ klɛle 'tɛ, 'ke ‑woo ‑wlɛnle'. 'Bhɛɛ‑ ‑o Zesu 'kunle‑ 'ke ‑o gele‑ 'kɛle‑ Nazarɛti ‑wa 'ɛ ‑gɔma', 'yee‑ Nazarɛti ‑wa 'ɛ dɔle ‑yaa gɔɔn 'la 'bhɛ ta 'bhɛ 'wiiŋ‑. ‑O ‑yaa zi 'bhii‑ ‑wa blin 'bhɛ gɔɔn 'ɛ 'wiiŋ‑, 'bhɛɛ‑ ‑e balaa' 'bhɛ kpɛla‑ ‑gluu 'ɛ 'yi. ");
INSERT INTO moa_vpl VALUES ("LK4_30","072_4_30","LUK","4","30","30","'Duŋ‑ Zesu ꞊kaan ‑o pleŋ‑ swɛŋ 'kee‑ jilale. ");
INSERT INTO moa_vpl VALUES ("LK4_31","072_4_31","LUK","4","31","31","'Bhɛ blaan, 'ke Zesu gele‑ Galile 'klɛɛn 'yi ‑wa 'la ‑o ‑yaa 'bhɛ sii Kapɛnɔmu 'bhɛ ta. ‑Yitrɛ' yi 'ɛ ma, 'kee‑ mɛɛ mu daanle‑ ‑Waanbhaa' a ‑jan 'ɛ 'le. ");
INSERT INTO moa_vpl VALUES ("LK4_32","072_4_32","LUK","4","32","32","‑Yaa' mɛɛ daangbɛya 'ɛ ‑Waanbhaa' a ‑jan 'ɛ 'le, 'bhɛ 'woo‑ mɛɛ mu 'ɛ ‑o 'kpɛn 'kpeelɛnia ‑o ma. ‑Amasrɔyi ‑e ‑yaa ‑jan 'ɛ 'wo zii' 'bhii‑ 'seŋ ‑o mɛɛ 'la zan ni 'bhɛ a ‑janwogbɛya gbɛɛn‑. ");
INSERT INTO moa_vpl VALUES ("LK4_33","072_4_33","LUK","4","33","33","'Bhɛ 'waati 'ɛ ba, lii ‑yɔɔ' 'yaa‑ 'yee‑ ‑o daanfɛ' 'ɛ ꞊la mu 'ɛ do zi. 'Bhɛ mɛɛ 'ɛ 'pɛɛnle‑ ‑saan 'eglɔɔle 'ke ‑ya pe dɔɔ: ");
INSERT INTO moa_vpl VALUES ("LK4_34","072_4_34","LUK","4","34","34","«Nazarɛti mi Zesu, ‑mɛ za ‑le ‑kɔɔ' 'pleŋ‑ ɛɛ? 'E ꞊nwa 'o 'siɛyrɛ‑ ‑la nɔɔ‑ ɛɛ? 'Mi 'e dɔ! 'Bhi ‑le 'ke ‑Waanbhaa' a mɛɛ 'weŋ 'ɛ 'le.» ");
INSERT INTO moa_vpl VALUES ("LK4_35","072_4_35","LUK","4","35","35","'Bhɛ 'yi 'tɛ, 'ke Zesu 'pɛɛnle lii ‑yɔɔ' 'ɛ ta 'ke ‑ya pe dɔɔ: «'E taga, go mɛɛ 'lɛɛ‑ zi!» 'Bhɛ klɛle 'tɛ, 'ke lii ‑yɔɔ' 'ɛ mɛɛ 'ɛ baale' 'trɛ ma mɔkpɛn' 'yrɛ ma. 'Duŋ‑ yaa ‑za 'yɔɔ‑ 'kedo‑ 'kpɔ klɛlɛ ‑a ni, 'bhɛɛ‑ ‑e ‑gwa ‑a zi. ");
INSERT INTO moa_vpl VALUES ("LK4_36","072_4_36","LUK","4","36","36","'Bhɛ klɛle 'tɛ, 'ke mɛɛ mu 'ɛ 'kpɛn 'kpeelɛnile ‑o ma. 'Bhɛɛ‑ 'ke ‑wa pele‑ dɔɔ: «‑Jan ‑glɔɔn 'ɛ ‑dele 'bhɛ 'le ‑gee' ɛɛ? 'Yee‑ mɛɛ 'lɛɛ‑ ‑e ‑janwo' lii ‑yɔɔ' mu ni faŋgan‑ ma, 'bhɛɛ‑ 'mu go mɛɛ mu 'ɛ zi.» ");
INSERT INTO moa_vpl VALUES ("LK4_37","072_4_37","LUK","4","37","37","‑Ayile, 'ke Zesu klɛza 'ɛ zɛnle‑ 'klɛɛn 'ɛ 'yi yrɛkpɛn‑ ꞊nɔɔ. ");
INSERT INTO moa_vpl VALUES ("LK4_38","072_4_38","LUK","4","38","38","'Bhɛ blaan, Zesu 'pwɛle‑ Zuufu mu 'ɛ waa daanfɛ' 'ɛ ꞊la, 'kee‑ gele‑ Simɔ ba. 'Flɛ 'yi 'la ga ‑glɔɔ do ‑yaa Simɔ boole ma. ‑Ayile, 'ke ‑wa pele‑ Zesu ni 'kaadɔɔ‑ 'bhɛ 'a 'bhee‑. ");
INSERT INTO moa_vpl VALUES ("LK4_39","072_4_39","LUK","4","39","39","'Bhɛ yrɛ do 'ɛ ꞊nɔɔ bhe, 'ke ‑ya makulale Simɔ boole 'ɛ trala, 'bhɛɛ‑ 'kee‑ 'pɛɛnle 'flɛ 'yi 'la ga 'ɛ ta. 'Bhɛla‑ ‑yile, 'ke ga 'ɛ gole‑ Simɔ boole ma. 'Kee‑ ‑wlɛnle', 'bhɛɛ‑ 'kee‑ Zesu 'lɛwɛɛ kpo klɛle‑. ");
INSERT INTO moa_vpl VALUES ("LK4_40","072_4_40","LUK","4","40","40","'Bhɛ 'yi, ‑yretɛbhɛ baale blaan, 'ke ‑wa 'ɛ ta mu 'ɛ ‑o nule‑ ‑waa gadɛ mu ‑glɔɔn 'ɛ 'kpɛn 'le Zesu ni. ‑Ya gbɛkpaa‑ ‑o 'kpɛn ma do do 'ke ‑o ‑bheele'. ");
INSERT INTO moa_vpl VALUES ("LK4_41","072_4_41","LUK","4","41","41","'Bhɛ ꞊nɔɔ bhe, ‑e 'zina ꞊gbian mɛɛ ‑bebe zi. 'Bhɛɛ‑ 'zina mu 'ɛ go bhla 'ɛ zi 'bhɛ mɛɛ mu 'ɛ zi, ‑o ‑yaa ‑gbekan' 'eglɔɔle 'kaa: «'Bhi ‑le 'ke *‑Waanbhaa' Gbe 'ɛ 'le!» 'Duŋ‑ Zesu 'yaa‑ 'pɛɛn zii' ‑o ta, 'bhɛɛ‑ yaa ‑yaa to 'ke ‑o ‑janwoyrɛ ‑srɔɔwo' ‑a 'kɔɔ, ‑amasrɔyi ‑o ‑yaa 'yaango 'bhii‑ ‑e ‑yaa Mɛɛ ‑Bhee Mi *Krisi 'ɛ 'yela‑ ‑le. ");
INSERT INTO moa_vpl VALUES ("LK4_42","072_4_42","LUK","4","42","42","Too ‑klinle', 'ke Zesu gole‑ ‑wa 'ɛ 'kpee, 'bhɛɛ‑ 'ke ‑a do ‑kplɛn gele‑ ‑bɔn 'ɛ drɛyi' yrɛ do nɔɔ‑. 'Bhɛ klɛle 'tɛ, 'ke ‑zamaa' ‑gbɛnɛ do 'a ziglinle 'sanle. ‑O 'tɛnlɛ‑ ‑a ma, 'ke ‑wa pele‑ ‑a ni dɔɔ waa nu 'ploolɛ ‑a ma 'kee go ‑o ‑din. ");
INSERT INTO moa_vpl VALUES ("LK4_43","072_4_43","LUK","4","43","43","‑Ayile, 'ke Zesu 'a 'pele ‑o ni dɔɔ: «'Ŋ gele‑ *‑Waanbhaa' a ‑bhleŋgbeya ma ‑Jan 'Nrale‑ 'ɛ 'wolɛ‑ ‑wa 'bhɛɛke mu 'ɛ ta. ‑Amasrɔyi ‑Waanbhaa' 'ŋ 'winbwa‑ 'bhɛɛ‑ 'kaama‑.» ");
INSERT INTO moa_vpl VALUES ("LK4_44","072_4_44","LUK","4","44","44","'Bhɛla‑ ‑yile, Zesu ‑Jan 'Nrale‑ 'ɛ ꞊woa Zuufu mu daanfɛ' mu 'la 'yaa‑ Zude 'klɛɛn 'ɛ 'yi 'mu 'kpɛn ꞊la. ");
INSERT INTO moa_vpl VALUES ("LK5_1","072_5_1","LUK","5","1","1","‑Yrekpaa' do, Zesu 'yaa‑ Zenezarɛti ‑draa 'ɛ 'lɛ ma, 'bhɛɛ‑ ‑zamaa' mu 'ɛ ‑o ‑yaa 'eke‑ ‑yrɔn 'zi ‑a zi, 'kooko‑ ‑woo 'trɔnkpa ‑Waanbhaa' a ‑jan 'ɛ ꞊la. ");
INSERT INTO moa_vpl VALUES ("LK5_2","072_5_2","LUK","5","2","2","‑Yitakoŋ plɛ dulale ‑yaa ‑yi 'ɛ 'lɛzi‑, 'bhɛɛ‑ kaadɛ mu 'la zinaa' ‑o ‑yi 'mu 'yaa‑ 'mu a kaadɛ yrɔ mu 'ɛ 'yigo‑ 'zi. ");
INSERT INTO moa_vpl VALUES ("LK5_3","072_5_3","LUK","5","3","3","Simɔ a pɛ ‑yaa 'woo‑ ‑yitakoŋ mu 'ɛ do 'le, Zesu ‑ja yaalɛ 'bhɛ 'yi. 'Bhɛɛ‑ ‑e pe Simɔ ni dɔɔ 'bhɛ ‑yitakoŋ 'ɛ 'pleŋgo sa ‑yi 'ɛ 'lɛ ma. 'Bhɛ klɛle 'tɛ, 'kee‑ mɛɛ mu 'ɛ daanle 'sanle ‑Jan 'Nrale‑ 'ɛ 'le. ");
INSERT INTO moa_vpl VALUES ("LK5_4","072_5_4","LUK","5","4","4","'Bhɛ blaan 'ke ‑ya pele‑ Simɔ ni dɔɔ: «‑Yitakoŋ 'ɛ 'mabɛɛn‑ ‑yi 'ɛ drɛyi', 'bhɛɛ‑ 'bhi 'pegee 'yaa‑ kaadɛyɔɔn mu 'ɛ, ‑ka 'kaa‑ kaadɛ yrɔ mu 'ɛ bɔ ‑yi 'ɛ ba.» ");
INSERT INTO moa_vpl VALUES ("LK5_5","072_5_5","LUK","5","5","5","'Bhɛ klɛle 'tɛ, 'ke Simɔ 'a 'pele ‑a ni dɔɔ: «'O Zan, 'o ꞊bwa yrɔ bɔle ma ‑bi 'lɛɛ‑ 'kpɛn zi, 'bhɛɛ‑ 'waa kaa do 'kpɔ 'kunlɛ‑. 'Duŋ‑ 'bhi 'a 'pelawoa 'mi ni 'kaa 'mi 'an yrɔ 'ɛ bɔ, 'ŋ nu a klɛlɛ 'e 'liiwli‑ ta.» ");
INSERT INTO moa_vpl VALUES ("LK5_6","072_5_6","LUK","5","6","6","‑O yrɔ mu 'ɛ bɔle, 'kee‑ 'mu kaa 'kunle 'ebebele 'kee‑ kan ‑a ‑daŋ' ta, ‑asiikɔɔ kaa mu 'ɛ 'yaa‑ zan yrɔ mu 'ɛ 'peedɛlɛ. ");
INSERT INTO moa_vpl VALUES ("LK5_7","072_5_7","LUK","5","7","7","‑Ayile, 'ke Simɔ 'pegee ‑yaa' kaadɛyɔɔn mu 'ɛ ‑o kaadɛ mu ‑bhɛɛke' mu 'la 'yaa‑ ‑yitakoŋ ‑vindo' 'ɛ 'yi 'mu 'siile, 'kaa 'mu 'nu 'bhɔ ‑o ba. 'Bhɛ mu nule 'tɛ 'ke ‑o 'koŋ plɛ 'ɛ 'pale 'ke kaa 'le ‑asiikɔɔ ‑yitakoŋ plɛ 'ɛ 'yaa‑ zan wlalɛ ‑yi 'ɛ ꞊la kaa gbiŋ 'ɛ 'kɔɔ. ");
INSERT INTO moa_vpl VALUES ("LK5_8","072_5_8","LUK","5","8","8","'Bhɛ 'yi 'tɛ, Simɔ Piɛri 'yrɛkpale 'bhɛ ma, 'ke ‑ya 'kpɔ zɛnle‑ Zesu 'lɛɛ, 'bhɛɛ‑ 'ke ‑ya pele‑ dɔɔ: «Mɛɛzan, 'e 'pleŋgo 'ŋ ma, ‑amasrɔyi 'ŋ 'yoo‑ 'ke ‑za 'yɔɔ‑ klɛ mi 'le.» ");
INSERT INTO moa_vpl VALUES ("LK5_9","072_5_9","LUK","5","9","9","Wlan 'gbu 'ɛ ni, ‑gblaan ꞊klaa 'yee‑ Simɔ 'pegee ‑a zi mu 'ɛ 'kpɛn 'yi, ‑o kaa ‑bebe 'la ꞊kwan 'bhɛ ‑zayi'. ");
INSERT INTO moa_vpl VALUES ("LK5_10","072_5_10","LUK","5","10","10","'Bhɛɛ‑ 'kee‑ kpa ‑yaa' kaadɛyɔɔn mu Zebede gbe plɛ 'ɛ 'mu ta, Zaki 'pegee Zaan, ‑gblaan ꞊klaa 'mu 'yi 'ezin‑. ‑Ayile, 'ke Zesu 'a 'pele Simɔ ni dɔɔ: «'Yaa ‑gblaanlɛ', 'kee‑ san ‑zɔn ma, 'e nu mɛɛ ‑bebe 'srɔɔwolɛ ‑Waanbhaa' ni 'bhii‑ 'e kaa mu kun 'ebebele gɔnɛ‑ 'la gbɛɛn‑.» ");
INSERT INTO moa_vpl VALUES ("LK5_11","072_5_11","LUK","5","11","11","'Bhɛ klɛle 'tɛ, 'ke ‑o ‑waa' ‑yitakoŋ mu 'ɛ 'pwɛle ‑yi 'ɛ ba, 'bhɛɛ‑ 'ke ‑woo dulale 'trɛ ma. 'Bhɛ blaan, 'ke ‑woo 'kpɛn 'tole ‑a nɔɔ‑, 'bhɛɛ‑ 'ke ‑o gele‑ dɔlɛ Zesu zi. ");
INSERT INTO moa_vpl VALUES ("LK5_12","072_5_12","LUK","5","12","12","Zesu 'bhɔle‑ ‑wa do ta, 'ke ‑kpaandɛ' mi do nule‑ ‑a ba. ‑Kpaandɛ' mi 'ɛ 'yrɛkpale Zesu ma, 'ke ‑ya 'kpɔ zɛnle‑ Zesu 'lɛɛ, 'bhɛɛ‑ 'kee‑ ‑sromabɔle 'bhɛ ni dɔɔ: «Mɛɛzan, 'kee‑ ꞊swa 'e ni, 'ŋ ma ‑kpaan 'ɛ go.» ");
INSERT INTO moa_vpl VALUES ("LK5_13","072_5_13","LUK","5","13","13","'Bhɛ klɛle 'tɛ, 'ke Zesu 'e gbɛ 'trole ‑a ba, 'ke 'ya gbɛkpale ‑a ma, 'bhɛɛ‑ 'ke ‑ya pele‑ dɔɔ: «'Ŋ 'yoo‑ ‑a zi 'bhii‑ 'e 'bhee‑, 'e ma ‑kpaan 'ɛ ‑gwa!» 'Bhɛ yrɛ do 'ɛ ꞊nɔɔ bhe, 'ke 'yee‑ mɛɛ 'ɛ ma ‑kpaan 'ɛ gole‑. ");
INSERT INTO moa_vpl VALUES ("LK5_14","072_5_14","LUK","5","14","14","‑Ayile, 'ke Zesu 'a 'pele ‑a ni dɔɔ: «'Yaa 'e 'bheeza‑ 'ɛ 'pelɛ‑ mɛɛ 'kedo‑ 'kpɔ ni. 'Duŋ‑ ge 'e 'gbu mazrɔn 'sraka 'lɛna mi 'ɛ ni. 'Bhɛɛ‑ *Moizi ‑kpaandɛ' mu ‑bheeza' 'sraka 'la ‑dwa 'bhɛ 'sraka 'ɛ go, 'kooko‑ mɔkpɛn' 'a 'yaango‑ 'bhii‑ 'e ma ‑kpaan 'ɛ ‑gwa.» ");
INSERT INTO moa_vpl VALUES ("LK5_15","072_5_15","LUK","5","15","15","'Bhɛ ꞊nɔɔ bhe, Zesu 'tɔbhɔleya 'ɛ baan' ꞊klaa ba yrɛkpɛn‑ ꞊nɔɔ, ‑asiikɔɔ mɛɛ ‑bebe 'yaa‑ zan ‑o 'trɔnkpalɛ ‑a ni. 'Bhɛɛ‑ mɛɛ 'ke mu ‑yaa zan 'mu ma ga mu 'ɛ goza 'yi. ");
INSERT INTO moa_vpl VALUES ("LK5_16","072_5_16","LUK","5","16","16","'Bhɛɛ‑ 'duŋ‑, 'yee‑ Zesu 'yaa‑ 'pleŋgo‑ ‑zamaa' 'ɛ ma 'waati 'ke ba. 'Bhɛɛ‑ ‑a do ‑kplɛn 'yaa‑ ge ‑bɔn 'ɛ drɛyi' ‑a 'seriwolɛ. ");
INSERT INTO moa_vpl VALUES ("LK5_17","072_5_17","LUK","5","17","17","‑Yrekpaa' do, Zesu 'yaa‑ mɛɛ 'ɛ mu daan 'zi. Farizi mu 'pegee 'Toŋ daan mu 'ɛ 'yaale‑ ‑yaa ‑a ‑din. ‑O ‑daa Galile 'pegee Zude 'klɛɛn mu 'ɛ ‑yi ‑wa mu 'ɛ 'kpɛn ta, 'bhɛ 'pegee Zeruzalɛmu. Mɛɛzan ‑Waanbhaa' a ‑glɔɔya' 'la 'yaa‑ Zesu ta, 'bhɛla‑ ‑yile ‑e ‑yaa gadɛ mu 'ɛ ‑bhee 'zi. ");
INSERT INTO moa_vpl VALUES ("LK5_18","072_5_18","LUK","5","18","18","'Bhɛ 'yi 'tɛ, 'ke mɛɛ 'ke mu nule‑ ‑flugba do 'le 'bhɛ 'yilapɛ 'ɛ ta. ‑O ‑yaa wlayrɛ ‑glin 'zi ‑zamaa' mu 'ɛ 'pleŋ‑, 'kooko‑ ‑o sɔ gele‑ 'yee‑ ‑flugba 'ɛ 'kpaalɛ‑ Zesu ꞊la. ");
INSERT INTO moa_vpl VALUES ("LK5_19","072_5_19","LUK","5","19","19","'Duŋ‑ waa wlayrɛ ‑srɔɔwolɛ mɛɛ mu 'ɛ 'kɔɔ. ‑Ayile, 'ke ‑o 'sanle 'kɛle‑ 'fɛ 'la Zesu 'yaa‑ 'bhɛ ꞊la 'bhɛ 'wiiŋ‑. 'Bhɛɛ‑ 'ke ‑woo wlayrɛ do klɛle‑ 'bhɛ 'wiiŋ‑. 'Bhɛ blaan 'ke ‑o ‑flugba 'ɛ 'kanle 'bhɛ yrɛ 'ɛ ꞊nɔɔ bhlɛ do ma, 'bhɛɛ‑ 'ke ‑wa zinale ‑o 'pegee ‑a yilapɛ 'ɛ 'le 'fɛ 'ɛ 'kpee Zesu ꞊la. ");
INSERT INTO moa_vpl VALUES ("LK5_20","072_5_20","LUK","5","20","20","Zesu 'a 'yele‑ 'bhii‑ ‑woo ‑kpaa 'bhɛ 'yi, 'ke ‑ya pele‑ ‑flugba 'ɛ ni dɔɔ: «'Ŋ 'bhɛgwlɛn‑, 'ŋ 'yaa‑ ‑za 'yɔɔ‑ mu 'ɛ 'sroma‑ ‑yaan.» ");
INSERT INTO moa_vpl VALUES ("LK5_21","072_5_21","LUK","5","21","21","'Bhɛ klɛle 'tɛ, 'ke 'Toŋ daan mu 'ɛ 'pegee Farizi mu mu 'ɛ ‑wa pele 'sanle ‑o 'kpee dɔɔ: «‑Dele mɛɛ 'lɛɛ‑ 'le, 'bhɛɛ‑ ‑e ‑Waanbhaa' 'tɔsiɛ zii' ‑gee' ɛɛ? ‑De 'gbu ‑le sɔ mɛɛ mu a ‑za mu 'ɛ ‑sroma 'yanle 'ke yaa 'e go ‑Waanbhaa' do ‑kplɛn ba ɛɛ?» ");
INSERT INTO moa_vpl VALUES ("LK5_22","072_5_22","LUK","5","22","22","Zesu ‑o 'kpeejan‑ mu 'ɛ dɔle 'ke ‑ya pele‑ ‑o ni dɔɔ: «‑Mɛle ‑kla 'bhɛɛ‑ 'ka 'kpeejan‑ mu ‑o 'bhɛ gbɛɛn‑ ‑gee' ɛɛ?» ");
INSERT INTO moa_vpl VALUES ("LK5_23","072_5_23","LUK","5","23","23","'Bhɛɛ‑ 'woo‑ ‑za plɛ 'lɛɛ‑ ‑o ‑de 'gbu ‑la pele ‑o 'edile ɛɛ? 'Ke 'an ꞊pia ‑flugba ni dɔɔ: «'Ŋ 'yaa‑ ‑za 'yɔɔ‑ mu 'ɛ 'sroma‑ ꞊yaan, taa‑ 'ke 'an ꞊pia ‑a ni ‑ya wlɛn 'bhɛɛ‑ ‑e 'taawo ɛɛ? ");
INSERT INTO moa_vpl VALUES ("LK5_24","072_5_24","LUK","5","24","24","'Duŋ‑ 'ŋ 'yoo‑ ‑a zi 'bhii‑ 'kaa 'yaango‑ dɔɔ 'bhii‑ ‑a 'seŋ ‑o Bhaaplɛŋ Gbe 'ɛ ni 'trɛ ta ‑gɛ 'kee‑ mɛɛ mu a ‑za 'yɔɔ‑ mu ma ‑sroma yan.» 'Bhɛ klɛle 'tɛ, 'ke ‑ya pele‑ ‑flugba 'ɛ ni dɔɔ: «'Mi pe 'e ni dɔɔ 'e 'wlɛn‑, 'e 'yilapɛ 'ɛ 'si, 'bhɛɛ‑ ge 'e ba ‑lɛ ma.» ");
INSERT INTO moa_vpl VALUES ("LK5_25","072_5_25","LUK","5","25","25","'Bhɛ yrɛ do 'ɛ ꞊nɔɔ bhe, 'ke ‑flugba 'ɛ ‑ya ‑wlɛnle' mɛɛ mu 'ɛ 'kpɛn 'yrɛ ma, 'bhɛɛ‑ 'ke ‑ya yilapɛ 'ɛ 'sile, 'kee‑ gele‑ ‑a ba ‑lɛ ma ‑Waanbhaa' 'tɔbhɔlele. ");
INSERT INTO moa_vpl VALUES ("LK5_26","072_5_26","LUK","5","26","26","'Bhɛ 'yi 'tɛ, 'ke mɛɛ mu 'ɛ 'kpɛn 'kpeelɛnile ‑o ma. ‑Ayile, 'ke ‑gblaan 'klale ‑o ‑yi, 'bhɛɛ‑ 'ke ‑wa pele‑ dɔɔ: «'Waa 'bhɛ 'yansi 'sɔle‑ maza mu klɛyrɛ yelɛ ‑lido'.» ");
INSERT INTO moa_vpl VALUES ("LK5_27","072_5_27","LUK","5","27","27","'Bhɛ blaan, 'ke Zesu 'nisrakun mi do yaale yele‑ 'bhɛ a yewo 'fɛ 'ɛ ꞊la. ‑O ‑yaa 'bhɛ sii Levi. 'Bhɛ klɛle 'tɛ, 'ke Zesu 'a 'pele ‑a ni dɔɔ: «Nu dɔ 'ŋ zi!» ");
INSERT INTO moa_vpl VALUES ("LK5_28","072_5_28","LUK","5","28","28","'Bhɛ yrɛ do 'ɛ ꞊nɔɔ bhe, 'ke Levi 'e 'wlɛnle, 'kee‑ 'ploole ‑yaa' ye 'ɛ ma; 'bhɛɛ‑ 'kee‑ gele‑ dɔlɛ Zesu zi. ");
INSERT INTO moa_vpl VALUES ("LK5_29","072_5_29","LUK","5","29","29","'Bhɛ blaan, 'ke Levi Zesu 'lɛwɛɛ pɛ ‑koo ‑gbɛnɛ do klɛle‑ ‑a ba ‑lɛ ma. 'Bhɛɛ‑ 'kee‑ 'nisrakun mu ‑bebe 'pegee mɛɛ ‑bhɛɛke' mu 'siile 'yee‑ pɛle 'ɛ ma. ");
INSERT INTO moa_vpl VALUES ("LK5_30","072_5_30","LUK","5","30","30","‑Ayile, 'ke *Farizi mu 'ɛ 'pegee *'Toŋ daan mu 'ɛ ‑o ‑janwole ‑o ‑lɛla' Zesu ma, 'bhɛɛ‑ 'ke ‑o yaa ‑klaŋlanɛ mu 'ɛ 'lrɔkpale dɔɔ: «‑Mɛle ꞊kla 'bhɛɛ‑ 'ka mu 'pegee 'nisrakun mu, 'bhɛɛ‑ mɛɛ 'joo 'yɔɔ‑ mu 'ɛ 'ka ‑o pɛle 'zi 'eke‑ zi ɛɛ?» ");
INSERT INTO moa_vpl VALUES ("LK5_31","072_5_31","LUK","5","31","31","‑Ayile, 'ke Zesu 'a 'pele ‑o ni dɔɔ: «Mɛɛ 'klɛnyawole mu maza laa dɔ ‑laanɛkpa mi ma 'ke yaa 'e go gadɛ mu ba. ");
INSERT INTO moa_vpl VALUES ("LK5_32","072_5_32","LUK","5","32","32","'Naa 'nule‑ mɛɛ ‑lɛdɔɔle mu 'siiyrɛ‑ ꞊nɔɔ 'kaa ‑o nu ‑Waanbhaa' ba, 'duŋ‑ 'mi ꞊nwa ‑za 'yɔɔ‑ klɛ mu ‑la 'siilɛ‑, 'kooko‑ 'ke ‑zadɔwɛɛ ꞊dwa ‑o ma waa ‑za 'yɔɔ‑ mu 'ɛ 'yi, ‑o ploo waa ‑za 'yɔɔ‑ mu 'ɛ ma.» ");
INSERT INTO moa_vpl VALUES ("LK5_33","072_5_33","LUK","5","33","33","Mɛɛ 'ke mu pe Zesu ni 'ezin‑ dɔɔ: «Mɛɛ Wiiŋfɛ' Mi Zaan a pɛ ‑klaŋlanɛ mu 'ɛ 'pegee Farizi mu 'ɛ 'mu a ‑klaŋlanɛ mu 'ɛ 'mu 'suŋwla‑, 'bhɛɛ‑ 'mu 'e 'seriwo 'ebebele, 'bhɛɛ‑ 'duŋ‑ 'bhi a pɛ ‑klaŋlanɛ mu 'ɛ 'mu bole ‑o pɛbhlele 'pegee ‑yi 'bhile‑ 'te ‑la ma.» ");
INSERT INTO moa_vpl VALUES ("LK5_34","072_5_34","LUK","5","34","34","'Bhɛ klɛle 'tɛ, 'ke Zesu 'a 'pele ‑o ni dɔɔ: «'Ke ‑o mɛɛ mu ‑siila le do dɔyrɛ ꞊nɔɔ, 'ka 'kpee ma ‑o sɔ 'suŋwlale 'ke ‑woo ‑o bhɛgwlɛn le ‑nɔɔ 'ɛ ‑din 'waati 'la ba ɛɛ? ");
INSERT INTO moa_vpl VALUES ("LK5_35","072_5_35","LUK","5","35","35","'Duŋ‑ 'ke le drɛɛ ‑nɔɔ 'ɛ ‑gwa ‑o ‑din 'waati 'la ba, ‑o nu 'sɔlɛ‑ 'suŋwlale 'tɛ.» ");
INSERT INTO moa_vpl VALUES ("LK5_36","072_5_36","LUK","5","36","36","'Bhɛ 'yi 'tɛ, 'ke Zesu ‑gɔɔn do bɔle‑ ‑o ni 'ezin‑ dɔɔ: «Mɛɛ do 'kpɔ laa sɔ sɔpee' 'nɛ do 'kanle ‑yaa' dunɛ‑ drɛɛ 'ɛ ma, 'bhɛɛ‑ ‑e yaa ‑dunɛ gwe 'ɛ 'yisra‑ 'bhɛ 'le. 'Kee‑ 'bhɛ ꞊kla, ‑e nu dunɛ‑ drɛɛ 'ɛ 'peedɛlɛ, 'bhɛɛ‑ sɔpee' drɛɛ 'ɛ yaa gaa dunɛ‑ gwe 'ɛ ta. ");
INSERT INTO moa_vpl VALUES ("LK5_37","072_5_37","LUK","5","37","37","'Bhɛɛ‑ 'ezin‑, mɛɛ 'kedo‑ 'kpɔ 'laa ‑wɛɛn drɛɛ kla wi 'flɛ 'floko gwe mu 'yi. 'Kee‑ 'bhɛ ꞊kla, ‑wɛɛn drɛɛ 'ɛ 'plii bhla 'ɛ zi, ‑e nu wi 'flɛ 'floko gwe mu 'ɛ 'peedɛlɛ, 'bhɛɛ‑ ‑e klalaa' 'trɛ ma, 'bhɛɛ‑ 'woo‑ 'floko mu 'ɛ ‑o 'gbu klɛ 'siɛ pɛ 'le 'bhɛ klɛgbɛya 'ɛ gbɛɛn‑ bhe. ");
INSERT INTO moa_vpl VALUES ("LK5_38","072_5_38","LUK","5","38","38","'Duŋ‑ ‑o sɔ ‑wɛɛn drɛɛ 'klale 'floko drɛɛ mu ‑la ‑yi. ");
INSERT INTO moa_vpl VALUES ("LK5_39","072_5_39","LUK","5","39","39","'Ezin‑, mɛɛ 'kedo‑ 'kpɔ 'laa dɔ ‑wɛɛn drɛɛ mile ‑la 'kee‑ ‑yaan ‑wɛɛn gwe mile 'le gban. ‑Amasrɔyi mɔkpɛn' 'a pe dɔɔ: ‹‑Wɛɛn gwe ‑lrele' ‑yiya' ‑wɛɛn drɛɛ ni.›» ");
INSERT INTO moa_vpl VALUES ("LK6_1","072_6_1","LUK","6","1","1","‑Yitrɛ' yi do ma, Zesu 'pegee ‑yaa' *‑klaŋlanɛ mu 'ɛ 'yaa‑ 'kan zii' ble gba do 'yi. 'Bhɛ 'yi bhe, 'ke ‑yaa' ‑klaŋlanɛ mu 'ɛ dɔle‑ ble (ble 'ɛ ‑yoo 'bhii‑ ‑mlɔ gbɛɛn) pɛbhɛ mu 'ɛ 'srɔnle‑ ma ‑o ‑vlɔ mu 'ɛ ma. ‑O ‑yaa 'bhɛ pɛbhɛ mu 'ɛ ‑glɔɔ 'zi ‑o 'kɔɔ, 'ke ‑woo kloo mu 'ɛ go ‑a bhɛ mu 'ɛ ma, 'bhɛɛ‑ ‑woo bhle. ");
INSERT INTO moa_vpl VALUES ("LK6_2","072_6_2","LUK","6","2","2","'Bhɛ klɛle 'tɛ, 'ke Farizi mu 'ke mu 'a 'lrɔkpale dɔɔ: «‑Mɛla ma waa ‑za 'la 'bhɛ klɛ ‑yitrɛ' yi ma, 'ka mu ‑o 'bhɛɛ‑ klɛ 'zi ɛɛ?» ");
INSERT INTO moa_vpl VALUES ("LK6_3","072_6_3","LUK","6","3","3","Zesu pe Farizi mu 'ɛ ni dɔɔ: «Gbɔn ‑bhleŋgbe *Davidi 'gbu 'pegee ‑a zi mu 'ɛ ꞊dia ‑yrekpaa' do, 'bhɛɛ‑ ‑o ‑za 'la 'bhɛ ꞊kla 'ka 'laa 'bhɛ tapelɛ ‑lido' ɛɛ? ");
INSERT INTO moa_vpl VALUES ("LK6_4","072_6_4","LUK","6","4","4","'Ŋ bhe, ‑e ‑wlaa ‑Waanbhaa' Gba 'Fɛ 'ɛ ꞊la, 'bhɛɛ‑ ‑o 'sraka ‑gwa ‑Waanbhaa' ni 'bluu mu 'la 'le, ‑e 'mu ꞊sia. 'Bhɛɛ‑ ‑yoo ꞊bhla, 'bhɛɛ‑ ‑yoo 'ke ꞊naa ‑a zi mu 'ɛ ni. 'Duŋ‑ ‑kɔɔa' 'toŋ 'ɛ ta, yaa dɔ mɛɛ ‑bhɛɛke' do kpɔ 'kpee 'ke 'bhɛ 'bhɛ 'bluu mu 'ɛ bhle, 'ke yaa 'e go *'sraka 'lɛna mu do ‑kplɛn ‑la ba.» ");
INSERT INTO moa_vpl VALUES ("LK6_5","072_6_5","LUK","6","5","5","Zesu pe ‑o ni 'ezin‑ dɔɔ: «*Bhaaplɛŋ Gbe 'ɛ 'ke ‑ya ꞊pia ‑o ‑za 'oo ‑za 'la klɛ ‑yitrɛ' yi 'ɛ ma, ‑o 'bhɛɛ‑ ‑klɔsikun.» ");
INSERT INTO moa_vpl VALUES ("LK6_6","072_6_6","LUK","6","6","6","‑Yitrɛ' yi ‑bhɛɛke' do ma, 'ke Zesu gele‑ wlalɛ *Zuufu mu daanfɛ' 'ɛ ꞊la. 'Bhɛɛ‑ 'kee‑ mɛɛ mu daanle 'sanle ‑Jan 'Nrale‑ 'ɛ 'le. 'Duŋ‑ mɛɛ gbɛ ‑yiɛ' 'kwlanle‑ do ‑yaa mɛɛ mu 'ɛ 'pleŋ‑ 'bhɛ 'fɛ 'ɛ ꞊la. ");
INSERT INTO moa_vpl VALUES ("LK6_7","072_6_7","LUK","6","7","7","'Toŋ daan mu 'ɛ 'pegee Farizi mu 'ɛ ‑o ‑yaa zi 'bhii‑ ‑o ‑la yrɛ ‑srɔɔwo' Zesu ta, 'ke 'bhɛ 'yee‑ mɛɛ 'ɛ 'bheela‑ ‑yitrɛ' yi 'ɛ ma. 'Bhɛla‑ ‑zɛɛle, ‑o ‑yaa ‑a 'klɔsikun zii' ‑a klɛza mu 'ɛ ma. ");
INSERT INTO moa_vpl VALUES ("LK6_8","072_6_8","LUK","6","8","8","'Duŋ‑ Zesu ‑o 'kpeejan‑ mu 'ɛ dɔle, 'ke ‑ya pele‑ mɛɛ gbɛ 'kwlanle‑ 'ɛ ni dɔɔ: «'E 'wlɛn‑, 'bhɛɛ‑ nu dula‑ mɔkpɛn' 'yrɛ ꞊la ‑gɛ doo!» 'Bhɛ klɛle 'tɛ, 'ke 'yee‑ mɛɛ 'ɛ ‑ya ‑wlɛnle' 'bhɛɛ‑ 'kee‑ nule‑ dulalɛ ‑o 'kpɛn 'yrɛ ꞊la. ");
INSERT INTO moa_vpl VALUES ("LK6_9","072_6_9","LUK","6","9","9","'Bhɛɛ‑ 'ke Zesu ‑o ‑lrɔkpale dɔɔ: «‑Kɔɔa' 'toŋ 'ɛ ta, mɛɛ sɔ ‑za 'wlan klɛle‑ taa‑ ‑e sɔ ‑za 'yɔɔ‑ klɛle‑ ‑yitrɛ' yi 'ɛ ma ɛɛ? 'Bhɛɛ‑ mɛɛ sɔ mɛɛ ‑bheele' ‑yitrɛ' yi 'ɛ ma, taa‑ mɛɛ sɔ mɛɛ dɛle‑ 'yee‑ yi 'ɛ ma ɛɛ?» ");
INSERT INTO moa_vpl VALUES ("LK6_10","072_6_10","LUK","6","10","10","Zesu 'e 'yrɛkpaa‑ ‑o ta frii, 'bhɛɛ‑ 'ke ‑ya pele‑ mɛɛ gbɛ 'kwlanle‑ 'ɛ ni dɔɔ: «'E gbɛ 'ɛ 'yisrɔn!» ‑Ya gbɛ 'ɛ 'yrɔnle‑ 'ke 'bhɛ 'lɛdɔɔle. ");
INSERT INTO moa_vpl VALUES ("LK6_11","072_6_11","LUK","6","11","11","'Bhɛ klɛle 'tɛ, 'ke 'Toŋ daan mu 'ɛ 'pegee Farizi mu 'ɛ ‑woo zrupliile. 'Bhɛɛ‑ ‑o ‑yaa nu 'sɔlɛ‑ ‑za ‑glɔɔn 'la klɛle‑ ‑a ni, ‑woo 'eke‑ ‑lrɔkpale ‑saan 'bhɛ 'yi. ");
INSERT INTO moa_vpl VALUES ("LK6_12","072_6_12","LUK","6","12","12","'Bhɛ 'waati 'ɛ ba, 'ke Zesu gele‑ ‑a 'seriwoyrɛ nɔɔ‑ gɔɔn do 'wiiŋ‑. 'Bhɛɛ‑ ‑e ꞊bwa ‑a 'seriwole ma ‑Waanbhaa' ni ‑bi 'ɛ 'kpɛn zi. ");
INSERT INTO moa_vpl VALUES ("LK6_13","072_6_13","LUK","6","13","13","Too ‑klinle', 'kee‑ ‑yaa' ‑klaŋlanɛ mu 'ɛ 'siile, 'ke ‑ya vu ta plɛ makunle ‑o ba, 'bhɛɛ‑ 'kee‑ 'mu klɛle‑ ‑yaa' *winbɔwo mu 'le. ");
INSERT INTO moa_vpl VALUES ("LK6_14","072_6_14","LUK","6","14","14","'Woo‑ mɛɛ vu ta plɛ 'ɛ 'wo ‑le ‑gɛ: Simɔ 'la ‑e 'bhɛ 'tɔkpaa‑ Piɛri, 'bhɛ 'pegee 'bhɛ nɛɛnɛ‑ Andre, Zaki 'pegee Zaan, 'bhɛɛ‑ Filipu 'pegee Batremi. ");
INSERT INTO moa_vpl VALUES ("LK6_15","072_6_15","LUK","6","15","15","Matie 'pegee Toma, 'bhɛɛ‑ Alife gbe Zaki 'pegee Simɔ 'la ‑o ‑yaa 'bhɛ sii Zelɔti, 'bhɛ 'yi ‑le dɔɔ mɛɛ 'la zan ‑yaa 'bhɛ a 'klɛɛn 'ɛ ‑vavadɛ 'egbɛnɛle. ");
INSERT INTO moa_vpl VALUES ("LK6_16","072_6_16","LUK","6","16","16","'Bhɛɛ‑ Zaki gbe Zudi, 'bhɛ 'pegee Zuda Isikariɔti, mɛɛ 'la zan ‑dawli' ꞊kpaa Zesu gbɛ ta, 'bhɛɛ‑ ‑ya ‑lɛnaa ‑a ‑sɔɔnnii' mu 'ɛ ni. ");
INSERT INTO moa_vpl VALUES ("LK6_17","072_6_17","LUK","6","17","17","Zesu 'pegee ‑yaa' *‑klaŋlanɛ mu ‑o ‑gwa gɔɔn 'ɛ 'wiiŋ‑, 'bhɛɛ‑ ‑o ‑nwa dulalɛ gɔɔn 'ɛ kpɛla‑. ‑Yaa' ‑klaŋlanɛ ‑vin 'srɛ mu 'ɛ 'pegee ‑zamaa' 'saa do ‑yaa ‑o zi 'bhɛ yrɛ 'ɛ 'nɔɔ‑. 'Woo‑ mɛɛ 'srɛ mu ‑o dayrɛ 'ɛ ꞊yaa 'ebebele: ‑o 'ke mu ‑daa Zude 'klɛɛn 'yi, ‑a 'ke ‑daa Zeruzalɛmu, 'bhɛɛ‑ ‑a 'ke mu ‑daa wɛyi‑ 'lɛ ma ‑wa mu 'ɛ ta, Tiri 'pegee Sidɔn. ");
INSERT INTO moa_vpl VALUES ("LK6_18","072_6_18","LUK","6","18","18","‑O 'kpɛn ꞊nwa ‑o 'trɔnkpalɛ Zesu 'wojan‑ mu 'ɛ ꞊la, 'bhɛ 'pegee ‑o 'ke mu ꞊nwa 'mu ma ga mu go zayi'. 'Bhɛɛ‑ 'zina mu 'yaa‑ mɛɛ 'la zan mu zi, ‑e 'zina mu 'ɛ ꞊gbian 'bhɛ zan mu 'ɛ zi. ");
INSERT INTO moa_vpl VALUES ("LK6_19","072_6_19","LUK","6","19","19","'Sɔleya ma faŋgan‑ do ‑yaa da 'zi Zesu 'flɛ 'ɛ 'yi, 'bhɛɛ‑ 'ke gadɛ mi 'oo gadɛ mi 'la ꞊yaa yan ‑a ma, 'bhɛ ꞊yaa bhee. 'Bhɛla‑ ‑yile, ‑zamaa' 'ɛ 'kpɛn ꞊yaa zi 'bhii‑ ‑o yan ‑a ma ‑o ‑bhee zayi'. ");
INSERT INTO moa_vpl VALUES ("LK6_20","072_6_20","LUK","6","20","20","Zesu 'e 'yrɛkpale ‑yaa' ‑klaŋlanɛ mu 'ɛ ta, 'ke ‑ya pele‑ ‑o ni dɔɔ: «'Ka mu 'la 'ka ‑o 'ke 'kɔɔfleŋzan mu 'le, 'kaa‑ pɛ ‑yinra'! ‑Amasrɔyi 'kaa pɛ ‑le 'ke *‑Waanbhaa' a ‑bhleŋgbeya ‑wa 'ɛ 'le. ");
INSERT INTO moa_vpl VALUES ("LK6_21","072_6_21","LUK","6","21","21","Gbɔn ‑o 'ka mu 'la dɛ 'zi ‑zɔn, 'kaa‑ pɛ ‑yinra'! ‑Amasrɔyi 'ka nu pɛle ‑bebe 'srɔɔwolɛ 'kee‑ pa 'ka ta. 'Bhɛɛ‑ 'ka mu 'la 'ka ‑o wisi' zii' ‑zɔn, 'kaa‑ pɛ ‑yinra'! ‑Amasrɔyi 'ka nu 'sɔnsilɛ.» ");
INSERT INTO moa_vpl VALUES ("LK6_22","072_6_22","LUK","6","22","22","«Mɛɛ mu ‑o 'ka mu 'la mafinyanwo zii', 'bhɛɛ‑ ‑woo ‑baŋgo' zii' 'ka 'yi, 'ke ‑o 'ka ‑zwanwo', 'bhɛɛ‑ ‑o 'ka 'tɔsiɛ zii' 'mi Bhaaplɛŋ Gbe 'ɛ 'tɔ 'ɛ ‑zayi', 'kaa‑ pɛ ‑yinra'! ");
INSERT INTO moa_vpl VALUES ("LK6_23","072_6_23","LUK","6","23","23","'Ke ‑o 'bhɛ ꞊kla 'ka ni bhla 'la ba, ‑ka 'ka zrukpala 'egbɛnɛle 'kee‑ kan ‑a ‑daŋ' ta. ‑Amasrɔyi, ‑trɔn ‑gbɛnɛ do ‑o 'ka 'magbɛn‑ 'zi laflɛ' yi. ‑O ‑taa mu ‑yrɛnkpaa ‑Waanbhaa' ‑lɛla' janwo mu 'ɛ ta 'elwale ‑sɔ 'bhɛɛ‑ gbɛɛn‑. ");
INSERT INTO moa_vpl VALUES ("LK6_24","072_6_24","LUK","6","24","24","'Duŋ‑ 'ka mu ‑naflo zan mu, 'ka ta ‑yrɛn! ‑Amasrɔyi 'ka mu 'kaa‑ pɛ ‑za 'wlan 'ɛ 'srɔɔwoa‑ gban ‑gɛ. ");
INSERT INTO moa_vpl VALUES ("LK6_25","072_6_25","LUK","6","25","25","'Ka mu 'la kpɛdɔle ‑o ‑zɔn, 'ka ta ‑yrɛn! ‑Amasrɔyi gbɔn nu 'ka dɛlɛ! 'Ka mu 'la 'ka ‑o 'sɔnsi zii' ‑zɔn, 'ka ta ‑yrɛn! ‑Amasrɔyi ga nu 'kpalɛ‑ 'ka ta, 'bhɛɛ‑ 'ka wisi. ");
INSERT INTO moa_vpl VALUES ("LK6_26","072_6_26","LUK","6","26","26","«'Ka ta ‑yrɛn! 'Ke mɔkpɛn' 'ka ma jan ‑lrele' ꞊woa. ‑Amasrɔyi ‑o ‑taa mu ‑yaa klɛ 'bhɛɛ‑ gbɛɛn‑ 'elwaleta bhla ma ‑Waanbhaa' ‑lɛla' janwo mu 'ɛ ni.» ");
INSERT INTO moa_vpl VALUES ("LK6_27","072_6_27","LUK","6","27","27","Zesu pe 'ezin‑ dɔɔ: «'Ka mu 'la 'ka 'kpɛn ‑o 'ka 'trɔnkpa zii' 'mi ni ‑gɛ bhe, 'mi pe 'ka mu ni dɔɔ 'ka 'sɔɔnnii mu ‑za 'sɔ 'ka ni. ‑Ka ‑za 'wlan klɛ 'ka vɛnsi mɛɛ 'la zan mu yin 'lii 'mu ni. ");
INSERT INTO moa_vpl VALUES ("LK6_28","072_6_28","LUK","6","28","28","'Ke mɛɛ 'la zan mu 'ka 'daŋganwoa ‑ka 'dumawo 'bhɛ zan mu 'ɛ ni. 'Bhɛɛ‑ mɛɛ 'la zan mu ‑o ‑yrɛnkpa' zii' 'ka ta, ‑ka 'ka 'seriwo 'mu a ‑za ma. ");
INSERT INTO moa_vpl VALUES ("LK6_29","072_6_29","LUK","6","29","29","'Ke mɛɛ do 'e 'trɔn do ‑dwa, 'e 'trɔn gbɛ do 'ɛ 'bhɛ dɔ ‑a ni 'bhɛɛ‑ ‑ya zɔn. 'Ke mɛɛ do 'yaa‑ dunɛ‑ tralapɛ 'ɛ ꞊sia, ‑a 'to 'bhɛɛ‑ ‑e 'yaa‑ dunɛ‑ 'ɛ 'gbu 'si 'ezin‑. ");
INSERT INTO moa_vpl VALUES ("LK6_30","072_6_30","LUK","6","30","30","'Ke mɛɛ 'oo mɛɛ 'la zan pɛ do ‑yrɛwoa 'e ma, 'yaa 'e ‑gbɛdɔlɛ 'bhɛ 'nale‑ ma ‑a ni. 'Bhɛɛ‑ 'ke ‑o pɛ do ꞊sia 'e 'kɔɔ, 'yaa 'bhɛ pɛ 'ɛ ‑zapelɛ 'bhɛ zan ma. ");
INSERT INTO moa_vpl VALUES ("LK6_31","072_6_31","LUK","6","31","31","'Kaa‑ zi 'bhii‑ mɛɛ mu ‑za yɛkɛ‑ 'la klɛ 'ka mu ni 'ka mu 'bhɛɛ‑ yɛkɛ‑ za klɛ 'bhɛ zan mu 'ɛ ni. ");
INSERT INTO moa_vpl VALUES ("LK6_32","072_6_32","LUK","6","32","32","'Ke 'ka ‑za sɔ mɛɛ 'la zan mu ni, 'ke 'bhɛ zan mu 'te ‑la ‑za sɔ 'ka ni, 'bhɛ ‑trɔn ‑o 'ka ma ‑mɛla ‑le ɛɛ? 'Ali‑ *‑za 'yɔɔ‑ klɛ mu 'ɛ ‑za sɔ mɛɛ 'la zan mu ni, 'mu ‑la ‑za sɔ ‑o ni ");
INSERT INTO moa_vpl VALUES ("LK6_33","072_6_33","LUK","6","33","33","'Bhɛɛ‑ 'ke 'ka ‑za 'wlan klɛ mɛɛ 'la zan mu do ‑kplɛn ‑za 'wlan klɛ 'ka ni 'te, 'bhɛ 'trɔn ‑o 'ka ma ‑mɛla ‑le ɛɛ? 'Ali‑ ‑za 'yɔɔ‑ klɛ mu 'a klɛ 'bhɛɛ‑ gbɛɛn‑. ");
INSERT INTO moa_vpl VALUES ("LK6_34","072_6_34","LUK","6","34","34","'Bhɛɛ‑ 'ezin‑, 'ke 'kaa 'yaango‑ 'bhii‑ mɛɛ 'la zan mu nu 'sɔlɛ‑ 'kaa‑ ca 'ɛ gbawole 'ka ca kpa 'bhɛ zan mu ‑la ma, 'bhɛ ma ‑trɔn ‑o 'ka ma ‑mɛla ‑le ɛɛ? 'Ali‑ ‑za 'yɔɔ‑ klɛ mu ca kpa mɛɛ 'la zan mu sɔ ‑waa' ca 'ɛ gbawole 'mu ‑la ma. ");
INSERT INTO moa_vpl VALUES ("LK6_35","072_6_35","LUK","6","35","35","'Duŋ‑ 'ka mu, 'ka 'sɔɔnnii mu ‑za 'sɔ 'ka ni. 'Bhɛɛ‑ ‑ka ‑za 'wlan klɛ ‑o ni. ‑Ka ca 'kpa mɛɛ mu ma, 'bhɛɛ‑ 'ka zru laa bolɛ a ni. 'Ka nu ‑trɔn ‑gbɛnɛ do ‑srɔɔwolɛ, 'bhɛɛ‑ 'ka nu klɛlɛ laanima ‑Waanbhaa' ‑nɛ mu 'le. ‑Amasrɔyi ‑yoo 'ewlanle mɛɛ kloo 'pegee mɛɛ yiɛnle mu ma. ");
INSERT INTO moa_vpl VALUES ("LK6_36","072_6_36","LUK","6","36","36","Mɛɛ ‑yrɛnkla' 'ka ma, 'bhii‑ mɛɛ ‑yrɛnkla' 'ka Dɛ ‑Waanbhaa' ma gɔnɛ‑ 'la gbɛɛn‑.» ");
INSERT INTO moa_vpl VALUES ("LK6_37","072_6_37","LUK","6","37","37","Zesu pe 'ezin‑ dɔɔ: «'Ka 'laa 'eke‑ 'tɔpelɛ, 'kooko‑ waa 'ka mu 'tɔpe 'ezin‑. 'Ka 'laa 'lalɛ‑ 'eke‑ ta, 'kooko‑ waa nu ‑lalɛ' 'ka mu ta 'ezin‑. ‑Ka 'eke‑ a ‑sroma 'yan, 'bhɛɛ‑ ‑Waanbhaa' nu 'kaa ‑sroma 'yanlɛ‑. ");
INSERT INTO moa_vpl VALUES ("LK6_38","072_6_38","LUK","6","38","38","‑Ka 'ka ‑vin mu gba pɛ ba, 'bhɛɛ‑ ‑Waanbhaa' nu 'ka mu gbalɛ pɛ ba 'ezin‑. 'Ka pɛ yɛkɛ‑ 'la ꞊naa mɛɛ mu ni, ‑Waanbhaa' nu 'bhɛɛ‑ yɛkɛ‑ pɛ 'ɛ 'nalɛ‑ 'ka ni. ‑Yoo 'bhii‑ 'kee‑ mɛɛ gba pɛ ba 'ebebele, 'e 'bhɛ pɛ 'ɛ kla pɛdanpɛ do 'yi, 'bhɛɛ‑ 'e 'bhɛ pa. 'Bhɛɛ‑ 'ya tagbaan 'fɔ 'kee‑ ge 'tɛnlɛ‑ 'yee‑ pɛdanpɛ 'ɛ 'pale‑ ma, 'bhɛɛ‑ 'yee‑ pɛ 'ɛ 'ke klalaa'. 'Bhɛ klɛgbɛya do 'ɛ 'yi bhe, 'kaa‑ pɛ nagbɛya 'ɛ mɛɛ mu ni, ‑Waanbhaa' nu 'bhɛɛ‑ wlata pɛ nalɛ 'ka mu ni 'ezin‑.» ");
INSERT INTO moa_vpl VALUES ("LK6_39","072_6_39","LUK","6","39","39","'Bhɛ blaan, 'ke Zesu ‑gɔɔn do bɔle‑ ‑o ni 'ezin‑ dɔɔ: «‑Yrɛ wi mi do laa sɔ ‑a ‑vindo' mi ‑yrɛ wi mi do ‑lɛdɔɔle, 'kebhlaale ‑o mɛɛ plɛ nu baalɛ ‑gluu do 'yi. ");
INSERT INTO moa_vpl VALUES ("LK6_40","072_6_40","LUK","6","40","40","‑Laklu 'nɛ do ‑yi 'laa ya ‑a daan mi 'ɛ ni. 'Duŋ‑ 'ke ‑laklu 'nɛ 'la 'bhɛ 'sɛwɛ ‑daanna 'elrele, ‑e nu klɛlɛ 'bhii‑ ‑a daan mi 'ɛ gbɛɛn‑. ");
INSERT INTO moa_vpl VALUES ("LK6_41","072_6_41","LUK","6","41","41","‑Mɛle ꞊kla ‑gaa 'klenɛ do 'la ‑yoo 'e nɛɛnɛ‑ 'ɛ ‑yrɛ ba, 'e 'bhɛɛ‑ ye, 'bhɛɛ‑ 'duŋ‑ 'yaa‑ sɔ 'e 'gbu 'yrɛ ba ‑yrikpu' 'ɛ 'yele ɛɛ? ");
INSERT INTO moa_vpl VALUES ("LK6_42","072_6_42","LUK","6","42","42","'E sɔ a pele‑ 'nale‑ 'e nɛɛnɛ‑ 'ɛ ni dɔɔ: ‹'Ŋ nɛɛnɛ‑, dula‑ doo, 'mi 'e 'yrɛ ba ‑gaa 'klelenɛ go.› 'Duŋ‑ 'bhɛ 'waati 'ɛ ba 'ke ‑yrikpu' do ‑o 'bhi 'gbu ‑yrɛ 'ɛ ba, 'bhɛɛ‑ 'yaa 'bhɛ ye ɛɛ? Mɛɛ ‑yrɛkɔɔza klɛ mi, 'e 'gbu 'yrɛ ba ‑yrikpu' 'ɛ go 'elwale 'pe, 'bhɛɛ‑ 'kee‑ yrɛ ma ꞊ya 'waati 'la ba, 'e nu 'sɔlɛ‑ 'e nɛɛnɛ‑ 'ɛ 'yrɛ ba ‑gaa 'klenɛ 'ɛ gole‑.» ");
INSERT INTO moa_vpl VALUES ("LK6_43","072_6_43","LUK","6","43","43","Zesu pe 'ezin‑ dɔɔ: «‑Yri diiŋ ‑lrele' laa bhaa ‑yɔɔ klɛ, 'bhɛɛ‑ ‑yri diiŋ ‑yɔɔ' laa bhaa ‑lrele' klɛ. ");
INSERT INTO moa_vpl VALUES ("LK6_44","072_6_44","LUK","6","44","44","‑O ‑yri diiŋ mu 'kpɛn dɔ ‑o bhaa mu ‑la ma. Waa figi bhaa kan ‑zulɛrɛ diiŋ 'yi. 'Bhɛɛ‑ waa ‑drɔɔ bhaa kan daanlɛrɛ diiŋ 'yi. ");
INSERT INTO moa_vpl VALUES ("LK6_45","072_6_45","LUK","6","45","45","Mɛɛ zru ‑lrele' ‑za 'wlan ‑la klɛ 'bhii‑ ‑za 'wlan yɛkɛ‑ 'la ‑yoo ‑a zru 'ɛ 'yi; 'duŋ‑ mɛɛ zru ‑yɔɔ' ‑za 'yɔɔ‑ ‑la klɛ 'bhii‑ ‑za 'yɔɔ‑ yɛkɛ‑ 'la ‑yoo ‑a zru 'ɛ 'yi. ‑Amasrɔyi ‑za yɛkɛ‑ 'la ‑yoo bhaaplɛŋ 'kpee, ‑e 'bhɛɛ‑ wlata ‑janwo'.» ");
INSERT INTO moa_vpl VALUES ("LK6_46","072_6_46","LUK","6","46","46","Zesu pe 'ezin‑ dɔɔ: «‑Mɛle ‑kla 'bhɛɛ‑ 'ka 'mi sii dɔɔ: Mɛɛzan, Mɛɛzan, 'bhɛɛ‑ 'ka 'laa 'mi zru maza klɛ ɛɛ? ");
INSERT INTO moa_vpl VALUES ("LK6_47","072_6_47","LUK","6","47","47","'Ke mɛɛ 'la zan ‑nwa 'mi ba, 'bhɛɛ‑ 'ke ‑ya 'trɔnkpaa‑ 'mi 'wojan‑ mu 'ɛ ꞊la, 'bhɛɛ‑ 'kee‑ 'taawoa꞊ ‑o ta, ‑o sɔ 'bhɛ zan 'ɛ 'kpale pɛ 'la ma, 'ŋ 'yoo‑ zan 'bhɛ zrɔnlɛ 'ka ni. ");
INSERT INTO moa_vpl VALUES ("LK6_48","072_6_48","LUK","6","48","48","'Bhɛ zan ‑o 'bhii‑ mɛɛ do 'la ‑e 'fɛ do dɔle‑ ‑saan. ‑E 'fɛ gaan bɔ ‑gluu 'ɛ ꞊kaan 'egbɔɔnle, 'bhɛɛ‑ ‑e 'fɛ gaan 'ɛ ꞊bwa vlɛ ‑saa do ta. La banle blaan 'ke tɔ 'ɛ 'pale, 'bhɛɛ‑ ‑yi 'pɔɔ 'ɛ ꞊nwa 'palɛ‑ 'fɛgwlɛ‑ ma, 'duŋ‑ yaa 'sɔlɛ‑ ‑a bɛɛnle‑. ‑Amasrɔyi 'fɛ 'ɛ dɔle‑ ‑yaa 'elrele. ");
INSERT INTO moa_vpl VALUES ("LK6_49","072_6_49","LUK","6","49","49","'Duŋ‑ 'ke mɛɛ 'la zan 'e 'trɔnkpaa‑ 'mi a ‑jan mu 'ɛ ꞊la, 'bhɛɛ‑ 'ke yaa 'taawolɛ ‑o ta, 'bhɛ zan 'ɛ 'pwɛle ‑o 'ke mɛɛ do 'la 'kee‑ ‑yaa' 'fɛ 'ɛ ‑dwa 'trɛ kpataakpa 'ɛ ta, 'bhɛɛ‑ yaa gaan bɔ ‑gluu 'kanlɛ‑ ‑a ‑la. La do banle blaan, 'ke tɔ 'ɛ 'pale, 'bhɛɛ‑ 'ke ‑yi 'pɔɔ 'ɛ 'nule 'palɛ‑ 'yee‑ 'fɛgwlɛ‑ 'ɛ ma. 'Bhɛ klɛle 'tɛ, 'kee‑ 'klaale 'bhɛɛ‑ 'fɛ 'ɛ 'kpɛn ꞊wia 'feŋfeŋ.» ");
INSERT INTO moa_vpl VALUES ("LK7_1","072_7_1","LUK","7","1","1","Zesu 'yanle‑ 'bhɛ ‑jan mu 'ɛ 'wolele mɛɛ mu 'ɛ ni, 'ke 'yee‑ 'pegee ‑yaa' ‑klaŋlanɛ mu 'ɛ ‑o gele‑ Kapɛnɔmu ‑wa 'ɛ ta. ");
INSERT INTO moa_vpl VALUES ("LK7_2","072_7_2","LUK","7","2","2","Romɛ mu a ‑srwase' ‑kuŋlii do ‑yaa 'bhɛ ‑wa 'ɛ ta, 'bhɛɛ‑ ga ‑gbɛnɛ do ‑yaa 'bhɛ a 'fɛ 'ɛ ꞊la yewonɛ mu 'ɛ do ma. ‑A ‑za ‑yaa sɔ ‑a zan ni 'eglɔɔle. 'Bhɛ ‑e 'yaa‑ zan galɛ, ");
INSERT INTO moa_vpl VALUES ("LK7_3","072_7_3","LUK","7","3","3","'Bhɛ 'yi 'tɛ, 'yee ‑srwase' ‑kuŋlii 'ɛ ‑ya 'malawoa 'kaa Zesu ꞊nwa, 'kee‑ Zuufu mu a 'gwlaan‑ gblaan mu 'ɛ 'ke 'winbɔle Zesu 'siiyrɛ‑ nɔɔ‑ 'kaa 'bhɛ 'nu ‑yaa' yewonɛ 'ɛ 'bhee‑. ");
INSERT INTO moa_vpl VALUES ("LK7_4","072_7_4","LUK","7","4","4","'Bhɛ 'gwlaan‑ gblaan mu 'ɛ gele 'tɛnlɛ‑ Zesu ma, 'ke ‑o 'bhɛ ‑sromabɔle dɔɔ: «'E 'zoole‑, 'yaa 'e ‑baŋgolɛ bhɔle ma mɛɛ 'lɛɛ‑ ba. ");
INSERT INTO moa_vpl VALUES ("LK7_5","072_7_5","LUK","7","5","5","‑Amasrɔyi, ‑kɔɔa' 'klɛɛn 'ɛ 'yi mu 'ɛ ‑za sɔ a ni 'egbɛnɛle. 'Bhɛɛ‑ 'yele‑ 'o daanfɛ' 'ɛ ‑dwa.» ");
INSERT INTO moa_vpl VALUES ("LK7_6","072_7_6","LUK","7","6","7","'Bhɛ klɛle 'tɛ, 'ke Zesu dɔle‑ gele ‑la 'yee‑ ‑srwase' mi 'ɛ ba ‑lɛ ma. ‑E bhɔle ‑yaa' 'fɛ 'ɛ ‑din 'waati 'la ba, 'bhɛɛ‑ 'yee‑ ‑srwase' ‑kuŋlii 'ɛ ‑ya bhɛgwlɛn mu 'ke mu winbwa‑ Zesu ta 'kaa ‑wa pe 'bhɛ ni dɔɔ: «Mɛɛzan, 'yaa 'e 'gbu 'trɛbhɔlɛ. 'Naa ‑o 'ke mɛɛ wlan 'le, ‑ayile 'mi 'gbu 'laa gelɛ 'e ta ye; 'bhɛla‑ ‑yile 'yaa sɔ nule‑ 'mi ba ‑lɛ ma. 'Duŋ‑ ‑jangɔ' do 'kpɔ 'wo, 'bhɛɛ‑ 'an yewonɛ 'ɛ nu ‑bheelɛ'. ");
INSERT INTO moa_vpl VALUES ("LK7_8","072_7_8","LUK","7","8","8","'Mi 'gbu ‑kuŋlii ‑o, 'bhɛɛ‑ 'mi 'gbu ‑o 'ke ‑srwase' 'ke mu ‑kuŋlii 'le 'ezin‑. 'Mi sɔ ‑a do winbɔle, 'bhɛɛ‑ 'bhɛ ge; 'bhɛɛ‑ 'mi sɔ ‑a ‑bhɛɛke' do 'siile, 'bhɛɛ‑ 'bhɛ nu. 'Ezin‑ 'ke 'mi 'a ꞊pia 'an pɛ yewonɛ 'ɛ ‑za 'la 'bhɛ klɛ, 'bhɛ 'bhɛɛ‑ klɛ.» ");
INSERT INTO moa_vpl VALUES ("LK7_9","072_7_9","LUK","7","9","9","Zesu 'yee‑ ‑srwase' mu a ‑kuŋlii 'ɛ 'liijan‑ 'ɛ 'male‑, 'ke ‑a zrukpaale 'gbu 'egbɛnɛle. ‑Ayile 'ke ‑ya ‑lɛklale ‑a zi ‑zamaa' 'ɛ ta, 'bhɛɛ‑ 'ke ‑ya pele‑ ‑o ni dɔɔ: «‑A 'san 'ke 'ŋ ‑Jan 'nrale‑ 'ɛ 'wole‑ zisan, 'naa 'bhɛ 'yansi mɛɛ ‑glɔɔn yelɛ ‑lido' 'ke 'bhɛ 'bhɛ kpa 'mi 'yi 'egbɛnɛle 'bhii‑ mɛɛ 'lɛɛ‑ gbɛɛn‑ Izraɛli 'klɛɛn 'ɛ 'yi ‑gɛ.» ");
INSERT INTO moa_vpl VALUES ("LK7_10","072_7_10","LUK","7","10","10","'Bhɛ blaan, 'ke 'yee‑ ‑srwase' ‑kuŋlii 'ɛ yaa winbɔwo mu 'ɛ 'niinale ‑a ta ‑yaa' 'fɛ 'ɛ 'lɛ ma. 'Bhɛɛ‑ 'ke ‑o bhɔle ‑yaa' yewonɛ 'ɛ 'bheele‑ ta. ");
INSERT INTO moa_vpl VALUES ("LK7_11","072_7_11","LUK","7","11","11","'Bhɛ blaan, 'ke Zesu gele‑ ‑wa do ta, ‑o ‑yaa 'bhɛ ‑wa 'ɛ sii Naini. ‑Yaa' ‑klaŋlanɛ mu 'ɛ 'pegee ‑zamaa' 'saa do ‑ja ‑a zi 'bhɛ ‑wa 'ɛ ta. ");
INSERT INTO moa_vpl VALUES ("LK7_12","072_7_12","LUK","7","12","12","‑E ꞊bhwa bhla 'la ba 'bhɛ ‑wa 'ɛ ‑din, 'ke ‑o ‑lɛpale gbaa bin mu 'ke mu 'le, 'mu 'yaa‑ ge 'zi glaanle do ‑la ‑nɛ 'gwlaan‑ bhɛdo 'kpɔ 'ɛ binlɛ. ‑Ayile, ‑wa 'ɛ ta mɛɛ 'srɛ do ꞊nwa 'yee‑ le ‑nɛ 'ɛ zi ‑a gbe 'ɛ binyrɛ nɔɔ‑. ");
INSERT INTO moa_vpl VALUES ("LK7_13","072_7_13","LUK","7","13","13","Mɛɛzan Zesu 'a yele, 'ke ‑a ‑yrɛnklale 'bhɛ ma, ‑ayile 'ke 'yee‑ Zesu 'a pele‑ ‑a ni dɔɔ: «'Yaa wisilɛ!» ");
INSERT INTO moa_vpl VALUES ("LK7_14","072_7_14","LUK","7","14","14","'Bhɛɛ‑ 'ke ‑ya mabɛɛnle gbaa 'ɛ ‑din, 'bhɛɛ‑ 'kee‑ 'kunle ‑a 'kpa 'kesu 'ɛ ma. 'Bhɛ klɛle 'tɛ, 'ke gbaa bina‑ mu 'ɛ ‑o dulale. 'Bhɛɛ‑ 'ke Zesu 'a 'pele gbaa 'ɛ 'a ni dɔɔ: «‑Zwannɛ, 'e 'wlɛn‑!» ");
INSERT INTO moa_vpl VALUES ("LK7_15","072_7_15","LUK","7","15","15","'Bhɛ yrɛ do 'ɛ ꞊nɔɔ bhe, 'yee‑ ‑nɛ ‑zwannɛ 'la ‑gaa bi bhe, ‑e ‑bwela, 'bhɛɛ‑ ‑e ‑wlɛnle', 'kee‑ ‑janwole 'sanle. 'Bhɛ blaan, 'ke Zesu 'a 'nale ‑a nɛɛ ni. ");
INSERT INTO moa_vpl VALUES ("LK7_16","072_7_16","LUK","7","16","16","'Bhɛ klɛle 'tɛ, mɛɛ mu 'la 'yaa‑ 'bhɛ yrɛ 'ɛ ꞊nɔɔ ye, ‑gblaan ꞊klaa 'mu 'kpɛn 'yi, 'bhɛɛ‑ 'ke ‑o ‑Waanbhaa' 'tɔbhɔle dɔɔ: «‑Waanbhaa' ‑lɛla' janwo mi ‑gbɛnɛ do ‑nwa ‑kɔɔ' 'pleŋ‑, 'bhɛɛ‑ ‑Waanbhaa' ‑nwa ‑yaa' mɛɛ mu 'ɛ taglinlɛ!» ");
INSERT INTO moa_vpl VALUES ("LK7_17","072_7_17","LUK","7","17","17","‑Ayile 'ke Zude 'klɛɛn 'ɛ 'yi mu 'ɛ kpɛn 'pegee ‑a ‑din mu 'ɛ ‑o 'kpɛn Zesu klɛza 'ɛ 'male. ");
INSERT INTO moa_vpl VALUES ("LK7_18","072_7_18","LUK","7","18","18","Zesu ‑za mu 'la ꞊kla, 'yee‑ Zaan a ‑klaŋlanɛ mu 'ɛ 'mu 'bhɛ mu 'kpɛn 'yigɔɔnna ‑a ni. ");
INSERT INTO moa_vpl VALUES ("LK7_19","072_7_19","LUK","7","19","19","Zaan 'bhɛ 'male‑, 'kee‑ ‑yaa' ‑klaŋlanɛ plɛ 'siile, 'ke ‑yoo winbɔle Mɛɛzan Zesu ba. ‑E pe ‑o ni ‑o ge Zesu 'lrɔkpa dɔɔ: «‑O mɛɛ 'la 'nuza‑ ꞊pia, 'bhi ‑le 'bhɛ zan 'ɛ 'le, taa‑ 'woo 'yrikpa mɛɛ ‑bhɛɛke' 'nule‑ ta ɛɛ?» ");
INSERT INTO moa_vpl VALUES ("LK7_20","072_7_20","LUK","7","20","20","‑O bhɔle Zesu ‑din, 'ke ‑wa pele‑ 'bhɛ ni dɔɔ: «Mɛɛ Wiiŋfɛ' Mi Zaan 'o 'winbwa‑ 'e 'lrɔkpa yrɛ nɔɔ‑ dɔɔ: ‑O mɛɛ 'la 'nuza‑ ꞊pia 'bhi ‑le 'bhɛ zan 'ɛ 'le taa‑ mɛɛ ‑bhɛɛke' ‑o zan 'bhi blaan ɛɛ?» ");
INSERT INTO moa_vpl VALUES ("LK7_21","072_7_21","LUK","7","21","21","'Bhɛ 'waati do 'kpɔ 'ɛ ba, 'ke Zesu mɛɛ ‑bebe ma ga mu gole‑, ‑e 'zina mu ‑gbian mɛɛ ‑bebe zi, 'bhɛɛ‑ ‑e ‑yrɛ 'wi mu ‑yrɛ 'liiploola. ");
INSERT INTO moa_vpl VALUES ("LK7_22","072_7_22","LUK","7","22","22","'Bhɛ blaan, 'ke ‑ya pele‑ Mɛɛ Wiiŋfɛ' Mi Zaan a winbɔwo mu 'ɛ ni dɔɔ: «'Ka ‑za mu 'la klɛyrɛ ‑ya 'ŋ 'kɔɔ, 'bhɛɛ‑ 'ka ‑jan mu 'la ꞊maa, ‑ka ge 'mu 'kpɛn 'yigɔɔn‑ Zaan ni. ‑Kaa pe ‑a ni dɔɔ: ‑yrɛ 'wi mu ‑o yrɛ ma ye 'zi, ‑flugba mu ‑o 'taawo zii', ‑kpaandɛ' mu ma ‑kpaan ‑o go 'zi, 'trɔn 'wi mu ‑o ‑jan 'ma zii', 'bhɛɛ‑ gbaa mu ‑o bwe 'zi gale ba. 'Ezin‑ ‑kaa pe ‑a ni dɔɔ 'kaa 'ŋ 'yoo‑ ‑Jan 'Nrale 'ɛ 'wo zii' ‑yrɛnbhɔ' dɛ mu ni. ");
INSERT INTO moa_vpl VALUES ("LK7_23","072_7_23","LUK","7","23","23","'Ke mɛɛ 'la zan laa 'ploolɛ‑ 'mi a pɛ zi 'ɛ ma, 'bhɛ zan a pɛ ‑yinra'.» ");
INSERT INTO moa_vpl VALUES ("LK7_24","072_7_24","LUK","7","24","24","Zaan a *winbɔwo mu 'ɛ gele blaan, 'ke Zesu ‑zamaa' 'ɛ 'lrɔkpale 'sanle 'yee‑ Zaan ba zayi' dɔɔ: «'Ka ‑ja ‑mɛla ‑glinlɛ' ‑kpe 'ɛ ta. ‑Ploo ‑yaa togɔ 'la bɛɛn 'zi 'bhɛ ‑le 'kɛle‑ ɛɛ? ");
INSERT INTO moa_vpl VALUES ("LK7_25","072_7_25","LUK","7","25","25","'Bhɛɛ‑ 'ka ‑ja mɛɛ 'la ‑glinlɛ' ‑kpe 'ɛ ta, 'ka dunɛ‑ 'lrele‑ ꞊ya ‑a ta ɛɛ? Mɛɛ 'la zan mu dunɛ‑ 'lrele‑ mu kla 'mu ta, 'bhɛɛ‑ 'ke pɛ ‑lrele' ‑bebe ‑o 'mu ‑kɔɔ, 'bhɛ zan mu 'ɛ ‑woo ‑bhleŋgbe mu ‑la 'fɛ mu ꞊la. ");
INSERT INTO moa_vpl VALUES ("LK7_26","072_7_26","LUK","7","26","26","'Ka ‑ja 'duŋ‑ ‑dela ‑glinlɛ' ‑kpe 'ɛ ta ɛɛ? 'Ka ‑Waanbhaa' *‑lɛla' janwo mi do ‑la ꞊ya ɛɛ? Wlan 'gbu 'ɛ ni, ‑yoo 'ke 'bhɛ do 'le, 'bhɛɛ‑ 'duŋ‑ ‑a gblaan ‑yiya' ‑Waanbhaa' ‑lɛla' janwo mi do ni. ");
INSERT INTO moa_vpl VALUES ("LK7_27","072_7_27","LUK","7","27","27","‑Amasrɔyi Zaan ‑le 'ke ‑Waanbhaa' mɛɛ 'la zan a ‑janwoa ‑yaa' 'Sɛwɛ 'ɛ 'yi dɔɔ: ‹'E 'yrɛkpa ‑gɛ doo, 'mi 'e 'lɛɛ ‑toorodɔ mi do winbwa‑. 'Bhɛ nu 'e 'lɛɛ zibhɛ 'ɛ magaanlɛ.›» ");
INSERT INTO moa_vpl VALUES ("LK7_28","072_7_28","LUK","7","28","28","'Bhɛɛ‑ Zesu pe ‑o 'ezin‑ dɔɔ: «‑A 'san 'ke ‑Waanbhaa' 'drunyan klɛ, 'bhɛ 'yansi mɛɛ laa yalɛ ‑lido', 'ke 'bhɛ gblaan ‑yiya' Zaan ni. 'Duŋ‑ *‑Waanbhaa' a ‑bhleŋgbeya ‑wa 'ɛ ta mɛɛ 'fiɛntrɔnnɛ 'ɛ bhɛ gblaan 'yiya‑ 'yee‑ Zaan 'gbu ni. ");
INSERT INTO moa_vpl VALUES ("LK7_29","072_7_29","LUK","7","29","29","Mɛɛ mu 'ɛ 'kpɛn 'pegee 'nisrakun mu 'ɛ ‑o ‑yaa ‑o 'trɔn 'kpa zii' Zaan ni. ‑O 'kpɛn 'a 'yaangwa‑ 'bhii‑ ‑Waanbhaa' ‑lɛdɔɔle ‑o, 'bhɛla‑ ‑yile ‑o ‑dwa ‑a ‑la 'ke Zaan ‑o wiiŋfɛ ‑yi ba ba. ");
INSERT INTO moa_vpl VALUES ("LK7_30","072_7_30","LUK","7","30","30","'Duŋ‑ Farizi mu 'ɛ 'pegee 'Toŋ daan mu waa dɔlɛ ‑a ‑la 'ke Zaan ‑o wiiŋfɛ ‑yi ba, 'bhɛ ya 'ɛ 'yi, waa ‑Waanbhaa' ‑lɛdɔlɛ ‑a ma.» ");
INSERT INTO moa_vpl VALUES ("LK7_31","072_7_31","LUK","7","31","31","Zesu pe ‑o ni 'ezin‑ dɔɔ: «'Ŋ sɔ 'saanigɛ mu ‑o danle‑ ‑mɛla ma ɛɛ? 'Bhɛɛ‑ ‑o 'pwɛle‑ ‑o 'ke ‑de 'gbu ‑la ‑le ɛɛ? ");
INSERT INTO moa_vpl VALUES ("LK7_32","072_7_32","LUK","7","32","32","'Saanigɛ mu 'ɛ ‑woo 'bhii‑ ‑nɛ mu 'la 'yaale‑ ‑o ‑zabla' ‑kpan do ta, 'bhɛɛ‑ ‑o 'ke mu ‑o ‑a 'pe 'zi ‑o ‑vin mu 'ɛ ni dɔɔ: ‹'O 'srokpa ‑gofɛn' mu ꞊pian 'ka ni, 'bhɛɛ‑ 'ka 'laa 'srotanlɛ. 'O wisi' 'sro mu ‑kpaa 'ka ni, 'bhɛɛ‑ 'ka 'laa wisilɛ!› ");
INSERT INTO moa_vpl VALUES ("LK7_33","072_7_33","LUK","7","33","33","'Bhɛ ya 'ɛ 'yi, Mɛɛ Wiiŋfɛ' Mi Zaan ꞊nwa, yaa ‑yaa pɛle, 'bhɛɛ‑ yaa ‑yaa ‑drɔɔ mi, 'bhɛɛ‑ 'ka pe dɔɔ 'zina mu ‑o ‑a zi. ");
INSERT INTO moa_vpl VALUES ("LK7_34","072_7_34","LUK","7","34","34","'Bhɛɛ‑ Bhaaplɛŋ Gbe 'ɛ ꞊nwa, 'bhɛ pɛbhle, 'bhɛɛ‑ 'bhɛ ‑wɛɛn mi. 'Bhɛɛ‑ 'ka pe 'bhɛ ma dɔɔ: ‑ka 'ka 'yrɛkpa 'a ta, mɛɛ 'lɛɛ‑ ‑a bole ‑o pɛbhlele 'pegee ‑wɛɛn ‑la mile ma. 'Bhɛɛ‑ ‑a bhɛgwlɛn mu ‑o 'ke 'nisrakun mu 'pegee mɛɛ 'joo 'yɔɔ‑ ‑bhɛɛke' mu ‑la ‑le! ");
INSERT INTO moa_vpl VALUES ("LK7_35","072_7_35","LUK","7","35","35","'Duŋ‑ mɛɛ 'la zan mu 'kpɛn ‑o ‑kpaa ‑Waanbhaa' a ‑zadɔleya 'ɛ 'yi, 'bhɛɛ‑ ‑wa ꞊ya 'bhii‑ ‑a ‑lɛdɔɔle ‑o, 'bhɛ zan mu 'kpɛn ‑dwa ‑a ‑la.» ");
INSERT INTO moa_vpl VALUES ("LK7_36","072_7_36","LUK","7","36","36","Farizi mi do pɛbhle ꞊kla, 'bhɛɛ‑ ‑e Zesu 'siila‑ 'bhɛ pɛbhle 'ɛ ma ‑a ba ‑lɛ ma. Zesu 'bhɔle‑ 'bhɛ ꞊nɔɔ, 'kee‑ gele‑ yaalɛ pɛbhle tabali 'ɛ zi. ");
INSERT INTO moa_vpl VALUES ("LK7_37","072_7_37","LUK","7","37","37","'Bhɛ ‑wa 'ɛ ta le do 'joo 'yaa‑ 'eyɔɔle. ‑Ya 'malawoa 'kaa Zesu ‑o pɛle 'zi Farizi mi 'ɛ ‑yaa' 'fɛ 'ɛ ꞊la, 'kee‑ nule‑ 'ke alibatri buteli 'plɛɛle‑ do 'le, 'bhɛ 'pale‑ ‑yaa 'ke ‑lasiklɔɔ ‑gblɛn 'nrale‑ do 'le. ");
INSERT INTO moa_vpl VALUES ("LK7_38","072_7_38","LUK","7","38","38","'Yee‑ le 'ɛ ꞊nwa dulalɛ Zesu ‑zan, 'bhɛɛ‑ 'kee‑ 'yaale 'bhɛ gaan ma. 'Kee‑ wisile 'ke ‑ya ‑yrɛyi' 'klale Zesu gaan ma. 'Bhɛ blaan 'ke ‑ya ‑yrɛyi' mu 'ɛ gole‑ Zesu gaan ma ‑a winle mu 'ɛ 'le, 'bhɛɛ‑ 'ke ‑ya gbɛ kan Zesu gaan mu 'ɛ ma yrɛtɛtɛ. ");
INSERT INTO moa_vpl VALUES ("LK7_39","072_7_39","LUK","7","39","39","'Bhɛ klɛle 'tɛ, Farizi mi 'la Zesu 'siila‑ pɛle 'ɛ ma, 'bhɛ 'yrɛkpale ‑a ma, 'ke 'bhɛ 'a pele‑ 'bhɛ 'kpee dɔɔ: «'Ke mɛɛ 'lɛɛ‑ ‑yoo 'ke ‑Waanbhaa' ‑lɛla' janwo mi kpataakpa 'gbu 'le bhe, le ‑glɔɔn 'la 'kun zii' ‑a ma bhe, ‑e ‑yaa nu 'bhɛ 'yaangolɛ. ‑E ‑yaa nu ‑a dɔlɛ 'bhii‑ le 'joo 'yɔɔ‑ do ‑le 'kɛle‑.» ");
INSERT INTO moa_vpl VALUES ("LK7_40","072_7_40","LUK","7","40","40","'Bhɛ klɛle 'tɛ, 'ke Zesu 'a 'pele 'yee‑ Farizi mi Simɔ ni dɔɔ: «'Ŋ 'yoo‑ ‑a zi 'bhii‑ 'ŋ ‑jan do wo 'e ni.» Simɔ pe ‑a ni dɔɔ: «'Ŋ Zan, ‑a wo!» ");
INSERT INTO moa_vpl VALUES ("LK7_41","072_7_41","LUK","7","41","41","Zesu pe ‑a ni dɔɔ: «Mɛɛ do ‑a ca ‑yaa mɛɛ plɛ ma. Denie ‑gɔli' 'taŋbha ‑kɛmɛ 'soo ca ‑yaa ‑a do ma, 'bhɛɛ‑ denie ‑gɔli' 'taŋbha mia plɛ bhɛ vu ca ‑yaa ‑a ‑bhɛɛke' do 'ɛ ma. ");
INSERT INTO moa_vpl VALUES ("LK7_42","072_7_42","LUK","7","42","42","‑O mɛɛ plɛ 'ɛ 'kedo‑ 'kpɔ 'laa ‑yaa sɔ ‑yaa ca mu 'ɛ gbawole. ‑Ayile 'ke ‑ya pele‑ ‑o ni 'kaa ‑ya niigwa‑ ‑waa' ca mu 'ɛ 'yi. 'Bhɛ ya 'ɛ 'yi, 'woo‑ mɛɛ plɛ 'ɛ ba ‑a ‑za nu 'sɔlɛ‑ ‑o ‑de 'gbu ‑la ni 'egbɛnɛle ɛɛ?» ");
INSERT INTO moa_vpl VALUES ("LK7_43","072_7_43","LUK","7","43","43","Simɔ pe ‑a ni dɔɔ: «‑Yaa' ca ‑gbɛnɛ ‑yaa mɛɛ 'la zan ma ‑a ‑za nu 'sɔlɛ‑ 'bhɛɛ‑ ni 'egbɛnɛle.» 'Bhɛ klɛle 'tɛ, 'ke Zesu 'a 'pele ‑a ni dɔɔ: «'E ‑jan 'ɛ ꞊woa 'elrele.» ");
INSERT INTO moa_vpl VALUES ("LK7_44","072_7_44","LUK","7","44","44","'Bhɛ blaan 'ke, Zesu 'e 'yrɛkpale 'yee‑ le 'ɛ ta, 'bhɛɛ‑ 'ke ‑ya pele‑ Simɔ ni dɔɔ: «Le 'lɛɛ‑ ‑glin 'pe doo. 'Ŋ ꞊nwa 'e ba 'fɛ 'ɛ ꞊la, 'bhɛɛ‑ 'yaa ‑yi 'nalɛ‑ 'mi ni 'ŋ gaan mu mafɛ' pɛ 'le. 'Duŋ‑ le 'lɛɛ‑ 'bhɛ ‑o mafia‑ 'ke ‑a ‑yrɛyi' mu 'ɛ 'le, 'bhɛɛ‑ ‑yoo magwa‑ 'ke ‑a winle mu 'ɛ 'le. ");
INSERT INTO moa_vpl VALUES ("LK7_45","072_7_45","LUK","7","45","45","'Ŋ ꞊nwa 'e ba, 'bhɛɛ‑ 'yaa 'ŋ ‑tuubɔlɛ. 'Duŋ‑ ‑a 'san 'ke 'ŋ wla 'yaa‑ 'fɛ 'ɛ ꞊la, le 'lɛɛ‑ ‑a bole ‑o ‑a gbɛ 'kanle‑ ma 'ŋ gaan 'ɛ ma. ");
INSERT INTO moa_vpl VALUES ("LK7_46","072_7_46","LUK","7","46","46","'Yaa 'ŋ 'wiiŋ‑ 'srolɛ‑ 'ke ‑yrɔn 'le, 'duŋ‑ 'yee‑ 'ŋ gaan masrola 'ke ‑lasiklɔɔ 'le. ");
INSERT INTO moa_vpl VALUES ("LK7_47","072_7_47","LUK","7","47","47","'Bhɛla‑ ‑yile, 'mi pe 'e ni dɔɔ 'mi ‑za 'la ꞊swa ‑a ni 'egbɛnɛle, ‑ayile ‑Waanbhaa' ‑yaa ‑za 'yɔɔ‑ mu 'ɛ 'sroma‑ ‑yaan. 'Duŋ‑ ‑Waanbhaa' mɛɛ 'la a ‑sroma yan ‑za 'yɔɔ‑ 'fiɛntrɔnnɛ 'yi, ‑a ‑za nu 'sɔlɛ‑ 'bhɛ zan ni 'bhɛɛ‑ yɛkɛ‑ gbɛɛn‑.» ");
INSERT INTO moa_vpl VALUES ("LK7_48","072_7_48","LUK","7","48","48","'Bhɛ blaan, 'ke Zesu 'a 'pele le 'ɛ ni dɔɔ: «‑Waanbhaa' 'yaa‑ ‑za 'yɔɔ‑ mu 'ɛ ‑sroma ‑yaan.» ");
INSERT INTO moa_vpl VALUES ("LK7_49","072_7_49","LUK","7","49","49","'Bhɛ klɛle 'tɛ, mɛɛ 'la zan mu 'pegee Zesu 'yaa‑ pɛle 'zi 'eke‑ zi 'mu pe 'mu 'kpee dɔɔ: «Mɛɛ ‑glɔɔn 'ɛ ‑dele mɛɛ 'lɛɛ‑ 'le, 'bhɛɛ‑ ‑e sɔ mɛɛ mu a ‑za 'yɔɔ‑ mu ‑sroma 'yanle ɛɛ?» ");
INSERT INTO moa_vpl VALUES ("LK7_50","072_7_50","LUK","7","50","50","'Bhɛɛ‑ 'duŋ‑, Zesu 'pe le 'ɛ ni dɔɔ: «Ge 'e ba ‑lɛ ma 'e yilablawolele, ‑amasrɔyi 'yee 'kpalawoa 'mi 'yi 'e ‑gwa ‑za 'yi.» ");
INSERT INTO moa_vpl VALUES ("LK8_1","072_8_1","LUK","8","1","1","'Bhɛ blaan, 'ke Zesu 'kaanle‑ 'sanle ‑wa ‑gbɛnɛ mu 'pegee ‑wa 'fiɛntrɔnnɛ mu 'ɛ ta. 'E ‑yaa ‑Waanbhaa' a ‑bhleŋgbeya ma ‑jan 'nrale‑ 'ɛ 'wo zii' 'bhɛ ‑wa mu 'ɛ ta. ‑Yaa' ‑klaŋlanɛ vu ta plɛ 'ɛ 'yaa‑ zi 'bhɛ yrɛ mu 'ɛ ꞊nɔɔ. ");
INSERT INTO moa_vpl VALUES ("LK8_2","072_8_2","LUK","8","2","2","Zesu 'zina mu ꞊gbian le mu 'la zi, 'bhɛ 'pegee ‑e le mu 'la 'bheela‑, 'mu ‑le ‑yaa zi. 'Woo‑ le mu 'ɛ 'wo ‑la 'tɔ ‑le ‑gɛ: Mari 'la ‑o ‑yaa 'bhɛ sii Magidala Mari, Zesu 'zina 'srwaplɛ‑ ‑gbian 'bhɛ ‑la zi. ");
INSERT INTO moa_vpl VALUES ("LK8_3","072_8_3","LUK","8","3","3","'Bhɛ 'pegee Suza 'na Zaani: 'yee‑ Suza ‑yaa 'ke ‑bhleŋgbe Erɔdi a 'fɛ 'ɛ ꞊la yewonɛ mu ‑lɛɛ mi 'le; 'bhɛɛ‑ Suzani 'pegee le ‑bhɛɛke' ‑bebe. 'Woo‑ le mu 'ɛ ‑o ‑yaa bhɔ Zesu 'pegee 'bhɛ a ‑klaŋlanɛ mu 'ɛ ba ‑o 'kɔɔpɛ‑ mu 'ɛ 'le. ");
INSERT INTO moa_vpl VALUES ("LK8_4","072_8_4","LUK","8","4","4","‑Wa mu 'ɛ 'kpɛn ta mɛɛ mu 'yaa‑ zan Zesu ba. 'Bhɛla‑ ‑yile 'ke ‑zamaa' 'srɛ do 'klale 'eke‑ ba ‑a zi. 'Bhɛɛ‑ 'kee‑ ‑gɔɔn 'lɛɛ‑ 'bhɛ bɔle‑ ‑o ni dɔɔ: ");
INSERT INTO moa_vpl VALUES ("LK8_5","072_8_5","LUK","8","5","5","«‑Yrekpaa' do, mɛɛ do ‑ja pɛbhɛ bɔyrɛ nɔɔ‑. ‑E ‑yaa pɛbhɛ mu 'ɛ 'wian zii' bhla 'la ba ‑yaa' gbabhɛ 'ɛ ta, pɛbhɛ mu 'ɛ 'lɛdo‑ 'klalaa‑ zibhɛ 'ɛ 'lɛzi‑, 'bhɛɛ‑ mɛɛ mu 'taawoa꞊ 'mu ta, 'bhɛɛ‑ maannɛ‑ mu 'mu ‑bhla. ");
INSERT INTO moa_vpl VALUES ("LK8_6","072_8_6","LUK","8","6","6","Pɛbhɛ mu 'ɛ 'lɛdo‑ ‑klalaa' vlɛ gloglo mu 'ɛ 'yi. ‑O bhɔle ‑gun blaale‑ 'ke ‑o gale‑, ‑amasrɔyi ‑o 'sɛnɛ mu 'ɛ waa 'sɔlɛ‑ 'tɛnle 'trɛ ‑dɔɔ ma. ");
INSERT INTO moa_vpl VALUES ("LK8_7","072_8_7","LUK","8","7","7","'Bhɛɛ‑ pɛbhɛ mu 'ɛ 'lɛdo‑ ‑klalaa' lɛrɛ mu 'yi. 'Bhɛɛ‑ ‑o 'pegee lɛrɛ mu 'ɛ 'bhɔlawoa 'eke‑ zi, 'bhɛ mu ‑o ‑dewoa. ");
INSERT INTO moa_vpl VALUES ("LK8_8","072_8_8","LUK","8","8","8","'Bhɛɛ‑ 'ezin‑, pɛbhɛ mu 'ɛ 'lɛdo‑ ‑klalaa' 'trɛ ti 'yi. ‑O bhɔlawoa 'ke ‑woo ‑bhaale' 'elrele. ‑Ayile 'ke ‑o 'kpɛn ‑o bhaa klɛle‑ ‑kɛmɛ do do.» 'Bhɛɛ‑ Zesu pe 'ezin‑ dɔɔ: «'Ke 'trɔn ‑o mɛɛ 'la zan ŋgblo ma 'bhɛ ‑jan 'lɛɛ‑ 'yima!» ");
INSERT INTO moa_vpl VALUES ("LK8_9","072_8_9","LUK","8","9","9","'Bhɛ blaan, 'ke Zesu a ‑klaŋlanɛ mu 'ɛ ‑wa pele‑ ‑a ni 'kaa ‑e 'bhɛ ‑gɔɔn 'ɛ 'yipe ‑o ni. ");
INSERT INTO moa_vpl VALUES ("LK8_10","072_8_10","LUK","8","10","10","Zesu pe ‑o ni dɔɔ: «'Ka mu ‑swa ‑Waanbhaa' a ‑bhleŋgbeya gaanyiza mu 'ɛ dɔle‑. 'Duŋ‑ ‑o mɛɛ ‑vin mu 'ɛ 'mu a pɛ 'ɛ klɛ ‑gɔɔn mu ‑la bɔlele; 'kooko‑ 'ke ‑woo ‑yrɛkpaa ‑o ta waa sɔ ‑o yele‑, 'bhɛɛ‑ 'ke ‑woo 'trɔnkpaa‑ ‑o ‑la, waa sɔ ‑o ‑yimale.» ");
INSERT INTO moa_vpl VALUES ("LK8_11","072_8_11","LUK","8","11","11","Zesu pe ‑yaa' ‑klaŋlanɛ mu 'ɛ ni dɔɔ: «Pɛbhɛ bɔ mi 'ɛ ma ‑gɔɔn 'ɛ 'yi ‑le ‑gɛ: ‑Waanbhaa' ‑jan 'ɛ 'bhɛ ‑le 'ke pɛbhɛ mu 'ɛ 'le. ");
INSERT INTO moa_vpl VALUES ("LK8_12","072_8_12","LUK","8","12","12","Mɛɛ 'ke mu ‑o 'bhii‑ pɛbhɛ mu 'la 'klalaa zibhɛ 'ɛ 'lɛzi‑. 'Ke ‑o ‑Waanbhaa' a ‑jan 'ɛ ꞊maa, ‑Setran' nu blaale‑ 'bhɛ ‑jan 'ɛ golɛ ‑o 'kpee, 'kooko‑ waa sɔ ‑o 'kpale ‑Waanbhaa' 'yi, 'bhɛɛ‑ 'bhɛ ‑o go ‑za 'yi. ");
INSERT INTO moa_vpl VALUES ("LK8_13","072_8_13","LUK","8","13","13","Mɛɛ 'ke mu ‑o 'bhii‑ pɛbhɛ mu 'la 'klalaa vlɛ gloglo mu 'ɛ 'yi. 'Ke ‑o ‑Waanbhaa' a ‑jan 'ɛ ꞊maa ‑wa ‑za klɛ ‑o zrukpaale ta. 'Duŋ‑ waa to 'ke 'yee‑ ‑jan 'ɛ ‑ya 'sɛnɛ gbaanyrɛ ‑srɔɔwo ‑o 'kpee 'ɛ 'yi, 'bhɛɛ‑ ‑woo kpa a ‑yi 'waati sa ba. ‑Amasrɔyi 'ke ‑o ‑yrɛnbhlele ‑saan bhla 'la ba ‑o ploo ‑o 'kpale‑ ma ‑a ‑yi. ");
INSERT INTO moa_vpl VALUES ("LK8_14","072_8_14","LUK","8","14","14","Mɛɛ 'ke mu ‑o 'bhii‑ pɛbhɛ mu 'la 'klalaa lɛrɛ mu 'ɛ 'yi. 'Ke ‑o ‑Waanbhaa' ‑jan 'ɛ ꞊maa, ‑wa ‑dewo' 'ke ‑o zru ba 'ŋgami mu 'ɛ 'le, 'bhɛ 'pegee ‑naflo maza mu ‑lrɔ mu 'pegee 'trɛ ta pɛ mu ‑lrɔ mu 'ɛ 'le. 'Bhɛ ‑za mu 'ɛ 'kɔɔ, ‑o ‑yrɛ ba laa sɔ 'kanle ‑Waanbhaa' a pɛ zi 'ɛ ta. ");
INSERT INTO moa_vpl VALUES ("LK8_15","072_8_15","LUK","8","15","15","Mɛɛ 'ke mu ‑o 'bhii‑ pɛbhɛ mu 'la 'klalaa 'trɛ ti ‑yi. 'Ke ‑o ‑Waanbhaa' a ‑jan 'ɛ ꞊maa, ‑wa kpa 'elrele ‑o 'kpee, 'bhɛɛ‑ ‑o blɔɔle bo ‑a ma. ‑Ayile ‑o 'bhɛ 'wlata‑ za ‑lrele' mu klɛ.» ");
INSERT INTO moa_vpl VALUES ("LK8_16","072_8_16","LUK","8","16","16","Zesu pe ‑o ni dɔɔ: «'Ke 'ka ‑laŋbha do ꞊bhia 'ka sɔ 'gboŋgbo do bhulale ‑a ta taa‑ 'ka sɔ ‑a dulale yilapɛ do ‑la ꞊la ɛɛ? 'Ŋ bhe, 'kaa duŋ ‑laŋbha duŋyrɛ 'ɛ 'bhɛ ꞊nɔɔ 'fɛgwlɛ‑ 'ɛ ma, 'kooko‑ 'ke mɛɛ 'la zan mu ‑o wlale‑ 'fɛ 'ɛ ꞊la ‑e sɔ 'mu 'lɛɛ 'kanle, 'bhɛɛ‑ 'mu sɔ yrɛ ma yele‑. ");
INSERT INTO moa_vpl VALUES ("LK8_17","072_8_17","LUK","8","17","17","'Bhɛla‑ ‑yile, pɛ 'oo pɛ 'la magaanle ‑o, 'bhɛ ta nu 'pwɛlɛ‑ kpataakpa, 'bhɛɛ‑ ‑dawli' maza mu 'ɛ 'kpɛn ta nu 'pwɛlɛ‑ mɔkpɛn' 'yrɛ ma, 'bhɛɛ‑ ‑woo dɔ kpataakpa. ");
INSERT INTO moa_vpl VALUES ("LK8_18","072_8_18","LUK","8","18","18","'Bhɛla ‑yile, 'ka 'ka 'trɔnkpa 'ŋ 'wojan‑ mu 'ɛ ꞊la gɔnɛ‑ 'la gbɛɛn‑ bhe, ‑ka 'ka 'yrɛkpa 'elrele 'ka 'gbu 'trɔnkapgbɛya 'ɛ ba. ‑Amasrɔyi 'ke pɛ ‑o mɛɛ 'la zan 'kɔɔ ‑o nu ‑a 'kɔɔpɛ‑ 'ɛ baan' 'kpalɛ‑. 'Duŋ‑ pɛ 'kedo‑ 'kpɔ 'laa ‑o mɛɛ 'la zan 'kɔɔ, ‑a yri ‑o pɛ sanɛ‑ 'la ta ‑a 'kɔɔ, ‑o nu 'bhɛɛ‑ 'kunlɛ‑ 'a 'kɔɔ.» ");
INSERT INTO moa_vpl VALUES ("LK8_19","072_8_19","LUK","8","19","19","Zesu nɛɛ 'pegee ‑a nɛɛnɛ‑ 'gwlaan‑ mu 'ɛ ꞊nwa ‑a ba, 'duŋ‑ ‑zamaa' 'srɛ 'ɛ 'kɔɔ, waa ‑yaa sɔ gele‑ 'tɛnlɛ‑ ‑a ma. ");
INSERT INTO moa_vpl VALUES ("LK8_20","072_8_20","LUK","8","20","20","'Bhɛ 'yi, 'ke mɛɛ mu 'ɛ ‑wa pele‑ Zesu ni dɔɔ: «'E nɛɛ 'pegee 'e nɛɛnɛ‑ 'gwlaan‑ mu 'ɛ ‑wa zi 'bhii‑ ‑o ‑janwo' 'e ni, 'bhɛɛ‑ ‑o dulale ‑o 'pɛɛlii‑.» ");
INSERT INTO moa_vpl VALUES ("LK8_21","072_8_21","LUK","8","21","21","'Bhɛ klɛle 'tɛ, 'ke Zesu 'a 'pele ‑o ni 'kaa: «Mɛɛ mu 'la zan mu ‑o 'trɔnkpa‑ ‑Waanbhaa' wojan 'ɛ ꞊la, 'bhɛɛ‑ 'ke ‑wa ‑yizaklɛ, 'bhɛ zan mu ‑le 'ŋ nɛɛ 'pegee 'ŋ nɛɛnɛ‑ 'gwlaan‑ mu 'le.» ");
INSERT INTO moa_vpl VALUES ("LK8_22","072_8_22","LUK","8","22","22","‑Yrekpaa' do, Zesu 'pegee ‑yaa' *‑klaŋlanɛ mu 'ɛ ‑saan ‑yitakoŋ do 'yi, 'bhɛɛ‑ ‑e pe ‑o ni dɔɔ: «‑Kɔɔ' ‑draa 'ɛ takan', 'bhɛɛ‑ ‑kɔɔ' ge ‑a 'yrɛ gbɛ do 'ɛ ta laale.» ");
INSERT INTO moa_vpl VALUES ("LK8_23","072_8_23","LUK","8","23","23","‑O ‑yaa ‑yi 'ɛ takan' zii' bhla 'la ba 'ke yi 'kpale‑ Zesu 'yrɛ ta, 'bhɛɛ‑ 'kee‑ yidɛle. 'Bhɛ yrɛ do 'ɛ ꞊nɔɔ bhe, 'ke ‑ploo ‑gbɛnɛ do 'kanle 'sanle ‑draa 'ɛ ta. 'Bhɛɛ‑ 'ke ‑yi 'pɔɔ 'ɛ 'klale‑ 'sanle ‑o zi ‑yitakoŋ 'ɛ 'yi, 'bhɛɛ‑ ‑za 'yɔɔ‑ ‑yaa zan 'tɛnlɛ‑ ‑o ma. ");
INSERT INTO moa_vpl VALUES ("LK8_24","072_8_24","LUK","8","24","24","'Bhɛ klɛle 'tɛ, 'ke ‑yaa' ‑klaŋlanɛ mu 'ɛ ‑woo mabɛɛnle ‑a ‑din, 'bhɛɛ‑ 'ke ‑wa pele‑ ‑a ni dɔɔ: «'O Zan, 'o Zan, 'woo‑ zan galɛ.» ‑Ayile, 'ke Zesu bwele‑, 'bhɛɛ‑ 'kee‑ 'pɛɛnle ‑ploo 'ɛ 'pegee ‑yi 'pɔɔ mu 'ɛ ta, 'ke ‑o makpaale, 'bhɛɛ‑ 'ke ‑yi 'ɛ 'yrɛ ta dɔle‑ 'sese. ");
INSERT INTO moa_vpl VALUES ("LK8_25","072_8_25","LUK","8","25","25","'Bhɛ blaan, 'ke Zesu 'a pele ‑o ni 'kaa: «‑Mɛla ma 'ka 'laa 'ka kpa 'mi 'yi ɛɛ?» ‑Gblaan ꞊klaa ‑o ‑yi, 'bhɛ 'pegee ‑o 'kpeelɛnia ‑o ma. 'Bhɛla‑ ‑yile, 'ke ‑woo 'eke‑ ‑lrɔkpale dɔɔ: «Mɛɛ ‑glɔɔn 'ɛ ‑dele mɛɛ 'lɛɛ‑ 'le ɛɛ? ‑E sɔ ‑janwole ‑ploo 'pegee ‑yi mu ni, 'Bhɛɛ‑ 'mu 'a 'weli‑ ma!» ");
INSERT INTO moa_vpl VALUES ("LK8_26","072_8_26","LUK","8","26","26","'Bhɛ blaan, 'ke Zesu 'pegee ‑yaa' ‑klaŋlanɛ mu 'ɛ ‑o 'kanle ‑draa 'yrɛ gbɛ do 'ɛ ta ‑yitakoŋ 'ɛ 'yi, Gadara mu a 'klɛɛn 'ɛ 'yi. 'Bhɛ 'klɛɛn 'ɛ 'pegee Galile 'klɛɛn 'ɛ 'lɛklale ‑yaa 'eke‑ ta. ");
INSERT INTO moa_vpl VALUES ("LK8_27","072_8_27","LUK","8","27","27","Zesu zinale ‑yitakoŋ 'ɛ 'yi, 'bhɛɛ‑ ‑e nule 'trɛ ma 'ke 'bhɛ ‑wa 'ɛ ta mɛɛ do nule‑ ‑a 'lɛpalɛ. 'Zina 'yaa‑ 'bhɛ mɛɛ 'ɛ zi, 'bhɛɛ‑ 'bhɛ ꞊nɔɔ ꞊mwa gban 'ke ‑a tafleŋ‑ baale ‑o. 'Bhɛɛ‑ yaa ‑yaa yi 'fa ꞊la, 'fɔ mɛɛ bu mu 'ɛ ta. ");
INSERT INTO moa_vpl VALUES ("LK8_28","072_8_28","LUK","8","28","28","‑E Zesu 'yele‑, 'kee‑ ‑gbekanle 'eglɔɔle, 'kee‑ baale' 'bhɛ gaan ma, 'bhɛɛ‑ 'ke ‑ya pele‑ 'eglɔɔle dɔɔ: «Laanima ‑Waanbhaa' Gbe Zesu, ꞊ya zi 'bhii‑ 'e ‑mɛla klɛ 'ŋ ni ɛɛ? 'E 'zoole‑ 'yaa ‑yrɛnkpalɛ 'ŋ ta.» ");
INSERT INTO moa_vpl VALUES ("LK8_29","072_8_29","LUK","8","29","29","‑E ‑sromabwa Zesu ni 'bhɛɛ‑ gbɛɛn‑, ‑amasrɔyi Zesu 'yaa‑ pe 'zi 'zina 'la 'yaa‑ ‑a zi 'bhɛ ni dɔɔ 'bhɛ go ‑a zi. 'Bhɛ bɔyrɛ ꞊mwa gban bi ‑a zi. ‑O ‑yaa ‑a gaan mu 'ɛ 'pegee ‑a gbɛ mu tabɔ kpɛlɛ‑ mu 'le. 'Duŋ‑ 'waati 'oo 'waati, ‑e ‑yaa 'bhɛ kpɛlɛ‑ mu 'ɛ takan, 'bhɛɛ‑ 'zina mu 'ɛ ‑wa winblin ‑bɔn ta. ");
INSERT INTO moa_vpl VALUES ("LK8_30","072_8_30","LUK","8","30","30","Zesu 'yee‑ mɛɛ 'ɛ 'lrɔkpaa‑ dɔɔ: «‑Woo' 'ɛ sii 'nale‑ ‑a ma ɛɛ?» ‑E pe 'bhɛ ni dɔɔ: «'Ŋ 'tɔ ‑le: ‑Zamaa' 'srɛ.» ‑Ya ꞊pia ‑a 'gbu ma 'bhɛ 'pegbɛya 'ɛ 'yi bhe, ‑amasrɔyi 'zina 'saa do ‑le ‑yaa ‑a zi. ");
INSERT INTO moa_vpl VALUES ("LK8_31","072_8_31","LUK","8","31","31","'Bhɛla‑ ‑yile, 'zina mu 'ɛ ‑o ‑yaa ‑sromabɔ 'zi Zesu ni 'kaa 'bhɛ 'laa gelɛ ‑o ‑le ‑gluu 'trole‑ ‑gbɛnɛ 'ɛ 'yi. ");
INSERT INTO moa_vpl VALUES ("LK8_32","072_8_32","LUK","8","32","32","꞊Swa 'lɛ ‑gbɛnɛ do ‑yaa pɛbhle zii' ‑o ‑din gɔɔnɛ‑ 'ɛ 'wiiŋ‑ 'bhɛ 'waati do 'kpɔ 'ɛ ba. 'Bhɛla‑ ‑yile 'ke 'zina mu 'ɛ ‑o ‑sromabɔle Zesu ni 'kaa 'bhɛ dɔ ‑a ‑la 'ke ‑o sɔ gele‑ wlalɛ 'bhɛ ꞊swa mu 'ɛ 'yi. 'Bhɛɛ‑ Zesu ‑dwa 'bhɛ ꞊la ‑o ni. ");
INSERT INTO moa_vpl VALUES ("LK8_33","072_8_33","LUK","8","33","33","'Bhɛ klɛle 'tɛ, ‑o gole‑ mɛɛ 'ɛ zi, 'ke ‑o gele‑ wlalɛ ꞊swa mu 'ɛ 'yi. 'Bhɛla‑ ‑yile, 'ke 'woo‑ ꞊swa 'lɛdo‑ ‑o 'ploole ‑o 'gbu ma gɔɔn 'ɛ 'wiiŋ‑, 'ke ‑o nule‑ baalɛ ‑draa 'ɛ ba, 'bhɛɛ‑ 'ke ‑o 'kpɛn gale‑. ");
INSERT INTO moa_vpl VALUES ("LK8_34","072_8_34","LUK","8","34","34","'Bhɛ klɛle 'tɛ, 'woo‑ ꞊swa mu 'ɛ gooba mu 'ɛ ‑o ‑yrɛkpale 'bhɛ ma, 'ke ‑o blasanle, 'bhɛɛ‑ 'ke ‑o gele‑ 'bhɛ ‑jan 'ɛ 'yigɔɔnlɛ ‑wa 'ɛ 'pegee gba la 'kpaa mu 'ɛ ta. ");
INSERT INTO moa_vpl VALUES ("LK8_35","072_8_35","LUK","8","35","35","‑Ayile, 'ke mɛɛ mu 'ɛ 'kpɛn 'pwɛle, 'ke ‑o nule‑ ‑za 'la 'bhɛ ꞊kla 'bhɛ ꞊nɔɔ ‑glinyrɛ' nɔɔ‑. ‑O bhɔle Zesu ‑din, 'zina mu ‑yaa mɛɛ 'la zan zi, 'ke ‑o 'bhɛ 'yele. 'Bhɛ 'yaale‑ ‑yaa Zesu gaan ma, 'bhɛɛ‑ dunɛ‑ ‑yaa 'bhɛ ta, 'bhɛ 'pegee ‑a ‑yrɛ ba 'kpaale‑ ‑yaa. 'Bhɛ ya 'ɛ 'yi, 'ke ‑gblaan 'klale ‑o ‑yi. ");
INSERT INTO moa_vpl VALUES ("LK8_36","072_8_36","LUK","8","36","36","Mɛɛ 'la zan mu 'woo‑ ‑za mu 'ɛ 'kpɛn klɛyrɛ ꞊ya, 'bhɛ mu ‑o 'yigɔɔnna ‑o ni. Zesu 'yee‑ mɛɛ 'ɛ zi 'zina mu 'ɛ ‑gbian gɔnɛ‑ 'la gbɛɛn‑ 'bhɛɛ‑ ‑e ‑bheela, 'mu 'bhɛ 'kpɛn 'yigɔɔnna ‑o ni. ");
INSERT INTO moa_vpl VALUES ("LK8_37","072_8_37","LUK","8","37","37","'Bhɛ klɛle 'tɛ, 'ke 'yee‑ Zerazeni 'klɛɛn 'ɛ 'yi mu 'ɛ 'kpɛn ‑sromabɔle Zesu ni 'kaa 'bhɛ 'e go ‑waa' 'klɛɛn 'ɛ 'yi. ‑Amasrɔyi ‑gblaan 'yɔɔ‑ ‑yaa ‑o ‑yi. ‑Ayile 'ke Zesu 'pegee ‑yaa ‑klaŋlanɛ mu 'ɛ ‑o 'sanle ‑yitakoŋ 'ɛ 'yi, 'bhɛɛ‑ 'ke ‑o jilale. ");
INSERT INTO moa_vpl VALUES ("LK8_38","072_8_38","LUK","8","38","38","'Duŋ‑ 'zina mu ‑yaa mɛɛ 'la zan zi, 'bhɛ ‑sromabwa Zesu ni 'kaa ‑e gele‑ ‑o zi. 'Bhɛɛ‑ 'duŋ‑ Zesu 'laa dɔlɛ 'bhɛ ꞊la ‑a ni, 'bhɛɛ‑ 'bhɛ pe ‑a ni dɔɔ: ");
INSERT INTO moa_vpl VALUES ("LK8_39","072_8_39","LUK","8","39","39","«Ge 'e ba ‑lɛ ma, 'bhɛɛ‑ ‑Waanbhaa' ‑za 'la ꞊kla 'e ni bhe, ge 'bhɛ 'yigɔɔn 'e ba 'fa ꞊la mu 'ɛ ni.» 'Bhɛ klɛle 'tɛ, 'yee‑ mɛɛ 'ɛ gele, Zesu ‑za wlan 'la ꞊kla ‑a ni, 'kee‑ 'bhɛ 'kpɛn 'yigɔɔnle ‑yaa ‑wa 'ɛ ta mu 'ɛ ni. ");
INSERT INTO moa_vpl VALUES ("LK8_40","072_8_40","LUK","8","40","40","Zesu 'pegee ‑yaa ‑klaŋlanɛ mu 'ɛ ‑o nule ‑draa 'yrɛ gbɛ do 'ɛ ta, 'ke ‑zamaa' 'srɛ do ‑o ‑lɛpale, ‑amasrɔyi ‑o 'kpɛn 'yaa‑ ‑a magbɛn 'zi 'bhɛɛ‑ yrɛ 'ɛ ꞊nɔɔ. ");
INSERT INTO moa_vpl VALUES ("LK8_41","072_8_41","LUK","8","41","41","'Bhɛ yrɛ do 'ɛ ꞊nɔɔ bhe, ‑o ‑yaa *Zuufu mu daanfɛ' 'ɛ ꞊la ‑kuŋlii 'la sii Zailusi 'bhɛ ꞊nwa 'bhɛ 'kpɔ zɛnlɛ 'yee‑ Zesu ꞊la, 'ke 'bhɛ 'sromabɔle ‑a ni dɔɔ ‑e ge 'bhɛ ba. ");
INSERT INTO moa_vpl VALUES ("LK8_42","072_8_42","LUK","8","42","42","'Bhɛ 'laa 'sanle‑ bhaama: ‑A ‑lunɛ' bhɛ do 'kpɔ 'la lɛɛ ‑yaa lɛɛ vu ta plɛ, 'bhɛ 'yaa‑ zan galɛ. 'Bhɛla‑ ‑yile, 'ke Zesu dɔle‑ 'tɛ 'yee‑ Zailusi ba ‑lɛ ma zi 'ɛ ta. 'Duŋ‑, ‑a ge bhla 'ɛ 'zi 'yee‑ Zailusi ba ‑lɛ ma 'ɛ ꞊nɔɔ, mɛɛ mu 'ɛ 'yaa‑ 'eke‑ ‑yrɔn 'zi ‑a zi. ");
INSERT INTO moa_vpl VALUES ("LK8_43","072_8_43","LUK","8","43","43","Le do ‑yaa 'woo‑ mɛɛ mu 'ɛ 'pleŋ‑, 'bhɛ lɛɛ vu ta plɛ 'ke 'bhɛ a ‑yito' 'ɛ 'lɛ 'laa kan, ‑ayile ‑e ‑yrɛn ‑bebe ꞊bhla gban. ‑Ya 'kɔɔpɛ‑ mu 'ɛ 'kpɛn ꞊naa ‑a ‑laanɛkpa mu 'ɛ ni, 'duŋ‑ 'mu do 'kpɔ 'laa klɛlɛ ‑a ‑bhee pɛ 'le. ");
INSERT INTO moa_vpl VALUES ("LK8_44","072_8_44","LUK","8","44","44","'Bhɛɛ‑ ‑e ‑nwa yrɛtɛtɛ Zesu ‑zanta' 'ke ‑ya gbɛ ‑nɛbhɛ' do ‑zwanle' Zesu ta dunɛ‑ 'ɛ ma. 'Bhɛ klɛle 'tɛ, 'ke yaa ‑yito' 'ɛ 'lɛkanle 'bhɛ yrɛ do 'kpɔ ɛ ꞊nɔɔ bhe. ");
INSERT INTO moa_vpl VALUES ("LK8_45","072_8_45","LUK","8","45","45","‑Ayile, 'ke Zesu mɛɛ mu 'ɛ 'lrɔkpale dɔɔ: «‑Dele 'e gbɛ ‑yaan 'ŋ ma ɛɛ?» ‑O 'kpɛn ‑o ‑lɛ ma ‑dwa 'eglɔɔle 'bhɛ ta. ‑Ayile 'ke Piɛri 'a 'pele Zesu ni dɔɔ: «'Ŋ zan, 'e 'yrɛkpa ‑zamaa' 'ɛ ta ‑gɛ 'eke‑ ‑yrɔn yrɛ ꞊nɔɔ 'e zi.» ");
INSERT INTO moa_vpl VALUES ("LK8_46","072_8_46","LUK","8","46","46","'Duŋ‑ Zesu pe ‑a ni dɔɔ: «Mɛɛ do ‑yaan 'ŋ ma, ‑amasrɔyi faŋgan‑ do ‑pwɛla 'ŋ 'yi.» ");
INSERT INTO moa_vpl VALUES ("LK8_47","072_8_47","LUK","8","47","47","'Bhɛ klɛle 'tɛ, 'yee‑ le 'ɛ ‑ya 'yaangole 'bhii‑ ‑wa tapwɛla, 'kee‑ nule‑ ‑a 'kpɔ zɛnlɛ Zesu 'lɛɛ. ‑E ‑yaa bɛɛn 'zi ‑gblaan 'ɛ 'kɔɔ. 'Bhɛɛ‑ ‑ya gbɛ ‑nɛbhɛ' ‑yaan Zesu ma ‑za 'la ma, 'bhɛ 'pegee ‑e ‑bheela gɔnɛ‑ 'la gbɛɛn‑ blaale‑ 'kee‑ 'bhɛ 'kpɛn 'yigɔɔnle mɔkpɛn' 'yrɛ ma. ");
INSERT INTO moa_vpl VALUES ("LK8_48","072_8_48","LUK","8","48","48","'Bhɛ klɛle 'tɛ, 'ke Zesu 'a 'pele ‑a ni dɔɔ: «'Ŋ 'lunɛ, 'yee 'e 'kpalawoa 'mi 'yi bhe, 'e bheela‑. Ge 'e ba ‑lɛ ma zrukpaa' ta.» ");
INSERT INTO moa_vpl VALUES ("LK8_49","072_8_49","LUK","8","49","49","Zesu 'yaa‑ 'bhɛ ‑jan 'ɛ 'wo zii' bhla 'la ba, 'ke mɛɛ do dale‑ Zuufu mu daanfɛ' 'ɛ ‑kuŋlii 'ɛ ba ‑lɛ ma, 'bhɛɛ‑ 'ke 'bhɛ 'a pele‑ 'yee‑ ‑kuŋlii 'ɛ ni dɔɔ: «'E 'nɛ 'ɛ ꞊kla siɛle‑, 'yaa ‑kɔɔ' Zan 'trɛbhɔlɛ.» ");
INSERT INTO moa_vpl VALUES ("LK8_50","072_8_50","LUK","8","50","50","'Duŋ‑ Zesu 'trɔn bɔle 'bhɛ wojan 'ɛ 'yi, 'ke ‑ya pele‑ Zailusi ni dɔɔ: «'Yaa ‑gblaanlɛ', 'ke 'yee ꞊kpa drɔŋ 'mi 'yi 'e 'nɛ nu ‑bheelɛ'.» ");
INSERT INTO moa_vpl VALUES ("LK8_51","072_8_51","LUK","8","51","51","‑O bhɔle 'yee‑ Zailusi ba ‑lɛ ma, 'ke Zesu 'a pele‑ dɔɔ mɛɛ 'kedo‑ 'kpɔ 'laa wlalɛ ‑a zi 'fɛ 'ɛ ꞊la, 'ke yaa 'e go 'yee‑ Zesu 'gbu 'pegee Piɛri, 'bhɛɛ Zaan 'pegee Zaki, 'bhɛɛ‑ ‑nɛ 'ɛ 'yapɛ‑ mu 'ɛ ba. ");
INSERT INTO moa_vpl VALUES ("LK8_52","072_8_52","LUK","8","52","52","'Bhɛ 'waati 'ɛ ba, mɛɛ mu 'ɛ 'kpɛn 'yaa‑ ‑yrɛn ma wisi' zii' ‑nɛ 'ɛ ta. 'Bhɛ klɛle 'tɛ, 'ke Zesu 'a 'pele ‑o ni dɔɔ: «'Ka 'laa wisilɛ, ‑nɛ 'ɛ yaa galɛ, ‑yoo yidɛ 'zi.» ");
INSERT INTO moa_vpl VALUES ("LK8_53","072_8_53","LUK","8","53","53","‑Ayile, 'ke ‑o 'sɔnsile Zesu ma, ‑amasrɔyi ‑o 'kpɛn 'yaa‑ ‑a 'yaango‑ 'bhii‑ 'yee‑ ‑gblanɛ 'ɛ ‑gaa. ");
INSERT INTO moa_vpl VALUES ("LK8_54","072_8_54","LUK","8","54","54","'Bhɛ klɛle 'tɛ, 'ke Zesu 'kunle ‑nɛ 'ɛ gbɛ ma, 'bhɛɛ‑ 'kee‑ ‑gbekanle 'eglɔɔle dɔɔ: «‑Gblanɛ, 'e 'wlɛn‑!» ");
INSERT INTO moa_vpl VALUES ("LK8_55","072_8_55","LUK","8","55","55","'Bhɛ yrɛ do 'ɛ ꞊nɔɔ bhe, 'ke ‑a nii‑ 'ɛ bɔle‑ ‑a ‑yi, 'bhɛɛ‑ 'ke ‑ya ‑wlɛnle'. ‑Ayile 'ke Zesu 'a 'pele dɔɔ ‑o pɛle na 'yee‑ ‑gblanɛ 'ɛ ni. ");
INSERT INTO moa_vpl VALUES ("LK8_56","072_8_56","LUK","8","56","56","‑A dɛ 'pegee ‑a nɛɛ mu ‑liibhaala ‑o ma 'kee‑ kan ‑a ‑daŋ' ta. 'Bhɛɛ‑ Zesu ‑o ‑lɛmazwan 'kaa ‑za 'la 'bhɛ ꞊kla ‑o lunɛ' 'ɛ ni waa 'bhɛ 'yigɔɔnlɛ mɛɛ 'kedo‑ 'kpɔ ni. ");
INSERT INTO moa_vpl VALUES ("LK9_1","072_9_1","LUK","9","1","1","Zesu ‑yaa' ‑klaŋlanɛ vu ta plɛ 'ɛ 'siila‑, 'bhɛɛ‑ ‑e 'zina ‑gbin 'seŋ 'pegee gadɛ mu ‑bhee 'seŋ ꞊naa ‑o ni. ");
INSERT INTO moa_vpl VALUES ("LK9_2","072_9_2","LUK","9","2","2","'Bhɛ blaan, 'ke ‑yoo winbɔle 'kaa ‑o ge ‑Waanbhaa' a ‑bhleŋgbeya ma jan ‑nrale' 'ɛ wo 'bhɛ 'pegee ‑o ge gadɛ mu ‑bhee'. ");
INSERT INTO moa_vpl VALUES ("LK9_3","072_9_3","LUK","9","3","3","'Bhɛɛ‑ ‑e pe ‑o ni dɔɔ: «'Ka ‑o ge 'zi 'taa 'la ta bhe, 'ka 'laa pɛ 'kedo‑ 'kpɔ 'silɛ‑: 'ka 'taawo 'beni oo, gbɛn ta ge 'pepe oo, pɛle oo, ‑gɔli' oo, 'bhɛɛ‑ 'ka 'laa dunɛ‑ plɛ 'silɛ‑. ");
INSERT INTO moa_vpl VALUES ("LK9_4","072_9_4","LUK","9","4","4","'Ke 'ka ‑ja 'fɛ 'oo 'fɛ 'la ꞊nɔɔ, 'ke ‑o 'ka 'cie ꞊sia 'elrele 'bhɛ ꞊nɔɔ, ‑ka bo 'bhɛ 'fɛ 'ɛ ꞊la 'fɔke 'bhɛ ge 'tɛnlɛ‑ 'ka ge yi 'ɛ ma. ");
INSERT INTO moa_vpl VALUES ("LK9_5","072_9_5","LUK","9","5","5","'Duŋ‑ 'ke 'ka ‑ja ‑wa 'oo ‑wa 'la ta, 'bhɛɛ‑ 'ke waa 'kaa‑ 'cie 'silɛ‑ 'elrele 'bhɛ ꞊nɔɔ, ‑ka go 'bhɛ ‑wa 'ɛ ta. 'Bhɛɛ‑ 'ka go bhla 'ɛ zi ‑kaa ꞊nɔɔ bwegblɛn‑ 'ɛ 'wlɛn 'ka gaan mu 'ɛ 'le: 'bhɛ bwegblɛn‑ 'wlɛnle‑ 'ɛ nu klɛlɛ ‑waa yiɛnya 'ɛ ma ‑tɔɔmasie 'le.» ");
INSERT INTO moa_vpl VALUES ("LK9_6","072_9_6","LUK","9","6","6","'Bhɛ klɛle 'tɛ, Zesu a ‑klaŋlanɛ mu 'ɛ ‑o ‑ja ‑wa mu 'ɛ 'kpɛn ta. ‑O ‑yaa ‑Jan 'Nrale‑ 'ɛ 'wo zii', 'bhɛ 'pegee 'ke ‑o gadɛ mu ‑bebe bhee ‑o 'kanyrɛ‑ mu 'ɛ 'kpɛn ꞊nɔɔ. ");
INSERT INTO moa_vpl VALUES ("LK9_7","072_9_7","LUK","9","7","7","Mɛɛ Wiiŋfɛ' Mi Zaan dɛle blaan, 'ke Galile 'klɛɛn 'ɛ ta ‑bhleŋgbe Erɔdi Zesu klɛza mu 'ɛ 'kpɛn 'male, 'bhɛɛ‑ 'ke ‑a zrubatɛdɔle. ‑Amasrɔyi mɛɛ 'ke mu ‑yaa 'pe 'zi dɔɔ: «Mɛɛ Wiiŋfɛ' Mi Zaan ‑bwela gale ba.» ");
INSERT INTO moa_vpl VALUES ("LK9_8","072_9_8","LUK","9","8","8","Mɛɛ 'ke mu ‑yaa 'pe 'zi dɔɔ: «*Eli ‑le nu gbɛ drɛɛwoa‑ 'ezin‑.» 'Bhɛɛ‑ mɛɛ ‑bhɛɛke' mu ‑yaa pe 'zi dɔɔ: «‑Waanbhaa' ‑lɛla' janwo mu gwe gwe 'ɛ do ‑le ‑bwela gale ba.» ");
INSERT INTO moa_vpl VALUES ("LK9_9","072_9_9","LUK","9","9","9","'Yee‑ Erɔdi 'gbu pe dɔɔ: «'An ꞊pia mɛɛ mu ni 'kaa ‑o Zaan ŋgblo 'kan, 'bhɛɛ‑ ‑o 'bhɛ ꞊kla. 'Ŋ 'yoo‑ mɛɛ 'ɛ ‑de 'gbu ‑la klɛza mu ‑lrele' ma 'zi ‑gee' ɛɛ?» ‑Ayile ‑e ‑yaa zi 'bhii‑ ‑e Zesu 'ye. ");
INSERT INTO moa_vpl VALUES ("LK9_10","072_9_10","LUK","9","10","10","Zesu ‑yaa' ‑klaŋlanɛ vu ta plɛ 'la 'winbwa‑, 'mu dale 'taa 'ɛ ta, 'ke ‑woo klɛza mu 'ɛ 'kpɛn 'yigɔɔnle 'a ni. 'Bhɛ klɛle 'tɛ, 'ke Zesu gele‑ ‑o ‑le mɛɛ mu 'ɛ 'yrɛ ‑gɔma' Bɛtisaida ‑wa 'ɛ ba ‑yrɛ ta. ");
INSERT INTO moa_vpl VALUES ("LK9_11","072_9_11","LUK","9","11","11","'Duŋ‑ ‑zamaa' mu 'ɛ ‑woo geza 'ɛ Bɛtisaida 'bhɛ 'male‑, 'kee‑ ‑o gele ‑o zi 'bhɛ ꞊nɔɔ. ‑Ayile 'ke Zesu ‑o 'kunle 'elrele. 'Bhɛɛ‑ 'kee‑ ‑Waanbhaa' a ‑bhleŋgbeya ma ‑jan 'ɛ 'wole ‑o ni, 'bhɛ 'pegee ga ‑yaa mɛɛ 'la zan mu ma ‑e 'mu 'kpɛn 'bheela‑. ");
INSERT INTO moa_vpl VALUES ("LK9_12","072_9_12","LUK","9","12","12","Yromazi bhɔle ‑saan bhla 'la ba, 'ke ‑yaa' ‑klaŋlanɛ vu ta plɛ 'ɛ ‑woo mabɛɛnle 'a ‑din, 'bhɛɛ‑ 'ke ‑wa pele‑ ‑a ni dɔɔ: «‑Kɔɔ' ‑o ‑bɔn drɛyi' ‑gɛ bhe, ‑a pe mɛɛ mu 'ɛ ni dɔɔ ‑o ge ‑o yilayrɛ mu 'pegee ‑o le pɛle mu ‑glin ‑kɔɔ' ‑din ‑wa mu 'ɛ 'pegee gba la 'kpaa mu 'ɛ ta.» ");
INSERT INTO moa_vpl VALUES ("LK9_13","072_9_13","LUK","9","13","13","'Bhɛ klɛle 'tɛ, 'ke Zesu 'a 'pele ‑o ni dɔɔ: «'Ka mu 'gbu pɛle na ‑o ni!» ‑Ayile 'ke ‑wa pele ‑a ni dɔɔ: «Pɛ 'kedo‑ 'kpɔ 'laa ‑o 'kɔɔ 'ke yaa 'e go 'bluu 'yri 'soo 'pegee kaa plɛ ba. 'Fɔke 'o ‑ja mɛɛ mu 'lɛɛ‑ 'kpɛn 'lɛbɔ‑ pɛ ‑lɔlɛ'.» ");
INSERT INTO moa_vpl VALUES ("LK9_14","072_9_14","LUK","9","14","14","Wlan 'ɛ ni, 'gwlaan‑ 'waa 'soo ‑le ‑yaa ‑o zi 'bhɛ 'waati 'ɛ ba. 'Bhɛ klɛle 'tɛ, 'ke Zesu 'a 'pele ‑yaa' ‑klaŋlanɛ mu 'ɛ ni dɔɔ: «‑Ka ‑o yala‑ mɛɛ mia plɛ bhɛ vu ‑lɛ ma ‑lɛ ma.» ");
INSERT INTO moa_vpl VALUES ("LK9_15","072_9_15","LUK","9","15","15","‑Ayile, Zesu 'a ꞊pia ‑o ni 'kaa ‑o mɛɛ mu 'ɛ 'yala‑ yaa‑ gbɛya 'la 'yi, ‑yaa' ‑klaŋlanɛ mu 'ɛ 'mu 'bhɛɛ‑ ꞊kla. ");
INSERT INTO moa_vpl VALUES ("LK9_16","072_9_16","LUK","9","16","16","'Bhɛ blaan, 'ke Zesu 'bluu 'yri 'soo 'ɛ 'pegee kaa plɛ 'ɛ 'sile, 'ke ‑ya ‑yrɛkpale laanima, 'bhɛɛ‑ 'kee‑ ‑Waanbhaa' 'pubɔle 'mu ma. 'Bhɛ blaan, 'kee‑ 'bluu mu 'ɛ takanle kplokplo, 'bhɛɛ‑ 'ke ‑ya pele‑ ‑yaa' ‑klaŋlanɛ mu 'ɛ ni dɔɔ ‑woo ‑yiciɛn' ‑zamaa' 'ɛ ma. ");
INSERT INTO moa_vpl VALUES ("LK9_17","072_9_17","LUK","9","17","17","Mɔkpɛn' pɛbhla‑, 'bhɛɛ‑ mɔkpɛn' kpɛdwa‑, 'bhɛɛ‑ pɛle 'ɛ 'ke ꞊bwa. ‑O le pɛle ‑vin 'la ꞊bwa, 'bhɛ ciɛ ‑nɛ vu ta plɛ ‑paa. ");
INSERT INTO moa_vpl VALUES ("LK9_18","072_9_18","LUK","9","18","18","‑Yrekpaa' do, Zesu do ‑kplɛn ‑ja ‑a 'seriwolɛ yrɛ do ꞊nɔɔ, 'bhɛɛ‑ ‑yaa' ‑klaŋlanɛ mu 'ɛ ‑ja 'tɛnlɛ‑ ‑a ma 'bhɛ yrɛ 'ɛ ꞊nɔɔ ye. 'Bhɛɛ‑ ‑yoo ‑lrɔkpaa dɔɔ: «Mɛɛ mu 'ɛ 'kpee ma, 'mi ‑o mɛɛ ‑glɔɔn 'ɛ ‑dela ‑le ɛɛ?» ");
INSERT INTO moa_vpl VALUES ("LK9_19","072_9_19","LUK","9","19","19","'Bhɛ klɛle 'tɛ, 'ke ‑wa pele‑ dɔɔ: «Mɛɛ 'ke mu pe dɔɔ 'yoo‑ 'ke Mɛɛ Wiiŋfɛ' Mi Zaan 'le, ‑a 'ke mu pe dɔɔ 'yoo‑ 'ke *Eli 'le. ‑A ‑lɛdo' pe 'ezin‑ dɔɔ ‑Waanbhaa' *‑lɛla' janwo mu gwe gwe 'ɛ do ‑le ‑bwela gale ba, 'bhɛɛ‑ 'bhɛ ‑le 'bhi 'le.» ");
INSERT INTO moa_vpl VALUES ("LK9_20","072_9_20","LUK","9","20","20","‑Ayile, 'ke Zesu 'woo‑ 'gbu 'lrɔkpale 'kaadɔɔ‑: «'Ka mu 'kpee ma ‑dele 'mi 'gbu 'le ɛɛ?» Piɛri pe dɔɔ: «'Bhi ‑le *Krisi 'le, ‑Waanbhaa' Mɛɛ ‑Bhee Mi ‑Kpɔsɔɔ 'gbu 'la ꞊kpaa 'bhɛ ‑le 'bhi 'le.» ");
INSERT INTO moa_vpl VALUES ("LK9_21","072_9_21","LUK","9","21","21","'Bhɛ ya 'ɛ 'yi, Zesu ‑o ‑lɛmazwan dɔɔ waa 'bhɛ za 'ɛ 'pelɛ‑ mɛɛ 'kedo‑ 'kpɔ ni. ");
INSERT INTO moa_vpl VALUES ("LK9_22","072_9_22","LUK","9","22","22","Zesu pe ‑yaa' ‑klaŋlanɛ mu 'ɛ ni 'ezin‑ dɔɔ: «‑A ‑lɛdulale ‑o dɔɔ Bhaaplɛŋ Gbe 'ɛ nu ‑yrɛn ‑bebe bhlelɛ mɛɛ mu 'kɔɔ: Zuufu mu a 'gwlaan‑ gblaan mu 'ɛ 'pegee *'sraka 'lɛna mu ‑kuŋlii mu 'ɛ, 'bhɛɛ‑ *'Toŋ daan mu 'ɛ ‑o nu ‑o ‑baŋgolɛ ‑a ‑yi. 'Bhɛɛ‑ ‑o nu a pelɛ 'kaa ‑wa dɛ. 'Duŋ‑ ‑e nu bwelɛ gale ba ‑a dɛle blaan ‑yrekpaa' yaga mi ma.» ");
INSERT INTO moa_vpl VALUES ("LK9_23","072_9_23","LUK","9","23","23","'Bhɛ blaan, 'ke ‑ya pele‑ 'ezin‑ dɔɔ: «'Ke mɛɛ 'la zan 'a ꞊pia 'kaa ‑yoo zan 'ŋ zi, 'bhɛ zan 'ɛ 'niigo‑ ‑a 'gbu 'yi, 'bhɛɛ‑ ‑e dɔ ‑yrɛnbhlele ‑la yi 'oo yi, 'ali‑ 'ke 'bhɛ ge 'tɛnlɛ‑ ‑a gale ma; 'bhɛɛ‑ 'bhɛ zan nu dɔlɛ 'ŋ zi 'tɛ. ");
INSERT INTO moa_vpl VALUES ("LK9_24","072_9_24","LUK","9","24","24","‑Amasrɔyi 'ke mɛɛ 'la zan ‑a zi 'bhii‑ ‑ya 'gbu a 'trɛ ta ‑si 'ɛ go ‑za ‑yi, 'bhɛ zan nu bloolɛ 'bhɛ 'si 'ɛ 'yi. 'Duŋ‑ 'ke mɛɛ 'la zan 'e zru ‑gwa ‑a 'gbu 'si 'ɛ ni 'mi ‑zayi', 'bhɛ zan nu golɛ ‑za 'yi. ");
INSERT INTO moa_vpl VALUES ("LK9_25","072_9_25","LUK","9","25","25","'Ke bhaaplɛŋ do 'trɛ ta pɛ mu 'ɛ 'kpɛn 'srɔɔwoa‑, 'bhɛɛ‑ 'ke yaa bole ‑yrɛ ma ‑si 'ɛ 'srɔɔwolɛ, 'bhɛɛ‑ 'ke ‑a ‑lɛyaan ‑jranama 'tɛ 'ɛ 'yi; 'bhɛ 'trɔn‑ ‑a ma ‑mɛla ‑le ɛɛ? ");
INSERT INTO moa_vpl VALUES ("LK9_26","072_9_26","LUK","9","26","26","'Ke mɛɛ 'la zan ‑yralakpaa 'mi 'pegee 'mi 'wojan‑ mu 'ɛ 'lɛɛ, Bhaaplɛŋ Gbe 'ɛ nu ‑yralakpalɛ 'bhɛ zan 'ɛ 'lɛɛ, 'kee‑ ꞊nwa yi 'la 'le ‑yaa' 'tɔbhɔleya 'ɛ 'yi 'yee‑ 'pegee ‑a Dɛ ‑Waanbhaa' 'bhɛɛ‑ ‑mlɛkɛ' 'weŋ mu 'ɛ 'le. ");
INSERT INTO moa_vpl VALUES ("LK9_27","072_9_27","LUK","9","27","27","'Mi pe 'ka ni 'ŋ 'sɔwɛɛ‑ 'ɛ ma dɔɔ: Mɛɛ 'la zan mu 'kpɛn ‑o ‑gɛ ‑zɔn, ‑a 'ke mu gale pleŋ‑, ‑o ‑yrɛ nu 'kpalɛ‑ ‑Waanbhaa' a ‑bhleŋgbeya yi 'ɛ ma.» ");
INSERT INTO moa_vpl VALUES ("LK9_28","072_9_28","LUK","9","28","28","‑Gbɛɛyi' do 'kanle blaan, 'ke 'yee‑ Zesu Piɛri 'pegee Zaan 'bhɛɛ‑ Zaki 'siile, 'ke ‑o gele 'sanlɛ‑ vlɛ gɔɔn do wiiŋ‑. ‑O ‑ja ‑o 'seriwolɛ 'bhɛ ꞊nɔɔ ye. ");
INSERT INTO moa_vpl VALUES ("LK9_29","072_9_29","LUK","9","29","29","Zesu 'yaa‑ 'seriwo zii' bhla 'la ba 'ke ‑a dɔgbɛya 'ɛ niinale, 'bhɛɛ‑ 'ke ‑a ta dunɛ‑ 'ɛ klɛle‑ 'epu 'peŋpeŋle. ");
INSERT INTO moa_vpl VALUES ("LK9_30","072_9_30","LUK","9","30","30","'Bhɛ yrɛ do 'ɛ ꞊nɔɔ bhe, 'ke mɛɛ plɛ 'pwɛle ‑a ba, 'bhɛɛ‑ 'kee‑ ‑balo klɛle 'sanle 'mu 'le: *Moizi 'pegee *Eli ‑le ‑yaa 'bhɛ mɛɛ plɛ 'ɛ 'le. ");
INSERT INTO moa_vpl VALUES ("LK9_31","072_9_31","LUK","9","31","31","‑O mɛɛ plɛ ‑pwɛla ‑Waanbhaa' a ‑lreleya 'ɛ 'yi, Zesu nu gelawolɛ Zeruzalɛmu 'taa 'la ta bhe, 'bhɛɛ‑ ‑e ‑yaa nu ‑Waanbhaa' zru maza 'la klɛlɛ, ‑o 'bhɛ ‑za mu 'ɛ 'kpɛn ta ‑balo ꞊kla. ");
INSERT INTO moa_vpl VALUES ("LK9_32","072_9_32","LUK","9","32","32","'Bhɛ 'waati 'ɛ ba, Piɛri 'pegee a madɔ mi plɛ 'ɛ, ‑yaa yidɛ 'zi. 'Bhɛɛ‑ 'duŋ‑, ‑o ‑bwele', 'ke ‑o Zesu 'lreleya ‑yrayra 'ɛ 'bhile‑ 'pegee mɛɛ plɛ 'ɛ 'yele‑ ‑a ‑din. ");
INSERT INTO moa_vpl VALUES ("LK9_33","072_9_33","LUK","9","33","33","'Woo‑ mɛɛ plɛ 'ɛ 'yaa‑ go 'zi Zesu ‑din bhla 'la ba, Piɛri pe Zesu ni dɔɔ: «'O Zan, 'o klɛlawoa ‑gɛ 'waati 'ɛ 'lɛɛ‑ ba 'bhɛ ꞊kla 'elrele, ‑ayile 'woo‑ zan 'kpaanɛ yaga dɔlɛ: 'Bhi a pɛ do, Moizi a pɛ do 'bhɛɛ‑ Eli a pɛ do.» 'Yee‑ Piɛri ‑yaa ‑jan 'la 'bhɛ 'wo zii', ‑a 'gbu 'laa ‑yaa 'bhɛ 'yaango‑ 'zi. ");
INSERT INTO moa_vpl VALUES ("LK9_34","072_9_34","LUK","9","34","34","‑E ‑yaa 'bhɛ ‑jan 'ɛ 'wo zii' bhla 'la ba, 'ke laflɛ' ‑gblɛn do nule‑, 'bhɛɛ‑ 'ke 'bhɛ lii 'ɛ 'kpale ‑o ta. ‑Ayile 'ke ‑gblaan ‑gbɛnɛ do 'klale ‑o ‑yi. ");
INSERT INTO moa_vpl VALUES ("LK9_35","072_9_35","LUK","9","35","35","'Bhɛɛ‑ 'ke ‑weli do dale‑ 'yee‑ laflɛ' ‑gblɛn 'ɛ 'yi dɔɔ: «'Mi 'ŋ Gbe 'la makwan‑ 'yele‑ ‑gɛ, ‑ka 'ka 'trɔnkpa 'a ni 'elrele!» ");
INSERT INTO moa_vpl VALUES ("LK9_36","072_9_36","LUK","9","36","36","'Bhɛ ‑weli' 'ɛ 'male‑ blaan, ‑o Zesu do ‑kplɛnnɛ' ‑la ꞊ya. 'Duŋ‑ 'woo‑ Zesu a ‑klaŋlanɛ mu 'ɛ waa 'bhɛ ‑za 'ɛ sanɛ‑ 'wolɛ‑ mɛɛ 'kedo‑ 'kpɔ ni 'bhɛ 'waati 'ɛ ba. ");
INSERT INTO moa_vpl VALUES ("LK9_37","072_9_37","LUK","9","37","37","'Bhɛ ta tooklin‑ yi 'ɛ 'le, 'ke Zesu gole‑ gɔɔn 'ɛ 'wiiŋ‑, 'bhɛɛ‑ 'kee‑ nule‑ ‑a kpɛ ‑la. 'Ezin‑ 'ke ‑zamaa' do nule ‑a ‑lɛpalɛ. ");
INSERT INTO moa_vpl VALUES ("LK9_38","072_9_38","LUK","9","38","38","'Bhɛ 'yi 'tɛ, 'ke mɛɛ do ‑gbekanle 'sanle ‑zamaa' 'ɛ 'pleŋ‑ dɔɔ: «'Ŋ Zan, 'yrɛkpa 'ŋ gbe ‑nɛbhɛ' do 'kpɔ 'ɛ ta ‑gɛ! ");
INSERT INTO moa_vpl VALUES ("LK9_39","072_9_39","LUK","9","39","39","'Zina 'la ‑ya zi, 'kee ꞊pwa ‑a ta 'waati 'la ba, ‑e ‑gbekan' 'eglɔɔle, 'bhɛɛ‑ ‑e bɛɛn ‑kpakpa 'eglɔɔle, 'bhɛɛ‑ ‑ya ‑liile' 'plii 'ɛ pwɛ ‑a ‑lɛ ma. ‑E ‑yrɛn 'ɛ 'kpɛn ‑glɔɔn kpa a ta, 'bhɛɛ‑ yaa go ‑a ta veŋ‑. ");
INSERT INTO moa_vpl VALUES ("LK9_40","072_9_40","LUK","9","40","40","‑Ayile, 'ŋ ꞊nwa 'tɛnlɛ‑ 'yaa‑ ‑klaŋlanɛ mu 'ɛ ma, 'bhɛɛ‑ 'ŋ ‑sromabwa ‑o ni dɔɔ ‑o 'yee‑ 'zina 'ɛ ‑gbin ‑a zi 'bhɛɛ‑ waa 'sɔlɛ‑ 'bhɛ klɛle‑.» ");
INSERT INTO moa_vpl VALUES ("LK9_41","072_9_41","LUK","9","41","41","'Bhɛ klɛle 'tɛ, 'ke Zesu 'lale ‑yaa' ‑klaŋlanɛ mu 'ɛ ta dɔɔ: «Mɛɛ 'kpee 'yɔɔ‑ mu, 'bhɛɛ‑ 'ka 'laa 'ka kpa 'ŋ 'yi! ‑A ‑vinbwa 'waati 'wɛɛ‑ 'ke 'ŋ bo 'ka 'kwe 'sile‑ ma ɛɛ? Nu 'e gbe 'ɛ 'le 'ŋ ni ‑gɛ.» ");
INSERT INTO moa_vpl VALUES ("LK9_42","072_9_42","LUK","9","42","42","‑O ‑yaa zan ‑nɛ 'ɛ 'le Zesu ni 'waati 'la ba, 'ke 'zina 'ɛ 'pɔle ‑a ta, 'ke ‑ya blinle‑ 'trɛ ma, 'bhɛɛ‑ 'kee‑ bɛɛnle‑ ‑kpakpa. 'Bhɛ 'yi bhe 'tɛ, 'ke Zesu 'pɛɛnle 'yee‑ 'zina 'ɛ ta 'eglɔɔle, 'bhɛɛ‑ 'ke ‑nɛ 'ɛ 'bheele. 'Bhɛ blaan 'ke Zesu 'a 'nale ‑a dɛ ni. ");
INSERT INTO moa_vpl VALUES ("LK9_43","072_9_43","LUK","9","43","43","'Bhɛ klɛgbɛya 'ɛ gbɛɛn‑ bhe, ‑Waanbhaa' a ‑glɔɔya' 'ɛ ‑e mɔkpɛn' 'kpeelɛnia. Zesu klɛza mu 'ɛ ꞊yaa mɔkpɛn' 'kpeelɛni zii', ‑ayile ‑e pe ‑yaa' ‑klaŋlanɛ mu 'ɛ ni dɔɔ: ");
INSERT INTO moa_vpl VALUES ("LK9_44","072_9_44","LUK","9","44","44","«'Ŋ 'yoo‑ zan ‑jan 'la 'wolɛ‑ 'ka ni ‑gɛ bhe, ‑kaa 'kpa 'elrele 'ka 'kpee: ‑Woo zan ‑dawli' 'kpalɛ‑ Bhaaplɛŋ Gbe 'ɛ gbɛ ta, 'bhɛɛ‑ ‑wa ‑lɛna' mɛɛ mu ni.» ");
INSERT INTO moa_vpl VALUES ("LK9_45","072_9_45","LUK","9","45","45","'Duŋ‑ waa 'bhɛ ‑jan 'ɛ 'yimalɛ, ‑amasrɔyi ‑gblo ‑yaa ‑o yikan' 'yrɛ ta,'bhɛɛ‑ waa ‑yaa sɔ ‑a ‑yimale kplankplan. 'Bhɛɛ‑ waa 'sɔlɛ‑ Zesu 'lrɔkpale ‑a ‑yi 'ɛ ma, ‑amasrɔyi ‑o ‑yaa ‑gblaan 'zi 'bhɛ 'lɛɛ. ");
INSERT INTO moa_vpl VALUES ("LK9_46","072_9_46","LUK","9","46","46","Zesu a ‑klaŋlanɛ mu 'ɛ ‑o zaabɔle ‑saan ‑za do ta dɔɔ ‑o ‑de 'gbu ‑la gblaan ‑yiya' ‑o 'kpɛn ba. ");
INSERT INTO moa_vpl VALUES ("LK9_47","072_9_47","LUK","9","47","47","Zesu 'a 'yaangole 'bhii‑ ‑o ‑yaa zaabɔ 'zi 'bhɛɛ‑ ‑za 'ɛ ta, 'kee ‑nɛ 'fiɛntrɔnnɛ do 'kunle 'bhɛ gbɛ ma, 'kee‑ 'bhɛ dulale ‑a ‑din. ");
INSERT INTO moa_vpl VALUES ("LK9_48","072_9_48","LUK","9","48","48","'Bhɛɛ‑ ‑e pe ‑o ni dɔɔ: «'Ke mɛɛ 'la zan ‑nɛ 'lɛɛ‑ ‑za ꞊kwan 'elrele 'mi ‑zayi', 'bhɛ zan 'ɛ 'bhɛ 'mi ‑la ‑za ‑kwan 'elrele bhe. 'Bhɛɛ‑ 'ke mɛɛ 'la zan 'mi ‑za ‑kwan 'elrele, 'bhɛ zan 'ɛ 'bhɛ 'ŋ 'winbɔ‑ mi 'ɛ 'bhɛɛ‑ ‑za ‑kwan 'elrele 'ezin‑ bhe. ‑Ayile 'ke mɛɛ 'la zan 'bhɛ 'gbu mavɛɛla 'ka ba 'bhɛ zan 'ɛ 'bhɛla‑ gblaan 'yiya‑ 'ka 'kpɛn ni.» ");
INSERT INTO moa_vpl VALUES ("LK9_49","072_9_49","LUK","9","49","49","'Bhɛ ya 'ɛ 'yi bhe, 'ke Zaan 'a pele Zesu ni dɔɔ: «'O Daan mi, 'o mɛɛ do ‑ya 'ke ‑yoo 'zina mu ‑gbin 'zi mɛɛ mu zi 'e 'tɔ 'ɛ 'yi. 'O mɔɔ pe ‑a ni 'kaa ‑e 'ploo‑ 'bhɛ ma, ‑amasrɔyi ‑yaa ‑o 'ke 'yaa‑ ‑klaŋlanɛ 'ɛ do 'le.» ");
INSERT INTO moa_vpl VALUES ("LK9_50","072_9_50","LUK","9","50","50","'Bhɛ klɛle 'tɛ, 'ke Zesu 'a 'pele ‑a ni dɔɔ: «'Ka 'laa 'bhɛ 'saawolɛ 'bhɛ zan 'ɛ 'kɔɔ, ‑amasrɔyi, mɛɛ la zan laa ‑o 'ka 'sɔɔnnii 'le, 'bhɛ zan ‑o 'ka 'yiɛnii ‑la ‑le.» ");
INSERT INTO moa_vpl VALUES ("LK9_51","072_9_51","LUK","9","51","51","Zesu a laflɛ' 'yi ge bhla 'la ꞊bhwa ‑wa ‑din, 'ke ‑ya pele‑ dɔɔ ‑e gele‑ ‑cian Zeruzalɛmu. ");
INSERT INTO moa_vpl VALUES ("LK9_52","072_9_52","LUK","9","52","52","'Bhɛ ya 'ɛ 'yi, ‑e mɛɛ 'ke mu winbwa‑ ‑a ‑lɛɛ magaan zayi'. 'Bhɛ zan mu 'ɛ ‑o ‑ja, 'bhɛɛ‑ ‑o ꞊bhwa Samari 'klɛɛn 'ɛ 'yi ‑wa do ta. ");
INSERT INTO moa_vpl VALUES ("LK9_53","072_9_53","LUK","9","53","53","'Duŋ‑ 'bhɛ ‑wa 'ɛ ta mu 'ɛ waa ‑o gbɛdɔlɛ Zesu ꞊la, ‑amasrɔyi ‑e ‑yaa ge 'zi Zeruzalɛmu. ");
INSERT INTO moa_vpl VALUES ("LK9_54","072_9_54","LUK","9","54","54","'Bhɛ klɛle 'tɛ, ‑yaa' ‑klaŋlanɛ mu 'ɛ, Zaki 'pegee Zaan 'bhɛ 'yele‑ 'ke ‑woo zrupliile, 'bhɛɛ‑ 'ke ‑wa pele‑ Zesu ni dɔɔ: «Mɛɛzan, 'ya zi 'bhii 'wa 'pe laflɛ' 'yi 'tɛ 'ɛ ni 'kaa ‑e zina‑ ‑o ta, 'bhɛɛ‑ ‑yoo 'kpɛn kpacie ɛɛ?» ");
INSERT INTO moa_vpl VALUES ("LK9_55","072_9_55","LUK","9","55","55","'Bhɛ 'yi 'tɛ, 'ke Zesu 'lale ‑o ta 'kaa ‑o wojan 'ɛ ‑yoo 'eyɔɔle. ");
INSERT INTO moa_vpl VALUES ("LK9_56","072_9_56","LUK","9","56","56","'Bhɛ blaan, 'ke ‑o gele‑ ‑wa 'bhɛɛke do ta. ");
INSERT INTO moa_vpl VALUES ("LK9_57","072_9_57","LUK","9","57","57","‑O ‑yaa Zeruzalɛmu 'taa 'ɛ ta bhla 'la ba, 'ke mɛɛ do 'a 'pele Zesu ni dɔɔ: «'Kee ‑ja yrɛ 'oo yrɛ 'la ꞊nɔɔ, 'ŋ nu gelɛ 'e zi 'bhɛɛ‑ ꞊nɔɔ.» ");
INSERT INTO moa_vpl VALUES ("LK9_58","072_9_58","LUK","9","58","58","'Bhɛ klɛle 'tɛ, 'ke Zesu 'a 'pele 'a ni dɔɔ: «‑Gbɛŋgbɛni mu yi ‑gluu mu ‑o, 'bhɛɛ‑ laanima maannɛ‑ mu yi 'fɛ mu ‑o, 'duŋ‑ yilayrɛ 'kedo‑ 'kpɔ 'laa ‑o Bhaaplɛŋ Gbe 'ɛ 'kɔɔ 'bhɛɛ‑ ‑ya ‑yitrɛ' 'bhɛ ꞊nɔɔ.» ");
INSERT INTO moa_vpl VALUES ("LK9_59","072_9_59","LUK","9","59","59","'Bhɛ ꞊nɔɔ bhe, Zesu pe mɛɛ ‑bhɛɛke' do ni dɔɔ: «Nu dɔ 'ŋ zi!» 'Bhɛ zan 'ɛ pe ‑a ni dɔɔ: «Mɛɛzan, ‑a 'to 'ke 'ŋ ꞊yaan 'ŋ dɛ binlele 'waati 'la ba 'bhɛɛ‑ 'ŋ nu dɔlɛ 'e zi.» ");
INSERT INTO moa_vpl VALUES ("LK9_60","072_9_60","LUK","9","60","60","'Bhɛ klɛle 'tɛ, 'ke Zesu 'a 'pele 'bhɛ zan 'ɛ ni dɔɔ: «Mɛɛ gbaa mu a gbaa mu 'ɛ 'to ‑o 'kɔɔ, 'bhɛɛ‑ ‑woo bin. 'Bhi 'duŋ‑, ge *‑Waanbhaa' a ‑bhleŋgbeya ma 'ɛ ‑Jan 'Nrale‑ 'ɛ 'wo mɛɛ mu ni.» ");
INSERT INTO moa_vpl VALUES ("LK9_61","072_9_61","LUK","9","61","61","'Bhɛ blaan, 'ke mɛɛ do 'a 'pele Zesu ni dɔɔ: «Mɛɛzan, 'ŋ 'yoo‑ ‑a zi 'bhii‑ 'ŋ dɔ 'e zi, 'duŋ‑ ‑a 'to 'ke 'ŋ ge 'ŋ 'srawo 'an 'fa ꞊la mu 'ɛ ma 'elwale 'pe.» ");
INSERT INTO moa_vpl VALUES ("LK9_62","072_9_62","LUK","9","62","62","‑Ayile 'ke Zesu 'a 'pele ‑a ni dɔɔ: «'Ke mɛɛ 'la zan 'e gbɛ ꞊kpaa dri mu a yewo ‑kpoo 'yri 'ɛ ma, 'bhɛɛ‑ 'ke ‑ya 'yrɛkpaa‑ ‑a ‑zanta', 'bhɛ zan 'ɛ yaa mɛɛ maza ‑yanwo' ‑Waanbhaa' a ‑bhleŋgbeya zi 'ɛ ta.» ");
INSERT INTO moa_vpl VALUES ("LK10_1","072_10_1","LUK","10","1","1","'Bhɛ ‑za mu 'ɛ blaan, Mɛɛzan Zesu ‑klaŋlanɛ mia yaga bhɛ vu makwan‑, 'bhɛɛ‑ ‑yoo winbwa‑ ‑a ‑lɛɛ. 'Yee‑ 'gbu 'yaa‑ nu 'kanlɛ‑ ‑wa mu 'la 'kpɛn 'pegee yrɛ mu 'la 'kpɛn ꞊nɔɔ ‑e pe ‑o ni 'kaa ‑o 'kan ‑sɔ ‑a ‑lɛɛ 'mu 'kpɛn ꞊nɔɔ. ");
INSERT INTO moa_vpl VALUES ("LK10_2","072_10_2","LUK","10","2","2","‑E pe ‑o ni dɔɔ: «‑Mlɔ gba 'ɛ ‑yoo 'egbɛnɛle, 'bhɛɛ‑ ‑e ‑tranna gban, 'duŋ‑ ‑a 'kan mu laa ‑o 'ebebele. ‑Ayile ‑ka ‑sromabɔ gbazan 'ɛ ni dɔɔ 'bhɛ ‑mlɔ 'ɛ 'kan mu 'ɛ baankpa' ‑o ba, 'bhɛɛ‑ ‑wa kan, 'bhɛ 'pegee ‑wa zrɛdɔ. ");
INSERT INTO moa_vpl VALUES ("LK10_3","072_10_3","LUK","10","3","3","‑Ka ge, 'ŋ 'yoo‑ 'ka 'winbɔ‑ 'zi mɛɛ mu 'ɛ ba, 'bhɛɛ‑ 'ka ‑o 'bhii‑ ‑bhlaa gwlɛn bhlonɛ‑ mu klɛ srɔpɛ mu pleŋ‑ gɔnɛ‑ 'la gbɛɛn‑. ");
INSERT INTO moa_vpl VALUES ("LK10_4","072_10_4","LUK","10","4","4","'Ka ge bhla 'ɛ zi, 'ka 'laa ‑gɔli' bɔlɛ 'ka 'wiiŋ‑, 'bhɛɛ‑ 'ka 'laa 'taa ta ge 'pepe 'silɛ‑, 'bhɛ 'pegee 'ka 'laa ‑sawla 'wlalɛ‑ 'ka gaan ma. 'Ka 'laa dulalɛ zi 'lii, 'bhɛɛ‑ 'ka mɛɛ 'pubɔ‑. ");
INSERT INTO moa_vpl VALUES ("LK10_5","072_10_5","LUK","10","5","5","'Ke 'ka ꞊wlaa 'fɛ 'oo 'fɛ 'la ꞊la, ‑kaa pe 'bhɛ ꞊la mu 'ɛ ni dɔɔ: ‹Bhaa ‑Waanbhaa' 'ka bɔ 'edɔɔle!› ");
INSERT INTO moa_vpl VALUES ("LK10_6","072_10_6","LUK","10","6","6","'Ke yilabla sɔ 'bhɛ 'fɛ 'ɛ ꞊la mi 'ɛ do ni, 'bhɛ zan 'ɛ nu 'kaa‑ 'duma 'ɛ 'srɔɔwolɛ. 'Duŋ‑ 'ke yilabla 'laa sɔ 'bhɛ 'fɛ 'ɛ ꞊la mu 'ɛ ni, 'ka 'laa 'bhɛ ꞊la mu 'ɛ 'dumawolɛ. ");
INSERT INTO moa_vpl VALUES ("LK10_7","072_10_7","LUK","10","7","7","'Ke 'ka ꞊wlaa 'fɛ ꞊lwa 'la ꞊la, ‑ka bo 'bhɛɛ‑ ꞊la, 'ke ‑o 'ka ‑gbaa pɛle 'pegee ‑yi 'la ba, ‑kaa bhle 'bhɛ 'pegee ‑kaa mi. ‑Amasrɔyi, yewonɛ 'ɛ 'sra‑ ‑o 'kɛla 'le ‑o 'bhɛɛ‑ na ‑a ni. 'Ka 'laa bolɛ 'kaanle‑ ma 'fɛ mu ꞊la do do ");
INSERT INTO moa_vpl VALUES ("LK10_8","072_10_8","LUK","10","8","8","'Ke 'ka ‑ja ‑wa 'oo ‑wa 'la ta, 'bhɛɛ‑ 'ke ‑o 'ka 'cieya‑ ꞊kla 'elrele 'bhɛ ꞊nɔɔ, 'bhɛ 'pegee 'ke ‑o pɛ 'oo pɛ 'la ꞊naa 'ka ni, ‑ka 'bhɛ 'bhle. ");
INSERT INTO moa_vpl VALUES ("LK10_9","072_10_9","LUK","10","9","9","‑Ka 'bhɛ ‑wa 'ɛ ta gadɛ mu 'ɛ 'bhee‑, 'bhɛɛ‑ ‑kaa pe ‑o ni dɔɔ: ‹‑Waanbhaa' a ‑bhleŋgbeya yi 'ɛ ꞊bhwa 'ka ‑din.› ");
INSERT INTO moa_vpl VALUES ("LK10_10","072_10_10","LUK","10","10","10","'Duŋ‑ 'ke 'ka ‑ja ‑wa 'la ta, 'bhɛɛ‑ 'ke 'bhɛ ꞊nɔɔ mu 'ɛ waa 'ka 'cieya‑ klɛlɛ, ‑ka go 'bhɛ ‑wa 'ɛ ta. ");
INSERT INTO moa_vpl VALUES ("LK10_11","072_10_11","LUK","10","11","11","'Ka go bhla zi 'bhɛ ‑wa 'ɛ ta, ‑kaa pe dɔɔ: ‹'O 'kaa‑ ‑wa 'kpee bwegblɛn‑ 'ɛ 'wlɛn zii' 'ka 'gbu 'kaama‑ 'o gaan mu 'ɛ 'le. 'Duŋ‑ ‑kaa 'yaango‑ dɔɔ 'bhii‑ ‑Waanbhaa' a ‑bhleŋgbeya yi 'ɛ ꞊bhwa 'ka ‑din.› ");
INSERT INTO moa_vpl VALUES ("LK10_12","072_10_12","LUK","10","12","12","‑Ayile 'mi pe 'ka ni 'ŋ 'sɔwɛɛ‑ ma dɔɔ ‑Waanbhaa' a 'kitikan yi ‑gbɛnɛ 'ɛ 'le, waa nu 'sɔlɛ‑ 'yee‑ ‑wa 'ɛ ta mu 'ɛ ‑o ta ‑yrɛn 'ɛ 'kpale Sodɔmu a pɛ ta ‑yrɛn 'ɛ 'bhɛ ma.» ");
INSERT INTO moa_vpl VALUES ("LK10_13","072_10_13","LUK","10","13","13","Zesu pe ‑o ni 'ezin‑ dɔɔ: «'Ka ta ‑yrɛn! 'Ka mu Korazɛn mu! 'Ka ta ‑yrɛn! 'Ka mu Bɛtisaida mu! 'Ŋ 'sɔle‑ maza mu 'la ꞊kla 'ka ba, 'kee‑ 'kpa bi 'ŋ 'bhɛ yɛkɛ‑ 'sɔle‑ maza mu klɛ Tiri 'pegee Sidɔn ‑wa mu 'ɛ ta, ‑zɔn 'laa 'bhɛ 'le 'ke ‑zadɔwɛɛ ꞊bwa gban ‑o ma ‑waa' ‑za 'yɔɔ‑ mu 'ɛ ‑zayi', 'bhɛɛ‑ 'ke ‑o ‑ploola gban 'bhɛ mu klɛle ma. ‑O ‑yaa nu 'bhɛ zrɔnlɛ ‑bɔtɔ kplɛ 'pegee ‑yie 'klalele ‑o ta. ");
INSERT INTO moa_vpl VALUES ("LK10_14","072_10_14","LUK","10","14","14","'Bhɛla‑ ‑yile, ‑Waanbhaa' a 'kitikan yi ‑gbɛnɛ 'ɛ 'le, Tiri ‑wa 'ɛ 'pegee Sidɔn ‑wa 'ɛ ta mu 'ɛ ‑o ta ‑yrɛn 'ɛ yaa nu ‑lalɛ' 'bhii‑ 'ka mu a pɛ 'ɛ gbɛɛn‑. ");
INSERT INTO moa_vpl VALUES ("LK10_15","072_10_15","LUK","10","15","15","'Bhɛɛ‑ 'ka mu Kapɛnɔmu ‑wa 'ɛ ta mu, 'ka 'kpee ma 'ka nu ‑wlɛnlɛ', 'bhɛɛ‑ 'ka tɛn laflɛ' ma ɛɛ? ‑Waanbhaa' nu 'ka mazinalɛ, 'bhɛɛ‑ ‑e ge 'ka 'le ‑jranama 'tɛ 'ɛ 'yi.» ");
INSERT INTO moa_vpl VALUES ("LK10_16","072_10_16","LUK","10","16","16","'Bhɛ blaan, 'ke Zesu 'a 'pele ‑yaa' ‑klaŋlanɛ mu 'ɛ ni dɔɔ: «'Ke mɛɛ 'la zan 'e 'trɔnkpaa‑ 'ka 'wojan‑ ‑la, 'bhɛ zan ‑o 'bhɛ 'trɔnkpa zii' 'mi ‑la wojan 'ɛ 'la bhe 'ezin‑. 'Ke mɛɛ 'la zan 'bhɛ ‑baŋgwa 'ka 'yi, 'bhɛ zan 'bhɛ ‑baŋgwa 'mi ‑la ‑yi bhe. 'Bhɛɛ‑ 'ke mɛɛ 'la zan 'bhɛ ‑baŋgwa 'mi 'yi, 'bhɛ zan 'ɛ 'bhɛ ‑baŋgwa mɛɛ 'la zan 'mi 'winbwa‑ 'bhɛɛ‑ 'yi 'ezin‑.» ");
INSERT INTO moa_vpl VALUES ("LK10_17","072_10_17","LUK","10","17","17","Zesu a ‑klaŋlanɛ mia yaga bhɛ vu 'ɛ ‑o ‑ja, 'bhɛɛ‑ ‑o ꞊nwa. ‑O zrukpaa' gbɛ ‑yɔɔ' 'ɛ 'kɔɔ 'ke ‑wa pele‑ Zesu ni dɔɔ: «'O Daan mi, ‑glɔɔya' 'la ‑yoo 'e 'tɔ 'ɛ 'yi 'bhɛ ‑zayi', 'o 'kpaale‑ ‑o 'zina mu 'ɛ 'wiiŋ‑; 'bhɛɛ‑ 'ke 'wa ꞊pia ‑o ni ‑o 'kɛla 'bhɛ klɛ ‑o 'bhɛɛ‑ klɛ.» ");
INSERT INTO moa_vpl VALUES ("LK10_18","072_10_18","LUK","10","18","18","'Bhɛ klɛle 'tɛ, 'ke Zesu 'a 'pele ‑a ni dɔɔ: «'Ŋ 'yrɛ 'yaa‑ ‑Setran' baale ma 'kee‑ da laflɛ' 'yi blaale‑ 'bhii‑ la ‑yrɛbɔgbɛya 'ɛ gbɛɛn‑. ");
INSERT INTO moa_vpl VALUES ("LK10_19","072_10_19","LUK","10","19","19","‑Ka 'ka 'trɔnkpa doo: 'ŋ 'bhɛ 'seŋ ꞊naa 'ka ni 'ke 'ka sɔ 'taawole mlɛ mu 'pegee ‑zaanweele mu ta, 'bhɛɛ‑ 'ke 'ka sɔ 'kpaale ‑kɔɔ' 'sɔɔnnii 'ɛ yaa ‑glɔɔya' 'ɛ 'wiiŋ‑. Pɛ 'kedo‑ 'kpɔ 'laa nu 'sɔlɛ‑ ‑za 'yɔɔ‑ do 'kpɔ klɛle‑ 'ka ni. ");
INSERT INTO moa_vpl VALUES ("LK10_20","072_10_20","LUK","10","20","20","'Duŋ‑, 'ka 'laa 'ka zrukpaalɛ 'ka 'kpaale‑ 'la ‑yoo 'zina mu wiiŋ‑ 'bhɛ ‑zayi'. 'Duŋ‑ 'ka zrukpaale klɛ ‑Waanbhaa' 'ka 'tɔ mu 'ɛ yɔɔn 'la ꞊dia gban laanima 'bhɛɛ‑ ‑zayi'.» ");
INSERT INTO moa_vpl VALUES ("LK10_21","072_10_21","LUK","10","21","21","'Bhɛ 'waati do 'kpɔ 'ɛ ba, 'ke *Lii 'Weŋ 'ɛ zrukpaa' ‑gbɛnɛ do zinale Zesu ta, 'bhɛɛ‑ 'ke ‑ya pele‑ dɔɔ: «'Ŋ Dɛ 'trɛ 'pegee laflɛ' Zan, 'mi 'e 'pubɔ, ‑amasrɔyi 'e ‑za 'la ‑gaanna ‑zadɔ' mu 'pegee 'sɛwɛdɔ mu ‑lɛɛ, 'e 'bhɛɛ‑ ‑zrɔnna ‑nɛ mu 'ɛ ni. ‑E ‑swa 'e ni 'ke 'ya klɛ 'bhɛ gbɛɛn‑, ‑ayile 'mi 'e 'tɔbhɔ‑ 'egbɛnɛle. ");
INSERT INTO moa_vpl VALUES ("LK10_22","072_10_22","LUK","10","22","22","«'Ŋ Dɛ ‑za 'kpɛn gbɛkpaa‑ 'mi 'kɔɔ. Mɛɛ 'kedo‑ 'kpɔ 'laa 'mi dɔ 'ke yaa 'e go 'yee‑ do ‑kplɛn ba. 'Bhɛɛ‑ mɛɛ 'kedo‑ 'kpɔ 'laa 'mi Dɛ 'ɛ dɔ 'ke yaa 'e go 'mi ‑a Gbe do ‑kplɛn, 'pegee mɛɛ 'la zan ‑a Gbe ‑a zi 'bhii‑ 'bhɛ zan 'a dɔ 'bhɛ ba.» ");
INSERT INTO moa_vpl VALUES ("LK10_23","072_10_23","LUK","10","23","23","'Bhɛ blaan, 'ke ‑ya l‑ɛklale ‑yaa' ‑klaŋlanɛ mu 'ɛ ta, 'bhɛɛ‑ 'ke ‑ya pele‑ 'mu ni dɔɔ: «'Ka mu 'la 'ka 'yrɛ ‑o ‑za 'lɛɛ‑ ma ‑gɛ ‑zɔn bhe, 'kaa‑ pɛ ‑yinra'. ");
INSERT INTO moa_vpl VALUES ("LK10_24","072_10_24","LUK","10","24","24","‑Amasrɔyi, ‑za 'la 'kpɛn ‑o klɛ 'zi 'ka yrɛ ma ‑gɛ ‑zɔn bhe, 'elwaleta ‑Waanbhaa' *‑lɛla' janwo mu ‑bebe 'pegee ‑bhleŋgbe ‑bebe 'ke mu ‑yaa zi 'bhii‑ 'yee‑ ‑za 'lɛɛ‑ klɛ ‑o ‑yrɛ ma, 'bhɛɛ‑ yaa klɛlɛ ‑o ‑yrɛ ma. ‑O ‑yaa zi 'bhii‑ ‑wa ma, 'bhɛɛ‑ waa malɛ.» ");
INSERT INTO moa_vpl VALUES ("LK10_25","072_10_25","LUK","10","25","25","'Bhɛ 'yi 'tɛ, 'ke 'Toŋ daan mu 'ɛ do nule‑ Zesu 'lrɔkpalɛ, ‑e ‑yaa zi 'bhii‑ ‑ya ‑yidan'. 'Bhɛla‑ ‑yile 'bhɛ 'Toŋ daan mi 'ɛ pe ‑a ni dɔɔ: «'An klɛ 'gbu 'nale‑ ‑a ma 'bhɛɛ‑ 'ŋ sɔ ‑Waanbhaa' ba bole ‑yrɛ ma ‑si 'la ‑daŋ 'laa ‑o 'bhɛ ma 'bhɛ 'srɔɔwole ɛɛ?» ");
INSERT INTO moa_vpl VALUES ("LK10_26","072_10_26","LUK","10","26","26","'Bhɛ klɛle 'tɛ, 'ke Zesu 'a 'pele 'a ni dɔɔ: «‑O ‑mɛ pɛ za ‑la yɔɔndia‑ ‑ Moizi a 'toŋ 'sɛwɛ 'ɛ 'yi ɛɛ? 'Bhɛɛ‑ 'ya 'yima‑ 'nale‑ ɛɛ?» ");
INSERT INTO moa_vpl VALUES ("LK10_27","072_10_27","LUK","10","27","27","'Yee‑ mɛɛ 'ɛ ‑e pe Zesu ni dɔɔ: «'Toŋ 'ɛ ta, ‑a yɔɔndɛle ‑o dɔɔ Mɛɛzan ‑Waanbhaa' 'sɔ 'e ni 'e zru oo, 'e 'nii‑ oo, 'e faŋgan‑ oo 'bhɛ 'pegee 'e 'kpeejan‑ 'ɛ 'kpɛn 'le. 'Bhɛɛ‑ 'e ‑vindo' mi 'sɔ 'e ni 'bhii‑ 'e ‑za sɔ 'e 'gbu ni gɔnɛ‑ 'la gbɛɛn‑.» ");
INSERT INTO moa_vpl VALUES ("LK10_28","072_10_28","LUK","10","28","28","'Bhɛ klɛle 'tɛ, 'ke Zesu 'a 'pele ‑a ni dɔɔ: «'Ye 'an ‑jan 'ɛ 'lɛkwan‑ 'elrele, 'bhi ge 'bhɛ 'yansi za klɛ, 'bhɛɛ‑ 'e nu bole ‑yrɛ ‑si 'la ‑daŋ' 'laa ‑o 'bhɛ ma 'bhɛ 'srɔɔwolɛ.» ");
INSERT INTO moa_vpl VALUES ("LK10_29","072_10_29","LUK","10","29","29","'Duŋ‑ 'yee‑ 'Toŋ daan mi 'ɛ 'yaa‑ zi 'bhii‑ ‑e 'zoo 'na ‑a 'gbu ni, ‑ayile 'kee‑ Zesu 'lrɔkpale dɔɔ: «‑De 'gbu ‑le 'ŋ ‑vindo' mi 'le ɛɛ?» ");
INSERT INTO moa_vpl VALUES ("LK10_30","072_10_30","LUK","10","30","30","'Bhɛ 'yi 'tɛ, 'ke Zesu ‑gɔɔn do bɔle‑ dɔɔ: «‑Yrekpaa' do, mɛɛ do ‑daa Zeruzalɛmu, 'bhɛɛ‑ ‑e ‑yaa ge 'zi Zeriko. ‑E bhɔle yrɛ do ꞊nɔɔ 'ke ‑faannii' mu baale' ‑a ta, 'bhɛɛ‑ 'ke ‑wa 'kɔɔpɛ‑ mu 'ɛ 'kpɛn 'sile, 'bhɛɛ‑ 'ke ‑wa tafɛle; 'bhɛ 'pegee 'ke ‑wa madiŋwole, 'bhɛɛ‑ 'ke ‑wa ‑zrɔle' baale 'tole zi 'ɛ 'lii, 'bhɛɛ‑ 'ke ‑o jilale. ");
INSERT INTO moa_vpl VALUES ("LK10_31","072_10_31","LUK","10","31","31","'Bhɛ ya 'ɛ 'yi bhe, 'sraka 'lɛna mi do 'kanle‑ ‑bɛŋgwa 'yee‑ zi do 'kpɔ 'ɛ 'lii 'bhɛ 'waati 'ɛ ba. ‑E bhɔle 'yee‑ mɛɛ 'ɛ baale ta, 'ke ‑ya taglinle frii, 'bhɛɛ‑ 'kee‑ 'kanle 'a ‑gɔma, 'bhɛɛ‑ 'kee‑ jilale. ");
INSERT INTO moa_vpl VALUES ("LK10_32","072_10_32","LUK","10","32","32","'Bhɛ blaan, 'ke Levi 'srɛ mu 'ɛ do 'kanle‑ ‑bɛŋgole 'yee‑ zi do 'kpɔ 'ɛ 'lii. 'Bhɛ 'bhɔle‑ 'yee‑ mɛɛ 'ɛ ta, 'ke ‑ya taglinle 'ezin‑ frii, 'bhɛɛ‑ 'ke 'bhɛ 'kanle 'ezin‑ ‑a ‑gɔma'. ");
INSERT INTO moa_vpl VALUES ("LK10_33","072_10_33","LUK","10","33","33","'Bhɛɛ‑ boolazi, Samari mɛɛ do ‑yaa ge 'zi 'taa ta 'yee‑ zi do 'kpɔ 'ɛ zi 'ezin‑. ‑E bhɔle 'yee‑ mɛɛ 'ɛ ‑din, 'bhɛɛ‑ ‑a ‑yrɛkpale a ma, 'ke ‑a ‑yrɛn ‑gbɛnɛ 'klale ‑a ma. ");
INSERT INTO moa_vpl VALUES ("LK10_34","072_10_34","LUK","10","34","34","‑Ayile, 'ke ‑ya mabɛɛnle 'a ‑din, 'bhɛɛ‑ 'ke ‑ya ma bhɛ mu 'ɛ 'tɛkpale ‑yrɔn 'pegee ‑laanɛ' 'yi 'le, 'bhɛɛ‑ 'kee‑ sɔgbɛ ‑yrele' 'mu bhɛ mu 'ɛ ta. 'Bhɛ blaan, 'kee‑ 'yee‑ mɛɛ 'ɛ 'sanle ‑yaa' ‑soofali 'ɛ ta, 'kee‑ gele‑ 'kɛle‑ 'cie mu yi 'fɛ do ‑la. ‑E bhɔle 'bhɛ ꞊nɔɔ ye, 'kee‑ 'yee‑ mɛɛ 'ɛ 'laanɛkpale 'elrele, 'bhɛɛ‑ 'ke ‑ya ‑yrɛkpale 'bhɛ ba. ");
INSERT INTO moa_vpl VALUES ("LK10_35","072_10_35","LUK","10","35","35","'Bhɛ ta tooklin‑ yi 'le, ‑e denie ‑gɔli' 'taŋbha plɛ ꞊sia ‑a ba 'yi, 'bhɛɛ‑ ‑yoo ‑naa 'cie mu yi 'fɛzan‑ 'ɛ ni, 'bhɛɛ‑ ‑e pe 'bhɛ ni dɔɔ: ‹'E 'yrɛkpa mɛɛ 'lɛɛ‑ ba 'elrele, 'ke 'ŋ ‑daa 'an 'taa 'ɛ ta yi 'la 'le, 'e ‑gɔli' yɛkɛ‑ 'la 'siɛla‑ 'ke 'bhɛ kan 'kɛlɛɛ‑ ta, 'ŋ nu 'bhɛ 'kpɛn gbawolɛ 'e ni.›» ");
INSERT INTO moa_vpl VALUES ("LK10_36","072_10_36","LUK","10","36","36","'Bhɛ blaan, 'ke Zesu 'yee‑ 'Toŋ daan mi 'ɛ 'lrɔkpale dɔɔ: «'Bhi 'kpee ma, 'woo‑ mɛɛ yaga 'la bhe, ‑o ‑de 'gbu ‑le ꞊kla ‑faannii' mu ‑balaa' mɛɛ 'la zan ta 'bhɛ ‑vindo' mi 'le ɛɛ?» ");
INSERT INTO moa_vpl VALUES ("LK10_37","072_10_37","LUK","10","37","37","'Yee‑ 'Toŋ daan mi 'ɛ pe dɔɔ: «‑A ‑yrɛnklaa mɛɛ 'la zan ma, 'bhɛ ‑le ꞊kla ‑a ‑bhoo 'ɛ 'le.» 'Bhɛ klɛle 'tɛ, 'ke Zesu 'a pele ‑a ni dɔɔ: «'Bhi ge 'bhɛ 'yansi za klɛ.» ");
INSERT INTO moa_vpl VALUES ("LK10_38","072_10_38","LUK","10","38","38","Zesu 'pegee ‑yaa' ‑klaŋlanɛ mu 'ɛ 'yaa‑ ge 'zi Zeruzalɛmu 'taa 'ɛ ta 'waati 'la ba, 'ke ‑o bhɔle‑ ‑wa do ta, 'bhɛɛ‑ 'ke ‑o gele‑ ‑o zɛnlɛ ‑o ‑yaa le 'la 'bhɛ sii Maati 'bhɛ ba. ");
INSERT INTO moa_vpl VALUES ("LK10_39","072_10_39","LUK","10","39","39","Maati 'nwale‑ do ‑yaa, ‑o ‑yaa 'bhɛ sii Mari. Mɛɛzan Zesu 'yaa‑ ‑Jan 'Nrale‑ 'ɛ 'wo zii' 'waati 'la ba, 'ke 'yee‑ Mari gele‑ yaalɛ 'bhɛ gaan ma, 'bhɛɛ‑ 'ke ‑ya 'trɔnkpa‑ 'bhɛ 'wojan‑ 'ɛ ꞊la. ");
INSERT INTO moa_vpl VALUES ("LK10_40","072_10_40","LUK","10","40","40","'Bhɛ 'waati 'ɛ ba, ‑a ‑doole' Maati yrɛ ba 'tɛ 'yaa‑ kpo klɛle ma, 'bhɛ 'pegee 'fɛ 'ɛ ꞊la ye ‑glɔɔn 'ɛ 'kpɛn 'wole‑ ma. ‑Ayile 'kee‑ nule‑ ‑a pelɛ Zesu ni dɔɔ: «'Ŋ Zan, 'ŋ 'nwale‑ 'ɛ ‑yoo 'ŋ do ‑kplɛn 'tolawoa ye 'ɛ 'wole‑ ma, 'bhɛ 'laa la 'ɛ ma ɛɛ? ‑A pe ‑a ni 'kaa ‑e nu bhɔ 'ŋ ba kpo klɛle 'ɛ 'le.» ");
INSERT INTO moa_vpl VALUES ("LK10_41","072_10_41","LUK","10","41","41","Zesu pe ‑a ni dɔɔ: «'E Maati, 'E Maati! 'E 'yrɛbatɛdɔle ‑o, 'bhɛɛ‑ 'e wlayrɛ 'ɛ 'pale‑ ‑o ‑za ‑bebe ‑zayi'. ");
INSERT INTO moa_vpl VALUES ("LK10_42","072_10_42","LUK","10","42","42","‑Nafan ‑o ‑za do 'kpɔ ‑la ma, 'ke 'bhɛ kan pɛ 'kpɛn ta, Mari 'bhɛɛ‑ makwan‑, 'bhɛɛ‑ mɛɛ 'kedo‑ 'kpɔ 'laa nu 'sɔlɛ 'bhɛ 'kunle ‑a 'kɔɔ.» ");
INSERT INTO moa_vpl VALUES ("LK11_1","072_11_1","LUK","11","1","1","‑Yrekpaa' do, Zesu 'yaa‑ 'seriwo zii' yrɛ do ꞊nɔɔ. ‑E yanle ‑a 'seriwolele, 'ke ‑yaa' ‑klaŋlanɛ mu 'ɛ do 'a 'pele ‑a ni dɔɔ: «Mɛɛzan, 'o daan 'o 'seriwolele, 'bhii‑ Mɛɛ Wiiŋfɛ' Mi Zaan bhɛ a ‑klaŋlanɛ mu 'ɛ ‑daanna 'mu 'seriwolele gɔnɛ‑ 'la gbɛɛn‑.» ");
INSERT INTO moa_vpl VALUES ("LK11_2","072_11_2","LUK","11","2","2","‑Ayile, 'ke Zesu 'a 'pele ‑o ni dɔɔ: «'Ke 'ka ‑o 'ka 'seriwole ‑kaa pe dɔɔ: ‹'O Dɛ ‑Waanbhaa', bhaa mɔkpɛn' 'a dɔ 'bhii‑ 'yoo‑ 'weŋ! Bhaa 'yaa‑ ‑bhleŋgbeya yaa‑ yi 'ɛ 'bhɔ. ");
INSERT INTO moa_vpl VALUES ("LK11_3","072_11_3","LUK","11","3","3","'O gba yi oo yi, 'o maza ‑o pɛbhle 'la ma 'bhɛ ba! ");
INSERT INTO moa_vpl VALUES ("LK11_4","072_11_4","LUK","11","4","4","'Waa‑ ‑za 'yɔɔ mu 'ɛ ‑sroma 'yan, 'bhii‑ mɛɛ 'la zan mu ‑za 'yɔɔ mu ꞊kla 'o ni 'o 'bhɛ zan mu a ‑sroma yan gɔnɛ‑ 'la gbɛɛn‑. 'Yaa 'tolɛ‑ 'ke ‑Setran' 'o 'lɛkan‑, 'bhɛɛ‑ ‑yoo' balaa' ‑za 'yɔɔ‑ 'yi.›» ");
INSERT INTO moa_vpl VALUES ("LK11_5","072_11_5","LUK","11","5","5","Zesu pe ‑yaa' ‑klaŋlanɛ mu 'ɛ ni 'ezin‑ dɔɔ: «'Ke 'ka do 'bhɛ 'wlɛnna‑ blaŋdrɛyi, 'bhɛɛ‑ ‑e ‑ja 'tɛnlɛ‑ ‑a bhɛgwlɛn do ma, 'bhɛɛ‑ ‑e kɔkɔdia 'bhɛ ta, 'ke ‑ya pe 'bhɛ ni dɔɔ: ‹'Ŋ 'bhɛgwlɛn‑, 'e 'wlɛn‑, 'bhɛɛ‑ 'ye 'ŋ gba 'bluu 'yri yaga ba. ");
INSERT INTO moa_vpl VALUES ("LK11_6","072_11_6","LUK","11","6","6","‑Amasrɔyi 'ŋ 'bhɛgwlɛn‑ do ‑daa 'taa ta ‑bi 'lɛɛ‑ zi, 'bhɛɛ‑ ‑e ꞊nwa 'ŋ ba. Pɛle kplankplan laa ‑o 'ŋ 'kɔɔ 'ke 'an 'lɛwɛɛ kpo klɛ.› ");
INSERT INTO moa_vpl VALUES ("LK11_7","072_11_7","LUK","11","7","7","'Bhɛɛ‑ 'bhɛ 'yi bhe 'tɛ, ‑a bhɛgwlɛn 'la 'yilale ‑o 'fɛ 'ɛ ꞊la, 'bhɛ 'a 'lɛkun ‑a ni dɔɔ: ‹'Ŋ 'to 'srɔ! 'Mi 'pegee 'ŋ 'nɛ mu 'ɛ 'o 'yilaa‑ gban, ‑ayile 'o 'fɛ 'liikoŋ bhɛ 'ɛ ꞊bwa gban. 'Naa sɔ ‑li 'ŋ 'wlɛnle, 'bhɛɛ‑ 'ŋ ge 'bluu 'nalɛ‑ 'e ni.› ");
INSERT INTO moa_vpl VALUES ("LK11_8","072_11_8","LUK","11","8","8","'Mi pe 'ka ni 'ŋ 'sɔwɛɛ‑ ma dɔɔ: 'Ali‑ 'ke yaa ‑wlɛnlɛ', 'bhɛɛ‑ ‑e 'bluu 'ɛ na ‑a bhɛgwlɛn 'ɛ ni ‑waa' bhɛgwlɛnya 'ɛ ma; 'ke 'bhɛ ꞊bwa ‑a matɛdɔ yrɛ nɔɔ‑, ‑e nu ‑a ‑wlɛnlɛ', 'bhɛɛ‑ ‑e 'bluu 'ɛ na 'bhɛ ni. ");
INSERT INTO moa_vpl VALUES ("LK11_9","072_11_9","LUK","11","9","9","'Bhɛla‑ ‑yile 'mi pe 'ka ni dɔɔ 'ke 'ka pɛ 'oo pɛ 'la 'yrɛwoa‑ ‑Waanbhaa' ma, ‑e nu 'bhɛ pɛ 'ɛ 'nalɛ‑ 'ka ni. 'Ke 'ka pɛ 'oo pɛ 'la 'bhɛ ‑glinna ‑Waanbhaa' ba, 'ka nu 'bhɛɛ‑ 'srɔɔwolɛ. ‑Ka kɔkɔdɛ 'fɛ 'liikoŋ 'ɛ ta, 'bhɛɛ‑ ‑Waanbhaa' nu ‑a ‑liigolɛ 'ka ni. ");
INSERT INTO moa_vpl VALUES ("LK11_10","072_11_10","LUK","11","10","10","‑Amasrɔyi, 'ke mɛɛ 'oo mɛɛ 'la zan maza ‑o pɛ 'la ma, 'kee‑ 'bhɛ 'yrɛwoa‑ ‑Waanbhaa' ma, 'bhɛ zan nu 'bhɛ pɛ 'ɛ 'srɔɔwolɛ. 'Bhɛɛ‑ 'ke mɛɛ 'oo mɛɛ 'la zan maza ‑o pɛ 'la ma 'kee‑ 'bhɛ pɛ 'ɛ ziglinna ‑Waanbhaa' ba, 'bhɛ zan nu 'bhɛ pɛ 'ɛ 'srɔɔwolɛ; 'ke mɛɛ 'oo mɛɛ 'la zan kɔkɔdia, ‑o nu 'fɛ 'ɛ 'liigolɛ 'bhɛ zan ni. ");
INSERT INTO moa_vpl VALUES ("LK11_11","072_11_11","LUK","11","11","11","'Ka ‑de 'gbu ‑le sɔ mlɛ 'kpale 'bhɛ 'nɛ 'ɛ 'kɔɔ, 'ke 'bhɛ kaa ‑yrɛwoa ‑a ma ɛɛ? ");
INSERT INTO moa_vpl VALUES ("LK11_12","072_11_12","LUK","11","12","12","‑Taa 'ka ‑de 'gbu ‑le sɔ ‑zaanweele do 'kpale 'bhɛ 'nɛ 'ɛ 'kɔɔ 'ke 'bhɛ maa yrɛn ‑yrɛwoa ‑a ɛɛ? ");
INSERT INTO moa_vpl VALUES ("LK11_13","072_11_13","LUK","11","13","13","'Ka mu bhaaplɛŋ 'kpee 'yɔɔ‑ mu, 'ke 'ka mu sɔ pɛ ‑lrele' mu nale‑ 'ka 'nɛ mu ni, ‑mɛla ma 'bhɛɛ‑ 'ka Dɛ ‑Waanbhaa' 'la ‑yoo laanima 'bhɛ 'laa nu 'sɔlɛ‑ Lii 'Weŋ 'ɛ 'nale 'ke mɛɛ 'la zan mu 'bhɛ 'yrɛwoa‑ ‑a ma 'mu ni ɛɛ?» ");
INSERT INTO moa_vpl VALUES ("LK11_14","072_11_14","LUK","11","14","14","Yi do ta, Zesu 'yaa‑ 'zina ‑gbin 'zi mɛɛ do zi. 'Bhobho 'zina ‑le ‑yaa 'bhɛ mɛɛ 'ɛ zi. Zesu 'yanle‑ 'yee‑ 'zina 'ɛ ‑gbinlele, 'ke 'yee‑ mɛɛ 'ɛ ‑janwole 'sanle. 'Bhɛ klɛle 'tɛ, 'ke 'bhɛ yrɛ 'ɛ ꞊nɔɔ mu 'ɛ 'kpɛn 'liibhaale 'mu 'gbu ma. ");
INSERT INTO moa_vpl VALUES ("LK11_15","072_11_15","LUK","11","15","15","'Duŋ‑ ‑zamaa' 'ɛ 'pleŋ‑ mɛɛ 'ke mu ‑yaa pe 'zi dɔɔ ‑o ‑yaa 'zina mu a ‑kuŋlii 'la sii Bɛɛzebuli 'bhɛ ‑le ‑yaa 'zina mu ‑gbin 'seŋ 'na zii' 'yee‑ Zesu ni. ");
INSERT INTO moa_vpl VALUES ("LK11_16","072_11_16","LUK","11","16","16","‑O 'ke mu ‑yaa bɔyrɛ ‑glin 'zi ‑a ‑la 'ke mu 'a 'pele ‑a ni dɔɔ 'kee‑ da ‑Waanbhaa' ba, ‑e 'bhɛ ma ‑tɔɔmasie do klɛ ‑o ‑yrɛ ma doo. ");
INSERT INTO moa_vpl VALUES ("LK11_17","072_11_17","LUK","11","17","17","'Duŋ‑ Zesu 'yaa‑ ‑o 'kpeejan‑ mu 'la dɔ bhe, 'ke 'bhɛ 'a 'pele ‑o ni dɔɔ: «'Ke ‑bhleŋgbe do a 'klɛɛn ‑yi mu gwledan 'eke‑ ba, 'bhɛ 'klɛɛn 'ɛ 'lɛyanyrɛ ‑le 'ke ‑a 'siɛle‑ ‑la ‑le, 'bhɛɛ‑ ‑a nɔɔ‑ ‑wa mu 'ɛ ta 'fɛ mu 'ɛ ‑o ‑klalaa'. ");
INSERT INTO moa_vpl VALUES ("LK11_18","072_11_18","LUK","11","18","18","'Bhɛ ya 'ɛ 'yi, 'ke ‑Setran' gwledan 'zi ‑a 'gbu ba, ‑yaa' 'klɛɛn nu ‑mɔlɛ' 'nale‑ ‑a ma ɛɛ? 'Ka mu ‑a pe 'zi dɔɔ 'mi ‑o 'zina mu 'ɛ ‑gbin 'zi *Bɛɛzebuli ‑la 'seŋ ta. ");
INSERT INTO moa_vpl VALUES ("LK11_19","072_11_19","LUK","11","19","19","'Duŋ‑ 'ke 'bhɛ ‑o 'ke wlan 'le, ‑dele 'zina mu ‑gbin 'seŋ 'na zii' 'ka a pɛ mɛɛ mu 'ɛ ni ɛɛ? 'Ka 'gbu a pɛ mɛɛ mu 'ɛ 'mu ‑le sɔ 'yee‑ ‑jan 'lɛɛ‑ ŋgblo 'kanle. ");
INSERT INTO moa_vpl VALUES ("LK11_20","072_11_20","LUK","11","20","20","'Duŋ‑ 'ŋ 'sɔwɛɛ‑ 'gbu 'ɛ ma, 'ke 'ŋ 'yoo‑ 'woo‑ 'zina mu 'ɛ ‑gbin 'zi ‑Waanbhaa' a pɛ 'seŋ ‑la ta, 'mi sɔ a pele‑ dɔɔ ‑Waanbhaa' a ‑bhleŋgbeya yi 'ɛ ꞊bhwa 'ka ‑din gban.» ");
INSERT INTO moa_vpl VALUES ("LK11_21","072_11_21","LUK","11","21","21","«'Ka 'gbu 'a 'yaango‑ 'bhii‑ 'ke gwledanpɛ ‑lrele' ‑o ‑faŋgan ma mɛɛ do 'kɔɔ, ‑za 'yɔɔ‑ laa sɔ 'tɛnle ‑yaa' 'fɛ 'pegee ‑a 'kɔɔpɛ‑ mu 'ɛ ma, ‑amasrɔyi ‑ya ‑yrɛkpa' ‑o ba 'elrele. ");
INSERT INTO moa_vpl VALUES ("LK11_22","072_11_22","LUK","11","22","22","'Duŋ‑ 'ke mɛɛ ‑bhɛɛke' do ꞊nwa 'bhɛɛ‑ 'ke 'bhɛ faŋgan‑ 'yiya‑ 'yee‑ faŋgan‑ ma mɛɛ ‑lwa mi 'ɛ ni; 'bhɛɛ‑ 'bhɛ ‑balaa' ‑a ta. ‑A 'kpale‑ ‑yaa ‑a 'kɔɔ gwledanpɛ mu 'la 'yi, 'kee‑ 'mu 'kpɛn ꞊sia 'a 'kɔɔ. 'Bhɛ blaan, ‑ya 'kɔɔpɛ‑ mu 'ɛ 'kpɛn 'la ꞊sia ‑e 'mu 'yiciɛn‑ mɛɛ ‑bhɛɛke' mu ma.» ");
INSERT INTO moa_vpl VALUES ("LK11_23","072_11_23","LUK","11","23","23","Zesu pe ‑yaa' ‑jan 'ɛ 'lɛyanyrɛ 'ɛ ꞊nɔɔ dɔɔ: «'Ke mɛɛ 'la zan laa ‑o 'ŋ zi, 'bhɛ zan ‑o 'ŋ ma. 'Bhɛɛ‑ 'ke mɛɛ 'la zan laa ‑o bhɔ 'zi 'ŋ ba mɛɛ mu ‑lɛkpalele 'eke‑ ta, 'bhɛ zan ‑o piila‑ mi ‑la ‑le 'eke‑ ma.» ");
INSERT INTO moa_vpl VALUES ("LK11_24","072_11_24","LUK","11","24","24","Zesu pe 'ezin‑ dɔɔ: «'Ke 'zina 'ɛ ‑gwa mɛɛ do zi, ‑e ge 'kaanlɛ‑ ‑bɔn 'yi yrɛ mu 'ɛ ꞊nɔɔ 'ke ‑ya ‑yitrɛ' yrɛ glin. 'Ke yaa ‑yitrɛ' yrɛ yelɛ, ‑ya pe dɔɔ: ‹'Ŋ gele‑ 'ŋ ‑zanta' 'ŋ boyrɛ gwe 'ɛ ꞊nɔɔ›. 'Zina 'ɛ 'niinaa, 'bhɛɛ‑ ‑e dɔ gbɛ drɛɛwo 'yee‑ mɛɛ 'ɛ zi. ");
INSERT INTO moa_vpl VALUES ("LK11_25","072_11_25","LUK","11","25","25","'Ke 'yee‑ 'zina 'ɛ ꞊nwa, ‑ya ‑si 'ɛ ‑lagole ye 'elrele, 'bhɛ 'pegee ‑a ‑yi pɛ mu 'ɛ 'kpɛn 'lɛkpale ye 'eke‑ ta 'elrele. ");
INSERT INTO moa_vpl VALUES ("LK11_26","072_11_26","LUK","11","26","26","‑Ya yelawoa 'bhɛ gbɛɛn‑ bhe, ‑e ge 'zina 'srwaplɛ‑ ‑bhɛɛke' 'siilɛ‑ 'ke 'mu ‑yɔɔ' ‑yiya' 'yee 'gbu ni. 'Ke 'bhɛ ꞊kla, 'bhɛɛ‑ ‑o nu dɔlɛ 'yee‑ mɛɛ 'ɛ zi. 'Bhɛla‑ ‑yile 'yee‑ mɛɛ ‑a ‑si 'ɛ 'siɛ gbɛ ‑yɔɔ' wo 'ke 'bhɛ 'yiya‑ ‑a ‑lwa 'ɛ ta.» ");
INSERT INTO moa_vpl VALUES ("LK11_27","072_11_27","LUK","11","27","27","Zesu 'yaa‑ ‑janwo' zii' 'waati 'la ba ‑zamaa' 'ɛ 'pleŋ‑, 'ke le do 'a 'pele ‑a ni dɔɔ: «Le 'la 'bhɛ 'e kpɛ 'ɛ ꞊sia, 'bhɛɛ‑ 'ke 'bhɛ 'e ꞊yaa, 'bhɛ 'pegee 'ke 'bhɛ ‑yɔn ‑naa 'e ni, 'bhɛ a pɛ ‑yinra'!» ");
INSERT INTO moa_vpl VALUES ("LK11_28","072_11_28","LUK","11","28","28","'Duŋ‑ Zesu pe 'bhɛ le 'ɛ ni dɔɔ: «‑A pe dɔɔ mɛɛ 'la zan mu ‑o 'trɔnkpa‑ ‑Waanbhaa' a ‑jan 'ɛ ꞊la, 'bhɛɛ‑ 'ke ‑wa ‑klɔsikun, 'bhɛɛ‑ zan mu a pɛ ‑yinra'.» ");
INSERT INTO moa_vpl VALUES ("LK11_29","072_11_29","LUK","11","29","29","Mɛɛ mu 'ɛ 'pale‑ ꞊saan Zesu ta, ‑ayile 'ke ‑ya pele‑ ‑o ni dɔɔ: «'Saanigɛ mu 'ɛ ‑woo 'eyɔɔle. ‑Wa zi 'bhii‑ 'ŋ 'sɔle‑ maza do klɛ ‑o ‑yrɛ ma. 'Duŋ‑ 'naa nu 'sɔle‑ maza ‑bhɛɛke' do 'kpɔ klɛlɛ ‑o ‑yrɛ ma, 'ke yaa 'e go Zonasi a pɛ 'ɛ ba. ");
INSERT INTO moa_vpl VALUES ("LK11_30","072_11_30","LUK","11","30","30","‑Amasrɔyi Zonasi ‑kla Ninivu ‑wa 'ɛ ta mu 'ɛ ma ‑tɔɔmasie 'le gɔnɛ‑ 'la gbɛɛn‑, Bhaaplɛŋ Gbe 'ɛ nu klɛlɛ 'saanigɛ mu 'ɛ ma ‑tɔɔmasie 'le 'bhɛɛ‑ gbɛɛn‑. ");
INSERT INTO moa_vpl VALUES ("LK11_31","072_11_31","LUK","11","31","31","'Bhɛ ya 'ɛ 'yi, ‑Waanbhaa' a 'kitikan yi 'ɛ 'le, ‑bhleŋgbe le Seba nu dulalɛ 'saanigɛ mɛɛ mu 'lɛɛ‑ ‑o ‑lɛ ma, 'bhɛɛ‑ ‑e ‑kpan kpalaa' ‑o ‑lii. ‑Amasrɔyi ‑yaa' pɛ 'waati 'ɛ ba ‑e ‑daa 'drunyan 'ɛ 'yi 'klɛɛn gbɔɔn do ‑yi, 'bhɛɛ‑ ‑e ꞊nwa ‑a 'trɔnkpalɛ ‑bhleŋgbe Salomɔ a ‑zadɔleya ma jan mu 'ɛ ꞊la. ‑E nu ‑kpan 'kpaalɛ‑ 'ka 'lii, ‑amasrɔyi mɛɛ 'la zan ‑o ‑gɛ 'bhɛ gblaan 'yiya‑ ‑bhleŋgbe Salomɔ ni, 'bhɛɛ‑ 'ka 'laa ‑o dɔle‑ ‑a ‑la 'ke 'ka 'trɔnkpa 'bhɛ ni. ");
INSERT INTO moa_vpl VALUES ("LK11_32","072_11_32","LUK","11","32","32","'Bhɛ klɛgbɛya do 'ɛ 'yi, ‑Waanbhaa' a 'kitikan yi 'ɛ 'le, Ninivu ‑wa 'ɛ ta mu 'ɛ ‑o nu dulalɛ mɛɛ mu 'lɛɛ‑ ‑o 'lɛ ma, 'bhɛɛ‑ 'mu nu ‑kpan 'kpaalɛ‑ ‑o ‑lii. ‑Amasrɔyi Zonasi ‑Waanbhaa' a ‑jan 'la ꞊woa Ninivu ‑wa 'ɛ ta mu 'ɛ ni, 'mu 'ploola‑ 'mu klɛza ‑yɔɔ' mu 'ɛ ma, 'bhɛɛ‑ ‑woo 'gbu ꞊naa ‑Waanbhaa' ni. ‑O nu ‑kpan 'kpaalɛ 'ka 'lii, ‑amasrɔyi mɛɛ 'la zan ‑o ‑gɛ, 'bhɛ zan gblaan 'yiya‑ Zonasi ni.» ");
INSERT INTO moa_vpl VALUES ("LK11_33","072_11_33","LUK","11","33","33","Zesu pe ‑o ni 'ezin‑ dɔɔ: «Mɛɛ 'kedo‑ 'kpɔ 'laa ‑laŋbha do bhi, 'bhɛɛ‑ ‑e 'gboŋgbo do bhulaa' 'bhɛ ‑laŋbha 'bhile‑ 'ɛ ta. Drɔɔn' 'ke ‑o ‑laŋbha 'ɛ ꞊bhia, ‑wa duŋ ‑a duŋyrɛ 'ɛ 'bhɛɛ‑ ꞊nɔɔ laanima, 'kooko‑ mɛɛ 'la zan mu ‑o wla 'zi 'fɛ 'ɛ ꞊la, 'mu sɔ ‑a ‑bhile' 'ɛ 'yele. ");
INSERT INTO moa_vpl VALUES ("LK11_34","072_11_34","LUK","11","34","34","'E 'yrɛbhɛ‑ mu 'ɛ ‑woo 'bhii‑ 'e 'flɛ 'ɛ ta ‑laŋbha 'bhile‑ do gbɛɛn‑. 'Bhɛɛ‑ 'kee‑ 'yrɛbhɛ‑ mu 'ɛ waa yrɛma ye, 'e 'flɛ 'ɛ 'kpɛn ‑o ‑gblo 'yi. 'Bhɛɛ‑ 'kee 'yrɛbhɛ‑ mu 'ɛ lele, 'e 'flɛ 'ɛ 'kpɛn takanle ‑o 'weŋ. ");
INSERT INTO moa_vpl VALUES ("LK11_35","072_11_35","LUK","11","35","35","'Bhɛla‑ ‑yile, 'e 'yrɛkpa 'e 'gbu ba 'elrele, 'kooko‑ 'yaa‑ pɛ 'tɛbhile 'ɛ yaa niinaa' 'ke ‑gblo 'le. ");
INSERT INTO moa_vpl VALUES ("LK11_36","072_11_36","LUK","11","36","36","‑Ayile, 'kee 'flɛ 'ɛ 'kpɛn ꞊kla 'tɛbhile ba, 'bhɛɛ‑ 'kee dɔpɛ do 'kpɔ 'laa ‑o ‑gblo 'yi, 'e 'flɛ 'kpɛn nu klɛlɛ 'tɛbhile ba. ‑E nu klɛlɛ 'bhii‑ ‑laŋbha 'bhile‑ mɛɛ takan 'weŋ ‑a ‑bhile' 'ɛ 'le gɔnɛ‑ 'la gbɛɛn‑.» ");
INSERT INTO moa_vpl VALUES ("LK11_37","072_11_37","LUK","11","37","37","Zesu 'yanle‑ ‑janwolele 'ke Farizi mi do 'a 'siile pɛ bhle yrɛ nɔɔ‑ 'bhɛ ba. 'Bhɛɛ‑ Zesu ‑ja 'bhɛ Farizi mi 'ɛ ba, 'bhɛɛ‑ ‑e ‑ja yaalɛ pɛbhle tabali 'ɛ zi. ");
INSERT INTO moa_vpl VALUES ("LK11_38","072_11_38","LUK","11","38","38","'Duŋ‑ Zuufu mu ‑o gbɛ mafɛ ‑waa' 'sinii ta gbɛ ma 'fɛgbɛya 'ɛ 'yi gɔnɛ‑ 'la gbɛɛn‑ 'ke ‑woo pɛbhlele, Zesu 'laa 'bhɛ gbɛ ma 'fɛlɛ‑ 'bhɛ klɛgbɛya 'ɛ 'yi. 'Bhɛla‑ ‑yile, 'ke 'bhɛ 'yee‑ ‑Farizi mi 'ɛ 'kpeelɛnile. ");
INSERT INTO moa_vpl VALUES ("LK11_39","072_11_39","LUK","11","39","39","'Bhɛ klɛle 'tɛ, 'ke Mɛɛzan Zesu ‑gɔɔn do bɔle‑ ‑a ni dɔɔ: «'Ka mu Farizi mu, 'ka 'kaa‑ ‑yi 'mi pɛ 'ɛ 'pegee 'kaa‑ pɛbhle 'tasa 'ɛ mafɛ 'elrele, 'duŋ‑ ‑faan zru 'pegee yiɛnya 'te ‑le 'ka 'kpee. ");
INSERT INTO moa_vpl VALUES ("LK11_40","072_11_40","LUK","11","40","40","Mɛɛ kloo mu! Mɛɛ 'la zan pɛ 'ɛ 'flɛ ma ꞊kla, 'bhɛ zan do 'kpɔ 'ɛ 'bhɛ ‑le 'laa ‑a 'kpee 'ɛ klɛlɛ 'ezin‑ ɛɛ? ");
INSERT INTO moa_vpl VALUES ("LK11_41","072_11_41","LUK","11","41","41","‑Ayile, ‑ka yiɛnya go 'ka zru ba, 'bhɛɛ‑ ‑ka 'kɔɔfleŋzan mu gba 'ka 'kɔɔpɛ‑ mu 'ɛ ba. 'Ke 'ka 'bhɛ ꞊kla 'bhɛ gbɛɛn‑ bhe, 'ka nu klɛlɛ zi 'weŋ 'ɛ ta.» ");
INSERT INTO moa_vpl VALUES ("LK11_42","072_11_42","LUK","11","42","42","«'Ka mu Farizi mu, 'ka ta ‑yrɛn! 'Ka 'kaa‑ ‑ziɛn ba ‑laanɛ' mu 'ɛ, 'pegee 'kaa‑ ‑ziɛnbhɛ' mu 'ɛ 'kpɛn do do ‑lɛdulayrɛ vu mi 'ɛ 'bhɛɛ‑ na Waanbhaa' ni; 'bhɛ ‑ziɛn ba ‑laanɛ' mu 'ɛ 'ke mu ‑le 'ke *mati 'pegee lu mu 'le. 'Duŋ‑ ‑lɛdɔɔ' ma 'taa 'ɛ ‑Waanbhaa' ‑yrɛ ꞊la, 'bhɛ 'pegee ‑a ba 'sɔniya 'ɛ, 'ka 'mu ‑za balaa'. 'Bhɛɛ‑ 'duŋ‑, 'kɛla 'bhɛ ‑o 'ke klɛ pɛ 'le 'pe, 'bhɛ ‑le 'ke ‑Waanbhaa' ‑za 'sɔ 'ka ni, 'bhɛ 'pegee 'ke 'ka 'lɛdɔɔle klɛ ‑a ‑yrɛ 'yi.» ");
INSERT INTO moa_vpl VALUES ("LK11_43","072_11_43","LUK","11","43","43","«'Ka mu Farizi mu, 'ka ta ‑yrɛn! 'Ke 'ka ‑o daanfɛ' mu 'ɛ ꞊la, 'ka yaayrɛ ‑lrele' mu 'ɛ 'mu ‑la makun. 'Bhɛɛ‑ 'ke 'ka ‑o ‑wa 'kpee ‑kpan mu 'ɛ ta, 'kaa‑ zi 'bhii‑ mɔkpɛn' 'ka 'lɛdɔ‑ ‑a ma, 'bhɛɛ‑ ‑o 'ka 'pubɔ‑. ");
INSERT INTO moa_vpl VALUES ("LK11_44","072_11_44","LUK","11","44","44","'Ka mu Farizi mu, 'ka ta ‑yrɛn! 'Ka ‑o 'bhii‑ mɛɛ bu mu 'la tagaanle ‑o; 'bhɛɛ‑ mɛɛ mu 'taawo‑ ‑o ta 'ke waa 'yaango‑.» ");
INSERT INTO moa_vpl VALUES ("LK11_45","072_11_45","LUK","11","45","45","'Bhɛ klɛle 'tɛ, 'ke *'Toŋ daan mi 'ɛ do 'a 'pele ‑a ni dɔɔ: «'O Daan mi, 'yaa‑ ‑janwogbɛya 'la bhe, ‑yoo 'bhii‑ 'yoo‑ wla 'zi 'o mɔɔ 'kpɛn ‑la ‑yi 'ezin‑.» ");
INSERT INTO moa_vpl VALUES ("LK11_46","072_11_46","LUK","11","46","46","'Bhɛ klɛle 'tɛ, 'ke Zesu 'a 'pele 'yee‑ 'Toŋ daan mi 'ɛ ni dɔɔ: «'Ka mu 'Toŋ daan mu, 'ka ta ‑yrɛn! 'Ka 'kwe gbinle mu dɔ mɛɛ mu wiiŋ‑, 'bhɛɛ‑ 'ka 'laa bhɔ 'mu ba sanɛ‑ 'bhɛ 'kwe mu 'ɛ 'ke 'silele. ");
INSERT INTO moa_vpl VALUES ("LK11_47","072_11_47","LUK","11","47","47","'Ka ta ‑yrɛn 'ezin‑! ‑Amasrɔyi 'ka 'taa‑ mu ‑Waanbhaa' ‑lɛla' janwo mu 'la ꞊dia, 'ka bu ‑lrele' mu dɔ 'bhɛ mu ni. ");
INSERT INTO moa_vpl VALUES ("LK11_48","072_11_48","LUK","11","48","48","'Bhɛ ya 'ɛ 'yi, 'kaa‑ zrɔn 'zi mɛɛ mu ni 'bhii‑ 'ka dɔle ‑o 'ka 'taa‑ mu 'ɛ zita ‑o klɛza ‑yɔɔ' mu 'ɛ ma. ‑Amasrɔyi ‑o ‑Waanbhaa' *‑lɛla' janwo mu 'la ꞊dia, 'ka bu ‑lrele' mu dɔ mu ni. ");
INSERT INTO moa_vpl VALUES ("LK11_49","072_11_49","LUK","11","49","49","‑Waanbhaa' a ‑zadɔleya 'ɛ ma ‑ya ꞊pia dɔɔ: ‹'Ŋ nu 'ŋ 'lɛla janwo mu 'pegee 'an *winbɔwo mu 'kpalɛ‑ ‑o ni. 'Duŋ‑ ‑o nu ‑o 'ke mu dɛlɛ, 'bhɛɛ‑ ‑o nu ‑yrɛnkpalɛ ‑o 'ke mu ta.› ");
INSERT INTO moa_vpl VALUES ("LK11_50","072_11_50","LUK","11","50","50","'Bhɛla‑ ‑yile, 'kee‑ san 'drunyan klɛle ma, 'kee‑ nu 'tɛnlɛ‑ ‑zɔn mu 'ɛ ma, ‑Waanbhaa' nu ‑o ‑lrɔkpalɛ ‑wa ‑lɛla' janwo mu 'la 'kpɛn ꞊dia do do 'bhɛ za 'ɛ 'yi. ");
INSERT INTO moa_vpl VALUES ("LK11_51","072_11_51","LUK","11","51","51","'Kee‑ san Abɛli dɛle 'ɛ ma, 'kee‑ nu 'tɛnlɛ‑ Zakari a pɛ dɛle 'ɛ ma: ‑o 'yee‑ Zakari ꞊dia 'srakagoyrɛ 'pegee ‑Waanbhaa' gbayrɛ 'ɛ 'pleŋ‑. 'Mi pe 'ka ni 'ŋ 'sɔwɛɛ‑ ma dɔɔ ‑Waanbhaa' nu ‑zɔn mu 'ɛ 'lrɔkpalɛ 'woo‑ mɛɛ mu 'ɛ 'kpɛn dɛza 'ɛ ma.» ");
INSERT INTO moa_vpl VALUES ("LK11_52","072_11_52","LUK","11","52","52","«'Ka ta ‑yrɛn! 'Ka mu 'Toŋ daan mu. ‑Amasrɔyi mɛɛ sɔ 'kanle zi 'la 'bhɛ zi 'bhɛɛ‑ 'bhɛ ‑Waanbhaa' dɔ, 'ka 'bhɛ 'gborobhɛ 'ɛ ꞊sia. 'Ka mu 'gbu 'laa kan 'bhɛ 'fɛlii 'ɛ ꞊nɔɔ, 'bhɛɛ‑ mɛɛ 'la zan mu ‑o ‑a zi 'bhii‑ 'mu 'wla 'bhɛ 'fɛlii 'ɛ ꞊nɔɔ, 'ka 'laa 'to 'ke 'bhɛ zan mu wla.» ");
INSERT INTO moa_vpl VALUES ("LK11_53","072_11_53","LUK","11","53","53","'Bhɛ ‑jan mu 'ɛ 'kpɛn blaan, Zesu 'yaa‑ zan golɛ 'bhɛ yrɛ 'ɛ ꞊nɔɔ bhla 'la ba, 'ke 'Toŋ daan mu 'ɛ 'pegee Farizi mu 'ɛ ‑wa ‑lɛma' ‑lale' 'sanle ‑jan mu 'le 'ke ‑wa ‑lrɔkpa'. 'Bhɛɛ‑ ‑wa ‑liiglinna gbɛ 'ɛ 'kpɛn ma, 'kooko‑ ‑e sɔ ‑janwole ‑o ni 'ezin‑. ");
INSERT INTO moa_vpl VALUES ("LK11_54","072_11_54","LUK","11","54","54","‑O ‑yaa bɔ 'zi ‑a ‑la, 'kooko‑ ‑o sɔ ‑a 'kunle ‑a 'gbu 'liiwli‑ ma. ");
INSERT INTO moa_vpl VALUES ("LK12_1","072_12_1","LUK","12","1","1","'Bhɛ 'waati 'ɛ ba, mɛɛ mu 'ɛ ‑o 'pa gbɛ ‑yɔɔ 'ɛ 'kɔɔ Zesu ta, ‑o ‑yaa 'tan zii' 'eke‑ gaan ta. ‑Ayile, 'ke Zesu ‑yaa' ‑klaŋlanɛ mu 'ɛ 'kpeelɛkanle 'sanle 'elwale 'pe dɔɔ: «‑Ka 'ka 'gbu 'kun 'elrele Farizi mu 'ɛ waa mɛɛ ‑yrɛkɔɔza klɛle 'ɛ ma. ‑Amasrɔyi, mɛɛ ‑yrɛkɔɔza klɛle 'ɛ ‑yoo 'bhii‑ 'bluu ‑pɛɛ 'wlɛn 'sɛkɛ. ");
INSERT INTO moa_vpl VALUES ("LK12_2","072_12_2","LUK","12","2","2","Pɛ 'tɔle‑ pɛ 'ke 'bhɛ tagaanle ‑o, ‑o nu 'bhɛ tapwɛlɛ ‑yrekpaa' do; 'bhɛɛ‑ gaanyiza 'tɔle‑ gaanyiza 'ɛ, mɔkpɛn' nu 'bhɛ dɔlɛ. ");
INSERT INTO moa_vpl VALUES ("LK12_3","072_12_3","LUK","12","3","3","'Bhɛla‑ ‑yile, 'ke 'ka ‑jan mu 'la 'kpɛn ꞊woa ‑bi zi ‑gblo 'yi, mɔkpɛn' nu 'mu malɛ ‑yrekpaa' kpataakpa. 'Bhɛɛ‑ 'ke 'ka swɛŋswɛŋ 'yi janwoa‑ mɛɛ 'trɔn 'yi 'fɛ ‑liitanle ‑la, ‑o nu 'pɛɛnlɛ‑ 'bhɛ 'wolele 'fɛ mu wiiŋ‑; 'bhɛɛ‑ mɔkpɛn' 'bhɛ 'yima‑.» ");
INSERT INTO moa_vpl VALUES ("LK12_4","072_12_4","LUK","12","4","4","'Bhɛ blaan, 'ke Zesu 'a 'pele 'ezin‑ dɔɔ: «'Ŋ 'bhɛgwlɛn‑ mu, mɛɛ 'la zan mu 'ke ‑o mɛɛ ꞊dia, 'bhɛɛ‑ waa sɔ ‑za 'bhɛɛke do klɛle‑ 'bhɛ blaan 'ka 'laa ‑gblaanlɛ' 'bhɛ zan mu 'ɛ 'lɛɛ. ");
INSERT INTO moa_vpl VALUES ("LK12_5","072_12_5","LUK","12","5","5","‑Ka 'ka 'trɔnkpa doo, 'ka sɔ ‑gblaanle' mɛɛ 'la zan 'lɛɛ‑, 'bhɛ zan ‑le ‑gɛ: ‑Waanbhaa' 'la sɔ mɛɛ 'niigole ‑a ‑yi, 'bhɛɛ‑ 'bhɛ blaan, ‑e 'ka blin ‑jranama 'tɛ 'yi. Wlan 'gbu 'ɛ ni, ‑ka ‑gblaan 'bhɛɛ‑ 'lɛɛ.» ");
INSERT INTO moa_vpl VALUES ("LK12_6","072_12_6","LUK","12","6","6","«Waa sɔ 'vonɛ 'soo gɔnle‑ ‑gɔli' 'taŋbha plɛ ma ɛɛ? 'Duŋ‑ ‑o do 'kpɔ ‑za 'laa ni ‑Waanbhaa' 'kpee. ");
INSERT INTO moa_vpl VALUES ("LK12_7","072_12_7","LUK","12","7","7","'Duŋ‑ 'ka mabhaabhɔ 'ke 'bhɛ kan 'vonɛ 'srɛ ta. Ali‑, ‑e 'ka 'wiiŋ‑ winbhɛ mu 'ɛ 'kpɛn 'liidɔ‑. ‑Ayile 'ka 'laa ‑gblaanlɛ' ‑titi.» ");
INSERT INTO moa_vpl VALUES ("LK12_8","072_12_8","LUK","12","8","8","Zesu pe 'ezin‑ dɔɔ: «'Mi pe 'ka ni 'ŋ 'sɔwɛɛ ma dɔɔ: 'ke mɛɛ 'la zan 'a ꞊pia mɔkpɛn' 'yrɛ ma kpataakpa 'kaa 'bhɛ ‑o 'an pɛ mɛɛ 'le, Bhaaplɛŋ Gbe 'ɛ nu a pelɛ ‑Waanbhaa' a ‑mlɛkɛ' mu 'ɛ 'yrɛ ma 'kaa ‑yaa pɛ ‑le 'bhɛ zan 'ɛ 'le 'ezin‑. ");
INSERT INTO moa_vpl VALUES ("LK12_9","072_12_9","LUK","12","9","9","'Duŋ‑ 'ke mɛɛ 'la zan 'a ꞊pia mɔkpɛn' 'yrɛ ma kpataakpa 'kaa yaa 'mi dɔ, Bhaaplɛŋ Gbe 'ɛ nu a pelɛ ‑Waanbhaa' a ‑mlɛkɛ' mu 'ɛ yrɛ ma dɔɔ yaa 'bhɛ zan 'ɛ dɔ 'ezin‑. ");
INSERT INTO moa_vpl VALUES ("LK12_10","072_12_10","LUK","12","10","10","'Ke mɛɛ 'la zan Bhaaplɛŋ Gbe 'ɛ ma jan ‑yɔɔ ꞊woa, ‑Waanbhaa' nu 'bhɛ zan a ‑sroma 'yanlɛ‑. 'Duŋ‑ 'ke mɛɛ 'la zan *Lii 'Weŋ 'ɛ ma jan ‑yɔɔ' ꞊woa, ‑Waanbhaa' 'laa nu 'bhɛ zan a ‑sroma 'yanlɛ‑ ‑titi.» ");
INSERT INTO moa_vpl VALUES ("LK12_11","072_12_11","LUK","12","11","11","«'Bhɛ ya 'ɛ 'yi, 'ke mɛɛ mu ‑ja 'ka 'le Zuufu mu daanfɛ' mu ꞊la oo, 'kitikan mu 'ɛ ba oo, 'bhɛ 'pegee ‑kɔɔ' ta mɛɛ gblaan mu 'ɛ ba. 'Bhɛɛ‑ 'ke ‑o ‑kpan ‑kpalaa' 'ka 'lii, 'ka nu 'ka 'gbu ta gwledan ‑jan yɛkɛ‑ 'la 'wolɛ‑ 'ka 'laa 'bhɛ yiɛnkanlɛ. ");
INSERT INTO moa_vpl VALUES ("LK12_12","072_12_12","LUK","12","12","12","‑Amasrɔyi, 'ka nu ‑jan yɛkɛ‑ 'la 'wolɛ‑, Lii 'Weŋ 'ɛ nu 'bhɛ dɔlɛ 'ka 'kpee 'bhɛ 'waati do 'kpɔ 'ɛ ba.» ");
INSERT INTO moa_vpl VALUES ("LK12_13","072_12_13","LUK","12","13","13","'Bhɛ blaan bhe 'tɛ, 'ke ‑zamaa' 'ɛ 'pleŋ‑ mɛɛ do 'a 'pele Zesu ni dɔɔ: «'O Daan mi, ‑a pe 'ŋ nɛɛnɛ‑ 'ɛ ni dɔɔ 'o 'ciɛn 'la 'ke 'o dɛ 'bhɛ ꞊twa 'o ni, ‑e 'bhɛ ‑yiciɛn' 'o ma.» ");
INSERT INTO moa_vpl VALUES ("LK12_14","072_12_14","LUK","12","14","14","Zesu pe ‑a ni dɔɔ: «'Ŋ 'bhɛgwlɛn‑, ‑dele 'mi ꞊kla 'ka ta 'kitikan mi 'le, 'bhɛɛ‑ ‑dele 'mi ꞊kla 'kaa‑ pɛ mu ‑yiciɛn' mi 'le ɛɛ?» ");
INSERT INTO moa_vpl VALUES ("LK12_15","072_12_15","LUK","12","15","15","'Bhɛ blaan, 'ke ‑ya pele‑ ‑o 'kpɛn ni dɔɔ: «‑Ka 'ka 'yrɛkpa 'ka 'gbu ba 'elrele ‑naflo maza mu ‑lrɔ 'ɛ ma. ‑Amasrɔyi bhaaplɛŋ do ‑si 'ɛ ‑daŋ' 'laa 'ke ‑a 'kɔɔpɛ‑ do ‑kplɛn mu 'le, 'ali‑ 'kee‑ ꞊kla 'ke pɛzan ‑gbɛnɛ do 'le.» ");
INSERT INTO moa_vpl VALUES ("LK12_16","072_12_16","LUK","12","16","16","'Bhɛla‑ ‑yile, 'kee‑ ‑gɔɔn 'lɛɛ‑ 'bhɛ bɔle‑ ‑o ni dɔɔ: «‑Naflo zan do a gba mu 'ɛ 'lrela‑. ");
INSERT INTO moa_vpl VALUES ("LK12_17","072_12_17","LUK","12","17","17","'Bhɛ ya 'ɛ 'yi, ‑e ‑yaa pe 'zi ‑a 'gbu 'kpee dɔɔ: ‹'Ŋ nu ‑a klɛlɛ 'nale‑ ‑a ma ɛɛ, ‑amasrɔyi 'an gba la pɛ mu 'ɛ ‑o 'klayrɛ‑ laa ‑o 'ŋ 'kɔɔ.› ");
INSERT INTO moa_vpl VALUES ("LK12_18","072_12_18","LUK","12","18","18","'Bhɛɛ‑ ‑za do ‑dwa ‑a 'kpee 'ke ‑ya pele‑ dɔɔ: ‹'Ŋ nu ‑za 'lɛɛ‑ 'bhɛɛ‑ klɛlɛ. 'Ŋ nu 'an pɛbhɛ 'kla 'fɛ mu 'ɛ 'wilɛ‑, 'bhɛɛ‑ 'ŋ ‑wo dɔ gbɛ drɛɛ wo 'ke mu gblaan 'yiya‑ ‑a ‑lwa mu 'ɛ ni. 'Ŋ nu 'an pɛbhɛ 'pegee 'ŋ 'ciɛn mu 'ɛ 'kpɛn 'klalɛ‑ 'woo‑ 'fɛ mu 'ɛ ꞊la. ");
INSERT INTO moa_vpl VALUES ("LK12_19","072_12_19","LUK","12","19","19","'Bhɛ blaan, 'ŋ nu ‑a pelɛ 'ŋ 'gbu 'kpee dɔɔ: 'Mi 'e 'ciɛn ‑bebe mu ꞊klaa 'fɛ mu 'ɛ ꞊la, ‑o nu 'sɔlɛ‑ 'e 'lɛbɔle lɛɛ ‑bebe ta. 'Bhɛla‑ ‑yile, 'e 'yitrɛ‑, 'bhɛɛ‑ bo pɛbhlele 'pegee ‑wɛɛn 'mile ma, 'bhɛɛ‑ 'e ‑zabla'.› ");
INSERT INTO moa_vpl VALUES ("LK12_20","072_12_20","LUK","12","20","20","'Duŋ‑ ‑e 'bhɛ 'pelawoa bhe, 'bhɛ 'waati do 'kpɔ 'ɛ ba, 'ke ‑Waanbhaa' 'a 'pele ‑a ni dɔɔ: ‹Mɛɛ kloo, ‑zɔn ‑bi 'lɛɛ‑ zi, 'ŋ nu 'e 'nii‑ 'ɛ golɛ 'e 'yi. 'Bhɛɛ‑ 'yee 'ciɛn mu 'la 'kpɛn magaanna ‑o nu bolɛ ‑de 'gbu ‑la ni ɛɛ?›» ");
INSERT INTO moa_vpl VALUES ("LK12_21","072_12_21","LUK","12","21","21","'Bhɛla‑ ‑yile, 'ke Zesu 'a pele ‑o ni dɔɔ: «'Ke mɛɛ 'la zan bole ‑o ‑naflo mu ‑lɛkpale ma 'eke‑ ta ‑a 'gbu ni, 'bhɛɛ‑ 'ke yaa ‑o pɛzan 'le ‑Waanbhaa' ‑yrɛ 'yi, ‑za 'yansi 'la bhe 'bhɛ ‑le tɛn 'bhɛ zan 'ɛ ma.» ");
INSERT INTO moa_vpl VALUES ("LK12_22","072_12_22","LUK","12","22","22","'Bhɛ blaan, 'ke Zesu 'a pele ‑yaa' ‑klaŋlanɛ mu 'ɛ ni dɔɔ: «'Mi pe 'ka ni dɔɔ 'ka nu pɛ 'la 'bhlelɛ‑, 'bhɛ 'pegee 'ka nu dunɛ‑ 'la klalɛ 'ka ta, 'ka 'laa 'mu do 'kpɔ ‑za yiɛnkanlɛ. ");
INSERT INTO moa_vpl VALUES ("LK12_23","072_12_23","LUK","12","23","23","‑Amasrɔyi bhaaplɛŋ ‑si 'ɛ 'bhɛ mabhaabhɔ bhle pɛle ta, 'bhɛ 'pegee ‑a 'flɛ 'bhɛ mabhaabhɔ dunɛ‑ ta. ");
INSERT INTO moa_vpl VALUES ("LK12_24","072_12_24","LUK","12","24","24","‑Ka laanima maannɛ‑ mu 'ɛ ‑glin doo! Waa pɛbhɛ bɔ, 'bhɛɛ‑ waa pɛ bhaa kan. 'Bhɛ 'pegee pɛbhɛ zrɛ dɔle laa ‑o 'kɔɔ, 'duŋ‑ ‑Waanbhaa' ‑o ‑lɛbɔ' yi 'oo yi. 'Bhɛɛ‑ 'duŋ‑, 'ka mu mabhaabhɔ maannɛ‑ mu ta. ");
INSERT INTO moa_vpl VALUES ("LK12_25","072_12_25","LUK","12","25","25","'Ka ‑de 'gbu ‑le sɔ ‑a 'gbu ‑si 'ɛ sa baan 'klale ‑a ba ‑a ma 'ŋgami mu 'ɛ 'kɔɔ ɛɛ? ");
INSERT INTO moa_vpl VALUES ("LK12_26","072_12_26","LUK","12","26","26","'Ke 'ka ma 'ŋgami 'laa sɔ 'ka 'gbu 'si 'ɛ sa baan' 'klale ‑a ba, ‑mɛle ꞊kla 'bhɛɛ‑ 'ka ‑o 'ka blina‑ yiɛndɔ 'zi ‑za 'bhɛɛke ‑vin mu 'ɛ 'yi ɛɛ? ");
INSERT INTO moa_vpl VALUES ("LK12_27","072_12_27","LUK","12","27","27","‑Ka 'ka 'yrɛkpa doo, gba la ‑bɔn mu 'ɛ 'bhɔgbɛya 'ɛ ta. Waa yewo, 'bhɛ 'pegee waa dunɛ‑ sra. 'Ali‑ ‑bhleŋgbe Salomɔ a ‑nafloya 'ɛ ta, ‑a ‑baale' ‑lreleya ‑yi 'laa 'yalɛ‑ ‑o do 'kpɔ ‑baagbɛya 'ɛ ni. ");
INSERT INTO moa_vpl VALUES ("LK12_28","072_12_28","LUK","12","28","28","'Ee! 'Ka 'kpale‑ la ‑Waanbhaa' 'yi 'dɛ! 'Ke ‑Waanbhaa' ‑bɔn mu baa, ‑bɔn mu 'la ‑woo ‑zɔn gba la, 'bhɛɛ‑ too ‑o nu klɛlɛ 'kpaciepɛ 'le. ‑Mɛla ma 'bhɛɛ‑ yaa nu 'sɔlɛ‑ 'ka mu ‑baale' ɛɛ? ");
INSERT INTO moa_vpl VALUES ("LK12_29","072_12_29","LUK","12","29","29","'Bhɛla‑ ‑yile, 'ka 'laa 'ka 'bhle pɛle 'pegee 'ka 'mi pɛ ‑za yiɛnkanlɛ. ");
INSERT INTO moa_vpl VALUES ("LK12_30","072_12_30","LUK","12","30","30","‑Amasrɔyi, 'drunyan 'yi mɛɛ mu 'la waa ‑Waanbhaa' dɔ, 'mu ‑le 'bhɛ ‑za 'yansi mu 'ɛ ‑glin. 'Duŋ‑ 'ka maza ‑o pɛ 'oo pɛ 'la ma, 'ka Dɛ 'bhɛ 'kpɛn dɔ. ");
INSERT INTO moa_vpl VALUES ("LK12_31","072_12_31","LUK","12","31","31","Drɔɔn' ‑ka ‑Waanbhaa' a pɛ ‑bhleŋgbeya zi 'ɛ 'bhɛɛ‑ ziglin‑ 'elwale 'pe, 'bhɛɛ‑ ‑e nu ‑za ‑vin mu 'ɛ 'kpɛn 'nalɛ‑ 'ka ni boolazi.» ");
INSERT INTO moa_vpl VALUES ("LK12_32","072_12_32","LUK","12","32","32","'Bhɛ blaan, 'ke Zesu 'a 'pele ‑yaa' ‑klaŋlanɛ mu 'ɛ ni dɔɔ: «'An ‑bhlaa 'lɛ 'fiɛntrɔnnɛ do, 'ka 'laa ‑gblaanlɛ'! ‑Amasrɔyi, ‑e ‑swa 'ka Dɛ ‑Waanbhaa' ni 'kee‑ yaa ‑bhleŋgbeya ‑wa 'ɛ na 'ka ni. ");
INSERT INTO moa_vpl VALUES ("LK12_33","072_12_33","LUK","12","33","33","‑Ka 'ka 'ciɛn mu 'ɛ 'kpɛn gɔn, 'bhɛɛ‑ ‑ka ‑o ma pɛ 'ɛ 'na 'kɔɔfleŋzan mu ni. ‑Gɔli' 'kpa ‑bɔtɔ mu 'la 'ke waa sɔ 'siɛle, ‑ka 'bhɛ mu klɛ 'ka 'gbu ni, 'bhɛ 'pegee ‑ka 'kaa ‑naflo mu 'ɛ zrɛdɔ laflɛ' 'yi, 'kooko‑ waa nu yanlɛ 'bhɛ ꞊nɔɔ ye. ‑Amasrɔyi ‑faannii' mu laa nu ‑o yelɛ, 'bhɛɛ‑ ‑woo faan 'bhɛ ꞊nɔɔ ye, 'bhɛ 'pegee ‑wlɛnnɛ' mu laa nu 'sɔlɛ‑ ‑o 'siɛle. ");
INSERT INTO moa_vpl VALUES ("LK12_34","072_12_34","LUK","12","34","34","‑Amasrɔyi 'yaa‑ ‑naflo 'ɛ 'kpale‑ ‑o yrɛ 'la ꞊nɔɔ, 'e zru 'pegee 'e 'yrikpale ‑o 'bhɛɛ‑ yrɛ 'ɛ ta.» ");
INSERT INTO moa_vpl VALUES ("LK12_35","072_12_35","LUK","12","35","35","Zesu pe mɛɛ mu 'ɛ ni dɔɔ: «Yi 'oo yi, 'ka 'yri 'wlale‑ bo 'ka 'gbu ‑za 'le, 'bhɛɛ‑ 'kaa‑ ‑laŋbha mu 'ɛ 'bhile‑ klɛ. ");
INSERT INTO moa_vpl VALUES ("LK12_36","072_12_36","LUK","12","36","36","'Bhɛɛ‑ ‑ka klɛ 'bhii‑ 'fɛ do ‑la yewonɛ mu 'ɛ gbɛɛn‑. ‑O yri ‑o ‑waa' 'fɛzan‑ 'ɛ nule ta 'ke 'bhɛ da le dɔyrɛ ꞊nɔɔ 'fɛti 'ɛ ta. 'Kooko‑ 'ke 'bhɛ ꞊nwa 'waati 'oo 'waati 'la ba, 'bhɛɛ‑ 'ke 'bhɛ kɔkɔdia ‑o ta, ‑o sɔ 'fɛ 'ɛ 'liigole 'bhɛ ni. ");
INSERT INTO moa_vpl VALUES ("LK12_37","072_12_37","LUK","12","37","37","'Ke ‑waa' 'fɛzan‑ 'ɛ ꞊nwa, 'bhɛɛ‑ 'ke 'bhɛ ꞊bhwa ‑o ta 'ke ‑woo ‑o ‑yrɛ ma, ‑waa pɛ ‑yi nu ‑nralɛ'. 'Mi pe 'ka ni 'ŋ 'sɔwɛɛ‑ 'ɛ ma dɔɔ 'yee‑ 'fɛzan‑ 'ɛ ‑e nu 'sɛntru do dɔlɛ ‑a 'saanla꞊, 'bhɛɛ‑ ‑e nu ‑yaa' yewonɛ mu 'ɛ 'siilɛ‑ pɛle ma, 'bhɛɛ‑ 'yee‑ 'gbu nu 'mu a pɛle 'ɛ dulalɛ 'mu ꞊la. ");
INSERT INTO moa_vpl VALUES ("LK12_38","072_12_38","LUK","12","38","38","'Kee‑ ꞊nwa blaŋdrɛyi 'oo, 'kee‑ ꞊nwa blaŋdrɛyi ‑zanta' oo, 'bhɛɛ‑ 'kee‑ ꞊bhwa ‑o ta 'ke ‑woo ‑yrɛ ma, ‑waa pɛ ‑yi nu ‑nralɛ'.» ");
INSERT INTO moa_vpl VALUES ("LK12_39","072_12_39","LUK","12","39","39","«‑Ka 'ka 'trɔnkpa 'elrele ‑jan 'lɛɛ‑ ꞊la: 'Ke 'fɛzan‑ do ‑yaa ‑faannii' 'ɛ nu 'bhla 'ɛ dɔ ‑yaa' 'fɛ 'ɛ ꞊la, yaa ‑yaa nu yidɛlɛ, 'bhɛɛ‑ ‑ya to 'ke ‑faannii' 'ɛ wla ‑yaa' 'fɛ 'ɛ ꞊la. ");
INSERT INTO moa_vpl VALUES ("LK12_40","072_12_40","LUK","12","40","40","‑Ayile, 'ka mu, 'ka 'yri 'laa golɛ 'ka 'gbu ‑za le. ‑Amasrɔyi 'ke 'ka 'yri 'laa ‑o Bhaaplɛŋ Gbe 'ɛ ta 'waati 'la ba, ‑e nu nulɛ 'bhɛɛ‑ 'waati 'ɛ ba.» ");
INSERT INTO moa_vpl VALUES ("LK12_41","072_12_41","LUK","12","41","41","'Bhɛ klɛle 'tɛ, 'ke Piɛri Zesu 'lrɔkpale dɔɔ: «Mɛɛzan, 'yoo‑ 'bhɛ ‑gɔɔn 'lɛɛ‑ 'bhɛ bɔ 'zi 'o mɔɔ do ‑kplɛn ‑la ma taa‑ 'ya bɔ 'zi mɔkpɛn' ‑la ma ɛɛ?» ");
INSERT INTO moa_vpl VALUES ("LK12_42","072_12_42","LUK","12","42","42","Mɛɛzan Zesu 'a 'lɛkwan‑ 'yee‑ Piɛri ni dɔɔ: «'Ke yewonɛ 'la 'lɛdɔɔle ‑o, 'bhɛɛ‑ ‑a zru ‑o do, ‑a zan nu 'a 'kpalɛ‑ ‑yaa' 'fɛ 'ɛ ꞊la mu 'ɛ 'kpɛn 'wiiŋ‑; 'kooko‑ ‑e sɔ pɛle nale‑ 'mu ni pɛle 'waati 'ɛ ba. ");
INSERT INTO moa_vpl VALUES ("LK12_43","072_12_43","LUK","12","43","43","Yewonɛ 'la 'ke ‑a zan 'ɛ ꞊bhwa ‑a ta 'ke ‑yoo yewo 'zi 'elrele, 'bhɛ yewonɛ 'ɛ 'bhɛ a pɛ ‑yinra'. ");
INSERT INTO moa_vpl VALUES ("LK12_44","072_12_44","LUK","12","44","44","'Mi pe 'ka ni 'ŋ 'sɔwɛɛ‑ ma dɔɔ 'fɛzan‑ 'ɛ nu ‑a 'kɔɔpɛ‑ mu 'ɛ 'kpɛn gbɛkpalɛ ‑a 'kɔɔ. ");
INSERT INTO moa_vpl VALUES ("LK12_45","072_12_45","LUK","12","45","45","'Duŋ‑ 'ke 'bhɛ yewonɛ 'ɛ ‑e ‑yaa' ye 'ɛ ꞊twa ‑a nɔɔ‑, 'bhɛɛ‑ ‑ya ꞊pia ‑a 'gbu 'kpee dɔɔ: ‹'Ŋ zan ‑o ‑mɔ 'zi ‑yaa' 'taa 'ɛ ta, yaa nu nulɛ 'saanibhe.› 'Bhɛla ‑yile 'kee‑ 'fɛ 'ɛ ꞊la yewonɛ 'gwlaan‑ ‑vin mu 'ɛ 'pegee yewo le mu 'ɛ zɔnle ‑saan, 'bhɛɛ‑ 'kee‑ ꞊bwa pɛbhlele 'pegee ‑wɛɛn 'mile‑ ma, 'bhɛɛ‑ 'kee‑ ‑wɛɛn dɛ. ");
INSERT INTO moa_vpl VALUES ("LK12_46","072_12_46","LUK","12","46","46","'Kee‑ ꞊bwa 'bhɛɛ‑ klɛle ma, ‑a zan nu yi 'ɛ 'pegee 'bhɛ 'nu 'waati 'ɛ nu 'klalɛ‑ ‑a ba. 'Bhɛla‑ ‑yile, 'bhɛ nu ‑a 'krowolɛ 'eyɔɔle ‑e ‑za 'yɔɔ‑ oo ‑za 'yɔɔ‑ mu 'la 'kpɛn ꞊kla 'mu ‑zayi'. 'Bhɛɛ‑ mɛɛ 'la zan mu laa gblaan ‑Waanbhaa' ‑lɛɛ ‑a dɔ nu klɛlɛ 'mu ta ‑yrɛn 'ɛ 'ke ba.» ");
INSERT INTO moa_vpl VALUES ("LK12_47","072_12_47","LUK","12","47","47","«'Ke yewonɛ 'la ‑ya zan zru maza dɔ, 'bhɛɛ‑ 'ke yaa 'bhɛ klɛlɛ, ‑o nu 'bhɛ yewonɛ 'ɛ zɔnlɛ 'ebebele. ");
INSERT INTO moa_vpl VALUES ("LK12_48","072_12_48","LUK","12","48","48","'Duŋ‑ 'ke yewonɛ 'la 'bhɛ 'laa 'bhɛ zan zru maza dɔ, 'bhɛɛ‑ 'ke ‑a klɛza ‑yɔɔ' 'ɛ ma ‑yoo 'ke zɔnpɛ 'le; ‑o nu 'bhɛ yewonɛ 'ɛ zɔnlɛ sanɛ‑. 'Bhɛla‑ ‑yile, ‑o ‑za ‑bebe ‑naa mɛɛ 'la zan ni, ‑o nu ‑za ‑bebe 'yrɛwolɛ 'bhɛɛ‑ zan ma. 'Bhɛɛ‑ ‑o ‑za ‑bebe gbɛkpaa‑ mɛɛ 'la zan 'kɔɔ, ‑o nu ‑za ‑bebe 'yrɛwolɛ 'bhɛɛ‑ zan ma 'ezin‑.» ");
INSERT INTO moa_vpl VALUES ("LK12_49","072_12_49","LUK","12","49","49","Zesu pe ‑o ni 'ezin‑ dɔɔ: «'Ŋ ꞊nwa 'tɛ ‑la bɔlɛ 'trɛ ta, 'bhɛɛ‑ 'ŋ 'yaa‑ zi bi 'bhii‑ ‑wa ꞊bhia gban. ");
INSERT INTO moa_vpl VALUES ("LK12_50","072_12_50","LUK","12","50","50","‑Yrɛn ‑gbɛnɛ do ‑o zan baalɛ 'mi ta, 'bhɛ nu klɛlɛ 'bhii‑ 'ŋ 'wiiŋfɛle ‑yi ba. 'Duŋ‑ 'sani‑ 'bhɛ yi 'ɛ 'bhɔle‑ pleŋ‑, 'ŋ blina‑ yiɛn ‑o. ");
INSERT INTO moa_vpl VALUES ("LK12_51","072_12_51","LUK","12","51","51","'Ka mu 'kpee ma 'ŋ ꞊nwa yilabla 'nalɛ‑ 'trɛ ta mu ni ɛɛ? Drɔɔn' 'ŋ ꞊nwa ‑o ‑yiciɛnyrɛ ‑la nɔɔ‑. ");
INSERT INTO moa_vpl VALUES ("LK12_52","072_12_52","LUK","12","52","52","'Kee‑ san ‑zɔn ma, 'fɛ do ‑la mɛɛ 'soo 'yiciɛnle nu klɛlɛ. ‑Ayile, mɛɛ yaga nu ‑o zibɔlɛ mɛɛ plɛ ma, 'bhɛɛ‑ mɛɛ plɛ nu ‑o zibɔlɛ mɛɛ yaga ma. ");
INSERT INTO moa_vpl VALUES ("LK12_53","072_12_53","LUK","12","53","53","'Fɛ do ‑la mu ba, ‑nɛ dɛ nu 'bhɛ 'wlɛnlɛ‑ 'bhɛ 'nɛ 'ɛ ma, 'bhɛɛ‑ ‑nɛ nu 'bhɛ 'wlɛnlɛ 'bhɛ dɛ ma. 'Bhɛ klɛgbɛya do 'ɛ 'yi, ‑nɛ nɛɛ 'ɛ 'bhɛ nu 'bhɛ 'wlɛnlɛ‑ 'bhɛ 'lu ma 'bhɛɛ‑ gbɛɛn‑. 'Bhɛɛ‑ ‑nɛ le do nu 'bhɛɛ‑ 'yansi za klɛlɛ 'bhɛ nɛɛ ni. 'Ezin‑ le ‑naale' do nu ‑wlɛnlɛ' 'bhɛ a le drɛɛ ma, 'bhɛɛ‑ le drɛɛ nu 'bhɛɛ‑ 'yansi za klɛlɛ 'bhɛ 'naale‑ ni 'ezin‑.» ");
INSERT INTO moa_vpl VALUES ("LK12_54","072_12_54","LUK","12","54","54","Zesu pe mɛɛ mu 'ɛ ni 'ezin‑ dɔɔ: «'Ke 'ka la tilale ꞊ya 'kee‑ da ‑yretɛbhɛ baayrɛ nɔɔ‑, 'kaa pe 'bhɛ yrɛ do 'ɛ ꞊nɔɔ bhe dɔɔ la ‑o zan banlɛ. 'Bhɛɛ‑ ‑e ban. ");
INSERT INTO moa_vpl VALUES ("LK12_55","072_12_55","LUK","12","55","55","'Bhɛɛ‑ 'ke ‑ploo 'kanle‑ ‑saan 'kee‑ da wɛyi‑ ba ‑yrɛ ta, 'kaa pe dɔɔ ‑yretɛ' nu ‑bhilɛ'. 'Bhɛɛ‑ 'bhɛ ‑le klɛ. ");
INSERT INTO moa_vpl VALUES ("LK12_56","072_12_56","LUK","12","56","56","Mɛɛ ‑yrɛkɔɔza klɛ mu, 'ka sɔ 'trɛ ta pɛ ‑tɔɔmasie mu 'pegee laflɛ' 'yi pɛ ‑tɔɔmasie mu 'ɛ ‑yimale, 'bhɛɛ‑ ‑mɛla ma 'ka 'laa sɔ ‑za 'la 'bhɛ ‑o klɛ 'zi ‑zɔn ‑gɛ 'bhɛ 'yimale ɛɛ?» ");
INSERT INTO moa_vpl VALUES ("LK12_57","072_12_57","LUK","12","57","57","Zesu pe 'ezin‑ dɔɔ: «‑Mɛle ‑kla 'bhɛɛ‑ pɛ 'la 'bhɛ 'lɛdɔɔle ‑o 'ka 'laa sɔ 'bhɛ dɔle‑ 'ka 'gbu 'kɔɔ ɛɛ? ");
INSERT INTO moa_vpl VALUES ("LK12_58","072_12_58","LUK","12","58","58","'Ke ‑za do ‑o 'ka 'pegee mɛɛ do pleŋ‑, 'bhɛɛ‑ 'ke 'yee‑ mɛɛ 'ɛ ‑ya zi 'bhii‑ ‑e ge 'e 'le ‑klu ta, dɔ klɛn 'kee 'bhɛ ‑za 'ɛ 'yrɛbago 'bhɛ mɛɛ 'ɛ 'le, 'bhɛɛ‑ 'ka kpa do ma 'ka ge bhla zi zi 'ɛ 'lii. 'Kebhlaale, 'kee‑ ‑ja 'e 'le ‑klu ta, 'kitikan mu 'ɛ ba, 'mu nu 'e 'kpalɛ‑ ‑kasofɛ gooba mu 'ɛ 'kɔɔ, 'bhɛɛ‑ 'mu 'e bɔ ‑kaso 'yi. ");
INSERT INTO moa_vpl VALUES ("LK12_59","072_12_59","LUK","12","59","59","'Mi pe 'e ni dɔɔ 'sani‑ 'e 'pwɛle‑ pleŋ‑ 'bhɛ ‑kaso 'ɛ 'yi, ‑e ‑gɔli' yɛkɛ‑ 'la ‑kpan ‑balaa' 'e ta, 'e nu 'bhɛ 'kpɛn gbawolɛ 'ke 'bhɛ ge 'tɛnlɛ‑ 'e 'kɔɔ ‑gɔli' bhɛ do 'ɛ ma.» ");
INSERT INTO moa_vpl VALUES ("LK13_1","072_13_1","LUK","13","1","1","'Bhɛ 'waati 'ɛ ba, ‑janmatii Pilati mɛɛ 'ke mu winbwa‑ 'kaa 'mu ge Galile 'klɛɛn 'ɛ 'yi mu 'ɛ 'ke dɛ. 'Bhɛɛ‑ 'yee‑ Pilati 'bhɛ mɛɛ mu 'ɛ yiɛn 'ɛ 'pegee ‑waa' 'sraka go wi yiɛn mu 'ɛ 'yizaala 'eke‑ ba, 'bhɛɛ‑ ‑yoo ꞊kla 'ke 'sraka 'le ‑Waanbhaa' ni. 'Duŋ‑ Zesu 'yaa‑ ‑janwo' zii' 'waati 'la ba, 'ke mɛɛ 'ke mu 'bhɛ ‑za 'ɛ 'yilrɔkpale ‑a ma. ");
INSERT INTO moa_vpl VALUES ("LK13_2","072_13_2","LUK","13","2","2","‑Ayile 'ke Zesu 'a 'pele ‑o ni dɔɔ: «‑O 'woo‑ Galile 'klɛɛn 'yi mu 'la ꞊dia, 'ka mu 'kpee ma ‑waa' ‑za 'yɔɔ‑ mu 'ɛ ‑woo 'ebebele 'ke 'bhɛ kan Galile 'klɛɛn 'yi mɛɛ ‑vin mu 'ɛ 'mu a pɛ 'ɛ ta ɛɛ? ");
INSERT INTO moa_vpl VALUES ("LK13_3","072_13_3","LUK","13","3","3","'Yooye‑! 'Mi pe 'ka ni dɔɔ 'ke 'ka 'laa 'ploolɛ‑ 'kaa‑ ‑za 'yɔɔ‑ mu 'ɛ ma, 'ka nu klɛlɛ siɛle 'bhii‑ 'woo‑ Galile mɛɛ mu 'ɛ gbɛɛn‑ 'ezin‑. ");
INSERT INTO moa_vpl VALUES ("LK13_4","072_13_4","LUK","13","4","4","'Bhɛɛ‑ 'ezin‑, Siloe 'fɛgwlɛ‑ 'ɛ 'klalaa‑ mɛɛ vu ta 'srwaa‑ 'la ta Zeruzalɛmu, 'ka 'mu 'kpee ma 'woo‑ mɛɛ vu ta 'srwaa‑ 'ɛ ‑o klɛza mu 'ɛ 'yɔɔ‑ ‑yiya' 'ke 'bhɛ kan Zeruzalɛmu mɛɛ ‑vin mu 'ɛ 'kpɛn ta ɛɛ? ");
INSERT INTO moa_vpl VALUES ("LK13_5","072_13_5","LUK","13","5","5","'Yooye‑! 'Mi pe 'ka ni dɔɔ, 'ke 'ka 'laa 'ploolɛ‑ 'kaa‑ ‑za 'yɔɔ‑ mu 'ɛ ma, 'ka nu klɛlɛ 'siɛle 'bhii‑ Zeruzalɛmu mu 'ɛ gbɛɛn‑.» ");
INSERT INTO moa_vpl VALUES ("LK13_6","072_13_6","LUK","13","6","6","'Bhɛ blaan, 'ke Zesu ‑gɔɔn do bɔle‑ ‑o ni dɔɔ: «Mɛɛ do ‑yri diiŋ do ꞊swa ‑yaa' ‑drɔɔ gba 'ɛ 'yi. ‑Yri bhaa 'kan bhla 'ɛ 'bhɔle‑ 'ke 'yee‑ mɛɛ 'ɛ 'nule 'yee‑ ‑yri bhaa 'ɛ 'kanyrɛ‑ ꞊nɔɔ. 'Duŋ‑ yaa 'bhɛ bhaa do 'kpɔ 'yelɛ‑ 'bhɛ 'yi. ");
INSERT INTO moa_vpl VALUES ("LK13_7","072_13_7","LUK","13","7","7","'Bhɛ 'yi 'tɛ, 'ke ‑ya pele‑ ‑drɔɔ gba la yetanɛ 'ɛ ni dɔɔ: ‹‑A 'san lɛɛ yaga ma 'ke 'ŋ nu ‑yri 'lɛɛ bhaa ‑glinlɛ' ‑a ‑yi, 'bhɛɛ‑ 'naa ‑a bhaa do 'kpɔ 'yelɛ‑ ‑lido'. Lɛɛ ‑bhɛɛke' ta, 'ke yaa ‑a bhaa klɛlɛ, ‑a takan', ‑mɛla ma 'bhɛɛ‑ ‑a 'sɔle‑ ‑o bhaa ma yrɛ 'lɛɛ‑ ꞊nɔɔ ɛɛ?› ");
INSERT INTO moa_vpl VALUES ("LK13_8","072_13_8","LUK","13","8","8","'Duŋ‑ ‑drɔɔ gba la yetanɛ 'ɛ 'bhɛ pe 'yee‑ mɛɛ 'ɛ ni dɔɔ: ‹'Ŋ zan, ‑a 'to 'ke lɛɛla‑ 'ɛ 'bhɛ 'kan 'a ta doo. 'Ŋ nu ‑gluu do 'kanlɛ‑ ‑a zi, 'bhɛɛ‑ 'ŋ grɛni kla ‑a zi 'kooko‑ ‑a nii‑ zinaa' ‑a ta 'elrele. ");
INSERT INTO moa_vpl VALUES ("LK13_9","072_13_9","LUK","13","9","9","'Ke 'bhɛ ꞊kla, ‑dɔke' ‑e nu 'sɔlɛ‑ ‑a bhaa klɛle‑ lɛɛtoo. 'Ke yaa ‑bhaalɛ' 'e nu 'sɔlɛ‑ ‑a takanle.›» ");
INSERT INTO moa_vpl VALUES ("LK13_10","072_13_10","LUK","13","10","10","*‑Yitrɛ' yi do ma, Zesu 'yaa‑ mɛɛ mu daan 'zi ‑Waanbhaa' a ‑jan 'ɛ 'le Zuufu mu daanfɛ' do ‑la. ");
INSERT INTO moa_vpl VALUES ("LK13_11","072_13_11","LUK","13","11","11","Koo ‑la ga ‑yaa le do ma 'bhɛ daanfɛ' 'ɛ ꞊la. Lii ‑yɔɔ ‑le 'bhɛ ga 'ɛ ꞊bwa 'yee‑ le 'ɛ ma. ‑A lɛɛ vu ta 'srwaa‑ ‑le ‑yaa bhe, 'ke koo ‑la ga ‑a ma, 'bhɛɛ‑ yaa ‑yaa sɔ ‑a ‑lɛdɔɔle. ");
INSERT INTO moa_vpl VALUES ("LK13_12","072_13_12","LUK","13","12","12","Zesu 'a 'yelawoa 'ke 'bhɛ 'a 'pele ‑a ni dɔɔ: «Le ‑nɛ, 'e koo ‑la ga 'ɛ ‑gwa ‑zɔn.» ");
INSERT INTO moa_vpl VALUES ("LK13_13","072_13_13","LUK","13","13","13","'Bhɛ klɛle 'tɛ, 'ke Zesu 'e gbɛ 'kpale ‑a ma, 'bhɛɛ 'bhɛ yrɛ do 'kpɔ 'ɛ ꞊nɔɔ bhe, 'ke ‑ya ‑lɛdɔɔle, 'kee‑ dulale ‑a gaan ta. 'Bhɛɛ‑ 'kee‑ ‑Waanbhaa' 'tɔbhɔle. ");
INSERT INTO moa_vpl VALUES ("LK13_14","072_13_14","LUK","13","14","14","'Duŋ‑ 'bhɛ Zuufu daanfɛ' 'ɛ ꞊la ‑kuŋlii 'ɛ 'bhɛ 'bhɛ zrupliila dɔɔ ‑mɛla ma 'bhɛɛ‑ Zesu 'yee‑ le 'ɛ 'bheela‑ ‑yitrɛ' yi 'ɛ ma ɛɛ. 'Bhɛ klɛle 'tɛ, 'ke ‑ya pele‑ mɛɛ mu 'ɛ ni dɔɔ: «‑Gbɛɛyi' do 'ɛ ꞊la, yewo yi ‑o ‑yrekpaa' 'srwado‑, 'ka 'sɔ nule‑ 'ka 'bheeyrɛ‑ ꞊nɔɔ 'bhɛ yi mu 'ɛ 'le. 'Duŋ‑ ‑yitrɛ' yi 'ɛ 'bhɛ 'laa ‑o 'ke ‑bhee yi 'le.» ");
INSERT INTO moa_vpl VALUES ("LK13_15","072_13_15","LUK","13","15","15","‑Ayile, 'ke Mɛɛzan Zesu 'a 'pele ‑a ni dɔɔ: «Mɛɛ ‑yrɛkɔɔza klɛ mu! ‑Yitrɛ' yi 'ɛ ma 'ka 'kpɛn do do laa 'kaa‑ dri mu pwɛ ‑waa' wɛlɛ‑ mu 'ɛ 'yi, 'bhɛɛ‑ 'ka 'ploo‑ 'kaa‑ ‑soofalinɛ mu 'ɛ ma, 'kooko‑ ‑o ge ‑yi 'milɛ‑ tɔ 'ɛ 'lɛ ma ɛɛ? ");
INSERT INTO moa_vpl VALUES ("LK13_16","072_13_16","LUK","13","16","16","'Bhɛɛ‑ ‑kɔɔ' 'taa‑ Abraamu 'nranɛ‑ 'lɛɛ‑, 'ke ‑Setran' 'a 'yrela‑ lɛɛ vu ta 'srwaa‑ ta, 'ali‑ 'kee‑ ꞊kla ‑yitrɛ' yi 'le oo, 'naa sɔ a 'ploole bi ɛɛ?» ");
INSERT INTO moa_vpl VALUES ("LK13_17","072_13_17","LUK","13","17","17","Zesu a ‑jan 'lɛkungbɛya 'ɛ 'bhɛ ‑yraladwa ‑o 'kpɛn ma. 'Duŋ‑ ‑e ‑yaa 'sɔle‑ maza ‑gbɛnɛ ‑gbɛnɛ mu 'la klɛ 'zi, mɛɛ mu 'ɛ zrukpaale ‑yaa 'bhɛ 'yi. ");
INSERT INTO moa_vpl VALUES ("LK13_18","072_13_18","LUK","13","18","18","Zesu pe mɛɛ mu 'ɛ ni dɔɔ: «'Ŋ sɔ *‑Waanbhaa' a ‑bhleŋgbeya ‑wa 'ɛ 'kpale ‑mɛ pɛ ‑la ma ɛɛ? ");
INSERT INTO moa_vpl VALUES ("LK13_19","072_13_19","LUK","13","19","19","‑Yoo 'bhii‑ ‑yri diiŋ 'la ‑wa sii mutaadi 'bhɛ bhɛnɛ‑ do gbɛɛn‑. Mɛɛ do 'bhɛ mutaadi bhɛ ꞊bwa ‑yaa' gba 'ɛ 'yi. ‑E ꞊bhwa, 'bhɛɛ‑ ‑e gbaandia‑, 'bhɛɛ‑ ‑e ꞊kla 'ke ‑yri diiŋ ‑gbɛnɛ do 'le. 'Bhɛɛ‑ maannɛ‑ mu 'mu 'fɛ ꞊kpaa ‑a gbɛ mu 'ɛ 'yi.» ");
INSERT INTO moa_vpl VALUES ("LK13_20","072_13_20","LUK","13","20","20","Zesu pe mɛɛ mu 'ɛ ni 'ezin‑ dɔɔ: «'Ŋ sɔ *‑Waanbhaa' a ‑bhleŋgbeya ‑wa 'ɛ 'kpale ‑mɛ pɛ ‑la ma ɛɛ? ");
INSERT INTO moa_vpl VALUES ("LK13_21","072_13_21","LUK","13","21","21","‑Yoo 'bhii‑ 'bluu ‑pɛɛ 'wlɛn 'sɛkɛ do. 'Ke le do 'a 'yizaala 'kilo mia do 'bhɛ 'soo 'bluu ‑pɛɛ ba, ‑e 'bhɛ 'bluu ‑pɛɛ 'ɛ wlɛn.» ");
INSERT INTO moa_vpl VALUES ("LK13_22","072_13_22","LUK","13","22","22","Zesu ge bhla zi Zeruzalɛmu, ‑e ‑yaa 'kan zii' ‑wa ‑gbɛnɛ mu 'pegee ‑wa 'nɛ mu ta. ");
INSERT INTO moa_vpl VALUES ("LK13_23","072_13_23","LUK","13","23","23","'Bhɛ 'yi 'tɛ, 'ke mɛɛ do 'a 'lrɔkpale dɔɔ: «Mɛɛzan, mɛɛ sanɛ‑ ‑le nu golɛ ‑za ‑yi ɛɛ?» 'Bhɛ klɛle 'tɛ, 'ke Zesu 'a 'pele mɛɛ mu 'ɛ ni dɔɔ: ");
INSERT INTO moa_vpl VALUES ("LK13_24","072_13_24","LUK","13","24","24","«‑Ka dɔ 'eglɔɔle, 'bhɛɛ‑ 'ka wla 'fɛlii kprɛnɛ‑ 'ɛ 'lii. ‑Amasrɔyi 'mi pe 'ka ni 'ŋ 'sɔwɛɛ‑ ma dɔɔ mɛɛ ‑bebe mu nu ‑a pelɛ 'kaa ‑o wlayrɛ ‑glinle', 'bhɛɛ‑ 'duŋ‑ waa nu 'sɔlɛ‑ wlale‑.» ");
INSERT INTO moa_vpl VALUES ("LK13_25","072_13_25","LUK","13","25","25","«'Ke 'fɛzan‑ 'ɛ ‑ya ‑wlɛnna bhla 'la ba, 'bhɛɛ‑ 'kee‑ 'fɛlii 'gborobhɛ 'ɛ ꞊bwa 'ke 'ka ‑o 'bhɛ bhla 'ɛ ba 'pɛɛlii‑. 'Ke 'bhɛ ꞊kla, 'ka nu kɔkɔdɛle 'sanlɛ‑ ‑a ta 'ke 'kaa pe dɔɔ: ‹Mɛɛzan, 'o mɔɔ ‑le, 'fɛ 'ɛ 'liigo‑ 'o ni›. 'Bhɛɛ‑ ‑e nu a ‑lɛkunlɛ 'ka ni 'fɛ 'ɛ 'kpee dɔɔ: ‹'Naa 'ka dɔ.› ");
INSERT INTO moa_vpl VALUES ("LK13_26","072_13_26","LUK","13","26","26","'Bhɛ bhla 'ɛ ba, 'ka nu ‑a pelɛ ‑a ni dɔɔ: ‹‑Kɔɔ' pɛbhla‑ 'eke‑ zi, 'bhɛɛ‑ ‑kɔɔ' ‑yi ꞊mia 'eke‑ zi, 'bhɛɛ‑ 'e mɛɛ mu ‑daanna 'waa‑ ‑wa 'ɛ 'kpee ‑gbleba mu 'ɛ ta.› ");
INSERT INTO moa_vpl VALUES ("LK13_27","072_13_27","LUK","13","27","27","'Bhɛɛ‑ Mɛɛzan nu ‑a pelɛ 'ka ni 'ezin‑ dɔɔ: ‹'Naa 'ka dɔ, ‑ka 'ka 'pleŋgo‑ 'ŋ ma, 'ka mu ‑za 'yɔɔ‑ klɛ mu.› ");
INSERT INTO moa_vpl VALUES ("LK13_28","072_13_28","LUK","13","28","28","'Bhɛ yi 'ɛ 'le, 'ke 'ka Abraamu 'pegee Izaki, 'bhɛɛ‑ ‑Waanbhaa' a *‑lɛla' janwo mu 'ɛ 'kpɛn ꞊ya bhla 'la ba *‑Waanbhaa' a ‑bhleŋgbeya ‑wa 'ɛ ta, 'ka nu 'ka gbɛnɛbhɛ mu 'ɛ 'sɔnkpalɛ 'bhɛɛ‑ 'ka wisi; 'bhɛɛ‑ ‑o nu 'ka blinlɛ 'pɛɛlii‑. ");
INSERT INTO moa_vpl VALUES ("LK13_29","072_13_29","LUK","13","29","29","‑Amasrɔyi mɛɛ mu nu dalɛ 'drunyan ‑daŋma' yrɛ 'ɛ 'kpɛn ꞊nɔɔ, 'bhɛɛ‑ ‑o nu pɛbhlelɛ ‑Waanbhaa' a ‑bhleŋgbeya ‑wa 'ɛ ta. ");
INSERT INTO moa_vpl VALUES ("LK13_30","072_13_30","LUK","13","30","30","'Bhɛ ya 'ɛ 'yi, mɛɛ 'ke mu ‑o zi zilɛɛ‑ mu 'le ‑zɔn, 'duŋ‑ 'mu nu klɛlɛ ‑zanta' mu 'le too. 'Bhɛɛ‑ mɛɛ 'ke mu ‑o ‑zanta' mu 'le ‑zɔn, 'duŋ‑ 'mu nu klɛlɛ zilɛɛ‑ mu 'le too.» ");
INSERT INTO moa_vpl VALUES ("LK13_31","072_13_31","LUK","13","31","31","'Bhɛ 'waati 'ɛ ba, Farizi mu 'ɛ 'ke mu ꞊nwa Zesu ‑din 'bhɛɛ‑ ‑o pe a ni dɔɔ:«'E Go ‑gɛ, 'bhɛɛ‑ 'e ge yrɛ ‑bhɛɛke' do ꞊nɔɔ, ‑amasrɔyi ‑bhleŋgbe Erɔdi ‑a zi 'bhii‑ ‑yee' dɛ.» ");
INSERT INTO moa_vpl VALUES ("LK13_32","072_13_32","LUK","13","32","32","'Bhɛ klɛle 'tɛ, 'ke ‑ya pele‑ ‑o ni dɔɔ: «‑Ka ge a pe 'yee‑ ‑gbɛŋgbɛni 'plalu mɛɛ 'la bhe ‑a ni 'kaa: 'Mi ‑o 'zina mu ‑gbin 'zi mɛɛ mu zi; 'bhɛ 'pegee 'ŋ 'yoo‑ gadɛ mu ‑bhee 'zi ‑zɔn 'pegee too. 'Bhɛɛ‑ 'ŋ nu yanlɛ 'ŋ 'woye‑ 'ɛ 'le ‑yrekpaa' yaga mi 'ɛ ma. ");
INSERT INTO moa_vpl VALUES ("LK13_33","072_13_33","LUK","13","33","33","'Bhɛla‑ ‑yile, 'ŋ nu 'ŋ 'yrɛgbaanlɛ Zeruzalɛmu 'taa ta gele 'ɛ zi, ‑zɔn 'pegee too, 'bhɛɛ‑ tootama. ‑Amasrɔyi ‑Waanbhaa' a ‑lɛla' janwo mi 'ɛ yaa sɔ gale‑ yrɛ ‑bhɛɛke' ꞊nɔɔ 'ke yaa 'e go Zeruzalɛmu do ‑kplɛn ba. ");
INSERT INTO moa_vpl VALUES ("LK13_34","072_13_34","LUK","13","34","34","«'Ee! Zeruzalɛmu ‑wa la mu, 'Ee! Zeruzalɛmu ‑wa la mu! 'Ka mu ‑le ‑Waanbhaa' ‑lɛla' janwo mu 'ɛ dɛ, 'bhɛɛ‑ 'kee‑ mɛɛ 'la zan mu 'winbwa‑ 'ka ta, 'ka kpoti pa 'mu ma, 'bhɛɛ‑ 'ka 'mu dɛ. Yaa 'sanlɛ‑ ‑zɔn ma 'ke 'an pe dɔɔ 'ŋ 'yoo‑ 'ka 'lɛkpale 'eke‑ ta 'bhii‑ maa da do 'bhɛ 'nɛ mu 'ɛ 'lɛkpa 'eke‑ ta ‑a gbɛŋroŋ‑ mu 'ɛ ꞊la gɔnɛ‑ 'la gbɛɛn‑. 'Duŋ‑ 'ka 'laa dɔlɛ ‑a ‑la do ‑titi. ");
INSERT INTO moa_vpl VALUES ("LK13_35","072_13_35","LUK","13","35","35","‑Ka 'ka 'trɔnbadɔ doo, ‑Waanbhaa' nu 'ka do ‑kplɛn 'tolɛ‑ ‑a nɔɔ‑. 'Bhɛɛ‑ 'mi pe 'ka ni 'ŋ 'sɔwɛɛ‑ 'ɛ ma dɔɔ: 'ka 'laa nu 'ŋ 'yelɛ‑ ‑li 'ke 'bhɛ ge 'tɛnlɛ‑ 'ka nu ‑a pelɛ yi 'la 'le dɔɔ: ‹Mɛɛ 'la zan ‑o zan Mɛɛzan ‑Waanbhaa' 'tɔ 'ɛ 'yi, bhaa 'e ‑dɔɔbo'!›» ");
INSERT INTO moa_vpl VALUES ("LK14_1","072_14_1","LUK","14","1","1","*‑Yitrɛ' yi do ma, Zesu ‑ja pɛbhlelɛ Farizi mu 'ɛ ‑o ‑kuŋlii 'ɛ do ba. ‑O 'pegee Farizi mu 'la 'yaa‑ pɛbhle 'zi 'eke‑ zi, 'mu ‑yaa ‑a klɛza mu 'ɛ 'klɔsikun zii'. ");
INSERT INTO moa_vpl VALUES ("LK14_2","072_14_2","LUK","14","2","2","'Bhɛ klɛle 'tɛ, 'ke mɛɛ do nule‑ dulalɛ Zesu 'lɛ ma: ‑mlaan ga ‑yaa 'bhɛ mɛɛ 'ɛ ma. ");
INSERT INTO moa_vpl VALUES ("LK14_3","072_14_3","LUK","14","3","3","‑Ayile, 'ke Zesu 'woo‑ 'Toŋ daan mu 'ɛ 'pegee Farizi mu 'ɛ 'lrɔkpale dɔɔ: «‑Kɔɔa' 'toŋ 'ɛ ta, ‑o sɔ mɛɛ ‑bheele' taa‑ waa sɔ ‑a ‑bheele' ‑yitrɛ' yi 'ɛ ma ɛɛ?» ");
INSERT INTO moa_vpl VALUES ("LK14_4","072_14_4","LUK","14","4","4","'Bhɛɛ‑ 'duŋ‑, ‑o tagale ꞊bwa. 'Bhɛ klɛle 'tɛ, 'ke Zesu 'e gbɛ 'kpale gadɛ mi 'ɛ ma, 'ke 'bhɛ 'bheele, 'bhɛɛ‑ 'ke ‑ya pele‑ 'bhɛ ni dɔɔ 'bhɛ ge 'bhɛ ba ‑lɛ ma. ");
INSERT INTO moa_vpl VALUES ("LK14_5","072_14_5","LUK","14","5","5","'Bhɛ blaan, 'ke Zesu ‑o ‑lrɔkpale dɔɔ: «'Ka ‑de 'gbu ‑le 'kee‑ ‑kla ‑a ‑nɛ 'le oo, 'kee‑ ‑kla ‑yaa' dri do 'le oo, 'ke 'bhɛ ‑balaa' ‑klɔŋ do ‑yi ‑yitrɛ' yi do ma, yaa nu 'bhɛ golɛ 'yee‑ ‑klɔŋ 'ɛ yi 'yee‑ ‑yitrɛ' yi 'gbu 'ɛ ma ɛɛ?» ");
INSERT INTO moa_vpl VALUES ("LK14_6","072_14_6","LUK","14","6","6","'Bhɛɛ‑ waa 'sɔlɛ‑ 'bhɛ 'lɛkunle ‑a ni. ");
INSERT INTO moa_vpl VALUES ("LK14_7","072_14_7","LUK","14","7","7","Zesu 'a 'yelawoa 'bhii‑ ‑o mɛɛ mu 'la 'kpɛn 'siila‑ pɛleyrɛ 'ɛ ꞊nɔɔ, 'mu 'kpɛn 'yaa‑ zilɛɛ‑ yaayrɛ ‑lrele' mu 'ɛ 'mu ‑la makun' zii', 'kee‑ ‑gɔɔn dɔ bɔle‑ dɔɔ: ");
INSERT INTO moa_vpl VALUES ("LK14_8","072_14_8","LUK","14","8","8","«'Ke mɛɛ do 'e 'siila‑ le dɔyrɛ nɔɔ‑ ‑zabla' do ta, 'yaa gelɛ yaalɛ zilɛɛ‑ yaayrɛ 'ɛ 'bhɛ ꞊nɔɔ. ‑Amasrɔyi 'ke ‑o mɛɛ ‑bhɛɛke' do ‑siila 'yee‑ le dɔyrɛ 'ɛ ꞊nɔɔ, 'bhɛɛ‑ 'ke 'bhɛ gblaan ‑yiya' 'bhi ni 'ezin‑, ");
INSERT INTO moa_vpl VALUES ("LK14_9","072_14_9","LUK","14","9","9","'bhɛɛ‑ 'ke 'ka 'kpɛn zeti‑ mi 'ɛ ꞊nwa 'waati 'la ba, 'ke ‑ya ꞊pia 'bhi ni dɔɔ: ‹'E 'wlɛn‑, 'bhɛɛ‑ 'e 'yaayrɛ‑ 'ɛ 'na mɛɛ 'lɛɛ‑ ni.› 'Ke 'bhɛ ꞊kla, ‑yrala' nu dɔlɛ 'e ma, 'bhɛɛ‑ 'e nu gelɛ yaalɛ mɔkpɛn' ‑zanta' zizan‑. ");
INSERT INTO moa_vpl VALUES ("LK14_10","072_14_10","LUK","14","10","10","Drɔɔn' 'ke ‑woo 'e 'siila‑ yrɛ do ꞊nɔɔ, ge yala‑ mɔkpɛn' ‑zanta' yaayrɛ 'ɛ 'bhɛɛ‑ ꞊nɔɔ; 'kooko‑ 'e zeti‑ mi 'la 'bhɛ 'e 'siila‑, 'ke 'bhɛ 'a ꞊ya 'bhii‑ zizan‑ 'yaayrɛ‑ 'ɛ ‑gaale' laa ‑o 'e ba, 'bhɛ sɔ ‑a pele‑ 'e ni dɔɔ: ‹'Ŋ 'bhɛgwlɛn‑ nu yala‑ zilɛɛ‑ ‑gɛ!› 'Ke 'bhɛ ꞊kla, 'e ŋgblo ma sɔ 'ŋgole ‑o mɛɛ mu 'la 'kpɛn 'siila‑ 'mu 'yrɛ ma. ");
INSERT INTO moa_vpl VALUES ("LK14_11","072_14_11","LUK","14","11","11","‑Ayile, 'ke mɛɛ 'oo mɛɛ 'la zan 'bhɛ 'gbu magbaandɛ mɛɛ ma, ‑Waanbhaa' nu 'bhɛ zan 'ɛ mavɛɛlɛ, 'duŋ‑ 'ke mɛɛ 'la zan 'bhɛ 'gbu mavɛɛ, ‑Waanbhaa' nu 'bhɛ zan 'ɛ magbaandɛlɛ.» ");
INSERT INTO moa_vpl VALUES ("LK14_12","072_14_12","LUK","14","12","12","'Bhɛɛ‑ mɛɛ 'la zan Zesu 'siila‑ pɛbhleyrɛ 'ɛ nɔɔ‑, Zesu pe 'bhɛ ni dɔɔ: «'Ke 'ya zi 'bhii‑ 'e mɛɛ mu 'sii‑ pɛbhle ma 'e ba ‑yrekpaa' oo, yromazi oo, yaa klɛlɛ 'e 'bhɛgwlɛn‑ mu oo, 'e nɛɛnɛ‑ mu oo, 'e 'yiɛnii mu oo, 'e ‑din ‑naflo zan mu 'ɛ ‑o 'kedo‑ 'kpɔ 'le; 'kooko‑ 'bhɛ mu laa nu 'e 'siilɛ‑ 'ezin‑ pɛbhle ma 'mu ba, 'bhɛɛ‑ ‑o 'yaa‑ ‑za 'wlan 'ɛ ‑zigo' 'ɛ ma. ");
INSERT INTO moa_vpl VALUES ("LK14_13","072_14_13","LUK","14","13","13","'Duŋ‑ 'kee 'yoo‑ mɛɛ mu ‑lɛwɛɛ' 'fɛti ta pɛle do klɛle‑, 'kee‑ ꞊kla 'kɔɔfleŋzan mu 'le oo, ‑flugba mu 'le oo, gaan 'siɛle‑ mu 'le oo, 'bhɛ 'pegee ‑yrɛ 'wi mu, 'mu ‑la 'sii‑ 'yaa‑ pɛbhle 'ɛ ma. ");
INSERT INTO moa_vpl VALUES ("LK14_14","072_14_14","LUK","14","14","14","'Kee 'bhɛ ꞊kla, 'yaa‑ pɛ ‑yi nu ‑nralɛ', ‑amasrɔyi waa nu 'sɔlɛ‑ ‑a ‑zigole 'e ma 'ke ‑woo 'e sii pɛbhle ma ‑o ba boolazi. ‑Waanbhaa' nu 'bhɛ ‑zigolɛ 'e ma mɛɛ ‑lɛdɔɔle mu bwe yi 'ɛ 'le gale ba.» ");
INSERT INTO moa_vpl VALUES ("LK14_15","072_14_15","LUK","14","15","15","Mɛɛ 'la zan mu 'pegee Zesu 'yaa‑ pɛbhle 'zi 'eke‑ zi, ‑o do 'bhɛ ‑jan 'la bhe 'bhɛ 'male‑, 'ke 'bhɛ 'a 'pele Zesu ni dɔɔ: «‑O nu mɛɛ 'la zan 'siilɛ‑ pɛle ma *‑Waanbhaa' a ‑bhleŋgbeya ‑wa 'ɛ ta, 'bhɛ zan a pɛ ‑yi nu ‑nralɛ'.» ");
INSERT INTO moa_vpl VALUES ("LK14_16","072_14_16","LUK","14","16","16","'Bhɛ klɛle 'tɛ, 'ke Zesu 'a 'pele ‑a ni dɔɔ: «‑Yrekpaa' do mɛɛ do mɛɛ mu ‑lɛwɛɛ' pɛbhle ‑koo ‑gbɛnɛ do ‑kla, 'bhɛɛ‑ ‑e mɛɛ ‑bebe ‑siila 'bhɛ ma. ");
INSERT INTO moa_vpl VALUES ("LK14_17","072_14_17","LUK","14","17","17","Pɛbhle 'waati 'ɛ 'bhɔle‑, 'kee‑ yaa 'fɛ 'ɛ ꞊la yewonɛ 'ɛ do winbɔle 'kaa 'bhɛ ge a pe mɛɛ mu 'ɛ ni dɔɔ ‑o nu, pɛ 'ɛ 'kpɛn 'lɛbɛŋgole ‑o. ");
INSERT INTO moa_vpl VALUES ("LK14_18","072_14_18","LUK","14","18","18","'Duŋ‑, ‑o 'kpɛn do do a 'pele‑ ‑saan 'bhɛ yewonɛ 'ɛ ni dɔɔ waa sɔ nule‑ ‑yaa' pɛleyrɛ 'ɛ ꞊nɔɔ. Mɛɛ ‑lwa mi 'ɛ 'bhɛ pe 'yee‑ yewonɛ 'ɛ ni 'kaa ‑ya pe ‑a zan 'ɛ ni dɔɔ: ‑A 'zoole‑, dɔɔ yaa nu 'sɔlɛ‑ gele‑ pɛbhleyrɛ 'ɛ ꞊nɔɔ, ‑amasrɔyi ‑e gba do ‑lwa ‑e gele‑ 'pwɛlɛ‑ 'bhɛ ta. ");
INSERT INTO moa_vpl VALUES ("LK14_19","072_14_19","LUK","14","19","19","‑A plɛ mi 'ɛ 'bhɛ pe ‑a ni dɔɔ, 'bhɛ 'laa nu 'sɔlɛ‑ gele‑ pɛbhleyrɛ 'ɛ ꞊nɔɔ, ‑amasrɔyi 'bhɛ dri vu ‑lwa, 'bhɛɛ 'bhɛ gele‑ 'mu ‑yidanlɛ 'bhɛ a gbabhɛ 'ɛ ta. ");
INSERT INTO moa_vpl VALUES ("LK14_20","072_14_20","LUK","14","20","20","‑A yaga mi 'ɛ 'bhɛ pe a ni 'ezin‑ dɔɔ 'bhɛ 'laa sɔ gele‑ pɛbhleyrɛ 'ɛ ꞊nɔɔ, ‑amasrɔyi 'bhɛ le do ꞊sia 'edrɛɛle. ");
INSERT INTO moa_vpl VALUES ("LK14_21","072_14_21","LUK","14","21","21","'Bhɛ klɛle 'tɛ, 'ke yewonɛ 'ɛ 'niinale ‑a zan ba, 'bhɛɛ‑ 'kee‑ 'woo‑ mɛɛ mu 'ɛ 'wojan‑ mu 'ɛ 'yiklale 'bhɛ 'kɔɔ. ‑Ayile 'ke 'fɛzan‑ 'ɛ ‑ya zrupliile', 'bhɛɛ‑ 'ke ‑ya pele‑ ‑yaa' yewonɛ 'ɛ ni dɔɔ: ‹Ge blaale‑ ‑wa 'ɛ 'kpee ‑gbleba mu 'ɛ 'pegee ‑kpan mu 'ɛ ta, 'bhɛɛ 'kɔɔfleŋzan mu oo, ‑flugba mu oo, ‑yrɛ 'wi mu oo, 'bhɛ 'pegee mɛɛ gaan 'siɛle‑ mu, ‑o 'kpɛn 'sii 'kaa ‑o nu ‑gɛ.› ");
INSERT INTO moa_vpl VALUES ("LK14_22","072_14_22","LUK","14","22","22","'Bhɛ blaan 'waati sa, 'ke yewonɛ 'ɛ 'nule ‑a pelɛ ‑a zan ni dɔɔ: ‹'Ŋ Zan, 'e pe 'ŋ mɛɛ 'la zan mu 'sii‑ 'ŋ 'bhɛ ꞊kla, 'duŋ‑ yaayrɛ 'ɛ 'ke ꞊bwa, 'bhɛɛ‑ mɛɛ laa ‑o 'mu ta.› ");
INSERT INTO moa_vpl VALUES ("LK14_23","072_14_23","LUK","14","23","23","'Bhɛ klɛle 'tɛ, 'ke ‑a zan 'a pele‑ 'a ni dɔɔ: ‹Ge gba la zi mu 'ɛ 'lii, 'bhɛ 'pegee 'fɛ ‑gbeŋ mu 'ɛ zi, 'bhɛɛ‑ ‑a pe mɛɛ nu 'ɛ ni 'kaa ‑o nu kpaŋma 'ŋ ba, 'kooko‑ 'an 'fɛ sɔ 'pale.›» ");
INSERT INTO moa_vpl VALUES ("LK14_24","072_14_24","LUK","14","24","24","'Bhɛɛ‑ ‑e pe dɔɔ: «'Ŋ mɛɛ ‑lwa mu 'la 'siila‑ pɛle 'ɛ ma, ‑o 'kedo‑ 'kpɔ laa nu 'an pɛ 'ɛ 'ke 'bhlelɛ.» ");
INSERT INTO moa_vpl VALUES ("LK14_25","072_14_25","LUK","14","25","25","‑Yrekpaa' do, Zesu 'pegee ‑zamaa' 'srɛ do ‑yaa 'taawo zii' 'eke‑ zi. 'Bhɛɛ‑ 'ke ‑ya ‑lɛ 'niinale 'mu ta, 'bhɛɛ‑ 'ke ‑ya pele‑ 'mu ni dɔɔ: ");
INSERT INTO moa_vpl VALUES ("LK14_26","072_14_26","LUK","14","26","26","«'Ke mɛɛ 'la zan ‑a zi 'bhii‑ 'bhɛ klɛ 'an pɛ ‑klaŋlanɛ 'le, 'ke 'ŋ ‑za 'laa 'sɔlɛ‑ 'bhɛ zan 'ɛ ni 'ke 'bhɛ kan 'bhɛ dɛ oo, 'bhɛ nɛɛ oo, 'bhɛ nɛɛnɛ‑ 'gwlaan‑ 'pegee 'bhɛ nɛɛnɛ‑ le mu ta, 'bhɛ 'pegee 'bhɛ 'gbu ta; 'bhɛ zan laa nu 'sɔlɛ‑ klɛle‑ 'mi 'an pɛ ‑klaŋlanɛ 'le. ");
INSERT INTO moa_vpl VALUES ("LK14_27","072_14_27","LUK","14","27","27","'Ke mɛɛ 'la zan laa dɔlɛ ‑yrɛn 'ɛ 'kpɛn ‑glɔɔn 'bhlele‑ ‑la 'fɔke 'bhɛ ge 'tɛnlɛ‑ ‑a gale ma, 'bhɛɛ 'kee‑ dɔ 'ŋ zi, 'bhɛ zan laa sɔ klɛle‑ 'mi a pɛ ‑klaŋlanɛ 'le. ");
INSERT INTO moa_vpl VALUES ("LK14_28","072_14_28","LUK","14","28","28","'Ka ‑de 'gbu ‑le 'ke ‑ya zi 'bhii‑ ‑e 'saŋgaso do dɔ, yaa yalaa' 'elwale 'pe, 'bhɛɛ‑ ‑e nu ‑gɔli' yɛkɛ‑ 'la 'wlalɛ‑ 'yee‑ 'saŋgaso dɔle 'ɛ 'yi, ‑e 'bhɛ nɔɔ. 'Bhɛɛ‑ 'kee‑ ‑a gbɛ nu 'sɔlɛ‑ 'yee‑ 'saŋgaso 'ɛ dɔle‑ ta ‑e 'bhɛ 'yaango‑. ");
INSERT INTO moa_vpl VALUES ("LK14_29","072_14_29","LUK","14","29","29","'Ke yaa 'bhɛ klɛlɛ 'elwale 'pe, 'kee‑ 'yee‑ 'saŋgaso 'ɛ dɔle‑ ‑saan, 'bhɛɛ‑ 'ke yaa ‑a ‑lɛyanlɛ, ‑e nu klɛlɛ mɔkpɛn' a pɛ 'sɔnsipɛ 'le. ");
INSERT INTO moa_vpl VALUES ("LK14_30","072_14_30","LUK","14","30","30","'Bhɛɛ‑ mɛɛ mu nu ‑a pelɛ dɔɔ: ‹Mɛɛ 'lɛɛ‑ ‑e ‑yaa' 'saŋgaso 'ɛ dɔle ‑saan, 'bhɛɛ‑ yaa 'sɔlɛ‑ ‑a ‑lɛyanle.› ");
INSERT INTO moa_vpl VALUES ("LK14_31","072_14_31","LUK","14","31","31","'Bhɛ klɛgbɛya do 'ɛ 'yi 'ezin‑, ‑bhleŋgbe 'ɛ ‑dele sɔ ‑wlɛnle' ‑bhleŋgbe 'bhɛɛke do 'kaama‑ 'kaa ‑e gwledanle 'bhɛ ba, 'ke yaa ‑yaa' gwledan mu 'ɛ 'nɔɔlɛ‑ 'elwale 'pe ɛɛ? 'Kee‑ ‑yalaa' 'pe, 'bhɛɛ‑ ‑ya klɛ gɔnɛ‑ 'la gbɛɛn‑ 'bhɛɛ‑ 'yee‑ 'pegee ‑yaa' gwledan mu 'waa vu 'ɛ ‑o sɔ gwledanle ‑bhleŋgbe 'bhɛɛke do 'ɛ 'pegee 'bhɛ a gwledan mu 'waa mia do 'ɛ ba, ‑ya 'kpeelɛdan 'bhɛɛ‑ ma 'elwale 'pe. ");
INSERT INTO moa_vpl VALUES ("LK14_32","072_14_32","LUK","14","32","32","'Duŋ‑ 'ke ‑ya ꞊ya 'bhii‑ waa sɔ gele‑ gwledanlɛ 'mu ba, ‑e mɛɛ do winbɔ 'bhɛ ‑bhleŋgbe 'bhɛɛke do 'ɛ ba, 'ke 'bhɛ 'laa 'bhɔlɛ‑ ‑li ‑o ‑din 'waati 'la ba, 'kaa ‑o 'ploo‑ gwle 'ɛ ma, 'bhɛɛ ‑o ‑bhoolaya dɔ ‑o pleŋ‑. ");
INSERT INTO moa_vpl VALUES ("LK14_33","072_14_33","LUK","14","33","33","'Bhɛ klɛgbɛya 'ɛ 'yi, 'ka do 'kpɔ 'laa sɔ klɛle‑ 'mi a ‑klaŋlanɛ 'le 'ke 'bhɛ zan laa 'bhɛ 'niigolɛ 'bhɛ 'kɔɔpɛ‑ mu 'ɛ 'kpɛn 'yi 'elwale 'pe.» ");
INSERT INTO moa_vpl VALUES ("LK14_34","072_14_34","LUK","14","34","34","Zesu pe 'ezin‑ dɔɔ: «Mɔkpɛn' 'a 'yaango‑ 'bhii‑ wɛ ‑o 'ke pɛ ‑lrele' do 'le. 'Duŋ‑ 'ke ‑a ‑nraleya 'ɛ ‑gwa ‑a ‑yi, ‑o sɔ ‑a ‑nrale' ‑mɛ pɛ ‑la ‑le ɛɛ? ");
INSERT INTO moa_vpl VALUES ("LK14_35","072_14_35","LUK","14","35","35","Yaa ‑za 'kedo‑ 'kpɔ 'yanwo‑ ‑li 'trɛ 'pegee 'trɛ ti ma. 'Bhɛɛ‑ ‑e klɛ 'ke blin pɛ 'le. 'Ke ‑za 'lɛɛ‑ 'yima 'trɔn ‑o 'ka ŋgblo ma, ‑kaa ‑yima'!» ");
INSERT INTO moa_vpl VALUES ("LK15_1","072_15_1","LUK","15","1","1","'Nisrakun mu 'ɛ 'kpɛn 'pegee mɛɛ 'joo 'yɔɔ‑ mu 'ɛ ‑woo mabɛɛnna Zesu ‑din, 'bhɛɛ‑ ‑woo 'trɔnkpale ‑saan ‑a wojan mu 'ɛ ꞊la. ");
INSERT INTO moa_vpl VALUES ("LK15_2","072_15_2","LUK","15","2","2","‑Ayile, 'ke Farizi mu 'ɛ 'pegee 'Toŋ daan mu 'ɛ ‑woo zrupliile', 'bhɛɛ‑ 'ke ‑wa pele‑ 'eke‑ ni dɔɔ: «‑Kaa ‑glin doo, mɛɛ 'lɛɛ‑ ‑e dɔ ‑a ‑la 'ke mɛɛ 'joo 'yɔɔ‑ mu 'ɛ nu yaalɛ ‑a ‑din a ma, 'bhɛɛ‑ ‑o 'pegee 'mu pɛbhle 'eke‑ zi.» ");
INSERT INTO moa_vpl VALUES ("LK15_3","072_15_3","LUK","15","3","3","Zesu 'trɔnbɔle 'bhɛ ‑jan 'ɛ 'yi, 'kee‑ ‑gɔɔn 'lɛɛ‑ 'bhɛ bɔle‑ ‑o ni dɔɔ: ");
INSERT INTO moa_vpl VALUES ("LK15_4","072_15_4","LUK","15","4","4","«'Ke ‑bhlaa ‑kɛmɛ do ‑o 'ka do 'kɔɔ, 'bhɛɛ‑ 'ke ‑a do ꞊nia ‑o ba, yaa nu ‑o ‑vin mia yiziɛ bhɛ vu ta 'srwayiziɛ 'ɛ 'tolɛ‑ ‑a ‑zanta' ‑bɔn 'yi ‑bɔn 'bhlele‑ ma, 'bhɛɛ‑ ‑e ge ‑a do 'la 'bhɛ ꞊nia 'bhɛ ziglinyrɛ nɔɔ‑ 'sani‑ ‑ya ye ɛɛ? ");
INSERT INTO moa_vpl VALUES ("LK15_5","072_15_5","LUK","15","5","5","'Ke ‑ya ꞊ya, ‑a zrukpaa' gbɛ ‑yɔɔ 'ɛ 'kɔɔ, ‑ya kpa ‑a bhlɔ ta. ");
INSERT INTO moa_vpl VALUES ("LK15_6","072_15_6","LUK","15","6","6","'Bhɛɛ‑ 'kee‑ ꞊nwa 'kɛle‑ 'fɛ 'lɛ ma, ‑ya bhɛgwlɛn mu 'ɛ sii 'bhɛ ‑ya pe 'mu ni dɔɔ: ‹‑Ka nu 'bhɛɛ‑ ‑kɔɔ' 'ŋ zrukpaa' maza 'ɛ 'yiciɛn‑ 'eke‑ zi! ‑Amasrɔyi 'an ‑bhlaa 'lɛɛ‑ ꞊nia bi 'bhɛɛ‑ 'an 'ye gbɛ drɛɛwoa‑.›» ");
INSERT INTO moa_vpl VALUES ("LK15_7","072_15_7","LUK","15","7","7","Zesu pe ‑o ni dɔɔ: «'Bhɛ klɛgbɛya do 'ɛ 'yi, 'ke ‑za 'yɔɔ‑ klɛ mi do 'kpɔ 'ploola‑ ‑za 'yɔɔ‑ klɛle ma, 'bhɛɛ‑ 'ke ‑ya 'gbu ꞊naa ‑Waanbhaa' ni, zrukpaa' ‑gbɛnɛ nu klɛlɛ laflɛ' 'yi ‑Waanbhaa' ba 'bhɛ ‑zayi'; 'yee‑ do ‑kplɛn a zrukpaa' 'ɛ 'bhɛ ‑gbɛnɛ 'yi nu yalɛ 'ke 'bhɛ kan mɛɛ ‑lɛdɔɔle mia yiziɛ bhɛ vu ta 'srwayiziɛ 'la 'ke 'mu laa 'ploolɛ‑ 'mu a ‑za 'yɔɔ‑ mu 'ɛ ma, 'bhɛɛ‑ waa ‑o 'gbu 'nalɛ‑ ‑Waanbhaa' ni 'mu ta.» ");
INSERT INTO moa_vpl VALUES ("LK15_8","072_15_8","LUK","15","8","8","Zesu pe 'ezin‑ dɔɔ: «'Bhɛɛ‑ 'ke ‑gɔli' 'taŋbha vu ‑o le do 'kɔɔ, 'bhɛɛ‑ 'ke ‑a do 'kpɔ ꞊nia ‑a 'kɔɔ 'fɛ 'ɛ ꞊la, yaa ‑za 'lɛɛ‑ 'bhɛɛ‑ klɛ ɛɛ? 'Ŋ bhe ‑e ‑yaa' ‑laŋbha 'ɛ bhi, 'bhɛɛ‑ ‑e 'fɛ 'ɛ ꞊la go ‑maa 'le 'elrele, 'sani‑ ‑ya ye. ");
INSERT INTO moa_vpl VALUES ("LK15_9","072_15_9","LUK","15","9","9","'Ke ‑ya ꞊ya bhla 'la ba, ‑ya bhɛle mu 'ɛ 'pegee ‑a ‑din mu 'ɛ 'kpɛn sii, 'bhɛɛ‑ ‑ya pe 'mu ni dɔɔ: ‹‑Ka nu 'bhɛɛ‑ ‑kɔɔ' 'ŋ zrukpaa' maza 'ɛ 'yiciɛn‑ 'eke‑ zi! ‑Amasrɔyi 'an 'taŋbha do 'lɛɛ‑ ‑e ꞊nia bi, 'bhɛɛ‑ 'an ye gbɛ drɛɛwoa‑ 'ezin‑!› ");
INSERT INTO moa_vpl VALUES ("LK15_10","072_15_10","LUK","15","10","10","'Bhɛ klɛgbɛya do 'ɛ 'yi, 'mi pe 'ka ni dɔɔ ‑Waanbhaa' a ‑mlɛkɛ' mu 'ɛ zrukpaale nu klɛlɛ 'egbɛnɛle, 'ke ‑za 'yɔɔ klɛ mi do 'kpɔ 'ploola‑ ‑za 'yɔɔ klɛle ma, 'bhɛɛ‑ 'ke ‑ya 'gbu ꞊naa ‑Waanbhaa' ni.» ");
INSERT INTO moa_vpl VALUES ("LK15_11","072_15_11","LUK","15","11","11","Zesu pe 'ezin‑ dɔɔ: «Mɛɛ do gbe ‑yaa plɛ. ");
INSERT INTO moa_vpl VALUES ("LK15_12","072_15_12","LUK","15","12","12","‑Yrekpaa' do, ‑nwagwlɛn' mi 'ɛ pe ‑a dɛ 'ɛ ni dɔɔ: ‹'Ŋ dɛ, 'yaa‑ ‑naflo 'ɛ ‑yiciɛn' 'o ma, 'bhɛɛ‑ 'ye 'an pɛ 'ciɛn 'na.› 'Bhɛla‑ ‑yile 'ke ‑o dɛ 'bhɛ a ‑naflo 'ɛ 'yiciɛnle ‑o mɛɛ plɛ ‑kpɛn ma. ");
INSERT INTO moa_vpl VALUES ("LK15_13","072_15_13","LUK","15","13","13","'Waati sa 'kanle‑ blaan, 'ke 'yee‑ ‑nwagwlɛn' mi 'ɛ ‑e ‑yaa' pɛ 'ciɛn 'ɛ 'kpɛn gɔnle‑. 'Bhɛɛ‑ ‑e 'bhɛ ma ‑gɔli' 'ɛ ꞊sia, 'kee‑ gele‑ 'klɛɛn gbɔɔn do ‑yi. ‑E ‑yaa' ‑gɔli' 'ɛ 'kpɛn 'siɛla‑ le mu ta 'bhɛ 'klɛɛn 'ɛ 'yi. ");
INSERT INTO moa_vpl VALUES ("LK15_14","072_15_14","LUK","15","14","14","‑E ‑yaan ‑a 'ciɛn 'ɛ 'kpɛn 'siɛlele bhla 'la ba, 'ke ‑gu ‑gbɛnɛ do dɔle‑ 'bhɛ 'klɛɛn 'yi mu 'ɛ ta. 'Bhɛɛ‑ ‑a ‑yrɛbatɛdɔle ‑saan. ");
INSERT INTO moa_vpl VALUES ("LK15_15","072_15_15","LUK","15","15","15","'Bhɛla‑ ‑yile, ‑e ‑ja ‑kɔntran' 'kanlɛ‑ 'yee 'klɛɛn 'ɛ 'yi mɛɛ do ba. 'Bhɛ mɛɛ 'ɛ 'bhɛ pe a ni 'kaa ‑ya ‑yrɛkpa' 'bhɛ a ꞊swa mu 'ɛ ba. ");
INSERT INTO moa_vpl VALUES ("LK15_16","072_15_16","LUK","15","16","16","‑E ‑yaa zi 'bhii‑ ‑wa gba ꞊swa mu 'ɛ 'le pɛbhle 'ɛ 'ke ba, 'duŋ‑ waa ‑a gbalɛ 'bhɛ 'kedo‑ 'kpɔ ba. ");
INSERT INTO moa_vpl VALUES ("LK15_17","072_15_17","LUK","15","17","17","'Bhɛla‑ ‑yile, 'ke ‑ya 'kpeelɛdanle 'sanle ‑a 'gbu 'si 'ɛ ma, 'bhɛɛ‑ 'ke ‑ya pele‑ dɔɔ: ‹'Ŋ dɛ a yewonɛ mu 'ɛ ‑o le pɛbhle mu 'ɛ waa ‑o sa, 'bhɛɛ‑ 'mi ‑o ga 'zi ‑gɛ gbɔn 'kɔɔ! ");
INSERT INTO moa_vpl VALUES ("LK15_18","072_15_18","LUK","15","18","18","'Kee‑ ꞊kla, 'ŋ nu gelɛ 'ŋ ‑zanta' 'ŋ dɛ ba, 'bhɛɛ‑ 'ŋ nu ‑a pelɛ ‑a ni dɔɔ: 'Ŋ dɛ, 'ŋ ‑za 'yɔɔ‑ ꞊kla 'bhi 'pegee ‑Waanbhaa' ni. ");
INSERT INTO moa_vpl VALUES ("LK15_19","072_15_19","LUK","15","19","19","'Bhɛ ‑gaale' laa ‑o 'ŋ ba 'ke 'ye 'ŋ kun 'ezin‑ 'bhii‑ 'e gbe do. 'Ŋ 'kun 'bhii‑ 'yaa‑ yewonɛ mu 'ɛ do gbɛɛn‑.› ");
INSERT INTO moa_vpl VALUES ("LK15_20","072_15_20","LUK","15","20","20","'Bhɛ klɛle 'tɛ, 'kee‑ nule‑ ‑a dɛ ba. ‑A dɛ ‑yrɛkpale ‑a ma 'egbɔɔnle, 'ke ‑a ‑yrɛnklale 'bhɛ ma 'eyɔɔle. 'Bhɛla‑ ‑zayile, 'ke 'bhɛ gele‑ ‑a ‑lɛpalɛ blaale‑, 'bhɛɛ‑ 'ke 'bhɛ 'a ‑tuubɔle. ");
INSERT INTO moa_vpl VALUES ("LK15_21","072_15_21","LUK","15","21","21","'Bhɛɛ‑ ‑e pe ‑a dɛ ni dɔɔ: ‹'Ŋ dɛ, 'ŋ ‑za 'yɔɔ‑ ꞊kla 'bhi 'pegee ‑Waanbhaa' ni, 'bhɛla‑ ‑yile, 'yaa 'ŋ 'kunlɛ‑ 'ezin‑ 'bhii‑ 'e gbe.› ");
INSERT INTO moa_vpl VALUES ("LK15_22","072_15_22","LUK","15","22","22","'Duŋ‑ ‑a dɛ pe 'bhɛ a yewonɛ mu 'ɛ ni dɔɔ: ‹‑Ka nu blaale‑ dunɛ‑ gbɔɔn 'la 'bhɛ 'lrele‑ ‑yiya' dunɛ‑ mu 'ɛ 'kpɛn ni 'bhɛ 'le, 'bhɛɛ‑ ‑ka 'bhɛ 'kla 'a ta. ‑Ka gbɛ ma piibhɛnɛ do bɔ ‑a gbɛ ‑nɛbhɛ' 'ɛ ma, 'bhɛɛ‑ ‑ka ‑sawla 'wla ‑a gaan ma. ");
INSERT INTO moa_vpl VALUES ("LK15_23","072_15_23","LUK","15","23","23","‑Ka ge dri ‑nɛ blaale 'ɛ 'kun, 'bhɛɛ‑ 'kaa dɛ; 'bhɛɛ‑ ‑kɔɔ' 'a bhle. 'Bhɛ blaan, ‑kɔɔ' ‑zabla' ‑kɔɔ' zrukpaa' ta. ");
INSERT INTO moa_vpl VALUES ("LK15_24","072_15_24","LUK","15","24","24","‑Amasrɔyi, 'ŋ 'nɛ 'la 'yele‑ ‑gɛ bhe, ‑e ‑gaa bi, 'bhɛɛ‑ ‑e ‑bwela gale ba ‑zɔn; ‑e ꞊nia bi, 'bhɛɛ‑ 'wa 'ye gbɛ drɛɛwoa‑ ‑zɔn.› 'Bhɛla‑ ‑yile ‑woo zrukpaa' ma ‑zablale ‑saan.» ");
INSERT INTO moa_vpl VALUES ("LK15_25","072_15_25","LUK","15","25","25","«'Bhɛ 'waati 'ɛ ba, 'yee‑ mɛɛ 'ɛ gbe ‑lwa mi 'ɛ 'yaa‑ gba la. 'Bhɛ da bhla 'ɛ zi gba 'ɛ ta, 'bhɛɛ‑ 'bhɛ bhɔlawoa ‑waa' 'fɛ 'ɛ ‑din, 'ke 'bhɛ 'srokpawli mu 'pegee 'srotanwli mu male‑. ");
INSERT INTO moa_vpl VALUES ("LK15_26","072_15_26","LUK","15","26","26","'Bhɛ klɛle 'tɛ, 'ke 'bhɛ yewonɛ mu 'ɛ do 'siile, 'bhɛɛ‑ 'kee‑ 'fɛ 'lɛ maza ‑yilrɔkpale 'bhɛ ma. ");
INSERT INTO moa_vpl VALUES ("LK15_27","072_15_27","LUK","15","27","27","'Bhɛ yewonɛ 'ɛ pe ‑a ni dɔɔ: ‹'E 'nwagwlɛn‑ 'la ‑ja 'drunyan zi, ‑e ꞊nwa ‑zɔn. ‑Ayile 'e dɛ pe dɔɔ ‑o dri ‑nɛ blaale 'ɛ dɛ ‑a ni. ‑Amasrɔyi ‑a gbe 'ɛ ꞊nwa ‑a ba 'edɔɔle.› ");
INSERT INTO moa_vpl VALUES ("LK15_28","072_15_28","LUK","15","28","28","'Bhɛ klɛle 'tɛ, 'ke ‑ya zrupliile, 'bhɛɛ‑ 'ke ‑ya pele‑ dɔɔ yaa ‑o gele‑ ‑o ba ‑lɛ ma. 'Bhɛla‑ ‑yile 'ke a dɛ 'pwɛle, 'ke 'bhɛ gele‑ ‑sromabɔlɛ ‑a ni. ");
INSERT INTO moa_vpl VALUES ("LK15_29","072_15_29","LUK","15","29","29","'Bhɛɛ‑ 'ke ‑ya pele‑ ‑a dɛ ni dɔɔ: ‹'E 'trɔnkpa 'ŋ ni doo, ‑zɔn 'laa 'ŋ 'sanlɛ‑ 'ke 'ŋ yewo 'e ni yi 'oo yi, 'bhɛ 'pegee 'mi 'taawoa꞊ 'taŋii 'e 'wojan‑ mu 'ɛ 'kpɛn ta. 'Bhɛɛ‑ 'duŋ‑ 'yaa bhoonɛ‑ do 'kpɔ 'nalɛ‑ ‑lido' 'mi ni 'ke 'mi 'pegee 'ŋ 'bhɛgwlɛn‑ mu 'ɛ 'o sɔ ‑zablale 'o zrukpaa' ta 'eke‑ zi. ");
INSERT INTO moa_vpl VALUES ("LK15_30","072_15_30","LUK","15","30","30","'Bhɛɛ‑ 'duŋ‑, 'e gbe mɛɛ kloo 'lɛɛ‑, 'bhɛ ‑ja 'yaa‑ ‑naflo 'ɛ 'kpɛn 'siɛlɛ‑ gwlɛn ‑wɛɛ le mu 'ɛ ta, 'bhɛɛ‑ ‑e nulawoa ‑zɔn, 'e dri ‑nɛ blaale ‑gbɛnɛ 'ɛ ꞊dia ‑a ni.› ");
INSERT INTO moa_vpl VALUES ("LK15_31","072_15_31","LUK","15","31","31","'Bhɛla‑ ‑yile, 'ke ‑a dɛ 'a 'pele 'a ni dɔɔ: ‹'Ŋ 'nɛ, 'bhi ‑o 'ŋ ‑din yikpɛnsee ta, 'ŋ 'kɔɔpɛ‑ 'tɔle‑ 'kɔɔpɛ‑ 'yaa‑ pɛ ‑le 'mu 'kpɛn 'le. ");
INSERT INTO moa_vpl VALUES ("LK15_32","072_15_32","LUK","15","32","32","'Duŋ‑, ‑kɔɔ' ‑kɔɔ' 'yinra‑, 'bhɛɛ‑ ‑kɔɔ' ‑zabla' zrukpaa' ta; ‑amasrɔyi 'e 'nwagwlɛn‑ 'lɛɛ‑ 'yaa‑ 'bhii‑ ‑e ‑gaa, 'bhɛɛ‑ ‑e ‑bwela gale ba. ‑E ꞊nia bi 'bhɛɛ‑ 'wa 'ye gbɛ drɛɛwoa‑.›» ");
INSERT INTO moa_vpl VALUES ("LK16_1","072_16_1","LUK","16","1","1","Zesu pe 'ezin‑ ‑yaa' ‑klaŋlanɛ mu 'ɛ ni dɔɔ: «Pɛzan do ‑yaa, 'bhɛɛ‑ ‑gɔli' magaan mi do ‑yaa ‑a 'kɔɔ. Yi do ta, ‑o ꞊nwa ‑yaa' ‑gɔli' magaan mi 'ɛ ꞊lwa 'wlalɛ‑ ‑a 'kɔɔ dɔɔ 'bhɛ ‑yaa' ‑gɔli' 'ɛ 'siɛ zii'. ");
INSERT INTO moa_vpl VALUES ("LK16_2","072_16_2","LUK","16","2","2","‑Ayile, 'kee‑ yaa ‑gɔli' magaan mi 'ɛ 'siile, 'bhɛɛ‑ 'kee‑ 'bhɛ ‑lrɔkpale dɔɔ: ‹'Mi 'e ma jan do ‑maa. 'Mi 'a ꞊maa dɔɔ 'yaa 'an ‑gɔli' 'ɛ 'siɛla‑; 'bhɛla‑ ‑zɛɛle 'ye 'an ‑gɔli' 'ɛ ꞊kla 'ke pɛ 'oo pɛ 'la 'le, nu 'bhɛ 'yipe 'ŋ ni, 'bhɛɛ‑ 'e jila. ‑Amasrɔyi 'yaa nu klɛlɛ ‑li 'an ‑gɔli' 'ɛ magaan mi 'le.› ");
INSERT INTO moa_vpl VALUES ("LK16_3","072_16_3","LUK","16","3","3","'Bhɛ klɛle 'tɛ, 'ke ‑ya pele‑ ‑a 'gbu 'kpee dɔɔ: ‹'Ŋ zan ‑o zan 'ŋ ‑gbinlawolɛ 'an ye 'ɛ ta bhe, 'ŋ sɔ ‑a klɛle‑ 'nale‑ ‑a ma ɛɛ? Gba la yewo faŋgan‑ 'laa ‑o 'ŋ ta, 'bhɛɛ‑ 'naa sɔ 'ŋ 'yrɛwole mɛɛ mu ma, ‑yrala' 'ɛ 'kɔɔ.› ");
INSERT INTO moa_vpl VALUES ("LK16_4","072_16_4","LUK","16","4","4","'Bhɛ 'yi, 'ke ‑za do dɔle‑ ‑a 'kpee, 'bhɛɛ‑ 'ke ‑ya pele‑ dɔɔ: ‹'Ŋ nu ‑za do klɛlɛ 'kooko‑ 'ke 'ŋ zan 'ŋ ‑gbian 'an ye 'ɛ ta, mɛɛ 'ke mu sɔ 'ŋ 'sile 'mu ba.› ");
INSERT INTO moa_vpl VALUES ("LK16_5","072_16_5","LUK","16","5","5","'Bhɛla‑ ‑yile, ‑a zan a ca mu ‑yaa mɛɛ 'la zan mu ma, 'kee‑ 'mu 'kpɛn 'siile do do ‑a ba. 'Bhɛɛ‑ 'ke ‑ya ‑lwa mi 'ɛ 'bhɛ 'lrɔkpale dɔɔ: ‹'Ŋ zan a ca ‑wɛɛ' ‑le 'e ma ɛɛ?› ");
INSERT INTO moa_vpl VALUES ("LK16_6","072_16_6","LUK","16","6","6","'Bhɛ pe ‑a ni dɔɔ: ‹‑Yrɔn 'gboŋgbo 'yan ‑kɛmɛ do.› 'Bhɛ klɛle 'tɛ, 'ke ‑gɔli' magaan mi 'ɛ ‑ya pele‑ 'bhɛ ni dɔɔ: ‹Yala‑ ‑gɛ blaale‑ doo, 'yaa‑ 'sɛwɛ 'ɛ 'si, 'bhɛɛ‑ ‑a yɔɔndɛ ‑yrɔn 'gboŋgbo mia plɛ bhɛ vu.› ");
INSERT INTO moa_vpl VALUES ("LK16_7","072_16_7","LUK","16","7","7","'Bhɛ blaan, 'ke 'yee‑ ‑gɔli' magaan mi 'ɛ ‑e mɛɛ ‑bhɛɛke' ‑lrɔkpale 'ezin‑ dɔɔ: ‹'Bhɛɛ‑ 'bhi 'lɛɛ‑, 'ŋ zan a ca ‑wɛɛ' ‑le 'bhi ma ɛɛ?› 'Bhɛ pe ‑a ni dɔɔ: ‹'An pɛ ca 'ɛ ‑yoo pɛbhɛ ‑bɔtɔ ‑kɛmɛ do.› 'Bhɛ klɛle 'tɛ 'ke 'yee‑ ‑gɔli' magaan mi 'ɛ ‑ya pele‑ 'bhɛ ni dɔɔ: ‹Yala‑ ‑gɛ blaale‑, 'yaa‑ 'sɛwɛ 'ɛ 'si, 'bhɛɛ‑ ‑a yɔɔndɛ mia yiziɛ.› ");
INSERT INTO moa_vpl VALUES ("LK16_8","072_16_8","LUK","16","8","8","'Bhɛ blaan, 'yee‑ ‑gɔli' magaan mi 'la bakanle laa ‑yaa, ‑a zan 'ɛ 'bhɛ 'a 'tɔ 'wlan ꞊pia ‑yaa' ‑dawliya 'ɛ ma.» 'Bhɛ blaan, 'ke Zesu 'a 'pele dɔɔ: «'Drunyan ta mɛɛ mu 'lɛɛ‑ ‑woo 'eke‑ 'kungbɛya dɔ ‑waa' ‑za mu 'ɛ 'yi, 'ke 'bhɛ kan ‑Waanbhaa' a pɛ mɛɛ mu 'la 'taawo zii' 'tɛbhile ba 'mu ta.» ");
INSERT INTO moa_vpl VALUES ("LK16_9","072_16_9","LUK","16","9","9","Zesu pe ‑yaa' ‑klaŋlanɛ mu 'ɛ ni dɔɔ: «'Mi pe 'ka ni dɔɔ 'ke 'ka 'drunyan ta ‑dawli' ma ‑naflo mu 'ɛ ꞊sia, 'bhɛɛ‑ 'ka ꞊bhwa mɛɛ mu ba 'kɛle‑, 'bhɛɛ‑ 'ke 'ka bhɛgwlɛnya ‑glinna 'kɛle‑, 'ke 'kaa pɛ 'trɛ ta 'ɛ ꞊yaan yi 'la ta, 'ka sɔ ‑bheele' ‑o ma ‑Waanbhaa' a ‑wa 'la 'ke ‑daŋ' 'laa ‑o 'bhɛ ma 'bhɛ ꞊nɔɔ. ");
INSERT INTO moa_vpl VALUES ("LK16_10","072_16_10","LUK","16","10","10","'Ke mɛɛ 'la zan zru ‑o do ‑za 'fiɛntrɔnnɛ mu 'yi, 'bhɛ zan zru nu klɛlɛ do ‑za ‑gbɛnɛ klɛle‑ 'yi 'ezin‑. 'Duŋ‑ 'ke mɛɛ 'la zan ‑lɛdɔɔle laa ‑o ‑za 'fiɛntrɔnnɛ mu 'yi, 'bhɛ zan 'ɛ ‑lɛdɔɔle laa ‑o ‑za ‑gbɛnɛ mu 'yi 'ezin‑. ");
INSERT INTO moa_vpl VALUES ("LK16_11","072_16_11","LUK","16","11","11","'Duŋ‑ 'ke 'ka 'lɛdɔɔle laa klɛlɛ 'drunyan 'lɛɛ‑ ta ‑dawli' ma ‑naflo ma mu 'kungbɛya 'ɛ ma, ‑dele nu 'sɔlɛ‑ 'bhɛ 'kpale 'ka 'yi, 'bhɛɛ‑ ‑e ‑naflo ‑zeze mu gbɛkpa 'ka 'kɔɔ ɛɛ? ");
INSERT INTO moa_vpl VALUES ("LK16_12","072_16_12","LUK","16","12","12","'Bhɛɛ‑ 'ke 'ka zru laa ‑o do 'ka ‑vindo' mi a ‑za ma, 'ka 'gbu a pɛ ‑o 'kɛla 'le, ‑dele nu 'sɔlɛ‑ 'bhɛ gbɛkpale 'ka 'kɔɔ ɛɛ?» ");
INSERT INTO moa_vpl VALUES ("LK16_13","072_16_13","LUK","16","13","13","«Mɛɛ do laa sɔ yewole ‑kuŋlii plɛ ni 'eke‑ ma. 'Kee‑ 'bhɛ ꞊kla, ‑a do vɛn nu 'silɛ‑ ‑a yin 'lii, 'bhɛɛ‑ ‑a ‑bhɛɛke' do 'ɛ ‑za sɔ a ni. 'Ke ‑a lii biile ꞊bwa ‑a do 'yi, ‑e nu ‑a ‑bhɛɛke' do 'ɛ mavɛɛlɛ. 'Bhɛ ya 'ɛ 'yi, 'ka 'laa sɔ klɛle‑ ‑Waanbhaa' a lu 'le, 'bhɛɛ‑ 'ka klɛ ‑gɔli' a lu 'le 'ezin‑.» ");
INSERT INTO moa_vpl VALUES ("LK16_14","072_16_14","LUK","16","14","14","Farizi mu 'la 'yaa‑ ‑o 'trɔnkpa zii' Zesu 'wojan‑ mu 'ɛ ꞊la, ‑o ‑yaa Zesu malrɔgo 'zi, ‑waa' ‑gɔli' 'flɛnya‑ 'ɛ ma. ");
INSERT INTO moa_vpl VALUES ("LK16_15","072_16_15","LUK","16","15","15","'Bhɛ klɛle 'tɛ, 'ke Zesu 'a 'pele ‑o ni dɔɔ: «'Ka mu, 'ka 'ka 'gbu klɛ mɛɛ ‑lɛdɔɔle mu 'le mɛɛ mu ‑yrɛ ta. 'Duŋ‑ ‑Waanbhaa' 'ka zru mu 'ɛ dɔ. 'Bhɛɛ‑ ‑za 'la 'bhɛ ‑o mɛɛ mu ‑yrɛ 'yi ‑za ‑gbɛnɛ 'le, 'bhɛ ‑la vɛnsi ‑Waanbhaa' yin 'lii.» ");
INSERT INTO moa_vpl VALUES ("LK16_16","072_16_16","LUK","16","16","16","«Moizi a 'toŋ 'ɛ 'pegee ‑Waanbhaa' a ‑lɛla' janwo mu 'ɛ ‑waa 'sɛwɛ mu 'ɛ 'seŋ ‑daŋ' ‑le Mɛɛ Wiiŋfɛ' Mi Zaan a pɛ 'waati 'bhɛɛ‑ 'le. ‑A 'san Mɛɛ Wiiŋfɛ' Mi Zaan 'nu yi 'ɛ ma, ‑o ‑Waanbhaa' a ‑Jan 'Nrale 'ɛ 'wo zii', 'bhɛɛ‑ mɔkpɛn' ‑o dɔ 'zi 'eglɔɔle 'ke ‑o wla ‑yaa' ‑bhleŋgbeya ‑wa 'ɛ ta. ");
INSERT INTO moa_vpl VALUES ("LK16_17","072_16_17","LUK","16","17","17","'Duŋ‑ laflɛ' 'pegee 'trɛ nu 'kanlɛ‑, 'duŋ‑ ‑Waanbhaa' 'a 'toŋ 'ɛ gɔ 'fiɛntrɔnnɛ do 'kpɔ 'laa nu 'sɔlɛ‑ gole‑ ‑a ba ‑titi.» ");
INSERT INTO moa_vpl VALUES ("LK16_18","072_16_18","LUK","16","18","18","«'Bhɛɛ‑ 'ezin‑, 'ke mɛɛ 'oo mɛɛ 'la zan ‑ploola 'bhɛ 'na 'ɛ ma, 'bhɛɛ‑ 'kee‑ le ‑bhɛɛke' 'yalaa‑, ‑e ‑yanbhɔɔya ‑la ꞊kla 'bhɛ 'le bhe. 'Bhɛɛ‑ 'ke mɛɛ 'la zan le 'la 'ke 'bhɛ ꞊nɔɔ ‑ploola 'bhɛ ma 'bhɛ 'yalaa‑, 'bhɛ zan 'ɛ 'bhɛ ‑yanbhɔɔya ‑la ꞊kla 'bhɛ 'le bhe 'ezin‑.» ");
INSERT INTO moa_vpl VALUES ("LK16_19","072_16_19","LUK","16","19","19","'Bhɛ blaan, 'ke Zesu 'a 'pele dɔɔ: «'Elwale ‑sɔ, ‑naflo zan do ‑yaa; ‑e ‑yaa dunɛ‑ 'plɛɛle‑ ‑lrele' mu ‑la kla ‑a ta. Yi 'oo yi, ‑trɔn maza ‑le ‑yaa sɔ ‑a ni, 'bhɛ 'pegee pɛbhle ‑lrele' ‑yaa sɔ ‑a ni. ");
INSERT INTO moa_vpl VALUES ("LK16_20","072_16_20","LUK","16","20","20","'Bhɛɛ‑ ‑o ‑yaa 'kɔɔfleŋzan do sii Lazaa. Bhɛ mu ‑yaa ‑a 'flɛ 'ɛ ma, 'bhɛɛ‑ ‑a yilale ‑yaa ‑naflo zan 'ɛ ‑yaa 'fɛ 'ɛ 'lɛ ma. ");
INSERT INTO moa_vpl VALUES ("LK16_21","072_16_21","LUK","16","21","21","'Ke pɛle piinɛ‑ mu 'la 'yaa‑ balaa' ‑naflo zan 'ɛ ‑yaa ‑tabali 'ɛ ꞊la, 'yee‑ Lazaa ‑yaa 'mu ‑la bhle. 'Bhɛɛ‑ ‑gbaan' mu ‑yaa ‑yaa' bhɛ mu 'ɛ 'liiplaa‑. ");
INSERT INTO moa_vpl VALUES ("LK16_22","072_16_22","LUK","16","22","22","'Bhɛ ya 'ɛ 'yi 'tɛ, 'ke Lazaa klɛle‑ 'ke siɛle', 'bhɛɛ‑ 'ke ‑Waanbhaa' a ‑mlɛkɛ' mu 'ɛ gele‑ ‑a lii 'ɛ 'le Abraamu ‑din laflɛ' 'yi. 'Bhɛ blaan, 'ke 'yee‑ ‑naflo zan 'ɛ klɛle‑ 'ke siɛle' 'ezin‑, 'bhɛɛ‑ 'ke ‑wa binle‑. ");
INSERT INTO moa_vpl VALUES ("LK16_23","072_16_23","LUK","16","23","23","'Duŋ‑ 'yee‑ ‑naflo zan 'ɛ binle blaan, ‑e ‑yaa ‑yrɛnbhle' zii' 'ebebele gbaa mu a ‑wa 'ɛ ta. ‑Ya ŋgblo ‑lawlɛnle 'ke ‑a ‑yrɛkpale Abraamu ma 'egbɔɔnle laanima. Lazaa ‑yaa 'bhɛ ‑din. ");
INSERT INTO moa_vpl VALUES ("LK16_24","072_16_24","LUK","16","24","24","'Bhɛ klɛle 'tɛ, 'kee‑ ‑gbekanle 'eglɔɔle, 'ke ‑ya pele‑ dɔɔ: ‹'Ŋ ‑gbɔɔ Abraamu, 'ŋ 'yrɛnkla 'e ma, ‑a pe Lazaa ni dɔɔ ‑ya gbɛ ‑nɛbhɛ' do ꞊zwan ‑yi ba, 'bhɛɛ‑ ‑e nu 'ŋ blina‑ 'ɛ 'twalɛ‑ 'ke 'bhɛ 'le, ‑amasrɔyi 'ŋ 'yoo‑ ‑yrɛn 'yɔɔ‑ bhle 'zi 'tɛ 'lɛɛ‑ 'yi ‑gɛ.› ");
INSERT INTO moa_vpl VALUES ("LK16_25","072_16_25","LUK","16","25","25","'Duŋ‑ Abraamu pe ‑a ni dɔɔ: ‹'Ŋ 'nɛ, 'bhɛ ‑za 'ɛ 'bhɛ 'laa ‑o ‑li 'e 'kpee ɛɛ, 'e 'yaa‑ 'e 'yrɛ ma 'waati 'la ba, 'e pɛ ‑bebe 'srɔɔwoa‑, 'bhɛɛ‑ Lazaa ‑yrɛnbhla 'ebebele 'bhɛ 'waati 'ɛ ba. ‑E ꞊nwa ‑a zrukpaa' yrɛ ‑la nɔɔ‑ ‑zɔn ‑gɛ, 'bhɛɛ‑ 'bhi ‑o ‑yrɛnbhle' zii'. ");
INSERT INTO moa_vpl VALUES ("LK16_26","072_16_26","LUK","16","26","26","'Bhɛɛ‑ 'duŋ‑, ‑gluu 'trole‑ ‑gbɛnɛ do ‑o 'o mɔɔ 'pegee 'ka mu pleŋ‑; ‑asiikɔɔ 'ke mɛɛ 'la zan 'a ꞊pia‑ dɔɔ 'bhɛ ‑o gole‑ 'o ba, 'bhɛɛ 'bhɛ ge 'ka ba laale, 'bhɛ zan laa sɔ 'bhɛ klɛle‑. 'Bhɛɛ‑ 'bhɛ klɛgbɛya do 'kpɔ 'ɛ 'yi, 'ke mɛɛ 'la zan 'a ꞊pia dɔɔ 'bhɛ ‑o gole‑ 'ka ba ye, 'bhɛɛ‑ 'bhɛ nu 'o ba ‑gɛ, 'bhɛ zan laa sɔ.› ");
INSERT INTO moa_vpl VALUES ("LK16_27","072_16_27","LUK","16","27","27","'Bhɛɛ‑ 'yee‑ ‑naflo zan 'ɛ pe dɔɔ: ‹'Ke ‑yoo 'bhɛ gbɛɛn‑ bhe, 'e 'zoole‑ 'ŋ ‑gbɔɔ Abraamu, Lazaa 'winbɔ‑ 'drunyan ta 'ŋ dɛ a 'fɛ 'ɛ ꞊la. ");
INSERT INTO moa_vpl VALUES ("LK16_28","072_16_28","LUK","16","28","28","'Ŋ nɛɛnɛ‑ 'soo ‑o 'bhɛ ꞊nɔɔ ye, ‑e ge ‑o 'kpeelɛkan, 'bhɛɛ‑ ‑ya pe ‑o ni dɔɔ waa nulɛ 'ŋ 'yoo‑ ‑yrɛnbhle' zii' yrɛ 'la ꞊nɔɔ ‑gɛ 'bhɛ ꞊nɔɔ.› ");
INSERT INTO moa_vpl VALUES ("LK16_29","072_16_29","LUK","16","29","29","Abraamu pe ‑a ni dɔɔ: ‹*Moizi 'pegee ‑Waanbhaa' ‑lɛla' janwo mu 'ɛ ‑woo ‑o ‑din ye. 'Bhɛ mu sɔ ‑o 'kpeelɛkanle, ‑woo 'trɔnkpa 'mu 'wojan‑ mu 'ɛ ꞊la.› ");
INSERT INTO moa_vpl VALUES ("LK16_30","072_16_30","LUK","16","30","30","'Duŋ‑ 'yee ‑naflo zan 'ɛ pe Abraamu ni dɔɔ: ‹'Ŋ ‑gbɔɔ Abraamu, 'bhɛ 'laa 'a 'yibhɔ‑. 'Duŋ‑ 'ke mɛɛ do ‑bwela gale ba, 'bhɛɛ‑ 'ke 'bhɛ ‑ja ‑o ta ye, ‑o 'kpeelɛkan zayi', ‑o nu 'ploolɛ‑ ‑waa' 'taawogbɛya 'yɔɔ‑ mu 'ɛ ma, 'bhɛɛ‑ ‑o 'taawo‑ ‑Waanbhaa' a zru maza 'ɛ ta 'tɛ.› ");
INSERT INTO moa_vpl VALUES ("LK16_31","072_16_31","LUK","16","31","31","Abraamu pe ‑a ni dɔɔ: ‹'Ke waa dɔ ‑a ‑la 'ke ‑woo 'trɔnkpa Moizi a 'toŋ mu 'ɛ 'pegee ‑Waanbhaa' *‑lɛla' janwo mu 'ɛ 'mu 'wojan‑ mu 'ɛ ‑la, 'ali‑ 'ke mɛɛ do ‑bwela gale ba, 'waa nu dɔlɛ ‑a ꞊la 'sekeseke 'ke ‑woo kpa 'bhɛ zan 'ɛ 'wojan‑ 'ɛ 'yi.›» ");
INSERT INTO moa_vpl VALUES ("LK17_1","072_17_1","LUK","17","1","1","Zesu pe ‑yaa' ‑klaŋlanɛ mu 'ɛ ni dɔɔ: «'Waati 'ɛ 'kpɛn ba, bhaaplɛŋ mu bala‑ pɛ mu ‑o ‑za 'yɔɔ‑ 'yi. 'Duŋ‑ 'ke mɛɛ 'la zan ꞊kla bhaaplɛŋ mu bala‑ pɛ 'le ‑za 'yɔɔ‑ 'yi, 'bhɛ zan ta ‑yrɛn! ");
INSERT INTO moa_vpl VALUES ("LK17_2","072_17_2","LUK","17","2","2","'Ali‑ 'ke ‑o vlɛ ‑kpuŋ ‑gbɛnɛ do ‑yrela bi 'bhɛ zan blina‑, 'bhɛɛ‑ 'ke ‑wa ‑blinna wɛyi‑ 'ɛ ba, 'bhɛ mabhaa ‑yaa nu bhɔlɛ 'bhɛ zan 'ɛ ma, 'sani‑ 'kee‑ ‑nɛ 'fiɛntrɔnnɛ mu 'la bhe 'mu do 'kpɔ balaa' ‑za 'yɔɔ‑ 'yi. ");
INSERT INTO moa_vpl VALUES ("LK17_3","072_17_3","LUK","17","3","3","‑Ka 'ka 'yrɛkpa 'ka 'gbu ba 'elrele! 'Kee nɛɛnɛ‑ do ‑za 'yɔɔ‑ ꞊kla, ‑a pe ‑a ni dɔɔ ‑e ‑za 'yɔɔ‑ ‑kla. 'Kee‑ ‑ploola 'bhɛ ‑za 'yɔɔ‑ 'ɛ ma, ‑yaa' ‑sroma 'yan. ");
INSERT INTO moa_vpl VALUES ("LK17_4","072_17_4","LUK","17","4","4","'Kee‑ ‑za 'yɔɔ‑ ‑kla 'e ni ‑glɔɔn 'srwaplɛ‑ ‑yrekpaa' do ꞊la, 'bhɛɛ‑ 'kee‑ ꞊nwa ‑a pelɛ 'e ni ‑glɔɔn 'srwaplɛ‑ dɔɔ 'e ‑yaa' ‑sroma 'yan, ‑yaa' ‑sroma 'yan.» ");
INSERT INTO moa_vpl VALUES ("LK17_5","072_17_5","LUK","17","5","5","Zesu a 'winbɔwo mu 'ɛ ‑wa ꞊pia ‑a ni dɔɔ: «Mɛɛzan, 'waa‑ 'kpaleya 'ɛ ‑a baankla' ‑a ba!» ");
INSERT INTO moa_vpl VALUES ("LK17_6","072_17_6","LUK","17","6","6","'Bhɛ klɛle 'tɛ, 'ke Mɛɛzan Zesu 'a 'pele ‑o ni dɔɔ: «'Ali‑ 'ke 'ka 'kpaleya 'ɛ ‑yoo bi 'efiɛntrɔnnɛle 'bhii‑ mutaadi bhɛ do gbɛɛn‑, 'ka 'yaa‑ nu 'sɔlɛ‑ a pele‑ ‑yri diiŋ 'la bhe 'bhɛ ni dɔɔ 'bhɛ yro 'bhɛ gbaanyrɛ 'ɛ ꞊nɔɔ, 'bhɛɛ 'bhɛ ge gbaan wɛyi‑ 'ɛ ba. 'Bhɛ ‑yaa nu 'bhɛ klɛlɛ 'ka 'liiwli‑ ta.» ");
INSERT INTO moa_vpl VALUES ("LK17_7","072_17_7","LUK","17","7","7","Zesu 'pe 'ezin‑ dɔɔ: «'Ka ‑de 'gbu ‑le 'ke 'bhɛ a yewonɛ do yalaa' ‑bhlaa mu gooba, 'bhɛɛ‑ 'ke 'bhɛ ‑daa gba la, 'kee‑ 'bhɛ ꞊ya, ‑e sɔ ‑a pele‑ 'bhɛ ni dɔɔ: ‹‑A klɛ blaale‑ 'bhɛɛ‑ 'e nu pɛbhlelɛ ɛɛ?› ");
INSERT INTO moa_vpl VALUES ("LK17_8","072_17_8","LUK","17","8","8","'Yooye‑, 'ŋ bhe ꞊ya pe 'bhɛ ni dɔɔ: ‹'Yaa‑ gba la ge pɛ mu 'ɛ go 'e ta, 'bhɛɛ‑ 'ye 'ŋ 'le pɛle 'ɛ dɔcie‑, 'bhɛɛ‑ 'ŋ 'bhɛ bhle 'pe. 'Kee‑ 'mi ꞊yaan bhla 'la ba; 'bhɛɛ‑ 'e sɔ 'yaa‑ pɛ pɛ 'ɛ 'bhlele, 'bhɛɛ‑ 'e ‑yi mi 'bhɛ ta.› ");
INSERT INTO moa_vpl VALUES ("LK17_9","072_17_9","LUK","17","9","9","'Ke 'yaa‑ yewonɛ 'bhɛ 'bhɛ 'woye‑ 'ɛ ꞊woa, 'e sɔ 'bhɛ 'pubɔle 'bhɛ ma ɛɛ?» ");
INSERT INTO moa_vpl VALUES ("LK17_10","072_17_10","LUK","17","10","10","Zesu pe ‑yaa' pɛ ‑klaŋlanɛ mu 'ɛ ni dɔɔ: «'Ka mu a pɛ ‑za 'ɛ ‑yoo 'bhɛ ‑la gbɛɛn‑ 'ezin‑. ‑O pe 'ka ye 'la 'wo 'ke 'ka ꞊yaan 'bhɛ 'kpɛn 'wolele 'waati 'la ba, 'ka nu ‑a pelɛ dɔɔ: ‹'O mɔɔ ‑o 'ke yewonɛ drɔŋ ‑la ‑le; 'woo 'woye‑ 'ɛ 'bhɛla‑ ꞊woa bhe.›» ");
INSERT INTO moa_vpl VALUES ("LK17_11","072_17_11","LUK","17","11","11","Zesu ge bhla zi Zeruzalɛmu 'taa 'ɛ ta, ‑e ‑kaan Samari 'pegee Galile 'klɛɛn plɛ 'ɛ 'pleŋ‑. ");
INSERT INTO moa_vpl VALUES ("LK17_12","072_17_12","LUK","17","12","12","‑E ‑yaa zan wlalɛ bhla 'la ba ‑wa do ta, 'ke ‑kpaandɛ' mi vu nule‑ ‑a ‑lɛpalɛ. ‑O ꞊bwa ‑a ma 'egbɔɔnle, 'bhɛɛ‑ ‑wa 'siile ‑saan 'eglɔɔle dɔɔ: ");
INSERT INTO moa_vpl VALUES ("LK17_13","072_17_13","LUK","17","13","13","«'O Daan mi Zesu, 'o 'yrɛnkla 'e ma!» ");
INSERT INTO moa_vpl VALUES ("LK17_14","072_17_14","LUK","17","14","14","'Bhɛ klɛle 'tɛ, 'ke Zesu 'a 'pele ‑o ni dɔɔ: «‑Ka ge 'ka 'gbu 'flɛ mazrɔn 'sraka 'lɛna mu 'ɛ ni.» ‑O ‑yaa ge 'zi bhla 'la ba 'bhɛ mu ba, 'ke ‑o ma ‑kpaan 'ɛ gole‑, 'bhɛɛ‑ 'ke ‑o ‑bheele'. ");
INSERT INTO moa_vpl VALUES ("LK17_15","072_17_15","LUK","17","15","15","‑O do 'a 'yelawoa 'bhii‑ 'bhɛ ma ‑kpaan 'ɛ golawoa, 'ke 'bhɛ niinale 'bhɛ gaan ‑gluu do 'ɛ 'yi 'kee‑ ‑Waanbhaa' 'tɔbhɔle 'eglɔɔle. ");
INSERT INTO moa_vpl VALUES ("LK17_16","072_17_16","LUK","17","16","16","‑E bhɔle Zesu ‑din, 'ke ‑ya 'kpɔ zɛnle‑ 'bhɛ 'lɛɛ, 'bhɛɛ 'kee‑ 'bhɛ 'pubɔle. ‑E ‑yaa 'ke Samari 'klɛɛn 'ɛ 'yi mi 'le. ");
INSERT INTO moa_vpl VALUES ("LK17_17","072_17_17","LUK","17","17","17","'Bhɛ klɛle 'tɛ, 'ke Zesu mɛɛ mu 'ɛ 'lrɔkpale dɔɔ: «'Woo‑ ‑kpaandɛ' mi vu 'ɛ, ‑o 'kpɛn 'laa 'bheelɛ‑ ɛɛ? ‑A ‑vin 'srwayiziɛ 'mu ‑o 'naa ɛɛ? ");
INSERT INTO moa_vpl VALUES ("LK17_18","072_17_18","LUK","17","18","18","Yaa dɔlɛ ‑o 'kedo‑ 'kpɔ 'kpee 'ke 'bhɛ nu ‑Waanbhaa' 'pubɔlɛ 'ke yaa 'e go 'yee‑ 'cie mi do 'kpɔ 'lɛɛ‑ ba ɛɛ?» ");
INSERT INTO moa_vpl VALUES ("LK17_19","072_17_19","LUK","17","19","19","'Bhɛ klɛle 'tɛ, 'ke Zesu 'a 'pele ‑a ni dɔɔ: «'Yee 'kpalawoa 'mi 'yi bhe 'e 'bheela‑, ge 'e ba ‑lɛ ma.» ");
INSERT INTO moa_vpl VALUES ("LK17_20","072_17_20","LUK","17","20","20","Farizi mu 'ɛ 'ke mu Zesu 'lrɔkpaa‑ *‑Waanbhaa' a ‑bhleŋgbeya 'yaa‑ yi 'ɛ ma. ‑Ayile, 'ke ‑ya pele‑ ‑o ni dɔɔ: «‑Waanbhaa' ‑bhleŋgbeya 'nuza‑ 'ɛ yaa nu klɛlɛ 'bhii‑ yepɛ 'le mɛɛ mu 'kɔɔ. ");
INSERT INTO moa_vpl VALUES ("LK17_21","072_17_21","LUK","17","21","21","Waa nu a pelɛ 'ka ni dɔɔ: ‹‑Ka 'ka 'yrɛkpa, 'yele‑ ‑gɛ! 'Yele‑ 'laale‑.› ‑Kaa 'yaango‑ dɔɔ 'bhii‑ ‑Waanbhaa' a ‑bhleŋgbeya 'ɛ ‑yoo gban 'ka 'pleŋ‑.» ");
INSERT INTO moa_vpl VALUES ("LK17_22","072_17_22","LUK","17","22","22","'Bhɛ blaan, 'ke ‑ya pele‑ ‑yaa' ‑klaŋlanɛ mu 'ɛ ni dɔɔ: «'Bhɛ 'waati ‑o zan bhɔlɛ, ‑e nu 'sɔlɛ‑ 'ka ni 'bhii‑ 'ka Bhaaplɛŋ Gbe 'ɛ ‑yaa' yi 'ɛ do ye. 'Duŋ‑ 'ka 'laa nu 'sɔlɛ‑ 'bhɛ 'yele. ");
INSERT INTO moa_vpl VALUES ("LK17_23","072_17_23","LUK","17","23","23","‑O nu ‑a pelɛ 'ka ni dɔɔ: ‹‑Ka 'ka 'yrɛkpa laale, ‑ka 'ka 'yrɛkpa ‑gɛ›. 'Ka 'laa gelɛ 'bhɛ yrɛ 'ɛ 'kedo‑ 'kpɔ ꞊nɔɔ, 'bhɛɛ‑ 'ka 'laa blasanlɛ 'ke 'ka ge 'bhɛ yrɛ 'ɛ ꞊nɔɔ. ");
INSERT INTO moa_vpl VALUES ("LK17_24","072_17_24","LUK","17","24","24","La ‑yrɛbole 'ɛ ‑e bhi 'bhɛɛ‑ ‑e kan blaale‑ laflɛ' 'yi, 'kee‑ da ‑a ‑daŋ' do ma, 'bhɛɛ‑ ‑e ge 'tɛnlɛ‑ ‑a ‑daŋ' 'bhɛɛke do ma gɔnɛ‑ 'la gbɛɛn‑, *Bhaaplɛŋ Gbe 'ɛ nu yi 'ɛ nu klɛlɛ 'bhɛ ‑la gbɛɛn‑ blaale‑. ");
INSERT INTO moa_vpl VALUES ("LK17_25","072_17_25","LUK","17","25","25","'Duŋ‑ 'sani‑ 'bhɛ yi 'ɛ 'bhɔle‑ pleŋ‑, ‑e nu ‑yrɛn ‑bebe 'bhlelɛ‑ 'elwale 'pe, 'bhɛɛ‑ ‑zɔn mu 'ɛ nu ‑o ‑baŋgolɛ ‑a ‑yi. ");
INSERT INTO moa_vpl VALUES ("LK17_26","072_17_26","LUK","17","26","26","‑Za mu 'la ꞊kla *Noe a pɛ 'waati 'ɛ ba, 'bhɛɛ‑ 'yansi za mu klɛlɛ Bhaaplɛŋ Gbe 'ɛ 'nu 'waati 'ɛ ba. ");
INSERT INTO moa_vpl VALUES ("LK17_27","072_17_27","LUK","17","27","27","Noe a pɛ 'waati 'ɛ ba, bhaaplɛŋ mu bole ‑yaa pɛbhlele 'pegee ‑wɛɛn 'mile ‑la ma. 'Bhɛɛ‑ ‑o ‑yaa le si 'bhɛ 'pegee ‑o ‑yaa ‑o ‑nɛ mu na gwlɛn ni. ‑O ꞊bwa 'bhɛɛ‑ 'yansi za mu 'ɛ klɛle ma 'kɛ 'bhɛ ge 'tɛnlɛ‑ Noe 'wlale‑ ma ‑yitakoŋ ‑gbɛnɛ 'ɛ 'yi. 'Bhɛ blaan, 'ke la gblɔ ‑gbɛnɛ 'ɛ banle‑ 'ke 'bhɛ 'yi 'ɛ 'kpale ‑o 'kpɛn ta, 'ke ‑o gale. ");
INSERT INTO moa_vpl VALUES ("LK17_28","072_17_28","LUK","17","28","28","'Bhɛɛ‑ Bhaaplɛŋ Gbe 'ɛ 'nu 'waati 'ɛ nu klɛlɛ 'ezin‑ 'bhii‑ Lɔti a pɛ 'waati 'ɛ gbɛɛn‑. 'Yee‑ Lɔti a pɛ 'waati 'ɛ ba, bhaaplɛŋ mu 'ɛ bole ‑yaa pɛbhlele 'pegee ‑wɛɛn 'mile‑ ‑la ma. ‑O ‑yaa pɛ mu lɔ, 'bhɛɛ‑ ‑o ‑yaa pɛ mu gɔn. ‑O ‑yaa gba mu kpa, 'bhɛɛ‑ ‑o ‑yaa 'fɛ mu dɔ. ");
INSERT INTO moa_vpl VALUES ("LK17_29","072_17_29","LUK","17","29","29","'Duŋ‑ Lɔti ‑gwa Sodɔmu ‑wa 'ɛ 'kpee yi 'la ta, 'tɛ 'pegee 'sɛkɛ 'tɛ ‑daa laanima 'bhii‑ la gbɛɛn‑, 'bhɛɛ‑ 'bhɛ ‑balaa' ‑o ta, 'ke 'bhɛ ‑o 'kpɛn 'kpaciele.» ");
INSERT INTO moa_vpl VALUES ("LK17_30","072_17_30","LUK","17","30","30","'Bhɛɛ‑ 'yansi za nu klɛlɛ Bhaaplɛŋ Gbe 'ɛ 'nu yi 'le. ");
INSERT INTO moa_vpl VALUES ("LK17_31","072_17_31","LUK","17","31","31","«'Bhɛ yi 'ɛ 'le, 'ke mɛɛ 'la zan ꞊kla 'bhɛ 'gbu a 'fɛ 'ɛ 'wiiŋ‑, 'bhɛɛ 'ke ‑yaa' pɛ mu ‑o yaa 'fɛ 'ɛ ꞊la, yaa pelɛ 'kaa ‑e zinale, 'bhɛɛ‑ ‑e ge 'bhɛ pɛ mu 'silɛ‑ 'fɛ 'ɛ ꞊la. 'Bhɛ klɛgbɛya do 'ɛ 'yi, 'ke mɛɛ 'la zan ‑o 'bhɛ ba gba la, 'bhɛ 'laa pelɛ 'kaa 'bhɛ niinale 'bhɛ ‑zanta' 'bhɛ ba 'fɛ 'lɛ ma. ");
INSERT INTO moa_vpl VALUES ("LK17_32","072_17_32","LUK","17","32","32","‑Za 'la 'bhɛ ꞊tian Lɔti na 'ɛ ma, 'bhɛ 'laa golɛ 'ka 'kpee. ");
INSERT INTO moa_vpl VALUES ("LK17_33","072_17_33","LUK","17","33","33","'Bhɛ ya 'ɛ 'yi, 'ke mɛɛ 'la zan ‑a zi 'bhii‑ 'bhɛ 'bhɛ 'gbu a 'trɛ ta 'si 'ɛ go ‑za 'yi, 'bhɛ zan nu bloolɛ 'bhɛ 'si 'ɛ 'yi. 'Duŋ‑ 'ke mɛɛ 'e 'niigwa‑ ‑a 'gbu 'si 'ɛ ni 'mi ‑zayi', 'bhɛ zan nu golɛ ‑za 'yi. ");
INSERT INTO moa_vpl VALUES ("LK17_34","072_17_34","LUK","17","34","34","'Mi pe 'ka ni 'ŋ 'sɔwɛɛ‑ 'ɛ ma dɔɔ: Bhaaplɛŋ Gbe 'ɛ 'nu yi 'le, mɛɛ plɛ nu klɛlɛ yilapɛ do ta, ‑o nu ‑a do 'silɛ‑ 'bhɛɛ‑ ‑a do 'ɛ 'bhɛ bo ‑a nɔɔ‑. ");
INSERT INTO moa_vpl VALUES ("LK17_35","072_17_35","LUK","17","35","35","Le plɛ nu klɛlɛ pɛ zɔn yrɛ nɔɔ‑ ‑wee do 'yi, ‑o nu ‑a do 'silɛ‑, 'bhɛɛ‑ ‑a do 'ɛ 'bhɛ bo ‑a nɔɔ‑. ");
INSERT INTO moa_vpl VALUES ("LK17_36","072_17_36","LUK","17","36","36","'Gwlaan‑ plɛ nu klɛlɛ gba do ta, ‑o nu ‑a do 'silɛ‑, 'bhɛɛ‑ ‑o nu ‑a plɛ mi 'tolɛ‑ ‑a nɔɔ ye.» ");
INSERT INTO moa_vpl VALUES ("LK17_37","072_17_37","LUK","17","37","37","'Bhɛ klɛle 'tɛ, 'ke Zesu a ‑Klaŋlanɛ mu 'ɛ ‑wa ‑lrɔkpale dɔɔ: «Mɛɛzan, 'e nu yi 'ɛ nu klɛlɛ 'naa‑ ‑a ma ɛɛ?» 'Bhɛɛ‑ Zesu 'a zikpaa‑ ‑o ni ‑gɔɔn do 'le dɔɔ: «Mɛɛ gbaa 'ɛ ‑yoo yrɛ 'la ꞊nɔɔ, gbotakwe mu 'ɛ ‑woo ‑lɛkpa' 'eke‑ ta 'bhɛɛ‑ ꞊nɔɔ.» ");
INSERT INTO moa_vpl VALUES ("LK18_1","072_18_1","LUK","18","1","1","'Bhɛ blaan, 'ke Zesu ‑gɔɔn do bɔle 'sanle ‑yaa' ‑klaŋlanɛ mu 'ɛ ni, 'kooko‑ ‑ya zrɔn 'mu ni 'bhii‑ 'mu bo 'mu 'seriwole ma 'waati 'ɛ 'kpɛn ba, 'bhɛɛ‑ 'mu 'trɛ 'laa 'bhɔlɛ‑ 'mu 'seriwole ma ‑titi. ");
INSERT INTO moa_vpl VALUES ("LK18_2","072_18_2","LUK","18","2","2","‑E pe 'mu ni dɔɔ: «'Kitikan mi do ‑yaa ‑wa do ta, yaa ‑yaa gblaan ‑Waanbhaa' ‑lɛɛ, 'bhɛɛ‑ yaa ‑yaa mɛɛ 'kedo‑ 'kpɔ 'klɔsikun. ");
INSERT INTO moa_vpl VALUES ("LK18_3","072_18_3","LUK","18","3","3","'Yee‑ ‑wa do 'kpɔ 'ɛ ta, ‑a nɔɔ‑ glaanle le do ‑yaa nu yi 'oo yi 'yee‑ 'kitikan 'mi 'ɛ ‑a matɛdɔlɛ. 'Bhɛ 'yaa‑ nu 'tɛnlɛ‑ ‑a ma, 'bhɛɛ‑ 'bhɛ 'a pe ‑a ni dɔɔ: ‹'Zoo 'na 'mi ni 'ŋ 'sɔɔnnii 'ɛ ta!› ");
INSERT INTO moa_vpl VALUES ("LK18_4","072_18_4","LUK","18","4","4","'Bhɛ glaanle 'ɛ ꞊mwa 'yee‑ 'kitikan mi 'ɛ matɛdɔle ma 'bhɛɛ‑ gbɛɛn‑, 'bhɛɛ‑ yaa ‑yaa dɔle‑ ‑a ‑la 'kee‑ 'zoo na 'bhɛ ni. 'Duŋ‑ ‑yrekpaa' do, 'ke ‑ya pele‑ ‑a 'gbu 'kpee dɔɔ: ‹Wlan 'ɛ ni, 'naa gblaan ‑Waanbhaa' ‑lɛɛ, 'bhɛɛ‑ 'naa mɛɛ 'kedo‑ 'kpɔ 'klɔsikun. ");
INSERT INTO moa_vpl VALUES ("LK18_5","072_18_5","LUK","18","5","5","'Bhɛɛ‑ 'duŋ‑, 'yee‑ le 'lɛɛ‑ ‑yoo 'ŋ matɛdɔ 'zi gɔnɛ‑ 'la gbɛɛn‑, ‑e nu bolɛ 'ŋ matɛdɔle ma 'bhɛɛ‑ gbɛɛn‑, 'fɔke 'bhɛ ge 'tɛnlɛ‑ 'ŋ zrupliile ma. 'Kee‑ ꞊kla 'bhɛ gbɛɛn‑ bhe, 'ŋ 'zoo 'nale ‑a ni.›» ");
INSERT INTO moa_vpl VALUES ("LK18_6","072_18_6","LUK","18","6","6","'Bhɛ blaan, 'ke Mɛɛzan Zesu 'a 'pele ‑yaa' ‑klaŋlanɛ mu 'ɛ ni dɔɔ: «'Ka 'yee‑ 'kitikan mi ‑yɔɔ 'ɛ ‑yaa' ‑jan 'ɛ ꞊maa ɛɛ? ");
INSERT INTO moa_vpl VALUES ("LK18_7","072_18_7","LUK","18","7","7","‑Waanbhaa' 'la mɛɛ mu ꞊sia ‑a ba 'ke ‑yaa' pɛ 'le, 'bhɛɛ‑ 'ke 'bhɛ mu bole ‑o wisile ma ‑a ni 'ke ‑wa ‑sromabɔ ‑bi zi 'pegee ‑yrekpaa', 'ka mu 'kpee ma 'yee‑ ‑Waanbhaa' laa nu 'bhɛ zan mu a 'seri 'ɛ 'lɛkunlɛ, 'bhɛɛ‑ ‑yoo go ‑yrɛn 'yi ɛɛ? 'Ka mu 'kpee ma, ‑e nu ‑mɔlɛ' 'ke yaa zibɔ ‑o zi ɛɛ? ");
INSERT INTO moa_vpl VALUES ("LK18_8","072_18_8","LUK","18","8","8","Wlan 'gbu 'ɛ ni, ‑Waanbhaa' laa nu ‑mɔlɛ' ‑o gole ma ‑yrɛn 'yi. 'Duŋ‑ Bhaaplɛŋ Gbe 'ɛ 'nu yi 'ɛ 'le, ‑e nu bhɔlɛ mɛɛ ‑wɛɛ' ‑la ta 'ke 'mu 'kpale‑ ‑o ‑a ‑yi ɛɛ?» ");
INSERT INTO moa_vpl VALUES ("LK18_9","072_18_9","LUK","18","9","9","Zesu ‑gɔɔn do ꞊bwa 'ezin‑. Mɛɛ ‑lɛdo' 'la ‑o 'kpee ma ‑o ‑lɛdɔɔle ‑o ‑Waanbhaa' ‑yrɛ 'yi, 'bhɛɛ‑ 'ke ‑woo 'gbu magbaandɛ mɛɛ ‑bhɛɛke' mu ma, Zesu ‑gɔɔn 'lɛɛ‑ 'bhɛ ꞊bwa 'mu ‑la 'kaama‑. ");
INSERT INTO moa_vpl VALUES ("LK18_10","072_18_10","LUK","18","10","10","‑E pe dɔɔ: «Mɛɛ plɛ ‑ja ‑o 'seriwo yrɛ nɔɔ‑ ‑Waanbhaa' Gba 'Fɛ ‑Gbɛnɛ 'ɛ ꞊la, ‑a do ‑yaa 'ke Farizi mi 'le, 'bhɛɛ‑ ‑a ‑bhɛɛke' do 'ɛ 'bhɛ 'yaa‑ 'ke 'nisrakun mi 'le. ");
INSERT INTO moa_vpl VALUES ("LK18_11","072_18_11","LUK","18","11","11","Farizi mi 'ɛ ‑ja dulalɛ 'edaŋma ‑Waanbhaa' Gba 'Fɛ ‑Gbɛnɛ 'ɛ ꞊la, 'bhɛɛ‑ ‑ya 'seriwole ‑saan dɔɔ: ‹'E, ‑Waanbhaa'! 'Mi 'e 'pubɔ‑, ‑amasrɔyi 'naa ‑o 'ke ‑faannii' 'pegee mɛɛ ‑yɔɔ' 'le, 'bhɛɛ‑ 'naa mɛɛ ‑bhɛɛke' 'na ‑glin 'bhii‑ mɛɛ ‑vin mu 'ɛ gbɛɛn‑. 'Mi 'e 'pubɔ‑ 'ezin‑, ‑amasrɔyi 'naa ‑o 'eyɔɔle 'bhii‑ 'nisrakun mi 'la bhe 'bhɛ gbɛɛn‑.› ");
INSERT INTO moa_vpl VALUES ("LK18_12","072_18_12","LUK","18","12","12","'Ŋ 'suŋwla‑ gaan plɛ ‑gbɛɛyi' 'ɛ ꞊la, 'bhɛɛ‑ 'ke 'ŋ pɛ 'oo pɛ 'la 'srɔɔwoa꞊ 'ŋ 'bhɛ 'yiciɛn‑ ‑lɛ vu, 'bhɛɛ‑ ‑a ‑lɛ vu mi 'ɛ 'ŋ 'bhɛ na 'bhi ‑Waanbhaa' ni. ");
INSERT INTO moa_vpl VALUES ("LK18_13","072_18_13","LUK","18","13","13","'Bhɛ 'waati 'ɛ ba, 'nisrakun mi 'ɛ 'bhɛ 'pleŋgole ‑yaa 'yee‑ Farizi mi 'ɛ ma, 'bhɛɛ‑ 'bhɛ 'laa ‑yaa sɔ 'bhɛ ‑yrɛkpale laanima. 'Bhɛ 'bhɛ gbɛ plɛ 'ɛ ꞊kpaa 'bhɛ 'wiiŋ‑, 'bhɛɛ‑ 'bhɛ pe dɔɔ: ‹'Ee, ‑Waanbhaa'! 'Ŋ 'yrɛnkla 'e ma, 'ŋ 'yoo‑ 'ke ‑za 'yɔɔ‑ klɛ mi 'le.›» ");
INSERT INTO moa_vpl VALUES ("LK18_14","072_18_14","LUK","18","14","14","'Bhɛ klɛle 'tɛ, 'ke Zesu 'a pele ‑yaa' ‑klaŋlanɛ mu 'ɛ ni dɔɔ: «'Mi pe 'ka 'ni dɔɔ ‑Waanbhaa' 'nisrakun mi 'ɛ ‑yaa' ‑za 'yɔɔ‑ mu 'ɛ ma ‑sroma ‑yaan, 'bhɛɛ‑ 'bhɛ ‑ja 'bhɛ ba 'fɛ 'lɛ ma. 'Duŋ‑ Farizi mi 'ɛ 'bhɛ 'laa ‑za 'kedo‑ 'kpɔ 'srɔɔwolɛ ‑Waanbhaa' 'kɔɔ. ‑Amasrɔyi, 'ke mɛɛ 'oo mɛɛ 'la 'bhɛ 'gbu magbaandia mɛɛ ma, ‑Waanbhaa' nu 'bhɛ zan mavɛɛlɛ. 'Bhɛɛ‑ 'ke mɛɛ 'la zan 'bhɛ 'gbu mavɛɛla, ‑Waanbhaa' nu 'bhɛ zan magbaandɛlɛ.» ");
INSERT INTO moa_vpl VALUES ("LK18_15","072_18_15","LUK","18","15","15","‑Yrekpaa' do, mɛɛ 'ke mu ꞊nwa ‑nɛ 'fiɛntrɔnnɛ 'ke mu 'le Zesu ni, 'kooko‑ ‑e 'mu 'dumawo. ‑Yaa' ‑klaŋlanɛ mu 'ɛ 'yrɛkpale 'bhɛ mɛɛ mu 'ɛ ma 'ke ‑o ‑yranle' 'mu zi. ");
INSERT INTO moa_vpl VALUES ("LK18_16","072_18_16","LUK","18","16","16","'Bhɛ klɛle 'tɛ, 'ke Zesu 'a 'pele ‑o ni dɔɔ ‑o nu 'woo‑ ‑nɛ mu 'ɛ 'le ‑a ni, 'bhɛɛ‑ ‑e pe 'ezin‑ dɔɔ: «'Ka 'laa ‑nɛ 'fiɛntrɔnnɛ mu 'ɛ ‑gbinlɛ' 'ŋ ma, ‑kaa 'to 'ke ‑o nu 'ŋ ba. ‑Amasrɔyi mɛɛ 'la zan mu klɛgbɛya ‑o 'bhii‑ 'woo‑ ‑nɛ mu 'lɛɛ‑ gbɛɛn‑, 'bhɛ zan mu ‑la pɛ ‑le 'ke ‑Waanbhaa' ‑bhleŋgbeya ‑wa 'ɛ 'le. ");
INSERT INTO moa_vpl VALUES ("LK18_17","072_18_17","LUK","18","17","17","'Mi pe 'ka ni 'ŋ 'sɔwɛɛ ma dɔɔ: 'Ke mɛɛ 'la zan laa ‑Waanbhaa' a ‑bhleŋgbeya ‑za 'ɛ 'kunlɛ‑ 'bhii‑ ‑nɛ 'fiɛntrɔnnɛ do 'a kun gɔnɛ‑ 'la gbɛɛn‑, 'bhɛ zan laa nu 'sɔlɛ‑ gele‑ ‑yaa' ‑bhleŋgbeya ‑wa 'ɛ ta ‑titi.» ");
INSERT INTO moa_vpl VALUES ("LK18_18","072_18_18","LUK","18","18","18","Zuufu mu a ‑kuŋlii do Zesu 'lrɔkpaa‑ dɔɔ: «'O Daan mi wlan, 'an klɛ 'nale‑ ‑a ma 'bhɛɛ‑ 'ŋ ‑Waanbhaa' ba bole ‑yrɛ ma ‑si 'la 'ke ‑daŋ' 'laa ‑o 'bhɛ ma 'bhɛ 'srɔɔwo‑ ɛɛ?» ");
INSERT INTO moa_vpl VALUES ("LK18_19","072_18_19","LUK","18","19","19","Zesu pe ‑a ni dɔɔ: «‑Mɛle ‑kla 'bhɛɛ‑ 'yoo‑ 'ŋ 'sii zii' 'e Daan mi wlan ɛɛ? Mɛɛ 'kedo‑ 'kpɔ 'laa ‑o 'elrele 'ke yaa 'e go ‑Waanbhaa' do ‑kplɛn ba. ");
INSERT INTO moa_vpl VALUES ("LK18_20","072_18_20","LUK","18","20","20","'E ‑Waanbhaa' a 'toŋ mu 'lɛɛ‑ dɔ ɛɛ, 'wole‑ dɔɔ: ‹'Yaa ‑yanbhɔɔya klɛlɛ, 'yaa mɛɛ dɛlɛ, 'yaa ‑faanwolɛ, 'yaa bhla 'kpalɛ‑ mɛɛ ma, 'e dɛ 'pegee 'e nɛɛ ‑lɛdɔ' ‑a ma.›» ");
INSERT INTO moa_vpl VALUES ("LK18_21","072_18_21","LUK","18","21","21","'Yee‑ ‑naflo zan 'ɛ pe Zesu ni dɔɔ: «'Ŋ 'woo‑ 'toŋ mu 'la bhe 'mu 'kpɛn 'klɔsikwan 'kee‑ 'san 'ŋ matruŋya 'waati 'ɛ ba.» ");
INSERT INTO moa_vpl VALUES ("LK18_22","072_18_22","LUK","18","22","22","‑E 'bhɛ 'pele‑ 'bhɛ gbɛɛn‑ bhe, 'ke Zesu 'a 'pele 'a ni dɔɔ: «'Yaa ‑za do 'kpɔ ‑la klɛlɛ ‑li, 'bhɛ ‑le dɔɔ: 'e 'kɔɔpɛ‑ mu 'ɛ 'kpɛn gɔn, 'bhɛɛ‑ ‑o ma ‑gɔli' 'ɛ 'yiciɛn‑ 'kɔɔfleŋzan mu ma. 'Kee 'bhɛ ꞊kla, 'e nu ‑naflo mu 'srɔɔwolɛ laflɛ' 'yi. 'Bhɛ blaan, nu 'bhɛɛ‑ 'e klɛ 'ŋ zi mi 'le.» ");
INSERT INTO moa_vpl VALUES ("LK18_23","072_18_23","LUK","18","23","23","'Yee‑ mɛɛ 'ɛ ‑e Zesu 'wojan‑ mu 'ɛ 'kpɛn 'male‑, 'ke ‑ya wlɛyisriwole, ‑amasrɔyi ‑e ‑yaa 'ke ‑naflo zan ‑gbɛnɛ do 'le. ");
INSERT INTO moa_vpl VALUES ("LK18_24","072_18_24","LUK","18","24","24","'Bhɛla‑ ‑yile, 'ke Zesu 'a 'pele dɔɔ: «'E, ‑naflo zan mu gele la ‑Waanbhaa' a ‑bhleŋgbeya ‑wa 'ɛ ta 'dɛ! ");
INSERT INTO moa_vpl VALUES ("LK18_25","072_18_25","LUK","18","25","25","'Ali‑ 'yɔɔnma do 'kanle‑ laa la ‑mlɛsiɛnnɛ do ‑gluu zi 'bhii‑ ‑naflo zan do gele la ‑Waanbhaa' a ‑bhleŋgbeya ‑wa 'ɛ ta gɔnɛ‑ 'la gbɛɛn‑.» ");
INSERT INTO moa_vpl VALUES ("LK18_26","072_18_26","LUK","18","26","26","'Bhɛ klɛle 'tɛ, mɛɛ 'la zan mu ‑yaa ‑o 'trɔnkpa zii' Zesu 'ni, 'bhɛ mu 'bhɛ ‑jan 'ɛ 'male‑, 'ke 'mu 'a pele‑ dɔɔ: «'Bhɛɛ‑ ‑dele sɔ gole ‑za 'yi ɛɛ?» ");
INSERT INTO moa_vpl VALUES ("LK18_27","072_18_27","LUK","18","27","27","'Bhɛ 'yi 'tɛ, 'ke Zesu 'a 'pele ‑o ni dɔɔ: «‑Za 'la 'bhɛ bhaaplɛŋ mu ‑baliwo, 'bhɛ 'laa ‑Waanbhaa' ‑baliwo ‑titi.» ");
INSERT INTO moa_vpl VALUES ("LK18_28","072_18_28","LUK","18","28","28","Piɛri pe ‑a ni dɔɔ: «'O mɔɔ ‑ploola 'o 'kɔɔpɛ‑ mu 'ɛ 'kpɛn ma, 'bhɛɛ‑ 'o ꞊nwa dɔlɛ 'e zi.» ");
INSERT INTO moa_vpl VALUES ("LK18_29","072_18_29","LUK","18","29","29","‑Ayile, 'ke Zesu 'a 'pele ‑o ni dɔɔ: «'Mi pe 'ka ni 'ŋ 'sɔwɛɛ ma dɔɔ: 'ke ‑Waanbhaa' a ‑bhleŋgbeya 'ɛ ‑zayi', 'bhɛɛ‑ mɛɛ 'la zan ‑yaa 'fɛ oo, ‑a na oo, ‑a nɛɛnɛ‑ mu oo, ‑a dɛ 'pegee ‑a nɛɛ oo, 'bhɛ 'pegee ‑a ‑nɛ mu 'ɛ ꞊twa ‑a nɔɔ‑. ");
INSERT INTO moa_vpl VALUES ("LK18_30","072_18_30","LUK","18","30","30","'Bhɛ zan nu 'bhɛ pɛ mu 'ɛ yɛkɛ‑ 'srɔɔwolɛ 'ke bhɛ kan ‑a 'ciɛn ‑lwa mu 'ɛ ta 'drunyan 'lɛɛ‑ 'yi, 'bhɛɛ‑ 'bhɛ zan nu ‑Waanbhaa' ba bole ‑yrɛ ma ‑si 'la ‑daŋ' 'laa ‑o 'bhɛ ma 'bhɛ 'srɔɔwolɛ.» ");
INSERT INTO moa_vpl VALUES ("LK18_31","072_18_31","LUK","18","31","31","'Bhɛ blaan, 'ke Zesu ‑yaa' *‑klaŋlanɛ vu ta plɛ 'ɛ 'siile, 'bhɛɛ‑ 'ke ‑ya pele‑ ‑o ni dɔɔ: «‑Ka 'ka 'trɔnkpa 'ŋ ni 'elrele, ‑kɔɔ' ‑o gelawo zii' Zeruzalɛmu ‑gɛ bhe, ‑Waanbhaa' *‑lɛla' janwo mu 'ɛ ‑o ‑za mu 'la 'kpɛn yɔɔndia‑ Bhaaplɛŋ Gbe 'ɛ ba za 'yi 'mu 'kpɛn 'yi za nu klɛlɛ. ");
INSERT INTO moa_vpl VALUES ("LK18_32","072_18_32","LUK","18","32","32","‑O nu Bhaaplɛŋ Gbe 'ɛ 'kpalɛ‑ 'si 'bhɛɛke mu 'kɔɔ, 'bhɛ mu 'nu ‑a malrɔgolɛ, 'bhɛɛ‑ 'mu 'sɔnsi‑ ‑a ma; 'mu nu a ‑zwanwolɛ, 'bhɛɛ‑ 'mu nu 'mu 'liile‑ 'klalɛ‑ ‑a ta. ");
INSERT INTO moa_vpl VALUES ("LK18_33","072_18_33","LUK","18","33","33","'Bhɛ blaan, ‑o nu ‑a tafɛlɛ 'ke gbaŋbhlɛ 'le, 'bhɛɛ‑ ‑wa dɛ. 'Ke ‑wa ꞊dia, 'duŋ‑ ‑e nu bwelɛ gale ba ‑a gale blaan ‑yrekpaa' yaga mi 'ɛ ma.» ");
INSERT INTO moa_vpl VALUES ("LK18_34","072_18_34","LUK","18","34","34","'Bhɛɛ‑ 'duŋ‑ ‑yaa' ‑klaŋlanɛ mu 'ɛ waa 'bhɛ ‑jan mu 'ɛ ‑o do 'kpɔ 'yimalɛ. ‑E ‑yaa 'bhii‑ ‑gblo 'kpale‑ ‑yaa' ‑o yikan' 'ɛ 'yrɛ ta, 'bhɛɛ‑ waa ‑yaa sɔ ‑o ‑yimale. ");
INSERT INTO moa_vpl VALUES ("LK18_35","072_18_35","LUK","18","35","35","Zesu 'pegee ‑a zi mu 'ɛ 'bhɔlawoa Zeriko ‑wa 'ɛ ‑din 'waati 'la ba, ‑yrɛ 'wi mi do yaale ‑yaa zi 'ɛ 'trɔn ta 'ke ‑ya ‑yrɛwo' mɛɛ mu ma. ");
INSERT INTO moa_vpl VALUES ("LK18_36","072_18_36","LUK","18","36","36","‑Ayile, ‑ya male 'kaa ‑zamaa' 'srɛ do ‑o 'kan zii', 'kee‑ mɛɛ 'ke mu ‑lrɔkpale dɔɔ: «‑Mɛla ma 'bhɛɛ‑ mɛɛ ‑weli' ‑o 'esrɛle ‑gee' ɛɛ?» ");
INSERT INTO moa_vpl VALUES ("LK18_37","072_18_37","LUK","18","37","37","‑O pe ‑a ni dɔɔ Zesu 'la da Nazarɛti ‑wa 'ɛ ta, 'bhɛ ‑le 'kan zii'. ");
INSERT INTO moa_vpl VALUES ("LK18_38","072_18_38","LUK","18","38","38","'Bhɛ 'yi 'tɛ, 'ke ‑ya pele 'sanle 'eglɔɔle dɔɔ: «Davidi 'nranɛ‑ Zesu, 'ŋ 'yrɛnkla 'e ma!» ");
INSERT INTO moa_vpl VALUES ("LK18_39","072_18_39","LUK","18","39","39","Mɛɛ 'la zan mu dɔle‑ ‑yaa mɛɛ ‑vin mu 'ɛ 'lɛɛ, 'mu 'yaa‑ ‑yran 'zi ‑a zi 'kaa ‑ya taga. 'Duŋ‑ ‑e ‑yaa pe 'zi 'eglɔɔle 'ezin‑ dɔɔ: «Davidi 'nranɛ‑ Zesu, 'ŋ 'yrɛnkla 'e ma!» ");
INSERT INTO moa_vpl VALUES ("LK18_40","072_18_40","LUK","18","40","40","'Bhɛ klɛle 'tɛ, 'ke Zesu dulale, 'bhɛɛ‑ 'ke ‑ya pele‑ 'kaa ‑o nu 'yee‑ ‑yrɛ 'wi mi 'ɛ 'le ‑a ni. ‑Ya mabɛɛnle Zesu ‑din, 'ke 'bhɛ 'a 'lrɔkpale dɔɔ: ");
INSERT INTO moa_vpl VALUES ("LK18_41","072_18_41","LUK","18","41","41","«'Yoo‑ ‑a zi 'bhii‑ 'ŋ ‑mɛ za ‑la klɛ 'e ni ɛɛ?» ‑E pe Zesu ni dɔɔ: «Mɛɛzan, 'ŋ 'yoo‑ ‑a zi 'bhii‑ 'ya klɛ 'ke 'ŋ sɔ yrɛ ma yele‑ 'ezin‑.» ");
INSERT INTO moa_vpl VALUES ("LK18_42","072_18_42","LUK","18","42","42","‑Ayile, 'ke Zesu 'a 'pele ‑a ni dɔɔ: «'E 'yrɛ 'liiploo‑! 'Yee 'kpalawoa 'mi 'yi bhe 'e 'bheela‑.» ");
INSERT INTO moa_vpl VALUES ("LK18_43","072_18_43","LUK","18","43","43","'Bhɛ yrɛ do 'ɛ ꞊nɔɔ bhe, 'ke ‑a ‑yrɛ mu 'ɛ 'liiploole, 'bhɛɛ‑ 'kee‑ yrɛ ma yele‑. ‑Ayile 'kee‑ dɔle‑ Zesu zi, 'bhɛɛ‑ 'kee‑ ge ‑Waanbhaa' 'tɔbhɔlele. ‑Zamaa' 'ɛ 'yrɛkpale 'yee‑ ‑yrɛ 'wi mi 'ɛ ma, 'ke ‑o 'kpɛn ‑Waanbhaa' 'tɔbhɔle 'sanle. ");
INSERT INTO moa_vpl VALUES ("LK19_1","072_19_1","LUK","19","1","1","Zesu 'bhɔle‑ Zeriko ‑wa 'ɛ ta, 'bhɛɛ‑ ‑e ‑kaan ‑a 'kpee. ");
INSERT INTO moa_vpl VALUES ("LK19_2","072_19_2","LUK","19","2","2","'Bhɛ ꞊nɔɔ 'nisrakun mu ‑kuŋlii do ‑yaa, ‑o 'yaa‑ 'bhɛ sii Zase. 'Bhɛ 'yaa‑ ‑naflo zan ‑gbɛnɛ do ‑la ‑le. ");
INSERT INTO moa_vpl VALUES ("LK19_3","072_19_3","LUK","19","3","3","‑E ‑yaa ‑a zi 'bhii‑ ‑e Zesu 'ye 'ke 'bhɛ ‑o mɛɛ ‑glɔɔn 'la 'le; 'duŋ‑ yaa ‑yaa 'sɔle 'bhɛ 'yele. ‑Amasrɔyi ‑e ‑yaa kpeteekpenɛ, 'bhɛɛ‑ ‑zamaa' 'ɛ ꞊yaa 'ebebele. ");
INSERT INTO moa_vpl VALUES ("LK19_4","072_19_4","LUK","19","4","4","‑Ayile, 'kee‑ 'kanle mɛɛ mu 'ɛ 'lɛɛ blaale‑, 'bhɛɛ‑ 'kee‑ gele‑ 'sanlɛ‑ ‑yri diiŋ do 'yi. ‑O ‑yaa 'bhɛ ‑yri diiŋ 'ɛ sii sikomɔɔ. ‑E ‑saan 'bhɛ 'yi, 'kooko‑ Zesu 'kan bhla 'ɛ zi, ‑e sɔ 'bhɛ 'yele. ");
INSERT INTO moa_vpl VALUES ("LK19_5","072_19_5","LUK","19","5","5","Zesu 'bhɔle‑ 'bhɛ ‑yri diiŋ 'ɛ ꞊la, 'ke ‑ya ‑yrɛkpale laanima, 'bhɛɛ‑ 'ke ‑ya pele‑ dɔɔ: «Zase, zina‑ blaale‑, 'mi nu 'ŋ zɛnlɛ 'bhi ‑la ba ‑zɔn.» ");
INSERT INTO moa_vpl VALUES ("LK19_6","072_19_6","LUK","19","6","6","'Bhɛ klɛle 'tɛ, 'ke Zase zinale blaale‑, 'bhɛɛ‑ 'kee‑ gele‑ Zesu 'le ‑a ba ‑lɛ ma, ‑a zrukpaa' ‑gbɛnɛ 'ɛ ta. ");
INSERT INTO moa_vpl VALUES ("LK19_7","072_19_7","LUK","19","7","7","'Duŋ‑ mɛɛ mu 'la 'kpɛn 'a ꞊ya ‑a ge bhla 'ɛ zi Zase ba, 'mu 'mu zrupliila, 'bhɛɛ‑ 'mu pe dɔɔ: «'Yee‑ mɛɛ 'lɛɛ‑ ‑ja ‑a zɛnlɛ ‑za 'yɔɔ klɛ mi do ‑la ba.» ");
INSERT INTO moa_vpl VALUES ("LK19_8","072_19_8","LUK","19","8","8","‑Woo 'bhɛ 'yi bhe oo, 'ke Zase 'e 'wlɛnle ‑o pleŋ‑, 'bhɛɛ‑ 'ke ‑ya pele‑ dɔɔ: «Mɛɛzan, 'E 'yrɛkpa ‑gɛ doo, 'mi nu 'ŋ 'kɔɔpɛ‑ mu 'ɛ 'yiciɛnlɛ ‑lɛ plɛ, 'bhɛɛ‑ 'an 'traa do na 'kɔɔfleŋzan mu ni. 'Ke 'ŋ ‑gɔli' ꞊kwan mɛɛ ‑bhɛɛke' 'kɔɔ ‑dawli' ma, 'ŋ nu 'bhɛ ‑gɔli' yɛkɛ‑ 'ɛ 'niinalɛ 'bhɛ zan ma ‑glɔɔn yiziɛ.» ");
INSERT INTO moa_vpl VALUES ("LK19_9","072_19_9","LUK","19","9","9","'Bhɛ klɛle 'tɛ, 'ke Zesu 'a 'pele ‑a ni dɔɔ: «‑Zɔn, ‑Waanbhaa' 'bhi 'pegee 'yaa‑ 'fa ꞊la mu 'ɛ ‑gwa ‑za 'yi; ‑amasrɔyi 'bhi 'ezin‑, 'yoo‑ 'ke Abraamu 'nranɛ‑ 'ɛ do 'le. ");
INSERT INTO moa_vpl VALUES ("LK19_10","072_19_10","LUK","19","10","10","*Bhaaplɛŋ Gbe 'ɛ ꞊nwa mɛɛ mu 'la zan mu ꞊nia 'mu ziglinlɛ 'bhɛɛ‑ ‑yoo go ‑za 'yi.» ");
INSERT INTO moa_vpl VALUES ("LK19_11","072_19_11","LUK","19","11","11","Mɛɛ mu 'ɛ ꞊bwa ‑o 'trɔnkpale ma Zesu ni, 'bhɛɛ‑ ‑o bhɔlawoa Zeruzalɛmu ‑wa 'ɛ ‑din, ‑o 'kpee ma, ‑Waanbhaa' a ‑bhleŋgbeya yaa‑ bhla 'ɛ 'lɛɛ 'laa ‑yaa ‑li 'egbɔɔnle. 'Bhɛla‑ ‑yile 'ke Zesu ‑gɔɔn 'lɛɛ‑ 'bhɛ bɔle‑ 'sanle ‑o ni. ");
INSERT INTO moa_vpl VALUES ("LK19_12","072_19_12","LUK","19","12","12","‑E pe ‑o ni dɔɔ: «'Elwaleta ‑sɔ, ꞊fwa mu ba 'fa 'la mi do ‑yaa zan gelɛ 'klɛɛn gbɔɔn do ‑yi, 'kooko‑ 'bhɛ 'klɛɛn 'ɛ 'yi mu 'ɛ 'mu 'a klɛ 'mu ta ‑bhleŋgbe 'le. 'Ke 'mu ꞊yaan ‑a klɛlele ‑bhleŋgbe 'le 'waati 'la ba, ‑e ‑yaa nu 'niinalɛ ‑a 'gbu 'ya 'klɛɛn 'ɛ 'yi, 'bhɛɛ ‑e klɛ ‑a 'gbu a mɛɛ mu 'ɛ ta ‑bhleŋgbe 'le. ");
INSERT INTO moa_vpl VALUES ("LK19_13","072_19_13","LUK","19","13","13","'Sani‑ ‑a gele pleŋ‑ 'bhɛ 'taa 'ɛ ta, ‑e ‑yaa' yewonɛ vu 'ɛ 'siila‑, 'bhɛɛ‑ ‑e ‑can 'taŋbha do do ꞊naa ‑o 'kpɛn ni do do. 'Bhɛɛ‑ ‑e pe ‑o ni dɔɔ: ‹‑Ka yewo 'yee‑ ‑gɔli' 'ɛ 'le, 'kooko‑ ‑trɔnkpa' ‑a ma 'sani‑ 'ŋ 'nule‑ pleŋ‑.› ");
INSERT INTO moa_vpl VALUES ("LK19_14","072_19_14","LUK","19","14","14","'Duŋ‑ ‑a ‑za 'laa ‑yaa sɔ ‑yaa 'klɛɛn 'yi mu 'ɛ ni, ‑ayile 'ke 'bhɛ mu mɛɛ mu winbɔle ‑a zi 'kaa 'mu 'a pe 'a ni dɔɔ: ‹'Waa‑ zi 'bhii‑ mɛɛ 'lɛɛ‑ klɛ 'o ta ‑bhleŋgbe 'le.› ");
INSERT INTO moa_vpl VALUES ("LK19_15","072_19_15","LUK","19","15","15","‑E ‑ja 'bhɛ 'klɛɛn 'ɛ 'yi, 'bhɛɛ‑ ‑wa ꞊kla 'ke ‑bhleŋgbe do 'le. 'Bhɛ blaan, 'kee‑ niinale ‑a ba 'klɛɛn 'ɛ 'yi. 'Bhɛɛ‑ ‑e ‑can ‑gɔli' 'taŋbha mu 'ɛ ꞊naa ‑yaa yewonɛ mu 'la ni, ‑e 'mu 'kpɛn ‑siila, 'bhɛɛ‑ ‑o ‑za yɛkɛ‑ mu 'la ꞊kla 'yee‑ ‑gɔli' mu 'ɛ 'le, ‑o 'mu 'yipia‑ ‑a ni. ");
INSERT INTO moa_vpl VALUES ("LK19_16","072_19_16","LUK","19","16","16","‑A lwa mi 'ɛ 'bhɛ 'nule‑, 'ke 'bhɛ 'a 'pele dɔɔ: ‹'Ŋ Zan, 'e ‑can ‑gɔli' 'taŋbha do 'la ꞊naa 'mi ni, 'mi ‑gɔli' 'taŋbha 'bhɛɛke vu ‑srɔɔwoa 'bhɛ ma ‑trɔn 'le.› ");
INSERT INTO moa_vpl VALUES ("LK19_17","072_19_17","LUK","19","17","17","'Yee‑ ‑bhleŋgbe 'ɛ pe 'bhɛ yewonɛ 'ɛ ni dɔɔ: ‹'Ŋ 'cie oo 'ŋ 'cie‑! Yewonɛ 'lrele‑. 'Yee‑ zru ‑kla do ‑za 'fiɛntrɔnnɛ mu 'yi, 'bhɛla‑ ‑yile, 'mi nu 'e klɛlɛ ‑wa vu ta ‑janmatii 'le.› ");
INSERT INTO moa_vpl VALUES ("LK19_18","072_19_18","LUK","19","18","18","‑A plɛ mi 'ɛ 'bhɛ 'nule‑, 'ke 'bhɛ 'a 'pele dɔɔ: ‹'Ŋ Zan, 'e ‑can ‑gɔli' 'taŋbha do 'la ꞊naa 'mi ni, 'mi ‑gɔli' 'taŋbha 'bhɛɛke 'soo 'srɔɔwoa‑ 'bhɛ ma ‑trɔn 'le.› ");
INSERT INTO moa_vpl VALUES ("LK19_19","072_19_19","LUK","19","19","19","‑Bhleŋgbe 'ɛ pe 'bhɛ ni dɔɔ: ‹'Ŋ 'cie oo 'ŋ 'cie‑! 'Ŋ nu 'bhi klɛlɛ ‑wa 'soo ta ‑janmatii 'le.› ");
INSERT INTO moa_vpl VALUES ("LK19_20","072_19_20","LUK","19","20","20","‑A yaga mi 'ɛ 'nule, 'ke 'bhɛ 'a 'pele dɔɔ: ‹'Ŋ Zan, 'e ‑can ‑gɔli' 'taŋbha do 'la ꞊naa 'mi ni, 'yele‑ ‑gɛ, 'an magaanna sɔ 'peenɛ do 'yi. ");
INSERT INTO moa_vpl VALUES ("LK19_21","072_19_21","LUK","19","21","21","'Ŋ ‑gblaanna 'e 'lɛɛ, ‑amasrɔyi 'yaa‑ ‑za 'yi ‑o 'eglɔɔle. 'Yaa‑ pɛ laa ‑o pɛ 'la 'le, 'e 'bhɛɛ‑ si. 'Yaa gba 'la 'kpalɛ‑, 'e 'bhɛɛ‑ 'yi pɛbhaa kan.› ");
INSERT INTO moa_vpl VALUES ("LK19_22","072_19_22","LUK","19","22","22","'Bhɛ klɛle 'tɛ, 'ke ‑bhleŋgbe 'ɛ ‑ya pele‑ ‑a ni dɔɔ: ‹Yewonɛ 'yɔɔ‑, 'ŋ nu 'e 'kunlɛ‑ 'e 'gbu 'liijan‑ ma. 'Ya 'yaango‑ bi 'bhii‑ 'an ‑za 'yi ‑o 'eglɔɔle, 'bhɛɛ‑ 'an pɛ laa ‑o pɛ 'la 'le 'ŋ 'bhɛɛ‑ si. 'Bhɛɛ‑ 'naa gba 'la 'kpalɛ‑, 'ŋ 'bhɛɛ‑ 'yi pɛbhaa kan. ");
INSERT INTO moa_vpl VALUES ("LK19_23","072_19_23","LUK","19","23","23","‑Mɛle ꞊kla 'bhɛɛ‑ 'yaa 'an ‑gɔli' 'ɛ 'kpalɛ‑ ‑gɔli' magaan 'fɛ 'ɛ ꞊la ɛɛ, 'kooko‑ 'ke 'ŋ ‑daa 'an 'taa 'ɛ ta 'waati 'la ba, 'ŋ 'yaa‑ sɔ ‑a ma ‑trɔn 'yele ɛɛ?› ");
INSERT INTO moa_vpl VALUES ("LK19_24","072_19_24","LUK","19","24","24","'Bhɛɛ‑ ‑bhleŋgbe 'ɛ pe mɛɛ 'la zan mu dulale ‑yaa ‑a ‑din 'mu ni dɔɔ: ‹‑Kaa 'kɔɔ ‑can ‑gɔli' 'taŋbha do 'ɛ 'kun, 'bhɛɛ‑ ‑ka 'bhɛ 'na 'taŋbha vu zan 'ɛ ni.› ");
INSERT INTO moa_vpl VALUES ("LK19_25","072_19_25","LUK","19","25","25","'Bhɛ mɛɛ mu 'ɛ pe ‑a ni dɔɔ: ‹'O Zan, 'taŋbha vu ‑o 'bhɛ 'kɔɔ gban.› ");
INSERT INTO moa_vpl VALUES ("LK19_26","072_19_26","LUK","19","26","26","‑Bhleŋgbe 'ɛ pe ‑o ni dɔɔ: ‹'Mi 'bhɛ 'yaango‑, 'bhɛɛ‑ 'mi pe 'ka ni dɔɔ pɛ ‑o mɛɛ 'la zan 'kɔɔ, ‑o nu ‑a 'kɔɔpɛ‑ 'ɛ baankpalɛ, 'bhɛɛ‑ pɛ 'kedo‑ 'kpɔ 'laa ‑o mɛɛ 'la zan 'kɔɔ, 'ali‑ ‑o nu ‑a 'kɔɔpɛ‑ sanɛ‑ 'ɛ 'bhɛ 'kunlɛ‑. ");
INSERT INTO moa_vpl VALUES ("LK19_27","072_19_27","LUK","19","27","27","Mɛɛ 'la zan mu ‑o 'ŋ 'sɔɔnnii mu 'le 'bhɛɛ‑ waa ‑a zi 'bhii‑ 'ŋ klɛ ‑o ta ‑bhleŋgbe 'le, ‑ka nu 'mu ‑le, 'bhɛɛ‑ 'ka ‑o 'kpɛn dɛ 'ŋ 'yrɛ ma ‑gɛ.›» ");
INSERT INTO moa_vpl VALUES ("LK19_28","072_19_28","LUK","19","28","28","Zesu 'yanle‑ 'bhɛ ‑jan mu 'ɛ 'wolele, 'kee dɔle‑ ‑zamaa' 'ɛ ‑lɛɛ Zeruzalɛmu 'taa 'ɛ ta. ");
INSERT INTO moa_vpl VALUES ("LK19_29","072_19_29","LUK","19","29","29","‑O bhɔle Bɛtifaze 'pegee Betani ‑wa mu 'ɛ ‑din, ‑o ‑yaa vlɛ gɔɔn 'la sii Olivi diiŋ vlɛ gɔɔnɛ‑ 'bhɛ ‑din bhla 'la ba, 'kee‑ yaa ‑klaŋlanɛ plɛ winbɔle ‑o ‑lɛɛ. ");
INSERT INTO moa_vpl VALUES ("LK19_30","072_19_30","LUK","19","30","30","‑E pe 'mu ni dɔɔ: «‑Ka ge ‑kɔɔ' 'lɛɛ ‑wa 'nɛ 'la bhe ‑a ta. 'Ke 'ka ꞊bhwa ‑a nɔɔ‑, 'ka nu ‑soofalinɛ do ‑yrele' yelɛ ‑yri diiŋ do ma, mɛɛ ‑bhɛɛke' do 'kpɔ 'laa 'sanlɛ‑ ‑lido' ‑a ta. 'Kaa‑ 'ploo‑ ‑yri 'ɛ ma, 'bhɛɛ‑ ‑ka nu 'kɛle‑. ");
INSERT INTO moa_vpl VALUES ("LK19_31","072_19_31","LUK","19","31","31","'Ke mɛɛ 'la 'ka 'lrɔkpaa‑ dɔɔ 'kaa‑ 'ploo zii' ‑mɛla ma, ‑kaa pe 'bhɛ zan ni dɔɔ: ‹Mɛɛzan maza ‑o ‑a ma.›» ");
INSERT INTO moa_vpl VALUES ("LK19_32","072_19_32","LUK","19","32","32","‑Yaa' *winbɔwo mu 'ɛ ‑o gele, 'ke ‑o ‑za mu 'ɛ 'kpɛn 'lɛsɔle yele‑ 'bhii‑ Zesu ‑o 'kpeelɛkaan gɔnɛ‑ 'la gbɛɛn‑. ");
INSERT INTO moa_vpl VALUES ("LK19_33","072_19_33","LUK","19","33","33","‑O ‑yaa ‑soofalinɛ 'ɛ 'ploo zii' bhla 'la ba, 'ke bhɛ zan mu ‑o ‑lrɔkpale dɔɔ: «‑Mɛle ꞊kla 'bhɛɛ 'ka ‑o 'yee‑ ‑soofalinɛ 'lɛɛ‑ 'ploo zii' ɛɛ?» ");
INSERT INTO moa_vpl VALUES ("LK19_34","072_19_34","LUK","19","34","34","‑O pe 'mu ni dɔɔ: «Mɛɛzan maza ‑o ‑a ma.» ");
INSERT INTO moa_vpl VALUES ("LK19_35","072_19_35","LUK","19","35","35","'Bhɛ klɛle 'tɛ, 'ke ‑o nule‑ ‑soofalinɛ 'ɛ 'le Zesu ni. ‑O ‑waa' dunɛ‑ mu 'ɛ 'ke ꞊klaa 'bhɛ kpoo ta, 'bhɛɛ‑ 'ke ‑o Zesu 'sanle 'bhɛ ta. ");
INSERT INTO moa_vpl VALUES ("LK19_36","072_19_36","LUK","19","36","36","‑Soofalinɛ 'ɛ 'yaa‑ ge 'zi Zesu 'le, 'bhɛɛ‑ mɛɛ mu 'ɛ ꞊yaa waa dunɛ‑ ‑gbɛnɛ mu 'ɛ 'piila‑ 'zi ‑a ‑lɛɛ zi 'ɛ 'lii. ");
INSERT INTO moa_vpl VALUES ("LK19_37","072_19_37","LUK","19","37","37","‑O bhɔle Zeruzalɛmu ‑din bhla 'la ba, 'ke ‑o kan zi 'la 'bhɛ 'yaa‑ kan Olivi diiŋ vlɛ gɔɔn 'ɛ ‑din, 'ke zrukpaa' ‑gbɛnɛ do zinale ‑yaa' ‑klaŋlanɛ mu 'ɛ 'kpɛn ta, 'bhɛɛ‑ ‑Waanbhaa' 'sɔle‑ maza mu 'la 'kpɛn ꞊kla ‑o ‑yrɛ ma, 'ke ‑o 'bhɛ 'pubɔle 'mu 'kpɛn ma. ");
INSERT INTO moa_vpl VALUES ("LK19_38","072_19_38","LUK","19","38","38","‑O ‑yaa pe 'zi dɔɔ: «‑Bhleŋgbe 'la ‑yoo zan Mɛɛzan ‑Waanbhaa' 'tɔ 'yi, bhaa ‑Waanbhaa' 'a ‑dɔɔbo'!» «Bhaa yilabla klɛ laflɛ' 'yi, 'bhɛɛ‑ 'tɔbhɔleya bo laanima ‑Waanbhaa' ni.» ");
INSERT INTO moa_vpl VALUES ("LK19_39","072_19_39","LUK","19","39","39","Farizi mu 'kɛ mu 'la 'yaa‑ ‑zamaa' 'ɛ 'pleŋ‑, 'mu pe Zesu ni dɔɔ: «'O Daan mi, ‑a pe 'yaa‑ ‑klaŋlanɛ mu 'ɛ ni dɔɔ ‑woo taga.» ");
INSERT INTO moa_vpl VALUES ("LK19_40","072_19_40","LUK","19","40","40","'Bhɛ 'yi, 'ke Zesu 'a 'pele ‑o ni 'kaa: «'Mi pe 'ka ni dɔɔ 'ke ‑woo tagaa‑, kpoti mu nu ‑welɛ' 'eglɔɔle.» ");
INSERT INTO moa_vpl VALUES ("LK19_41","072_19_41","LUK","19","41","41","Zesu 'bhɔle‑ Zeruzalɛmu ‑wa 'ɛ ‑din, 'bhɛɛ‑ ‑a ‑yrɛkpale ‑a ma, 'kee‑ wisile ‑a ta. ");
INSERT INTO moa_vpl VALUES ("LK19_42","072_19_42","LUK","19","42","42","‑E pe dɔɔ: «'Ee, Zeruzalɛmu! ‑Za 'la 'bhɛ sɔ yilabla 'nale 'e ni, 'kee ꞊yaa sɔ 'bhɛ dɔle‑ ‑zɔn bi. 'Duŋ‑ ‑a gaanle ‑o 'e 'lɛɛ, 'yaa sɔ ‑a yele‑. ");
INSERT INTO moa_vpl VALUES ("LK19_43","072_19_43","LUK","19","43","43","'Bhɛ yi ‑o zan bhɔlɛ, 'e 'sɔɔnnii mu nu 'fɛgwlɛ‑ mu dɔlɛ 'e zi, 'bhɛɛ‑ 'mu nu 'yaa‑ ‑wa 'ɛ 'kunlɛ‑. ‑O nu 'mliŋgolɛ 'e zi, 'bhɛɛ‑ ‑o nu 'e ta mu 'ɛ 'yrɛbatɛdɔlɛ yrɛkpɛn‑ ꞊nɔɔ. ");
INSERT INTO moa_vpl VALUES ("LK19_44","072_19_44","LUK","19","44","44","‑O nu 'yaa‑ 'fɛ mu 'ɛ 'kpɛn 'wilɛ‑ 'feŋfeŋ, 'bhɛɛ‑ ‑wa ‑dwa vlɛ mu 'la 'le 'mu do 'kpɔ 'kpaale‑ laa nu bolɛ‑ 'eke‑ ta. 'Bhɛɛ‑ ‑o nu 'yaa‑ ‑wa 'ɛ ta mɛɛ mu 'ɛ 'kpɛn dɛlɛ, ‑amasrɔyi ‑Waanbhaa' ꞊nwa bhɔlɛ 'e ba 'waati 'la ba, 'yaa 'bhɛ 'waati 'ɛ 'yidɔlɛ!» ");
INSERT INTO moa_vpl VALUES ("LK19_45","072_19_45","LUK","19","45","45","Zesu ‑ja wlalɛ ‑Waanbhaa' Gba 'Fɛ ‑Gbɛnɛ 'ɛ ꞊la, 'kee 'plɛɛgɔn‑ mu 'ɛ ‑gbinle' 'sanle. ");
INSERT INTO moa_vpl VALUES ("LK19_46","072_19_46","LUK","19","46","46","‑E pe ‑o ni dɔɔ: «‑Waanbhaa' 'a ꞊pia ‑yaa' 'Sɛwɛ 'ɛ 'yi dɔɔ: ‹'An 'fɛ 'ɛ nu klɛlɛ 'seriwo 'fɛ ‑la ‑le, 'duŋ‑ 'ka mu 'a ꞊kla 'ke ‑faannii' mu gaan 'fɛ 'le!›» ");
INSERT INTO moa_vpl VALUES ("LK19_47","072_19_47","LUK","19","47","47","Yi 'oo yi, Zesu 'yaa‑ mɛɛ mu daan ‑Waanbhaa' Gba 'Fɛ ‑Gbɛnɛ 'ɛ ꞊la. 'Bhɛɛ‑ 'sraka 'lɛna ‑kuŋlii mu 'ɛ 'pegee 'Toŋ daan mu 'ɛ 'bhɛɛ‑ Zuufu mu ‑lɛɛ mu ‑gbɛnɛ mu 'ɛ 'mu 'yaa‑ Zesu dɛyrɛ ‑la ‑glin 'zi. ");
INSERT INTO moa_vpl VALUES ("LK19_48","072_19_48","LUK","19","48","48","'Duŋ‑ ‑wa klɛ gɔnɛ‑ 'la gbɛɛn‑ 'bhɛɛ‑ ‑wa kun, waa ‑yaa 'bhɛ dɔ; ‑amasrɔyi Zesu 'wojan‑ mu 'ɛ 'bhɛ mu mɛɛ mu 'ɛ 'kpɛn zru 'ɛ ꞊kwan, 'bhɛɛ‑ ‑o 'kpɛn 'yaa‑ ‑o 'trɔnkpa zii' ‑a ni. ");
INSERT INTO moa_vpl VALUES ("LK20_1","072_20_1","LUK","20","1","1","‑Yrekpaa' do, Zesu 'yaa‑ mɛɛ mu 'ɛ daan 'zi 'bhɛɛ‑ ‑e ‑yaa ‑Waanbhaa' ‑Jan 'Nrale‑ 'ɛ 'wo zii' ‑Waanbhaa' Gba 'Fɛ ‑Gbɛnɛ 'ɛ ꞊la 'waati 'la ba, 'ke 'sraka 'lɛna ‑kuŋlii mu 'pegee *'Toŋ daan mu 'ɛ, 'bhɛɛ‑ Zuufu mu a 'gwlaan gblaan mu 'ɛ 'nule 'tɛnlɛ‑ ‑a ma. ");
INSERT INTO moa_vpl VALUES ("LK20_2","072_20_2","LUK","20","2","2","'Bhɛɛ‑ ‑wa ‑lrɔkpaa dɔɔ: «'E ‑za mu 'la klɛ 'zi, ‑dele pe 'e ni dɔɔ 'yoo‑ klɛ ɛɛ? 'Bhɛɛ‑ ‑dele ‑o klɛ 'seŋ ꞊naa 'e ni ɛɛ?» ");
INSERT INTO moa_vpl VALUES ("LK20_3","072_20_3","LUK","20","3","3","'Bhɛ klɛle 'tɛ, 'ke Zesu 'a 'pele ‑o ni dɔɔ: «'Mi ‑o zan 'ka mu ‑lrɔkpalɛ 'ezin‑ dɔɔ: ");
INSERT INTO moa_vpl VALUES ("LK20_4","072_20_4","LUK","20","4","4","‑Ka 'bhɛ zikpa' 'ŋ ni, ‑dele Mɛɛ Wiiŋfɛ' Mi Zaan 'winbwa‑ mɛɛ mu 'wiiŋfɛyrɛ nɔɔ‑ ‑yi ba, ‑Waanbhaa' taa‑ bhaaplɛŋ mu ɛɛ?» ");
INSERT INTO moa_vpl VALUES ("LK20_5","072_20_5","LUK","20","5","5","'Bhɛ 'yi, 'ke ‑o zaabɔle 'sanle 'eke‑ pleŋ‑ dɔɔ: «'Ke 'wa ꞊pia ‑a ni 'kaa ‹‑Waanbhaa' ‑le 'a 'winbwa‑›, ‑e nu 'o 'lrɔkpalɛ dɔɔ ‑mɛla ma 'bhɛɛ‑ ‑kɔɔ' 'laa ‑kɔɔ' 'kpalɛ‑ ‑a ‑yi ɛɛ? ");
INSERT INTO moa_vpl VALUES ("LK20_6","072_20_6","LUK","20","6","6","'Bhɛɛ‑ 'ke 'wa ꞊pia dɔɔ mɛɛ mu ‑le 'a 'winbwa‑, ‑kɔɔa' mɛɛ mu 'ɛ nu ‑kɔɔ' dɛyrɛ ‑glinlɛ' kpoti 'le. ‑Amasrɔyi ‑o 'kpɛn 'kpale‑ ‑o ‑a ‑yi 'bhii‑ Zaan ‑o 'ke ‑Waanbhaa' ‑lɛla' janwo mi do 'le.» ");
INSERT INTO moa_vpl VALUES ("LK20_7","072_20_7","LUK","20","7","7","'Bhɛla‑ ‑yile, 'ke ‑wa pele‑ dɔɔ: «Mɛɛ 'la zan 'a 'winbwa‑ 'o mɔɔ laa 'bhɛ zan 'ɛ dɔ.» ");
INSERT INTO moa_vpl VALUES ("LK20_8","072_20_8","LUK","20","8","8","'Bhɛ 'yi, 'ke Zesu 'a 'lɛkunle ‑o ni dɔɔ: «'Duŋ‑ 'kee‑ ꞊kla 'bhɛ gbɛɛn‑ bhe, 'mi 'ezin‑, mɛɛ 'la zan ‑za mu 'lɛɛ‑ klɛ 'seŋ ꞊naa 'mi ni, 'naa nu 'bhɛ zan 'ɛ 'tɔkanlɛ 'ka ni.» ");
INSERT INTO moa_vpl VALUES ("LK20_9","072_20_9","LUK","20","9","9","'Bhɛ blaan, 'ke Zesu ‑gɔɔn 'lɛɛ‑ 'bhɛ bɔle 'sanle mɛɛ mu 'ɛ ni, 'bhɛɛ‑ ‑e pe ‑o ni dɔɔ: «Mɛɛ do ‑drɔɔ gba do ‑kpaa, 'bhɛɛ‑ ‑ya gbɛkpaa‑ yetanɛ mu 'kɔɔ‑. 'Bhɛ blaan, 'kee‑ gele‑ 'taa do ta, 'bhɛɛ‑ ‑e ꞊mwa 'bhɛ ꞊nɔɔ ye. ");
INSERT INTO moa_vpl VALUES ("LK20_10","072_20_10","LUK","20","10","10","‑Woo 'bhɛ 'yi bhe, ‑drɔɔ bhaa 'kan bhla 'ɛ 'bhɔle‑, 'kee‑ ‑yaa' 'fɛ ꞊la yewonɛ mu 'ɛ do winbɔle ‑yaa' gba 'ɛ ta yetanɛ mu 'ɛ zi, ‑yaa' pɛ ‑drɔɔ bhaa 'si zayi'. 'Duŋ‑ 'woo‑ yetanɛ mu 'ɛ ‑o ‑yaa' yewonɛ 'ɛ ꞊kwan, 'bhɛɛ‑ ‑wa tafia꞊; 'bhɛɛ‑ ‑o ‑ploola ‑a ma ‑a 'kɔɔfleŋ‑ 'le. ");
INSERT INTO moa_vpl VALUES ("LK20_11","072_20_11","LUK","20","11","11","'Bhɛ blaan, 'ke ‑drɔɔ gbazan 'ɛ ‑e ‑yaa' yewonɛ 'ɛ 'bhɛɛke do winbɔle yetanɛ mu 'ɛ zi ezin‑. 'Duŋ‑ 'bhɛ 'bhɔle‑ ‑o ta, 'ke ‑o 'bhɛ tafɛle 'ezin‑, ‑o 'bhɛ ‑zwanwoa, 'bhɛɛ‑ 'ke ‑o 'ploole 'bhɛ 'kɔɔfleŋ‑ 'ɛ ma. ");
INSERT INTO moa_vpl VALUES ("LK20_12","072_20_12","LUK","20","12","12","'Bhɛ blaan, 'ke 'yee‑ ‑drɔɔ gbazan 'ɛ ‑e ‑yaa' yewonɛ mu 'ɛ yaga mi winbɔle ‑o ta 'ezin‑. ‑O 'bhɛ madiŋgwa, 'ke ‑o gele‑ 'bhɛ blinlɛ gba 'ɛ bhlemazi. ");
INSERT INTO moa_vpl VALUES ("LK20_13","072_20_13","LUK","20","13","13","'Bhɛ blaan, 'ke gbazan 'ɛ ‑ya pele‑ dɔɔ: ‹'An klɛ 'nale‑ ‑a ma ɛɛ? 'Ŋ nu 'ŋ gbe bhɛ do 'la ‑za sɔ 'ŋ ni 'egbɛnɛle 'bhɛ winbɔlɛ ‑o ta, ‑dɔke' ‑o nu ‑gasikpalɛ 'bhɛ 'lɛɛ oo.› ");
INSERT INTO moa_vpl VALUES ("LK20_14","072_20_14","LUK","20","14","14","'Duŋ‑ 'woo‑ yetanɛ mu 'ɛ ‑o ‑yrɛkpale 'bhɛ ma, 'ke ‑wa pele‑ 'eke‑ ni dɔɔ: ‹Mɛɛ 'lɛɛ‑ 'bhɛ ‑le nu klɛlɛ gbazan 'ɛ 'le boolazi ‑a dɛ gale blaan. ‑Ayile ‑kɔɔ' 'a dɛ, 'bhɛɛ‑ ‑drɔɔ gba 'ɛ bo ‑kɔɔ ni.› ");
INSERT INTO moa_vpl VALUES ("LK20_15","072_20_15","LUK","20","15","15","'Bhɛla‑ ‑yile, 'ke ‑wa 'kunle, 'bhɛɛ 'ke ‑o gele‑ 'kɛle‑ gba 'ɛ ‑zanta', 'bhɛɛ‑ 'ke ‑wa dɛle‑.» Zesu ‑zamaa' 'ɛ 'lrɔkpaa‑ dɔɔ: «'Ka mu 'kpee ma, gbazan 'ɛ nu ‑mɛ za ‑la klɛlɛ 'woo‑ yetanɛ mu 'ɛ ni ɛɛ? ");
INSERT INTO moa_vpl VALUES ("LK20_16","072_20_16","LUK","20","16","16","'Ŋ bhe, ‑e nu 'woo‑ yetanɛ mu 'ɛ 'kpɛn dɛlɛ, 'bhɛɛ‑ ‑e ‑drɔɔ gba 'ɛ gbɛkpa yetanɛ mu ‑bhɛɛke' mu 'kɔɔ.» Mɛɛ mu 'ɛ ‑o 'bhɛ ‑jan 'ɛ 'male‑ 'ke ‑wa pele‑ dɔɔ: «'Ee, bhaa 'bhɛ 'yansi za 'ɛ 'kan 'o ma 'egbɔɔnle.» ");
INSERT INTO moa_vpl VALUES ("LK20_17","072_20_17","LUK","20","17","17","Zesu 'e 'yrɛkpale ‑o ta frii, 'ke ‑yoo ‑lrɔkpale dɔɔ: «‑Waanbhaa' a ‑jan 'lɛɛ‑, 'bhɛ 'yi ‑o 'nale‑ ‑a ma ɛɛ? 'Bhɛ ‑jan 'ɛ 'yele‑ ‑gɛ: ‹'Fɛdɔ‑ mu 'ɛ ‑woo ‑baŋgwa vlɛ 'la 'yi 'bhɛɛ‑ ‑wa ‑blinna, 'bhɛ ‑le ꞊kla 'fɛgwlɛ‑ 'ɛ gaan ‑la vlɛ ‑kpuŋ ‑gbɛnɛ 'gbu 'ɛ.›» ");
INSERT INTO moa_vpl VALUES ("LK20_18","072_20_18","LUK","20","18","18","«'Ke mɛɛ 'oo mɛɛ 'la zan ‑balaa' 'yee‑ vlɛ 'lɛɛ‑ ta, 'bhɛ zan ma diiŋ nu golɛ. 'Bhɛɛ‑ 'kee‑ ‑balaa' mɛɛ 'la zan ta, ‑e nu 'bhɛ zan 'wiilɛ‑.» ");
INSERT INTO moa_vpl VALUES ("LK20_19","072_20_19","LUK","20","19","19","'Bhɛ 'waati do 'kpɔ 'ɛ ba, 'Toŋ daan mu 'ɛ 'pegee 'sraka 'lɛna ‑kuŋlii mu 'yaa‑ zi 'bhii‑ ‑o Zesu 'kun. ‑Amasrɔyi ‑wa 'yaangwa‑ 'bhii‑, Zesu ‑gɔɔn 'ɛ ꞊bwa 'wo ‑la ma. 'Duŋ‑ ‑o ‑yaa ‑gblaan 'zi ‑zamaa' 'ɛ 'lɛɛ. ");
INSERT INTO moa_vpl VALUES ("LK20_20","072_20_20","LUK","20","20","20","‑A 'san 'bhɛ yi 'ɛ ma, ‑o ‑yaa Zesu 'klɔsikun zii' 'bhɛ klɛza mu 'ɛ ma. ‑Ayile 'ke ‑o mɛɛ mu winbɔle ‑a zi. 'Bhɛ mɛɛ mu 'ɛ 'yaa‑ 'mu 'gbu klɛ 'zi mɛɛ ‑lrele' mu 'le ‑dawli' ma. 'Bhɛ mu ‑ja bɔlɛ ‑a ‑la, 'kooko‑ 'mu sɔ ‑a 'kunle ‑a 'gbu 'liiwli‑ ma. 'Bhɛɛ‑ 'ke 'mu 'a ꞊kwan 'mu sɔ gele‑ 'kɛle‑ 'kitikan mu 'ɛ 'pegee ‑waa' ‑janmatii 'ɛ ba. ");
INSERT INTO moa_vpl VALUES ("LK20_21","072_20_21","LUK","20","21","21","‑Ayile 'ke ‑o nule‑ Zesu 'lrɔkpalɛ dɔɔ: «'O Daan mi, 'wa 'yaango‑ dɔɔ 'e 'yoo‑ ‑jan 'la 'wo zii' 'bhɛ 'pegee 'yoo‑ mɛɛ daan mu 'zi 'ke ‑za 'la 'le, wlan ‑le 'mu 'kpɛn 'le. 'Yaa mɛɛ bago, 'bhɛɛ‑ 'e ‑Waanbhaa' a zi 'ɛ 'bhɛɛ‑ daan wlan 'gbu ma kpataakpa. ");
INSERT INTO moa_vpl VALUES ("LK20_22","072_20_22","LUK","20","22","22","'Woo ‑za do ‑yilrɔkpale 'e ma doo: ‑Kɔɔa' 'toŋ‑ 'ɛ ta, ‑kɔɔ' sɔ taa‑ ‑kɔɔ' 'laa sɔ *Romɛ mu 'ɛ ‑waa' ‑bhleŋgbe ‑gbɛnɛ Sezaa a 'nisra 'ɛ gbawole ɛɛ?» ");
INSERT INTO moa_vpl VALUES ("LK20_23","072_20_23","LUK","20","23","23","'Duŋ‑ Zesu waa ‑dawli' maza 'ɛ dɔle, 'ke ‑ya pele‑ ‑o ni dɔɔ: «‑Ka nu ‑gɔli' 'taŋbha do 'le 'ŋ ni doo.» ");
INSERT INTO moa_vpl VALUES ("LK20_24","072_20_24","LUK","20","24","24","‑O nule 'bhɛ 'taŋbha 'ɛ 'le ‑a ni, 'ke ‑yoo ‑lrɔkpale dɔɔ: «‑Dela ŋgblo lii 'pegee ‑a 'tɔ yɔɔndɛle ‑gɛ ɛɛ?» ‑O 'kpɛn pe dɔɔ: «Romɛ mu a ‑bhleŋgbe ‑gbɛnɛ 'bhɛ ‑le 'kɛle‑.» ");
INSERT INTO moa_vpl VALUES ("LK20_25","072_20_25","LUK","20","25","25","'Bhɛ klɛle 'tɛ, 'ke Zesu 'a 'pele ‑o ni dɔɔ: «'Ke ‑yoo 'bhɛ gbɛɛn‑ bhe, 'kɛla 'bhɛ ‑o Sezaa a pɛ ‑o 'le, ‑ka 'bhɛɛ‑ gbawo 'bhɛ ni, 'bhɛɛ‑ ‑Waanbhaa' a pɛ ‑o 'kɛla 'le ‑ka 'bhɛ 'na 'bhɛ ni.» ");
INSERT INTO moa_vpl VALUES ("LK20_26","072_20_26","LUK","20","26","26","'Ali‑ 'woo‑ mɛɛ mu 'ɛ waa 'sɔlɛ‑ Zesu 'kunle 'bhɛ 'gbu 'liiwli‑ 'ɛ ma. Drɔɔn' ‑a wojan mu 'ɛ ‑yoo ‑liibhaala ‑o ma. ‑Ayile waa 'sɔlɛ‑ ‑jan 'kedo‑ 'kpɔ 'wole, 'bhɛɛ‑ ‑o tagale ꞊bwa. ");
INSERT INTO moa_vpl VALUES ("LK20_27","072_20_27","LUK","20","27","27","‑O ‑yaa mɛɛ 'ke mu sii *Saduse mu, ‑o 'si ta waa ‑yaa ‑o kpa mɛɛ bweza gale ba 'ɛ 'yi. ‑O ‑yaa pe dɔɔ 'ke mɛɛ ‑gaa 'ke ‑za 'kpɛn ꞊yaan. ‑Yrekpaa' do, ‑o 'ke mu ‑o mabɛɛnna Zesu ‑din, 'ke ‑o 'bhɛ 'lrɔkpale dɔɔ: ");
INSERT INTO moa_vpl VALUES ("LK20_28","072_20_28","LUK","20","28","28","«'O Daan, Moizi 'a yɔɔndia‑ ‑yaa' 'toŋ 'sɛwɛ 'ɛ 'yi dɔɔ: 'Ke mɛɛ do ꞊kla 'ke 'siɛle‑, 'bhɛɛ‑ 'ke ‑ya na ‑twa ‑a blaan, 'bhɛɛ‑ 'ke yaa ‑nɛ 'yalɛ‑ 'bhɛ ta. ‑A gaanzidɔ dɔ 'ɛ 'gwlaan‑ 'ɛ 'bhɛ 'a na yalaa'. 'Ke 'bhɛ ꞊kla bhe, 'ke 'bhɛ ‑nɛ mu 'la ꞊yaa ‑a na ta, 'mu nu klɛlɛ 'bhii‑ ‑a 'gbu 'kpee 'yi mu. ");
INSERT INTO moa_vpl VALUES ("LK20_29","072_20_29","LUK","20","29","29","'Bhɛ 'laa 'sanlɛ‑ bhaama, nɛɛnɛ‑ ma 'gwlaan‑ 'srwaplɛ‑ ‑yaa. ‑O ‑lɛɛ mi 'ɛ 'bhɛ le 'la ꞊sia 'bhɛ 'laa ‑nɛ 'srɔɔwolɛ 'bhɛ ta, 'bhɛɛ‑ 'bhɛ ꞊kla 'ke 'siɛle. ");
INSERT INTO moa_vpl VALUES ("LK20_30","072_20_30","LUK","20","30","30","'Bhɛ gaanzidɔ dɔ 'ɛ, 'bhɛ glaanle 'ɛ ꞊sia, 'bhɛ 'laa ‑nɛ 'srɔɔwolɛ ‑a ta, 'bhɛɛ‑ 'ke 'bhɛ gale‑. ‑A gaanzidɔ dɔ yaga mi 'ɛ, 'bhɛ ꞊kla 'yee‑ klɛgbɛya do 'kpɔ 'ɛ 'yela‑ gbɛɛn‑. ");
INSERT INTO moa_vpl VALUES ("LK20_31","072_20_31","LUK","20","31","31","'Woo‑ nɛɛnɛ‑ 'gwlaan 'srwaplɛ‑ ‑o 'kpɛn 'yee‑ le 'ɛ 'yalaa do do, 'bhɛɛ‑ ‑o 'kpɛn ꞊kla 'ke 'siɛle‑ do do 'ke waa ‑nɛ 'srɔɔwo‑ ‑a ta. ");
INSERT INTO moa_vpl VALUES ("LK20_32","072_20_32","LUK","20","32","32","‑O 'kpɛn gale blaan, 'ke 'yee‑ le 'ɛ 'gbu klɛle‑ 'ke 'siɛle 'ezin‑. ");
INSERT INTO moa_vpl VALUES ("LK20_33","072_20_33","LUK","20","33","33","'Bhɛ ya 'ɛ 'yi, 'ke gbaa mu ‑bwela gale ba yi 'la 'le, 'woo nɛɛnɛ‑ ma 'gwlaan‑ 'srwaplɛ‑ 'ɛ ‑o ‑de 'gbu ‑la na nu klɛlɛ 'yee‑ le 'ɛ 'le ɛɛ?» ");
INSERT INTO moa_vpl VALUES ("LK20_34","072_20_34","LUK","20","34","34","'Bhɛ klɛle 'tɛ, 'ke Zesu 'a 'pele ‑o ni dɔɔ: «Gwlɛnna yaale ‑o 'gwlaan‑ mu 'pegee le mu pleŋ‑ 'drunyan 'lɛɛ‑ 'bhɛɛ‑ ‑yi. ");
INSERT INTO moa_vpl VALUES ("LK20_35","072_20_35","LUK","20","35","35","'Duŋ‑ 'ke ‑Waanbhaa' 'a 'lɛdulaa dɔɔ mɛɛ 'la zan mu bwe gale ba, 'bhɛɛ‑ 'drunyan 'la 'bhɛ ‑o zan ‑o bo 'bhɛ 'yi, waa nu le mu nalɛ gwlɛn ni, 'bhɛɛ‑ 'gwlaan‑ mu laa nu le 'silɛ‑. ");
INSERT INTO moa_vpl VALUES ("LK20_36","072_20_36","LUK","20","36","36","Waa nu 'sɔlɛ‑ gale‑ ‑li, 'bhɛɛ‑ ‑o nu klɛlɛ 'bhii‑ ‑Waanbhaa' a ‑mlɛkɛ' mu 'ɛ gbɛɛn‑. ‑O nu klɛlɛ ‑Waanbhaa' ‑nɛ mu 'le, waa nu galɛ ‑li ‑titi, ‑amasrɔyi ‑o ‑bwela gale ba. ");
INSERT INTO moa_vpl VALUES ("LK20_37","072_20_37","LUK","20","37","37","*Moizi 'a ꞊pia kpataakpa dɔɔ gbaa mu nu bwelɛ gale ba. ‑Yaa' 'sɛwɛ 'ɛ 'yi yrɛ 'la ‑yri lunɛ‑ 'ɛ ba janwo, Moizi Mɛɛzan ‑Waanbhaa' ‑siila dɔɔ: Abraamu a ‑Waanbhaa', 'bhɛ 'pegee Izaki a ‑Waanbhaa', 'bhɛɛ‑ Zakɔbu a ‑Waanbhaa'. ");
INSERT INTO moa_vpl VALUES ("LK20_38","072_20_38","LUK","20","38","38","‑Amasrɔyi, ‑Waanbhaa' ‑o 'ke mɛɛ ‑yrɛ male mu a ‑Waanbhaa' ‑la ‑le, 'bhɛɛ‑ yaa ‑o 'ke gbaa mu a ‑Waanbhaa' 'le. 'Bhɛɛ‑ mɔkpɛn' ‑o 'mu 'yrɛ ma ‑Waanbhaa' ‑yrɛ 'yi.» ");
INSERT INTO moa_vpl VALUES ("LK20_39","072_20_39","LUK","20","39","39","'Bhɛ klɛle 'tɛ, 'ke 'Toŋ daan mu 'ɛ 'ke mu 'a 'pele ‑a ni dɔɔ: «'O Daan mi, 'e 'swa‑ ‑jan 'ɛ zikpale ‑o ni 'elrele.» ");
INSERT INTO moa_vpl VALUES ("LK20_40","072_20_40","LUK","20","40","40","‑A 'san 'bhɛ ma, yaa dɔlɛ ‑o do 'kpɔ 'kpee 'ke 'bhɛ ‑za 'kedo‑ 'kpɔ 'yilrɔkpa ‑a ma 'ezin‑. ");
INSERT INTO moa_vpl VALUES ("LK20_41","072_20_41","LUK","20","41","41","Zesu pe 'woo‑ 'Toŋ daan mu 'ɛ ni dɔɔ: «‑Mɛla ma 'bhɛɛ‑ mɛɛ mu 'ɛ ‑wa pe 'zi dɔɔ Mɛɛ ‑Bhee Mi ‑Kpɔsɔɔ Krisi ‑o 'ke Davidi 'nranɛ‑ ‑la ‑le 'te ɛɛ? ");
INSERT INTO moa_vpl VALUES ("LK20_42","072_20_42","LUK","20","42","42","'Bhɛɛ‑ 'duŋ‑, Davidi 'gbu 'a ꞊pia‑ ‑yaa' 'Srokpa 'sɛwɛ 'ɛ 'yi dɔɔ: ‹Mɛɛzan ‑Waanbhaa' 'a ꞊pia 'an Mɛɛzan ni dɔɔ: Nu yala‑ 'ŋ ‑din 'tɔbhɔ ma yaayrɛ 'ɛ ꞊nɔɔ. ");
INSERT INTO moa_vpl VALUES ("LK20_43","072_20_43","LUK","20","43","43","'Sani‑ 'mi yan 'e ‑sɔɔnnii' mu 'ɛ kpaalele 'e gaan ꞊la.› ");
INSERT INTO moa_vpl VALUES ("LK20_44","072_20_44","LUK","20","44","44","«'Ke Davidi 'gbu Mɛɛ ‑Bhee mi Krisi 'siila‑ dɔɔ ‑yaa' Mɛɛzan. 'Bhɛɛ‑ ‑e sɔ klɛle‑ ‑a ‑nranɛ 'le 'nale‑ ‑a ma ɛɛ?» ");
INSERT INTO moa_vpl VALUES ("LK20_45","072_20_45","LUK","20","45","45","‑Zamaa' 'ɛ 'kpɛn 'yaa‑ ‑o 'trɔnkpa zii' Zesu 'ni 'waati 'la ba, 'ke ‑ya pele‑ ‑yaa' ‑klaŋlanɛ mu 'ɛ ni dɔɔ: ");
INSERT INTO moa_vpl VALUES ("LK20_46","072_20_46","LUK","20","46","46","«‑Ka 'ka 'yrɛkpa 'ka 'gbu ba 'Toŋ daan mu 'ɛ ma. 'Kaanle‑ sɔ ‑o ni dunɛ‑ gbɔɔn mu 'le ‑o ta ‑wa 'kpee ‑kpan mu 'ɛ ta, 'bhɛɛ‑ ‑wa zi 'bhii‑ mɛɛ mu ‑o ‑lɛdɔ' ‑a ma, 'bhɛɛ‑ 'mu ‑o 'pubɔ‑. 'Ke ‑o ‑wlaa *Zuufu mu daanfɛ' mu 'ɛ ꞊la, 'bhɛ 'pegee 'fɛti klɛyrɛ ‑gbɛnɛ mu 'ɛ ꞊nɔɔ, zilɛɛ‑ yaakpe mu 'ɛ 'mu ‑la 'sile‑ sɔ ‑o ni. ");
INSERT INTO moa_vpl VALUES ("LK20_47","072_20_47","LUK","20","47","47","‑O glaanle mu 'ɛ 'kɔɔpɛ‑ mu 'ɛ 'kpɛn yan ‑dawli' ma. 'Bhɛɛ‑ ‑o mɔ ‑waa' 'seriwole 'ɛ zi, 'kooko‑ ‑woo 'gbu zrɔn mɛɛ mu ‑yrɛ ta 'bhii‑ mɛɛ wlan mu. 'Bhɛla‑ ‑zɛɛle, ‑o ta 'kiti 'ɛ 'bhɛ 'yɔɔ‑ nu ‑yiyalɛ mɛɛ ‑vin mu 'ɛ 'mu a pɛ 'kiti 'ɛ ni ‑Waanbhaa' ba.» ");
INSERT INTO moa_vpl VALUES ("LK21_1","072_21_1","LUK","21","1","1","Zesu 'yaa‑ ‑Waanbhaa' Gba 'Fɛ ‑Gbɛnɛ 'ɛ ꞊la 'waati 'la ba, ‑naflo zan mu 'ɛ ‑yaa ‑gɔli' bɔ 'zi ‑gɔli' bɔ ‑koonɛ 'ɛ 'yi; 'bhɛɛ‑ ‑ya ŋgblo ‑lawlɛnle 'ke ‑yoo yele‑. ");
INSERT INTO moa_vpl VALUES ("LK21_2","072_21_2","LUK","21","2","2","'Bhɛɛ‑ 'kee‑ glaanle 'kɔɔfleŋzan do yele‑, 'ke 'bhɛ ‑o zan ‑gɔli' 'taŋbha piinɛ‑ plɛ bɔlɛ 'yee‑ ‑koonɛ 'ɛ 'yi. ");
INSERT INTO moa_vpl VALUES ("LK21_3","072_21_3","LUK","21","3","3","‑Ayile 'ke Zesu 'a 'pele dɔɔ: «'Mi pe 'ka ni wlan 'ɛ ni dɔɔ glaanle 'lɛɛ‑ ‑gɔli' yɛkɛ‑ 'la ꞊bwa ‑gɔli' bɔ ‑koonɛ 'ɛ 'yi, 'bhɛ 'yiya‑ mɛɛ ‑vin mu 'ɛ 'mu ‑gɔli' yɛkɛ‑ 'la ꞊bwa 'bhɛ ni. ");
INSERT INTO moa_vpl VALUES ("LK21_4","072_21_4","LUK","21","4","4","‑Amasrɔyi 'woo‑ mɛɛ mu 'ɛ ‑o maza laa ‑yaa ‑li ‑gɔli' 'la ma, ‑o 'bhɛɛ‑ ꞊bwa ‑koonɛ 'ɛ 'yi. 'Duŋ‑ 'yee‑ glaanle 'lɛɛ‑ ‑yaa' 'kɔɔfleŋya 'ɛ 'yi, ‑ya 'tɔta‑ ‑gɔli' ‑vin sanɛ‑ 'ɛ 'bhɛɛ‑ ꞊bwa ‑koonɛ 'ɛ 'yi.» ");
INSERT INTO moa_vpl VALUES ("LK21_5","072_21_5","LUK","21","5","5","Zesu a ‑klaŋlanɛ mu 'ɛ 'ke mu 'ɛ 'yaa‑ ‑balo klɛ 'zi ‑Waanbhaa' Gba 'Fɛ ‑Gbɛnɛ 'ɛ 'bhɛ dɔgbɛya 'ɛ ta. ‑O ‑yaa ‑o ‑lɛkpa' zii' ‑a ‑lregbɛya 'ɛ ma, 'bhɛ 'pegee ‑wa ‑dwa vlɛ ‑lrele' mu 'la 'le, 'bhɛɛ‑ ‑a ‑la 'srakagopɛ ‑lrele' mu 'ɛ. ‑Ayile 'ke Zesu 'a 'pele ‑o ni dɔɔ: ");
INSERT INTO moa_vpl VALUES ("LK21_6","072_21_6","LUK","21","6","6","«'Ka 'yrɛ ‑o 'fɛ ‑gbɛnɛ 'la ma ‑gɛ bhe, ‑o nu ‑a 'kpɛn 'wilɛ‑ ‑yrekpaa' do. 'Ali‑ ‑wa ‑dwa vlɛ ‑kpuŋ mu 'la 'le, 'mu do 'kpɔ 'kpaale laa nu bolɛ 'eke‑ ta. ‑O nu 'mu 'kpɛn 'klaalɛ‑.» ");
INSERT INTO moa_vpl VALUES ("LK21_7","072_21_7","LUK","21","7","7","Zesu a *‑klaŋlanɛ mu 'ɛ ‑wa ‑lrɔkpaa dɔɔ: «'O Daan mi, 'bhɛ ‑za 'ɛ nu bhɔlɛ 'waati 'ɛ ‑dela ba ɛɛ? 'Bhɛɛ‑ 'bhɛ ‑za mu 'ɛ 'ke ‑o klɛ bhla ꞊bhwa 'waati 'la ba, 'o nu 'bhɛ 'yaangolɛ ‑tɔɔmasie 'ɛ ‑dela ma ɛɛ?» ");
INSERT INTO moa_vpl VALUES ("LK21_8","072_21_8","LUK","21","8","8","‑Ayile, 'ke Zesu 'a 'pele ‑o ni dɔɔ: «‑Ka 'ka 'yrɛkpa 'ka 'gbu ba 'elrele, 'kooko‑ mɛɛ 'kedo‑ 'kpɔ 'laa 'ka 'yini‑. ‑Amasrɔyi mɛɛ ‑bebe nu 'mi 'tɔ 'ɛ 'kpalɛ‑ ‑o 'gbu ma 'bhɛɛ‑ ‑wa pe dɔɔ: ‹'Mi ‑le 'ke Mɛɛ ‑Bhee Mi Krisi 'ɛ 'le, 'mi 'an pɛ 'waati 'ɛ ꞊bhwa!› 'Ka 'laa dɔlɛ ‑o zi. ");
INSERT INTO moa_vpl VALUES ("LK21_9","072_21_9","LUK","21","9","9","'Ke 'ka gwledanwli mu ‑maa 'waati 'la ba, 'bhɛ 'pegee 'ke mɛɛ mu wlɛnle ‑saan ‑o ‑lɛɛ mu ma 'klɛɛn ‑bebe 'yi, 'ka 'laa ‑gblaanlɛ'; 'bhɛ ‑za ‑glɔɔn mu 'ɛ 'mu ‑le nu 'sɔlɛ‑ bhɔle‑ 'elwale 'pe. 'Duŋ‑ 'bhɛ 'laa nu klɛlɛ 'drunyan 'yan 'waati 'ɛ 'le.» ");
INSERT INTO moa_vpl VALUES ("LK21_10","072_21_10","LUK","21","10","10","'Bhɛɛ‑ Zesu pe 'ezin‑ dɔɔ: «'Si do nu gwledanlɛ 'si 'bhɛɛke do ba; 'bhɛɛ‑ ‑bhleŋgbe do a 'klɛɛn 'yi mu nu gwledanlɛ ‑bhleŋgbe 'bhɛɛke do a 'klɛɛn 'yi mu ba. ");
INSERT INTO moa_vpl VALUES ("LK21_11","072_21_11","LUK","21","11","11","'Trɛ nu bɛɛnlɛ yrɛ 'ke mu nɔɔ‑, 'bhɛ 'pegee ‑gu ‑gbɛnɛ mu, 'bhɛɛ‑ ga ‑yɔɔ' ‑glɔɔn mu 'la ‑woo ‑yivlin' mɛɛ 'srɛ ma, 'mu 'kpɛn nu baalɛ bhaaplɛŋ mu ta. Mɛɛ ‑gblaan ma pɛ mu 'pegee ‑tɔɔmasie ‑gbɛnɛ mu nu 'pwɛlɛ‑ laflɛ' 'yi.» ");
INSERT INTO moa_vpl VALUES ("LK21_12","072_21_12","LUK","21","12","12","«'Duŋ‑ 'sani‑ 'bhɛ ‑za mu 'ɛ klɛle pleŋ‑, ‑o nu 'ka 'kunlɛ‑ 'bhɛɛ‑ ‑o ‑yrɛnkpa' 'ka ta. ‑O nu 'ka 'kitikanlɛ Zuufu mu daanfɛ' mu 'ɛ ꞊la, 'bhɛɛ‑ ‑o nu 'ka bɔlɛ ‑kaso 'yi. 'Mi 'tɔ 'ɛ ‑zayi', ‑o nu gelɛ 'ka 'le ‑bhleŋgbe mu 'pegee mɛɛ gblaan mu ba. ");
INSERT INTO moa_vpl VALUES ("LK21_13","072_21_13","LUK","21","13","13","'Ke 'bhɛ yi 'ɛ ꞊bhwa, 'ka nu 'sɔlɛ‑ 'mi 'an ‑Jan 'Nrale‑ 'ɛ 'wole 'bhɛ mɛɛ mu 'ɛ ni. ");
INSERT INTO moa_vpl VALUES ("LK21_14","072_21_14","LUK","21","14","14","'Ka nu 'ka 'gbu ta jan 'ɛ 'wolɛ‑ gɔnɛ‑ 'la gbɛɛn‑, 'ka 'laa 'bhɛ yiɛnkanlɛ 'elwale 'pe. ");
INSERT INTO moa_vpl VALUES ("LK21_15","072_21_15","LUK","21","15","15","‑Amasrɔyi 'mi 'gbu nu yikan' ma ‑jan 'kpalɛ‑ 'ka 'lii, 'bhɛɛ‑ 'ka 'sɔɔnnii 'kedo‑ a ‑jan 'laa nu 'sɔlɛ‑ 'ka 'kunle, 'bhɛɛ‑ ‑e zaabɔ 'ka 'lɛ ma. ");
INSERT INTO moa_vpl VALUES ("LK21_16","072_21_16","LUK","21","16","16","'Ali‑ 'ka 'yapɛ‑ mu oo, 'ka nɛɛnɛ‑ mu oo, 'ka 'yiɛnii mu oo, 'bhɛɛ‑ 'ka 'bhɛgwlɛn‑ mu 'gbu nu 'ka 'nalɛ‑ mɛɛ mu ni, 'bhɛɛ‑ 'mu 'ka ‑bebe dɛ. ");
INSERT INTO moa_vpl VALUES ("LK21_17","072_21_17","LUK","21","17","17","'Ka vɛn nu 'silɛ‑ mɔkpɛn' yin ‑lii, 'mi 'tɔ 'ɛ ‑zayi'. ");
INSERT INTO moa_vpl VALUES ("LK21_18","072_21_18","LUK","21","18","18","'Duŋ‑ 'ka 'winbhɛ‑ do 'kpɔ 'laa nu golɛ a ba. ");
INSERT INTO moa_vpl VALUES ("LK21_19","072_21_19","LUK","21","19","19","‑Ka 'woo‑ ‑yrɛn mu 'ɛ 'yikun: ‑amasrɔyi 'ke 'bhɛ ꞊kla, 'ka nu 'sɔlɛ‑ 'ka 'gbu 'si 'ɛ gole‑ ‑za 'yi 'bhɛɛ‑ gbɛɛn‑.» ");
INSERT INTO moa_vpl VALUES ("LK21_20","072_21_20","LUK","21","20","20","Zesu pe ‑o ni 'ezin‑ dɔɔ: «'Ke 'ka gwledan mu zɛnle ꞊ya Zeruzalɛmu ‑wa 'ɛ zi 'waati 'la ba, ‑kaa 'yaango‑ 'bhii‑ ‑a ‑wi 'waati 'ɛ ꞊bhwa ‑wa ‑din. ");
INSERT INTO moa_vpl VALUES ("LK21_21","072_21_21","LUK","21","21","21","'Bhɛ ya 'ɛ 'yi, 'ke mɛɛ 'la zan mu ꞊kla Zude 'klɛɛn 'ɛ 'yi 'bhɛ bhla 'ɛ ba, 'bhɛ zan mu blasan‑, 'bhɛɛ‑ 'mu ge 'mu gaan 'mu 'lɛɛ vlɛ gɔɔn mu 'ɛ 'yi ye. 'Bhɛɛ‑ 'ke mɛɛ 'la zan mu ‑o Zeruzalɛmu ‑wa 'ɛ 'kpee, 'bhɛ zan mu ge 'mu gaan. 'Bhɛɛ‑ 'ke mɛɛ 'la zan mu ꞊kla 'bhɛ mu ba gba la, 'mu 'laa 'pelɛ‑ dɔɔ 'mu 'nule ‑wa la. ");
INSERT INTO moa_vpl VALUES ("LK21_22","072_21_22","LUK","21","22","22","‑Amasrɔyi, ‑Waanbhaa' nu 'bhɛ yi mu 'ɛ klɛlɛ ‑yrɛnkpa' yi ‑gbɛnɛ mu 'le bhaaplɛŋ mu ta; 'kooko‑ ‑Waanbhaa' ‑lɛla' janwo mu 'ɛ ‑jan mu 'la ꞊woa 'elwale gban ‑sɔ 'mu 'lɛsɔ‑. ");
INSERT INTO moa_vpl VALUES ("LK21_23","072_21_23","LUK","21","23","23","'Ee! Le mu 'la kpɛle nu klɛlɛ, 'bhɛ 'pegee le mu 'la 'nɛ mu nu klɛlɛ ‑yɔn ma 'bhɛ 'waati 'ɛ ba, 'mu 'nisɛ‑ ‑yrɛn ma! ‑Amasrɔyi 'trɛbhɔ ‑gbɛnɛ nu klɛlɛ 'klɛɛn 'ɛ 'yi, 'bhɛɛ‑ ‑Waanbhaa' a zruplii‑ 'ɛ nu baalɛ Izraɛli 'si mu 'lɛɛ‑ ta. ");
INSERT INTO moa_vpl VALUES ("LK21_24","072_21_24","LUK","21","24","24","‑O nu ‑o 'ke mu dɛlɛ 'ke ‑gɔkuŋ' mu 'le, 'bhɛɛ‑ ‑o nu gelɛ ‑a 'ke mu 'le ‑kaso 'yi 'si mu 'la 'kpɛn 'laa ‑Waanbhaa' dɔ 'mu ba. 'Mu 'seŋ nu wolɛ 'ke Zeruzalɛmu mu 'ɛ 'le, 'bhɛɛ‑ ‑woo klɛ 'ke ‑o gaan ‑la pɛ mu 'le, 'sani ‑o 'waati yɛkɛ‑ 'la ‑dwa ‑o ni 'bhɛ 'yanle‑ pleŋ‑.» ");
INSERT INTO moa_vpl VALUES ("LK21_25","072_21_25","LUK","21","25","25","Zesu pe ‑o ni 'ezin‑ dɔɔ: «'Ka nu ‑tɔɔmasie mu yelɛ ‑yretɛbhɛ 'pegee mlɛ 'bhɛɛ‑ mlɛklɛnnɛ mu 'ɛ 'yi. 'Bhɛɛ‑ 'trɛ ta ‑gɛ, ‑gblaan nu 'klalɛ‑ mɛɛ mu 'ɛ 'kpɛn 'yi, wɛyi‑ 'pegee 'bhɛ 'pɔɔ mu 'ɛ 'wegbɛya ‑gbɛnɛ ‑gbɛnɛ mu 'ɛ ‑zayi', 'bhɛɛ‑ ‑o 'kpɛn blina‑ yiɛn nu dɔlɛ. ");
INSERT INTO moa_vpl VALUES ("LK21_26","072_21_26","LUK","21","26","26","'Trɛ ta mu 'ɛ ‑o ‑gblaan gbɛ ‑yɔɔ' 'ɛ 'kɔɔ, ‑o 'ke mu nu galɛ 'ke ‑woo 'kpeelɛdaan ‑klɔlɔɔ' ‑glɔɔn 'la nu 'tɛnlɛ‑ ‑o ma 'trɛ 'lɛɛ‑ 'kpɛn ta ‑gɛ 'mu ma. ‑Amasrɔyi laflɛ' 'yi pɛ ‑glɔɔ ‑glɔɔ mu 'ɛ ‑o nu bɛɛnlɛ. ");
INSERT INTO moa_vpl VALUES ("LK21_27","072_21_27","LUK","21","27","27","'Ke 'bhɛ ꞊kla 'tɛ, mɔkpɛn' 'yrɛ nu 'kpalɛ‑ Bhaaplɛŋ Gbe 'ɛ 'nule‑ ma laflɛ' ‑gblɛn do ta, ‑yaa' ‑glɔɔya' 'pegee ‑a 'tɔbhɔleya 'ɛ 'le. ");
INSERT INTO moa_vpl VALUES ("LK21_28","072_21_28","LUK","21","28","28","'Ke 'bhɛ ‑za mu 'ɛ klɛle ‑saan 'ka 'yrɛ ma 'waati 'la ba, ‑ka 'ka ŋgblo ‑lawlɛn', 'bhɛɛ‑ ‑ka 'ka zru dɔ 'eglɔɔle, ‑amasrɔyi 'ka 'bhee bhla 'ɛ ꞊bhwa 'ka ‑din.» ");
INSERT INTO moa_vpl VALUES ("LK21_29","072_21_29","LUK","21","29","29","'Bhɛ blaan, 'ke Zesu ‑gɔɔn do 'lɛɛ‑ 'bhɛ bɔle‑ ‑o ni 'ezin‑ dɔɔ: «‑Ka figi diiŋ 'pegee ‑yri diiŋ ‑vin mu 'ɛ 'klɔsikun doo. ");
INSERT INTO moa_vpl VALUES ("LK21_30","072_21_30","LUK","21","30","30","'Ke ‑o ‑laa 'tɔɔnle‑ ‑saan bhla 'la ba ‑o ta, 'kaa 'yaango‑ 'bhii‑ ‑o bhaa klɛ 'waati ꞊bhwa 'e ‑din gban. ");
INSERT INTO moa_vpl VALUES ("LK21_31","072_21_31","LUK","21","31","31","'Bhɛ klɛgbɛya do 'ɛ 'yi bhe, 'ke 'ka 'bhɛ ‑za mu 'la bhe 'mu klɛyrɛ ꞊ya 'waati 'la ba, ‑kaa 'yaango‑ 'bhii‑ *‑Waanbhaa' a ‑bhleŋgbeya 'ɛ ꞊bhwa ‑wa ‑din. ");
INSERT INTO moa_vpl VALUES ("LK21_32","072_21_32","LUK","21","32","32","'Mi pe 'ka ni wlan 'ɛ ni dɔɔ mɛɛ 'la zan mu ‑o 'mu 'yrɛ ma ‑zɔn ‑gɛ, 'sani‑ 'mu 'kpɛn gale pleŋ‑, ‑za mu 'lɛɛ‑ nu klɛlɛ ‑o 'ke mu ‑yrɛ ma. ");
INSERT INTO moa_vpl VALUES ("LK21_33","072_21_33","LUK","21","33","33","Laflɛ' 'pegee 'trɛ mu nu kanlɛ, 'duŋ‑ 'an pɛ ‑jan mu 'ɛ waa nu 'kanlɛ‑ ‑titi.» ");
INSERT INTO moa_vpl VALUES ("LK21_34","072_21_34","LUK","21","34","34","Zesu pe ‑o ni 'ezin‑ dɔɔ: «‑Ka 'ka 'yrɛkpa 'ka 'gbu ba 'elrele! 'Ka 'laa 'tolɛ‑ 'ke pɛbhle ‑gbɛnɛ mu 'pegee ‑wɛɛn dɛ maza, 'bhɛɛ‑ 'drunyan ta 'ŋgami mu 'ɛ 'kɔɔ, 'ka 'yri go 'ka 'gbu ‑za 'le, 'bhɛɛ‑ 'bhɛ yi 'ɛ kla 'ka ba. ");
INSERT INTO moa_vpl VALUES ("LK21_35","072_21_35","LUK","21","35","35","Bhaaplɛŋ Gbe 'ɛ 'nu yi 'ɛ nu 'klalɛ‑ 'drunyan ta mɛɛ mu 'kpɛn ba blaale‑, 'bhii‑ kaadɛ yrɔ kla kaa mu ba gɔnɛ‑ 'la gbɛɛn‑ ‑yi ba, 'bhɛɛ‑ ‑yoo 'kpɛn kun. ");
INSERT INTO moa_vpl VALUES ("LK21_36","072_21_36","LUK","21","36","36","'Ka 'yri 'laa golɛ 'ka 'gbu ‑za 'le, 'bhɛɛ‑ ‑ka 'ka 'seriwo 'waati oo 'waati 'ɛ 'kpɛn ba. 'Kooko‑ faŋgandɔ 'ka ta, 'bhɛɛ ‑klɔlɔɔ' mu 'la ‑woo zan bhe, 'mu kan 'ka ma 'egbɔɔnle, 'bhɛɛ‑ 'ka ge dulalɛ Bhaaplɛŋ Gbe 'ɛ 'yrɛ ꞊la.» ");
INSERT INTO moa_vpl VALUES ("LK21_37","072_21_37","LUK","21","37","37","'Ke ‑yrekpaa' ‑yaa bhɔ, Zesu 'yaa‑ ge mɛɛ mu daanlɛ ‑Waanbhaa' Gba 'Fɛ ‑Gbɛnɛ 'ɛ ꞊la, 'bhɛɛ‑ yromazi, ‑e ‑yaa ge yilɛ Olivi diiŋ vlɛ gɔɔn 'ɛ 'wiiŋ‑. ");
INSERT INTO moa_vpl VALUES ("LK21_38","072_21_38","LUK","21","38","38","'Bhɛɛ‑ mɛɛ mu 'ɛ 'kpɛn 'yaa‑ nu zrwanzi 'tutu ‑Waanbhaa' Gba 'Fɛ ‑Gbɛnɛ 'ɛ ꞊la 'mu 'trɔnkpalɛ ‑a wojan mu 'ɛ ꞊la. ");
INSERT INTO moa_vpl VALUES ("LK22_1","072_22_1","LUK","22","1","1","Zuufu mu 'ɛ 'yaa‑ 'bluu ‑pɛɛ 'wlɛn kle bhle 'fɛti 'la klɛ lɛɛ 'oo lɛɛ, 'bhɛ 'yaa‑ zan bhɔlɛ. 'Bhɛ 'fɛti 'ɛ 'yaa‑ 'ezin‑ Paki 'fɛti 'ɛ 'le. ");
INSERT INTO moa_vpl VALUES ("LK22_2","072_22_2","LUK","22","2","2","'Sraka 'lɛna ‑kuŋlii mu 'ɛ 'pegee 'Toŋ daan mu 'ɛ ‑o ‑yaa Zesu dɛyrɛ ‑glin 'zi, 'bhɛɛ‑ 'duŋ‑ ‑o ‑yaa ‑gblaan 'zi waa mɛɛ mu 'ɛ 'lɛɛ. 'Duŋ‑, waa ‑yaa zi 'bhii‑ ‑wa klɛ 'ke mɔkpɛn' ‑za dɔ ‑a 'yi, 'bhɛɛ‑ mɛɛ mu wlɛn ‑o ma, ‑amasrɔyi ‑o ‑yaa ‑gblaan 'zi ‑waa' 'si mu 'ɛ 'lɛɛ. ");
INSERT INTO moa_vpl VALUES ("LK22_3","072_22_3","LUK","22","3","3","‑Setran' ‑za 'yɔɔ‑ ꞊wlaa Zuda 'la ‑wa sii Isikariɔti 'bhɛ zru ba: ‑e ‑yaa 'duŋ‑ Zesu ‑a ‑klaŋlanɛ vu ta plɛ 'ɛ do 'le. ");
INSERT INTO moa_vpl VALUES ("LK22_4","072_22_4","LUK","22","4","4","'Bhɛ ya 'ɛ 'yi, 'yee‑ Zuda ‑ja 'tɛnlɛ‑ 'sraka 'lɛna mu ‑lɛɛ mu 'ɛ 'pegee ‑Waanbhaa' Gba 'Fɛ ‑Gbɛnɛ 'ɛ gooba mu ‑kuŋlii mu 'ɛ ma. 'Bhɛɛ‑ ‑e ‑yaa nu 'sɔlɛ‑ Zesu 'lɛnale ‑o ni gɔnɛ‑ 'la gbɛɛn‑, ‑o ‑bɛŋgwa do 'bhɛ ma. ");
INSERT INTO moa_vpl VALUES ("LK22_5","072_22_5","LUK","22","5","5","'Bhɛ klɛle 'tɛ, 'ke ‑o zrukpaale Zuda 'a 'pelawoa dɔɔ 'bhɛ nu bhɔlɛ ‑o ba, 'bhɛɛ‑ 'bhɛ Zesu 'lɛna‑ ‑o ni 'bhɛ 'yi. 'Bhɛla‑ ‑yile 'ke ‑wa pele‑ ‑a ni dɔɔ ‑o nu ‑gɔli' 'nalɛ‑ ‑a ni 'bhɛ ‑za 'ɛ 'yi. ");
INSERT INTO moa_vpl VALUES ("LK22_6","072_22_6","LUK","22","6","6","'Yee‑ Zuda ‑dwa 'bhɛ ꞊la. ‑A 'san 'bhɛ yi 'ɛ ma, ‑a gbɛ sɔ Zesu ta gɔnɛ‑ 'la gbɛɛn‑ 'bhɛɛ‑ ‑e 'bhɛ 'lɛna‑ Zuufu mu a ‑kuŋlii mu 'ɛ ni, ‑e yaa‑ 'bhɛɛ‑ klɛgbɛya 'ɛ ‑glin 'zi gaanyi', 'kooko‑ ‑zamaa' 'ɛ ‑za 'laa dɔ 'bhɛ 'yi. ");
INSERT INTO moa_vpl VALUES ("LK22_7","072_22_7","LUK","22","7","7","'Bluu ‑pɛɛ 'wlɛn‑ kle bhle 'fɛti 'la 'ke ‑wa sii Paki 'fɛti 'ɛ, 'bhɛ yi 'ɛ ꞊bhwa, 'bhɛɛ‑ ‑o ‑yaa nu ‑bhlaa gwlɛn bhlonɛ‑ mu klɛlɛ 'sraka 'le, 'bhɛɛ‑ ‑woo bhle 'yee‑ 'fɛti 'ɛ ta pɛbhle 'ɛ ba. ");
INSERT INTO moa_vpl VALUES ("LK22_8","072_22_8","LUK","22","8","8","‑Ayile, 'ke Zesu Piɛri 'pegee Zaan winbɔle ‑o ‑lɛɛ, 'bhɛɛ‑ ‑e pe 'mu ni dɔɔ: «‑Ka ge ‑kɔɔ mu a pɛ 'fɛti 'ɛ ta kpo 'ɛ klɛ.» ");
INSERT INTO moa_vpl VALUES ("LK22_9","072_22_9","LUK","22","9","9","Piɛri 'pegee Zaan pe ‑a ni dɔɔ: «꞊Ya zi 'bhii‑ 'o ge 'yee‑ kpo 'ɛ klɛ 'naa‑ ma ɛɛ?» ");
INSERT INTO moa_vpl VALUES ("LK22_10","072_22_10","LUK","22","10","10","Zesu pe ‑o ni dɔɔ: «'Ka 'bhɔle‑ 'te ‑wa 'ɛ ta, 'ka 'lɛ nu 'palɛ‑ mɛɛ do 'le, ‑yi gbɔ do ‑o ‑a wiiŋ‑. ‑Ka gbaan ‑a zi, 'bhɛɛ‑ ‑ka ge wla ‑a wla 'fɛ 'ɛ ꞊la. ");
INSERT INTO moa_vpl VALUES ("LK22_11","072_22_11","LUK","22","11","11","'Bhɛɛ‑ 'ke 'ka ꞊wlaa 'bhɛ ꞊la 'waati 'la ba, ‑kaa pe 'fɛzan‑ 'ɛ ni dɔɔ: ‹'O Daan mi 'pe 'wo 'e 'lrɔkpa dɔɔ 'yee‑ 'pegee ‑yaa' ‑klaŋlanɛ mu 'ɛ ‑o nu ‑waa' Paki 'fɛti ta pɛle 'ɛ 'bhlelɛ‑ 'fɛkpee 'ɛ ‑dela ꞊la ɛɛ?› ");
INSERT INTO moa_vpl VALUES ("LK22_12","072_22_12","LUK","22","12","12","'Ke 'bhɛ ꞊kla, ‑e nu 'fɛkpee ‑gbɛnɛ do zrɔnlɛ 'ka ni, 'bhɛ ‑o 'saŋgaso 'kpee do 'le laanima. Yilapɛ 'pegee yaapɛ, 'bhɛɛ‑ kpo klɛpɛ mu 'kpɛn ‑o 'bhɛ ‑la gban, 'ka nu ‑kɔɔa' kpo 'ɛ klɛlɛ 'bhɛɛ‑ ꞊nɔɔ.» ");
INSERT INTO moa_vpl VALUES ("LK22_13","072_22_13","LUK","22","13","13","Piɛri 'pegee Zaan gele, 'ke ‑o ‑za mu 'ɛ 'kpɛn 'lɛsɔle yele‑ 'bhii‑ Zesu 'a ꞊pia ‑o ni gɔnɛ‑ 'la gbɛɛn‑. 'Bhɛɛ‑ ‑o ‑waa' 'fɛti ta kpo 'ɛ ꞊kla 'bhɛɛ‑ ꞊nɔɔ. ");
INSERT INTO moa_vpl VALUES ("LK22_14","072_22_14","LUK","22","14","14","Piɛri 'pegee Zaan 'yanle‑ ‑za mu 'ɛ 'kpɛn 'lɛmagaanle 'le 'waati 'la ba, 'ke Zesu 'pegee ‑yaa' winbɔwo mu ‑vin mu 'ɛ 'nule, 'ke ‑o 'kpɛn 'yaale pɛbhle ‑tabali 'ɛ zi, 'bhɛɛ‑ ‑o pɛ 'ɛ ꞊bhla 'eke‑ zi. ");
INSERT INTO moa_vpl VALUES ("LK22_15","072_22_15","LUK","22","15","15","‑O ‑yaa pɛ 'ɛ 'bhle zii' 'waati 'la ba, 'ke Zesu 'a 'pele ‑o ni dɔɔ: «'Ŋ 'yaa‑ ‑a zi 'eglɔɔle 'bhii‑ 'mi 'pegee 'ka mu 'yee‑ 'fɛti 'lɛɛ‑ ta pɛ 'ɛ 'bhle 'eke‑ zi, 'sani‑ 'ŋ ‑yrɛnbhlele zisan; 'bhɛ yi 'ɛ 'bhɛ ‑le ꞊bhwa ‑zɔn ‑gɛ. ");
INSERT INTO moa_vpl VALUES ("LK22_16","072_22_16","LUK","22","16","16","'Duŋ‑ 'mi pe 'ka ni 'ŋ 'sɔwɛɛ‑ ma dɔɔ: 'Naa nu ‑a ‑bhɛɛke' 'bhlelɛ‑ 'ezin‑ ‑li, 'sani‑ ‑a ‑tɔɔmasie 'ɛ 'lɛsɔle pleŋ‑ ‑Waanbhaa' a ‑bhleŋgbeya ‑wa 'ɛ ta.» ");
INSERT INTO moa_vpl VALUES ("LK22_17","072_22_17","LUK","22","17","17","'Bhɛ klɛle 'tɛ, 'kee‑ ‑drɔɔ pɛyan‑ do 'sile, 'kee‑ ‑Waanbhaa' 'pubɔle 'bhɛ ma, 'bhɛɛ‑ 'ke ‑ya pele‑ ‑o ni dɔɔ: «‑Kaa 'kun ‑gɛ 'bhɛɛ‑ 'ka 'kpɛn 'a 'ke 'mi do do. ");
INSERT INTO moa_vpl VALUES ("LK22_18","072_22_18","LUK","22","18","18","‑Amasrɔyi 'naa nu ‑drɔɔ 'bhɛɛke 'milɛ‑ ‑li 'ezin‑ 'sani‑ ‑Waanbhaa' ‑bhleŋgbeya yaa‑ yi 'ɛ bhɔle pleŋ‑.» ");
INSERT INTO moa_vpl VALUES ("LK22_19","072_22_19","LUK","22","19","19","'Bhɛ blaan, 'kee‑ 'bluu do 'sile, 'bhɛɛ‑ ‑e yanle ‑Waanbhaa' 'pubɔlele 'bhɛ ma, 'ke ‑ya takanle kplokplo. 'Bhɛɛ‑ 'kee‑ 'bhɛ 'kpale ‑o 'kɔɔ, 'bhɛɛ‑ ‑e pe dɔɔ: «'Mi 'gbu 'flɛ 'ɛ 'yele‑ ‑gɛ, 'ŋ 'yela‑ na 'zi 'ka ni ‑gɛ. ‑Kaa bhle 'bhɛɛ‑ 'ŋ ‑za bo 'ka 'kpee.» ");
INSERT INTO moa_vpl VALUES ("LK22_20","072_22_20","LUK","22","20","20","‑O yanle 'bluu 'ɛ 'bhlelele, 'kee‑ ‑drɔɔ pɛyan‑ do 'ɛ 'sile, 'bhɛɛ‑ 'ke ‑ya pele‑ ‑o ni 'ezin‑ dɔɔ: «‑Waanbhaa' *‑bhoolaya drɛɛ 'la ‑dwa bhaaplɛŋ mu 'pegee 'yee‑ pleŋ‑, 'bhɛ ma ‑tɔɔmasie ‑le 'ke 'ŋ yiɛn 'la 'klalaa‑ 'ka mu ma 'bhɛ 'le.» ");
INSERT INTO moa_vpl VALUES ("LK22_21","072_22_21","LUK","22","21","21","«'Duŋ‑ ‑ka 'ka 'yrɛkpa ‑gɛ, mɛɛ 'la zan ‑o 'ŋ 'na zii' 'ŋ 'sɔɔnnii mu 'ɛ ni 'bhɛ zan ‑o ‑kɔɔ' 'pleŋ‑ ‑tabali 'lɛɛ‑ zi ‑gɛ. ");
INSERT INTO moa_vpl VALUES ("LK22_22","072_22_22","LUK","22","22","22","Wlan 'ɛ ni, *Bhaaplɛŋ Gbe 'ɛ nu klɛlɛ 'ke siɛle' 'bhii‑ ‑Waanbhaa' a 'lɛdulaa gɔnɛ‑ 'la gbɛɛn‑. 'Bhɛɛ‑ 'duŋ‑, mɛɛ 'la zan ‑a 'lɛna zii' ‑dawli' ma ‑a ‑sɔɔnnii' mu ni, ‑klɔlɔɔ' ‑o 'bhɛ zan ma!» ");
INSERT INTO moa_vpl VALUES ("LK22_23","072_22_23","LUK","22","23","23","'Bhɛ klɛle 'tɛ, 'ke ‑woo 'eke‑ ‑lrɔkpale 'sanle ‑o ba mɛɛ 'la 'yaa‑ nu 'bhɛ ‑za ‑glɔɔn 'ɛ klɛlɛ 'bhɛ ma. ");
INSERT INTO moa_vpl VALUES ("LK22_24","072_22_24","LUK","22","24","24","Zesu a ‑klaŋlanɛ mu 'ɛ ‑o zaabɔle ‑saan 'eke‑ pleŋ‑ dɔɔ ‑o ‑de 'gbu ‑le ‑o ba mɛɛ gblaan 'le ɛɛ. ");
INSERT INTO moa_vpl VALUES ("LK22_25","072_22_25","LUK","22","25","25","'Bhɛ klɛle 'tɛ, 'ke Zesu 'a 'pele ‑o ni dɔɔ: «'Trɛ 'lɛɛ‑ ta ‑gɛ, ‑bhleŋgbe mu 'ɛ 'kpaale‑ ‑o waa 'klɛɛn 'yi mu 'ɛ 'wiiŋ‑ faŋgan‑ ‑la ma. 'Bhɛɛ‑ faŋgan‑ ‑o mɛɛ 'la zan mu 'kɔɔ, 'bhɛ mu ‑o ‑a zi 'bhii‑ ‑o 'mu 'sii‑ ‹‑Za 'wlan klɛ mu› ");
INSERT INTO moa_vpl VALUES ("LK22_26","072_22_26","LUK","22","26","26","'Duŋ‑ 'ka mu laa klɛlɛ 'bhɛ gbɛɛn‑. Drɔɔn' 'ke mɛɛ 'la zan ‑o 'ka ba mɛɛ gblaan 'le, 'bhɛ 'bhɛ 'gbu 'kun 'bhii‑ matruŋnɛ. 'Bhɛɛ‑ 'ke mɛɛ 'la zan ‑o 'ka 'lɛɛ mi 'le, 'bhɛ zan klɛ 'kaa‑ yewonɛ 'le. ");
INSERT INTO moa_vpl VALUES ("LK22_27","072_22_27","LUK","22","27","27","'Bhɛɛ‑ 'woo‑ mɛɛ plɛ 'lɛɛ‑, ‑o de 'gbu ‑la gblaan ‑yiya': mɛɛ 'la zan ‑o pɛbhle 'zi taa‑ mɛɛ 'la zan ‑o pɛle 'ɛ 'na zii' ‑a ‑vindo' mi ni ɛɛ? Mɛɛ 'la zan ‑o pɛ 'ɛ 'bhle zii' 'bhɛ ‑le 'laa ‑le ɛɛ? 'Bhɛɛ‑ 'mi 'duŋ‑ ‑o 'ka 'pleŋ‑ ‑gɛ 'bhii‑ 'kaa‑ yewonɛ! ");
INSERT INTO moa_vpl VALUES ("LK22_28","072_22_28","LUK","22","28","28","'Bhɛɛ‑ 'mi 'pegee 'ka mu ‑le ‑yrɛn mu 'ɛ ꞊bhla 'eke‑ zi ‑gɛ yi 'oo yi. ");
INSERT INTO moa_vpl VALUES ("LK22_29","072_22_29","LUK","22","29","29","'Bhɛ klɛgbɛya do 'ɛ 'yi, 'ŋ Dɛ ‑yaa' ‑bhleŋgbeya ‑wa 'ɛ ꞊kla 'mi a pɛ 'le gɔnɛ‑ 'la gbɛɛn‑, 'mi 'a klɛ 'ka mu a pɛ 'le 'bhɛɛ‑ gbɛɛn‑ 'ezin‑. ");
INSERT INTO moa_vpl VALUES ("LK22_30","072_22_30","LUK","22","30","30","'Ka mu nu pɛbhlelɛ, 'bhɛɛ‑ 'ka nu ‑yi 'milɛ‑ 'mi 'an pɛ pɛbhle tabali 'ɛ zi 'an ‑Bhleŋgbeya ‑wa 'ɛ ta. 'Bhɛɛ‑ 'ka nu yaalɛ ‑bhleŋgbe mu 'yaakpe‑ mu 'ɛ ta, 'bhɛɛ‑ 'ka nu Izraɛli ‑gbaa vu ta plɛ 'ɛ 'kitikanlɛ.» ");
INSERT INTO moa_vpl VALUES ("LK22_31","072_22_31","LUK","22","31","31","Mɛɛzan Zesu pe Piɛri ni dɔɔ: «Simɔ, Simɔ, 'e 'trɔnkpa doo, ‑Setran' 'e ‑zapia 'ŋ ba dɔɔ ‑ya zi 'bhii‑ ‑yoo 'e 'yidan‑, 'bhɛɛ‑ ‑yoo 'e zru 'ɛ ye, 'bhii‑ le do ‑mlɔ bhɛ 'pegee ‑a ‑gboo 'ɛ bapian gɔnɛ‑ 'la gbɛɛn‑. ");
INSERT INTO moa_vpl VALUES ("LK22_32","072_22_32","LUK","22","32","32","'Duŋ‑ 'mi 'ŋ 'seriwoa 'yaa‑ ‑za ma, 'kooko‑ 'yaa ploo 'e 'kpale‑ ma 'mi 'yi. 'Bhɛɛ‑ 'ke 'yee zru 'niinaa 'mi ba 'waati 'la ba, 'fuudɔ‑ 'e ‑vin mu 'ɛ ta.» ");
INSERT INTO moa_vpl VALUES ("LK22_33","072_22_33","LUK","22","33","33","Piɛri pe Zesu ni dɔɔ: «Mɛɛzan, 'kee‑ ‑kla ‑kaso 'yi gele 'le oo, 'kee‑ ‑kla gale 'le oo, 'ŋ magaanle ‑o 'bhɛ 'kpɛn klɛlele 'mi 'pegee 'bhi 'le.» ");
INSERT INTO moa_vpl VALUES ("LK22_34","072_22_34","LUK","22","34","34","'Bhɛ klɛle 'tɛ, 'ke Zesu 'a 'pele ‑a ni dɔɔ: «Piɛri 'mi pe 'e ni 'ŋ 'sɔwɛɛ‑ 'ɛ ma dɔɔ 'sani‑ maagwlɛn ‑weli' pleŋ‑ ‑zɔn, 'bhi nu a pelɛ 'mi ma gaan yaga dɔɔ 'yaa 'mi dɔ.» ");
INSERT INTO moa_vpl VALUES ("LK22_35","072_22_35","LUK","22","35","35","'Bhɛ blaan, 'ke Zesu 'a 'pele ‑yaa' ‑klaŋlanɛ mu 'ɛ ni dɔɔ: «'Ŋ 'ka 'winlabwa ‑Jan 'Nrale‑ 'ɛ 'woyrɛ‑ nɔɔ‑, 'bhɛɛ‑ 'an 'pelawoa 'ka ni dɔɔ 'ka 'laa ‑gɔli' bɔlɛ 'ka 'wiiŋ‑, 'bhɛɛ‑ 'ka 'laa gbɛn ta ge 'pepe 'silɛ‑, 'bhɛ 'pegee 'ka 'laa ‑sawla mu 'silɛ‑, 'bhɛɛ‑ 'ka gelawoa 'yee‑ 'taa 'ɛ ta, pɛ 'ke 'kanaa 'ka ma ɛɛ?» ‑O pe «'Yooye‑!» ");
INSERT INTO moa_vpl VALUES ("LK22_36","072_22_36","LUK","22","36","36","'Bhɛ klɛle 'tɛ, 'ke Zesu 'a 'pele ‑o ni dɔɔ: «'Duŋ‑ ‑zɔn, 'ke ‑gɔli' ‑o mɛɛ 'la zan 'kɔɔ oo, 'ke gbɛn ta ge 'pepe ‑o mɛɛ 'la zan 'kɔɔ 'oo, 'bhɛ zan 'mu 'si ‑zɔn. 'Bhɛɛ‑ 'ke ‑gɔkuŋ' 'laa ‑o mɛɛ 'la zan 'kɔɔ, 'bhɛ zan 'bhɛ ta dunɛ‑ 'ɛ gɔn, 'bhɛɛ‑ ‑ya ma ‑gɔli' 'ɛ si, 'bhɛɛ‑ ‑e ‑gɔkuŋ' do ‑lɔ 'kɛle‑. ");
INSERT INTO moa_vpl VALUES ("LK22_37","072_22_37","LUK","22","37","37","‑Amasrɔyi 'mi pe 'ka ni dɔɔ ‑a ‑lɛdulale ‑o dɔɔ ‑o ‑jan mu 'la ꞊woa 'mi ba zayi' 'elwale gban ‑sɔ ‑Waanbhaa' a 'sɛwɛ 'ɛ 'yi, 'bhɛ 'yizaklɛ yi 'ɛ 'bhɛ ‑le ꞊bhwa ‑zɔn ‑gɛ, 'bhɛ ‑jan 'ɛ 'bhɛ ‑le dɔɔ: ‹‑Wa ꞊kwan 'bhii‑ ‑za 'yɔɔ‑ klɛ mi do›. ‑Ayile ‑Waanbhaa' ‑lɛla' janwo mu 'ɛ ‑o ‑jan mu 'la 'kpɛn ꞊woa 'mi ma, ‑o 'kpɛn 'lɛsɔ yi ꞊bhwa ‑zɔn.» ");
INSERT INTO moa_vpl VALUES ("LK22_38","072_22_38","LUK","22","38","38","'Bhɛ ꞊nɔɔ bhe, 'ke ‑yaa' ‑klaŋlanɛ mu 'ɛ ‑wa pele‑ ‑a ni dɔɔ: «Mɛɛzan, ‑gɔkuŋ' plɛ ‑le ‑gɛ.» 'Bhɛɛ‑ ‑e pe ‑o ni dɔɔ: «‑Ka 'ploo‑ 'bhɛ ‑jan 'ɛ ma 'pe!» ");
INSERT INTO moa_vpl VALUES ("LK22_39","072_22_39","LUK","22","39","39","'Bhɛ blaan, 'ke Zesu 'pegee ‑yaa' ‑klaŋlanɛ mu 'ɛ 'pwɛle 'bhɛ 'fɛ 'ɛ ꞊la. 'Bhɛɛ‑ 'ke ‑o gele‑ *Olivi diiŋ vlɛ gɔɔn 'ɛ 'wiiŋ‑, 'bhii‑ ‑e ‑yaa klɛ gɔnɛ‑ 'la gbɛɛn‑ 'egwele. ");
INSERT INTO moa_vpl VALUES ("LK22_40","072_22_40","LUK","22","40","40","‑O bhɔle 'bhɛ vlɛ gɔɔn 'ɛ ta, 'ke ‑ya pele‑ ‑yaa' ‑klaŋlanɛ mu 'ɛ ni dɔɔ: «‑Ka 'ka 'seriwo, 'kooko‑ 'ka 'laa balaa' ‑Setran' a mɛɛ ‑lɛkan' maza mu 'ɛ 'yi.» ");
INSERT INTO moa_vpl VALUES ("LK22_41","072_22_41","LUK","22","41","41","'Bhɛɛ‑ ‑ya pleŋgole ‑o ma sa, 'ke ‑ya 'kpɔ zɛnle‑ 'trɛ ma, 'bhɛɛ‑ 'ke ‑ya 'seriwole dɔɔ: ");
INSERT INTO moa_vpl VALUES ("LK22_42","072_22_42","LUK","22","42","42","«'Ŋ Dɛ, 'kee sɔ ‑yrɛn 'lɛɛ‑ 'pleŋgole 'ŋ ma. 'Duŋ‑ 'yaa 'mi a pɛ zru maza 'ɛ klɛlɛ, 'fɔ 'yaa‑ pɛ 'ɛ 'bhɛɛ‑ klɛ.» ");
INSERT INTO moa_vpl VALUES ("LK22_43","072_22_43","LUK","22","43","43","'Bhɛ 'yi 'tɛ, 'ke Mɛɛzan ‑Waanbhaa' a ‑mlɛkɛ' do 'pwɛle ‑a ba, 'bhɛɛ‑ 'ke 'bhɛ 'fuudɔle ‑a ta. ");
INSERT INTO moa_vpl VALUES ("LK22_44","072_22_44","LUK","22","44","44","Zesu blina‑ yiɛndɔ gbɛ ‑yɔɔ 'ɛ 'kɔɔ, 'ke ‑ya 'seriwole 'eglɔɔle 'ezin‑. ‑Ayile 'ke ‑a ta 'fuu 'ɛ klɛle‑ 'bhii‑ yiɛn 'kpla mu gbɛɛn‑ 'kee‑ tɔ 'trɛ ma. ");
INSERT INTO moa_vpl VALUES ("LK22_45","072_22_45","LUK","22","45","45","‑E yanle ‑a 'seriwolele, 'kee‑ nule‑ ‑yaa' ‑klaŋlanɛ mu 'ɛ ta, 'bhɛɛ‑ 'kee‑ bhɔle‑ 'mu ta 'ke 'mu ‑o yidɛ 'zi 'mu wlɛyisriwo gbɛya ‑yɔɔ' 'ɛ 'kɔɔ. ");
INSERT INTO moa_vpl VALUES ("LK22_46","072_22_46","LUK","22","46","46","'Bhɛ klɛle 'tɛ, 'ke ‑ya pele‑ 'mu ni dɔɔ: «‑Mɛle ‑kla 'bhɛɛ‑ 'ka ‑o yidɛ 'zi ɛɛ? ‑Ka 'ka 'wlɛn‑, 'bhɛɛ‑ ‑ka 'ka 'seriwo, 'kooko‑ 'ka 'laa balaa' ‑Setran' a mɛɛ ‑lɛkan maza mu 'ɛ yi.» ");
INSERT INTO moa_vpl VALUES ("LK22_47","072_22_47","LUK","22","47","47","Zesu 'yaa‑ 'bhɛ ‑jan 'ɛ 'wo zii' 'waati 'la ba, 'ke ‑zamaa' 'srɛ do 'pwɛle ‑a ‑yi. ‑Yaa' ‑klaŋlanɛ vu ta plɛ mi 'la ‑o ‑yaa 'bhɛ sii Zuda 'bhɛ dɔle ‑yaa 'bhɛ ‑zamaa' 'ɛ 'lɛɛ. ‑Ya mabɛɛnle Zesu ‑din, 'kee‑ 'bhɛ ‑tuubɔle. ");
INSERT INTO moa_vpl VALUES ("LK22_48","072_22_48","LUK","22","48","48","'Bhɛ klɛle 'tɛ, 'ke Zesu 'a 'pele 'a ni dɔɔ: «Zuda, 'e *Bhaaplɛŋ Gbe 'ɛ 'lɛna zii' mɛɛ mu ‑a ‑tuubɔle ‑la ‑le ɛɛ?» ");
INSERT INTO moa_vpl VALUES ("LK22_49","072_22_49","LUK","22","49","49","'Bhɛ 'yi 'tɛ, ‑yaa' ‑klaŋlanɛ ‑vin mu 'ɛ 'mu 'a 'yaangole 'bhii‑ ‑o ꞊nwa ‑a 'kunyrɛ‑ ‑la nɔɔ‑, 'ke 'mu 'a ‑lrɔkpale dɔɔ: «Mɛɛzan, 'o 'waa‑ ‑gɔkuŋ' mu 'ɛ 'si ‑o 'kaama‑ ɛɛ?» ");
INSERT INTO moa_vpl VALUES ("LK22_50","072_22_50","LUK","22","50","50","'Bhɛ klɛle 'tɛ, 'ke ‑yaa' ‑klaŋlanɛ mu 'ɛ do 'bhɛ a ‑gɔkuŋ' 'ɛ 'sile, 'bhɛɛ‑ 'kee‑ *'sraka 'lɛna mu a ‑kuŋlii gblaan 'ɛ 'bhɛ a yewonɛ mu 'ɛ do gbɛ ‑yiɛ' ta 'trɔn 'ɛ takanle ‑lɛyan' do. ");
INSERT INTO moa_vpl VALUES ("LK22_51","072_22_51","LUK","22","51","51","‑Ayile, 'ke Zesu 'a 'pele dɔɔ: «'Ka 'laa gwledanlɛ.» 'Bhɛ yrɛ do 'ɛ ꞊nɔɔ bhe 'kee‑ 'trɔn kpu 'ɛ 'sile, 'kee‑ 'bhɛ blɔɔle‑ 'bhɛ 'kpayrɛ 'ɛ ꞊nɔɔ, 'bhɛɛ‑ 'ke 'bhɛ 'bheele. ");
INSERT INTO moa_vpl VALUES ("LK22_52","072_22_52","LUK","22","52","52","'Bhɛ blaan, 'ke Zesu 'a 'pele 'sraka 'lɛna mu ‑kuŋlii mu 'ɛ 'pegee ‑Waanbhaa' Gba 'Fɛ ‑Gbɛnɛ 'ɛ gooba ‑kuŋlii mu 'ɛ, 'bhɛɛ‑ 'gwlaan‑ gblaan mu 'la ꞊nwa ‑a 'kaama‑ 'mu ni dɔɔ: «'Ka ꞊nwa 'ŋ 'kunyrɛ‑ nɔɔ‑ ‑gɔkuŋ' 'pegee 'beni mu 'le 'ka 'kɔɔ, 'bhii‑ 'ka ꞊nwa mɛɛ dɛ mi do ‑la 'kunyrɛ‑ nɔɔ‑.» ");
INSERT INTO moa_vpl VALUES ("LK22_53","072_22_53","LUK","22","53","53","«‑Mɛle ‑kla 'ŋ 'yaa‑ yikpɛn‑ ta ‑Waanbhaa' Gba 'Fɛ ‑Gbɛnɛ 'ɛ ꞊la, 'bhɛɛ‑ 'ka 'laa 'ŋ 'kunlɛ‑ ɛɛ? 'Duŋ‑ 'ka mu 'pegee ‑Setran' a pɛ ‑glɔɔya' klɛ 'waati 'ɛ 'bhɛ ‑le ꞊bhwa ‑zɔn ‑gɛ.» ");
INSERT INTO moa_vpl VALUES ("LK22_54","072_22_54","LUK","22","54","54","'Bhɛ klɛle 'tɛ, 'ke ‑o Zesu 'kunle, 'bhɛɛ‑ 'ke ‑o gele‑ 'kɛle‑ 'sraka 'lɛna mu ‑kuŋlii gblaan 'ɛ ba 'fa ꞊la. 'Bhɛɛ‑ 'duŋ‑ Piɛri ꞊bwa ‑o ‑zanta' 'egbɔɔnle, 'kee‑ nu sasa, 'bhɛɛ‑ ‑e ꞊wlaa 'bhɛ ‑gbeŋ 'ɛ 'yi. ");
INSERT INTO moa_vpl VALUES ("LK22_55","072_22_55","LUK","22","55","55","Mɛɛ mu 'ɛ ‑o 'tɛ do ‑lɛswan 'yee‑ 'sraka 'lɛna mu ‑kuŋlii ‑gbɛnɛ 'ɛ ‑yaa' ‑gbeŋ 'ɛ 'yi, 'bhɛɛ‑ ‑o ‑yaa ‑o maga 'zi 'bhɛ ma. ‑Ayile 'ke 'yee‑ Piɛri 'nule yaalɛ ‑o pleŋ‑ 'ezin‑. ");
INSERT INTO moa_vpl VALUES ("LK22_56","072_22_56","LUK","22","56","56","'Bhɛ klɛle 'tɛ, 'ke 'yee‑ 'sraka 'lɛna mu ‑kuŋlii ‑gbɛnɛ 'ɛ ‑yaa' 'fɛ 'ɛ ꞊la yewo le ‑nɛ mu 'ɛ do 'yee‑ Piɛri 'yele‑ 'tɛ 'ɛ ‑din, 'bhɛɛ‑ 'ke 'bhɛ 'e 'yrɛkpale ‑a ta frii, 'bhɛɛ‑ 'ke 'bhɛ 'a 'pele dɔɔ: «'Yee‑ Zesu 'ɛ ‑yaa' ‑klaŋlanɛ mu 'ɛ do ‑le ‑gɛ!» ");
INSERT INTO moa_vpl VALUES ("LK22_57","072_22_57","LUK","22","57","57","'Bhɛ ꞊nɔɔ bhe, 'ke Piɛri 'e 'lɛmadɔle 'eglɔɔle, 'bhɛɛ‑ 'ke ‑ya pele‑ dɔɔ: «'Bhi le 'la bhe, 'naa 'yee‑ mɛɛ 'lɛɛ‑ dɔ 'dɛ!» ");
INSERT INTO moa_vpl VALUES ("LK22_58","072_22_58","LUK","22","58","58","'Bhɛ blaan 'waati sa 'kanle‑, mɛɛ ‑bhɛɛke' do 'a 'yele‑ 'ke 'bhɛ 'a 'pele 'a ni dɔɔ: «'Mi 'a 'yaango‑ 'bhii‑ 'bhi ‑o 'yee Zesu 'ɛ ‑yaa' ‑klaŋlanɛ mu 'ɛ do 'le ‑kpɔ!» 'Duŋ‑ Piɛri pe 'ezin‑ 'bhɛ mɛɛ 'ɛ ni dɔɔ: «'Yooye‑, 'naa ‑o 'ke 'a do 'le!» ");
INSERT INTO moa_vpl VALUES ("LK22_59","072_22_59","LUK","22","59","59","'Bhɛ blaan 'waati sa 'kanle boolazi, 'ke mɛɛ ‑bhɛɛke' do 'a 'pele kpataakpa dɔɔ: «'Mi 'gbu 'kpale ‑o ‑a ‑yi 'bhii‑ mɛɛ 'lɛɛ‑ ‑yoo 'ke Zesu a ‑klaŋlanɛ mu 'ɛ do 'le, ‑amasrɔyi ‑e da Galile 'trɛ ta.» ");
INSERT INTO moa_vpl VALUES ("LK22_60","072_22_60","LUK","22","60","60","'Bhɛ klɛle 'tɛ, 'ke Piɛri 'a 'pele dɔɔ: «'E go 'ŋ 'yrɛ ꞊la doo, 'yoo‑ ‑we 'zi mɛɛ 'la zan 'le 'naa 'bhɛ zan 'ɛ dɔ.» Yaa yanlɛ ‑li 'bhɛ ‑jan 'ɛ 'wolele bhla 'la ba, 'ke maagwlɛn do ‑wele'. ");
INSERT INTO moa_vpl VALUES ("LK22_61","072_22_61","LUK","22","61","61","'Bhɛ klɛle 'tɛ, 'ke Mɛɛzan Zesu 'e 'yrɛkpale 'bhɛ ‑zanta', 'bhɛɛ‑ 'ke ‑o ‑yrɛ bɔle‑ 'eke‑ wlɛyi'. 'Bhɛla‑ ‑yile, Zesu ‑jan 'la 'bhɛ ꞊woa 'yee‑ Piɛri ni, 'bhɛ ‑dwa ‑a 'kpee dɔɔ: «'Sani‑ maagwlɛn ‑weli' pleŋ‑ ‑zɔn, 'e nu 'e 'lɛmadɔlɛ 'mi ma 'eglɔɔle gaan yaga 'kaa 'yaa 'mi dɔ.» ");
INSERT INTO moa_vpl VALUES ("LK22_62","072_22_62","LUK","22","62","62","‑Ayile, 'yee‑ Piɛri 'pwɛle‑ 'tɛ ‑gbeŋ 'ɛ 'yi, 'kee‑ wisile 'ebebele. ");
INSERT INTO moa_vpl VALUES ("LK22_63","072_22_63","LUK","22","63","63","‑Srwase' mu 'la 'yaa‑ Zesu gooba, 'mu 'yaa‑ ‑a malrɔgo 'zi, 'bhɛɛ‑ 'mu 'yaa‑ zɔn 'zi 'ezin‑. ");
INSERT INTO moa_vpl VALUES ("LK22_64","072_22_64","LUK","22","64","64","‑O sɔ ‑bhulaa' 'a wlɛyi', 'bhɛɛ‑ 'ke ‑wa ‑lrɔkpa' dɔɔ: «Mɛɛ 'la zan 'e ꞊zwan bhe, 'bhɛ zan 'ɛ 'tɔkan 'o ni doo!» ");
INSERT INTO moa_vpl VALUES ("LK22_65","072_22_65","LUK","22","65","65","'Bhɛɛ‑ 'ezin‑, ‑wa ‑zwanwoa gɔn 'ɛ 'kpɛn gbɛɛn‑. ");
INSERT INTO moa_vpl VALUES ("LK22_66","072_22_66","LUK","22","66","66","Too ‑klinle', 'ke Zuufu mu 'ɛ ‑waa' 'gwlaan‑ gblaan mu 'ɛ 'pegee 'sraka 'lɛna ‑kuŋlii mu 'ɛ, 'bhɛɛ‑ 'Toŋ daan mu 'ɛ ‑woo ‑lɛkpale 'eke‑ ta. 'Bhɛɛ‑ 'ke ‑wa pele‑ dɔɔ ‑o nu Zesu 'le ‑o ta. ");
INSERT INTO moa_vpl VALUES ("LK22_67","072_22_67","LUK","22","67","67","Zesu 'nule‑, 'ke ‑o 'bhɛ 'lrɔkpale dɔɔ: «'Bhi ‑le 'ke Mɛɛ ‑Bhee Mi ‑kpɔsɔɔ Krisi 'le ɛɛ?» Zesu pe ‑o ni dɔɔ: «'Ke 'an ꞊pia 'ka ni dɔɔ 'mi ‑le 'kɛle‑, 'ka 'laa nu 'ka 'kpalɛ‑ 'mi 'yi. ");
INSERT INTO moa_vpl VALUES ("LK22_68","072_22_68","LUK","22","68","68","'Bhɛɛ‑ 'ke 'ŋ ‑za do ‑yilrɔkpaa 'ka ma, 'ka 'laa nu 'bhɛ zikpalɛ 'ŋ ni. ");
INSERT INTO moa_vpl VALUES ("LK22_69","072_22_69","LUK","22","69","69","'Duŋ‑ 'kee‑ san ‑zɔn ma, Bhaaplɛŋ Gbe 'ɛ 'yaale‑ nu klɛlɛ ‑Waanbhaa' ‑glɔɔ ‑a ‑din 'tɔbhɔ ma yaayrɛ 'ɛ 'nɔɔ‑.» ");
INSERT INTO moa_vpl VALUES ("LK22_70","072_22_70","LUK","22","70","70","'Bhɛ klɛle 'tɛ, 'ke ‑o 'kpɛn 'a 'lrɔkpale dɔɔ: «'Bhɛ 'yi bhe, 'bhi ‑le 'ke *‑Waanbhaa' Gbe 'ɛ 'le ɛɛ?» Zesu 'a 'lɛkwan꞊ ‑o ni dɔɔ: «'Ka ‑o 'yela‑ pe 'zi bhe.» ");
INSERT INTO moa_vpl VALUES ("LK22_71","072_22_71","LUK","22","71","71","'Bhɛ klɛle 'tɛ, 'ke ‑wa pele‑ dɔɔ: «‑Kɔɔ' maza ‑o 'srɛya‑ ‑bhɛɛke' klɛle ma ‑li ɛɛ? 'Yele‑ ‑daa ‑a 'gbu 'lii bhe.» ");
INSERT INTO moa_vpl VALUES ("LK23_1","072_23_1","LUK","23","1","1","'Bhɛ blaan, 'ke 'woo‑ 'kitikan mɛɛ ‑lɛdo' 'ɛ ‑o 'kpɛn ‑o ‑wlɛnle', 'ke ‑o gele‑ Zesu 'le ‑Janmatii Pilati ba. ");
INSERT INTO moa_vpl VALUES ("LK23_2","072_23_2","LUK","23","2","2","‑O bhɔle 'bhɛ ba, 'ke ‑o bhla ‑glɔɔn 'ɛ 'kpɛn 'kpale‑ 'sanle Zesu ma. ‑O pe dɔɔ: «'O ꞊bhwa mɛɛ 'lɛɛ‑ ta 'ke ‑yoo ‑kɔɔa' mɛɛ mu 'ɛ 'trɔn 'yidɔ‑ 'zi 'eglɔɔle, 'bhɛɛ‑ 'ke ‑ya pe 'mu ni 'ezin‑ dɔɔ 'mu 'laa ‑bhleŋgbe ‑gbɛnɛ Sezaa a 'nisra 'ɛ gbawolɛ. 'Bhɛɛ‑ ‑ya pe ‑a 'gbu ma 'kaa ‑yoo 'ke Mɛɛ ‑Bhee Mi ‑kpɔsɔɔ Krisi 'pegee ‑bhleŋgbe 'le.» ");
INSERT INTO moa_vpl VALUES ("LK23_3","072_23_3","LUK","23","3","3","'Bhɛ klɛle 'tɛ, 'ke Pilati 'a 'lrɔkpale dɔɔ: «'Bhi ‑le 'ke Zuufu mu a ‑bhleŋgbe 'ɛ 'le ɛɛ?» 'Bhɛ 'yi 'tɛ, 'ke Zesu 'a zikpale 'a ni dɔɔ: «'E 'gbu 'yela‑ ꞊pia bhe.» ");
INSERT INTO moa_vpl VALUES ("LK23_4","072_23_4","LUK","23","4","4","'Bhɛ blaan, 'ke Pilati 'a 'pele 'sraka 'lɛna ‑kuŋlii mu 'ɛ 'pegee ‑zamaa' 'ɛ ni dɔɔ: «Mɛɛ 'lɛɛ‑ yaa ‑za 'yɔɔ do 'kpɔ klɛlɛ, 'bhɛla‑ ‑yile 'naa sɔ ‑kpan baale' 'a ta.» ");
INSERT INTO moa_vpl VALUES ("LK23_5","072_23_5","LUK","23","5","5","'Duŋ‑ ‑o pe 'ezin‑ 'eglɔɔle dɔɔ: «‑E ‑kaan yrɛ mu 'la 'kpɛn ꞊nɔɔ: 'Kee‑ san Galile 'klɛɛn 'ɛ 'yi, 'kee‑ ‑e kan Zude 'klɛɛn 'ɛ 'yi, 'bhɛɛ‑ 'kee‑ nu 'pwɛlɛ‑ Zeruzalɛmu ‑gɛ, ‑e mɛɛ mu 'ɛ daan 'zi dɔɔ 'mu 'wlɛn ‑kɔɔ' 'lɛɛ mu 'ɛ ma.» ");
INSERT INTO moa_vpl VALUES ("LK23_6","072_23_6","LUK","23","6","6","*Pilati 'bhɛ ‑jan mu 'ɛ 'male‑, 'ke ‑yoo ‑lrɔkpale dɔɔ: «Galile 'trɛ ta mi ‑le mɛɛ 'lɛɛ‑ 'le ɛɛ?» ");
INSERT INTO moa_vpl VALUES ("LK23_7","072_23_7","LUK","23","7","7","‑O pe a ni 'kaa ‑e da Galile 'trɛ ta ‑a ma. ‑E 'bhɛ 'male‑, 'ke ‑ya pele‑ dɔɔ ‑o ge Zesu 'le Erɔdi ta, ‑amasrɔyi Erɔdi ‑yaa ‑janmatii 'le 'yee‑ Galile 'trɛ 'ɛ ta, 'bhɛɛ‑ ‑za mu 'lɛɛ‑ klɛ bhla 'ɛ ba 'ke ‑yoo Zeruzalɛmu ‑wa 'ɛ ta. 'Bhɛɛ‑ ‑o ‑ja 'kɛle‑ Erɔdi ba 'tɛ. ");
INSERT INTO moa_vpl VALUES ("LK23_8","072_23_8","LUK","23","8","8","'Bhɛ 'yi, Erɔdi Zesu 'yele‑, 'ke ‑a zrukpaale 'egbɛnɛle. ‑Amasrɔyi ‑e ‑jan ‑bebe ꞊maa Zesu ba zayi', 'bhɛɛ‑ 'bhɛ 'ye ‑lrɔ ‑yaa ‑a ma 'egwele. ‑A yri ‑yaa ‑a ta dɔɔ 'bhɛ nu 'sɔle‑ maza do klɛlɛ ‑a ‑yrɛ ma. ");
INSERT INTO moa_vpl VALUES ("LK23_9","072_23_9","LUK","23","9","9","‑Ayile, 'kee‑ ‑za ‑bebe 'yilrɔkpale 'bhɛ ma, 'duŋ‑ 'bhɛ 'laa 'bhɛ do 'kpɔ zikpalɛ a ni. ");
INSERT INTO moa_vpl VALUES ("LK23_10","072_23_10","LUK","23","10","10","'Duŋ‑, 'sraka 'lɛna ‑kuŋlii mu 'ɛ 'pegee 'Toŋ daan mu 'ɛ 'mu 'yaa‑ bhla ‑glɔɔn 'ɛ 'kpɛn 'kpa zii' Zesu ma. ");
INSERT INTO moa_vpl VALUES ("LK23_11","072_23_11","LUK","23","11","11","'Bhɛ ya 'ɛ 'yi, Erɔdi 'pegee ‑yaa' ‑srwase' mu 'ɛ ‑o Zesu malrɔgwa, 'bhɛɛ‑ 'ke ‑wa mavɛɛle 'eyɔɔle. 'Bhɛ blaan, 'ke ‑o dunɛ‑ 'lrele‑ ‑yrayra do 'klale 'bhɛ ta, 'bhɛɛ‑ 'ke ‑o gele‑ 'kɛle‑ Pilati ba 'ezin‑. ");
INSERT INTO moa_vpl VALUES ("LK23_12","072_23_12","LUK","23","12","12","‑Sɔɔnaya ‑yaa Erɔdi 'pegee Pilati 'pleŋ‑ 'elwale ‑sɔ, 'duŋ‑ 'bhɛ ‑yrekpaa' do 'ɛ le ‑o bhɛgwlɛnya ‑dwa. ");
INSERT INTO moa_vpl VALUES ("LK23_13","072_23_13","LUK","23","13","13","*Pilati 'sraka 'lɛna ‑kuŋlii mu 'ɛ 'pegee Zuufu mu ‑lɛɛ mu 'ɛ, 'bhɛɛ‑ Zuufu 'si mu 'kpɛn 'lɛkpaa‑ 'eke‑ ta. ");
INSERT INTO moa_vpl VALUES ("LK23_14","072_23_14","LUK","23","14","14","'Bhɛɛ‑ ‑e pe ‑o ni dɔɔ: «'Ka ꞊nwa mɛɛ 'lɛɛ‑ 'le 'ŋ ni, 'bhɛɛ‑ 'ka pe dɔɔ ‑e ‑yaa mɛɛ mu 'ɛ 'wlɛn zii' ‑kɔɔ' 'lɛɛ mu 'ɛ ma. 'An 'lrɔkpaa‑ 'ka 'kpɛn 'yrɛ ma ‑gɛ. 'Bhɛɛ‑ 'ka 'yaa‑ ‑la 'zi 'a ta ‑za mu 'la 'kpɛn 'yi, 'naa 'a 'yelɛ‑ 'bhɛ ‑za mu 'ɛ do 'kpɔ klɛ mi 'le. ");
INSERT INTO moa_vpl VALUES ("LK23_15","072_23_15","LUK","23","15","15","*Erɔdi 'duŋ‑, 'laa ‑za 'yɔɔ‑ do 'kpɔ 'yelɛ‑ ‑a zi 'ezin‑, ‑ayile 'bhɛ ꞊nwa 'kɛle‑ ‑kɔɔ' mu ta 'ezin‑ ‑gɛ. 'Bhɛ ya 'ɛ 'yi, 'yee‑ mɛɛ 'lɛɛ‑ yaa ‑za 'yɔɔ‑ dɔ 'kpɔ klɛlɛ 'ke 'bhɛ sɔ klɛle‑ a dɛ win 'le. ");
INSERT INTO moa_vpl VALUES ("LK23_16","072_23_16","LUK","23","16","16","'Ŋ nu a pelɛ 'kaa ‑wa zita zɔn 'ke gbaŋbhlɛ 'le, 'bhɛ blaan 'ŋ nu 'ploolɛ‑ ‑a ma.» ");
INSERT INTO moa_vpl VALUES ("LK23_17","072_23_17","LUK","23","17","17","Lɛɛ 'oo lɛɛ, 'bhɛɛ‑ *Paki 'fɛti oo Paki 'fɛti ta, Pilati ‑yaa ploo ‑kaso 'yi mi do ma ‑o ni. ");
INSERT INTO moa_vpl VALUES ("LK23_18","072_23_18","LUK","23","18","18","'Duŋ‑ Pilati 'yanle‑ 'bhɛ ‑jan 'ɛ 'wolele ‑o ni, 'ke ‑o 'kpɛn ‑o ‑weli' 'ɛ 'wlɛnle 'eke‑ zi 'eglɔɔle dɔɔ: «‑A pe ‑o mɛɛ 'lɛɛ‑ dɛ, 'bhɛɛ‑ ‑o 'ploo Barabasi ma 'o ni!» ");
INSERT INTO moa_vpl VALUES ("LK23_19","072_23_19","LUK","23","19","19","'Duŋ‑ Barabasi 'laa bɔlɛ ‑kaso 'yi bhaama. ‑Wa ꞊bwa ‑kaso 'yi, ‑amasrɔyi ‑e ‑yaa mɛɛ mu ‑wlɛn 'zi ‑o ‑lɛɛ mu 'ɛ ma Zeruzalɛmu, 'bhɛɛ‑ ‑e mɛɛ do ‑dia ‑sɔ. ");
INSERT INTO moa_vpl VALUES ("LK23_20","072_23_20","LUK","23","20","20","Pilati ‑yaa ‑a zi 'bhii‑ ‑e 'ploo Zesu ma, 'bhɛla‑ ‑yile ‑e ‑zamaa' 'ɛ 'lrɔkpa gbɛ drɛɛwoa‑ 'ezin‑. ");
INSERT INTO moa_vpl VALUES ("LK23_21","072_23_21","LUK","23","21","21","'Duŋ‑ ‑woo ‑weli' 'ɛ 'wlɛnna‑ 'eke‑ zi 'eglɔɔle dɔɔ: «‑Kaa gbaan ‑yrigbɛɛle 'ɛ ta, 'bhɛɛ‑ ‑e ga; ‑kaa gbaan ‑yrigbɛɛle 'ɛ ta 'bhɛɛ‑ ‑e ga!» ");
INSERT INTO moa_vpl VALUES ("LK23_22","072_23_22","LUK","23","22","22","'Bhɛ klɛle 'tɛ, 'ke Pilati ‑o ‑lrɔkpa' gbɛ ‑glɔɔn yaga mi ‑wole dɔɔ: «‑E ‑mɛ pɛ ‑za 'yɔɔ‑ 'gbu ‑la ‑kla ɛɛ? 'Naa ‑za 'yɔɔ‑ do 'kpɔ 'yelɛ‑ ‑a zi 'ke 'bhɛ klɛ ‑a dɛ win 'le. 'Duŋ‑ 'ŋ nu a pelɛ 'kaa ‑wa zita zɔn, 'bhɛ blaan 'ŋ nu 'ploolɛ‑ ‑a ma.» ");
INSERT INTO moa_vpl VALUES ("LK23_23","072_23_23","LUK","23","23","23","'Duŋ‑ ‑woo ‑weli' mu 'ɛ 'wlɛnna‑ 'eke‑ zi 'eglɔɔle dɔɔ ‑o Zesu gbaan ‑yrigbɛɛle 'ɛ ta. ‑O ‑bolawoa 'pɛɛnle‑ ma 'ke Pilati dɔle‑ ‑a ꞊la ‑o ni. ");
INSERT INTO moa_vpl VALUES ("LK23_24","072_23_24","LUK","23","24","24","'Bhɛ ya 'ɛ 'yi bhe, Pilati ‑dwa ‑a ‑la 'ke ‑yoo ‑o zru maza 'ɛ klɛ. ");
INSERT INTO moa_vpl VALUES ("LK23_25","072_23_25","LUK","23","25","25","‑Ayile, 'kee‑ 'ploole mɛɛ 'la zan ‑o 'bhɛ ꞊bwa ‑kaso 'yi mɛɛ mu ‑wlɛnle' ma ‑o ‑lɛɛ mu 'ɛ ma, 'bhɛ 'pegee mɛɛ dɛle ma. 'Bhɛɛ‑ ‑e Zesu ꞊kpaa ‑o 'kɔɔ 'kaa 'ke ‑za yɛkɛ‑ 'la klɛle‑ ‑swa ‑o ni ‑a ni ‑o 'bhɛɛ‑ klɛ. ");
INSERT INTO moa_vpl VALUES ("LK23_26","072_23_26","LUK","23","26","26","‑Zamaa' 'ɛ 'yaa‑ ge 'zi bhla 'la ba Zesu dɛyrɛ 'ɛ ꞊nɔɔ, 'ke ‑o ‑lɛpale Sirɛni ‑wa 'ɛ ta mɛɛ do 'le, ‑o ‑yaa 'bhɛ sii Simɔ, 'bhɛ ‑yaa da 'zi gba la. 'Bhɛ 'yi 'tɛ, 'ke ‑wa pele‑ 'bhɛ ni dɔɔ 'bhɛ Zesu gbaan ‑yrigbɛɛle 'ɛ 'si 'bhɛɛ‑ ‑e dɔ Zesu zi. ");
INSERT INTO moa_vpl VALUES ("LK23_27","072_23_27","LUK","23","27","27","‑Zamaa' 'srɛ do ‑yaa Zesu zi, 'bhɛɛ‑ le 'ke mu ‑yaa ‑yrɛn ma wisi' zii' ‑a zi. ");
INSERT INTO moa_vpl VALUES ("LK23_28","072_23_28","LUK","23","28","28","'Bhɛla‑ ‑yile, 'ke ‑ya ‑lɛklale 'mu ta, 'bhɛɛ‑ 'ke ‑ya pele‑ 'mu ni dɔɔ: «Zeruzalɛmu le mu, 'ka 'laa wisilɛ 'mi zi, 'duŋ‑ ‑ka wisi' 'ka 'gbu 'pegee 'ka 'nɛ mu ‑la ‑za ma. ");
INSERT INTO moa_vpl VALUES ("LK23_29","072_23_29","LUK","23","29","29","‑Amasrɔyi 'bhɛ yi ‑o zan bhɔlɛ, 'bhɛɛ‑ ‑o nu ‑a pelɛ dɔɔ: ‹Le mu 'la waa ‑nɛ 'srɔɔwolɛ ‑lido', 'bhɛ 'pegee le mu 'la waa ‑nɛ 'yalɛ‑ ‑lido', 'bhɛɛ‑ le mu 'la waa ‑yɔn 'nalɛ‑ ‑lido' ‑nɛ 'yiɛntɛnnɛ mu ni, 'mu a pɛ ‑yinra'!› ");
INSERT INTO moa_vpl VALUES ("LK23_30","072_23_30","LUK","23","30","30","‑Amasrɔyi 'bhɛ yi 'ɛ 'le, bhaaplɛŋ mu nu ‑a pelɛ vlɛ gɔɔn mu ni 'kaa: ‹‑Ka bala‑ 'o ta 'bhɛɛ‑ 'ka 'o dɛ!› 'Bhɛɛ‑ ‑o nu ‑a pelɛ 'trɛ gɔɔn mu ni dɔɔ: ‹‑Ka bhula‑ 'o ta!› ");
INSERT INTO moa_vpl VALUES ("LK23_31","072_23_31","LUK","23","31","31","‑Amasrɔyi 'ke ‑o 'bhɛ ‑za 'yɔɔ‑ ‑glɔɔn 'lɛɛ‑ ꞊kla ‑yri ‑dɔɔ 'ɛ ni; waa nu za 'yɔɔ‑ ‑glɔɔn 'ɛ ‑dela ‑la klɛlɛ ‑yri ‑kpaa 'ɛ ni ɛɛ?» ");
INSERT INTO moa_vpl VALUES ("LK23_32","072_23_32","LUK","23","32","32","'Bhɛ ꞊nɔɔ bhe 'ezin‑, 'yee‑ ‑zamaa' do 'ɛ 'yaa‑ ge 'zi mɛɛ dɛ mi plɛ dɛlɛ ‑o 'pegee Zesu 'le. ");
INSERT INTO moa_vpl VALUES ("LK23_33","072_23_33","LUK","23","33","33","‑O bhɔle ‑o yrɛ 'la ‑o 'bhɛ sii: ‹Bhaaplɛŋ ŋgblo bhɛlɛ' yrɛ›, 'ke ‑o Zesu gbaanle‑ ‑yrigbɛɛle 'ɛ ta. 'Bhɛɛ‑ 'ezin‑, 'ke ‑o 'yee‑ mɛɛ dɛ mi plɛ 'ɛ gbaanle‑ Zesu ‑din: ‑A do ‑yaa ‑a gbɛ ‑yiɛ' ta, 'bhɛɛ‑ ‑a ‑bhɛɛke' do 'ɛ 'yaa‑ ‑a gbɛ ‑koo ta. ");
INSERT INTO moa_vpl VALUES ("LK23_34","072_23_34","LUK","23","34","34","'Bhɛ klɛle 'tɛ, 'ke Zesu 'e 'seriwole dɔɔ: «'Ŋ Dɛ, waa ‑sroma 'yan, ‑amasrɔyi ‑o ‑za 'la klɛ 'zi waa 'bhɛ 'yaango‑.» 'Bhɛ blaan, 'ke ‑o 'tete dɔle‑ ‑a tapɛ mu 'ɛ ta, 'kooko‑ ‑o 'kpɛn do do dɔ ‑o 'kɛla 'le ‑o 'bhɛ dɔ. ");
INSERT INTO moa_vpl VALUES ("LK23_35","072_23_35","LUK","23","35","35","Izraɛli 'si mu 'ɛ 'kpɛn 'yaa‑ Zesu ‑glin 'zi. 'Bhɛ bhla 'ɛ ba, 'ke Zuufu mu ‑lɛɛ mu 'ɛ ‑wa malrɔgo 'ke ‑wa pe dɔɔ: «‑E mɛɛ ‑vin mu 'ɛ ‑gwa ‑za ‑yi, 'ke ‑yoo 'ke Mɛɛ ‑Bhee Mi ‑kpɔsɔɔ Krisi 'la 'ke ‑Waanbhaa' 'bhɛ makwan‑ 'bhɛ 'le, ‑ya 'gbu 'bhee‑ ‑zɔn doo, 'bhɛɛ‑ 'o 'bhɛ ye!» ");
INSERT INTO moa_vpl VALUES ("LK23_36","072_23_36","LUK","23","36","36","'Bhɛ ꞊nɔɔ bhe 'ezin‑, ‑srwase' mu 'ɛ 'yaa‑ ‑a malrɔgo 'zi. 'Bhɛ mu 'mu 'mabɛɛnna ‑a ‑din, 'bhɛɛ‑ 'ke 'mu ‑wɛɛn 'tɔnle‑ do zrɔnle‑ ‑a ni, ");
INSERT INTO moa_vpl VALUES ("LK23_37","072_23_37","LUK","23","37","37","'bhɛɛ‑ 'mu pe ‑a ni dɔɔ: «'Kee 'yoo‑ 'ke Zuufu mu a ‑bhleŋgbe 'le kpataakpa, 'e 'gbu 'bhee‑, 'bhɛɛ‑ 'o 'bhɛ ye!» ");
INSERT INTO moa_vpl VALUES ("LK23_38","072_23_38","LUK","23","38","38","Mɛɛ mu 'ɛ ‑o 'sɛwɛ ‑glɔɔn 'lɛɛ‑ 'bhɛ yɔɔndia‑ ‑yri 'peenɛ do ta, 'bhɛɛ‑ ‑o 'bhɛ ‑gbaanna Zesu ŋgblo 'ɛ trala dɔɔ: ");
INSERT INTO moa_vpl VALUES ("LK23_39","072_23_39","LUK","23","39","39","'Bhɛ 'yi 'tɛ, ‑o mɛɛ dɛ mi plɛ 'la ‑gbaanna ‑a gbɛ ‑yiɛ' 'pegee ‑a gbɛ ‑koo 'ɛ ta, 'mu do 'a ‑zwanwole ‑saan dɔɔ: «'Bhi ‑le 'laa ‑o 'ke Mɛɛ ‑Bhee Mi ‑kpɔsɔɔ Krisi 'ɛ 'le ɛɛ? 'E 'gbu 'bhee‑ 'pe, 'bhɛɛ‑ 'yoo mɔɔ bhee 'bhɛ blaan!» ");
INSERT INTO moa_vpl VALUES ("LK23_40","072_23_40","LUK","23","40","40","'Duŋ‑ ‑a ‑vindo' mi 'ɛ 'bhɛ ‑yaa' ‑janwo' gbɛya 'ɛ mazapia ‑a ni dɔɔ: «'Yaa gblaan ‑Waanbhaa' ‑lɛɛ ɛɛ? ‑O 'yee‑ ‑yrɛn do 'kpɔ 'ɛ 'kpa zii' 'bhi 'la 'bhi ta 'ezin‑ bhe. ");
INSERT INTO moa_vpl VALUES ("LK23_41","072_23_41","LUK","23","41","41","'Mi 'pegee 'bhi a pɛ dɛza 'ɛ, 'bhɛ ‑o 'ke wlan ma 'kitikanle 'le. ‑Amasrɔyi 'o ‑za 'yɔɔ‑ mu 'la ꞊kla, 'bhɛ mu ‑la ‑zanta' za ‑le 'tɛn zii' 'o ma. 'Duŋ‑ 'yee‑ 'laa ‑za 'yɔɔ‑ do 'kpɔ klɛlɛ ‑titi.» ");
INSERT INTO moa_vpl VALUES ("LK23_42","072_23_42","LUK","23","42","42","'Bhɛ 'yanle‑ 'bhɛ ‑jan 'ɛ 'wolele, 'ke 'bhɛ 'a pele‑ Zesu ni dɔɔ: «Zesu, 'ŋ ‑za bo 'e 'kpee 'kee ꞊nwa yi 'la ta yaa ‑bhleŋgbeya yaayrɛ 'ɛ ꞊nɔɔ.» ");
INSERT INTO moa_vpl VALUES ("LK23_43","072_23_43","LUK","23","43","43","'Bhɛ klɛle 'tɛ, 'ke Zesu 'a pele 'a ni dɔɔ: «'Mi pe 'e ni 'ŋ 'sɔwɛɛ‑ ma dɔɔ, 'mi 'pegee 'bhi 'o nu gelɛ ‑Waanbhaa' ba ‑zɔn.» ");
INSERT INTO moa_vpl VALUES ("LK23_44","072_23_44","LUK","23","44","44","‑Yrekpaa' bhɔ 'waati 'ɛ ba sasa, 'ke ‑yretɛ' 'liile‑, 'bhɛɛ‑ 'ke ‑gblo 'kpale Izraɛli 'klɛɛn 'ɛ 'kpɛn ta, 'ke 'bhɛ ge 'tɛnlɛ‑ yromazi ‑yretɛbhɛ yanyan 'ɛ 'waati 'ɛ ma. ");
INSERT INTO moa_vpl VALUES ("LK23_45","072_23_45","LUK","23","45","45","'Bhɛɛ‑ sɔgbɛ ‑gbɛnɛ 'la 'yaa‑ ‑Waanbhaa' Gba 'Fɛ ‑Gbɛnɛ 'ɛ ꞊la, 'bhɛ 'peedia‑ plɛ 'bhɛ drɛyi'. ");
INSERT INTO moa_vpl VALUES ("LK23_46","072_23_46","LUK","23","46","46","'Bhɛ klɛle 'tɛ, 'ke Zesu 'pɛɛnle 'eglɔɔle dɔɔ: «'Ŋ Dɛ 'mi 'ŋ 'nii‑ 'ɛ gbɛkpaa‑ 'e 'kɔɔ.» 'Bhɛ blaan, 'ke ‑a nii‑ 'ɛ gole‑ ‑a ‑yi. ");
INSERT INTO moa_vpl VALUES ("LK23_47","072_23_47","LUK","23","47","47","Romɛ mu a ‑srwase' ‑kuŋlii 'la dulale ‑yaa 'yee‑ gɔn 'ɛ ꞊nɔɔ, 'bhɛ 'bhɛ ‑za 'ɛ 'yele, 'ke 'bhɛ ‑Waanbhaa' 'tɔbhɔle dɔɔ: «Wlan 'gbu 'ɛ ni, mɛɛ 'lɛɛ‑ 'yaa‑ 'ke mɛɛ ‑lɛdɔɔle 'gbu ‑la ‑le.» ");
INSERT INTO moa_vpl VALUES ("LK23_48","072_23_48","LUK","23","48","48","Mɛɛ 'la zan mu 'kpɛn ꞊nwa 'yee‑ ‑za 'ɛ klɛyrɛ ‑glinlɛ', 'mu 'niina‑ bhla zi 'mu ba, wisi' ‑gbɔɔ 'ɛ 'kɔɔ, 'mu 'yaa‑ 'mu gbɛ 'kpa zii' 'mu zru ‑lii. ");
INSERT INTO moa_vpl VALUES ("LK23_49","072_23_49","LUK","23","49","49","Zesu dɔ mu 'ɛ 'kpɛn, 'bhɛ 'pegee le mu 'la ‑daa ‑a zi Galile 'klɛɛn 'ɛ 'yi, 'bhɛ mu 'kpɛn dulale ‑yaa 'egbɔɔnle 'ke 'mu 'a taglin. ");
INSERT INTO moa_vpl VALUES ("LK23_50","072_23_50","LUK","23","50","50","‑O ‑yaa mɛɛ do sii Zozɛfu. 'Bhɛ 'yaa‑ Zuufu mu a 'kitikan mɛɛ gblaan mu 'ɛ do 'le, 'bhɛɛ‑ 'bhɛ ‑yaa da Zude 'klɛɛn 'ɛ 'yi Zuufu mu a ‑wa 'la ‑o ‑yaa 'bhɛ sii Arimate 'bhɛɛ‑ ta. ");
INSERT INTO moa_vpl VALUES ("LK23_51","072_23_51","LUK","23","51","51","Mɛɛ wlan do ‑le ‑yaa 'kɛle‑, 'bhɛɛ‑ ‑a ‑lɛdɔɔle ‑yaa ‑Waanbhaa' ‑yrɛ 'yi. 'Bhɛɛ‑ ‑a yri ‑yaa ‑Waanbhaa' a ‑bhleŋgbeya yi 'ɛ 'bhɔle‑ ta. 'Bhɛla‑ ‑yile, ‑a ‑vin mu 'ɛ ‑za 'la ꞊kla Zesu ni, ‑yaa dɔlɛ 'mu zita. ");
INSERT INTO moa_vpl VALUES ("LK23_52","072_23_52","LUK","23","52","52","'Bhɛ ya 'ɛ 'yi, 'yee‑ Zozɛfu ‑ja Zesu gbaa 'ɛ 'yrɛwolɛ Pilati ma, 'kaa ‑e gele‑ 'bhɛ binlɛ. ");
INSERT INTO moa_vpl VALUES ("LK23_53","072_23_53","LUK","23","53","53","'Bhɛ 'yi 'tɛ, 'kee‑ Zesu gbaa 'ɛ gole‑ ‑yrigbɛɛle 'ɛ ta. 'Bhɛɛ‑ 'kee‑ sɔ 'pu 'peŋpeŋ do 'kpale 'bhɛ ma. 'Bhɛ blaan, 'kee‑ gele‑ 'bhɛ binlɛ bu ‑gluu drɛɛ drɛɛ do 'yi. ‑O 'bhɛ bu ‑gluu 'ɛ 'kwleela‑ vlɛ ‑saa do ‑la ‑yi, 'bhɛɛ‑ waa mɛɛ 'kedo‑ 'kpɔ binlɛ ‑lido' 'bhɛ bu 'ɛ 'yi. ");
INSERT INTO moa_vpl VALUES ("LK23_54","072_23_54","LUK","23","54","54","‑E ‑kla ‑klaago ma yromazi 'ɛ zi, Zuufu mu a ‑yitrɛ' yi 'ɛ 'bhɛ 'lɛɛ magaan yi 'ɛ 'le. ");
INSERT INTO moa_vpl VALUES ("LK23_55","072_23_55","LUK","23","55","55","Le mu 'la ‑daa Zesu zi Galile 'trɛ ta, 'bhɛ mu ‑yaa Zozɛfu ‑din Zesu bin bhla 'ɛ zi. 'Bhɛɛ‑ 'mu ‑yrɛkpaa ‑a gbaa 'ɛ 'kpaagbɛya 'ɛ ma bu ‑gluu 'ɛ 'yi. ");
INSERT INTO moa_vpl VALUES ("LK23_56","072_23_56","LUK","23","56","56","‑O yanle Zesu binlele, 'ke 'woo‑ le mu 'ɛ ‑o gele‑ ‑o ba; 'bhɛɛ‑ 'ke ‑wa gbaa ma 'sro ‑yrɔn mu 'pegee ‑lasiklɔɔ mu klɛle‑. 'Bhɛ blaan, 'ke ‑woo ‑yitrɛle ‑yitrɛ' yi 'ɛ ma, 'bhii‑ ‑wa klɛ gɔnɛ‑ 'la gbɛɛn‑ Zuufu mu a 'toŋ 'ɛ ta. ");
INSERT INTO moa_vpl VALUES ("LK24_1","072_24_1","LUK","24","1","1","'Kaŋgɔplɛ ma zrwan 'tutu 'ɛ zi, 'ke 'woo‑ le mu 'ɛ ‑o gele‑ Zesu bu 'ɛ ta. ‑O gbaa ma 'sro ‑yrɔn mu 'pegee ‑lasiklɔɔ ‑gblɛn 'nrale‑ mu 'la ꞊kla, 'mu ‑ja ‑o 'kɔɔ. ");
INSERT INTO moa_vpl VALUES ("LK24_2","072_24_2","LUK","24","2","2","‑O bhɔle bu ‑gluu 'ɛ ta, ‑wa ‑liitaan vlɛ ‑kpuŋ 'la 'le, 'ke ‑o 'bhɛ 'bhlile‑ yele‑ ‑a ‑lii 'ɛ ‑gɔma' 'egbɔɔnle. ");
INSERT INTO moa_vpl VALUES ("LK24_3","072_24_3","LUK","24","3","3","'Bhɛ klɛle 'tɛ, 'ke ‑o wlale‑ bu ‑gluu 'ɛ zi, 'bhɛɛ‑ waa Mɛɛzan Zesu gbaa 'ɛ 'yelɛ‑ 'bhɛ 'kpaayrɛ‑ 'ɛ ꞊nɔɔ. ");
INSERT INTO moa_vpl VALUES ("LK24_4","072_24_4","LUK","24","4","4","‑O ‑yaa ‑o 'kpeelɛdan 'zi bhla 'la ba 'bhɛ ma, 'ke mɛɛ plɛ 'pwɛle ‑o ba. 'Bhɛ mu ta dunɛ‑ mu 'ɛ 'yaa‑ flee 'e 'pu 'peŋpeŋle. ");
INSERT INTO moa_vpl VALUES ("LK24_5","072_24_5","LUK","24","5","5","‑Gblaan ‑gbɛnɛ 'ɛ 'kɔɔ, ‑woo 'kpɔ ꞊zian, 'bhɛɛ‑ ‑woo ŋgblo ‑kulaa' 'trɛ ma. 'Bhɛɛ‑ 'ke 'mu 'a pele‑ ‑o ni dɔɔ: «‑Mɛle ꞊kla 'bhɛɛ mɛɛ 'la zan ‑o ‑a ‑yrɛ ma, 'ka ‑o 'bhɛ ziglin‑ 'zi mɛɛ gbaa mu 'ɛ pleŋ‑ ɛɛ? ");
INSERT INTO moa_vpl VALUES ("LK24_6","072_24_6","LUK","24","6","6","Yaa ‑o ‑gɛ titi, ‑e ‑bwela gale ba. ‑E ‑yaa 'waati 'la ba Galile 'trɛ ta, ‑e ‑jan 'la ꞊woa 'ka ni, 'bhɛ 'laa ‑o 'ka 'kpee ɛɛ! ‑Ya ꞊pia 'ka ni dɔɔ: ");
INSERT INTO moa_vpl VALUES ("LK24_7","072_24_7","LUK","24","7","7","‹‑A ‑lɛdulale ‑o dɔɔ ‑o nu *Bhaaplɛŋ Gbe 'ɛ 'kpalɛ‑ ‑za 'yɔɔ‑ klɛ mu 'kɔɔ, 'bhɛɛ‑ 'mu 'a gbaan ‑yrigbɛɛle 'ɛ ta. 'Duŋ‑ ‑e nu bwelɛ gale ba a gale blaan ‑yrekpaa' yaga mi ma.›» ");
INSERT INTO moa_vpl VALUES ("LK24_8","072_24_8","LUK","24","8","8","'Bhɛɛ‑ 'bhɛ ‑jan mu 'ɛ ‑dwa ‑o 'kpee 'tɛ. ");
INSERT INTO moa_vpl VALUES ("LK24_9","072_24_9","LUK","24","9","9","‑Ayile, 'ke ‑o gole‑ bu 'ɛ ta, 'bhɛɛ‑ 'ke ‑o gele‑ 'bhɛ ‑za 'ɛ 'yigɔɔnlɛ Zesu a ‑klaŋlanɛ ‑vin vu ta do 'ɛ 'pegee mɛɛ ‑vin mu 'ɛ ni. ");
INSERT INTO moa_vpl VALUES ("LK24_10","072_24_10","LUK","24","10","10","Le mu 'la ‑ja Zesu bu 'ɛ ta, 'mu 'tɔ ‑le ‑gɛ: Magidala Mari 'pegee Zaani, 'bhɛɛ‑ Zaki nɛɛ Mari. Le ‑vin mu 'la 'yaa‑ ye, 'mu 'yee‑ ‑jan do 'kpɔ 'ɛ 'yela‑ ‑yigɔɔnna Zesu a *winbɔwo mu 'ɛ ni. ");
INSERT INTO moa_vpl VALUES ("LK24_11","072_24_11","LUK","24","11","11","'Duŋ‑ Zesu a 'winbɔwo mu 'ɛ waa ‑o 'kpalɛ‑ 'woo‑ le mu 'ɛ 'wojan‑ mu 'ɛ 'yi; 'bhɛ mu ‑yaa ‑o ‑yrɛ 'yi 'bhii‑ gbiŋ dɛza. ");
INSERT INTO moa_vpl VALUES ("LK24_12","072_24_12","LUK","24","12","12","'Bhɛɛ‑ 'duŋ‑, Piɛri 'e 'wlɛnle‑, 'kee‑ gele‑ blaale‑ Zesu bu 'ɛ ta. ‑E bhɔle 'bhɛ ta, 'ke ‑ya makulale, 'bhɛɛ‑ 'kee‑ bu ‑gluu 'ɛ 'yiglinle. Yaa pɛ 'kedo‑ 'kpɔ 'yelɛ‑ 'bhɛ 'yi, 'ke yaa 'e go gbaa ma sɔ 'pu 'ɛ ba. ‑Ayile, ‑a ‑liibhaa' gbɛ ‑yɔɔ 'ɛ 'kɔɔ ‑a ma, 'kee‑ niinale ‑a ‑zanta'. ");
INSERT INTO moa_vpl VALUES ("LK24_13","072_24_13","LUK","24","13","13","'Bhɛ yi do 'kpɔ 'ɛ 'le, Zesu a ‑klaŋlanɛ plɛ ‑yaa ge 'zi ‑wa do ta, ‑o ‑yaa 'bhɛ ‑wa 'ɛ sii Emausi. 'Bhɛ ‑wa 'ɛ 'pleŋgole ‑yaa Zeruzalɛmu ma kilo vu ta do. ");
INSERT INTO moa_vpl VALUES ("LK24_14","072_24_14","LUK","24","14","14","‑Za mu 'la 'kpɛn ꞊kla Zeruzalɛmu ‑wa 'ɛ ta, ‑o mɛɛ plɛ ‑yaa ‑balo klɛ 'zi 'mu ‑la ta. ");
INSERT INTO moa_vpl VALUES ("LK24_15","072_24_15","LUK","24","15","15","‑O ‑yaa 'bhɛ ‑balo 'ɛ ta 'waati 'la ba, 'ke Zesu 'gbu 'e 'mabɛɛnle ‑o ‑din, 'bhɛɛ‑ 'ke ‑o gele‑ 'eke‑ zi 'taa 'ɛ ta. ");
INSERT INTO moa_vpl VALUES ("LK24_16","072_24_16","LUK","24","16","16","‑O ‑yrɛ ‑yaa ‑a ma, 'duŋ‑ ‑e ‑yaa 'bhii‑ ‑gblo 'kpale‑ ‑yaa ‑o ‑yrɛ ta, 'bhɛɛ‑ waa ‑yaa sɔ ‑a madɔle. ");
INSERT INTO moa_vpl VALUES ("LK24_17","072_24_17","LUK","24","17","17","Zesu ‑o ‑lrɔkpale dɔɔ: «'Ka ‑yaa ‑mɛ ‑balo ‑la klɛ 'zi 'ka 'nu bhla 'ɛ zi ɛɛ?» 'Bhɛ klɛle 'tɛ, 'ke ‑o dulale ‑o wlɛyisriwole 'ɛ 'le. ");
INSERT INTO moa_vpl VALUES ("LK24_18","072_24_18","LUK","24","18","18","'Bhɛɛ‑ ‑o ‑yaa ‑o do 'la sii Kleopasi, 'bhɛ Zesu 'lrɔkpaa‑ dɔɔ: «'Bhi do ‑kplɛn 'kpɔ ‑le 'yee‑ Zeruzalɛmu ‑wa 'lɛɛ‑ ta 'kee‑ ‑zadɔle laa ‑o ‑za mu 'la ꞊kla ‑yrekpaa' plɛ 'lɛɛ‑ ta 'mu 'yi ɛɛ?» ");
INSERT INTO moa_vpl VALUES ("LK24_19","072_24_19","LUK","24","19","19","Zesu pe dɔɔ: «‑Za mu 'ɛ ‑de ɛɛ?» 'Bhɛ klɛle 'tɛ, 'ke ‑o mɛɛ plɛ 'a 'pele‑ 'sanle Zesu ni dɔɔ: «‑Za 'la 'bhɛ ꞊kla Nazarɛti mi Zesu 'ɛ ni bhe! ‑E ‑yaa 'duŋ‑ ‑Waanbhaa' ‑lɛla' janwo mi ‑glɔɔ do 'le. ‑E ‑yaa 'eglɔɔle ‑a klɛza mu 'pegee ‑a wojan mu 'ɛ ma ‑Waanbhaa' 'pegee Izraɛli 'si mu 'ɛ 'kpɛn 'yrɛ ma. ");
INSERT INTO moa_vpl VALUES ("LK24_20","072_24_20","LUK","24","20","20","‑Kɔɔa' 'sraka 'lɛna ‑kuŋlii mu 'ɛ 'pegee ‑kɔɔ' 'lɛɛ mu 'ɛ ‑wa ‑kpaa *Romɛ mu a mɛɛ gblaan mu 'ɛ 'kɔɔ, 'kaa 'mu 'a dɛ. ‑Ayile 'mu 'a ‑gbaanna ‑yrigbɛɛle 'ɛ ta. ");
INSERT INTO moa_vpl VALUES ("LK24_21","072_24_21","LUK","24","21","21","'O mɔɔ 'kpee ma, 'yele‑ ‑yaa nu klɛlɛ Izraɛli 'klɛɛn 'yi mu 'ɛ ‑o ‑Bhee mi 'le. 'Duŋ‑ ‑e ‑gaa 'bhɛ ‑yrekpaa' yaga mi ‑le ‑zɔn. ");
INSERT INTO moa_vpl VALUES ("LK24_22","072_24_22","LUK","24","22","22","'Bhɛɛ‑ 'waa‑ le mu 'ɛ 'ke mu 'o 'kpeelɛnia. ‑O ‑wlɛnna ‑zɔn zrwanzi 'tutu 'ɛ zi, 'bhɛɛ‑ ‑o ‑ja Zesu bu 'ɛ ta. ");
INSERT INTO moa_vpl VALUES ("LK24_23","072_24_23","LUK","24","23","23","'Duŋ‑ waa ‑a gbaa 'ɛ 'yelɛ‑ ‑a bu 'ɛ 'yi. 'Bhɛɛ‑ ‑wa ꞊pia 'o ni dɔɔ ‑mlɛkɛ' 'ke mu ‑pwɛla ‑o ba, 'bhɛɛ‑ 'mu pe ‑o ni dɔɔ ‑e ‑bwela gale ba, 'bhɛɛ‑ ‑ya ‑yrɛ ma. ");
INSERT INTO moa_vpl VALUES ("LK24_24","072_24_24","LUK","24","24","24","'Bhɛ blaan, 'waa‑ 'gwlaan‑ mu 'ɛ 'ke mu ‑ja ‑a bu 'ɛ ta. 'Bhɛɛ‑ le mu 'ɛ 'mu ‑za mu 'la 'yigɔɔnna ‑o ni, 'woo‑ 'gwlaan‑ mu 'ɛ ‑o 'bhɛɛ‑ ‑za mu do 'kpɔ 'ɛ ꞊ya, 'duŋ‑ waa 'yee‑ Zesu 'gbu 'yelɛ‑.» ");
INSERT INTO moa_vpl VALUES ("LK24_25","072_24_25","LUK","24","25","25","'Bhɛ klɛle 'tɛ, 'ke Zesu 'a 'pele ‑o ni dɔɔ: «'Ee! Mɛɛ 'kpeelɛkle mu, 'ka nu 'ka 'kpalɛ‑ ‑Waanbhaa' ‑lɛla' janwo mu 'ɛ 'mu ‑jan mu 'la ꞊woa ‑Waanbhaa' a 'Sɛwɛ 'ɛ 'yi 'mu 'yi 'waati 'ɛ ‑de ‑la ba ɛɛ? ");
INSERT INTO moa_vpl VALUES ("LK24_26","072_24_26","LUK","24","26","26","‑A ‑lɛdulale laa ‑yaa dɔɔ Mɛɛ ‑Bhee Mi ‑kpɔsɔɔ Krisi yaa ‑yaa nu 'bhɛɛ‑ ‑yrɛn 'ɛ 'bhlelɛ‑ 'elwale 'pe, 'bhɛɛ‑ ‑e sɔ gele‑ 'tɛ ‑Waanbhaa' a 'tɔbhɔleya 'ɛ 'yi ɛɛ?» ");
INSERT INTO moa_vpl VALUES ("LK24_27","072_24_27","LUK","24","27","27","'Bhɛ blaan, 'ke ‑ya san Moizi 'sɛwɛ mu 'la yɔɔndia‑ ‑Waanbhaa' a 'Sɛwɛ 'ɛ 'yi 'mu ma, 'bhɛɛ‑ 'kee‑ nu 'tɛnlɛ‑ ‑Waanbhaa' a ‑lɛla' janwo mu 'ɛ 'kpɛn ‑jan mu 'la yɔɔndia‑ 'mu a 'sɛwɛ mu 'ɛ 'yi 'mu ma, 'bhɛɛ‑ 'woo‑ mɛɛ mu 'la bhe ‑o 'kpɛn ‑jan mu 'la ꞊woa 'yee‑ 'gbu ba zayi', ‑e 'mu 'kpɛn 'yipia꞊ ‑o ni. ");
INSERT INTO moa_vpl VALUES ("LK24_28","072_24_28","LUK","24","28","28","‑O bhɔle Emausi ‑wa 'ɛ ‑din, Zesu 'a ꞊kla 'bhii‑ ‑e 'kanle 'bhɛ ‑wa 'ɛ ta. ");
INSERT INTO moa_vpl VALUES ("LK24_29","072_24_29","LUK","24","29","29","'Duŋ‑ ‑yaa' ‑klaŋlanɛ plɛ 'ɛ 'mu 'a 'yikwlanna gele ma, 'bhɛɛ 'mu pe ‑a ni dɔɔ: «Bo 'o ‑din ‑gɛ, yromazi ꞊bhwa gban, 'bhɛɛ‑ ‑fitrii' 'kpale‑ ‑saan gban 'ezin‑.» 'Bhɛ klɛle 'tɛ, 'kee‑ gele‑ ‑o zi ‑wa 'ɛ 'kpee. ");
INSERT INTO moa_vpl VALUES ("LK24_30","072_24_30","LUK","24","30","30","Pɛbhle 'waati 'ɛ ba, 'ke ‑o yaale' ‑tabali 'ɛ zi. 'Bhɛɛ‑ Zesu 'bluu 'ɛ 'sile‑, 'kee‑ ‑Waanbhaa' 'pubɔle 'bhɛ ma. 'Bhɛ blaan, 'ke ‑ya takanle, 'bhɛɛ‑ 'kee‑ ‑waa pɛ nale‑. ");
INSERT INTO moa_vpl VALUES ("LK24_31","072_24_31","LUK","24","31","31","'Bhɛ klɛle 'tɛ, 'ke ‑gblo gole‑ ‑o ‑yrɛ ta, 'bhɛɛ‑ 'ke ‑o Zesu madɔle. 'Bhɛ yrɛ do 'kpɔ 'ɛ ꞊nɔɔ bhe, 'kee‑ 'truŋwole ‑o ‑yrɛ ba. ");
INSERT INTO moa_vpl VALUES ("LK24_32","072_24_32","LUK","24","32","32","‑Ayile, 'ke ‑wa pele‑ 'eke‑ ni dɔɔ: «‑Kɔɔ' 'yaa‑ ‑balo klɛ 'zi 'a ‑le zi 'ɛ 'lii, 'bhɛɛ‑ ‑e ‑yaa ‑Waanbhaa' a ‑jan mu 'ɛ 'yipe zii' 'o ni 'waati 'la ba, 'o zrukpaale ‑yaa 'egbɛnɛle 'dɛ!» ");
INSERT INTO moa_vpl VALUES ("LK24_33","072_24_33","LUK","24","33","33","'Bhɛ klɛle 'tɛ, 'ke ‑woo ‑wlɛnle' blaale‑, 'bhɛɛ‑ 'ke ‑o niinale ‑o ‑zanta' Zeruzalɛmu. 'Bhɛɛ‑ 'ke ‑o gele‑ 'tɛnlɛ‑ Zesu a ‑klaŋlanɛ ‑vin vu ta do 'ɛ 'pegee 'bhɛ mu 'madɔwo mu 'ɛ ma. ");
INSERT INTO moa_vpl VALUES ("LK24_34","072_24_34","LUK","24","34","34","'Bhɛ mu ‑yaa pe 'zi dɔɔ: «Mɛɛzan ‑bwela gale ba kpataakpa, 'bhɛɛ‑ Simɔ 'gbu 'a ꞊ya!» ");
INSERT INTO moa_vpl VALUES ("LK24_35","072_24_35","LUK","24","35","35","‑Ayile, 'woo Zesu a ‑klaŋlanɛ plɛ 'la ‑daa Emausi ‑wa 'ɛ ta, ‑o ‑waa pɛ ‑za 'ɛ 'yigɔɔnna. Zesu 'pwɛla‑ ‑o ba gɔnɛ‑ 'la gbɛɛn‑ ‑o ge bhla 'ɛ zi Emausi, 'bhɛɛ‑ ‑wa madwa‑ gɔnɛ‑ 'la gbɛɛn‑ 'yee‑ Zesu 'yaa‑ 'bluu takan' zii' ‑o ‑le bhla 'la ba, ‑o 'bhɛ 'kpɛn 'yigɔɔnna 'bhɛ mu ni. ");
INSERT INTO moa_vpl VALUES ("LK24_36","072_24_36","LUK","24","36","36","‑O ꞊bwa 'bhɛ ‑za 'ɛ 'yigɔɔnle ma bhe, 'ke Zesu 'pwɛle ‑o 'kpɛn 'pleŋ‑, 'bhɛɛ‑ 'ke ‑ya pele‑ ‑o ni dɔɔ: «Bhaa ‑Waanbhaa' a yilabla klɛ 'ka ba!» ");
INSERT INTO moa_vpl VALUES ("LK24_37","072_24_37","LUK","24","37","37","'Duŋ‑ ‑e ‑kla bi ‑o ni 'bhii‑ jiɛlii do ‑le ‑pwɛla ‑o ba, ‑ayile ‑gblaan ‑gbɛnɛ do ꞊klaa ‑o 'kpɛn 'yi. ");
INSERT INTO moa_vpl VALUES ("LK24_38","072_24_38","LUK","24","38","38","'Bhɛ klɛle 'tɛ, 'ke 'yee‑ Zesu 'gbu 'a 'pele ‑o ni dɔɔ: «‑Mɛle ꞊kla 'bhɛɛ‑ 'ka zru ba 'tɛ ‑o ɛɛ? 'Bhɛɛ‑ ‑mɛla ma 'bhɛɛ‑ 'ka ‑o 'ka zru mu 'ɛ klɛ 'zi plɛ ɛɛ? ");
INSERT INTO moa_vpl VALUES ("LK24_39","072_24_39","LUK","24","39","39","‑Ka 'ŋ 'kɔɔlaalii mu 'ɛ 'pegee 'ŋ gaan mu 'ɛ ‑glin doo, 'mi 'gbu ‑le ‑gɛ kpataakpa. ‑Ka 'kun 'ŋ ma, 'bhɛɛ‑ ‑ka 'ŋ ‑glin doo. So 'pegee bhɛlɛ' 'laa ‑o mɛɛ jiɛlii ma, 'bhii‑ 'ka 'yrɛ ‑o ‑a ma 'mi ma gɔnɛ‑ 'la gbɛɛn‑ ‑gɛ.» ");
INSERT INTO moa_vpl VALUES ("LK24_40","072_24_40","LUK","24","40","40","‑E 'bhɛ 'pelawoa 'bhɛ gbɛɛn‑ bhe, 'pɔnli blaan mu 'la 'yaa‑ ‑a 'kɔɔlaalii, 'bhɛ 'pegee ‑a gaan ‑laa mu 'ɛ ma, ‑e 'mu ‑zrɔnna ‑o ni. ");
INSERT INTO moa_vpl VALUES ("LK24_41","072_24_41","LUK","24","41","41","‑O zrukpaa' gbɛ 'pegee ‑o ‑liibhaa' gbɛya ‑yɔɔ 'ɛ 'kɔɔ, waa ‑yaa 'sɔle ‑o 'kpale ‑a ‑yi. 'Bhɛla‑ ‑zɛɛle 'ke ‑yoo ‑lrɔkpale dɔɔ: «Pɛle sa ‑o 'ka 'kɔɔ ‑gɛ ɛɛ?» ");
INSERT INTO moa_vpl VALUES ("LK24_42","072_24_42","LUK","24","42","42","'Bhɛ klɛle 'tɛ, 'ke ‑o kaa ‑yaale' ‑lɛkpu' do nale‑ ‑a ni. ");
INSERT INTO moa_vpl VALUES ("LK24_43","072_24_43","LUK","24","43","43","‑E 'bhɛ 'sile‑, 'kee‑ 'bhɛ 'bhlele ‑o 'kpɛn 'yrɛ ma. ");
INSERT INTO moa_vpl VALUES ("LK24_44","072_24_44","LUK","24","44","44","'Bhɛ blaan, 'ke ‑ya pele‑ ‑o ni dɔɔ: «'Ŋ ‑jan mu 'la ꞊woa 'ka ni 'ŋ 'yaa‑ 'ka ‑din 'waati 'la ba, 'bhɛ mu laa ‑o ‑li 'ka 'kpee ɛɛ? 'An ꞊pia 'ka ni dɔɔ: ‑A ‑lɛdulale ‑o ‑za mu 'la 'kpɛn yɔɔndɛle ‑o 'mi ba zayi' Moizi a 'toŋ 'sɛwɛ 'ɛ 'yi 'bhɛ 'pegee ‑Waanbhaa' ‑lɛla' janwo mu 'ɛ 'mu ‑jan mu 'la yɔɔndia‑ ‑waa' 'sɛwɛ mu 'ɛ 'yi 'mi ba zayi', 'bhɛɛ‑ ‑o 'kɛ mu 'la yɔɔndia‑ 'Srokpa 'sɛwɛ 'ɛ 'yi, 'bhɛ ‑jan mu 'ɛ 'kpɛn 'yizakla wlan 'le kpataakpa.» ");
INSERT INTO moa_vpl VALUES ("LK24_45","072_24_45","LUK","24","45","45","'Bhɛ 'yi 'tɛ, 'kee‑ yikan' 'nale ‑o ni, 'kooko‑ ‑o sɔ ‑Waanbhaa' a ‑jan mu 'ɛ 'yimale kplankplan. ");
INSERT INTO moa_vpl VALUES ("LK24_46","072_24_46","LUK","24","46","46","'Bhɛ blaan, 'ke ‑ya pele‑ ‑o ni dɔɔ: «‑Wa yɔɔndia‑ 'elwale gban ‑sɔ ‑Waanbhaa' a 'Sɛwɛ 'ɛ 'yi dɔɔ: ‹‑A ‑lɛdulale ‑o dɔɔ Mɛɛ ‑Bhee Mi ‑Kpɔsɔɔ Krisi nu ‑yrɛnbhlelɛ 'elwale 'pe, 'bhɛɛ‑ 'bhɛ blaan ‑e nu bwelɛ gale ba ‑a gale blaan ‑yrekpaa' yaga mi ma.› ");
INSERT INTO moa_vpl VALUES ("LK24_47","072_24_47","LUK","24","47","47","'Bhɛɛ‑ 'ezin‑, 'kee‑ san Zeruzalɛmu ma, 'bhɛɛ‑ ‑e ge 'tɛnlɛ‑ 'drunyan 'ɛ 'yi mɛɛ mu 'ɛ 'kpɛn ma, ‑o nu ‑Jan 'Nrale‑ 'ɛ 'wolɛ‑ ‑o 'kpɛn ni ‑a 'tɔ 'ɛ 'yi; 'kooko‑ ‑o ploo waa ‑za 'yɔɔ‑ mu 'ɛ ma, 'bhɛɛ‑ ‑Waanbhaa' ‑waa' ‑za 'yɔɔ‑ mu 'ɛ ‑sroma yan. ");
INSERT INTO moa_vpl VALUES ("LK24_48","072_24_48","LUK","24","48","48","'Ka mu 'gbu ‑le 'mi 'srɛ 'le ‑za mu 'ɛ 'kpɛn 'yi. ");
INSERT INTO moa_vpl VALUES ("LK24_49","072_24_49","LUK","24","49","49","'Ŋ Dɛ 'bhɛ 'liiwli‑ ‑naa ‑a *Lii 'Weŋ 'la 'naza‑ ta 'ka ni, 'mi 'gbu nu 'bhɛ 'kpalɛ‑ 'ka ni. 'Duŋ‑ ‑ka bo ‑sɔ Zeruzalɛmu 'sani‑ 'ke 'bhɛ ‑glɔɔya' 'ɛ zinaa' 'ka ta 'kee‑ da laanima.» ");
INSERT INTO moa_vpl VALUES ("LK24_50","072_24_50","LUK","24","50","50","'Bhɛ blaan, 'ke Zesu 'pegee ‑yaa' ‑klaŋlanɛ mu 'ɛ ‑o gole‑ Zeruzalɛmu ‑wa 'ɛ 'kpee, 'bhɛɛ‑ 'ke ‑o gele‑ Betani ‑wa 'ɛ ba ‑yrɛ ta. ‑O bhɔlawoa 'bhɛ ꞊nɔɔ bhe, 'ke ‑ya gbɛ mu 'ɛ 'wlɛnle, 'bhɛɛ‑ 'ke ‑yoo 'dumawole. ");
INSERT INTO moa_vpl VALUES ("LK24_51","072_24_51","LUK","24","51","51","‑E ‑yaa ‑o 'dumawo zii' 'waati 'la ba, 'ke ‑Waanbhaa' 'a 'sile 'ke 'bhɛ gele‑ 'kɛle‑ laflɛ' 'yi. ");
INSERT INTO moa_vpl VALUES ("LK24_52","072_24_52","LUK","24","52","52","'Bhɛ blaan, ‑yaa' ‑klaŋlanɛ mu 'ɛ 'yanle‑ ‑a gbalele, 'ke 'mu niinale 'mu ‑zanta' Zeruzalɛmu, 'mu zrukpaa' ‑gbɛnɛ 'ɛ ta. ");
INSERT INTO moa_vpl VALUES ("LK24_53","072_24_53","LUK","24","53","53","Yi 'oo yi, ‑o ‑yaa kla 'eke‑ ba ‑Waanbhaa' Gba 'Fɛ ‑Gbɛnɛ 'ɛ ꞊la, 'bhɛɛ‑ ‑o ‑yaa ‑Waanbhaa' gba.");
INSERT INTO moa_vpl VALUES ("JN1_1","073_1_1","JHN","1","1","1","'Elwale ‑sɔ, 'sani‑ 'drunyan klɛle pleŋ‑ ‑Waanbhaa' 'kɔɔ, ‑liijan' ‑yaa' gban; 'bhɛɛ‑ ‑liijan' 'pegee ‑Waanbhaa' ‑yaa 'eke‑ zi, 'bhɛɛ‑ ‑liijan' 'ɛ 'yaa‑ 'ke ‑Waanbhaa' 'le. ");
INSERT INTO moa_vpl VALUES ("JN1_2","073_1_2","JHN","1","2","2","'Sani‑ 'drunyan klɛle pleŋ‑ ‑Waanbhaa' 'kɔɔ, 'yee‑ 'pegee ‑Waanbhaa ‑yaa 'eke‑ zi. ");
INSERT INTO moa_vpl VALUES ("JN1_3","073_1_3","JHN","1","3","3","‑Waanbhaa' pɛ 'kpɛn ꞊kla 'yela‑ ‑le. 'Bhɛɛ‑ 'yee‑ ‑Waanbhaa' laa 'trɛ ta pɛ 'tɔle‑ 'trɛ ta pɛ 'bhɛ klɛlɛ 'yee‑ blaan. ");
INSERT INTO moa_vpl VALUES ("JN1_4","073_1_4","JHN","1","4","4","Bole ‑yrɛ ma ‑si 'ɛ ꞊daa 'yela‑ ‑yi, 'bhɛɛ‑ 'bhɛ ‑si 'ɛ ꞊kla 'ke bhaaplɛŋ mu ta 'tɛbhile 'le. ");
INSERT INTO moa_vpl VALUES ("JN1_5","073_1_5","JHN","1","5","5","'Bhɛ 'tɛbhile 'ɛ ꞊bhia ‑gblo 'ɛ 'yi, 'duŋ‑ 'bhɛɛ‑ ‑gblo 'ɛ yaa 'sɔlɛ‑ 'kpale ‑a ta. ");
INSERT INTO moa_vpl VALUES ("JN1_6","073_1_6","JHN","1","6","6","'Waati do ba, ‑Waanbhaa' mɛɛ do winbwa‑, ‑o ‑yaa 'bhɛ mɛɛ 'ɛ sii Zaan. ");
INSERT INTO moa_vpl VALUES ("JN1_7","073_1_7","JHN","1","7","7","'Bhɛ ꞊nwa klɛlɛ 'yee‑ 'tɛbhile 'ɛ 'srɛ 'le. 'Bhɛ ꞊nwa ‑janwolɛ 'yee‑ 'tɛbhile 'ɛ ba zayi', 'kooko‑ mɔkpɛn' 'e kpa ‑a ‑yi. ");
INSERT INTO moa_vpl VALUES ("JN1_8","073_1_8","JHN","1","8","8","'Yee‑ Zaan 'gbu 'laa ‑yaa 'bhɛ 'tɛbhile 'ɛ 'le. 'Duŋ‑ yaa pɛ nu win 'ɛ ꞊kla 'ke ‑a 'srɛya‑ klɛle ‑la ‑le, ‑ayile ‑e ‑janwoa ‑a ba zayi'. ");
INSERT INTO moa_vpl VALUES ("JN1_9","073_1_9","JHN","1","9","9","'Yee‑ 'tɛbhile 'ɛ 'yele‑ ‑yaa 'ke 'tɛbhile kplankplan 'gbu 'ɛ 'le, ‑e ꞊nwa 'drunyan 'ɛ 'yi, 'bhɛɛ‑ ‑e mɔkpɛn' takan 'weŋ. ");
INSERT INTO moa_vpl VALUES ("JN1_10","073_1_10","JHN","1","10","10","Wlan 'ɛ ni, 'yee‑ ‑liijan' 'ɛ 'yaa‑ 'drunyan 'yi 'elwale gban ‑sɔ. 'Bhɛɛ‑ ‑Waanbhaa' 'drunyan 'ɛ ꞊kla 'yela‑ 'le, 'bhɛɛ‑ 'duŋ‑, 'drunyan ta bhaaplɛŋ mu 'ɛ waa ‑a dɔlɛ. ");
INSERT INTO moa_vpl VALUES ("JN1_11","073_1_11","JHN","1","11","11","‑E ‑nwa ‑a 'gbu ba 'klɛɛn 'ɛ 'yi, 'bhɛɛ‑ ‑yaa' 'klɛɛn 'yi mu 'ɛ waa ‑a 'kunlɛ‑ 'elrele. ");
INSERT INTO moa_vpl VALUES ("JN1_12","073_1_12","JHN","1","12","12","'Duŋ‑ mɛɛ 'la zan mu ‑dwa ‑a ‑la, 'bhɛɛ‑ ‑woo ‑kpaa ‑a ‑yi, ‑e 'bhɛ 'seŋ 'naa‑ 'bhɛ zan mu 'ɛ ni 'ke ‑o klɛ 'ke ‑Waanbhaa' ‑nɛ mu 'le. ");
INSERT INTO moa_vpl VALUES ("JN1_13","073_1_13","JHN","1","13","13","Waa klɛlɛ ‑Waanbhaa' ‑nɛ 'mu 'le, 'bhii‑ bhaaplɛŋ mu a pɛ yagbɛya 'ɛ gbɛɛn‑. 'Duŋ‑ ‑Waanbhaa' 'gbu ‑le ‑dwa ‑a ‑la 'ke ‑o klɛ 'bhɛ 'nɛ mu 'le. ");
INSERT INTO moa_vpl VALUES ("JN1_14","073_1_14","JHN","1","14","14","'Bhɛ ya 'ɛ 'yi, 'yee‑ ‑liijan' 'ɛ ꞊kla 'ke bhaaplɛŋ do 'le, 'bhɛɛ‑ ‑e ꞊nwa ‑kɔɔ' 'pleŋ‑ ‑gɛ. 'O ‑yaa' 'tɔbhɔleya 'ɛ ꞊ya. ‑A 'tɔbhɔleya 'ɛ 'yaa‑ 'bhii‑ ‑Nɛ bhɛ do 'kpɔ 'la 'ke 'bhɛ 'tɔbhɔleya ‑srɔɔwoa 'bhɛ Dɛ 'kɔɔ 'bhɛɛ‑ gbɛɛn‑. ‑A zru 'ɛ 'pale‑ ‑yaa 'ke 'sɔniya ‑zeze 'pegee wlan 'le. ");
INSERT INTO moa_vpl VALUES ("JN1_15","073_1_15","JHN","1","15","15","Mɛɛ Wiiŋfɛ' Mi Zaan 'yela‑ 'srɛya‑ ꞊kla, 'bhɛɛ‑ ‑ya ‑pia mɛɛ mu 'ɛ ni 'eglɔɔle dɔɔ: «'Ŋ 'yaa‑ ‑janwo' zii' 'yela‑ ba zayi' 'ke 'an pe dɔɔ: ‹‑Yoo zan nulɛ 'ŋ ‑zanta', 'duŋ‑ ‑a gblaan ‑yiya' 'mi ni, ‑amasrɔyi ‑e ‑yaa 'mi 'lɛɛ 'elwale ‑sɔ.›» ");
INSERT INTO moa_vpl VALUES ("JN1_16","073_1_16","JHN","1","16","16","‑E ‑lia 'kɔɔ ma 'kee‑ kan ‑a ‑daŋ' ta, 'bhɛɛ‑ ‑e ge ‑lilele ‑kɔɔ' ma 'taŋii. ");
INSERT INTO moa_vpl VALUES ("JN1_17","073_1_17","JHN","1","17","17","‑Amasrɔyi, ‑Waanbhaa' ‑kaan *Moizi ‑la ba, 'bhɛɛ‑ ‑e ‑yaa' 'toŋ mu 'ɛ ꞊naa ‑kɔɔ' ni. 'Duŋ‑ ‑e ‑lia ‑kɔɔ' ma, 'bhɛ 'pegee ‑ya 'gbu ma wlan 'ɛ 'bhɛ ‑zrɔnna ‑kɔɔ' ni Zesu Krisi ‑la 'srɔyi. ");
INSERT INTO moa_vpl VALUES ("JN1_18","073_1_18","JHN","1","18","18","Mɛɛ 'kedo‑ do 'kpɔ 'laa ‑Waanbhaa' yelɛ ‑lido; 'ke yaa 'e go ‑a Gbe bhɛ do 'kpɔ 'ɛ ba. 'Bhɛ ‑le 'ke ‑Waanbhaa' 'le, 'bhɛɛ‑ 'bhɛ 'pegee 'bhɛ Dɛ ‑Waanbhaa' 'kpale‑ ‑o do ma. 'Bhɛɛ‑ 'bhɛ ‑le ‑Waanbhaa' ‑zrɔnna mɛɛ mu ni. ");
INSERT INTO moa_vpl VALUES ("JN1_19","073_1_19","JHN","1","19","19","Zeruzalɛmu Zuufu mu 'ɛ ‑o 'sraka 'lɛna mu 'ke mu 'pegee ‑Waanbhaa' Gba 'Fɛ ‑Gbɛnɛ 'ɛ la yewonɛ mu 'ke mu winbwa‑ Mɛɛ Wiiŋfɛ' Mi Zaan ba. 'Bhɛɛ‑ 'mu ‑ja Zaan ta 'ke ‑wa ‑lrɔkpale dɔɔ: «Mɛɛ 'ɛ ‑dele 'bhi 'le ɛɛ?» ");
INSERT INTO moa_vpl VALUES ("JN1_20","073_1_20","JHN","1","20","20","Zaan 'laa ‑baŋgolɛ 'bhɛ ‑jan 'ɛ zikpale ma ‑o ni, 'duŋ‑ ‑ya ꞊pia ‑o ni kpataakpa dɔɔ: «'Mi 'laa ‑o 'ke Mɛɛ ‑Bhee Mi ‑Kpɔsɔɔ Krisi 'ɛ 'le.» ");
INSERT INTO moa_vpl VALUES ("JN1_21","073_1_21","JHN","1","21","21","'Bhɛɛ‑ ‑wa ‑lrɔkpaa 'ezin‑ dɔɔ: «'Bhɛɛ‑ mɛɛ 'ɛ ‑de 'gbu ‑le 'bhi 'le ɛɛ? 'Bhi ‑le 'ke *Eli 'le ɛɛ?» Zaan 'bhɛ zikpaa‑ ‑o ni dɔɔ: «'Ɔn ɔn, 'mi 'laa ‑o 'ke Eli 'le.» 'Bhɛɛ‑ ‑wa ‑lrɔkpaa 'ezin‑ dɔɔ: «'Bhi ‑le 'ke ‑Waanbhaa' *‑lɛla' janwo mi 'ɛ 'le ɛɛ?» 'Bhɛɛ‑ Zaan pe ‑o ni 'ezin‑ dɔɔ: «'Yooye‑.» ");
INSERT INTO moa_vpl VALUES ("JN1_22","073_1_22","JHN","1","22","22","'Bhɛla‑ ‑yile, 'ke ‑wa ‑lrɔkpale 'tɛ dɔɔ: «'Bhɛɛ‑ ‑de 'gbu ‑le 'bhi 'le ɛɛ? 'Yoo‑ 'ke mɛɛ ‑glɔɔn 'la 'le 'bhɛ 'pe 'o ni, 'bhɛɛ‑ 'o sɔ 'bhɛ 'pele 'o 'winbɔ‑ mu 'ɛ ni. 'Bhi 'gbu 'a pe 'e 'gbu ma 'nale‑ ɛɛ?» ");
INSERT INTO moa_vpl VALUES ("JN1_23","073_1_23","JHN","1","23","23","'Bhɛ klɛle 'tɛ, 'ke Zaan 'bhɛ zikpale ‑o ni ‑Waanbhaa' ‑lɛla' janwo mi *Ezai a ‑jan do 'le. 'Bhɛ 'a ꞊pia dɔɔ: «Mɛɛ do ‑o ‑toorodɔ 'zi ‑kpe 'ɛ ta 'ke ‑ya pe dɔɔ: ‹‑Ka zibhɛ 'ɛ 'lɛmagaan, 'bhɛɛ‑ ‑kaa 'lɛdɔɔ‑ Mɛɛzan ni›. Zaan pe ‑o ni dɔɔ: ‹'Mi ‑le 'bhɛ ‑toorodɔ mi 'ɛ 'le.›» ");
INSERT INTO moa_vpl VALUES ("JN1_24","073_1_24","JHN","1","24","24","‑O mɛɛ 'la zan mu 'winbwa‑ Zaan ta, 'mu 'ke mu ‑yaa Farizi mu 'le. ");
INSERT INTO moa_vpl VALUES ("JN1_25","073_1_25","JHN","1","25","25","'Bhɛɛ‑ 'bhɛ mu 'yee‑ Zaan 'lrɔkpaa‑ 'ezin‑ dɔɔ: «'Ke 'yaa‑ ‑o 'ke Mɛɛ ‑Bhee Mi ‑Kpɔsɔɔ Krisi 'le, 'bhɛ 'pegee 'ke 'yaa ‑o 'ke Eli 'le, 'bhɛɛ‑ 'ke 'yaa ‑o 'ke ‑Waanbhaa' ‑lɛla' janwo mi 'ɛ 'le, ‑mɛle ‑kla 'yoo‑ mɛɛ mu wiiŋfɛ' zii' ‑yi ba ɛɛ?» ");
INSERT INTO moa_vpl VALUES ("JN1_26","073_1_26","JHN","1","26","26","'Bhɛ klɛle 'tɛ, 'ke Zaan 'a 'lɛkunle ‑o ni dɔɔ: «'Mi ‑o 'ka wiiŋfɛ' zii' 'ke ‑yi 'le, 'duŋ‑ mɛɛ do ‑o 'ka 'pleŋ‑, 'bhɛɛ‑ 'ka 'laa 'bhɛ zan 'ɛ dɔlɛ ‑li. ");
INSERT INTO moa_vpl VALUES ("JN1_27","073_1_27","JHN","1","27","27","'Bhɛ zan 'ɛ, 'bhɛ ‑le nu nulɛ 'mi ‑zanta', 'ali‑ 'bhɛ wlɛyi' laa ‑o 'mi wlɛyi' ta 'ke 'mi 'gbu ‑a gaan ma ‑sawla bhlɛ mu ploo 'bhii‑ lu mu a klɛ gɔnɛ‑ 'la gbɛɛn‑ bhe.» ");
INSERT INTO moa_vpl VALUES ("JN1_28","073_1_28","JHN","1","28","28","'Bhɛ ‑za mu 'ɛ 'kpɛn ꞊kla Betani ‑wa 'ɛ ta. 'Bhɛ ‑wa 'ɛ 'yaa‑ Zrudɛn yue 'yrɛ gbɛ do 'ɛ ta. Zaan 'yaa‑ mɛɛ mu 'ɛ wiiŋfɛ' zii' 'bhɛɛ‑ ꞊nɔɔ. ");
INSERT INTO moa_vpl VALUES ("JN1_29","073_1_29","JHN","1","29","29","'Bhɛ ‑za mu 'ɛ klɛle ta tooklin‑ yi 'ɛ 'le, 'ke Zaan Zesu 'yele 'ke 'bhɛ ‑o zan ‑a ta. ‑Ayile, 'ke ‑ya pele‑ dɔɔ: «‑Waanbhaa' ‑Bhlaa Gwlɛn Bhlonɛ‑ 'la nu klɛlɛ 'sraka 'le, 'bhɛɛ‑ ‑e bhaaplɛŋ mu 'ɛ ‑waa' ‑za 'yɔɔ‑ 'kwe go ‑o wiiŋ‑, 'yele‑ ‑gɛ! ");
INSERT INTO moa_vpl VALUES ("JN1_30","073_1_30","JHN","1","30","30","'Ŋ 'yela‑ ma ‑janwoa dɔɔ: ‹Mɛɛ do ‑o zan mi blaan, ‑a gblaan ‑yiya' 'mi ni; ‑amasrɔyi 'sani‑ ‑o 'mi ya, 'ke 'yee‑ ‑o.› ");
INSERT INTO moa_vpl VALUES ("JN1_31","073_1_31","JHN","1","31","31","‑E ‑yaa nu klɛlɛ mɛɛ 'la 'le, 'naa ‑yaa 'bhɛ dɔ. 'Duŋ‑ 'mi ꞊nwa ‑sɔ mɛɛ mu wiiŋfɛyrɛ nɔɔ‑ ‑yi 'le, 'kooko‑ Izraɛli mɛɛ mu 'ɛ ‑wa dɔ.» ");
INSERT INTO moa_vpl VALUES ("JN1_32","073_1_32","JHN","1","32","32","Zaan 'a 'srɛya‑ ꞊kla 'ezin‑ mɛɛ mu 'ɛ 'yrɛ ma dɔɔ: «'Ŋ *Lii 'Weŋ 'ɛ zinale ꞊ya ‑a ta 'kee‑ da 'zi laflɛ' 'ɛ ma 'bhii‑ ‑bhooladɔ maannɛ‑ do gbɛɛn‑, 'bhɛɛ‑ ‑a yaale ꞊bwa ‑a ta. ");
INSERT INTO moa_vpl VALUES ("JN1_33","073_1_33","JHN","1","33","33","‑E ‑yaa 'ke mɛɛ 'la 'le, 'mi 'gbu 'laa ‑yaa ‑a dɔ. 'Duŋ‑ ‑Waanbhaa' 'la 'ŋ 'winbwa‑ mɛɛ mu wiiŋfɛyrɛ nɔɔ‑ ‑yi 'le, 'bhɛ ‑la ꞊pia 'ŋ ni dɔɔ: ‹'Kee Lii 'Weŋ 'ɛ zinale ꞊ya mɛɛ 'la zan ta, 'bhɛɛ‑ 'ke ‑a yaale ꞊bwa 'bhɛ zan 'ɛ ta, ‑a 'yaango‑ dɔɔ 'bhii‑ 'bhɛ zan 'ɛ 'bhɛ ‑le nu mɛɛ mu wiiŋfɛlɛ 'ke Lii‑ 'Weŋ 'ɛ 'le.› ");
INSERT INTO moa_vpl VALUES ("JN1_34","073_1_34","JHN","1","34","34","'Mi 'bhɛ ‑za 'ɛ klɛyrɛ 'ɛ 'yelawoa, 'mi sɔ ‑a pele‑ kpataakpa dɔɔ 'yele‑ 'ke ‑Waanbhaa' Gbe ‑Kpɔsɔɔ 'gbu 'ɛ 'le.» ");
INSERT INTO moa_vpl VALUES ("JN1_35","073_1_35","JHN","1","35","35","'Bhɛ ta tooklin‑ yi 'le, Mɛɛ Wiiŋfɛ' Mi Zaan 'pegee 'bhɛ a ‑klaŋlanɛ plɛ ‑yaa 'yee‑ yrɛ 'ɛ ꞊nɔɔ‑ 'ezin‑. ");
INSERT INTO moa_vpl VALUES ("JN1_36","073_1_36","JHN","1","36","36","‑E Zesu 'yele‑ 'ke 'bhɛ ‑o 'kan zii', 'ke ‑ya pele‑ dɔɔ: «‑Waanbhaa' a ‑Bhlaa Gwlɛn Bhlonɛ‑ 'ɛ 'yele‑ ‑gɛ!» ");
INSERT INTO moa_vpl VALUES ("JN1_37","073_1_37","JHN","1","37","37","Zaan a ‑klaŋlanɛ plɛ 'trɔnbɔle 'bhɛ ‑jan 'ɛ 'yi, 'ke ‑o gele‑ Zesu zi. ");
INSERT INTO moa_vpl VALUES ("JN1_38","073_1_38","JHN","1","38","38","'Bhɛ klɛle 'tɛ, Zesu 'e 'yrɛkpale ‑a ‑zanta', 'bhɛɛ‑ ‑ya yele 'bhii‑ 'woo‑ Zaan a ‑klaŋlanɛ plɛ 'ɛ 'yaa‑ zan ‑a zi, 'ke ‑yoo ‑lrɔkpale dɔɔ: «'Ka ‑o ‑mɛla ‑glin 'zi ɛɛ?» ‑O pe Zesu ni dɔɔ: «Rabi ('bhɛ 'yi ‑le dɔɔ: ‹'O Daan mi›), 'e ba ‑o 'naa ɛɛ?» ");
INSERT INTO moa_vpl VALUES ("JN1_39","073_1_39","JHN","1","39","39","'Bhɛ klɛle 'tɛ, 'ke ‑ya ‑lɛkunle ‑o ni dɔɔ: «‑Ka nu 'bhɛɛ‑ 'kaa ye doo.» 'Bhɛ 'yi 'tɛ, 'ke ‑o gele‑ Zesu zi, 'ke ‑wa ‑yi yrɛ 'ɛ 'yele; 'bhɛɛ‑ 'ke ‑o bole‑ ‑a ‑din 'bhɛ ‑yrekpaa' do 'ɛ 'le. 'Bhɛ ꞊kla yromazi 'waati 'ɛ ba. ");
INSERT INTO moa_vpl VALUES ("JN1_40","073_1_40","JHN","1","40","40","Mɛɛ plɛ 'la ‑o Zaan 'wojan‑ 'ɛ ꞊maa, 'bhɛɛ‑ 'ke ‑o ‑ja dɔlɛ Zesu zi, ‑o ‑yaa ‑o do sii Andre, 'bhɛ 'yaa‑ Simɔ Piɛri 'nwagwlɛn‑ 'le. ");
INSERT INTO moa_vpl VALUES ("JN1_41","073_1_41","JHN","1","41","41","'Bhɛ 'yi 'tɛ, Andre ‑ja 'bhɛ 'naagwlɛn‑ Simɔ ta, 'bhɛɛ‑ 'ke ‑ya pele‑ 'bhɛ ni dɔɔ: «'O *Mesi 'ɛ ꞊ya!» 'Bhɛ 'yi ‑le dɔɔ: ‹Mɛɛ ‑Bhee Mi ‑Kpɔsɔɔ Krisi›. ");
INSERT INTO moa_vpl VALUES ("JN1_42","073_1_42","JHN","1","42","42","'Bhɛɛ‑ 'ke Andre gele‑ Simɔ 'le Zesu ba. ‑O bhɔle Zesu ‑din, 'bhɛɛ‑ 'bhɛ 'yrɛkpale 'yee‑ Simɔ ta frii, 'ke ‑ya pele‑ ‑a ni dɔɔ: «'Bhi Zaan gbe Simɔ, ‑o nu 'bhi 'siilɛ‑ boolazi ‑gɛ Kefasi, 'bhɛ 'yi ‑le dɔɔ: ‹Vlɛ›.» ");
INSERT INTO moa_vpl VALUES ("JN1_43","073_1_43","JHN","1","43","43","'Bhɛ ta tooklin‑ yi 'ɛ 'le, Zesu 'yaa‑ zi 'bhii‑ ‑e ge Galile 'klɛɛn 'ɛ 'yi. 'Bhɛ 'yi 'tɛ, ‑a ge bhla 'ɛ zi, 'ke ‑a ‑lɛpale Filipu 'le, 'bhɛɛ‑ 'ke ‑ya pele‑ 'bhɛ ni dɔɔ: «Nu dɔ 'ŋ zi!» ");
INSERT INTO moa_vpl VALUES ("JN1_44","073_1_44","JHN","1","44","44","Filipu ‑yaa da Piɛri 'pegee Andre mu da ‑wa 'ɛ 'bhɛɛ‑ ta, 'bhɛɛ‑ ‑o ‑yaa 'bhɛ ‑wa 'ɛ sii Bɛtisaida. ");
INSERT INTO moa_vpl VALUES ("JN1_45","073_1_45","JHN","1","45","45","'Bhɛ blaan, Filipu 'lɛpale Natanaɛli 'le, 'ke ‑ya pele‑ 'bhɛ ni dɔɔ: «*Moizi mɛɛ 'la zan a ‑janwoa ‑Waanbhaa' a *'Toŋ 'sɛwɛ 'ɛ 'yi, 'bhɛ 'pegee ‑Waanbhaa' *‑lɛla' janwo mu 'ɛ ‑o 'yee‑ mɛɛ 'la zan a ‑janwoa 'ezin‑ bhe, 'wa ꞊ya. ‑Wa sii Zesu, 'bhɛɛ‑ ‑wa dɛ sii Zozɛfu, ‑e da Nazarɛti ‑wa 'ɛ ta.» ");
INSERT INTO moa_vpl VALUES ("JN1_46","073_1_46","JHN","1","46","46","'Bhɛɛ‑, 'ke Natanaɛli 'a 'pele Filipu ni dɔɔ: «‑Za 'lrele‑ do sɔ dale‑ Nazarɛti ‑wa 'ɛ ta ɛɛ?» 'Bhɛ klɛle 'tɛ, 'ke Filipu 'a 'lɛkunle ‑a ni dɔɔ: «Nu 'bhɛɛ‑ 'ya ye doo.» ");
INSERT INTO moa_vpl VALUES ("JN1_47","073_1_47","JHN","1","47","47","‑Ayile, Zesu 'a 'yele‑ 'bhii‑ Natanaɛli ‑yaa zan ‑a zi, 'ke ‑ya pele‑ ‑a ma dɔɔ: «Izraɛli mi ‑kpɔsɔɔ do ‑le ‑gɛ, mɛɛ gbɛtakpa mi laa 'kɛle‑.» ");
INSERT INTO moa_vpl VALUES ("JN1_48","073_1_48","JHN","1","48","48","'Bhɛ klɛle 'tɛ, 'ke Natanaɛli Zesu 'lrɔkpale dɔɔ: «Ye 'ŋ dɔ 'nale‑ ‑a ma ɛɛ?» Zesu pe ‑a ni dɔɔ: «'Sani‑ Filipu nu 'e 'siilɛ‑ 'waati 'la ba, 'ke 'mi 'e ꞊ya gban figi diiŋ 'ɛ ꞊la.» ");
INSERT INTO moa_vpl VALUES ("JN1_49","073_1_49","JHN","1","49","49","'Bhɛ klɛle 'tɛ, 'ke Natanaɛli 'a 'pele ‑a ni dɔɔ: «'O Daan mi, 'bhi ‑le 'ke *‑Waanbhaa' Gbe 'ɛ 'le, 'bhɛ 'pegee 'bhi ‑le Izraɛli mu 'ɛ 'yri ‑o ‑Bhleŋgbe 'la 'nule‑ ta 'bhɛ 'le!» ");
INSERT INTO moa_vpl VALUES ("JN1_50","073_1_50","JHN","1","50","50","Zesu 'a zikpaa‑ ‑a ni dɔɔ: «'An 'pelawoa 'e ni dɔɔ 'mi 'e ꞊ya figi diiŋ 'ɛ ꞊la, 'bhɛla‑ ‑yile 'yee 'kpa zii' 'mi 'yi ɛɛ? 'Duŋ‑ 'e nu ‑za 'ke mu yelɛ 'ke 'mu gblaan ‑yiya' 'kɛ 'lɛɛ‑ ni.» ");
INSERT INTO moa_vpl VALUES ("JN1_51","073_1_51","JHN","1","51","51","Zesu pe ‑o ni 'ezin‑ dɔɔ: «'Mi pe 'ka ni 'ŋ 'sɔwɛɛ‑ ma 'kaa 'ka 'yrɛ nu laflɛ' 'liigole yelɛ, 'bhɛɛ‑ 'ka nu ‑Waanbhaa' a ‑mlɛkɛ' 'mu 'ɛ 'sanle‑ 'pegee ‑o ‑zinale yelɛ Bhaaplɛŋ Gbe 'ɛ ma!» ");
INSERT INTO moa_vpl VALUES ("JN2_1","073_2_1","JHN","2","1","1","'Bhɛ ‑yrekpaa' yaga mi 'ɛ ma, 'ke le do dɔ yi bhɔle‑ Kana, Galile 'klɛɛn 'ɛ 'yi ‑wa 'nɛ do ta. Zesu nɛɛ ‑yaa 'bhɛ le dɔyrɛ nɔɔ‑ 'fɛti 'ɛ ta. ");
INSERT INTO moa_vpl VALUES ("JN2_2","073_2_2","JHN","2","2","2","'Bhɛɛ‑ ‑o Zesu 'pegee ‑yaa' ‑klaŋlanɛ mu 'ɛ 'siila‑ 'bhɛ le dɔyrɛ 'ɛ ꞊nɔɔ 'ezin‑. ");
INSERT INTO moa_vpl VALUES ("JN2_3","073_2_3","JHN","2","3","3","‑O ‑yaa 'bhɛ ꞊nɔɔ bhla 'la ba, 'ke ‑drɔɔ 'ɛ 'kaanle mɛɛ mu 'ɛ ma. 'Bhɛ 'yi 'tɛ, 'ke Zesu nɛɛ 'a 'pele 'yee‑ Zesu ni dɔɔ: «‑O 'kɔɔ ‑drɔɔ 'ɛ ꞊yaan.» ");
INSERT INTO moa_vpl VALUES ("JN2_4","073_2_4","JHN","2","4","4","'Bhɛ klɛle 'tɛ, 'ke Zesu 'a 'pele 'a ni dɔɔ: «'Ŋ nɛɛ, 'bhi ‑le 'mi klɛza 'ɛ pe 'mi ni ɛɛ? 'An pɛ 'waati 'ɛ yaa bhɔlɛ ‑li.» ");
INSERT INTO moa_vpl VALUES ("JN2_5","073_2_5","JHN","2","5","5","'Bhɛ 'yi, 'ke ‑a nɛɛ 'a 'pele yewonɛ mu 'ɛ ni dɔɔ: «'Ke ‑ya ꞊pia 'ka ni dɔɔ 'ka ‑za 'oo ‑za 'la klɛ, ‑ka 'bhɛɛ‑ klɛ.» ");
INSERT INTO moa_vpl VALUES ("JN2_6","073_2_6","JHN","2","6","6","‑Yi 'kla vlɛ gbɔ 'srwado‑ dulale ‑yaa ‑o ‑din 'bhɛ bhla 'ɛ ba. Zuufu mu 'a 'seri 'ɛ ta za 'ɛ ma, ‑o ‑yaa ‑yi ꞊kla 'bhɛ gbɔ mu 'ɛ 'yi, 'bhɛɛ‑ ‑woo 'fɛ 'bhɛ ‑yi 'ɛ 'le, 'bhɛɛ‑ ‑o klɛ 'weŋ. ‑O ‑yaa sɔ ‑yi 'litri mia yiziɛ 'pegee ‑yi 'litri ‑kɛmɛ do 'ke 'litri mia do 'klale 'woo‑ gbɔ mu 'ɛ 'kpɛn do do 'yi. ");
INSERT INTO moa_vpl VALUES ("JN2_7","073_2_7","JHN","2","7","7","'Bhɛ 'yi 'tɛ, 'ke Zesu 'a 'pele 'fɛti 'ɛ ta yewonɛ mu 'ɛ ni dɔɔ: «‑Ka gbɔ mu 'lɛɛ‑ pa 'ke ‑yi 'le.» 'Bhɛ klɛle 'tɛ, 'ke ‑woo 'pale 'ke ‑yi 'le 'kee‑ tɛn ‑o ‑lɛ ma. ");
INSERT INTO moa_vpl VALUES ("JN2_8","073_2_8","JHN","2","8","8","‑O bhɛ klɛle, 'ke Zesu 'a 'pele ‑o ni dɔɔ: «'Ka ‑yi 'la ꞊klaa 'yee‑ gbɔ mu 'ɛ 'yi, ‑ka 'yee‑ ‑yi 'ɛ sa 'si, 'bhɛɛ‑ 'ka ge 'kɛle‑ 'yee‑ le dɔyrɛ nɔɔ‑ 'fɛti 'ɛ ‑kuŋlii 'ɛ ni.» 'Bhɛ klɛle 'tɛ, 'ke ‑o gele‑ 'bhɛ ‑yi 'ɛ sa 'le 'fɛti 'ɛ ‑kuŋlii 'ɛ ni. ");
INSERT INTO moa_vpl VALUES ("JN2_9","073_2_9","JHN","2","9","9","'Yee‑ ‑yi 'la 'niinaa‑ 'ke ‑drɔɔ 'le, 'fɛti zan 'ɛ 'bhɛ sa ‑daan ‑a nrɛ ma. Yaa ‑yaa 'bhɛ ‑drɔɔ 'ɛ dayrɛ dɔ. 'Duŋ‑ yewonɛ mu 'la ‑yi 'ɛ ꞊twa gbɔ 'ɛ 'yi, 'mu 'yaa‑ 'bhɛ dɔ. 'Bhɛla‑ ‑yile, 'kee‑ le drɛɛ ‑nɔɔ 'ɛ 'siile. ");
INSERT INTO moa_vpl VALUES ("JN2_10","073_2_10","JHN","2","10","10","'Bhɛɛ‑ 'ke ‑ya pele‑ 'bhɛ ni dɔɔ: «Mɔkpɛn' ‑drɔɔ 'lrele‑ 'ɛ 'bhɛɛ‑ na 'cie mu 'ɛ ni 'elwale 'pe, 'bhɛɛ‑ 'ke ‑o 'bhɛ 'mia‑ 'ebebele 'waati 'la ba, 'bhɛɛ‑ ‑o sɔ 'kɛla 'bhɛ 'laa lele kplankplan 'bhɛ 'nale ‑o ni. 'Duŋ‑, 'bhi ‑drɔɔ 'lrele‑ 'ɛ 'bhɛɛ‑ ꞊twa boolazi, 'ke 'bhɛ nu 'tɛnlɛ‑ 'waati 'lɛɛ‑ ma!» ");
INSERT INTO moa_vpl VALUES ("JN2_11","073_2_11","JHN","2","11","11","'Bhɛ ‑yi 'niinaza 'ɛ ‑drɔɔ 'le, 'bhɛ ‑le ꞊kla 'ke Zesu a 'sɔle‑ maza ‑lwa mi 'ɛ 'le Kana, Galile 'klɛɛn 'yi ‑wa 'nɛ 'ɛ ta. Zesu ‑yaa' 'glɔɔya‑ 'ɛ ‑zrɔnna ‑yaa' ‑klaŋlanɛ mu 'ɛ ni 'bhɛɛ‑ klɛgbɛya 'ɛ gbɛɛn‑. 'Bhɛɛ‑ ‑yaa' ‑klaŋlanɛ mu 'ɛ ‑woo ‑kpaa ‑a ‑yi. ");
INSERT INTO moa_vpl VALUES ("JN2_12","073_2_12","JHN","2","12","12","'Bhɛ blaan, 'ke Zesu 'pegee ‑a nɛɛ, 'bhɛɛ‑ ‑a nɛɛnɛ‑ mu 'ɛ 'pegee ‑yaa' ‑klaŋlanɛ mu 'ɛ gele‑ Kapɛnɔmu ‑wa 'ɛ ta. ‑O ‑yrekpaa' 'dama ‑la ‑kla 'bhɛ ꞊nɔɔ ye. ");
INSERT INTO moa_vpl VALUES ("JN2_13","073_2_13","JHN","2","13","13","Zuufu mu a Paki 'fɛti ꞊bhwa gban bi ‑wa ‑din, 'bhɛla‑ ‑yile, Zesu ‑ja Zeruzalɛmu 'tɛ. ");
INSERT INTO moa_vpl VALUES ("JN2_14","073_2_14","JHN","2","14","14","'Bhɛɛ‑ 'kee‑ gele‑ bhɔlɛ dri 'pegee ‑bhlaa, 'bhɛɛ‑ ‑dwati' gɔn mu ta ‑Waanbhaa' Gba 'Fɛ ‑Gbɛnɛ 'ɛ ꞊la. 'Bhɛɛ‑ 'ezin‑, ‑gɔli' tabɔɔ mu yaale ‑yaa 'mu a ‑gɔli' tabɔɔ ‑tabali mu 'ɛ zi 'yee‑ ‑Waanbhaa' Gba 'Fɛ ‑Gbɛnɛ 'ɛ ꞊la. ");
INSERT INTO moa_vpl VALUES ("JN2_15","073_2_15","JHN","2","15","15","'Bhɛ klɛle 'tɛ, 'ke Zesu gbaŋbhlɛ do klɛle‑ 'ke bhlɛ mu 'le, 'bhɛɛ‑ 'ke ‑yoo 'kpɛn ‑gbinle' 'fɛ 'ɛ ꞊la, ‑o 'pegee ‑waa dri mu 'pegee ‑waa' ‑bhlaa mu 'ɛ 'le. ‑E ‑gɔli' tabɔɔ mu 'ɛ waa ‑gɔli' 'ɛ 'wianna‑ 'trɛ ma, 'bhɛɛ‑ 'kee‑ waa ‑tabali mu 'ɛ 'lɛbhulale. ");
INSERT INTO moa_vpl VALUES ("JN2_16","073_2_16","JHN","2","16","16","'Bhɛɛ‑ 'ke ‑ya pele‑ ‑dwati' gɔn mu 'ɛ ni dɔɔ: «‑Ka pɛ mu 'lɛɛ‑ 'si, 'bhɛɛ‑ 'ka ‑o 'kpɛn go ‑gɛ! 'Ka 'laa 'ŋ Dɛ a 'fɛ 'ɛ klɛlɛ 'ke yawowofɛ 'le!» ");
INSERT INTO moa_vpl VALUES ("JN2_17","073_2_17","JHN","2","17","17","'Bhɛ klɛle 'tɛ, 'ke ‑Waanbhaa' a 'Sɛwɛ 'ɛ 'yi ‑jan 'lɛɛ‑ dɔle‑ ‑yaa' ‑klaŋlanɛ mu 'ɛ 'kpee dɔɔ: «'E! ‑Waanbhaa', 'yaa‑ 'fɛ 'ɛ 'lrɔ‑ 'ɛ ‑yoo 'ŋ dɛ 'zi 'papa 'bhii‑ 'tɛbhile la pɛ ma gɔnɛ‑ 'la gbɛɛn‑.» ");
INSERT INTO moa_vpl VALUES ("JN2_18","073_2_18","JHN","2","18","18","‑Ayile, 'ke Zuufu mu 'ɛ ‑waa' ‑kuŋlii mu 'ɛ Zesu 'lrɔkpale dɔɔ: «'E sɔ ‑mɛ pɛ 'sɔle‑ maza 'gbu 'ɛ ‑dela klɛle, 'bhɛɛ‑ 'ke 'bhɛ 'a zrɔn 'o ni 'bhii‑ ‑za mu 'la bhe ‑o 'seŋ ‑o 'e ni ɛɛ?» ");
INSERT INTO moa_vpl VALUES ("JN2_19","073_2_19","JHN","2","19","19","'Bhɛ klɛle 'tɛ, 'ke Zesu 'a zikpale ‑o ni dɔɔ: «‑Ka ‑Waanbhaa' Gba ‑Gbɛnɛ 'Fɛ 'lɛɛ‑ 'wi, 'bhɛɛ‑ 'mi nu ‑a dɔ gbɛ drɛɛwolɛ ‑yrekpaa' yaga ꞊la.» ");
INSERT INTO moa_vpl VALUES ("JN2_20","073_2_20","JHN","2","20","20","Zuufu mu 'ɛ pe Zesu ni 'tɛ dɔɔ: «'O mɔɔ 'yee‑ 'fɛ 'lɛɛ‑ ‑dwa lɛɛ mia plɛ bhɛ 'srwado‑ ‑la, 'bhɛɛ‑ 'bhi nu 'sɔlɛ‑ ‑a dɔle‑ ‑yrekpaa' yaga ꞊la ɛɛ?» ");
INSERT INTO moa_vpl VALUES ("JN2_21","073_2_21","JHN","2","21","21","'Duŋ‑ Zesu 'yaa‑ ‑we 'zi ‑Waanbhaa' Gba 'Fɛ ‑Gbɛnɛ 'la 'le, 'bhɛ ‑le ‑yaa ‑a 'gbu 'flɛ 'ɛ 'le. ");
INSERT INTO moa_vpl VALUES ("JN2_22","073_2_22","JHN","2","22","22","‑Ayile, Zesu bwele blaan gale ba, ‑e 'bhɛ ‑jan 'la ꞊woa 'elwale bhe, 'bhɛ ‑jan 'ɛ ‑dwa ‑yaa' ‑klaŋlanɛ mu 'ɛ 'kpee. 'Bhɛla‑ ‑yile, 'ke ‑woo 'kpale ‑Waanbhaa' a ‑jan mu 'la ‑yoo ‑yaa' 'Sɛwɛ 'ɛ 'yi 'mu 'yi. 'Bhɛɛ‑ Zesu ‑jan mu 'la ꞊woa ‑o ni, ‑woo ꞊kpaa 'mu 'yi 'ezin‑. ");
INSERT INTO moa_vpl VALUES ("JN2_23","073_2_23","JHN","2","23","23","Zesu 'yaa‑ Zuufu mu a Paki 'fɛti 'ɛ ta bhla 'la ba Zeruzalɛmu, mɛɛ ‑bebe 'e ꞊kpaa ‑a ‑yi ‑e ‑yaa 'sɔle‑ maza mu 'la klɛ 'zi 'mu 'yrɛ ma 'mu ‑zayi'. ");
INSERT INTO moa_vpl VALUES ("JN2_24","073_2_24","JHN","2","24","24","'Duŋ‑ Zesu 'laa ‑yaa 'e 'kpa zii' ‑o ‑yi, ‑amasrɔyi ‑e ‑yaa ‑o 'kpɛn zru 'ɛ dɔ. ");
INSERT INTO moa_vpl VALUES ("JN2_25","073_2_25","JHN","2","25","25","‑A maza laa ‑yaa 'ke mɛɛ 'ke nu mɛɛ ‑bhɛɛke' do a ‑za 'yaanpelɛ ‑a ni. ‑Amasrɔyi, ‑za 'la ‑yoo bhaaplɛŋ 'kpee, ‑a 'gbu 'bhɛ dɔ. ");
INSERT INTO moa_vpl VALUES ("JN3_1","073_3_1","JHN","3","1","1","‑O ‑yaa mɛɛ do sii Nikodɛmu. *Farizi mi do ‑le ‑yaa 'bhɛ 'le. 'Bhɛɛ‑ ‑e ‑yaa Zuufu mu a ‑kuŋlii 'ɛ do 'le. ");
INSERT INTO moa_vpl VALUES ("JN3_2","073_3_2","JHN","3","2","2","Yroma do zi ‑bi 'ɛ zi, ‑e ‑ja Zesu ba, 'ke ‑ya pele‑ 'bhɛ ni dɔɔ: «'O Daan mi, 'o mɔɔ 'a 'yaango‑ 'bhii‑ ‑Waanbhaa' ‑le 'e 'winbwa‑ 'o daanyrɛ nɔɔ‑ ‑yaa' ‑jan 'ɛ 'le. ‑Amasrɔyi mɛɛ 'kedo‑ 'kpɔ 'laa sɔ 'e 'sɔle‑ maza mu 'la klɛ 'zi bhe 'mu klɛle‑, 'ke ‑Waanbhaa' laa ‑o 'bhɛ zan 'ɛ ba.» ");
INSERT INTO moa_vpl VALUES ("JN3_3","073_3_3","JHN","3","3","3","Zesu 'a 'lɛkwan‑ ‑a ni dɔɔ: «'Mi pe 'e ni 'ŋ 'sɔwɛɛ‑ ma dɔɔ mɛɛ 'kedo‑ 'kpɔ 'laa sɔ *‑Waanbhaa' a ‑bhleŋgbeya ‑wa 'ɛ 'yele 'ke waa 'bhɛ zan 'ɛ ya gbɛ drɛɛwolɛ.» ");
INSERT INTO moa_vpl VALUES ("JN3_4","073_3_4","JHN","3","4","4","'Bhɛ klɛle 'tɛ, 'ke Nikodɛmu 'a 'lrɔkpale dɔɔ: «'Ke mɛɛ do ‑kla gban 'gwlaan‑ gblaan 'le, ‑o sɔ ‑a ya gbɛ drɛɛwole 'nale‑ ‑a ma ɛɛ? Yaa sɔ niinale ‑a nɛɛ 'kpee, 'bhɛɛ‑ 'bhɛ 'a 'ya gbɛ drɛɛwo 'ezin‑.» ");
INSERT INTO moa_vpl VALUES ("JN3_5","073_3_5","JHN","3","5","5","'Duŋ‑ Zesu pe ‑a ni 'ezin‑ dɔɔ: «'Mi pe 'e ni 'ŋ 'sɔwɛɛ‑ ma dɔɔ 'ke waa mɛɛ 'la zan yalɛ 'ke ‑yi 'pegee Lii 'Weŋ 'ɛ ‑glɔɔya' 'le, 'bhɛ zan laa nu 'sɔlɛ‑ ‑Waanbhaa' 'a ‑bhleŋgbeya ‑wa 'ɛ 'yele. ");
INSERT INTO moa_vpl VALUES ("JN3_6","073_3_6","JHN","3","6","6","‑O mɛɛ 'la zan ‑yaa bhaaplɛŋ ma, bhaaplɛŋ zru ‑le 'bhɛ zan 'ɛ 'yi, 'bhɛɛ‑ 'duŋ‑, ‑o mɛɛ 'la zan ‑yaa ‑Waanbhaa' Lii 'Weŋ 'ɛ ba, 'bhɛ zan zru ‑o 'bhii‑ ‑Waanbhaa' zru gbɛɛn‑. ");
INSERT INTO moa_vpl VALUES ("JN3_7","073_3_7","JHN","3","7","7","'Mi 'a 'pelawoa 'e ni dɔɔ: ‹‑Yoo 'ke ‑za 'le 'kee 'ya gbɛ drɛɛwo›. 'Bhɛ ‑jan 'ɛ 'bhɛ 'laa 'e 'kpeelɛnilɛ 'e ma. ");
INSERT INTO moa_vpl VALUES ("JN3_8","073_3_8","JHN","3","8","8","'E 'gbu 'bhɛ 'yaango‑, ‑ploo 'ɛ, 'ke ‑ya zi 'bhii‑ ‑e 'kan yrɛ 'la ꞊nɔɔ, ‑e kan 'bhɛɛ‑ ꞊nɔɔ. 'E 'trɔnkpa‑ ‑a 'kanwli‑ 'ɛ ma, 'duŋ‑ 'yaa dayrɛ 'pegee ‑a geyrɛ dɔ. ‑Yoo 'bhɛɛ‑ gbɛɛn‑, 'ke mɛɛ 'oo mɛɛ 'la zan ‑yaa Lii 'Weŋ a ‑glɔɔya' 'ɛ ba.» ");
INSERT INTO moa_vpl VALUES ("JN3_9","073_3_9","JHN","3","9","9","'Bhɛ klɛle 'tɛ, 'ke Nikodɛmu 'a 'pele Zesu ni dɔɔ: «'Bhɛ sɔ klɛle‑ 'nale‑ 'tɛ ‑a ma ɛɛ?» ");
INSERT INTO moa_vpl VALUES ("JN3_10","073_3_10","JHN","3","10","10","Zesu 'a zikpaa‑ ‑a ni dɔɔ: «'Bhi 'la 'bhi ‑o 'ke Zuufu mu 'ɛ daan mi ‑gbɛnɛ 'le Izraɛli ‑gɛ, 'yaa 'bhɛ ‑za mu 'ɛ dɔ ɛɛ? ");
INSERT INTO moa_vpl VALUES ("JN3_11","073_3_11","JHN","3","11","11","'Mi pe 'e ni 'ŋ 'sɔwɛɛ‑ ma dɔɔ 'o mɔɔ ‑za 'la dɔ, 'o 'bhɛɛ‑ 'srɛya‑ klɛ, 'bhɛɛ‑ 'ke 'o pɛ 'la ꞊ya, 'o 'bhɛɛ‑ 'srɛya‑ klɛ 'ezin‑, 'duŋ‑ 'ka mu laa ‑o ‑a zi 'ke 'ka dɔ 'o 'wojan‑ 'ɛ ꞊la. ");
INSERT INTO moa_vpl VALUES ("JN3_12","073_3_12","JHN","3","12","12","‑Za mu 'la klɛ 'zi 'trɛ ta ‑gɛ, 'ke 'ŋ 'bhɛ mu ma ‑janwoa, 'ka 'laa 'ka kpa 'ŋ 'yi, 'bhɛɛ‑ 'ka nu 'ka 'kpalɛ‑ 'ŋ 'yi 'nale‑ ‑a ma, 'ke 'ŋ laflɛ' 'yi pɛ mu ba ‑janwoa 'ka ni bhla 'la ba ɛɛ? ");
INSERT INTO moa_vpl VALUES ("JN3_13","073_3_13","JHN","3","13","13","Mɛɛ 'kedo‑ 'kpɔ 'laa 'sanlɛ‑ ‑lido' laanima 'bhɛɛ‑ ‑e ge laflɛ' yi, 'ke yaa 'e go Bhaaplɛŋ Gbe 'ɛ do ‑kplɛn 'kpɔ ba, 'bhɛ ‑le ‑daa laflɛ' 'yi, 'bhɛɛ‑ 'bhɛ ‑le nu niinalɛ a nɔɔ‑ 'ezin‑ bhe.» ");
INSERT INTO moa_vpl VALUES ("JN3_14","073_3_14","JHN","3","14","14","«'Elwaleta ‑sɔ, Moizi piibhɛ 'tɛn ꞊sia, 'bhɛɛ‑ ‑e mlɛ ꞊kla 'bhɛ piibhɛ ‑yi 'ɛ 'le. 'Bhɛ blaan 'kee‑ 'bhɛ piibhɛ mlɛ 'ɛ 'kpale ‑yri do ta ‑kpe 'ɛ ta. 'Bhɛ klɛgbɛya do 'ɛ gbɛɛn‑, ‑o nu Bhaaplɛŋ Gbe 'ɛ 'kpalɛ‑ ‑yri ta, 'bhɛɛ‑ ‑wa wlɛn, ");
INSERT INTO moa_vpl VALUES ("JN3_15","073_3_15","JHN","3","15","15","'kooko‑ 'ke mɛɛ 'oo mɛɛ 'la zan 'e ꞊kpaa ‑a ‑yi, 'bhɛ zan nu ‑Waanbhaa' ba bole ‑yrɛ ma ‑si 'la ‑daŋ' 'laa ‑o ‑a ma 'bhɛ 'srɔɔwolɛ. ");
INSERT INTO moa_vpl VALUES ("JN3_16","073_3_16","JHN","3","16","16","‑Amasrɔyi 'drunyan ta mɛɛ mu 'ɛ 'sɔ gbɛ ‑yɔɔ 'ɛ 'kɔɔ ‑Waanbhaa' ni, 'ke ‑ya *Gbe bhɛ do 'kpɔ 'ɛ 'nale 'ke 'sraka 'le, 'kooko‑ 'ke mɛɛ 'oo mɛɛ 'la zan 'e ꞊kpaa ‑a ‑yi, 'bhɛ zan laa ni, 'bhɛɛ‑ 'bhɛ 'pleŋgole klɛ ‑Waanbhaa' ma, 'duŋ‑ 'bhɛ zan 'ɛ ‑Waanbhaa' ba bole ‑yrɛ ma ‑si 'la ‑daŋ' 'laa ‑o 'bhɛ ma 'bhɛɛ‑ 'srɔɔwo‑. ");
INSERT INTO moa_vpl VALUES ("JN3_17","073_3_17","JHN","3","17","17","'Duŋ‑, ‑Waanbhaa' laa ‑a Gbe 'ɛ 'kpalɛ‑ 'drunyan 'yi ‑kpan baa‑ zayi' 'drunyan 'yi mu 'ɛ ta. 'Duŋ‑ ‑ya gbe 'ɛ ꞊kpaa, 'kooko‑ 'ke ‑o go ‑za 'yi ‑a 'srɔyi. ");
INSERT INTO moa_vpl VALUES ("JN3_18","073_3_18","JHN","3","18","18","'Ke mɛɛ 'la zan 'e ꞊kpaa ‑Waanbhaa' Gbe 'ɛ 'yi, ‑Waanbhaa' a ‑kpan 'laa nu baalɛ 'bhɛ zan ta, 'duŋ‑ 'ke mɛɛ 'la zan 'laa 'e 'kpalɛ‑ ‑a ‑yi, ‑kpan ‑balaa' gban 'bhɛ zan 'ɛ ta, ‑amasrɔyi yaa 'kpalɛ‑ ‑Waanbhaa' Gbe bhɛ do 'kpɔ 'ɛ 'yi. ");
INSERT INTO moa_vpl VALUES ("JN3_19","073_3_19","JHN","3","19","19","‑Waanbhaa' a ‑kpan baaza 'ɛ win ‑le ‑gɛ: ‑Waanbhaa' a 'tɛbhile 'ɛ ꞊nwa 'drunyan 'yi, 'bhɛɛ‑ ‑gblo ꞊swa 'drunyan 'yi mu 'ɛ ni 'ke 'bhɛ kan 'tɛbhile 'ɛ ta, ‑amasrɔyi ‑o klɛza mu 'ɛ 'yaa‑ 'eyɔɔle. ");
INSERT INTO moa_vpl VALUES ("JN3_20","073_3_20","JHN","3","20","20","‑Amasrɔyi, 'ke mɛɛ 'oo mɛɛ 'la zan ‑za 'yɔɔ klɛ, ‑Waanbhaa' a 'tɛbhile 'ɛ vɛnsi 'bhɛ zan yin 'lii, 'bhɛɛ‑ yaa nu 'tɛbhile 'ɛ ba. ‑Amasrɔyi ‑e gblaan, 'kooko‑ 'puya 'laa nu 'kanlɛ‑ ‑a klɛza ‑yɔɔ' mu 'ɛ ta kpataakpa. ");
INSERT INTO moa_vpl VALUES ("JN3_21","073_3_21","JHN","3","21","21","'Duŋ‑ 'ke mɛɛ 'la zan ‑o wlan a pɛ zi 'ɛ ta, 'bhɛ zan nu 'tɛbhile 'ɛ ba; 'kooko‑ mɔkpɛn' 'a klɛza mu 'ɛ ye kpataakpa, 'bhɛɛ‑ ‑wa ye 'bhii‑ ‑yoo 'taawo zii' ‑Waanbhaa' a pɛ zi 'ɛ 'bhɛɛ‑ ta.» ");
INSERT INTO moa_vpl VALUES ("JN3_22","073_3_22","JHN","3","22","22","'Bhɛ blaan, 'ke Zesu 'pegee ‑yaa' ‑klaŋlanɛ mu 'ɛ ‑o gele‑ Zude 'klɛɛn 'ɛ 'yi, 'bhɛɛ‑ 'ke ‑o bole‑ 'bhɛ ꞊nɔɔ 'waati sa, 'ke ‑o mɛɛ mu 'ɛ 'wiiŋfɛ‑ ‑sɔ ‑yi ba 'bhɛ 'klɛɛn 'ɛ 'yi. ");
INSERT INTO moa_vpl VALUES ("JN3_23","073_3_23","JHN","3","23","23","'Bhɛ 'waati 'ɛ ba, Zaan ‑yaa mɛɛ mu wiiŋfɛ' zii' 'ezin‑ yrɛ do nɔɔ‑, ‑o ‑yaa 'bhɛ yrɛ 'ɛ sii Enɔ, 'bhɛɛ‑ 'bhɛ 'yaa‑ Salimu ‑wa 'ɛ ‑din. ‑Amasrɔyi ‑yi ‑bebe ‑yaa 'bhɛ yrɛ 'ɛ ꞊nɔɔ. Mɛɛ mu 'ɛ 'yaa‑ nu 'zi ‑a ba, 'bhɛɛ‑ ‑e ‑yaa 'mu wiiŋfɛ ‑yi ba 'bhɛ yrɛ 'ɛ ꞊nɔɔ. ");
INSERT INTO moa_vpl VALUES ("JN3_24","073_3_24","JHN","3","24","24","'Bhɛ 'waati 'ɛ ba 'ezin‑, 'ke waa Zaan bɔlɛ ‑li ‑kaso 'yi. ");
INSERT INTO moa_vpl VALUES ("JN3_25","073_3_25","JHN","3","25","25","'Bhɛ 'yi 'tɛ, Zaan a ‑klaŋlanɛ mu 'ke mu zaabɔle ‑saan Zuufu mi do 'le ‑woo fɛ ‑waa' 'seri 'ɛ ta gɔnɛ‑ 'la gbɛɛn‑ 'bhɛɛ‑ ‑o 'fleele‑ klɛ ‑Waanbhaa' ‑yrɛ 'yi 'bhɛ ‑zayi'. ");
INSERT INTO moa_vpl VALUES ("JN3_26","073_3_26","JHN","3","26","26","'Bhɛɛ‑, 'ke 'yee‑ Zaan a ‑klaŋlanɛ mu 'ɛ gele‑ 'tɛnlɛ‑ a ma, 'ke ‑wa pele‑ ‑a ni dɔɔ: «'O Daan mi, mɛɛ 'la zan ‑yaa 'e ‑din Zrudɛn yue yrɛ gbɛ do 'ɛ ta laale, 'bhɛɛ‑ 'e ‑janwoa 'o ni ‑a ba zayi' bhe; 'e 'yrɛkpa ‑gɛ doo, ‑yoo mɛɛ mu wiiŋfɛ' zii' 'ezin‑. 'Bhɛɛ‑ mɛɛ mu 'ɛ 'kpɛn ‑o ge 'zi ‑a ba ye.» ");
INSERT INTO moa_vpl VALUES ("JN3_27","073_3_27","JHN","3","27","27","Zaan 'a zikpaa‑ ‑o ni dɔɔ: «'Ke ‑Waanbhaa' laa pɛ 'la 'nalɛ‑ mɛɛ ni, ‑e sɔ 'bhɛ 'srɔɔwole ɛɛ? ");
INSERT INTO moa_vpl VALUES ("JN3_28","073_3_28","JHN","3","28","28","'Ka mu 'gbu ‑o 'ŋ 'srɛ 'le 'kaa 'an ꞊pia dɔɔ: ‹'Mi 'naa ‑o 'ke Mɛɛ ‑Bhee Mi ‑Kpɔsɔɔ Krisi 'ɛ 'le, 'duŋ‑ ‑Waanbhaa' 'mi 'winbwa‑ ‑a ‑lɛɛ.› ");
INSERT INTO moa_vpl VALUES ("JN3_29","073_3_29","JHN","3","29","29","'Ka 'gbu 'a 'yaango‑ dɔɔ mɛɛ 'la zan a pɛ ‑le 'ke le drɛɛ 'ɛ 'le, 'bhɛ zan ‑le 'yee‑ le drɛɛ ‑nɔɔ 'ɛ 'le. 'Duŋ‑ le drɛɛ ‑nɔɔ 'bhɛgwlɛn‑ 'ɛ 'bhɛ dulale 'la ‑yoo le drɛɛ ‑nɔɔ 'ɛ ‑din, 'bhɛɛ‑ 'ke ‑ya 'trɔnbadɔ 'bhɛ 'weli‑ 'ɛ ꞊la, 'bhɛ 'a zrukpalaa 'egbɛnɛle. 'Bhɛ zrukpaa', 'bhɛ ‑le 'mi a pɛ 'ɛ 'le, 'bhɛɛ‑ ‑a ‑lɛpaa ‑zɔn. ");
INSERT INTO moa_vpl VALUES ("JN3_30","073_3_30","JHN","3","30","30","‑Yoo 'ke ‑za 'le 'ke ‑o 'yee‑ magbaandɛ, 'bhɛɛ‑ ‑o 'mi mavɛɛ.» ");
INSERT INTO moa_vpl VALUES ("JN3_31","073_3_31","JHN","3","31","31","Mɛɛ Wiiŋfɛ' Mi Zaan pe ‑o ni 'ezin‑ dɔɔ: «'Ke mɛɛ 'la zan ‑daa laanima, 'bhɛ zan 'ɛ 'kpaale‑ ‑o pɛ 'kpɛn 'wiiŋ‑. 'Duŋ‑ 'ke mɛɛ zan ‑daa 'trɛ ta, 'bhɛ zan 'ɛ 'bhɛ ‑o 'ke 'yee‑ 'drunyan 'lɛɛ‑ 'yi mi 'le, 'bhɛɛ‑ ‑e ‑janwo' 'bhii‑ 'trɛ ta mɛɛ do gbɛɛn‑. 'Ke mɛɛ 'la zan ‑daa laanima, 'bhɛ zan 'ɛ 'kpaale‑ ‑o pɛ 'kpɛn 'wiiŋ‑. ");
INSERT INTO moa_vpl VALUES ("JN3_32","073_3_32","JHN","3","32","32","‑E ‑za 'la ꞊ya, 'bhɛɛ‑ ‑e 'kɛla ꞊maa, ‑e mu ‑la 'srɛya‑ klɛ. 'Bhɛɛ‑ 'duŋ‑, mɛɛ 'kedo‑ 'kpɔ 'laa dɔ 'bhɛ 'srɛya‑ ma jan 'ɛ ꞊la. ");
INSERT INTO moa_vpl VALUES ("JN3_33","073_3_33","JHN","3","33","33","'Ke mɛɛ 'la zan ‑dwa ‑a wojan 'ɛ ꞊la, 'bhɛ zan 'a zrɔn 'bhɛ gbɛɛn‑ bhe 'bhii‑ ‑Waanbhaa' wlan pe kpataakpa. ");
INSERT INTO moa_vpl VALUES ("JN3_34","073_3_34","JHN","3","34","34","‑Waanbhaa' mɛɛ 'la zan winbwa‑, 'bhɛ zan 'ɛ ‑Waanbhaa' a ‑jan mu ‑la wo, ‑amasrɔyi ‑Waanbhaa' 'a *Lii 'Weŋ 'ɛ na 'bhɛ zan ni 'ke ‑daŋ' 'laa klɛ 'bhɛ ma. ");
INSERT INTO moa_vpl VALUES ("JN3_35","073_3_35","JHN","3","35","35","‑Nɛ 'ɛ ‑za sɔ ‑a Dɛ ‑Waanbhaa' ni, 'bhɛla‑ ‑zayile ‑a Dɛ ‑za 'kpɛn gbɛkpaa‑ ‑a 'kɔɔ. ");
INSERT INTO moa_vpl VALUES ("JN3_36","073_3_36","JHN","3","36","36","'Ke mɛɛ 'la zan 'e ꞊kpaa ‑a Gbe 'ɛ 'yi, ‑daŋ' 'laa ‑o bole ‑yrɛ ma ‑si 'la ma 'bhɛ ‑o 'bhɛ zan 'kɔɔ. 'Duŋ‑ 'ke mɛɛ 'la zan laa dɔlɛ ‑a ‑la 'ke ‑ya kpa ‑a Gbe 'ɛ 'yi, 'bhɛ zan laa nu 'bhɛ bole ‑yrɛ ma ‑si 'ɛ 'srɔɔwolɛ, 'bhɛ zan nu bolɛ ‑Waanbhaa' a 'kiti ‑yrɛn 'ɛ 'yi yikpɛnsee ta.» ");
INSERT INTO moa_vpl VALUES ("JN4_1","073_4_1","JHN","4","1","1","Farizi mu 'ɛ ‑wa ‑maa mɛɛ mu ta dɔɔ Zesu 'yaa‑ ‑klaŋlanɛ ‑bebe 'srɔɔwo zii' 'kee‑ 'mu 'wiiŋfɛ‑ 'ke 'bhɛ kan Mɛɛ Wiiŋfɛ' Mi Zaan ta. ");
INSERT INTO moa_vpl VALUES ("JN4_2","073_4_2","JHN","4","2","2","'Bhɛɛ‑ 'duŋ‑, 'yee‑ Zesu 'gbu 'laa ‑yaa mɛɛ mu wiiŋfɛ' zii', ‑yaa' ‑klaŋlanɛ mu 'ɛ 'mu ‑le ‑yaa 'bhɛ klɛ 'zi. ");
INSERT INTO moa_vpl VALUES ("JN4_3","073_4_3","JHN","4","3","3","'Bhɛla‑ ‑yile, 'ke 'yee‑ Zesu gole‑ Zude 'klɛɛn 'ɛ 'yi, 'bhɛɛ‑ 'kee‑ niinale ‑a ‑zanta' Galile 'klɛɛn 'ɛ 'yi. ");
INSERT INTO moa_vpl VALUES ("JN4_4","073_4_4","JHN","4","4","4","‑A ge bhla zi Galile 'klɛɛn 'ɛ 'yi, yaa ‑yaa sɔ 'kanle ‑yrɛ ‑bhɛɛke' do 'kpɔ ꞊nɔɔ 'ke yaa 'e go Samari 'klɛɛn 'ɛ ba. ");
INSERT INTO moa_vpl VALUES ("JN4_5","073_4_5","JHN","4","5","5","‑E ‑ja bhɔlɛ Samari 'klɛɛn 'ɛ 'yi ‑wa 'nɛ do 'la ‑o ‑yaa 'bhɛ sii Sikaa 'bhɛɛ‑ ta. 'Bhɛ Sikaa ‑wa 'ɛ 'yaa‑ Zakɔbu gba 'la 'naa‑ ‑a gbe Zozɛfu ni 'bhɛɛ‑ ‑din. ");
INSERT INTO moa_vpl VALUES ("JN4_6","073_4_6","JHN","4","6","6","Zakɔbu ‑klɔŋ 'la 'kaan‑, 'bhɛ 'yaa‑ 'bhɛ yrɛ 'ɛ ꞊nɔɔ. 'Bhɛ 'yi bhe, Zesu 'trɛlabhwa 'taa 'ɛ 'kɔɔ, 'kee‑ gele‑ yaalɛ 'bhɛ ‑klɔŋ 'ɛ bhoŋla. 'Bhɛ ꞊kla ‑yrekpaa' bhɔ 'waati 'ɛ ‑din. ");
INSERT INTO moa_vpl VALUES ("JN4_7","073_4_7","JHN","4","7","7","'Bhɛ ya 'ɛ 'yi, 'ke Samari le do nule‑ ‑yi 'tɔyrɛ‑ nɔɔ‑ 'bhɛ ‑klɔŋ 'ɛ 'yi. 'Bhɛɛ‑ 'ke Zesu 'a 'pele 'a ni dɔɔ: «'Ŋ gba mi yi sa ba.» ");
INSERT INTO moa_vpl VALUES ("JN4_8","073_4_8","JHN","4","8","8","'Bhɛ 'waati 'ɛ ba, 'ke Zesu a ‑klaŋlanɛ mu 'ɛ ‑ja gban ‑waa' pɛbhle ‑lɔyrɛ' nɔɔ‑ ‑wa 'ɛ 'kpee. ");
INSERT INTO moa_vpl VALUES ("JN4_9","073_4_9","JHN","4","9","9","'Bhɛ klɛle 'tɛ, 'ke Samari le 'ɛ ‑ya pele‑ Zesu ni dɔɔ: «'Aa! 'Bhi Zuufu mi, 'e mi yi ‑yrɛwo' zii' 'mi ‑la ma ɛɛ, 'mi 'la 'mi ‑o 'ke Samari le 'le bhe ɛɛ?» 'Yee‑ ‑le 'ɛ 'bhɛ ‑jan ‑glɔɔn 'ɛ ꞊woa, ‑amasrɔyi Zuufu mu 'ɛ 'pegee Samari mu 'ɛ waa ‑za 'laa ‑yaa 'eke‑ ta. ");
INSERT INTO moa_vpl VALUES ("JN4_10","073_4_10","JHN","4","10","10","'Bhɛ 'yi 'tɛ, 'ke Zesu 'a zikpale ‑a ni dɔɔ: «'Kee‑ 'kpa bi ‑Waanbhaa' bhaaplɛŋ mu ‑gbaa pɛ 'la ba 'e 'bhɛ dɔ bi, 'bhɛɛ‑ mɛɛ 'la zan ‑o mi yi ‑yrɛwo' zii' 'e ma, 'kee 'yaa‑ 'bhɛ zan 'ɛ dɔ bi, 'bhi 'gbu ‑le ‑yaa nu mi yi ‑yrɛwolɛ 'bhɛ zan 'ɛ ma. 'Bhɛɛ‑ ‑yi 'la 'bhɛ bole ‑yrɛ ma ‑si na mɛɛ ni, ‑e ‑yaa nu 'bhɛɛ‑ 'nalɛ‑ 'e ni.» ");
INSERT INTO moa_vpl VALUES ("JN4_11","073_4_11","JHN","4","11","11","'Bhɛ klɛle 'tɛ, 'ke le 'ɛ ‑ya pele‑ Zesu ni dɔɔ: «Mɛɛzan, ‑yi 'tɔ 'gboŋgbo 'laa ‑o 'e 'kɔɔ, 'bhɛɛ‑ ‑klɔŋ 'ɛ tro. 'E nu 'sɔlɛ‑ 'yee‑ ‑yi 'la 'kee‑ bole ‑yrɛ ma ‑si 'ɛ na mɛɛ ni 'bhɛ 'srɔɔwole 'naa ma ɛɛ? ");
INSERT INTO moa_vpl VALUES ("JN4_12","073_4_12","JHN","4","12","12","'O ‑gbɔɔ Zakɔbu ‑le ‑klɔŋ 'lɛɛ‑ 'kaan‑, 'bhɛɛ‑ ‑ya ‑naa 'o ni. 'Yee‑ 'gbu 'pegee ‑a gbe mu 'ɛ, 'bhɛɛ‑ ‑yaa' tropɛ mu 'ɛ ‑o 'yee‑ ‑klɔŋ 'lɛɛ‑ 'yi yi 'ɛ ꞊mia. 'Bhi 'kpee ma 'e gblaan ‑yiya' 'o ‑gbɔɔ Zakɔbu ni ɛɛ?» ");
INSERT INTO moa_vpl VALUES ("JN4_13","073_4_13","JHN","4","13","13","Zesu 'a zikpaa‑ ‑a ni dɔɔ: «'Ke mɛɛ 'oo mɛɛ 'la zan ‑klɔŋ 'lɛɛ‑ 'yi yi 'ɛ ‑mia, ‑yi 'mi ‑lrɔ nu 'bhɛ zan dɛ gbɛ drɛɛwolɛ 'ezin‑; ");
INSERT INTO moa_vpl VALUES ("JN4_14","073_4_14","JHN","4","14","14","'duŋ‑ 'ke 'mi 'ŋ 'kɔɔ ‑yi 'ɛ ꞊naa mɛɛ 'la zan ni, 'bhɛɛ‑ ‑ya ‑mia, ‑yi 'mi ‑lrɔ 'laa nu 'bhɛ zan 'ɛ dɛlɛ ‑li ‑titi. ‑Amasrɔyi, 'ŋ nu ‑yi 'la 'bhɛ 'nalɛ‑ 'bhɛ zan 'ɛ ni, 'bhɛ nu klɛlɛ 'bhii‑ tɔ ŋgblo do 'bhɛ zan 'ɛ 'yi, 'bhɛɛ‑ yaa nu ‑bheelɛ' ‑titi. 'Bhɛɛ‑ 'bhɛ tɔ ŋgblo 'ɛ nu ‑si 'la 'ke ‑daŋ' 'laa 'bhɛ ma 'bhɛ 'nalɛ‑ 'bhɛ zan ni.» ");
INSERT INTO moa_vpl VALUES ("JN4_15","073_4_15","JHN","4","15","15","'Bhɛ klɛlɛ 'tɛ, 'ke 'yee‑ le 'ɛ ‑ya pele‑ Zesu ni dɔɔ: «Mɛɛzan, 'ŋ gba 'bhɛ ‑yi 'ɛ 'ke ba, 'kooko‑ ‑yi 'mi ‑lrɔ 'laa 'ŋ dɛ ‑li, 'bhɛɛ‑ 'naa nu ‑yi 'tɔlɛ‑ ‑li ‑gɛ ‑titi.» ");
INSERT INTO moa_vpl VALUES ("JN4_16","073_4_16","JHN","4","16","16","'Bhɛ 'yi 'tɛ, Zesu pe ‑a ni dɔɔ: «Ge 'e ꞊nɔɔ 'sii‑, 'bhɛɛ‑ 'ka nu ‑gɛ doo.» ");
INSERT INTO moa_vpl VALUES ("JN4_17","073_4_17","JHN","4","17","17","'Bhɛ klɛle 'tɛ, 'ke 'yee‑ le 'ɛ ‑ya ‑lɛkunle Zesu ni dɔɔ: «'Ŋ ꞊nɔɔ 'laa ‑o.» Zesu pe ‑a ni 'ezin‑ dɔɔ: «'Zoo ‑o 'e zi 'ke 'ya pe dɔɔ 'e ꞊nɔɔ 'laa ‑o; ");
INSERT INTO moa_vpl VALUES ("JN4_18","073_4_18","JHN","4","18","18","‑amasrɔyi, 'e 'yalaa gwlɛn na ‑glɔɔn 'soo, 'bhɛɛ‑ 'yoo‑ mɛɛ 'la zan 'kɔɔ ‑zɔn, 'e ꞊nɔɔ 'laa 'bhɛ zan 'ɛ 'le. 'E ‑jan 'la ꞊woa bhe wlan ‑le 'bhɛ 'le.» ");
INSERT INTO moa_vpl VALUES ("JN4_19","073_4_19","JHN","4","19","19","'Bhɛ klɛle 'tɛ, 'ke 'yee‑ le 'ɛ ‑ya pele‑ Zesu ni dɔɔ: «'Ee! Mɛɛzan, 'an 'yaango‑ 'bhii‑ 'yoo‑ wlan ma ‑Waanbhaa' * ‑lɛla' janwo mi do 'le. ");
INSERT INTO moa_vpl VALUES ("JN4_20","073_4_20","JHN","4","20","20","'O mɔɔ Samari mu, 'o ‑gbɔɔ mu ‑Waanbhaa' ‑gbaa vlɛ gɔɔn 'lɛɛ‑ 'bhɛɛ‑ 'wiiŋ‑ ‑gɛ, 'bhɛɛ‑ 'duŋ‑, 'ka mu Zuufu mu, 'ka pe dɔɔ ‑o ‑Waanbhaa' gba yrɛ 'la ꞊nɔɔ, 'bhɛ ‑o Zeruzalɛmu do ‑kplɛn 'la ꞊nɔɔ.» ");
INSERT INTO moa_vpl VALUES ("JN4_21","073_4_21","JHN","4","21","21","Zesu 'bhɛ zikpaa‑ ‑a ni dɔɔ: «Le ‑nɛ, 'ŋ 'yoo zan ‑jan 'la 'wolɛ‑ 'e ni 'e 'kpa 'bhɛ 'yi, 'waati do ‑o zan bhɔlɛ', 'bhɛɛ‑ 'ka 'laa nu 'ŋ Dɛ ‑Waanbhaa' gbalɛ ‑li vlɛ gɔɔn 'lɛɛ‑ 'wiiŋ‑, 'bhɛ 'pegee Zeruzalɛmu. ");
INSERT INTO moa_vpl VALUES ("JN4_22","073_4_22","JHN","4","22","22","'Ka mu Samari mu, 'ka pɛ 'la 'bhɛ gba 'ka 'laa 'bhɛ dɔ; 'o mɔɔ pɛ 'la 'bhɛ gba 'o 'bhɛ dɔ, ‑amasrɔyi ‑Waanbhaa' bhaaplɛŋ mu go ‑za 'yi gɔnɛ‑ 'la gbɛɛn‑, Zuufu mu ‑le sɔ 'bhɛ 'pele 'ka ni. ");
INSERT INTO moa_vpl VALUES ("JN4_23","073_4_23","JHN","4","23","23","'Duŋ‑ 'bhɛ 'waati ‑o zan bhɔlɛ, 'bhɛɛ‑ 'bhɛ ꞊bhwa gban, 'bhɛ 'waati 'ɛ ba, 'ŋ Dɛ ‑Waanbhaa' gba mu kplankplan mu 'ɛ ‑o nu ‑a gbalɛ Lii 'Weŋ 'ɛ 'yi 'bhɛ 'pegee wlan ma. ‑Amasrɔyi 'ŋ Dɛ ‑Waanbhaa' ‑o 'bhɛɛ‑ mɛɛ ‑glɔɔn 'ɛ ‑glin 'zi 'bhɛɛ‑ ‑wa gba. ");
INSERT INTO moa_vpl VALUES ("JN4_24","073_4_24","JHN","4","24","24","‑Waanbhaa' 'gbu ‑o 'ke Lii 'le, ‑yoo 'ke ‑za 'le 'ke mɛɛ 'la zan mu 'a gba, 'bhɛ zan mu 'a gba ‑a Lii 'Weŋ 'ɛ 'seŋ ta 'bhɛ 'pegee wlan ma.» ");
INSERT INTO moa_vpl VALUES ("JN4_25","073_4_25","JHN","4","25","25","'Bhɛ klɛle 'tɛ, 'ke 'yee‑ le 'ɛ ‑ya pele‑ Zesu ni dɔɔ: «'An 'yaango‑ dɔɔ *Mesi 'ɛ ('bhɛ 'yi ‑le ‹Mɛɛ ‑Bhee Mi ‑Kpɔsɔɔ›) ‑o 'bhɛ ‑la sii Krisi, 'bhɛ nu nulɛ. 'Ke 'bhɛ ꞊nwa 'bhɛ nu ‑za 'kpɛn 'yipelɛ 'o ni.» ");
INSERT INTO moa_vpl VALUES ("JN4_26","073_4_26","JHN","4","26","26","Zesu 'a zikpaa‑ ‑a ni dɔɔ: «'Mi 'la 'mi ‑o ‑janwo' zii' 'e ni ‑gɛ bhe, 'mi ‑le 'kɛle‑.» ");
INSERT INTO moa_vpl VALUES ("JN4_27","073_4_27","JHN","4","27","27","'Bhɛ 'waati 'ɛ ba, 'ke Zesu ‑a ‑klaŋlanɛ mu 'ɛ 'nule 'tɛ; ‑wa yelawoa 'ke ‑yoo ‑balo klɛ 'zi 'ke le do 'le bhe, 'bhɛ ‑o 'kpeelɛnia ‑o ma. 'Duŋ‑ yaa dɔlɛ ‑o 'kedo‑ 'kpɔ 'kpee 'ke 'bhɛ 'a 'lrɔkpa‑ dɔɔ: «‑Yoo ‑mɛ za ‑la ‑yilrɔkpa zii' 'e ma ɛɛ? 'Bhɛ 'pegee 'ka 'pegee 'yee‑ ‑o ‑mɛ pɛ jan ‑la wo zii' ɛɛ?» 'Bhɛ 'pegee dɔɔ: «‑Mɛla ma 'yoo‑ ‑balo klɛ 'zi 'kɛle‑ ɛɛ?» ");
INSERT INTO moa_vpl VALUES ("JN4_28","073_4_28","JHN","4","28","28","'Bhɛ klɛle 'tɛ, 'ke le 'ɛ ‑e yaa ‑yi gbɔ 'ɛ 'tole ‑a nɔɔ‑, 'kee‑ gele‑ ‑wa ꞊la, 'bhɛɛ‑ 'ke ‑ya pele‑ mɛɛ mu 'ɛ ni dɔɔ: ");
INSERT INTO moa_vpl VALUES ("JN4_29","073_4_29","JHN","4","29","29","«‑Ka nu mɛɛ 'lɛɛ‑ ‑glin doo, 'mi ‑za 'oo ‑za mu 'la ꞊kla 'elwale gban, ‑e 'mu 'kpɛn ꞊pia 'ŋ ni. ‑Dɔke' Mɛɛ ‑Bhee Mi ‑Kpɔsɔɔ Krisi 'ɛ 'yele‑ 'kɛle‑ oo.» ");
INSERT INTO moa_vpl VALUES ("JN4_30","073_4_30","JHN","4","30","30","'Bhɛ klɛle 'tɛ, 'ke ‑wa 'ɛ ta mu 'ɛ 'pwɛle, 'bhɛɛ‑ 'ke ‑o nule‑ Zesu ‑glinyrɛ' nɔɔ‑. ");
INSERT INTO moa_vpl VALUES ("JN4_31","073_4_31","JHN","4","31","31","'Bhɛ 'waati 'ɛ ba, Zesu a ‑klaŋlanɛ mu 'ɛ 'yaa‑ matɛdɔ 'zi dɔɔ: «'O Daan mi, 'e 'zoole‑, pɛ sa bhle!» ");
INSERT INTO moa_vpl VALUES ("JN4_32","073_4_32","JHN","4","32","32","'Duŋ‑, ‑ya ‑lɛkwan 'mu ni dɔɔ: «Pɛ 'la ‑yoo 'ŋ 'kɔɔ 'ke 'bhɛ ‑o 'ke 'ŋ 'bhle pɛ 'le, 'ka 'laa 'bhɛ dɔ.» ");
INSERT INTO moa_vpl VALUES ("JN4_33","073_4_33","JHN","4","33","33","'Bhɛ 'yi, 'ke ‑yaa' ‑klaŋlanɛ mu 'ɛ ‑woo 'eke‑ ‑lrɔkpale dɔɔ: «Taa‑ mɛɛ 'ke mu ‑nwa pɛle nalɛ ‑a ni ɛɛ?» ");
INSERT INTO moa_vpl VALUES ("JN4_34","073_4_34","JHN","4","34","34","Zesu pe ‑o ni dɔɔ: «'Ŋ 'bhle pɛle 'ɛ 'bhɛ ‑le 'ke 'ŋ 'winbɔ‑ mi 'ɛ 'bhɛ zru maza klɛle 'le, 'bhɛɛ‑ ‑e ye 'la gbɛkpaa‑ 'ŋ 'kɔɔ 'ke 'ŋ 'bhɛ 'lɛyan‑. ");
INSERT INTO moa_vpl VALUES ("JN4_35","073_4_35","JHN","4","35","35","‑Wa pe dɔɔ: ‹‑A ‑vinbwa mlɛ yiziɛ 'bhɛɛ‑ pɛbhaa 'kan bhla 'ɛ bhɔ.› 'Duŋ‑ 'mi pe 'ka ni dɔɔ ‑ka 'ka 'yrɛkpa gba mu 'ɛ ta laale doo, pɛbhaa mu 'ɛ 'tranna‑, 'bhɛɛ‑ ‑o 'kan 'waati ꞊bhwa gban! ");
INSERT INTO moa_vpl VALUES ("JN4_36","073_4_36","JHN","4","36","36","Pɛbhaa 'kan mi 'ɛ, ‑e ‑yaa pɛbhaa 'kanle‑ ma ‑sra 'srɔɔwo‑, 'bhɛɛ‑ ‑yoo pɛbhaa mu 'ɛ 'lɛkpa‑ zii' 'eke‑ ta 'ke ‑yoo to bole ‑yrɛ ma ‑si 'la ‑daŋ' 'laa ‑o ‑a ma 'bhɛ ‑zayi'. 'Bhɛ klɛgbɛya do 'ɛ 'yi, pɛbhɛ bɔ mi 'pegee pɛbhaa 'kan mi 'ɛ ‑o mɛɛ plɛ zrukpaa' 'srɔɔwo‑ 'eke‑ zi. ");
INSERT INTO moa_vpl VALUES ("JN4_37","073_4_37","JHN","4","37","37","‑Amasrɔyi, ‑o ‑gɔɔn 'la bɔ dɔɔ: ‹Mɛɛ do pɛbhɛ bɔ, 'bhɛɛ‑ mɛɛ ‑bhɛɛke' do pɛbhaa kan.› Wlan ‑le 'bhɛ ‑gɔɔn 'ɛ 'le. ");
INSERT INTO moa_vpl VALUES ("JN4_38","073_4_38","JHN","4","38","38","'Bhɛ ya 'ɛ 'yi, 'mi 'ka 'winbwa‑ pɛbhaa 'kanyrɛ‑ nɔɔ‑ gba 'la 'ka 'laa ‑yrɛnbhlelɛ 'bhɛ 'kpale ma 'bhɛ 'yi; mɛɛ ‑bhɛɛke' mu ‑le ‑yrɛnbhla 'bhɛ gba 'ɛ 'kpale‑ ma, 'bhɛɛ‑ 'ka mu ‑o ‑trɔn 'srɔɔwo zii' ‑o woye 'ɛ ma.» ");
INSERT INTO moa_vpl VALUES ("JN4_39","073_4_39","JHN","4","39","39","Samari mu ‑bebe ‑o ꞊kpaa Zesu 'yi 'bhɛ ‑wa 'ɛ ta, le 'ɛ ‑jan 'la ꞊woa ‑o ni 'bhɛ ‑zayi' dɔɔ: «'Mi ‑za 'oo ‑za mu 'la 'kpɛn ꞊kla 'elwale gban, ‑e 'mu 'yipia꞊ 'ŋ ni.» ");
INSERT INTO moa_vpl VALUES ("JN4_40","073_4_40","JHN","4","40","40","'Woo‑ Samari mu 'ɛ 'bhɔle‑ Zesu ‑din, 'ke ‑o ‑sromabɔle ‑a ni dɔɔ ‑e bo ‑o ba ye 'waati sa. ‑Ayile, 'kee‑ bole‑ ‑o ba ‑yrekpaa' plɛ ta 'ezin‑. ");
INSERT INTO moa_vpl VALUES ("JN4_41","073_4_41","JHN","4","41","41","'Bhɛ klɛle 'tɛ, 'ke mɛɛ ‑bhɛɛke' ‑bebe 'e 'kpale Zesu 'yi 'ezin‑ ‑a 'gbu 'wojan‑ mu 'ɛ ma. ");
INSERT INTO moa_vpl VALUES ("JN4_42","073_4_42","JHN","4","42","42","'Woo‑ mɛɛ mu 'ɛ pe le 'ɛ ni dɔɔ: «'Waa 'o 'kpalɛ‑ ‑a ‑yi 'bhi 'wojan‑ drɔŋ 'ɛ 'bhɛ ma, 'duŋ‑ 'woo ꞊kpaa ‑a ‑yi, ‑amasrɔyi 'o mɔɔ 'gbu 'a wojan mu 'ɛ ꞊maa, 'wa 'yaangwa‑ 'bhii‑ 'yele‑ 'ke 'drunyan 'yi mu 'ɛ 'Bhee Mi kpataakpa 'ɛ 'le.» ");
INSERT INTO moa_vpl VALUES ("JN4_43","073_4_43","JHN","4","43","43","Zesu 'yanle ‑yrekpaa' plɛ klɛlele 'bhɛ yrɛ 'ɛ ꞊nɔɔ, 'kee‑ gele‑ Galile 'trɛ ta. ");
INSERT INTO moa_vpl VALUES ("JN4_44","073_4_44","JHN","4","44","44","‑Amasrɔyi 'yee‑ 'gbu 'a ꞊pia‑ dɔɔ: «Waa ‑Waanbhaa' *‑lɛla' janwo mi ‑lɛdɔ' a ma ‑a 'gbu a 'klɛɛn 'yi.» ");
INSERT INTO moa_vpl VALUES ("JN4_45","073_4_45","JHN","4","45","45","‑E bhɔle 'duŋ‑ Galile 'klɛɛn 'ɛ 'yi, 'ke bhɛ ꞊nɔɔ mɛɛ mu 'ɛ ‑wa 'kunle 'elrele. ‑Amasrɔyi Zesu ‑za mu 'la 'kpɛn ꞊kla Paki 'fɛti 'ɛ ta Zeruzalɛmu 'mu 'bhɛ mu ꞊ya. ‑Amasrɔyi 'bhɛ mu 'gbu 'yaa‑ 'bhɛ 'fɛti 'ɛ ta 'ezin‑. ");
INSERT INTO moa_vpl VALUES ("JN4_46","073_4_46","JHN","4","46","46","Zesu ꞊nwa 'ezin‑ 'tɛ Kana ‑wa 'ɛ ta, Galile 'klɛɛn 'ɛ 'yi; ‑e ‑yi 'niinaa‑ 'ke ‑drɔɔ 'le 'elwale 'bhɛɛ‑ ‑wa 'ɛ ta. Yeta mi ‑gbɛnɛ do ‑yaa ye, 'bhɛɛ‑ ga ‑yaa 'bhɛ gbe ‑nɛ 'ɛ ma Kapɛnɔmu. ");
INSERT INTO moa_vpl VALUES ("JN4_47","073_4_47","JHN","4","47","47","'Bhɛɛ‑, 'yee‑ yeta mi ‑gbɛnɛ 'ɛ ‑ya male 'kaa Zesu ‑gwa Zude 'klɛɛn 'ɛ 'yi, 'bhɛɛ‑ ‑e ꞊nwa Galile 'klɛɛn 'ɛ 'yi, 'kee‑ gele‑ 'tɛnlɛ‑ Zesu ma. 'Bhɛɛ‑ 'kee‑ ‑sromabɔle Zesu ni dɔɔ 'bhɛ ge ‑a gbe 'ɛ 'bhee‑ Kapɛnɔmu. ‑Amasrɔyi ‑a gbe 'ɛ 'yaa‑ zan klɛlɛ 'ke 'siɛle. ");
INSERT INTO moa_vpl VALUES ("JN4_48","073_4_48","JHN","4","48","48","Zesu pe ‑a ni 'tɛ dɔɔ: «'Ka nu bolɛ 'bhɛɛ‑ klɛle ma 'taŋii ɛɛ? 'Ka 'laa sɔ 'ka 'kpale 'ŋ 'yi, 'ke 'naa 'sɔle‑ maza mu 'pegee 'kpeelɛni maza mu klɛlɛ 'ka 'yrɛ ma ɛɛ?» ");
INSERT INTO moa_vpl VALUES ("JN4_49","073_4_49","JHN","4","49","49","'Bhɛ 'yi 'tɛ, 'ke 'yee‑ yeta mi 'ɛ ‑ya zikpale Zesu ni dɔɔ: «Mɛɛzan, 'e 'zoole‑, nu blaale‑ 'sani 'ŋ gbe ‑nɛ 'ɛ yaa nu galɛ.» ");
INSERT INTO moa_vpl VALUES ("JN4_50","073_4_50","JHN","4","50","50","'Bhɛ klɛle 'tɛ, 'ke Zesu 'a 'pele 'a ni dɔɔ: «Ge 'e ba ‑lɛ ma, 'e 'nɛ ‑ya ‑yrɛ ma.» 'Bhɛ ꞊nɔɔ bhe, 'ke 'yee‑ mɛɛ ‑ya 'kpale Zesu 'wojan‑ 'ɛ 'yi, 'bhɛɛ‑ 'kee‑ gele‑ ‑a ba ‑lɛ ma. ");
INSERT INTO moa_vpl VALUES ("JN4_51","073_4_51","JHN","4","51","51","‑E ‑yaa ‑a ba ‑lɛ ma zi 'ɛ 'lii bhla 'la ba, 'ke ‑yaa' 'fɛ 'ɛ ꞊la yewonɛ mu 'ɛ 'nule ‑a ‑lɛpalɛ, 'bhɛɛ‑ 'ke ‑wa pele‑ ‑a ni dɔɔ: «'E 'nɛ ‑ya ‑yrɛ ma!» ");
INSERT INTO moa_vpl VALUES ("JN4_52","073_4_52","JHN","4","52","52","'Bhɛ ꞊nɔɔ bhe, 'ke ‑yoo ‑lrɔkpale dɔɔ ‑a 'flɛ 'yi 'pɔɔnna‑ 'waati 'ɛ ‑dela ba. 'Bhɛɛ‑ ‑wa ꞊pia ‑a ni dɔɔ 'bhɛ ‑kla ‑yretɛbhɛ bhlɔ bii 'waati 'ɛ ba. 'Bhɛɛ‑ 'waati 'ɛ ba, ‑a 'flɛ 'yi 'la ga 'ɛ ‑gwa ‑a ma. ");
INSERT INTO moa_vpl VALUES ("JN4_53","073_4_53","JHN","4","53","53","'Bhɛ klɛle 'tɛ, 'ke 'yee‑ ‑nɛ dɛ 'ɛ ‑ya 'yaangole dɔɔ Zesu 'a ꞊pia ‑a ni 'bhɛɛ‑ 'waati 'ɛ ba 'kaa: «'E 'nɛ ‑ya ‑yrɛ ma.» ‑Ayile 'yee‑ ‑nɛ dɛ 'ɛ 'pegee ‑yaa' 'fa ꞊la mu 'ɛ ‑o 'kpɛn ‑o ‑kpaa Zesu 'yi. ");
INSERT INTO moa_vpl VALUES ("JN4_54","073_4_54","JHN","4","54","54","'Bhɛ ‑nɛ 'ɛ 'bheeza‑ 'ɛ, 'bhɛ ‑le ꞊kla Zesu a 'sɔle‑ maza ‑tɔɔmasie ‑glɔɔn plɛ mi klɛle 'le; ‑a 'san 'kee‑ go Zude 'klɛɛn 'ɛ 'yi, 'bhɛɛ‑ 'kee‑ nu Galile 'klɛɛn 'ɛ 'yi. ");
INSERT INTO moa_vpl VALUES ("JN5_1","073_5_1","JHN","5","1","1","'Bhɛ blaan 'waati sa 'kanle‑, Zuufu mu a 'seri 'fɛti do ‑yaa, 'bhɛɛ‑ Zesu ‑ja Zeruzalɛmu 'bhɛ 'fɛti 'ɛ ta. ");
INSERT INTO moa_vpl VALUES ("JN5_2","073_5_2","JHN","5","2","2","‑Draa 'nɛ do ‑yaa 'yee‑ Zeruzalɛmu ‑wa 'ɛ 'kpee, 'bhɛɛ‑ ‑o ‑yaa 'bhɛ sii Zuufu wli 'ɛ 'yi Bɛtizata. 'Bhɛ ‑draa 'nɛ 'ɛ yaa‑ 'fɛgwlɛ‑ 'la 'mliŋgole ‑yaa Zeruzalɛmu zi 'bhɛ 'wlayrɛ‑ 'la ‑din ‑o ‑yaa 'bhɛ sii ‹‑Bhlaa mu wlayrɛ›. 'Bhɛɛ‑ 'kpaanɛ 'soo dɔle ‑yaa 'yee‑ ‑draa 'ɛ ‑din. ");
INSERT INTO moa_vpl VALUES ("JN5_3","073_5_3","JHN","5","3","3","Gadɛ mu ‑bebe 'yilale ‑yaa 'bhɛ 'kpaanɛ mu 'ɛ ꞊la: 'e pe ‑yrɛ 'wi mu oo, ‑flugba mu oo, 'bhɛ 'pegee mɛɛ gaan 'siɛle‑ 'mu 'kpɛn. ‑O 'kpɛn 'yaa‑ ‑yi 'ɛ 'bhɛɛ‑ bɛɛnle 'ɛ magbɛn 'zi. ");
INSERT INTO moa_vpl VALUES ("JN5_4","073_5_4","JHN","5","4","4","‑Amasrɔyi ‑Waanbhaa' a ‑mlɛkɛ' do ‑yaa zinaa' 'yee‑ ‑draa 'ɛ ba 'waati 'ke ba, 'bhɛɛ‑ ‑e ‑yaa bɛɛn. 'Kee‑ ‑yaa ‑yi 'ɛ bɛɛn 'waati 'la ba, 'bhɛɛ‑ 'ke gadɛ mi 'oo gadɛ mi 'la 'yaa‑ bɔ 'a ba 'elwale gadɛ mu ‑vin mu 'ɛ 'lɛɛ, 'bhɛ gadɛ mi 'ɛ 'yaa‑ bhee. ");
INSERT INTO moa_vpl VALUES ("JN5_5","073_5_5","JHN","5","5","5","'Bhɛɛ‑ 'duŋ‑, gadɛ mi do ‑yaa ye, 'bhɛ lɛɛ mia do bhɛ vu ta 'srwaa‑ 'ke ga ‑o 'bhɛ ma. ");
INSERT INTO moa_vpl VALUES ("JN5_6","073_5_6","JHN","5","6","6","'Bhɛ 'yi, Zesu 'yee‑ gadɛ mi 'ɛ yilale yele, 'bhɛɛ‑ ‑ya 'yaangole 'bhii‑ ‑yaa' ga 'ɛ ꞊mwa gban ‑a ma, 'ke ‑ya ‑lrɔkpale dɔɔ: «'Yoo‑ ‑a zi 'bhii‑ 'e 'bhee ɛɛ?» ");
INSERT INTO moa_vpl VALUES ("JN5_7","073_5_7","JHN","5","7","7","'Bhɛ klɛle 'tɛ, 'ke 'yee‑ gadɛ mi 'ɛ ‑ya zikpale Zesu ni dɔɔ: «Mɛɛzan, mɛɛ 'kedo‑ 'kpɔ 'laa ‑o 'ŋ 'kɔɔ, 'ke 'bhɛ 'ŋ bɔ ‑yi 'ɛ ba 'ke ‑wa bɛɛnle ‑saan 'waati 'la ba. 'Bhɛɛ‑ 'ke 'ŋ 'yoo‑ ge 'zi bɔlɛ ‑a ba 'waati 'la ba, mɛɛ ‑bhɛɛke' do ge bɔlɛ a ba 'mi 'lɛɛ.» ");
INSERT INTO moa_vpl VALUES ("JN5_8","073_5_8","JHN","5","8","8","'Bhɛɛ‑ Zesu pe ‑a ni 'tɛ dɔɔ: «'E 'wlɛn‑, 'bhɛɛ‑ 'e 'yila‑ ‑saa 'ɛ 'si, 'bhɛɛ‑ 'taawo.» ");
INSERT INTO moa_vpl VALUES ("JN5_9","073_5_9","JHN","5","9","9","'Bhɛ yrɛ do 'ɛ ꞊nɔɔ bhe, 'ke 'yee‑ mɛɛ 'ɛ 'bheele, 'ke ‑ya yila‑ ‑saa 'ɛ 'sile, 'bhɛɛ‑ 'kee‑ 'taawole. 'Duŋ‑ 'bhɛ ꞊kla Zuufu mu a *‑yitrɛ' yi 'ɛ 'bhɛɛ‑ ma. ");
INSERT INTO moa_vpl VALUES ("JN5_10","073_5_10","JHN","5","10","10","'Bhɛɛ‑ 'ke Zuufu ‑kuŋlii mu 'ɛ ‑wa pele‑ 'yee‑ mɛɛ 'ɛ ni dɔɔ: «‑Yitrɛ' yi ‑le ‑zɔn 'dɛ! 'Bhɛɛ‑ ‑kɔɔa' 'toŋ 'ɛ ta, 'bhɛ 'seŋ 'laa ‑o 'e ni 'kee 'taawo‑ 'e 'yila‑ ‑saa 'ɛ 'le 'e 'kɔɔ.» ");
INSERT INTO moa_vpl VALUES ("JN5_11","073_5_11","JHN","5","11","11","'Bhɛ 'yi 'tɛ, 'ke 'yee‑ mɛɛ 'ɛ ‑ya lɛkunle ‑o ni dɔɔ: «Mɛɛ 'la zan 'ŋ 'bheela‑ 'bhɛla‑ 'a ꞊pia 'ŋ ni dɔɔ: ‹'E 'yila‑ ‑saa 'ɛ 'si, 'bhɛɛ‑ 'e 'taawo›.» ");
INSERT INTO moa_vpl VALUES ("JN5_12","073_5_12","JHN","5","12","12","'Bhɛ klɛle 'tɛ, 'ke ‑wa ‑lrɔkpale 'kaadɔɔ‑: «Mɛɛ 'ɛ ‑de 'gbu ‑le 'a ꞊pia 'e ni dɔɔ: ‹'E 'yila‑ ‑saa 'ɛ 'si, 'bhɛɛ‑ 'e 'taawo‑ ɛɛ?›» ");
INSERT INTO moa_vpl VALUES ("JN5_13","073_5_13","JHN","5","13","13","'Duŋ‑ 'yee‑ mɛɛ 'la 'bheela‑, yaa ‑yaa ‑a ‑bhee mi 'ɛ dɔ. ‑Amasrɔyi Zesu 'truŋwoa꞊ ‑zamaa' 'la 'yaa‑ 'bhɛ yrɛ 'ɛ ꞊nɔɔ 'mu 'ɛ 'pleŋ‑. ");
INSERT INTO moa_vpl VALUES ("JN5_14","073_5_14","JHN","5","14","14","'Bhɛ blaan boola 'ɛ zi, 'ke Zesu 'lɛpale 'kɛle‑ ‑Waanbhaa' Gba 'Fɛ ‑Gbɛnɛ 'ɛ ꞊la, 'bhɛɛ‑ 'ke ‑ya pele‑ ‑a ni dɔɔ: «'E 'trɔnbadɔ doo, 'e 'bheelawoa ‑zɔn bhe, 'yaa ‑za 'yɔɔ‑ klɛlɛ 'ezin‑, 'kooko‑ ‑za 'bhɛɛke do laa nu 'tɛnlɛ‑ 'e ma 'ke 'bhɛ 'yɔɔ‑ ‑yiya' 'kɛlɛɛ‑ ni.» ");
INSERT INTO moa_vpl VALUES ("JN5_15","073_5_15","JHN","5","15","15","'Bhɛ 'yi 'tɛ, 'ke 'yee‑ mɛɛ 'ɛ ‑e gele‑ ‑a pelɛ Zuufu ‑kuŋlii mu 'ɛ ni dɔɔ mɛɛ 'la zan 'a 'bheela‑ ‑o 'bhɛ sii Zesu. ");
INSERT INTO moa_vpl VALUES ("JN5_16","073_5_16","JHN","5","16","16","'Bhɛla‑ ‑yile, ‑a 'san 'bhɛ yi 'ɛ ma, Zuufu ‑kuŋlii mu 'ɛ ‑o Zesu 'yrɛbatɛdɔle ‑saan, ‑amasrɔyi ‑e 'bhɛ mɛɛ 'ɛ 'bheela‑ ‑waa' ‑yitrɛ' yi do ‑la ma. ");
INSERT INTO moa_vpl VALUES ("JN5_17","073_5_17","JHN","5","17","17","'Duŋ‑ Zesu pe ‑o ni dɔɔ: «'Ŋ Dɛ ‑Waanbhaa' ‑o yewo 'zi 'taŋii 'kee‑ nu 'tɛnlɛ‑ ‑zɔn ma, 'bhɛla‑ ‑yile 'mi ‑o yewo 'zi 'ezin‑.» ");
INSERT INTO moa_vpl VALUES ("JN5_18","073_5_18","JHN","5","18","18","'Bhɛ ‑jan 'ɛ ‑zayi', Zuufu ‑kuŋlii mu 'ɛ 'yaa‑ dɛyrɛ baan' ‑glin 'zi, ‑amasrɔyi ‑e ‑yitrɛ' yi 'ɛ 'yisiɛla, 'bhɛɛ‑ ‑e ‑Waanbhaa' 'sii zii' ‑a Dɛ kpataakpa 'le. 'Bhɛɛ‑ 'ezin‑, ‑ya 'gbu 'kpa zii' ‑Waanbhaa' ma, 'ke ‑ya klɛ 'bhii‑ ‑o 'pegee ‑Waanbhaa' gblaanya 'ɛ sɔ 'eke‑ ni. ");
INSERT INTO moa_vpl VALUES ("JN5_19","073_5_19","JHN","5","19","19","'Bhɛ klɛle 'tɛ, 'ke Zesu ‑jan 'ɛ 'sile‑, 'bhɛɛ‑ 'ke ‑ya pele‑ ‑o ni dɔɔ: «'Mi pe 'ka ni 'ŋ 'sɔwɛɛ‑ ma dɔɔ: ‑Nɛ 'ɛ yaa sɔ ‑za 'kedo‑ 'kpɔ klɛle‑ ‑a 'gbu 'kɔɔ. 'Ke ‑ya Dɛ ꞊ya ‑za 'la klɛyrɛ nɔɔ‑, ‑e 'bhɛɛ‑ klɛ. ‑A Dɛ ‑za 'oo ‑za 'la klɛ, ‑e 'bhɛɛ‑ klɛ 'ezin‑. ");
INSERT INTO moa_vpl VALUES ("JN5_20","073_5_20","JHN","5","20","20","‑Amasrɔyi, ‑Nɛ 'ɛ ‑za sɔ ‑a Dɛ ni, 'bhɛla‑ ‑zayile, ‑a Dɛ ‑o ‑za 'oo ‑za 'la klɛ 'zi, 'bhɛ 'gbu 'bhɛ zrɔn ‑a ni. 'Bhɛɛ‑ 'duŋ‑, ‑e nu ‑za 'bhɛɛke mu zrɔnlɛ ‑a ni 'ke 'mu gblaan ‑yiya' 'kɛ mu 'lɛɛ‑ ni, 'bhɛɛ‑ 'mu nu 'ka 'kpeelɛnilɛ 'ka ma. ");
INSERT INTO moa_vpl VALUES ("JN5_21","073_5_21","JHN","5","21","21","‑Amasrɔyi, ‑a Dɛ gbaa mu bwe gale ba gɔnɛ‑ 'la gbɛɛn‑, 'bhɛɛ‑ ‑e bole ‑yrɛ ma ‑si 'na gbɛ drɛɛwo ‑o ni, 'bhɛ klɛgbɛya do 'ɛ gbɛɛn‑, 'ke bole ‑yrɛ ‑si 'nale‑ ‑swa ‑Nɛ 'ɛ ni mɛɛ 'la zan ni, ‑e 'bhɛɛ‑ na 'ezin‑. ");
INSERT INTO moa_vpl VALUES ("JN5_22","073_5_22","JHN","5","22","22","‑Nɛ Dɛ 'ɛ yaa mɛɛ 'kedo‑ 'kpɔ 'kitikan, 'duŋ‑ ‑e bhaaplɛŋ mu 'kpɛn 'kitikanle 'seŋ 'naa‑ ‑a Gbe 'ɛ ni, ");
INSERT INTO moa_vpl VALUES ("JN5_23","073_5_23","JHN","5","23","23","'kooko‑ mɔkpɛn' ‑Nɛ 'ɛ 'lɛdɔ‑ ‑a ma 'bhii‑ ‑wa Dɛ 'ɛ ‑lɛdɔ' a ma gɔnɛ‑ 'la gbɛɛn‑. 'Ke mɛɛ 'la zan laa ‑Nɛ 'ɛ 'lɛdɔ‑ ‑a ma, 'bhɛ zan laa ‑a Dɛ 'la 'bhɛ 'a winbwa‑ 'bhɛ 'lɛdɔ‑ a ma 'ezin‑. ");
INSERT INTO moa_vpl VALUES ("JN5_24","073_5_24","JHN","5","24","24","«'Mi pe 'ka ni 'ŋ 'sɔwɛɛ‑ 'gbu 'ɛ ma dɔɔ: 'ke mɛɛ 'la zan 'e 'trɔnkpaa‑ 'ŋ 'wojan‑ mu 'ɛ ꞊la, 'bhɛɛ‑ 'ke ‑ya ‑kpaa mɛɛ 'la zan 'ŋ 'winbwa‑ 'bhɛ 'yi, bole ‑yrɛ ma ‑si 'la ‑daŋ' 'laa ‑o 'bhɛ ma ‑o 'bhɛ zan 'kɔɔ. Waa nu 'bhɛ zan 'kitikanlɛ, 'duŋ‑ 'bhɛ zan ‑gwa ga a pɛ zi 'ɛ ta, ‑e ꞊wlaa ‑daŋ' 'laa ‑o bole ‑yrɛ ma ‑si 'la ma 'bhɛ 'yi gban. ");
INSERT INTO moa_vpl VALUES ("JN5_25","073_5_25","JHN","5","25","25","'Mi pe 'ka ni 'ŋ 'sɔwɛɛ‑ ma dɔɔ: Gbaa mu nu *‑Waanbhaa' Gbe 'ɛ 'weli‑ malɛ 'waati 'la ba 'bhɛ 'waati 'ɛ 'bhɛ ‑o zan bhɔlɛ, 'bhɛɛ‑ 'duŋ‑ 'bhɛ bhla 'ɛ ꞊bhwa gban ‑zɔn. 'Ke mɛɛ 'la zan mu 'a ‑weli' 'ɛ ꞊maa, 'bhɛɛ‑ ‑e ‑jan 'kɛla ꞊woa 'ke ‑o ꞊dwa 'bhɛ ꞊la, 'mu nu bole ‑yrɛ ma ‑si 'ɛ 'srɔɔwolɛ. ");
INSERT INTO moa_vpl VALUES ("JN5_26","073_5_26","JHN","5","26","26","‑Amasrɔyi, 'bhɛ 'seŋ ‑o ‑nɛ Dɛ 'ɛ ni 'kee‑ bole ‑yrɛ ma ‑si na mɛɛ mu ni gɔnɛ‑ 'la gbɛɛn‑, ‑e 'bhɛɛ‑ yɛkɛ‑ 'seŋ 'naa‑ ‑a Gbe 'ɛ ni 'ke 'bhɛ bole ‑yrɛ ma ‑si na bhaaplɛŋ mu ni 'bhɛɛ‑ gbɛɛn‑. ");
INSERT INTO moa_vpl VALUES ("JN5_27","073_5_27","JHN","5","27","27","'Bhɛɛ‑ 'ezin‑, 'ŋ Dɛ bhaaplɛŋ mu 'kitikan 'seŋ 'naa‑ 'mi ni, ‑amasrɔyi 'mi ‑le 'ke Bhaaplɛŋ Gbe 'ɛ 'le. ");
INSERT INTO moa_vpl VALUES ("JN5_28","073_5_28","JHN","5","28","28","'Ŋ 'yoo‑ zan ‑jan 'la 'wolɛ‑ 'ka ni ‑gɛ bhe 'bhɛ 'laa klɛlɛ 'ka ma 'kpeelɛni maza 'le, ‑amasrɔyi 'waati do ‑o zan bhɔlɛ, mɛɛ 'la zan mu 'kpɛn ‑gaa gban, 'mu nu Bhaaplɛŋ Gbe 'ɛ 'weli‑ malɛ. ");
INSERT INTO moa_vpl VALUES ("JN5_29","073_5_29","JHN","5","29","29","'Ke 'bhɛ ꞊kla, 'woo‑ gbaa mu 'ɛ ‑o nu 'pwɛlɛ‑ bu mu 'ɛ 'yi. 'Bhɛ 'yi 'tɛ, ‑o 'kɛ mu 'la ‑za 'wlan ꞊kla 'elwale ‑sɔ, 'mu nu ‑bwelɛ gale ba, 'bhɛɛ‑ 'mu nu bo gbɛ drɛɛwolɛ 'mu yrɛ ma ‑Waanbhaa' ba. 'Duŋ‑ ‑o 'kɛ mu 'la ‑za 'yɔɔ‑ mu ꞊kla 'elwale ‑sɔ, 'mu nu bwelɛ gale ba, 'bhɛɛ‑ ‑o 'mu 'kitikan.» ");
INSERT INTO moa_vpl VALUES ("JN5_30","073_5_30","JHN","5","30","30","Zesu pe ‑o ni 'ezin‑ dɔɔ: «'Naa sɔ ‑za 'kedo‑ 'kpɔ klɛle‑ 'ŋ 'gbu ma. ‑Waanbhaa' 'kɛla ꞊woa 'ŋ ni, 'ŋ mɛɛ mu 'kitikan 'bhɛɛ‑ ta. 'An 'yaango‑ 'bhii‑ 'ŋ mɛɛ mu 'kitikan wlan ma, ‑amasrɔyi, 'naa ‑o 'ŋ 'gbu zru maza klɛ yrɛ ‑glin 'zi, 'duŋ‑ mɛɛ 'la zan 'ŋ 'winbwa‑ 'ŋ 'bhɛɛ‑ zan zru maza klɛ 'zi.» ");
INSERT INTO moa_vpl VALUES ("JN5_31","073_5_31","JHN","5","31","31","«'Ke 'ŋ 'gbu ‑o 'ŋ 'gbu 'srɛya‑ klɛ 'zi, 'ŋ 'gbu a pɛ 'srɛya‑ 'ɛ 'bhɛ 'laa ‑o 'ke wlan 'le. ");
INSERT INTO moa_vpl VALUES ("JN5_32","073_5_32","JHN","5","32","32","'Duŋ‑ mɛɛ ‑bhɛɛke' do ‑le 'mi 'srɛya‑ ‑kla, 'bhɛɛ‑ 'an 'yaango‑ dɔɔ ‑e 'mi 'srɛya‑ 'la ꞊kla, 'bhɛ ‑o 'ke wlan 'le. ");
INSERT INTO moa_vpl VALUES ("JN5_33","073_5_33","JHN","5","33","33","'Ka mɛɛ mu winbwa‑ Mɛɛ Wiiŋfɛ' Mi Zaan ba, 'bhɛɛ‑ ‑e 'mi 'srɛya‑ 'la ꞊kla, wlan ‑le 'bhɛ 'le. ");
INSERT INTO moa_vpl VALUES ("JN5_34","073_5_34","JHN","5","34","34","'Mi maza laa ‑o bhaaplɛŋ do ma 'ke 'bhɛ zan 'mi 'srɛya‑ klɛ; 'duŋ‑ 'ŋ 'bhɛ 'pe zii' 'bhɛ 'pe gbɛya 'ɛ 'yi bhe, 'kooko‑ 'ka sɔ gole‑ ‑za 'yi. ");
INSERT INTO moa_vpl VALUES ("JN5_35","073_5_35","JHN","5","35","35","Zaan ‑yaa 'bhii‑ ‑laŋbha do 'la ‑wa ꞊bhia, 'bhɛɛ‑ ‑yoo mɛɛ mu 'ɛ takan' zii'. 'Bhɛɛ‑ 'ka ‑dwa ‑a ‑la 'ke 'ka 'ka zrukpalaa 'waati sa ba ‑yaa' 'tɛbhile 'ɛ ba. ");
INSERT INTO moa_vpl VALUES ("JN5_36","073_5_36","JHN","5","36","36","'Duŋ‑ pɛ 'la 'bhɛ ‑o 'mi 'srɛya‑ klɛ 'zi, 'bhɛ gblaan ‑yiya' 'ke 'bhɛ 'kan Zaan 'mi 'srɛya‑ 'la ꞊kla 'bhɛ ta. ‑Amasrɔyi, 'ŋ Dɛ ‑Waanbhaa' ye mu 'la gbɛkpaa‑ 'mi 'kɔɔ, 'bhɛɛ‑ 'ke 'mi ‑o 'mu 'wo zii' bhe, 'bhɛ klɛza mu 'ɛ 'mu ‑le 'a zrɔn 'ka ni 'bhii‑ 'ŋ Dɛ ‑Waanbhaa' ‑le 'mi 'winbwa‑. ");
INSERT INTO moa_vpl VALUES ("JN5_37","073_5_37","JHN","5","37","37","'Bhɛɛ‑ 'ŋ Dɛ ‑Waanbhaa' 'la 'mi 'winbwa‑ 'bhɛ 'gbu ‑le 'mi 'srɛ 'le. 'Bhɛɛ‑ 'duŋ‑ 'ka mu 'laa ‑a ‑weli' malɛ ‑lido', 'bhɛ 'pegee 'ka 'laa 'a wlɛyi' 'yelɛ‑ ‑lido'. ");
INSERT INTO moa_vpl VALUES ("JN5_38","073_5_38","JHN","5","38","38","'Ka 'laa ‑yaa' ‑jan mu 'ɛ 'kpa 'ka 'kpee, ‑amasrɔyi 'ka 'laa 'ka kpa ‑e mɛɛ 'la zan winbwa‑ 'bhɛ zan 'ɛ 'yi. ");
INSERT INTO moa_vpl VALUES ("JN5_39","073_5_39","JHN","5","39","39","'Ka ‑Waanbhaa' a 'Sɛwɛ mu 'ɛ 'yi jan mu 'ɛ daan 'elrele 'gbu, ‑amasrɔyi 'ka 'kpee ma, 'ka nu bole ‑yrɛ ma ‑si 'la ‑daŋ' 'laa ‑o 'bhɛ ma 'bhɛ 'srɔɔwolɛ 'wola‑ ma: 'bhɛɛ‑ 'duŋ‑, 'woo‑ 'sɛwɛ mu 'ɛ 'yi jan mu do 'kpɔ 'ɛ 'wole‑ 'mi 'srɛya‑ klɛ. ");
INSERT INTO moa_vpl VALUES ("JN5_40","073_5_40","JHN","5","40","40","'Bhɛɛ‑ 'ka 'laa ‑a zi 'ka nu 'mi ba, 'kooko‑ 'bole ‑yrɛ ma ‑si 'la ‑daŋ' 'laa ‑o 'bhɛ ma 'ka 'bhɛ 'srɔɔwo‑.» ");
INSERT INTO moa_vpl VALUES ("JN5_41","073_5_41","JHN","5","41","41","«'Naa ‑o 'ŋ 'gbu 'tɔbhɔleya ‑glin 'zi bhaaplɛŋ mu 'kɔɔ. ");
INSERT INTO moa_vpl VALUES ("JN5_42","073_5_42","JHN","5","42","42","'Bhɛɛ‑ 'duŋ‑, 'mi 'gbu 'a 'yaandɔ‑ 'bhii‑ ‑Waanbhaa' a 'sɔniya 'ɛ yaa ‑o 'ka zru 'ɛ 'yi. ");
INSERT INTO moa_vpl VALUES ("JN5_43","073_5_43","JHN","5","43","43","'Mi ꞊nwa 'ŋ Dɛ 'tɔ 'ɛ 'bhɛɛ‑ 'yi, 'bhɛɛ‑ 'ka laa ‑o dɔ 'zi ‑a ‑la 'ke 'ka 'mi kun 'elrele. 'Duŋ‑, 'ke mɛɛ ‑bhɛɛke' do ꞊nwa 'bhɛ 'gbu 'tɔ 'yi, 'ka 'bhɛ zan 'ɛ kun 'elrele! ");
INSERT INTO moa_vpl VALUES ("JN5_44","073_5_44","JHN","5","44","44","'Bhɛɛ‑ 'ka sɔ 'ka 'kpale 'ŋ 'yi 'nale‑ ‑a ma ɛɛ? ‑Amasrɔyi 'ke 'ka 'eke‑ 'tɔbhɔ‑, 'bhɛ ‑le sɔ 'ka ni, 'bhɛɛ‑ 'tɔbhɔleya 'la da ‑Waanbhaa' do ‑kplɛn ba, 'ka mu laa 'bhɛ ziglin. ");
INSERT INTO moa_vpl VALUES ("JN5_45","073_5_45","JHN","5","45","45","Yaa klɛlɛ 'ka ni 'bhii‑ 'mi ‑le nu ‑lalɛ' 'ka ta 'ŋ Dɛ ‑Waanbhaa' ‑yrɛ ꞊la. 'Ka 'ka 'yrikpaa‑ *Moizi 'la ta, 'bhɛ ‑le nu ‑lalɛ' 'ka ta. ");
INSERT INTO moa_vpl VALUES ("JN5_46","073_5_46","JHN","5","46","46","'Ke 'ka 'ka 'kpa bi Moizi 'yi kpataakpa, 'ka 'yaa‑ nu 'ka 'kpalɛ‑ 'mi 'yi 'ezin‑, ‑amasrɔyi 'yee‑ Moizi 'gbu 'mi a ‑janwoa ‑yaa' 'sɛwɛ 'ɛ 'yi. ");
INSERT INTO moa_vpl VALUES ("JN5_47","073_5_47","JHN","5","47","47","'Duŋ‑ 'ke 'ka 'laa 'ka 'kpalɛ‑ ‑e ‑za mu 'la yɔɔndia‑ 'mu 'yi, 'ka sɔ 'ka 'kpale 'mi 'wojan‑ mu 'ɛ 'yi 'nale‑ ‑a ma ɛɛ?» ");
INSERT INTO moa_vpl VALUES ("JN6_1","073_6_1","JHN","6","1","1","'Bhɛ blaan, 'ke Zesu 'pegee ‑yaa' ‑klaŋlanɛ mu 'ɛ ‑o 'kanle Galile ‑draa 'yrɛ gbɛ do 'ɛ ta. ‑O ‑yaa 'bhɛ ‑draa 'ɛ sii 'ezin‑ Tiberiadi ‑draa. ");
INSERT INTO moa_vpl VALUES ("JN6_2","073_6_2","JHN","6","2","2","'Bhɛ ya 'ɛ 'yi, 'ke ‑zamaa' ‑gbɛnɛ do dɔle‑ ‑a zi 'bhɛ yrɛ 'ɛ ꞊nɔɔ 'ezin‑; ‑amasrɔyi ‑o ‑yaa Zesu 'ye zii' 'sɔle‑ maza mu klɛyrɛ nɔɔ‑ 'kee‑ gadɛ mu 'ɛ bhee. ");
INSERT INTO moa_vpl VALUES ("JN6_3","073_6_3","JHN","6","3","3","Zesu 'pegee ‑yaa' ‑klaŋlanɛ mu 'ɛ ꞊saan gɔɔn do wiiŋ‑, 'bhɛɛ‑ 'ke ‑o yaale' 'bhɛ ꞊nɔɔ ye. ");
INSERT INTO moa_vpl VALUES ("JN6_4","073_6_4","JHN","6","4","4","'Duŋ‑ Zuufu mu a Paki 'fɛti 'ɛ ꞊bhwa gban 'e ‑din. ");
INSERT INTO moa_vpl VALUES ("JN6_5","073_6_5","JHN","6","5","5","Zesu a ŋgblo ‑lawlɛnle, 'ke ‑a ‑yrɛkpale ‑zamaa' 'srɛ do ma 'ke 'bhɛ mu ‑o zan ‑a ba ‑yrɛ ta; ‑ayile 'kee‑ Filipu 'lrɔkpale dɔɔ: «‑Kɔɔ' nu 'sɔlɛ‑ pɛle ‑lɔpɛ' ‑srɔɔwole 'naa ‑a ma ɛɛ, 'bhɛɛ‑ ‑kɔɔ 'a na mɛɛ mu 'lɛɛ‑ ni ɛɛ?» ");
INSERT INTO moa_vpl VALUES ("JN6_6","073_6_6","JHN","6","6","6","‑E Filipu 'lrɔkpaa‑ 'bhɛ gbɛɛn‑ bhe, ‑amasrɔyi, ‑e ‑yaa zi 'bhii‑ ‑e 'bhɛ 'liijan‑ ma; 'kebhlaale, ‑e ‑yaa zan ‑za 'la klɛlɛ, ‑a 'gbu 'yaa‑ 'bhɛ dɔ. ");
INSERT INTO moa_vpl VALUES ("JN6_7","073_6_7","JHN","6","7","7","'Bhɛ klɛle 'tɛ, 'ke Filipu 'a zikpale 'a ni dɔɔ: «'Ali‑ 'kee yetanɛ a mlɛ 'srwaplɛ‑ ta ‑sra 'ɛ 'kpɛn ꞊wlaa pɛbhle 'yi, 'bhɛɛ‑ 'kooko‑ ‑o 'kpɛn do do 'yee‑ pɛbhle 'ɛ sanɛ‑ sanɛ‑ bhle, 'bhɛ 'laa nu ‑o mabhɔlɛ.» ");
INSERT INTO moa_vpl VALUES ("JN6_8","073_6_8","JHN","6","8","8","'Bhɛ ꞊nɔɔ bhe, 'ke ‑yaa' ‑klaŋlanɛ 'la ‑o ‑yaa 'bhɛ sii Andre, 'bhɛɛ 'ke 'bhɛ 'yaa‑ Simɔ Piɛri 'nwagwlɛn‑ 'le bhe, 'bhɛ pe ‑a ni dɔɔ: ");
INSERT INTO moa_vpl VALUES ("JN6_9","073_6_9","JHN","6","9","9","«'bluu 'yri 'soo 'pegee kaa plɛ ‑o ‑nɛ ‑zwannɛ do 'kɔɔ ‑gɛ. 'Bhɛɛ‑ 'bhɛ mu sɔ ‑mɛla ‑yanwole ‑zamaa' 'srɛ 'lɛɛ‑ ma ɛɛ?» ");
INSERT INTO moa_vpl VALUES ("JN6_10","073_6_10","JHN","6","10","10","Zesu pe ‑o ni tɛ dɔɔ: «‑Kaa pe mɛɛ mu 'ɛ ni 'kaa ‑o yala‑». ‑Bɔn ‑dɔɔ ‑bebe 'yaa‑ 'bhɛ yrɛ 'ɛ ꞊nɔɔ. 'Bhɛɛ‑ ‑o ‑yalaa' 'tɛ; 'bhɛɛ‑ ‑o ba 'gwlaan‑ mu 'ɛ 'yaa‑ bhɔ 'gwlaan‑ 'waa 'soo ‑din (5.000). ");
INSERT INTO moa_vpl VALUES ("JN6_11","073_6_11","JHN","6","11","11","'Bhɛ 'yi 'tɛ, 'ke Zesu 'bluu 'soo 'ɛ 'sile‑, 'kee‑ ‑Waanbhaa' 'pubɔle ‑o ma, 'bhɛɛ‑ 'ke ‑ya pele‑ dɔɔ ‑woo ‑yiciɛn' mɛɛ mu 'la 'yaale‑ ‑yaa 'trɛ ma 'mu ma. 'Bhɛɛ‑ ‑e kaa mu 'ɛ 'sile‑, 'ke ‑yoo nale‑ ‑o ni 'bhɛ klɛgbɛya do 'ɛ 'yi 'ezin‑. ‑O maza ‑yaa pɛle yɛkɛ‑ 'la ma, ‑o 'kpɛn 'bhɛɛ‑ 'srɔɔwoa‑. ");
INSERT INTO moa_vpl VALUES ("JN6_12","073_6_12","JHN","6","12","12","‑O kpɛdɔle ‑yaan 'waati 'la ba, 'ke Zesu 'a 'pele ‑yaa' ‑klaŋlanɛ mu 'ɛ ni dɔɔ: «‑Ka 'bluu kpu mu 'la ꞊bwa 'mu 'wloo‑, 'kooko‑ waa siɛ.» ");
INSERT INTO moa_vpl VALUES ("JN6_13","073_6_13","JHN","6","13","13","'Bhɛ klɛle 'tɛ, mɛɛ mu 'ɛ 'yanle‑ pɛbhlelele, 'bluu kpu mu 'la ꞊bwa 'woo‑ 'bluu 'yri 'soo 'ɛ blaan'; ‑o 'mu 'wloola‑, 'bhɛɛ‑ 'mu ꞊kla ciɛ ‑nɛ 'yan vu ta plɛ. ");
INSERT INTO moa_vpl VALUES ("JN6_14","073_6_14","JHN","6","14","14","'Bhɛ ya 'ɛ 'yi, mɛɛ mu 'ɛ ‑wa yele 'bhii‑ Zesu 'bhɛ 'sɔle‑ maza 'ɛ ꞊kla, 'ke ‑wa pele‑ dɔɔ: «Mɛɛ 'lɛɛ‑ 'yele‑ 'ke ‑Waanbhaa' *‑lɛla' janwo mi 'la 'yaa‑ nu nulɛ 'drunyan 'yi 'bhɛ 'le kpataakpa.» ");
INSERT INTO moa_vpl VALUES ("JN6_15","073_6_15","JHN","6","15","15","Zesu 'a 'yaangole 'bhii‑ ‑o ‑yaa nu ‑a 'kunlɛ‑ kpaŋma, 'bhɛɛ‑ ‑wa klɛ 'ke ‑bhleŋgbe do 'le, 'kee‑ gole‑ ‑o pleŋ‑ swɛŋ, 'bhɛɛ‑ 'ke ‑a do ‑kplɛn ge gbɛ drɛɛwole vlɛ gɔɔn 'ɛ 'wiiŋ‑. ");
INSERT INTO moa_vpl VALUES ("JN6_16","073_6_16","JHN","6","16","16","'Bhɛ yroma do 'ɛ zi, 'ke yaa ‑klaŋlanɛ mu 'ɛ ‑o gele‑ ‑draa 'ɛ 'lɛ ma. ");
INSERT INTO moa_vpl VALUES ("JN6_17","073_6_17","JHN","6","17","17","'Bhɛɛ‑ 'ke ‑o 'sanle ‑yitakoŋ do 'yi, 'bhɛɛ‑ 'ke ‑o ‑draa 'ɛ takanle 'sanle 'ke ‑o ge Kapɛnɔmu ‑wa 'ɛ ba yrɛ ta. ‑Fitrii' ꞊kpaa gban, 'ke Zesu 'laa 'tɛn ‑o ma. ");
INSERT INTO moa_vpl VALUES ("JN6_18","073_6_18","JHN","6","18","18","'Duŋ‑ ‑draa 'yi 'ɛ 'pɔɔ mu 'ɛ 'yaa‑ bɛɛn 'zi, ‑amasrɔyi ‑ploo ‑gbɛnɛ do ‑yaa 'kan zii'. ");
INSERT INTO moa_vpl VALUES ("JN6_19","073_6_19","JHN","6","19","19","‑Woo pleŋgole ‑draa 'ɛ 'lɛ ma kilo 'srwado‑ yɛkɛ‑ 'yi 'waati 'la ba, 'ke ‑o ‑yrɛkpale Zesu ma 'ke 'bhɛ ‑o 'taawo zii' ‑yi 'ɛ ta, 'bhɛɛ‑ 'bhɛ 'yaa‑ 'bhɛ mabɛɛn‑ 'zi ‑yitakoŋ 'ɛ ‑din; ‑ayile 'ke ‑gblaan 'klale ‑o ‑yi. ");
INSERT INTO moa_vpl VALUES ("JN6_20","073_6_20","JHN","6","20","20","'Duŋ‑ Zesu pe ‑o ni dɔɔ: «'Mi ‑le 'kɛle‑, 'ka 'laa ‑gblaanlɛ'!» ");
INSERT INTO moa_vpl VALUES ("JN6_21","073_6_21","JHN","6","21","21","'Bhɛ klɛle 'tɛ, ‑o ‑yaa ‑a zi 'bhii‑ Zesu 'san ‑o zi ‑waa' ‑yitakoŋ 'ɛ 'yi. 'Duŋ‑ 'bhɛ yrɛ do 'ɛ ꞊nɔɔ bhe, 'ke ‑yitakoŋ 'ɛ 'bhɔle‑ ‑o ‑yaa ge 'zi yrɛ 'la ꞊nɔɔ 'bhɛ ꞊nɔɔ. ");
INSERT INTO moa_vpl VALUES ("JN6_22","073_6_22","JHN","6","22","22","'Bhɛ yi 'ɛ ta tooklin‑ yi 'le, ‑zamaa' 'lɛdo‑ 'la ꞊bwa ‑draa 'yrɛ gbɛ do 'ɛ ta, ‑wa 'yaangwa‑ dɔɔ ‑yitakoŋ do 'kpɔ ‑le ‑yaa ye, 'bhɛɛ‑ Zesu 'pegee ‑yaa' ‑klaŋlanɛ mu 'ɛ waa gelɛ 'eke‑ zi 'bhɛ ‑yitakoŋ 'ɛ 'yi; 'duŋ‑ ‑yaa' ‑klaŋlanɛ mu 'ɛ do ‑kplɛn ‑le ‑saan 'bhɛ 'yi 'bhɛɛ‑ ‑o ‑ja. ");
INSERT INTO moa_vpl VALUES ("JN6_23","073_6_23","JHN","6","23","23","'Bhɛɛ‑ 'woo‑ mɛɛ mu 'ɛ ‑wa yele 'bhii‑ ‑yitakoŋ 'bhɛɛke mu ‑daa Tiberiadi ‑wa 'ɛ ta, Mɛɛzan ‑Waanbhaa' 'pubwa‑ 'bluu mu 'ɛ ma, 'bhɛɛ‑ ‑woo ꞊bhla yrɛ 'la ꞊nɔɔ, 'bhɛ ‑yitakoŋ mu 'ɛ ꞊nwa 'bhɛ 'yrɛ 'ɛ ‑din. ");
INSERT INTO moa_vpl VALUES ("JN6_24","073_6_24","JHN","6","24","24","'Bhɛɛ‑ ‑zamaa' 'yrɛ 'laa 'kpalawolɛ Zesu 'pegee ‑yaa' ‑klaŋlanɛ mu 'ɛ ma, 'ke ‑o bɔle‑ 'bhɛ ‑yitakoŋ mu 'ɛ 'yi, 'bhɛɛ‑ 'ke ‑o gele‑ Zesu ziglinyrɛ nɔɔ‑ Kapɛnɔmu. ");
INSERT INTO moa_vpl VALUES ("JN6_25","073_6_25","JHN","6","25","25","‑O tɛnlɛ‑ ‑a ma ‑draa 'ɛ 'yrɛ gbɛ do 'ɛ ta, 'ke ‑wa ‑lrɔkpale dɔɔ: «'O Daan mi, 'e ꞊nwa 'waati 'ɛ ‑dela ba ‑gɛ ɛɛ?» ");
INSERT INTO moa_vpl VALUES ("JN6_26","073_6_26","JHN","6","26","26","Zesu 'a 'lɛkwan‑ ‑o ni dɔɔ: «'Mi pe 'ka ni 'ŋ 'sɔwɛɛ‑ ma dɔɔ 'ka 'laa ‑o 'ŋ ziglin‑ 'zi 'ka 'sɔle‑ maza mu 'la ꞊ya 'mu ‑zayi', 'duŋ‑ 'ka ‑o 'ŋ ziglin‑ 'zi win 'la ma 'bhɛ ‑le dɔɔ 'ka 'bluu ꞊bhla, 'bhɛɛ‑ 'ka kpɛdwa‑. ");
INSERT INTO moa_vpl VALUES ("JN6_27","073_6_27","JHN","6","27","27","'Ka 'laa yewolɛ pɛle 'la 'bhɛ ‑o 'ke 'siɛpɛ‑ 'le 'bhɛ 'kaama‑, 'duŋ‑ ‑ka yewo pɛle 'la 'ke 'bhɛ mɔ, 'bhɛɛ‑ 'ke 'bhɛ bole ‑yrɛ ma ‑si na mɛɛ ni 'bhɛɛ 'kaama‑. 'Bhɛ pɛle ‑glɔɔn 'ɛ Bhaaplɛŋ Gbe 'ɛ nu 'bhɛɛ‑ 'nalɛ‑ 'ka ni. ‑Amasrɔyi ‑a Dɛ ‑Waanbhaa' 'bhɛ a ‑glɔɔya' yɔɔn ‑kpalaa' 'yela‑ ta.» ");
INSERT INTO moa_vpl VALUES ("JN6_28","073_6_28","JHN","6","28","28","'Bhɛ 'yi bhe 'tɛ, 'ke ‑o Zesu 'lrɔkpale dɔɔ: «'O ‑mɛ pɛ za ‑la klɛ, 'bhɛɛ‑ 'o ‑Waanbhaa' zru ma ye mu 'ɛ wo ɛɛ?» ");
INSERT INTO moa_vpl VALUES ("JN6_29","073_6_29","JHN","6","29","29","Zesu 'bhɛ 'lɛkwan‑ ‑o ni dɔɔ: «‑Waanbhaa' a zru ma yewole 'ɛ 'bhɛ ‑le 'ke 'ka 'ka 'kpa ‑e mɛɛ 'la zan winbwa‑ 'bhɛ zan 'ɛ 'yi.» ");
INSERT INTO moa_vpl VALUES ("JN6_30","073_6_30","JHN","6","30","30","‑O Zesu 'lrɔkpaa‑ 'ezin‑ dɔɔ: «'E sɔ 'sɔle‑ maza 'gbu 'ɛ ‑de 'gbu ‑la klɛle‑, 'bhɛɛ‑ 'ke 'o 'bhɛ ꞊ya, 'woo kpa 'e 'yi ɛɛ? 'E sɔ ‑mɛ za 'gbu ‑la klɛle‑ ɛɛ? ");
INSERT INTO moa_vpl VALUES ("JN6_31","073_6_31","JHN","6","31","31","'O ‑gbɔɔ mu pɛbhle 'la ‑wa sii mani 'bhɛ꞊bhla ‑kpe 'ɛ ta 'bhii‑ ‑Waanbhaa' a 'Sɛwɛ 'ɛ ‑ya ‑pia gɔnɛ‑ 'la gbɛɛn‑ dɔɔ: ‹‑Yoo ‑gbaa 'bluu 'la ‑daa laflɛ' 'yi 'bhɛɛ‑ ba 'kaa ‑wa bhle.›» ");
INSERT INTO moa_vpl VALUES ("JN6_32","073_6_32","JHN","6","32","32","Zesu pe ‑o ni dɔɔ: «'Mi pe 'ka ni 'ŋ 'sɔwɛɛ‑ ma dɔɔ 'bluu 'la ‑daa laflɛ' 'yi *Moizi 'laa 'bhɛ 'nalɛ‑ 'ka ni. 'Duŋ‑ 'ŋ Dɛ ‑le 'bluu ‑zeze 'gbu 'la da laflɛ' 'yi 'bhɛɛ‑ na 'ka ni. ");
INSERT INTO moa_vpl VALUES ("JN6_33","073_6_33","JHN","6","33","33","‑Amasrɔyi ‑Waanbhaa' 'bluu 'la na bhaaplɛŋ mu ni, 'bhɛ ‑le 'ke mɛɛ 'la zan da laflɛ' 'yi, 'bhɛɛ‑ ‑e ‑si na 'drunyan 'yi mu 'ɛ ni 'bhɛ zan 'ɛ 'le.» ");
INSERT INTO moa_vpl VALUES ("JN6_34","073_6_34","JHN","6","34","34","'Bhɛ klɛle 'tɛ, 'ke ‑wa pele‑ Zesu ni dɔɔ: «'O Daan mi, 'o gba yikpɛn‑ ta 'bhɛ 'bluu 'ɛ ba.» ");
INSERT INTO moa_vpl VALUES ("JN6_35","073_6_35","JHN","6","35","35","'Bhɛ klɛle 'tɛ, 'ke Zesu 'a 'pele ‑o ni dɔɔ: «'Mi ‑le 'ke 'bluu 'la ‑si na mɛɛ ni 'bhɛ 'le. 'Ke mɛɛ 'la zan ‑nwa 'mi ba, gbɔn laa nu 'bhɛ zan 'ɛ dɛlɛ ‑titi. 'Bhɛɛ‑ 'ke mɛɛ 'la zan 'e ꞊kpaa 'mi 'yi, ‑yi 'mi ‑lrɔ 'laa nu 'bhɛ zan 'ɛ dɛlɛ ‑titi. ");
INSERT INTO moa_vpl VALUES ("JN6_36","073_6_36","JHN","6","36","36","'Mi 'a ꞊pia 'ka ni dɔɔ 'ka 'ŋ ꞊ya, 'bhɛɛ‑ 'duŋ‑ 'ka 'laa 'ka kpa 'ŋ 'yi. ");
INSERT INTO moa_vpl VALUES ("JN6_37","073_6_37","JHN","6","37","37","'Ke 'ŋ Dɛ mɛɛ 'oo mɛɛ 'la zan ‑naa 'ŋ ni, 'bhɛ zan nu nulɛ 'mi ba. 'Bhɛɛ‑ 'ke mɛɛ 'la zan ‑nwa 'ŋ ba, 'naa nu 'ŋ ‑baŋgolɛ 'bhɛ zan 'ɛ 'yi. ");
INSERT INTO moa_vpl VALUES ("JN6_38","073_6_38","JHN","6","38","38","‑Amasrɔyi 'naa dalɛ laflɛ' 'yi 'ŋ 'gbu zru maza klɛ zayi', 'duŋ‑ 'ŋ ‑daa laflɛ' 'yi 'ŋ 'winbɔ‑ mi ‑la zru maza klɛ zayi'. ");
INSERT INTO moa_vpl VALUES ("JN6_39","073_6_39","JHN","6","39","39","'Duŋ‑ mɛɛ 'la zan 'ŋ 'winbwa‑, 'bhɛ zru maza 'ɛ 'bhɛ ‑le ‑gɛ: ‑Ya zi 'bhii‑ ‑e mɛɛ mu 'la 'kpɛn 'naa‑ 'ŋ 'ni, 'naa ‑o do 'kpɔ 'nilɛ‑, 'bhɛɛ‑ 'duŋ‑ 'ke ‑o 'kpɛn bwe gale ba 'drunyan 'yan yi 'le. ");
INSERT INTO moa_vpl VALUES ("JN6_40","073_6_40","JHN","6","40","40","'Ŋ Dɛ ‑Waanbhaa' zru maza 'ɛ 'yele‑ ‑gɛ: ‑Ya zi 'bhii‑ 'ke mɛɛ mu 'la 'kpɛn ‑a Gbe 'ɛ ꞊ya, 'bhɛɛ‑ ‑woo ‑kpaa ‑a ‑yi, 'bhɛ zan mu 'ɛ ‑o bole ‑yrɛ ma ‑si 'ɛ 'srɔɔwo‑; 'bhɛɛ‑ 'mi 'gbu nu ‑o bwelɛ gale ba 'drunyan 'yan yi 'le.» ");
INSERT INTO moa_vpl VALUES ("JN6_41","073_6_41","JHN","6","41","41","'Bhɛ klɛle 'tɛ, 'ke Zuufu ‑kuŋlii mu 'ɛ ‑o Zesu 'tɔpele 'sanle ‑o ‑lɛla', ‑amasrɔyi ‑ya ‑pia dɔɔ: «'Mi ‑le 'ke 'bluu 'la ‑daa laflɛ' 'yi 'bhɛ 'le.» ");
INSERT INTO moa_vpl VALUES ("JN6_42","073_6_42","JHN","6","42","42","‑O ‑yaa 'pe 'zi dɔɔ: «‑Ɛɛ'! Zozɛfu gbe Zesu 'ɛ yaa 'kɛle‑ ɛɛ? 'Wa dɛ 'pegee ‑a nɛɛ dɔ, ‑e ꞊kla 'nale‑ 'bhɛɛ‑ ‑ya pe 'zi dɔɔ ‑e ‑daa laflɛ' 'yi ɛɛ?» ");
INSERT INTO moa_vpl VALUES ("JN6_43","073_6_43","JHN","6","43","43","'Bhɛ klɛle 'tɛ, 'ke Zesu 'a 'lɛkunle ‑o ni dɔɔ: «‑Ka 'laa 'ŋ 'tɔpelɛ 'ka 'lɛla 'eke‑ pleŋ‑. ");
INSERT INTO moa_vpl VALUES ("JN6_44","073_6_44","JHN","6","44","44","Mɛɛ 'kedo‑ 'kpɔ 'laa sɔ nule‑ 'mi ba, 'ke 'ŋ Dɛ ‑Waanbhaa' 'la 'bhɛ 'ŋ 'winbwa‑ 'bhɛ 'laa 'nulɛ‑ 'bhɛ zan 'ɛ 'le 'mi ba, 'bhɛɛ‑ 'mi 'a bwe gale ba 'drunyan 'yan yi 'le. ");
INSERT INTO moa_vpl VALUES ("JN6_45","073_6_45","JHN","6","45","45","‑Waanbhaa' ‑lɛla' janwo mu 'ɛ 'ke mu ‑jan 'lɛɛ‑ 'bhɛ ꞊woa dɔɔ: ‹‑Waanbhaa' nu ‑o 'kpɛn daanlɛ.› 'Ke mɛɛ 'oo mɛɛ 'la zan 'e 'trɔnkpaa‑ 'ŋ Dɛ wojan 'ɛ ꞊la, 'bhɛɛ‑ 'kee‑ ‑dwa ‑a ‑la, 'bhɛ zan 'ɛ nu 'mi ba. ");
INSERT INTO moa_vpl VALUES ("JN6_46","073_6_46","JHN","6","46","46","Yaa klɛlɛ 'bhii‑ mɛɛ 'ke 'ŋ Dɛ ‑Waanbhaa' ꞊ya, 'ke yaa 'e go mɛɛ 'la zan do ‑kplɛn ‑daa ‑Waanbhaa' ba 'bhɛ zan ‑le 'a ꞊ya.» ");
INSERT INTO moa_vpl VALUES ("JN6_47","073_6_47","JHN","6","47","47","«'Mi pe 'ka ni 'ŋ 'sɔwɛɛ‑ ma dɔɔ: 'ke mɛɛ 'la zan 'e ꞊kpaa 'mi 'yi, 'bhɛ zan bole ‑yrɛ ma ‑si 'la ‑daŋ' 'laa ‑o 'bhɛ ma 'bhɛ 'srɔɔwo‑. ");
INSERT INTO moa_vpl VALUES ("JN6_48","073_6_48","JHN","6","48","48","'Mi 'gbu ‑le 'ke pɛbhle 'la ‑si na mɛɛ ni 'bhɛ 'le. ");
INSERT INTO moa_vpl VALUES ("JN6_49","073_6_49","JHN","6","49","49","'Elwaleta ‑sɔ, 'ka ‑gbɔɔ mu 'ɛ ‑o ‑yaa pɛbhle 'la sii mani 'bhɛ bhle ‑kpe 'ɛ ta, 'bhɛɛ‑ 'duŋ‑ ‑o ‑gaa. ");
INSERT INTO moa_vpl VALUES ("JN6_50","073_6_50","JHN","6","50","50","'Duŋ‑ pɛbhle 'la ‑daa laflɛ' 'yi 'ke mɛɛ 'la zan 'bhɛ ꞊bhla, 'bhɛ zan laa nu galɛ. ");
INSERT INTO moa_vpl VALUES ("JN6_51","073_6_51","JHN","6","51","51","'Mi 'gbu ‑le 'ke pɛbhle 'yrɛ male 'la ‑daa laflɛ' 'yi 'bhɛ 'le. 'Ke mɛɛ 'la zan 'bhɛ pɛ 'ɛ ꞊bhla, 'bhɛ zan nu bolɛ 'bhɛ 'yrɛ ma yikpɛnsee ta 'ke ‑daŋ' 'laa klɛ 'bhɛ ma. 'Bhɛɛ‑ 'ŋ nu pɛbhle 'la 'nalɛ 'bhɛ zan ni, 'bhɛ ‑le 'ke 'ŋ 'flɛ 'ɛ 'le. 'Mi ‑o 'ŋ 'flɛ 'ɛ 'na zii', 'kooko‑ 'drunyan 'yi mu 'ɛ bole ‑yrɛ ma ‑si 'srɔɔwo‑ 'bhɛ ma.» ");
INSERT INTO moa_vpl VALUES ("JN6_52","073_6_52","JHN","6","52","52","'Bhɛ klɛle 'tɛ, 'ke Zuufu mu 'ɛ ‑o ‑zaabɔle 'sanle 'eglɔɔle 'eke‑ pleŋ‑, 'ke ‑wa pe dɔɔ: «'Bhɛ sɔ klɛle‑ 'nale‑ 'bhɛɛ‑ mɛɛ 'lɛɛ‑ sɔ ‑a 'flɛ 'ɛ 'nale 'o ni 'kaa 'wa 'bhle ɛɛ?» ");
INSERT INTO moa_vpl VALUES ("JN6_53","073_6_53","JHN","6","53","53","Zesu pe ‑o ni 'ezin‑ dɔɔ: «'Mi pe 'ka ni 'ŋ 'sɔwɛɛ‑ ma dɔɔ: 'ke 'ka 'laa Bhaaplɛŋ Gbe 'ɛ 'flɛ 'ɛ 'bhlelɛ‑, 'bhɛɛ‑ 'ke 'ka 'laa ‑a yiɛn 'milɛ‑, 'ka 'laa nu bole ‑yrɛ ma ‑si 'srɔɔwolɛ 'ka 'gbu 'yi. ");
INSERT INTO moa_vpl VALUES ("JN6_54","073_6_54","JHN","6","54","54","'Ke mɛɛ 'la zan 'ŋ 'flɛ 'ɛ ꞊bhla, 'bhɛɛ‑ 'ke ‑yoo 'ŋ yiɛn 'ɛ 'mia‑, bole ‑yrɛ ma ‑si 'la ‑daŋ' 'laa ‑o 'bhɛ ma 'bhɛ ‑o 'bhɛ zan 'kɔɔ; 'bhɛɛ‑ 'mi nu 'bhɛ zan 'ɛ bwelɛ gale ba 'drunyan 'yan yi 'le. ");
INSERT INTO moa_vpl VALUES ("JN6_55","073_6_55","JHN","6","55","55","‑Amasrɔyi, 'ŋ 'flɛ ‑yoo 'ke pɛbhle ‑zeze 'gbu 'le, 'bhɛɛ‑ 'ŋ yiɛn 'ɛ 'bhɛ ‑o 'ke mipɛ ‑zeze 'gbu 'le 'ezin‑. ");
INSERT INTO moa_vpl VALUES ("JN6_56","073_6_56","JHN","6","56","56","'Ke mɛɛ 'la zan 'ŋ 'flɛ 'ɛ ꞊bhla, 'bhɛɛ‑ 'ke ‑yoo 'ŋ yiɛn 'ɛ 'mia‑, 'bhɛ zan bo 'mi 'yi, 'bhɛɛ‑ 'mi bo 'bhɛ zan 'ɛ ‑yi 'ezin‑. ");
INSERT INTO moa_vpl VALUES ("JN6_57","073_6_57","JHN","6","57","57","'Ŋ Dɛ 'la ‑yoo 'ŋ 'winbwa‑ ‑ya ‑yrɛ ma, 'bhɛɛ‑ 'ŋ 'yoo‑ 'ŋ 'yrɛ ma 'yela‑ 'srɔyi. 'Duŋ‑ 'ke mɛɛ 'la zan 'ŋ 'flɛ 'ɛ ꞊bhla, 'bhɛ zan nu bolɛ 'bhɛ 'yrɛ ma 'mi 'srɔyi. ");
INSERT INTO moa_vpl VALUES ("JN6_58","073_6_58","JHN","6","58","58","Pɛbhle 'la ‑daa laflɛ 'yi 'yele‑ ‑gɛ. Yaa ‑o 'bhii‑ 'ka ‑gbɔɔ mu 'kɛla ꞊bhla, 'bhɛɛ‑ waa bole ‑yrɛ ma ‑si 'la ‑daŋ' 'laa ‑o 'bhɛ ma 'bhɛ 'srɔɔwolɛ, 'bhɛɛ‑ ‑o ‑gaa. 'Ke mɛɛ 'la zan 'yee‑ pɛbhle 'la ‑daa laflɛ' 'yi 'bhɛ ꞊bhla, 'bhɛ zan nu bolɛ 'bhɛ 'yrɛ ma yikpɛnsee ta.» ");
INSERT INTO moa_vpl VALUES ("JN6_59","073_6_59","JHN","6","59","59","Zesu 'bhɛ ‑jan mu 'la bhe 'mu ꞊woa 'ke ‑yoo Kapɛnɔmu Zuufu mu 'ɛ daanfɛ' 'ɛ ꞊la. ");
INSERT INTO moa_vpl VALUES ("JN6_60","073_6_60","JHN","6","60","60","Zesu 'yanle‑ 'bhɛ ‑jan 'ɛ 'wolele 'tɛ, 'ke ‑yaa' ‑klaŋlanɛ mu 'ɛ ‑bebe 'a 'pele dɔɔ: «‑Jan 'lɛɛ‑ 'bhɛ ‑o 'eglɔɔle 'dɛ, ‑dele sɔ dɔle‑ 'bhɛ ꞊la ɛɛ?» ");
INSERT INTO moa_vpl VALUES ("JN6_61","073_6_61","JHN","6","61","61","'Bhɛ 'yi, 'ke Zesu 'a 'yaangole 'bhii‑ ‑yaa' ‑klaŋlanɛ mu 'ɛ 'yaa‑ ‑a ma janwo 'zi ‑o ‑lɛla'. 'Bhɛla‑ ‑yile, 'ke ‑ya pele‑ ‑o ni dɔɔ: «'Bhɛ ‑jan 'ɛ ꞊sia 'ka 'yi ɛɛ? ");
INSERT INTO moa_vpl VALUES ("JN6_62","073_6_62","JHN","6","62","62","'Bhɛɛ‑ 'ka nu ‑a pelɛ 'nale‑ ‑a ma, 'ke 'ka *Bhaaplɛŋ Gbe 'ɛ 'sanle ꞊ya 'waati 'la ba, 'ke ‑yoo ge 'zi ‑e ‑yaa yrɛ ꞊lwa 'la ꞊nɔɔ 'elwale 'bhɛ ꞊nɔɔ ɛɛ? ");
INSERT INTO moa_vpl VALUES ("JN6_63","073_6_63","JHN","6","63","63","‑Waanbhaa' Lii 'Weŋ 'ɛ 'bhɛ ‑le bole ‑yrɛ ma ‑si 'na mɛɛ ni, 'bhɛɛ‑ bhaaplɛŋ laa sɔ ‑si 'nale bhaaplɛŋ ni. 'Ŋ ‑jan mu 'la ꞊woa 'ka ni bhe, 'ka *‑Waanbhaa' Lii 'Weŋ 'pegee bole ‑yrɛ ma ‑si 'srɔɔwo‑ 'mu ‑la ma. ");
INSERT INTO moa_vpl VALUES ("JN6_64","073_6_64","JHN","6","64","64","'Duŋ‑ 'ka 'ke mu laa ‑o 'mu 'kpa zii' 'mu 'yi.» ‑Amasrɔyi 'kee‑ san ‑yaa' ye 'ɛ zisan' bhla zi 'ɛ ma, mɛɛ 'la zan mu laa ‑yaa nu 'mu 'kpalɛ‑ ‑a ‑yi ‑e ‑yaa 'bhɛ zan mu 'ɛ dɔ; 'bhɛɛ‑ mɛɛ 'la zan ‑yaa nu ‑dawli' 'kpalɛ‑ ‑a gbɛ ta, 'bhɛɛ‑ ‑ya ‑lɛna' mɛɛ mu ni; ‑e ‑yaa 'bhɛ zan 'ɛ dɔ 'ezin‑. ");
INSERT INTO moa_vpl VALUES ("JN6_65","073_6_65","JHN","6","65","65","Zesu pe 'bhɛ trala 'ezin‑ dɔɔ: «'Bhɛla‑ ‑zayile 'mi 'a ꞊pia 'ka ni dɔɔ mɛɛ 'kedo‑ 'kpɔ 'laa sɔ nule‑ 'mi ba, 'ke 'ŋ Dɛ laa 'bhɛ 'seŋ 'nalɛ‑ 'bhɛ zan 'ɛ ni.» ");
INSERT INTO moa_vpl VALUES ("JN6_66","073_6_66","JHN","6","66","66","‑A 'san 'bhɛ yi 'ɛ ma, Zesu ‑a ‑klaŋlanɛ mu 'ɛ ‑bebe ‑o pleŋgwa‑ ‑a ma, 'bhɛɛ‑ waa ‑yaa ge a zi ‑li. ");
INSERT INTO moa_vpl VALUES ("JN6_67","073_6_67","JHN","6","67","67","'Bhɛla‑ ‑zayile, 'ke Zesu ‑yaa' ‑klaŋlanɛ vu ta plɛ 'ɛ ‑o ‑lrɔkpale dɔɔ: «'Ka mu 'lɛɛ, 'ka mu laa ‑a zi 'bhii‑ 'ka go 'ŋ zi 'ezin‑ ɛɛ?» ");
INSERT INTO moa_vpl VALUES ("JN6_68","073_6_68","JHN","6","68","68","'Bhɛ klɛle 'tɛ, 'ke Simɔ Piɛri 'a 'lɛkunle 'a ni dɔɔ: «Mɛɛzan, 'o nu gelɛ ‑de 'gbu ba ɛɛ? ‑Jan mu 'la bole ‑yrɛ ma ‑si 'la ‑daŋ' 'laa ‑o 'bhɛ ma 'bhɛ na bhaaplɛŋ ni 'mu ‑o 'bhi 'la 'kɔɔ. ");
INSERT INTO moa_vpl VALUES ("JN6_69","073_6_69","JHN","6","69","69","'Bhɛɛ‑ 'woo ꞊kpaa 'mu 'yi, 'bhɛɛ‑ 'wa 'yaango‑ dɔɔ 'bhii‑ 'bhi ‑le 'ke ‑Waanbhaa' Mɛɛ 'Weŋ 'la ꞊kpaa bhaaplɛŋ mu ni 'bhɛ 'le.» ");
INSERT INTO moa_vpl VALUES ("JN6_70","073_6_70","JHN","6","70","70","'Bhɛ klɛle 'tɛ, 'ke Zesu 'a zikpale 'a ni dɔɔ: «'Mi ‑le 'laa 'ka mɛɛ vu ta plɛ 'ɛ makunlɛ ɛɛ? 'Bhɛɛ‑ 'duŋ‑, 'ka do ‑o 'ke ‑Setran' 'le!» ");
INSERT INTO moa_vpl VALUES ("JN6_71","073_6_71","JHN","6","71","71","‑E ‑yaa 'bhɛ ‑jan 'ɛ 'wo zii' Zuda ‑la ma, Simɔ Isikariɔti gbe, ‑amasrɔyi 'ali‑ ‑e ‑yaa Zesu a ‑klaŋlanɛ vu ta plɛ do ‑la 'le bhe, 'yele‑ ‑yaa nu ‑dawli' 'kpalɛ‑ Zesu gbɛ ta, 'bhɛɛ‑ ‑ya ‑lɛna' mɛɛ mu ni. ");
INSERT INTO moa_vpl VALUES ("JN7_1","073_7_1","JHN","7","1","1","'Bhɛ blaan, 'ke Zesu 'kaanle Galile 'klɛɛn 'ɛ 'yi yrɛkpɛn‑ ꞊nɔɔ. Yaa ‑yaa ‑a zi 'bhii‑ ‑e ge Zude 'klɛɛn 'ɛ 'yi, ‑amasrɔyi Zuufu ‑kuŋlii mu 'ɛ 'yaa‑ dɛyrɛ ‑glin 'zi. ");
INSERT INTO moa_vpl VALUES ("JN7_2","073_7_2","JHN","7","2","2","'Bhɛ 'waati 'ɛ ba, Zuufu mu a 'fɛti 'la ‑o ‑yaa 'bhɛ sii Tabɛɛnaki ('bhɛ 'yi ‑le dɔɔ 'kpaa ꞊la 'yaaza‑ 'fɛti) 'bhɛ ꞊bhwa gban bi 'e ‑din, ");
INSERT INTO moa_vpl VALUES ("JN7_3","073_7_3","JHN","7","3","3","'Bhɛɛ‑ Zesu nɛɛnɛ‑ mu 'ɛ ‑o pe ‑a ni dɔɔ: «Go ‑gɛ, 'bhɛɛ‑ ge Zude 'trɛ ta, 'kooko‑ 'yaa‑ ‑klaŋlanɛ mu 'la ‑woo 'bhɛ yrɛ 'ɛ ꞊nɔɔ ye, 'mu 'e klɛza mu 'ɛ ye 'ezin‑. ");
INSERT INTO moa_vpl VALUES ("JN7_4","073_7_4","JHN","7","4","4","'Ke mɛɛ 'la zan ‑a zi 'bhii‑ mɛɛ mu 'a dɔ, 'bhɛ zan laa ‑za mu klɛ gaanyi'. 'E 'sɔle‑ maza mu 'la klɛ 'zi bhe, 'e 'gbu zrɔn mɛɛ mu ni, 'kooko‑ mɔkpɛn' 'e ye.» ");
INSERT INTO moa_vpl VALUES ("JN7_5","073_7_5","JHN","7","5","5","Zesu nɛɛnɛ‑ mu 'ɛ 'yaa‑ 'bhɛ ‑jan ‑glɔɔn 'ɛ 'wo zii' ‑a ni, amasrɔyi 'mu 'laa ‑yaa 'e kpa a ‑yi. ");
INSERT INTO moa_vpl VALUES ("JN7_6","073_7_6","JHN","7","6","6","'Bhɛ 'yi 'tɛ, 'ke Zesu 'a ‑lɛkunle ‑o ni dɔɔ: «‑Waanbhaa' 'waati 'la ‑dwa 'mi ni, 'bhɛ 'laa bhɔlɛ ‑li; 'bhɛɛ‑ 'duŋ‑ 'waati 'ɛ 'kpɛn ‑o 'elrele 'ka mu ma. ");
INSERT INTO moa_vpl VALUES ("JN7_7","073_7_7","JHN","7","7","7","'Drunyan ta mɛɛ mu 'ɛ waa sɔ 'ka mu mafinyanwole, 'duŋ‑ ‑o 'mi mafinyanwo, ‑amasrɔyi 'mi ‑o ‑a pe 'zi dɔɔ ‑o klɛza mu 'ɛ ‑woo 'eyɔɔle. ");
INSERT INTO moa_vpl VALUES ("JN7_8","073_7_8","JHN","7","8","8","'Ka mu, ‑ka ge 'yee‑ 'fɛti 'la bhe ‑a ta. 'Mi 'laa nu gelɛ ‑a ta, ‑amasrɔyi 'an pɛ 'waati 'ɛ yaa bhɔlɛ ‑li.» ");
INSERT INTO moa_vpl VALUES ("JN7_9","073_7_9","JHN","7","9","9","‑E yanle 'bhɛ ‑jan mu 'ɛ 'wolele ‑o ni, 'kee‑ bole‑ Galile 'klɛɛn 'ɛ 'yi. ");
INSERT INTO moa_vpl VALUES ("JN7_10","073_7_10","JHN","7","10","10","Zesu nɛɛnɛ‑ mu 'ɛ gele blaan Zeruzalɛmu Tabɛɛnaki 'fɛti 'ɛ ta, 'ke 'yee‑ Zesu 'gbu gele 'yee‑ 'fɛti 'ɛ ta 'ezin‑. 'Duŋ‑ yaa 'gbu mazrɔnlɛ mɛɛ 'kedo‑ 'kpɔ ni, 'bhɛɛ‑ ‑a gaanle ꞊bwa. ");
INSERT INTO moa_vpl VALUES ("JN7_11","073_7_11","JHN","7","11","11","Zuufu ‑kuŋlii mu 'ɛ 'yaa‑ ‑a ziglin‑ 'zi 'bhɛ 'fɛti 'ɛ ta, 'bhɛɛ‑ 'ke ‑wa pe dɔɔ: «‑Yoo 'naa‑ ma ɛɛ?» ");
INSERT INTO moa_vpl VALUES ("JN7_12","073_7_12","JHN","7","12","12","‑Zamaa' 'ɛ 'pleŋ‑ mɛɛ mu 'ɛ 'yaa‑ zaabɔ 'zi ‑a ba zayi'. Mɛɛ 'ke mu ‑yaa pe 'zi dɔɔ: «Mɛɛ wlan ‑le 'kɛle‑.» 'Bhɛɛ‑ ‑a 'ke mu ‑yaa pe 'zi dɔɔ: «Wlan laa 'ke 'bhɛ 'le, ‑e mɛɛ mu 'ɛ 'ni zii'.» ");
INSERT INTO moa_vpl VALUES ("JN7_13","073_7_13","JHN","7","13","13","'Duŋ‑ mɛɛ 'kedo‑ 'kpɔ 'laa ‑yaa ‑janwo' zii' ‑a ma 'eglɔɔle, ‑amasrɔyi ‑o 'kpɛn 'yaa‑ ‑gblaan 'zi Zuufu ‑kuŋlii mu 'ɛ 'lɛɛ. ");
INSERT INTO moa_vpl VALUES ("JN7_14","073_7_14","JHN","7","14","14","'Fɛti 'ɛ ꞊bhwa ‑a drɛyi' bhla 'la ba, 'ke Zesu gele‑ wlalɛ ‑Waanbhaa' Gba 'Fɛ ‑Gbɛnɛ 'ɛ ꞊la, 'bhɛɛ‑ 'kee‑ mɛɛ mu daanle 'sanle. ");
INSERT INTO moa_vpl VALUES ("JN7_15","073_7_15","JHN","7","15","15","'Bhɛ ya 'ɛ 'yi, Zuufu ‑kuŋlii mu 'ɛ 'kpeelɛnia ‑o ma, 'bhɛɛ‑ ‑woo 'eke‑ ‑lrɔkpale ‑saan dɔɔ: «‑E ꞊kla 'nale‑ 'bhɛɛ‑ 'yee‑ 'gwlaan‑ 'lɛɛ‑ ‑e ‑Waanbhaa' a 'Sɛwɛ 'ɛ dɔ 'bhɛ gbɛɛn‑ ‑gee' ɛɛ, ‑amasrɔyi yaa 'sɛwɛ daanlɛ ‑laklu 'yi?» ");
INSERT INTO moa_vpl VALUES ("JN7_16","073_7_16","JHN","7","16","16","'Bhɛ klɛle 'tɛ, 'ke Zesu 'a 'zikpale ‑o ni dɔɔ: «'An pɛ mɛɛ daangbɛya 'ɛ 'bhɛ 'laa da 'mi ba, 'duŋ‑ 'bhɛ da ‑Waanbhaa' 'la 'mi 'winbwa‑ 'bhɛɛ‑ ba. ");
INSERT INTO moa_vpl VALUES ("JN7_17","073_7_17","JHN","7","17","17","'Ke mɛɛ 'la zan ‑a zi 'bhii‑ 'bhɛ ‑Waanbhaa' zru maza klɛ, 'ke 'an pɛ mɛɛ daangbɛya 'ɛ da ‑Waanbhaa' ba oo, 'kee‑ da 'ŋ 'gbu a ‑glɔɔya' ‑la ba oo, 'bhɛ zan nu 'bhɛ dɔlɛ. ");
INSERT INTO moa_vpl VALUES ("JN7_18","073_7_18","JHN","7","18","18","'Ke mɛɛ 'la zan ‑o ‑janwo' zii' ‑a 'gbu a ‑glɔɔya' ma, ‑ya 'gbu 'tɔbhɔyrɛ ‑la glin. 'Duŋ‑ 'ke mɛɛ 'la zan ‑o mɛɛ 'la zan 'a 'winbwa‑ 'bhɛ 'tɔbhɔyrɛ ‑glin 'zi, 'bhɛ zan wlan pe, 'bhɛɛ‑ bhla maza do 'kpɔ 'laa ‑o ‑a ‑yi. ");
INSERT INTO moa_vpl VALUES ("JN7_19","073_7_19","JHN","7","19","19","*Moizi ‑le 'laa 'Toŋ 'ɛ 'nalɛ‑ 'ka ni ɛɛ? 'Bhɛɛ‑, 'duŋ‑ 'ka 'kedo‑ 'kpɔ 'laa 'yee‑ 'Toŋ 'ɛ 'klɔsikun. ‑Mɛle ‑kla 'bhɛɛ‑ 'kaa‑ zi 'bhii‑ 'ka 'mi dɛ ɛɛ?» ");
INSERT INTO moa_vpl VALUES ("JN7_20","073_7_20","JHN","7","20","20","'Bhɛ klɛle 'tɛ, 'ke ‑zamaa' 'ɛ ‑ya ‑lɛkunle dɔɔ: «Lii ‑yɔɔ' ‑o 'e zi! ‑Dele 'e dɛyrɛ ‑glin 'zi ɛɛ?» ");
INSERT INTO moa_vpl VALUES ("JN7_21","073_7_21","JHN","7","21","21","Zesu pe ‑o ni dɔɔ: «'Mi 'sɔle‑ maza do 'kpɔ 'la ‑kla, 'bhɛɛ‑ 'bhɛ ‑le 'ka 'kpɛn 'kpeelɛnia 'ka ma! ");
INSERT INTO moa_vpl VALUES ("JN7_22","073_7_22","JHN","7","22","22","Moizi 'kaa ‑nɛ 'gwlaan‑ mu wlaza 'klɛɛn 'yi 'toŋ 'ɛ ‑dwa 'ka ni bhe, 'bhɛɛ‑ 'duŋ‑ 'bhɛ 'klɛɛn 'yi 'wlaza‑ 'toŋ 'ɛ 'bhɛ 'laa 'sanlɛ‑ 'yee‑ Moizi ma, 'bhɛ zisaan‑ ‑kɔɔ' ‑gbɔɔ mu ‑la ma. 'Ali‑ ‑yitrɛ' yi ma, 'ka dɔ ‑a ‑la 'ke 'kaa ‑nɛ 'gwlaanɛ‑ mu wla 'klɛɛn 'yi. ");
INSERT INTO moa_vpl VALUES ("JN7_23","073_7_23","JHN","7","23","23","'Ke 'ka sɔ ‑nɛ 'gwlaan‑ do wlale‑ 'klɛɛn 'yi ‑yitrɛ' yi 'ɛ ma, 'ke 'bhɛ 'laa Moizi a 'Toŋ 'ɛ 'yisiɛ‑, ‑mɛle ‑kla 'bhɛɛ‑ 'ka ‑o 'ka zruplii‑ 'zi 'mi ma, ‑amasrɔyi 'mi mɛɛ do ‑bheela ‑yitrɛ' yi 'ɛ ma ɛɛ? ");
INSERT INTO moa_vpl VALUES ("JN7_24","073_7_24","JHN","7","24","24","'Ka 'laa mɛɛ mu 'kitikanlɛ ‑o dɔgbɛya ma, ‑ka mɛɛ mu 'kitikan ‑lɛdɔɔleya ‑la ma.» ");
INSERT INTO moa_vpl VALUES ("JN7_25","073_7_25","JHN","7","25","25","Zeruzalɛmu ‑wa 'ɛ ta mu 'ɛ 'ke mu ‑yaa pe 'zi dɔɔ: «Waa ‑yaa 'yee‑ mɛɛ 'lɛɛ‑ 'yela‑ dɛyrɛ glin 'zi ɛɛ? ");
INSERT INTO moa_vpl VALUES ("JN7_26","073_7_26","JHN","7","26","26","‑Ka 'ka 'yrɛkpa doo, ‑yoo ‑janwo' zii' mɔkpɛn' 'yrɛ ma kpataakpa, 'bhɛɛ‑ mɛɛ 'kedo‑ 'kpɔ 'laa sɔ ‑jan 'kanle ‑a ‑lɛ ma! Taa‑ 'o ‑kuŋlii mu 'ɛ ‑wa ꞊ya wlan ma 'bhii‑ 'yele‑ 'ke Mɛɛ ‑Bhee Mi ‑Kpɔsɔɔ Krisi 'ɛ 'le ɛɛ? ");
INSERT INTO moa_vpl VALUES ("JN7_27","073_7_27","JHN","7","27","27","Mɛɛ 'lɛɛ‑, 'o mɔɔ 'a dayrɛ dɔ; 'bhɛɛ‑ 'duŋ‑, 'ke Mɛɛ ‑Bhee Mi ‑Kpɔsɔɔ Krisi 'ɛ ꞊nwa, mɛɛ 'kedo‑ 'kpɔ 'laa nu 'bhɛ dayrɛ 'ɛ dɔlɛ.» ");
INSERT INTO moa_vpl VALUES ("JN7_28","073_7_28","JHN","7","28","28","'Bhɛ ꞊nɔɔ bhe 'tɛ, Zesu 'yaa‑ mɛɛ mu 'ɛ daan 'zi bhla 'la ba ‑Waanbhaa' Gba 'Fɛ ‑Gbɛnɛ 'ɛ ꞊la, 'ke ‑ya pele‑ 'eglɔɔle dɔɔ: «'Ka 'mi dɔ ɛɛ? 'Bhɛɛ‑ 'ka 'mi dayrɛ 'ɛ dɔ ɛɛ? 'Duŋ‑ 'naa 'nulɛ‑ 'ŋ 'gbu ma, 'bhɛɛ‑ mɛɛ 'la zan 'ŋ 'winbwa‑ 'bhɛ zan ‑o 'ke wlan pe mi 'le. 'Ka 'laa 'bhɛ dɔ. ");
INSERT INTO moa_vpl VALUES ("JN7_29","073_7_29","JHN","7","29","29","'Mi 'duŋ‑ 'a dɔ, ‑amasrɔyi 'ŋ da 'zi 'a ‑din, 'bhɛɛ‑ 'yele‑ 'mi 'winbwa‑.» ");
INSERT INTO moa_vpl VALUES ("JN7_30","073_7_30","JHN","7","30","30","Zesu 'bhɛ 'pele‑ bhe, ‑o ‑yaa ‑a zi 'bhii‑ ‑wa 'kun. 'Duŋ‑ mɛɛ 'kedo‑ 'kpɔ 'laa 'a 'kunlɛ‑, ‑amasrɔyi ‑yaa pɛ 'waati 'ɛ 'bhɛ 'laa bhɔlɛ ‑li bi. ");
INSERT INTO moa_vpl VALUES ("JN7_31","073_7_31","JHN","7","31","31","'Duŋ‑ ‑zamaa' 'ɛ 'pleŋ‑ mɛɛ ‑bebe 'e ‑kpaa ‑a ‑yi, 'bhɛɛ‑ ‑o ‑yaa pe 'zi dɔɔ: «'Ke Mɛɛ ‑Bhee Mi ‑Kpɔsɔɔ Krisi 'ɛ ꞊nwa, ‑e nu 'sɔle‑ maza ‑bebe klɛlɛ 'ke 'bhɛ kan mɛɛ 'lɛɛ‑ ta ɛɛ?» ");
INSERT INTO moa_vpl VALUES ("JN7_32","073_7_32","JHN","7","32","32","‑Zamaa' 'ɛ 'yaa‑ ‑jan 'la 'wo zii' ‑o ‑lɛla' Zesu ba zayi', Farizi mu 'ɛ 'bhɛ ꞊maa. ‑Ayile 'ke 'sraka 'lɛna ‑kuŋlii' mu 'ɛ 'pegee Farizi mu 'ɛ ‑o ‑Waanbhaa' Gba 'Fɛ ‑Gbɛnɛ 'ɛ gooba mu 'ɛ 'ke mu winbɔle Zesu 'kunyrɛ‑ nɔɔ‑. ");
INSERT INTO moa_vpl VALUES ("JN7_33","073_7_33","JHN","7","33","33","'Bhɛ klɛle 'tɛ, 'ke Zesu 'a 'pele dɔɔ: «'Ŋ 'yoo‑ 'ka ‑din ‑sɔ 'waati sa, 'bhɛɛ‑ 'ŋ nu gelɛ mɛɛ 'la zan 'ŋ 'winbwa‑ 'bhɛ ba. ");
INSERT INTO moa_vpl VALUES ("JN7_34","073_7_34","JHN","7","34","34","'Ka nu 'ŋ ziglinlɛ, 'bhɛɛ‑ 'duŋ‑ 'ka 'laa nu 'ŋ 'yelɛ‑; ‑amasrɔyi 'ŋ nu klɛlɛ yrɛ 'la ꞊nɔɔ 'ka 'laa sɔ gele‑ 'bhɛ ꞊nɔɔ.» ");
INSERT INTO moa_vpl VALUES ("JN7_35","073_7_35","JHN","7","35","35","'Bhɛ ya 'ɛ 'yi, 'ke Zuufu ‑kuŋlii mu 'ɛ ‑wa pele‑ 'eke‑ ni dɔɔ: «‑E nu gelɛ yrɛ 'ɛ ‑dela nɔɔ‑ 'bhɛɛ‑ 'waa sɔ ‑a yele‑ ɛɛ? ‑E nu gelɛ Zuufu mu 'la 'kaan‑ 'eke‑ ma, 'bhɛɛ‑ ‑o ‑ja Grɛki mu 'ɛ 'pleŋ‑ 'mu ‑la ba, 'bhɛɛ‑ ‑e Grɛki mu 'ɛ daan ɛɛ? ");
INSERT INTO moa_vpl VALUES ("JN7_36","073_7_36","JHN","7","36","36","‑E ‑jan 'la 'wo zii' dɔɔ: ‹'Ka nu 'ŋ ziglinlɛ, 'bhɛɛ‑ 'ka 'laa nu 'ŋ 'yelɛ‑; ‑amasrɔyi 'ŋ nu klɛlɛ yrɛ ‑nɛ 'la ꞊nɔɔ 'ka 'laa nu 'sɔlɛ‑ gele‑ 'bhɛ ꞊nɔɔ.› 'Bhɛ 'yi ‑o 'nale‑ ɛɛ?» ");
INSERT INTO moa_vpl VALUES ("JN7_37","073_7_37","JHN","7","37","37","'Fɛti 'ɛ 'yan yi 'ɛ 'bhɛ ‑le ‑yaa yi ‑gbɛnɛ 'gbu 'ɛ 'le. 'Bhɛ ‑yi 'ɛ 'le, Zesu dulale 'la 'yaa‑ ‑zamaa' do ‑lɛɛ 'ke ‑ya pele‑ 'eglɔɔle dɔɔ: «'Ke ‑yi 'mi ‑lrɔ ‑o mɛɛ 'la zan dɛ 'zi, 'bhɛ zan nu 'mi ba 'bhɛɛ‑ ‑e ‑yi mi. ");
INSERT INTO moa_vpl VALUES ("JN7_38","073_7_38","JHN","7","38","38","‹'Ke mɛɛ 'la zan 'e ꞊kpaa 'mi 'yi, yue mu 'la 'ke ‑o ‑yi 'ɛ bole ‑yrɛ ma ‑si na mɛɛ ni, 'mu nu ‑yrolɛ' 'bhɛ zan 'ɛ 'kpee›. 'Bhii‑ ‑a yɔɔndɛle ‑o ‑Waanbhaa' a 'Sɛwɛ 'ɛ gɔnɛ‑ 'la gbɛɛn‑ bhe.» ");
INSERT INTO moa_vpl VALUES ("JN7_39","073_7_39","JHN","7","39","39","Zesu 'yaa‑ ‑we 'zi *Lii 'Weŋ 'la 'ke mɛɛ 'la zan mu ‑o ‑kpaa 'yee‑ Zesu 'gbu 'yi 'mu 'yaa‑ nu 'bhɛ 'srɔɔwolɛ 'bhɛɛ‑ 'le. 'Bhɛ 'waati 'ɛ ba, 'ke ‑Waanbhaa' laa Lii 'Weŋ 'ɛ 'nalɛ‑ ‑li bhaaplɛŋ mu ni; ‑amasrɔyi 'bhɛ klɛ 'ke yaa Zesu 'silɛ‑ ‑li 'kee‑ ge 'bhɛ 'le 'tɔbhɔleya yrɛ 'ɛ ꞊nɔɔ laflɛ' 'yi. ");
INSERT INTO moa_vpl VALUES ("JN7_40","073_7_40","JHN","7","40","40","‑Zamaa' 'ɛ Zesu 'wojan‑ 'ɛ 'male‑, 'ke mɛɛ 'ke mu 'a 'pele dɔɔ: «Mɛɛ 'lɛɛ‑ 'yele‑ kpataakpa ‑o ‑Waanbhaa' ‑lɛla' janwo mi 'la 'nuza‑ ꞊woa 'bhɛ 'le!» ");
INSERT INTO moa_vpl VALUES ("JN7_41","073_7_41","JHN","7","41","41","‑A ‑lɛdo' ‑yaa pe 'zi 'ezin‑ dɔɔ: «Mɛɛ ‑Bhee Mi ‑Kpɔsɔɔ 'ɛ 'yele‑ 'kɛle‑!» 'Bhɛɛ‑ ‑a 'ke mu ‑yaa pe 'zi dɔɔ: «Mɛɛ ‑Bhee Mi ‑Kpɔsɔɔ 'ɛ sɔ dalɛ Galile 'trɛ ‑la ta ɛɛ? ");
INSERT INTO moa_vpl VALUES ("JN7_42","073_7_42","JHN","7","42","42","‑A pele laa ‑o ‑Waanbhaa' a 'Sɛwɛ 'ɛ 'yi dɔɔ Mɛɛ ‑Bhee Mi ‑Kpɔsɔɔ Krisi 'ɛ 'nu klɛlɛ 'ke ‑bhleŋgbe Davidi 'nranɛ‑ ‑la ‑le, 'bhɛɛ‑ ‑e nu dalɛ Bɛtelɛmu ‑wa 'la 'bhɛ ‑o 'yee‑ Davidi 'gbu ꞊ya ‑wa 'le bhe 'bhɛɛ‑ ta.» ");
INSERT INTO moa_vpl VALUES ("JN7_43","073_7_43","JHN","7","43","43","'Bhɛ ya 'ɛ 'yi bhe, ‑zamaa' 'ɛ ‑yiciɛnna Zesu ‑zayi'. ");
INSERT INTO moa_vpl VALUES ("JN7_44","073_7_44","JHN","7","44","44","‑Zamaa' 'ɛ 'pleŋ‑ mɛɛ 'ke mu ‑yaa zi 'bhii‑ ‑wa 'kun, 'duŋ‑ mɛɛ 'kedo‑ 'kpɔ 'laa 'kunlɛ‑. ");
INSERT INTO moa_vpl VALUES ("JN7_45","073_7_45","JHN","7","45","45","'Bhɛ ya 'ɛ 'yi, 'ke 'woo‑ *‑Waanbhaa' Gba 'Fɛ ‑Gbɛnɛ 'ɛ gooba mu 'ɛ ‑o niinale 'sraka 'lɛna ‑kuŋlii mu 'ɛ 'pegee Farizi mu 'ɛ ta. 'Bhɛɛ‑ 'ke 'mu ‑o ‑lrɔkpale dɔɔ: «‑Mɛle ‑kla 'ka 'laa 'nulɛ‑ 'kɛle‑ ɛɛ?» ");
INSERT INTO moa_vpl VALUES ("JN7_46","073_7_46","JHN","7","46","46","'Bhɛ klɛle 'tɛ, 'ke 'woo ‑Waanbhaa' Gba 'Fɛ ‑Gbɛnɛ 'ɛ gooba mu 'ɛ ‑wa ‑lɛkunle ‑o ni dɔɔ: «'Waa 'bhɛ 'yansi mɛɛ a ‑janwogbɛya yelɛ‑ ‑lido' 'bhii‑ 'yee‑ mɛɛ 'lɛɛ‑ gbɛɛn‑!» ");
INSERT INTO moa_vpl VALUES ("JN7_47","073_7_47","JHN","7","47","47","‑Ayile 'ke Farizi mu 'ɛ ‑wa pele‑ ‑o ni dɔɔ: «'Ka mu 'a ꞊twa 'bhɛɛ‑ ‑e 'ka mu ‑yinia 'ezin‑ ɛɛ? ");
INSERT INTO moa_vpl VALUES ("JN7_48","073_7_48","JHN","7","48","48","'Kaa ꞊maa dɔɔ 'waa ‑kuŋlii mu 'ɛ do 'kpɔ 'e ꞊kpaa ‑a ‑yi, taa‑ Farizi mu 'ɛ do 'kpɔ 'e ꞊kpaa ‑a ‑yi ɛɛ? ");
INSERT INTO moa_vpl VALUES ("JN7_49","073_7_49","JHN","7","49","49","'Bhɛɛ‑ ‑zamaa' 'la ‑woo 'kpa zii' ‑a ‑yi, waa Moizi a 'Toŋ mu 'ɛ dɔ, ‑o 'kpɛn ‑o 'ke 'daŋgan ma mɛɛ mu 'le!» ");
INSERT INTO moa_vpl VALUES ("JN7_50","073_7_50","JHN","7","50","50","'Bhɛɛ‑ 'duŋ‑, 'woo‑ Farizi mu 'la 'yaa‑ ye ‑o ‑yaa ‑o do 'sii Nikodɛmu; 'bhɛ ‑le ‑ja 'elwale gban ‑sɔ Zesu ba. 'Bhɛ pe ‑o ni dɔɔ: ");
INSERT INTO moa_vpl VALUES ("JN7_51","073_7_51","JHN","7","51","51","«‑Kɔɔa' 'toŋ 'ɛ ta, ‑kɔɔ' sɔ ‑kpan baale mɛɛ do ta, 'ke ‑kɔɔ' 'laa ‑a ‑liijan' malɛ 'elwale 'pe ɛɛ? 'Bhɛɛ‑ 'kee‑ ‑za 'la ꞊kla, 'ke ‑kɔɔ' 'laa 'bhɛ dɔlɛ 'pe ɛɛ?» ");
INSERT INTO moa_vpl VALUES ("JN7_52","073_7_52","JHN","7","52","52","'Bhɛ klɛle 'tɛ, 'ke ‑wa pele‑ 'bhɛ ni dɔɔ: «'Bhi da 'ezin‑ Galile 'klɛɛn 'yi ‑a ma ɛɛ? Ge ‑Waanbhaa' a 'Sɛwɛ 'yiglin‑ 'elrele doo, 'e nu ‑a yelɛ 'bhii‑ ‑Waanbhaa' ‑lɛla' janwo mi 'kedo‑ 'kpɔ 'laa dalɛ ‑lido' Galile 'klɛɛn 'yi.» ");
INSERT INTO moa_vpl VALUES ("JN7_53","073_7_53","JHN","7","53","53","'Bhɛ blaan, ‑o yanle ‑janwolele, ‑o 'kpɛn ‑o ‑wlɛnna, 'bhɛɛ‑ 'ke ‑o jilale ‑o ba ‑lɛ ma do do. ");
INSERT INTO moa_vpl VALUES ("JN8_1","073_8_1","JHN","8","1","1","'Duŋ‑ Zesu ‑ja ‑o ‑yaa vlɛ gɔɔn 'la sii ‹Olivi diiŋ vlɛ gɔɔn› 'ɛ 'bhɛ 'wiiŋ‑. ");
INSERT INTO moa_vpl VALUES ("JN8_2","073_8_2","JHN","8","2","2","'Bhɛ ta tooklin‑ yi 'ɛ 'le zrwan 'tutu 'ɛ zi, 'kee‑ niinale‑Waanbhaa' Gba 'Fɛ ‑Gbɛnɛ 'ɛ ꞊la Zeruzalɛmu ‑wa 'ɛ ta. 'Bhɛɛ‑ 'ke mɛɛ mu 'ɛ 'kpɛn 'nule ‑a ‑din. ‑Ayile, 'kee‑ yaale' 'bhɛɛ‑ 'ke ‑yoo daanle 'sanle. ");
INSERT INTO moa_vpl VALUES ("JN8_3","073_8_3","JHN","8","3","3","Zesu 'yaa‑ 'bhɛ klɛ 'zi 'waati 'la ba, 'ke 'Toŋ Daan mu 'ɛ 'pegee Farizi mu 'ɛ ‑o nule‑ gwlɛn ‑wɛɛ le do 'le 'a ta. ‑O pe dɔɔ ‑o 'yee‑ le 'ɛ ꞊kwan 'gwlaan‑ ‑la. ‑O nule 'bhɛ le 'ɛ 'le, 'ke ‑wa dulale ‑o 'kpɛn 'pleŋ‑. ");
INSERT INTO moa_vpl VALUES ("JN8_4","073_8_4","JHN","8","4","4","'Bhɛɛ‑ 'ke ‑wa pele‑ Zesu ni dɔɔ: «'O Daan mi, 'o le 'lɛɛ‑ ꞊kwan 'gwlaan‑ ‑la. ");
INSERT INTO moa_vpl VALUES ("JN8_5","073_8_5","JHN","8","5","5","Moizi a 'Toŋ 'ɛ ta, ‑ya ꞊pia 'o ni dɔɔ 'o kpoti 'pa 'bhɛ le ‑glɔɔn mu 'lɛɛ‑ ma 'bhɛɛ‑ 'woo‑ dɛ, 'bhɛɛ‑ 'bhi pe 'bhɛ 'yi 'nale‑ ɛɛ?» ");
INSERT INTO moa_vpl VALUES ("JN8_6","073_8_6","JHN","8","6","6","‑O 'bhɛ 'pia‑ 'bhɛ gbɛɛn‑ bhe, 'kooko‑ ‑o ‑jan bhee kpalaa' ‑a 'lɛɛ, 'bhɛɛ‑ ‑o sɔ ‑a 'kunle ‑a 'gbu 'liiwli‑ ma. 'Duŋ‑ Zesu 'e ŋgblo kulale, 'kee‑ 'sɛwɛdɛle 'sanle 'trɛ ma ‑a gbɛ ‑nɛbhɛ' do 'le. ");
INSERT INTO moa_vpl VALUES ("JN8_7","073_8_7","JHN","8","7","7","‑O ‑yaa ‑a matɛdɔ 'zi ‑a ‑lrɔkpale 'le bhe, 'ke ‑ya ŋgblo ‑lawlɛnle, 'bhɛɛ‑ 'ke ‑yoo ‑lrɔkpale dɔɔ: «'Ke 'ka 'pleŋ‑ mɛɛ 'la zan 'gbu laa ‑za 'yɔɔ‑ klɛlɛ ‑lido', 'bhɛ zan kpoti 'ɛ 'pa ‑a ma 'elwale 'pe.» ");
INSERT INTO moa_vpl VALUES ("JN8_8","073_8_8","JHN","8","8","8","'Bhɛ blaan, 'ke Zesu 'e ŋgblo kulale, 'bhɛɛ‑ 'kee‑ 'sɛwɛdɛle 'sanle 'trɛ ma 'ezin‑. ");
INSERT INTO moa_vpl VALUES ("JN8_9","073_8_9","JHN","8","9","9","‑O 'bhɛ ‑jan 'ɛ 'male‑, ('bhɛ 'lalawoa ‑o nii‑ 'ɛ ma) 'ke ‑o 'kpɛn jilale do do 'ke 'bhɛ san ‑o ba 'gwlaan‑ gblaan mu 'ɛ ma, 'ke 'bhɛ ge 'tɛnlɛ‑ ‑waa' ‑zwannɛ mu 'ɛ ma. 'Bhɛɛ‑ Zesu do ‑kplɛn 'kpɔ 'pegee 'yee‑ le 'ɛ 'wole‑ ꞊bwa ‑a nɔɔ‑ ye. ");
INSERT INTO moa_vpl VALUES ("JN8_10","073_8_10","JHN","8","10","10","'Bhɛ klɛlɛ 'tɛ, 'ke Zesu 'e ŋgblo ‑lawlɛnle, 'bhɛɛ‑ 'kee‑ 'yee‑ le 'ɛ 'lrɔkpale dɔɔ: «Mɛɛ 'la zan mu ‑yaa ‑la 'zi 'e ta, ‑woo 'naa ɛɛ? Mɛɛ 'kedo‑ 'kpɔ 'laa bolɛ 'ke 'bhɛ ‑kpan baalɛ 'e ta ɛɛ?» ");
INSERT INTO moa_vpl VALUES ("JN8_11","073_8_11","JHN","8","11","11","'Yee‑ le 'ɛ pe Zesu ni dɔɔ: «'Ɔn ɔn, Mɛɛzan, mɛɛ 'kedo‑ 'kpɔ 'laa bolɛ 'ke 'bhɛ ‑kpan balaa' 'ŋ ta.» 'Bhɛɛ‑ Zesu pe ‑a ni dɔɔ: «'Mi 'duŋ‑ 'naa nu ‑kpan baalɛ 'e ta 'ezin‑, 'e sɔ gele‑ 'e ba ‑lɛ ma; 'duŋ‑ 'yaa ‑za 'yɔɔ‑ ‑bhɛɛke' do 'kpɔ klɛlɛ 'ezin‑.» ");
INSERT INTO moa_vpl VALUES ("JN8_12","073_8_12","JHN","8","12","12","'Bhɛ blaan, 'ke Zesu ‑janwole 'ezin‑ mɛɛ mu 'ɛ 'ni dɔɔ: «'Mi ‑le 'ke 'drunyan 'ɛ ta 'tɛbhile 'le. 'Ke mɛɛ 'la zan ‑dwa 'ŋ zi, 'tɛbhile 'la bole ‑yrɛ ma ‑si na mɛɛ ni 'bhɛ zan nu 'bhɛ 'srɔɔwolɛ, 'bhɛɛ‑ yaa nu 'taawolɛ ‑gblo 'yi ‑titi.» ");
INSERT INTO moa_vpl VALUES ("JN8_13","073_8_13","JHN","8","13","13","'Bhɛ klɛle 'tɛ, 'ke Farizi mu 'ɛ ‑wa pele‑ ‑a ni 'kaa: «'E do ‑kplɛn kpɔ ‑le 'srɛya‑ klɛ 'zi 'e 'gbu ba zayi', 'bhɛɛ‑ 'e ‑jan 'la 'wo zii' 'e 'gbu ma, 'bhɛ 'laa ‑o 'ke wlan 'le.» ");
INSERT INTO moa_vpl VALUES ("JN8_14","073_8_14","JHN","8","14","14","'Bhɛ ya 'ɛ 'yi 'tɛ, 'ke Zesu 'a zikpale ‑o ni dɔɔ: «'Ali‑ 'ke 'ŋ 'yoo‑ 'ŋ 'gbu 'srɛya‑ klɛ 'zi 'ŋ 'gbu ba zayi', 'bhɛ ‑o 'ke wlan 'le. ‑Amasrɔyi 'mi 'ŋ dayrɛ 'pegee 'ŋ geyrɛ dɔ. 'Duŋ‑ 'ka mu laa 'mi dayrɛ 'pegee 'ŋ geyrɛ dɔ. ");
INSERT INTO moa_vpl VALUES ("JN8_15","073_8_15","JHN","8","15","15","'Ka mu, 'ka mɛɛ mu 'kitikan bhaaplɛŋ 'kungbɛya ‑la ma; 'duŋ‑ 'mi 'laa mɛɛ 'kedo‑ 'kpɔ 'kitikan. ");
INSERT INTO moa_vpl VALUES ("JN8_16","073_8_16","JHN","8","16","16","'Bhɛɛ‑ 'duŋ‑, 'ke 'ŋ mɛɛ mu 'kitikaan, 'an 'kiti 'ɛ ‑yoo wlan ma 'kiti ‑la ‑le. ‑Amasrɔyi 'ŋ do ‑kplɛn 'laa ‑o mɛɛ mu 'kitikan zii'; 'duŋ‑ 'ŋ Dɛ 'la 'bhɛ 'ŋ 'winbwa‑ 'bhɛ ‑o 'ŋ ba 'ezin‑. ");
INSERT INTO moa_vpl VALUES ("JN8_17","073_8_17","JHN","8","17","17","‑A yɔɔndɛle ‑o 'kaa‑ 'toŋ 'sɛwɛ 'ɛ 'yi dɔɔ 'ke mɛɛ plɛ ꞊kla ‑za do 'srɛ 'le, ‑wa pe dɔɔ 'bhɛ ‑za 'ɛ 'bhɛ ‑o 'ke wlan 'le. ");
INSERT INTO moa_vpl VALUES ("JN8_18","073_8_18","JHN","8","18","18","'Mi ‑o 'srɛya‑ klɛ 'zi 'ŋ 'gbu ba zayi', 'bhɛɛ‑ 'ŋ Dɛ 'la 'bhɛ 'ŋ 'winbwa‑ 'bhɛ ‑o 'ŋ 'srɛya‑ klɛ 'zi 'ezin‑.» ");
INSERT INTO moa_vpl VALUES ("JN8_19","073_8_19","JHN","8","19","19","'Bhɛ klɛle 'tɛ, 'ke ‑o Zesu 'lrɔkpale dɔɔ: «'E Dɛ ‑o 'naa ‑a ma ɛɛ?» 'Bhɛɛ‑ Zesu 'bhɛ zikpaa‑ ‑o ni 'kaa: «'Ka 'laa 'mi dɔ, 'bhɛɛ‑ 'ka 'laa 'ŋ Dɛ dɔ 'ezin‑. 'Ke 'ka 'mi dɔ bi, 'ka 'yaa‑ nu 'ŋ Dɛ dɔlɛ 'ezin‑.» ");
INSERT INTO moa_vpl VALUES ("JN8_20","073_8_20","JHN","8","20","20","Zesu 'bhɛ ‑jan mu 'ɛ ꞊woa 'ke ‑yoo mɛɛ mu 'ɛ daan 'zi bhla 'la ba ‑Waanbhaa' Gba 'Fɛ ‑Gbɛnɛ 'ɛ ꞊la. ‑A dulale ‑yaa ‑koonɛ mu 'la ‑o ‑Waanbhaa' gbapɛ mu 'ɛ bɔ 'mu 'yi 'mu ‑din. 'Bhɛɛ‑ 'duŋ‑, mɛɛ 'kedo‑ 'kpɔ 'laa ‑a 'kunlɛ‑, ‑amasrɔyi ‑yaa' pɛ 'waati 'ɛ 'bhɛ 'laa bhɔlɛ ‑li bi. ");
INSERT INTO moa_vpl VALUES ("JN8_21","073_8_21","JHN","8","21","21","Zesu pe ‑o ni 'ezin‑ dɔɔ: «'Ŋ 'yoo‑ zan gelɛ, 'bhɛɛ‑ 'ka nu 'ŋ ziglinlɛ. 'Duŋ‑ 'ka mu nu galɛ 'kaa‑ ‑za 'yɔɔ‑ 'ɛ 'yi. 'Ka 'laa sɔ gele‑ 'ŋ ge 'zi yrɛ 'la ꞊nɔɔ 'bhɛ ꞊nɔɔ.» ");
INSERT INTO moa_vpl VALUES ("JN8_22","073_8_22","JHN","8","22","22","‑E 'bhɛ 'pelawoa bhe, 'ke Zuufu mu 'ɛ ‑wa pele‑ 'eke‑ ni dɔɔ: «Taa‑ ‑e gele‑ ‑a 'gbu dɛlɛ ɛɛ? ‑Amasrɔyi ‑ya pe 'zi dɔɔ: ‹'Ŋ gele‑ yrɛ 'la ꞊nɔɔ, 'ka 'laa sɔ gele‑ 'bhɛ ꞊nɔɔ.›» ");
INSERT INTO moa_vpl VALUES ("JN8_23","073_8_23","JHN","8","23","23","'Bhɛ klɛle 'tɛ, 'ke Zesu 'a zikpale ‑o ni dɔɔ: «'Ka mu da 'trɛ ta ‑gɛ, 'duŋ‑ 'mi da laanima. 'Ka mu ‑o 'ke 'drunyan 'lɛɛ‑ 'bhɛ a pɛ 'le, 'duŋ‑ 'mi 'laa ‑o 'ke 'drunyan 'lɛɛ‑ 'bhɛ a pɛ 'le. ");
INSERT INTO moa_vpl VALUES ("JN8_24","073_8_24","JHN","8","24","24","'Bhɛla‑ ‑zayile, 'mi pe 'ka ni dɔɔ 'ka nu galɛ 'kaa‑ ‑za 'yɔɔ‑ mu 'ɛ 'yi. ‑Amasrɔyi 'ke 'ka 'laa 'ka 'kpalɛ‑ ‑a ‑yi 'bhii‑ 'an ꞊pia dɔɔ: ‹'Ŋ 'yoo‑ 'ke mɛɛ 'la zan 'Ŋ 'yoo 'ke 'bhɛ 'le kpataakpa.› 'Ka nu galɛ 'kaa ‑za 'yɔɔ‑ mu 'ɛ 'yi.» ");
INSERT INTO moa_vpl VALUES ("JN8_25","073_8_25","JHN","8","25","25","'Bhɛ klɛle 'tɛ, 'ke ‑o Zesu 'lrɔkpale dɔɔ: «'Bhɛ bhla 'ɛ ba, ‑dele 'bhi 'le ɛɛ?» Zesu 'a 'lɛkwan ‑o ni dɔɔ: «‑A 'san ‑a zisan' bhla zi 'ɛ ma, 'ŋ 'yoo‑ 'ke mɛɛ ‑glɔɔn 'la 'le, 'ŋ 'bhɛ 'pia‑ 'ka ni. ");
INSERT INTO moa_vpl VALUES ("JN8_26","073_8_26","JHN","8","26","26","'Ŋ sɔ ‑jan ‑bebe 'wole 'ka ba zayi', 'bhɛɛ‑ 'ŋ sɔ 'ka 'kitikanle ‑za ‑bebe ma. 'Duŋ‑ mɛɛ 'la zan 'mi 'winbwa‑ 'bhɛ wlan ‑la pe, 'bhɛɛ‑ 'ŋ ‑za 'la ‑daanna ‑a ba, 'ŋ 'bhɛɛ‑ 'wo zii' 'drunyan 'lɛɛ‑ 'yi mɛɛ mu 'ɛ ni.» ");
INSERT INTO moa_vpl VALUES ("JN8_27","073_8_27","JHN","8","27","27","Zuufu mu 'ɛ waa 'bhɛ ‑jan 'ɛ 'yimalɛ 'kaa ‑e ‑yaa ‑we 'zi ‑a Dɛ ‑Waanbhaa' ‑la ‑le. ");
INSERT INTO moa_vpl VALUES ("JN8_28","073_8_28","JHN","8","28","28","‑Ayile 'ke Zesu 'a 'pele ‑o ni dɔɔ: «'Ke 'ka Bhaaplɛŋ Gbe 'ɛ 'lawlɛnna 'waati 'la ba, 'ka nu ‑a 'yaangolɛ 'bhii‑ 'mi ‑le 'ke ‹'Ŋ 'yoo‑ kpataakpa mɛɛ 'la zan 'Ŋ 'yoo 'ke 'bhɛɛ‑ 'le›. 'Ka nu 'a 'yaangolɛ 'ezin‑ 'bhii‑ 'naa ‑za 'kedo‑ 'kpɔ klɛ 'ŋ 'gbu 'kɔɔ: 'ŋ Dɛ ‑Waanbhaa' 'ŋ ‑daanna ‑za 'la 'le, 'ŋ 'yoo‑ 'bhɛɛ‑ 'wo zii' 'ka ni 'te. ");
INSERT INTO moa_vpl VALUES ("JN8_29","073_8_29","JHN","8","29","29","Mɛɛ 'la zan 'ŋ 'winbwa‑ 'bhɛ ‑o 'ŋ ba; 'bhɛ 'laa 'ŋ do ‑kplɛnnɛ' 'tolɛ‑ a nɔɔ‑ 'le, ‑amasrɔyi ‑za 'la sɔ ‑a ni 'ŋ 'bhɛɛ‑ klɛ 'taŋii.» ");
INSERT INTO moa_vpl VALUES ("JN8_30","073_8_30","JHN","8","30","30","Zesu 'yaa‑ ‑janwo' zii' 'bhɛ gbɛɛn‑ bhe, 'ke mɛɛ ‑bebe ‑o 'kpale 'a ‑yi. ");
INSERT INTO moa_vpl VALUES ("JN8_31","073_8_31","JHN","8","31","31","Zesu pe Zuufu mu 'la ‑woo ‑kpaa ‑a ‑yi 'mu ni dɔɔ: «'Ke 'ka blɔɔle ꞊bwa 'ŋ 'wojan‑ mu 'ɛ ma, 'ka nu klɛlɛ 'an ‑klaŋlanɛ mu ‑zeze mu 'gbu ‑la ‑le. ");
INSERT INTO moa_vpl VALUES ("JN8_32","073_8_32","JHN","8","32","32","'Bhɛ klɛgbɛya 'ɛ 'yi, 'ka nu wlan dɔlɛ ‑Waanbhaa' ba zayi', 'bhɛɛ‑ 'ke 'ka 'bhɛ wlan 'ɛ ‑dwa 'bhɛ nu 'ka bolɛ 'ka 'gbu ma.» ");
INSERT INTO moa_vpl VALUES ("JN8_33","073_8_33","JHN","8","33","33","'Bhɛ klɛle 'tɛ, 'ke ‑wa pele‑ Zesu ni dɔɔ: «'O mɔɔ ‑o 'ke *Abraamu 'srɛ mu 'le, 'waa klɛlɛ ‑lido' mɛɛ 'kedo‑ 'kpɔ a lu mu 'le. ‑E ‑kla 'nale‑ 'bhɛɛ‑ 'ya 'pe zii' 'o ni dɔɔ: ‹'Ka nu bolɛ 'ka 'gbu ma ɛɛ?›» ");
INSERT INTO moa_vpl VALUES ("JN8_34","073_8_34","JHN","8","34","34","‑Ayile 'ke Zesu 'a zikpale ‑o ni dɔɔ: «'Mi pe 'ka ni 'ŋ 'sɔwɛɛ‑ ma dɔɔ 'ke mɛɛ 'oo mɛɛ 'la zan ‑za 'yɔɔ‑ klɛ, 'bhɛ zan ‑o 'ke ‑za 'yɔɔ a lu 'le. ");
INSERT INTO moa_vpl VALUES ("JN8_35","073_8_35","JHN","8","35","35","'Bhɛɛ‑ 'ka 'gbu 'a 'yaango‑ 'bhii‑ waa lu do kpa 'taŋii ‑yoo 'fɛ 'la ꞊la 'bhɛ 'fa ‑la mu 'ɛ ba. 'Duŋ‑ 'fɛzan‑ 'ɛ gbe 'ɛ, 'bhɛ ‑o 'yee‑ 'fɛ 'ɛ ꞊la mu 'ɛ baan' 'le 'taŋii. ");
INSERT INTO moa_vpl VALUES ("JN8_36","073_8_36","JHN","8","36","36","'Ke *Bhaaplɛŋ Gbe 'ɛ 'ka ꞊twa 'ka 'gbu ma, 'ka nu klɛlɛ ꞊klɔ mu ‑zeze 'gbu 'le. ");
INSERT INTO moa_vpl VALUES ("JN8_37","073_8_37","JHN","8","37","37","'Mi 'a 'yaango‑ 'bhii‑ 'ka ‑o 'ke Abraamu 'srɛ mu 'le. 'Duŋ‑ 'ka mu ‑a zi' 'bhii‑ 'ka 'mi dɛ, ‑amasrɔyi 'ka 'laa ‑o dɔ 'zi 'ŋ 'wojan‑ mu 'ɛ ꞊la. ");
INSERT INTO moa_vpl VALUES ("JN8_38","073_8_38","JHN","8","38","38","'Ŋ ‑za 'la ꞊ya 'ŋ Dɛ 'kɔɔ, 'ŋ 'yoo‑ 'bhɛɛ‑ ‑janwo' zii' 'ka ni. 'Bhɛɛ‑ 'duŋ‑ 'ka mu, 'ka ‑jan 'la ꞊maa 'ka dɛ ta, 'ka ‑o 'bhɛɛ‑ klɛ 'zi.» ");
INSERT INTO moa_vpl VALUES ("JN8_39","073_8_39","JHN","8","39","39","'Bhɛ klɛle 'tɛ, 'ke ‑wa ‑lɛkunle Zesu ni dɔɔ: «Abraamu ‑le 'o mɔɔ ‑gbɔɔ 'le.» 'Bhɛɛ‑ Zesu 'a zikpale ‑o ni dɔɔ: «'Ke 'ka 'yaa‑ klɛ bi Abraamu 'srɛ mu 'le kpataakpa, 'ka 'yaa‑ nu Abraamu klɛza mu 'ɛ klɛlɛ. ");
INSERT INTO moa_vpl VALUES ("JN8_40","073_8_40","JHN","8","40","40","'Ka ‑o ‑a zi 'bhii‑ 'ka 'mi dɛ ‑zɔn, 'mi 'la 'ŋ wlan 'la ‑daanna ‑Waanbhaa' ba 'bhɛɛ‑ 'ke 'ŋ 'bhɛ ꞊pia 'ka ni bhe. Abraamu 'duŋ‑ laa 'bhɛ 'yansi za klɛlɛ! ");
INSERT INTO moa_vpl VALUES ("JN8_41","073_8_41","JHN","8","41","41","'Ka ‑o 'ka dɛ klɛza mu ‑la klɛ 'zi.» 'Bhɛ 'yi, 'ke ‑wa zikpale Zesu ni dɔɔ: «'O mɔɔ laa ‑o 'ke ‑naazinɛ mu 'le, 'o Dɛ ‑o do 'kpɔ, 'bhɛ ‑le 'ke ‑Waanbhaa' 'le.» ");
INSERT INTO moa_vpl VALUES ("JN8_42","073_8_42","JHN","8","42","42","Zesu pe ‑o ni 'ezin‑ dɔɔ: «'Kee‑ 'kpa bi ‑Waanbhaa' ‑o 'ka Dɛ 'gbu 'le bhe, 'ŋ ‑za ‑yaa nu 'sɔlɛ‑ 'ka ni. ‑Amasrɔyi 'ŋ ꞊daa 'yela‑ ba, 'bhɛɛ‑ 'ŋ 'yoo‑ ‑gɛ 'yela‑ 'srɔyi. 'Naa 'nulɛ‑ 'ŋ 'gbu ma, 'duŋ‑ 'yele‑ 'mi 'winbwa‑. ");
INSERT INTO moa_vpl VALUES ("JN8_43","073_8_43","JHN","8","43","43","‑Mɛle ‑kla 'bhɛɛ‑ 'ka 'laa ‑o 'ŋ 'wojan‑ mu 'ɛ 'yima zii' ɛɛ? ‑Amasrɔyi 'ka 'laa ‑o ‑a zi 'ke 'ka dɔ 'ŋ 'wojan‑ mu 'ɛ ꞊la. ");
INSERT INTO moa_vpl VALUES ("JN8_44","073_8_44","JHN","8","44","44","'Ka dɛ ‑le 'ke ‑Setran' 'le, 'bhɛɛ‑ 'ka ‑o ‑a zi 'ke 'kaa zru maza ‑la klɛ. ‑Yoo 'taŋii mɛɛ dɛ mi 'le. Yaa dulalɛ ‑lido' wlan ta, ‑amasrɔyi wlan do 'kpɔ laa ‑o ‑a 'kpee ‑titi. 'Ke ‑yoo bhla pe 'zi, ‑e ‑janwo' ‑a 'gbu dɔgbɛya 'ɛ 'bhɛɛ‑ zi; ‑amasrɔyi ‑yoo 'ke bhla pe mi 'le, 'bhɛɛ‑ 'yele‑ 'ke bhla 'ɛ dɛ 'le. ");
INSERT INTO moa_vpl VALUES ("JN8_45","073_8_45","JHN","8","45","45","'Mi 'duŋ‑, 'mi ‑o wlan ‑la 'pe zii' 'ka ni, 'bhɛla‑ ‑yile 'ka 'laa ‑o 'ka 'kpale 'mi 'yi. ");
INSERT INTO moa_vpl VALUES ("JN8_46","073_8_46","JHN","8","46","46","'Ka ba, 'ka ‑dele sɔ a zrɔnle‑ dɔɔ 'ŋ ‑za 'yɔɔ ꞊kla ɛɛ? 'Bhɛɛ‑ 'ke 'ŋ 'yoo‑ wlan pe 'zi, ‑mɛla ma 'ka 'laa ‑o 'ka 'kpale 'ŋ 'yi ɛɛ? ");
INSERT INTO moa_vpl VALUES ("JN8_47","073_8_47","JHN","8","47","47","'Ke mɛɛ 'la zan da ‑Waanbhaa' ba, 'bhɛ zan 'e 'trɔnkpa‑ ‑yaa' ‑jan mu 'ɛ ꞊la 'elrele. 'Duŋ‑ 'ka mu laa da ‑Waanbhaa' ba, 'bhɛla‑ ‑yile 'ka 'laa ‑o dɔ 'zi ‑a ‑la 'ke 'ka 'ka 'trɔnkpa 'ŋ ni 'elrele.» ");
INSERT INTO moa_vpl VALUES ("JN8_48","073_8_48","JHN","8","48","48","'Bhɛ klɛle 'tɛ, 'ke Zuufu mu 'ɛ ‑wa ‑lɛkunle Zesu ni dɔɔ: «'Zoo 'laa ‑o 'o zi 'ke 'wa pe 'kaa 'yoo‑ 'ke Samari mi 'le, 'bhɛ 'pegee lii ‑yɔɔ do ‑o 'e zi ɛɛ?» ");
INSERT INTO moa_vpl VALUES ("JN8_49","073_8_49","JHN","8","49","49","Zesu 'bhɛ zikpaa‑ ‑o ni dɔɔ: «Lii ‑yɔɔ laa ‑o 'ŋ zi. 'Duŋ‑ 'ŋ 'yoo‑ 'ŋ Dɛ ‑lɛdɔ' 'zi ‑a ma, 'bhɛɛ‑ 'ka mu laa ‑o dɔle‑ ‑a ‑la 'ke 'ka 'mi 'lɛdɔ‑ ‑a ma. ");
INSERT INTO moa_vpl VALUES ("JN8_50","073_8_50","JHN","8","50","50","'Mi, 'mi 'laa ‑o 'ŋ 'gbu 'tɔbhɔyrɛ ‑glin 'zi. Mɛɛ do 'kpɔ ‑le 'tɔbhɔleya ‑glin 'zi 'mi ni, 'bhɛɛ‑ 'bhɛ ‑le 'mi ta janwo. ");
INSERT INTO moa_vpl VALUES ("JN8_51","073_8_51","JHN","8","51","51","'Mi pe 'ka ni 'ŋ 'sɔwɛɛ‑ ma dɔɔ: 'ke mɛɛ 'la zan 'ŋ 'wojan‑ mu 'ɛ 'klɔsikwan 'bhɛ zan laa nu galɛ ‑titi.» ");
INSERT INTO moa_vpl VALUES ("JN8_52","073_8_52","JHN","8","52","52","'Bhɛ klɛle 'tɛ, 'ke Zuufu mu 'ɛ ‑wa pele‑ Zesu ni dɔɔ: «'O 'kpale ‑o ‑a ‑yi ‑zɔn 'tɛ 'bhii‑ lii ‑yɔɔ' do ‑o 'e zi! *Abraamu ‑gaa, 'bhɛɛ‑ ‑Waanbhaa' ‑lɛla' janwo mu 'ɛ ‑gaa, 'bhɛɛ‑ 'mi pe dɔɔ: ‹'Ke mɛɛ 'la zan 'e 'wojan‑ mu 'ɛ 'klɔsikwan, 'bhɛ zan laa nu galɛ ‑titi.› ");
INSERT INTO moa_vpl VALUES ("JN8_53","073_8_53","JHN","8","53","53","'O ‑gbɔɔ Abraamu ‑gaa, 'bhi 'kpee ma 'e gblaan ‑yiya' 'bhɛ ni ɛɛ? 'Bhɛɛ‑ ‑Waanbhaa' ‑lɛla' janwo mu 'la ‑gaa bhe 'ezin‑, 'yoo‑ 'e 'gbu klɛ 'zi mɛɛ ‑glɔɔn 'ɛ ‑dela ‑le ɛɛ?» ");
INSERT INTO moa_vpl VALUES ("JN8_54","073_8_54","JHN","8","54","54","'Bhɛ klɛle 'tɛ, 'ke Zesu 'a zikpale ‑o ni dɔɔ: «'Ke 'ŋ 'yoo‑ 'ŋ 'gbu 'tɔbhɔ zii' bi, 'an 'tɔbhɔleya 'ɛ ‑yoo bhaama. 'Duŋ‑ mɛɛ 'la zan ‑o 'ŋ 'tɔbhɔ zii', 'bhɛ ‑le 'ke 'ŋ Dɛ 'le, 'bhɛɛ‑ 'kaa pe 'bhɛɛ‑ ma dɔɔ: 'O Dɛ! ");
INSERT INTO moa_vpl VALUES ("JN8_55","073_8_55","JHN","8","55","55","'Bhɛɛ‑ 'duŋ‑, 'ka 'laa ‑a dɔ. 'Mi 'duŋ‑ 'a dɔ. 'Ke 'an 'pe bi 'kaa 'naa ‑a dɔ, 'ŋ 'yaa‑ nu klɛlɛ 'ke bhlanii‑ 'le 'bhii‑ 'ka mu gbɛɛn‑. 'Duŋ‑ 'mi 'a dɔ kpataakpa, 'bhɛɛ‑ 'mi ‑yaa ‑jan mu 'ɛ 'klɔsikun. ");
INSERT INTO moa_vpl VALUES ("JN8_56","073_8_56","JHN","8","56","56","'Ka ‑gbɔɔ Abraamu zrukpalaa 'egbɛnɛle ‑e ‑yaa nu 'ŋ 'nu yi 'ɛ 'yelawolɛ bhe 'bhɛ ‑zayi'; ‑e 'bhɛ yi 'ɛ ꞊ya 'bhɛɛ‑ ‑a zrukpalaa.» ");
INSERT INTO moa_vpl VALUES ("JN8_57","073_8_57","JHN","8","57","57","'Bhɛ klɛle 'tɛ, 'ke Zuufu mu 'ɛ ‑wa pele‑ ‑a ni dɔɔ: «'E lɛɛ ‑lii 'laa lɛɛ mia plɛ bhɛ vu bhɔlɛ ‑li, 'bhɛɛ‑ 'e pe dɔɔ 'e Abraamu ꞊ya ɛɛ?» ");
INSERT INTO moa_vpl VALUES ("JN8_58","073_8_58","JHN","8","58","58","Zesu pe ‑o ni dɔɔ: «'Mi pe 'ka ni 'ŋ 'sɔwɛɛ‑ ma dɔɔ 'sani‑ Abraamu 'yale‑ pleŋ‑, 'mi 'yaa‑ gban 'ŋ 'yrɛ ma 'bhɛ 'lɛɛ.» ");
INSERT INTO moa_vpl VALUES ("JN8_59","073_8_59","JHN","8","59","59","'Bhɛla‑ ‑yile 'tɛ, 'ke ‑o kpoti mu 'sile, 'bhɛɛ‑ 'ke ‑wa pele‑ dɔɔ ‑o 'mu 'pale 'a ma. 'Duŋ‑ Zesu 'nile‑ ‑o pleŋ‑, 'kee‑ 'pwɛle ‑Waanbhaa' Gba 'Fɛ ‑Gbɛnɛ 'ɛ ꞊la, 'bhɛɛ‑ 'kee‑ jilale. ");
INSERT INTO moa_vpl VALUES ("JN9_1","073_9_1","JHN","9","1","1","Zesu 'kan bhla 'ɛ zi, 'kee‑ mɛɛ do yele‑: 'kee‑ 'san ‑o 'bhɛ ya, 'bhɛ 'yrɛ 'wile‑ ‑yaa. ");
INSERT INTO moa_vpl VALUES ("JN9_2","073_9_2","JHN","9","2","2","Zesu a ‑klaŋlanɛ mu 'ɛ ‑wa ‑lrɔkpaa dɔɔ: «'O Daan mi, ‑mɛle ‑kla 'bhɛɛ‑ ‑o mɛɛ 'lɛɛ‑ 'yaa‑ ‑a ‑yrɛ 'wile‑ 'le ɛɛ? 'Bhɛ ‑daa ‑a 'gbu ‑za 'yɔɔ‑ mu 'la ꞊kla 'mu ‑la ba taa‑, 'bhɛ ‑daa ‑a yapɛ mu 'ɛ 'mu ‑za 'yɔɔ‑ 'la ꞊kla 'bhɛ ‑la ba ɛɛ?» ");
INSERT INTO moa_vpl VALUES ("JN9_3","073_9_3","JHN","9","3","3","Zesu 'bhɛ zikpaa‑ ‑o ni dɔɔ: «‑Wa ‑yaa ‑a ‑yrɛ 'wile‑ 'le, 'bhɛ 'laa dalɛ ‑a 'gbu a ‑za 'yɔɔ‑ mu 'ɛ ba, 'bhɛ 'pegee 'bhɛ 'laa dalɛ 'ezin‑ ‑a dɛ 'pegee ‑a nɛɛ a ‑za 'yɔɔ‑ mu 'ɛ ba; 'duŋ‑ ‑wa ‑yaa 'bhɛ gbɛɛn‑ bhe, 'kooko‑ ‑o sɔ ‑Waanbhaa' a ‑glɔɔya' 'ɛ 'yele kpataakpa. ");
INSERT INTO moa_vpl VALUES ("JN9_4","073_9_4","JHN","9","4","4","'Waati 'la ba 'ke ‑yrekpaa' 'tɛbhile ‑o ‑a nɔɔ‑ ‑li, ‑yoo 'ke ‑za 'le 'ke 'ŋ mɛɛ 'la zan 'ŋ 'winbwa‑ 'ŋ 'bhɛ a ye mu 'ɛ 'wo. 'Kebhlaale, 'ke ‑bi ꞊pwa 'waati 'la ba mɛɛ 'kedo‑ 'kpɔ 'laa nu 'sɔlɛ‑ yewole. ");
INSERT INTO moa_vpl VALUES ("JN9_5","073_9_5","JHN","9","5","5","'Ŋ 'yoo‑ 'waati 'la ba 'drunyan 'lɛɛ‑ 'yi, 'ŋ 'yoo‑ 'drunyan 'yi mu 'ɛ waa 'tɛbhile ‑la ‑le.» ");
INSERT INTO moa_vpl VALUES ("JN9_6","073_9_6","JHN","9","6","6","Zesu 'yanle 'bhɛ ‑jan mu 'ɛ 'wolele, 'ke ‑ya ‑liile' 'klaale 'trɛ ma, 'kee‑ ‑pɛɛ sanɛ‑ klɛle‑ 'bhɛ 'le. 'Bhɛɛ‑ 'kee‑ 'bhɛ ‑pɛɛ 'ɛ ‑glɔɔle' 'yee‑ ‑yrɛ 'wi mi 'ɛ 'yrɛ ta. ");
INSERT INTO moa_vpl VALUES ("JN9_7","073_9_7","JHN","9","7","7","'Bhɛɛ‑ 'ke ‑ya pele‑ ‑a ni dɔɔ: «Ge 'e wlɛyi' 'fɛ mɛɛ 'fɛ Siloe ‑draa 'nɛ 'ɛ ba ('Siloe 'bhɛ 'yi ‑le dɔɔ: ‹‑O mɛɛ 'la zan winbwa‑›).» 'Bhɛ klɛle 'tɛ, 'ke 'yee‑ ‑yrɛ 'wi mi 'ɛ ‑e gele‑ ‑a wlɛyi' 'fɛlɛ‑ 'bhɛ ‑yi 'ɛ ba, 'bhɛɛ‑ ‑a nu bhla 'ɛ zi, 'kee‑ yrɛ ma yele‑. ");
INSERT INTO moa_vpl VALUES ("JN9_8","073_9_8","JHN","9","8","8","'Bhɛ klɛle 'tɛ, 'yee‑ mɛɛ 'ɛ yaayɔɔn' mu 'ɛ 'pegee mɛɛ 'la zan mu 'a ꞊ya 'elwale ‑sɔ pɛ ‑yrɛwo' yrɛ nɔɔ‑ mɛɛ mu ma, 'ke 'mu 'a 'pele dɔɔ: «'Yee‑ mɛɛ 'lɛɛ‑ 'yela‑ yaale laa ‑yaa ‑gɛ 'kee‑ pɛ mu ‑yrɛwo' mɛɛ mu ma ɛɛ?» ");
INSERT INTO moa_vpl VALUES ("JN9_9","073_9_9","JHN","9","9","9","Mɛɛ 'ke mu ‑yaa pe 'zi dɔɔ: «'Yele‑ 'kɛle‑!» 'Bhɛɛ‑ mɛɛ ‑bhɛɛke' mu ‑yaa pe 'zi dɔɔ: «'Ɔn ɔn, 'yee‑ laa 'kɛle‑, ‑o 'pwɛle‑ ‑o 'eke‑ 'le.» 'Duŋ‑ 'yee‑ mɛɛ 'ɛ 'gbu 'yaa‑ pe 'zi dɔɔ: «'Mi ‑le 'kɛle‑.» ");
INSERT INTO moa_vpl VALUES ("JN9_10","073_9_10","JHN","9","10","10","'Bhɛ 'yi 'tɛ, 'ke ‑wa 'gbu 'lrɔkpale dɔɔ: «'Ya ‑kla 'nale‑ 'bhɛɛ‑ 'e 'yrɛbhɛ‑ mu 'ɛ 'liiploola ɛɛ?» ");
INSERT INTO moa_vpl VALUES ("JN9_11","073_9_11","JHN","9","11","11","‑E pe ‑o ni 'tɛ dɔɔ: «‑O mɛɛ 'la zan sii Zesu, ‑e ‑pɛɛ sa ‑kla 'bhɛɛ‑ ‑e 'bhɛ ‑pɛɛ 'ɛ ‑glɔɔla 'ŋ 'yrɛbhɛ‑ mu 'ɛ ta, 'bhɛ blaan, 'ke ‑ya pele‑ 'ŋ ni dɔɔ: ‹Ge 'e wlɛyi' 'fɛ Siloe mɛɛ 'fɛ ‑draa 'nɛ 'ɛ ba›. 'Ŋ ‑ja 'bhɛɛ‑ ꞊nɔɔ 'tɛ, 'ke 'mi 'ŋ wlɛyi' 'fɛle, 'bhɛɛ‑ 'ŋ yrɛ ma ꞊ya 'bhɛ blaan.» ");
INSERT INTO moa_vpl VALUES ("JN9_12","073_9_12","JHN","9","12","12","'Bhɛ klɛle 'tɛ, 'ke ‑wa ‑lrɔkpale dɔɔ: «'Bhɛɛ‑ ‑a 'gbu ‑o 'naa‑ ma ɛɛ?» 'Bhɛɛ‑ 'ke ‑ya zikaple ‑o ni dɔɔ: «'Naa 'a geyrɛ dɔ.» ");
INSERT INTO moa_vpl VALUES ("JN9_13","073_9_13","JHN","9","13","13","'Bhɛ klɛle 'tɛ, 'ke ‑o gele‑ 'yee‑ mɛɛ 'la zan ‑yrɛ 'wile‑ ‑yaa 'elwale ‑sɔ ‑a ‑le Farizi mu 'ɛ ba. ");
INSERT INTO moa_vpl VALUES ("JN9_14","073_9_14","JHN","9","14","14","'Bhɛɛ‑ 'duŋ‑, Zesu ‑pɛɛ 'ɛ ꞊kla, 'bhɛɛ‑ ‑e 'yee‑ mɛɛ 'ɛ 'yrɛ 'liiploola Zuufu mu a ‑yitrɛ' yi do ‑la ma. ");
INSERT INTO moa_vpl VALUES ("JN9_15","073_9_15","JHN","9","15","15","'Bhɛla‑ ‑zayile, 'ke 'woo‑ Farizi mu 'ɛ ‑o 'yee‑ mɛɛ 'ɛ 'lrɔkpale 'ezin‑ dɔɔ ‑e ꞊kla 'nale‑ 'bhɛɛ‑ ‑e ‑swa yrɛma yele‑ ‑zɔn. 'Bhɛ klɛle 'tɛ 'ke ‑ya pele‑ ‑o ni dɔɔ: «‑E ‑pɛɛ sa ‑glɔɔla 'ŋ 'yrɛbhɛ‑ mu 'ɛ ta, 'bhɛɛ‑ 'ŋ ‑ja 'ŋ wlɛyi' 'fɛlɛ‑; 'bhɛ blaan, 'bhɛɛ‑ 'ŋ 'swa‑ yrɛma yele‑.» ");
INSERT INTO moa_vpl VALUES ("JN9_16","073_9_16","JHN","9","16","16","‑O 'bhɛ 'male‑ 'tɛ, 'ke *Farizi mu 'ɛ 'ke mu 'a 'pele dɔɔ: «Mɛɛ 'lɛɛ‑ yaa da ‑Waanbhaa' ba, ‑amasrɔyi yaa ‑kɔɔ ‑yitrɛ' yi 'ɛ 'klɔsikun.» 'Duŋ‑ ‑o 'ke mu 'a ꞊pia dɔɔ: «‑Za 'yɔɔ‑ klɛ mi do sɔ 'bhɛ 'sɔle‑ maza ‑glɔɔn mu 'ɛ klɛle‑ 'nale‑ ‑a ma ɛɛ?» ‑Ayile ‑o ‑yiciɛnna ‑lɛ plɛ 'bhɛ ‑za 'ɛ 'yi. ");
INSERT INTO moa_vpl VALUES ("JN9_17","073_9_17","JHN","9","17","17","'Bhɛ blaan sa 'ezin‑, 'ke 'woo‑ Farizi mu 'ɛ ‑o 'yee‑ mɛɛ 'ɛ 'lrɔkpa gbɛ drɛɛwole dɔɔ: «Mɛɛ 'la zan 'e 'yrɛ 'liiploola 'bhi pe ‑a ma 'nale‑ ɛɛ?» 'Bhɛ klɛle 'tɛ, 'ke ‑ya ‑lɛkunle ‑o ni dɔɔ: «‑Waanbhaa' ‑lɛla' ‑janwo' mi do ‑le.» ");
INSERT INTO moa_vpl VALUES ("JN9_18","073_9_18","JHN","9","18","18","'Duŋ‑ Zuufu ‑kuŋlii mu 'ɛ waa ‑yaa ‑a zi 'bhii‑ ‑woo 'kpa 'a ‑yi 'bhii‑ 'yee‑ mɛɛ 'ɛ 'yrɛ 'wile‑ ‑yaa 'elwale ‑sɔ, 'bhɛɛ‑ ‑a ‑yrɛ 'liiploola ‑zɔn. 'Bhɛla‑ ‑yile 'ke ‑wa dɛ 'pegee ‑a nɛɛ 'siile, 'bhɛɛ‑ 'ke 'mu 'nule. ");
INSERT INTO moa_vpl VALUES ("JN9_19","073_9_19","JHN","9","19","19","'Bhɛɛ‑ 'ke ‑o 'mu 'lrɔkpale dɔɔ: «'Ka gbe 'ɛ 'yele‑ ‑gɛ ɛɛ? 'Ka pe dɔɔ 'ka 'yela‑ ‑yaa ‑a ‑yrɛ 'wile‑ 'le ɛɛ? ‑E ‑kla 'nale 'bhɛɛ‑ ‑e yrɛma ye 'zi ‑zɔn ɛɛ?» ");
INSERT INTO moa_vpl VALUES ("JN9_20","073_9_20","JHN","9","20","20","'Bhɛ klɛle 'tɛ, 'ke ‑a yapɛ mu 'ɛ ‑wa ‑lɛkunle ‑o ni dɔɔ: «'O mɔɔ 'a 'yaango‑ 'bhii‑ 'o gbe 'ɛ 'yele‑ ‑gɛ, 'bhɛɛ‑ 'wa 'yaango‑ 'bhii‑ 'wa 'yaa‑ 'ke ‑a ‑yrɛ 'wile‑ 'le. ");
INSERT INTO moa_vpl VALUES ("JN9_21","073_9_21","JHN","9","21","21","'Duŋ‑ ‑za 'la ꞊kla 'bhɛɛ‑ ‑e yrɛma ye 'zi ‑zɔn 'waa 'bhɛ dɔ. 'Bhɛɛ‑ mɛɛ 'la zan ‑a ‑yrɛ 'liiploola, 'waa 'bhɛ zan 'ɛ dɔ 'ezin‑. ‑Kaa 'gbu 'lrɔkpa doo, matruŋ 'laa 'kɛle‑ ‑li, ‑a 'gbu nu 'sɔlɛ‑ 'bhɛ ‑za 'ɛ 'yipele 'ka ni!» ");
INSERT INTO moa_vpl VALUES ("JN9_22","073_9_22","JHN","9","22","22","‑A yapɛ mu 'ɛ 'yaa‑ ‑gblaan 'zi Zuufu ‑kuŋlii mu 'ɛ 'lɛɛ, 'bhɛla‑ ‑yile ‑o ‑janwoa 'bhɛ gbɛɛn‑ bhe. ‑Amasrɔyi 'woo‑ Zuufu ‑kuŋlii mu 'ɛ ‑wa ‑kpaa gban bi do ma 'ke mɛɛ 'la zan 'a ꞊pia dɔɔ Zesu 'ke Mɛɛ ‑Bhee Mi ‑Kpɔsɔɔ Krisi 'ɛ 'le, ‑o nu 'bhɛ zan 'ɛ ‑gbinlɛ' ‑waa' daanfɛ' 'ɛ ꞊la. ");
INSERT INTO moa_vpl VALUES ("JN9_23","073_9_23","JHN","9","23","23","'Bhɛla‑ ‑zayile, 'yee‑ mɛɛ 'ɛ 'yapɛ‑ mu 'ɛ pe dɔɔ: «Matruŋ 'laa 'kɛle‑, ‑kaa 'gbu 'lrɔkpa doo, ‑e nu 'sɔlɛ‑ 'bhɛ ‑za 'ɛ 'yipele 'ka ni!» ");
INSERT INTO moa_vpl VALUES ("JN9_24","073_9_24","JHN","9","24","24","Farizi mu 'ɛ ‑o 'yee‑ mɛɛ 'la 'yrɛ 'wile‑ ‑yaa 'elwale ‑sɔ, 'bhɛ 'sii gbɛ plɛ mi ꞊woa, 'bhɛɛ‑ 'ke ‑wa pele‑ ‑a ni dɔɔ: «'Tɔbhɔleya na ‑Waanbhaa' ni, 'bhɛɛ‑ wlan pe ‑a ‑yrɛ ma ‑gɛ. 'O mɔɔ 'kpale‑ ‑o ‑a ‑yi 'bhii‑ 'yee‑ mɛɛ 'lɛɛ‑ ‑yoo 'ke ‑za 'yɔɔ‑ klɛ mi do 'le.» ");
INSERT INTO moa_vpl VALUES ("JN9_25","073_9_25","JHN","9","25","25","'Yee‑ mɛɛ 'ɛ ‑ya zikpaa‑ ‑o ni dɔɔ: «'Ke ‑yoo 'ke ‑za 'yɔɔ‑ klɛ mi 'le oo, 'ke yaa ‑o 'ke ‑za 'yɔɔ‑ klɛ mi 'le oo, 'naa 'bhɛ dɔ. 'Duŋ‑ 'mi ‑za do 'kpɔ 'la 'bhɛ dɔ, 'bhɛ ‑le dɔɔ 'ŋ 'yrɛ 'wile‑ ‑yaa, 'bhɛɛ‑ 'ŋ yrɛma ye 'zi ‑zɔn.» ");
INSERT INTO moa_vpl VALUES ("JN9_26","073_9_26","JHN","9","26","26","‑Wa ‑lrɔkpaa 'ezin‑ dɔɔ: «‑E ‑mɛ pɛ za ‑la ‑kla 'e ni ɛɛ? ‑Yee' 'yrɛ 'liiploola 'nale‑ ɛɛ?» ");
INSERT INTO moa_vpl VALUES ("JN9_27","073_9_27","JHN","9","27","27","'Bhɛ klɛle 'tɛ, 'ke ‑ya ‑lɛkunle ‑o ni dɔɔ: «'Ŋ 'bhɛ ꞊pia gban 'ka ni, 'bhɛɛ‑ 'ka 'laa dɔlɛ ‑a ꞊la 'ke 'ka 'ka 'trɔnkpa 'ŋ ni. ‑Mɛle ‑kla 'kaa‑ zi 'bhii‑ 'ŋ 'bhɛ 'pe gbɛ drɛɛwo 'ka ni 'ezin‑ ɛɛ? Taa‑ 'kaa‑ zi 'bhii‑ 'ka klɛ ‑yaa' ‑klaŋlanɛ mu 'ke mu 'le 'ezin‑ ɛɛ?» ");
INSERT INTO moa_vpl VALUES ("JN9_28","073_9_28","JHN","9","28","28","'Bhɛ 'yi 'tɛ, 'ke ‑wa ‑zwanwole, 'bhɛɛ‑ 'ke ‑wa pele‑ ‑a ni dɔɔ: «'Bhi ‑le 'ke 'yee‑ mɛɛ 'ɛ ‑yaa ‑klaŋlanɛ 'le! 'Bhɛɛ‑ 'duŋ‑, 'o mɔɔ ‑o 'ke *Moizi a ‑klaŋlanɛ mu ‑la ‑le. ");
INSERT INTO moa_vpl VALUES ("JN9_29","073_9_29","JHN","9","29","29","'Wa 'yaango‑ dɔɔ ‑Waanbhaa' ‑janwoa Moizi ni; 'duŋ‑ 'yee‑ mɛɛ 'la bhe 'waa ‑a dayrɛ dɔ!» ");
INSERT INTO moa_vpl VALUES ("JN9_30","073_9_30","JHN","9","30","30","'Bhɛ klɛle 'tɛ, 'ke 'yee‑ mɛɛ ‑ya ‑lɛkunle ‑o ni dɔɔ: «'Kpeelɛni maza ‑le ‑gɛ 'dɛ! 'Ka pe dɔɔ 'ka 'laa ‑a dayrɛ dɔ, 'bhɛɛ‑ 'duŋ‑, ‑e 'mi 'yrɛ 'liiploola. ");
INSERT INTO moa_vpl VALUES ("JN9_31","073_9_31","JHN","9","31","31","‑Kɔɔ' 'kpɛn 'a 'yaango‑ 'bhii‑ ‑Waanbhaa' laa 'e 'trɔnkpa‑ ‑za 'yɔɔ‑ klɛ mu ni, 'duŋ‑ 'ke mɛɛ 'la zan ‑gasikpa ‑a ‑lɛɛ, 'bhɛɛ‑ 'bhɛ 'a zru maza klɛ, ‑ya 'trɔnkpa‑ 'bhɛɛ‑ zan 'a 'seri 'ɛ ꞊la. ");
INSERT INTO moa_vpl VALUES ("JN9_32","073_9_32","JHN","9","32","32","‑A 'san 'drunyan zisan' bhla zi ma, 'kee‑ nu 'tɛnlɛ‑ ‑zɔn ma, ‑kɔɔ' 'laa 'malɛ‑ ‑lido' 'kaa mɛɛ do ‑yaa ‑a ‑yrɛ 'wile‑ 'le, 'bhɛɛ‑ mɛɛ ‑bhɛɛke' do 'a 'yrɛ 'liiploola. ");
INSERT INTO moa_vpl VALUES ("JN9_33","073_9_33","JHN","9","33","33","'Ke 'yee‑ mɛɛ 'lɛɛ‑ yaa ‑yaa da ‑Waanbhaa' ba bi, yaa ‑yaa nu 'sɔlɛ‑ ‑za 'kedo‑ 'kpɔ klɛle‑.» ");
INSERT INTO moa_vpl VALUES ("JN9_34","073_9_34","JHN","9","34","34","'Bhɛ klɛle 'tɛ, 'ke 'woo‑ Farizi mu 'ɛ ‑wa pele‑ 'yee‑ mɛɛ 'ɛ ni dɔɔ: «‑A 'san 'e 'ya yi ma, 'e 'gbutru 'ɛ 'kpɛn ‑o ‑za 'yɔɔ‑ 'yi; 'bhɛɛ‑ 'ya zi 'bhii‑ 'yoo daan ‑zɔn ɛɛ? ‑Ayile 'tɛ, 'ke ‑wa ‑gbinle' ‑o daanfɛ' 'ɛ ꞊la.» ");
INSERT INTO moa_vpl VALUES ("JN9_35","073_9_35","JHN","9","35","35","Zesu 'a 'malawoa 'kaa Farizi mu 'ɛ ‑o 'yee‑ mɛɛ 'ɛ ‑gbian ‑o pleŋ‑, 'kee‑ gele‑ ‑a ziglinlɛ, 'bhɛɛ‑ ‑ya yele, 'ke ‑ya ‑lrɔkpale dɔɔ: «'Yee kpa Bhaaplɛŋ Gbe 'ɛ 'yi ɛɛ?» ");
INSERT INTO moa_vpl VALUES ("JN9_36","073_9_36","JHN","9","36","36","'Ke 'yee‑ mɛɛ 'ɛ Zesu 'lrɔkpale dɔɔ: «‑Dele 'kɛle‑ ɛɛ Mɛɛzan, 'bhɛɛ‑ 'ŋ sɔ 'ŋ 'kpale ‑a ‑yi ɛɛ?» ");
INSERT INTO moa_vpl VALUES ("JN9_37","073_9_37","JHN","9","37","37","'Bhɛɛ‑ Zesu 'a ꞊pia ‑a ni dɔɔ: «'E 'yrɛ ‑o 'yela‑ ma ‑gɛ, 'yele‑ ‑janwo' zii' 'e ni ‑gɛ.» ");
INSERT INTO moa_vpl VALUES ("JN9_38","073_9_38","JHN","9","38","38","'Bhɛ klɛle 'tɛ, 'ke ‑ya pele‑ Zesu ni dɔɔ: «Mɛɛzan, 'mi 'ŋ ꞊kpaa 'e 'yi.» 'Bhɛ ya 'ɛ 'yi, 'ke ‑ya 'kpɔ zɛnle‑ Zesu 'lɛɛ‑, 'bhɛɛ‑ 'kee‑ 'bhɛ gbale‑. ");
INSERT INTO moa_vpl VALUES ("JN9_39","073_9_39","JHN","9","39","39","Zesu pe ‑a ni dɔɔ: «'Ŋ ꞊nwa 'drunyan 'lɛɛ‑ 'yi 'kiti do ‑la 'kanyrɛ‑ nɔɔ‑; 'kooko‑ ‑yrɛ 'wi mu yrɛ ma ye, 'bhɛɛ‑ mɛɛ 'la zan mu ‑yrɛ 'wile‑ laa ‑o, 'mu zan mu klɛ ‑yrɛ 'wi mu 'le.» ");
INSERT INTO moa_vpl VALUES ("JN9_40","073_9_40","JHN","9","40","40","Farizi 'kɛ mu 'la dulale 'yaa‑ ‑a ‑din 'bhɛ 'waati 'ɛ ba, 'mu 'trɔnbɔle 'bhɛ ‑jan 'ɛ 'yi, 'ke ‑o Zesu 'lrɔkpale dɔɔ: «'O mɔɔ ‑o 'ezin‑ ‑yrɛ 'wi mu 'le ɛɛ?» ");
INSERT INTO moa_vpl VALUES ("JN9_41","073_9_41","JHN","9","41","41","Zesu 'bhɛ 'lɛkwan‑ ‑o ni dɔɔ: «'Kee‑ 'kpa bi 'ka ‑o 'ke ‑yrɛ 'wi mu 'le, ‑za 'yɔɔ‑ ‑kpan 'laa ‑yaa nu baalɛ 'ka ta, 'kaa ‑za 'yɔɔ‑ klɛle ‑zayi'. 'Duŋ‑ 'kaa 'pelawo zii' dɔɔ: ‹'O yrɛ ma ye›. 'Bhɛla‑ ‑zayile 'kiti ‑o 'ka ma 'kaa‑ ‑za 'yɔɔ mu 'ɛ ‑zayi'.» ");
INSERT INTO moa_vpl VALUES ("JN10_1","073_10_1","JHN","10","1","1","Zesu pe ‑o ni dɔɔ: «'Mi pe 'ka ni 'sɔwɛɛ‑ ma dɔɔ 'ke mɛɛ 'la zan laa wlalɛ ‑bhlaa mu a wɛlɛ‑ 'ɛ 'lii, 'bhɛɛ‑ 'kee‑ ‑saan wɛlɛ‑ 'ɛ ma yrɛ ‑bhɛɛke' ꞊nɔɔ, 'bhɛɛ‑ ‑e ‑zinaa' wɛlɛ‑ 'ɛ 'kpee, 'bhɛ zan 'ɛ 'bhɛ ‑o 'ke ‑faannii' do 'pegee mɛɛ dɛ mi do ‑la ‑le. ");
INSERT INTO moa_vpl VALUES ("JN10_2","073_10_2","JHN","10","2","2","'Duŋ‑ 'ke mɛɛ 'la zan ‑kaan wɛlɛ‑ 'ɛ 'lii, 'bhɛ zan 'ɛ 'bhɛ ‑le 'ke ‑bhlaa mu 'ɛ gooba mi 'gbu 'ɛ 'le. ");
INSERT INTO moa_vpl VALUES ("JN10_3","073_10_3","JHN","10","3","3","‑Bhlaa mu a wɛlɛ‑ tagbin‑ mi 'ɛ, 'bhɛ wɛlɛ‑ 'ɛ 'liigo‑ 'yee‑ ‑bhlaa gooba mi 'ɛ ni. 'Bhɛɛ‑ ‑bhlaa mu 'ɛ ‑wa ‑weli' 'ɛ ma; 'bhɛɛ‑ ‑e ‑yaa' ‑bhlaa mu 'ɛ 'kpɛn sii do do ‑o 'tɔ ma, 'bhɛɛ ‑e pwɛ ‑o ‑le 'pɛɛlii‑. ");
INSERT INTO moa_vpl VALUES ("JN10_4","073_10_4","JHN","10","4","4","'Kee‑ ‑yaan ‑yaa' pɛ ‑bhlaa mu 'ɛ 'kpɛn 'pwɛlele bhla 'la ba, 'bhɛɛ‑ ‑e dɔ 'mu ‑lɛɛ, 'bhɛɛ 'mu dɔ ‑a zi ‑amasrɔyi 'mu 'a 'weli‑ 'ɛ dɔ. ");
INSERT INTO moa_vpl VALUES ("JN10_5","073_10_5","JHN","10","5","5","'Duŋ‑ waa mɛɛ 'la zan dɔ, waa nu dɔlɛ 'bhɛ zan 'ɛ zi, ‑amasrɔyi waa a ‑weli' 'ɛ dɔ; 'bhɛla‑ ‑yile ‑o nu blasanlɛ 'bhɛ zan 'ɛ ma 'egbɔɔnle.» ");
INSERT INTO moa_vpl VALUES ("JN10_6","073_10_6","JHN","10","6","6","Zesu 'bhɛ ‑gɔɔn 'la ꞊woa ‑o ni bhe, 'duŋ‑ waa 'bhɛ 'yimalɛ. ");
INSERT INTO moa_vpl VALUES ("JN10_7","073_10_7","JHN","10","7","7","Zesu pe ‑o ni 'ezin‑ dɔɔ: «'Mi pe 'ka ni 'ŋ 'sɔwɛɛ‑ ma dɔɔ 'mi ‑le 'ke ‑bhlaa mu a wɛlɛ‑ 'ɛ 'lii 'le. ");
INSERT INTO moa_vpl VALUES ("JN10_8","073_10_8","JHN","10","8","8","Mɛɛ 'la zan mu 'kpɛn ꞊nwa 'mi 'lɛɛ, 'mu ‑o 'ke ‑faannii' mu 'pegee mɛɛ dɛ mu 'le; 'duŋ‑ ‑bhlaa mu 'ɛ waa ‑o 'trɔnkpalɛ ‑o ni. ");
INSERT INTO moa_vpl VALUES ("JN10_9","073_10_9","JHN","10","9","9","'Mi ‑le 'bhii‑ 'fɛlii 'ɛ 'le, 'ke mɛɛ 'la zan ‑wlaa 'bhɛ 'fɛlii 'ɛ ꞊nɔɔ, 'bhɛ zan nu golɛ ‑za 'yi. 'Bhɛ zan nu 'sɔlɛ‑ wlale, 'bhɛɛ‑ ‑e pwɛ, 'bhɛɛ‑ ‑e nu ‑a le pɛ ‑srɔɔwolɛ. ");
INSERT INTO moa_vpl VALUES ("JN10_10","073_10_10","JHN","10","10","10","‑Faannii' 'ɛ yaa nu bhaama, 'ke yaa 'e go ‑faanwole 'pegee mɛɛ dɛle ‑la ba, 'bhɛɛ‑ pɛ 'siɛza‑ 'kaama‑. 'Duŋ‑ 'mi ꞊nwa, 'kooko‑ bhaaplɛŋ mu 'ɛ ‑o bole ‑yrɛ ma ‑si 'srɔɔwo‑, 'bhɛɛ‑ 'yee‑ ‑si 'ɛ pa ‑o ‑yi 'kee‑ kan a ‑daŋ' ta. ");
INSERT INTO moa_vpl VALUES ("JN10_11","073_10_11","JHN","10","11","11","'Mi ‑le 'ke ‑bhlaa mu gooba mi kplankplan 'ɛ 'le. 'Bhɛɛ‑ ‑bhlaa mu gooba mi wlan 'ɛ ‑dwa a ‑la 'ke ‑ya niigo ‑a 'gbu 'si 'ɛ 'yi ‑yaa' ‑bhlaa mu 'ɛ ni. ");
INSERT INTO moa_vpl VALUES ("JN10_12","073_10_12","JHN","10","12","12","'Duŋ‑ mɛɛ 'la zan yewo ‑gɔli' ma, 'bhɛ zan 'laa ‑o 'ke ‑bhlaa gooba mi kplankplan 'ɛ 'le. 'Bhɛɛ‑ ‑yaa' pɛ 'laa 'ke ‑bhlaa mu 'ɛ 'le, 'bhɛla‑ ‑yile 'ke ‑a ‑yrɛkpaa srɔpɛ do ma 'ke 'bhɛ ‑o zan ‑a ta, ‑e blasan, 'bhɛɛ‑ ‑e ‑bhlaa mu 'ɛ to srɔpɛ 'ɛ 'kɔɔ. 'Bhɛɛ‑ srɔpɛ 'ɛ nu banlɛ 'yee‑ ‑bhlaa mu 'ɛ 'ke ta, 'bhɛɛ‑ ‑a ‑vin mu 'ɛ kan 'eke‑ ma. ");
INSERT INTO moa_vpl VALUES ("JN10_13","073_10_13","JHN","10","13","13","'Yee‑ ‑gɔli' ma yewo mi 'ɛ blasan srɔpɛ 'ɛ 'lɛɛ, ‑amasrɔyi ‑e yewo ‑gɔli' do ‑kplɛnnɛ' ‑la ma, 'bhɛɛ‑ yaa a 'ŋgamiwo ‑bhlaa mu 'ɛ ma. ");
INSERT INTO moa_vpl VALUES ("JN10_14","073_10_14","JHN","10","14","14","'Mi ‑le 'ke ‑bhlaa gooba mi kplankplan 'ɛ 'le. 'Mi 'an pɛ ‑bhlaa mu 'ɛ dɔ, 'bhɛɛ‑ 'an pɛ ‑bhlaa mu 'ɛ ‑woo 'mi dɔ. ");
INSERT INTO moa_vpl VALUES ("JN10_15","073_10_15","JHN","10","15","15","'Bhii‑ gɔnɛ‑ 'la gbɛɛn‑, 'ŋ Dɛ ‑Waanbhaa' 'mi dɔ, 'bhɛɛ‑ 'mi 'yee‑ 'ŋ Dɛ ‑Waanbhaa' dɔ 'ezin‑. 'Mi 'ŋ 'niigo‑ 'ŋ 'gbu 'si 'ɛ 'yi 'an pɛ ‑bhlaa mu 'ɛ ni. ");
INSERT INTO moa_vpl VALUES ("JN10_16","073_10_16","JHN","10","16","16","‑Bhlaa 'bhɛɛke mu ‑o 'ŋ 'kɔɔ 'ezin‑, 'bhɛ mu laa ‑o ‑bhlaa mu yi wɛlɛ‑ 'lɛɛ‑ 'yi. ‑Yoo 'ke ‑za 'le 'ke 'ŋ dɔ 'mu 'lɛɛ 'bhɛɛ‑ 'ŋ ge 'mu 'le. 'Bhɛ mu nu 'ŋ 'weli‑ 'ɛ malɛ, 'bhɛɛ‑ ‑o 'pegee 'kɛ mu 'lɛɛ‑ ‑o nu 'klalɛ‑ 'eke‑ ba, 'bhɛɛ‑ ‑o klɛ ‑bhlaa 'lɛdo‑, 'bhɛɛ‑ ‑bhlaa gooba mi do 'kpɔ ‑la dɔle nu klɛlɛ ‑o ‑lɛɛ.» ");
INSERT INTO moa_vpl VALUES ("JN10_17","073_10_17","JHN","10","17","17","«'Ŋ ‑za sɔ 'ŋ Dɛ ‑Waanbhaa' ni, ‑amasrɔyi 'mi 'ŋ 'niigo‑ 'ŋ 'gbu 'si 'ɛ 'yi, 'kooko‑ 'an 'srɔɔwo gbɛ drɛɛwo 'ezin‑. ");
INSERT INTO moa_vpl VALUES ("JN10_18","073_10_18","JHN","10","18","18","Mɛɛ 'kedo‑ 'kpɔ 'laa sɔ 'ŋ ‑si 'ɛ 'sile, 'duŋ‑ 'ŋ 'gbu ‑le 'ŋ si 'ɛ 'na zii' ga ni 'ŋ 'gbu zru ma. 'Bhɛ ya 'ɛ 'yi, ‑a 'seŋ ‑o 'ŋ ni 'ke 'an na ga ni, 'bhɛɛ‑ ‑a 'seŋ ‑o 'ŋ ni 'ke 'ŋ sɔ a 'kunle ga 'kɔɔ 'ezin‑. 'Ŋ Dɛ ‑Waanbhaa 'a ꞊pia 'ŋ ni 'kaa 'an klɛ 'bhɛɛ‑ gbɛɛn‑.» ");
INSERT INTO moa_vpl VALUES ("JN10_19","073_10_19","JHN","10","19","19","Zesu a ‑jan mu 'ɛ Zuufu mu 'ɛ 'yiciɛnna 'ezin‑. ");
INSERT INTO moa_vpl VALUES ("JN10_20","073_10_20","JHN","10","20","20","‑O ‑bebe ‑yaa pe 'zi dɔɔ: «Lii ‑yɔɔ' ‑o ‑a zi! ‑A ŋgblo ‑wlɛnna! ‑Mɛla ma 'ka ‑o 'ka 'trɔnkpa zii' ‑a ni ɛɛ?» ");
INSERT INTO moa_vpl VALUES ("JN10_21","073_10_21","JHN","10","21","21","'Duŋ‑ ‑o 'ke mu ‑yaa pe 'zi dɔɔ: «'Ɔn ɔn! Lii ‑yɔɔ' ‑o mɛɛ 'la zan zi 'bhɛ 'laa ‑janwo' 'bhɛ gbɛɛn‑. 'Bhɛɛ‑ lii ‑yɔɔ' sɔ ‑yrɛ 'wi mu ‑yrɛ ‑liiploole ɛɛ?» ");
INSERT INTO moa_vpl VALUES ("JN10_22","073_10_22","JHN","10","22","22","‑Waanbhaa' Gba 'Fɛ ‑Gbɛnɛ 'ɛ gbɛkpa yi 'ɛ ‑Waanbhaa' 'kɔɔ, 'bhɛ 'fɛti 'ɛ 'yaa‑ klɛ Zeruzalɛmu lɛɛ 'oo lɛɛ. 'Bhɛ 'fɛti yi 'ɛ ꞊bhwa, 'bhɛɛ‑ 'bhɛ 'yaa‑ ‑niinii' 'kpa bhla ‑gbɛnɛ 'ɛ zi. ");
INSERT INTO moa_vpl VALUES ("JN10_23","073_10_23","JHN","10","23","23","'Bhɛ 'fɛti yi 'ɛ 'le, Zesu 'yaa‑ ge 'zi 'kee‑ nu 'yee‑ ‑Waanbhaa' Gba 'Fɛ ‑Gbɛnɛ 'ɛ ꞊la yrɛ 'la ‑o ‑yaa 'bhɛ sii: ‹‑Bhleŋgbe Salomɔ a 'wlaŋla›. ");
INSERT INTO moa_vpl VALUES ("JN10_24","073_10_24","JHN","10","24","24","'Bhɛ klɛle 'tɛ, 'ke Zuufu mu 'ɛ ‑woo ‑lɛkpale 'eke‑ ta ‑a zi, 'bhɛɛ‑ 'ke ‑wa ‑lrɔkpale dɔɔ: «'E nu 'o 'nii‑ 'ɛ golɛ bhlɛ ta 'waati 'ɛ ‑dela ba ɛɛ? 'Ke 'bhi ‑le 'ke Mɛɛ ‑Bhee Mi ‑Kpɔsɔɔ Krisi 'ɛ 'le, 'bhɛ 'pe 'o ni kpataakpa.» ");
INSERT INTO moa_vpl VALUES ("JN10_25","073_10_25","JHN","10","25","25","Zesu 'a 'lɛkwan‑ ‑o ni dɔɔ: «'An 'pia‑ gban 'ka ni, 'duŋ‑ 'ka 'laa 'ka 'kpalɛ‑ 'ŋ 'yi. 'Ŋ 'yoo‑ ‑za mu 'la klɛ 'zi 'ŋ Dɛ ‑Waanbhaa' a ‑glɔɔya' 'le, 'mi ‑o mɛɛ ‑glɔɔn 'la 'le 'mu 'bhɛ zrɔn kpataakpa. ");
INSERT INTO moa_vpl VALUES ("JN10_26","073_10_26","JHN","10","26","26","'Duŋ‑ 'ka 'laa 'ka kpa 'mi 'yi, ‑amasrɔyi 'ka 'laa ‑o 'an pɛ ‑bhlaa mu 'ɛ 'ke mu 'le. ");
INSERT INTO moa_vpl VALUES ("JN10_27","073_10_27","JHN","10","27","27","'An pɛ ‑bhlaa mu 'ɛ ‑woo 'trɔnkpa‑ 'ŋ 'weli‑ 'ɛ ꞊la. 'Mi ‑o dɔ 'bhɛɛ‑ ‑o dɔ 'mi zi. ");
INSERT INTO moa_vpl VALUES ("JN10_28","073_10_28","JHN","10","28","28","'Mi bole ‑yrɛ ma ‑si 'la ‑daŋ' laa ‑o 'bhɛ ma 'bhɛ na ‑o ni. Waa nu galɛ ‑titi, 'bhɛɛ‑ mɛɛ 'kedo‑ 'kpɔ 'laa nu 'sɔlɛ‑ ‑o 'kunle 'ŋ 'kɔɔ. ");
INSERT INTO moa_vpl VALUES ("JN10_29","073_10_29","JHN","10","29","29","'Ŋ Dɛ ‑Waanbhaa' 'la 'bhɛ ‑o ‑naa 'ŋ ni 'bhɛ gblaan 'yiya‑ pɛ 'kpɛn ni; 'bhɛɛ‑ mɛɛ 'kedo‑ 'kpɔ 'laa sɔ ‑o 'kunle 'ŋ Dɛ ‑Waanbhaa' 'kɔɔ. ");
INSERT INTO moa_vpl VALUES ("JN10_30","073_10_30","JHN","10","30","30","'Mi 'pegee 'ŋ Dɛ ‑Waanbhaa' 'woo‑ do 'kpɔ.» ");
INSERT INTO moa_vpl VALUES ("JN10_31","073_10_31","JHN","10","31","31","'Bhɛ klɛle 'tɛ, 'ke Zuufu mu 'ɛ ‑o kpoti mu 'sile 'ezin‑ 'mu 'pa zayi' Zesu ma. ");
INSERT INTO moa_vpl VALUES ("JN10_32","073_10_32","JHN","10","32","32","'Bhɛ 'yi 'tɛ, 'ke Zesu 'a 'pele ‑o ni dɔɔ: «'Ŋ ‑za 'lrele‑ ‑bebe 'la 'srɔɔwoa‑ 'ŋ Dɛ ‑Waanbhaa' 'kɔɔ, 'ŋ 'mu ‑kla 'ka 'yrɛ ma. 'Ka ‑a zi 'bhii‑ 'ka kpoti pa 'ŋ ma 'woo‑ ‑za 'lrele‑ mu 'la bhe ‑o ‑de 'gbu ‑la ‑zayi' ɛɛ?» ");
INSERT INTO moa_vpl VALUES ("JN10_33","073_10_33","JHN","10","33","33","Zuufu mu 'ɛ ‑o 'bhɛ zikpaa‑ Zesu ni dɔɔ: «'Waa ‑o kpoti 'payrɛ‑ ‑glin 'zi 'e ma ‑za 'lrele‑ klɛ ‑zayi'. 'E ‑Waanbhaa' 'tɔsiɛ zii' bhe, 'bhɛla‑ ‑zayile, 'wa zi 'bhii‑ 'o kpoti 'pa 'e ma. ‑Amasrɔyi 'bhi 'la 'bhi ‑o 'ke bhaaplɛŋ bhaamale 'le 'yoo‑ 'e 'gbu klɛ 'zi 'ke ‑Waanbhaa' 'le.» ");
INSERT INTO moa_vpl VALUES ("JN10_34","073_10_34","JHN","10","34","34","'Bhɛ klɛle 'tɛ, 'ke Zesu 'a 'pele ‑o ni dɔɔ: «‑A yɔɔndɛle laa ‑o 'kaa 'toŋ 'sɛwɛ 'ɛ 'yi dɔɔ ‑Waanbhaa' 'a 'pia‑ dɔɔ: ‹'Ka ‑o ‑waanbhaa' mu 'le ɛɛ?› ");
INSERT INTO moa_vpl VALUES ("JN10_35","073_10_35","JHN","10","35","35","‑Kɔɔ' 'a 'yaango‑ dɔɔ ‑za 'la ‑yɔɔndɛle ‑o ‑Waanbhaa' 'a 'Sɛwɛ 'ɛ 'yi, waa sɔ 'bhɛ 'yigale ‑titi. 'Bhɛɛ‑ ‑Waanbhaa' ‑yaa' ‑jan 'ɛ 'lɛnaa‑ mɛɛ 'la zan mu ni, 'kee‑ 'mu 'siila‑ ‹‑waanbhaa' mu.› ");
INSERT INTO moa_vpl VALUES ("JN10_36","073_10_36","JHN","10","36","36","'Bhɛ bhla 'ɛ ba, 'ŋ Dɛ ‑Waanbhaa' 'mi ‑la makwan‑ 'bhɛɛ‑ ‑e 'mi 'winbwa‑ 'drunyan 'lɛɛ‑ 'yi. ‑E ‑kla 'nale‑ 'bhɛɛ‑ 'kaa‑ pe 'zi dɔɔ: ‹'E ‑Waanbhaa' 'tɔsiɛ zii' ɛɛ?› ‑Amasrɔyi 'an ꞊pia dɔɔ 'ŋ 'yoo‑ 'ke *‑Waanbhaa' Gbe 'le bhe. ");
INSERT INTO moa_vpl VALUES ("JN10_37","073_10_37","JHN","10","37","37","'Ke 'naa ‑o 'ŋ Dɛ ‑Waanbhaa' klɛza mu klɛ 'zi bi, 'ka 'laa 'ka 'kpalɛ‑ 'mi 'yi. ");
INSERT INTO moa_vpl VALUES ("JN10_38","073_10_38","JHN","10","38","38","'Duŋ‑ 'ke 'ŋ 'yoo 'ŋ Dɛ ‑Waanbhaa' klɛza mu klɛ 'zi, 'ali‑ 'ke 'ka 'laa 'ka 'kpalɛ‑ 'mi 'yi, ‑ka 'ka 'kpa ‑o ‑yi, 'kooko‑ 'kaa 'yaango‑ 'bhii‑ 'mi 'pegee 'ŋ Dɛ ‑Waanbhaa ‑o do: 'Ŋ ‑Dɛ ‑Waanbhaa' ‑o 'mi 'yi, 'bhɛɛ‑ 'mi ‑o 'yee‑ 'ŋ Dɛ ‑Waanbhaa' 'yi 'ezin‑.» ");
INSERT INTO moa_vpl VALUES ("JN10_39","073_10_39","JHN","10","39","39","‑O 'bhɛ ‑jan 'ɛ 'male‑, 'ke ‑wa pele‑ dɔɔ ‑wa 'kunle 'ezin‑. 'Duŋ‑ ‑e ꞊bhia ‑o 'kɔɔ. ");
INSERT INTO moa_vpl VALUES ("JN10_40","073_10_40","JHN","10","40","40","'Bhɛ blaan, 'ke Zesu gele‑ 'ezin‑ Zrudɛn yue 'ɛ ‑yrɛ gbɛ do 'ɛ ta, Mɛɛ Wiiŋfɛ' Mi Zaan ‑yaa mɛɛ mu 'ɛ 'wiiŋfɛ zii' 'yrɛ 'la ꞊nɔɔ 'elwale bhe 'bhɛ ꞊nɔɔ. 'Bhɛɛ‑ 'kee‑ bole‑ 'bhɛ yrɛ 'ɛ ꞊nɔɔ ye. ");
INSERT INTO moa_vpl VALUES ("JN10_41","073_10_41","JHN","10","41","41","Mɛɛ ‑bebe ‑ja 'tɛnlɛ‑ ‑a ma 'bhɛ ꞊nɔɔ. 'Bhɛɛ‑ 'mu 'yaa‑ pe 'zi dɔɔ: «Zaan 'laa 'sɔle‑ maza do 'kpɔ klɛlɛ, 'duŋ‑ ‑e ‑jan 'oo ‑jan 'la ꞊woa 'yee‑ mɛɛ 'lɛɛ‑ ba zayi', 'mu 'kpɛn ‑o 'ke wlan 'le.» ");
INSERT INTO moa_vpl VALUES ("JN10_42","073_10_42","JHN","10","42","42","'Bhɛɛ‑ mɛɛ ‑bebe ‑o ‑kpaa Zesu 'yi 'bhɛ yrɛ 'ɛ ꞊nɔɔ ye. ");
INSERT INTO moa_vpl VALUES ("JN11_1","073_11_1","JHN","11","1","1","‑O ‑yaa 'gwlaan‑ do sii Lazaa, 'bhɛɛ‑ ga ‑yaa 'bhɛ ma. 'Bhɛ 'yaa‑ da ‑wa 'la ta ‑o ‑yaa 'bhɛ sii Betani. ‑A nɛɛnɛ‑ ‑le ‑yaa plɛ: Mari 'pegee Maati. 'Bhɛ mu ‑yaa 'yee‑ ‑wa do 'kpɔ 'ɛ 'yela‑ ta 'ezin‑. ");
INSERT INTO moa_vpl VALUES ("JN11_2","073_11_2","JHN","11","2","2","Mari ‑le ‑yaa le 'la ‑lasiklɔɔ ‑gblɛn 'nrale‑ do ꞊klaa Mɛɛzan Zesu gaan ma, 'bhɛɛ ‑yoo magwa‑ ‑a winle mu 'ɛ 'le. Ga ‑yaa 'yela‑ nɛɛnɛ‑ 'gwlaan‑ Lazaa ma. ");
INSERT INTO moa_vpl VALUES ("JN11_3","073_11_3","JHN","11","3","3","'Bhɛ klɛle 'tɛ, 'ke 'woo‑ nɛɛnɛ‑ le plɛ 'ɛ ‑o mɛɛ winbɔle Zesu ta 'kaa ‑ya pe ‑a ni dɔɔ: «Mɛɛzan, 'e 'bhɛgwlɛn‑ 'la ‑za sɔ 'e ni, pɛ ‑o ‑a ma.» ");
INSERT INTO moa_vpl VALUES ("JN11_4","073_11_4","JHN","11","4","4","Zesu 'bhɛ ‑jan 'ɛ 'male‑, 'ke ‑ya pele‑ dɔɔ: «Lazaa ma ga 'ɛ yaa nu klɛlɛ ‑a dɛpɛ 'le. 'Duŋ‑ 'yee‑ ga 'ɛ ‑e nu klɛlɛ 'ke ‑Waanbhaa' 'tɔbhɔpɛ 'le; 'bhɛɛ‑ ‑e nu klɛlɛ ‑Waanbhaa' Gbe 'ɛ 'tɔbhɔpɛ 'le 'ezin‑.» ");
INSERT INTO moa_vpl VALUES ("JN11_5","073_11_5","JHN","11","5","5","'Bhɛɛ‑ 'duŋ‑, Maati 'pegee Mari, 'bhɛɛ‑ Lazaa ‑za ‑yaa sɔ Zesu ni 'egbɛnɛle. ");
INSERT INTO moa_vpl VALUES ("JN11_6","073_11_6","JHN","11","6","6","'Duŋ‑ ‑ya malawoa 'kaa ga ‑o Lazaa ma, ‑e ꞊bwa 'ezin‑ ‑yrekpaa' plɛ ta ‑e ‑yaa yrɛ 'la ꞊nɔɔ 'bhɛ ꞊nɔɔ. ");
INSERT INTO moa_vpl VALUES ("JN11_7","073_11_7","JHN","11","7","7","'Bhɛ blaan, 'ke ‑ya pele‑ ‑yaa ‑klaŋlanɛ mu 'ɛ ni dɔɔ: «‑Kɔɔ' 'niina‑ ‑kɔɔ' ‑zanta' Zude 'klɛɛn 'ɛ 'yi.» ");
INSERT INTO moa_vpl VALUES ("JN11_8","073_11_8","JHN","11","8","8","'Bhɛ klɛle 'tɛ, 'ke ‑yaa' ‑klaŋlanɛ mu 'ɛ ‑wa zikpale ‑a ni dɔɔ: «'O Daan mi, 'bhɛ ꞊nɔɔ laa ‑mɔlɛ' ‑li, 'bhɛɛ‑ Zude Zuufu mu 'ɛ ‑yaa zi 'bhii‑ ‑o kpoti 'pa 'e ma, 'bhɛɛ‑ ‑woo 'e dɛ, 'bhɛɛ‑ 'yoo‑ ‑a zi 'bhii‑ 'e 'niinale 'ezin‑ 'bhɛɛ‑ yrɛ 'ɛ ꞊nɔɔ ɛɛ?» ");
INSERT INTO moa_vpl VALUES ("JN11_9","073_11_9","JHN","11","9","9","Zesu 'bhɛ zikpaa‑ ‑o ni dɔɔ: «'Lɛrɛ vu ta plɛ laa ‑o ‑yrekpaa' do 'yi ɛɛ? 'Ke mɛɛ 'la zan ‑o 'taawo zii' ‑yrekpaa', 'bhɛ zan gaan laa san pɛ 'kedo‑ 'kpɔ ma, ‑amasrɔyi ‑yretɛ' ‑o ‑bhi 'zi. ");
INSERT INTO moa_vpl VALUES ("JN11_10","073_11_10","JHN","11","10","10","'Duŋ‑ 'ke mɛɛ 'la zan 'taawo zii' ‑bi zi, ‑a gaan san pɛ ma; ‑amasrɔyi 'tɛbhile laa ‑o ‑a ‑lɛɛ.» ");
INSERT INTO moa_vpl VALUES ("JN11_11","073_11_11","JHN","11","11","11","Zesu 'yanle‑ 'bhɛ ‑jan 'ɛ 'wolele, 'ke ‑ya 'kpale 'a ta 'ezin‑ dɔɔ: «‑Kɔɔ' 'bhɛgwlɛn‑ Lazaa ‑o yidɛ zi, 'duŋ‑ 'ŋ nu gelɛ ‑a bwelɛ.» ");
INSERT INTO moa_vpl VALUES ("JN11_12","073_11_12","JHN","11","12","12","‑Ayile 'ke ‑yaa' ‑klaŋlanɛ mu 'ɛ ‑wa zikpale ‑a ni dɔɔ: «'Ee! Mɛɛzan, 'ke ‑yoo yidɛ 'zi, ‑e nu ‑bheelɛ'.» ");
INSERT INTO moa_vpl VALUES ("JN11_13","073_11_13","JHN","11","13","13","Zesu 'yaa‑ ‑we 'zi 'ke Lazaa gaza 'ɛ 'bhɛɛ‑ 'le, 'duŋ‑ ‑yaa' ‑klaŋlanɛ mu 'ɛ 'kpee ma, ‑e ‑yaa ‑we 'zi yidɛza 'te ‑la ‑le. ");
INSERT INTO moa_vpl VALUES ("JN11_14","073_11_14","JHN","11","14","14","'Bhɛ 'yi 'tɛ, 'ke Zesu 'a 'pele ‑o ni kpataakpa dɔɔ: «Lazaa ‑gaa. ");
INSERT INTO moa_vpl VALUES ("JN11_15","073_11_15","JHN","11","15","15","'Duŋ‑ yaa klɛlawolɛ 'ŋ 'yrɛ ma bhe, 'bhɛ ꞊swa 'mi ni 'ka mu ‑zayi', 'kooko‑ 'ka 'ka kpa 'mi 'yi. 'Duŋ‑ ‑ka 'ka 'wlɛn‑, 'bhɛɛ‑ ‑kɔɔ' ge ‑a ‑din.» ");
INSERT INTO moa_vpl VALUES ("JN11_16","073_11_16","JHN","11","16","16","'Bhɛ klɛle 'tɛ, Toma 'la ‑o 'bhɛ 'tɔkpaa‑ Didimu ('bhɛ 'yi ‑le ‹‑Nɛ Yonɛ‑›), 'bhɛ 'a 'pia‑ Zesu a ‑klaŋlanɛ ‑vin mu 'ɛ ni dɔɔ: «‑Kɔɔ' mu ge ‑a zi 'ezin‑, 'bhɛɛ‑ ‑kɔɔ' 'kpɛn 'pegee 'yee‑ ‑kɔɔ' Daan mi 'ɛ ‑kɔɔ' ga 'eke‑ zi!» ");
INSERT INTO moa_vpl VALUES ("JN11_17","073_11_17","JHN","11","17","17","Zesu 'bhɔle‑ Betani, 'ke ‑ya yele‑ 'bhii‑ ‑o 'yee‑ Lazaa ꞊bian gban 'bhɛ ‑yrekpaa' yiziɛ ‑le ‑gɛ. ");
INSERT INTO moa_vpl VALUES ("JN11_18","073_11_18","JHN","11","18","18","Betani ‑wa 'ɛ 'pleŋgole ‑yaa Zeruzalɛmu ma kilo yaga. ");
INSERT INTO moa_vpl VALUES ("JN11_19","073_11_19","JHN","11","19","19","'Bhɛla‑ ‑yile, Zuufu ‑bebe mu ‑nwa Maati 'pegee Mari ba ‑o tagalɛ, ‑o nɛɛnɛ‑ Lazaa gaza 'ɛ 'yi. ");
INSERT INTO moa_vpl VALUES ("JN11_20","073_11_20","JHN","11","20","20","Maati 'a 'male‑ 'kaa Zesu ‑o zan, 'kee‑ gele‑ ‑a ‑lɛpa' yrɛ nɔɔ‑; 'duŋ‑ Mari ꞊bwa 'fɛ 'lɛ ma. ");
INSERT INTO moa_vpl VALUES ("JN11_21","073_11_21","JHN","11","21","21","Maati gele 'tɛnlɛ‑ Zesu ma, 'ke ‑ya pele‑ dɔɔ: «Mɛɛzan, 'kee‑ 'kpa bi ‑gɛ, 'ŋ nɛɛnɛ‑ 'ɛ yaa ‑yaa nu galɛ. ");
INSERT INTO moa_vpl VALUES ("JN11_22","073_11_22","JHN","11","22","22","'Duŋ‑ 'an 'yaango‑ 'bhii‑ 'kee‑ pɛ 'oo pɛ 'la 'yrɛwoa‑ ‑Waanbhaa' ma, ‑e nu 'bhɛ 'nalɛ‑ 'e ni 'saanibhe.» ");
INSERT INTO moa_vpl VALUES ("JN11_23","073_11_23","JHN","11","23","23","Zesu pe ‑a ni dɔɔ: «'E nɛɛnɛ‑ 'ɛ nu bwelɛ gale ba.» ");
INSERT INTO moa_vpl VALUES ("JN11_24","073_11_24","JHN","11","24","24","Maati 'bhɛ zikpaa‑ Zesu ni dɔɔ: «'An 'yaango‑ 'bhii‑ ‑e nu bwelɛ gale ba gbaa mu ‑bwe yi 'ɛ gale ba 'drunyan 'lɛyan yi 'ɛ 'le.» ");
INSERT INTO moa_vpl VALUES ("JN11_25","073_11_25","JHN","11","25","25","'Bhɛ klɛle 'tɛ, 'ke Zesu 'a 'pele ‑a ni dɔɔ: «'Mi ‑le mɛɛ mu bwe gale ba, 'bhɛɛ‑ 'mi ‑le bole ‑yrɛ ma ‑si na mɛɛ ni. 'Ke mɛɛ 'la zan 'e ꞊kpaa 'mi 'yi, 'ali‑ 'kee‑ ‑gaa, 'ŋ nu ‑a bwelɛ gale ba, 'bhɛɛ‑ ‑e bo ‑a ‑yrɛ ma. ");
INSERT INTO moa_vpl VALUES ("JN11_26","073_11_26","JHN","11","26","26","'Bhɛɛ‑ 'ke mɛɛ 'oo mɛɛ 'la zan ‑o ‑a ‑yrɛ ma, 'bhɛɛ‑ 'ke ‑ya ‑kpaa 'mi 'yi, 'bhɛ zan laa nu galɛ ‑titi. 'Yee kpa 'bhɛ ‑jan 'ɛ 'yi ɛɛ?» ");
INSERT INTO moa_vpl VALUES ("JN11_27","073_11_27","JHN","11","27","27","'Bhɛ ꞊nɔɔ bhe, 'ke Maati 'a 'lɛkunle Zesu ni dɔɔ: «‑Aani' Mɛɛzan, 'an 'yaango‑ dɔɔ 'bhi ‑le Mɛɛ ‑Bhee Mi ‑Kpɔsɔɔ Krisi 'ɛ 'le, 'bhɛ 'pegee 'bhi ‑le *‑Waanbhaa' Gbe 'ɛ 'le; ‑a ‑lɛdulale ‑yaa dɔɔ 'bhi ‑le ‑yaa nu nulɛ 'drunyan 'yi.» ");
INSERT INTO moa_vpl VALUES ("JN11_28","073_11_28","JHN","11","28","28","Maati 'yanle‑ 'bhɛ ‑jan 'ɛ 'wolele, 'kee‑ gele‑ ‑a nɛɛnɛ‑ le Mari 'siilɛ‑; 'bhɛɛ‑ 'ke ‑ya pele‑ 'bhɛ ni gaanyi' dɔɔ: «‑Kɔɔ' Daan mi 'ɛ ꞊nwa, ‑yoo 'e 'sii zii'.» ");
INSERT INTO moa_vpl VALUES ("JN11_29","073_11_29","JHN","11","29","29","Mari 'bhɛ 'male‑, 'ke ‑ya ‑wlɛnle' blaale‑, 'bhɛɛ‑ 'kee‑ gele‑ Zesu 'lɛpalɛ. ");
INSERT INTO moa_vpl VALUES ("JN11_30","073_11_30","JHN","11","30","30","'Duŋ‑ Zesu 'laa wlalɛ ‑li 'bhɛ bhla 'ɛ ba Betani ‑wa 'ɛ 'kpee. Maati 'lɛpaa‑ 'kɛle‑ yrɛ 'la ꞊nɔɔ, ‑e ‑yaa ‑li 'bhɛɛ‑ ꞊nɔɔ. ");
INSERT INTO moa_vpl VALUES ("JN11_31","073_11_31","JHN","11","31","31","Zuufu mu 'la 'yaa‑ Mari ‑din 'fɛ 'ɛ ꞊la ‑a taga zayi', 'mu 'a 'yele‑ 'bhii‑ Mari 'e 'wlɛnle‑, 'bhɛɛ‑ ‑e ‑pwɛla 'pɛɛlii‑ blaale‑; 'ke ‑o dɔle‑ ‑a zi. ‑O 'kpee ma ‑e ‑yaa ge 'zi wisilɛ Lazaa bu 'ɛ ta. ");
INSERT INTO moa_vpl VALUES ("JN11_32","073_11_32","JHN","11","32","32","Zesu 'yaa‑ yrɛ 'la ꞊nɔɔ, Mari 'bhɔle‑ 'bhɛ yrɛ 'ɛ ꞊nɔɔ, 'bhɛɛ‑ ‑a ‑yrɛkpale Zesu ma, 'kee‑ baale' ‑a 'kpɔ ta 'bhɛ gaan ma, 'bhɛɛ‑ 'ke ‑ya pele‑ 'kaa: «Mɛɛzan 'kee‑ 'kpa bi ‑gɛ, 'ŋ nɛɛnɛ‑ 'ɛ yaa ‑yaa nu galɛ.» ");
INSERT INTO moa_vpl VALUES ("JN11_33","073_11_33","JHN","11","33","33","Zesu Mari 'yele‑ wisiyrɛ nɔɔ‑, 'bhɛ 'pegee Zuufu mu 'la 'yaa‑ 'yee‑ Mari zi, ‑e 'mu 'yele‑ wisi' yrɛ nɔɔ‑ 'ezin‑, 'bhɛ wisi' ‑gbɔɔ ‑dwa ‑a ‑yrɛ ta 'egbɛnɛle, 'bhɛɛ‑ ‑a zrubatɛdwa. ");
INSERT INTO moa_vpl VALUES ("JN11_34","073_11_34","JHN","11","34","34","'Bhɛɛ‑ 'ke Zesu ‑o ‑lrɔkpale dɔɔ: «'Kaa ꞊bian 'naa‑ ma ɛɛ?» ‑O pe ‑a ni dɔɔ: «Mɛɛzan, nu a ‑glin doo.» ");
INSERT INTO moa_vpl VALUES ("JN11_35","073_11_35","JHN","11","35","35","'Bhɛɛ‑ Zesu 'gbu wisia꞊. ");
INSERT INTO moa_vpl VALUES ("JN11_36","073_11_36","JHN","11","36","36","'Bhɛ klɛle 'tɛ, 'ke Zuufu mu 'ɛ ‑wa pele‑ 'eke‑ ni dɔɔ: «‑Kaa ‑glin doo! 'Gwlaan‑ 'lɛɛ‑ ‑za ‑yaa sɔ ‑a ni dɛ!» ");
INSERT INTO moa_vpl VALUES ("JN11_37","073_11_37","JHN","11","37","37","'Duŋ‑ ‑o 'ke pe dɔɔ: «'Yee‑ 'la mɛɛ ‑yrɛ 'wi mi 'ɛ 'yrɛ 'liiploola, yaa ‑yaa sɔ ‑a klɛle‑ 'bhɛɛ‑ Lazaa 'laa ga ɛɛ?» ");
INSERT INTO moa_vpl VALUES ("JN11_38","073_11_38","JHN","11","38","38","Wisi' ‑gbɔɔ dɔ gbɛ drɛɛwoa‑ 'egbɛnɛle Zesu 'yrɛ ta, 'bhɛɛ‑ ‑e ‑ja Lazaa bu 'ɛ ta. ‑A bu 'ɛ 'yaa‑ 'ke vlɛ ‑gluu do ‑la ‑le, 'bhɛɛ‑ ‑wa ‑liitaan 'ke vlɛ ‑kpuŋ ‑gbɛnɛ do ‑la ‑le. ");
INSERT INTO moa_vpl VALUES ("JN11_39","073_11_39","JHN","11","39","39","Zesu pe mɛɛ mu 'ɛ ni dɔɔ: «‑Ka vlɛ ‑kpuŋ 'ɛ go bu ‑gluu 'ɛ 'lii doo!» 'Bhɛ klɛle 'tɛ, Maati, 'yee‑ Lazaa nɛɛnɛ‑ le 'ɛ, 'ke ‑ya 'pele Zesu ni dɔɔ: «Mɛɛzan, ‑a vɛndwa‑ gban 'eyɔɔle, ‑amasrɔyi ‑a binle blaan ‑yrekpaa' yiziɛ ‑le ‑gɛ.» ");
INSERT INTO moa_vpl VALUES ("JN11_40","073_11_40","JHN","11","40","40","'Bhɛ 'yi 'tɛ, 'ke Zesu 'a 'pele Maati ni dɔɔ: «'Naa 'pelɛ 'e ni dɔɔ 'kaa 'ke 'yee ꞊kpaa 'mi 'yi, 'e nu ‑Waanbhaa' a 'tɔbhɔleya 'ɛ 'yelɛ ɛɛ?» ");
INSERT INTO moa_vpl VALUES ("JN11_41","073_11_41","JHN","11","41","41","'Bhɛ klɛle 'tɛ, 'ke ‑o vlɛ ‑kpuŋ 'ɛ gole‑ bu ‑gluu 'ɛ 'lii. 'Bhɛɛ‑ Zesu 'e 'yrɛkpale laanima, 'ke ‑ya pele‑ dɔɔ: «'Ŋ Dɛ ‑Waanbhaa', 'mi 'e 'pubɔ‑ ‑amasrɔyi 'ye 'an 'seri 'ɛ 'lɛkwan‑ gban. ");
INSERT INTO moa_vpl VALUES ("JN11_42","073_11_42","JHN","11","42","42","'Mi 'an 'yaango‑ 'bhii‑ 'ye 'an 'seri mu 'ɛ 'lɛkun‑ 'taŋii, 'duŋ‑ 'ŋ 'yoo‑ 'seri 'lɛɛ‑ klɛ 'zi 'e ni, 'ŋ zi mɛɛ mu 'lɛɛ‑ 'wola‑ ‑zayi'; 'kooko‑ ‑woo kpa ‑a ‑yi 'bhii‑ 'bhi ‑le 'mi 'winbwa‑.» ");
INSERT INTO moa_vpl VALUES ("JN11_43","073_11_43","JHN","11","43","43","‑E yanle‑ 'bhɛ ‑jan 'ɛ 'wole‑ 'le, 'kee‑ 'pɛɛnle 'eglɔɔle dɔɔ: «Lazaa 'pwɛ ‑gɛ!» ");
INSERT INTO moa_vpl VALUES ("JN11_44","073_11_44","JHN","11","44","44","'Bhɛ klɛle 'tɛ, 'ke Lazaa gbaa 'ɛ bwele‑, 'bhɛɛ‑ ‑e ‑pwɛla. ‑A gbɛ 'pegee ‑a gaan mu 'ɛ 'yrele‑ ‑yaa 'ke sɔgbɛ mu 'le, 'bhɛɛ‑ sɔgbɛ 'pu do 'kpale‑ ‑yaa ‑a wlɛyi'. Zesu pe ‑o ni 'tɛ dɔɔ: «‑Kaa 'ploo‑, 'bhɛɛ‑ ‑e ge a 'gbu ma!» ");
INSERT INTO moa_vpl VALUES ("JN11_45","073_11_45","JHN","11","45","45","Zuufu mu 'la ꞊nwa Mari ba, 'bhɛɛ‑ Zesu ‑za 'la ꞊kla, ‑o 'bhɛ 'yele‑, 'ke ‑o ‑bebe ‑o 'kpale 'a ‑yi. ");
INSERT INTO moa_vpl VALUES ("JN11_46","073_11_46","JHN","11","46","46","'Duŋ‑ ‑o 'ke ‑ja Farizi mu 'ɛ ba, 'ke ‑o Zesu klɛza 'ɛ 'kpɛn 'yigɔɔnle 'mu ni. ");
INSERT INTO moa_vpl VALUES ("JN11_47","073_11_47","JHN","11","47","47","'Sraka 'lɛna ‑kuŋlii mu 'ɛ 'pegee Farizi mu 'ɛ ‑o ‑waa 'kitikan mɛɛ gblaan ‑lɛdo' 'ɛ 'lɛkpaa‑ 'eke‑ ta, 'bhɛɛ‑ 'ke ‑wa pele‑ dɔɔ: «‑Kɔɔ' nu ‑mɛ za 'gbu ‑la klɛlɛ ɛɛ? ‑Amasrɔyi ‑yoo 'sɔle‑ maza ‑bebe mu klɛ 'zi. ");
INSERT INTO moa_vpl VALUES ("JN11_48","073_11_48","JHN","11","48","48","'Ke ‑kɔɔ' 'a 'twa‑ 'kee ꞊bwa klɛza ‑glɔɔn mu 'lɛɛ‑ klɛle ma, ‑kɔɔa' mɛɛ mu 'ɛ 'kpɛn nu ‑o 'kpalɛ ‑a ‑yi. 'Ke 'bhɛ ꞊kla, *Romɛ ‑kuŋlii mu 'ɛ ‑o nu nulɛ ‑kɔɔa' ‑Waanbhaa' Gba 'Fɛ ‑Gbɛnɛ 'ɛ 'pegee ‑kɔɔa' 'klɛɛn 'ɛ 'wilɛ‑ 'dɛ!» ");
INSERT INTO moa_vpl VALUES ("JN11_49","073_11_49","JHN","11","49","49","'Bhɛ klɛle 'tɛ, ‑o ba mɛɛ do 'la ‑o ‑yaa 'bhɛ sii Kaifu, 'bhɛɛ‑ 'ke 'bhɛ 'yaa‑ ‑waa' 'sraka 'lɛna ‑kuŋlii gblaan 'le 'bhɛ lɛɛ 'ɛ ta bhe, 'bhɛ pe ‑o ni dɔɔ: «'Ka 'laa ‑za 'kedo‑ 'kpɔ 'yima‑! ");
INSERT INTO moa_vpl VALUES ("JN11_50","073_11_50","JHN","11","50","50","'Kaa 'laa 'yaango‑ dɔɔ 'ke mɛɛ do 'kpɔ ‑gaa 'klɛɛn 'yi mu 'ɛ 'kpɛn a ‑za ma, 'bhɛ mabhaabhɔ ‑kɔɔ' 'gbu ma 'ke 'bhɛ kan ‑kɔɔa' mɛɛ mu 'ɛ 'kpɛn dɛle ta ɛɛ?» ");
INSERT INTO moa_vpl VALUES ("JN11_51","073_11_51","JHN","11","51","51","'Duŋ‑ Kaifu ‑jan 'la 'woa‑ bhe, 'bhɛ 'laa dalɛ ‑a 'gbu ba; ‑e ‑yaa 'ke 'sraka 'lɛna mu ‑kuŋlii gblaan 'le 'bhɛ lɛɛ 'ɛ 'le, 'bhɛla‑ ‑zayile ‑e ‑yaa ‑Waanbhaa' ‑lɛla' janwo 'zi dɔɔ Zesu 'yaa‑ nu galɛ Zuufu mu 'ɛ ni. ");
INSERT INTO moa_vpl VALUES ("JN11_52","073_11_52","JHN","11","52","52","'Duŋ‑ Zesu 'laa ‑yaa nu galɛ Zuufu mu 'ɛ do ‑kplɛn ni. ‑Waanbhaa' a mɛɛ mu 'la 'kpɛn 'piilale ‑o 'drunyan 'yi yrɛkpɛn‑ ꞊nɔɔ, ‑e 'yaa‑ nu galɛ 'mu ‑la ni 'ezin‑; 'kooko‑ ‑yoo 'kpɛn 'lɛkpa‑ 'eke‑ ta, 'bhɛɛ‑ ‑yoo klɛ mɛɛ 'si do 'le. ");
INSERT INTO moa_vpl VALUES ("JN11_53","073_11_53","JHN","11","53","53","‑A 'san 'bhɛ yi 'ɛ ma, Zuufu mu a ‑kuŋlii mu 'ɛ ‑waa ‑kpaa do ma dɔɔ ‑o nu Zesu dɛlɛ. ");
INSERT INTO moa_vpl VALUES ("JN11_54","073_11_54","JHN","11","54","54","'Bhɛla‑ ‑zayile, Zesu 'laa ‑yaa 'kaan zii' ‑li Zuufu mu 'ɛ 'pleŋ‑ mɔkpɛn' 'yrɛ ma kpataakpa. ‑E ‑gwa 'bhɛ yrɛ 'ɛ ꞊nɔɔ, 'bhɛɛ‑ 'yee‑ 'pegee ‑yaa' ‑klaŋlanɛ mu 'ɛ ‑ja 'klɛɛn do 'yi ‑wa do ta ‑kpe 'ɛ ba ‑yrɛ ta. ‑O ‑yaa' 'bhɛ ‑wa 'ɛ sii Efraimu. Zesu 'pegee ‑yaa' ‑klaŋlanɛ mu 'ɛ ꞊bwa 'bhɛɛ‑ ‑wa 'ɛ ta ye. ");
INSERT INTO moa_vpl VALUES ("JN11_55","073_11_55","JHN","11","55","55","Zuufu mu a Paki 'fɛti 'ɛ ꞊bhwa gban bi ‑wa ‑din. 'Bhɛla‑ ‑yile, mɛɛ ‑bebe ‑ja Zeruzalɛmu 'yee‑ 'fɛti 'ɛ 'lɛɛ, 'kooko‑ ‑o ‑yaa ‑za 'la klɛ ‑waa' 'toŋ 'ɛ ta, 'bhɛɛ‑ ‑o klɛ 'weŋ ‑Waanbhaa' ‑yrɛ 'yi, ‑o 'bhɛ klɛ ‑sɔ. ");
INSERT INTO moa_vpl VALUES ("JN11_56","073_11_56","JHN","11","56","56","‑O 'yaa‑ Zesu ziglin‑ 'zi 'tɛ. 'Bhɛɛ‑ ‑o ‑yaa bhla 'la ba ‑Waanbhaa' Gba 'Fɛ ‑Gbɛnɛ 'ɛ ꞊la, ‑o ‑yaa pe 'zi 'eke‑ ni dɔɔ: «‑E ꞊kla 'nale‑ ɛɛ? ‑E nu nulɛ 'fɛti 'ɛ ta taa‑ yaa nu nulɛ ɛɛ?» ");
INSERT INTO moa_vpl VALUES ("JN11_57","073_11_57","JHN","11","57","57","'Duŋ‑ 'sraka 'lɛna ‑kuŋlii mu 'ɛ 'pegee Farizi mu 'ɛ ‑wa ‑pia gban mɛɛ mu 'ɛ ni dɔɔ 'ke mɛɛ 'oo mɛɛ 'la zan ‑yaa Zesu geyrɛ 'ɛ dɔ, 'bhɛ zan nu 'bhɛ 'pe ‑o ni, 'kooko‑ ‑o ge ‑a 'kunlɛ‑. ");
INSERT INTO moa_vpl VALUES ("JN12_1","073_12_1","JHN","12","1","1","‑Yrekpaa' 'srwado‑ ‑yaa Zuufu mu a Paki 'fɛti 'ɛ 'lɛɛ, 'bhɛɛ‑ Zesu ge gbɛ drɛɛwoa‑ Betani ‑wa 'ɛ ta. ‑E Lazaa 'la ‑bwela gale ba, 'bhɛ a ‑wa ‑le ‑yaa Betani 'le. ");
INSERT INTO moa_vpl VALUES ("JN12_2","073_12_2","JHN","12","2","2","‑O 'yee Zesu 'lɛwɛɛ pɛ ꞊kla 'bhɛɛ‑ ꞊nɔɔ. Maati ‑yaa pɛbhle 'ɛ 'yiciɛn zii'. 'Bhɛɛ‑ Lazaa 'pegee Zesu 'bhɛɛ‑ ‑yaa' ‑klaŋlanɛ mu 'ɛ 'yaale‑ ‑yaa pɛbhle ‑tabali 'ɛ zi. ");
INSERT INTO moa_vpl VALUES ("JN12_3","073_12_3","JHN","12","3","3","'Bhɛ bhla 'ɛ ba, 'ke Mari ‑lasiklɔɔ ‑kpɔsɔɔ 'plɛɛle‑ buteli do 'sile, 'bhɛɛ‑ 'kee‑ Zesu gaan ma 'srole 'kɛle‑. 'Bhɛ blaan, 'kee‑ 'bhɛ gaan mu 'ɛ magole 'ke ‑a winle mu 'ɛ 'le. 'Bhɛ ya 'ɛ 'yi, 'ke ‑lasiklɔɔ 'ɛ ‑gblɛn 'ɛ zɛnle‑ 'fɛ 'ɛ 'kpɛn ꞊la. ");
INSERT INTO moa_vpl VALUES ("JN12_4","073_12_4","JHN","12","4","4","‑O ‑yaa Zesu a ‑klaŋlanɛ 'kɛla sii Zuda Isikariɔti, 'yee‑ 'la 'yaa‑ nu ‑dawli' 'kpalɛ‑ Zesu gbɛ ta, 'bhɛɛ‑ ‑ya ‑lɛna' mɛɛ mu ni, 'bhɛ pe 'tɛ dɔɔ: ");
INSERT INTO moa_vpl VALUES ("JN12_5","073_12_5","JHN","12","5","5","«‑Mɛle ‑kla waa ‑lasiklɔɔ ‑gblɛn 'nrale‑ 'lɛɛ‑ gɔnlɛ ‑gɔli' 'taŋbha ‑kɛmɛ yaga ma, 'bhɛɛ‑ ‑o 'bhɛ ‑gɔli' 'ɛ na 'kɔɔfleŋzan mu ni ɛɛ?» ");
INSERT INTO moa_vpl VALUES ("JN12_6","073_12_6","JHN","12","6","6","'Duŋ‑ Zuda 'bhɛ ‑jan 'ɛ ꞊woa 'bhɛ gbɛɛn‑ bhe, yaa klɛlɛ 'bhii‑ ‑e ‑yaa 'kɔɔfleŋzan mu ‑si yiɛnkan' zii'. 'Duŋ‑ ‑e 'bhɛ 'pia‑ bhɛ gbɛɛn‑, ‑amasrɔyi ‑e ‑yaa 'ke ‑faannii' 'le: 'Yele‑ ‑yaa ‑waa' ‑gɔli' bɔpɛ 'ɛ magaan mi 'le, 'bhɛɛ‑ 'ke ‑o ‑yaa ‑gɔli' 'la bɔ 'bhɛ 'yi, ‑e ‑yaa 'bhɛ 'si. ");
INSERT INTO moa_vpl VALUES ("JN12_7","073_12_7","JHN","12","7","7","'Duŋ‑ Zesu 'a zikpaa‑ ‑a ni dɔɔ: «‑Kaa 'to 'srɔ! ‑E 'bhɛ ꞊kla, 'ŋ binza 'ɛ 'lɛɛmagaanza 'yi ‑sɔ. ");
INSERT INTO moa_vpl VALUES ("JN12_8","073_12_8","JHN","12","8","8","'Kɔɔfleŋzan mu ‑o 'ka ‑din 'taŋii, 'duŋ‑ 'mi 'laa nu klɛlɛ 'ka ‑din 'taŋii.» ");
INSERT INTO moa_vpl VALUES ("JN12_9","073_12_9","JHN","12","9","9","Zuufu mu ‑zamaa' ‑gbɛnɛ do 'a ꞊maa dɔɔ Zesu ‑o Betani. ‑Ayile 'ke ‑o gele‑ 'bhɛ ꞊nɔɔ. 'Duŋ‑ waa gelɛ Zesu do ‑kplɛn ‑glin zayi', ‑o ‑ja Lazaa 'la 'ke Zesu 'bhɛ ‑bwela gale ba 'bhɛɛ‑ ‑zayi' 'ezin‑. ");
INSERT INTO moa_vpl VALUES ("JN12_10","073_12_10","JHN","12","10","10","'Bhɛ klɛle 'tɛ, 'ke 'sraka 'lɛna ‑kuŋlii mu 'ɛ ‑wa 'kpale dɔɔ ‑o Lazaa dɛle‑ 'ezin‑. ");
INSERT INTO moa_vpl VALUES ("JN12_11","073_12_11","JHN","12","11","11","‑Amasrɔyi 'yee‑ Lazaa ‑zayi', Zuufu mu ‑bebe ‑yaa go 'zi 'woo‑ 'sraka 'lɛna ‑kuŋlii mu 'ɛ 'zi, 'bhɛɛ‑ ‑o ‑yaa ‑o 'kpa zii' Zesu 'yi. ");
INSERT INTO moa_vpl VALUES ("JN12_12","073_12_12","JHN","12","12","12","'Bhɛ yi 'ɛ ta tooklin‑ yi 'le, ‑zamaa' ‑gbɛnɛ 'la 'nwa‑ Paki 'fɛti 'ɛ ta, ‑wa ꞊maa dɔɔ Zesu ‑o zan Zeruzalɛmu ‑wa 'ɛ ta. ");
INSERT INTO moa_vpl VALUES ("JN12_13","073_12_13","JHN","12","13","13","'Bhɛla‑ ‑yile, 'ke ‑o yɔ ‑laa mu 'kanle, 'ke ‑o 'pwɛle‑ ‑wa 'ɛ 'kpee, 'bhɛɛ‑ 'ke ‑o 'kpɛn gele‑ ‑a ‑lɛpa' yrɛ nɔɔ‑. ‑O ‑yaa 'pe 'zi 'eke‑ 'zi 'eglɔɔle dɔɔ: «Ozana! Mɛɛ 'la zan ‑o zan Mɛɛzan 'ɛ 'tɔ 'yi, bhaa ‑Waanbhaa' 'bhɛ ‑dɔɔbo'! Bhaa ‑Waanbhaa' Izraɛli mu a ‑bhleŋgbe 'ɛ 'dumawo!» ");
INSERT INTO moa_vpl VALUES ("JN12_14","073_12_14","JHN","12","14","14","Zesu ‑soofali 'nɛ do ꞊ya, 'bhɛɛ‑ ‑a 'sanle‑ ‑yaa 'bhɛɛ‑ ta, 'bhii‑ ‑a yɔɔndɛle ‑o ‑Waanbhaa' a 'Sɛwɛ 'yi gɔnɛ‑ 'la gbɛɛn‑ dɔɔ: ");
INSERT INTO moa_vpl VALUES ("JN12_15","073_12_15","JHN","12","15","15","«Siɔn ‑wa ‑la mu, 'ka 'laa ‑gblaanlɛ' (Zeruzalɛmu 'tɔ 'ɛ do ‑le ‑yaa 'bhɛ 'le 'ezin‑). ‑Ka 'ka 'yrɛkpa doo, 'kaa‑ ‑bhleŋgbe 'ɛ ‑yoo zan, ‑a yaale ‑o ‑soofali 'nɛ do ta.» ");
INSERT INTO moa_vpl VALUES ("JN12_16","073_12_16","JHN","12","16","16","'Bhɛ 'waati 'ɛ ba, Zesu a ‑klaŋlanɛ mu 'ɛ waa 'bhɛ ‑za mu 'ɛ 'yimalɛ 'elwale 'pe. 'Duŋ‑ Zesu bwelawoa gale ba, 'bhɛɛ‑ ‑e ‑ja ‑Waanbhaa' a 'tɔbhɔleya 'ɛ 'yi 'waati 'la ba, 'bhɛɛ‑ ‑wa 'yaangwa‑ dɔɔ ‑Waanbhaa' ‑lɛla' janwo mu 'ɛ ‑o ‑za mu 'la yɔɔndia‑ Zesu ba zayi' mɛɛ mu 'ɛ ‑o 'bhɛɛ‑ wlata za ꞊kla ‑a ni. ");
INSERT INTO moa_vpl VALUES ("JN12_17","073_12_17","JHN","12","17","17","Mɛɛ 'la zan mu 'kpɛn 'yaa‑ Zesu zi ‑e Lazaa 'siila‑ bu ‑gluu 'ɛ 'yi bhla 'la ba, 'bhɛɛ‑ 'bhɛ ‑bwela gale ba; 'bhɛ mɛɛ mu 'ɛ 'yaa‑ ‑za mu 'la ꞊kla 'mu ‑yrɛ ma, 'mu 'kpɛn 'yigɔɔn‑ 'zi. ");
INSERT INTO moa_vpl VALUES ("JN12_18","073_12_18","JHN","12","18","18","'Bhɛla‑ ‑zayile, 'ke ‑zamaa' 'srɛ do gele‑ ‑a ‑lɛpayrɛ nɔɔ‑. ‑Amasrɔyi ‑wa ‑maa 'kaa ‑e 'bhɛ 'sɔle‑ maza 'ɛ ꞊kla. ");
INSERT INTO moa_vpl VALUES ("JN12_19","073_12_19","JHN","12","19","19","'Bhɛ klɛle 'tɛ, 'ke Farizi mu 'ɛ ‑wa pele‑ dɔɔ: «‑Ka 'ka 'yrɛkpa ‑o ta doo, 'ka 'laa nu 'sɔlɛ‑ ‑za 'kedo‑ 'kpɔ klɛle‑ ‑a ni, ‑amasrɔyi mɔkpɛn' ‑o ge 'zi ‑a zi.» ");
INSERT INTO moa_vpl VALUES ("JN12_20","073_12_20","JHN","12","20","20","Mɛɛ 'la zan mu ‑nwa ‑Waanbhaa' gbalɛ Zeruzalɛmu 'fɛti 'ɛ ta, Grɛki mu 'ke mu ‑yaa 'mu pleŋ‑. ");
INSERT INTO moa_vpl VALUES ("JN12_21","073_12_21","JHN","12","21","21","'Bhɛ 'yi 'tɛ, 'ke ‑woo mabɛɛnle Filipu ‑din, 'bhɛ 'yaa‑ da Galile 'klɛɛn 'yi ‑wa 'la ‑o ‑yaa 'bhɛ sii Bɛtisaida 'bhɛɛ‑ ta. 'Bhɛɛ‑ ‑o pe Filipu ni dɔɔ: «'O Zan, ꞊wa zi 'bhii‑ 'o Zesu 'ye, 'bhɛɛ‑ 'o ‑balo sa klɛ 'kɛle‑.» ");
INSERT INTO moa_vpl VALUES ("JN12_22","073_12_22","JHN","12","22","22","'Bhɛ klɛle 'tɛ, 'ke Filipu gele‑ 'bhɛ 'pelɛ‑ Andre ni, 'bhɛɛ‑ ‑o mɛɛ plɛ ‑ja 'bhɛ 'pelɛ‑ Zesu ni. ");
INSERT INTO moa_vpl VALUES ("JN12_23","073_12_23","JHN","12","23","23","‑Ayile, 'ke Zesu 'a pele ‑o ni dɔɔ: «Bhaaplɛŋ Gbe 'ɛ nu 'tɔbhɔleya 'srɔɔwolɛ ‑Waanbhaa' 'kɔɔ 'waati 'la ba, 'bhɛ 'waati 'ɛ ꞊bhwa. ");
INSERT INTO moa_vpl VALUES ("JN12_24","073_12_24","JHN","12","24","24","'Mi pe 'ka 'ni 'ŋ 'sɔwɛɛ‑ ma dɔɔ: 'Ke waa pɛbhɛ do bɔlɛ 'trɛ 'yi, 'bhɛɛ‑ ‑e bɔn, ‑e bo ‑a do ‑kplɛnnɛya 'ɛ 'yi. 'Duŋ‑ 'ke ‑wa ꞊bwa 'trɛ 'yi, 'bhɛɛ‑ 'kee‑ ꞊bwan, ‑e bhɔ 'bhɛɛ‑ ‑ya bhaa klɛ 'ebebele. ");
INSERT INTO moa_vpl VALUES ("JN12_25","073_12_25","JHN","12","25","25","'Ke mɛɛ 'la zan lii biile ‑o 'bhɛ a 'trɛ ta ‑gɛ ‑si 'ɛ 'yi, 'bhɛ zan nu bloolɛ 'bhɛ 'yi. 'Duŋ‑ 'ke mɛɛ 'la zan 'bhɛ 'niigwa‑ 'bhɛ a 'trɛ ta ‑gɛ ‑si 'ɛ 'yi, 'bhɛ zan nu ‑Waanbhaa' ba bole ‑yrɛ ma ‑si 'la ‑daŋ' 'laa ‑o 'bhɛ ma 'bhɛ 'srɔɔwolɛ. ");
INSERT INTO moa_vpl VALUES ("JN12_26","073_12_26","JHN","12","26","26","'Ke mɛɛ 'la zan ‑o ‑a zi 'bhii‑ ‑e yewo 'mi ni, 'bhɛ zan dɔ 'ŋ zi. 'Bhɛ ya 'ɛ 'yi, 'ke 'ŋ 'yoo‑ yrɛ 'la ꞊nɔɔ, 'an yewonɛ 'ɛ nu klɛlɛ 'ŋ zi 'bhɛɛ‑ yrɛ 'ɛ ꞊nɔɔ. 'Ke mɛɛ 'la zan yewo 'ŋ ni 'ŋ Dɛ ‑Waanbhaa' nu 'bhɛ zan 'ɛ ‑lɛdɔlɛ ‑a ma.» ");
INSERT INTO moa_vpl VALUES ("JN12_27","073_12_27","JHN","12","27","27","Zesu pe 'ezin‑ dɔɔ: «'Ŋ zru ba 'tɛ ‑o ‑zɔn. 'Bhɛɛ‑ 'ŋ sɔ a pele‑ 'nale‑ ‑a ma ɛɛ? Taa‑ 'an 'pe dɔɔ: 'Ŋ Dɛ ‑Waanbhaa, 'ŋ go ‑yrɛnbhle' 'waati 'lɛɛ‑ 'yi ɛɛ? 'Bhɛɛ‑ 'duŋ‑, 'ŋ 'nwa‑ 'bhɛɛ‑ ‑yrɛnbhle' 'waati 'lɛɛ‑ 'bhɛɛ‑ ‑zayi'. ");
INSERT INTO moa_vpl VALUES ("JN12_28","073_12_28","JHN","12","28","28","'Ŋ Dɛ ‑Waanbhaa', 'e 'tɔ 'ɛ magbaandɛ!» 'Bhɛ klɛle 'tɛ, 'ke ‑weli' do dale‑ laanima dɔɔ: «'Mi 'ŋ 'tɔ 'ɛ magbaandia gban, 'bhɛɛ‑ 'ŋ nu ‑a magbaandɛ gbɛ drɛɛwolɛ 'ezin‑.» ");
INSERT INTO moa_vpl VALUES ("JN12_29","073_12_29","JHN","12","29","29","‑Zamaa' 'la 'yaa‑ Zesu ‑din, 'bhɛ mu 'yee ‑weli' 'ɛ 'male‑, 'ke ‑wa pele‑ dɔɔ: «‑Gblaŋ ‑le 'pɛɛ zii' bhe». 'Duŋ‑ ‑o 'ke mu pe dɔɔ: «‑Waanbhaa' a ‑mlɛkɛ' do ‑le ‑janwoa ‑a ni!» ");
INSERT INTO moa_vpl VALUES ("JN12_30","073_12_30","JHN","12","30","30","'Duŋ‑ Zesu 'a zikpaa‑ ‑o ni dɔɔ: «'Ka ‑weli' 'la ꞊maa bhe, 'bhɛ 'laa ‑welɛ' 'mi 'kaama‑, 'duŋ‑ ‑e ꞊wia 'ka mu ‑la 'kaama‑. ");
INSERT INTO moa_vpl VALUES ("JN12_31","073_12_31","JHN","12","31","31","'Drunyan 'lɛɛ‑ ta 'kitikan yi 'ɛ ꞊bhwa ‑zɔn. ‑Setran' 'la 'kpaale‑ ‑o 'drunyan 'lɛɛ‑ 'wiiŋ‑ 'bhii‑ ‑a ‑kuŋlii, ‑Waanbhaa' nu ‑a ‑gbinlɛ' ‑yaa' ‑kuŋliiya 'ɛ 'yi. ");
INSERT INTO moa_vpl VALUES ("JN12_32","073_12_32","JHN","12","32","32","'Bhɛɛ‑ 'ke ‑woo 'ŋ 'wlɛnna‑ laanima 'waati 'la ba 'trɛ 'lɛɛ‑ ta ‑gɛ, 'ŋ nu mɛɛ mu 'ɛ 'kpɛn ‑glaanlɛ' 'ŋ ba.» ");
INSERT INTO moa_vpl VALUES ("JN12_33","073_12_33","JHN","12","33","33","Zesu 'yaa‑ nu galɛ gɔnɛ‑ 'la gbɛɛn‑ bhe, ‑e 'bhɛɛ‑ ‑zrɔnna ‑o ni ‑janwo' gbɛya 'la bhe 'bhɛ 'yi. ");
INSERT INTO moa_vpl VALUES ("JN12_34","073_12_34","JHN","12","34","34","'Bhɛ klɛle 'tɛ, 'ke ‑zamaa' 'ɛ ‑wa ‑lɛkunle Zesu ni dɔɔ: «'Wa ‑daanna 'waa‑ 'toŋ 'sɛwɛ mu 'ɛ 'yi dɔɔ Mɛɛ ‑Bhee Mi ‑Kpɔsɔɔ Krisi 'ɛ nu bolɛ ‑a ‑yrɛ ma ‑yikpɛnsee ta. ‑E ‑kla 'nale‑ 'bhɛɛ‑ 'bhi ‑o ‑a pe 'zi 'o ni dɔɔ: ‹‑O nu Bhaaplɛŋ Gbe 'ɛ 'wlɛnlɛ‑ laanima ɛɛ?› ‑Dele 'bhɛ Bhaaplɛŋ Gbe 'ɛ 'le ɛɛ?» ");
INSERT INTO moa_vpl VALUES ("JN12_35","073_12_35","JHN","12","35","35","'Bhɛ klɛle 'tɛ, 'ke Zesu 'a 'pele ‑o ni dɔɔ: «'Tɛbhile 'ɛ nu ‑bhilɛ' 'ka 'pleŋ‑ 'waati sa. 'Tɛbhile 'ɛ ‑yoo 'ka 'pleŋ‑ 'waati 'la ba ‑li, ‑ka 'taawo ‑a ‑bhile' 'ɛ ba, 'kooko‑ ‑gblo mu laa nu 'klalɛ‑ 'ka ba. ‑Amasrɔyi 'ke mɛɛ 'la zan ‑o 'taawo zii' ‑gblo mu 'yi, 'bhɛ zan 'laa 'bhɛ 'gbu geyrɛ dɔ. ");
INSERT INTO moa_vpl VALUES ("JN12_36","073_12_36","JHN","12","36","36","'Tɛbhile 'ɛ ‑yoo 'ka 'pleŋ‑ 'waati 'la ba, ‑ka 'ka 'kpa ‑a ‑yi, 'kooko‑ 'ka klɛ 'tɛbhile ba ‑nɛ mu 'le.» Zesu 'yanle‑ 'bhɛ ‑jan mu 'ɛ 'wolele, 'ke ‑ya pleŋgole ‑o ma, 'bhɛɛ‑ 'kee gele‑ ‑a magaanlɛ ‑o ma 'egbɔɔnle. ");
INSERT INTO moa_vpl VALUES ("JN12_37","073_12_37","JHN","12","37","37","'Ali‑ Zesu 'sɔle‑ maza ‑bebe mu 'la ꞊kla ‑o ‑yrɛ ma, Zuufu ‑kuŋlii mu 'ɛ waa ‑o 'kpalɛ‑ ‑a ‑yi. ");
INSERT INTO moa_vpl VALUES ("JN12_38","073_12_38","JHN","12","38","38","'Bhɛ klɛgbɛya 'ɛ gbɛɛn‑ bhe, ‑Waanbhaa' ‑lɛla' janwo mi Ezai ‑jan 'la ꞊woa 'elwale ‑sɔ, 'bhɛ 'lɛswa꞊; ‑ya ‑pia dɔɔ: «Mɛɛzan, ‑dele 'e ꞊kpaa 'o 'wojan‑ 'ɛ 'yi ɛɛ? 'Bhɛɛ‑ Mɛɛzan ‑yaa' ‑glɔɔya' 'ɛ ‑zrɔnna ‑de ‑la ni ɛɛ?» ");
INSERT INTO moa_vpl VALUES ("JN12_39","073_12_39","JHN","12","39","39","'Bhɛɛ‑ waa ‑yaa 'sɔle ‑o 'kpale Zesu 'yi 'bhii‑ ‑Waanbhaa' ‑lɛla' janwo mi 'ɛ ‑ya ꞊pia gɔnɛ‑ 'la gbɛɛn‑ 'ezin‑ dɔɔ: ");
INSERT INTO moa_vpl VALUES ("JN12_40","073_12_40","JHN","12","40","40","«‑Waanbhaa' ‑o ‑yrɛbhɛ' mu 'ɛ ꞊wia, 'bhɛɛ‑ ‑yoo zru ‑dwa 'eglɔɔle ‑yaa' ‑jan 'ɛ ma, 'kooko‑ waa sɔ yrɛ ma yele‑ ‑o ‑yrɛbhɛ' mu 'ɛ 'le, 'bhɛɛ‑ 'kooko‑ waa sɔ ‑za 'yimale ‑o zru mu 'ɛ 'le, 'bhɛɛ‑ waa nu niinalɛ 'mi ‑Waanbhaa' ba, 'bhɛɛ‑ ‑o bhee.» ");
INSERT INTO moa_vpl VALUES ("JN12_41","073_12_41","JHN","12","41","41","Ezai ‑janwoa 'bhɛ gbɛɛn‑ bhe Zesu ba zayi', ‑amasrɔyi ‑e Zesu 'tɔbhɔleya 'ɛ ꞊ya 'elwale ‑sɔ. ");
INSERT INTO moa_vpl VALUES ("JN12_42","073_12_42","JHN","12","42","42","'Duŋ‑, 'woo‑ Zuufu ‑kuŋlii mu 'ɛ ba, ‑o ‑bebe ‑o ‑kpaa Zesu 'yi. 'Duŋ‑ ‑o ‑yaa ‑gblaanlawo zii' Farizi mu 'ɛ 'yrɛ 'lɛɛ bhe, 'bhɛla‑ ‑zayile, waa ‑yaa sɔ ‑a pele‑ 'pɛɛlii‑ kpataakpa, 'kooko‑ waa nu ‑o ‑gbinlɛ' ‑waa' daanfɛ' 'ɛ ꞊la. ");
INSERT INTO moa_vpl VALUES ("JN12_43","073_12_43","JHN","12","43","43","‑Amasrɔyi, 'tɔbhɔleya 'la 'yaa‑ da bhaaplɛŋ mu ba, 'bhɛ 'yaa‑ sɔ ‑o ni 'ke 'bhɛ kan 'kɛla 'yaa‑ da ‑Waanbhaa' ba 'bhɛ ta. ");
INSERT INTO moa_vpl VALUES ("JN12_44","073_12_44","JHN","12","44","44","Zesu pe mɛɛ mu 'ɛ ni 'eglɔɔle dɔɔ: «'Ke mɛɛ 'la zan 'e ꞊kpaa 'mi 'yi, 'bhɛ zan laa 'bhɛ 'kpalɛ‑ 'mi 'yi, 'duŋ‑ ‑ya ꞊kpaa mɛɛ 'la zan 'mi 'winbwa‑ 'bhɛɛ‑ 'yi bhe. ");
INSERT INTO moa_vpl VALUES ("JN12_45","073_12_45","JHN","12","45","45","'Ke mɛɛ 'la zan 'mi ꞊ya, 'bhɛ zan mɛɛ 'la zan 'ŋ 'winbwa‑ 'bhɛɛ‑ ꞊ya bhe. ");
INSERT INTO moa_vpl VALUES ("JN12_46","073_12_46","JHN","12","46","46","'Mi ꞊nwa 'drunyan 'lɛɛ‑ 'yi 'bhii‑ 'tɛbhile, 'kooko‑ 'ke mɛɛ 'oo mɛɛ 'la zan 'e ꞊kpaa 'mi 'yi, 'bhɛ zan laa bo ‑gblo 'yi. ");
INSERT INTO moa_vpl VALUES ("JN12_47","073_12_47","JHN","12","47","47","'Ke mɛɛ 'la zan 'ŋ 'wojan‑ mu 'ɛ ꞊maa, 'bhɛɛ‑ 'ke yaa 'mu 'yizaklɛlɛ, 'mi 'laa nu 'bhɛ zan 'ɛ 'kitikanlɛ. ‑Amasrɔyi 'ŋ ꞊nwa mɛɛ mu go yrɛ ‑la nɔɔ‑ ‑za 'yi, 'mi 'laa 'nulɛ‑ 'kitikan yrɛ nɔɔ‑. ");
INSERT INTO moa_vpl VALUES ("JN12_48","073_12_48","JHN","12","48","48","'Ke mɛɛ 'la zan 'e ‑baŋgwa 'mi 'yi, 'bhɛɛ‑ 'ke 'bhɛ zan laa dɔlɛ 'ŋ 'wojan‑ mu 'ɛ ꞊la, 'bhɛ zan 'ɛ 'bhɛ 'bhɛ 'gbu 'kitikan mi ꞊ya gban. 'Ŋ ‑jan mu 'la ꞊woa 'ka ni bhe, 'mu ‑le nu 'bhɛ zan 'ɛ 'kitikanlɛ 'drunyan 'lɛyan yi 'ɛ 'le. ");
INSERT INTO moa_vpl VALUES ("JN12_49","073_12_49","JHN","12","49","49","‑Amasrɔyi 'ŋ 'wojan‑ mu 'ɛ waa dalɛ 'mi 'gbu ba. 'Duŋ‑ 'ŋ Dɛ ‑Waanbhaa' 'la 'bhɛ 'ŋ 'winbwa‑ 'bhɛ ‑jan 'la ꞊kpaa 'ŋ 'lii 'mi 'bhɛɛ‑ ꞊woa. ");
INSERT INTO moa_vpl VALUES ("JN12_50","073_12_50","JHN","12","50","50","'Bhɛɛ‑ 'mi 'a 'yaango‑ 'bhii‑ 'ŋ Dɛ ‑Waanbhaa' pe 'ŋ ni 'ŋ 'kɛla klɛ, 'bhɛ ‑le bole ‑yrɛ ma ‑si 'la ‑daŋ' 'laa ‑o ‑a ma 'bhɛ nalele mɛɛ mu ni. 'Bhɛɛ‑ ya 'ɛ 'yi, 'ŋ Dɛ ‑Waanbhaa' ‑jan yɛkɛ‑ do 'kpɔ 'la ꞊kpaa 'ŋ 'lii 'ŋ 'bhɛɛ‑ 'wo zii'.» ");
INSERT INTO moa_vpl VALUES ("JN13_1","073_13_1","JHN","13","1","1","'Bhɛ ꞊kla Zuufu mu a Paki 'fɛti yi 'ɛ 'lɛɛ. 'Bhɛɛ‑ Zesu 'gbu 'a 'yaangwa‑ 'bhii‑ ‑a go bhla 'drunyan 'lɛɛ‑ 'yi, 'bhɛɛ ‑e ge ‑a Dɛ ‑Waanbhaa' ba 'bhɛ ꞊bhwa. Mɛɛ 'la zan mu ‑yaa yaa pɛ 'le, 'mu ‑za ‑swa ‑a ni 'taŋii, 'ke 'bhɛ ge 'tɛnlɛ‑ ‑a ‑lɛyanle ma. ");
INSERT INTO moa_vpl VALUES ("JN13_2","073_13_2","JHN","13","2","2","Zesu 'pegee ‑yaa' ‑klaŋlanɛ mu 'ɛ ‑yaa yromazi pɛ 'ɛ 'bhle zii'. ‑Setran' 'a ꞊kpaa Simɔ gbe Zuda Isikariɔti 'kpee gban 'elwale ‑sɔ dɔɔ ‑e ‑dawli' 'kpa Zesu gbɛ ta, 'bhɛɛ‑ ‑e 'bhɛ 'lɛna‑ mɛɛ mu ni. ");
INSERT INTO moa_vpl VALUES ("JN13_3","073_13_3","JHN","13","3","3","Zesu 'gbu 'yaa‑ 'yaango‑ 'bhii‑ ‑Waanbhaa' 'seŋ 'kpɛn ‑glɔɔn gbɛkpaa‑ ‑a 'kɔɔ, 'bhɛɛ‑ ‑e ‑daa 'bhɛ ‑la ba, 'bhɛɛ‑ ‑e ‑yaa zan gelɛ 'bhɛ ‑la ba 'ezin‑. ");
INSERT INTO moa_vpl VALUES ("JN13_4","073_13_4","JHN","13","4","4","'Bhɛ klɛle 'tɛ, ‑o ‑yaa pɛbhle 'zi bhla 'la ba, 'ke Zesu 'e 'wlɛnle‑, 'kee‑ ‑yaa dunɛ‑ tralapɛ 'ɛ gole‑, 'bhɛɛ‑ 'kee‑ sɔ do ‑yrele' ‑a 'saanla꞊. ");
INSERT INTO moa_vpl VALUES ("JN13_5","073_13_5","JHN","13","5","5","'Bhɛ blaan, 'kee‑ ‑yi 'klale 'tasa do 'yi, 'bhɛɛ‑ 'kee‑ ‑yaa' ‑klaŋlanɛ mu 'ɛ gaan mafɛle 'sanle, 'bhɛɛ‑ 'kee‑ 'mu mago ‑sɔ ‑e sɔ 'la ‑dwa ‑a 'saanla꞊ 'bhɛ 'le. ");
INSERT INTO moa_vpl VALUES ("JN13_6","073_13_6","JHN","13","6","6","‑E bhɔle Simɔ Piɛri ta, 'ke 'bhɛ 'a 'pele ‑a ni dɔɔ: «Mɛɛzan, 'bhi ‑le zan 'mi gaan mafɛlɛ bhe ɛɛ?» ");
INSERT INTO moa_vpl VALUES ("JN13_7","073_13_7","JHN","13","7","7","Zesu 'bhɛ zikpaa ‑a ni dɔɔ: «'Ŋ 'yoo‑ ‑za 'la klɛ 'zi ‑gɛ, 'yaa sɔ ‑a ‑yimale, 'duŋ‑ 'e nu ‑a ‑yimalɛ boolazi.» ");
INSERT INTO moa_vpl VALUES ("JN13_8","073_13_8","JHN","13","8","8","Piɛri pe ‑a ni 'ezin‑ dɔɔ: «'Yaa nu 'mi gaan 'mafɛlɛ ‑titi!» 'Bhɛ klɛle 'tɛ, 'ke Zesu 'a zikpale ‑a ni dɔɔ: «'Ke 'naa 'e gaan mafɛlɛ, 'mi 'pegee 'bhi a ‑za 'kedo‑ 'kpɔ 'laa nu klɛlɛ ‑li 'eke‑ ta.» ");
INSERT INTO moa_vpl VALUES ("JN13_9","073_13_9","JHN","13","9","9","'Bhɛ klɛle 'tɛ, 'ke Simɔ Piɛri 'a 'pele ‑a ni dɔɔ: «'Yaa 'ŋ gaan do ‑kplɛn mafɛlɛ, 'duŋ‑ 'ŋ ŋgblo 'pegee 'ŋ gbɛ mu 'ɛ mafɛ' 'ezin‑!» ");
INSERT INTO moa_vpl VALUES ("JN13_10","073_13_10","JHN","13","10","10","'Bhɛ 'yi 'tɛ, 'ke Zesu 'a 'pele 'a ni dɔɔ: «'Ke ‑o mɛɛ 'la zan ꞊fia ‑yi ba, 'bhɛ maza laa ‑o ‑li 'bhɛ 'gbu 'fɛle‑ ma 'ezin‑, 'ke yaa 'e go ‑a gaan mu 'ɛ 'mu ‑la mafɛle ba. ‑Amasrɔyi ‑a 'gbutru 'ɛ 'kpɛn 'fleele‑ ‑o. 'Bhɛɛ‑ 'duŋ‑, 'ka ꞊kla gban 'weŋ, 'duŋ‑ 'naa ‑o ‑we 'zi 'ka 'kpɛn 'le.» ");
INSERT INTO moa_vpl VALUES ("JN13_11","073_13_11","JHN","13","11","11","‑Amasrɔyi Zesu 'yaa‑ mɛɛ 'la zan ‑yaa nu ‑dawli' 'kpalɛ‑ ‑a gbɛ ta, 'bhɛɛ‑ 'bhɛ 'a 'lɛna‑ mɛɛ mu ni 'bhɛ zan 'ɛ dɔ; 'bhɛla‑ ‑yile ‑ya ‑pia dɔɔ: «'Ka 'kpɛn 'laa ‑o 'weŋ.» ");
INSERT INTO moa_vpl VALUES ("JN13_12","073_13_12","JHN","13","12","12","Zesu 'yanle‑ ‑o gaan mafɛlele, 'kee‑ ‑yaa dunɛ‑ tralapɛ 'ɛ 'klale ‑a ta, 'kee‑ yaa gbɛ drɛɛwole pɛbhle ‑tabali 'ɛ zi, 'bhɛɛ‑ 'ke ‑ya pele‑ ‑o ni dɔɔ: «'Ŋ ‑za 'la ꞊kla 'ka ni bhe, 'kaa 'yimaa‑ ɛɛ? ");
INSERT INTO moa_vpl VALUES ("JN13_13","073_13_13","JHN","13","13","13","'Ka 'mi sii dɔɔ: ‹'O Daan mi,› 'bhɛ 'pegee‹Mɛɛzan.› 'Zoo ‑o 'ka zi, ‑amasrɔyi 'mi 'gbu ‑le 'ka Daan mi 'pegee Mɛɛzan 'ɛ 'le. ");
INSERT INTO moa_vpl VALUES ("JN13_14","073_13_14","JHN","13","14","14","'Ke 'mi 'la 'mi ‑o 'ke Mɛɛzan 'pegee 'ka Daan mi 'le, 'mi 'ka gaan mafia‑, 'ka mu 'ezin‑, ‑ka 'eke‑ gaan mafɛ' do do. ");
INSERT INTO moa_vpl VALUES ("JN13_15","073_13_15","JHN","13","15","15","'Mi ‑za 'la ꞊kla, 'bhɛɛ‑ 'an klɛ gbɛya 'ɛ ‑zrɔnna 'ka ni, 'kooko‑ 'ka mu 'bhɛ 'yansi za klɛ, ‑ka 'bhɛɛ‑ klɛ 'eke‑ ni. ");
INSERT INTO moa_vpl VALUES ("JN13_16","073_13_16","JHN","13","16","16","'Mi pe 'ka ni 'ŋ 'sɔwɛɛ‑ ma dɔɔ yewonɛ do gblaan ‑yi 'laa ya ‑a ‑kuŋlii 'ɛ ni, 'bhɛɛ‑ winbɔwo mi 'ɛ 'bhɛ 'yi 'laa ya 'bhɛ 'winbɔ‑ mi 'ɛ ni. ");
INSERT INTO moa_vpl VALUES ("JN13_17","073_13_17","JHN","13","17","17","'Ke 'ka 'bhɛ ‑za mu 'ɛ ‑dwa, 'kaa pɛ ‑yi nu ‑nralɛ' 'ke 'ka ꞊swa ‑o ‑yizaklɛle. ");
INSERT INTO moa_vpl VALUES ("JN13_18","073_13_18","JHN","13","18","18","'Naa ‑o ‑we 'zi 'ka 'kpɛn 'le. 'Mi mɛɛ 'la zan mu makwan‑, 'ŋ 'mu dɔ. 'Duŋ‑ ‑za 'la yɔɔndɛle ‑o ‑Waanbhaa' a 'Sɛwɛ 'ɛ 'yi, ‑yoo 'ke ‑za ‑le 'ke 'bhɛ 'lɛsɔ‑. ‑A yɔɔndɛlɛ ‑o dɔɔ: ‹'O 'pegee mɛɛ 'la zan ‑o pɛle 'zi 'eke‑ ta, 'bhɛ zan 'ɛ 'wlɛnna‑ 'mi 'kaama‑.› ");
INSERT INTO moa_vpl VALUES ("JN13_19","073_13_19","JHN","13","19","19","Mi ‑o 'ka 'kpeelɛkan zii' ‑zɔn 'sani‑ 'yee‑ ‑za 'ɛ klɛ bhla 'ɛ pleŋ‑. 'Kooko‑ 'kee‑ ꞊bhwa 'waati 'la ba, 'kaa 'yaango‑ 'bhii‑ ‹'Ŋ 'yoo‑ 'ke kpataakpa mɛɛ 'la zan 'ŋ 'yoo 'ke 'bhɛ 'le.› ");
INSERT INTO moa_vpl VALUES ("JN13_20","073_13_20","JHN","13","20","20","'Mi pe 'ka ni 'ŋ 'sɔwɛɛ‑ ma dɔɔ: Mɛɛ 'la zan 'ŋ 'winbwa‑, 'ke 'bhi 'la 'bhɛ zan 'ɛ ‑kwan 'elrele, 'e 'mi ‑la 'kun zii' 'elrele bhe. 'Bhɛɛ‑ 'ke mɛɛ 'la zan 'mi ‑kwan 'elrele, 'bhɛ zan 'ɛ 'bhɛ ‑o 'ŋ 'winbɔ‑ mi 'ɛ 'bhɛɛ‑ 'kun zii' 'elrele 'ezin‑ bhe.» ");
INSERT INTO moa_vpl VALUES ("JN13_21","073_13_21","JHN","13","21","21","Zesu 'yanle‑ 'bhɛ ‑jan 'ɛ 'wolele 'ke ‑a zrubatɛdɔle‑, 'bhɛɛ‑ 'ke ‑ya pele‑ kpataakpa dɔɔ: «'Mi pe 'ka ni 'ŋ 'sɔwɛɛ‑ ma dɔɔ 'ka do nu ‑dawli' 'kpalɛ‑ 'ŋ gbɛ ta.» ");
INSERT INTO moa_vpl VALUES ("JN13_22","073_13_22","JHN","13","22","22","'Bhɛ klɛle 'tɛ, 'ke ‑yaa' ‑klaŋlanɛ mu 'ɛ ‑woo ‑yrɛkpale 'eke‑ ta, 'bhɛɛ‑ ‑e ‑yaa ‑we 'zi mɛɛ 'la zan 'le, waa ‑yaa 'bhɛ zan 'ɛ dɔ. ");
INSERT INTO moa_vpl VALUES ("JN13_23","073_13_23","JHN","13","23","23","'Yee‑ Zesu a ‑klaŋlanɛ 'la 'bhɛ ‑za ‑yaa sɔ ‑a ni 'egbɛnɛle, 'bhɛ 'yaale‑ ‑yaa ‑a ‑din 'bhɛ bhla 'ɛ ba. ");
INSERT INTO moa_vpl VALUES ("JN13_24","073_13_24","JHN","13","24","24","‑Ayile, 'ke Simɔ Piɛri 'e 'yrɛ ‑kwlanbɔle 'bhɛ ni dɔɔ 'bhɛ 'yee‑ Zesu 'lrɔkpa, 'bhɛɛ‑ ‑e 'bhɛ zan 'ɛ zrɔn ‑a ni. ");
INSERT INTO moa_vpl VALUES ("JN13_25","073_13_25","JHN","13","25","25","'Bhɛ klɛle 'tɛ, 'ke 'bhɛ ‑klaŋlanɛ 'ɛ ‑ya makulale Zesu ba ‑yrɛ ta, 'bhɛɛ‑ 'kee‑ Zesu ‑lrɔkpale dɔɔ: «Mɛɛzan, ‑dele 'bhɛ zan 'ɛ 'le ɛɛ?» ");
INSERT INTO moa_vpl VALUES ("JN13_26","073_13_26","JHN","13","26","26","'Bhɛ 'yi 'ke Zesu 'a 'pele ‑a ni dɔɔ: «'Ŋ nu 'bluu kpu 'lɛɛ‑ ‑zwanlɛ' ‑ziɛn 'ɛ ba, 'ke 'an ꞊naa mɛɛ 'la zan ni, 'bhɛ zan ‑le nu ‑dawli' 'kpalɛ‑ 'ŋ gbɛ ta.» 'Bhɛ klɛle 'tɛ, 'ke Zesu 'bluu kpu do 'sile, 'ke ‑ya ‑zwanle' ‑ziɛn 'ɛ ba, 'bhɛɛ‑ 'ke ‑ya nale‑ Simɔ Isikariɔti gbe Zuda ni. ");
INSERT INTO moa_vpl VALUES ("JN13_27","073_13_27","JHN","13","27","27","Zuda 'bluu kpu 'ɛ 'kunle‑, 'ke ‑Setran' 'wlale ‑a zru 'ɛ 'yi; 'bhɛɛ‑ 'ke Zesu 'a 'pele a ni dɔɔ: «'Yoo‑ zan ‑za 'la klɛlɛ, ‑a klɛ ‑gun blaale‑!» ");
INSERT INTO moa_vpl VALUES ("JN13_28","073_13_28","JHN","13","28","28","Mɛɛ 'la zan mu 'pegee Zesu 'yaa‑ pɛbhle 'zi 'eke‑ zi, ‑e 'bhɛ ‑jan 'ɛ ꞊woa ‑a ni win 'la ma 'mu do 'kpɔ 'laa 'bhɛ dɔlɛ. ");
INSERT INTO moa_vpl VALUES ("JN13_29","073_13_29","JHN","13","29","29","Zuda ‑yaa waa ‑gɔli' magaan mi 'la 'le bhe, ‑o 'ke mu 'kpee ma Zesu 'a ꞊pia ‑a ni dɔɔ, 'ke yaa gelɛ waa pɛ 'fɛti ta pɛ 'ɛ 'mu 'lɔyrɛ‑ nɔɔ‑, ‑e ge ‑gɔli' 'na 'kɔɔfleŋzan mu ni. ");
INSERT INTO moa_vpl VALUES ("JN13_30","073_13_30","JHN","13","30","30","Zuda 'yanle‑ 'bluu kpu 'ɛ 'bhlelele, 'kee‑ 'pwɛle blaale‑. 'Bhɛ ꞊kla bi 'ɛ zi. ");
INSERT INTO moa_vpl VALUES ("JN13_31","073_13_31","JHN","13","31","31","Zuda 'pwɛle‑ blaan, 'ke Zesu 'a 'pele ‑yaa' ‑klaŋlanɛ mu 'ɛ ni dɔɔ: «Bhaaplɛŋ Gbe 'ɛ 'tɔbhɔleya 'ɛ tapwɛ' bhla ꞊bhwa 'tɛ, 'bhɛɛ‑ ‑e nu ‑Waanbhaa' 'tɔbhɔleya 'ɛ tapwɛlɛ mɛɛ mu ni. ");
INSERT INTO moa_vpl VALUES ("JN13_32","073_13_32","JHN","13","32","32","'Bhɛɛ‑ 'ke 'yee‑ 'a ꞊kla 'bhɛɛ‑ mɛɛ mu ‑Waanbhaa' 'tɔbhɔ‑ 'yee‑ 'gbu 'yi, ‑Waanbhaa' nu ‑a klɛlɛ 'bhɛɛ‑ mɛɛ mu 'a Gbe 'ɛ 'tɔbhɔleya 'ɛ ye 'yee‑ ‑Waanbhaa' 'gbu 'yi 'ezin‑, ‑a ‑vinbwa 'waati sa 'bhɛɛ‑ ‑e 'bhɛ klɛ. ");
INSERT INTO moa_vpl VALUES ("JN13_33","073_13_33","JHN","13","33","33","'Ŋ 'bhɛgwlɛn‑ mu, 'naa nu ‑mɔlɛ' 'ka ‑din ‑li. 'Ka nu 'ŋ ziglinlɛ, 'duŋ‑ 'ŋ ‑jan yɛkɛ‑ 'la ꞊woa Zuufu ‑kuŋlii mu 'ɛ ni, 'ŋ 'bhɛɛ‑ 'wole 'ka mu ni 'ezin‑ dɔɔ: 'ŋ nu gelɛ yrɛ 'la ꞊nɔɔ, 'ka 'laa nu 'sɔlɛ‑ gele‑ 'bhɛ ꞊nɔɔ. ");
INSERT INTO moa_vpl VALUES ("JN13_34","073_13_34","JHN","13","34","34","'Bhɛla‑ ‑yile, 'mi ‑o zan 'toŋ drɛɛ do dɔlɛ 'ka ni, 'bhɛ ‑le dɔɔ: 'ka ‑za 'sɔ 'eke‑ ni. 'Ka ‑za ‑swa 'mi ni gɔnɛ‑ 'la gbɛɛn‑, 'ka mu ‑za 'sɔ 'eke‑ 'bhɛɛ‑ gbɛɛn‑ 'ezin‑. ");
INSERT INTO moa_vpl VALUES ("JN13_35","073_13_35","JHN","13","35","35","'Ke 'ka ‑za ‑swa 'eke‑ ni mɔkpɛn' nu 'a 'yaangolɛ 'tɛ 'bhii‑ 'ka ‑o 'ke 'mi a ‑klaŋlanɛ mu 'le.» ");
INSERT INTO moa_vpl VALUES ("JN13_36","073_13_36","JHN","13","36","36","'Bhɛ klɛle 'tɛ, 'ke Simɔ Piɛri Zesu 'lrɔkpale dɔɔ: «Mɛɛzan, 'e ge 'zi 'naa ma ɛɛ?» Zesu 'a 'lɛkwan‑ ‑a ni dɔɔ: «'Ŋ gele‑ yrɛ 'la ꞊nɔɔ‑ ‑zɔn 'yaa sɔ gele‑ 'ŋ zi 'bhɛ ꞊nɔɔ, 'duŋ‑ 'e nu gelɛ 'ŋ zi boolazi.» ");
INSERT INTO moa_vpl VALUES ("JN13_37","073_13_37","JHN","13","37","37","'Bhɛ 'yi 'tɛ, 'ke Piɛri 'a 'pele Zesu ni dɔɔ: «Mɛɛzan, ‑mɛla ma 'naa sɔ gele‑ 'e zi ‑zɔn ɛɛ? 'Ŋ 'yrisriwole ‑o 'ke 'mi 'ŋ 'niigo‑ 'ŋ ꞊si 'ɛ yi 'yaa‑ ‑za ma.» ");
INSERT INTO moa_vpl VALUES ("JN13_38","073_13_38","JHN","13","38","38","'Bhɛ klɛle 'tɛ, 'ke Zesu 'a 'lrɔkpale dɔɔ: «'E 'yrisriwole ‑o dɔɔ 'yee 'niigwa‑ 'e 'gbu ꞊si 'ɛ 'yi 'mi a ‑za ma ɛɛ? 'Mi pe 'e ni 'ŋ 'sɔwɛɛ‑ ma dɔɔ: 'sani‑ maagwlɛn ‑weli' pleŋ‑ ‑zɔn, 'e nu 'e 'lɛmadɔlɛ 'mi ma 'eglɔɔle ‑glɔɔn yaga 'kaa 'yaa 'mi dɔ.» ");
INSERT INTO moa_vpl VALUES ("JN14_1","073_14_1","JHN","14","1","1","'Bhɛ blaan, 'ke Zesu 'a 'pele ‑yaa' ‑klaŋlanɛ mu 'ɛ ni 'ezin‑ dɔɔ: «'Ka 'laa 'ka zrubatɛdɔlɛ. ‑Ka 'ka 'kpa ‑Waanbhaa' 'yi, 'bhɛɛ‑ ‑ka 'ka 'kpa 'mi 'yi 'ezin‑. ");
INSERT INTO moa_vpl VALUES ("JN14_2","073_14_2","JHN","14","2","2","Yaayrɛ ‑bebe ‑o 'ŋ Dɛ ‑Waanbhaa' ba 'fɛ 'ɛ ꞊la. 'Ke 'bhɛ 'laa ‑o bi 'ke wlan 'le, 'naa ‑yaa nu ‑a pelɛ 'ka ni dɔɔ 'mi ge 'zi 'ka 'yaayrɛ‑ magaanlɛ 'ka 'lɛɛ ‑sɔ. ");
INSERT INTO moa_vpl VALUES ("JN14_3","073_14_3","JHN","14","3","3","'Ke 'ŋ 'yaan‑ 'ka 'yaayrɛ‑ 'ɛ magaanlele bhla 'la ba, 'ŋ nu nulɛ 'ka 'kunlɛ‑, 'kooko‑ 'ŋ 'yoo‑ yrɛ 'la ꞊nɔɔ 'ka klɛ 'bhɛ ꞊nɔɔ 'ezin‑. ");
INSERT INTO moa_vpl VALUES ("JN14_4","073_14_4","JHN","14","4","4","'Mi ‑o ge 'zi yrɛ 'la ꞊nɔɔ, 'ka 'bhɛ ꞊nɔɔ zi 'ɛ dɔ.» ");
INSERT INTO moa_vpl VALUES ("JN14_5","073_14_5","JHN","14","5","5","'Bhɛ klɛle 'tɛ, 'ke Toma 'a 'pele Zesu ni dɔɔ: «Mɛɛzan, 'e gele‑ yrɛ 'la ꞊nɔɔ 'waa 'bhɛ dɔ. 'O sɔ 'bhɛ ꞊nɔɔ zi 'ɛ dɔle‑ 'nale‑ ‑a ma ɛɛ?» ");
INSERT INTO moa_vpl VALUES ("JN14_6","073_14_6","JHN","14","6","6","'Bhɛ 'yi 'tɛ, 'ke Zesu 'a zikpale ‑a ni dɔɔ: «'Mi ‑le 'ke Zi 'ɛ 'le, 'bhɛɛ‑ 'mi ‑le 'ke wlan 'le, 'bhɛ 'pegee 'mi ‑le bole ‑yrɛ ma ‑si 'ɛ 'na mɛɛ ni. Mɛɛ 'kedo‑ 'kpɔ 'laa sɔ gele‑ 'ŋ Dɛ ‑Waanbhaa ba 'ke 'bhɛ zan laa 'kanlɛ‑ 'mi ba. ");
INSERT INTO moa_vpl VALUES ("JN14_7","073_14_7","JHN","14","7","7","'Ke 'ka 'mi dɔ bi, 'ka 'yaa‑ nu 'ŋ Dɛ ‑Waanbhaa' dɔlɛ 'ezin‑. 'Bhɛɛ‑ drɔɔn' 'kaa ‑dwa ‑zɔn, 'bhɛɛ‑ 'kaa ꞊ya.» ");
INSERT INTO moa_vpl VALUES ("JN14_8","073_14_8","JHN","14","8","8","Filipu pe Zesu ni 'tɛ dɔɔ: «Mɛɛzan, 'e Dɛ ‑Waanbhaa' zrɔn 'o ni, 'bhɛɛ‑ 'bhɛ 'waa‑ pɛ 'ɛ 'yibhɔ‑.» ");
INSERT INTO moa_vpl VALUES ("JN14_9","073_14_9","JHN","14","9","9","Zesu 'bhɛ zikpaa‑ ‑a ni 'bhɛ 'yi 'tɛ dɔɔ: «‑A nɔɔ‑ ꞊mwa gban 'ke ‑kɔɔ' ‑o 'eke‑ zi, 'bhɛɛ‑ 'bhi Filipu 'laa 'ŋ dɔlɛ ‑lii ɛɛ? 'Ke mɛɛ 'la zan 'ŋ ꞊ya 'bhɛ zan 'ŋ Dɛ ‑Waanbhaa' ‑la ꞊ya. ‑Mɛle ‑kla 'yoo‑ ‑a 'pe 'zi dɔɔ: ‹'E Dɛ ‑Waanbhaa zrɔn 'o ni ɛɛ?› ");
INSERT INTO moa_vpl VALUES ("JN14_10","073_14_10","JHN","14","10","10","'E 'kpale‑ laa ‑o ‑a ‑yi 'bhii‑ 'mi ‑o 'ŋ Dɛ ‑Waanbhaa' 'yi, 'bhɛɛ‑ 'ŋ Dɛ ‑Waanbhaa' ‑o 'mi 'yi ɛɛ? 'Ŋ 'yoo‑ ‑jan mu 'la 'wo zii' 'ka ni, 'mu 'laa ‑o da 'zi 'mi 'gbu 'kpee. 'Ŋ Dɛ ‑Waanbhaa' 'la ‑yoo 'ŋ 'yi, 'bhɛ ‑le 'bhɛ 'gbu a ye mu wo 'zi 'mi 'yi. ");
INSERT INTO moa_vpl VALUES ("JN14_11","073_14_11","JHN","14","11","11","‑Ka 'ka 'kpa 'mi 'yi 'ke 'an 'pia‑ 'ka ni dɔɔ: 'ŋ 'yoo‑ 'ŋ Dɛ ‑Waanbhaa' 'yi, 'bhɛɛ‑ 'yee‑ 'ŋ Dɛ ‑Waanbhaa' ‑o 'mi 'yi. 'Bhɛɛ‑ 'duŋ‑, 'ke 'ka 'laa 'ka 'kpalɛ‑ 'ŋ ‑jan 'la ꞊woa 'mu 'yi, ‑ka 'ka 'kpa 'ŋ ‑za mu 'la klɛ 'zi 'mu 'yi. ");
INSERT INTO moa_vpl VALUES ("JN14_12","073_14_12","JHN","14","12","12","'Mi pe 'ka ni 'ŋ 'sɔwɛɛ‑ ma dɔɔ: 'ke mɛɛ 'la zan 'e ꞊kpaa 'ŋ 'yi, 'ŋ 'yoo‑ ye mu 'la 'wo zii', 'bhɛ zan nu 'bhɛ 'yansi ye mu 'wolɛ‑. 'Bhɛɛ‑ 'duŋ‑, 'bhɛ zan nu ye mu 'ke mu wolɛ 'ke 'mu gblaan ‑yiya' 'mi a pɛ mu 'ɛ ni, ‑amasrɔyi 'ŋ 'yoo‑ ge 'zi 'ŋ Dɛ ‑Waanbhaa' ba. ");
INSERT INTO moa_vpl VALUES ("JN14_13","073_14_13","JHN","14","13","13","'Bhɛɛ‑ 'ke 'ka pɛ 'la 'yrɛwoa‑ ‑Waanbhaa' ma 'ŋ 'tɔ 'yi 'kaa 'ŋ 'bhɛ klɛ, 'ŋ nu 'bhɛɛ‑ klɛlɛ, 'kooko‑ ‑Nɛ 'ɛ ‑ya Dɛ ‑Waanbhaa' 'tɔbhɔleya 'ɛ zrɔn mɛɛ mu ni kpataakpa. ");
INSERT INTO moa_vpl VALUES ("JN14_14","073_14_14","JHN","14","14","14","'Ke 'ka pɛ 'kɛ 'la ‑yrɛwoa 'ŋ ma 'ŋ 'tɔ 'yi 'kaa 'ŋ 'bhɛ klɛ, 'ŋ nu 'bhɛɛ‑ klɛlɛ.» ");
INSERT INTO moa_vpl VALUES ("JN14_15","073_14_15","JHN","14","15","15","«'Ke 'ŋ ‑za sɔ 'ka ni, 'ka nu 'ŋ 'wojan‑ mu 'ɛ 'klɔsikunlɛ. ");
INSERT INTO moa_vpl VALUES ("JN14_16","073_14_16","JHN","14","16","16","'Mi nu ‑a ‑yrɛwolɛ 'ŋ Dɛ ‑Waanbhaa' ma dɔɔ ‑e bhɔŋba mi ‑bhɛɛke' do na 'ka ni, 'kooko‑ 'bhɛ bo 'ka ‑din 'taŋii. ");
INSERT INTO moa_vpl VALUES ("JN14_17","073_14_17","JHN","14","17","17","'Bhɛ 'bhɔŋba‑ mi 'ɛ 'bhɛ ‑le wlan ma *Lii 'Weŋ 'ɛ 'le. 'Drunyan 'yi mu 'ɛ waa sɔ ‑a ‑srɔɔwole, ‑amasrɔyi waa sɔ ‑a yele‑, 'bhɛ 'pegee waa sɔ a dɔle‑. 'Bhɛɛ‑ 'duŋ‑, 'ka mu 'a dɔ, ‑amasrɔyi ‑yoo 'ka mu ‑din, 'bhɛɛ‑ ‑yoo zan bolɛ 'ka 'yi. ");
INSERT INTO moa_vpl VALUES ("JN14_18","073_14_18","JHN","14","18","18","'Naa nu 'ka 'tolɛ‑ 'ka do ‑kplɛn 'le 'bhii‑ twenɛ‑ mu; 'ŋ nu nu gbɛ drɛɛwolɛ 'ka ba. ");
INSERT INTO moa_vpl VALUES ("JN14_19","073_14_19","JHN","14","19","19","‑A ‑vinbwa 'waati sa, 'bhɛɛ‑ 'drunyan ta mɛɛ mu 'ɛ waa nu 'ŋ 'yelɛ‑ ‑li 'ezin‑. 'Duŋ‑ 'ka mu nu 'ŋ 'yelɛ‑, ‑amasrɔyi 'ŋ 'yoo‑ 'ŋ 'yrɛ ma, 'bhɛɛ‑ 'ka mu nu bolɛ 'ka 'yrɛ ma 'ezin‑. ");
INSERT INTO moa_vpl VALUES ("JN14_20","073_14_20","JHN","14","20","20","'Ke 'bhɛ yi 'ɛ ꞊bhwa, 'ka nu ‑a 'yaangolɛ 'bhɛ 'yi, 'bhii‑ 'mi 'pegee 'ŋ Dɛ ‑Waanbhaa' 'woo do, 'bhɛɛ‑ 'ka mu 'pegee 'mi ‑o do, 'bhɛɛ‑ 'mi 'pegee 'ka mu ‑o do.» ");
INSERT INTO moa_vpl VALUES ("JN14_21","073_14_21","JHN","14","21","21","«'Ke mɛɛ 'la zan 'ŋ 'wojan‑ mu 'ɛ 'lɛdɔ‑ ‑a ma, 'bhɛɛ‑ ‑yoo 'klɔsikun, 'ŋ ‑za sɔ 'bhɛɛ‑ zan ni. 'Bhɛɛ‑ 'ke 'ŋ ‑za sɔ mɛɛ 'la zan ni, 'bhɛ zan ‑za nu 'sɔlɛ‑ 'ŋ Dɛ ‑Waanbhaa' ni. 'Bhɛ zan ‑za nu 'sɔlɛ‑ 'ŋ ni, 'bhɛɛ‑ 'mi 'gbu nu 'ŋ 'gbu zrɔnlɛ 'bhɛ zan 'ɛ ni.» ");
INSERT INTO moa_vpl VALUES ("JN14_22","073_14_22","JHN","14","22","22","'Bhɛ ya 'ɛ 'yi, ‑o ‑yaa Zesu a ‑klaŋlanɛ 'la sii Zudi, waa pelɛ Zuda Isikariɔti, 'ke 'bhɛ Zesu 'lrɔkpale dɔɔ: «Mɛɛzan, ‑mɛle ‑kla 'bhɛɛ‑ 'e nu 'e 'gbu zrɔnlɛ 'o mɔɔ ni, 'bhɛɛ‑ 'yaa nu ‑e 'gbu zrɔnlɛ 'drunyan ta mu 'ɛ ni ɛɛ?» ");
INSERT INTO moa_vpl VALUES ("JN14_23","073_14_23","JHN","14","23","23","Zesu 'bhɛ 'lɛkwan‑ ‑a ni dɔɔ: «'Ke 'ŋ ‑za sɔ mɛɛ 'la zan ni, 'bhɛ zan 'ŋ 'wojan‑ mu 'ɛ 'klɔsikun. 'Bhɛɛ‑ ‑a ‑za nu 'sɔlɛ‑ 'ŋ Dɛ ‑Waanbhaa' ni. 'Bhɛla‑ ‑yile 'mi 'pegee 'ŋ Dɛ ‑Waanbhaa' 'o nu nulɛ 'bhɛ zan 'ɛ ba, 'bhɛɛ‑ ‑o nu bolɛ ‑a ‑yi. ");
INSERT INTO moa_vpl VALUES ("JN14_24","073_14_24","JHN","14","24","24","'Duŋ‑ 'ke 'ŋ ‑za 'laa sɔ mɛɛ 'la zan ni, 'bhɛ zan laa 'ŋ 'wojan‑ mu 'ɛ 'klɔsikun. 'Ka ‑o ‑jan mu 'la 'ma zii' 'ŋ 'lii ‑gɛ bhe, 'mu 'laa ‑o da 'zi 'mi 'gbu ba; 'duŋ‑ 'ŋ Dɛ ‑Waanbhaa' 'la 'mi 'winbwa‑ 'bhɛ ‑le ‑o 'kpa zii' 'ŋ 'lii. ");
INSERT INTO moa_vpl VALUES ("JN14_25","073_14_25","JHN","14","25","25","'Ŋ 'bhɛ ‑jan mu 'ɛ ꞊woa 'ka ni 'bhɛ 'waati 'ɛ ba 'ke 'ŋ 'yoo‑ 'ka ‑din. ");
INSERT INTO moa_vpl VALUES ("JN14_26","073_14_26","JHN","14","26","26","'Duŋ‑ 'ka 'bhɔŋba‑ mi 'ɛ, Lii 'Weŋ 'la 'ŋ Dɛ nu 'bhɛ 'kpalɛ‑ 'ka ni 'ŋ 'tɔ 'yi, 'bhɛ nu 'ka daanlɛ ‑za mu 'ɛ 'kpɛn 'le, 'bhɛɛ‑ 'ŋ ‑jan mu 'la 'kpɛn ꞊woa 'ka ni, 'bhɛ nu 'mu 'kpɛn dɔlɛ 'ka 'kpee.» ");
INSERT INTO moa_vpl VALUES ("JN14_27","073_14_27","JHN","14","27","27","«'Mi ‑o yilabla 'ɛ 'to zii' 'ka ni, 'mi ‑o 'an yilabla 'ɛ 'bhɛɛ‑ 'na zii' 'ka ni. 'Duŋ‑ 'mi 'laa ‑o ‑a na 'zi 'ka ni 'bhii‑ 'drunyan 'yi mu 'a na gɔnɛ‑ 'la gbɛɛn‑. 'Ka 'laa 'ka zrubatɛdɔlɛ, 'bhɛɛ‑ 'ka 'laa ‑gblaanlɛ'. ");
INSERT INTO moa_vpl VALUES ("JN14_28","073_14_28","JHN","14","28","28","'Kaa ꞊maa 'ŋ ta dɔɔ: ‹'Ŋ 'yoo‑ ge 'zi, 'bhɛɛ‑ 'duŋ‑ 'ŋ nu nu gbɛ drɛɛwolɛ 'ka ba.› 'Ke 'ŋ ‑za sɔ bi 'ka ni, 'ŋ gelawo zii' 'ŋ Dɛ ‑Waanbhaa' 'la gblaan ‑yiya' 'mi ni 'bhɛ ba bhe, 'bhɛ ‑za 'ɛ 'yaa‑ nu 'ka zrukpaalɛ. ");
INSERT INTO moa_vpl VALUES ("JN14_29","073_14_29","JHN","14","29","29","'Mi ‑za mu 'la ꞊pia 'ka ni ‑gɛ bhe, 'ke waa bhɔlɛ ‑li; 'ke 'ka ‑o bhɔle ꞊ya 'waati 'la ba, 'ka nu 'ka 'kpalɛ‑ 'mi 'yi. ");
INSERT INTO moa_vpl VALUES ("JN14_30","073_14_30","JHN","14","30","30","'Mi 'pegee 'ka mu laa nu ‑welɛ' ‑li 'ebebele. ‑Amasrɔyi 'drunyan 'lɛɛ‑ ‑a ta ‑kuŋlii 'ɛ ꞊bhwa gban ‑wa ‑din. ‑Yaa' 'seŋ do 'kpɔ 'laa ‑o ‑li 'mi ta. ");
INSERT INTO moa_vpl VALUES ("JN14_31","073_14_31","JHN","14","31","31","'Duŋ‑, 'kooko‑ 'drunyan 'yi mu 'ɛ ‑wa 'yaango‑ 'bhii‑ 'ŋ Dɛ ‑Waanbhaa' ‑za sɔ 'ŋ ni, 'bhɛɛ‑ ‑ya ꞊pia 'ŋ 'kɛla klɛ, 'ŋ 'bhɛɛ‑ klɛ. ‑Ka 'ka 'wlɛn‑ 'bhɛɛ‑ ‑kɔɔ' ge!» ");
INSERT INTO moa_vpl VALUES ("JN15_1","073_15_1","JHN","15","1","1","Zesu pe 'ezin‑ dɔɔ: «'Mi ‑le 'ke ‑drɔɔ diiŋ ‑zeze 'gbu 'ɛ 'le, 'bhɛɛ‑ 'ŋ Dɛ ‑Waanbhaa' ‑le 'ke ‑a gbakpa' mi 'ɛ 'le. ");
INSERT INTO moa_vpl VALUES ("JN15_2","073_15_2","JHN","15","2","2","‑Drɔɔ diiŋ 'ɛ gbɛ 'oo gbɛ 'la yaa ‑a bhaa klɛ, ‑e 'bhɛ takan, 'bhɛɛ‑ ‑a gbɛ 'oo gbɛ 'la 'bhɛ 'bhɛ bhaa klɛ, ‑e 'bhɛ yin 'ɛ kan, 'kooko‑ ‑ya bhaa 'ɛ baan' klɛ 'ebebele 'ezin‑. ");
INSERT INTO moa_vpl VALUES ("JN15_3","073_15_3","JHN","15","3","3","'Bhɛ klɛgbɛya do 'ɛ 'yi, 'ŋ 'ka ‑daanna ‑jan 'la 'le bhe, 'bhɛ 'kaa‑ 'drunyan ta zru maza mu 'ɛ ‑gwa 'ka ma, 'bhɛɛ‑ 'bhɛ 'ka ꞊kla 'weŋ gban. ");
INSERT INTO moa_vpl VALUES ("JN15_4","073_15_4","JHN","15","4","4","'Ka blɔɔle bo 'mi ma 'bhii‑ 'mi blɔɔle bole ‑o 'ka mu ma gɔnɛ‑ 'la gbɛɛn‑. ‑Yri gbɛ do laa sɔ ‑a bhaa klɛle‑ 'ke ‑a blɔɔle laa bolɛ ‑yri diiŋ 'ɛ ma. 'Bhɛ klɛgbɛya do 'ɛ 'yi, 'ke 'ka blɔɔle 'laa bolɛ 'mi ma, 'ka 'laa nu 'sɔlɛ‑ ‑za 'kedo‑ 'kpɔ klɛle‑ ‑Waanbhaa ni. ");
INSERT INTO moa_vpl VALUES ("JN15_5","073_15_5","JHN","15","5","5","'Mi ‑o 'bhii‑ ‑drɔɔ diiŋ 'ɛ gbɛɛn‑, 'bhɛɛ‑ 'ka mu ‑o 'bhii‑ ‑a gbɛ mu 'ɛ gbɛɛn‑. 'Ke mɛɛ 'la zan blɔɔle ꞊bwa 'mi ma, 'bhɛɛ‑ 'ke 'mi blɔɔle ꞊bwa 'bhɛ zan 'ɛ ma, 'bhɛ zan sɔ ‑za 'lrele‑ ‑bebe klɛle‑. ‑Amasrɔyi 'ka 'laa sɔ ‑za 'kedo‑ 'kpɔ klɛle‑ 'mi blaan. ");
INSERT INTO moa_vpl VALUES ("JN15_6","073_15_6","JHN","15","6","6","'Ke mɛɛ 'la zan blɔɔle laa bolɛ 'mi ma, ‑o 'bhɛ zan blin 'pɛɛlii‑ 'bhii‑ ‑yri gbɛ do, 'bhɛɛ‑ ‑e ga. ‑E klɛ 'bhii‑ ‑yri gbɛ mu 'la 'ke ‑woo takaan‑, 'bhɛɛ‑ ‑woo ‑gwa ‑yri diiŋ 'ɛ ma, ‑o ‑gaa; ‑woo ‑wloo', 'bhɛɛ‑ ‑woo blin 'tɛ 'yi, 'bhɛɛ‑ 'tɛ ‑o bhle. ");
INSERT INTO moa_vpl VALUES ("JN15_7","073_15_7","JHN","15","7","7","'Bhɛ ya 'ɛ 'yi, 'ke 'ka blɔɔle ꞊bwa 'mi ma, 'bhɛɛ‑ 'ke 'an ‑jan mu 'ɛ ꞊bwa 'ka 'kpee, 'ke 'ka maza ‑dwa pɛ 'oo pɛ 'la ma, ‑ka 'bhɛ 'yrɛwo‑ 'ŋ ma, 'bhɛɛ‑ 'ŋ nu 'bhɛ 'nalɛ‑ 'ka ni. ");
INSERT INTO moa_vpl VALUES ("JN15_8","073_15_8","JHN","15","8","8","‑Yri gbɛ mu 'ɛ ‑woo bhaa klɛ 'ebebele gɔnɛ‑ 'la gbɛɛn‑, 'ke 'ka ‑za 'lrele‑ ‑bebe mu klɛ 'bhɛ gbɛɛn‑, 'ka 'ŋ Dɛ ‑Waanbhaa' 'tɔbhɔ, 'bhɛɛ‑ 'bhɛ ya 'ɛ 'yi, 'kaa zrɔn 'bhɛ ma 'bhii‑ 'ka ‑o 'an ‑klaŋlanɛ mu 'le. ");
INSERT INTO moa_vpl VALUES ("JN15_9","073_15_9","JHN","15","9","9","'Ŋ ‑za sɔ 'ŋ Dɛ ‑Waanbhaa' ni gɔnɛ‑ 'la gbɛɛn‑, 'ka mu ‑za sɔ 'mi ni 'bhɛɛ‑ gbɛɛn‑. ‑Ka bo 'mi a pɛ 'sɔniya 'ɛ 'yi. ");
INSERT INTO moa_vpl VALUES ("JN15_10","073_15_10","JHN","15","10","10","'Ke 'ka 'mi 'wojan‑ mu 'ɛ 'klɔsikwan, 'ka nu bolɛ 'mi a pɛ 'sɔniya 'ɛ 'yi, 'bhii‑ 'mi 'ŋ Dɛ ‑Waanbhaa' wojan mu 'ɛ 'klɔsikwan gɔnɛ‑ 'la gbɛɛn‑, 'bhɛɛ‑ 'ŋ ꞊bwa ‑yaa' 'sɔniya 'ɛ 'yi.» ");
INSERT INTO moa_vpl VALUES ("JN15_11","073_15_11","JHN","15","11","11","«'Ŋ 'bhɛ ‑jan 'ɛ ꞊woa 'ka ni 'bhɛ gbɛɛn‑ bhe, 'kooko‑ 'mi zrukpaale ‑o gɔnɛ‑ 'la gbɛɛn‑, 'ka mu zrukpaale klɛ 'bhɛ gbɛɛn‑, 'bhɛɛ‑ 'kaa‑ pɛ zrukpaa' 'ɛ 'lɛpale klɛ. ");
INSERT INTO moa_vpl VALUES ("JN15_12","073_15_12","JHN","15","12","12","'Ŋ 'yoo‑ ‑a zi 'bhii‑ 'ka 'taawo 'toŋ 'lɛɛ‑ 'bhɛɛ‑ ta, 'bhɛ ‑le dɔɔ: 'Ka ‑za 'sɔ 'eke‑ ni, 'bhii‑ 'ka ‑za ꞊swa 'mi ni gɔnɛ‑ 'la gbɛɛn‑. ");
INSERT INTO moa_vpl VALUES ("JN15_13","073_15_13","JHN","15","13","13","'Ke 'yee 'niigo‑ 'e 'gbu ꞊si 'ɛ 'yi, 'bhɛɛ‑ 'e ga 'e 'bhɛgwlɛn‑ mu 'ɛ ‑zayi', 'sɔniya 'bhɛɛke ‑gbɛnɛ 'kanle‑ ‑laa ‑o 'bhɛ ta. ");
INSERT INTO moa_vpl VALUES ("JN15_14","073_15_14","JHN","15","14","14","'Ke 'an 'pia‑ 'ka ni 'ka 'taawo 'toŋ 'la ta, 'ke 'ka 'bhɛ ꞊kla, 'kaa‑ zrɔn 'bhɛ ma 'bhii‑ 'ka ‑o 'ŋ 'bhɛgwlɛn‑ mu 'le. ");
INSERT INTO moa_vpl VALUES ("JN15_15","073_15_15","JHN","15","15","15","'Naa 'ka sii ‑li 'an yewonɛ mu, ‑amasrɔyi yewonɛ 'ɛ yaa ‑a ‑kuŋlii klɛza mu 'ɛ dɔ. 'Duŋ‑ 'mi ‑o 'ka 'sii zii' 'ŋ 'bhɛgwlɛn‑ mu, ‑amasrɔyi 'ŋ ‑za 'oo ‑za 'la ‑daanna 'ŋ Dɛ ‑Waanbhaa' 'kɔɔ, 'mi 'bhɛ 'kpɛn ‑zrɔnna 'ka ni. ");
INSERT INTO moa_vpl VALUES ("JN15_16","073_15_16","JHN","15","16","16","Yaa klɛlɛ 'bhii‑ 'ka mu ‑le 'mi makwan‑, 'duŋ‑ 'mi ‑le 'ka mu makwan‑. 'Mi 'ka mu makwan‑, 'bhɛɛ‑ 'ŋ 'ka ꞊kla 'an *winbɔwo mu 'le. 'Kooko‑ 'ka ge ‑za 'lrele‑ mu klɛ; 'bhɛɛ‑ 'ke 'bhɛ ‑za 'lrele‑ mu 'ɛ mɔ. 'Ke 'bhɛ ꞊kla, 'ke 'ka pɛ 'oo pɛ 'la 'yrɛwoa‑ 'ŋ Dɛ ‑Waanbhaa' ma 'mi 'tɔ 'yi, ‑e nu 'bhɛ 'nalɛ‑ 'ka ni. ");
INSERT INTO moa_vpl VALUES ("JN15_17","073_15_17","JHN","15","17","17","'Mi ‑o ‑a zi 'bhii‑ 'ka 'taawo 'toŋ 'la ta, 'bhɛ ‑le dɔɔ 'ke 'ka ‑za sɔ 'eke‑ ni.» ");
INSERT INTO moa_vpl VALUES ("JN15_18","073_15_18","JHN","15","18","18","Zesu pe ‑yaa' ‑klaŋlanɛ mu 'ɛ ni 'ezin‑ dɔɔ: «'Ke 'ka vɛnsi 'drunyan 'yi mu 'ɛ yin 'lii, ‑kaa 'yaango‑ 'bhii‑ 'mi vɛnsia‑ ‑o yin 'lii 'ezin‑ 'ka mu ‑lɛɛ. ");
INSERT INTO moa_vpl VALUES ("JN15_19","073_15_19","JHN","15","19","19","'Kee‑ 'kpa bi 'ka 'pegee 'drunyan 'lɛɛ‑ 'yi mu 'ɛ 'ka ‑o do, 'ka ‑za ‑yaa nu 'sɔlɛ‑ ‑o ni. 'Duŋ‑ 'ka 'laa ‑o 'drunyan 'lɛɛ‑ ‑yaa pɛ 'le, 'bhɛɛ‑ 'mi 'ka malakwan 'yee‑ 'drunyan 'lɛɛ‑ 'yi mu 'ɛ ba, 'bhɛla‑ ‑zayile 'ka vɛn ‑o 'si zii' ‑o yin 'lii. ");
INSERT INTO moa_vpl VALUES ("JN15_20","073_15_20","JHN","15","20","20","'Ŋ ‑jan 'la ꞊woa 'ka ni bhe, 'bhɛ dɔ 'ka 'kpee, 'bhɛ ‑jan 'ɛ 'bhɛ ‑le dɔɔ: ‹Yewonɛ 'ɛ gblaan ‑yi 'laa ya ‑a ‑kuŋlii 'ɛ ni›. 'Bhɛ ya 'ɛ 'yi, 'ke mɛɛ mu 'ɛ ‑yrɛnkpaa 'mi ta, ‑o nu ‑yrɛnkpalɛ 'ka mu ta 'ezin‑; 'ke ‑woo 'ŋ 'wojan‑ mu 'ɛ 'klɔsikwan, ‑o nu 'ka mu wojan mu 'ɛ 'klɔsikunlɛ 'ezin‑. ");
INSERT INTO moa_vpl VALUES ("JN15_21","073_15_21","JHN","15","21","21","‑O nu 'bhɛ ‑za mu 'ɛ 'kpɛn klɛlɛ 'ka ni 'mi 'tɔ 'ɛ ‑zayi'; ‑amasrɔyi mɛɛ 'la zan 'ŋ 'winbwa‑ waa 'bhɛ zan dɔ. ");
INSERT INTO moa_vpl VALUES ("JN15_22","073_15_22","JHN","15","22","22","'Ke 'naa 'nulɛ‑ bi 'drunyan 'lɛɛ‑ 'yi, 'bhɛɛ‑ 'ke 'naa ‑Jan 'Nrale‑ 'ɛ 'wolɛ‑ ‑o ni, ‑kpan 'laa ‑yaa nu baalɛ ‑o ta ‑waa' ‑za ‑yɔɔ' mu 'ɛ ‑zayi'. 'Duŋ‑ ‑zɔn 'zoo 'kedo‑ 'kpɔ 'laa ‑o zi 'ke ‑wa pe dɔɔ waa 'yaango‑ 'bhii‑ ‑o klɛza mu 'ɛ 'mu ‑o 'ke ‑za 'yɔɔ‑ mu 'le. ");
INSERT INTO moa_vpl VALUES ("JN15_23","073_15_23","JHN","15","23","23","'Ke mɛɛ 'la zan 'ŋ mafinyanwo, 'bhɛ zan 'ŋ Dɛ ‑Waanbhaa' mafinyanwo 'ezin‑. ");
INSERT INTO moa_vpl VALUES ("JN15_24","073_15_24","JHN","15","24","24","Mɛɛ ‑bhɛɛke' do 'kpɔ 'laa 'sɔle‑ maza ‑glɔɔn mu 'la klɛlɛ ‑lido', 'ke 'naa 'bhɛ 'sɔle‑ maza ‑glɔɔn mu 'ɛ klɛlɛ bi ‑o 'pleŋ‑, ‑kpan 'laa ‑yaa nu baalɛ ‑o ta 'mu ‑zayi', 'bhɛɛ‑ 'sɔle‑ maza mu 'ɛ ‑zayi' ‑woo 'mi 'pegee 'ŋ Dɛ ‑Waanbhaa' mafinyanwo. ");
INSERT INTO moa_vpl VALUES ("JN15_25","073_15_25","JHN","15","25","25","'Duŋ‑ 'bhɛ 'kpɛn ꞊kla, 'kooko‑ ‑jan 'la yɔɔndɛle ‑o ‑waa' 'Toŋ mu 'ɛ 'yi, 'bhɛ ‑jan 'ɛ 'lɛsɔ‑; 'bhɛ ‑jan 'ɛ 'bhɛ ‑le dɔɔ: ‹‑Woo 'ŋ mafinyanwoa bhaama.›» ");
INSERT INTO moa_vpl VALUES ("JN15_26","073_15_26","JHN","15","26","26","«'Mi nu 'ka 'Bhɔŋba‑ mi 'la 'kpalɛ‑ 'ka ni 'kee‑ da 'ŋ Dɛ ‑Waanbhaa' ba, 'bhɛ 'la 'bhɛ ‑o 'ke wlan ma Lii Weŋ 'ɛ 'le bhe. 'Ke 'bhɛ ꞊nwa bhla 'la ba, 'bhɛ nu 'srɛya‑ klɛlɛ 'mi ba zayi'. ");
INSERT INTO moa_vpl VALUES ("JN15_27","073_15_27","JHN","15","27","27","'Bhɛɛ‑ 'ka mu, 'ka nu 'srɛya‑ klɛlɛ 'mi ba zayi', ‑amasrɔyi 'mi 'pegee 'ka mu ꞊bwa 'eke‑ zi 'kee‑ 'san 'an ye 'ɛ zisan' bhla zi ma.» ");
INSERT INTO moa_vpl VALUES ("JN16_1","073_16_1","JHN","16","1","1","«'Ŋ 'bhɛ ‑jan mu 'ɛ ꞊woa 'ka ni, 'kooko‑ 'ka 'laa ploo 'ka 'kpale‑ ma 'mi 'yi. ");
INSERT INTO moa_vpl VALUES ("JN16_2","073_16_2","JHN","16","2","2","‑O nu 'ka ‑gbinlɛ' Zuufu mu daanfɛ' mu 'ɛ ꞊la. Drɔɔn', 'bhɛ 'waati ‑o zan bhɔlɛ, 'ke 'bhɛ ꞊bhwa, 'ke mɛɛ mu 'ka ꞊dia, ‑e nu klɛlɛ ‑o ni 'bhii‑ ‑woo ‑Waanbhaa' ‑la gba 'zi 'bhɛɛ‑ gbɛɛn‑ bhe. ");
INSERT INTO moa_vpl VALUES ("JN16_3","073_16_3","JHN","16","3","3","‑O nu 'bhɛ ‑za mu 'ɛ klɛlɛ 'ka ni 'bhɛ gbɛɛn‑ bhe, ‑amasrɔyi waa 'ŋ Dɛ ‑Waanbhaa' dɔlɛ, 'bhɛɛ‑ waa 'mi dɔlɛ 'ezin‑. ");
INSERT INTO moa_vpl VALUES ("JN16_4","073_16_4","JHN","16","4","4","'Duŋ‑, 'ŋ 'bhɛ ‑za mu 'ɛ ꞊woa 'ka ni ‑zɔn, 'kooko‑ 'ke ‑o 'bhɛ ‑za ‑glɔɔn mu 'ɛ ꞊kla 'ka ni 'waati 'la ba, ‑e dɔ 'ka 'kpee 'bhii‑ 'ŋ 'bhɛ ‑jan 'ɛ ꞊woa gban 'ka ni. 'Naa 'bhɛ ‑za mu 'ɛ 'pelɛ‑ 'ka ni 'an ye 'ɛ zisan' bhla zi, ‑amasrɔyi 'ŋ 'yaa‑ 'ka ‑din.» ");
INSERT INTO moa_vpl VALUES ("JN16_5","073_16_5","JHN","16","5","5","«'Ŋ 'yoo‑ zan gelɛ 'ŋ 'winbɔ‑ mi 'ɛ ba, 'bhɛɛ‑ 'ka 'kedo‑ 'kpɔ 'laa ‑o 'ŋ 'lrɔkpale dɔɔ: ‹'E ge 'zi 'naa‑ ɛɛ?› ");
INSERT INTO moa_vpl VALUES ("JN16_6","073_16_6","JHN","16","6","6","'Duŋ‑ 'ŋ 'bhɛ ‑jan mu 'ɛ 'wolawoa 'ka ni, 'bhɛla‑ ‑yile 'ka 'ka wlɛyisriwoa. ");
INSERT INTO moa_vpl VALUES ("JN16_7","073_16_7","JHN","16","7","7","'Bhɛɛ‑ 'duŋ‑, 'ŋ 'yoo‑ wlan ‑la pe 'zi 'ka ni dɔɔ: 'ke 'ŋ ‑ja, 'bhɛ 'trɔn‑ ‑o 'ka mu 'gbu ma. ‑Amasrɔyi 'ke 'naa gelɛ, 'Bhɔŋba‑ mi 'ɛ yaa nu nulɛ 'ka ba. 'Duŋ‑ 'ke 'ŋ ‑ja, 'ŋ nu ‑a 'kpalɛ‑ 'ka ni. ");
INSERT INTO moa_vpl VALUES ("JN16_8","073_16_8","JHN","16","8","8","'Bhɛɛ‑ 'ke 'bhɛ 'Bhɔŋba‑ mi 'ɛ ꞊nwa bhla 'la ba, 'bhɛ nu a zrɔnlɛ 'drunyan 'yi mu 'ɛ ni 'bhii‑ ‑o ‑yinile ‑o ‑za 'yɔɔ‑ ba zayi', 'bhɛ 'pegee ‑lɛdɔɔleya ‑Waanbhaa' ‑yrɛ 'yi, 'bhɛɛ‑ ‑Waanbhaa' a 'kiti 'ɛ ba zayi'. ");
INSERT INTO moa_vpl VALUES ("JN16_9","073_16_9","JHN","16","9","9","‑O ‑yinile ‑o ‑za 'yɔɔ ba zayi' win 'la ma, 'bhɛ ‑le waa ‑o 'kpa 'mi 'yi. ");
INSERT INTO moa_vpl VALUES ("JN16_10","073_16_10","JHN","16","10","10","'Bhɛɛ‑ ‑o ‑yinile ‑o ‑lɛdɔɔleya ba zayi' win 'la ma, 'bhɛ ‑le dɔɔ 'ŋ 'yoo‑ ge 'zi 'ŋ Dɛ ‑Waanbhaa' ba, 'bhɛɛ‑ 'ka 'laa nu 'ŋ 'yelɛ‑ ‑li. ");
INSERT INTO moa_vpl VALUES ("JN16_11","073_16_11","JHN","16","11","11","'Bhɛɛ‑ ‑o ‑yinile ‑o ‑Waanbhaa' a 'kitikanza 'ɛ ba zayi', ‑amasrɔyi ‑Waanbhaa' ‑kpan balaa' gban 'drunyan 'lɛɛ‑ 'yi ‑kuŋlii 'ɛ ta. ");
INSERT INTO moa_vpl VALUES ("JN16_12","073_16_12","JHN","16","12","12","«‑Jan ‑bebe ‑o ‑li 'ŋ zi 'ke 'mu pe 'ka ni, 'duŋ‑ 'bhɛ faŋgan‑ 'laa ‑o 'ka ta 'ke 'ka sɔ ‑o ‑yimale ‑zɔn. ");
INSERT INTO moa_vpl VALUES ("JN16_13","073_16_13","JHN","16","13","13","'Ke wlan ma Lii 'Weŋ 'ɛ ꞊nwa bhla 'la ba, 'bhɛ nu 'ka 'lɛdɔɔlɛ wlan a pɛ zi 'ɛ 'kpɛn 'lii. ‑Amasrɔyi, Yaa nu ‑a 'gbu a janwolɛ, 'duŋ‑ ‑e ‑za mu 'la 'kpɛn ꞊maa ‑e nu 'mu ‑la wolɛ 'ka ni; 'bhɛɛ‑ ‑za mu 'la ‑woo zan klɛlɛ, ‑e nu 'mu ‑la ‑lɛɛjanwolɛ 'ka ni. ");
INSERT INTO moa_vpl VALUES ("JN16_14","073_16_14","JHN","16","14","14","‑E nu 'ŋ 'tɔbhɔlɛ, ‑amasrɔyi ‑jan 'la 'bhɛ ‑o 'mi 'kɔɔ, ‑e nu 'bhɛɛ‑ 'silɛ‑, 'bhɛɛ‑ ‑e 'bhɛ wo 'ka ni. ");
INSERT INTO moa_vpl VALUES ("JN16_15","073_16_15","JHN","16","15","15","Pɛ 'oo pɛ 'la ‑yoo 'ŋ Dɛ ‑Waanbhaa' 'kɔɔ, 'mi a pɛ ‑le 'mu 'kpɛn 'le 'ezin‑. 'Bhɛla‑ ‑zayile 'an ꞊pia dɔɔ Lii 'Weŋ 'ɛ nu 'mi a ‑jan 'ɛ 'silɛ‑ 'bhɛɛ‑ ‑e 'bhɛ wo 'ka ni.» ");
INSERT INTO moa_vpl VALUES ("JN16_16","073_16_16","JHN","16","16","16","Zesu pe ‑yaa' ‑klaŋlanɛ mu 'ɛ ni dɔɔ: «‑A ‑vinbwa 'waati sa, 'bhɛɛ‑ 'ka 'laa nu 'ŋ 'yelɛ‑ ‑li, 'bhɛɛ‑ ‑a ‑vinbwa 'waati sa 'bhɛɛ‑ 'ka nu 'ŋ 'yelɛ‑ 'ezin‑.» ");
INSERT INTO moa_vpl VALUES ("JN16_17","073_16_17","JHN","16","17","17","'Bhɛ klɛle 'tɛ, 'ke ‑yaa' ‑klaŋlanɛ mu 'ɛ 'ke mu 'a 'pele 'eke‑ ni dɔɔ: «‑Ya 'pelawo zii' dɔɔ: ‹‑A ‑vinbwa 'waati sa, 'bhɛɛ‑ 'ka 'laa nu 'ŋ 'yelɛ‑ ‑li, 'bhɛɛ‑ ‑a ‑vinbwa 'waati sa 'bhɛɛ‑ 'ka nu 'ŋ 'yelɛ‑ 'ezin‑›. 'Bhɛ 'pegee: ‹‑Amasrɔyi 'ŋ 'yoo‑ ge 'zi 'ŋ Dɛ ‑Waanbhaa' ba.› 'Bhɛ ‑jan mu 'la bhe 'mu 'yi ‑o 'nale‑ ‑a ma ɛɛ? ");
INSERT INTO moa_vpl VALUES ("JN16_18","073_16_18","JHN","16","18","18","‑Ya 'pelawo zii' dɔɔ: ‹‑A ‑vinbwa 'waati sa›. 'Bhɛ 'yi ‑o 'nale‑ ‑a ma ɛɛ? ‑Yoo ‑jan 'la 'wo 'zi bhe, 'waa ‑o 'bhɛ 'yima zii'.» ");
INSERT INTO moa_vpl VALUES ("JN16_19","073_16_19","JHN","16","19","19","Zesu 'a 'yaangole 'bhii‑ ‑yaa' ‑klaŋlanɛ mu 'ɛ ‑woo zan ‑a ‑lrɔkpalɛ, 'ke ‑ya pele‑ ‑o ni 'tɛ dɔɔ: «'An 'pelawoa 'ka ni dɔɔ: ‹‑A ‑vinbwa 'waati sa, 'bhɛɛ‑ 'ka 'laa nu 'ŋ 'yelɛ‑ ‑li, 'bhɛɛ‑ ‑a ‑vinbwa 'waati sa 'bhɛɛ‑ 'ka nu 'ŋ 'ye 'ezin‑›. 'Ka ‑o 'eke‑ ‑lrɔkpa' zii' 'bhɛɛ‑ ma ɛɛ? ");
INSERT INTO moa_vpl VALUES ("JN16_20","073_16_20","JHN","16","20","20","'Mi pe 'ka ni 'ŋ 'sɔwɛɛ‑ ma dɔɔ: 'ka nu wisilɛ, 'bhɛɛ‑ 'ka nu 'ka 'la ma wisilɛ, 'duŋ‑ 'drunyan 'lɛɛ‑ 'yi mu 'ɛ ‑o zrukpaale nu klɛlɛ 'bhɛ ‑zayi'. 'Bhɛɛ‑ 'ka nu 'ka wlɛyisriwolɛ, 'duŋ‑ 'kaa‑ wlɛyisriwole 'ɛ nu niinalɛ 'ke 'ka zrukpaa' 'le. ");
INSERT INTO moa_vpl VALUES ("JN16_21","073_16_21","JHN","16","21","21","'Ke le do ‑bla ꞊zian ‑a ta, ‑ya wlɛyisriwo, ‑amasrɔyi yaa ‑yrɛnbhle' bhla 'ɛ ꞊bhwa. 'Duŋ‑ 'kee‑ ‑yaan ‑nɛ 'ɛ 'yalele bhla 'la ba, ‑e ‑yrɛn 'la ꞊bhla bhe, 'bhɛ ꞊nia ‑a 'kpee, ‑amasrɔyi ‑ya ‑yaa 'ke bhaaplɛŋ do 'la 'le 'drunyan 'lɛɛ‑ 'yi 'bhɛ 'a zrukpalaa. ");
INSERT INTO moa_vpl VALUES ("JN16_22","073_16_22","JHN","16","22","22","'Bhɛɛ‑ 'ka mu ‑o 'bhɛɛ‑ gbɛɛn‑ 'ezin‑: 'ka ‑o 'ka wlɛyisriwo zii' ‑zɔn. 'Duŋ‑ 'ŋ nu 'ka 'yelɛ‑ 'ezin‑, 'bhɛɛ‑ 'ka zrukpaale nu klɛlɛ. 'Bhɛɛ‑ mɛɛ 'kedo‑ 'kpɔ 'laa nu 'sɔlɛ‑ 'kaa‑ zrukpaa 'ɛ gole‑ 'ka zru ba.» ");
INSERT INTO moa_vpl VALUES ("JN16_23","073_16_23","JHN","16","23","23","«'Ke 'bhɛ yi 'ɛ ꞊bhwa, 'ka 'laa nu 'ŋ 'lrɔkpalɛ ‑za 'kedo‑ 'kpɔ 'yi ‑li. 'Mi pe 'ka ni 'ŋ 'sɔwɛɛ‑ ma dɔɔ: 'ke 'ka pɛ 'oo pɛ 'la 'yrɛwoa‑ 'ŋ Dɛ ‑Waanbhaa' ma 'mi 'tɔ 'ɛ 'yi, ‑e nu 'bhɛ pɛ 'ɛ 'nalɛ‑ 'ka ni. ");
INSERT INTO moa_vpl VALUES ("JN16_24","073_16_24","JHN","16","24","24","'Ali‑ 'kee‑ nu 'tɛnlɛ‑ ‑zɔn ma, 'ka 'laa pɛ 'kedo‑ 'kpɔ 'yrɛwolɛ ‑li 'ŋ Dɛ ‑Waanbhaa' ma 'mi 'tɔ 'yi. ‑Ka pɛ ‑yrɛwo' ‑a ma, 'bhɛɛ‑ 'ka nu pɛ 'srɔɔwolɛ ‑a 'kɔɔ. 'Ke 'bhɛ ꞊kla, 'bhɛɛ‑ 'kaa‑ zrukpaa' 'ɛ 'lɛ nu 'palɛ‑.» ");
INSERT INTO moa_vpl VALUES ("JN16_25","073_16_25","JHN","16","25","25","Zesu ‑ja ‑janwole 'ɛ zi ‑yaa' ‑klaŋlanɛ mu 'ɛ ni 'ke ‑ya pe ‑o ni dɔɔ: «'Mi 'bhɛ ‑za mu 'ɛ 'kpɛn ꞊woa 'ka ni ‑gɔɔn mu ‑la ‑yi. 'Duŋ‑ 'bhɛ 'waati ‑o zan bhɔlɛ, 'bhɛɛ‑ 'naa nu ‑janwolɛ ‑li 'ka ni ‑gɔɔn mu 'yi, 'duŋ‑ 'ŋ nu 'ŋ Dɛ ‑Waanbhaa' ba jan mu 'ɛ 'wolɛ‑ 'ka ni kpataakpa. ");
INSERT INTO moa_vpl VALUES ("JN16_26","073_16_26","JHN","16","26","26","'Ke 'bhɛ yi 'ɛ ꞊bhwa, 'ka nu pɛ ‑yrɛwolɛ 'ŋ Dɛ ‑Waanbhaa' ma 'ŋ 'tɔ 'yi; 'bhɛɛ‑ 'naa‑ ‑o ‑a pe 'zi 'ka ni dɔɔ 'ŋ nu ‑sromabɔlɛ 'ŋ Dɛ ‑Waanbhaa' ni, 'kooko‑ ‑e 'kaa pɛ ‑yrɛwole 'ɛ 'lɛkun‑ 'ka ni. ");
INSERT INTO moa_vpl VALUES ("JN16_27","073_16_27","JHN","16","27","27","‑Amasrɔyi 'ka mu ‑za sɔ 'ŋ Dɛ ‑Waanbhaa' 'gbu ni. 'Ka ‑za sɔ ‑a ni ‑amasrɔyi 'mi ‑za ‑swa 'ka ni, 'bhɛɛ‑ 'ka 'kpale‑ ‑o ‑a ‑yi 'bhii‑ 'ŋ ‑daa 'yee‑ ‑Waanbhaa' ‑la ba. ");
INSERT INTO moa_vpl VALUES ("JN16_28","073_16_28","JHN","16","28","28","Wlan 'ɛ ni, 'ŋ ‑daa 'yee‑ 'ŋ Dɛ ‑Waanbhaa' ‑la ba, 'bhɛɛ‑ 'ŋ ꞊nwa 'drunyan 'lɛɛ‑ 'yi. 'Mi ‑o go 'zi 'drunyan 'lɛɛ‑ 'yi, 'bhɛɛ‑ 'ŋ 'yoo‑ 'niina‑ 'zi 'yee‑ 'ŋ Dɛ ‑Waanbhaa' ba ye.» ");
INSERT INTO moa_vpl VALUES ("JN16_29","073_16_29","JHN","16","29","29","'Bhɛ klɛle 'tɛ, 'ke ‑yaa' ‑klaŋlanɛ mu 'ɛ ‑wa pele‑ ‑a ni dɔɔ: «‑Ŋŋ'! 'Yaa ‑o ‑janwo' zii' ‑li 'o ni ‑gɔɔn mu 'yi, 'bhɛɛ‑ 'duŋ‑ 'e ‑janwole ‑saan 'o ni kpataakpa 'tɛ. ");
INSERT INTO moa_vpl VALUES ("JN16_30","073_16_30","JHN","16","30","30","'Wa 'yaango‑ ‑zɔn 'bhii‑ 'e ‑za 'kpɛn dɔ. 'Bhɛɛ‑ 'sani‑ ‑o nu 'e 'lrɔkpalɛ ‑za 'la 'yi, 'e 'bhɛ ‑dwa gban. 'Bhɛla‑ ‑yile 'o 'kpale‑ ‑o ‑a ‑yi 'bhii‑ 'e ‑daa ‑Waanbhaa' ba.» ");
INSERT INTO moa_vpl VALUES ("JN16_31","073_16_31","JHN","16","31","31","'Bhɛ klɛle 'tɛ, 'ke Zesu 'bhɛ zikpale ‑o ni dɔɔ: «'Ka pe dɔɔ 'ka 'kpale‑ ‑o 'mi 'yi ‑zɔn ɛɛ? ");
INSERT INTO moa_vpl VALUES ("JN16_32","073_16_32","JHN","16","32","32","‑Ka 'ka 'trɔnkpa doo! 'Bhɛ 'waati ‑o zan bhɔlɛ, 'bhɛɛ‑ 'bhɛ ꞊bhwa gban 'duŋ‑, 'ka 'kpɛn nu 'kanlɛ‑ 'eke‑ ma, 'bhɛɛ‑ 'ka 'kpɛn do do nu gelɛ 'ka ba ‑lɛ ma, 'bhɛɛ‑ 'ka nu 'ŋ do ‑kplɛnnɛ' 'tolɛ‑ ‑a nɔɔ‑. 'Duŋ‑ 'naa nu bolɛ ‑o 'ŋ do ‑kplɛnnɛ' 'le 'dɛ, ‑amasrɔyi, 'ŋ Dɛ ‑Waanbhaa' ‑o 'ŋ zi. ");
INSERT INTO moa_vpl VALUES ("JN16_33","073_16_33","JHN","16","33","33","'Ŋ 'bhɛ ‑za mu 'ɛ ꞊pia 'ka ni bhe, 'kooko‑ 'mi 'pegee 'ka mu 'kpale‑ 'la ‑yoo do ma, 'ka yilabla 'srɔɔwo‑. 'Ka nu ‑yrɛn ‑bebe 'bhlelɛ‑ 'drunyan 'lɛɛ‑ 'yi. 'Duŋ‑ ‑ka 'ka zrudɔ 'eglɔɔle! ‑Amasrɔyi 'ŋ 'seŋgwa‑ gban 'drunyan 'le.» ");
INSERT INTO moa_vpl VALUES ("JN17_1","073_17_1","JHN","17","1","1","Zesu 'yanle‑ 'bhɛ ‑jan 'ɛ 'wolele, 'ke ‑ya ‑yrɛkpale laanima, 'bhɛɛ‑ 'ke ‑ya pele‑ dɔɔ: «'Ŋ Dɛ ‑Waanbhaa' 'waati 'ɛ ꞊bhwa ‑zɔn 'tɛ. 'E Gbe 'ɛ 'tɔbhɔ mɛɛ mu 'ɛ ‑yrɛ ma, 'kooko‑ 'e Gbe 'bhɛ 'e 'tɔbhɔ 'ezin‑ ‑o ‑yrɛ ma. ");
INSERT INTO moa_vpl VALUES ("JN17_2","073_17_2","JHN","17","2","2","‑Amasrɔyi 'e ‑glɔɔya' ‑naa ‑a ni bhaaplɛŋ mu 'kpɛn ta, 'kooko‑ bole ‑yrɛ ma ‑si 'la ‑daŋ' 'laa ‑o 'bhɛ ma ‑e 'bhɛ na 'e mɛɛ 'la zan mu gbɛkpaa‑ ‑a 'kɔɔ 'mu ni. ");
INSERT INTO moa_vpl VALUES ("JN17_3","073_17_3","JHN","17","3","3","Bole ‑yrɛ ma ‑si 'la ‑daŋ' 'laa ‑o 'bhɛ ma 'bhɛ ‑le dɔɔ 'ke ‑woo 'e dɔ 'bhii‑ 'bhi ‑le 'ke wlan ma ‑Waanbhaa' do 'kpɔ 'ɛ 'le, 'bhɛɛ‑ 'ke ‑wa dɔ 'ezin‑ 'bhii‑ 'bhi ‑le Zesu Krisi 'winbwa‑. ");
INSERT INTO moa_vpl VALUES ("JN17_4","073_17_4","JHN","17","4","4","'Bhɛɛ‑ 'ŋ 'yaa‑ 'tɔbhɔleya 'ɛ ‑zrɔnna 'trɛ ta ‑gɛ, 'bhɛɛ‑ 'e ye 'la gbɛkpaa‑ 'ŋ 'kɔɔ 'kaa 'an 'wo, 'ŋ 'yaan‑ 'bhɛ 'wolele. ");
INSERT INTO moa_vpl VALUES ("JN17_5","073_17_5","JHN","17","5","5","'Bhɛ ya 'ɛ 'yi, 'ŋ Dɛ ‑Waanbhaa', 'ŋ 'tɔbhɔle ‑yaa 'e ‑din gɔnɛ‑ 'la gbɛɛn‑ 'ke 'drunyan 'laa klɛlɛ ‑li 'waati 'la ba, 'bhɛ 'tɔbhɔleya ‑glɔɔn 'ɛ 'na 'ŋ ni ‑zɔn.» ");
INSERT INTO moa_vpl VALUES ("JN17_6","073_17_6","JHN","17","6","6","«'E mɛɛ la zan mu ꞊sia 'drunyan 'ɛ 'yi mu 'ɛ ba, 'bhɛɛ‑ 'yoo‑ ‑naa 'ŋ ni, 'an ꞊kla 'bhɛɛ‑ ‑woo 'e ‑dwa. 'Yaa‑ pɛ ‑le ‑yaa 'ke ‑o ‑le, 'bhɛɛ‑ 'yoo‑ ‑naa 'ŋ ni; 'bhɛɛ‑ ‑o 'yaa‑ ‑jan 'ɛ 'klɔsikwan. ");
INSERT INTO moa_vpl VALUES ("JN17_7","073_17_7","JHN","17","7","7","‑Wa 'yaangwa‑ ‑zɔn 'bhii‑ 'e pɛ 'la 'kpɛn ꞊naa 'ŋ ni, 'bhɛ da 'bhi 'gbu ‑la ba. ");
INSERT INTO moa_vpl VALUES ("JN17_8","073_17_8","JHN","17","8","8","‑Amasrɔyi 'e ‑jan mu 'la ꞊woa 'mi ni, 'mi 'bhɛ mu ‑la ꞊woa ‑o ni 'ezin‑; 'bhɛɛ‑ ‑o ‑dwa ‑o ‑la. ‑Wa 'yaangwa‑ 'ezin‑ 'bhii‑ 'ŋ ‑daa 'bhi 'gbu ‑la ba wlan 'ɛ ni, 'bhɛɛ‑ ‑woo ‑kpaa ‑a ‑yi 'bhii‑ 'bhi ‑le 'mi 'winbwa‑. ");
INSERT INTO moa_vpl VALUES ("JN17_9","073_17_9","JHN","17","9","9","«'Ŋ 'yoo‑ 'ŋ 'seriwo zii' 'wola‑ ‑za ma, 'naa ‑o 'ŋ 'seriwo zii' 'drunyan 'yi mu a ‑za ma; 'duŋ‑ 'ŋ 'yoo‑ 'seriwo zii' 'e mɛɛ 'la zan mu gbɛkpaa‑ 'ŋ 'kɔɔ 'mu ‑la ‑za ma, ‑amasrɔyi 'yaa pɛ ‑le 'ke ‑o ‑le. ");
INSERT INTO moa_vpl VALUES ("JN17_10","073_17_10","JHN","17","10","10","Pɛ 'oo pɛ 'la 'bhɛ ‑o 'mi 'kɔɔ, 'yaa‑ pɛ ‑le 'bhɛ 'le; 'bhɛɛ‑ pɛ 'oo pɛ 'la 'bhɛ ‑o 'bhi 'kɔɔ, 'mi a pɛ ‑le 'bhɛ 'le 'ezin‑. 'Bhɛ ya 'ɛ 'yi, mɛɛ mu 'an pɛ 'tɔbhɔleya 'ɛ ye 'mi a pɛ ‑klaŋlanɛ mu 'ɛ 'mu ‑la ‑yi. ");
INSERT INTO moa_vpl VALUES ("JN17_11","073_17_11","JHN","17","11","11","'Mi ‑o zan golɛ 'drunyan 'lɛɛ‑ 'yi, duŋ‑ 'woo‑ mu nu bolɛ ‑a ‑yi. 'Mi ‑o ge 'zi 'bhi ‑la ba ye. 'Ŋ Dɛ ‑Waanbhaa' 'weŋ, 'e 'yrɛkpa ‑o ba 'yaa‑ ‑glɔɔya' 'ɛ 'le, 'e ‑glɔɔya' 'la ꞊naa 'ŋ ni. 'Kooko‑ ‑o klɛ do, 'bhii‑ 'bhi 'pegee 'mi ‑o do gɔnɛ‑ 'la gbɛɛn‑ bhe. ");
INSERT INTO moa_vpl VALUES ("JN17_12","073_17_12","JHN","17","12","12","'Mi 'pegee 'woo‑ mu ‑yaa 'eke‑ zi 'waati 'la ba, 'mi 'yaa‑ 'ŋ 'yrɛkpa‑ ‑o ba 'yaa‑ 'ɛ ‑glɔɔya' 'le, 'e ‑glɔɔya' 'la ꞊naa 'mi ni bhe. 'Mi ‑o tagbian‑ 'bhɛɛ‑ ‑o do 'kpɔ 'laa 'nilɛ‑ ‑o ba, 'ke yaa 'e go ‑o do 'la 'yaa‑ nu nilɛ ‑o ba 'bhɛ ba, 'kooko‑ 'bhi ‑Waanbhaa' 'yaa‑ 'Sɛwɛ 'yi jan 'ɛ 'lɛsɔ‑. ");
INSERT INTO moa_vpl VALUES ("JN17_13","073_17_13","JHN","17","13","13","'Duŋ‑ ‑zɔn, 'ŋ 'yoo‑ ge 'zi 'e ba ye. 'Ŋ 'yoo‑ 'bhɛ ‑jan mu 'lɛɛ‑ 'kpɛn 'pe zii' 'bhɛ gbɛɛn‑ bhe, 'ŋ 'yoo‑ ‑li 'drunyan 'yi bhla 'la ba, 'kooko‑ zrukpaa' 'la 'bhɛ ‑o 'mi 'yi, 'bhɛ ‑glɔɔn 'ɛ klɛ ‑o ‑yi, 'bhɛɛ‑ 'bhɛ 'lɛpale klɛ. ");
INSERT INTO moa_vpl VALUES ("JN17_14","073_17_14","JHN","17","14","14","'Ŋ ‑wo ‑daanna 'yaa‑ ‑jan 'ɛ 'le, 'bhɛla‑ ‑zayile 'drunyan 'yi mu ‑o mafinyanwoa. ‑Amasrɔyi waa ‑o 'ke 'drunyan a pɛ 'le, 'bhii‑ 'mi 'laa ‑o 'ke 'drunyan 'lɛɛ‑ ‑yaa' pɛ 'le gɔnɛ‑ 'la gbɛɛn‑. ");
INSERT INTO moa_vpl VALUES ("JN17_15","073_17_15","JHN","17","15","15","'Naa ‑o ‑sromabɔ 'zi 'e ni dɔɔ 'yoo‑ 'kun 'bhɛɛ‑ 'yoo‑ go 'drunyan 'lɛɛ‑ 'yi, 'duŋ‑ 'ŋ 'yoo‑ ‑sromabɔ 'zi 'e ni dɔɔ 'yee 'yrɛkpa‑ ‑o ba, 'bhɛɛ‑ 'e ‑Setran' 'kan ‑o ma 'egbɔɔnle. ");
INSERT INTO moa_vpl VALUES ("JN17_16","073_17_16","JHN","17","16","16","Waa ‑o 'ke 'drunyan 'lɛɛ‑ ‑yaa' pɛ 'le, 'bhii‑ 'mi 'laa ‑o 'ke ‑yaa' pɛ 'le gɔnɛ‑ 'la gbɛɛn‑. ");
INSERT INTO moa_vpl VALUES ("JN17_17","073_17_17","JHN","17","17","17","‑O 'kpɛn 'kpa 'edaŋma, 'bhɛɛ 'yoo‑ klɛ 'yaa mɛɛ 'weŋ mu 'le 'yaa‑ wlan 'ɛ 'le. ‑Amasrɔyi 'yaa‑ ‑jan 'ɛ 'bhɛ ‑le 'ke wlan 'le. ");
INSERT INTO moa_vpl VALUES ("JN17_18","073_17_18","JHN","17","18","18","'E 'mi 'winbwa‑ 'drunyan 'yi gɔnɛ‑ 'la gbɛɛn‑, 'mi ‑o winbɔ 'zi 'bhɛɛ‑ gbɛɛn‑ 'drunyan 'ɛ 'yi. ");
INSERT INTO moa_vpl VALUES ("JN17_19","073_17_19","JHN","17","19","19","'Mi 'ŋ 'gbu 'kpa zii' 'edaŋma 'bhi do ‑kplɛn ‑a pɛ 'le 'woo‑ mu ‑zayi', 'kooko‑ 'woo‑ 'gbu kpa 'ezin‑ 'edaŋma, 'bhɛɛ‑ ‑o klɛ 'weŋ 'yaa‑ pɛ wlan 'ɛ 'le.» ");
INSERT INTO moa_vpl VALUES ("JN17_20","073_17_20","JHN","17","20","20","«'Naa ‑o 'ŋ 'seriwo zii' 'te 'woo‑ do 'kpɛn ma; 'duŋ‑ 'ŋ 'yoo‑ 'ŋ 'seriwo zii' 'ezin‑ mɛɛ 'la zan mu nu 'mu 'kpalɛ‑ 'ŋ 'yi ‑o wojan mu 'ɛ ma boolazi. ");
INSERT INTO moa_vpl VALUES ("JN17_21","073_17_21","JHN","17","21","21","'Ŋ 'yoo‑ 'ŋ 'seriwo zii' 'e ni, 'kooko‑ ‑o 'kpɛn 'kpale‑ klɛ do ma, 'bhii‑ 'bhi 'ŋ Dɛ ‑Waanbhaa' 'pegee 'mi 'kpale‑ ‑o do ma gɔnɛ‑ 'la gbɛɛn‑. 'Bhɛɛ‑ 'kooko‑ 'woo‑ mu 'pegee 'o mɔɔ 'kpale‑ klɛ do ma, 'kooko‑ 'drunyan 'yi mu 'ɛ ‑woo kpa ‑a ‑yi 'bhii‑ 'bhi ‑le 'mi 'winbwa‑. ");
INSERT INTO moa_vpl VALUES ("JN17_22","073_17_22","JHN","17","22","22","'Mi 'duŋ‑, 'e 'tɔbhɔleya 'la ꞊naa 'mi ni, 'ŋ 'bhɛɛ‑ ‑glɔɔn ꞊naa ‑o ni, 'kooko‑ ‑o 'kpale‑ klɛ do ma, 'bhii‑ 'mi 'pegee 'bhi ‑o do gɔnɛ‑ 'la gbɛɛn‑. ");
INSERT INTO moa_vpl VALUES ("JN17_23","073_17_23","JHN","17","23","23","'Bhɛ 'yi ‑le dɔɔ: 'mi ‑o 'woo‑ mu 'yi, 'bhɛɛ‑ 'bhi ‑o 'mi 'yi; 'bhɛ klɛgbɛya 'ɛ gbɛɛn‑ bhe, ‑o nu klɛlɛ do, 'ke ‑a ‑lɛyan' a ma. 'Ke 'bhɛ ꞊kla, 'drunyan 'yi mu 'ɛ nu ‑a 'yaangolɛ 'bhii‑ 'bhi ‑le 'mi winbwa‑, 'bhɛ 'pegee ‑o ‑za sɔ 'e ni 'bhii‑ 'mi ‑za sɔ 'e ni gɔnɛ‑ 'la gbɛɛn‑ 'ezin‑ bhe. ");
INSERT INTO moa_vpl VALUES ("JN17_24","073_17_24","JHN","17","24","24","'Ŋ Dɛ ‑Waanbhaa', 'bhi ‑le ‑o ‑naa 'mi ni. 'Bhɛɛ‑ 'ŋ 'yoo‑ ‑a zi 'bhii‑ 'ŋ ‑yoo yrɛ 'la ꞊nɔɔ 'woo‑ 'pegee 'mi klɛ 'eke‑ 'yi 'bhɛɛ‑ ꞊nɔɔ 'ezin‑. 'Ke 'bhɛ ꞊kla ‑o nu 'ŋ 'tɔbhɔleya 'ɛ 'yelɛ‑, 'e 'tɔbhɔleya 'la ꞊naa 'ŋ ni bhe. ‑Amasrɔyi 'ŋ ‑za ‑swa 'e ni 'ke 'yaa 'drunyan klɛlɛ ‑li 'elwale ta ‑sɔ. ");
INSERT INTO moa_vpl VALUES ("JN17_25","073_17_25","JHN","17","25","25","'Ŋ Dɛ ‑Waanbhaa' ‑lɛdɔɔle, 'drunyan 'yi mu laa 'e dɔlɛ; 'mi 'duŋ‑ 'e ‑dwa; 'bhɛɛ‑ 'an ‑klaŋlanɛ mu 'lɛɛ‑ 'mu 'a 'yaandwa‑ 'bhii‑ 'bhi ‑le 'mi 'winbwa‑. ");
INSERT INTO moa_vpl VALUES ("JN17_26","073_17_26","JHN","17","26","26","'Mi 'a ꞊kla 'bhɛɛ‑ ‑woo 'e ‑dwa, 'bhɛɛ‑ 'ŋ nu a klɛlɛ 'ezin‑ 'bhɛɛ‑ ‑woo 'e baan' dɔ, 'kooko‑ 'mi ‑za ꞊swa 'e ni 'sɔniya ‑glɔɔn 'la 'yi, 'bhɛ 'sɔniya ‑glɔɔn 'ɛ klɛ ‑o ‑yi 'ezin‑, 'bhɛɛ‑ 'mi 'gbu klɛ 'woo‑ mu 'gbu 'yi.» ");
INSERT INTO moa_vpl VALUES ("JN18_1","073_18_1","JHN","18","1","1","Zesu 'yanle‑ ‑a 'seriwolele, 'ke 'yee‑ 'pegee ‑yaa' ‑klaŋlanɛ mu 'ɛ ‑o gele‑ Sedrɔn tɔ ‑yrɛ gbɛ do 'ɛ ta. 'Bhɛɛ‑ 'ke ‑o wlale‑ 'bhɛ ꞊nɔɔ ‑yrigba' do 'yi. ");
INSERT INTO moa_vpl VALUES ("JN18_2","073_18_2","JHN","18","2","2","Zuda 'la 'yaa‑ nu ‑dawli' 'kpalɛ‑ Zesu gbɛ ta, 'bhɛ 'yaa‑ 'bhɛ ‑yrigba' 'ɛ dɔ 'ezin‑. ‑Amasrɔyi Zesu 'pegee ‑yaa' ‑klaŋlanɛ mu 'ɛ 'yaa‑ ꞊kla 'eke‑ ba 'bhɛ yrɛ 'ɛ ꞊nɔɔ 'waati 'ke ba. ");
INSERT INTO moa_vpl VALUES ("JN18_3","073_18_3","JHN","18","3","3","Zesu 'pegee ‑yaa' ‑klaŋlanɛ mu 'ɛ 'yaa‑ 'bhɛ ‑yrigba' 'ɛ 'yi bhla 'la ba, 'ke Zuda 'nule. 'Srwase 'lɛdo‑ 'pegee ‑Waanbhaa' Gba 'Fɛ ‑Gbɛnɛ 'ɛ gooba mu 'ke mu ‑yaa 'yee‑ Zuda zi. 'Sraka 'lɛna ‑kuŋlii mu 'ɛ 'pegee Farizi mu 'ɛ 'mu ‑le 'woo‑ ‑Waanbhaa' Gba 'Fɛ ‑Gbɛnɛ 'ɛ gooba mu 'ɛ ꞊kpaa ‑a zi. ‑Laŋbha mu 'pegee ‑yani mu, 'bhɛɛ‑ gwledanpɛ mu ‑yaa ‑o 'kɔɔ. ");
INSERT INTO moa_vpl VALUES ("JN18_4","073_18_4","JHN","18","4","4","'Bhɛ 'yi 'tɛ, ‑za 'oo ‑za 'la 'yaa‑ nu 'tɛnlɛ‑ Zesu ma, ‑a 'gbu 'yaa‑ 'bhɛ dɔ. 'Bhɛla‑ ‑yile 'ke ‑ya mabɛɛnle 'woo‑ mɛɛ mu 'ɛ ‑din, 'bhɛɛ‑ 'ke ‑yoo ‑lrɔkpale dɔɔ: «'Ka ‑o ‑dela ‑glin 'zi ɛɛ?» ");
INSERT INTO moa_vpl VALUES ("JN18_5","073_18_5","JHN","18","5","5","‑O pe a ni dɔɔ: «'Woo‑ Zesu 'la da Nazarɛti ‑wa 'ɛ ta 'bhɛ ‑la ‑glin 'zi.» Zesu pe 'ezin‑ ‑o ni dɔɔ: «'Mi ‑le 'kɛle‑.» 'Bhɛɛ‑ Zuda 'la 'yaa‑ ‑dawli' 'kpa zii' Zesu gbɛ ta 'bhɛ 'yaa‑ 'woo‑ mɛɛ mu 'ɛ 'pleŋ‑. ");
INSERT INTO moa_vpl VALUES ("JN18_6","073_18_6","JHN","18","6","6","Zesu 'a 'pele‑ ‑o ni dɔɔ: «'Mi 'le 'kɛle‑». 'Ke ‑o gele‑ ‑o ‑zanta', 'bhɛɛ‑ 'ke ‑o baale' 'trɛ ma. ");
INSERT INTO moa_vpl VALUES ("JN18_7","073_18_7","JHN","18","7","7","'Bhɛɛ‑ 'ke Zesu ‑o ‑lrɔkpa' gbɛ drɛɛwole dɔɔ: «'Ka ‑o ‑dela ‑glin 'zi ɛɛ?» ‑O pe dɔɔ: «Zesu 'la da Nazarɛti ‑wa 'ɛ ta.» ");
INSERT INTO moa_vpl VALUES ("JN18_8","073_18_8","JHN","18","8","8","'Bhɛ klɛle 'tɛ, 'ke Zesu 'a 'lɛkunle ‑o ni dɔɔ: «'Naa 'pelɛ‑ gban 'ka ni dɔɔ 'mi ‑le 'kɛle‑ ɛɛ? 'Ke 'ka ‑o 'mi ‑la ‑glin 'zi, ‑kaa 'to 'ke 'ŋ zi mu 'lɛɛ‑ ‑o ge ‑o ba ‑lɛ ma.» ");
INSERT INTO moa_vpl VALUES ("JN18_9","073_18_9","JHN","18","9","9","'Bhɛ ya 'ɛ 'yi bhe, ‑e ‑jan 'la ꞊woa 'elwale gban ‑sɔ 'bhɛ 'lɛswa꞊: ‑ya pia‑ dɔɔ: «'Ŋ Dɛ ‑Waanbhaa', 'e mɛɛ 'la zan mu ꞊naa 'ŋ ni ‑o do 'kpɔ 'laa 'nilɛ‑ ‑o ba 'ŋ 'kɔɔ.» ");
INSERT INTO moa_vpl VALUES ("JN18_10","073_18_10","JHN","18","10","10","'Bhɛ klɛle 'tɛ, ‑gɔkuŋ' do 'la 'yaa‑ Simɔ Piɛri 'kɔɔ, 'kee‑ 'bhɛ 'yrole 'bhɛ 'bhoo‑ 'ɛ 'yi, 'bhɛɛ‑ 'kee‑ 'sraka 'lɛna mu ‑kuŋlii gblaan 'ɛ 'bhɛ a yewonɛ 'ɛ gbɛ ‑yiɛ' ta 'trɔn kpukanle 'bhɛ ‑gɔkuŋ' 'ɛ 'le. ‑O ‑yaa 'bhɛ yewonɛ 'ɛ sii Malikusi. ");
INSERT INTO moa_vpl VALUES ("JN18_11","073_18_11","JHN","18","11","11","'Bhɛɛ‑ 'duŋ‑, Zesu pe Simɔ Piɛri ni dɔɔ: «'Yaa‑ ‑gɔkuŋ' 'ɛ 'wla ‑a ‑bhoo 'ɛ 'yi. 'Bhi 'kpee ma, 'ŋ Dɛ ‑Waanbhaa' ‑yrɛn pɛyan‑ do 'la ꞊twa 'ŋ ni 'naa ‑a zi 'bhii‑ 'ŋ 'bhɛ 'mi ɛɛ?» ");
INSERT INTO moa_vpl VALUES ("JN18_12","073_18_12","JHN","18","12","12","'Woo‑ ‑srwase' 'lɛdo‑ 'ɛ 'pegee ‑o ‑lɛɛ mɛɛ gblaan 'ɛ, 'bhɛɛ‑ 'fɛ gooba mu 'la Zuufu mu 'ɛ ‑woo ‑kpaa 'yee‑ Zuda zi ‑srwase' mu 'ɛ ba, 'mu Zesu ꞊kwan, 'bhɛɛ‑ 'ke ‑wa gbɛtabɔle 'ke bhlɛ mu 'le. ");
INSERT INTO moa_vpl VALUES ("JN18_13","073_18_13","JHN","18","13","13","'Bhɛ blaan, 'ke ‑o gele‑ 'kɛle‑ Anasi ba 'pe. 'Yee‑ Anasi‑yaa 'ke Kaifu boogwlɛn 'le. Kaifu ‑le ‑yaa 'ke 'sraka 'lɛna mu 'ɛ ‑waa' ‑kuŋlii gblaan 'ɛ 'le 'bhɛ lɛɛ 'ɛ 'le. ");
INSERT INTO moa_vpl VALUES ("JN18_14","073_18_14","JHN","18","14","14","'Bhɛɛ‑ 'yee‑ Kaifu ‑le Zuufu ‑kuŋlii mu 'ɛ 'liala‑ dɔɔ: «'Ke mɛɛ do 'kpɔ ‑gaa ‑kɔɔa' mɛɛ mu 'ɛ ni, 'bhɛ mabhaa laa bhɔ ‑kɔɔa' mɛɛ mu 'ɛ 'kpɛn gale ta ɛɛ?» ");
INSERT INTO moa_vpl VALUES ("JN18_15","073_18_15","JHN","18","15","15","Simɔ Piɛri 'pegee Zesu a ‑klaŋlanɛ 'ɛ 'bhɛɛke do ‑yaa zan ‑o ‑zanta'. 'Sraka 'lɛna mu 'ɛ ‑waa' ‑kuŋlii gblaan 'ɛ 'yaa‑ Zesu a ‑klaŋlanɛ 'bhɛɛke do 'ɛ dɔ. 'Bhɛla‑ ‑yile, Zesu 'wla bhla 'ɛ zi 'yee‑ 'sraka 'lɛna mu ‑kuŋlii gblaan 'ɛ ‑yaa' ‑gbeŋ 'ɛ 'yi, 'ke 'yee‑ ‑klaŋlanɛ 'ɛ wlale‑ 'bhɛ zi. ");
INSERT INTO moa_vpl VALUES ("JN18_16","073_18_16","JHN","18","16","16","'Duŋ‑ 'yee‑ Simɔ Piɛri 'laa wlalɛ‑ 'yee‑ ‑gbeŋ 'ɛ 'yi, 'bhɛɛ‑ ‑e ꞊bwa 'pɛɛlii‑ ‑gbeŋ 'lii 'ɛ ‑din. 'Bhɛ klɛle 'tɛ, 'sraka 'lɛna mu 'ɛ ‑waa' ‑kuŋlii gblaan 'ɛ 'yaa‑ Zesu a ‑klaŋlanɛ 'bhɛɛke do 'la dɔ, 'ke 'bhɛ 'pwɛle, 'bhɛɛ‑ 'ke 'bhɛ ‑janwole ‑gbeŋ 'ɛ 'liigooba le 'ɛ ni, 'bhɛɛ‑ 'ke 'bhɛ 'yee‑ Piɛri 'wlale ‑gbeŋ 'ɛ 'kpee 'tɛ. ");
INSERT INTO moa_vpl VALUES ("JN18_17","073_18_17","JHN","18","17","17","'Bhɛɛ‑ Piɛri 'wla bhla 'ɛ zi, 'ke ‑gbeŋ 'ɛ 'lii gooba le 'ɛ 'bhɛ 'a 'lrɔkpale dɔɔ: «'Bhi 'laa ‑o 'ke 'yee‑ mɛɛ 'la bhe ‑yaa' ‑klaŋlanɛ mu 'ɛ do 'le ɛɛ?» Piɛri pe ‑a ni dɔɔ: «'Ɔn ɔn, 'mi 'laa ‑o 'ke 'bhɛ 'le 'dɛ!» ");
INSERT INTO moa_vpl VALUES ("JN18_18","073_18_18","JHN","18","18","18","'Bhɛ 'yi 'tɛ, ‑niinii' 'la 'yaa‑ klɛ zi bhe, 'ke 'fɛ 'ɛ ꞊la yewonɛ mu 'ɛ 'pegee 'fɛ 'ɛ gooba mu 'ɛ ‑o 'tɛ do ‑lɛkunle ‑o magaza 'yi 'bhɛ ma. 'Bhɛɛ‑ 'yee‑ Piɛri ꞊nwa ‑a magalɛ 'bhɛ 'tɛ 'ɛ ma 'ezin‑. ");
INSERT INTO moa_vpl VALUES ("JN18_19","073_18_19","JHN","18","19","19","'Sraka 'lɛna mu a ‑kuŋlii gblaan 'ɛ ‑e Zesu 'lrɔkpaa‑ 'bhɛ a ‑klaŋlanɛ mu 'ɛ 'pegee 'bhɛ a mɛɛ daangbɛya 'ɛ ma. ");
INSERT INTO moa_vpl VALUES ("JN18_20","073_18_20","JHN","18","20","20","'Bhɛɛ‑ Zesu 'a 'lɛkwan‑ ‑a ni dɔɔ: «'Mi ‑janwoa mɛɛ mu 'ɛ 'kpɛn 'yrɛ ma kpataakpa. 'Ŋ 'yaa‑ mɛɛ mu 'ɛ daan 'taŋii Zuufu mu 'ɛ ‑waa' daanfɛ' mu 'ɛ 'pegee ‑Waanbhaa' Gba 'Fɛ ‑Gbɛnɛ 'ɛ ꞊la, Zuufu mu 'ɛ 'kpɛn 'yaa‑ ‑o ‑lɛkpa' 'eke‑ ta 'bhɛ mu ‑la nɔɔ‑; 'naa ‑jan 'kedo‑ 'kpɔ wolɛ gaanyi'. ");
INSERT INTO moa_vpl VALUES ("JN18_21","073_18_21","JHN","18","21","21","‑Mɛle ‑kla 'bhɛɛ‑ 'yoo‑ 'ŋ 'lrɔkpa zii' ɛɛ? Mɛɛ 'la zan mu 'ŋ 'wojan‑ mu 'ɛ ꞊maa, 'mu ‑lrɔkpa' doo. 'Mi ‑jan mu 'la ꞊woa, ‑o 'gbu 'mu dɔ.» ");
INSERT INTO moa_vpl VALUES ("JN18_22","073_18_22","JHN","18","22","22","Zesu 'bhɛ ‑jan 'ɛ 'wole‑ 'tɛ, ‑Waanbhaa' Gba 'Fɛ ‑Gbɛnɛ 'ɛ gooba mu 'ɛ do 'la dulale ‑yaa 'yee‑ Zesu ‑din, 'ke 'bhɛ 'a 'trɔn 'wiile, 'bhɛɛ‑ 'ke 'bhɛ 'pele‑ 'a ni dɔɔ: «‑Jan 'lɛkungbɛya 'ɛ ‑glɔɔn 'ɛ ‑dele ‑gee' sraka 'lɛna mu a ‑kuŋlii gblaan 'ɛ ni ɛɛ?» ");
INSERT INTO moa_vpl VALUES ("JN18_23","073_18_23","JHN","18","23","23","'Bhɛ klɛle 'tɛ, 'ke Zesu 'a zikpale ‑a ni dɔɔ: «'Ke 'ŋ ‑jan 'yɔɔ‑ ‑woa 'kɛla 'le 'bhɛ zrɔn 'ŋ ni doo; 'duŋ‑ 'ŋ ‑jan 'la ꞊woa 'saanibhe, 'ke 'bhɛ 'laa ‑o 'ke ‑jan 'yɔɔ‑ 'le, ‑mɛla ma 'bhɛɛ‑ 'yoo‑ 'ŋ zɔn 'zi ɛɛ?» ");
INSERT INTO moa_vpl VALUES ("JN18_24","073_18_24","JHN","18","24","24","'Bhɛ 'yi 'tɛ, 'ke Anasi Zesu gbɛtabɔle 'tole, 'bhɛɛ‑ 'kee‑ gele‑ Zesu 'le 'sraka 'lɛna mu a ‑kuŋlii gblaan Kaifu ba. ");
INSERT INTO moa_vpl VALUES ("JN18_25","073_18_25","JHN","18","25","25","'Bhɛ 'waati 'ɛ ba, Simɔ Piɛri ‑yaa ‑a maga 'zi ‑li 'tɛ 'ɛ ma. 'Bhɛ klɛle 'tɛ, 'ke ‑wa ‑lrɔkpale dɔɔ: «'Bhi 'laa ‑o 'ke 'yee‑ mɛɛ 'la bhe ‑yaa' ‑klaŋlanɛ mu 'ɛ do 'le ɛɛ?» 'Duŋ‑ Piɛri pe ‑o ni dɔɔ: «'Ɔn ɔn, 'naa ‑o 'ke 'bhɛ 'le.» ");
INSERT INTO moa_vpl VALUES ("JN18_26","073_18_26","JHN","18","26","26","'Yee‑ Piɛri 'gwlaan‑ 'la 'trɔn kpukaan, 'bhɛ dɛ ‑nɛ do ‑yaa 'sraka 'lɛna mu ‑kuŋlii gblaan 'ɛ 'bhɛ a yewonɛ mu 'ɛ do 'le. 'Bhɛ yewonɛ 'ɛ Piɛri 'lrɔkpaa‑ dɔɔ: «'Mi 'laa 'ka 'pegee 'yee‑ mɛɛ 'lɛɛ‑ 'yelɛ‑ 'eke‑ 'zi ‑yrigba' 'ɛ 'yi ɛɛ?» ");
INSERT INTO moa_vpl VALUES ("JN18_27","073_18_27","JHN","18","27","27","'Duŋ‑ Piɛri 'a 'lɛmadɔ gbɛ drɛɛwoa‑ 'eglɔɔle dɔɔ yaa Zesu dɔ. 'Bhɛ klɛle 'tɛ, 'ke maagwlɛn ‑wele' 'bhɛ 'waati do 'kpɔ 'ɛ ba. ");
INSERT INTO moa_vpl VALUES ("JN18_28","073_18_28","JHN","18","28","28","'Bhɛ blaan, 'ke ‑o Zesu gole‑ Kaifu ba, 'bhɛɛ‑ 'ke ‑o gele‑ 'kɛle‑ *Romɛ mu a ‑janmatii Pilati ba zrwan 'tutu 'ɛ zi. 'Duŋ‑ Zuufu ‑kuŋlii mu 'ɛ waa wlalɛ Pilati a 'fɛ ‑gbɛnɛ 'ɛ ꞊la; 'kooko‑ ‑o bo 'weŋ, 'bhɛɛ‑ ‑o sɔ 'woo‑ Zuufu mu 'ɛ ‑waa' Paki 'fɛti 'ɛ ta pɛ 'ɛ 'bhlele. ");
INSERT INTO moa_vpl VALUES ("JN18_29","073_18_29","JHN","18","29","29","'Bhɛla‑ ‑zayile, ‑janmatii Pilati 'gbu 'pwɛla‑ ‑a ba 'fɛ 'ɛ ꞊la, 'bhɛɛ‑ ‑e ꞊nwa ‑o ‑lɛpalɛ 'pɛɛlii‑. 'Bhɛɛ‑ 'ke ‑yoo ‑lrɔkpale dɔɔ: «'Ka ‑o ‑la 'zi 'yee‑ mɛɛ 'lɛɛ‑ ta win 'ɛ ‑dela ma ɛɛ?» ");
INSERT INTO moa_vpl VALUES ("JN18_30","073_18_30","JHN","18","30","30","'Bhɛ klɛle 'tɛ, 'ke ‑wa zikpale Pilati ni dɔɔ: «'Ke mɛɛ 'lɛɛ‑ yaa klɛlɛ bi ‑za 'yɔɔ‑ klɛ mi 'le, 'waa ‑yaa nu nulɛ ‑a ‑lɛnalɛ 'e ni.» ");
INSERT INTO moa_vpl VALUES ("JN18_31","073_18_31","JHN","18","31","31","'Bhɛ 'yi 'tɛ, 'ke Pilati 'a 'pele ‑o ni dɔɔ: «'Ka mu 'gbu 'a 'kun, 'bhɛɛ‑ 'ka ge ‑a 'kitikanlɛ 'bhii‑ 'kaa klɛ gɔnɛ‑ 'la gbɛɛn‑ 'kaa‑ 'toŋ mu 'ɛ ta.» 'Bhɛ klɛle 'tɛ, 'ke Zuufu mu 'ɛ ‑wa zikpale Pilati ni 'ezin‑ dɔɔ: «Romɛ mu a 'toŋ mu 'ɛ ta, 'bhɛ 'seŋ 'laa ‑o 'o ni 'ke ‑o mɛɛ dɛ.» ");
INSERT INTO moa_vpl VALUES ("JN18_32","073_18_32","JHN","18","32","32","'Bhɛɛ‑ klɛgbɛya 'ɛ 'yi, Zesu 'yaa‑ nu galɛ gɔnɛ‑ 'la gbɛɛn‑ ‑e 'bhɛ 'lɛɛjanlawoa 'elwale ‑sɔ, 'bhɛ 'lɛswa꞊ 'bhɛɛ‑ gbɛɛn‑ bhe. (‑Amasrɔyi Zuufu mu 'sinii ta za 'ɛ ma waa ‑yaa mɛɛ dɛ ‑yrigbɛɛle do ta, 'duŋ‑ Romɛ mu 'ɛ 'mu ‑le ‑yaa ‑za 'yɔɔ‑ klɛ mu dɛ 'bhɛ gbɛɛn‑.) ");
INSERT INTO moa_vpl VALUES ("JN18_33","073_18_33","JHN","18","33","33","Pilati ꞊wlaa 'ezin‑ ‑yaa' 'fɛ ‑gbɛnɛ 'ɛ ꞊la, 'kee‑ Zesu 'siile, 'bhɛɛ‑ 'kee‑ 'bhɛ 'lrɔkpale dɔɔ: «'Bhi ‑le 'ke Zuufu mu a ‑bhleŋgbe 'le ɛɛ?» ");
INSERT INTO moa_vpl VALUES ("JN18_34","073_18_34","JHN","18","34","34","'Bhɛ klɛle 'tɛ, 'ke Zesu 'a zikpale ‑a ni dɔɔ: «'E 'gbu ‑le 'bhɛ ‑jan 'ɛ ‑dwa 'e 'kpee taa‑ mɛɛ ‑bhɛɛke' mu ‑le 'bhɛ ꞊kpaa 'e 'lii 'mi ba zayi' ɛɛ?» ");
INSERT INTO moa_vpl VALUES ("JN18_35","073_18_35","JHN","18","35","35","'Bhɛ 'yi 'tɛ, 'ke Pilati 'bhɛ zikpale Zesu ni dɔɔ: «'Mi ‑o 'ke Zuufu mi 'le ɛɛ? 'Yaa‑ mɛɛ mu 'ɛ 'pegee 'sraka 'lɛna ‑kuŋlii mu 'ɛ ‑woo 'e 'lɛnaa‑ 'ŋ ni, 'e ‑mɛ pɛ za 'gbu ‑la ‑kla ɛɛ?» ");
INSERT INTO moa_vpl VALUES ("JN18_36","073_18_36","JHN","18","36","36","Zesu 'bhɛ 'lɛkwan‑ ‑a ni dɔɔ: «'An pɛ ‑bhleŋgbeya 'ɛ ‑yaa ‑o 'drunyan 'lɛɛ‑ 'bhɛ 'yi. 'Kee‑ 'kpa bi 'mi a pɛ ‑bhleŋgbeya 'ɛ ‑yoo 'drunyan 'lɛɛ‑ 'bhɛ 'yi, 'mi a pɛ mɛɛ mu 'ɛ 'yaa‑ nu 'ŋ ta gwledanlɛ, 'kooko‑ waa sɔ 'ŋ 'lɛnale Zuufu mu 'ɛ ni. 'Duŋ‑ 'an pɛ ‑bhleŋgbeya 'ɛ yaa ‑o 'trɛ 'lɛɛ‑ 'bhɛ ta ‑gɛ.» ");
INSERT INTO moa_vpl VALUES ("JN18_37","073_18_37","JHN","18","37","37","'Bhɛ klɛle 'tɛ, 'ke Pilati 'a 'pele ‑a ni dɔɔ: «'Bhɛ bhla 'ɛ ba, 'yoo‑ 'ke ‑bhleŋgbe 'le ɛɛ?» Zesu 'bhɛ zikpaa‑ ‑a ni dɔɔ: «'E 'gbu 'yela‑ pe 'zi bhe dɔɔ: ‹'ŋ 'yoo‑ 'ke ‑bhleŋgbe 'le›. ‑Woo' 'ŋ ꞊yaa 'bhɛɛ‑ ma, 'bhɛɛ‑ 'ŋ ꞊nwa 'drunyan 'lɛɛ‑ 'yi 'bhɛɛ‑ ma, 'kooko‑ 'ŋ 'srɛya‑ klɛ wlan 'ɛ ba zayi'. 'Ke mɛɛ 'oo mɛɛ 'la zan ‑o 'ke wlan a pɛ 'le, 'bhɛ zan 'e 'trɔnkpa 'ŋ 'yoo‑ ‑jan 'la 'wo zii' 'bhɛ ꞊la.» ");
INSERT INTO moa_vpl VALUES ("JN18_38","073_18_38","JHN","18","38","38","'Bhɛ 'yi 'tɛ, 'ke Pilati 'a 'lrɔkpale dɔɔ: «‑Mɛle ke wlan 'le ɛɛ?» ‑E yanle‑ 'bhɛ ‑jan 'ɛ 'wolele, 'kee‑ 'pwɛle ‑yaa' 'fɛ 'ɛ ꞊la, 'bhɛɛ‑ 'kee‑ gele‑ Zuufu mu 'ɛ ba ‑yrɛ ta. 'Bhɛɛ‑ 'ke ‑ya pele‑ ‑o ni dɔɔ: «'Naa ‑za 'yɔɔ‑ do 'kpɔ 'yelɛ‑ mɛɛ 'lɛɛ‑ zi 'ke 'bhɛ klɛ ‑a dɛ win 'le. ");
INSERT INTO moa_vpl VALUES ("JN18_39","073_18_39","JHN","18","39","39","'Duŋ‑ 'kaa‑ 'sinii ta za 'ɛ ma, lɛɛ 'oo lɛɛ, 'kaa‑ Paki 'fɛti 'ɛ ta, 'mi ploolawo ‑kaso 'yi mi do ma 'ka ni, 'ka ‑o ‑a zi 'bhii‑ 'ŋ 'ploo‑ Zuufu mu 'ɛ ‑waa' ‑bhleŋgbe 'ɛ ma ɛɛ?» ");
INSERT INTO moa_vpl VALUES ("JN18_40","073_18_40","JHN","18","40","40","'Bhɛ klɛle 'tɛ, 'ke ‑o 'pɛɛn gbɛ drɛɛwole 'ezin‑ 'ke ‑wa pe dɔɔ: «'Ɔn ɔn, 'yaa 'ploolɛ‑ ‑a ma! 'Ploo‑ Barabasi ‑la ma!» 'Bhɛɛ‑ 'duŋ‑ Barabasi ‑yaa 'ke mɛɛ dɛ mi do ‑la ‑le. ");
INSERT INTO moa_vpl VALUES ("JN19_1","073_19_1","JHN","19","1","1","'Bhɛ 'yi 'tɛ, 'ke Pilati 'a 'pele dɔɔ ‑o Zesu 'kun 'bhɛɛ‑ ‑wa zita zɔn 'ke gbaŋbhlɛ 'le. ");
INSERT INTO moa_vpl VALUES ("JN19_2","073_19_2","JHN","19","2","2","‑Srwase' mu 'ɛ ‑o zuŋgblɛ do ꞊taan 'ke lɛrɛ mu 'le, 'bhɛɛ‑ ‑o 'bhɛ ‑dwa Zesu 'wiiŋ‑ 'bhii‑ ‑bhleŋgbe ŋgblo ma 'faa do gbɛɛn‑. 'Bhɛɛ‑ 'ke ‑o dunɛ‑ 'tɛn gbɔɔn do 'klale ‑a ta. ");
INSERT INTO moa_vpl VALUES ("JN19_3","073_19_3","JHN","19","3","3","'Bhɛ blaan, 'ke ‑woo ‑mabɛɛnle 'a ‑din, 'ke ‑wa pele‑ ‑a ni dɔɔ: «Zuufu mu a ‑bhleŋgbe, bhaa 'e bo 'e 'yrɛ ma! Zuufu mu a ‑Bhleŋgbe, bhaa 'e bo 'e 'yrɛ ma!» 'Bhɛɛ‑ ‑o ‑yaa ‑a 'trɔnwii zii'. ");
INSERT INTO moa_vpl VALUES ("JN19_4","073_19_4","JHN","19","4","4","'Bhɛ blaan, Pilati 'pwɛ gbɛ drɛɛwoa‑ 'ezin‑ 'pɛɛlii‑, 'ke ‑ya pele‑ ‑zamaa' 'ɛ ni dɔɔ: «‑Ka 'ka 'yrɛkpa ‑gɛ doo, 'ŋ nu nulɛ 'kɛle‑ 'ka ni 'pɛɛlii‑ ‑gɛ, 'kooko‑ 'kaa 'yaango‑ 'bhii‑ 'naa ‑za 'yɔɔ 'kedo‑ 'kpɔ 'yelɛ‑ ‑a zi 'ke 'bhɛ klɛ ‑a dɛ win 'le.» ");
INSERT INTO moa_vpl VALUES ("JN19_5","073_19_5","JHN","19","5","5","Zesu 'pwɛla‑ 'tɛ 'pɛɛlii‑; lɛlɛ zuŋgblɛ do ‑yaa ‑a ŋgblo ma, 'bhɛ 'pegee ‑bhleŋgbe ta dunɛ‑ 'tɛn gbɔɔn do ‑yaa ‑a ta. 'Bhɛɛ‑ 'ke Pilati 'a 'pele mɛɛ mu 'ɛ ni 'tɛ dɔɔ: «'Kaa‑ mɛɛ 'ɛ 'yele‑ ‑gɛ!» ");
INSERT INTO moa_vpl VALUES ("JN19_6","073_19_6","JHN","19","6","6","'Duŋ‑ 'sraka 'lɛna ‑kuŋlii mu 'ɛ 'pegee ‑Waanbhaa' gba 'Fɛ ‑Gbɛnɛ 'ɛ gooba mu 'ɛ ‑o Zesu 'yele‑, 'ke ‑o 'pɛɛnle 'ke ‑wa pe dɔɔ: «‑A gbaan ‑yrigbɛɛle do ta, 'bhɛɛ‑ ‑e ga! ‑A gbaan ‑yrigbɛɛle do ta, 'bhɛɛ‑ ‑e ga!» 'Bhɛɛ‑ Pilati pe ‑o ni dɔɔ: «'Ka mu 'gbu 'a 'kun, 'bhɛɛ‑ 'ka ge a gbaanlɛ ‑yrigbɛɛle do ta, ‑amasrɔyi, wlan 'ɛ ni, 'mi 'naa ‑za 'yɔɔ‑ do 'kpɔ 'yelɛ‑ ‑a zi 'ke klɛ ‑a dɛ win 'le.» ");
INSERT INTO moa_vpl VALUES ("JN19_7","073_19_7","JHN","19","7","7","'Bhɛ klɛle 'tɛ, 'ke Zuufu ‑kuŋlii mu 'ɛ ‑wa zikpale Pilati ni 'ezin‑ dɔɔ: «'Toŋ do ‑o 'o 'kɔɔ, 'bhɛ 'toŋ 'ɛ ta, ‑yoo 'ke dɛ pɛ 'le, ‑amasrɔyi ‑ya ‑pia ‑a 'gbu ma 'kaa ‑yoo 'ke ‑Waanbhaa' Gbe 'le.» ");
INSERT INTO moa_vpl VALUES ("JN19_8","073_19_8","JHN","19","8","8","Pilati 'bhɛ ‑jan 'ɛ 'male‑, 'ke ‑gblaan baan' 'klale ‑a ‑yi. ");
INSERT INTO moa_vpl VALUES ("JN19_9","073_19_9","JHN","19","9","9","‑E wla gbɛ drɛɛwole ‑yaa' 'fɛ 'ɛ ꞊la, 'bhɛɛ‑ 'kee‑ Zesu 'lrɔkpale 'ezin‑ dɔɔ: «'Bhi da 'naa‑ ‑a ma ɛɛ?» 'Duŋ‑ Zesu 'laa 'bhɛ ‑jan 'ɛ 'lɛkunlɛ ‑a ni. ");
INSERT INTO moa_vpl VALUES ("JN19_10","073_19_10","JHN","19","10","10","'Bhɛ 'yi 'tɛ, 'ke Pilati 'a 'pele Zesu ni dɔɔ: «'Yaa ‑o ‑wele' 'mi ni ɛɛ? 'Yaa 'yaango‑ 'bhii‑ 'bhɛ 'seŋ ‑o 'ŋ ni 'ke 'ŋ ploo 'e ma, 'bhɛɛ‑ 'bhɛ 'seŋ ‑o 'ŋ ni 'ezin‑ 'ke 'an klɛ 'bhɛɛ‑ ‑woo 'e gbaan ‑yrigbɛɛle 'ɛ ta ɛɛ?» ");
INSERT INTO moa_vpl VALUES ("JN19_11","073_19_11","JHN","19","11","11","'Bhɛ klɛle 'tɛ, 'ke Zesu 'bhɛ zikpale ‑a ni dɔɔ: «'Bhɛ 'seŋ do 'kpɔ 'laa ‑yaa nu 'sɔlɛ‑ klɛle‑ 'e ni, 'ke yaa 'e go 'kɛla laanima ‑Waanbhaa' 'bhɛ ꞊naa 'e ni 'bhɛ ba. 'Bhɛla‑ ‑zayile mɛɛ 'la zan 'ŋ ꞊kwan, 'bhɛɛ‑ 'ke 'bhɛ ꞊nwa 'ŋ 'lɛnalɛ 'e ni, 'bhɛ zan a ‑za 'yɔɔ‑ 'ɛ gblaan 'yiya‑ 'ke 'bhɛ kan 'yaa‑ pɛ 'ɛ ta.» ");
INSERT INTO moa_vpl VALUES ("JN19_12","073_19_12","JHN","19","12","12","Pilati 'bhɛ ‑jan 'ɛ 'male 'tɛ, ‑e ‑yaa 'plooyrɛ‑ ‑glin 'zi Zesu ma. 'Duŋ‑ Zuufu mu 'ɛ dɔle 'pɛɛnle‑ ma 'ke ‑wa pele‑ dɔɔ: «'Kee 'ploola‑ mɛɛ 'lɛɛ‑ ma, 'yaa ‑o 'ke ‑bhleŋgbe ‑gbɛnɛ Sezaa 'bhɛgwlɛn‑ 'le. ‑Amasrɔyi 'ke mɛɛ 'oo mɛɛ 'la zan 'a 'gbu klɛ 'zi 'ke ‑bhleŋgbe 'le 'bhɛ zan 'ɛ klɛ ‑bhleŋgbe ‑gbɛnɛ Sezaa ‑sɔɔnnii' ‑la ‑le.» ");
INSERT INTO moa_vpl VALUES ("JN19_13","073_19_13","JHN","19","13","13","Pilati 'bhɛ ‑jan 'ɛ 'male‑ 'tɛ, 'ke ‑ya pele‑ mɛɛ mu 'ɛ ni 'kaa ‑o ge Zesu 'le 'pɛɛlii‑; 'bhɛɛ‑ 'ke 'yee‑ Pilati 'gbu gele‑ yaalɛ yrɛ 'la ‑o ‑yaa 'bhɛ sii Ebre wli 'ɛ 'yi dɔɔ: ‹Gabata›. 'Bhɛ 'yi ‑le 'kitikan mi 'ɛ 'yaakpe‑. ");
INSERT INTO moa_vpl VALUES ("JN19_14","073_19_14","JHN","19","14","14","'Bhɛ ꞊kla Zuufu mu a Paki 'fɛti 'ɛ 'lɛkpa yi 'ɛ ma, ‑yrekpaa' 'waati 'ɛ ba. Pilati pe Zuufu mu 'ɛ ni dɔɔ: «'Kaa‑ ‑bhleŋgbe 'ɛ 'yele‑ ‑gɛ!» ");
INSERT INTO moa_vpl VALUES ("JN19_15","073_19_15","JHN","19","15","15","'Bhɛ klɛle 'tɛ, 'ke ‑o 'pɛɛnle dɔɔ: «‑Yoo 'ke dɛ pɛ 'le! ‑Yoo 'ke dɛ pɛ 'le! ‑A gbaan ‑yrigbɛɛle 'ɛ ta!» Pilati pe ‑o ni dɔɔ: «'Kaa‑ zi 'bhii‑ 'ŋ 'kaa‑ ‑bhleŋgbe 'ɛ gbaan ‑yrigbɛɛle ta ɛɛ?» 'Sraka 'lɛna ‑kuŋlii mu 'ɛ ‑wa zikpaa‑ ‑a ni dɔɔ: «'Waa‑ ‑bhleŋgbe 'bhɛɛke 'laa ‑o ‑bhleŋgbe ‑gbɛnɛ Sezaa blaan.» ");
INSERT INTO moa_vpl VALUES ("JN19_16","073_19_16","JHN","19","16","16","'Bhɛ klɛle 'tɛ, 'ke Pilati Zesu 'kpale ‑o 'kɔɔ, 'kooko‑ ‑srwase' mu 'ɛ ge ‑a gbaan ‑yrigbɛɛle 'ɛ ta. 'Bhɛɛ‑ ‑o Zesu ꞊kwan, 'bhɛɛ‑ ‑o ‑ja ‑a gbaan yrɛ nɔɔ‑ ‑yrigbɛɛle 'ɛ ta. ");
INSERT INTO moa_vpl VALUES ("JN19_17","073_19_17","JHN","19","17","17","‑O ‑yaa nu Zesu 'gbu gbaanlɛ ‑yrigbɛɛle 'la ta, ‑o 'bhɛ 'kwe 'ɛ ‑dwa ‑a 'gbu 'wiiŋ‑. 'Bhɛɛ‑ ‑e ‑gwa Zeruzalɛmu ‑wa 'ɛ 'kpee 'bhɛ 'le, 'kee‑ gele‑ yrɛ 'la ‑o ‑yaa 'bhɛ sii: «Mɛɛ ŋgblo bhɛlɛ' yrɛ» 'bhɛ ꞊nɔɔ, ‑o 'bhɛ sii 'ezin‑ Ebre wli 'ɛ 'yi dɔɔ: «Gɔligota» ");
INSERT INTO moa_vpl VALUES ("JN19_18","073_19_18","JHN","19","18","18","‑O bhɔle 'bhɛ yrɛ 'ɛ ꞊nɔɔ, 'ke ‑srwase' mu 'ɛ ‑o Zesu gbaanle‑ ‑yrigbɛɛle 'ɛ ta. 'Bhɛɛ‑ ‑o mɛɛ ‑bhɛɛke' plɛ ‑gbaanna ‑yrigbɛɛle plɛ ta ‑a ‑din 'ezin‑: ‑a do ‑yaa ‑a gbɛ ‑yiɛ' ta, 'bhɛɛ‑ ‑a ‑vindo' 'ɛ 'yaa‑ ‑a gbɛ ‑koo ta, 'bhɛɛ‑ 'yee‑ Zesu 'gbu 'yaa‑ ‑o pleŋ‑. ");
INSERT INTO moa_vpl VALUES ("JN19_19","073_19_19","JHN","19","19","19","Pilati pe ‑o 'sɛwɛ do yɔɔndɛ ‑yripeenɛ do ta, 'bhɛɛ‑ ‑o 'bhɛ gbaan Zesu trala ‑yrigbɛɛle 'ɛ ta. ‑O ‑za 'la 'bhɛ yɔɔndia‑ 'bhɛ ‑le ‑gɛ: ");
INSERT INTO moa_vpl VALUES ("JN19_20","073_19_20","JHN","19","20","20","Zuufu mu ‑bebe 'bhɛ ‑yripeenɛ 'ɛ ta 'sɛwɛ 'ɛ tapia‑, ‑amasrɔyi ‑o Zesu ‑gbaanna ‑yrigbɛɛle 'ɛ ta yrɛ 'la ꞊nɔɔ, 'bhɛ 'yaa‑ Zeruzalɛmu ‑wa 'ɛ ‑din. ‑O 'yee‑ 'sɛwɛ 'ɛ yɔɔndia‑ wli yaga ‑la ‑yi: Ebre wli, 'bhɛɛ‑ Latɛn wli, 'bhɛ 'pegee Grɛki wli. ");
INSERT INTO moa_vpl VALUES ("JN19_21","073_19_21","JHN","19","21","21","'Bhɛ 'yi 'tɛ, 'ke Zuufu mu a *'sraka 'lɛna ‑kuŋlii mu 'ɛ ‑wa pele‑ Pilati ni dɔɔ: «'Yaa yɔɔndɛle 'tolɛ‑ 'te dɔɔ: ‹Zuufu mu a ‑bhleŋgbe›. ‑A yɔɔndɛ dɔɔ: ‹Mɛɛ 'lɛɛ‑ ‑ya ‑pia dɔɔ: 'Mi ‑le 'ke Zuufu mu a ‑bhleŋgbe 'ɛ 'le.›» ");
INSERT INTO moa_vpl VALUES ("JN19_22","073_19_22","JHN","19","22","22","'Bhɛ klɛle 'tɛ, 'ke Pilati 'a 'lɛkunle ‑o ni dɔɔ: «'Ŋ 'kɛla 'bhɛ yɔɔndia‑ gban 'bhɛ ‑le nu bolɛ.» ");
INSERT INTO moa_vpl VALUES ("JN19_23","073_19_23","JHN","19","23","23","‑Srwase' mu 'ɛ ‑o yanle Zesu gbaanlele ‑yrigbɛɛle 'ɛ ta, 'ke ‑wa tapɛ mu 'ɛ 'sile, 'bhɛɛ‑ 'ke ‑woo ‑yiciɛnle 'eke‑ ma ‑lɛ yiziɛ: ‑srwase' mu 'ɛ 'kpɛn dɔ ‑yaa ‑lɛ do do. ‑Wa ta dunɛ‑ gbɔɔn 'ɛ ꞊sia 'ezin‑; 'Bhɛ dunɛ‑ 'ɛ 'srale‑ ‑yaa 'ke sɔ ‑laa do ‑la ‑le 'kee‑ da laanima, 'kee‑ nu 'tɛnlɛ‑ 'traa. ");
INSERT INTO moa_vpl VALUES ("JN19_24","073_19_24","JHN","19","24","24","'Woo‑ ‑srwase' mu 'ɛ ‑o pe 'eke‑ ni dɔɔ: «‑Kɔɔ' 'laa 'yee‑ dunɛ‑ gbɔɔn 'lɛɛ‑ 'peedɛlɛ, 'duŋ‑ ‑kɔɔ' 'tete dɔ ‑a ta, 'bhɛɛ‑ 'ke mɛɛ la zan 'a ꞊sia ‑e bo 'bhɛɛ‑ zan ni.» 'Bhɛ klɛgbɛya 'ɛ gbɛɛn‑ bhe, ‑jan 'la yɔɔndɛle ‑yaa ‑Waanbhaa' 'sɛwɛ 'ɛ 'yi, 'bhɛ 'la ‑lɛswa꞊, 'bhɛ ‑jan 'ɛ 'yaa‑ dɔɔ: «‑Woo 'ŋ tapɛ mu 'ɛ 'yiciɛnna 'eke‑ ma. 'Bhɛɛ‑ ‑o 'tete ‑dwa 'ŋ ta dunɛ‑ gbɔɔn 'ɛ ta.» ‑Srwase' mu 'ɛ ‑o ‑za 'la ꞊kla 'bhɛ ‑le bhe. ");
INSERT INTO moa_vpl VALUES ("JN19_25","073_19_25","JHN","19","25","25","Le mu 'la dulale ‑yaa ‑o Zesu ‑gbaanna ‑yrigbɛɛle 'la ta 'bhɛ ‑din, 'mu ‑yaa ‑a nɛɛ Mari 'pegee 'bhɛ nɛɛnɛ‑ le, 'bhɛɛ‑ Klopasi 'na Mari, 'bhɛ 'pegee Magidala ‑wa la Mari. ");
INSERT INTO moa_vpl VALUES ("JN19_26","073_19_26","JHN","19","26","26","Zesu 'a nɛɛ ꞊ya, 'bhɛɛ‑ ‑yaa' *‑klaŋlanɛ 'la ‑za ‑yaa sɔ ‑a ni, ‑e 'bhɛ dulale ꞊ya ‑a nɛɛ ‑din. 'Bhɛla‑ ‑yile 'ke ‑ya pele‑ ‑a nɛɛ ni dɔɔ: «'Ŋ nɛɛ, 'e gbe ‑le ‑gɛ.» ");
INSERT INTO moa_vpl VALUES ("JN19_27","073_19_27","JHN","19","27","27","'Bhɛ blaan, 'ke ‑ya pele‑ yaa ‑klaŋlanɛ 'ɛ ni dɔɔ: «'E nɛɛ ‑le ‑gɛ.» ‑A 'san 'bhɛ yi 'ɛ ma, 'bhɛ ‑klaŋlanɛ 'ɛ Zesu nɛɛ ‑kwan 'elrele, 'bhɛɛ‑ ‑ya ꞊kpaa ‑yaa' 'fa ‑la mu 'ɛ ba. ");
INSERT INTO moa_vpl VALUES ("JN19_28","073_19_28","JHN","19","28","28","'Bhɛ blaan, Zesu 'gbu 'a 'yaangole 'bhii‑ ‑za 'ɛ 'kpɛn 'lɛsɔle ‑yaan gban, 'ke ‑ya pele‑ dɔɔ: «‑Yi 'mi ‑lrɔ ‑o 'ŋ dɛ 'zi». ‑E 'bhɛ ꞊pia win 'la ma 'kooko‑ ‑Waanbhaa' 'Sɛwɛ 'ɛ 'yi jan 'ɛ 'lɛsɔ‑. ");
INSERT INTO moa_vpl VALUES ("JN19_29","073_19_29","JHN","19","29","29","'Bhɛ klɛle 'tɛ, gbɔ do dulale ‑yaa 'bhɛ yrɛ 'ɛ ꞊nɔɔ. 'Bhɛ 'pale‑ ‑yaa 'ke ‑drɔɔ 'tɔnle‑ do 'le. ‑Srwase' mu 'ɛ ‑o ‑gblaŋluu' ‑fɔlu' 'fɔlu do ꞊wlaa 'bhɛ ‑drɔɔ yue 'tɔnle 'ɛ ba. 'Ke ‑o 'bhɛ ‑gblaŋluu' 'ɛ 'yrele togɔ do yin 'lii, 'bhɛɛ‑ 'ke ‑o 'bhɛ 'kpale Zesu 'lii 'ɛ ‑din. ");
INSERT INTO moa_vpl VALUES ("JN19_30","073_19_30","JHN","19","30","30","Zesu 'bhɛ ‑drɔɔ yue 'tɔnle‑ 'ɛ danle ‑a nrɛ ma, 'ke ‑ya pele‑ dɔɔ: «‑Za 'kpɛn 'lɛswa꞊!» 'Bhɛ klɛle 'tɛ, ‑ya ŋgblo zinale, 'ke ‑a nii‑ 'ɛ gole‑ ‑a ‑yi. ");
INSERT INTO moa_vpl VALUES ("JN19_31","073_19_31","JHN","19","31","31","'Bhɛ yi 'ɛ 'yaa‑ Zuufu mu a Paki 'fɛti 'ɛ 'lɛkpa yi 'ɛ 'le. 'Bhɛɛ‑ Zuufu ‑kuŋlii mu 'ɛ waa ‑yaa zi 'bhii‑ mɛɛ mu 'la gbaanle ‑o ‑yrigbɛɛle mu 'ɛ ta, ‑yitrɛ' yi 'ɛ 'bhɔ 'mu ma ‑yrigbɛɛle mu 'ɛ ta. ‑Amasrɔyi, 'bhɛ 'taalɛɛyi ‑yitrɛ' yi 'ɛ 'yaa‑ ‑yitrɛ' yi ‑gbɛnɛ 'le. 'Bhɛla ‑zayile ‑yrekpaa' do 'la 'yaa‑ ‑a ‑lɛɛ bhe, Zuufu mu a *'sraka 'lɛna ‑kuŋlii mu 'ɛ ‑ja 'tɛnlɛ‑ Pilati ma, 'bhɛɛ‑ ‑o ‑sromabwa 'bhɛ ni dɔɔ 'bhɛ 'a 'to 'bhɛɛ‑ ‑o ge mɛɛ 'la zan mu gbaanle ‑yaa ‑yrigbɛɛle mu 'ɛ ta 'mu gaan mu 'ɛ 'ciɛn, 'kooko‑ 'mu ga blaale, 'bhɛɛ‑ ‑o 'mu ‑gbaa mu 'ɛ go ‑yrigbɛɛle mu 'ɛ ta. ");
INSERT INTO moa_vpl VALUES ("JN19_32","073_19_32","JHN","19","32","32","'Bhɛ klɛle 'tɛ, 'ke ‑srwase' mu 'ɛ ‑o nule‑, 'bhɛɛ‑ ‑o mɛɛ plɛ 'la 'pegee Zesu ‑gbaanna 'eke‑ zi ‑yrigbɛɛle mu 'ɛ ta, ‑o 'bhɛ do gaan mu 'ɛ 'ciɛnna‑, 'bhɛɛ‑ ‑wa plɛ mi 'ɛ 'bhɛ gaan mu 'ɛ 'ciɛnna‑ 'ezin‑. ");
INSERT INTO moa_vpl VALUES ("JN19_33","073_19_33","JHN","19","33","33","‑O bhɔle Zesu ta, 'ke ‑wa yele‑ 'bhii‑ ‑e ‑gaa gban; 'bhɛla‑ ‑zayile waa gaan mu 'ɛ 'ciɛnlɛ‑. ");
INSERT INTO moa_vpl VALUES ("JN19_34","073_19_34","JHN","19","34","34","'Duŋ‑ ‑srwase' mu 'ɛ do Zesu gbaa 'ɛ ꞊pwan ‑a 'siɛn 'yi 'ke ‑dibhɛ' do 'le. 'Bhɛɛ‑ 'ke ‑yi 'pegee yiɛn 'pwɛle 'bhɛ yrɛ 'ɛ ꞊nɔɔ blaale‑. ");
INSERT INTO moa_vpl VALUES ("JN19_35","073_19_35","JHN","19","35","35","Mɛɛ 'la zan ‑o ‑za mu 'lɛɛ‑ klɛgbɛya 'ɛ 'yikla zii' 'ka 'kɔɔ, ‑yoo klɛyrɛ ꞊ya kpataakpa. 'Bhɛɛ‑ ‑yoo ‑jan 'la 'wo zii' bhe 'bhɛ ‑o 'ke wlan 'le. ‑A 'gbu 'a 'yaango‑ 'bhii‑ ‑yaa' 'srɛya‑ klɛle 'ɛ 'bhɛ ‑o 'ke wlan kpataakpa 'le. ‑E 'bhɛ ‑za mu 'ɛ klɛgbɛya 'ɛ ꞊pia, 'kooko‑ 'ka mu 'ka kpa ‑yaa' 'srɛya‑ klɛle 'ɛ 'yi 'ezin‑. ");
INSERT INTO moa_vpl VALUES ("JN19_36","073_19_36","JHN","19","36","36","Wlan 'ɛ ni, bhɛ ‑za mu 'lɛɛ‑ ꞊kla, 'kooko‑ ‑Waanbhaa' a 'Sɛwɛ 'ɛ 'yi ‑jangɔ' do 'lɛɛ‑ 'bhɛ 'lɛsɔ‑; 'bhɛ ‑jan 'ɛ 'yaa‑ dɔɔ: «Waa nu ‑a bhɛlɛ' mu 'ɛ do 'kpɔ 'ciɛnlɛ‑.» ");
INSERT INTO moa_vpl VALUES ("JN19_37","073_19_37","JHN","19","37","37","'Bhɛɛ‑ ‑a pele ‑o ‑Waanbhaa' a 'Sɛwɛ 'ɛ gɔn do zi 'ezin‑ dɔɔ: «‑O mɛɛ 'la zan ‑pwan ‑a 'siɛn 'yi, ‑o nu ‑o ‑yrɛkpalɛ 'bhɛ zan ta.» ");
INSERT INTO moa_vpl VALUES ("JN19_38","073_19_38","JHN","19","38","38","'Bhɛ blaan, Zozɛfu 'la 'yaa‑ da Arimate ‑wa 'ɛ ta, 'bhɛ ꞊nwa ‑sromabɔlɛ Pilati ni dɔɔ 'bhɛ 'a 'to 'bhɛɛ‑ ‑e Zesu gbaa 'ɛ go ‑yrigbɛɛle 'ɛ ta. 'Yee‑ Zozɛfu 'duŋ‑ ‑yaa 'ke Zesu a ‑klaŋlanɛ mu 'ɛ do 'le gaanyi', ‑amasrɔyi ‑e ‑yaa ‑gblaan Zuufu ‑kuŋlii mu 'ɛ 'yrɛ 'lɛɛ. Pilati ‑dwa 'bhɛ ꞊la. ‑Ayile 'ke 'yee‑ Zozɛfu 'nule Zesu gbaa 'ɛ 'silɛ‑, 'bhɛɛ‑ 'kee‑ gele‑ 'kɛle‑. ");
INSERT INTO moa_vpl VALUES ("JN19_39","073_19_39","JHN","19","39","39","'Bhɛɛ‑ Nikodɛmu 'la ꞊nwa Zesu ba 'elwale ‑sɔ ‑bi do zi, 'bhɛ ꞊nwa 'ezin‑ 'kpalɛ‑ Zozɛfu ba. 'Bhɛ ꞊nwa 'ke 'kilo mia do bhɛ vu ‑lasiklɔɔ ‑gblɛn 'nrale‑ plɛ ‑yizaale 'le 'eke‑ ba: miri 'pegee aloɛsi. ");
INSERT INTO moa_vpl VALUES ("JN19_40","073_19_40","JHN","19","40","40","‑O mɛɛ plɛ Zesu gbaa 'ɛ ꞊sia, 'bhɛɛ‑ ‑o sɔgbɛ 'pu 'peŋpeŋ mu ‑yrela ‑a gbaa 'ɛ ma, 'bhɛ 'pegee ‑o ‑yrɔn ‑gblɛn 'nrale‑ ꞊klaa 'a ta, 'bhii‑ Zuufu mu gbaa bin gɔnɛ‑ 'la gbɛɛn‑ bhe. ");
INSERT INTO moa_vpl VALUES ("JN19_41","073_19_41","JHN","19","41","41","‑O Zesu ‑gbaanna ‑yrigbɛɛle 'ɛ ta yrɛ 'la ꞊nɔɔ, ‑yri gba do ‑yaa 'bhɛ yrɛ 'ɛ ꞊nɔɔ. 'Bhɛɛ‑ mɛɛ bu ‑gluu drɛɛ do ‑yaa 'bhɛ ‑yri gba 'ɛ ꞊la, 'bhɛɛ‑ ‑waa mɛɛ gbaa ‑bhɛɛke' do 'kpɔ binlɛ ‑lido' 'bhɛ 'yi. ");
INSERT INTO moa_vpl VALUES ("JN19_42","073_19_42","JHN","19","42","42","'Bhɛ yi 'ɛ 'yaa‑ Zuufu mu a Paki 'fɛti 'ɛ 'lɛkpa yi 'la 'le bhe, 'bhɛɛ‑ ‑o mɛɛ bu ‑gluu 'la ꞊ya, 'bhɛ 'yaa‑ Zesu gbaanle ‑yaa ‑yrigbɛɛle 'la ta yrɛ 'la ꞊nɔɔ 'bhɛ ‑din. 'Bhɛɛ‑ 'yee‑ Zozɛfu 'pegee Nikodɛmu Zesu gbaa 'ɛ ꞊bian 'bhɛ bu ‑gluu 'ɛ 'yi blaale‑. ");
INSERT INTO moa_vpl VALUES ("JN20_1","073_20_1","JHN","20","1","1","'Kaŋgɔplɛ 'ɛ ma zrwan 'tutu 'ɛ zi, yrɛma ‑yaa 'buŋbuŋ 'waati 'la ba ‑li, 'ke Magidala ‑wa la Mari 'e 'wlɛnle‑, 'bhɛɛ‑ 'kee‑ gele‑ Zesu bu 'ɛ ta. ‑O bu ‑gluu 'ɛ 'liitaan‑ vlɛ ‑kpuŋ 'la 'le, ‑e 'bhɛ gole ꞊ya bu ‑gluu 'ɛ 'lii. ");
INSERT INTO moa_vpl VALUES ("JN20_2","073_20_2","JHN","20","2","2","'Bhɛ klɛle 'tɛ, 'kee‑ blasanle, 'kee‑ gele‑ 'tɛnlɛ‑ Simɔ Piɛri 'pegee Zesu a ‑klaŋlanɛ 'la ‑za ‑yaa sɔ 'yee‑ Zesu 'gbu ni 'bhɛ mu ma, 'bhɛɛ‑ ‑e pe ‑o ni dɔɔ: «‑O Mɛɛzan gbaa 'ɛ ‑gwa ‑a bu ‑gluu 'ɛ 'yi, 'bhɛɛ‑ ‑wa ‑kpaa yrɛ 'la ꞊nɔɔ 'waa 'bhɛ yrɛ 'ɛ dɔ.» ");
INSERT INTO moa_vpl VALUES ("JN20_3","073_20_3","JHN","20","3","3","'Bhɛ yrɛ do 'ɛ ꞊nɔɔ bhe, Simɔ Piɛri 'pegee Zesu a ‑klaŋlanɛ 'bhɛɛke do 'ɛ ‑o 'bhɛ ‑jan 'ɛ 'male‑, 'ke ‑o 'pwɛle, 'bhɛɛ‑ 'ke ‑o gele‑ bu ‑gluu 'ɛ ta. ");
INSERT INTO moa_vpl VALUES ("JN20_4","073_20_4","JHN","20","4","4","‑O mɛɛ plɛ ‑yaa blasan‑ 'zi 'eke‑ zi; 'duŋ‑ Zesu a ‑klaŋlanɛ ‑bhɛɛke' do 'ɛ 'bhɛ blasaan‑ blaale‑ 'ke 'bhɛ kan Piɛri ta. 'Bhɛla ‑zayile 'bhɛ ꞊wlaa bu 'ɛ ta Piɛri 'lɛɛ. ");
INSERT INTO moa_vpl VALUES ("JN20_5","073_20_5","JHN","20","5","5","‑E ‑kulaa', 'ke ‑ya ‑yrɛkpale bu ‑gluu 'ɛ 'yi, 'bhɛɛ‑ 'kee‑ Zesu gbaa 'ɛ ma sɔgbɛ 'pu 'peŋpeŋ mu 'ɛ 'kpaale‑ 'yele‑ 'trɛ ma. 'Duŋ‑ 'yee‑ 'gbu 'laa wlalɛ bu ‑gluu 'ɛ zi. ");
INSERT INTO moa_vpl VALUES ("JN20_6","073_20_6","JHN","20","6","6","'Bhɛ blaan 'waati sa 'kanle‑, 'ke Simɔ Piɛri 'nule; 'ke 'bhɛ 'wlale bu ‑gluu 'ɛ zi. 'Bhɛɛ‑ 'ke 'bhɛ sɔgbɛ 'pu 'peŋpeŋ mu 'ɛ klaale yele‑ 'trɛ ma. ");
INSERT INTO moa_vpl VALUES ("JN20_7","073_20_7","JHN","20","7","7","'Bhɛɛ‑ ‑o sɔ 'la 'yrela‑ Zesu ŋgblo ma Piɛri 'bhɛ ꞊ya 'ezin‑; 'bhɛ sɔ 'ɛ 'bhɛ 'laa ‑yaa sɔgbɛ ‑vin 'ɛ ba, 'duŋ‑ 'bhɛ gbɛkpale ‑yaa 'eke‑ 'yi 'edaŋma. ");
INSERT INTO moa_vpl VALUES ("JN20_8","073_20_8","JHN","20","8","8","'Bhɛ 'yi 'tɛ, Zesu a ‑klaŋlanɛ 'la ꞊bhwa 'elwale bu 'ɛ ta, 'ke 'bhɛ 'wlale bu ‑gluu 'ɛ zi 'tɛ. 'Bhɛ Zesu ma sɔgbɛ mu 'ɛ 'klaale‑ 'la ꞊ya 'bhɛ ꞊nɔɔ, 'ke 'bhɛ 'e 'kpale ‑a ‑yi 'bhii‑ ‑e ‑bwela kpataakpa gale ba. ");
INSERT INTO moa_vpl VALUES ("JN20_9","073_20_9","JHN","20","9","9","‑Amasrɔyi, ‑jan 'la yɔɔndɛle ‑yaa ‑Waanbhaa' a 'Sɛwɛ 'yi dɔɔ ‑a ‑lɛdulale ‑yaa dɔɔ Zesu nu bwelɛ gale ba, ‑yaa' ‑klaŋlanɛ mu 'ɛ waa 'bhɛ ‑jan 'ɛ 'yimalɛ ‑li ‑bi. ");
INSERT INTO moa_vpl VALUES ("JN20_10","073_20_10","JHN","20","10","10","'Bhɛ blaan, 'ke 'yee‑ Zesu a ‑klaŋlanɛ plɛ 'ɛ ‑o nule‑ ‑o ‑zanta' ‑o ba ‑lɛ ma. ");
INSERT INTO moa_vpl VALUES ("JN20_11","073_20_11","JHN","20","11","11","'Bhɛɛ‑ 'duŋ‑, 'bhɛ 'waati 'ɛ ba, Mari dulale ‑yaa 'pɛɛlii‑ Zesu bu 'ɛ ‑din, 'bhɛɛ‑ 'kee‑ wisi. ‑E ‑yaa wisi zii' bhla 'la ba, 'ke ‑ya makulale, 'bhɛɛ‑ 'kee‑ bu ‑gluu 'ɛ 'yiglinle. ");
INSERT INTO moa_vpl VALUES ("JN20_12","073_20_12","JHN","20","12","12","'Bhɛ ꞊nɔɔ bhe, 'kee‑ ‑mlɛkɛ' plɛ yaale yele‑ Zesu gbaa 'ɛ 'kpaale‑ ‑yaa yrɛ 'la ꞊nɔɔ 'bhɛ ꞊nɔɔ. Dunɛ‑ 'pu 'peŋpeŋ mu ‑yaa 'mu ta, 'bhɛɛ‑ ‑a do yaale ‑yaa Zesu ŋgblo 'ɛ 'kpaale‑ ‑yaa yrɛ 'la ꞊nɔɔ 'bhɛ ꞊nɔɔ. 'Bhɛɛ‑ ‑a ‑vindo' 'ɛ 'yaa‑ Zesu gaan mu 'ɛ 'kpaayrɛ‑ 'ɛ ꞊nɔɔ. ");
INSERT INTO moa_vpl VALUES ("JN20_13","073_20_13","JHN","20","13","13","'Bhɛ klɛle 'tɛ, 'ke ‑mlɛkɛ' mu 'ɛ ‑o 'yee‑ Mari 'lrɔkpale dɔɔ: «'Ee le! ‑Mɛle ‑kla 'bhɛɛ‑ 'yoo‑ wisi' zii' ɛɛ?» Mari 'a 'lɛkwan‑ ‑o ni dɔɔ: «‑Woo 'ŋ Zaan gbaa 'ɛ ꞊sia, 'bhɛɛ‑ ‑wa ‑kpaa yrɛ 'la ꞊nɔɔ 'naa 'bhɛ dɔ.» ");
INSERT INTO moa_vpl VALUES ("JN20_14","073_20_14","JHN","20","14","14","‑E yanle 'bhɛ ‑jan 'ɛ 'wolele, ‑ya ‑yrɛkpale ‑a ‑zanta', 'kee‑ Zesu dulale yele‑, 'duŋ‑ yaa 'yaangolɛ 'bhii‑ Zesu ‑le ‑yaa 'kɛle‑. ");
INSERT INTO moa_vpl VALUES ("JN20_15","073_20_15","JHN","20","15","15","'Bhɛ klɛle 'tɛ, 'ke Zesu 'a 'pele 'a ni dɔɔ: «'Ee Le, ‑mɛle ‑kla 'bhɛɛ‑ 'yoo‑ wisi' zii' ɛɛ? 'Yoo‑ ‑dela ‑glin 'zi ɛɛ?» 'Yee‑ Mari 'kpee ma ‑yri gbazan 'ɛ 'bhɛ ‑le ‑yaa 'kɛle‑, 'bhɛla‑ ‑zayile ‑ya ꞊pia ‑a ni dɔɔ: «'Ŋ 'yoo‑ Zesu gbaa 'ɛ 'bhɛɛ‑ ‑glin 'zi. 'Ke 'bhi ‑le 'a ꞊sia, ‑a pe 'ŋ ni, 'bhɛɛ‑ 'ya ꞊kpaa yrɛ 'la ꞊nɔɔ, 'bhɛɛ‑ 'ŋ ge ‑a 'silɛ‑.» ");
INSERT INTO moa_vpl VALUES ("JN20_16","073_20_16","JHN","20","16","16","'Bhɛ 'yi 'tɛ, 'ke Zesu 'a 'pele ‑a ni dɔɔ: «Mari!» Mari 'e 'yrɛkpale ‑a ‑zanta', 'ke ‑ya pele‑ Ebre wli 'ɛ 'yi dɔɔ: «Rabuni!» ('Bhɛ 'yi ‑le dɔɔ: «'O Daan mi.») ");
INSERT INTO moa_vpl VALUES ("JN20_17","073_20_17","JHN","20","17","17","Zesu pe a ni 'ezin‑ dɔɔ: «'Yaa 'yanlɛ‑ 'ŋ ma, ‑amasrɔyi 'naa gelɛ ‑li laanima 'ŋ Dɛ ‑Waanbhaa' ba. 'Bhi 'duŋ‑ ge ‑a pe 'ŋ nɛɛnɛ‑ mu 'ɛ ni dɔɔ 'ŋ ge 'zi laanima 'ŋ Dɛ ‑Waanbhaa' 'la ‑yoo 'ka Dɛ 'le 'ezin‑ bhe 'bhɛ ba; 'bhɛ 'pegee 'mi 'a ‑Waanbhaa' 'la ‑yoo 'kaa‑ ‑Waanbhaa' 'le 'ezin‑ bhe 'bhɛ ba.» ");
INSERT INTO moa_vpl VALUES ("JN20_18","073_20_18","JHN","20","18","18","'Bhɛ klɛle 'tɛ, 'ke Magidala ‑wa la Mari gele‑ ‑a pelɛ Zesu a ‑klaŋlanɛ mu 'ɛ ni dɔɔ: «'Ee! 'Ŋ Mɛɛzan ꞊ya!» 'Bhɛɛ‑ Zesu ‑jan 'la ꞊woa ‑a ni, ‑e 'bhɛ 'yigɔɔnna ‑o ni. ");
INSERT INTO moa_vpl VALUES ("JN20_19","073_20_19","JHN","20","19","19","'Bhɛ 'kaŋgɔplɛ do 'ɛ ma yroma 'ɛ zi, Zesu a ‑klaŋlanɛ mu 'ɛ ‑woo ‑lɛkpaa 'eke‑ ta 'fɛ do ‑la, 'bhɛɛ‑ ‑o 'bhɛ 'fɛ 'ɛ bhɛ ꞊bwa ‑o ta; ‑amasrɔyi ‑o ‑yaa ‑gblaan 'zi Zuufu ‑kuŋlii mu 'ɛ 'lɛɛ. 'Bhɛ klɛle 'tɛ, 'ke Zesu 'nule, 'kee‑ dulale ‑o pleŋ‑, 'bhɛɛ‑ 'ke ‑ya pele‑ ‑o ni dɔɔ: «Bhaa ‑Waanbhaa' yilabla 'na 'ka ni!» ");
INSERT INTO moa_vpl VALUES ("JN20_20","073_20_20","JHN","20","20","20","‑E yanle 'bhɛ ‑jan 'ɛ 'wolele ‑o ni, 'ke ‑ya 'kɔɔlaalii mu 'ɛ 'pegee ‑a 'siɛn 'yi 'ɛ zrɔnle‑ ‑o ni. ‑Ayile, 'ke ‑yaa' ‑klaŋlanɛ mu 'ɛ zrukpaale 'egbɛnɛle ‑o Mɛɛzan 'yelawoa bhe 'bhɛ ‑zayi'. ");
INSERT INTO moa_vpl VALUES ("JN20_21","073_20_21","JHN","20","21","21","Zesu 'a 'pe gbɛ drɛɛwoa‑ ‑o ni dɔɔ: «Bhaa ‑Waanbhaa' yilabla 'na 'ka ni! 'Ŋ Dɛ 'mi 'winbwa‑ gɔnɛ‑ 'la gbɛɛn‑ 'mi ‑o 'ka mu winbɔ 'zi 'ezin‑ 'bhɛ ‑la gbɛɛn‑.» ");
INSERT INTO moa_vpl VALUES ("JN20_22","073_20_22","JHN","20","22","22","‑E yanle 'bhɛ ‑jan 'ɛ 'wolele, 'ke ‑ya ‑lii ‑ploo 'pɛɛnle ‑o ta, 'bhɛɛ‑ 'ke ‑ya pele‑ ‑o ni dɔɔ: «‑Ka Lii 'Weŋ 'ɛ 'srɔɔwo! ");
INSERT INTO moa_vpl VALUES ("JN20_23","073_20_23","JHN","20","23","23","'Ke 'ka mɛɛ 'la zan mu a ‑za 'yɔɔ‑ mu ‑sroma ‑yaan, ‑Waanbhaa' nu 'bhɛ zan mu a ‑za 'yɔɔ‑ mu 'ɛ ma ‑sroma 'yanlɛ‑; 'duŋ‑ 'ke 'ka 'laa dɔlɛ ‑a ‑la 'ke 'ka mɛɛ 'la zan mu a ‑za 'yɔɔ‑ mu ‑sroma yan, ‑Waanbhaa' laa nu 'bhɛ zan mu 'ɛ ‑waa' ‑za 'yɔɔ‑ ‑sroma 'yanlɛ‑ 'ezin‑.» ");
INSERT INTO moa_vpl VALUES ("JN20_24","073_20_24","JHN","20","24","24","'Duŋ‑, Zesu 'pwɛla‑ ‑yaa' ‑klaŋlanɛ mu 'ɛ ba 'waati 'la ba, ‑yaa' ‑klaŋlanɛ vu ta plɛ 'ɛ, ‑o ba mɛɛ do 'la 'ke ‑o ‑yaa 'bhɛ sii Toma, 'bhɛɛ‑ 'ke ‑o 'bhɛ 'tɔkpaa‑ ‹Yonɛ‑›, 'bhɛ 'laa ‑yaa ‑o ba 'bhɛ 'waati 'ɛ ba. ");
INSERT INTO moa_vpl VALUES ("JN20_25","073_20_25","JHN","20","25","25","'Bhɛla‑ ‑zayile, ‑klaŋlanɛ ‑vin mu 'ɛ ‑wa ꞊pia ‑a ni dɔɔ: «'O mɔɔ Mɛɛzan 'ɛ ꞊ya.» 'Duŋ‑ Toma 'a zikpaa‑ ‑o ni dɔɔ: «'Ke 'naa 'pɔnli mu 'ɛ blaan bhɛkpɔɔ mu 'ɛ 'yelɛ‑ ‑a 'kɔɔlaalii mu 'ɛ ꞊nɔɔ, 'bhɛɛ‑ 'ke 'naa 'ŋ gbɛnɛbhɛ do wlalɛ 'bhɛ 'pɔnli mu 'ɛ blaan bhɛkpɔɔ mu 'ɛ 'lii 'pe, 'bhɛ 'pegee 'ke 'naa 'ŋ gbɛ 'kpalɛ‑ ‑a 'siɛn 'yi ‑dibhɛ' blaan kpɔɔ 'ɛ 'lii 'pe, 'naa nu 'ŋ 'kpalɛ‑ 'ka 'wojan‑ 'ɛ 'yi.» ");
INSERT INTO moa_vpl VALUES ("JN20_26","073_20_26","JHN","20","26","26","‑Gbɛɛyi' do 'kanle‑ blaan, Zesu a ‑klaŋlanɛ mu 'ɛ 'klale‑ ‑yaa 'eke‑ ba 'ezin‑ 'fɛ 'ɛ ꞊la, 'bhɛɛ‑ 'gborobhɛ 'ɛ bɔle ‑yaa ‑o ta. 'Bhɛɛ‑ Toma ‑yaa ‑o ba 'taalɛɛyi. 'Bhɛ ya 'ɛ 'yi, 'ke Zesu 'pwɛle ‑a ‑yi, 'kee‑ dulale ‑o pleŋ‑, 'bhɛɛ‑ 'ke ‑ya pele‑ ‑o ni dɔɔ: «Bhaa ‑Waanbhaa' ‑yaa' yilabla 'ɛ 'na 'ka ni!» ");
INSERT INTO moa_vpl VALUES ("JN20_27","073_20_27","JHN","20","27","27","'Bhɛ blaan, 'ke ‑ya pele‑ Toma ni dɔɔ: «Nu 'e gbɛ ‑nɛbhɛ' 'ɛ ꞊zwan 'ŋ 'kɔɔlaalii mu 'ɛ ꞊nɔɔ ‑gɛ, 'bhɛɛ‑ ‑o ‑glin doo; 'bhɛɛ‑ 'e gbɛ 'kpa 'ŋ 'siɛn 'yi yrɛ 'lɛɛ‑ ꞊nɔɔ gɛ doo. 'Yaa 'e 'kpee klɛlɛ plɛ 'mi ma, 'duŋ‑ 'e 'kpa 'mi 'yi!» ");
INSERT INTO moa_vpl VALUES ("JN20_28","073_20_28","JHN","20","28","28","'Bhɛ klɛle 'tɛ, 'ke Toma 'a 'lɛkunle ‑a ni dɔɔ: «'Ee! 'Mi ‑le 'ŋ Zan 'pegee 'an ‑Waanbhaa' 'le!» ");
INSERT INTO moa_vpl VALUES ("JN20_29","073_20_29","JHN","20","29","29","'Bhɛ 'yi, 'ke Zesu 'a zikpale 'a ni dɔɔ: «'E 'mi 'yelawoa, 'bhɛla‑ ‑yile 'yee ꞊kpaa 'mi 'yi ɛɛ? 'Duŋ‑ mɛɛ 'la zan mu laa 'ŋ 'yelɛ‑, 'bhɛɛ‑ ‑woo kpa 'ŋ 'yi bhe, 'bhɛ zan mu a pɛ ‑yinra'!» ");
INSERT INTO moa_vpl VALUES ("JN20_30","073_20_30","JHN","20","30","30","Zesu 'sɔle‑ maza ‑bebe 'bhɛɛke mu ꞊kla 'ezin‑ ‑yaa' ‑klaŋlanɛ mu 'ɛ 'yrɛ ma, 'duŋ‑ 'waa 'mu 'kpɛn 'yigɔɔnlɛ 'yee‑ 'sɛwɛ 'lɛɛ‑ 'yi. ");
INSERT INTO moa_vpl VALUES ("JN20_31","073_20_31","JHN","20","31","31","'Duŋ‑ ‑o ‑za mu 'lɛɛ‑ yɔɔndia‑, 'kooko‑ 'ka 'ka kpa ‑a ‑yi 'bhii‑ Zesu ‑le 'ke Mɛɛ ‑Bhee Mi ‑Kpɔsɔɔ Krisi 'ɛ 'le, 'bhɛ 'pegee 'ka 'ka kpa ‑a ‑yi 'bhii‑ 'yele‑ 'ke *‑Waanbhaa' Gbe 'ɛ 'le. 'Bhɛɛ‑ 'kooko‑ 'ke 'ka 'ka꞊kpaa ‑a 'yi, bole ‑yrɛ ma ‑si 'la ‑daŋ' 'laa ‑o 'bhɛ ma, 'ka 'bhɛ 'srɔɔwo‑ ‑a 'tɔ 'ɛ ‑srɔyi'. ");
INSERT INTO moa_vpl VALUES ("JN21_1","073_21_1","JHN","21","1","1","'Bhɛ blaan 'waati sa, 'ke Zesu 'pwɛle 'ezin‑ ‑yaa' ‑klaŋlanɛ mu 'ɛ ba Tiberiadi ‑draa 'ɛ bhoŋla. ‑E ‑pwɛla ‑o ba gɔnɛ‑ 'lɛɛ‑ 'bhɛɛ‑ gbɛɛn‑: ");
INSERT INTO moa_vpl VALUES ("JN21_2","073_21_2","JHN","21","2","2","Simɔ Piɛri 'pegee Toma (‑o ‑yaa 'bhɛ sii ‑Nɛ Yonɛ‑), 'bhɛɛ‑ Natanaɛli ('bhɛ 'yaa‑ da Kana ‑wa 'ɛ ta, Galile 'klɛɛn 'ɛ 'yi) 'bhɛɛ‑ Zebede gbe plɛ 'ɛ 'bhɛ 'pegee Zesu a ‑klaŋlanɛ 'bhɛɛke plɛ, ‑o 'kpɛn 'klale‑ ‑yaa 'eke‑ ba. ");
INSERT INTO moa_vpl VALUES ("JN21_3","073_21_3","JHN","21","3","3","Simɔ Piɛri pe ‑o ni dɔɔ: «'Ŋ gele‑ kaa dɛyrɛ‑ nɔɔ‑.» 'Bhɛɛ‑ Zesu a ‑klaŋlanɛ ‑vin mu 'ɛ pe a ni dɔɔ: «'O mɔɔ nu gelɛ 'ezin‑ 'e zi.» ‑O ‑ja 'bhɛɛ‑ 'yi 'tɛ, 'ke ‑o 'sanle ‑yitakoŋ 'ɛ 'yi. 'Duŋ‑ waa kaa do 'kpɔ dɛlɛ 'bhɛ ‑bi 'ɛ zi. ");
INSERT INTO moa_vpl VALUES ("JN21_4","073_21_4","JHN","21","4","4","Yrɛma 'kanle‑ ‑saan bhla 'la ba, 'ke Zesu 'pwɛle ‑a ‑yi, 'bhɛɛ‑ 'kee‑ dulale ‑draa 'ɛ bhoŋla. 'Duŋ‑ ‑yaa' ‑klaŋlanɛ mu 'ɛ waa 'yaangolɛ 'bhii‑ 'yele‑ ‑yaa 'kɛle‑. ");
INSERT INTO moa_vpl VALUES ("JN21_5","073_21_5","JHN","21","5","5","'Bhɛ klɛle 'tɛ, 'ke Zesu 'a 'pele ‑o ni dɔɔ: «‑Nɛ ‑zwannɛ mu, 'ka kaa ꞊kwan ɛɛ?» ‑O 'bhɛ zikpaa ‑a ni dɔɔ: «'Ɔn ɔn, 'waa pɛ 'kedo‑ 'kpɔ 'kunlɛ‑.» ");
INSERT INTO moa_vpl VALUES ("JN21_6","073_21_6","JHN","21","6","6","'Bhɛ klɛle 'tɛ, 'ke Zesu 'a 'pele ‑o ni dɔɔ: «‑Ka yrɔ 'ɛ bɔ ‑yitakoŋ 'ɛ gbɛ ‑yiɛ' 'yi, 'bhɛɛ‑ 'ka nu kaa mu 'kunlɛ‑ 'bhɛ ꞊nɔɔ.» ‑O 'bhɛ bɔle 'bhɛ yrɛ 'ɛ ꞊nɔɔ 'tɛ, 'ke 'bhɛ kaa ‑bebe 'kunle, ‑asiikɔɔ ‑a gbiŋ 'ɛ 'kɔɔ, waa ‑yaa 'sɔle ‑a ‑glaanle' ‑yi 'ɛ ba. ");
INSERT INTO moa_vpl VALUES ("JN21_7","073_21_7","JHN","21","7","7","'Bhɛ 'yi 'tɛ, Zesu a ‑klaŋlanɛ 'la ‑za ‑yaa sɔ 'yee‑ Zesu 'gbu ni, 'bhɛ pe Piɛri ni dɔɔ: «Mɛɛzan ‑le 'kɛle‑!» Piɛri 'a 'male‑ 'kaa Mɛɛzan ‑le 'kɛle‑, 'kee‑ yaa dunɛ mu 'ɛ 'klale ‑a ta, ‑amasrɔyi ‑e ‑yaa kaa dɛ zii' bhla 'la ba, ‑a tafleŋ‑ ‑le ‑yaa. 'Bhɛɛ‑ 'kee‑ bɔle‑ ‑yi 'ɛ ba, 'kee‑ gele‑ Zesu ba ‑yrɛ ta. ");
INSERT INTO moa_vpl VALUES ("JN21_8","073_21_8","JHN","21","8","8","Zesu a ‑klaŋlanɛ ‑vin mu 'ɛ ‑nwa ‑yi 'ɛ bhoŋla ‑yitakoŋ 'ɛ 'yi. 'Bhɛɛ‑ ‑o yrɔ 'ɛ ‑glaanna, ‑a 'pale‑ ‑yaa 'ke kaa mu 'ɛ 'le. ‑Amasrɔyi ‑o pleŋgole laa ‑yaa ‑draa 'ɛ bhoŋla 'ɛ ma mɛtrɛ ‑kɛmɛ do yɛkɛ‑ 'yi. ");
INSERT INTO moa_vpl VALUES ("JN21_9","073_21_9","JHN","21","9","9","‑O bhɔle 'trɛ ma, 'ke ‑o 'tɛ do ‑lɛkunle yele‑, 'bhɛɛ‑ kaa 'pegee 'bluu 'yaa‑ 'bhɛ 'tɛ 'ɛ ta. ");
INSERT INTO moa_vpl VALUES ("JN21_10","073_21_10","JHN","21","10","10","Zesu pe ‑o ni dɔɔ: «'Ka kaa mu 'la ꞊kwan bhe, ‑ka nu 'a 'ke 'le ‑gɛ.» ");
INSERT INTO moa_vpl VALUES ("JN21_11","073_21_11","JHN","21","11","11","'Bhɛ klɛle 'tɛ, 'ke Simɔ Piɛri 'sanle ‑yitakoŋ 'ɛ 'yi, 'bhɛɛ‑ 'kee‑ yrɔ 'ɛ ‑glaanle' 'trɛ ma, ‑a 'pale‑ ‑yaa 'ke kaa ‑gbɛnɛ ‑gbɛnɛ mu 'le: ‑o ‑yaa kaa bhɛ ‑kɛmɛ do 'ke 'kaa bhɛ mia plɛ bhɛ vu ta yaga (153). 'Ali‑ 'woo‑ kaa mu 'ɛ ‑o ‑bebeya 'ɛ ma, kaadɛ yrɔ 'ɛ yaa 'peedɛlɛ. ");
INSERT INTO moa_vpl VALUES ("JN21_12","073_21_12","JHN","21","12","12","Zesu pe ‑o ni dɔɔ: «‑Ka nu pɛbhle.» 'Duŋ‑ ‑yaa' ‑klaŋlanɛ mu 'ɛ do 'kpɔ 'laa ‑yaa sɔ ‑a ‑lrɔkpale dɔɔ: «‑Dele 'e 'le ɛɛ?» ‑Amasrɔyi ‑o 'gbu 'yaa‑ 'yaango‑ 'bhii‑ Mɛɛzan ‑le 'kɛle‑. ");
INSERT INTO moa_vpl VALUES ("JN21_13","073_21_13","JHN","21","13","13","‑Ayile, 'ke Zesu 'e 'mabɛɛnle ‑o ‑din, 'kee‑ 'bluu 'ɛ 'sile, 'kee‑ 'bhɛ 'yiciɛnle ‑o ma. 'Bhɛɛ‑ 'kee‑ 'kaa ‑yiciɛnle 'ezin‑ ‑o ma. ");
INSERT INTO moa_vpl VALUES ("JN21_14","073_21_14","JHN","21","14","14","‑A 'san Zesu bwe gale ba, ‑a 'pwɛ gbɛ ‑glɔɔn yaga mi ‑le ‑yaa 'bhɛ 'le bhe ‑yaa' ‑klaŋlanɛ mu 'ɛ ba. ");
INSERT INTO moa_vpl VALUES ("JN21_15","073_21_15","JHN","21","15","15","‑O yanle pɛbhlelele, 'ke Zesu Simɔ Piɛri 'lrɔkpale dɔɔ: «Zaan gbe Simɔ, 'ŋ ‑za sɔ 'e ni 'ke 'bhɛ kan 'ŋ ‑za sɔ mɛɛ mu 'lɛɛ‑ ni gɔnɛ‑ 'la gbɛɛn‑ 'bhɛ ta ɛɛ?» 'Yee‑ Simɔ 'bhɛ zikpaa Zesu ni dɔɔ: «‑Aani' Mɛɛzan, 'e 'gbu 'a 'yaango‑ 'bhii‑ 'e ‑za sɔ 'ŋ ni.» 'Bhɛɛ‑ Zesu pe ‑a ni dɔɔ: «'An ‑bhlaa gwlɛn bhlonɛ‑ mu 'ɛ 'lɛbɔ‑.» ");
INSERT INTO moa_vpl VALUES ("JN21_16","073_21_16","JHN","21","16","16","'Bhɛ blaan, 'ke Zesu 'a 'lrɔkpa gbɛ plɛ mi wole‑ 'ezin‑ dɔɔ: «Zaan gbe Simɔ, 'ŋ ‑za sɔ 'e ni ɛɛ?» Piɛri ‑a 'lɛkwan ‑a ni 'ezin‑ dɔɔ: «‑Aani' Mɛɛzan, 'e 'gbu 'a 'yaango‑ 'bhii‑ 'e ‑za sɔ 'ŋ ni.» 'Bhɛɛ‑ Zesu pe ‑a ni dɔɔ: «Klɛ 'an ‑bhlaa mu 'ɛ tagbin mi 'le.» ");
INSERT INTO moa_vpl VALUES ("JN21_17","073_21_17","JHN","21","17","17","'Bhɛ blaan 'ezin‑, 'kee‑ Piɛri 'lrɔkpa gbɛ yaga mi wole‑ dɔɔ: «Zaan gbe Simɔ, 'ŋ ‑za sɔ 'e ni ɛɛ?» 'Bhɛ klɛle 'tɛ, 'ke Piɛri 'a wlɛyisriwole, ‑amasrɔyi Zesu 'a 'lrɔkpaa gaan yaga dɔɔ: «'Ŋ ‑za sɔ 'e ni ɛɛ?» ‑Ayile 'ke ‑ya pele‑ Zesu ni dɔɔ: «Mɛɛzan, 'e ‑za 'kpɛnsee dɔ, 'e 'gbu 'a 'yaango‑ 'bhii‑ 'e ‑za sɔ 'ŋ ni!» 'Bhɛɛ‑ Zesu pe ‑a ni 'bhɛɛ‑ 'yi 'tɛ dɔɔ: «'An ‑bhlaa mu 'ɛ ‑o 'lɛbɔ‑. ");
INSERT INTO moa_vpl VALUES ("JN21_18","073_21_18","JHN","21","18","18","'Mi pe 'e ni 'ŋ 'sɔwɛɛ ma dɔɔ 'e 'yaa‑ 'waati 'la ba ‑zwannɛ 'le, 'e 'yaa‑ dunɛ‑ kla 'e 'gbu ta, 'bhɛɛ‑ 'e 'sɛntru dɔ 'e 'gbu 'saanla, 'bhɛɛ‑ 'ke gele ‑yaa sɔ 'e ni yrɛ 'la ꞊nɔɔ, 'e 'yaa‑ ge 'bhɛɛ‑ ꞊nɔɔ. 'Duŋ‑ 'kee 'krɔyawoa 'waati 'la ba, 'e nu 'e gbɛ 'trolɛ‑ mɛɛ ‑bhɛɛke' ‑la ba, 'bhɛ nu dunɛ‑ 'klalɛ‑ 'e ta, 'bhɛɛ‑ 'bhɛ nu 'sɛntru dɔlɛ 'e 'saanla꞊. 'Yaa‑ zi 'bhii‑ ‑e ge yrɛ 'la ꞊nɔɔ 'bhɛ nu gelɛ 'e 'le 'bhɛɛ‑ ꞊nɔɔ.» ");
INSERT INTO moa_vpl VALUES ("JN21_19","073_21_19","JHN","21","19","19","Piɛri ‑yaa nu galɛ gagbɛya 'la 'yi, 'bhɛɛ‑ ‑e ‑Waanbhaa' 'tɔbhɔ‑, Zesu 'bhɛɛ‑ ‑zrɔnna ‑a ni ‑gɔɔn 'yi jan 'la bhe 'bhɛɛ‑ wolele. 'Bhɛ blaan, 'ke Zesu 'a pele Piɛri ni dɔɔ: «Dɔ 'ŋ zi!» ");
INSERT INTO moa_vpl VALUES ("JN21_20","073_21_20","JHN","21","20","20","Piɛri 'e 'yrɛkpale ‑a ‑zanta', 'kee Zesu a ‑klaŋlanɛ 'la ‑za ‑yaa sɔ Zesu 'gbu ni 'bhɛ 'yele 'ke 'bhɛ ‑o zan ‑o zi. 'Bhɛ ‑klaŋlanɛ 'ɛ 'bhɛ ‑le 'bhɛ makulaa Zesu ba ‑yrɛ ta pɛbhle 'waati 'ɛ ba ‑bi do zi, 'bhɛɛ‑ 'bhɛ ‑le Zesu 'lrɔkpaa‑ dɔɔ: «Mɛɛzan, ‑de 'gbu ‑le nu ‑dawli' 'kpalɛ‑ 'e gbɛ ta ɛɛ?» ");
INSERT INTO moa_vpl VALUES ("JN21_21","073_21_21","JHN","21","21","21","Piɛri 'bhɛ ‑klaŋlanɛ 'ɛ 'yele‑ 'kee‑ Zesu 'lrɔkpale dɔɔ: «'Bhɛɛ‑ mɛɛ 'lɛɛ‑ 'lɛɛ, Mɛɛzan, ‑mɛ pɛ za ‑le nu klɛlɛ 'bhɛ ni ɛɛ?» ");
INSERT INTO moa_vpl VALUES ("JN21_22","073_21_22","JHN","21","22","22","'Bhɛ klɛle 'tɛ, 'ke Zesu 'bhɛ zikpale ‑a ni dɔɔ: «'Ke 'mi ‑a zi 'bhii‑ ‑e bo ‑a ‑yrɛ ma, 'sani‑ 'ke 'bhɛ ge 'tɛnlɛ‑ 'ŋ 'nu 'yi 'ɛ ma, 'yaa‑ ‑mɛ pɛ za ‑le 'bhɛ 'yi ɛɛ? 'Bhi, 'bhi dɔ 'ŋ zi drɔŋ!» ");
INSERT INTO moa_vpl VALUES ("JN21_23","073_21_23","JHN","21","23","23","‑O 'bhɛɛ‑ ‑jan 'ɛ 'wole‑ 'ɛ ꞊zian ‑o nɛɛnɛ‑ Zesu 'yi mu 'ɛ 'pleŋ‑ dɔɔ 'bhɛ ‑klaŋlanɛ 'ɛ 'bhɛ 'laa ‑yaa nu galɛ. 'Bhɛɛ‑ 'duŋ‑, Zesu 'laa 'pelɛ‑ Piɛri ni dɔɔ: «Yaa nu galɛ». ‑Ya ꞊pia ‑a ni dɔɔ: «'Ke 'mi ‑a zi 'bhii‑ ‑e bo ‑a ‑yrɛ ma, 'sani‑ 'ke 'bhɛ ge 'tɛnlɛ‑ 'ŋ nu 'yi 'ɛ ma, 'yaa‑ ‑mɛ pɛ za ‑le 'bhɛ 'yi ɛɛ?» ");
INSERT INTO moa_vpl VALUES ("JN21_24","073_21_24","JHN","21","24","24","'Bhɛ ‑klaŋlanɛ do 'kpɔ 'ɛ 'bhɛ ‑le 'srɛya‑ klɛ 'zi ‑za mu 'lɛɛ‑ ba zayi'. 'Yele‑ ‑za mu 'lɛɛ‑ yɔɔndia‑ 'ezin‑. 'Bhɛɛ‑ 'o mɔɔ 'gbu 'a 'yaango‑ 'bhii‑ ‑yaa' 'srɛya‑ klɛle 'ɛ ‑yoo 'ke wlan 'le. ");
INSERT INTO moa_vpl VALUES ("JN21_25","073_21_25","JHN","21","25","25","Zesu ‑za 'bhɛɛke ‑bebe ꞊kla. 'Kee 'kpa bi ‑woo 'kpɛn yɔɔndɛ do do, 'mi 'kpee ma, 'bhɛ 'sɛwɛ mu 'ɛ ‑waa ‑yaa nu 'sɔlɛ‑ 'drunyan 'lɛɛ‑ 'yi.");
INSERT INTO moa_vpl VALUES ("AC1_1","074_1_1","ACT","1","1","1","'Mi Luki, 'mi ‑le 'sɛwɛ 'lɛɛ‑ dɛ 'zi 'bhi 'ŋ nɛɛnɛ‑ Teofili ni. Zesu ‑za mu 'la ꞊kla, 'bhɛ 'pegee ‑e mɛɛ mu ‑daanna ‑za mu 'la 'le, 'ŋ 'mu 'kpɛn 'yigɔɔnna 'e ni 'an 'sɛwɛ ꞊lwa mi 'ɛ 'yi, 'ke 'an san ‑e ‑yaa' ye 'ɛ zisaan‑ 'waati 'la ba 'bhɛ ma, ");
INSERT INTO moa_vpl VALUES ("AC1_2","074_1_2","ACT","1","2","2","'bhɛɛ‑ 'kee‑ nu 'tɛnlɛ‑ ‑Waanbhaa' 'a ꞊sia laflɛ' 'ɛ 'yi yi 'la 'le 'bhɛ ma. 'Duŋ‑ 'sani‑ ‑a gele pleŋ‑ laflɛ' 'ɛ 'yi, ‑e mɛɛ 'la zan mu makwan‑ 'bhii‑ ‑yaa' pɛ winbɔwo mu, ‑e ‑yaa zi 'bhii‑ 'mu ‑za mu 'la dɔ, ‑e 'mu ‑daanna 'mu 'le. ");
INSERT INTO moa_vpl VALUES ("AC1_3","074_1_3","ACT","1","3","3","‑A gale 'pegee ‑a bwele gale ba 'ɛ blaan, ‑ya 'gbu ‑zrɔnna 'mu ni zrɔn gbɛya ‑bebe 'yi 'bhii‑ ‑ya ‑yrɛ ma kpataakpa. ‑Amasrɔyi ‑e ‑pwɛla 'mu ba ‑yrekpaa' mia plɛ ꞊la, 'kee‑ ‑Waanbhaa' a ‑bhleŋgbeya ‑wa 'ɛ ma ‑jan 'ɛ wo 'mu ni. ");
INSERT INTO moa_vpl VALUES ("AC1_4","074_1_4","ACT","1","4","4","'Bhɛ 'yi 'tɛ, 'yee‑ Zesu 'pegee ‑yaa' ‑klaŋlanɛ mu 'ɛ 'yaa‑ pɛbhle 'zi 'eke‑ zi ‑yrekpaa' do, 'bhɛɛ‑ ‑e pe ‑o ni dɔɔ: «'Ka 'laa 'ka 'pleŋgolɛ Zeruzalɛmu ‑wa 'ɛ ma; pɛ 'la 'ke 'ŋ Dɛ 'a 'liiwli‑ ꞊naa 'bhɛ 'na zayi' 'ka ni bhe, 'bhɛɛ‑ 'ke 'mi 'bhɛɛ‑ baan' ꞊pia 'ezin‑ 'ka ni; ‑ka 'bhɛ pɛ 'ɛ magbɛn a ꞊nɔɔ ye. ");
INSERT INTO moa_vpl VALUES ("AC1_5","074_1_5","ACT","1","5","5","‑Amasrɔyi Mɛɛ Wiiŋfɛ' Mi Zaan mɛɛ mu 'wiiŋfia꞊ 'ke ‑yi 'le, 'duŋ‑ ‑a ‑vinbwa ‑yrekpaa' 'dama 'bhɛɛ‑ ‑Waanbhaa' nu 'ka mu 'palɛ‑ 'ke Lii 'Weŋ 'ɛ 'le.» ");
INSERT INTO moa_vpl VALUES ("AC1_6","074_1_6","ACT","1","6","6","Zesu a 'winbɔwo mu 'ɛ 'klale‑ ‑yaa 'eke‑ ba 'ezin‑, 'ke ‑wa ‑lrɔkpale dɔɔ: «Mɛɛzan, 'e nu ‑bhleŋgbe do 'kpa gbɛ drɛɛwolɛ Izraɛli mu 'ɛ 'wiiŋ‑ 'bhɛɛ‑ 'waati 'ɛ ba ɛɛ?» (‑O Zesu 'lrɔkpaa 'bhɛ gbɛɛn‑ bhe, ‑amasrɔyi *Romɛ mu ‑le ‑yaa Izraɛli mu 'ɛ 'wiiŋ‑ 'bhɛ 'waati 'ɛ ba.) ");
INSERT INTO moa_vpl VALUES ("AC1_7","074_1_7","ACT","1","7","7","Zesu pe ‑o ni dɔɔ: «'Ŋ Dɛ 'woo‑ za mu 'lɛɛ‑ klɛ 'waati mu 'la 'lɛdulaa, 'ka mu maza laa ‑o 'mu dɔle ma. ");
INSERT INTO moa_vpl VALUES ("AC1_8","074_1_8","ACT","1","8","8","'Duŋ‑ ‑Waanbhaa' nu 'ka 'palɛ‑ 'ke Lii 'Weŋ 'ɛ 'le, 'bhɛɛ‑ 'ka mu nu ‑yaa' ‑glɔɔya' 'ɛ 'srɔɔwolɛ. 'Ke 'bhɛ ꞊kla, 'ka nu klɛlɛ 'ŋ 'srɛ 'le 'ke 'ka 'mi ba janwo Zeruzalɛmu ‑wa 'ɛ 'pegee Zude, 'bhɛɛ‑ Samari 'klɛɛn mu 'ɛ 'yi, 'ke 'bhɛ ge 'tɛnlɛ‑ 'drunyan ‑daŋ' mu 'ɛ 'kpɛn ma.» ");
INSERT INTO moa_vpl VALUES ("AC1_9","074_1_9","ACT","1","9","9","Zesu 'yanle‑ 'bhɛ ‑jan mu 'ɛ 'wolele, 'kee‑ ‑wlɛnle' laanima ‑yaa' ‑klaŋlanɛ mu 'ɛ trala, 'kee‑ ge laflɛ' ba ‑yrɛ ta; 'bhɛɛ‑ 'mu 'yrɛ ꞊yaa ‑a zi ‑a ge bhla 'ɛ zi; 'ke laflɛ' ‑gblɛn 'pu do 'kpale ‑a ta, 'bhɛɛ‑ 'ke 'bhɛ 'a 'nile 'mu ‑yrɛ ba. ");
INSERT INTO moa_vpl VALUES ("AC1_10","074_1_10","ACT","1","10","10","‑O ‑yrɛ ‑yaa ‑a zi ‑li 'waati 'la ba, 'ke mɛɛ plɛ 'pwɛle ‑o ba 'bhɛ yrɛ do 'ɛ꞊nɔɔ bhe: dunɛ‑ 'pu mu ‑yaa 'mu ta. ");
INSERT INTO moa_vpl VALUES ("AC1_11","074_1_11","ACT","1","11","11","'Bhɛ mɛɛ plɛ 'ɛ pe ‑o ni 'tɛ dɔɔ: «Galile mu, ‑mɛle ꞊kla 'bhɛɛ‑ 'ka dulale ‑o 'ke 'ka 'ka 'yrɛkpa laanima ɛɛ? 'Ka 'yee‑ Zesu do 'kpɔ 'la ꞊ya 'ka pleŋ‑ ‑gɛ, 'bhɛɛ‑ ‑e ‑ja laflɛ' 'yi gɔnɛ‑ 'la gbɛɛn‑ bhe, ‑e nu nu gbɛ drɛɛwolɛ 'yee‑ gɔnɛ‑ do 'kpɔ 'ɛ 'yela‑ gbɛɛn‑ 'ezin‑.» ");
INSERT INTO moa_vpl VALUES ("AC1_12","074_1_12","ACT","1","12","12","'Bhɛ 'yi 'tɛ, 'ke ‑yaa' winbɔwo mu 'ɛ gole‑ OLivi diiŋ vlɛ gɔɔn 'ɛ 'wiiŋ‑, 'bhɛɛ‑ 'ke ‑o nule‑ Zeruzalɛmu ba ‑yrɛ ta. 'Bhɛ gɔɔn 'ɛ 'yaa‑ Zeruzalɛmu ‑wa 'ɛ ma kilo do. ");
INSERT INTO moa_vpl VALUES ("AC1_13","074_1_13","ACT","1","13","13","‑O bhɔle Zeruzalɛmu, 'ke ‑o gele‑ 'saŋgaso 'kpee 'la ‑o ‑yaa kla 'eke‑ ba 'taŋii 'bhɛ ꞊la 'bhɛɛ‑ ꞊la. Mɛɛ 'la zan mu 'klale‑ ‑yaa 'eke‑ ba 'mu 'tɔ ‑le ‑gɛ: Piɛri 'pegee Zaan 'bhɛɛ‑ Zaki, Andre pegee Filipu 'bhɛɛ‑ Toma, Batremi 'pegee Matie, 'bhɛɛ‑ Alife gbe Zaki 'pegee Simɔ 'la 'yaa‑ 'bhɛ a 'klɛɛn 'ɛ ‑vavadɛ, 'bhɛɛ‑ Zaki gbe Zudi. ");
INSERT INTO moa_vpl VALUES ("AC1_14","074_1_14","ACT","1","14","14","‑O 'kpɛn 'kpale‑ ‑yaa do ma, 'bhɛɛ‑ ‑o bole ‑yaa ‑o seriwole ma ‑Waanbhaa' ni ‑o 'pegee le 'ke mu 'le. Zesu nɛɛ Mari 'pegee ‑a nɛɛnɛ‑ mu 'ɛ 'yaa‑ ‑o ba. ");
INSERT INTO moa_vpl VALUES ("AC1_15","074_1_15","ACT","1","15","15","'Yee‑ yi mu 'ɛ do 'le, ‑o ꞊klaa 'eke‑ ba, 'bhɛɛ‑ ‑o ‑yaa bhɔ mɛɛ ‑kɛmɛ do 'ke mɛɛ mia do ‑din. 'Bhɛɛ‑ Piɛri 'e 'wlɛnle‑ ‑o pleŋ‑ 'ke ‑ya pele‑ ‑o ni dɔɔ: ");
INSERT INTO moa_vpl VALUES ("AC1_16","074_1_16","ACT","1","16","16","«‑A ‑lɛdulale ‑yaa 'ke *Lii 'Weŋ 'ɛ ‑jan 'la ꞊kpaa *Davidi 'lii ‑Waanbhaa' a 'Sɛwɛ 'ɛ 'yi 'bhɛ 'lɛsɔ‑. ‑Ayile, Zuda 'yaa‑ nu dɔlɛ Zesu 'kun mu 'ɛ 'lɛɛ gɔnɛ‑ 'la gbɛɛn‑, 'yee‑ Davidi 'bhɛ 'lɛɛjanwoa 'elwale ‑sɔ. ");
INSERT INTO moa_vpl VALUES ("AC1_17","074_1_17","ACT","1","17","17","Zuda ‑yaa ‑kɔɔ' mɛɛ ‑lɛdo 'lɛɛ‑ ba mɛɛ 'ɛ do 'le, 'bhɛɛ‑ ‑a dɔ ‑yaa ‑kɔɔ' 'kpɛn 'woye‑ do 'kpɔ 'ɛ ba. ");
INSERT INTO moa_vpl VALUES ("AC1_18","074_1_18","ACT","1","18","18","'Bhɛɛ‑ ‑o yaa mɛɛ dɛ ma ‑gɔli' 'la gbawoa‑ ‑a ni, ‑e ‑ja gba do lɔlɛ 'bhɛ ‑gɔli' 'ɛ 'le. 'Bhɛ blaan 'kee‑ gele‑ ‑a 'gbu duŋlɛ 'bhɛ gba 'ɛ 'yi ‑yri diiŋ 'ɛ do 'yi, 'bhɛɛ‑ 'kee‑ baale' 'trɛ ma ‑a bhlɔ ta. 'Ke ‑a vi 'ɛ 'pɔnle, 'bhɛɛ‑ ‑a gbɔŋbhlɛ mu 'ɛ 'pwɛla‑ ‑a kpɛ ta, 'kee‑ gale‑. ");
INSERT INTO moa_vpl VALUES ("AC1_19","074_1_19","ACT","1","19","19","Zeruzalɛmu ‑wa 'ɛ ta mu 'ɛ 'kpɛn 'bhɛ ‑za 'ɛ dɔ. 'Bhɛla‑ ‑zayile ‑o 'yee‑ gba 'ɛ 'tɔkpaa‑ ‑waa' wli 'ɛ 'yi dɔɔ: ‹Akɛlidama›. 'Bhɛ 'yi ‑le dɔɔ: ‹mɛɛ yiɛn ma gba›. ");
INSERT INTO moa_vpl VALUES ("AC1_20","074_1_20","ACT","1","20","20","'Duŋ‑ ‑jan 'lɛɛ‑ 'bhɛɛ‑ yɔɔndɛle ‑yaa ‑a ba zayi' ‑Waanbhaa a 'Srokpa 'sɛwɛ 'ɛ 'yi dɔɔ: ‹Bhaa yaa 'fɛ 'ɛ ꞊la 'fleŋbo, 'bhɛɛ‑ mɛɛ 'kedo‑ 'kpɔ 'laa bolɛ 'bhɛ ꞊la 'ezin‑ ‑titi.› 'Bhɛɛ‑ ‑wa yɔɔndia‑ 'ezin‑ 'yee‑ 'sɛwɛ 'ɛ 'yi yrɛ do ꞊nɔɔ dɔɔ: ‹Bhaa mɛɛ ‑bhɛɛke' do zɛn ‑a blaanta.› ");
INSERT INTO moa_vpl VALUES ("AC1_21","074_1_21","ACT","1","21","22","‑Kɔɔ' mɛɛ do makun', 'bhɛɛ‑ 'kɔɔ 'bhɛ kpa ‑kɔɔ' ba, 'kooko‑ ‑kɔɔ' klɛ Mɛɛzan Zesu bweza 'ɛ gale ba 'bhɛ 'srɛ 'le. 'Duŋ‑ 'bhɛ zan 'ɛ klɛ mɛɛ mu 'la ‑kɔɔ' 'pegee 'mu 'yaa‑ kanaa' 'eke‑ zi 'klɛɛn 'ɛ 'yi 'waati 'ɛ 'kpɛn ba, 'bhɛɛ do 'le; 'kee‑ san Mɛɛ Wiiŋfɛ' Mi Zaan Mɛɛzan Zesu 'pegee mɛɛ 'ke mu 'wiiŋfia꞊ ‑yi ba 'waati 'la ba, 'bhɛɛ‑ 'kee‑ nu 'tɛnlɛ‑ ‑Waanbhaa' 'a ꞊sia ‑kɔɔ' 'pleŋ ‑gɛ yi 'la ma, 'bhɛɛ‑ ‑e ‑ja 'kɛle‑ laflɛ' 'yi 'bhɛ ma.» ");
INSERT INTO moa_vpl VALUES ("AC1_23","074_1_23","ACT","1","23","23","'Bhɛ blaan, 'ke ‑o mɛɛ plɛ makunle ‑o ba: Zozɛfu 'pegee Matiasi. Zozɛfu ‑zwana' 'tɔ 'yaa‑ Baasabasi; 'bhɛɛ‑ ‑o ‑yaa ‑a sii 'ezin‑ mɛɛ ‑lɛdɔɔle. ");
INSERT INTO moa_vpl VALUES ("AC1_24","074_1_24","ACT","1","24","24","'Bhɛ blaan, 'ke ‑o 'kpɛn ‑o 'seriwole 'eke‑ zi, 'ke ‑wa pele‑ ‑Waanbhaa' ni dɔɔ: «Mɛɛzan ‑Waanbhaa', 'bhi 'la 'bhi bhaaplɛŋ 'kpɛn 'kpeejan‑ dɔ, 'e 'woo‑ mɛɛ plɛ 'lɛɛ‑ ‑o 'kɛla 'bhɛ makwan‑ 'yaa‑ pɛ 'le, 'bhɛ zan 'ɛ zrɔn 'o ni, ");
INSERT INTO moa_vpl VALUES ("AC1_25","074_1_25","ACT","1","25","25","'kooko‑ 'bhɛ zan zɛn Zudasi blaan yrɛ 'ɛ ꞊nɔɔ, 'bhɛɛ‑ ‑e klɛ 'yaa‑ 'winbɔwo mu 'ɛ do 'le. ‑Amasrɔyi 'yee‑ Zudasi ‑gwa ‑a dulayrɛ 'ɛ ꞊nɔɔ, 'bhɛɛ‑ ‑e ‑ja yrɛ 'la ‑gaale' ‑o ‑a ba 'bhɛ ꞊nɔɔ.» ");
INSERT INTO moa_vpl VALUES ("AC1_26","074_1_26","ACT","1","26","26","'Bhɛ blaan, 'ke ‑o 'tete dɔle‑, 'bhɛɛ‑ 'ke 'bhɛ baale' 'woo‑ mɛɛ plɛ 'ɛ do ta. 'Bhɛ mɛɛ 'ɛ ‑yaa 'ke Matiasi ‑la ‑le. 'Bhɛ 'yi 'tɛ, 'ke 'bhɛ 'kpale Zesu a 'winbɔwo mu vu ta do 'ɛ ba, 'bhɛɛ‑ ‑o ꞊kla mɛɛ vu ta plɛ 'tɛ 'ezin‑. ");
INSERT INTO moa_vpl VALUES ("AC2_1","074_2_1","ACT","2","1","1","‑O ‑yaa Zuufu mu 'ɛ ‑waa' 'fɛti 'la sii Pantekɔti, 'bhɛ yi 'ɛ ꞊bhwa, 'bhɛɛ‑ Zesu a ‑klaŋlanɛ mu 'ɛ 'kpɛn 'klale‑ ‑yaa 'eke‑ ba yrɛ do 'kpɔ ꞊nɔɔ. ");
INSERT INTO moa_vpl VALUES ("AC2_2","074_2_2","ACT","2","2","2","'Bhɛ yrɛ do 'ɛ ꞊nɔɔ bhe, 'ke pɛ ‑weli' do dale‑ blaale‑ laflɛ' 'yi, 'bhɛ pɛ ‑weli' 'ɛ 'yaa‑ 'bhii‑ faŋgan‑ ma ‑ploo ‑gbɛnɛ do 'kangbɛya gbɛɛn‑, 'bhɛɛ‑ Zesu a ‑klaŋlanɛ mu 'ɛ ‑yaale' ‑yaa 'fɛ 'kpee 'la ꞊la, 'ke 'yee‑ pɛ ‑weli' ‑gbɛnɛ 'ɛ 'wlale 'bhɛ 'nɔɔ‑, 'bhɛɛ‑ 'kee‑ 'bhɛ 'kpɛn 'pale. ");
INSERT INTO moa_vpl VALUES ("AC2_3","074_2_3","ACT","2","3","3","'Bhɛ klɛle 'tɛ, 'bhɛ 'waati do 'kpɔ 'ɛ ba, 'ke ‑o ‑yrɛkpale pɛ nrɛ 'ke mu ma 'bhii‑ 'tɛ nrɛ mu gbɛɛn‑. 'Bhɛɛ‑ 'ke 'mu gole‑ 'eke‑ ma, 'ke ‑o gele‑ dulalɛ Zesu 'yi mu 'ɛ 'kpɛn 'wiiŋ‑ do do. ");
INSERT INTO moa_vpl VALUES ("AC2_4","074_2_4","ACT","2","4","4","'Bhɛ 'yi, 'ke ‑o 'kpɛn 'pale 'ke Lii 'Weŋ 'ɛ 'le, 'bhɛɛ‑ 'ke ‑o wli ‑bhɛɛke' mu pele 'sanle; ‑o 'kpɛn do do ‑yaa Lii 'Weŋ 'ɛ 'seŋ 'wlata‑ wli ‑bhɛɛke' mu 'pe 'zi. ");
INSERT INTO moa_vpl VALUES ("AC2_5","074_2_5","ACT","2","5","5","'Bhɛɛ‑ 'duŋ‑, Zuufu mu 'la 'yaa‑ gblaan ‑Waanbhaa' ‑lɛɛ, 'bhɛɛ‑ 'ke ‑o zɛnle ‑yaa 'klɛɛn 'bhɛɛke mu 'ɛ 'yi, 'mu 'kpɛn ꞊yaa Zeruzalɛmu 'bhɛ 'waati 'ɛ ba. ");
INSERT INTO moa_vpl VALUES ("AC2_6","074_2_6","ACT","2","6","6","‑O 'bhɛ pɛ ‑weli' do 'ɛ 'male‑, 'ke ‑o 'kpɛn blasanle 'bhɛɛ‑ 'ke ‑o gele‑ 'bhɛ yrɛ 'ɛ ꞊nɔɔ ‑glinlɛ'. 'Bhɛ 'yi 'tɛ, 'ke ‑o 'kpɛn 'liibhaale ‑o ma, ‑amasrɔyi ‑o 'kpɛn do do ‑yaa Zesu 'yi mu 'ɛ 'yaa‑ wli mu 'la 'pe zii' 'mu ‑yima' zii' ‑o 'gbu 'ya wli mu 'ɛ 'yi. ");
INSERT INTO moa_vpl VALUES ("AC2_7","074_2_7","ACT","2","7","7","‑O ‑liibhaa' gbɛ ‑yɔɔ 'ɛ 'kɔɔ‑ ‑o ma 'ke ‑wa pele‑ dɔɔ: «'E! 'Woo‑ mɛɛ mu 'la bhe waa ‑o 'ke Galile mu 'le ɛɛ? ");
INSERT INTO moa_vpl VALUES ("AC2_8","074_2_8","ACT","2","8","8","'Bhɛɛ‑ ‑e ꞊kla 'nale‑ 'bhɛɛ‑ ‑kɔɔ' 'kpɛn do do ‑o pe wli mu 'ɛ 'ma zii' ‑kɔɔ' 'gbu 'ya wli mu 'ɛ 'yi do do ɛɛ? ");
INSERT INTO moa_vpl VALUES ("AC2_9","074_2_9","ACT","2","9","9","'E pe Paritɛsi mu oo, Mɛdi mu oo, Elami mu oo, Mezopotami mu oo, Zude mu oo, Kapadɔsi mu oo, Pɔn mu oo, 'bhɛɛ‑ Azi mu oo, ");
INSERT INTO moa_vpl VALUES ("AC2_10","074_2_10","ACT","2","10","10","Frizi mu oo, Panfili mu oo, Ezipu mu 'pegee Libi gbɛ 'la ‑yoo Sirɛni ‑din 'bhɛ ꞊nɔɔ mu, 'bhɛɛ‑ Rɔmu mu; 'mu 'ke mu ‑o Zuufu ‑kpɔsɔɔ mu 'le, 'bhɛɛ‑ 'mu 'ke mu ‑wlaa Zuufu mu a 'seri 'ɛ 'yi. ");
INSERT INTO moa_vpl VALUES ("AC2_11","074_2_11","ACT","2","11","11","'Bhɛɛ‑ mɛɛ 'ke mu ‑o 'ke Krɛti mu 'le, 'bhɛɛ‑ ‑a 'ke mu ‑o 'ke Arabu mu 'le. 'Duŋ‑ ‑e ꞊kla 'nale‑, 'bhɛɛ‑ ‑kɔɔ' 'kpɛn ‑o ‑Waanbhaa' klɛza ‑gbɛnɛ mu 'ɛ 'ma zii' ‑kɔɔ' 'kpɛn do do ya wli mu 'ɛ 'yi ɛɛ?» ");
INSERT INTO moa_vpl VALUES ("AC2_12","074_2_12","ACT","2","12","12","‑O 'kpɛn 'liibhaa gbɛ ‑yɔɔ' 'ɛ 'kɔɔ ‑o ma, waa ‑yaa 'sɔle ‑jan 'bhɛɛke do 'kpɔ 'wole, 'ke yaa 'e go 'ke ‑wa pe 'eke‑ ni dɔɔ: «‑Za 'lɛɛ‑ 'bhɛ 'yi ‑o 'nale‑ ‑a ma ɛɛ?» ");
INSERT INTO moa_vpl VALUES ("AC2_13","074_2_13","ACT","2","13","13","'Duŋ‑ 'woo‑ mɛɛ mu 'ɛ 'ke mu ‑yaa 'sɔnsi zii' Zesu 'yi mu 'ɛ ma 'ke ‑wa pe dɔɔ: «‑wɛɛn ‑le ‑o dɛ 'zi!» ");
INSERT INTO moa_vpl VALUES ("AC2_14","074_2_14","ACT","2","14","14","'Bhɛ klɛle 'tɛ, 'ke Piɛri 'pegee Zesu a *winbɔwo mu ‑vin vu ta do 'ɛ ‑woo ‑wlɛnle', 'bhɛɛ‑ 'ke 'yee‑ Piɛri 'a 'weli‑ 'ɛ 'lawlɛnle, 'bhɛɛ‑ 'ke ‑ya pele‑ ‑zamaa' 'ɛ ni dɔɔ: «'Ka mu Zuufu mu, 'bhɛɛ‑ 'ka mu 'la 'kpɛn ‑o ‑zɔn Zeruzalɛmu ‑gɛ, ‑ka 'ka 'trɔnbadɔ 'ŋ ni 'elrele doo, 'bhɛɛ‑ ‑ka 'ŋ 'wojan‑ 'ɛ 'yima. ");
INSERT INTO moa_vpl VALUES ("AC2_15","074_2_15","ACT","2","15","15","'Ka mu 'kpee ma ‑wɛɛn ‑le mɛɛ mu 'lɛɛ‑ dɛ 'zi ɛɛ? 'Duŋ‑ ‑wɛɛn do 'kpɔ 'laa ‑o dɛ 'zi, ‑amasrɔyi ‑wɛɛn dɛ bhla laa 'ke zrwanzi 'waati 'lɛɛ‑ ba 'ɛ 'le. ");
INSERT INTO moa_vpl VALUES ("AC2_16","074_2_16","ACT","2","16","16","'Duŋ‑ ‑Waanbhaa' ‑jan 'la ꞊kpaa ‑a ‑lɛla' janwo mi Zoɛli 'lii 'elwaleta ‑sɔ 'bhɛ ‑la ‑lɛsɔ' zii' ‑zɔn ‑gɛ, ‑ya ꞊pia dɔɔ: ");
INSERT INTO moa_vpl VALUES ("AC2_17","074_2_17","ACT","2","17","17","‹‑Ka 'ka 'yrɛkpa, 'ke 'drunyan 'lɛyan yi mu 'ɛ ꞊bhwa 'e ‑din 'waati 'la ba, 'ŋ nu ‑za mu 'lɛɛ‑ 'mu ‑la klɛlɛ: 'ŋ 'nu 'ŋ Lii 'Weŋ 'ɛ zinalɛ bhaaplɛŋ mu 'ɛ 'kpɛn ta, 'bhɛɛ‑ 'ka gbe mu 'pegee 'ka 'lu mu 'ɛ nu 'ŋ 'lɛla꞊ janwolɛ, 'bhɛɛ‑ 'kaa‑ ‑zwannɛ mu 'pegee 'kaa‑ ‑gblanɛ mu nu ‑za mu yelɛ ‑yrɛ zi yele 'yi; 'bhɛɛ‑ gbiŋ mu nu 'klalɛ‑ 'kaa‑ 'gwlaan‑ gblaan mu 'ɛ 'yrɛ ba. ");
INSERT INTO moa_vpl VALUES ("AC2_18","074_2_18","ACT","2","18","18","Wlan 'gbu 'ɛ ni, 'ŋ nu 'ŋ Lii 'Weŋ 'ɛ zinalɛ 'an yewonɛ 'gwlaan‑ mu 'pegee 'an yewo le mu 'ɛ 'kpɛn ta, 'bhɛɛ‑ ‑o nu 'ŋ 'lɛla꞊ janwolɛ. ");
INSERT INTO moa_vpl VALUES ("AC2_19","074_2_19","ACT","2","19","19","'Ŋ nu 'kpeelɛni maza mu zrɔnlɛ laanima laflɛ' 'yi, 'bhɛɛ‑ 'ŋ nu 'sɔle‑ maza mu zrɔnlɛ 'trɛ ta ‑gɛ: yiɛn 'bhɛɛ‑ 'tɛ 'pegee 'tɛgblɛn‑ nu klɛlɛ. ");
INSERT INTO moa_vpl VALUES ("AC2_20","074_2_20","ACT","2","20","20","‑Gblo nu 'kpalɛ‑ ‑yretɛbhɛ 'ɛ 'yrɛ ta, 'bhɛɛ‑ laanima mlɛ 'ɛ nu 'tranlɛ‑ 'bhii yiɛn gbɛɛn‑. 'Bhɛ 'kpɛn blaan, 'bhɛɛ‑ Mɛɛzan ‑Waanbhaa' a yi 'ɛ nu bhɔlɛ 'tɛ, 'bhɛ yi 'ɛ nu klɛlɛ 'ke yi ‑gbɛnɛ do 'bhɛ 'pegee ‑Waanbhaa' a 'tɔbhɔleya yi 'le. ");
INSERT INTO moa_vpl VALUES ("AC2_21","074_2_21","ACT","2","21","21","'Bhɛ 'yi 'ɛ 'tɛ, 'ke mɛɛ 'oo mɛɛ 'la zan Mɛɛzan 'tɔ 'ɛ ‑siila, 'bhɛ zan nu golɛ ‑za 'yi. ‑Waanbhaa' ‑lɛla' janwo mi Zoɛli ‑jan 'la ꞊woa 'bhɛ ‑le bhe.›» ");
INSERT INTO moa_vpl VALUES ("AC2_22","074_2_22","ACT","2","22","22","Piɛri ‑ja ‑yaa' ‑jan 'ɛ 'wole‑ zi 'ke ‑ya pele 'ezin‑ dɔɔ: «‑Ka 'ka 'trɔnbadɔ 'ŋ ni doo, 'ŋ nɛɛnɛ‑ Izraɛli mu: Zesu 'la 'yaa‑ da Nazarɛti ‑wa 'ɛ ta, ‑Waanbhaa' 'gbu 'a ‑zrɔnna 'ka ni 'bhii‑ 'yee‑ 'gbu ‑le 'a 'winbwa‑; ‑amasrɔyi 'yee‑ ‑Waanbhaa' 'sɔle‑ maza mu 'pegee 'kpeelɛni maza mu, 'bhɛɛ‑ ‑tɔɔmasie mu ꞊kla ‑a gbɛ zi ‑e ‑yaa ‑kɔɔ' 'pleŋ‑ ‑gɛ 'waati 'la ba; 'bhii‑ 'ka 'gbu 'bhɛ ‑za mu 'ɛ 'yaango‑ gɔnɛ‑ 'la gbɛɛn‑ bhe. ");
INSERT INTO moa_vpl VALUES ("AC2_23","074_2_23","ACT","2","23","23","'Yee‑ mɛɛ 'lɛɛ‑ 'lɛnale 'ɛ 'ka ni 'ɛ 'bhɛ ‑daa ‑Waanbhaa' ‑la ba, 'bhii‑ ‑ya 'lɛdulaa gɔnɛ‑ 'la gbɛɛn‑ 'elwale ‑sɔ. 'Ka mu ‑le 'a ꞊kla 'bhɛɛ‑ mɛɛ ‑yɔɔ' mu 'a ꞊dia 'ke ‑wa gbaan ‑yrigbɛɛle ta. ");
INSERT INTO moa_vpl VALUES ("AC2_24","074_2_24","ACT","2","24","24","'Duŋ‑ ‑Waanbhaa' 'a ‑bwela gale ba, 'bhɛɛ‑ ‑ya ‑gwa ga a ‑yrɛn mu 'yi. ‑Amasrɔyi yaa ‑yaa sɔ dɔle‑ ga 'kpee 'ke 'bhɛ 'bhɛ gbɛblɔɔ ‑a ta. ");
INSERT INTO moa_vpl VALUES ("AC2_25","074_2_25","ACT","2","25","25","Wlan 'ɛ ni, ‑bhleŋgbe Davidi 'gbu 'yee‑ Zesu 'gbu ba ‑janwoa 'elwaleta ‑sɔ dɔɔ: ‹'Ŋ Mɛɛzan ye 'waati 'ɛ 'kpɛn ba 'ŋ 'lɛɛ. ‑Yoo 'ŋ ‑din 'tɔbhɔ‑ ma yaayrɛ 'ɛ ꞊nɔɔ, 'kooko‑ 'naa ‑gblaan'. ");
INSERT INTO moa_vpl VALUES ("AC2_26","074_2_26","ACT","2","26","26","'Bhɛla‑ ‑yile, 'ŋ zrukpaale ‑o, 'bhɛɛ‑ 'ŋ ‑janwo' zii' 'ŋ zrukpaale ‑gbɛnɛ 'le. 'Ŋ gale blaan, 'ŋ 'yri nu bolɛ ‑a ta 'bhii‑ 'ŋ 'flɛ 'ɛ nu bolɛ yilabla 'yi. ");
INSERT INTO moa_vpl VALUES ("AC2_27","074_2_27","ACT","2","27","27","‑Amasrɔyi 'bhi Mɛɛzan ‑Waanbhaa' laa nu 'ŋ lii 'ɛ 'tolɛ‑ gbaa mu a ‑wa 'ɛ ta 'sekeseke, 'bhɛ 'pegee 'yaa nu ‑a 'tolɛ‑ 'bhɛɛ‑ 'yaa‑ pɛ mɛɛ 'weŋ 'ɛ gbaa 'ɛ bɔn. ");
INSERT INTO moa_vpl VALUES ("AC2_28","074_2_28","ACT","2","28","28","Bole ‑yrɛ ma ‑si 'la ‑daŋ' 'laa ‑o 'bhɛ ma, 'e 'bhɛ a zi ‑zrɔnna 'ŋ ni, 'bhɛɛ‑ 'e bolela ‑yoo 'ŋ ‑din 'bhɛ nu 'ŋ zrukpaalɛ 'egbɛnɛle.›» ");
INSERT INTO moa_vpl VALUES ("AC2_29","074_2_29","ACT","2","29","29","Piɛri pe 'ezin‑ dɔɔ: «'Ŋ nɛɛnɛ‑ mu, 'kaa‑ 'to 'ke 'ŋ ‑jan sa wo 'ka ni kpataakpa ‑kɔɔ' ‑gbɔɔ Davidi ba za 'yi doo: ‑e ꞊kla 'ke siɛle', ‑wa ꞊bian, 'bhɛɛ‑ ‑a bu 'ɛ ‑yoo ‑kɔɔ' ba ‑gɛ ‑zɔn ‑li. ");
INSERT INTO moa_vpl VALUES ("AC2_30","074_2_30","ACT","2","30","30","‑E ‑yaa ‑Waanbhaa' ‑lɛla' janwo mi 'la 'le bhe, 'bhɛɛ‑ ‑ya 'yaangolawoa 'bhii‑ ‑Waanbhaa' 'gbu 'bhɛ 'siɛnwoa꞊ ‑a ni kpataakpa dɔɔ 'bhɛ nu 'yee‑ Davidi 'gbu 'srɛ mu 'ɛ do klɛlɛ 'ke ‑bhleŋgbe 'le ‑a blaan. ");
INSERT INTO moa_vpl VALUES ("AC2_31","074_2_31","ACT","2","31","31","‑Za 'la 'yaa‑ nu bhɔlɛ, 'yee‑ Davidi 'gbu 'bhɛ ꞊ya 'elwale gban ‑sɔ, ‑ayile ‑e Mɛɛ ‑Bhee Mi ‑Kpɔsɔɔ Krisi bweza 'ɛ gale ba 'bhɛ ba janwoa‑ dɔɔ: ‹Waa ‑a 'tolɛ‑ gbaa mu a ‑wa 'ɛ ta, 'bhɛɛ‑ ‑a gbaa 'ɛ yaa nu bɔnlɛ.› ");
INSERT INTO moa_vpl VALUES ("AC2_32","074_2_32","ACT","2","32","32","‑Waanbhaa' 'bhɛ Zesu 'la ‑bwela gale ba, 'ŋ 'yoo‑ 'bhɛ ‑laa' ‑janwo' zii' 'ka ni, 'bhɛɛ‑ 'o mɔɔ 'gbu ‑o ‑a 'srɛ 'le. ");
INSERT INTO moa_vpl VALUES ("AC2_33","074_2_33","ACT","2","33","33","‑E ‑ja laanima, 'bhɛɛ‑ ‑Waanbhaa' 'a 'lɛdwa‑ ‑a ma 'egbɛnɛle 'ke 'bhɛ 'a klɛ ‑bhleŋgbe 'le 'bhɛ ‑din 'tɔbhɔ ma yaayrɛ 'ɛ ꞊nɔɔ. 'Bhɛɛ‑ ‑e Lii 'Weŋ 'ɛ 'srɔɔwoa‑ ‑a Dɛ ‑Waanbhaa' 'kɔɔ 'bhii‑ 'bhɛ 'bhɛ 'liiwli‑ ꞊naa ‑a naza ta gɔnɛ‑ 'la gbɛɛn‑ bhe. 'Bhɛɛ‑ 'yee‑ Zesu 'gbu 'bhɛ Lii 'Weŋ ‑zinaa' 'ɛ 'o mɔɔ ta, 'bhii‑ 'ka 'yrɛ ‑o ‑a ma gɔnɛ‑ 'la gbɛɛn‑ ‑gɛ bhe, 'bhɛɛ‑ 'kaa‑ ma 'zi gɔnɛ‑ 'la gbɛɛn‑ 'ezin‑ ‑zɔn. ");
INSERT INTO moa_vpl VALUES ("AC2_34","074_2_34","ACT","2","34","34","‑Amasrɔyi, Davidi 'gbu 'laa 'wlɛnlɛ‑ 'bhɛɛ‑ ‑e ge laflɛ' 'yi 'bhii‑ Zesu gbɛɛn‑, 'bhɛɛ‑ 'duŋ‑, 'yee‑ 'gbu Zesu ba janwoa‑ dɔɔ: ‹Mɛɛzan ‑Waanbhaa' 'a ꞊pia 'mi a pɛ Mɛɛzan 'ɛ ni dɔɔ: Yala‑ 'ŋ ‑din 'tɔbhɔ ma yaayrɛ 'ɛ ꞊nɔɔ, ");
INSERT INTO moa_vpl VALUES ("AC2_35","074_2_35","ACT","2","35","35","'sani‑ 'ke 'ŋ yan 'e 'sɔɔnnii mu 'ɛ klɛlele 'e gaan ꞊la pɛ mu 'le.› ");
INSERT INTO moa_vpl VALUES ("AC2_36","074_2_36","ACT","2","36","36","«'Bhɛla‑ ‑yile, 'ka mu 'kpɛn 'ŋ nɛɛnɛ‑ Izraɛli mu, ‑kaa 'yaango‑ kpataakpa 'bhii‑ 'ka 'yee‑ Zesu 'la ‑gbaanna ‑yrigbɛɛle 'ɛ ta, ‑Waanbhaa' 'yela‑ ꞊kla 'ke Mɛɛzan 'pegee Mɛɛ ‑Bhee Mi Krisi 'le bhe!» ");
INSERT INTO moa_vpl VALUES ("AC2_37","074_2_37","ACT","2","37","37","Mɛɛ mu 'ɛ 'bhɛ ‑jan mu 'ɛ 'male‑, 'ke ‑o zrubatɛdɔle (‑amasrɔyi ‑wa 'yaangwa‑ 'bhii‑ ‑o ‑za 'yɔɔ‑ ꞊kla ‑Waanbhaa' ni); 'bhɛla‑ ‑yile, 'ke ‑o Piɛri 'pegee Zesu a 'winbɔwo mu ‑vin mu 'ɛ 'lrɔkpale dɔɔ: «'O nɛɛnɛ‑ mu, 'o sɔ ‑mɛ pɛ za 'gbu ‑la klɛle‑ ɛɛ?» ");
INSERT INTO moa_vpl VALUES ("AC2_38","074_2_38","ACT","2","38","38","'Bhɛ klɛle 'tɛ, 'ke Piɛri 'a 'pele ‑o ni dɔɔ: «‑Ka 'ploo‑ 'kaa‑ ‑za 'yɔɔ‑ mu 'ɛ ma, 'bhɛɛ‑ ‑ka 'ka 'gbu 'na ‑Waanbhaa' ni, 'bhɛɛ‑ ‑kaa klɛ 'ke ‑o 'ka 'kpɛn do do wiiŋfɛ ‑yi ba Zesu 'tɔ 'ɛ 'yi; 'kooko‑ ‑Waanbhaa' 'kaa‑ ‑za 'yɔɔ‑ mu 'ɛ 'sroma‑ yan. 'Ke 'bhɛ ꞊kla, ‑Waanbhaa' nu Lii 'Weŋ 'ɛ 'nalɛ‑ 'ka ni 'tɛ. ");
INSERT INTO moa_vpl VALUES ("AC2_39","074_2_39","ACT","2","39","39","‑Amasrɔyi 'kee‑ kpa 'ka mu ta oo, 'kee‑ kpa 'ka 'nɛ mu 'pegee yrɛ gbɔɔn nɔɔ‑ 'klɛɛn 'yi mu 'ɛ 'kpɛn ta oo, 'bhɛ 'pegee‑ Mɛɛzan ‑Waanbhaa' nu mɛɛ 'la zan mu 'siilɛ‑ 'mu ta, 'yee‑ ‑Waanbhaa' 'a 'liiwli‑ ꞊naa Lii 'Weŋ 'ɛ 'naza‑ ta 'ka 'kpɛn ni.» ");
INSERT INTO moa_vpl VALUES ("AC2_40","074_2_40","ACT","2","40","40","Piɛri ‑jan 'bhɛɛke ‑bebe ꞊woa ‑o ni 'ezin‑ 'ke ‑ya 'kpankpanyan ‑o ma, 'bhɛ 'pegee 'kee‑ zruwla ‑o 'kpee dɔɔ: «‑Kaa 'to 'ke Mɛɛzan Zesu 'ka go ‑za 'yi, 'bhɛɛ‑ 'ka 'ka 'pleŋgo‑ 'woo‑ ‑zɔn mɛɛ ‑yɔɔ' mu 'lɛɛ‑ ma!» ");
INSERT INTO moa_vpl VALUES ("AC2_41","074_2_41","ACT","2","41","41","'Bhɛ klɛle 'tɛ, 'ke ‑o ‑bebe dɔle‑ Piɛri 'wojan‑ mu 'ɛ ꞊la, 'bhɛɛ‑ 'ke ‑woo 'wiiŋfɛle ‑yi ba Zesu 'tɔ 'yi. 'Bhɛ ‑yrekpaa' do 'ɛ 'le, mɛɛ 'waa yaga ꞊kpaa Zesu 'yi mu ‑lɛdo' 'ɛ ba. ");
INSERT INTO moa_vpl VALUES ("AC2_42","074_2_42","ACT","2","42","42","'Kee‑ san 'bhɛ yi 'ɛ ma, 'woo‑ mɛɛ mu 'ɛ bole ‑yaa Zesu a winbɔwo mu 'ɛ 'yaa‑ ‑o daan 'zi ‑za mu 'la 'le 'mu 'klɔsikunle ma, 'bhɛɛ‑ ‑o 'kpale‑ ‑yaa do ma 'bhii‑ nɛɛnɛ‑ ma do mu. 'Ezin‑ ‑o ‑yaa bo Mɛɛzan ‑Waanbhaa' a pɛ 'ɛ 'bhlele‑ ma 'eke‑ zi, 'ke ‑woo 'seriwo 'eke‑ zi. ");
INSERT INTO moa_vpl VALUES ("AC2_43","074_2_43","ACT","2","43","43","‑Waanbhaa' ‑lɛɛgblaanya 'ɛ 'yaa‑ ‑o 'kpɛn 'yi, ‑amasrɔyi 'yee‑ ‑Waanbhaa' ‑yaa 'kpeelɛni maza ‑bebe 'pegee 'sɔle‑ maza mu klɛ 'zi Zesu a 'winbɔwo mu 'ɛ gbɛ zi. ");
INSERT INTO moa_vpl VALUES ("AC2_44","074_2_44","ACT","2","44","44","Zesu 'yi mu 'ɛ 'kpɛn 'kpale‑ ‑yaa do ma, 'bhɛɛ‑ ‑o ‑yaa ‑o 'kɔɔpɛ‑ mu 'ɛ 'kpɛn kpa 'eke‑ ta. ");
INSERT INTO moa_vpl VALUES ("AC2_45","074_2_45","ACT","2","45","45","‑O ‑yaa ‑waa' gba mu 'pegee ‑o 'kɔɔpɛ‑ mu 'ɛ gɔn, 'bhɛɛ‑ ‑o ‑yaa 'mu ma ‑gɔli' mu 'ɛ 'yiciɛn‑ 'eke‑ ma. ‑O 'kpɛn do do maza ‑yaa ‑gɔli' yɛkɛ‑ 'la ma, ‑o ‑yaa 'bhɛ 'yiciɛn‑ ‑o ma 'bhɛɛ‑ wlata zi 'lii. ");
INSERT INTO moa_vpl VALUES ("AC2_46","074_2_46","ACT","2","46","46","Yi 'oo yi, ‑o ‑yaa kla 'eke‑ ba ‑Waanbhaa' Gba 'Fɛ ‑Gbɛnɛ 'ɛ ꞊la, 'bhɛɛ‑ ‑o ‑yaa pɛ 'ɛ bhle 'eke‑ zi ‑waa' 'fɛ mu 'ɛ ꞊la. 'Bhɛɛ‑ ‑o ‑yaa pɛbhle 'eke‑ ba ‑o zrukpaa' ta, 'bhɛ 'pegee ‑o 'kpee 'lrele‑ 'le. ");
INSERT INTO moa_vpl VALUES ("AC2_47","074_2_47","ACT","2","47","47","‑O ‑yaa ‑Waanbhaa' 'tɔbhɔ‑, 'bhɛɛ‑ ‑o ‑za ‑yaa sɔ ‑waa' 'si mu 'ɛ 'kpɛn ni. 'Bhɛ ya 'ɛ 'yi, yi 'oo yi, Mɛɛzan ‑Waanbhaa' ‑yaa mɛɛ 'la zan mu go ‑za 'yi, 'mu 'yaa‑ 'kpa zii' Zesu 'yi mu ‑lɛdo' 'ɛ ba ‑o baan' 'le. ");
INSERT INTO moa_vpl VALUES ("AC3_1","074_3_1","ACT","3","1","1","‑Yrekpaa' do, ‑yretɛbhɛ bhlɔ bii 'waati 'ɛ 'la 'yaa‑ 'seriwo 'waati 'ɛ 'le, Piɛri 'pegee Zaan 'yaa‑ ge 'zi ‑o 'seriwo yrɛ nɔɔ‑ ‑Waanbhaa' Gba 'Fɛ ‑Gbɛnɛ 'ɛ ꞊la. ");
INSERT INTO moa_vpl VALUES ("AC3_2","074_3_2","ACT","3","2","2","Mɛɛ do yaale ‑yaa ‑Waanbhaa' Gba 'Fɛ ‑Gbɛnɛ 'ɛ 'lii 'la ‑o ‑yaa 'bhɛ sii: «'Fɛ 'lii 'lrele‑» 'bhɛ ‑din. 'Yee‑ mɛɛ 'ɛ 'yaa‑ 'ke ‑flugba 'le ‑a 'san ‑a ya yi 'ɛ ma. Yi 'oo yi, ‑o ‑yaa nu 'kɛle‑ 'bhɛɛ‑ ‑wa yalaa' 'bhɛ 'fɛ 'lii 'ɛ ‑din, 'kooko‑ ‑e ‑gɔli' 'yrɛwo‑ mɛɛ 'la zan mu 'yaa‑ nu ‑Waanbhaa' Gba 'Fɛ ‑Gbɛnɛ 'ɛ ꞊la 'mu ma. ");
INSERT INTO moa_vpl VALUES ("AC3_3","074_3_3","ACT","3","3","3","'Bhɛ 'yi 'tɛ, ‑a ‑yrɛkpale Piɛri 'pegee Zaan ma 'ke 'mu ‑o zan wlalɛ 'yee‑ ‑Waanbhaa' Gba 'Fɛ ‑Gbɛnɛ 'ɛ ꞊la, 'kee‑ pɛ ‑yrɛwole 'mu ma. ");
INSERT INTO moa_vpl VALUES ("AC3_4","074_3_4","ACT","3","4","4","'Bhɛ klɛle 'tɛ, 'ke Piɛri 'pegee Zaan 'mu 'e ‑yrɛkpale ‑a ta frii, 'bhɛɛ‑ 'ke Piɛri 'a 'pele 'a ni dɔɔ: «'O ‑glin doo!» ");
INSERT INTO moa_vpl VALUES ("AC3_5","074_3_5","ACT","3","5","5","‑Ayile, 'ke ‑ya ‑yrɛkpale 'mu ta frii, ‑a 'kpee ma 'mu 'yaa‑ nu pɛ do ‑la nalɛ ‑a ni. ");
INSERT INTO moa_vpl VALUES ("AC3_6","074_3_6","ACT","3","6","6","'Duŋ‑ Piɛri pe ‑a ni dɔɔ: «‑Gɔli' do 'kpɔ 'laa ‑o 'ŋ 'kɔɔ, 'bhɛɛ‑ 'duŋ‑, pɛ 'la 'bhɛ ‑o 'ŋ 'kɔɔ, 'ŋ 'bhɛɛ‑ 'nale‑ 'e ni, 'bhɛla‑ ‑yile 'mi pe 'e ni Zesu Krisi la da Nazarɛti 'bhɛ 'tɔ 'ɛ 'yi dɔɔ 'e 'wlɛn‑ 'bhɛɛ‑ 'taawo!» ");
INSERT INTO moa_vpl VALUES ("AC3_7","074_3_7","ACT","3","7","7","'Bhɛɛ‑ 'ke Piɛri 'a 'kunle ‑a gbɛ ‑yiɛ' 'ɛ ma, 'bhɛɛ‑ 'ke 'bhɛ 'a 'lawlɛnle. 'Bhɛ yrɛ do 'kpɔ 'ɛ ꞊nɔɔ bhe, 'ke ‑a gaanlaa‑ mu 'ɛ 'pegee ‑a gaanbhlɔ mu 'ɛ dɔle‑ 'eglɔɔle; ");
INSERT INTO moa_vpl VALUES ("AC3_8","074_3_8","ACT","3","8","8","'bhɛɛ‑ 'ke ‑ya ‑wlɛnle' ꞊kwan, 'kee‑ 'taawole 'sanle. ‑Ayile, 'kee‑ gele‑ Zesu a 'winbɔwo mu plɛ 'ɛ zi ‑Waanbhaa' Gba 'Fɛ ‑Gbɛnɛ 'ɛ ꞊la, 'kee‑ ge 'taawolele, 'bhɛ 'pegee 'kee‑ pinaa', 'bhɛɛ‑ 'kee‑ ‑Waanbhaa' 'tɔbhɔ. ");
INSERT INTO moa_vpl VALUES ("AC3_9","074_3_9","ACT","3","9","9","Mɛɛ mu 'ɛ 'kpɛn 'a ꞊ya 'ke ‑yoo 'taawo zii', 'bhɛɛ‑ 'kee‑ ‑Waanbhaa' 'tɔbhɔ‑. ");
INSERT INTO moa_vpl VALUES ("AC3_10","074_3_10","ACT","3","10","10","'Duŋ‑ ‑wa yele 'bhii‑ 'yela‑ yaale ‑yaa ‑Waanbhaa' Gba 'Fɛ ‑Gbɛnɛ 'lii 'la ‑o ‑yaa 'bhɛ sii: ‹'Fɛ 'lii 'lrele‑› 'bhɛ ‑din, 'ke ‑ya ‑yrɛwo' mɛɛ mu ma, 'bhɛɛ‑ ‑za yɛkɛ‑ 'la ꞊kla ‑a ni 'bhɛ ‑o 'kpɛn 'liibhaala, 'bhɛɛ‑ waa ‑yaa sɔ 'bhɛ 'yipele. ");
INSERT INTO moa_vpl VALUES ("AC3_11","074_3_11","ACT","3","11","11","'Yee‑ ‑flugba 'ɛ ‑bheele' blaan, yaa ‑yaa go Piɛri 'pegee Zaan zi; 'bhɛla‑ ‑yile, 'ke mɛɛ mu 'ɛ 'kpɛn 'kpeelɛnile. 'Bhɛɛ‑ 'ke ‑o 'kpɛn blasanle 'ke ‑o gele‑ 'klalɛ‑ Piɛri 'pegee Zaan zi ‑Waanbhaa' Gba 'Fɛ ‑Gbɛnɛ 'ɛ ‑gbeŋ 'ɛ 'yi yrɛ 'la ‑o ‑yaa 'bhɛ sii: «‑Bhleŋgbe Salomɔ a 'wlaŋla» 'bhɛ ꞊nɔɔ. ");
INSERT INTO moa_vpl VALUES ("AC3_12","074_3_12","ACT","3","12","12","Piɛri ‑zamaa' 'ɛ 'yele‑, 'ke ‑ya pele‑ ‑o ni dɔɔ: «'Ŋ nɛɛnɛ‑ Izraɛli mu, ‑mɛle ꞊kla 'bhɛɛ‑ 'yee‑ ‑flugba 'lɛɛ‑ 'bheeza‑ 'ɛ ‑yoo 'ka 'kpeelɛni zii' ɛɛ? ‑Mɛla ma ‑le 'bhɛɛ‑ 'ka ‑o 'o ‑glin 'zi 'bhii‑ 'o mɔɔ 'gbu ‑le 'a 'bheela‑ 'waa‑ ‑glɔɔya' 'ɛ 'le? 'Bhɛɛ‑ 'ka 'kpee ma 'yee‑ mɛɛ 'lɛɛ‑ 'taawoa꞊ 'waa‑ ‑Waanbhaa' a ‑lɛɛgblaanya 'bhɛɛ‑ ma ‑lɛɛ? ");
INSERT INTO moa_vpl VALUES ("AC3_13","074_3_13","ACT","3","13","13","*Abraamu, Izaki 'bhɛɛ‑ Zakɔbu a ‑Waanbhaa', 'yee‑ ‑kɔɔ' ‑gbɔɔ mu a ‑Waanbhaa' 'ɛ, 'bhɛ ‑le 'tɔbhɔleya ‑naa 'bhɛ a yewonɛ Zesu ni. 'Ka mu 'gbu 'bhɛ꞊naa ‑kɔɔ' 'lɛɛ mu 'ɛ ni 'kaa ‑wa dɛ, 'bhɛɛ‑ 'ka 'ka ‑baŋgwa ‑a ‑yi 'bhii‑ 'kaa‑ ‑bhleŋgbe 'le Pilati 'yrɛ ꞊la. 'Bhɛ 'gbu 'yaa‑ zi 'bhii‑ 'bhɛ 'ploo ‑a ma, ‑amasrɔyi 'bhɛ 'laa ‑za 'yɔɔ‑ do 'kpɔ 'yelɛ‑ ‑a zi. ");
INSERT INTO moa_vpl VALUES ("AC3_14","074_3_14","ACT","3","14","14","'Ka 'ka ‑baŋgwa 'yee‑ mɛɛ 'weŋ 'pegee 'yee‑ mɛɛ ‑lɛdɔɔle 'ɛ 'yi, 'bhɛɛ‑ 'ka ‑sromabwa Pilati ni dɔɔ 'bhɛ 'li mɛɛ dɛ mi do ma, 'bhɛɛ‑ ‑e 'ploo‑ 'bhɛ ma 'ka ni. ");
INSERT INTO moa_vpl VALUES ("AC3_15","074_3_15","ACT","3","15","15","'Bhɛ klɛgbɛya 'ɛ 'yi, 'kaa ꞊kla 'bhɛɛ‑ mɛɛ 'la zan bole ‑yrɛ ma ‑si na bhaaplɛŋ mu ni ‑o 'bhɛɛ‑ ꞊dia. 'Duŋ‑ ‑Waanbhaa' 'a ‑bwela gale ba, 'bhɛɛ‑ 'o mɔɔ 'gbu ‑o 'ke ‑a 'srɛ 'le. ");
INSERT INTO moa_vpl VALUES ("AC3_16","074_3_16","ACT","3","16","16","'Woo 'kpalawoa 'yee‑ Zesu 'ɛ 'yi, 'bhɛɛ‑ ‑glɔɔya' 'la ‑yoo ‑a 'tɔ 'ɛ 'yi, 'bhɛ ‑la 'srɔyi 'bhɛɛ‑ 'yee‑ mɛɛ 'lɛɛ‑ ꞊swa ‑a ‑wlɛnle', 'bhɛɛ‑ ‑e ‑dulaa' ‑a gaan ta. 'Ka 'kpɛn 'yrɛ ‑o 'yela‑ ma ‑gɛ, 'bhɛɛ‑ 'kaa dɔ. 'Kpaleya ‑la ma Zesu 'ɛ 'yi, 'bhɛɛ‑ 'yee‑ mɛɛ 'lɛɛ‑ 'bheela‑ 'bhii‑ 'ka 'yrɛ ‑o ‑a ma gɔnɛ‑ 'la gbɛɛn‑ ‑gɛ.» ");
INSERT INTO moa_vpl VALUES ("AC3_17","074_3_17","ACT","3","17","17","«'Bhɛɛ‑ 'ŋ nɛɛnɛ‑ mu, 'mi 'gbu 'a 'yaango‑ 'bhii‑ ‑zadɔkleya ‑la ma 'bhɛɛ‑ 'ka mu 'pegee 'kaa‑ ‑kuŋlii mu 'ɛ 'ka 'bhɛ ‑za 'yɔɔ‑ 'ɛ ꞊kla 'yee‑ Zesu 'ɛ ni. ");
INSERT INTO moa_vpl VALUES ("AC3_18","074_3_18","ACT","3","18","18","‑Waanbhaa' 'duŋ‑ ‑jan 'la ꞊kpaa ‑a ‑lɛla' janwo mu 'ɛ 'kpɛn 'lii 'elwale ‑sɔ 'bhɛ 'lɛswa꞊. ‑Ya ꞊pia dɔɔ Mɛɛ ‑Bhee Mi Krisi nu ‑yrɛnbhlelɛ mɛɛ mu 'kɔɔ‑. ");
INSERT INTO moa_vpl VALUES ("AC3_19","074_3_19","ACT","3","19","19","'Bhɛ ya 'ɛ 'yi, ‑ka 'ka dɔgbɛya 'ɛ maniina, 'bhɛɛ‑ ‑ka 'ka 'gbu 'na ‑Waanbhaa' ni, 'kooko‑ ‑e 'kaa ‑za 'yɔɔ‑ mu 'ɛ ma ‑sroma yan, 'bhɛɛ‑ ‑yoo talii. ");
INSERT INTO moa_vpl VALUES ("AC3_20","074_3_20","ACT","3","20","20","'Ke 'ka 'bhɛ ꞊kla, Mɛɛzan nu 'ka 'yitrɛ 'waati 'nalɛ‑ 'ka ni, 'bhɛɛ‑ ‑e Mɛɛ ‑Bhee Mi Krisi 'la makwan‑ 'elwale ‑sɔ, ‑e nu 'bhɛ 'winbɔlɛ 'ka ta: 'bhɛ Mɛɛ ‑Bhee Mi Krisi 'ɛ 'tɔ 'ɛ 'bhɛ ‑le Zesu. ");
INSERT INTO moa_vpl VALUES ("AC3_21","074_3_21","ACT","3","21","21","'Duŋ‑ 'sani‑ 'bhɛ yi 'ɛ 'bhɔle‑ pleŋ‑, Zesu nu bolɛ laflɛ' 'yi ‑sɔ 'ke pɛ mu 'ɛ 'kpɛn mabɔɔ 'bhɛɛ‑ ‑o klɛ 'edrɛɛle; 'bhii‑ ‑ya ꞊kpaa ‑ya ‑lɛla' janwo mu 'la makwan‑ 'elwaleta 'egbɔɔn gbɔɔnle' ‑sɔ 'mu 'lii gɔnɛ‑ 'la gbɛɛn‑. ");
INSERT INTO moa_vpl VALUES ("AC3_22","074_3_22","ACT","3","22","22","'Bhɛɛ‑ 'bhii‑ ‑kɔɔ' ‑gbɔɔ Moizi 'a ꞊pia gɔnɛ‑ 'la gbɛɛn‑ dɔɔ: ‹‑Kɔɔa' Mɛɛzan ‑Waanbhaa' 'mi 'winbwa‑ gɔnɛ‑ 'la gbɛɛn‑, ‑e nu ‑a ‑lɛla' janwo mi ‑bhɛɛke' do winbɔlɛ 'ka ta 'bhɛ klɛgbɛya do 'ɛ gbɛɛn‑; 'bhɛ nu klɛlɛ 'ka 'gbu 'srɛ mu 'ɛ do ‑la ‑le. ‑Ka 'ka 'trɔnkpa ‑a wojan mu 'ɛ 'kpɛn ꞊la. ");
INSERT INTO moa_vpl VALUES ("AC3_23","074_3_23","ACT","3","23","23","'Duŋ‑ 'ke mɛɛ 'oo mɛɛ 'la zan laa 'yee‑ ‑Waanbhaa' ‑lɛla' janwo mi 'ɛ 'wojan‑ mu 'ɛ 'klɔsikunlɛ, ‑o nu 'bhɛ zan 'ɛ dɛlɛ, 'bhɛɛ‑ ‑wa go 'an 'si mu 'ɛ ba.› ");
INSERT INTO moa_vpl VALUES ("AC3_24","074_3_24","ACT","3","24","24","'Kee‑ san ‑Waanbhaa' ‑lɛla' janwo mi Samiɛli ma, 'bhɛ 'pegee 'bhɛ a pɛ zitɛn' mu 'ɛ ma, ‑Waanbhaa' ‑lɛla' janwo mu 'ɛ 'kpɛn do do ‑Waanbhaa' ‑lɛlajanwoa ‑zɔn ‑za mu 'ɛ ba za 'yi. ");
INSERT INTO moa_vpl VALUES ("AC3_25","074_3_25","ACT","3","25","25","‑Waanbhaa' 'a 'liiwli‑ ꞊naa ‑za mu 'la 'kpɛn 'naza‑ ta ‑a ‑lɛla' janwo mu 'ɛ ni, 'ka mu ‑le ꞊kla bhɛ ‑za mu 'ɛ 'srɔɔwo mu 'le. 'Bhɛɛ‑ ‑e *‑bhoolaya 'la ‑dwa 'yee‑ 'pegee 'ka ‑gbɔɔ mu 'ɛ 'pleŋ, 'kaa‑ pɛ ‑le 'bhɛ ‑bhoolaya 'ɛ 'le 'ezin‑; ‑ya ꞊pia Abraamu ni dɔɔ: ‹'Ŋ nu 'trɛ ta 'si mu'ɛ 'kpɛn 'dumawolɛ 'bhi a pɛ 'srɛ mu ‑la ‑srɔyi'.› ");
INSERT INTO moa_vpl VALUES ("AC3_26","074_3_26","ACT","3","26","26","'Bhɛ klɛgbɛya 'ɛ 'yi, ‑Waanbhaa' ‑yaa' yewonɛ Zesu 'la makwan‑, ‑e 'bhɛ 'winbwa‑ 'ka mu ‑la ba 'elwale 'pe, 'ka 'dumawo ‑zayi'; 'bhɛɛ‑ 'kee‑ 'ka 'kpɛn do do go ‑za 'yi, 'bhɛɛ‑ ‑e 'ka go 'kaa‑ zi ‑yɔɔ' mu 'ɛ ta.» ");
INSERT INTO moa_vpl VALUES ("AC4_1","074_4_1","ACT","4","1","1","Piɛri 'pegee Zaan ‑yaa ‑janwo' zii' ‑li mɛɛ mu 'ɛ ni bhla 'la ba, 'ke 'sraka 'lɛna mu 'ke mu 'pegee ‑Waanbhaa' Gba 'Fɛ ‑Gbɛnɛ 'ɛ gooba ‑srwase' mu 'ɛ ‑kuŋlii 'ɛ, 'bhɛɛ‑ Saduse mu 'ɛ ‑o nule‑ wlalɛ ‑o ta 'yee‑ ‑Waanbhaa' Gba 'Fɛ ‑Gbɛnɛ 'ɛ ꞊la. ");
INSERT INTO moa_vpl VALUES ("AC4_2","074_4_2","ACT","4","2","2","‑Wa yelawoa 'bhii‑ Piɛri 'pegee Zaan ‑yaa mɛɛ mu 'ɛ daan 'zi 'ke ‑wa pe 'mu ni dɔɔ Zesu ‑bwela gale ba gɔnɛ‑ 'la gbɛɛn‑, bhaaplɛŋ mu 'kpɛn nu bwelɛ gale ba 'bhɛɛ‑ gbɛɛn‑ 'ezin‑; 'bhɛ ‑za 'ɛ 'bhɛ ‑o zrupliila 'egbɛnɛle. ");
INSERT INTO moa_vpl VALUES ("AC4_3","074_4_3","ACT","4","3","3","'Bhɛ klɛle 'tɛ, 'ke ‑o Piɛri 'pegee Zaan 'kunle 'bhɛɛ‑ 'ke ‑woo bɔle‑ ‑kaso 'yi, 'ke 'bhɛ ge 'tɛnlɛ‑ 'fɔ tooklinle ma; ‑amasrɔyi ‑woo ‑kwan yroma ‑la zi. ");
INSERT INTO moa_vpl VALUES ("AC4_4","074_4_4","ACT","4","4","4","'Bhɛɛ‑ 'duŋ‑, mɛɛ 'la zan mu 'yee‑ Piɛri 'pegee Zaan 'wojan‑ mu 'ɛ ꞊maa, 'mu 'e ‑kpaa Zesu 'yi, 'bhɛɛ‑ Zesu 'yi mu 'ɛ ‑o baan' ꞊kla ‑o ba, 'bhɛɛ‑ ‑o ‑lii 'ɛ ꞊bhwa mɛɛ 'waa 'soo ‑din. ");
INSERT INTO moa_vpl VALUES ("AC4_5","074_4_5","ACT","4","5","5","Too ‑klinle', Zuufu mu ‑kuŋlii mu 'ɛ 'pegee ‑waa' 'gwlaan‑ gblaan mu 'ɛ, 'bhɛɛ‑ 'Toŋ daan mu 'ɛ ‑o ꞊klaa 'eke‑ ba Zeruzalɛmu ‑wa 'ɛ ta. ");
INSERT INTO moa_vpl VALUES ("AC4_6","074_4_6","ACT","4","6","6","'Woo‑ mɛɛ mu 'la ꞊klaa 'eke‑ ba, ‑o 'ke ‑le ‑gɛ: 'sraka 'lɛna mu ‑kuŋlii gblaan Anasi, 'bhɛɛ‑ Kaifu 'pegee Zaan 'bhɛɛke do; 'bhɛɛ‑ Alɛzandri 'pegee 'yee‑ 'sraka 'lɛna ‑kuŋlii gblaan 'ɛ ‑yaa' 'fa ‑la mu 'ɛ 'kpɛn. ");
INSERT INTO moa_vpl VALUES ("AC4_7","074_4_7","ACT","4","7","7","‑O ‑ja Piɛri 'pegee Zaan 'siilɛ‑ ‑kaso 'ɛ 'yi, 'bhɛɛ‑ ‑o ‑nwa 'mu dulalɛ ‑o ‑yrɛ ꞊la; 'bhɛɛ‑ ‑o 'mu 'lrɔkpaa‑ dɔɔ: «‑De 'gbu ‑le 'bhɛ 'seŋ 'ɛ ꞊naa 'ka ni, 'bhɛ 'pegee ‑de 'gbu ‑la 'tɔ 'yi 'bhɛɛ‑ 'ka 'yee‑ ‑flugba 'lɛɛ‑ 'bheela‑ ɛɛ?» ");
INSERT INTO moa_vpl VALUES ("AC4_8","074_4_8","ACT","4","8","8","'Bhɛ klɛle 'tɛ, Piɛri 'palela 'yaa‑ 'ke Lii 'Weŋ 'ɛ 'le 'bhɛ 'waati 'ɛ ba, 'ke 'bhɛ 'a zikpale ‑o ni dɔɔ: «'Waa‑ ‑kuŋlii mu 'pegee Izraɛli mu a 'gwlaan‑ gblaan mu! ");
INSERT INTO moa_vpl VALUES ("AC4_9","074_4_9","ACT","4","9","9","'O ‑za 'wlan 'la ꞊kla ‑flugba 'gwlaan‑ 'lɛɛ‑ ni, 'bhɛɛ‑ ‑e ‑bheela gɔnɛ‑ 'la gbɛɛn‑; ‑woo' 'lrɔkpa zii' ‑zɔn 'bhɛɛ‑ ma, 'duŋ‑ 'mi ‑o zan 'bhɛ 'yipelɛ 'ka ni. ");
INSERT INTO moa_vpl VALUES ("AC4_10","074_4_10","ACT","4","10","10","'Ka 'kpɛn 'pegee Izraɛli mu 'ɛ 'kpɛn, ‑ka dɔ klɛn 'ke 'kaa 'yaango 'bhii‑ ‑glɔɔya' 'la ‑yoo Nazarɛti mi Zesu Krisi 'tɔ 'ɛ 'yi, 'bhɛla‑ 'srɔyi 'bhɛɛ‑ 'ka 'yrɛ ‑o ‑zɔn 'yee‑ mɛɛ 'lɛɛ‑ 'klɛnyawole dulale ma ‑gɛ. 'Ka 'yee‑ Zesu 'la ‑gbaanna *‑yrigbɛɛle 'ɛ ta, 'bhɛɛ‑ 'kaa ꞊dia; 'bhɛɛ‑ ‑Waanbhaa' 'a ‑bwela gale ba 'bhɛ ‑le 'yee‑ mɛɛ 'lɛɛ‑ 'bheela‑. ");
INSERT INTO moa_vpl VALUES ("AC4_11","074_4_11","ACT","4","11","11","‑Waanbhaa' a 'Sɛwɛ 'ɛ 'bhɛ 'yee‑ Zesu ba janwoa‑ dɔɔ: ‹'Ka mu 'fɛgwlɛ‑ dɔ mu 'ɛ, 'ka vlɛ 'la ‑blinna; 'bhɛ ‑le ꞊kla 'ke 'fɛgwlɛ‑ 'ɛ gaan ‑la vlɛ ‑kpuŋ ‑gbɛnɛ 'gbu 'ɛ 'le.›» ");
INSERT INTO moa_vpl VALUES ("AC4_12","074_4_12","ACT","4","12","12","'Bhɛɛ‑ Piɛri pe 'ezin‑ dɔɔ: «Bhaaplɛŋ laa sɔ gole‑ ‑za ‑yi 'tɔ 'bhɛɛke do 'kpɔ 'srɔyi, 'ke yaa 'e go Zesu 'tɔ do 'kpɔ 'ɛ 'bhɛɛ‑ ba. ‑Amasrɔyi ‑Waanbhaa' laa 'tɔ 'bhɛɛke do 'kpalɛ‑ bhaaplɛŋ 'kedo‑ 'kpɔ ma 'trɛ ta ‑gɛ, 'bhɛɛ‑ 'ke ‑kɔɔ' ‑kɔɔ' ꞊kpaa 'bhɛ 'yi, 'bhɛɛ‑ ‑kɔɔ' sɔ gole‑ ‑za 'yi.» ");
INSERT INTO moa_vpl VALUES ("AC4_13","074_4_13","ACT","4","13","13","'Woo‑ Zuufu mu a ‑kuŋlii mu 'ɛ 'pegee ‑waa' 'gwlaan‑ gblaan mu 'ɛ ‑wa yele 'bhii‑ ‑gblaan 'laa ‑yaa Piɛri 'pegee Zaan 'yi, 'mu a ‑janwo' bhla 'ɛ zi, 'ke ‑o ‑liibhaale ‑o ma. ‑Amasrɔyi ‑o ‑yaa ‑a 'yaandɔ‑ 'bhii‑ Piɛri 'pegee Zaan yaa 'ke bhaama mɛɛ mu ‑la ‑le, 'bhɛɛ‑ 'mu 'laa ‑yaa 'sɛwɛdɔ mu 'le. ‑O ‑yaa 'mu dɔ Zesu zi mu 'te ‑la ‑le. ");
INSERT INTO moa_vpl VALUES ("AC4_14","074_4_14","ACT","4","14","14","'Duŋ‑ ‑o ‑yrɛ 'la 'yaa‑ mɛɛ 'la zan 'bheela‑ 'bhɛ dulale ma Piɛri 'pegee Zaan ‑din, waa ‑yaa sɔ ‑jan 'kedo‑ 'kpɔ 'wole 'ezin‑ ‑li. ");
INSERT INTO moa_vpl VALUES ("AC4_15","074_4_15","ACT","4","15","15","‑Ayile 'ke ‑wa pele‑ Piɛri 'pegee Zaan ni dɔɔ‑ 'mu 'e go ‑o pleŋ‑ 'bhɛɛ‑ 'mu ge 'pɛɛlii‑ sa. 'Bhɛ mu 'pwɛle‑ blaan, 'ke ‑o zaabɔle 'sanle 'eke‑ pleŋ‑. ");
INSERT INTO moa_vpl VALUES ("AC4_16","074_4_16","ACT","4","16","16","'Bhɛ 'yi 'tɛ, 'ke ‑wa pele‑ 'eke‑ ni dɔɔ: «‑Kɔɔ' nu ‑mɛ pɛ za ‑la klɛlɛ 'woo‑ mɛɛ plɛ 'lɛɛ‑ ni ɛɛ? ‑Amasrɔyi Zeruzalɛmu ‑wa 'kpee mu 'ɛ 'kpɛn 'a 'yaango‑ 'bhii‑ 'sɔle‑ maza ‑gbɛnɛ 'lɛɛ‑ ꞊kla 'wola‑ gbɛ zi; 'bhɛɛ‑ 'duŋ‑ ‑kɔɔ' 'laa sɔ a pele‑ dɔɔ 'woo‑ mu klɛza laa 'bhɛ 'le. ");
INSERT INTO moa_vpl VALUES ("AC4_17","074_4_17","ACT","4","17","17","'Duŋ‑, 'kooko‑ 'ke ‑kɔɔ' 'laa to 'ke 'yee‑ ‑flugba 'lɛɛ‑ 'bheeza‑ 'ɛ zɛn yrɛkpɛn‑ ꞊nɔɔ ‑kɔɔa' mɛɛ mu 'ɛ 'pleŋ, ‑kɔɔ' ‑o ‑lɛmazɔn, 'bhɛɛ‑ ‑kɔɔ' ‑gblaan 'kla ‑o ‑yi 'kaa waa Zesu 'tɔ 'ɛ 'kanlɛ‑ mɛɛ 'kedo‑ 'kpɔ ni 'ezin‑ 'sekeseke.» ");
INSERT INTO moa_vpl VALUES ("AC4_18","074_4_18","ACT","4","18","18","'Bhɛ blaan, 'ke ‑o Piɛri 'pegee Zaan 'siile, 'bhɛɛ‑ 'ke ‑wa pele‑ 'mu ni dɔɔ 'mu 'laa Zesu 'tɔ 'ɛ 'kanlɛ‑ mɛɛ 'kedo‑ 'kpɔ ni 'ezin‑ 'sekeseke, 'bhɛ 'pegee 'mu 'laa mɛɛ 'kedo‑ 'kpɔ daanlɛ 'yee‑ Zesu 'tɔ 'ɛ 'yi 'ezin‑ ‑titi. ");
INSERT INTO moa_vpl VALUES ("AC4_19","074_4_19","ACT","4","19","19","'Bhɛ klɛle 'tɛ, 'ke Piɛri 'pegee Zaan 'a zikpale ‑o ni dɔɔ: «'Ka 'gbu 'bhɛ ‑glin doo, ‑za 'lrele‑ ‑le 'bhɛ 'le ‑Waanbhaa' ‑yrɛyi' 'ke 'o 'ka mu 'gbu zru maza klɛ, 'bhɛɛ‑ 'woo ‑baŋgo' 'yee‑ ‑Waanbhaa' 'gbu a pɛ zru maza klɛle 'yi ɛɛ? ");
INSERT INTO moa_vpl VALUES ("AC4_20","074_4_20","ACT","4","20","20","Wlan 'gbu 'ɛ ni, 'o mɔɔ ‑za 'la ꞊ya Zesu 'kɔɔ, 'bhɛ 'pegee 'o ‑jan 'la ꞊maa ‑a ‑lii, 'waa sɔ 'o tagale 'mu ta.» ");
INSERT INTO moa_vpl VALUES ("AC4_21","074_4_21","ACT","4","21","21","'Bhɛ klɛle 'tɛ 'ke 'woo‑ Zuufu ‑kuŋlii mu 'ɛ 'pegee ‑waa' 'gwlaan‑ gblaan mu 'ɛ ‑gblaan 'klale Piɛri 'pegee Zaan 'yi 'ezin‑, 'bhɛɛ‑ 'ke ‑o 'ploole 'mu ma. ‑Amasrɔyi ‑o ‑yaa nu ‑o 'krowole gɔnɛ‑ 'la gbɛɛn‑, waa ‑yaa 'bhɛ dɔ. 'Bhɛɛ‑ ‑o ‑yaa ‑gblaan 'zi ‑waa' mɛɛ mu 'ɛ 'lɛɛ, ‑amasrɔyi mɔkpɛn' 'yaa ‑Waanbhaa' 'tɔbhɔ zii' ‑e 'sɔle‑ maza 'la 'bhɛ ꞊kla 'bhɛ ‑zayi'. ");
INSERT INTO moa_vpl VALUES ("AC4_22","074_4_22","ACT","4","22","22","'Bhɛɛ‑ mɛɛ 'la zan ‑bheela Zesu a 'sɔleya 'ɛ ma, 'bhɛ lɛɛ ‑lii ‑yaa kan lɛɛ mia plɛ ta. ");
INSERT INTO moa_vpl VALUES ("AC4_23","074_4_23","ACT","4","23","23","‑O 'ploole Piɛri 'pegee Zaan ma 'tɛ, 'ke 'mu gele‑ 'tɛnlɛ‑ Zesu a ‑klaŋlanɛ ‑vin mu 'ɛ ma. 'Bhɛɛ‑ 'sraka 'lɛna ‑kuŋlii mu 'ɛ 'pegee 'gwlaan‑ gblaan mu 'ɛ ‑jan mu 'la ꞊woa ‑o ni, 'ke ‑o 'mu 'kpɛn 'yigɔɔnle 'mu ni. ");
INSERT INTO moa_vpl VALUES ("AC4_24","074_4_24","ACT","4","24","24","'Bhɛ klɛle 'tɛ, 'woo‑ Zesu 'yi mu 'ɛ 'bhɛ ‑jan mu 'ɛ 'male‑, 'ke ‑o 'kpɛn ‑o 'seriwole 'sanle ‑Waanbhaa' ni ‑o zru do 'le 'ke ‑wa pe dɔɔ: «Mɛɛzan ‑Waanbhaa', 'bhi 'la 'bhi laflɛ' 'pegee 'trɛ, 'bhɛɛ‑ wɛyi‑ 'pegee 'bhɛ ba pɛ mu 'kpɛn ꞊kla, ");
INSERT INTO moa_vpl VALUES ("AC4_25","074_4_25","ACT","4","25","25","'Bhi ‑le ꞊kaan Lii 'Weŋ 'ɛ ba, 'bhɛɛ‑ 'e ‑jan ꞊kpaa 'o ‑gbɔɔ Davidi, 'yaa‑ yewonɛ 'ɛ 'lii dɔɔ: ‹‑Mɛle ꞊kla 'bhɛɛ‑ 'si 'bhɛɛke mu 'ɛ ‑woo gbu magbaandɛ ma jan mu wo zii' ɛɛ? 'Bhɛɛ‑ ‑mɛle ꞊kla 'bhɛɛ‑ ‑o 'kpeejan‑ mu 'ɛ ‑woo 'eyɔɔle ‑gee' ɛɛ? ");
INSERT INTO moa_vpl VALUES ("AC4_26","074_4_26","ACT","4","26","26","'Trɛ ta ‑bhleŋgbe mu 'ɛ 'kpɛn 'wlɛnna‑, 'bhɛɛ‑ 'trɛ ta ‑kuŋlii mu 'ɛ 'kpɛn ‑o zibwa‑ Mɛɛzan ‑Waanbhaa' 'pegee ‑e 'yee‑ 'la makwan‑ 'ke 'bhɛ ‑o 'ke Mɛɛ ‑Bhee Mi Krisi 'ɛ 'le bhe 'bhɛ ma ɛɛ?›» ");
INSERT INTO moa_vpl VALUES ("AC4_27","074_4_27","ACT","4","27","27","'Bhɛɛ‑ ‑wa ꞊pia 'ezin‑ dɔɔ: «‑Amasrɔyi wlan 'gbu 'ɛ ni, ‑bhleŋgbe Erɔdi 'pegee ‑janmatii Pɔnsi Pilati, 'bhɛɛ‑ 'si 'bhɛɛke mu 'ɛ, 'bhɛ 'pegee Izraɛli mu 'ɛ ‑o 'kpɛn 'a ꞊kpaa do ma ‑wa 'lɛɛ‑ ta ‑gɛ; 'bhɛɛ‑ ‑woo zibwa‑ Zesu ma, 'yaa‑ yewonɛ 'weŋ Zesu 'la 'ya makwan‑ 'bhii Mɛɛ ‑Bhee Mi Krisi 'le bhe. ");
INSERT INTO moa_vpl VALUES ("AC4_28","074_4_28","ACT","4","28","28","'Bhɛ ya 'ɛ 'yi, 'yaa‑ ‑glɔɔya' 'ɛ ma, 'bhɛ 'pegee 'e 'gbu ‑za yɛkɛ‑ 'la 'lɛdulaa gban 'e 'gbu zru ma 'elwale ‑sɔ, ‑o 'bhɛɛ‑ ‑za 'ɛ ꞊kla. ");
INSERT INTO moa_vpl VALUES ("AC4_29","074_4_29","ACT","4","29","29","'Bhɛɛ‑ ‑zɔn, Mɛɛzan ‑Waanbhaa', ‑woo' ‑gblaan 'la 'kla zii' 'o 'yi bhe, 'bhɛ ‑glin doo; 'bhɛla‑ ‑yile ‑a klɛ 'bhɛɛ‑ 'yaa‑ yewonɛ mu 'ɛ ‑o 'yaa‑ ‑jan 'ɛ 'wo 'ke ‑gblaan 'laa klɛ ‑o ‑yi. ");
INSERT INTO moa_vpl VALUES ("AC4_30","074_4_30","ACT","4","30","30","'Yaa‑ ‑glɔɔya' 'ɛ tazrɔn, 'kooko‑ mɛɛ mu sɔ ‑bheele', 'bhɛɛ‑ 'ke 'sɔle‑ maza mu 'pegee 'kpeelɛni maza mu 'ɛ 'kpɛn ‑glɔɔn sɔ klɛle‑ 'yaa‑ yewonɛ 'weŋ Zesu 'tɔ 'ɛ 'yi.» ");
INSERT INTO moa_vpl VALUES ("AC4_31","074_4_31","ACT","4","31","31","Zesu 'yi mu 'ɛ 'yanle‑ 'bhɛ 'seri 'ɛ klɛlele, ‑o ꞊klaa 'eke‑ ba yrɛ 'la ꞊nɔɔ, 'ke 'bhɛ yrɛ 'ɛ 'trɛ 'ɛ bɛɛnle‑. 'Bhɛ klɛle 'te, 'ke Lii 'Weŋ 'ɛ zinale ‑o ta, 'bhɛɛ‑ 'ke ‑o 'kpɛn 'pale 'ke 'bhɛ 'le. 'Bhɛɛ‑ ‑o ‑Waanbhaa' a ‑jan 'ɛ 'wole‑ ‑saan ‑o zru ba ‑dɔɔ 'le. ");
INSERT INTO moa_vpl VALUES ("AC4_32","074_4_32","ACT","4","32","32","Zesu 'yi mu 'ɛ 'kpɛn ‑bɛŋgole ‑yaa ‑za do ma, 'bhɛɛ‑ ‑o zru ‑yaa do, 'bhɛ 'pegee‑ ‑o 'kpeejan‑ ‑yaa do. ‑O do 'kpɔ 'laa ‑yaa 'bhɛ 'kɔɔpɛ‑ mu 'ɛ kun 'bhii‑ 'bhɛ do ‑kplɛn ‑a pɛ 'le. 'Duŋ‑ ‑o ‑yaa ‑o 'kɔɔpɛ‑ mu 'ɛ 'yiciɛn‑ 'eke‑ ma do do. ");
INSERT INTO moa_vpl VALUES ("AC4_33","074_4_33","ACT","4","33","33","Zesu a *winbɔwo mu 'ɛ ‑yaa Mɛɛzan Zesu bweza gale ba 'ɛ 'bhɛ ‑jan 'ɛ 'wo zii' ‑glɔɔya' ‑gbɛnɛ 'le ‑o ‑yi. 'Bhɛɛ‑ ‑Waanbhaa' a 'duma ‑gbɛnɛ ꞊yaa ‑o 'kpɛn ta. ");
INSERT INTO moa_vpl VALUES ("AC4_34","074_4_34","ACT","4","34","34","‑O do 'kpɔ gbɛ laa ‑yaa kanaa' ‑o maza ‑yaa dɔ pɛ yɛkɛ‑ 'la ma 'bhɛ ba. ‑Amasrɔyi, gba 'pegee 'fɛ mu ‑yaa ‑o 'kɛ mu 'la 'kɔɔ, 'bhɛ mu ‑yaa 'mu gɔn 'bhɛɛ‑ ‑o ‑yaa nu 'mu ma ‑gɔli' 'ɛ 'le. ");
INSERT INTO moa_vpl VALUES ("AC4_35","074_4_35","ACT","4","35","35","'Bhɛɛ‑ ‑o ‑yaa 'bhɛ ‑gɔli' 'ɛ kpa Zesu a 'winbɔwo mu 'ɛ 'kɔɔ. 'Bhɛɛ‑ 'mu ꞊yaa 'bhɛ ‑gɔli' 'ɛ 'yiciɛn‑ o 'kpɛn ma do do, 'ke 'bhɛ ‑bɛŋgo' ‑o maza ‑yaa ‑gɔli' yɛkɛ‑ 'la ma, 'bhɛ 'le. ");
INSERT INTO moa_vpl VALUES ("AC4_36","074_4_36","ACT","4","36","36","'Bhɛ 'yi, ‑o ‑yaa ‑o pleŋ‑ mɛɛ do sii Zozɛfu, 'bhɛ 'yaa‑ 'ke Levi 'srɛ mu 'ɛ do 'le; 'bhɛɛ‑ 'bhɛ 'yaa‑ da Sipru. Zesu a 'winbɔwo mu 'ɛ ‑o 'bhɛ mɛɛ 'ɛ 'tɔkpaa‑ Banabasi, ('bhɛ 'yi ‑le dɔɔ: mɛɛ 'la zan zruwla mɛɛ 'kpee). ");
INSERT INTO moa_vpl VALUES ("AC4_37","074_4_37","ACT","4","37","37","Banabasi 'bhɛ a gba 'ɛ gɔnle‑, 'kee‑ gele‑ 'bhɛ ma ‑gɔli' 'ɛ 'kpalɛ‑ Zesu a 'winbɔwo mu 'ɛ 'kɔɔ. ");
INSERT INTO moa_vpl VALUES ("AC5_1","074_5_1","ACT","5","1","1","‑O ‑yaa mɛɛ do sii Ananiasi, 'bhɛɛ‑ ‑o ‑yaa ‑a na sii Safira. ‑O ‑waa pɛ gba do ‑gwan. ");
INSERT INTO moa_vpl VALUES ("AC5_2","074_5_2","ACT","5","2","2","'Duŋ‑ 'yee‑ 'pegee ‑a na Safira ‑bɛŋgwa do ma, 'bhɛɛ‑ ‑o ‑waa' gba 'ɛ ma ‑gɔli' 'ɛ 'lɛdo‑ magaanna. 'Bhɛ blaan, 'ke 'yee‑ Ananiasi gele‑ 'bhɛ ‑gɔli' 'ɛ 'lɛ ‑vindo' 'ɛ 'nalɛ‑ Zesu a 'winbɔwo mu 'ɛ ni. ");
INSERT INTO moa_vpl VALUES ("AC5_3","074_5_3","ACT","5","3","3","'Bhɛ klɛle 'tɛ, 'ke Piɛri 'a 'lrɔkpale dɔɔ: «Ananiasi, ‑mɛle ꞊kla 'bhɛɛ‑ 'ya ꞊twa 'ke ‑Setran' 'e zru 'ɛ pa 'ke 'kpeejan‑ ‑yɔɔ' 'te 'le, 'bhɛɛ‑ 'e 'yaa‑ gba 'ɛ ma ‑gɔli' 'ɛ 'lɛdo‑ ‑gaanna, 'bhɛɛ‑ 'e ꞊nwa bhla pelɛ Lii 'Weŋ 'ɛ ni 'bhɛ gbɛɛn‑ ‑gee' bhe ɛɛ? ");
INSERT INTO moa_vpl VALUES ("AC5_4","074_5_4","ACT","5","4","4","'Yaa 'yaa‑ gba 'ɛ gɔnlɛ ‑li 'waati 'la ba, 'yaa‑ pɛ ‑le ‑yaa 'kɛle‑, 'bhɛɛ‑ 'ya gɔnlawoa 'yaa‑ pɛ ‑le ‑yaa 'ke ‑a ma gɔli' 'ɛ 'le 'ezin‑. ‑Mɛle ‑kla 'bhɛɛ‑ 'e 'bhɛ ‑za 'yɔɔ‑ ‑glɔɔn 'lɛɛ‑ ꞊kpaa 'e 'kpee ɛɛ? 'Duŋ‑ ‑a 'yaango‑ 'bhii‑ 'yaa bhla pelɛ bhaaplɛŋ mu ni, 'duŋ‑ 'ya ꞊pia ‑Waanbhaa' ‑la ni.» ");
INSERT INTO moa_vpl VALUES ("AC5_5","074_5_5","ACT","5","5","5","Ananiasi 'bhɛ ‑jan mu 'ɛ 'male‑ 'tɛ, 'kee‑ baale', 'bhɛɛ‑ 'kee‑ klɛle‑ 'ke 'siɛle. 'Bhɛ klɛle 'tɛ, mɛɛ 'la zan mu 'kpɛn 'a gaza 'ɛ ꞊maa, 'ke ‑gblaan ‑gbɛnɛ do 'klale 'mu 'kpɛn 'yi. ");
INSERT INTO moa_vpl VALUES ("AC5_6","074_5_6","ACT","5","6","6","'Bhɛ ya 'ɛ 'yi, 'ke ‑zwannɛ mu 'ke mu ‑wlɛnle', 'bhɛɛ‑ 'ke 'mu sɔ 'kpale 'yee‑ Ananiasi gbaa 'ɛ ma, 'bhɛɛ‑ 'ke 'mu gele‑ ‑a binlɛ. ");
INSERT INTO moa_vpl VALUES ("AC5_7","074_5_7","ACT","5","7","7","'Bhɛ blaan 'lɛrɛ yaga 'kanle‑, 'ke ‑a na Safira 'nule‑ wlalɛ Zesu a 'winbɔwo mu 'ɛ ta 'bhɛ 'fɛ 'ɛ ꞊la; 'duŋ‑ ‑za 'la 'bhɛ ꞊kla ‑a ‑nɔɔ ni yaa ‑yaa 'bhɛ dɔ. ");
INSERT INTO moa_vpl VALUES ("AC5_8","074_5_8","ACT","5","8","8","‑Ayile, 'ke Piɛri 'a 'lrɔkpale dɔɔ: «Safira, wlan 'gbu 'ɛ a ni, 'ka 'kaa‑ gba 'ɛ ‑gwan ‑gɔli' 'lii yɛkɛ‑ 'lɛɛ‑ 'bhɛɛ‑ 'le ɛɛ?» 'Bhɛ klɛle 'tɛ, 'ke ‑ya pele‑ Piɛri ni dɔɔ: «‑Aani', 'wa ‑gwan 'bhɛ ‑gɔli' 'lii yɛkɛ‑ 'la bhe 'bhɛɛ‑ 'le.» ");
INSERT INTO moa_vpl VALUES ("AC5_9","074_5_9","ACT","5","9","9","'Bhɛ klɛle 'tɛ, 'ke Piɛri 'a 'pele ‑a ni dɔɔ: «‑Mɛle ꞊kla 'bhɛɛ‑ 'ka mɛɛ plɛ 'a ꞊kpaa do ma dɔɔ 'ka ‑o Mɛɛzan Lii 'Weŋ 'ɛ 'yidanle ɛɛ? 'E 'yrɛkpa laale doo, mɛɛ 'la zan mu ‑ja 'e ꞊nɔɔ 'ɛ binlɛ 'wo ‑la dulale ‑o 'fɛ 'ɛ 'lii bhe. ‑O nu gelɛ 'bhi 'le 'ezin‑.» ");
INSERT INTO moa_vpl VALUES ("AC5_10","074_5_10","ACT","5","10","10","'Bhɛ 'yi 'tɛ, 'kee‑ baale' 'bhɛ 'yrɛ do 'kpɔ 'ɛ ꞊nɔɔ bhe Piɛri gaan ma, 'bhɛɛ‑ 'kee‑ klɛle‑ 'ke siɛle'. 'Bhɛ ꞊nɔɔ bhe, 'ke ‑zwannɛ mu 'ɛ ‑o wlale‑ 'fɛ 'ɛ ꞊la, 'bhɛɛ‑ 'ke ‑wa gbaa 'ɛ 'yele; 'bhɛɛ‑ 'ke ‑o gele‑ ‑a binlɛ ‑a ‑nɔɔ ‑din. ");
INSERT INTO moa_vpl VALUES ("AC5_11","074_5_11","ACT","5","11","11","Zesu 'yi mu ‑lɛdo' 'ɛ 'kpɛn 'pegee mɛɛ 'la zan mu 'kpɛn 'bhɛ ‑za mu 'ɛ klɛza ‑maa, ‑gblaan ‑gbɛnɛ ꞊klaa 'mu 'kpɛn 'yi. ");
INSERT INTO moa_vpl VALUES ("AC5_12","074_5_12","ACT","5","12","12","Zesu a 'winbɔwo mu 'ɛ ‑yaa 'sɔle maza ‑bebe 'pegee 'kpeelɛni maza mu klɛ 'zi ‑waa' 'si mu 'ɛ 'pleŋ. Zesu 'yi mu 'ɛ 'kpɛn 'klale‑ ‑yaa 'eke‑ ba ‑Waanbhaa' Gba 'Fɛ ‑Gbɛnɛ 'ɛ ꞊la yrɛ 'la ‑o ‑yaa 'bhɛ sii: ‹‑Bhleŋgbe Salomɔ a 'wlaŋla› 'ɛ 'bhɛɛ‑ ꞊la. ");
INSERT INTO moa_vpl VALUES ("AC5_13","074_5_13","ACT","5","13","13","Yaa ‑yaa dɔ mɛɛ ‑bhɛɛke' 'kpee 'ke 'bhɛ kpa ‑o ba, 'duŋ‑ mɛɛ mu 'ɛ 'kpɛn 'yaa‑ ‑o 'tɔ wlan pe 'zi 'ke ‑o ‑gasikpa ‑o ‑lɛɛ. ");
INSERT INTO moa_vpl VALUES ("AC5_14","074_5_14","ACT","5","14","14","Yi 'oo yi, 'gwlaan‑ ‑bebe 'pegee le ‑bebe mu 'la 'yaa‑ ‑o 'kpa Mɛɛzan 'yi, 'mu 'yaa‑ klɛ 'zi Zesu 'yi mu 'ɛ baan' 'le. ");
INSERT INTO moa_vpl VALUES ("AC5_15","074_5_15","ACT","5","15","15","‑Asiikɔɔ mɛɛ mu 'ɛ 'yaa‑ nu 'zi ‑waa' gadɛ mu 'ɛ 'le ‑gbleba mu 'ɛ ta, 'bhɛɛ‑ ‑o ‑yaa 'mu kpa ‑saa mu 'pegee yilapɛ mu 'ɛ ta. 'Kooko‑ 'ke Piɛri 'kan bhla zi, 'ali‑ 'kee‑ ‑yaa sɔ ‑a gbɛ 'kpale 'bhɛ gadɛ mu 'ɛ ma, 'bhɛ 'pegee 'ke ‑a lii 'ɛ 'yaa‑ sɔ 'klale 'mu 'ke ta, 'mu 'yaa sɔ ‑bheele'. ");
INSERT INTO moa_vpl VALUES ("AC5_16","074_5_16","ACT","5","16","16","‑Zamaa' 'saa 'yaa‑ da 'zi 'ezin‑ Zeruzalɛmu kpɛ ma ‑wa ‑vin mu 'ɛ ta, 'Bhɛɛ‑ ‑o ‑yaa nu 'zi ‑waa' gadɛ mu 'pegee lii ‑yɔɔ mu ‑yaa mɛɛ 'la zan mu zi 'mu 'kpɛn 'le Zeruzalɛmu Zesu a 'winbɔwo mu 'ɛ ta, 'bhɛɛ‑ 'mu 'kpɛn 'yaa‑ ‑bhee 'zi. ");
INSERT INTO moa_vpl VALUES ("AC5_17","074_5_17","ACT","5","17","17","'Bhɛɛ‑ 'duŋ‑, *'sraka 'lɛna ‑kuŋlii gblaan 'ɛ 'pegee ‑a zi mu 'la 'kpɛn 'yaa‑ 'ke *Saduse mɛɛ mu 'le, ‑o zranwoa‑ Zesu a 'winbɔwo mu 'ɛ ba 'mu klɛza mu 'ɛ ‑zayi'. ");
INSERT INTO moa_vpl VALUES ("AC5_18","074_5_18","ACT","5","18","18","'Bhɛla‑ ‑yile, 'ke ‑o 'mu 'kunle, 'bhɛɛ‑ ‑o 'mu ꞊bwa ‑waa' ‑kaso 'fɛ ‑gbɛnɛ 'ɛ ꞊la. ");
INSERT INTO moa_vpl VALUES ("AC5_19","074_5_19","ACT","5","19","19","'Duŋ‑ ‑bi 'ɛ zi, Mɛɛzan ‑Waanbhaa' a ‑mlɛkɛ' 'ɛ do ‑ja ‑kaso 'fɛ 'ɛ 'liigolɛ, 'bhɛɛ‑ 'bhɛ Zesu a 'winbɔwo mu 'ɛ 'pwɛla‑. 'Bhɛɛ‑ 'ke ‑ya pele‑ 'mu ni dɔɔ: ");
INSERT INTO moa_vpl VALUES ("AC5_20","074_5_20","ACT","5","20","20","«‑Ka ge ‑Waanbhaa' Gba 'Fɛ ‑Gbɛnɛ 'ɛ ꞊la, 'bhɛɛ‑ bole ‑yrɛ ma ‑si drɛɛ 'ɛ ba jan ‑o 'kɛla 'le, ‑ka 'bhɛ 'kpɛn 'wo mɛɛ mu 'ɛ ni.» ");
INSERT INTO moa_vpl VALUES ("AC5_21","074_5_21","ACT","5","21","21","'Bhɛ 'yi 'ɛ zrwan 'tutu 'ɛ zi, ‑mlɛkɛ' 'ɛ ‑jan 'la ꞊woa 'yee‑ Zesu a 'winbɔwo mu 'ɛ ni, 'ke ‑o 'bhɛ klɛle‑. ‑Ayile 'ke ‑o gele‑ ‑Waanbhaa' Gba 'Fɛ ‑Gbɛnɛ 'ɛ ꞊la, 'bhɛɛ‑ 'ke ‑o mɛɛ mu 'ɛ daanle 'sanle. 'Sraka 'lɛna ‑kuŋlii gblaan 'ɛ 'pegee ‑yaa' yewoyɔɔn mu 'ɛ ꞊nwa ‑waa' 'klaŋkeba yrɛ 'ɛ ꞊nɔɔ; 'bhɛɛ‑ ‑o Zuufu mu 'ɛ ‑waa' 'gwlaan‑ gblaan mu 'ɛ 'pegee ‑waa' 'kitikan mu 'ɛ 'kpɛn 'lɛkpaa‑ 'eke‑ ta. 'Bhɛɛ‑ 'ke ‑o mɛɛ mu winbɔle Zesu a 'winbɔwo mu 'ɛ 'siiyrɛ‑ nɔɔ‑ ‑kaso 'fɛ 'ɛ ꞊la. ");
INSERT INTO moa_vpl VALUES ("AC5_22","074_5_22","ACT","5","22","22","'Duŋ‑ 'bhɛ mu bhɔle ‑kaso 'fɛ 'ɛ ꞊la, 'mu 'laa Zesu a 'winbɔwo mu 'ɛ 'yelɛ‑ 'bhɛ ꞊nɔɔ. 'Bhɛ klɛle 'tɛ, 'ke 'mu nule‑ 'bhɛ 'pelɛ‑ 'woo‑ 'kitikan mɛɛ ‑lɛdo' 'ɛ ni. ");
INSERT INTO moa_vpl VALUES ("AC5_23","074_5_23","ACT","5","23","23","‑O pe dɔɔ: «'O gelawoa, 'o ‑kaso 'fɛ 'lii 'ɛ 'tanle‑ ꞊ya 'elrele, 'bhɛɛ‑ ‑a gooba ‑srwase' mu 'ɛ dulale ‑yaa 'mu dulayrɛ mu 'ɛ ꞊nɔɔ ‑kaso 'fɛ 'ɛ 'lii mu 'ɛ ꞊nɔɔ. 'Duŋ‑ 'o ‑kaso 'fɛ 'ɛ 'liigole, 'waa mɛɛ 'kedo‑ 'kpɔ yelɛ ‑a ꞊la.» ");
INSERT INTO moa_vpl VALUES ("AC5_24","074_5_24","ACT","5","24","24","'Bhɛ klɛle 'tɛ, ‑Waanbhaa' Gba 'Fɛ ‑Gbɛnɛ 'ɛ gooba ‑srwase' mu 'ɛ ‑kuŋlii 'ɛ 'pegee 'sraka 'lɛna mu ‑kuŋlii mu 'ɛ, ‑o 'bhɛ ‑jan 'ɛ 'male‑, 'ke ‑o zrubatɛdɔle ‑o ma Zesu a 'winbɔwo mu 'ɛ ‑zayi'; 'bhɛɛ‑ 'ke ‑woo 'eke‑ ‑lrɔkpale dɔɔ: «'O nu 'bhɛ ‑za 'lɛɛ‑ 'kpalɛ‑ 'nale‑ ‑a ma ɛɛ?» ");
INSERT INTO moa_vpl VALUES ("AC5_25","074_5_25","ACT","5","25","25","'Bhɛ 'waati do 'kpɔ 'ɛ ba, 'ke mɛɛ do nule‑ ‑a pelɛ ‑o ni dɔɔ: «‑Ka dula‑ doo! 'Ka mɛɛ 'la zan mu ꞊bwa ‑kaso 'yi, ‑woo mɛɛ mu daan 'zi ‑Waanbhaa' Gba 'Fɛ ‑Gbɛnɛ 'ɛ ꞊la.» ");
INSERT INTO moa_vpl VALUES ("AC5_26","074_5_26","ACT","5","26","26","'Bhɛ klɛle 'tɛ, 'ke ‑Waanbhaa' Gba 'Fɛ ‑Gbɛnɛ 'ɛ gooba ‑srwase' ‑kuŋlii 'ɛ 'pegee ‑srwase' 'ɛ 'ke mu gele‑ Zesu a 'winbɔwo mu 'ɛ 'kunyrɛ‑ nɔɔ‑. 'Duŋ‑ waa ‑o 'kunlɛ‑ faŋgan‑ ma, ‑amasrɔyi ‑o ‑yaa ‑gblaan 'zi ‑waa' mɛɛ mu 'ɛ 'lɛɛ 'kaa 'mu 'laa nu ‑wlɛnlɛ' ‑o ma 'bhɛɛ‑ 'mu kpoti pa ‑o ma. ");
INSERT INTO moa_vpl VALUES ("AC5_27","074_5_27","ACT","5","27","27","‑O nule 'ke ‑o ‑le ‑waa' Zuufu mu a 'kitikan mɛɛ ‑lɛdo' 'ɛ ta, 'ke 'sraka 'lɛna ‑kuŋlii gblaan 'ɛ 'bhɛ ‑o ‑lrɔkpale 'sanle dɔɔ: ");
INSERT INTO moa_vpl VALUES ("AC5_28","074_5_28","ACT","5","28","28","«'Waa mazapɛlɛ 'ka ni kpataakpa 'elwale dɔɔ 'ka 'laa mɛɛ 'kedo‑ 'kpɔ daanlɛ 'ezin‑ 'sekeseke 'yee‑ Zesu 'tɔ 'ɛ 'yi ɛɛ? 'Bhɛɛ‑ 'duŋ‑, 'ka 'yaan‑ Zeruzalɛmu ‑wa 'ɛ ta mu 'ɛ 'kpɛn ŋgblo 'siɛlele gban 'kaa‑ mɛɛ daangbɛya 'ɛ 'le, 'bhɛɛ‑ 'kaa‑ zi 'bhii‑ 'ka 'yee‑ Zesu dɛza 'ɛ 'tɔkpa‑ 'o mɔɔ ‑la ma.» ");
INSERT INTO moa_vpl VALUES ("AC5_29","074_5_29","ACT","5","29","29","'Bhɛ klɛle 'tɛ, 'ke Piɛri 'pegee Zesu a 'winbɔwo mu ‑vin mu 'ɛ ‑wa pele‑ ‑o ni dɔɔ: «'O ‑Waanbhaa' ‑la zru maza klɛ taa‑ bhaaplɛŋ mu ɛɛ? ");
INSERT INTO moa_vpl VALUES ("AC5_30","074_5_30","ACT","5","30","30","'Ka 'yee‑ Zesu 'la ‑gbaanna ‑yrigbɛɛle 'ɛ ta, 'bhɛɛ‑ 'kaa ꞊dia, 'o ‑gbɔɔ mu a ‑Waanbhaa' 'ɛ 'yela‑ ‑bwela gale ba. ");
INSERT INTO moa_vpl VALUES ("AC5_31","074_5_31","ACT","5","31","31","'Bhɛɛ‑ ‑Waanbhaa' a ‑glɔɔya' 'ɛ ma, ‑e Zesu 'lɛdwa‑ ‑a ma 'egbɛnɛle. 'Bhɛɛ‑ ‑ya ‑lawlɛnna laanima, 'ke ‑ya klɛle‑ 'ke pɛ 'kpɛn 'wiiŋ‑ mi ‑gbɛnɛ 'le, 'bhɛ 'pegee Mɛɛ ‑Bhee Mi 'le, 'kooko‑ Izraɛli mu 'ɛ ploo waa ‑za 'yɔɔ‑ mu 'ɛ ma, 'bhɛɛ‑ ‑woo 'gbu na ‑Waanbhaa' ni; 'bhɛɛ‑ 'bhɛ ‑waa' ‑za 'yɔɔ‑ mu 'ɛ ‑sroma yan. ");
INSERT INTO moa_vpl VALUES ("AC5_32","074_5_32","ACT","5","32","32","'Bhɛ ‑za mu 'ɛ ꞊kla 'o mɔɔ 'gbu ‑la 'yrɛ ma, 'bhɛɛ‑ 'o mɔɔ 'gbu 'pegee ‑Waanbhaa' Lii 'Weŋ 'ɛ 'o mɔɔ ‑le 'bhɛ ‑za mu 'ɛ 'srɛ 'le; ‑Waanbhaa' 'bhɛ Lii 'Weŋ 'ɛ ꞊naa mɛɛ 'la zan mu ‑yaa' jan mu 'ɛ 'klɔsikun 'mu ‑la ni.» ");
INSERT INTO moa_vpl VALUES ("AC5_33","074_5_33","ACT","5","33","33","'Woo‑ Zuufu mu a 'kitikan mɛɛ ‑lɛdo' 'ɛ ‑o 'bhɛ ‑jan 'ɛ 'male, ‑o zruplii‑ gbɛ ‑yɔɔ' 'ɛ 'kɔɔ, 'ke ‑wa pele‑ dɔɔ ‑o Zesu a *winbɔwo mu 'ɛ dɛle‑. ");
INSERT INTO moa_vpl VALUES ("AC5_34","074_5_34","ACT","5","34","34","'Duŋ‑ Farizi mi do ‑yaa ‑o ba, ‑o ‑yaa 'bhɛ sii Gamaliɛli. 'Bhɛ 'yaa‑ 'ke 'Toŋ daan mi ‑gbɛnɛ do ‑la ‑le, 'bhɛɛ‑ mɔkpɛn' 'yaa‑ ‑gasikpa 'bhɛ 'lɛɛ. 'Yee‑ Gamaliɛli 'e 'wlɛnle‑ 'tɛ ‑o pleŋ‑ 'ke ‑ya pele‑ dɔɔ ‑o Zesu a 'winbɔwo mu 'ɛ 'pwɛ 'pɛɛlii‑ 'waati sa 'pe. ");
INSERT INTO moa_vpl VALUES ("AC5_35","074_5_35","ACT","5","35","35","‑O yanle ‑o 'pwɛlele, 'ke 'yee‑ Gamaliɛli 'a 'pele ‑waa' Zuufu mu a 'kitikan mɛɛ ‑lɛdo' 'ɛ ni dɔɔ: «'Ŋ nɛɛnɛ‑ Izraɛli mu, 'ka ‑o zan ‑za 'la klɛlɛ 'woo‑ mɛɛ mu 'lɛɛ‑ ni, ‑ka 'ka 'yrɛkpa 'ka 'gbu ba 'elrele. ");
INSERT INTO moa_vpl VALUES ("AC5_36","074_5_36","ACT","5","36","36","'Bhɛ ꞊nɔɔ 'laa ‑mɔlɛ' ‑li, 'bhɛɛ‑ mɛɛ do ‑pwɛla ‑a ‑yi, ‑o ‑yaa 'bhɛ sii Tedasi, 'bhɛɛ‑ 'bhɛ 'yaa‑ 'bhɛ 'gbu klɛ 'zi 'ke mɛɛ gblaan do ‑la ‑le. Mɛɛ ‑kɛmɛ yiziɛ yɛkɛ‑ dɔle ‑yaa zi. 'Duŋ‑, 'bhɛ ꞊nɔɔ 'laa ‑mɔlɛ' 'ke ‑wa dɛle‑. 'Bhɛɛ‑ mɛɛ 'la zan mu 'kpɛn 'yaa‑ zi, 'mu 'kpɛn 'kaan‑ 'eke‑ ma; 'bhɛɛ‑ 'bhɛ ‑za 'ɛ ꞊kla 'ke bhaama ‑za 'le. ");
INSERT INTO moa_vpl VALUES ("AC5_37","074_5_37","ACT","5","37","37","Tedasi blaan, ‑o ‑yaa ‑kɔɔ' 'nɔɔ zii' 'waati 'la ba, 'ke mɛɛ ‑bhɛɛke' do 'pwɛle ‑a ‑yi: ‑o ‑yaa 'bhɛ sii Zudasi, 'bhɛ ‑yaa da Galile 'trɛ ta. 'Bhɛ mɛɛ ‑bebe ꞊klaa 'bhɛ zi yakla‑ ma; 'bhɛ 'duŋ‑ ‑gaa 'ezin‑. ‑A gale blaan, ‑a zi mu 'ɛ 'kpɛn 'kaan‑ 'eke‑ ma. ");
INSERT INTO moa_vpl VALUES ("AC5_38","074_5_38","ACT","5","38","38","'Mi pe 'ka ni ‑zɔn dɔɔ ‑ka 'woo‑ mɛɛ mu 'la bhe ‑o 'to 'srɔ, 'bhɛɛ‑ ‑ka 'ploo ‑o ma. ‑Amasrɔyi 'ke ‑waa' mɛɛ daangbɛya 'ɛ 'pegee ‑o klɛza mu 'ɛ da bhaaplɛŋ mu ba, waa nu ‑mɔlɛ' 'mu zi. ");
INSERT INTO moa_vpl VALUES ("AC5_39","074_5_39","ACT","5","39","39","'Duŋ‑ 'ke 'mu da 'zi ‑Waanbhaa' ‑la ba, 'ka 'laa nu 'sɔlɛ‑ 'mu 'siɛle. ‑Ka 'ka 'yrɛkpa 'ka 'gbu ba 'elrele, 'ka 'laa klɛlɛ gwledan mu 'le ‑Waanbhaa' ba!» ");
INSERT INTO moa_vpl VALUES ("AC5_40","074_5_40","ACT","5","40","40","'Woo Zuufu mu a 'kitikan mu mɛɛ ‑lɛdo' 'ɛ, ‑o ‑dwa Gamaliɛli 'wojan‑ 'ɛ ꞊la. 'Bhɛ blaan, 'ke ‑o Zesu a 'winbɔwo mu 'ɛ 'siile 'fɛ 'ɛ ꞊la. 'Bhɛɛ‑ ‑woo zita ꞊zwan, 'ke ‑woo ‑lɛmazɔnle‑ dɔɔ waa malɛ 'ezin‑ 'sekeseke dɔɔ ‑woo Zesu 'tɔ 'ɛ 'kan zii' mɛɛ mu ni; 'bhɛɛ‑ ‑o ‑ploola ‑o ma 'tɛ. ");
INSERT INTO moa_vpl VALUES ("AC5_41","074_5_41","ACT","5","41","41","'Bhɛ ya 'ɛ 'yi, 'woo‑ Zesu a 'winbɔwo mu 'ɛ ‑o go bhla 'ɛ zi 'woo‑ Zuufu mu a 'kitikan mu 'ɛ ‑din, ‑o 'kpɛn zrukpaale ‑yaa. ‑Amasrɔyi 'bhɛ ‑gaale' ‑yaa ‑o ba 'ke mɛɛ mu ‑o ‑zwanwo' Zesu 'tɔ 'ɛ ‑zayi'. ");
INSERT INTO moa_vpl VALUES ("AC5_42","074_5_42","ACT","5","42","42","'Bhɛɛ‑ yi 'oo yi, ‑o ‑yaa mɛɛ mu daan ‑Waanbhaa' Gba 'Fɛ ‑Gbɛnɛ 'ɛ ꞊la, 'bhɛ 'pegee yi 'fɛ mu 'ɛ ꞊la. ‑O ‑yaa pe 'zi mɛɛ mu 'ɛ ni dɔɔ Zesu ‑le 'ke Mɛɛ ‑Bhee Mi Krisi 'ɛ 'le. ");
INSERT INTO moa_vpl VALUES ("AC6_1","074_6_1","ACT","6","1","1","'Bhɛ 'waati 'ɛ ba, Zesu a ‑klaŋlanɛ mu 'ɛ baan' 'yaa‑ 'kla zii' ‑o ba. 'Bhɛla‑ ‑yile, Zuufu mu 'la 'yaa‑ Grɛki wli pe, 'bhɛɛ‑ 'ke waa 'mu yalɛ Izraɛli 'klɛɛn 'ɛ 'yi, 'mu 'yaa‑ 'mu 'la ma janwo 'zi Zuufu mu 'la 'yaa‑ Ebre wli pe 'mu ni. ‑O ‑yaa ‑o ‑la ma janwo 'zi ‑amasrɔyi pɛle ‑yiciɛn' bhla 'ɛ ba yi 'oo yi, ‑wa ꞊ya 'bhii‑ ‑o ‑yaa pɛle yɛkɛ‑ 'la na Zuufu Ebre glaanle mu 'ɛ ni, waa ‑yaa 'bhɛ yɛkɛ‑ na ‑waa' pɛ glaanle mu 'ɛ ni. ");
INSERT INTO moa_vpl VALUES ("AC6_2","074_6_2","ACT","6","2","2","'Bhɛla‑ 'yi 'tɛ, 'ke Zesu a 'winbɔwo mu vu ta plɛ 'ɛ, ‑o Zesu a ‑klaŋlanɛ ‑vin mu 'ɛ 'kpɛn 'siile, 'bhɛɛ‑ 'ke ‑wa pele‑ 'mu ni dɔɔ: «'Ke ‑kɔɔ' 'ploola‑ ‑Waanbhaa' a ‑jan 'ɛ 'wole‑ ma, 'bhɛɛ‑ 'ke ‑kɔɔ' ꞊bwa pɛle ‑yiciɛnle ‑janwole ma, 'bhɛ 'laa lele. ");
INSERT INTO moa_vpl VALUES ("AC6_3","074_6_3","ACT","6","3","3","‑Ayile, ‑ka mɛɛ 'srwaplɛ‑ makun' 'ka ba, 'ke 'mu 'taawogbɛya 'ɛ lele, 'bhɛɛ‑ 'ke 'mu 'pale‑ ‑o 'ke Lii 'Weŋ 'ɛ 'le, 'bhɛ 'pegee 'ke 'm