﻿USE sofia;
DROP TABLE IF EXISTS sofia.mnv_vpl;
CREATE TABLE mnv_vpl (
  verseID VARCHAR(16) NOT NULL PRIMARY KEY,
  canon_order VARCHAR(12) NOT NULL,
  book VARCHAR(3) NOT NULL,
  chapter VARCHAR(3) NOT NULL,
  startVerse VARCHAR(3) NOT NULL,
  endVerse VARCHAR(3) NOT NULL,
  verseText TEXT CHARACTER SET UTF8 NOT NULL) ENGINE=MyISAM;
LOCK TABLES mnv_vpl WRITE;
INSERT INTO mnv_vpl VALUES ("MT1_1","070_1_1","MAT","1","1","1","Tenei te hanohano o Jesus Christ, te makupuna o te hakahua ia David, te makupuna o Abraham: ");
INSERT INTO mnv_vpl VALUES ("MT1_2","070_1_2","MAT","1","2","2","Ko Abraham te tamana o Isaac, ko Isaac te tamana o Jacob, ko Jacob te tamana o Judah ma tena 'api. ");
INSERT INTO mnv_vpl VALUES ("MT1_3","070_1_3","MAT","1","3","3","Ko Judah te tamana o Perez ma Zerah, tegaaua tinana ko Tamar. Ko Perez te tamana o Hezron, ko Hezron te tamana o Ram. ");
INSERT INTO mnv_vpl VALUES ("MT1_4","070_1_4","MAT","1","4","4","Ko Ram te tamana o Amminadab, ko Amminadab te tamana o Nahshon, ko Nahshon te tamana o Salmon. ");
INSERT INTO mnv_vpl VALUES ("MT1_5","070_1_5","MAT","1","5","5","Ko Salmon te tamana o Boaz, tona tinana ko Rahab. Ko Boaz te tamana o Obed, tona tinana ko Ruth. Ko Obed te tamana o Jesse. ");
INSERT INTO mnv_vpl VALUES ("MT1_6","070_1_6","MAT","1","6","6","Ko Jesse te tamana o te hakahua ia David, ko David te tamana o Solomon, tena tinana ko te uguugu o Uriah noko hai. ");
INSERT INTO mnv_vpl VALUES ("MT1_7","070_1_7","MAT","1","7","7","Ko Solomon te tamana o Rehoboam, ko Rehoboam te tamana o Abijah, ko Abijah te tamana o Asa. ");
INSERT INTO mnv_vpl VALUES ("MT1_8","070_1_8","MAT","1","8","8","Ko Asa te tamana o Jehoshaphat, ko Jehoshaphat te tamana o Jehoram, ko Jehoram te tamana o Uzziah. ");
INSERT INTO mnv_vpl VALUES ("MT1_9","070_1_9","MAT","1","9","9","Ko Uzziah te tamana o Jotham, ko Jotham te tamana o Ahaz, ko Ahaz te tamana o Hezekiah. ");
INSERT INTO mnv_vpl VALUES ("MT1_10","070_1_10","MAT","1","10","10","Ko Hezekiah te tamana o Manasseh, ko Manasseh te tamana o Amon, ko Amon te tamana o Josiah. ");
INSERT INTO mnv_vpl VALUES ("MT1_11","070_1_11","MAT","1","11","11","Ko Josiah te tamana o Jeconiah ma tena 'api, i na 'aso na kakabe 'ia ai ki Babylon. ");
INSERT INTO mnv_vpl VALUES ("MT1_12","070_1_12","MAT","1","12","12","Nimaa mugi i te kakabe 'aatea 'anga ia te kigatou ki Babylon: ko Jeconiah te tamana o Shealtiel, ko Shealtiel te tamana o Zerubbabel. ");
INSERT INTO mnv_vpl VALUES ("MT1_13","070_1_13","MAT","1","13","13","Ko Zerubbabel te tamana o Abiud, ko Abiud te tamana o Eliakim, ko Eliakim te tamana o Azor. ");
INSERT INTO mnv_vpl VALUES ("MT1_14","070_1_14","MAT","1","14","14","Ko Azor te tamana o Zadok, ko Zadok te tamana o Akim, ko Akim te tamana o Elihud. ");
INSERT INTO mnv_vpl VALUES ("MT1_15","070_1_15","MAT","1","15","15","Ko Elihud te tamana o Eleazar, ko Eleazar te tamana o Matthan, ko Matthan te tamana o Jacob. ");
INSERT INTO mnv_vpl VALUES ("MT1_16","070_1_16","MAT","1","16","16","Ka ko Jacob te tamana o Joseph, te matu'a o Mary. Tenei a Mary na haka haa eia a Jesus, ko Ia na mate te 'Agiki Taga'ia. ");
INSERT INTO mnv_vpl VALUES ("MT1_17","070_1_17","MAT","1","17","17","Te 'atuhano nei noko haka tu'u mai ia Abraham o hetae mai ki te hakahua ia David, noko 'atu anga hugu tuma'a e haa (14), ka te haka tu'u mai 'anga ia David o hetae mai ki te kakabe 'aatea 'anga a Israel ki Babylon noko 'atu anga hugu tuma'a e haa (14), ka te haka tu'u mai 'anga i te kakabe 'aatea 'anga a Israel ki Babylon o hetae mai kia Christ noko 'atu anga hugu tuma'a e haa (14). ");
INSERT INTO mnv_vpl VALUES ("MT1_18","070_1_18","MAT","1","18","18","Noko konei na noho te haka haa o Jesus Christ. Ko te tinana a Mary noko he ahoaho 'aki ma Joseph ke go nonoho. Mugi kigaaua o haka pata 'aki, ka na na'a 'ia ko Mary e hai tama noko agatu'u i te Spirit Tapu. ");
INSERT INTO mnv_vpl VALUES ("MT1_19","070_1_19","MAT","1","19","19","Ka ko tona matu'a a Joseph te tangata tinogaoi, noko he'e siahai ke na'a ngatahi 'ia te hai 'anga nei ke maatiba ai a Mary, ma te hai tena tegeu'a ke manga mau'i ia te ia. ");
INSERT INTO mnv_vpl VALUES ("MT1_20","070_1_20","MAT","1","20","20","Nimaa sigi tena konei na tegeu'a 'anga ki te hai 'anga nei, te ensel o te 'Aitu noko haka 'agi tino kia te ia i te miti o hai atu, “Joseph te makupuna o David, noka tau mataku ki te kakabe ia Mary ki tou manaha ke hai ai mo'ou he uguugu, iteme'agaa tena hai tama 'anga e hai e te Spirit Tapu. ");
INSERT INTO mnv_vpl VALUES ("MT1_21","070_1_21","MAT","1","21","21","Ko Mary nimaa go haka haa ma'ana he tama, e hai ke go haka ingoa e koe ko Jesus, iteme'agaa ko Ia e hai ke go haka ma'ugi ona pegea i ogatou 'oosongo.” ");
INSERT INTO mnv_vpl VALUES ("MT1_22","070_1_22","MAT","1","22","22","Ka na hai 'anga nei noko hai o haka maa'ogi ai nia noko gea ai a te 'Aitu o agatu'u i tona taauga: ");
INSERT INTO mnv_vpl VALUES ("MT1_23","070_1_23","MAT","1","23","23","“Te hahine taupo'ou 'esi'esi e hai ke go hai tama ogo hai ma'ana he tama, e hai ke go mate ko Immanuel, tegaa tena gaataki: Ko God e haka pata kia te kitatou.” ");
INSERT INTO mnv_vpl VALUES ("MT1_24","070_1_24","MAT","1","24","24","Te 'aso na 'aga ai a Joseph, na hai eia nia noko kaunaki e te ensel o te 'Aitu ke hai. Na kakabe mai eia ia Mary ki tona manaha o hai ai tona uguugu. ");
INSERT INTO mnv_vpl VALUES ("MT1_25","070_1_25","MAT","1","25","25","Ko kigaaua koi he'e he na'a 'aki ano hetae ki te guea 'anga a Mary o hai tena tama. O haka ingoa e Joseph ko Jesus. ");
INSERT INTO mnv_vpl VALUES ("MT2_1","070_2_1","MAT","2","1","1","Mugi i te haka haa o Jesus i Bethlehem i te kakai 'anga i Judea, i na 'aso noko manga hakahua ai a Herod, na taangata he 'igo'igo 'aki, noko boomai mai matangi ki Jerusalem. ");
INSERT INTO mnv_vpl VALUES ("MT2_2","070_2_2","MAT","2","2","2","O konei 'agatou he haka anuanu 'aki, “Tehea te tama 'iti'iti kua haka haa ke go hai ai te hakahua mo'o na Jew? E hiina'i kimatou ki tena hetu'u e sopo i matangi, ma te boomai kimatou sogi kia te Ia.” ");
INSERT INTO mnv_vpl VALUES ("MT2_3","070_2_3","MAT","2","3","3","Te gholoba na haka gongo ai a Herod te hakahua ki te hai 'anga nei, koia ma ba'i pegea i Jerusalem na he langalanga 'aki ai ");
INSERT INTO mnv_vpl VALUES ("MT2_4","070_2_4","MAT","2","4","4","Ma te haka putu mai e Herod ba'i priest ma na ako o na tagangonga, o haka anuanu kia te kigatou o hai atu, “Tehea te kunga noko hai ke go haka haa ai te 'Agiki Taga'ia?” ");
INSERT INTO mnv_vpl VALUES ("MT2_5","070_2_5","MAT","2","5","5","Ma te haka tau a kigatou o hai atu, “Noko hai ke go sopo i Bethlehem i te kakai 'anga i Judea, iteme'agaa noko konei na kanukanu ai te taauga: ");
INSERT INTO mnv_vpl VALUES ("MT2_6","070_2_6","MAT","2","6","6","‘Ka kokoe Bethlehem i te kakai 'anga i Judah, e he'e hakagaataki kokoe te mi'i hutiaki i na hutiaki e i-Judah, iteme'agaa e hai ke go sopo ia te koe te hutiaki, ko Ia e hai kego hai ai te ge'o sanga ki 'Oku pegea i Israel.’ ” ");
INSERT INTO mnv_vpl VALUES ("MT2_7","070_2_7","MAT","2","7","7","Ma te pogo 'aki huu a Herod i na taangata he 'igo'igo 'aki o hegeu soko kigatou, ke na'a ai eia ia te kigatou te 'aso mogimogi noko sopo ai te hetu'u. ");
INSERT INTO mnv_vpl VALUES ("MT2_8","070_2_8","MAT","2","8","8","Ka na kaunaki e Herod 'ia te kigatou o boo ki Bethlehem, kae hai atu kinai, “Boo atu o ligo gosigosi te tama 'iti'iti. Nimaa go kite e koutou, 'ogo haka to'o mai he gongo kia te au, ka kau go hinatu o sogi ma'u kia te Ia.” ");
INSERT INTO mnv_vpl VALUES ("MT2_9","070_2_9","MAT","2","9","9","Nimaa 'oti i te haka gongo kigatou ki te hakahua ia Herod, kae boo a kigatou, ka te hetu'u noko hiina'i kinai kigatou i matangi, noko manga mu'a ia te kigatou, ano manga eke haka ma'u o pata iho i te kunga noko manga iai te tama 'iti'iti. ");
INSERT INTO mnv_vpl VALUES ("MT2_10","070_2_10","MAT","2","10","10","Te 'aso na hiina'i ai kigatou ki te hetu'u, ko kigatou na hu'ai sisia ai. ");
INSERT INTO mnv_vpl VALUES ("MT2_11","070_2_11","MAT","2","11","11","Ka te 'aso na boo ake ai kigatou ki te hage, ko kigatou na hiina'i ki te tama 'iti'iti ma te tinana ia Mary. Ko kigatou na he tokotugi 'aki o sogi kia te Ia, ma te lugaluga na kete noko iai 'agatou ga'unga o haiga'a kia te Ia na golu ma na me'a tutu o tutuu gaoi e ingoa na ‘incense’, ma na me'a tutuu gaoi e ingoa na ‘myrrh’. ");
INSERT INTO mnv_vpl VALUES ("MT2_12","070_2_12","MAT","2","12","12","Ma te haka kuumanaba e God 'ia te kigatou i te miti, ke noka te giu kia Herod, kae manga giu ki tegatou kakai 'anga i he aga 'aatea. ");
INSERT INTO mnv_vpl VALUES ("MT2_13","070_2_13","MAT","2","13","13","Te 'aso na boo ai na taangata he 'igo'igo 'aki, te ensel o te 'Aitu noko haka 'agitino kia Joseph i te miti o hai atu kinai, “ 'Aga ake o kakabe te tama 'iti'iti ma te tinana, o he 'agiko ki Egypt, na'e ko Herod kago sasaga eia te tama 'iti'iti nei ke go taa. Pau atu o noko noho 'aki i Egypt ano 'io gea haka hoki atu au.” ");
INSERT INTO mnv_vpl VALUES ("MT2_14","070_2_14","MAT","2","14","14","Ko Joseph na 'aga o kakabe te tama 'iti'iti ma te tinana o boo i te poo ki Egypt. ");
INSERT INTO mnv_vpl VALUES ("MT2_15","070_2_15","MAT","2","15","15","Koia na noho ano i Egypt, hetae ki te 'aso na mate ai a Herod. Noko konei na haka maa'ogi ai nia noko gea ai a te 'Aitu o agatu'u i te taauga o hai ake: “Ko Au e ngege i toku Hosa ke hano i Egypt.” ");
INSERT INTO mnv_vpl VALUES ("MT2_16","070_2_16","MAT","2","16","16","Te 'aso na na'a gaoi ai e Herod koia e pake e na taangata he 'igo'igo 'aki, koia na haka tangi to'a, ma te tuku eia ke taa ko ba'i tama giki taangata i Bethlehem ma ona manaha babae, haka tu'u i na tama giki guanga ghapu o hetae ki na tama giki hai ho'ou, ke papata ki na 'aso noko na'a ai eia i na taangata he 'igo'igo 'aki. ");
INSERT INTO mnv_vpl VALUES ("MT2_17","070_2_17","MAT","2","17","17","Ma te haka maa'ogi ai nia noko gea kinai te taauga ia Jeremiah: ");
INSERT INTO mnv_vpl VALUES ("MT2_18","070_2_18","MAT","2","18","18","“Te ge'o i te manaha i Ramah noko haka gongo kinai na pegea noko tatangi ma te magegepe toto'a, ko Rachel noko manga magepe ia tena haanau, koia noko he'e maka ke baa kogikogi, iteme'agaa ko kigatou kua he'e kitea.” ");
INSERT INTO mnv_vpl VALUES ("MT2_19","070_2_19","MAT","2","19","19","Nimaa mate a Herod, te ensel o te 'Aitu noko haka 'agitino kia Joseph i te miti i Egypt. ");
INSERT INTO mnv_vpl VALUES ("MT2_20","070_2_20","MAT","2","20","20","O hai atu, “ 'Aga ake, o kakabe te tama 'iti'iti ma te tinana o giu ki na kunga henua o Israel, na'e kua mamate na pegea noko hai lobo ke taa te tama 'iti'iti nei.” ");
INSERT INTO mnv_vpl VALUES ("MT2_21","070_2_21","MAT","2","21","21","Ma te 'aga a Joseph o kakabe te tama 'iti'iti ma te tinana o boo ki na kunga henua o Israel. ");
INSERT INTO mnv_vpl VALUES ("MT2_22","070_2_22","MAT","2","22","22","Ka te 'aso na gongo ai a Joseph ko Archelaus kua sui ia te tamana o hakahua i Judea, ko Joseph na mataku te hano ki Judea, ma te haka kuu manaba hoki e God i te miti, tenaa te hai 'anga na hano ai ki te kakai 'anga i Galilee. ");
INSERT INTO mnv_vpl VALUES ("MT2_23","070_2_23","MAT","2","23","23","Koia na hano o noho i te manaha i Nazareth. Te hai 'anga nei na haka maa'ogi ai nia noko gegea ai na taauga: “Ko Ia e hai ke go haka ingoa 'ia te tangata mai Nazareth.” ");
INSERT INTO mnv_vpl VALUES ("MT3_1","070_3_1","MAT","3","1","1","Na 'aso na, ko John Baptist noko a'u o manga tohi'aki i te tugatea i Judea, ");
INSERT INTO mnv_vpl VALUES ("MT3_2","070_3_2","MAT","3","2","2","o hai atu, “Koutou sui tegeu'a atu, na'e na 'aso e hai ke go hakahua ai te 'Aitu kua hitaiaki.” ");
INSERT INTO mnv_vpl VALUES ("MT3_3","070_3_3","MAT","3","3","3","Ko John tenei te pegea noko gea kinai te taauga ia Isaiah: “Te ge'o o te pegea e ngege i te tugatea, ‘Haka ngaague he aga ki te 'Agiki; haka tinogaoi ba'i kunga kia te Ia.’ ” ");
INSERT INTO mnv_vpl VALUES ("MT3_4","070_3_4","MAT","3","4","4","Na ake o John Baptist noko gosigosi i na hugu ‘camel’, tena kapitiake noko gosigosi i na kigi buluka, kogaa ana utunga na 'ungaghali ma na hani i mouku. ");
INSERT INTO mnv_vpl VALUES ("MT3_5","070_3_5","MAT","3","5","5","Te 'apitanga o pegea i Jerusalem ma Judea ma ba'i kunga henua e mugheghi i te bai mimigo i Jordan noko boo kia John. ");
INSERT INTO mnv_vpl VALUES ("MT3_6","070_3_6","MAT","3","6","6","Ko kigatou noko haka nuukegi i ogatou 'oosongo, ma te haa gogomi e John 'ia te kigatou i te bai mimigo i Jordan. ");
INSERT INTO mnv_vpl VALUES ("MT3_7","070_3_7","MAT","3","7","7","Ka te gholoba na ina ai a John ki te 'apitanga o na Pharisee ma na Sadducee noko boo ake kia te ia ke haa gogomi ia te kigatou, koia noko hai atu kia te kigatou, “Koutou na matiginga ana ngata hai maka! Koai te kua haka kuu manaba ia te koutou ke he'agiko i te kagohia e a'u? ");
INSERT INTO mnv_vpl VALUES ("MT3_8","070_3_8","MAT","3","8","8","Hai atu na hai 'anga ke haka 'agi ai koutou kua sui tegeu'a i autou hai 'anga songo. ");
INSERT INTO mnv_vpl VALUES ("MT3_9","070_3_9","MAT","3","9","9","Kae noka tautou tuku gaoi o hai ake, ‘Ko kimatou te hai tematou tupuna ia Abraham.’ Ka ko au e hai atu kia te koutou, na hatu nei manga 'aonga te hai ai e God ni pegea ke hai ai ni makupuna mo'o Abraham! ");
INSERT INTO mnv_vpl VALUES ("MT3_10","070_3_10","MAT","3","10","10","Na 'aso nei kua 'oti i te tuku ai te akisi ki na tugi o na ga'akau. Nimaa iai ni ga'akau he'e tau hua gaoi, e hai ke go tua o seu ki te ahi. ");
INSERT INTO mnv_vpl VALUES ("MT3_11","070_3_11","MAT","3","11","11","“Koau manga haa gogomi eau ia te koutou i te bai ke haka 'agi koutou kua sui tegeu'a, ka ko Ia e hai ke go mugi mai ia te au e hu'ai taganga o sigi ia te au, e he'e 'aonga te he to'o 'aki eau ona taka ba'e, ko Ia e hai ke go haa gogomi ia te koutou i te Spirit Tapu ma te ahi. ");
INSERT INTO mnv_vpl VALUES ("MT3_12","070_3_12","MAT","3","12","12","Ko Ia manga kopi tena me'a hai hekau e hai kego haka 'aatea ai na penu i tena hata hai witi. Ko Ia e hai ke go haka putu ana hatu witi gaoi ki goto i te hage haka putu me'a, kae tutu na penu kigi witi i te hu'ai ahi kago he'e 'aonga te tamate.” ");
INSERT INTO mnv_vpl VALUES ("MT3_13","070_3_13","MAT","3","13","13","Ko Jesus noko hinaiho mai Galilee kia John i te bai mimigo i Jordan ke haa gogomi eia ia te Ia. ");
INSERT INTO mnv_vpl VALUES ("MT3_14","070_3_14","MAT","3","14","14","Ka ko John noko hai lobo eia ke sui maanatu a Jesus. Noko hai atu, “Koau te 'aonga te haa gogomi e Koe. 'Ai ko Koe e a'u kia te au?” ");
INSERT INTO mnv_vpl VALUES ("MT3_15","070_3_15","MAT","3","15","15","Ma te haka tau kinai a Jesus o hai atu, “Tuku iho ke konei na hai, na'e te paaunga kitaua hai 'ia te hai 'anga nei, ke haka maa'ogi ai ba'i hai 'anga haka tinogaoi.” ");
INSERT INTO mnv_vpl VALUES ("MT3_16","070_3_16","MAT","3","16","16","Nimaa 'oti i te haa gogomi a Jesus, ko Ia na ghali o sopo ake i te bai, ma te ta'aki a te gangi kia te Ia, o ina a John ki te Spirit Tapu o God noko iho mai, manga noho pe te gupe o mapu ia Jesus. ");
INSERT INTO mnv_vpl VALUES ("MT3_17","070_3_17","MAT","3","17","17","Kae hai iho ma'u te ge'o mai te gangi, “Tenei toku Hosa e hu'ai ma'ine kinai Au. Ko Au e hu'ai maagaohie kia te Ia.” ");
INSERT INTO mnv_vpl VALUES ("MT4_1","070_4_1","MAT","4","1","1","Ko Jesus na hutiaki e te Spirit Tapu ki te tugatea ke pake e Satan. ");
INSERT INTO mnv_vpl VALUES ("MT4_2","070_4_2","MAT","4","2","2","Mugi i tena he'e kai 'anga o katoa haka haa ona 'ao ma te katoa haka haa ona poo, ko Ia na ongea to'a. ");
INSERT INTO mnv_vpl VALUES ("MT4_3","070_4_3","MAT","4","3","3","Ko te 'atua pake noko a'u kia Jesus o hai atu, “Ko Koe nimaa te Hosa o God, gea atu ki na hatu nei ke haka haagiu ai ni utunga.” ");
INSERT INTO mnv_vpl VALUES ("MT4_4","070_4_4","MAT","4","4","4","Ko Jesus noko haka tau kinai o hai atu, “Na 'oti i te hai ake na Kanukanu Tapu: ‘Ko pegea e he'e manga maa'ugi i na utunga, kae maa'ugi ma'u i ba'i kupu gea ai a te 'Aitu.’ ” ");
INSERT INTO mnv_vpl VALUES ("MT4_5","070_4_5","MAT","4","5","5","Ma te kakabe e Satan ia te Ia ki te manaha tapu i Jerusalem, o hai ia te Ia o tu'u i te kunga e hu'ai ma'u'agunga i te Hage Tapu, ");
INSERT INTO mnv_vpl VALUES ("MT4_6","070_4_6","MAT","4","6","6","o hai atu kinai, “Ko Koe nimaa te Hosa o God, 'utu atu ki gago, na'e na 'oti i te hai ake na Kanukanu Tapu: ‘E hai ke go kaunaki mai ona ensel, agatu'u ia te Koe, e hai ma'u kigatou go nekeneke ia te Koe i ogatou gima, ke go noka te tukia te ba'e o 'Ou ki he hatu.’ ” ");
INSERT INTO mnv_vpl VALUES ("MT4_7","070_4_7","MAT","4","7","7","Ma te haka tau a Jesus o hai atu, “Na Kanukanu Tapu e konei na hai ake ma'u: ‘Noka te tuku ia te 'Agiki te 'Aitu o 'ou ki te hai lobo.’ ” ");
INSERT INTO mnv_vpl VALUES ("MT4_8","070_4_8","MAT","4","8","8","Ma te haka kabe haka hoki e Satan 'ia Jesus ki te ogo hu'ai ma'u 'agunga, o haka kite kia te Ia na kakai 'anga o te kege nei ma ona gaoi 'anga. ");
INSERT INTO mnv_vpl VALUES ("MT4_9","070_4_9","MAT","4","9","9","Kae hai atu, “Na me'a nei ngatahi e hai kau go haiga'a 'ia kia te Koe, i te poi toko tugi Koe o sogi kia te au.” ");
INSERT INTO mnv_vpl VALUES ("MT4_10","070_4_10","MAT","4","10","10","Hai atu kinai a Jesus, “Hinatu 'aatea ia te Au, Satan. Na 'oti i te hai ake na Kanukanu Tapu: ‘Manga sogi atu kia te 'Agiki te 'Aitu o 'ou, ma te manga hai hekau kia te Ia launatasi.’ ” ");
INSERT INTO mnv_vpl VALUES ("MT4_11","070_4_11","MAT","4","11","11","Ma te hano 'aatea a Satan ia Jesus, kae boo iho na ensel o 'aabaki kia te Ia. ");
INSERT INTO mnv_vpl VALUES ("MT4_12","070_4_12","MAT","4","12","12","Te 'aso na gongo ai a Jesus ko John kua tuku 'ia ki te hage kagohia, ko Ia na hoki ki Galilee. ");
INSERT INTO mnv_vpl VALUES ("MT4_13","070_4_13","MAT","4","13","13","Ko Ia na he'e noho i Nazareth, ka na hano o manga noho i Capernaum, te manaha pata i te gano i Galilee, i na kunga henua o na hanohano o Zebulun ma Naphtali, ");
INSERT INTO mnv_vpl VALUES ("MT4_14","070_4_14","MAT","4","14","14","ke haka maa'ogi ai nia noko gea kinai te taauga ia Isaiah: ");
INSERT INTO mnv_vpl VALUES ("MT4_15","070_4_15","MAT","4","15","15","“Na kunga henua o na hanohano o Zebulun ma Naphtali i te pa'asi ki tai i te bai mimigo i Jordan, ko Galilee te kakai 'anga o na pegea 'aatea, ");
INSERT INTO mnv_vpl VALUES ("MT4_16","070_4_16","MAT","4","16","16","te 'apitanga manga noho 'aki i te poo'uginga kua 'oti i te hiina'i ki te maagama hu'ai hua'eha; ko na pegea manga noho 'aki o maikia i te kai mamate, kua hetae kinai te maagama.” ");
INSERT INTO mnv_vpl VALUES ("MT4_17","070_4_17","MAT","4","17","17","Haka tu'u i na 'aso na o hano, ko Jesus na haka tu'u tena tohi'aki: “Koutou sui tegeu'a atu, iteme'agaa te Hakahua 'anga a te 'Aitu kua hitaiaki.” ");
INSERT INTO mnv_vpl VALUES ("MT4_18","070_4_18","MAT","4","18","18","Ko Jesus noko manga sehu i na pa'asi o te gano i Galilee. Ko Ia noko ina ki te hai haanau: ia Simon noko mate ko Peter, ma te taina ia Andrew. Ko kigaaua noko manga hai bugho i te gano, iteme'agaa ko kigaaua gua taangata tautai. ");
INSERT INTO mnv_vpl VALUES ("MT4_19","070_4_19","MAT","4","19","19","Ma te hai atu kinai a Jesus, “Tata'o mai ia te Au, ka kau hai 'ia ia te kougua ke go tautai pegea.” ");
INSERT INTO mnv_vpl VALUES ("MT4_20","070_4_20","MAT","4","20","20","Ko kigaaua na ghali o ti'aki ogaua bugho, kae tata'o ia Jesus. ");
INSERT INTO mnv_vpl VALUES ("MT4_21","070_4_21","MAT","4","21","21","Nimaa boo soo atu kigatou, ko Jesus noko ina ma'u ki tegaa hai haanau: ia James ma John, gua hosa o Zebedee manga i te baka ma tegaaua tamana. Noko manga gosigosi ogatou bugho, ma te hakapogo e Jesus 'ia te kigaaua. ");
INSERT INTO mnv_vpl VALUES ("MT4_22","070_4_22","MAT","4","22","22","Ma te ghali kigaaua o ti'aki te baka ma tegaaua tamana, kae tata'o ia Jesus. ");
INSERT INTO mnv_vpl VALUES ("MT4_23","070_4_23","MAT","4","23","23","Ko Jesus noko sehu i ba'i kakai 'anga i Galilee, o manga ako i na Hage hai paaunga, ma te 'atigongo i te Gongo Gaoi o te Hakahua 'anga a te 'Aitu, ma te haka ma'ugi na pegea e iai te mou hage o na sa'o saga ma te masaki. ");
INSERT INTO mnv_vpl VALUES ("MT4_24","070_4_24","MAT","4","24","24","Te gongo o'ona na hohoga i ba'i kunga i Syria, ka ko pegea na kakabe ake kia te Ia na pegea masasaki i te mou hage o te sa'o saga songo, ma na pegea manga higosia ma'u i te mou haka gongonga, na pegea eketia i te haagiki ma na pegea he ghotoi 'aki, ma na pegea mamate pa'asi tasi, ka noko haka ma'ugi ngatahi e Jesus. ");
INSERT INTO mnv_vpl VALUES ("MT4_25","070_4_25","MAT","4","25","25","Na hu'ai tu'u pegea mai Galilee ma Decapolis, ma Jerusalem ma Judea ma na kakai 'anga i tegaa pa'asi i Jordan, noko manga he'agumaki ia te ia. ");
INSERT INTO mnv_vpl VALUES ("MT5_1","070_5_1","MAT","5","1","1","Nimaa ina a Jesus ki te 'apitanga, ko Ia na haka neke ki te pa'asi o te ogo o noho ai, ma te boo ake ona pegea haka ako kia te Ia. ");
INSERT INTO mnv_vpl VALUES ("MT5_2","070_5_2","MAT","5","2","2","O haka tu'u ako e Jesus ia te kigatou, o hai atu, ");
INSERT INTO mnv_vpl VALUES ("MT5_3","070_5_3","MAT","5","3","3","“Te hakagaoinga ki na pegea tegeu'a haka tukunga kia te 'Aitu, iteme'agaa tegatou manaha ko te nuku i te gangi. ");
INSERT INTO mnv_vpl VALUES ("MT5_4","070_5_4","MAT","5","4","4","Te hakagaoinga ki na pegea manga magegepe, iteme'agaa ko kigatou kago baa kogikogi 'ia. ");
INSERT INTO mnv_vpl VALUES ("MT5_5","070_5_5","MAT","5","5","5","Te hakagaoinga ki na pegea haka ma'u gago, iteme'agaa kago ga'u e kigatou a te kege nei. ");
INSERT INTO mnv_vpl VALUES ("MT5_6","070_5_6","MAT","5","6","6","Te hakagaoinga ki na pegea manga gootunga ki te haka tinogaoi o te 'Aitu, iteme'agaa kago ga'u e kigatou. ");
INSERT INTO mnv_vpl VALUES ("MT5_7","070_5_7","MAT","5","7","7","Te hakagaoinga ki na pegea 'agogoha i gaa pegea, iteme'agaa kago haka'agi kinai te 'agoha o te 'Aitu. ");
INSERT INTO mnv_vpl VALUES ("MT5_8","070_5_8","MAT","5","8","8","Te hakagaoinga ki na pegea soihua ogatou uso, iteme'agaa ko kigatou kago hiina'i kia te 'Aitu. ");
INSERT INTO mnv_vpl VALUES ("MT5_9","070_5_9","MAT","5","9","9","Te hakagaoinga ki na pegea haka noka hetaunga, iteme'agaa ko kigatou kago mate na tama giki a te 'Aitu. ");
INSERT INTO mnv_vpl VALUES ("MT5_10","070_5_10","MAT","5","10","10","Te hakagaoinga ki na pegea hai songo 'ia i te ghaghi i te haka tinogaoi o te 'Aitu, iteme'agaa tegatou manaha ko te nuku i te gangi. ");
INSERT INTO mnv_vpl VALUES ("MT5_11","070_5_11","MAT","5","11","11","Te hakagaoinga kia te koutou i na 'aso gegea songo ai a pegea kia te koutou, ma te hai songo ia te koutou, ma te hai gongo songo ia te koutou, i te ghaghi ia te Au. ");
INSERT INTO mnv_vpl VALUES ("MT5_12","070_5_12","MAT","5","12","12","Koutou sisia atu, ma te magagaohie, iteme'agaa te hu'ai ga'unga a'autou manga i te gangi. Ko kigatou noko manga konei 'agatou noho ma'u ki na taauga noko mumu'a mai ia te koutou. ");
INSERT INTO mnv_vpl VALUES ("MT5_13","070_5_13","MAT","5","13","13","“Koutou e hai ke noho pe na solo ki na pegea o gago nei, ka na solo nimaa he'e kona, e hai ke kohea na hai ke kona haka hoki? Kua pau o he'e gaoi ki he me'a ka manga seu, ma te takataka e pegea. ");
INSERT INTO mnv_vpl VALUES ("MT5_14","070_5_14","MAT","5","14","14","“Koutou te maagama ki na pegea i gago nei. Te manaha i te hohonga ogo, e he'e 'aonga te ngigo. ");
INSERT INTO mnv_vpl VALUES ("MT5_15","070_5_15","MAT","5","15","15","E he'e kitea he pegea ma'u tutu he peba o poghi i he kete, kae hai ke haka eke ki te kunga tuku peba, ka ke maagama ki ba'i pegea i te hage. ");
INSERT INTO mnv_vpl VALUES ("MT5_16","070_5_16","MAT","5","16","16","Manga konei na noho ma'u, tuku atu te maagama o 'outou ki 'ago ia pegea, kigatou hiina'i ki autou hekau gaoi, ka kigatou haka e'eha ai ia te Tamana o'outou e noho i te gangi. ");
INSERT INTO mnv_vpl VALUES ("MT5_17","070_5_17","MAT","5","17","17","“Noka tautou tegeu'a ake, ko Au e a'u kau hai ti'aki 'ia na tagangonga a Moses ma na akonga ana taauga. Ko Au e he'e a'u kau hai songo 'ia, kae a'u kau haka maa'ogi 'ia. ");
INSERT INTO mnv_vpl VALUES ("MT5_18","070_5_18","MAT","5","18","18","Ko Au e gea maa'ogi kia te koutou: Hano ano hetae ki te nimo o te gangi ma te kege nei, e si'ai he mi'i kupu po he mi'i tongi 'anga kanukanu i na tagangonga kago nimo, hano ano 'oti ko ba'i hai 'anga. ");
INSERT INTO mnv_vpl VALUES ("MT5_19","070_5_19","MAT","5","19","19","Nimaa iai he pegea e hai songo eia he mi'i kunga i na tagangonga nei, ma te ako kogaa pegea kigatou tata'o ia te ia, koia e hai ke go hai ai he pegea he'e tau hai 'anga i te Hakahua 'anga a te 'Aitu i te gangi. Ka koai kago maangao ki na tagangonga ma te ako kogaa pegea kigatou tata'o ia te ia, koia e hai ke go hai ai he hu'ai pegea i te Hakahua 'anga a te 'Aitu. ");
INSERT INTO mnv_vpl VALUES ("MT5_20","070_5_20","MAT","5","20","20","Iteme'agaa ko Au e hai atu kia te koutou, naakupu ki te tinogaoi koutou o sigi i na Pharisee ma na ako o na tagangonga, koutou kago he'e 'aonga te boo ki goto i te nuku i te gangi. ");
INSERT INTO mnv_vpl VALUES ("MT5_21","070_5_21","MAT","5","21","21","“Koutou noko haka gongo ki na gegea 'anga ki na tupuna o tatou i gaa 'aso noko hai ake: ‘Noka tautou taa pegea ke mamate. Nimaa iai he pegea e taa eia he pegea o mate, koia e hai kego to'o ki te haka aba.’ ");
INSERT INTO mnv_vpl VALUES ("MT5_22","070_5_22","MAT","5","22","22","Ka ko Au e hai atu kia te koutou, te pegea nimaa 'ika'ika kia te taina, koia kago to'o ki te haka aba. Ka nimaa iai he pegea hai atu kia te taina, ‘Ko koe e he'e tau hai 'anga,’ koia kago hano o haka aba e na Sanhedrin. Ka nimaa iai he pegea hai atu, ‘Ko koe te haka tugihu'u,’ koia kago hano ki te ugaimami. ");
INSERT INTO mnv_vpl VALUES ("MT5_23","070_5_23","MAT","5","23","23","“Tenei te hai 'anga nimaa hai ke haiga'a ai ma'au he ga'a tausu'u kia te 'Aitu i te olta, kae maanatu hoki koe kia te taiu e iai te hai 'anga e haka tangi ai kia te koe, ");
INSERT INTO mnv_vpl VALUES ("MT5_24","070_5_24","MAT","5","24","24","mataa tuku iho tau ga'a tausu'u i 'ago i te olta, kae hoki o haka gaoi 'aki ma te taiu, 'io hokimai o haiga'a tau ga'a tausu'u. ");
INSERT INTO mnv_vpl VALUES ("MT5_25","070_5_25","MAT","5","25","25","“Haka noka me'a ghali atu ki tou makau e hai ke to'o ia te koe ki te haka aba. Haka noka atu i te gholoba manga koi boo ai kougua i te aga ki te haka aba, na'e nimaa pau ia o haiga'a ia te koe ki te haka aba, go haiga'a e te haka aba ia te koe ki te solodia ma te tuku ia te koe ki te hage kagohia. ");
INSERT INTO mnv_vpl VALUES ("MT5_26","070_5_26","MAT","5","26","26","Ko Au e gea maa'ogi kia te koe: Ko koe ka he'e 'aonga te sopo iho ano, 'io haiga'a haka 'oti te me'a taha'aki e toe i te tau'i o 'ou. ");
INSERT INTO mnv_vpl VALUES ("MT5_27","070_5_27","MAT","5","27","27","“Koutou noko manga haka gongo ki na pegea ogaa 'aso noko hai ake: ‘Noka te haka masi'i ki na uguugu ogaa taangata.’ ");
INSERT INTO mnv_vpl VALUES ("MT5_28","070_5_28","MAT","5","28","28","Ka ko Au e hai atu kia te koutou: Nimaa iai he launa tasi tangata e ina ki he hahine o haka nau kinai, kua 'oti i te tatae ki te hahine i te uso o'ona. ");
INSERT INTO mnv_vpl VALUES ("MT5_29","070_5_29","MAT","5","29","29","Te mata maui o'ou nimaa hai ia te koe o 'oosongo, sa'u iho o tupe 'aatea. E gaoi i te ti'aki he kunga e tasi i tou tino o sigi i te hano tou tino kaatoa ki te ugaimami. ");
INSERT INTO mnv_vpl VALUES ("MT5_30","070_5_30","MAT","5","30","30","Ka poi hai e tou gima maui ia te koe o 'oosongo, toghi atu o tupe. E gaoi i te ti'aki he kunga e tasi i tou tino o sigi i te hano tou tino kaatoa ki te ugaimami. ");
INSERT INTO mnv_vpl VALUES ("MT5_31","070_5_31","MAT","5","31","31","“Na tagangonga noko hai ake ma'u: ‘Nimaa iai he tangata maabae ma tona uguugu, koia hai ke haiga'a ki te hahine te kanukanu haka 'igonga o te maabae.’ ");
INSERT INTO mnv_vpl VALUES ("MT5_32","070_5_32","MAT","5","32","32","Ka ko Au e hai atu kia te koutou: Nimaa iai he tangata ti'aki tena uguugu, ka tena uguugu he'e haka masi'i ki he tangata 'aatea, te tangata nei e hai eia te hahine nei ke 'oosongo, i te poi hai matu'a hoki. Ka nimaa iai he tangata kago pipiki eia te hahine kua ti'aki e tena matu'a, te tangata nei e 'oosongo ma'u. ");
INSERT INTO mnv_vpl VALUES ("MT5_33","070_5_33","MAT","5","33","33","“Koutou noko haka gongo hoki ki na gegea 'anga ki na tupuna o tatou i gaa 'aso noko hai ake: ‘Noka te haisongo autou tukunga kupu, kae pau o pipiki atu nia noko tuku kupu ai koe kia te 'Aitu.’ ");
INSERT INTO mnv_vpl VALUES ("MT5_34","070_5_34","MAT","5","34","34","Ka ko Au e hai atu kia te koutou: Noka te aguagu ki ni me'a. Noka te aguagu ki te gangi, na'e te noohonga o te 'Aitu. ");
INSERT INTO mnv_vpl VALUES ("MT5_35","070_5_35","MAT","5","35","35","Ma te noka te aguagu ki te kege nei, na'e tena kunga tu'u, ma te noka te aguagu ki Jerusalem, na'e te manaha o te Hakahua tamaki. ");
INSERT INTO mnv_vpl VALUES ("MT5_36","070_5_36","MAT","5","36","36","Kae noka te aguagu ma'u ki outou 'ugu, iteme'agaa ka he'e 'aonga te hai e koutou he gau 'ugu ke susugu poe 'ugi. ");
INSERT INTO mnv_vpl VALUES ("MT5_37","070_5_37","MAT","5","37","37","Kae manga tuku tau haka 'Oo 'anga ke maa'ogi, poe tau haka Si'ai 'anga ke maa'ogi. Ka nimaa e haka soo atu ma'u he me'a, te me'a a'u mai te haagiki. ");
INSERT INTO mnv_vpl VALUES ("MT5_38","070_5_38","MAT","5","38","38","“Koutou noko haka gongo ki na gegea 'anga ki na pegea ogaa 'aso noko hai ake: ‘Nimaa tuki'ia he mata, sui atu o tuki he mata, nimaa tuki'ia he niho, sui atu o tuki he niho.’ ");
INSERT INTO mnv_vpl VALUES ("MT5_39","070_5_39","MAT","5","39","39","Ka ko Au e hai atu kia te koutou: Noka te haka hetata'i ki he pegea songo. Nimaa iai he pegea paa tou kagahau maui, giu atu ma'u kinai tegaa pa'asi. ");
INSERT INTO mnv_vpl VALUES ("MT5_40","070_5_40","MAT","5","40","40","Ka nimaa iai he pegea to'o ia te koe ki te haka aba o sa'u te ake o'ou, tuku atu ma'u ke hai mo'ona te ake maatogu o'ou. ");
INSERT INTO mnv_vpl VALUES ("MT5_41","070_5_41","MAT","5","41","41","Nimaa iai he pegea haka mataku taku ia te koe ke tata'o haka makabaa ia te ia, tata'o haka mama'o so atu ai. ");
INSERT INTO mnv_vpl VALUES ("MT5_42","070_5_42","MAT","5","42","42","Haiga'a atu ki he pegea haka ene kia te koe. Noka te susugi te pegea e siahai ke mataa to'o ma'au he me'a ka kego 'abatu hoki 'ia te koe. ");
INSERT INTO mnv_vpl VALUES ("MT5_43","070_5_43","MAT","5","43","43","“Koutou noko haka gongo, noko hai ake: ‘Maa'ine atu ki na pegea e pata mai ia te koe, kae 'atua hekai atu ki outou makau.’ ");
INSERT INTO mnv_vpl VALUES ("MT5_44","070_5_44","MAT","5","44","44","Ka ko Au e hai atu kia te koutou: Maa'ine atu ki na makau o 'outou, ma te taakunga i na pegea manga hai songo ia te koutou. ");
INSERT INTO mnv_vpl VALUES ("MT5_45","070_5_45","MAT","5","45","45","Ka kego hai ia te koutou na hosa o te Tamana o 'outou e noho i te gangi. Ko Ia e tuku e Ia te ga'aa o 'Ona o sopo ake ki na pegea songo ma na pegea gaoi, ma te hakato'o e Ia na 'ua ki na pegea tinogaoi ma na pegea he'e tinogaoi. ");
INSERT INTO mnv_vpl VALUES ("MT5_46","070_5_46","MAT","5","46","46","Ka koutou poi manga maa'ine ki na pegea manga maa'ine kia te koutou, tehea te ga'unga kago ga'u e koutou? 'Ai na pegea tibu takis he'e konaa agatou hai ma'u? ");
INSERT INTO mnv_vpl VALUES ("MT5_47","070_5_47","MAT","5","47","47","Ka koutou nimaa manga gegea gaoi ki outou 'api, nia te hai e koutou o sigi i gaa pegea? 'Ai na pegea he'e sogi he'e konaa agatou hai ma'u? ");
INSERT INTO mnv_vpl VALUES ("MT5_48","070_5_48","MAT","5","48","48","Haka tinogaoi atu, o noho pe te Tamana o 'outou e noho i te gangi e soihua. ");
INSERT INTO mnv_vpl VALUES ("MT6_1","070_6_1","MAT","6","1","1","“Haka tauganga atu, noka tautou haihai 'anga gaoi ki mata ia pegea ke hiina'i kinai. Koutou nimaa konaa 'autou hai, kago he'e tau giu'akinga ga'u e koutou ia te Tamana o'outou e noho i te gangi. ");
INSERT INTO mnv_vpl VALUES ("MT6_2","070_6_2","MAT","6","2","2","“Ka ko koe nimaa haiga'a ki na pegea lae, noka te hai baa gongo ai, ke noho pe na hai 'anga a na pegea haka hage hage i na Hage hai paaunga ma na agatu'u, ke haka 'eha'eha ai e pegea 'ia te kigatou. Ko Au e gea maa'ogi kia te koutou: Kua 'oti i te ga'u e kigatou na giu'aki ga'unga agatou. ");
INSERT INTO mnv_vpl VALUES ("MT6_3","070_6_3","MAT","6","3","3","Ka ko koe nimaa haiga'a ki na pegea hu'ai lae, noka te tuku te pa'asi sema o 'ou ke na'a nia e hai e te pa'asi maui o 'ou. ");
INSERT INTO mnv_vpl VALUES ("MT6_4","070_6_4","MAT","6","4","4","Ka ko koe manga haiga'a huu atu, na'e te Tamana o 'ou e noho i te gangi te ina ki nia manga hai huu e koe, kago giu'aki e Ia kia te koe. ");
INSERT INTO mnv_vpl VALUES ("MT6_5","070_6_5","MAT","6","5","5","“Ka na 'aso taakunga o 'outou, noka te noho pe na pegea haka hagehage, manga siahahai ki na tutu'u 'anga i na hage hai paaunga ma na agatu'u, ke hiina'i kinai a pegea. Ko Au e gea maa'ogi kia te koutou: Kua 'oti i te ga'u e kigatou na giu'aki ogatou. ");
INSERT INTO mnv_vpl VALUES ("MT6_6","070_6_6","MAT","6","6","6","Ka nimaa te 'aso e taakunga ai koe, mene atu ki tou hage o titingi tena aga, kae taakunga kia te Tamana o 'ou e he'e hiina'i kinai. Ka te Tamana o 'ou e ina ki na me'a hai huunaki, kago giu'aki e Ia kia te koe. ");
INSERT INTO mnv_vpl VALUES ("MT6_7","070_6_7","MAT","6","7","7","Nimaa i outou 'aso taakunga, noka te baloghalogha ke noho pe na pegea he'e na'a e kigatou ia te 'Aitu, iteme'agaa ko kigatou manga tegeu'a ake ka haka gongo kia te kigatou i agatou taakunga gogoa 'anga. ");
INSERT INTO mnv_vpl VALUES ("MT6_8","070_6_8","MAT","6","8","8","Noka tautou konei na hai pe kigatou, na'e te Tamana o 'outou manga na'a e Ia nia e siahahai kinai koutou, 'io mugi koutou o haka ene 'aki ai kia te Ia. ");
INSERT INTO mnv_vpl VALUES ("MT6_9","070_6_9","MAT","6","9","9","E hai koutou konei na taakunga: Tematou Tamana e noho i te gangi, ke hai tou ingoa ke tapu, ");
INSERT INTO mnv_vpl VALUES ("MT6_10","070_6_10","MAT","6","10","10","ke a'u Tou 'aso hakahua ai a te kege nei, ke hai Au paaunga ki te kege nei ke noho pe Au paaunga i te gangi. ");
INSERT INTO mnv_vpl VALUES ("MT6_11","070_6_11","MAT","6","11","11","Haiga'a mai i te 'ao nei na utunga manga ga'u e kimatou i ba'i 'ao. ");
INSERT INTO mnv_vpl VALUES ("MT6_12","070_6_12","MAT","6","12","12","Haka noka mai kia te kimatou ni hai 'anga songo hai e kimatou, ke noho pe na haka noka hai 'anga a matou ki na pegea hai 'oosongo kia te kimatou. ");
INSERT INTO mnv_vpl VALUES ("MT6_13","070_6_13","MAT","6","13","13","Noka te hutiaki ia te kimatou ki na pakenga, kae haka tausu'u ia te kimatou i te haagiki. Iteme'agaa te hakahua 'anga, ma te mamagunga, ma na taganga, ke noho kia te Koe ki ba'i 'aso. E tonu! ");
INSERT INTO mnv_vpl VALUES ("MT6_14","070_6_14","MAT","6","14","14","“Nimaa haka noka e koutou kogaa pegea hai hai 'anga songo kia te koutou, te Tamana o 'outou e i-te gangi ka go haka noka ma'u kia te koutou. ");
INSERT INTO mnv_vpl VALUES ("MT6_15","070_6_15","MAT","6","15","15","Ka nimaa he'e haka noka e koutou na hai 'anga maase'i hai e gaa pegea kia te koutou, te Tamana o 'outou ka go he'e haka noka ma'u 'outou 'oosongo. ");
INSERT INTO mnv_vpl VALUES ("MT6_16","070_6_16","MAT","6","16","16","“ 'Outou 'aso he'e kai i te sogi, noka tautou hiina'i haka 'aagogoha, ke noho pe na hai 'anga ana pegea haka hagehage, ta'anga hiina'i haka 'aagogoha ke haka 'agi ki gaa pegea ko kigatou e he'e kai i te sogi. Ko Au e gea maa'ogi kia te koutou: Kua 'oti i te ga'u e kigatou na giu'aki ogatou. ");
INSERT INTO mnv_vpl VALUES ("MT6_17","070_6_17","MAT","6","17","17","Ka nimaa tou 'aso he'e kai i te sogi, segu atu tou 'ugu mate huhu'i atu ou mata. ");
INSERT INTO mnv_vpl VALUES ("MT6_18","070_6_18","MAT","6","18","18","Ka ke he'e suga ki gaa pegea ko koe e he'e kai i tau sogi, ka manga ko te Tamau e he'e hiina'i kinai a pegea. Ko Ia te manga ina ki nia manga hai huu e koe, e hai ke go giu'aki e Ia kia te koe. ");
INSERT INTO mnv_vpl VALUES ("MT6_19","070_6_19","MAT","6","19","19","“Noka te haka putu ni ga'unga ki te kege nei, na'e ka go hai songo e na kagakuba, ma te koli. Te kunga na kago tuki ma'u e na pegea mou toto'o o kaia'a. ");
INSERT INTO mnv_vpl VALUES ("MT6_20","070_6_20","MAT","6","20","20","Kae manga haka putu atu ma'autou ni ga'unga ki te gangi, na'e kago he'e hai songo ena kagakuba poe koli. Tenaa te kunga kago he'e tuki ma'u e na pegea mou toto'o o kaia'a. ");
INSERT INTO mnv_vpl VALUES ("MT6_21","070_6_21","MAT","6","21","21","Iteme'agaa te kunga e haka putu kinai autou ga'unga, tenaa te kunga manga heketi hinangago ma'u ai koutou. ");
INSERT INTO mnv_vpl VALUES ("MT6_22","070_6_22","MAT","6","22","22","“Te mata te peba o te tino. Te mata o 'ou nimaa gaoi, te tino o 'ou ngatahi ka maagama to'a. ");
INSERT INTO mnv_vpl VALUES ("MT6_23","070_6_23","MAT","6","23","23","Ka nimaa songo te mata o 'ou, te tino ngatahi ka manga poo'ugi to'a. Ka te maagama e i-te uso o 'ou nimaa poo'ugi, te poo'ugi 'anga nei te hu'ai poo'uginga. ");
INSERT INTO mnv_vpl VALUES ("MT6_24","070_6_24","MAT","6","24","24","“Ka he'e kitea he pegea 'aonga te hai hekau ki he toka gua hakahua. Koia kitai go gotoa'a ki tegaa, kae ma'ine ki tegaa. Koia kitai go hai gaoi ki tegaa, kae hai songo tegaa. Koutou ka he'e 'aonga te hai hekau kia God ma na mane ngatahi. ");
INSERT INTO mnv_vpl VALUES ("MT6_25","070_6_25","MAT","6","25","25","“Kogaa na noho ko Au e hai atu kia te koutou, noka te maikia ki outou ma'ugi, po nia ka go kai ma te binu. Po nia kego mamago ai koutou. 'Ai te ma'ugi e he'e gaoi to'a o sigi i na utunga? 'Ai na tino e he'e gaoi to'a o sigi i na laoa? ");
INSERT INTO mnv_vpl VALUES ("MT6_26","070_6_26","MAT","6","26","26","Hiina'i atu ki na manu he gegei. Ko kigatou e he'e sanga poe utu poe haka putu utunga ki ni hage, ka manga haangai e te Tamana o 'outou e noho i te gangi. 'Ai koutou e he'e gaoi toto'a o sigi i na manu he gegei? ");
INSERT INTO mnv_vpl VALUES ("MT6_27","070_6_27","MAT","6","27","27","Koai ia te koutou e maikia ki te ma'ugi o 'ona ma te beegaba ai eia te mi'i gholoba ki te ma'ugi? ");
INSERT INTO mnv_vpl VALUES ("MT6_28","070_6_28","MAT","6","28","28","“Tehea ma'u te hai 'anga e maikia ai koutou ki na laoa? 'Ai hiina'i atu ki na ngaasogo 'anga na lakaa me'a o mouku. Na lakaa me'a o mouku e he'e hai hekau poe lapui. ");
INSERT INTO mnv_vpl VALUES ("MT6_29","070_6_29","MAT","6","29","29","Ka ko Au e hai atu kia te koutou, he'e po ko Solomon ma'u ma ana me'a gaoi ngatahi noko he'e mamago gaoi ke noho po he launatasi i na lakaa me'a nei. ");
INSERT INTO mnv_vpl VALUES ("MT6_30","070_6_30","MAT","6","30","30","Nimaa konaa na noho na haa mago 'anga e God na lakaa me'a o mouku, manga noho i te aso nei kae seu ki te ahi i te 'aso 'ao, 'ai ko Ia ka he'e haka soo atu te haa mago e Ia ia te koutou? Koutou hu'ai gigiki 'outou sano kia God! ");
INSERT INTO mnv_vpl VALUES ("MT6_31","070_6_31","MAT","6","31","31","Noka tautou maikia, o hai ake, ‘Nia 'a tatou kago kai?’ po ‘Nia 'a tatou kago binu?’ po ‘Nia kago mamago ai a kitatou?’ ");
INSERT INTO mnv_vpl VALUES ("MT6_32","070_6_32","MAT","6","32","32","Iteme'agaa na pegea he'e sogi kia te 'Aitu te manga ligo e kigatou na me'a nei, ka te Tamana o 'outou e i-te gangi manga na'a e Ia koutou e sia hahai ki na me'a nei. ");
INSERT INTO mnv_vpl VALUES ("MT6_33","070_6_33","MAT","6","33","33","Ka koutou mataa sasaga atu te hakahua o 'Ona ma te haka tinogaoi o 'Ona ka kego beegaba e Ia na me'a ngatahi nei kia te koutou. ");
INSERT INTO mnv_vpl VALUES ("MT6_34","070_6_34","MAT","6","34","34","Kogaa na noho, noka tautou maikia atu ki te 'aso 'ao, na'e na maikia o te 'aso 'ao konaa. Ko ba'i 'ao e taki hai ona maikia. ");
INSERT INTO mnv_vpl VALUES ("MT7_1","070_7_1","MAT","7","1","1","“Noka te haka aba, na'e ko koutou te kai go haka aba 'ia ma'u. ");
INSERT INTO mnv_vpl VALUES ("MT7_2","070_7_2","MAT","7","2","2","Iteme'agaa na haka aba 'anga e hai e koutou ki gaa pegea, te hai ke go sui o haka aba 'ia ai ia te koutou, ma nia e hai e koutou, e hai ke go sui o hai ma'u kia te koutou. ");
INSERT INTO mnv_vpl VALUES ("MT7_3","070_7_3","MAT","7","3","3","“ 'Eaa e ina 'atu ai koe ki te momo pebu e i-te mata o te taiu, kae manga haka tausu'u ai ki te pa'asi ga'akau manga i tou mata? ");
INSERT INTO mnv_vpl VALUES ("MT7_4","070_7_4","MAT","7","4","4","Tehea te hai 'anga e hai atu ai koe kia te taiu, ‘Tuku mai kau sa'u iho 'ia te pebu manga i tou mata,’ ka te manga noho te pa'asi ga'akau i tou mata? ");
INSERT INTO mnv_vpl VALUES ("MT7_5","070_7_5","MAT","7","5","5","Ko koe te pegea haka hagehage! Mataa sa'u iho te pa'asi ga'akau i tou mata, 'io ina gaoi koe ke sa'u iho te pebu e i-te mata o te taiu. ");
INSERT INTO mnv_vpl VALUES ("MT7_6","070_7_6","MAT","7","6","6","“Noka te seu na me'a 'eteaki ki na tokitoki, ma te noka te seu autou me'a susugu gaoi ki na piki. Nimaa konaa na hai e koutou, ka manga takataka e kigatou, kae taka hugi o taa hakamaseuseu ia te koutou. ");
INSERT INTO mnv_vpl VALUES ("MT7_7","070_7_7","MAT","7","7","7","“Haka ene 'aki atu, ka ke go haiga'a kia te koutou. Sasaga atu, ka ke go kite e koutou. Tukituki atu te titingi, ka ke go luga kia te koutou. ");
INSERT INTO mnv_vpl VALUES ("MT7_8","070_7_8","MAT","7","8","8","Iteme'agaa ko ba'i pegea haka ene 'aki kago ga'u e kigatou. Koai e sasaga, e hai ke go kite eia, ka koai e tukituki te titingi, e hai ke go luga kia te ia. ");
INSERT INTO mnv_vpl VALUES ("MT7_9","070_7_9","MAT","7","9","9","“ 'Ai koai ia te koutou, poi haka ene utunga kinai mo'ona he hosa, ka 'abange kinai he hatu?! ");
INSERT INTO mnv_vpl VALUES ("MT7_10","070_7_10","MAT","7","10","10","Poe haka ene kinai he kaui, ka 'abange kinai he ngata?! ");
INSERT INTO mnv_vpl VALUES ("MT7_11","070_7_11","MAT","7","11","11","He'e po koutou na pegea hai hai 'anga songo te manga haiga'a me'a gaoi ki 'autou tama giki. Kae soo atu te Tamana o 'outou e i-te gangi i tena haiga'a me'a gaoi to'a ki na pegea haka ene 'aki kia te Ia. ");
INSERT INTO mnv_vpl VALUES ("MT7_12","070_7_12","MAT","7","12","12","Hai atu ki gaa pegea nia e siahahai koutou ke hai e kigatou kia te koutou, iteme'agaa tenei te tuginga o na Tagangonga a Moses ma te Akonga a na Taauga. ");
INSERT INTO mnv_vpl VALUES ("MT7_13","070_7_13","MAT","7","13","13","“Boo atu ki goto i te mi'i aga, na'e te aga e gau e'eha ma te hu'ai agatu'u e hano ki te sangasongo, kae 'eha pegea manga boo ai. ");
INSERT INTO mnv_vpl VALUES ("MT7_14","070_7_14","MAT","7","14","14","Ka te mi'i aga e 'ago 'iti'iti kae 'ago kapikapi, e hano ki te ma'ugi, ka manga te geka te kite e kigatou. ");
INSERT INTO mnv_vpl VALUES ("MT7_15","070_7_15","MAT","7","15","15","“Na'ana'a atu ki na taauga gogoi. Ko kigatou e boomai kia te koutou manga a'aki pe na sipisipi, ka ogatou uso manga noho pena tokitoki 'atua hekai. ");
INSERT INTO mnv_vpl VALUES ("MT7_16","070_7_16","MAT","7","16","16","Kago na'a e koutou i ogatou huhuta: E si'ai ni pegea haki ni hua kaubago i na ga'akau hotohoto, po ni hua ‘fig’ i na kaubago hotohoto. ");
INSERT INTO mnv_vpl VALUES ("MT7_17","070_7_17","MAT","7","17","17","E kogaa na noho, ko ba'i ga'akau gaoi e gaoi ona hua 'anga, ka na ga'akau songo e songo ona hua 'anga. ");
INSERT INTO mnv_vpl VALUES ("MT7_18","070_7_18","MAT","7","18","18","Te ga'akau e gaoi e he'e 'aonga te songo tena hua, ka te ga'akau e songo e he'e 'aonga te gaoi te hua e sopo ai. ");
INSERT INTO mnv_vpl VALUES ("MT7_19","070_7_19","MAT","7","19","19","Ko ba'i ga'akau e he'e gaoi tena hai hua 'anga e tua o tupe ki te ahi. ");
INSERT INTO mnv_vpl VALUES ("MT7_20","070_7_20","MAT","7","20","20","Ka i na noho konei ona noho, e hai kego na'a ai e koutou ia te kigatou. ");
INSERT INTO mnv_vpl VALUES ("MT7_21","070_7_21","MAT","7","21","21","“E he'e ko ba'i pegea e hai mai kia te Au: ‘Hakahua, Hakahua!’ ka go boo ki goto i te nuku i te gangi, ka manga koai e hai eia na paaunga a Tamau e noho i te gangi. ");
INSERT INTO mnv_vpl VALUES ("MT7_22","070_7_22","MAT","7","22","22","E 'api pegea ka go hai mai kia te Au i te 'aso na: ‘Hakahua, Hakahua, 'ai ko kimatou noko he'e taga gongo i tou ingoa, ma te pagepage 'atua ma'u i tou ingoa, ma te hai taganga ma'u ai?!’ ");
INSERT INTO mnv_vpl VALUES ("MT7_23","070_7_23","MAT","7","23","23","Kae ka go hogahoga haka tinogaoi e Au kia te kigatou, ‘E he'e mi'i na'a e Au ia te koutou, boo 'aatea atu ia te Au, koutou na pegea hai hai 'anga hakamakau.’ ");
INSERT INTO mnv_vpl VALUES ("MT7_24","070_7_24","MAT","7","24","24","“Kogaa na noho ko ba'i pegea e haka gongo ki ba'i haka hegeunga a 'Aku nei o hai e kigatou, manga papata ma te tangata 'igo'igo noko 'ati tena hage i te ogo hatu. ");
INSERT INTO mnv_vpl VALUES ("MT7_25","070_7_25","MAT","7","25","25","Too na hu'ai 'ua kae tupu na mi'i bai mimigo kae ase mai na huukenga o he guti ki te hage; ka manga he'e too te hage, iteme'agaa te hage nei noko 'ati tena tugi ki te ogo hatu. ");
INSERT INTO mnv_vpl VALUES ("MT7_26","070_7_26","MAT","7","26","26","Ka ko ba'i pegea nimaa haka gongo ki aku haka hegeunga nei, ka manga he'e hai e kigatou, manga papata ma te tangata noanoa noko 'ati tena hage ki te 'one. ");
INSERT INTO mnv_vpl VALUES ("MT7_27","070_7_27","MAT","7","27","27","Nimaa too mai na hu'ai 'ua, kae tupu na mi'i bai mimigo, kae ase mai na huukenga o heguti ki te hage, kae manga guti haka maseuseu.” ");
INSERT INTO mnv_vpl VALUES ("MT7_28","070_7_28","MAT","7","28","28","Te gholoba na 'oti ai te gea 'anga a Jesus i na me'a nei, te 'apitanga noko he langalanga 'aki i ana akonga. ");
INSERT INTO mnv_vpl VALUES ("MT7_29","070_7_29","MAT","7","29","29","Iteme'agaa, ko Ia noko ako o noho mai pe te pegea hai taganga, o he'e noho pe ogatou ako i na tagangonga. ");
INSERT INTO mnv_vpl VALUES ("MT8_1","070_8_1","MAT","8","1","1","Te 'aso na iho mai ai a Jesus i te ogo, te 'apitanga noko tata'o ia te Ia. ");
INSERT INTO mnv_vpl VALUES ("MT8_2","070_8_2","MAT","8","2","2","A'u te launatasi tangata kahoa o toko tugi i 'ago ia Jesus o hai atu, “Hakahua, nimaa siahai Koe ke hai, hai mai ia te au kau ma'a!” ");
INSERT INTO mnv_vpl VALUES ("MT8_3","070_8_3","MAT","8","3","3","'Oso atu a Jesus kia te tangata nei o hai atu, “Ko Au manga siahai kau hai 'ia ia te koe ke ma'a. Ma'a ake!” Ma te ghali o mahu i tena kahoa 'anga. ");
INSERT INTO mnv_vpl VALUES ("MT8_4","070_8_4","MAT","8","4","4","Ka noko hai atu kinai a Jesus, “Ina mai, noka tau 'atigongo ai ki he pegea, kae manga hinatu o haka 'agi ia te koe ki te priest, ma te haiga'a kinai nia noko tuku e Moses ke hai, ke konei na taukimata ai koe ki te 'apitanga ko koe kua ma'a.” ");
INSERT INTO mnv_vpl VALUES ("MT8_5","070_8_5","MAT","8","5","5","Te 'aso na hetae ai a Jesus ki Capernaum, te hutiaki o na pegea hai tau'a o Rome noko a'u kia te Ia, ke haka ene kinai he 'abakinga. ");
INSERT INTO mnv_vpl VALUES ("MT8_6","070_8_6","MAT","8","6","6","O hai atu, “Hakahua, toku guani manga teka i te hage, e taa haka pikipiki kae hu'ai tutahi.” ");
INSERT INTO mnv_vpl VALUES ("MT8_7","070_8_7","MAT","8","7","7","Ma te hai atu a Jesus, “E hai kau hano o haka ma'ugi 'ia.” ");
INSERT INTO mnv_vpl VALUES ("MT8_8","070_8_8","MAT","8","8","8","Te tugi tau'a noko haka tau kinai o hai atu, “Koau e he'e 'aonga ki te hano Koe ki goto i toku hage, ka manga gea i ma'au he kupu, ka ke ma'ugi ai toku guani. ");
INSERT INTO mnv_vpl VALUES ("MT8_9","070_8_9","MAT","8","9","9","Iteme'agaa ko au te pegea manga hakahua 'ia ma'u, kae iai te tu'uganga i na pegea hai tau'a e haka hua eau. Nimaa hai atu au ki tegaa, ‘Hinatu!’ koia e hai ke hano. Nimaa hai atu au ki tegaa, ‘A'u!’ koia e hai ke a'u. Nimaa hai atu au ki toku guani, ‘Hai atu te me'a nei!’ ka hai eia.” ");
INSERT INTO mnv_vpl VALUES ("MT8_10","070_8_10","MAT","8","10","10","Te gholoba noko haka gongo kinai a Jesus, ko Ia noko gege ma'ugi o hai atu ki na pegea noko he tata'o 'aki ia te Ia, “Ko Au e gea maa'ogi kia te koutou: Ko Au e he'e kite i he pegea i Israel ke konei na hua'eha te sano. ");
INSERT INTO mnv_vpl VALUES ("MT8_11","070_8_11","MAT","8","11","11","Ko Au e hai atu kia te koutou, e 'eha pegea ka go boomai mai matangi ma gago, ka go noho 'aki haka pata kia Abraham ma Isaac ma Jacob i te haka tahinga i te Nuku i te gangi. ");
INSERT INTO mnv_vpl VALUES ("MT8_12","070_8_12","MAT","8","12","12","Ka na pegea mai Jew noko hai ke go noho 'aki i te nuku nei, ka go seu ki na poo'uginga o haho, ko kigatou ka go noko magegepe ma te he taangisi 'aki ogatou niho.” ");
INSERT INTO mnv_vpl VALUES ("MT8_13","070_8_13","MAT","8","13","13","Mugi a Jesus o hai atu ki te hutiaki ona pegea hai tau'a, “Hoki atu, na'e hai ke hai ke papata ki te sano o 'ou.” Kae ma'ugi tena guani i te gholoba na. ");
INSERT INTO mnv_vpl VALUES ("MT8_14","070_8_14","MAT","8","14","14","Te gholoba noko hano ai a Jesus ki te hage o Peter, o ina ki te tinana hungabai o Peter noko 'augia o manga takoto i te kaainga. ");
INSERT INTO mnv_vpl VALUES ("MT8_15","070_8_15","MAT","8","15","15","Ma te 'oso a Jesus ki te gima, kae manga 'oti tena 'augia 'anga. Ma te 'aga hoki te hahine nei o gosigosi utunga kia te Ia. ");
INSERT INTO mnv_vpl VALUES ("MT8_16","070_8_16","MAT","8","16","16","Nimaa i te ahiahi, 'eha pegea he uguhia 'aki noko kakabe 'ia kia Jesus, ka noko manga gea kinai, o boo 'aatea ai na haagiki songo ma te haka ma'ugi e Ia ba'i pegea masasaki. ");
INSERT INTO mnv_vpl VALUES ("MT8_17","070_8_17","MAT","8","17","17","Te hai 'anga nei noko hai o haka maa'ogi ai nia noko gea kinai te taauga ia Isaiah: “Kua to'o e Ia otatou sangasongo, ma te 'amo e Ia otatou sa'osaga.” ");
INSERT INTO mnv_vpl VALUES ("MT8_18","070_8_18","MAT","8","18","18","Te gholoba noko ina ai a Jesus ki te 'apitanga kua ghigho ia te Ia, hakaunga unga a Jesus ke toghi ki tegaa pa'asi i te gano. ");
INSERT INTO mnv_vpl VALUES ("MT8_19","070_8_19","MAT","8","19","19","Ma te a'u te ako o na tagangonga o hai atu kia te Ia, “Ako, e hai kau tata'o ia te Koe ki ba'i kunga ka hano kinai Koe.” ");
INSERT INTO mnv_vpl VALUES ("MT8_20","070_8_20","MAT","8","20","20","Ma te haka tau kinai a Jesus o hai atu, “Na tokitoki o mouku e hai ogatou kagi, ma na manu he gegei e hai ogatou aliu, ka te Hosa o Pegea e he'e kitea he kunga ke haka mapu kinai te 'ugu.” ");
INSERT INTO mnv_vpl VALUES ("MT8_21","070_8_21","MAT","8","21","21","Ma te hai atu tegaa tasi pegea haka ako, “Hakahua, tuku mai kau mataa hoki ke go tanu ia tamau.” ");
INSERT INTO mnv_vpl VALUES ("MT8_22","070_8_22","MAT","8","22","22","Ka ko Jesus noko hai atu kia te ia, “Tata'o mai ia te Au, kae tuku atu na pegea mamate ke tanu ogatou pegea mamate.” ");
INSERT INTO mnv_vpl VALUES ("MT8_23","070_8_23","MAT","8","23","23","Kae sopo a Jesus ki te baka, ma te tata'o ai ona pegea haka ako. ");
INSERT INTO mnv_vpl VALUES ("MT8_24","070_8_24","MAT","8","24","24","Kae manga he gegema'ugi 'aki i te too te hu'ai huukenga to'a ki te gano, hati na ngagu o tango te baka, ka ko Jesus noko manga moe. ");
INSERT INTO mnv_vpl VALUES ("MT8_25","070_8_25","MAT","8","25","25","Boo ake na pegea haka ako o baa 'aga ia te Ia o hai atu, “Hakahua, haka soi ake ia te kitatou. Na'e ko kitatou ka mamate!” ");
INSERT INTO mnv_vpl VALUES ("MT8_26","070_8_26","MAT","8","26","26","Haka tau atu a Jesus, “ 'Eaa koutou e matataku toto'a ai? 'Outou sano hu'ai gigiki!” 'Io tu'u Ia o susugi na oko ma na ngagu, kae manga pau o magino. ");
INSERT INTO mnv_vpl VALUES ("MT8_27","070_8_27","MAT","8","27","27","Na taangata nei na he langalanga 'aki, ma te haka anuanu 'aki, “ 'Ai te tangata aa 'okoia tenei? He'e po na oko ma na ngagu e mangangao kia te Ia.” ");
INSERT INTO mnv_vpl VALUES ("MT8_28","070_8_28","MAT","8","28","28","Nimaa tatae a Jesus ki te kakai 'anga i Gadara i tegaa pa'asi i te gano, noko iai gua taangata he uguhia 'aki noko manga he kakai 'aki i te 'atu takotonga. Ko kigaaua noko 'atua hekai toto'a, o he'e kitea he pegea sehu i te kunga nei. Ko kigaaua noko boomai o bilaabei ma Jesus, ");
INSERT INTO mnv_vpl VALUES ("MT8_29","070_8_29","MAT","8","29","29","o ngengege atu, “Ko Koe te Hosa o God! Niaa te siahai Koe ke hai kia te kimaaua? Ko Koe e a'u ki te kunga nei ke hai ia te kimaaua, kimaaua haka gongo songo, ka te koi he'e hetae te 'aso mogimogi?” ");
INSERT INTO mnv_vpl VALUES ("MT8_30","070_8_30","MAT","8","30","30","Noko iai te hu'ai tugaa piki, noko manga haangai haka hitaiaki kia te kigaaua. ");
INSERT INTO mnv_vpl VALUES ("MT8_31","070_8_31","MAT","8","31","31","Na haagiki songo noko he sasaka 'aki kia Jesus, “Nimaa pagepage e Koe ia te kimatou, haka to'o atu ia te kimatou ki te tugaa piki.” ");
INSERT INTO mnv_vpl VALUES ("MT8_32","070_8_32","MAT","8","32","32","Hai atu a Jesus ki na haagiki songo, “Boo atu!” Ma te boo na haagiki o he uguhi i na piki, ma te he 'agiko iho na piki ngatahi ki te tihatiha 'anga na kapa o te gano, o 'u'utu o mamate ki te bai. ");
INSERT INTO mnv_vpl VALUES ("MT8_33","070_8_33","MAT","8","33","33","Na pegea noko ge'o na piki, na he'agiko, o boo ki te hu'ai manaha o he 'atigongo 'aki i na hai 'anga nei, ma te 'atigongo 'aki ma'u i nia kua hai kia gua taangata noko he uguhia 'aki. ");
INSERT INTO mnv_vpl VALUES ("MT8_34","070_8_34","MAT","8","34","34","Te 'apitanga i te hu'ai manaha nei na boo ngatahi ke bilaabei ma Jesus. Te gholoba na hiina'i ai kigatou kia te Ia, ko kigatou na haka ene 'aki kia te Ia ke hano i tegatou kakai 'anga. ");
INSERT INTO mnv_vpl VALUES ("MT9_1","070_9_1","MAT","9","1","1","Ko Jesus noko sopo ki te baka o toghi i te gano ki tena manaha. ");
INSERT INTO mnv_vpl VALUES ("MT9_2","070_9_2","MAT","9","2","2","Kakabe kinai e na taangata te tangata taa haka pikipiki, noko manga teka i te kaupea. Te gholoba noko ina ai a Jesus ki te sano o 'ogatou, ma te hai atu ki te tangata taa haka pikipiki, “Magaohie ake, tama; na'e ou 'oosongo kua haka noka.” ");
INSERT INTO mnv_vpl VALUES ("MT9_3","070_9_3","MAT","9","3","3","Te hai 'anga nei, noko iai kogaa i na ako o na tagangonga noko hegeu soko o hai ake, “Te pegea nei e igho to'a kia te 'Aitu!” ");
INSERT INTO mnv_vpl VALUES ("MT9_4","070_9_4","MAT","9","4","4","Noko na'a e Jesus agatou maanatu nei, ma te hai atu, “Tehea te hai 'anga e konaa autou maanatu songo ai i outou uso? ");
INSERT INTO mnv_vpl VALUES ("MT9_5","070_9_5","MAT","9","5","5","Tehea te hai 'anga e hai ngaohie, te hai atu: ‘Ou 'oosongo kua haka noka,’ po te hai atu: ‘Tu'u ake o sehu?’ ");
INSERT INTO mnv_vpl VALUES ("MT9_6","070_9_6","MAT","9","6","6","Kae hai ke na'a e koutou, te Hosa o Pegea te hai taganga i te kege nei ke haka noka na 'oosongo.” Ma te hai atu ki te tangata piki piki, “Tu'u ake, o to'o tou kaupea o hoki ki tou manaha.” ");
INSERT INTO mnv_vpl VALUES ("MT9_7","070_9_7","MAT","9","7","7","Ma te tu'u te tangata o hoki ki tena manaha. ");
INSERT INTO mnv_vpl VALUES ("MT9_8","070_9_8","MAT","9","8","8","Te gholoba noko hiina'i ai te 'apitanga ki te hai 'anga nei, ko kigatou na matataku, ma te haka e'eha e kigatou ia te 'Aitu, kua haiga'a kia pegea te hainga taganga konei o na noho. ");
INSERT INTO mnv_vpl VALUES ("MT9_9","070_9_9","MAT","9","9","9","Nimaa hano a Jesus i te kunga na, ko Ia noko ina ki te tangata tena ingoa ko Matthew, te pegea tibu takis, noko manga noho i te kunga hai hekau o 'ona. Hai atu kinai a Jesus, “Tata'o mai ia te Au.” Ma te tu'u a Matthew o tata'o ia te Ia. ");
INSERT INTO mnv_vpl VALUES ("MT9_10","070_9_10","MAT","9","10","10","Te gholoba na kai ai a Jesus i te hage o Matthew, noko 'eha pegea tibu takis ma gaa pegea 'oosongo noko boo ake o kai haka pigi kia Jesus ma ona pegea haka ako. ");
INSERT INTO mnv_vpl VALUES ("MT9_11","070_9_11","MAT","9","11","11","Te gholoba na hiina'i ai kinai na Pharisee, ko kigatou noko haka anuanu 'aki ki ona pegea haka ako o hai atu, “Tehea te hai 'anga e kai haka pigi ai te ako o 'outou ki na pegea tibu takis ma kogaa pegea 'oosongo?” ");
INSERT INTO mnv_vpl VALUES ("MT9_12","070_9_12","MAT","9","12","12","Ko Jesus na haka gongo atu kinai, ma te hai atu, “E he'e na pegea toka te siahahai pegea hetauaki masaki, ka manga na pegea masasaki. ");
INSERT INTO mnv_vpl VALUES ("MT9_13","070_9_13","MAT","9","13","13","Kae boo atu o na'a po tehea te gaataki o te gea 'anga nei: ‘Ko Au manga siahai ki na kumu pegea 'anga, ka he'e na giunga.’ Iteme'agaa ko Au noko he'e a'u kau hai'ina na pegea tinogaoi ke boomai kia te Au, ka na pegea 'oosongo ina.” ");
INSERT INTO mnv_vpl VALUES ("MT9_14","070_9_14","MAT","9","14","14","Mugi na pegea haka ako o John Baptist, o boo ake, o he haka anuanu 'aki kia Jesus o hai atu, “Tehea te hai 'anga manga 'eha 'aso he'e kai i te sogi ai kimatou ma na Pharisee, ka manga he'e hai e na pegea haka ako o'ou?” ");
INSERT INTO mnv_vpl VALUES ("MT9_15","070_9_15","MAT","9","15","15","Ma te haka tau a Jesus o hai atu, “E hai ke kohea na maagegepe na usunga a te tangata hai uguugu ho'ou i te gholoba koi haka pata ai kia te kigatou? Na 'aso kago a'u, te hai ke go to'o 'aatea 'ia ai te tangata hai uguugu ho'ou ia te kigatou, 'io go he'e kai i te sogi a kigatou. ");
INSERT INTO mnv_vpl VALUES ("MT9_16","070_9_16","MAT","9","16","16","“Kae he'e kitea he pegea lapui he pa'asi laoa ho'ou ke 'ato ai he ake mai gaa'aso iteme'agaa te pa'asi laoa ho'ou kago laga boga eia te ake mai gaa'aso, ka go hai ma'u eia te malagi 'anga o tutahi. ");
INSERT INTO mnv_vpl VALUES ("MT9_17","070_9_17","MAT","9","17","17","“E he'e kitea ma'u ni pegea 'utuhaki ni waeni ho'ou ki ni me'a pipiki waeni mai gaa'aso. Nimaa konei ona hai, na me'a 'utu waeni ka maha'aha'a o magingi te waeni kae momomomo na me'a pipiki waeni. Ka manga 'utu e kigatou na waeni ho'ou ki na me'a pipiki waeni ho'ou, ka ke gaoi ngatahi gua me'a nei.” ");
INSERT INTO mnv_vpl VALUES ("MT9_18","070_9_18","MAT","9","18","18","Te gholoba noko manga koi konei na gea ai a Jesus, kae a'u te hakahua o te Hage hai paaunga o toko tugi i 'ago ia te Ia, o hai atu, “Taku tama 'ahine kua mate, kae a'u o haka eke ou gima ia te ia ka ke ma'ugi.” ");
INSERT INTO mnv_vpl VALUES ("MT9_19","070_9_19","MAT","9","19","19","Ma te tu'u a Jesus o tata'o ma ona pegea haka ako ia te Ia. ");
INSERT INTO mnv_vpl VALUES ("MT9_20","070_9_20","MAT","9","20","20","Ka noko iai ma'u te hahine masaki noko hano na tino o katoa tuma'a e gua ona ghapu, ko ia noko 'agu mugi ia Jesus o 'oso ki te kapa o tena ake. ");
INSERT INTO mnv_vpl VALUES ("MT9_21","070_9_21","MAT","9","21","21","Te hahine noko hai ake tena maanatu, “Poi manga 'oso au ki tena ake, ko au ka ma'ugi.” ");
INSERT INTO mnv_vpl VALUES ("MT9_22","070_9_22","MAT","9","22","22","Ma te taka hugi a Jesus o ina 'atu kia te ia o hai atu, “Magaohie ake ta'ahine, na'e tou sano kua hai ia te koe o ma'ugi.” Ka te hahine na ma'ugi i te mi'i gholoba na. ");
INSERT INTO mnv_vpl VALUES ("MT9_23","070_9_23","MAT","9","23","23","Te 'aso na hetae ai a Jesus ki te hage o te hakahua, ko Ia noko ina ki na pegea noko manga pusi kohe, ma te 'apitanga manga magegepe, ");
INSERT INTO mnv_vpl VALUES ("MT9_24","070_9_24","MAT","9","24","24","ma te hai atu Ia, “Boo atu, na'e te mi'i hahine nei e he'e mate ka manga moe.” Kae manga kakata a kigatou kia te Ia. ");
INSERT INTO mnv_vpl VALUES ("MT9_25","070_9_25","MAT","9","25","25","Nimaa 'oti i te pagepage 'anga te 'apitanga, kae hano Ia ki goto o 'oso ki te gima o te mi'i hahine o ta'aki, ma te 'aga o tu'u. ");
INSERT INTO mnv_vpl VALUES ("MT9_26","070_9_26","MAT","9","26","26","Te gongo o te hai 'anga nei na hohoga ki ba'i kunga i te kakai 'anga nei. ");
INSERT INTO mnv_vpl VALUES ("MT9_27","070_9_27","MAT","9","27","27","Nimaa hano 'aatea a Jesus i te kungaa, te toka gua taangata kikibi noko tata'o ia Jesus, o ngengege atu, “Ko Koe, te Hosa o David, 'agoha mai ia te kimaaua!” ");
INSERT INTO mnv_vpl VALUES ("MT9_28","070_9_28","MAT","9","28","28","Te gholoba na ugu ai a Jesus ki goto i te hage, gua taangata kikibi noko boo ake kia te Ia, ma te haka anu a Jesus kia te kigaaua o hai atu, “Kougua e sano ake e 'aonga te hai e Au te hai 'anga nei?” Ma te haka tau a kigaaua o hai atu, “ 'Oo, Hakahua.” ");
INSERT INTO mnv_vpl VALUES ("MT9_29","070_9_29","MAT","9","29","29","Ma te 'oso a Jesus ki ogaua mata kae hai atu, “Ke hai kia te kougua ke papata ki na sano o 'ougua.” ");
INSERT INTO mnv_vpl VALUES ("MT9_30","070_9_30","MAT","9","30","30","Ma te luga luga ogaua mata, kae susugi e Jesus ia te kigaaua ke go noka te he 'atigongo 'aki ki he pegea i te hai 'anga nei. ");
INSERT INTO mnv_vpl VALUES ("MT9_31","070_9_31","MAT","9","31","31","Ka na boo a kigaaua o hohoga te gongo o Jesus i te kakai 'anga nei. ");
INSERT INTO mnv_vpl VALUES ("MT9_32","070_9_32","MAT","9","32","32","Te gholoba na boo ai kigaaua, noko kakabe ake 'ia kia Jesus te tangata uguhia kae he'e gea. ");
INSERT INTO mnv_vpl VALUES ("MT9_33","070_9_33","MAT","9","33","33","Te gholoba na pagepage ai e Jesus te 'atua, te tangata he'e gea nei na gea. Te 'apitanga na hegege ma'ugi 'aki ma te hai ake, “Noko si'ai ni hai 'anga konei ona noho ke hiina'i kinai i Israel.” ");
INSERT INTO mnv_vpl VALUES ("MT9_34","070_9_34","MAT","9","34","34","Ka na Pharisee noko hai ake, “E pagepage e Ia na haagiki i na taganga o te hakahua o na haagiki songo.” ");
INSERT INTO mnv_vpl VALUES ("MT9_35","070_9_35","MAT","9","35","35","Ko Jesus noko hano ki ba'i hu'ai manaha ma na mi'i manaha, o manga ako i ogatou Hage hai paaunga, ma te tohi'aki i te Gongo Gaoi o te Hakahua 'anga a te 'Aitu. Ma te hakanoka ba'i sa'o saga ma te haka ma'ugi ba'i masaki. ");
INSERT INTO mnv_vpl VALUES ("MT9_36","070_9_36","MAT","9","36","36","Te gholoba noko ina ai a Jesus ki te 'apitanga nei, noko hu'ai 'agoha kia te kigatou, iteme'agaa ko kigatou manga hai songo 'ia ma te he'e tau saanonga, o noho pe na sipisipi he'e tau pegea ge'o. ");
INSERT INTO mnv_vpl VALUES ("MT9_37","070_9_37","MAT","9","37","37","Ma te hai atu ki ona pegea haka ako, “E 'eha to'a na 'umanga kua matu'a o ngaague ke utu, kae he'e 'api pegea ke hai hekau ai. ");
INSERT INTO mnv_vpl VALUES ("MT9_38","070_9_38","MAT","9","38","38","Takunga atu ai ki te hakahua o na 'umanga, kego haka to'o e Ia ni pegea hai hekau ke utu ona 'umanga.” ");
INSERT INTO mnv_vpl VALUES ("MT10_1","070_10_1","MAT","10","1","1","Ko Jesus noko ngege i tena katoa tuma'a e gua pegea haka ako o boomai kia te Ia, o haiga'a taganga kia te kigatou, ke pagepage 'atua, ma te hetauaki ba'i sa'o saga, ma ba'i masaki. ");
INSERT INTO mnv_vpl VALUES ("MT10_2","070_10_2","MAT","10","2","2","Konei na ingoa o te katoa tuma'a e gua pegea haka to'o: Te pegea mu'a ko Simon, (noko mate ko Peter) ma te taina ia Andrew. Ko James te hosa o Zebedee, ma te taina ia John. ");
INSERT INTO mnv_vpl VALUES ("MT10_3","070_10_3","MAT","10","3","3","Ko Philip ma Bartholomew. Ko Thomas ma Matthew te tangata tibu takis. Ko James te hosa o Alphaeus, ma Thaddaeus. ");
INSERT INTO mnv_vpl VALUES ("MT10_4","070_10_4","MAT","10","4","4","Ko Simon te ‘zealot’, ma Judas Iscariot noko haka soko eia ia Jesus. ");
INSERT INTO mnv_vpl VALUES ("MT10_5","070_10_5","MAT","10","5","5","Te katoa tuma'a e gua pegea nei, noko haka to'o e Jesus, kae konei na tongitongi aki ia te kigatou, “Noka te boo ki na pegea 'aatea. Noka ma'u te boo ki he hu'ai manaha mo'ona pegea mai Samaria. ");
INSERT INTO mnv_vpl VALUES ("MT10_6","070_10_6","MAT","10","6","6","Kae manga boo atu ki na pegea o Israel kua boo 'aatea ia God. ");
INSERT INTO mnv_vpl VALUES ("MT10_7","070_10_7","MAT","10","7","7","Tautou boo 'anga, tohi'aki atu kinai i te gongo nei: ‘Te Hakahua 'anga a te 'Aitu kua hitaiaki.’ ");
INSERT INTO mnv_vpl VALUES ("MT10_8","070_10_8","MAT","10","8","8","Haka ma'ugi atu na pegea masasaki, ma te baa 'aga na pegea mamate, ma te haka ma'ugi na pegea kahoa ke ma'a, ma te pagepage na haagiki songo. Na taganga nei manga ga'u tausu'u e koutou, kae sui atu o hai tausu'u ki gaa pegea. ");
INSERT INTO mnv_vpl VALUES ("MT10_9","070_10_9","MAT","10","9","9","Noka te to'o ni golu, ma ni siliva, ma ni mane i autou oko oko. ");
INSERT INTO mnv_vpl VALUES ("MT10_10","070_10_10","MAT","10","10","10","Noka te to'o he kete i te lango 'anga nei, po he tokagua ake, po ni taka ba'e po he tokotoko, iteme'agaa te pegea hai hekau e gaoi te haiga'a kinai nia e siahai kinai. ");
INSERT INTO mnv_vpl VALUES ("MT10_11","070_10_11","MAT","10","11","11","“Na 'aso kago boo ai koutou ki he hu'ai manaha po he mi'i manaha, ogo ligo atu he pegea gaoi, ogo haka pata kia te ia i tena hage aano hetae te 'aso boo o 'outou i te manaha. ");
INSERT INTO mnv_vpl VALUES ("MT10_12","070_10_12","MAT","10","12","12","Koutou nimaa go he uguhi ki goto i he hage, ogo hai atu, ‘Te goto maagie o God ke haka pata kia te koutou.’ ");
INSERT INTO mnv_vpl VALUES ("MT10_13","070_10_13","MAT","10","13","13","Ka na pegea i te hage nimaa haka pogo ia te koutou, tuku atu te goto maagie o'outou ke noho kia te kigatou. ");
INSERT INTO mnv_vpl VALUES ("MT10_14","070_10_14","MAT","10","14","14","Ka nimaa iai ni pegea e he'e haka pogo ia te koutou ki ogatou hage, poe he'e sia haka gongo ki autou gegea 'anga, ogo tuutuu atu na tobeabu i outou tapungao i te 'aso e boo ai koutou i te manaha. ");
INSERT INTO mnv_vpl VALUES ("MT10_15","070_10_15","MAT","10","15","15","Ko Au e gea maa'ogi kia te koutou: Te 'aso kago haka aba ai e te 'Aitu ia pegea, kago hua'eha te kagohia kago tuku e Ia ki na pegea i te manaha na o sigi i na pegea noko noho 'aki i Sodom ma Gomorrah. ");
INSERT INTO mnv_vpl VALUES ("MT10_16","070_10_16","MAT","10","16","16","“Koutou e haka to'o e Au nei, manga noho pe na sipisipi boo haka higo ki goto i na tokitoki 'atuahekai hai maka. Tenei te hai 'anga e hai koutou he 'igo'igo 'aki ai ke noho pe na ngata, ma te ngongoto he'e hai tau'a ke noho pe na gupe. ");
INSERT INTO mnv_vpl VALUES ("MT10_17","070_10_17","MAT","10","17","17","“Ka koutou na'ana'a atu kia pegea, ko kigatou kago haiga'a ia te koutou ki te puugenga ke haka aba, ma te kogu ia te koutou i na Hage hai paaunga. ");
INSERT INTO mnv_vpl VALUES ("MT10_18","070_10_18","MAT","10","18","18","I te ghaghinga ia te Au, koutou kago kakabe 'ia ki 'ago i na hu'ai hakahua ma na king, kego 'atigongo atu koutou i te Gongo Gaoi kia te kigatou ma na pegea 'aatea. ");
INSERT INTO mnv_vpl VALUES ("MT10_19","070_10_19","MAT","10","19","19","Te 'aso kago he 'osohi ai kia te koutou o kakabe ki te haka aba, ogo noka tautou maikia po nia hai koutou go gegea ai poe kohea autou to'o, na'e nia e hai koutou go gegea ai e hai ke go haiga'a kia te koutou i te 'aso na. ");
INSERT INTO mnv_vpl VALUES ("MT10_20","070_10_20","MAT","10","20","20","Iteme'agaa he'e ko koutou te hai ke go gegea, ka te Spirit Tapu o te Tamana o'outou, te hai ke go gea ke agatu'u ia te koutou. ");
INSERT INTO mnv_vpl VALUES ("MT10_21","070_10_21","MAT","10","21","21","“Na taangata kago haka soko ogatou taina ke taa 'ia ke mamate. Te tamana kago konei na hai ma'u kia tena tama'iti'iti. Na tama giki kago haka hetata'i ki ogatou hai maatu'a, ma te kago haiga'a ia te kigatou ke taa 'ia ke mamate. ");
INSERT INTO mnv_vpl VALUES ("MT10_22","070_10_22","MAT","10","22","22","Ko ba'i pegea kago mikau'a kia te koutou, i te ghaghi ia te Au, ka koai kago tu'u o ma'u ano hetae ki te 'otinga, tenaa ia kago ma'ugi. ");
INSERT INTO mnv_vpl VALUES ("MT10_23","070_10_23","MAT","10","23","23","Koutou nimaa go hai songo 'ia i he manaha, ogo he 'agiko atu ki tegaa manaha. Ko Au e gea maa'ogi kia te koutou: Koutou kago he'e 'oti i te boo ki na manaha o Israel, kae a'u te Hosa o Pegea. ");
INSERT INTO mnv_vpl VALUES ("MT10_24","070_10_24","MAT","10","24","24","“Te pegea koi haka ako e he'e 'igo'igo o sigi i tena ako. Te guani e he'e hua'eha o sigi i tena hakahua. ");
INSERT INTO mnv_vpl VALUES ("MT10_25","070_10_25","MAT","10","25","25","Te pegea koi haka ako manga 'aonga te noho po tena ako, te guani ma'u manga 'aonga te noho po tena hakahua. Ka te hakahua o te hage nimaa mate 'ia ko Beelzebub, te hakahua o na haagiki, kago soo atu te hai songo 'ia na pegea i tena hage. ");
INSERT INTO mnv_vpl VALUES ("MT10_26","070_10_26","MAT","10","26","26","“Kae noka te matataku kia te kigatou, na'e ko ba'i hai 'anga ngigo i na 'aso nei, e hai ke go haka 'agi ke na'a. ");
INSERT INTO mnv_vpl VALUES ("MT10_27","070_10_27","MAT","10","27","27","Nia e 'atigongo ai Au kia te koutou i te poo'uginga, ogo gegea atu ai koutou i he 'ao. Nia e palana ai Au ki 'outou taginga, go 'atigongo haka maa hoga atu ai i na tu'aa hage. ");
INSERT INTO mnv_vpl VALUES ("MT10_28","070_10_28","MAT","10","28","28","Noka te matataku ki na pegea manga taa na tino kae he'e taa na ma'ugi, kae manga matataku atu kia God e 'aonga te hai songo ngatahi e Ia na tino ma na ma'ugi i te ugaimami. ");
INSERT INTO mnv_vpl VALUES ("MT10_29","070_10_29","MAT","10","29","29","Te tokagua mi'i manu manga 'aonga te tau'i i he mi'i mane e tasi. Masi'igoa e konei na noho, kae kago he'e toiho ai he launatasi ki te kege i taha i te kumu o te Tamana o 'outou. ");
INSERT INTO mnv_vpl VALUES ("MT10_30","070_10_30","MAT","10","30","30","He'e po na gau 'ugu o 'outou manga na'a e Ia 'ona taunga. ");
INSERT INTO mnv_vpl VALUES ("MT10_31","070_10_31","MAT","10","31","31","Kae noka tautou matataku, na'e koutou hu'ai gaoi toto'a kia te 'Aitu o sigi i na mi'i manu e 'eha. ");
INSERT INTO mnv_vpl VALUES ("MT10_32","070_10_32","MAT","10","32","32","“Koai kago 'atigongo ia te Au i 'ago ia pegea, koia e hai kau go 'atigongo ai i 'ago ia Tamau e noho i te gangi. ");
INSERT INTO mnv_vpl VALUES ("MT10_33","070_10_33","MAT","10","33","33","Ka koai kago haka si'ai ia te Au i 'ago i ba'i pegea, e hai kau go haka si'ai 'ia ia te ia i 'ago ia Tamau e noho i te gangi. ");
INSERT INTO mnv_vpl VALUES ("MT10_34","070_10_34","MAT","10","34","34","“Noka te tegeu'a ake e to'o mai e Au te goto maagie ki te kege nei. Ko Au he'e a'u kau to'o mai 'ia te goto maagie, ka te kiba hai tau'a. ");
INSERT INTO mnv_vpl VALUES ("MT10_35","070_10_35","MAT","10","35","35","Taku a'u 'anga nei, ka baghaghi ai: te hosa ke ngatu'a ki tena tamana, te tama 'ahine ke ngatu'a ki tena tinana, te tama 'ahine hungabai ke ngatu'a ki tena tinana hungabai. ");
INSERT INTO mnv_vpl VALUES ("MT10_36","070_10_36","MAT","10","36","36","Na makau o te pegea kago hai i na 'atima'ogi o'ona. ");
INSERT INTO mnv_vpl VALUES ("MT10_37","070_10_37","MAT","10","37","37","Koai e ma'ine kia te tamana po kia te tinana o sigi ia te Au, e he'e 'aonga te tata'o ia te Au; koai e ma'ine ki tena hosa po ki tena tama 'ahine o sigi ia te Au, koia e he'e 'aonga te tata'o ia te Au. ");
INSERT INTO mnv_vpl VALUES ("MT10_38","070_10_38","MAT","10","38","38","Ka koai e he'e 'amo tena kros o 'agu mai ia te Au, koia e he'e 'aonga te hai ai mo'oku he pegea. ");
INSERT INTO mnv_vpl VALUES ("MT10_39","070_10_39","MAT","10","39","39","Koai manga kumu i te ma'ugi, e hai ke go he'e kitea. Ka koai e hai ti'aki te ma'ugi i te ghaghi ia te Au, e hai ke go ga'u eia te ma'ugi. ");
INSERT INTO mnv_vpl VALUES ("MT10_40","070_10_40","MAT","10","40","40","“Koai kago haka pogo ia te koutou, e haka pogo eia ia te Au. Ka koai e haka pogo eia ia te Au, e haka pogo ia te Ia noko haka to'o mai ia te Au. ");
INSERT INTO mnv_vpl VALUES ("MT10_41","070_10_41","MAT","10","41","41","Ka koai e haka pogo eia he taauga, i te tegeu'a ake ia, te taauga tenei, e hai ke go ga'u eia te giu'aki o te taauga. Ka koai e haka pogo eia he pegea haka tinogaoi, i te tegeu'a ake ia, te pegea haka tinogaoi tenei, e hai ke go ga'u eia te giu'aki o te pegea haka tinogaoi. ");
INSERT INTO mnv_vpl VALUES ("MT10_42","070_10_42","MAT","10","42","42","Ka koai e haiga'a eia he momo bai gogohi i he kapu ki he mi'i pegea i oku pegea nei, i te tegeu'a ake ia, tenei te pegea haka ako o 'Oku, ko Au e gea maa'ogi kia te koutou, e hai ke go ga'u eia tena giu'aki.” ");
INSERT INTO mnv_vpl VALUES ("MT11_1","070_11_1","MAT","11","1","1","Nimaa 'oti i te tongi aki e Jesus tena katoa tuma'a e gua pegea haka ako, kae hano 'aatea i te kungaa, ke ako ma te tohi'aki i na manaha i Galilee. ");
INSERT INTO mnv_vpl VALUES ("MT11_2","070_11_2","MAT","11","2","2","Ko John Baptist noko manga noho i te hage kagohia, ka te 'aso na gongo ai i nia manga hai e Christ, koia noko haka to'o kinai gua pegea haka ako o'ona. ");
INSERT INTO mnv_vpl VALUES ("MT11_3","070_11_3","MAT","11","3","3","Ke he haka anu anu 'aki kia te Ia o hai atu, “Tenaa Koe te pegea e hai ke go a'u, po kimatou hitagi i he pegea 'aatea?” ");
INSERT INTO mnv_vpl VALUES ("MT11_4","070_11_4","MAT","11","4","4","Ko Jesus noko haka tau kia te kigaaua o hai atu, “Giu atu o hogahoga kia John nia kua haka gongo ma te hiina'i kinai kougua: ");
INSERT INTO mnv_vpl VALUES ("MT11_5","070_11_5","MAT","11","5","5","Na pegea kikibi kua hiina'i, na pegea seu kua he boboo 'aki, na pegea noko kahoa kua he tauaki o ma'u'ugi, na pegea tugi kua haka gongo, na pegea mamate kua ma'u'ugi giu, ma na pegea lae kua tohi'aki kinai i te Gongo Gaoi. ");
INSERT INTO mnv_vpl VALUES ("MT11_6","070_11_6","MAT","11","6","6","Te hakagaoinga ki te pegea ka he'e hano 'aatea i te baaghaghi ia te Au.” ");
INSERT INTO mnv_vpl VALUES ("MT11_7","070_11_7","MAT","11","7","7","Te gholoba na boo ai gua pegea haka ako o John, ko Jesus noko haka tu'u gea ki te 'apitanga ia John, “Te 'aso noko boo ai koutou ki te tugatea, niaa te noko boo koutou ke hiina'i kinai? Te kaso hatu pusi loloku e te oko? ");
INSERT INTO mnv_vpl VALUES ("MT11_8","070_11_8","MAT","11","8","8","Ka nimaa si'ai, niaa te noko boo koutou ke hiina'i kinai? Te tangata ake i na 'ota'ota gaoi? Si'ai, kogaa na taangata ake i na 'ota'ota gaoi te manga noho 'aki i na hage o na hakahua. ");
INSERT INTO mnv_vpl VALUES ("MT11_9","070_11_9","MAT","11","9","9","Ka niaa te noko boo koutou ke hiina'i kinai? Te taauga? 'Oo, tenaa, ko Au e hai atu kia te koutou, ko John e hua'eha o sigi i na taauga. ");
INSERT INTO mnv_vpl VALUES ("MT11_10","070_11_10","MAT","11","10","10","Tenei ia noko kanukanu ai i na Kanukanu Tapu o hai ake: ‘E hai kego haka to'o mo'oku he pegea 'atigongo ke mu'a ia te Koe. Koia e hai ke go mataa haka ngaague mo'ou he aga, 'io mugi Koe.’ ");
INSERT INTO mnv_vpl VALUES ("MT11_11","070_11_11","MAT","11","11","11","Ko Au e gea maa'ogi kia te koutou, e si'ai he pegea haka haa i he hahine, e hua'eha o sigi ia John Baptist. Ka te mi'i pegea i te Hakahua 'anga a te 'Aitu, koia e hua'eha o sigi ia John. ");
INSERT INTO mnv_vpl VALUES ("MT11_12","070_11_12","MAT","11","12","12","Haka tu'u mai i na 'aso o John, o hetae mai ki te 'aso nei, te Hakahua 'anga a te 'Aitu e heha'ao kinai a pegea, ka na pegea keu ta'ane te kua sa'asa'a e kigatou. ");
INSERT INTO mnv_vpl VALUES ("MT11_13","070_11_13","MAT","11","13","13","Ko ba'i taauga ma na tagangonga noko manga he 'atigongo 'aki ai aano hetae mai kia John. ");
INSERT INTO mnv_vpl VALUES ("MT11_14","070_11_14","MAT","11","14","14","Ka koutou nimaa mangangao o too kinai, ko John ko Elijah noko hai ke mu'a mai. ");
INSERT INTO mnv_vpl VALUES ("MT11_15","070_11_15","MAT","11","15","15","Koai e hai na taginga, haka gongo ake ai! ");
INSERT INTO mnv_vpl VALUES ("MT11_16","070_11_16","MAT","11","16","16","“E hai kau kohea na haka papata ia te 'atu tangata nei? Ko kigatou manga noho pe na tama giki, taki noho 'aki i te kunga tau'i me'a o manga he ngengege 'aki: ");
INSERT INTO mnv_vpl VALUES ("MT11_17","070_11_17","MAT","11","17","17","‘Ko kimatou noko pusi kohe kia te koutou, ka noko he'e tau'aso koutou. Ko kimatou noko pugotu i te taugua haka 'aagoha, ka noko he'e magegepe koutou.’ ");
INSERT INTO mnv_vpl VALUES ("MT11_18","070_11_18","MAT","11","18","18","Iteme'agaa ko John noko a'u he'e kai, o he'e binu waeni, kae manga hai ake kigatou, ‘Koia e hai tena 'atua.’ ");
INSERT INTO mnv_vpl VALUES ("MT11_19","070_11_19","MAT","11","19","19","Nimaa a'u te Hosa o Pegea o manga kai ma te binu, hai ake kigatou, ‘Te pegea kai to'a ma te binu to'a tenei, ko Ia ma'u te hemasi'inga ana pegea tibu takis ma gaa pegea 'oosongo.’ Ka te 'igo'igo e haka 'agi maa'ogi e nia kua hai.” ");
INSERT INTO mnv_vpl VALUES ("MT11_20","070_11_20","MAT","11","20","20","Ma te gea haka sigisigi e Jesus na manaha noko hai taganga goa ai, iteme'agaa ko kigaaua noko he'e sui tegeu'a, ");
INSERT INTO mnv_vpl VALUES ("MT11_21","070_11_21","MAT","11","21","21","o hai atu, “Haka 'aagoha a koutou Chorazin, haka 'aagoha a koutou Bethsaida: Na hu'ai taganga noko hai ia te kougua, ka poi hai na taganga nei i Tyre ma Sidon, ko kigatou na goa te sui tegeu'a, ma te ake i ni bebe hakagogoo ma te haka gehugehu ogatou 'ugu. ");
INSERT INTO mnv_vpl VALUES ("MT11_22","070_11_22","MAT","11","22","22","Ka ko Au e hai atu kia te koutou, te 'aso kago haka aba ai e te 'Aitu a te kege nei, kago hua'eha te kagohia go tuku e Ia ki Chorazin ma Bethsaida o sigi i Tyre ma Sidon. ");
INSERT INTO mnv_vpl VALUES ("MT11_23","070_11_23","MAT","11","23","23","Ka ko koe Capernaum, 'ai ko koe kago nekeneke ki te 'agohi gangi? Si'ai, ko koe e hai kego haka sogogi ki poo'ugi, iteme'agaa na taganga noko hai ia te koe, poi noko hai i Sodom, ko Sodom manga koi noho o tatae mai ki te 'aso nei. ");
INSERT INTO mnv_vpl VALUES ("MT11_24","070_11_24","MAT","11","24","24","Ka ko Au e hai atu kia te koutou, te 'aso kago haka aba ai e te 'Aitu a te kege nei, kago hua'eha te kagohia kago tuku e Ia ki Capernaum o sigi i Sodom.” ");
INSERT INTO mnv_vpl VALUES ("MT11_25","070_11_25","MAT","11","25","25","Te 'aso na, ko Jesus noko konei ana sogi, “Tamau, ko Koe te Hakahua o te gangi ma te kege nei, ko Au e haka 'aue kia te Koe, iteme'agaa na hai 'anga nei noko huu e Koe i na pegea he 'igo'igo 'aki ma te na'a me'a, kae haka 'agi e Koe ki na pegea noho po na tama giki. ");
INSERT INTO mnv_vpl VALUES ("MT11_26","070_11_26","MAT","11","26","26","E na'a e Au Tamau, konei Au paaunga e maagaohie ai Koe. ");
INSERT INTO mnv_vpl VALUES ("MT11_27","070_11_27","MAT","11","27","27","“Ko ba'i hai 'anga kua haiga'a e Tamau kia te Au, e si'ai he pegea na'a eia te Hosa, ka manga ko te Tamana. E si'ai he pegea na'a eia te Tamana, ka manga ko tena Hosa ma na pegea haka pau e tena Hosa ke haka kite kinai ia te Tamana. ");
INSERT INTO mnv_vpl VALUES ("MT11_28","070_11_28","MAT","11","28","28","“Boomai kia te Au ba'i pegea maikia ma te mahatia kau haiga'a 'ia te oki oki kia te koutou. ");
INSERT INTO mnv_vpl VALUES ("MT11_29","070_11_29","MAT","11","29","29","To'o ake taku kau 'amo o haka eke ia te koutou, ma te haka ako ia te Au, na'e ko Au te pegea haka tautau ma te tegeu'a haka ma'u gago, ka Kau go haiga'a 'ia te oki oki ki na uso o 'outou. ");
INSERT INTO mnv_vpl VALUES ("MT11_30","070_11_30","MAT","11","30","30","Te kau 'amo a 'Aku e hai ngaohie, ma te kabenga a 'Aku e ma'ama'a.” ");
INSERT INTO mnv_vpl VALUES ("MT12_1","070_12_1","MAT","12","1","1","I na hainga 'aso na, ko Jesus ma ona pegea haka ako noko boo ai i te uso o te 'umanga witi i te 'Ao oki oki, ka ona pegea haka ako na he ongea 'aki ma te tohitohi e kigatou na witi o kai. ");
INSERT INTO mnv_vpl VALUES ("MT12_2","070_12_2","MAT","12","2","2","Ka na hiina'i kinai na pegea i na Pharisee, o hai atu ai kia Jesus, “Ina 'atu! 'Ou pegea haka ako e hai e kigatou nia noko susugi ena tagangonga ke noka te hai i te 'Ao oki oki.” ");
INSERT INTO mnv_vpl VALUES ("MT12_3","070_12_3","MAT","12","3","3","Ma te haka tau a Jesus o hai atu, “ 'Ai e he'e haka sahe e koutou nia te noko hai David, ma tena tu'uganga i tegatou he ongea 'aki 'anga? ");
INSERT INTO mnv_vpl VALUES ("MT12_4","070_12_4","MAT","12","4","4","Ko David na heuguhi ma tena tu'uganga ki goto i te hage o God. Koia ma tena tu'uganga na kai e kigatou na bred noko haiga'a kia God, noko tapu, he'e kai maasoko ka manga na tunihenua. ");
INSERT INTO mnv_vpl VALUES ("MT12_5","070_12_5","MAT","12","5","5","'Ai e he'e haka sahe ma'u e koutou i na tagangonga ki na tunihenua noko manga hai hekau i te Hage Tapu i ba'i 'Ao oki oki, ka he'e saga ai? ");
INSERT INTO mnv_vpl VALUES ("MT12_6","070_12_6","MAT","12","6","6","Ko Au e hai atu kia te koutou, e iai te pegea i te kunga nei e hua'eha o sigi i te Hage Tapu. ");
INSERT INTO mnv_vpl VALUES ("MT12_7","070_12_7","MAT","12","7","7","Ka poi na'a e koutou te gaataki ona haka hegeunga a te 'Aitu nei: ‘Ko Au manga siahai ki te he 'agogoha 'aki, ka he'e na giunga,’ manga noho mai manga he'e haka bagebage koutou ki na pegea he'e hai e kigatou he hai 'anga songo. ");
INSERT INTO mnv_vpl VALUES ("MT12_8","070_12_8","MAT","12","8","8","Iteme'agaa te Hosa o Pegea, te Hakahua o te 'Ao oki oki.” ");
INSERT INTO mnv_vpl VALUES ("MT12_9","070_12_9","MAT","12","9","9","Ko Jesus na hano i te kunga nei, o ugu ki goto i tegatou Hage hai paaunga, ");
INSERT INTO mnv_vpl VALUES ("MT12_10","070_12_10","MAT","12","10","10","o ina ki te tangata mate te gima i te kungaa. Ka ko kigatou noko ligo hai 'anga kigatou to'o ai ia Jesus ki te haka aba, kae hai atu, “Na tagangonga e tuku he pegea ke haka ma'ugi masaki i te 'Ao oki oki?” ");
INSERT INTO mnv_vpl VALUES ("MT12_11","070_12_11","MAT","12","11","11","Ka noko hai atu a Jesus kia te kigatou, “ 'Ai poi iai he pegea ia te koutou, e toiho ma'ana he sipisipi ki he pupu'a i te 'Ao oki oki, 'ai ka he'e 'oso iho kinai o sa'u ake? ");
INSERT INTO mnv_vpl VALUES ("MT12_12","070_12_12","MAT","12","12","12","Ka ko pegea e hu'ai gaoi o sigi i na sipisipi, tenei te hai 'anga noko tuku ai e na tagangonga kitatou hai hai 'anga gaoi i te 'Ao oki oki.” ");
INSERT INTO mnv_vpl VALUES ("MT12_13","070_12_13","MAT","12","13","13","Ma te hai atu ki te tangata, “Hohoga atu tou gima.” Nimaa hohoga te gima ma te pau te gima o soihua o noho pe tegaa gima. ");
INSERT INTO mnv_vpl VALUES ("MT12_14","070_12_14","MAT","12","14","14","Ma te boo na Pharisee o puge huu, poe hai kigatou go kohea na taa 'ia ia Jesus. ");
INSERT INTO mnv_vpl VALUES ("MT12_15","070_12_15","MAT","12","15","15","Ko Jesus noko na'a e Ia nia noko ma puge kigatou ke hai, ma te haka 'aatea ai Ia i te manaha, ka noko 'eha pegea noko tata'o ia te Ia, ma te haka ma'ugi e Ia i ogatou masaki ngatahi. ");
INSERT INTO mnv_vpl VALUES ("MT12_16","070_12_16","MAT","12","16","16","Noko haka pungaga e Jesus ia te kigatou, ke noka te 'atigongo ia te Ia. ");
INSERT INTO mnv_vpl VALUES ("MT12_17","070_12_17","MAT","12","17","17","Te hai 'anga nei noko hai ke haka maa'ogi ai nia noko gea ai te taauga ia Isaiah: ");
INSERT INTO mnv_vpl VALUES ("MT12_18","070_12_18","MAT","12","18","18","“Tenei toku guani, noko hakapupugu e Au. Tenei te launatasi e ma'ine kinai Au. Ko Ia ma'u e maagaohie kinai Au. E hai kau go tuku 'ia toku Spirit Tapu kia te Ia. E hai ke go hogahoga e Ia nia e tinogaoi ki na kunga henua. ");
INSERT INTO mnv_vpl VALUES ("MT12_19","070_12_19","MAT","12","19","19","Ko Ia kago he'e gea haka tauseke po e ngege, kago si'ai he launatasi ke haka gongo ki te ge'o o 'ona i na agatu'u. ");
INSERT INTO mnv_vpl VALUES ("MT12_20","070_12_20","MAT","12","20","20","Ko Ia kago he'e totohi e Ia he bugu tukia, po e tamate e Ia he peba mi'i kaa, o hano aano hai e Ia te tinogaoi ke sepu. ");
INSERT INTO mnv_vpl VALUES ("MT12_21","070_12_21","MAT","12","21","21","Te ingoa o'ona e hai ke go tuku sano kinai ba'i kakai 'anga i te kege nei.” ");
INSERT INTO mnv_vpl VALUES ("MT12_22","070_12_22","MAT","12","22","22","Mugi kigatou o kakabe ake te tangata uguhia noko kibi, kae he'e gea, o hakagaoi e Jesus, ka ke gea ma te ina. ");
INSERT INTO mnv_vpl VALUES ("MT12_23","070_12_23","MAT","12","23","23","Te 'apitanga na hu'ai he tu'ia 'aki ai, o konei agatou gegea, “Mano tenei te Hosa o David?” ");
INSERT INTO mnv_vpl VALUES ("MT12_24","070_12_24","MAT","12","24","24","Ka te 'aso noko haka gongo kinai na Pharisee, noko hai ake kigatou, “Te pegea nei manga pagepage haagiki songo i te ingoa o Beelzebub, te hakahua o na haagiki.” ");
INSERT INTO mnv_vpl VALUES ("MT12_25","070_12_25","MAT","12","25","25","Ka noko na'a e Jesus agatou tegeu'a nei, ma te hai atu kia te kigatou, “Na kakai 'anga nimaa tuhatuha o he migi 'aki, ka maseuseu. Na hu'ai manaha po na haanau e tasi, nimaa tuhatuha o he migi 'aki, ka maseuseu. ");
INSERT INTO mnv_vpl VALUES ("MT12_26","070_12_26","MAT","12","26","26","Ko Satan nimaa pagepage eia a Satan, koia manga tuhatuha ma te hai songo iho ia te ia launatasi, e hai ke kohea na tu'u tena hakahua 'anga? ");
INSERT INTO mnv_vpl VALUES ("MT12_27","070_12_27","MAT","12","27","27","Ko Au nimaa pagepage 'atua i te taganga o Beelzebub, to'oi te taganga te pagepage haagiki songo ai na pegea o 'outou? Na hai 'anga nei e haka maa'ogi ai koutou e songo. ");
INSERT INTO mnv_vpl VALUES ("MT12_28","070_12_28","MAT","12","28","28","Ka ko Au nimaa pagepage haagiki songo i na taganga o te Spirit Tapu o God, te Hakahua 'anga a te 'Aitu kua hetae mai kia te koutou. ");
INSERT INTO mnv_vpl VALUES ("MT12_29","070_12_29","MAT","12","29","29","“Po e hai ke kohea na hai ke hano he pegea ki he hage mo'o he tangata to'a, o haka sopo ba'i ga'unga a'ana? Ka naakupu ki te mataa gii eia te tangata to'a, 'io 'aonga te kaia'a eia tena hage. ");
INSERT INTO mnv_vpl VALUES ("MT12_30","070_12_30","MAT","12","30","30","“Koai e he'e haka pa'asi kia te Au, koia e he'e i to'oku pa'asi. Koai e he'e 'aabaki Au o hakaputu me'a koia manga lago e ia. ");
INSERT INTO mnv_vpl VALUES ("MT12_31","070_12_31","MAT","12","31","31","Tenei te hai 'anga e hai atu ai Au kia te koutou, ko ba'i 'oosongo ma ba'i 'igho 'anga kago haka noka kia pegea, ka te pegea e igho ki te Spirit Tapu, kago he'e haka noka. ");
INSERT INTO mnv_vpl VALUES ("MT12_32","070_12_32","MAT","12","32","32","Koai e gea haka makau ki te Hosa o Pegea, kago haka noka kia te ia. Ka nimaa iai he pegea koia e gea haka makau ki te Spirit Tapu, kago he'e haka noka kia te ia i na 'atu tangata nei ma na 'atu tangata kago a'u. ");
INSERT INTO mnv_vpl VALUES ("MT12_33","070_12_33","MAT","12","33","33","“Gosigosi atu te ga'akau ka ke go gaoi ona hua, ka te ga'akau nimaa songo kago songo 'ona hua, iteme'agaa te ga'akau ka manga haka he'aki i ona hua. ");
INSERT INTO mnv_vpl VALUES ("MT12_34","070_12_34","MAT","12","34","34","Koutou te matiginga ana ngata hai maka, e hai ke kohea na hai e koutou na pegea songo ke gegea i ni me'a gaoi? Iteme'agaa nia e 'epu ai na uso konaa te haka he'aki e na gea 'anga i na ngutu. ");
INSERT INTO mnv_vpl VALUES ("MT12_35","070_12_35","MAT","12","35","35","Te pegea gaoi e sosopo na hai 'anga gaoi i ana gea 'anga i na hai 'anga gaoi manga haka putu ia te ia. Ka te pegea songo manga sosopo na hai 'anga songo i ana gea 'anga i na hai 'anga songo manga haka putu e ia ki te uso. ");
INSERT INTO mnv_vpl VALUES ("MT12_36","070_12_36","MAT","12","36","36","Ka ko Au e hai atu kia te koutou, te 'aso kago haka aba ai a te kege nei, ko ba'i pegea e hai ke go hogahoga na kupu noko manga tangani gegea ai kigatou. ");
INSERT INTO mnv_vpl VALUES ("MT12_37","070_12_37","MAT","12","37","37","Iteme'agaa au gea 'anga, te hai ke go hai ia te koe ke go tausu'u i te kagohia, poe hai ia te koe ke go kagohia.” ");
INSERT INTO mnv_vpl VALUES ("MT12_38","070_12_38","MAT","12","38","38","Mugi kogaa i na Pharisee ma na ako o na tagangonga o hai atu kia te Ia, “Ako, ko kimatou e siahahai ke haka 'agi e Koe ni taganga haka'igonga mai a te Koe.” ");
INSERT INTO mnv_vpl VALUES ("MT12_39","070_12_39","MAT","12","39","39","Ko Jesus noko haka tau o hai atu, “Koutou te 'atu tangata hai hai 'anga songo, ma te ti'aki ia God, e haka ene 'aki kau haka 'agi taganga, kae si'ai ni taganga ke haiga'a kia te koutou, ka manga te haka 'igonga o te taauga ia Jonah. ");
INSERT INTO mnv_vpl VALUES ("MT12_40","070_12_40","MAT","12","40","40","Ko Jonah noko noho i te tina'e o te hu'ai kaui o toka togu ona 'ao ma te toka togu ona poo, ka te Hosa o Pegea e hai ke go konei na noho toka togu ona 'ao ma te toka togu ona poo i te takege o te kege nei. ");
INSERT INTO mnv_vpl VALUES ("MT12_41","070_12_41","MAT","12","41","41","Na pegea noko i Nineveh kago tutu'u hakapigi i te 'aso kago haka aba ai na 'atu tangata nei ogo haka bagebage te 'atu tangata nei, iteme'agaa ko kigatou na sui tegeu'a i te tohi'aki 'anga kinai a Jonah, kae e iai te pegea i te kunga nei e hua'eha o sigi ia Jonah. ");
INSERT INTO mnv_vpl VALUES ("MT12_42","070_12_42","MAT","12","42","42","Ko Sheba, te hakahua hahine o bagitakugu, kago tu'u hakapigi ki te 'atu tangata nei, ogo haka bagebage e ia, iteme'agaa koia noko a'u i te 'otinga o te kege nei, ke haka gongo ki te 'igo'igo o Solomon, ka te pegea e hua'eha o sigi ia Solomon manga i te kunga nei. ");
INSERT INTO mnv_vpl VALUES ("MT12_43","070_12_43","MAT","12","43","43","“Te gholoba e hano 'aatea ai te 'atua songo i te tangata, o sehu i na kunga he'e tau bai, o sasaga he kunga ke oki oki ai aano he'e kite he kunga. ");
INSERT INTO mnv_vpl VALUES ("MT12_44","070_12_44","MAT","12","44","44","Ma te hai ake, ‘E hai kau hoki ki te hage noko ti'aki eau.’ Ka te gholoba e tatae hoki ai, te hage kua tahitahi, ma te huhu'i o ma'a, ma te haka tinogaoi, ka manga gaabaki. ");
INSERT INTO mnv_vpl VALUES ("MT12_45","070_12_45","MAT","12","45","45","Ma te hoki ia o kakabe mai te toka hitu 'atua songo toto'a o sigi ia te ia, o boo kigatou o noho 'aki ai. Na noho taha'aki o te tangata na kua tutahi o sigi i nia noko mataa hetae kia te ia. E hai ke go konei na noho ma'u ki na 'atu tangata hai hai 'anga songo nei.” ");
INSERT INTO mnv_vpl VALUES ("MT12_46","070_12_46","MAT","12","46","46","Te gholoba noko manga koi gea ai a Jesus ki te 'apitanga, ko te tinana ma tena 'api noko manga tutu'u i haho, noko siahahai kigatou gegea kia te Ia. ");
INSERT INTO mnv_vpl VALUES ("MT12_47","070_12_47","MAT","12","47","47","Ma te hogahoga atu e te pegea kia Jesus, “Ko te tinau ma tou 'api manga tutu'u ake i haho e siahahai ke gegea kia te Koe.” ");
INSERT INTO mnv_vpl VALUES ("MT12_48","070_12_48","MAT","12","48","48","Ma te konei na haka tau atu a Jesus kia te ia, “Koai toku tinana, koai ma'u toku 'api?” ");
INSERT INTO mnv_vpl VALUES ("MT12_49","070_12_49","MAT","12","49","49","Kae haka tuiaki i te gima kia ona pegea haka ako, kae hai atu, “Konei oku tinana ma toku 'api. ");
INSERT INTO mnv_vpl VALUES ("MT12_50","070_12_50","MAT","12","50","50","Iteme'agaa koai e hai eia na me'a e siahai kinai a Tamau e noho i te gangi, koia toku taina ma toku tuhahine ma toku tinana.” ");
INSERT INTO mnv_vpl VALUES ("MT13_1","070_13_1","MAT","13","1","1","Te 'ao e tasi na, ko Jesus na sopo ki haho i te hage o noho i te pa'asi o te gano. ");
INSERT INTO mnv_vpl VALUES ("MT13_2","070_13_2","MAT","13","2","2","Hakaputu mai te 'apitanga 'api to'a o noho 'aki mugheghi ia te Ia, ma te sopo a Jesus ki goto i te baka o noho ai, kae manga tutu'u te 'apitanga o pegea i te tauaba. ");
INSERT INTO mnv_vpl VALUES ("MT13_3","070_13_3","MAT","13","3","3","Kae gea i na haka gaataki, o 'eha hai 'anga noko 'atigongo ai kia te kigatou, o hai atu, “Te pegea sanga 'umanga noko hano o lago ana hatu me'a. ");
INSERT INTO mnv_vpl VALUES ("MT13_4","070_13_4","MAT","13","4","4","Te gholoba noko lago ai e ia na hatu me'a, noko iai na hatu me'a hetoki ki te aga ba'e o te aga, noko boomai na manu hegegei o kai. ");
INSERT INTO mnv_vpl VALUES ("MT13_5","070_13_5","MAT","13","5","5","Ka noko iai kogaa hatu me'a noko hetoki ki na kunga ngaoa'a e he'e 'eha ai ni kege, manga malubu ghali ake naato'o te momo kege e he'e maatogu. ");
INSERT INTO mnv_vpl VALUES ("MT13_6","070_13_6","MAT","13","6","6","Nimaa te sopo ake 'anga te ga'aa na me'a maalubu nei na bega o maemae, iteme'agaa noko he'e tau aka. ");
INSERT INTO mnv_vpl VALUES ("MT13_7","070_13_7","MAT","13","7","7","Kogaa hatu me'a noko hetoki baa saoga i na mouku hotohoto, manga ngaasogo na mouku hotohoto o tamate na me'a maalubu nei. ");
INSERT INTO mnv_vpl VALUES ("MT13_8","070_13_8","MAT","13","8","8","Ka noko iai kogaa 'isi hatu me'a noko hetoki ki te kunga iai na kege gaoi, o ngaasogo o tau hua, kogaa noko gau (100), katoa hakaono (60), kogaa noko katoa hakatogu (30) hatu i te hua e tasi ona 'eha'anga o sigi i nia noko mataa sanga. ");
INSERT INTO mnv_vpl VALUES ("MT13_9","070_13_9","MAT","13","9","9","Koai e hai na taginga ke hakagongo, haka gongo ake ai!” ");
INSERT INTO mnv_vpl VALUES ("MT13_10","070_13_10","MAT","13","10","10","Na pegea haka ako noko boo ake o haka anu 'aki kia te Ia o hai atu, “Tehea te hai 'anga manga gea ai Koe kia te kigatou i na gaataki?” ");
INSERT INTO mnv_vpl VALUES ("MT13_11","070_13_11","MAT","13","11","11","Hakatau atu a Jesus, “Te na'a na hai 'anga ngigo o te Hakahua 'anga a te 'Aitu, kua haiga'a kia te koutou, ka he'e haiga'a kia te kigatou. ");
INSERT INTO mnv_vpl VALUES ("MT13_12","070_13_12","MAT","13","12","12","Koai kua ga'u eia, e hai ke go haiga'a beegaba ke go pau o 'eha. Koai koi he'e ga'u eia, nia manga hai eia e hai ke go sa'u ia te ia. ");
INSERT INTO mnv_vpl VALUES ("MT13_13","070_13_13","MAT","13","13","13","Tenei te hai 'anga manga gea ai Au kia te kigatou i na haka gaataki: ‘Ko kigatou manga hiina'i ka he'e tau maatanga, manga haka gongo, kae he'e na'a nia te manga haka gongo kinai.’ ");
INSERT INTO mnv_vpl VALUES ("MT13_14","070_13_14","MAT","13","14","14","Ko kigatou manga haka maa'ogi ai na taga gongo 'anga a Isaiah e hai ake: ‘Koutou ka go noko haka gongo i ba'i 'aso, kae ka go he'e na'a e koutou. Koutou ka go noko tangani hiina'i, kae ka go he'e tau maatanga. ");
INSERT INTO mnv_vpl VALUES ("MT13_15","070_13_15","MAT","13","15","15","Iteme'agaa na uso o na pegea nei kua mogi, ko kigatou kua he'e 'aonga te hakagongo i ogatou taginga, ko kigatou kua titingi ma'u ogatou mata. Ka nimaa si'ai, ko kigatou kago hiina'i i ogatou mata, ma te haka gongo i ogatou taginga, ma te 'igohia i ogatou uso o sui tegeu'a, kae hai Kau go haka ma'ugi 'ina ia te kigatou.’ ");
INSERT INTO mnv_vpl VALUES ("MT13_16","070_13_16","MAT","13","16","16","Ka te haka gaoinga ki outou mata, iteme'agaa 'outou mata kua hiina'i ma outou taginga kua haka gongo. ");
INSERT INTO mnv_vpl VALUES ("MT13_17","070_13_17","MAT","13","17","17","Ka ko Au e gea maa'ogi kia te koutou: Noko 'eha taauga ma na pegea tinogaoi noko gotu kigatou hiina'i ki nia kua hiina'i kinai koutou, ka na he'e hiina'i kinai. Ma te gotu kigatou haka gongo ki nia kua haka gongo kinai koutou, ka na he'e haka gongo ma'u kinai. ");
INSERT INTO mnv_vpl VALUES ("MT13_18","070_13_18","MAT","13","18","18","“Haka gongo mai ki te gaataki o te pegea lago hatu me'a: ");
INSERT INTO mnv_vpl VALUES ("MT13_19","070_13_19","MAT","13","19","19","Te 'aso kago haka gongo ai he pegea i na gongo o te Hakahua 'anga a te 'Aitu o he'e 'igohia kinai, te haagiki songo te a'u ia o sa'u eia nia kua 'oti i te sanga ki te uso o'ona. Tenei te hatu me'a noko lago ki te aga. ");
INSERT INTO mnv_vpl VALUES ("MT13_20","070_13_20","MAT","13","20","20","Ka nia noko lago ki na kunga hatuhatua e noho pe te tangata e haka gongo ki na gongo gaoi, manga ghali o siasia magaohie te to'o eia. ");
INSERT INTO mnv_vpl VALUES ("MT13_21","070_13_21","MAT","13","21","21","Kae naato'o ia te ia noko he'e tau aka, koia na manga noho i te mi'i gholoba. Na 'aso a'u ai te hakatangi, ma te hai songo 'ia i te ghaghi i te Gongo Gaoi, koia kago ghali o he'e maanatu. ");
INSERT INTO mnv_vpl VALUES ("MT13_22","070_13_22","MAT","13","22","22","Nia noko lago baa saoga i na kaubago hotohoto, e noho pe te tangata e haka gongo ki na gongo gaoi, ka na maikia o te ma'ugi nei ma na pakenga a na ga'unga e ta'ota'o ia te ia o he'e tau hua. ");
INSERT INTO mnv_vpl VALUES ("MT13_23","070_13_23","MAT","13","23","23","Ka nia noko lago ki na kunga kege gaoi e noho pe te tangata e haka gongo ki na gongo gaoi o 'igohia kinai. Koia e hai eia te hatu me'a o tau hua, ona hua e gau (100), katoa hakaono (60), poe katoa hakatogu (30) tena 'eha 'anga.” ");
INSERT INTO mnv_vpl VALUES ("MT13_24","070_13_24","MAT","13","24","24","Ko Jesus noko 'atigongo kia te kigatou i tegaa haka gaataki: “Te Hakahua 'anga a te 'Aitu e noho pe te tangata noko lago hatu me'a gaoi i tona 'umanga. ");
INSERT INTO mnv_vpl VALUES ("MT13_25","070_13_25","MAT","13","25","25","Ka te gholoba noko momoe ai ba'i pegea, kae a'u tena makau o lago baa saoga eia na mouku songo ki na witi kae hano. ");
INSERT INTO mnv_vpl VALUES ("MT13_26","070_13_26","MAT","13","26","26","Te 'aso na maalubu ai na hua o na witi o hakatu'u ke hua, kae ngaasogo ake ma'u na mouku songo. ");
INSERT INTO mnv_vpl VALUES ("MT13_27","070_13_27","MAT","13","27","27","“Na guani o te pegea noko hai tena 'umanga noko boo mai kia te ia o hai atu, ‘Hakahua, 'ai noko he'e manga na hatu me'a gaoi te noko lago e koe i tou 'umanga? Na mouku songo na me'a mai hea?’ ");
INSERT INTO mnv_vpl VALUES ("MT13_28","070_13_28","MAT","13","28","28","“Koia noko haka tau atu, ‘Na me'a hai e te makau.’ “Na guani noko haka anu 'aki atu kia te ia, ‘E siahai koe kimatou boo 'ina o abu?’ ");
INSERT INTO mnv_vpl VALUES ("MT13_29","070_13_29","MAT","13","29","29","“Hakatau te hakahua o hai atu, ‘Noka, na'e nimaa abu e koutou na mouku songo, kago abu haka pigi kinai na witi. ");
INSERT INTO mnv_vpl VALUES ("MT13_30","070_13_30","MAT","13","30","30","Tuku atu ke noko ngaasogo ngatahi, ke hano ano matu'a ke utu. Nimaa i te 'aso utu, 'io tuku eau na pegea utu 'umanga ke go mataa abu na mouku songo o no'ano'a ona 'uu ke tutu, 'io haka putu na witi o to'o mai ki toku hage haka putu utunga.’ ” ");
INSERT INTO mnv_vpl VALUES ("MT13_31","070_13_31","MAT","13","31","31","Ko Jesus noko 'atigongo kia te kigatou i tegaa haka gaataki: “Te Hakahua 'anga a te 'Aitu manga noho pe te hatu o te ga'akau e ingoa te ‘mustard’ noko to'o e te tangata o tanu i tona 'umanga. ");
INSERT INTO mnv_vpl VALUES ("MT13_32","070_13_32","MAT","13","32","32","Masi'igoa e hu'ai boboko to'a o sigi i gaa hatu me'a, ka te 'aso kago malubu ai o ngasogo kago hua'eha o sigi i gaa hua 'umanga maalubu i te 'umanga, kago hai ai he ga'akau, kago boomai na manu o noko ma'unga i ona ga'a.” ");
INSERT INTO mnv_vpl VALUES ("MT13_33","070_13_33","MAT","13","33","33","Ko Jesus noko 'atigongo ma'u i tegaa haka gaataki: “Te Hakahua 'anga a te 'Aitu manga noho pe te me'a haka tupu bred noko hai e te hahine o natu ki te hu'ai tu'u palaoa, ano haka ngasogo ai na palaoa.” ");
INSERT INTO mnv_vpl VALUES ("MT13_34","070_13_34","MAT","13","34","34","Ko Jesus noko manga gea i na hai 'anga nei ki te 'apitanga i na haka gaataki. Ko Ia noko he'e gea kia te kigatou i ni hai 'anga, ka noko manga gea i na haka gaataki. ");
INSERT INTO mnv_vpl VALUES ("MT13_35","070_13_35","MAT","13","35","35","Ka ke haka maa'ogi nia noko gea ai a te 'Aitu o agatu'u i te taauga noko hai ake: “E hai kau go gea i na haka gaataki kia te kigatou, e hai kau go hogahoga 'ia kia te kigatou na hai 'anga noko manga ngigo, haka tu'u mai i te gosigosi 'anga a te kege nei.” ");
INSERT INTO mnv_vpl VALUES ("MT13_36","070_13_36","MAT","13","36","36","Mugi a Jesus o hano i te 'apitanga nei o ugu ki goto i te hage, ona pegea haka ako noko boo ake kia te Ia o hai atu, “Hogahoga mai kia te kimatou te gaataki o na witi ma na mouku songo i te 'umanga.” ");
INSERT INTO mnv_vpl VALUES ("MT13_37","070_13_37","MAT","13","37","37","Ko Jesus noko haka tau atu, “Te tangata e lago na hatu me'a gaoi, te Hosa o Pegea. ");
INSERT INTO mnv_vpl VALUES ("MT13_38","070_13_38","MAT","13","38","38","Te 'umanga ko te kege nei. Na hatu me'a gaoi, te haka gaataki o na pegea e haka hua e te 'Aitu. Na mouku songo, na pegea e haka hua e te 'atua. ");
INSERT INTO mnv_vpl VALUES ("MT13_39","070_13_39","MAT","13","39","39","Ka te makau e lago eia na mouku songo, ko Satan. Te matu'a 'anga o utu o haka putu, te 'otinga o te kege nei. Na pegea e utu na 'umanga, na ensel. ");
INSERT INTO mnv_vpl VALUES ("MT13_40","070_13_40","MAT","13","40","40","Na mouku maase'i noko abu o tutu i te ahi, e hai ke go konaa na noho te 'otinga o te kege nei. ");
INSERT INTO mnv_vpl VALUES ("MT13_41","070_13_41","MAT","13","41","41","Te Hosa o Pegea e hai ke go haka to'o ona ensel, kigatou go haka 'aatea 'ia na pegea hai kogaa pegea o 'oosongo, ma na pegea hai hai 'anga songo i te Hakahua 'anga a te 'Aitu. ");
INSERT INTO mnv_vpl VALUES ("MT13_42","070_13_42","MAT","13","42","42","Na ensel e hai kigatou go seu 'ia ia te kigatou ki goto i te bebega 'anga o te ahi. Te kunga na, ko kigatou go noko tatangi ma te he taangisi 'aki ogatou niho. ");
INSERT INTO mnv_vpl VALUES ("MT13_43","070_13_43","MAT","13","43","43","Ka te gholoba na, na pegea haka tinogaoi, e hai ke go noko haka ahu pe te ga'aa i te nuku o togatou Tamana. Koai e hai na taginga ke hakagongo, haka gongo ake ai! ");
INSERT INTO mnv_vpl VALUES ("MT13_44","070_13_44","MAT","13","44","44","“Te Hakahua 'anga a te 'Aitu e noho pe na ga'unga manga huu i te ma'aga. Te 'aso e kite ai e te tangata, manga huu haka hoki eia, ka koia na siasia ma te hano o haiga'a ba'i me'a a'ana, kae tau'i eia te ma'aga nei. ");
INSERT INTO mnv_vpl VALUES ("MT13_45","070_13_45","MAT","13","45","45","“Te Hakahua 'anga a te 'Aitu e noho ma'u pe te pegea haka putu me'a ke tau'i, ligo ma'ana ni hatu susugu gaoi. ");
INSERT INTO mnv_vpl VALUES ("MT13_46","070_13_46","MAT","13","46","46","Te 'aso e kite ai eia te hatu hu'ai gaoi e hu'ai 'eha o na mane, koia na hano o salemu ba'i me'a a'ana, kae tau'i eia te me'a nei. ");
INSERT INTO mnv_vpl VALUES ("MT13_47","070_13_47","MAT","13","47","47","“E kogaa na noho ma'u: Te Hakahua 'anga a te 'Aitu e noho pe te bugho tupe ki te tai ma te lunu ai te mou hage o te kaui. ");
INSERT INTO mnv_vpl VALUES ("MT13_48","070_13_48","MAT","13","48","48","Te 'aso na pau o honu ai, na huhuti ake e na taangata tautai ki te tauaba, mugi kigatou o noho 'aki o tuhatuha na kaui, tape na me'a gaoi ki agatou kete, kae seu 'aatea na me'a maase'i. ");
INSERT INTO mnv_vpl VALUES ("MT13_49","070_13_49","MAT","13","49","49","Te 'oti 'anga a te kege nei, e hai ke go konei o na noho. Na ensel e hai ke go boomai o tuku 'aatea na pegea songo i na pegea soihua. ");
INSERT INTO mnv_vpl VALUES ("MT13_50","070_13_50","MAT","13","50","50","Kae seu na pegea songo ki goto i te bebega 'anga o te ahi. Te kunga kago noko tatangi, ma te he taakisi 'aki ai ogatou niho.” ");
INSERT INTO mnv_vpl VALUES ("MT13_51","070_13_51","MAT","13","51","51","Ma te haka anu atu a Jesus, “Kua 'igohia koutou ki na hai 'anga nei?” Ko kigatou noko haka tau atu, “ 'Oo.” ");
INSERT INTO mnv_vpl VALUES ("MT13_52","070_13_52","MAT","13","52","52","Ma te hai atu a Jesus kia te kigatou, “Nimaa konaa na noho, na ako o na tagangonga kua haka ako i na noho o te Hakahua 'anga a te 'Aitu, ko kigatou e noho pe te pegea hai tona hage, e 'aonga te sa'u iho i tona kunga tuku me'a na ga'unga ho'ou ma na ga'unga mai gaa 'aso.” ");
INSERT INTO mnv_vpl VALUES ("MT13_53","070_13_53","MAT","13","53","53","Te 'aso na 'oti i te hogahoga ai e Jesus na haka gaataki nei, kae hano 'aatea i te manaha. ");
INSERT INTO mnv_vpl VALUES ("MT13_54","070_13_54","MAT","13","54","54","Ko Ia noko hoki ki tona manaha i Nazareth, o manga ako ia te kigatou i tegatou Hage hai paaunga, ka ko kigatou na he gege ma'ugi 'aki o haka anuanu 'aki, “Te tau hinangago ma na taganga o te tangata nei na hai 'anga ga'u e Ia mai hea? ");
INSERT INTO mnv_vpl VALUES ("MT13_55","070_13_55","MAT","13","55","55","'Ai he'e tenei te hosa o te tangata mataisau?! 'Ai he'e tona tinana ko Mary?! 'Ai he'e tona 'api ko James ma Joseph ma Simon ma Judas?! ");
INSERT INTO mnv_vpl VALUES ("MT13_56","070_13_56","MAT","13","56","56","'Ai he'e ona tuhaahine te manga haka pata kia te kitatou? Ka na hai 'anga mai hea te hai e te tangata nei?!” ");
INSERT INTO mnv_vpl VALUES ("MT13_57","070_13_57","MAT","13","57","57","Ko kigatou na he 'ika'ika 'aki kia te Ia. Ma te hai atu a Jesus kia te kigatou, “Te taauga e pago kinai a pegea, ka manga tona manaha ma na pegea i te hage o'ona te he'e pago kia te ia.” ");
INSERT INTO mnv_vpl VALUES ("MT13_58","070_13_58","MAT","13","58","58","Ko Jesus na he'e 'eha tena hai taganga i Nazareth, 'ia te kigatou noko he'e too kia te Ia. ");
INSERT INTO mnv_vpl VALUES ("MT14_1","070_14_1","MAT","14","1","1","Na 'aso na, ko king Herod na haka gongo i na gongo o Jesus. ");
INSERT INTO mnv_vpl VALUES ("MT14_2","070_14_2","MAT","14","2","2","Ma te hai atu ki ona pegea hai hekau, “Ko John Baptist tenei kae ma'ugi haka hokimai i te mate, tenei te hai 'anga e hai taganga ai.” ");
INSERT INTO mnv_vpl VALUES ("MT14_3","070_14_3","MAT","14","3","3","Te gholoba na, ko Herod na labu e ia ia John o gii o tuku ki te kagohia, i te ghaghi ia Herodias te uguugu o te taina ia Philip. ");
INSERT INTO mnv_vpl VALUES ("MT14_4","070_14_4","MAT","14","4","4","Iteme'agaa ko John noko konei ana gea kia Herod, “E he'e tuku i na tagangonga ke pipiki e koe ia te ia.” ");
INSERT INTO mnv_vpl VALUES ("MT14_5","070_14_5","MAT","14","5","5","Ko Herod noko gotu ke taa eia ia John, ka noko mataku ki na pegea, iteme'agaa na tegeu'a ake kigatou ko ia te taauga. ");
INSERT INTO mnv_vpl VALUES ("MT14_6","070_14_6","MAT","14","6","6","Nimaa i te kainga i te 'ao noko haka haa ai a Herod, te tama 'ahine a Herodias na tau'aso kia te kigatou, ma te maagaohie to'a ai a Herod, ");
INSERT INTO mnv_vpl VALUES ("MT14_7","070_14_7","MAT","14","7","7","o tuku kupu ki te hahine ma te aguagu e hai ke go haiga'a kinai e ia nia kago haka ene ai. ");
INSERT INTO mnv_vpl VALUES ("MT14_8","070_14_8","MAT","14","8","8","Ka ko ia na usuusu e te tinana, ma te konei ana gea, “Tuku atu te 'ugu o John Baptist ki he besin o 'aumai kia te au i te kunga nei.” ");
INSERT INTO mnv_vpl VALUES ("MT14_9","070_14_9","MAT","14","9","9","Te king na hu'ai 'agoha ai, ka naato'o ia te ia na 'oti i te aguagu i 'ago i ana hogau noko manga noho 'aki, ma te kaunaki eia ke hai te haka enenga a te hahine. ");
INSERT INTO mnv_vpl VALUES ("MT14_10","070_14_10","MAT","14","10","10","Na tuku eia o toghi te 'ugu o John Baptist noko manga i te kunga o na pegea kagohia. ");
INSERT INTO mnv_vpl VALUES ("MT14_11","070_14_11","MAT","14","11","11","Te 'ugu o John na to'o ake i te besin o haiga'a ki te hahine, o to'o eia kia te tinana. ");
INSERT INTO mnv_vpl VALUES ("MT14_12","070_14_12","MAT","14","12","12","Ma te boomai na pegea haka ako o John o to'o te tino o'ona o tanu, kae boo o he 'atigongo 'aki ai kia Jesus. ");
INSERT INTO mnv_vpl VALUES ("MT14_13","070_14_13","MAT","14","13","13","Te 'aso na gongo ai a Jesus i te hai 'anga na hai, ko Ia na haka 'aatea i te baka o hano ki te kunga gaabaki. Ka na gongo ai te 'apitanga, ma te haka tu'u boo ba'e i ogatou manaha o tata'o ia te Ia. ");
INSERT INTO mnv_vpl VALUES ("MT14_14","070_14_14","MAT","14","14","14","Te gholoba na sahe ake ai a Jesus o ina ki te 'apitanga, ko Ia na 'agoha kia te kigatou ma te haka ma'ugi e Ia ia te kigatou i ogatou masaki. ");
INSERT INTO mnv_vpl VALUES ("MT14_15","070_14_15","MAT","14","15","15","Nimaa i te hai hano 'anga ki te ahiahi, boo ake Ona pegea haka ako kia te Ia o hai atu, “E hano ke poo, ka te manaha mama'o tenei. Hai atu te 'apitanga nei ke maseu, ka ke boo ki na mi'i manaha o taki tau'i ma'agatou ni utunga.” ");
INSERT INTO mnv_vpl VALUES ("MT14_16","070_14_16","MAT","14","16","16","Ma te haka tau atu a Jesus, “Ko kigatou e he'e maseu. Manga 'abatu e koutou ma'agatou ni me'a ke kai.” ");
INSERT INTO mnv_vpl VALUES ("MT14_17","070_14_17","MAT","14","17","17","Ma te haka tau kigatou o hai atu, “Manga hai e kimatou te toka gima bred ma te toka gua kaui.” ");
INSERT INTO mnv_vpl VALUES ("MT14_18","070_14_18","MAT","14","18","18","Hai atu a Jesus, “To'o mai kia te Au.” ");
INSERT INTO mnv_vpl VALUES ("MT14_19","070_14_19","MAT","14","19","19","Kae kaunaki atu e Ia te 'apitanga ke noho 'aki ki te mutie, kae sa'u ake e Ia te toka gima bred ma te toka gua kaui o ina haka tu'u ki te gangi o haka 'aue, kae tohitohi na bred o 'abange ki na pegea haka ako o tuha e kigatou ki te 'apitanga. ");
INSERT INTO mnv_vpl VALUES ("MT14_20","070_14_20","MAT","14","20","20","Ko kigatou ngatahi na kai ano maakokona, kae tibu e na pegea haka ako na momo utunga noko toe o honu i te katoa tuma'a e gua kete. ");
INSERT INTO mnv_vpl VALUES ("MT14_21","070_14_21","MAT","14","21","21","Te mootunga o na pegea noko kai noko gimanga noa taangata, ma na haahine, ma na tama giki. ");
INSERT INTO mnv_vpl VALUES ("MT14_22","070_14_22","MAT","14","22","22","Ma te ghali a Jesus o tuku ona pegea haka ako, o sosopo ki te baka o mumu'a ki tegaa pa'asi i te gano, kae kaunaki e Ia te 'apitanga o taki boo. ");
INSERT INTO mnv_vpl VALUES ("MT14_23","070_14_23","MAT","14","23","23","Nimaa 'oti i te kaunaki e Ia te 'apitanga o maseu, kae haka neke launatasi ki te pa'asi o te ogo ke taakunga ai. Nimaa i te ahiahi ko Ia noko manga launatasi i te kungaa. ");
INSERT INTO mnv_vpl VALUES ("MT14_24","070_14_24","MAT","14","24","24","Ka te baka kua mama'o i te kunga henua, o manga he tupetupe 'aki e na ngagu, iteme'agaa noko pusi haka titingi e te oko. ");
INSERT INTO mnv_vpl VALUES ("MT14_25","070_14_25","MAT","14","25","25","Nimaa i te 'ago ki te 'ao, kae hano a Jesus kia te kigatou, ko Ia noko manga sehu i te huka o te tai. ");
INSERT INTO mnv_vpl VALUES ("MT14_26","070_14_26","MAT","14","26","26","Te gholoba na hiina'i atu ai na pegea haka ako kia te Ia manga sehu i te huka o te tai, ko kigatou na hu'ai matataku o hai ake, “Te 'atua!” kae ngengege i te noko matataku. ");
INSERT INTO mnv_vpl VALUES ("MT14_27","070_14_27","MAT","14","27","27","Ma te ghali a Jesus o hai ake kia te kigatou, “Noka te he sosopomananaba 'aki, na'e ko Au. Noka tautou matataku.” ");
INSERT INTO mnv_vpl VALUES ("MT14_28","070_14_28","MAT","14","28","28","Ma te haka tau atu a Peter, “Nimaa ko Koe hakahua, gea mai kau hinatu kia te Koe i te huka o te tai.” ");
INSERT INTO mnv_vpl VALUES ("MT14_29","070_14_29","MAT","14","29","29","Ma te hai atu a Jesus, “A'u.” Ma te sopo iho a Peter o a'u kia Jesus i te huka o te tai. ");
INSERT INTO mnv_vpl VALUES ("MT14_30","070_14_30","MAT","14","30","30","Ka te gholoba noko ina ai a Peter ki na oko, koia na mataku, ma te haka tu'u ke mene, 'use atu, “Hakahua, haka ma'ugi mai ia te au.” ");
INSERT INTO mnv_vpl VALUES ("MT14_31","070_14_31","MAT","14","31","31","Ma te ghali a Jesus o 'oso ki te gima, kae hai atu, “Te sano o'ou e hu'ai boboko. Tehea te hai 'anga e he'e sano ai koe?” ");
INSERT INTO mnv_vpl VALUES ("MT14_32","070_14_32","MAT","14","32","32","Te gholoba na sosopo ai kigaaua ki te baka, na ngongoto te oko. ");
INSERT INTO mnv_vpl VALUES ("MT14_33","070_14_33","MAT","14","33","33","Ma te sogi na pegea noko i te baka kia te Ia, o hai atu, “E maa'ogi, Ko Koe te Hosa o God.” ");
INSERT INTO mnv_vpl VALUES ("MT14_34","070_14_34","MAT","14","34","34","Nimaa te gholoba na hegakau 'aki ai kigatou ki tegaa pa'asi, ko kigatou na sahe ki Gennesaret. ");
INSERT INTO mnv_vpl VALUES ("MT14_35","070_14_35","MAT","14","35","35","Nimaa te gholoba na na'a gaoi ai e na pegea i te manaha ia Jesus, hakato'o e kigatou te gongo ki ba'i kunga henua mugheghi i te kakai 'anga. O kakabe ngatahi ake ai e pegea ogatou pegea masasaki kia te Ia. ");
INSERT INTO mnv_vpl VALUES ("MT14_36","070_14_36","MAT","14","36","36","O haka ene 'aki kia te Ia ke tuku na pegea masasaki ke manga he 'osohi ki na kapa o te ake o 'Ona, ko ba'i pegea noko he 'osohi kia te Ia na maa'ugi. ");
INSERT INTO mnv_vpl VALUES ("MT15_1","070_15_1","MAT","15","1","1","Noko iai kogaa i na Pharisee ma na ako o na tagangonga, noko boo iho i Jerusalem kia Jesus, o he haka anu anu 'aki kinai, ");
INSERT INTO mnv_vpl VALUES ("MT15_2","070_15_2","MAT","15","2","2","“Tehea te hai 'anga e ta'anga hai songo ai e ou pegea haka ako na hesuinga mai na hai tupuna? Ko kigatou he'e huhu'i ogatou gima 'io mugi o kai!” ");
INSERT INTO mnv_vpl VALUES ("MT15_3","070_15_3","MAT","15","3","3","Ma te haka tau atu a Jesus, “Ka tehea te hai 'anga e hai songo ai e koutou na tagangonga a te 'Aitu, i te ghaghi i autou hesuinga? ");
INSERT INTO mnv_vpl VALUES ("MT15_4","070_15_4","MAT","15","4","4","Ko God noko hai mai: ‘Haka e'eha atu ia te tamau ma te tinau. Ka nimaa iai he pegea koia e gea maase'i kia te tamana po ko te tinana, koia e hai ke tuku ke mate.’ ");
INSERT INTO mnv_vpl VALUES ("MT15_5","070_15_5","MAT","15","5","5","Kae ako e koutou o hai ake: Nimaa iai he tangata hai atu kia te tamana po ko te tinana, ‘Nia noko hai ke ga'u e kougua ia te au i taku 'aabaki ai kia te kougua, na me'a nei kua 'oti i te haiga'a kia God.’ ");
INSERT INTO mnv_vpl VALUES ("MT15_6","070_15_6","MAT","15","6","6","Te tangata e konei ana gea, koia e he'e hai ke haka e'eha ai ia te tamana ma te tinana. E konei na hai e koutou o haka sogago ai na haka hegeunga a te 'Aitu, i te ghaghi i autou hesuinga. ");
INSERT INTO mnv_vpl VALUES ("MT15_7","070_15_7","MAT","15","7","7","Koutou na pegea haka hagehage! Ko Isaiah noko hu'ai maa'ogi tena taga gongo 'anga ia te koutou: ");
INSERT INTO mnv_vpl VALUES ("MT15_8","070_15_8","MAT","15","8","8","‘Na pegea nei manga haka e'eha e kigatou ia te Au i ogatou gau ngutu, ka ogatou uso e hu'ai mama'o ia te Au. ");
INSERT INTO mnv_vpl VALUES ("MT15_9","070_15_9","MAT","15","9","9","Ko kigatou manga tangani sogi kia te Au. Na akonga manga ako e kigatou, na tagangonga hai e pegea.’ ” ");
INSERT INTO mnv_vpl VALUES ("MT15_10","070_15_10","MAT","15","10","10","Ma te ngege atu a Jesus i te 'apitanga o haka putu mai kia te Ia o hai atu kinai, “Haka gongo mai o na'a. ");
INSERT INTO mnv_vpl VALUES ("MT15_11","070_15_11","MAT","15","11","11","Nia e hano ki goto i te ngutu o te pegea e he'e baa 'ugi ia te ia. Ka nia e sopo ake i te ngutu o'ona, tenaa te me'a e baa 'ugi ia te ia.” ");
INSERT INTO mnv_vpl VALUES ("MT15_12","070_15_12","MAT","15","12","12","Mugi na pegea haka ako o boo ake o haka anu kia te Ia o hai atu, “E na'a e Koe na Pharisee e haka gongo songo i tau gea 'anga nei?” ");
INSERT INTO mnv_vpl VALUES ("MT15_13","070_15_13","MAT","15","13","13","Ma te haka tau a Jesus o hai atu, “Ko ba'i ga'akau noko he'e tanu e Tamau e noho i te gangi, e hai ke go abu ma ogatou aka. ");
INSERT INTO mnv_vpl VALUES ("MT15_14","070_15_14","MAT","15","14","14","Tuku atu ia te kigatou, na'e kigatou na hutiaki kikibi. Te tangata kibi nimaa kakabe eia tegaa tangata kibi, ko kigaaua kago hetoki ngatahi ki he pupu'a.” ");
INSERT INTO mnv_vpl VALUES ("MT15_15","070_15_15","MAT","15","15","15","Ma te hai atu a Peter, “Hogahoga mai te haka gaataki nei kia te kimatou.” ");
INSERT INTO mnv_vpl VALUES ("MT15_16","070_15_16","MAT","15","16","16","Haka anu atu a Jesus kia te kigatou, “ 'Ai koutou koi he noanoa 'aki ma'u? ");
INSERT INTO mnv_vpl VALUES ("MT15_17","070_15_17","MAT","15","17","17","'Ai e he'e na'a e koutou: Nia e mene ki goto i na ngutu manga hano ki te ghaghalaghi ano sopo ki taha i te tino? ");
INSERT INTO mnv_vpl VALUES ("MT15_18","070_15_18","MAT","15","18","18","Ka na me'a e sosopo ake i na ngutu, e boo ake i na hinangago. Konei na me'a e baa 'ugi ia pegea. ");
INSERT INTO mnv_vpl VALUES ("MT15_19","070_15_19","MAT","15","19","19","Iteme'agaa na hinangago te sosopo ake ai na tegeu'a maase'i, ma te taa pegea, ma te maasoko na taangata hai uguugu, ma te maasoko a taangata ma haahine, ma te kaia'a, ma te gogoi, ma te hegeu songo ki gaa pegea. ");
INSERT INTO mnv_vpl VALUES ("MT15_20","070_15_20","MAT","15","20","20","Konei na hai 'anga e baa 'ugi ia pegea, ka te kai i na gima he'e huhu'i e he'e baa 'ugi ia pegea.” ");
INSERT INTO mnv_vpl VALUES ("MT15_21","070_15_21","MAT","15","21","21","Ko Jesus na 'oti i te kunga nei, kae hano ki te kakai 'anga noko iai gua manaha i Tyre ma Sidon. ");
INSERT INTO mnv_vpl VALUES ("MT15_22","070_15_22","MAT","15","22","22","Ka noko iai te hahine 'aatea mai Canaan noko manga kakai i te kungaa, na hinake o ngege atu kia te Ia, “Hakahua, ko koe te Hosa o David, 'agoha mai kia te au. Taku tama 'ahine e hu'ai higosia i tena uguhia 'anga.” ");
INSERT INTO mnv_vpl VALUES ("MT15_23","070_15_23","MAT","15","23","23","Ka ko Jesus noko he'e gea kinai, ma te boo ake ona pegea haka ako o haka ene 'aki kia te Ia, “Kaunaki atu te hahine nei ke hano, na'e koia ka noko ngege he tata'o 'aki ia te kitatou.” ");
INSERT INTO mnv_vpl VALUES ("MT15_24","070_15_24","MAT","15","24","24","Ma te haka tau a Jesus ki te hahine o hai atu, “Ko Au noko manga haka to'o mai ki na pegea o Israel kua boo 'aatea o noho pe na sipisipi sesee.” ");
INSERT INTO mnv_vpl VALUES ("MT15_25","070_15_25","MAT","15","25","25","Ma te a'u te hahine o toko tugi i 'ago ia Jesus o hai atu, “Hakahua, 'aabaki mai kia te au.” ");
INSERT INTO mnv_vpl VALUES ("MT15_26","070_15_26","MAT","15","26","26","Haka tau atu a Jesus, “E he'e gaoi te sa'u na utunga a na tama giki o seu ki na tokitoki.” ");
INSERT INTO mnv_vpl VALUES ("MT15_27","070_15_27","MAT","15","27","27","Ma te hai atu te hahine, “E maa'ogi Hakahua, ka na tokitoki ta'anga kai ma'u i na momo utunga ta'a hetoki iho i na kunga kai o 'ogatou hakahua.” ");
INSERT INTO mnv_vpl VALUES ("MT15_28","070_15_28","MAT","15","28","28","Ma te haka tau a Jesus o hai atu, “Ta'ahine, ko koe e hua'eha tou sano! Tau saakanga nei e hai.” Tenaa te gholoba na ma'ugi ai tena tama 'ahine. ");
INSERT INTO mnv_vpl VALUES ("MT15_29","070_15_29","MAT","15","29","29","Ko Jesus na hano i te kunga na ki na tahataha o te gano i Galilee, o haka neke ki te pa'asi ogo o manga noho ai. ");
INSERT INTO mnv_vpl VALUES ("MT15_30","070_15_30","MAT","15","30","30","Te 'apitanga noko boo ake kia te Ia, o kakabe mai kinai na pegea seu, na pegea kikibi, na pegea taa haka piki piki, na pegea he'e gegea, ma gaa pegea sa'o saga 'ina o haka taahoga e kigatou ki na ba'e o Jesus. Ma te haka ma'ugi e Ia ia te kigatou. ");
INSERT INTO mnv_vpl VALUES ("MT15_31","070_15_31","MAT","15","31","31","Te 'apitanga na he gege ma'ugi 'aki i tegatou hiina'i 'anga ki na pegea noko he'e gegea kua gegea, ma na pegea taa haka pikipiki kua soihua ma na pegea seu kua he boboo 'aki, ma na pegea kikibi kua hiina'i. Ma te haka e'eha e kigatou te God o Israel. ");
INSERT INTO mnv_vpl VALUES ("MT15_32","070_15_32","MAT","15","32","32","Ko Jesus noko haka putu mai ona pegea haka ako kia te Ia o hai atu, “Ko Au e hu'ai 'agoha ki na pegea nei, ko kigatou kua haka pata kia te Au i te toka togu 'ao nei o he'e tau utunga ke kai. Kae he'e siahai kau tuku 'ia ke boo he ongea 'aki, i te kitai semu he pegea i te agatu'u ma kaa giu.” ");
INSERT INTO mnv_vpl VALUES ("MT15_33","070_15_33","MAT","15","33","33","Ma te hakatau atu ona pegea haka ako, “E hai kimatou kohea na hai 'ia ni utunga i te kunga gaabaki nei, ke 'aonga te haangai ai te hu'ai haka putunga?” ");
INSERT INTO mnv_vpl VALUES ("MT15_34","070_15_34","MAT","15","34","34","Haka anu atu a Jesus, “E hia bred e hai e koutou?” Ma te hakatau atu kigatou, “Te toka hitu, ma na mi'i kaui.” ");
INSERT INTO mnv_vpl VALUES ("MT15_35","070_15_35","MAT","15","35","35","Ma te kaunaki e Jesus te 'apitanga ke noho 'aki ki te kege. ");
INSERT INTO mnv_vpl VALUES ("MT15_36","070_15_36","MAT","15","36","36","Kae sa'u ake e Ia te toka hitu bred ma na mi'i kaui. Te gholoba na 'oti i te haka 'aue ai kia God, kae tohitohi e Ia na utunga o 'abange ki ona pegea haka ako, o tuha e na pegea haka ako ki te 'apitanga. ");
INSERT INTO mnv_vpl VALUES ("MT15_37","070_15_37","MAT","15","37","37","Ko kigatou ngatahi na kai ano maakokona, 'io mugi na pegea haka ako o tibu na momo utunga noko toe, o hohonu ai te toka hitu kete. ");
INSERT INTO mnv_vpl VALUES ("MT15_38","070_15_38","MAT","15","38","38","Te taunga o na pegea noko kai nei noko haanga noa (4,000) taangata, ka noko iai ma'u na haahine ma na tama giki. ");
INSERT INTO mnv_vpl VALUES ("MT15_39","070_15_39","MAT","15","39","39","Nimaa 'oti i te tuku e Jesus te 'apitanga o maseu, ko Ia noko sopo ki te baka o hano ki na tahataha o Magadan. ");
INSERT INTO mnv_vpl VALUES ("MT16_1","070_16_1","MAT","16","1","1","Na Pharisee ma na Sadducee noko boo ake kia Jesus o hakaanu hai lobo e kigatou ia te Ia, ke haka 'agi kia te kigatou ni haka 'igonga mai te gangi. ");
INSERT INTO mnv_vpl VALUES ("MT16_2","070_16_2","MAT","16","2","2","Ka noko haka tau kinai a Jesus o hai atu, “Na 'aso e pisi ai te ga'aa, koutou e ta'anga hai ake: ‘Ka magino, iteme'agaa e uga te 'agohi gangi.’ ");
INSERT INTO mnv_vpl VALUES ("MT16_3","070_16_3","MAT","16","3","3","Ka nimaa i te mahoata koutou e ta'anga hai ake: ‘Te 'aso nei ka maase'i, iteme'agaa te 'agohi gangi e uga ma te haka 'ao'ao.’ 'Eaa e na'a te hogahoga ai e koutou na noho o na 'aso hiina'i ai ki te 'agohi gangi, kae he'e na'a te hogahoga ai e koutou na noho o na haka 'igonga o na 'aso nei? ");
INSERT INTO mnv_vpl VALUES ("MT16_4","070_16_4","MAT","16","4","4","Koutou na pegea hai hai 'anga songo, ma te 'atu tangata sogi ki na haka tino. Koutou e haka ene 'aki kia te Au he haka 'igonga i ni taganga, kae si'ai he hai 'anga ke haka 'agi, ka manga te haka 'igonga o Jonah.” Kae hano 'aatea a Jesus 'ia te kigatou. ");
INSERT INTO mnv_vpl VALUES ("MT16_5","070_16_5","MAT","16","5","5","Nimaa i te 'aso na toghi ai kigatou ki tegaa pa'asi i te gano, na pegea haka ako na he'e maanatu ke to'o ni bred. ");
INSERT INTO mnv_vpl VALUES ("MT16_6","070_16_6","MAT","16","6","6","Ka na hai atu a Jesus kia te kigatou, “Koutou haka tauganga atu ma te na'ana'a ki na me'a haka tupu bred a na Pharisee ma na Sadducee.” ");
INSERT INTO mnv_vpl VALUES ("MT16_7","070_16_7","MAT","16","7","7","Ma te manga hegeu kinai kigatou o hai ake, “E konei ana to'o i te kua he'e to'o mai e kitatou ni bred.” ");
INSERT INTO mnv_vpl VALUES ("MT16_8","070_16_8","MAT","16","8","8","Na na'a e Jesus tegatou hegeunga nei, ma te haka anu kinai o hai atu, “ 'Eaa manga hegeu ai koutou ki te he'e tau bred 'anga? Koutou hu'ai gigiki outou sano! ");
INSERT INTO mnv_vpl VALUES ("MT16_9","070_16_9","MAT","16","9","9","Koi he'e na'a ma'u e koutou? 'Ai koutou kua he'e maanatu ki te 'aso na tohitohi ai e Au te toka gima bred o haangai ai te gimanga noa (5,000) taangata? Ma te he'e maanatu ma'u a koutou po noko tokahia kete tape o honu noko haka putu e koutou? ");
INSERT INTO mnv_vpl VALUES ("MT16_10","070_16_10","MAT","16","10","10","Po te toka hitu bred noko haangai ai te haanga noa (4,000) taangata, ma te tokahia kete tape o honu noko haka putu e koutou? ");
INSERT INTO mnv_vpl VALUES ("MT16_11","070_16_11","MAT","16","11","11","'Eaa e he'e na'a ai e koutou ko Au e he'e gea ki na bred? Ka koutou manga na'ana'a atu ki na me'a haka tupu bred a na Pharisee ma na Sadducee!” ");
INSERT INTO mnv_vpl VALUES ("MT16_12","070_16_12","MAT","16","12","12","'Io na'a gaoi e kigatou, 'ai ko Jesus noko he'e gea kia te kigatou ke na'ana'a ki na me'a haka tupu bred. Ka noko manga gea kia te kigatou ke na'ana'a ki na akonga a na Pharisee ma na Sadducee. ");
INSERT INTO mnv_vpl VALUES ("MT16_13","070_16_13","MAT","16","13","13","Te 'aso noko hano ai a Jesus ki te kakai 'anga i Caesarea Philippi, ko Ia noko haka anu ki ona pegea haka ako o hai atu kinai, “Te Hosa o Pegea e hai mai te 'apitanga koai?” ");
INSERT INTO mnv_vpl VALUES ("MT16_14","070_16_14","MAT","16","14","14","Ma te haka tau a kigatou o hai atu, “E hai ake kogaa ko John Baptist, kae hai ake kogaa, ko Elijah, ka manga hai ake kogaa, ko Jeremiah po te launatasi i na taauga.” ");
INSERT INTO mnv_vpl VALUES ("MT16_15","070_16_15","MAT","16","15","15","Ma te haka anu hoki atu a Jesus, “Kae hai ake koutou ko Au koai?” ");
INSERT INTO mnv_vpl VALUES ("MT16_16","070_16_16","MAT","16","16","16","Ma te haka tau a Peter o hai atu, “Ko Koe te 'Agiki Taga'ia, te Hosa o te God ma'ugi goa.” ");
INSERT INTO mnv_vpl VALUES ("MT16_17","070_16_17","MAT","16","17","17","Haka tau atu a Jesus, “Te hakagaoinga kia te koe, Simon te hosa o Jonah. Te hai 'anga nei e he'e haka 'agi e he pegea kia te koe, kae haka 'agi e Tamau e noho i te gangi. ");
INSERT INTO mnv_vpl VALUES ("MT16_18","070_16_18","MAT","16","18","18","Kae hai atu Au kia te koe: Ko koe ko Peter, ka i te hatu nei e hai kau go haka tu'u ai 'ina te haka putunga o na pegea o'oku, kago he'e sepu ai na taganga o te mate. ");
INSERT INTO mnv_vpl VALUES ("MT16_19","070_16_19","MAT","16","19","19","E hai kau go haiga'a 'ia kia te koe te hai paaunga ki te Hakahua 'anga a te 'Aitu. Nia go susugi e koe i gago nei, e hai ke go susugi ma'u i te gangi. Ka nia ka go tuku e koe i gago nei, e hai ke go tuku ma'u i te gangi.” ");
INSERT INTO mnv_vpl VALUES ("MT16_20","070_16_20","MAT","16","20","20","Ma te taagango e Jesus ona pegea haka ako, ke noka te hogahoga ki he pegea ko Ia te 'Agiki Taga'ia. ");
INSERT INTO mnv_vpl VALUES ("MT16_21","070_16_21","MAT","16","21","21","Haka tu'u i te 'aso na, ko Jesus noko tongitongi aki e Ia kia ona pegea haka ako, ko Ia e hai ke go hano ki Jerusalem ke go tiha'ia i ba'i hai 'anga ka go hai kinai e na 'agiki o na Jew ma na hu'ai priest ma na ako o na tagangonga, e hai ke go taa 'ia, ka ko Ia kago ma'ugi hoki i te togunga 'ao. ");
INSERT INTO mnv_vpl VALUES ("MT16_22","070_16_22","MAT","16","22","22","Ma te haka 'aatea e Peter 'ia Jesus o haka tu'u susugi e ia o hai atu, “Si'ai Hakahua! Te hai 'anga nei ka go he'e hai kia te Koe!” ");
INSERT INTO mnv_vpl VALUES ("MT16_23","070_16_23","MAT","16","23","23","Taka hugi iho a Jesus kia Peter o hai atu, “Hinake ki mugi ia te Au Satan! Na'e ko koe haka gabegabe kia te Au. Ko koe e he'e tegeu'a ki na hai 'anga a te 'Aitu, ka na hai 'anga a pegea.” ");
INSERT INTO mnv_vpl VALUES ("MT16_24","070_16_24","MAT","16","24","24","Ma te hai atu a Jesus ki ona pegea haka ako, “Nimaa iai he pegea e siahai ke tata'o tu'a ia te Au, koia e hai ke hai ti'aki ia te ia, kae 'amo tena kros o tata'o mai ia te Au. ");
INSERT INTO mnv_vpl VALUES ("MT16_25","070_16_25","MAT","16","25","25","Iteme'agaa koai e siahai ke noko haka sao i te ma'ugi, kago he'e kite e ia. Ka koai kago hai ti'aki te ma'ugi o 'ona i te ghaghi ia te Au, e hai ke go kite e ia te ma'ugi. ");
INSERT INTO mnv_vpl VALUES ("MT16_26","070_16_26","MAT","16","26","26","Niaa kago gaoi ki te tangata i te poi hai eia ba'i ga'unga i te kege nei, kae ti'aki te ma'ugi o 'ona? Po niaa kago haiga'a e te tangata nei ke haka suihaki ai te ma'ugi o 'ona? ");
INSERT INTO mnv_vpl VALUES ("MT16_27","070_16_27","MAT","16","27","27","Iteme'agaa te Hosa o Pegea e hai ke go a'u i te mamagunga o te Tamana ma ona ensel, 'io giu'aki e Ia kia pegea taki tasi nia noko ta'anga hai e kigatou. ");
INSERT INTO mnv_vpl VALUES ("MT16_28","070_16_28","MAT","16","28","28","Ko Au e gea maa'ogi kia te koutou: E iai na pegea ia te koutou e tutu'u i te kunga nei, kago he'e mamate ano hiina'i ki te Hosa o Pegea e hai ke go a'u ma tona Hakahua.” ");
INSERT INTO mnv_vpl VALUES ("MT17_1","070_17_1","MAT","17","1","1","Nimaa sigi te toka ono 'ao, kakabe e Jesus ia Peter, ma James, ma te taina ia John, o hakaneke soko ki 'agunga i te ogo ma'u 'agunga. ");
INSERT INTO mnv_vpl VALUES ("MT17_2","070_17_2","MAT","17","2","2","Te kunga na, ko Jesus na gigiu i 'ago ia te kigatou. Na taunga mata o'ona noko maagama o noho pe te ga'aa, ka ona ake noko susugu o noho pe te peba. ");
INSERT INTO mnv_vpl VALUES ("MT17_3","070_17_3","MAT","17","3","3","Kae haka 'agi kia te kigatou ia Moses ma Elijah i te gholoba na ma'u, o manga hegeu ma Jesus. ");
INSERT INTO mnv_vpl VALUES ("MT17_4","070_17_4","MAT","17","4","4","Ma te hai atu a Peter kia Jesus, “Hakahua, te hai 'anga gaoi te matou boomai 'anga ki te kunga nei, ka nimaa siahai kinai Koe, e hai kau 'ati 'ia he toka togu boghugha, ke hai mo'ou tasi, hai mo'o Moses tasi, kae hai mo'o Elijah tasi.” ");
INSERT INTO mnv_vpl VALUES ("MT17_5","070_17_5","MAT","17","5","5","Te gholoba noko manga koi gea ai a Peter, sopo te po'ao susugu o tango ia te kigatou, kae sopo mai te ge'o i te po'ao o hai atu, “Tenei toku Hosa e ma'ine kinai Au, ko Au e hu'ai maagaohie ia te Ia. Koutou haka gongo ake kia te Ia.” ");
INSERT INTO mnv_vpl VALUES ("MT17_6","070_17_6","MAT","17","6","6","Te 'aso na haka gongo atu ai kinai na pegea haka ako, ko kigatou na hetoki haka haao'o ki te kege, i te matataku toto'a. ");
INSERT INTO mnv_vpl VALUES ("MT17_7","070_17_7","MAT","17","7","7","Ka na a'u kinai a Jesus o 'oso atu kia te kigatou kae hai atu, “A'aga ake, noka te matataku.” ");
INSERT INTO mnv_vpl VALUES ("MT17_8","070_17_8","MAT","17","8","8","Te gholoba na hekeu 'aki ake ai kigatou, na he'e hiina'i ma'u ki he pegea, ka manga ko Jesus. ");
INSERT INTO mnv_vpl VALUES ("MT17_9","070_17_9","MAT","17","9","9","Nimaa i tegatou iho 'anga i te ogo, ko Jesus noko taagango atu ia te kigatou, “Noka te hogahoga ki he pegea nia kua hiina'i kinai koutou, ano ma'ugi hoki te Hosa o Pegea mai te mate.” ");
INSERT INTO mnv_vpl VALUES ("MT17_10","070_17_10","MAT","17","10","10","Na pegea haka ako noko haka anu 'aki kia te Ia o hai atu, “ 'Eaa noko hai ake ai na ako o na tagangonga, ko Elijah e hai ke go mataa a'u?” ");
INSERT INTO mnv_vpl VALUES ("MT17_11","070_17_11","MAT","17","11","11","Haka tau atu a Jesus, “E hai ke na'a, ko Elijah e mu'a mai kego hai ba'i hai 'anga ke ho'ou. ");
INSERT INTO mnv_vpl VALUES ("MT17_12","070_17_12","MAT","17","12","12","Ka ko Au e hai atu kia te koutou, Ko Elijah na goa tena a'u, ka na he'e haka 'igonga e kigatou ia te ia, o manga hai kinai e kigatou ba'i hai 'anga sia hahai kigatou ke hai kia te ia. Te Hosa o Pegea e hai kego konei agatou hai ma'u kinai ke tiha'ia i ogatou taganga.” ");
INSERT INTO mnv_vpl VALUES ("MT17_13","070_17_13","MAT","17","13","13","Ma te na'a e na pegea haka ako, ko Jesus manga gea kia te kigatou ia John Baptist. ");
INSERT INTO mnv_vpl VALUES ("MT17_14","070_17_14","MAT","17","14","14","Te 'aso na giu mai ai ki te 'apitanga, noko iai te tangata na tu'uti mai ia Jesus o toko tugi i 'ago ia te Ia. ");
INSERT INTO mnv_vpl VALUES ("MT17_15","070_17_15","MAT","17","15","15","O hai atu, “Hakahua, 'agoha mai kia toku hosa. Koia e iai te masaki ghotoi o hu'ai tiha'ia ai. 'Eha 'aso guti ai ki na ahi ma na bai. ");
INSERT INTO mnv_vpl VALUES ("MT17_16","070_17_16","MAT","17","16","16","Kua kakabe mai eau ki ou pegea haka ako, ka kua he'e 'aonga te haka ma'ugi e kigatou ia te ia.” ");
INSERT INTO mnv_vpl VALUES ("MT17_17","070_17_17","MAT","17","17","17","Ma te haka tau a Jesus o hai atu, “Koutou te 'atu tangata he'e too kia God ma te hai hai 'anga songo. E hai ke kohea na noho goa taku haka pata kia te koutou?! E hai ke kohea na noho goa taku hai tuku kia te koutou?! Kakabe mai te mi'i tangata kia te Au i te kunga nei.” ");
INSERT INTO mnv_vpl VALUES ("MT17_18","070_17_18","MAT","17","18","18","Ko Jesus na pagepage e Ia te haagiki songo o sopo ki taha i te mi'i tangata. Koia na soihua i te mi'i gholoba na. ");
INSERT INTO mnv_vpl VALUES ("MT17_19","070_17_19","MAT","17","19","19","Mugi o boo soko ake na pegea haka ako kia Jesus, o haka anu atu kinai, “ 'Eaa kua he'e 'aonga te pagepage ai e kimatou?” ");
INSERT INTO mnv_vpl VALUES ("MT17_20","070_17_20","MAT","17","20","20","Ma te haka tau atu a Jesus, “Iteme'agaa koutou e pau o gigiki toto'a 'outou sano. Ko Au e gea maa'ogi kia te koutou: Koutou poi gigiki outou sano o noho po te mi'i hatu me'a o te ga'akau e ingoa te ‘mustard’, koutou manga 'aonga te hai atu ki te ogo nei, ‘Ngaso'i atu i te kunga nei ki tegaa kunga,’ ka ngaso'i. Kago si'ai ni me'a haingata'a kia te koutou. ");
INSERT INTO mnv_vpl VALUES ("MT17_21","070_17_21","MAT","17","21","21","Ka te haagiki songo nei, ka he'e manga muna o hano 'aatea, naakupu ki te taakunga ma te he'e kai i te sogi.” ");
INSERT INTO mnv_vpl VALUES ("MT17_22","070_17_22","MAT","17","22","22","Te 'aso na haka putu giu ai kigatou ki Galilee, ko Jesus noko hai atu kia te kigatou, “Te Hosa o Pegea e hai ke go haka soko 'ia ki na taganga o pegea. ");
INSERT INTO mnv_vpl VALUES ("MT17_23","070_17_23","MAT","17","23","23","E hai kigatou go taa 'ia ke mate, ka nimaa 'io go i te togunga 'ao, ko Ia e hai ke go ma'ugi hoki mai.” Na pegea haka ako na hu'ai he gege hinangago 'aki. ");
INSERT INTO mnv_vpl VALUES ("MT17_24","070_17_24","MAT","17","24","24","Te 'aso noko hetae ai a Jesus ma ona pegea haka ako ki te manaha i Capernaum, na pegea tibu takis o te Hage Tapu, noko boo ake o haka anu 'aki kia Peter o hai atu, “Te Ako o 'ou ma tau'i te takis o te Hage Tapu?” ");
INSERT INTO mnv_vpl VALUES ("MT17_25","070_17_25","MAT","17","25","25","Ma te haka tau atu a Peter, “ 'Oo, ma hai e Ia.” Ka te gholoba na ugu ai a Peter ki goto i te hage, ko Jesus te noko mataa gea kia te ia o haka anu, “Tehea tau maanatu Simon? Koai te tibu takis ai na hakahua o gago nei: Ogatou hosa maa'ogi po na pegea 'aatea?” ");
INSERT INTO mnv_vpl VALUES ("MT17_26","070_17_26","MAT","17","26","26","Haka tau atu a Peter, “Na pegea 'aatea.” Ma te hai atu a Jesus kia te ia, “Ka ona hosa manga tausu'u. ");
INSERT INTO mnv_vpl VALUES ("MT17_27","070_17_27","MAT","17","27","27","Ke noka te kitatou hai 'ia ia te kigatou ke 'ika'ika 'aki: Hinatu ki te gano o sisi ai, ogo sa'u te kaui ka go mataa huhuti, o luga te ngutu, ka go kite ai e koe he mane. 'Ogo to'o atu o haiga'a kia te kigatou o tau'i ai toku takis ma to'ou.” ");
INSERT INTO mnv_vpl VALUES ("MT18_1","070_18_1","MAT","18","1","1","I na 'aso na, na pegea haka ako noko boo ake kia Jesus o haka anu 'aki kinai o hai atu, “Koai te hai ke go hua'eha i te Hakahua 'anga a te 'Aitu?” ");
INSERT INTO mnv_vpl VALUES ("MT18_2","070_18_2","MAT","18","2","2","Ko Jesus noko ngege i te mi'i tama 'iti'iti o haka tu'u goto ia te kigatou. ");
INSERT INTO mnv_vpl VALUES ("MT18_3","070_18_3","MAT","18","3","3","Kae hai atu a Jesus, “Ko Au e gea maa'ogi kia te koutou: Naakupu ki te sui 'outou a'aki ke noho po na mi'i tama giki, koutou kago he'e boo ki goto i te Hakahua 'anga a te 'Aitu. ");
INSERT INTO mnv_vpl VALUES ("MT18_4","070_18_4","MAT","18","4","4","Kogaa na noho, ko ai e haka ma'ugago ia te ia o noho pe te mi'i tama 'iti'iti nei, ka go hua'eha to'a i te Hakahua 'anga a te 'Aitu. ");
INSERT INTO mnv_vpl VALUES ("MT18_5","070_18_5","MAT","18","5","5","“Ko ai kago haka pogo e ia i he mi'i tama 'iti'iti noho po tenei i te ghaghi i toku ingoa, koia e haka pogo e ia ia te Au ma'u. ");
INSERT INTO mnv_vpl VALUES ("MT18_6","070_18_6","MAT","18","6","6","Ka nimaa iai he pegea hai eia he launatasi i na tama giki kua too kia te Au ke go 'oosongo, mano koia e gaoi i te tauga he hu'ai hatu ki te u'a o baa lologi ki te takege o te moana. ");
INSERT INTO mnv_vpl VALUES ("MT18_7","070_18_7","MAT","18","7","7","“Haka 'aagoha a gago nei i na me'a e hai ia pegea o 'oosongo. Na me'a na e hai ke boo mai, kae haka 'aagoha te pegea kago boo mai ai na me'a na. ");
INSERT INTO mnv_vpl VALUES ("MT18_8","070_18_8","MAT","18","8","8","Ka tou gima po tou ba'e, nimaa hai eia ia te koe o 'oosongo, toghi atu o tupe. E hu'ai gaoi i te poi hano sanga songo po e pikipiki koe ki te ma'ugi, o sigi i te noko noho guo'ou gima ma guo'ou ba'e o seu ngatahi ki te ahi noho goa. ");
INSERT INTO mnv_vpl VALUES ("MT18_9","070_18_9","MAT","18","9","9","Ka tou mata nimaa hai eia ia te koe o 'oosongo, kape iho o tupe. E hu'ai gaoi i te poi hano mata tasi koe ki te ma'ugi, o sigi i te noko noho guo'ou mata kae seu ki te ahi o te ugaimami. ");
INSERT INTO mnv_vpl VALUES ("MT18_10","070_18_10","MAT","18","10","10","“Koutou noka te hiina'i haka sogago ki he launatasi i na mi'i pegea nei, na'e hai atu Au, ogatou ensel i te gangi manga suga te hiina'i ki na mata o Tamau i te gangi. ");
INSERT INTO mnv_vpl VALUES ("MT18_11","070_18_11","MAT","18","11","11","Te Hosa o Pegea noko a'u ke haka ma'ugi na pegea kua boo 'aatea. ");
INSERT INTO mnv_vpl VALUES ("MT18_12","070_18_12","MAT","18","12","12","“Koutou e kohea na tegeu'a? Poi iai he tangata hai ma'ana he tino te gau sipisipi, kae hano 'aatea te launatasi ia te kigatou, 'ai ka go he'e tuku eia te tino iba tuma'a e iba i na ogo, kae hano o sasaga te launatasi kua se'ia? ");
INSERT INTO mnv_vpl VALUES ("MT18_13","070_18_13","MAT","18","13","13","Ko Au e gea kia te koutou i te maa'ogi: Nimaa go kite eia, koia ka hu'ai mahi i te launatasi nei, o sigi i te tino iba tuma'a e iba manga noho. ");
INSERT INTO mnv_vpl VALUES ("MT18_14","070_18_14","MAT","18","14","14","Manga konei na noho ma'u te Tamana o 'outou e noho i te gangi. Ko Ia e he'e siahai ki he launatasi i na mi'i pegea nei kego he'e kitea. ");
INSERT INTO mnv_vpl VALUES ("MT18_15","070_18_15","MAT","18","15","15","“Ko te taiu nimaa hai hai 'anga songo kia te koe, hinatu kougua manga hegeu toka gua, kae hogahoga kinai te hai 'anga songo e hai e ia. Nimaa haka gongo kia te koe, e kakabe hokimai e koe ia te taiu. ");
INSERT INTO mnv_vpl VALUES ("MT18_16","070_18_16","MAT","18","16","16","Ka nimaa he'e haka gongo kia te koe, ogo kakabe atu he launatasi po he toka gua pegea o boo kinai. Ko ba'i hai 'anga hegeu kinai kougua, e hai ke go tinogaoi i te na'a 'aabaki ai he toka gua po he toka togu pegea. ");
INSERT INTO mnv_vpl VALUES ("MT18_17","070_18_17","MAT","18","17","17","Ka nimaa he'e maka ma'u ke haka gongo kia te kigatou, 'atigongo atu ai ki na pegea sogi. Ka nimaa pau o he'e maka ma'u ke haka gongo ki na pegea sogi, tuku atu ia te ia ke noho po te pegea he'e too kia te 'Aitu po te pegea tibu takis. ");
INSERT INTO mnv_vpl VALUES ("MT18_18","070_18_18","MAT","18","18","18","“Ko Au e gea maa'ogi kia te koutou: Nia e gii poe susugi e koutou i te kege nei, kago gii ma'u i te gangi. Ka nia e huhuke poe tuku e koutou i te kege nei, kago huhuke ma'u i te gangi. ");
INSERT INTO mnv_vpl VALUES ("MT18_19","070_18_19","MAT","18","19","19","“Ko Au e gea haka hoki atu ma'u kia te koutou, nimaa iai he toka gua ia te koutou e gototasi ki he me'a i te kege nei, o haka ene 'aki ai, e hai ke go hai e Tamau e noho i te gangi kia te kigaaua. ");
INSERT INTO mnv_vpl VALUES ("MT18_20","070_18_20","MAT","18","20","20","Iteme'agaa, nimaa iai he toka gua po he toka togu e haka putu i toku ingoa, ko Au manga haka pata kia te kigatou.” ");
INSERT INTO mnv_vpl VALUES ("MT18_21","070_18_21","MAT","18","21","21","Ma te a'u a Peter o haka anu atu kia Jesus, “Hakahua, e hai kau haka noka haka hia ki toku taina i ona 'aso hai hai 'anga songo kia te au? Haka hitu gholoba?” ");
INSERT INTO mnv_vpl VALUES ("MT18_22","070_18_22","MAT","18","22","22","Haka tau atu a Jesus, “Ko Au e hai atu kia te koutou, he'e manga te haka hitu gholoba, kae haka noka o sigi i te katoa haka hitu tuma'a e hitu gholoba. ");
INSERT INTO mnv_vpl VALUES ("MT18_23","070_18_23","MAT","18","23","23","“E kogaa na noho, te Hakahua 'anga a te 'Aitu manga noho pe te hakahua e siahai ke haka tinogaoi na kaone a ona guani. ");
INSERT INTO mnv_vpl VALUES ("MT18_24","070_18_24","MAT","18","24","24","Te gholoba noko hai ke haka tu'u ai te haka tino gaoi 'anga, kae kakabe ake 'ia kinai te tangata noko kaone eia te noa (1,000) mane. ");
INSERT INTO mnv_vpl VALUES ("MT18_25","070_18_25","MAT","18","25","25","Naato'o i te guani nei na he'e tau mane ke sui ai tena kaone, manga kaunaki e tena hakahua ia te ia ma tena uguugu ma tena haanau ma ba'i me'a a 'ana ke salemu ke sui ai tena kaone. ");
INSERT INTO mnv_vpl VALUES ("MT18_26","070_18_26","MAT","18","26","26","“Te guani na too toko tugi i 'ago i te hakahua o sasaka ake, ‘Baa noa mai ka kau go tau'i hoki 'ia ba'i me'a.’ ");
INSERT INTO mnv_vpl VALUES ("MT18_27","070_18_27","MAT","18","27","27","Te hakahua na 'agoha ki tona guani o haka noka tena hu'ai kaone, kae tuku ia te ia o hano. ");
INSERT INTO mnv_vpl VALUES ("MT18_28","070_18_28","MAT","18","28","28","“Ka te 'aso noko hano ai te guani na, o sasa'o ki tegaa guani noko kaone eia tena gau (100) mane ma te logi eia o kukumi te u'a kae hai atu, ‘Tau'i hokimai nia noko kaone e koe kia te au!’ ");
INSERT INTO mnv_vpl VALUES ("MT18_29","070_18_29","MAT","18","29","29","“Too toko tugi tegaa guani o hai ake, ‘Baa noa mai ka kau go tau'i hoki 'ina kia te koe.’ ");
INSERT INTO mnv_vpl VALUES ("MT18_30","070_18_30","MAT","18","30","30","“Ka koia na he'e maka, manga kakabe eia o tuku ki te kunga o na pegea kagohia, ke go noho ai ano sui tena kaone. ");
INSERT INTO mnv_vpl VALUES ("MT18_31","070_18_31","MAT","18","31","31","Te gholoba na hiina'i ai kogaa guani ki nia noko hai, ko kigatou na 'agogoha toto'a ma te boo kigatou o he 'atigongo 'aki ki te hakahua i nia kua hai e te guani. ");
INSERT INTO mnv_vpl VALUES ("MT18_32","070_18_32","MAT","18","32","32","“Ma te pogo 'aki te hakahua i te guani nei, o hai atu kinai, ‘Ko koe te guani songo to'a. Noko haka noka eau tau hu'ai kaone, i tau sasaka 'anga kia te au. ");
INSERT INTO mnv_vpl VALUES ("MT18_33","070_18_33","MAT","18","33","33","'Ai ko koe e he'e 'agoha ki tegaa guani, ke noho pe taku 'agoha 'anga kia te koe?!’ ");
INSERT INTO mnv_vpl VALUES ("MT18_34","070_18_34","MAT","18","34","34","Te hakahua na hu'ai haka tangi, ma te tuku e ia te guani nei ki te kunga o na pegea kagohia, ke noho ai ano tau'i hoki tena hu'ai kaone. ");
INSERT INTO mnv_vpl VALUES ("MT18_35","070_18_35","MAT","18","35","35","“Ko Tamau e noho i te gangi, kago konei ana noho ma'u kia te koutou taki tasi, i te poi he'e haka noka ki outou taina i outou uso.” ");
INSERT INTO mnv_vpl VALUES ("MT19_1","070_19_1","MAT","19","1","1","Te gholoba na 'oti i te gea ai a Jesus i na hai 'anga nei, ko Ia na hano i Galilee o hano ki te kakai 'anga i Judea i tegaa pa'asi o te bai mimigo i Jordan. ");
INSERT INTO mnv_vpl VALUES ("MT19_2","070_19_2","MAT","19","2","2","Te hu'ai 'apitanga noko manga 'agu ia Jesus, ma te haka ma'ugi e Ia ia te kigatou. ");
INSERT INTO mnv_vpl VALUES ("MT19_3","070_19_3","MAT","19","3","3","Noko iai kogaa i na Pharisee, noko boo ake ke haka anuanu pake ia Jesus. Ko kigatou noko haka anu 'aki, “ 'Ai manga gaoi ki atatou tagangonga ki te tangata i te poi maabae ma tena uguugu i ba'i hai 'anga?” ");
INSERT INTO mnv_vpl VALUES ("MT19_4","070_19_4","MAT","19","4","4","Haka tau atu a Jesus, “ 'Ai e he'e haka sahe e koutou: ‘Haka tu'u mai i te gosigosi 'anga a gago nei, ko God noko gosigosi ia te kigaaua te tangata ma te hahine,’ ");
INSERT INTO mnv_vpl VALUES ("MT19_5","070_19_5","MAT","19","5","5","kae hai atu a te 'Aitu: ‘Tenei te hai 'anga e hai ke hano ai a te tangata ia te tamana ma te tinana, o he piitaki 'aki ma tena uguugu, ko kigaaua kua hai ai te tino e tasi.’ ");
INSERT INTO mnv_vpl VALUES ("MT19_6","070_19_6","MAT","19","6","6","Ko kigaaua ka he'e noko hai ai he toka gua pegea, ka te pegea e tasi. E kogaa na noho, nia na haka he potaki 'aki e God, noka te tuku he pegea ke haka maabae.” ");
INSERT INTO mnv_vpl VALUES ("MT19_7","070_19_7","MAT","19","7","7","Na Pharisee na haka anu atu, “Ka 'eaa gaa noko tuku ai e Moses, te tangata ke 'abange he kanukanu mo'o te maabae kia tona uguugu, kae tuku te hahine ke hano?” ");
INSERT INTO mnv_vpl VALUES ("MT19_8","070_19_8","MAT","19","8","8","Ma te haka tau a Jesus o hai atu, “Ko Moses noko manga tuku e ia ia te koutou ke maabae ma outou uguugu, iteme'agaa outou uso noko mogi toto'a. Ka noko he'e konaa na hai i te haka tu'u sanga. ");
INSERT INTO mnv_vpl VALUES ("MT19_9","070_19_9","MAT","19","9","9","Ko Au e hai atu kia te koutou: Nimaa iai he pegea manga muna o maabae ma tona uguugu, ka te hahine e he'e maasoko, kae sui o taka ma tegaa hahine, koia te tangata hai uguugu maasoko.” ");
INSERT INTO mnv_vpl VALUES ("MT19_10","070_19_10","MAT","19","10","10","Na pegea haka ako noko hai atu kia Jesus, “Nimaa tenei te paaunga ki te matu'a ma te uguugu, e gaoi ke noka te taka.” ");
INSERT INTO mnv_vpl VALUES ("MT19_11","070_19_11","MAT","19","11","11","Ma te haka tau atu a Jesus, “Te akonga nei e he'e hai ki ba'i pegea, ka manga na pegea kua haiga'a kinai e te 'Aitu. ");
INSERT INTO mnv_vpl VALUES ("MT19_12","070_19_12","MAT","19","12","12","Iteme'agaa e iai na pegea haka haa o he'e 'aonga ki te hai uguugu, kae iai kogaa e hai e pegea o he'e 'aonga ki te hai uguugu, kae iai kogaa pegea manga he'e siahai uguugu, i te tegeu'a ke manga hai hekau ki te Hakahua 'anga a te 'Aitu. Ka koai e siahai ki te akonga nei, manga 'aonga te 'agu tu'a ai!” ");
INSERT INTO mnv_vpl VALUES ("MT19_13","070_19_13","MAT","19","13","13","Na mi'i tama giki noko kakabe ake kia Jesus, ke haka eke ai na gima ma te sogi ia te kigatou, ka na gehu na pegea haka ako ki na pegea noko kakabe ake e kigatou na mi'i tama giki. ");
INSERT INTO mnv_vpl VALUES ("MT19_14","070_19_14","MAT","19","14","14","Ma te hai atu a Jesus, “Tuku atu na mi'i tama giki ke boomai kia te Au, kae noka te susugi ia te kigatou, iteme'agaa te Hakahua 'anga a te 'Aitu te kunga mo'o na pegea e noho pe na tama giki nei.” ");
INSERT INTO mnv_vpl VALUES ("MT19_15","070_19_15","MAT","19","15","15","Ko Jesus na haka eke gua gima i na mi'i tama giki kae hano. ");
INSERT INTO mnv_vpl VALUES ("MT19_16","070_19_16","MAT","19","16","16","E iai te tangata noko a'u kia Jesus, o haka anu atu kinai, “Ako, tehea te hai 'anga gaoi kau hai 'ia, ka kau go ga'u 'ia ai te ma'ugi noho goa?” ");
INSERT INTO mnv_vpl VALUES ("MT19_17","070_19_17","MAT","19","17","17","Ma te haka tau a Jesus o hai atu, “ 'Eaa e haka anu ai koe kia te Au po nia te gaoi? 'E iai te Launatasi e gaoi. Ka ko koe nimaa siahai ke go ga'u e koe te ma'ugi, maangao atu ki na tagangonga.” ");
INSERT INTO mnv_vpl VALUES ("MT19_18","070_19_18","MAT","19","18","18","Ma te haka anu te tangata o hai atu, “Na tagangonga hea?” Haka tau atu a Jesus, “Noka te taa pegea, noka te maasoko na taangata hai uguugu, noka te kaia'a, noka te gogoi, ");
INSERT INTO mnv_vpl VALUES ("MT19_19","070_19_19","MAT","19","19","19","haka e'eha atu ia te tamau ma te tinau, ma te ma'ine atu ki na pegea e pata mai, ke noho pe au ma'ine 'anga kia te koe.” ");
INSERT INTO mnv_vpl VALUES ("MT19_20","070_19_20","MAT","19","20","20","Ma te haka tau te tamatama nei o hai atu, “Na hai 'anga nei manga hai e au o 'oti, ka nia te koi he'e hai eau?” ");
INSERT INTO mnv_vpl VALUES ("MT19_21","070_19_21","MAT","19","21","21","Ma te hai atu a Jesus, “Ko koe nimaa siahai ke pau o tinogaoi, hinatu o tuku au ga'unga ke tau'i 'ia ke hai ai ni mane o haiga'a ki na pegea lae, ka ke go hai ma'au ni ga'unga i te gangi, kae a'u o tata'o ia te Au.” ");
INSERT INTO mnv_vpl VALUES ("MT19_22","070_19_22","MAT","19","22","22","Te gholoba na haka gongo ai te tangata tamatama nei, ko ia na hano 'agoha, iteme'agaa koia e hai ana hu'ai ga'unga. ");
INSERT INTO mnv_vpl VALUES ("MT19_23","070_19_23","MAT","19","23","23","Ma te hai atu a Jesus kia ona pegea haka ako, “Ko Au e gea maa'ogi kia te koutou, e hai ngata'a te tangata ga'u te hano ki goto i te Hakahua 'anga a te 'Aitu. ");
INSERT INTO mnv_vpl VALUES ("MT19_24","070_19_24","MAT","19","24","24","Ko Au e gea hoki atu kia te koutou, e mi'i haingaohie te mene he ‘camel’ i he mata nila, o sigi i te sopo he pegea ga'u ki goto i te Hakahua 'anga a te 'Aitu.” ");
INSERT INTO mnv_vpl VALUES ("MT19_25","070_19_25","MAT","19","25","25","Te gholoba noko haka gongo ai na pegea haka ako ki te gea 'anga nei, ko kigatou na hu'ai he tu'ia 'aki o haka anu atu kia te Ia, “Ka koai gaa te kago maa'ugi?” ");
INSERT INTO mnv_vpl VALUES ("MT19_26","070_19_26","MAT","19","26","26","Ko Jesus noko ina atu kia te kigatou ma te hai atu, “Te hai 'anga nei e haingata'a kia pegea, ka ko ba'i hai 'anga manga haingaohie kia God.” ");
INSERT INTO mnv_vpl VALUES ("MT19_27","070_19_27","MAT","19","27","27","Ma te haka tau a Peter kia Jesus o hai atu, “Ko kimatou kua ti'aki ba'i me'a, kae tata'o ia te Koe, ka nia gaa kago hai ai kia te kimatou?” ");
INSERT INTO mnv_vpl VALUES ("MT19_28","070_19_28","MAT","19","28","28","Ma te hai atu a Jesus kia te kigatou, “Ko Au e gea maa'ogi kia te koutou: Te hai haka hoki 'anga ba'i hai 'anga o ho'ou, te gholoba kago noho ai te Hosa o Pegea i tena noohonga mamagunga, ka koutou kua 'oti i te he tata'o 'aki ia te Au e hai ke go noho 'aki ma'u i te katoa tuma'a e gua noohonga o haka aba te katoa tuma'a e gua hanohano o Israel. ");
INSERT INTO mnv_vpl VALUES ("MT19_29","070_19_29","MAT","19","29","29","Ka ko ba'i pegea ti'aki hage, po 'ogatou 'api taangata po 'ogaatou tuhaahine, po 'ogatou tamana, po 'ogatou tinana, po agatou haanau, po ogatou kunga henua, i te baaghaghi ia te Au, kago ga'u me'a o 'eha to'a kae kago ga'u ma'u te ma'ugi noho goa. ");
INSERT INTO mnv_vpl VALUES ("MT19_30","070_19_30","MAT","19","30","30","Ka e 'api pegea e mumu'a, e hai ke go mugi. Ka e 'api pegea e mugi, e hai ke go mumu'a. ");
INSERT INTO mnv_vpl VALUES ("MT20_1","070_20_1","MAT","20","1","1","“Te Hakahua 'anga a te 'Aitu manga noho pe te pegea hai ona kunga henua. Kae hano i te taha'ata ke hai ki ni pegea ke hai hekau i tona 'umanga kaubago. ");
INSERT INTO mnv_vpl VALUES ("MT20_2","070_20_2","MAT","20","2","2","Ko ia noko magaohie ke tau'i ia te kigatou i he mane siliva e tasi i te 'ao kae haka to'o ia te kigatou ki tona 'umanga kaubago. ");
INSERT INTO mnv_vpl VALUES ("MT20_3","070_20_3","MAT","20","3","3","“Nimaa i te mahoata, kae hano ia ki te kunga tau'i me'a, o ina ki na pegea manga tutu'u ai he'e tau tukunga. ");
INSERT INTO mnv_vpl VALUES ("MT20_4","070_20_4","MAT","20","4","4","Hai atu ia kia te kigatou, ‘Koutou boo atu ma'u o hai hekau i toku 'umanga kaubago, ka kau go tau'i 'ia ia te koutou i nia e 'aonga.’ ");
INSERT INTO mnv_vpl VALUES ("MT20_5","070_20_5","MAT","20","5","5","Ma te boo kigatou. “Koia noko hoki ma'u i te 'ao 'atea, hoki ma'u i te eke seunga 'anga te ga'aa, o manga hai eia te hai 'anga e tasi te tuku na pegea o hai hekau ke go tau'i. ");
INSERT INTO mnv_vpl VALUES ("MT20_6","070_20_6","MAT","20","6","6","Nimaa i te ga'aa page, koia noko hoki ma'u ki te kunga tau'i me'a o kite i na pegea manga koi tutu'u. Koia noko haka anu kia te kigatou, ‘ 'Eaa manga konaa autou tutu'u ai i te 'ao kaatoa nei he'e hai he hai 'anga?’ ");
INSERT INTO mnv_vpl VALUES ("MT20_7","070_20_7","MAT","20","7","7","“Ma te haka tau kigatou o hai atu, ‘ 'I te he'e tau pegea tuku kimatou hai hekau.’ “Ma te hai atu ia kia te kigatou, ‘Koutou boo atu ma'u o hai hekau i toku 'umanga kaubago.’ ");
INSERT INTO mnv_vpl VALUES ("MT20_8","070_20_8","MAT","20","8","8","“Nimaa i te ahiahi, te hakahua o te 'umanga kaubago, noko hai atu ki tona pegea ge'o hekau, ‘Pogoaki atu i na pegea e hai hekau o tau'i agatou ga'unga, haka tu'u tau'i atu i na pegea noko tuku taha'aki o hai hekau, ano taha'aki i na pegea noko mataa tuku o hai hekau.’ ");
INSERT INTO mnv_vpl VALUES ("MT20_9","070_20_9","MAT","20","9","9","“Ma te boo ake na pegea noko tuku o hai hekau i te ga'aa page, o manga ga'u taki tasi agatou mane siliva. ");
INSERT INTO mnv_vpl VALUES ("MT20_10","070_20_10","MAT","20","10","10","Ka te 'aso na boo ake ai na pegea noko mataa tuku o hai hekau, ko kigatou noko haka sano ke ga'u 'eha, ka ko kigatou na manga to'o mane takitasi ngatahi. ");
INSERT INTO mnv_vpl VALUES ("MT20_11","070_20_11","MAT","20","11","11","Te gholoba na ga'u ai na tau'i ogatou, ko kigatou na haka megemege ki te hakahua o te 'umanga kaubago. ");
INSERT INTO mnv_vpl VALUES ("MT20_12","070_20_12","MAT","20","12","12","Ko kigatou noko hai atu, ‘Na pegea nei noko tuku taha'aki o manga hai hekau i te mi'i gholoba e tasi, ka kua hai e koe o papata kia te kimatou kua ngaage te hai hekau ma te begangia i te 'ao kaatoa.’ ");
INSERT INTO mnv_vpl VALUES ("MT20_13","070_20_13","MAT","20","13","13","“Ka te hakahua o te 'umanga kaubago, noko haka tau ki te launatasi ia te kigatou o hai atu, ‘Taku hemasi'inga, e he'e hai eau he hai 'anga songo kia te koe. Ko koe noko maangao ke hai hekau ke tasi mane siliva i te 'ao, 'ine? ");
INSERT INTO mnv_vpl VALUES ("MT20_14","070_20_14","MAT","20","14","14","To'o ake te tau'i o'ou na o hano. Taku paaunga ke haiga'a ki na pegea noko tuku taha'aki o hai hekau ke papata kia te koe. ");
INSERT INTO mnv_vpl VALUES ("MT20_15","070_20_15","MAT","20","15","15","'Ai e he'e gaoi te hai eau nia e siahai kau hai 'ia i aku mane? Po ko koe e 'ita ia te au e 'agoha?’ ” ");
INSERT INTO mnv_vpl VALUES ("MT20_16","070_20_16","MAT","20","16","16","Ma te hai atu a Jesus, “E konei na noho, koai manga mugi, e hai ke go mu'a, ka koai manga mu'a e hai ke go mugi.” ");
INSERT INTO mnv_vpl VALUES ("MT20_17","070_20_17","MAT","20","17","17","Te gholoba noko hano ai a Jesus ki Jerusalem, ko Ia noko gea ki tona katoa tuma'a e gua pegea haka ako soko i te boo 'anga i te agatu'u o hai atu kia te kigatou, ");
INSERT INTO mnv_vpl VALUES ("MT20_18","070_20_18","MAT","20","18","18","“Ko kitatou e hakaneke ki Jerusalem, ka te Hosa o Pegea ka hakasoko 'ia ki na hakahua o na priest ma na ako o na tagangonga. E hai kigatou go haka pau 'ia ke mate. ");
INSERT INTO mnv_vpl VALUES ("MT20_19","070_20_19","MAT","20","19","19","Ma te hai kego haiga'a ia te Ia ki na pegea 'aatea, ke go noko putatai kia te Ia, ma te kogu ia te Ia, ma te go taa ia te Ia ki te kros. Ka nimaa go i te 'ao kago togu kinai tona mate, ko Ia e hai ke go haka ma'ugi haka hoki.” ");
INSERT INTO mnv_vpl VALUES ("MT20_20","070_20_20","MAT","20","20","20","Kae boo ake te tinana o gua hosa o Zebedee ma gua'ana tama kia Jesus, o he toko tugi 'aki kae haka ene kia Jesus ke go hai he hai 'anga gaoi ki gua'ana tama. ");
INSERT INTO mnv_vpl VALUES ("MT20_21","070_20_21","MAT","20","21","21","Ma te haka anu atu kinai a Jesus, “Niaa te siahai kinai koe?” Ma te hai atu te hahine, “Ke tuku gua'aku tama nei ke go noho tegaa i tou pa'asi maui, kae noho tegaa i tou pa'asi sema i tou 'aso Hakahua.” ");
INSERT INTO mnv_vpl VALUES ("MT20_22","070_20_22","MAT","20","22","22","Hai atu a Jesus kia gua taangata, “E he'e na'a e koutou nia te he haka ene 'aki ai koutou. 'Ai kougua kago 'aonga te bibinu i te kapu e hai kau go binu ai?” Haka tau atu a kigaaua, “ 'Oo, manga 'aonga.” ");
INSERT INTO mnv_vpl VALUES ("MT20_23","070_20_23","MAT","20","23","23","Hai atu a Jesus kia te kigaaua, “E maa'ogi kougua kago bibinu i te kapu nei, ka te noho 'aki kougua i toku pa'asi maui ma toku pa'asi sema, e he'e te hai 'anga kau tuku 'ia. Gua noohonga nei gua kunga ki na pegea na 'oti i te haka pau kinai e Tamau.” ");
INSERT INTO mnv_vpl VALUES ("MT20_24","070_20_24","MAT","20","24","24","Te gholoba na haka gongo kinai tegaa katoa pegea haka ako, ko kigatou noko haka tangi 'aki toto'a ki te hai haanau nei. ");
INSERT INTO mnv_vpl VALUES ("MT20_25","070_20_25","MAT","20","25","25","Ma te ngege atu a Jesus ia te kigatou o haka putu mai, o hai atu, “Manga na'a e koutou, na hutiaki o na pegea 'aatea e pau kigatou o hakahuahua ia te kigatou. Ogatou hakahua te noko manga hai paaunga kia te kigatou. ");
INSERT INTO mnv_vpl VALUES ("MT20_26","070_20_26","MAT","20","26","26","Ka koutou he'e hai ke konaa autou noho. Koai e siahai ke hua'eha ia te koutou, koia e hai ke hai ai mo'outou he guani. ");
INSERT INTO mnv_vpl VALUES ("MT20_27","070_20_27","MAT","20","27","27","Koai e siahai ke mu'a, koia e hai ke hai hekau kia te koutou. ");
INSERT INTO mnv_vpl VALUES ("MT20_28","070_20_28","MAT","20","28","28","Ke noho pe te Hosa o Pegea, noko he'e a'u ke hai hekau kinai, ka ko Ia te noko a'u ke hai hekau, ma te ke haiga'a te ma'ugi te tau'i ki na ma'ugi o pegea.” ");
INSERT INTO mnv_vpl VALUES ("MT20_29","070_20_29","MAT","20","29","29","Te gholoba noko boo ai a Jesus ma ona pegea haka ako i Jericho, te hu'ai tu'uganga noko tata'o ia te Ia. ");
INSERT INTO mnv_vpl VALUES ("MT20_30","070_20_30","MAT","20","30","30","Ka noko iai te toka gua taangata kikibi, noko manga noho 'aki i te taha aga. Nimaa haka gongo kigaaua ko Jesus e sigi, ko kigaaua na ngengege, “Hakahua, te Hosa o David, 'agoha mai kia te kimaaua.” ");
INSERT INTO mnv_vpl VALUES ("MT20_31","070_20_31","MAT","20","31","31","Gehu te 'apitanga kia te kigaaua, ma te kaunaki ia te kigaaua ke ngongoto. Kae manga tuku haka soo ake ogaa ge'o o ngengege toto'a o hai atu, “Hakahua, te Hosa o David, 'agoha mai kia te kimaaua!” ");
INSERT INTO mnv_vpl VALUES ("MT20_32","070_20_32","MAT","20","32","32","Ko Jesus na tu'u o ngege atu ia te kigaaua, o hai atu kinai, “Niaa te sia hahai kougua kau hai 'ia kia te kougua?” ");
INSERT INTO mnv_vpl VALUES ("MT20_33","070_20_33","MAT","20","33","33","Ko kigaaua noko haka tau o hai atu, “Hakahua, ko kimaaua e siahahai ke lugaluga omaua mata.” ");
INSERT INTO mnv_vpl VALUES ("MT20_34","070_20_34","MAT","20","34","34","Ko Jesus na hu'ai 'agoha kia te kigaaua, ma te 'oso ki ogaa mata. Ko kigaaua na ghali o lugaluga ogaua mata o hiina'i, kae tata'o ia Jesus. ");
INSERT INTO mnv_vpl VALUES ("MT21_1","070_21_1","MAT","21","1","1","Te 'aso na hitaiaki ai kigatou ki Jerusalem, kae tatae ki Bethphage e i-te Ogo i Olives. Haka to'o e Jesus te toka gua i ona pegea haka ako, ");
INSERT INTO mnv_vpl VALUES ("MT21_2","070_21_2","MAT","21","2","2","kae hai atu kia te kigaaua, “Boo atu ki te mi'i manaha e i-mu'a ia te kougua, ka kite ai kougua i te donki manga taugaki haka pigi kinai tena punua tangata. Ogo huhuke atu o kakabe ngatahi mai kia te Au ");
INSERT INTO mnv_vpl VALUES ("MT21_3","070_21_3","MAT","21","3","3","Nimaa go gea he pegea i he hai 'anga kia te kougua, ogo hai atu kinai, ‘E siahai kinai te Hakahua,’ ka ke go manga haka to'o ghali mai eia.” ");
INSERT INTO mnv_vpl VALUES ("MT21_4","070_21_4","MAT","21","4","4","Te hai 'anga nei noko hai ke haka maa'ogi ai nia noko gea kinai te taauga, o hai ake: ");
INSERT INTO mnv_vpl VALUES ("MT21_5","070_21_5","MAT","21","5","5","“Hai atu ki te Tama'ahine a Zion: Ina 'atu, te hakahua o 'ou e a'u kia te koe. E haka ma'ugago o eke o a'u i te donki ma te punua tangata a te donki.” ");
INSERT INTO mnv_vpl VALUES ("MT21_6","070_21_6","MAT","21","6","6","Gua pegea haka ako na boo o hai nia noko tongitongi aki e Jesus ke hai. ");
INSERT INTO mnv_vpl VALUES ("MT21_7","070_21_7","MAT","21","7","7","Ko kigaaua na kakabe mai te donki ma tena punua, o haka eke kinai ogaua ake o noho ai a Jesus. ");
INSERT INTO mnv_vpl VALUES ("MT21_8","070_21_8","MAT","21","8","8","Kae hohoga na ake o te 'apitanga i te agatu'u. Kae toghi toghi e kogaa 'isi pegea na 'ugu ga'akau o hohoga ma'u i te agatu'u. ");
INSERT INTO mnv_vpl VALUES ("MT21_9","070_21_9","MAT","21","9","9","Te 'apitanga noko mumu'a kogaa kae mumugi kogaa ia Jesus, o manga ngengege ngatahi o hai ake, “Te haka e'eha kia te Hosa o David! Te haka gaoinga kia te Ia e a'u i te ingoa o te 'Aitu! Te haka e'eha kia te 'Aitu Ma'u 'agunga.” ");
INSERT INTO mnv_vpl VALUES ("MT21_10","070_21_10","MAT","21","10","10","Te gholoba na hano ai a Jesus ki goto i Jerusalem, ko ba'i pegea i Jerusalem noko nganangana kinai, ma te he haka anuanu 'aki, “Koai tenei?” ");
INSERT INTO mnv_vpl VALUES ("MT21_11","070_21_11","MAT","21","11","11","Ka te 'apitanga noko tata'o ai noko haka tau o hai atu, “Ko Jesus tenei, te taauga mai Nazareth i Galilee!” ");
INSERT INTO mnv_vpl VALUES ("MT21_12","070_21_12","MAT","21","12","12","Hano a Jesus ki goto i te Hage Tapu, o pagepage e Ia na pegea noko manga tau'i ma te salemu me'a i te kunga na. 'Aka gigingi e Ia na kaupea noko sui mane ai, kae 'aka gigingi ma'u e Ia na kaupea o na pegea noko salemu gupe. ");
INSERT INTO mnv_vpl VALUES ("MT21_13","070_21_13","MAT","21","13","13","Ma te hai atu kia te kigatou, “Na 'oti i te kanukanu: ‘Toku Hage e hai kego mate: Te Hage Takunga,’ ka kua hai e koutou o hai ai te 'ana ki na pegea kaia'a.” ");
INSERT INTO mnv_vpl VALUES ("MT21_14","070_21_14","MAT","21","14","14","Na pegea kikibi ma na pegea seu noko boo ake kia Jesus i te Hage Tapu, o hakagaoi e Ia ia te kigatou. ");
INSERT INTO mnv_vpl VALUES ("MT21_15","070_21_15","MAT","21","15","15","Ka te 'aso na hiina'i ai na hakahua o na priest, ma na ako o na tagangonga ki na hai 'anga gaoi noko hai e Jesus, ma te haka gongo ki te ngengege 'anga a na tama giki i te Hage Tapu o hai ake, “Te haka e'eha ki te Hosa o David!” ko kigatou na hu'ai he 'ika'ika 'aki ai. ");
INSERT INTO mnv_vpl VALUES ("MT21_16","070_21_16","MAT","21","16","16","Ko kigatou noko haka anu 'aki atu kia Jesus, “Ko koe e haka gongo ki nia e gegea kinai na tama giki?” Ma te haka tau atu a Jesus, “ 'Oo, 'ai e he'e haka sahe e koutou na Kanukanu e hai ake: ‘Ko Koe kua hai na ngutu o na tamagiki ma na tamagiki koi haa uu o haiga'a te haka e'eha maa'ogi’?” ");
INSERT INTO mnv_vpl VALUES ("MT21_17","070_21_17","MAT","21","17","17","Ma te hano a Jesus ia te kigatou i Jerusalem ki Bethany o noho ai i te poo. ");
INSERT INTO mnv_vpl VALUES ("MT21_18","070_21_18","MAT","21","18","18","Ko Jesus noko hokimai ki Jerusalem i te mahoata pilupilu o tegaa 'ao, ka ko Ia noko ongea. ");
INSERT INTO mnv_vpl VALUES ("MT21_19","070_21_19","MAT","21","19","19","Ma te ina ki te ga'akau ‘fig’ i te pa'asi o te aga tu'u, o hakaneke kinai, e he'e tau hua, ka manga na gau. Ma te hai atu Ia ki te ga'akau, “Ko koe kago he'e hua haka hoki i he 'aso.” Kae manga ghali te ga'akau o maemae. ");
INSERT INTO mnv_vpl VALUES ("MT21_20","070_21_20","MAT","21","20","20","Te 'aso na hiina'i ai kinai na pegea haka ako, ko kigatou na he langalanga 'aki ai o hai ake, “E kohea na hai e maemae ghali ai te ‘fig’ nei?” ");
INSERT INTO mnv_vpl VALUES ("MT21_21","070_21_21","MAT","21","21","21","Ma te haka tau a Jesus o hai atu, “Ko Au e gea maa'ogi atu kia te koutou: Koutou poi pau o too mogimogi kia te 'Aitu ma te he'e mou tegeu'a, e he'e manga hai e koutou nia kua hai ki te ‘fig’ nei, ka koutou ka go 'aonga ma'u te hai atu ki te ogo nei: ‘Hinatu o too ki te moana,’ kago hai. ");
INSERT INTO mnv_vpl VALUES ("MT21_22","070_21_22","MAT","21","22","22","Koutou poi too, kago ga'u e koutou nia kago haka ene 'aki ai koutou i te sogi.” ");
INSERT INTO mnv_vpl VALUES ("MT21_23","070_21_23","MAT","21","23","23","Ko Jesus noko hano ki goto i te Hage Tapu, ka te gholoba noko manga ako ai Ia, na hakahua o na priest ma na 'agiki o na Jew noko boomai kia te Ia, o haka anu 'aki atu, “Koai te tuku ia te Koe o hai na hai 'anga nei? Koai ma'u noko haiga'a kia te Koe na paaunga nei?” ");
INSERT INTO mnv_vpl VALUES ("MT21_24","070_21_24","MAT","21","24","24","Ma te haka tau kinai a Jesus o hai atu, “Ko Au e hai kau haka anuanu ma'u kia te koutou i te launatasi haka anu. Ka nimaa haka tau mai koutou kia te Au, 'io mugi Au o hogahoga kia te koutou po o'ai na taganga e hai ai e Au na hai 'anga nei. ");
INSERT INTO mnv_vpl VALUES ("MT21_25","070_21_25","MAT","21","25","25","Te haa gogomi pegea 'anga a John, te hai 'anga mai hea? Te hai 'anga mai te gangi? Po te hai 'anga mai a pegea?” Ka na mataa hegeu kinai kigatou ano hai ake, “Nimaa hai atu kitatou, ‘Te hai 'anga mai te gangi,’ ka hai mai, ‘Ka 'eaa noko he'e too ai koutou kia John?’ ");
INSERT INTO mnv_vpl VALUES ("MT21_26","070_21_26","MAT","21","26","26","Ka nimaa hai atu kitatou, ‘Te hai 'anga mai a pegea,’ ko kitatou e matataku ki te 'apitanga, iteme'agaa kua na'a e kigatou, ko John te taauga.” ");
INSERT INTO mnv_vpl VALUES ("MT21_27","070_21_27","MAT","21","27","27","Ko kigatou na haka tau atu kia Jesus, “E he'e na'a e kimatou.” Ma te hai atu a Jesus, “Ka he'e hogahoga ma'u e Au kia te koutou, po o'ai na taganga te hai ai e Au na hai 'anga nei. ");
INSERT INTO mnv_vpl VALUES ("MT21_28","070_21_28","MAT","21","28","28","“Tehea tautou tegeu'a ki te haka gaataki nei: Noko iai te tangata, noko hai gua ona hosa. Koia noko mataa hano ki te hai ta'okete o hai atu kinai, ‘Tama, hinatu i te 'ao nei o hai hekau kia te au i toku 'umanga kaubago.’ ");
INSERT INTO mnv_vpl VALUES ("MT21_29","070_21_29","MAT","21","29","29","“Koia noko haka tau atu, ‘Koau ka he'e hano,’ ka na mugi o sui tegeu'a o hano. ");
INSERT INTO mnv_vpl VALUES ("MT21_30","070_21_30","MAT","21","30","30","“Mugi te tamana o hano ki tegaa ona hosa, o gea kinai i te hai 'anga e tasi. Koia na hakatau atu kinai, ‘E hai kau hano, hakahua,’ ka noko he'e hano. ");
INSERT INTO mnv_vpl VALUES ("MT21_31","070_21_31","MAT","21","31","31","“Koai i te toka gua nei na hai nia te noko siahai kinai te tamana?” Haka tau atu kigatou, “Te hai ta'okete.” Hai atu a Jesus kia te kigatou, “Ko Au e gea maa'ogi kia te koutou: Na pegea tibu takis ma na haahine maasoko, kago mumu'a ia te koutou ki te Hakahua 'anga a te 'Aitu. ");
INSERT INTO mnv_vpl VALUES ("MT21_32","070_21_32","MAT","21","32","32","Iteme'agaa ko John noko mu'a mai kia te koutou ke haka 'agi kia te koutou na hai 'anga tinogaoi. Ka koutou na he'e sui tegeu'a o too kia te ia, ka na pegea tibu takis ma na haahine maasoko na too kinai. Ka koutou he'e po te hiina'i ki na hai 'anga nei, koutou noko he'e sui tegeu'a o too kia te ia. ");
INSERT INTO mnv_vpl VALUES ("MT21_33","070_21_33","MAT","21","33","33","“Haka gongo mai ki tegaa haka gaataki: Noko iai te pegea hai ona kunga henua noko sanga tona 'umanga kaubago. Noko 'ati eia te 'aa o mugheghi ai, kegi ma'u eia te pupu'a ke go natu kinai na hua kaubago ke hai ai ni waeni. Kae 'ati ma'u e ia te hata mata o ma'u 'agunga, 'io mugi ia o tuha te 'umanga nei ki na pegea noko tau'i ke ge'o tona 'umanga, kae hano o sehu. ");
INSERT INTO mnv_vpl VALUES ("MT21_34","070_21_34","MAT","21","34","34","Nimaa hitaiaki te 'aso ke utu ai te 'umanga nei, kae haka to'o e ia ona guani ke to'o tena 'inati i na waeni. ");
INSERT INTO mnv_vpl VALUES ("MT21_35","070_21_35","MAT","21","35","35","“Ka na ge'o sanga o te 'umanga na labu e kigatou ona guani nei, o kogu e kigatou tegaa, kae taa tegaa, kae 'aumahu hatu tegaa. ");
INSERT INTO mnv_vpl VALUES ("MT21_36","070_21_36","MAT","21","36","36","Ma te haka to'o hoki eia kogaa, noko 'api o sigi i na guani noko mataa haka to'o, ka na hai songo ma'u e na ge'osanga ia te kigatou. ");
INSERT INTO mnv_vpl VALUES ("MT21_37","070_21_37","MAT","21","37","37","Te hai 'anga taha'aki, koia na haka to'o tona hosa ki na ge'osanga. Koia noko tegeu'a ake, ‘Ko kigatou kago pago kia toku hosa.’ ");
INSERT INTO mnv_vpl VALUES ("MT21_38","070_21_38","MAT","21","38","38","“Ka te 'aso noko hiina'i atu ai na ge'o sanga o te 'umanga ki te tama, ko kigatou na konei agatou gegea, ‘Tenei te hosa o te hakahua o te 'umanga. Boomai kitatou taa 'ia, ka ke hai mo'otatou ana hesuinga.’ ");
INSERT INTO mnv_vpl VALUES ("MT21_39","070_21_39","MAT","21","39","39","Ma te logi e kigatou ia te ia, o tupe ki taha i te 'umanga o taa ai ia te ia.” ");
INSERT INTO mnv_vpl VALUES ("MT21_40","070_21_40","MAT","21","40","40","“Te 'aso kago a'u ai te hakahua o te 'umanga, niaa kago hai eia ki na ge'o sanga o te 'umanga?” ");
INSERT INTO mnv_vpl VALUES ("MT21_41","070_21_41","MAT","21","41","41","Ko kigatou noko haka tau atu, “Kago pau ia o taa haka masogo na pegea hai hai 'anga songo, kae tuha tena 'umanga kaubago ki gaa pegea ke hai hekau ai, ka ke go haiga'a tona 'inati i na waeni i te 'aso utu ai te 'umanga.” ");
INSERT INTO mnv_vpl VALUES ("MT21_42","070_21_42","MAT","21","42","42","Hai atu a Jesus kia te kigatou, “ 'Ai koutou e he'e haka sahe i na Kanukanu Tapu e hai ake: ‘Te hatu na he'e siahahai kinai na pegea 'ati hage, na hai ai te tokoi ki te hage. Te hai 'anga a te 'Aitu tenei, kae hu'ai maatanga gaoi ki otatou mata.’ ");
INSERT INTO mnv_vpl VALUES ("MT21_43","070_21_43","MAT","21","43","43","Kogaa na noho te hai 'anga e hai atu ai Au kia te koutou: Te Hakahua 'anga a te 'Aitu, e hai ke go sa'u ia te koutou, o haiga'a ki na pegea kago hai hekau gaoi o tau hua. ");
INSERT INTO mnv_vpl VALUES ("MT21_44","070_21_44","MAT","21","44","44","Te pegea kago guti ki te hatu nei, kago tukia o matohitohi, ka te pegea kago too kinai te hatu nei, kago tuki haka momomomo e te hatu ia te ia.” ");
INSERT INTO mnv_vpl VALUES ("MT21_45","070_21_45","MAT","21","45","45","Te 'aso na haka gongo ai na hakahua o na priest ma na ako o na tagangonga ki na haka gaataki a Jesus, noko na'a e kigatou ko Ia manga gea kia te kigatou. ");
INSERT INTO mnv_vpl VALUES ("MT21_46","070_21_46","MAT","21","46","46","Ma te gaataki kigatou he 'osohi kia Jesus, ka noko matataku ki te 'apitanga, iteme'agaa kua na'a e te 'apitanga ko Jesus te taauga. ");
INSERT INTO mnv_vpl VALUES ("MT22_1","070_22_1","MAT","22","1","1","Ko Jesus noko gea hoki ma'u kia te kigatou i gaa haka gaataki, o hai atu, ");
INSERT INTO mnv_vpl VALUES ("MT22_2","070_22_2","MAT","22","2","2","“Te Hakahua 'anga a te 'Aitu, manga papata ki te hakahua e ngaague te haka tahinga ki te takanga hai ho'ou o tena hosa. ");
INSERT INTO mnv_vpl VALUES ("MT22_3","070_22_3","MAT","22","3","3","Haka to'o e te hakahua o na guani o boo i na pegea noko haka pogo e ia ki te haka tahinga, ke 'atigongo kia te kigatou ke boomai. Ka ko kigatou na he'e mamaka ke boomai. ");
INSERT INTO mnv_vpl VALUES ("MT22_4","070_22_4","MAT","22","4","4","“Mugi te hakahua o haka to'o kogaa guani kae hai atu kinai, ‘Hai atu ki na pegea noko haka pogo, ko au kua 'oti i te ngaague taku kainga. Aku buluka ma aku manu he toogohi manga pusi o pepeti kua 'oti i te taa, ko ba'i me'a kua 'oti i te ngaague. Boomai ki te haka tahinga ki toku hosa e hai uguugu ho'ou.’ ");
INSERT INTO mnv_vpl VALUES ("MT22_5","070_22_5","MAT","22","5","5","Ka ko kigatou noko he'e pungaga kinai, manga taki boo, hano tegaa ki tena 'umanga, hano tegaa ki tena kunga hai mane. ");
INSERT INTO mnv_vpl VALUES ("MT22_6","070_22_6","MAT","22","6","6","Kae labu e kogaa na guani o hai songo toto'a ma te taa ia te kigatou. ");
INSERT INTO mnv_vpl VALUES ("MT22_7","070_22_7","MAT","22","7","7","Te hakahua na haka tangi to'a. Koia na haka to'o tena tau'a o taa na pegea kua taa ona guani, ma te tutu tegatou hu'ai manaha. ");
INSERT INTO mnv_vpl VALUES ("MT22_8","070_22_8","MAT","22","8","8","'Io mugi o hai atu ki ona guani, ‘Te haka tahinga nei kua 'oti i te ngaague, ka na pegea noko haka pogo eau, kua he'e boomai. ");
INSERT INTO mnv_vpl VALUES ("MT22_9","070_22_9","MAT","22","9","9","Boo atu ki na agatu'u. Koai e sasa'o kinai koutou, haka pogo atu ki te haka tahinga nei.’ ");
INSERT INTO mnv_vpl VALUES ("MT22_10","070_22_10","MAT","22","10","10","Ma te boo na guani nei ki na tautaha ona agatu'u, o haka putu mai e kigatou ba'i pegea sasa'o kinai, na pegea gaoi ma na pegea songo. Te hage noko hai ai te haka tahinga na 'api to'a i na pegea noko haka pogo. ");
INSERT INTO mnv_vpl VALUES ("MT22_11","070_22_11","MAT","22","11","11","“Ka te gholoba na hinake ai te hakahua ke ina ki na pegea noko haka pogo, na ina ki te tangata he'e mago i te ake o te haka tahinga ki te takanga hai ho'ou. ");
INSERT INTO mnv_vpl VALUES ("MT22_12","070_22_12","MAT","22","12","12","Ma te haka anu kinai te hakahua o hai atu, ‘Hemasi'inga, ko koe e kohea au a'u ki te kunga nei, e he'e mago ai koe i te ake o te haka tahinga nei?’ Te tangata na pau o he'e muna. ");
INSERT INTO mnv_vpl VALUES ("MT22_13","070_22_13","MAT","22","13","13","“Ma te hai atu te hakahua ki ona guani, ‘Gii atu gua gima ma gua ba'e, o tupe ia te ia ki te poo'uginga i haho. Te kunga e hai kego tatangi ma te he taangisi 'aki ai na niho.’ ");
INSERT INTO mnv_vpl VALUES ("MT22_14","070_22_14","MAT","22","14","14","“Iteme'agaa e hu'ai 'eha pegea e haka pogo, ka kago he'e 'eha pegea haka pau.” ");
INSERT INTO mnv_vpl VALUES ("MT22_15","070_22_15","MAT","22","15","15","Ma te he uguhi ki haho na Pharisee o hai tegatou hegeunga, kigatou haka anuanu pake 'ia ia Jesus, i ma'ana ni gea 'anga. ");
INSERT INTO mnv_vpl VALUES ("MT22_16","070_22_16","MAT","22","16","16","Haka to'o kogaa i ogatou pegea haka ako kia te Ia, ma na pegea o te tu'uganga a Herod. O hai atu kigatou, “Ako, e na'a e kimatou ko Koe te pegea maa'ogi gaoi manga ako e Koe na noho o God i te maa'ogi. Ko Koe e he'e hai e na tegeu'a pegea ke se'ia, iteme'agaa ko Koe e he'e haka tukutuku ki na noho o pegea. ");
INSERT INTO mnv_vpl VALUES ("MT22_17","070_22_17","MAT","22","17","17","Hogahoga mai kia te kimatou, po tehea tau tegeu'a, te hai 'anga gaoi te tau'i takis kia Caesar po e si'ai?” ");
INSERT INTO mnv_vpl VALUES ("MT22_18","070_22_18","MAT","22","18","18","Ka ko Jesus noko manga na'a e Ia agatou tegeu'a songo nei. Noko hai atu kinai, “Koutou na pegea haka hagehage. 'Eaa e haka anuanu pake ai e koutou ia te Au? ");
INSERT INTO mnv_vpl VALUES ("MT22_19","070_22_19","MAT","22","19","19","Haka 'agi mai te mane manga hai e koutou o tau'i takis ai.” Ma te to'o ake e kigatou te mane. ");
INSERT INTO mnv_vpl VALUES ("MT22_20","070_22_20","MAT","22","20","20","Ma te haka anu atu a Jesus kia te kigatou, “To'ai te 'ata tenei, ma to'ai haka 'igonga?” ");
INSERT INTO mnv_vpl VALUES ("MT22_21","070_22_21","MAT","22","21","21","Ma te haka tau a kigatou o hai atu, “O'o Caesar.” Mugi a Jesus o hai atu, “ 'Abatu kia Caesar nia 'a Caesar, kae haiga'a kia God nia 'a God.” ");
INSERT INTO mnv_vpl VALUES ("MT22_22","070_22_22","MAT","22","22","22","Te 'aso na haka gongo kinai kigatou, ko kigatou na he tu'ia 'aki. Ma te ti'aki e kigatou ia te Ia kae boo. ");
INSERT INTO mnv_vpl VALUES ("MT22_23","070_22_23","MAT","22","23","23","Na Sadducee noko haka si'ai e kigatou te maa'ugi giu mai i te mate, noko boo mai o haka anu 'aki atu kia Jesus, ");
INSERT INTO mnv_vpl VALUES ("MT22_24","070_22_24","MAT","22","24","24","“Ako, ko Moses noko hai mai kia te kimatou, ‘Nimaa go iai he tangata mate kae he'e tau tama giki, tena taina e hai ke sui o pipiki e ia te hahine e magepe, ke go hai ni tama giki ma'a tena ta'okete.’ ");
INSERT INTO mnv_vpl VALUES ("MT22_25","070_22_25","MAT","22","25","25","Ka noko iai te 'api taangata toka hitu ia te kimatou. Noko hai te uguugu o te hai ta'okete ano mate, kae he'e tau tama giki, tuku tena uguugu kia te taina. ");
INSERT INTO mnv_vpl VALUES ("MT22_26","070_22_26","MAT","22","26","26","Te hai 'anga e tasi na hai ma'u ki te hai taina e toka gua kinai ma te hai taina e toka togu kinai, na konei na noho ma'u ki te 'api, o hetae ki te hai taina noko toka hitu kinai. ");
INSERT INTO mnv_vpl VALUES ("MT22_27","070_22_27","MAT","22","27","27","Ka na mate taha'aki te hahine. ");
INSERT INTO mnv_vpl VALUES ("MT22_28","070_22_28","MAT","22","28","28","Ka nimaa go i te maa'u'ugi giu mai 'anga i te mamate, to'ai te uguugu te hahine nei i te 'api taangata toka hitu, iteme'agaa na pipiki ngatahi e kigatou ia te ia?” ");
INSERT INTO mnv_vpl VALUES ("MT22_29","070_22_29","MAT","22","29","29","Ma te haka tau a Jesus o hai atu kia te kigatou, “Koutou e saga, iteme'agaa e he'e na'a e koutou na Kanukanu Tapu, po te taganga o God. ");
INSERT INTO mnv_vpl VALUES ("MT22_30","070_22_30","MAT","22","30","30","Te maa'u'ugi giu mai 'anga i te mamate, ko pegea kago he'e taka, kago he'e hai uguugu ma te kago he'e hai matu'a. E hai kigatou go manga noho pe na ensel i te gangi. ");
INSERT INTO mnv_vpl VALUES ("MT22_31","070_22_31","MAT","22","31","31","Ka i na noho o te maa'ugi giu mai i te mate, 'ai noko he'e haka sahe e koutou nia noko gea ai a te 'Aitu kia te koutou o hai ake, ");
INSERT INTO mnv_vpl VALUES ("MT22_32","070_22_32","MAT","22","32","32","‘Ko Au te God o Abraham, ma te God o Isaac, ma te God o Jacob.’ Ko Ia he'e te 'Aitu o na pegea mamate, ka te 'Aitu o na pegea maa'ugi!” ");
INSERT INTO mnv_vpl VALUES ("MT22_33","070_22_33","MAT","22","33","33","Te gholoba na haka gongo kinai te 'apitanga, ko kigatou na he tu'ia 'aki i ana akonga. ");
INSERT INTO mnv_vpl VALUES ("MT22_34","070_22_34","MAT","22","34","34","Te 'aso na haka gongo ai na Pharisee ko Jesus kua hai e Ia na Sadducee o he'e mumuna, ko kigatou na haka putu. ");
INSERT INTO mnv_vpl VALUES ("MT22_35","070_22_35","MAT","22","35","35","Kae launatasi ia te kigatou, e na'a gaoi e ia na tagangonga, noko hai lobo ia Jesus i tena haka anuanu nei: ");
INSERT INTO mnv_vpl VALUES ("MT22_36","070_22_36","MAT","22","36","36","“Ako, tehea te me'a e hua'eha i na tagangonga?” ");
INSERT INTO mnv_vpl VALUES ("MT22_37","070_22_37","MAT","22","37","37","Ma te haka tau a Jesus kia te ia o hai atu, “ ‘Ma'ine atu kia te 'Agiki te 'Aitu o 'ou, i tou uso ngatahi, ma tou ma'ugi ngatahi, ma au haingaa tegeu'a ngatahi.’ ");
INSERT INTO mnv_vpl VALUES ("MT22_38","070_22_38","MAT","22","38","38","Tenei te tagangonga e mu'a kae hua'eha ma'u. ");
INSERT INTO mnv_vpl VALUES ("MT22_39","070_22_39","MAT","22","39","39","Ka te tagangonga e toka gua kinai e konei na noho: ‘Ma'ine atu ki ou pegea e pata mai, ke noho pe au ma'ine 'anga kia te koe.’ ");
INSERT INTO mnv_vpl VALUES ("MT22_40","070_22_40","MAT","22","40","40","Ko ba'i tagangonga a Moses ma na akonga a na taauga, manga tau i te toka gua tagangonga nei.” ");
INSERT INTO mnv_vpl VALUES ("MT22_41","070_22_41","MAT","22","41","41","Te 'aso noko haka putu ai na Pharisee, ko Jesus noko haka anu kia te kigatou o hai atu, ");
INSERT INTO mnv_vpl VALUES ("MT22_42","070_22_42","MAT","22","42","42","“Tehea tautou tegeu'a ki te 'Agiki Taga'ia? To'ai te hosa?” Ko kigatou noko haka tau atu, “Ko Ia te Hosa o David.” ");
INSERT INTO mnv_vpl VALUES ("MT22_43","070_22_43","MAT","22","43","43","Hai atu a Jesus kia te kigatou, “Ka 'eaa a David, noko gea i te Spirit Tapu, o mate eia te 'Agiki Taga'ia tena hakahua, i te noko konei ana hai ake: ");
INSERT INTO mnv_vpl VALUES ("MT22_44","070_22_44","MAT","22","44","44","‘Ko te 'Agiki noko hai atu ki toku Hakahua: “Noho mai i toku pa'asi gima maui, kego ano pau Au o tuku ou makau i ou gago ba'e.” ’ ");
INSERT INTO mnv_vpl VALUES ("MT22_45","070_22_45","MAT","22","45","45","Ka nimaa hai ake a David ko ia tena Hakahua, 'eaa e hai ake ai koutou ko Ia tena hosa?” ");
INSERT INTO mnv_vpl VALUES ("MT22_46","070_22_46","MAT","22","46","46","Ka na he'e kitea he pegea haka tau kia Jesus i he kupu e tasi, ma te haka tu'u i te 'ao na, noko he'e tau pegea toka manaba ke haka anu kia te Ia i ni haka anuanu ma'u. ");
INSERT INTO mnv_vpl VALUES ("MT23_1","070_23_1","MAT","23","1","1","Ko Jesus noko hai atu ki te 'apitanga ma ona pegea haka ako, ");
INSERT INTO mnv_vpl VALUES ("MT23_2","070_23_2","MAT","23","2","2","“Na ako o na tagangonga ma na Pharisee, ko kigatou manga noho 'aki i te noohonga o Moses. ");
INSERT INTO mnv_vpl VALUES ("MT23_3","070_23_3","MAT","23","3","3","Koutou e hai ke mangangao ma te hai nia e kaunaki e kigatou ia te koutou ke hai. Kae noka te hai e koutou nia e hai e kigatou. Iteme'agaa ko kigatou e he'e hai nia manga tohi'aki ai kigatou. ");
INSERT INTO mnv_vpl VALUES ("MT23_4","070_23_4","MAT","23","4","4","Ko kigatou manga hai na kabenga mamaha o haka eke i na honga uma o gaa pegea, ka ko kigatou e he'e mi'i mangangao kigatou 'aabaki ai. ");
INSERT INTO mnv_vpl VALUES ("MT23_5","070_23_5","MAT","23","5","5","“Ko kigatou manga hai ba'i hai 'anga ke hiina'i kinai a pegea, manga hai e kigatou o hua'e'eha na tanga e tape ai na Kanukanu Tapu, o ha'uha'u ma te no'ano'a ki ogatou gima, ma te hai ogatou ake taakunga o hu'ai gogoa ki gago. ");
INSERT INTO mnv_vpl VALUES ("MT23_6","070_23_6","MAT","23","6","6","Ko kigatou manga siahahai ma'u ki na noohonga ona hakahua i na haka tahinga, ma na nonoho 'anga ma'u i na noohonga i 'ago i na Hage hai paaunga. ");
INSERT INTO mnv_vpl VALUES ("MT23_7","070_23_7","MAT","23","7","7","Ko kigatou manga siahahai ke noko oho e pegea i na kunga haka putu, ma te siahahai ke mate e pegea kigatou na ako. ");
INSERT INTO mnv_vpl VALUES ("MT23_8","070_23_8","MAT","23","8","8","“Ka ko koutou ka he'e mate na ‘Ako’, iteme'agaa e tasi outou ako ko te 'Aitu, ka koutou te 'api taangata. ");
INSERT INTO mnv_vpl VALUES ("MT23_9","070_23_9","MAT","23","9","9","Kae noka te mate he tangata i te kege nei: ‘Tamau,’ na'e tasi outou Tamana manga noho i te gangi. ");
INSERT INTO mnv_vpl VALUES ("MT23_10","070_23_10","MAT","23","10","10","Koutou ma'u he'e hai ke mate na hutiaki, iteme'agaa e tasi outou hutiaki, te 'Agiki Taga'ia. ");
INSERT INTO mnv_vpl VALUES ("MT23_11","070_23_11","MAT","23","11","11","Te hu'ai pegea ia te koutou, hai ke go hai ai mo'outou he guani. ");
INSERT INTO mnv_vpl VALUES ("MT23_12","070_23_12","MAT","23","12","12","Koai manga haka hua'eha ake ia te ia, e hai ke go tuku gago, ka koai manga tuku gago ia te ia, e hai ke go haka ma'u'agunga. ");
INSERT INTO mnv_vpl VALUES ("MT23_13","070_23_13","MAT","23","13","13","“Haka 'aagoha koutou, na ako o na tagangonga ma na Pharisee. Koutou na pegea haka hagehage. Koutou kua titingi te Hakahua 'anga a te 'Aitu. Kago he'e boo ai koutou ki goto, kae he'e tuku ma'u e koutou na pegea e hai lobo kinai ke boo ai ki goto. ");
INSERT INTO mnv_vpl VALUES ("MT23_14","070_23_14","MAT","23","14","14","“Haka 'aagoha koutou, na ako o na tagangonga ma na Pharisee. Koutou na pegea haka hagehage. Koutou manga gogoi ki na haahine magegepe, ma te kaia'a i ogatou hage, ka manga tangani taakunga gogoa. Tenei te hai 'anga kago hu'ai kagohia ai koutou. ");
INSERT INTO mnv_vpl VALUES ("MT23_15","070_23_15","MAT","23","15","15","“Haka 'aagoha koutou, na ako o na tagangonga ma na Pharisee. Koutou na pegea haka hagehage. Koutou manga tangani lango i na 'aamonga ma te moana, ke taka hugi he launatasi pegea ki autou akonga, ka nimaa hai mo'outou he pegea, manga hai e koutou o hai ai te pegea manga haka soso atu te pegea ki te ugaimami, o noho pe ko koutou. ");
INSERT INTO mnv_vpl VALUES ("MT23_16","070_23_16","MAT","23","16","16","“Haka 'aagoha koutou, na hutiaki kikibi. Koutou e hai atu te aguagu he pegea i te Hage Tapu, e he'e tau hai 'anga. Ka nimaa iai he pegea e aguagu ki na golu i te Hage Tapu, e hai ke ghaulia ki tena tukungaa kupu. ");
INSERT INTO mnv_vpl VALUES ("MT23_17","070_23_17","MAT","23","17","17","Koutou na pegea kikibi he noanoa 'aki. Nia te tamaki: Na golu po te Hage Tapu e hai na golu o 'esi'esi?! ");
INSERT INTO mnv_vpl VALUES ("MT23_18","070_23_18","MAT","23","18","18","Koutou e hai ake ma'u, nimaa iai he pegea e aguagu i te olta, e he'e tau hai 'anga. Ka nimaa iai he pegea e aguagu ki na me'a e i-te olta, e hai ke ghaulia ki tena tukungaa kupu. ");
INSERT INTO mnv_vpl VALUES ("MT23_19","070_23_19","MAT","23","19","19","Koutou na pegea kikibi. Nia te tamaki: Te ga'a tausu'u, po te olta e hai te ga'a tausu'u o 'esi'esi?! ");
INSERT INTO mnv_vpl VALUES ("MT23_20","070_23_20","MAT","23","20","20","E kogaa na noho, koai e aguagu i te olta, e aguagu i te olta ma na me'a e iai. ");
INSERT INTO mnv_vpl VALUES ("MT23_21","070_23_21","MAT","23","21","21","Ka koai e aguagu i te Hage Tapu, e aguagu i te Hage Tapu, ma te 'Aitu manga noho ai. ");
INSERT INTO mnv_vpl VALUES ("MT23_22","070_23_22","MAT","23","22","22","Koai e aguagu i te gangi, e aguagu i te noohonga o God ma Ia manga noho ai. ");
INSERT INTO mnv_vpl VALUES ("MT23_23","070_23_23","MAT","23","23","23","“Haka 'aagoha koutou, na ako o na tagangonga ma na Pharisee. Koutou na pegea haka hagehage! Koutou manga haiga'a na katoa o ba'i me'a haka tutu gaoi o autou utunga, na ‘mint’ ma na ‘dill’ ma na ‘cummin’, ka te kua ti'aki e koutou na me'a e tamaki i na tagangonga, te hai na me'a e tinogaoi, ma te he 'agogoha 'aki, ma te maa'ogi 'aki. E gaoi te haiga'a na katoa o autou me'a, i te poi he'e ti'aki e koutou na me'a e tugi ai. ");
INSERT INTO mnv_vpl VALUES ("MT23_24","070_23_24","MAT","23","24","24","Koutou na hutiaki kikibi, koutou manga baa gege na gango i outou bai, kae hogo te ‘camel’. ");
INSERT INTO mnv_vpl VALUES ("MT23_25","070_23_25","MAT","23","25","25","“Haka 'aagoha koutou, na ako o na tagangonga, ma na Pharisee. Koutou na pegea haka hagehage! Koutou manga kumu i taha i autou kapu ma na peleti o susugu, ka ko goto manga honu ai te maa'ina ma te kumu ake. ");
INSERT INTO mnv_vpl VALUES ("MT23_26","070_23_26","MAT","23","26","26","Ko koe te Pharisee kibi. Mataa huhu'i atu a goto i te kapu ma te peleti ke ma'a, ka kego ma'a ma'u a taha. ");
INSERT INTO mnv_vpl VALUES ("MT23_27","070_23_27","MAT","23","27","27","“Haka 'aagoha koutou, na ako o na tagangonga ma na Pharisee. Koutou na pegea haka hagehage! Koutou manga noho pe na takotonga huhu'i a taha o ma'a to'a, o 'aatanga gaoi a taha, ka ko goto manga honu ai na ibi o na pegea mamate, ma ba'i me'a 'ugi. ");
INSERT INTO mnv_vpl VALUES ("MT23_28","070_23_28","MAT","23","28","28","Manga konei na noho ma'u, ko taha koutou manga haka 'agi kia pegea kabe tinogaoi, ka ko goto ia te koutou manga honu ai na haka hagehage 'anga ma na hai 'anga songo. ");
INSERT INTO mnv_vpl VALUES ("MT23_29","070_23_29","MAT","23","29","29","“Haka 'aagoha koutou, na ako o na tagangonga ma na Pharisee. Koutou na pegea haka hagehage! Koutou manga 'ati na takotonga o na taauga, o gosigosi gaoi na takotonga o na pegea tinogaoi. ");
INSERT INTO mnv_vpl VALUES ("MT23_30","070_23_30","MAT","23","30","30","Kae hai ake koutou, ko kimatou poi noho 'aki ake i na 'ao o na tupuna omatou, ko kimatou ma he'e 'aabaki kia te kigatou o haka singa na toto o na taauga. ");
INSERT INTO mnv_vpl VALUES ("MT23_31","070_23_31","MAT","23","31","31","Ko koutou manga haka maa'ogi mai, konaa koutou na hanohano o na pegea noko taa e kigatou na taauga. ");
INSERT INTO mnv_vpl VALUES ("MT23_32","070_23_32","MAT","23","32","32","Pau atu o hai ke 'oti gaa, na hai 'anga songo na haka tu'u mai e outou hai tupuna. ");
INSERT INTO mnv_vpl VALUES ("MT23_33","070_23_33","MAT","23","33","33","“Koutou na ngata, na matiginga ana ngata taa pegea. E hai koutou go kohea na he'agiko i te haka pau 'anga ki te kagohia i te ugaimami? ");
INSERT INTO mnv_vpl VALUES ("MT23_34","070_23_34","MAT","23","34","34","Kogaa na noho e haka to'o mai ai e Au na taauga, ma na pegea 'igo'igo, ma na ako. E iai na pegea ia te kigatou kago taa e koutou, ma te taa kogaa ki te kros, ma te kogu kogaa i outou Hage hai paaunga, ma te go noko he 'agu'agu maki e koutou i ba'i manaha. ");
INSERT INTO mnv_vpl VALUES ("MT23_35","070_23_35","MAT","23","35","35","Ka konei koutou e hai ke go kagohia i na toto o na pegea haka tinogaoi o te 'Aitu noko singa i te kege nei, haka tu'u mai i te toto o te pegea tinogaoi ia Abel, o a'u ano hetae mai ki na toto o Zechariah te hosa o Berekiah, na taa 'ia i te noho goto 'anga i te kunga e tapu to'a ma te olta i te Hage Tapu. ");
INSERT INTO mnv_vpl VALUES ("MT23_36","070_23_36","MAT","23","36","36","Ko Au e gea maa'ogi kia te koutou: Na hai 'anga nei e hai ke go a'u o ekenga i te hanohano nei. ");
INSERT INTO mnv_vpl VALUES ("MT23_37","070_23_37","MAT","23","37","37","“Ailaue Jerusalem, Jerusalem! Te manaha na taa na taauga, ma te 'aumahu hatu kogaa pegea haka to'o mai kinai. Tahia 'aso siahai kau haka putu 'ia autou haanau ke noho pe te paolo hahine haka putu ana punua ki gago i ona kapakau, ka noko he'e siahahai kinai koutou. ");
INSERT INTO mnv_vpl VALUES ("MT23_38","070_23_38","MAT","23","38","38","Hiina'i mai, te hage o 'outou kua ti'akina o gaabaki. ");
INSERT INTO mnv_vpl VALUES ("MT23_39","070_23_39","MAT","23","39","39","Ka ko Au e hai atu kia te koutou, koutou kago he'e hiina'i giu kia te Au, hano ano go hai ake koutou, ‘Haka gaoi ia te Ia e a'u i te ingoa o te 'Aitu.’ ” ");
INSERT INTO mnv_vpl VALUES ("MT24_1","070_24_1","MAT","24","1","1","Ko Jesus noko hinaiho i te potu tapu o te Hage Tapu, o haka tu'u ke hano, ma te boo atu kinai ona pegea haka ako, o tuiaki kinai na goosinga o te Hage Tapu. ");
INSERT INTO mnv_vpl VALUES ("MT24_2","070_24_2","MAT","24","2","2","Ma te haka anu atu a Jesus, “Koutou e hiina'i ki na me'a nei? Ko Au e gea maa'ogi kia te koutou: Kago he'e tau hatu ke go noko heketi ai, ko ba'i hatu e hai ke go seu ki gago.” ");
INSERT INTO mnv_vpl VALUES ("MT24_3","070_24_3","MAT","24","3","3","Nimaa noho a Jesus i te Ogo i Olives, na pegea haka ako noko boo soko ake kia te Ia, o haka anu 'aki atu kinai, “Hogahoga mai kia te kimatou, po tehea te 'aso kago hai ai na hai 'anga nei. Tehea ma'u te haka 'igonga o tou 'aso a'u ai ma te 'otinga o gago nei?” ");
INSERT INTO mnv_vpl VALUES ("MT24_4","070_24_4","MAT","24","4","4","Haka tau a Jesus o hai atu kia te kigatou, “Koutou na'ana'a atu, ka ke go noka te goi he pegea kia te koutou. ");
INSERT INTO mnv_vpl VALUES ("MT24_5","070_24_5","MAT","24","5","5","Iteme'agaa kago 'eha pegea boomai i toku ingoa, o taki hai atu, ‘Tenei au te 'Agiki Taga'ia,’ kae kago 'eha pegea gogoi kinai. ");
INSERT INTO mnv_vpl VALUES ("MT24_6","070_24_6","MAT","24","6","6","Koutou kago noko haka gongo ki na sagatau'a, ma te go noko gongo hegeunga i ni sagatau'a, kae ogo noka tautou matataku, na hai 'anga nei e hai ke go hetae mai, ka te 'otinga o ba'i me'a koi he'e hetae mai. ");
INSERT INTO mnv_vpl VALUES ("MT24_7","070_24_7","MAT","24","7","7","Na henua e hai ke go noko he 'atua 'aki ma gaa henua. Ko ba'i kakai 'anga hai hakahua e hai ke go noko he taa 'aki. 'Eha kunga henua e hai ke go noko ongesau, ma te go noko o'i o'i. ");
INSERT INTO mnv_vpl VALUES ("MT24_8","070_24_8","MAT","24","8","8","Ka na hai 'anga nei ngatahi na haka tu'u sanga o na haka gongo songo o te hahine guea. ");
INSERT INTO mnv_vpl VALUES ("MT24_9","070_24_9","MAT","24","9","9","“Ka koutou kago haiga'a 'ia ma'u ke noko hai songo 'ia ma te taa ke mamate. Koutou e hai ke go he'e siahahai kinai na henua i te ghaghi ia te Au. ");
INSERT INTO mnv_vpl VALUES ("MT24_10","070_24_10","MAT","24","10","10","Na 'aso na, e 'eha pegea kago boo 'aatea i tegatou too kia te Au, kae he haka soko 'aki ma te he'e he siahahai 'aki. ");
INSERT INTO mnv_vpl VALUES ("MT24_11","070_24_11","MAT","24","11","11","Kae 'eha taauga gogoi ka go sosopo mai o gogoi ki te 'apitanga. ");
INSERT INTO mnv_vpl VALUES ("MT24_12","070_24_12","MAT","24","12","12","I te hanau a na hai 'anga songo, e 'eha pegea kago gogohi ogatou ma'ine. ");
INSERT INTO mnv_vpl VALUES ("MT24_13","070_24_13","MAT","24","13","13","Ka koai kago tu'u o ma'u o hano ano hetae ki te 'otinga, tenaa ia e hai ke go sao. ");
INSERT INTO mnv_vpl VALUES ("MT24_14","070_24_14","MAT","24","14","14","Ka te Gongo Gaoi o te Hakahua 'anga a te 'Aitu, e hai kego tohi'aki ai ki ba'i kunga i gago nei, ke haka 'agi ki ba'i kungaa henua. 'Io mugi o hetae mai te 'otinga o gago nei. ");
INSERT INTO mnv_vpl VALUES ("MT24_15","070_24_15","MAT","24","15","15","“Ka te 'aso kago hiina'i ai koutou ki te me'a songo to'a e baghaghi ai na hai 'anga he'e gaoi nei e tu'u i te kunga tapu, noko gea kinai te taauga ia Daniel. Tuku te pegea haka sahe, ke na'a gaoi eia. ");
INSERT INTO mnv_vpl VALUES ("MT24_16","070_24_16","MAT","24","16","16","Kae na pegea e i Judea ke he 'agiko ki na ogo. ");
INSERT INTO mnv_vpl VALUES ("MT24_17","070_24_17","MAT","24","17","17","Noka te tuku he pegea noho i mo'ona he tu'aa hage ke iho o to'o ni me'a i te hage. ");
INSERT INTO mnv_vpl VALUES ("MT24_18","070_24_18","MAT","24","18","18","Noka te tuku he pegea manga i tena 'umanga ke hoki o to'o tena ake. ");
INSERT INTO mnv_vpl VALUES ("MT24_19","070_24_19","MAT","24","19","19","Kago haka 'aagogoha toto'a na haahine hai tama ma na haahine haa uu tama giki i na 'ao na! ");
INSERT INTO mnv_vpl VALUES ("MT24_20","070_24_20","MAT","24","20","20","Taakunga atu ke go noka te hai tautou he 'agikonga nei i na 'aso gogohi po i te 'Ao oki oki. ");
INSERT INTO mnv_vpl VALUES ("MT24_21","070_24_21","MAT","24","21","21","Iteme'agaa na hu'ai sanga songo i na 'aso na, noko he'e kitea ni sanga songo konei na noho, haka tu'u mai i te hakatu'u sanga noko gosigosi ai e te 'Aitu a gago nei, o hetae mai ki te gholoba nei. Kago he'e konei na noho ma'u i ni 'aso mugi mai. ");
INSERT INTO mnv_vpl VALUES ("MT24_22","070_24_22","MAT","24","22","22","Ka poi he'e toghi toghi e te 'Aitu na 'aso na ke pupulu, ka he'e tau pegea ogataki. Ka i te ghaghinga i ona pegea kua 'oti i te haka pau, na 'aso na ka go hai kego pupulu. ");
INSERT INTO mnv_vpl VALUES ("MT24_23","070_24_23","MAT","24","23","23","Na 'aso na, nimaa hai atu ai he pegea kia te koutou, ‘Hiina'i mai, tenei te 'Agiki Taga'ia!’ poe hai atu, ‘Hiina'i atu, na'e tegaa!’ ogo noka tautou too kinai. ");
INSERT INTO mnv_vpl VALUES ("MT24_24","070_24_24","MAT","24","24","24","E hai ke go boomai ni pegea gogoi, ogo noko taki hai atu, ‘Tenei au te Christ, te 'Agiki Taga'ia.’ Go boomai ma'u ni taauga gogoi ogo noko hai haka 'igonga, ma te hai ni me'a haingata'a, ke go pake ai na pegea na 'oti i te haka pau, i te poi haingaohie. ");
INSERT INTO mnv_vpl VALUES ("MT24_25","070_24_25","MAT","24","25","25","He na'ana'a 'aki atu, na'e kua 'oti i te mataa hogahoga e Au kia te koutou. ");
INSERT INTO mnv_vpl VALUES ("MT24_26","070_24_26","MAT","24","26","26","“Ka nimaa go hai atu he pegea kia te koutou, ‘Hiina'i atu, te 'Agiki Taga'ia manga i te kunga tugatea!’ 'Ogo noka tautou boo kinai. Poe hai atu, ‘Tenei te 'Agiki Taga'ia te manga i goto i na potu hage!’ 'Ogo noka tautou too kinai. ");
INSERT INTO mnv_vpl VALUES ("MT24_27","070_24_27","MAT","24","27","27","Iteme'agaa te hokimai o te Hosa o Pegea, e hai ke go noho po te 'uiga, e kemo i matangi o hiina'i ma'u kinai te potu gago. ");
INSERT INTO mnv_vpl VALUES ("MT24_28","070_24_28","MAT","24","28","28","Tehea te kunga e teka ai he tino mo'o he me'a mate, kago haka putu kinai na manu kai me'a mamate. ");
INSERT INTO mnv_vpl VALUES ("MT24_29","070_24_29","MAT","24","29","29","“Mugi i te sanga songo o na 'ao na o ghali o sigi, ‘te ga'aa e hai ke go poo'ugi, kae kago he'e maagama ai te maahina. Na hetu'u e hai ke go hetoki iho mai te gangi, ma ba'i me'a i te gangi e hai ke go o'i o'i ngatahi.’ ");
INSERT INTO mnv_vpl VALUES ("MT24_30","070_24_30","MAT","24","30","30","I te gholoba na, te haka 'igonga o te Hosa o Pegea e hai ke go sopo i te 'agohi gangi. Ko ba'i 'atuhenua o te kege nei kago magegepe. Ko kigatou e hai ke go hiina'i ki te Hosa o Pegea e hai ke go a'u i na po'ao o te 'agohi gangi ma ona taganga ma tona hu'ai mamagunga. ");
INSERT INTO mnv_vpl VALUES ("MT24_31","070_24_31","MAT","24","31","31","Ko Ia e hai ke go haka to'o mai ona ensel ma te hu'ai baa gongo. Na ensel e hai kigatou go haka putu mai 'ia ona pegea haka pau i te toka haa pa'asi o gago nei, haka tu'u mai i tegaa pa'asi o gago nei o hetae ki tegaa pa'asi. ");
INSERT INTO mnv_vpl VALUES ("MT24_32","070_24_32","MAT","24","32","32","“Na'a ake te hai 'anga nei i te ga'akau e mate te ‘fig’. Te gholoba e motomoto ai ona ga'a kae somosomo ai ona gau, e na'a e koutou e hitaiaki ke mahana na henua. ");
INSERT INTO mnv_vpl VALUES ("MT24_33","070_24_33","MAT","24","33","33","Manga konei na noho ma'u, na 'aso kago hai ai na hai 'anga nei o hiina'i kinai koutou, e hai ke go na'a ai e koutou toku 'aso hokimai kua hitaiaki, kua hu'ai napi. ");
INSERT INTO mnv_vpl VALUES ("MT24_34","070_24_34","MAT","24","34","34","Ko Au e gea maa'ogi kia te koutou: Te 'atu tangata nei kago noko noho 'aki, kae hai na hai 'anga nei. ");
INSERT INTO mnv_vpl VALUES ("MT24_35","070_24_35","MAT","24","35","35","Ko te gangi ma te kege nei e hai ke go haka masogo, ka aku haka hegeunga kago he'e haka masogo. ");
INSERT INTO mnv_vpl VALUES ("MT24_36","070_24_36","MAT","24","36","36","“E si'ai he pegea na'a eia te 'ao na, po te gholoba na. E he'e na'a ma'u e na ensel i te gangi. E he'e na'a ma'u e te Hosa, ka manga na'a launatasi e te Tamana. ");
INSERT INTO mnv_vpl VALUES ("MT24_37","070_24_37","MAT","24","37","37","Te a'u 'anga te Hosa o Pegea, e hai ke go noho ki nia noko hai i na 'aso o Noah. ");
INSERT INTO mnv_vpl VALUES ("MT24_38","070_24_38","MAT","24","38","38","Na 'aso noko manga koi he'e laghe ai, ko pegea noko manga kai, ma te bibinu, ma te taka a taangata ma haahine, hano ano hetae ki te gholoba na hano ai a Noah ki goto i te ‘ark’. ");
INSERT INTO mnv_vpl VALUES ("MT24_39","070_24_39","MAT","24","39","39","Ka ko ba'i pegea noko he'e na'a e kigatou, nia te hai kego hai, hano ano a'u te laghe 'anga o to'o ia te kigatou ngatahi. E hai ke go konaa na noho ma'u te a'u 'anga te Hosa o Pegea. ");
INSERT INTO mnv_vpl VALUES ("MT24_40","070_24_40","MAT","24","40","40","Kago iai te toka gua taangata i te 'umanga i te 'aso na, kago kakabe 'ia tegaa kae ti'aki tegaa. ");
INSERT INTO mnv_vpl VALUES ("MT24_41","070_24_41","MAT","24","41","41","Kago iai te toka gua haahine e ogo witi i te kunga e tasi, kago kakabe 'ia tegaa, kae ti'aki tegaa. ");
INSERT INTO mnv_vpl VALUES ("MT24_42","070_24_42","MAT","24","42","42","“Tenei te hai 'anga e hai koutou na'ana'a ai, iteme'agaa e he'e na'a e koutou po tehea te 'ao kago a'u ai te Hakahua o 'outou. ");
INSERT INTO mnv_vpl VALUES ("MT24_43","070_24_43","MAT","24","43","43","Kae hai ke na'a e koutou te hai 'anga nei: Te pegea e hai tona hage, poi na'a eia tehea te gholoba i te poo e hai ke go a'u ai te pegea kaia'a, koia manga na'ana'a kinai, o he'e tuku tena hage ke tuki e te pegea kaia'a o mene ki goto. ");
INSERT INTO mnv_vpl VALUES ("MT24_44","070_24_44","MAT","24","44","44","Koutou e hai ke ngaague ma'u, iteme'agaa te Hosa o Pegea, kago a'u i he gholoba he'e tegeu'a ake koutou ka a'u ai. ");
INSERT INTO mnv_vpl VALUES ("MT24_45","070_24_45","MAT","24","45","45","“Koai gaa te guani kago maa'ogi ma te 'igo'igo? Tenaa ia e hai ke go tuku e tena hakahua ke go ge'o eia tena hage, kego noko haangai ia te kigatou i na 'aso haka pau. ");
INSERT INTO mnv_vpl VALUES ("MT24_46","070_24_46","MAT","24","46","46","Kago gaoi to'a ki te guani i te 'aso kago hoki mai ai tena hakahua o kite koia manga hai eia na hai 'anga nei. ");
INSERT INTO mnv_vpl VALUES ("MT24_47","070_24_47","MAT","24","47","47","Ko Au e gea maa'ogi kia te koutou: Kago tuku e tena hakahua ia te ia, o hakahua ba'i me'a a'ana. ");
INSERT INTO mnv_vpl VALUES ("MT24_48","070_24_48","MAT","24","48","48","Ka te guani nimaa koia te guani hai hai 'anga songo, kae hai ake ma'ana he tegeu'a, ‘Toku hakahua ka taka goa.’ ");
INSERT INTO mnv_vpl VALUES ("MT24_49","070_24_49","MAT","24","49","49","Kae haka tu'u kogu kogaa i na guani, kae kai, ma te binu haka pigi ki na pegea hai tegatou hai 'anga bibinu waeni. ");
INSERT INTO mnv_vpl VALUES ("MT24_50","070_24_50","MAT","24","50","50","Te hakahua o te guani nei, kago hokimai i he 'ao he'e tagisaki ai, po i he gholoba he'e na'a eia. ");
INSERT INTO mnv_vpl VALUES ("MT24_51","070_24_51","MAT","24","51","51","Te hakahua kago tuku ni hu'ai kagohia ki tena guani, ma te tuku haka pigi ia te ia ki na pegea haka hagehage i te kunga kagohia go noko tangi ma te he taangisi 'aki ai na niho. ");
INSERT INTO mnv_vpl VALUES ("MT25_1","070_25_1","MAT","25","1","1","“Te 'aso na, te Hakahua 'anga a te 'Aitu kago papata ki te katoa haahine taupopo'ou, noko to'o agatou peba o boo kigatou sasa'o ki te tangata e hai uguugu ho'ou. ");
INSERT INTO mnv_vpl VALUES ("MT25_2","070_25_2","MAT","25","2","2","Ka noko iai te toka gima ia te kigatou noko he noanoa 'aki, kae he 'igo'igo 'aki tegaa toka gima. ");
INSERT INTO mnv_vpl VALUES ("MT25_3","070_25_3","MAT","25","3","3","Na haahine he noanoa 'aki, noko to'o agatou peba, ka noko he'e to'o ni 'oela ke ge'o ai. ");
INSERT INTO mnv_vpl VALUES ("MT25_4","070_25_4","MAT","25","4","4","Ka te toka gima noko he 'igo'igo 'aki, te na to'o na 'oela i na poati ke ge'o ai agatou peba. ");
INSERT INTO mnv_vpl VALUES ("MT25_5","070_25_5","MAT","25","5","5","Ma te ngese mai te tangata hai uguugu ho'ou, ko kigatou na he tugi momoe 'aki ano, manga momoe. ");
INSERT INTO mnv_vpl VALUES ("MT25_6","070_25_6","MAT","25","6","6","“Nimaa i te tu'u gua poo, kae sopo te ngege 'anga: ‘Tenei te tangata hai uguugu ho'ou! Boo atu koutou bilaabei!’ ");
INSERT INTO mnv_vpl VALUES ("MT25_7","070_25_7","MAT","25","7","7","“Ma te a'aga te katoa haahine taupopo'ou o gosigosi agatou peba. ");
INSERT INTO mnv_vpl VALUES ("MT25_8","070_25_8","MAT","25","8","8","Ma te hai atu na haahine noko he noanoa 'aki ki na haahine noko he 'igo'igo 'aki, ‘ 'Aumai ma'a maatou ni 'oela 'ia 'autou, na'e a maatou peba kua masa.’ ");
INSERT INTO mnv_vpl VALUES ("MT25_9","070_25_9","MAT","25","9","9","“Ma te haka tau atu na haahine noko he 'igo'igo 'aki, ‘Si'ai, ka he'e 'aonga kia te kitatou ngatahi. Boo atu ki na pegea manga tau'i 'oela kinai, o tau'i ai ma'autou 'ini.’ ");
INSERT INTO mnv_vpl VALUES ("MT25_10","070_25_10","MAT","25","10","10","“Ka te gholoba na boo ai kigatou ke tau'i 'oela, te tangata hai uguugu ho'ou na hetae mai. Na haahine noko ngaague, na tata'o ia te ia ki goto ki te haka tahinga ki te takanga ho'ou. Kae titingi te aga. ");
INSERT INTO mnv_vpl VALUES ("MT25_11","070_25_11","MAT","25","11","11","“Nimaa mugi kogaa haahine taupopo'ou o boomai o hai ake, ‘Hakahua, hakahua! Luga mai te aga kia te kimatou!’ ");
INSERT INTO mnv_vpl VALUES ("MT25_12","070_25_12","MAT","25","12","12","“Ka koia na haka tau iho, ‘Koau e gea maa'ogi kia te koutou: E he'e na'a eau ia te koutou.’ ");
INSERT INTO mnv_vpl VALUES ("MT25_13","070_25_13","MAT","25","13","13","“Tenei te hai 'anga e hai koutou noko he na'ana'a 'aki ai, iteme'agaa e he'e na'a e koutou te 'ao po te gholoba. ");
INSERT INTO mnv_vpl VALUES ("MT25_14","070_25_14","MAT","25","14","14","“Te Hakahua 'anga a te 'Aitu, manga papata ma'u ki te tangata hano ke noko sehu. Noko haka putu mai ona guani, o tuha kinai ana mane. ");
INSERT INTO mnv_vpl VALUES ("MT25_15","070_25_15","MAT","25","15","15","Noko 'abange te gimanga noa (5,000) mane ki tegaa guani, kae 'abange te guanga noa (2,000) mane ki tegaa guani, kae 'abange ma'u te noa (1,000) mane ki tegaa guani. Noko manga taki 'abange haka papata ki nia e na'a te hai e kigatou, kae hano. ");
INSERT INTO mnv_vpl VALUES ("MT25_16","070_25_16","MAT","25","16","16","Te tangata noko ga'u eia te gimanga noa, na hano o hai hekau ai ano sopo ma'u tegaa gimanga noa. ");
INSERT INTO mnv_vpl VALUES ("MT25_17","070_25_17","MAT","25","17","17","Noko konaa na hai ma'u te tangata noko ga'u eia te guanga noa. Koia noko hai hekau ai ano sopo kinai tegaa guanga noa. ");
INSERT INTO mnv_vpl VALUES ("MT25_18","070_25_18","MAT","25","18","18","Ka te tangata noko ga'u eia te noa mane, na hano o kegi eia te gua i te kege o huu ai na mane a tena hakahua. ");
INSERT INTO mnv_vpl VALUES ("MT25_19","070_25_19","MAT","25","19","19","“Na taunga gogoa te hano 'anga te hakahua o na guani, ka na hokimai o haka tinogaoi ana mane kia te kigatou. ");
INSERT INTO mnv_vpl VALUES ("MT25_20","070_25_20","MAT","25","20","20","Te tangata noko ga'u eia te gimanga noa, noko to'o ake eia tegaa gimanga noa. Kae hai atu, ‘Hakahua, noko tuku e koe kia te au te gimanga noa, kae ina mai, kua beegaba eau i tegaa gimanga noa’. ");
INSERT INTO mnv_vpl VALUES ("MT25_21","070_25_21","MAT","25","21","21","Ma te haka tau kinai tona hakahua, ‘Gaoi! Ko koe te guani gaoi ma te maa'ogi. Ko koe kua hai hekau maa'ogi i na mi'i hai 'anga, kae hai kau tuku 'ia ia te koe ke hakahua i na hu'ai hai 'anga. A'u o 'aabaki i te siasia o te hakahua o'ou.’ ");
INSERT INTO mnv_vpl VALUES ("MT25_22","070_25_22","MAT","25","22","22","“Te tangata noko ga'u eia te guanga noa, noko hinake o hai atu, ‘Hakahua, noko tuku e koe kia te au te guanga noa, kae ina mai, kua beegaba eau i tegaa guanga noa mane.’ ");
INSERT INTO mnv_vpl VALUES ("MT25_23","070_25_23","MAT","25","23","23","“Ma te haka tau kinai tona hakahua, ‘Gaoi! Ko koe te guani gaoi ma te maa'ogi, ko koe kua hai hekau maa'ogi i na mi'i hai 'anga, kae hai kau tuku 'ia ia te koe ke hakahua i na hu'ai hai 'anga. A'u o 'aabaki i te siasia o te hakahua o'ou!’ ");
INSERT INTO mnv_vpl VALUES ("MT25_24","070_25_24","MAT","25","24","24","“Ma te mugi ake te tangata noko ga'u eia te noa mane, o hai atu, ‘Hakahua, 'e na'a eau ko koe te pegea hai hakahuahua, manga utu e koe na me'a he'e sanga e koe ma te haka putu e koe na me'a he'e lago e koe. ");
INSERT INTO mnv_vpl VALUES ("MT25_25","070_25_25","MAT","25","25","25","Ka koau na mataku, ma te hano au o huu au mane i te kege. Ina mai, konei au mane.’ ");
INSERT INTO mnv_vpl VALUES ("MT25_26","070_25_26","MAT","25","26","26","“Hakatau kinai tena hakahua o hai atu, ‘Ko koe te guani lologi, hai hai 'anga songo. Kae na'a e koe ko au manga utu eau nia e he'e sanga eau, ma te haka putu eau nia e he'e lago eau? ");
INSERT INTO mnv_vpl VALUES ("MT25_27","070_25_27","MAT","25","27","27","Manga gaoi, noko gaoi i te poi to'o e koe aku mane o tuku ki te hage pipiki mane, ke nimaa go hokimai au hai kau go to'o haka hoki 'ia aku mane, ma he me'a beegaba kinai. ");
INSERT INTO mnv_vpl VALUES ("MT25_28","070_25_28","MAT","25","28","28","“ ‘Sa'u atu te noa mane ia te ia, o 'abange ki te pegea kua ga'u eia te katoa noa mane. ");
INSERT INTO mnv_vpl VALUES ("MT25_29","070_25_29","MAT","25","29","29","Iteme'agaa ko ba'i pegea ga'u o hai gosigosi, e hai ke go 'abange beegaba, ko kigatou e hai ke go ga'u o 'eha. Ka koai e ga'u o he'e hai gaoi, he'e pote mi'i ga'unga kua ga'u eia, e hai ke go sa'u 'aatea ia te ia. ");
INSERT INTO mnv_vpl VALUES ("MT25_30","070_25_30","MAT","25","30","30","Kae tupe atu te guani he'e tau hai 'anga na, ki te poo'uginga o haho ki te kunga tatangi ma te he taangisi 'aki na niho.’ ");
INSERT INTO mnv_vpl VALUES ("MT25_31","070_25_31","MAT","25","31","31","“Te 'aso kago a'u ai te Hosa o Pegea ma tona mamagunga, kago haka pata kinai te 'apitanga o na ensel o 'Ona, ko Ia e hai ke go noho i tona noohonga mamagunga. ");
INSERT INTO mnv_vpl VALUES ("MT25_32","070_25_32","MAT","25","32","32","Na 'atuhenua e hai ke go haka putu mai ki 'ago ia te Ia. Kago tuhatuha ai e Ia te 'apitanga o pegea, ke noho pe na haka babae 'anga e na pegea ge'o sipisipi na sipisipi i na nane goti. ");
INSERT INTO mnv_vpl VALUES ("MT25_33","070_25_33","MAT","25","33","33","Ko Ia kago tuku na sipisipi ki Tena pa'asi maui, kae tuku na nane goti ki Tena pa'asi sema. ");
INSERT INTO mnv_vpl VALUES ("MT25_34","070_25_34","MAT","25","34","34","“Kae mugi a te Hakahua o hai atu kia te kigatou e noho 'aki i te pa'asi maui o 'Ona, ‘Boomai, na'e konaa koutou e haka gaoi e Tamau, o to'o 'autou ga'unga ma te noho 'aki i te nuku noko gosigosi kia te koutou mai te haka tu'u sanga o gago nei. ");
INSERT INTO mnv_vpl VALUES ("MT25_35","070_25_35","MAT","25","35","35","Iteme'agaa ko Au noko ongea, kae 'aumai e koutou aku utunga o kai. Sia binu au, 'aumai e koutou oku bai o binu. Oku 'aso taka tahea ai, manga hakapogo e koutou ia te Au. ");
INSERT INTO mnv_vpl VALUES ("MT25_36","070_25_36","MAT","25","36","36","He'e tau haka gogoo, haa mago e koutou ia te Au. Oku 'aso masaki, manga kumu koutou ia te Au. Oku 'aso noho ai i te kagohia, manga 'asi'asi e koutou ia te Au.’ ");
INSERT INTO mnv_vpl VALUES ("MT25_37","070_25_37","MAT","25","37","37","“Ka na pegea tinogaoi kago haka tau kia te Ia, ‘Hakahua, na 'aso hea te noko hiina'i ai kimatou kia te Koe, e ongea o haangai ia te Koe, poe sia binu o 'abatu ai e kimatou na bai kia te Koe o binu? ");
INSERT INTO mnv_vpl VALUES ("MT25_38","070_25_38","MAT","25","38","38","Na 'aso hea te noko hiina'i ai kimatou kia te Koe noko taka tahea ai o haka pogo ai ia te Koe ki omatou hage? Poe he'e tau haka gogoo ai koe o haa mago e kimatou ia te Koe? ");
INSERT INTO mnv_vpl VALUES ("MT25_39","070_25_39","MAT","25","39","39","Na 'aso hea te noko hiina'i ai kimatou kia te Koe, kae masaki poe kagohia o 'asi'asi ai e kimatou ia te Koe?’ ");
INSERT INTO mnv_vpl VALUES ("MT25_40","070_25_40","MAT","25","40","40","“Te Hakahua e hai ke go konei ana haka tau, ‘Koau e gea maa'ogi kia te koutou: Nimaa iai ni hai 'anga hai e koutou ki he mi'i pegea i na pegea kua too kia te Au nei, e hai e koutou kia te Au.’ ");
INSERT INTO mnv_vpl VALUES ("MT25_41","070_25_41","MAT","25","41","41","“Kae hai atu te Hakahua ki na pegea e noho 'aki i te pa'asi sema o 'Ona, ‘Koutou boo atu ia te Au, koutou kua haka pau kego kago kinai a te 'Aitu i te ahi noho goa noko haka ngaague kia Satan ma ona ensel. ");
INSERT INTO mnv_vpl VALUES ("MT25_42","070_25_42","MAT","25","42","42","Iteme'agaa ko Au noko ta'anga ongea, kae he'e 'aumai e koutou ma'aku ni utunga ke kai. Nimaa sia binu Au, he'e 'aumai e koutou mo'oku ni bai ke binu. ");
INSERT INTO mnv_vpl VALUES ("MT25_43","070_25_43","MAT","25","43","43","Oku 'aso taka tahea ai noko he'e haka pogo e koutou ia te Au ki outou hage. Oku 'aso siahai mo'oku ni haka gogoo, noko he'e haa mago e koutou ia te Au. Oku 'aso masaki ma te noho ai i te kagohia, noko he'e maataki e koutou ia te Au.’ ");
INSERT INTO mnv_vpl VALUES ("MT25_44","070_25_44","MAT","25","44","44","“Ko kigatou kago haka tau ma'u o hai atu, ‘Hakahua, na 'aso hea te noko hiina'i ai kimatou kia te Koe kae ongea, poe sia binu, poe taka tahea, poe sia hai haka gogoo, poe masaki, poe noho i te kagohia, ka manga he'e 'aabaki kimatou kia te Koe?’ ");
INSERT INTO mnv_vpl VALUES ("MT25_45","070_25_45","MAT","25","45","45","“Ko Ia kago konei ana haka tau, ‘Ko Au e gea maa'ogi kia te koutou: Nia e he'e hai e koutou ki he mi'i pegea i na pegea o'oku nei, e he'e hai e koutou kia te Au.’ ");
INSERT INTO mnv_vpl VALUES ("MT25_46","070_25_46","MAT","25","46","46","“Ko kigatou nei e hai ke go tuku ke boo 'aatea ki te kagohia noho goa, ka na pegea tinogaoi e hai ke go boo ki te ma'ugi noho goa.” ");
INSERT INTO mnv_vpl VALUES ("MT26_1","070_26_1","MAT","26","1","1","Te gholoba na 'oti i te gea ai a Jesus i na hai 'anga nei, ko Ia noko hai atu ki ona pegea haka ako, ");
INSERT INTO mnv_vpl VALUES ("MT26_2","070_26_2","MAT","26","2","2","“Manga na'a e koutou, te kainga o te Passover e toe kinai te toka gua 'ao, ka ke tuku 'ia te Hosa o Pegea ke go taa 'ia.” ");
INSERT INTO mnv_vpl VALUES ("MT26_3","070_26_3","MAT","26","3","3","Ka na hakahua o na priest ma na hutiaki o na Jew noko haka putu ki te hu'ai hage o te hakahua o na priest, tena ingoa ko Caiaphas. ");
INSERT INTO mnv_vpl VALUES ("MT26_4","070_26_4","MAT","26","4","4","O puge soko kigatou ke go manga he 'osohi huu kia Jesus, kigatou taa 'ia. ");
INSERT INTO mnv_vpl VALUES ("MT26_5","070_26_5","MAT","26","5","5","Ka ko kigatou noko hai ake ke noka te hai 'ia i na gholoba manga koi hai ai te haka tahinga, na'e kitai go huhu ai te 'apitanga. ");
INSERT INTO mnv_vpl VALUES ("MT26_6","070_26_6","MAT","26","6","6","Te gholoba noko manga noho ai a Jesus i Bethany, i te hage o te tangata noko na'a 'ia ko Simon noko kahoa. ");
INSERT INTO mnv_vpl VALUES ("MT26_7","070_26_7","MAT","26","7","7","Hinake kinai te hahine ma te poati bai hugu tena ingoa te alabasta 'eha to'a tena mane, o gigingi e ia ki te 'ugu o Jesus noko manga loghoni ki te kaupea kai. ");
INSERT INTO mnv_vpl VALUES ("MT26_8","070_26_8","MAT","26","8","8","Te 'aso na hiina'i ai na pegea haka ako ki te hai 'anga nei, ko kigatou na haka tangi 'aki ai. Ko kigatou noko haka anu 'aki atu, “ 'Eaa e maumau ai? ");
INSERT INTO mnv_vpl VALUES ("MT26_9","070_26_9","MAT","26","9","9","Te bai hugu nei, e gaoi i te tuku ke tau'i ke 'eha o na mane, ke haiga'a ki na pegea lae.” ");
INSERT INTO mnv_vpl VALUES ("MT26_10","070_26_10","MAT","26","10","10","Ko Jesus noko na'a e Ia nia te noko manga gegea kinai kigatou, ma te hai atu kia te kigatou, “ 'Eaa e haka patu'a ai e koutou te hahine nei? E hai e ia te hai 'anga gaoi to'a kia te Au. ");
INSERT INTO mnv_vpl VALUES ("MT26_11","070_26_11","MAT","26","11","11","Na pegea lae ka noko haka pata kia te koutou i ba'i 'aso, ka ko Au ka he'e haka pata goa kia te koutou. ");
INSERT INTO mnv_vpl VALUES ("MT26_12","070_26_12","MAT","26","12","12","Te gholoba e gigingi ai e ia te bai hugu ki toku tino, e haka ngaague eia toku tino ke go tanu. ");
INSERT INTO mnv_vpl VALUES ("MT26_13","070_26_13","MAT","26","13","13","Ko Au e gea maa'ogi kia te koutou: Kohea ma'u na kunga i gago nei kago noko tohi'aki ai i te Gongo Gaoi nei, kago noko hogahoga nia kua hai e te hahine nei, ke go noko maanatu ai ia te ia ma'u.” ");
INSERT INTO mnv_vpl VALUES ("MT26_14","070_26_14","MAT","26","14","14","'Io mugi a Judas Iscariot, te pegea i te katoa tuma'a e gua pegea haka ako, o hano ki na hakahua o na priest, ");
INSERT INTO mnv_vpl VALUES ("MT26_15","070_26_15","MAT","26","15","15","o haka anuanu kia te kigatou, “Niaa kago 'aumai e koutou ma'aku, i te poi haiga'a eau ia Jesus kia te koutou?” Ma te haka sahe e kigatou te katoa haka togu mane silver o 'abange kia te ia. ");
INSERT INTO mnv_vpl VALUES ("MT26_16","070_26_16","MAT","26","16","16","Haka tu'u i te gholoba na, ko Judas noko manga mata eia he gholoba tautau gaoi ke haiga'a ai e ia ia Jesus. ");
INSERT INTO mnv_vpl VALUES ("MT26_17","070_26_17","MAT","26","17","17","I te 'ao mu'a o te haka tahinga a na Jew e ingoa te Passover, ta'anga kai ai na bred he'e tau me'a haka tupu utunga, na pegea haka ako noko boo ake kia Jesus o haka anu atu kinai, “Tehea te kunga e siahai Koe kimatou ngaague 'ia ke go kai ai Koe i te kainga o te Passover?” ");
INSERT INTO mnv_vpl VALUES ("MT26_18","070_26_18","MAT","26","18","18","Ma te haka tau atu a Jesus, “Boo atu ki goto i te hu'ai manaha o boo ki te pegea kua haka pau e Au o hai atu kia te ia, ‘Te Ako e hai mai: Kua hitaiaki te 'aso noko haka pau kia te Au ka ko Au e hai kau mahi haka pigi ki oku pegea haka ako i te kainga o te Passover i tou hage.’ ” ");
INSERT INTO mnv_vpl VALUES ("MT26_19","070_26_19","MAT","26","19","19","Gua pegea haka ako na hai e kigaaua nia noko gea ai a Jesus kia te kigaaua, o ngaague e kigaaua te kainga o te Passover. ");
INSERT INTO mnv_vpl VALUES ("MT26_20","070_26_20","MAT","26","20","20","Nimaa i te ahiahi kae noho 'aki a Jesus ma tena katoa tuma'a e gua pegea haka ako ki te kaupea. ");
INSERT INTO mnv_vpl VALUES ("MT26_21","070_26_21","MAT","26","21","21","Nimaa i te gholoba noko manga kai ai kigatou, hai atu Ia, “Ko Au e gea maa'ogi kia te koutou: E iai te launatasi ia te koutou ka haka soko e ia ia te Au.” ");
INSERT INTO mnv_vpl VALUES ("MT26_22","070_26_22","MAT","26","22","22","Ko kigatou na hu'ai 'agogoha, o manga taki hakaanu 'aki atu, “He'e ko au 'ine, Hakahua?” ");
INSERT INTO mnv_vpl VALUES ("MT26_23","070_26_23","MAT","26","23","23","Ma te haka tau atu a Jesus, “Te pegea kua gogomi te gima ki te besini ma to 'Oku, tenaa ia kago haka soko e ia ia te Au. ");
INSERT INTO mnv_vpl VALUES ("MT26_24","070_26_24","MAT","26","24","24","Te Hosa o Pegea e hai ke go hano o papata ki nia noko gea ai na Kanukanu Tapu ia te Ia, kae haka 'aagoha te pegea kago haka soko eia te Hosa o Pegea. Noko gaoi i te poi he'e haka haa a ia.” ");
INSERT INTO mnv_vpl VALUES ("MT26_25","070_26_25","MAT","26","25","25","Ka ko Judas, noko hai ke haka soko ia Jesus, noko hai atu, “He'e ko au, Ako?” Ma te haka tau atu a Jesus, “ 'Oo, ko koe.” ");
INSERT INTO mnv_vpl VALUES ("MT26_26","070_26_26","MAT","26","26","26","Te gholoba noko manga kai ai kigatou, noko sa'u ake e Jesus te bred o haka 'aue ai, kae tohitohi o haiga'a ki ona pegea haka ako, kae hai atu, “Sa'u atu o kai, na'e tenei toku tino.” ");
INSERT INTO mnv_vpl VALUES ("MT26_27","070_26_27","MAT","26","27","27","Kae sa'u mai ma'u e Ia te waeni i te kapu o haka 'aue ai kae haiga'a kia te kigatou, kae hai atu, “Koutou bibinu ngatahi ake ai. ");
INSERT INTO mnv_vpl VALUES ("MT26_28","070_26_28","MAT","26","28","28","Tenei toku toto e singa ke go he tu'utaki 'aki ai a te 'Aitu ma ba'i pegea. E singa ki te 'apitanga ke haka noka na 'oosongo. ");
INSERT INTO mnv_vpl VALUES ("MT26_29","070_26_29","MAT","26","29","29","Ko Au e hai atu kia te koutou, haka tu'u i te 'aso nei o hano, ko Au ka he'e binu i te hua o te kaubago haka hoki o hano ano hetae ki te 'ao e hai kau go binu waeni haka pigi haka hoki ai kia te koutou i te nuku manga hakahua ai a Tamau.” ");
INSERT INTO mnv_vpl VALUES ("MT26_30","070_26_30","MAT","26","30","30","Te gholoba na taugua ai kigatou i te taugua ogiogi o 'oti, kae boo ki te Ogo i Olives. ");
INSERT INTO mnv_vpl VALUES ("MT26_31","070_26_31","MAT","26","31","31","Kae hai atu a Jesus kia te kigatou, “Te poo nei koutou ngatahi ka ti'aki ia te Au kae he 'agiko. Iteme'agaa na 'oti i te gea kinai na Kanukanu Tapu: ‘E hai kau go taa 'ia te pegea ge'o sipisipi ka ke go taki he'agiko na sipisipi.’ ");
INSERT INTO mnv_vpl VALUES ("MT26_32","070_26_32","MAT","26","32","32","Ka te gholoba kago ma'ugi hoki ai Au, e hai kau go mu'a ia te koutou ki Galilee.” ");
INSERT INTO mnv_vpl VALUES ("MT26_33","070_26_33","MAT","26","33","33","Ma te haka tau kinai a Peter o hai atu, “Masi'igoa ko kigatou ngatahi kago boo 'aatea ia te Koe, ka ko au kago he'e hano ia te Koe.” ");
INSERT INTO mnv_vpl VALUES ("MT26_34","070_26_34","MAT","26","34","34","Haka tau kinai a Jesus o hai atu, “Ko Au e gea maa'ogi atu kia te koe: Te poo nei 'io mugi te paolo o tangi, ko koe Peter kua 'oti te haka si'ai haka togu e koe ia te Au.” ");
INSERT INTO mnv_vpl VALUES ("MT26_35","070_26_35","MAT","26","35","35","Ka ko Peter noko pau o haka sukisuki atu, “Masi'igoa ko au kago mate haka pigi kia te Koe, ka kago he'e 'aonga te haka si'ai eau ia te Koe.” Kogaa pegea haka ako noko konei agatou gegea ma'u. ");
INSERT INTO mnv_vpl VALUES ("MT26_36","070_26_36","MAT","26","36","36","Kae boo a Jesus ma ona pegea haka ako ki te kunga noko mate ko Gethsemane, o hai atu a Ia kia te kigatou, “Noho 'aki iho i te kunga nei i te gholoba e hano ai au kau taakunga.” ");
INSERT INTO mnv_vpl VALUES ("MT26_37","070_26_37","MAT","26","37","37","Kakabe e Ia ia Peter ma gua hosa o Zebedee o tata'o ia te Ia, kae haka tu'u tena 'agoha to'a 'anga ma tena tiha'ia. ");
INSERT INTO mnv_vpl VALUES ("MT26_38","070_26_38","MAT","26","38","38","Ma te hai atu a Jesus kia te kigatou, “Toku uso e mamaha i te 'agoha to'a manga sa'akigoa ko Au ka mate. Koutou noho 'aki iho i te kunga nei, o mata haka pigi kia te Au.” ");
INSERT INTO mnv_vpl VALUES ("MT26_39","070_26_39","MAT","26","39","39","Ko Jesus noko hano o makabaa, o too tuku na taungaa mata ki te kege o kogaa ana taakunga, “Tamau, nimaa haingaohie, sa'u 'aatea atu te kapu nei ia te Au. Kae ka he'e hai i na paaunga a'aku, ka i na paaunga a'Au.” ");
INSERT INTO mnv_vpl VALUES ("MT26_40","070_26_40","MAT","26","40","40","Nimaa hoki atu ki ona pegea haka ako, o kite ia te kigatou manga momoe, ma te hai atu kia Peter, “ 'Ai koutou 'okoia he'e 'aonga te mata haka pigi kia te Au i he mi'i gholoba e tasi? ");
INSERT INTO mnv_vpl VALUES ("MT26_41","070_26_41","MAT","26","41","41","Na'ana'a ake ma te taakunga, ka ke go noka tautou haa'oa ki na pakenga. Autou maanatu e mangangao ka outou tino e he lologi 'aki.” ");
INSERT INTO mnv_vpl VALUES ("MT26_42","070_26_42","MAT","26","42","42","Ko Jesus noko hano i te guanga gholoba o konei ana taakunga, “Tamau, te kapu nei nimaa haingata'a te sa'u 'aatea, kae pau Kau binu 'ia, ke manga hai nia e siahai Koe ke hai.” ");
INSERT INTO mnv_vpl VALUES ("MT26_43","070_26_43","MAT","26","43","43","Te gholoba noko hoki mai ai a Jesus, kite haka hoki ia te kigatou manga momoe, iteme'agaa ko kigatou noko hu'ai sia momoe. ");
INSERT INTO mnv_vpl VALUES ("MT26_44","070_26_44","MAT","26","44","44","Ma te hoki a Jesus ia te kigatou o taakunga, tenei tena taakunga haka togu, manga gea i te me'a e tasi. ");
INSERT INTO mnv_vpl VALUES ("MT26_45","070_26_45","MAT","26","45","45","Ma te hoki a Jesus ki ona pegea haka ako o hai atu kia te kigatou, “Koutou koi momoe ma te okioki? Hiina'i atu, te gholoba kua hitaiaki. Te Hosa o Pegea e haka soko ki na taganga o na pegea 'oosongo. ");
INSERT INTO mnv_vpl VALUES ("MT26_46","070_26_46","MAT","26","46","46","Tutu'u ake kitatou boo! Tenaa te tangata e haka soko e ia ia te Au te a'u na!” ");
INSERT INTO mnv_vpl VALUES ("MT26_47","070_26_47","MAT","26","47","47","Te gholoba noko manga koi gea ai a Jesus, kae tatae kinai a Judas te pegea i te katoa tuma'a e gua pegea haka ako, ma te hu'ai tu'uganga, noko to'o mai agatou hu'ai kiba ma na ga'akau taa pegea. Ko kigatou noko hakato'o kinai e na hakahua o na Priest ma na 'agiki o na Jew. ");
INSERT INTO mnv_vpl VALUES ("MT26_48","070_26_48","MAT","26","48","48","Ko Judas na 'oti i te haka tinogaoi te haka 'igonga ki te tu'uganga: “Te pegea e sosongi ai au, tenaa te tangata; 'ogo he 'osohi atu kia te Ia.” ");
INSERT INTO mnv_vpl VALUES ("MT26_49","070_26_49","MAT","26","49","49","Ghali atu a Judas kia Jesus o hai atu kinai, “Gaoi, Ako!” kae sosongi atu ia te Ia. ");
INSERT INTO mnv_vpl VALUES ("MT26_50","070_26_50","MAT","26","50","50","Haka tau kinai a Jesus o hai atu, “Taku hemasi'inga, hai ake nia e a'u ai koe.” Ma te boo atu ki mu'a na taangata o he 'osohi kia Jesus o kakabe. ");
INSERT INTO mnv_vpl VALUES ("MT26_51","070_26_51","MAT","26","51","51","Te gholoba na, noko iai te pegea noko manga haka pata kia Jesus, na 'oso ki tena kiba o sa'u ake, o sabi momotu ai eia te taginga o te guani o te hakahua o na priest. ");
INSERT INTO mnv_vpl VALUES ("MT26_52","070_26_52","MAT","26","52","52","Ma te hai atu kinai a Jesus, “Tape haka hoki iho tau kiba ki tena tanga. Na pegea e hai kiba e hai ke go mamate ki na kiba. ");
INSERT INTO mnv_vpl VALUES ("MT26_53","070_26_53","MAT","26","53","53","'Ai e tegeu'a ake koutou, ko Au ka he'e 'aonga te haka ene kia Tamau he 'abakinga, ka ke manga hakato'o mai e Ia kia te Au he hu'ai tau'a ensel, o sigi i te katoa tuma'a e gua tu'uganga? ");
INSERT INTO mnv_vpl VALUES ("MT26_54","070_26_54","MAT","26","54","54","Ka manga konei na noho, ke haka maa'ogi ai na Kanukanu Tapu noko hai ake e hai ke go konei na noho.” ");
INSERT INTO mnv_vpl VALUES ("MT26_55","070_26_55","MAT","26","55","55","Ma te hai atu a Jesus ki te 'apitanga, “ 'Ai ko Au te pegea kaia'a, ka ke to'o mai autou kiba ma autou ga'akau taa pegea, ke labu ai ia te Au?! Ko ba'i 'aso ko Au manga noho ai i te potu i te Hage Tapu, o manga ako ai, ka noko he'e he 'osohi ai koutou kia te Au. ");
INSERT INTO mnv_vpl VALUES ("MT26_56","070_26_56","MAT","26","56","56","Ka manga konei na hai ke haka maa'ogi ai na Kanukanu Tapu noko hai e na taauga.” Ma te ti'aki e na pegea haka ako ia te Ia kae he 'agiko. ");
INSERT INTO mnv_vpl VALUES ("MT26_57","070_26_57","MAT","26","57","57","Na pegea noko he'osohi kia Jesus na kakabe e kigatou ia te Ia kia Caiaphas, te hakahua o na priest, noko haka putu kinai na ako o na tagangonga ma na 'agiki o na Jew. ");
INSERT INTO mnv_vpl VALUES ("MT26_58","070_26_58","MAT","26","58","58","Ka ko Peter noko manga mugi haka mama'o ia Jesus, ano hetae ki te gotomaga'e i te mu'a o te hage o te hakahua o na priest. Koia noko hano ki goto o noho haka pigi ki na ge'o sanga ke go na'a po nia ka hai. ");
INSERT INTO mnv_vpl VALUES ("MT26_59","070_26_59","MAT","26","59","59","Na hakahua o na priest ma na maatu'a o te Puugenga o na Jew noko hai lobo te ligo e kigatou ni gogoi 'anga, ke pau o haka makau ai ia Jesus, ka kigatou taa 'ia ke mate. ");
INSERT INTO mnv_vpl VALUES ("MT26_60","070_26_60","MAT","26","60","60","Ka na he'e kite e kigatou ni hai 'anga, masi'igoa noko 'eha pegea gogoi noko boo ake o gegea. Hano ano taha'aki i te boo ake te toka gua pegea, ");
INSERT INTO mnv_vpl VALUES ("MT26_61","070_26_61","MAT","26","61","61","o he 'atigongo haka totonu 'aki, “Te pegea nei noko gea, ‘Manga 'aonga te ebeebe e Au te Hage Tapu o God o haka tu'u hoki i he toka togu 'ao.’ ” ");
INSERT INTO mnv_vpl VALUES ("MT26_62","070_26_62","MAT","26","62","62","Kae manga tu'u te hakahua o na priest o hai atu kia Jesus, “ 'Ai ko Koe ka he'e haka tau ki na 'atigongo haka makau 'anga ia te Koe nei?” ");
INSERT INTO mnv_vpl VALUES ("MT26_63","070_26_63","MAT","26","63","63","Ka ko Jesus noko pau o he'e muna. Te hakahua o na priest noko hai atu kia Jesus, “Koau e hai atu kia te Koe i te ingoa o God ma'ugi goa: Hogahoga mai kia te kimatou, i te poi tenaa Koe te 'Agiki Taga'ia, te Hosa o God.” ");
INSERT INTO mnv_vpl VALUES ("MT26_64","070_26_64","MAT","26","64","64","Ma te haka tau atu a Jesus, “ 'Oo, tenaa te manga gea kinai koe. Ka ko Au e hai atu kia te koutou ngatahi: Na 'aso koi toe mai, koutou kago hiina'i ki te Hosa o Pegea e hai ke go noho i te pa'asi maui o God Hu'ai Hai taganga, ma te go hiina'i ma'u kinai e hai ke go a'u i na po'ao o te gangi.” ");
INSERT INTO mnv_vpl VALUES ("MT26_65","070_26_65","MAT","26","65","65","Ma te lagilagi e te hakahua o na priest ona ake, kae hai atu, “Tenaa te manga igho na! 'Eaa? 'Ai ko kitatou koi siahahai ma'u ni pegea ke he 'atigongo 'aki? Hiina'i atu, koutou kua haka gongo kia te Ia kae igho. ");
INSERT INTO mnv_vpl VALUES ("MT26_66","070_26_66","MAT","26","66","66","Koutou e kohea autou tegeu'a?” Ko kigatou na haka tau atu, “Ko Ia kua 'aonga te mate!” ");
INSERT INTO mnv_vpl VALUES ("MT26_67","070_26_67","MAT","26","67","67","Kae he ngaa'esu 'aki ki na mata o Jesus, kae kumi husu ogatou gima o husu ia te Ia. Kae paa e kogaa ia te Ia i ogatou gima, ");
INSERT INTO mnv_vpl VALUES ("MT26_68","070_26_68","MAT","26","68","68","kae hai atu, “Hogahoga mai kia te kimatou, na'e ko Koe te 'Agiki Taga'ia, po koai te taa ia te Koe nei?” ");
INSERT INTO mnv_vpl VALUES ("MT26_69","070_26_69","MAT","26","69","69","Te gholoba na, ko Peter noko manga noho i te gotomaga'e i te mu'a o te hage ma te a'u te guani hahine o hai atu kia te ia, “Ko koe ma'u noko manga haka pata kia Jesus mai Galilee.” ");
INSERT INTO mnv_vpl VALUES ("MT26_70","070_26_70","MAT","26","70","70","Ma te haka si'ai e Peter i 'ago ia te kigatou ngatahi. Kae hai atu, “E he'e na'a eau po nia te manga gea kinai koe.” ");
INSERT INTO mnv_vpl VALUES ("MT26_71","070_26_71","MAT","26","71","71","Ma te hano a Peter ki te aga o te hage, ka noko ina ma'u kinai tegaa hahine, o hai atu ki na pegea noko i te kungaa, “Te pegea nei noko manga haka pata ma'u kia Jesus mai Nazareth.” ");
INSERT INTO mnv_vpl VALUES ("MT26_72","070_26_72","MAT","26","72","72","Haka si'ai haka hoki e Peter, kae aguagu, “E he'e mi'i na'a eau te tangata na!” ");
INSERT INTO mnv_vpl VALUES ("MT26_73","070_26_73","MAT","26","73","73","Nimaa he'e taunga gogoa, kae boo ake na pegea noko manga tutu'u i te kungaa kia Peter o hai atu kinai, “E maa'ogi ko koe te pegea ia te kigatou, e maatino e kimatou i au gea 'anga ma tou ge'o.” ");
INSERT INTO mnv_vpl VALUES ("MT26_74","070_26_74","MAT","26","74","74","Ma te kuba e Peter ia te ia launatasi, kae konei ana aguagu kia te kigatou, “Ko au e he'e na'a eau te tangata na!” Ma te manga tangi te paolo. ");
INSERT INTO mnv_vpl VALUES ("MT26_75","070_26_75","MAT","26","75","75","'Io mugi a Peter o maanatu hoki ki te gea 'anga kinai a Jesus, “ 'Io mugi o tangi te paolo, ko koe kago haka si'ai haka togu e koe ia te Au.” Ma te hano a Peter ki haho o magepe maa'ogi. ");
INSERT INTO mnv_vpl VALUES ("MT27_1","070_27_1","MAT","27","1","1","Nimaa i te mahoata pipilu, ko ba'i hakahua o na priest ma na 'agiki o na Jew, na haka putu o puge ano hai tegatou paaunga ke taa ia Jesus ke mate. ");
INSERT INTO mnv_vpl VALUES ("MT27_2","070_27_2","MAT","27","2","2","Gii e kigatou ia Jesus o kakabe o haiga'a kia Pilate, te hakahua mai Rome. ");
INSERT INTO mnv_vpl VALUES ("MT27_3","070_27_3","MAT","27","3","3","Te gholoba na ina 'atu ai a Judas na haka soko eia ia Jesus, ko Ia kua pau o hai songo kae hai ke taa, ko ia na sui tegeu'a o to'o hoki eia te katoa haka togu mane siliva ki na hakahua o na Priest ma na 'agiki o na Jew. ");
INSERT INTO mnv_vpl VALUES ("MT27_4","070_27_4","MAT","27","4","4","O hai atu, “Koau kua hai toku 'oosongo te haka soko eau te tangata he'e hai e Ia ni hai 'anga maase'i ke mate ai.” Ka na haka tau kigatou o hai atu, “Nia teenaa kia te kimatou? Tau hai 'anga hai launatasi teenaa.” ");
INSERT INTO mnv_vpl VALUES ("MT27_5","070_27_5","MAT","27","5","5","Ma te seu e Judas na mane ki goto i te potu tapu to'a i te Hage Tapu, kae hano o tau te uka ki te ga'akau o nono'a ai te u'a o mate. ");
INSERT INTO mnv_vpl VALUES ("MT27_6","070_27_6","MAT","27","6","6","Ka na sa'u ake ena hakahua o na Priest na mane o hai ake, “Te mane hai i na toto tenei e hai susugi e na tagangonga ke noka te tuku haka tahi 'aki ki na mane o te Hage Tapu.” ");
INSERT INTO mnv_vpl VALUES ("MT27_7","070_27_7","MAT","27","7","7","Ma te hegeu kigatou o hai kinai tegatou paaunga, ke tau'i ai te ma'aga a te tangata gosigosi simeti, ke hai ai he hui taanuma mo'o na pegea taka taahea. ");
INSERT INTO mnv_vpl VALUES ("MT27_8","070_27_8","MAT","27","8","8","Tenaa te hai 'anga noko ta'a mate ai i gaa 'aso ano hetae mai ki te 'ao nei te Ma'aga o te Toto. ");
INSERT INTO mnv_vpl VALUES ("MT27_9","070_27_9","MAT","27","9","9","Ma te haka maa'ogi ai nia noko gea kinai te taauga ia Jeremiah: “Na to'o e kigatou te katoa haka togu mane silver, te tau'i na 'oti i te haka pau e na pegea o Israel. ");
INSERT INTO mnv_vpl VALUES ("MT27_10","070_27_10","MAT","27","10","10","O hai e kigatou na mane nei o tau'i ai te ma'aga a te tangata gosigosi simeti, ke papata ki te kaunaki 'anga e te 'Aitu ia te au kau hai 'ina.” ");
INSERT INTO mnv_vpl VALUES ("MT27_11","070_27_11","MAT","27","11","11","Te gholoba noko tu'u 'ago ai a Jesus ia Pilate, ko Pilate noko haka anu kia te Ia o hai atu, “ 'Ai ko Koe te hakahua o na Jew?” Ma te haka tau atu a Jesus, “ 'Oo, tenaa te manga gea mai ai koe.” ");
INSERT INTO mnv_vpl VALUES ("MT27_12","070_27_12","MAT","27","12","12","Ka te gholoba na gegea haka makau ai e na hakahua o na Priest ma na 'agiki o na Jew ia Jesus, ko Ia noko he'e haka tau kinai. ");
INSERT INTO mnv_vpl VALUES ("MT27_13","070_27_13","MAT","27","13","13","Ma te haka anu a Pilate kia Jesus o hai atu, “ 'Ai ko koe e he'e haka gongo ki ba'i hai 'anga e gegea haka goi ai e kigatou ia te Koe?” ");
INSERT INTO mnv_vpl VALUES ("MT27_14","070_27_14","MAT","27","14","14","Ka ko Jesus noko pau o he'e hakatau ki he launatasi me'a i na haka makau 'ia 'anga o langalanga to'a ai a Pilate. ");
INSERT INTO mnv_vpl VALUES ("MT27_15","070_27_15","MAT","27","15","15","Noko iai te huhuta o Pilate i te 'aso o te haka tahinga nei te haka tausu'u he pegea haka pupugu e te 'apitanga o Jew i na pegea i te kagohia. ");
INSERT INTO mnv_vpl VALUES ("MT27_16","070_27_16","MAT","27","16","16","Ka te gholoba na, noko iai te pegea hai me'a haka tangi to'a i te kagohia, tena ingoa ko Barabbas. ");
INSERT INTO mnv_vpl VALUES ("MT27_17","070_27_17","MAT","27","17","17","Te gholoba noko haka putu ake ai te 'apitanga o Jew, kae haka anu a Pilate kia te kigatou o hai atu, “Koai te siahahai koutou kau tuku 'ia ke tausu'u kia te koutou, ko Barabbas po ko Jesus, e mate te 'Agiki Taga'ia?” ");
INSERT INTO mnv_vpl VALUES ("MT27_18","070_27_18","MAT","27","18","18","Iteme'agaa noko na'a gaoi e Pilate ko Jesus noko manga haiga'a e Jew kia te ia, i te noko 'i'ita kia te Ia. ");
INSERT INTO mnv_vpl VALUES ("MT27_19","070_27_19","MAT","27","19","19","Te gholoba noko manga koi noho ai a Pilate i te noohonga haka aba pegea, hakato'o mai kinai e tena uguugu te gongo nei, “Noka te hai e koe he hai 'anga ki te tangata he'e hai e Ia ni hai 'anga songo na, na'e kua hai kinai taku miti i anapoo, o hu'ai mataku ai au.” ");
INSERT INTO mnv_vpl VALUES ("MT27_20","070_27_20","MAT","27","20","20","Ka na hakahua o na Priest ma na 'agiki o na Jew, noko usuusu e kigatou te 'apitanga o Jew, ke go haka ene 'aki ia Barabbas, ka ke tuku ia Jesus ke mate. ");
INSERT INTO mnv_vpl VALUES ("MT27_21","070_27_21","MAT","27","21","21","Ma te haka anu a Pilate, “Koai ia te kigaaua nei te siahahai koutou kau haka tausu'u atu 'ia kia te koutou?” Ko kigatou na haka tau atu, “Ko Barabbas!” ");
INSERT INTO mnv_vpl VALUES ("MT27_22","070_27_22","MAT","27","22","22","Ma te haka anu atu a Pilate, “Ka niaa e hai kau hai 'ia kia Jesus, e mate te 'Agiki Taga'ia?” Ko kigatou ngatahi na haka tau atu, “Taa atu ki te kros!” ");
INSERT INTO mnv_vpl VALUES ("MT27_23","070_27_23","MAT","27","23","23","Ma te hai atu a Pilate, “ 'Eaa, nia te hai e Ia o songo?” Ka ko kigatou noko ngengege haka soo ake ogatou ge'o, “Taa atu ia te Ia ki te kros!” ");
INSERT INTO mnv_vpl VALUES ("MT27_24","070_27_24","MAT","27","24","24","Te gholoba na ina 'iho ai a Pilate e he'e tau hai 'anga ma'u ke hai eia, kae haka tu'u ngana ngana. Ma te sa'u mai eia te bai o huhu'i ai na gima i 'ago i te 'apitanga, kae hai atu, “Ka he'e hai eau he hai 'anga songo te tuku eau te tangata nei ke mate, ka a'autou hugi sanga!” ");
INSERT INTO mnv_vpl VALUES ("MT27_25","070_27_25","MAT","27","25","25","Ka te 'apitanga noko haka tau atu, “Tuku mai te kagohia o tena mate ke noho kia te kimatou ma amatou matiginga!” ");
INSERT INTO mnv_vpl VALUES ("MT27_26","070_27_26","MAT","27","26","26","Ma te haka tausu'u e Pilate ia Barabbas kia te kigatou, kae kaunaki ke kogu ia Jesus 'io haiga'a ke taa ki te kros. ");
INSERT INTO mnv_vpl VALUES ("MT27_27","070_27_27","MAT","27","27","27","Ma te kakabe e na pegea hai tau'a o Pilate ia Jesus ki te hu'ai hage o Pilate. O haka putu ba'i pegea hai tau'a o ghigho ia Jesus. ");
INSERT INTO mnv_vpl VALUES ("MT27_28","070_27_28","MAT","27","28","28","'Ui'ui e kigatou te mago o Jesus, kae sui kigatou o haa mago ia te Ia i na ake uga sesenga. ");
INSERT INTO mnv_vpl VALUES ("MT27_29","070_27_29","MAT","27","29","29","Kae higi ma'u e kigatou te ha'u i na kaubago hotohoto o haka eke ki te 'ugu o Jesus, kae tuku e kigatou te ga'akau ki te gima maui o'ona, kae he tokotugi 'aki i 'ago ia Jesus o putatai kinai, “Tenaa koe, te Hakahua o na Jew!” ");
INSERT INTO mnv_vpl VALUES ("MT27_30","070_27_30","MAT","27","30","30","He nga'esu 'aki kia te Ia, kae sa'u e kigatou te ga'akau o pe'epe'e ai te 'ugu o 'Ona. ");
INSERT INTO mnv_vpl VALUES ("MT27_31","070_27_31","MAT","27","31","31","Nimaa 'oti agatou putatai 'anga kia Jesus nei, 'ui e kigatou te hu'ai ake uga sesenga, kae haa mago haka hoki i o'Ona o kakabe ia te Ia ke taa ki te kros. ");
INSERT INTO mnv_vpl VALUES ("MT27_32","070_27_32","MAT","27","32","32","Te gholoba noko maa boo ai ko kigatou, noko bilaabei ma te tangata mai Cyrene tena ingoa ko Simon, ma te hai e na pegea hai tau'a o 'amo eia te kros o Jesus. ");
INSERT INTO mnv_vpl VALUES ("MT27_33","070_27_33","MAT","27","33","33","Ko kigatou na boo o hetae ki te kunga noko mate ko Golgota, (e gaataki “Te Kunga o te Puso 'ugu”). ");
INSERT INTO mnv_vpl VALUES ("MT27_34","070_27_34","MAT","27","34","34","Tenaa te kunga na haiga'a ai e na pegea hai tau'a waeni ke binu ai a Jesus, noko haka higohigo i te bai bii; ka na binu lobo e Ia ma te he'e binu. ");
INSERT INTO mnv_vpl VALUES ("MT27_35","070_27_35","MAT","27","35","35","Te gholoba na 'oti i te taa ai e kigatou ia Jesus ki te kros, kae hai e kigatou te babage 'anga i na daes, ke tuha ai e kigatou na ake o 'Ona. ");
INSERT INTO mnv_vpl VALUES ("MT27_36","070_27_36","MAT","27","36","36","Kae noho 'aki o mata e kigatou ia Jesus i te kunga na. ");
INSERT INTO mnv_vpl VALUES ("MT27_37","070_27_37","MAT","27","37","37","Te pata 'anga ki 'agunga i te 'ugu o Jesus i te kros, noko tau kinai te kanukanu haka makau kia te Ia, “Tenei a Jesus te Hakahua o na Jew.” ");
INSERT INTO mnv_vpl VALUES ("MT27_38","070_27_38","MAT","27","38","38","Noko toka gua pegea kaia'a noko taa 'ia haka pigi kia Jesus, o tau tegaa i te pa'asi maui, kae tau tegaa i te pa'asi sema. ");
INSERT INTO mnv_vpl VALUES ("MT27_39","070_27_39","MAT","27","39","39","Na pegea noko manga he sigi sigi haki, noko gegea songo toto'a kia Jesus, ma te he o'io'i 'aki ogatou 'ugu. ");
INSERT INTO mnv_vpl VALUES ("MT27_40","070_27_40","MAT","27","40","40","Kae hai atu, “Ko Koe ka tuki te Hage Tapu ka ke go 'ati hoki i te togunga 'ao? Haka ma'ugi iho ia te Koe! Hinaiho i te kros na i te poi ko Koe te Hosa o God!” ");
INSERT INTO mnv_vpl VALUES ("MT27_41","070_27_41","MAT","27","41","41","Na hakahua o na Priest, ma na ako o na tagangonga ma na 'agiki o na Jew noko manga konei na noho ma'u agatou putatai kia Jesus. ");
INSERT INTO mnv_vpl VALUES ("MT27_42","070_27_42","MAT","27","42","42","Ko kigatou noko hai atu, “Manga haka ma'ugi e Ia kogaa pegea, kae he'e 'aonga te haka ma'ugi ia te Ia. Ko Ia te Hakahua o na Jew, tuku atu ke iho mai i te kros, ka kitatou too kia te Ia.” ");
INSERT INTO mnv_vpl VALUES ("MT27_43","070_27_43","MAT","27","43","43","Ko Ia e sano kia God. Tuku atu a te 'Aitu ke haka soi ia te Ia i te gholoba nei i te poi siahai Ia kia te Ia, na'e noko konei Ana gea, “Ko Au te Hosa o God.” ");
INSERT INTO mnv_vpl VALUES ("MT27_44","070_27_44","MAT","27","44","44","He'e po gua taangata kaia'a noko taa haka pigi 'ia kia te Ia, noko gegea songo toto'a ma'u kia te Ia. ");
INSERT INTO mnv_vpl VALUES ("MT27_45","070_27_45","MAT","27","45","45","Na henua na poo'ugi ngatahi haka tu'u i te 'ao 'atea, o hano ano ga'aa page. ");
INSERT INTO mnv_vpl VALUES ("MT27_46","070_27_46","MAT","27","46","46","Nimaa i te ga'aa page ko Jesus noko hai tena hu'ai ngege 'anga: “Ilae, ilae, lama, sabaktani?” Tegaa tona gaataki, “Toku God, toku God. 'Eaa e ti'aki ai e Koe ia te Au?” ");
INSERT INTO mnv_vpl VALUES ("MT27_47","070_27_47","MAT","27","47","47","Te gholoba noko haka gongo ai na pegea noko manga tutu'u i te kungaa ki te gea 'anga Jesus nei, ko kigatou noko konei agatou gegea, “Ko Jesus manga ngege ia Elijah.” ");
INSERT INTO mnv_vpl VALUES ("MT27_48","070_27_48","MAT","27","48","48","Ma te tege ghali te pegea ia te kigatou, o to'o mai te me'a maguu o hai kinai eia na waeni maga, o tuku ki te tino bugu, o haka to'ake ke binu ai a Jesus. ");
INSERT INTO mnv_vpl VALUES ("MT27_49","070_27_49","MAT","27","49","49","Ka noko hai atu kogaa, “Saunoa atu kia te Ia, ka kitatou mataa hiina'i kinai, po ka a'u a Elijah o haka soi ia te Ia.” ");
INSERT INTO mnv_vpl VALUES ("MT27_50","070_27_50","MAT","27","50","50","Ka te gholoba na tangi to'a haka hoki ai a Jesus, kae haiga'a te spirit o 'Ona. ");
INSERT INTO mnv_vpl VALUES ("MT27_51","070_27_51","MAT","27","51","51","Te gholoba na, na maha'a gua ai te laoa maatogu noko tau i te uso o te Hage Tapu, haka tu'u iho i 'agunga o hetae iho ki gago. O'i o'i ma'u a te kege kae maha'aha'a ai na hatu mogi. ");
INSERT INTO mnv_vpl VALUES ("MT27_52","070_27_52","MAT","27","52","52","Maha'aha'a o ta'ata'aki na takotonga. Kae a'aga giu mai ki te ma'ugi na tino o na pegea tapu noko mamate. ");
INSERT INTO mnv_vpl VALUES ("MT27_53","070_27_53","MAT","27","53","53","Ko kigatou na sosopo ake i na takotonga. Nimaa ma'ugi hoki a Jesus, ko kigatou na boo ki Jerusalem o haka 'agitino ki te 'apitanga. ");
INSERT INTO mnv_vpl VALUES ("MT27_54","070_27_54","MAT","27","54","54","Te gholoba noko hiina'i ai te tugi tau'a ma tena tu'uganga noko manga tutu'u o ge'o ia Jesus, ki te o'i o'i 'anga, ma ba'i hai 'anga noko hai, ko kigatou na matataku toto'a kae gegea toto'a ake, “E maa'ogi, ko Ia te Hosa o God.” ");
INSERT INTO mnv_vpl VALUES ("MT27_55","070_27_55","MAT","27","55","55","Noko 'eha haahine noko i te kungaa, noko manga mata haka mama'o atu, ko kigatou noko he tata'o 'aki ia Jesus mai Galilee, o noko manga baa siko ia te Ia. ");
INSERT INTO mnv_vpl VALUES ("MT27_56","070_27_56","MAT","27","56","56","Noko iai a Mary mai Magdala, ma Mary te tinana o James ma Joseph ma te tinana o gua hosa o Zebedee. ");
INSERT INTO mnv_vpl VALUES ("MT27_57","070_27_57","MAT","27","57","57","Nimaa i te hano 'anga ki te ahiahi, hetae mai te tangata ga'u mai Arimathea, tena ingoa ko Joseph, koia ma'u na hai ia te ia te pegea haka ako o Jesus. ");
INSERT INTO mnv_vpl VALUES ("MT27_58","070_27_58","MAT","27","58","58","Hano kia Pilate, o haka ene kinai i te tino o Jesus. Ma te kaunaki e Pilate ona pegea o haiga'a te tino o Jesus kia Joseph. ");
INSERT INTO mnv_vpl VALUES ("MT27_59","070_27_59","MAT","27","59","59","Ma te sa'u iho e Joseph te tino o Jesus o pegu i na laoa susugu ma'a, ");
INSERT INTO mnv_vpl VALUES ("MT27_60","070_27_60","MAT","27","60","60","o tuku e Joseph ki te takotonga ho'ou o'ona noko kegi eia i te ogo hatu, kae hugihugi kinai eia te hu'ai hatu o titingi ai te mata o te takotonga, kae hano. ");
INSERT INTO mnv_vpl VALUES ("MT27_61","070_27_61","MAT","27","61","61","Ko Mary mai Magdala, ma tegaa tasi Mary noko manga noho 'aki o he nga'ago 'aki ki te takotonga. ");
INSERT INTO mnv_vpl VALUES ("MT27_62","070_27_62","MAT","27","62","62","Nimaa i tegaa 'ao, te 'ao e mugi mai i te 'Ao Ngaague, na hakahua o na Priest ma na Pharisee noko boo ake kia Pilate. ");
INSERT INTO mnv_vpl VALUES ("MT27_63","070_27_63","MAT","27","63","63","O hai atu, “Hakahua, ko kimatou e maanatu ki na 'aso noko manga koi ma'ugi ai te pegea goi nei, noko hai mai, ‘Nimaa go i te 'ao go togu kinai toku mate, e hai kau go ma'ugi haka hoki ai.’ ");
INSERT INTO mnv_vpl VALUES ("MT27_64","070_27_64","MAT","27","64","64","Haiga'a atu he kaunakinga ke ge'o gaoi te takotonga, ke hano ano hetae ki te 'ao go togu kinai tena mate. Na'e kitai go boo ake ona pegea haka ako o kaia'a te tino, kae go he 'atigongo 'aki ki te 'apitanga ko Ia kua ma'ugi mai i te mate. Te gogoi mugi 'anga nei, kago tamaki o sigi i te mataa hai 'anga.” ");
INSERT INTO mnv_vpl VALUES ("MT27_65","070_27_65","MAT","27","65","65","Ma te haka tau atu a Pilate, “Kakabe atu na pegea ge'o ke ge'o, boo atu o ge'o gaoi te takotonga, ma te hai kinai nia e 'aonga te hai kinai e koutou.” ");
INSERT INTO mnv_vpl VALUES ("MT27_66","070_27_66","MAT","27","66","66","Ma te boo kigatou o ge'o gaoi te takotonga, noko tuku haka 'igonga ki te hatu e titingi ai te takotonga kae tuku na pegea ge'o. ");
INSERT INTO mnv_vpl VALUES ("MT28_1","070_28_1","MAT","28","1","1","Nimaa sigi te 'ao oki oki, i te mahoata pilupilu o te 'ao mu'a, ko Mary mai Magdala, ma tegaa tasi Mary, noko boo ke hiina'i ki te takotonga. ");
INSERT INTO mnv_vpl VALUES ("MT28_2","070_28_2","MAT","28","2","2","'Ai na hai te hu'ai o'i o'i 'anga, i te hinaiho 'anga mai te gangi te ensel o te 'Aitu o hano ki te takotonga o hugihugi te hatu ki taha o manga noho ai. ");
INSERT INTO mnv_vpl VALUES ("MT28_3","070_28_3","MAT","28","3","3","Na noho o'ona noko manga noho pe te 'uiga, ka ona laoa noko maa susugu pe na usae. ");
INSERT INTO mnv_vpl VALUES ("MT28_4","070_28_4","MAT","28","4","4","Na pegea noko ge'o te takotonga na matataku ki te ensel o manga he popoge 'aki, ano manga sa'akigoa na pegea mamate. ");
INSERT INTO mnv_vpl VALUES ("MT28_5","070_28_5","MAT","28","5","5","Hai atu te ensel kia gua haahine, “Noka te matataku, e na'a eau kougua manga sasaga ia Jesus na ta'ia ki te kros. ");
INSERT INTO mnv_vpl VALUES ("MT28_6","070_28_6","MAT","28","6","6","Ko Ia e he'e kitea i te kunga nei. Ko Ia kua ma'ugi hoki o haka maa'ogi ai nia noko gea ai. Boomai o hiina'i ki te kunga noko takoto ai. ");
INSERT INTO mnv_vpl VALUES ("MT28_7","070_28_7","MAT","28","7","7","Kae giu ghali atu o hogahoga ki ona pegea haka ako: ‘Ko Ia kua ma'ugi hokimai i te mate, ka kua mu'a ia te koutou ki Galilee. Tenaa te kunga kago hiina'i ai koutou kia te Ia.’ Manga konei na hogahoga atu e Au kia te kougua.” ");
INSERT INTO mnv_vpl VALUES ("MT28_8","070_28_8","MAT","28","8","8","Ma te ghali gua haahine o boo i te takotonga. Masi'igoa noko matataku, ka ko kigaaua noko sisia. Kae he 'agiko ke 'atigongo ki na pegea haka ako. ");
INSERT INTO mnv_vpl VALUES ("MT28_9","070_28_9","MAT","28","9","9","Manga he tu'ia 'aki kigaaua i te sasa'o kia Jesus, o hakagaoi kia te kigaaua. Boo kigaaua kia Jesus o he 'osohi ki na tapungao o sogi kia te Ia. ");
INSERT INTO mnv_vpl VALUES ("MT28_10","070_28_10","MAT","28","10","10","Ma te hai atu a Jesus kia te kigaaua, “Noka te matataku. Boo atu o he 'atigongo 'aki ki na pegea o 'Oku ke boo ki Galilee, 'e tenaa te kunga kago hiina'i ai kia te Au.” ");
INSERT INTO mnv_vpl VALUES ("MT28_11","070_28_11","MAT","28","11","11","Te gholoba noko maa koi boo ai gua haahine, noko iai kogaa i na pegea noko ge'o te takotonga na boo ki Jerusalem o he 'atigongo 'aki ki na hakahua o na Priest i ba'i hai 'anga na hai. ");
INSERT INTO mnv_vpl VALUES ("MT28_12","070_28_12","MAT","28","12","12","I te gholoba noko bilaabei ai na hakahua o na Priest ma na 'agiki o na Jew o hai tegatou paaunga, o haiga'a te hu'ai tu'u mane ki na pegea hai tau'a. ");
INSERT INTO mnv_vpl VALUES ("MT28_13","070_28_13","MAT","28","13","13","Hai atu kia te kigatou, “Koutou e hai ke konei na gegea: ‘Ko kimatou noko manga momoe i te poo, kae boomai Ona pegea haka ako o kaia'a te tino o 'Ona.’ ");
INSERT INTO mnv_vpl VALUES ("MT28_14","070_28_14","MAT","28","14","14","Ka ko Pilate nimaa go haka gongo ki te gongo nei, e hai kimatou go haka tinogaoi 'ia kinai, kago he'e tatae he maikia kia te koutou.” ");
INSERT INTO mnv_vpl VALUES ("MT28_15","070_28_15","MAT","28","15","15","Na pegea hai tau'a na to'o e kigatou na mane, o hai e kigatou nia noko tongitongi aki kigatou hai 'ia. Te gongo nei na seseke ki ba'i pegea o Jew, ano tatae mai ki te 'ao nei. ");
INSERT INTO mnv_vpl VALUES ("MT28_16","070_28_16","MAT","28","16","16","Ma te boo te katoa tuma'a e tasi pegea haka ako ki Galilee, ki te ogo noko gea a Jesus kia te kigatou ke boo kinai. ");
INSERT INTO mnv_vpl VALUES ("MT28_17","070_28_17","MAT","28","17","17","Te gholoba na hiina'i ai kigatou kia Jesus, ko kigatou na sogi kia te Ia, ka noko iai kogaa pegea noko manga he tootoobaasi'a 'aki. ");
INSERT INTO mnv_vpl VALUES ("MT28_18","070_28_18","MAT","28","18","18","Ma te a'u a Jesus kia te kigatou o hai atu, “Ko ba'i taganga ma na paaunga o te gangi ma te kege nei, kua haiga'a kia te Au. ");
INSERT INTO mnv_vpl VALUES ("MT28_19","070_28_19","MAT","28","19","19","Kae boo atu ki ba'i henua o hai ia te kigatou ke hai ai mo'oku ni pegea haka ako. Haa gogomi atu ia te kigatou i te ingoa o te Tamana, ma te Hosa, ma te Spirit Tapu. ");
INSERT INTO mnv_vpl VALUES ("MT28_20","070_28_20","MAT","28","20","20","Ma te ako ia te kigatou ke mangangao ki ba'i hai 'anga kua 'oti i te gea ai Au kia te koutou. Ka noko na'a pipiki atu, na'e ko Au e hai kau noko haka pata kia te koutou i ba'i gholoba, hano ano hetae ki te 'otinga o te kege nei. E tonu!”");
INSERT INTO mnv_vpl VALUES ("MK1_1","071_1_1","MRK","1","1","1","Tenei te haka tu'u sanga o te Gongo Gaoi o Jesus Christ, te Hosa o te 'Aitu. ");
INSERT INTO mnv_vpl VALUES ("MK1_2","071_1_2","MRK","1","2","2","Na 'oti i te kanukanu e te taauga ia Isaiah: “E hai kau go haka to'o 'ia toku pegea to'o gongo ke go mu'a ia te Koe. E hai ke go haka ngaague eia te aga kia te Koe. ");
INSERT INTO mnv_vpl VALUES ("MK1_3","071_1_3","MRK","1","3","3","Te ge'o o te pegea manga ngege i te tugatea o hai ake: ‘Haka ngaague atu te aga kia te 'Agiki. Haka tinogaoi atu na mi'i aga kia te Ia.’ ” ");
INSERT INTO mnv_vpl VALUES ("MK1_4","071_1_4","MRK","1","4","4","Ma te a'u a John Baptist ki te kunga i te tugatea o haa gogomi pegea ma te tohi'aki o hai atu, “Koutou he ngatu'a 'aki atu ki na 'oosongo ma te haa gogomi ia te koutou, ka ke haka noka ai e te 'Aitu outou 'oosongo.” ");
INSERT INTO mnv_vpl VALUES ("MK1_5","071_1_5","MRK","1","5","5","Ma te boomai te 'apitanga mai Judea, ma te hu'ai manaha i Jerusalem, o haka gongo kia John. Ko kigatou na haka nuukegi i ogatou 'oosongo ma te haa gogomi e John ia te kigatou i te bai mimigo i Jordan. ");
INSERT INTO mnv_vpl VALUES ("MK1_6","071_1_6","MRK","1","6","6","Ko John noko manga mago i na laoa gosigosi i na hugu ‘camel’, ma te nono'a te tino i te kapitiake gosigosi i na kigi buluka. Koia noko manga kai 'ungaghali ma na ‘honey’ i mouku. ");
INSERT INTO mnv_vpl VALUES ("MK1_7","071_1_7","MRK","1","7","7","Ko John noko tohi'aki o hai atu, “Te pegea e mugi mai ia te au, e hua'eha o sigi ia te au. Koau e he'e 'aonga te hao'o kau huhuke 'ia Ona taka ba'e. ");
INSERT INTO mnv_vpl VALUES ("MK1_8","071_1_8","MRK","1","8","8","Manga haa gogomi eau ia te koutou i te bai, ka ko Ia kago haa gogomi e Ia ia te koutou i te Spirit Tapu.” ");
INSERT INTO mnv_vpl VALUES ("MK1_9","071_1_9","MRK","1","9","9","I na gholoba na, ko Jesus noko a'u mai Nazareth, te manaha i Galilee ki te bai mimigo i Jordan ke haa gogomi ai e John. ");
INSERT INTO mnv_vpl VALUES ("MK1_10","071_1_10","MRK","1","10","10","Nimaa sopo ake a Jesus i te bai, o ina 'ake ki te gangi e maha'a gua, kae iho mai ai te Spirit Tapu kia te Ia manga noho pe te gupe. ");
INSERT INTO mnv_vpl VALUES ("MK1_11","071_1_11","MRK","1","11","11","Ma te sopo te ge'o mai te gangi o hai iho, “Tenaa Koe toku Hosa, e ma'ine to'a kinai Au. Ko Au e hu'ai magaohie to'a kia te Koe.” ");
INSERT INTO mnv_vpl VALUES ("MK1_12","071_1_12","MRK","1","12","12","Ma te hakato'o e te Spirit Tapu ia te Ia o hano ki te tugatea. ");
INSERT INTO mnv_vpl VALUES ("MK1_13","071_1_13","MRK","1","13","13","Ko Ia noko noho i te tugatea i te katoa haka haa 'ao, manga pake e Satan. Ko Jesus noko manga haka pata ki na manu o mouku, ka noko manga 'aabaki kinai na ensel. ");
INSERT INTO mnv_vpl VALUES ("MK1_14","071_1_14","MRK","1","14","14","Mugi i te tuku 'anga a John Baptist ki te hage o na kagohia, hano a Jesus ki Galilee o manga 'atigongo i te Gongo Gaoi o te 'Aitu. ");
INSERT INTO mnv_vpl VALUES ("MK1_15","071_1_15","MRK","1","15","15","O hai atu, “Te 'aso haka pau kua a'u. Te gholoba o te 'Aitu ke hakahua ai e Ia a te kege nei kua hitaiaki. Koutou he ngatutu'a 'aki atu ki na 'oosongo kae too ki te Gongo Gaoi!” ");
INSERT INTO mnv_vpl VALUES ("MK1_16","071_1_16","MRK","1","16","16","Te 'aso noko manga sehu ai a Jesus i te pa'asi o te gano i Galilee, ina kia Simon ma te taina ia Andrew manga hai bugho i te gano, iteme'agaa ko kigaaua gua pegea tautai. ");
INSERT INTO mnv_vpl VALUES ("MK1_17","071_1_17","MRK","1","17","17","Hai atu a Jesus kia te kigaaua, “Tata'o mai ia te Au, ka kau hai 'ia ia te kougua ke tautai kia pegea.” ");
INSERT INTO mnv_vpl VALUES ("MK1_18","071_1_18","MRK","1","18","18","Ma te ti'aki ghali ogaua bugho, kae tata'o ia te Ia. ");
INSERT INTO mnv_vpl VALUES ("MK1_19","071_1_19","MRK","1","19","19","Nimaa mi'i hano soo atu a Jesus, kite atu e Ia gua hosa o Zebedee, ia James ma te taina ia John manga gosigosi ogaua bugho i te baka. ");
INSERT INTO mnv_vpl VALUES ("MK1_20","071_1_20","MRK","1","20","20","He'e haka tautau a Jesus manga ngege atu ia te kigaaua ke tata'o ia te Ia. Manga ti'aki e kigaaua ia tegaaua tamana ia Zebedee ma na pegea hai hekau i te baka, kae tata'o ia te Ia. ");
INSERT INTO mnv_vpl VALUES ("MK1_21","071_1_21","MRK","1","21","21","Boo kigatou ki Capernaum, ka nimaa i te 'Ao oki oki, hano a Jesus ki te Hage hai paaunga o haka tu'u ako ai. ");
INSERT INTO mnv_vpl VALUES ("MK1_22","071_1_22","MRK","1","22","22","Te 'apitanga noko he gege ma'ugi 'aki i Ana akonga, iteme'agaa noko manga ako ia te kigatou po te pegea hu'ai taganga he'e noho pe na ako o na tagangonga. ");
INSERT INTO mnv_vpl VALUES ("MK1_23","071_1_23","MRK","1","23","23","Nimaa i te gholoba na, te pegea uguhia i tegatou hage hai paaunga noko ngege to'a, ");
INSERT INTO mnv_vpl VALUES ("MK1_24","071_1_24","MRK","1","24","24","o hai atu, “Jesus mai Nazareth, niaa te siahai kinai Koe ia te kimatou? Ko Koe e a'u ke taa ia te kimatou? E na'a eau ia te Koe: Te Pegea Tapu o te 'Aitu!” ");
INSERT INTO mnv_vpl VALUES ("MK1_25","071_1_25","MRK","1","25","25","Ma te hai atu kinai a Jesus, “Ngongoto iho! Sopo iho ki taha ia te ia!” ");
INSERT INTO mnv_vpl VALUES ("MK1_26","071_1_26","MRK","1","26","26","Ma te hai e te haagiki songo ia te ia o popoge to'a kae sopo ghaghaa ki taha. ");
INSERT INTO mnv_vpl VALUES ("MK1_27","071_1_27","MRK","1","27","27","Na pegea noko he gege ma'ugi 'aki toto'a ma te he haka anuanu 'aki, “Teaa tenei? Te akonga ho'ou, kae hu'ai taganga! Ko Ia ma'u e gea to'a ki na haagiki songo ma te manga mangangao kia te Ia!” ");
INSERT INTO mnv_vpl VALUES ("MK1_28","071_1_28","MRK","1","28","28","Te gongo o 'Ona na ghali tena seseke 'anga o mahoga i ba'i kakai 'anga i Galilee. ");
INSERT INTO mnv_vpl VALUES ("MK1_29","071_1_29","MRK","1","29","29","Ko kigatou noko sosopo iho i te Hage hai paaunga, o manga pau o boo ma James ma John ki te hage o Simon ma te taina ia Andrew. ");
INSERT INTO mnv_vpl VALUES ("MK1_30","071_1_30","MRK","1","30","30","Te tinana hungabai o Simon noko manga takoto i te masaki 'augia, ma te he 'atigongo 'aki ai a kigatou kia Jesus. ");
INSERT INTO mnv_vpl VALUES ("MK1_31","071_1_31","MRK","1","31","31","Ka noko hano kinai a Jesus o 'oso ki te gima o baa 'aga. Ma te sigi te 'augia kae gosigosi utunga kia te kigatou. ");
INSERT INTO mnv_vpl VALUES ("MK1_32","071_1_32","MRK","1","32","32","Te ahiahi na mugi i te mene 'anga te ga'aa, haka kakabe mai e na pegea kia Jesus ko ba'i pegea iai na masaki ma na pegea he uguhia 'aki. ");
INSERT INTO mnv_vpl VALUES ("MK1_33","071_1_33","MRK","1","33","33","Ko ba'i pegea o te manaha nei, na haka putu mai ki te mataa aga o te hage. ");
INSERT INTO mnv_vpl VALUES ("MK1_34","071_1_34","MRK","1","34","34","O haka ma'ugi e Jesus te 'apitanga i ba'i agaa sa'o saga, kae pagepage e Ia na haagiki songo. Ka noko he'e tuku e Ia na haagiki ke gegea, iteme'agaa noko na'a e kigatou ia te Ia. ");
INSERT INTO mnv_vpl VALUES ("MK1_35","071_1_35","MRK","1","35","35","Nimaa i te mahoata pilupilu, 'aga a Jesus o ugu ki haho o hano ki te kunga gaabaki, o taakunga ai. ");
INSERT INTO mnv_vpl VALUES ("MK1_36","071_1_36","MRK","1","36","36","Ma te boo a Simon ma tena 'api o sasaga ia te Ia. ");
INSERT INTO mnv_vpl VALUES ("MK1_37","071_1_37","MRK","1","37","37","Nimaa te kite 'anga e kigatou kae hai atu, “Ko ba'i pegea manga sasaga e kigatou ia te Koe!” ");
INSERT INTO mnv_vpl VALUES ("MK1_38","071_1_38","MRK","1","38","38","Ma te haka tau a Jesus kia te kigatou o hai atu, “Kitatou boo ki na manaha e hitaiaki mai nei, ka kau tohi'aki ai ma'u, tena te hai 'anga noko a'u ai Au.” ");
INSERT INTO mnv_vpl VALUES ("MK1_39","071_1_39","MRK","1","39","39","Ko Ia noko hano ki ba'i manaha i Galilee, o manga tohi'aki i na Hage hai paaunga ma te pagepage haagiki songo ai. ");
INSERT INTO mnv_vpl VALUES ("MK1_40","071_1_40","MRK","1","40","40","Te tangata kahoa noko a'u kia Jesus o toko tugi o haka ene maa'ogi kia te Ia o hai atu, “Nimaa siahai Koe, e 'aonga te hai mai kau mahu.” ");
INSERT INTO mnv_vpl VALUES ("MK1_41","071_1_41","MRK","1","41","41","'Agoha to'a kinai a Jesus o hohoga te gima o 'oso kinai, kae hai atu kia te ia, “E siahai kinai Au. Ko koe hai ke mahu!” ");
INSERT INTO mnv_vpl VALUES ("MK1_42","071_1_42","MRK","1","42","42","Ma te he'e kitea tena kahoa 'anga i te gholoba na kae mahu. ");
INSERT INTO mnv_vpl VALUES ("MK1_43","071_1_43","MRK","1","43","43","Tuku e Jesus ia te ia o hano, kae gea susugi to'a kinai o hai atu, ");
INSERT INTO mnv_vpl VALUES ("MK1_44","071_1_44","MRK","1","44","44","“Noka tau 'atigongo i te hai 'anga nei ki he pegea, kae hinatu o haka 'agi ia te koe ki he priest, kae haiga'a te ga'a kia te 'Aitu noko tuku i na tagangonga a Moses ke ma'a ai koe, o taukimata ai kia te kigatou.” ");
INSERT INTO mnv_vpl VALUES ("MK1_45","071_1_45","MRK","1","45","45","Ka koia na hano o 'atigongo i nia noko hai kia te ia. Na konei na noho ma te he'e 'aonga te hano haka 'agi'agi ai a Jesus ki goto i na manaha, ka manga noho i tu'a i na kunga gaabaki. Ka ko pegea mai ba'i kunga noko manga boomai kia te Ia. ");
INSERT INTO mnv_vpl VALUES ("MK2_1","071_2_1","MRK","2","1","1","Nimaa sigi kogaa 'ao, ko Jesus noko hoki ki goto i Capernaum, ma te gongo ai na pegea ko Ia kua hoki mai ki te manaha. ");
INSERT INTO mnv_vpl VALUES ("MK2_2","071_2_2","MRK","2","2","2","Na 'api to'a te haka putu 'anga o he'e tau kunga toe he'e po te taha o te aga ki goto i te hage. Kae tohi'aki a Jesus kia te kigatou i te Gongo Gaoi. ");
INSERT INTO mnv_vpl VALUES ("MK2_3","071_2_3","MRK","2","3","3","Ka noko 'amo mai e te toka haa pegea te tangata taa haka pikipiki i te kaupea kia te Ia. ");
INSERT INTO mnv_vpl VALUES ("MK2_4","071_2_4","MRK","2","4","4","Ka noko he'e kitea na to'o e kigatou kia Jesus i te noko niti ia pegea. Ma te hekaakei kigatou o kegi te tu'a hage e pata iho ia te Ia. Nimaa 'oti i te luga e kigatou te tu'a hage kae tuku iho te kaupea manga teka ai te pegea taa haka pikipiki. ");
INSERT INTO mnv_vpl VALUES ("MK2_5","071_2_5","MRK","2","5","5","Te gholoba noko ina ai a Jesus ki te hu'ai sano o 'ogatou, ma te hai atu a Ia ki te pegea taa haka pikipiki, “Tama, ou 'oosongo kua haka noka.” ");
INSERT INTO mnv_vpl VALUES ("MK2_6","071_2_6","MRK","2","6","6","Ka te hage nei noko manga noho 'aki ai na ako o na Jew, noko konei na tegeu'a kia te kigatou soko, ");
INSERT INTO mnv_vpl VALUES ("MK2_7","071_2_7","MRK","2","7","7","“ 'Eaa te pegea na e konaa ana gea ai? Ko Ia e igho! Manga ko te 'Aitu launatasi te manga 'aonga te haka noka na 'oosongo!” ");
INSERT INTO mnv_vpl VALUES ("MK2_8","071_2_8","MRK","2","8","8","Ma te na'a e Jesus i te Spirit o 'Ona nia te manga tegeu'a kinai kigatou i ogatou uso, o hai atu kia te kigatou, “ 'Eaa e tegeu'a ai koutou ki na me'a na? ");
INSERT INTO mnv_vpl VALUES ("MK2_9","071_2_9","MRK","2","9","9","'Ai tehea te hai 'anga e hai ngaohie: Te hai atu ki te pegea taa haka pikipiki nei, ‘Ou 'oosongo kua haka noka’, po ke hai atu kia te ia, ‘ 'Aga ake, o to'o tou kaainga o hano’? ");
INSERT INTO mnv_vpl VALUES ("MK2_10","071_2_10","MRK","2","10","10","Kae hai ke na'a e koutou te Hosa o Pegea e hai taganga i te kege nei ke haka noka na 'oosongo...” Ma te hai atu a Jesus ki te pegea taa haka pikipiki, ");
INSERT INTO mnv_vpl VALUES ("MK2_11","071_2_11","MRK","2","11","11","“Ko Au e hai atu kia te koe, 'Aga ake, to'o ake tou kaupea na, o hano ki tou manaha!” ");
INSERT INTO mnv_vpl VALUES ("MK2_12","071_2_12","MRK","2","12","12","Koia na 'aga o to'o tena kaupea o hano ki haho o hiina'i kinai ba'i pegea, ma te he gege ma'ugi 'aki ai kigatou, o haka e'eha ia te 'Aitu, kae hai ake, “Ko kimatou he'e mi'i hiina'i ki ni hai 'anga konei na noho!” ");
INSERT INTO mnv_vpl VALUES ("MK2_13","071_2_13","MRK","2","13","13","Ko Jesus noko hoki ma'u ki te pa'asi o te gano i Galilee. Ma te boomai te 'apitanga kia te Ia o hakatu'u ako e Ia ia te kigatou. ");
INSERT INTO mnv_vpl VALUES ("MK2_14","071_2_14","MRK","2","14","14","Nimaa sehu atu a Jesus, ma te ina ki te pegea tibu takis ia Levi, te hosa o Alphaeus. Ko Levi noko manga noho i tena hage kanukanu, ma te hai atu kinai a Jesus, “Tata'o mai ia te Au.” Ma te tu'u ake a Levi o tata'o ia Jesus. ");
INSERT INTO mnv_vpl VALUES ("MK2_15","071_2_15","MRK","2","15","15","Nimaa i te gholoba noko ma kai ai a Jesus i te hage o Levi, noko 'api pegea tibu takis ma na pegea 'oosongo noko ma kai haka pigi kia te Ia ma ona pegea haka ako, iteme'agaa noko 'api pegea noko ma he tata'o 'aki ia te Ia. ");
INSERT INTO mnv_vpl VALUES ("MK2_16","071_2_16","MRK","2","16","16","Nimaa te gholoba noko hiina'i ai na ako o na tagangonga, ko na Pharisee, kia Jesus manga kai haka pigi ki na pegea tibu takis ma na pegea 'oosongo ina, ma te he haka anuanu 'aki ki na pegea haka ako o Jesus o hai atu, “Tehea te hai 'anga e kai haka pigi ai Ia ki na pegea tibu takis ma kogaa pegea 'oosongo ina?” ");
INSERT INTO mnv_vpl VALUES ("MK2_17","071_2_17","MRK","2","17","17","Te hakagongo 'anga a Jesus ki te hakaanu nei, ko Ia na hai atu kia te kigatou, “Na pegea toka e he'e siahahai pegea hetauaki, ka manga na pegea masasaki. Ko Au noko he'e a'u ki gago nei kau ligo 'ia na pegea gaoi ka na pegea 'oosongo.” ");
INSERT INTO mnv_vpl VALUES ("MK2_18","071_2_18","MRK","2","18","18","Na pegea haka ako o John Baptist ma na pegea haka ako o na Pharisee noko he'e kai i te sogi. Kae boomai na pegea kia Jesus o he hakaanu 'aki kia te Ia o hai atu, “ 'Eaa e he'e kai ai na pegea haka ako o John ma o'ona Pharisee, ka manga kai ai o'ou?” ");
INSERT INTO mnv_vpl VALUES ("MK2_19","071_2_19","MRK","2","19","19","Ma te konei na haka tau a Jesus kia te kigatou: “E hai ke kohea na hai ke he'e kai na pegea haka pogo e te tangata hai uguugu ho'ou i te gholoba manga hakapata ai ia kia te kigatou? Ko kigatou e hai ke noko kai i te 'aso manga koi haka pata ai Ia kia te kigatou. ");
INSERT INTO mnv_vpl VALUES ("MK2_20","071_2_20","MRK","2","20","20","Ka e iai te 'aso ka go kakabe 'aatea ai 'ia te pegea hai uguugu ho'ou ia te kigatou. Tenaa te 'ao kago he'e kai ai kigatou. ");
INSERT INTO mnv_vpl VALUES ("MK2_21","071_2_21","MRK","2","21","21","“E he'e kitea he pegea lapui he momo laoa ho'ou ki he laoa popo. Nimaa hai, te momo laoa ho'ou ka lalagi te pa'asi laoa popo, ka hai te malagi 'anga o hua'eha. ");
INSERT INTO mnv_vpl VALUES ("MK2_22","071_2_22","MRK","2","22","22","“Kae he'e kitea ma'u he pegea ke 'utu he waeni ho'ou ki he me'a 'utu waeni mai gaa 'aso. Nimaa hai e ia, te waeni ho'ou ka haha'a eia te me'a 'utu waeni, o magingi ai te waeni, kae songo ma'u te me'a 'utu waeni. Kae kogaa na noho, e hai ke 'utu na waeni ho'ou ki na me'a 'utu waeni ho'ou.” ");
INSERT INTO mnv_vpl VALUES ("MK2_23","071_2_23","MRK","2","23","23","Te launatasi 'Ao oki oki ko Jesus noko boo ma ona pegea haka ako i te uso o na 'umanga witi. Ona pegea haka ako noko haka tu'u haki e kigatou na hua o na witi. ");
INSERT INTO mnv_vpl VALUES ("MK2_24","071_2_24","MRK","2","24","24","Ma te haka anuanu 'aki na Pharisee kia Jesus o hai atu, “ 'Eaa e konei na hai ai e kigatou na hai 'anga e he'e tuku ke hai i te 'Ao oki oki?” ");
INSERT INTO mnv_vpl VALUES ("MK2_25","071_2_25","MRK","2","25","25","Ma te haka tau atu a Jesus, “ 'Ai e he'e haka sahe e koutou nia noko hai e David i te 'aso noko he ongea 'aki ai ma tena lango 'anga, kae he'e kitea ma'agatou ni me'a ke kai? ");
INSERT INTO mnv_vpl VALUES ("MK2_26","071_2_26","MRK","2","26","26","Ko David noko hano ki goto i te hage o te 'Aitu, i na 'aso o Abiathar te hakahua o na priest, o kai eia na bred noko haa tapu kia te 'Aitu. Na bred nei noko manga 'aonga te kai soko e na priest, kae haiga'a ma'u e ia na bred ki tena lango 'anga o kai.” ");
INSERT INTO mnv_vpl VALUES ("MK2_27","071_2_27","MRK","2","27","27","Ma te hai atu a Jesus kia te kigatou, “Te 'Ao oki oki noko gosigosi kia pegea, ka noko he'e gosigosi a pegea ki te 'Ao oki oki. ");
INSERT INTO mnv_vpl VALUES ("MK2_28","071_2_28","MRK","2","28","28","Kogaa na noho, te Hosa o Pegea te hakahua ma'u o te 'Ao oki oki.” ");
INSERT INTO mnv_vpl VALUES ("MK3_1","071_3_1","MRK","3","1","1","I tegaa tasia 'aso, hano Ia ki te Hage hai paaunga, manga noho ai te tangata pege te gima. ");
INSERT INTO mnv_vpl VALUES ("MK3_2","071_3_2","MRK","3","2","2","Ka noko iai na pegea noko siahahai ke 'atigongo haka makau ia Jesus i ni hai 'anga songo hai e Ia. Tenaa te hai 'anga noko mata pipiki ai e kigatou ia te Ia, i te poi haka ma'ugi e Ia te tangata i te 'Ao oki oki. ");
INSERT INTO mnv_vpl VALUES ("MK3_3","071_3_3","MRK","3","3","3","Ma te hai atu a Jesus ki te tangata noko pege te gima, “Tu'u ake ki 'ago i ba'i pegea!” ");
INSERT INTO mnv_vpl VALUES ("MK3_4","071_3_4","MRK","3","4","4","Kae haka anuanu a Jesus kia te kigatou o hai atu, “Niaa te tuku e na tagangonga ia te kitatou ke hai i te 'Ao oki oki? Ke hai na hai 'anga gaoi po ke hai na hai 'anga songo, ke haka ma'ugi pegea po ke taa pegea?” Ma te he'e mumuna kigatou. ");
INSERT INTO mnv_vpl VALUES ("MK3_5","071_3_5","MRK","3","5","5","Ko Jesus noko ina sehu ma te 'ika'ika kia te kigatou, kae haka gongo songo ma'u ia te kigatou noko mogi toto'a ogatou uso. Kae hai atu ki te tangata, “Hohoga atu tou gima.” Hohoga te gima ma te gaoi hoki te gima. ");
INSERT INTO mnv_vpl VALUES ("MK3_6","071_3_6","MRK","3","6","6","Ma te he uguhi ghali ki haho na Pharisee o bilaabei ma na pegea o Herod, o puge poe hai kigatou kohea na taa 'ia ia Jesus. ");
INSERT INTO mnv_vpl VALUES ("MK3_7","071_3_7","MRK","3","7","7","Ko Jesus ma ona pegea haka ako noko haka 'aatea ki te gano, ma te tata'o ai te 'apitanga mai Galilee. ");
INSERT INTO mnv_vpl VALUES ("MK3_8","071_3_8","MRK","3","8","8","Te 'aso noko gongo ai kigatou ki ba'i hai 'anga noko hai e Jesus, noko 'eha pegea noko boo mai kia te Ia mai Judea, Jerusalem, Idumea, ma na kakai'anga i tegaa pa'asi o te bai mimigo i Jordan, ma na pegea mai na kunga e mugheghi i Tyre ma Sidon. ");
INSERT INTO mnv_vpl VALUES ("MK3_9","071_3_9","MRK","3","9","9","Ma te kaunaki e Jesus 'Ona pegea haka ako ke ngaague he baka kia te Ia, iteme'agaa noko 'api to'a ka ke noka te kukumi 'ia ia te Ia. ");
INSERT INTO mnv_vpl VALUES ("MK3_10","071_3_10","MRK","3","10","10","Iteme'agaa na haka ma'ugi e Ia na pegea masasaki, ma te he 'uku'uku 'aki na pegea masasaki ki mu'a ke he 'osohi kia te Ia. ");
INSERT INTO mnv_vpl VALUES ("MK3_11","071_3_11","MRK","3","11","11","Nimaa i te gholoba noko hiina'i ai na pegea noko iai na haagiki songo kia te Ia, ko kigatou noko hetoki i 'ago ia te Ia o ngengege ake, “Tenaa Koe te Hosa o te 'Aitu!” ");
INSERT INTO mnv_vpl VALUES ("MK3_12","071_3_12","MRK","3","12","12","Ka noko tagango e Ia ia te kigatou ke noka te hogahoga na noho o'Ona. ");
INSERT INTO mnv_vpl VALUES ("MK3_13","071_3_13","MRK","3","13","13","Ko Jesus noko haka neke ki te ogo o ngege i na pegea noko siahai kinai, o boomai kia te Ia. ");
INSERT INTO mnv_vpl VALUES ("MK3_14","071_3_14","MRK","3","14","14","Noko haka pupugu e Ia te tino anga hugu tuma'a e gua pegea o mate e Ia Ona pegea haka to'o ke haka pata kia te Ia, ma te kego haka to'o ma'u e Ia ia te kigatou ke tohi'aki, ");
INSERT INTO mnv_vpl VALUES ("MK3_15","071_3_15","MRK","3","15","15","ma te ke haiga'a taganga kia te kigatou ke pagepage haagiki songo ai. ");
INSERT INTO mnv_vpl VALUES ("MK3_16","071_3_16","MRK","3","16","16","Konei na pegea noko haka pupugu e Ia: Ko Simon, noko mate e Jesus ko Peter, ");
INSERT INTO mnv_vpl VALUES ("MK3_17","071_3_17","MRK","3","17","17","ko James ma te taina ia John, gua hosa o Zebedee, noko mate e Jesus ia te kigaaua ko Boanerges, e gaataki gua Hosa o Hatutigi. ");
INSERT INTO mnv_vpl VALUES ("MK3_18","071_3_18","MRK","3","18","18","Ko Andrew, ma Philip, ma Bartholomew, ma Matthew, ma Thomas, ma James te hosa o Alphaeus, ma Thaddaeus, ma Simon te ‘zealot’, ");
INSERT INTO mnv_vpl VALUES ("MK3_19","071_3_19","MRK","3","19","19","ma Judas Iscariot na haka soko eia ia Jesus. ");
INSERT INTO mnv_vpl VALUES ("MK3_20","071_3_20","MRK","3","20","20","Ma te ugu a Jesus ki te hage kae manga haka putu ma'u kinai te 'apitanga, o he'e tau gholoba kia te Ia ma ona pegea haka ako ke kai ai. ");
INSERT INTO mnv_vpl VALUES ("MK3_21","071_3_21","MRK","3","21","21","Nimaa haka gongo ai ona 'atima'ogi, ma te boo kinai ke kakabe ia te Ia, iteme'agaa noko hai ake na pegea, “Koia kua nimo ana tegeu'a!” ");
INSERT INTO mnv_vpl VALUES ("MK3_22","071_3_22","MRK","3","22","22","Kae hai ake na ako o na tagangonga noko boo iho mai Jerusalem, “Ko Ia e ugu ai a Beelzebub! Ko Ia manga pagepage haagiki songo i na taganga o te haagiki songo.” ");
INSERT INTO mnv_vpl VALUES ("MK3_23","071_3_23","MRK","3","23","23","Ma te ngege atu a Ia ia te kigatou o gea kinai i na haka gaataki: “E hai ke kohea na 'aonga te pagepage e Satan ia Satan?! ");
INSERT INTO mnv_vpl VALUES ("MK3_24","071_3_24","MRK","3","24","24","Te nuku nimaa taki tuha tuha, te nuku na ka he'e tu'u. ");
INSERT INTO mnv_vpl VALUES ("MK3_25","071_3_25","MRK","3","25","25","Te haanau e tasi nimaa taki tuha tuha, te haanau na ka he'e noho 'aki ngatahi. ");
INSERT INTO mnv_vpl VALUES ("MK3_26","071_3_26","MRK","3","26","26","Ka ko Satan nimaa ngatu'a kia te ia launatasi o taki tuha tuha, ko ia ka he'e tu'u; ko ia kua tatae ki te 'otinga o 'ona ");
INSERT INTO mnv_vpl VALUES ("MK3_27","071_3_27","MRK","3","27","27","Tenei tena maa'ogi 'anga, e he'e kitea he pegea 'aonga te hano ki goto i he hage mo'o he pegea to'a o to'o ana me'a, naakupu ki te gii eia te pegea to'a, 'io mugi o kaia'a tena hage. ");
INSERT INTO mnv_vpl VALUES ("MK3_28","071_3_28","MRK","3","28","28","Ko Au e gea maa'ogi kia te koutou: Ko ba'i 'oosongo ma na he igho 'aki 'anga hai e pegea kago haka noka kia te kigatou. ");
INSERT INTO mnv_vpl VALUES ("MK3_29","071_3_29","MRK","3","29","29","Ka koai e igho ki te Spirit Tapu, kago he'e haka noka kinai, koia e saga i te 'oosongo nei ki ba'i 'aso.” ");
INSERT INTO mnv_vpl VALUES ("MK3_30","071_3_30","MRK","3","30","30","Ko Jesus noko konei Ana to'o, iteme'agaa ko kigatou noko konei agatou gegea, “Ko Ia e ugu ai te haagiki songo.” ");
INSERT INTO mnv_vpl VALUES ("MK3_31","071_3_31","MRK","3","31","31","Ma te tatae mai a te tinana ma ona hai taina, o noko manga tutu'u i taha, kae haka to'o e kigatou te pegea o hano ki goto ke hai kia te Ia ke hinaiho. ");
INSERT INTO mnv_vpl VALUES ("MK3_32","071_3_32","MRK","3","32","32","Ka noko ma noho 'aki mugheghi te 'apitanga ia Jesus, ma te hai atu kigatou, “Ko te tinau ma Ou haitaina manga i haho, ma sasaga ia te Koe.” ");
INSERT INTO mnv_vpl VALUES ("MK3_33","071_3_33","MRK","3","33","33","Ma te hai atu a Jesus, “Koai Toku tinana? Koai ma'u Oku taina?” ");
INSERT INTO mnv_vpl VALUES ("MK3_34","071_3_34","MRK","3","34","34","Kae ina ki na pegea manga noho 'aki mugheghi ia te Ia o hai atu, “Konei Toku tinana ma Oku taina! ");
INSERT INTO mnv_vpl VALUES ("MK3_35","071_3_35","MRK","3","35","35","Koai e hai eia nia e siahai kinai a te 'Aitu, koia Toku taina ma Toku tuhahine ma Toku tinana.” ");
INSERT INTO mnv_vpl VALUES ("MK4_1","071_4_1","MRK","4","1","1","Ko Jesus noko haka tu'u ke ako haka hoki i te pa'asi o te gano. Ka te 'apitanga noko haka putu kia te Ia noko hu'ai 'api, ma te hano Ia ki te baka manga tahea i te gano o noho ai. Kae noho 'aki te 'apitanga i te tau aba o te gano. ");
INSERT INTO mnv_vpl VALUES ("MK4_2","071_4_2","MRK","4","2","2","O ako e Ia ia te kigatou ko ba'i me'a i na haka gaataki o hai atu, ");
INSERT INTO mnv_vpl VALUES ("MK4_3","071_4_3","MRK","4","3","3","“Haka gongo mai! Te tangata hai hekau 'umanga noko hano ke lago ana hatu me'a. ");
INSERT INTO mnv_vpl VALUES ("MK4_4","071_4_4","MRK","4","4","4","I te gholoba noko manga lago ai eia na hatu me'a, noko hetoki na hatu me'a ki te aga ba'e o te aga ma te boomai na manu o kai. ");
INSERT INTO mnv_vpl VALUES ("MK4_5","071_4_5","MRK","4","5","5","Hetoki kogaa hatu me'a ki te kunga hatuhatua he'e 'eha kege. Manga ngasogo ghali ake, iteme'agaa noko he'e 'eha kege. ");
INSERT INTO mnv_vpl VALUES ("MK4_6","071_4_6","MRK","4","6","6","Ka te gholoba e sopo ake ai te ga'aa, tutu eia na mi'i ga'akau o maemae, iteme'agaa noko he'e tau aka. ");
INSERT INTO mnv_vpl VALUES ("MK4_7","071_4_7","MRK","4","7","7","Kogaa hatu me'a noko hetoki ki na uso o na mouku hoto hoto o ngaasogo kae manga toghi toghi 'ia na ga'akau nei, ma te he'e tau hua. ");
INSERT INTO mnv_vpl VALUES ("MK4_8","071_4_8","MRK","4","8","8","Kogaa hatu me'a noko hetoki ki te kege gaoi o malubu ake o ngaasogo gaoi o tau hua gaoi, hu'ai 'eha ona hua: kogaa noko katoa haka togu ona hua, katoa haka ono na hua o kogaa, ma te gau (100) na hua o kogaa o sigi i na hatu me'a noko lago.” ");
INSERT INTO mnv_vpl VALUES ("MK4_9","071_4_9","MRK","4","9","9","Ma te hai atu a Jesus, “Koai e hai na taginga ke hakagongo, haka gongo ake ai!” ");
INSERT INTO mnv_vpl VALUES ("MK4_10","071_4_10","MRK","4","10","10","Nimaa i te gholoba noko ma noho launatasi ai Ia, boo Ona pegea haka ako ma gaa pegea noko noho 'aki mugheghi ia te Ia, o he haka anu 'aki kinai i na noho o na haka gaataki. ");
INSERT INTO mnv_vpl VALUES ("MK4_11","071_4_11","MRK","4","11","11","Hai atu a Jesus kia te kigatou, “Kua haiga'a e te 'Aitu kia te koutou nia noko huu i na noho o te Hakahua 'anga a te 'Aitu, kae 'atigongo ki na pegea i taha i ba'i hai 'anga i na haka gaataki. ");
INSERT INTO mnv_vpl VALUES ("MK4_12","071_4_12","MRK","4","12","12","E kogaa na noho, ‘Ko kigatou manga 'aonga te hiina'i, kae he'e tau maatanga. Ko kigatou manga 'aonga te haka gongo, kae he'e tau naa'anga, kigatou kitai go sui tegeu'a, ma te haka noka kinai e te 'Aitu.’ ” ");
INSERT INTO mnv_vpl VALUES ("MK4_13","071_4_13","MRK","4","13","13","Ma te hai atu a Jesus kia te kigatou, “ 'Ai e he'e na'a e koutou te haka gaataki nei? E hai ke go kohea na na'a ma'u e koutou he haka gaataki?” ");
INSERT INTO mnv_vpl VALUES ("MK4_14","071_4_14","MRK","4","14","14","“Na hatu me'a lago e te tangata hai hekau 'umanga e noho pe na haka hegeunga a te 'Aitu. ");
INSERT INTO mnv_vpl VALUES ("MK4_15","071_4_15","MRK","4","15","15","E iai na pegea manga noho pe na hatu me'a e hetoki ki te pa'asi o te aga, e sanga kinai na haka hegeunga a te 'Aitu. Te gholoba e haka gongo kinai kigatou, kae ghali a Satan o a'u o sa'u na haka hegeunga a te 'Aitu noko lago ki ogatou uso. ");
INSERT INTO mnv_vpl VALUES ("MK4_16","071_4_16","MRK","4","16","16","Na hatu me'a noko hetoki ki te kunga hatuhatua e noho pe na haka hegeunga a te 'Aitu i na uso ogaa pegea. Te gholoba e haka gongo kinai e ghali kigatou o to'o o sisia ai. ");
INSERT INTO mnv_vpl VALUES ("MK4_17","071_4_17","MRK","4","17","17","Kae he'e tau aka, ko kigatou e noho 'aki o mi'i taaunga gogoa. Ka nimaa boomai na hakatangi ma te hai songo ia te kigatou i te ghaghi i na haka hegeunga a te 'Aitu, manga ghali o he toki iho. ");
INSERT INTO mnv_vpl VALUES ("MK4_18","071_4_18","MRK","4","18","18","Ka kogaa manga noho pe na hatu me'a noko hetoki ki te uso o na mouku hotohoto, e hakagongo ki na haka hegeunga a te 'Aitu, ");
INSERT INTO mnv_vpl VALUES ("MK4_19","071_4_19","MRK","4","19","19","ka na maikia o te ma'ugi nei ma na pakenga a na ga'unga ma na maa'ina hugihugi 'anga ki ba'i me'a e boo mai o toghitoghi e kigatou, kae hai na haka hegeunga a te 'Aitu i ogatou uso o he'e tau hua. ");
INSERT INTO mnv_vpl VALUES ("MK4_20","071_4_20","MRK","4","20","20","Kogaa, manga noho pe na hatu me'a noko hetoki ki te kege gaoi, e hakagongo ki na haka hegeunga a te 'Aitu. O to'o e kigatou ki 'ogatou uso o hai hua: o katoa haka togu hua, katoa haka ono hua, ma te gau (100) ona hua o sigi i na hatu me'a noko lago.” ");
INSERT INTO mnv_vpl VALUES ("MK4_21","071_4_21","MRK","4","21","21","Ko Jesus noko hai atu kia te kigatou, “ 'E iai he pegea o to'o mai he peba e huu ki gago i he kaupea poe huu ki gago i he besin? E si'ai, ka tuku e koutou te peba ki he me'a tuku peba. ");
INSERT INTO mnv_vpl VALUES ("MK4_22","071_4_22","MRK","4","22","22","Iteme'agaa nia e huu e hai ke haka 'agi, ka nia e poghi e hai ke go ta'aki. ");
INSERT INTO mnv_vpl VALUES ("MK4_23","071_4_23","MRK","4","23","23","Koai e hai na taginga ke hakagongo, haka gongo ake ai!” ");
INSERT INTO mnv_vpl VALUES ("MK4_24","071_4_24","MRK","4","24","24","Ko Ia noko hai atu ma'u kia te kigatou, “Hai tegeu'a gaoi ake ki nia e gongo kinai koutou: Nia manga hai e koutou, e hai ke go hai ma'u kia te koutou o sigi. ");
INSERT INTO mnv_vpl VALUES ("MK4_25","071_4_25","MRK","4","25","25","Iteme'agaa, koai e ga'u me'a, e hai kego haiga'a beegaba kia te ia. Ka koai e he'e ga'u, nia a'ana e ga'u e hai kego sa'u ma'u ia te ia.” ");
INSERT INTO mnv_vpl VALUES ("MK4_26","071_4_26","MRK","4","26","26","Ko Jesus noko hai atu ma'u, “Te Hakahua 'anga a te 'Aitu e konei na noho: Te tangata e lago hatu me'a ki te kege. ");
INSERT INTO mnv_vpl VALUES ("MK4_27","071_4_27","MRK","4","27","27","Te poo ma te 'ao, si'igoa e moe poe 'aga, na hatu me'a manga maalubu o ngaasogo, masi'igoa e he'e na'a eia poe kohea na hai. ");
INSERT INTO mnv_vpl VALUES ("MK4_28","071_4_28","MRK","4","28","28","Te kege te hai launatasi eia te hatu me'a o malubu ake o hai tena hua: mataa hai ona ha'a, ano hai te buli, ano hai te hatu i goto i te buli. ");
INSERT INTO mnv_vpl VALUES ("MK4_29","071_4_29","MRK","4","29","29","I te gholoba e matu'a ai te hua, kae utu eia i te kiba, iteme'agaa kua tatae te 'aso ke utu ai.” ");
INSERT INTO mnv_vpl VALUES ("MK4_30","071_4_30","MRK","4","30","30","Ma te hai hakahoki atu a Jesus, “E hai ke kohea atatou gegea i na noho o te Hakahua 'anga a te 'Aitu? Tehea te haka gaataki ke hogahoga ai? ");
INSERT INTO mnv_vpl VALUES ("MK4_31","071_4_31","MRK","4","31","31","Te Hakahua 'anga a te 'Aitu manga noho pe te mi'i hatu me'a o te ga'akau e ingoa te ‘mustard’. Te hatu me'a nei e boboko o sigi i ba'i hatu me'a e tanu e koutou i te kege. ");
INSERT INTO mnv_vpl VALUES ("MK4_32","071_4_32","MRK","4","32","32","Ka nimaa tanu, e ngasogo ake o hai ai te ga'akau o hua'eha o sigi i ba'i ga'akau i te 'umanga, ona ga'a hu'ai hua'e'eha toto'a, manga 'aonga te boo na manu o te 'agohigangi o haka mapu ai.” ");
INSERT INTO mnv_vpl VALUES ("MK4_33","071_4_33","MRK","4","33","33","Noko 'eha haka gaataki papata ki te haka gaataki nei noko gea ai a Jesus kia te kigatou, na kupu noko 'aonga te na'a e kigatou. ");
INSERT INTO mnv_vpl VALUES ("MK4_34","071_4_34","MRK","4","34","34","Ko Ia noko suga te gea i na me'a kia te kigatou, he'e sigi i te gea i na haka gaataki, ka na 'aso noho'aki soko ai ma Ona pegea haka ako, kae hogahoga kinai e Ia ko ba'i me'a. ");
INSERT INTO mnv_vpl VALUES ("MK4_35","071_4_35","MRK","4","35","35","Nimaa te ahiahi o te 'ao na, kae hai atu a Jesus ki ona pegea haka ako, “Kitatou boo ki tegaa pa'asi o te gano.” ");
INSERT INTO mnv_vpl VALUES ("MK4_36","071_4_36","MRK","4","36","36","Sosopo na pegea haka ako ma Jesus ki te baka kae ti'aki te 'apitanga. Noko tata'o ma'u kogaa 'isi baka ia te Ia. ");
INSERT INTO mnv_vpl VALUES ("MK4_37","071_4_37","MRK","4","37","37","Nimaa haka tu'u te hu'ai huukenga, ma te hati na ngagu ki goto i te baka o honu ai. ");
INSERT INTO mnv_vpl VALUES ("MK4_38","071_4_38","MRK","4","38","38","Ka ko Jesus noko manga moe i mugi i te baka, o haka eke te 'ugu i te 'ugunga. Ma te baa 'aga e kigatou ia te Ia o hai atu, “Ako, 'ai ko Koe e he'e 'agoha kia te kimatou? Ko kitatou ka mamate!” ");
INSERT INTO mnv_vpl VALUES ("MK4_39","071_4_39","MRK","4","39","39","Ma te tu'u ake Ia o susugi te oko, “Ngongoto iho!” Ma te hai atu ki na ngagu, “Magino iho!” Ma te ngongoto te oko kae magino te gano. ");
INSERT INTO mnv_vpl VALUES ("MK4_40","071_4_40","MRK","4","40","40","Ma te hai atu Ia ki ona pegea haka ako, “ 'Eaa e matataku ai koutou? Koutou koi he'e sano kia te Au?” ");
INSERT INTO mnv_vpl VALUES ("MK4_41","071_4_41","MRK","4","41","41","Ma te matataku toto'a kigatou o he haka anuanu 'aki, “Te pegea aa tenei? He'e po na oko ma na ngagu e mangangao kia te Ia!” ");
INSERT INTO mnv_vpl VALUES ("MK5_1","071_5_1","MRK","5","1","1","Ko kigatou noko toghi ki tegaa pa'asi o te gano o hetae ki te kakai 'anga o na pegea o Gerasa. ");
INSERT INTO mnv_vpl VALUES ("MK5_2","071_5_2","MRK","5","2","2","Nimaa sopo ake a Jesus i te baka, hinaiho kinai te tangata uguhia noko manga i na takotonga kigaaua bilaabei ma Jesus. ");
INSERT INTO mnv_vpl VALUES ("MK5_3","071_5_3","MRK","5","3","3","Te tangata nei noko manga kakai i na takotonga. Ka noko he'e 'aonga te gii ma'u e he pegea, he'e 'aonga te gii ma'u i na puni hatu'ugi ma'u. ");
INSERT INTO mnv_vpl VALUES ("MK5_4","071_5_4","MRK","5","4","4","Noko 'eha 'aso gii ai na gima ma na ba'e, kae manga motumotu eia na puni hatu'ugi, ma te tohitohi eia na hatu'ugi noko i na ba'e. Noko he'e 'aonga he pegea te haka suki kinai. ");
INSERT INTO mnv_vpl VALUES ("MK5_5","071_5_5","MRK","5","5","5","Ko ba'i 'ao ma ba'i poo noko manga sehu ai ia i na 'atu takotonga ma na ogo, ma te ngege to'a ma te upi ia te ia i na hatu. ");
INSERT INTO mnv_vpl VALUES ("MK5_6","071_5_6","MRK","5","6","6","Te gholoba na ina 'atu ai kia Jesus mai mama'o, koia na tege kinai o too toko tugi i 'ago ia te Ia. ");
INSERT INTO mnv_vpl VALUES ("MK5_7","071_5_7","MRK","5","7","7","Koia noko ngege to'a o hai atu, “Jesus, te Hosa o te 'Aitu Hu'ai Ma'u'agunga, niaa te hai ke hai e Koe kia te au? Aguagu ake kia te 'Aitu ko Koe ka he'e hai songo ia te au.” ");
INSERT INTO mnv_vpl VALUES ("MK5_8","071_5_8","MRK","5","8","8","Ko ia noko konei ana gea iteme'agaa noko hai atu a Jesus kia te ia, “Ko koe te haagiki songo. Sopo iho i te tangata nei.” ");
INSERT INTO mnv_vpl VALUES ("MK5_9","071_5_9","MRK","5","9","9","Ma te haka anu a Jesus kia te ia o hai atu, “Tehea tou ingoa?” Koia noko haka tau o hai atu, “Toku ingoa ko 'Api To'a, iteme'agaa ko kimatou e hu'ai 'api.” ");
INSERT INTO mnv_vpl VALUES ("MK5_10","071_5_10","MRK","5","10","10","Ma te pau o sasaka a te pegea sasa kia Jesus ke noka te hakato'o ia te kigaatou ke boo i te kungaa. ");
INSERT INTO mnv_vpl VALUES ("MK5_11","071_5_11","MRK","5","11","11","Ka te taha o te ogo noko hitaiaki ki te kunga nei, noko 'eha piki noko maa kai ai. ");
INSERT INTO mnv_vpl VALUES ("MK5_12","071_5_12","MRK","5","12","12","Ma te he sasaka 'aki na haagiki kia Jesus o hai atu, “Tuku mai kimatou boo ki na piki, kimatou boo ki goto ia te kigatou.” ");
INSERT INTO mnv_vpl VALUES ("MK5_13","071_5_13","MRK","5","13","13","Ma te tuku atu e Ia o sosopo iho na haagiki o boo ki na piki o boo o he uguhi ki goto i ogatou uso. Sa'akigoa noko guanga noa tino (2,000) te taunga o na piki, noko he 'agiko ghali iho i te tiha o boo ki te gano o memene ai. ");
INSERT INTO mnv_vpl VALUES ("MK5_14","071_5_14","MRK","5","14","14","Na pegea ge'o piki na he'agiko o he 'atigongo 'aki i te hu'ai manaha ma na manaha i na tahataha, ka te 'apitanga na boo mai ke hiina'i ki nia te kua hai. ");
INSERT INTO mnv_vpl VALUES ("MK5_15","071_5_15","MRK","5","15","15","Te 'aso na boomai ai kigatou kia Jesus, ma te hiina'i ki te tangata noko iai na haagiki kua haka gosigosi o noko manga noho gaoi, i te kua gaoi ana tegeu'a, kae manga matataku ai kigatou. ");
INSERT INTO mnv_vpl VALUES ("MK5_16","071_5_16","MRK","5","16","16","Na pegea noko hiina'i ki nia noko hai e Jesus ki te tangata uguhia, na he 'atigongo 'aki ai ma te he 'atigongo 'aki i na piki ma'u. ");
INSERT INTO mnv_vpl VALUES ("MK5_17","071_5_17","MRK","5","17","17","Ma te he sasaka 'aki a kigatou kia Jesus ke hano i tegatou kakai 'anga. ");
INSERT INTO mnv_vpl VALUES ("MK5_18","071_5_18","MRK","5","18","18","Te gholoba noko sopo a Jesus ki te baka, hinatu kinai te tangata noko uguhia o haka ene kia Jesus ke tata'o ia te Ia. ");
INSERT INTO mnv_vpl VALUES ("MK5_19","071_5_19","MRK","5","19","19","Ka noko he'e maka kinai a Jesus, kae manga hai atu kia te ia, “Hoki atu ki tou manaha o 'atigongo ki ou pegea i te hu'ai hai 'anga kua hai e te 'Agiki kia te koe, ma ana 'agoha 'anga kia te koe.” ");
INSERT INTO mnv_vpl VALUES ("MK5_20","071_5_20","MRK","5","20","20","Ma te hano te tangata nei o haka tu'u 'atigongo i na hu'ai hai 'anga kua hai e Jesus kia te ia i tona kakai 'anga i Decapolis. Ka noko tu'ia ai ko ba'i pegea. ");
INSERT INTO mnv_vpl VALUES ("MK5_21","071_5_21","MRK","5","21","21","Te 'aso noko hoki ai a Jesus ki tegaa pa'asi i te gano, noko haka putu kinai te 'apitanga o pegea i te tau ganga o te gano. ");
INSERT INTO mnv_vpl VALUES ("MK5_22","071_5_22","MRK","5","22","22","Te launatasi i na hakahua o te Hage hai paaunga, tona ingoa ko Jairus, noko a'u ki te kungaa o ina kia Jesus o toko tugi ki na ba'e o'ona. ");
INSERT INTO mnv_vpl VALUES ("MK5_23","071_5_23","MRK","5","23","23","O sasaka kia te Ia o hai atu, “Taku mi'i tama 'ahine e mate, 'ine 'ai manga a'u Koe, hakahua, o tuku kinai ou gima ka ke ma'ugi, ka he'e mate.” ");
INSERT INTO mnv_vpl VALUES ("MK5_24","071_5_24","MRK","5","24","24","Ma te tata'o a Jesus ia te ia. Tata'o te 'apitanga o 'ati tu'u kia te Ia. ");
INSERT INTO mnv_vpl VALUES ("MK5_25","071_5_25","MRK","5","25","25","Ka noko iai te launatasi hahine i te kungaa noko hai tona masaki tu'u te hano na tino i te katoa tuma'a e gua ghapu. ");
INSERT INTO mnv_vpl VALUES ("MK5_26","071_5_26","MRK","5","26","26","Ko ia noko hu'ai tiha'ia maa'ogi i na pegea hetauaki pegea noko 'aabaki kia te ia, ka ko ia ma'u na haiga'a ko ba'i ana mane ke hetauaki tona masaki, ka manga pau o hua'eha hano te masaki o'ona. ");
INSERT INTO mnv_vpl VALUES ("MK5_27","071_5_27","MRK","5","27","27","Te na'a 'anga e ia na hai taganga 'anga a Jesus, ko ia na mugi atu ia te Ia i te uso o te 'apitanga, o 'oso ki tona ake, ");
INSERT INTO mnv_vpl VALUES ("MK5_28","071_5_28","MRK","5","28","28","iteme'agaa koia noko hai tena maanatu, “Poi 'oso au ki ona ake, ko au kua ma'ugi.” ");
INSERT INTO mnv_vpl VALUES ("MK5_29","071_5_29","MRK","5","29","29","Ma te manga ghali o 'oti te hano 'anga na tino kae haka gongo iho ko ia e hakagongo gaoi, e tausu'u i tona tiha'ia. ");
INSERT INTO mnv_vpl VALUES ("MK5_30","071_5_30","MRK","5","30","30","Ma te ghali o na'a e Jesus e hano 'aatea te taganga ia te Ia, ma te takahugi ki te 'apitanga o hai atu, “Koai te 'oso ki oku ake?” ");
INSERT INTO mnv_vpl VALUES ("MK5_31","071_5_31","MRK","5","31","31","Ma te haka tau ona pegea haka ako o hai atu, “Ko Koe e ina ki te 'apitanga e 'ati tu'u kia te Koe. Ka 'eaa e hai mai ai a Koe, ‘Koai te 'oso kia te Au?’ ” ");
INSERT INTO mnv_vpl VALUES ("MK5_32","071_5_32","MRK","5","32","32","Ka manga pau o ligo e Jesus po koai te hai eia te hai 'anga nei. ");
INSERT INTO mnv_vpl VALUES ("MK5_33","071_5_33","MRK","5","33","33","Nimaa na'a e te hahine nia te kua hai kia te ia, ma te a'u popoge i te noko mataku o too toko tugi ki na ba'e o Jesus, kae hai atu, “Koau te 'oso kia te Koe.” ");
INSERT INTO mnv_vpl VALUES ("MK5_34","071_5_34","MRK","5","34","34","Ma te hai atu a Jesus kia te ia, “Tama 'ahine, te sano o'ou kua haka ma'ugi ia te koe. Hinatu ma te goto maagie, na'e kua 'oti tou tiha'ia i tou masaki.” ");
INSERT INTO mnv_vpl VALUES ("MK5_35","071_5_35","MRK","5","35","35","I te gholoba noko maa koi gea ai a Jesus, boomai na pegea i te hage o Jairus, te hakahua o te hage hai paaunga, kia te Ia o hai atu kinai, “Tau tama 'ahine kua mate. E he'e tau tukunga te haka 'oha'oha soo atu te hakahua ma'u.” ");
INSERT INTO mnv_vpl VALUES ("MK5_36","071_5_36","MRK","5","36","36","Ka noko 'ainoa a Jesus ki agatou gegea 'anga o manga hai atu ki te hakahua o te hage hai paaunga, “Noka tau mataku, ka manga too.” ");
INSERT INTO mnv_vpl VALUES ("MK5_37","071_5_37","MRK","5","37","37","Noko he'e tuku e Ia ni pegea ke tata'o ia te Ia, ka manga ko Peter ma James ma te taina ia John. ");
INSERT INTO mnv_vpl VALUES ("MK5_38","071_5_38","MRK","5","38","38","Nimaa hetae kigatou ki te hage o te hakahua o te hage hai paaunga, ko Jesus noko ina ki te 'apitanga o pegea, ma te haka gongo ki tegatou hu'ai tatangi 'anga ma tegatou magepenga. ");
INSERT INTO mnv_vpl VALUES ("MK5_39","071_5_39","MRK","5","39","39","Ma te hano ki goto i te hage o hai atu, “ 'Eaa koutou e he bobo 'aki ma te magegepe toto'a ai? Te tama 'iti'iti nei e he'e mate, ka manga moe.” ");
INSERT INTO mnv_vpl VALUES ("MK5_40","071_5_40","MRK","5","40","40","Kae manga putatai a kigatou kia te Ia. Ma te pagepage e Ia ia te kigatou ki haho. Kae kakabe te tamana ma te tinana o te mi'i hahine ma tena toka togu pegea haka ako o boo ki goto i te kunga noko iai te tama 'iti'iti. ");
INSERT INTO mnv_vpl VALUES ("MK5_41","071_5_41","MRK","5","41","41","'Oso Ia ki te gima o te mi'i hahine o hai atu kia te ia (i te haka hegeunga a na Jew), “Talitha koum!” (E gaataki: “Mi'i hahine, ko Au e hai atu kia te koe, 'aga ake!”) ");
INSERT INTO mnv_vpl VALUES ("MK5_42","071_5_42","MRK","5","42","42","Ma te ghali te hahine o tu'u o sehu. (Te hahine nei noko katoa tuma'a e gua o na ghapu). Ma te hu'ai he tu'ia 'aki ai kigatou. ");
INSERT INTO mnv_vpl VALUES ("MK5_43","071_5_43","MRK","5","43","43","Ma te hai taagango a Jesus kia te kigatou ke noka te 'atigongo i te hai 'anga nei ke na'a e he pegea, kae hai atu ma'u kia te kigatou ke abange ma'ana ni me'a ke kai. ");
INSERT INTO mnv_vpl VALUES ("MK6_1","071_6_1","MRK","6","1","1","Ko Jesus na hano 'aatea i te kungaa, o hoki ki tona manaha, noko manga he tata'o 'aki ai ona pegea haka ako. ");
INSERT INTO mnv_vpl VALUES ("MK6_2","071_6_2","MRK","6","2","2","Nimaa hetae mai te 'Ao oki oki, haka tu'u ako a Jesus i te Hage hai paaunga. Noko 'eha pegea haka gongo kinai o he gege ma'ugi 'aki o hai ake, “Ana akonga nei na hai 'anga mai hea? To'ai te 'igo'igo te haiga'a kia te Ia? O'ai ma'u na taganga te hai e Ia? ");
INSERT INTO mnv_vpl VALUES ("MK6_3","071_6_3","MRK","6","3","3","'Ai he'e tenei okoia te tangata mataisau? 'Ai he'e tenei te tama a Mary, te ta'okete o James ma Joses ma Judas ma Simon? 'Ai he'e konei ona tuhaahine te manga haka pata kia te kitatou?” Ko kigatou na he 'ika'ika 'aki ai kia te Ia. ");
INSERT INTO mnv_vpl VALUES ("MK6_4","071_6_4","MRK","6","4","4","Hai atu a Jesus kia te kigatou, “Te tangata nimaa te taauga kago pago kinai ba'i pegea, ka manga na pegea i tena manaha, ma na 'atima'ogi o'ona, ma tona 'api te he'e pago kinai.” ");
INSERT INTO mnv_vpl VALUES ("MK6_5","071_6_5","MRK","6","5","5","Ko Ia he'e 'aonga te hai taganga i tona manaha, manga haka eke na gima i gua pegea masasaki e gua o maa'ugi. ");
INSERT INTO mnv_vpl VALUES ("MK6_6","071_6_6","MRK","6","6","6","Ko Jesus noko gege ma'ugi ma'u i tegatou he'e sano kia te Ia. Kae hano ki na manaha e noho mugheghi o manga ako sehu ai. ");
INSERT INTO mnv_vpl VALUES ("MK6_7","071_6_7","MRK","6","7","7","Kae hakaputu mai e Jesus tona katoa tuma'a e gua pegea haka ako, haka to'o taki gua ia te kigatou, kae haiga'a kinai na taganga o'Ona ke go sepu ai i na haagiki songo. ");
INSERT INTO mnv_vpl VALUES ("MK6_8","071_6_8","MRK","6","8","8","Ma te tongitongi aki e Jesus ia te kigatou o hai atu, “Noka te to'o me'a i te lango 'anga nei, ka manga te tokotoko, he'e tau utunga, he'e tau tanga, he'e tau mane i autou oko oko. ");
INSERT INTO mnv_vpl VALUES ("MK6_9","071_6_9","MRK","6","9","9","Manga taka ba'e atu, kae noka te to'o beegaba he ake. ");
INSERT INTO mnv_vpl VALUES ("MK6_10","071_6_10","MRK","6","10","10","Te 'aso kago haka pogo 'ia ai koutou ki ni hage, ogo noko noho 'aki atu ai ano hetae ki te 'aso boo o 'outou i te manaha. ");
INSERT INTO mnv_vpl VALUES ("MK6_11","071_6_11","MRK","6","11","11","Ka nimaa iai he manaha kago he'e haka pogo ia te koutou poe he'e sia haka gongo kia te koutou, ogo tutuku atu na tobeabu i outou tapungao i te 'aso kago boo ai koutou, tenei te haka kuu manaba kia te kigatou.” ");
INSERT INTO mnv_vpl VALUES ("MK6_12","071_6_12","MRK","6","12","12","Ma te boo a kigatou o manga tohi'aki ko ba'i pegea e hai kigatou sui tegeu'a. ");
INSERT INTO mnv_vpl VALUES ("MK6_13","071_6_13","MRK","6","13","13","Ko kigatou noko pagepage haagiki songo, ma te gigingi gogo ki ba'i pegea masasaki o maa'ugi ai kigatou. ");
INSERT INTO mnv_vpl VALUES ("MK6_14","071_6_14","MRK","6","14","14","Ko king Herod noko haka gongo i na hai 'anga nei, iteme'agaa te ingoa o Jesus kua na'a ngatahi e ba'i pegea. Noko iai na pegea noko hai ake, “Ko John Baptist kua ma'ugi hoki, tenei te hai 'anga e hu'ai hai taganga ai.” ");
INSERT INTO mnv_vpl VALUES ("MK6_15","071_6_15","MRK","6","15","15","Hai ake kogaa pegea, “Koia ko Elijah.” Ka manga pau kogaa o hai ake, “Koia te taauga, manga noho pe na taauga noko i gaa 'aso.” ");
INSERT INTO mnv_vpl VALUES ("MK6_16","071_6_16","MRK","6","16","16","Ka te 'aso na haka gongo ai a Herod, koia na hai ake, “Ko John na toghi eau te u'a kua ma'ugi hoki?” ");
INSERT INTO mnv_vpl VALUES ("MK6_17","071_6_17","MRK","6","17","17","Iteme'agaa ko Herod te noko kaunaki eia na pegea o he 'osohi kia John o gii o tuku ki te kunga o te kagohia. Noko hai eia te hai 'anga nei ia Herodias, te uguugu o te taina ia Philip na sui ia o pipiki. ");
INSERT INTO mnv_vpl VALUES ("MK6_18","071_6_18","MRK","6","18","18","Ka ko John Baptist noko hai atu kia Herod, “E he'e gaoi ki na tagangonga te pipiki e koe te uguugu o te taiu.” ");
INSERT INTO mnv_vpl VALUES ("MK6_19","071_6_19","MRK","6","19","19","Tenei te hai 'anga na pau a Herodias o na'a makau ai kia John, ma te siahai ia ke taa, ka noko he'e kitea na taa eia. ");
INSERT INTO mnv_vpl VALUES ("MK6_20","071_6_20","MRK","6","20","20","Iteme'agaa ko Herod noko pago kia te ia ma te ge'o ia te ia, noko na'a ma'u eia te tangata tinogaoi ma te 'esi'esi. Ko Herod noko ta'anga haka gongo kia John o hu'ai sopo manaba, ka noko manga sia haka gongo kia te ia. ");
INSERT INTO mnv_vpl VALUES ("MK6_21","071_6_21","MRK","6","21","21","Hano ano ma na'akina a Herodias o hai tena 'aso gaoi i te 'aso noko sopo ai a Herod, na hai ai tena haka tahinga ki ba'i hakahua o te gahumanu, ma ba'i tugi tau'a, ma ba'i hutiaki o Galilee. ");
INSERT INTO mnv_vpl VALUES ("MK6_22","071_6_22","MRK","6","22","22","Te gholoba na hinake ai te tama 'ahine a Herodias o tau'aso. Na hu'ai magagaohie ai a Herod ma 'ana usunga. Ma te hai atu a Herod kia te ia, “Haka ene mai kia te au po nia e siahai kinai koe, na'e hai kau 'abatu 'ia kia te koe.” ");
INSERT INTO mnv_vpl VALUES ("MK6_23","071_6_23","MRK","6","23","23","Ma te aguagu a Herod kae tuku kupu o hai atu, “Niaa e hai ke haka ene ai koe, e hai kau 'abatu 'ia kia te koe, he'e po te siahai mo'ou tasi pa'asi i te nuku o'oku nei, manga 'aonga te hai.” ");
INSERT INTO mnv_vpl VALUES ("MK6_24","071_6_24","MRK","6","24","24","Te hahine nei na hano ki haho o hai atu kia te tinana, “Niaa te hai kau haka ene ai?” Ma te hai atu a te tinana, “Haka ene atu i te 'ugu o John Baptist.” ");
INSERT INTO mnv_vpl VALUES ("MK6_25","071_6_25","MRK","6","25","25","Te hahine nei na hoki ghali kia Herod, ma tena haka enenga o hai atu, “Koau e siahai ke 'aumai e koe te 'ugu o John Baptist i he peleti kia te au i te gholoba nei.” ");
INSERT INTO mnv_vpl VALUES ("MK6_26","071_6_26","MRK","6","26","26","Ma te hu'ai haka gongo songo to'a ai a Herod, ka noko baghaghinga e tena tuku kupu 'anga i 'ago i ba'i pegea noko kai haka pigi kia te ia, na he'e siahai ke haka si'ai eia te haka ene 'anga a te hahine. ");
INSERT INTO mnv_vpl VALUES ("MK6_27","071_6_27","MRK","6","27","27","Ma te ghali a Herod o kaunaki te tangata taa pegea ke hano o to'o mai te 'ugu o John. Ka na hano te tangata nei ki te kunga o na pegea kagohia, o toghi ai te u'a o John, ");
INSERT INTO mnv_vpl VALUES ("MK6_28","071_6_28","MRK","6","28","28","o to'o ake te 'ugu i te peleti o haiga'a ki te hahine nei, ma te to'o eia o 'abange kia te tinana ia Herodias. ");
INSERT INTO mnv_vpl VALUES ("MK6_29","071_6_29","MRK","6","29","29","Nimaa i te 'aso na haka gongo ai na pegea haka ako o John i te hai 'anga nei, na boo kigatou o to'o te tino o John o tanu. ");
INSERT INTO mnv_vpl VALUES ("MK6_30","071_6_30","MRK","6","30","30","Na pegea haka to'o na giu mai o haka putu kia Jesus o hogahoga kia te Ia ko ba'i hai 'anga hai ma te ako e kigatou. ");
INSERT INTO mnv_vpl VALUES ("MK6_31","071_6_31","MRK","6","31","31","Noko 'api pegea boomai ma te giu o hai ia te kigatou o he'e tau gholoba kigatou kai ai, ma te hai atu a Jesus kia te kigatou, “Koutou tata'o soko mai ia te Au ki he kunga tausu'u ka koutou he okioki 'aki ai.” ");
INSERT INTO mnv_vpl VALUES ("MK6_32","071_6_32","MRK","6","32","32","Ma te boo soko i te baka ki te kunga gaabaki, ");
INSERT INTO mnv_vpl VALUES ("MK6_33","071_6_33","MRK","6","33","33","ka noko 'api pegea hiina'i ki tegatou haka 'ui 'anga, o haka 'igonga e kigatou ma te 'eha pegea he 'agiko i ogatou ba'e o boo i ba'i manaha o 'agu tu'a ia te kigatou ano mataa hetae ki te kunga noko boo kinai. ");
INSERT INTO mnv_vpl VALUES ("MK6_34","071_6_34","MRK","6","34","34","Te sopo ake 'anga a Jesus, o ina ki te 'apitanga kua 'oti i te haka putu, ko Ia na hu'ai 'agoha kia te kigatou, iteme'agaa ko kigatou noko manga noho pe na sipisipi he'e tau pegea ge'o, ma te ako e Ia ia te kigatou i na me'a 'eha. ");
INSERT INTO mnv_vpl VALUES ("MK6_35","071_6_35","MRK","6","35","35","Ka te gholoba nei kua ahiahi, ma te boomai ona pegea haka ako o hai atu kia te Ia, “Te kunga gaabaki tenei, kae kua poo ma'u. ");
INSERT INTO mnv_vpl VALUES ("MK6_36","071_6_36","MRK","6","36","36","Kaunaki atu na pegea nei kigatou ke boo ki ni kunga ma na manaha e hitaiaki mai ke tau'i ai ma'agatou ni utunga ke kai.” ");
INSERT INTO mnv_vpl VALUES ("MK6_37","071_6_37","MRK","6","37","37","Ma te haka tau kinai a Jesus o hai atu, “ 'Abatu e koutou ma'agatou ni me'a ke kai.” Ma te haka tau kigatou kia te Ia o hai atu, “ 'Ai e hai kimatou boo o tau'i 'ia ni utunga i he guanga gau mane siliva ke haangai ai?” ");
INSERT INTO mnv_vpl VALUES ("MK6_38","071_6_38","MRK","6","38","38","Ma te hai atu a Jesus kia te kigatou, “ 'E hia utunga e hai e koutou? 'Ai boo atu o ligo.” Nimaa na'a e kigatou, na giu mai o hai atu, “Te toka gima bred ma te toka gua mi'i kaui.” ");
INSERT INTO mnv_vpl VALUES ("MK6_39","071_6_39","MRK","6","39","39","Ma te kaunaki e Jesus ona pegea haka ako o hai te 'apitanga ke taki noho 'aki i na tu'uganga ki te mutie. ");
INSERT INTO mnv_vpl VALUES ("MK6_40","071_6_40","MRK","6","40","40","Taki noho 'aki i na tu'uganga, noko hai na kunga tino te gau, kae hai na kunga tino gima. ");
INSERT INTO mnv_vpl VALUES ("MK6_41","071_6_41","MRK","6","41","41","Ma te sa'u ake e Jesus te toka gima bred ma te toka gua kaui, o ina haka tu'u ki te gangi, o haka 'aue kia te 'Aitu, kae tohitohi na bred o 'abatu ki ona pegea haka ako ke tuku atu ki te 'apitanga. Konei na tuha atu ma'u e Ia gua kaui ki te 'apitanga. ");
INSERT INTO mnv_vpl VALUES ("MK6_42","071_6_42","MRK","6","42","42","Ko kigatou ngatahi na kai ano maakokona. ");
INSERT INTO mnv_vpl VALUES ("MK6_43","071_6_43","MRK","6","43","43","Kae haka putu e na pegea haka ako na momo toe bred ma na momo toe kaui noko noho, o tape o katoa tuma'a e gua ona kete. ");
INSERT INTO mnv_vpl VALUES ("MK6_44","071_6_44","MRK","6","44","44","Te taunga o na taangata noko kai nei noko gimanga noa. ");
INSERT INTO mnv_vpl VALUES ("MK6_45","071_6_45","MRK","6","45","45","Ghali a Jesus o hai ona pegea haka ako o heketi ki te baka o mumu'a ki tegaa pa'asi o te gano ki Bethsaida. Kae kaunaki e Ia te 'apitanga o taki giu. ");
INSERT INTO mnv_vpl VALUES ("MK6_46","071_6_46","MRK","6","46","46","Kae hano a Jesus ki te ogo ke taakunga ai. ");
INSERT INTO mnv_vpl VALUES ("MK6_47","071_6_47","MRK","6","47","47","Te hano 'anga ki te poo, te baka noko manga i te uso o te gano, ka ko Ia noko manga launatasi i te 'aamonga. ");
INSERT INTO mnv_vpl VALUES ("MK6_48","071_6_48","MRK","6","48","48","Ko Ia na ina 'atu ona pegea haka ako noko maa tiha'ia i na hoe, iteme'agaa na oko noko pusi to'a ia te kigatou. Nimaa i te nui ki te 'ao, hano a Jesus kia te kigatou, o manga hano i te huka o te gano, ka noko sa'akigoa ko Ia e hai ke sigi ia te kigatou. ");
INSERT INTO mnv_vpl VALUES ("MK6_49","071_6_49","MRK","6","49","49","Ka te hiina'i atu kigatou kia te Ia manga sehu i te huka o te gano, na tegeu'a ake kigatou, ko Ia te 'atua. Ko kigatou na he 'usee 'aki, ");
INSERT INTO mnv_vpl VALUES ("MK6_50","071_6_50","MRK","6","50","50","iteme'agaa ko kigatou na hiina'i ngatahi kia te Ia, o hu'ai matataku. Ma te ghali a Jesus o ngege atu kia te kigatou o hai atu, “Toka mananaba ake, na'e ko Au. Noka te matataku!” ");
INSERT INTO mnv_vpl VALUES ("MK6_51","071_6_51","MRK","6","51","51","Ma te sopo ake kia te kigatou i te baka, kae ngongoto te oko. Ko kigatou na hu'ai he gege ma'ugi 'aki ai, ");
INSERT INTO mnv_vpl VALUES ("MK6_52","071_6_52","MRK","6","52","52","iteme'agaa noko he'e na'a e kigatou te gaataki o nia noko hai ki na utunga, iteme'agaa noko mogi ogatou uso. ");
INSERT INTO mnv_vpl VALUES ("MK6_53","071_6_53","MRK","6","53","53","Te gholoba na boo ai kigatou ki tegaa pa'asi i te gano o hetae ki Gennesaret o tu'u ai te haka taupapa. ");
INSERT INTO mnv_vpl VALUES ("MK6_54","071_6_54","MRK","6","54","54","Te gholoba noko sosopo ake ai kigatou i te baka, manga haka 'igonga ghali e kigatou ia Jesus. ");
INSERT INTO mnv_vpl VALUES ("MK6_55","071_6_55","MRK","6","55","55","He 'agiko kigatou ki ba'i manaha i te kakai 'anga, o 'amo mai ba'i pegea masasaki i ogatou kaainga, o to'o mai ki na kunga e haka gongo kigatou manga iai a Jesus. ");
INSERT INTO mnv_vpl VALUES ("MK6_56","071_6_56","MRK","6","56","56","Ka ko ba'i kunga hano kinai a Jesus, i na mi'i manaha ma na hu'ai manaha ma na kakai 'anga, noko manga tuku e kigatou na pegea masasaki i na uso o na kunga he tau'i 'aki me'a. Haka ene 'aki kigatou kia Jesus, ke tuku ia te kigatou ke manga he 'osohi ki na kapa o tena ake. Ka ko ba'i pegea he 'osohi kia te Ia na maa'ugi. ");
INSERT INTO mnv_vpl VALUES ("MK7_1","071_7_1","MRK","7","1","1","Na Pharisee ma kogaa pegea i na ako o na tagangonga noko boo iho mai Jerusalem, noko haka putu ake kia Jesus. ");
INSERT INTO mnv_vpl VALUES ("MK7_2","071_7_2","MRK","7","2","2","Ma te hiina'i kigatou ki kogaa i Ona pegea haka ako, manga kai agatou utunga i na gima “ 'ugi”, he'e huhu'i. ");
INSERT INTO mnv_vpl VALUES ("MK7_3","071_7_3","MRK","7","3","3","(Iteme'agaa na Pharisee ma gaa Jew, noko manga mataa huhu'i ogatou gima ke hai na paaunga a ogatou hai tupuna, 'io mugi o kai. ");
INSERT INTO mnv_vpl VALUES ("MK7_4","071_7_4","MRK","7","4","4","Na 'aso giu mai ai i na kunga tau'i me'a, ko kigatou e he'e 'aonga te kai ma'u, naakupu ki te mataa huhu'i. Kae pipiki ma'u kigatou kogaa 'isi huhuta a na haitupuna, te mataa huhu'i ba'i me'a hai utunga, na kapu ma na me'a pipiki bai ma na ketolo.) ");
INSERT INTO mnv_vpl VALUES ("MK7_5","071_7_5","MRK","7","5","5","Na Pharisee ma na ako o na tagangonga noko he haka anuanu 'aki kia Jesus o hai atu, “Tehea te hai 'anga e he'e tata'o tu'a ai ou pegea haka ako i na paaunga o na haitupuna, ka manga kai utunga he'e huhu'i gima?” ");
INSERT INTO mnv_vpl VALUES ("MK7_6","071_7_6","MRK","7","6","6","Haka tau kinai a Jesus o hai atu, “Ko Isaiah noko maa'ogi i tena taauga 'anga o taga gongo ia te koutou na pegea haka hagehage, noko kogaa ana to'o: ‘Na pegea nei manga haka 'eha 'eha ia te Au i ogatou gau ngutu, ka ogatou hinangago hu'ai mama'o ia te Au. ");
INSERT INTO mnv_vpl VALUES ("MK7_7","071_7_7","MRK","7","7","7","Ko kigatou manga muna o sogi kia te Au, agatou akonga na tagangonga ako e pegea.’ ");
INSERT INTO mnv_vpl VALUES ("MK7_8","071_7_8","MRK","7","8","8","Koutou kua ti'aki e koutou na tagangonga a te 'Aitu, ka manga pipiki e koutou na paaunga mai a pegea.” ");
INSERT INTO mnv_vpl VALUES ("MK7_9","071_7_9","MRK","7","9","9","Kae hai atu ma'u a Jesus kia te kigatou, “Koutou e hu'ai hai tuupau e koutou te hai ti'aki 'anga na tagangonga a te 'Aitu, ka ke manga pipiki na paaunga a'autou. ");
INSERT INTO mnv_vpl VALUES ("MK7_10","071_7_10","MRK","7","10","10","Iteme'agaa na tagangonga a Moses noko hai ake: ‘Hakae'eha atu ia te tamau ma te tinau,’ ma te hai ake ma'u, ‘He pegea e baa logho ia te tamana po ko te tinana, e hai ke taa ke mate.’ ");
INSERT INTO mnv_vpl VALUES ("MK7_11","071_7_11","MRK","7","11","11","Kae hai ake koutou, te pegea nimaa hai atu kia te tamana po ko te tinana: ‘Nia ka 'aabaki kia te kougua mano e ga'u mai ia te au te “Corban” ’, (e gaataki: te ga'a hakapau kia te 'Aitu). ");
INSERT INTO mnv_vpl VALUES ("MK7_12","071_7_12","MRK","7","12","12","Te pegea nei e tuku e koutou o he'e tau 'aabakinga kia te tamana po kia te tinana. ");
INSERT INTO mnv_vpl VALUES ("MK7_13","071_7_13","MRK","7","13","13","Kua haka noka e koutou na haka hegeunga a te 'Aitu, i autou paaunga manga pipiki haka hano hano e koutou nei, hu'ai 'eha me'a konaa na noho, manga hai ma'u e koutou.” ");
INSERT INTO mnv_vpl VALUES ("MK7_14","071_7_14","MRK","7","14","14","Ngege hakahoki a Jesus i te 'apitanga o haka putu giu mai kia te Ia, o hai atu kia te kigatou, “Haka gongo mai kia te Au, koutou ngatahi, o na'a gaoi te hai 'anga nei: ");
INSERT INTO mnv_vpl VALUES ("MK7_15","071_7_15","MRK","7","15","15","E si'ai ni me'a mai taha ke boo ki goto i he pegea e 'aonga te baa 'ugi ia te ia, ka manga na me'a e sosopo ake i te uso te baa 'ugi ia te ia. ");
INSERT INTO mnv_vpl VALUES ("MK7_16","071_7_16","MRK","7","16","16","Koai e hai na taginga, tuku ake ke haka gongo ai!” ");
INSERT INTO mnv_vpl VALUES ("MK7_17","071_7_17","MRK","7","17","17","Mugi i te hano 'anga a Jesus i te 'apitanga o ugu ki goto i te hage, he haka anuanu 'aki kinai o na pegea haka ako i te haka gaataki nei. ");
INSERT INTO mnv_vpl VALUES ("MK7_18","071_7_18","MRK","7","18","18","Hai atu kinai a Jesus, “ 'Ai koutou e pau o he'e na'a me'a? 'Ai koi he'e na'a e koutou? E si'ai ni me'a mai taha boo ki goto i he pegea, e 'aonga te baa 'ugi ia te ia. ");
INSERT INTO mnv_vpl VALUES ("MK7_19","071_7_19","MRK","7","19","19","Iteme'agaa e he'e boo ki te uso, ka manga boo ki goto i te tina'e, 'io mugi o sosopo ki taha i te tino.” (Te gea 'anga a Jesus nei, na gea haka maahoga ko ba'i utunga e-“ma'a”.) ");
INSERT INTO mnv_vpl VALUES ("MK7_20","071_7_20","MRK","7","20","20","Ko Jesus noko gea soo atu ma'u, “Nia e sopo ake i te uso o te pegea, tenei te me'a e baa 'ugi ia te ia. ");
INSERT INTO mnv_vpl VALUES ("MK7_21","071_7_21","MRK","7","21","21","Iteme'agaa ko goto i na uso o pegea e sosopo ake ai: Na tegeu'a maase'i, ma te hai maasoko a taangata ma haahine, ma te kaia'a, ma te he taa 'aki o mamate, ma te masoko na pegea hai uguugu ma te hai matu'a, ");
INSERT INTO mnv_vpl VALUES ("MK7_22","071_7_22","MRK","7","22","22","ma te maa'ina, ma te siahai ki te hai songo pegea, ma te pake, ma te he siahahai 'aki maase'i a taangata ma haahine, ma te 'i'ita, ma te baa songo kogaa pegea, ma te haka 'eha'eha, ma te haka tugihu'u. ");
INSERT INTO mnv_vpl VALUES ("MK7_23","071_7_23","MRK","7","23","23","Ko ba'i hai 'anga songo toto'a nei e sosopo ake i goto i na uso o pegea o baa 'ugi ia pegea.” ");
INSERT INTO mnv_vpl VALUES ("MK7_24","071_7_24","MRK","7","24","24","Ko Jesus noko hano i te kunga na o hano ki na kakai 'anga e pata i Tyre. Ko Ia noko hano ki goto i te hage, o he'e siahai ke na'a e he pegea ko Ia manga i goto, ka noko he'e 'aonga te ngigo. ");
INSERT INTO mnv_vpl VALUES ("MK7_25","071_7_25","MRK","7","25","25","Noko manga konei na noho, ka te gongo 'anga ai te hahine noko hai tena tama'ahine uguhia, koia na a'u o too ki na ba'e o Jesus. ");
INSERT INTO mnv_vpl VALUES ("MK7_26","071_7_26","MRK","7","26","26","Te hahine nei te pegea mai Greece, te pegea sopo i te hanohano mai Syro phoenicea, koia noko sasaka kia Jesus ke pagepage te haagiki songo ia tena tama 'ahine. ");
INSERT INTO mnv_vpl VALUES ("MK7_27","071_7_27","MRK","7","27","27","Konei na haka tau a Jesus ki te hahine, “E hai ke mataa tuku na tama giki ke kai 'io makokona, iteme'agaa e he'e gaoi te seu na utunga ana tama giki ma'a na tokitoki.” ");
INSERT INTO mnv_vpl VALUES ("MK7_28","071_7_28","MRK","7","28","28","Ka noko haka tau te hahine nei o hai atu, “Hakahua e maa'ogi, ka na tokitoki e ta'anga kai ma'u i na momo utunga tutuku iho i na tama giki ki na gago kaupea.” ");
INSERT INTO mnv_vpl VALUES ("MK7_29","071_7_29","MRK","7","29","29","Ma te konei na to'o a Jesus kia te ia, “Baaghaghi e tau haka tau e gaoi na, ma 'aonga tau hoki, na'e te haagiki songo kua hano 'aatea i tau tama 'ahine.” ");
INSERT INTO mnv_vpl VALUES ("MK7_30","071_7_30","MRK","7","30","30","Te hahine na hoki ki tona manaha o kite i tena tama 'ahine manga moe i tona kaainga, ka kua hano 'aatea te haagiki songo ia te ia. ");
INSERT INTO mnv_vpl VALUES ("MK7_31","071_7_31","MRK","7","31","31","Ko Jesus na hoki i na kakai 'anga e pata i Tyre o agatu'u i Sidon, o iho ki te gano i Galilee, ma te kakai 'anga i Decapolis. ");
INSERT INTO mnv_vpl VALUES ("MK7_32","071_7_32","MRK","7","32","32","Hakakabe ake e na pegea te tangata tugi kae he'e gea, o he sasaka 'aki kia Jesus ke haka eke te gima i te tangata nei. ");
INSERT INTO mnv_vpl VALUES ("MK7_33","071_7_33","MRK","7","33","33","Ma te kakabe e Jesus ia te ia o haka 'aatea i te 'apitanga, o tuku na maninia gima ki gua taginga o te tangata nei, kae nga'esu o tuku ki te 'agego o te tangata nei. ");
INSERT INTO mnv_vpl VALUES ("MK7_34","071_7_34","MRK","7","34","34","Ina haka tu'u Ia ki te gangi, o manaba gege, kae hai atu kia te ia, i te hegeunga a Jew “Ephphatha” (e gaataki “Luga ake”). ");
INSERT INTO mnv_vpl VALUES ("MK7_35","071_7_35","MRK","7","35","35","Ma te lugaluga gua taginga o te tangata nei, kae ma'ama'a te 'agego o gea gaoi. ");
INSERT INTO mnv_vpl VALUES ("MK7_36","071_7_36","MRK","7","36","36","Ma te susugi e Jesus ia te kigatou ke noka te he 'atigongo 'aki ki ni pegea i te hai 'anga nei, ka noko manga gonga'a te susugi atu, ka manga haka soso atu 'agaatou hegeu 'anga kinai. ");
INSERT INTO mnv_vpl VALUES ("MK7_37","071_7_37","MRK","7","37","37","Ko ba'i pegea noko haka gongo ai, ko kigatou noko tutahi agaatou he gege ma'ugi 'aki ai 'anga o hai ake, “Kua hai e Ia ba'i me'a o gaoi. E hai ma'u e Ia na pegea tugi o haka gongo ma na pegea he'e gegea o gegea.” ");
INSERT INTO mnv_vpl VALUES ("MK8_1","071_8_1","MRK","8","1","1","Na 'ao na, noko haka putu giu ai te 'apitanga kia Jesus, ka naato'o i te noko he'e tau utunga, haka putu mai e Jesus ona pegea haka ako o hai atu kinai, ");
INSERT INTO mnv_vpl VALUES ("MK8_2","071_8_2","MRK","8","2","2","“Ko Au e hu'ai 'agoha ki te 'apitanga nei, ia te kigatou kua haka pata kia te Au ano te poo togu nei, kae he'e tau utunga ke kai. ");
INSERT INTO mnv_vpl VALUES ("MK8_3","071_8_3","MRK","8","3","3","Ka nimaa he'e haangai e Au, ka manga tuku o giu e ongea 'aki ki 'ogatou manaha, ka manga sesemu i te agatu'u, iteme'agaa e iai na pegea ia te kigatou e boomai i na kunga mama'o.” ");
INSERT INTO mnv_vpl VALUES ("MK8_4","071_8_4","MRK","8","4","4","Haka tau kinai Ona pegea haka ako o hai atu, “Kae hai ke kohea na hai ni utunga i te kunga gaabaki nei ke haangai ai te 'apitanga?” ");
INSERT INTO mnv_vpl VALUES ("MK8_5","071_8_5","MRK","8","5","5","Ma te haka anu atu a Jesus, “E toka hia bred ma hai e koutou?” Ma te haka tau kigatou o hai atu, “E toka hitu bred.” ");
INSERT INTO mnv_vpl VALUES ("MK8_6","071_8_6","MRK","8","6","6","Ma te hai atu a Jesus ki te 'apitanga ke noho 'aki ki te kege, kae sa'u ake e Ia te toka hitu bred o haka 'aue ai kia te 'Aitu, 'io tohitohi e Ia o 'abatu ki ona pegea haka ako ke tuha ki te 'apitanga, o tuhatuha e kigatou. ");
INSERT INTO mnv_vpl VALUES ("MK8_7","071_8_7","MRK","8","7","7","Noko hai ma'u e kigatou gua mi'i kaui e gua, noko haka 'aue ma'u ai a Jesus, kae tuku atu ma'u ki ona pegea haka ako o tuhatuha ki te 'apitanga. ");
INSERT INTO mnv_vpl VALUES ("MK8_8","071_8_8","MRK","8","8","8","Na pegea nei na kai ano maakokona. Mugi na pegea haka ako o haka putu na momo utunga noko toe o tape i te toka hitu kete o hohonu. ");
INSERT INTO mnv_vpl VALUES ("MK8_9","071_8_9","MRK","8","9","9","Te haka putunga nei noko haanga noa taangata. Na tuku e Jesus ia te kigatou o taki giu. ");
INSERT INTO mnv_vpl VALUES ("MK8_10","071_8_10","MRK","8","10","10","Ko Ia ma ona pegea haka ako na heketi i te baka o boo ki te kakai 'anga i Dalmanutha. ");
INSERT INTO mnv_vpl VALUES ("MK8_11","071_8_11","MRK","8","11","11","Boo mai na Pharisee o haka anuanu 'aki kia Jesus, ke hai lobo ia te Ia. Ko kigatou noko haka ene 'aki kinai ni haka 'igonga mai te gangi. ");
INSERT INTO mnv_vpl VALUES ("MK8_12","071_8_12","MRK","8","12","12","Ka ko Jesus na manaba gege kae hai atu, “ 'Eaa e haka ene 'aki ai te 'atu tangata nei he haka 'igonga haingata'a? Ko Au e gea maa'ogi kia te koutou: Ka si'ai he haka 'igonga kau haiga'a 'ia kia te koutou.” ");
INSERT INTO mnv_vpl VALUES ("MK8_13","071_8_13","MRK","8","13","13","Kae hano ia te kigatou, o hoki ki te baka o toghi ki tegaa pa'asi i te gano. ");
INSERT INTO mnv_vpl VALUES ("MK8_14","071_8_14","MRK","8","14","14","Na pegea haka ako na he'e maanatu ke to'o ni utunga, manga te launatasi bred te noko manga hai e kigatou i te baka. ");
INSERT INTO mnv_vpl VALUES ("MK8_15","071_8_15","MRK","8","15","15","Ma te haka kuu manaba e Jesus ia te kigatou o hai atu, “Ge'o gaoi atu ma te na'ana'a ki na me'a haka tupu bred a na Pharisee ma a'a te hakahua ia Herod.” ");
INSERT INTO mnv_vpl VALUES ("MK8_16","071_8_16","MRK","8","16","16","Ma te hegeu soko kigatou o hai ake, “E konei ana gea ia te kitatou kua he'e tau utunga.” ");
INSERT INTO mnv_vpl VALUES ("MK8_17","071_8_17","MRK","8","17","17","Ka noko na'a e Jesus tegatou konei na hegeu 'anga, ma te haka anu atu kia te kigatou, “ 'Eaa e ba'aki ai koutou ki te he'e tau utunga 'anga? 'Ai koutou koi he'e hiina'i ma te he'e na'a? 'Ai na uso o'outou manga koi mogi? ");
INSERT INTO mnv_vpl VALUES ("MK8_18","071_8_18","MRK","8","18","18","'Ai koutou manga hai outou mata kae he'e hiina'i, ma na taginga kae he'e haka gongo?! Koutou kua he'e maanatu ma'u?! ");
INSERT INTO mnv_vpl VALUES ("MK8_19","071_8_19","MRK","8","19","19","Te 'aso noko tohitohi ai e Au te toka gima bred o 'abange ki te gimanga noa taangata, noko toka hia kete noko honu i na momo utunga noko tibu e koutou?” Ma te haka tau kigatou o hai atu, “Noko katoa tuma'a e gua.” ");
INSERT INTO mnv_vpl VALUES ("MK8_20","071_8_20","MRK","8","20","20","“Ka te tohitohi 'anga e Au te toka hitu bred ki te haanga noa taangata, noko toka hia kete noko honu i na momo utunga noko tibu e koutou?” Ma te haka tau kigatou o hai atu, “Noko toka hitu.” ");
INSERT INTO mnv_vpl VALUES ("MK8_21","071_8_21","MRK","8","21","21","Ma te haka tau a Jesus kia te kigatou o hai atu, “Manga koi he'e na'a e koutou?” ");
INSERT INTO mnv_vpl VALUES ("MK8_22","071_8_22","MRK","8","22","22","Ko kigatou noko boo mai ki Bethsaida, kae kakabe ake e na pegea te tangata kibi o he sasaka 'aki kia Jesus ke 'oso kia te ia. ");
INSERT INTO mnv_vpl VALUES ("MK8_23","071_8_23","MRK","8","23","23","Ma te tau a Jesus i te gima o te tangata kibi o kakabe ki taha i te manaha nei. Te gholoba noko nga'esu ai a Jesus ki na mata o te tangata kibi nei, kae haka eke gua gima ia te ia kae hai atu, “Ko koe e ina ki he me'a?” ");
INSERT INTO mnv_vpl VALUES ("MK8_24","071_8_24","MRK","8","24","24","Koia noko haka tu'u o hai ake, “Koau e ina ki na pegea, manga sa'akigoa na tino ga'akau manga he boo boo 'aki.” ");
INSERT INTO mnv_vpl VALUES ("MK8_25","071_8_25","MRK","8","25","25","Ma te tuku haka hoki gua gima o Jesus ki gua mata o te tangata, ma te lugaluga gua mata o'ona, na maatanga a'ana kua gaoi haka hoki, kae ina maahoga ai ki ba'i me'a. ");
INSERT INTO mnv_vpl VALUES ("MK8_26","071_8_26","MRK","8","26","26","Ma te haka to'o e Jesus o hoki ki tena manaha kae hai atu kia te ia, “Noka tau hano ki te manaha.” ");
INSERT INTO mnv_vpl VALUES ("MK8_27","071_8_27","MRK","8","27","27","Ko Jesus ma ona pegea haka ako noko boo ki na manaha e pata i te kakai 'anga i Caesarea Philippi. Te gholoba noko manga koi boo ai i te agatu'u, kae haka anu atu a Jesus kia te kigatou, “E hai mai te 'apitanga ko Au koai?” ");
INSERT INTO mnv_vpl VALUES ("MK8_28","071_8_28","MRK","8","28","28","Na pegea haka ako noko hai atu, “E hai mai kogaa, ko Koe ko John Baptist, kae hai mai kogaa, ko Koe ko Elijah, ka manga hai ake kogaa, ko Koe te launatasi i na taauga.” ");
INSERT INTO mnv_vpl VALUES ("MK8_29","071_8_29","MRK","8","29","29","Ma te hesigi a Jesus kia te kigatou o hai atu, “Kae hai mai koutou ko Au koai?” Ma te haka tau a Peter o hai atu, “Ko Koe te 'Agiki Taga'ia.” ");
INSERT INTO mnv_vpl VALUES ("MK8_30","071_8_30","MRK","8","30","30","Ma te susugi e Jesus ia te kigatou ke noka te he 'atigongo 'aki ki ni pegea ia te Ia. ");
INSERT INTO mnv_vpl VALUES ("MK8_31","071_8_31","MRK","8","31","31","Ko Jesus noko haka tu'u ako ia te kigatou o hai atu, “Te Hosa o Pegea e hai ke go tiha'ia i ba'i hai 'anga, ma te hai ke go he'e sia hahai ma'u kinai na 'agiki ma na tugi o na priest, ma na ako o na tagangonga. Ko Ia e hai ke go ta'ia ma'u, ka nimaa go i te togunga 'ao, kae ma'ugi hoki.” ");
INSERT INTO mnv_vpl VALUES ("MK8_32","071_8_32","MRK","8","32","32","Ko Jesus noko gea haka maahoga i na me'a nei, ma te kakabe 'aatea e Peter ia te Ia o susugi, “Noka te konaa au gea.” ");
INSERT INTO mnv_vpl VALUES ("MK8_33","071_8_33","MRK","8","33","33","Ma te keu iho a Jesus ki ona pegea haka ako, kae susugi atu ia Peter, o hai atu, “Hinake ki mugi Satan, na'e ko koe e he'e hai e koe na maanatu a te 'Aitu, manga hai e koe a'a pegea.” ");
INSERT INTO mnv_vpl VALUES ("MK8_34","071_8_34","MRK","8","34","34","Ma te haka putu mai e Jesus te 'apitanga ma ona pegea haka ako o hai atu kinai, “Nimaa iai he pegea siahai ke tata'o ia te Au, e hai ke mataa he'e maanatu kia te ia, kae 'amo tena kros o tata'o mai ia te Au. ");
INSERT INTO mnv_vpl VALUES ("MK8_35","071_8_35","MRK","8","35","35","Iteme'agaa, koai e kumu i te ma'ugi nei, e hai ke go he'e kitea, ka koai e hai ti'aki te ma'ugi i te ghaghi ia te Au ma te Gongo Gaoi, e hai ke go pipiki e ia. ");
INSERT INTO mnv_vpl VALUES ("MK8_36","071_8_36","MRK","8","36","36","Tehea te gaoi 'anga o te pegea ga'u eia ba'i me'a i te kege nei, kae pau o ti'aki te ma'ugi o'ona? ");
INSERT INTO mnv_vpl VALUES ("MK8_37","071_8_37","MRK","8","37","37","Po niaa kago haiga'a e te pegea ke go haka suihaki ai te ma'ugi? ");
INSERT INTO mnv_vpl VALUES ("MK8_38","071_8_38","MRK","8","38","38","Te pegea nimaa pa'a ia te Au ma na haka hegeunga a'aku i te 'atu tangata masoko ma te 'osongo ina nei, te Hosa o Pegea e hai kego pa'a ia te ia i te 'aso kago a'u ai Ia i te mamagunga o te Tamana ma na ensel 'esi'esi.” ");
INSERT INTO mnv_vpl VALUES ("MK9_1","071_9_1","MRK","9","1","1","Kae hai atu a Jesus kia te kigatou, “Ko Au e gea maa'ogi atu kia te koutou, e iai na pegea manga tutu'u i te kunga nei, kago he'e na'a te mamate ano hiina'i ki te a'u 'anga te Hakahua 'anga a te 'Aitu ma na taganga.” ");
INSERT INTO mnv_vpl VALUES ("MK9_2","071_9_2","MRK","9","2","2","Sigi te ononga 'ao, kakabe e Jesus ia Peter ma James ma John o haka neke ki te ogo ma'u 'agunga o noko manga hiina'i soko ai, ma te haka gigiu a Jesus o hiina'i kinai kigatou. ");
INSERT INTO mnv_vpl VALUES ("MK9_3","071_9_3","MRK","9","3","3","Ona laoa noko hu'ai tia'a, noko susugu o sigi i ba'i me'a huhu'i i te kege nei o susugu. ");
INSERT INTO mnv_vpl VALUES ("MK9_4","071_9_4","MRK","9","4","4","Ka noko haka 'agitino ma'u a Elijah ma Moses kia te kigatou. Ko kigaaua noko manga hegeu ma Jesus. ");
INSERT INTO mnv_vpl VALUES ("MK9_5","071_9_5","MRK","9","5","5","Ma te hai atu a Peter kia Jesus, “Ako, e hu'ai gaoi tematou boomai 'anga ki te kunga nei. Kimatou 'ati 'ia he toka togu boghugha, ke hai mo'ou tasi, hai mo'o Moses tasi, kae hai mo'o Elijah tasi.” ");
INSERT INTO mnv_vpl VALUES ("MK9_6","071_9_6","MRK","9","6","6","(Ko Peter noko he'e na'a eia po nia e hai ke gea kinai, iteme'agaa ko kigatou na matataku.) ");
INSERT INTO mnv_vpl VALUES ("MK9_7","071_9_7","MRK","9","7","7","Ma te sopo te po'ao o tango ia te kigatou, kae haka gongo atu kigatou ki te ge'o e sopo mai i te po'ao o hai mai, “Tenei toku Hosa e ma'ine kinai Au, manga haka gongo ake kia te Ia!” ");
INSERT INTO mnv_vpl VALUES ("MK9_8","071_9_8","MRK","9","8","8","Nimaa ghali kigatou o hiina'i iho manga he'e hiina'i ma'u ki he pegea, ka manga ko Jesus launatasi. ");
INSERT INTO mnv_vpl VALUES ("MK9_9","071_9_9","MRK","9","9","9","Nimaa i tegatou giu iho 'anga i te ogo, susugi e Jesus ia te kigatou ke noka te gaatou he 'atigongo 'aki ki he pegea i nia kua hiina'i kinai, ke hano ano hetae ki te 'aso e hai ke go ma'ugi hokimai ai te Hosa o Pegea i te mate. ");
INSERT INTO mnv_vpl VALUES ("MK9_10","071_9_10","MRK","9","10","10","Pipiki e kigatou te gea 'anga a Jesus nei kia te kigatou soko kae manga hegeu po tehea te gaataki o te “ma'ugi hoki mai i te mate.” ");
INSERT INTO mnv_vpl VALUES ("MK9_11","071_9_11","MRK","9","11","11","Kae he haka anu 'aki kigatou kia Jesus o hai atu, “ 'Eaa noko hai mai ai na ako o na tagangonga, ko Elijah e hai ke go mu'a mai?” ");
INSERT INTO mnv_vpl VALUES ("MK9_12","071_9_12","MRK","9","12","12","Haka tau a Jesus o hai atu kia te kigatou, “E maa'ogi ko Elijah noko hai ke go mu'a mai, ke gosigosi haka hoki ba'i me'a. Ka 'eaa e hai ake ai na Kanukanu Tapu, te Hosa o Pegea e hai ke go hu'ai haka higosia ma te he'e sia hahai kinai? ");
INSERT INTO mnv_vpl VALUES ("MK9_13","071_9_13","MRK","9","13","13","Kae hogahoga e Au kia te koutou, ko Elijah na 'oti i te a'u, o hai kinai e kigatou ba'i hai 'anga siahahai kigatou ke hai kia te ia, o manga noho pe nia noko kanukanu e hai ke go hai kia te ia.” ");
INSERT INTO mnv_vpl VALUES ("MK9_14","071_9_14","MRK","9","14","14","Te gholoba noko boomai ai ki te toenga o na pegea haka ako, ko kigatou noko hiina'i ki te hu'ai haka putunga noko ghigho ia te kigatou, ka na ako o na tagangonga te noko manga haka bagebage kia te kigatou. ");
INSERT INTO mnv_vpl VALUES ("MK9_15","071_9_15","MRK","9","15","15","Te gholoba noko hiina'i ai te 'apitanga kia Jesus, ko kigatou noko hu'ai he gege ma'ugi 'aki, kae he 'agiko o oho ia te Ia. ");
INSERT INTO mnv_vpl VALUES ("MK9_16","071_9_16","MRK","9","16","16","Hai atu a Jesus ki ona pegea haka ako, “Niaa te haka bagebage 'aki ai a koutou kia te kigaatou?” ");
INSERT INTO mnv_vpl VALUES ("MK9_17","071_9_17","MRK","9","17","17","Haka tau ake te pegea i te 'apitanga o hai atu, “Ako, ko au e kakabe mai toku hosa kia te Koe. Koia e ugu ai te haagiki songo, o hai ia te ia o he'e gea. ");
INSERT INTO mnv_vpl VALUES ("MK9_18","071_9_18","MRK","9","18","18","Na gholoba ta'anga hetae kinai te haagiki songo, manga tupe ia te ia ki te kege o manga piloe te ngutu ma te he taangisi 'aki na niho kae maghitighiti. Ka kua haka ene ai au ki ou pegea haka ako nei kigatou pagepage 'ia te haagiki songo ma te he'e 'aonga te hai e kigatou.” ");
INSERT INTO mnv_vpl VALUES ("MK9_19","071_9_19","MRK","9","19","19","Ma te haka tau a Jesus o hai atu, “Koutou te 'atu tangata he'e too. E hai ke kohea na potaha Toku haka pata kia te koutou? Kakabe mai te tangata na kia te Au.” ");
INSERT INTO mnv_vpl VALUES ("MK9_20","071_9_20","MRK","9","20","20","Ma te kakabe ake e kigatou ia te ia kia Jesus. Te gholoba noko ina ai te haagiki songo kia Jesus, kae manga hai e ia te tangata nei o ghotoi. Koia noko too ki te kege o manga lulube'i ma te piloe te ngutu. ");
INSERT INTO mnv_vpl VALUES ("MK9_21","071_9_21","MRK","9","21","21","Haka anu a Jesus kia te tamana o hai atu, “E hianga ghapu te konei ana noho?” Ma te haka tau a te tamana o hai atu, “Noko haka tu'u i tena tama'iti'iti 'anga. ");
INSERT INTO mnv_vpl VALUES ("MK9_22","071_9_22","MRK","9","22","22","E 'eha 'aso 'aka ia te ia ki na ahi ma na bai ke taa ia te ia, ka nimaa 'aonga ki te hai kinai e Koe he hai 'anga, 'agoha mai o 'aabaki kia te kimaaua.” ");
INSERT INTO mnv_vpl VALUES ("MK9_23","071_9_23","MRK","9","23","23","Ma te hai atu a Jesus, “Nimaa 'aonga ki te hai e Koe? Ko ba'i me'a manga haingaohie ki te pegea e too.” ");
INSERT INTO mnv_vpl VALUES ("MK9_24","071_9_24","MRK","9","24","24","Ma te manga hai te hu'ai ge'o o te tamana o te tangata nei o hai atu, “Hakahua, ko au e too; 'aabaki mai kia te au ke hakanoka taku he'e too 'anga!” ");
INSERT INTO mnv_vpl VALUES ("MK9_25","071_9_25","MRK","9","25","25","Te gholoba noko ina ai a Jesus ki te he 'agiko mai 'anga te 'apitanga ki te kunga noko manga iai Ia, ma te gehu Ia ki te haagiki songo o hai atu, “Ko koe te haagiki songo tugi kae he'e gea, ko Au e hai atu kia te koe, sopo iho ia te ia, ma te noka ma'u tau go hokimai kinai.” ");
INSERT INTO mnv_vpl VALUES ("MK9_26","071_9_26","MRK","9","26","26","Te haagiki songo nei na hai tena hu'ai 'use 'anga, kae hai ia te tangata nei o ghotoi o tutahi 'io mugi o sopo ki taha ia te ia. Te tangata nei noko ma noho ake po te pegea mate, ma te 'eha pegea noko hai ake, “Kua mate.” ");
INSERT INTO mnv_vpl VALUES ("MK9_27","071_9_27","MRK","9","27","27","Ka noko 'oso a Jesus ki te gima o haka tu'u ki na ba'e o tu'u. ");
INSERT INTO mnv_vpl VALUES ("MK9_28","071_9_28","MRK","9","28","28","Mugi i te ugu 'anga a Jesus ki te hage, boo ake Ona pegea haka ako o haka anuanu 'aki kia te Ia i tegatou hiina'i soko 'anga, o hai atu, “ 'Eaa kua he'e 'aonga te pagepage ai e kimatou te haagiki songo nei?” ");
INSERT INTO mnv_vpl VALUES ("MK9_29","071_9_29","MRK","9","29","29","Ma te haka tau a Jesus, “Te haingaa haagiki songo nei ka manga 'aonga te pagepage i te taakunga ma te he'e kai i te sogi.” ");
INSERT INTO mnv_vpl VALUES ("MK9_30","071_9_30","MRK","9","30","30","Ko kigatou na boo i te manaha na o agatu'u i Galilee. Ko Jesus noko he'e siahai ke na'a e he pegea po ko kigatou e boo ki hea, ");
INSERT INTO mnv_vpl VALUES ("MK9_31","071_9_31","MRK","9","31","31","iteme'agaa ko Ia noko manga ako ona pegea haka ako. Ko Ia noko hai atu kia te kigatou, “Te Hosa o Pegea e hai ke go haka soko 'ia ki na noho o na taganga o pegea. Kago taa e kigatou, kae mugi i te toka togu 'ao, ko Ia kago ma'ugi hoki.” ");
INSERT INTO mnv_vpl VALUES ("MK9_32","071_9_32","MRK","9","32","32","Ka noko he'e na'a e kigatou po nia te gaataki e Jesus, ka noko matataku te haka anuanu 'aki ai kia Jesus. ");
INSERT INTO mnv_vpl VALUES ("MK9_33","071_9_33","MRK","9","33","33","Ko kigatou noko boo ki Capernaum. Te gholoba noko iai Ia i te hage, haka anu kia te kigatou o hai atu, “Niaa te kua he haka bagebage 'aki boomai ai koutou i te agatu'u?” ");
INSERT INTO mnv_vpl VALUES ("MK9_34","071_9_34","MRK","9","34","34","Ka ko kigatou noko he'e gegea, iteme'agaa ko kigatou noko haka bagebage 'aki i te agatu'u, po koai ia te kigatou e hai ke go hua'eha. ");
INSERT INTO mnv_vpl VALUES ("MK9_35","071_9_35","MRK","9","35","35","Noho a Jesus o ngege atu i tona katoa tuma'a e gua pegea haka ako o hai atu kinai, “Nimaa iai he pegea e siahai ke mu'a, koia e hai ke pau o tuku taha'aki ki gago ia te ia, o hai ma'u ai he guani mo'o ba'i pegea.” ");
INSERT INTO mnv_vpl VALUES ("MK9_36","071_9_36","MRK","9","36","36","'Oso a Jesus ki te tama 'iti'iti o hai o tu'u ki 'ago ia te kigatou o kopi e Ia, kae hai atu kia te kigatou, ");
INSERT INTO mnv_vpl VALUES ("MK9_37","071_9_37","MRK","9","37","37","“Ko ai e oho eia he mi'i tama 'iti'iti i na tamagiki nei i te ghaghi i toku ingoa, e oho eia ia te Au; ko ai ma'u e oho ia te Au, e he'e manga oho ia te Au, kae oho ma'u ia te Ia noko haka to'o mai e Ia ia te Au.” ");
INSERT INTO mnv_vpl VALUES ("MK9_38","071_9_38","MRK","9","38","38","Ko John noko hai atu kia Jesus, “Ako, ko kimatou na hiina'i ki te tangata noko manga pagepage haagiki songo i tou ingoa, ma te susugi e kimatou, iteme'agaa he'e te pegea ia te kitatou.” ");
INSERT INTO mnv_vpl VALUES ("MK9_39","071_9_39","MRK","9","39","39","Ma te hai atu a Jesus, “Noka te susugi ia te ia. E si'ai he pegea ke hai ni taganga i toku ingoa, ke 'aonga te ghali o gea maase'i kia te Au. ");
INSERT INTO mnv_vpl VALUES ("MK9_40","071_9_40","MRK","9","40","40","Iteme'agaa ko ai e he'e hai songo ia te kitatou, koia te pegea o tatou. ");
INSERT INTO mnv_vpl VALUES ("MK9_41","071_9_41","MRK","9","41","41","Ko Au e gea maa'ogi kia te koutou: Nimaa iai he pegea e 'abatu mo'outou ni bai binu i Toku ingoa iteme'agaa koutou na pegea o Christ, koia kago ga'u 'ona ga'unga. ");
INSERT INTO mnv_vpl VALUES ("MK9_42","071_9_42","MRK","9","42","42","“Kago nimaa iai he pegea hai eia he tama 'iti'iti o 'oosongo i na tama giki nei kua 'oti i te too kia te Au, mano e gaoi i te logha he hu'ai hatu mamaha ki te u'a o tupe ia te ia ki te moana. ");
INSERT INTO mnv_vpl VALUES ("MK9_43","071_9_43","MRK","9","43","43","“Tou gima, nimaa hai ia te koe o 'oosongo, toghi atu. Ko koe e gaoi te hano gima tasi ki te ma'ugi, o sigi i te hano ma gu'ou gima ki te ugaimami, te ahi he'e mate, ");
INSERT INTO mnv_vpl VALUES ("MK9_44","071_9_44","MRK","9","44","44","te kunga he'e mamate ai na ugo e kai ia te kigatou, ma te he'e 'aonga te tamate tena ahi. ");
INSERT INTO mnv_vpl VALUES ("MK9_45","071_9_45","MRK","9","45","45","“Tou ba'e ma'u, nimaa hai ia te koe o 'oosongo, toghi atu. E gaoi i te hano koe te pegea paka ki te ma'ugi, o sigi i te poi noko hai gu'ou ba'e kae tupe ia te koe ki te ugaimami, ");
INSERT INTO mnv_vpl VALUES ("MK9_46","071_9_46","MRK","9","46","46","te kunga he'e mamate ai na ugo e kai ia te kigatou, ma te he'e 'aonga te tamate tena ahi. ");
INSERT INTO mnv_vpl VALUES ("MK9_47","071_9_47","MRK","9","47","47","“Tou mata ma'u, nimaa hai ia te koe ke 'oosongo, kape iho, na'e gaoi i te hano mata tasi koe ki te Hakahua 'anga a te 'Aitu, o sigi i te tupe ia te koe ma gu'ou mata ki te ugaimami, ");
INSERT INTO mnv_vpl VALUES ("MK9_48","071_9_48","MRK","9","48","48","te kunga ‘he'e mamate ai na ugo e kai ia te kigatou, ma te he'e 'aonga te tamate tena ahi.’ ");
INSERT INTO mnv_vpl VALUES ("MK9_49","071_9_49","MRK","9","49","49","Iteme'agaa ko ba'i pegea e hai kego hai o ma'a i te ahi ke noho pe te sakrifaes e hai e na solo o ma'a. ");
INSERT INTO mnv_vpl VALUES ("MK9_50","071_9_50","MRK","9","50","50","“Te solo te me'a gaoi, ka nimaa he'e kitea tena kona 'anga, hai ke kohea na hai ke kona hoki? Koutou he gotomaagie 'aki atu, ke noho pe na solo e hai na utunga o kai gaoi.” ");
INSERT INTO mnv_vpl VALUES ("MK10_1","071_10_1","MRK","10","1","1","Ko Jesus na hano i te manaha na, noko hano ki te kunga henua i Judea, o gakau i te bai mimigo i Jordan, ma te haka putu ma'u te 'apitanga kia te Ia. Ka na hai tena toonginga te ako ia te kigatou. ");
INSERT INTO mnv_vpl VALUES ("MK10_2","071_10_2","MRK","10","2","2","Boomai kinai na pegea i na Pharisee o hai lobo e kigatou ia Jesus o hai atu, “E tuku e na tagangonga he tangata ke ti'aki tena uguugu?” ");
INSERT INTO mnv_vpl VALUES ("MK10_3","071_10_3","MRK","10","3","3","Haka tau a Jesus o hai atu, “Niaa te noko gea a Moses ke hai e koutou?” ");
INSERT INTO mnv_vpl VALUES ("MK10_4","071_10_4","MRK","10","4","4","Ma te haka tau a kigatou, “Ko Moses noko tuku eia te tangata ke kanukanu eia he leta mo'o te maabae kae ti'aki a tena uguugu.” ");
INSERT INTO mnv_vpl VALUES ("MK10_5","071_10_5","MRK","10","5","5","Haka tau a Jesus o hai atu, “Noko konei na kanukanu e Moses, iteme'agaa outou uso e mogi. ");
INSERT INTO mnv_vpl VALUES ("MK10_6","071_10_6","MRK","10","6","6","Ka te haka tu'u sanga o gago nei, ko te 'Aitu noko gosigosi e Ia te tangata ma te hahine. ");
INSERT INTO mnv_vpl VALUES ("MK10_7","071_10_7","MRK","10","7","7","Tenei te hai 'anga e hano ai te tangata ia te tamana ma te tinana o tu'utaki kia tena uguugu. ");
INSERT INTO mnv_vpl VALUES ("MK10_8","071_10_8","MRK","10","8","8","Ko kigaaua ka hai ai te tino e tasi. Ko kigaaua kua he'e hai ai te toka gua, ka te launatasi. ");
INSERT INTO mnv_vpl VALUES ("MK10_9","071_10_9","MRK","10","9","9","Kogaa na noho nia e konei na tu'utaki e te 'Aitu, e hai ke noka te haka maabae e he pegea.” ");
INSERT INTO mnv_vpl VALUES ("MK10_10","071_10_10","MRK","10","10","10","Te 'aso na giu ai kigatou ki goto i te hage, ona pegea haka ako noko haka anuanu 'aki kia Jesus i na noho o te hai 'anga nei. ");
INSERT INTO mnv_vpl VALUES ("MK10_11","071_10_11","MRK","10","11","11","Ko Jesus noko haka tau o hai atu, “Ko ai e ti'aki tona uguugu, kae sui o pipiki tegaa hahine, koia manga kaia'a ki tona uguugu kua ti'aki. ");
INSERT INTO mnv_vpl VALUES ("MK10_12","071_10_12","MRK","10","12","12","Ka te hahine nimaa ti'aki tona matu'a kae sui o noho i tegaa tangata, koia manga kaia'a ki tona matu'a kua ti'aki.” ");
INSERT INTO mnv_vpl VALUES ("MK10_13","071_10_13","MRK","10","13","13","Te 'apitanga noko kakabe mai na mi'i tama giki kia Jesus, ke 'oso kia te kigatou, ka na susugi e na pegea haka ako ia te kigatou. ");
INSERT INTO mnv_vpl VALUES ("MK10_14","071_10_14","MRK","10","14","14","Ka te gholoba noko ina 'atu ai kinai a Jesus, ko Ia noko hu'ai he'e siahai kinai, ma te hai atu kia te kigatou, “Tuku iho na mi'i tama giki na ke boomai kia te Au, noka te susugi, iteme'agaa te Hakahua 'anga a te 'Aitu te kunga o na pegea konei na noho. ");
INSERT INTO mnv_vpl VALUES ("MK10_15","071_10_15","MRK","10","15","15","Ko Au e gea maa'ogi kia te koutou: Te pegea nimaa he'e to'o e ia te Hakahua 'anga a te 'Aitu ke noho pe te sano o te tama 'iti'iti, koia kago he'e hano ai ki goto.” ");
INSERT INTO mnv_vpl VALUES ("MK10_16","071_10_16","MRK","10","16","16","Kae gagaba mai e Jesus na mi'i tama giki nei ki na gima, o haka eke na gima ia te kigatou, o haka gaoi ia te kigatou. ");
INSERT INTO mnv_vpl VALUES ("MK10_17","071_10_17","MRK","10","17","17","Te 'aso noko haka tu'u ai a Jesus ke hano, tege ake te tangata o too toko tugi i 'ago ia te Ia, o haka anu ake, “Ako gaoi, tehea te hai 'anga kau hai 'ia kau ga'u ai 'ia te ma'ugi noho goa?” ");
INSERT INTO mnv_vpl VALUES ("MK10_18","071_10_18","MRK","10","18","18","Ma te hai atu a Jesus, “ 'Eaa e hai mai ai koe ko Au e gaoi? E si'ai he pegea gaoi ka manga ko te 'Aitu launatasi. ");
INSERT INTO mnv_vpl VALUES ("MK10_19","071_10_19","MRK","10","19","19","E na'a e koe na tagangonga: Noka te he taa 'aki, noka te maasoko na taangata hai uguugu ma na haahine hai matu'a 'i kogaa haahine ma kogaa taangata, noka te kaia'a, noka te taukimata gogoi, noka te mou toto'o, haka e'eha atu ia te tamau ma te tinau.” ");
INSERT INTO mnv_vpl VALUES ("MK10_20","071_10_20","MRK","10","20","20","Koia noko haka tau o hai atu, “Ako, na hai 'anga nei noko pipiki mai eau i aku bagokaa 'anga.” ");
INSERT INTO mnv_vpl VALUES ("MK10_21","071_10_21","MRK","10","21","21","Ko Jesus noko ina 'atu kia te ia ma te ma'ine kinai, ka na hai atu, “E tasi hai 'anga koi he'e hai e koe, hinatu o salemu ba'i me'a a'au o haiga'a ki na pegea lae, ka ke go hai ma'au ni ga'unga i te Nuku i te gangi. Kae a'u o tata'o ia te Au.” ");
INSERT INTO mnv_vpl VALUES ("MK10_22","071_10_22","MRK","10","22","22","Te hai 'anga nei na pa'a ai te tangata nei, ano manga hano 'agoha, iteme'agaa koia te pegea hu'ai ga'u. ");
INSERT INTO mnv_vpl VALUES ("MK10_23","071_10_23","MRK","10","23","23","Ko Jesus na he keukeu 'aki kae hai atu ki Ona pegea haka ako, “E hu'ai haingata'a ki te hano he pegea ga'u ki goto i te Hakahua 'anga a te 'Aitu!” ");
INSERT INTO mnv_vpl VALUES ("MK10_24","071_10_24","MRK","10","24","24","Na pegea haka ako noko hu'ai he langalanga 'aki i Ana akonga nei. Ka noko gea haka hoki atu a Jesus, “Tamagiki, e hu'ai haingata'a te sosopo ki goto i te Hakahua 'anga a te 'Aitu! ");
INSERT INTO mnv_vpl VALUES ("MK10_25","071_10_25","MRK","10","25","25","Manga haingaohie te mene he ‘camel’ i he mataa nila lapui o sigi i te pegea ga'u te hano ki goto i te Hakahua 'anga a te 'Aitu.” ");
INSERT INTO mnv_vpl VALUES ("MK10_26","071_10_26","MRK","10","26","26","Na pegea haka ako na tuku so atu 'agatou he langalanga 'aki 'anga, ma te konei agatou he haka anuanu 'aki, “ 'Ai koai okoia te kago ma'ugi?” ");
INSERT INTO mnv_vpl VALUES ("MK10_27","071_10_27","MRK","10","27","27","Ina 'atu a Jesus kia te kigatou kae hai atu, “Kia pegea, te hai 'anga nei e hu'ai haingata'a, kae he'e haingata'a kia te 'Aitu; ko ba'i hai 'anga manga hai ngaohie ia te 'Aitu.” ");
INSERT INTO mnv_vpl VALUES ("MK10_28","071_10_28","MRK","10","28","28","Hai atu a Peter kia te Ia, “Ko kimatou kua ti'aki ko ba'i me'a ka kimatou 'agu tu'a ia te Koe!” ");
INSERT INTO mnv_vpl VALUES ("MK10_29","071_10_29","MRK","10","29","29","Haka tau atu a Jesus, “Ko Au e gea maa'ogi kia te koutou: E si'ai he pegea kua ti'aki tena manaha po tena 'api taangata po ona tuhaahine po tena tinana, po ko te tamana po 'ana tamagiki po ona ma'aga kia te Au ma te Gongo Gaoi, ");
INSERT INTO mnv_vpl VALUES ("MK10_30","071_10_30","MRK","10","30","30","kago he'e ga'u eia te gau o sigi i te 'atu nei (na manaha, na 'api taangata, na tuhaahine, na tinana, na tamagiki, ma na ma'aga; hakapigi ki na me'a nei, na haisongo 'ia 'anga) ma i-te 'atu tangata kago a'u, te ma'ugi noho goa. ");
INSERT INTO mnv_vpl VALUES ("MK10_31","071_10_31","MRK","10","31","31","Ka te 'apitanga noko mumu'a mai kago mumugi, ka te 'apitanga noko mumugi kago mumu'a.” ");
INSERT INTO mnv_vpl VALUES ("MK10_32","071_10_32","MRK","10","32","32","Ko kigatou noko haka neke ki Jerusalem, ko Jesus te noko mu'a i te agatu'u, ka na pegea haka ako noko manga he langalanga 'aki, ka kogaa pegea noko tata'o mugi, noko matataku. Ma te haka 'aatea haka hoki e Jesus tena katoa tuma'a e gua pegea, o hogahoga kia te kigatou nia te hai ke hetae kia te Ia. ");
INSERT INTO mnv_vpl VALUES ("MK10_33","071_10_33","MRK","10","33","33","“Ko kitatou e hakaneke ki Jerusalem, ka te Hosa o Pegea, ka haka soko 'ia ki na hakahua o na priest ma na ako o na tagangonga. E hai kigatou haka pau 'ia ke mate, kae haiga'a ki na pegea 'aatea. ");
INSERT INTO mnv_vpl VALUES ("MK10_34","071_10_34","MRK","10","34","34","Ko kigatou kago putatai kia te Ia, ma te he ngaa'esu 'aki kia te Ia, ma te go bisa ma te tamate ia te Ia. Ka nimaa go i te togunga 'ao, ko Ia kago 'aga hoki mai.” ");
INSERT INTO mnv_vpl VALUES ("MK10_35","071_10_35","MRK","10","35","35","Mugi a James ma John, gua hosa o Zebedee o boo kia Jesus, o hai atu, “Ako, ko kimaua e sia hahai ke hai e Koe kia te kimaua nia ka haka ene 'aki ai kimaua kia te Koe.” ");
INSERT INTO mnv_vpl VALUES ("MK10_36","071_10_36","MRK","10","36","36","Hai atu a Jesus, “Niaa te sia hahai kougua kau hai 'ia kia te kougua?” ");
INSERT INTO mnv_vpl VALUES ("MK10_37","071_10_37","MRK","10","37","37","Haka tau atu kigaaua o hai atu, “Tuku mai ia te kimaaua, kimaaua go noho 'aki pa'asi gua ia te Koe i tou mamagunga. Noho tegaa i te pa'asi maui, kae noho tegaa i te pa'asi sema.” ");
INSERT INTO mnv_vpl VALUES ("MK10_38","071_10_38","MRK","10","38","38","Haka tau kinai a Jesus o hai atu, “E he'e na'a e kougua nia te haka ene 'aki ai kougua. 'Ai kougua e 'aonga te bibinu i te kapu e hai kau go binu ai, po kougua e 'aonga te haa gogomi i te haa gogomi 'anga e hai kau go hai 'ia?” ");
INSERT INTO mnv_vpl VALUES ("MK10_39","071_10_39","MRK","10","39","39","Haka tau a kigaaua o hai atu, “Manga 'aonga te hai e kimaaua.” Ma te hai atu a Jesus kia te kigaaua, “Kougua kago bibinu i te kapu go binu ai Au, ma te haa gogomi i te haa gogomi 'anga e hai kau hai 'ia. ");
INSERT INTO mnv_vpl VALUES ("MK10_40","071_10_40","MRK","10","40","40","Ka te noho 'aki kougua i toku pa'asi maui ma toku pa'asi sema, e he'e te hai 'anga kau tuku 'ia. Gua kunga nei gua kunga ki na pegea na 'oti i te haka ngaague kinai.” ");
INSERT INTO mnv_vpl VALUES ("MK10_41","071_10_41","MRK","10","41","41","Te 'aso na haka gongo ai tegaa katoa pegea haka ako, ko kigatou na he 'ika'ika 'aki toto'a kia James ma John. ");
INSERT INTO mnv_vpl VALUES ("MK10_42","071_10_42","MRK","10","42","42","Haka putu mai e Jesus ia te kigatou o hai atu, “Manga na'a e koutou, na pegea e haka pau ke hakahua ki na pegea 'aatea e pau kigatou o hakahua. Ma ogatou hu'ai pegea hai hekau, manga hai paaunga kia te kigatou. ");
INSERT INTO mnv_vpl VALUES ("MK10_43","071_10_43","MRK","10","43","43","Ka koutou e he'e hai ke konaa autou noho, kae hai ke konei na noho: Koai e siahai ke hua'eha ia te koutou, koia e hai ke hai ai mo'outou he guani. ");
INSERT INTO mnv_vpl VALUES ("MK10_44","071_10_44","MRK","10","44","44","Nimaa iai he pegea siahai ke mu'a ia te koutou e hai ke hai ai he guani mo'o te 'apitanga. ");
INSERT INTO mnv_vpl VALUES ("MK10_45","071_10_45","MRK","10","45","45","Iteme'agaa te Hosa o Pegea noko he'e a'u ke hai hekau kinai, ka ko Ia noko a'u ke hai hekau, ma te ke haiga'a te ma'ugi ke tau'i hoki ai te 'apitanga.” ");
INSERT INTO mnv_vpl VALUES ("MK10_46","071_10_46","MRK","10","46","46","Ma te boomai kigatou ki Jericho. Nimaa boo a Jesus ma ona pegea haka ako ma te 'apitanga, te tangata kibi ia Bartimaeus (te hosa o Timeas) noko manga noho i te taha o te agatu'u, o manga haka ene. ");
INSERT INTO mnv_vpl VALUES ("MK10_47","071_10_47","MRK","10","47","47","Te gholoba na haka gongo ai o na'a eia ko Jesus te pegea mai Nazareth, ma te haka tu'u ngege, “Jesus, te Hosa o David, 'agoha mai kia te au.” ");
INSERT INTO mnv_vpl VALUES ("MK10_48","071_10_48","MRK","10","48","48","'Eha pegea gehu kia te ia ma te kaunaki ia te ia ke manga noho ngongoto, kae manga tuku soo ake tena ngege 'anga, “Jesus, te Hosa o David, 'agoha mai kia te au.” ");
INSERT INTO mnv_vpl VALUES ("MK10_49","071_10_49","MRK","10","49","49","Tu'u a Jesus o hai atu, “Ngege atu ia te ia.” Ma te ngengege atu kigatou i te pegea kibi, “Siasia ake! Tu'u ake, na'e ko Ia e ngege mai ia te koe.” ");
INSERT INTO mnv_vpl VALUES ("MK10_50","071_10_50","MRK","10","50","50","Koia na tupe 'aatea tena ake mamaha, kae tu'u gege i na ba'e o a'u kia Jesus. ");
INSERT INTO mnv_vpl VALUES ("MK10_51","071_10_51","MRK","10","51","51","Haka anu a Jesus kia te ia o hai atu, “Niaa te siahai koe kau hai 'ia kia te koe?” Hai atu te tangata kibi, “Ako, ko au e siahai kau ina.” ");
INSERT INTO mnv_vpl VALUES ("MK10_52","071_10_52","MRK","10","52","52","Hai atu a Jesus, “Hinatu, 'e tou sano kua hai ia te koe o ma'ugi.” Ma te manga ina haka hoki, o tata'o ia Jesus i te agatu'u. ");
INSERT INTO mnv_vpl VALUES ("MK11_1","071_11_1","MRK","11","1","1","Te 'aso noko hitaiaki atu ai kigatou ki Jerusalem o boo ki Bethphage ma Bethany i te Ogo i Olives, haka to'o e Jesus te toka gua i ona pegea haka ako, ");
INSERT INTO mnv_vpl VALUES ("MK11_2","071_11_2","MRK","11","2","2","hai atu kia te kigaaua, “Boo atu ki te manaha e i mu'a ia te kougua. Nimaa go memene kougua ki goto, kago sasa'o kougua ki te punua donki manga tauga i te kunga na, manga koi he'e sehu ai he pegea. Huhuke atu o kakabe mai ki te kunga nei. ");
INSERT INTO mnv_vpl VALUES ("MK11_3","071_11_3","MRK","11","3","3","Ka nimaa haka anu he pegea kia te kougua o hai atu: ‘ 'Eaa e hai ai e kougua te hai 'anga nei?’ Manga hai atu kinai, ‘E siahai kinai te Hakahua, ka ke go haka to'o hoki ghali mai.’ ” ");
INSERT INTO mnv_vpl VALUES ("MK11_4","071_11_4","MRK","11","4","4","Ko kigaaua na boo, o kite i te punua donki manga tauga i te mu'a manaha o pata i te agatu'u, ma te huhuke e kigaaua. ");
INSERT INTO mnv_vpl VALUES ("MK11_5","071_11_5","MRK","11","5","5","Na pegea noko manga tutu'u i te kungaa, noko haka anu 'aki kinai o hai atu, “Niaa te hai e kougua na, te huhuke te punua donki na?” ");
INSERT INTO mnv_vpl VALUES ("MK11_6","071_11_6","MRK","11","6","6","Ma te hakatau kinai kigaaua i te gea 'anga noko hogahoga e Jesus kigaaua gegea ai, ma te tuku e kigatou ia te kigaaua o kakabe te punua donki o boo. ");
INSERT INTO mnv_vpl VALUES ("MK11_7","071_11_7","MRK","11","7","7","Te gholoba noko kakabe ai e kigaaua te punua donki kia Jesus, kae gisaki ogatou ake ki te punua donki, o noho kinai a Jesus. ");
INSERT INTO mnv_vpl VALUES ("MK11_8","071_11_8","MRK","11","8","8","'Eha pegea noko hoga ogatou ake ki te agatu'u, kae sepesepe e kogaa pegea na 'ugu ga'akau i te pa'asi o te aga o hoga ma'u ki te agatu'u. ");
INSERT INTO mnv_vpl VALUES ("MK11_9","071_11_9","MRK","11","9","9","Na pegea noko mumu'a ma na pegea noko 'agu mugi noko ngengege ngatahi o hai ake, “Hosanna!” “Te haka gaoinga kia te Ia e a'u i te ingoa o te 'Aitu. ");
INSERT INTO mnv_vpl VALUES ("MK11_10","071_11_10","MRK","11","10","10","Te haka gaoinga te a'u o te hakahua 'anga a te matou tupuna ia David! Hosanna, te haka e'eha kia te 'Aitu Ma'u 'agunga.” ");
INSERT INTO mnv_vpl VALUES ("MK11_11","071_11_11","MRK","11","11","11","Ko Jesus na sopo ki Jerusalem o hano ki te Hage Tapu, o noko manga ina sehu ki ba'i me'a, ka noko hai hano ke poo, ma te boo ma tena katoa tuma'a e gua pegea haka ako ki Bethany. ");
INSERT INTO mnv_vpl VALUES ("MK11_12","071_11_12","MRK","11","12","12","Tegaa 'ao kigatou noko boo i Bethany, kae ongea a Jesus. ");
INSERT INTO mnv_vpl VALUES ("MK11_13","071_11_13","MRK","11","13","13","Ka noko ina 'atu ki na gau o te ga'akau, e ingoa te ‘fig’, o hano kinai ke ligo po e iai ni hua. Te gholoba na hetae atu ai kinai, noko si'ai ni hua ka manga na gau, iteme'agaa noko manga koi he'e tatae te 'aso hua o na ga'akau nei. ");
INSERT INTO mnv_vpl VALUES ("MK11_14","071_11_14","MRK","11","14","14","Ma te hai atu Ia ki te ga'akau, “Kago si'ai ma'u he pegea ke go kai haka hoki he hua ia te koe.” O haka gongo ona pegea haka ako ki tena gea 'anga nei. ");
INSERT INTO mnv_vpl VALUES ("MK11_15","071_11_15","MRK","11","15","15","Te hetae 'anga ki Jerusalem, ko Jesus noko hano ki goto i te Hage Tapu, ma te pagepage e Ia na pegea noko manga tau'i me'a ma te salemu me'a i te kunga na. 'Aka gigingi e Ia na kaupea o na pegea sui mane, ma na kaupea o na pegea salemu gupe. ");
INSERT INTO mnv_vpl VALUES ("MK11_16","071_11_16","MRK","11","16","16","Kae he'e tuku ma'u e Ia he pegea ke to'o ni ga'unga o hano i goto i te Hage Tapu. ");
INSERT INTO mnv_vpl VALUES ("MK11_17","071_11_17","MRK","11","17","17","Ka noko ako e Ia ia te kigatou, o hai atu, “ 'Ai noko he'e kanukanu: ‘Toku hage e hai ke go mate te hage o te sogi ki ba'i kungaa henua.’? Ka kua hai e koutou o manga hai ai ‘te 'ana mo'ona pegea kaia'a.’ ” ");
INSERT INTO mnv_vpl VALUES ("MK11_18","071_11_18","MRK","11","18","18","Na haka gongo kinai na hakahua o na priest ma na ako o na tagangonga ma te sasaga hai 'anga kigatou go taa 'ia ai ia Jesus, iteme'agaa ko kigatou noko matataku kia te Ia, i te 'apitanga na he tu'ia 'aki i ana akonga. ");
INSERT INTO mnv_vpl VALUES ("MK11_19","071_11_19","MRK","11","19","19","Nimaa i te ahiahi, kae boo a Jesus ma ona pegea ki taha i Jerusalem. ");
INSERT INTO mnv_vpl VALUES ("MK11_20","071_11_20","MRK","11","20","20","Nimaa i te mahoata, ko kigatou noko boo i te agatu'u, ko kigatou noko hiina'i ki te ‘fig’ kua maemae, haka tu'u ake i ona aka. ");
INSERT INTO mnv_vpl VALUES ("MK11_21","071_11_21","MRK","11","21","21","Maanatu a Peter ki nia na hai e Jesus, o hai atu kia te Ia, “Ako, ina 'atu ki te ga'akau noko tongi e Koe, kua maemae!” ");
INSERT INTO mnv_vpl VALUES ("MK11_22","071_11_22","MRK","11","22","22","Ma te haka tau kinai a Jesus o hai atu, “Manga sano atu kia te 'Aitu. ");
INSERT INTO mnv_vpl VALUES ("MK11_23","071_11_23","MRK","11","23","23","Ko Au e gea maa'ogi kia te koutou: Poi hai atu he pegea ki te ogo nei, ‘Hinatu o too ki te moana,’ ka te uso o'ona e he'e tootoobaasi'a, manga pau o na'a ake tena gea 'anga ka hai, kago hai kia te ia. ");
INSERT INTO mnv_vpl VALUES ("MK11_24","071_11_24","MRK","11","24","24","Kogaa na noho ko Au e hai atu kia te koutou, e iai ni me'a haka ene 'aki ai koutou i te taakunga, too atu e hai ke go ga'u e koutou. ");
INSERT INTO mnv_vpl VALUES ("MK11_25","071_11_25","MRK","11","25","25","Ka koutou nimaa hai ke taakunga, kae iai ni hai 'anga manga na'a makau ai koutou ki he pegea, haka noka atu kinai, ka kego haka noka e te Tamana o 'outou i te gangi 'outou 'oosongo. ");
INSERT INTO mnv_vpl VALUES ("MK11_26","071_11_26","MRK","11","26","26","Koutou nimaa he'e haka noka ki gaa pegea, te Tamana o 'outou i te gangi ka he'e haka noka ma'u e Ia outou 'oosongo.” ");
INSERT INTO mnv_vpl VALUES ("MK11_27","071_11_27","MRK","11","27","27","Ko kigatou na hetae giu ki Jerusalem. Ka te gholoba noko manga sehu ai a Jesus i goto i te Hage Tapu, na hakahua o na priest ma na ako o na tagangonga ma na 'agiki o te sogi noko boomai kia te Ia. ");
INSERT INTO mnv_vpl VALUES ("MK11_28","071_11_28","MRK","11","28","28","O haka anu 'aki kia Jesus, “O'ai na taganga te hai ai e Koe na hai 'anga nei? Koai ma'u e haiga'a e Ia na paaunga nei kia te Koe?” ");
INSERT INTO mnv_vpl VALUES ("MK11_29","071_11_29","MRK","11","29","29","Haka tau kinai a Jesus o hai atu, “Ko Au e hai kau haka anu kia te koutou i te haka anu. Ka koutou e hai ke haka tau mai, 'io mugi Au o hogahoga kia te koutou po o'ai na taganga te hai ai e Au na hai 'anga nei: ");
INSERT INTO mnv_vpl VALUES ("MK11_30","071_11_30","MRK","11","30","30","Hogahoga mai po na haa gogomi pegea 'anga a John, te hai 'anga mai te gangi, po te hai 'anga mai a pegea?” ");
INSERT INTO mnv_vpl VALUES ("MK11_31","071_11_31","MRK","11","31","31","Ko kigatou noko hegeu soko kinai o hai ake, “Nimaa hai atu kitatou, ‘Te hai 'anga mai te gangi,’ kago hai mai, ‘Ka eaa e he'e too ai koutou kia te ia?’ ");
INSERT INTO mnv_vpl VALUES ("MK11_32","071_11_32","MRK","11","32","32","Ka nimaa hai atu kitatou, ‘Te hai 'anga mai a pegea’ ...” (Ko kigatou noko matataku ki te 'apitanga, iteme'agaa ko ba'i pegea kua na'a e kigatou ko John e maa'ogi te taauga.) ");
INSERT INTO mnv_vpl VALUES ("MK11_33","071_11_33","MRK","11","33","33","Ma te haka tau kigatou kia Jesus o hai atu, “E he'e na'a e kimatou.” Ma te hai atu a Jesus, “Ka he'e hogahoga ma'u e Au kia te koutou po o'ai na taganga te hai ai e Au na hai 'anga nei.” ");
INSERT INTO mnv_vpl VALUES ("MK12_1","071_12_1","MRK","12","1","1","Ko Jesus noko haka tu'u te gea kia te kigatou i na haka gaataki. “Te pegea noko sanga tena 'umanga i te kaubago e ingoa te-‘grape’, noko 'ati eia te 'aa o mugheghi ai, kegi ma'u te pupu'a ke go natu kinai na hua kaubago ke hai ai ni waeni, kae 'ati ma'u eia te hata mata ma'u 'agunga. 'Io mugi ia o tuku te 'umanga nei ki na pegea hai 'umanga ke tau'i ma te ge'o, kae hano. ");
INSERT INTO mnv_vpl VALUES ("MK12_2","071_12_2","MRK","12","2","2","Nimaa i te 'aso utu, haka to'o eia te guani ki na ge'o sanga ke to'o ai ni hua mai te 'umanga. ");
INSERT INTO mnv_vpl VALUES ("MK12_3","071_12_3","MRK","12","3","3","Ka na labu e kigatou ia te ia o kogu, kae haka to'o huihui gima e kigatou ia te ia. ");
INSERT INTO mnv_vpl VALUES ("MK12_4","071_12_4","MRK","12","4","4","Ma te haka to'o hokimai tegaa guani kia te kigatou; manga pe'epe'e e kigatou te 'ugu, kae hai e kigatou o hu'ai ta'ea pa'a. ");
INSERT INTO mnv_vpl VALUES ("MK12_5","071_12_5","MRK","12","5","5","Ka manga haka to'o mai ma'u tegaa guani; tenaa na taa e kigatou o mate. Haka to'o ma'u eia kogaa, o kogu e kigatou kogaa, kae taa kogaa. ");
INSERT INTO mnv_vpl VALUES ("MK12_6","071_12_6","MRK","12","6","6","“Koia noko manga toe kinai te launatasi ke haka to'o ma'u: Tena hosa noko hu'ai ma'ine kinai. Na haka to'o taha'aki eia, kae hai ake, ‘Ko kigatou kago pago kia toku hosa.’ ");
INSERT INTO mnv_vpl VALUES ("MK12_7","071_12_7","MRK","12","7","7","“Ka na ge'o sanga o te 'umanga na hegeu o hai ake kia te kigatou, ‘Tenei te pegea ka sui i te hakahua o te 'umanga. Boo mai kitatou taa 'ia, ka ke hai mo'otatou ana ga'unga.’ ");
INSERT INTO mnv_vpl VALUES ("MK12_8","071_12_8","MRK","12","8","8","Ma te kakabe e kigatou ia te ia o taa, kae tupe e kigatou ki taha i te 'umanga kaubago. ");
INSERT INTO mnv_vpl VALUES ("MK12_9","071_12_9","MRK","12","9","9","“Niaa ma'u kago hai e te hakahua o te 'umanga kaubago? Koia kago a'u o taa na ge'o sanga o te 'umanga nei, kae tuku te 'umanga kaubago ki ni pegea 'aatea. ");
INSERT INTO mnv_vpl VALUES ("MK12_10","071_12_10","MRK","12","10","10","'Ai koutou e he'e haka sahe na Kanukanu Tapu nei: ‘Te hatu na ti'aki e na pegea 'ati hage, na sui o hai ai te Poutu'u o te Hage. ");
INSERT INTO mnv_vpl VALUES ("MK12_11","071_12_11","MRK","12","11","11","Te hai 'anga nei kua 'oti i te hai e te 'Aitu, kae hu'ai gaoi ki atatou hiina'i 'anga kinai.’ ” ");
INSERT INTO mnv_vpl VALUES ("MK12_12","071_12_12","MRK","12","12","12","Ka na gaataki a kigatou ke he 'osohi kia Jesus, iteme'agaa noko na'a e kigatou ko Ia manga gea i te haka gaataki haka makau ia te kigatou. Ka ko kigatou noko matataku ki te 'apitanga, ma te ti'aki e kigatou ia te Ia kae boo. ");
INSERT INTO mnv_vpl VALUES ("MK12_13","071_12_13","MRK","12","13","13","Mugi kigatou o haka to'o na pegea i na Pharisee ma na pegea o Herod, ke haka anuanu pake ia Jesus. ");
INSERT INTO mnv_vpl VALUES ("MK12_14","071_12_14","MRK","12","14","14","Boomai kigatou o hai atu kia te Ia, “Ako, e na'a e kimatou ko Koe te pegea hakamaatu'a, he'e haka gata ki na tegeu'a a pegea, iteme'agaa ko Koe he'e ua ki na noho o gaatou; ka ko Koe manga ako te maa'ogi i na noho o te 'Aitu. Te hai 'anga gaoi te tau'i takis kia Caesar po si'ai? ");
INSERT INTO mnv_vpl VALUES ("MK12_15","071_12_15","MRK","12","15","15","E hai kitatou tau'i kinai po si'ai?” Ka ko Jesus noko manga na'a e Ia agatou mou toto'o 'anga, ma te hai atu kinai, “ 'Eaa e haka anuanu pake ai e koutou ia te Au? To'o mai he mane kau ina kinai.” ");
INSERT INTO mnv_vpl VALUES ("MK12_16","071_12_16","MRK","12","16","16","Nimaa to'o ake e kigatou te mane, ma te haka anu kinai a Jesus o hai atu, “To'ai te 'ata, ma to'ai te haka 'igonga te manga i te mane nei?” Haka tau kigatou o hai atu, “O'o Caesar.” ");
INSERT INTO mnv_vpl VALUES ("MK12_17","071_12_17","MRK","12","17","17","Ma te hai atu a Jesus kia te kigatou, “ 'Abatu kia Caesar nia a'a Caesar, kae haiga'a atu kia te 'Aitu nia a'a te 'Aitu.” Ko kigatou na he tu'ia 'aki ia te Ia. ");
INSERT INTO mnv_vpl VALUES ("MK12_18","071_12_18","MRK","12","18","18","Na Sadducee noko haka si'ai e kigaatou te maa'ugi giu mai i te mate. Noko boomai kia Jesus ma te haka anu. ");
INSERT INTO mnv_vpl VALUES ("MK12_19","071_12_19","MRK","12","19","19","Ko kigatou noko hai atu, “Ako, ko Moses noko kanukanu te tagangonga nei kia te kitatou: Nimaa mate he ta'okete mo'o he tangata kae ti'aki tona uguugu he'e tau tama giki, te tangata e hai ke sui ia o pipiki te hahine magepe nei, ke go hai ni tama giki mo'o tena ta'okete. ");
INSERT INTO mnv_vpl VALUES ("MK12_20","071_12_20","MRK","12","20","20","Ka noko iai te 'api taangata toka hitu, na hai uguugu te 'ugumatu'a ka na mate he'e tau tama giki. ");
INSERT INTO mnv_vpl VALUES ("MK12_21","071_12_21","MRK","12","21","21","Sui te tangata e taha kinai o pipiki te hahine magepe, ka na mate ma'u, si'ai ma'ana ni tama giki. Na konaa na noho ma'u te tangata noko togu kinai te 'api. ");
INSERT INTO mnv_vpl VALUES ("MK12_22","071_12_22","MRK","12","22","22","Na si'ai he tangata i te 'api toka hitu hai ma'ana ni tama giki. Ka na mugi te hahine nei o mate ma'u. ");
INSERT INTO mnv_vpl VALUES ("MK12_23","071_12_23","MRK","12","23","23","Ka nimaa go i te maa'ugi giu 'anga, to'ai te uguugu te hahine nei? Iteme'agaa na pipiki ngatahi e te toka hitu.” ");
INSERT INTO mnv_vpl VALUES ("MK12_24","071_12_24","MRK","12","24","24","Haka tau kinai a Jesus o hai atu, “Koutou e saga, iteme'agaa e he'e na'a e koutou na Kanukanu Tapu po te taganga o te 'Aitu. ");
INSERT INTO mnv_vpl VALUES ("MK12_25","071_12_25","MRK","12","25","25","Te 'aso kago maa'ugi giu mai ai a pegea mai te mate, ko kigatou kago he'e taka, kago he'e hai uguugu ma te he'e hai matu'a ma'u, ko kigaatou kago noho pe na ensel i te nuku i te gangi. ");
INSERT INTO mnv_vpl VALUES ("MK12_26","071_12_26","MRK","12","26","26","Ka na noho o te maa'ugi giu mai 'anga mai te mamate 'anga: 'Ai koutou noko he'e haka sahe i te buka a Moses i te taga tupu'a o te ga'akau noko bega? Noko hai atu ai a te 'Aitu kia Moses, ‘Ko Au te 'Aitu o Abraham, ma te 'Aitu o Isaac, ma te 'Aitu o Jacob.’ ");
INSERT INTO mnv_vpl VALUES ("MK12_27","071_12_27","MRK","12","27","27","Ko Ia he'e te 'Aitu o na pegea mamate, ka te 'Aitu o na pegea maa'ugi. Koutou hu'ai saga!” ");
INSERT INTO mnv_vpl VALUES ("MK12_28","071_12_28","MRK","12","28","28","Noko iai te launatasi i na ako o na tagangonga noko a'u o haka gongo ki agatou hegeu 'anga, o na'a eia ko Jesus noko gaoi ana haka tau 'anga, koia na konei ana haka anu kia Jesus, “Tehea te hu'ai me'a i na tagangonga?” ");
INSERT INTO mnv_vpl VALUES ("MK12_29","071_12_29","MRK","12","29","29","Ma te haka tau kinai a Jesus o hai atu, “Tenei te hu'ai me'a i na tagangonga: ‘Haka gongo mai ba'i pegea o Israel, ko te 'Agiki tetatou 'Aitu manga tenaa te 'Agiki e tasi. ");
INSERT INTO mnv_vpl VALUES ("MK12_30","071_12_30","MRK","12","30","30","Ma'ine atu kia te 'Agiki te 'Aitu o 'ou, i tou uso ngatahi, ma tou ma'ugi ngatahi, ma au haingaa tegeu'a ngatahi, ma au to'a 'anga ngatahi.’ ");
INSERT INTO mnv_vpl VALUES ("MK12_31","071_12_31","MRK","12","31","31","Ka te me'a e gua kinai e konei na noho: ‘Ma'ine atu ki ou pegea e pata mai, ke noho pe au ma'ine 'anga kia te koe.’ E si'ai ma'u he tagangonga ke hua'eha o sigi i gua nei.” ");
INSERT INTO mnv_vpl VALUES ("MK12_32","071_12_32","MRK","12","32","32","Te tangata nei na haka tau kinai o hai atu, “Ako, hu'ai gaoi, ko koe e maa'ogi i tau gea 'anga na, e launatasi ko te 'Aitu, e si'ai ma'u he 'Aitu ka manga ko Ia. ");
INSERT INTO mnv_vpl VALUES ("MK12_33","071_12_33","MRK","12","33","33","Ke ma'ine kia te 'Aitu i tou uso ngatahi, ma au haingaa tegeu'a ngatahi, ma au to'a 'anga ngatahi, ma te ma'ine ki ou pegea e pata mai ke noho pe au ma'ine 'anga kia te koe, e hua'eha o sigi i te mou hage o na ga'a, ma na beegiunga.” ");
INSERT INTO mnv_vpl VALUES ("MK12_34","071_12_34","MRK","12","34","34","Te na'a 'anga e Jesus tena haka tau 'anga nei e 'igo'igo, ma te hai atu kia te ia, “Ko koe e he'e mama'o i te Hakahua 'anga a te 'Aitu.” Haka tu'u i te gholoba na o hano, na si'ai he pegea tegeu'a ke konei na haka anu haka soatu i he me'a kia te Ia. ");
INSERT INTO mnv_vpl VALUES ("MK12_35","071_12_35","MRK","12","35","35","Te gholoba noko manga ako ai a Jesus i goto i te Hage Tapu, noko haka anu, “ 'Eaa e hai ake ai na ako o na tagangonga te 'Agiki Taga'ia te Hosa o David? ");
INSERT INTO mnv_vpl VALUES ("MK12_36","071_12_36","MRK","12","36","36","Ka ko David noko hai ake i te haka niniko e te Spirit Tapu o kogaa ana to'o: ‘Ko te 'Agiki noko hai atu ki toku Hakahua: Noho mai i toku pa'asi maui ke hano ano pau Au o tuku gago na makau o'ou i ou gago ba'e.’ ");
INSERT INTO mnv_vpl VALUES ("MK12_37","071_12_37","MRK","12","37","37","Ko David noko mate ake eia tena ‘Hakahua’, kae kohea na hai o hai ai te Hosa o David?” Te 'apitanga noko haka gongo kia te Ia ma te hu'ai magagaohie. ");
INSERT INTO mnv_vpl VALUES ("MK12_38","071_12_38","MRK","12","38","38","Ko Jesus noko ako o hai atu, “Na'ana'a atu ki na ako o na tagangonga. Ko kigatou manga siahahai ki na mamago 'anga i na ake gogoa o he boboo 'aki kae oho e te 'apitanga i na kunga tau'i. ");
INSERT INTO mnv_vpl VALUES ("MK12_39","071_12_39","MRK","12","39","39","Ma te manga noho 'aki i na noohonga gaoi i na Hage hai paaunga, ma na noohonga o na hakahua i na haka tahinga. ");
INSERT INTO mnv_vpl VALUES ("MK12_40","071_12_40","MRK","12","40","40","E hai songo e kigatou na hage o na haahine magegepe, kae manga haka 'agi ia te kigatou i te hai agatou taakunga o gogoa. Na haingaa pegea nei kago hua'e'eha ogatou kagohia.” ");
INSERT INTO mnv_vpl VALUES ("MK12_41","071_12_41","MRK","12","41","41","Ko Jesus noko manga noho hitaiaki ki te kete tape mane o noko manga mata e Ia te 'apitanga noko tuku mane ki te kete tape mane. Noko 'eha pegea ga'u seu hu'ai tu'u mane kinai. ");
INSERT INTO mnv_vpl VALUES ("MK12_42","071_12_42","MRK","12","42","42","Ka noko iai te hahine magepe kae hu'ai lae, noko hinake o tuku kinai eia te toka gua mi'i mane. ");
INSERT INTO mnv_vpl VALUES ("MK12_43","071_12_43","MRK","12","43","43","Haka putu e Jesus ona pegea haka ako kia te Ia o hai atu kinai, “Ko Au e gea maa'ogi kia te koutou: Te hahine magepe lae nei e hua'eha te me'a e tuku eia ki te kete tape mane o sigi i gaa. ");
INSERT INTO mnv_vpl VALUES ("MK12_44","071_12_44","MRK","12","44","44","Ko kigatou manga haiga'a mane o 'eha i agatou hu'ai ga'unga, ka te hahine hu'ai lae nei, e tuku ngatahi nia e hai ke noko ma'ugi kinai.” ");
INSERT INTO mnv_vpl VALUES ("MK13_1","071_13_1","MRK","13","1","1","Nimaa sopo a Jesus ki haho i te Hage Tapu, te launatasi i ona pegea haka ako noko hai atu kia te Ia, “Ako, 'ai ina 'atu! Na hu'ai hatu! Na hu'ai goosinga matanga gaoi!” ");
INSERT INTO mnv_vpl VALUES ("MK13_2","071_13_2","MRK","13","2","2","Ma te haka tau kinai a Jesus o hai atu, “Ko koe e ina ki na hu'ai goosinga nei? Kago si'ai ni hatu ke go noko he heketi 'aki, ko ba'i hatu e hai ke go seuseu.” ");
INSERT INTO mnv_vpl VALUES ("MK13_3","071_13_3","MRK","13","3","3","Nimaa noho a Jesus i te Ogo i Olives i tegaa pa'asi i te Hage Tapu, ko Peter ma James ma John ma Andrew noko haka ene 'aki kia te Ia i tegatou noho 'aki soko 'anga o hai atu, ");
INSERT INTO mnv_vpl VALUES ("MK13_4","071_13_4","MRK","13","4","4","“Hogahoga mai kia te kimatou, po tehea te 'aso kago hai ai na hai 'anga nei? Ma tehea ma'u te haka 'igonga o na hai 'anga nei e hitaiaki ke haka maa'ogi?” ");
INSERT INTO mnv_vpl VALUES ("MK13_5","071_13_5","MRK","13","5","5","Ma te hai atu a Jesus kia te kigatou, “Na'ana'a atu ka ke go noka he pegea te konei ana goi kia te koutou. ");
INSERT INTO mnv_vpl VALUES ("MK13_6","071_13_6","MRK","13","6","6","E 'eha pegea kago boomai i toku ingoa ogo taki hai atu, ‘Tenei au,’ kae gogoi ai ki te 'apitanga. ");
INSERT INTO mnv_vpl VALUES ("MK13_7","071_13_7","MRK","13","7","7","Na 'aso kago noko haka gongo ai koutou ki na sagatau'a ma na ba'aki 'anga ki na sagatau'a, ogo noka tautou matataku: Na hai 'anga na e hai ke tatae mai, ka te 'otinga manga koi he'e tatae mai. ");
INSERT INTO mnv_vpl VALUES ("MK13_8","071_13_8","MRK","13","8","8","Ko pegea e hai ke go noko he taa 'aki ma gaa pegea, ma ba'i sa'a e hai ke go noko he taa 'aki, 'eha kunga henua e hai ke go o'i o'i, kae ongesau ma'u. Na hai 'anga nei te haka tu'u 'anga o te haka gongo songo e noho pe te mamae 'anga o te hahine guea. ");
INSERT INTO mnv_vpl VALUES ("MK13_9","071_13_9","MRK","13","9","9","“Koutou hai ke na'ana'a, na'e koutou hai ke go tuku 'ia ki na paaunga o na puugenga, ogo kogu ia te koutou i na Hage hai paaunga i te ghaghi ia te Au. Koutou e hai ke go tutu'u 'ago i ba'i pegea hai paaunga ma na hakahua ogo noko 'atigongo kia te kigatou. ");
INSERT INTO mnv_vpl VALUES ("MK13_10","071_13_10","MRK","13","10","10","Ka te Gongo Gaoi e hai ke mataa tohi'aki ai ki na pegea i ba'i kakai 'anga. ");
INSERT INTO mnv_vpl VALUES ("MK13_11","071_13_11","MRK","13","11","11","Ka na 'aso kago kakabe 'ia ai koutou ki te haka aba, ogo noka tautou mataa maikia po nia hai koutou go gegea ai, kae go manga gegea atu i nia e hai ke go haiga'a kia te koutou i te gholoba na, iteme'agaa e he'e ko koutou te gegea, ka te Spirit Tapu. ");
INSERT INTO mnv_vpl VALUES ("MK13_12","071_13_12","MRK","13","12","12","“Te hai ta'okete kago haka soko tena taina ke go taa 'ia ke mate. Ma te tamana kago haka soko tena tama 'iti'iti. Na matiginga kago haka hetata'i ki ogatou hai maatu'a, o taa ia te kigatou o mamate. ");
INSERT INTO mnv_vpl VALUES ("MK13_13","071_13_13","MRK","13","13","13","Ko ba'i pegea kago he'e siahahai kia te koutou i te ghaghi i toku ingoa. Ka koai kago pipiki ia te ia ano hetae ki tona 'otinga, tenaa ia e hai ke go ma'ugi. ");
INSERT INTO mnv_vpl VALUES ("MK13_14","071_13_14","MRK","13","14","14","“Koutou kago hiina'i ki ‘te me'a songo to'a kago hai songo ba'i me'a’, manga tu'u i te kunga he'e hai ke tu'u ai. Te pegea kago haka sahe eia, ke na'a eia. Te gholoba na, na pegea i Judea ke he 'agiko ki na ogo. ");
INSERT INTO mnv_vpl VALUES ("MK13_15","071_13_15","MRK","13","15","15","He pegea manga i te hohonga o tena hage, ogo noka te sopo ki gago po e ugu ki goto ke sa'u iho ai he me'a. ");
INSERT INTO mnv_vpl VALUES ("MK13_16","071_13_16","MRK","13","16","16","He pegea manga noho i tena 'umanga, ogo noka te hoki ki te hage o to'o tena ake. ");
INSERT INTO mnv_vpl VALUES ("MK13_17","071_13_17","MRK","13","17","17","E hai ke go hu'ai sanga songo ai na haahine kago hai tama ma na haahine kago haa uu mi'i tama giki i na 'aso na. ");
INSERT INTO mnv_vpl VALUES ("MK13_18","071_13_18","MRK","13","18","18","Takunga atu i te hai 'anga nei ke go noka te hai i na 'aso gogohi. ");
INSERT INTO mnv_vpl VALUES ("MK13_19","071_13_19","MRK","13","19","19","Iteme'agaa na hu'ai sanga songo 'anga i na 'aso na, noko si'ai ni sanga songo konei na noho haka tu'u mai i te gosigosi 'anga e te 'Aitu a te kege nei, ano hetae mai ki na 'aso nei. Kago he'e konei na noho ma'u ini 'aso mugi mai. ");
INSERT INTO mnv_vpl VALUES ("MK13_20","071_13_20","MRK","13","20","20","Ka poi he'e hai e te 'Aitu na 'ao na ke pupulu, kago si'ai he launatasi ke go ogataki, ka i te ghaghinga i ona pegea haka pupugu kua 'oti i te haka pau e Ia, e hai ke go haka soo mai ai e Ia na 'ao na. ");
INSERT INTO mnv_vpl VALUES ("MK13_21","071_13_21","MRK","13","21","21","Te 'aso na, nimaa hai atu ai he pegea kia te koutou, ‘Hiina'i mai, tenei te 'Agiki Taga'ia,’ po e hai atu, ‘Hiina'i atu, tena Ia!’ ogo noka tautou too kinai. ");
INSERT INTO mnv_vpl VALUES ("MK13_22","071_13_22","MRK","13","22","22","Iteme'agaa e hai ke go boomai ni pegea taga'ia gogoi ma ni taauga gogoi ogo noko hai haka 'igonga ma te hai ni me'a haingata'a, ke go pake ai na pegea na 'oti i te haka pupugu i te poi 'aonga. ");
INSERT INTO mnv_vpl VALUES ("MK13_23","071_13_23","MRK","13","23","23","Kae na'ana'a atu, na'e kua 'oti i te mataa hogahoga e Au ba'i hai 'anga kia te koutou. ");
INSERT INTO mnv_vpl VALUES ("MK13_24","071_13_24","MRK","13","24","24","“Ka i na 'ao na, nimaa go sigi na haka gongo songo 'anga, ‘e hai ke go poo'ugi ma'u ai te ga'aa, ma te kago he'e maagama ai te maahina. ");
INSERT INTO mnv_vpl VALUES ("MK13_25","071_13_25","MRK","13","25","25","Na hetu'u e hai ke go hetoki iho ma'u mai te 'agohi gangi, ma ba'i me'a i te gangi e hai ke go o'i o'i ngatahi.’ ");
INSERT INTO mnv_vpl VALUES ("MK13_26","071_13_26","MRK","13","26","26","I na 'aso na, ko pegea e hai ke go hiina'i ki te Hosa o Pegea e a'u i na po'ao ma na taganga ma te mamagunga. ");
INSERT INTO mnv_vpl VALUES ("MK13_27","071_13_27","MRK","13","27","27","Ko Ia kago haka to'o mai ona ensel, o haka putu ona pegea haka pau i te toka haa pa'asi o te kege nei, kago haka tu'u i te 'otinga o te kege nei o hetae ki te 'otinga o te gangi. ");
INSERT INTO mnv_vpl VALUES ("MK13_28","071_13_28","MRK","13","28","28","“Koutou haka ako atu i te haka gaataki o te ga'akau e mate te ‘fig’. Nimaa motomoto ona ga'a kae sosomo ona gau, e na'a e koutou e hitaiaki na 'aso mahana. ");
INSERT INTO mnv_vpl VALUES ("MK13_29","071_13_29","MRK","13","29","29","Manga konei na noho ma'u, na 'aso kago hiina'i ai koutou ki nia kua gea ai Au, e hai ke go na'a ai e koutou toku 'aso hokimai e hitaiaki, e hu'ai napi. ");
INSERT INTO mnv_vpl VALUES ("MK13_30","071_13_30","MRK","13","30","30","Ko Au e gea maa'ogi kia te koutou: Te 'atu tangata nei kago noko noho 'aki kae hai na hai 'anga nei. ");
INSERT INTO mnv_vpl VALUES ("MK13_31","071_13_31","MRK","13","31","31","Ko te gangi ma te kege nei e hai ke go haka masogo, ka 'aku haka hegeunga ka noko noho ki ba'i 'aso. ");
INSERT INTO mnv_vpl VALUES ("MK13_32","071_13_32","MRK","13","32","32","“E si'ai he pegea ke na'a eia te 'ao po te gholoba, e he'e na'a ma'u ena ensel i te gangi, o he'e na'a ma'u e te Hosa, ka manga na'a launatasi e te Tamana. ");
INSERT INTO mnv_vpl VALUES ("MK13_33","071_13_33","MRK","13","33","33","Ka koutou ge'o atu ma te na'ana'a, na'e he'e na'a e koutou po tehea te 'aso kago a'u ai na hai 'anga nei. ");
INSERT INTO mnv_vpl VALUES ("MK13_34","071_13_34","MRK","13","34","34","Na hai 'anga nei manga noho pe te pegea hano 'aatea kae tuku tena hage ki ona guani. Noko tuku ia te kigatou ke taki hai agatou hekau, kae kaunaki tegaa e ge'o te aga ke noko na'ana'a. ");
INSERT INTO mnv_vpl VALUES ("MK13_35","071_13_35","MRK","13","35","35","“Koutou e hai ke konei na na'ana'a, iteme'agaa e he'e na'a e koutou po tehea te 'aso kago a'u ai te hakahua o te hage, kago a'u i te ahiahi po te tu'u gua poo, po na gholoba tatangi paolo, po te taha o te 'ao. ");
INSERT INTO mnv_vpl VALUES ("MK13_36","071_13_36","MRK","13","36","36","Ka koia nimaa go hoki ghali mai, kego noka te kite ia te koutou manga momoe. ");
INSERT INTO mnv_vpl VALUES ("MK13_37","071_13_37","MRK","13","37","37","Nia e gea ai Au kia te koutou, e gea ma'u ai Au ki te 'apitanga: Noko he na'ana'a 'aki atu.” ");
INSERT INTO mnv_vpl VALUES ("MK14_1","071_14_1","MRK","14","1","1","Noko toe te guanga 'ao ka ke hai te Passover, ma te Kainga Bred he'e tau Me'a Haka tupu Utunga. Ka na hakahua o na priest ma na ako o na tagangonga noko maa ligo e kigatou po ke kohea agatou mou toto'o ke he 'osohi huu kia Jesus kigatou taa 'ia. ");
INSERT INTO mnv_vpl VALUES ("MK14_2","071_14_2","MRK","14","2","2","Ka na hai ake kigatou, “Ke noka te hai i te 'aso o te Kainga, na'e kitai go hetau ai te 'apitanga.” ");
INSERT INTO mnv_vpl VALUES ("MK14_3","071_14_3","MRK","14","3","3","Te gholoba noko manga iai a Jesus i Bethany, noko manga noho i te kaupea kai i te hage o Simon te pegea noko kahoa, kae hinake te hahine manga kopi eia te poati, tena ingoa te alabasta, manga honu i te bai hu'ai tutuu gaoi, noko hu'ai 'eha ona mane, noko gosigosi mai i te mi'i ga'akau e ingoa te nadi. Na totohi e te hahine nei te mata o te poati o gigingi eia te bai hu'ai tutuu gaoi ki te 'ugu o Jesus. ");
INSERT INTO mnv_vpl VALUES ("MK14_4","071_14_4","MRK","14","4","4","Noko iai na pegea i te hage, noko haka tangi 'aki ai o hai ake, “ 'Eaa e maumau ai te bai hu'ai tutuu gaoi?! ");
INSERT INTO mnv_vpl VALUES ("MK14_5","071_14_5","MRK","14","5","5","Te bai nei poi tau'i kua sigi i te togunga gau mane siliva, ke haiga'a ki na pegea lae.” Kae huhu toto'a kigatou kia te ia. ");
INSERT INTO mnv_vpl VALUES ("MK14_6","071_14_6","MRK","14","6","6","Ka noko hai atu a Jesus kia te kigatou, “Saunonoa atu kinai. 'Eaa e haka patu'a ai e koutou ia te ia? E hai eia te hai 'anga hu'ai gaoi kia te Au. ");
INSERT INTO mnv_vpl VALUES ("MK14_7","071_14_7","MRK","14","7","7","Na pegea lae ka noko haka pata kia te koutou i ba'i 'aso, kago noko 'aabaki kinai koutou i ni 'aso siahahai kinai koutou, ka ko Au ka he'e noko haka pata kia te koutou ki ba'i 'aso. ");
INSERT INTO mnv_vpl VALUES ("MK14_8","071_14_8","MRK","14","8","8","Te hahine nei e hai eia nia e 'aonga te hai, kua gigingi eia te bai hu'ai tutuu gaoi ki toku tino ke haka ngaague ki toku 'aso mate o tanu. ");
INSERT INTO mnv_vpl VALUES ("MK14_9","071_14_9","MRK","14","9","9","Ko Au e gea maa'ogi kia te koutou: Kohea na kunga i te kege nei kago noko tohi'aki ai i te Gongo Gaoi, te hai 'anga e hai e te hahine nei, kago noko hogahoga ma'u, ke go noko maanatu ai kia te ia.” ");
INSERT INTO mnv_vpl VALUES ("MK14_10","071_14_10","MRK","14","10","10","'Io mugi a Judas Iscariot, te launatasi i te katoa tuma'a e gua pegea haka ako, o hano ki na hakahua o na priest ke haka soko ia Jesus kia te kigatou. ");
INSERT INTO mnv_vpl VALUES ("MK14_11","071_14_11","MRK","14","11","11","Ko kigatou na hu'ai magagaohie i te haka gongo 'anga kinai, ma te tuku kupu kia Judas ke go 'abange mane kinai. Ma te mamata e Judas he gholoba tau gaoi kego haiga'a ai ia Jesus kia te kigatou. ");
INSERT INTO mnv_vpl VALUES ("MK14_12","071_14_12","MRK","14","12","12","I te 'ao mu'a o te haka tahinga ana Jew e ingoa te Passover, e ta'anga kai ai na bred he'e tau me'a haka tupu utunga, te 'aso e iai ma'u tegatou hesuinga te taa he punua sipisipi o gosigosi ai he kainga mo'o te Passover, na pegea haka ako o Jesus noko haka anuanu atu kia te Ia, “Tehea te kunga e siahai Koe kimatou ngaague 'ia kego kai ai Koe i te kainga o te Passover?” ");
INSERT INTO mnv_vpl VALUES ("MK14_13","071_14_13","MRK","14","13","13","Ma te haka to'o e Ia te toka gua i ona pegea haka ako, kae hai atu kia te kigaaua, “Boo atu ki te hu'ai manaha, na'e kougua e hai ke go sasa'o ki te tangata manga 'amo eia te bai i te hu'ai poati, ogo tata'o atu ia te ia. ");
INSERT INTO mnv_vpl VALUES ("MK14_14","071_14_14","MRK","14","14","14","Ogo hai atu ki te hakahua o te hage kago ugu kinai, ‘Te Ako e haka anu, Tehea toku potu hage e hai kau kai haka pigi ai ki oku pegea haka ako i te kainga o te Passover?’. ");
INSERT INTO mnv_vpl VALUES ("MK14_15","071_14_15","MRK","14","15","15","Kago haka kite eia te hu'ai kunga i te hohonga o te hage, manga iai ba'i me'a kua ngaague. Ogo ngaague atu ai kia te kitatou.” ");
INSERT INTO mnv_vpl VALUES ("MK14_16","071_14_16","MRK","14","16","16","Na boo gua pegea haka ako ki te te hu'ai manaha o kite e kigaaua ba'i me'a manga noho maa'ogi ki te gea 'anga a Jesus kia te kigaaua, ma te ngaague e kigaaua te Passover. ");
INSERT INTO mnv_vpl VALUES ("MK14_17","071_14_17","MRK","14","17","17","Nimaa ahiahi, kae hetae mai a Jesus ma tona katoa tuma'a e gua pegea. ");
INSERT INTO mnv_vpl VALUES ("MK14_18","071_14_18","MRK","14","18","18","Te gholoba noko manga koi noho 'aki ai kigatou i te kaupea o kai, ko Jesus noko hai atu, “Ko Au e gea maa'ogi kia te koutou: E iai te pegea ia te koutou ka haka soko eia ia te Au. Koia manga kai haka pata kia te Au.” ");
INSERT INTO mnv_vpl VALUES ("MK14_19","071_14_19","MRK","14","19","19","Ko kigatou na hu'ai he nohonoho maase'i 'aki, o manga taki hai atu kia te Ia, “ 'Eaa? He'e ko au 'ine?” ");
INSERT INTO mnv_vpl VALUES ("MK14_20","071_14_20","MRK","14","20","20","Ma te haka tau atu a Jesus, “Koia te launatasi i te katoa tuma'a e gua pegea, manga baa mene a maua momo bred ki te supu e i-te peleti e tasi. ");
INSERT INTO mnv_vpl VALUES ("MK14_21","071_14_21","MRK","14","21","21","Te Hosa o Pegea e hai ke manga hano haka papata ki nia e hai ake ai na Kanukanu Tapu ia te Ia. Kae haka 'aagoha te tangata kago haka soko eia te Hosa o Pegea. Koia noko gaoi i te poi he'e haka haa.” ");
INSERT INTO mnv_vpl VALUES ("MK14_22","071_14_22","MRK","14","22","22","Te gholoba noko manga koi kai ai, ko Jesus noko sa'u ake e Ia te bred o haka 'aue ai, kae tohitohi o haiga'a atu ki ona pegea haka ako kae hai atu, “He 'osohi ake kinai, na'e tenei toku tino.” ");
INSERT INTO mnv_vpl VALUES ("MK14_23","071_14_23","MRK","14","23","23","Kae sa'u mai te kapu o haka 'aue, kae haiga'a atu kia te kigatou, o bibinu ai kigatou. ");
INSERT INTO mnv_vpl VALUES ("MK14_24","071_14_24","MRK","14","24","24","Hai atu a Jesus kia te kigatou, “Tenei toku toto e singa mo'o te 'apitanga ke go he tu'utaki 'aki ai a te 'Aitu ma ba'i pegea. ");
INSERT INTO mnv_vpl VALUES ("MK14_25","071_14_25","MRK","14","25","25","Ko Au e gea maa'ogi kia te koutou, ko Au kago he'e binu waeni hoki, hano ano hetae ki te 'ao kago binu waeni hoki ai Au ma kaa haka pigi Au ki na pegea i te Hakahua 'anga a te 'Aitu.” ");
INSERT INTO mnv_vpl VALUES ("MK14_26","071_14_26","MRK","14","26","26","Te gholoba na taugua ai kigatou i te taugua ogiogi, kae boo kigatou ki te Ogo i Olives. ");
INSERT INTO mnv_vpl VALUES ("MK14_27","071_14_27","MRK","14","27","27","Ko Jesus noko gea kia te kigatou, “Koutou ngatahi kago boo 'aatea, iteme'agaa na 'oti i te hai ake na Kanukanu Tapu: ‘E hai kau go taa 'ia te tangata ge'o sipisipi, ka ke go maseuseu na sipisipi.’ ");
INSERT INTO mnv_vpl VALUES ("MK14_28","071_14_28","MRK","14","28","28","Ka te gholoba kago ma'ugi hoki ai Au, e hai kau go mu'a ia te koutou ki Galilee.” ");
INSERT INTO mnv_vpl VALUES ("MK14_29","071_14_29","MRK","14","29","29","Hai atu a Peter, “Masi'igoa ko ba'i pegea kago boo 'aatea ia te Koe, ko au kago he'e hano.” ");
INSERT INTO mnv_vpl VALUES ("MK14_30","071_14_30","MRK","14","30","30","Ma te haka tau kinai a Jesus o hai atu, “Ko Au e gea maa'ogi kia te koe: Te 'ao nei i ma kaa poo, ko koe kago haka si'ai haka togu e koe ia te Au, kae mugi o tangi haka gua te paolo.” ");
INSERT INTO mnv_vpl VALUES ("MK14_31","071_14_31","MRK","14","31","31","Ka ko Peter noko pau o haka suki atu, “He'e po te mate haka pigi au kia te Koe, koau kago he'e 'aonga te haka si'ai eau ia te Koe.” Kogaa pegea noko konei agatou gegea ma'u. ");
INSERT INTO mnv_vpl VALUES ("MK14_32","071_14_32","MRK","14","32","32","Ko kigatou noko boo ki te kunga noko mate ko Gethsemane, kae hai atu a Jesus ki ona pegea haka ako, “Noho 'aki iho i te kunga nei i te gholoba e taakunga ai Au.” ");
INSERT INTO mnv_vpl VALUES ("MK14_33","071_14_33","MRK","14","33","33","Kae kakabe e Ia ia Peter ma James ma John o tata'o ia te Ia, ka na haka tu'u haka gongo songo ma te tiha'ia. ");
INSERT INTO mnv_vpl VALUES ("MK14_34","071_14_34","MRK","14","34","34","Ma te hai atu Ia kia te kigatou, “Toku uso e hua'eha kinai te 'agoha manga hai kau mate; noho 'aki iho i te kunga nei o noko na'ana'a.” ");
INSERT INTO mnv_vpl VALUES ("MK14_35","071_14_35","MRK","14","35","35","Ko Jesus noko hano haka soatu, o too ki te kege o konei ana taakunga i te poi haingaohie, ke sigi 'aki te gholoba haingata'a kia te Ia. ");
INSERT INTO mnv_vpl VALUES ("MK14_36","071_14_36","MRK","14","36","36","Kae hai ake ma'u, “Tamau, ko ba'i me'a manga haingaohie kia te Koe. Sa'u 'aatea atu te kapu nei ia te Au. Ka ke noka te hai nia te siahai kinai Au, ka ke manga hai nia e siahai kinai Koe.” ");
INSERT INTO mnv_vpl VALUES ("MK14_37","071_14_37","MRK","14","37","37","Nimaa hoki atu Ia ki ona pegea haka ako o kite ia te kigatou manga momoe, ma te hai atu kia Peter, “Simon, 'ai ko koe manga moe? 'Ai ko koe e he'e 'aonga te na'ana'a i he mi'i gholoba e tasi? ");
INSERT INTO mnv_vpl VALUES ("MK14_38","071_14_38","MRK","14","38","38","Koutou he na'ana'a 'aki atu ma te taakunga, ka ke go noka tautou haa'oa ki na pakenga. Te uso e maangao, ka te tino e lologi.” ");
INSERT INTO mnv_vpl VALUES ("MK14_39","071_14_39","MRK","14","39","39","Ma te hoki a Jesus o manga taakunga hoki i na me'a kua mataa taakunga ai. ");
INSERT INTO mnv_vpl VALUES ("MK14_40","071_14_40","MRK","14","40","40","Ka te gholoba noko hoki mai ai, sasa'o hoki kia te kigatou manga koi momoe, iteme'agaa ko kigatou noko manga koi sia momoe toto'a. Ko kigatou na he'e na'a po nia hai ke gegea ai kia Jesus. ");
INSERT INTO mnv_vpl VALUES ("MK14_41","071_14_41","MRK","14","41","41","Nimaa te hokimai hakatogu a Jesus, hai atu kia te kigatou, “Koutou manga koi momoe ma te okioki? Kua 'aonga! Te gholoba kua hetae mai. Hiina'i atu, te Hosa o Pegea e haka soko 'ia ki na paaunga ana pegea 'oosongo. ");
INSERT INTO mnv_vpl VALUES ("MK14_42","071_14_42","MRK","14","42","42","Tutu'u ake, kitatou boo, tenei te pegea e haka soko ia te Au te a'u nei!” ");
INSERT INTO mnv_vpl VALUES ("MK14_43","071_14_43","MRK","14","43","43","Te gholoba noko manga koi gea ai a Jesus, kae sopo mai a Judas te pegea ma'u i te katoa tuma'a e gua pegea haka ako. Noko tata'o mai ai te hu'ai tu'u pegea ma agatou kiba ma na ga'akau, noko kaunaki e na hakahua o na priest, ma na ako o na tagangonga, ma na 'agiki o na Jew. ");
INSERT INTO mnv_vpl VALUES ("MK14_44","071_14_44","MRK","14","44","44","Te pegea noko hakasoko kua haka tinogaoi eia te haka 'igonga kia te kigatou: “Te pegea kago sosongi ai au, tenaa te tangata. Ogo he 'osohi atu kinai o kakabe o noko ge'o gaoi.” ");
INSERT INTO mnv_vpl VALUES ("MK14_45","071_14_45","MRK","14","45","45","Ko Judas na ghali atu kia Jesus o hai atu, “Ako!” kae sosongi atu ia te Ia. ");
INSERT INTO mnv_vpl VALUES ("MK14_46","071_14_46","MRK","14","46","46","Ma te he 'osohi saghaghi na taangata kia Jesus o kakabe ia te Ia. ");
INSERT INTO mnv_vpl VALUES ("MK14_47","071_14_47","MRK","14","47","47","Ma te sa'u ake te kiba a te pegea noko manga tu'u haka hitaiaki mai o haka iho ki te guani o te hakahua o na priest o sabi te taginga o'ona. ");
INSERT INTO mnv_vpl VALUES ("MK14_48","071_14_48","MRK","14","48","48","Ma te hai atu a Jesus kia te kigatou, “ 'Ai ko Au te pegea haka tauseke, ka ke boo mai koutou ma autou kiba ma autou ga'akau ke labu ai ia te Au? ");
INSERT INTO mnv_vpl VALUES ("MK14_49","071_14_49","MRK","14","49","49","Ko ba'i 'aso Ko Au noko manga haka pata kia te koutou ma te ako ia te koutou i te Hage Tapu, ka koutou noko he'e he 'osohi kia te Au. Ka manga konei na hai, ka ke haka maa'ogi ai nia e i-na Kanukanu Tapu.” ");
INSERT INTO mnv_vpl VALUES ("MK14_50","071_14_50","MRK","14","50","50","Ma te ti'aki ngatahi e na pegea kae he 'agiko. ");
INSERT INTO mnv_vpl VALUES ("MK14_51","071_14_51","MRK","14","51","51","Noko iai te tangata tamatama noko he'e 'agoaki manga mago i te ake susugu, noko ma tata'o ia Jesus. Te gholoba na labu ai e kigaatou ia te ia, ");
INSERT INTO mnv_vpl VALUES ("MK14_52","071_14_52","MRK","14","52","52","na ti'aki tona ake, kae manga tege he'e tau mago. ");
INSERT INTO mnv_vpl VALUES ("MK14_53","071_14_53","MRK","14","53","53","Na kakabe e kigatou ia Jesus ki te hakahua o na priest ma te haka putu mai ba'i pegea, na hakahua o na priest, ma na 'agiki o na Jew, ma na ako o na tagangonga. ");
INSERT INTO mnv_vpl VALUES ("MK14_54","071_14_54","MRK","14","54","54","Ko Peter noko manga mugi haka mama'o, o hano ki goto i te gotomaga'e i te mu'a o te hage o te hakahua o na priest, o noho haka pigi ki na pegea ge'o o manga mumugu i te ahi. ");
INSERT INTO mnv_vpl VALUES ("MK14_55","071_14_55","MRK","14","55","55","Na hakahua o na priest ma ba'i pegea i tegatou puugenga noko manga ligo e kigatou ni hai 'anga hai e Jesus o maase'i, ka kigatou hai 'ia ai a Jesus ke mate, ka noko he'e tau hai 'anga ke kite kinai. ");
INSERT INTO mnv_vpl VALUES ("MK14_56","071_14_56","MRK","14","56","56","Noko 'eha tegatou gogoi 'anga haka makau ia te Ia, ka agatou gegea 'anga noko he'e goto tasi. ");
INSERT INTO mnv_vpl VALUES ("MK14_57","071_14_57","MRK","14","57","57","Ka noko tutu'u ma'u kogaa o konei agatou gegea haka makau ia Jesus, ");
INSERT INTO mnv_vpl VALUES ("MK14_58","071_14_58","MRK","14","58","58","“Ko kimatou noko haka gongo kia te Ia kae konei ana gea, ‘E hai kau go tuki 'ia te Hage Tapu noko 'ati e pegea, ka nimaa i te toka togu 'ao, kae 'ati haka hoki tegaa, e he'e 'ati e pegea.’ ” ");
INSERT INTO mnv_vpl VALUES ("MK14_59","071_14_59","MRK","14","59","59","Ka agatou gegea 'anga noko he'e goto tasi ma'u. ");
INSERT INTO mnv_vpl VALUES ("MK14_60","071_14_60","MRK","14","60","60","Ma te tu'u ake te hakahua o na priest i 'ago ia te kigatou o haka anu atu kia Jesus, “ 'Ai ko Koe ka he'e haka tau? Te gongo aa te manga gegea haka makau ai e na pegea nei ia te Koe?” ");
INSERT INTO mnv_vpl VALUES ("MK14_61","071_14_61","MRK","14","61","61","Ka ko Jesus noko manga ngongoto, he'e haka tau kinai. Haka anu hoki te hakahua o na priest kia Jesus, “ 'Ai tenaa koe te 'Agiki Taga'ia, te Hosa o te Hakagaoinga e Tasi?” ");
INSERT INTO mnv_vpl VALUES ("MK14_62","071_14_62","MRK","14","62","62","Haka tau a Jesus o hai atu, “Ko Au. Ka koutou e hai ke go hiina'i ki te Hosa o Pegea manga noho i te pa'asi maui o te 'Aitu e Hu'ai To'a kae a'u i na po'ao o te gangi.” ");
INSERT INTO mnv_vpl VALUES ("MK14_63","071_14_63","MRK","14","63","63","Ma te lagilagi e te hakahua o na priest ona ake, kae hai atu, “ 'Eaa? 'Ai ko kitatou koi siahahai ma'u ni pegea ke 'atigongo haka makau? ");
INSERT INTO mnv_vpl VALUES ("MK14_64","071_14_64","MRK","14","64","64","Koutou kua haka gongo atu ki Ana igho 'anga, e kohea autou tegeu'a?” ");
INSERT INTO mnv_vpl VALUES ("MK14_65","071_14_65","MRK","14","65","65","Ma te haka tu'u he ngaa'esu 'aki na pegea ia te kigatou kia Jesus, kae nono'a titingi ma'u e kigaatou na mata, husu ia te Ia i ogaatou gima, kae hai atu, “Taauga mai!” Kae kakabe e na pegea ge'o ia te Ia o kogu. ");
INSERT INTO mnv_vpl VALUES ("MK14_66","071_14_66","MRK","14","66","66","Ka te gholoba noko manga iai a Peter i te gotomaga'e i te mu'a o te hage, a'u te guani i na guani haahine o te hakahua o na priest. ");
INSERT INTO mnv_vpl VALUES ("MK14_67","071_14_67","MRK","14","67","67","Tena ina 'anga kia Peter manga mumugu i te ahi, koia noko ina titingi kia Peter o hai atu, “Ko koe noko manga haka pata ma'u kia Jesus mai Nazareth!” ");
INSERT INTO mnv_vpl VALUES ("MK14_68","071_14_68","MRK","14","68","68","Ka noko haka si'ai e Peter kae hai atu, “E he'e na'a eau, ma te he'e gaataki eau po nia te manga gea kinai koe.” Kae tu'u o hinatu ki te aga o te hage. ");
INSERT INTO mnv_vpl VALUES ("MK14_69","071_14_69","MRK","14","69","69","Te gholoba noko ina 'atu ai te guani hahine kia te ia i te kungaa, gea hoki atu ki na pegea noko manga tutu'u, “Te tangata nei te pegea ia te kigatou.” ");
INSERT INTO mnv_vpl VALUES ("MK14_70","071_14_70","MRK","14","70","70","Haka si'ai haka hoki e Peter. Nimaa he'e taunga gogoa, na pegea noko tutu'u haka hitaiaki noko hai atu kia Peter, “E maa'ogi, ko koe te pegea ia te kigatou, iteme'agaa ko koe te pegea mai Galilee.” ");
INSERT INTO mnv_vpl VALUES ("MK14_71","071_14_71","MRK","14","71","71","Ka ko Peter na haka tu'u te baa logho ia te ia kae aguagu kia te kigatou, “E he'e mi'i na'a eau te tangata e hai kinai koutou nei.” ");
INSERT INTO mnv_vpl VALUES ("MK14_72","071_14_72","MRK","14","72","72","Ma te manga ghali o tangi haka hoki te paolo, ma te maanatu hoki a Peter ki te gea 'anga a Jesus noko hai kia te ia, “Ko koe kago haka si'ai haka togu e koe ia te Au, kae mugi o tangi haka gua te paolo.” Koia na hu'ai 'agoha ma te magepe. ");
INSERT INTO mnv_vpl VALUES ("MK15_1","071_15_1","MRK","15","1","1","Nimaa i te mahoata pipilu, na hakahua o na priest na haka tahi 'aki ma na 'agiki o na Jew, ma na ako o na tagangonga, ma ba'i pegea i tegatou tu'uganga puge, o hai agatou paaunga. Ma te gii e kigatou ia Jesus, kae kakabe o haiga'a ia te Ia kia Pilate. ");
INSERT INTO mnv_vpl VALUES ("MK15_2","071_15_2","MRK","15","2","2","Ka na haka anu a Pilate kia Jesus o hai atu, “ 'Ai ko Koe te Hakahua o na Jew?” Haka tau a Jesus o hai atu, “ 'Oo tenaa te manga gea mai ai koe.” ");
INSERT INTO mnv_vpl VALUES ("MK15_3","071_15_3","MRK","15","3","3","Ma te haka pipiki na hakahua o na priest kia Jesus i na hai 'anga 'eha to'a. ");
INSERT INTO mnv_vpl VALUES ("MK15_4","071_15_4","MRK","15","4","4","Ma te haka anu hoki atu a Pilate kia Jesus, “Ko Koe e pau a na pegea nei o 'atigongo haka makau ai i ba'i hai 'anga. 'Ai ko Koe ka he'e haka tau kinai?!” ");
INSERT INTO mnv_vpl VALUES ("MK15_5","071_15_5","MRK","15","5","5","Ka ko Jesus noko pau o he'e haka tau kinai, o hu'ai langalanga ai a Pilate. ");
INSERT INTO mnv_vpl VALUES ("MK15_6","071_15_6","MRK","15","6","6","Ka te paaunga o te haka tahinga o te Passover, te haka tausu'u e Pilate he launatasi i na pegea kagohia haka ene 'aki ai te 'apitanga ke haka tausu'u. ");
INSERT INTO mnv_vpl VALUES ("MK15_7","071_15_7","MRK","15","7","7","Ka te pegea e ingoa ia Barabbas noko manga i te kagohia ma na pegea noko taa e kigatou na pegea i tegatou haka hetata'i 'anga ki te gahumanu. ");
INSERT INTO mnv_vpl VALUES ("MK15_8","071_15_8","MRK","15","8","8","Boo ake te 'apitanga o he hakaene 'aki kia Pilate, ke hai nia e ta'anga hai eia kia te kigatou. ");
INSERT INTO mnv_vpl VALUES ("MK15_9","071_15_9","MRK","15","9","9","Ma te haka anu atu a Pilate, “E siahahai koutou kau haka tausu'u 'ia te hakahua o na Jew kia te koutou?” ");
INSERT INTO mnv_vpl VALUES ("MK15_10","071_15_10","MRK","15","10","10","Noko na'a e Pilate na hakahua o na priest noko manga 'i'ita o haiga'a e kigaatou ia Jesus kia te ia. ");
INSERT INTO mnv_vpl VALUES ("MK15_11","071_15_11","MRK","15","11","11","Ka na hakahua o na priest noko usuusu e kigaatou te 'apitanga ke hai a Pilate ke haka tausu'u eia ia Barabbas, ke haka suihaki ia Jesus. ");
INSERT INTO mnv_vpl VALUES ("MK15_12","071_15_12","MRK","15","12","12","Ma te haka anu hoki atu a Pilate kia te kigatou, “Ka niaa e hai kau hai 'ia ki te pegea e mate e koutou te hakahua o na Jew?” ");
INSERT INTO mnv_vpl VALUES ("MK15_13","071_15_13","MRK","15","13","13","Ngengege atu a kigatou, “Taa atu ia te Ia ki te kros!” ");
INSERT INTO mnv_vpl VALUES ("MK15_14","071_15_14","MRK","15","14","14","Ma te haka anu hoki atu a Pilate, “ 'Eaa, tehea te hai 'anga maase'i noko hai e Ia?” Kae manga haka soso ake 'agaatou ngengege 'anga, “Taa atu ia te Ia ki te kros!” ");
INSERT INTO mnv_vpl VALUES ("MK15_15","071_15_15","MRK","15","15","15","Ko Pilate noko manga siahai ke haka maagaohie eia te 'apitanga, ma te haka tausu'u eia ia Barabbas kia te kigatou, kae tuku ia Jesus ke kogu, kae haiga'a ma'u ia te Ia ke taa ki te kros. ");
INSERT INTO mnv_vpl VALUES ("MK15_16","071_15_16","MRK","15","16","16","Na taangata hai tau'a na kakabe e kigatou ia Jesus ki te hu'ai hage o te hakahua ia Pilate, o haka putu mai kinai kogaa pegea i na taangata hai tau'a. ");
INSERT INTO mnv_vpl VALUES ("MK15_17","071_15_17","MRK","15","17","17","Haa mago e kigatou ia Jesus i te ake uga sesenga, kae higi e kigatou te ha'u ‘crown’ i na kaubago hotohoto o haka eke i te 'ugu o Jesus. ");
INSERT INTO mnv_vpl VALUES ("MK15_18","071_15_18","MRK","15","18","18","Kae ngengege ia te Ia o hai atu, “Oho ia te Koe, te hakahua o na Jew.” ");
INSERT INTO mnv_vpl VALUES ("MK15_19","071_15_19","MRK","15","19","19","Kae pe'epe'e haka he hokihoki saki e kigatou te 'ugu o Jesus i te ga'akau, ma te he ngaa'esu 'aki kia te Ia. Kae he tokotugi 'aki o sogi kia Jesus. ");
INSERT INTO mnv_vpl VALUES ("MK15_20","071_15_20","MRK","15","20","20","Ka te gholoba noko maa babage ai kia te Ia, kae 'ui e kigatou te ake uga sesenga, kae haa mago hoki i na ake o 'Ona, 'io mugi a kigatou o kakabe ia Jesus ke taa ki te kros. ");
INSERT INTO mnv_vpl VALUES ("MK15_21","071_15_21","MRK","15","21","21","Noko iai te tangata mai Cyrene tena ingoa ko Simon, te tamana o Alexander ma Rufus, koia noko manga hinaiho mai te kakai 'anga i taha ki te hu'ai manaha, ka na manga haka matakutaku e kigatou o 'amo eia te kros. ");
INSERT INTO mnv_vpl VALUES ("MK15_22","071_15_22","MRK","15","22","22","Noko kakabe e kigatou ia Jesus ki te kunga noko mate ko Golgotha, (e gaataki “Te Kunga o te Puso 'ugu”). ");
INSERT INTO mnv_vpl VALUES ("MK15_23","071_15_23","MRK","15","23","23","Nimaa hetae ki Golgotha, kae haiga'a e kigatou te waeni haka higohigo i na ‘myrrh’, ka na he'e binu e Ia. ");
INSERT INTO mnv_vpl VALUES ("MK15_24","071_15_24","MRK","15","24","24","Ma te taa e kigatou ia Jesus ki te kros, kae tuhatuha e kigatou ona ake, 'io hai e kigatou te babage 'anga i na daes ke na'a ai po nia te ka taki ga'u e kigatou. ");
INSERT INTO mnv_vpl VALUES ("MK15_25","071_15_25","MRK","15","25","25","Ko Jesus noko taa ki te kros i te 9 kiloko i te taha'ata. ");
INSERT INTO mnv_vpl VALUES ("MK15_26","071_15_26","MRK","15","26","26","Te kanukanu 'anga o te haka makau 'ia 'anga a Jesus o taa 'ia noko konei na haka sahe: “Te Hakahua o na Jew.” ");
INSERT INTO mnv_vpl VALUES ("MK15_27","071_15_27","MRK","15","27","27","Noko taa haka pigi e kigatou te toka gua taangata kaia'a kia Jesus, tegaa i te pa'asi maui ma tegaa i te pa'asi sema. ");
INSERT INTO mnv_vpl VALUES ("MK15_28","071_15_28","MRK","15","28","28","Te hai 'anga nei noko haka maa'ogi ai na Kanukanu Tapu noko hai ake: “Ko Ia noko haka sahe haka pigi 'ia ki na pegea 'oosongo.” ");
INSERT INTO mnv_vpl VALUES ("MK15_29","071_15_29","MRK","15","29","29","Na pegea noko manga he sigisigi haki noko manga gegea maase'i kia Jesus, ma te he nounou 'aki ogatou 'ugu, kae hai ake, “Tenaa Koe noko hai ke tuki te Hage Tapu ka ke go 'ati hoki i te togunga 'ao. ");
INSERT INTO mnv_vpl VALUES ("MK15_30","071_15_30","MRK","15","30","30","Haka ma'ugi iho ia te Koe, o iho mai i te kros na!” ");
INSERT INTO mnv_vpl VALUES ("MK15_31","071_15_31","MRK","15","31","31","Na hakahua o na priest ma na ako o na tagangonga noko maa babage ma'u kia Jesus, o hai ake, “Noko manga haka ma'ugi e Ia kogaa pegea, kae he'e 'aonga te haka ma'ugi ia te Ia! ");
INSERT INTO mnv_vpl VALUES ("MK15_32","071_15_32","MRK","15","32","32","Te 'Agiki Taga'ia nei, te Hakahua o Israel, ke iho mai i te kros, ka kitatou hiina'i kinai ka kitatou too kia te Ia!” Ka ko gua pegea noko taa 'ia haka pigi kia Jesus, noko babage ma'u kia te Ia. ");
INSERT INTO mnv_vpl VALUES ("MK15_33","071_15_33","MRK","15","33","33","Nimaa i te 'ao 'atea, te 'atuhenua ngatahi na poo'ugi o hano ano 3 kiloko ga'aa page. ");
INSERT INTO mnv_vpl VALUES ("MK15_34","071_15_34","MRK","15","34","34","Nimaa i te ga'aa page, ko Jesus noko hai tena hu'ai ngege 'anga o hai ake, “Eloi, Eloi, lama sabachthani?” E haka gaataki, “Toku 'Aitu, Toku 'Aitu, 'eaa e ti'aki ai e Koe ia te Au?” ");
INSERT INTO mnv_vpl VALUES ("MK15_35","071_15_35","MRK","15","35","35","Te gholoba noko haka gongo ai kinai na pegea noko manga tutu'u hitaiaki, kogaa ia te kigatou noko hai atu, “ 'Ai haka gongo atu, ko Ia manga ngege ia Elijah.” ");
INSERT INTO mnv_vpl VALUES ("MK15_36","071_15_36","MRK","15","36","36","Ma te tege te launatasi tangata o hai te bai kona ki te me'a maguu, o tuku ki te ga'akau o haka to'o ake kia Jesus ke binu ai, kae hai atu, “Saunonoa atu kinai, ka ke mataa hiina'i kinai po ka a'u a Elijah o sa'u iho ia te Ia i te kros!” ");
INSERT INTO mnv_vpl VALUES ("MK15_37","071_15_37","MRK","15","37","37","Ko Jesus na hai tena hu'ai ngege 'anga kae manaba tena manaba taha'aki. ");
INSERT INTO mnv_vpl VALUES ("MK15_38","071_15_38","MRK","15","38","38","Ka te laoa maatogu noko i te uso o te Hage Tapu na manga muna o maha'a gua, haka tu'u iho i 'agunga o hinaiho ano hetae ki gago. ");
INSERT INTO mnv_vpl VALUES ("MK15_39","071_15_39","MRK","15","39","39","Ka te tugi tau'a noko manga tu'u 'ago ia Jesus, na haka gongo ki tena ngege 'anga, kae ina ma'u ki te kogaa ana mate 'anga, o hai ake, “E maa'ogi to'a, te tangata nei te Hosa o te 'Aitu.” ");
INSERT INTO mnv_vpl VALUES ("MK15_40","071_15_40","MRK","15","40","40","Ka noko manga tutu'u haka makabaa na haahine o manga mata mai kinai, noko iai a Mary mai Magdala, ma Salome, ma Mary te tinana o te tamatama ia James ma te taina ia Joses. ");
INSERT INTO mnv_vpl VALUES ("MK15_41","071_15_41","MRK","15","41","41","Na haahine nei noko tata'o mai ia Jesus mai Galilee o manga baa siko ia te Ia. Noko 'eha kogaa haahine noko tata'o mai ia Jesus ki Jerusalem noko manga i te kungaa ma'u. ");
INSERT INTO mnv_vpl VALUES ("MK15_42","071_15_42","MRK","15","42","42","Te 'ao na, te 'Ao Ngaague (te 'ao 'io mugi te 'Ao Okioki), ka noko hai hano ke ahiahi. ");
INSERT INTO mnv_vpl VALUES ("MK15_43","071_15_43","MRK","15","43","43","Ko Joseph mai Arimathea, na toka manaba o hano o haka ene kia Pilate i te tino o Jesus. Ko Joseph te pegea pagongia i te tu'uganga puge a na Jew, koia noko manga hitagi ma'u i te Hakahua 'anga a te 'Aitu. ");
INSERT INTO mnv_vpl VALUES ("MK15_44","071_15_44","MRK","15","44","44","Ka ko Pilate na gegema'ugi i te gongo 'anga ko Jesus kua pau o mate, ma te pogo 'aki i te tugi tau'a o haka anu kia te ia po ko Jesus kua pau o mate. ");
INSERT INTO mnv_vpl VALUES ("MK15_45","071_15_45","MRK","15","45","45","Te na'a 'anga e Pilate i te tugi tau'a ko Jesus kua pau o mate, ma te tuku eia te tino o Jesus kia Joseph. ");
INSERT INTO mnv_vpl VALUES ("MK15_46","071_15_46","MRK","15","46","46","Ma te tau'i e Joseph na laoa susugu, kae sa'u iho eia te tino o Jesus, o pegu i na laoa susugu, o tuku eia te tino ki te takotonga noko kegi i te ogo hatu, kae hugihugi eia te hu'ai hatu o titingi ai te mata o te takotonga. ");
INSERT INTO mnv_vpl VALUES ("MK15_47","071_15_47","MRK","15","47","47","Ko Mary mai Magdala, ma Mary te tinana o Joses noko hiina'i ki te kunga noko haka takoto kinai ia te Ia. ");
INSERT INTO mnv_vpl VALUES ("MK16_1","071_16_1","MRK","16","1","1","Nimaa te ahiahi na 'oti ai te 'Ao oki oki, ko Mary mai Magdala, ma Salome, ma Mary te tinana o James, noko tau'i e kigatou na me'a tutuu gaoi, kigatou boo 'ia o gigingi ki te tino o Jesus. ");
INSERT INTO mnv_vpl VALUES ("MK16_2","071_16_2","MRK","16","2","2","Nimaa i te mahoata pipilu o te 'ao mu'a i te gholoba noko sopo ai te ga'aa, kae boo kigatou ki te takotonga, ");
INSERT INTO mnv_vpl VALUES ("MK16_3","071_16_3","MRK","16","3","3","o haka anuanu 'aki kia te kigatou soko, “Koai e hai ke go hugi te hu'ai hatu i te mata o te takotonga?” ");
INSERT INTO mnv_vpl VALUES ("MK16_4","071_16_4","MRK","16","4","4","Ka te gholoba na hiina'i haka tutu'u atu ai kigatou, te hu'ai hatu kua hugi 'ia. ");
INSERT INTO mnv_vpl VALUES ("MK16_5","071_16_5","MRK","16","5","5","Nimaa he uguhi kigatou ki goto i te takotonga, ma te hiina'i ki te tangata tamatama mago i na laoa susugu manga noho i te pa'asi maui, ma te manga he matataku 'aki. ");
INSERT INTO mnv_vpl VALUES ("MK16_6","071_16_6","MRK","16","6","6","Ma te hai atu te tangata, “Noka tautou he matataku 'aki. Koutou manga sasaga ia Jesus mai Nazareth na taa 'ia ki te kros. Ko Ia kua ma'ugi hoki! Ko Ia e he'e kitea i te kunga nei. Hiina'i mai ki te kunga noko tanu ai ia te Ia. ");
INSERT INTO mnv_vpl VALUES ("MK16_7","071_16_7","MRK","16","7","7","Kae boo atu o he 'atigongo 'aki ki ona pegea haka ako ma Peter, ‘Ko Ia kua mu'a ia te koutou ki Galilee. Tenaa te kunga kago hiina'i ai koutou kia te Ia, ke noho ki nia noko gea ai kia te koutou.’ ” ");
INSERT INTO mnv_vpl VALUES ("MK16_8","071_16_8","MRK","16","8","8","Na haahine na he popoge 'aki ma te he sopomananaba 'aki, o manga sosopo iho i te takotonga o he 'agiko, ko kigatou noko he'e gegea ki he pegea, iteme'agaa ko kigatou noko hu'ai matataku. ");
INSERT INTO mnv_vpl VALUES ("MK16_9","071_16_9","MRK","16","9","9","Te 'aso noko ma'ugi hoki ai a Jesus i te mahoata pipilu o te 'ao mu'a, ko Ia na mataa haka 'agitino kia Mary mai Magdala, te hahine na pagepage ai e Jesus te toka hitu haagiki songo. ");
INSERT INTO mnv_vpl VALUES ("MK16_10","071_16_10","MRK","16","10","10","Ko ia na hoki o 'atigongo ki tegatou tu'uganga noko manga tatangi ma te magegepe. ");
INSERT INTO mnv_vpl VALUES ("MK16_11","071_16_11","MRK","16","11","11","Te gholoba na haka gongo ai kigatou ko Jesus kua ma'ugi hoki, ka kua ina ma'u kinai ia, ko kigatou noko he'e too kinai. ");
INSERT INTO mnv_vpl VALUES ("MK16_12","071_16_12","MRK","16","12","12","Kae mugi a Jesus o haka 'agi tino ki te toka gua ia te kigatou. Ka noko hai o'Ona noho i te haka 'agi tino 'anga kia te kigaaua i te 'aso noko ma giu ai ki na kunga henua o'ogaaua. ");
INSERT INTO mnv_vpl VALUES ("MK16_13","071_16_13","MRK","16","13","13","Ko kigaaua nei na giu o 'atigongo 'aki ai kia te kigatou ngatahi, ka ko kigatou noko he'e too kinai ma'u. ");
INSERT INTO mnv_vpl VALUES ("MK16_14","071_16_14","MRK","16","14","14","Mugi a Jesus o haka 'agi tino ki te katoa tuma'a e tasi pegea haka ako i te gholoba noko manga kai ai kigatou, o too aki kia te kigatou i tegatou he'e too kia te Ia ma 'agatou mogi 'anga o he'e siahahai ke too ki na pegea kua hiina'i kia te Ia i tena ma'ugi hoki 'anga. ");
INSERT INTO mnv_vpl VALUES ("MK16_15","071_16_15","MRK","16","15","15","Hai atu a Jesus kia te kigatou, “Boo atu ki ba'i kunga i te kege nei o tohi'aki i te Gongo Gaoi ki ba'i pegea. ");
INSERT INTO mnv_vpl VALUES ("MK16_16","071_16_16","MRK","16","16","16","Ko ai kago too ki te Gongo Gaoi o gogomi e hai ke go ma'ugi, ka ko ai e he'e too, e hai ke go kagohia. ");
INSERT INTO mnv_vpl VALUES ("MK16_17","071_16_17","MRK","16","17","17","Na pegea kago too kinai, e hai ke go haiga'a kinai na haka 'igonga nei: Ko kigatou e hai ke go pagepage haagiki songo i toku ingoa. Ko kigatou e hai ke go gegea i ni hegeunga ho'ou. ");
INSERT INTO mnv_vpl VALUES ("MK16_18","071_16_18","MRK","16","18","18","Ko kigatou kago he 'osohi ki ni ngata taa pegea, po e bibinu e kigatou ni bai e 'aonga te mamate ai, ka kago he'e hai songo ia te kigatou. Ko kigatou e hai ke go haka eke ogatou gima i ni pegea masasaki ogo maa'ugi.” ");
INSERT INTO mnv_vpl VALUES ("MK16_19","071_16_19","MRK","16","19","19","Nimaa 'oti i te gea a te Hakahua ia Jesus kia te kigatou, kae to'ogia ia te Ia ki te nuku i te gangi, o noho i te pa'asi maui o te 'Aitu. ");
INSERT INTO mnv_vpl VALUES ("MK16_20","071_16_20","MRK","16","20","20","Kae boo na pegea haka ako o tohi'aki i ba'i kunga, kae hai hekau haka pigi a te Hakahua kia te kigatou, o haka maa'ogi tena haka hegeunga i na haka 'igonga noko hai ma'u.");
INSERT INTO mnv_vpl VALUES ("LK1_1","072_1_1","LUK","1","1","1","Kia Theophilus. Kua 'api pegea hai agatou hekau gaoi te kanukanu e kigatou na gongo o na hai 'anga kua 'oti i te haka maa'ogi mai kia te kimatou. ");
INSERT INTO mnv_vpl VALUES ("LK1_2","072_1_2","LUK","1","2","2","O manga papata ki na hai 'anga noko 'atigongo ai kia te kimatou na pegea noko mataa hiina'i kinai ma te hai hekau kinai. ");
INSERT INTO mnv_vpl VALUES ("LK1_3","072_1_3","LUK","1","3","3","I te ghaghinga i te ligo gosigosi eau ona haka tu'u mai 'anga, kae noho ake e gaoi kau haka mamanu 'ia o kanukanu atu ai kau hogahoga 'ia kia te koe, 'agiki. ");
INSERT INTO mnv_vpl VALUES ("LK1_4","072_1_4","LUK","1","4","4","E hai eau na hai 'anga nei ke na'a gaoi e koe na me'a na 'oti i te ako kia te koe. ");
INSERT INTO mnv_vpl VALUES ("LK1_5","072_1_5","LUK","1","5","5","I na 'aso o Herod te hakahua o Judea, noko iai te priest tena ingoa ko Zechariah, te priest o te hanohano o Abijah, ka ko tena uguugu ia Elizabeth te makupuna o Aaron. ");
INSERT INTO mnv_vpl VALUES ("LK1_6","072_1_6","LUK","1","6","6","Ko kigaaua ngatahi noko tinogaoi ki na mata o te 'Aitu, kae pipiki gaoi e kigaaua ba'i haka hegeunga ma na tagangonga a te 'Aitu. ");
INSERT INTO mnv_vpl VALUES ("LK1_7","072_1_7","LUK","1","7","7","Ka ko kigaaua noko he'e tau tama giki iteme'agaa ko Elizabeth te meetogho, ka ko kigaaua na he tauiku 'aki ma'u. ");
INSERT INTO mnv_vpl VALUES ("LK1_8","072_1_8","LUK","1","8","8","Nimaa i tegaa 'aso, ko Zechariah noko sui o hai hekau ai i te hekau ana priest i 'ago ia te 'Aitu. ");
INSERT INTO mnv_vpl VALUES ("LK1_9","072_1_9","LUK","1","9","9","I te ghaghi i te hesuinga o na priest, koia na tuku 'ia ke hano ki goto i te Hage Tapu o te 'Aitu, ke tutu ai ni me'a tutuu gaoi ke taakunga ai kia te 'Aitu. ");
INSERT INTO mnv_vpl VALUES ("LK1_10","072_1_10","LUK","1","10","10","Nimaa hetae ki te gholoba o te tutu 'anga na me'a tutuu gaoi, ko ba'i pegea sogi noko manga noho 'aki i tu'a o noko manga taakunga. ");
INSERT INTO mnv_vpl VALUES ("LK1_11","072_1_11","LUK","1","11","11","Ma te haka'agi tino te ensel o te 'Aitu kia te ia, noko manga tu'u i te pa'asi maui o te olta tutu o na me'a tutuu gaoi. ");
INSERT INTO mnv_vpl VALUES ("LK1_12","072_1_12","LUK","1","12","12","Te gholoba noko ina ai a Zechariah ki te ensel, koia noko gegema'ugi o hu'ai mataku ai. ");
INSERT INTO mnv_vpl VALUES ("LK1_13","072_1_13","LUK","1","13","13","Ka noko hai atu te ensel kia te ia, “Noka tau mataku, Zechariah, na'e tau taakunga 'anga kua haka gongo kinai a te 'Aitu: Ko tou uguugu ia Elizabeth e hai ke go hakahaa eia mo'ou he hosa, kae ogo haka ingoa atu e koe ko John. ");
INSERT INTO mnv_vpl VALUES ("LK1_14","072_1_14","LUK","1","14","14","Koia kago magaohie ai koe, ma tau siasia ai. Ko ba'i pegea kago sisia ma'u i tena sopo 'anga. ");
INSERT INTO mnv_vpl VALUES ("LK1_15","072_1_15","LUK","1","15","15","Koia kago hua'eha i 'ago ia te 'Aitu. Koia kago he'e 'aonga te binu i ni waeni, po ni bai to'a, ka koia e hai ke go honu i te Spirit Tapu, ma kaa sopo. ");
INSERT INTO mnv_vpl VALUES ("LK1_16","072_1_16","LUK","1","16","16","Kago 'api pegea i Israel kago to'o haka hoki mai eia ki te 'Agiki te 'Aitu ogatou. ");
INSERT INTO mnv_vpl VALUES ("LK1_17","072_1_17","LUK","1","17","17","Koia e hai ke go mu'a mai i te Hakahua, ma te 'igo'igo ma na taganga noko hai e Elijah, ke haka haagiu ai na uso o na tamana ki agatou tama giki, ma te ke haka haagiu na pegea he'e mangangao ke he 'igo'igo 'aki pe na pegea gaoi, ma te ke haka ngaague ai te 'apitanga kia te 'Aitu.” ");
INSERT INTO mnv_vpl VALUES ("LK1_18","072_1_18","LUK","1","18","18","Ko Zechariah noko haka anu ki te ensel o hai atu kinai, “E hai ke kohea na na'a eau te hai 'anga nei, ia te au kua tauiku, kae tauiku ma'u toku uguugu?” ");
INSERT INTO mnv_vpl VALUES ("LK1_19","072_1_19","LUK","1","19","19","Ma te haka tau te ensel o hai atu kinai, “Koau ko Gabriel. Koau manga tu'u 'ago ia te 'Aitu, kae hakato'o mai ia te au o a'u, kau gea kia te koe ma te kau 'atigongo kia te koe i te gongo gaoi nei. ");
INSERT INTO mnv_vpl VALUES ("LK1_20","072_1_20","LUK","1","20","20","Ka te gholoba nei, ko koe ka he'e 'aonga tau gea o hano aano hetae ki te 'aso e hai ke go maa'ogi mai ai te hai 'anga nei, iteme'agaa ko koe kua he'e too ki aku gea 'anga, kae hai ke go haka maa'ogi ma kaa hetae ki tena 'aso.” ");
INSERT INTO mnv_vpl VALUES ("LK1_21","072_1_21","LUK","1","21","21","Te 'apitanga noko hitagi goa ia Zechariah ma tegatou he langalanga 'aki po 'eaa e noho goa ai ia i goto i te Hage Tapu. ");
INSERT INTO mnv_vpl VALUES ("LK1_22","072_1_22","LUK","1","22","22","Te gholoba noko sopo hoki iho ai, koia noko he'e 'aonga tena gea kia te kigatou, ma te na'a e kigatou koia kua hai tena maatanga i te Hage Tapu. Koia noko manga haka hegeu 'aaunga kia te kigatou, ia te ia na pau o he'e 'aonga tena gea. ");
INSERT INTO mnv_vpl VALUES ("LK1_23","072_1_23","LUK","1","23","23","Nimaa 'oti i te hai ana hekau, kae hoki ki tena hage. ");
INSERT INTO mnv_vpl VALUES ("LK1_24","072_1_24","LUK","1","24","24","Nimaa 'oti kogaa gholoba, ko tena uguugu ia Elizabeth na hai tama, ka tena gimanga maahina koia noko manga ina haka ma'u ai he'e sehu. ");
INSERT INTO mnv_vpl VALUES ("LK1_25","072_1_25","LUK","1","25","25","Ko Elizabeth noko hai tena gea 'anga o hai ake, “Te 'Aitu kua hai e Ia te hai 'anga nei kia te au. Na 'ao nei kua haka 'agi ai tena 'agoha, ma te haka noka ai e Ia taku nohonoho maase'i i 'ago i te 'apitanga.” ");
INSERT INTO mnv_vpl VALUES ("LK1_26","072_1_26","LUK","1","26","26","Nimaa ononga maahina te hai tama a Elizabeth, ko te 'Aitu noko tuku e Ia te ensel ia Gabriel o hano ki Nazareth, te manaha i Galilee, ");
INSERT INTO mnv_vpl VALUES ("LK1_27","072_1_27","LUK","1","27","27","ki te launatasi hahine taupo'ou he'e hai taangata, kae he ahoaho 'aki ma te tangata e mate tena ingoa ko Joseph te pegea i te hanohano o David. Te hahine he'e hai taangata tena ingoa ko Mary. ");
INSERT INTO mnv_vpl VALUES ("LK1_28","072_1_28","LUK","1","28","28","Te ensel noko hano kia Mary o hai atu kinai, “Te goto maagie kia te koe. Ko koe kua hu'ai tau babae 'ia. Te 'Aitu manga haka pata kia te koe.” ");
INSERT INTO mnv_vpl VALUES ("LK1_29","072_1_29","LUK","1","29","29","Ko Mary noko hu'ai maikia i te gea 'anga a te ensel, ma tena langalanga poe kohea gaa na gaataki te haka 'atu'atu 'anga nei. ");
INSERT INTO mnv_vpl VALUES ("LK1_30","072_1_30","LUK","1","30","30","Ka te ensel noko hai atu kia te ia, “Noka tau mataku, Mary, na'e ko koe kua tau babae e te 'Aitu. ");
INSERT INTO mnv_vpl VALUES ("LK1_31","072_1_31","LUK","1","31","31","Ko koe e hai ke go hai tama ogo haka haa ma'au he tama, ogo haka ingoa ko Jesus. ");
INSERT INTO mnv_vpl VALUES ("LK1_32","072_1_32","LUK","1","32","32","Ko Ia e hai ke go hua'eha ma te go mate te hosa o te 'Aitu Hu'ai Ma'u'agunga. Te 'Agiki ia te 'Aitu e hai ke go tuku kia te Ia te hakahua 'anga a te tupuna ia David. ");
INSERT INTO mnv_vpl VALUES ("LK1_33","072_1_33","LUK","1","33","33","Ko Ia e hai ke go Hakahua ki te hanohano o Jacob ke noho goa, ma tena hakahua 'anga kago he'e 'aonga te 'oti.” ");
INSERT INTO mnv_vpl VALUES ("LK1_34","072_1_34","LUK","1","34","34","Ko Mary noko hai atu ki te ensel, “E hai ke kohea na maa'ogi mai te hai 'anga nei, iteme'agaa ko au te hahine he'e na'a eau he tangata?” ");
INSERT INTO mnv_vpl VALUES ("LK1_35","072_1_35","LUK","1","35","35","Ka noko haka tau te ensel kia te ia o hai atu kinai, “Te Spirit Tapu e hai ke go a'u kia te koe, ma na taganga o te 'Aitu Hu'ai Ma'u'agunga e hai ke go ekenga ia te koe, ka te tama 'iti'iti tapu e hai ke go sopo ia te koe e hai ke go mate te Hosa o te 'Aitu. ");
INSERT INTO mnv_vpl VALUES ("LK1_36","072_1_36","LUK","1","36","36","Ko Elizabeth ma'u tou 'atima'ogi ka hai ma'ana he tama'iti'iti i tena tauiku 'anga nei, ka koia manga na'a 'ia te meetogho, ka kua ononga maahina te hai tama. ");
INSERT INTO mnv_vpl VALUES ("LK1_37","072_1_37","LUK","1","37","37","E si'ai he me'a ke haingata'a kia te 'Aitu.” ");
INSERT INTO mnv_vpl VALUES ("LK1_38","072_1_38","LUK","1","38","38","Ma te haka tau a Mary o hai atu, “Koau te guani o te 'Aitu. Manga 'aonga te hai kia te au te hai 'anga e gea kinai koe.” Ma te mugi te ensel o hano 'aatea ia te ia. ");
INSERT INTO mnv_vpl VALUES ("LK1_39","072_1_39","LUK","1","39","39","Te gholoba na, ko Mary noko ngaague o ghali o hano ki te manaha i na kunga henua i na ogo o Judea. ");
INSERT INTO mnv_vpl VALUES ("LK1_40","072_1_40","LUK","1","40","40","Nimaa hano a Mary o ugu ki te hage o Zechariah o oho atu e ia ia Elizabeth. ");
INSERT INTO mnv_vpl VALUES ("LK1_41","072_1_41","LUK","1","41","41","Te gholoba noko haka gongo ai a Elizabeth ki te oho 'anga a Mary, ma te ngaguegue te tama 'iti'iti i te tina'e, ka ko Elizabeth na honu i te Spirit Tapu. ");
INSERT INTO mnv_vpl VALUES ("LK1_42","072_1_42","LUK","1","42","42","O hai ai tena hu'ai gea 'anga o hai atu, “Te hakagaoi kia te koe o sigi i ba'i haahine, ma te hakagaoi ma'u ki te tama 'iti'iti kago sopo ia te koe! ");
INSERT INTO mnv_vpl VALUES ("LK1_43","072_1_43","LUK","1","43","43","Ka eaa e hai ai te hu'ai hai 'anga gaoi kia te au nei, te a'u te tinana o toku Hakahua o ina kia te au? ");
INSERT INTO mnv_vpl VALUES ("LK1_44","072_1_44","LUK","1","44","44","Te gholoba kua haka gongo atu ai au ki tau oho 'anga, te tama 'iti'iti i toku tina'e kua ngaguegue i te magaohie. ");
INSERT INTO mnv_vpl VALUES ("LK1_45","072_1_45","LUK","1","45","45","Te hakagaoi kia te koe kua too ki nia noko gea ai a te 'Aitu kia te koe kago haka maa'ogi mai.” ");
INSERT INTO mnv_vpl VALUES ("LK1_46","072_1_46","LUK","1","46","46","Ma te konei na to'o a Mary: “Toku hinangago e haka e'eha ia te 'Aitu. ");
INSERT INTO mnv_vpl VALUES ("LK1_47","072_1_47","LUK","1","47","47","Ma toku uso e maagaohie kia te 'Aitu, toku Ma'ugi sanga. ");
INSERT INTO mnv_vpl VALUES ("LK1_48","072_1_48","LUK","1","48","48","Iteme'agaa kua maanatu mai i te noho haka'agoha o tena guani nei. Haka tu'u i te 'aso nei o hano ki ba'i 'atu tangata e hai ke go noko hegeu kia te au, ko au te pegea hakagaoi 'ia. ");
INSERT INTO mnv_vpl VALUES ("LK1_49","072_1_49","LUK","1","49","49","Iteme'agaa ko te 'Aitu Hu'ai Taganga kua hai e Ia na hu'ai hai 'anga kia te au. Tena ingoa e tapu. ");
INSERT INTO mnv_vpl VALUES ("LK1_50","072_1_50","LUK","1","50","50","Tena 'agoha manga haka soo atu ki na pegea e pago kia te Ia i te 'atu tangata nei ki kogaa 'atu tangata. ");
INSERT INTO mnv_vpl VALUES ("LK1_51","072_1_51","LUK","1","51","51","Ko Ia noko hai e Ia na hu'ai hekau i na gima; ko Ia noko hai e Ia o maseuseu na pegea siga i agatou tegeu'a haka mamanu maase'i. ");
INSERT INTO mnv_vpl VALUES ("LK1_52","072_1_52","LUK","1","52","52","Ko Ia noko tuku gago e Ia na hu'ai hakahua i ogatou hakahua 'anga, kae haka ma'u 'agunga e Ia na pegea haka ma'u gago. ");
INSERT INTO mnv_vpl VALUES ("LK1_53","072_1_53","LUK","1","53","53","Ko Ia noko haangai e Ia na pegea he ongea 'aki i na me'a gaoi, kae hai e Ia na pegea ga'u o boo huhu gima. ");
INSERT INTO mnv_vpl VALUES ("LK1_54","072_1_54","LUK","1","54","54","Ko Ia noko 'aabaki ki tena guani Israel, ma te maanatu ke noko 'agoha ");
INSERT INTO mnv_vpl VALUES ("LK1_55","072_1_55","LUK","1","55","55","ia Abraham ma tena hanohano ki ba'i 'aso ke 'oti, ke noho ki ana tukungaa kupu ki otatou tupuna.” ");
INSERT INTO mnv_vpl VALUES ("LK1_56","072_1_56","LUK","1","56","56","Ko Mary noko haka pata kia Elizabeth o togunga maahina 'io mugi o hoki ki tena manaha. ");
INSERT INTO mnv_vpl VALUES ("LK1_57","072_1_57","LUK","1","57","57","Nimaa hetae ki te 'aso o Elizabeth noko hai ke hai ai ma'ana he tama 'iti'iti, koia noko guea o hai tena tama. ");
INSERT INTO mnv_vpl VALUES ("LK1_58","072_1_58","LUK","1","58","58","Na hemasi'inga a Elizabeth e pata mai, ma na pegea o tena hohoga 'anga na haka gongo ko te 'Aitu kua haka 'agi tena hu'ai 'agoha kia te ia. O sisia hakapigi ma'u kia te ia. ");
INSERT INTO mnv_vpl VALUES ("LK1_59","072_1_59","LUK","1","59","59","Nimaa i te bagunga 'ao, ko kigatou noko boomai ke kuga te tama 'iti'iti, ma te kigatou haka ingoa 'ia ki te ingoa o te tamana ia Zechariah. ");
INSERT INTO mnv_vpl VALUES ("LK1_60","072_1_60","LUK","1","60","60","Ka ko te tinana noko gea o hai atu, “Si'ai! Koia e hai ke haka ingoa ko John.” ");
INSERT INTO mnv_vpl VALUES ("LK1_61","072_1_61","LUK","1","61","61","Ka noko hai atu kigatou kia te ia, “E si'ai he launatasi i ou 'atima'ogi hai eia te ingoa na.” ");
INSERT INTO mnv_vpl VALUES ("LK1_62","072_1_62","LUK","1","62","62","Ma te haka anuanu he 'aaunga 'aki kia te tamana, ke na'a po tehea te ingoa e siahai ia ke tuku ki te tama 'iti'iti. ");
INSERT INTO mnv_vpl VALUES ("LK1_63","072_1_63","LUK","1","63","63","Ma te haka ene a Zechariah o to'o mai kinai te pa'asi ga'akau o tosi kinai te, “Tena ingoa ko John.” Ko ba'i pegea na he gege ma'ugi 'aki ai. ");
INSERT INTO mnv_vpl VALUES ("LK1_64","072_1_64","LUK","1","64","64","Te mi'i gholoba na, ko Zechariah na luga te ngutu kae tausu'u te 'agego, o haka tu'u te gea, haka e'eha ia te 'Aitu. ");
INSERT INTO mnv_vpl VALUES ("LK1_65","072_1_65","LUK","1","65","65","Ko ba'i hemasi'inga e pata mai na hu'ai matataku ai, ka te gongo o na hai 'anga nei kua mahoga i ba'i kunga henua i na ogo o Judea. ");
INSERT INTO mnv_vpl VALUES ("LK1_66","072_1_66","LUK","1","66","66","Ko ba'i pegea noko haka gongo i te gongo nei noko he tu'ia 'aki ai ma te kogaa agatou hegeu, “Te tama 'iti'iti nei kago kohea gaa o na noho?” Iteme'agaa na taganga o te 'Aitu kua tuku kia te ia. ");
INSERT INTO mnv_vpl VALUES ("LK1_67","072_1_67","LUK","1","67","67","Ko Zechariah te tamana o John noko honu i te Spirit Tapu o kogaa ana taauga: ");
INSERT INTO mnv_vpl VALUES ("LK1_68","072_1_68","LUK","1","68","68","“Kitatou haka e'eha ia te Hakahua, te 'Aitu o Israel! Iteme'agaa ko Ia e a'u ke tau'i haka hoki ona pegea. ");
INSERT INTO mnv_vpl VALUES ("LK1_69","072_1_69","LUK","1","69","69","Ko te 'Aitu e haiga'a mai e Ia tetatou Ma'ugi sanga Hu'ai Taganga i te hanohano o tena guani ia David. ");
INSERT INTO mnv_vpl VALUES ("LK1_70","072_1_70","LUK","1","70","70","(Ko te 'Aitu noko konei ana gea i ona taauga 'esi'esi i na 'aso na sigi), ");
INSERT INTO mnv_vpl VALUES ("LK1_71","072_1_71","LUK","1","71","71","Te Ma'ugi sanga kia te kitatou i otatou makau, ma ba'i pegea gotoa'a kia te kitatou, ");
INSERT INTO mnv_vpl VALUES ("LK1_72","072_1_72","LUK","1","72","72","ke haka 'agi tena kumu ki otatou tupuna ma tena maanatu hoki ki ana tukungaa kupu 'esi'esi. ");
INSERT INTO mnv_vpl VALUES ("LK1_73","072_1_73","LUK","1","73","73","Tena tukungaa kupu maa'ogi noko hakamaa'ogi e Ia ki tetatou tupuna ia Abraham: ");
INSERT INTO mnv_vpl VALUES ("LK1_74","072_1_74","LUK","1","74","74","ke hakasao ia te kitatou i na gima o na makau otatou, ka ke hai ia te kitatou he toka mananaba 'aki, kitatou hai hekau kia te Ia ");
INSERT INTO mnv_vpl VALUES ("LK1_75","072_1_75","LUK","1","75","75","i te tapuaki ma te tinogaoi kia te Ia i ba'i 'aso o taatou. ");
INSERT INTO mnv_vpl VALUES ("LK1_76","072_1_76","LUK","1","76","76","Ka ko koe taku tama 'iti'iti, e hai ke go mate ia te koe te taauga o te 'Aitu e Hu'ai Ma'u 'agunga; ia te koe e hai kego mataa hai hekau kia te 'Agiki i te haka ngaague te aga kia te Ia, ");
INSERT INTO mnv_vpl VALUES ("LK1_77","072_1_77","LUK","1","77","77","ke hogahoga ki ona pegea te gongo o te ma'ugi i te haka noka ogatou 'oosongo. ");
INSERT INTO mnv_vpl VALUES ("LK1_78","072_1_78","LUK","1","78","78","Iteme'agaa te 'agoha o tetatou 'Aitu kua haiga'a mai o noho pe te ga'aa e ta'aki o a'u kia te kitatou mai te gangi, ");
INSERT INTO mnv_vpl VALUES ("LK1_79","072_1_79","LUK","1","79","79","ke maagama ki na pegea manga noho 'aki i te poo'uginga, ma na pegea manga noho 'aki i te 'ata o te mate, ma te ke hutiaki ia te kitatou i te aga o te goto maagie.” ");
INSERT INTO mnv_vpl VALUES ("LK1_80","072_1_80","LUK","1","80","80","Te tama 'iti'iti nei noko ngasogo ake o tau hinangago i te Spirit; ka koia noko manga kakai i te tugatea aano hetae ki tena 'aso noko sopo o haka 'agi ai ia te ia ki te 'apitanga o Israel. ");
INSERT INTO mnv_vpl VALUES ("LK2_1","072_2_1","LUK","2","1","1","I na 'aso o Caesar Augustus, noko hai ai tena tukunga, ko ba'i pegea o na kakai 'anga o Rome e hai ke haka sahe taki tasi ia te kigatou. ");
INSERT INTO mnv_vpl VALUES ("LK2_2","072_2_2","LUK","2","2","2","(Te haka sahe 'anga a pegea noko hai nei, noko mataa hai i na 'aso o Quirinius noko hakahua ai i Syria.) ");
INSERT INTO mnv_vpl VALUES ("LK2_3","072_2_3","LUK","2","3","3","Ko ba'i pegea na taki giu ki ogatou manaha ke taki tosi ai ogatou ingoa. ");
INSERT INTO mnv_vpl VALUES ("LK2_4","072_2_4","LUK","2","4","4","Ko Joseph ma'u noko hano i Nazareth, te manaha i Galilee ki te manaha o te Hakahua David i Judea e mate tena ingoa ko Bethlehem, iteme'agaa koia te pegea o te hanohano o David. ");
INSERT INTO mnv_vpl VALUES ("LK2_5","072_2_5","LUK","2","5","5","Koia noko hano ki te kungaa, ke tosi haka pigi ia te ia kia Mary, te pegea noko he ahoaho 'aki ki gaaua taka, ka ko Mary kua tina'e huhuga. ");
INSERT INTO mnv_vpl VALUES ("LK2_6","072_2_6","LUK","2","6","6","Te gholoba noko manga noho 'aki ai kigaaua i Bethlehem, te tama 'iti'iti na hetae tena 'aso ke sopo ai. ");
INSERT INTO mnv_vpl VALUES ("LK2_7","072_2_7","LUK","2","7","7","Ko Mary na guea o hai tena tama 'ugumatu'a, noko pegu eia i na laoa o haka takoto i te kunga haangai o na buluka, iteme'agaa na he'e tau kunga kia te kigaaua i te hage kakai o na pegea lango. ");
INSERT INTO mnv_vpl VALUES ("LK2_8","072_2_8","LUK","2","8","8","Noko iai na taangata ge'o sipisipi noko manga kakai i mouku o ge'o agatou sipisipi i te poo. ");
INSERT INTO mnv_vpl VALUES ("LK2_9","072_2_9","LUK","2","9","9","Te ensel o te 'Aitu noko haka 'agitino kia te kigatou, ma te mamagunga o te 'Aitu noko maagamatia ai kigatou o matataku ai. ");
INSERT INTO mnv_vpl VALUES ("LK2_10","072_2_10","LUK","2","10","10","Ma te hai atu te ensel kia te kigatou, “Noka tautou matataku, na'e to'o mai eau te Gongo Gaoi, kago haiga'a te hu'ai magaohie ki ba'i pegea. ");
INSERT INTO mnv_vpl VALUES ("LK2_11","072_2_11","LUK","2","11","11","Te ma'ugi sanga kia te koutou kua sopo i te 'aso nei i te manaha o David, ko Ia te 'Agiki Taga'ia, te 'Aitu. ");
INSERT INTO mnv_vpl VALUES ("LK2_12","072_2_12","LUK","2","12","12","Tenei te haka 'igonga ke go na'a ai e koutou: Kago kite e koutou te tama 'iti'iti manga pegu i na laoa o haka takoto i te kunga haangai o na buluka.” ");
INSERT INTO mnv_vpl VALUES ("LK2_13","072_2_13","LUK","2","13","13","Ma te ghali te hu'ai tu'uganga mai te gangi o haka 'agitino haka pigi ki te ensel noko mataa a'u, o noko manga taugua haka e'eha kia te 'Aitu, o kogaa agatou to'o, ");
INSERT INTO mnv_vpl VALUES ("LK2_14","072_2_14","LUK","2","14","14","“Te mamagunga kia te 'Aitu e hu'ai ma'u'agunga, ma te goto maagie ki te kege nei ki na pegea manga magaohie kinai a te 'Aitu.” ");
INSERT INTO mnv_vpl VALUES ("LK2_15","072_2_15","LUK","2","15","15","Te gholoba na boo 'aatea ai na ensel ia te kigatou i tegatou giu 'anga ki te gangi, na pegea ge'o sipisipi noko kogaa agatou hegeu, “Kitatou boo ki Bethlehem o hiina'i ki te hai 'anga e hai nei, na'e kua 'oti i te 'atigongo ai te 'Aitu kia te kitatou.” ");
INSERT INTO mnv_vpl VALUES ("LK2_16","072_2_16","LUK","2","16","16","Ko kigatou na ghali o boo o kite ia Mary ma Joseph ma te tama 'iti'iti manga haka takoto ki te kunga haangai o na buluka. ");
INSERT INTO mnv_vpl VALUES ("LK2_17","072_2_17","LUK","2","17","17","Te gholoba noko hiina'i ai kigatou kia te Ia, ko kigatou na 'atigongo boo i nia kua 'atigongo ai te ensel kia te kigatou i na noho o te tama 'iti'iti nei. ");
INSERT INTO mnv_vpl VALUES ("LK2_18","072_2_18","LUK","2","18","18","Na pegea noko haka gongo kinai, na hu'ai he tu'ia 'aki i na hai 'anga noko hogahoga e na pegea ge'o sipisipi kia te kigatou. ");
INSERT INTO mnv_vpl VALUES ("LK2_19","072_2_19","LUK","2","19","19","Ka ko Mary noko manga pipiki eia na hai 'anga nei o manga hai tegeu'a kinai i te uso. ");
INSERT INTO mnv_vpl VALUES ("LK2_20","072_2_20","LUK","2","20","20","Na pegea ge'o sipisipi noko giu ma tegatou taugua haka e'eha kia te 'Aitu i ba'i me'a kua haka gongo ai ma te hiina'i kinai, noko manga papata ki na hai 'anga noko hogahoga e te ensel kia te kigatou. ");
INSERT INTO mnv_vpl VALUES ("LK2_21","072_2_21","LUK","2","21","21","Nimaa hetae ki te bagunga 'ao, te 'aso haka pau ke kuga ai te tama 'iti'iti, ko Ia na haka ingoa ko Jesus, te ingoa noko tuku e te ensel ka koi he'e hai tama ai a Mary. ");
INSERT INTO mnv_vpl VALUES ("LK2_22","072_2_22","LUK","2","22","22","Nimaa hetae ki te 'aso ke haa ma'a ai ke 'aonga ki na tagangonga a Moses, ko Joseph ma Mary noko to'o e kigaaua ia te Ia ki Jerusalem, ke haka 'agi kia te 'Aitu, ");
INSERT INTO mnv_vpl VALUES ("LK2_23","072_2_23","LUK","2","23","23","ke haka maa'ogi ai te kanukanu 'anga ki na tagangonga a te 'Aitu: “Ko ba'i 'ugumatu'a taangata e hai ke go haa tapu kia te 'Aitu.” ");
INSERT INTO mnv_vpl VALUES ("LK2_24","072_2_24","LUK","2","24","24","Ko kigaaua noko boo ke hai ma'agaaua he sakrifaes i he toka gua gupe pohe toka gua punua manu he gegei, ke papata ki na gea 'anga a te 'Aitu i na tagangonga. ");
INSERT INTO mnv_vpl VALUES ("LK2_25","072_2_25","LUK","2","25","25","Na 'aso na, noko iai te launatasi tangata i Jerusalem tena ingoa ko Simeon, te pegea tinogaoi ma te pipiki i te sogi kia te 'Aitu. Koia noko manga hitagi i Israel ke go haka tausu'u, ka te Spirit Tapu noko manga haka pata kia te ia. ");
INSERT INTO mnv_vpl VALUES ("LK2_26","072_2_26","LUK","2","26","26","Na hogahoga e te Spirit Tapu kia Simeon, koia ka he'e mate, kae hai ke go mataa ina ki te 'Agiki Taga'ia mai a te 'Aitu. ");
INSERT INTO mnv_vpl VALUES ("LK2_27","072_2_27","LUK","2","27","27","Ko Simeon noko hutiaki e te Spirit Tapu o hano ki te kunga i te Hage Tapu. Te gholoba noko to'o ake ai e Joseph ma Mary te tama 'iti'iti a Jesus ke hai kia te Ia nia noko gea kinai na tagangonga, ");
INSERT INTO mnv_vpl VALUES ("LK2_28","072_2_28","LUK","2","28","28","ko Simeon noko sa'u mai eia te tama 'iti'iti o kopi i gua gima, kae haka 'aue ake ai kia te 'Aitu o hai ake, ");
INSERT INTO mnv_vpl VALUES ("LK2_29","072_2_29","LUK","2","29","29","“ 'Agiki, ko Koe manga pipiki ki au tukungaa kupu noko hai, kae manga tuku mai tou guani nei ke go 'oti ma te goto maagie. ");
INSERT INTO mnv_vpl VALUES ("LK2_30","072_2_30","LUK","2","30","30","Na'e ko au kua 'oti i te ina ki te ma'ugi sanga o'ou, ");
INSERT INTO mnv_vpl VALUES ("LK2_31","072_2_31","LUK","2","31","31","noko haka ngaague mai e Koe ke go hiina'i kinai ba'i pegea. ");
INSERT INTO mnv_vpl VALUES ("LK2_32","072_2_32","LUK","2","32","32","Ko Ia te maagama ke haka 'agi ai au gaataki ki na pegea 'aatea, ka te mamagunga ki ou pegea i Israel.” ");
INSERT INTO mnv_vpl VALUES ("LK2_33","072_2_33","LUK","2","33","33","Te tamana ma te tinana o te tama 'iti'iti noko he gege ma'ugi 'aki i te konei na gea 'anga a Simeon ia te Ia. ");
INSERT INTO mnv_vpl VALUES ("LK2_34","072_2_34","LUK","2","34","34","Ma te hakagaoi e Simeon ia te kigaaua, kae hai atu kia te tinana ia Mary, “Te tama 'iti'iti nei kua haka pupugu e te 'Aitu ke go hai kogaa ke hetoki iho, kae hai kogaa ke maa'ugi i Israel. Ko Ia te haka 'igonga mai a te 'Aitu e hai ke go noko gegea haka makau e te 'apitanga. ");
INSERT INTO mnv_vpl VALUES ("LK2_35","072_2_35","LUK","2","35","35","E hai ke go haka 'agi ai agatou maanatu huu. Ka te hu'ai kiba e hai ke go bego ma'u ai te uso o'ou.” ");
INSERT INTO mnv_vpl VALUES ("LK2_36","072_2_36","LUK","2","36","36","Noko iai ma'u te taauga hahine, tena ingoa ko Anna, te tama 'ahine a Penuel, te pegea i te hanohano o Asher. Koia noko hu'ai tauiku, noko hai tena matu'a o noho haka pata 'aki i te hitunga ghapu, kae mate. ");
INSERT INTO mnv_vpl VALUES ("LK2_37","072_2_37","LUK","2","37","37","Ko Anna te hahine magepe noko hano aano hetae ki te katoa haka bagu tuma'a e haa ona ghapu. Koia noko he'e hano 'aatea i te Hage Tapu, noko manga sogi ai ba'i poo ma ba'i 'ao, ma te he'e kai i te sogi ma te taakunga. ");
INSERT INTO mnv_vpl VALUES ("LK2_38","072_2_38","LUK","2","38","38","Te mi'i gholoba na, noko hinake ai a Anna kia te kigatou o haka 'aue kia te 'Aitu, ma te na 'atigongo i te tama 'iti'iti ki ba'i pegea hitagi ke go hiina'i ki te haka tausu'u 'anga e te 'Aitu a Jerusalem. ");
INSERT INTO mnv_vpl VALUES ("LK2_39","072_2_39","LUK","2","39","39","Nimaa 'oti i te hai e Joseph ma Mary ba'i me'a gea ai na tagangonga a te 'Aitu, ko kigaaua noko giu ki Galilee ki tegaaua manaha i Nazareth. ");
INSERT INTO mnv_vpl VALUES ("LK2_40","072_2_40","LUK","2","40","40","Te tama 'iti'iti noko ngasogo ake o tau hinangago ma te hu'ai 'igo'igo, ka te hakagaoi o te 'Aitu noko manga noho kia te Ia. ");
INSERT INTO mnv_vpl VALUES ("LK2_41","072_2_41","LUK","2","41","41","Ko ba'i ghapu ko Joseph ma Mary noko manga boo ai ki Jerusalem ki te haka tahinga o te Passover. ");
INSERT INTO mnv_vpl VALUES ("LK2_42","072_2_42","LUK","2","42","42","Te gholoba noko katoa tuma'a e gua ai na ghapu o Jesus, ko kigatou ngatahi noko haka neke ai ki Jerusalem ki te haka tahinga, ke 'aonga ki na paaunga ana Jew. ");
INSERT INTO mnv_vpl VALUES ("LK2_43","072_2_43","LUK","2","43","43","Nimaa maseu te haka tahinga, ko ona hai maatu'a noko giu ki tegatou manaha, ka te bagokaa ia Jesus noko manga noho i Jerusalem, ka na he'e na'a e kigaaua. ");
INSERT INTO mnv_vpl VALUES ("LK2_44","072_2_44","LUK","2","44","44","Ko kigaaua na giu i te 'ao, kae tegeu'a ake ko Jesus manga he tata'o 'aki i tegatou lango 'anga. Ma te haka tu'u ligo e kigaaua ia te Ia i goto i ogaaua 'atima'ogi ma agaaua hemasi'inga. ");
INSERT INTO mnv_vpl VALUES ("LK2_45","072_2_45","LUK","2","45","45","Te 'aso na he'e kite ai e kigaaua ia Jesus, ko kigaaua na giu ki Jerusalem ke sasaga ia te Ia. ");
INSERT INTO mnv_vpl VALUES ("LK2_46","072_2_46","LUK","2","46","46","Nimaa i te togunga 'ao, kae kite e kigaaua ia Jesus i te Hage Tapu, manga noho haka pata ki na ako o noko manga haka gongo kia te kigatou ma te haka anuanu kia te kigatou. ");
INSERT INTO mnv_vpl VALUES ("LK2_47","072_2_47","LUK","2","47","47","Ko ba'i pegea noko haka gongo kia te Ia i ana naa 'anga ma 'ana haka tau 'anga o hu'ai he langalanga 'aki ai. ");
INSERT INTO mnv_vpl VALUES ("LK2_48","072_2_48","LUK","2","48","48","Te gholoba na kite ai e Joseph ma Mary, ko kigaaua noko hu'ai he gege ma'ugi 'aki ai, ma te hai atu a Mary kia Jesus, “Tama, 'eaa e konei au hai ai kia te kimaaua? Ko kimaaua ma te tamau kua ngageto'igoto i te sasaga ia te Koe.” ");
INSERT INTO mnv_vpl VALUES ("LK2_49","072_2_49","LUK","2","49","49","Ka ko Jesus noko haka tau o hai atu, “ 'Eaa e sasaga ai e kougua ia te Au? 'Ai e he'e na'a e kougua tenei te hage o Tamau noko hai kau noho ai?” ");
INSERT INTO mnv_vpl VALUES ("LK2_50","072_2_50","LUK","2","50","50","Ka noko he'e na'a e kigaaua, poe kohea na gaataki tena gea 'anga. ");
INSERT INTO mnv_vpl VALUES ("LK2_51","072_2_51","LUK","2","51","51","Ko Jesus na tata'o hoki ia te kigaaua ki Nazareth o noko manga maangao kinai, ka ko te tinana noko na'a pipiki eia ba'i me'a i te uso o'ona. ");
INSERT INTO mnv_vpl VALUES ("LK2_52","072_2_52","LUK","2","52","52","Ko Jesus noko ngasogo te tino ma te 'igo'igo, kae siahahai kinai a te 'Aitu ma pegea. ");
INSERT INTO mnv_vpl VALUES ("LK3_1","072_3_1","LUK","3","1","1","Nimaa hetae te katoa tuma'a e gima ghapu noko hakahua ai a Tiberias Caesar, kae gahumanu a Pontias Pilate i Judea, kae hakahua a Herod i Galilee, kae hakahua a te taina Philip i Iturea ma gaa manaha i Traconitis, kae hakahua a Lysanias i Abilene, ");
INSERT INTO mnv_vpl VALUES ("LK3_2","072_3_2","LUK","3","2","2","kae gua hakahua o na priest ko Annas ma Caiaphas, tenaa te 'aso noko gea ai a te 'Aitu kia John te hosa o Zechariah i te tugatea. ");
INSERT INTO mnv_vpl VALUES ("LK3_3","072_3_3","LUK","3","3","3","Ko John noko hano ki ba'i kakai 'anga noko mugheghi i te bai mimigo i Jordan o tohi'aki ai i te haa gogomi ke haka 'agi ai kua sui tegeu'a ma te ke haka noka ai na 'oosongo. ");
INSERT INTO mnv_vpl VALUES ("LK3_4","072_3_4","LUK","3","4","4","Ke noho pe te kanukanu 'anga e Isaiah te taauga ki tena buka o hai ake: “Te ge'o o te launatasi pegea manga ngege i te tugatea o hai ake: ‘Ngaague atu te aga kia te 'Agiki, gosigosi atu te aga kia te Ia ke tino gaoi. ");
INSERT INTO mnv_vpl VALUES ("LK3_5","072_3_5","LUK","3","5","5","Ko ba'i abaga e hai ke 'ati ke hohonu, kae hai na hu'ai ogo ma na mi'i ogo ke pagago, kae hai na aga e he ghaughau 'aki ke tinogaoi, kae hai na aga ngaoa'a ke magagigagi. ");
INSERT INTO mnv_vpl VALUES ("LK3_6","072_3_6","LUK","3","6","6","Ko ba'i pegea e hai ke go hiina'i ki te ma'ugi sanga e hai ke go a'u mai a te 'Aitu.’ ” ");
INSERT INTO mnv_vpl VALUES ("LK3_7","072_3_7","LUK","3","7","7","Ko John noko kogaa ana to'o atu ki te 'apitanga noko boomai ke haa gogomi eia, “Koutou te haanau ana ngata! Koai noko baa gongo ia te koutou ke he 'agiko i te 'ika'ika o'ona e hai ke go a'u? ");
INSERT INTO mnv_vpl VALUES ("LK3_8","072_3_8","LUK","3","8","8","Hai atu e koutou ni hai 'anga ke haka 'agi ai koutou kua hekeu 'aki giu mai i outou 'oosongo, kae noka tautou tegeu'a gaoi o hai ake, ‘Ko Abraham tematou tupuna.’ Iteme'agaa ko Au e hai atu kia te koutou, na hatu nei manga 'aonga te hai e te 'Aitu ke sosopo mai ai ni pegea ke hai ai he hanohano mo'o Abraham. ");
INSERT INTO mnv_vpl VALUES ("LK3_9","072_3_9","LUK","3","9","9","Te 'akis kua 'oti i te tuku ki na tugi o na ga'akau. Ka ko ba'i ga'akau he'e hua gaoi e hai ke go tua o seu ki te ahi.” ");
INSERT INTO mnv_vpl VALUES ("LK3_10","072_3_10","LUK","3","10","10","Te 'apitanga noko haka anuanu 'aki atu kia John o hai atu, “Niaa te hai kimatou hai 'ia?” ");
INSERT INTO mnv_vpl VALUES ("LK3_11","072_3_11","LUK","3","11","11","Haka tau a John o hai atu kinai, “Koai e hai mo'ona he toka gua ake: 'Abatu he launatasi mo'o te pegea e lae ai, ka koai e hai ma'ana ni utunga: Tuha atu ma'u.” ");
INSERT INTO mnv_vpl VALUES ("LK3_12","072_3_12","LUK","3","12","12","He'e po na pegea tibu takis noko boomai ke haa gogomi, noko hakaanu atu kia te ia, “Ako, niaa hai kimatou hai 'ia?” ");
INSERT INTO mnv_vpl VALUES ("LK3_13","072_3_13","LUK","3","13","13","Koia noko haka tau o hai atu kia te kigatou, “Noka te tibu e koutou na takis ke sigi i ona pootaha.” ");
INSERT INTO mnv_vpl VALUES ("LK3_14","072_3_14","LUK","3","14","14","Noko iai kogaa i na pegea hai tau'a, noko haka anuanu kia te ia o hai atu, “Ka niaa te hai kimatou hai 'ia?” Ka ko John noko haka tau o hai atu kinai, “Noka te boo o haka matakutaku kogaa pegea ke to'o agatou mane, ma te noka te 'atigongo songo ai, kae manga magagaohie ake i na tau'i o'outou.” ");
INSERT INTO mnv_vpl VALUES ("LK3_15","072_3_15","LUK","3","15","15","Na pegea noko manga pali ma te mou tegeu'a i ogatou uso i te poi maa'ogi ko John te 'Agiki Taga'ia. ");
INSERT INTO mnv_vpl VALUES ("LK3_16","072_3_16","LUK","3","16","16","Ka ko John noko hai atu kia te kigatou ngatahi, “E haa gogomi eau ia te koutou i na bai, kae iai te launatasi e hu'ai taganga o sigi ia te au e hai ke go a'u, kago he'e 'aonga te huhuke eau na me'a gii o na taka ba'e o'ona. Ko Ia e hai ke go haa gogomi ia te koutou i te Spirit Tapu ma te ahi. ");
INSERT INTO mnv_vpl VALUES ("LK3_17","072_3_17","LUK","3","17","17","Ko Ia manga kopi tena me'a hai hekau e hai kego haka 'aatea ai na penu i tena hata hai witi, ka ke haka putu na hatu witi ki tena hage tuku utunga, kae tutu na penu o na witi i te ahi e he'e 'aonga te tamate.” ");
INSERT INTO mnv_vpl VALUES ("LK3_18","072_3_18","LUK","3","18","18","Noko 'eha ma'u kogaa gea 'anga a John noko tongi tongi aki ai eia te 'apitanga i na tohi'aki 'anga i te Gongo Gaoi kia te kigatou. ");
INSERT INTO mnv_vpl VALUES ("LK3_19","072_3_19","LUK","3","19","19","Ko John noko haka bagebage kia Herod te gahumanu, i te pipiki 'anga eia a Herodias, te uguugu o te taina, ma gaa me'a maase'i noko hai eia. ");
INSERT INTO mnv_vpl VALUES ("LK3_20","072_3_20","LUK","3","20","20","Ko Herod noko hai eia tegaa hai 'anga hu'ai maase'i, i te tuku 'anga eia ia John ki te kunga o na pegea kagohia. ");
INSERT INTO mnv_vpl VALUES ("LK3_21","072_3_21","LUK","3","21","21","Te gholoba noko haa gogomi ai ba'i pegea, ko Jesus noko haa gogomi ma'u ai. Te 'aso noko taakunga ai a Jesus, ko te gangi noko luga kinai, ");
INSERT INTO mnv_vpl VALUES ("LK3_22","072_3_22","LUK","3","22","22","ma te hinaiho te Spirit Tapu kia te Ia noko hai te tino o noho pe te gupe, kae sopo iho te ge'o mai te gangi o hai iho, “Ko Koe toku Hosa e hu'ai ma'ine kinai Au. Koau e hu'ai magaohie kia te Koe.” ");
INSERT INTO mnv_vpl VALUES ("LK3_23","072_3_23","LUK","3","23","23","Ko Jesus noko katoa haka togu ona ghapu 'io mugi o haka tu'u ana hekau. Ko Ia noko tegeu'a ake a pegea te hosa o Joseph, ka ko Joseph te hosa o Heli, ko Heli, te hosa o Matthat. ");
INSERT INTO mnv_vpl VALUES ("LK3_24","072_3_24","LUK","3","24","24","Ko Matthat te hosa o Levi, ko Levi te hosa o Melki, ko Melki te hosa o Jannai, ko Jannai te hosa o Joseph. ");
INSERT INTO mnv_vpl VALUES ("LK3_25","072_3_25","LUK","3","25","25","Ko Joseph te hosa o Mattathias, ko Mattathias te hosa o Amos, ko Amos te hosa o Nahum, ko Nahum te hosa o Esli, ko Esli te hosa o Naggai. ");
INSERT INTO mnv_vpl VALUES ("LK3_26","072_3_26","LUK","3","26","26","Ko Naggai te hosa o Maath, ko Maath te hosa o Mattathias, ko Mattathias te hosa o Semein, ko Semein te hosa o Josech, ko Josech te hosa o Joda. ");
INSERT INTO mnv_vpl VALUES ("LK3_27","072_3_27","LUK","3","27","27","Ko Joda te hosa o Joanan, ko Joanan te hosa o Rhesa, ko Rhesa te hosa o Zerubbabel, ko Zerubbabel te hosa o Shealtiel, ko Shealtiel te hosa o Neri. ");
INSERT INTO mnv_vpl VALUES ("LK3_28","072_3_28","LUK","3","28","28","Ko Neri te hosa o Melki, ko Melki te hosa o Addi, ko Addi te hosa o Cosam, ko Cosam te hosa o Elmadam, ko Elmadam te hosa o Er. ");
INSERT INTO mnv_vpl VALUES ("LK3_29","072_3_29","LUK","3","29","29","Ko Er te hosa o Joshua, ko Joshua te hosa o Eliezer, ko Eliezer te hosa o Jorim, ko Jorim te hosa o Matthat, ko Matthat te hosa o Levi. ");
INSERT INTO mnv_vpl VALUES ("LK3_30","072_3_30","LUK","3","30","30","Ko Levi te hosa o Simeon, ko Simeon te hosa o Judah, ko Judah te hosa o Joseph, ko Joseph te hosa o Jonam, ko Jonam te hosa o Eliakim. ");
INSERT INTO mnv_vpl VALUES ("LK3_31","072_3_31","LUK","3","31","31","Ko Eliakim te hosa o Melea, ko Melea te hosa o Menna, ko Menna te hosa o Mattatha, ko Mattatha te hosa o Nathan, ko Nathan te hosa o David. ");
INSERT INTO mnv_vpl VALUES ("LK3_32","072_3_32","LUK","3","32","32","Ko David te hosa o Jesse, ko Jesse te hosa o Obed, ko Obed te hosa o Boaz, ko Boaz te hosa o Salmon, ko Salmon te hosa o Nahshon. ");
INSERT INTO mnv_vpl VALUES ("LK3_33","072_3_33","LUK","3","33","33","Ko Nahshon te hosa o Amminadab, ko Amminadab te hosa o Ram, ko Ram te hosa o Hezron, ko Hezron te hosa o Perez, ko Perez te hosa o Judah. ");
INSERT INTO mnv_vpl VALUES ("LK3_34","072_3_34","LUK","3","34","34","Ko Judah te hosa o Jacob, ko Jacob te hosa o Isaac, ko Isaac te hosa o Abraham, ko Abraham te hosa o Terah, ko Terah te hosa o Nahor. ");
INSERT INTO mnv_vpl VALUES ("LK3_35","072_3_35","LUK","3","35","35","Ko Nahor te hosa o Serug, ko Serug te hosa o Reu, ko Reu te hosa o Peleg, ko Peleg te hosa o Eber, ko Eber te hosa o Shelah. ");
INSERT INTO mnv_vpl VALUES ("LK3_36","072_3_36","LUK","3","36","36","Ko Shelah te hosa o Cainan, ko Cainan te hosa o Arphaxad, ko Arphaxad te hosa o Shem, ko Shem te hosa o Noah, ko Noah te hosa o Lamech. ");
INSERT INTO mnv_vpl VALUES ("LK3_37","072_3_37","LUK","3","37","37","Ko Lamech te hosa o Methuselah, ko Methuselah te hosa o Enoch, ko Enoch te hosa o Jared, ko Jared te hosa o Mahalalel, ko Mahalalel te hosa o Kenan. ");
INSERT INTO mnv_vpl VALUES ("LK3_38","072_3_38","LUK","3","38","38","Ko Kenan te hosa o Enosh, ko Enosh te hosa o Seth, ko Seth te hosa o Adam, ko Adam te hosa o te 'Aitu. ");
INSERT INTO mnv_vpl VALUES ("LK4_1","072_4_1","LUK","4","1","1","Ko Jesus noko honu i te Spirit Tapu, o hoki i te bai mimigo i Jordan ma te hutiaki e te Spirit Tapu ki te tugatea, ");
INSERT INTO mnv_vpl VALUES ("LK4_2","072_4_2","LUK","4","2","2","o katoa haka haa ai ona 'ao noko pake ai e Satan. Ko Ia noko he'e kai i na 'ao na, aano hetae ki te 'otinga o te katoa haka haa 'ao, kae ongea. ");
INSERT INTO mnv_vpl VALUES ("LK4_3","072_4_3","LUK","4","3","3","Ko Satan noko hai atu kia Jesus, “Ko Koe nimaa te Hosa o te 'Aitu, gea iho ki te hatu nei ke hai ai ni utunga.” ");
INSERT INTO mnv_vpl VALUES ("LK4_4","072_4_4","LUK","4","4","4","Ka ko Jesus noko haka tau kia Satan o hai atu kinai, “Na 'oti i te kanukanu: ‘Ko pegea ka he'e manga maa'ugi i na utunga.’ ” ");
INSERT INTO mnv_vpl VALUES ("LK4_5","072_4_5","LUK","4","5","5","Ma te kakabe e Satan ia Jesus ki te ogo ma'u 'agunga o tuiaki kia te Ia ba'i kakai 'anga i te kege nei i te mi'i gholoba. ");
INSERT INTO mnv_vpl VALUES ("LK4_6","072_4_6","LUK","4","6","6","Kae hai atu a Satan kia Jesus, “E hai kau haiga'a 'ia kia te Koe ba'i taganga ma ba'i me'a gaoi agatou, iteme'agaa kua 'oti i te tuku kia te au, kae hai kau sui o haiga'a 'ia ki he pegea siahai kau haiga'a 'ia kinai. ");
INSERT INTO mnv_vpl VALUES ("LK4_7","072_4_7","LUK","4","7","7","Ka poi sogi Koe kia te au, ko ba'i me'a na me'a a'au.” ");
INSERT INTO mnv_vpl VALUES ("LK4_8","072_4_8","LUK","4","8","8","Ka ko Jesus noko haka tau kinai o hai atu, “Na 'oti i te kanukanu: ‘Manga sogi atu kia te 'Agiki te 'Aitu o 'ou, ma te hai hekau kia te Ia launatasi.’ ” ");
INSERT INTO mnv_vpl VALUES ("LK4_9","072_4_9","LUK","4","9","9","Nimaa kakabe e Satan ia Jesus ki Jerusalem o hai eia o tu'u i te kunga e hu'ai ma'u 'agunga i te Hage Tapu, kae hai atu kinai, “Ko Koe nimaa te Hosa o te 'Aitu, 'utu atu ki gago i te kunga nei, ");
INSERT INTO mnv_vpl VALUES ("LK4_10","072_4_10","LUK","4","10","10","na'e na 'oti i te kanukanu: ‘Ko Ia e hai ke go tuku ona ensel ke go ge'o gaoi ia te Koe, ");
INSERT INTO mnv_vpl VALUES ("LK4_11","072_4_11","LUK","4","11","11","ma te ke go nekeneke e kigatou ia te Koe i ogatou gima, ka ke go noka te tukia ou ba'e kini hatu.’ ” ");
INSERT INTO mnv_vpl VALUES ("LK4_12","072_4_12","LUK","4","12","12","Ka ko Jesus noko haka tau kia Satan o hai atu kinai, “Na 'oti i te hai ake: ‘Noka te hai lobo e koe te 'Agiki te 'Aitu o 'ou.’ ” ");
INSERT INTO mnv_vpl VALUES ("LK4_13","072_4_13","LUK","4","13","13","Te 'aso na 'oti ai ba'i pakenga a Satan, koia noko hano 'aatea ia Jesus kego aano tatae ki he gholoba tau gaoi. ");
INSERT INTO mnv_vpl VALUES ("LK4_14","072_4_14","LUK","4","14","14","Ko Jesus noko hoki ki Galilee i na taganga o te Spirit Tapu, ka te gongo o'ona na mahoga i ba'i kunga i te kakai 'anga. ");
INSERT INTO mnv_vpl VALUES ("LK4_15","072_4_15","LUK","4","15","15","Ko Ia noko manga ako i ogatou Hage hai paaunga, ka te 'apitanga noko haka e'eha ia te Ia. ");
INSERT INTO mnv_vpl VALUES ("LK4_16","072_4_16","LUK","4","16","16","Ka na hano a Jesus ki Nazareth, te kunga noko haka tu'u ngasogo ai Ia. Nimaa te 'ao oki oki, ko Ia noko hano ki te Hage hai paaunga, iteme'agaa tena toonginga. Ko Jesus noko tu'u ke haka sahe. ");
INSERT INTO mnv_vpl VALUES ("LK4_17","072_4_17","LUK","4","17","17","Ma te 'abange 'ia kinai te buka a te taauga a Isaiah, o huhuke e Ia o kite ai te kunga na 'oti i te kanukanu, noko kogaa na to'o: ");
INSERT INTO mnv_vpl VALUES ("LK4_18","072_4_18","LUK","4","18","18","“Te Spirit o te 'Aitu kua ia te Au, iteme'agaa ko Ia na haka pau e Ia ia te Au kau tohi'aki i te Gongo Gaoi ki na pegea lae. Ko Ia noko tuku ia te Au kau 'atigongo i te noho 'aki tausu'u ki na pegea kagohia, ma te ke lugaluga na mata o na pegea kikibi, ma te ke hai ke tausu'u na pegea tino akina, ");
INSERT INTO mnv_vpl VALUES ("LK4_19","072_4_19","LUK","4","19","19","ma te ke hogahoga tenei te ghapu tau gaoi e hai ke haka ma'ugi ai e te 'Aitu ona pegea.” ");
INSERT INTO mnv_vpl VALUES ("LK4_20","072_4_20","LUK","4","20","20","Kae pegu e Ia te buka o 'abange haka hoki ki te pegea noko hai hekau, kae noho hoki. Ko ba'i pegea noko i te Hage hai paaunga na manga pau o hiina'i titingi kia te Ia. ");
INSERT INTO mnv_vpl VALUES ("LK4_21","072_4_21","LUK","4","21","21","Ka ko Jesus noko hai atu kia te kigatou, “Te 'aso nei te Kanukanu Tapu nei kua tatae maa'ogi mai o haka gongo kinai koutou.” ");
INSERT INTO mnv_vpl VALUES ("LK4_22","072_4_22","LUK","4","22","22","Ko ba'i pegea noko he 'aamuti 'aki ia Jesus i na haka hegeunga gaoi noko gea ai, ma te kogaa agatou he haka anuanu 'aki, “ 'Ai he'e tenei te hosa o Joseph?” ");
INSERT INTO mnv_vpl VALUES ("LK4_23","072_4_23","LUK","4","23","23","Ko Jesus noko hai atu kia te kigatou, “E na'a e Au e hai ke haka meme'i e koutou te gea haka hasa nei kia te Au: ‘Dokita, haka ma'ugi iho ia te Koe!’ Hai mai ma'u koutou, ‘Hai iho i tou manaha nei na me'a noko haka gongo ai kimatou noko ma hai e Koe i Capernaum.’ ” ");
INSERT INTO mnv_vpl VALUES ("LK4_24","072_4_24","LUK","4","24","24","Ko Jesus noko gea soo atu o hai atu, “Ko Au e gea maa'ogi atu kia te koutou, e si'ai he taauga ke siahahai kinai tena manaha. ");
INSERT INTO mnv_vpl VALUES ("LK4_25","072_4_25","LUK","4","25","25","Ko Au e 'atigongo maa'ogi atu kia te koutou, noko 'api haahine magegepe noko i Israel i na 'aso o Elijah na tu'a ga'aa ai o togunga ghapu ma te ononga maahina, kae hetae ma'u te hu'ai ongesau ki te kakai 'anga ngatahi. ");
INSERT INTO mnv_vpl VALUES ("LK4_26","072_4_26","LUK","4","26","26","Ka noko he'e tuku 'ia a Elijah ke hano ki he pegea ia te kigatou, ka noko manga tuku o hano ki te hahine magepe i Zarephath i te kunga henua i Sidon. ");
INSERT INTO mnv_vpl VALUES ("LK4_27","072_4_27","LUK","4","27","27","Noko 'api pegea i Israel noko iai na pegea kahoa i na 'aso o Elisha te taauga, ka noko si'ai he pegea ia te kigatou ke mahu, ka manga ko Naaman te pegea mai Syria.” ");
INSERT INTO mnv_vpl VALUES ("LK4_28","072_4_28","LUK","4","28","28","Te 'apitanga noko i te Hage hai paaunga na he 'ika'ika 'aki i te gholoba noko haka gongo ai kigatou ki tena gea 'anga nei. ");
INSERT INTO mnv_vpl VALUES ("LK4_29","072_4_29","LUK","4","29","29","Ko kigatou na tutu'u o pagepage e kigatou ia Jesus ki tu'a i te manaha, ma te kakabe ia te Ia ki te hohonga o te ogo noko 'ati ai tegatou manaha, kigatou 'aka 'ia ia te Ia ki gago i te tihaa. ");
INSERT INTO mnv_vpl VALUES ("LK4_30","072_4_30","LUK","4","30","30","Ka ko Jesus na hano i goto i te 'apitanga o pau o hano. ");
INSERT INTO mnv_vpl VALUES ("LK4_31","072_4_31","LUK","4","31","31","Ma te mugi a Jesus o hano ki Capernaum, te manaha i Galilee. Nimaa i te 'ao oki oki, ko Ia noko haka tu'u ako te 'apitanga. ");
INSERT INTO mnv_vpl VALUES ("LK4_32","072_4_32","LUK","4","32","32","Ko kigatou noko he gege ma'ugi 'aki i ana akonga, iteme'agaa ana haka hegeunga noko iai te taganga. ");
INSERT INTO mnv_vpl VALUES ("LK4_33","072_4_33","LUK","4","33","33","Ko goto i te Hage hai paaunga noko iai te launatasi tangata noko iai te haagiki, koia noko tangi ngege o hai atu, ");
INSERT INTO mnv_vpl VALUES ("LK4_34","072_4_34","LUK","4","34","34","“Ko Koe Jesus mai Nazareth, niaa te siahai Koe ke hai kia te kimatou? 'Ai ko Koe e a'u ke taa ia te kimatou? E na'a eau ia te Koe te tangata tapu o te 'Aitu!” ");
INSERT INTO mnv_vpl VALUES ("LK4_35","072_4_35","LUK","4","35","35","Ma te hai atu a Jesus ki te haagiki, “Ngongoto 'iho! Sopo iho ia te ia!” Ma te tupe e te haagiki te tangata ki te kege i 'ago ia te kigatou ngatahi, kae sopo iho, ka noko si'ai he maka ke hai eia ki te tangata. ");
INSERT INTO mnv_vpl VALUES ("LK4_36","072_4_36","LUK","4","36","36","Te 'apitanga noko he gege ma'ugi 'aki o kogaa agatou to'o kia te kigatou, “Na haka hegeunga aa konei? E hu'ai to'a kae taganga. Ko Ia e gea ki na haagiki songo o sosopo ki taha!” ");
INSERT INTO mnv_vpl VALUES ("LK4_37","072_4_37","LUK","4","37","37","Na gongo o'ona noko mahoga i ba'i kunga i te kakai 'anga. ");
INSERT INTO mnv_vpl VALUES ("LK4_38","072_4_38","LUK","4","38","38","Ko Jesus noko hano i te Hage hai paaunga ki te hage o Simon. Te tinana hungabai o Simon manga takoto i te noko hu'ai 'augia. Ko kigatou noko haka ene 'aki kia Jesus ke 'aabaki kia te ia. ");
INSERT INTO mnv_vpl VALUES ("LK4_39","072_4_39","LUK","4","39","39","Ma te hano a Jesus o tu'u i na pa'asi o te hahine o gea to'a ki te 'augia ma te sigi ia te ia. Te hahine na ghali o 'aga mai o hai hekau kia te kigatou. ");
INSERT INTO mnv_vpl VALUES ("LK4_40","072_4_40","LUK","4","40","40","Nimaa mene te ga'aa, ko ba'i pegea noko kakabe mai e kigatou kia Jesus na pegea noko taki hai ogatou masaki. Ma te tuku gua gima kia te kigatou taki tasi o haka ma'ugi ia te kigatou ngatahi. ");
INSERT INTO mnv_vpl VALUES ("LK4_41","072_4_41","LUK","4","41","41","Na ta'u haagiki songo noko sosopo iho i te 'apitanga o boo, noko ngengege o kogaa agatou to'o, “Ko Koe te Hosa o te 'Aitu!” Ka ko Jesus noko susugi ia te kigatou o kaunaki ia te kigatou ke noka te gegea, iteme'agaa noko na'a e kigatou ko Ia te 'Agiki Taga'ia. ");
INSERT INTO mnv_vpl VALUES ("LK4_42","072_4_42","LUK","4","42","42","Nimaa te 'ago ke 'ao, ko Jesus noko hano 'aatea i te manaha ki te kunga gaabaki. Te 'apitanga noko sasaga ia te Ia aano hetae ki te kunga noko manga noho ai, ma te hai lobo kigatou pipiki 'ia ke noka te hano ia te kigatou. ");
INSERT INTO mnv_vpl VALUES ("LK4_43","072_4_43","LUK","4","43","43","Ka ko Jesus noko hai atu, “Ko Au e hai kau tohi'aki i te Gongo Gaoi o te Hakahua 'anga a te 'Aitu ki gaa manaha ma'u, iteme'agaa tenei te hai 'anga noko haka to'o mai ai ia te Au.” ");
INSERT INTO mnv_vpl VALUES ("LK4_44","072_4_44","LUK","4","44","44","Ko Jesus noko manga pau o tohi'aki i na Hage hai paaunga i Judea. ");
INSERT INTO mnv_vpl VALUES ("LK5_1","072_5_1","LUK","5","1","1","Nimaa te tasi 'ao, ko Jesus noko manga tu'u ai i te tau ganga i te gano i Gennesaret, kae haka putu mai kinai ba'i pegea o noho 'aki mugheghi ia te Ia ke haka gongo ki na haka hegeunga a te 'Aitu. ");
INSERT INTO mnv_vpl VALUES ("LK5_2","072_5_2","LUK","5","2","2","Nimaa ina 'atu a Jesus te tokagua baka manga tau mai i te tauganga, ka na taangata tautai kua boo ke huhu'i ogatou bugho. ");
INSERT INTO mnv_vpl VALUES ("LK5_3","072_5_3","LUK","5","3","3","Ko Jesus noko sopo ki tegaa i gua baka, te baka o Simon, ka noko haka ene kinai a Jesus ke mi'i tuku soo atu i te tau ganga, ma te noho ai o ako te 'apitanga. ");
INSERT INTO mnv_vpl VALUES ("LK5_4","072_5_4","LUK","5","4","4","Nimaa 'oti tena haka hegeu, kae hai atu kia Simon, “Tuku soo atu ki te popoko 'anga o tupe ai te bugho ke hai ai ni kaui.” ");
INSERT INTO mnv_vpl VALUES ("LK5_5","072_5_5","LUK","5","5","5","Ka ko Simon noko haka tau o hai atu kinai, “Hakahua, ko kimatou kua ngageto'igoto i te poo nei, kae si'ai ni me'a kimatou hai 'ia, ka naato'o i te kua gea mai Koe, kae hai kau tupe 'ia te bugho nei.” ");
INSERT INTO mnv_vpl VALUES ("LK5_6","072_5_6","LUK","5","6","6","Te gholoba na tupe ai e kigaaua te bugho, noko hu'ai 'eha kaui noko tau ai, ma te hai ke motumotu ai tegaaua bugho. ");
INSERT INTO mnv_vpl VALUES ("LK5_7","072_5_7","LUK","5","7","7","Ma te baa pae atu agaaua hemasi'inga noko i tegaa baka ke boomai o 'aabaki kia te kigaaua. Ma te boomai a kigaaua o uta ngatahi gu'ogatou baka i na kaui o hohonu ma te hakatu'u ke memene. ");
INSERT INTO mnv_vpl VALUES ("LK5_8","072_5_8","LUK","5","8","8","Te gholoba noko ina ai a Peter ki te hai 'anga nei, koia na too ki na tugi o Jesus o hai atu kinai, “Hakahua, hinatu 'aatea ia te au, na'e ko au te pegea 'oosongo ina!” ");
INSERT INTO mnv_vpl VALUES ("LK5_9","072_5_9","LUK","5","9","9","Ko Peter ma ana hemasi'inga na hu'ai he gege ma'ugi 'aki i na kaui noko hu'ai 'eha noko hai e kigatou. ");
INSERT INTO mnv_vpl VALUES ("LK5_10","072_5_10","LUK","5","10","10","Noko konaa na noho ma'u a James ma John, gua hosa o Zebedee, gua hemasi'inga a Peter. Ko Jesus noko kogaa na to'o atu kia Peter, “Noka tau mataku, na'e haka tu'u i te 'aso nei o hano, ko koe e hai kego tautai pegea mai kia te au.” ");
INSERT INTO mnv_vpl VALUES ("LK5_11","072_5_11","LUK","5","11","11","Ko kigatou na toso ogatou baka ki 'agunga o tuku ai ma ba'i me'a agatou, kae tata'o ia Jesus. ");
INSERT INTO mnv_vpl VALUES ("LK5_12","072_5_12","LUK","5","12","12","Te 'aso noko manga noho ai a Jesus i tegaa manaha, noko a'u ai te launatasi tangata kahoa. Te gholoba noko ina ai kia Jesus, koia noko too ki te kege o sasaka kia te Ia o hai ake, “Hakahua, nimaa gaoi kia te Koe, hai mai ia te au kau mahu.” ");
INSERT INTO mnv_vpl VALUES ("LK5_13","072_5_13","LUK","5","13","13","Ma te hohoga atu te gima o Jesus o 'oso atu ki te tangata, kae hai atu kinai, “Manga gaoi kia te Au. Ko koe e hai ke mahu.” Ma te ghali te kahoa 'anga o masogo. ");
INSERT INTO mnv_vpl VALUES ("LK5_14","072_5_14","LUK","5","14","14","Kae hai taagango kinai a Jesus o hai atu, “Noka tau 'atigongo ai ki he pegea, kae manga hinatu ki te priest ke ina kia te koe, kae hai atu te begiunga noko gea ai a Moses ke haka 'agi ai, ko koe kua pau o mahu.” ");
INSERT INTO mnv_vpl VALUES ("LK5_15","072_5_15","LUK","5","15","15","Te gongo o Jesus na hohoga soo atu, ma te haka putu mai ai te 'apitanga o ba'i pegea ke haka gongo kia te Ia, ma te ke haka ma'ugi i ogatou masaki. ");
INSERT INTO mnv_vpl VALUES ("LK5_16","072_5_16","LUK","5","16","16","Ka ko Ia na hano 'aatea ia te kigatou ki na kunga gaabaki o noko manga noho ai o taakunga. ");
INSERT INTO mnv_vpl VALUES ("LK5_17","072_5_17","LUK","5","17","17","Nimaa te tasi 'ao, ko Jesus noko manga ako ai, ka na Pharisee ma na ako o na tagangonga noko boomai i ba'i manaha i Galilee, ma Judea, ma Jerusalem o noko ma noho 'aki i te kungaa. Ka na taganga o te 'Aitu noko ia Jesus ke haka ma'ugi masaki ai. ");
INSERT INTO mnv_vpl VALUES ("LK5_18","072_5_18","LUK","5","18","18","Noko iai na pegea noko 'amo mai e kigatou te pegea masaki taa haka pikipiki i te kaupea. Noko hai lobo kigatou to'o 'ia ki goto i te hage ke tuku i 'ago ia Jesus. ");
INSERT INTO mnv_vpl VALUES ("LK5_19","072_5_19","LUK","5","19","19","Ka na he'e kite e kigatou he aga ke hai ai, iteme'agaa noko hu'ai 'api, ma te he kaakei kigatou ki te tu'aa hage o ta'aki, kae tuku iho ai ia te ia i te kaupea ki te uso o te haka putunga i 'ago ia Jesus. ");
INSERT INTO mnv_vpl VALUES ("LK5_20","072_5_20","LUK","5","20","20","Te 'aso noko ina ai a Jesus ki te sano ogatou, ko Ia noko hai atu, “Taku hemasi'inga, ou 'oosongo kua haka noka.” ");
INSERT INTO mnv_vpl VALUES ("LK5_21","072_5_21","LUK","5","21","21","Na Pharisee ma na ako o na tagangonga na kogaa agatou tegeu'a, “Te pegea aa tenei e igho? 'Ai koai e 'aonga te haka noka na 'oosongo, ka manga ko te 'Aitu launatasi?” ");
INSERT INTO mnv_vpl VALUES ("LK5_22","072_5_22","LUK","5","22","22","Ko Jesus noko na'a e Ia agatou tegeu'a ma te hakaanu atu kinai, “ 'Eaa e konaa na tegeu'a ai i na uso outou? ");
INSERT INTO mnv_vpl VALUES ("LK5_23","072_5_23","LUK","5","23","23","'Ai niaa te haingaohie: I te poi hai atu: ‘Ou 'oosongo kua haka noka,’ poe hai atu: ‘Tu'u ake o hano’? ");
INSERT INTO mnv_vpl VALUES ("LK5_24","072_5_24","LUK","5","24","24","Kae siahai Au ke na'a ai e koutou te Hosa o Pegea e hai taganga i te kege nei ke haka noka na 'oosongo.” Ma te hai atu a Jesus ki te pegea masaki taa haka pikipiki, “Ko Au e hai atu kia te koe: Tu'u ake o to'o tou kaainga o hano ki tou manaha.” ");
INSERT INTO mnv_vpl VALUES ("LK5_25","072_5_25","LUK","5","25","25","Ma te ghali ia, o tu'u i 'ago ia te kigatou, o to'o nia noko manga teka kinai o hano ki tena manaha, ma te haka e'eha eia ia te 'Aitu. ");
INSERT INTO mnv_vpl VALUES ("LK5_26","072_5_26","LUK","5","26","26","Ko ba'i pegea noko he gege ma'ugi 'aki o haka e'eha e kigatou ia te 'Aitu. Ko kigatou noko hu'ai he langalanga 'aki ai o kogaa agatou to'o, “Ko kitatou kua hiina'i ki na hai 'anga hai o'ona noho i te 'aso nei.” ");
INSERT INTO mnv_vpl VALUES ("LK5_27","072_5_27","LUK","5","27","27","Nimaa 'oti na hai 'anga nei, ko Jesus noko hano o kite i te pegea tibu takis tena ingoa ko Levi, manga noho i tena hage hai hekau. Ma te hai atu kinai a Jesus, “Tata'o mai ia te Au.” ");
INSERT INTO mnv_vpl VALUES ("LK5_28","072_5_28","LUK","5","28","28","Ko Levi na tu'u o ti'aki ba'i me'a, kae tata'o ia Jesus. ");
INSERT INTO mnv_vpl VALUES ("LK5_29","072_5_29","LUK","5","29","29","Ma te hai te hu'ai kainga a Levi kia Jesus i tena hage, noko hu'ai 'api pegea tibu takis ma gaa pegea ma'u noko kai haka pigi kia te kigatou. ");
INSERT INTO mnv_vpl VALUES ("LK5_30","072_5_30","LUK","5","30","30","Ka na Pharisee ma na ako o na tagangonga noko tu'utaki ki tegatou tu'uganga, noko haka angaanga 'aki o hai atu kia ona pegea haka ako, “ 'Eaa koutou e kai ma te bibinu haka pigi ai ki na pegea tibu takis ma gaa pegea 'oosongo?” ");
INSERT INTO mnv_vpl VALUES ("LK5_31","072_5_31","LUK","5","31","31","Ka ko Jesus noko haka tau kia te kigatou o hai atu kinai, “E he'e na pegea toka te ligo dokita, ka na pegea masasaki. ");
INSERT INTO mnv_vpl VALUES ("LK5_32","072_5_32","LUK","5","32","32","Koau e he'e a'u kau haka pogo 'ia na pegea tinogaoi, ka manga na pegea 'oosongo ke sui tegeu'a.” ");
INSERT INTO mnv_vpl VALUES ("LK5_33","072_5_33","LUK","5","33","33","Ko kigatou noko hai atu kia Jesus, “Na pegea haka ako o John noko he'e kai i ogatou 'aso taakunga ma te sogi, noko konaa na hai ma'u na pegea haka ako o na Pharisee, ka manga o'ou te manga kai ma te bibinu.” ");
INSERT INTO mnv_vpl VALUES ("LK5_34","072_5_34","LUK","5","34","34","Ma te haka tau a Jesus o hai atu kia te kigatou, “ 'Ai e hai e koutou na pegea haka pogo e te tangata hai uguugu ho'ou ke he'e kai i te gholoba manga haka pata ai kigatou kia te ia? ");
INSERT INTO mnv_vpl VALUES ("LK5_35","072_5_35","LUK","5","35","35","Ka te 'aso kago a'u kago kakabe 'aatea ai te tangata hai uguugu ho'ou ia te kigatou, 'io tenaa tegatou 'aso he'e kai ma te taakunga.” ");
INSERT INTO mnv_vpl VALUES ("LK5_36","072_5_36","LUK","5","36","36","Ko Jesus noko 'atigongo kia te kigatou i te haka gaataki nei, “Ka si'ai he pegea lalagi he momo laoa i te ake ho'ou o lapui ki he bebe ake. Poi konei na hai eia, koia e tangani lalagi eia te ake ho'ou, ka te momo laoa ho'ou ka he'e 'aonga ki te bebe ake. ");
INSERT INTO mnv_vpl VALUES ("LK5_37","072_5_37","LUK","5","37","37","“Ka si'ai he pegea 'utu eia he waeni ho'ou ki he me'a 'utu waeni mai gaa 'aso. Poi konei na hai eia, te waeni ho'ou ka haka puu eia te me'a 'utu waeni, te waeni ka magingi kae maase'i ma'u ai te me'a e 'utu kinai te waeni. ");
INSERT INTO mnv_vpl VALUES ("LK5_38","072_5_38","LUK","5","38","38","E si'ai! Te waeni ho'ou manga 'aonga te 'utu ki ni me'a 'utu waeni ho'ou. ");
INSERT INTO mnv_vpl VALUES ("LK5_39","072_5_39","LUK","5","39","39","“E si'ai ma'u he pegea ke nimaa 'oti i te binu i he waeni mai gaa 'aso kae siahai ki he me'a ho'ou, ka manga kogaa na to'o: ‘Te me'a mai gaa 'aso te gaoi.’ ” ");
INSERT INTO mnv_vpl VALUES ("LK6_1","072_6_1","LUK","6","1","1","Te launatasi 'Ao oki oki ko Jesus noko hano ai i te uso o te 'umanga witi, ka ona pegea haka ako noko haka tu'u haki e kigatou na hua o na witi o migimigi i ogatou gima o kai ona hatu. ");
INSERT INTO mnv_vpl VALUES ("LK6_2","072_6_2","LUK","6","2","2","Ma te haka anu kogaa i na Pharisee o hai atu kinai, “ 'Eaa e hai ai e koutou na hai 'anga he'e tuku ke hai i te 'Ao oki oki?” ");
INSERT INTO mnv_vpl VALUES ("LK6_3","072_6_3","LUK","6","3","3","Ma te haka tau a Jesus kia te kigatou o hai atu, “ 'Ai e he'e haka sahe e koutou nia noko hai e David i te gholoba noko he ongea 'aki ai ma ona pegea? ");
INSERT INTO mnv_vpl VALUES ("LK6_4","072_6_4","LUK","6","4","4","Ko David noko hano o ugu ki te hage o te 'Aitu, o to'o iho ai eia na utunga tapu o kai na me'a noko manga 'aonga te kai soko e na priest. Kae 'abange ma'u eia kogaa ki ona pegea o kai.” ");
INSERT INTO mnv_vpl VALUES ("LK6_5","072_6_5","LUK","6","5","5","Ma te hai atu a Jesus kia te kigatou, “Te Hosa o Pegea te Hakahua o te 'Ao oki oki.” ");
INSERT INTO mnv_vpl VALUES ("LK6_6","072_6_6","LUK","6","6","6","Nimaa tegaa tasi 'Ao oki oki, ko Jesus noko hano o ugu ki te Hage hai paaunga o ako ai, ka noko iai te launatasi tangata pikipiki te gima maui. ");
INSERT INTO mnv_vpl VALUES ("LK6_7","072_6_7","LUK","6","7","7","Na Pharisee ma na ako o na tagangonga noko ligo e kigatou he hai 'anga ke haka makau ai kia te Ia, ma te mata haka hitaiaki ia te Ia po ka haka ma'ugi e Ia te pegea i te 'Ao oki oki. ");
INSERT INTO mnv_vpl VALUES ("LK6_8","072_6_8","LUK","6","8","8","Ka ko Jesus noko na'a e Ia agatou tegeu'a, ma te hai atu ki te pegea noko piki piki te gima, “Tu'u ake o a'u o tu'u i 'ago i te 'apitanga.” Ma te tu'u te tangata o hano o tu'u i te kungaa. ");
INSERT INTO mnv_vpl VALUES ("LK6_9","072_6_9","LUK","6","9","9","Ma te hai atu a Jesus kia te kigatou, “Ko Au e hai kau hakaanu kia te koutou, niaa te tuku ke hai i te 'Ao oki oki, ke hai ai ni hai 'anga gaoi, po ke hai ai ni hai 'anga maase'i. E hai ke haka ma'ugi pegea ai, poe hai ke taa pegea ai?” ");
INSERT INTO mnv_vpl VALUES ("LK6_10","072_6_10","LUK","6","10","10","Ma te he keukeu 'aki a Jesus ia te kigatou ngatahi, kae hai atu ki te tangata, “Hohoga atu tou gima.” Ma te hai e te tangata, ma te gaoi hoki te gima. ");
INSERT INTO mnv_vpl VALUES ("LK6_11","072_6_11","LUK","6","11","11","Ka na Pharisee ma na ako ona tagangonga na hu'ai he 'ika'ika 'aki ai ma te haka tu'u puge po nia e hai kigatou hai 'ia kia Jesus. ");
INSERT INTO mnv_vpl VALUES ("LK6_12","072_6_12","LUK","6","12","12","Na 'aso na, noko haka neke ai a Jesus ki te ogo ke taakunga ai. Noko noho ai i te poo o noko manga taakunga ai kia te 'Aitu. ");
INSERT INTO mnv_vpl VALUES ("LK6_13","072_6_13","LUK","6","13","13","Nimaa te mahoata, kae haka pogo e Jesus ona pegea haka ako o boomai kia te Ia o haka pau ai te tino anga hugu tuma'a e gua ia te kigatou o mate ia te kigatou na pegea haka to'o. ");
INSERT INTO mnv_vpl VALUES ("LK6_14","072_6_14","LUK","6","14","14","Konei ogatou ingoa: Ko Simon, noko mate ma'u e Ia tena ingoa ko Peter, ma te taina ia Andrew, ma James, ma John, ma Philip, ma Bartholomew, ");
INSERT INTO mnv_vpl VALUES ("LK6_15","072_6_15","LUK","6","15","15","ma Matthew, ma Thomas, ma James te hosa o Alphaeus, ma Simon te ‘zealot’, ");
INSERT INTO mnv_vpl VALUES ("LK6_16","072_6_16","LUK","6","16","16","ma Judas te hosa o James, ma Judas Iscariot te pegea noko hai ke go haka soko ia Jesus. ");
INSERT INTO mnv_vpl VALUES ("LK6_17","072_6_17","LUK","6","17","17","Ko Jesus noko iho tata'o ia te kigatou o tu'u i te kunga tokatoka gaoi. Te hu'ai tu'uganga i ona pegea haka ako noko i te kungaa, ma ba'i pegea taki boo mai i ba'i kunga i Judea, ma Jerusalem, ma te tukutai o Tyre ma Sidon. ");
INSERT INTO mnv_vpl VALUES ("LK6_18","072_6_18","LUK","6","18","18","Ko kigatou noko boomai ke haka gongo kia Jesus, ma te ke haka ma'ugi i ogatou masaki. Na pegea noko iai na haagiki songo na hai o gaoi, ");
INSERT INTO mnv_vpl VALUES ("LK6_19","072_6_19","LUK","6","19","19","ko ba'i pegea noko he gotu 'aki ke he 'osohi kia Jesus, iteme'agaa na taganga noko sosopo mai ia te Ia o haka ma'ugi ia te kigatou ngatahi. ");
INSERT INTO mnv_vpl VALUES ("LK6_20","072_6_20","LUK","6","20","20","Ko Jesus noko ina 'atu ki ona pegea haka ako ma te hai atu kinai, “Te haka gaoinga kia te koutou e lae, iteme'agaa koutou na pegea o te Hakahua 'anga a te 'Aitu. ");
INSERT INTO mnv_vpl VALUES ("LK6_21","072_6_21","LUK","6","21","21","Te haka gaoinga kia te koutou manga he ongea 'aki, iteme'agaa koutou e hai ke go makokona. Te haka gaoinga kia te koutou e magegepe i na 'aso nei, iteme'agaa koutou e hai ke go kakata. ");
INSERT INTO mnv_vpl VALUES ("LK6_22","072_6_22","LUK","6","22","22","Te haka gaoinga kia te koutou i na 'aso gotoa'a ai a pegea kia te koutou, ma te he ngaatutu'a 'aki kia te koutou, ma te baa songo ia te koutou, ma te hegeu songo ai kia te koutou, i te ghaghi i te Hosa o Pegea. ");
INSERT INTO mnv_vpl VALUES ("LK6_23","072_6_23","LUK","6","23","23","'Ogo noko sisia atu i na 'aso na ma te noko magagaohie, iteme'agaa e hua'eha te ga'unga a 'autou i te gangi. Noko manga konaa na hai ogatou tupuna ki na taauga. ");
INSERT INTO mnv_vpl VALUES ("LK6_24","072_6_24","LUK","6","24","24","Kae haka 'aagoha koutou na pegea ga'u, iteme'agaa kua 'oti i te ga'u e koutou te haka magaohie. ");
INSERT INTO mnv_vpl VALUES ("LK6_25","072_6_25","LUK","6","25","25","Haka 'aagoha koutou manga kai gaoi i na 'aso nei, iteme'agaa koutou e hai ke go he ongea 'aki. Haka 'aagoha 'aki a koutou manga kakata i na 'aso nei, iteme'agaa koutou kago noko magegepe ma te tatangi. ");
INSERT INTO mnv_vpl VALUES ("LK6_26","072_6_26","LUK","6","26","26","Haka 'aagoha koutou i na 'aso hegeu gaoi ai a pegea kia te koutou, noko manga konaa na hai ogatou tupuna ki na taauga gogoi. ");
INSERT INTO mnv_vpl VALUES ("LK6_27","072_6_27","LUK","6","27","27","“Ka ko Au e hai atu kia te koutou manga haka gongo mai kia te Au: Ma'ine atu ki outou makau, ma te hai hai 'anga gaoi atu ki na pegea manga gotoa'a kia te koutou. ");
INSERT INTO mnv_vpl VALUES ("LK6_28","072_6_28","LUK","6","28","28","Haka gaoi atu na pegea manga tongi ia te koutou, ma te taakunga atu i na pegea manga he'e kumu ia te koutou. ");
INSERT INTO mnv_vpl VALUES ("LK6_29","072_6_29","LUK","6","29","29","Nimaa iai he pegea e paa eia tou kagahau, anga atu ma'u kinai tegaa pa'asi. Nimaa iai he pegea e to'o eia te ake o'ou, noka te susugi ia te ia i te poi to'o ma'u eia tou ake maatogu ");
INSERT INTO mnv_vpl VALUES ("LK6_30","072_6_30","LUK","6","30","30","Haiga'a atu ki ba'i pegea haka ene 'aki kia te koe, ka nimaa iai he pegea e to'o ma'au he me'a, noka tau haka ene hoki ai. ");
INSERT INTO mnv_vpl VALUES ("LK6_31","072_6_31","LUK","6","31","31","Hai atu e koutou ni hai 'anga ki gaa pegea ke papata ki autou siahahai 'anga kia te kigatou, ke hai ni hai 'anga kia te koutou. ");
INSERT INTO mnv_vpl VALUES ("LK6_32","072_6_32","LUK","6","32","32","“Nimaa maa'ine koutou ki na pegea manga maa'ine kia te koutou, tehea te haka gaoinga ka ga'u ai e koutou? Manga konaa na hai ma'u na pegea 'oosongo te maa'ine ki na pegea maa'ine kia te kigatou. ");
INSERT INTO mnv_vpl VALUES ("LK6_33","072_6_33","LUK","6","33","33","Ka poi manga hai hai 'anga gaoi koutou ki na pegea manga hai hai 'anga gaoi kia te koutou, e hai ke kohea na ga'u e koutou ni hakagaoinga? Na pegea 'oosongo manga konaa agatou hai ma'u. ");
INSERT INTO mnv_vpl VALUES ("LK6_34","072_6_34","LUK","6","34","34","Ka nimaa manga haiga'a me'a koutou ki na pegea, manga tegeu'a ake koutou ke go tau'i haka hoki kia te koutou, e hai ke go kohea na ga'u ai e koutou he hakagaoi? Na pegea 'oosongo manga haiga'a me'a ma'u ki gaa pegea 'oosongo, kae tegeu'a ake ke go tau'i haka hoki ngatahi. ");
INSERT INTO mnv_vpl VALUES ("LK6_35","072_6_35","LUK","6","35","35","Ka koutou maa'ine atu ki outou makau, ma te hai me'a gaoi atu kia te kigatou, ma te manga muna o 'abatu ma'agatou ni me'a, kae noka tautou hakasano ke go giu'aki kia te koutou, ka ke go hua'e'eha ai autou ga'unga, ka ke go hai ma'u ai ni tamagiki ma'a te 'Aitu Hu'ai Ma'u 'agunga ia te koutou, iteme'agaa ko Ia e 'agoha ma'u i na pegea he'e tagamagie, ma na pegea hai hai 'anga songo. ");
INSERT INTO mnv_vpl VALUES ("LK6_36","072_6_36","LUK","6","36","36","Koutou 'agogoha atu, ke noho pe te Tamana o'outou e 'agoha. ");
INSERT INTO mnv_vpl VALUES ("LK6_37","072_6_37","LUK","6","37","37","“Noka te haka aba kogaa pegea, ka ke go noka te haka aba ia te koutou. Noka te haka makau kogaa pegea, ka ke go noka te haka makau ia te koutou. Haka noka hai 'anga atu ki gaa pegea ka ke go haka noka hai 'anga ma'u kia te koutou. ");
INSERT INTO mnv_vpl VALUES ("LK6_38","072_6_38","LUK","6","38","38","Haiga'a atu, ka ke go sui o haiga'a kia te koutou. E hai ke go 'abatu ke 'eha kia te koutou, ke noho pe te kete e tape o ta'ota'o ma te o'i o'i, ka ke 'eha aano honu o magingi ai ni me'a. E konaa na noho te haiga'a 'anga kia te koutou. Ka te potaha o nia kago hai e koutou, e hai ke go konaa na hai haka papata ma'u kia te koutou.” ");
INSERT INTO mnv_vpl VALUES ("LK6_39","072_6_39","LUK","6","39","39","Ko Jesus noko 'atigongo ma'u kia te kigatou i te haka gaataki nei, “ 'Ai manga 'aonga te hutiaki e he pegea kibi he pegea kibi? 'Ai ko kigaaua ngatahi kago he'e hetoki ki he pupu'a?! ");
INSERT INTO mnv_vpl VALUES ("LK6_40","072_6_40","LUK","6","40","40","Te pegea haka ako e he'e sigi i tena ako, ka nimaa iai he pegea haka ako gaoi, koia e hai ke go noho pe tena ako. ");
INSERT INTO mnv_vpl VALUES ("LK6_41","072_6_41","LUK","6","41","41","“ 'Eaa manga ina ai koe ki te mi'i momo pebu e i-te mata o te taiu, ka manga haka tausu'u ake ai koe ki te potu ga'akau i tou mata? ");
INSERT INTO mnv_vpl VALUES ("LK6_42","072_6_42","LUK","6","42","42","'Eaa e konei na to'o ai koe kia te taiu, ‘Taina, tuku mai kau sa'u iho 'ia te mi'i momo pebu i tou mata na,’ ka te manga he'e ina koe ki te potu ga'akau i tou mata?! Ko koe te pegea haka tomu'a. Mataa sa'u iho te potu ga'akau i tou mata, ka ke ina gaoi koe o sa'u iho te mi'i momo pebu i te mata o te taiu. ");
INSERT INTO mnv_vpl VALUES ("LK6_43","072_6_43","LUK","6","43","43","“E si'ai he ga'akau gaoi ke hai mo'ona ni hua maase'i, kae si'ai ma'u he ga'akau maase'i ke hai mo'ona ni hua gaoi. ");
INSERT INTO mnv_vpl VALUES ("LK6_44","072_6_44","LUK","6","44","44","Ko ba'i ga'akau manga taki na'a i ona hua. Ko pegea ka he'e haki e kigatou ni hua mo'o te ga'akau e mate te ‘fig’ i ni kaubago hotohoto i mouku, po ni hua ga'akau hai waeni i he ga'akau maase'i i mouku. ");
INSERT INTO mnv_vpl VALUES ("LK6_45","072_6_45","LUK","6","45","45","Te pegea gaoi e sosopo mai ai na me'a gaoi i na me'a gaoi manga noho i te uso o 'ona, ka te pegea maase'i manga sosopo mai ai na me'a maase'i manga noho i te uso o'ona. Ka te ngutu e gea i na me'a manga honu i te uso o'ona. ");
INSERT INTO mnv_vpl VALUES ("LK6_46","072_6_46","LUK","6","46","46","“ 'Eaa e mate ai e koutou ia te Au o hai mai: ‘Hakahua, Hakahua,’ ka manga he'e hai ai e koutou nia e gea ai Au? ");
INSERT INTO mnv_vpl VALUES ("LK6_47","072_6_47","LUK","6","47","47","E hai kau haka 'agi 'ia kia te koutou na noho o na pegea boomai kia te Au o haka gongo i aku haka hegeunga o hai e kigatou. ");
INSERT INTO mnv_vpl VALUES ("LK6_48","072_6_48","LUK","6","48","48","Ko kigatou manga noho pe te pegea haka tu'u tena hage. Koia noko mataa kegi na gua ki na pou o popoko, 'io mugi o haka tu'u te hage i te ogo hatu. Te 'aso na kake ake ai te honunga o guti ki te hage, ka noko he'e 'aonga te ngatugu, iteme'agaa noko gaoi tena haka tu'u 'anga. ");
INSERT INTO mnv_vpl VALUES ("LK6_49","072_6_49","LUK","6","49","49","Ka te pegea e haka gongo ki aku haka hegeunga, kae he'e hai eia, manga noho pe te pegea noko haka tu'u tena hage i te kege, ka he'e tau haka tu'u sanga. Te gholoba e kake ai te honunga o guti kinai, ma te too te hage, o pau o maseuseu.” ");
INSERT INTO mnv_vpl VALUES ("LK7_1","072_7_1","LUK","7","1","1","Nimaa 'oti i te gea a Jesus i ba'i hai 'anga nei ki te 'apitanga noko ma hakagongo kia te Ia, kae hano ki Capernaum. ");
INSERT INTO mnv_vpl VALUES ("LK7_2","072_7_2","LUK","7","2","2","Te kunga na noko iai te launatasi guani o te tugi tau'a noko hu'ai ma'ine kinai tena hakahua, ka na masaki o hitaiaki ke mate. ");
INSERT INTO mnv_vpl VALUES ("LK7_3","072_7_3","LUK","7","3","3","Te tugi tau'a na gongo ia Jesus ma te tuku eia kogaa i na 'agiki o na Jew o boo kia te Ia, o he haka ene 'aki kinai ke a'u a Jesus o haka ma'ugi tena guani. ");
INSERT INTO mnv_vpl VALUES ("LK7_4","072_7_4","LUK","7","4","4","Te gholoba noko boomai ai kigatou kia Jesus, ko kigatou noko hu'ai he sasaka 'aki kia te Ia o hai atu kinai, “Te pegea nei e hu'ai maa'ogi ke 'aabaki kinai Koe, ");
INSERT INTO mnv_vpl VALUES ("LK7_5","072_7_5","LUK","7","5","5","iteme'agaa koia e hu'ai ma'ine ki tematou kakai 'anga nei, ma te haka tu'u ma'u eia tematou Hage hai paaunga.” ");
INSERT INTO mnv_vpl VALUES ("LK7_6","072_7_6","LUK","7","6","6","Ma te tata'o a Jesus ia te kigatou. Ko Ia noko hitaiaki ki te hage, kae manga kaunaki e te tugi tau'a ana hemasi'inga o boo kia Jesus o hai atu kinai, “Hakahua, noka tau maikia mai kinai, na'e he'e 'aonga te hai atu au ke a'u Koe ki goto i toku hage nei. ");
INSERT INTO mnv_vpl VALUES ("LK7_7","072_7_7","LUK","7","7","7","Tenei te hai 'anga e maanatu ake ai au e he'e 'aonga taku hinatu kia te Koe, ka manga gea mai kinai i he kupu, ka ke ma'ugi toku guani. ");
INSERT INTO mnv_vpl VALUES ("LK7_8","072_7_8","LUK","7","8","8","Iteme'agaa ko au ma'u te pegea hakahua e pegea, kae sui au o hakahua eau kogaa pegea hai tau'a. Nimaa hai atu au ki tenei: ‘Hinatu!’ koia ka hano. Nimaa hai atu ma'u au ki tegaa, ‘A'u!’ koia ka a'u. Nimaa kaunaki eau toku guani o hai atu kinai, ‘Hai atu te hai 'anga na!’ ka maa'ogi ia o hai.” ");
INSERT INTO mnv_vpl VALUES ("LK7_9","072_7_9","LUK","7","9","9","Nimaa haka gongo a Jesus ki te hai 'anga nei, ko Ia noko gege ma'ugi ai ma te keu iho ki te 'apitanga noko tata'o ia te Ia o hai atu kinai, “Ko Au e hai atu kia te koutou, e he'e kite e Au he pegea ke konei na sano i Israel.” ");
INSERT INTO mnv_vpl VALUES ("LK7_10","072_7_10","LUK","7","10","10","Nimaa giu na pegea noko kaunaki o boo kia Jesus o hetae atu ki te hage o kite e kigatou te guani kua ma'ugi. ");
INSERT INTO mnv_vpl VALUES ("LK7_11","072_7_11","LUK","7","11","11","Noko he'e taunga gogoa, kae ghali a Jesus o hano ki te manaha e mate tena ingoa ko Nain. Ona pegea haka ako ma te hu'ai tu'uganga noko tata'o ia te Ia. ");
INSERT INTO mnv_vpl VALUES ("LK7_12","072_7_12","LUK","7","12","12","Nimaa hitaiaki Ia ke hetae ki te aga ki goto i te manaha, te pegea e mate e 'amo iho ki taha. Koia te tama e tasi a te tinana, ka koia te hahine magepe. Noko hu'ai 'api pegea i te manaha noko manga haka pata kia te ia. ");
INSERT INTO mnv_vpl VALUES ("LK7_13","072_7_13","LUK","7","13","13","Te gholoba noko ina 'atu ai te Hakahua ki te hahine, te uso o'ona noko hu'ai 'agoha kinai ma te hai atu kinai, “Noka te tangi.” ");
INSERT INTO mnv_vpl VALUES ("LK7_14","072_7_14","LUK","7","14","14","Kae hano a Jesus o 'oso ki te peenanga o te pegea mate, ma te tutu'u haka ma'u na pegea noko 'amo e kigatou, kae hai atu a Jesus, “Tama, ko Au e hai atu kia te koe: 'Aga ake!” ");
INSERT INTO mnv_vpl VALUES ("LK7_15","072_7_15","LUK","7","15","15","Te pegea na mate noko 'aga o noho o noko manga haka hegeu, ma te a'u a Jesus o 'abange haka hoki kia te tinana. ");
INSERT INTO mnv_vpl VALUES ("LK7_16","072_7_16","LUK","7","16","16","Ko ba'i pegea noko hu'ai he gege ma'ugi 'aki o haka e'eha e kigatou ia te 'Aitu, o kogaa agatou to'o, “Te hu'ai taauga kua haka 'agitino i 'ago ia te kitatou.” Ma te kogaa agatou to'o ma'u, “Ko te 'Aitu kua a'u ke 'aabaki ki ona pegea.” ");
INSERT INTO mnv_vpl VALUES ("LK7_17","072_7_17","LUK","7","17","17","Te gongo o Jesus na mahoga i ba'i kunga i Judea, ma ba'i kunga henua noho mugheghi. ");
INSERT INTO mnv_vpl VALUES ("LK7_18","072_7_18","LUK","7","18","18","Na pegea haka ako o John noko 'atigongo kia te ia i te ta'u hai 'anga nei, ma te ngege atu a John i te toka gua i ona pegea haka ako, o boomai kia te ia, ");
INSERT INTO mnv_vpl VALUES ("LK7_19","072_7_19","LUK","7","19","19","ma te haka to'o eia o boo kia te Hakahua ke haka anuanu kinai, “Tenaa Koe manga mata ai ke a'u, po ko kimatou manga koi hitagi i he pegea 'aatea?” ");
INSERT INTO mnv_vpl VALUES ("LK7_20","072_7_20","LUK","7","20","20","Nimaa boomai gua pegea kia Jesus, o hai atu kinai, “Ko John e haka to'o mai eia ia te kimaaua o boomai kimaaua haka anu kia te Koe, po tenaa Koe manga mata ai ke a'u, po ko kimatou koi hitagi i he pegea 'aatea?” ");
INSERT INTO mnv_vpl VALUES ("LK7_21","072_7_21","LUK","7","21","21","Te gholoba na, ko Jesus noko manga haka ma'ugi ai e Ia ba'i pegea masasaki i ba'i sa'o saga mou hage, ma te pagepage e Ia na haagiki songo, ma te lugaluga e Ia na mata o na pegea kikibi. ");
INSERT INTO mnv_vpl VALUES ("LK7_22","072_7_22","LUK","7","22","22","Nimaa haka tau a Jesus ki gua pegea noko haka to'o mai e John o boomai, o hai atu kinai, “Giu atu o hogahoga kia John i nia kua hiina'i kinai kougua ma te haka gongo kinai: Na pegea kikibi kua hiina'i, na pegea seu kua lango, na pegea kahoa kua mahu, na pegea tugi kua haka gongo, na pegea mamate kua maa'ugi giu, ma te Gongo Gaoi kua tohi'aki ai ki na pegea lae. ");
INSERT INTO mnv_vpl VALUES ("LK7_23","072_7_23","LUK","7","23","23","Haka gaoi ki te pegea e he'e tootoo baasi'a ia te Au.” ");
INSERT INTO mnv_vpl VALUES ("LK7_24","072_7_24","LUK","7","24","24","Nimaa 'oti i te giu gua pegea o John, kae haka tu'u te haka hegeu a Jesus ki te 'apitanga i na noho o John, o hai atu kinai, “Niaa te boo koutou ki te tugatea ke hiina'i kinai? Te kaso hatu e pusi e te oko o maloku? ");
INSERT INTO mnv_vpl VALUES ("LK7_25","072_7_25","LUK","7","25","25","Nimaa si'ai, 'ai niaa te noko boo koutou ke hiina'i kinai? Te tangata e haka gosigosi i na ake hu'ai maatanga gaoi? Si'ai, na pegea e haka gosigosi i na ake hu'ai maatanga gaoi i te ga'u me'a haka saga ka manga kite ai i na hage o na hakahua ga'u. ");
INSERT INTO mnv_vpl VALUES ("LK7_26","072_7_26","LUK","7","26","26","Ka niaa te noko boo koutou ke hiina'i kinai? Te taauga? E maa'ogi, e hai atu Au kia te koutou, koia e sigi i na taauga. ");
INSERT INTO mnv_vpl VALUES ("LK7_27","072_7_27","LUK","7","27","27","Tenei te pegea noko 'atigongo ai na Kanukanu Tapu o hai ake, ‘E hai ke go haka to'o mai toku pegea to'o gongo ke go mu'a ia te Koe, ke go haka ngaague eia te aga kia te Koe.’ ");
INSERT INTO mnv_vpl VALUES ("LK7_28","072_7_28","LUK","7","28","28","Ko Au e hai atu kia te koutou, ko John e hu'ai hua'eha o sigi i ba'i pegea sosopo i te kege nei, ka he pegea e hua'iti'iti i te Hakahua 'anga a te 'Aitu, koia e hu'ai hua'eha o sigi ia John.” ");
INSERT INTO mnv_vpl VALUES ("LK7_29","072_7_29","LUK","7","29","29","Ko ba'i pegea, ma na pegea tibu takis ma'u noko haka gongo ki na gea 'anga a Jesus, ma te na'a ai e kigatou na paaunga a te 'Aitu e hu'ai gaoi, iteme'agaa ko kigatou na 'oti i te haa gogomi e John. ");
INSERT INTO mnv_vpl VALUES ("LK7_30","072_7_30","LUK","7","30","30","Ka na Pharisee ma na ako o na tagangonga noko he'e siahahai ki na gaataki a te 'Aitu kia te kigatou, iteme'agaa na he'e haa gogomi e John. ");
INSERT INTO mnv_vpl VALUES ("LK7_31","072_7_31","LUK","7","31","31","Ko Jesus noko konei na gea ma'u, “E hai kau kohea na haka papata 'ia na pegea o te 'atu tangata nei? E kohea na noho a kigatou? ");
INSERT INTO mnv_vpl VALUES ("LK7_32","072_7_32","LUK","7","32","32","Ko kigatou manga noho pe na tama giki manga noho 'aki i te kunga he tau'i 'aki me'a o noko manga he ngengege 'aki kia te kigatou: ‘Ko kimatou e pusi kohe kia te koutou, ka he'e tau'aso kinai koutou! Ko kimatou e taugua i na taugua haka 'aagoha, ka he'e tatangi ai koutou.’ ");
INSERT INTO mnv_vpl VALUES ("LK7_33","072_7_33","LUK","7","33","33","Ko John Baptist noko a'u o he'e kai utunga o he'e binu ini waeni, ma te hai ake koutou, ‘Koia e iai te 'atua.’ ");
INSERT INTO mnv_vpl VALUES ("LK7_34","072_7_34","LUK","7","34","34","Nimaa a'u te Hosa o Pegea o kai ma te binu, ma te hai ake koutou, ‘Ko Ia te pegea sia kai ma te sia binu waeni, ka ko Ia ma'u te hemasi'inga ana pegea tibu takis ma gaa pegea 'oosongo.’ ");
INSERT INTO mnv_vpl VALUES ("LK7_35","072_7_35","LUK","7","35","35","Na pegea kua ga'u e kigatou te 'igo'igo o te 'Aitu, e haka 'agi e kigatou e maa'ogi.” ");
INSERT INTO mnv_vpl VALUES ("LK7_36","072_7_36","LUK","7","36","36","Te launatasi i na Pharisee noko haka pogo eia ia Jesus ke kai haka pigi kia te ia, ma te hano Ia o ugu ki te hage o te Pharisee o noho ki te kunga kai. ");
INSERT INTO mnv_vpl VALUES ("LK7_37","072_7_37","LUK","7","37","37","Nimaa na'a e te hahine 'oosongo noko i te manaha, ko Jesus manga kai i te hage o te Pharisee, ma te to'o mai eia te mi'i poati, tena ingoa te alabasta, noko iai te bai hu'ai tutuu gaoi. ");
INSERT INTO mnv_vpl VALUES ("LK7_38","072_7_38","LUK","7","38","38","Koia noko tu'u mai tu'a ia Jesus o pata i na ba'e, o noko manga tangi ma te basuu eia na ba'e o Jesus i na go'imata o'ona, ma te sogosogo eia i na gau 'ugu o'ona, ma te sosongi i na ba'e kae gigingi kinai eia te bai tutuu gaoi. ");
INSERT INTO mnv_vpl VALUES ("LK7_39","072_7_39","LUK","7","39","39","Te gholoba na ina 'atu ai te Pharisee noko haka pogo eia ia Jesus ki te hai 'anga nei, koia noko konei ana tegeu'a ake, “Te pegea nei poi te taauga, manga 'aonga te na'a e Ia po te hahine aa te 'oso kia te Ia, ma te na'a ma'u e Ia koia te hahine 'oosongo ina.” ");
INSERT INTO mnv_vpl VALUES ("LK7_40","072_7_40","LUK","7","40","40","Ma te haka tau a Jesus o hai atu kia te ia, “Simon, ko Au e siahai kau gea kia te koe i te hai 'anga.” Ma te haka tau a Simon o hai atu kinai, “Ako, 'atigongo mai kia te au.” ");
INSERT INTO mnv_vpl VALUES ("LK7_41","072_7_41","LUK","7","41","41","Ma te hai atu a Jesus, “Te toka gua pegea noko to'o agaa mane ka ke go sui ki te pegea haiga'a mane. Noko to'o e tegaa te gimanga gau (500) mane, kae to'o e tegaa te katoa haka gima (50) mane. ");
INSERT INTO mnv_vpl VALUES ("LK7_42","072_7_42","LUK","7","42","42","Ka na si'ai he pegea ia te kigaaua ke hai he mane ke tau'i haka hoki ai kia te ia, ma te manga haka noka eia kia te kigaaua ngatahi. Koai gaa ia te kigaaua te noko hu'ai ma'ine kinai?” ");
INSERT INTO mnv_vpl VALUES ("LK7_43","072_7_43","LUK","7","43","43","Ma te haka tau a Simon o hai atu, “Koau e kogaa aku tegeu'a, te pegea e to'o mane o 'eha ka kua manga haka noka kinai.” Hai atu kinai a Jesus, “Tau haka tau mai 'anga na e hu'ai gaoi.” ");
INSERT INTO mnv_vpl VALUES ("LK7_44","072_7_44","LUK","7","44","44","Ma te keu atu a Jesus ki te hahine kae hai atu kia Simon, “Ko koe e ina mai ki te hahine nei? Taku a'u 'anga ki tou hage nei, ko koe e he'e 'aumai e koe he bai ke huhu'i ai oku ba'e, ka te hahine nei e huhu'i eia oku ba'e i na go'imata o'ona, ma te sogosogo i na gau 'ugu o'ona. ");
INSERT INTO mnv_vpl VALUES ("LK7_45","072_7_45","LUK","7","45","45","Ko koe e he'e sosongi ia te Au, ka te hahine nei e haka tu'u i te gholoba e ugu mai ai Au ki te hage nei, koia e he'e 'oti tena sosongi i oku tapungao. ");
INSERT INTO mnv_vpl VALUES ("LK7_46","072_7_46","LUK","7","46","46","Ko koe e he'e gigingi e koe he bai tutuu gaoi ki toku 'ugu, ka te hahine nei kua gigingi eia te bai tutuu gaoi ki oku ba'e. ");
INSERT INTO mnv_vpl VALUES ("LK7_47","072_7_47","LUK","7","47","47","Tenei te hai 'anga e hai atu ai Au kia te koe: Na 'oosongo o te hahine nei e hu'ai 'eha, ka kua haka noka kinai, tenei te hai 'anga e hua'eha ai tena ma'ine. Ka koai e he'e hu'ai haka noka hai 'anga kinai, e hai ke hua'iti'iti ma'u te ma'ine o'ona.” ");
INSERT INTO mnv_vpl VALUES ("LK7_48","072_7_48","LUK","7","48","48","Ma te hai atu a Jesus ki te hahine, “Ou 'oosongo kua haka noka.” ");
INSERT INTO mnv_vpl VALUES ("LK7_49","072_7_49","LUK","7","49","49","Kogaa i na pegea noko haka pata kia te Ia, noko kogaa agatou to'o, “ 'Ai koai tenei te 'aonga te haka noka na 'oosongo ma'u?!” ");
INSERT INTO mnv_vpl VALUES ("LK7_50","072_7_50","LUK","7","50","50","Ko Jesus noko hai atu ki te hahine, “Te sano o'ou te haka ma'ugi ia te koe; hinatu ma te goto maagie.” ");
INSERT INTO mnv_vpl VALUES ("LK8_1","072_8_1","LUK","8","1","1","Nimaa mugi mai kogaa gholoba, ko Jesus noko hano ki na hu'ai manaha ma na mi'i manaha o noko manga tohi'aki ai i te Gongo Gaoi o te Hakahua 'anga a te 'Aitu. Te tino anga hugu tuma'a e gua pegea haka ako noko manga he tata'o 'aki ia te Ia. ");
INSERT INTO mnv_vpl VALUES ("LK8_2","072_8_2","LUK","8","2","2","Ka noko iai ma'u na haahine noko hakagaoi e Jesus i na haagiki songo ma na sa'o saga: Ko Mary noko mate tena ingoa ko Mary mai Magdala, te pegea noko boo 'aatea ai te toka hitu haagiki songo, ");
INSERT INTO mnv_vpl VALUES ("LK8_3","072_8_3","LUK","8","3","3","ma Joanna, te uguugu o Chuza, te pegea noko hakahua i na me'a a Herod, ma Susanna, ma gaa pegea ma'u. Na haahine nei noko hai agatou me'a o 'aabaki ai kia Jesus ma ona pegea haka ako. ");
INSERT INTO mnv_vpl VALUES ("LK8_4","072_8_4","LUK","8","4","4","Noko hu'ai 'api pegea noko taki boomai i ba'i manaha kia Jesus, ma te 'atigongo kinai a Ia i te haka gaataki nei: ");
INSERT INTO mnv_vpl VALUES ("LK8_5","072_8_5","LUK","8","5","5","“Te launatasi pegea sanga noko hano ke sanga ana hatu me'a. Nimaa lago ana hatu me'aa, noko hetoki kogaa ki na taha ba'e aga o takataka, kae boomai na manu he gegei o te gangi o kai e kigatou. ");
INSERT INTO mnv_vpl VALUES ("LK8_6","072_8_6","LUK","8","6","6","Noko iai kogaa hatu me'a noko hetoki ki te kunga ngaoa'a. Nimaa malubu ake, ghali o pakupaku, iteme'agaa e he'e tau bai ke haka ngasogo eia. ");
INSERT INTO mnv_vpl VALUES ("LK8_7","072_8_7","LUK","8","7","7","Noko iai kogaa hatu me'a noko hetoki ki te kunga kaubago hotohoto ina. Nimaa malubu o ngaasogo ngatahi ake, ma te baa magu 'ia e gaa ga'akau na me'a noko baa seu o mamate. ");
INSERT INTO mnv_vpl VALUES ("LK8_8","072_8_8","LUK","8","8","8","Noko iai kogaa hatu me'a noko hetoki ki te kunga kege gaoi, noko ngasogo ake o hai ona hua, noko taki hua te hua me'a e tasi.” Te gholoba noko 'oti i te konei ana gea ai, kae hai atu kia te kigatou, “Koai e hai na taginga ke hakagongo, haka gongo ake ai!” ");
INSERT INTO mnv_vpl VALUES ("LK8_9","072_8_9","LUK","8","9","9","Na pegea haka ako noko haka anuanu kia Jesus o hai atu, “Tehea te gaataki o te haka gaataki nei?” ");
INSERT INTO mnv_vpl VALUES ("LK8_10","072_8_10","LUK","8","10","10","Ka ko Jesus noko haka tau kia te kigatou o hai atu, “Te naa 'anga o na hai 'anga ngigo o te Hakahua 'anga a te 'Aitu, kua 'oti i te haiga'a kia te koutou, ka kogaa pegea e haka hegeu kinai Au i na haka gaataki, ka ke nimaa, ‘si'igoa e hiina'i kinai kigatou, ka ka he'e kite, ma te si'igoa e haka gongo kinai, ka ka he'e 'igohia.’ ");
INSERT INTO mnv_vpl VALUES ("LK8_11","072_8_11","LUK","8","11","11","Tenei te hogahoga 'anga o te haka gaataki: Na hatu me'a manga noho pena haka hegeunga a te 'Aitu. ");
INSERT INTO mnv_vpl VALUES ("LK8_12","072_8_12","LUK","8","12","12","Na me'a noko hetoki ki te taha ba'e agaa, manga noho pena haka hegeunga a te 'Aitu i na uso o na pegea manga haka gongo, kae ghali a Satan o a'u o sa'u 'aatea i na uso ogatou, ka kigatou noka te too kinai ma te maa'ugi ai. ");
INSERT INTO mnv_vpl VALUES ("LK8_13","072_8_13","LUK","8","13","13","Na me'a e hetoki ki te kunga ngaoa'a, manga noho pena haka hegeunga a te 'Aitu i na uso o na pegea ga'u e kigatou na haka hegeunga a te 'Aitu i te mi'i gholoba e haka gongo kinai o magagaohie, kae he'e tau aka. Manga na'a i te mi'i 'aso, ka nimaa hetae mai na 'aso o na pakenga, ko kigatou manga hetoki iho. ");
INSERT INTO mnv_vpl VALUES ("LK8_14","072_8_14","LUK","8","14","14","Na me'a e hetoki ki na kunga kaubago hotohoto ina, manga noho pena haka hegeunga a te 'Aitu i na uso o na pegea e haka gongo kinai, ka manga maikia ki na ga'unga, ma na siahai 'anga ki na me'a o te kege nei e hai ia te kigatou o he'e 'aonga te hai ni hai 'anga gaoi. ");
INSERT INTO mnv_vpl VALUES ("LK8_15","072_8_15","LUK","8","15","15","Ka na hatu me'a e hetoki ki te kunga kege gaoi, manga noho pe na haka hegeunga a te 'Aitu i na uso o na pegea gaoi ma te mangangao o haka gongo kinai o pipiki i na uso ogatou, ma te tuku gago ia te kigatou, ka ke go hai ai e kigatou ni hai 'anga gaoi. ");
INSERT INTO mnv_vpl VALUES ("LK8_16","072_8_16","LUK","8","16","16","“E si'ai he pegea ke tutu eia he peba o tango i he kete, po e tuku ki he gago kaupea, kae hai ke haka tu'u ki te kunga haka eke peba, ka ke hiina'i kinai na pegea e boo ki goto i te hage. ");
INSERT INTO mnv_vpl VALUES ("LK8_17","072_8_17","LUK","8","17","17","Iteme'agaa ko ba'i hai 'anga huu e hai ke go haka 'agi ke hiina'i kinai, ma ba'i hai 'anga ngigo e hai ke go na'a, ma te to'o mai ki te maagama ke hiina'i kinai. ");
INSERT INTO mnv_vpl VALUES ("LK8_18","072_8_18","LUK","8","18","18","Na'a pipiki ake e koutou nia e haka gongo ai koutou, iteme'agaa koai e ga'u eia, e hai ke go haiga'a beegaba kia te ia, ka koai e he'e ga'u eia, e hai ke go sa'u 'aatea ia te ia. Haka gatagoa nia e tegeu'a ake e hai eia, e hai ke go sa'u ia te ia.” ");
INSERT INTO mnv_vpl VALUES ("LK8_19","072_8_19","LUK","8","19","19","Te tinana o Jesus ma na taina o'ona noko boomai kigatou hiina'i kia te Ia, ka na he'e 'aonga tegatou boo o hitaiaki kinai, iteme'agaa noko hu'ai 'api pegea. ");
INSERT INTO mnv_vpl VALUES ("LK8_20","072_8_20","LUK","8","20","20","Noko iai na pegea noko 'atigongo ai kia Jesus o hai atu kinai, “Ko te tinau ma na taina o'ou manga tutu'u i haho e siahahai ke hiina'i kia te Koe.” ");
INSERT INTO mnv_vpl VALUES ("LK8_21","072_8_21","LUK","8","21","21","Ka ko Jesus noko haka tau o hai atu kinai, “Konei oku tinana ma oku taina, na pegea manga haka gongo ki na haka hegeunga a te 'Aitu o hai e kigatou.” ");
INSERT INTO mnv_vpl VALUES ("LK8_22","072_8_22","LUK","8","22","22","Nimaa te launatasi 'ao, ko Jesus noko hai atu ki ona pegea haka ako, “Kitatou boo ki tegaa pa'asi i te gano nei.” Ma te sosopo a kigatou ki te baka o haka 'ui. ");
INSERT INTO mnv_vpl VALUES ("LK8_23","072_8_23","LUK","8","23","23","Nimaa 'ui a kigatou i te baka, kae moe a Jesus. Ma te too te huukenga ki te gano o hai ke mene ai te baka. O hu'ai maikia ai kigatou. ");
INSERT INTO mnv_vpl VALUES ("LK8_24","072_8_24","LUK","8","24","24","Na pegea haka ako noko boomai kia Jesus o baa 'aga e kigatou o hai atu kinai, “Hakahua, ko kitatou ka mamate!” Ma te tu'u ake a Jesus o gea susugi na oko ma te moana noko 'atua, ma te maa'ogi o magino kae ngongoto. ");
INSERT INTO mnv_vpl VALUES ("LK8_25","072_8_25","LUK","8","25","25","Kae hai atu a Jesus ki ona pegea haka ako, “Tehea te sano o 'outou?!” Ko kigatou noko matataku ma te he gege ma'ugi 'aki o kogaa agatou he hakaanu 'aki, “Te pegea aa tenei, te gea ki na oko ma te moana o mangangao kia te Ia?” ");
INSERT INTO mnv_vpl VALUES ("LK8_26","072_8_26","LUK","8","26","26","Ko kigatou noko 'ui o boo ki na kunga henua o na pegea o Gerasa, te kunga i tegaa pa'asi i te gano i Galilee. ");
INSERT INTO mnv_vpl VALUES ("LK8_27","072_8_27","LUK","8","27","27","Te gholoba noko sopo ake ai a Jesus ki te tau ganga, ko Ia noko bilaabei ma te tangata uguhia, te pegea mai te manahaa. Noko hu'ai 'eha 'aso te tangata nei noko he'e mago ai, o he'e kakai ai ini hage, ka koia noko manga kakai i na 'atu takotonga. ");
INSERT INTO mnv_vpl VALUES ("LK8_28","072_8_28","LUK","8","28","28","Nimaa ina 'atu kia Jesus, koia noko pipisi te mate kae too atu ki na ba'e o Jesus, o tangi ngege o hai ake, “Jesus, niaa te hai ke hai e Koe kia te au? Jesus, te Hosa o te 'Aitu e Hu'ai Ma'u 'agunga? Ko au e sasaka kia te Koe, ke noka te hai songo ia te au.” ");
INSERT INTO mnv_vpl VALUES ("LK8_29","072_8_29","LUK","8","29","29","Ka ko Jesus na kaunaki e Ia te haagiki songo ke hano 'aatea i te tangata. Noko 'eha 'aso noko uguhia ai. Masi'igoa noko gii na ba'e ma na gima i na puni hatu'ugi, ma te hai ona pegea ge'o, ka noko manga motumotu eia na puni hatu'ugi kae kakabe e te 'atua ki na kunga gaabaki. ");
INSERT INTO mnv_vpl VALUES ("LK8_30","072_8_30","LUK","8","30","30","Ko Jesus noko haka anu kinai o hai atu, “Tehea tou ingoa?” Ma te haka tau o hai atu, “Toku ingoa ko 'Api To'a.” Koia noko konei ana gea, iteme'agaa noko 'api haagiki songo na he uguhi ia te ia. ");
INSERT INTO mnv_vpl VALUES ("LK8_31","072_8_31","LUK","8","31","31","Kae he sasaka 'aki na haagiki kia Jesus ke noka te kaunaki ia te kigatou ke boo ki te pupu'a he'e ngato. ");
INSERT INTO mnv_vpl VALUES ("LK8_32","072_8_32","LUK","8","32","32","Noko iai te hu'ai tugaa piki noko manga kai i te pa'asi o te ogo. Na haagiki noko he sasaka 'aki kia Jesus ke tuku kigatou boo o he uguhi i na piki, ka na tuku e Ia. ");
INSERT INTO mnv_vpl VALUES ("LK8_33","072_8_33","LUK","8","33","33","Te gholoba na sosopo ai na haagiki songo ki taha i te tangata, ko kigatou na he'agiko o he uguhi i na piki, ma te he 'agiko iho i te pa'asi o te tiha, o 'u'utu ki te gano o memene ai. ");
INSERT INTO mnv_vpl VALUES ("LK8_34","072_8_34","LUK","8","34","34","Nimaa hiina'i kinai na pegea noko ge'o e kigatou na piki ki te hai 'anga na hai, ma te he 'agiko giu o he 'atigongo 'aki ai i te manaha ma na kakai 'anga. ");
INSERT INTO mnv_vpl VALUES ("LK8_35","072_8_35","LUK","8","35","35","Ma te boo te 'apitanga ke hiina'i ki te hai 'anga na hai. Te gholoba noko boo ai kigatou kia Jesus, kigatou na kite i te pegea noko iai na haagiki, kua boo 'aatea ai, ka manga noho haka pata kia Jesus. Koia kua mago, ka kua hai tegeu'a gaoi, ma te matataku ai a kigatou. ");
INSERT INTO mnv_vpl VALUES ("LK8_36","072_8_36","LUK","8","36","36","Na pegea noko hiina'i kinai, noko 'atigongo ai ki te 'apitanga i te tangata noko iai na haagiki kua gaoi. ");
INSERT INTO mnv_vpl VALUES ("LK8_37","072_8_37","LUK","8","37","37","Ma te boomai ko ba'i pegea i te kakai 'anga i Gerasa o haka ene 'aki kia Jesus ke hano 'aatea ia te kigatou, iteme'agaa ko kigatou kua hu'ai matataku. Ma te sopo a Jesus ki te baka o hano. ");
INSERT INTO mnv_vpl VALUES ("LK8_38","072_8_38","LUK","8","38","38","Te tangata noko boo 'aatea ai na haagiki songo, noko haka ene kia Jesus ke tata'o ai, ka na he'e maka a Jesus, manga hai atu kinai, ");
INSERT INTO mnv_vpl VALUES ("LK8_39","072_8_39","LUK","8","39","39","“Hoki atu ki tou manaha o 'atigongo ai i nia kua hai e te 'Aitu kia te koe.” Ma te hoki te tangata o 'atigongo i ba'i hai 'anga kua hai e Jesus kia te ia. ");
INSERT INTO mnv_vpl VALUES ("LK8_40","072_8_40","LUK","8","40","40","Te gholoba noko hoki ai a Jesus ki tegaa pa'asi o te gano, te 'apitanga noko haka pogo ia te Ia, iteme'agaa ko kigatou ngatahi noko ma hitagi ia te Ia. ");
INSERT INTO mnv_vpl VALUES ("LK8_41","072_8_41","LUK","8","41","41","Noko iai te pegea tena ingoa ko Jairus, te hakahua o te Hage hai paaunga, ka noko a'u o too ki na ba'e o Jesus o haka ene kinai ke hano ki tena hage. ");
INSERT INTO mnv_vpl VALUES ("LK8_42","072_8_42","LUK","8","42","42","Iteme'agaa tena tama 'ahine e tasi, te pegea katoa tuma'a e gua ona ghapu, ka manga takoto e hai ke go mate. Ka te hano 'anga a Jesus i te agaa, ko ba'i pegea noko muimui mai kia te Ia. ");
INSERT INTO mnv_vpl VALUES ("LK8_43","072_8_43","LUK","8","43","43","Ka noko iai te launatasi hahine noko manga higosia i te masaki o haahine o katoa tuma'a e gua ona ghapu. Ka noko si'ai he pegea ke hai ia te ia ke gaoi. ");
INSERT INTO mnv_vpl VALUES ("LK8_44","072_8_44","LUK","8","44","44","Te hahine noko 'agu mai tu'a ia Jesus o 'oso ki te kapa o tena ake, ma te ghali te singa 'anga te tino o 'oti. ");
INSERT INTO mnv_vpl VALUES ("LK8_45","072_8_45","LUK","8","45","45","Ma te haka anu a Jesus o hai atu, “Koai te 'oso kia te Au?” Ma te heege'i ngatahi kigatou, kae hai atu kinai a Peter, “Hakahua, e hu'ai 'api to'a te haka putu mai 'anga o muimui kia te Koe!” ");
INSERT INTO mnv_vpl VALUES ("LK8_46","072_8_46","LUK","8","46","46","Ka ko Jesus noko kogaa ana to'o atu, “Kua 'oso te pegea kia te Au. E na'a e Au i te taganga e hano ia te Au.” ");
INSERT INTO mnv_vpl VALUES ("LK8_47","072_8_47","LUK","8","47","47","Ma te kite iho e te hahine te hai 'anga e hai eia kua na'a, ma te a'u popoge, o guti ki na ba'e o Jesus o hogahoga i 'ago i te 'apitanga te hai 'anga e 'oso ai kia Jesus, ma tena ghali 'anga o ma'ugi. ");
INSERT INTO mnv_vpl VALUES ("LK8_48","072_8_48","LUK","8","48","48","Ma te hai atu a Jesus kia te ia, “Ta'ahine, te sano o'ou kua hai ia te koe o soihua. Hinatu ma te goto maagie.” ");
INSERT INTO mnv_vpl VALUES ("LK8_49","072_8_49","LUK","8","49","49","Ko Jesus noko manga koi haka hegeu, kae boomai na pegea i te hage o Jairus, te hakahua o te Hage hai paaunga, o hai atu kia Jairus, “Ko tau tama 'ahine kua mate. Noka te hai ma'u te Ako ke ghaulia ai.” ");
INSERT INTO mnv_vpl VALUES ("LK8_50","072_8_50","LUK","8","50","50","Nimaa haka gongo kinai a Jesus, ma te hai atu kia Jairus, “Noka tau mataku, ka manga too mai, ka ke ma'ugi a tau tama 'ahine.” ");
INSERT INTO mnv_vpl VALUES ("LK8_51","072_8_51","LUK","8","51","51","Te 'aso noko hetae ai a Jesus ki te hage o Jairus, noko he'e tuku e Jesus he pegea ke tata'o ia te Ia, ka manga ko Peter ma John ma James ma te tamana ma te tinana o te tama 'iti'iti. ");
INSERT INTO mnv_vpl VALUES ("LK8_52","072_8_52","LUK","8","52","52","Ko ba'i pegea noko manga tatangi ma te magegepe i te tama 'iti'iti, ka ko Jesus noko hai atu kinai, “Noka tautou magegepe, na'e koia e he'e mate, ka manga moe.” ");
INSERT INTO mnv_vpl VALUES ("LK8_53","072_8_53","LUK","8","53","53","Ko kigatou noko putatai kia Jesus, i te noko na'a e kigatou te tama 'iti'iti kua mate. ");
INSERT INTO mnv_vpl VALUES ("LK8_54","072_8_54","LUK","8","54","54","Ka ko Jesus noko tau i te gima o te tama 'iti'iti kae hai atu kinai, “Ta'ahine, 'aga ake!” ");
INSERT INTO mnv_vpl VALUES ("LK8_55","072_8_55","LUK","8","55","55","Ma te ghali te ma'ugi o te mi'i hahine o hokimai kinai, o 'aga o tu'u, ma te kaunaki e Jesus ia te kigatou ke 'abange ma'ana ni utunga ke kai. ");
INSERT INTO mnv_vpl VALUES ("LK8_56","072_8_56","LUK","8","56","56","Ko ona hai maatu'a noko hu'ai he gege ma'ugi 'aki ai, ka ko Jesus noko hai taagango kia te kigaaua o hai atu, “Noka te hogahoga ki he pegea te hai 'anga e hai nei.” ");
INSERT INTO mnv_vpl VALUES ("LK9_1","072_9_1","LUK","9","1","1","Ko Jesus noko ngege i te tino anga hugu tuma'a e gua pegea haka ako o boo ngatahi mai, kae haiga'a kinai e Ia na taganga ke pagepage ai na haagiki songo ma te ke haka ma'ugi ai na pegea masasaki. ");
INSERT INTO mnv_vpl VALUES ("LK9_2","072_9_2","LUK","9","2","2","Ma te kaunaki e Jesus ia te kigatou ke boo o tohi'aki i te Hakahua 'anga a te 'Aitu, ma te ke haka ma'ugi na pegea masasaki. ");
INSERT INTO mnv_vpl VALUES ("LK9_3","072_9_3","LUK","9","3","3","Ko Jesus noko hai atu kia te kigatou, “Noka te to'o ma'autou ni me'a i tautou boo 'anga na: Ni tokotoko, poni kete, poni utunga, poni mane, poni ake ke ge'o ai. ");
INSERT INTO mnv_vpl VALUES ("LK9_4","072_9_4","LUK","9","4","4","Tehea te hage e he uguhi kinai koutou, noho 'aki atu ai aano hetae ki te 'aso boo o 'outou i te manaha. ");
INSERT INTO mnv_vpl VALUES ("LK9_5","072_9_5","LUK","9","5","5","Ka nimaa iai ni pegea he'e haka pogo ia te koutou, tuutuu atu na kege i outou tapungao ma kaa boo koutou i tegatou manaha, kago haka 'agi ai ko kigatou e ti'akina.” ");
INSERT INTO mnv_vpl VALUES ("LK9_6","072_9_6","LUK","9","6","6","Ko kigatou na boo i ba'i manaha o tohi'aki kinai i te Gongo Gaoi ma te haka ma'ugi ba'i pegea masasaki i ba'i kunga. ");
INSERT INTO mnv_vpl VALUES ("LK9_7","072_9_7","LUK","9","7","7","Ko Herod te Hakahua o Galilee na haka gongo i na hai 'anga noko hai, o mou tegeu'a, noko ghaghi i te hai ake na pegea, “Ko Ia ko John Baptist na mate ka kua ma'ugi hoki.” ");
INSERT INTO mnv_vpl VALUES ("LK9_8","072_9_8","LUK","9","8","8","Kae hai ake kogaa ma'u, “Ko Ia ko Elijah kua haka 'agitino hoki,” ka manga hai ake kogaa, “Ko Ia te launatasi i na taauga mai gaa 'aso, ka kua manga ma'ugi hoki.” ");
INSERT INTO mnv_vpl VALUES ("LK9_9","072_9_9","LUK","9","9","9","Ka ko Herod noko hai atu, “Ko John na toghi eau te u'a, ka koai te haka gongo ai au nei?” Ka ko Herod noko siahai ke ina kia Jesus. ");
INSERT INTO mnv_vpl VALUES ("LK9_10","072_9_10","LUK","9","10","10","Nimaa giu mai na pegea haka to'o, ko kigatou noko 'atigongo kia Jesus i nia kua 'oti i te hai e kigatou, ma te kakabe e Jesus ia te kigatou o boo soko ki te launatasi manaha, e mate ko Bethsaida. ");
INSERT INTO mnv_vpl VALUES ("LK9_11","072_9_11","LUK","9","11","11","Ka na na'a e te 'apitanga, o tata'o ia te Ia, ka na haka pogo e Jesus ia te kigatou, ma te 'atigongo kinai i te Hakahua 'anga a te 'Aitu, ma te haka ma'ugi na pegea noko siahahai kigatou maa'ugi. ");
INSERT INTO mnv_vpl VALUES ("LK9_12","072_9_12","LUK","9","12","12","Nimaa hano te ga'aa ke pisi, te tino anga hugu tuma'a e gua pegea haka ako noko boomai kia Jesus o hai atu kinai, “Tuku atu te 'apitanga kigatou boo ki na manaha ma na kunga henua e hitaiaki mai nei, ke ligo ai ma'agatou ni utunga, ma te kigatou noho 'aki ai, na'e ko kitatou manga i te kunga gaabaki.” ");
INSERT INTO mnv_vpl VALUES ("LK9_13","072_9_13","LUK","9","13","13","Ka ko Jesus noko haka tau kia te kigatou o hai atu, “ 'Abatu e koutou ma'agatou ni utunga ke kai.” Ko kigatou noko haka tau o hai atu kia Jesus, “Manga toka gima amatou bred ma te toka gua mi'i kaui, nimaa si'ai, kimatou boo o tau'i ni utunga ma'ana pegea e 'api nei!” ");
INSERT INTO mnv_vpl VALUES ("LK9_14","072_9_14","LUK","9","14","14","(Iteme'agaa te gimanga noa taangata te noko i te kungaa.) Ko Jesus noko hai atu ki ona pegea haka ako, “Hai atu ki te 'apitanga ke boomai o manga taki noho 'aki i te tino gima.” ");
INSERT INTO mnv_vpl VALUES ("LK9_15","072_9_15","LUK","9","15","15","Nimaa maa'ogi na pegea haka ako o hai e kigatou te 'apitanga o noho 'aki. ");
INSERT INTO mnv_vpl VALUES ("LK9_16","072_9_16","LUK","9","16","16","Sa'u ake e Jesus te toka gima bred ma gua kaui, kae ina haka tu'u ki te gangi o haka 'aue ai kia te 'Aitu, kae tohitohi o 'abange ki ona pegea haka ako o tuha ki te 'apitanga. ");
INSERT INTO mnv_vpl VALUES ("LK9_17","072_9_17","LUK","9","17","17","Ko kigatou na kai o makokona, kae tibu ena pegea haka ako na momo utunga noko toe o tape ai te tini ma te tokagua kete. ");
INSERT INTO mnv_vpl VALUES ("LK9_18","072_9_18","LUK","9","18","18","Nimaa tegaa 'aso, ko Jesus noko manga taakunga launatasi ai, kae boomai ona pegea haka ako kia te Ia, ma te haka anu kinai a Jesus o hai atu, “Te 'apitanga manga hai ake ko Au koai?” ");
INSERT INTO mnv_vpl VALUES ("LK9_19","072_9_19","LUK","9","19","19","Ko kigatou noko haka tau o hai atu, “Manga hai ake kogaa, ko Koe ko John Baptist, kae hai ake kogaa ma'u, ko Koe ko Elijah, kae hai ake kogaa pegea, ko Koe te launatasi i na taauga mai gaa 'aso ka kua ma'ugi hoki.” ");
INSERT INTO mnv_vpl VALUES ("LK9_20","072_9_20","LUK","9","20","20","Nimaa haka anu hoki atu a Jesus kia te kigatou o hai atu, “Ka koutou 'eaa? Koutou e hai ake ko Au koai?” Ma te haka tau a Peter o hai atu, “Ko Koe te 'Agiki Taga'ia mai a te 'Aitu.” ");
INSERT INTO mnv_vpl VALUES ("LK9_21","072_9_21","LUK","9","21","21","Ka ko Jesus noko hai taagango kia te kigatou ke noka te hogahoga na noho o'ona ki he pegea. ");
INSERT INTO mnv_vpl VALUES ("LK9_22","072_9_22","LUK","9","22","22","Kae kogaa ana to'o atu ma'u, “Te Hosa o Pegea e hai ke go tiha'ia ki ba'i hai 'anga, kago he'e siahahai kinai na 'agiki o na Jew, ma na tuginga o na Priest, ma na ako o na tagangonga. Ko Ia e hai ke go ta'ia, ka nimaa i te togunga 'ao, kae ma'ugi hokimai.” ");
INSERT INTO mnv_vpl VALUES ("LK9_23","072_9_23","LUK","9","23","23","Ma te hai atu a Jesus kia te kigatou ngatahi, “Te pegea nimaa siahai ke tata'o tu'a ia te Au, e hai ke noka te maanatu iho kia te ia, kae to'o tena kros, o tata'o tu'a mai ia te Au. ");
INSERT INTO mnv_vpl VALUES ("LK9_24","072_9_24","LUK","9","24","24","Iteme'agaa koai e siahai ke ge'o te ma'ugi o'ona, e hai ke go he'e kitea, ka koai e ti'aki mai te ma'ugi kia te Au, e hai ke go kite hoki ai. ");
INSERT INTO mnv_vpl VALUES ("LK9_25","072_9_25","LUK","9","25","25","'Ai tehea te gaoi o te pegea ga'u eia ba'i me'a i te kege nei, kae ti'aki te ma'ugi o 'ona? ");
INSERT INTO mnv_vpl VALUES ("LK9_26","072_9_26","LUK","9","26","26","Te pegea nimaa pa'a ia te Au ma aku haka hegeunga, te Hosa o Pegea kago pa'a ma'u ia te ia, i te 'aso kago a'u ai Ia ma tena mamagunga, ma te mamagunga o te Tamana, ma o'ona ensel tapu. ");
INSERT INTO mnv_vpl VALUES ("LK9_27","072_9_27","LUK","9","27","27","“Koau e 'atigongo maa'ogi atu kia te koutou, e iai na pegea manga tutu'u i te kunga nei kago he'e hetae kinai te mate, hano aano hiina'i ki te Hakahua 'anga a te 'Aitu.” ");
INSERT INTO mnv_vpl VALUES ("LK9_28","072_9_28","LUK","9","28","28","Nimaa sigi te bagunga 'ao i te konei na gea a Jesus, kae kakabe e Ia ia Peter, ma John, ma James, o haka pigi kia te Ia o haka neke ki te ogo ke taakunga ai. ");
INSERT INTO mnv_vpl VALUES ("LK9_29","072_9_29","LUK","9","29","29","Te gholoba noko manga taakunga ai Ia, na taunga mata noko gigiu, kae hu'ai maagama ona ake, o manga noho pe na kemo 'anga na 'uiga. ");
INSERT INTO mnv_vpl VALUES ("LK9_30","072_9_30","LUK","9","30","30","Ma te 'a'aki ma te mamagunga 'atanga gaoi, te toka gua taangata, ko Moses ma Elijah o manga hegeu ma Jesus. ");
INSERT INTO mnv_vpl VALUES ("LK9_31","072_9_31","LUK","9","31","31","Ko kigatou noko manga hegeu ki te hano o 'ona noko ma hai ke haka maa'ogi e Ia i Jerusalem. ");
INSERT INTO mnv_vpl VALUES ("LK9_32","072_9_32","LUK","9","32","32","Ka ko Peter ma gua 'ana hemasi'inga na hu'ai momoe, nimaa te gholoba na a'aga ai, ko kigatou noko hiina'i ki te mamagunga o Jesus ma gua pegea noko tutu'u haka pigi kia te Ia. ");
INSERT INTO mnv_vpl VALUES ("LK9_33","072_9_33","LUK","9","33","33","Nimaa hai ke boo 'aatea gua pegea ia Jesus, kae hai atu a Peter kia te Ia, “Hakahua, e hu'ai gaoi tematou boomai 'anga ki te kunga nei, kimatou hai 'ia he toka togu boghugha, he launatasi mo'ou, ma he launatasi mo'o Moses, ma he launatasi mo'o Elijah.” Ka noko he'e na'a e Peter nia te noko gea kinai. ");
INSERT INTO mnv_vpl VALUES ("LK9_34","072_9_34","LUK","9","34","34","Te gholoba noko manga koi haka hegeu ai a Peter, kae sopo mai te po'ao o tango ia te kigatou, ma te matataku na pegea haka ako i tegatou memene 'anga i te po'ao. ");
INSERT INTO mnv_vpl VALUES ("LK9_35","072_9_35","LUK","9","35","35","Ma te sopo mai te ge'o i te po'ao o hai mai, “Tenei toku Hosa noko haka pupugu e Au. Haka gongo ake kia te Ia.” ");
INSERT INTO mnv_vpl VALUES ("LK9_36","072_9_36","LUK","9","36","36","Te gholoba na he'e gongona ai te ge'o, kae hiina'i atu kigatou ko Jesus manga launatasi. Na pegea haka ako na manga na'a soko e kigatou na hai 'anga nei. Kae he'e hogahoga e kigatou ki ni pegea na hai 'anga noko hiina'i kinai kigatou. ");
INSERT INTO mnv_vpl VALUES ("LK9_37","072_9_37","LUK","9","37","37","Nimaa tegaa 'ao, ko kigatou noko boo iho i te ogo, kae boomai te 'apitanga o pegea o bilaabei ma Jesus. ");
INSERT INTO mnv_vpl VALUES ("LK9_38","072_9_38","LUK","9","38","38","Te launatasi tangata i te haka putunga noko ngege kia Jesus o hai atu, “Hakahua, ko au e sasaka atu kia te Koe ke ina ki toku hosa, na'e tenei taku tama 'iti'iti e tasi. ");
INSERT INTO mnv_vpl VALUES ("LK9_39","072_9_39","LUK","9","39","39","Kae hai e te 'atua ia te ia o ghaghaa to'a; hai ia te ia ghotoi, o manga popoge kae piloe te ngutu, kae hu'ai hai songo eia ia te ia, kae he'e 'aonga tena hano 'aatea ia te ia. ");
INSERT INTO mnv_vpl VALUES ("LK9_40","072_9_40","LUK","9","40","40","Kua sasaka ai au ki ou pegea haka ako kigatou pagepage 'ia, ma te he'e 'aonga te hai e kigatou.” ");
INSERT INTO mnv_vpl VALUES ("LK9_41","072_9_41","LUK","9","41","41","Ma te haka tau a Jesus o hai atu, “Koutou te 'atu tangata maase'i, kae he'e too kia te Au. Tahiaange 'aso e hai kau noko haka pata ai kia te koutou o baasiko ia te koutou? Kakabe mai tou hosa ki te kunga nei.” ");
INSERT INTO mnv_vpl VALUES ("LK9_42","072_9_42","LUK","9","42","42","Nimaa haka tu'u a'u te mi'i tangata, kae manga 'aka e te haagiki ia te ia o too ki te kege, kae hai o popoge, ma te pagepage e Jesus te haagiki songo, kae haka ma'ugi e Ia te mi'i tangata, kae tuku o hoki kia te tamana. ");
INSERT INTO mnv_vpl VALUES ("LK9_43","072_9_43","LUK","9","43","43","Te 'apitanga na hu'ai he gege ma'ugi 'aki ai i na hu'ai taganga o te 'Aitu. Te gholoba noko he gege ma'ugi 'aki ai ba'i pegea i na hai 'anga noko hai e Jesus, ko Ia noko hai atu ki ona pegea haka ako, ");
INSERT INTO mnv_vpl VALUES ("LK9_44","072_9_44","LUK","9","44","44","“Haka gongo mai o na'a gaoi nia te hai kau gea ai kia te koutou: Te Hosa o Pegea e hai ke go haka soko 'ia ki na gima o pegea.” ");
INSERT INTO mnv_vpl VALUES ("LK9_45","072_9_45","LUK","9","45","45","Ka noko he'e na'a e kigatou po tehea tena gaataki. Noko hu'ai ngigo ia te kigatou, o he'e na'a ai e kigatou, ma te matataku a kigatou te haka anuanu 'aki ai kia te Ia. ");
INSERT INTO mnv_vpl VALUES ("LK9_46","072_9_46","LUK","9","46","46","Na pegea haka ako noko haka bagebage 'aki, po koai ia te kigatou te hai ke go hua'eha. ");
INSERT INTO mnv_vpl VALUES ("LK9_47","072_9_47","LUK","9","47","47","Nimaa na'a e Jesus agatou maanatu, ma te kakabe mai e Ia te mi'i tama 'iti'iti o haka tu'u i ona taha. ");
INSERT INTO mnv_vpl VALUES ("LK9_48","072_9_48","LUK","9","48","48","Kae hai atu a Jesus kia te kigatou, “Koai e kumu i te mi'i tama 'iti'iti nei, i te maanatu i toku ingoa, e kumu ia te Au. Ka koai e kumu ia te Au, e kumu ia te Ia noko haka to'o mai ia te Au. Ka te pegea e hu'ai hua'iti'iti ia te koutou, tenaa ia e hai ke go hua'eha.” ");
INSERT INTO mnv_vpl VALUES ("LK9_49","072_9_49","LUK","9","49","49","Ma te hai atu a John, “Hakahua, ko kimatou noko hiina'i ki te pegea noko manga pagepage haagiki i tou ingoa, ka na susugi e kimatou ia te ia, iteme'agaa koia he'e te pegea ia te kitatou.” ");
INSERT INTO mnv_vpl VALUES ("LK9_50","072_9_50","LUK","9","50","50","Ma te hai atu kinai a Jesus, “Noka te susugi ia te ia, na'e te pegea nimaa he'e haka makau ia te koutou, te pegea outou.” ");
INSERT INTO mnv_vpl VALUES ("LK9_51","072_9_51","LUK","9","51","51","Nimaa hitaiaki te 'aso noko hai ke hoki ai a Jesus ki te gangi, ko Ia noko hai tena maanatu ke hano ki Jerusalem. ");
INSERT INTO mnv_vpl VALUES ("LK9_52","072_9_52","LUK","9","52","52","Ka noko tuku na pegea o mumu'a ia te Ia, ke baa gongo te manaha i Samaria ke ngaague o hitagi mai ia te Ia. ");
INSERT INTO mnv_vpl VALUES ("LK9_53","072_9_53","LUK","9","53","53","Ka na pegea o te manaha na he'e haka pogo ia Jesus, iteme'agaa ko Ia noko hai ke hano ki Jerusalem. ");
INSERT INTO mnv_vpl VALUES ("LK9_54","072_9_54","LUK","9","54","54","Nimaa hiina'i kinai gua pegea haka ako ia James ma John ki te hai 'anga nei, ma te hai atu kia Jesus, “Hakahua, ko Koe e siahai kimaua haka ene 'aki he ahi mai te gangi ke tutu ia te kigatou?” ");
INSERT INTO mnv_vpl VALUES ("LK9_55","072_9_55","LUK","9","55","55","Ka noko keu mai kinai a Jesus o gea susugi ia te kigaaua. ");
INSERT INTO mnv_vpl VALUES ("LK9_56","072_9_56","LUK","9","56","56","Kae boo kigatou ki tegaa manaha. ");
INSERT INTO mnv_vpl VALUES ("LK9_57","072_9_57","LUK","9","57","57","Te gholoba noko manga koi boo ai kigatou i te aga, kae hai atu te pegea kia Jesus, “Koau hai kau tata'o tu'a ia te Koe ki ba'i kunga hano kinai Koe.” ");
INSERT INTO mnv_vpl VALUES ("LK9_58","072_9_58","LUK","9","58","58","Ka na hai atu a Jesus kia te ia, “Na manu hetoogohi o mouku e hai ogatou 'ana, ka na manu he gegei e hai ogatou aliu, ka te Hosa o Pegea e he'e tau kunga ke moe ai.” ");
INSERT INTO mnv_vpl VALUES ("LK9_59","072_9_59","LUK","9","59","59","Kae hai atu a Jesus ki tegaa pegea, “Tata'o tu'a mai ia te Au.” Ka koia noko haka tau o hai atu, “Hakahua, mataa tuku mai kau hano o tanu ia tamau.” ");
INSERT INTO mnv_vpl VALUES ("LK9_60","072_9_60","LUK","9","60","60","Ma te haka tau a Jesus o hai atu kia te ia, “Tuku atu na pegea mamate, ke tanu ogatou pegea mamate, kae hinatu koe o 'atigongo i te Hakahua 'anga a te 'Aitu.” ");
INSERT INTO mnv_vpl VALUES ("LK9_61","072_9_61","LUK","9","61","61","Kae hai atu ma'u tegaa pegea, “Hakahua, mataa tuku mai kau hoki o haka mahoga ki oku pegea i toku manaha, 'io kau go tata'o ia te Koe.” ");
INSERT INTO mnv_vpl VALUES ("LK9_62","072_9_62","LUK","9","62","62","Ma te haka tau kinai a Jesus o hai atu, “He'e kitea he pegea ke 'oso ki te me'a kegi kege, kae keu hoki ki tu'a. Koia ka he'e 'aonga te hai hekau ki te Hakahua 'anga a te 'Aitu.” ");
INSERT INTO mnv_vpl VALUES ("LK10_1","072_10_1","LUK","10","1","1","Mugi i te hai 'anga nei, ko te Hakahua noko haka pau ma'u e Ia te tino hitu tuma'a e gua o tuku ia te kigatou o boo taki gua, o mumu'a ia te Ia ki ba'i manaha ma ba'i kunga e hai ke go hano kinai. ");
INSERT INTO mnv_vpl VALUES ("LK10_2","072_10_2","LUK","10","2","2","Ko Jesus noko hai atu kia te kigatou, “E hu'ai 'eha na me'a e matu'a i te 'umanga, ka na pegea utu he'e 'api. Haka ene 'aki atu ai ki te Hakahua o te 'umanga kua matu'a, ke tuku ma'u eia ni pegea ke boo kigatou o utu te 'umanga kua matu'a. ");
INSERT INTO mnv_vpl VALUES ("LK10_3","072_10_3","LUK","10","3","3","Boo atu! Na'e tuku e Au ia te koutou ke boo o noho pe na punua sipisipi e boo ki na kunga e iai na manu totogo hai maka. ");
INSERT INTO mnv_vpl VALUES ("LK10_4","072_10_4","LUK","10","4","4","Noka te to'o ni oko oko, poni tanga, poni taka ba'e, ma te noka te gegea ki ni pegea i te aga. ");
INSERT INTO mnv_vpl VALUES ("LK10_5","072_10_5","LUK","10","5","5","“Te 'aso kago he uguhi ai koutou ki he hage, ogo mataa kogaa na hai atu kinai: ‘Te goto maagie ki te hage nei.’ ");
INSERT INTO mnv_vpl VALUES ("LK10_6","072_10_6","LUK","10","6","6","Ka nimaa iai he pegea goto maagie i te hage, te goto maagie e hai ke noho kia te ia. Ka nimaa si'ai, te goto maagie e hai ke manga hoki atu kia te koutou. ");
INSERT INTO mnv_vpl VALUES ("LK10_7","072_10_7","LUK","10","7","7","Noho 'aki atu i te hage na, o kai ma te bibinu nia kago 'abatu e kigatou kia te koutou, iteme'agaa te pegea e hai hekau, kago ga'u eia tena giu'aki. Ogo noka te boo i tegaa hage ki tegaa hage. ");
INSERT INTO mnv_vpl VALUES ("LK10_8","072_10_8","LUK","10","8","8","“Koutou nimaa boo ki he manaha o haka pogo ia te koutou, kai atu nia kago 'abatu kia te koutou. ");
INSERT INTO mnv_vpl VALUES ("LK10_9","072_10_9","LUK","10","9","9","Haka ma'ugi atu na pegea masasaki i te kungaa, ma te 'atigongo atu kia te kigatou: ‘Te Hakahua 'anga a te 'Aitu kua hitaiaki kia te koutou.’ ");
INSERT INTO mnv_vpl VALUES ("LK10_10","072_10_10","LUK","10","10","10","Ka nimaa boo koutou ki he manaha o he'e haka pogo ia te koutou, ogo manga boo atu ki na agatu'u, o hai atu ki na pegea manga iai, ");
INSERT INTO mnv_vpl VALUES ("LK10_11","072_10_11","LUK","10","11","11","‘He'e po na tobeabu i na manaha o'outou e pipigi ki omatou tapungao, e hai ke tahitahi ke haka 'agi ai te kuu manaba kia te koutou. Ka te me'a ke na'a e koutou, te Hakahua 'anga a te 'Aitu kua hitaiaki.’ ");
INSERT INTO mnv_vpl VALUES ("LK10_12","072_10_12","LUK","10","12","12","Ko Au e hai atu kia te koutou, ko te 'Aitu e hai ke go kago ki te manaha nei i te 'aso o te haka aba o sigi i Sodom. ");
INSERT INTO mnv_vpl VALUES ("LK10_13","072_10_13","LUK","10","13","13","“Haka 'aagoha a koutou Chorazin! Haka 'aagoha a koutou Bethsaida! Na hai 'anga haka gege ma'ugi noko hai e Au kia te koutou, poi hai e Au ki Tyre ma Sidon, ko kigatou kua goa te he keu 'aki giu mai o mamago ini bebe laoa, ma te haa pugha ini gehu, ke haka 'agi ai kua 'oti i ogatou 'oosongo. ");
INSERT INTO mnv_vpl VALUES ("LK10_14","072_10_14","LUK","10","14","14","Ko te 'Aitu e hai ke go kago kia te koutou, i te 'ao o te haka aba o sigi i Tyre ma Sidon. ");
INSERT INTO mnv_vpl VALUES ("LK10_15","072_10_15","LUK","10","15","15","Ka koutou Capernaum e siahahai koutou hu'ai ma'u 'agunga? E hai ke go seu ki te ugaimami.” ");
INSERT INTO mnv_vpl VALUES ("LK10_16","072_10_16","LUK","10","16","16","Ko Jesus noko hai atu ki ona pegea haka ako, “Koai e haka gongo kia te koutou, e haka gongo ma'u kia te Au. Ka koai kago he'e siahai kia te koutou, kago he'e siahai ma'u kia te Au. Ka te pegea kago he'e siahai kia te Au, e he'e siahai ma'u kia te 'Aitu noko haka to'o mai ia te Au.” ");
INSERT INTO mnv_vpl VALUES ("LK10_17","072_10_17","LUK","10","17","17","Te tino hitu tuma'a e gua noko giu mai ma tegatou magagaohie o kogaa agatou to'o, “Hakahua, na haagiki songo ma'u noko hu'ai mangangao kia te kimatou i na pagepage 'anga e kimatou i tou ingoa.” ");
INSERT INTO mnv_vpl VALUES ("LK10_18","072_10_18","LUK","10","18","18","Ma te haka tau a Jesus o hai atu kia te kigatou, “Ko Au kua ina kia Satan e toiho, manga noho pe te 'uiga kemo mai i te gangi. ");
INSERT INTO mnv_vpl VALUES ("LK10_19","072_10_19","LUK","10","19","19","Ka kua 'abatu e Au kia te koutou na taganga, koutou takataka 'ia ai na ngata ma na manu ba'e gua, ma te koutou sigi ai i na taganga o te makau. Kago si'ai ni me'a ke hai songo ia te koutou. ");
INSERT INTO mnv_vpl VALUES ("LK10_20","072_10_20","LUK","10","20","20","Ka koutou noka tautou sisia, i te munange na haagiki kua mangangao ia te koutou, ka koutou e hai ke manga sisia, i na ingoa o'outou kua 'oti i te kanukanu i te gangi.” ");
INSERT INTO mnv_vpl VALUES ("LK10_21","072_10_21","LUK","10","21","21","Te gholoba na, ko Jesus noko hu'ai magaohie i te Spirit Tapu ma te kogaa ana to'o, “Tamau, ko Koe te Hakahua o te gangi ma te kege nei, ko Au e haka e'eha ia te Koe, iteme'agaa noko huu e Koe na hai 'anga nei i na pegea he 'igo'igo 'aki ma na pegea na'a hai 'anga, kae haka 'agi e Koe ki na pegea manga noho pena tama giki. E maa'ogi Tamau, na me'a nei manga hai i au maanatu gaoi. ");
INSERT INTO mnv_vpl VALUES ("LK10_22","072_10_22","LUK","10","22","22","“Ko ba'i hai 'anga na tuku e Tamau kia te Au. E si'ai he pegea na'a eia koai ko tena Hosa, ka manga na'a e te Tamana. Kae si'ai ma'u he pegea na'a koai ko te Tamana, ka manga ko tena Hosa, ma na pegea e ligo e te Hosa ke haka 'agi kinai e Ia.” ");
INSERT INTO mnv_vpl VALUES ("LK10_23","072_10_23","LUK","10","23","23","Ma te takahugi atu a Jesus ki ona pegea haka ako o manga mi'i gea atu kia te kigatou o hai atu, “Haka gaoi ki na mata kua hiina'i ki na hai 'anga e hiina'i kinai koutou nei. ");
INSERT INTO mnv_vpl VALUES ("LK10_24","072_10_24","LUK","10","24","24","Iteme'agaa ko Au e hai atu kia te koutou, noko 'api taauga ma na hakahua, noko siahahai ke hiina'i ki na hai 'anga kua hiina'i kinai koutou nei, ka noko he'e 'aonga te hiina'i kinai. Ko kigatou noko siahahai ma'u kigatou haka gongo ki na hai 'anga kua haka gongo kinai koutou nei, ka noko he'e 'aonga te haka gongo kinai.” ");
INSERT INTO mnv_vpl VALUES ("LK10_25","072_10_25","LUK","10","25","25","Te launatasi 'aso noko tu'u ai te launatasi i na ako o na tagangonga o hai lobo eia ia Jesus, o hai atu kinai, “Ako, niaa e hai kau hai 'ia kau ga'u 'ia ai te ma'ugi noho goa?” ");
INSERT INTO mnv_vpl VALUES ("LK10_26","072_10_26","LUK","10","26","26","Ma te haka tau a Jesus o hai atu kinai, “Niaa te noko kanukanu ki na tagangonga? E kohea na na'a e koe tena haka sahe 'anga?” ");
INSERT INTO mnv_vpl VALUES ("LK10_27","072_10_27","LUK","10","27","27","Ka koia noko haka tau o hai atu, “Ma'ine atu kia te 'Agiki te 'Aitu o 'ou i tou uso ngatahi, ma tou ma'ugi ngatahi, ma au to'a 'anga ngatahi, ma au tegeu'a ngatahi. Ma te ma'ine atu ki ou pegea e pata mai, ke noho pe au ma'ine 'anga kia te koe.” ");
INSERT INTO mnv_vpl VALUES ("LK10_28","072_10_28","LUK","10","28","28","Ma te haka tau a Jesus o hai atu kinai, “Tau haka tau na e hu'ai gaoi, konei na hai atu, ka ke ma'ugi ai koe.” ");
INSERT INTO mnv_vpl VALUES ("LK10_29","072_10_29","LUK","10","29","29","Ka koia noko siahai ke haka 'agi koia e hu'ai gaoi, tegaa te hai 'anga noko hai atu ai kia Jesus, “ 'Ai koai toku pegea e pata mai?” ");
INSERT INTO mnv_vpl VALUES ("LK10_30","072_10_30","LUK","10","30","30","Ma te haka tau a Jesus o hai atu kinai, “Te launatasi tangata noko hinaiho i Jerusalem ki Jericho. Ma te labu e na pegea kaia'a, o huhuke e kigatou ona ake, kae kogu e kigatou aano semu o noko manga takoto, kae boo. ");
INSERT INTO mnv_vpl VALUES ("LK10_31","072_10_31","LUK","10","31","31","Nimaa hano ma'u te priest i te aga e tasi, koia na kite i te pegea manga takoto, ma te hano haka tihitihi ai i tegaa pa'asi o te aga. ");
INSERT INTO mnv_vpl VALUES ("LK10_32","072_10_32","LUK","10","32","32","Noko iai ma'u te pegea i te hanohano o Levi noko hetae ki te kungaa. Nimaa ina ki te pegea, koia ma'u noko hano haka tihitihi ai i tegaa pa'asi o te aga. ");
INSERT INTO mnv_vpl VALUES ("LK10_33","072_10_33","LUK","10","33","33","Ka te launatasi pegea mai Samaria noko hano i te aga e tasi. Nimaa hetae ki te kunga noko manga takoto ai te pegea, koia na ina kinai o hu'ai 'agoha kia te ia. ");
INSERT INTO mnv_vpl VALUES ("LK10_34","072_10_34","LUK","10","34","34","Koia noko hano o tuku kinai eia na oela ma na waeni o hetauaki ai ona maka, o gii. Kae mugi ia o nekeneke ake ia te ia o haka eke ki tena donki, o kakabe eia ki te hage o na pegea lango o hegau ai ia te ia. ");
INSERT INTO mnv_vpl VALUES ("LK10_35","072_10_35","LUK","10","35","35","Nimaa tegaa 'ao, sa'u ake eia te toka gua mane siliva, o haiga'a ki te hakahua o te hage, kae hai atu kinai: ‘Kumu atu ia te ia, ka nimaa go hokimai au, kau go sui 'ia nia kua hai kinai e koe.’ ” ");
INSERT INTO mnv_vpl VALUES ("LK10_36","072_10_36","LUK","10","36","36","Ma te hai atu a Jesus, “Koai i te toka togu nei e tegeu'a ake koe, koia noko hai ki te pegea na taa ena pegea kaia'a, o noho mai tena pegea e pata mai?” ");
INSERT INTO mnv_vpl VALUES ("LK10_37","072_10_37","LUK","10","37","37","Te ako o na tagangonga noko haka tau o hai atu kinai, “Te pegea noko 'agoha kia te ia.” Ma te hai atu a Jesus kia te ia, “Hinatu, o konei au hai ma'u.” ");
INSERT INTO mnv_vpl VALUES ("LK10_38","072_10_38","LUK","10","38","38","Ko Jesus ma ona pegea haka ako noko boo i te aga. Ko Ia noko hetae ki te manaha o te hahine e mate tena ingoa ko Martha, o haka pogo eia ia te Ia ki tena manaha. ");
INSERT INTO mnv_vpl VALUES ("LK10_39","072_10_39","LUK","10","39","39","Ko ia noko hai tena taina noko mate tena ingoa ko Mary, noko manga noho o pata i na ba'e o te 'Aitu, o noko manga haka gongo ki nia noko manga gea kinai. ");
INSERT INTO mnv_vpl VALUES ("LK10_40","072_10_40","LUK","10","40","40","Ka ko Martha noko hu'ai ghaulia i ba'i me'a noko manga ngaague eia. Koia noko a'u kia Jesus o hai atu kinai, “Hakahua, 'ai e he'e tegeu'a ake Koe e maase'i, te manga tuku e te taina o'oku ia te au o manga hai hekau launatasi? Hai atu kinai ke a'u o 'aabaki kia te au!” ");
INSERT INTO mnv_vpl VALUES ("LK10_41","072_10_41","LUK","10","41","41","Haka tau a te Hakahua o hai atu, “Martha, ko koe e hu'ai ghaulia ki ba'i me'a. ");
INSERT INTO mnv_vpl VALUES ("LK10_42","072_10_42","LUK","10","42","42","Kae launatasi hai 'anga e gaoi te siahai kinai. Ko Mary kua ligo eia te hai 'anga hu'ai gaoi, kago he'e to'o 'aatea ia te ia.” ");
INSERT INTO mnv_vpl VALUES ("LK11_1","072_11_1","LUK","11","1","1","Te launatasi 'ao, ko Jesus noko taakunga ai i tegaa kunga. Te gholoba na 'oti i te taakunga ai Ia, a'u te launatasi i ona pegea haka ako o hai atu kinai, “Hakahua, ako mai kimatou taakunga, ke noho pe te ako 'anga e John ona pegea haka ako.” ");
INSERT INTO mnv_vpl VALUES ("LK11_2","072_11_2","LUK","11","2","2","Ko Jesus noko hai atu kia te kigatou, “Koutou nimaa taakunga, konei na taakunga ake, ‘Tematou Tamana e noho i te gangi, te ingoa tapu o'ou ke haka ma'u 'agunga, te hakahua o'ou ke go a'u. ");
INSERT INTO mnv_vpl VALUES ("LK11_3","072_11_3","LUK","11","3","3","'Aumai ma'amatou ni utunga i ba'i 'aso. ");
INSERT INTO mnv_vpl VALUES ("LK11_4","072_11_4","LUK","11","4","4","Haka noka mai omatou 'oosongo, na'e ko kimatou manga haka noka ma'u ki na pegea e hai agatou hai 'anga songo kia te kimatou.’ Ma te noka te tuku ia te kimatou ki ni pakenga.” ");
INSERT INTO mnv_vpl VALUES ("LK11_5","072_11_5","LUK","11","5","5","Ma te hai atu a Jesus kia te kigatou “Poi iai he pegea ia te koutou e hai ma'ana he hemasi'inga, kae hano kia te ia i te tu'u gua poo o hai atu kinai: ‘Hemasi'inga, mataa 'aumai ma'aku he toka togu bred, ");
INSERT INTO mnv_vpl VALUES ("LK11_6","072_11_6","LUK","11","6","6","e iai taku hemasi'inga e a'u kia te au, kae he'e tau utunga kau haangai 'ia ai.’ ");
INSERT INTO mnv_vpl VALUES ("LK11_7","072_11_7","LUK","11","7","7","Ka poi konei na hakatau iho te pegea i goto: ‘Noka te baa tu'ia mai ia te au. Te aga kua 'oti i te titingi, ka ko kimatou ma aku tama giki kua 'oti i te momoe. E he'e 'aonga taku 'aga kau 'abatu 'ia he me'a kia te koe.’ ");
INSERT INTO mnv_vpl VALUES ("LK11_8","072_11_8","LUK","11","8","8","Ko Au e hai atu kia te koutou, hakagata goa koia ka he'e 'aga o 'abange te bred i te munange koia tena hemasi'inga, ka naato'o i te koia e he'e pa'a tena haka ene goa, koia ka 'aga o haiga'a kia te ia te potaha o na me'a e siahai kinai ia. ");
INSERT INTO mnv_vpl VALUES ("LK11_9","072_11_9","LUK","11","9","9","“Ka ko Au e hai atu kia te koutou: Haka ene 'aki atu ka ke 'abatu kia te koutou. Sasaga atu ka ke go kite e koutou. Tukituki atu te titingi ka ke go luga kia te koutou. ");
INSERT INTO mnv_vpl VALUES ("LK11_10","072_11_10","LUK","11","10","10","Iteme'agaa ko ba'i pegea haka ene 'aki e hai ke go ga'u e kigatou, koai e sasaga e hai ke go kite eia, koai e tukituki e hai ke go luga kia te ia te aga. ");
INSERT INTO mnv_vpl VALUES ("LK11_11","072_11_11","LUK","11","11","11","“ 'Ai koai ia te koutou na tamana, poi haka ene kinai mo'ona he hosa i he kaui, ka manga haka suihaki eia i he ngata o 'abange kinai? ");
INSERT INTO mnv_vpl VALUES ("LK11_12","072_11_12","LUK","11","12","12","Poe haka ene kinai ma'ana he hua paolo, ka manga 'abange kinai eia he manu ba'egua? ");
INSERT INTO mnv_vpl VALUES ("LK11_13","072_11_13","LUK","11","13","13","Ka koutou poi na pegea maase'i, kae manga na'a te haiga'a me'a gaoi ki autou tama giki, e soo atu te Tamana o'outou manga noho i te gangi e hai ke go haiga'a e Ia te Spirit Tapu ki na pegea e haka ene 'aki ai kia te Ia.” ");
INSERT INTO mnv_vpl VALUES ("LK11_14","072_11_14","LUK","11","14","14","Ko Jesus noko pagepage e Ia te haagiki he'e gea. Te gholoba noko hano 'aatea ai te haagiki, te tangata noko he'e 'aonga te gea, na gea, ma te he tu'ia 'aki ai te 'apitanga. ");
INSERT INTO mnv_vpl VALUES ("LK11_15","072_11_15","LUK","11","15","15","Ka noko iai kogaa ia te kigatou noko kogaa agatou to'o, “Ko Beelzebub, te tugi o na haagiki songo, te haiga'a eia kia te Ia na taganga o ma pagepage ai na haagiki songo.” ");
INSERT INTO mnv_vpl VALUES ("LK11_16","072_11_16","LUK","11","16","16","Noko hai lobo e kogaa pegea ia te Ia i te haka ene 'aki kinai ni haka 'igonga mai te gangi. ");
INSERT INTO mnv_vpl VALUES ("LK11_17","072_11_17","LUK","11","17","17","Ko Jesus noko na'a e Ia agatou maanatu ma te hai atu kia te kigatou, “Poi iai he sa'a e tuhatuha ia te kigatou o he hai songo 'aki, kago he'e noho goa. Ka poi iai he matiginga e tasi, e tuhatuha ia te kigatou o he hai songo 'aki, kago pau o maseuseu. ");
INSERT INTO mnv_vpl VALUES ("LK11_18","072_11_18","LUK","11","18","18","Ko Satan poi tuha tena sa'a o he hai songo 'aki ia te kigatou, e hai ke kohea na noho goa tena sa'a? Ko Au manga konei aku gea, iteme'agaa e hai ake koutou, ko Au manga pagepage haagiki i na taganga o Beelzebub. ");
INSERT INTO mnv_vpl VALUES ("LK11_19","072_11_19","LUK","11","19","19","Ka poi maa'ogi o pagepage e Au na haagiki i te ingoa o Beelzebub, to'oi te taganga te manga pagepage ai ena pegea o'outou na haagiki? E haka 'agi ai ena pegea o'outou, koutou e saga. ");
INSERT INTO mnv_vpl VALUES ("LK11_20","072_11_20","LUK","11","20","20","Ka nimaa pagepage e Au na haagiki i na taganga o te 'Aitu, te Hakahua 'anga a te 'Aitu kua hetae mai kia te koutou. ");
INSERT INTO mnv_vpl VALUES ("LK11_21","072_11_21","LUK","11","21","21","“Te gholoba e ngaague ai te pegea to'a 'ana me'a hai tau'a o ge'o ai tena hage, ko ba'i me'a a'ana ka noko noho gaoi. ");
INSERT INTO mnv_vpl VALUES ("LK11_22","072_11_22","LUK","11","22","22","Ka nimaa iai he pegea e hu'ai to'a o sigi, e a'u kia te ia o hetau aano sepu ai, ka to'o eia ko ba'i me'a hai tau'a a te tangata noko sano goa kinai, o tuhatuha eia nia e to'o eia. ");
INSERT INTO mnv_vpl VALUES ("LK11_23","072_11_23","LUK","11","23","23","“Te pegea e he'e haka pata kia te Au e haka makau eia ia te Au, ka te pegea nimaa he'e kakabe pegea mai kia te Au, manga hai eia a pegea o maseuseu. ");
INSERT INTO mnv_vpl VALUES ("LK11_24","072_11_24","LUK","11","24","24","“Te gholoba e sopo ai ki taha te haagiki songo i te tangata, koia manga sehu ai i na kunga henua gaabaki, o sasaga kunga ke oki oki ai o he'e kite he kunga, ma te hai ake, ‘Kau hoki ki te hage noko hano ai au.’ ");
INSERT INTO mnv_vpl VALUES ("LK11_25","072_11_25","LUK","11","25","25","Nimaa hetae o kite eia te hage kua tahitahi o ma'a, ma te kua 'oti i te haka tinogaoi ba'i me'a. ");
INSERT INTO mnv_vpl VALUES ("LK11_26","072_11_26","LUK","11","26","26","Ma te hano ia o kakabe mai tegaa toka hitu haagiki kabe songo o sigi ia te ia, o he uguhi ki goto o kakai ai. Na noho o te tangata nei e hu'ai maase'i to'a o sigi i te mataa noho 'anga.” ");
INSERT INTO mnv_vpl VALUES ("LK11_27","072_11_27","LUK","11","27","27","Te gholoba noko manga gea ai a Jesus i na hai 'anga nei, te launatasi hahine i te 'apitanga noko ngege atu kia Jesus o hai atu, “E haka gaoi te hahine noko haka haa ia te Koe, ma te haa uu ia te Koe.” ");
INSERT INTO mnv_vpl VALUES ("LK11_28","072_11_28","LUK","11","28","28","Ko Jesus noko haka tau o hai atu kinai, “Si'ai, e haka gaoi na pegea e haka gongo ki na haka hegeunga a te 'Aitu o mangangao kinai.” ");
INSERT INTO mnv_vpl VALUES ("LK11_29","072_11_29","LUK","11","29","29","Te haka putu 'anga te 'apitanga noko hu'ai 'api ma te kogaa na to'o atu kinai a Jesus, “Te 'atu tangata nei e hu'ai maase'i, e haka ene 'aki he haka 'igonga, kae si'ai he hai 'anga ke haka 'agi kia te kigatou, ka manga te haka 'igonga o Jonah. ");
INSERT INTO mnv_vpl VALUES ("LK11_30","072_11_30","LUK","11","30","30","E kogaa na noho ko Jonah noko hai ai te haka 'igonga ki te 'apitanga o Nineveh, ka manga konaa na noho ma'u te Hosa o Pegea te haka 'igonga ki te 'atu tangata o na 'aso nei. ");
INSERT INTO mnv_vpl VALUES ("LK11_31","072_11_31","LUK","11","31","31","Te hakahua hahine o Bagitakugu kago tu'u i te 'ao o te haka aba o haka makau eia te 'atu tangata o na 'aso nei, iteme'agaa koia noko a'u i na kunga mama'o i te kege nei ke haka gongo ki te 'igo'igo o Solomon. Kae iai te launatasi i te kunga nei e hua'eha o sigi ia Solomon. ");
INSERT INTO mnv_vpl VALUES ("LK11_32","072_11_32","LUK","11","32","32","Te 'apitanga o Nineveh kago tutu'u i te 'ao o te haka aba, o haka makau e kigatou te 'atu tangata nei, iteme'agaa na he sui tegeu'a 'aki i na tohi'aki 'anga a Jonah, ka e iai te launatasi i te kunga nei e hua'eha o sigi ia Jonah. ");
INSERT INTO mnv_vpl VALUES ("LK11_33","072_11_33","LUK","11","33","33","“Ka si'ai he pegea ke tutu eia he peba o huu eia ki he kunga, poe poghi eia i he kete, kae hai ke manga haka eke ki he me'a tuku peba, ka ke hiina'i kinai na pegea e he uguhi mai ki te hage. ");
INSERT INTO mnv_vpl VALUES ("LK11_34","072_11_34","LUK","11","34","34","Ou mata te peba o tou tino. Ou mata nimaa gaoi, tou tino ngatahi ka hu'ai maagama, ka nimaa he'e gaoi, tou tino ma'u ka hu'ai poo'ugi. ");
INSERT INTO mnv_vpl VALUES ("LK11_35","072_11_35","LUK","11","35","35","Ge'o gaoi atu ka ke noka te poo'ugi te maagama kua i goto ia te koe. ");
INSERT INTO mnv_vpl VALUES ("LK11_36","072_11_36","LUK","11","36","36","Tegaa te me'a, te tino ngatahi o'ou poi maagama kaatoa, kae si'ai he kunga ke poo'ugi, kua pau o hu'ai maagama o noho pe te peba hai o maagama ia te koe.” ");
INSERT INTO mnv_vpl VALUES ("LK11_37","072_11_37","LUK","11","37","37","Nimaa 'oti i te haka hegeu a Jesus, te launatasi i na Pharisee noko haka pogo eia ia Jesus ke kai haka pigi kia te ia. Ma te ugu a Jesus ki goto o noho i te kunga kai. ");
INSERT INTO mnv_vpl VALUES ("LK11_38","072_11_38","LUK","11","38","38","Ka te Pharisee noko ina 'atu kia Jesus manga he'e huhu'i na gima 'io mugi o kai, ma te gege ma'ugi ai. ");
INSERT INTO mnv_vpl VALUES ("LK11_39","072_11_39","LUK","11","39","39","Ma te hai atu a te Hakahua kia te ia, “Koutou na Pharisee manga hai e koutou o ma'a a taha i na kapu ma na peleti, ka ko goto ia te koutou e hua'eha ai te mou toto'o ma te hai hai 'anga songo. ");
INSERT INTO mnv_vpl VALUES ("LK11_40","072_11_40","LUK","11","40","40","Koutou na pegea hu'ai huhu'u! 'Ai e he'e na'a e koutou ia te 'Aitu noko gosigosi e Ia a taha ma goto ma'u? ");
INSERT INTO mnv_vpl VALUES ("LK11_41","072_11_41","LUK","11","41","41","Ka nia e i-goto ia te koutou—haiga'a atu ai ki na pegea lae, ka kego hai ko ba'i me'a ke ma'a kia te koutou. ");
INSERT INTO mnv_vpl VALUES ("LK11_42","072_11_42","LUK","11","42","42","“Haka 'aagoha koutou Pharisee, iteme'agaa e haiga'a e koutou kia te 'Aitu na katoa o na mi'i gaukei e mate na ‘mint’ ma na ‘rue’ ma gaa gaukei i outou 'umanga, kae hai ti'aki e koutou te haka tinogaoi ma te ma'ine o te 'Aitu. Konei na hai 'anga e hai ke hai e koutou, kae noka te hai ti'aki kogaa hai 'anga. ");
INSERT INTO mnv_vpl VALUES ("LK11_43","072_11_43","LUK","11","43","43","“Haka 'aagoha koutou Pharisee, iteme'agaa koutou manga maa'ine ki te noho 'aki i na noho 'anga ma'u 'agunga i na Hage hai paaunga ma na haka e'eha 'anga e pegea i na kunga he tau'i 'aki me'a. ");
INSERT INTO mnv_vpl VALUES ("LK11_44","072_11_44","LUK","11","44","44","“Haka 'aagoha koutou, iteme'agaa koutou manga noho pe na takotonga he'e tau haka 'igonga, manga lango a pegea o taka hanga ai i te he'e na'a e kigatou!” ");
INSERT INTO mnv_vpl VALUES ("LK11_45","072_11_45","LUK","11","45","45","Te launatasi i na ako o na tagangonga noko haka tau kia Jesus o hai atu kinai, “Ako, te gholoba e konei na gea ai Koe i na hai 'anga nei e hai songo ma'u ai e Koe ia te kimatou.” ");
INSERT INTO mnv_vpl VALUES ("LK11_46","072_11_46","LUK","11","46","46","Ka ko Jesus noko haka tau o hai atu kinai, “Haka 'aagoha koutou na ako o na tagangonga, i te 'ati e koutou na kabenga ki na tu'a ogaa pegea o he'e 'aonga te to'o e kigatou, kae si'ai he pegea ia te koutou ke 'oso atu te gima o 'aabaki kia te kigatou. ");
INSERT INTO mnv_vpl VALUES ("LK11_47","072_11_47","LUK","11","47","47","“Haka 'aagoha koutou, i te manga gosigosi e koutou na takotonga o na taauga na taa e outou tupuna. ");
INSERT INTO mnv_vpl VALUES ("LK11_48","072_11_48","LUK","11","48","48","Kua hogahoga ai e koutou ma te haka maa'ogi e koutou nia noko hai ena tupuna o'outou. Na taa e kigatou na taauga kae gosigosi e koutou ogatou takotonga. ");
INSERT INTO mnv_vpl VALUES ("LK11_49","072_11_49","LUK","11","49","49","Baaghaghi i na hai 'anga nei, ko te 'Aitu i tena 'igo'igo noko gea o hai ake: ‘E hai kau go haka to'o 'ia kinai ni taauga, ma ni pegea haka to'o, kago taa kogaa ia te kigatou, kae hai songo kogaa.’ ");
INSERT INTO mnv_vpl VALUES ("LK11_50","072_11_50","LUK","11","50","50","Te 'atu tangata nei te hai kego tuku kinai te kagohia o te taa'ia 'anga na taauga haka tu'u mai i te gosigosi 'anga a te kege nei. ");
INSERT INTO mnv_vpl VALUES ("LK11_51","072_11_51","LUK","11","51","51","Haka tu'u mai i te ta'ia 'anga a Abel ki te ta'ia 'anga a Zechariah, noko taa i te noho goto 'anga o te olta ma te kunga hu'ai tapu i goto i te Hage Tapu. E maa'ogi e hai atu Au kia te koutou, na pegea nei e hai ke go kagohia i ba'i hai 'anga noko hai nei. ");
INSERT INTO mnv_vpl VALUES ("LK11_52","072_11_52","LUK","11","52","52","“Haka 'aagoha koutou na ako o na tagangonga, i te huu e koutou te maa'ogi i te 'apitanga. Kua he'e ga'u e koutou, kae bapanoko e koutou na pegea e hai ke na'a ai e kigatou.” ");
INSERT INTO mnv_vpl VALUES ("LK11_53","072_11_53","LUK","11","53","53","Te gholoba noko hano ai a Jesus i te kungaa, na ako o na tagangonga ma na Pharisee noko haka tu'u tagatou haka bagebage toto'a kinai ma tegatou he haka anuanu 'aki boo kinai i ba'i me'a. ");
INSERT INTO mnv_vpl VALUES ("LK11_54","072_11_54","LUK","11","54","54","Noko manga pali e kigatou ke nimaa gea ini me'a kigatou go haka makau 'ia ai. ");
INSERT INTO mnv_vpl VALUES ("LK12_1","072_12_1","LUK","12","1","1","Nimaa i te tasi 'ao, te 'apitanga noko haka putu ngatahi mai o hu'ai 'api to'a o sigi i te noa. Ko kigatou noko he 'uku'uku 'aki, ka ko Jesus noko mataa gea ki ona pegea haka ako o hai atu kinai, “Koutou na'ana'a atu ki na akonga ana Pharisee, na'e hu'ai haka hagehage. ");
INSERT INTO mnv_vpl VALUES ("LK12_2","072_12_2","LUK","12","2","2","Ko ba'i me'a ngigo, e hai ke go hiina'i kinai, ma ba'i me'a huu e hai ke go hai ke na'a. ");
INSERT INTO mnv_vpl VALUES ("LK12_3","072_12_3","LUK","12","3","3","Nia e gegea ai koutou i te poo'uginga, e hai ke go haka gongo kinai i te maagama, ka nia noko palalana huu ai koutou i te hage, e hai ke go hogahoga haka maahoga i na hohonga o na hage. ");
INSERT INTO mnv_vpl VALUES ("LK12_4","072_12_4","LUK","12","4","4","“Ko Au e hai atu kia te koutou aku hemasi'inga, noka te matataku ki na pegea kago taa na tino, kae mugi o he'e tau hai 'anga ma'u. ");
INSERT INTO mnv_vpl VALUES ("LK12_5","072_12_5","LUK","12","5","5","Kae hai kau tuiaki 'ia kia te koutou koai te hai koutou matataku kinai: Matataku atu kia te 'Aitu e hai ke go nimaa 'oti i te taa e Ia na tino, kae hai taganga o seu e Ia ia te koutou ki te ugaimami. Ko Au e gea maa'ogi atu kia te koutou: Matataku atu kia te Ia. ");
INSERT INTO mnv_vpl VALUES ("LK12_6","072_12_6","LUK","12","6","6","Te toka gima mi'i manu manga 'aonga te tau'i i he toka gua mi'i mane, kae si'ai he launatasi ke he'e maanatu kinai a te 'Aitu. ");
INSERT INTO mnv_vpl VALUES ("LK12_7","072_12_7","LUK","12","7","7","He'e po na gau 'ugu o'outou e na'a e Ia tena taunga. Noka tautou matataku, na'e koutou e hu'ai gaoi o sigi i na tugaa mi'i manu. ");
INSERT INTO mnv_vpl VALUES ("LK12_8","072_12_8","LUK","12","8","8","“Ko Au e hai atu kia te koutou, te pegea nimaa 'atigongo ia te Au i 'ago ia pegea, te Hosa o Pegea kago sui o 'atigongo ia te ia i 'ago i na ensel o te 'Aitu. ");
INSERT INTO mnv_vpl VALUES ("LK12_9","072_12_9","LUK","12","9","9","Ka koai e hai ake koia he'e te pegea o'oku i 'ago ia pegea, te Hosa o Pegea e hai ke go sui o hai atu i 'ago i na ensel o te 'Aitu, koia he'e toku pegea. ");
INSERT INTO mnv_vpl VALUES ("LK12_10","072_12_10","LUK","12","10","10","Ka te pegea namaaa gea maase'i ki te Hosa o Pegea e hai ke go haka noka kinai, ka te pegea nimaa igho ki te Spirit Tapu kago he'e haka noka kinai. ");
INSERT INTO mnv_vpl VALUES ("LK12_11","072_12_11","LUK","12","11","11","“Te gholoba kago kakabe ai ia te koutou ki na Hage hai paaunga pona gahumanu ma na hakahua ke hai lobo ai ia te koutou, ogo noka tautou maikia ai poe hai ke go kohea na haka soi ia te koutou poe hai ke go kohea autou gegea. ");
INSERT INTO mnv_vpl VALUES ("LK12_12","072_12_12","LUK","12","12","12","Iteme'agaa te Spirit Tapu te hai ke go ako e Ia i te gholoba na nia te hai koutou go gegea ai.” ");
INSERT INTO mnv_vpl VALUES ("LK12_13","072_12_13","LUK","12","13","13","Noko iai te pegea i te haka putu 'anga noko hai atu kia Jesus, “Ako, hai atu ki toku taina ke baghigua amaa me'a noko tuha e temaua tamana kia te kimaaua.” ");
INSERT INTO mnv_vpl VALUES ("LK12_14","072_12_14","LUK","12","14","14","Ka ko Jesus noko haka tau o hai atu kinai, “Te pegea na, koai te tuku ia te Au kau haka totonu 'ia ia te kougua, ma te kau baghigua 'ia augua me'a ia te kougua?” ");
INSERT INTO mnv_vpl VALUES ("LK12_15","072_12_15","LUK","12","15","15","Kae hai atu ma'u a Jesus kia te kigatou, “Na'ana'a atu! Ma te ge'o gaoi atu ia te koutou ki ba'i haka maa'ina, iteme'agaa te ma'ugi o te pegea e he'e hai i ba'i ga'unga hai eia, masi'igoa koia e hu'ai ga'u.” ");
INSERT INTO mnv_vpl VALUES ("LK12_16","072_12_16","LUK","12","16","16","Ko Jesus noko 'atigongo kia te kigatou i te haka gaataki nei: “Te launatasi tangata ga'u noko hai tena kunga kege o tanu ai ana me'a o hu'ai me'aa gaoi ma te hai hua gaoi. ");
INSERT INTO mnv_vpl VALUES ("LK12_17","072_12_17","LUK","12","17","17","Ma te konei ana haka tu'u hai tegeu'a ake, ‘Niaa gaa e hai kau hai 'ia i te kua he'e tau kunga ke 'ati kinai aku hua 'umanga?’ ");
INSERT INTO mnv_vpl VALUES ("LK12_18","072_12_18","LUK","12","18","18","“Ma te konei ana tegeu'a, ‘Tenei te hai 'anga e hai kau hai 'ia: E hai ke ebeebe toku hage tuku me'aa, ka ke haka tu'u ni hu'ai hage, o 'ati kinai ko ba'i hua 'umanga a'aku, ma gaa me'a gaoi a'aku. ");
INSERT INTO mnv_vpl VALUES ("LK12_19","072_12_19","LUK","12","19","19","Kae hai kau go konei aku gea kia te au: “Ko koe e hu'ai 'eha au me'a gaoi haka putu ki na ghapu kago a'u. Oki oki iho, na'e kua haingaohie, o noko kai, ma te binu, ma te noko siasia.” ’ ");
INSERT INTO mnv_vpl VALUES ("LK12_20","072_12_20","LUK","12","20","20","“Ka ko te 'Aitu noko kogaa ana to'o atu kia te ia: ‘Ko koe te pegea noanoa! Te poo nei ko koe e hai ke mate ai, ka koai te hai ke sui ki au me'a noko ta'anga haka putu ma'au launatasi?’ ” ");
INSERT INTO mnv_vpl VALUES ("LK12_21","072_12_21","LUK","12","21","21","“Manga konei na noho na pegea e haka putu ko ba'i ga'unga kia te kigatou kae e he'e ga'u i te pa'asi o te 'Aitu.” ");
INSERT INTO mnv_vpl VALUES ("LK12_22","072_12_22","LUK","12","22","22","Kae hai atu a Jesus ki ona pegea haka ako, “Tenei te hai 'anga e hai kau gea ai kia te koutou: Noka tautou maikia ki outou ma'ugi, nia e hai koutou go kai 'ia, po outou tino, nia e hai koutou go mamago ai. ");
INSERT INTO mnv_vpl VALUES ("LK12_23","072_12_23","LUK","12","23","23","Na ma'ugi te me'a haka saga o sigi i na utunga, ma na tino te me'a haka saga o sigi i na laoa. ");
INSERT INTO mnv_vpl VALUES ("LK12_24","072_12_24","LUK","12","24","24","Tegeu'a atu ki na manu he gegei: e he'e sanga o he'e utu, o he'e tau hage tuku utunga; ka manga haangai e te 'Aitu ia te kigatou. Ka koutou e hu'ai tau babae e te 'Aitu o sigi i na manu! ");
INSERT INTO mnv_vpl VALUES ("LK12_25","072_12_25","LUK","12","25","25","'Ai koai ia te koutou e maikia ka 'aonga te beegaba eia mo'ona ni 'aso ke noko ma'ugi ai? ");
INSERT INTO mnv_vpl VALUES ("LK12_26","072_12_26","LUK","12","26","26","Nimaa haingata'a te hai e koutou te mi'i hai 'anga nei, 'eaa e maikia ai koutou ki gaa me'a ma'u? ");
INSERT INTO mnv_vpl VALUES ("LK12_27","072_12_27","LUK","12","27","27","“ 'Ai tegeu'a atu ki na mi'i mouku e ngasongo ake o laka. Ko kigatou he'e hai hekau o he'e lapui. Ka ko Au e hai atu kia te koutou, masi'igoa ko Solomon te pegea ga'u, ka noko he'e mago i ni me'a gaoi ke noho pe na laka o na mi'i mouku nei. ");
INSERT INTO mnv_vpl VALUES ("LK12_28","072_12_28","LUK","12","28","28","Ka nimaa konaa na haa mago e te 'Aitu na mi'i mouku i ona laka manga noho i te 'aso nei, kae seu ki te ahi i te 'aso 'ao, 'ai e he'e tegeu'a ake a koutou ko te 'Aitu e taubabae ia te koutou o haa mago ia te koutou? Na sano o'outou hu'ai mi'i me'a! ");
INSERT INTO mnv_vpl VALUES ("LK12_29","072_12_29","LUK","12","29","29","Kae noka tautou hiina'i manga maikia po nia kago kai poe bibinu ai. ");
INSERT INTO mnv_vpl VALUES ("LK12_30","072_12_30","LUK","12","30","30","Te ta'u pegea he'e sogi o te kege nei, e hu'ai maikia i te ta'u hai 'anga nei, ka te Tamana o'outou manga na'a e Ia na me'a e siahahai kinai koutou. ");
INSERT INTO mnv_vpl VALUES ("LK12_31","072_12_31","LUK","12","31","31","Mataa sasaga atu e koutou te Hakahua 'anga a te 'Aitu, ka ke go 'abatu beegaba e Ia na me'a nei kia te koutou. ");
INSERT INTO mnv_vpl VALUES ("LK12_32","072_12_32","LUK","12","32","32","“Te mi'i tu'uganga nei, noka tautou matataku, na'e te Tamana o'outou hu'ai siahai ke haiga'a kia te koutou te nuku o'ona. ");
INSERT INTO mnv_vpl VALUES ("LK12_33","072_12_33","LUK","12","33","33","Tuku atu autou 'ota'ota ke tau'i o 'aabaki ai ki na pegea lae. Pipiki ake ma'autou ni oko oko he'e 'aonga te motumotu, na'e te kunga tuku me'a gaoi i te gangi, e si'ai he pegea kaia'a hano o hitaiaki kinai, o si'ai ma'u ni kagakuba ke kai e kigatou. ");
INSERT INTO mnv_vpl VALUES ("LK12_34","072_12_34","LUK","12","34","34","Iteme'agaa tehea te kunga tuku me'a gaoi o'outou, tenaa te kunga manga iai na uso o'outou ma'u. ");
INSERT INTO mnv_vpl VALUES ("LK12_35","072_12_35","LUK","12","35","35","“Koutou ngaague atu o nono'a outou ake ke ma'u, ma te tutu atu autou peba ke noko kaa, ");
INSERT INTO mnv_vpl VALUES ("LK12_36","072_12_36","LUK","12","36","36","ke noho pe na pegea hitagi i tegatou hakahua e hokimai i te kainga hai ki te noohonga. Te 'aso kago hetae mai ai, o tukituki ake ai te titingi, kae ghali a kigatou o luga iho te aga kia te ia. ");
INSERT INTO mnv_vpl VALUES ("LK12_37","072_12_37","LUK","12","37","37","Kago gaoi to'a ki na pegea haihekau te a'u 'anga te hakahua o kite ia te kigatou manga mata i tena 'aso a'u ai. Ko Au e 'atigongo maa'ogi atu kia te koutou, te hakahua nei e hai ke go nono'a tena ake ke ma'u, kae hai eia ia te kigatou o noho 'aki ki te kunga kai, kae a'u o hai hekau kinai. ");
INSERT INTO mnv_vpl VALUES ("LK12_38","072_12_38","LUK","12","38","38","Masi'igoa ko te hakahua kago a'u i te tu'u gua poo pote 'ago ke 'ao, kago gaoi to'a ki na pegea haihekau te a'u 'anga a ia o kite ia te kigatou, manga ngaague. ");
INSERT INTO mnv_vpl VALUES ("LK12_39","072_12_39","LUK","12","39","39","Kae na'a ake te hai 'anga nei: Te hakahua o te hage poi na'a eia te gholoba e hai ke a'u ai te tangata kaia'a, kua he'e 'aonga te tuku tena hage ke tuki eia. ");
INSERT INTO mnv_vpl VALUES ("LK12_40","072_12_40","LUK","12","40","40","Koutou ma'u e gaoi i te ngaague, iteme'agaa te Hosa o Pegea e hai ke go a'u i he 'aso he'e tegeu'a ake a koutou ka he'e a'u ai.” ");
INSERT INTO mnv_vpl VALUES ("LK12_41","072_12_41","LUK","12","41","41","Ko Peter noko hakaanu, “Hakahua, ko Koe manga 'atigongo i te haka gaataki nei kia te kimatou po ko ba'i pegea?” ");
INSERT INTO mnv_vpl VALUES ("LK12_42","072_12_42","LUK","12","42","42","Te Hakahua noko haka tau o hai atu kinai, “Koai te ge'osanga e maa'ogi ma te 'igo'igo e hai ke go tuku e tena hakahua ke ge'o o na guani ma te tuha kinai eia agatou tuhanga i na utunga i ona 'aso mogimogi? ");
INSERT INTO mnv_vpl VALUES ("LK12_43","072_12_43","LUK","12","43","43","Kago hu'ai gaoi ki te pegea hai hekau e kite e te hakahua manga konei ona noho i te 'aso hoki mai o'ona. ");
INSERT INTO mnv_vpl VALUES ("LK12_44","072_12_44","LUK","12","44","44","Ko Au e gea maa'ogi atu kia te koutou, te hakahua e hai ke go tuku ia te ia o hakahua i ba'i me'a a'ana. ");
INSERT INTO mnv_vpl VALUES ("LK12_45","072_12_45","LUK","12","45","45","Ka nimaa hai ake te guani kia te ia: ‘Toku hakahua ka hu'ai noho goa i tena hai 'anga ke hokimai.’ Kae haka tu'u kogu eia na guani taangata ma na guani haahine, ka manga kai ma te binu o gigi bogu. ");
INSERT INTO mnv_vpl VALUES ("LK12_46","072_12_46","LUK","12","46","46","Te hakahua o te pegea hai hekau kago a'u i he 'ao he'e mata ai ma he gholoba he'e na'a eia, o tobago ia te ia, kae tuku ki te kunga o na pegea he'e too kia te ia. ");
INSERT INTO mnv_vpl VALUES ("LK12_47","072_12_47","LUK","12","47","47","“Te pegea hai hekau e na'a eia na paaunga a tena hakahua, ka manga he'e ngaague ma te he'e hai eia nia e siahai kinai tena hakahua, e hai ke go kogu haka 'eha. ");
INSERT INTO mnv_vpl VALUES ("LK12_48","072_12_48","LUK","12","48","48","Ka te guani e he'e na'a eia nia te siahai kinai tena hakahua, o manga hai eia na me'a e 'aonga tena kagohia ai, koia e hai ke go mi'i kogu. Te pegea kua haiga'a kinai na me'a o 'eha, e hai ke go haka ene kinai ini me'a ke 'eha, ka te pegea noko sama kinai a pegea o tuku me'a kia te ia o 'eha, e hai ke go haka ene 'aki giu kia te ia ini me'a ke hu'ai 'eha. ");
INSERT INTO mnv_vpl VALUES ("LK12_49","072_12_49","LUK","12","49","49","“Ko Au e a'u e to'o mai e Au te ahi ki te kege nei, ka ko Au manga haka nau i te poi na 'oti i te tutu! ");
INSERT INTO mnv_vpl VALUES ("LK12_50","072_12_50","LUK","12","50","50","Kae e iai te haa gogomi 'anga e hai ke go hai kia te Au, e hu'ai mamaha kia te Au, naakupu ki te aano hai o 'oti. ");
INSERT INTO mnv_vpl VALUES ("LK12_51","072_12_51","LUK","12","51","51","Koutou e tegeu'a ake, ko Au e a'u ma te goto maagie ki te kege nei? Si'ai, ko Au e hai atu kia te koutou, ko Au e a'u kau tuhatuha 'ia a pegea. ");
INSERT INTO mnv_vpl VALUES ("LK12_52","072_12_52","LUK","12","52","52","Haka tu'u i te 'aso nei o hano, kago iai te toka gima i te kaugaba e tasi, kago tuhatuha o haka makau ia te kigatou takitasi. Te toka togu ka go haka makau te toka gua, kae sui te toka gua o haka makau te toka togu. ");
INSERT INTO mnv_vpl VALUES ("LK12_53","072_12_53","LUK","12","53","53","Ko kigatou kago he'e goto tasi: Ko te tamana kago haka makau ia tena hosa, kae sui a tena hosa o haka makau ia te tamana. Kae haka makau e te tinana ia tena tama 'ahine, kae sui a tena tama 'ahine o haka makau ia te tinana. Kae haka makau e te tinana hungabai ia tena tama 'ahine hungabai, kae sui a tena tama 'ahine hungabai o haka makau ia tena tinana hungabai.” ");
INSERT INTO mnv_vpl VALUES ("LK12_54","072_12_54","LUK","12","54","54","Ko Jesus noko hai atu ki te 'apitanga, “Te gholoba e hiina'i atu ai koutou ki te tu'unga'ao e sopo ake i gago, kago ghali koutou o hai ake, ‘Ka 'ua,’ ma te maa'ogi o 'ua. ");
INSERT INTO mnv_vpl VALUES ("LK12_55","072_12_55","LUK","12","55","55","Nimaa pusi te oko mai tu'ahenua, hai ake koutou, ‘Ka bebega,’ ma te maa'ogi o bebega. ");
INSERT INTO mnv_vpl VALUES ("LK12_56","072_12_56","LUK","12","56","56","Koutou na pegea haka tomu'a! E na'a te hogahoga e koutou na noho o te kege nei ma te 'agohi gangi, ka 'eaa koutou he'e 'aonga te hogahoga ai na noho o na 'aso nei? ");
INSERT INTO mnv_vpl VALUES ("LK12_57","072_12_57","LUK","12","57","57","“ 'Eaa e he'e haka totonu ai e koutou na me'a ke maa'ogi? ");
INSERT INTO mnv_vpl VALUES ("LK12_58","072_12_58","LUK","12","58","58","Nimaa a'u he pegea makau kia te koe o kakabe ia te koe ke koti, hai lobo atu e koe te haka tinogaoi kinai i te gholoba manga boo ai kougua i te aga, ka ke go noka te huhuti eia ia te koe ki te haka aba, ma te haka soko e te haka aba ia te koe ki na pegea hai tau'a, o sui na pegea hai tau'a o tuku ia te koe ki te kunga o na pegea kagohia. ");
INSERT INTO mnv_vpl VALUES ("LK12_59","072_12_59","LUK","12","59","59","Ko Au e hai atu kia te koe, ko koe ka he'e hano 'aatea ai aano 'io haka 'oti te me'a e toe i te tau'i o'ou.” ");
INSERT INTO mnv_vpl VALUES ("LK13_1","072_13_1","LUK","13","1","1","E iai na pegea noko noho 'aki i na 'aso na, noko 'atigongo kia Jesus i na pegea mai Galilee, noko taa e Pilate o haka higohigo eia ogatou toto kia agatou giunga noko hai kia te 'Aitu. ");
INSERT INTO mnv_vpl VALUES ("LK13_2","072_13_2","LUK","13","2","2","Ko Jesus noko haka tau o hai atu, “Na pegea mai Galilee nei na konaa na taa 'ia, kae tegeu'a ake koutou na pegea nei noko 'oosongo o sigi i gaa pegea ma'u i Galilee? ");
INSERT INTO mnv_vpl VALUES ("LK13_3","072_13_3","LUK","13","3","3","Ko Au e hai atu kia te koutou, Si'ai! Koutou ma'u, nimaa he'e he keu 'aki giu mai i outou 'oosongo, koutou e hai ke go mamate ma'u. ");
INSERT INTO mnv_vpl VALUES ("LK13_4","072_13_4","LUK","13","4","4","Po te tino anga hugu tuma'a e bagu noko mamate i te 'aso noko too ai te taoa i Siloam o ta'ota'o ia te kigatou? E tegeu'a ake koutou ko kigatou na pegea noko hu'ai maase'i o sigi i gaa pegea manga noho 'aki i Jerusalem? ");
INSERT INTO mnv_vpl VALUES ("LK13_5","072_13_5","LUK","13","5","5","Ko Au e hai atu kia te koutou, Si'ai! Koutou ma'u nimaa he'e he keu 'aki giu mai i outou 'oosongo, koutou e hai ke go mamate ma'u.” ");
INSERT INTO mnv_vpl VALUES ("LK13_6","072_13_6","LUK","13","6","6","Ko Jesus noko 'atigongo i te launatasi haka gaataki: “Te launatasi tangata noko hai tena 'umanga o tanu ai eia te ga'akau e mate te ‘fig’. Koia noko hano o sasaga hua ai, ka noko si'ai ai ni me'a ke kite ai. ");
INSERT INTO mnv_vpl VALUES ("LK13_7","072_13_7","LUK","13","7","7","Ma te hano o hai atu ki te pegea noko manga ge'o eia te 'umanga, ‘Tenei te togunga ghapu a'u ai au o sasaga hua i te ga'akau nei, o he'e kite ai ni me'a. Tua atu ke too, na'e tangani hai songo eia te kege!’ ");
INSERT INTO mnv_vpl VALUES ("LK13_8","072_13_8","LUK","13","8","8","“Te ge'o sanga o te 'umanga noko haka tau o hai atu kinai, ‘Hakahua, tuku atu ke mataa noho mo'ona he ghapu e tasi, ka kau go kegi mugheghi 'ia ke hetauaki i ni me'a ke hai hua. ");
INSERT INTO mnv_vpl VALUES ("LK13_9","072_13_9","LUK","13","9","9","Ka ke go nimaa tau hua i tegaa ghapu, gaoi! Ka nimaa go si'ai, kago tua ke too.’ ” ");
INSERT INTO mnv_vpl VALUES ("LK13_10","072_13_10","LUK","13","10","10","I te tasi 'Ao oki oki ko Jesus noko manga ako ai i te launatasi Hage hai paaunga. ");
INSERT INTO mnv_vpl VALUES ("LK13_11","072_13_11","LUK","13","11","11","Ka noko iai te launatasi hahine noko iai te haagiki songo noko hai eia o sanga songo o katoa tuma'a e bagu ona ghapu. Koia noko piko te tu'a o he'e 'aonga te tu'u haka tinogaoi. ");
INSERT INTO mnv_vpl VALUES ("LK13_12","072_13_12","LUK","13","12","12","Nimaa ina 'atu a Jesus kia te ia ma te haka pogo atu ai o a'u, ma te hai atu kinai, “Ta'ahine, ko koe kua tausu'u i tou masaki.” ");
INSERT INTO mnv_vpl VALUES ("LK13_13","072_13_13","LUK","13","13","13","Kae haka eke atu na gima o Jesus i 'agunga ia te ia ma te ghali o tu'u haka tinogaoi o haka e'eha eia a te 'Aitu. ");
INSERT INTO mnv_vpl VALUES ("LK13_14","072_13_14","LUK","13","14","14","Te hakahua o te Hage hai paaunga noko 'ika'ika kia Jesus i te haka ma'ugi 'anga e Ia te pegea i te 'Ao oki oki ma te kogaa ana to'o atu ki te 'apitanga, “E toka ono 'ao e 'aonga te hai hekau ai. Boomai o hetauaki i na 'ao na, kae noka te hai i te 'Ao oki oki.” ");
INSERT INTO mnv_vpl VALUES ("LK13_15","072_13_15","LUK","13","15","15","Ko Jesus noko haka tau kia te ia o hai atu, “Koutou na pegea haka tomu'a! Koai ia te koutou e he'e huhuke tena buluka po tena donki i te kunga haangai, kae kakabe o haa binu i te 'Ao oki oki? ");
INSERT INTO mnv_vpl VALUES ("LK13_16","072_13_16","LUK","13","16","16","Kae he'e hai ki te hahine nei, te pegea i te hanohano o Abraham, ka kua manga hakahua hua e Satan i te katoa tuma'a e bagu ghapu. 'Ai e he'e gaoi i te hai 'anga o tausu'u i te 'Ao oki oki?” ");
INSERT INTO mnv_vpl VALUES ("LK13_17","072_13_17","LUK","13","17","17","Te gholoba noko konei na gea ai a Jesus, ko ba'i makau o'ona na papa'a, ka te 'apitanga noko magagaohie i ba'i hai 'anga gaoi kua hai e Ia. ");
INSERT INTO mnv_vpl VALUES ("LK13_18","072_13_18","LUK","13","18","18","Ko Jesus noko haka anu o hai atu, “Te Hakahua 'anga a te 'Aitu manga noho pe niaa? E hai kau kohea na haka papata 'ia? ");
INSERT INTO mnv_vpl VALUES ("LK13_19","072_13_19","LUK","13","19","19","Te Hakahua 'anga a te 'Aitu manga noho pe te mi'i hatu me'a o te ga'akau e ingoa te ‘mustard’, e to'o e te pegea tena hatu o tanu i tena 'umanga, o ngasogo ake o hai ai te hu'ai ga'akau, kae boomai na manu o te 'agohi gangi o haka tokatoka i ona ga'a.” ");
INSERT INTO mnv_vpl VALUES ("LK13_20","072_13_20","LUK","13","20","20","Ko Jesus noko haka anu hoki kia te kigatou o hai atu, “E hai kau kohea na haka papata 'ia te Hakahua 'anga a te 'Aitu? ");
INSERT INTO mnv_vpl VALUES ("LK13_21","072_13_21","LUK","13","21","21","Te hakahua 'anga a te 'Aitu manga noho pe te me'a e tuku ki na palaoa o tupu, noko to'o e te hahine o natu haka pigi ki na palaoa o tuku o mataa noho aano tupu na palaoa ngatahi.” ");
INSERT INTO mnv_vpl VALUES ("LK13_22","072_13_22","LUK","13","22","22","Ko Jesus noko mugi o hano o agatu'u i ba'i hu'ai manaha ma na mi'i manaha o noko manga ako ai i tena hano 'anga i te aga ki Jerusalem. ");
INSERT INTO mnv_vpl VALUES ("LK13_23","072_13_23","LUK","13","23","23","Noko iai te pegea noko haka anu kia te Ia o hai atu, “Hakahua, 'ai kago he'e 'eha pegea ke go maa'ugi?” Ma te hai atu a Jesus kia te kigatou, ");
INSERT INTO mnv_vpl VALUES ("LK13_24","072_13_24","LUK","13","24","24","“He gotu 'aki atu koutou ogo boo ki goto i te aga 'ago kapikapi, iteme'agaa ko Au e hai atu kia te koutou, e 'api kago hai lobo kigatou boo ki goto o he'e 'aonga te hai. ");
INSERT INTO mnv_vpl VALUES ("LK13_25","072_13_25","LUK","13","25","25","Kago ghali te hakahua o te hage o 'aga o titingi te aga. Ka koutou kago tutu'u i tu'a ogo tukituki ake te aga ma te hai ake kinai, ‘Hakahua, luga mai te aga nei kia te kimatou.’ Ka koia kago haka tau o kogaa ana to'o, ‘He'e na'a eau ia te koutou, po koutou e boomai i hea.’ ");
INSERT INTO mnv_vpl VALUES ("LK13_26","072_13_26","LUK","13","26","26","“Ka koutou kago mugi o kogaa autou to'o atu kinai, ‘Ko kimatou noko manga kai ma te bibinu haka pigi kia te koe, ma te ako koe i omatou manaha.’ ");
INSERT INTO mnv_vpl VALUES ("LK13_27","072_13_27","LUK","13","27","27","“Ka koia kago haka tau o hai atu, ‘E he'e na'a eau ia te koutou po koutou e boomai i hea. Koutou boo atu ia te au, na'e koutou na pegea hai hai 'anga songo!’ ");
INSERT INTO mnv_vpl VALUES ("LK13_28","072_13_28","LUK","13","28","28","“Kago noko magegepe ma te he taangisi 'aki ai na niho i te 'aso kago hiina'i ai koutou kia Abraham, ma Isaac, ma Jacob, ma ba'i taauga i te kunga e haka hua ai a te 'Aitu, ka koutou te hai ke go seu ki taha. ");
INSERT INTO mnv_vpl VALUES ("LK13_29","072_13_29","LUK","13","29","29","Ko ba'i pegea kago boomai i matangi ma gago ma bagikaago ma bagitakugu, o noho 'aki o kai i te kunga e haka hua ai a te 'Aitu. ");
INSERT INTO mnv_vpl VALUES ("LK13_30","072_13_30","LUK","13","30","30","Na pegea noko mumugi e hai ke go mumu'a, ka na pegea noko mumu'a e hai ke go mumugi.” ");
INSERT INTO mnv_vpl VALUES ("LK13_31","072_13_31","LUK","13","31","31","Noko iai na Pharisee noko boomai kia Jesus i te 'aso na, o hai atu kia te Ia, “Hinatu i tenei o hano ki he kunga, na'e ko Herod e gotu ke taa eia ia te Koe.” ");
INSERT INTO mnv_vpl VALUES ("LK13_32","072_13_32","LUK","13","32","32","Ka ko Jesus noko haka tau kia te kigatou o hai atu, “Boo atu o hogahoga ki te pegea mou to'o, na'e ko Au e hai kau noko pagepage haagiki ma te haka ma'ugi pegea i te 'aso nei ma te 'aso 'ao, ka nimaa te togunga 'ao 'io 'oti aku hekau. ");
INSERT INTO mnv_vpl VALUES ("LK13_33","072_13_33","LUK","13","33","33","Nimaa iai he hai 'anga, ko Au ka manga pau o hai hekau i te 'aso nei ma te 'aso 'ao ma tegaa 'ao, iteme'agaa e si'ai he taauga ke mate i tu'a i Jerusalem! ");
INSERT INTO mnv_vpl VALUES ("LK13_34","072_13_34","LUK","13","34","34","“Jerusalem, Jerusalem, koutou na taa e koutou na taauga ma te 'aumahu e koutou i na hatu na pegea noko haka to'o mai e te 'Aitu kia te koutou o mamate. Tahia 'aso e hakanau kau haka putu ai 'ia koutou ngatahi kia te Au, ke noho pe te paolo hahine e haka putu ana punua o poghi i na kapakau, ka noko he'e mamaka a koutou. ");
INSERT INTO mnv_vpl VALUES ("LK13_35","072_13_35","LUK","13","35","35","Na'a ake, na'e te manaha o 'outou nei kago pau o maase'i. Ko Au e hai atu kia te koutou, koutou kago he'e hiina'i giu kia te Au aano kogaa autou to'o, ‘Te hakagaoi kia te Ia noko a'u i te ingoa o te 'Aitu.’ ” ");
INSERT INTO mnv_vpl VALUES ("LK14_1","072_14_1","LUK","14","1","1","Te launatasi 'Ao oki oki, ko Jesus noko hano ai ke kai i te hage o te launatasi hutiaki o na Pharisee, ka noko mata pipiki e kigatou ia Jesus. ");
INSERT INTO mnv_vpl VALUES ("LK14_2","072_14_2","LUK","14","2","2","Ka noko manga i 'ago ia te Ia te launatasi pegea masaki huhuga na ba'e ma na gima. ");
INSERT INTO mnv_vpl VALUES ("LK14_3","072_14_3","LUK","14","3","3","Ko Jesus noko haka anu ki na Pharisee ma na ako o na tagangonga o hai atu kinai, “Na tagangonga e tuku ke haka ma'ugi pegea i te 'Ao oki oki po si'ai?” ");
INSERT INTO mnv_vpl VALUES ("LK14_4","072_14_4","LUK","14","4","4","Ka ko kigatou noko manga hiina'i he'e gegea, ma te 'oso a Jesus ki te pegea o hai e Ia o ma'ugi kae tuku o hano. ");
INSERT INTO mnv_vpl VALUES ("LK14_5","072_14_5","LUK","14","5","5","Kae mugi a Jesus o hai atu kia te kigatou, “Poi iai he pegea ia te koutou e hai mo'ona he hosa po he buluka, ka kua too ki he pupu'a i te 'Ao oki oki, 'ai ka he'e ghali ia o sa'u haka hoki ake?” ");
INSERT INTO mnv_vpl VALUES ("LK14_6","072_14_6","LUK","14","6","6","Ko kigatou noko he'e 'aonga te gegea ini hai 'anga. ");
INSERT INTO mnv_vpl VALUES ("LK14_7","072_14_7","LUK","14","7","7","Nimaa na'a e Jesus kogaa pegea i na usunga manga ligo kunga gaoi o nonoho ai o kai, ma te gea kinai a Jesus i te launatasi haka gaataki: ");
INSERT INTO mnv_vpl VALUES ("LK14_8","072_14_8","LUK","14","8","8","“Ko koe nimaa haka pogo 'ia ki he haka tahinga ki he noohonga hai ho'ou, noka tau hano o noho ki he noho 'anga gaoi, na'e mano e iai he pegea hakahua o sigi ia te koe kua haka pogo 'ia. ");
INSERT INTO mnv_vpl VALUES ("LK14_9","072_14_9","LUK","14","9","9","Nimaa konei na noho, te pegea e hai ana utunga o pogo aki ia te kougua ngatahi kago a'u o hai atu kia te koe, ‘Tuku ake te tangata nei ke noho i te kunga e noho ai koe na.’ Ko koe kago pa'a ma te hano o noho i te noho 'anga i te kege. ");
INSERT INTO mnv_vpl VALUES ("LK14_10","072_14_10","LUK","14","10","10","Ka ko koe nimaa haka pogo 'ia, hinatu o noho ki gago, ka ke go nimaa a'u te tangata e hai ana utunga o hai atu kia te koe, ‘Hemasi'inga, hinatu o noho i te kunga e gaoi.’ Ko koe kago maatanga gaoi ai i 'ago i gaa pegea tege gongo ai ke kai. ");
INSERT INTO mnv_vpl VALUES ("LK14_11","072_14_11","LUK","14","11","11","Ko ba'i pegea haka ma'u 'agunga ia te kigatou e hai ke go tuku gago, ka koai e tuku gago ia te ia e hai ke go haka ma'u 'agunga.” ");
INSERT INTO mnv_vpl VALUES ("LK14_12","072_14_12","LUK","14","12","12","Ma te mugi a Jesus o hai atu ki te pegea e hai ana utunga, “Ko koe nimaa hai ke haangai ma'au ni pegea i he 'ao 'atea po he ahiahi, ogo noka te manga haka pogo au hemasi'inga, po te 'api o'ou, po tou hohoga 'anga, po na pegea o'ou e pata mai e hu'ai ga'u. Nimaa konei au hai kinai, e hai ke go sui kigatou o haka pogo ia te koe ma te giu'aki kia te koe. ");
INSERT INTO mnv_vpl VALUES ("LK14_13","072_14_13","LUK","14","13","13","Ka ko koe nimaa hai ma'au he haka tahinga, haka pogo atu na pegea lae, ma na pegea taa haka pikipiki, ma na pegea seu, ma na pegea kikibi. ");
INSERT INTO mnv_vpl VALUES ("LK14_14","072_14_14","LUK","14","14","14","Ka ke go haka gaoi ai kia te koe, iteme'agaa kago giu'aki e te 'Aitu kia te koe i te 'aso kago maa'ugi giu ai na pegea gaoi.” ");
INSERT INTO mnv_vpl VALUES ("LK14_15","072_14_15","LUK","14","15","15","Te gholoba na haka gongo kinai te launatasi i na pegea noko manga noho 'aki haka pigi kia Jesus i te kunga kai, koia noko hai atu kia Jesus, “Te hu'ai magaohie ki te pegea kago noho o kai i te kunga e haka hua ai a te 'Aitu.” ");
INSERT INTO mnv_vpl VALUES ("LK14_16","072_14_16","LUK","14","16","16","Ma te haka tau a Jesus o hai atu kia te ia, “Noko iai te launatasi tangata noko ngaague tena hu'ai haka tahinga, kae haka pogo kinai ba'i pegea ke boomai o kai ai. ");
INSERT INTO mnv_vpl VALUES ("LK14_17","072_14_17","LUK","14","17","17","Nimaa hetae ki te 'aso o te haka tahinga, hakato'o tena guani o hano te gongo i na pegea na 'oti i te haka pogo o hai atu kinai, ‘Boomai, na'e ko ba'i me'a kua 'oti i te ngaague.’ ");
INSERT INTO mnv_vpl VALUES ("LK14_18","072_14_18","LUK","14","18","18","“Ka ko kigatou na sa'aki o taki hai haka tupenga. Te pegea mu'a noko kogaa na to'o, ‘Koau te'itoo tau'i nei toku kungaa kege, kae hai kau hano o ina kinai. Tenei to'oku haka tupenga.’ ");
INSERT INTO mnv_vpl VALUES ("LK14_19","072_14_19","LUK","14","19","19","“Hai atu ma'u tegaa, ‘Koau te'itoo tau'i nei taku tino anga hugu buluka, kae hano kinai ke hai lobo ia te kigatou. Na'a mai na'e tenei to'oku haka tupenga.’ ");
INSERT INTO mnv_vpl VALUES ("LK14_20","072_14_20","LUK","14","20","20","“Nimaa hai atu ma'u tegaa, ‘Koau te'itoo hai nei toku uguugu, ko au he'e hinatu ai.’ ");
INSERT INTO mnv_vpl VALUES ("LK14_21","072_14_21","LUK","14","21","21","“Te guani na hoki o 'atigongo ai ki tena hakahua, ma te 'ika'ika te hakahua o te hage kae hai atu ki tena guani, ‘Hinatu ghali ki na hu'ai agatu'u ma na mi'i aga baasi'a o te manaha, o kakabe mai ai ni pegea lae, ma ni pegea taa haka pikipiki, ma ni pegea kikibi, ma ni pegea seu.’ ");
INSERT INTO mnv_vpl VALUES ("LK14_22","072_14_22","LUK","14","22","22","“Te guani na hokimai o hai atu, ‘Hakahua, nia noko gea kinai koe, kua 'oti i te hai, ka koi 'eha kunga manga koi toe.’ ");
INSERT INTO mnv_vpl VALUES ("LK14_23","072_14_23","LUK","14","23","23","“Ma te hai atu te hakahua ki tena guani, ‘Hinatu ki na agatu'u ma ba'i kunga noho mugheghi i te manaha o hai ki ba'i pegea ke haka putu mai ki toku hage ke honu ai. ");
INSERT INTO mnv_vpl VALUES ("LK14_24","072_14_24","LUK","14","24","24","Koau e hai atu kia te koutou: Ka si'ai he launatasi i na pegea noko mataa haka pogo ke a'u o kai i taku kainga.’ ” ");
INSERT INTO mnv_vpl VALUES ("LK14_25","072_14_25","LUK","14","25","25","Noko hu'ai 'api pegea noko tata'o ia Jesus, ka noko keu mai kia te kigatou o hai atu kinai, ");
INSERT INTO mnv_vpl VALUES ("LK14_26","072_14_26","LUK","14","26","26","“Poi iai he pegea a'u kia te Au, ka he'e ti'aki ia te tamana ma te tinana, ma tena uguugu, ma ana tama giki, ma ona ta'okete, ma ona taina, ma ona tuhaahine, po koai ma'u, koia he'e toku pegea haka ako. ");
INSERT INTO mnv_vpl VALUES ("LK14_27","072_14_27","LUK","14","27","27","Te pegea nimaa he'e to'o tena kros o tata'o tu'a ia te Au, koia he'e toku pegea haka ako. ");
INSERT INTO mnv_vpl VALUES ("LK14_28","072_14_28","LUK","14","28","28","“Poi iai he pegea ia te koutou e siahai ke 'ati mo'ona he hu'ai hage ma'u 'agunga, 'ai koia he'e mataa noho o haka mamanu te 'eha 'anga o ana mane po ka 'aonga te hai ai ke 'oti? ");
INSERT INTO mnv_vpl VALUES ("LK14_29","072_14_29","LUK","14","29","29","Iteme'agaa poi manga haka taahoga e koe tena haka tu'usanga kae he'e hai ke 'oti, ko ba'i pegea kago hiina'i kinai o sogo ai kia te koe. ");
INSERT INTO mnv_vpl VALUES ("LK14_30","072_14_30","LUK","14","30","30","O hai ake, ‘Te pegea nei noko haka tu'u 'ati tena hage o he'e 'aonga te hai ke 'oti.’ ");
INSERT INTO mnv_vpl VALUES ("LK14_31","072_14_31","LUK","14","31","31","“Ka poi iai he hakahua e siahai ke hano o hai tau'a ki tegaa hakahua, 'ai koia ka he'e mataa noho o hai tegeu'a, po koia ma tena katoa noa (10,000) pegea e na'a te kanai ki tegaa, e a'u ma tena gua hugu noa (20,000) pegea, ke haka hetata'i kinai? ");
INSERT INTO mnv_vpl VALUES ("LK14_32","072_14_32","LUK","14","32","32","Poi ina 'iho e he'e 'aonga, manga kaunaki eia he tuku muna ke boo i te gholoba koi mama'o ai tegaa hakahua, ke haka ene 'aki kinai he 'aso ke he tanu 'aki ai. ");
INSERT INTO mnv_vpl VALUES ("LK14_33","072_14_33","LUK","14","33","33","Manga konei na noho ma'u, na pegea ia te koutou e he'e ti'aki ba'i me'a hai e kigatou, ko kigatou he'e 'aonga te hai ai oku pegea haka ako. ");
INSERT INTO mnv_vpl VALUES ("LK14_34","072_14_34","LUK","14","34","34","“Na solo e gaoi ki na utunga, ka poi he'e kitea tena kona 'anga e hai ke kohea na hai ke kona hoki? ");
INSERT INTO mnv_vpl VALUES ("LK14_35","072_14_35","LUK","14","35","35","Ka he'e 'aonga te tuku ki te kege, po ke tuku ki na me'a haka ma'ugi 'umanga, kae pau o seu. Koai e hai na taginga ke hakagongo ai, haka gongo ake ai!” ");
INSERT INTO mnv_vpl VALUES ("LK15_1","072_15_1","LUK","15","1","1","Na pegea tibu takis ma gaa pegea 'oosongo noko haka putu ngatahi o haka gongo kia Jesus. ");
INSERT INTO mnv_vpl VALUES ("LK15_2","072_15_2","LUK","15","2","2","Ka na Pharisee ma na ako o na tagangonga noko 'uigago o hai ake, “Te pegea nei e sia haka masi'i ki na pegea 'oosongo ma te kai haka pigi kia te kigatou.” ");
INSERT INTO mnv_vpl VALUES ("LK15_3","072_15_3","LUK","15","3","3","Ma te 'atigongo a Jesus kia te kigatou i te launatasi haka gaataki, o hai atu, ");
INSERT INTO mnv_vpl VALUES ("LK15_4","072_15_4","LUK","15","4","4","“Poi iai he pegea ia te koutou e hai ma'ana he gau sipisipi, kae he'e kitea te launatasi ia te kigatou, 'ai ka he'e tuku eia te tino iba tuma'a e iba i te kunga manga haangai ai, kae hano o sasaga te me'a kua he'e kitea aano kite eia? ");
INSERT INTO mnv_vpl VALUES ("LK15_5","072_15_5","LUK","15","5","5","Te 'aso e kite ai, koia hu'ai magaohie ai, ma te sa'u ake o haka eke ki na honga uma, ");
INSERT INTO mnv_vpl VALUES ("LK15_6","072_15_6","LUK","15","6","6","o to'o haka hoki ki te manaha. Koia kago pogo 'aki i ana hemasi'inga ma ona pegea e taha mai ngatahi o boomai, kae hai atu kinai, ‘Sisia 'aabaki mai kia te au, na'e taku sipisipi noko he'e kitea kua kite.’ ");
INSERT INTO mnv_vpl VALUES ("LK15_7","072_15_7","LUK","15","7","7","Ko Au e hai atu kia te koutou, manga konei na noho te hu'ai sisia 'anga a te gangi i te pegea 'oosongo kua sui tegeu'a o sigi i te tino iba tuma'a e iba (99) pegea gaoi e he'e hai ke sui tegeu'a ke gaoi. ");
INSERT INTO mnv_vpl VALUES ("LK15_8","072_15_8","LUK","15","8","8","“Po e iai he hahine e hai ma'ana he katoa mane kae he'e kitea he launatasi, 'ai ka he'e tutu eia he peba ma te tahitahi te hage o ligo gaoi eia aano kite? ");
INSERT INTO mnv_vpl VALUES ("LK15_9","072_15_9","LUK","15","9","9","Te 'aso e kite ai, koia e pogo 'aki i ana hemasi'inga ma ona pegea e pata mai o boo ngatahi mai, kae hai atu kinai, ‘Koutou sisia 'aabaki mai kia te au, na'e taku mane noko he'e kitea kua kite.’ ");
INSERT INTO mnv_vpl VALUES ("LK15_10","072_15_10","LUK","15","10","10","Ko Au e hai atu kia te koutou, manga konaa na noho na sisia 'anga na ensel o te 'Aitu i he launatasi pegea sui tegeu'a ke gaoi.” ");
INSERT INTO mnv_vpl VALUES ("LK15_11","072_15_11","LUK","15","11","11","Ko Jesus noko manga koi gea o hai atu, “Noko iai te launatasi tangata noko hai tena toka gua hosa. ");
INSERT INTO mnv_vpl VALUES ("LK15_12","072_15_12","LUK","15","12","12","Te hai taina noko hai atu kia te tamana, ‘Tamau, 'aumai toku baaenga noko tuku e koe i au ga'unga.’ Ma te baghigua eia ana ga'unga ia te kigaaua. ");
INSERT INTO mnv_vpl VALUES ("LK15_13","072_15_13","LUK","15","13","13","“Nimaa he'e taunga gogoa kae haka putu e te hosa hai taina ko ba'i me'a a'ana o to'o, o hano ki te kakai 'anga mama'o, o maumau ai ana ga'unga ki ba'i hai 'anga songo. ");
INSERT INTO mnv_vpl VALUES ("LK15_14","072_15_14","LUK","15","14","14","Nimaa 'oti i te haiga'a ba'i me'a a'ana, kae hetae mai te hu'ai ongesau ki te kakai 'anga ngatahi, ma te haka tu'u tena sanga maase'i. ");
INSERT INTO mnv_vpl VALUES ("LK15_15","072_15_15","LUK","15","15","15","Koia na hano o haka ene ki te pegea o te kakai 'anga o hai hekau kinai, ma te tuku eia o hano o haangai ana piki. ");
INSERT INTO mnv_vpl VALUES ("LK15_16","072_15_16","LUK","15","16","16","Koia noko gotu ke kai ma'ana 'isi i na utunga noko manga kai e na piki, ka noko si'ai he pegea 'abange ma'ana ni me'a. ");
INSERT INTO mnv_vpl VALUES ("LK15_17","072_15_17","LUK","15","17","17","“Koia na mugi o hai tegeu'a, ma te kogaa ana to'o ake, ‘E hia gaa pegea manga hai hekau kia tamau, ma te hai ma'agatou ni utunga o 'eha, ka ko au te ka mate nei i te ongea! ");
INSERT INTO mnv_vpl VALUES ("LK15_18","072_15_18","LUK","15","18","18","Koau e hai kau tu'u o hoki kia tamau, kau go kogaa na to'o atu kia te ia, “Tamau, ko au kua 'oosongo kia te 'Aitu ma koe. ");
INSERT INTO mnv_vpl VALUES ("LK15_19","072_15_19","LUK","15","19","19","Ko au kua he'e 'aonga te mate tou hosa. Hai mai ia te au ke manga noho pe na pegea manga hai hekau kia te koe.” ’ ");
INSERT INTO mnv_vpl VALUES ("LK15_20","072_15_20","LUK","15","20","20","Kae tu'u o hoki kia te tamana. “Te gholoba noko manga koi mama'o ai, kae ina 'atu ai a te tamana kia te ia, ko ia na hu'ai 'agoha kinai. Ma te tege atu kia tena hosa, o gagaba mai i na gima o sosongi ai. ");
INSERT INTO mnv_vpl VALUES ("LK15_21","072_15_21","LUK","15","21","21","“Ka ko tena hosa noko kogaa ana to'o atu kia te ia, ‘Tamau, ko au kua 'oosongo kia te 'Aitu ma koe, ko au kua he'e 'aonga te mate tou hosa.’ ");
INSERT INTO mnv_vpl VALUES ("LK15_22","072_15_22","LUK","15","22","22","“Ka ko te tamana noko hai atu ki ona guani, ‘Ghali atu, o to'o mai he ake gaoi o haa mago ai ia te ia. Tango atu he ghagha lobo ki te maninia gima, ma ni taka ba'e ki gua tapungao. ");
INSERT INTO mnv_vpl VALUES ("LK15_23","072_15_23","LUK","15","23","23","Kae to'o mai te buluka momona o taa ke hai ai ma'atatou he kainga ma te kitatou sisia. ");
INSERT INTO mnv_vpl VALUES ("LK15_24","072_15_24","LUK","15","24","24","Iteme'agaa tenei toku hosa noko mate, ka kua ma'ugi hoki. Koia noko he'e kitea, ka kua kite haka hoki.’ Ma te haka tu'u sisia a kigatou. ");
INSERT INTO mnv_vpl VALUES ("LK15_25","072_15_25","LUK","15","25","25","“Te 'aso na, te hosa hai ta'okete noko manga i mouku. Te gholoba noko hano ai ia o hitaiaki ki te hage, kae haka gongo ki na pegea manga taugua ma te tau'aso. ");
INSERT INTO mnv_vpl VALUES ("LK15_26","072_15_26","LUK","15","26","26","Ma te ngege atu i tegaa i na guani o haka anu kia te ia o hai atu, ‘Niaa te hai nei?’ ");
INSERT INTO mnv_vpl VALUES ("LK15_27","072_15_27","LUK","15","27","27","Haka tau te guani o hai atu, ‘Ko te taiu kua hokimai, ka kua taa kinai e te tamau te buluka e momona, iteme'agaa e hai ake ia, ko tena hosa kua hoki sanga gaoi mai.’ ");
INSERT INTO mnv_vpl VALUES ("LK15_28","072_15_28","LUK","15","28","28","“Te hosa hai ta'okete na 'ika'ika o he'e maka ke ugu ki goto i te hage, ma te sopo iho kinai a te tamana o sasaka kinai. ");
INSERT INTO mnv_vpl VALUES ("LK15_29","072_15_29","LUK","15","29","29","Ka koia noko haka tau kia te tamana o hai atu kinai, ‘Ina mai! Ko ba'i ghapu ko au manga haka sa'ohie ai kia te koe o he'e 'aonga taku he'e maka ki au gea 'anga, kae he'e 'aumai ma'u e koe ma'aku he punua nane goti ke hai ai ma'aku he kainga ki aku hemasi'inga. ");
INSERT INTO mnv_vpl VALUES ("LK15_30","072_15_30","LUK","15","30","30","Nimaa te hokimai 'anga tou hosa na maumau eia au ga'unga ki na haahine maasoko, taa kinai e koe te buluka momona!’ ");
INSERT INTO mnv_vpl VALUES ("LK15_31","072_15_31","LUK","15","31","31","“Ma te hai atu a te tamana, ‘Tama, ko kitaaua gua pegea manga haka pata 'aki, ko ba'i me'a hai eau 'au me'a. ");
INSERT INTO mnv_vpl VALUES ("LK15_32","072_15_32","LUK","15","32","32","Ka ko kitatou manga 'aonga te magagaohie ma te sisia, iteme'agaa tenei a te taiu na mate, ka kua ma'ugi hoki. Koia noko he'e kitea ka kua kite.’ ” ");
INSERT INTO mnv_vpl VALUES ("LK16_1","072_16_1","LUK","16","1","1","Ko Jesus noko 'atigongo ki ona pegea haka ako o hai atu, “Noko iai te launatasi tangata ga'u, noko hai tena pegea ge'o me'a kinai, ka na manga hegeu maase'i kinai i te hai songo eia na ga'unga a te hakahua o'ona. ");
INSERT INTO mnv_vpl VALUES ("LK16_2","072_16_2","LUK","16","2","2","Ma te pogo 'aki ia te ia o haka anu kinai o hai atu, ‘Niaa te haka gongo kinai au i te manga hegeu ai kia te koe? 'Atigongo mai i na me'a noko ge'o e koe, na'e ko koe e hai ke 'oti i te ge'o me'a.’ ");
INSERT INTO mnv_vpl VALUES ("LK16_3","072_16_3","LUK","16","3","3","“Ka te pegea ge'o me'a noko tegeu'a ake, ‘Niaa gaa e hai kau hai 'ia? Toku hakahua ka sa'u haka hoki eia taku hekau, ka ko au te pegea he'e haka 'ao'ao ki te kegi gua, ko au e pa'a ki te haka ene ma'u. ");
INSERT INTO mnv_vpl VALUES ("LK16_4","072_16_4","LUK","16","4","4","E na'a eau te hai 'anga e hai kau hai 'ia, ka nimaa go he'e hai taku hekau, manga hai aku hemasi'inga ke go kumu ia te au ma te haka pogo ia te au ki ogatou hage.’ ");
INSERT INTO mnv_vpl VALUES ("LK16_5","072_16_5","LUK","16","5","5","“Te pegea ge'o me'a noko pogo 'aki i ba'i pegea to'o me'a ka ke go sui ki te hakahua o boomai, ma te hai atu ki te pegea noko mataa a'u, ‘E toka hia au me'a noko to'o ka ke go sui ki toku hakahua?’ ");
INSERT INTO mnv_vpl VALUES ("LK16_6","072_16_6","LUK","16","6","6","“Ka koia noko haka tau o hai atu, ‘Te bagunga gau (800) galon oela.’ “Te pegea ge'o me'a noko hai atu, ‘Noho iho, o sa'u ake tau buka o ghali o sui o kanukanu kinai he haanga gau (400).’ ");
INSERT INTO mnv_vpl VALUES ("LK16_7","072_16_7","LUK","16","7","7","“Kae hai atu ki te pegea noko gua kinai, ‘Noko hia 'au me'a noko to'o ka ke go sui?’ “Koia noko haka tau o hai atu, ‘Te noa (1,000) kete witi hohonu ngatahi.’ “Hai atu te pegea ge'o me'a, ‘Sa'u ake tau buka o sui o kanukanu kinai he bagunga gau (800).’ ");
INSERT INTO mnv_vpl VALUES ("LK16_8","072_16_8","LUK","16","8","8","“Te hakahua noko magaohie ki te pegea he'e maa'ogi i te noko gaoi ana maanatu o hai ai eia na hai 'anga. Iteme'agaa na pegea he'e sogi o te kege nei e hai maanatu gaoi o sigi i na pegea o te maagama. ");
INSERT INTO mnv_vpl VALUES ("LK16_9","072_16_9","LUK","16","9","9","Ko Au e hai atu kia te koutou, hai atu na ga'unga o te kege nei o hai ai ma'autou ni hemasi'inga, ka ke go nimaa go 'oti autou ga'unga, ka kego haka pogo ia te koutou ki na kunga noho 'aki goa. ");
INSERT INTO mnv_vpl VALUES ("LK16_10","072_16_10","LUK","16","10","10","“Te pegea nimaa maa'ogi ki na mi'i hai 'anga, e hai ke go maa'ogi ki na hu'ai hai 'anga, ka te pegea e he'e maa'ogi i na mi'i hai 'anga, e hai ke go he'e maa'ogi ma'u i na hu'ai hai 'anga. ");
INSERT INTO mnv_vpl VALUES ("LK16_11","072_16_11","LUK","16","11","11","Ka koutou nimaa he'e sama kinai i na ga'unga o te kege nei, koai e hai ke sama kia te koutou i na ga'unga maa'ogi? ");
INSERT INTO mnv_vpl VALUES ("LK16_12","072_16_12","LUK","16","12","12","Ka koutou nimaa he'e sanomia i te ge'o e koutou ni me'a ma'a ni pegea, 'ai koai kago 'aonga te 'abatu ma'autou ni me'a?! ");
INSERT INTO mnv_vpl VALUES ("LK16_13","072_16_13","LUK","16","13","13","“E si'ai he guani ke hai hekau ki he toka gua hakahua, iteme'agaa kago gotoa'a ki tegaa, kae ma'ine ki tegaa. Poe maa'ogi ki tegaa kae haka mi'i me'a atu tegaa. Koutou ka he'e hai hekau ki na mane ma te 'Aitu i te gholoba e tasi.” ");
INSERT INTO mnv_vpl VALUES ("LK16_14","072_16_14","LUK","16","14","14","Na Pharisee, noko maa'ine ki na mane, noko haka gongo ki na hai 'anga nei, ma te putatai ai kigatou kia Jesus. ");
INSERT INTO mnv_vpl VALUES ("LK16_15","072_16_15","LUK","16","15","15","Ka ko Jesus noko hai atu kia te kigatou, “Konaa koutou manga hai ia te koutou ke gaoi ki na mata o pegea, ka manga na'a e te 'Aitu outou uso. Nia e tegeu'a ake a pegea e hu'ai gaoi kia te kigatou, e ina kinai a te 'Aitu e hu'ai maase'i. ");
INSERT INTO mnv_vpl VALUES ("LK16_16","072_16_16","LUK","16","16","16","“Na tagangonga a Moses ma na kanukanu 'anga ana taauga noko tuiaki ia te kigatou, o hano aano hetae ki na 'aso o John Baptist. Haka tu'u i na gholoba na, te Gongo Gaoi o te Hakahua 'anga a te 'Aitu noko ma tohi'aki ai. Ka ko ba'i pegea manga taki he gotu 'aki kigatou memene kinai. ");
INSERT INTO mnv_vpl VALUES ("LK16_17","072_16_17","LUK","16","17","17","E hu'ai haingaohie te nimo a te gangi ma te kege nei, o sigi i te poi haka noka e he pegea he mi'i kupu i na tagangonga. ");
INSERT INTO mnv_vpl VALUES ("LK16_18","072_16_18","LUK","16","18","18","“Te pegea nimaa maabae ma tena uguugu, kae sui o nonoho ma tegaa hahine, koia e saga kia tena uguugu. Ka te pegea nimaa pipiki eia te hahine noko maabae ma tena matu'a, koia e saga ki te matu'a o te hahine. ");
INSERT INTO mnv_vpl VALUES ("LK16_19","072_16_19","LUK","16","19","19","“Noko iai te launatasi tangata ga'u noko haka gosigosi i na ake uga sesenga o noko manga noho haka sagasaga i ba'i 'aso. ");
INSERT INTO mnv_vpl VALUES ("LK16_20","072_16_20","LUK","16","20","20","Ka noko iai te launatasi tangata lae, tena ingoa ko Lazarus, noko hu'ai maka ina, koia noko manga kakabe mai o tuku i te aga ki te hage o te tangata ga'u. ");
INSERT INTO mnv_vpl VALUES ("LK16_21","072_16_21","LUK","16","21","21","Tegaa tena siahai ke noko kai eia na momo utunga hetoki iho i te kunga kai o te tangata ga'u. Ka na tokitoki ma'u te noko manga taetae ona maka. ");
INSERT INTO mnv_vpl VALUES ("LK16_22","072_16_22","LUK","16","22","22","“Nimaa hetae ki te 'aso na mate ai a Lazarus, na ensel noko kakabe ia te ia o noko manga haka pata kia Abraham. Ka te tangata ga'u na mate ma'u o tanu. ");
INSERT INTO mnv_vpl VALUES ("LK16_23","072_16_23","LUK","16","23","23","Koia noko noho i te ugaimami o hu'ai haka gongo songo ai. Koia noko ina haka tu'u, ma te kite atu eia ia Abraham ki mama'o ka manga noho a Lazarus o haka pata kinai. ");
INSERT INTO mnv_vpl VALUES ("LK16_24","072_16_24","LUK","16","24","24","Ma te ngege atu te tangata ga'u kia te ia o hai atu, ‘Tamau Abraham, 'agoha mai ia te au o tuku ia Lazarus ke a'u o tuku te maninia gima ki he bai o haka gogohi ai toku 'agego, na'e ko au e haka gongo songo i te ahi nei.’ ");
INSERT INTO mnv_vpl VALUES ("LK16_25","072_16_25","LUK","16","25","25","“Ka ko Abraham noko haka tau kinai o hai atu, ‘Tama, 'ai maanatu atu ki ou 'aso noko manga ma'ugi ai, noko manga ga'u me'a gaoi ai koe, ka ko Lazarus noko manga ga'u me'a maase'i ai, ka te gholoba nei koia e sui o magaohie, ka ko koe e sui o haka gongo songo. ");
INSERT INTO mnv_vpl VALUES ("LK16_26","072_16_26","LUK","16","26","26","Tegaa tasi hai 'anga ma'u, e noho goto ia te kitatou te hu'ai pupu'a he'e ngato. E hai ngata'a ai he pegea ia te kimatou siahai ke hinatu kia te koutou, kae haingata'a ma'u te a'u he pegea ia te koutou.’ ");
INSERT INTO mnv_vpl VALUES ("LK16_27","072_16_27","LUK","16","27","27","“Ka te tangata ga'u noko haka tau o hai ake, ‘Koau e sasaka ake kia te koe, tamau, tuku iho ia Lazarus ke hano ki te hage o tamau. ");
INSERT INTO mnv_vpl VALUES ("LK16_28","072_16_28","LUK","16","28","28","Na'e manga iai toku toka gima taina, kae hai ke hano ia, o baa gongo ke go noka te boomai ki te kunga o te haka gongo songo nei.’ ");
INSERT INTO mnv_vpl VALUES ("LK16_29","072_16_29","LUK","16","29","29","“Ka ko Abraham noko haka tau o hai atu, ‘Manga hai e kigatou na buka a Moses ma na taauga, tuku atu kigatou haka gongo kinai.’ ");
INSERT INTO mnv_vpl VALUES ("LK16_30","072_16_30","LUK","16","30","30","“Ka te tangata ga'u noko hai ake, ‘Tamau Abraham, si'ai! Ka poi iai he pegea mate o ma'ugi hoki o hano kia te kigatou, ko kigatou ma sui tegeu'a.’ ");
INSERT INTO mnv_vpl VALUES ("LK16_31","072_16_31","LUK","16","31","31","“Ka ko Abraham noko haka tau o hai atu kinai, ‘Ko kigatou nimaa he'e haka gongo ki na gea 'anga a Moses ma na taauga, masi'igoa e ma'ugi hoki he pegea i na mamate 'anga, ka ko kigatou he'e 'aonga te sui maanatu ai.’ ” ");
INSERT INTO mnv_vpl VALUES ("LK17_1","072_17_1","LUK","17","1","1","Ko Jesus noko hai atu ki ona pegea haka ako, “Na me'a e baaghaghi a pegea o 'oosongo e hai ke go boomai, kae haka 'aagoha te pegea kago maa'ogi ia o hai. ");
INSERT INTO mnv_vpl VALUES ("LK17_2","072_17_2","LUK","17","2","2","Kago gaoi i te taugaki he hu'ai hatu ki te u'a o tupe ki te moana, o sigi i te hai eia he launatasi i na mi'i pegea nei o 'oosongo. ");
INSERT INTO mnv_vpl VALUES ("LK17_3","072_17_3","LUK","17","3","3","Kae ge'o gaoi atu ia te koutou! “Ko te taiu nimaa hai 'oosongo kia te koe, gea atu kinai ke noka te hai; ka nimaa sui tegeu'a, haka noka atu kinai. ");
INSERT INTO mnv_vpl VALUES ("LK17_4","072_17_4","LUK","17","4","4","Ma si'igoa e 'oosongo haka hitu kia te koe i he 'ao e tasi, kae hoki haka hitu mai kia te koe o hai atu, ‘Koau kua sui tegeu'a,’ ogo haka noka atu kinai.” ");
INSERT INTO mnv_vpl VALUES ("LK17_5","072_17_5","LUK","17","5","5","Na pegea haka to'o noko hai atu kia te Hakahua, “Hai mai tematou sano ke hua'eha soo atu!” ");
INSERT INTO mnv_vpl VALUES ("LK17_6","072_17_6","LUK","17","6","6","Ka ko Jesus noko haka tau o hai atu, “Koutou poi sano o kogaa na noho te iai na mi'i hatu o te ga'akau e mate te ‘mustard’, koutou ma 'aonga te hai atu ki te hu'ai ga'akau nei, ‘Abu ake ia te koe o tanu i te moana!’ Kago 'aonga te maangao kia te koutou. ");
INSERT INTO mnv_vpl VALUES ("LK17_7","072_17_7","LUK","17","7","7","“Poi iai he launatasi ia te koutou e hai mo'ona he guani o ganga i mo'ona he 'umanga, po e ge'o ma'ana ni sipisipi, 'ai koia kago na'a te kogaa ana hai atu ki tena guani i te 'aso e hetae hoki iho ai i tena 'umanga, ‘A'u o noho o kai’?! ");
INSERT INTO mnv_vpl VALUES ("LK17_8","072_17_8","LUK","17","8","8","'Ai koia ka he'e mataa konei ana gea atu kinai, ‘Ngaague atu ma'aku ni utunga ki te ahiahi nei, kae manga hitagi mai ka kau mataa kai ma te binu, 'io mugi koe o kai ma te binu’? ");
INSERT INTO mnv_vpl VALUES ("LK17_9","072_17_9","LUK","17","9","9","'Ai koia ka na'a te haka 'aue ki te guani, iteme'agaa kua hai eia nia e gea kinai ia ke hai?! ");
INSERT INTO mnv_vpl VALUES ("LK17_10","072_17_10","LUK","17","10","10","Manga konaa ma'u autou noho, te gholoba kago hai ai e koutou ko ba'i me'a tuku kia te koutou ke hai, e hai ke go kogaa autou to'o, ‘Ko kimatou manga na guani maase'i; ko kimatou noko manga hai amatou hekau.’ ” ");
INSERT INTO mnv_vpl VALUES ("LK17_11","072_17_11","LUK","17","11","11","Te hano 'anga a Jesus ki Jerusalem, noko hano i te noho goto 'anga o Samaria ma Galilee. ");
INSERT INTO mnv_vpl VALUES ("LK17_12","072_17_12","LUK","17","12","12","Nimaa tena hano 'anga ki tegaa manaha, ko Ia na bilaabei ma te tino anga hugu pegea kahoa. Ko kigatou noko tutu'u mama'o, ");
INSERT INTO mnv_vpl VALUES ("LK17_13","072_17_13","LUK","17","13","13","o hu'ai ngengege o hai atu, “Jesus, Hakahua! 'Agoha mai kia te kimatou!” ");
INSERT INTO mnv_vpl VALUES ("LK17_14","072_17_14","LUK","17","14","14","Te gholoba noko ina 'atu ai a Jesus, ko Ia noko hai atu kinai, “Boo atu, o haka 'agi ia te koutou ki na priest.” Nimaa boo a kigatou, ma te kite iho ia te kigatou kua ma'a. ");
INSERT INTO mnv_vpl VALUES ("LK17_15","072_17_15","LUK","17","15","15","Te launatasi ia te kigatou na kite iho koia kua mahu, ma te hoki o hu'ai ngege haka e'eha ia te 'Aitu. ");
INSERT INTO mnv_vpl VALUES ("LK17_16","072_17_16","LUK","17","16","16","Koia na a'u o guti ki na ba'e o Jesus o haka 'aue kinai — ka koia te pegea mai Samaria. ");
INSERT INTO mnv_vpl VALUES ("LK17_17","072_17_17","LUK","17","17","17","Ko Jesus noko haka anu o hai atu, “Te katoa pegea te kua hai o ma'a, 'ai kohea tegaa toka iba? ");
INSERT INTO mnv_vpl VALUES ("LK17_18","072_17_18","LUK","17","18","18","E si'ai he pegea e tasi ke hokimai o haka e'eha ia te 'Aitu, ka manga te taka tahea nei?” ");
INSERT INTO mnv_vpl VALUES ("LK17_19","072_17_19","LUK","17","19","19","Ma te hai atu a Jesus kia te ia, “Tu'u ake o hano, te sano o'ou kua hai ia te koe o gaoi.” ");
INSERT INTO mnv_vpl VALUES ("LK17_20","072_17_20","LUK","17","20","20","Noko iai na Pharisee noko haka anuanu 'aki kia Jesus po tehea te 'aso kago hetae mai ai te Hakahua 'anga a te 'Aitu, ka noko haka tau kinai a Jesus o hai atu, “Te Hakahua 'anga a te 'Aitu he'e te hai 'anga ke a'u ke hiina'i kinai, ");
INSERT INTO mnv_vpl VALUES ("LK17_21","072_17_21","LUK","17","21","21","po ke kogaa na hai ake te 'apitanga: ‘Tenei, te manga i te kunga nei!’ po ‘Tegaa, te manga i te kungaa,’ iteme'agaa te Hakahua 'anga a te 'Aitu manga noho i goto ia te koutou.” ");
INSERT INTO mnv_vpl VALUES ("LK17_22","072_17_22","LUK","17","22","22","Ko Jesus noko hai atu ki ona pegea haka ako, “Na 'aso kago a'u, koutou kago siahahai ke hiina'i ai ki he 'ao i na 'aso o te Hosa o Pegea, ka kago he'e hiina'i kinai koutou. ");
INSERT INTO mnv_vpl VALUES ("LK17_23","072_17_23","LUK","17","23","23","Kago iai ni pegea kago hai atu kia te koutou, ‘Tegaa a Ia!’ po e hai atu, ‘Tenei a Ia!’ 'ogo noka tautou tata'o ai. ");
INSERT INTO mnv_vpl VALUES ("LK17_24","072_17_24","LUK","17","24","24","Iteme'agaa te 'ao o te Hosa o Pegea kago manga noho pe te 'uiga, e kemo o maagama ai te agohi gangi o a'u i tegaa potu o hetae ki tegaa potu. ");
INSERT INTO mnv_vpl VALUES ("LK17_25","072_17_25","LUK","17","25","25","Ka ko Ia e hai ke go mataa tiha'ia ki ba'i hai 'anga ma te he'e siahahai kinai na 'atu tangata o na 'aso nei. ");
INSERT INTO mnv_vpl VALUES ("LK17_26","072_17_26","LUK","17","26","26","“Manga noho pe na 'aso o Noah, e hai ke go kogaa na noho ma'u na 'aso o te Hosa o Pegea: ");
INSERT INTO mnv_vpl VALUES ("LK17_27","072_17_27","LUK","17","27","27","Ko ba'i pegea noko manga kai ma te bibinu ma te hai uguugu ma te hai matu'a o hano aano hetae ki te 'aso na ugu ai a Noah ki te ‘ark’, kae mugi te honunga o hetae mai o haka masogo ia te kigatou ngatahi. ");
INSERT INTO mnv_vpl VALUES ("LK17_28","072_17_28","LUK","17","28","28","“Manga noho ma'u pena 'aso o Lot: Ko ba'i pegea noko manga kai ma te bibinu, ma te tau'i me'a ma te hetau'i me'a 'aki, ma te sanga me'a ma te 'ati me'a. ");
INSERT INTO mnv_vpl VALUES ("LK17_29","072_17_29","LUK","17","29","29","Ka nimaa te 'aso na hano ai a Lot i Sodom, te ahi ma te 'ua hatu na hetoki iho mai te gangi o haka masogo ia te kigatou ngatahi. ");
INSERT INTO mnv_vpl VALUES ("LK17_30","072_17_30","LUK","17","30","30","“Manga kogaa na noho te 'ao kago haka 'agitino ai te Hosa o Pegea. ");
INSERT INTO mnv_vpl VALUES ("LK17_31","072_17_31","LUK","17","31","31","Te gholoba na, te pegea nimaa noho i te hohonga o te hage o'ona, koia kago he'e hinaiho o to'o ana me'a gaoi i goto i tena hage. Manga kogaa na noho ma'u, te pegea nimaa noho i mouku, koia kago he'e hoki o to'o he me'a i tena hage. ");
INSERT INTO mnv_vpl VALUES ("LK17_32","072_17_32","LUK","17","32","32","Maanatu atu ki te uguugu o Lot! ");
INSERT INTO mnv_vpl VALUES ("LK17_33","072_17_33","LUK","17","33","33","Te pegea nimaa siahai ke ge'o te ma'ugi o'ona, kago he'e kitea, ka koai e tuku te ma'ugi o'ona kia te Au, koia kago ma'ugi. ");
INSERT INTO mnv_vpl VALUES ("LK17_34","072_17_34","LUK","17","34","34","Ko Au e hai atu kia te koutou: Te poo na, kago momoe ai te toka gua pegea i he kaainga e tasi. Kago kakabe tegaa, kae noho tegaa. ");
INSERT INTO mnv_vpl VALUES ("LK17_35","072_17_35","LUK","17","35","35","Kago iai gua haahine go hai utunga ngatahi. Kago kakabe tegaa, kae noho tegaa. ");
INSERT INTO mnv_vpl VALUES ("LK17_36","072_17_36","LUK","17","36","36","Kago iai te toka gua pegea i mouku. Kago kakabe tegaa, kae noho tegaa.” ");
INSERT INTO mnv_vpl VALUES ("LK17_37","072_17_37","LUK","17","37","37","Ona pegea haka ako noko haka anu 'aki kia te Ia o hai atu, “Hakahua, tehea te kunga e hai ke go hai ai?” Ka ko Ia noko haka tau o hai atu, “Te kunga e takoto ai te tino kua mate, tegaa te kunga kago haka putu kinai na manu kai manu hetoogohi mamate.” ");
INSERT INTO mnv_vpl VALUES ("LK18_1","072_18_1","LUK","18","1","1","Ko Jesus noko 'atigongo i te launatasi haka gaataki ki ona pegea haka ako ke tuiaki ai ia te kigatou ke noko haka hano te taakunga, ka ke noka te he lologi 'aki o maau'i. ");
INSERT INTO mnv_vpl VALUES ("LK18_2","072_18_2","LUK","18","2","2","Ko Ia noko hai atu, “Noko iai te launatasi manaha noko noho ai te tangata haka aba pegea, noko he'e pago kia te 'Aitu ma na tegeu'a a pegea. ");
INSERT INTO mnv_vpl VALUES ("LK18_3","072_18_3","LUK","18","3","3","Ka noko iai ma'u te hahine magepe i te manaha, noko a'u goa kia te ia i ba'i 'aso o hai atu kinai, ‘Haka tinogaoi mai te hai 'anga e noho goto ia te au ma toku makau.’ ");
INSERT INTO mnv_vpl VALUES ("LK18_4","072_18_4","LUK","18","4","4","“Noko 'eha 'aso noko he'e maka kinai, ka nimaa tegaa 'aso koia noko kogaa na tegeu'a ake: ‘Masi'igoa ko au he'e pago kia te 'Aitu ma na tegeu'a a pegea, ");
INSERT INTO mnv_vpl VALUES ("LK18_5","072_18_5","LUK","18","5","5","kae naato'o i te a'u goa te hahine magepe nei o baa tu'ia goa ia te au, e hai kau 'aabaki kinai ke gaoi, ka ke go noka te hoki mai o haka mumuna ia te au.’ ” ");
INSERT INTO mnv_vpl VALUES ("LK18_6","072_18_6","LUK","18","6","6","Ka ko Jesus noko konei ana gea, “Haka gongo atu ki te pegea hakaaba maase'i e konei ana gea. ");
INSERT INTO mnv_vpl VALUES ("LK18_7","072_18_7","LUK","18","7","7","'Ai ko te 'Aitu he'e 'aonga te haka tinogaoi e Ia na noho o na pegea ligo o'ona, manga tatangi kia te Ia i na 'ao ma na poo? 'Ai ko Ia ka he'e 'aonga te 'aabaki kinai? ");
INSERT INTO mnv_vpl VALUES ("LK18_8","072_18_8","LUK","18","8","8","Ko Au e hai atu kia te koutou: Ko te 'Aitu kago 'aonga te haka tinogaoi ghali e Ia na hai 'anga ana pegea o'ona. Ka te gholoba kago a'u ai te Hosa o Pegea, kago kite e Ia te sano i te kege nei?” ");
INSERT INTO mnv_vpl VALUES ("LK18_9","072_18_9","LUK","18","9","9","Ko Jesus noko 'atigongo ma'u i te launatasi haka gaataki ki na pegea tegeu'a ake ko kigatou e hu'ai tinogaoi, kae tuku gago e kigatou kogaa pegea, o hai atu, ");
INSERT INTO mnv_vpl VALUES ("LK18_10","072_18_10","LUK","18","10","10","“Te toka gua taangata noko haka neke ki te Hage Tapu kigaua taakunga ai. Tegaa te Pharisee ka tegaa te pegea tibu takis. ");
INSERT INTO mnv_vpl VALUES ("LK18_11","072_18_11","LUK","18","11","11","Te Pharisee noko tu'u haka babae o manga taakunga o hai ake: ‘Te 'Aitu, ko au e 'aue kia te Koe ia te au he'e noho pe gaa pegea e kaia'a, ma te hai hai 'anga maase'i, ma te kaia'a na uguugu ogaa, poe konei aku noho te iai te pegea tibu takis nei. ");
INSERT INTO mnv_vpl VALUES ("LK18_12","072_18_12","LUK","18","12","12","Koau he'e kai i te sogi i te guanga 'ao i na 'ao, ma te haiga'a eau kia te Koe te katoa o ba'i me'a a'aku.’ ");
INSERT INTO mnv_vpl VALUES ("LK18_13","072_18_13","LUK","18","13","13","“Ka te pegea tibu takis noko tu'u mai mama'o. Koia noko he'e ta'aki te 'ugu ke ina ki te gangi, ka noko manga paa paa te hatahata, kae hai ake, ‘Te 'Aitu, 'agoha mai ia te au, na'e ko au te pegea 'oosongo ina.’ ” ");
INSERT INTO mnv_vpl VALUES ("LK18_14","072_18_14","LUK","18","14","14","Ma te hai atu a Jesus, “Ko Au e hai atu kia te koutou: Te pegea nei kua tinogaoi o sigi i tegaa i te 'aso na hoki ai ki tena manaha. Iteme'agaa na pegea haka ma'u 'agunga ia te kigatou e hai ke go tuku gago, ka koai e haka ma'ugago ia te ia e hai ke go haka ma'u 'agunga.” ");
INSERT INTO mnv_vpl VALUES ("LK18_15","072_18_15","LUK","18","15","15","Noko iai na pegea noko kakabe mai agatou mi'i tama giki kia Jesus ke 'oso kinai ma te haka gaoi ia te kigatou. Nimaa hiina'i kinai na pegea haka ako, ma te gehu kia te kigatou. ");
INSERT INTO mnv_vpl VALUES ("LK18_16","072_18_16","LUK","18","16","16","Ka ko Jesus noko ngege i na tama giki o boomai kia te Ia, kae hai atu, “Tuku iho na mi'i tama giki ke boomai kia te Au, kae noka te susugi, na'e te Hakahua 'anga a te 'Aitu e tuku ki na pegea e konei na noho. ");
INSERT INTO mnv_vpl VALUES ("LK18_17","072_18_17","LUK","18","17","17","Ko Au e gea maa'ogi kia te koutou, te pegea nimaa he'e ga'u eia te Hakahua 'anga a te 'Aitu ke noho pe te mi'i tama 'iti'iti, kago he'e sopo kinai.” ");
INSERT INTO mnv_vpl VALUES ("LK18_18","072_18_18","LUK","18","18","18","Te launatasi hutiaki noko haka anu kia Jesus o hai atu, “Ako gaoi, niaa e 'aonga taku hai 'ia kau ga'u ai 'ia te ma'ugi noho goa?” ");
INSERT INTO mnv_vpl VALUES ("LK18_19","072_18_19","LUK","18","19","19","Ma te haka tau a Jesus o hai atu kinai, “ 'Eaa e hai mai koe ko Au e gaoi? E si'ai he pegea gaoi ka manga ko te 'Aitu launatasi. ");
INSERT INTO mnv_vpl VALUES ("LK18_20","072_18_20","LUK","18","20","20","E na'a e koe na tagangonga: ‘Noka te 'oosongo a taangata ma haahine, noka tau taa pegea, noka tau kaia'a, noka tau 'ati gongo goi, haka e'eha atu ia te tamau ma te tinau.’ ” ");
INSERT INTO mnv_vpl VALUES ("LK18_21","072_18_21","LUK","18","21","21","Ka koia noko haka tau o hai atu, “Na me'a nei manga pipiki mai eau i taku tamatama 'anga.” ");
INSERT INTO mnv_vpl VALUES ("LK18_22","072_18_22","LUK","18","22","22","Nimaa haka gongo a Jesus ki tena gea 'anga nei, ma te hai atu kia te ia, “E iai te me'a e tasi koi he'e hai e koe. Tuku atu ba'i me'a hai e koe ke tau'i o 'aabaki ai ki na pegea lae, ka ke go hai ma'au ni ga'unga ke 'eha i te gangi, kae a'u o tata'o mai ia te Au.” ");
INSERT INTO mnv_vpl VALUES ("LK18_23","072_18_23","LUK","18","23","23","Te gholoba na haka gongo ai te tangata ki te gea 'anga nei, koia na hu'ai agoha ai, iteme'agaa koia noko hu'ai 'eha ana ga'unga. ");
INSERT INTO mnv_vpl VALUES ("LK18_24","072_18_24","LUK","18","24","24","Ko Jesus noko ina 'atu kia te ia ma te hai atu kinai, “E hu'ai haingata'a ki he pegea ga'u te hano ki goto i te Hakahua 'anga a te 'Aitu. ");
INSERT INTO mnv_vpl VALUES ("LK18_25","072_18_25","LUK","18","25","25","E mi'i haingaohie te ‘camel’ te mene i te mata o te nila lapui me'a, o sigi i te pegea ga'u te hano ki goto i te Hakahua 'anga a te 'Aitu.” ");
INSERT INTO mnv_vpl VALUES ("LK18_26","072_18_26","LUK","18","26","26","Na pegea noko haka gongo ki te gea 'anga nei noko haka anu 'aki o hai atu, “Ka koai gaa te kago maa'ugi?” ");
INSERT INTO mnv_vpl VALUES ("LK18_27","072_18_27","LUK","18","27","27","Ko Jesus noko haka tau o hai atu, “Niaa e hai ngata'a kia pegea manga haingaohie kia te 'Aitu.” ");
INSERT INTO mnv_vpl VALUES ("LK18_28","072_18_28","LUK","18","28","28","Ka ko Peter noko hai atu, “Ko kimatou kua ti'aki ko ba'i me'a amatou kimatou tata'o tu'a ia te Koe!” ");
INSERT INTO mnv_vpl VALUES ("LK18_29","072_18_29","LUK","18","29","29","Ma te hai atu a Jesus kia te kigatou, “Ko Au e gea maa'ogi kia te koutou, koai kua hano i tena manaha, po ko tena uguugu, po ko tena 'api, po ko ona tuhaahine, po ko ona hai maatu'a, po ko tena haanau, i te ghaghinga i te Hakahua 'anga a te 'Aitu, ");
INSERT INTO mnv_vpl VALUES ("LK18_30","072_18_30","LUK","18","30","30","koia e hai ke go ga'u ma'ana ni ga'unga ke 'eha i na gholoba nei, ma te ma'ugi noho goa i na 'aso kago a'u.” ");
INSERT INTO mnv_vpl VALUES ("LK18_31","072_18_31","LUK","18","31","31","Ko Jesus noko kakabe 'aatea e Ia te tino anga hugu tuma'a e gua, o 'atigongo kia te kigatou o hai atu, “Ko kitatou e hai ke haka neke ki Jerusalem, kae hai ke haka maa'ogi ai ko ba'i me'a noko kanukanu ena taauga i na noho o te Hosa o Pegea. ");
INSERT INTO mnv_vpl VALUES ("LK18_32","072_18_32","LUK","18","32","32","Ko Ia e hai ke go haka soko ki na pegea 'aatea, kigatou kago noko putatai kia te Ia, ma te hai songo ia te Ia, ma te he ngaa'esu 'aki kia te Ia, ");
INSERT INTO mnv_vpl VALUES ("LK18_33","072_18_33","LUK","18","33","33","ma te kogu ia te Ia aano taa. Ka nimaa te togunga 'ao, kae ma'ugi hoki Ia.” ");
INSERT INTO mnv_vpl VALUES ("LK18_34","072_18_34","LUK","18","34","34","Na pegea haka ako noko he'e na'a e kigatou he me'a i ana gea 'anga nei. Te gaataki o na haka hegeunga nei noko huu ia te kigatou, o he'e na'a ai po nia te noko manga gea kinai. ");
INSERT INTO mnv_vpl VALUES ("LK18_35","072_18_35","LUK","18","35","35","Nimaa hano a Jesus o hitaiaki ki Jericho. Te launatasi pegea kibi manga noho i te taha ba'e aga o noko manga haka ene. ");
INSERT INTO mnv_vpl VALUES ("LK18_36","072_18_36","LUK","18","36","36","Te gholoba noko haka gongo ai ki ba'i pegea manga boomai o sigi, koia noko haka anu o hai ake, “Niaa te manga hai nei?” ");
INSERT INTO mnv_vpl VALUES ("LK18_37","072_18_37","LUK","18","37","37","Ko kigatou noko 'atigongo atu kia te ia o hai atu, “Ko Jesus mai Nazareth e sigi.” ");
INSERT INTO mnv_vpl VALUES ("LK18_38","072_18_38","LUK","18","38","38","Koia noko ngege to'a o hai atu, “Jesus, te Hosa o David, 'agoha mai kia te au!” ");
INSERT INTO mnv_vpl VALUES ("LK18_39","072_18_39","LUK","18","39","39","Na pegea noko mumu'a noko susugi atu ia te ia, ma te hai atu kinai, “Ngongoto iho!” Ka koia noko manga ngege soo atu o hai atu, “Te Hosa o David, 'agoha mai kia te au!” ");
INSERT INTO mnv_vpl VALUES ("LK18_40","072_18_40","LUK","18","40","40","Ma te tu'u a Jesus, kae kaunaki atu ke kakabe mai te pegea kia te Ia. Te gholoba noko a'u ai ia o hitaiaki mai ai, ko Jesus noko haka anu kinai o hai atu, ");
INSERT INTO mnv_vpl VALUES ("LK18_41","072_18_41","LUK","18","41","41","“Niaa te siahai koe kau hai 'ia kia te koe?” Ka koia noko haka tau o hai atu, “Hakahua, ko au e siahai kau ina.” ");
INSERT INTO mnv_vpl VALUES ("LK18_42","072_18_42","LUK","18","42","42","Ma te hai atu a Jesus kia te ia, “Luga ake ou mata. Tou sano kua hai ia te koe o gaoi.” ");
INSERT INTO mnv_vpl VALUES ("LK18_43","072_18_43","LUK","18","43","43","Gua mata o 'ona na lugaluga, ma te tata'o ia Jesus, o noko manga haka e'eha ia te 'Aitu. Nimaa te hiina'i 'anga kinai te 'apitanga, ko kigatou na haka e'eha ai ia te 'Aitu ma'u. ");
INSERT INTO mnv_vpl VALUES ("LK19_1","072_19_1","LUK","19","1","1","Ko Jesus noko hetae ki Jericho o hano i tena uso. ");
INSERT INTO mnv_vpl VALUES ("LK19_2","072_19_2","LUK","19","2","2","Ka noko iai te tangata noko mate tena ingoa ko Zacchaeus. Koia te hakahua o na pegea tibu takis, kae ga'u ma'u. ");
INSERT INTO mnv_vpl VALUES ("LK19_3","072_19_3","LUK","19","3","3","Koia noko siahai ke ina po koai ko Jesus. Ka koia te pegea pulu ma te he'e 'aonga tena ina, i te noko hu'ai 'api pegea. ");
INSERT INTO mnv_vpl VALUES ("LK19_4","072_19_4","LUK","19","4","4","Ko Zacchaeus na tege o mu'a i te 'apitanga o kake i te ga'akau e mate te ‘sycamore’, ke ina kia Jesus noko ma a'u i te aga na. ");
INSERT INTO mnv_vpl VALUES ("LK19_5","072_19_5","LUK","19","5","5","Nimaa hetae mai a Jesus ki te kungaa, ko Ia noko ina haka tu'u o hai ake kia te ia, “Zacchaeus, hoki ghali iho, na'e ko Au e hano kau noho i tou hage i te 'ao nei.” ");
INSERT INTO mnv_vpl VALUES ("LK19_6","072_19_6","LUK","19","6","6","Ma te ghali iho a Zacchaeus o hu'ai siasia kia te Ia, o haka pogo eia ki tena hage. ");
INSERT INTO mnv_vpl VALUES ("LK19_7","072_19_7","LUK","19","7","7","Ko ba'i pegea na hiina'i ki te hai 'anga nei, ma te konei agatou he nguunguu 'aki, “Ko Ia e hano ke hai ai he hogau ma'a te pegea 'oosongo ina.” ");
INSERT INTO mnv_vpl VALUES ("LK19_8","072_19_8","LUK","19","8","8","Ka ko Zacchaeus noko tu'u o hai atu kia Jesus, “Hakahua, 'ai ina mai, e hai kau haiga'a 'ia he pa'asi i aku me'a ki na pegea lae, ka nimaa mou to'o au ki he pegea i he me'a, e hai kau sui haka haa 'ia kinai.” ");
INSERT INTO mnv_vpl VALUES ("LK19_9","072_19_9","LUK","19","9","9","Ka ko Jesus noko hai atu kia te ia, “Te 'aso nei te ma'ugi sanga kua a'u ki te hage nei, iteme'agaa te pegea nei te launatasi i te hanohano o Abraham ma'u. ");
INSERT INTO mnv_vpl VALUES ("LK19_10","072_19_10","LUK","19","10","10","Te Hosa o Pegea noko a'u ke sasaga ma te haka ma'ugi na pegea kua boo 'aatea.” ");
INSERT INTO mnv_vpl VALUES ("LK19_11","072_19_11","LUK","19","11","11","Te gholoba noko ma haka gongo ai kigatou ki te hai 'anga nei, ko Jesus noko 'atigongo soo atu kia te kigatou i te haka gaataki, iteme'agaa ko Ia kua hitaiaki ki Jerusalem, ka te 'apitanga noko tegeu'a ake, te Hakahua 'anga a te 'Aitu e hai ke ghali o hiina'i kinai. ");
INSERT INTO mnv_vpl VALUES ("LK19_12","072_19_12","LUK","19","12","12","Ko Jesus noko hai atu, “Noko iai te launatasi tangata sopo haka maatu'a noko hano ki te kakai 'anga mama'o ke hai ai ia te ia ke hakahua, ka ke go mugi o hokimai. ");
INSERT INTO mnv_vpl VALUES ("LK19_13","072_19_13","LUK","19","13","13","Ka koia noko ngege i tena tino anga hugu guani o taki haiga'a kia te kigatou na mane golu kae hai atu kinai: ‘Hai hekau atu ai ke hano aano hetae ki toku 'aso hokimai.’ ");
INSERT INTO mnv_vpl VALUES ("LK19_14","072_19_14","LUK","19","14","14","“Ka na pegea o'ona noko gotoa'a kia te ia, ma te tuku e kigatou na pegea o tata'o ai ke hai atu, ‘Ko kimatou he'e siahahai ki te pegea nei ke hai ai mo'omatou he hakahua.’ ");
INSERT INTO mnv_vpl VALUES ("LK19_15","072_19_15","LUK","19","15","15","“Ka te tangata haka maatu'a na pau o tuku o hakahua, kae hokimai, ma te pogo 'aki i ona guani noko taki 'abange kinai na mane ke na'a eia poe hia kua beegaba kinai e kigatou. ");
INSERT INTO mnv_vpl VALUES ("LK19_16","072_19_16","LUK","19","16","16","“Te pegea mu'a noko a'u o hai atu: ‘Hakahua, tau mane kua beegaba kinai eau te katoa ma'u.’ ");
INSERT INTO mnv_vpl VALUES ("LK19_17","072_19_17","LUK","19","17","17","“Haka tau tena hakahua o hai atu: ‘Hu'ai gaoi, ko koe toku guani gaoi! Ko koe kua hai gaoi e koe te mi'i hai 'anga, kae tuku eau ia te koe ke hakahua i he katoa manaha.’ ");
INSERT INTO mnv_vpl VALUES ("LK19_18","072_19_18","LUK","19","18","18","“Te pegea noko gua kinai noko a'u o hai atu: ‘Hakahua, tau mane kua beegaba kinai eau te toka gima ma'u.’ ");
INSERT INTO mnv_vpl VALUES ("LK19_19","072_19_19","LUK","19","19","19","“Tena hakahua noko haka tau o hai atu, ‘Ko koe e hai ke hakahua i he toka gima manaha.’ ");
INSERT INTO mnv_vpl VALUES ("LK19_20","072_19_20","LUK","19","20","20","“Nimaa a'u tegaa guani o hai atu, ‘Hakahua, tenei tau mane; manga pegu eau i te momo laoa o noko manga pipiki, ");
INSERT INTO mnv_vpl VALUES ("LK19_21","072_19_21","LUK","19","21","21","ia te au e mataku kia te koe, iteme'agaa ko koe te pegea he'e haka papau ki he pegea. Manga to'o e koe na me'a 'aatea, ma te utu e koe na me'a he'e tanu e koe.’ ");
INSERT INTO mnv_vpl VALUES ("LK19_22","072_19_22","LUK","19","22","22","“Tena hakahua noko haka tau o hai atu, ‘Ko koe te guani maase'i to'a! E hai kau haka aba 'ia ia te koe i au gea 'anga na. Kua 'oti i te na'a e koe ko au te pegea he'e haka papau, e to'o eau na me'a 'aatea, ma te utu na me'a noko he'e tanu eau. ");
INSERT INTO mnv_vpl VALUES ("LK19_23","072_19_23","LUK","19","23","23","'Ai tehea te hai 'anga noko he'e tuku ai e koe taku mane ki te kunga tuku mane? Ka kau go ga'u 'ia tena beegaba 'anga i toku 'aso hokimai ai?’ ");
INSERT INTO mnv_vpl VALUES ("LK19_24","072_19_24","LUK","19","24","24","“Ma te hai atu te hakahua ki na pegea noko manga tutu'u haka pata kia te ia, ‘Sa'u atu te mane e hai eia o 'abatu ki te pegea e hai eia te katoa mane.’ ");
INSERT INTO mnv_vpl VALUES ("LK19_25","072_19_25","LUK","19","25","25","“Ka ko kigatou noko haka tau o hai atu, ‘Hakahua, kua 'oti i te hai tena katoa!’ ");
INSERT INTO mnv_vpl VALUES ("LK19_26","072_19_26","LUK","19","26","26","“Ka te hakahua noko haka tau o hai atu kinai, ‘Koau e hai atu kia te koutou, “Na pegea kua ga'u, e hai ke go 'abange beegaba, ka na pegea he'e ga'u me'a, masi'igoa na mi'i me'a te manga hai e kigatou, kae hai ke go sa'u ia te kigatou. ");
INSERT INTO mnv_vpl VALUES ("LK19_27","072_19_27","LUK","19","27","27","Ka oku makau noko he'e siahahai kia te au kau hakahua kia te kigatou, kakabe mai o taa i 'ago ia te au.” ’ ” ");
INSERT INTO mnv_vpl VALUES ("LK19_28","072_19_28","LUK","19","28","28","Ko Jesus noko 'oti i te konei ana gea kae mu'a ia te kigatou ki Jerusalem. ");
INSERT INTO mnv_vpl VALUES ("LK19_29","072_19_29","LUK","19","29","29","Nimaa hitaiaki a Ia ki Bethphage ma Bethany e hitaiaki ki te ogo e mate tena ingoa te Ogo i Olives, ko Jesus noko kaunaki te toka gua i ona pegea haka ako o hai atu kia te kigaaua, ");
INSERT INTO mnv_vpl VALUES ("LK19_30","072_19_30","LUK","19","30","30","“Kougua boo atu ki te manaha e i-mu'a ia te kougua. Nimaa hetae kinai kougua kago kite ai e kougua te punua donki manga tauga i te kungaa, manga koi he'e sehu ai he pegea. Ogo huhuke atu o kakabe mai ki te kunga nei. ");
INSERT INTO mnv_vpl VALUES ("LK19_31","072_19_31","LUK","19","31","31","Nimaa iai he pegea e haka anu ai kia te kougua, ‘Tehea te hai 'anga e huhuke ai e kougua?’ ogo hogahoga atu kia te ia o hai atu kinai, ‘Te Hakahua e siahai kinai.’ ” ");
INSERT INTO mnv_vpl VALUES ("LK19_32","072_19_32","LUK","19","32","32","Nimaa boo kigaaua i te aga ma te kite e kigaaua ba'i me'a noko gea ai a Jesus kia te kigaaua. ");
INSERT INTO mnv_vpl VALUES ("LK19_33","072_19_33","LUK","19","33","33","Nimaa huhuke e kigaaua te punua donki, tena hakahua noko hai atu kia te kigaaua, “Tehea te hai 'anga e huhuke ai te punua donki na?” ");
INSERT INTO mnv_vpl VALUES ("LK19_34","072_19_34","LUK","19","34","34","Ko kigaaua noko haka tau o hai atu, “Te Hakahua e siahai kinai.” ");
INSERT INTO mnv_vpl VALUES ("LK19_35","072_19_35","LUK","19","35","35","Ma te kakabe mai kia Jesus, o haagiki e kigatou i ogatou ake te tu'a o te punua donki, kae 'aabaki kia Jesus o sopo kinai. ");
INSERT INTO mnv_vpl VALUES ("LK19_36","072_19_36","LUK","19","36","36","Te 'aso noko hano ai, ko ba'i pegea noko hoga ogatou ake i te aga. ");
INSERT INTO mnv_vpl VALUES ("LK19_37","072_19_37","LUK","19","37","37","Te gholoba noko hano ai a Jesus o hitaiaki ki te kunga e iho ai te aga i te Ogo i Olives, ko ba'i pegea haka ako ngatahi na haka tu'u sisia ma te ngengege i te haka e'eha e kigatou ia te 'Aitu i ba'i hai 'anga haka ohokia kua 'oti i te hiina'i kinai, ma te hai atu, ");
INSERT INTO mnv_vpl VALUES ("LK19_38","072_19_38","LUK","19","38","38","“Haka gaoi ki te Hakahua e a'u i te ingoa o te 'Aitu! Te goto maagie i te gangi, ma te mamagunga i te nuku hu'ai ma'u 'agunga!” ");
INSERT INTO mnv_vpl VALUES ("LK19_39","072_19_39","LUK","19","39","39","Ma te hai atu kogaa i na Pharisee noko uso i te 'apitanga kia Jesus, “Ako, susugi atu ou pegea haka ako!” ");
INSERT INTO mnv_vpl VALUES ("LK19_40","072_19_40","LUK","19","40","40","Ka ko Jesus noko haka tau o hai atu kia te kigatou, “Ko kigatou nimaa ngongoto, na hatu e hai ke sui o ngengege!” ");
INSERT INTO mnv_vpl VALUES ("LK19_41","072_19_41","LUK","19","41","41","Nimaa hano Ia o hitaiaki ki Jerusalem o ina 'atu ki te hu'ai manaha, ko Ia na tangi ai. ");
INSERT INTO mnv_vpl VALUES ("LK19_42","072_19_42","LUK","19","42","42","Kae konei ana gea, “Poi manga tegaa te na'a e koutou te 'aso nei, nia e hai kego hai koutou goto maagie ai! Ka kua he'e 'aonga te hiina'i kinai koutou! ");
INSERT INTO mnv_vpl VALUES ("LK19_43","072_19_43","LUK","19","43","43","Na 'ao kago boomai kia te koutou, na makau o'outou kago haka putu mai o 'ati mabaenga kia te koutou, ma te ghigho ia te koutou ma te kukumi ba'i pa'asi ia te koutou. ");
INSERT INTO mnv_vpl VALUES ("LK19_44","072_19_44","LUK","19","44","44","E hai ke go taa e kigatou ia te koutou, koutou ma na tamagiki manga kakai haka pigi kia te koutou i goto i na 'aa o'outou. Kago si'ai he hatu e tasi ke takoto i te kunga nei, iteme'agaa noko he'e haka 'igonga e koutou te 'aso a'u ai a te 'Aitu kia te koutou.” ");
INSERT INTO mnv_vpl VALUES ("LK19_45","072_19_45","LUK","19","45","45","Te 'aso noko hano ai a Jesus ki te Hage Tapu, o pagepage ai e Ia na pegea noko tau'i me'a i te kungaa. ");
INSERT INTO mnv_vpl VALUES ("LK19_46","072_19_46","LUK","19","46","46","Ma te hai atu a Jesus kia te kigatou, “Na 'oti i te kanukanu: ‘Toku hage nei te kunga taakunga.’ Ka kua hai e koutou te 'ana o na pegea kaia'a.” ");
INSERT INTO mnv_vpl VALUES ("LK19_47","072_19_47","LUK","19","47","47","Ko ba'i 'aso ko Jesus noko manga ako ai i te Hage Tapu, ka na hakahua o na Priest, ma na ako o na tagangonga, ma na hutiaki o te 'apitanga noko gotu kigatou taa 'ia ia te Ia. ");
INSERT INTO mnv_vpl VALUES ("LK19_48","072_19_48","LUK","19","48","48","Ka noko he'e kite e kigatou he 'aso tau gaoi kigatou hai 'ia ai, iteme'agaa ko ba'i pegea noko manga haka putu o haka gongo ki ana haka hegeu 'anga. ");
INSERT INTO mnv_vpl VALUES ("LK20_1","072_20_1","LUK","20","1","1","Te launatasi 'ao, ko Jesus noko manga ako ai e Ia te 'apitanga i te Hage Tapu, ma te tohi'aki i te Gongo Gaoi, ka na hakahua o na Priest ma na ako o na tagangonga, haka pigi kinai na 'agiki o na Jew, noko boo ngatahi mai kia te Ia o hai atu kinai, ");
INSERT INTO mnv_vpl VALUES ("LK20_2","072_20_2","LUK","20","2","2","“ 'Atigongo mai kia te kimatou pona taganga mai hea te hai ai e Koe na hai 'anga nei. Koai te noko 'abatu eia kia te Koe na taganga nei?” ");
INSERT INTO mnv_vpl VALUES ("LK20_3","072_20_3","LUK","20","3","3","Ka ko Jesus noko haka tau o hai atu kia te kigatou, “Ko Au ma'u e hai kau haka anu kia te koutou i te launatasi haka anuanu. ");
INSERT INTO mnv_vpl VALUES ("LK20_4","072_20_4","LUK","20","4","4","Hogahoga mai kia te Au, po te haa gogomi pegea 'anga a John, te hai 'anga a'u mai te gangi, po te hai 'anga a'u ia pegea?” ");
INSERT INTO mnv_vpl VALUES ("LK20_5","072_20_5","LUK","20","5","5","Ko kigatou na ba'aki kinai aano kogaa agatou to'o, “Nimaa hai atu kitatou, ‘Te hai 'anga mai te gangi,’ ko Ia kago hai mai, ‘Ka 'eaa na he'e too ai koutou kia John?’ ");
INSERT INTO mnv_vpl VALUES ("LK20_6","072_20_6","LUK","20","6","6","Ka nimaa hai atu kitatou, ‘Te hai 'anga a'u ia pegea,’ ko ba'i pegea kago 'aumahu ia te kitatou i ni hatu, iteme'agaa kua na'a e kigatou ko John te taauga.” ");
INSERT INTO mnv_vpl VALUES ("LK20_7","072_20_7","LUK","20","7","7","Ko kigatou noko haka tau o hai atu kia Jesus, “E he'e na'a maahoga e kimatou po te hai 'anga a'u mai hea.” ");
INSERT INTO mnv_vpl VALUES ("LK20_8","072_20_8","LUK","20","8","8","Ko Jesus na hai atu kia te kigatou, “Ka he'e hogahoga ma'u e Au kia te koutou pona taganga mai hea te hai ai e Au na hai 'anga nei.” ");
INSERT INTO mnv_vpl VALUES ("LK20_9","072_20_9","LUK","20","9","9","Ko Jesus noko 'atigongo kia te kigatou ma'u i te haka gaataki nei, “Te tangata noko tanu tena 'umanga o tuku ki na pegea hai hekau 'umanga, kae hano ki tegaa kakai 'anga ke ina goa ai. ");
INSERT INTO mnv_vpl VALUES ("LK20_10","072_20_10","LUK","20","10","10","Nimaa hetae ki te gholoba noko matu'a ai, kae kaunaki eia tena guani o hano ki na pegea manga ge'o 'umanga, ke 'abange kinai e kigatou ni me'a i te 'umanga. Ka na pegea ge'o 'umanga na manga kogu e kigatou ia te ia, kae haka to'o hoki, kae si'ai ma'ana ni me'a to'o. ");
INSERT INTO mnv_vpl VALUES ("LK20_11","072_20_11","LUK","20","11","11","Kaunaki ma'u eia tegaa ona guani o hano, ka na kogu hakapa'a ma'u e kigatou ma te hai songo ia te ia, kae kaunaki o hoki si'ai ma'ana ni me'a to'o. ");
INSERT INTO mnv_vpl VALUES ("LK20_12","072_20_12","LUK","20","12","12","Hakato'o ma'u eia te pegea noko toka togu kinai o hano, ka na kogu ma'u ena pegea noko i te 'umanga o hai ona maka, kae tupe e kigatou ki taha i te 'umanga. ");
INSERT INTO mnv_vpl VALUES ("LK20_13","072_20_13","LUK","20","13","13","“Ma te hai ake te hakahua o te 'umanga, ‘Niaa gaa hai kau hai 'ia? E hai kau haka to'o 'ia toku hosa e ma'ine to'a kinai au ke hano. Mano te kaigo pago kigatou kia te ia.’ ");
INSERT INTO mnv_vpl VALUES ("LK20_14","072_20_14","LUK","20","14","14","“Ka te gholoba na hiina'i ai kigatou kia te ia, noko hegeu kinai ma te hai ake, ‘Tenei tena hosa hakahua, kitatou taa 'ia ia te ia ka ke hai mo'otatou na me'a noko tuha kia te ia.’ ");
INSERT INTO mnv_vpl VALUES ("LK20_15","072_20_15","LUK","20","15","15","Ma te pagepage e kigatou ia te ia ki tu'a i te 'umanga o taa ai. “Niaa gaa te kago hai e te hakahua o te 'umanga kia te kigatou? ");
INSERT INTO mnv_vpl VALUES ("LK20_16","072_20_16","LUK","20","16","16","Koia kago a'u kinai o taa eia na pegea ge'o o te 'umanga, kae haiga'a eia te 'umanga ki gaa pegea.” Te gholoba noko haka gongo kinai ba'i pegea noko hai ake kigatou, “E he'e konaa o na noho!” ");
INSERT INTO mnv_vpl VALUES ("LK20_17","072_20_17","LUK","20","17","17","Ko Jesus noko ina 'atu kia te kigatou ma te hai atu kinai, “Tehea te gaataki o te kanukanu 'anga e konei na to'o: ‘Te hatu noko he'e siahahai kinai na pegea 'ati hage, e hai ke go hai ai he poutu'u.’? ");
INSERT INTO mnv_vpl VALUES ("LK20_18","072_20_18","LUK","20","18","18","Ko ba'i pegea hetoki ki te hatu na, e hai ke go matohitohi ki ni momo; ka koai kago too kinai te hatu nei, ka go pau o momomomo.” ");
INSERT INTO mnv_vpl VALUES ("LK20_19","072_20_19","LUK","20","19","19","Na ako o na tagangonga ma na tuginga o na Priest noko sasaga e kigatou he gholoba tau gaoi ke ghali o he 'osohi ai kia te Ia, iteme'agaa ana gea 'anga noko hai songo ia te kigatou, ka ko kigatou noko matataku ki te 'apitanga. ");
INSERT INTO mnv_vpl VALUES ("LK20_20","072_20_20","LUK","20","20","20","Noko mata pipiki e kigatou ia te Ia, ma te tuku e kigatou na pegea mata o boomai o hai ia te kigatou o noho mai na pegea gaoi. Ko kigatou noko gotu kigatou labu 'ia ni me'a gea ai a Jesus, ka kigatou haiga'a 'ia ia te Ia ki na paaunga ma na taganga o te gahumanu o Rome. ");
INSERT INTO mnv_vpl VALUES ("LK20_21","072_20_21","LUK","20","21","21","Na pegea noko tuku o hai ai na mata kia te Ia, noko hai atu kia Jesus, “Ako, e na'a e kimatou ko Koe e gea ma te ako na me'a maa'ogi. Ko Koe ma'u he'e 'aonga tau haka gata ki he pegea, i te maa'ogi au ako 'anga i na noho o te 'Aitu. ");
INSERT INTO mnv_vpl VALUES ("LK20_22","072_20_22","LUK","20","22","22","Ko kimatou manga gaoi i te poi tau'i takis kia Caesar po si'ai?” ");
INSERT INTO mnv_vpl VALUES ("LK20_23","072_20_23","LUK","20","23","23","Ka ko Jesus noko na'a e Ia tegatou haka tootoo e hai, ma te hai atu kia te kigatou, ");
INSERT INTO mnv_vpl VALUES ("LK20_24","072_20_24","LUK","20","24","24","“ 'Ai haka 'agi mai he mane. To'ai te 'ata ma te ingoa te pigi ai?” Ka ko kigatou noko haka tau o hai atu, “To'o Caesar.” ");
INSERT INTO mnv_vpl VALUES ("LK20_25","072_20_25","LUK","20","25","25","Ma te hai atu a Jesus kia te kigatou, “ 'Abatu kia Caesar na me'a Caesar, kae haiga'a atu e koutou kia te 'Aitu nia a te 'Aitu.” ");
INSERT INTO mnv_vpl VALUES ("LK20_26","072_20_26","LUK","20","26","26","Ko kigatou na he'e 'aonga te haka makau ia te Ia i na me'a noko gea ai i 'ago i te 'apitanga. Ko kigatou na he gege ma'ugi 'aki i tena haka tau 'anga noko hai kia te kigatou, ma te manga hiina'i haka ngongoto. ");
INSERT INTO mnv_vpl VALUES ("LK20_27","072_20_27","LUK","20","27","27","Noko iai kogaa i na Sadducee, noko kogaa agatou to'o: Ko pegea kago he'e maa'ugi giu, noko boomai kia Jesus ma te haka anu, ");
INSERT INTO mnv_vpl VALUES ("LK20_28","072_20_28","LUK","20","28","28","o hai atu, “Ako, ko Moses noko kanukanu kia te kimatou o hai mai, ‘Nimaa iai he pegea hai mo'ona he taina e mate, kae toe a tena uguugu he'e tau tama giki, te tangata nei e hai ke pipiki eia te hahine magepe ke hai eia ni tama giki ma'a tena ta'okete.’ ");
INSERT INTO mnv_vpl VALUES ("LK20_29","072_20_29","LUK","20","29","29","Ka noko iai te 'api toka hitu. Te hai ta'okete noko hai tena uguugu aano mate, si'ai ma'ana he tama 'iti'iti. ");
INSERT INTO mnv_vpl VALUES ("LK20_30","072_20_30","LUK","20","30","30","Ma te pipiki ma'u e te pegea e gua kinai, ");
INSERT INTO mnv_vpl VALUES ("LK20_31","072_20_31","LUK","20","31","31","aano sui kinai te pegea e toka togu kinai. Manga konei na noho ngatahi te toka hitu aano mamate ngatahi, kae he'e tau tama giki. ");
INSERT INTO mnv_vpl VALUES ("LK20_32","072_20_32","LUK","20","32","32","Kae mate taha'aki ma'u te hahine. ");
INSERT INTO mnv_vpl VALUES ("LK20_33","072_20_33","LUK","20","33","33","Nimaa go hetae te 'aso kago maa'ugi giu ai, te hahine to'ai te uguugu i te noko pipiki ngatahi e te 'api toka hitu?” ");
INSERT INTO mnv_vpl VALUES ("LK20_34","072_20_34","LUK","20","34","34","Ko Jesus noko haka tau kia te kigatou o hai atu, “Na pegea o na 'aso nei manga hai uguugu ma te haiga'a o hai matu'a, ");
INSERT INTO mnv_vpl VALUES ("LK20_35","072_20_35","LUK","20","35","35","ka na pegea kago 'aonga te maa'ugi giu i te 'aso na, ko kigatou kago he'e hai uguugu ma te haiga'a ke hai matu'a. ");
INSERT INTO mnv_vpl VALUES ("LK20_36","072_20_36","LUK","20","36","36","Ko kigatou kago he'e mamate, 'ia te kigatou kago manga noho pe na ensel. Ko kigatou na tama giki a te 'Aitu, iteme'agaa ko kigatou kua maa'ugi giu. ");
INSERT INTO mnv_vpl VALUES ("LK20_37","072_20_37","LUK","20","37","37","Ka te tagatupu'a o te ga'akau noko kaa, noko haka 'agi ma'u ai e Moses na pegea mamate e maa'ugi giu, ia te ia noko mate eia ia te 'Agiki: ‘Te 'Aitu o Abraham, ma te 'Aitu o Isaac, ma te 'Aitu o Jacob.’ ");
INSERT INTO mnv_vpl VALUES ("LK20_38","072_20_38","LUK","20","38","38","Ko Ia he'e te 'Aitu o na pegea mamate, ka te 'Aitu o na pegea maa'ugi, iteme'agaa ko kigatou manga maa'ugi ia te Ia.” ");
INSERT INTO mnv_vpl VALUES ("LK20_39","072_20_39","LUK","20","39","39","Noko iai kogaa i na ako o na tagangonga noko hai atu, “Ako, e gaoi au haka hegeunga na.” ");
INSERT INTO mnv_vpl VALUES ("LK20_40","072_20_40","LUK","20","40","40","Na si'ai ma'u he pegea toka manaba ke haka anu hoki kia te Ia. ");
INSERT INTO mnv_vpl VALUES ("LK20_41","072_20_41","LUK","20","41","41","Ko Jesus noko hai atu kia te kigatou, “Eaa e hai ake ai te 'apitanga te 'Agiki Taga'ia te Hosa o David? ");
INSERT INTO mnv_vpl VALUES ("LK20_42","072_20_42","LUK","20","42","42","Iteme'agaa ko David noko gea i te Buka o Psalm o hai ake: ‘Te 'Agiki e hai atu ki toku Hakahua: “Noho mai i toku pa'asi maui, ");
INSERT INTO mnv_vpl VALUES ("LK20_43","072_20_43","LUK","20","43","43","ke go hano aano hetae ki te 'aso kago hai ai e Au ou makau ke go hai ai he kunga haka tutu'u kinai ou ba'e.” ’ ");
INSERT INTO mnv_vpl VALUES ("LK20_44","072_20_44","LUK","20","44","44","Ko David noko mate eia ia te Ia te ‘Hakahua.’ Kae hai ke kohea na hai ke hai ai mo'ona he hosa?” ");
INSERT INTO mnv_vpl VALUES ("LK20_45","072_20_45","LUK","20","45","45","Te gholoba noko ma haka gongo ai ba'i pegea kia te Ia, ko Jesus noko hai atu ki ona pegea haka ako, ");
INSERT INTO mnv_vpl VALUES ("LK20_46","072_20_46","LUK","20","46","46","“Koutou matasiba atu ki na ako o na tagangonga manga siahahai ke noko mamago i na ake gogoa o noko lango, ma te maa'ine ki na hegeu gaoi 'anga kinai i na kunga tau'i me'a, ma te ligo ma'u i na noho 'anga gaoi i na Hage hai paaunga ma na kunga gaoi i na haka tahinga. ");
INSERT INTO mnv_vpl VALUES ("LK20_47","072_20_47","LUK","20","47","47","Ko kigatou manga hai songo na hage o na haahine magegepe, ma te haka'agi i agatou taakunga gogoa 'anga. Na pegea nei kago hua'eha tegatou kagohia.” ");
INSERT INTO mnv_vpl VALUES ("LK21_1","072_21_1","LUK","21","1","1","Ko Jesus noko ina 'atu ki na pegea ga'u manga tuku agatou ga'a tausu'u ki te kunga tuku mane i te Hage Tapu. ");
INSERT INTO mnv_vpl VALUES ("LK21_2","072_21_2","LUK","21","2","2","Ko Ia ma'u noko ina 'atu ki te hahine magepe hu'ai lae e tuku ki goto tena toka gua mi'i mane. ");
INSERT INTO mnv_vpl VALUES ("LK21_3","072_21_3","LUK","21","3","3","Ma te konei ana gea, “Ko Au e gea maa'ogi atu kia te koutou, te hahine magepe lae nei kua tuku ta'ana o 'eha o sigi i gaa pegea. ");
INSERT INTO mnv_vpl VALUES ("LK21_4","072_21_4","LUK","21","4","4","Ko ba'i pegea e haiga'a mane manga haiga'a ia agatou ga'unga, ka te hahine lae nei e haiga'a ngatahi na me'a e hai ke noko ma'ugi kinai.” ");
INSERT INTO mnv_vpl VALUES ("LK21_5","072_21_5","LUK","21","5","5","Noko iai kogaa i na pegea haka ako noko manga hegeu ki te maatanga gaoi 'anga te Hage Tapu i na hatu hu'ai gaoi noko 'ati ai, ma na to'o 'anga na ga'a tausu'u o sogi ai kia te 'Aitu. ");
INSERT INTO mnv_vpl VALUES ("LK21_6","072_21_6","LUK","21","6","6","Ma te hai atu kinai a Jesus, “Na me'a e hiina'i kinai koutou nei, kago si'ai he hatu e tasi ke takoto ai i na 'aso kago a'u: Ko ba'i hatu e hai ke go haka tutuku ngatahi ki gago.” ");
INSERT INTO mnv_vpl VALUES ("LK21_7","072_21_7","LUK","21","7","7","Ka ko kigatou noko haka anuanu 'aki kinai o hai atu, “Ako, tehea te 'aso kago hai ai na hai 'anga nei? Tehea te haka 'igonga ke go na'a ai na hai 'anga nei kago hai?” ");
INSERT INTO mnv_vpl VALUES ("LK21_8","072_21_8","LUK","21","8","8","Ko Jesus noko haka tau o hai atu kia te kigatou, “Koutou matasiba atu ka ke go noka te gogoi kia te koutou. Kago 'api pegea kago boomai i toku ingoa o hai ake, ‘Koau ko Ia,’ ma te hai ake ma'u, ‘Te 'aso kua hitaiaki.’ Ogo noka tautou too kia te kigatou. ");
INSERT INTO mnv_vpl VALUES ("LK21_9","072_21_9","LUK","21","9","9","Na 'aso kago haka gongo ai koutou ki ni sagatau'a ma na he hai songo 'aki 'anga a pegea, noka tautou matataku ai. Na me'a nei e hai ke go mataa hai, ka te 'ao taha'aki koi he'e hetae mai.” ");
INSERT INTO mnv_vpl VALUES ("LK21_10","072_21_10","LUK","21","10","10","Ko Jesus noko gea hoki kia te kigatou o hai atu kinai, “Na pegea o tegaa kakai 'anga kago he taa 'aki ma na pegea o tegaa kakai 'anga. Na pegea o tegaa sa'a kago he taa 'aki ma'u ma na pegea o tegaa sa'a. ");
INSERT INTO mnv_vpl VALUES ("LK21_11","072_21_11","LUK","21","11","11","E hai ke go hetae mai na 'aso hu'ai o'i o'i, ma na 'aso o te ongesau, ma na 'aso sa'o saga ina ai ba'i kunga, kago hu'ai matataku ai i na hu'ai haka 'igonga kago boomai i te gangi. ");
INSERT INTO mnv_vpl VALUES ("LK21_12","072_21_12","LUK","21","12","12","“E hai ke go mugi o hai na hai 'anga nei, kae hai ke go mataa he 'osohi kia te koutou o hai songo, ma te tuku ia te koutou ki na Hage hai paaunga o Jew, ke go haka aba ia te koutou aano tuku ki te kunga o te kagohia. E hai ke go kakabe ia te koutou ke go tutu'u 'ago i na hakahua ma na pegea hai paaunga, i te ghaghinga i toku ingoa. ");
INSERT INTO mnv_vpl VALUES ("LK21_13","072_21_13","LUK","21","13","13","Tenaa te gholoba gaoi kego 'atigongo ai koutou kia te kigatou ia te Au. ");
INSERT INTO mnv_vpl VALUES ("LK21_14","072_21_14","LUK","21","14","14","Pipiki hinangago atu kae noka tautou maikia ki na 'aso kago a'u poe hai ke go kohea na haka baabaasi'a ia te koutou. ");
INSERT INTO mnv_vpl VALUES ("LK21_15","072_21_15","LUK","21","15","15","Iteme'agaa e hai kau go haiga'a 'ia kia te koutou ni kupu ma te 'igo'igo kago si'ai he makau mo'outou ke haka noka poe haka si'ai eia. ");
INSERT INTO mnv_vpl VALUES ("LK21_16","072_21_16","LUK","21","16","16","Koutou e hai ke go haka soko e outou hai maatu'a ma outou ta'okete ma outou taina ma outou 'atimaa'ogi ma autou hemasi'inga. E hai ke go taa e kigatou ni pegea ia te koutou. ");
INSERT INTO mnv_vpl VALUES ("LK21_17","072_21_17","LUK","21","17","17","Ko ba'i pegea kago noko gotoa'a kia te koutou i te ghaghinga ia te Au. ");
INSERT INTO mnv_vpl VALUES ("LK21_18","072_21_18","LUK","21","18","18","Ka kago si'ai he gau 'ugu e tasi i outou 'ugu ke go he'e kitea. ");
INSERT INTO mnv_vpl VALUES ("LK21_19","072_21_19","LUK","21","19","19","Koutou tutu'u atu ke ma'u, na'e tenaa te hai 'anga kago maa'ugi ai koutou. ");
INSERT INTO mnv_vpl VALUES ("LK21_20","072_21_20","LUK","21","20","20","“Nimaa hiina'i koutou ki Jerusalem e ghigho e na tau'a, e hai kego na'a e koutou e hitaiaki ke haka masogo. ");
INSERT INTO mnv_vpl VALUES ("LK21_21","072_21_21","LUK","21","21","21","Ka na pegea manga noho 'aki i Judea, e hai ke go he 'agiko ki na ogo, na pegea manga i goto i te hu'ai manaha e hai ke go he'aki iho, na pegea manga noho 'aki i na tahataha e hai ke go noka te boo ki goto i te hu'ai manaha. ");
INSERT INTO mnv_vpl VALUES ("LK21_22","072_21_22","LUK","21","22","22","Iteme'agaa tenei te 'aso o te kagohia e hai ke go haka maa'ogi ai nia na 'oti i te kanukanu. ");
INSERT INTO mnv_vpl VALUES ("LK21_23","072_21_23","LUK","21","23","23","Kago hu'ai tiha'ia 'aki i na 'aso na na haahine tina'e huhuga ma na haahine haa uu tamagiki! Kago hetae mai na 'aso hu'ai sanga songo ki te kakai 'anga nei ma te 'ika'ika o te 'Aitu kago a'u ki na pegea nei. ");
INSERT INTO mnv_vpl VALUES ("LK21_24","072_21_24","LUK","21","24","24","Ko kigatou kago taa 'ia ini kiba, ma te to'ogia o hai ai ni guani ki kogaa kakai 'anga. Ko Jerusalem e hai ke go hakahuahua e na pegea 'aatea o hano aano hetae ki na 'aso 'oti ai ogatou hakahua 'anga. ");
INSERT INTO mnv_vpl VALUES ("LK21_25","072_21_25","LUK","21","25","25","“Kago iai na haka 'igonga kago hai ki te ga'aa ma te maahina ma na hetu'u. Ko ba'i kakai 'anga i te kege nei kago hu'ai haka gongo songo ma te he tootoo baasi'a 'aki i na hahangu 'anga a te tai ma na 'aso 'atua ai. ");
INSERT INTO mnv_vpl VALUES ("LK21_26","072_21_26","LUK","21","26","26","Ko pegea kago noko sesemu i te matataku i ba'i hai 'anga e hai ke go boomai ki te kege nei, iteme'agaa na me'a o te gangi kago o'i. ");
INSERT INTO mnv_vpl VALUES ("LK21_27","072_21_27","LUK","21","27","27","Te 'aso na, ko kigatou kago hiina'i ki te Hosa o Pegea e a'u i te po'ao i ona taganga, ma te hu'ai mamagunga o'ona. ");
INSERT INTO mnv_vpl VALUES ("LK21_28","072_21_28","LUK","21","28","28","Te 'aso kago hai ai na hai 'anga nei, ogo tutu'ake o ta'aki outou 'ugu, iteme'agaa ko Ia na tau'i haka hoki ia te koutou, kua hitaiaki.” ");
INSERT INTO mnv_vpl VALUES ("LK21_29","072_21_29","LUK","21","29","29","Ko Jesus noko 'atigongo kia te kigatou i te haka gaataki nei, “Koutou hiina'i atu ki te ga'akau e mate te ‘fig’, ma ba'i ga'akau. ");
INSERT INTO mnv_vpl VALUES ("LK21_30","072_21_30","LUK","21","30","30","Nimaa hiina'i kinai koutou i te gau motomoto, manga na'a e koutou e hitaiaki te 'aso mahana. ");
INSERT INTO mnv_vpl VALUES ("LK21_31","072_21_31","LUK","21","31","31","Manga kogaa na noho ma'u, te 'aso kago hiina'i ai koutou ki na hai 'anga nei kae hai, ke go manga na'a ake e koutou te 'aso o te Hakahua 'anga a te 'Aitu kua hitaiaki. ");
INSERT INTO mnv_vpl VALUES ("LK21_32","072_21_32","LUK","21","32","32","“Ko Au e 'atigongo maa'ogi kia te koutou: Te 'atu tangata nei kago he'e 'aonga te masogo o hano aano hetae ki te 'aso hai ke go hai ai na hai 'anga nei. ");
INSERT INTO mnv_vpl VALUES ("LK21_33","072_21_33","LUK","21","33","33","Ko te gangi ma te kege nei kago masogo, ka aku haka hegeunga ka he'e 'aonga te masogo. ");
INSERT INTO mnv_vpl VALUES ("LK21_34","072_21_34","LUK","21","34","34","“Ge'o gaoi atu ia te koutou, ka ke noka tautou ha'ao hinangago ki na kai 'anga ma na bibinu 'anga i na bai to'a ma na hu'ai tegeu'a 'anga ki na me'a o te kege nei, na'e te kaigo hetae ghali mai te 'ao na kia te koutou pe te papaga. ");
INSERT INTO mnv_vpl VALUES ("LK21_35","072_21_35","LUK","21","35","35","E hai ke go hetae ki ba'i pegea manga taki haka toka i ba'i kunga i te kege nei. ");
INSERT INTO mnv_vpl VALUES ("LK21_36","072_21_36","LUK","21","36","36","Koutou na'ana'a atu ma te noko taakunga atu kia te 'Aitu i ba'i 'aso ka ke go 'aonga tautou boo 'aatea ai i ba'i hai 'anga e hai ke go boomai, ka koutou go 'aonga te tutu'u 'ago ai i te Hosa o Pegea.” ");
INSERT INTO mnv_vpl VALUES ("LK21_37","072_21_37","LUK","21","37","37","Ko ba'i 'ao ko Jesus noko manga ako ai i te Hage Tapu, ka ko ba'i ahiahi ko Ia noko manga hano o noho ai ona poo i te ogo e mate tena ingoa te Ogo i Olives. ");
INSERT INTO mnv_vpl VALUES ("LK21_38","072_21_38","LUK","21","38","38","Ko ba'i pegea noko boomai i na mahoata ki te Hage Tapu ke noko haka gongo kia te Ia. ");
INSERT INTO mnv_vpl VALUES ("LK22_1","072_22_1","LUK","22","1","1","Noko hitaiaki ki te 'aso o te haka tahinga o na bred he'e tau me'a haka tupu utunga, e mate tena ingoa te Passover. ");
INSERT INTO mnv_vpl VALUES ("LK22_2","072_22_2","LUK","22","2","2","Ka na tuginga o na Priest ma na ako o na tagangonga noko ma ligo e kigatou he hai 'anga tau gaoi kigatou taa 'ia ai a Jesus, iteme'agaa ko kigatou noko matataku ki te 'apitanga. ");
INSERT INTO mnv_vpl VALUES ("LK22_3","072_22_3","LUK","22","3","3","Nimaa ugu a Satan ia Judas, e mate ma'u ko Iscariot, te launatasi i te tino anga hugu tuma'a e gua. ");
INSERT INTO mnv_vpl VALUES ("LK22_4","072_22_4","LUK","22","4","4","O hano a Judas ki na tuginga o na Priest ma na hakahua o na pegea ge'o o te Hage Tapu o hegeu kigatou po e hai ke kohea na haka soko eia ia Jesus kia te kigatou. ");
INSERT INTO mnv_vpl VALUES ("LK22_5","072_22_5","LUK","22","5","5","Ko kigatou noko magagaohie ai ma te goto tasi ke 'abange ni mane kia te ia. ");
INSERT INTO mnv_vpl VALUES ("LK22_6","072_22_6","LUK","22","6","6","Ko Judas noko maangao kinai ma te mamata eia he 'aso tau gaoi ke haka soko ai eia ia Jesus kia te kigatou i he gholoba he'e tau pegea hitaiaki mai. ");
INSERT INTO mnv_vpl VALUES ("LK22_7","072_22_7","LUK","22","7","7","Nimaa hetae mai te 'ao o na bred he'e tau me'a haka tupu utunga, ma te gholoba e hai ke taa ai te punua sipisipi ki te kainga e mate te Passover. ");
INSERT INTO mnv_vpl VALUES ("LK22_8","072_22_8","LUK","22","8","8","Kaunaki e Jesus ia Peter ma John ke boo, kae hai atu kinai, “Boo atu o ngaague he kunga kitatou go kai ai i te Passover.” ");
INSERT INTO mnv_vpl VALUES ("LK22_9","072_22_9","LUK","22","9","9","Ka noko haka tau a kigaaua o hai atu, “Tehea te kunga e siahai Koe kimaa ngaague 'ia kinai?” ");
INSERT INTO mnv_vpl VALUES ("LK22_10","072_22_10","LUK","22","10","10","Haka tau a Jesus o hai atu kinai, “Nimaa boo kougua o hetae ki te hu'ai manaha, kago kite e kougua te tangata manga 'amo eia te poati manga iai te bai. Ogo tata'o tu'a atu ai ki te hage, kago hano o ugu kinai. ");
INSERT INTO mnv_vpl VALUES ("LK22_11","072_22_11","LUK","22","11","11","Ogo kogaa augua to'o atu ki te hakahua o te hage, ‘Te Hakahua e haka ene mai: Po tehea te potu hage o na hogau e hai kimatou bilaabei kinai ma oku pegea haka ako ke kai ai i te Passover?’ ");
INSERT INTO mnv_vpl VALUES ("LK22_12","072_22_12","LUK","22","12","12","Kago haka tuiaki eia kia te kougua te hu'ai potu gaoi i 'agunga i te hage manga iai ba'i me'a, ogo ngaague atu ai e kougua ba'i me'a.” ");
INSERT INTO mnv_vpl VALUES ("LK22_13","072_22_13","LUK","22","13","13","Nimaa boo a kigaaua, o kite i ba'i me'a gea ai a Jesus kia te kigaaua, ma te ngaague e kigaaua te Passover. ");
INSERT INTO mnv_vpl VALUES ("LK22_14","072_22_14","LUK","22","14","14","Nimaa hetae te 'aso, ko Jesus ma ona pegea haka to'o noko boomai o nonoho ki te kaupea kai. ");
INSERT INTO mnv_vpl VALUES ("LK22_15","072_22_15","LUK","22","15","15","Kae hai atu a Ia kia te kigatou, “Ko Au noko hu'ai siahai kau kai haka pigi kia te koutou i te Passover nei, 'io mugi Au o tiha'ia. ");
INSERT INTO mnv_vpl VALUES ("LK22_16","072_22_16","LUK","22","16","16","Ko Au e hai atu kia te koutou: Ko Au kago he'e 'aonga te kai hoki i te kainga nei, aano hetae ki te 'aso e hai ke go maa'ogi mai ai te Hakahua 'anga a te 'Aitu.” ");
INSERT INTO mnv_vpl VALUES ("LK22_17","072_22_17","LUK","22","17","17","Mugi i te sa'u ake 'anga te kapu, kae haka 'aue ai Ia kae hai atu, “To'o atu o tuha ia te koutou. ");
INSERT INTO mnv_vpl VALUES ("LK22_18","072_22_18","LUK","22","18","18","Na'e ko Au kua hai atu kia te koutou ko Au ka he'e binu hoki i te waeni nei o hano aano hetae ki te 'aso e hai ke go a'u ai te Hakahua 'anga a te 'Aitu.” ");
INSERT INTO mnv_vpl VALUES ("LK22_19","072_22_19","LUK","22","19","19","Nimaa sa'u ake ma'u e Jesus na bred o haka 'aue ake ai kia te 'Aitu, kae tohitohi e Ia o haiga'a kia te kigatou, kae hai atu kinai, “Tenei toku tino e haiga'a kia te koutou. Hai atu e koutou te hai 'anga nei o noko maanatu ai ia te Au.” ");
INSERT INTO mnv_vpl VALUES ("LK22_20","072_22_20","LUK","22","20","20","Noko hai ma'u e Ia te hai 'anga nei i te sa'u ake e Ia te waeni i te kapu i te 'oti 'anga te kai, kae hai atu, “Te waeni e i-te kapu nei, te gaataki o te tukungaa kupu ho'ou a te 'Aitu i te toto o'oku e hai ke go singa kia te koutou. ");
INSERT INTO mnv_vpl VALUES ("LK22_21","072_22_21","LUK","22","21","21","Ka te pegea kago haka soko eia ia te Au manga haka pata kia te Au i te kunga e kai nei. ");
INSERT INTO mnv_vpl VALUES ("LK22_22","072_22_22","LUK","22","22","22","Te Hosa o Pegea e hai ke go mate i te na 'oti i te haka pau e te 'Aitu, kae haka 'aagoha te tangata kago haka soko ia te Ia.” ");
INSERT INTO mnv_vpl VALUES ("LK22_23","072_22_23","LUK","22","23","23","Ko kigatou noko haka tu'u tegatou he haka anuanu 'aki o hai ake, “Koai gaa te hai ke hai eia te hai 'anga nei?” ");
INSERT INTO mnv_vpl VALUES ("LK22_24","072_22_24","LUK","22","24","24","Na pegea haka ako noko haka bagebage 'aki po koai ia te kigatou te hai ke maanatu kinai kogaa, koia te hu'ai pegea. ");
INSERT INTO mnv_vpl VALUES ("LK22_25","072_22_25","LUK","22","25","25","Ka ko Jesus noko kogaa ana to'o atu kia te kigatou, “Na hakahua o na pegea 'aatea manga hakahuahua ia te kigatou; ma na pegea e haka hua ia te kigatou, e mate e kigatou ia te kigatou soko: ‘Na hemasi'inga a pegea.’ ");
INSERT INTO mnv_vpl VALUES ("LK22_26","072_22_26","LUK","22","26","26","Ka he'e tenei te a'aki e hai ke hai e koutou: Te pegea nimaa hua'eha ia te koutou e hai ke noho pe te tama 'iti'iti. Ka te pegea e hutiaki, e hai ke noho pe te guani. ");
INSERT INTO mnv_vpl VALUES ("LK22_27","072_22_27","LUK","22","27","27","'Ai koai te hua'eha, te pegea e noho i te kaupea o kai, po te pegea e hai hekau? Tegaa te pegea e hua'eha: Te pegea e noho o kai i te kaupea. Ka ko Au manga haka pata kia te koutou, manga noho pe te pegea hai hekau. ");
INSERT INTO mnv_vpl VALUES ("LK22_28","072_22_28","LUK","22","28","28","Konei koutou kua noho 'aki haka pata goa kia te Au i ba'i 'aso hai lobo ai ia te Au. ");
INSERT INTO mnv_vpl VALUES ("LK22_29","072_22_29","LUK","22","29","29","Kae kogaa na noho, ko Tamau noko tuku e Ia ia te Au kau hakahua, kae konei na tuku ma'u e Au ia te koutou. ");
INSERT INTO mnv_vpl VALUES ("LK22_30","072_22_30","LUK","22","30","30","Koutou e hai ke go kai ma te bibinu i te kunga kai o'oku ma te nuku o'oku, ma te hai koutou go nonoho ini noho 'anga ma'u 'agunga o haka aba e koutou te tino anga hugu tuma'a e gua hanohano o Israel. ");
INSERT INTO mnv_vpl VALUES ("LK22_31","072_22_31","LUK","22","31","31","“Simon, Simon! Ko Satan na haka ene ke tuhatuha eia ia te koutou ke noho pe te pegea e tuhatuha eia na kigi ma na hatu witi. ");
INSERT INTO mnv_vpl VALUES ("LK22_32","072_22_32","LUK","22","32","32","Ka ko Au kua taakunga ia te koe Simon, ke noka te lologi te sano o'ou, ka ke go nimaa hetae tou 'aso keu hokimai ai kia te Au, ogo usu 'aki atu na pegea o'ou.” ");
INSERT INTO mnv_vpl VALUES ("LK22_33","072_22_33","LUK","22","33","33","Ka ko Peter noko haka tau o hai atu kia Jesus, “Hakahua, ko au manga ngaague kau tata'o ia te Koe ki te kunga o na pegea kagohia, ma te kau go mate haka pigi kia te Koe.” ");
INSERT INTO mnv_vpl VALUES ("LK22_34","072_22_34","LUK","22","34","34","Ko Jesus noko haka tau o hai atu kia Peter, “Te 'aso nei ko koe kago mataa gea haka togu o hai ake, e he'e na'a e koe ia te Au, 'io mugi te paolo o tangi.” ");
INSERT INTO mnv_vpl VALUES ("LK22_35","072_22_35","LUK","22","35","35","Ma te haka anu a Jesus kia te kigatou o hai atu, “Te 'aso noko tuku ai e Au ia te koutou o boo, koutou noko he'e to'o ma'autou ni oko oko, po ni tanga, po ni taka ba'e, koutou noko sanga songo i ni me'a?” Ko kigatou noko haka tau o hai atu, “Si'ai.” ");
INSERT INTO mnv_vpl VALUES ("LK22_36","072_22_36","LUK","22","36","36","Hai atu a Jesus kia te kigatou, “Ka te 'aso nei, nimaa iai he pegea ia te koutou e hai ma'ana he oko oko, to'o ake. Po e hai he tanga, to'o ake ma'u. Ka nimaa he'e hai ma'au he kiba taa pegea, tuku atu te ake o'ou ke tau'i o hai ai he mane o tau'i ai he kiba. ");
INSERT INTO mnv_vpl VALUES ("LK22_37","072_22_37","LUK","22","37","37","Na 'oti i te kanukanu ki na Kanukanu Tapu: ‘Ko Ia na tau hakapigi ki na pegea hai hai 'anga songo.’ Kae hai atu Au te hai 'anga nei e hai ke haka maa'ogi ia te Au. E maa'ogi, nia noko kanukanu i na noho o 'Oku e tatae ki tena 'otinga.” ");
INSERT INTO mnv_vpl VALUES ("LK22_38","072_22_38","LUK","22","38","38","Na pegea haka ako noko hai atu kinai, “Hakahua, kua hai tematou toka gua kiba taa pegea.” Ma te haka tau a Jesus o hai atu kinai, “Kua 'aonga!” ");
INSERT INTO mnv_vpl VALUES ("LK22_39","072_22_39","LUK","22","39","39","Ko Jesus noko hano ki te kunga tena paaunga te hano kinai i te Ogo i Olives, kae tata'o ai ona pegea haka ako. ");
INSERT INTO mnv_vpl VALUES ("LK22_40","072_22_40","LUK","22","40","40","Nimaa hetae kigatou ki te kungaa, ko Jesus noko hai atu kia te kigatou, “Taakunga atu, ka koutou noka te hetoki iho ki na pakenga.” ");
INSERT INTO mnv_vpl VALUES ("LK22_41","072_22_41","LUK","22","41","41","Ma te hano 'aatea Ia ia te kigatou o mi'i makabaa, kae toko tugi o taakunga o hai ake, ");
INSERT INTO mnv_vpl VALUES ("LK22_42","072_22_42","LUK","22","42","42","“Tamau, nimaa tuku e Koe ke hai, sa'u atu te kapu nei ia te Au; ka he'e aku paaunga te hai ke hai, ka ke hai au paaunga.” ");
INSERT INTO mnv_vpl VALUES ("LK22_43","072_22_43","LUK","22","43","43","Haka 'agitino te ensel mai te gangi kia te Ia o hai ia te Ia o to'a. ");
INSERT INTO mnv_vpl VALUES ("LK22_44","072_22_44","LUK","22","44","44","Ko Ia noko hu'ai haka gongo songo te uso, ma te hu'ai taakunga aano pisi ona ta'ata'a o noho pe na toto o singa ki te kege. ");
INSERT INTO mnv_vpl VALUES ("LK22_45","072_22_45","LUK","22","45","45","Nimaa tu'u hokimai i tena taakunga 'anga, o hoki ki na pegea haka ako o manga kite e Ia manga momoe, iteme'agaa ko kigatou noko he lologi 'aki i te 'agogoha. ");
INSERT INTO mnv_vpl VALUES ("LK22_46","072_22_46","LUK","22","46","46","Ma te hai atu a Jesus kia te kigatou, “Koutou e momoe i teaa? A'aga ake o taakunga, ka koutou noka te tata'o ki na pakenga.” ");
INSERT INTO mnv_vpl VALUES ("LK22_47","072_22_47","LUK","22","47","47","Te gholoba noko manga koi haka hegeu ai a Jesus, kae boomai te hu'ai tu'uganga, ka te tangata noko mate ko Judas, te launatasi i te tino anga hugu tuma'a e gua, noko hutiaki mai eia te 'apitanga. Koia noko hano o hitaiaki kia Jesus ke sosongi ai. ");
INSERT INTO mnv_vpl VALUES ("LK22_48","072_22_48","LUK","22","48","48","Ma te hakaanu atu a Jesus kia te ia, “Judas, 'ai e haka soko e koe te Hosa o Pegea i te sosongi koe ia te Au?” ");
INSERT INTO mnv_vpl VALUES ("LK22_49","072_22_49","LUK","22","49","49","Te gholoba noko hiina'i ai na pegea haka ako ki te hai 'anga e hai, ma te hai atu kia Jesus, “Hakahua, e 'aonga te taa e kimatou i gua kiba taa pegea nei?” ");
INSERT INTO mnv_vpl VALUES ("LK22_50","072_22_50","LUK","22","50","50","Te launatasi ia te kigatou na tapi e ia te guani o te hakahua o na priest, o sabi eia te taginga maui. ");
INSERT INTO mnv_vpl VALUES ("LK22_51","072_22_51","LUK","22","51","51","Ka noko hai atu kinai a Jesus, “E he'e hai ke konaa na hai!” Kae 'oso atu ki te taginga o te pegea o hai o gaoi hoki. ");
INSERT INTO mnv_vpl VALUES ("LK22_52","072_22_52","LUK","22","52","52","Kae kogaa na to'o atu a Jesus ki na hakahua o na Priest, ma na pegea noko ge'o e kigatou te Hage Tapu, ma na 'agiki o na Jew noko boomai kia te Ia, “ 'Ai ko Au te pegea haka tauseke ka ke boomai kinai koutou ma na kiba taa pegea, ma na ga'akau taa pegea? ");
INSERT INTO mnv_vpl VALUES ("LK22_53","072_22_53","LUK","22","53","53","Ko Au noko manga haka pata kia te koutou i te Hage Tapu i ba'i 'ao, ka manga he'e he 'osohi koutou kia te Au. Ka tenei te gholoba o 'outou, te gholoba e haka hua ai te poo'uginga.” ");
INSERT INTO mnv_vpl VALUES ("LK22_54","072_22_54","LUK","22","54","54","Ma te samu huhuti e kigatou ia Jesus o kakabe ki te hage o te hakahua o na priest, ka ko Peter noko manga tata'o haka makabaa ai. ");
INSERT INTO mnv_vpl VALUES ("LK22_55","072_22_55","LUK","22","55","55","Nimaa te hai 'anga e kogaa i te kungaa tegatou ahi i te uso o te gotomaga'e i te mu'a o te hage, o noho 'aki ngatahi kinai kigatou, ko Peter noko noho haka pigi ma'u kia te kigatou. ");
INSERT INTO mnv_vpl VALUES ("LK22_56","072_22_56","LUK","22","56","56","Te guani hahine noko ina 'atu kia Peter manga noho i te taha ahi. Ina titingi atu te hahine kia te ia ma te hai atu, “Te pegea nei noko manga haka pata ma'u kia te Ia.” ");
INSERT INTO mnv_vpl VALUES ("LK22_57","072_22_57","LUK","22","57","57","Ka ko Peter noko haka si'ai eia, ma te hai atu, “Ta'ahine, e he'e na'e eau ia te Ia!” ");
INSERT INTO mnv_vpl VALUES ("LK22_58","072_22_58","LUK","22","58","58","Nimaa mi'i taunga gogoa kae ina 'atu ma'u kinai tegaa ia te kigatou o hai atu kinai, “Ko koe ma'u te pegea ia te kigatou.” Haka tau a Peter o hai atu “Teiana, ko au si'ai!” ");
INSERT INTO mnv_vpl VALUES ("LK22_59","072_22_59","LUK","22","59","59","Nimaa hetae ki tegaa mi'i gholoba, gea to'a tegaa tasi tangata kia te ia o hai atu, “E hu'ai maa'ogi te pegea nei noko manga haka pata kia Jesus, iteme'agaa koia te pegea mai Galilee!” ");
INSERT INTO mnv_vpl VALUES ("LK22_60","072_22_60","LUK","22","60","60","Ka ko Peter noko haka tau o hai atu kinai, “Teiana, e he'e na'a eau po nia te manga gea kinai koe na!” Te gholoba noko manga koi gea ai, kae tangi te paolo. ");
INSERT INTO mnv_vpl VALUES ("LK22_61","072_22_61","LUK","22","61","61","Te Hakahua na keu atu o ina titingi atu kia Peter, ma te maanatu hoki a Peter ki te kupu a te Hakahua noko gea ai kia te ia o hai atu, “Te 'aso nei ko koe kago gea haka togu o hai ake e he'e na'a e koe ia te Au, 'io mugi te paolo o tangi.” ");
INSERT INTO mnv_vpl VALUES ("LK22_62","072_22_62","LUK","22","62","62","Ko Peter na tohu ki haho o hai tena hu'ai magepenga. ");
INSERT INTO mnv_vpl VALUES ("LK22_63","072_22_63","LUK","22","63","63","Na pegea noko ge'o e kigatou ia Jesus noko haka tu'u putatai kia te Ia ma te kogu e kigatou. ");
INSERT INTO mnv_vpl VALUES ("LK22_64","072_22_64","LUK","22","64","64","Noko poghi e kigatou na mata, kae haka anu 'aki kinai o hai atu, “Taauga mai po koai te kogu ia te Koe.” ");
INSERT INTO mnv_vpl VALUES ("LK22_65","072_22_65","LUK","22","65","65","Noko 'eha me'a maase'i ma'u noko gegea ai kigatou kia te Ia. ");
INSERT INTO mnv_vpl VALUES ("LK22_66","072_22_66","LUK","22","66","66","Nimaa te taha'ataa, te tu'uganga puge ana 'agiki o na pegea, ma na hakahua o na Priest ma na ako o na tagangonga, noko haka putu ngatahi, kae kakabe mai a Jesus ki 'ago ia te kigatou. ");
INSERT INTO mnv_vpl VALUES ("LK22_67","072_22_67","LUK","22","67","67","O hai atu kinai, “Ko Koe nimaa te 'Agiki Taga'ia, 'atigongo mai ai kia te kimatou.” Ko Jesus noko haka tau o hai atu kinai, “Ko Au poi 'atigongo kia te koutou, koutou ka he'e too kia te Au, ");
INSERT INTO mnv_vpl VALUES ("LK22_68","072_22_68","LUK","22","68","68","ka poi haka anu Au kia te koutou, koutou ka he'e haka tau. ");
INSERT INTO mnv_vpl VALUES ("LK22_69","072_22_69","LUK","22","69","69","Kae haka tu'u i te 'aso nei o hano, te Hosa o Pegea e hai ke noho i te pa'asi maui o te 'Aitu e Hu'ai Taganga.” ");
INSERT INTO mnv_vpl VALUES ("LK22_70","072_22_70","LUK","22","70","70","Ko kigatou ngatahi noko hai atu kia Jesus, “ 'Ai ko Koe te Hosa o te 'Aitu?” Haka tau a Jesus o hai atu kinai, “Koutou kua 'oti i te gegea mai ai, ko Au.” ");
INSERT INTO mnv_vpl VALUES ("LK22_71","072_22_71","LUK","22","71","71","Ma te konei agatou to'o, “Eaa e siahahai ma'u ai kitatou ni gongo? Ko kitatou kua 'oti i te haka gongo kinai, kae gea ai i te ngutu!” ");
INSERT INTO mnv_vpl VALUES ("LK23_1","072_23_1","LUK","23","1","1","Ma te tutu'u ngatahi te haka putunga o kakabe e kigatou ia Jesus kia Pilate. ");
INSERT INTO mnv_vpl VALUES ("LK23_2","072_23_2","LUK","23","2","2","O haka tu'u tegatou 'atigongo haka makau e kigatou ia Jesus o kogaa agatou to'o, “Te pegea nei kua kite e kimatou e hai maase'i e Ia ba'i pegea, ma te susugi ma'u e Ia ke noka te haiga'a takis kia Caesar, kae hai ake ma'u ko Ia te 'Agiki Taga'ia, te Hakahua.” ");
INSERT INTO mnv_vpl VALUES ("LK23_3","072_23_3","LUK","23","3","3","Nimaa haka anu a Pilate kia Jesus o hai atu kinai, “ 'Ai ko Koe te Hakahua o na Jew?” Haka tau a Jesus o hai atu, “Tenaa te ma gea ai koe na.” ");
INSERT INTO mnv_vpl VALUES ("LK23_4","072_23_4","LUK","23","4","4","Ma te hogahoga atu e Pilate ki na hakahua o na Priest ma te 'apitanga o hai atu, “E he'e kite eau he hai 'anga ke hai songo ai te pegea nei.” ");
INSERT INTO mnv_vpl VALUES ("LK23_5","072_23_5","LUK","23","5","5","Ka ko kigatou noko gegea toto'a ake, “Te pegea nei kua usuusu e Ia ba'i pegea i ba'i kunga i Judea i ana akonga. Noko haka tu'u mai e Ia i Galilee ka kua a'u aano te hetae mai nei ki tenei.” ");
INSERT INTO mnv_vpl VALUES ("LK23_6","072_23_6","LUK","23","6","6","Nimaa haka gongo kinai a Pilate, ma te haka anu atu ki te 'apitanga po te pegea mai Galilee. ");
INSERT INTO mnv_vpl VALUES ("LK23_7","072_23_7","LUK","23","7","7","Te gholoba noko na'a ai eia ko Jesus te pegea i te kunga manga ge'o e Herod, ma te hakato'o eia a Jesus o hano kia Herod noko manga i Jerusalem i te gholobaa. ");
INSERT INTO mnv_vpl VALUES ("LK23_8","072_23_8","LUK","23","8","8","Te 'aso noko ina ai a Herod kia Jesus, koia noko hu'ai magaohie ai, iteme'agaa noko 'eha 'aso siahai ke ina ai kia te Ia, noko hu'ai gootunga ke ina kini hai 'anga haka ohokia hai e Jesus. ");
INSERT INTO mnv_vpl VALUES ("LK23_9","072_23_9","LUK","23","9","9","Ko Herod noko hu'ai haka anuanu kia te Ia, ka ko Jesus noko he'e haka tau hoki kia te ia. ");
INSERT INTO mnv_vpl VALUES ("LK23_10","072_23_10","LUK","23","10","10","Na hakahua o na Priest ma na ako o na tagangonga noko manga tutu'u i te kungaa, o manga hu'ai gegea haka makau ai e kigatou ia Jesus. ");
INSERT INTO mnv_vpl VALUES ("LK23_11","072_23_11","LUK","23","11","11","Ma te putatai ma te gegea maase'i a Herod ma ona pegea hai tau'a kia te Ia. Haa mago e kigatou i na ake gaoi, kae haka to'o hoki kia Pilate. ");
INSERT INTO mnv_vpl VALUES ("LK23_12","072_23_12","LUK","23","12","12","Te 'ao na, ko Herod ma Pilate na hemaasi'i ai, ka ko kigaaua gua pegea noko manga he makakau 'aki. ");
INSERT INTO mnv_vpl VALUES ("LK23_13","072_23_13","LUK","23","13","13","Ko Pilate noko hakaputu ngatahi e ia na hakahua o na Priest ma ba'i hakahua ma te 'apitanga. ");
INSERT INTO mnv_vpl VALUES ("LK23_14","072_23_14","LUK","23","14","14","O hai atu kia te kigatou, “E kakabe mai kia te au te pegea nei, i te hai ake koutou e ako e Ia ba'i pegea o hu'ai hai hai 'anga maase'i. Kua ligo eau ia te Ia i 'ago ia te koutou o he'e kitea he hai 'anga ke haka tu'u ai na hegeunga haka makau e hai kia te Ia. ");
INSERT INTO mnv_vpl VALUES ("LK23_15","072_23_15","LUK","23","15","15","Ko Herod ma'u e he'e kite eia he hai 'anga songo kia te Ia, ma te tuku eia o hokimai kia te kitatou. Kua 'oti i te na'a e koutou e si'ai he hai 'anga hai e Ia ke 'aonga ai ki te mate. ");
INSERT INTO mnv_vpl VALUES ("LK23_16","072_23_16","LUK","23","16","16","Kae konei na noho, e hai kau tuku 'ia ke kogu ka ke tuku ke hano.” ");
INSERT INTO mnv_vpl VALUES ("LK23_17","072_23_17","LUK","23","17","17","Ko ba'i 'aso noko hai ai te haka tahinga o te Passover, ko Pilate noko ta'a tuku ai eia he launatasi i na pegea kagohia o tausu'u. ");
INSERT INTO mnv_vpl VALUES ("LK23_18","072_23_18","LUK","23","18","18","Ka te 'apitanga noko hu'ai ngengege ngatahi o hai atu, “Kakabe 'aatea atu te pegea nei, kae tuku iho ia Barabbas ke tausu'u ke a'u kia te kimatou!” ");
INSERT INTO mnv_vpl VALUES ("LK23_19","072_23_19","LUK","23","19","19","(Ko Barabbas noko tuku ki te kagohia i te noko hu'ai hai hai 'anga haka tangi ki ba'i pegea i te manaha, kae taa pegea ma'u.) ");
INSERT INTO mnv_vpl VALUES ("LK23_20","072_23_20","LUK","23","20","20","Ko Pilate noko tegeu'a ke tuku eia ia Jesus ke hano tausu'u, ma te haka anu hoki ai ki te 'apitanga. ");
INSERT INTO mnv_vpl VALUES ("LK23_21","072_23_21","LUK","23","21","21","Ka ko kigatou noko manga ngengege giu atu kinai, “Taa atu ia te Ia ki te kros! Taa atu ia te Ia ki te kros!” ");
INSERT INTO mnv_vpl VALUES ("LK23_22","072_23_22","LUK","23","22","22","Ka ko Pilate noko gea haka togu kia te kigatou o hai atu, “Tehea te hai 'anga songo e hai e te pegea nei? E he'e kite eau he hai 'anga hai e Ia ke 'aonga ai ki te mate! E hai kau manga tuku 'ia ke kogu, ka ke tuku ke hano tausu'u.” ");
INSERT INTO mnv_vpl VALUES ("LK23_23","072_23_23","LUK","23","23","23","Ka ko kigatou noko tuku soo ake 'agatou ngengege 'anga ke taa ia Jesus ki te kros. Ka na haka maa'ogi tegatou ngengege 'anga o hai. ");
INSERT INTO mnv_vpl VALUES ("LK23_24","072_23_24","LUK","23","24","24","Na haka pau e Pilate ia Jesus o tuku i tegatou haka ene 'aki 'anga. ");
INSERT INTO mnv_vpl VALUES ("LK23_25","072_23_25","LUK","23","25","25","Kae haka tausu'u eia te pegea noko tuku ki te kunga o na pegea kagohia i te noko hu'ai hai hai 'anga haka tangi ki ba'i pegea kae taa pegea ma'u, kae tuku eia ia Jesus ke hai kinai nia noko siahahai kinai kigatou. ");
INSERT INTO mnv_vpl VALUES ("LK23_26","072_23_26","LUK","23","26","26","Ko kigatou noko kakabe 'aatea e kigatou ia Jesus i te manaha. Nimaa kite e kigatou ia Simon, te pegea mai Cyrene i te agaa. Koia noko a'u i te kakai 'anga i tu'a ki Jerusalem, ma te labu e kigatou o neneke kinai te kros o 'amo eia o tata'o tu'a ia Jesus. ");
INSERT INTO mnv_vpl VALUES ("LK23_27","072_23_27","LUK","23","27","27","Te 'apitanga o pegea noko tata'o tu'a ia te Ia, noko haka pigi kinai na haahine noko manga tatangi ma te magegepe ia te Ia. ");
INSERT INTO mnv_vpl VALUES ("LK23_28","072_23_28","LUK","23","28","28","Ma te keu kinai a Jesus o hai atu kia te kigatou, “Haahine o Jerusalem, noka tautou tatangi ia te Au, kae manga tatangi iho ia te koutou ma autou tama giki. ");
INSERT INTO mnv_vpl VALUES ("LK23_29","072_23_29","LUK","23","29","29","Iteme'agaa na 'aso kago a'u, koutou kago kogaa autou to'o, ‘E magagaohie na haahine meetogho, ma na haahine he'e tina'e huhuga, ma na haahine koi he'e haa uu ma'agatou ni tama giki!’ ");
INSERT INTO mnv_vpl VALUES ("LK23_30","072_23_30","LUK","23","30","30","Te gholoba na kago kogaa na to'o atu ai te 'apitanga ki na ogo, ‘Hetoki mai kia te kimatou!’ Ma te hai atu ma'u ki na mi'i ogo, ‘Poghi mai ia te kimatou!’ ");
INSERT INTO mnv_vpl VALUES ("LK23_31","072_23_31","LUK","23","31","31","Ko pegea nimaa hai e kigatou na hai 'anga nei i na 'aso koi ma'ugi ai te ga'akau, niaa e hai ke go hai i na 'aso kago pakupaku ai te ga'akau?” ");
INSERT INTO mnv_vpl VALUES ("LK23_32","072_23_32","LUK","23","32","32","Toka gua taangata hai hai 'anga songo noko kakabe ma'u e kigatou ke taa haka pigi kia Jesus. ");
INSERT INTO mnv_vpl VALUES ("LK23_33","072_23_33","LUK","23","33","33","Te 'aso noko hetae ai kigatou ki te kunga e mate tena ingoa: “Te Puso 'ugu”, tenaa te kunga noko taa ai e kigatou ia Jesus ki te kros, ma gua pegea hai hai 'anga songo. Noko tuku tegaa i te pa'asi maui, kae tuku tegaa i te pa'asi sema. ");
INSERT INTO mnv_vpl VALUES ("LK23_34","072_23_34","LUK","23","34","34","Ko Jesus noko kogaa na to'o, “Tamau, haka noka mai kia te kigatou, na'e he'e na'a e kigatou nia te hai e kigatou nei.” Kae tuhatuha e kigatou ona ake i te babage 'anga i na daes o taki to'o. ");
INSERT INTO mnv_vpl VALUES ("LK23_35","072_23_35","LUK","23","35","35","Te 'apitanga noko tutu'u kigatou o ma mata, kae putatai na hakahua o na Jew kia te Ia, o kogaa agatou to'o kinai, “Ko Ia noko ta'anga haka ma'ugi e Ia kogaa pegea, kae tuku atu ke haka ma'ugi ia te Ia i te poi maa'ogi ko Ia te 'Agiki Taga'ia, te pegea haka pau mai e te 'Aitu?” ");
INSERT INTO mnv_vpl VALUES ("LK23_36","072_23_36","LUK","23","36","36","Na pegea hai tau'a noko boomai ma'u o putatai kia te Ia, kae haiga'a kinai e kigatou te bai kona, ");
INSERT INTO mnv_vpl VALUES ("LK23_37","072_23_37","LUK","23","37","37","kae kogaa agatou to'o atu kinai, “Ko Koe nimaa te Hakahua o na Jew, haka ma'ugi iho ia te Koe!” ");
INSERT INTO mnv_vpl VALUES ("LK23_38","072_23_38","LUK","23","38","38","Noko iai te kanukanu 'anga noko tuku ki 'agunga ia te Ia, noko kogaa na hai ake: “TENEI TE HAKAHUA O NA JEW.” ");
INSERT INTO mnv_vpl VALUES ("LK23_39","072_23_39","LUK","23","39","39","Noko iai te launatasi i gua pegea hai hai 'anga songo noko tau haka pigi kia te Ia noko gea maase'i kia Jesus, o hai atu, “Tenaa a koe te 'Agiki Taga'ia 'ine?! Haka ma'ugi ake ia te Koe ma kimaaua!” ");
INSERT INTO mnv_vpl VALUES ("LK23_40","072_23_40","LUK","23","40","40","Ka tegaa pegea hai hai 'anga songo noko susugi atu eia ma te hai atu kinai, “ 'Ai ko koe he'e mataku kia te 'Aitu, ka ko koe ma'u e kagohia pe Ia. ");
INSERT INTO mnv_vpl VALUES ("LK23_41","072_23_41","LUK","23","41","41","Tetaua kagohia manga 'aonga, iteme'agaa ko kitaaua gua pegea hai hai 'anga songo. Ka te pegea nei he'e hai e Ia he hai 'anga songo.” ");
INSERT INTO mnv_vpl VALUES ("LK23_42","072_23_42","LUK","23","42","42","Kae kogaa ana to'o atu, “Jesus, ogo maanatu mai ia te au i tou 'aso Hakahua!” ");
INSERT INTO mnv_vpl VALUES ("LK23_43","072_23_43","LUK","23","43","43","Ma te haka tau kinai a Jesus o hai atu kia te ia, “Ko Au e gea maa'ogi kia te koe: Te 'aso nei e hai ke haka pata ai koe kia te Au i te nuku gaoi.” ");
INSERT INTO mnv_vpl VALUES ("LK23_44","072_23_44","LUK","23","44","44","Nimaa hetae ki te 'ao 'aatea, kae poo'ugi ngatahi te kunga henua o hano aano hetae ki te ga'aa page. ");
INSERT INTO mnv_vpl VALUES ("LK23_45","072_23_45","LUK","23","45","45","Na he'e maagama ai te ga'aa. Kae malagi gua ai te laoa maatogu noko i te Hage Tapu o toka gua o na pa'asi. ");
INSERT INTO mnv_vpl VALUES ("LK23_46","072_23_46","LUK","23","46","46","Ko Jesus noko hai tena hu'ai ngege 'anga o hai ake, “Tamau, toku ma'ugi e tuku atu ki na gima o'ou!” Noko konei ana gea kae manaba taha'aki. ");
INSERT INTO mnv_vpl VALUES ("LK23_47","072_23_47","LUK","23","47","47","Te tugi tau'a na ina ki te hai 'anga e hai, ma te haka e'eha eia a te 'Aitu, o hai ake, “ 'Ai e maa'ogi ko Ia te pegea tinogaoi.” ");
INSERT INTO mnv_vpl VALUES ("LK23_48","072_23_48","LUK","23","48","48","Te 'apitanga noko haka putu mai o mata ki tena taa 'ia 'anga, ma ba'i hai 'anga noko hai. Ko kigatou noko tuki ogatou hatahata i te noko 'agogoha, kae giu ki ogatou manaha. ");
INSERT INTO mnv_vpl VALUES ("LK23_49","072_23_49","LUK","23","49","49","Ka na pegea noko na'a e kigatou ia Jesus, o haka pigi atu ki na haahine noko tata'o mai ia te Ia i Galilee, noko manga tutu'u mama'o o hiina'i ki na hai 'anga nei. ");
INSERT INTO mnv_vpl VALUES ("LK23_50","072_23_50","LUK","23","50","50","Noko iai te tangata noko mate tena ingoa ko Joseph, te pegea o te tu'uganga puuge, koia noko gaoi kae a'aki gaoi ma'u. ");
INSERT INTO mnv_vpl VALUES ("LK23_51","072_23_51","LUK","23","51","51","Koia noko he'e tata'o ki agatou paaunga ma agatou hai 'anga noko hai. Koia te pegea mai Arimathea, te manaha i Judea. Koia te pegea manga hitagi ke go ina ki te Hakahua 'anga a te 'Aitu. ");
INSERT INTO mnv_vpl VALUES ("LK23_52","072_23_52","LUK","23","52","52","Ko Joseph noko hano kia Pilate o haka ene kinai i te tino o Jesus. ");
INSERT INTO mnv_vpl VALUES ("LK23_53","072_23_53","LUK","23","53","53","O hano ia o 'ui o penapena i na laoa susugu, o tuku ki te takotonga noko kegi i te ogo hatu, te kunga noko manga koi he'e takoto ai he pegea. ");
INSERT INTO mnv_vpl VALUES ("LK23_54","072_23_54","LUK","23","54","54","Te 'aso na, te 'ao haka ngaague, 'io mugi o hetae ki te 'Ao oki oki. ");
INSERT INTO mnv_vpl VALUES ("LK23_55","072_23_55","LUK","23","55","55","Na haahine noko tata'o mai ia Jesus mai Galilee, noko tata'o tu'a ia Joseph o hiina'i ki te takotonga ma te tuku 'anga te tino o Jesus ki te takotonga. ");
INSERT INTO mnv_vpl VALUES ("LK23_56","072_23_56","LUK","23","56","56","Ko kigatou noko giu ki tegatou manaha o ngaague mai ai na me'a hu'ai tutuu gaoi ma na oel haka tutuu gaoi. Kae oki oki kigatou i te 'Ao oki oki i te mangangao ki te tagangonga. ");
INSERT INTO mnv_vpl VALUES ("LK24_1","072_24_1","LUK","24","1","1","Nimaa te taha'ata poo'ugi o te 'ao mu'a o te wiki, na haahine noko to'o e kigatou na me'a tutuu gaoi noko ngaague e kigatou o boo ki te takotonga. ");
INSERT INTO mnv_vpl VALUES ("LK24_2","072_24_2","LUK","24","2","2","Noko kite e kigatou te hatu kua hugi 'aatea i te takotonga. ");
INSERT INTO mnv_vpl VALUES ("LK24_3","072_24_3","LUK","24","3","3","Ka te gholoba noko he uguhi ai kigatou ki goto, noko he'e kite e kigatou te tino o te Hakahua ia Jesus. ");
INSERT INTO mnv_vpl VALUES ("LK24_4","072_24_4","LUK","24","4","4","Ko kigatou na manga tutu'u o ma he langalanga 'aki ai, ma te manga ghali gua taangata manga mamago i na ake hu'ai susugu pe na 'uiga o ma tutu'u haka pigi kia te kigatou. ");
INSERT INTO mnv_vpl VALUES ("LK24_5","072_24_5","LUK","24","5","5","Na haahine na hu'ai matataku o punonou ki te kege, ma te hai atu gua taangata kia te kigatou, “Tehea te hai 'anga e sasaga ai e koutou te tangata ma'ugi ki goto i te kunga o na pegea mamate? ");
INSERT INTO mnv_vpl VALUES ("LK24_6","072_24_6","LUK","24","6","6","Ko Ia he'e i te kunga nei! Ko Ia kua ma'ugi hoki! 'Ai koutou he'e maanatu giu ki nia noko gea ai kia te koutou i ona 'aso noko manga koi haka pata ai kia te koutou i Galilee? Noko hai atu ai: ");
INSERT INTO mnv_vpl VALUES ("LK24_7","072_24_7","LUK","24","7","7","‘Te Hosa o Pegea e hai ke go haiga'a ki na gima o na pegea 'oosongo ke taa ki te kros, ka nimaa i te togunga 'ao, ko Ia e hai ke go ma'ugi hoki.’ ” ");
INSERT INTO mnv_vpl VALUES ("LK24_8","072_24_8","LUK","24","8","8","Ma te maanatu giu kigatou ki ana gea 'anga. ");
INSERT INTO mnv_vpl VALUES ("LK24_9","072_24_9","LUK","24","9","9","Te 'aso noko giu ai kigatou i te takotonga, ko kigatou noko 'atigongo ai ki te tino anga hugu tuma'a e tasi pegea haka ako, ma gaa pegea ma'u. ");
INSERT INTO mnv_vpl VALUES ("LK24_10","072_24_10","LUK","24","10","10","Ko Mary mai Magdala, ma Joanna, ma Mary te tinana o James, ma gaa haahine noko haka pigi ma'u kia te kigatou te noko he 'atigongo 'aki i na hai 'anga nei ki na pegea haka to'o. ");
INSERT INTO mnv_vpl VALUES ("LK24_11","072_24_11","LUK","24","11","11","Ka noko he'e too na pegea haka to'o ki na haahine, iteme'agaa agatou gegea 'anga noko manga noho pe na me'a si'ai. ");
INSERT INTO mnv_vpl VALUES ("LK24_12","072_24_12","LUK","24","12","12","Ka ko Peter na tu'u o tege ki te takotonga o punou o baa ligo atu ki goto, manga na laoa te manga taahoga ai. Koia na hoki ma tena langalanga po nia te kua hai. ");
INSERT INTO mnv_vpl VALUES ("LK24_13","072_24_13","LUK","24","13","13","I te 'aso e tasi, noko boo ai te toka gua ia te kigatou ki te manaha e mate tena ingoa ko Emmaus, noko mama'o e hitunga mael i Jerusalem. ");
INSERT INTO mnv_vpl VALUES ("LK24_14","072_24_14","LUK","24","14","14","Ko kigaaua noko manga ba'aki boo ki ba'i hai 'anga kua 'oti i te hai. ");
INSERT INTO mnv_vpl VALUES ("LK24_15","072_24_15","LUK","24","15","15","Te gholoba noko manga hegeu boo ai a kigaaua ki na hai 'anga kua hai, ko Jesus noko a'u o hano hakapigi kia te kigaaua, ");
INSERT INTO mnv_vpl VALUES ("LK24_16","072_24_16","LUK","24","16","16","ka noko he'e haka 'igonga e kigaaua ia te Ia. ");
INSERT INTO mnv_vpl VALUES ("LK24_17","072_24_17","LUK","24","17","17","Ko Jesus noko haka anu kia te kigaaua o hai atu kinai, “Niaa te manga hegeu kinai kougua i taugua boomai 'anga nei?” Ko kigaaua na tutu'u haka ma'u o noko manga hiina'i haka 'aagoha. ");
INSERT INTO mnv_vpl VALUES ("LK24_18","072_24_18","LUK","24","18","18","Ka te launatasi ia te kigaaua, noko mate tena ingoa ko Cleopas, noko haka anu kia te Ia o hai atu, “ 'Ai ko koe te launatasi pegea manga hano ki Jerusalem, o he'e na'a na hai 'anga kua 'oti i te hai i te kungaa i na 'aso e sigi ange nei?” ");
INSERT INTO mnv_vpl VALUES ("LK24_19","072_24_19","LUK","24","19","19","Ka ko Ia noko haka tau o hai atu kinai, “Na hai 'anga aa?” Ka ko kigaaua noko haka tau o hai atu kia te Ia, “Na hai 'anga kua 'oti i te hai kia Jesus mai Nazareth. Ko Ia te taauga, hai taganga i ana gea 'anga ma na hai 'anga hai e Ia i 'ago ia te 'Aitu ma ba'i pegea. ");
INSERT INTO mnv_vpl VALUES ("LK24_20","072_24_20","LUK","24","20","20","Na tuginga o na Priest ma omatou hakahua kua tuku e kigatou ia te Ia ke mate, ma te maa'ogi kigatou o taa ki te kros. ");
INSERT INTO mnv_vpl VALUES ("LK24_21","072_24_21","LUK","24","21","21","Ka ko kimatou noko sano ake tenaa Ia e hai ke go haka tausu'u e Ia a Israel! E toe atu ma'u kogaa 'isi hai 'anga, ka tenei te togunga 'ao ki te hai 'anga na hai nei. ");
INSERT INTO mnv_vpl VALUES ("LK24_22","072_24_22","LUK","24","22","22","Noko iai ma'u kogaa haahine i tematou tu'uganga noko hai e kigatou ia te kimatou o he gege ma'ugi 'aki i te boo kigatou ki te takotonga i te taha'ata poo'ugi, ");
INSERT INTO mnv_vpl VALUES ("LK24_23","072_24_23","LUK","24","23","23","o he'e kite e kigatou te tino o'ona. Ko kigatou na manga giu mai o 'atigongo kia te kimatou i te kua hai tegatou maatanga ki gua ensel, noko 'atigongo ko Jesus kua ma'ugi hoki. ");
INSERT INTO mnv_vpl VALUES ("LK24_24","072_24_24","LUK","24","24","24","Noko iai kogaa i tematou tu'uganga noko boo ki te takotonga o kite e kigatou te gongo ana haahine e maa'ogi, ka ko kigatou noko he'e hiina'i kia te Ia.” ");
INSERT INTO mnv_vpl VALUES ("LK24_25","072_24_25","LUK","24","25","25","Nimaa hai atu a Jesus kia te kigaaua, “Kougua e he'e tau tegeu'a, ma te hu'ai ngese ougua uso ki te too kougua ki ba'i me'a noko gegea ai na taauga! ");
INSERT INTO mnv_vpl VALUES ("LK24_26","072_24_26","LUK","24","26","26","'Ai te 'Agiki Taga'ia noko he'e hai ke mataa tiha'ia i na hai 'anga nei, 'io mugi o hano ki tena mamagunga?” ");
INSERT INTO mnv_vpl VALUES ("LK24_27","072_24_27","LUK","24","27","27","Ko Jesus noko hogahoga e Ia kia te kigaaua nia noko gea kinai ba'i Kanukanu Tapu i na noho o 'Ona, noko haka tu'u mai i na buka a Moses ma a'ana taauga. ");
INSERT INTO mnv_vpl VALUES ("LK24_28","072_24_28","LUK","24","28","28","Nimaa hitaiaki a kigatou ki te manaha noko boo kinai, ko Jesus noko sa'akigoa e hai ke hano soo atu, ");
INSERT INTO mnv_vpl VALUES ("LK24_29","072_24_29","LUK","24","29","29","ka noko susugi toto'a e kigaaua ia te Ia o hai atu kinai, “Haka pata mai kia te kimaaua, na'e kua ahiahi. Te 'aso nei e hitaiaki ke poo.” Ma te tata'o Ia o haka pata kia te kigaaua. ");
INSERT INTO mnv_vpl VALUES ("LK24_30","072_24_30","LUK","24","30","30","Te gholoba noko noho haka pigi ai Ia kia te kigaaua i te kunga kai, noko sa'u ake e Ia na utunga o haka 'atu'atu ai kia te 'Aitu, kae tohitohi e Ia o 'abange kia te kigaaua. ");
INSERT INTO mnv_vpl VALUES ("LK24_31","072_24_31","LUK","24","31","31","Ma te lugaluga ogaua mata o hiina'i gaoi atu kinai kigaaua o haka 'igonga e kigaaua ko Jesus, kae nimo maatanga kigaaua ia te Ia. ");
INSERT INTO mnv_vpl VALUES ("LK24_32","072_24_32","LUK","24","32","32","Ko kigaaua noko manga hegeu toka gua o hai ake, “Otaaua uso noko bega i te gholoba manga hegeu boo iho ai kitatou i te aga ma na hogahoga 'anga ma'u e Ia kia te kitaaua na me'a noko gea kinai na Kanukanu Tapu.” ");
INSERT INTO mnv_vpl VALUES ("LK24_33","072_24_33","LUK","24","33","33","Ko kigaaua na tutu'u ghali o giu ki Jerusalem. O boo kigaaua o kite i te tino anga hugu tuma'a e tasi pegea haka ako, ma gaa pegea kua haka putu ngatahi, ");
INSERT INTO mnv_vpl VALUES ("LK24_34","072_24_34","LUK","24","34","34","o manga gegea, “E hu'ai maa'ogi, te Hakahua kua ma'ugi hoki o haka 'agitino kia Simon.” ");
INSERT INTO mnv_vpl VALUES ("LK24_35","072_24_35","LUK","24","35","35","Kae mugi kigaaua o hogahoga nia kua hai kia te kigaaua i te agaa, ma te hogahoga ma'u e kigaaua te haka 'igonga 'anga e kigaaua ia Jesus i te 'aso e tohitohi ai e Ia te bred. ");
INSERT INTO mnv_vpl VALUES ("LK24_36","072_24_36","LUK","24","36","36","Te gholoba noko manga koi 'atigongo ai kigaaua i te hai 'anga nei, ko Jesus na tu'u goto ia te kigatou o hai atu kinai, “Te goto maagie ke noho kia te koutou.” ");
INSERT INTO mnv_vpl VALUES ("LK24_37","072_24_37","LUK","24","37","37","Ko kigatou noko he gegema'ugi 'aki ma te matataku i te tegeu'a ake ko kigatou e hiina'i ki te 'atua. ");
INSERT INTO mnv_vpl VALUES ("LK24_38","072_24_38","LUK","24","38","38","Ka ko Jesus noko hai atu kia te kigatou, “ 'Eaa e maikia ai koutou? 'Eaa e sosopo ake ai na mou tegeu'a i na uso outou? ");
INSERT INTO mnv_vpl VALUES ("LK24_39","072_24_39","LUK","24","39","39","Hiina'i mai ki gua gima ma gua tapungao o 'oku o na'a ai e koutou, tenei Au! He 'osohi mai kia te Au o na'a, na'e na 'atua e he'e tau tino o he'e tau ibi, ke konei na noho ko Au e hiina'i kinai koutou.” ");
INSERT INTO mnv_vpl VALUES ("LK24_40","072_24_40","LUK","24","40","40","Te gholoba noko konei ana gea ai kia te kigatou, kae haka 'agi kinai gua gima ma gua tapungao, ");
INSERT INTO mnv_vpl VALUES ("LK24_41","072_24_41","LUK","24","41","41","ko kigatou noko ma koi he'e too kinai, iteme'agaa noko sisia ma te he gegema'ugi 'aki ai, ka ko Ia noko haka anu kia te kigatou o hai atu, “E hai ma'autou ni utunga i te kunga nei ke kai?” ");
INSERT INTO mnv_vpl VALUES ("LK24_42","072_24_42","LUK","24","42","42","Ma te 'abange kinai e kigatou te momo kaui moso. ");
INSERT INTO mnv_vpl VALUES ("LK24_43","072_24_43","LUK","24","43","43","O sa'u ake e Ia o kai i 'ago ia te kigatou. ");
INSERT INTO mnv_vpl VALUES ("LK24_44","072_24_44","LUK","24","44","44","Kae hai atu kia te kigatou, “Te hai 'anga nei na goa te 'atigongo ai Au kia te koutou i oku 'aso noko ta'anga haka pata ai kia te koutou, ko ba'i me'a noko kanukanu i na noho o'oku ki na tagangonga a Moses, ma a'ana taauga ma te buka o na taugua e hai ke haka maa'ogi.” ");
INSERT INTO mnv_vpl VALUES ("LK24_45","072_24_45","LUK","24","45","45","Kae hai e Jesus ogatou uso o na'a e kigatou na Kanukanu Tapu. ");
INSERT INTO mnv_vpl VALUES ("LK24_46","072_24_46","LUK","24","46","46","Hai atu a Jesus kia te kigatou, “Tenei te me'a noko kanukanu: Te 'Agiki Taga'ia e hai ke go tiha'ia aano mate, kae ma'ugi hokimai i te togunga 'ao. ");
INSERT INTO mnv_vpl VALUES ("LK24_47","072_24_47","LUK","24","47","47","Kae hai ke tohi'aki i tena ingoa ki ba'i pegea i ba'i kunga ke sui tegeu'a ma te haka noka ai na 'oosongo, e hai ke go haka tu'u i Jerusalem. ");
INSERT INTO mnv_vpl VALUES ("LK24_48","072_24_48","LUK","24","48","48","Koutou e hai ke 'atigongo i na hai 'anga kua hiina'i kinai koutou. ");
INSERT INTO mnv_vpl VALUES ("LK24_49","072_24_49","LUK","24","49","49","Ka ko Au te hai kau go haiga'a 'ia kia te koutou nia noko tuku kupu ai a Tamau. Kae noko hiina'i iho i te hu'ai manaha nei aano hetae ki te gholoba e hai ke go a'u ai te Spirit Tapu o haiga'a na taganga mai ia te Ia e ma'u 'agunga kia te koutou.” ");
INSERT INTO mnv_vpl VALUES ("LK24_50","072_24_50","LUK","24","50","50","Ko Jesus noko kakabe e Ia ia te kigatou o boo o hetae ki Bethany, o haka tutu'u gua gima o haka gaoi ia te kigatou. ");
INSERT INTO mnv_vpl VALUES ("LK24_51","072_24_51","LUK","24","51","51","Te gholoba noko ma haka gaoi ai e Ia ia te kigatou, kae hano ia te kigatou o to'ogia ki 'agunga i te gangi. ");
INSERT INTO mnv_vpl VALUES ("LK24_52","072_24_52","LUK","24","52","52","Kae sogi kigatou kia te Ia kae giu ki Jerusalem, ma te hu'ai magagaohie. ");
INSERT INTO mnv_vpl VALUES ("LK24_53","072_24_53","LUK","24","53","53","Ko kigatou noko manga noho 'aki i te Hage Tapu i ba'i 'aso o noko manga haka e'eha ia te 'Aitu.");
INSERT INTO mnv_vpl VALUES ("JN1_1","073_1_1","JHN","1","1","1","I te hakatu'u sanga, te “Haka hegeunga”. Te “Haka hegeunga” noko manga haka pata kia te 'Aitu. Te “Haka hegeunga” ko te 'Aitu. ");
INSERT INTO mnv_vpl VALUES ("JN1_2","073_1_2","JHN","1","2","2","Ko Ia noko manga haka pata kia te 'Aitu i te hakatu'u sanga. ");
INSERT INTO mnv_vpl VALUES ("JN1_3","073_1_3","JHN","1","3","3","Ko ba'i me'a na manga gosigosi ia te Ia, ka poi si'ai ia te Ia, ma he'e tau me'a i na me'a noko gosigosi na gosigosi. ");
INSERT INTO mnv_vpl VALUES ("JN1_4","073_1_4","JHN","1","4","4","Te ma'ugi manga ia te Ia, ka te ma'ugi na te maagama o pegea. ");
INSERT INTO mnv_vpl VALUES ("JN1_5","073_1_5","JHN","1","5","5","Te maagama nei e kaa i te poo'uginga, ka te poo'uginga noko he'e na'a e ia. ");
INSERT INTO mnv_vpl VALUES ("JN1_6","073_1_6","JHN","1","6","6","Ma te haka to'o mai e te 'Aitu te pegea; tena ingoa ko John. ");
INSERT INTO mnv_vpl VALUES ("JN1_7","073_1_7","JHN","1","7","7","Koia noko a'u ke 'atigongo 'aabaki i te maagama na, ka ke too kinai a pegea agatu'u ia te Ia. ");
INSERT INTO mnv_vpl VALUES ("JN1_8","073_1_8","JHN","1","8","8","Koia he'e te maagama; koia manga a'u ke 'atigongo 'aabaki i te maagama. ");
INSERT INTO mnv_vpl VALUES ("JN1_9","073_1_9","JHN","1","9","9","Te maagama maa'ogi e haiga'a te maagama ki ba'i pegea kua a'u ki te kege nei. ");
INSERT INTO mnv_vpl VALUES ("JN1_10","073_1_10","JHN","1","10","10","Ko Ia noko manga i te kege nei. Masi'igoa ko te kege nei noko manga gosigosi ia te Ia, ka ko te kege nei noko he'e haka'igonga ia te Ia. ");
INSERT INTO mnv_vpl VALUES ("JN1_11","073_1_11","JHN","1","11","11","Ko Ia noko a'u ki na pegea o tena kakai 'anga, ka noko he'e to'o ia te Ia. ");
INSERT INTO mnv_vpl VALUES ("JN1_12","073_1_12","JHN","1","12","12","Ka ki ba'i pegea na to'o ia te Ia, ki na pegea na too ki te ingoa o'Ona, na haiga'a kinai e Ia te taganga ke hai ai na tama giki a te 'Aitu. ");
INSERT INTO mnv_vpl VALUES ("JN1_13","073_1_13","JHN","1","13","13","Na tamagiki he'e hai i na noho o pegea, o he'e hai i na maanatu a pegea po na paaunga a na matu'a, kae sosopo mai ia te 'Aitu. ");
INSERT INTO mnv_vpl VALUES ("JN1_14","073_1_14","JHN","1","14","14","Te “Haka hegeunga” na a'u o hai ai te pegea, o haka pata kia te kitatou. Ko kimatou na hiina'i ki tona mamagunga, te mamagunga o te Launatasi e Tasi. Noko a'u ia te Tamana, noko honu ia te Ia te 'agoha ma te ma'ine. ");
INSERT INTO mnv_vpl VALUES ("JN1_15","073_1_15","JHN","1","15","15","Ko John noko manga 'atigongo ia te Ia. Ko ia noko ngege o hai atu, “Tenei Ia noko 'atigongo goa ai au kia te koutou e mugi mai ia te au. Kae hua'eha o sigi ia te au, iteme'agaa ko au noko mugi o haka haa, ka ko Ia na goa te noho.” ");
INSERT INTO mnv_vpl VALUES ("JN1_16","073_1_16","JHN","1","16","16","I tona hu'ai 'agoha, ko kitatou kua ga'u haka hanohano e kitatou ngatahi na haka gaoinga mai ia te Ia. ");
INSERT INTO mnv_vpl VALUES ("JN1_17","073_1_17","JHN","1","17","17","Iteme'agaa na tagangonga noko haiga'a mai ia Moses, ka te hu'ai 'agoha ma te maa'ogi noko a'u ia Jesus Christ. ");
INSERT INTO mnv_vpl VALUES ("JN1_18","073_1_18","JHN","1","18","18","E si'ai he pegea ina kia te 'Aitu, ka manga ko te 'Aitu te Launatasi e Tasi te manga i te pa'asi o te Tamana, na hai e Ia ia te Ia o na'a. ");
INSERT INTO mnv_vpl VALUES ("JN1_19","073_1_19","JHN","1","19","19","Tenei te taukimata a John Baptist i te 'aso na haka to'o ai e na Jew o Jerusalem na priest ma na pegea i te hanohano o Levi o boo ke haka anuanu 'aki kia te ia po koia koai. ");
INSERT INTO mnv_vpl VALUES ("JN1_20","073_1_20","JHN","1","20","20","Ka noko he'e huu ai, manga hogahoga hakatino gaoi e ia o kogaa ana to'o, “Koau he'e te 'Agiki Taga'ia.” ");
INSERT INTO mnv_vpl VALUES ("JN1_21","073_1_21","JHN","1","21","21","Haka anu 'aki giu o hai atu, “ 'Ai koai ko koe? Ko koe ko Elijah?” Haka tau a John o hai atu, “Koau e he'e ko Elijah.” Haka anu 'aki giu kigatou o hai atu, “ 'Ai ko koe te Taauga?” Haka tau o hai atu, “Si'ai.” ");
INSERT INTO mnv_vpl VALUES ("JN1_22","073_1_22","JHN","1","22","22","Ma te hai taha'aki atu kinai kigatou, “Koai okoia ko koe? Hogahoga mai, ka kimatou boo o hogahoga 'ia ki na pegea e haka to'o mai ia te kimatou. Tehea tau gea 'anga ia te koe?” ");
INSERT INTO mnv_vpl VALUES ("JN1_23","073_1_23","JHN","1","23","23","Haka tau kinai a John i na hakahegeunga a Isaiah te taauga, o hai atu, “Ko au te ge'o o te launatasi e ngege i te tugatea, ‘Haka tinogaoi ake te aga kia te 'Agiki.’ ” ");
INSERT INTO mnv_vpl VALUES ("JN1_24","073_1_24","JHN","1","24","24","Na to'onga gongo noko tuku ena Pharisee, ");
INSERT INTO mnv_vpl VALUES ("JN1_25","073_1_25","JHN","1","25","25","noko haka anuanu 'aki kia John o hai atu kinai, “Ka 'eaa a koe e haa gogomi pegea ai ka ko koe he'e te 'Agiki Taga'ia, he'e ko Elijah, he'e te Taauga ma'u?” ");
INSERT INTO mnv_vpl VALUES ("JN1_26","073_1_26","JHN","1","26","26","Ma te haka tau a John o hai atu, “Koau e haa gogomi pegea i te bai, kae e iai te pegea manga tu'u uso ia te koutou e he'e na'a e koutou. ");
INSERT INTO mnv_vpl VALUES ("JN1_27","073_1_27","JHN","1","27","27","Ko Ia e mugi mai ia te au. E he'e 'aonga te bebete e au ona taka ba'e.” ");
INSERT INTO mnv_vpl VALUES ("JN1_28","073_1_28","JHN","1","28","28","Na hai 'anga nei noko hai i Bethany i tegaa pa'asi i te bai mimigo i Jordan, noko ma haa gogomi pegea ai a John. ");
INSERT INTO mnv_vpl VALUES ("JN1_29","073_1_29","JHN","1","29","29","Nimaa i tegaa 'ao, ina a John kia Jesus e a'u kia te ia, ma te haka kite atu a John, “Hiina'i atu ki te punua sipisipi a te 'Aitu, e hai ke sa'u 'aatea na 'oosongo o gago nei. ");
INSERT INTO mnv_vpl VALUES ("JN1_30","073_1_30","JHN","1","30","30","Tenei te pegea e 'atigongo goa ai au o hai atu, ‘E iai te pegea e mugi mai ia te au, ko Ia e hua'eha o sigi ia te au, iteme'agaa ko Ia noko haka tu'u mai gaa 'aso 'io mugi au.’ ");
INSERT INTO mnv_vpl VALUES ("JN1_31","073_1_31","JHN","1","31","31","Ko Ia noko he'e na'a ma'u eau, ka koau na a'u o haa gogomi pegea i te bai, ka kego na'a e Israel ia te Ia.” ");
INSERT INTO mnv_vpl VALUES ("JN1_32","073_1_32","JHN","1","32","32","Ma te taukimata ma'u a John o hai atu, “Koau noko ina ki te Spirit noko hinaiho mai te gangi manga noho pe te gupe o tu'u kia te Ia. ");
INSERT INTO mnv_vpl VALUES ("JN1_33","073_1_33","JHN","1","33","33","Ko Ia noko he'e na'a eau, ka te pegea noko tuku mai ia te au kau haa gogomi pegea i te bai, te noko hogahoga mai e Ia kia te au o hai mai, ‘Te pegea e hai kego ina kinai koe e iho mai te Spirit o tu'u kinai, tena Ia e hai kego haa gogomi pegea i te Spirit Tapu.’ ");
INSERT INTO mnv_vpl VALUES ("JN1_34","073_1_34","JHN","1","34","34","Ka ko au kua ina kia te Ia, ma te 'atigongo atu: Tenei te Hosa o te 'Aitu.” ");
INSERT INTO mnv_vpl VALUES ("JN1_35","073_1_35","JHN","1","35","35","Nimaa i tegaa 'ao, ko John ma gua 'ona pegea haka ako noko manga i te kungaa ma'u. ");
INSERT INTO mnv_vpl VALUES ("JN1_36","073_1_36","JHN","1","36","36","Nimaa ina 'atu a John kia Jesus kae a'u o sigi, manga hai atu, “Hiina'i atu, tenaa te punua sipisipi a te 'Aitu!” ");
INSERT INTO mnv_vpl VALUES ("JN1_37","073_1_37","JHN","1","37","37","Te gholoba na haka gongo ai gua pegea haka ako o John kia te ia ma te tata'o ia Jesus. ");
INSERT INTO mnv_vpl VALUES ("JN1_38","073_1_38","JHN","1","38","38","Manga keu hokimai a Jesus o ina kia te kigaaua manga tata'o mugi o hakaanu atu, “Niaa te sasaga e kougua?” Ma te hai atu a kigaaua, “Rabbi” (e haka gaataki te ako), “ko Koe manga kakai i hea?” ");
INSERT INTO mnv_vpl VALUES ("JN1_39","073_1_39","JHN","1","39","39","Hai atu a Jesus, “Boomai o hiina'i kinai.” Ma te boo o hetae ki tena kunga kakai o haka pata kinai kigaaua i te ga'aa page o hetae ki te ahiahi. ");
INSERT INTO mnv_vpl VALUES ("JN1_40","073_1_40","JHN","1","40","40","Ko Andrew, te taina o Simon Peter, te launatasi i gua pegea noko haka gongo ki te gea 'anga a John o tata'o ia Jesus. ");
INSERT INTO mnv_vpl VALUES ("JN1_41","073_1_41","JHN","1","41","41","Tegaa te hai 'anga noko mataa hai e Andrew, te sasaga ia tena ta'okete ia Simon o 'atigongo kinai, “Kua kite e kimaaua te 'Agiki Taga'ia” (e haka gaataki te Christ). ");
INSERT INTO mnv_vpl VALUES ("JN1_42","073_1_42","JHN","1","42","42","Kae kakabe eia ia Peter kia Jesus. Ina 'atu kinai a Jesus o hai atu, “Ko koe ko Simon, te Hosa o John, ka ko koe e hai ke go ingoa ko Cephas” (E tasi o na noho ma te ingoa Peter). ");
INSERT INTO mnv_vpl VALUES ("JN1_43","073_1_43","JHN","1","43","43","Nimaa i tegaa 'ao, kae tegeu'a a Jesus ke hano ki Galilee. Manga kite ia Philip, o hai atu kinai, “Tata'o mai ia te Au.” ");
INSERT INTO mnv_vpl VALUES ("JN1_44","073_1_44","JHN","1","44","44","Ko Philip te pegea mai Bethsaida, te manaha ma'u o Andrew ma Peter. ");
INSERT INTO mnv_vpl VALUES ("JN1_45","073_1_45","JHN","1","45","45","Kite a Philip ia Nathaniel o hai atu kinai, “Kua kite e kimatou te pegea noko kanukanu ai a Moses i na Tagangonga. Ma te taga gongo ma'u ai na taauga: Ko Jesus mai Nazareth, te Hosa o Joseph.” ");
INSERT INTO mnv_vpl VALUES ("JN1_46","073_1_46","JHN","1","46","46","Ma te hakaanu atu a Nathaniel, “Nazareth! Te kunga na ma 'aonga te sopo mai ai he hai 'anga gaoi?!” Ma te hai atu kinai a Philip, “Manga a'u o ina kinai.” ");
INSERT INTO mnv_vpl VALUES ("JN1_47","073_1_47","JHN","1","47","47","Nimaa ina 'atu a Jesus kia Nathaniel e a'u kia te Ia, ma te hai atu kinai a Jesus, “Tenei te pegea maa'ogi mai Israel, koia e he'e 'aonga te goi.” ");
INSERT INTO mnv_vpl VALUES ("JN1_48","073_1_48","JHN","1","48","48","Haka anu atu kinai a Nathaniel, “E kohea na na'a e Koe ia te au?” Haka tau a Jesus o hai atu kinai, “Ko Au noko ina kia te koe i te gago o te ga'akau e ingoa te ‘fig’, 'io mugi a Philip o gea kia te koe.” ");
INSERT INTO mnv_vpl VALUES ("JN1_49","073_1_49","JHN","1","49","49","Ma te haka tau a Nathaniel o hai atu, “Rabbi, ko Koe te Hosa o te 'Aitu! Te Hakahua o Israel.” ");
INSERT INTO mnv_vpl VALUES ("JN1_50","073_1_50","JHN","1","50","50","Hai atu a Jesus kia te ia, “Ko koe manga too kia te Au i taku hai atu 'anga, Ko Au noko ina kia te koe i te gago o te ga'akau e ingoa te ‘fig’, ka ko koe kago ina ki ni hu'ai hai 'anga go sigi i te hai 'anga nei!” ");
INSERT INTO mnv_vpl VALUES ("JN1_51","073_1_51","JHN","1","51","51","Hai atu ma'u kia te ia, “Ko Au e gea maa'ogi atu kia te koutou, e hai ke go hiina'i koutou ki te gangi kago luga kae he'aki na ensel o te 'Aitu o boo ki 'agunga ma te boo iho ki te Hosa o Pegea.” ");
INSERT INTO mnv_vpl VALUES ("JN2_1","073_2_1","JHN","2","1","1","Nimaa i te togunga 'ao, kae hai te noohonga i Cana, te kunga i Galilee. Te tinana o Jesus noko ma i te kunga na. ");
INSERT INTO mnv_vpl VALUES ("JN2_2","073_2_2","JHN","2","2","2","Ka noko haka pogo 'ia ma'u a Jesus ma ona pegea haka ako ki te haka tahinga ki te noohonga hai ho'ou. ");
INSERT INTO mnv_vpl VALUES ("JN2_3","073_2_3","JHN","2","3","3","Te gholoba na masa ai na bai waeni, ma te hai atu te tinana o Jesus kia te Ia, “Na pegea nei kua he'e tau waeni.” ");
INSERT INTO mnv_vpl VALUES ("JN2_4","073_2_4","JHN","2","4","4","Haka tau atu a Jesus, “Ta'ahine, 'Eaa e ha 'abaki ai e koe ia te Au? Ma koi he'e tatae toku 'aso.” ");
INSERT INTO mnv_vpl VALUES ("JN2_5","073_2_5","JHN","2","5","5","Ma te hai atu a te tinana ki na guani, “Hai atu nia go gea ai kia te koutou.” ");
INSERT INTO mnv_vpl VALUES ("JN2_6","073_2_6","JHN","2","6","6","Te kunga noko ma pata ai noko ma tutu'u ai te tokaono hu'ai poati hai i na hatu, te hainga poati noko ta'a hai e na Jew o huhu'i ai ia te kigatou ke ma'a; te launatasi i na poati nei noko ma 'aonga te pipiki ai he katoa haka gua poe katoa haka togu galon i goto. ");
INSERT INTO mnv_vpl VALUES ("JN2_7","073_2_7","JHN","2","7","7","Hai atu a Jesus ki na guani, “ 'Utuhaki atu na poati na i ni bai.” Ma te 'utuhaki e kigatou o hohonu ngatahi. ");
INSERT INTO mnv_vpl VALUES ("JN2_8","073_2_8","JHN","2","8","8","Kae hai atu Ia kia te kigatou, “Gigingi atu ni me'a o to'o ki te hakahua o te haka tahinga nei.” Ma te konaa na hai e kigatou, ");
INSERT INTO mnv_vpl VALUES ("JN2_9","073_2_9","JHN","2","9","9","o binu lobo e te hakahua o te haka tahinga te bai kua hai ai te waeni. Ka noko he'e na'a eia po na me'a mai hea, ka noko manga na'a e na guani noko 'utuhaki e kigatou. Ma te ngege i te tangata noko hai uguugu ho'ou, ");
INSERT INTO mnv_vpl VALUES ("JN2_10","073_2_10","JHN","2","10","10","o hai atu kia te ia, “Ko ba'i pegea e mataa tuha na waeni gaoi to'a, 'io ano mugi na waeni he'e hu'ai gaoi i te gholoba kua pau ba'i pegea o 'eha tegatou bibinu 'anga; ka ko koe kua pipiki na waeni hu'ai gaoi o hetae mai ki te gholoba nei.” ");
INSERT INTO mnv_vpl VALUES ("JN2_11","073_2_11","JHN","2","11","11","Tenei te haka 'igonga haka gege ma'ugi noko mataa hai e Jesus i Cana i Galilee, noko haka 'agi ma'u ai tona mamagunga, o too ai ona pegea haka ako kia te Ia. ");
INSERT INTO mnv_vpl VALUES ("JN2_12","073_2_12","JHN","2","12","12","Mugi i te hai 'anga nei, kae boo ma te tinana ma ona hai taina ma ona pegea haka ako ki Capernaum o noho 'aki ai ogatou 'ao. ");
INSERT INTO mnv_vpl VALUES ("JN2_13","073_2_13","JHN","2","13","13","Nimaa hitaiaki ki te 'aso o te haka tahinga a Jew e mate te ‘Passover’, hakaneke a Jesus ki Jerusalem. ");
INSERT INTO mnv_vpl VALUES ("JN2_14","073_2_14","JHN","2","14","14","Kite ai Ia i na pegea i goto i te Hage Tapu manga he tau'i 'aki agatou buluka ma agatou sipisipi ma agatou gupe. Ma te noho 'aki kogaa pegea ki na kaupea o manga sui mane. ");
INSERT INTO mnv_vpl VALUES ("JN2_15","073_2_15","JHN","2","15","15","Ma te hai tena sasau i te potu uka o taa 'agu'agu ngatahi iho ai e Ia i te Hage Tapu, na sipisipi ma na buluka; lube'i e Ia na mane a na pegea sui mane kae 'aka gigingi 'ogatou kaupea. ");
INSERT INTO mnv_vpl VALUES ("JN2_16","073_2_16","JHN","2","16","16","Kae hai atu ki na pegea noko tau'i agatou gupe, “To'o atu na me'a nei ki haho. Noka te hai mo'outou he kunga he tau'i 'aki i te hage o Tamau.” ");
INSERT INTO mnv_vpl VALUES ("JN2_17","073_2_17","JHN","2","17","17","Ma te maanatu giu na pegea haka ako, ki nia noko kanukanu mai i gaa 'aso o hai ake: “Taku tuubaa i tou hage e bega ai toku uso.” ");
INSERT INTO mnv_vpl VALUES ("JN2_18","073_2_18","JHN","2","18","18","Ma te boomai na Jew o gegea toto'a kia te ia o hai atu kinai, “Tehea te haka'igonga haka gege ma'ugi e hai ke haka'agi e koe kia te kimatou, ka kimatou na'a ai 'ina ko koe te hakahua ka ke 'aonga te hai e Koe na hai 'anga nei?” ");
INSERT INTO mnv_vpl VALUES ("JN2_19","073_2_19","JHN","2","19","19","Haka tau kinai a Jesus o hai atu, “Tuki atu te Hage Tapu nei, kae 'ati haka hoki e Au i he togunga 'ao.” ");
INSERT INTO mnv_vpl VALUES ("JN2_20","073_2_20","JHN","2","20","20","Haka tau 'aki hoki atu na Jew, “ 'Te Hage Tapu nei noko 'ati i te katoa haka haa tuma'a e ono (46) ghapu, kae ka 'ati e koe i te togunga 'ao?” ");
INSERT INTO mnv_vpl VALUES ("JN2_21","073_2_21","JHN","2","21","21","Ka te Hage Tapu noko gea kinai a Jesus te tino o'ona. ");
INSERT INTO mnv_vpl VALUES ("JN2_22","073_2_22","JHN","2","22","22","Mugi i te ma'ugi hokimai 'anga Ia i tena mate 'anga, maanatu giu ona pegea haka ako ki nia noko gea kinai Ia, ma te too ai kigatou ki na Kanukanu Tapu, ma na haka hegeunga noko gea ai a Jesus. ");
INSERT INTO mnv_vpl VALUES ("JN2_23","073_2_23","JHN","2","23","23","Nimaa i te 'aso noko noho ai Ia i Jerusalem i te 'aso noko hai ai te haka tahinga o te Passover, noko 'api pegea noko too kia te Ia, i te noko hiina'i kigatou ki na hu'ai hekau noko hai e Ia. ");
INSERT INTO mnv_vpl VALUES ("JN2_24","073_2_24","JHN","2","24","24","Ka ko Jesus noko he'e sano ki he pegea ia te kigatou, iteme'agaa noko manga na'a ngatahi e Ia ia te kigatou. ");
INSERT INTO mnv_vpl VALUES ("JN2_25","073_2_25","JHN","2","25","25","Noko he'e hai ke hogahoga e he pegea kia te Ia na noho o pegea, iteme'agaa noko manga na'a e Ia, nia manga i na uso o pegea. ");
INSERT INTO mnv_vpl VALUES ("JN3_1","073_3_1","JHN","3","1","1","Noko iai te pegea o na Pharisee noko ingoa ko Nicodemus, te pegea i na mu'a 'aki o na Jew. ");
INSERT INTO mnv_vpl VALUES ("JN3_2","073_3_2","JHN","3","2","2","Koia noko a'u kia Jesus i te poo o hai atu, “Ako, e na'a e kimatou ko Koe te Ako e a'u mai a te 'Aitu, iteme'agaa e si'ai he pegea 'aonga te hai na hai 'anga haka gege ma'ugi e hai e Koe i te poi he'e haka pata a te 'Aitu kia te ia.” ");
INSERT INTO mnv_vpl VALUES ("JN3_3","073_3_3","JHN","3","3","3","Haka tau kinai a Jesus o hakamaahoga atu, “Ko Au e gea maa'ogi atu kia te koe: Kago si'ai he pegea ke go na'a eia te Hakahua 'anga a te 'Aitu i te poi he'e haa haka hoki.” ");
INSERT INTO mnv_vpl VALUES ("JN3_4","073_3_4","JHN","3","4","4","Haka anu a Nicodemus o hai atu, “E hai ke kohea na haa haka hoki he pegea i te tauiku 'anga? Koia ka he'e 'aonga te mene haka hoki ki te tina'e o te tinana ke haa haka hoki!” ");
INSERT INTO mnv_vpl VALUES ("JN3_5","073_3_5","JHN","3","5","5","Haka tau kinai a Jesus o hai atu, “Ko Au e gea maa'ogi atu kia te koe: Ka he'e tau pegea hano ki goto i te Hakahua 'anga a te 'Aitu, naakupu ki te haka haa i te bai ma te Spirit. ");
INSERT INTO mnv_vpl VALUES ("JN3_6","073_3_6","JHN","3","6","6","Te tino e haka haa te tino, ka te Spirit e haka haa te Spirit. ");
INSERT INTO mnv_vpl VALUES ("JN3_7","073_3_7","JHN","3","7","7","Ko koe e he'e hai ke langalanga i nia e gea kinai au, ‘Ko koe e hai ke haa haka hoki.’ ");
INSERT INTO mnv_vpl VALUES ("JN3_8","073_3_8","JHN","3","8","8","Te oko manga pusi ki te kunga e siahai ke hano kinai. Hakagongo a koe ki tena hahangu 'anga, ka ka he'e na'a e koe te kunga e pusi mai ai po te kunga e pusi kinai. Ma konaa na noho ma'u ba'i pegea e haa i te Spirit Tapu.” ");
INSERT INTO mnv_vpl VALUES ("JN3_9","073_3_9","JHN","3","9","9","Haka anu atu a Nicodemus, “E hai ke kohea o na hai?” ");
INSERT INTO mnv_vpl VALUES ("JN3_10","073_3_10","JHN","3","10","10","Hai atu a Jesus, “Ko koe te ako o Israel, ka e he'e na'a e koe na hai 'anga nei?! ");
INSERT INTO mnv_vpl VALUES ("JN3_11","073_3_11","JHN","3","11","11","Ko Au e gea maa'ogi kia te koe: Ko kimatou e hegeu ki nia e na'a e kimatou, ma te he hogahoga 'aki e kimatou nia noko hiina'i kinai kimatou. Ka koi he'e tau pegea ia te koutou ke to'o nia manga he 'atigongo 'aki ai kimatou. ");
INSERT INTO mnv_vpl VALUES ("JN3_12","073_3_12","JHN","3","12","12","Koutou e he'e too kia te Au i aku 'atigongo 'anga kia te koutou i na me'a o gago nei. Ka hai ke go kohea autou too kia te Au, i te poi 'atigongo Au kia te koutou i na me'a o te gangi? ");
INSERT INTO mnv_vpl VALUES ("JN3_13","073_3_13","JHN","3","13","13","E he'e tau pegea hano ki te gangi, ka manga te pegea noko hinaiho mai te gangi, te Hosa o Pegea. ");
INSERT INTO mnv_vpl VALUES ("JN3_14","073_3_14","JHN","3","14","14","Ka hai ke go noho pe te haka tu'u 'anga e Moses te ga'akau noko iai te ngata i te tugatea, e hai ke go konaa o na tau ma'u te Hosa o Pegea. ");
INSERT INTO mnv_vpl VALUES ("JN3_15","073_3_15","JHN","3","15","15","Ka ko ba'i pegea e too kia te Ia e hai ke go ga'u e kigatou te ma'ugi noho goa. ");
INSERT INTO mnv_vpl VALUES ("JN3_16","073_3_16","JHN","3","16","16","“Iteme'agaa te 'Aitu noko hu'ai ma'ine ki gago nei, o haiga'a mai tena Hosa e tasi, ke nimaa too he pegea kia te Ia, ko ia kago he'e mate, ka e hai ke go ga'u eia te ma'ugi noho goa. ");
INSERT INTO mnv_vpl VALUES ("JN3_17","073_3_17","JHN","3","17","17","Iteme'agaa te 'Aitu noko he'e haka to'o mai e Ia tena Hosa ki gago nei ke hai songo e Ia ia pegea, ka noko a'u ke haka maa'ugi a pegea ia te Ia. ");
INSERT INTO mnv_vpl VALUES ("JN3_18","073_3_18","JHN","3","18","18","Koai e too kia te Ia, koia he'e hai songo 'ia. Ka koai e he'e too kinai, koia kua 'oti i te noho i te hai maase'i 'ia, iteme'agaa, koia e he'e too ki te ingoa o te Hosa e tasi o te 'Aitu. ");
INSERT INTO mnv_vpl VALUES ("JN3_19","073_3_19","JHN","3","19","19","E hai ke konei na noho tena haka aba sanga: Te maagama na 'oti i te a'u ki te kege nei, ka ko pegea noko maa'ine ki te poo'uginga o sigi i te maagama, iteme'agaa 'agaatou hekau noko songo toto'a. ");
INSERT INTO mnv_vpl VALUES ("JN3_20","073_3_20","JHN","3","20","20","Koai manga hai hai 'anga songo, e he'e siahai ki te maagama o he'e a'u ki te maagama, iteme'agaa e mataku ana hai hai 'anga songo 'anga ka hiina'i kinai. ");
INSERT INTO mnv_vpl VALUES ("JN3_21","073_3_21","JHN","3","21","21","Ka koai e noho i te maa'ogi, e a'u ki te maagama, ka ke hiina'i gaoi kinai, nia kua hai e ia na hai ia te 'Aitu.” ");
INSERT INTO mnv_vpl VALUES ("JN3_22","073_3_22","JHN","3","22","22","Mugi i na hai 'anga nei, kae boo a Jesus ma ona pegea haka ako ki te kunga henua i Judea o hakapata ai Ia kia te kigatou, ma te haa gogomi pegea. ");
INSERT INTO mnv_vpl VALUES ("JN3_23","073_3_23","JHN","3","23","23","Kae haa gogomi pegea ma'u a John i Aenon e hitaiaki atu ki Salim, iteme'agaa noko 'eha bai i te kungaa, ka ko pegea noko ma boo mai o haa gogomi eia. ");
INSERT INTO mnv_vpl VALUES ("JN3_24","073_3_24","JHN","3","24","24","(Te hai 'anga nei noko hai ka ko John noko manga koi he'e tuku ki te kunga o te kagohia.) ");
INSERT INTO mnv_vpl VALUES ("JN3_25","073_3_25","JHN","3","25","25","Ka noko haka tu'u te he taunga he titingi 'aki i na pegea haka ako o John ma na Jew i na noho o na hai 'anga ke huhu'i ke ma'a. ");
INSERT INTO mnv_vpl VALUES ("JN3_26","073_3_26","JHN","3","26","26","Ko kigatou noko boo kia John o hai atu kinai, “Ako, te pegea noko haka pata kia te koe i tegaa pa'asi i Jordan, te pegea noko 'atigongo ai koe? Manga haa gogomi pegea i te gholoba nei, kua ase kinai ba'i pegea!” ");
INSERT INTO mnv_vpl VALUES ("JN3_27","073_3_27","JHN","3","27","27","Ko John noko konei ana hakatau ki te gongo nei, “Te pegea ka manga ga'u eia nia e haiga'a kia te ia mai te gangi. ");
INSERT INTO mnv_vpl VALUES ("JN3_28","073_3_28","JHN","3","28","28","Ko koutou ma'u manga 'aonga te hogahoga e koutou taku hai atu 'anga: ‘Ko au he'e te 'Agiki Taga'ia, ka ko au noko mataa haka to'o mai ia te Ia.’ ");
INSERT INTO mnv_vpl VALUES ("JN3_29","073_3_29","JHN","3","29","29","Te tangata e hai ke hai uguugu, te pegea o te hahine e hai ke hai matu'a, ka te hemasi'inga a te tangata nei manga pali ma te hakagongo kia te ia, o manga magaohie to'a i te hakagongo 'anga ki te ge'o o te tangata hai uguugu. Te magaohie 'anga na ta'aku, ka kua tatae ki tena 'otinga. ");
INSERT INTO mnv_vpl VALUES ("JN3_30","073_3_30","JHN","3","30","30","Ko Ia e hai ke hua'eha soo atu, ka ko au e hai kau mi'i me'a. ");
INSERT INTO mnv_vpl VALUES ("JN3_31","073_3_31","JHN","3","31","31","“Te pegea e hinaiho mai 'agunga, e ma'u 'agunga i ba'i pegea, ka koai manga i gago nei, te pegea o gago nei, ma te manga gea ma'u pe te pegea o gago nei. Te pegea e hinaiho mai te gangi, e ma'u 'agunga o sigi i ba'i pegea. ");
INSERT INTO mnv_vpl VALUES ("JN3_32","073_3_32","JHN","3","32","32","Ko Ia e 'atigongo i nia noko ina kinai ma te haka gongo kinai, ka e he'e tau pegea ke to'o tena 'atigongo 'anga. ");
INSERT INTO mnv_vpl VALUES ("JN3_33","073_3_33","JHN","3","33","33","Koai kua to'o ana gea 'anga, e haka 'agi ai ko te 'Aitu e maa'ogi. ");
INSERT INTO mnv_vpl VALUES ("JN3_34","073_3_34","JHN","3","34","34","Iteme'agaa te pegea e haka to'o mai e te 'Aitu, e gea i na gea 'anga a te 'Aitu, iteme'agaa e he'e tau potaha te Spirit e haiga'a kinai e te 'Aitu. ");
INSERT INTO mnv_vpl VALUES ("JN3_35","073_3_35","JHN","3","35","35","Te Tamana e ma'ine ki te Hosa, o tuku e Ia ba'i hai 'anga ki ona taganga. ");
INSERT INTO mnv_vpl VALUES ("JN3_36","073_3_36","JHN","3","36","36","Koai e too ki te Hosa, e hai ke ga'u eia te ma'ugi noho goa. Ka koai e he'e too ki te Hosa, koia kago he'e ina ki te ma'ugi, kae haka soo atu te 'ika'ika o te 'Aitu, kago noko noho ia te ia ki ba'i 'aso.” ");
INSERT INTO mnv_vpl VALUES ("JN4_1","073_4_1","JHN","4","1","1","Na Pharisee na haka gongo i te 'api pegea kua too kia Jesus ma te 'api kua haa gogomi e Ia o sigi ia John. ");
INSERT INTO mnv_vpl VALUES ("JN4_2","073_4_2","JHN","4","2","2","Ka he'e ko Jesus te noko haa gogomi pegea, ka ona pegea haka ako. ");
INSERT INTO mnv_vpl VALUES ("JN4_3","073_4_3","JHN","4","3","3","Nimaa haka gongo a Jesus ki na hegeunga nei, ma te hoki i Judea ki Galilee. ");
INSERT INTO mnv_vpl VALUES ("JN4_4","073_4_4","JHN","4","4","4","Ko Ia noko hano i te aga i te uso o te kunga henua i Samaria. ");
INSERT INTO mnv_vpl VALUES ("JN4_5","073_4_5","JHN","4","5","5","Ka na hetae ki te manaha i Samaria tena ingoa ko Sychar. Noko pata i te kunga kege noko haiga'a e Jacob kia tena hosa ia Joseph. ");
INSERT INTO mnv_vpl VALUES ("JN4_6","073_4_6","JHN","4","6","6","Te bai kegi o Jacob noko i te kungaa. Ka ko Jesus noko logho i tegatou boo 'anga, o noho i te pa'asi o te bai i te 'ao 'aatea. ");
INSERT INTO mnv_vpl VALUES ("JN4_7","073_4_7","JHN","4","7","7","Ma te a'u te hahine mai Samaria te 'utunga bai, ma te hai atu kinai a Jesus, “ 'Aumai he bai kau binu.” ");
INSERT INTO mnv_vpl VALUES ("JN4_8","073_4_8","JHN","4","8","8","(Ka ona pegea haka ako na boo ki te manaha te tau'inga utunga.) ");
INSERT INTO mnv_vpl VALUES ("JN4_9","073_4_9","JHN","4","9","9","Ma te hai atu te hahine mai Samaria kia te Ia, “Ko Koe te Jew, ka ko au te hahine mai Samaria, ka 'eaa e haka ene bai ai Koe kia te au?” (Iteme'agaa na pegea o Jew ma na pegea mai Samaria e he'e 'aonga te hepiitaki i he hai 'anga.) ");
INSERT INTO mnv_vpl VALUES ("JN4_10","073_4_10","JHN","4","10","10","Ka noko haka tau a Jesus ki te hahine o hai atu, “Poi na'a e koe te ga'a tausu'u o te 'Aitu, ma te na'a e koe po koai te haka ene kia te koe, ka haka ene a koe kia te Ia, ka kego haiga'a e Ia kia te koe te bai o te ma'ugi.” ");
INSERT INTO mnv_vpl VALUES ("JN4_11","073_4_11","JHN","4","11","11","Ma te hai atu te hahine, “Hakahua, e he'e gahi ake te bai, kae he'e kitea he me'a ke kagu bai ai Koe, kae hai ke kohea na hai e Koe te bai o te ma'ugi? ");
INSERT INTO mnv_vpl VALUES ("JN4_12","073_4_12","JHN","4","12","12","'Ai ko Koe e hu'a'eha o sigi ia te matou tupuna ia Jacob, noko haiga'a eia te bai nei kia te kimatou o binu ai ia ma'u, ma 'ona hosa ma 'ana manu hetoogohi?” ");
INSERT INTO mnv_vpl VALUES ("JN4_13","073_4_13","JHN","4","13","13","Ma te hai atu kinai a Jesus, “Koai e binu i te bai nei, e hai ke go sia binu hoki. ");
INSERT INTO mnv_vpl VALUES ("JN4_14","073_4_14","JHN","4","14","14","Ka koai kago binu eia te bai kago haiga'a kinai e Au, kago he'e 'aonga tena sia binu hoki. E maa'ogi to'a, te bai e hai kau go haiga'a 'ia kia te ia, e hai ke go tupu ake i te uso o'ona ke noko haiga'a kia te ia te ma'ugi noho goa.” ");
INSERT INTO mnv_vpl VALUES ("JN4_15","073_4_15","JHN","4","15","15","Ma te hai atu te hahine, “Hakahua, haiga'a mai kia te au te bai nei ka kau noka te sia binu hoki, ma te ke noka taku hokimai he 'utunga bai ki te bai nei.” ");
INSERT INTO mnv_vpl VALUES ("JN4_16","073_4_16","JHN","4","16","16","Hai atu a Jesus, “Hinatu o kakabe ia tou matu'a o giu mai.” ");
INSERT INTO mnv_vpl VALUES ("JN4_17","073_4_17","JHN","4","17","17","Ma te hai atu te hahine, “Koau e he'e tau matu'a.” Ma te hai atu a Jesus, “E maa'ogi tau gea 'anga na, ko koe he'e tau matu'a, ");
INSERT INTO mnv_vpl VALUES ("JN4_18","073_4_18","JHN","4","18","18","ka tena maa'ogi 'anga, ko koe kua 'oti i te hai tou toka gima matu'a, tegaa manga haka pata 'aki kougua, he'e tou matu'a maa'ogi. Nia e gea kinai koe e maa'ogi.” ");
INSERT INTO mnv_vpl VALUES ("JN4_19","073_4_19","JHN","4","19","19","Ma te hai atu te hahine, “Kua ina 'atu au ko Koe te taauga. ");
INSERT INTO mnv_vpl VALUES ("JN4_20","073_4_20","JHN","4","20","20","Omatou tupuna noko sogi kia te 'Aitu i te ogo nei, ka e hai ake koutou na Jew, manga tenei te kunga hai ke noko sogi ai, ko Jerusalem.” ");
INSERT INTO mnv_vpl VALUES ("JN4_21","073_4_21","JHN","4","21","21","Ma te hai atu a Jesus, “Too mai kia te Au, ta'ahine, te 'aso manga a'u, ko pegea kago he'e sogi ai ki te Tamana i te ogo nei po i Jerusalem. ");
INSERT INTO mnv_vpl VALUES ("JN4_22","073_4_22","JHN","4","22","22","Koutou Samaria manga sogi ki nia e he'e na'a e koutou. Ko kimatou e na'a e kimatou koai te sogi kinai kimatou, iteme'agaa te ma'ugi sanga e a'u i na Jew. ");
INSERT INTO mnv_vpl VALUES ("JN4_23","073_4_23","JHN","4","23","23","Ka e iai te 'aso e a'u ka kua hetae mai, te gholoba na, na pegea sogi maa'ogi kago sogi ki te Tamana i te Spirit ma te maa'ogi, iteme'agaa konaa na haingaa pegea e ligo e te Tamana. ");
INSERT INTO mnv_vpl VALUES ("JN4_24","073_4_24","JHN","4","24","24","Ko te 'Aitu te Spirit, ka na pegea e sogi kia te Ia, e hai ke sogi maa'ogi kinai i te Spirit ma te maa'ogi.” ");
INSERT INTO mnv_vpl VALUES ("JN4_25","073_4_25","JHN","4","25","25","Ma te hai atu te hahine kia te Ia, “E na'a eau te 'Agiki Taga'ia, (e ingoa te Christ), e a'u. Ka nimaa a'u, e hai ke go hogahoga e Ia ko ba'i hai 'anga kia te kimatou.” ");
INSERT INTO mnv_vpl VALUES ("JN4_26","073_4_26","JHN","4","26","26","Ma te haka tau a Jesus o hai atu, “Ko Au tenei te manga haka hegeu kia te koe.” ");
INSERT INTO mnv_vpl VALUES ("JN4_27","073_4_27","JHN","4","27","27","I te gholoba na, na pegea haka ako o Jesus na giu mai, o hu'ai he langalanga 'aki i te noko kite ia te Ia manga haka hegeu ki te hahine. Ka noko he'e haka anu 'aki ma'u kia te Ia, po nia e siahai kinai, po 'eaa e gea haka pata ai ki te hahine. ");
INSERT INTO mnv_vpl VALUES ("JN4_28","073_4_28","JHN","4","28","28","Te hahine na ti'aki tena poati 'utu bai, kae hoki ki te manaha o hai atu ki na pegea o te manaha, ");
INSERT INTO mnv_vpl VALUES ("JN4_29","073_4_29","JHN","4","29","29","“ 'Ai boomai o hiina'i ki te pegea e hogahoga e Ia kia te au ba'i hai 'anga noko hai eau. 'Ai he'e tenei te 'Agiki Taga'ia?” ");
INSERT INTO mnv_vpl VALUES ("JN4_30","073_4_30","JHN","4","30","30","Ma te boo kigatou ki taha i te hu'ai manaha o boomai kia te Ia. ");
INSERT INTO mnv_vpl VALUES ("JN4_31","073_4_31","JHN","4","31","31","I te gholoba na, ona pegea haka ako noko usuusu ia te Ia o hai atu “Ako, kai ake ma'au ni me'a.” ");
INSERT INTO mnv_vpl VALUES ("JN4_32","073_4_32","JHN","4","32","32","Ka noko hai atu Ia kia te kigatou, “E hai 'aku utunga ke kai, e he'e na'a e koutou.” ");
INSERT INTO mnv_vpl VALUES ("JN4_33","073_4_33","JHN","4","33","33","Ma te tu'ia ona pegea haka ako o he haka anuanu 'aki o hai ake, “ 'Ai kua to'o mai kinai ehe pegea ni utunga?” ");
INSERT INTO mnv_vpl VALUES ("JN4_34","073_4_34","JHN","4","34","34","Ka noko hai atu a Jesus kia te kigatou, “Konei 'aku utunga te hai na paaunga a 'Ana noko haka to'o mai ia te Au, ma te ke haka 'oti Ana hekau. ");
INSERT INTO mnv_vpl VALUES ("JN4_35","073_4_35","JHN","4","35","35","Koutou e ta'anga hai ake, ‘E toe te haanga maahina ka ke matu'a na 'umanga’, ka ko Au e hai atu: 'Ai lugaluga ake 'outou mata o hiina'i gaoi atu ki na 'umanga: Na me'a sanga kua 'oti i te matu'a, kua ngaague ke utu. ");
INSERT INTO mnv_vpl VALUES ("JN4_36","073_4_36","JHN","4","36","36","Te pegea e utu eia te 'umanga nei ma to'o i tena giu'akinga, koia ma'u ma haka putu na hua 'umanga ki te ma'ugi noho goa, ke magagaohie ngatahi ai kigaaua ma te pegea e sanga eia. ");
INSERT INTO mnv_vpl VALUES ("JN4_37","073_4_37","JHN","4","37","37","O haka maa'ogi ai te haka mee'inga nei, ‘E sanga e tegaa pegea kae utu e tegaa pegea.’ ");
INSERT INTO mnv_vpl VALUES ("JN4_38","073_4_38","JHN","4","38","38","E haka to'o e Au ia te koutou, ke utu te 'umanga kua matu'a noko he'e 'aabaki hekau ai koutou i tena sanga 'anga. E toe na pegea noko haka higosia i te hai hekau ai, kae ka ga'u e koutou te hakagaoinga o agatou hekau.” ");
INSERT INTO mnv_vpl VALUES ("JN4_39","073_4_39","JHN","4","39","39","Noko hu'ai 'api pegea i te manaha i Samaria noko too kia Jesus, iteme'agaa, noko 'atigongo te hahine, “Ko Ia noko hogahoga e Ia kia te au, nia noko hai eau.” ");
INSERT INTO mnv_vpl VALUES ("JN4_40","073_4_40","JHN","4","40","40","Te 'aso na boomai ai na pegea o Samaria, ko kigatou noko haka ene 'aki kia te Ia ke noko haka pata kia te kigatou. Ma te haka pata kinai a Jesus i te guanga 'ao. ");
INSERT INTO mnv_vpl VALUES ("JN4_41","073_4_41","JHN","4","41","41","Na 'api pegea noko too kia Jesus i ana haka hegeu 'anga. ");
INSERT INTO mnv_vpl VALUES ("JN4_42","073_4_42","JHN","4","42","42","Ma te hai atu kigatou ki te hahine, “Ko kimatou e he'e manga too kinai i nia noko 'atigongo ai koe, ka ko kimatou e too kinai, iteme'agaa ko kimatou kua haka gongo soko ma'u ki ana gea 'anga, o na'a e kimatou e maa'ogi ko Ia te ma'ugi sanga o te kege nei.” ");
INSERT INTO mnv_vpl VALUES ("JN4_43","073_4_43","JHN","4","43","43","Nimaa 'oti tena guanga 'ao i te kungaa, kae hano ki Galilee. ");
INSERT INTO mnv_vpl VALUES ("JN4_44","073_4_44","JHN","4","44","44","(Iteme'agaa, ko Jesus na 'oti i te konei ana gea, “Te taauga e hai ke go he'e pago kinai tona kakai 'anga.”) ");
INSERT INTO mnv_vpl VALUES ("JN4_45","073_4_45","JHN","4","45","45","Te 'aso noko hetae ai Ia ki Galilee, na pegea o Galilee noko oho e kigatou ia te Ia, iteme'agaa ko kigatou noko boo ma'u ki Jerusalem o hiina'i ki ba'i hai 'anga noko hai e Ia i te 'aso o te haka tahinga o te Passover i te kunga na. ");
INSERT INTO mnv_vpl VALUES ("JN4_46","073_4_46","JHN","4","46","46","Ko Jesus noko hoki ki Cana i Galilee, te kunga noko haka haagiu ai e Ia te bai ki te waeni. Ka noko iai te pegea o te gahumanu noko masaki a tona hosa i Capernaum. ");
INSERT INTO mnv_vpl VALUES ("JN4_47","073_4_47","JHN","4","47","47","Te 'aso noko haka gongo ai ia Jesus kua hokimai mai Judea ki Galilee, ma te hano kinai ke haka ene kia te Ia ke hano ki Capernaum o haka ma'ugi tena hosa e hitaiaki ke mate. ");
INSERT INTO mnv_vpl VALUES ("JN4_48","073_4_48","JHN","4","48","48","Ma te hai atu a Jesus, “Ka si'ai he pegea ia te koutou ke too kia te Au, i te poi he'e hiina'i koutou ki ni hu'ai hai 'anga haka gege ma'ugi e hai e Au.” ");
INSERT INTO mnv_vpl VALUES ("JN4_49","073_4_49","JHN","4","49","49","Ma te haka tau te hu'ai pegea nei o hai atu, “Tata'o mai ia te au, na'e kitai mate taku tama 'iti'iti.” ");
INSERT INTO mnv_vpl VALUES ("JN4_50","073_4_50","JHN","4","50","50","Ma te hai atu a Jesus kia te ia, “Hinatu, tou hosa ka ma'ugi!” Ma te too te pegea ki te gea 'anga a Jesus o hoki. ");
INSERT INTO mnv_vpl VALUES ("JN4_51","073_4_51","JHN","4","51","51","Te gholoba noko manga koi hano ai i te aga, ma te bilaabei ma ona guani noko tu'uti mai ai te gongo ko tena hosa kua ma'ugi. ");
INSERT INTO mnv_vpl VALUES ("JN4_52","073_4_52","JHN","4","52","52","Ma te haka anu atu ia kia te kigatou i te gholoba noko sigi ai tona masaki, ma te hai atu kigatou, “Ko anaahi i te ga'aa page te noko sigi ai tena 'augia.” ");
INSERT INTO mnv_vpl VALUES ("JN4_53","073_4_53","JHN","4","53","53","Ma te na'a e te tamana, tona hosa noko sigi tena masaki i te gholoba noko gea ai a Jesus o hai atu, “Tou hosa ka ma'ugi.” Ma te too ngatahi ai kigatou ma tena haanau kia Jesus. ");
INSERT INTO mnv_vpl VALUES ("JN4_54","073_4_54","JHN","4","54","54","Tenei te gua hai 'anga haka gege ma'ugi noko hai e Jesus i tena hokimai 'anga mai Judea ki Galilee. ");
INSERT INTO mnv_vpl VALUES ("JN5_1","073_5_1","JHN","5","1","1","Nimaa mugi i na hai 'anga nei, ko Jesus noko hakaneke ki Jerusalem ki te haka tahinga ana Jew. ");
INSERT INTO mnv_vpl VALUES ("JN5_2","073_5_2","JHN","5","2","2","Ka noko iai te bai i Jerusalem e hitaiaki ki te aga e mate te Aga o na Sipisipi. Te bai nei e mate i te hegeunga a na Hebrew ko Bethesda, ka noko mugheghi ai te toka gima pa'asi hage. ");
INSERT INTO mnv_vpl VALUES ("JN5_3","073_5_3","JHN","5","3","3","Ka noko hu'ai 'api na pegea masasaki noko manga taahoga i na pa'asi hage nei, na pegea kikibi, ma na pegea seu ma na pegea taa haka pikipiki. Ko kigatou noko manga hitagi i te bai ke bulo. ");
INSERT INTO mnv_vpl VALUES ("JN5_4","073_5_4","JHN","5","4","4","Iteme'agaa noko iai na 'aso noko ta'a hinaiho kinai te ensel o te 'Aitu o hai eia te bai o bulo. Koai i na pegea masasaki e mataa 'utu kinai i te gholoba e bulobulo ai, e hai ke ma'ugi i ona masaki. ");
INSERT INTO mnv_vpl VALUES ("JN5_5","073_5_5","JHN","5","5","5","Ka noko iai te tangata, koia noko masaki o katoa haka togu tuma'a e bagu (38) ona ghapu. ");
INSERT INTO mnv_vpl VALUES ("JN5_6","073_5_6","JHN","5","6","6","Noko ina 'atu kinai a Jesus i te manga takoto i te kungaa, o na'a e Ia te pegea nei na goa tena masaki. Ko Ia na hakaanu atu kia te ia, “Ko koe e siahai ke ma'ugi?” ");
INSERT INTO mnv_vpl VALUES ("JN5_7","073_5_7","JHN","5","7","7","Ma te haka tau te masaki o hai atu, “Hakahua, ko au e he'e tau pegea baa siko ke tuku ia te au ki te bai i na 'aso e bulo ai. E ta'anga hai lobo kau mataa 'utu kinai, ka kua mataa 'utu kinai tegaa pegea.” ");
INSERT INTO mnv_vpl VALUES ("JN5_8","073_5_8","JHN","5","8","8","Ma te hai atu kinai a Jesus, “Tu'ake! Sa'u ake tou kaainga o hano.” ");
INSERT INTO mnv_vpl VALUES ("JN5_9","073_5_9","JHN","5","9","9","Te tangata na ghali o soihua. Koia na sa'u ake tona kaainga o hano. Ka te 'ao noko hai ai te hai 'anga nei, te 'Ao Oki oki. ");
INSERT INTO mnv_vpl VALUES ("JN5_10","073_5_10","JHN","5","10","10","Ma te kogaa na hai atu na hu'ai pegea o Jew ki te pegea na ma'ugi i ona masaki, “Te 'Ao Oki oki tenei, kae hai songo e koe atatou tagangonga i te to'o 'anga ai tou kaainga.” ");
INSERT INTO mnv_vpl VALUES ("JN5_11","073_5_11","JHN","5","11","11","Ka na haka tau ia o hai atu, “Te pegea e haka ma'ugi ia te au, te kaunaki ia te au ke to'o toku kaainga kau hano.” ");
INSERT INTO mnv_vpl VALUES ("JN5_12","073_5_12","JHN","5","12","12","Ma te haka anu 'aki atu kinai kigatou, “Koai te pegea e kaunaki ia te koe ke to'o tou kaainga o hano?” ");
INSERT INTO mnv_vpl VALUES ("JN5_13","073_5_13","JHN","5","13","13","Ka te pegea noko ma'ugi i ona masaki noko he'e na'a eia po koai, iteme'agaa ko Jesus na haka higo atu ki te 'apitanga noko i te kunga na. ");
INSERT INTO mnv_vpl VALUES ("JN5_14","073_5_14","JHN","5","14","14","Nimaa mugi a Jesus o kite ia te ia i te Hage Tapu o hai atu kinai, “Hakagongo mai, ko koe kua ma'ugi hoki! Noka tau 'oosongo hoki, na'e ko koe kitai go hetae kinai he hai 'anga songo o sigi i nia kua hai kia te koe.” ");
INSERT INTO mnv_vpl VALUES ("JN5_15","073_5_15","JHN","5","15","15","Ma te hano te tangata nei o 'atigongo ki na hu'ai pegea o Jew, ko Jesus te noko haka ma'ugi ia te ia. ");
INSERT INTO mnv_vpl VALUES ("JN5_16","073_5_16","JHN","5","16","16","Tenei te hai 'anga noko hai maase'i ai e na Jew ia Jesus, iteme'agaa noko hai e Ia na hai 'anga nei i te 'Ao Oki oki. ");
INSERT INTO mnv_vpl VALUES ("JN5_17","073_5_17","JHN","5","17","17","Ma te hai atu a Jesus kia te kigatou, “Ko Tamau manga hai hekau o hetae mai ki te 'ao nei, ko Au ma'u e hai hekau ai.” ");
INSERT INTO mnv_vpl VALUES ("JN5_18","073_5_18","JHN","5","18","18","Tena gea 'anga nei noko hai na hu'ai pegea o Jew o soo atu ai tegatou maanatu ke taa ia Jesus, i te noko he'e manga ngato ki te hai songo 'anga e Ia te tagangonga o te 'Ao Oki oki, kae hai ake ma'u ko te 'Aitu tena Tamana, ma te hai ia te Ia o papata ma te 'Aitu. ");
INSERT INTO mnv_vpl VALUES ("JN5_19","073_5_19","JHN","5","19","19","Ma te konei na haka tau kinai a Jesus, “Ko Au e gea kia te koutou i nia e maa'ogi: Te Hosa e he'e 'aonga te hai hai 'anga launatasi, ka ko Ia manga hai e Ia nia e hai e te Tamana o ina kinai, iteme'agaa nia e hai e te Tamana e hai ma'u e te Hosa. ");
INSERT INTO mnv_vpl VALUES ("JN5_20","073_5_20","JHN","5","20","20","Iteme'agaa te Tamana e ma'ine ki te Hosa o haka 'agi kia te Ia ko ba'i hai 'anga manga hai e Ia. Ka hai ke go haka 'agi ma'u e Ia ni hu'ai hai 'anga o sigi i na hai 'anga nei ke go hai ma'u e Ia. Ka koutou hai ke go he gege ma'ugi 'aki ai. ");
INSERT INTO mnv_vpl VALUES ("JN5_21","073_5_21","JHN","5","21","21","Ko te Tamana e baa 'aga e Ia na pegea mamate o haiga'a kinai te ma'ugi. E konaa na hai ma'u te Hosa e haiga'a e Ia te ma'ugi ki na pegea e siahai Ia ke haiga'a kinai. ");
INSERT INTO mnv_vpl VALUES ("JN5_22","073_5_22","JHN","5","22","22","E kogaa o na haka soatu ma'u, te Tamana e he'e haka aba e Ia he pegea, i te kua 'oti i te haka tukunga e Ia ki te Hosa ke haka aba pegea, ");
INSERT INTO mnv_vpl VALUES ("JN5_23","073_5_23","JHN","5","23","23","ka ke haka e'eha ai e ba'i pegea te Hosa, ke noho pe na haka e'eha 'anga e kigatou ia te Tamana. Koai e he'e haka e'eha eia te Hosa, e he'e haka e'eha eia te Tamana noko haka to'o mai ia te Ia. ");
INSERT INTO mnv_vpl VALUES ("JN5_24","073_5_24","JHN","5","24","24","“Ko Au e gea maa'ogi kia te koutou: Koai e haka gongo ki aku gea 'anga o too ki te Tamana noko haka to'o mai ia te Au, e hai eia te ma'ugi noho goa. Koia kago he'e haisongo 'ia, ia te ia kua 'oti tena sigi i te mate ki te ma'ugi. ");
INSERT INTO mnv_vpl VALUES ("JN5_25","073_5_25","JHN","5","25","25","Ko Au e gea i nia e maa'ogi: Te 'aso noko hai ke a'u kua 'oti i te hetae mai. E hai ke go haka gongo ai na pegea mamate ki te ge'o o te Hosa o te 'Aitu, ka koai kago haka gongo ki te ge'o, kago ma'ugi. ");
INSERT INTO mnv_vpl VALUES ("JN5_26","073_5_26","JHN","5","26","26","Iteme'agaa te Tamana e hai e Ia te ma'ugi ia te Ia, e konaa na tuku ma'u e Ia te ma'ugi ki te Hosa ke hai ma'u e Ia te ma'ugi ia te Ia. ");
INSERT INTO mnv_vpl VALUES ("JN5_27","073_5_27","JHN","5","27","27","Ka kua haiga'a e Ia ki te Hosa te taganga ke haka aba pegea, iteme'agaa ko Ia te Hosa o Pegea. ");
INSERT INTO mnv_vpl VALUES ("JN5_28","073_5_28","JHN","5","28","28","“Noka te he gege ma'ugi 'aki i te hai 'anga nei, iteme'agaa te 'aso kago a'u, ko ba'i pegea mamate manga i na takotonga e hai ke go haka gongo ki tona ge'o, ");
INSERT INTO mnv_vpl VALUES ("JN5_29","073_5_29","JHN","5","29","29","o a'aga mai i ogatou takotonga. Koai ia te kigatou noko hai hai 'anga gaoi, ko kigatou kago a'aga mai o maa'ugi, ka koai noko hai hai 'anga maase'i kago maa'ugi mai ki te kagohia. ");
INSERT INTO mnv_vpl VALUES ("JN5_30","073_5_30","JHN","5","30","30","“Ko Au e he'e 'aonga te hai launatasi e Au ni hai 'anga i aku haka paaunga. Ko Au manga haka aba pegea i nia e gea ai a te 'Aitu kia te Au. Tenei te hai 'anga e tinogaoi ai aku haka aba 'anga, iteme'agaa ko Au he'e manga hai e Au nia e tegeu'a ai Au, ka manga hai e Au nia e siahai kinai Ia noko haka to'o mai ia te Au. ");
INSERT INTO mnv_vpl VALUES ("JN5_31","073_5_31","JHN","5","31","31","“Ko Au poi manga 'atigongo ia te Au, e he'e maa'ogi aku haka hegeu 'anga nei. ");
INSERT INTO mnv_vpl VALUES ("JN5_32","073_5_32","JHN","5","32","32","Kae iai ma'u tegaa pegea manga 'atigongo ia te Au, kae na'a e Au nia e 'atigongo ai ia te Au e maa'ogi. ");
INSERT INTO mnv_vpl VALUES ("JN5_33","073_5_33","JHN","5","33","33","“Koutou noko haka to'o pegea kia John o 'atigongo kinai i te maa'ogi. ");
INSERT INTO mnv_vpl VALUES ("JN5_34","073_5_34","JHN","5","34","34","He'e hai ke hai mo'oku ni pegea ke he 'atigongo 'aki ia te Au, ka ko Au manga gea i na hai 'anga nei ke 'aonga te ga'u ai e koutou te ma'ugi. ");
INSERT INTO mnv_vpl VALUES ("JN5_35","073_5_35","JHN","5","35","35","Ko John te peba noko tutu o kaa o maagama, ka na haka pupugu e koutou te gholoba ke sisia ai i tena maagama. ");
INSERT INTO mnv_vpl VALUES ("JN5_36","073_5_36","JHN","5","36","36","“Ka ko Au e hua'eha aku haka maahoga 'anga ia te Au, o sigi i na 'atigongo 'anga a John, iteme'agaa na hekau noko tuku e Tamau kia te Au kau hai 'ia, manga hai e Au o haka maahoga ai ko te Tamana te noko haka to'o mai ia te Au. ");
INSERT INTO mnv_vpl VALUES ("JN5_37","073_5_37","JHN","5","37","37","Ka te Tamana noko haka to'o mai ia te Au, ko Ia noko 'atigongo ma'u ia te Au, ka koutou e he'e haka gongo ki te ge'o o'ona ma te he'e hiina'i ki ona noho, ");
INSERT INTO mnv_vpl VALUES ("JN5_38","073_5_38","JHN","5","38","38","ma te he'e pipiki e koutou ana gea 'anga i outou uso, iteme'agaa koutou e he'e too kia te Ia noko haka to'o mai e Ia. ");
INSERT INTO mnv_vpl VALUES ("JN5_39","073_5_39","JHN","5","39","39","Koutou manga haka ako gaoi i na Kanukanu Tapu iteme'agaa e tegeu'a ake koutou hai ke ga'u ai e koutou te ma'ugi noho goa, ka na Kanukanu Tapu nei manga 'atigongo ia te Au. ");
INSERT INTO mnv_vpl VALUES ("JN5_40","073_5_40","JHN","5","40","40","Ka koutou e he'e mamaka ke boomai kia te Au ka koutou ga'u 'ia ai te ma'ugi. ");
INSERT INTO mnv_vpl VALUES ("JN5_41","073_5_41","JHN","5","41","41","“Ko Au e he'e siahai ki na haka e'eha 'anga e pegea, ");
INSERT INTO mnv_vpl VALUES ("JN5_42","073_5_42","JHN","5","42","42","kae na'a e Au ia te koutou. E he'e hai e koutou te ma'ine o te 'Aitu i outou uso. ");
INSERT INTO mnv_vpl VALUES ("JN5_43","073_5_43","JHN","5","43","43","Ko Au noko a'u i te ingoa o Tamau, kae he'e too koutou kia te Au. Ka nimaa go a'u he pegea i te ingoa o'ona launatasi, ka too kinai koutou. ");
INSERT INTO mnv_vpl VALUES ("JN5_44","073_5_44","JHN","5","44","44","E hai koutou kohea na too kia te Au, i te poi siahahai koutou ki na haka e'eha 'anga ia te koutou soko, kae he'e hai lobo e koutou ke ga'u te haka e'eha e a'u mai te 'Aitu e tasi. ");
INSERT INTO mnv_vpl VALUES ("JN5_45","073_5_45","JHN","5","45","45","“Kae noka tautou tegeu'a ake e hai kau go gea haka makau ia te koutou i 'ago ia Tamau. Koutou manga sano kia Moses, ka tenaa te pegea kago gea haka makau ia te koutou. ");
INSERT INTO mnv_vpl VALUES ("JN5_46","073_5_46","JHN","5","46","46","Koutou poi too kia Moses, koutou kua too ma'u kia te Au, iteme'agaa nia noko kanukanu eia noko manga haka hegeu ia te Au. ");
INSERT INTO mnv_vpl VALUES ("JN5_47","073_5_47","JHN","5","47","47","Ka ia te koutou kua he'e too ki nia noko kanukanu eia, 'ai e hai koutou kohea na too ki nia e gea ai Au?” ");
INSERT INTO mnv_vpl VALUES ("JN6_1","073_6_1","JHN","6","1","1","Mugi na 'aso i na hai 'anga nei, kae hano a Jesus ki tegaa pa'asi i te Gano i Galilee, (e mate te Gano o Tiberias). ");
INSERT INTO mnv_vpl VALUES ("JN6_2","073_6_2","JHN","6","2","2","Ka noko tata'o ai te hu'ai tu'uganga, i te na hiina'i kigatou ki na hai 'anga haka gege ma'ugi noko hai e Ia ki na pegea masasaki. ");
INSERT INTO mnv_vpl VALUES ("JN6_3","073_6_3","JHN","6","3","3","Ka noko haka neke a Jesus ki te ogo o noho 'aki ai kigatou ma ona pegea haka ako. ");
INSERT INTO mnv_vpl VALUES ("JN6_4","073_6_4","JHN","6","4","4","Ka noko hitaiaki te 'aso o te Haka tahinga o te Passover a na Jew. ");
INSERT INTO mnv_vpl VALUES ("JN6_5","073_6_5","JHN","6","5","5","Nimaa keu ake a Jesus o kite atu e Ia te hu'ai tu'uganga e boomai kia te Ia, ma te haka anu kia Philip o hai atu, “Kitatou ka tau'i utunga i hea ke haangai ai te hu'ai tu'uganga nei?” ");
INSERT INTO mnv_vpl VALUES ("JN6_6","073_6_6","JHN","6","6","6","Ko Jesus noko manga konei na haka anu kia Philip ke hai lobo ia te Ia. Ka na 'oti i te na'a e Ia nia e hai ke hai. ");
INSERT INTO mnv_vpl VALUES ("JN6_7","073_6_7","JHN","6","7","7","Ka noko haka tau a Philip kia te Ia o hai atu, “He'e po te gua gau mane siliva koi he'e 'aonga ma'u te tau'i ai ni bred ke taki hai mi'i momo ai te 'apitanga nei ke kai!” ");
INSERT INTO mnv_vpl VALUES ("JN6_8","073_6_8","JHN","6","8","8","Ka tegaa i ona pegea haka ako e ingoa ko Andrew, te taina o Simon Peter, noko hai atu, ");
INSERT INTO mnv_vpl VALUES ("JN6_9","073_6_9","JHN","6","9","9","“E iai te mi'i tangata i te kunga nei e hai tena toka gima mi'i bred, ma te toka gua mi'i kaui. Ka hai ke kohea na 'aonga ki te hu'ai tu'uganga nei?” ");
INSERT INTO mnv_vpl VALUES ("JN6_10","073_6_10","JHN","6","10","10","Ka noko hai atu kinai a Jesus, “Hai atu ki te 'apitanga ke noho 'aki.” Te kungaa noko tango e te mutie ma te noho 'aki ai te 'apitanga. Ko kigatou noko gimanga noa taangata. ");
INSERT INTO mnv_vpl VALUES ("JN6_11","073_6_11","JHN","6","11","11","Ma te sa'u ake e Jesus na bred, o haka 'aue ai kia te 'Aitu, kae tuha atu ki te 'apitanga noko noho 'aki i te kungaa. Noko konei na hai ma'u e Ia gua kaui. Na ga'u ngatahi ai ko ba'i pegea o 'aonga ki nia noko siahai kinai kigatou. ");
INSERT INTO mnv_vpl VALUES ("JN6_12","073_6_12","JHN","6","12","12","Te gholoba na maakokona ai ko ba'i pegea, kae hai atu a Jesus ki ona pegea haka ako, “Haka putu atu na momo utunga e noho, noka te ti'aki ni me'a.” ");
INSERT INTO mnv_vpl VALUES ("JN6_13","073_6_13","JHN","6","13","13","Ma te haka putu e kigatou na momo utunga noko noho i te toka gima mi'i bred noko kai e kigatou, o tape ai te tini tuma'a e gua kete. ");
INSERT INTO mnv_vpl VALUES ("JN6_14","073_6_14","JHN","6","14","14","Mugi i te hiina'i 'anga te 'apitanga ki te hai 'anga haka gege ma'ugi noko hai e Jesus nei, ma te hai ake a kigatou, “E maa'ogi to'a, tenei te Taauga noko hai ke a'u ki gago nei!” ");
INSERT INTO mnv_vpl VALUES ("JN6_15","073_6_15","JHN","6","15","15","Noko na'a e Jesus na pegea nei noko hai agatou paaunga ke hai e kigatou ia te Ia ke king, ka ko Ia na haka 'aatea ia te kigatou o hoki launatasi ki te ogo. ");
INSERT INTO mnv_vpl VALUES ("JN6_16","073_6_16","JHN","6","16","16","Nimaa magu mai te ahiahi, kae iho na pegea haka ako o Jesus ki te gano. ");
INSERT INTO mnv_vpl VALUES ("JN6_17","073_6_17","JHN","6","17","17","O sosopo ki te haka taupapa o 'ui o giu ki Capernaum i tegaa pa'asi i te gano. Te gholoba na pongia ai, ka ko Jesus noko manga koi he'e a'u kia te kigatou. ");
INSERT INTO mnv_vpl VALUES ("JN6_18","073_6_18","JHN","6","18","18","Ma te hetae te hu'ai huukenga kia te kigatou o 'atua to'a ma'u ai te gano. ");
INSERT INTO mnv_vpl VALUES ("JN6_19","073_6_19","JHN","6","19","19","Te gholoba noko a'ago ai tegatou baka o mi'i mama'o (noko togu poe togu ma te toe mael), kae hiina'i kigatou kia Jesus noko manga a'u i te huka o te tai o hitaiaki mai ki te baka, ma te matataku toto'a kigatou. ");
INSERT INTO mnv_vpl VALUES ("JN6_20","073_6_20","JHN","6","20","20","Ma te hai ake a Jesus kia te kigatou, “Noka tautou matataku, na'e ko Au!” ");
INSERT INTO mnv_vpl VALUES ("JN6_21","073_6_21","JHN","6","21","21","Ma te haa sopo e kigatou ia Jesus ki te baka, kae ghali o hetae kigatou ki te kunga noko boo kinai. ");
INSERT INTO mnv_vpl VALUES ("JN6_22","073_6_22","JHN","6","22","22","Nimaa i tegaa tasi 'ao, te 'apitanga noko manga koi noho 'aki i tegaa pa'asi o te gano. Noko na'a e kigatou e tasi baka noko manga i te kungaa. Noko na'a ma'u e kigatou ko Jesus noko he'e tata'o i ona pegea haka ako, ka ko kigatou noko manga boo soko. ");
INSERT INTO mnv_vpl VALUES ("JN6_23","073_6_23","JHN","6","23","23","Ka noko sahe mai na baka mai Tiberias, o tau haka hitaiaki ki te kunga noko kai ai te 'apitanga i na bred noko haka 'aue ai te Hakahua. ");
INSERT INTO mnv_vpl VALUES ("JN6_24","073_6_24","JHN","6","24","24","Te gholoba na hiina'i iho ai te 'apitanga ko Jesus ma ona pegea haka ako e he'e kitea i te kungaa, ko kigatou manga sosopo ki na baka o boo ki Capernaum ke sasaga ia Jesus. ");
INSERT INTO mnv_vpl VALUES ("JN6_25","073_6_25","JHN","6","25","25","Te 'aso na hiina'i ai kigatou kia Jesus i tegaa pa'asi i te gano, ko kigatou noko haka anu 'aki kinai o hai atu, “Ako, tehea te 'aso noko hetae mai ai Koe ki tenei?” ");
INSERT INTO mnv_vpl VALUES ("JN6_26","073_6_26","JHN","6","26","26","Ma te haka tau a Jesus o hai atu, “Ko Au e gea maa'ogi kia te koutou: Koutou e he'e sasaga ia te Au i te hiina'i 'anga koutou ki na hekau haka gege ma'ugi noko hai e Au, ka koutou manga sasaga ia te Au i te kai 'anga i na utunga o makokona. ");
INSERT INTO mnv_vpl VALUES ("JN6_27","073_6_27","JHN","6","27","27","Noka tautou hai hekau ki na utunga e na'a te masogo, ka manga hai hekau atu ki na utunga o te ma'ugi noho goa. Te ma'ugi kago haiga'a e te Hosa o Pegea kia te koutou, iteme'agaa ko te 'Aitu te Tamana, na tuku kinai e Ia tona haka 'igonga o haka maa'ogi ai ia te Ia.” ");
INSERT INTO mnv_vpl VALUES ("JN6_28","073_6_28","JHN","6","28","28","Ko kigatou noko haka anu kia Jesus o hai atu, “Niaa hai kimatou hai 'ia ka ke hai ai e kimatou na hekau a te 'Aitu?” ");
INSERT INTO mnv_vpl VALUES ("JN6_29","073_6_29","JHN","6","29","29","Ma te haka tau a Jesus o hai atu, “Tenei te hekau a te 'Aitu: Koutou e hai ke too kia te Ia noko haka to'o mai e te 'Aitu.” ");
INSERT INTO mnv_vpl VALUES ("JN6_30","073_6_30","JHN","6","30","30","Ma te haka tau a kigatou kia te Ia o hai atu, “Tehea te hai 'anga haka gege ma'ugi ka hai e Koe kimatou hiina'i kinai o too ai kia te Koe? Niaa gaa ka hai e Koe? ");
INSERT INTO mnv_vpl VALUES ("JN6_31","073_6_31","JHN","6","31","31","'Otatou tupuna noko kai e kigatou na utunga noko mate na ‘mana’ i te tugatea. Kogaa o na noho te noko hai ake ai na Kanukanu Tapu: ‘Noko haiga'a e Ia agatou utunga mai te gangi o kai.’ ” ");
INSERT INTO mnv_vpl VALUES ("JN6_32","073_6_32","JHN","6","32","32","Hai atu ma'u a Jesus, “Ko Au e gea maa'ogi kia te koutou: He'e ko Moses te noko haiga'a e ia kia te koutou te utunga mai te gangi, ka ko Tamau te noko haiga'a e Ia kia te koutou te utunga maa'ogi mai te gangi, ");
INSERT INTO mnv_vpl VALUES ("JN6_33","073_6_33","JHN","6","33","33","iteme'agaa te utunga a te 'Aitu te kua hinaiho mai te gangi o haiga'a e Ia te ma'ugi ki gago nei.” ");
INSERT INTO mnv_vpl VALUES ("JN6_34","073_6_34","JHN","6","34","34","Ma te hai atu kigatou kia te Ia, “Hakahua, noko haiga'a haka hanohano mai te utunga nei kia te kimatou.” ");
INSERT INTO mnv_vpl VALUES ("JN6_35","073_6_35","JHN","6","35","35","Ma te hai atu a Jesus kia te kigatou, “Tenei Au te utunga o te ma'ugi. Koai e a'u kia te Au, koia kago he'e 'aonga te ongea. Koai ma'u e too kia te Au, koia kago he'e sia binu. ");
INSERT INTO mnv_vpl VALUES ("JN6_36","073_6_36","JHN","6","36","36","Ka ko Au e hai atu kia te koutou, koutou kua hiina'i kia te Au, ka manga koi he'e too kia te Au. ");
INSERT INTO mnv_vpl VALUES ("JN6_37","073_6_37","JHN","6","37","37","Ko ba'i pegea e haiga'a e te Tamana kia te Au, kago boomai kia te Au, ka ko ba'i pegea kago boomai kia te Au, kago he'e 'aonga te pagepage e Au. ");
INSERT INTO mnv_vpl VALUES ("JN6_38","073_6_38","JHN","6","38","38","Iteme'agaa ko Au noko he'e hinaiho mai te gangi ke hai ma'aku ni paaunga, ka Ko Au noko hinaiho ke hai na paaunga a 'Ana noko haka to'o mai ia te Au. ");
INSERT INTO mnv_vpl VALUES ("JN6_39","073_6_39","JHN","6","39","39","Tenei te haka paaunga a 'Ana noko haka to'o mai ia te Au, kau go noka te ti'aki 'ia he launatasi i na pegea na 'oti i te haiga'a e Ia kia te Au, ka ke go baa 'aga ia te kigatou ke maa'ugi i te 'ao taha'aki. ");
INSERT INTO mnv_vpl VALUES ("JN6_40","073_6_40","JHN","6","40","40","Ka tenei te siahai a Tamau ki ba'i pegea e hiina'i ki te Hosa o too kia te Ia: Kago hai e kigatou te ma'ugi noho goa. E hai kau go baa 'aga ia te kigatou ke maa'ugi i te 'ao taha'aki.” ");
INSERT INTO mnv_vpl VALUES ("JN6_41","073_6_41","JHN","6","41","41","Ka na Jew noko haka tu'u tegatou he nguunguu 'aki ia te Ia, i te hai ake 'anga ko Ia te utunga noko hinaiho mai te gangi. ");
INSERT INTO mnv_vpl VALUES ("JN6_42","073_6_42","JHN","6","42","42","Noko konei agatou to'o ma'u, “ 'Ai he'e tenei a Jesus te hosa o Joseph? E na'a e kitatou ia te tamana ma te tinana, ka 'eaa e hai ake ai ko Ia noko hinaiho mai te gangi?” ");
INSERT INTO mnv_vpl VALUES ("JN6_43","073_6_43","JHN","6","43","43","Ma te haka tau a Jesus o hai atu kia te kigatou, “ 'Oti iho tautou he nguunguu 'aki! ");
INSERT INTO mnv_vpl VALUES ("JN6_44","073_6_44","JHN","6","44","44","Ka he'e kitea he pegea 'aonga te a'u kia te Au, naakupu ki te tuku e te Tamana noko haka to'o mai ia te Au te tuku e Ia. Kae hai kau go baa 'aga 'ia ia te ia i te 'ao taha'aki. ");
INSERT INTO mnv_vpl VALUES ("JN6_45","073_6_45","JHN","6","45","45","Noko kanukanu mai i na taauga, ‘Ko kigatou ngatahi e hai ke go ako e te 'Aitu.’ Ko ba'i pegea e haka gongo ki te Tamana o haka ako ai, kago boomai kia te Au. ");
INSERT INTO mnv_vpl VALUES ("JN6_46","073_6_46","JHN","6","46","46","E si'ai he pegea ina kia te Tamana, ka manga ko Ia e a'u mai ia te 'Aitu te ina kia te Tamana. ");
INSERT INTO mnv_vpl VALUES ("JN6_47","073_6_47","JHN","6","47","47","Ko Au e gea maa'ogi kia te koutou: Koai e too kinai kago ga'u eia te ma'ugi noho goa. ");
INSERT INTO mnv_vpl VALUES ("JN6_48","073_6_48","JHN","6","48","48","“Ko Au te utunga o te ma'ugi. ");
INSERT INTO mnv_vpl VALUES ("JN6_49","073_6_49","JHN","6","49","49","'Outou tupuna noko kai e kigatou i te tugatea na utunga mai te gangi, te ‘mana’, ka ko kigatou na mamate. ");
INSERT INTO mnv_vpl VALUES ("JN6_50","073_6_50","JHN","6","50","50","Ka tenei te utunga e hinaiho mai te gangi. Te utunga nei nimaa go kai e he pegea, koia kago he'e mate. ");
INSERT INTO mnv_vpl VALUES ("JN6_51","073_6_51","JHN","6","51","51","Ko Au te utunga o te ma'ugi noko hinaiho mai te gangi. Te pegea nimaa kai i te utunga nei, e hai ke ma'ugi goa. Te utunga nei toku tino, e haiga'a e Au, ke maa'ugi ai na pegea i gago nei.” ");
INSERT INTO mnv_vpl VALUES ("JN6_52","073_6_52","JHN","6","52","52","Ka na Jew na haka bagebage 'aki soko o hai ake, “E hai ke kohea na haiga'a e te tangata nei te tino kitatou kai 'ia?” ");
INSERT INTO mnv_vpl VALUES ("JN6_53","073_6_53","JHN","6","53","53","Ka noko haka tau a Jesus o hai atu kia te kigatou, “Ko Au e gea maa'ogi kia te koutou: Koutou nimaa he'e kai i te tino o te Hosa o Pegea ma te he'e bibinu i te toto o 'Ona, koutou e he'e tau ma'ugi ia te koutou. ");
INSERT INTO mnv_vpl VALUES ("JN6_54","073_6_54","JHN","6","54","54","Ka koai e kai i toku tino ma te binu i toku toto e ga'u eia te ma'ugi noho goa. Kae e hai kau go haka ma'ugi 'ia i te 'ao taha'aki. ");
INSERT INTO mnv_vpl VALUES ("JN6_55","073_6_55","JHN","6","55","55","Iteme'agaa toku tino te utunga maa'ogi, toku toto te bai binu maa'ogi. ");
INSERT INTO mnv_vpl VALUES ("JN6_56","073_6_56","JHN","6","56","56","Koai e kai i toku tino ma te binu i toku toto, koia e noho haka pata kia te Au, kae noho haka pata Au kia te ia. ");
INSERT INTO mnv_vpl VALUES ("JN6_57","073_6_57","JHN","6","57","57","Ko Tamau noko haka to'o mai ia te Au te hai e Ia te ma'ugi, ka ko Au e hai e Au te ma'ugi i te ghaghi ia te Ia. Kae konei na noho ma'u, koai e kai i toku tino kago hai eia te ma'ugi i te ghaghi ia te Au. ");
INSERT INTO mnv_vpl VALUES ("JN6_58","073_6_58","JHN","6","58","58","Tenei te utunga noko hinaiho mai te gangi, he'e noho pe na utunga noko kai ai outou tupuna o mamate, ka koai e kai i te utunga nei e hai ke go ma'ugi goa.” ");
INSERT INTO mnv_vpl VALUES ("JN6_59","073_6_59","JHN","6","59","59","Ko Jesus noko gea i na hai 'anga nei i tena ako 'anga, i te Hage hai paaunga i Capernaum. ");
INSERT INTO mnv_vpl VALUES ("JN6_60","073_6_60","JHN","6","60","60","Noko 'api ona pegea haka ako noko haka gongo ki ana akonga ma te hai ake, “Na akonga nei e hu'ai haingata'a, 'ai koai e 'aonga te haka gongo kinai?” ");
INSERT INTO mnv_vpl VALUES ("JN6_61","073_6_61","JHN","6","61","61","Noko na'a e Jesus nia noko manga he nguunguu 'aki ai ona pegea haka ako, ma te hai atu kinai, “ 'Ai na hai 'anga nei e hai songo ia te koutou? ");
INSERT INTO mnv_vpl VALUES ("JN6_62","073_6_62","JHN","6","62","62","Koutou kago aa ma kaa hiina'i ki te Hosa o Pegea e haka neke hoki ki te kunga noko mataa noho ai? ");
INSERT INTO mnv_vpl VALUES ("JN6_63","073_6_63","JHN","6","63","63","Te Spirit Tapu te haiga'a te ma'ugi, ka te tino he'e tau hai 'anga. Ka na kupu noko gea ai Au kia te koutou, na kupu a te Spirit e hai ai te ma'ugi. ");
INSERT INTO mnv_vpl VALUES ("JN6_64","073_6_64","JHN","6","64","64","Kae iai na pegea ia te koutou koi he'e too kinai.” Na goa te na'a e Jesus i te haka tu'u sanga, koai te he'e too kinai ma te pegea e hai ke go haka soko ia te Ia. ");
INSERT INTO mnv_vpl VALUES ("JN6_65","073_6_65","JHN","6","65","65","Ma te hai atu ma'u, “Tenei te hai 'anga na hai atu ai Au: E he'e 'aonga he pegea te manga muna o a'u kia te Au ka naakupu ki te tuku e te Tamana ia te ia ke a'u.” ");
INSERT INTO mnv_vpl VALUES ("JN6_66","073_6_66","JHN","6","66","66","Haka tu'u i te 'aso na, noko 'eha pegea i ona pegea haka ako na he keu 'aki giu o he'e he tata'o 'aki ia te Ia. ");
INSERT INTO mnv_vpl VALUES ("JN6_67","073_6_67","JHN","6","67","67","Ma te hai atu a Jesus ki tena katoa tuma'a e gua pegea haka ako, “ 'Ai koutou e he'e siahahai koutou boo ma'u?” ");
INSERT INTO mnv_vpl VALUES ("JN6_68","073_6_68","JHN","6","68","68","Ma te haka tau a Simon Peter o hai atu kia Jesus, “Hakahua, koai te hai kimatou boo kinai? Ka tenaa Koe e hai na haka hegeunga e haiga'a te ma'ugi noho goa. ");
INSERT INTO mnv_vpl VALUES ("JN6_69","073_6_69","JHN","6","69","69","Ko kimatou kua 'oti i te too kinai ma te na'a e kimatou tenaa Koe te tangata e a'u mai a te 'Aitu.” ");
INSERT INTO mnv_vpl VALUES ("JN6_70","073_6_70","JHN","6","70","70","Ma te haka tau a Jesus o hai atu, “Te katoa tuma'a e gua o 'outou noko hakapupugu e Au, ka e iai te launatasi ia te koutou te 'atua!” ");
INSERT INTO mnv_vpl VALUES ("JN6_71","073_6_71","JHN","6","71","71","(Ko Ia noko manga gea kia Judas, te hosa o Simon Iscariot, iteme'agaa masi'igoa koia te launatasi i ona pegea haka ako, kae hai ke go haka soko ia te Ia.) ");
INSERT INTO mnv_vpl VALUES ("JN7_1","073_7_1","JHN","7","1","1","Nimaa sigi i te hai 'anga nei, ko Jesus noko manga sehu i Galilee, ke noho mama'o i Judea iteme'agaa na Jew i te kungaa noko manga sasaga ia te Ia kigatou taa 'ia. ");
INSERT INTO mnv_vpl VALUES ("JN7_2","073_7_2","JHN","7","2","2","Ka te 'aso na hitaiaki ai te Haka tahinga a na Jew ki na Tabanakal, ");
INSERT INTO mnv_vpl VALUES ("JN7_3","073_7_3","JHN","7","3","3","te 'api taangata o Jesus noko hai atu kia te Ia, “Hinatu i te manaha nei ki Judea, ka ke go hiina'i ai ou pegea haka ako ki ni taganga hai e Koe. ");
INSERT INTO mnv_vpl VALUES ("JN7_4","073_7_4","JHN","7","4","4","E si'ai he pegea siahai ke hai hekau haka 'agi'agi ke hai hekau huu, ka ko Koe manga hai e Koe na taganga nei, haka 'agi atu ia te Koe ki ba'i pegea i gago nei.” ");
INSERT INTO mnv_vpl VALUES ("JN7_5","073_7_5","JHN","7","5","5","He'e po ko tena 'api taangata noko he'e too ma'u kia te Ia. ");
INSERT INTO mnv_vpl VALUES ("JN7_6","073_7_6","JHN","7","6","6","Ma te hai atu a Jesus kia te kigatou, “Te 'aso kau hano ai koi he'e a'u. Ka ko ba'i 'aso manga 'aonga kia te koutou. ");
INSERT INTO mnv_vpl VALUES ("JN7_7","073_7_7","JHN","7","7","7","Na pegea o gago nei, e he'e gotoa'a kia te koutou, kae gotoa'a kia te Au, iteme'agaa e haka 'agi e Au agatou hekau e maase'i. ");
INSERT INTO mnv_vpl VALUES ("JN7_8","073_7_8","JHN","7","8","8","Koutou boo atu ki te haka tahinga. 'Ai ko Au ka he'e hano kinai, iteme'agaa te 'aso taugaoi kia te Au ma koi he'e hetae mai.” ");
INSERT INTO mnv_vpl VALUES ("JN7_9","073_7_9","JHN","7","9","9","Ko Jesus na konei ana gea, ka manga noho i Galilee. ");
INSERT INTO mnv_vpl VALUES ("JN7_10","073_7_10","JHN","7","10","10","Nimaa boo tena 'api taangata ki te Haka tahinga, ma te hano ma'u a Jesus. Ka noko he'e hano haka 'agi'agi, ka manga hano huu. ");
INSERT INTO mnv_vpl VALUES ("JN7_11","073_7_11","JHN","7","11","11","Na hu'ai pegea o Jew noko ma sasaga e kigatou ia te Ia i te Haka tahinga o manga haka anuanu 'aki, “Tehea te pegea nei?” ");
INSERT INTO mnv_vpl VALUES ("JN7_12","073_7_12","JHN","7","12","12","Ka te 'apitanga noko manga hegeu huu ia Jesus, o hai ake kogaa, “Ko Ia te tangata gaoi.” Kae hai ake kogaa, “Si'ai, ko Ia e goi ki te 'apitanga.” ");
INSERT INTO mnv_vpl VALUES ("JN7_13","073_7_13","JHN","7","13","13","Ka noko si'ai he pegea gea haka 'agi'agi i he hai 'anga ia Jesus, iteme'agaa ko kigatou noko matataku ki na Jew. ");
INSERT INTO mnv_vpl VALUES ("JN7_14","073_7_14","JHN","7","14","14","Nimaa ngatahinga te Haka tahinga, ko Jesus na hano ki te Hage Tapu o haka tu'u ako te 'apitanga. ");
INSERT INTO mnv_vpl VALUES ("JN7_15","073_7_15","JHN","7","15","15","Na Jew noko he gege ma'ugi 'aki o hai ake, “E kohea na ga'u e te tangata nei na naa 'anga nei, ka ko Ia te noko he'e haka ako ai?” ");
INSERT INTO mnv_vpl VALUES ("JN7_16","073_7_16","JHN","7","16","16","Ma te haka tau atu a Jesus, “Aku akonga nei, e he'e aku hai 'anga, kae a'u mai ia te Ia noko haka to'o mai ia te Au. ");
INSERT INTO mnv_vpl VALUES ("JN7_17","073_7_17","JHN","7","17","17","Koai e maangao ke hai eia na hai 'anga e siahai kinai a te 'Aitu, kago na'a eia po aku akonga nei e a'u mai a te 'Aitu, po ko Au manga gea i aku paaunga. ");
INSERT INTO mnv_vpl VALUES ("JN7_18","073_7_18","JHN","7","18","18","Te pegea nimaa manga gea ia te ia, e hai ke manga haka 'eha'eha ia te ia launatasi. Ka te pegea nimaa hai hekau ke haka 'eha'eha ia te Ia noko haka to'o mai ia te Ia, ko Ia te tangata maa'ogi, e he'e tau hai 'anga ke goi ai. ");
INSERT INTO mnv_vpl VALUES ("JN7_19","073_7_19","JHN","7","19","19","'Ai ko Moses noko he'e haiga'a eia na tagangonga kia te koutou? Kae si'ai he launatasi ia te koutou ke maangao ki na tagangonga. Ka 'eaa e hai lobo ai e koutou ke taa ia te Au?” ");
INSERT INTO mnv_vpl VALUES ("JN7_20","073_7_20","JHN","7","20","20","Ma te hai atu te 'apitanga, “Ko Koe te pegea uguhia! Koai e hai lobo ke taa ia te Koe?” ");
INSERT INTO mnv_vpl VALUES ("JN7_21","073_7_21","JHN","7","21","21","Ma te haka tau atu a Jesus, “Noko hai e Au te launatasi taganga, ma te he gege ma'ugi 'aki ai koutou. ");
INSERT INTO mnv_vpl VALUES ("JN7_22","073_7_22","JHN","7","22","22","Ka koutou noko kaunaki e Moses ke kuga outou hosa, e he'e ko Moses, ka noko haka tu'u mai i otatou tupuna. Ka koutou ma'u manga kuga na tama giki i te 'Ao Oki oki. ");
INSERT INTO mnv_vpl VALUES ("JN7_23","073_7_23","JHN","7","23","23","Ka nimaa kuga he tama 'iti'iti i te 'Ao Oki oki, ka ke noka te hai songo ai te tagangonga a Moses, 'eaa a koutou e he 'ika'ika 'aki ai kia te Au, i te haka ma'ugi 'anga e Au te pegea o soihua i te 'Ao Oki oki? ");
INSERT INTO mnv_vpl VALUES ("JN7_24","073_7_24","JHN","7","24","24","Noka te haka aba na hai 'anga i na noho mai 'anga, kae haka aba atu na hai 'anga i ona maa'ogi 'anga.” ");
INSERT INTO mnv_vpl VALUES ("JN7_25","073_7_25","JHN","7","25","25","Noko iai na pegea i Jerusalem noko hai ake, “ 'Ai he'e tenei te tangata e hai lobo kigatou taa 'ia? ");
INSERT INTO mnv_vpl VALUES ("JN7_26","073_7_26","JHN","7","26","26","Tenei Ia te manga gea haka 'agi'agi nei, ka ko kigatou e he'e gegea kia te Ia. 'Ai na hakahua kua na'a gaoi e kigatou ko Ia te 'Agiki Taga'ia? ");
INSERT INTO mnv_vpl VALUES ("JN7_27","073_7_27","JHN","7","27","27","Kae na'a e kitatou te kunga e a'u ai te tangata nei. Ka te 'Agiki Taga'ia nimaa go a'u, kago si'ai he pegea na'a te kunga e a'u ai.” ");
INSERT INTO mnv_vpl VALUES ("JN7_28","073_7_28","JHN","7","28","28","Ka ko Jesus noko manga koi ako i te Hage Tapu. Ko Ia noko ngege, o hai atu, “E na'a e koutou ia te Au, ma te na'a e koutou po ko Au e a'u mai hea. Ko Au e he'e a'u i ma'aku ni hai 'anga, ka ko Ia noko haka to'o mai ia te Au e maa'ogi, kae he'e na'a e koutou ia te Ia. ");
INSERT INTO mnv_vpl VALUES ("JN7_29","073_7_29","JHN","7","29","29","Kae na'a e Au ia te Ia, iteme'agaa ko Au noko a'u ia te Ia noko haka to'o mai ia te Au.” ");
INSERT INTO mnv_vpl VALUES ("JN7_30","073_7_30","JHN","7","30","30","Ma te hai lobo kigatou he 'osohi kia Jesus, ka na si'ai he pegea 'oso kia te Ia, iteme'agaa noko ma koi he'e tatae te 'aso o'ona. ");
INSERT INTO mnv_vpl VALUES ("JN7_31","073_7_31","JHN","7","31","31","Ka noko 'eha pegea na too kia te Ia. Ko kigatou noko hai ake, “ 'Ai nimaa go a'u te 'Agiki Taga'ia, kago hai e Ia ni taganga o sigi i na hai 'anga e hai e te tangata nei?” ");
INSERT INTO mnv_vpl VALUES ("JN7_32","073_7_32","JHN","7","32","32","Na Pharisee na haka gongo ki te 'apitanga noko manga hegeu kia Jesus, ma te haka to'o ena hakahua o na priest ma na Pharisee na ge'o sanga o te Hage Tapu, ke he 'osohi kia te Ia. ");
INSERT INTO mnv_vpl VALUES ("JN7_33","073_7_33","JHN","7","33","33","Ma te hai atu a Jesus, “Ko Au manga haka pata kia te koutou i te mi'i gholoba, kae hai kau go hoki kia te Ia noko haka to'o mai ia te Au. ");
INSERT INTO mnv_vpl VALUES ("JN7_34","073_7_34","JHN","7","34","34","Koutou kago sasaga ia te Au, ka kago he'e kite e koutou ia te Au, iteme'agaa te kunga go hano kinai Au, kago he'e 'aonga te boo ange kinai koutou.” ");
INSERT INTO mnv_vpl VALUES ("JN7_35","073_7_35","JHN","7","35","35","Ma te hai ake na hakahua o na Jew, “Kohea te hai ke go hano kinai te tangata nei, ke go he'e kite ai e kitatou ia te Ia? Ko Ia e hai ke hano ki na kunga noho 'aki ai otatou pegea ki na pegea o Greece, ke ako ai e Ia na pegea o Greece? ");
INSERT INTO mnv_vpl VALUES ("JN7_36","073_7_36","JHN","7","36","36","Niaa te kua haka gaataki e Ia i tena hai mai 'anga, ‘Koutou kago sasaga ia te Au, ka kago he'e kite e koutou ia te Au, iteme'agaa te kunga go hano kinai Au, kago he'e 'aonga te boo ange kinai koutou?’ ” ");
INSERT INTO mnv_vpl VALUES ("JN7_37","073_7_37","JHN","7","37","37","Nimaa i te 'ao taha'aki o te haka tahinga, tenaa te hu'ai 'ao o te Haka tahinga, ko Jesus noko tu'u o hai atu i tona hu'ai ge'o, “Nimaa iai he pegea sia binu, tuku ia te ia ke a'u kia te Au o binu. ");
INSERT INTO mnv_vpl VALUES ("JN7_38","073_7_38","JHN","7","38","38","E hai ake na Kanukanu Tapu: ‘Koai e too kia te Au te pupuke 'anga te bai o te ma'ugi e mimigo iho i te uso o'ona.’ ” ");
INSERT INTO mnv_vpl VALUES ("JN7_39","073_7_39","JHN","7","39","39","Tena gea 'anga nei noko haka gaataki e Ia te Spirit Tapu. Nimaa iai ni pegea kua too kia te Ia, e hai kigatou go mani ga'u 'ia. Ka na 'aso na, te Spirit Tapu manga koi he'e haiga'a mai, iteme'agaa ko Jesus manga koi he'e hoki ki tona mamagunga i te gangi. ");
INSERT INTO mnv_vpl VALUES ("JN7_40","073_7_40","JHN","7","40","40","Te 'apitanga na haka gongo ki tena gea 'anga nei, o hai ake kogaa ia te kigatou, “E maa'ogi te tangata nei te taauga.” ");
INSERT INTO mnv_vpl VALUES ("JN7_41","073_7_41","JHN","7","41","41","Ka noko hai atu kogaa, “Ko Ia te 'Agiki Taga'ia.” Ka kogaa pegea noko manga hai atu, “Te 'Agiki Taga'ia ka he'e a'u i Galilee! ");
INSERT INTO mnv_vpl VALUES ("JN7_42","073_7_42","JHN","7","42","42","'Ai na Kanukanu Tapu noko he'e hai ake: Te 'Agiki Taga'ia e hai ke go a'u i te hanohano o David, ma te a'u i Bethlehem, te manaha noko kakai ai a David?” ");
INSERT INTO mnv_vpl VALUES ("JN7_43","073_7_43","JHN","7","43","43","Tenei te hai 'anga na tuhatuha ai te 'apitanga i te ghaghi ia Jesus. ");
INSERT INTO mnv_vpl VALUES ("JN7_44","073_7_44","JHN","7","44","44","Noko iai na pegea siahahai ke he 'osohi kia Jesus, ka na si'ai he pegea ke 'oso kia te Ia. ");
INSERT INTO mnv_vpl VALUES ("JN7_45","073_7_45","JHN","7","45","45","Ma te giu ake na ge'o sanga o te Hage Tapu ki na hakahua o na Priest ma na Pharisee, ma te haka anu na Pharisee kia te kigatou o hai atu, “ 'Eaa e he'e kakabe mai ai e koutou ia te Ia?” ");
INSERT INTO mnv_vpl VALUES ("JN7_46","073_7_46","JHN","7","46","46","Ma te haka tau atu na ge'o sanga o te Hage Tapu, “E si'ai he pegea konei na gea te tangata nei.” ");
INSERT INTO mnv_vpl VALUES ("JN7_47","073_7_47","JHN","7","47","47","Ma te haka anu atu na Pharisee, “ 'Ai koutou kua tata'o ma'u ki ana goi 'anga? ");
INSERT INTO mnv_vpl VALUES ("JN7_48","073_7_48","JHN","7","48","48","E iai he launatasi i na hutiaki po he Parasi kua too kia te Ia? ");
INSERT INTO mnv_vpl VALUES ("JN7_49","073_7_49","JHN","7","49","49","Si'ai, manga na pegea he'e na'a e kigatou na tagangonga. Ko kigatou kago kagohia.” ");
INSERT INTO mnv_vpl VALUES ("JN7_50","073_7_50","JHN","7","50","50","Ko Nicodemus, na hano kia Jesus i te poo, koia ma'u te launatasi o na Pharisee, noko haka anu atu kia te kigatou, ");
INSERT INTO mnv_vpl VALUES ("JN7_51","073_7_51","JHN","7","51","51","“ 'Ai atatou tagangonga manga mu'a te haka pau pegea ke mate, he'e mataa haka gongo kia te ia, ke na'a po nia te hai eia?” ");
INSERT INTO mnv_vpl VALUES ("JN7_52","073_7_52","JHN","7","52","52","Ko kigatou na haka tau o hai atu kinai, “ 'Ai ko koe ma'u te pegea mai Galilee? Haka sahe atu na Kanukanu Tapu o na'a ai e koe, e si'ai he taauga ke a'u mai Galilee.” ");
INSERT INTO mnv_vpl VALUES ("JN7_53","073_7_53","JHN","7","53","53","Ko kigatou na maseu o taki boo ki ogatou hage. ");
INSERT INTO mnv_vpl VALUES ("JN8_1","073_8_1","JHN","8","1","1","Ka ko Jesus noko hano ki te Ogo i Olives. ");
INSERT INTO mnv_vpl VALUES ("JN8_2","073_8_2","JHN","8","2","2","Nimaa i te mahoata, ko Jesus na sopo hoki ake ki te Hage Tapu. Noko 'eha pegea haka putu mai o mugheghi ia te Ia, ma te noho a Jesus o ako ia te kigatou. ");
INSERT INTO mnv_vpl VALUES ("JN8_3","073_8_3","JHN","8","3","3","Ka na ako o na tagangonga ma na Pharisee noko kakabe ake e kigatou te hahine hai matu'a maasoko. Noko tuku e kigatou te hahine o tu'u 'ago i te 'apitanga, ");
INSERT INTO mnv_vpl VALUES ("JN8_4","073_8_4","JHN","8","4","4","kae hai atu kia Jesus, “Ako, te hahine nei te pegea e hai matu'a, kae kite 'ia manga maasoko. ");
INSERT INTO mnv_vpl VALUES ("JN8_5","073_8_5","JHN","8","5","5","Ka ko Moses noko tuku eia i na tagangonga kimatou noko taa hatu 'ia na haahine konei na noho, ka tehea kinai ta'au gea 'anga?” ");
INSERT INTO mnv_vpl VALUES ("JN8_6","073_8_6","JHN","8","6","6","Ko kigatou noko konei na gegea kia Jesus, i te noko haka anuanu pake kigatou haka makau 'ia ia te Ia i ma'ana he gea 'anga. Ka ko Jesus noko manga punou o kanukanu ki te kege i te maninia gima. ");
INSERT INTO mnv_vpl VALUES ("JN8_7","073_8_7","JHN","8","7","7","Ko kigatou na pau o haka anuanu 'aki kia te Ia, ma te keu ake a Jesus o hai atu kia te kigatou, “Nimaa iai he pegea ia te koutou e he'e tau 'oosongo, tenaa ia e hai ke mataa tupe eia he hatu ki te hahine na.” ");
INSERT INTO mnv_vpl VALUES ("JN8_8","073_8_8","JHN","8","8","8","Kae punou hoki o kanukanu ki te kege. ");
INSERT INTO mnv_vpl VALUES ("JN8_9","073_8_9","JHN","8","9","9","Te gholoba na haka gongo kinai kigatou, ko kigatou na boo taki tasi ki haho, noko mataa boo na maatu'a. Na boo aano manga toe launatasi a Jesus ma te hahine noko manga koi tu'u i te kungaa. ");
INSERT INTO mnv_vpl VALUES ("JN8_10","073_8_10","JHN","8","10","10","Ma te keu ake a Jesus ki te hahine o hai atu, “Ta'ahine, kohea a kigatou? 'Ai e he'e tau pegea haka pau ia te koe ke mate?” ");
INSERT INTO mnv_vpl VALUES ("JN8_11","073_8_11","JHN","8","11","11","Ma te haka tau atu te hahine, “Oo Hakahua, he'e tau pegea.” Ma te hai atu a Jesus, “Ka he'e haka pau ma'u e Au ia te koe ke mate, hinatu, kae noka te 'oosongo hoki.” ");
INSERT INTO mnv_vpl VALUES ("JN8_12","073_8_12","JHN","8","12","12","Ko Jesus noko gea hoki kia te kigatou, o hai atu, “Ko Au te maagama ki te kege nei, koai e tata'o tu'a ia te Au kago he'e sehu i te poo'uginga, kae hai ke go ga'u eia te maagama o te ma'ugi.” ");
INSERT INTO mnv_vpl VALUES ("JN8_13","073_8_13","JHN","8","13","13","Na Pharisee noko hai atu kia Jesus, “E noho mai ko Koe manga gea kia te Koe, ka 'au 'atigongo 'anga na e he'e maa'ogi.” ");
INSERT INTO mnv_vpl VALUES ("JN8_14","073_8_14","JHN","8","14","14","Ma te haka tau atu a Jesus, “Masi'igoa ko Au manga gea kia te Au, ka 'aku gea 'anga nei e maa'ogi, iteme'agaa e na'a e Au te kunga noko a'u ai Au, ma te kunga e hai kau go hano kinai, kae he'e na'a ma'u e koutou po ko Au noko a'u mai hea, o he'e na'a ma'u e koutou po ko Au go hano ki hea. ");
INSERT INTO mnv_vpl VALUES ("JN8_15","073_8_15","JHN","8","15","15","Koutou manga haka aba i na noho o pegea, ka ko Au e he'e haka aba e Au he pegea. ");
INSERT INTO mnv_vpl VALUES ("JN8_16","073_8_16","JHN","8","16","16","Ka ko Au poi hai haka aba, aku paaunga e maa'ogi, iteme'agaa ko Au he'e launatasi, ka ko Au manga haka pata kinai a Tamau noko haka to'o mai ia te Au. ");
INSERT INTO mnv_vpl VALUES ("JN8_17","073_8_17","JHN","8","17","17","Na 'oti i te kanukanu ki autou tagangonga: Te 'atigongo o te toka gua pegea e maa'ogi. ");
INSERT INTO mnv_vpl VALUES ("JN8_18","073_8_18","JHN","8","18","18","Ko Au manga 'atigongo ia te Au. Ka tegaa tasi e 'atigongo ma'u ia te Au: Ko Tamau noko haka to'o mai ia te Au.” ");
INSERT INTO mnv_vpl VALUES ("JN8_19","073_8_19","JHN","8","19","19","Ma te haka anu kigatou kia te Ia o hai atu, “Tehea tou Tamana?” Ma te haka tau atu kinai a Jesus, “E he'e na'a e koutou ia te Au ma Tamau, ka poi na'a e koutou ia te Au, kua na'a ma'u e koutou ia Tamau.” ");
INSERT INTO mnv_vpl VALUES ("JN8_20","073_8_20","JHN","8","20","20","Ko Jesus noko gea i na hai 'anga nei i te gholoba noko manga ako ai i te Hage Tapu, o pata i na me'a tuku ga'a tausu'u, ka noko si'ai he pegea 'oso kia te Ia, iteme'agaa noko ma koi he'e tatae te 'aso o 'Ona. ");
INSERT INTO mnv_vpl VALUES ("JN8_21","073_8_21","JHN","8","21","21","Ma te gea hoki ma'u a Jesus kia te kigatou, “Ko Au e hai kau hano. Koutou kago noko sasaga ia te Au, ka koutou kago mamate ki outou 'oosongo. Kohea e hano kinai Au, koutou kago he'e 'aonga te boo ange kinai.” ");
INSERT INTO mnv_vpl VALUES ("JN8_22","073_8_22","JHN","8","22","22","Te gea 'anga a Jesus nei na hai ake ai na Jew, “Ko Ia gaa ka taa ia te Ia? Tena te hai 'anga e hai mai ai, ‘Te kunga e hano kinai Au kago he'e 'aonga te boo ange kinai koutou’?” ");
INSERT INTO mnv_vpl VALUES ("JN8_23","073_8_23","JHN","8","23","23","Haka tau atu kinai a Jesus, “Koutou na pegea o gago nei, ka ko Au te pegea mai 'agunga. Koutou na pegea o te kege nei, ka ko Au he'e te pegea o te kege nei. ");
INSERT INTO mnv_vpl VALUES ("JN8_24","073_8_24","JHN","8","24","24","Ko Au kua hai atu kia te koutou, koutou kago mamate ki outou 'oosongo. I te poi he'e too koutou ko AU ko AU, koutou kago mamate ki outou 'oosongo.” ");
INSERT INTO mnv_vpl VALUES ("JN8_25","073_8_25","JHN","8","25","25","Ko kigatou noko haka anu atu, “ 'Ai ko Koe koai?” Ma te haka tau atu a Jesus, “Manga noho pe nia kua gea goa kinai Au. ");
INSERT INTO mnv_vpl VALUES ("JN8_26","073_8_26","JHN","8","26","26","Ko Au e 'eha hai 'anga kau gea ai ma te haka aba ai ia te koutou, ka ko Ia noko haka to'o mai ia te Au, ko Ia e maa'ogi. E hai kau manga gea kia pegea i nia noko haka gongo ai Au kia te Ia.” ");
INSERT INTO mnv_vpl VALUES ("JN8_27","073_8_27","JHN","8","27","27","Noko he'e na'a e kigatou ko Jesus noko manga gea kia te kigatou ia te Tamana. ");
INSERT INTO mnv_vpl VALUES ("JN8_28","073_8_28","JHN","8","28","28","Ma te hai atu a Jesus kia te kigatou, “Te 'aso kago taa ai e koutou te Hosa o Pegea ki te kros, tena te 'aso kago na'a ai e koutou ko AU ko AU, ma te na'a ma'u ai e koutou ko Au he'e hai paaunga launatasi, ka ko Au manga gea kia pegea i nia noko ako e Tamau kia te Au. ");
INSERT INTO mnv_vpl VALUES ("JN8_29","073_8_29","JHN","8","29","29","Ko Ia noko haka to'o mai ia te Au manga haka pata kia te Au. E he'e tuku e Ia ia te Au kau launatasi, iteme'agaa ko ba'i 'aso manga hai e Au nia e magaohie ai.” ");
INSERT INTO mnv_vpl VALUES ("JN8_30","073_8_30","JHN","8","30","30","Noko 'eha pegea na too kia te Ia i tena konei na gea 'anga. ");
INSERT INTO mnv_vpl VALUES ("JN8_31","073_8_31","JHN","8","31","31","Ko Jesus noko gea ki na Jew na too kia te Ia o hai atu, “Koutou nimaa pipiki ki te akonga a 'Aku, koutou na pegea haka ako maa'ogi o 'Oku. ");
INSERT INTO mnv_vpl VALUES ("JN8_32","073_8_32","JHN","8","32","32","Ma te hai ke go na'a e koutou te maa'ogi, ma te maa'ogi e hai ke go haka tausu'u ia te koutou.” ");
INSERT INTO mnv_vpl VALUES ("JN8_33","073_8_33","JHN","8","33","33","Ko kigatou noko haka tau kia Jesus o hai atu, “Ko kimatou te hanohano o Abraham, ko kimatou he'e tino akina, kae kohea na gaataki e Koe, te hai mai ke haka tausu'u ia te kimatou?” ");
INSERT INTO mnv_vpl VALUES ("JN8_34","073_8_34","JHN","8","34","34","Ma te haka tau atu a Jesus, “Ko Au e gea maa'ogi kia te koutou: Ko ba'i pegea hai 'oosongo manga tino ai na 'oosongo. ");
INSERT INTO mnv_vpl VALUES ("JN8_35","073_8_35","JHN","8","35","35","Te pegea tino akina e he'e pau o haka pata ki te pegea ma tena haanau, ka manga te hosa te pau o haka pata kinai. ");
INSERT INTO mnv_vpl VALUES ("JN8_36","073_8_36","JHN","8","36","36","Ka nimaa hai e te Hosa ia te koutou o tausu'u, koutou ka pau o tausu'u maa'ogi. ");
INSERT INTO mnv_vpl VALUES ("JN8_37","073_8_37","JHN","8","37","37","E na'a e Au koutou te hanohano o Abraham, ka manga hai lobo koutou ke taa ia te Au, iteme'agaa koutou e he'e tata'o ki aku akonga. ");
INSERT INTO mnv_vpl VALUES ("JN8_38","073_8_38","JHN","8","38","38","Ko Au manga gea kia te koutou i nia noko haka 'agi e Tamau kia te Au, ka manga hai e koutou nia noko haka gongo ai koutou ki outou tupuna.” ");
INSERT INTO mnv_vpl VALUES ("JN8_39","073_8_39","JHN","8","39","39","Ma te haka tau kigatou o hai atu, “Ko Abraham tematou tupuna.” Ma te hai atu a Jesus, “Koutou nimaa na makupuna o Abraham, hai atu na hekau noko hai e Abraham. ");
INSERT INTO mnv_vpl VALUES ("JN8_40","073_8_40","JHN","8","40","40","Ka koutou e hai lobo ke taa ia te Au manga 'atigongo kia te koutou i te maa'ogi noko haka gongo ai Au kia te 'Aitu. Ko Abraham noko he'e hai eia na hai 'anga konei na noho. ");
INSERT INTO mnv_vpl VALUES ("JN8_41","073_8_41","JHN","8","41","41","Koutou manga hai e koutou nia noko hai e outou tamana.” Ko kigatou noko haka tau he 'ika'ika 'aki o hai atu, “Ko kimatou he'e na tama giki ma'a ni pegea maasoko, ka ko kimatou e hai tematou Tamana e tasi ko te 'Aitu.” ");
INSERT INTO mnv_vpl VALUES ("JN8_42","073_8_42","JHN","8","42","42","Ma te hai atu a Jesus kia te kigatou, “Ko te 'Aitu poi te Tamana o 'outou, koutou ma maa'ine kia te Au, iteme'agaa ko Au noko a'u mai a te 'Aitu, tenei Au. Ko Au noko he'e a'u i ma'aku ni haka gaatanga, ka ko Au noko haka to'o mai e te 'Aitu. ");
INSERT INTO mnv_vpl VALUES ("JN8_43","073_8_43","JHN","8","43","43","Tehea te hai 'anga e he'e na'a ai e koutou nia e gea ai Au? E he'e na'a e koutou, iteme'agaa koutou e he'e haka gongo ki aku haka hegeunga. ");
INSERT INTO mnv_vpl VALUES ("JN8_44","073_8_44","JHN","8","44","44","Koutou te haanau a te tamana o'outou ia Satan, manga siahai koutou ke hai na haka siahai a te tamana o'outou. Koia te 'atua taa pegea noko haka tu'u mai i te haka tu'u sanga o na henua. Koia e he'e pipiki nia e maa'ogi, iteme'agaa te maa'ogi e he'e noho i goto ia te ia. Ona 'aso goi ai, manga gea i te huhuta o'ona, iteme'agaa koia te 'atua goi ma te tamana o na pegea gogoi. ");
INSERT INTO mnv_vpl VALUES ("JN8_45","073_8_45","JHN","8","45","45","Ka ko Au e gea kia te koutou i te maa'ogi, tenei te hai 'anga e he'e too ai koutou kia te Au. ");
INSERT INTO mnv_vpl VALUES ("JN8_46","073_8_46","JHN","8","46","46","E iai he pegea ia te koutou e 'aonga te haka 'agi eia ko Au e saga i he 'oosongo? Ka ko Au nimaa 'atigongo i te maa'ogi kia te koutou, 'eaa e he'e too ai koutou kia te Au? ");
INSERT INTO mnv_vpl VALUES ("JN8_47","073_8_47","JHN","8","47","47","Te pegea o te 'Aitu, e hai ke haka gongo ki nia e gea ai a te 'Aitu, ka tenei te hai 'anga e he'e haka gongo ai koutou kia te Au, iteme'agaa koutou he'e na pegea o te 'Aitu.” ");
INSERT INTO mnv_vpl VALUES ("JN8_48","073_8_48","JHN","8","48","48","Na Jew noko haka tau atu kia Jesus, “ 'Ai e he'e maa'ogi tematou hai atu 'anga, ko Koe te pegea mai Samaria, ko Koe e uguhia?” ");
INSERT INTO mnv_vpl VALUES ("JN8_49","073_8_49","JHN","8","49","49","Ma te haka tau kinai a Jesus o hai atu, “Ko Au e he'e uguhia, ka ko Au manga haka e'eha e Au ia Tamau, ka manga haka ma'u gago e koutou ia te Au. ");
INSERT INTO mnv_vpl VALUES ("JN8_50","073_8_50","JHN","8","50","50","Ko Au e he'e sasaga mo'oku he mamagunga, ka ko te 'Aitu te manga sasaga e Ia. E hai ma'u ke go haka aba e Ia. ");
INSERT INTO mnv_vpl VALUES ("JN8_51","073_8_51","JHN","8","51","51","Ko Au e gea maa'ogi kia te koutou: Nimaa iai he pegea e pipiki aku haka hegeunga nei, ko Ia kago he'e mate.” ");
INSERT INTO mnv_vpl VALUES ("JN8_52","073_8_52","JHN","8","52","52","Na Jew noko hai hu'ai ge'o o hai atu kia Jesus, “Te 'aso nei kua na'a e kimatou ko Koe e uguhia: Ko Abraham na mate o konaa na noho ma'u na taauga, ka ko Koe e hai mai, ‘Nimaa iai he pegea pipiki na haka hegeunga a 'Aku, koia kago he'e mate.’ ");
INSERT INTO mnv_vpl VALUES ("JN8_53","073_8_53","JHN","8","53","53","'Ai ko Koe e hu'ai hua'eha o sigi i tematou tupuna a Abraham? Ka koia na mate o kogaa ana noho ma'u na taauga. Kae tegeu'a ake Koe, ko Koe koai?” ");
INSERT INTO mnv_vpl VALUES ("JN8_54","073_8_54","JHN","8","54","54","Ko Jesus noko haka tau atu, “Ko Au poi manga haka e'eha e Au ia te Au, aku haka e'eha 'anga e he'e tau hai 'anga. Ka ko Tamau e hai ake koutou, ko Ia te 'Aitu o 'outou, tenaa Ia manga haka e'eha ia te Au. ");
INSERT INTO mnv_vpl VALUES ("JN8_55","073_8_55","JHN","8","55","55","Masi'igoa e he'e na'a e koutou ia te Ia, kae na'a e Au ia te 'Aitu. Ka nimaa hai atu Au, e he'e na'a e Au ia te Ia, ko Au ka goi ai o noho pe koutou. Kae na'a e Au ia te Ia, ma te pipiki e Au ana haka hegeunga. ");
INSERT INTO mnv_vpl VALUES ("JN8_56","073_8_56","JHN","8","56","56","Ko te tupuna o 'outou ia Abraham noko siasia i tena maanatu ke ina ki toku 'aso, ka na ina kinai ma te magaohie ai.” ");
INSERT INTO mnv_vpl VALUES ("JN8_57","073_8_57","JHN","8","57","57","Ma te hai atu na Jew kia Jesus, “Ko Koe koi he'e gimanga hugu ou ghapu, 'ai ko Koe noko ina kia Abraham?” ");
INSERT INTO mnv_vpl VALUES ("JN8_58","073_8_58","JHN","8","58","58","Ma te haka tau atu a Jesus, “Ko Au e gea maa'ogi kia te koutou: Na 'aso noko manga koi he'e haka haa ai a Abraham, ko AU.” ");
INSERT INTO mnv_vpl VALUES ("JN8_59","073_8_59","JHN","8","59","59","Ma te sa'u ake e kigatou na hatu ke taa hatu ai ia te Ia, ma te haka ngigo a Jesus o hano 'aatea i te Hage Tapu. ");
INSERT INTO mnv_vpl VALUES ("JN9_1","073_9_1","JHN","9","1","1","Ko Jesus noko manga sehu, ma te ina ki te tangata kibi, noko haka tu'u mai i tena haka haa 'anga. ");
INSERT INTO mnv_vpl VALUES ("JN9_2","073_9_2","JHN","9","2","2","Na pegea haka ako o Jesus noko haka anu 'aki kia te Ia o hai atu, “Ako, to'ai te 'oosongo i te tangata nei ma o na hai maatu'a, te noko haka haa ai te tangata nei o kibi?” ");
INSERT INTO mnv_vpl VALUES ("JN9_3","073_9_3","JHN","9","3","3","Ko Jesus noko hai atu, “E he'e na 'oosongo o te tangata nei po o 'ona hai maatu'a, ka te hai 'anga nei e hai ke haka 'agi ai na hekau a te 'Aitu i te ma'ugi o'ona. ");
INSERT INTO mnv_vpl VALUES ("JN9_4","073_9_4","JHN","9","4","4","E hai kau hai 'ia na hekau a te 'Aitu noko haka to'o mai ia te Au i na 'aso koi 'ao ai nei, na'e nimaa go a'u te poo kago si'ai he pegea 'aonga te hai hekau. ");
INSERT INTO mnv_vpl VALUES ("JN9_5","073_9_5","JHN","9","5","5","Na 'aso koi noho ai Au i gago nei, ko Au te maagama ki gago nei.” ");
INSERT INTO mnv_vpl VALUES ("JN9_6","073_9_6","JHN","9","6","6","Nimaa 'oti i te konei ana gea, kae nga'esu ki na kege o natu aano maguu o hugu ai na mata o te tangata. ");
INSERT INTO mnv_vpl VALUES ("JN9_7","073_9_7","JHN","9","7","7","Ma te hai atu kia te ia, “Hinatu o huhu'i ou mata i te bai i Siloam.” (Te ingoa nei e haka gaataki: Te Haka to'o). Ka te tangata na hano o huhu'i na mata, nimaa hokimai kua ina. ");
INSERT INTO mnv_vpl VALUES ("JN9_8","073_9_8","JHN","9","8","8","Ona pegea noko taha mai ma na pegea noko ta'a hiina'i ki ana haka ene 'anga, noko haka anuanu 'aki, “ 'Ai he'e tenei te tangata noko ta'anga noho o manga haka ene?” ");
INSERT INTO mnv_vpl VALUES ("JN9_9","073_9_9","JHN","9","9","9","Noko iai na pegea noko hai ake, “Koia tenaa.” Kae hai atu kogaa, “Si'ai, manga noho kia te ia.” Ka koia noko hai atu, “E maa'ogi koau.” ");
INSERT INTO mnv_vpl VALUES ("JN9_10","073_9_10","JHN","9","10","10","Ma te haka anuanu a kigatou kia te ia o hai atu, “Ka gua mata o 'ou e kohea na lugaluga?” ");
INSERT INTO mnv_vpl VALUES ("JN9_11","073_9_11","JHN","9","11","11","Koia noko haka tau atu, “Te tangata e mate e kigatou ko Jesus, te natu e Ia na kege o hugu ai oku mata, kae kaunaki e Ia kau hano o huhu'i oku mata i te bai i Siloam. Nimaa hano au o huhu'i, ma te ina ai au.” ");
INSERT INTO mnv_vpl VALUES ("JN9_12","073_9_12","JHN","9","12","12","Ko kigatou na haka anu atu, “Ka tehea te tangata nei?” Ma te hai atu ia, “E he'e na'a eau.” ");
INSERT INTO mnv_vpl VALUES ("JN9_13","073_9_13","JHN","9","13","13","Na kakabe e kigatou te tangata noko kibi ki na Pharisee. ");
INSERT INTO mnv_vpl VALUES ("JN9_14","073_9_14","JHN","9","14","14","Ka te 'ao noko natu ai e Jesus na kege o lugaluga ai e Ia na mata o te tangata kibi te 'Ao Oki oki. ");
INSERT INTO mnv_vpl VALUES ("JN9_15","073_9_15","JHN","9","15","15","Tena te hai 'anga noko haka anuanu ma'u ai na Pharisee ki te tangata noko kibi, po koia e kohea na hai o ina, ma te haka tau ia kia te kigatou o hai atu, “Noko hugu e Ia oku mata i na kege kae huhu'i eau, ma te ina au.” ");
INSERT INTO mnv_vpl VALUES ("JN9_16","073_9_16","JHN","9","16","16","Kogaa i na Pharisee noko hai atu, “Te tangata nei e he'e a'u mai a te 'Aitu, iteme'agaa e he'e pipiki e Ia te 'Ao Oki oki.” Ka kogaa noko haka anuanu atu, “Kae hai ke kohea na hai ehe pegea 'oosongo na hai 'anga haka ohokia nei?” Ma te tuhatuha ai kigatou. ");
INSERT INTO mnv_vpl VALUES ("JN9_17","073_9_17","JHN","9","17","17","Ma te haka anuanu giu na Pharisee ki te tangata noko kibi o hai atu kinai, “E hai mai koe kua lugaluga e Ia gu'ou mata o ina, ka tehea ta'au gea 'anga kia te Ia?” Ka koia na haka tau atu, “Ko Ia te taauga.” ");
INSERT INTO mnv_vpl VALUES ("JN9_18","073_9_18","JHN","9","18","18","Na hu'ai pegea o Jew noko manga koi he'e too koia te pegea noko kibi ka kua ina, aano pogo 'aki kigatou i na hai maatu'a o te tangata. ");
INSERT INTO mnv_vpl VALUES ("JN9_19","073_9_19","JHN","9","19","19","O haka anu 'aki atu kia te kigaaua, “Taugua tama tenei? Tenei te tangata noko hai mai kougua noko kibi i tena haka haa 'anga, kae kohea na hai o ina i te 'aso nei?” ");
INSERT INTO mnv_vpl VALUES ("JN9_20","073_9_20","JHN","9","20","20","Ma te hai atu a ona hai maatu'a, “E na'a e kimaaua koia temaaua tama noko kibi i tena haka haa 'anga. ");
INSERT INTO mnv_vpl VALUES ("JN9_21","073_9_21","JHN","9","21","21","Kae kohea na hai o ina, ma te koai kua lugaluga gua mata, e he'e na'a e kimaaua. Haka anu atu kia te ia, na'e koia kua tauiku. Koia manga 'aonga te gea ake ia te ia.” ");
INSERT INTO mnv_vpl VALUES ("JN9_22","073_9_22","JHN","9","22","22","Ko ona hai maatu'a noko konei agaaua gegea, iteme'agaa ko kigaaua noko matataku ki na Jew, i te na 'oti i te haka pau ena Jew, nimaa iai he pegea 'atigongo ko Jesus te 'Agiki Taga'ia, koia e hai ke go pagepage i te Hage hai paaunga. ");
INSERT INTO mnv_vpl VALUES ("JN9_23","073_9_23","JHN","9","23","23","Tenei te hai 'anga na hai atu ai a ona hai maatu'a, “Koia kua tauiku manga haka anu atu kia te ia.” ");
INSERT INTO mnv_vpl VALUES ("JN9_24","073_9_24","JHN","9","24","24","Ko kigatou na pogo aki giu i te tangata noko kibi, o hai atu kinai, “Haka e'eha atu ia te 'Aitu. E na'a e kitatou te tangata nei te pegea 'oosongo.” ");
INSERT INTO mnv_vpl VALUES ("JN9_25","073_9_25","JHN","9","25","25","Te tangata na haka tau atu, “E he'e na'a eau pote pegea 'oosongo po si'ai, kae tasi hai 'anga e na'a eau, koau noko kibi ka te 'aso nei koau kua ina.” ");
INSERT INTO mnv_vpl VALUES ("JN9_26","073_9_26","JHN","9","26","26","Ma te haka anu atu kigatou kia te ia, “Niaa te noko hai e Ia kia te koe? Noko kohea na lugaluga e Ia gu'ou mata?” ");
INSERT INTO mnv_vpl VALUES ("JN9_27","073_9_27","JHN","9","27","27","Te tangata kibi na haka tau atu, “Kua 'atigongo ai au kia te koutou ka manga he'e haka gongo kinai koutou, ka 'eaa e siahai koutou ke haka gongo giu kinai? 'Ai koutou ma'u e siahahai ke hai ai mo'ona ni pegea haka ako?” ");
INSERT INTO mnv_vpl VALUES ("JN9_28","073_9_28","JHN","9","28","28","Ma te huhu kigatou kia te ia, kae hai atu, “Tenaa koe te pegea haka ako o te pegea nei, ka ko kimatou na pegea haka ako o Moses. ");
INSERT INTO mnv_vpl VALUES ("JN9_29","073_9_29","JHN","9","29","29","E na'a e kimatou ko te 'Aitu noko gea kia Moses, ka te pegea nei e he'e na'a e kimatou po ko Ia e a'u mai hea.” ");
INSERT INTO mnv_vpl VALUES ("JN9_30","073_9_30","JHN","9","30","30","Te tangata noko kibi na haka tau kia te kigatou o hai atu, “Te hai 'anga haka ohokia tenei, e he'e na'a e koutou po ko Ia e a'u mai hea, ka kua lugaluga e Ia gu'oku mata. ");
INSERT INTO mnv_vpl VALUES ("JN9_31","073_9_31","JHN","9","31","31","E na'a e kitatou ko te 'Aitu e he'e haka gongo ki na pegea 'oosongo, ka ko Ia manga haka gongo ki na pegea sogi maa'ogi kia te Ia, ma te hai nia e siahai kinai a te 'Aitu. ");
INSERT INTO mnv_vpl VALUES ("JN9_32","073_9_32","JHN","9","32","32","Haka tu'u mai i gaa 'aso, e si'ai he pegea ngutua ke luga eia ni mata mo'o he pegea kibi haka tu'u mai i tena haka haa 'anga. ");
INSERT INTO mnv_vpl VALUES ("JN9_33","073_9_33","JHN","9","33","33","Te tangata nei poi he'e te pegea mai a te 'Aitu, e he'e 'aonga te hai e Ia ni hai 'anga.” ");
INSERT INTO mnv_vpl VALUES ("JN9_34","073_9_34","JHN","9","34","34","Ko kigatou noko haka tau kia te ia o hai atu, “Ko koe noko 'oosongo mai i tau haka haa 'anga! 'Ai e hai ke ako e koe ia te kimatou?!” Ma te tupe e kigatou ia te ia ki haho. ");
INSERT INTO mnv_vpl VALUES ("JN9_35","073_9_35","JHN","9","35","35","Ko Jesus na gongo i te tupe 'anga e kigatou ia te ia ki haho. Nimaa i te 'aso na sasa'o ai kia te ia, ma te hai atu, “Ko koe e too ki te Hosa o Pegea?” ");
INSERT INTO mnv_vpl VALUES ("JN9_36","073_9_36","JHN","9","36","36","Te tangata noko kibi na haka anu atu kia Jesus, “Hakahua, hogahoga mai, ka kau too kia te Ia.” ");
INSERT INTO mnv_vpl VALUES ("JN9_37","073_9_37","JHN","9","37","37","Ma te hai atu a Jesus kia te ia, “Ko koe ma ina kinai, ka tenei ma'u Au te manga gea kia te koe.” ");
INSERT INTO mnv_vpl VALUES ("JN9_38","073_9_38","JHN","9","38","38","Ma te hai atu te tangata, “Hakahua, koau e too kia te Koe.” Kae toko tugi o sogi kia te Ia. ");
INSERT INTO mnv_vpl VALUES ("JN9_39","073_9_39","JHN","9","39","39","Ko Jesus na hai atu, “Ko Au noko a'u ki gago nei ke hakaaba a pegea. Na pegea he'e hiina'i, e hai ke go hiina'i. Ka na pegea manga hiina'i, e hai ke go kikibi.” ");
INSERT INTO mnv_vpl VALUES ("JN9_40","073_9_40","JHN","9","40","40","Noko iai na Pharisee noko noho 'aki haka hitaiaki kia te Ia, na haka gongo ki te konei ana gea 'anga, ma te haka anu atu, “ 'Eaa? 'Ai ko kimatou ma'u e kikibi?” ");
INSERT INTO mnv_vpl VALUES ("JN9_41","073_9_41","JHN","9","41","41","Ma te hai atu a Jesus kia te kigatou, “Koutou poi kikibi, koutou e he'e saga i he 'oosongo, ka kua hai mai koutou, ‘Ko kimatou e he'e kikibi,’ tenaa te hai 'anga koutou manga koi noho toka ai i outou 'oosongo.” ");
INSERT INTO mnv_vpl VALUES ("JN10_1","073_10_1","JHN","10","1","1","Ko Jesus noko hai atu, “Ko Au e gea maa'ogi kia te koutou: Te pegea e he'e mene i te aga o te 'aa o na sipisipi, ka manga kake i te kunga 'aatea, koia te pegea kaia'a ma te mou to'o. ");
INSERT INTO mnv_vpl VALUES ("JN10_2","073_10_2","JHN","10","2","2","Te tangata e mene ki goto i te agaa, tenaa ia te pegea e ge'o ana sipisipi. ");
INSERT INTO mnv_vpl VALUES ("JN10_3","073_10_3","JHN","10","3","3","Te ge'o sanga o te 'aa kago luga te aga ki te pegea ge'o sipisipi nei. Na sipisipi kago haka gongo ki tena ge'o. Koia kago ngege i na ingoa o ana sipisipi, ma te kakabe ia te kigatou ki tu'a. ");
INSERT INTO mnv_vpl VALUES ("JN10_4","073_10_4","JHN","10","4","4","Te 'aso e kakabe ai ana sipisipi ki tu'a, koia e mu'a ia te kigatou, ka ana sipisipi manga mugi ia te ia, iteme'agaa e na'a e kigatou te ge'o o'ona. ");
INSERT INTO mnv_vpl VALUES ("JN10_5","073_10_5","JHN","10","5","5","Ko kigatou kago he'e tata'o i he pegea 'aatea, kago he 'agiko ia te ia, iteme'agaa e he'e na'a e kigatou te ge'o o te pegea 'aatea.” ");
INSERT INTO mnv_vpl VALUES ("JN10_6","073_10_6","JHN","10","6","6","Ko Jesus noko gea kia te kigatou i te haka gaataki nei, ka noko he'e na'a e kigatou nia te hogahoga e Ia kia te kigatou. ");
INSERT INTO mnv_vpl VALUES ("JN10_7","073_10_7","JHN","10","7","7","Tegaa te hai 'anga na gea hoki ai a Jesus kia te kigatou, “Ko Au e gea maa'ogi kia te koutou: Ko Au te aga mo'ona sipisipi. ");
INSERT INTO mnv_vpl VALUES ("JN10_8","073_10_8","JHN","10","8","8","Ko ba'i pegea na mumu'a mai ia te Au, na pegea kaia'a ma te mou toto'o. Ka na sipisipi noko he'e haka gongo kia te kigatou. ");
INSERT INTO mnv_vpl VALUES ("JN10_9","073_10_9","JHN","10","9","9","Ko Au te aga. Koai e hano ki goto o agatu'u ia te Au, kago ma'ugi. Koia kago noko a'u ki goto ma te hano ki tu'a ke kite ma'ana ni utunga. ");
INSERT INTO mnv_vpl VALUES ("JN10_10","073_10_10","JHN","10","10","10","Na pegea kaia'a manga boomai ke kaia'a, ma te taa pegea, ma te haka masogo, ka ko Au noko a'u ke hai ai e kigatou te ma'ugi ma te mou tokatokanga. ");
INSERT INTO mnv_vpl VALUES ("JN10_11","073_10_11","JHN","10","11","11","“Ko Au te pegea ge'o sipisipi gaoi. Tegaa te pegea e ge'o sipisipi gaoi, te maangao ke haiga'a te ma'ugi ki na sipisipi. ");
INSERT INTO mnv_vpl VALUES ("JN10_12","073_10_12","JHN","10","12","12","Ka te pegea e tau'i 'ia, e he'e tenaa te pegea e hai ana sipisipi. Koia nimaa go ina ki he manu totogo hai maka e a'u, kago ti'aki eia na sipisipi kae tege. Ma te kakahi 'anga te manu totogo hai maka ki na sipisipi o hai o masoko te maseuseu. ");
INSERT INTO mnv_vpl VALUES ("JN10_13","073_10_13","JHN","10","13","13","Te tangata e tege, iteme'agaa koia te pegea manga tau'i 'ia, kae he'e 'agoha i na sipisipi. ");
INSERT INTO mnv_vpl VALUES ("JN10_14","073_10_14","JHN","10","14","14","“Ko Au te pegea ge'o sipisipi gaoi. E na'a e Au aku sipisipi, kae na'a e aku sipisipi ia te Au. ");
INSERT INTO mnv_vpl VALUES ("JN10_15","073_10_15","JHN","10","15","15","Manga konei na noho ma'u a Tamau e na'a e Ia ia te Au, kae na'a e Au ia te Ia, ma te maangao Au ke haiga'a toku ma'ugi ki na sipisipi. ");
INSERT INTO mnv_vpl VALUES ("JN10_16","073_10_16","JHN","10","16","16","E hai ma'u kogaa aku sipisipi, manga koi he'e i te tu'u sipisipi nei, kae hai ma'u kau go kakabe mai 'ia. Ko kigatou ma'u e hai ke go haka gongo ki toku ge'o, ke hai ai he tu'uganga e tasi, ma te pegea ge'o sipisipi e tasi. ");
INSERT INTO mnv_vpl VALUES ("JN10_17","073_10_17","JHN","10","17","17","Tenei te hai 'anga e ma'ine ai a Tamau kia te Au, ia te Au e maangao o haiga'a toku ma'ugi ka kau go ga'u haka hoki 'ia. ");
INSERT INTO mnv_vpl VALUES ("JN10_18","073_10_18","JHN","10","18","18","E si'ai he pegea ke go sa'u 'aatea eia ia te Au, ka manga haiga'a e Au i aku paaunga. Ko Au e hai taganga te haiga'a e Au, ma te hai taganga te sa'u haka hoki e Au. Na hai 'anga nei noko hai mai a Tamau kau hai 'ia.” ");
INSERT INTO mnv_vpl VALUES ("JN10_19","073_10_19","JHN","10","19","19","Tena gea 'anga nei, na tuhatuha giu ai na Jew. ");
INSERT INTO mnv_vpl VALUES ("JN10_20","073_10_20","JHN","10","20","20","Noko 'api ia te kigatou noko hai ake, “Ko Ia e uguhia, kae sasa to'a. 'Eaa e haka gongo ai kia te Ia?” ");
INSERT INTO mnv_vpl VALUES ("JN10_21","073_10_21","JHN","10","21","21","Ka kogaa noko hai atu, “Na pegea he uguhia 'aki e he'e konei na gegea. 'Ai e 'aonga te lugaluga e he 'atua ni mata mo'o he pegea kibi?!” ");
INSERT INTO mnv_vpl VALUES ("JN10_22","073_10_22","JHN","10","22","22","Nimaa tatae te 'aso o te haka tahinga o te Haa tapu 'anga te Hage Tapu, noko hai i Jerusalem. Te 'aso gogohi, ");
INSERT INTO mnv_vpl VALUES ("JN10_23","073_10_23","JHN","10","23","23","ka ko Jesus noko manga i goto i te Hage Tapu, o manga sehu i te kunga haka tokatoka noko ingoa kia Solomon. ");
INSERT INTO mnv_vpl VALUES ("JN10_24","073_10_24","JHN","10","24","24","Na Jew noko haka putu mai kia Jesus o hai atu, “E hia 'aso e hai e Koe ia te kimatou o he tootoo baasi'a 'aki. Nimaa ko Koe te 'Agiki Taga'ia, hogahoga haka maahoga mai kia te kimatou.” ");
INSERT INTO mnv_vpl VALUES ("JN10_25","073_10_25","JHN","10","25","25","Ma te haka tau atu a Jesus, “Na hogahoga e Au kia te koutou, ka manga he'e too kinai koutou. Na hai 'anga haka ohokia noko hai e Au i te ingoa o Tamau, manga haka 'agi ai ia te Au. ");
INSERT INTO mnv_vpl VALUES ("JN10_26","073_10_26","JHN","10","26","26","Ka manga he'e too kinai koutou, iteme'agaa koutou e he'e aku sipisipi. ");
INSERT INTO mnv_vpl VALUES ("JN10_27","073_10_27","JHN","10","27","27","Aku sipisipi e haka gongo ki toku ge'o, kae na'a e Au ia te kigatou o tata'o tu'a kigatou ia te Au. ");
INSERT INTO mnv_vpl VALUES ("JN10_28","073_10_28","JHN","10","28","28","E haiga'a e Au te ma'ugi noho goa kia te kigatou, ko kigatou kago he'e mamate, e si'ai he pegea ke go ha'ao ia te kigatou i oku gima. ");
INSERT INTO mnv_vpl VALUES ("JN10_29","073_10_29","JHN","10","29","29","Ko Tamau noko haiga'a ia te kigatou kia te Au, ko Ia e hu'ai hua'eha o sigi i ba'i pegea. Kago si'ai he pegea ha'ao ia te kigatou i na gima o Tamau. ");
INSERT INTO mnv_vpl VALUES ("JN10_30","073_10_30","JHN","10","30","30","Ko Au ma Tamau te launatasi.” ");
INSERT INTO mnv_vpl VALUES ("JN10_31","073_10_31","JHN","10","31","31","Na Jew na tibu hatu giu, ke taa hatu ai ia te Ia, ");
INSERT INTO mnv_vpl VALUES ("JN10_32","073_10_32","JHN","10","32","32","ka na hai atu a Jesus kia te kigatou, “Kua haka 'agi e Au kia te koutou na hu'ai hai 'anga haka ohokia mai a Tamau. Ka tehea te hai 'anga i na me'a nei e hai ke 'aumahu ai e koutou ia te Au?” ");
INSERT INTO mnv_vpl VALUES ("JN10_33","073_10_33","JHN","10","33","33","Ma te haka tau na Jew o hai atu, “E he'e hai kimatou 'aumahu 'ia ia te Koe i na hai 'anga gaoi, ka tau igho 'anga, iteme'agaa ko Koe manga te pegea, kae hai mai Koe, ko Koe ko te 'Aitu.” ");
INSERT INTO mnv_vpl VALUES ("JN10_34","073_10_34","JHN","10","34","34","Ko Jesus na haka tau kia te kigatou o hai atu, “ 'Ai noko he'e kanukanu ki autou tagangonga, noko hai mai a te 'Aitu, ‘Koutou na ngasuenga’? ");
INSERT INTO mnv_vpl VALUES ("JN10_35","073_10_35","JHN","10","35","35","Nimaa mate e te 'Aitu na ngasuenga na pegea noko haiga'a kinai ana haka hegeunga, o he'e hai songo na Kanukanu Tapu, ");
INSERT INTO mnv_vpl VALUES ("JN10_36","073_10_36","JHN","10","36","36","ka 'eaa te pegea noko tuku babae e te 'Aitu mo'ona o haka to'o mai ki gago nei? 'Eaa e huhu ai koutou kia te Au i te igho, e munange kua hai atu Au, ‘Ko Au te Hosa o te 'Aitu?’ ");
INSERT INTO mnv_vpl VALUES ("JN10_37","073_10_37","JHN","10","37","37","Ko Au poi he'e hai e Au na hekau a Tamau, noka tautou too kia te Au. ");
INSERT INTO mnv_vpl VALUES ("JN10_38","073_10_38","JHN","10","38","38","Ka nimaa hai e Au na hekau, masi'igoa koutou e he'e too kia te Au, ka manga too atu ki aku hekau, ka ke na'a ai e koutou ma te 'igohia, ko Tamau manga i goto ia te Au, ka ko Au manga ia Tamau.” ");
INSERT INTO mnv_vpl VALUES ("JN10_39","073_10_39","JHN","10","39","39","Ko kigatou na hai lobo ma'u ke he 'osohi kia Jesus, ka ko Ia na manga soga ia te kigatou o he'e he 'osohi kia te Ia. ");
INSERT INTO mnv_vpl VALUES ("JN10_40","073_10_40","JHN","10","40","40","Ko Jesus na hoki ki tegaa pa'asi i Jordan, o manga noho i te kunga noko mataa haa gogomi pegea ai a John. ");
INSERT INTO mnv_vpl VALUES ("JN10_41","073_10_41","JHN","10","41","41","Noko 'eha pegea boomai kia Jesus. Ko kigatou noko hai ake, “Masi'igoa ko John noko he'e hai ni hai 'anga haka ohokia, ka ko ba'i hai 'anga noko gea ai i te tangata nei noko maa'ogi.” ");
INSERT INTO mnv_vpl VALUES ("JN10_42","073_10_42","JHN","10","42","42","Na 'eha pegea i te kunga nei na too kia Jesus. ");
INSERT INTO mnv_vpl VALUES ("JN11_1","073_11_1","JHN","11","1","1","Noko iai te tangata tena ingoa ko Lazarus noko masaki. Koia te tangata mai Bethany, te manaha o Mary ma tena ta'okete ia Martha. ");
INSERT INTO mnv_vpl VALUES ("JN11_2","073_11_2","JHN","11","2","2","Ko Mary nei, (te noko masaki a tena tunga'ane ia Lazarus), te pegea e tasi noko gigingi eia te bai tutuu gaoi ki na tapungao o te Hakahua, kae sogosogo ma'u eia i ona gau 'ugu. ");
INSERT INTO mnv_vpl VALUES ("JN11_3","073_11_3","JHN","11","3","3","Ko Mary ma tena ta'okete noko haka to'o te gongo kia Jesus, o hai atu, “Hakahua, te tangata e ma'ine kinai Koe e masaki.” ");
INSERT INTO mnv_vpl VALUES ("JN11_4","073_11_4","JHN","11","4","4","Te 'aso na gongo ai a Jesus, ko Ia noko hai atu, “Te 'otinga o te masaki nei e he'e hai ke mate ai, ka manga hai ke haka mamagunga ai ia te 'Aitu. Ma te ke haka mamagunga 'ia ma'u ai te Hosa o te 'Aitu.” ");
INSERT INTO mnv_vpl VALUES ("JN11_5","073_11_5","JHN","11","5","5","Ko Jesus noko ma'ine kia Martha, ma tena taina, ma Lazarus. ");
INSERT INTO mnv_vpl VALUES ("JN11_6","073_11_6","JHN","11","6","6","Ka te 'aso na gongo ai ko Lazarus e masaki, ko Ia noko manga noho i te kunga noko manga iai i te toka gua 'ao. ");
INSERT INTO mnv_vpl VALUES ("JN11_7","073_11_7","JHN","11","7","7","'Io mugi Ia o hai atu ki ona pegea haka ako, “Kitatou giu ki Judea.” ");
INSERT INTO mnv_vpl VALUES ("JN11_8","073_11_8","JHN","11","8","8","Ko kigatou noko hai atu, “Ako, te 'aso kua sigi atu, na Jew noko hai lobo kigatou taa 'ia ia te Koe i ni hatu. 'Ai ko Koe e hai ke hoki ki te kungaa?” ");
INSERT INTO mnv_vpl VALUES ("JN11_9","073_11_9","JHN","11","9","9","Ma te hakatau a Jesus o hai atu, “Ko ba'i 'ao manga katoa tuma'a e gua o na mi'i gholoba. Te tangata sehu i te 'ao, ka he'e tukia, iteme'agaa koia manga ina i te maagama 'anga o gago nei. ");
INSERT INTO mnv_vpl VALUES ("JN11_10","073_11_10","JHN","11","10","10","Ka te sehu 'anga i te poo, te ka tukia ai, iteme'agaa e he'e maagama.” ");
INSERT INTO mnv_vpl VALUES ("JN11_11","073_11_11","JHN","11","11","11","Ko Jesus na 'oti i te konei ana gea, kae hai atu ma'u, “Te hemasi'inga atatou ia Lazarus kua moe, kae hano kau baa 'aga 'ia.” ");
INSERT INTO mnv_vpl VALUES ("JN11_12","073_11_12","JHN","11","12","12","Ka ona pegea haka ako noko haka tau atu, “Hakahua, koia poi manga moe, koia kago gaoi.” ");
INSERT INTO mnv_vpl VALUES ("JN11_13","073_11_13","JHN","11","13","13","Ko Jesus noko gaataki e Ia ko Lazarus kua mate, ka ona pegea haka ako noko tegeu'a ake ko Ia manga gea ki na momoe 'anga manga hai. ");
INSERT INTO mnv_vpl VALUES ("JN11_14","073_11_14","JHN","11","14","14","'Io hogahoga haka tinogaoi e Jesus kia te kigatou, “Ko Lazarus kua mate. ");
INSERT INTO mnv_vpl VALUES ("JN11_15","073_11_15","JHN","11","15","15","Ka te ghaghinga ia te koutou, ko Au e maagaohie ia te Au noko he'e i te kungaa, ka ke too ai koutou kia te Au. Ka kitatou boo kia te ia.” ");
INSERT INTO mnv_vpl VALUES ("JN11_16","073_11_16","JHN","11","16","16","Ma te hai atu a Thomas, noko mate te Maasanga, ki gaa pegea haka ako, “Kitatou boo ma'u, kitatou mamate haka pigi kia te Ia.” ");
INSERT INTO mnv_vpl VALUES ("JN11_17","073_11_17","JHN","11","17","17","Nimaa hetae atu a Jesus o na'a, ko Lazarus kua tuku ki te takotonga o toka haa o na 'ao. ");
INSERT INTO mnv_vpl VALUES ("JN11_18","073_11_18","JHN","11","18","18","Ko Bethany noko hitaiaki ki Jerusalem. ");
INSERT INTO mnv_vpl VALUES ("JN11_19","073_11_19","JHN","11","19","19","Noko 'api i na Jew noko boomai ke hiina'i kia Martha ma Mary, ke baa kogikogi ia te kigaaua i te mate 'anga a tegaaua tunga'ane. ");
INSERT INTO mnv_vpl VALUES ("JN11_20","073_11_20","JHN","11","20","20","Te 'aso na haka gongo ai a Martha ko Jesus kua a'u, koia na hano ke ina kia te Ia, ka ko Mary noko manga noho i te hage. ");
INSERT INTO mnv_vpl VALUES ("JN11_21","073_11_21","JHN","11","21","21","Ko Martha noko hai atu kia Jesus, “Hakahua, ko Koe poi noko noho i tenei, toku tunga'ane kua he'e mate. ");
INSERT INTO mnv_vpl VALUES ("JN11_22","073_11_22","JHN","11","22","22","Kae na'a eau, he'e po te gholoba nei ko te 'Aitu e 'aonga te haiga'a kia te Koe nia ka haka ene ai Koe.” ");
INSERT INTO mnv_vpl VALUES ("JN11_23","073_11_23","JHN","11","23","23","Ma te hai atu a Jesus kia Martha, “Ko tou tunga'ane e hai ke ma'ugi hoki.” ");
INSERT INTO mnv_vpl VALUES ("JN11_24","073_11_24","JHN","11","24","24","Ma te haka tau atu a Martha, “E na'a eau koia kago ma'ugi hoki i te maa'ugi giu 'anga i te 'ao taha'aki.” ");
INSERT INTO mnv_vpl VALUES ("JN11_25","073_11_25","JHN","11","25","25","Ka na hai atu a Jesus kia Martha, “Ko Au te maa'ugi giu 'anga, ma te ma'ugi. Koai e too kia te Au, si'igoa koia e mate, kae hai ke go ma'ugi. ");
INSERT INTO mnv_vpl VALUES ("JN11_26","073_11_26","JHN","11","26","26","Ka koai manga ma'ugi kae too kia te Au, koia kago he'e pau o mate. Ko koe e too ki te hai 'anga nei?” ");
INSERT INTO mnv_vpl VALUES ("JN11_27","073_11_27","JHN","11","27","27","Ma te haka tau a Martha o hai atu, “ 'Oo Hakahua, koau kua too kia te Koe, te 'Agiki Taga'ia, te Hosa o te 'Aitu. Tenei te Hosa o te 'Aitu noko hai ke go a'u ki gago nei.” ");
INSERT INTO mnv_vpl VALUES ("JN11_28","073_11_28","JHN","11","28","28","Nimaa 'oti i te konei na gea a Martha, kae hoki o manga gea haka 'aonga kia tona taina ia Mary o hai atu, “Te Ako kua i tenei, kae ma haka anu ia te koe.” ");
INSERT INTO mnv_vpl VALUES ("JN11_29","073_11_29","JHN","11","29","29","Te haka gongo 'anga kinai a Mary, koia na tu'u ghali o hano kia Jesus. ");
INSERT INTO mnv_vpl VALUES ("JN11_30","073_11_30","JHN","11","30","30","Te 'aso na, ko Jesus noko manga koi he'e hano ki goto i te manaha, ka noko manga noho i te kunga noko sasa'o ai a Martha kia te Ia. ");
INSERT INTO mnv_vpl VALUES ("JN11_31","073_11_31","JHN","11","31","31","Te gholoba na hiina'i ai na Jew noko haka pata kia Mary o manga baa kogikogi, ia Mary e tu'u o ghali o hano ki haho, ko kigatou na tata'o ia te ia, i te noko tegeu'a ake kigatou koia e hano ki te takotonga ke noko magepe ai. ");
INSERT INTO mnv_vpl VALUES ("JN11_32","073_11_32","JHN","11","32","32","Te 'aso na hetae ai a Mary ki te kunga noko iai a Jesus o ina kia te Ia, koia na too ki na ba'e o te 'Aitu, kae hai atu, “Hakahua, ko Koe poi noko noho i tenei, toku tunga'ane kua he'e mate.” ");
INSERT INTO mnv_vpl VALUES ("JN11_33","073_11_33","JHN","11","33","33","Ko Jesus na ina kia Mary noko tangi, ma na Jew noko tata'o mai ai na tatangi ma'u. Ko Jesus na hu'ai 'agoha o haka gongo songo ai. ");
INSERT INTO mnv_vpl VALUES ("JN11_34","073_11_34","JHN","11","34","34","Ma te haka anu a Jesus o hai atu, “Tehea te kunga e tanu ai e koutou ia te ia?” Ko kigatou na haka tau kinai o hai atu, “Hakahua, a'u o ina kinai.” ");
INSERT INTO mnv_vpl VALUES ("JN11_35","073_11_35","JHN","11","35","35","Ko Jesus na tangi. ");
INSERT INTO mnv_vpl VALUES ("JN11_36","073_11_36","JHN","11","36","36","Ma te hai atu na Jew, “Hiina'i atu ki tona ma'ine kia te ia.” ");
INSERT INTO mnv_vpl VALUES ("JN11_37","073_11_37","JHN","11","37","37","Ka noko iai kogaa i na Jew noko hai ake, “Ko Ia te noko lugaluga e Ia na mata o te tangata kibi, 'ai e he'e 'aonga te pipiki e Ia ia Lazarus ke noka te mate?” ");
INSERT INTO mnv_vpl VALUES ("JN11_38","073_11_38","JHN","11","38","38","Ko Jesus na hu'ai 'agoha hoki, ma te hinatu ki te takotonga, te 'ana, ka noko hugi te hu'ai hatu o titingi ai tena mata. ");
INSERT INTO mnv_vpl VALUES ("JN11_39","073_11_39","JHN","11","39","39","Ma te hai atu a Jesus, “ 'Aka 'aatea atu te hatu na.” Ka ko Martha te tuhahine o te tangata kua mate, noko hai atu, “Hakahua, te 'aso nei kua tutuu maase'i ai, iteme'agaa kua poo haa te tanu.” ");
INSERT INTO mnv_vpl VALUES ("JN11_40","073_11_40","JHN","11","40","40","Ma te hai atu a Jesus kia Martha, “ 'Ai noko he'e hogahoga e Au kia te koe, nimaa too koe kia te Au, ko koe ka ina ki te mamagunga o te 'Aitu?” ");
INSERT INTO mnv_vpl VALUES ("JN11_41","073_11_41","JHN","11","41","41","Ma te 'aka 'aatea e kigatou te hatu, kae ina haka tu'u a Jesus o hai ake, “Tamau, ko Au e 'aue kia te Koe ia te Koe manga haka gongo kia te Au. ");
INSERT INTO mnv_vpl VALUES ("JN11_42","073_11_42","JHN","11","42","42","E na'a e Au ko Koe manga haka gongo kia te Au i ba'i 'aso, kae konei aku gea i te ghaghinga i na pegea e noho 'aki nei, kigatou na'a 'ia ko Au noko haka to'o mai e Koe.” ");
INSERT INTO mnv_vpl VALUES ("JN11_43","073_11_43","JHN","11","43","43","Te gholoba na konei na gea ai a Jesus, ko Ia na ngege i te hu'ai ge'o, “Lazarus, sopo mai!” ");
INSERT INTO mnv_vpl VALUES ("JN11_44","073_11_44","JHN","11","44","44","Te tangata noko mate na 'aga mai, ka na gima ma na ba'e noko manga koi gii i na pa'asi laoa, noko manga koi pegu ma'u na mata i te laoa. Ma te kaunaki e Jesus ia te kigatou, o hai atu, “Huhuke atu na laoa, kae tuku ke hano.” ");
INSERT INTO mnv_vpl VALUES ("JN11_45","073_11_45","JHN","11","45","45","Noko 'eha na Jew kigatou noko boomai kia Mary, na hiina'i ki nia noko hai e Jesus, ko kigatou na too ai kia te Ia. ");
INSERT INTO mnv_vpl VALUES ("JN11_46","073_11_46","JHN","11","46","46","Ka noko iai kogaa ia te kigatou noko giu ki na Pharisee o 'atigongo kia te kigatou i nia kua hai e Jesus. ");
INSERT INTO mnv_vpl VALUES ("JN11_47","073_11_47","JHN","11","47","47","Ma te he potaki na Pharisee ma na hakahua o na priest o hai ake, “Niaa e hai kitatou hai 'ia? Iteme'agaa e 'eha hai 'anga haka ohokia kua hai e te tangata nei. ");
INSERT INTO mnv_vpl VALUES ("JN11_48","073_11_48","JHN","11","48","48","Nimaa tuku e kitatou ia te Ia ke noko konei ana hai hano, ko ba'i pegea kago too kia te Ia, ma te go boomai na pegea o Rome o ha'ao te manaha otatou nei ma otatou pegea ma'u.” ");
INSERT INTO mnv_vpl VALUES ("JN11_49","073_11_49","JHN","11","49","49","Noko iai te launatasi ia te kigatou, tena ingoa ko Caiaphas, te hakahua o na priest i te ghapu na, koia noko hai atu, “ 'Ai e he'e mi'i na'a e koutou he hai 'anga. ");
INSERT INTO mnv_vpl VALUES ("JN11_50","073_11_50","JHN","11","50","50","'Ai e he'e na'a e koutou, e gaoi i te tuku e koutou he launatasi tangata ke mate kia pegea, o sigi i te haka masogo ba'i pegea ngatahi?” ");
INSERT INTO mnv_vpl VALUES ("JN11_51","073_11_51","JHN","11","51","51","Ko Caiaphas noko he'e manga gau hua o konei ana gea, ka koia te hakahua o na priest i te ghapu na, koia noko taga gongo ia Jesus e hai ke go mate ki na pegea o Jew. ");
INSERT INTO mnv_vpl VALUES ("JN11_52","073_11_52","JHN","11","52","52","E he'e manga ko Jew soko, kae hai ke go haka tahi 'aki e Ia na tama giki a te 'Aitu na maseuseu. ");
INSERT INTO mnv_vpl VALUES ("JN11_53","073_11_53","JHN","11","53","53","Ma te haka tu'u i te 'ao na o hano, na Jew na haka pau kigatou go taa 'ia ia Jesus. ");
INSERT INTO mnv_vpl VALUES ("JN11_54","073_11_54","JHN","11","54","54","Ma te he'e sehu haka 'agi'agi ai a Jesus i Judea. Ko Ia na hano ki te kunga e hitaiaki ki te tugatea, te manaha noko mate ko Ephraim. Ko Ia noko manga noho haka pata ai ki ona pegea haka ako. ");
INSERT INTO mnv_vpl VALUES ("JN11_55","073_11_55","JHN","11","55","55","Te haka tahinga o Jew i te Passover na hitaiaki, noko 'eha pegea na boomai i ba'i kakai 'anga ki Jerusalem, ke mataa hai ia te kigatou ke ma'a, 'io mugi mai te 'aso o te haka tahinga. ");
INSERT INTO mnv_vpl VALUES ("JN11_56","073_11_56","JHN","11","56","56","Ko kigatou noko manga sasaga ia Jesus. Te 'aso noko tutu'u ai kigatou i te Hage Tapu, ko kigatou noko manga haka anuanu 'aki, “Kohea autou tegeu'a? 'Ai ko Jesus ka he'e a'u ki te haka tahinga nei?” ");
INSERT INTO mnv_vpl VALUES ("JN11_57","073_11_57","JHN","11","57","57","Ka na hakahua o na priest ma na Pharisee noko hai tegatou hu'ai gegea 'anga: Nimaa na'a e he pegea te kunga e iai a Jesus, ke hogahoga eia, ka kigatou he 'osohi kia te Ia. ");
INSERT INTO mnv_vpl VALUES ("JN12_1","073_12_1","JHN","12","1","1","Te toka ono 'ao noko toe ka ke hetae ai te 'ao o te haka tahinga o te Passover, ko Jesus noko hetae mai ki Bethany, te manaha noko kakai ai a Lazarus na haka ma'ugi e Ia i tena mate 'anga. ");
INSERT INTO mnv_vpl VALUES ("JN12_2","073_12_2","JHN","12","2","2","Na gosigosi e kigatou te kainga kia te Ia. Ko Martha noko 'aabaki i te hai utunga 'anga, ka ko Lazarus noko manga haka pata ki na pegea noko noho 'aki haka pigi kia Jesus. ");
INSERT INTO mnv_vpl VALUES ("JN12_3","073_12_3","JHN","12","3","3","Ma te to'o mai e Mary te bai hu'ai tutuu gaoi noko gosigosi hage tasi i na nadi, noko hu'ai 'eha ona mane. Ka na gigingi e Mary ki na ba'e o Jesus, kae sogosogo eia i ona gau 'ugu. Te hage na gemosi ai te tutuu gaoi 'anga o te bai. ");
INSERT INTO mnv_vpl VALUES ("JN12_4","073_12_4","JHN","12","4","4","Te launatasi i na pegea haka ako o Jesus, tena ingoa ko Judas Iscariot, te pegea noko hai ke go haka soko ia te Ia, noko hai atu, ");
INSERT INTO mnv_vpl VALUES ("JN12_5","073_12_5","JHN","12","5","5","“Tehea te hai 'anga e he'e tau'i ai te bai na, ke hai ai ni mane hu'ai 'eha, ke haiga'a ki na pegea lae?” ");
INSERT INTO mnv_vpl VALUES ("JN12_6","073_12_6","JHN","12","6","6","Ko Judas noko he'e konei ana gea i te 'agoha ki na pegea lae, ka naato'o ia te ia te pegea kaia'a noko he to'o 'aki eia te kete mane o manga sa'ohie i na mane. ");
INSERT INTO mnv_vpl VALUES ("JN12_7","073_12_7","JHN","12","7","7","Ka ko Jesus na hai atu, “Saunoa atu ki te hahine na! Tuku atu ke hai nia e hai eia ki te 'ao kago tanu ai ia te Au. ");
INSERT INTO mnv_vpl VALUES ("JN12_8","073_12_8","JHN","12","8","8","Koutou ka noko haka pata 'aki ma na pegea lae, ka ko Au ka he'e noko haka pata kia te koutou.” ");
INSERT INTO mnv_vpl VALUES ("JN12_9","073_12_9","JHN","12","9","9","Te 'apitanga o Jew na gongo ia Jesus manga noho i Bethany, ko kigatou na boo kinai. Ko kigatou noko he'e manga boo kia Jesus, ka noko boo ke hiina'i ma'u kia Lazarus na haka ma'ugi e Jesus i te mate 'anga. ");
INSERT INTO mnv_vpl VALUES ("JN12_10","073_12_10","JHN","12","10","10","Ma te puge ai na hakahua o na Priest, ke taa ma'u ia Lazarus. ");
INSERT INTO mnv_vpl VALUES ("JN12_11","073_12_11","JHN","12","11","11","Iteme'agaa ko Lazarus te kua hai eia te 'apitanga o Jew o ti'aki ogatou hutiaki, kae too kia Jesus. ");
INSERT INTO mnv_vpl VALUES ("JN12_12","073_12_12","JHN","12","12","12","Nimaa i tegaa 'ao, te 'apitanga na boomai ki te haka tahinga o te Passover, ko kigatou na haka gongo ko Jesus e a'u ki Jerusalem. ");
INSERT INTO mnv_vpl VALUES ("JN12_13","073_12_13","JHN","12","13","13","Noko to'o e kigatou na gaukei e noho pena paipai o boo ke sasa'o kia Jesus. Ko kigatou noko ngengege o hai ake, “Haka e'eha ia te 'Aitu! Haka gaoi ki te pegea e a'u i te ingoa o te 'Aitu! Haka gaoi ki te Hakahua o Israel!” ");
INSERT INTO mnv_vpl VALUES ("JN12_14","073_12_14","JHN","12","14","14","Ko Jesus na kite e Ia te mi'i donki o sopo kinai o papata ki na Kanukanu Tapu, noko hai ake, ");
INSERT INTO mnv_vpl VALUES ("JN12_15","073_12_15","JHN","12","15","15","“Noka tautou matataku na pegea o Jerusalem. Hiina'i atu, tenaa te hakahua o 'outou te a'u, e eke i te punua donki.” ");
INSERT INTO mnv_vpl VALUES ("JN12_16","073_12_16","JHN","12","16","16","Ona pegea haka ako na mataa he'e na'a e kigatou te hai 'anga nei i te 'aso na. Ka te 'aso na ma'ugi hoki ai a Jesus ki tena mamagunga, ma te maanatu ai kigatou, 'ai na Kanukanu Tapu noko gea i na hai 'anga nei ia Jesus, ka na hai 'anga nei kua hai kia te Ia. ");
INSERT INTO mnv_vpl VALUES ("JN12_17","073_12_17","JHN","12","17","17","Te 'apitanga noko noho 'aki haka pata kia Jesus i te 'aso noko ngege ai ia Lazarus o sopo mai i te takotonga o haka ma'ugi ia te ia i te mate 'anga, noko manga 'atigongo i te hai 'anga nei. ");
INSERT INTO mnv_vpl VALUES ("JN12_18","073_12_18","JHN","12","18","18","Tegaa te hai 'anga na boo ai te 'apitanga ke sasa'o kia te Ia, iteme'agaa ko kigatou na haka gongo i te noko hai e Ia te hai 'anga haka ohokia nei. ");
INSERT INTO mnv_vpl VALUES ("JN12_19","073_12_19","JHN","12","19","19","Na Pharisee na hegeu o hai ake, “Kua kite iho e kitatou, ko kitatou e pau o he'e tau hai 'anga. 'Ai hiina'i atu, ko ba'i pegea kua tata'o tu'a ia te Ia.” ");
INSERT INTO mnv_vpl VALUES ("JN12_20","073_12_20","JHN","12","20","20","Te 'aso na, noko iai na pegea mai Greece, noko uso i na pegea noko boo ke sogi i te haka tahinga. ");
INSERT INTO mnv_vpl VALUES ("JN12_21","073_12_21","JHN","12","21","21","Ko kigatou na boomai kia Philip te pegea mai Bethsaida i Galilee, o haka ene 'aki kinai, “Hakahua, ko kimatou e siahahai kimatou hiina'i kia Jesus.” ");
INSERT INTO mnv_vpl VALUES ("JN12_22","073_12_22","JHN","12","22","22","Ma te hano a Philip o 'atigongo ai kia Andrew, ma te boo kigaaua he 'atigongo 'aki ai kia Jesus. ");
INSERT INTO mnv_vpl VALUES ("JN12_23","073_12_23","JHN","12","23","23","Ma te haka tau a Jesus kia te kigaaua o hai atu, “Kua hetae mai te gholoba ki te Hosa o Pegea ke mamagunga ai. ");
INSERT INTO mnv_vpl VALUES ("JN12_24","073_12_24","JHN","12","24","24","Ko Au e gea maa'ogi kia te kougua: Na hatu witi, manga na hatu me'a. Ka manga te hatu witi kago toiho ki te kege o mate, te kago mugi o hai mo'ona ni hatu o hu'ai 'eha. ");
INSERT INTO mnv_vpl VALUES ("JN12_25","073_12_25","JHN","12","25","25","Te pegea nimaa ma'ine ki te ma'ugi o'ona, kago he'e kite eia te ma'ugi. Ka te pegea e hai ti'aki te ma'ugi o'ona i gago nei, e hai ke go ga'u ai te ma'ugi noho goa. ");
INSERT INTO mnv_vpl VALUES ("JN12_26","073_12_26","JHN","12","26","26","Koai e siahai ke hai hekau kia te Au, koia e hai ke tata'o ia te Au. Tehea te kunga kago noho ai Au, toku guani kago haka pata kia te Au. Ko Tamau kago haka e'eha e Ia te pegea kago hai hekau kia te Au. ");
INSERT INTO mnv_vpl VALUES ("JN12_27","073_12_27","JHN","12","27","27","“Te 'aso nei toku uso e haka gongo songo, kae hai kau kohea aku to'o? 'Ai e hai kau hai atu, ‘Tamau, noka te tuku te gholoba nei ke a'u kia te Au’? Si'ai, tenei te hai 'anga noko a'u ai Au ki te gholoba nei. ");
INSERT INTO mnv_vpl VALUES ("JN12_28","073_12_28","JHN","12","28","28","Tamau, tou ingoa ke mamagunga.” Ma te iho mai te ge'o mai te gangi o gea iho, “Kua haka mamagunga e Au, kae hai kau go haka mamagunga haka hoki 'ia.” ");
INSERT INTO mnv_vpl VALUES ("JN12_29","073_12_29","JHN","12","29","29","Te 'apitanga noko tutu'u i te kungaa, noko haka gongo ki te ge'o, ka noko hai ake na hatutigi, kae hai ake kogaa, te ensel e gea kia te Ia. ");
INSERT INTO mnv_vpl VALUES ("JN12_30","073_12_30","JHN","12","30","30","Ma te hai atu a Jesus kia te kigatou, “Te ge'o nei e he'e a'u kia te Au, kae a'u kia te koutou. ");
INSERT INTO mnv_vpl VALUES ("JN12_31","073_12_31","JHN","12","31","31","Tenei te 'aso e hai ke haka aba ai a gago nei. Te hakahua o gago nei ia Satan e hai ke pagepage. ");
INSERT INTO mnv_vpl VALUES ("JN12_32","073_12_32","JHN","12","32","32","Te 'aso kago tau ai ia te Au ki te kros, e hai kau go tataki mai 'ia ba'i pegea kia te Au.” ");
INSERT INTO mnv_vpl VALUES ("JN12_33","073_12_33","JHN","12","33","33","Ko Jesus noko konei ana gea, ke haka 'agi ai na noho o te mate 'anga e hai ke go mate ai. ");
INSERT INTO mnv_vpl VALUES ("JN12_34","073_12_34","JHN","12","34","34","Te 'apitanga na haka tau o hai atu kinai, “Ko kimatou noko haka gongo ki na tagangonga e hai ake, ‘Te 'Agiki Taga'ia e hai ke go noko ma'ugi ki ba'i 'aso.’ Ka 'eaa e hai mai ai Koe, ‘Te Hosa o Pegea e hai ke go tau ai ki te kros?’ 'Ai koai te Hosa o Pegea?” ");
INSERT INTO mnv_vpl VALUES ("JN12_35","073_12_35","JHN","12","35","35","Ma te haka tau atu a Jesus, “E hai ke manga mi'i taunga gogoa te haka pata te maagama kia te koutou. Noko lango atu i te gholoba koi hai ai e koutou te maagama, ka ke go noka te hetae te poo'uginga kia te koutou, iteme'agaa te pegea sehu i te poo'uginga, ka he'e na'a eia te kunga e hano kinai. ");
INSERT INTO mnv_vpl VALUES ("JN12_36","073_12_36","JHN","12","36","36","Kae too atu ki te maagama i te gholoba koi hai ai e koutou, ka ke hai ni tama giki ma'a te maagama ia te koutou.” Te 'aso na 'oti ai te gea 'anga a Jesus i na hai 'anga nei, ko Ia na hano o noho haka ngigo ia te kigatou. ");
INSERT INTO mnv_vpl VALUES ("JN12_37","073_12_37","JHN","12","37","37","Masi'igoa ko kigatou noko hiina'i ki na hai 'anga haka ohokia noko hai e Jesus, ka ko kigatou noko he'e too kia te Ia. ");
INSERT INTO mnv_vpl VALUES ("JN12_38","073_12_38","JHN","12","38","38","Te hai 'anga nei na haka maa'ogi ai nia noko gea kinai te taauga ia Isaiah: “Hakahua, koai e too ki amatou 'atigongo 'anga? Koai ma'u te kua haka 'agi kinai na taganga o te 'Aitu?” ");
INSERT INTO mnv_vpl VALUES ("JN12_39","073_12_39","JHN","12","39","39","Tenei te hai 'anga na he'e too ai a kigatou, iteme'agaa te taauga ia Isaiah noko konei ana gea i tegaa tasi kunga: ");
INSERT INTO mnv_vpl VALUES ("JN12_40","073_12_40","JHN","12","40","40","“Na hai e Ia ogatou mata o kikibi, ma te hai ogatou uso o mogi, ka kigatou he'e hiina'i ogatou mata, ma te he'e tau naa 'anga i ogatou uso, ma te he'e he keu 'aki giu mai, ka kego haka maa'ugi e Ia ia te kigatou.” ");
INSERT INTO mnv_vpl VALUES ("JN12_41","073_12_41","JHN","12","41","41","Te taauga ia Isaiah noko gea i te hai 'anga nei, iteme'agaa koia na ina ki te mamagunga o Jesus, ma te konei ana gea ai. ");
INSERT INTO mnv_vpl VALUES ("JN12_42","073_12_42","JHN","12","42","42","Masi'igoa na konei na noho, ka kogaa i na mu'a 'aki na too kia Jesus, kae naato'o ko kigatou na Pharisee ko kigatou na he'e gegea haka 'agi'agi ai ite matataku, i te kai paagea i te Hage hai paaunga o Jew, ");
INSERT INTO mnv_vpl VALUES ("JN12_43","073_12_43","JHN","12","43","43","ia te kigatou noko maa'ine ki na haka e'eha 'anga e pegea o sigi i te haka e'eha e te 'Aitu. ");
INSERT INTO mnv_vpl VALUES ("JN12_44","073_12_44","JHN","12","44","44","Ko Jesus na hai atu i te hu'ai ge'o, “Koai e too kia te Au, e he'e manga too kia te Au launatasi, kae too kia te Ia noko haka to'o mai ia te Au. ");
INSERT INTO mnv_vpl VALUES ("JN12_45","073_12_45","JHN","12","45","45","Koai e ina kia te Au, e ina ma'u kia te Ia noko haka to'o mai ia te Au. ");
INSERT INTO mnv_vpl VALUES ("JN12_46","073_12_46","JHN","12","46","46","Ko Au noko a'u ki gago nei, ke noho pe te maagama. Koai e too kia te Au, ka he'e noho i te poo'uginga. ");
INSERT INTO mnv_vpl VALUES ("JN12_47","073_12_47","JHN","12","47","47","“Koai e haka gongo ki aku gea 'anga nei o he'e too kinai, kago he'e haka aba e Au ia te ia. Iteme'agaa ko Au noko he'e a'u kau haka aba 'ia a gago nei, ka noko a'u kau haka ma'ugi 'ia. ");
INSERT INTO mnv_vpl VALUES ("JN12_48","073_12_48","JHN","12","48","48","Koai e he'e tata'o kia te Au, ma te he'e haka gongo ki aku gea 'anga nei, e iai te launatasi e hai ke go haka aba ia te ia: Na haka hegeunga kua 'oti i te gea ai Au, te hai ke go haka aba ia te ia i te 'ao taha'aki. ");
INSERT INTO mnv_vpl VALUES ("JN12_49","073_12_49","JHN","12","49","49","Ko Au e he'e manga gea i aku paaunga, ka ko Tamau noko haka to'o mai ia te Au, te noko haka hegeu kia te Au, i nia e hai kau hai atu ai ma te gea ai. ");
INSERT INTO mnv_vpl VALUES ("JN12_50","073_12_50","JHN","12","50","50","E na'a e Au ana haka hegeunga e hutiaki ki te ma'ugi noho goa. E kogaa na noho, nia e gea ai Au, ko Au manga gea i na hai 'anga haka hegeu ai a Tamau kau gea ai.” ");
INSERT INTO mnv_vpl VALUES ("JN13_1","073_13_1","JHN","13","1","1","Noko mugi mai te 'aso o te haka tahinga o te Passover, ko Jesus noko na'a e Ia kua hetae mai te 'aso o'Ona ke hano ai i gago nei kia te Tamana. Ko Ia noko ma'ine ki ona pegea i gago nei. Ko Ia noko ma'ine kia te kigatou o hano aano hetae ki tena 'otinga. ");
INSERT INTO mnv_vpl VALUES ("JN13_2","073_13_2","JHN","13","2","2","Ko Jesus ma ona pegea haka ako noko manga koi noho 'aki i te kainga i te ahiahi, ko Satan na 'oti i te haka niniko ia Judas Iscariot, te hosa o Simon, ke haka soko ia Jesus. ");
INSERT INTO mnv_vpl VALUES ("JN13_3","073_13_3","JHN","13","3","3","Ko Jesus noko na'a e Ia, ko te Tamana kua 'oti i te tuku e Ia ba'i hai 'anga ki ona taganga, kae na'a ma'u e Ia ko Ia noko a'u mai ia te 'Aitu, kae hai ke hoki kia te 'Aitu; ");
INSERT INTO mnv_vpl VALUES ("JN13_4","073_13_4","JHN","13","4","4","ma te tu'u a Jesus i te kainga o 'ui tona hu'ai ake, kae sa'u mai te taolo o nono'a ki te pagi o 'Ona. ");
INSERT INTO mnv_vpl VALUES ("JN13_5","073_13_5","JHN","13","5","5","Mugi i te hai 'anga nei kae gigingi e Ia te bai ki te besin, o haka tu'u huhu'i ai na tapungao o na pegea haka ako, kae sogosogo i te taolo noko nono'a ki na pagi. ");
INSERT INTO mnv_vpl VALUES ("JN13_6","073_13_6","JHN","13","6","6","Nimaa hinatu a Jesus kia Simon Peter, ma te hai atu a Peter kia te Ia, “Hakahua, 'ai e hai ke huhu'i e Koe oku tapungao?” ");
INSERT INTO mnv_vpl VALUES ("JN13_7","073_13_7","JHN","13","7","7","Ko Jesus noko haka tau kia te ia o hai atu, “E he'e gaataki e koe nia te hai e Au nei, kae hai ke go mugi koe o na'a.” ");
INSERT INTO mnv_vpl VALUES ("JN13_8","073_13_8","JHN","13","8","8","Ma te hai atu a Peter, “Si'ai, ka he'e huhu'i e Koe gu'oku tapungao!” Ma te haka tau atu a Jesus, “Nimaa he'e huhu'i e Au gu'ou tapungao, ko koe he'e te pegea o'Oku.” ");
INSERT INTO mnv_vpl VALUES ("JN13_9","073_13_9","JHN","13","9","9","Ma te haka tau atu a Peter, “Hakahua, noka te manga huhu'i gu'oku tapungao, ka ke huhu'i ma'u gu'oku gima ma toku 'ugu.” ");
INSERT INTO mnv_vpl VALUES ("JN13_10","073_13_10","JHN","13","10","10","Ma te haka tau atu a Jesus, “Te pegea 'oti i te kaukau e hai ke manga huhu'i gua tapungao, ka te tino kaatoa kua ma'a. Ka koutou kua ma'a, kae he'e ko koutou ngatahi.” ");
INSERT INTO mnv_vpl VALUES ("JN13_11","073_13_11","JHN","13","11","11","Noko na'a e Jesus, koai te hai ke haka soko ia te Ia, tena te hai 'anga noko hai atu ai, “Koutou e he'e ma'a ngatahi.” ");
INSERT INTO mnv_vpl VALUES ("JN13_12","073_13_12","JHN","13","12","12","Te 'aso na 'oti i te huhu'i ai e Jesus ogatou tapungao, ko Ia na ake hoki i tena hu'ai ake, o noho hoki ki te kunga noko noho ai, o haka anu atu kia te kigatou, “E gaataki e koutou te hai 'anga e hai e Au kia te koutou nei? ");
INSERT INTO mnv_vpl VALUES ("JN13_13","073_13_13","JHN","13","13","13","Koutou e hai mai, ko Au te Ako ma te Hakahua. E maa'ogi, ko Au e konaa aku noho. ");
INSERT INTO mnv_vpl VALUES ("JN13_14","073_13_14","JHN","13","14","14","Nimaa ko Au te Hakahua o 'outou ma te Ako o 'outou, ka kua huhu'i e Au 'outou tapungao, koutou e hai ke huhu'i ma'u na tapungao ogaa pegea. ");
INSERT INTO mnv_vpl VALUES ("JN13_15","073_13_15","JHN","13","15","15","Kua tuku e Au te haka mee'inga kia te koutou, koutou go hai atu 'ia ke noho ki te hai 'anga e Au kia te koutou. ");
INSERT INTO mnv_vpl VALUES ("JN13_16","073_13_16","JHN","13","16","16","Ko Au e gea maa'ogi kia te koutou, e si'ai he guani ke hua'eha o sigi i mo'ona he hakahua. E si'ai he pegea to'o gongo ke hua'eha o sigi i te pegea e haka to'o ia te ia. ");
INSERT INTO mnv_vpl VALUES ("JN13_17","073_13_17","JHN","13","17","17","Nimaa na'a e koutou na hai 'anga nei, koutou kago ga'u ai e koutou te haka gaoi i te poi hai e koutou. ");
INSERT INTO mnv_vpl VALUES ("JN13_18","073_13_18","JHN","13","18","18","“Ko Au e he'e gea kia te koutou ngatahi, e na'a e Au oku pegea noko ligo, ka te hai 'anga ke haka maa'ogi ai na Kanukanu Tapu, noko hai ake: ‘Te pegea manga kai 'aabaki i aku utunga, e hai ke go taka hugi o haka makau ia te Au.’ ");
INSERT INTO mnv_vpl VALUES ("JN13_19","073_13_19","JHN","13","19","19","E 'atigongo ai Au kia te koutou i te gholoba nei, 'io mugi o hai. Ka nimaa go maa'ogi o hai, ke go too ai koutou kia te Au, na'e ko Au tenei. ");
INSERT INTO mnv_vpl VALUES ("JN13_20","073_13_20","JHN","13","20","20","Ko Au e gea maa'ogi kia te koutou, koai e haka pogo eia he pegea haka to'o e Au, koia e haka pogo ia te Au. Ka koai e haka pogo ia te Au, koia e haka pogo ia te Ia noko haka to'o mai ia te Au.” ");
INSERT INTO mnv_vpl VALUES ("JN13_21","073_13_21","JHN","13","21","21","Mugi i te gea 'anga a Jesus i te hai 'anga nei, ko Ia na hu'ai haka gongo songo, ma te hogahoga haka tinogaoi e Ia, “Ko Au e gea maa'ogi kia te koutou: E iai te launatasi ia te koutou, e hai ke haka soko eia ia te Au.” ");
INSERT INTO mnv_vpl VALUES ("JN13_22","073_13_22","JHN","13","22","22","Ona pegea haka ako na he hiina'i 'aki, iteme'agaa noko he'e na'a po koai te gea kinai. ");
INSERT INTO mnv_vpl VALUES ("JN13_23","073_13_23","JHN","13","23","23","Te launatasi i na pegea haka ako noko ma'ine kinai a Jesus, koia noko noho hitaiaki kia te Ia. ");
INSERT INTO mnv_vpl VALUES ("JN13_24","073_13_24","JHN","13","24","24","Ko Simon Peter noko mou atu ki te pegea haka ako nei o hai atu, “Haka anu atu kia te Ia po koai te gea kinai.” ");
INSERT INTO mnv_vpl VALUES ("JN13_25","073_13_25","JHN","13","25","25","Loghoni atu te pegea hakaako kia Jesus, o haka anu atu kia te Ia, “Koai te gea kinai Koe, Hakahua?” ");
INSERT INTO mnv_vpl VALUES ("JN13_26","073_13_26","JHN","13","26","26","Ma te haka tau kinai a Jesus o hai atu, “Tegaa te pegea te hai kau gogomi 'ia te potu bred nei i te besin o 'abange kinai.” Ma te sa'u e Ia te potu bred o gogomi kae 'abange kia Judas Iscariot, te hosa o Simon. ");
INSERT INTO mnv_vpl VALUES ("JN13_27","073_13_27","JHN","13","27","27","Nimaa sa'u e Judas te potu bred, ko Satan na ghali o hano ki te uso o'ona. Ma te hai atu a Jesus kia Judas, “Niaa te hai ke hai e koe, he ghali taki atu.” ");
INSERT INTO mnv_vpl VALUES ("JN13_28","073_13_28","JHN","13","28","28","Na si'ai he launatasi i na pegea noko i te kainga ke na'a, po 'eaa e konei na gea ai a Jesus kia Judas. ");
INSERT INTO mnv_vpl VALUES ("JN13_29","073_13_29","JHN","13","29","29","Ko Judas noko ge'o eia te kete mane, tenaa te hai 'anga noko iai kogaa i na pegea haka ako na tegeu'a ake, ko Jesus e gea kia Judas ke hano o tau'i mai nia e sanga songo ai kigatou i te kainga, po noko kaunaki ke haiga'a ni mane ki na pegea lae. ");
INSERT INTO mnv_vpl VALUES ("JN13_30","073_13_30","JHN","13","30","30","Nimaa sa'u e Judas te potu bred, ma te ghali o tohu ki haho, ka na poo. ");
INSERT INTO mnv_vpl VALUES ("JN13_31","073_13_31","JHN","13","31","31","Mugi i te hano 'anga a Judas, ko Jesus noko hai atu, “Te gholoba nei te Hosa o Pegea e hai ke mamagunga, ka te mamagunga o te 'Aitu e hai ke agatu'u ia te Ia. ");
INSERT INTO mnv_vpl VALUES ("JN13_32","073_13_32","JHN","13","32","32","Ko te 'Aitu nimaa mamagunga o agatu'u ia te Ia, ko Ia ka hai te Hosa o mamagunga ia te Ia ma'u, kae hai ke ghali a te 'Aitu o konei na hai kia te Ia. ");
INSERT INTO mnv_vpl VALUES ("JN13_33","073_13_33","JHN","13","33","33","“Aku tama giki, ko Au ka he'e noho goa taku haka pata kia te koutou. Koutou kago sasaga ia te Au, kae hai kau gea kia te koutou i nia na gea ai Au ki na Jew, koutou kago he'e boo ange ki te kunga e hano kinai Au. ");
INSERT INTO mnv_vpl VALUES ("JN13_34","073_13_34","JHN","13","34","34","“Te tagangonga ho'ou e gea ai Au kia te koutou: He ma'ine 'aki atu. Ke noho pe aku ma'ine 'anga kia te koutou, ka koutou he ma'ine 'aki atu ma'u. ");
INSERT INTO mnv_vpl VALUES ("JN13_35","073_13_35","JHN","13","35","35","Koutou nimaa he ma'ine 'aki, kago na'a ai e ba'i pegea, koutou oku pegea haka ako.” ");
INSERT INTO mnv_vpl VALUES ("JN13_36","073_13_36","JHN","13","36","36","Ko Simon Peter noko haka anu kia te Ia o hai atu, “Hakahua, ko Koe e hano ki hea?” Ma te haka tau atu a Jesus, “Ko koe ka he'e tata'o ki te kunga e hano kinai Au, kae hai ke go mugi koe o tata'o ange ia te Au.” ");
INSERT INTO mnv_vpl VALUES ("JN13_37","073_13_37","JHN","13","37","37","Ko Peter noko haka anu atu, “Hakahua, 'eaa e he'e tata'o ai au ia te Koe i te 'aso nei? Koau e ngaague kau mate haka pigi kia te Koe.” ");
INSERT INTO mnv_vpl VALUES ("JN13_38","073_13_38","JHN","13","38","38","Ma te haka tau kinai a Jesus o hai atu, “ 'Ai ko koe e ngaague maa'ogi ke mate haka pigi kia te Au? Ko Au e gea maa'ogi kia te koe: 'Io mugi te paolo o tangi, e hai ke go mataa gea haka togu koe o haka si'ai ia te Au. ");
INSERT INTO mnv_vpl VALUES ("JN14_1","073_14_1","JHN","14","1","1","“Noka te tuku outou uso ke mou tegeu'a. Koutou too atu kia te 'Aitu, ma te too ma'u kia te Au. ");
INSERT INTO mnv_vpl VALUES ("JN14_2","073_14_2","JHN","14","2","2","Ko goto i te hage o Tamau e 'eha ai kunga kakai, ka nimaa he'e konei na noho, 'ai ko Au ka he'e hai atu kia te koutou. E hano kau ngaague 'ia he kunga kia te koutou. ");
INSERT INTO mnv_vpl VALUES ("JN14_3","073_14_3","JHN","14","3","3","Ka nimaa hano Au o ngaague he kunga kia te koutou, e hai kau go hokimai o kakabe ia te koutou ke haka pata kia te Au koutou go noho 'aki ma'u i te kunga e noho ai Au. ");
INSERT INTO mnv_vpl VALUES ("JN14_4","073_14_4","JHN","14","4","4","Kua na'a e koutou te aga ki te kunga e hano kinai Au.” ");
INSERT INTO mnv_vpl VALUES ("JN14_5","073_14_5","JHN","14","5","5","Ma te hai atu a Thomas kia Jesus, “Hakahua, e he'e na'a e kimatou te kunga e hano kinai Koe, kae hai kimatou kohea na na'a 'ia te agaa?” ");
INSERT INTO mnv_vpl VALUES ("JN14_6","073_14_6","JHN","14","6","6","Ma te haka tau a Jesus o hai atu, “Tenei Au te aga, ma te maa'ogi, ma te ma'ugi. E si'ai he pegea ke manga hano kia Tamau, ka manga na pegea e agatu'u ia te Au. ");
INSERT INTO mnv_vpl VALUES ("JN14_7","073_14_7","JHN","14","7","7","Nimaa na'a gaoi e koutou ia te Au, ka na'a ma'u e koutou ia Tamau, ma te hiina'i koutou kia te Ia.” ");
INSERT INTO mnv_vpl VALUES ("JN14_8","073_14_8","JHN","14","8","8","Ma te hai atu a Philip, “Hakahua, haka 'agi mai ia te Tamau kia te kimatou, manga tenaa te siahai amatou.” ");
INSERT INTO mnv_vpl VALUES ("JN14_9","073_14_9","JHN","14","9","9","Ma te haka tau kinai a Jesus o hai atu, “Tasi aa 'aso haka pata ai Au kia te koutou? 'Ai koi he'e na'a e koe ia te Au Philip? Koai e ina kia te Au e ina kia Tamau, ka 'eaa e hai mai ai koe, haka 'agi mai kia te kimatou ia te Tamau? ");
INSERT INTO mnv_vpl VALUES ("JN14_10","073_14_10","JHN","14","10","10","'Ai ko koe e he'e too kinai, ko Au manga i goto ia Tamau, ka ko Tamau manga i goto ia te Au? Na haka hegeunga e gea ai Au kia te koutou e he'e aku haka hegeunga. Ka ko Tamau e noho i goto ia te Au, o manga hai ana hekau. ");
INSERT INTO mnv_vpl VALUES ("JN14_11","073_14_11","JHN","14","11","11","Too mai kia te Au, i taku hai atu 'anga: Ko Au manga i goto ia Tamau ka ko Tamau manga i goto ia te Au. Nimaa si'ai, too mai kia te Au i na hekau manga hai e Au. ");
INSERT INTO mnv_vpl VALUES ("JN14_12","073_14_12","JHN","14","12","12","Ko Au e gea maa'ogi kia te koutou: Koai e too kia te Au, kago hai eia na hekau manga hai e Au. Kago hai ma'u eia ni hu'ai hai 'anga o sigi i na hai 'anga nei, iteme'agaa ko Au e hano kia Tamau. ");
INSERT INTO mnv_vpl VALUES ("JN14_13","073_14_13","JHN","14","13","13","E hai kau go noko hai 'ia nia kago noko haka ene 'aki ai koutou i toku ingoa, ka ke haka 'agi ai e te Hosa te mamagunga o te Tamana. ");
INSERT INTO mnv_vpl VALUES ("JN14_14","073_14_14","JHN","14","14","14","Koutou nimaa go haka ene 'aki kia te Au ini hai 'anga i toku ingoa, e hai kau go noko hai 'ia. ");
INSERT INTO mnv_vpl VALUES ("JN14_15","073_14_15","JHN","14","15","15","“Koutou nimaa ma'ine kia te Au, koutou e hai ke mangangao ki aku haka hegeunga nei. ");
INSERT INTO mnv_vpl VALUES ("JN14_16","073_14_16","JHN","14","16","16","Ka ko Au e hai kau go haka ene kia Tamau, ke go haiga'a e Ia kia te koutou tegaa ia 'aabaki, e hai ke go noho haka pata kia te koutou i ba'i 'aso. ");
INSERT INTO mnv_vpl VALUES ("JN14_17","073_14_17","JHN","14","17","17","Ko Ia te Spirit Tapu o te maa'ogi, kago he'e ga'u e ba'i pegea o gago nei, iteme'agaa kago he'e hiina'i kinai, ma te he'e na'a e kigatou te Spirit Tapu, kae hai ke go manga na'a e koutou, iteme'agaa e hai ke go haka pata kia te koutou, ma te noho i outou uso. ");
INSERT INTO mnv_vpl VALUES ("JN14_18","073_14_18","JHN","14","18","18","Ko Au kago he'e tuku e Au ia te koutou ke noho pena tama giki he'e tau hai maatu'a, kae hai kau go hokimai kia te koutou. ");
INSERT INTO mnv_vpl VALUES ("JN14_19","073_14_19","JHN","14","19","19","Ka mi'i taunga gogoa kae he'e hiina'i na pegea o gago nei kia te Au, kae koutou kago noko hiina'i kia te Au. Iteme'agaa ko Au manga ma'ugi, koutou kago noko maa'ugi ma'u. ");
INSERT INTO mnv_vpl VALUES ("JN14_20","073_14_20","JHN","14","20","20","Nimaa go hetae mai te 'ao na, e hai ke go na'a e koutou, ko Au e i-goto ia Tamau, kae noho 'aki koutou ia te Au, ka ko Au manga i goto ia te koutou. ");
INSERT INTO mnv_vpl VALUES ("JN14_21","073_14_21","JHN","14","21","21","Koai e pipiki aku haka hegeunga nei, ma te maangao kinai, tenaa ia e ma'ine kia te Au. Koai e ma'ine kia te Au, e hai ke ma'ine kinai a Tamau, e hai ma'u kaugo ma'ine kia te ia, ma te go haka 'agi ia te Au kia te ia.” ");
INSERT INTO mnv_vpl VALUES ("JN14_22","073_14_22","JHN","14","22","22","Ma te hai atu a Judas (he'e ko Judas Iscariot), “Hakahua, 'eaa e hai ke go manga haka 'agi ai ia te Koe kia te kimatou, ka he'e haka 'agi ai ki na pegea o gago nei?” ");
INSERT INTO mnv_vpl VALUES ("JN14_23","073_14_23","JHN","14","23","23","Ma te haka tau a Jesus kia te ia o hai atu, “Nimaa iai he pegea e ma'ine kia te Au, koia e hai ke maangao ki aku akonga. Ko Tamau e hai ke go ma'ine kia te ia. Ko kimaaua ma Tamau e hai kimaaua go boomai o noho 'aki haka pata kia te ia. ");
INSERT INTO mnv_vpl VALUES ("JN14_24","073_14_24","JHN","14","24","24","Koai e he'e ma'ine kia te Au, ka he'e maangao ki aku akonga. Na haka hegeunga e haka gongo kinai koutou nei, e he'e aku haka hegeunga, ka na gea 'anga a Tamau noko haka to'o mai e Ia ia te Au. ");
INSERT INTO mnv_vpl VALUES ("JN14_25","073_14_25","JHN","14","25","25","“Konei na hai 'anga e 'atigongo ai Au kia te koutou i oku 'aso koi haka pata ai kia te koutou. ");
INSERT INTO mnv_vpl VALUES ("JN14_26","073_14_26","JHN","14","26","26","Ka te 'aabaki i te Spirit Tapu, e hai ke go haka to'o mai e Tamau i toku ingoa, te hai ke go ako ia te koutou i ba'i hai 'anga, ma te go hai ia te koutou ke maanatu giu ki ba'i hai 'anga gea ai Au kia te koutou. ");
INSERT INTO mnv_vpl VALUES ("JN14_27","073_14_27","JHN","14","27","27","Te goto maagie e tuku e Au kia te koutou, toku goto maagie e haiga'a e Au kia te koutou. E he'e noho ki na haiga'a 'anga o gago nei. Noka te tuku outou uso ke mou tegeu'a, ma te noka te matataku. ");
INSERT INTO mnv_vpl VALUES ("JN14_28","073_14_28","JHN","14","28","28","“Koutou kua haka gongo kia te Au kae hai atu, ko Au e hano kae hai kau go hoki mai kia te koutou. Koutou nimaa ma'ine kia te Au, koutou e hai ke magagaohie ia te Au e hano kia Tamau, iteme'agaa ko Tamau e hua'eha o sigi ia te Au. ");
INSERT INTO mnv_vpl VALUES ("JN14_29","073_14_29","JHN","14","29","29","Ko Au e 'atigongo ai kia te koutou i na 'aso nei, 'io mugi o hetae mai. Ka nimaa go hetae mai, koutou hai ke go too ai kia te Au. ");
INSERT INTO mnv_vpl VALUES ("JN14_30","073_14_30","JHN","14","30","30","Ko Au ka he'e noho goa taku gea haka pigi kia te koutou, iteme'agaa te hakahua o gago nei ia Satan e a'u. Koia e he'e hai taganga o sigi ia te Au. ");
INSERT INTO mnv_vpl VALUES ("JN14_31","073_14_31","JHN","14","31","31","Ka manga hai ke na'a ai ena pegea o gago nei, ko Au e ma'ine kia Tamau, ma te hai e Au nia noko haka hegeu ai a Tamau kia te Au. “Tutu'u ake; kitatou boo i te kunga nei. ");
INSERT INTO mnv_vpl VALUES ("JN15_1","073_15_1","JHN","15","1","1","“Ko Au te tino o te kaubago maa'ogi, ka ko Tamau tenaa te hakahua. ");
INSERT INTO mnv_vpl VALUES ("JN15_2","073_15_2","JHN","15","2","2","Na ga'a o'oku e he'e tau hua kago toghitoghi e Tamau. Ka na ga'a go tau hua kago kotikoti gosigosi e Ia, ka ke go hu'ai 'eha ai ona hua. ");
INSERT INTO mnv_vpl VALUES ("JN15_3","073_15_3","JHN","15","3","3","Koutou kua 'oti i te hai o ma'a i na haka hegeunga kua gea ai Au kia te koutou. ");
INSERT INTO mnv_vpl VALUES ("JN15_4","073_15_4","JHN","15","4","4","Tu'u taki mai kia te Au, ka kau noho i goto ia te koutou. E si'ai he ga'a vaen ke manga muna o tau hua, ka naakupu ki te tu'utaki ki te tino o te vaen. Koutou ma'u ka he'e 'aonga te tau hua, ka naakupu ki te tu'utaki koutou kia te Au. ");
INSERT INTO mnv_vpl VALUES ("JN15_5","073_15_5","JHN","15","5","5","“Ko Au te tino o te vaen, ka koutou ona ga'a. Nimaa iai he pegea e tu'utaki kia te Au, kae noho Au i goto ia te ia, koia kago tau hua o 'eha. Ka koutou nimaa haka 'ui ia te Au, koutou ka he'e tau hai 'anga. ");
INSERT INTO mnv_vpl VALUES ("JN15_6","073_15_6","JHN","15","6","6","Nimaa iai he pegea he'e tu'utaki kia te Au, koia e noho pe te ga'a vaen tupe o maemae. Na ga'a vaen e konei na noho, manga haka putu o seu ki na ahi o bega. ");
INSERT INTO mnv_vpl VALUES ("JN15_7","073_15_7","JHN","15","7","7","Koutou nimaa tu'utaki kia te Au, kae noho aku haka hegeunga i goto ia te koutou, haka ene 'aki mai nia e siahahai kinai koutou, ka ke haiga'a kia te koutou. ");
INSERT INTO mnv_vpl VALUES ("JN15_8","073_15_8","JHN","15","8","8","Tenei te hai 'anga e haka 'agi ai te mamagunga o Tamau, te tau hua koutou. Tenei ma'u te hai 'anga ke haka 'agi ai koutou oku pegea haka ako maa'ogi. ");
INSERT INTO mnv_vpl VALUES ("JN15_9","073_15_9","JHN","15","9","9","“Ko Au e ma'ine kia te koutou o noho pe Tamau e ma'ine kia te Au. Koutou noho 'aki iho i toku ma'ine. ");
INSERT INTO mnv_vpl VALUES ("JN15_10","073_15_10","JHN","15","10","10","Koutou poi mangangao ki aku haka hegeunga, koutou kago noho 'aki i toku ma'ine, o noho pe Au e maangao ki na haka hegeunga a Tamau, o noho ai i tona ma'ine. ");
INSERT INTO mnv_vpl VALUES ("JN15_11","073_15_11","JHN","15","11","11","Ko Au e 'atigongo kia te koutou i te hai 'anga nei, ka ke go noho ai i toku siasia kia te koutou, ka ke hua'e'eha ai te sisia o 'outou. ");
INSERT INTO mnv_vpl VALUES ("JN15_12","073_15_12","JHN","15","12","12","Tenei taku tagangonga, koutou he ma'ine 'aki atu, ke noho pe aku ma'ine 'anga kia te koutou. ");
INSERT INTO mnv_vpl VALUES ("JN15_13","073_15_13","JHN","15","13","13","E si'ai he pegea hua'eha te ma'ine, ke sigi i tenei: Te pegea haiga'a te ma'ugi o'ona ki ana hemasi'inga. ");
INSERT INTO mnv_vpl VALUES ("JN15_14","073_15_14","JHN","15","14","14","Koutou aku hemasi'inga i te poi hai e koutou nia e haka hegeu ai Au kia te koutou. ");
INSERT INTO mnv_vpl VALUES ("JN15_15","073_15_15","JHN","15","15","15","Koutou ka he'e noko mate e Au oku guani, iteme'agaa te guani e he'e na'a eia nia manga hai e tona hakahua, kae sui Au o mate ia te koutou aku hemasi'inga, iteme'agaa ko ba'i hai 'anga noko haka gongo ai Au kia Tamau, kua hogahoga e Au kia te koutou. ");
INSERT INTO mnv_vpl VALUES ("JN15_16","073_15_16","JHN","15","16","16","Koutou noko he'e ligo ia te Au, ka ko Au te noko ligo e Au ia te koutou, o tuku ke boo ke tau hua. Na hua e hai ke go noho goa, ka ke go haiga'a ai e Tamau kia te koutou, nia kago haka ene 'aki ai koutou kia te Ia i toku ingoa. ");
INSERT INTO mnv_vpl VALUES ("JN15_17","073_15_17","JHN","15","17","17","Tenei taku tagangonga: Koutou he ma'ine 'aki atu. ");
INSERT INTO mnv_vpl VALUES ("JN15_18","073_15_18","JHN","15","18","18","“Nimaa go noko gotoa'a na pegea o gago nei kia te koutou, go noko maanatu atu ko kigatou noko mataa gotoa'a kia te Au. ");
INSERT INTO mnv_vpl VALUES ("JN15_19","073_15_19","JHN","15","19","19","Koutou poi na pegea o gago nei, ko kigatou kua ma'ine kia te koutou ke noho pe agatou ma'ine 'anga ki ogatou pegea. Ka koutou na ligo e Au ke haka maabae mai i na pegea o gago nei, tenei te hai 'anga kago gotoa'a ai na pegea o gago nei kia te koutou. ");
INSERT INTO mnv_vpl VALUES ("JN15_20","073_15_20","JHN","15","20","20","Maanatu giu atu ki taku gea 'anga kua hai kia te koutou: E si'ai he guani ke hua'eha o sigi i tona hakahua. Kogaa na noho noko hai songo e kigatou ia te Au, kago hai songo ma'u e kigatou ia te koutou. Ka poi mangangao kigatou ki aku akonga, ko kigatou kago mangangao ma'u ki autou akonga. ");
INSERT INTO mnv_vpl VALUES ("JN15_21","073_15_21","JHN","15","21","21","Ko kigatou kago konei na haka toto'o kia te koutou, i te ghaghi i toku ingoa, iteme'agaa e he'e na'a e kigatou ia te Ia noko haka to'o mai ia te Au. ");
INSERT INTO mnv_vpl VALUES ("JN15_22","073_15_22","JHN","15","22","22","Ko Au poi he'e a'u o haka hegeu kia te kigatou, ko kigatou e he'e saga ini 'oosongo. Ka na 'aso nei, ko kigatou e he'e 'aonga te huu ai ogatou 'oosongo. ");
INSERT INTO mnv_vpl VALUES ("JN15_23","073_15_23","JHN","15","23","23","Koai e gotoa'a kia te Au, e gotoa'a ma'u kia Tamau. ");
INSERT INTO mnv_vpl VALUES ("JN15_24","073_15_24","JHN","15","24","24","Poi he'e hai e Au ni hai 'anga he'e 'aonga te hai eni pegea i 'ago ia te kigatou, ko kigatou e he'e saga ini 'oosongo. Ka ko kigatou kua hiina'i ki na hai 'anga haka ohokia noko hai e Au, ka manga gotoa'a kia te kimaaua ngatahi ma Tamau. ");
INSERT INTO mnv_vpl VALUES ("JN15_25","073_15_25","JHN","15","25","25","Ka te hai 'anga nei manga hai ke haka maa'ogi ai nia na 'oti i te kanukanu ki agatou tagangonga: ‘Ko kigatou manga muna o gotoa'a kia te Au.’ ");
INSERT INTO mnv_vpl VALUES ("JN15_26","073_15_26","JHN","15","26","26","“Te 'aabaki o te Spirit Tapu, e hai kau go haka to'o mai 'ia mai a Tamau. Ko Ia te Spirit Tapu o te maa'ogi e hai ke go a'u ia Tamau ke noko 'atigongo ia te Au. ");
INSERT INTO mnv_vpl VALUES ("JN15_27","073_15_27","JHN","15","27","27","Ka koutou ma'u e hai ke go noko he 'atigongo 'aki ia te Au, iteme'agaa koutou noko haka pata kia te Au mai taku haka tu'u hai hekau 'anga.” ");
INSERT INTO mnv_vpl VALUES ("JN16_1","073_16_1","JHN","16","1","1","“Ko Au e 'atigongo kia te koutou i na hai 'anga nei, ke hai ia te koutou ke go noka tautou hetoki iho. ");
INSERT INTO mnv_vpl VALUES ("JN16_2","073_16_2","JHN","16","2","2","Koutou kago pagepage e kigatou ki haho i na Hage hai paaunga. E maa'ogi na 'aso ka a'u kago taa ai eni pegea ia te koutou, kae tegeu'a ake te hekau gaoi kia te 'Aitu. ");
INSERT INTO mnv_vpl VALUES ("JN16_3","073_16_3","JHN","16","3","3","Kago hai e kigatou na hai 'anga konei na noho, iteme'agaa kua he'e na'a e kigatou ia Tamau, o he'e na'a ma'u ia te Au. ");
INSERT INTO mnv_vpl VALUES ("JN16_4","073_16_4","JHN","16","4","4","Ko Au e 'atigongo kia te koutou i na hai 'anga nei, ka nimaa i na 'aso go hetae mai ai, kago maanatu giu ai koutou ki taku haka kuu manaba kia te koutou nei. Ko Au noko he'e 'atigongo kia te koutou i te hai 'anga nei i tetatou haka tu'u 'anga, iteme'agaa ko Au manga koi haka pata kia te koutou. ");
INSERT INTO mnv_vpl VALUES ("JN16_5","073_16_5","JHN","16","5","5","“Ka te gholoba nei, ko Au e hano kia te Ia noko haka to'o mai ia te Au. Ka koi he'e hakaanu he pegea ia te koutou kia te Au, ‘Ko Koe e hano ki hea?’ ");
INSERT INTO mnv_vpl VALUES ("JN16_6","073_16_6","JHN","16","6","6","Koutou manga 'agogoha, iteme'agaa ko Au kua 'atigongo kia te koutou i na hai 'anga nei. ");
INSERT INTO mnv_vpl VALUES ("JN16_7","073_16_7","JHN","16","7","7","Ka ko Au e gea maa'ogi kia te koutou: Taku hano 'anga nei te hai 'anga gaoi kia te koutou, iteme'agaa ko Au nimaa he'e hano, te Spirit Tapu ka he'e a'u kia te koutou. Ka nimaa hano Au, e hai kau go haka to'o mai 'ia te Spirit kia te koutou. ");
INSERT INTO mnv_vpl VALUES ("JN16_8","073_16_8","JHN","16","8","8","Te 'aso kago a'u ai te Spirit Tapu, e hai ke go haka 'agi e Ia na pegea o gago nei e saga i na 'oosongo, kago haka 'agi ma'u e Ia e saga ki te haka tinogaoi, ma te haka aba a te 'Aitu. ");
INSERT INTO mnv_vpl VALUES ("JN16_9","073_16_9","JHN","16","9","9","E haka 'agi e Ia ko kigatou e saga i na 'oosongo, iteme'agaa ko pegea kua he'e too kia te Au. ");
INSERT INTO mnv_vpl VALUES ("JN16_10","073_16_10","JHN","16","10","10","E haka 'agi e Ia ko kigatou e saga ki te haka tinogaoi, iteme'agaa ko Au e hano kia Tamau, ka koutou kago he'e hai ke noko hiina'i kia te Au. ");
INSERT INTO mnv_vpl VALUES ("JN16_11","073_16_11","JHN","16","11","11","E haka 'agi e Ia ko kigatou e saga ki te haka aba 'anga, iteme'agaa te hakahua o gago nei kua 'oti i te haka aba. ");
INSERT INTO mnv_vpl VALUES ("JN16_12","073_16_12","JHN","16","12","12","“E 'eha hai 'anga koi toe kau gea ai kia te koutou, ka kitai haingata'a te na'a e koutou i na 'aso nei. ");
INSERT INTO mnv_vpl VALUES ("JN16_13","073_16_13","JHN","16","13","13","Ka na 'aso kago a'u ai te Spirit Tapu o te maa'ogi, kago hutiaki e Ia ia te koutou ki ba'i hai 'anga maa'ogi. Kago he'e gea i ma'ana ni paaunga, kae hai ke go manga 'atigongo i nia e haka gongo ai. Kago 'atigongo ma'u kia te koutou, i nia koi he'e hetae mai. ");
INSERT INTO mnv_vpl VALUES ("JN16_14","073_16_14","JHN","16","14","14","Te Spirit Tapu kago hai ia te Au o mamagunga, iteme'agaa kago to'o mai e Ia nia e gea ai Au o 'atigongo ai kia te koutou. ");
INSERT INTO mnv_vpl VALUES ("JN16_15","073_16_15","JHN","16","15","15","Ko ba'i hai 'anga a Tamau na hai 'anga a'aku. Tenei te hai 'anga e hai atu ai Au, te Spirit Tapu e hai ke go to'o mai na hai 'anga gea ai Au o 'atigongo ai kia te koutou. ");
INSERT INTO mnv_vpl VALUES ("JN16_16","073_16_16","JHN","16","16","16","“E hai ke mi'i taunga gogoa, kae he'e hiina'i koutou kia te Au. Ka nimaa go mi'i taunga gogoa hoki, kae hiina'i giu koutou kia te Au.” ");
INSERT INTO mnv_vpl VALUES ("JN16_17","073_16_17","JHN","16","17","17","Kogaa i ona pegea haka ako noko hegeu o hai ake, “Niaa te gaataki e Ia, ‘E hai ke mi'i taunga gogoa, koutou kago he'e hiina'i kia te Au, ka nimaa go mi'i taunga gogoa hoki, kae hiina'i giu koutou kia te Au,’ kae hai mai ma'u, ‘Iteme'agaa ko Au e hano kia Tamau?’ ” ");
INSERT INTO mnv_vpl VALUES ("JN16_18","073_16_18","JHN","16","18","18","Ko kigatou noko manga he haka anuanu 'aki, “Niaa te gaataki e Ia: ‘E hai ke mi'i taunga gogoa?’ E he'e na'a e kitatou po nia te gea kinai.” ");
INSERT INTO mnv_vpl VALUES ("JN16_19","073_16_19","JHN","16","19","19","Noko na'a e Jesus, ko kigatou noko siahahai ke haka anu 'aki kia te Ia i te hai 'anga nei, ma te hai atu Ia kia te kigatou, “ 'Ai koutou e haka anuanu 'aki po tehea te gaataki o taku hai atu 'anga, ‘Ka mi'i taunga gogoa kae he'e hiina'i koutou kia te Au, ka nimaa go mi'i taunga gogoa hoki, kae hiina'i giu koutou kia te Au’? ");
INSERT INTO mnv_vpl VALUES ("JN16_20","073_16_20","JHN","16","20","20","Ko Au e gea maa'ogi kia te koutou: Koutou kago tatangi ma te magegepe i na 'aso kago noko sisia ai na pegea o gago nei. Koutou kago 'agogoha, ka autou 'agogoha 'anga e hai ke go taka hugi o noko sisia. ");
INSERT INTO mnv_vpl VALUES ("JN16_21","073_16_21","JHN","16","21","21","“Te hahine nimaa guea, koia ka haka gongo songo, iteme'agaa e hetae tena 'aso mamae, ka nimaa haka haa ma'ana he tama 'iti'iti, te hahine ka he'e maanatu ki tena haka gongo songo 'anga, iteme'agaa koia e siasia i te tama 'iti'iti kua haka haa ki gago nei. ");
INSERT INTO mnv_vpl VALUES ("JN16_22","073_16_22","JHN","16","22","22","E konei na noho ma'u a koutou: Na 'aso nei outou 'aso haka gongo songo, kae hai kau go ina hoki kia te koutou. Koutou e hai ke go sisia, kago si'ai he pegea to'o 'aatea 'autou sisia 'anga. ");
INSERT INTO mnv_vpl VALUES ("JN16_23","073_16_23","JHN","16","23","23","Te 'ao na, koutou kago he'e haka ene ai kia te Au i he hai 'anga. Ko Au e gea maa'ogi kia te koutou: Ko Tamau e hai ke go haiga'a kia te koutou nia kago haka ene ai koutou i toku ingoa. ");
INSERT INTO mnv_vpl VALUES ("JN16_24","073_16_24","JHN","16","24","24","A'u ano hetae mai ki na 'aso nei, koutou koi he'e haka ene 'aki i he me'a i toku ingoa, kae haka ene 'aki atu o ga'u e koutou, ka ke go hua'eha ai te sisia o 'outou. ");
INSERT INTO mnv_vpl VALUES ("JN16_25","073_16_25","JHN","16","25","25","“Masi'igoa ko Au manga gea kia te koutou i na haka mee'inga ka na 'aso ka a'u, ko Au kago he'e gea i na haka mee'inga kia te koutou, kae hai kau go 'atigongo haka maahoga kia te koutou ia Tamau. ");
INSERT INTO mnv_vpl VALUES ("JN16_26","073_16_26","JHN","16","26","26","Nimaa go hetae mai te 'ao na, koutou ogo haka ene 'aki atu i toku ingoa. Ko Au e he'e hai atu e hai kau go noko haka ene kia Tamau mo'outou. ");
INSERT INTO mnv_vpl VALUES ("JN16_27","073_16_27","JHN","16","27","27","Si'ai, ka ko Tamau e ma'ine kia te koutou, iteme'agaa koutou kua ma'ine kia te Au, ma te too ma'u koutou ko Au noko a'u mai a te 'Aitu. ");
INSERT INTO mnv_vpl VALUES ("JN16_28","073_16_28","JHN","16","28","28","Ko Au noko a'u mai a Tamau, o a'u ki gago nei, ka na 'aso nei e hano ai Au i gago nei, o hoki kia Tamau.” ");
INSERT INTO mnv_vpl VALUES ("JN16_29","073_16_29","JHN","16","29","29","Ma te hai atu na pegea haka ako o Jesus, “Na 'aso nei ko Koe manga gea haka maahoga kia te kimatou, he'e gea ini haka mee'inga. ");
INSERT INTO mnv_vpl VALUES ("JN16_30","073_16_30","JHN","16","30","30","Kua 'oti i te na'a e kimatou, ko Koe e na'a gaoi ba'i hai 'anga, ia te Koe e he'e tegeu'a ke haka anu he pegea kia te Koe. Te hai 'anga nei kua hai ia te kimatou o too ai, ko Koe noko a'u mai a te 'Aitu.” ");
INSERT INTO mnv_vpl VALUES ("JN16_31","073_16_31","JHN","16","31","31","Ma te haka tau atu a Jesus, “Koutou te'io too nei kia te Au. ");
INSERT INTO mnv_vpl VALUES ("JN16_32","073_16_32","JHN","16","32","32","Ka na 'aso noko hai ke a'u, kua hetae mai, kago maseuseu ai koutou o taki boo ki outou manaha, kae ti'aki e koutou ia te Au, o noho launatasi. Ka ko Au kago he'e pau o launatasi, ia Tamau manga haka pata kia te Au. ");
INSERT INTO mnv_vpl VALUES ("JN16_33","073_16_33","JHN","16","33","33","“Ko Au e 'atigongo kia te koutou i na hai 'anga nei, ka ke go ga'u ai e koutou te goto maagie ia te Au. Ko gago nei e hai ke go ga'u ai e koutou te haka gongo songo, ka koutou pipiki hinangago atu, na'e ko Au kua 'oti i te sepu i gago nei.” ");
INSERT INTO mnv_vpl VALUES ("JN17_1","073_17_1","JHN","17","1","1","Nimaa 'oti i te gea a Jesus i na hai 'anga nei, ko Ia na ina haka tu'u ki te gangi o taakunga o hai ake, “Tamau, te 'aso kua hetae mai. Haka e'eha mai ia tou Hosa, ka ke go haka e'eha ai e tou Hosa ia te Koe. ");
INSERT INTO mnv_vpl VALUES ("JN17_2","073_17_2","JHN","17","2","2","Iteme'agaa kua tuku kinai e Koe na hu'ai taganga ke hakahua i ba'i pegea, ma te kego haiga'a e Ia te ma'ugi noho goa ki na pegea kua haiga'a e Koe kia te Ia. ");
INSERT INTO mnv_vpl VALUES ("JN17_3","073_17_3","JHN","17","3","3","Tenei te ma'ugi noho goa, e hai kigatou na'a 'ia ko Koe launatasi te 'Aitu maa'ogi, ma Jesus Christ noko haka to'o mai e Koe. ");
INSERT INTO mnv_vpl VALUES ("JN17_4","073_17_4","JHN","17","4","4","Kua haka 'agi e Au tou mamagunga i te kege nei, i te kua hai e Au o 'oti na hekau noko tuku e Koe kau a'u o hai 'ia. ");
INSERT INTO mnv_vpl VALUES ("JN17_5","073_17_5","JHN","17","5","5","Ka te 'aso nei, Tamau, haka e'eha mai ia te Au i 'ago ia te Koe i te mamagunga noko hai haka pigi e Au kia te Koe, 'io mugi te haka tu'u sanga o na henua. ");
INSERT INTO mnv_vpl VALUES ("JN17_6","073_17_6","JHN","17","6","6","“Kua haka 'agi e Au ia te Koe ki na pegea na sa'u e Koe i gago nei o haiga'a kia te Au. Ko kigatou nei ou pegea, ka na haiga'a e Koe ia te kigatou kia te Au. Ko kigatou kua mangangao ki au haka hegeunga. ");
INSERT INTO mnv_vpl VALUES ("JN17_7","073_17_7","JHN","17","7","7","Na 'aso nei kua na'a e kigatou ko ba'i hai 'anga noko haiga'a e Koe kia te Au noko boo mai mai a te Koe. ");
INSERT INTO mnv_vpl VALUES ("JN17_8","073_17_8","JHN","17","8","8","Kua 'oti i te haiga'a e Au kia te kigatou na haka hegeunga noko haiga'a e Koe kia te Au, o too kinai kigatou. Kua na'a maa'ogi e kigatou ko Au noko a'u ia te Koe, ma te too kigatou ko Au noko haka to'o mai e Koe. ");
INSERT INTO mnv_vpl VALUES ("JN17_9","073_17_9","JHN","17","9","9","Ko Au e taakunga ia te kigatou. Ko Au e he'e taakunga i na pegea o gago nei, ka ko Au manga taakunga ia te kigatou kua 'oti i te haiga'a e Koe kia te Au, iteme'agaa ko kigatou ou pegea. ");
INSERT INTO mnv_vpl VALUES ("JN17_10","073_17_10","JHN","17","10","10","Ko ba'i me'a hai a'aku, au me'a, ka ko ba'i me'a a'au, aku me'a. Te mamagunga e a'u kia te Au, e agatu'u ia te kigatou. ");
INSERT INTO mnv_vpl VALUES ("JN17_11","073_17_11","JHN","17","11","11","Ko Au ka he'e noko noho i gago nei, ka ko kigatou te hai ke noko noho 'aki i gago nei, ka ko Au e hinatu kia te Koe. Tamau, ko Koe e Tapu, pipiki iho ia te kigatou ke magu ki na taganga o tou ingoa, te ingoa na haiga'a e Koe kia te Au. Hai mai ia te kigatou ke hepiitaki ke noho pe kitaaua e hepiitaki. ");
INSERT INTO mnv_vpl VALUES ("JN17_12","073_17_12","JHN","17","12","12","Na 'aso e haka pata ai Au kia te kigatou, e ge'o e Au ia te kigatou i tou ingoa noko haiga'a kia te Au. E si'ai he launatasi ia te kigatou kua hano 'aatea, ka manga te pegea noko haka pau ke go he'e kitea, ke haka maa'ogi ai na Kanukanu Tapu. ");
INSERT INTO mnv_vpl VALUES ("JN17_13","073_17_13","JHN","17","13","13","“Ko Au e hai kau hinatu kia te Koe i na 'aso nei, kae gea Au i na hai 'anga nei, i na 'aso koi noho ai Au i gago nei, ka ke hua'eha ai toku siasia i na uso ogatou. ");
INSERT INTO mnv_vpl VALUES ("JN17_14","073_17_14","JHN","17","14","14","Kua haiga'a e Au kia te kigatou au haka hegeunga, ma te gotoa'a ai na pegea o gago nei kia te kigatou, iteme'agaa ko kigatou e he'e na pegea o gago nei, o noho pe Au e he'e te pegea o gago nei. ");
INSERT INTO mnv_vpl VALUES ("JN17_15","073_17_15","JHN","17","15","15","Ko Au e he'e taakunga kia te Koe ke to'o 'aatea ia te kigatou i gago nei, ka ke manga pipiki e Koe ia te kigatou kia Satan. ");
INSERT INTO mnv_vpl VALUES ("JN17_16","073_17_16","JHN","17","16","16","Ko kigatou e he'e na pegea o gago nei, o noho pe Au e he'e te pegea o gago nei. ");
INSERT INTO mnv_vpl VALUES ("JN17_17","073_17_17","JHN","17","17","17","Haa tapu mai ia te kigatou i te maa'ogi. Tenei te maa'ogi: Na haka hegeunga a'au. ");
INSERT INTO mnv_vpl VALUES ("JN17_18","073_17_18","JHN","17","18","18","E haka to'o e Au ia te kigatou ki gago nei, o noho pe te haka to'o mai 'anga e Koe ia te Au ki gago nei. ");
INSERT INTO mnv_vpl VALUES ("JN17_19","073_17_19","JHN","17","19","19","Ko Au noko haa tapu ia te Au kia te Koe, i te ghaghinga ia te kigatou, ka kigatou ma'u ke tapuaki maa'ogi. ");
INSERT INTO mnv_vpl VALUES ("JN17_20","073_17_20","JHN","17","20","20","“Ko Au e he'e manga taakunga ia te kigatou nei soko, ka ko Au e taakunga ma'u i na pegea kago too kia te Au i agatou 'atigongo 'anga. ");
INSERT INTO mnv_vpl VALUES ("JN17_21","073_17_21","JHN","17","21","21","Tamau, ko Au e taakunga ke hai ia te kigatou ke hepiitaki, ke noho pe Koe e noho i goto ia te Au, kae noho Au i goto ia te Koe. Ko kigatou ma'u ke noho 'aki haka pigi kia te kitaaua, ka ke go too ai na pegea o gago nei, ko Au noko haka to'o mai e Koe. ");
INSERT INTO mnv_vpl VALUES ("JN17_22","073_17_22","JHN","17","22","22","Kua haiga'a e Au kia te kigatou te mamagunga noko 'aumai e Koe kia te Au, ke hai ia te kigatou ke hepiitaki, ke noho pe kitaaua e hepiitaki. ");
INSERT INTO mnv_vpl VALUES ("JN17_23","073_17_23","JHN","17","23","23","Ko Au e noho i goto ia te kigatou, ka ko Koe e noho i goto ia te Au. Ke hai ia te kigatou ke pau o he tu'utaki 'aki gaoi, ka ke go na'a ai ena pegea o gago nei, ko Koe te noko haka to'o mai ia te Au, ka ko Koe ma'u e ma'ine kia te kigatou, o noho pe au ma'ine 'anga kia te Au. ");
INSERT INTO mnv_vpl VALUES ("JN17_24","073_17_24","JHN","17","24","24","“Tamau, ko Au e siahai ki na pegea kua haiga'a e Koe kia te Au nei, ke haka pata kia te Au i te kunga e noho ai Au, ma te kigatou hiina'i ki te mamagunga noko haiga'a e Koe kia te Au, iteme'agaa ko Koe noko ma'ine kia te Au, 'io mugi te haka tu'u sanga o na henua. ");
INSERT INTO mnv_vpl VALUES ("JN17_25","073_17_25","JHN","17","25","25","“Tamau, ko Koe e tinogaoi. Masi'igoa na pegea o gago nei e he'e na'a e kigatou ia te Koe, kae na'a e Au ia te Koe, ka kua na'a e kigatou nei, ko Koe te noko haka to'o mai ia te Au. ");
INSERT INTO mnv_vpl VALUES ("JN17_26","073_17_26","JHN","17","26","26","Kua hai e Au o na'a e kigatou ia te Koe. E hai kau noko konei na hai 'ia, ka ke go noho ai te ma'ine e hai e Koe kia te Au i ogatou uso, ka kau go noho ma'u ai i ogatou uso.” ");
INSERT INTO mnv_vpl VALUES ("JN18_1","073_18_1","JHN","18","1","1","Te 'aso na 'oti ai te taakunga a Jesus, ko Ia ma ona pegea haka ako noko gaakau i te abaga i Kidron, noko iai te 'ugu olives i tegaa pa'asi. Ko Jesus ma ona pegea haka ako noko boo ki te kunga nei. ");
INSERT INTO mnv_vpl VALUES ("JN18_2","073_18_2","JHN","18","2","2","Ka ko Judas noko haka soko eia a Jesus, noko na'a ma'u eia te kungaa, iteme'agaa noko 'eha 'aso haka putu kinai a Jesus ma ona pegea haka ako. ");
INSERT INTO mnv_vpl VALUES ("JN18_3","073_18_3","JHN","18","3","3","Ko Judas na hano ki te kungaa, noko hutiaki eia te tu'uganga solodia mai Rome, ma na ge'o sanga o te Hage Tapu noko haka to'o ena hakahua o na Priest ma na Pharisee. Ko kigatou noko to'o agatou peba ma na iha, ma agatou me'a taa pegea. ");
INSERT INTO mnv_vpl VALUES ("JN18_4","073_18_4","JHN","18","4","4","Ko Jesus noko na'a e Ia ba'i hai 'anga hai ke hetae kia te Ia, ko Ia na tu'uti atu o haka anu kia te kigatou, “Koai te sasaga e koutou?” ");
INSERT INTO mnv_vpl VALUES ("JN18_5","073_18_5","JHN","18","5","5","Ko kigatou noko haka tau atu, “Ko Jesus mai Nazareth.” Ma te hai atu a Jesus, “Tenei Au.” (Ka ko Judas e haka soko eia a Jesus, noko manga tu'u haka pigi kia te kigatou.) ");
INSERT INTO mnv_vpl VALUES ("JN18_6","073_18_6","JHN","18","6","6","Te 'aso na hai atu ai a Jesus, “Tenei Au,” ko kigatou na he sogomugi 'aki, ma te hetoki ki te kege. ");
INSERT INTO mnv_vpl VALUES ("JN18_7","073_18_7","JHN","18","7","7","Ma te haka anu hoki kinai a Jesus o hai atu, “Koai te sasaga e koutou?” Ma te hai atu kigatou, “Ko Jesus mai Nazareth.” ");
INSERT INTO mnv_vpl VALUES ("JN18_8","073_18_8","JHN","18","8","8","Ma te hai atu a Jesus, “Kua hogahoga e Au kia te koutou, tenei Au. Nimaa ko Au te sasaga e koutou, tuku atu na pegea nei ke boo.” ");
INSERT INTO mnv_vpl VALUES ("JN18_9","073_18_9","JHN","18","9","9","Ko Jesus noko konei ana gea, ka ke haka maa'ogi ai ana gea 'anga: “Tamau, kua he'e ti'aki e Au he launatasi i na pegea noko haiga'a e Koe kia te Au.” ");
INSERT INTO mnv_vpl VALUES ("JN18_10","073_18_10","JHN","18","10","10","Ka ko Simon Peter noko hai tena kiba taa pegea, na sa'u ake eia o haka iho ki te guani o te hakahua o na priest, ma te sabi ai te taginga maui o 'ona. (Te ingoa o te guani nei ko Malchus.) ");
INSERT INTO mnv_vpl VALUES ("JN18_11","073_18_11","JHN","18","11","11","Ma te hai atu a Jesus kia Peter, “Tuku hoki iho tau kiba ki tona tanga, na'e e hai kau binu 'ia te kapu o te haka gongo songo noko haiga'a e Tamau kia te Au.” ");
INSERT INTO mnv_vpl VALUES ("JN18_12","073_18_12","JHN","18","12","12","Te tu'uganga o na solodia, ma tegatou tugi tau'a, ma na ge'o sanga o te Hage Tapu, na he'osohi kia Jesus o gii e kigatou ia te Ia. ");
INSERT INTO mnv_vpl VALUES ("JN18_13","073_18_13","JHN","18","13","13","O mataa kakabe ia te Ia kia Annas, te tamana hungabai o Caiaphas, te hakahua o na priest i te ghapu na. ");
INSERT INTO mnv_vpl VALUES ("JN18_14","073_18_14","JHN","18","14","14","Tenei a Caiaphas na puge ki na Jew, “E gaoi ke tuku e koutou he launatasi tangata ke mate ki te 'apitanga o pegea.” ");
INSERT INTO mnv_vpl VALUES ("JN18_15","073_18_15","JHN","18","15","15","Ko Simon Peter ma tegaa pegea haka ako noko tata'o tu'a ia Jesus, ka tegaa pegea haka ako noko he na'a 'aki ma te hakahua o na priest, na tata'o ia Jesus ki goto i te gotomaga'e i te mu'a o te hage o te hakahua o na priest. ");
INSERT INTO mnv_vpl VALUES ("JN18_16","073_18_16","JHN","18","16","16","Ka ko Peter noko manga hitagi ake i te agaa. Tegaa pegea haka ako noko he na'a 'aki ma te hakahua o na priest, noko hoki iho o gea ki te hahine noko ge'o i te agaa, o kakabe ia Peter ki goto. ");
INSERT INTO mnv_vpl VALUES ("JN18_17","073_18_17","JHN","18","17","17","Te hahine i te agaa na hai atu kia Peter, “ 'Ai ko koe e he'e te launatasi i na pegea haka ako o te tangata nei?” Ma te haka tau atu a Peter, “Si'ai, ko au he'e te pegea o 'Ona.” ");
INSERT INTO mnv_vpl VALUES ("JN18_18","073_18_18","JHN","18","18","18","Na guani ma na solodia o te Hage Tapu, noko tutu'u mugheghi i te ahi noko hai o he mumugu 'aki ai i te noko gogohi. Ko Peter noko ma tu'u haka pigi kia te kigatou o mumugu. ");
INSERT INTO mnv_vpl VALUES ("JN18_19","073_18_19","JHN","18","19","19","Te gholoba na, noko haka anu ai a Annas, te hakahua o na priest, kia Jesus i na noho o na pegea haka ako ma na akonga a'ana. ");
INSERT INTO mnv_vpl VALUES ("JN18_20","073_18_20","JHN","18","20","20","Ma te haka tau atu a Jesus, “Ko Au noko manga gea haka 'agi'agi ki ba'i pegea o gago nei. Ko ba'i 'aso ko Au noko manga ako i na Hage hai paaunga ma te Hage Tapu, gua kunga nei noko manga haka putu kinai a Jew. Ko Au noko he'e gea huu ini hai 'anga. ");
INSERT INTO mnv_vpl VALUES ("JN18_21","073_18_21","JHN","18","21","21","Tehea te hai 'anga e haka anu ai koe kia te Au? Haka anu atu ki na pegea noko ta'a haka gongo kia te Au. Na'e e na'a gaoi e kigatou nia noko gea ai Au.” ");
INSERT INTO mnv_vpl VALUES ("JN18_22","073_18_22","JHN","18","22","22","Te gholoba na konei na gea ai a Jesus, noko iai te launatasi i na solodia o te Hage Tapu noko ma hitaiaki kia te Ia, noko paa eia na mata o Jesus i te 'agohi gima, kae hai atu, “ 'Ai e konaa au haka tau ki te hakahua o na priest?” ");
INSERT INTO mnv_vpl VALUES ("JN18_23","073_18_23","JHN","18","23","23","Ma te haka tau a Jesus kia te Ia o hai atu, “Nimaa gea Au i he hai 'anga maase'i, hogahoga ake nia te maase'i. Ka nimaa tinogaoi taku gea 'anga, 'eaa gaa e husu ai e koe ia te Au?” ");
INSERT INTO mnv_vpl VALUES ("JN18_24","073_18_24","JHN","18","24","24","Ma te haka to'o e Annas ia Jesus kia Caiaphas, te hakahua o na priest, ka noko manga koi noho ai na giitanga. ");
INSERT INTO mnv_vpl VALUES ("JN18_25","073_18_25","JHN","18","25","25","Ko Peter noko manga koi tu'u o mumugu, ma te haka anu 'aki giu kigatou kia te ia o hai atu, “ 'Eaa? E maa'ogi ko koe e he'e te launatasi i ona pegea haka ako?” Ka na haka si'ai ma'u eia o hai atu, “Si'ai, ko au he'e te pegea o 'Ona.” ");
INSERT INTO mnv_vpl VALUES ("JN18_26","073_18_26","JHN","18","26","26","Te launatasi i na guani o te hakahua o na priest, te 'atima'ogi o te tangata noko sabi e Peter te taginga, noko haka anu atu kia Peter, “ 'Eaa? 'Ai ko au noko he'e ina kia te koe manga haka pata kia te Ia i te kunga e iai na olive?” ");
INSERT INTO mnv_vpl VALUES ("JN18_27","073_18_27","JHN","18","27","27","Ma te haka si'ai haka hoki ma'u e Peter, ka te gholoba na e tangi ai te paolo. ");
INSERT INTO mnv_vpl VALUES ("JN18_28","073_18_28","JHN","18","28","28","Ma te kakabe e na hakahua o na Jew ia Jesus i te hage o Caiaphas, o boo ki te hu'ai hage gaoi o Pilate, te hu'ai hakahua mai Rome. Nimaa i te mahoata pipilu, na Jew na he'e he uguhi ki te hage hu'ai gaoi i te noko siahahai ke pipiki ia te kigatou ke ma'a ki agatou paaunga, ka kigatou go 'aonga te kai i te kainga o te Passover. ");
INSERT INTO mnv_vpl VALUES ("JN18_29","073_18_29","JHN","18","29","29","Nimaa sopo iho a Pilate kia te kigatou, o haka anu atu kinai, “Niaa te 'atigongo haka makau ai e koutou te tangata nei?” ");
INSERT INTO mnv_vpl VALUES ("JN18_30","073_18_30","JHN","18","30","30","Ma te haka tau a kigatou o hai atu, “Te pegea nei poi he'e hai hai 'anga maase'i, ma he'e haiga'a e kimatou ia te Ia kia te koe.” ");
INSERT INTO mnv_vpl VALUES ("JN18_31","073_18_31","JHN","18","31","31","Ma te hai atu a Pilate kia te kigatou, “Kakabe soko atu e koutou ia te Ia o haka aba haka papata ki autou tagangonga.” Ma te haka tau atu na Jew, “E he'e 'aonga te haka pau e kimatou he pegea ke mate.” ");
INSERT INTO mnv_vpl VALUES ("JN18_32","073_18_32","JHN","18","32","32","Te hai 'anga nei noko hai o haka maa'ogi ai na gea 'anga a Jesus, noko haka maahoga ai e Ia, poe hai ke go kohea ana mate. ");
INSERT INTO mnv_vpl VALUES ("JN18_33","073_18_33","JHN","18","33","33","Ko Pilate na ugu hoki ki goto i tona hu'ai hage gaoi, o pogo 'aki iho ia Jesus, o haka anuanu kia te Ia o hai atu, “Tenaa Koe te Hakahua o na Jew?” ");
INSERT INTO mnv_vpl VALUES ("JN18_34","073_18_34","JHN","18","34","34","Ma te haka anu atu kinai a Jesus, “Manga au haka gaatanga o konaa au haka anu kia te Au, poe iai he pegea 'atigongo kia te koe ia te Au?” ");
INSERT INTO mnv_vpl VALUES ("JN18_35","073_18_35","JHN","18","35","35","Ma te haka tau atu a Pilate, “ 'Ai e tegeu'a ake Koe koau te Jew? Ou pegea ma outou hakahua na priest te haiga'a e kigatou ia te Koe kia te au. Niaa te noko hai e Koe?” ");
INSERT INTO mnv_vpl VALUES ("JN18_36","073_18_36","JHN","18","36","36","Ko Jesus noko hai atu, “Te Hakahua 'anga a'aku, e he'e te hai 'anga o gago nei. Poi te hai 'anga o gago nei, oku guani kua haka hetata'i o susugi na Jew ke noka tegatou he 'osohi kia te Au, ka taku Hakahua 'anga te hai 'anga mai te kunga 'aatea.” ");
INSERT INTO mnv_vpl VALUES ("JN18_37","073_18_37","JHN","18","37","37","Ma te hai atu a Pilate kia Jesus, “Ko Koe te Hakahua?” Ma te haka tau kinai a Jesus o hai atu, “Manga gaoi te hai mai 'anga koe ko Au te Hakahua. E maa'ogi tenei te hai 'anga na haka haa ai Au i gago nei. Tenei ma'u te tugi o taku a'u ki gago nei kau 'atigongo i te maa'ogi. Ko ba'i pegea i te pa'asi o te maa'ogi e haka gongo kia te Au.” ");
INSERT INTO mnv_vpl VALUES ("JN18_38","073_18_38","JHN","18","38","38","Ma te haka anu atu a Pilate, “ 'Ai niaa te maa'ogi?” Kae tohu iho a Pilate ki na Jew o hai atu kia te kigatou, “E he'e kite eau he hai 'anga maase'i kia te Ia. ");
INSERT INTO mnv_vpl VALUES ("JN18_39","073_18_39","JHN","18","39","39","E iai te hai 'anga e ta'anga hai eau kia te koutou i na 'aso o te Passover: Ta'a haka tausu'u ai eau he launatasi pegea kagohia kia te koutou, ka koutou e siahahai kau haka tausu'u 'ia kia te koutou te Hakahua o na Jew?” ");
INSERT INTO mnv_vpl VALUES ("JN18_40","073_18_40","JHN","18","40","40","Ko kigatou na ngengege giu atu kia Pilate, “Si'ai e he'e te tangata nei, ka ko Barabbas!” Ka ko Barabas te tangata haka tauseke. ");
INSERT INTO mnv_vpl VALUES ("JN19_1","073_19_1","JHN","19","1","1","Ko Pilate na kakabe iho eia ia Jesus o tuku o kogu. ");
INSERT INTO mnv_vpl VALUES ("JN19_2","073_19_2","JHN","19","2","2","Ma te higi ena solodia te ha'u kraon i na kaubago hotohoto, o haka eke ki te 'ugu, kae haa ake e kigatou ia te Ia i te ake uga tetenga. ");
INSERT INTO mnv_vpl VALUES ("JN19_3","073_19_3","JHN","19","3","3","Ko kigatou noko he hokihoki saki te boo ake kia te Ia o hai atu, “Ke ma'ugi goa te hakahua o na Jew!” Kae paa e kigatou na mata o'ona. ");
INSERT INTO mnv_vpl VALUES ("JN19_4","073_19_4","JHN","19","4","4","Ko Pilate noko hoki iho ma'u o hai atu ki na Jew, “Hiina'i mai, e hai kau kakabe iho 'ia ia Jesus kia te koutou, ke na'a e koutou, e si'ai he hai 'anga maase'i kau kite 'ia kia te Ia.” ");
INSERT INTO mnv_vpl VALUES ("JN19_5","073_19_5","JHN","19","5","5","Nimaa hinaiho a Jesus ki haho, kua tango e Ia te kaubago hotohoto o hai ai tena ha'u kraon, kae ake i te ake uga tetenga, ma te hai atu a Pilate kia te kigatou, “Hiina'i mai, tenei te tangata!” ");
INSERT INTO mnv_vpl VALUES ("JN19_6","073_19_6","JHN","19","6","6","Te 'aso na hiina'i ai na hakahua o na Priest, ma na pegea hai hekau ogatou kia Jesus, ko kigatou na ngengege atu, “Taa atu ki te kros, taa atu ki te kros!” Ka na hai atu a Pilate kia te kigatou, “Kakabe atu e koutou o taa ia te Ia ki te kros, e he'e kite eau he hai 'anga maase'i kia te Ia.” ");
INSERT INTO mnv_vpl VALUES ("JN19_7","073_19_7","JHN","19","7","7","Ma te haka tau na Jew kia te ia o hai atu, “Ko kimatou e hai ta'a matou tagangonga. E haka papata ki te tagangonga nei, ko Ia e hai ke mate, iteme'agaa e hai ake, ko Ia te Hosa o te 'Aitu.” ");
INSERT INTO mnv_vpl VALUES ("JN19_8","073_19_8","JHN","19","8","8","Te 'aso na haka gongo ai a Pilate ki tegatou konei na gegea 'anga, koia na hu'ai mataku ai. ");
INSERT INTO mnv_vpl VALUES ("JN19_9","073_19_9","JHN","19","9","9","Ma te hoki ki goto i tena hage, o haka anu kia Jesus o hai atu, “Tehea te kunga noko a'u ai Koe?” Ka ko Jesus noko he'e muna kinai. ");
INSERT INTO mnv_vpl VALUES ("JN19_10","073_19_10","JHN","19","10","10","Ma te hai atu a Pilate, “Ko Koe e he'e siahai ke gea kia te au? 'Ai e he'e na'a e Koe ia te au e hai taganga te tuku ia te Koe ke tausu'u, po ke taa ia te Koe ki te kros?” ");
INSERT INTO mnv_vpl VALUES ("JN19_11","073_19_11","JHN","19","11","11","Ma te haka tau kinai a Jesus o hai atu, “Ko koe e he'e hai taganga ke sigi ia te Au i te poi he'e haiga'a kia te koe mai te gangi. Tenei te hai 'anga e hua'eha ai te 'oosongo o te pegea kua haiga'a eia ia te Au kia te koe.” ");
INSERT INTO mnv_vpl VALUES ("JN19_12","073_19_12","JHN","19","12","12","Ma te haka tu'u i te gholoba na, ko Pilate noko hai lobo ke tuku ia Jesus ke tausu'u, ka na Jew noko manga ngengege atu kia te ia, “Nimaa tuku e koe te tangata nei o tausu'u, ko koe he'e te hemasi'inga a Caesar. Koai e hai ake te hakahua, e gea haka makau kia Caesar.” ");
INSERT INTO mnv_vpl VALUES ("JN19_13","073_19_13","JHN","19","13","13","Te gholoba na haka gongo ai a Pilate ki na ngengege 'anga nei, koia na kakabe iho eia a Jesus, o noho i te noohonga haka aba pegea, te kunga noko ingoa te 'Atinga Hatu. Noko mate i te hegeunga a Hebrew te Gabbatha. ");
INSERT INTO mnv_vpl VALUES ("JN19_14","073_19_14","JHN","19","14","14","Te 'ao na, te 'aso haka ngaague ai ki te Passover. Nimaa i te 'ao 'aatea, ko Pilate na hai atu ki na Jew, “Tenei te Hakahua o 'outou.” ");
INSERT INTO mnv_vpl VALUES ("JN19_15","073_19_15","JHN","19","15","15","Ka ko kigatou noko ngengege atu, “Kakabe 'aatea atu! Kakabe 'aatea atu! Taa atu ia te Ia ki te kros!” Ma te hai atu a Pilate kia te kigatou, “ 'Ai e hai kau taa 'ia te hakahua o 'outou?” Ma te haka tau na hakahua o na Priest o hai atu, “E si'ai ma'u mo'omatou he hakahua, ka manga ko Caesar.” ");
INSERT INTO mnv_vpl VALUES ("JN19_16","073_19_16","JHN","19","16","16","Ma te haiga'a e Pilate ia Jesus kia te kigatou, ke taa ki te kros. Na solodia na he'osohi kia Jesus o kakabe ia te Ia. ");
INSERT INTO mnv_vpl VALUES ("JN19_17","073_19_17","JHN","19","17","17","Ko Jesus noko 'amo tena kros, o hano ki te kunga noko mate “Te kunga o na Puso 'ugu”, noko mate i te hegeunga a Hebrew: ko Golgotha. ");
INSERT INTO mnv_vpl VALUES ("JN19_18","073_19_18","JHN","19","18","18","Tenaa te kunga na taa ai e kigatou ia Jesus ki te kros. Noko taa haka pigi e kigatou te toka gua pegea kia te Ia. Noko taki tuku i gua pa'asi, kae noho uso ai a Jesus. ");
INSERT INTO mnv_vpl VALUES ("JN19_19","073_19_19","JHN","19","19","19","Ko Pilate noko hai tena kanukanu 'anga o tuku i 'agunga ia Jesus. Konei na me'a noko kanukanu, “Ko Jesus mai Nazareth, te Hakahua o na Jew.” ");
INSERT INTO mnv_vpl VALUES ("JN19_20","073_19_20","JHN","19","20","20","Noko 'eha Jew na haka sahe e kigatou te haka 'igonga nei, iteme'agaa te kunga noko taa ai a Jesus ki te kros, noko hitaiaki ki te hu'ai manaha. Te haka 'igonga nei noko kanukanu i te hegeunga a Hebrew, ma te hegeunga a Rome, ma te hegeunga a Greece. ");
INSERT INTO mnv_vpl VALUES ("JN19_21","073_19_21","JHN","19","21","21","Na hakahua o na Priest noko hai atu kia Pilate, “Noka te kanukanu, ‘Te Hakahua o na Jew,’ ka manga kanukanu, ‘Te tangata nei e hai ake, ko Ia te Hakahua o na Jew.’ ” ");
INSERT INTO mnv_vpl VALUES ("JN19_22","073_19_22","JHN","19","22","22","Ko Pilate na haka tau kinai o hai atu, “Nia kua kanukanu eau, kua pau au o kanukanu.” ");
INSERT INTO mnv_vpl VALUES ("JN19_23","073_19_23","JHN","19","23","23","Te 'aso na taa ai ena solodia ia Jesus ki te kros, na hai e kigatou ona ake o tuhatuha o toka haa ona pa'asi, o taki hai e kigatou, kae toe tona ake ki goto. Te ake nei noko he'e tau agaa lapuinga ke tu'utaki ai, noko gaganga i te me'a e tasi, haka tu'u iho mai 'agunga o hetae iho ki tona potu 'oti ki gago. ");
INSERT INTO mnv_vpl VALUES ("JN19_24","073_19_24","JHN","19","24","24","Ko kigatou na hai ake, “Kitatou noka te lagilagi 'ia, ka kitatou manga ligo 'ia i te babage 'anga i na daes ke kite ai po koai e hai ke hai mo'ona.” Te hai 'anga nei noko hai o haka maa'ogi ai na Kanukanu Tapu, noko hai ake: “E hai kigatou go tuhatuha 'ia oku ake, kae tuku toku ake ki goto ke babage kinai.” Ka na konei na hai ena solodia. ");
INSERT INTO mnv_vpl VALUES ("JN19_25","073_19_25","JHN","19","25","25","Ko te tinana o Jesus, ma te taina o te tinana, ma Mary te uguugu o Clopas, ma Mary mai Magdala, noko manga tutu'u haka hitaiaki ki te kros. ");
INSERT INTO mnv_vpl VALUES ("JN19_26","073_19_26","JHN","19","26","26","Te gholoba na ina 'atu ai a Jesus kia te tinana manga i te kungaa, ma te pegea haka ako noko ma'ine kinai Ia manga hitaiaki kinai, ko Ia na hai atu kia te tinana, “Ta'ahine, tenaa tau tama.” ");
INSERT INTO mnv_vpl VALUES ("JN19_27","073_19_27","JHN","19","27","27","Kae hai atu ki te pegea haka ako, “Tenaa tou tinana.” Haka tu'u i te gholoba na, te pegea haka ako nei na kakabe eia a Mary ki tona manaha. ");
INSERT INTO mnv_vpl VALUES ("JN19_28","073_19_28","JHN","19","28","28","Mugi i na hai 'anga nei, ko Jesus noko na'a e Ia ko ba'i hai 'anga kua hai o 'oti, ka ke haka maa'ogi na Kanukanu Tapu, ko Ia noko hai atu, “Ko Au e sia binu.” ");
INSERT INTO mnv_vpl VALUES ("JN19_29","073_19_29","JHN","19","29","29","Noko iai te hu'ai poati noko i te kungaa, noko honu i na waeni e maga. Na gogomi ai e kigatou te momo laoa maguu i te waeni nei o tuku ki te ga'akau hisop o tuku ake ki te ngutu o Jesus. ");
INSERT INTO mnv_vpl VALUES ("JN19_30","073_19_30","JHN","19","30","30","Te 'aso na binu ai e Jesus te waeni nei, ko Ia na hai ake, “Kua 'oti.” Kae mou te 'ugu o haiga'a te ma'ugi o 'ona kae mate. ");
INSERT INTO mnv_vpl VALUES ("JN19_31","073_19_31","JHN","19","31","31","Te 'ao na, te 'aso haka ngaague, iteme'agaa tegaa 'ao, te 'Ao Oki oki. Te 'ao na te 'Ao Oki oki o te Passover. Tenei te hai 'anga noko he'e siahahai ai na Jew ke noko noho ai na tino o na pegea nei i na kros i te 'Ao Oki oki, ma te haka ene 'aki kigatou kia Pilate, ke tohitohi ogatou ba'e ke mamate ghali ai, ka ke sa'u iho ogatou tino. ");
INSERT INTO mnv_vpl VALUES ("JN19_32","073_19_32","JHN","19","32","32","Ma te boomai na solodia o tohitohi na ba'e o gua pegea noko taa haka pigi kia Jesus. Noko mataa tohitohi na ba'e o tegaa, kae mugi o tohitohi na ba'e o tegaa. ");
INSERT INTO mnv_vpl VALUES ("JN19_33","073_19_33","JHN","19","33","33","Nimaa te gholoba na boo atu ai kigatou kia Jesus ma te kite e kigatou kua 'oti i te mate, ma te he'e tohitohi e kigatou gua ba'e. ");
INSERT INTO mnv_vpl VALUES ("JN19_34","073_19_34","JHN","19","34","34","Ka noko iai te launatasi i na solodia na bego eia te kaokao o Jesus i te tao. O singa iho ai na toto ma na bai. ");
INSERT INTO mnv_vpl VALUES ("JN19_35","073_19_35","JHN","19","35","35","Te tangata noko ina kinai, koia te noko 'atigongo nei. Ka ana 'atigongo 'anga nei e maa'ogi, ma te hogahoga eia koutou go too ma'u kinai. ");
INSERT INTO mnv_vpl VALUES ("JN19_36","073_19_36","JHN","19","36","36","Na hai 'anga nei noko hai o haka maa'ogi ai na Kanukanu Tapu: “Kago si'ai he launatasi i na ibi o'ona ke totohi.” ");
INSERT INTO mnv_vpl VALUES ("JN19_37","073_19_37","JHN","19","37","37","Ma te noho ma'u ki tegaa Kanukanu Tapu noko hai ake: “E hai kigatou go hiina'i ki te launatasi pegea kua bego e kigatou.” ");
INSERT INTO mnv_vpl VALUES ("JN19_38","073_19_38","JHN","19","38","38","Mugi a Joseph mai Arimathea, o haka ene kia Pilate i te tino o Jesus. Ko Joseph te pegea haka ako o Jesus, ka noko manga hai huu, iteme'agaa koia noko mataku ki na Jew. Nimaa tuku e Pilate, ma te hano ia o to'o te tino o Jesus. ");
INSERT INTO mnv_vpl VALUES ("JN19_39","073_19_39","JHN","19","39","39","Ko Joseph noko boo ma Nicodemus, te tangata noko hano kia Jesus i te poo. Ko Nicodemus noko to'o mai eia na bai tutuu gaoi noko haka higohigo i na ‘myrrh’ ma na ‘aloe’, noko hu'ai 'eha na me'a nei. ");
INSERT INTO mnv_vpl VALUES ("JN19_40","073_19_40","JHN","19","40","40","Gua taangata nei na to'o e kigaaua te tino o Jesus, o penapena i na laoa susugu, kae tuku kinai na me'a tutuu gaoi. Noko konei na hai na hesuinga a Jew ki na tanu pegea mamate 'anga. ");
INSERT INTO mnv_vpl VALUES ("JN19_41","073_19_41","JHN","19","41","41","Te kunga noko taa ai ia Jesus ki te kros, noko iai te 'umanga. Te 'umanga nei noko iai te takotonga ho'ou, manga koi he'e tanu ai he pegea. ");
INSERT INTO mnv_vpl VALUES ("JN19_42","073_19_42","JHN","19","42","42","Iteme'agaa te 'ao haka ngaague o Jew, ka tenaa te takotonga noko hitaiaki, ma te tanu ai e kigaaua ia Jesus. ");
INSERT INTO mnv_vpl VALUES ("JN20_1","073_20_1","JHN","20","1","1","Te mahoata pipilu o te 'ao mu'a o na 'ao na, te gholoba noko manga koi poo'ugi ai, ko Mary mai Magdala na hano ki te takotonga, ma te ina ki te hatu kua hugi 'aatea i te takotonga. ");
INSERT INTO mnv_vpl VALUES ("JN20_2","073_20_2","JHN","20","2","2","Ma te tege hoki o hano kia Simon Peter, ma tegaa pegea haka ako noko ma'ine kinai a Jesus, o hai atu kia te kigaaua, “Kua to'o 'aatea e kigatou te Hakahua i te takotonga, kae he'e na'a e kitatou po tehea te kunga e tuku ai e kigatou ia te Ia!” ");
INSERT INTO mnv_vpl VALUES ("JN20_3","073_20_3","JHN","20","3","3","Ma te boo a Peter ma tegaa pegea haka ako ki te takotonga. ");
INSERT INTO mnv_vpl VALUES ("JN20_4","073_20_4","JHN","20","4","4","Ko kigaaua noko ma he 'agiko, ka tegaa pegea haka ako na tege o sigi ia Peter, o mataa tatae ki te takotonga. ");
INSERT INTO mnv_vpl VALUES ("JN20_5","073_20_5","JHN","20","5","5","Koia noko hao'o o ina 'atu ki na laoa susugu noko penapena ai, ka koia noko he'e hano ki goto. ");
INSERT INTO mnv_vpl VALUES ("JN20_6","073_20_6","JHN","20","6","6","Ka ko Simon Peter na mugi mai ia te ia, o hetae mai o hano ki goto i te takotonga. Koia noko ina ki na laoa susugu noko penapena ai manga koi noho. ");
INSERT INTO mnv_vpl VALUES ("JN20_7","073_20_7","JHN","20","7","7","Ka te mi'i laoa noko pegu ai te 'ugu o Jesus, noko he'e haka pigi ki na laoa susugu, ka noko pegu o hai to'ona kunga. ");
INSERT INTO mnv_vpl VALUES ("JN20_8","073_20_8","JHN","20","8","8","Ka tegaa pegea haka ako noko mataa hetae ki te takotonga, na hano ma'u ki goto. Koia na ina kinai o too kinai. ");
INSERT INTO mnv_vpl VALUES ("JN20_9","073_20_9","JHN","20","9","9","Ko kigaaua noko manga koi he'e na'a e kigaaua na Kanukanu Tapu noko hai ake: “Ko Ia e hai ke go ma'ugi hokimai i te mate.” ");
INSERT INTO mnv_vpl VALUES ("JN20_10","073_20_10","JHN","20","10","10","Ma te giu gua pegea haka ako ki gu'o gaaua manaha. ");
INSERT INTO mnv_vpl VALUES ("JN20_11","073_20_11","JHN","20","11","11","Ka ko Mary noko manga tu'u i te taha o te takotonga o manga tangi, aano hao'o o ina ki goto i te takotonga. ");
INSERT INTO mnv_vpl VALUES ("JN20_12","073_20_12","JHN","20","12","12","Ma te ina ki te toka gua ensel noko ake i na me'a susugu, o ma noho 'aki i te kunga noko tuku ai te tino o Jesus, noho tegaa i honga 'ugu, kae noho tegaa i na mugi ba'e. ");
INSERT INTO mnv_vpl VALUES ("JN20_13","073_20_13","JHN","20","13","13","Ko kigaaua noko haka anu atu kia Mary, “Ta'ahine, tehea te hai 'anga manga tangi ai koe?” Ma te hai atu a Mary, “Kua to'o e kigatou toku Hakahua, kae he'e na'a eau po tehea te kunga kua tuku ai e kigatou ia te Ia.” ");
INSERT INTO mnv_vpl VALUES ("JN20_14","073_20_14","JHN","20","14","14","Nimaa konei na gea a Mary kae taka hugi, ma te ina kia Jesus manga tu'u i te kungaa, ka noko he'e na'a eia, ko Jesus. ");
INSERT INTO mnv_vpl VALUES ("JN20_15","073_20_15","JHN","20","15","15","Ma te hai atu a Jesus kia Mary, “Ta'ahine, tehea te hai 'anga manga tangi ai koe? Koai te manga sasaga ai koe?” Ka na tegeu'a ake a Mary te ge'o sanga o te 'umanga, ma te hai atu kia te ia, “Hakahua, nimaa kua to'o 'aatea e koe ia te Ia, hogahoga mai po tehea te kunga kua tuku ai e koe, ka kau hano o to'o 'ia.” ");
INSERT INTO mnv_vpl VALUES ("JN20_16","073_20_16","JHN","20","16","16","Nimaa hai atu a Jesus kia te ia, “Mary.” Ma te taka hugi a Mary o hai atu i te hegeunga a Hebrew, “Rabboni!” e haka gaataki: Ako. ");
INSERT INTO mnv_vpl VALUES ("JN20_17","073_20_17","JHN","20","17","17","Hai atu a Jesus kia Mary, “Noka te 'oso kia te Au, na'e ko Au koi he'e hoki kia Tamau, ka manga hinatu ki toku 'api, o 'atigongo kia te kigatou, ko Au e hoki kia Tamau, te Tamana o 'outou ma'u, ki toku 'Aitu, te 'Aitu o 'outou ma'u.” ");
INSERT INTO mnv_vpl VALUES ("JN20_18","073_20_18","JHN","20","18","18","Ko Mary mai Magdala na hoki ki na pegea haka ako ma te gongo nei, koia kua ina ki te Hakahua, ma te kua gea kia te Ia i na hai 'anga nei. ");
INSERT INTO mnv_vpl VALUES ("JN20_19","073_20_19","JHN","20","19","19","Nimaa i te ahiahi o te 'ao mu'a o na 'ao na, te gholoba na haka putu ai na pegea haka ako ki te hage, noko titingi e kigatou te aga o ma'u, i te noko matataku ki na Jew, ka na hinake a Jesus o tu'u 'ago ia te kigatou o hai atu, “Te goto maagie kia te koutou!” ");
INSERT INTO mnv_vpl VALUES ("JN20_20","073_20_20","JHN","20","20","20","Mugi i te konei ana gea 'anga kae haka 'agi na gima ma te kaokao kia te kigatou. Na pegea haka ako na hu'ai sisia i te 'aso na hiina'i ai kigatou ki te Hakahua. ");
INSERT INTO mnv_vpl VALUES ("JN20_21","073_20_21","JHN","20","21","21","Ma te hai haka hoki atu a Jesus, “Te goto maagie kia te koutou. Manga noho pe te haka to'o mai 'anga e Tamau ia te Au, kae konei na haka to'o e Au ia te koutou.” ");
INSERT INTO mnv_vpl VALUES ("JN20_22","073_20_22","JHN","20","22","22","Te gholoba na konei ana gea ai, kae manaba atu Ia kia te kigatou, kae hai atu, “Ke ga'u e koutou te Spirit Tapu. ");
INSERT INTO mnv_vpl VALUES ("JN20_23","073_20_23","JHN","20","23","23","Nimaa go haka noka e koutou ni 'oosongo mo'o ni pegea, kago haka noka maa'ogi kia te kigatou. Ka nimaa go he'e haka noka e koutou ni 'oosongo mo'o ni pegea, kago he'e haka noka maa'ogi kia te kigatou.” ");
INSERT INTO mnv_vpl VALUES ("JN20_24","073_20_24","JHN","20","24","24","Ko Thomas, noko mate te Maasanga, te launatasi i na pegea haka ako, noko he'e haka pata ki na pegea haka ako i te 'aso na hano kinai a Jesus. ");
INSERT INTO mnv_vpl VALUES ("JN20_25","073_20_25","JHN","20","25","25","Nimaa 'atigongo kinai kogaa pegea haka ako, ko kigatou kua hiina'i ki te Hakahua, ka koia noko hai atu, “Naakupu ki te ina au ki na paba maka i na gima, ma te tuku toku maninia gima ki na paba maka i na hugu hatu'ugi, ma te tuku toku gima ki te kaokao, ko au ka he'e 'aonga taku too kinai.” ");
INSERT INTO mnv_vpl VALUES ("JN20_26","073_20_26","JHN","20","26","26","Nimaa sigi na 'ao, 'Ona pegea haka ako noko noho 'aki giu i te hage, ka ko Thomas noko ma noho haka pata kia te kigatou. Masi'igoa na aga noko titingi o ma'u, ka ko Jesus na hinake o tu'u 'ago ia te kigatou o hai atu, “Te goto maagie kia te koutou!” ");
INSERT INTO mnv_vpl VALUES ("JN20_27","073_20_27","JHN","20","27","27","Kae hai atu kia Thomas, “Tuku mai tou mania gima ki oku kunga nei, ma te ina mai ki gu'oku gima, kae hohoga mai tou gima o tuku ki toku kaokao. Noka te haka mi'i me'a tou sano, kae too mai kia te Au.” ");
INSERT INTO mnv_vpl VALUES ("JN20_28","073_20_28","JHN","20","28","28","Ma te hai atu a Thomas kia te Ia, “Toku Hakahua ma toku 'Aitu!” ");
INSERT INTO mnv_vpl VALUES ("JN20_29","073_20_29","JHN","20","29","29","Ma te hai atu a Jesus kia te ia, “Ko koe e too kia te Au, iteme'agaa ko koe kua ina kia te Au. Te hakagaoi ki na pegea he'e hiina'i kia te Au, ka manga too kia te Au.” ");
INSERT INTO mnv_vpl VALUES ("JN20_30","073_20_30","JHN","20","30","30","Ko Jesus noko 'eha ma'u kogaa haka 'igonga haka ohokia noko hai e Ia i 'ago i ona pegea haka ako, e he'e kanukanu ki te buka nei. ");
INSERT INTO mnv_vpl VALUES ("JN20_31","073_20_31","JHN","20","31","31","Ka konei na hai 'anga kua kanukanu, ke na'a ai e koutou, ko Jesus te 'Agiki Taga'ia, te Hosa o te 'Aitu, ka nimaa too kinai koutou, ka hai ai e koutou te ma'ugi i tona ingoa. ");
INSERT INTO mnv_vpl VALUES ("JN21_1","073_21_1","JHN","21","1","1","Nimaa sigi na 'aso, ko Jesus noko sopo ki ona pegea haka ako i te gano i Galilee, e mate ma'u ko Taeberias. Noko konei na haka 'agi tino kinai: ");
INSERT INTO mnv_vpl VALUES ("JN21_2","073_21_2","JHN","21","2","2","Ko Simon Peter, ma Thomas, noko mate te Maasanga, ma Nathaniel mai Cana i Galilee, ma gua hosa o Zebedee, ma gua gaa pegea haka ako, noko manga haka pata 'aki. ");
INSERT INTO mnv_vpl VALUES ("JN21_3","073_21_3","JHN","21","3","3","Ma te hai atu a Peter kia te kigatou, “E hai kau hano o tautai.” Ma te hai atu kigatou, “E hai kimatou tata'o ia te koe.” Ma te boo iho kigatou o sosopo ki te baka, ka te poo na ko kigatou na si'ai ma'agatou ni kaui. ");
INSERT INTO mnv_vpl VALUES ("JN21_4","073_21_4","JHN","21","4","4","Nimaa i te mahoata, ko Jesus noko manga tu'u i te 'one, ka noko he'e na'a ena pegea haka ako, ko Jesus. ");
INSERT INTO mnv_vpl VALUES ("JN21_5","073_21_5","JHN","21","5","5","Ko Jesus noko ngege iho kia te kigatou, “Aku hemasi'inga, e hai ma'autou ni kaui?” Ko kigatou noko haka tau ake kia te Ia, “Si'ai.” ");
INSERT INTO mnv_vpl VALUES ("JN21_6","073_21_6","JHN","21","6","6","Ko Ia na ngege iho kia te kigatou, “Tupe iho te bugho ki te pa'asi maui o te baka, ka ke hai ai ma'autou ni kaui.” Nimaa tupe e kigatou te bugho ki te pa'asi maui o te baka, na he'e 'ao'ao ki te huhuti ake e kigatou te bugho, iteme'agaa noko hu'ai 'eha kaui. ");
INSERT INTO mnv_vpl VALUES ("JN21_7","073_21_7","JHN","21","7","7","Ma te hai atu te pegea haka ako noko ma'ine kinai a Jesus kia Peter, “Te Hakahua tenei.” Te 'aso na haka gongo ai a Simon Peter kia te ia noko hai atu, “Te Hakahua tenei”, koia na mago hoki i ona ake, iteme'agaa na 'ui'ui kae hai hekau, o 'utu ki te moana. ");
INSERT INTO mnv_vpl VALUES ("JN21_8","073_21_8","JHN","21","8","8","Ka kogaa pegea haka ako noko mugi ake i te baka, o huhuti ake e kigatou te bugho noko honu i na kaui, iteme'agaa ko kigatou noko he'e mama'o ki 'agunga, noko manga gimanga kumi tona mama'o 'anga. ");
INSERT INTO mnv_vpl VALUES ("JN21_9","073_21_9","JHN","21","9","9","Te 'aso na boo ake ai kigatou ki 'agunga, ko kigatou na hiina'i ki te ahi manga kaa gagahu manga heketi ai na kaui, ma na bred. ");
INSERT INTO mnv_vpl VALUES ("JN21_10","073_21_10","JHN","21","10","10","Ma te hai atu a Jesus kia te kigatou, “To'o mai ni me'a i na kaui e hai ho'ou e koutou.” ");
INSERT INTO mnv_vpl VALUES ("JN21_11","073_21_11","JHN","21","11","11","Ma te sopo a Simon Peter ki te baka o tata ake eia ki 'agunga te bugho kua honu i na kaui, noko mata te gau ma te mata gima tuma'a e togu (153). Masi'igoa noko konei na 'eha, ka te bugho noko he'e motumotu. ");
INSERT INTO mnv_vpl VALUES ("JN21_12","073_21_12","JHN","21","12","12","Ma te hai atu a Jesus kia te kigatou, “Boomai o kai.” Ka noko si'ai he pegea haka ako ke toka manaba ke haka anu kia te Ia, “Ko Koe koai?” i te na 'oti i te na'a e kigatou, te Hakahua tenei. ");
INSERT INTO mnv_vpl VALUES ("JN21_13","073_21_13","JHN","21","13","13","Ma te a'u a Jesus o sa'u ake na bred o 'abange kia te kigatou, ma te 'abange ma'u kinai na kaui. ");
INSERT INTO mnv_vpl VALUES ("JN21_14","073_21_14","JHN","21","14","14","Tenei te haka 'agi haka togu o Jesus ki ona pegea haka ako, i tena ma'ugi hokimai 'anga i te mate. ");
INSERT INTO mnv_vpl VALUES ("JN21_15","073_21_15","JHN","21","15","15","Te 'aso na 'oti ai tegatou kai 'anga, ko Jesus na hai atu kia Simon Peter, “Simon, te Hosa o John, ko koe e ma'ine maa'ogi kia te Au o sigi i te ma'ine o na pegea nei?” Hai atu a Peter kia Jesus, “ 'Oo, Hakahua e na'a e Koe, koau e ma'ine kia te Koe.” Ma te hai atu a Jesus, “Ge'o atu aku punua sipisipi.” ");
INSERT INTO mnv_vpl VALUES ("JN21_16","073_21_16","JHN","21","16","16","Ma te gea hoki atu a Jesus, “Simon, te hosa o John, ko koe e ma'ine maa'ogi kia te Au?” Hai atu a Peter kia Jesus, “ 'Oo, Hakahua, e na'a e Koe koau e ma'ine kia te Koe.” Ma te hai atu a Jesus, “Ge'o atu aku sipisipi.” ");
INSERT INTO mnv_vpl VALUES ("JN21_17","073_21_17","JHN","21","17","17","Nimaa gea haka togu a Jesus o hai atu kia Peter, “Simon, te hosa o John, ko koe e ma'ine kia te Au?” Ko Peter na haka gongo songo i te noko gea haka togu kinai a Jesus, “Ko koe e ma'ine kia te Au?” Ma te hai atu ia kia Jesus, “Hakahua, manga na'a e Koe ba'i hai 'anga. E na'a e Koe, koau e ma'ine kia te Koe.” Ma te hai atu a Jesus kia Peter, “Ge'o atu aku sipisipi. ");
INSERT INTO mnv_vpl VALUES ("JN21_18","073_21_18","JHN","21","18","18","Ko Au e gea maa'ogi kia te koe: Ou 'aso noko tamatama ai, ko koe noko manga haamago ia te koe kae hano ki na kunga siahai koe ke hano kinai. Ka tou 'aso tauiku, ko koe e hai ke go hohoga ou gima kae haamago eni pegea 'aatea ia te koe, ma te kauaki ia te koe kini kunga he'e siahai koe ke hano kinai.” ");
INSERT INTO mnv_vpl VALUES ("JN21_19","073_21_19","JHN","21","19","19","Ko Jesus noko konei ana gea, ke haka 'agi ai poe hai ke go kohea na mate a Peter, ke haka ma'u 'agunga ai ia te 'Aitu. Kae hai atu a Jesus kia Peter, “Tata'o mai ia te Au.” ");
INSERT INTO mnv_vpl VALUES ("JN21_20","073_21_20","JHN","21","20","20","Ma te keu iho a Peter o ina 'atu ki te pegea haka ako e ma'ine kinai a Jesus, manga mugi mai ia te kigaaua. Tenei te pegea noko loghoni kia Jesus, i te 'aso noko hai ai te kai tapu, ma te hai atu, “Hakahua, koai te hai ke go haka soko ia te Koe?” ");
INSERT INTO mnv_vpl VALUES ("JN21_21","073_21_21","JHN","21","21","21","Te 'aso na ina 'atu ai a Peter kia te ia, ma te hai atu kia Jesus, “Hakahua, ka 'eaa te tangata nei?” ");
INSERT INTO mnv_vpl VALUES ("JN21_22","073_21_22","JHN","21","22","22","Hai atu a Jesus kia Peter, “Poi siahai Au kia te ia ke noko ma'ugi ke noho ano hetae ki toku 'aso hokimai, e he'e tau hai 'anga kia te koe, ko koe e hai ke tata'o ia te Au.” ");
INSERT INTO mnv_vpl VALUES ("JN21_23","073_21_23","JHN","21","23","23","Te gea 'anga nei na hohoga i na pegea sogi o hai ake, “Te pegea haka ako nei kago he'e mate.” Ka ko Jesus noko he'e hai mai, koia kago he'e mate. Ka ko Ia noko manga hai mai, “Poi siahai Au kia te ia ke noko ma'ugi, ke noho ano hetae ki toku 'aso hoki mai, e he'e tau hai 'anga kia te koe.” ");
INSERT INTO mnv_vpl VALUES ("JN21_24","073_21_24","JHN","21","24","24","Tenei te pegea haka ako e hogahoga eia na hai 'anga nei, ma te kanukanu eia. E na'a e kimatou ana 'atigongo 'anga nei e maa'ogi. ");
INSERT INTO mnv_vpl VALUES ("JN21_25","073_21_25","JHN","21","25","25","Noko 'eha ma'u kogaa hai 'anga hai e Jesus, ka poi kanukanu ngatahi ba'i hai 'anga, e hai taku maanatu, he'e po ko te kege nei kaatoa, kago he'e tau kunga ke pipiki ai na buka, i te poi kanukanu ngatahi kinai.");
ALTER TABLE mnv_vpl ADD FULLTEXT(verseText);
UNLOCK TABLES;
