﻿USE sofia;
DROP TABLE IF EXISTS sofia.mni_vpl;
CREATE TABLE mni_vpl (
  verseID VARCHAR(16) NOT NULL PRIMARY KEY,
  canon_order VARCHAR(12) NOT NULL,
  book VARCHAR(3) NOT NULL,
  chapter VARCHAR(3) NOT NULL,
  startVerse VARCHAR(3) NOT NULL,
  endVerse VARCHAR(3) NOT NULL,
  verseText TEXT CHARACTER SET UTF8 NOT NULL) ENGINE=MyISAM;
LOCK TABLES mni_vpl WRITE;
INSERT INTO mni_vpl VALUES ("MT1_1","070_1_1","MAT","1","1","1","Isinduna thamliba asi David amadi Abraham-gi charon suron oiriba Jisu Christtagi pari purigi maramdani. ");
INSERT INTO mni_vpl VALUES ("MT1_2","070_1_2","MAT","1","2","2","Abraham-na Isaac pok-i, Isaac-na Jacob pok-i, Jacob-na Judah amasung mahakki machin manaosing pok-i. ");
INSERT INTO mni_vpl VALUES ("MT1_3","070_1_3","MAT","1","3","3","Aduga Judah-na Perez amasung Zerah pok-i, amasung Tamar-na makhoigi mamani. Aduga Perez-na Hezron pok-i, Hezron-na Ram pok-i. ");
INSERT INTO mni_vpl VALUES ("MT1_4","070_1_4","MAT","1","4","4","Aduga Ram-na Amminadab pok-i, Amminadab-na Nahshon pok-i, Nahshon-na Salmon pok-i. ");
INSERT INTO mni_vpl VALUES ("MT1_5","070_1_5","MAT","1","5","5","Salmon-na Rahab louduna Boaz pok-i. Aduga Boaz-na Ruth louduna Obed pok-i. Adudagi Obed-na Jesse pok-i. ");
INSERT INTO mni_vpl VALUES ("MT1_6","070_1_6","MAT","1","6","6","Jesse-na David ningthou pok-i; aduga David-na Uriah-na louramba nupi adu louduna Solomon pok-i. ");
INSERT INTO mni_vpl VALUES ("MT1_7","070_1_7","MAT","1","7","7","Aduga Solomon-na Rehoboam pok-i, Rehoboam-na Abijah pok-i, Abijah-na Asa pok-i. ");
INSERT INTO mni_vpl VALUES ("MT1_8","070_1_8","MAT","1","8","8","Aduga Asa-na Jehoshaphat pok-i, Jehoshaphat-na Jehoram pok-i. Jehoram-na Uzziah pok-i. ");
INSERT INTO mni_vpl VALUES ("MT1_9","070_1_9","MAT","1","9","9","Aduga Uzziah-na Jotham pok-i, Jotham-na Ahaz pok-i, Ahaz-na Hezekiah pok-i. ");
INSERT INTO mni_vpl VALUES ("MT1_10","070_1_10","MAT","1","10","10","Aduga Hezekiah-na Manasseh pok-i, Manasseh-na Amon pok-i, Amon-na Josiah pok-i. ");
INSERT INTO mni_vpl VALUES ("MT1_11","070_1_11","MAT","1","11","11","Aduga makhoibu Babylon-da lanpha oina puba matam aduwaida Josiah-na Jeconiah amasung mahakki machin-manaosing pok-i. ");
INSERT INTO mni_vpl VALUES ("MT1_12","070_1_12","MAT","1","12","12","Adudagi makhoibu Babylon-da lanpha oina pukhraba matungda, Jeconiah-na Shealtiel pok-i, Shealtiel-na Zerubbabel pok-i. ");
INSERT INTO mni_vpl VALUES ("MT1_13","070_1_13","MAT","1","13","13","Aduga Zerubbabel-na Abiud pok-i, Abiud-na Eliakim pok-i, Eliakim-na Azor pok-i. ");
INSERT INTO mni_vpl VALUES ("MT1_14","070_1_14","MAT","1","14","14","Aduga Azor-na Zadok pok-i, Zadokna Akim pok-i, Akim-na Eliud pok-i. ");
INSERT INTO mni_vpl VALUES ("MT1_15","070_1_15","MAT","1","15","15","Aduga Eliud-na Eleazar pok-i, Eleazar-na Matthan pok-i, Matthan-na Jacob pok-i. ");
INSERT INTO mni_vpl VALUES ("MT1_16","070_1_16","MAT","1","16","16","Aduga Jacob-na Mary-gi mapuroiba Joseph pok-i. Mary-na Christta kouba Jisu-bu pok-i. ");
INSERT INTO mni_vpl VALUES ("MT1_17","070_1_17","MAT","1","17","17","Asumna Abrahamda-gi houraga David phaobagi miron pumnamak asi taramarini. Aduga David-tagi houraga makhoibu Babylon-da lanpha oina pukhiba phaoba miron taramarini. Aduga Babylon-da lanpha oina pukhibadagi Christta pokpa phaoba adu miron taramarini. ");
INSERT INTO mni_vpl VALUES ("MT1_18","070_1_18","MAT","1","18","18","Jisu Christta asi matou asumna pokkhi. Ibungogi mama Mary asi Joseph-ka luhongnabagi waroinaraga, makhoi ani leiminadringeigi mamangda mahak Thawai Asengbagi mapanna mironle haiba khanglakle. ");
INSERT INTO mni_vpl VALUES ("MT1_19","070_1_19","MAT","1","19","19","Adubu Joseph achumba chatpa mi ama oiba maramna, Marybu miyam mangda phongdoktuna ikai phiruk khumhanninglamde. Maram aduna mahakna mana-manin naidana Mary-bu thadoklage haina leplammi. ");
INSERT INTO mni_vpl VALUES ("MT1_20","070_1_20","MAT","1","20","20","Aduga mahakna asumna khallingeida, yeng-u, Mapu Ibungogi dut amana mamangda uhanbiduna asumna hairak-i, “He David-ki macha Joseph, Mary-bu nahakki nupi oina loubada kiganu, Maramdi mahakna naopuriba angang adu Thawai Asengbadagini. ");
INSERT INTO mni_vpl VALUES ("MT1_21","070_1_21","MAT","1","21","21","Aduga mahakna machanupa ama pokkani, nahakna mahakki maming Jisu thon-gadabani. Maramdi mahakna mahakki misingbu makhoigi paptagi kanbigani.” ");
INSERT INTO mni_vpl VALUES ("MT1_22","070_1_22","MAT","1","22","22","Mapu Ibungona Tengban Mapugi wa phongdokpa maichousinggi mapanna phongdokpikhiba wasing adu thungnanaba pumnamak asi thoklare, ");
INSERT INTO mni_vpl VALUES ("MT1_23","070_1_23","MAT","1","23","23","“Yeng-u, leisabi asengbi amana mironduna machanupa ama pokkani, aduga mahakki maming Immanuel kougani, masigi wahanthokti ‘Eikhoiga leiminaba Tengban Mapu’ haibani.” ");
INSERT INTO mni_vpl VALUES ("MT1_24","070_1_24","MAT","1","24","24","Aduga Joseph-na tumlambadagi hougatlaga, Mapu Ibungogi dut aduna piramba yathang adugi matung inna mahakna Mary-bu luhongduna loure. ");
INSERT INTO mni_vpl VALUES ("MT1_25","070_1_25","MAT","1","25","25","Adubu Mary-na machanupa adu poktriba phaoba Joseph-na mahakka phidinnaramde. Aduga mahakna angang adugi maming Jisu thonkhi. ");
INSERT INTO mni_vpl VALUES ("MT2_1","070_2_1","MAT","2","1","1","Herod Ningthougi haktakta, Judea-gi Bethlehem-da Jisu poklaba matungda, yeng-u, nongpoklomdagi khang-heiraba misingna Jerusalem-da laktuna hanglak-i, ");
INSERT INTO mni_vpl VALUES ("MT2_2","070_2_2","MAT","2","2","2","“Jihudigi ningthou oina pokkhraba angang adu kadaida leibage? Maramdi nongpoklomda Ibungo mahakki thawanmichak thokpa eikhoina ure. Aduna eikhoina Ibungobu khurumjaba lakcharibani.” ");
INSERT INTO mni_vpl VALUES ("MT2_3","070_2_3","MAT","2","3","3","Madu tabada Herod ningthou wakhal yamna langtaknarammi aduga Jerusalem-da leiriba mi pumnamaksu wakhal langtaknarammi. ");
INSERT INTO mni_vpl VALUES ("MT2_4","070_2_4","MAT","2","4","4","Adudagi mahakna athoiba purohitsing amasung Wayel Yathanggi ojasing pumnamak kouraduna Christta pokkadaba mapham adu kadaidano haina hanglammi. ");
INSERT INTO mni_vpl VALUES ("MT2_5","070_2_5","MAT","2","5","5","Maduda makhoina mangonda khumlak-i; “Judea-gi Bethlehem-da pokkani. Maramdi Tengban Mapugi wa phongdokpiba maichouna asumna haikhi: ");
INSERT INTO mni_vpl VALUES ("MT2_6","070_2_6","MAT","2","6","6","‘Judea-gi lamda leiba Bethlehem, nahakti Judah-gi leingakpasinggi maraktagi hanthaba natte; maramdi nangondagi eigi mi Israel-bu chingbigadaba leingakpa ama thoklakkani.’ ” ");
INSERT INTO mni_vpl VALUES ("MT2_7","070_2_7","MAT","2","7","7","Maduda Herod-na khang-heiraba mising adubu lonna kouraduna karamba matamda thawanmichak adu thokkhibage haibadu makhoidagi khangdokle. ");
INSERT INTO mni_vpl VALUES ("MT2_8","070_2_8","MAT","2","8","8","Adudagi mahakna makhoibu Bethlehem-da tharaduna hairak-i, “Nakhoina chattuna, pikliba angang adubu cheksinna thiyu; aduga nakhoina mahakpu hek phangbaga eihaknasu laktuna mahakpu khurumjanaba eingonda pao pirak-u.” ");
INSERT INTO mni_vpl VALUES ("MT2_9","070_2_9","MAT","2","9","9","Makhoina ningthougi wa adu taraba matungda mapham adu thadoktuna chatkhre. Amasung makhoina nongpoklomda ukhiba thawanmichak aduna angang aduna leiriba mapham aduphaoba laktuna leptriphaoba makhoigi mamang thaduna chatlammi. ");
INSERT INTO mni_vpl VALUES ("MT2_10","070_2_10","MAT","2","10","10","Makhoina thawanmichak adu uba matamda hainingngai leitana haraojarammi. ");
INSERT INTO mni_vpl VALUES ("MT2_11","070_2_11","MAT","2","11","11","Adudagi makhoina yum adugi manungda changlaklammi. Amasung makhoina pikliba angang aduna mama Mary-ga loinana leiramba adu ubada khuru-khudak kunduna Ibungobu khurumjare. Aduga makhoina sana, kunduru amadi myrrh-gi khudonpot adu louthokchaduna Ibungoda khudol tamjare. ");
INSERT INTO mni_vpl VALUES ("MT2_12","070_2_12","MAT","2","12","12","Adudagi Tengban Mapuna makhoida Herod-ki manakta amuk halluraganu haina mamang amada khanghanbirabada makhoina atoppa lambi amada chattuna mareibakta hankhirammi. ");
INSERT INTO mni_vpl VALUES ("MT2_13","070_2_13","MAT","2","13","13","Amasung makhoina chatkhraba tungda, Mapu Ibungogi dut amana Joseph-ki mamangda uhanbiduna hairak-i, “Hougatlu, pikliba angang adu mamaga loinana puduna Egypt-ta chellu. Aduga eina nangonda amuk hallak-u haidriba phaoba mapham aduda leiyu. Maramdi Herod-na angang asibu hatnanaba thirakkadouri.” ");
INSERT INTO mni_vpl VALUES ("MT2_14","070_2_14","MAT","2","14","14","Adudagi Joseph-na hougattuna ahing adumaktada angang adu mamaga loinana puraduna Egypt-ta chatkhi. ");
INSERT INTO mni_vpl VALUES ("MT2_15","070_2_15","MAT","2","15","15","Aduga Herod-na sidriba phaoba makhoina mapham aduda leirammi. Masi Tengban Mapugi wa phongdokpiba maichousinggi mapanna Mapu Ibungona haikhiba “Eina eigi Ichanupabu Egypt-tagi kouthok-i” haiba wa adu thungnanabani. ");
INSERT INTO mni_vpl VALUES ("MT2_16","070_2_16","MAT","2","16","16","Herod-na khang-heiraba mising aduna mahakpu namthak toukhre haiba khanglaklabada mahak yamna saorammi. Aduga mahakna khang-heirabasing aduna hairamba thawanmichak adu thokkhiba matam adu yenglaga Bethlehem amasung madugi akoibada leiba chahi ani amasung chahi anigi makhada leiba nupamachasingbu hatnanaba yathang pikhi. ");
INSERT INTO mni_vpl VALUES ("MT2_17","070_2_17","MAT","2","17","17","Matou asumna Tengban Mapugi wa phongdokpiba maichou Jeremiah-na haikhiba adu thunglare. ");
INSERT INTO mni_vpl VALUES ("MT2_18","070_2_18","MAT","2","18","18","“Takhi Ramah-da, khonjel ama, Hikna hikna kappagi amasung yamna kanna tengtha-naoibagi khonjel. Rachel-na machasinggidamak kappi; Yaramde mahakpu themjinba, maramdi makhoi leikhidre.” ");
INSERT INTO mni_vpl VALUES ("MT2_19","070_2_19","MAT","2","19","19","Herod-na siraba matungda, Egypt-ta Tengban Mapugi dut amana Joseph-ki mamangda uhanbiduna, ");
INSERT INTO mni_vpl VALUES ("MT2_20","070_2_20","MAT","2","20","20","hairak-i, “Hougatlu, pikliba angang adu mamaga loinana puraduna Israel leibakta hallo; maramdi angang adubu hatke hotnaramba makhoising adu sikhre.” ");
INSERT INTO mni_vpl VALUES ("MT2_21","070_2_21","MAT","2","21","21","Adudagi Joseph-na hougatlaga pikliba angang adu mamaga loinana puraduna Israel leibakta hallakle. ");
INSERT INTO mni_vpl VALUES ("MT2_22","070_2_22","MAT","2","22","22","Adubu Judea-da Archelausna mapa Herod-ki mahutta palli haiba Joseph-na tarabada, mahakna mapham aduda chatpa kirammi. Adudagi mahakki mamangda Tengban Mapuna khanghanbiraba matungda Galilee-gi lamda chatkhirammi. ");
INSERT INTO mni_vpl VALUES ("MT2_23","070_2_23","MAT","2","23","23","Aduga makhoina Nazareth kouba apikpa sahar amada laktuna leirammi. Masi Tengban Mapugi wa phongdokpiba maichousingna, “Ibungobu Nazareth-ki mi kougani” haikhiba wa adu thungnanabani. ");
INSERT INTO mni_vpl VALUES ("MT3_1","070_3_1","MAT","3","1","1","Matam aduda baptize toubiba John-na thoraktuna Judea-gi lamjao lamhangda pao sandokpa hourammi. ");
INSERT INTO mni_vpl VALUES ("MT3_2","070_3_2","MAT","3","2","2","Mahakna asumna hairammi, “Nakhoina paptagi pukning hongduna Tengban Mapuda halak-u, maramdi swarga leibak adu naksillakle!” ");
INSERT INTO mni_vpl VALUES ("MT3_3","070_3_3","MAT","3","3","3","Tengban Mapugi wa phongdokpiba maichou Isaiah-na phongdokpikhiba misak adu John asini, “Laori, kanagumba amana lamjao lamhangda, ‘MAPU IBUNGO-gi lambi adu thourang tou; Ibungo mahakna chatnaba lambi adu chumhallu!’ ” ");
INSERT INTO mni_vpl VALUES ("MT3_4","070_3_4","MAT","3","4","4","John-na ut matugi phi setlammi, aduga makhwangda sawun-gi khwangjet laklammi; amasung mahakki chinjakti koujeng amasung lamlakki khoihina oirammi. ");
INSERT INTO mni_vpl VALUES ("MT3_5","070_3_5","MAT","3","5","5","Aduga Jerusalem-gi mising yaona Judea apumbadagi amadi Jordan turen-gi akoibada leiba mapham pumnamaktagi miyam thoklaktuna mahakpu yengnaba amasung mahakki wahei tananaba laklammi. ");
INSERT INTO mni_vpl VALUES ("MT3_6","070_3_6","MAT","3","6","6","Aduga makhoina makhoigi mapapsing haidokcharabada, John-na makhoibu Jordan turenda baptize loubirammi. ");
INSERT INTO mni_vpl VALUES ("MT3_7","070_3_7","MAT","3","7","7","Adubu Pharisee amasung Sadducee mayam amana mahakna baptize touba aduda lakpa ubada, mahakna makhoida hairak-i, “He lilgi chada naodasa, lakkadouriba Tengban Mapugi asaoba adudagi chennanaba nakhoida kanana haibage? ");
INSERT INTO mni_vpl VALUES ("MT3_8","070_3_8","MAT","3","8","8","Nakhoina paptagi pukning hongbagi matik chaba mahei yallu. ");
INSERT INTO mni_vpl VALUES ("MT3_9","070_3_9","MAT","3","9","9","Aduga ‘Eikhoigi ipa Abraham lei’ hairaga cheirak adudagi nanthokkani haina khan-ganu. Maramdi eina nakhoida hairi madudi nungsing asidagisu Tengban Mapuna Abraham-gi machasing thok-hanba ngammi. ");
INSERT INTO mni_vpl VALUES ("MT3_10","070_3_10","MAT","3","10","10","Houjiksu upalsing asigi makhongda yanthatnabagidamak singjang thourang touduna lei, amasung aphaba mahei yandaba upal khudingmak yanthattuna meinungda langsingani. ");
INSERT INTO mni_vpl VALUES ("MT3_11","070_3_11","MAT","3","11","11","Pukning hongbagidamak eina nakhoibu isingda baptize toubi, adubu eigi itungda lenglakliba Ibungo mahakna eingondagi henna matik chaoba helli. Eidi mahakki sandal puba phaoba matik chade. Aduga mahaknadi nakhoibu Thawai Asengbada amasung meida baptize toubigani. ");
INSERT INTO mni_vpl VALUES ("MT3_12","070_3_12","MAT","3","12","12","Ibungona magi phou-inthok paiduna gehudagi mahamsing khaidoknaba thourang touduna leiri. Adudagi mahakna mahei marong yeipham adu sengdoktuna gehusing adubu keida peisin-gani, adubu mahamsing adubudi mutpa naidaba meida thajin-gani.” ");
INSERT INTO mni_vpl VALUES ("MT3_13","070_3_13","MAT","3","13","13","Adudagi Jisuna John-dagi baptize lounabagidamak Galilee thadoktuna Jordan-da laklammi. ");
INSERT INTO mni_vpl VALUES ("MT3_14","070_3_14","MAT","3","14","14","Adubu John-na mahakpu khamladuna hairak-i; “Ibungona eihakpudum baptize toubipham thok-i, aduga Ibungona oina eigi inakta lengbiraklabra?” ");
INSERT INTO mni_vpl VALUES ("MT3_15","070_3_15","MAT","3","15","15","Jisuna mangonda khumlak-i, “Houjikki oinadi asumna oirasanu; maramdi matou asumna eikhoina achumba chatpagi thabak pumnamak adu mapung phahanba matik chabani.” Maduda John-na mahakpu baptize toubada yajare. ");
INSERT INTO mni_vpl VALUES ("MT3_16","070_3_16","MAT","3","16","16","Aduga Jisuna baptize louraba tungda, isingdagi hek karakpaga, yeng-u, nongmadon atiya hangdoktuna Tengban Mapugi Thawaina Ibungogi mathakta khunugumna lengtharakpa mahakna ure. ");
INSERT INTO mni_vpl VALUES ("MT3_17","070_3_17","MAT","3","17","17","Aduga swargadagi khonjel amana asumna hairak-i, “Mahak eigi nungsijaraba Ichanupani, mangonda eina yamna pelle.” ");
INSERT INTO mni_vpl VALUES ("MT4_1","070_4_1","MAT","4","1","1","Adudagi Devil-na Jisubu themnanaba Thawai Asengbana mahakpu lamjao lamhangda puthoklammi. ");
INSERT INTO mni_vpl VALUES ("MT4_2","070_4_2","MAT","4","2","2","Amasung Jisuna ahing nungthil numit niphuni chara hellaklabada mapuk lamlaklammi. ");
INSERT INTO mni_vpl VALUES ("MT4_3","070_4_3","MAT","4","3","3","Aduga athemba mapu aduna Ibungogi nakta laktuna hairak-i, “Nahakna Tengban Mapugi Machanupa oirabadi, nung-sing asi tal onnaba yathang piyu.” ");
INSERT INTO mni_vpl VALUES ("MT4_4","070_4_4","MAT","4","4","4","Maduda Ibungona mangonda khumlak-i, “Mapugi Puyana asumna hai, ‘Tal khaktagi mapanna mioibana hingloi, adubu Tengban Mapugi chindagi thoklakpa wahei khudinggi mapanna hinggani.’ ” ");
INSERT INTO mni_vpl VALUES ("MT4_5","070_4_5","MAT","4","5","5","Adudagi Devil-na Jisubu asengba sahar, Jerusalem-da pure, aduga mahakpu Mapugi sanglen-gi khwaidagi wangba matonda lep-halle. ");
INSERT INTO mni_vpl VALUES ("MT4_6","070_4_6","MAT","4","6","6","Aduga mahakna hairak-i, “Nahakna Tengban Mapugi Machanupa oirabadi, nasa nathanta chongthajou; maramdi Mapugi Puyada asumna iduna lei, ‘Tengban Mapuna mahakki dutsingda nanggi maramda yathang pibigani; Aduga, Nahakki khong phaoba nungda yeisindanabagidamak makhoigi khutna nahakpu pamkhatpigani.’ ” ");
INSERT INTO mni_vpl VALUES ("MT4_7","070_4_7","MAT","4","7","7","Maduda Jisuna mangonda hairak-i, “Mapugi Puyada asumnasu iduna lei, ‘Nahakna nahakki Tengban Mapu, MAPU IBUNGO-bu chang yengloidabani.’ ” ");
INSERT INTO mni_vpl VALUES ("MT4_8","070_4_8","MAT","4","8","8","Adudagi Devil-na Jisubu amukka awangba chingthak amada pukhatle aduga mangonda taibangpan asigi ningthou leibak pumnamak amadi makhoigi matik mangal pumnamak uhalle. ");
INSERT INTO mni_vpl VALUES ("MT4_9","070_4_9","MAT","4","9","9","Aduga Devil-na Ibungoda hairak-i, “Nahakna eingonda khuru khudak kunduna khurumjarabadi, eina nangonda pumnamaksing asi pibigani.” ");
INSERT INTO mni_vpl VALUES ("MT4_10","070_4_10","MAT","4","10","10","Maduda Jisuna mangonda hairak-i, “Inaktagi chathokkhro, Satan! Mapugi Puyada asumna iduna lei, ‘Nahakna nahakki Tengban Mapu, MAPU IBUNGO khaktabu khurumjagadabani amasung thouganjagadabani!’ ” ");
INSERT INTO mni_vpl VALUES ("MT4_11","070_4_11","MAT","4","11","11","Adudagi Devil-na Ibungobu thadoktuna chatkhirammi, amasung swargadutsing laktuna Ibungobu thougal tourammi. ");
INSERT INTO mni_vpl VALUES ("MT4_12","070_4_12","MAT","4","12","12","John-bu keisumsangda thamkhre haiba Jisuna tarabada, mahakna Judea-dagi Galilee-da halaklammi. ");
INSERT INTO mni_vpl VALUES ("MT4_13","070_4_13","MAT","4","13","13","Aduga mahakna Nazareth-ta hanna chatlaba tungda Capernaum-da laktuna leirammi. Capernaum asi Zebulun amasung Naphtali-gi lamda leiba, Galilee patki mapanda leiba khunni. ");
INSERT INTO mni_vpl VALUES ("MT4_14","070_4_14","MAT","4","14","14","Masina Tengban Mapugi wa phongdokpa maichou Isaiah-na haikhiba wa adu thunghalle: ");
INSERT INTO mni_vpl VALUES ("MT4_15","070_4_15","MAT","4","15","15","“Zebulun-gi lamdam amadi Naphtali-gi lamdam, pat taba lambida, Jordan turen-gi wangmada leiriba, atoppa phurupsinggi Galilee! ");
INSERT INTO mni_vpl VALUES ("MT4_16","070_4_16","MAT","4","16","16","Amambada leiriba mising aduna achouba mangal ama ujare; asibagi amamba lamdamda leiriba makhoising adugi mathakta mangal aduna ngallare.” ");
INSERT INTO mni_vpl VALUES ("MT4_17","070_4_17","MAT","4","17","17","Matam adudagi houna Jisuna pao sandokpa houraduna hai, “Nakhoina paptagi pukning hong-u, maramdi swarga leibak adu naksillakle.” ");
INSERT INTO mni_vpl VALUES ("MT4_18","070_4_18","MAT","4","18","18","Nongma Jisuna Galilee-gi pat mapanda chatlingeida Peter kouba Simon amasung mahakki manao Andrew, makhoi machin-manao anina pat aduda in hunduna leiramba adu ure. Maramdi makhoi nga phaba mising oirammi. ");
INSERT INTO mni_vpl VALUES ("MT4_19","070_4_19","MAT","4","19","19","Aduga Jisuna makhoida hairak-i, “Lak-u, eigi itung illu, eina nakhoibu mi phabasing oihan-gani.” ");
INSERT INTO mni_vpl VALUES ("MT4_20","070_4_20","MAT","4","20","20","Khudak adumaktada makhoina makhoigi in-sing adu thanamduna Ibungogi tung-injare. ");
INSERT INTO mni_vpl VALUES ("MT4_21","070_4_21","MAT","4","21","21","Adudagi Ibungona mapham adudagi asum lakpada machin manao ani, haibadi Zebedeegi macha Jacob amadi mahakki manao John-bu ure. Makhoina makhoigi hida mapa Zebedee-ga loinana, makhoigi in-sing semjin-sajinduna leirammi. Amasung Ibungona makhoibu kourammi. ");
INSERT INTO mni_vpl VALUES ("MT4_22","070_4_22","MAT","4","22","22","Maduda makhoina khudak aduda hi amasung mapabu thadoklamlaga Ibungogi matung injakhi. ");
INSERT INTO mni_vpl VALUES ("MT4_23","070_4_23","MAT","4","23","23","Adudagi Jisuna synagogue-singda tambiduna, Ningthou leibakki maramda aphaba pao sandokladuna amadi makhal khudinggi laina amadi anabasingbu phahanbiduna Galilee-gi mapham sinba thungna chatlammi. ");
INSERT INTO mni_vpl VALUES ("MT4_24","070_4_24","MAT","4","24","24","Aduga Ibungogi paona Syria sinba thunglammi. Amasung mahakki manakta misingna makhal kayagi lainana naraba pumnamak haibadi akanba cheina khaanglibasing, lai phattaba changbasing, sarei houbasing, aduga pangtha-sithaduna naba pumnamakpu puraklammi. Aduga Ibungona makhoi pumnamakpu phahanbirammi. ");
INSERT INTO mni_vpl VALUES ("MT4_25","070_4_25","MAT","4","25","25","Aduga Galilee, Decapolis, Jerusalem, Judea amadi Jordan turen wangmadagi yamlaba miyamsingna Ibungogi matung injare. ");
INSERT INTO mni_vpl VALUES ("MT5_1","070_5_1","MAT","5","1","1","Adudagi Jisuna yamlaba miyam adu ubada chingthakta kakhattuna phamlammi. Aduga mahakki tung-inbasing aduna mahakki manakta tillarabada, ");
INSERT INTO mni_vpl VALUES ("MT5_2","070_5_2","MAT","5","2","2","Ibungona makhoibu tambiba houre: ");
INSERT INTO mni_vpl VALUES ("MT5_3","070_5_3","MAT","5","3","3","“Thawai tonbasing adu yaiphabani; maramdi swarga leibak adu makhoigini. ");
INSERT INTO mni_vpl VALUES ("MT5_4","070_5_4","MAT","5","4","4","Tengtha naoiribasing adu yaiphabani; maramdi Tengban Mapuna makhoibu harao nungaihanbigani! ");
INSERT INTO mni_vpl VALUES ("MT5_5","070_5_5","MAT","5","5","5","Pukning tappasing adu yaiphabani; maramdi makhoina malem asi phangjagani. ");
INSERT INTO mni_vpl VALUES ("MT5_6","070_5_6","MAT","5","6","6","Achumba chatpagidamak aram khouranglibasing adu yaiphabani; maramdi Tengban Mapuna makhoibu thalhanbigani! ");
INSERT INTO mni_vpl VALUES ("MT5_7","070_5_7","MAT","5","7","7","Chanbiheibasing adu yaiphabani; maramdi Tengban Mapuna makhoibu chanbigani! ");
INSERT INTO mni_vpl VALUES ("MT5_8","070_5_8","MAT","5","8","8","Thamoi sengbasing adu yaiphabani; maramdi makhoina Tengban Mapubu ujagani! ");
INSERT INTO mni_vpl VALUES ("MT5_9","070_5_9","MAT","5","9","9","Ingthaba puraknabagi thabak touribasing adu yaiphabani; maramdi makhoibu Tengban Mapugi machasing kougani! ");
INSERT INTO mni_vpl VALUES ("MT5_10","070_5_10","MAT","5","10","10","Achumba chatpagidamak otpi neibiba phanglibasing adu yaiphabani; maramdi Tengban Mapugi leibak adu makhoigini! ");
INSERT INTO mni_vpl VALUES ("MT5_11","070_5_11","MAT","5","11","11","“Eigi maramgidamak misingna nakhoibu ikaiba piduna cheiraba, ot-neiraba amadi nakhoigi nathakta phattaba pumnamak thangjillabada, nakhoi yaiphabani. ");
INSERT INTO mni_vpl VALUES ("MT5_12","070_5_12","MAT","5","12","12","Madugidamak nakhoi haraojou amasung thoidok hendokna nungaijou! Maramdi swargada nakhoigi mana chao-i. Aduga matou asumna nakhoigi namangda leiramba Tengban Mapugi wa phongdokpa maichousingbu makhoina ot-neikhi. ");
INSERT INTO mni_vpl VALUES ("MT5_13","070_5_13","MAT","5","13","13","“Nakhoidi taibangpan-gi thumni. Adubu thum aduna magi mahao mangkhrabadi, nakhoina madubu karamna mahao amuk leihan-gadage? Adunadi madu mapanda hundoktuna misinggi makhongna netpa nattana atei karisu kanadre. ");
INSERT INTO mni_vpl VALUES ("MT5_14","070_5_14","MAT","5","14","14","“Nakhoidi taibangpan-gi mangalni. Chingthakta leiba sahar lotpa yade. ");
INSERT INTO mni_vpl VALUES ("MT5_15","070_5_15","MAT","5","15","15","Aduga misingna thaomei thallaga thumok makhada thamnade; adubu thaomei makhong mathakta thamduna yum manungda leiba pumnamakpu ngalhalli. ");
INSERT INTO mni_vpl VALUES ("MT5_16","070_5_16","MAT","5","16","16","Matou asumna, misingna nakhoigi aphaba thabaksing adu swargada leiba nakhoigi Napa Ibungobu thagatnanaba nakhoigi mangal adu misinggi mangda ngalhallu. ");
INSERT INTO mni_vpl VALUES ("MT5_17","070_5_17","MAT","5","17","17","“Eina Moses-ki Wayel Yathang nattraga Tengban Mapu wa phongdokpiba maichousingna tambibasing adu mang-hanba lakpani haina khan-ganu. Eidi madu manghanba lakpa natte, adubu thunghanba lakpani. ");
INSERT INTO mni_vpl VALUES ("MT5_18","070_5_18","MAT","5","18","18","Eina nakhoida tasengnamak hairibasini, swarga amasung malem mangdriba phaoba Wayel Yathang adugi khwaidagi pikpa mayek nattraga khwaidagi pikpa saruk ama phaoba, pumnamak aduna thungdriphaoba mangloi. ");
INSERT INTO mni_vpl VALUES ("MT5_19","070_5_19","MAT","5","19","19","Aduga kanagumbana hairiba yathangsing asidagi apikpa yathang amabu thugairaba amasung madumak tounanaba misingda tambirabadi swarga leibakta mahakpu khwaidagi apikpa kougani. Adubu kanagumbana Wayel Yathang injaraga madumak misingda tounanaba tambirabadi, swarga leibakta mahakpu achouba kougani. ");
INSERT INTO mni_vpl VALUES ("MT5_20","070_5_20","MAT","5","20","20","Aduga eina nakhoida hairi, karigumba nakhoigi achumba chatpa aduna Wayel Yathanggi ojasing amadi Pharisee-sing adudagi hendrabadi, nakhoina swarga leibakta keidounungdasu changloi. ");
INSERT INTO mni_vpl VALUES ("MT5_21","070_5_21","MAT","5","21","21","“Mamangngeida eikhoigi ipa-ipusingda, ‘Nahakna mi hatloidabani aduga kanagumbana mi hatlabadi mahakna wayenbagi awabada tagani’ haina haikhiba adu nakhoina tare. ");
INSERT INTO mni_vpl VALUES ("MT5_22","070_5_22","MAT","5","22","22","Adubu eina nakhoida hairibasini, kanagumba amana magi machin-manaogi mathakta saorabadi, wayen-gi awabada tagani. Aduga amuksu, kanagumbana magi machin manaoda ‘Raca’ haina hairabadi mahakna sanhedrin-gi mamangda pukhatpagi khudongthiba adu nanggani. Amasung kanagumbana mahakki machin manaoda ‘Apang mirem’ hairabadi mahakna norokki meigi awabada tagani. ");
INSERT INTO mni_vpl VALUES ("MT5_23","070_5_23","MAT","5","23","23","Maram aduna nahakna Tengban Mapuda katchanaba nahakki iratpot adu latnapungda purakpa matamda nahakki nachin-nanao amana nahakki nathakta nungaitaba leiba adu ningsinglaklabadi, ");
INSERT INTO mni_vpl VALUES ("MT5_24","070_5_24","MAT","5","24","24","Nahakki iratpot adu latnapung adugi mamangda thanamduna, nahakki nachin-nanao adugi manakta hanna chattuna mahakka taisinnaru. Aduga nahakna halaktuna nahakki iratpot adu katlu. ");
INSERT INTO mni_vpl VALUES ("MT5_25","070_5_25","MAT","5","25","25","“Nahakki maiyokta leiriba mahakka loinana nahakna wayelsang tamna lambida chatlingeida, thunamak mahakka chamthoknou, adu nattrabadi mahakna nahakpu wayel mapuda pithokpa yai, aduga wayel mapuna nahakpu phamnaibada sinaduna nahakpu keisumsangda thajinba yai. ");
INSERT INTO mni_vpl VALUES ("MT5_26","070_5_26","MAT","5","26","26","Eina nakhoida tasengnamak hairibasini, nahakna sendon adu loina singdoktriphaoba mapham adudagi khak thorakpa yaroi. ");
INSERT INTO mni_vpl VALUES ("MT5_27","070_5_27","MAT","5","27","27","“ ‘Nahakna atoppagi nupa nattraga nupiga lannabagi thabak touroidabani’ haikhiba asi nakhoina tare. ");
INSERT INTO mni_vpl VALUES ("MT5_28","070_5_28","MAT","5","28","28","Adubu eina nakhoida hairibasini, kanagumbana nupi amabu apambana sumhattuna yenglabadi mahakki thamoida nupi aduga lannabagi thabak toukhrabani. ");
INSERT INTO mni_vpl VALUES ("MT5_29","070_5_29","MAT","5","29","29","Aduga karigumba nahakki yetthangba mitna nahakpu papta tahallabadi, madu kothoktuna nangondagi langthok-u; maramdi nahakki hakchang apumba norokta langsinkhigadabagi sarukpudi, nahakki hakchanggi kayat ama mangkhibana nahakkidamak henna phei. ");
INSERT INTO mni_vpl VALUES ("MT5_30","070_5_30","MAT","5","30","30","Aduga nahakki yetthangba khutna nahakpu papta tahallabadi madu kakthattuna langthok-u; maramdi nahakki hakchang apumba norokta chatkadabagi sarukpudi, nahakki hakchang kayat ama mangkhibana nahakkidamak henna phei. ");
INSERT INTO mni_vpl VALUES ("MT5_31","070_5_31","MAT","5","31","31","“Aduga masimasu haikhre, ‘Kanagumbana mahakki nupibu khainarabadi mahakki nupida khainabagi che adu pigadabani.’ ");
INSERT INTO mni_vpl VALUES ("MT5_32","070_5_32","MAT","5","32","32","Adubu eina nakhoida hairibasini, lannabagi thabak toubagi maramgidamak nattana kanagumbana mahakki nupibu khainarabadi, mahakna nupi adu nupa lannahallabani; aduga kanagumbana khainarabi nupi aduga luhonglabadi, mahakna nupi lannabagi thabak tourabani. ");
INSERT INTO mni_vpl VALUES ("MT5_33","070_5_33","MAT","5","33","33","“Eikhoigi ipa-ipusingda haikhiba asimasu nakhoina tare, ‘Nahakna lanna wasakloidabani, adubu nahakna MAPU IBUNGO-da sakkhiba wasaksing adu ngakkadabani.’ ");
INSERT INTO mni_vpl VALUES ("MT5_34","070_5_34","MAT","5","34","34","Adubu eina nakhoida hairibasini, nakhoina keidounungda khak wasakloidabani: Nakhoina swarga panduna wasakkanu, maramdi swargadi Tengban Mapugi phambalni. ");
INSERT INTO mni_vpl VALUES ("MT5_35","070_5_35","MAT","5","35","35","Malem pandunasu wasakkanu, maramdi malemdi Tengban Mapugi khongnetphamni; Jerusalem pandunasu wasakkanu, maramdi Jerusalem-di wangthoiraba Ningthou adugi saharni. ");
INSERT INTO mni_vpl VALUES ("MT5_36","070_5_36","MAT","5","36","36","Aduga nahakki nakok panjadunasu wasakkanu, maramdi nahakna samna ama phaoba ngouhanba nattraga muhanba ngamde. ");
INSERT INTO mni_vpl VALUES ("MT5_37","070_5_37","MAT","5","37","37","Adubu nakhoina ‘Hoi’ hairaga hoi, nattraga ‘Mai’ hairaga mai haiyu; masidagi henba makheidi Phattabagi mapu adudagi lakpani. ");
INSERT INTO mni_vpl VALUES ("MT5_38","070_5_38","MAT","5","38","38","“ ‘Mit amagi mahutta mit ama, aduga ya amagi mahutta ya ama’ haiba adu nakhoina tare. ");
INSERT INTO mni_vpl VALUES ("MT5_39","070_5_39","MAT","5","39","39","Adubu eina nakhoida hairibasini; nakhoida lallakpa mahak aduda laman singganu. Adubu kanagumbana nahakki yetthangba khajaida khubakna tharaklabadi, nahakki oithangba khajai adusu onsillu. ");
INSERT INTO mni_vpl VALUES ("MT5_40","070_5_40","MAT","5","40","40","Aduga kanagumbana nahakki phurit adu louningbagidamak wayelsangda wakatlaklabadi, mahakna nahakki achonba phurit adusu loujasanu. ");
INSERT INTO mni_vpl VALUES ("MT5_41","070_5_41","MAT","5","41","41","Aduga kanagumbana nahakpu namduna mile ama chatnaba hairabadi, mahakka loinana mile ani chatminnou. ");
INSERT INTO mni_vpl VALUES ("MT5_42","070_5_42","MAT","5","42","42","Nangonda nijaba mahak aduda pinou, aduga nangondagi pujaningba mahak adudagi leithokkanu. ");
INSERT INTO mni_vpl VALUES ("MT5_43","070_5_43","MAT","5","43","43","“Aduga ‘Nahakna nahakki keiroi leikaibu nungsiyu, aduga nahakki yeknabasingbu yengthiyu,’ haiba asi nakhoina takhre. ");
INSERT INTO mni_vpl VALUES ("MT5_44","070_5_44","MAT","5","44","44","Adubu eina nakhoida hairi, Nakhoina yeknabasingbu nungsiyu, nakhoibu sirap toubasingbu yaipha-thoujal pibiyu, nakhoibu yengthibasingda aphaba toubiyu aduga nakhoibu thaoi-usitana sijinnariba amasung ot-neiribasingidamak haijabiyu. ");
INSERT INTO mni_vpl VALUES ("MT5_45","070_5_45","MAT","5","45","45","Masi nakhoina swargada leiba nakhoigi Napa Ibungogi machasing oinabagidamakni. Maramdi Ibungo mahakna phattaba amasung aphaba misinggi mathakta numit thok-hanbi. Aduga achumba chatpa amasung phattaba toubasinggi mathakta nong chuhanbi. ");
INSERT INTO mni_vpl VALUES ("MT5_46","070_5_46","MAT","5","46","46","Maramdi nakhoibu nungsibibasing adu khaktabu nakhoina nungsirabadi, nakhoigi kari mana leigadage? Kanggat khombasing aduna phaoba adumna touba nattra? ");
INSERT INTO mni_vpl VALUES ("MT5_47","070_5_47","MAT","5","47","47","Aduga nakhoina nakhoigi nachin-nanaosing khaktada taram-taramna tourabadi, atoppasingdagi nakhoina kari henna touribage? Tengban Mapubu thajadabasingna phaoba adumna touba nattra? ");
INSERT INTO mni_vpl VALUES ("MT5_48","070_5_48","MAT","5","48","48","Maram aduna swargada leiba nakhoigi Napa Ibungona mapung phaba adugumna nakhoisu mapung phaba oiyu.” ");
INSERT INTO mni_vpl VALUES ("MT6_1","070_6_1","MAT","6","1","1","“Nakhoina aphaba thabaksing touba matamda misingda utnabagidamakta toudanaba cheksillu. Madu nattrabadi swargada leiba nakhoigi Napa Ibungogi maphamdagi nakhoigi mana phangloi. ");
INSERT INTO mni_vpl VALUES ("MT6_2","070_6_2","MAT","6","2","2","“Maram aduna misingdagi thagatpa phangnanabagidamak aphasasinnabasingna synagogue-sing amasung lambisingda toubagumna, nakhoina leita lairasingda piba matamda namangda pungjao thin-ganu. Eina nakhoida tasengnamak hairibasini, makhoina makhoigi phangadaba mana adu loina phangkhre. ");
INSERT INTO mni_vpl VALUES ("MT6_3","070_6_3","MAT","6","3","3","Adubu nangna leita-lairasingda mateng pangba matamda, nanggi yetthangba khutna touba adu oi thangba khutna khangdasanu. ");
INSERT INTO mni_vpl VALUES ("MT6_4","070_6_4","MAT","6","4","4","Masi nanggi pibagi thabak adu aronba oinabani. Aduga aronba pumnamakpu uriba nahakki Ipana nangonda mana pibigani. ");
INSERT INTO mni_vpl VALUES ("MT6_5","070_6_5","MAT","6","5","5","“Aduga nahakna haijaba matamda, aphasasinnabasinggumna oiganu; maramdi makhoibu misingna unanaba, makhoina synagogue-sing amasung miyam tinba lambisingda leptuna haijabadu pammi. Eina nakhoida tasengnamak hairibasini, makhoina makhoigi phangadaba mana loina phangkhre. ");
INSERT INTO mni_vpl VALUES ("MT6_6","070_6_6","MAT","6","6","6","Adubu nahakti, nahakna haijaba matamda nanggi kada chang-u, aduga thong thingjinduna lonna leiba nahakki Napada haijou. Aduga aronba pumnamakpu ubiba nahakki Ipana nangonda mana pibigani.” ");
INSERT INTO mni_vpl VALUES ("MT6_7","070_6_7","MAT","6","7","7","“Aduga nakhoina haijaba matamda, Tengban Mapubu thajadabasinggumna arembada hanjin hanjin haijaganu, maramdi makhoina wahei mayam ama haibagi maramna makhoigi haijaba adu tabigani haina makhoina khalli. ");
INSERT INTO mni_vpl VALUES ("MT6_8","070_6_8","MAT","6","8","8","Adubu nakhoidi makhoigumna oiganu; maramdi nakhoina nijadringeigi mamangda nakhoigi awatpa leiba adu nakhoigi Ipana khangbi. ");
INSERT INTO mni_vpl VALUES ("MT6_9","070_6_9","MAT","6","9","9","Maram aduna nakhoina matou asumna haijou, ‘Swargada leiba eikhoigi Ipa, Ibungo Nahakki ming asengba oisanu. ");
INSERT INTO mni_vpl VALUES ("MT6_10","070_6_10","MAT","6","10","10","Nahakki leibak laksanu; swargada nahakna ningba toubagumna taibangpanda oisanu. ");
INSERT INTO mni_vpl VALUES ("MT6_11","070_6_11","MAT","6","11","11","Numit asigi nongmagi chara eikhoida pinabiyu. ");
INSERT INTO mni_vpl VALUES ("MT6_12","070_6_12","MAT","6","12","12","Aduga eikhoida laman tonbasingbu eikhoina kokpibagumna, eikhoigi laman kokpiyu. ");
INSERT INTO mni_vpl VALUES ("MT6_13","070_6_13","MAT","6","13","13","Aduga eikhoibu athembada tahanbiganu, adubu phattaba adudagi eikhoibu kanbiyu. Maramdi ningthou leibak, panggal amasung matik mangal lomba naidana nahakkini. Amen.’ ");
INSERT INTO mni_vpl VALUES ("MT6_14","070_6_14","MAT","6","14","14","“Maramdi nakhoigi nathakta misingna tourakpa ayol-aransing adu nakhoina kokpirabadi, nakhoigi swargada leiba Napa Ibungonasu nakhoibu kokpigani. ");
INSERT INTO mni_vpl VALUES ("MT6_15","070_6_15","MAT","6","15","15","Adubu nakhoina misinggi ayol-aran kokpidrabadi, nakhoigi Napa Ibungona nakhoigi ayol-aransing adu kokpiroi.” ");
INSERT INTO mni_vpl VALUES ("MT6_16","070_6_16","MAT","6","16","16","“Aduga nakhoina chara henba matamda, aphasasinnaba misinggi matougumna awa-maithong utkanu, maramdi makhoina chara helli haiba adu misingda utnanaba makhoigi maithong adu maksilhalli. Eina nakhoida tasengnamak hairibasini, makhoina makhoigi phangadaba mana loina phangkhre. ");
INSERT INTO mni_vpl VALUES ("MT6_17","070_6_17","MAT","6","17","17","Adubu nahakti chara henba matamda, namai-namit tathoktuna nakoktu thao teisillu. ");
INSERT INTO mni_vpl VALUES ("MT6_18","070_6_18","MAT","6","18","18","Masi nahakna chara helli haibadu misingna khangdananaba adubu lonna leiba nahakki Napa Ibungo khaktana khangnanabani. Aduga lonna toujaba adubu ubiba nahakki Napa Ibungona nangonda mana pibigani. ");
INSERT INTO mni_vpl VALUES ("MT6_19","070_6_19","MAT","6","19","19","“Til-kang amadi kolhingna manghanba aduga huranbasingna sagun touduna huranba malem asida nakhoigidamak lan peisin-ganu. ");
INSERT INTO mni_vpl VALUES ("MT6_20","070_6_20","MAT","6","20","20","Adubu til-kang amadi kolhingna manghanba ngamdraba, aduga huranbasingnasu huba ngamdraba swargada nakhoigidamak lan peisillu. ");
INSERT INTO mni_vpl VALUES ("MT6_21","070_6_21","MAT","6","21","21","Maramdi nahakki lan leiba mapham aduda nahakki thamoisu leigani. ");
INSERT INTO mni_vpl VALUES ("MT6_22","070_6_22","MAT","6","22","22","“Mit haibasina hakchanggidi thaomeiga pangkhakni. Maram aduna nahakki mityeng chumlagadi, nahakki hakchang apumba mangalna than-gani. ");
INSERT INTO mni_vpl VALUES ("MT6_23","070_6_23","MAT","6","23","23","Adubu nahakki mityeng chumdrabadi, nahakki hakchang apumba amambana than-gani. Aduga nangonda leiba mangal aduna mamlabadi, amamba adu kayada mamkhraba. ");
INSERT INTO mni_vpl VALUES ("MT6_24","070_6_24","MAT","6","24","24","“Kananasu mapu anigi minai oiba ngamde; maramdi mahakna amabu tukkacharaga atoppa amabuna nungsigani, nattraga mahakna amabu ninglaga atoppa amabuna thou-oiroi. Asumna nakhoina Tengban Mapu amasung lan animakpu thougal touba ngamloi. ");
INSERT INTO mni_vpl VALUES ("MT6_25","070_6_25","MAT","6","25","25","“Maram aduna eina nakhoida tasengnamak hairibasini, nakhoina hingnabagidamak kari chagani, kari thakkani nattraga hakchanggidamak kari setkani haibagidamak karisu langtaknaganu. Thawaina chinjaktagi aduga hakchangna phijettagi henna maru oidra? ");
INSERT INTO mni_vpl VALUES ("MT6_26","070_6_26","MAT","6","26","26","Atiyagi ucheksingda yeng-u; makhoina marusu hunde, loksu lokte, aduga kei-dasu peisinde. Adumakpu nakhoigi swargada leiba Ipana makhoida chananaba machinjak pibi. Nakhoidi makhoisingdagi yamna henna mamal yamba nattra? ");
INSERT INTO mni_vpl VALUES ("MT6_27","070_6_27","MAT","6","27","27","Aduga nakhoi kanana langtaknaduna nakhoigi punsibu pungja ama sangdok-hanba ngambage? ");
INSERT INTO mni_vpl VALUES ("MT6_28","070_6_28","MAT","6","28","28","“Aduga nakhoina phijetkidamak karigi langtaknaribage? Loubuk-lamhangda houba tharosingna, karamna houriba haibadu yeng-u. Makhoina thabaksu nomde, langsu naide. ");
INSERT INTO mni_vpl VALUES ("MT6_29","070_6_29","MAT","6","29","29","Adubu eina nakhoida hairibasini, Ningthou Solomonmak-na mahakki matik mangal pumnamakka loinana phijet leitenglabasu leising asina phajaba asigumna phijet leitengkhide. ");
INSERT INTO mni_vpl VALUES ("MT6_30","070_6_30","MAT","6","30","30","Aduga ngasidi houriba, hayengdi meinungda hunjinkhragadaba loubukki napi phaoba Tengban Mapuna asuk ningthijana phijet leitengbirabadi, he thajaba watpasa, mahakna nakhoibu kaya ningthijana phijet leitengbiroidra? ");
INSERT INTO mni_vpl VALUES ("MT6_31","070_6_31","MAT","6","31","31","“Maram aduna eikhoina kari chagani, nattraga kari thakkani, nattraga kari setkani haiduna langtaknaganu. ");
INSERT INTO mni_vpl VALUES ("MT6_32","070_6_32","MAT","6","32","32","Maramdi Tengban Mapubu thajadabasingna pot pumnamaksing asi thi, adubu swargada leiba nakhoigi Ipana pot pumnamaksing asi nakhoida mathou tai haiba khang-bi. ");
INSERT INTO mni_vpl VALUES ("MT6_33","070_6_33","MAT","6","33","33","Adubu nakhoina ahanbada Tengban Mapugi leibak amasung Ibungo mahakna nakhoida touhaningba achumba thabaksing adu thiyu, aduga pot pumnamaksing asi nakhoida pinabigani. ");
INSERT INTO mni_vpl VALUES ("MT6_34","070_6_34","MAT","6","34","34","Maram aduna nakhoina hayenggidamak langtaknaganu, maramdi hayengsu hayeng masagi langtaknaba adumak leijagani. Aduna nongmagi waruba aduna numit adugidi awokpani. ");
INSERT INTO mni_vpl VALUES ("MT7_1","070_7_1","MAT","7","1","1","“Nakhoibu Tengban Mapuna wayendanaba nakhoina misingbu wayelluganu. ");
INSERT INTO mni_vpl VALUES ("MT7_2","070_7_2","MAT","7","2","2","Maramdi nakhoina misingbu wayelluba matou adugumna Tengban Mapunasu nakhoibu wayen-gani, aduga nakhoina olluriba chang adumak nakhoidasu amuk ollagani. ");
INSERT INTO mni_vpl VALUES ("MT7_3","070_7_3","MAT","7","3","3","Aduga nahakki namitta leiba ujao adudi karisu khandraga nahakki nachin nanaogi mamitta leiba u makup aduda karigi yenglibano? ");
INSERT INTO mni_vpl VALUES ("MT7_4","070_7_4","MAT","7","4","4","Aduga nahakki namitta ujao ama leina leina nahakki nachin nanaoda, ‘Nahakki mitta leiba u makup adu ei louthokpige,’ haina nahakna karamna haigadouribano? ");
INSERT INTO mni_vpl VALUES ("MT7_5","070_7_5","MAT","7","5","5","He, aphasasinnaba! Nahakna nahak nasamakki namitta leiba ujao adu hanna louthokkho, adu oirabadi nahakna nahakki nachin-nanaogi mitta leiba u makup adu louthokpada sengna ugani. ");
INSERT INTO mni_vpl VALUES ("MT7_6","070_7_6","MAT","7","6","6","“Huisingda asengba pot piganu, Aduga oksinggi mangda nakhoigi mani-mukta langsin-ganu, maramdi makhoigi makhongna madu netsillaga onsillaktuna nakhoibu machet machet segaigani. ");
INSERT INTO mni_vpl VALUES ("MT7_7","070_7_7","MAT","7","7","7","“Nijou, nakhoida pibigani; thijou, nakhoina phangjagani; thong thinjou, nakhoigidamak hangdokpigani. ");
INSERT INTO mni_vpl VALUES ("MT7_8","070_7_8","MAT","7","8","8","Maramdi nijaba mi khudingna phangjei, thijaba mahak aduna phangjei, aduga thong thinjaba mahak aduda hangdokpigani. ");
INSERT INTO mni_vpl VALUES ("MT7_9","070_7_9","MAT","7","9","9","Nakhoigi narakta mapa oiriba nakhoi kanana nachasingna tal niba matamda makhoida nung oina pigadage? ");
INSERT INTO mni_vpl VALUES ("MT7_10","070_7_10","MAT","7","10","10","Nattraga nga niraga madugi mahutta lil oina pigadage? ");
INSERT INTO mni_vpl VALUES ("MT7_11","070_7_11","MAT","7","11","11","Nakhoina phattaba oidunasu nachasingda karamna aphaba khudol pigadage haiba khanglabadi, swargada leiba nakhoigi Ipana mangonda nijaba makhoising aduda kayada thoidok hendokna aphaba khudolsing pibiroidage? ");
INSERT INTO mni_vpl VALUES ("MT7_12","070_7_12","MAT","7","12","12","“Maram aduna misingna nakhoida toubirakpa pamba pumnmak adu nakhoinasu makhoida tou. Maramdi masida Wayel Yathang amasung Tengban Mapugi wa phongdokpiba maichousinggi wa pumnamak adu suplabani.” ");
INSERT INTO mni_vpl VALUES ("MT7_13","070_7_13","MAT","7","13","13","“Nakhoina akhuba thong aduda chang-u, maramdi amang-atada tanaba thong adu lao-i, amasung lambi adu pak-i, aduga maduda changba mi yammi. ");
INSERT INTO mni_vpl VALUES ("MT7_14","070_7_14","MAT","7","14","14","Adubu hingba younaba thong adudi khui, amasung lambi adu yamna chappi, amasung madu phangba mi yamde. ");
INSERT INTO mni_vpl VALUES ("MT7_15","070_7_15","MAT","7","15","15","“Nakhoina Tengban Mapugi wa phongdoksinnaba mising adudagi cheksillu. Makhoina nakhoigi nanakta yaogi phijet setuna lak-i adubu manungdadi makhoi tasengnamak tamthiraba keisalgumbani. ");
INSERT INTO mni_vpl VALUES ("MT7_16","070_7_16","MAT","7","16","16","Makhoigi maheidagi haibadi makhoina touthorakpa thabak adudagi nakhoina makhoibu khanggani. Misingna tingkhanggi mongsongdagi anggur heknabra, nattraga tingkhang panbisingdagi heiyit heknabra? ");
INSERT INTO mni_vpl VALUES ("MT7_17","070_7_17","MAT","7","17","17","Matou asumna aphaba upal khudingna aphaba mahei yalli; adubu phattaba upalna phattaba mahei yalli. ");
INSERT INTO mni_vpl VALUES ("MT7_18","070_7_18","MAT","7","18","18","Aphaba upalna phattaba mahei yanba ngamde, aduga phattaba upalna aphaba mahei yanba ngamde. ");
INSERT INTO mni_vpl VALUES ("MT7_19","070_7_19","MAT","7","19","19","Aduga aphaba mahei yandaba upal khudingmakpu yanthattuna meinungda langsilli. ");
INSERT INTO mni_vpl VALUES ("MT7_20","070_7_20","MAT","7","20","20","Matou asumna makhoigi maheidagi nakhoina makhoibu khanggani. ");
INSERT INTO mni_vpl VALUES ("MT7_21","070_7_21","MAT","7","21","21","“Eingonda ‘Ibungo, Ibungo,’ kouba mi khudingmakna swarga leibakta changloi; adubu swargada leiba Ipagi aningba toujaba mahak adu khaktana changgani. ");
INSERT INTO mni_vpl VALUES ("MT7_22","070_7_22","MAT","7","22","22","Aduga wayenbagi numit aduda, mi mayam amana eingonda haigani, ‘Ibungo, Ibungo! Eikhoina Ibungogi mingda Tengban Mapugi wa phongdokchakhiba nattra, amadi eikhoina Ibungogi mingda lai phattabasingbu tanthokchakhiba nattra, aduga Ibungogi mingda eikhoina angakpa thabaksing toujakhiba nattra?’ ");
INSERT INTO mni_vpl VALUES ("MT7_23","070_7_23","MAT","7","23","23","Adubu matam aduda eina makhoida haigani, ‘Eina nakhoibu keidounungdasu khangkhide. He phattaba thabak toubasa! Eingondagi chathokhro!’ ");
INSERT INTO mni_vpl VALUES ("MT7_24","070_7_24","MAT","7","24","24","“Maram aduna eigi wasing asibu taraga touba mi khudingbu nungjao mathakta yum saba asingba mi amaga changdamnagani. ");
INSERT INTO mni_vpl VALUES ("MT7_25","070_7_25","MAT","7","25","25","Aduga nong taraktuna ising ichao lakle, amasung nungsit kanna sitlaktuna yum aduda yeirare. Adubu yum adu nungjao mathakta saba maramna tukhide. ");
INSERT INTO mni_vpl VALUES ("MT7_26","070_7_26","MAT","7","26","26","“Adubu eigi wasing asi taraga toudaba mi khudingbu leingoi mathakta yum saba apangba mi amaga changdamnagani. ");
INSERT INTO mni_vpl VALUES ("MT7_27","070_7_27","MAT","7","27","27","Aduga nong taraktuna ising ichao lakle, amasung nungsit kanna sitlaktuna yum aduda yeibada yum adu khuttu thina ture.” ");
INSERT INTO mni_vpl VALUES ("MT7_28","070_7_28","MAT","7","28","28","Jisuna wasing asi haiba loirabada, miyam aduna mahakki tambiba aduda ingak ngaklammi. ");
INSERT INTO mni_vpl VALUES ("MT7_29","070_7_29","MAT","7","29","29","Maramdi makhoigi Wayel Yathanggi ojasingna tambiba adugumna nataduna, Ibungona matik leiba mi amagumna tambirammi. ");
INSERT INTO mni_vpl VALUES ("MT8_1","070_8_1","MAT","8","1","1","Jisuna chingthaktagi kumtharakpa matamda, yamlaba miyam amana Ibungogi tung injarammi. ");
INSERT INTO mni_vpl VALUES ("MT8_2","070_8_2","MAT","8","2","2","Aduga ikhang khanghoudana kiningai oiba unsagi lainana naba nupa amana Ibungogi nakta laklaga Ibungoda khurumjaraduna hairak-i, “Ibungona yabirabadi, eibu Ibungona senghanbiba ngammi.” ");
INSERT INTO mni_vpl VALUES ("MT8_3","070_8_3","MAT","8","3","3","Maduda Ibungona khut tingthokladuna mahakpu soklaga hairak-i, “Eina yare, nahak sengjaro.” Khudak adumaktada mahakki laina adudagi mahak sengjare. ");
INSERT INTO mni_vpl VALUES ("MT8_4","070_8_4","MAT","8","4","4","Adudagi Jisuna mangonda hairak-i, “Yeng-u, masi kanadasu haidokkanu, adubu purohitki manakta chattuna nasamak purohitta utcharu aduga mipum khudingna nahak phare haiba khangnanaba Moses-na katlu haiduna yathang piramba iratpot adu katcharu.” ");
INSERT INTO mni_vpl VALUES ("MT8_5","070_8_5","MAT","8","5","5","Jisuna Capernaum-da changba matamda lanmi chamagi makok amana Ibungogi nakta laktuna khurumjaraga pangbinaba haijarak-i, ");
INSERT INTO mni_vpl VALUES ("MT8_6","070_8_6","MAT","8","6","6","“Ibungo, eigi inai ama pangtha-sithabagi lainana naduna yamna wana yumda leihouri.” ");
INSERT INTO mni_vpl VALUES ("MT8_7","070_8_7","MAT","8","7","7","Maduda Jisuna mangonda hairak-i, “Eina laktuna mahakpu phahanbigani.” ");
INSERT INTO mni_vpl VALUES ("MT8_8","070_8_8","MAT","8","8","8","Adubu lanmi chamagi makok aduna hairak-i, “Ibungo, eigi yumda Ibungona lengbirakpa itik chajade. Adubu Ibungona anabadu phananaba yathang aduta pibiyu, aduga eigi inaigi anabadu phajagani. ");
INSERT INTO mni_vpl VALUES ("MT8_9","070_8_9","MAT","8","9","9","Maramdi ei isamaksu mathak thongba phamnaibasinggi makhada leiba mini, aduga eigi ikhada eigi lanmising lei. Eina ‘Chatlu,’ hairaga makhoina chatli, aduga ‘Lak-u,’ hairaga makhoina lak-i. Aduga eina eigi inaisingda ‘Masi tou,’ hairaga makhoina madu tou-i.” ");
INSERT INTO mni_vpl VALUES ("MT8_10","070_8_10","MAT","8","10","10","Jisuna madu tabada ngakladuna mahakki tung illiba makhoising aduda hairak-i, “Eina nakhoida tasengnamak hairibasini, asigumna asuk yamna thajaba mi eina Israel leibakta keidoungeida thengnadri. ");
INSERT INTO mni_vpl VALUES ("MT8_11","070_8_11","MAT","8","11","11","Eina nakhoida hairibasini madudi nongpok amadi nongchuptagi mi kayana laktuna swarga leibakta Abraham, Isaac amadi Jacob-ka loinana chaklen aduda phaminagani. ");
INSERT INTO mni_vpl VALUES ("MT8_12","070_8_12","MAT","8","12","12","Adubu swarga leibak adugi oipham thokpa mi kaya amadi mapan-gi amambada langthokkani; mapham aduda makhoina kapkani amasung maya krak-krak chikkani.” ");
INSERT INTO mni_vpl VALUES ("MT8_13","070_8_13","MAT","8","13","13","Adudagi Jisuna lanmi chamagi makok aduda hairak-i, “Nayumda hanjaro, nahakna thajabagi maramna nangonda madumak thoklagani.” Aduga pungja adumaktada mahakki manai adu naba phajare. ");
INSERT INTO mni_vpl VALUES ("MT8_14","070_8_14","MAT","8","14","14","Adudagi Jisuna Peter-gi yumda lakpa matamda Peter-gi manembok arum houduna nabadagi phamungda hiplamba adu ure. ");
INSERT INTO mni_vpl VALUES ("MT8_15","070_8_15","MAT","8","15","15","Amasung Jisuna mahakki makhutta sokpada mahakki arum houramba adu phakhirammi; aduga mahakna phamungdagi hougattuna Ibungogi thougal toujare. ");
INSERT INTO mni_vpl VALUES ("MT8_16","070_8_16","MAT","8","16","16","Adudagi numidangwairam oisillaklabada misingna sengdaba thawai changba mi mayam ama Jisugi nakta puraklammi; aduga Ibungogi wahei amana sengdaba thawaising adubu tanthoklammi amasung mahakna anaba mi pumnamakpu phahanbirammi. ");
INSERT INTO mni_vpl VALUES ("MT8_17","070_8_17","MAT","8","17","17","Masi Tengban Mapugi wa phongdokpiba maichou Isaiah-na haikhiba, “Mahak masamakna eikhoigi anabasingbu pubire amasung eikhoigi lainasingbu louthokpire” haiba wa adu thungnabani. ");
INSERT INTO mni_vpl VALUES ("MT8_18","070_8_18","MAT","8","18","18","Aduga Jisuna mahakki akoibada leiriba miyam adu uba matamda, mahakna mahakki tung-inbasing aduda pat adugi wangmada lanthoknanaba yathang pirammi. ");
INSERT INTO mni_vpl VALUES ("MT8_19","070_8_19","MAT","8","19","19","Adudagi Wayel Yathanggi oja amana mahakki nakta laktuna hairak-i, “Oja Ibungo, nahakna chatpa mapham khudingda eihak tung injagani.” ");
INSERT INTO mni_vpl VALUES ("MT8_20","070_8_20","MAT","8","20","20","Maduda Jisuna mangonda hairak-i, “Lamhuisinggi makol lei, amadi ucheksinggi mahum lei, adubu Migi Machanupa adugidi makok ngathapham phaoba leite.” ");
INSERT INTO mni_vpl VALUES ("MT8_21","070_8_21","MAT","8","21","21","Aduga atoppa tung-inba amana Ibungoda hairak-i, “Ibungo, eina yumda hanna hanjaduna ipabu leiron chanjarukhige.” ");
INSERT INTO mni_vpl VALUES ("MT8_22","070_8_22","MAT","8","22","22","Maduda Jisuna mangonda hairak-i, “Eigi itung illu, aduga asibasingna makhoigi asibasingbu leiron chansanu.” ");
INSERT INTO mni_vpl VALUES ("MT8_23","070_8_23","MAT","8","23","23","Adudagi Jisuna hida kakhatle aduga mahakki tung-inbasing adusu mahakka loinana chatminnare. ");
INSERT INTO mni_vpl VALUES ("MT8_24","070_8_24","MAT","8","24","24","Amasung ikhang khanghoudana pat aduda akanba nonglei nungsit ama lakle aduga ithak ipomna yeibadagi hi adu laksinlammi. Adubu Ibungodi tumduna leirammi. ");
INSERT INTO mni_vpl VALUES ("MT8_25","070_8_25","MAT","8","25","25","Adudagi tung-inbasing aduna Ibungogi nakta laklaga mahakpu houdoktuna hairak-i, “Ibungo, eikhoibu kanbiyu, Eikhoi iraknaduna siba tare.” ");
INSERT INTO mni_vpl VALUES ("MT8_26","070_8_26","MAT","8","26","26","Maduda Jisuna makhoida hairak-i, “He thajaba watpasa, nakhoina karigi aduk yamna kiribano?” Aduga Ibungona hougattuna nungsit amadi ithak aduda lepnanaba yathang pirammi, aduga pumnamak adu pungtap tapthakhre. ");
INSERT INTO mni_vpl VALUES ("MT8_27","070_8_27","MAT","8","27","27","Maduda tung-inbasing aduna ingak ngakladuna hairak-i, “Nungsit amadi ithaksing phaobana haiba illiba mahak asibu karamba mino.” ");
INSERT INTO mni_vpl VALUES ("MT8_28","070_8_28","MAT","8","28","28","Aduga Jisuna patki wangmada leiba Gadara-gi lamdamda thunglabada, mongphamdagi thoklakpa lai phattaba changba nupa anina mahakka thengnare. Makhoisingdu adukki matik yamna tamthirammi madudi mi kana amata lambi adu phaoraga chatpa ngamlamde. ");
INSERT INTO mni_vpl VALUES ("MT8_29","070_8_29","MAT","8","29","29","Aduga khudak aduda makhoina asumna laorak-i, “He Tengban Mapugi Machanupa, nangna eikhoida kari touba pambage? Matam adu youdringeida nahakna eikhoibu ot-neinaba mapham asida laklibra?” ");
INSERT INTO mni_vpl VALUES ("MT8_30","070_8_30","MAT","8","30","30","Aduga mapham adudagi panglap laptana ok sanggu ama machinchak chaduna leirammi. ");
INSERT INTO mni_vpl VALUES ("MT8_31","070_8_31","MAT","8","31","31","Maram aduna lai phattabasing aduna Jisuda haijarak-i, “Nahakna eikhoibu tanthoklabadi ok sanggu asigi manungda eikhoibu changhanbiyu.” ");
INSERT INTO mni_vpl VALUES ("MT8_32","070_8_32","MAT","8","32","32","Adudagi Jisuna makhoida hairak-i, “Chatlu.” Aduga makhoina thokkhiduna ok sanggu adugi manungda changkhre amasung ok sanggu apumba aduna angamba torban adudagi pat tamna thuna chenthakhiduna pat aduda iraknaduna sire. ");
INSERT INTO mni_vpl VALUES ("MT8_33","070_8_33","MAT","8","33","33","Maduda ok sellambasing aduna chenkhiduna sahar aduda chatlaga lai phattaba changbasing aduda thokkhiba thoudok adu yaona wari pumnamaksing adu tamle. ");
INSERT INTO mni_vpl VALUES ("MT8_34","070_8_34","MAT","8","34","34","Adudagi sahar adugi mi pumnamakna Jisubu unnanaba thorakle. Aduga makhoina Ibungobu uba matamda makhoigi lamdam adu thadoktuna chatpikhinaba haijarammi. ");
INSERT INTO mni_vpl VALUES ("MT9_1","070_9_1","MAT","9","1","1","Adudagi Jisuna hi amada tongduna pat adu lanthoklaga mahak masamakki saharda laklammi. ");
INSERT INTO mni_vpl VALUES ("MT9_2","070_9_2","MAT","9","2","2","Aduga mi kharana pangtha-sithaduna naba mi amabu hipnaphamda hipphalladuna Ibungogi nakta puraklammi. Amasung Jisuna makhoigi thajaba adu uba matamda pangtha-sithaduna naba mi aduda hairak-i, “Ichanupa, haraojaro; nahakki napapsing kokpire.” ");
INSERT INTO mni_vpl VALUES ("MT9_3","070_9_3","MAT","9","3","3","Maduda Wayel Yathanggi oja kharagi marakta asumna hainarammi, “Nupa asina Mapu Ibungobu thina ngangle!” ");
INSERT INTO mni_vpl VALUES ("MT9_4","070_9_4","MAT","9","4","4","Aduga makhoina kari khallibage haibadu Jisuna khangladuna makhoida hairak-i, “Nakhoigi thamoida karigi adugumba phattaba wakhal khallibano? ");
INSERT INTO mni_vpl VALUES ("MT9_5","070_9_5","MAT","9","5","5","Maramdi ‘Nahakki napapsing kokpire,’ haibaga ‘Hougattuna chatlu,’ haibasiga karambana henna laibage? ");
INSERT INTO mni_vpl VALUES ("MT9_6","070_9_6","MAT","9","6","6","Adubu Migi Machanupa aduna taibangpanda papsing kokpinaba matik lei haiba eina nakhoida utkani.” Adudagi Ibungona pangtha-sithaduna naba mi aduda hairak-i, “Hougatlu, aduga nahakki hipnapham adu loukhattuna nayumda chatlo.” ");
INSERT INTO mni_vpl VALUES ("MT9_7","070_9_7","MAT","9","7","7","Maduda nupa aduna hougatlaga mayumda chatkhirammi. ");
INSERT INTO mni_vpl VALUES ("MT9_8","070_9_8","MAT","9","8","8","Aduga miyam aduna madu ubada angakpa amasung akibana thallammi, amadi asigumba matik asibu mioibada pibiba Tengban Mapubu makhoina thagatcharammi. ");
INSERT INTO mni_vpl VALUES ("MT9_9","070_9_9","MAT","9","9","9","Adudagi Jisuna mapham adu thadoktuna asum lakpada, Matthew kouba kanggat khomba nupa amana kanggat khomphamda phamduna leiba adu uraduna mangonda hairak-i, “Eigi tung illu.” Maduda Matthew-na hougattuna Ibungogi matung injare. ");
INSERT INTO mni_vpl VALUES ("MT9_10","070_9_10","MAT","9","10","10","Madugi matungda nongma Jisuna Matthew-gi yumda numidanggi chaklen chaba matamda kanggat khombasing amadi inthokpiraba misingsu chaklen aduda laktuna Ibungo amadi mahakki tung-inbasingga loinana chaminnarammi. ");
INSERT INTO mni_vpl VALUES ("MT9_11","070_9_11","MAT","9","11","11","Pharisee-singna madu ubada Ibungogi tung-inbasing aduda hanglak-i, “Karigi nakhoigi ojana asigumba mising asiga chamin thakminaribano?” ");
INSERT INTO mni_vpl VALUES ("MT9_12","070_9_12","MAT","9","12","12","Makhoina hainariba adu tabada Jisuna khumlak-i, “Masa phabasinggidi layengba mi mathou tade, adubu anabasinggidi mathou tai. ");
INSERT INTO mni_vpl VALUES ("MT9_13","070_9_13","MAT","9","13","13","Aduga Mapugi puyada hairiba, ‘Eina pambadi chanbiheiba aduni, iratpot adu natte’ hairiba asi karino haiba nakhoina chattuna tamlukho. Maramdi eina achumba chatpasingbu kouba lakpa natte adubu pap chenbasingbuni.” ");
INSERT INTO mni_vpl VALUES ("MT9_14","070_9_14","MAT","9","14","14","Nongma Baptize toubiba John-gi tung-inbasingna Jisugi nakta laktuna hanglak-i, “Eikhoina amadi Pharisee-singnadi tattana chara helli, adubu Ibungogi tung- inbasingnadi chara hendriba karigino?” ");
INSERT INTO mni_vpl VALUES ("MT9_15","070_9_15","MAT","9","15","15","Maduda Jisuna makhoida khumlak-i, “Luhongbada lakliba borgi marupsingna bor aduga loinaduna leiminnaringeida tengtha nao-oigadra? Adum oinamak makhoidagi bor adu pukhigadaba numit adu lakkani, aduga matam aduda makhoina chara hen-gani. ");
INSERT INTO mni_vpl VALUES ("MT9_16","070_9_16","MAT","9","16","16","“Aduga mi kana amatana ahanba phi machet amabu amanba phida photchinde, maramdi ahanba phi machet aduna chingsinduna segairiba adu hennadum segairakkani. ");
INSERT INTO mni_vpl VALUES ("MT9_17","070_9_17","MAT","9","17","17","Aduga mi kana amatana anouba yubu amanba sawun-gi khaosingda khak hapnade, karigumba haplabadi sawun khaosing adu pokhaiduna yu adu heidokkani aduga sawun-gi khaosing adusu manggani. Madugi mahutta anouba yubu anouba sawun-gi khaosingda hapnei, aduga animak phana thammi.” ");
INSERT INTO mni_vpl VALUES ("MT9_18","070_9_18","MAT","9","18","18","Aduga Jisuna wasing asi makhoida hairingeida, synagogue-ki phamnaiba ama laklaga Ibungogi mangda khuru khudak kulladuna Ibungoda hairak-i, “Eigi ichanupi houjikta sibada ngairi; aduna Ibungona lengbiraktuna mahakki mathakta Ibungogi khut thambiyu, adu oirabadi mahakna amuk hingba phangjagani.” ");
INSERT INTO mni_vpl VALUES ("MT9_19","070_9_19","MAT","9","19","19","Maduda Jisuna hougattuna mahakki tung-inbasing aduga loinana mahakki matung induna chatle. ");
INSERT INTO mni_vpl VALUES ("MT9_20","070_9_20","MAT","9","20","20","Aduga Jisuna chatlingei matam aduda chahi taranithoi chupna ee taduna naraklabi nupi amana Ibungogi tunglomda laktuna Ibungogi phijida sokcharammi. ");
INSERT INTO mni_vpl VALUES ("MT9_21","070_9_21","MAT","9","21","21","Maramdi “Eina Ibungogi phiji asibu sokta sokcharabadi eigi anaba asi phajagani” haina nupi aduna khanjarammi. ");
INSERT INTO mni_vpl VALUES ("MT9_22","070_9_22","MAT","9","22","22","Aduga Jisuna leithorakpada nupi adubu urammi. Amasung mahakna nupi aduda hairak-i, “Haraojou, Ichanupi, nahakki thajabana nahakpu phahanbire.” Aduga mikup adumaktada nupi adugi anaba adu phajare. ");
INSERT INTO mni_vpl VALUES ("MT9_23","070_9_23","MAT","9","23","23","Madugi matungda phamnaiba adugi yumda Jisuna changlakpa matamda tengtha naoiduna langlamba miyam amadi mathou mangamgidamak basi khonglibasing adu ure. ");
INSERT INTO mni_vpl VALUES ("MT9_24","070_9_24","MAT","9","24","24","Maduda Ibungona makhoida hairak-i, “Mayam pumnamak thokpikhro, nupimacha asi siba natte, mahak tumlibani!” Maduda makhoina Ibungobu karemnaduna noknare. ");
INSERT INTO mni_vpl VALUES ("MT9_25","070_9_25","MAT","9","25","25","Aduga miyam adubu mapanda thok-hankhraba matungda, Ibungona nupimacha adugi kada changlaga nupimacha adugi makhut adu paikhatpire, adudagi nupimacha adu hougatlakle. ");
INSERT INTO mni_vpl VALUES ("MT9_26","070_9_26","MAT","9","26","26","Aduga pao asina lam adu sinba thungna sandokkhre. ");
INSERT INTO mni_vpl VALUES ("MT9_27","070_9_27","MAT","9","27","27","Adudagi Jisuna mapham adu thadoklamlaga lambida asum lakpada, mamit tangba nupa anina “He David-ki Machanupa, eikhoibu chanbiyu!” haina laora- laoraduna Ibungogi matung innaraklammi. ");
INSERT INTO mni_vpl VALUES ("MT9_28","070_9_28","MAT","9","28","28","Aduga Jisuna imungda changlaba matungda mamit tangba nupa ani adu mahakki manakta lakle. Maduda Ibungona makhoida hairak-i, “Eina nakhoibu phahanbiba ngammi haibasi nakhoi thajabra?” Makhoina Ibungoda khumjarak-i, “Hoi, Ibungo.” ");
INSERT INTO mni_vpl VALUES ("MT9_29","070_9_29","MAT","9","29","29","Adudagi Ibungona makhoigi mamitta sokladuna hairak-i, “Nakhoigi thajabagi matung inna madumak nakhoida oirasanu.” ");
INSERT INTO mni_vpl VALUES ("MT9_30","070_9_30","MAT","9","30","30","Aduga makhoina uba phangjare. Adudagi Jisuna makhoida, “Masigi maramda mi kana amatada haiganu” haiduna akanba yathang pire. ");
INSERT INTO mni_vpl VALUES ("MT9_31","070_9_31","MAT","9","31","31","Adubu makhoina chatkhraga Ibungogi maramda lam adu sinba thungna sandokle. ");
INSERT INTO mni_vpl VALUES ("MT9_32","070_9_32","MAT","9","32","32","Aduga makhoina mapham adudagi hek thokkhibaga mi kharana lai phattaba changba marol thoktaba nupa ama Jisugi nakta puraklammi. ");
INSERT INTO mni_vpl VALUES ("MT9_33","070_9_33","MAT","9","33","33","Amasung Jisuna lai phattaba adu hek tanthokkhibaga marol thoktaba nupa adu wa ngangba hourakle. Maduda mipum khudingmakna ngakpaga loinana hairak-i, “Eikhoina asigumba thoudok amata Israel leibakta amukta ukhidri.” ");
INSERT INTO mni_vpl VALUES ("MT9_34","070_9_34","MAT","9","34","34","Adubu Pharisee-singnadi asumna hairak-i, “Mahakna lai phattabasing tanthokliba asidi lai phattabasinggi makok adugi mapalnani.” ");
INSERT INTO mni_vpl VALUES ("MT9_35","070_9_35","MAT","9","35","35","Adudagi Jisuna mapham adugi saharsing amadi khunggangsing sinba thungna koina chattuna synagogue-singda tambirammi amadi ningthou leibakki aphaba pao sandoklammi. Amasung Ibungona laina khuding amadi anaba khudingmakpu phahanbirammi. ");
INSERT INTO mni_vpl VALUES ("MT9_36","070_9_36","MAT","9","36","36","Aduga Ibungona miyam adu ubada mahakki thamoida makhoibu nungsiba pokle. Maramdi makhoi senbinaba leitaba yaosinggumna kangaonaraba amasung pangbinaba leitabasing oirammi. ");
INSERT INTO mni_vpl VALUES ("MT9_37","070_9_37","MAT","9","37","37","Adudagi Ibungona mahakki tung-inbasing aduda hairak-i, “Lou lokkadabadi yammi, adubu thabak subinaba midi yamde. ");
INSERT INTO mni_vpl VALUES ("MT9_38","070_9_38","MAT","9","38","38","Maram aduna nakhoina Ibungo mahakki lou lokphamda thabak suba mi henna thabiraknaba lougi mapuda haijou.” ");
INSERT INTO mni_vpl VALUES ("MT10_1","070_10_1","MAT","10","1","1","Adudagi Jisuna mahakki tung-inba taranithoi adubu mahakki manakta kouraduna phattaba thawaising tanthoknaba amasung laina khuding amadi anaba khudingbu phahannaba Ibungona makhoida matik pibire. ");
INSERT INTO mni_vpl VALUES ("MT10_2","070_10_2","MAT","10","2","2","Pakhonchatpa makhoi taranithoi adugi mamingdi, ahanbada, Peter kouba Simon amasung mahakki manao Andrew; Zebedee-gi machanupa Jacob amasung mahakki manao John; ");
INSERT INTO mni_vpl VALUES ("MT10_3","070_10_3","MAT","10","3","3","Philip amasung Bartholomew; Thomas amasung kanggat khomba Matthew; Alphaeus-gi machanupa Jacob amasung Thaddaeus; ");
INSERT INTO mni_vpl VALUES ("MT10_4","070_10_4","MAT","10","4","4","mareibak ningba Simon amasung Ibungobu yeknabasinggi khutta pithokkhiba Judas Iscariot, hairibasing asini. ");
INSERT INTO mni_vpl VALUES ("MT10_5","070_10_5","MAT","10","5","5","Adudagi Jisuna yathangsing asi piraduna makhoi taranithoibu tharammi. Yathangsing adudi: “Nakhoina Jihudi nattaba phurupsingna leiba maphamsingda chatluganu aduga Samaria machasinggi saharsingdasu changganu. ");
INSERT INTO mni_vpl VALUES ("MT10_6","070_10_6","MAT","10","6","6","Adugi mahutta, nakhoina mangkhraba yaogi masak oiraba Israel-gi misinggi maphamda chatlu. ");
INSERT INTO mni_vpl VALUES ("MT10_7","070_10_7","MAT","10","7","7","Aduga nakhoina chatpa matamda, ‘Swarga leibak adu naksillakle!’ haiduna makhoida sandok-u. ");
INSERT INTO mni_vpl VALUES ("MT10_8","070_10_8","MAT","10","8","8","Anabasingbu phahallu, asibasingbu hinggat-hallu, kiningngai oiba unsagi lainana nabasingbu phahanduna senghallu, phattaba thawaisingbu tanthok-u. Nakhoina lemna phangbagumna nakhoina lemna pinou. ");
INSERT INTO mni_vpl VALUES ("MT10_9","070_10_9","MAT","10","9","9","Nakhoigi senggaoda sana, lupa, nattraga korigi sel-mayek puganu. ");
INSERT INTO mni_vpl VALUES ("MT10_10","070_10_10","MAT","10","10","10","Aduga nakhoigi khongchat adugidamak khao, sandal, cheisu nattraga phurit ani suna puganu; maramdi thabak suba mina mahakki chinjak phangba matik chai. ");
INSERT INTO mni_vpl VALUES ("MT10_11","070_10_11","MAT","10","11","11","“Nakhoina sahar nattraga khunggang amada changba matamda, nakhoina leibada matik chaba mi kana mapham aduda leibage haibadu thidok-u aduga nakhoina mapham adu thadoktriba phaoba mahakki yum aduda leiyu. ");
INSERT INTO mni_vpl VALUES ("MT10_12","070_10_12","MAT","10","12","12","Amasung nakhoina yum aduda changba matamda asumna haiyu, ‘Nakhoida ingthaba oisanu.’ ");
INSERT INTO mni_vpl VALUES ("MT10_13","070_10_13","MAT","10","13","13","Aduga imung aduna matik charabadi, nakhoigi ingthabagi yaipha thoujal adu makhoida leisanu; adubu imung aduna matik chadrabadi, nakhoigi ingthabagi yaipha thoujal adu nakhoida hallaksanu. ");
INSERT INTO mni_vpl VALUES ("MT10_14","070_10_14","MAT","10","14","14","Aduga kanagumbana nakhoibu lousindrabadi nattraga nakhoigi wasing adu tadrabadi, nakhoina imung adu nattraga sahar adu thadokpa matamda nakhoigi khongyagi uphul adu kanthoklammu. ");
INSERT INTO mni_vpl VALUES ("MT10_15","070_10_15","MAT","10","15","15","Eina nakhoida tasengnamak hairibasini, wayenbagi numit aduda Sodom amasung Gomorrah-gi lamna sahar adudagi henna saphagani. ");
INSERT INTO mni_vpl VALUES ("MT10_16","070_10_16","MAT","10","16","16","“Yeng-u, eina nakhoibu keisalgi marakta yaogumna thari, maram aduna nakhoina lin-gumna sing-u, amasung khunugumna pukchel ting-u. ");
INSERT INTO mni_vpl VALUES ("MT10_17","070_10_17","MAT","10","17","17","Aduga nakhoi cheksillu, maramdi nakhoibu wayel-sangsingda pukhatkani amasung synagogue-singda nakhoibu phugani. ");
INSERT INTO mni_vpl VALUES ("MT10_18","070_10_18","MAT","10","18","18","Aduga eigi maramgidamak nakhoibu leingakpasing amasung ningthousinggi mamangda, makhoida amadi atoppa phurupsingda sakhi pinabagidamak pukhatkani. ");
INSERT INTO mni_vpl VALUES ("MT10_19","070_10_19","MAT","10","19","19","Adubu makhoina nakhoibu phaba matamda, nakhoina kari haigadage nattraga kamdouna haigadage haibagidamak karisu langtaknaganu. Maramdi pungpham aduda nakhoina haigadaba waheising adu nakhoida pibigani. ");
INSERT INTO mni_vpl VALUES ("MT10_20","070_10_20","MAT","10","20","20","Maramdi ngangliba adu nakhoina natte, adubu nakhoigi Napa Ibungogi Thawaina waheising adu nakhoida nganghanbigani. ");
INSERT INTO mni_vpl VALUES ("MT10_21","070_10_21","MAT","10","21","21","“Aduga machin manaona machin manaobu hat-hannaba pithokkani, matou asigumna mapana machasingbusu pithokkani amasung machasingna mama-mapagi maiyokta leptuna makhoibu hat-han-gani. ");
INSERT INTO mni_vpl VALUES ("MT10_22","070_10_22","MAT","10","22","22","Mi pumnamakna eigi maramgidamak nakhoibu yengthigani. Adubu aroiba phaoba chetna lepchaba mahak adubu kanbigani. ");
INSERT INTO mni_vpl VALUES ("MT10_23","070_10_23","MAT","10","23","23","Adubu makhoina nakhoibu sahar amada ot-neirabadi, nakhoina atoppa amada chellu. Eina nakhoida tasengnamak hairibasini, Migi Machanupa aduna lenglaktringei mamangda nakhoina Israel-gi saharsing pumnamak sin-thungna chatpa nangloi. ");
INSERT INTO mni_vpl VALUES ("MT10_24","070_10_24","MAT","10","24","24","“Tung-inba amana mahakki ojagi mathakta leite, aduga manaina mahakki mapudagi henna chaode. ");
INSERT INTO mni_vpl VALUES ("MT10_25","070_10_25","MAT","10","25","25","Tung-inbasingna makhoigi ojagum amasung manaina makhoigi mapugum oirakpa aduna okle. Aduga yumgi yumburen aduda Beelzebul haina makhoina kourabadi, mahakki imunggi misingdadi kayada henna thina kougadaba! ");
INSERT INTO mni_vpl VALUES ("MT10_26","070_10_26","MAT","10","26","26","“Adubu nakhoina misingbu kiganu. Maramdi phongdokloidaba kupsinba karisu leite, aduga khangloidaba arotpa amata leite. ");
INSERT INTO mni_vpl VALUES ("MT10_27","070_10_27","MAT","10","27","27","Eina nakhoida amambada haiba adu, nakhoina anganbada haidok-u; aduga nakhoigi nakong khaktana takhibasing adu nakhoina yumthaktagi laothok-u. ");
INSERT INTO mni_vpl VALUES ("MT10_28","070_10_28","MAT","10","28","28","Aduga hakchangbu hatlaga, thawaibudi hatpa ngamdaba makhoising adubu kiganu; adubu thawai amasung hakchang animakpu norokta manghanba ngamba Ibungo mahakpu kiyu. ");
INSERT INTO mni_vpl VALUES ("MT10_29","070_10_29","MAT","10","29","29","Sendrang anibu peisa amada yonba nattra? Adumakpu nakhoigi Napa Ibungona yabiba nattanadi makhoigi maraktagi ama phaoba siduna leimaida taroi. ");
INSERT INTO mni_vpl VALUES ("MT10_30","070_10_30","MAT","10","30","30","Aduga nakhoigi kokta sam masing kaya houribage haiba phaoba Tengban Mapuna khanglibani. ");
INSERT INTO mni_vpl VALUES ("MT10_31","070_10_31","MAT","10","31","31","Maram aduna kiganu; nakhoidi sendrang kayadagisu henna mamal yamba helli. ");
INSERT INTO mni_vpl VALUES ("MT10_32","070_10_32","MAT","10","32","32","“Maram aduna misinggi mamangda eigi tung-inbani haina yajaba mahak adubu swargada leiba Ipagi mangda einasu yabigani. ");
INSERT INTO mni_vpl VALUES ("MT10_33","070_10_33","MAT","10","33","33","Adubu misinggi mangda eibu yadaba mahak adubu einasu swargada leiba Ipagi mangda yabiroi. ");
INSERT INTO mni_vpl VALUES ("MT10_34","070_10_34","MAT","10","34","34","“Eina taibangpan asida ingthaba piba lakpani haina khan-ganu. Eina ingthaba piba lakpa natte, adubu thangsang piba lakpani. ");
INSERT INTO mni_vpl VALUES ("MT10_35","070_10_35","MAT","10","35","35","Maramdi machanupasingna makhoigi mapagi maiyokta, machanupisingna makhoigi mamagi maiyokta aduga mamou nupisingna manemboksinggi maiyokta leihannaba ei lakpani. ");
INSERT INTO mni_vpl VALUES ("MT10_36","070_10_36","MAT","10","36","36","Mi amagi yeknaba adu mahak masagi imung manunggi misingna oigani. ");
INSERT INTO mni_vpl VALUES ("MT10_37","070_10_37","MAT","10","37","37","“Mapa nattraga mamabu eingondagi henna nungsiba mahak adu eigi oibada matik chade; aduga machanupa nattraga machanupibu eingondagi henna nungsiba mahak adu eigi oibada matik chade. ");
INSERT INTO mni_vpl VALUES ("MT10_38","070_10_38","MAT","10","38","38","Aduga mahakki cross thanggattuna eigi tung indaba mahak adu eigi oibada matik chade. ");
INSERT INTO mni_vpl VALUES ("MT10_39","070_10_39","MAT","10","39","39","Mathawai kanjaba mahak aduna madu mangjagani; aduga eigi maramgidamak mathawai mangjaba mahak aduna madu phangjagani. ");
INSERT INTO mni_vpl VALUES ("MT10_40","070_10_40","MAT","10","40","40","“Nakhoibu lousinba mahak aduna eibu lousinbani, aduga eibu lousinba mahak aduna eibu tharakpa mahak adubu lousinbani. ");
INSERT INTO mni_vpl VALUES ("MT10_41","070_10_41","MAT","10","41","41","Kanagumba amana Tengban Mapugi wa phongdokpa mi amabu Tengban Mapugi wa phongdokpa mi ama oina lousinjarabadi Tengban Mapugi wa phongdokpa mi aduna phanggadaba mana adumak mahaknasu phangjagani; aduga kanagumba amana achumba chatpa mi amabu achumba chatpa mi ama oibagi maramna lousillabadi achumba chatpa mi aduna phanggadaba mana adumak mahaknasu phangjagani. ");
INSERT INTO mni_vpl VALUES ("MT10_42","070_10_42","MAT","10","42","42","Aduga kanagumbana apikpasing asigi maraktagi amada eigi tung-inba oibagi maramna ayingba ising glass ama pirabadi, eina nakhoida tasengnamak hairibasini, mahakna mahakki mana khak mangloi.” ");
INSERT INTO mni_vpl VALUES ("MT11_1","070_11_1","MAT","11","1","1","Jisuna mahakki tung-inba taranithoi adubu takpiba loiraba matungda makhoigi sahar saharsingda tambinaba amadi pao sandoknabagidamak mapham adu thadoklammi. ");
INSERT INTO mni_vpl VALUES ("MT11_2","070_11_2","MAT","11","2","2","Aduga Christtana touriba thabaksing adugi maramda keisumsangda leiriba baptize toubiba John-na tarabada, mahakna mahakki tung-inba kharabu Ibungogi nakta tharaduna, ");
INSERT INTO mni_vpl VALUES ("MT11_3","070_11_3","MAT","11","3","3","wahang asi Ibungoda hanghallammi, “Lenglakkadouriba Ibungo adu nahakla nattraga eikhoina atoppa amabu amuk ngaijakhigadra?” ");
INSERT INTO mni_vpl VALUES ("MT11_4","070_11_4","MAT","11","4","4","Maduda Jisuna makhoida khumlak-i, “Nakhoina taribasing amadi uribasing adu nakhoina chattuna John-da tammu, ");
INSERT INTO mni_vpl VALUES ("MT11_5","070_11_5","MAT","11","5","5","Mit tangbasingna ujare, khong tekpasingna chatpa ngamjare, kiningai oiba unsagi lainana nabasingna sengjare, mana pangbasingna tajare, asibasingbu hinggat-hanbire, aduga lairabasingda aphaba pao sandokle. ");
INSERT INTO mni_vpl VALUES ("MT11_6","070_11_6","MAT","11","6","6","Aduga eigi maramda chingnaba leitaba mahak adu yaiphabani.” ");
INSERT INTO mni_vpl VALUES ("MT11_7","070_11_7","MAT","11","7","7","Adudagi John-gi tung-inbasing aduna mapham adu thadokkhibaga, Jisuna miyam aduda John-gi maramda haiba hourak-i, “Nakhoina lamjao lamhangda kari yengba chatlubage? Nungsitna yeibada koihum humba awangba napibura? ");
INSERT INTO mni_vpl VALUES ("MT11_8","070_11_8","MAT","11","8","8","Nattragana nakhoina leikanglada kari yengba chatlubage? Ningthijaba phijol setpa mi amabura? Yeng-u, ningthijaba phijol setpa makhoising adudi ningthou konungsingda leibani. ");
INSERT INTO mni_vpl VALUES ("MT11_9","070_11_9","MAT","11","9","9","Adudi nakhoina kari yengba chatlubage? Tengban Mapugi wa takthokpa maichou amabura? Hoi, eina nakhoida hairibasini, mahakti Tengban Mapugi wa takthokpa maichou amadagisu henna chao-i. ");
INSERT INTO mni_vpl VALUES ("MT11_10","070_11_10","MAT","11","10","10","Mapugi puyada iduna leiriba asi John asigi maramdani, ‘Yeng-u, eina eigi paopubabu nahakki namang thana thagani, Aduga mahakna nahakki mangda nahakki lambi thourang tougani.’ ");
INSERT INTO mni_vpl VALUES ("MT11_11","070_11_11","MAT","11","11","11","“Eina nakhoida tasengnamak hairibasini, taibangpan asida baptize toubiba John-dagi henna chaoba kanasu pokkhidri. Adumakpu Tengban Mapugi leibakta khwaidagi henna pikpa mahak aduna John-dagi henna chao-i. ");
INSERT INTO mni_vpl VALUES ("MT11_12","070_11_12","MAT","11","12","12","Baptize toubiba John-na Tengban Mapugi aphaba pao sandokpadagi houraga houjik phaobada swarga leibak asi panggal leina changsillak-i, aduga panggal leiba misingna madu pairi. ");
INSERT INTO mni_vpl VALUES ("MT11_13","070_11_13","MAT","11","13","13","Maramdi Tengban Mapugi wa phongdokpiba maichou pumnamakna amadi Moses-ki Wayel Yathangna John-na laktringei matam adu phaoba Ningthou Leibak adugi maramda hairammi. ");
INSERT INTO mni_vpl VALUES ("MT11_14","070_11_14","MAT","11","14","14","Aduga nakhoina madubu lousinjage haina ninglabadi, maichousingna lakkani haina phongdokpiramba Elijah adu mahakni. ");
INSERT INTO mni_vpl VALUES ("MT11_15","070_11_15","MAT","11","15","15","Tananaba nakong panba mahak aduna tasanu!” ");
INSERT INTO mni_vpl VALUES ("MT11_16","070_11_16","MAT","11","16","16","“Aduga eina miron asi kariga changdamnagadage? Makhoidi keithelda sanariba angang machasinggumbani. Makhoina atei marupsingda kouraduna hai, ");
INSERT INTO mni_vpl VALUES ("MT11_17","070_11_17","MAT","11","17","17","‘Eikhoina nakhoigidamak basi khong-i adubu nakhoina jagoi sade; eikhoina tengtha nao-oibagi esei sak-i, adubu nakhoina tengthade!’ ");
INSERT INTO mni_vpl VALUES ("MT11_18","070_11_18","MAT","11","18","18","Maramdi John-na ateigumna cha-thakte amasung yu thakte, aduga nakhoina, ‘Mahakpu lai phattaba changbani haibire!’ ");
INSERT INTO mni_vpl VALUES ("MT11_19","070_11_19","MAT","11","19","19","Aduga Migi Machanupa aduna lakpa matamdadi cha-thakle, aduga amuk nakhoina mahakpu ‘Pukchaoba, yuthakpa, amasung kanggat khomba amadi papisinggi marupni’ haibire. Adubu Tengban Mapugi lousingdi achumbani haibasi madubu lousinjaribasing adugi thabaksing aduna utli.” ");
INSERT INTO mni_vpl VALUES ("MT11_20","070_11_20","MAT","11","20","20","Adudagi Ibungona mahakki matik leiba thabak ayambasing toukhiba saharsing aduda cheiba hourak-i, maramdi makhoina pukning honglamde, ");
INSERT INTO mni_vpl VALUES ("MT11_21","070_11_21","MAT","11","21","21","“He Chorazin, nangdi awabanida! He Bethsaida, nangdi awabanida! Maramdi nakhoida toukhiba angakpa thabaksing adu Tyre amadi Sidon-da touramlabadi makhoina thinthadabamakhei pukning hongduna, pap tourubagi ningngamdaba adu utnabagidamak bora phi settuna masada ut chaikhatlamgadabani. ");
INSERT INTO mni_vpl VALUES ("MT11_22","070_11_22","MAT","11","22","22","Aduga wayenbagi numit aduda nakhoidagidi Tyre amadi Sidon-na henna saphagani. ");
INSERT INTO mni_vpl VALUES ("MT11_23","070_11_23","MAT","11","23","23","Aduga he Capernaum, nangdi swargada ikai khumnaba phanggadra? Natte, nangdi khamnung leibakta kumlagani, maramdi nangonda toukhiba angakpa thabaksing adu Sodom-da touramlabadi, ngasi phaoba Sodom leiramgadabani. ");
INSERT INTO mni_vpl VALUES ("MT11_24","070_11_24","MAT","11","24","24","Adubu eina nakhoida hairibasini, wayenbagi numit aduda nakhoidagidi Sodom-na henna saphagani.” ");
INSERT INTO mni_vpl VALUES ("MT11_25","070_11_25","MAT","11","25","25","Matam adumaktada Jisuna hairak-i, “He Ipa, swarga malem pumnamakki Mapu Ibungo! Eina nahakpu thagatchari maramdi nahakna hiramsing asibu masana masabu asingbani amadi akhang-aheini khanjabasingda thuptuna thambiraga anganggumna nollukchabasingda phongdokpire. ");
INSERT INTO mni_vpl VALUES ("MT11_26","070_11_26","MAT","11","26","26","Hoi, Ipa, masimak nahakki naphamdadi apenbani. ");
INSERT INTO mni_vpl VALUES ("MT11_27","070_11_27","MAT","11","27","27","“Eigi Ipana pumnamak eingongda sinabire. Mapa adu nattana kananasu Machanupa adubu khangde aduga Machanupa adu nattana Mapa adu kana amatana khangde, aduga Machanupana phongdokningba kanagumba aduda Mapu adu kanano haiba phongdok-i. ");
INSERT INTO mni_vpl VALUES ("MT11_28","070_11_28","MAT","11","28","28","“Choktharaba amasung potlum puba pumnamak eingonda changlak-u, eina nakhoibu potthahanbigani. ");
INSERT INTO mni_vpl VALUES ("MT11_29","070_11_29","MAT","11","29","29","Eigi potpu nathakta thongatlu amasung eingondagi tamjou, maramdi eidi pukning tappi amasung thamoida nolluk-i; aduga nakhoina nakhoigi thawaida potthaba phangjagani. ");
INSERT INTO mni_vpl VALUES ("MT11_30","070_11_30","MAT","11","30","30","Maramdi eigi potpudi pubada lai, amasung eigi potlumdi yangi.” ");
INSERT INTO mni_vpl VALUES ("MT12_1","070_12_1","MAT","12","1","1","Madugi matung ikui kuidana nongma potthaba numit amada Jisuna mahei maronggi loubuk phaoduna chatlammi. Amasung Ibungogi tung-inbasing aduna mapuk lamladuna gehu charong heklaga chaba hourammi. ");
INSERT INTO mni_vpl VALUES ("MT12_2","070_12_2","MAT","12","2","2","Aduga Pharisee-singna madu ubada Ibungoda hairak-i, “Yeng-u, nahakki tung-inbasingna potthaba numitta mahei-marong hektuna Wayel Yathang thugaire!” ");
INSERT INTO mni_vpl VALUES ("MT12_3","070_12_3","MAT","12","3","3","Maduda Jisuna khumlak-i, “David amadi mahakka loinabasingna mapuk lamlabada David-na kari toukhibage haiba adu nakhoina Mapugi puyada padabra? ");
INSERT INTO mni_vpl VALUES ("MT12_4","070_12_4","MAT","12","4","4","Matou karamna mahakna Mapugi sangda changduna mahak amasung mahakka loinabasing aduna purohitsing khaktana chaba yaba Tengban Mapuda katpa asengba tal adu chakhibage haibadu nakhoina padabra? ");
INSERT INTO mni_vpl VALUES ("MT12_5","070_12_5","MAT","12","5","5","Aduga Mapugi Sanglenda thougal touba purohitsingna potthaba numit khudinggi potthabagi wayel adu thugairabasu makhoi maral leite haiba adu nakhoina Moses-ki Wayel Yathangda padabara? ");
INSERT INTO mni_vpl VALUES ("MT12_6","070_12_6","MAT","12","6","6","Eina nakhoida hairibasini, Mapugi Sanglen asidagi henna chaoba ama mapham asida lei. ");
INSERT INTO mni_vpl VALUES ("MT12_7","070_12_7","MAT","12","7","7","Aduga, ‘Eina pambadi chanbiheiba aduni, iratpot adu natte’ haiba Mapugi puyagi wa asigi wahanthok nakhoina khanglamlabadi, nakhoina maral leijadabasing adubu lalhallamloidabani. ");
INSERT INTO mni_vpl VALUES ("MT12_8","070_12_8","MAT","12","8","8","Maramdi Migi Machanupa adu potthaba numitki Mapuni.” ");
INSERT INTO mni_vpl VALUES ("MT12_9","070_12_9","MAT","12","9","9","Adudagi Jisuna mapham adu thadoktuna makhoigi synagogue-ta chatlammi. ");
INSERT INTO mni_vpl VALUES ("MT12_10","070_12_10","MAT","12","10","10","Mapham aduda makhut nama pangtha-sithaduna naba nupa ama leirammi. Aduga Jisubu maral piba yanaba Pharisee-sing aduna Jisuda hanglak-i, “Potthaba numitta anaba phahanbasi Moses-ki Wayel Yathangna yabara?” ");
INSERT INTO mni_vpl VALUES ("MT12_11","070_12_11","MAT","12","11","11","Maduda Jisuna makhoida hairak-i, “Nakhoigi naraktagi kanagumba amagi yao ama potthaba numitta kom amada tarabadi, mahakna madubu paiduna loukhatloidra? ");
INSERT INTO mni_vpl VALUES ("MT12_12","070_12_12","MAT","12","12","12","Adu oirabadi mina yaodagi kayada henna mamal leiba helliba? Maram aduna, eikhoina potthaba numitta aphaba touba wayel yathangna yai.” ");
INSERT INTO mni_vpl VALUES ("MT12_13","070_12_13","MAT","12","13","13","Adudagi Ibungona makhut nama pangtha-sithaba nupa aduda hairak-i, “Nahakki nakhut adu tingthok-u.” Maduda nupa aduna makhut adu thingthokcharammi amasung makhut adu atoppa makhut nama adugumna pungpha phajare. ");
INSERT INTO mni_vpl VALUES ("MT12_14","070_12_14","MAT","12","14","14","Adudagi Pharisee-sing aduna chatkhiduna Jisubu karamna hatsige haiduna wa tanarammi. ");
INSERT INTO mni_vpl VALUES ("MT12_15","070_12_15","MAT","12","15","15","Adubu Jisuna madu khangbadagi mapham adudagi chatthokkhirammi. Aduga yamlaba miyamna Ibungogi tung injarammi. Amasung Ibungona makhoi pumnamakki anaba phahanbirammi, ");
INSERT INTO mni_vpl VALUES ("MT12_16","070_12_16","MAT","12","16","16","Adubu mahakki maramda mi kanadasu haidokkanu haiduna makhoida yathang pirammi. ");
INSERT INTO mni_vpl VALUES ("MT12_17","070_12_17","MAT","12","17","17","Masi Tengban Mapugi wa phongdokpa maichou Isaiah-na haikhiba wa adu thungnanabani: ");
INSERT INTO mni_vpl VALUES ("MT12_18","070_12_18","MAT","12","18","18","“Yeng-u, eina khandoklaba eigi inai, Eigi thawaina penjariba, eigi nungsithoiraba. Eina mahakki mathakta eigi thawai pibigani, Amasung mahakna atoppa phurupsingda eigi achumba wayel laothokkani. ");
INSERT INTO mni_vpl VALUES ("MT12_19","070_12_19","MAT","12","19","19","Mahakna khatna-cheinabasu touroi, lao khongbasu touroi, Aduga lambisingda kananasu mahakki khonjel taroi. ");
INSERT INTO mni_vpl VALUES ("MT12_20","070_12_20","MAT","12","20","20","Puraktriphaoba mahakna, achumba wayelna lanngambadu, Thudekloi mahakna, kontharaba singwutpu, Mutthatloi mahakna, mutsi mutsi chakliba thaomeibu, ");
INSERT INTO mni_vpl VALUES ("MT12_21","070_12_21","MAT","12","21","21","Aduga Ibungo mahakki mingda, thamjagani asa mipum khudingmakna.” ");
INSERT INTO mni_vpl VALUES ("MT12_22","070_12_22","MAT","12","22","22","Adudagi mi kharana mamit tangba aduga marolsu thoktaba lai phattaba changba nupa amabu Jisugi nakta purakle. Aduga Jisuna mahakpu phahanbiduna mahakna wa ngangba amasung uba ngamjare. ");
INSERT INTO mni_vpl VALUES ("MT12_23","070_12_23","MAT","12","23","23","Maduda miyam pumnamak aduna ngaklduna hairak-i, “Mahak asibu David-ki Machanupa adu oigadouribra?” ");
INSERT INTO mni_vpl VALUES ("MT12_24","070_12_24","MAT","12","24","24","Adubu touribasing adu tarabada Pharisee-singna hairak-i, “Mahakna phattaba thawaibu tanthokpa natte, adubu lai phattabasinggi mapu Satan-gi mapanna tanthokpani.” ");
INSERT INTO mni_vpl VALUES ("MT12_25","070_12_25","MAT","12","25","25","Maduda Jisuna makhoina khalliba adu khangladuna makhoida hairak-i, “Leibak manungda tokhai tokhai tanaduna amaga amaga khatnaduna leiriba leibak khudingmak mang takkani. Aduga tokhai tokhai tanaba sahar nattraga imung khudingmak amata oina kuina leptuna leiba ngamloi. ");
INSERT INTO mni_vpl VALUES ("MT12_26","070_12_26","MAT","12","26","26","Aduga Satan-na Satan-bu tanthoklabadi, mahak masamakki manungda tokhai tajare. Adu oirabadi mahakki leibak adu karamna panba ngamgadage. ");
INSERT INTO mni_vpl VALUES ("MT12_27","070_12_27","MAT","12","27","27","Aduga eina Beelzebul-gi mapanna lai phattaba tanthoklabadi, nahakki misingnadi kanagi mapanna makhoibu tanthokpage? Maram aduna nahak nasamakki tung-inbasingna nahak lali haibadu utchare. ");
INSERT INTO mni_vpl VALUES ("MT12_28","070_12_28","MAT","12","28","28","Adubu Tengban Mapugi Thawaigi mapanna eina lai phattabasingbu tanthoklabadi, Tengban Mapugi leibak adu nakhoigi nathakta laklabani. ");
INSERT INTO mni_vpl VALUES ("MT12_29","070_12_29","MAT","12","29","29","“Aduga panggal kanba nupa amabu haanna punduna phajinba nattanadi kanana mahakki yumda changduna mahakki mapot macheisingdu munduna lougadage? Mahakna nupa adubu pullaba matung khaktada mahakki mapot macheisingdu munduna puba ngamgani. ");
INSERT INTO mni_vpl VALUES ("MT12_30","070_12_30","MAT","12","30","30","“Eibu yadaba mahak aduna eigi mayokta lei; aduga eiga loinana khomjinbagi thabak touminnadaba mahak aduna madubu chaikhai. ");
INSERT INTO mni_vpl VALUES ("MT12_31","070_12_31","MAT","12","31","31","Maram aduna eina nakhoida hairibasini, pap khuding amasung thina ngangba khudingmakpu kokpigani; adubu kanagumbana Thawai Asengbagi mathakta thina nganglabadi mahakpu kokpiroi. ");
INSERT INTO mni_vpl VALUES ("MT12_32","070_12_32","MAT","12","32","32","Aduga Migi Machanupa adugi mathakta wa ngangba mahak adubu kokpigani, adubu Thawai Asengbagi mathakta ngangba mahak adubu houjikki mirol asidasu aduga lakkadaba miroldasu kokpiroi. ");
INSERT INTO mni_vpl VALUES ("MT12_33","070_12_33","MAT","12","33","33","“Upal amagi masak mahakna palliba mahei aduna tak-i. Upal aduna pharabadi mahakki mahei adusu phagani adubu upal aduna phattrabadi mahakki mahei adusu pharoi. ");
INSERT INTO mni_vpl VALUES ("MT12_34","070_12_34","MAT","12","34","34","He lilgi chada-naodasa, nakhoina phattaba mi oiraga karamna nakhoina aphaba wa nganggani? Maramdi thamoinungda thanna leiribasing adu chinbalna ngangthok-i. ");
INSERT INTO mni_vpl VALUES ("MT12_35","070_12_35","MAT","12","35","35","Aphaba mina mahakki aphaba thamoigi pukeidagi aphaba adu puthok-i, aduga phattaba mina mahakki phattaba thamoigi pukeidagi phattaba adu puthok-i. ");
INSERT INTO mni_vpl VALUES ("MT12_36","070_12_36","MAT","12","36","36","“Aduga eina nakhoida hairibasini madudi nakhoina ngangkhiba warem khudingmakki maram nakhoina wayenbagi numit aduda pigadabani. ");
INSERT INTO mni_vpl VALUES ("MT12_37","070_12_37","MAT","12","37","37","Maramdi nahakna ngangkhiba waheising adugi matung-inna nahakpu chumhanbigani nattraga nahakpu lalhan-gani.” ");
INSERT INTO mni_vpl VALUES ("MT12_38","070_12_38","MAT","12","38","38","Adudagi nongma Wayel Yathanggi oja khara amadi Pharisee-sing kharana Jisugi nakta laklaga hairak-i, “Oja nangondagi eikhoina angakpa khudam khara uning-i.” ");
INSERT INTO mni_vpl VALUES ("MT12_39","070_12_39","MAT","12","39","39","Maduda Jisuna makhoida khumlak-i, “Phattaba amadi thajaba yadaba mironna angakpa khudam thi! Adubu Tengban Mapugi wa phongdokpa maichou Jonah-gi khudam adu nattana atoppa khudam amata nakhoida piroi. ");
INSERT INTO mni_vpl VALUES ("MT12_40","070_12_40","MAT","12","40","40","Maramdi Jonah-na achouba nga adugi puknungda ahing ahum nungthil ahum leikhibagum, Migi Machanupa adunasu malem leisanungda ahing ahum nugthil ahum leigani. ");
INSERT INTO mni_vpl VALUES ("MT12_41","070_12_41","MAT","12","41","41","Amasung wayenbagi numitta Nineveh-gi misingna ngasigi miron asiga lepminnagani aduga miron asibu lalhan-gani. Maramdi Jonah-na pao sandokpa matamda makhoina paptagi pukning hongjakhi; aduga eina nakhoida hairi madudi Jonah-dagi henna chaoba ama mapham asida leiri! ");
INSERT INTO mni_vpl VALUES ("MT12_42","070_12_42","MAT","12","42","42","Aduga wayenba numitta Sheba leibakki leimarembina ngasigi miron asiga lepminnagani aduga miron asibu lalhan-gani; maramdi mahakna ningthou Solomon-gi lousinggi wa tanaba mahakki laplaba maramdamdagi lakkhi; aduga eina nakhoida tasengnamak hairi madudi Solomon-dagi henna chaoba ama mapham asida leiri adubu nakhoina tade! ");
INSERT INTO mni_vpl VALUES ("MT12_43","070_12_43","MAT","12","43","43","“Phattaba thawai amana mi amadagi thoklakpa matamda mahakna potthapham thiduna leikanglagi maphamsingda koina chatli. Aduga mahakna mapham phangdrabada, ");
INSERT INTO mni_vpl VALUES ("MT12_44","070_12_44","MAT","12","44","44","mathanta asumna haijei, ‘Eina thoklakkhiba yum aduda ei amuk hallage.’ Aduga mahakna hallakpa matamda yumdu ihang hangna, sittok-sengdoktuna ningthina thamlamba adu ure. ");
INSERT INTO mni_vpl VALUES ("MT12_45","070_12_45","MAT","12","45","45","Adudagi mahakna amuk chatkhiduna mangondagi henna phattaba thawai taret purakle, aduga makhoina mi aduda changduna mapham aduda leire. Aduga mi adugi akonbagi phibam adu hanna oiramba phibam adudagi yamna henna phalaktre. Matou asumna phattaba miron asidasu oigani.” ");
INSERT INTO mni_vpl VALUES ("MT12_46","070_12_46","MAT","12","46","46","Adudagi Jisuna miyam aduda wa nganglingeida, mahakki mama amasung machin manaosingna mangonda wa khara hainingbadagi mapanda leptuna leirammi. ");
INSERT INTO mni_vpl VALUES ("MT12_47","070_12_47","MAT","12","47","47","Aduga kanagumba amana Ibungoda hairak-i, “Yengbiyu, Ibungogi ima amasung inaosingna Ibungoda wa hainingbadagi mapanda leptuna leiri.” ");
INSERT INTO mni_vpl VALUES ("MT12_48","070_12_48","MAT","12","48","48","Maduda Ibungona nupa aduda hairak-i, “Eigi ima kanano? Aduga eigi ichin- inaosing haibasina kanabuno?” ");
INSERT INTO mni_vpl VALUES ("MT12_49","070_12_49","MAT","12","49","49","Adudagi Ibungona mahakki tung-inbasingda khut thilladuna hairak-i, “Yeng-u! Makhoising asi eigi ima amasung eigi ichin inaosingni! ");
INSERT INTO mni_vpl VALUES ("MT12_50","070_12_50","MAT","12","50","50","Maramdi swargada leiriba Ipagi aningba touriba makhoising adu eigi ichin-inao, iche-ichan amasung eigi imani.” ");
INSERT INTO mni_vpl VALUES ("MT13_1","070_13_1","MAT","13","1","1","Numit aduda Jisuna yum adudagi thokraklaga pat mapanda laktuna miyamda tambinabagidamak phamlammi. ");
INSERT INTO mni_vpl VALUES ("MT13_2","070_13_2","MAT","13","2","2","Amasung Ibungogi akoibada tilliba miyam adu yammankhibana Ibungona hi amada kakhatlaga hithakta phamladuna tambirammi, aduga miyam aduna pat mapan aduda leplammi. ");
INSERT INTO mni_vpl VALUES ("MT13_3","070_13_3","MAT","13","3","3","Adudagi Ibugona makhoida hiram kaya ama pandam sijinnaduna tambirak-i. “Yeng-u, lou-uba amana maru hunba chatlammi. ");
INSERT INTO mni_vpl VALUES ("MT13_4","070_13_4","MAT","13","4","4","Mahakna loubukta maru asum hullakpada, maru kharana lambi mapanda tare aduga ucheksing laktuna marusingdu chathokkhre. ");
INSERT INTO mni_vpl VALUES ("MT13_5","070_13_5","MAT","13","5","5","Aduga kharana leibak kaya leitaba nunglakta tare. Amasung leibak luthana leitabana marusing adu thuna mayon chonglakle. ");
INSERT INTO mni_vpl VALUES ("MT13_6","070_13_6","MAT","13","6","6","Adubu numit thorakpada nungsagi meisana pambisingdu thuna kangsilhalle, maramdi pambisingdu mara luna taramde. ");
INSERT INTO mni_vpl VALUES ("MT13_7","070_13_7","MAT","13","7","7","Aduga kharana tingkhangsinggi marakta tare, amasung tingkhangsingduna chaokhatlaktuna pambising adubu namhatle. ");
INSERT INTO mni_vpl VALUES ("MT13_8","070_13_8","MAT","13","8","8","Adubu maru kharadi aphaba leihao chenba maphamda tarammi aduga pambising adu mahei yamna yallammi, madudi kharana chama, kharana humphu aduga khara amana mahei kunthra yallammi.” ");
INSERT INTO mni_vpl VALUES ("MT13_9","070_13_9","MAT","13","9","9","Adudagi Jisuna makhoida hairak-i, “Tananaba nakong panba mahak aduna tasanu!” ");
INSERT INTO mni_vpl VALUES ("MT13_10","070_13_10","MAT","13","10","10","Adudagi tung-inbasing aduna laktuna Ibungoda hanglak-i, “Karigi Ibungona misingda pandam sijinnaduna ngangbiribano?” ");
INSERT INTO mni_vpl VALUES ("MT13_11","070_13_11","MAT","13","11","11","Maduda Jisuna makhoida khumlak-i, “Nakhoida swarga leibakki athuppa khangnaba lousing adu pibire, adubu makhoidadi pibide. ");
INSERT INTO mni_vpl VALUES ("MT13_12","070_13_12","MAT","13","12","12","Maramdi areiba mahak aduda henna pibigani, amasung mahakna marang kaina leijagani. Aduga leitaba mahak adudagi mahakki leijaba adu phaoba louthokkani. ");
INSERT INTO mni_vpl VALUES ("MT13_13","070_13_13","MAT","13","13","13","Eina makhoida pandamsing sijinnaduna nganglibagi maram adudi asini: Makhoina una una ude, aduga tana tana tade aduga khangsu khangde. ");
INSERT INTO mni_vpl VALUES ("MT13_14","070_13_14","MAT","13","14","14","Asumna maichou Isaiah-na haikhiba wasing asi makhoida thunghalle: ‘Makhoina hanna hanna tagani, adubu wakhal taba ngamloi Makhoina hanna hanna yenggani, adubu khangloi. ");
INSERT INTO mni_vpl VALUES ("MT13_15","070_13_15","MAT","13","15","15","Maramdi makhoigi thamoi kansinkhre, makhoigi manana taningde; aduga makhoigi mamit uisinkhre. Adu natlamdrabadi makhoigi mitna ujaramgadabani, makhoigi manakongna tajaramgadabani, amasung makhoina wakhal tajaduna, makhoina eingonda hallaklamgadabani, aduga eina makhoibu phahanbiramgadabani.’ ");
INSERT INTO mni_vpl VALUES ("MT13_16","070_13_16","MAT","13","16","16","“Adubu nakhoigi mit amasung nakongdi yaiphei, maramdi nakhoigi mitna ujare aduga nakhoigi nakongna tajare. ");
INSERT INTO mni_vpl VALUES ("MT13_17","070_13_17","MAT","13","17","17","Eina nakhoida tasengnamak hairibasini, Tengban Mapugi wa phongdokpiba kayana amadi achumba chatpa mi kayana nakhoina uriba adubu yamna uninglamkhi, adubu makhoina ukhide; aduga nakhoina tariba adubu taninglamkhi adubu makhoina takhide. ");
INSERT INTO mni_vpl VALUES ("MT13_18","070_13_18","MAT","13","18","18","“Maram aduna maru hunbagi pandamgi wahanthok asi taro. ");
INSERT INTO mni_vpl VALUES ("MT13_19","070_13_19","MAT","13","19","19","Ningthou leibakki wa adu tabadi targa adubu khangbadi ngamdaba makhoising adu lambi mapanda taba marusing aduga mannei. Madudi Phattaba aduna lakllaga mahakki thamoida hunkhiba maru adu louthokkhi. ");
INSERT INTO mni_vpl VALUES ("MT13_20","070_13_20","MAT","13","20","20","Aduga nunglakta hunba maru adudi wa adu taraga thunamak haraona lousinba mahak aduni. ");
INSERT INTO mni_vpl VALUES ("MT13_21","070_13_21","MAT","13","21","21","Adum oinamak makhoina mara phajana tadabana ngaihaktamak leirammi. Aduga wa adugi maramna awa-ana amadi ot-neiba lakpada mahakna thuna tukhi. ");
INSERT INTO mni_vpl VALUES ("MT13_22","070_13_22","MAT","13","22","22","Aduga tingkhang marakta hunba maru aduna wa adu tariba makhoising aduni. Adubu taibangpan punsi asigi langtaknaba amadi lanthumgi oiba nungaibagi lounamna wa adubu namhatkhibana makhoina mahei yanba ngamde. ");
INSERT INTO mni_vpl VALUES ("MT13_23","070_13_23","MAT","13","23","23","Aduga aphaba leihao chenba maphamda hunba marusing aduna wa adubu taba amadi wakhal taba makhoising aduni. Amasung makhoina mahei yalli, madudi kharana chama, kharana humphu aduga kharana mahei kunthra yalli.” ");
INSERT INTO mni_vpl VALUES ("MT13_24","070_13_24","MAT","13","24","24","Adudagi Jisuna makhoida atoppa pandam amaga hairak-i, “Swarga leibak adu masagi loubukta aphaba maru hunkhiba nupa amaga changdamnei. ");
INSERT INTO mni_vpl VALUES ("MT13_25","070_13_25","MAT","13","25","25","Adubu pumnamakna tumnaringei matamda, mahakki yeknabana laklaga gehu marakta napi maru hunjinlamlaga chatkhirammi. ");
INSERT INTO mni_vpl VALUES ("MT13_26","070_13_26","MAT","13","26","26","Aduga gehu pambi aduna chaokhatlaktuna gehu satlakpa matamda napi adusu satlakle. ");
INSERT INTO mni_vpl VALUES ("MT13_27","070_13_27","MAT","13","27","27","Maduda loupu adugi manaisingna mahakki manakta laktuna hairak-i, ‘Ibungo, nahakna nahakki loubukta aphaba maru hunkhiba nattra? Aduga napising asina kadaidagi laklibano?’ ");
INSERT INTO mni_vpl VALUES ("MT13_28","070_13_28","MAT","13","28","28","Mahakna makhoida khumlak-i, ‘Yeknaba amana masi tourambani.’ Adudagi manaising aduna mangonda hanglak-i, ‘Eikhoina chattuna napising adu phukthokcharu haibra?’ ");
INSERT INTO mni_vpl VALUES ("MT13_29","070_13_29","MAT","13","29","29","Maduda mahakna khumlak-i, ‘Phuktokluraganu, maramdi nakhoina napising adu phuktokpada gehu pambising adusu phuktokkhiba yai. ");
INSERT INTO mni_vpl VALUES ("MT13_30","070_13_30","MAT","13","30","30","Aduna lokpa matam youdribaphaobadi animak punna adum houminnarasanu. Aduga matamduda eina lou lokpagi thabak suriba mising aduda haigani nakhoina napising adu hanna phuktoktuna meida thananaba mapun oina punsillu adudagi gehusing adu khomjinduna eigi keida peisillu haigani.’ ” ");
INSERT INTO mni_vpl VALUES ("MT13_31","070_13_31","MAT","13","31","31","Jisuna makhoida atoppa pandam amasu hairak-i, “Swarga leibak adudi kanagumba mi amana louduna mahakki loubukta hullamba hanggam maru amagumbani. ");
INSERT INTO mni_vpl VALUES ("MT13_32","070_13_32","MAT","13","32","32","Hanggam maru asi marusinggi marakta khwaidagi pik-i, adumakpu chaoraklaba matamdadi mahakna ingkholgi mana masingsinggi maraktagi khwaidagi chaoba pambi oirak-i aduga upal ama oiraktuna atiyagi ucheksingna laktuna magi masasingda mahum sarei.” ");
INSERT INTO mni_vpl VALUES ("MT13_33","070_13_33","MAT","13","33","33","Jisuna makhoida atoppa pandam amagasu hairak-i: “Swarga leibak adudi nupi amana louraga yam thumok amada yansinduna anoiba yam pumnamak aduna kamkhattriphaoba thamba hameigumbani.” ");
INSERT INTO mni_vpl VALUES ("MT13_34","070_13_34","MAT","13","34","34","Jisuna hiram pumnamaksing asi miyam aduda pandamsing sijinnaduna hairammi; mahakna pandam sijinadana misingda karigumba amata hairamde. ");
INSERT INTO mni_vpl VALUES ("MT13_35","070_13_35","MAT","13","35","35","Masina Tengban Mapugi wa phongdokpa maichouna haikhiba wa adu thunghalle. “Eina nakhoida pandamsing sijinnaduna nganggani; Malem leisemngeidagi khanghandana thamlakpasing adubu eina phongdokkani.” ");
INSERT INTO mni_vpl VALUES ("MT13_36","070_13_36","MAT","13","36","36","Adudagi Jisuna miyam adu thadoklamduna yum manungda changlaklaba matungda Ibungogi tung-inbasing aduna Ibungogi nakta laktuna hairak-i, “Loubukki napigi pandam adu eikhoida sandokna takpiyu.” ");
INSERT INTO mni_vpl VALUES ("MT13_37","070_13_37","MAT","13","37","37","Maduda Jisuna makhoida khumlak-i, “Aphaba maru hulliba nupa adu Migi Machanupa aduni. ");
INSERT INTO mni_vpl VALUES ("MT13_38","070_13_38","MAT","13","38","38","Loubuk aduna taibangpanni, amasung aphaba maru aduna ningthou leibak adugi machasingni. Aduga napising aduna phattaba adugi machasingni. ");
INSERT INTO mni_vpl VALUES ("MT13_39","070_13_39","MAT","13","39","39","Amasung makhoising adubu hullamba yeknaba aduna Devil-ni. Lokpagi matam aduna taibangpangi aroiba matam aduni, aduga lokpagi thabak suribasing aduna swargadutnisingni. ");
INSERT INTO mni_vpl VALUES ("MT13_40","070_13_40","MAT","13","40","40","Aduga napising adubu khomjillaga meida thajinba aduga chap mannana taibangpangi aroiba matam adudasu oigani. ");
INSERT INTO mni_vpl VALUES ("MT13_41","070_13_41","MAT","13","41","41","Madudi Migi Machanupa aduna mahakki dutsingbu tharaktuna misingbu papta tahalliba pumnamak amasung phattaba touba pumnamakpu mahakki ningthou leibaktagi khomjingani, ");
INSERT INTO mni_vpl VALUES ("MT13_42","070_13_42","MAT","13","42","42","aduga makhoina makhoising adubu meigi komda langsin-gani, mapham aduda makhoina kap-laogani amasung maya krak-krak chikkani. ");
INSERT INTO mni_vpl VALUES ("MT13_43","070_13_43","MAT","13","43","43","Aduga Tengban Mapugi oiba misingna Mapa Ibungogi leibak aduda numitkumna ngangani. Tananaba manakong panba mahak aduna tasanu. ");
INSERT INTO mni_vpl VALUES ("MT13_44","070_13_44","MAT","13","44","44","“Swarga leibak adudi loubukta lottuna leiba lan-gumbani. Mi amana madubu phangba matamda mahakna madubu amuk hanna lotsilli. Amasung mahakna adukki matik haraojarammi madudi mahakna chatkhiduna mahakki leijaba pumnamak yonthoklaga loubuk adubu leijei. ");
INSERT INTO mni_vpl VALUES ("MT13_45","070_13_45","MAT","13","45","45","“Amuksu, swarga leibak adudi aphaba mani-mukta thiriba lalonba amagumbani. ");
INSERT INTO mni_vpl VALUES ("MT13_46","070_13_46","MAT","13","46","46","Mahakna mamal yamna tanglaba mani-mukta ama phangba matamda, mahakna chattuna mahakki leijaba pumnamak yonthoktuna mani-mukta adubu leijei. ");
INSERT INTO mni_vpl VALUES ("MT13_47","070_13_47","MAT","13","47","47","“Amukkasu, swarga leibak adudi patta hunduna makhal kayagi ngasing phariba in amagumbani. ");
INSERT INTO mni_vpl VALUES ("MT13_48","070_13_48","MAT","13","48","48","In adu ngana thallabada, nga phabasing aduna pat mapanda chingkhattuna phamtharaga ngasing adubu khandoktuna aphaba ngasing aduna tunggolda hapchilli aduga kanadaba ngasing aduna hundokkhi. ");
INSERT INTO mni_vpl VALUES ("MT13_49","070_13_49","MAT","13","49","49","Aduga taibangpangi aroiba matam adudasu matou asumna oigani. Swargadutsingna laktuna achumba chatpasingdagi phattaba misingbu tonganna khaidokkani. ");
INSERT INTO mni_vpl VALUES ("MT13_50","070_13_50","MAT","13","50","50","Aduga makhoibu meigi komda langsingani, mapham aduda makhoina kap laogani amasung maya krak-krak chikkani.” ");
INSERT INTO mni_vpl VALUES ("MT13_51","070_13_51","MAT","13","51","51","Adudagi Jisuna makhoida hairak-i, “Hairiba pumnamaksing asi nakhoi khanglabra?” Makhoina khumlak-i, “Hoi, Ibungo.” ");
INSERT INTO mni_vpl VALUES ("MT13_52","070_13_52","MAT","13","52","52","Adudagi Ibungona makhoida hairak-i, “Maram aduna swarga leibakki tung-inba oiraba Wayel Yathanggi oja khudingmak mahakki pukeida leiba ariba amasung anouba lansing puthoklakpa yumbu amagumbani.” ");
INSERT INTO mni_vpl VALUES ("MT13_53","070_13_53","MAT","13","53","53","Jisuna pandamsing asi haiba loiraba tungda mapham adu thadoklamduna, ");
INSERT INTO mni_vpl VALUES ("MT13_54","070_13_54","MAT","13","54","54","masagi lamdamda lakle. Amasung mapham aduda mahakna misingbu synagogue-ta tambirammi aduga maduda mising aduna ngakladuna hanglak-i, “Mahakna mapham kadaidagi asigumba lousing amasung matik leiba thabaksing asi tounabagi panggal phanglibano?” ");
INSERT INTO mni_vpl VALUES ("MT13_55","070_13_55","MAT","13","55","55","“Mahak asi u-suba adugi machanupa nattra? Mary-du mahakki mama nattra? Aduga Jacob, Joseph, Simon amasung Judas-na mahakki manaosing nattra? ");
INSERT INTO mni_vpl VALUES ("MT13_56","070_13_56","MAT","13","56","56","Mahakki machansing eikhoiga leiminariba nattra? Aduga mahakna kadaidagi pumnamak asi phanglibano?” ");
INSERT INTO mni_vpl VALUES ("MT13_57","070_13_57","MAT","13","57","57","Maram aduna makhoina Ibungobu yaramde. Adudagi Jisuna makhoida hairak-i, “Tengban Mapugi wa phongdokpa maichousingbu makhoigi maramdam amadi masamakki imung manungna ikai khumnabidrabasu mapham khudingmakta ikai khumnei.” ");
INSERT INTO mni_vpl VALUES ("MT13_58","070_13_58","MAT","13","58","58","Aduga makhoina thajaba leitabagi maramna, Ibungona mapham aduda matik leiba thabak yamna toukhide. ");
INSERT INTO mni_vpl VALUES ("MT14_1","070_14_1","MAT","14","1","1","Matam aduda Galilee-gi leingak mapu Herod-na Jisugi maramda tarabada, ");
INSERT INTO mni_vpl VALUES ("MT14_2","070_14_2","MAT","14","2","2","mahakna mahakki phamnaibasingda hairak-i, “Mahak asi asengbamak baptize toubiba John-ni. Mahak asibasinggi maraktagi hinggatkhre, aduna mahakna matik leiba thabaksing touba ngambagi panggal mangonda leiribani.” ");
INSERT INTO mni_vpl VALUES ("MT14_3","070_14_3","MAT","14","3","3","Mamaangda Herod-na mahakki manao nupa Philip-ki nupi Herodias masunglanggidamak John-bu pharaga punduna keisumsangda thamkhi. ");
INSERT INTO mni_vpl VALUES ("MT14_4","070_14_4","MAT","14","4","4","Maramdi John-na mangonda “Nahakna Herodias-pu louba wayen kai” haikhi. ");
INSERT INTO mni_vpl VALUES ("MT14_5","070_14_5","MAT","14","5","5","Aduga Herod-na mahakpu hatninglabasu, mahakna miyambu kirammi. Maramdi makhoina John-bu Tengban Mapugi wa phongdokpa maichou amani haina lourammi. ");
INSERT INTO mni_vpl VALUES ("MT14_6","070_14_6","MAT","14","6","6","Adubu Herod-ki mapok numitta Herodias-ki machanupina tinlibasinggi mangda jagoi saduna Herod-pu yamna pelhallammi. ");
INSERT INTO mni_vpl VALUES ("MT14_7","070_14_7","MAT","14","7","7","Maduda pelladuna mahakna nijaba adumak pibigani haiduna Herod-na mangonda wasaklammi. ");
INSERT INTO mni_vpl VALUES ("MT14_8","070_14_8","MAT","14","8","8","Aduda mamagi thousindagi mahakna “Baptize toubiba John-gi makok adu sempak amada haptuna eingonda pibiyu” haiduna Herod-ta hairammi. ");
INSERT INTO mni_vpl VALUES ("MT14_9","070_14_9","MAT","14","9","9","Maduda ningthou thawai warammi, adum oinamakpu thouram aduda tinlibasing adugi mamaangda mahakna wasakkhibagi maramna, niriba adu pinanaba mahakna yathang pirammi. ");
INSERT INTO mni_vpl VALUES ("MT14_10","070_14_10","MAT","14","10","10","Adudagi mahakna mahakki lanmising thaduna keisumsangda leiriba baptize toubiba John-gi mangak adu kak-hankhi. ");
INSERT INTO mni_vpl VALUES ("MT14_11","070_14_11","MAT","14","11","11","Aduga John-gi makok adu sempak amada haptuna puraklaga nupi aduda pire, aduga mahakna madu mamagi nakta puraklammi. ");
INSERT INTO mni_vpl VALUES ("MT14_12","070_14_12","MAT","14","12","12","Amasung John-gi tung-inbasing aduna laklaga mahakki asiba hakchang adu louduna leiron chankhi. Adudagi makhoina chattuna thoudok adubu Jisuda tamkhi. ");
INSERT INTO mni_vpl VALUES ("MT14_13","070_14_13","MAT","14","13","13","Jisuna pao adu tabada hi amada tongduna mapham adu thadoklaga mathanta achikpa mapham amada chatkhirammi. Adubu misingna madu tabada makhoi makhoigi saharsing thadoklamlaga makhongna kangphalda chattuna Ibungogi tung illaklammi. ");
INSERT INTO mni_vpl VALUES ("MT14_14","070_14_14","MAT","14","14","14","Aduga Jisuna hidagi hek kumthabaga yamlaba miyam adu uba matamda Ibungogi thamoida makhoibu nungsiba poklammi amasung mahakna makhoigi anabasingbu phahanbirammi. ");
INSERT INTO mni_vpl VALUES ("MT14_15","070_14_15","MAT","14","15","15","Adudagi numidangwairam oisillaklabada Ibungogi tung-inbasingna Ibungogi nakta laktuna hairak-i, “Mapham asi lamhangni, aduga matam asisu thengjillakle. Aduna makhoina khunggangsingda chattuna makhoi masagi chananaba leijarunaba miyam asi thadokkhrasi.” ");
INSERT INTO mni_vpl VALUES ("MT14_16","070_14_16","MAT","14","16","16","Adubu Jisuna makhoida hairak-i, “Makhoina chatlubagi mathou tade. Nakhoina oina makhoida chanaba piyu.” ");
INSERT INTO mni_vpl VALUES ("MT14_17","070_14_17","MAT","14","17","17","Makhoina Ibungoda khumlak-i, “Eikhoigi leijaba haibabu tal manga amadi nga anikhak lei.” ");
INSERT INTO mni_vpl VALUES ("MT14_18","070_14_18","MAT","14","18","18","Maduda Ibungona makhoida hairak-i, “Madu eigi inakta purak-u.” ");
INSERT INTO mni_vpl VALUES ("MT14_19","070_14_19","MAT","14","19","19","Adudagi Ibungona miyamsing adubu napi mathakta phamnanaba yathang pirammi. Aduga mahakna tal manga amasung nga ani adu louduna swargada yengkhattuna Tengban Mapubu thagatcharaga talsing adu settuna tung-inbasingda pire. Aduga tung-inbasing aduna madu miyamda yenthoklammi. ");
INSERT INTO mni_vpl VALUES ("MT14_20","070_14_20","MAT","14","20","20","Amasung makhoi pumnamakna mabuk thanna charaba matungda tung-inbasing aduna lemhouba machet makaising adu khomjinbada thumok taranithoi thankhi. ");
INSERT INTO mni_vpl VALUES ("MT14_21","070_14_21","MAT","14","21","21","Numit aduda chakhiba mising adu nupi amasung angang thadana nupa lising mangarom oirammi. ");
INSERT INTO mni_vpl VALUES ("MT14_22","070_14_22","MAT","14","22","22","Adugi hek matungda, Jisuna miyam adubu halhallingeida Ibungogi tung-inbasing adubu hi tonghanduna mahakki mang thana pat adugi wangmada chat-hallammi. ");
INSERT INTO mni_vpl VALUES ("MT14_23","070_14_23","MAT","14","23","23","Adudagi Ibungona mising adubu mayumda halhankhraba matungda haijanabagidamak mathanta chingthak amada kakhatlammi. Aduga mahakna mapham aduda mathanta leiringeida numidangwairam oisinlaklammi. ");
INSERT INTO mni_vpl VALUES ("MT14_24","070_14_24","MAT","14","24","24","Matam aduda hi adudi nungsit maiyoknabagi maramna ithakna yeiduna iyaida leirammi. ");
INSERT INTO mni_vpl VALUES ("MT14_25","070_14_25","MAT","14","25","25","Aduga nongngallamdaigi pung ahum aduwaida Jisuna ising mathakta khongna chattuna mahakki tung-inbasinggi nakta laklammi. ");
INSERT INTO mni_vpl VALUES ("MT14_26","070_14_26","MAT","14","26","26","Aduga Ibungona ising mathakta khongna chatpadu ubada, Ibungogi tung-inbasing aduna akiba phaoraduna hairak-i, “Masi tamnaba laini” amasung makhoina kibaga loinana laorammi. ");
INSERT INTO mni_vpl VALUES ("MT14_27","070_14_27","MAT","14","27","27","Adubu khudak aduda Jisuna makhoida hairak-i, “Nathouna phou, eini kiganu!” ");
INSERT INTO mni_vpl VALUES ("MT14_28","070_14_28","MAT","14","28","28","Adudagi Peter-na hairak-i, “Ibungo, asengbamak nahak oirabadi, eihakna ising mathak asida chattuna nanakta laknaba eingonda yathang pinabiyu.” ");
INSERT INTO mni_vpl VALUES ("MT14_29","070_14_29","MAT","14","29","29","Maduda Jisuna hairak-i, “Lak-u!” Aduga Peter-na hidagi kumthaduna Ibungogi manak tamna ising mathakta chatlammi. ");
INSERT INTO mni_vpl VALUES ("MT14_30","070_14_30","MAT","14","30","30","Adubu mahakna akanba nungsit adu uba matamda mahak akiba phaoraklammi amasung isingda lupthaba houraklammi. Maduda mahakna laorak-i, “Ibungo, eihakpu kanbiyu!” ");
INSERT INTO mni_vpl VALUES ("MT14_31","070_14_31","MAT","14","31","31","Khudak aduda Jisuna makhut tingthoktuna mahakpu chingkhatpiraduna hairak-i, “He, thajaba watpa, nahakna karigi chingnaribano?” ");
INSERT INTO mni_vpl VALUES ("MT14_32","070_14_32","MAT","14","32","32","Aduga makhoina hida kakhatpaga nungsit adu lepkhre. ");
INSERT INTO mni_vpl VALUES ("MT14_33","070_14_33","MAT","14","33","33","Adudagi hi manungda leiriba Ibungogi tung-inbasing aduna Ibungobu khurumjaduna hairak-i, “Tasengbamak Ibungo nahak Tengban Mapugi Machanupani!” ");
INSERT INTO mni_vpl VALUES ("MT14_34","070_14_34","MAT","14","34","34","Aduga makhoina pat adu lanthoktuna Gennesaret-ki lamda laklammi. ");
INSERT INTO mni_vpl VALUES ("MT14_35","070_14_35","MAT","14","35","35","Mapham adugi mising aduna Jisubu khanglabada akoibada leiriba lam pumnamakta Ibungona thunglabagi pao thakhirammi. Aduga misingna anaba pumnamakpu Ibungogi manakta puraktuna, ");
INSERT INTO mni_vpl VALUES ("MT14_36","070_14_36","MAT","14","36","36","anabasing aduna Ibungogi phijida sokchanaba makhoina Ibungoda haijare. Aduga madubu sokchaba anaba khudingmakna anaba phajarammi. ");
INSERT INTO mni_vpl VALUES ("MT15_1","070_15_1","MAT","15","1","1","Matam aduda Jerusalemda-gi Pharisee amasung Wayel Yathanggi oja khara laktuna Jisuda hanglak-i, ");
INSERT INTO mni_vpl VALUES ("MT15_2","070_15_2","MAT","15","2","2","“Karigi eikhoigi ipa-ipudagi chatnaraklaba chatnabi asi nahakki tung-inbasingna thugairibano? Makhoina chadringeigi mamangda makhut hamdokte!” ");
INSERT INTO mni_vpl VALUES ("MT15_3","070_15_3","MAT","15","3","3","Maduda Jisuna makhoida khumlak-i, “Aduga karigi nakhoigi chatnabi adugidamak Tengban Mapugi wayel-yathangbu thugairiba? ");
INSERT INTO mni_vpl VALUES ("MT15_4","070_15_4","MAT","15","4","4","Maramdi Tengban Mapuna hai, ‘Nakhoina nama napabu ikai khumnou’ aduga ‘Mama mapabu thina ngangba mahak adu sibagi cheirak phangsanu.’ ");
INSERT INTO mni_vpl VALUES ("MT15_5","070_15_5","MAT","15","5","5","Adubu nakhoina tambi madudi kanagumba amana mahakki mama nattraga mapada, ‘Eina nakhoida pigadabasing adu Tengban Mapugi maphamda katthokkhre’ hairabadi, ");
INSERT INTO mni_vpl VALUES ("MT15_6","070_15_6","MAT","15","6","6","mahakna mama mapada ikai khumnadrabasu karisu kaidre. Asumna nakhoina nakhoigi chatnabi adu ngaknabagidamak Tengban Mapugi yathangbu karisu nattaba oihalle. ");
INSERT INTO mni_vpl VALUES ("MT15_7","070_15_7","MAT","15","7","7","He aphasasinnabasa! Maichou Isaiah-na nakhoigi maramda phongdoklamba adu kayada chumkhraba! ");
INSERT INTO mni_vpl VALUES ("MT15_8","070_15_8","MAT","15","8","8","‘Mising asina eibu chinbanthongda ikai khumnei, adubu makhoigi thamoidi eingondagi thapna lei. ");
INSERT INTO mni_vpl VALUES ("MT15_9","070_15_9","MAT","15","9","9","Makhoina mioibagi chatnabising adubu eigi yathangsinggumna tambiduna, Makhoina eibu arembada khurummi.’ ” ");
INSERT INTO mni_vpl VALUES ("MT15_10","070_15_10","MAT","15","10","10","Adudagi Jisuna miyam adubu manakta kouraduna makhoida hairak-i, “Tao amasung masi khang-u! ");
INSERT INTO mni_vpl VALUES ("MT15_11","070_15_11","MAT","15","11","11","Chinda changkhiba aduna mi amabu maang-hanba natte, adubu chindagi thoklakpa aduna mibu maanghalli.” ");
INSERT INTO mni_vpl VALUES ("MT15_12","070_15_12","MAT","15","12","12","Adudagi Ibungogi tung-inbasing aduna Ibungogi nakta laklaga hairak-i, “Ibungona haikhiba wa aduna Pharisee-sing adu thamoi sokle haiba Ibungo khangbibra?” ");
INSERT INTO mni_vpl VALUES ("MT15_13","070_15_13","MAT","15","13","13","Maduda Ibungona khumlak-i, “Eigi swargagi Ipana thakhidaba pambi khudingmakpu maru phuktatkani. ");
INSERT INTO mni_vpl VALUES ("MT15_14","070_15_14","MAT","15","14","14","Aduga makhoigidamak karisu khallunu, makhoidi mittangbasingbu chingliba mittangba lamjingbasingni; aduga mittangbana mittangbabu lamjinglabadi makhoi animak komda tagani.” ");
INSERT INTO mni_vpl VALUES ("MT15_15","070_15_15","MAT","15","15","15","Maduda Peter-na Ibungoda hairak-i, “Pandam asi eikhoida sandokna takpiyu.” ");
INSERT INTO mni_vpl VALUES ("MT15_16","070_15_16","MAT","15","16","16","Jisuna makhoida hairak-i, “Nakhoisu houjik phaoba khangdribra? ");
INSERT INTO mni_vpl VALUES ("MT15_17","070_15_17","MAT","15","17","17","Nakhoina chakhiba khudingmak adu chakkhaoda changkhraba matungda hakchangdagi amuk thokkhi haiba nakhoina khangdabra. ");
INSERT INTO mni_vpl VALUES ("MT15_18","070_15_18","MAT","15","18","18","Adubu nakhoigi chindagi thorakpa wasing adu nakhoigi thamoidagi thoklakpani, aduga hairibasing asina nakhoibu maanghalli. ");
INSERT INTO mni_vpl VALUES ("MT15_19","070_15_19","MAT","15","19","19","Maramdi phattaba wakhallonsing, mihatpa, nupa-nupi lanaba, lamchat naidaba, huranba, chinthiba, aduga migi mangnanaba ngangba pumnamak asi thamoidagi thoklak-i. ");
INSERT INTO mni_vpl VALUES ("MT15_20","070_15_20","MAT","15","20","20","Hairibasing asina nakhoibu maanghalli. Adubu khut hamdoktana chabana nakhoibu maanghande.” ");
INSERT INTO mni_vpl VALUES ("MT15_21","070_15_21","MAT","15","21","21","Adudagi Jisuna Galilee thadoklamduna Tyre amadi Sidon lamda chatlammi. ");
INSERT INTO mni_vpl VALUES ("MT15_22","070_15_22","MAT","15","22","22","Aduga mapham aduda leiba Canaan-gi nupi amana Ibungogi nakta laktuna hairak-i, “He Ibungo, David-ki Machanupa, Ibungona eibu chanbiyu. Eigi ichanupi adu lai phattaba ama changduna tamthina ot-neiduna leire.” ");
INSERT INTO mni_vpl VALUES ("MT15_23","070_15_23","MAT","15","23","23","Adubu Jisuna mangonda paokhum amata piramde. Maduda Ibungogi tung-inbasing aduna Ibungogi manakta laklaga haijarak-i, “Ibungona mahakpu chat-hanbikhro! Mahak eikhoigi itung induna laoraga leire.” ");
INSERT INTO mni_vpl VALUES ("MT15_24","070_15_24","MAT","15","24","24","Maduda Ibungona khumlak-i, “Eihak Tengban Mapugi mangkhraba yaosing haibadi Israel-gi mising khaktagidamak tharakpani.” ");
INSERT INTO mni_vpl VALUES ("MT15_25","070_15_25","MAT","15","25","25","Adubu nupi aduna laktuna Ibungogi khuyada tuthajaduna hairak-i, “Ibungo, eibu pangbiyu!” ");
INSERT INTO mni_vpl VALUES ("MT15_26","070_15_26","MAT","15","26","26","Maduda Jisuna hairak-i, “Angangsinggi chananaba adu louduna huisingda hunjinba chumde.” ");
INSERT INTO mni_vpl VALUES ("MT15_27","070_15_27","MAT","15","27","27","Nupi aduna khumlak-i, “Madu achumbani Ibungo, adubu huising aduna makhoigi mapusinggi table-dagi tarakpa arem akhaksing adu chajei.” ");
INSERT INTO mni_vpl VALUES ("MT15_28","070_15_28","MAT","15","28","28","Adudagi Jisuna nupi aduda hairak-i, “He nupi, nahakna kayada thajaba chetliba! Nahakki ningjaba adumak nangonda oisanu.” Aduga pungpham adumaktada mahakki machanupi adu naba phajare. ");
INSERT INTO mni_vpl VALUES ("MT15_29","070_15_29","MAT","15","29","29","Adudagi Jisuna mapham adudagi Galilee-gi pat manakta hallaklaga ching amada kakhattuna phamlammi. ");
INSERT INTO mni_vpl VALUES ("MT15_30","070_15_30","MAT","15","30","30","Aduga yamlaba miyam amana makhong tekpa, mamit tangba, makhong soinaiba, lol thoktaba amadi atoppa kaya ama puraduna Ibungogi manakta laklammi. Amasung makhoibu Ibungogi mangda thamle aduga Ibungona makhoibu phahanbirammi. ");
INSERT INTO mni_vpl VALUES ("MT15_31","070_15_31","MAT","15","31","31","Aduga lol thoktabasingna wa ngangba, soinaibasingna phajaba, khong tekpasingna chatpa, amadi mamit tangbasingna ujaba adu ubada miyam adu ngaklammi amasung makhoina Israel-gi Tengban Mapubu thagatcharammi. ");
INSERT INTO mni_vpl VALUES ("MT15_32","070_15_32","MAT","15","32","32","Adudagi Jisuna mahakki tung-inbasing adubu kouraduna hairak-i, “Eina miyam asigidamak nungsiba pokle, maramdi eihakka loinana makhoina numit humni leiminnare aduga houjik makhoigi chananaba karisu leitre. Aduga eina makhoibu kari amata pijadana thadokkhiba pamde adu nattrabadi makhoi lambida wantharakpasu yai.” ");
INSERT INTO mni_vpl VALUES ("MT15_33","070_15_33","MAT","15","33","33","Maduda Ibungogi tung-inbasing aduna Ibungoda haijarak-i, “Asuk yamkhraba miyam asina chaba konanaba chinjak lamhang asida eikhoina karamna phanggadouribano?” ");
INSERT INTO mni_vpl VALUES ("MT15_34","070_15_34","MAT","15","34","34","Jisuna makhoida hairak-i, “Nakhoida tal kaya yaoribage?” Maduda makhoina khumlak-i, “Tal taret amasung nga macha kharaga yaojari.” ");
INSERT INTO mni_vpl VALUES ("MT15_35","070_15_35","MAT","15","35","35","Adudagi Ibungona miyam adubu leimaida phamthanaba hairammi. ");
INSERT INTO mni_vpl VALUES ("MT15_36","070_15_36","MAT","15","36","36","Aduga mahakna tal taret amadi nga adu louraga Tengban Mapubu thagatcharammi. Amasung talsing adu settuna tung-inbasingda pire, aduga tung-inbasing aduna miyam aduda yenthoklammi. ");
INSERT INTO mni_vpl VALUES ("MT15_37","070_15_37","MAT","15","37","37","Amasung makhoi pumnamakna mabuk thanna charaba matungda lemhouba machet makaising adu tung-inbasingna thumok taret thanna khomjinkhi. ");
INSERT INTO mni_vpl VALUES ("MT15_38","070_15_38","MAT","15","38","38","Numit aduda chakhiba mising adu nupi amasung angang thadana nupa lising marirom oirammi. ");
INSERT INTO mni_vpl VALUES ("MT15_39","070_15_39","MAT","15","39","39","Adudagi Ibungona miyam adubu thadokkhraba tungda hi amada tongduna Magadan-gi lamda chatkhirammi. ");
INSERT INTO mni_vpl VALUES ("MT16_1","070_16_1","MAT","16","1","1","Nongma Pharisee-sing amadi Sadducee-singna Jisugi nakta laktuna Ibungobu chang yengladuna swargadagi khudam ama makhoida utnaba hairammi. ");
INSERT INTO mni_vpl VALUES ("MT16_2","070_16_2","MAT","16","2","2","Maduda Ibungona makhoida hairak-i, “Numidangwairam oirakpa matamda, ‘Atiya asi nganglabadi nong-chinggi phibham phagani’ haina nakhoina hai. ");
INSERT INTO mni_vpl VALUES ("MT16_3","070_16_3","MAT","16","3","3","Aduga karigumba ayukta atiya asi nganglabadi aduga leichin nongphai thanglabadi ngasi nong tagani haina nakhoina hai. He aphasasinnabasa! Nakhoina atiyabu yenglaga nongju nungsagi phibham kari oigani haibadu takpadi ngammi, adubu nakhoina matam asigi khudamsing adudi khangba ngamde. ");
INSERT INTO mni_vpl VALUES ("MT16_4","070_16_4","MAT","16","4","4","Phattaba amadi thajada Tengban Mapuba thajadaba miron khaktana angakpa khudamsing thi, adubu Tengban Mapugi wa phongdokpa maichou Jonah-gi khudam nattana atoppa khudam amata eina piraroi.” Adudagi Ibungona makhoibu thadoktuna chatkhre. ");
INSERT INTO mni_vpl VALUES ("MT16_5","070_16_5","MAT","16","5","5","Aduga tung-inbasing aduna pat wangma lanthoraklaba matungda chananaba purakpa kaoramle haiba khanglakle. ");
INSERT INTO mni_vpl VALUES ("MT16_6","070_16_6","MAT","16","6","6","Adudagi Jisuna makhoida hairak-i, “Pharisee-sing amadi Sadducee-singgi hameidagi nakhoi mit-na sing-u amasung cheksillu.” ");
INSERT INTO mni_vpl VALUES ("MT16_7","070_16_7","MAT","16","7","7","Maduda makhoi masen khannaraduna hairak-i, “Eikhoina tal puraktabagi maramna mahakna masi hairibani.” ");
INSERT INTO mni_vpl VALUES ("MT16_8","070_16_8","MAT","16","8","8","Aduga makhoina khannaribadu Jisuna khangladuna makhoida hairak-i, “He thajaba watpasa! Karigi nakhoi nasen-gi marakta tal puraktabagi maramda khannaribano? ");
INSERT INTO mni_vpl VALUES ("MT16_9","070_16_9","MAT","16","9","9","Nakhoina houjikphaoba khangdribra? Eina tal mangana mi lising mangabu pijakhiba amasung lemhoubasing adu nakhoina thumok kaya khomgatkhibage haibadu nakhoi ningsingdabra? ");
INSERT INTO mni_vpl VALUES ("MT16_10","070_16_10","MAT","16","10","10","Aduga amuksu eina tal taretna mi lising maribu pijakhiba amasung lemhoubasing adu nakhoina thumok kaya khomgatkhibage haibadu nakhoi ningsingdabra? ");
INSERT INTO mni_vpl VALUES ("MT16_11","070_16_11","MAT","16","11","11","Eina nakhoida talgi maramda haiba natte haibasi nakhoina khangba karigi ngamdribano? Maram aduna eina amukkasu hairi, madudi nakhoina Pharisee-sing amadi Sadducee-singgi hameidagi cheksillu.” ");
INSERT INTO mni_vpl VALUES ("MT16_12","070_16_12","MAT","16","12","12","Adudagi makhoina Ibungona hairiba adu talda sijinnaba hameidagi cheksinnaba haiba natte adubu Pharisee-sing amasung Sadducee-singgi tambiba adudagi cheksinnaba makhoida haibani haibadu makhoi khanglakle. ");
INSERT INTO mni_vpl VALUES ("MT16_13","070_16_13","MAT","16","13","13","Jisuna Caesarea Philippi-gi lamda lakpa matamda, Ibungona mahakki tung-inbasing aduda hanglak-i, “Misingna Migi Machanupa adubu kanani hainabage?” ");
INSERT INTO mni_vpl VALUES ("MT16_14","070_16_14","MAT","16","14","14","Maduda makhoina khumlak-i, “Mi kharana Ibungobu baptize toubiba John-ni hai, atoppa kharana Elijah-ni hai, aduga atoppa mi kharana amuk Jeremiah nattraga Tengban Mapugi wa phongdokpasinggi maraktagi amani hainei.” ");
INSERT INTO mni_vpl VALUES ("MT16_15","070_16_15","MAT","16","15","15","Adudagi Ibungona makhoida hanglak-i, “Adubu nakhoinadi eibu kanani haina haibage?” ");
INSERT INTO mni_vpl VALUES ("MT16_16","070_16_16","MAT","16","16","16","Maduda Simon Peter-na khumlak-i, “Nahakti ahingba Tengban Mapugi Machanupa Christta aduni.” ");
INSERT INTO mni_vpl VALUES ("MT16_17","070_16_17","MAT","16","17","17","Jisuna hairak-i, “Jonah-gi machanupa Simon, nahakti yaiphabani, maramdi masi nahakki naphamda mioiba kana amatana phongdokpa natte adubu swargada leiba Ipana nangonda phongdokpibani. ");
INSERT INTO mni_vpl VALUES ("MT16_18","070_16_18","MAT","16","18","18","Aduga eina nangonda hairi, madudi nahakti Peter-ni, nungjao asigi mathakta eina eigi singlup sagani, aduga khamnung leibakki panggalna madubu maithiba piba ngamloi. ");
INSERT INTO mni_vpl VALUES ("MT16_19","070_16_19","MAT","16","19","19","Aduga eina nangonda swarga leibakki sosing pigani; nahakna malemda punba adu swargadasu pun-gani, aduga nahakna thadokpa adu swargadasu thadokkani.” ");
INSERT INTO mni_vpl VALUES ("MT16_20","070_16_20","MAT","16","20","20","Adudagi Jisuna mahak Christtani haibadu mi kana amatada haidoktanaba mahakki tung-inbasing aduda yathang pirammi. ");
INSERT INTO mni_vpl VALUES ("MT16_21","070_16_21","MAT","16","21","21","Matam adudagi houna Jisuna mahakki tung-inbasingda mangonda thokkadabasing adu khanghanba hourammi. Ibungona hairak-i, “Eihakna Jerusalem-da chatpa tai aduga ahal-lamansinggi, athoiba purohitsing amadi Wayel Yathanggi ojasinggi makhuttagi awa-ana kaya ama khaangba tai. Aduga makhoina eihakpu hatkani adubu humni suba numitta eina sibadagi hinggatkani.” ");
INSERT INTO mni_vpl VALUES ("MT16_22","070_16_22","MAT","16","22","22","Adudagi Peter-na Ibungobu tonganna kouthoktuna cheiba hourak-i, “Ibungo, madu Ibungodagi thapna leiba oisanu! Keidounungda madu Ibungoda thoktaba oisanu.” ");
INSERT INTO mni_vpl VALUES ("MT16_23","070_16_23","MAT","16","23","23","Adubu Ibungona Peter-da onsillaktuna hairak-i, “Eingondagi lapna chathokkhro, Satanǃ Nahakna eigi lambida apanba oire, maramdi nahakna Tengban Mapugi oiba aduda khande, adubu mioibagi oiba aduda khalli.” ");
INSERT INTO mni_vpl VALUES ("MT16_24","070_16_24","MAT","16","24","24","Adudagi Jisuna mahakki tung-inbasing aduda hairak-i, “Kanagumbana eigi itung inninglabadi mahakna masagi oiba aningba apambasing thadoksanu aduga mahakki cross puduna eigi itung insanu. ");
INSERT INTO mni_vpl VALUES ("MT16_25","070_16_25","MAT","16","25","25","Maramdi kanagumbana mathawai kanjaninglabadi madu mangjagani; adubu eigi amadi Aphaba Paogidamak mathawai thajarabadi mahakna madu phangjagani. ");
INSERT INTO mni_vpl VALUES ("MT16_26","070_16_26","MAT","16","26","26","Mi amana taibangpan apumba phangjaraga mahakki thawai mangjarabadi, mahakki kari tongjaba leibage? Nattraga mi amana mahakki thawaiga kariga sinnaba yabage? ");
INSERT INTO mni_vpl VALUES ("MT16_27","070_16_27","MAT","16","27","27","Maramdi Migi Machanupa aduna mapagi matik mangalda mahakki dutsingga loinana lenglakkani aduga mahakna mi khudingbu mana mana toukhiba adugi matung-inna mana pibigani. ");
INSERT INTO mni_vpl VALUES ("MT16_28","070_16_28","MAT","16","28","28","Eina nakhoida tasengnamak hairibasini, mapham asida lepliba makhoi kharadi Migi Machanupa aduna mahakki ningthou leibak aduda lenglakpa udriphaoba sibagi mahao khak tangloi.” ");
INSERT INTO mni_vpl VALUES ("MT17_1","070_17_1","MAT","17","1","1","Numit taruknigi matungda Jisuna Peter, Jacob amasung Jacob-ki manaonupa John khaktabu tonganna puraduna awangba ching amada kakhatlammi. ");
INSERT INTO mni_vpl VALUES ("MT17_2","070_17_2","MAT","17","2","2","Amasung mapham aduda Ibungona makhoigi mamangda sak-ong hongle. Aduga Ibungogi maithongdu numitkumna ngallammi, amasung mahakki phijol adu mangalgumna ngourammi. ");
INSERT INTO mni_vpl VALUES ("MT17_3","070_17_3","MAT","17","3","3","Adudagi khang-houdana Elijah amadi Moses thoraktuna Jisuga wari sanaba adu makhoina ure. ");
INSERT INTO mni_vpl VALUES ("MT17_4","070_17_4","MAT","17","4","4","Maduda Peter-na Jisuda hairak-i, “Ibungo, eikhoina mapham asida leijabasi eikhoigidamak kayada phakhraba! Nahakna yabirabadi eikhoina sang ahum, Ibungogi ama, Moses-ki ama, amasung Elijah-gi ama sasi.” ");
INSERT INTO mni_vpl VALUES ("MT17_5","070_17_5","MAT","17","5","5","Aduga mahakna nganglingeimaktada langlaba leichil amana makhoibu khanjinlammi, amasung leichil maraktagi khonjel amana hairak-i, “Mahak eigi nungsiraba Ichanupani, mangonda eina yamna pelle. Mahakna haiba tao!” ");
INSERT INTO mni_vpl VALUES ("MT17_6","070_17_6","MAT","17","6","6","Ibungogi tung-inbasing aduna khonjel adu tabada adukki matik kiraduna mamaidu leimaithakta upthaduna tuthajarammi. ");
INSERT INTO mni_vpl VALUES ("MT17_7","070_17_7","MAT","17","7","7","Adudagi Jisuna makhoigi manakta laktuna makhoibu sokpiraduna hairak-i; “Hougatlu, kiganu.” ");
INSERT INTO mni_vpl VALUES ("MT17_8","070_17_8","MAT","17","8","8","Aduga makhoina yengkhatlakpada, Jisu nattana atei kana amata ukhidre. ");
INSERT INTO mni_vpl VALUES ("MT17_9","070_17_9","MAT","17","9","9","Adudagi makhoina chingthaktagi kumtharakpa matamda Jisuna makhoida yathang piraduna hairak-i, “Migi Machanupa aduna sibadagi hinggattriba phaoba nakhoina ukhiba adu mi kana amatada haiganu.” ");
INSERT INTO mni_vpl VALUES ("MT17_10","070_17_10","MAT","17","10","10","Adudagi tung-inbasing aduna Ibungoda hanglak-i, “Adu oirabadi Christtana lenglaktringeida Elijah-na hanna lakkani haina Wayel Yathanggi ojasingna hairiba karigino?” ");
INSERT INTO mni_vpl VALUES ("MT17_11","070_17_11","MAT","17","11","11","Jisuna khumlak-i, “Asengbamak Elijah-na hanna lakkani aduga pot pumnamak masagi oipham thokpa phibhamda hanjinbigani. ");
INSERT INTO mni_vpl VALUES ("MT17_12","070_17_12","MAT","17","12","12","Adumakpu eina nakhoida hairi, Elijah-di lakkhre, aduga makhoina mahakpu khangkhide, amasung makhoina makhoigi apamba adu mangonda toukhre. Maduga chap manana makhoigi khutta Migi Machanupa adusu awa-ana nanggani.” ");
INSERT INTO mni_vpl VALUES ("MT17_13","070_17_13","MAT","17","13","13","Adudagi tung-inbasing aduna Ibungona nganglibadu Baptize toubiba John-gi maramdani haiba khangle. ");
INSERT INTO mni_vpl VALUES ("MT17_14","070_17_14","MAT","17","14","14","Adudagi makhoina miyam adugi manakta halakpa matamda nupa amana Jisugi manakta laklaga mahakki mangda khuru khudak kulladuna haijarak-i, ");
INSERT INTO mni_vpl VALUES ("MT17_15","070_17_15","MAT","17","15","15","“Ibungo, eigi ichanupabu chanbiyu! Mahak sarei houduna yamna kanna nare. Aduga mahakna toina meida amasung isingda tai. ");
INSERT INTO mni_vpl VALUES ("MT17_16","070_17_16","MAT","17","16","16","Eina mahakpu Ibungogi tung-inbasinggi manakta purakpani, adubu makhoina mahakpu phahanba ngamdre.” ");
INSERT INTO mni_vpl VALUES ("MT17_17","070_17_17","MAT","17","17","17","Maduda Jisuna hairak-i, “He thajadaba amasung seranana chingkhraba miron! Eina nakhoiga kayam kuina loinaduna leiminnakhigadage? Eina nakhoibu kayam kuina khangkhigadage? Nupamacha adu eigi inakta purak-u.” ");
INSERT INTO mni_vpl VALUES ("MT17_18","070_17_18","MAT","17","18","18","Adudagi Jisuna lai phattaba aduda cheibada nupamacha adudagi mahak thokkhirammi aduga nupamacha adu mikup aduda naba pharammi. ");
INSERT INTO mni_vpl VALUES ("MT17_19","070_17_19","MAT","17","19","19","Maduda tung-inbasing aduna Jisugi nakta tonganna laktuna Jisuda hanglak-i, “Karigi eikhoina lai phattaba adu tanthokpa ngamdribano?” ");
INSERT INTO mni_vpl VALUES ("MT17_20","070_17_20","MAT","17","20","20","Amasung Jisuna makhoida hairak-i, “Nakhoina thajaba watpanani. Eina nakhoida tasengnamak hairibasini, nakhoida hanggam marumuk chaoba thajaba leirabadi nakhoina chingjao asida ‘Mapham asidagi aduda hongdok-u’ haiba ngamgani, aduga maduda chingjao adu hongdokkhigani. Amasung nakhoida oithoktaba karisu leiroi.” ");
INSERT INTO mni_vpl VALUES ("MT17_21","070_17_21","MAT","17","21","21","Adumakpu asigumba asi charahenba amadi haijabagi mapanna nattanadi oithokte. ");
INSERT INTO mni_vpl VALUES ("MT17_22","070_17_22","MAT","17","22","22","Adudagi makhoina Galilee-da punna leiminnaraba matungda Jisuna makhoida hairak-i, “Migi Machanupa adubu misinggi makhutta pithokkadouri. ");
INSERT INTO mni_vpl VALUES ("MT17_23","070_17_23","MAT","17","23","23","Aduga makhoina mahakpu hatkani, adubu mahakna humnisuba numitta hinggatkani.” Maduda tung-inbasing adu mathawai yamna warammi. ");
INSERT INTO mni_vpl VALUES ("MT17_24","070_17_24","MAT","17","24","24","Aduga Jisu amasung mahakki tung-inbasingna Capernaum-da lakpa matamda Mapugi Sanglen-gi kanggat khomba aduna Peter-gi nakta laktuna hanglak-i, “Nakhoigi ojana Mapugi Sanglen-gi kanggat adu pidabra?” ");
INSERT INTO mni_vpl VALUES ("MT17_25","070_17_25","MAT","17","25","25","Maduda Peter-na khumlak-i, “Hoi, mahakna pi.” Adudagi Peter-na imungda changlaklammi aduga mahakna hiram adugi matangda haidringeigi mamangda Jisuna mangonda hairak-i, “Simon, nahakna kari khanbage? Taibangpan asigi ningthousingna kanadagi kanggat amadi loipot loubage, makhoi masagi leibak miyamdagira nattraga atoppa misingdagira?” ");
INSERT INTO mni_vpl VALUES ("MT17_26","070_17_26","MAT","17","26","26","Peter-na khumlak-i, “Atoppa misingdagidi lou-i.” Maduda Jisuna hairak-i, “Adu oirabadi masagi leibak miyamdagidi louningai oidre. ");
INSERT INTO mni_vpl VALUES ("MT17_27","070_17_27","MAT","17","27","27","Adum oinamakpu makhoibu khudi thihandanaba, patta chattuna khoi choppu. Aduga ahanba phaba nga adugi maya phaktokpada Mapugi Sanglen-gi kanggat thiba konnagadaba lupagi sel mayek ama phanggani. Madu louduna makhoida eikhoi anigi kanggat piyu.” ");
INSERT INTO mni_vpl VALUES ("MT18_1","070_18_1","MAT","18","1","1","Matam aduda Jisugi tung-inbasing aduna Jisugi nakta laktuna hairak-i, “Swarga leibakta kanana khwaidagi henna chaobage?” ");
INSERT INTO mni_vpl VALUES ("MT18_2","070_18_2","MAT","18","2","2","Maduda Ibungona apikpa angang amabu kousilladuna makhoigi marakta lep-halle. ");
INSERT INTO mni_vpl VALUES ("MT18_3","070_18_3","MAT","18","3","3","Adudagi Ibungona hairak-i, “Eina nakhoida tasengnamak hairibasini, nakhoina pukning hongduna apikpa angangsinggumna oirakpa natanadi, nakhoina swarga leibakta khak changloi. ");
INSERT INTO mni_vpl VALUES ("MT18_4","070_18_4","MAT","18","4","4","Maram aduna apikpa angang asigumna nollukchaba kanagumba mahak aduna swarga leibakta khwaidagi henna chao-i. ");
INSERT INTO mni_vpl VALUES ("MT18_5","070_18_5","MAT","18","5","5","Aduga eigi mingda asigumba apikpa angang amabu lousinjaba kanagumba mahak aduna eibu lousinjabani. ");
INSERT INTO mni_vpl VALUES ("MT18_6","070_18_6","MAT","18","6","6","“Kanagumbana eibu thajaba apikpa angangsing asigi maraktagi amabu papta tahallabadi, mahakki ngaksamda achouba chakkri-nung ama yansillaga aruba ipakta lup-hankhibana mahakkidamak henna phei. ");
INSERT INTO mni_vpl VALUES ("MT18_7","070_18_7","MAT","18","7","7","Misingbu papta tahalliba makhoising adugi maramna taibangpan asi awabanida! Asigumbasing asi soidana thokkani adubu athembada tahalliba mi adu awabanida! ");
INSERT INTO mni_vpl VALUES ("MT18_8","070_18_8","MAT","18","8","8","“Aduga nahakki nakhut nattraga nakhongna nahakpu papta tahallabadi, madu kakthattuna langthokkho. Maramdi nakhut ani amadi nakhong ani pallaga lomba naidaba meinungda langsinbabudi, nakhut soinaina amadi khong tekna hingbada changbana nahakidamak henna phei. ");
INSERT INTO mni_vpl VALUES ("MT18_9","070_18_9","MAT","18","9","9","Aduga nahakki mitna nahakpu papta tahallabadi, madu kotthoktuna langthokkho. Maramdi namit ani pallaga norokki meinungda langsinbabudi, namit namatang pallaga hingbada changbana nahakkidamak henna phei. ");
INSERT INTO mni_vpl VALUES ("MT18_10","070_18_10","MAT","18","10","10","“Nakhoina apikpa angangsing asigi maraktagi amabu thou-oi usittana toudananaba cheksillu. Maramdi eina nakhoida hairi, madudi matam pumnamakta eigi swargagi Ipaga loinadunata leiba makhoigi dutsing swargada lei. ");
INSERT INTO mni_vpl VALUES ("MT18_11","070_18_11","MAT","18","11","11","Maramdi Migi Machanupa aduna mangkhraba adubu kanbinanaba lakpani. ");
INSERT INTO mni_vpl VALUES ("MT18_12","070_18_12","MAT","18","12","12","“Nakhoina karamna khanbage? Kanagumba nupa amagi yao chama leijaba adudagi yao ama mangkhrabadi mahakna yao mariphutara-mapan adubu chingda thanamduna mangkhraba yao adubu thiba chatloidra? ");
INSERT INTO mni_vpl VALUES ("MT18_13","070_18_13","MAT","18","13","13","Aduga mahakna yao adu phanglabadi, eina nakhoida tasengnamak hairibasini, mahakna mangdaba yao mariphutara-mapan adudagi henna mangluraba yao amadu phangjabana thoina henna haraojei. ");
INSERT INTO mni_vpl VALUES ("MT18_14","070_18_14","MAT","18","14","14","Matou asigumna angangsing asigi maraktagi ama mangkhiba haibasi nakhoigi swargada leiba napa Ibungogi aningba natte. ");
INSERT INTO mni_vpl VALUES ("MT18_15","070_18_15","MAT","18","15","15","“Nahakki nachin-nanaona nahakki nathakta pap tourabadi, nahakna chattuna mangonda mahakki aranba adu khanghallu. Adubu madu nakhoi ani khaktagi marakta pangthok-u. Karigumba nahakna haiba adu mahakna tarabadi, nahakna nahakki nachin-nanao adu amuk hanna phangjarabani. ");
INSERT INTO mni_vpl VALUES ("MT18_16","070_18_16","MAT","18","16","16","Adubu nahakna haiba adu mahakna tadrabadi, nahakna haiba khudingmak adu achumbani haiba lepnabagi sakhi oinaba mioi ani nattraga ahum puduna amuk chatlu. ");
INSERT INTO mni_vpl VALUES ("MT18_17","070_18_17","MAT","18","17","17","Aduga makhoina haiba adudasu mahakna tadrabadi, pumnamaksing adu singlupta haiyu. Aduga singlupna haiba wa phaoba mahakna tadrabadi mahakpu Tengban Mapubu thajadaba mi amasung kanggat khomba mi amagumna lou. ");
INSERT INTO mni_vpl VALUES ("MT18_18","070_18_18","MAT","18","18","18","“Eina nakhoida tasengnamak hairibasini, nakhoina taibangpanda punba khuding eina swargadasu pun-gani, aduga nakhoina taibangpanda thadokpa khuding eina swargadasu thadokkani! ");
INSERT INTO mni_vpl VALUES ("MT18_19","070_18_19","MAT","18","19","19","“Aduga eina masimasu nakhoida tasengna hairi: Nakhoigi maraktagi anina makhoina nijariba adugi maramda malem asida pukning tinnajarabadi makhoina nijariba adu swargada leiba eigi Ipana makhoida toubigani. ");
INSERT INTO mni_vpl VALUES ("MT18_20","070_18_20","MAT","18","20","20","Maramdi eigi mingda mi ani nattraga ahum punna tinnaba mapham aduda eina makhoigi marakta lei.” ");
INSERT INTO mni_vpl VALUES ("MT18_21","070_18_21","MAT","18","21","21","Adudagi Peter-na Jisugi nakta laktuna hairak-i, “Ibungo, eigi ichin-inaona eingonda aranba thabak touraklabadi eina mahakpu kayarak ngakpigadage? Taretlak phaoba ngakpigadra?” ");
INSERT INTO mni_vpl VALUES ("MT18_22","070_18_22","MAT","18","22","22","Maduda Jisuna mangonda khumlak-i, “Natte, taretlak natte, adubu tarettu humphutararakni! ");
INSERT INTO mni_vpl VALUES ("MT18_23","070_18_23","MAT","18","23","23","Maram aduna swarga leibak asi mahakki manaisingga sel pathok pasin touge ningliba ningthou amagumbani. ");
INSERT INTO mni_vpl VALUES ("MT18_24","070_18_24","MAT","18","24","24","Aduga mahakna sel pathok pasin touba hourabada talent lising tara tonba nupa ama mahakki nakta purakle. ");
INSERT INTO mni_vpl VALUES ("MT18_25","070_18_25","MAT","18","25","25","Adubu manai aduna madu singba ngamdrabada, mahak masamak aduga mahakki nupi angang amadi mahakki leijaba pumnamak yonthoklaga sendol adu singdoknaba mabungo aduna yathang pirammi. ");
INSERT INTO mni_vpl VALUES ("MT18_26","070_18_26","MAT","18","26","26","Adubu manai aduna ningthou adugi mangda tuthajaduna khurumjaraga haijarak-i, ‘Ibungo, eibu matam kharadangga ngaibiyu, eina sel pumnamak singjage.’ ");
INSERT INTO mni_vpl VALUES ("MT18_27","070_18_27","MAT","18","27","27","Maduda mabungo aduna manai aduda nungsiba pokladuna mahakpu thadokpire aduga mahakki sendol adusu kokpire. ");
INSERT INTO mni_vpl VALUES ("MT18_28","070_18_28","MAT","18","28","28","“Adubu manai aduna mapham adudagi thoklakpada mahakki denari chama tonba ningthou manai oiminnaba mamannaba ama thengnare. Adudagi mahakna mamannaba adubu pharaga makhouri charam mettuna, ‘Eigi atonba sel adu sing-u!’ haina hairammi. ");
INSERT INTO mni_vpl VALUES ("MT18_29","070_18_29","MAT","18","29","29","Maduda mamannaba minai aduna mamaangda tuthajaduna haijarak-i, ‘Eibu matam kharadangga ngaibiyu, eina sel pumnamak singjage.’ ");
INSERT INTO mni_vpl VALUES ("MT18_30","070_18_30","MAT","18","30","30","Adubu haijariba adu mahakna yaramde. Madugi mahutta, mahakna toliba senphamdu singdriphaoba mahakpu keisumsangda thajille. ");
INSERT INTO mni_vpl VALUES ("MT18_31","070_18_31","MAT","18","31","31","Adudagi mahakki mamannaba atoppa minai kharana thokkhiba thoudoktu ubada thamoi yamna soklammi. Amasung makhoina chattuna thokkhiba thoudok pumnamak adu ningthou aduda tamlure. ");
INSERT INTO mni_vpl VALUES ("MT18_32","070_18_32","MAT","18","32","32","Adudagi ningthou aduna minai adubu koukhatladuna hairak-i, ‘He phattaba minai, nahakna eingonda haijabagi maramna eina nahakki sendon pumnamak adu kokpikhre. ");
INSERT INTO mni_vpl VALUES ("MT18_33","070_18_33","MAT","18","33","33","Eina nangbu nungsikhiba adugumna nahaknasu nahakki namannaba adubusu nungsipham thoktabra?’ ");
INSERT INTO mni_vpl VALUES ("MT18_34","070_18_34","MAT","18","34","34","Adudagi ningthou aduna saoraduna mana tonba sendon pumnamak adu singdriphaoba mahakpu ot-neinanaba keisumsangda thajillammi.” ");
INSERT INTO mni_vpl VALUES ("MT18_35","070_18_35","MAT","18","35","35","“Aduga nakhoina nakhoigi thamoidagi nachin-nanaogi ayol-aransing adu kokpidrabadi swargada leiba eigi Ipanasu nakhoida matou asigumna tougani.” ");
INSERT INTO mni_vpl VALUES ("MT19_1","070_19_1","MAT","19","1","1","Adudagi Jisuna hiramsing asi tambiba loirabada, Galilee thadoktuna Jordan turen-gi wangmada leiba Judea-gi lamda laklammi. ");
INSERT INTO mni_vpl VALUES ("MT19_2","070_19_2","MAT","19","2","2","Aduga yamlaba miyam amana Ibungogi tung injarammi, amasung mapham aduda Ibungona makhoigi anabasing adu phahanbirammi. ");
INSERT INTO mni_vpl VALUES ("MT19_3","070_19_3","MAT","19","3","3","Aduga Pharisee-sing kharasu Ibungogi nakta laklammi. Amasung makhoina chang yengladuna Ibungoda wahang asi hanglak-i, “Mi amana mahakki nupibu karigumba maram amagidamak khainabasi wayel kaibra?” ");
INSERT INTO mni_vpl VALUES ("MT19_4","070_19_4","MAT","19","4","4","Jisuna makhoida khumlak-i, “Nakhoina Mapugi puyada hairibasing asi padabra? Ahoubadagi houna sembiba Mapuna makhoibu nupa amadi nupi haina sembikhi, ");
INSERT INTO mni_vpl VALUES ("MT19_5","070_19_5","MAT","19","5","5","amasung mahakna haikhi, ‘Maram asina nupa amana mahakki mama mapabu thadoktuna magi nupida punsin-gani aduga makhoi ani hakchang amata oigani.’ ");
INSERT INTO mni_vpl VALUES ("MT19_6","070_19_6","MAT","19","6","6","Adunadi makhoi amuk hanna ani oidre, amata oire. Maram aduna Tengban Mapuna punsinbikhraba adu mi kana amatana khaidoktasanu.” ");
INSERT INTO mni_vpl VALUES ("MT19_7","070_19_7","MAT","19","7","7","Maduda makhoina Ibungoda hairak-i, “Adu oirabadi, nupa amana mahakki nupibu khainabada khaina-che ama piyu haina Moses-na yathang piramliba adu karigino?” ");
INSERT INTO mni_vpl VALUES ("MT19_8","070_19_8","MAT","19","8","8","Jisuna makhoida khumlak-i, “Nakhoigi thamoi kanbagi maramna Moses-na nakhoida nupi khainaba yarambani, adubu ahoubadadi matou asumna touramba natte. ");
INSERT INTO mni_vpl VALUES ("MT19_9","070_19_9","MAT","19","9","9","Eina nakhoida hairibasini, atoppa nupaga yumbanbagi mari leinarambagi khak nattana kanagumbana mahakki nupibu khainaduna atoppa nupi amabu luhongduna lourabadi mahakna nupi lannabagi thabak tourabani. Aduga khainarabi mahakpu louba mahak aduna nupi lannabagi thabak tourabani.” ");
INSERT INTO mni_vpl VALUES ("MT19_10","070_19_10","MAT","19","10","10","Maduda Ibungogi tung-inbasing aduna Ibungoda hairak-i, “Nupa amaga, magi nupigagi marakta asumna mari leinarabadi luhongdabana henna phei.” ");
INSERT INTO mni_vpl VALUES ("MT19_11","070_19_11","MAT","19","11","11","Aduga Jisuna makhoida hairak-i, “Wa asi mi khudingmakna lousinba ngamde, adubu Tengban Mapuna madubu pibiba makhoikhaktana lousinba ngammi. ");
INSERT INTO mni_vpl VALUES ("MT19_12","070_19_12","MAT","19","12","12","Maramdi mi kharadi mama puknungdagi masa onba oina poklak-i, aduga misingna semba masa onbasu lei, aduga kharana Tengban Mapugi swarga leibakkidamak luhongdaba misu lei. Lousinba ngamba mahak aduna masi lousinjasanu.” ");
INSERT INTO mni_vpl VALUES ("MT19_13","070_19_13","MAT","19","13","13","Nongma mi kharana makhoigi apikpa angangsingbu Jisuda khut thamhanduna makhoigidamak haijahannabagidamak puraklammi. Adubu Ibungogi tung-inbasingna makhoibu cheirammi. ");
INSERT INTO mni_vpl VALUES ("MT19_14","070_19_14","MAT","19","14","14","Maduda Jisuna hairak-i, “Apikpa angangsingdu eigi nakta lakchasanu, makhoibu thingganu, maramdi swarga leibak adu makhoi asigumbasingga manaba mising adugini.” ");
INSERT INTO mni_vpl VALUES ("MT19_15","070_19_15","MAT","19","15","15","Aduga Ibungona makhoigi mathakta khut thambiraba matungda mapham adudagi chatkhre. ");
INSERT INTO mni_vpl VALUES ("MT19_16","070_19_16","MAT","19","16","16","Nongma nupa amana Jisugi nakta laktuna asumna hangjarammi, “Aphaba Oja Ibungo, lomba naidaba hingba phangnanaba eina kari aphaba thabak toujagadage?” ");
INSERT INTO mni_vpl VALUES ("MT19_17","070_19_17","MAT","19","17","17","Jisuna mangonda hairak-i, “Nahakna eibu kari maramgi aphaba kouribage? Tengban Mapu nattana mi kana amata aphaba leite, adubu nahakna hingba phangninglabadi, nahakna mahakki yathangsing adu illu.” ");
INSERT INTO mni_vpl VALUES ("MT19_18","070_19_18","MAT","19","18","18","Nupa aduna hairak-i, “Karamba yathangno?” Maduda Jisuna khumlak-i, “Nahakna mi hatkanu, nahakna mitu-miwa lanaganu, nahakna huran-ganu, nahakna aranba sakhi piganu. ");
INSERT INTO mni_vpl VALUES ("MT19_19","070_19_19","MAT","19","19","19","Nama napabu ikai khumnou, amasung nahakki yumlon keironnabasingbu nasamakkumna nungsiyu.” ");
INSERT INTO mni_vpl VALUES ("MT19_20","070_19_20","MAT","19","20","20","Maduda naha aduna Ibungoda hairak-i, “Eina angang oiringeidagi houna hairiba yathang pumnamaksing asi ngakcharak-i; houjik eina tougadaba kari ama amuk watlibage?” ");
INSERT INTO mni_vpl VALUES ("MT19_21","070_19_21","MAT","19","21","21","Jisuna mangonda hairak-i, “Nahakna mapung phaba oininglabadi, nahakna chattuna nahakki leijaba pumnamak yonthoklaga lairabasingda piyu, adu oirabadi swargada nahakki lan leigani; aduga lak-u, eigi itung illu.” ");
INSERT INTO mni_vpl VALUES ("MT19_22","070_19_22","MAT","19","22","22","Adubu naha aduna wasing asi tabada, pukning wana chatkhirammi; maramdi mahak maral-mathum yamna leiba mi oirammi. ");
INSERT INTO mni_vpl VALUES ("MT19_23","070_19_23","MAT","19","23","23","Adudagi Jisuna mahakki tung-inbasing aduda hairak-i, “Eina nakhoida tasengnamak hairibasini, inakkhunba mina swarga leibakta changba yamna lui. ");
INSERT INTO mni_vpl VALUES ("MT19_24","070_19_24","MAT","19","24","24","Eina nakhoida amuk hanna hairi, madudi inakkhunba mi amana Tengban Mapugi leibakta changbabudi, ut amana yetum manada litpana henna lai.” ");
INSERT INTO mni_vpl VALUES ("MT19_25","070_19_25","MAT","19","25","25","Ibungogi tung-inbasing aduna wapham adu tabada yamna ngakladuna Ibungoda hangjarak-i, “Adu oirabadi kanana kanbiba phangba ngamgadage?” ");
INSERT INTO mni_vpl VALUES ("MT19_26","070_19_26","MAT","19","26","26","Jisuna makhoida yengladuna hairak-i, “Mioibagi maphamdadi masi oithoktabani, adubu Tengban Mapugi maphamdadi pumnamak oithokpa ngaktani.” ");
INSERT INTO mni_vpl VALUES ("MT19_27","070_19_27","MAT","19","27","27","Adudagi Peter-na Ibungoda hairak-i, “Yengbiyu, eikhoina pumnamak thadoktuna Ibungogi tung injare. Adu oirabadi eikhoina kari phangjagani?” ");
INSERT INTO mni_vpl VALUES ("MT19_28","070_19_28","MAT","19","28","28","Jisuna makhoida hairak-i, “Eina nakhoida tasengnamak hairibasini, anouba taibangpan aduda Migi Machanupa aduna mahakki matik mangalgi phambalda phamba matamda, eigi tung-inba nakhoi taranithoisu phambal taranithoida phamduna, Israel-gi salai taranithoibu wayen-gani. ");
INSERT INTO mni_vpl VALUES ("MT19_29","070_19_29","MAT","19","29","29","Aduga eigi maramgidamak mayum makei, machin-manao, machan-mache, mama mapa, macha-masu, lou-sing thadokpa mi khudingmakna madugi saruk chama henna amasung lomba naidaba hingba phangjagani. ");
INSERT INTO mni_vpl VALUES ("MT19_30","070_19_30","MAT","19","30","30","Adubu ahanba oiriba kayana akonba oigani, aduga akonba oiriba kayana ahanba oigani.” ");
INSERT INTO mni_vpl VALUES ("MT20_1","070_20_1","MAT","20","1","1","“Maramdi swarga leibak adudi mahakki anggur ingkholda thabak suhannabagidamak mi neknaba ayuk anganbada chatthorakpa ingkhol mapu amagumbani. ");
INSERT INTO mni_vpl VALUES ("MT20_2","070_20_2","MAT","20","2","2","Aduga mahakna thabak subasing aduga nongmagi khutsumal denari ama pibada yanaraduna makhoibu anggur ingkholda thakhre. ");
INSERT INTO mni_vpl VALUES ("MT20_3","070_20_3","MAT","20","3","3","Aduga mahakna pung mapan taba aduwaida amuk chatthokpa matamda keithelda mi kharana karisu toudana leptuna leibadu ure. ");
INSERT INTO mni_vpl VALUES ("MT20_4","070_20_4","MAT","20","4","4","Maduda mahakna makhoida hairak-i, ‘Nakhoisu anggur ingkholda chattuna thabak suru, aduga eina nakhoigi matik chaba khutsumal adu pige.’ ");
INSERT INTO mni_vpl VALUES ("MT20_5","070_20_5","MAT","20","5","5","Maduda makhoina chatkhre. Adudagi numityungba matamda amadi pung ahum taba matamda mahakna amuk chatthoktuna maduga chap manana atoppa ateisu amuk thare. ");
INSERT INTO mni_vpl VALUES ("MT20_6","070_20_6","MAT","20","6","6","Aduga nungthilgi pung mangarom tabada mahakna chatthokluba matam adudasu atoppa mi kharana karisu toudana leptuna leiba thengnare. Maduda mahakna makhoida hairak-i, ‘Nakhoina numit chuppa thabak karisu sudana leptuna leiriba karigino?’ ");
INSERT INTO mni_vpl VALUES ("MT20_7","070_20_7","MAT","20","7","7","Makhoina khumlak-i, ‘Maramdi kana amatana eikhoibu nekpidre,’ Aduda mahakna makhoida hairak-i, ‘Adudi phare, nakhoisu eigi anggur ingkholda chatuna thabak suru, aduga nakhoina matik chaba khutsumal adu phanggani.’ ");
INSERT INTO mni_vpl VALUES ("MT20_8","070_20_8","MAT","20","8","8","“Adudagi numidangwairam oisillaklabada anggur ingkholgi mapu aduna mahakki thabak pannaba mi adu kouraduna hairak-i, ‘Thabak subasing adu kouduna akonba nekpa adudagi houduna ahanba nekkhiba makhoising adugi khutsumal piyu.’ ");
INSERT INTO mni_vpl VALUES ("MT20_9","070_20_9","MAT","20","9","9","Adudagi nungthilgi pung manga tabada nekkhibasing adu lakle aduga makhoina denari amamam phangjare. ");
INSERT INTO mni_vpl VALUES ("MT20_10","070_20_10","MAT","20","10","10","Aduga ahanba nekkhibasing aduna lakpada makhoina khutsumal henna phanggani haina khanjarammi, adubu makhoi khudingmaksu chap manana denari amamam phanglammi. ");
INSERT INTO mni_vpl VALUES ("MT20_11","070_20_11","MAT","20","11","11","Aduga makhoina khutsumal adu louba matamda loupu adugi mathakta murum murum solladuna wakatlak-i. ");
INSERT INTO mni_vpl VALUES ("MT20_12","070_20_12","MAT","20","12","12","‘Akonba nekpasing asina pung amatamak thabak sui, aduga numit chuppa nungsagi meisalakta thabak sukhiba eikhoiga makhoiga chap manahalle.’ ");
INSERT INTO mni_vpl VALUES ("MT20_13","070_20_13","MAT","20","13","13","“Maduda mahakna makhoigi maraktagi amada khumlak-i, ‘Marup, eina nangonda aranba toude; eiga nangga mayamna pinariba denari ama pibada yanakhiba nattra? ");
INSERT INTO mni_vpl VALUES ("MT20_14","070_20_14","MAT","20","14","14","Houjik nahakki khutsumal adu louraga chatkhro. Eina nangonda piba aduga chap mannana eina akonba nekpa mi asida piba eigi apambani. ");
INSERT INTO mni_vpl VALUES ("MT20_15","070_20_15","MAT","20","15","15","Isagi selna isagi apamba toubadu eigi ining nattabra? Nattraga eina atoppasingda pina heibagi maramna nakhoina kalak khambanlibra?’ ” ");
INSERT INTO mni_vpl VALUES ("MT20_16","070_20_16","MAT","20","16","16","“Maram aduna houjik akonba oibasingna ahanba oigani, aduga ahanba oibasingna akonba oigani.” ");
INSERT INTO mni_vpl VALUES ("MT20_17","070_20_17","MAT","20","17","17","Adudagi Jisuna Jerusalem-da chatlammi. Amasung lambida mahakna mahakki tung-inba taranithoibu tonganna puthokladuna hairak-i, ");
INSERT INTO mni_vpl VALUES ("MT20_18","070_20_18","MAT","20","18","18","“Yeng-u, eikhoina houjik Migi Machanupa adubu athoiba purohit amadi Wayel Yathanggi ojasinggi makhutta pithokadaba mapham Jerusalem-da chatli. Makhoina mahakpu hatnanabagi maran sigani. ");
INSERT INTO mni_vpl VALUES ("MT20_19","070_20_19","MAT","20","19","19","Aduga mahakpu noknanabagidamak, phunanabagidamak amadi cross-ta pang tingduna hatnabagidamak Jihudi nattaba misinggi makhutta pithokkani aduga humni suba numitta mahakna amuk hinggatkani.” ");
INSERT INTO mni_vpl VALUES ("MT20_20","070_20_20","MAT","20","20","20","Adudagi Zebedee-gi nupina machanupa aniga loinana Jisugi nakta laktuna khurumjaraga Ibungodagi karigumba ama nijarammi. ");
INSERT INTO mni_vpl VALUES ("MT20_21","070_20_21","MAT","20","21","21","Maduda Jisuna mangonda hanglak-i, “Nahakna kari pambage?” Mahakna Ibungoda khumlak-i, “Eigi ichanupa ani asina Ibungogi leibakta amana Ibungogi yetta aduga amana oida phamnanabagi yathang pinabiyu.” ");
INSERT INTO mni_vpl VALUES ("MT20_22","070_20_22","MAT","20","22","22","Maduda Jisuna makhoida hairak-i, “Nakhoina nijariba adu karino haiba nakhoina khangde. Eihakna thakkadouriba awa-anagi tenggot adu nakhoina thakpa ngamgadra?” Makhoina khumlak-i, “Hoi, eikhoina ngamjagani.” ");
INSERT INTO mni_vpl VALUES ("MT20_23","070_20_23","MAT","20","23","23","Jisuna makhoida hairak-i, “Achumbamak nakhoina eigi tenggot adu thakpadi thakkani, adubu eigi yetta nattraga oida phamba haibadudi eina pigadaba natte, adubu masidi eigi Ipana makhoigidamaktani haina thourang langbikhraba makhoising adugini.” ");
INSERT INTO mni_vpl VALUES ("MT20_24","070_20_24","MAT","20","24","24","Adudagi atoppa tung-inba tara aduna masigi maramda tarabada, machin- manao makhoi anigi mathakta saorammi. ");
INSERT INTO mni_vpl VALUES ("MT20_25","070_20_25","MAT","20","25","25","Maduda Jisuna makhoi pumnamakpu mahakki manakta kousillaga hairak-i, “Taibangpanba asigi leingakpani hairibasing aduna misinggi mathakta palli aduga makhoigi luchingbasing aduna makha tabasinggi mathakta namthaduna pannabagi matik adu lei. ");
INSERT INTO mni_vpl VALUES ("MT20_26","070_20_26","MAT","20","26","26","Adubu nakhoigi naraktadi asumna tougadaba natte. Nakhoigi naraktagi achouba oiningba mahak aduna ateising adugi thougal touba mi oigadabani; ");
INSERT INTO mni_vpl VALUES ("MT20_27","070_20_27","MAT","20","27","27","Aduga nakhoigi naraktagi khwaidagi makok oiningba mahak aduna pumnamakki manai oigadabani. ");
INSERT INTO mni_vpl VALUES ("MT20_28","070_20_28","MAT","20","28","28","Maramdi Migi Machanupa aduna mahak masabu thougal touhannaba lakpa natte adubu misingbu thougal tounanaba aduga mayamgi thadokmal oina mahakki thawai pinabiba lakpani.” ");
INSERT INTO mni_vpl VALUES ("MT20_29","070_20_29","MAT","20","29","29","Jisu amadi mahakki tung-inbasingna Jericho thadokpa matamda yamlaba miyam amana makhoigi tung illammi. ");
INSERT INTO mni_vpl VALUES ("MT20_30","070_20_30","MAT","20","30","30","Amasung lambigi mataida phamduna leiriba mamit tangba mi anina Jisuna lambi aduda lakli haiba tabada khonjel houna laoba hourak-i, “He Ibungo, David-ki Machanupa, eikhoibu chanbiyu.” ");
INSERT INTO mni_vpl VALUES ("MT20_31","070_20_31","MAT","20","31","31","Maduda miyam aduna makhoibu cheiraduna tuminna leinaba hairammi. Adubu makhoina amukka hena houna laorak-i, “He Ibungo, David-ki Machanupa, eikhoibu chanbiyu.” ");
INSERT INTO mni_vpl VALUES ("MT20_32","070_20_32","MAT","20","32","32","Maduda Jisuna chatlambadagi leple. Aduga makhoibu kouraduna hairak-i, “Eina nakhoigidamak kari toubiba nakhoina pambage?” ");
INSERT INTO mni_vpl VALUES ("MT20_33","070_20_33","MAT","20","33","33","Makhoina khumlak-i, “Ibungo, eikhoibu mit uhanbiyuǃ” ");
INSERT INTO mni_vpl VALUES ("MT20_34","070_20_34","MAT","20","34","34","Maduda Jisuna makhoibu nungsiba pokladuna makhoigi mamitta sokpire. Aduga khudak aduda makhoina uba ngamjare amasung makhoina Ibungogi tung injare. ");
INSERT INTO mni_vpl VALUES ("MT21_1","070_21_1","MAT","21","1","1","Adudagi Jisu amadi mahakki tung-inbasingna Jerusalem naksillaklabada, makhoina chorphon chingda leiba Bethphage khunda laklammi. Aduga Ibungona tung-inbasinggi maraktagi makhoi anibu mangjounana tharaduna, ");
INSERT INTO mni_vpl VALUES ("MT21_2","070_21_2","MAT","21","2","2","makhoida hairak-i, “Nakhoigi mangda leiriba khun aduda chatlu, aduga nakhoina maduda hek changbaga lola mapi-macha punduna leiba nakhoina thengnagani. Makhoibu thouri thoktuna eigi nakta purak-u. ");
INSERT INTO mni_vpl VALUES ("MT21_3","070_21_3","MAT","21","3","3","Aduga kanagumbana nakhoina touribadu karino haina hanglaklabadi, nakhoina mangonda Ibungona masi mathou tai haina haiyu; aduga khudakta nakhoina makhoibu puba mahakna yabirakkani.” ");
INSERT INTO mni_vpl VALUES ("MT21_4","070_21_4","MAT","21","4","4","Masi pumnamaksing asi Tengban Mapugi wa phongdokpiba maichouna haikhiba wa adu thungnanabani. ");
INSERT INTO mni_vpl VALUES ("MT21_5","070_21_5","MAT","21","5","5","“Haiyu, nakhoina Zion-gi misingda, Yeng-u, nakhoigi ningthouna nakhoida lengbirakli! Ibungodi nolluk-i amasung tong-i lola amada, tong-i lola macha amagi mathakta.” ");
INSERT INTO mni_vpl VALUES ("MT21_6","070_21_6","MAT","21","6","6","Adudagi tung-inba ani aduna chatkhiduna Jisuna makhoida yathang pikhibasing adu toure. ");
INSERT INTO mni_vpl VALUES ("MT21_7","070_21_7","MAT","21","7","7","Makhoina lola mapi-machadu Jisugi manakta puraktuna madugi mathakta makhoigi phising thare aduga Ibungona madugi mathakta tongle. ");
INSERT INTO mni_vpl VALUES ("MT21_8","070_21_8","MAT","21","8","8","Amasung mi mayam amana makhoigi phi tingthoktuna lambida thajarammi aduga ateisingna upal-singdagi mana panba anouba masasing kaktuna lambida thajarammi. ");
INSERT INTO mni_vpl VALUES ("MT21_9","070_21_9","MAT","21","9","9","Aduga Ibungogi mangda amadi tung induna chatliba miyam aduna laorak-i, “Hosanna! David-ki Machanupada! MAPU IBUNGO-gi mingda lengbirakliba Mahak yaiphabani! Hosanna haina wangthoiraba swargada laosanu!” ");
INSERT INTO mni_vpl VALUES ("MT21_10","070_21_10","MAT","21","10","10","Jisuna Jerusalem changlakpada sahar apumba mathum marang houraduna makhoina hanglak-i, “Mahak asi kanano?” ");
INSERT INTO mni_vpl VALUES ("MT21_11","070_21_11","MAT","21","11","11","Maduda miyam aduna khumlak-i, “Mahak Galilee-gi Nazareth-tagi Tengban Mapugi wa phongdokpa Jisuni.” ");
INSERT INTO mni_vpl VALUES ("MT21_12","070_21_12","MAT","21","12","12","Adudagi Jisuna Mapugi Sanglenda changduna Sanglen manungda iratpotki sa yolliba amadi leiriba makhoi pumnamakpu tanthokle amasung Ibungona sel kaithok kaisin touribasinggi table amadi khunu yollibasinggi phampham mathak makha onthokle. ");
INSERT INTO mni_vpl VALUES ("MT21_13","070_21_13","MAT","21","13","13","Aduga Ibungona makhoida hairak-i, “Mapugi puyada masi iduna lei, ‘Eigi yumdi haijanabagi yum kougani,’ adubu nakhoina masibu huranbasinggi makon oihalle!” ");
INSERT INTO mni_vpl VALUES ("MT21_14","070_21_14","MAT","21","14","14","Aduga mamit tangbasing amadi makhong tekpasingna Jisugi nakta Mapugi Sanglenda lakcharammi amasung Ibungona makhoibu phahanbirammi. ");
INSERT INTO mni_vpl VALUES ("MT21_15","070_21_15","MAT","21","15","15","Adubu athoiba purohitsing amasung Wayel Yathanggi ojasingna Ibungona toukhiba angakpa thabaksing adu ubada amasung Mapugi Sanglenda “Hosanna, David-ki Machanupa” haina angangsingna laobadu tabada saoraduna, ");
INSERT INTO mni_vpl VALUES ("MT21_16","070_21_16","MAT","21","16","16","Ibungoda hairak-i, “Angangsingna hairiba asi nahak tadabra?” Maduda Jisuna makhoida khumlak-i, “Hoi, ei tai. Nakhoina, ‘Angangsing amadi khomlang chinglibasinggi chindagi nahakpu thagatnanaba nahakna makhoibu mapung phahanbire haiba Tengban Mapugi wa adu padabra?’ ” ");
INSERT INTO mni_vpl VALUES ("MT21_17","070_21_17","MAT","21","17","17","Adudagi Jisuna makhoibu thadoktuna sahar adudagi Bethany khunda chatlammi. Aduga mahakna mapham aduda ahing leklammi. ");
INSERT INTO mni_vpl VALUES ("MT21_18","070_21_18","MAT","21","18","18","Mathang numitki ayuk anganbada, Jisuna Jerusalem saharda halakpagi lambida chak lamlaklammi. ");
INSERT INTO mni_vpl VALUES ("MT21_19","070_21_19","MAT","21","19","19","Aduga Ibungona lambi mapanda heiyit pambi ama houba ubada pambidugi manakta changlammi adubu manakhak nattana mahei amata panba thengnaramde. Maduda Ibungona heiyit pambi aduda hairak-i, “Matam pumnamakta nahak mahei pandaba oirasanu!” Aduga khudak aduda heiyit pambi adu kangsillaklammi. ");
INSERT INTO mni_vpl VALUES ("MT21_20","070_21_20","MAT","21","20","20","Madu ubada Ibungogi tung-inbasing aduna ingak ngakladuna hairak-i, “Karamna heiyit pambi asina asuk thuna khangsillaklibano?” ");
INSERT INTO mni_vpl VALUES ("MT21_21","070_21_21","MAT","21","21","21","Jisuna makhoida khumlak-i, “Eina nakhoida tasengnamak hairibasini, karigumba nakhoida thajaba leiraba aduga chingnadrabadi, heiyit pambi asida toukhiba asigumna nakhoina touba ngamba khakta nattaduna nakhoina chingjao asidasu ‘Nasa nathanta phuktuna pat asida langthajou,’ haibada madu oigani. ");
INSERT INTO mni_vpl VALUES ("MT21_22","070_21_22","MAT","21","22","22","Nakhoida thajaba leirabadi nakhoina haija-nijaba matamda nijaba khudingmak nakhoina phangjagani.” ");
INSERT INTO mni_vpl VALUES ("MT21_23","070_21_23","MAT","21","23","23","Adudagi Jisuna Mapugi Sanglenda changduna tambiringeida athoiba purohitsing amasung ahal-lamansingna Ibungogi nakta laktuna hairak-i, “Nahakki karamba matik leiduna asigumba thabaksing asi touribano? Aduga kanana matik asi nangonda pibage?” ");
INSERT INTO mni_vpl VALUES ("MT21_24","070_21_24","MAT","21","24","24","Jisuna makhoida khumlak-i, “Eisu nakhoida wahang ama hangge, nakhoina madugi paokhum eingonda piragadi eigi karamba itik leiduna asigumba thabaksing asi touribano haibadu eina nakhoida haige. ");
INSERT INTO mni_vpl VALUES ("MT21_25","070_21_25","MAT","21","25","25","John-da leiriba baptize tounabagi matik adu swargadagira nattraga misingdagira?” Makhoina kari khumgadage haibadu makhoi masen khannarammi. “Eikhoina swargadagini haina khumlagadi, mahakna haigani, ‘Adu oirabadi nakhoina John-bu karigi thajadribano?’ ");
INSERT INTO mni_vpl VALUES ("MT21_26","070_21_26","MAT","21","26","26","Aduga amaromda eikhoina madu ‘Misingdagini hairagasu,’ eikhoina misingbu ki maramdi mi pumnamakna John-bu Tengban Mapugi wa phongdokpa maichou amani haina lou-i.” ");
INSERT INTO mni_vpl VALUES ("MT21_27","070_21_27","MAT","21","27","27","Maram aduna makhoina Jisuda khumlak-i, “Eikhoi khangde.” Maduda Jisuna makhoida hairak-i, “Adu oirabadi, eigi karamba itik leiduna asigumba thabaksing asi touribano haibadu einasu nakhoida hairaroi.” ");
INSERT INTO mni_vpl VALUES ("MT21_28","070_21_28","MAT","21","28","28","“Adubu masigi maramda nakhoina kari khanbage? Nupa amagi machanupa ani leirammi. Aduga mahakna machanupa ahan-gi nakta laktuna hairammi, ‘Ichanupa, ngasidi eigi anggur ingkholda chattuna thabak suru.’ ");
INSERT INTO mni_vpl VALUES ("MT21_29","070_21_29","MAT","21","29","29","Maduda machanupa aduna khumlak-i, ‘Ei chatloi,’ adubu mameithangdadi mahak pukning honglaktuna chatkhirammi. ");
INSERT INTO mni_vpl VALUES ("MT21_30","070_21_30","MAT","21","30","30","Adudagi mapa aduna anisuba machanupa adugi nakta laklaga matou adugumduna mangondasu haire. Maduda machanupa aduna khumlak-i, ‘Hoi chatchage, paba,’ adubu mahakna chatkhide. ");
INSERT INTO mni_vpl VALUES ("MT21_31","070_21_31","MAT","21","31","31","Makhoi ani asigi maraktagi karambana mapagi aningba adu toukhibage?” Makhoina khumlak-i, “Machanupa ahal aduna toukhi.” Adudagi Jisuna makhoida hairak-i, “Eina nakhoida hairibasini, kanggat khombasing amasung oktabisingna nakhoidagi hanna Tengban Mapugi leibakta changani. ");
INSERT INTO mni_vpl VALUES ("MT21_32","070_21_32","MAT","21","32","32","Maramdi baptize touba John-na achumba lambi adubu nakhoida utpiba lakkhi, adubu nakhoina mahakpu thajakhide; adubu kanggat khombasing amasung oktabisingnadi mahakpu thajakhi. Aduga nakhoina masi uraba matungda phaoba nakhoina pukning hongduna mahakpu thajade.” ");
INSERT INTO mni_vpl VALUES ("MT21_33","070_21_33","MAT","21","33","33","Adudagi Jisuna makhoida hairak-i, “Atoppa pandam amasu tao,” “Kanagumba anggur ingkhol koiba ingkhol mapu ama leirammi. Mahakna ingkholdugi akoibada sambal khare, aduga anggur mahi sumpham ama toure, amasung ingkhol ngaknaba awangba loutangsang amasu sare. Madudagi mahakna anggur ingkhol adu ingkhol pannabasingda sandoklamlaga atoppa lam amada chatkhre. ");
INSERT INTO mni_vpl VALUES ("MT21_34","070_21_34","MAT","21","34","34","Amasung mahei lokpagi matam laklabada mahakna mahakki manaisingbu ingkhol koibasing adudagi mahakki phangpham thokpa saruk lourunaba thare. ");
INSERT INTO mni_vpl VALUES ("MT21_35","070_21_35","MAT","21","35","35","Adubu ingkhol koibasing aduna mahakki manaising adubu phaduna, amabuna phubire, atoppa amana hatle, aduga atoppa amabuna nungna thare. ");
INSERT INTO mni_vpl VALUES ("MT21_36","070_21_36","MAT","21","36","36","Adudagi mahakna ahanba adudagi henna yamba atoppa manaising amuk thare. Adubu makhoising adubusu makhoina hannagi adugumna chap manana toukhi. ");
INSERT INTO mni_vpl VALUES ("MT21_37","070_21_37","MAT","21","37","37","Ikon-konbada ingkhol mapu aduna mahakki machanupabudi ikai khumnabigani khalladuna mahakna machanupabu thare. ");
INSERT INTO mni_vpl VALUES ("MT21_38","070_21_38","MAT","21","38","38","Adubu ingkhol koibasing aduna machanupa adubu ubada makhoi masen-gi marakta asumna hainarammi, ‘Mahak asi yumlep charani, lak-o, eikhoina mahakpu hatlasi, aduga eikhoina mahakki lanthum asi lourasi.’ ");
INSERT INTO mni_vpl VALUES ("MT21_39","070_21_39","MAT","21","39","39","Aduga makhoina mahakpu pharaga anggur ingkholgi mapanda chingthoktuna hatle. ");
INSERT INTO mni_vpl VALUES ("MT21_40","070_21_40","MAT","21","40","40","“Houjik, anggur ingkholgi mapu aduna lakpa matamda, makhoising adugi mathakta mahakna kari tougani haina nakhoina khanbage?” ");
INSERT INTO mni_vpl VALUES ("MT21_41","070_21_41","MAT","21","41","41","Maduda makhoina khumlak-i, “Mahakna phattaba makhoising adubu tamthina hatkani aduga anggur ingkhol adubu lourok matam khudinggi mahakki saruk adu pirakkadaba ingkhol koibasingda pithokkani.” ");
INSERT INTO mni_vpl VALUES ("MT21_42","070_21_42","MAT","21","42","42","Adudagi Jisuna makhoida hairak-i, “Nakhoina Mapugi puyada masi pakhidabra? ‘Yumsabasingna kanadre haiduna hundoklaba nung adu, Oirakle khwaidagi maruoiba chithekki nung. MAPU IBUNGO-na masi toubire, Eikhoigi mityengda masi kayada angakpano!’ ");
INSERT INTO mni_vpl VALUES ("MT21_43","070_21_43","MAT","21","43","43","“Maram aduna eina nakhoida hairi, Tengban Mapugi leibak adu nakhoidagi louthokkani aduga mahei ningthina puthokkadaba phurup amada madu pigani. ");
INSERT INTO mni_vpl VALUES ("MT21_44","070_21_44","MAT","21","44","44","Aduga nung asigi mathakta tuba mahak adu machet machet tana kaigani aduga nung asina mathakta taba mahakpu uphulgumna toigani.” ");
INSERT INTO mni_vpl VALUES ("MT21_45","070_21_45","MAT","21","45","45","Athoiba purohitsing amadi Pharisee-sing aduna Ibungogi pandamsing adu tabada, Ibungona makhoigi maramda nganglibani haiba khanglammi. ");
INSERT INTO mni_vpl VALUES ("MT21_46","070_21_46","MAT","21","46","46","Maram aduna makhoina Ibungobu phananaba lambi ama thirammi. Adubu misingna Jisubu Tengban Mapugi wa phongdokpa maichou amani haina louba maramna makhoina miyam adubu kirammi. ");
INSERT INTO mni_vpl VALUES ("MT22_1","070_22_1","MAT","22","1","1","Jisuna amuk makhoida pandamsing sijinnaduna hairak-i, ");
INSERT INTO mni_vpl VALUES ("MT22_2","070_22_2","MAT","22","2","2","“Swarga leibak asidi machanupagi luhongbagi achouba chaklen ama thourang touriba ningthou amaga manei. ");
INSERT INTO mni_vpl VALUES ("MT22_3","070_22_3","MAT","22","3","3","Mahakna luhongba lakpinaba haija warol pikhibasing adubu kounanaba mahakki manaising tharammi, adubu makhoina lakpiyu yakhide. ");
INSERT INTO mni_vpl VALUES ("MT22_4","070_22_4","MAT","22","4","4","Adudagi mahakna amuk hanna atoppa manaising thaduna hairak-i, Nakhoina lakpinaba haija warol pikhibasing aduda haiyu, ‘Yeng-u, eina chaklen adu thourang touba loire. Eigi sanlabasing amadi thaktuna thamlaba sasing hattuna thourang pumnamak loire. Luhongbagi chaklen aduda laklo!’ ");
INSERT INTO mni_vpl VALUES ("MT22_5","070_22_5","MAT","22","5","5","Adubu makhoina maduda thousadana masa masagi thabakta haibadi kharana loubukta, khara amana lalon-itikki thabak touba chatkhirammi. ");
INSERT INTO mni_vpl VALUES ("MT22_6","070_22_6","MAT","22","6","6","Aduga atei leihoubasing aduna mahakki manaising adubu phaduna thina toubire amasung makhoibu hatle. ");
INSERT INTO mni_vpl VALUES ("MT22_7","070_22_7","MAT","22","7","7","Madu tabada ningthou adu adukki matik saorammi. Aduga mahakna mahakki lanmising thaduna mihatpasing adu hat-hankhi amasung makhoigi sahar adu mei thadok-hankhi. ");
INSERT INTO mni_vpl VALUES ("MT22_8","070_22_8","MAT","22","8","8","Adudagi mahakna mahakki manaising adu kouraduna hairak-i, ‘Eina luhongbagi chaklen adu thourang touba loire, adubu eina lakpinaba haija warol pikhiba makhoising adu matik chadre. ");
INSERT INTO mni_vpl VALUES ("MT22_9","070_22_9","MAT","22","9","9","Aduna houjik nakhoina maruoiba lambisingda chattuna nakhoina thengnaba mi khuding chaklen aduda lakpinaba haija warol piyu.’ ");
INSERT INTO mni_vpl VALUES ("MT22_10","070_22_10","MAT","22","10","10","Adudagi manaising aduna lambida thokkhiduna makhoina aphangba aphaba-phattaba mi pumnamak purakle, amasung luhongbagi chaklen sang adu mina pumthan thankhre. ");
INSERT INTO mni_vpl VALUES ("MT22_11","070_22_11","MAT","22","11","11","“Adubu ningthou aduna chaklen aduda lakkhraba mising adubu yengba changlakpada luhongbagi phijon settaba nupa ama mahakna ure. ");
INSERT INTO mni_vpl VALUES ("MT22_12","070_22_12","MAT","22","12","12","Maduda ningthou aduna mangonda hanglak-i, ‘Marup, matou karamna nahakna luhongbagi phijon settana mapham asida changlaklibano?’ Adubu nupa aduna paokhum kari amata piramde. ");
INSERT INTO mni_vpl VALUES ("MT22_13","070_22_13","MAT","22","13","13","Adudagi ningthou aduna mahakki manaisingda hairak-i, ‘Mahakki makhong makhut punsilu, aduga mahakpu punduna mapan-gi amamba aduda langthokkho. Mapham aduda mahakna kapkani amasung maya krak krak chikkani.’ ” ");
INSERT INTO mni_vpl VALUES ("MT22_14","070_22_14","MAT","22","14","14","“Maramdi mi mayam amabu kou-i, adubu khara khaktabu khalli.” ");
INSERT INTO mni_vpl VALUES ("MT22_15","070_22_15","MAT","22","15","15","Adudagi Pharisee-sing aduna thokkhiduna Jisugi wangangda asoiba thiduna karamna mahakpu phagadage haiduna wa tannarammi. ");
INSERT INTO mni_vpl VALUES ("MT22_16","070_22_16","MAT","22","16","16","Aduga makhoina makhoigi tung-inba khara amadi Herod-ki tung-inba kharabu Ibungogi manakta tharammi. Aduga makhoina Ibungoda hairak-i, “Oja Ibungo, Nahakna achumba ngangbi haiba eikhoina khang-i. Nahakna mina kari khanbage haibadu karisu kiba toudana Tengban Mapugi lambi adu chumna tambi, maramdi nahakna misak mimai yengde. ");
INSERT INTO mni_vpl VALUES ("MT22_17","070_22_17","MAT","22","17","17","Aduna eikhoida haibiyu, Caesar-da kanggat thiba asi wayel kaibra nattraga kaidabra, nahakna kari khanbage?” ");
INSERT INTO mni_vpl VALUES ("MT22_18","070_22_18","MAT","22","18","18","Adubu Jisuna makhoigi phattaba pukning adu khangladuna hairak-i, “Aphasasinnabasa! Nakhoina eibu karigi chang yenglibage? ");
INSERT INTO mni_vpl VALUES ("MT22_19","070_22_19","MAT","22","19","19","Kadai, kanggat thinaba sel mayek adu eingonda utlu!” Maduda makhoina sel mayek ama Ibungoda pire. ");
INSERT INTO mni_vpl VALUES ("MT22_20","070_22_20","MAT","22","20","20","Aduga Ibungona makhoida hairak-i, “Masida namliba makok amadi maming asi kanagino?” ");
INSERT INTO mni_vpl VALUES ("MT22_21","070_22_21","MAT","22","21","21","Makhoina Ibungoda khumlak-i, “Caesar-gini,” Adudagi Ibungona makhoida hairak-i, “Phare, adu oirabadi Caesar-gi oiba aduna Caesar-da aduga Tengban Mapugi oiba aduna Tengban Mapuda piyu.” ");
INSERT INTO mni_vpl VALUES ("MT22_22","070_22_22","MAT","22","22","22","Makhoina madu tabada ngaklammi; amasung Ibungobu thadoktuna chatkhirammi. ");
INSERT INTO mni_vpl VALUES ("MT22_23","070_22_23","MAT","22","23","23","Numit adumaktada sibadagi hinggatpa haibasi leite hairiba Sadducee-singna Jisugi nakta laktuna wahang ama hanglammi. ");
INSERT INTO mni_vpl VALUES ("MT22_24","070_22_24","MAT","22","24","24","Makhoina Ibungoda hairak-i, Oja Ibungo, “Moses-na haibirammi madudi kanagumba nupa amana macha amata thamlamdana sikhiba thoklabadi, hairiba nupa asigi charol-surol thamlamnabagidamak magi machin-manaona lukhrabi adubu amuk lougadabani. ");
INSERT INTO mni_vpl VALUES ("MT22_25","070_22_25","MAT","22","25","25","Adu oirabadi, nupa amagi machin manao taret leirammi haina lourasi. Adudagi mayamba ahal adu nupi thire adubu macha amata thamamdana sire. Asumna mahakki nupi adu manao nupada thanamle. ");
INSERT INTO mni_vpl VALUES ("MT22_26","070_22_26","MAT","22","26","26","Matou adugumna anisuba, ahumsuba amadi makhoi mathang mathang makhoi teretmakta maduga chap manana thokle. ");
INSERT INTO mni_vpl VALUES ("MT22_27","070_22_27","MAT","22","27","27","Aduga ikon konbada nupi adusu sire. ");
INSERT INTO mni_vpl VALUES ("MT22_28","070_22_28","MAT","22","28","28","Adu oirabadi asibana hinggatpagi numit aduda nupi asi makhoi taretki manungda kanagi nupi oigadage? Maramdi makhoi taretmakna nupi adubu lourammi.” ");
INSERT INTO mni_vpl VALUES ("MT22_29","070_22_29","MAT","22","29","29","Jisuna makhoida khumlak-i, “Nakhoina Mapugi puya amadi Tengban Mapugi panggal adu khangdabagi maramna nakhoi lalle. ");
INSERT INTO mni_vpl VALUES ("MT22_30","070_22_30","MAT","22","30","30","Maramdi asibasingna amuk hinggatlakpa matam aduda makhoina amuk luhonglaroi, aduga luhongdunasu piraroi adubu makhoi swargada leiba swargadutsinggumna oigani. ");
INSERT INTO mni_vpl VALUES ("MT22_31","070_22_31","MAT","22","31","31","Aduga asibasing hinggatpagi maramda Tengban Mapuna nakhoida haikhiba adu nakhoina padabra? ");
INSERT INTO mni_vpl VALUES ("MT22_32","070_22_32","MAT","22","32","32","‘Eidi Abraham-gi Tengban Mapu, Isaac-ki Tengban Mapu, amasung Jacob-ki Tengban Mapuni.’ Mahakti asibasinggi Tengban Mapu natte, adubu ahingbasinggi Tengban Mapuni.” ");
INSERT INTO mni_vpl VALUES ("MT22_33","070_22_33","MAT","22","33","33","Aduga miyam aduna madu taba matamda, mahakki tambiba aduda makhoi ngaklammi. ");
INSERT INTO mni_vpl VALUES ("MT22_34","070_22_34","MAT","22","34","34","Jisugi paokhum aduna Sadducee-sing adubu khumba ngamhandre haiba Pharisee-singn tarabada, makhoi masen pullap punsinare. ");
INSERT INTO mni_vpl VALUES ("MT22_35","070_22_35","MAT","22","35","35","Aduga makhoigi maraktagi Wayel Yathanggi oja amana Jisubu chang yengladuna wahang ama hanglak-i, ");
INSERT INTO mni_vpl VALUES ("MT22_36","070_22_36","MAT","22","36","36","“Oja Ibungo, Tengban Mapugi Wayel Yathangsinggi manungdagi karamba yathangna khwaidagi athoiba yathangno?” ");
INSERT INTO mni_vpl VALUES ("MT22_37","070_22_37","MAT","22","37","37","Maduda Jisuna mangonda khumlak-i, “‘Nahakna nahakki Tengban Mapu, MAPU IBUNGO-bu nahakki thamoi apumba, thawai apumba, pukning apumba yaona nungsigadabani.’ ");
INSERT INTO mni_vpl VALUES ("MT22_38","070_22_38","MAT","22","38","38","Masina ahanba amasung athoiba yathangni. ");
INSERT INTO mni_vpl VALUES ("MT22_39","070_22_39","MAT","22","39","39","Aduga anisuba yathang aduna asini, ‘Nahakna nahakki yumlon-keironnabasingbu nasamakum nungsigadabani.’ ");
INSERT INTO mni_vpl VALUES ("MT22_40","070_22_40","MAT","22","40","40","Wayel Yathang apumba amasung Tengban Mapugi wa phongdokpa maichousinggi wa adu hairiba yathang ani asida suplabani.” ");
INSERT INTO mni_vpl VALUES ("MT22_41","070_22_41","MAT","22","41","41","Adudagi Pharisee-singna punsinduna leiringeida Jisuna makhoida hanglak-i, ");
INSERT INTO mni_vpl VALUES ("MT22_42","070_22_42","MAT","22","42","42","“Christtagi maramda nakhoina kari khanbage? Mahak kanagi machanupano?” Makhoina Ibungoda khumlak-i, “David-ki machanupani.” ");
INSERT INTO mni_vpl VALUES ("MT22_43","070_22_43","MAT","22","43","43","Ibungona makhoida hairak-i, “Adu oirabadi, Thawai Asengbagi chingbibagi mapanna David-na mahakpu karamna ‘Mapu Ibungo’ haina kouribano? Maramdi David-na asumna haikhi, ");
INSERT INTO mni_vpl VALUES ("MT22_44","070_22_44","MAT","22","44","44","‘MAPU IBUNGO-na eigi Ibungoda hai: Phammu nahakna eigi yetthangbada, Thamdriphaoba eina nahakki yeknabasingbu, nanggi nakhong makhada.’ ");
INSERT INTO mni_vpl VALUES ("MT22_45","070_22_45","MAT","22","45","45","David-na mangonda ‘Mapu Ibungo’ haina kourabadi, karamna mahakna David-ki machanupa oigadouribano?” ");
INSERT INTO mni_vpl VALUES ("MT22_46","070_22_46","MAT","22","46","46","Aduga mi kana amatana Jisuda wa amata khumba ngamdre amasung numit adudagi houna kana amatana Ibungoda ichang thouna wahang amata hangkhidre. ");
INSERT INTO mni_vpl VALUES ("MT23_1","070_23_1","MAT","23","1","1","Adudagi Jisuna miyamsing amadi mahakki tung-inbasing aduda hairak-i, ");
INSERT INTO mni_vpl VALUES ("MT23_2","070_23_2","MAT","23","2","2","“Wayel Yathanggi ojasing amasung Pharisee-singna Moses-ki phamphamda phammi. ");
INSERT INTO mni_vpl VALUES ("MT23_3","070_23_3","MAT","23","3","3","Maram aduna makhoina haiba pumnamak adu nakhoina ngak-u amasung tou. Adumakpu makhoina touba matou adugumnadi touganu, maramdi makhoina tambiba wa adu makhoina toude. ");
INSERT INTO mni_vpl VALUES ("MT23_4","070_23_4","MAT","23","4","4","Makhoina arumba amadi pubada wagadaba potlumsingbu misinggi marengbanda thonggatli, adubu makhoi masanadi makhoibu mateng pangnanaba khudombi phaoba thanggatningde. ");
INSERT INTO mni_vpl VALUES ("MT23_5","070_23_5","MAT","23","5","5","Aduga makhoina touba thabak khudingmak misingna unanaba tou-i. Makhoina Mapugi Puyagi aiba wahei haptuna sijinnaba sawunna semba upu adu pak-halli aduga makhoigi phigi phinasing adu cholhalli. ");
INSERT INTO mni_vpl VALUES ("MT23_6","070_23_6","MAT","23","6","6","Aduga makhoina chak-khangbada ikaikhumnaba misinggi phamphamda amadi Synagogue-singda akhannaba phamphamda phamba pammi. ");
INSERT INTO mni_vpl VALUES ("MT23_7","070_23_7","MAT","23","7","7","Makhoina keithelnachingba miyam tinba maphamda chatpada misingna makhoibu ikaikhumnabaga loinana koubirakpa amadi ‘Rabbi’ haina kouhanba pammi. ");
INSERT INTO mni_vpl VALUES ("MT23_8","070_23_8","MAT","23","8","8","Adubu nakhoibudi ‘Rabbi’ kouhan-ganu, maramdi nakhoigi ojadi ama-khaktani, aduga nakhoi pumnamak nachin-nanao ngaktani. ");
INSERT INTO mni_vpl VALUES ("MT23_9","070_23_9","MAT","23","9","9","Aduga malem asida leiriba kanagumba amada ‘Ipa,’ haina kouganu maramdi nakhoigi Napa Ibungodi ama-khaktani aduga mahakti swargada lei. ");
INSERT INTO mni_vpl VALUES ("MT23_10","070_23_10","MAT","23","10","10","Aduga nakhoibudi oja kouhan-ganu, maramdi nakhoigi ojadi Christta mathantani. ");
INSERT INTO mni_vpl VALUES ("MT23_11","070_23_11","MAT","23","11","11","Nakhoigi narakta khwaidagi chaoba mahak aduna nakhoigi manai oigani. ");
INSERT INTO mni_vpl VALUES ("MT23_12","070_23_12","MAT","23","12","12","Masa mathanta chaojaningba mahak adubu nolluk-han-gani, aduga masana nollukchaba mahak adubu chaohanbigani.” ");
INSERT INTO mni_vpl VALUES ("MT23_13","070_23_13","MAT","23","13","13","“Adubu aphasasinnaba, he Wayel Yathanggi ojasing amasung Pharisee-sing nakhoidi awabanida! Maramdi misingna changjagadaba swarga leibakki thong adu nakhoina thingjilli. Aduga nakhoi nasamaksu maduda changde aduga maduda changnaba hotnajariba makhoi adubusu nakhoina thing-i. ");
INSERT INTO mni_vpl VALUES ("MT23_14","070_23_14","MAT","23","14","14","Aphasasinaba, he Wayel Yathanggi ojasing amasung Pharisee-sing nakhoidi awabanida! Maramdi nakhoina lukhrabisingdagi khudongchaba louduna mayum-makei mulli, aduga misingna unanabagidamak tousinnaduna Tengban Mapuda haijaba adu sangna haijei. Maram aduna nakhoina henna kanba cheirak phanggani. ");
INSERT INTO mni_vpl VALUES ("MT23_15","070_23_15","MAT","23","15","15","“Aphasasinaba, he Wayel Yathanggi ojasing amasung Pharisee-sing nakhoidi awabanida! Maramdi nakhoina mi amabu nakhoigi lainingda olhannabagidamak ipak kaya amasung lamdam kaya koina chatli. Aduga mahakna ollaklabada mahakpu nakhoina oiba adudagi saruk ani henna norokki macha oihalli.” ");
INSERT INTO mni_vpl VALUES ("MT23_16","070_23_16","MAT","23","16","16","“Mittangba lamjingbasa, nakhoidi awabanida! Nakhoina hai ningnasang panduna wasakpadi karisu natte, ‘Adubu Mapugi Sanglengi sana adu panduna wasakpa mahak adu mahakki wasak aduna pullabani.’ ");
INSERT INTO mni_vpl VALUES ("MT23_17","070_23_17","MAT","23","17","17","Apangba amasung mittangbasa! Sanaga sana adubu senghalliba Mapugi Sang aduga kanana henna chaobage? ");
INSERT INTO mni_vpl VALUES ("MT23_18","070_23_18","MAT","23","18","18","Aduga nakhoina asisu tambi madudi, ‘Kanagumbana latnapung panduna wasaklabasu karisu natte, adubu latnapunggi mathakta leiba athenpot adu panduna wasakpa mahak adudi mahakki wasak aduna pullabani.’ ");
INSERT INTO mni_vpl VALUES ("MT23_19","070_23_19","MAT","23","19","19","Apangba amasung mittangbasa! Athenpotka athenpot adubu senghalliba latnapungga kanana henna chaobage? ");
INSERT INTO mni_vpl VALUES ("MT23_20","070_23_20","MAT","23","20","20","Maram aduna latnapung panduna wasakliba mahak aduna latnapung amadi madugi mathakta leiriba pot pumnamak adubu panduna wasaklabani. ");
INSERT INTO mni_vpl VALUES ("MT23_21","070_23_21","MAT","23","21","21","Aduga Mapugi sang panduna wasakliba mahak aduna madubu amasung madugi manungda leiba Tengban Mapu mahakpu panduna wasaklabani. ");
INSERT INTO mni_vpl VALUES ("MT23_22","070_23_22","MAT","23","22","22","Aduga swarga panduna wasakliba mahak aduna Tengban Mapugi phambalbu amasung madugi mathakta phamliba Tengban Mapu mahakpu panduna wasaklabani.” ");
INSERT INTO mni_vpl VALUES ("MT23_23","070_23_23","MAT","23","23","23","“Aphasasinnba, he Wayel Yathanggi ojasing amasung pharisee-sing nakhoidi awabanida! Maramdi nakhoina nungsihidak, hop, amadi jira phaoba saruk taragi ama katli adubu nakhoina Wayel Yathanggi maru oiba hiramsing haibadi achumba wayel, chanbiba, amasung thajaba yaba adubudi thou-oide. Hoi nakhoina madusu tougadabani adubu henna maruoibasing adubu thou-oidaba touroidabani. ");
INSERT INTO mni_vpl VALUES ("MT23_24","070_23_24","MAT","23","24","24","Mittangba lamjingbasa! Nakhoina nakhoigi thaknanaba isingdagi tumitpudi phijumda chumthok-i adubu chaoraba utpudi yotsilli!” ");
INSERT INTO mni_vpl VALUES ("MT23_25","070_23_25","MAT","23","25","25","“Aphasasinnaba, he Wayel Yathanggi ojasing amasung Pharisee-sing nakhoidi awabanida! Maramdi nakhoigi pukham tenggotki mapan thangba saruk adubudi sengdok-i, adubu manungdadi mihouba amasung masa khudum chanjadabana pik thalli. ");
INSERT INTO mni_vpl VALUES ("MT23_26","070_23_26","MAT","23","26","26","Mittangba Pharisee-sa! Nakhoina ahanbada pukham tenggotki manung thangba saruk adu hanna sengdok-u, aduga mapan thangba adusu senglakkani.” ");
INSERT INTO mni_vpl VALUES ("MT23_27","070_23_27","MAT","23","27","27","“Aphasasinnaba, he Wayel Yathanggi ojasing amasung Pharisee-sing nakhoidi awabanida! Maramdi nakhoidi mapanthongda phajana uba adubu manungdadi asibasinggi saru amasung amotpa pumnamakna pik thanba angouba teiba mongphamsingumbani. ");
INSERT INTO mni_vpl VALUES ("MT23_28","070_23_28","MAT","23","28","28","Matou adugumna nakhoisu mapanthongda misinggi maphamda achumba chatpa oina ui, adubu manungdadi aphasasinnaba amasung papna pik thalli.” ");
INSERT INTO mni_vpl VALUES ("MT23_29","070_23_29","MAT","23","29","29","“Aphasasinnaba, he Wayel Yathanggi ojasing amasung Pharisee-sing nakhoidi awabanida! Maramdi nakhoina Tengban Mapugi wa phongdokpasinggi phajaba mongphamsing sai amasung achumba chatpasinggi mongphamgi phurasingbu ningthina leiteng-i. ");
INSERT INTO mni_vpl VALUES ("MT23_30","070_23_30","MAT","23","30","30","Aduga nakhoina hai, ‘Eikhoina eikhoigi ipa ipusinggi haktakta hinglamba tarabadi, eikhoina Tengban Mapugi wa phongdokpasingbu makhoina hatpa aduda eikhoina saruk yaramloi.’ ");
INSERT INTO mni_vpl VALUES ("MT23_31","070_23_31","MAT","23","31","31","Adubu nakhoina madu haiba matamda Tengban Mapugi wa phongdokpasingbu hatkhibasing adugi macha masusingni haiba nakhoi nasana phongdokchare. ");
INSERT INTO mni_vpl VALUES ("MT23_32","070_23_32","MAT","23","32","32","Adu oirabadi, nakhoigi napa-napusingna houramlaba adu nakhoina mapung phahallu. ");
INSERT INTO mni_vpl VALUES ("MT23_33","070_23_33","MAT","23","33","33","He lilsa, he lindugi machasa, norokki wayen adudagi nakhoina karamna nanthokkadage? ");
INSERT INTO mni_vpl VALUES ("MT23_34","070_23_34","MAT","23","34","34","Maram aduna, yeng-u, eina nakhoida hairi, eina nakhoida Tengban Mapugi wa phongdokpasing, asingba mising amasung ojasingbu thagani. Aduga nakhoina makhoi kharabu hatkani amasung kharabuna cross-ta hatkani. Amasung atoppa ateisingbuna nakhoina nakhoigi Synagogue-singda phugani amasung makhoibu sahar amadagi sahar amada tannaduna ot-neigani. ");
INSERT INTO mni_vpl VALUES ("MT23_35","070_23_35","MAT","23","35","35","Masi achumba chatpa Abel hatpadagi houraga Mapugi Sanglen amasung latnapunggi marakta hatkhiba Barachiah-gi machanupa Zechariah hatkhiba matam phaobada malemda takhiba achumba chatpa mi pumnamakki eegi cheirak adu nakhoigi nathakta tananabani. ");
INSERT INTO mni_vpl VALUES ("MT23_36","070_23_36","MAT","23","36","36","Eina nakhoida tasengnamak hairibasini, masi pumnamaksing asigi cheirak adu miron asigi mathakta tagani!” ");
INSERT INTO mni_vpl VALUES ("MT23_37","070_23_37","MAT","23","37","37","“Mapu Ibungogi wa phongdokpasingbu hatpa amasung nangonda thakhiba Mapu Ibungogi pao pubasingbu nungna thaba, he Jerusalem Jerusalem! Yenbina machasingbu mathanungda konsinbagumna kayamuk thoina nahakki nachasingbu eina ithanungda konjaningkhiba! Adubu nakhoina kolhankhide. ");
INSERT INTO mni_vpl VALUES ("MT23_38","070_23_38","MAT","23","38","38","Yeng-u, nakhoigi yum adu thadokkadouri amasung itak takkadouri. ");
INSERT INTO mni_vpl VALUES ("MT23_39","070_23_39","MAT","23","39","39","Maramdi eina nakhoida hairibasini, ‘MAPU IBUNGO-gi mingda lenglakliba Ibungo mahak adu yaiphabani haibasi nakhoina haidriphaoba nakhoina eibu keidounungda amuk hanna uraroi.’ ” ");
INSERT INTO mni_vpl VALUES ("MT24_1","070_24_1","MAT","24","1","1","Jisuna Mapugi sanglen thadoktuna chatthorakpada mahakki tung-inbasing aduna manakta laktuna Mapugi Sanglengi yumsing adu utlammi. ");
INSERT INTO mni_vpl VALUES ("MT24_2","070_24_2","MAT","24","2","2","Maduda Jisuna makhoida hairak-i, “Nakhoina pumnamak asi ure nattra? Eina nakhoida tasengnamak hairibasini, masi pumnamaksing asi thugaiduna pummang manghan-gani, ningkhaidaba lonnaba nung amata phaoba maphamsida thanamlaroi.” ");
INSERT INTO mni_vpl VALUES ("MT24_3","070_24_3","MAT","24","3","3","Aduga Jisuna chorphon chingthakta phamlingeida tung-inbasing aduna Ibungogi nakta makhoi khaktamak lakladuna hairak-i, “Pumnamaksing asi karamba matamda thokkadage? Ibungona amuk lengbirakkadaba amasung taibangpan-gi aroiba matamgi khudam adu karino haiba eikhoida takpiyu.” ");
INSERT INTO mni_vpl VALUES ("MT24_4","070_24_4","MAT","24","4","4","Jisuna makhoida hairak-i, “Kananasu nakhoibu serannana lamjingdanaba cheksillu. ");
INSERT INTO mni_vpl VALUES ("MT24_5","070_24_5","MAT","24","5","5","Maramdi ‘Ei Christtani’ haiduna mi kaya amana eigi mingda lakkani, aduga makhoina mi kaya amabu lanna lamjing-gani. ");
INSERT INTO mni_vpl VALUES ("MT24_6","070_24_6","MAT","24","6","6","Aduga nakhoina lan amasung lan-gi paoninkhol taraga mipaiganu. Maramdi hairibasing asi soidana thoklaba tai, adubu aroiba matam adu houjik laktri. ");
INSERT INTO mni_vpl VALUES ("MT24_7","070_24_7","MAT","24","7","7","Maramdi phurup amana phurup amagi mathakta, aduga ningtou leibak amana ningthou leibak amagi mathakta lan hourakkani. Malemgi tongan tonganba mapham kayada yuhar haba amadi chak tangba thokkani. ");
INSERT INTO mni_vpl VALUES ("MT24_8","070_24_8","MAT","24","8","8","Pumnamaksing asi naoyekpa hek hourakpagi ahanba cheinakhol adugumbani. ");
INSERT INTO mni_vpl VALUES ("MT24_9","070_24_9","MAT","24","9","9","“Aduga makhoina nakhoibu phagani, ot-neigani amasung hatkani. Aduga nakhoina eigi tung-inbasing oibagi maramna taibangpanda leiriba misingna nakhoibu yengthigani. ");
INSERT INTO mni_vpl VALUES ("MT24_10","070_24_10","MAT","24","10","10","Matam aduda mi ayambana eingondagi leithokkhigani; aduga makhoina amaga amaga pithoknagani amadi yengthinagani! ");
INSERT INTO mni_vpl VALUES ("MT24_11","070_24_11","MAT","24","11","11","Aduga Tengban Mapugi wa takthoksinnaba mi kaya ama thorakkani amasung mi kaya amabu lanna lamjinggani. ");
INSERT INTO mni_vpl VALUES ("MT24_12","070_24_12","MAT","24","12","12","Aduga phattabana asum hen-gatlakpagi maramna mi ayambagi nungsiba hantharakkani. ");
INSERT INTO mni_vpl VALUES ("MT24_13","070_24_13","MAT","24","13","13","Adubu aroiba phaoba khangba mahak adubu kanbigani. ");
INSERT INTO mni_vpl VALUES ("MT24_14","070_24_14","MAT","24","14","14","Aduga taibangpanda leiriba phurup khudingmakna ningthou leibakki aphaba pao asibu lousinjaba phangnanaba taibangpan apumbada sandokkani, aduga aroiba matam adu lakkani. ");
INSERT INTO mni_vpl VALUES ("MT24_15","070_24_15","MAT","24","15","15","“Tengban Mapugi wa phongdokpa Daniel-na haikhiba asengba maphambu khuntak-halliba tukkachaningai oiba mahak aduna asengba mapham aduda leppa nakhoina uba matamda (apaba mahak aduna khangsanu), ");
INSERT INTO mni_vpl VALUES ("MT24_16","070_24_16","MAT","24","16","16","Judea-da leiriba makhoising aduna chingda chenkhisanu. ");
INSERT INTO mni_vpl VALUES ("MT24_17","070_24_17","MAT","24","17","17","Yumthakta leiba mahak aduna imungda amuk kumthaduna mahakki punanaba pot louduna matam manghandasanu. ");
INSERT INTO mni_vpl VALUES ("MT24_18","070_24_18","MAT","24","18","18","Aduga loubukta leiba mahak adunasu maphi lounanaba mayumda amuk halaktasanu. ");
INSERT INTO mni_vpl VALUES ("MT24_19","070_24_19","MAT","24","19","19","Aduga numitsing aduda mironlibising amasung chajenlibisinggidamakti kayada awaba oiragaba! ");
INSERT INTO mni_vpl VALUES ("MT24_20","070_24_20","MAT","24","20","20","Adubu nakhoina chenba adu ningthamthada amadi potthaba numitta thoktanaba Tengban Mapuda haijou. ");
INSERT INTO mni_vpl VALUES ("MT24_21","070_24_21","MAT","24","21","21","Maramdi taibangpan houba matamdagi houjik phaoba amukta thokkhidriba yamna tamthiba awa-ana thokkani, aduga adugumna waba adu keidounungdasu amuk hanna thoklaroi. ");
INSERT INTO mni_vpl VALUES ("MT24_22","070_24_22","MAT","24","22","22","Numitsing adu kaksinbiba nattanadi, mi kana amatana hingloi. Adubu khan-gatpikhraba makhoising adugidamak numitsing adu kaksinbigani. ");
INSERT INTO mni_vpl VALUES ("MT24_23","070_24_23","MAT","24","23","23","“Matam aduda kanagumbana, ‘Yeng-u, Christta asida leire’ nattraga ‘Aduda leire’ haina hairaklabadi, nakhoina maduda thajaganu. ");
INSERT INTO mni_vpl VALUES ("MT24_24","070_24_24","MAT","24","24","24","Maramdi Christta sasinnaba amasung maichou sasinnabasing thoklakkani; aduga makhoina misingbu serannana lamjingnaba achouba khudamsing amasung matik leiba khudamsing utkani. Aduda ngamlabadi Mapu Ibungogi khan-gatpikhrabasing adu phaoba makhoina serannana lamjingbigani. ");
INSERT INTO mni_vpl VALUES ("MT24_25","070_24_25","MAT","24","25","25","Yeng-u, Eina masi nakhoida mangjounana haikhre. ");
INSERT INTO mni_vpl VALUES ("MT24_26","070_24_26","MAT","24","26","26","“Maramdi kanagumbana nakhoida, ‘Yeng-u, Christta lamhangda lei!’ hairabasu mapham aduda chatkanu! Nattraga ‘Yeng-u, Christta achikpa kada lei,’ hairabasu thajaganu. ");
INSERT INTO mni_vpl VALUES ("MT24_27","070_24_27","MAT","24","27","27","Maramdi atiya sinthungna nongthanggi mangalna nongpoktagi nongchupta uba adugumna Migi Machanupa aduna lakpa adusu adugumgani.” ");
INSERT INTO mni_vpl VALUES ("MT24_28","070_24_28","MAT","24","28","28","“Asiba masa leiba maphamda, langjasing adu pullap leigani.” ");
INSERT INTO mni_vpl VALUES ("MT24_29","070_24_29","MAT","24","29","29","“Awa-ana numitsinggi matungda, numitna mamsin-gani, thana amuk hanna ngallaroi, thawanmichaksingna nongdon atiyadagi tarakkani, amasung atiyagi panggalsing nik-han-gani. ");
INSERT INTO mni_vpl VALUES ("MT24_30","070_24_30","MAT","24","30","30","Aduga aroiba matamda, atiyada Migi Machanupa adugi khudam ugani, aduga taibangpanda leiba misingna tengtha naoigani! Migi Machanupa aduna panggal amasung achouba matik mangalga loinana atiyagi leichinda lenglakpa nakhoina ugani. ");
INSERT INTO mni_vpl VALUES ("MT24_31","070_24_31","MAT","24","31","31","Ibungona mahakki dutsingbu peresinggagi ahouba makhon-ga loinana tharakkani, aduga makhoina Ibungogi khandokkhrabasing pumnamakpu atiyagi aroiba amadagi aroiba ama phaoba maikei marimaktagi khomjingani. ");
INSERT INTO mni_vpl VALUES ("MT24_32","070_24_32","MAT","24","32","32","“Houjik heiyit pambidagi nakhoina pandam asi khangjillu. Upal asigi masasingda yening hullaktuna manasing panba houraklabada nakhoina kalentha naksillakle haiba khang-i. ");
INSERT INTO mni_vpl VALUES ("MT24_33","070_24_33","MAT","24","33","33","Matou asumna nakhoina thoudoksing asi thoklakpa urabadi matam adu naksillakle, thongjinda leire haiba khang-u. ");
INSERT INTO mni_vpl VALUES ("MT24_34","070_24_34","MAT","24","34","34","Eina nakhoida tasengnamak hairibasini, miron asina houkhidringei mamangda thoudok pumnamak asi thokkani. ");
INSERT INTO mni_vpl VALUES ("MT24_35","070_24_35","MAT","24","35","35","Atiya amadi malemdi mangkhigani adubu Eigi waheisingdi keidounungda manglaroi.” ");
INSERT INTO mni_vpl VALUES ("MT24_36","070_24_36","MAT","24","36","36","“Mi kana amatana madugi pungpham amasung numittu khangde, swargada leiba dutsing phaoba madu khangde; adubu eigi Ipa khaktana khang-i. ");
INSERT INTO mni_vpl VALUES ("MT24_37","070_24_37","MAT","24","37","37","Noah-gi haktakta thokkhibagumna Migi Machanupa aduna lenglakpadasu oigani. ");
INSERT INTO mni_vpl VALUES ("MT24_38","070_24_38","MAT","24","38","38","Maramdi achouba ising ichao thoktringeida, Noah-na hijao manungda changdringei misingna cha-thaktuna, luhongduna amasung luhonghanduna leirammi. ");
INSERT INTO mni_vpl VALUES ("MT24_39","070_24_39","MAT","24","39","39","Ising ichao adu laktuna makhoi pumnamak puthoktriphaoba makhoina karisu khanglamde; matou adumna Migi Machanupa aduna lenglakpa adudasu oigani. ");
INSERT INTO mni_vpl VALUES ("MT24_40","070_24_40","MAT","24","40","40","Matam aduda mi ani loubukta thabak suduna leigani amabu pukhigani; aduga amabu thanamgani. ");
INSERT INTO mni_vpl VALUES ("MT24_41","070_24_41","MAT","24","41","41","Nupi anina chakkri taktuna leigani; amabu pukhigani aduga amabu thanamgani. ");
INSERT INTO mni_vpl VALUES ("MT24_42","070_24_42","MAT","24","42","42","“Maram aduna tumdana mitseng khang-u, maramdi nakhoigi Mapu Ibungona karamba numitta lenglakkani haibadu nakhoina khangde. ");
INSERT INTO mni_vpl VALUES ("MT24_43","070_24_43","MAT","24","43","43","Adubu asi khang-u, kari yuthakta huranbana lakkani haiba yumbuna khanglamlabadi, mahakna mitsel khangduna magi yum adu sagun touhallamloidabani. ");
INSERT INTO mni_vpl VALUES ("MT24_44","070_24_44","MAT","24","44","44","Maram aduna nakhoisu thourang touduna leiyu, maramdi nakhoina ningludaba pungphamda Migi Machanupa adu lenglakkani.” ");
INSERT INTO mni_vpl VALUES ("MT24_45","070_24_45","MAT","24","45","45","“Adu oirabadi, thajaba yaba amadi asingba manai adu kanano? Mahak adudi mabungona mahakki manaisingbu yengsinnaba amasung makhoibu pija pithak tounaba sinariba mahakni. ");
INSERT INTO mni_vpl VALUES ("MT24_46","070_24_46","MAT","24","46","46","Mabungona mayumda lenglakpada asumna su-nomlamba manai adu yaiphabani! ");
INSERT INTO mni_vpl VALUES ("MT24_47","070_24_47","MAT","24","47","47","Eina nakhoida tasengnamak hairibasini, mabungona mahakki leijaba maran-mathum pumnamak mahakki makhutta sinagani. ");
INSERT INTO mni_vpl VALUES ("MT24_48","070_24_48","MAT","24","48","48","Adubu karigumba phattaba manai oirabadi mahak masa mathanta haijagani, ‘Eigi mapu matam kuina lakkhiroi,’ ");
INSERT INTO mni_vpl VALUES ("MT24_49","070_24_49","MAT","24","49","49","Mahakka thabak touminnaba minaisingbu mahakna phuba amadi yungaobasingga chamin thakminnaba houre. ");
INSERT INTO mni_vpl VALUES ("MT24_50","070_24_50","MAT","24","50","50","Adubu manai aduna thousadana leiba numit amasung mahakna khandaba pungda mahakki mabungo lenglakkani. ");
INSERT INTO mni_vpl VALUES ("MT24_51","070_24_51","MAT","24","51","51","Mabu matup anithokna kakthatlagani amasung aphasasinnabasingga loinana magi saruk phanghan-gani; mapham aduda kappa amasung maya krak-krak chikpa oigani.” ");
INSERT INTO mni_vpl VALUES ("MT25_1","070_25_1","MAT","25","1","1","“Matamduda swarga leibak adu makhutta thaomei paiduna bor okpa thorakpi leisabi taraga managani. ");
INSERT INTO mni_vpl VALUES ("MT25_2","070_25_2","MAT","25","2","2","Makhoigi marakta manga amadi apangbini, aduga manga amana asingbini. ");
INSERT INTO mni_vpl VALUES ("MT25_3","070_25_3","MAT","25","3","3","Apangbising aduna makhoigi thaomei puraklabasu konanaba thaodi puraklamde, ");
INSERT INTO mni_vpl VALUES ("MT25_4","070_25_4","MAT","25","4","4","adubu asingbising adunadi makhoigi thaomeising adu thanba konnanaba ahenba thaosu puraklammi. ");
INSERT INTO mni_vpl VALUES ("MT25_5","070_25_5","MAT","25","5","5","Aduga bor aduna lakpa thintharabada makhoi pumnamak uirakladuna tumthakhirammi. ");
INSERT INTO mni_vpl VALUES ("MT25_6","070_25_6","MAT","25","6","6","“Aduga ahing nongyaigi matamda, ‘Yeng-u, bor lenglakle, nakhoina thoraktuna mahakpu oklaro’ haina laorakpa aduda makhoi mikap thoklammi. ");
INSERT INTO mni_vpl VALUES ("MT25_7","070_25_7","MAT","25","7","7","Maduda leisabi tara aduna hougattuna makhoigi thaomeising adu semjillammi. ");
INSERT INTO mni_vpl VALUES ("MT25_8","070_25_8","MAT","25","8","8","Adudagi apangbi leisabi manga aduna asingbi leisabi manga aduda hairak-i, ‘Eikhoida nakhoigi thao adu khara pibiyu, maramdi eikhoigi thaomeising asi mutkadoure.’ ");
INSERT INTO mni_vpl VALUES ("MT25_9","070_25_9","MAT","25","9","9","Maduda asingbi leisabising aduna khumlak-i, ‘Yararoi,’ eikhoina nakhoida pithoklabadi nakhoigisu eikhoigisu amata konnararoi. Aduna nakhoina thao yonphamda chattuna nakhoi nasagi leijaruro. ");
INSERT INTO mni_vpl VALUES ("MT25_10","070_25_10","MAT","25","10","10","Adubu makhoina thao leiba chatlingeida, bor adu thunglare. Adudagi thourang toujaduna leiribi manga aduna mahakka loinana luhongbagi chaklen-gidamak changkhrabada thong thingkhre. ");
INSERT INTO mni_vpl VALUES ("MT25_11","070_25_11","MAT","25","11","11","“Madugi matungda atoppa leisabi manga adusu halaklammi aduga makhoina mapandagi kourak-i, ‘Ibungo, Ibungo! Eikhoida thong amukta hangdokpiyu.’ ");
INSERT INTO mni_vpl VALUES ("MT25_12","070_25_12","MAT","25","12","12","Adubu bor aduna khumlak-i, ‘Eina nakhoida tasengnamak hairibasini, eina nakhoibu kanano khangde.’ ” ");
INSERT INTO mni_vpl VALUES ("MT25_13","070_25_13","MAT","25","13","13","“Maram aduna nakhoina mitseng khang-u, maramdi Migi Machanupa aduna lenglakkadaba numit amadi pungpham nakhoina khangde.” ");
INSERT INTO mni_vpl VALUES ("MT25_14","070_25_14","MAT","25","14","14","“Maramdi swarga Leibak adudi mahakki manaisingbu kouduna mahakki lanthum sinnaramlaga langphei chatkhiba nupa amaga manei. ");
INSERT INTO mni_vpl VALUES ("MT25_15","070_25_15","MAT","25","15","15","Mahakna makhoi khudingmakta mana mana ngamgadaba changgi matung-ina, amadana sanagi sel mayek lising manga, anisuba manai aduda lising ani, aduga ahumsuba manai aduda lising ama pire. Aduga mahakna langphei chatkhre. ");
INSERT INTO mni_vpl VALUES ("MT25_16","070_25_16","MAT","25","16","16","Adudagi sanagi sel mayek lising manga phangba manai aduna khudakta chatkhiduna sel adu lalonbada thadare, aduga atoppa lising manga tongle. ");
INSERT INTO mni_vpl VALUES ("MT25_17","070_25_17","MAT","25","17","17","Maduga chap manana sanagi sel mayek lising ani phangba mahak aduna lising ani amaga phangle. ");
INSERT INTO mni_vpl VALUES ("MT25_18","070_25_18","MAT","25","18","18","Adubu sanagi sel mayek lising ama phangba mahak adunadi chatkhiduna leipak touthoklaga mahakki mabungogi sel adu lotsinkhi. ");
INSERT INTO mni_vpl VALUES ("MT25_19","070_25_19","MAT","25","19","19","“Matam kuirabagi tungda makhoigi mabungo adu mahakki khongchat adudagi halakle aduga makhoibu chaga-chading tounanaba koure. ");
INSERT INTO mni_vpl VALUES ("MT25_20","070_25_20","MAT","25","20","20","Adudagi sanagi sel mayek lising manga phangba manai aduna atongba lising manga adusu puraktuna laklaga hairak-i, ‘Ibungo, Nahakna eingonda sanagi sel mayek lising manga pibikhi, aduga Yengbiyu! Eina lising manga amaga tongjare.’ ");
INSERT INTO mni_vpl VALUES ("MT25_21","070_25_21","MAT","25","21","21","Maduda mahakki mabungona mangonda hairak-i, ‘Eigi aphaba amadi thajaba yaba inai! Nahakna yamna ningthijana toure. Nahakna khajik asida thajaba yabagi maramna houjik eina nangonda henna chaoba thoudang sinna-gani. Nahakna laktuna nabungogi haraobada saruk yajaro!’ ");
INSERT INTO mni_vpl VALUES ("MT25_22","070_25_22","MAT","25","22","22","“Adudagi sanagi sel mayek lising ani phangba manai adunasu atongba lising ani puraktuna laklaga hairak-i, ‘Ibungona eingonda sanagi sel mayek lising ani pibikhi. Aduga yengbiyu eina lising ani amaga tongjare.’ ");
INSERT INTO mni_vpl VALUES ("MT25_23","070_25_23","MAT","25","23","23","Maduda mahakki mabungona mangonda hairak-i, ‘Eigi aphaba amasung thajaba yaba inai! Nahakna yamna ningthijana toure. Nahakna khajik asida thajaba yabagi maramna houjik eina nangonda henna chaoba thoudang sinnagani. Nahakna laktuna nabungogi haraobada saruk yajaro!’ ");
INSERT INTO mni_vpl VALUES ("MT25_24","070_25_24","MAT","25","24","24","“Adudagi sanagi sel mayek lising ama phangba adusu laktuna hairak-i, ‘Ibungodi hunkhidaba adubu lokpa, aduga thakhidaba adubu khomjinba, sathiba mini haiba eina khangjei. ");
INSERT INTO mni_vpl VALUES ("MT25_25","070_25_25","MAT","25","25","25","Aduna eina kijaduna chatlaga Ibungogi sanagi sel mayek lising amadu leipak manungda lotsinduna thamlure. Yengbiyu, Ibungogi selsingdu asida leire.’ ” ");
INSERT INTO mni_vpl VALUES ("MT25_26","070_25_26","MAT","25","26","26","Maduda mabungo aduna mangonda hairak-i, “Phattaba amasung atanba minai, eina hunkhidaba adudagi lok-i, aduga thakhidaba adubu khomjinli haiba adu nahakna khanglabadi, ");
INSERT INTO mni_vpl VALUES ("MT25_27","070_25_27","MAT","25","27","27","karigi nahakna eigi sel adu sel puthokpasingda thamlamdribano? Adu oirabadi eina hallakpa matamda selsing adu mathoiga loinana phanglamgadabani. ");
INSERT INTO mni_vpl VALUES ("MT25_28","070_25_28","MAT","25","28","28","Adudagi mabungo aduna asumna yathang pirak-i, Minai asidagi sel adu louthoktuna sanagi sel mayek lising tara leiba mangonda piyu. ");
INSERT INTO mni_vpl VALUES ("MT25_29","070_25_29","MAT","25","29","29","Maramdi areiba mi khudingmakta henna pibigani, aduga leitaba mahak adudagi mahakki leijariba khara adu phaoba louthokkani. ");
INSERT INTO mni_vpl VALUES ("MT25_30","070_25_30","MAT","25","30","30","Aduga kanadraba minai adu mapan-gi amambada langthokkho; mapham aduda kappa amadi maya krak-krak chikpa oigani.” ");
INSERT INTO mni_vpl VALUES ("MT25_31","070_25_31","MAT","25","31","31","“Adubu Migi Machanupa aduna mahakki matik mangalga loinana amadi swarga dut pumnamaka loinana lenglakpada, mahakna mahakki matik mangalgi phambalda phamgani. ");
INSERT INTO mni_vpl VALUES ("MT25_32","070_25_32","MAT","25","32","32","Amasung phurup pumnamakpu mahakki mamangda pulhan-gani. Aduga yaosenbana mahakki yaosingbu hamengsingdagi khaidokpagum, mahakna makhoibu amadagi amabu khaidokkani. ");
INSERT INTO mni_vpl VALUES ("MT25_33","070_25_33","MAT","25","33","33","Mahakna yaosingbu mahakki yetthangbada, aduga hamengsingna mahakki oithangbada thamgani. ");
INSERT INTO mni_vpl VALUES ("MT25_34","070_25_34","MAT","25","34","34","Adudagi Ningthou aduna mahakki yetthangbada leiba makhoi aduda haigani, ‘Lak-u, eigi Ipagi yaipha thoujal phangbasa! Taibangpan leisemngeidagi nakhoigidamak thourang toukhraba ningthou leibak adu phangjaro. ");
INSERT INTO mni_vpl VALUES ("MT25_35","070_25_35","MAT","25","35","35","Maramdi eina lamlabada nakhoina eingonda chanaba pibikhi, aduga eina khouranglabada nakhoina eingonda thaknaba pibikhi; eina lamlanba oiringeida nakhoina eibu nakhoigi yumsingda taramna okpikhi. ");
INSERT INTO mni_vpl VALUES ("MT25_36","070_25_36","MAT","25","36","36","Eina phi leitrabada nakhoina eingonda phi pibikhi; eina narabada nakhoina eibu yengsinbikhi, eina keisumsangda leiringeida nakhoina eigi nakta lakpikhi.’ ” ");
INSERT INTO mni_vpl VALUES ("MT25_37","070_25_37","MAT","25","37","37","“Matam aduda achumba chatpasing aduna mangonda hangjagani, ‘Ibungo, karamba matamda eikhoina Ibungona lamba ujaduna Ibungobu pijakhibage, aduga khouranglabada pithakpikhibage? ");
INSERT INTO mni_vpl VALUES ("MT25_38","070_25_38","MAT","25","38","38","Aduga karamba matamda eikhoina Ibungona lamlanba oiramba ujaduna Ibungobu yumda taramna okchakhibage, aduga phi leitrabada phi pikhibage? ");
INSERT INTO mni_vpl VALUES ("MT25_39","070_25_39","MAT","25","39","39","Aduga karamba matamda eikhoina Ibungona naduna leiba nattraga keisumsangda leiba ujaduna Ibungogi nakta lakchakhibage?’ ");
INSERT INTO mni_vpl VALUES ("MT25_40","070_25_40","MAT","25","40","40","Maduda Ningthou aduna makhoida haigani, ‘Eina nakhoida tasengnamak hairibasini, nakhoina eigi ichin-inaosing asigi maraktagi khwaidagi tonba amada toukhiba adumak nakhoina eingonda toubibani!’ ");
INSERT INTO mni_vpl VALUES ("MT25_41","070_25_41","MAT","25","41","41","“Adudagi Ibungona mahakki oiromda leibasing aduda haigani, ‘He sirap phangbasa, eingondagi chatthoktuna Satan amasung mahakki dutsingidamak thourang toukhraba mutpa naidaba mei aduda chatkhro! ");
INSERT INTO mni_vpl VALUES ("MT25_42","070_25_42","MAT","25","42","42","Maramdi eina lamlabada nakhoina eingonda chanaba karisu pikhide; eina khouranglabada thaknaba karisu pikhide, ");
INSERT INTO mni_vpl VALUES ("MT25_43","070_25_43","MAT","25","43","43","Eina lamlanba oiringeida nakhoigi yumda eibu lousinbikhide, phi leitabada nakhoina eingonda phi pibikhide; naba matamda amasung keisumsangda leiringeida nakhoina laktuna eibu yengsinbikhide.’ ");
INSERT INTO mni_vpl VALUES ("MT25_44","070_25_44","MAT","25","44","44","“Maduda makhoinasu khumgani, ‘Ibungo, eikhoina karamba matamda Ibungona lamba nattraga khourangba, nattraga lamlanba oiba, nattraga phi leitaba, nattraga naba nattraga keisumsangda leiba ujaraga, Ibungobu thougal toujakhidabage?’ ");
INSERT INTO mni_vpl VALUES ("MT25_45","070_25_45","MAT","25","45","45","Matam aduda Ibungona makhoida haigani, ‘Eina nakhoida tasengnamak hairibasini, makhoi asigi maraktagi khwaidagi tonba amada nakhoina toukhidaba adumak nakhoina eingonda toukhidabani!’ ");
INSERT INTO mni_vpl VALUES ("MT25_46","070_25_46","MAT","25","46","46","Adudagi makhoina lomba naidaba cheirak phanggadaba maphamda chatkani, adubu achumba chatpasingna lomba naidaba hingbada chatkani.” ");
INSERT INTO mni_vpl VALUES ("MT26_1","070_26_1","MAT","26","1","1","Jisuna waramsing asi tambiba loirabada, mahakna mahakki tung-inbasingda hairak-i, ");
INSERT INTO mni_vpl VALUES ("MT26_2","070_26_2","MAT","26","2","2","“Nakhoina khangbagumna numit ninigi matungdadi lanthokpibagi chakkhangba laklagani. Aduga matam aduda Migi Machanupa adubu cross-ta hatnaba pithokani.” ");
INSERT INTO mni_vpl VALUES ("MT26_3","070_26_3","MAT","26","3","3","Matam adumaktada athoiba purohitsing, Wayel Yathanggi ojasing amadi phurupki ahal-lamansingna athoiba purohitlen Caiaphas-ki yumda punna tinarammi, ");
INSERT INTO mni_vpl VALUES ("MT26_4","070_26_4","MAT","26","4","4","aduga makhoina Jisubu lounam touduna phananaba amadi hatnanaba wa tanare. ");
INSERT INTO mni_vpl VALUES ("MT26_5","070_26_5","MAT","26","5","5","Adubu makhoina hai, “Madu chakkhangbagi kumhei manungdadi oihangumsi, nattrabadi misingna irang hourakkani.” ");
INSERT INTO mni_vpl VALUES ("MT26_6","070_26_6","MAT","26","6","6","Adudagi Jisuna Bethany-da kiningai oiba unsagi lainana naramba Simon-gi yumda leiringeida, ");
INSERT INTO mni_vpl VALUES ("MT26_7","070_26_7","MAT","26","7","7","nupi amana alabaster kouba nungngouna saba chaphu amada mamal yamna tangba manam nungsiba teinathao haplaga puduna Ibungogi nakta laklammi. Aduga Ibungona chananaba phamlingeida, nupi aduna Ibungogi kokthakta thao adu heibirammi. ");
INSERT INTO mni_vpl VALUES ("MT26_8","070_26_8","MAT","26","8","8","Madu ubada tung-inbasing aduna saoraduna hairak-i, “Karigi thao asibu asumna manghallibano?” ");
INSERT INTO mni_vpl VALUES ("MT26_9","070_26_9","MAT","26","9","9","“Manam nungsiba thao asi tangna yonduna senpham adu lairabasingda piba yarambani!” ");
INSERT INTO mni_vpl VALUES ("MT26_10","070_26_10","MAT","26","10","10","Makhoina hairiba adu Jisuna khangladuna makhoida hairak-i, “Nakhoina nupi asibu karigi yetlibano? Mahakna eihakkidamak yamna phaba amadi phajaraba thabak ama toubire. ");
INSERT INTO mni_vpl VALUES ("MT26_11","070_26_11","MAT","26","11","11","Maramdi lairabasingdi matam pumnamakta nakhoiga loinadunata leigani, adubu eidi nakhoiga matam pumnamakta leiminnaroi. ");
INSERT INTO mni_vpl VALUES ("MT26_12","070_26_12","MAT","26","12","12","Manam nungsiba teinathao asi mahakna eigi hakchangda heibiduna eibu phumnabagidamak thourang toubire. ");
INSERT INTO mni_vpl VALUES ("MT26_13","070_26_13","MAT","26","13","13","Houjik, eina nakhoida tasengnamak hairibasini, Aphaba Pao asi sandokpa malemgi mapham khudingda, mahakpu ningsingba oina mahakna toukhibasing asibusu phongdokkani.” ");
INSERT INTO mni_vpl VALUES ("MT26_14","070_26_14","MAT","26","14","14","Adudagi tung-inba taranithoi adugi maraktagi ama oiriba Judas Iscariot kouba aduna athoiba purohitsinggi manakta chatlaga, ");
INSERT INTO mni_vpl VALUES ("MT26_15","070_26_15","MAT","26","15","15","makhoida hairammi, “Jisubu eina nakhoida sinnarabadi nakhoina eingonda kari pigadage?” Maduda makhoina lupagi sel mayek kunthra thiraga mangonda pirammi. ");
INSERT INTO mni_vpl VALUES ("MT26_16","070_26_16","MAT","26","16","16","Aduga matam adudagi houduna Judas-na Ibungobu makhoigi makhutta pithoknaba khudong chaba tanja thirammi. ");
INSERT INTO mni_vpl VALUES ("MT26_17","070_26_17","MAT","26","17","17","Hamei yaodaba talgi chakkhangbagi ahanba numitta tung-inbasingna Jisugi nakta laktuna hangjarak-i, “Eikhoina mapham kadaida Ibungogidamak lanthokpibagi chakkhangbagi chaklen adu thourang langjaba Ibungona pambibage?” ");
INSERT INTO mni_vpl VALUES ("MT26_18","070_26_18","MAT","26","18","18","Maduda Ibungona makhoida hairak-i, “Nakhoina sahar aduda changduna kanagumba nupa amagi manakta chattuna mangonda asumna haiyu, ‘Eikhoigi ojana hai: Eigi pungpham adu naksillakle. Eina eigi tung-inbasingga loinana nahakki yumda lanthokpibagi chakkhangba pangthokani.’ ” ");
INSERT INTO mni_vpl VALUES ("MT26_19","070_26_19","MAT","26","19","19","Aduga Jisuna makhoida haikhiba adugumna tung-inbasing aduna tourammi; amasung makhoina mapham aduda lanthokpibagi chakkhangba adu thourang toujakhi. ");
INSERT INTO mni_vpl VALUES ("MT26_20","070_26_20","MAT","26","20","20","Numidanggi matam oiraklabada, Jisuna mahakki tung-inba taranithoi aduga loinana chananaba phamtharammi. ");
INSERT INTO mni_vpl VALUES ("MT26_21","070_26_21","MAT","26","21","21","Aduga makhoina charingeida, Jisuna makhoida hairak-i, “Eina nakhoida tasengnamak hairibasini, nakhoigi naraktagi amana eibu pithokkani.” ");
INSERT INTO mni_vpl VALUES ("MT26_22","070_26_22","MAT","26","22","22","Maduda makhoi pukning yamna warammi, amasung makhoi amamamna mathang mathang Ibungoda hangba hourak-i, “Ibungo, Mahak adu eira?” ");
INSERT INTO mni_vpl VALUES ("MT26_23","070_26_23","MAT","26","23","23","Jisuna khumlak-i, “Eiga loinana houjikta pukham asida chaminnakhiba mahak aduna eibu pithokkani. ");
INSERT INTO mni_vpl VALUES ("MT26_24","070_26_24","MAT","26","24","24","Mahakki maramda Mapugi puyada ikhiba adugumna Migi Machanupa aduna chatli, adubu Migi Machanupa adubu pithokpa mahak adudi awabanida! Mahak poklamdabana mahakkidamaktadi henna pharamgadabani!” ");
INSERT INTO mni_vpl VALUES ("MT26_25","070_26_25","MAT","26","25","25","Adudagi Ibungobu pithokkadouriba Judas-na hairak-i, “Oja Ibungo, mahak adu eira?” Jisuna mangonda hairak-i, “Nahak nasamakna madu haijare.” ");
INSERT INTO mni_vpl VALUES ("MT26_26","070_26_26","MAT","26","26","26","Makhoina charingeida, Jisuna tal ama louraga Tengban Mapubu thagatchare. Aduga tal adubu machet machet setladuna mahakki tung-inbasing aduda piraga hairak-i, “Tal asi louduna chao, Masi eigi hakchangni.” ");
INSERT INTO mni_vpl VALUES ("MT26_27","070_26_27","MAT","26","27","27","Adudagi Ibungona anggur mahi tenggot ama amuk loukhatladuna madugidamak Tengban Mapubu thagatchare. Aduga madu makhoida piraduna hairak-i, “Nakhoi pumnamakna masi thak-u. ");
INSERT INTO mni_vpl VALUES ("MT26_28","070_26_28","MAT","26","28","28","Maramdi masi anouba walepnaba adugi, mi kayagi pap kokpinabagidamak tabikhraba eigi eeni. ");
INSERT INTO mni_vpl VALUES ("MT26_29","070_26_29","MAT","26","29","29","Eina nakhoida hairibasini, Ipagi leibakta eina nouna thakkadaba numit adu laktriba phaoba eina amuk hanna anggur mahi asi thaklaroi.” ");
INSERT INTO mni_vpl VALUES ("MT26_30","070_26_30","MAT","26","30","30","Adudagi makhoina Tengban Mapubu thagatpa isei ama saklamlaga Chorphon chingda chatkhre. ");
INSERT INTO mni_vpl VALUES ("MT26_31","070_26_31","MAT","26","31","31","Adudagi Jisuna makhoida hairak-i, “Ngasi ahing asida nakhoi pumnamakna eibu thadoklamgadouri. Maramdi Mapugi puyada asumna iduna lei, ‘Eina yaosenbabu yeithugani aduga yao sanggu adu chaithokkani.’ ");
INSERT INTO mni_vpl VALUES ("MT26_32","070_26_32","MAT","26","32","32","Adubu eina hinggatlaba matungda, nakhoidagi hanna Galilee-da chatkani.” ");
INSERT INTO mni_vpl VALUES ("MT26_33","070_26_33","MAT","26","33","33","Maduda Peter-na Ibungoda hairak-i, “Atei pumnamakna Ibungobu thadoklabasu eina Ibungobu keidounungda thadokloi!” ");
INSERT INTO mni_vpl VALUES ("MT26_34","070_26_34","MAT","26","34","34","Jisuna Peter-da hairak-i, “Eina nangonda tasengnamak hairibasini, ngasi ahing yenbarabana khongdringeigi mamangda nahakna eibu ahumlak yaroi.” ");
INSERT INTO mni_vpl VALUES ("MT26_35","070_26_35","MAT","26","35","35","Adubu Peter-na Ibungoda hairak-i, “Eina Ibungoga loinana siba tarabasu eina madu keidounungdasu haijaroi!” Aduga matou adugumna atei tung-inba pumnamaknasu maduga chap manana haikhi. ");
INSERT INTO mni_vpl VALUES ("MT26_36","070_26_36","MAT","26","36","36","Adudagi Jisuna mahakki tung-inbasing aduga loinana Gethsemane kouba mapham amada lakle, aduga mahakna makhoida hairak-i, “Eina ada chattuna haijaringeida, nakhoina mapham asida phamlammu.” ");
INSERT INTO mni_vpl VALUES ("MT26_37","070_26_37","MAT","26","37","37","Aduga Ibungona mahakka loinana Peter amadi Zebedee-gi machanupa ani purammi, amasung Ibungogi pukning amadi thawai waba houraklammi. ");
INSERT INTO mni_vpl VALUES ("MT26_38","070_26_38","MAT","26","38","38","Adudagi Ibungona makhoida hairak-i, “Eigi thamoisi sigadaba makhei khamthengna ware. Nakhoina mapham asida leiyu aduga eiga loinana mitseng khangg-u.” ");
INSERT INTO mni_vpl VALUES ("MT26_39","070_26_39","MAT","26","39","39","Aduga Ibungona manglomda khara chatlaga mamai leipak tana tuthajaduna haijarak-i, “He Ipa masi oiba yarabadi, awa anagi tenggot asi eingondagi louthokpiyu! Adum oinamakpu eihakki ningba oidaduna nahakki aningba adumak toubiyu.” ");
INSERT INTO mni_vpl VALUES ("MT26_40","070_26_40","MAT","26","40","40","Adudagi Ibungona tung-inbasing adugi manakta hallakpa matamda makhoina tumduna leiramba thengnare. Maduda Ibungona Peter-da hairak-i, “Nakhoina eiga loinana pung amatang phaoba mitseng khangba ngamdrabra? ");
INSERT INTO mni_vpl VALUES ("MT26_41","070_26_41","MAT","26","41","41","Nakhoi athembada tadanaba mitseng khangduna haijou. Thawainadi maningi, adubu hakchangnadi masolli.” ");
INSERT INTO mni_vpl VALUES ("MT26_42","070_26_42","MAT","26","42","42","Adudagi Ibungona anirak suba oina amuk chatthokladuna haijarak-i, “He Ipa, eina awa anagi tenggot asi thakpa nattana, eingondagi louthokpa yaroidaba oirabadi, Ibungogi aningba adumak oisanu.” ");
INSERT INTO mni_vpl VALUES ("MT26_43","070_26_43","MAT","26","43","43","Aduga Ibungona amuk halakpa matamda tung-inbasing adu tumduna leiramba thengnare, maramdi makhoigi mamit adu tumningbana lumtharammi. ");
INSERT INTO mni_vpl VALUES ("MT26_44","070_26_44","MAT","26","44","44","Maram aduna Ibungona makhoibu thanamlaga amuk chatthoktuna ahumlaksuba oina haanna haikhiba waheising aduga chap mannana haijarammi. ");
INSERT INTO mni_vpl VALUES ("MT26_45","070_26_45","MAT","26","45","45","Adudagi Ibungona tung-inbasing adugi manakta halaktuna makhoida hairak-i, “Nakhoi houjikphaoba tumduna potthaduna leiribra? Yeng-u, pungpham adu lakle amasung Migi Machanupa adu papchenba misinggi makhutta pithokadouri. ");
INSERT INTO mni_vpl VALUES ("MT26_46","070_26_46","MAT","26","46","46","Hougatlo, eikhoi chatlasi. Yeng-u eibu pithokkadaba mahak adu lakle!” ");
INSERT INTO mni_vpl VALUES ("MT26_47","070_26_47","MAT","26","47","47","Jisuna nganglingeimaktada, yeng-u tung-inba taranithoigi maraktagi ama oiriba Judas-na athoiba purohitsing amasung phurupki ahal-lamansingna tharakpa thangsang amasung cheitup paiba yamlaba miyam amaga loinana thunglare. ");
INSERT INTO mni_vpl VALUES ("MT26_48","070_26_48","MAT","26","48","48","Ibungobu pithokpa mahak aduna miyam aduda inggit touraduna hairak-i, “Eina chupkadouriba mahak adu nakhoina pamliba mi aduni; nakhoina mahakpu phao.” ");
INSERT INTO mni_vpl VALUES ("MT26_49","070_26_49","MAT","26","49","49","Khudak adumaktada Judas-na Jisugi nakta changsilladuna hairak-i, “Khurumjari, Oja Ibungo!” aduga mahakna Ibungobu chuple. ");
INSERT INTO mni_vpl VALUES ("MT26_50","070_26_50","MAT","26","50","50","Jisuna mangonda hairak-i, “Marup, nahakna pangthokpa lakliba adu pangthoklo.” Adudagi makhoina changsillaktuna Jisubu phare. ");
INSERT INTO mni_vpl VALUES ("MT26_51","070_26_51","MAT","26","51","51","Aduga Jisuga loinaribasing adugi maraktagi amana thangsang sattoktuna purohitlengi manai amagi mana kakthatlammi. ");
INSERT INTO mni_vpl VALUES ("MT26_52","070_26_52","MAT","26","52","52","“Maduda Jisuna mangonda hairak-i, Nahakki thangsangdu makhumda hapchillu, maramdi thang paiba mahakna thangda sigani. ");
INSERT INTO mni_vpl VALUES ("MT26_53","070_26_53","MAT","26","53","53","Eina Ipada eibu mateng pangbinaba koujaba amadi Ipana khudakta eigidamak swarga dut tenggol taranithoi henna tharakpa ngammoi haina nahakna khanbra? ");
INSERT INTO mni_vpl VALUES ("MT26_54","070_26_54","MAT","26","54","54","Adubu eina adumna tourabadi Mapugi puyana asumna thokkadabani haina haikhibasing adu karamna thunggadage?” ");
INSERT INTO mni_vpl VALUES ("MT26_55","070_26_55","MAT","26","55","55","Pungpham adumaktada Jisuna miyam aduda hairak-i, “Nakhoina eibu leibakki wayel pathap thugaiba tamthiba mi ama phagadabagum thangsang amasung cheitup paiduna eibu phaba laklibra? Numit khudinggi eina nakhoiga phaminaduna Mapugi Sanglenda tambikhi, adubu nakhoina eibu phakhide. ");
INSERT INTO mni_vpl VALUES ("MT26_56","070_26_56","MAT","26","56","56","Adubu Tengban Mapugi wa phongdokpa maichousingna Mapugi puyada ikhiba wasing adu thungnanabagidamak masi pumnamaksing asi thoklare.” Adudagi tung-inbasing pumnamakna Ibungobu thadoklamduna chenkhre. ");
INSERT INTO mni_vpl VALUES ("MT26_57","070_26_57","MAT","26","57","57","Jisubu phakhibasing aduna Jisubu purohitlen Caiaphas-ki yumda purakle. Mapham aduda Wayel Yathanggi ojasing amasung ahal-lamansing punna tinnaduna leirammi. ");
INSERT INTO mni_vpl VALUES ("MT26_58","070_26_58","MAT","26","58","58","Aduga Peter-na laptakna purohitlengi yumgi sumang phaoba Ibungogi tung-illaklammi. Amasung kari thokkadage haibadu yengnanabagidamak changsinduna ngakselliba manaising aduga phaminarammi. ");
INSERT INTO mni_vpl VALUES ("MT26_59","070_26_59","MAT","26","59","59","Athoiba purohitlensing, ahal-lamansing, amasung Sanhedrin apumbana Jisubu hatnanaba aranba sakhi thirammi. ");
INSERT INTO mni_vpl VALUES ("MT26_60","070_26_60","MAT","26","60","60","Adubu mi kaya ama thoraktuna Ibungogi maramda aranba kaya ama hairabasu makhoina mahakki maran amata phangkhide. Mameithangda nupa anikhak thoraklammi. ");
INSERT INTO mni_vpl VALUES ("MT26_61","070_26_61","MAT","26","61","61","Aduga makhoina hairak-i, “Nupa asina, ‘Eina Tengban Mapugi Sanglen adu thugairaga numit humnigi manungda amuk sagatpa ngammi haina haikhi.’ ” ");
INSERT INTO mni_vpl VALUES ("MT26_62","070_26_62","MAT","26","62","62","Adudagi purohitlen aduna lepkhattuna Jisuda hairak-i, “Nahakna paokhum amata piraroidra mising asina nahakki maiyokta thangjilliba naran asi karino?” ");
INSERT INTO mni_vpl VALUES ("MT26_63","070_26_63","MAT","26","63","63","Adubu Jisuna paokhum amata pidana tuminna leirammi. Adudagi purohitlenna amuk Ibungoda hairak-i, “Eina ahingba Tengban Mapugi minglen panduna nangonda hairi, nahak Tengban Mapugi Machanupa Christta adura eikhoida haiyu?” ");
INSERT INTO mni_vpl VALUES ("MT26_64","070_26_64","MAT","26","64","64","Jisuna mangonda hairak-i, “Nahakna hairiba adumakni; adumakpu eina nakhoi pumnamakta hairi, lakkadaba matamda Migi Machanupa aduna ingam-ngamba Mapu Ibungogi yetthangbada phamba amadi nongmadon leichillakta lenglakpa nakhoina ugani!” ");
INSERT INTO mni_vpl VALUES ("MT26_65","070_26_65","MAT","26","65","65","Maduda purohitlen aduna maphi segairaduna hairak-i, “Mahakna Tengban Mapubu thina ngangle. Eikhoina kari sakhi ama amuk mathou taribage? Yeng-u, mahakna Tengban Mapubu thina ngangba adu nakhoina tare! ");
INSERT INTO mni_vpl VALUES ("MT26_66","070_26_66","MAT","26","66","66","Nakhoina kari khanbage?” Maduda makhoina khumlak-i, “Mahak sibada matik chai.” ");
INSERT INTO mni_vpl VALUES ("MT26_67","070_26_67","MAT","26","67","67","Adudagi makhoina Ibungogi mamaida tin sinchinduna mahakpu khudumna suba houre. Aduga atei amana mahakpu khupakna thabire, ");
INSERT INTO mni_vpl VALUES ("MT26_68","070_26_68","MAT","26","68","68","aduga makhoina hairak-i, “Eikhoida phongdok-u, Christta, nangonda phukhiba misak adu kanano?” ");
INSERT INTO mni_vpl VALUES ("MT26_69","070_26_69","MAT","26","69","69","Matam aduda Peter-na mapan-gi sumangda phamduna leirammi. Aduga tengbangbi leisabi amana mahakki nakta laktuna hairak-i, “Nahaksu, Galilee-gi Jisuga loinarambasinggi marakta amani.” ");
INSERT INTO mni_vpl VALUES ("MT26_70","070_26_70","MAT","26","70","70","Adubu mahakna makhoi pumnamaki mamaangda yadaduna hairak-i, “Nahakna hairiba adu karino ei khangde.” ");
INSERT INTO mni_vpl VALUES ("MT26_71","070_26_71","MAT","26","71","71","Adudagi mahakna chatthokkhiduna hojanglomda thokkhre. Amasung atoppa tengbangbi leisabi amana mahakpu uraduna mapham aduda leiba mising aduda hairak-i, “Nupa asi Nazareth-ki Jisuga loinarambani.” ");
INSERT INTO mni_vpl VALUES ("MT26_72","070_26_72","MAT","26","72","72","Peter-na amukkasu maduda yadaduna khumlak-i, “Eina wasakli, nupa adu ei khangde.” ");
INSERT INTO mni_vpl VALUES ("MT26_73","070_26_73","MAT","26","73","73","Ngaihak leiraba matungda mapham aduda leptuna leiribasing aduna Peter-gi nakta laktuna hairak-i, “Asengbamak nahak makhoigi maraktagi amani; nahakki wa ngangbagi maong-matou aduna nahakpu saktakchare.” ");
INSERT INTO mni_vpl VALUES ("MT26_74","070_26_74","MAT","26","74","74","Adudagi mahak masa mathanta sirap toujaraduna amadi wasakladuna makhoida hairak-i, “Nupa adu ei khangde!” Aduga khudak adumaktada yenbarabana khonglakle. ");
INSERT INTO mni_vpl VALUES ("MT26_75","070_26_75","MAT","26","75","75","Adudagi “Yenbarabana khongdringeida, nangna eibu ahumlak yaroi” haiduna Jisuna haikhiba wa adu Peter-na ningsinglakle. Aduga mahakna mapanda thokkhraga thamoi sokna kaple. ");
INSERT INTO mni_vpl VALUES ("MT27_1","070_27_1","MAT","27","1","1","Ayuk anganbada, athoiba purohitsing pumnamak amasung ahal-lamansingna Jisubu hatnanaba wa tanarammi. ");
INSERT INTO mni_vpl VALUES ("MT27_2","070_27_2","MAT","27","2","2","Aduga makhoina Ibungobu punduna mapham adudagi puraklaga Rome-gi leingakmapu Pilat-ta sinnarammi. ");
INSERT INTO mni_vpl VALUES ("MT27_3","070_27_3","MAT","27","3","3","Adudagi makhoina Ibungobu maral siduna sibagi cheirak pikhiba adu Ibungobu pithokpa Judas-na ubada, ningamlaktraduna lupagi sel mayek kunthra adu athoiba purohitsinggi amadi ahal-lamansinggi maphamda handoklammi. ");
INSERT INTO mni_vpl VALUES ("MT27_4","070_27_4","MAT","27","4","4","Aduga mahakna hairak-i, “Eina maran leitaba mi amabu pithoktuna pap toukhare.” Maduda makhoina khumlak-i, “Maduda eikhoigi kari ithou leibage? Madudi nahakki nathouni!” ");
INSERT INTO mni_vpl VALUES ("MT27_5","070_27_5","MAT","27","5","5","Adudagi mahakna lupagi sel mayeksing adu Mapugi Sanglenda langsillamlaga chatkhre; aduga mahakna chatkhraga masa mathanta thouri yanduna sijare. ");
INSERT INTO mni_vpl VALUES ("MT27_6","070_27_6","MAT","27","6","6","Athoiba purohitsingna lupagi sel mayeksing adu loukhatlaga hairak-i, “Masi Mapugi Sanglengi lan-thamphamda thamjinbada eikhoigi Wayel Yathang kai maramdi masi ee-gi mamalni.” ");
INSERT INTO mni_vpl VALUES ("MT27_7","070_27_7","MAT","27","7","7","Aduga makhoina wa tanaraba tungda sel aduna chaphu sabagi loubuk adu leire amasung makhoina maduda lamlanbasingbu phumnanaba mapham semle. ");
INSERT INTO mni_vpl VALUES ("MT27_8","070_27_8","MAT","27","8","8","Maram aduna loubuk adubu “Ee-gi loubuk” haina ngasi phaoba kounari. ");
INSERT INTO mni_vpl VALUES ("MT27_9","070_27_9","MAT","27","9","9","Maduna Tengban Mapugi wa phongdokpiba Jeremiah-na haikhiba adu thunghalle: “Israel-gi misingna lepkhiba Ibungogi mamal lupagi sel mayek kunthra adu makhoina loure, ");
INSERT INTO mni_vpl VALUES ("MT27_10","070_27_10","MAT","27","10","10","Aduga MAPU IBUNGO-na yathang pibikhibagumna sel adu makhoina chaphu sabagi loubuk leibada sijinnare.” ");
INSERT INTO mni_vpl VALUES ("MT27_11","070_27_11","MAT","27","11","11","Matam aduda Jisuna Rome leibakki leingakmapugi mangda leplammi. Aduga leingakmapu aduna Jisuda hanglak-i, “Nahak Jihudisinggi ningthoura?” Maduda Jisuna mangonda khumlak-i, “Hoi, Nahakna hairiba aduni.” ");
INSERT INTO mni_vpl VALUES ("MT27_12","070_27_12","MAT","27","12","12","Adubu athoiba purohitsing amasung ahal-lamansingna Ibungoda maral siba matam aduda Ibungona kari amata khumlamde. ");
INSERT INTO mni_vpl VALUES ("MT27_13","070_27_13","MAT","27","13","13","Maduda Pilat-na Ibungoda hairak-i, “Makhoina nahakki nathakta maral mayam siribasing asi nahak tadabra?” ");
INSERT INTO mni_vpl VALUES ("MT27_14","070_27_14","MAT","27","14","14","Adubu Jisuna wahei amatasu khumlaktaba aduda leingakmapu adu yamna ngaklammi. ");
INSERT INTO mni_vpl VALUES ("MT27_15","070_27_15","MAT","27","15","15","Lanthokpibagi chakkhangba khudingda Pilat-na miyamgi apamba phadok amabu thadokpiba asi mahakki mahousani. ");
INSERT INTO mni_vpl VALUES ("MT27_16","070_27_16","MAT","27","16","16","Matam aduda Barabbas kouba maming chatlaba phadok ama leirammi. ");
INSERT INTO mni_vpl VALUES ("MT27_17","070_27_17","MAT","27","17","17","Maram aduna miyam adu tillabada Pilat-na makhoida hanglak-i, “Eina nakhoigidamak kanabu thadok-haningbage? Barabbas pura nattraga Christta kouba Jisubura?” ");
INSERT INTO mni_vpl VALUES ("MT27_18","070_27_18","MAT","27","18","18","Jihudi luchingbasingna kallakpagi maramna Jisubu mangonda sinarakpani haibasi Pilat-na munna khanglammi. ");
INSERT INTO mni_vpl VALUES ("MT27_19","070_27_19","MAT","27","19","19","Aduga Pilat-na wayen phambeida phamlingeida, mahakki nupina pao ama tharaktuna mangonda hairak-i, “Maran leitaba mi aduda nahakna kari amata touganu, maramdi mahakki maramda ngasi mangda yamna awa khanglammi.” ");
INSERT INTO mni_vpl VALUES ("MT27_20","070_27_20","MAT","27","20","20","Adubu athoiba purohitsing amasung ahal-lamansingna miyam aduda Barabbas-pu thadoknanaba aduga Jisubuna hatnanaba haiyu haina insillammi. ");
INSERT INTO mni_vpl VALUES ("MT27_21","070_27_21","MAT","27","21","21","Maduda leingakmapuna makhoida hanglak-i, “Makhoi ani asigi maraktagi kanabu eina nakhoigidamak thadok-haningbage?” Makhoina hairak-i, “Barabbas-pu thadok-u!” ");
INSERT INTO mni_vpl VALUES ("MT27_22","070_27_22","MAT","27","22","22","Maduda Pilat-na makhoida hanglak-i, “Adu oirabadi Christta kouba Jisubu eina kari tougadage?” Makhoi pumnamakna khumlak-i, “Mahakpu cross-ta hatlu!” ");
INSERT INTO mni_vpl VALUES ("MT27_23","070_27_23","MAT","27","23","23","Aduda Pilat-na makhoida hanglak-i, “Mahakna kari phattaba toukhrabage?” Maduda makhoina henadum laona hairak-i, “Mahakpu cross-ta hatlu!” ");
INSERT INTO mni_vpl VALUES ("MT27_24","070_27_24","MAT","27","24","24","Mahakna kari amata pangthokpa ngamdre adubu madugi mahutta irang hourakadoure haiba Pilat-na ubada, mahakna miyam adugi mamangda ising louraga makhut hamladuna hairak-i, “Maral leitaba nupa asigi ee-gi maramda eigi iral leite. Masi nakhoigi nasarukni?” ");
INSERT INTO mni_vpl VALUES ("MT27_25","070_27_25","MAT","27","25","25","Maduda makhoi pumnamakna khumlak-i, “Mahakki ee adu eikhoida amasung eikhoigi ichasinggi mathakta tasanu!” ");
INSERT INTO mni_vpl VALUES ("MT27_26","070_27_26","MAT","27","26","26","Maram aduna Pilat-na makhoigidamak Barabbas-pu thadokle aduga mahakna Jisubu phuhalle aduga cross-ta hatnaba makhoida sinakhre. ");
INSERT INTO mni_vpl VALUES ("MT27_27","070_27_27","MAT","27","27","27","Adudagi leingakmapugi lanmisingna Jisubu leingakmapugi leipham praetorium-da pusille aduga lanmi kangbu apumbana Ibungogi akoibada koisilammi. ");
INSERT INTO mni_vpl VALUES ("MT27_28","070_27_28","MAT","27","28","28","Aduga makhoina Ibungogi maphi louthoklaga mangra machugi achonba phi setchinbire. ");
INSERT INTO mni_vpl VALUES ("MT27_29","070_27_29","MAT","27","29","29","Adudagi makhoina tingkhanggi luhup ama lollaga Ibungogi makokta upsinbire aduga Ibungogi yet thangba makhuta sing-ut machei ama paihalle. Aduga makhoina Ibungogi mangda khuru khudak kunduna noknaduna hairak-i, “Khurumjari, he Jihudisinggi ningthou?” ");
INSERT INTO mni_vpl VALUES ("MT27_30","070_27_30","MAT","27","30","30","Adudagi makhoina Ibungoda tin sitchille aduga sing-ut machei adu louraga Ibungogi kokta phure. ");
INSERT INTO mni_vpl VALUES ("MT27_31","070_27_31","MAT","27","31","31","Aduga makhoina Ibungobu noknaraba matungda Ibungogi achonba phi adu louthoklaga Ibungo masagi phi adu amuk hanna setchinbire. Aduga makhoina mahakpu cross-ta hatnaba pukhre. ");
INSERT INTO mni_vpl VALUES ("MT27_32","070_27_32","MAT","27","32","32","Makhoina asum chatlingeida Simon kouba Cyrene-gi nupa ama thengnare aduga lanmising aduna mahakpu namduna Jisugi cross puhalle. ");
INSERT INTO mni_vpl VALUES ("MT27_33","070_27_33","MAT","27","33","33","Adudagi makhoina Golgotha haibadi handokpada “Kokki sarugi mapham” kouba mapham aduda lakle. ");
INSERT INTO mni_vpl VALUES ("MT27_34","070_27_34","MAT","27","34","34","Lanmising aduna akhaba yansillaba yu Ibungoda thaknaba pirammi adubu Ibungona madu mahao tanglabada thak-u haiba yadre. ");
INSERT INTO mni_vpl VALUES ("MT27_35","070_27_35","MAT","27","35","35","Makhoina Ibungobu cross-ta yotpi thaduna pang tinglaba matungda, makhoina laibak chang yengnaduna Ibungogi maphi-marolsing adu makhoi masel yennarammi. Masi Tengban Mapugi wa phongdokpiba maichou aduna haikhiba asi thungnanabani “Makhoina eigi phirol makhoigi marakta yenare aduga makhoina eigi achonba phigidamak laibak chang yengnare!” ");
INSERT INTO mni_vpl VALUES ("MT27_36","070_27_36","MAT","27","36","36","Aduga makhoina mapham aduda phamduna Ibungobu sanglammi. ");
INSERT INTO mni_vpl VALUES ("MT27_37","070_27_37","MAT","27","37","37","Adudagi “Masi Jihudisinggi ningthou Jisu aduni” haina i-ba Ibungobu maran siba ayiba adu Ibungogi kokthaklomda makhoina thetle. ");
INSERT INTO mni_vpl VALUES ("MT27_38","070_27_38","MAT","27","38","38","Makhoina Ibungoga loinana huranba anibusu, amana Ibungogi yetta aduga amana oida cross-ta pang tinglammi. ");
INSERT INTO mni_vpl VALUES ("MT27_39","070_27_39","MAT","27","39","39","Adudagi manak aduwaida chatthok chatsin touriba misingna Ibungoda thina nganglammi amasung mangak nomladuna, ");
INSERT INTO mni_vpl VALUES ("MT27_40","070_27_40","MAT","27","40","40","noknaduna hairak-i, “Mapugi Sanglen thugaiduna numit humnida sagatkadaba nahak, nasabu kanjou! Nahak Tengban Mapugi Machanupa oirabadi cross-tagi kumtharak-u!” ");
INSERT INTO mni_vpl VALUES ("MT27_41","070_27_41","MAT","27","41","41","Adugumduna athoiba purohitsing, Wayel Yathanggi ojasing amasung ahal- lamansingnasu Jisubu noknaduna hairak-i. ");
INSERT INTO mni_vpl VALUES ("MT27_42","070_27_42","MAT","27","42","42","“Mahakna atoppasingbudi kanbi adubu mahak masabudi kanjaba ngamjade, Mahak Israel-gi ningthou nattra? Houjik mahakna cross-tagi kumthasanu aduga eikhoina mahakpu thajage. ");
INSERT INTO mni_vpl VALUES ("MT27_43","070_27_43","MAT","27","43","43","Mahakna Tengban Mapubu thajei. Tengban Mapuna mahakpu kanba pamlabadi houjik mahakpu kanbisanu maramdi ‘Eidi Tengban Mapugi Machanupani’ haina mahakna haijei!” ");
INSERT INTO mni_vpl VALUES ("MT27_44","070_27_44","MAT","27","44","44","Ibungoga loinana pang tingminnakhiba huranba ani adunasu Ibungobu chap manaba maongda ikaiba pirammi. ");
INSERT INTO mni_vpl VALUES ("MT27_45","070_27_45","MAT","27","45","45","Numityungba matamda leibak sinba thungna pung ahum amambana kupsillammi. ");
INSERT INTO mni_vpl VALUES ("MT27_46","070_27_46","MAT","27","46","46","Pung ahummuk tarakpa matamduda Jisuna ahouba khonjelga loinana laorak-i, “Eloi, Eloi, lama sabachthani?” Masigi wahanthokti “Eigi Tengban Mapu Ibungo, eigi Tengban Mapu Ibungo, nangna eibu karigi thadokpiribano?” haibani. ");
INSERT INTO mni_vpl VALUES ("MT27_47","070_27_47","MAT","27","47","47","Mapham aduda leiriba makhoi kharana madu tabada hairak-i, “Mahakna Elijah-bu kouri.” ");
INSERT INTO mni_vpl VALUES ("MT27_48","070_27_48","MAT","27","48","48","Khudak aduda makhoigi maraktagi amana chenkhiduna sponge ama louraga asinba yuda luple aduga sing-ut amada lengsilaga Ibungoda thaknaba pire. ");
INSERT INTO mni_vpl VALUES ("MT27_49","070_27_49","MAT","27","49","49","Adubu atoppa misingna hairak-i, “Ngaikho, Elijah laktuna mahakpu kanbibra haibadu eikhoi yengkhisi.” ");
INSERT INTO mni_vpl VALUES ("MT27_50","070_27_50","MAT","27","50","50","Adudagi Jisuna khonjel houna amuk laoramlaga mathawai thakhre. ");
INSERT INTO mni_vpl VALUES ("MT27_51","070_27_51","MAT","27","51","51","Matam aduda Mapugi Sanglen-gi asengba maphamgi phijang adu mathaktagi makha phaoba ani thokna segairammi. Aduga malem niklammi amasung nungjaosing kairammi. ");
INSERT INTO mni_vpl VALUES ("MT27_52","070_27_52","MAT","27","52","52","Amasung mongphamsing hangdokle aduga sikhraba asengba mising kaya ama hinggatle. ");
INSERT INTO mni_vpl VALUES ("MT27_53","070_27_53","MAT","27","53","53","Aduga Jisuna hinggatlaba matungda, makhoina mongphamsing adu thadoklaga asengba saharda changduna mi kaya amada uhalle. ");
INSERT INTO mni_vpl VALUES ("MT27_54","070_27_54","MAT","27","54","54","Lanmi chamagi makok amasung mahakka loinana Jisubu sangliba lanmising aduna yuhar haba amadi thokliba thoudoksing adu ubada yamna kiraduna hairak-i, “Mahak asi asengbamak Tengban Mapugi Machanupani!” ");
INSERT INTO mni_vpl VALUES ("MT27_55","070_27_55","MAT","27","55","55","Galilee-dagi Jisugi matung injaduna Ibungogi thougal toujakhiba nupi mayam ama mapham aduda arappadagi yengduna leirammi. ");
INSERT INTO mni_vpl VALUES ("MT27_56","070_27_56","MAT","27","56","56","Makhoisinggi marakta Mary Magdalene, Jacob amadi Joseph-ki mama Mary, amasung Zebedee-gi nupi yaorammi. ");
INSERT INTO mni_vpl VALUES ("MT27_57","070_27_57","MAT","27","57","57","Numidangwairam oirakllabada, Jisugi tung-inba amasu oiriba Arimathea-dagi Joseph kouba inakkhunba nupa ama laklammi. ");
INSERT INTO mni_vpl VALUES ("MT27_58","070_27_58","MAT","27","58","58","Mahakna Pilat-ki maphamda chattuna Jisugi hakchang nijarammi, maduda Ibungogi hakchang adu mangonda pinaba Pilat-na yathang pire. ");
INSERT INTO mni_vpl VALUES ("MT27_59","070_27_59","MAT","27","59","59","Adudagi Joseph-na hakchang adu louraga ananba muga manbi phi amana yomsille. ");
INSERT INTO mni_vpl VALUES ("MT27_60","070_27_60","MAT","27","60","60","Aduga nungjaoda huttuna semba mahak masagi anouba mongphamda mahakna madubu thamle. Amasung mahakna achouba nung ama insillamduna mongphamgi changpham adu thinglamlaga mahak chatkhre. ");
INSERT INTO mni_vpl VALUES ("MT27_61","070_27_61","MAT","27","61","61","Aduga Mary Magdalene amasung atoppa Mary-na mongphamga maiyoknana phamduna leirammi. ");
INSERT INTO mni_vpl VALUES ("MT27_62","070_27_62","MAT","27","62","62","Mathanggi numit haibadi potthaba numitta, athoiba purohitsing amasung pharisee-singna Pilat unaba punna laklammi. ");
INSERT INTO mni_vpl VALUES ("MT27_63","070_27_63","MAT","27","63","63","Aduga makhoina Pilat-ta hairak-i, “Ikai khumnajaraba Ibungo, minamba nupa aduna hinglingeida, ‘Humni suba numitta eina amuk hinggatkani’ haina haikhiba adu eikhoi ningsing-i. ");
INSERT INTO mni_vpl VALUES ("MT27_64","070_27_64","MAT","27","64","64","Maram aduna numit humni sudriphaoba mongpham adu ningthina ngak-sennaba yathang pibiyu, nattrabadi mahakki tung-inbasingna laktuna mabu hukhraga, mahakpu asibasinggi maraktagi hinggatpikhre, haina misingda haiba yai. Madugi akonba minamba aduna ahanbagi minamba adudagi henna patthaba oigani.” ");
INSERT INTO mni_vpl VALUES ("MT27_65","070_27_65","MAT","27","65","65","Maduda Pilat-na makhoida hairak-i, “Nakhoina ngak-sennaba lanmising lou, Aduga nakhoina ngamba makhei cheksinna ngak-hallu.” ");
INSERT INTO mni_vpl VALUES ("MT27_66","070_27_66","MAT","27","66","66","Maram aduna makhoina chatkhraga mongpham adugi nung adu chum namduna amadi lanmising thamduna mongpham adu cheksinna ngakhalle. ");
INSERT INTO mni_vpl VALUES ("MT28_1","070_28_1","MAT","28","1","1","Potthaba numitki matung, chayolgi ahanba numitki ayuk anganbada Mary Magdalene amasung atoppa Mary aduna mongpham adu yengnaba laklammi. ");
INSERT INTO mni_vpl VALUES ("MT28_2","070_28_2","MAT","28","2","2","Aduga khanghoudana akanba yuhar haba ama thokle! Maramdi Mapu Ibungogi dut amana swargadagi kumtharaktuna mongpham aduda laklaga nung adu inthoktuna madugi mathakta phamlammi. ");
INSERT INTO mni_vpl VALUES ("MT28_3","070_28_3","MAT","28","3","3","Mahakki maithong adu nongthang kuppagum oirammi, amasung mahakki phising adu un-gumna ngourammi. ");
INSERT INTO mni_vpl VALUES ("MT28_4","070_28_4","MAT","28","4","4","Ngakseliba lanmising aduna mahakpu ubada kiraduna niklammi amasung makhoi asiba misingumna oirammi. ");
INSERT INTO mni_vpl VALUES ("MT28_5","070_28_5","MAT","28","5","5","Adudagi dut aduna nupising aduda hairak-i; “Nakhoi kiganu, cross-ta hatkhiba Jisubu nakhoina thiribani haiba Eina khang-i. ");
INSERT INTO mni_vpl VALUES ("MT28_6","070_28_6","MAT","28","6","6","Ibungo mahakti mapham asida leitre; maramdi Ibungo mahakna haikhibagumna mahak hinggatkhre. Lak-u, Ibungobu thamlamba mapham asi yeng-u. ");
INSERT INTO mni_vpl VALUES ("MT28_7","070_28_7","MAT","28","7","7","Aduga nakhoina thuna chattuna Ibungogi tung-inbasingda asumna tamlu madudi ‘Asibasinggi maraktagi Ibungo mahak hinggatkhre amasung Ibungona nakhoidagi mangthana Galilee-da chatli aduga nakhoina Ibungobu mapham aduda ugani.’ ” ");
INSERT INTO mni_vpl VALUES ("MT28_8","070_28_8","MAT","28","8","8","Aduga makhoina akiba amasung haraobaga loinana mongpham adu thuna thadoktuna Ibungogi tung-inbasingda pao adu tamlunaba chenkhre. ");
INSERT INTO mni_vpl VALUES ("MT28_9","070_28_9","MAT","28","9","9","Aduga makhoina pao asi tung-inbasingda tamlunaba asum chatlingeida khanghoudana Jisuna makhoibu oknaduna hairak-i, “Nakhoida ingthaba oisanu.” Aduga makhoina Ibungogi manakta changsillaklaga khong paiduna Ibungobu khurumjarammi. ");
INSERT INTO mni_vpl VALUES ("MT28_10","070_28_10","MAT","28","10","10","Adudagi Jisuna makhoida hairak-i, “Kiganu, Chatlu aduga eigi ichil-inaosingda Galilee-da chatnaba haiyu; makhoina mapham aduda eibu ujagani.” ");
INSERT INTO mni_vpl VALUES ("MT28_11","070_28_11","MAT","28","11","11","Nupising aduna chatlingeida, mongpham adubu ngakselliba lanmising adugi maraktagi kharana saharda chatkhiduna thokkhiba thoudok khudingmak athoiba purohitsingda tamle. ");
INSERT INTO mni_vpl VALUES ("MT28_12","070_28_12","MAT","28","12","12","Aduga athoiba purohitsing aduna ahal-lamansingga unaduna wa tanaraga lanmising aduda yamlaba sel ama pirammi. ");
INSERT INTO mni_vpl VALUES ("MT28_13","070_28_13","MAT","28","13","13","Aduga makhoina lanmising aduda hairak-i, “Eikhoina tumlingeida mahakki tung-inbasingna ahingda laktuna mahakki hakchang hurankhre haina nakhoina misingda haiyu. ");
INSERT INTO mni_vpl VALUES ("MT28_14","070_28_14","MAT","28","14","14","Aduga pao asi leingak mapugi nakong youkhrabasu, eikhoina mahakpu themgani aduga nakhoibu khudongthibada tahanbiroi.” ");
INSERT INTO mni_vpl VALUES ("MT28_15","070_28_15","MAT","28","15","15","Asumna lanmising aduna sel adu louraga makhoida tou haina takkhiba adumak toure. Hairiba pao asi Jihudisinggi marakta ngasi phaoba pak sanna sandokli. ");
INSERT INTO mni_vpl VALUES ("MT28_16","070_28_16","MAT","28","16","16","Adudagi tung-inba taramathoi aduna Galilee-da laktuna Jisuna makhoida chatlu haina takpikhiba ching aduda chatlammi. ");
INSERT INTO mni_vpl VALUES ("MT28_17","070_28_17","MAT","28","17","17","Aduga makhoina Ibungobu ujabada khurumjarammi; adubu makhoi kharanadi chingnarammi. ");
INSERT INTO mni_vpl VALUES ("MT28_18","070_28_18","MAT","28","18","18","Madudagi Jisuna makhoigi manakta changsillaktuna hairak-i, “Swarga amasung malemda leiba matik pumnamak eingonda pibire. ");
INSERT INTO mni_vpl VALUES ("MT28_19","070_28_19","MAT","28","19","19","Maram aduna nakhoina chattuna phurup pumnamakpu eigi tung-inba semmu: Aduga makhoibu Mapa, Machanupa amasung Thawai Asengbagi mingda baptize tou. ");
INSERT INTO mni_vpl VALUES ("MT28_20","070_28_20","MAT","28","20","20","Eina nakhoida pikhiba yathang pumnamak adu ngaknaba makhoibu tambiyu. Aduga yeng-u, taibangpangi aroiba matam adu phaoba nakhoibu matam pumnamakta eina loinabigani.”");
INSERT INTO mni_vpl VALUES ("MK1_1","071_1_1","MRK","1","1","1","Aphaba Pao asi Tengban Mapugi Machanupa Jisu Christtagi maramdani. ");
INSERT INTO mni_vpl VALUES ("MK1_2","071_1_2","MRK","1","2","2","Aphaba Pao asi, Mapu Ibungogi wa phongdokpiba maichou Isaiah-na ikhibagumna asumna hou-i, “Mapu Ibungona hai, ‘Eina eigi pao pubabu nahakki lambi thourang tounanaba nahakki namang thana thagani.’ ");
INSERT INTO mni_vpl VALUES ("MK1_3","071_1_3","MRK","1","3","3","Kanagumba amana lamjao lamhangda laori, ‘MAPU IBUNGO-gi lambi adu thourang tou; Ibungo mahakna chatnaba lambi chumhallu!’ ” ");
INSERT INTO mni_vpl VALUES ("MK1_4","071_1_4","MRK","1","4","4","Matou adugumduna baptize toubiba John-na miyamda pap kokchanabagidamak pukning hongbagi baptize touba adu sandoktuna lamjao lamhangda thorakle. Mahakna miyam aduda hairammi, “Nakhoina paptagi pukning hongduna baptize lou, aduga Mapu Ibungona nakhoigi papsing kokpigani.” ");
INSERT INTO mni_vpl VALUES ("MK1_5","071_1_5","MRK","1","5","5","Jerusalem sahardagi mising yaona Judea lamdagi yamlaba misingna John-na hairibadu tananaba thoraklammi. Aduga makhoina makhoigi mapapsing haidokcharammi amasung John-na makhoibu Jordan turelda baptize toubirammi. ");
INSERT INTO mni_vpl VALUES ("MK1_6","071_1_6","MRK","1","6","6","John-na ut matugi phi setlammi, sawun-gi khwangjet laklammi aduga koujeng amasung lamlakki khoihina mahakki chinjak oirammi. ");
INSERT INTO mni_vpl VALUES ("MK1_7","071_1_7","MRK","1","7","7","Aduga miyam aduda mahakna asumna laothokle, “Eigi tungda lenglakkadouriba Ibungo mahak aduna eingondagi yamna henna matik magun chao-i. Eina nonthajaduna Ibungo mahakki sandal mari louthokpa phaoba itik chajade. ");
INSERT INTO mni_vpl VALUES ("MK1_8","071_1_8","MRK","1","8","8","Einadi nakhoibu isingda baptize tou-i adubu Ibungo mahaknadi nakhoibu Thawai Asengbada baptize toubigani.” ");
INSERT INTO mni_vpl VALUES ("MK1_9","071_1_9","MRK","1","9","9","Matam aduda Jisuna Galilee-gi lam Nazareth-tagi laklammi amasung John-na Ibungobu Jordan turelda baptize toubikhi. ");
INSERT INTO mni_vpl VALUES ("MK1_10","071_1_10","MRK","1","10","10","Amasung Jisuna isingdagi hek karakpaga, nongdon atiya hangdoktuna Thawaina Ibungogi mathakta khunugumna lengtharakpa Ibungona urammi. ");
INSERT INTO mni_vpl VALUES ("MK1_11","071_1_11","MRK","1","11","11","Aduga swargadagi khonjel amana asumna hairak-i, “Nahak eigi nungsijaraba Ichanupani. Eina nangonda yamna pelle.” ");
INSERT INTO mni_vpl VALUES ("MK1_12","071_1_12","MRK","1","12","12","Adudagi khudak aduda Mapu Ibungogi Thawaina Ibungobu lamjao lamhangda puthoklammi. ");
INSERT INTO mni_vpl VALUES ("MK1_13","071_1_13","MRK","1","13","13","Aduga Satan-na themladuna mapham aduda Ibungona numit niphuni leire. Mapham aduda lamlakki sasingsu leirammi, adubu swargadutsingna laktuna Ibungobu thougal tourammi. ");
INSERT INTO mni_vpl VALUES ("MK1_14","071_1_14","MRK","1","14","14","John-bu keisumsangda thamkhraba matungda, Jisuna Galilee-da chattuna Tengban Mapugi Aphaba Pao sandoklammi. ");
INSERT INTO mni_vpl VALUES ("MK1_15","071_1_15","MRK","1","15","15","Ibungona hairak-i, “Achaba matam adu lakle, aduga Tengban Mapugi leibak adu naksillakle! Nakhoina paptagi pukning hongduna Aphaba Paoda thajou!” ");
INSERT INTO mni_vpl VALUES ("MK1_16","071_1_16","MRK","1","16","16","Adudagi Ibungona Galilee-gi pat mapanda asum chatlingeida, in hunduna nga phariba Simon amadi mahakki manao Andrew-bu ure. ");
INSERT INTO mni_vpl VALUES ("MK1_17","071_1_17","MRK","1","17","17","Amasung Ibungona makhoida hairak-i, “Eigi itung illu, eina nakhoibu mi phabasing oihan-gani.” ");
INSERT INTO mni_vpl VALUES ("MK1_18","071_1_18","MRK","1","18","18","Khudak adumaktada makhoina makhoigi insingdu thanamlaga Ibungogi tung injare. ");
INSERT INTO mni_vpl VALUES ("MK1_19","071_1_19","MRK","1","19","19","Ibungona mapham adudagi khara chatlaga, Zebedee-gi machanupa Jacob amadi mahakki manao John-bu ure. Makhoina hinungda makhoigi insing semjin sajinduna leirammi. ");
INSERT INTO mni_vpl VALUES ("MK1_20","071_1_20","MRK","1","20","20","Jisuna makhoibu hek ubaga, makhoibu koure; maduda makhoina makhoigi mapa Zebedee-bu anekpa sinmisingga loinana hinungda thanamlaga Jisugi tung injare. ");
INSERT INTO mni_vpl VALUES ("MK1_21","071_1_21","MRK","1","21","21","Adudagi Jisu amadi mahakki tung inbasingna Capernaum saharda laklammi, aduga potthaba numitta Ibungona synagogue-ta changduna tambiba hourammi. ");
INSERT INTO mni_vpl VALUES ("MK1_22","071_1_22","MRK","1","22","22","Ibungogi tambiba matambi aduda makhoi ngakle, maramdi Ibungona Wayel Yathanggi Ojasinggumna nattaduna, matik leiba mi amagum tambirammi. ");
INSERT INTO mni_vpl VALUES ("MK1_23","071_1_23","MRK","1","23","23","Adudagi ikhang khang-houdana phattaba thawai changba mi ama synagogue aduda changlaklaga khonjel houna laoraduna hairak-i, ");
INSERT INTO mni_vpl VALUES ("MK1_24","071_1_24","MRK","1","24","24","“He Nazareth-ki Jisu, nangna eikhoida kari touba pambage? Nahak eikhoibu mang-hannaba mapham asida laklibra? Nahak kanano haiba ei khang-i, nahakti Mapu Ibungona tharakpa Asengba Mahak aduni.” ");
INSERT INTO mni_vpl VALUES ("MK1_25","071_1_25","MRK","1","25","25","Maduda Jisuna phattaba thawai aduda yathang piraduna hairak-i, “Tuminna leiyu, aduga mangondagi thokkhro!” ");
INSERT INTO mni_vpl VALUES ("MK1_26","071_1_26","MRK","1","26","26","Adudagi phattaba thawai aduna nupa adubu ot-neina nik-laduna, ahouba khonjelda laoramlaga nupa adudagi thokkhre. ");
INSERT INTO mni_vpl VALUES ("MK1_27","071_1_27","MRK","1","27","27","Maduda makhoi pumnamak ngakladuna makhoi masel amaga amaga hangnaduna hairak-i, “Touribasi karino? Masibu karamba makhalgi anouba tambibano? Mahakna phattaba thawaisingda phaoba yathang pinaba matik lei aduga makhoina mahakki yathang illi!” ");
INSERT INTO mni_vpl VALUES ("MK1_28","071_1_28","MRK","1","28","28","Khudak adudagi Jisugi paona thunamak Galilee-gi mapham sinba thungkhre. ");
INSERT INTO mni_vpl VALUES ("MK1_29","071_1_29","MRK","1","29","29","Jisu amadi mahakki tung-inbasingna synagogue adudagi hek thorakpaga, Jacob amasung John-ga loinana Simon amadi Andrew-gi yumda chatlammi. ");
INSERT INTO mni_vpl VALUES ("MK1_30","071_1_30","MRK","1","30","30","Matam aduda Simon-gi manembok laihou houduna nabadagi phamungda leirammi. Ibungona hek thungbaga makhoina mahakki maramda Ibungoda tamle. ");
INSERT INTO mni_vpl VALUES ("MK1_31","071_1_31","MRK","1","31","31","Adudagi Ibungona mahakki manakta changlaga makhut paibiduna mahakpu chingkhatpirammi. Aduga khudak aduda mahakki laihou adu phakhre amasung mahakna makhoibu thougal toujare. ");
INSERT INTO mni_vpl VALUES ("MK1_32","071_1_32","MRK","1","32","32","Adudagi numitna mayum changkhiduna numidangwairam oiraklabada misingna anaba amadi lai phattaba changba pumnamak Ibungogi manakta puraklammi. ");
INSERT INTO mni_vpl VALUES ("MK1_33","071_1_33","MRK","1","33","33","Amasung sahar adugi mi pumnamak yum adugi mangda tillare. ");
INSERT INTO mni_vpl VALUES ("MK1_34","071_1_34","MRK","1","34","34","Aduga Ibungona mi kaya amabu makhal makha kayagi lainasingdagi phahanbire amasung lai phattaba kaya amabusu tanthokle. Amasung Ibungona lai phattabasingdu wa amata ngang-hallamde maramdi makhoina Ibungobu kanano haiba khanglammi. ");
INSERT INTO mni_vpl VALUES ("MK1_35","071_1_35","MRK","1","35","35","Ayuk yamna ngallingei, mamlingei matamda, Jisuna hougattuna yum adudagi thoraklaga achikpa mapham amada chattuna Mapu Ibungoda haijarammi. ");
INSERT INTO mni_vpl VALUES ("MK1_36","071_1_36","MRK","1","36","36","Adudagi Simon amadi mahakka loinabasingna Ibungobu thiba thorakle. ");
INSERT INTO mni_vpl VALUES ("MK1_37","071_1_37","MRK","1","37","37","Aduga makhoina Ibungobu phanglabada, makhoina Ibungoda hairak-i, “Mi pumnamakna Ibungo nahakpu thiri.” ");
INSERT INTO mni_vpl VALUES ("MK1_38","071_1_38","MRK","1","38","38","Maduda Jisuna khumlak-i, “Eikhoina manak nakpa atei khulsingdasu chatkadabani. Eihakna makhoidasu pao sandokpa tai, maramdi ei madugidamak lakpani.” ");
INSERT INTO mni_vpl VALUES ("MK1_39","071_1_39","MRK","1","39","39","Maram aduna Ibungona Galilee-gi mapham pumnamakta chattuna, synagogue-singda pao sandoklammi aduga lai phattabasingbu tanthoklammi. ");
INSERT INTO mni_vpl VALUES ("MK1_40","071_1_40","MRK","1","40","40","Yamna kiningai oiba unsagi lainana naba mi amana Jisuda laktuna khuru khudak kullaga tengbangbinaba haijarak-i, “Ibungona yabirabadi, eibu Ibungona seng-hanbiba ngammi.” ");
INSERT INTO mni_vpl VALUES ("MK1_41","071_1_41","MRK","1","41","41","Maduda Jisuna nungsiba pokladuna makhut tingthoklaga mahakpu sokpiraduna hairak-i, “Eina yare, nahak sengjaro!” ");
INSERT INTO mni_vpl VALUES ("MK1_42","071_1_42","MRK","1","42","42","Khudak aduda mangondagi laina adu mangkhre aduga mahak sengjare. ");
INSERT INTO mni_vpl VALUES ("MK1_43","071_1_43","MRK","1","43","44","Adudagi Jisuna nupa aduda hairak-i, “Yeng-u, masi mi kana amatada haidokkanu; adubu nahakna chattuna purohitta yeng-hallu. Aduga mipum khudingmakna nahak naba phare haiba khangnanaba Moses-na katlu hairamba potlamsing adu katcharu.” Asumna akanba yathang asi piraga khudak aduda Jisuna mahakpu thakhre. ");
INSERT INTO mni_vpl VALUES ("MK1_45","071_1_45","MRK","1","45","45","Adubu mahakna chatkhraga pao adu mapham khudingmakta sandokpa houre. Aduga madugi mahei oina, Jisuna phongna saharda changba ngamdre. Adudagi Ibungona mi tadaba achikpa maphamsingda leirammi, adumakpu mapham khudingdagi misingna Ibungogi manakta adumak laklammi. ");
INSERT INTO mni_vpl VALUES ("MK2_1","071_2_1","MRK","2","1","1","Numit kharanigi matungda Jisuna Capernaum-da amuk lakle, amasung Ibungona yumda halakle haibagi pao thuna sandokkhre. ");
INSERT INTO mni_vpl VALUES ("MK2_2","071_2_2","MRK","2","2","2","Adudagi thunamak yamlaba miyam amana mapham aduda tillare madudi mising adu yammankhibana ka adu mina pik thanbadagi thongjin mapal phaobasu leppham leiramde. Aduga Jisuna makhoida Mapu Ibungogi wa sandoklingeida, ");
INSERT INTO mni_vpl VALUES ("MK2_3","071_2_3","MRK","2","3","3","Nupa marina pangthaduna naba mi ama puduna Ibungogi nakta lakle. ");
INSERT INTO mni_vpl VALUES ("MK2_4","071_2_4","MRK","2","4","4","Adubu tilliba mising adu yamankhibana makhoina anaba adubu Ibungogi nakta pusinba ngamdre. Maram aduna makhoina Ibungona leiriba mapadugi yumthak adu huttoktuna phattoklaga pangthaduna naba nupa adubu magi hippham aduga loinana thadaraklammi. ");
INSERT INTO mni_vpl VALUES ("MK2_5","071_2_5","MRK","2","5","5","Amasung Ibungona makhoigi thajaba kayamuk leibage haibadu ubada, pangthaduna naba nupa aduda hairak-i, “Ichanupa, nahakki napapsing kokpire.” ");
INSERT INTO mni_vpl VALUES ("MK2_6","071_2_6","MRK","2","6","6","Mapham aduda phamduna leiriba Wayel Yathanggi Oja kharana mapukningda mathanta khanjarammi, ");
INSERT INTO mni_vpl VALUES ("MK2_7","071_2_7","MRK","2","7","7","“Kari matik leiduna mahakna asumna nganglibano? Masi Mapu Ibungobu thina ngangbani! Pap kokpiba ngambadi Mapu Ibungo mahak khaktani!” ");
INSERT INTO mni_vpl VALUES ("MK2_8","071_2_8","MRK","2","8","8","Khudaktuda makhoina kari khallibano haibadu khangladuna Ibungona makhoida hairak-i, “Nakhoina adumna karigi khallibano? ");
INSERT INTO mni_vpl VALUES ("MK2_9","071_2_9","MRK","2","9","9","Pangthaduna nariba nupa asida, ‘Nahakki napapsing kokpire,’ haibaga, ‘Hougatlu aduga nahakki hipnapham adu loukhattuna chatlu’ haibaga karambana henna laibage? ");
INSERT INTO mni_vpl VALUES ("MK2_10","071_2_10","MRK","2","10","10","Adubu Migi Machanupa aduna taibangpanda pap kokpinaba matik lei haibasi nakhoida utke.” Adudagi Ibungona pangthaduna naba nupa aduda hairak-i, ");
INSERT INTO mni_vpl VALUES ("MK2_11","071_2_11","MRK","2","11","11","“Eina nangonda hairi, hougatlu, aduga nahakki hipnapham adu loukhattuna nayumda chatlu!” ");
INSERT INTO mni_vpl VALUES ("MK2_12","071_2_12","MRK","2","12","12","Adudagi nupa aduna hougattuna mahakki hipnapham adu loukhatlaga makhoi pumnamakki mityeng mamangmaktada thunamak chatkhre. Masina makhoi pumnamakta pungak ngak-hallammi, aduga makhoina Mapu Ibungobu thagattuna hairak-i, “Eikhoina asigumba amata amukta ukhidri!” ");
INSERT INTO mni_vpl VALUES ("MK2_13","071_2_13","MRK","2","13","13","Jisuna Galilee-gi pat mapanda amuk hanna chatlammi. Amasung yamkhraba miyam amana Ibungogi manakta tillare, aduga Ibungona makhoida tambiba houre. ");
INSERT INTO mni_vpl VALUES ("MK2_14","071_2_14","MRK","2","14","14","Aduga Ibungona asum chatlingeida, kanggat khomba, Alphaeus-gi machanupa Levi-na kanggat thiphamda phamduna leiba adu Ibungona urabada mangonda hairak-i, “Eigi itung illu.” Maduda Levi-na hougattuna Ibungogi tung injare. ");
INSERT INTO mni_vpl VALUES ("MK2_15","071_2_15","MRK","2","15","15","Madugi tungda Jisuna Levi-gi yumda numidanggi chaklen charammi. Amasung kanggat khombasing amadi inthokpiraba mi mayam amana Ibungogi tung illammi, aduga makhoina Ibungo amadi Ibunggogi tung-inbasingga loinana chaklen adu chaminnarammi. ");
INSERT INTO mni_vpl VALUES ("MK2_16","071_2_16","MRK","2","16","16","Wayel Yathanggi Oja oiba Pharisee-sing kharana, inthokpiraba amadi kanggat khomba misingga loinana Jisuna chamin thakminnaba adu ubada, makhoina Ibungogi tung-inbasingda hanglak-i, “Karigi mahakna asigumba mising asiga chamin-thakminnaribano?” ");
INSERT INTO mni_vpl VALUES ("MK2_17","071_2_17","MRK","2","17","17","Makhoina hainariba adu tabada Jisuna khumlak-i, “Masa phabasinggidi laiyengba mi mathou tade, adubu anabasinggidi mathou tai. Aduga masana achumba chatpani haina khanjaba mising adubu eina kouba lakpa natte adubu masana pap chelli haina khangjaba mising adubu kouba lakpani.” ");
INSERT INTO mni_vpl VALUES ("MK2_18","071_2_18","MRK","2","18","18","Nongma thoudok amada Baptize toubiba John-gi tung-inbasing amadi Pharisee-singna chara hellammi. Maduda mi kharana Jisugi manakta laklaga hanglak-i, “Baptize toubiba John-gi tung-inbasing amadi Pharisee-singdi chara helli adubu Ibungogi tung-inbasingnadi chara hendriba karigino?” ");
INSERT INTO mni_vpl VALUES ("MK2_19","071_2_19","MRK","2","19","19","Jisuna makhoida khumlak-i, “Luhongbada lakliba bor adugi marupsingna chara hen-gadra? Bor aduna makhoiga hek leiminnaribamakhei makhoina chara khak helloi. ");
INSERT INTO mni_vpl VALUES ("MK2_20","071_2_20","MRK","2","20","20","Adum oinamak makhoidagi bor adu pukhigadaba numit adu lakkani, aduga matam aduda makhoina chara hen-gani. ");
INSERT INTO mni_vpl VALUES ("MK2_21","071_2_21","MRK","2","21","21","“Mi kana amatana ahanba phi machet amabu amanba phida photchinde, maramdi ahanba phi machet aduna chingsinduna segairiba adu hennadum segairakkani. ");
INSERT INTO mni_vpl VALUES ("MK2_22","071_2_22","MRK","2","22","22","Aduga mi kana amatana anouba yubu amanba sawun-gi khaosingda khak hapnade, maramdi yu aduna sawun khaosing adu pokhaihanduna yusu aduga khaosingdusu animak mang-han-gani. Madugi mahutta anouba yudi anouba sawungi khaosingda hapkadabani.” ");
INSERT INTO mni_vpl VALUES ("MK2_23","071_2_23","MRK","2","23","23","Potthaba numit amada Jisuna gehugi loubukta phaoduna chatlammi. Aduga makhoina asum chatlingeida Ibungogi tung-inbasingna gehu charong khara heklammi. ");
INSERT INTO mni_vpl VALUES ("MK2_24","071_2_24","MRK","2","24","24","Maduda Pharisee-singna Jisuda hairak-i, “Yeng-u, potthaba numitta nahakki tung-inbasingna touribasi Wayel Yathanggi maiyoktani.” ");
INSERT INTO mni_vpl VALUES ("MK2_25","071_2_25","MRK","2","25","25","Jisuna makhoida khumlak-i, “David amadi mahakki loinabasingna mabuk lamlabada kari toukhibage haibadu nakhoi padabra? ");
INSERT INTO mni_vpl VALUES ("MK2_26","071_2_26","MRK","2","26","26","Abiathar-na Purohitlen oiringei matamda David-na Mapugi Sanglenda changduna Wayel Yathanggi matung inna purohitsingkhaktana chaba yaba Mapu Ibungoda katpa asengba tal adu mahakna chakhi aduga mahakka loinarakpa misingdasu mahakna tal adu pikhi.” ");
INSERT INTO mni_vpl VALUES ("MK2_27","071_2_27","MRK","2","27","27","Jisuna makha taraduna makhoida hairak-i, “Potthaba numit asi mioibagi phanabagidamak sembibani, adubu mioibadi potthaba numitkidamak semkhiba natte. ");
INSERT INTO mni_vpl VALUES ("MK2_28","071_2_28","MRK","2","28","28","Maram aduna Migi Machanupa adu potthaba numitkisu mapuni.” ");
INSERT INTO mni_vpl VALUES ("MK3_1","071_3_1","MRK","3","1","1","Adudagi Jisuna synagogue-ta amuk hanna changlammi, amasung mapham aduda makhut nama sithaba nupa ama leirammi. ");
INSERT INTO mni_vpl VALUES ("MK3_2","071_3_2","MRK","3","2","2","Aduga Jisubu maral siba pamba mi kharasu mapham aduda leirammi, maram aduna makhoina potthaba numitta anaba nupa adubu Ibungona phahan-gadara haiduna Ibungobu maral sinabagidamak cheksinna yenglammi. ");
INSERT INTO mni_vpl VALUES ("MK3_3","071_3_3","MRK","3","3","3","Maduda Jisuna nupa aduda hairak-i, “Lak-u aduga mayamgi mamangsida leppu.” ");
INSERT INTO mni_vpl VALUES ("MK3_4","071_3_4","MRK","3","4","4","Aduga Ibungona makhoida hanglak-i, “Potthaba numitta kari kari touba yai haina eikhoigi Wayel Yathangna haibage? Migi mateng pangbra nattraga phattaba toubra? Migi thawai kanbra nattraga mang-hanbra?” Adubu makhoina wa amata ngangdana tuminna leirammi. ");
INSERT INTO mni_vpl VALUES ("MK3_5","071_3_5","MRK","3","5","5","Adudagi Jisuna makhoida asaobaga loinana koina yengle, adubu makhoigi thamoi kanba matou aduda Ibungona thamoi sokladuna nupa aduda hairak-i, “Nahakki nakhuttu tingthok-u.” Maduda nupa aduna makhut tingthokle aduga mahakki makhuttu hannagum pungpha phajare. ");
INSERT INTO mni_vpl VALUES ("MK3_6","071_3_6","MRK","3","6","6","Adudagi Pharisee-sing aduna synagogue-tagi chatkhiduna Herod-ki misingga khudaktuda unare aduga Ibungobu karamna hatsige haiduna makhoina wa tanaba houre. ");
INSERT INTO mni_vpl VALUES ("MK3_7","071_3_7","MRK","3","7","7","Jisu amadi mahakki tung-inbasingna Galilee-gi pat mayada chatthoklammi, aduga yamlaba miyam amana Ibungogi tung illammi. Miyamsing adu Galilee, Judea, ");
INSERT INTO mni_vpl VALUES ("MK3_8","071_3_8","MRK","3","8","8","Jerusalem, Idumea, Jordan-gi nongpok thangba maphamsing, aduga Tyre amadi Sidon-gi saharsingdagi lakpani. Ibungona toukhiba angakpa thabaksing adu tabadagi makhoina Ibungogi manakta lakpani. ");
INSERT INTO mni_vpl VALUES ("MK3_9","071_3_9","MRK","3","9","9","Miyam adu yamankhibagi maramna miyamduna mangonda omsindanaba, Ibungona mahakki tung-inbasingda mahakkidamak hi ama thourang tounaba hairammi. ");
INSERT INTO mni_vpl VALUES ("MK3_10","071_3_10","MRK","3","10","10","Numit aduda Ibungona mi mayam amabu anaba phahanbirammi maram aduna atoppa anabasingnasu Ibungobu sokchanaba manglomda insinnaduna changsinaraklammi. ");
INSERT INTO mni_vpl VALUES ("MK3_11","071_3_11","MRK","3","11","11","Phattaba thawai changba misingna Ibungobu uba matamda, Ibungogi mangda tuthaduna kanna laorak-i, “Ibungodi Tengban Mapugi Machanupani!” ");
INSERT INTO mni_vpl VALUES ("MK3_12","071_3_12","MRK","3","12","12","Aduga Jisuna mahaksi kanano haibadu mi kana amatada haidanaba phattaba thawaising aduda akanba yathang pire. ");
INSERT INTO mni_vpl VALUES ("MK3_13","071_3_13","MRK","3","13","13","Adudagi Jisuna chingthakta kakhatlaga mahakna pamba makhoising adubu manakta koure amasung makhoina Ibungogi nakta lakle. ");
INSERT INTO mni_vpl VALUES ("MK3_14","071_3_14","MRK","3","14","14","Aduga Ibungona makhoi taranithoibu khandoklaga pakhonchatpa haiba mingthol piraduna makhoida hairak-i, “Eihakna nakhoibu eihakka loinanaba khandoklabani. Aduga eina nakhoibu Mapu Ibungogi wa sandoknaba thagani, ");
INSERT INTO mni_vpl VALUES ("MK3_15","071_3_15","MRK","3","15","15","amadi anabasingbu phahannaba amasung phattaba laisingbu tanthoknabagi matik nakhoida leigani.” ");
INSERT INTO mni_vpl VALUES ("MK3_16","071_3_16","MRK","3","16","16","Ibungona khandoklaba makhoi taranithoi adudi, Ibungona Peter haina mingthonbiba Simon; ");
INSERT INTO mni_vpl VALUES ("MK3_17","071_3_17","MRK","3","17","17","Zebedee-gi machanupa Jacob amadi John (Jisuna makhoibu Boanerges haina ming thollammi, Boanerges haibagi wahanthokti “Nongkhakpagi machanupasing” haibani); ");
INSERT INTO mni_vpl VALUES ("MK3_18","071_3_18","MRK","3","18","18","Andrew, Philip, Bartholomew, Matthew, Thomas, Alphaeus-gi machanupa Jacob, Thaddaeus, mareibak ningba Simon, ");
INSERT INTO mni_vpl VALUES ("MK3_19","071_3_19","MRK","3","19","19","amasung Ibungobu yeknabasinggi khutta pithokkhiba, Judas Iscariot, hairibasing asini. ");
INSERT INTO mni_vpl VALUES ("MK3_20","071_3_20","MRK","3","20","20","Adudagi Jisuna yum amada changlammi. Aduga yamlaba miyam amana amuk hanna tillarabada Ibungo amadi mahakki tung-inbasingna chananabagi matam phaoba leiramde. ");
INSERT INTO mni_vpl VALUES ("MK3_21","071_3_21","MRK","3","21","21","Pao asi Ibungogi imung manunggi misingna tarabada, makhoina Ibungobu yumda punanaba thoraklammi maramdi makhoina “Mahak ngaore” haina hainarammi. ");
INSERT INTO mni_vpl VALUES ("MK3_22","071_3_22","MRK","3","22","22","Aduga Jerusalem-dagi lakpa Wayel Yathanggi Oja kharana hairak-i, “Mangonda Beelzebul changle! Aduga lai phattabasinggi makok asigi mapanna mahakna lai phattabasingbu tanthok-i.” ");
INSERT INTO mni_vpl VALUES ("MK3_23","071_3_23","MRK","3","23","23","Maduda Jisuna makhoibu manakta kouraga pandamsing piraduna hairak-i, “Satan-na Satan-bu karamna tanthokpa ngamgadage? ");
INSERT INTO mni_vpl VALUES ("MK3_24","071_3_24","MRK","3","24","24","Leibak amana napak-napak tanaduna amaga amaga khatnarabadi, leibak adu kaigani. ");
INSERT INTO mni_vpl VALUES ("MK3_25","071_3_25","MRK","3","25","25","Imung amada tongan tongan tanaduna khatnarabadi, imung adu kaigani. ");
INSERT INTO mni_vpl VALUES ("MK3_26","071_3_26","MRK","3","26","26","Maram aduna Satan-gi leibak adu kanglup naiduna machet tanarabadi madu kuina leptuna leiba ngamloi, adubu mahakki aroiba haibadu oigani. ");
INSERT INTO mni_vpl VALUES ("MK3_27","071_3_27","MRK","3","27","27","“Akanba mi adu hanna punduna thamdrabadi, mi kana amatana mahakki mayumda changduna mapot macheising munduna louba ngamloi. Adubu mahak pullaba matung khaktada mapot macheising adu louba ngamgani. ");
INSERT INTO mni_vpl VALUES ("MK3_28","071_3_28","MRK","3","28","28","“Eina nakhoida tasengnamak hairibasini, mioibana touba pap khudingmak amadi makhoina thina ngangba pumnamak kokpigani. ");
INSERT INTO mni_vpl VALUES ("MK3_29","071_3_29","MRK","3","29","29","Adubu Thawai Asengbagi maiyokta thina ngangba mahakpudi keidoungeidasu kokpiroi maramdi mahakna lomba naidaba pap ama langsillabani.” ");
INSERT INTO mni_vpl VALUES ("MK3_30","071_3_30","MRK","3","30","30","“Mangonda phattaba thawai lei” haina mi kharana haibagi maramna Ibungona masi haibani. ");
INSERT INTO mni_vpl VALUES ("MK3_31","071_3_31","MRK","3","31","31","Madugi matungda Jisugi mama amadi manaosingna Jisuna leiriba yum aduda lakle. Adudagi makhoina mapanda leptuna Ibungobu kouthoknaba mi ama tharammi. ");
INSERT INTO mni_vpl VALUES ("MK3_32","071_3_32","MRK","3","32","32","Maduda Jisugi akoibada phamduna leiriba misingduna Jisuda hairak-i, “Ibungogi ima, nanaosing amadi nachansingna mapanda Ibungobu unanaba leiri.” ");
INSERT INTO mni_vpl VALUES ("MK3_33","071_3_33","MRK","3","33","33","Jisuna khumlak-i, “Eigi ima kanano amadi eigi ichin-inao kanano?” ");
INSERT INTO mni_vpl VALUES ("MK3_34","071_3_34","MRK","3","34","34","Adudagi Ibungona mahakki akoibada phamlibasing aduda yengladuna hairak-i, “Yeng-u! Mapham asida eigi ima amadi eigi ichin-inaosing leire! ");
INSERT INTO mni_vpl VALUES ("MK3_35","071_3_35","MRK","3","35","35","Tengban Mapugi aningba apamba touba mising adu eigi ichil inaoni, eigi iche ichalni amadi eigi imani.” ");
INSERT INTO mni_vpl VALUES ("MK4_1","071_4_1","MRK","4","1","1","Adudagi Jisuna Galilee-gi pat mapanda amuk tambiba hourammi. Maduda Ibungogi akoibada tilliba miyamsingdu yamankhibana Ibungona hi amada kakhattuna phamlammi. Hi adu ipakthakta leirammi aduga miyam aduna pat mapanda leplammi. ");
INSERT INTO mni_vpl VALUES ("MK4_2","071_4_2","MRK","4","2","2","Adudagi Ibungona pandamsing sijinnaduna hiram kaya ama makhoida tambirammi. Ibungona makhoida hairak-i, ");
INSERT INTO mni_vpl VALUES ("MK4_3","071_4_3","MRK","4","3","3","“Tao! Lou-uba amana maru hunba chatlammi. ");
INSERT INTO mni_vpl VALUES ("MK4_4","071_4_4","MRK","4","4","4","Mahakna loubukta maru asum hullakpada, maru kharana lambi mapanda tare aduga ucheksing laktuna marusingdu chathokkhre. ");
INSERT INTO mni_vpl VALUES ("MK4_5","071_4_5","MRK","4","5","5","Aduga kharana leipak kaya leitaba nunglakta tare. Amasung leipak luthana leitabana marusing adu thuna mayol chonglakle. ");
INSERT INTO mni_vpl VALUES ("MK4_6","071_4_6","MRK","4","6","6","Adubu numit thorakpada nungsagi meisana yeibadagi pambisingdu thuna kangsilhalle, maramdi pambisingdu mara luna taramde. ");
INSERT INTO mni_vpl VALUES ("MK4_7","071_4_7","MRK","4","7","7","Aduga kharana tingkhangsinggi marakta tare, amasung tingkhangsingduna chaokhatlaktuna pambisingdu namhatle aduga pambisingdu mahei yanba ngamdre. ");
INSERT INTO mni_vpl VALUES ("MK4_8","071_4_8","MRK","4","8","8","Adubu maru kharadi aphaba leihao chenba maphamda tare aduga mayol chonglaktuna chaokhatlaklaga mahei yamna yalle, madudi kharana kunthra, kharana humphu aduga khara amana chama yalle.” ");
INSERT INTO mni_vpl VALUES ("MK4_9","071_4_9","MRK","4","9","9","Adudagi Jisuna makhoida hairak-i, “Tananaba nakong panba mahak aduna tasanu!” ");
INSERT INTO mni_vpl VALUES ("MK4_10","071_4_10","MRK","4","10","10","Adudagi miyam adu chatkhiduna Ibungokhakta ngaihouraba matamda, tung-inba taranithoi amadi mahakki akoibada phamlibasing aduna pandamsing adu sandokna takpinaba Ibungoda haijarammi. ");
INSERT INTO mni_vpl VALUES ("MK4_11","071_4_11","MRK","4","11","11","Jisuna makhoida hairak-i, “Tengban Mapugi Leibakki athuppa adu nakhoida khang-hanbire. Adubu mapanda leiba makhoidadi eina pumnamak pandam oina hai. ");
INSERT INTO mni_vpl VALUES ("MK4_12","071_4_12","MRK","4","12","12","Maramdi Mapugi Puyagi wa asi thungnanabani, ‘Makhoina hanna hanna yenggani, adubu khangloi; makhoina hanna hanna tagani, adubu wakhal taba ngamloi. Maramdi makhoina khanglamlaba aduga wakhal taramlaba, makhoina Mapu Ibungoda hallaklamgadabani, aduga Mapu Ibungona makhoibu kokpiramgadabani.’ ” ");
INSERT INTO mni_vpl VALUES ("MK4_13","071_4_13","MRK","4","13","13","Adudagi Jisuna makhoida hanglak-i, “Pandam asi nakhoina khangba ngamdabra? Adu oirabadi kamdouna nakhoina atei pandamsing khangba ngamgadage? ");
INSERT INTO mni_vpl VALUES ("MK4_14","071_4_14","MRK","4","14","14","Maru hunba mi aduna hullibadu Mapu Ibungogi waheini. ");
INSERT INTO mni_vpl VALUES ("MK4_15","071_4_15","MRK","4","15","15","Mi kharadi lambi mapanda taba marusing aduga mannei. Madudi makhoina Mapu Ibungogi waheidu hek tabaga, Satan-na laktuna makhoida hunkhraba Mapu Ibungogi waheidu makhoidagi louthokkhi. ");
INSERT INTO mni_vpl VALUES ("MK4_16","071_4_16","MRK","4","16","16","Aduga mi kharana nunglakta taba marusingduga manei. Makhoina Mapu Ibungogi wahei adu hek tabaga haraona lousilli. ");
INSERT INTO mni_vpl VALUES ("MK4_17","071_4_17","MRK","4","17","17","Adum oinamak makhoina mara phajana tadaba maramna kuina khaangde. Maram aduna Mapu Ibungogi waheigi maramgidamak makhoida awa-ana amadi ot-neiba lakpa matamda makhoigi thajaba adu thuna thadokkhi. ");
INSERT INTO mni_vpl VALUES ("MK4_18","071_4_18","MRK","4","18","18","Aduga mi kharadi tingkhang marakta hunkhiba marusing aduga manei. Makhoina Mapu Ibungogi wahei tare, ");
INSERT INTO mni_vpl VALUES ("MK4_19","071_4_19","MRK","4","19","19","adubu taibangpan punsi asigi langtaknaba, lanthumgi oiba nungaibagi lounam amadi makhal kayagi apambasingna makhoida changkhiduna Mapu Ibungogi wahei adu namhatkhi aduga mahei yalhande. ");
INSERT INTO mni_vpl VALUES ("MK4_20","071_4_20","MRK","4","20","20","Adubu mi kharadi aphaba leihao chenba maphamda hunba marusingga manei. Makhoina Mapu Ibungogi wahei adu tai amadi wahei adubu lousinjei, aduga mahei yalli madudi kharana kunthra, kharana humphu aduga khara amana chama mahei yalli.” ");
INSERT INTO mni_vpl VALUES ("MK4_21","071_4_21","MRK","4","21","21","Jisuna makhoida makha taraduna hairak-i, “Kanana thaomeibu thumok makhada nattraga kangkha makhada thamnabage? Thaomeidi thaomei makhong mathakta thamnaba nattra? ");
INSERT INTO mni_vpl VALUES ("MK4_22","071_4_22","MRK","4","22","22","Maramdi phongdokloidaba arotpa karisu leite aduga khangloidaba aronba karisu leite. ");
INSERT INTO mni_vpl VALUES ("MK4_23","071_4_23","MRK","4","23","23","Aduna manakong panba mahak aduna tasanu!” ");
INSERT INTO mni_vpl VALUES ("MK4_24","071_4_24","MRK","4","24","24","Ibungona makhoida makha tana asisu hairak-i, “Nakhoina tariba aduda ningthijana wakhal tou! Nakhoina olliba chang adumak Mapu Ibungona nakhoidasu onbirakkani amasung hennadum onbirakkani. ");
INSERT INTO mni_vpl VALUES ("MK4_25","071_4_25","MRK","4","25","25","Areiba mahak aduda henna pibigani, aduga leitaba mahak adudagi mahakki leijaba adu phaoba louthokkani.” ");
INSERT INTO mni_vpl VALUES ("MK4_26","071_4_26","MRK","4","26","26","Jisuna asisu hairak-i, “Mapu Ibungogi leibak adu mi amana mahakki loubukta maru hunbagumbani. ");
INSERT INTO mni_vpl VALUES ("MK4_27","071_4_27","MRK","4","27","27","Mahakna tumlabasu hougatlabasu, ahing nungthil animakta marusing adu mayol chongduna hourak-i. Mahaknadi madu kamdouna oiraklibano haibadudi khangde. ");
INSERT INTO mni_vpl VALUES ("MK4_28","071_4_28","MRK","4","28","28","Leipak masana adumak pambisingdu chaokhat-handuna mahei yalhalli; ahanbada mayol, mathangda charong, aduga akonbada pambi aduda mapung phana mahei yalhalli. ");
INSERT INTO mni_vpl VALUES ("MK4_29","071_4_29","MRK","4","29","29","Mahei aduna mullabada mahakna thanggol thaduna lok-i, maramdi lourok tha adu lakle.” ");
INSERT INTO mni_vpl VALUES ("MK4_30","071_4_30","MRK","4","30","30","Jisuna amuksu hairak-i, “Tengban Mapugi leibak adu eikhoina kariga changdamnagadage? Masibu sandokna taknaba eikhoina kari pandam sijinnagani? ");
INSERT INTO mni_vpl VALUES ("MK4_31","071_4_31","MRK","4","31","31","Masi marusinggi marakta khwaidagi pikpa maru oiriba hanggam maru amabu, mi amana louraga leipakta thabagumbani. ");
INSERT INTO mni_vpl VALUES ("MK4_32","071_4_32","MRK","4","32","32","Adubu thakhraba matung khara leiraga madu chaokhatlak-i, aduga ingkholgi mana-masing pumnakki manungda khwaidagi chaoba pambi oirak-i. Maduna achouba masa longthorak-i aduga ucheksingna madugi marumda mahum sai.” ");
INSERT INTO mni_vpl VALUES ("MK4_33","071_4_33","MRK","4","33","33","Asigumba atoppa pandam kaya amasu sijinnaduna Jisuna misingda makhoina khangba ngamba chang adu phaoba tambirammi. ");
INSERT INTO mni_vpl VALUES ("MK4_34","071_4_34","MRK","4","34","34","Ibungona makhoida pandam sijinnadana keidounungda tambiramde, adum oinamak Ibungona mahakki tung-inbasing khaktaga tonganna leiba matamda, Ibungona makhoida pumnamak sandokna takpirammi. ");
INSERT INTO mni_vpl VALUES ("MK4_35","071_4_35","MRK","4","35","35","Numit adumakki numidangwairamda Jisuna mahakki tung-inbasingda hairak-i, “Eikhoi pat asigi wangmada chatsi.” ");
INSERT INTO mni_vpl VALUES ("MK4_36","071_4_36","MRK","4","36","36","Adudagi Ibungogi tung-inbasing aduna miyam adubu thanamlaga, Jisuna phamliba hi aduda tongkhattuna makhoina Jisubu puduna chatle. Mapham aduda hi mayam amasu leirammi. ");
INSERT INTO mni_vpl VALUES ("MK4_37","071_4_37","MRK","4","37","37","Adudagi ikhang khang-houdana akanba nonglei nungsit ama lakle. Aduga ithak-ipomna hida yeibadagi hinungda ising hajillaktuna hidu isingna than-gadourammi. ");
INSERT INTO mni_vpl VALUES ("MK4_38","071_4_38","MRK","4","38","38","Adubu Jisudi hirubakta mon khangduna tumduna leirammi. Maduda Ibungogi tung-inbasingna Ibungobu houdoktuna hairak-i, “Oja Ibungo, eikhoi sigadoure haibasi Ibungona kari amata khanbidrabra?” ");
INSERT INTO mni_vpl VALUES ("MK4_39","071_4_39","MRK","4","39","39","Adudagi Jisuna hougatlaktuna nungsit aduda yathang pirak-i, “Tuminna leiyu!” aduga mahakna ithaksing aduda hairak-i, “Tapthou!” Adudagi nungsit adu lepkhre aduga pumnamak pumtap tapthakhre. ");
INSERT INTO mni_vpl VALUES ("MK4_40","071_4_40","MRK","4","40","40","Maduda Jisuna makhoida hairak-i, “Nakhoina aduk kiriba karigino? Nakhoida houjik phaoba thajaba leitribra?” ");
INSERT INTO mni_vpl VALUES ("MK4_41","071_4_41","MRK","4","41","41","Maduda makhoi yamna kirammi aduga makhoi masel amaga amaga hainarak-i, “Nungsit amadi ithaksing phaobana haiba illiba mahak asibu kanano?” ");
INSERT INTO mni_vpl VALUES ("MK5_1","071_5_1","MRK","5","1","1","Adudagi Jisu amadi mahakki tung-inbasingna Galilee patki wangmada leiba Gerasa-gi lamda thunglammi. ");
INSERT INTO mni_vpl VALUES ("MK5_2","071_5_2","MRK","5","2","2","Amasung Jisuna hidagi hek kumthabaga, phattaba thawai changba mi amana mongpham maraktagi Ibungobu unanaba thoraklammi. ");
INSERT INTO mni_vpl VALUES ("MK5_3","071_5_3","MRK","5","3","3","Nupa adu mongpham marakta leibani. Aduga kana amatana mahakpu amuk hanna yotlina punduna thamba ngamdre. ");
INSERT INTO mni_vpl VALUES ("MK5_4","071_5_4","MRK","5","4","4","Makhoina mahakki makhong makhut adu kayarak hanna pullurabani adubu mahakpu hek punba khudingmakta mahakna yotli adu thadatli amasung yotling phalang adubu matek matek thudek-i. Mahak yamna kanba maramna kanamatana mahakpu phajinba ngamlamde. ");
INSERT INTO mni_vpl VALUES ("MK5_5","071_5_5","MRK","5","5","5","Ahing nungthil animak mahakna mongpham marakta amadi chingda koichat chattuna koirao laoraga masa mathantabu nungna sudatcharammi. ");
INSERT INTO mni_vpl VALUES ("MK5_6","071_5_6","MRK","5","6","6","Jisuna lapna leiringeida mahakna Jisubu urammi aduga mahakna chellaktuna Ibungogi mangda khuru khudak kunduna tuthajarammi. ");
INSERT INTO mni_vpl VALUES ("MK5_7","071_5_7","MRK","5","7","7","Amasung mahakna ahouba khonjelda laoraduna hairak-i, “He Jisu, khwaidagi wangthoiraba Mapu Ibungogi Machanupa! Nangna eingonda kari touba pambage? Eina Mapu Ibungo panduna haijari, eibu ot-neiduna cheirak pibiganu!” ");
INSERT INTO mni_vpl VALUES ("MK5_8","071_5_8","MRK","5","8","8","(Mahakna masi haibagi maramdi Jisuna, “Phattaba thawai, mi asidagi thokkhro!” haina hanna haikhibagini.) ");
INSERT INTO mni_vpl VALUES ("MK5_9","071_5_9","MRK","5","9","9","Maduda Jisuna mangonda hanglak-i, “Naming kari kou-i?” Mahakna khumlak-i, “Eigi mingdi ‘Tenggol’ kou-i, maramdi eikhoi yammi!” ");
INSERT INTO mni_vpl VALUES ("MK5_10","071_5_10","MRK","5","10","10","Aduga mahakna Jisuda makhoibu mapham adudagi tanthokpidanaba hanjin hanjin haijarammi. ");
INSERT INTO mni_vpl VALUES ("MK5_11","071_5_11","MRK","5","11","11","Matam aduda manak nakpa ching-ya amada ok sanggu ama machinjak chaduna leirammi. ");
INSERT INTO mni_vpl VALUES ("MK5_12","071_5_12","MRK","5","12","12","Maram aduna phattaba thawaising aduna Jisuda nonjaduna haijarak-i, “Eikhoibu oksing asida thabiduna makhoida chang-hanbiyu.” ");
INSERT INTO mni_vpl VALUES ("MK5_13","071_5_13","MRK","5","13","13","Adudagi Ibungona makhoida ayaba adu pire, amasung phattaba thawaisingduna mi adudagi thokkhraga oksing aduda changkhre. Chaorakna masing lising animuk oiba ok sanggu adu angamba adudagi pat tamna thuna chenthakhiduna pat aduda iraknaduna sire. ");
INSERT INTO mni_vpl VALUES ("MK5_14","071_5_14","MRK","5","14","14","Maduda ok sellambasing aduna chenkhiduna saharduda amadi khunsingda thoudok adugi paodu sandokle. Adudagi misingna thokkhiba thoudok adu yengnanabagidamak mapham aduda laklammi. ");
INSERT INTO mni_vpl VALUES ("MK5_15","071_5_15","MRK","5","15","15","Amasung makhoina Jisugi nakta lakpada, phattaba thawai tenggol changlamba nupa aduna maphamduda maphi marol ningthina settuna amadi wakhal tana phambadu ubada makhoi loina kire. ");
INSERT INTO mni_vpl VALUES ("MK5_16","071_5_16","MRK","5","16","16","Aduga phattaba thawaising changlamba nupa amasung oksing aduda kari thokkhibage haibadu uhoubasingna makhoida tamle. ");
INSERT INTO mni_vpl VALUES ("MK5_17","071_5_17","MRK","5","17","17","Maram aduna Jisubu makhoigi lam adu thadoktuna chatpikhinaba makhoina Jisuda haijare. ");
INSERT INTO mni_vpl VALUES ("MK5_18","071_5_18","MRK","5","18","18","Aduga Jisuna hida kakhatpa matamda phattaba thawaising changlamba nupa aduna Jisuda nonjaduna haijarak-i, “Eisu Ibungoga loinana chatchage!” ");
INSERT INTO mni_vpl VALUES ("MK5_19","071_5_19","MRK","5","19","19","Adubu madu Jisuna yakhide. Amasung Ibungona mangonda hairak-i, “Nahakna nayumda amasung nahakki oiba mising adugi manakta handuna Mapu Ibungona nahakkidamak kayada chaoba thabak toubikhiba amadi nahakpu kayagi matik nungsibiba haibadu makhoida tamlu.” ");
INSERT INTO mni_vpl VALUES ("MK5_20","071_5_20","MRK","5","20","20","Maduda mahakna chatkhiduna Decapolis haina khangnaba Sahar Tara adugi mapham khudingda Jisuna mangonda toubikhibasing adu sandokpa hourammi. Amasung madu taba mi pumnamakna ngaklammi. ");
INSERT INTO mni_vpl VALUES ("MK5_21","071_5_21","MRK","5","21","21","Adudagi Jisuna patki wangmada amuk hallakle. Aduga yamlaba miyam amana Ibungogi akoibada tillare. ");
INSERT INTO mni_vpl VALUES ("MK5_22","071_5_22","MRK","5","22","22","Adudagi Jairus kouba synagogue-ki luchingba amana mapham aduda lakle, aduga mahakna Jisubu ubaga Jisugi khuyakhada tuthajaduna, ");
INSERT INTO mni_vpl VALUES ("MK5_23","071_5_23","MRK","5","23","23","yamna nollukna haijarak-i, “Eigi piklibi ichanupi sigadabagi phibhamda yamna kanna nare. Mahakna naba phajaduna hingjananaba, Ibungona lakpiduna mahakki mathakta Ibungogi khut thambiyu.” ");
INSERT INTO mni_vpl VALUES ("MK5_24","071_5_24","MRK","5","24","24","Maduda Jisuna Jairus-ka loinana chatminnare. Amasung yamlaba miyam amana Ibungogi matung illammi aduga makhoina Ibungogi akoibada krik-krik innaduna chatlammi. ");
INSERT INTO mni_vpl VALUES ("MK5_25","071_5_25","MRK","5","25","25","Mapham aduda chahi taranithoi chupna ee taduna naraklabi nupi ama leirammi. ");
INSERT INTO mni_vpl VALUES ("MK5_26","071_5_26","MRK","5","26","26","Mahakna layengba mi kaya amada yengduna awaba kaya khangkhre aduga mahakki areiba sel pumbasu sijinnakhre, adubu phagatlakpagi mahutta anaba henna henjillammi. ");
INSERT INTO mni_vpl VALUES ("MK5_27","071_5_27","MRK","5","27","28","Mahakna Jisugi maramda taraduna miyam marakta Ibungogi tunglomda laklaga mahak masa mathanta “Eina Ibungogi phi asi sokta sokcharabadi, ei naba phajagani” haina mapukningda khanjabaga loinana Ibungogi phida sokcharammi. ");
INSERT INTO mni_vpl VALUES ("MK5_29","071_5_29","MRK","5","29","29","Mahakna Ibungogi phi adu hek sokchabaga, khudak aduda mahakki ee tarambadu lepkhre; amasung mahak masana masada leiba anaba adu phajare haibadu khangjakhi. ");
INSERT INTO mni_vpl VALUES ("MK5_30","071_5_30","MRK","5","30","30","Maduda Jisuna mangondagi panggal thokkhre haibadu khudak aduda khangladuna, miyam aduda onsillaktuna hanglak-i, “Kanana eigi phi sokkhibage?” ");
INSERT INTO mni_vpl VALUES ("MK5_31","071_5_31","MRK","5","31","31","Ibungogi tung-inbasingna khumlak-i, “Yengbiyu, miyamsing asina Ibungogi akoibada krik-krik innaduna leiri; aduga ‘Kanana eibu sokkhibage?’ haina karigi Ibungona hangbiribano?” ");
INSERT INTO mni_vpl VALUES ("MK5_32","071_5_32","MRK","5","32","32","Adubu mangonda sokkhibi nupi adubu unanaba Ibungona koina yenglammi. ");
INSERT INTO mni_vpl VALUES ("MK5_33","071_5_33","MRK","5","33","33","Nupi aduna mangonda kari thokkhibage haibadu khanglabada kibana masadu niklammi amasung mahakna laktuna Ibungogi khuyakhada tuthajaraga thokkhiba thoudok pumnamak Ibungoda tamjare. ");
INSERT INTO mni_vpl VALUES ("MK5_34","071_5_34","MRK","5","34","34","Maduda Jisuna mangonda hairak-i, “Ichanupi, nanggi thajabana nahakpu phahanbire. Ingthana chatlo, aduga nahakki laina adudagi phajaro!” ");
INSERT INTO mni_vpl VALUES ("MK5_35","071_5_35","MRK","5","35","35","Jisuna masi hairingeida synagogue-ki luchingba Jairus-ki yumdagi mi khara laklaga mangonda hairak-i, “Nahakki nachanupi sire. Oja Ibungobu amuk wahallubagi kari kanagani?” ");
INSERT INTO mni_vpl VALUES ("MK5_36","071_5_36","MRK","5","36","36","Makhoina haibadu hek tabaga karisu thousaba toudana Ibungona Jairus-ta hairak-i, “Kiganu, thada thajou.” ");
INSERT INTO mni_vpl VALUES ("MK5_37","071_5_37","MRK","5","37","37","Adudagi Peter, Jacob amadi mahakki manao John nattana atei kana amatabu mahakka loinana chatminnaba Ibungona yadre. ");
INSERT INTO mni_vpl VALUES ("MK5_38","071_5_38","MRK","5","38","38","Amasung makhoina Jairus-ki yumda lakle aduga mapham aduda irang langba, kappa laoba amadi tengtha nawoiba Ibungona ure. ");
INSERT INTO mni_vpl VALUES ("MK5_39","071_5_39","MRK","5","39","39","Adudagi Ibungona changsinduna makhoida hairak-i, “Karigi nakhoina irang langduna kapna-laonaribano? Angang asi siba natte, mahak tumlibani!” ");
INSERT INTO mni_vpl VALUES ("MK5_40","071_5_40","MRK","5","40","40","Maduda makhoina Ibungoda karemnaduna noknarammi. Adubu Ibungona makhoi pumnamak mapanda thok-hankhraga, angangdugi mama mapa amadi Ibungogi tung-inba ahumduga loinana, angangduna hipliba ka aduda changle. ");
INSERT INTO mni_vpl VALUES ("MK5_41","071_5_41","MRK","5","41","41","Aduga Ibungona angang adugi khut pairaduna hairak-i, “Talitha kumi!” haibagi wahanthokti, “Nupimacha, eina nangonda hairi, hougatlu!” ");
INSERT INTO mni_vpl VALUES ("MK5_42","071_5_42","MRK","5","42","42","Khudaktuda nupimachadu hougattuna koichat chatle. (Mahak chahi taranithoi surabini.) Maduda makhoi yamna ngaklammi. ");
INSERT INTO mni_vpl VALUES ("MK5_43","071_5_43","MRK","5","43","43","Adubu Ibungona makhoida kana amatada haidoktanaba akanba yathang pirammi, aduga mahakna makhoida hairak-i, “Nupimacha aduda chanaba khara piyu.” ");
INSERT INTO mni_vpl VALUES ("MK6_1","071_6_1","MRK","6","1","1","Jisuna mapham adu thadoklaga mahakki tung-inbasingga loinana masagi khunda amuk hallakle. ");
INSERT INTO mni_vpl VALUES ("MK6_2","071_6_2","MRK","6","2","2","Aduga Ibungona potthaba numitta synagogue-ta tambiba houre. Amasung mi mayam amana Ibungogi tambiba adu tabada ngakladuna hairak-i, “Mahakna pumnamaksing asi kamdouna touba ngamlibano? Asigumba angakpa thabaksing asi tounanaba lousing amadi panggal asi mahakna kadaidagi phanglibano? ");
INSERT INTO mni_vpl VALUES ("MK6_3","071_6_3","MRK","6","3","3","Mahak asi u-suba midu nattra? Mahak Mary-gi machanupa, aduga Jacob, Joseph, Judas amadi Simon-gi mayambadu nattra? Aduga mahakki machansing adu eikhoiga leiminnaba nattra?” Asumna makhoina Ibungobu yadre. ");
INSERT INTO mni_vpl VALUES ("MK6_4","071_6_4","MRK","6","4","4","Adudagi Jisuna makhoida hairak-i, “Mapu Ibungogi wa phongdokpa maichousingbu makhoigi maramdam, imung manung amadi mari-matasingna ikai khumnabidaba khak nattana mapham khudingmakta ikai khumnei.” ");
INSERT INTO mni_vpl VALUES ("MK6_5","071_6_5","MRK","6","5","5","Aduga makhoina thajadaba adugi maramna Ibungona anaba mi kharagi mathakta khut thambiraga phahanbibakhak nattana atei angakpa thabak amata touba ngamdre. ");
INSERT INTO mni_vpl VALUES ("MK6_6","071_6_6","MRK","6","6","6","Amasung makhoigi thajaba leitaba aduda Ibungona yamna ngaklammi. Adudagi Jisuna thangnaba khun khunsingda chattuna misingbu tambirammi. ");
INSERT INTO mni_vpl VALUES ("MK6_7","071_6_7","MRK","6","7","7","Aduga Ibungona mahakki tung-inba taranithoibu manakta koure. Amasung Ibungona makhoida phattaba thawaisingbu ngamnaba matik pibire aduga makhoi ani ani semduna thare. ");
INSERT INTO mni_vpl VALUES ("MK6_8","071_6_8","MRK","6","8","8","Amasung makhoina chatpa matamda cheisu nattana chananaba pot, punanaba khao, senggaoda sel amadi atei kari amata pudanaba yathang pirammi. ");
INSERT INTO mni_vpl VALUES ("MK6_9","071_6_9","MRK","6","9","9","Makhoina sandal tongbadi yarammi adubu ahenba phurit pubadi yaramde. ");
INSERT INTO mni_vpl VALUES ("MK6_10","071_6_10","MRK","6","10","10","Aduga Ibungona makhoida asisu hairammi, “Nakhoibu taramna okliba yum aduda, maphamdu thadoktriba phaoba nakhoina lengdana leiyu. ");
INSERT INTO mni_vpl VALUES ("MK6_11","071_6_11","MRK","6","11","11","Karigumba mapham amagi misingna nakhoibu taramna oktraba nattraga nakhoina haiba tadraba nakhoigi khongyagi uphuldu kanthoklamlaga mapham adu thadok-tuna chatlu. Maduna makhoida cheksin wa oinabani.” ");
INSERT INTO mni_vpl VALUES ("MK6_12","071_6_12","MRK","6","12","12","Adudagi Ibungogi tung-inbasing aduna chatkhiduna, misingna paptagi pukning hongduna Mapu Ibungoda hallaknaba pao sandoklammi. ");
INSERT INTO mni_vpl VALUES ("MK6_13","071_6_13","MRK","6","13","13","Makhoina phattaba thawai kaya tanthoklammi aduga anabasingbu thao teibiduna anaba phahanbirammi. ");
INSERT INTO mni_vpl VALUES ("MK6_14","071_6_14","MRK","6","14","14","Adudagi Herod ningthouna Jisugi maramda tare, maramdi Jisugi ming mapham khudingda sandokkhre. Mi kharana hairammi, “Baptize toubiba John amuk hinggatle! Maram aduna mangonda angakpasing toubagi panggal asi leiribani.” ");
INSERT INTO mni_vpl VALUES ("MK6_15","071_6_15","MRK","6","15","15","Adubu mi kharana amuk hai, “Mahaksi Elijah-ni.” Aduga atoppa kharanasu amuk hai, “Mahak mamangngeigi Mapu Ibungogi wa phongdokpa matik leiba maichousinggumba maichou amani.” ");
INSERT INTO mni_vpl VALUES ("MK6_16","071_6_16","MRK","6","16","16","Madu tabada Herod-na hairak-i, “Mahaksi Baptize toubiba John-ni! Eina mahakpu mangak kaktuna hatkhrabani, adubu mahak amuk hinggatle!” ");
INSERT INTO mni_vpl VALUES ("MK6_17","071_6_17","MRK","6","17","17","Maramdi Herod masamakna yathang piduna John-bu pharaga keisumsangda punduna thamkhi. Mahakna madu Herodias masunglanggidamak toukhibani. Herodias asi Herod masamakki manao nupa Philip-ki nupi oijarabasu mahakna luhongduna lourammi. ");
INSERT INTO mni_vpl VALUES ("MK6_18","071_6_18","MRK","6","18","18","Maduda Baptize toubiba John-na Herod-ta hanjin hanjin haikhi, “Nahakki nanao nupagi nupibu nahakna louba haibasi wayel yathang kai!” ");
INSERT INTO mni_vpl VALUES ("MK6_19","071_6_19","MRK","6","19","19","Maram aduna Herodias-na John-bu malom thamduna singkhi aduga mahakpu hatpa pamkhi. Adum oinamak Herod-na maram oiduna mahakna hatpa ngamlamde. ");
INSERT INTO mni_vpl VALUES ("MK6_20","071_6_20","MRK","6","20","20","Maramdi Herod-na John asi achumba chatpa amadi asengba mi amani khangduna ikai khumnarammi amasung mahakpu ngakthoklammi. Amasung John-na ngangba taba khudingda mahakna kari tougadage haipham khangdabagi awaba leirabasu, John-na ngangbadi mahak adumak taba pamlammi. ");
INSERT INTO mni_vpl VALUES ("MK6_21","071_6_21","MRK","6","21","21","Mameithangda Herodias-ki khudong chaba adu phangle. Herod-na mahakki mapok numitta mahakki phamnaibasing, lanmigi makoksing amadi Galilee-gi masak naiba misinggidamak chaklen ama langle. ");
INSERT INTO mni_vpl VALUES ("MK6_22","071_6_22","MRK","6","22","22","Amasung Herodias-ki machanupina changlaktuna Herod amadi tilliba miyamgidamak jagoi sarammi. Aduga mahakna makhoi pumnamakpu yamna pelhallammi. Maram aduna ningthouna leisabi macha aduda hairak-i, “Nahakna apamba ama nijou madu eina nangonda pigani.” ");
INSERT INTO mni_vpl VALUES ("MK6_23","071_6_23","MRK","6","23","23","Mahakna mangonda wasaktuna hairak-i, “Eina wasakli, nahakna niningba ama nijabada eina madu pibigani, eigi leibak tangkhai ama oirabasu eina pigani.” ");
INSERT INTO mni_vpl VALUES ("MK6_24","071_6_24","MRK","6","24","24","Adudagi leisabi macha aduna mamada changsinduna hangle, “Eina kari nijouge?” Maduda mamana khumlak-i, “Baptize toubiba John-gi makok niyu.” ");
INSERT INTO mni_vpl VALUES ("MK6_25","071_6_25","MRK","6","25","25","Aduga leisabi macha aduna thuna ningthougi manakta changlaga hairak-i, “Baptize toubiba John-gi makok adu houjikmak sempak amada haptuna eingonda pibiyu.” ");
INSERT INTO mni_vpl VALUES ("MK6_26","071_6_26","MRK","6","26","26","Madu tabada Herod ningthou thawai yamna warammi, adum oinamak mahakna mayam mamangda sakkhiba wasak aduna mahakna yaroi haiba ngamlamde. ");
INSERT INTO mni_vpl VALUES ("MK6_27","071_6_27","MRK","6","27","27","Maram aduna mahakna lanmigi sanglingba amada John-gi makok kaktuna puraknaba yathang pire. Adudagi lanmigi sanglingba aduna keisumsangda chatkhraga John-gi makok kakle; ");
INSERT INTO mni_vpl VALUES ("MK6_28","071_6_28","MRK","6","28","28","Amasung mahakna John-gi makok adu sempak amada haplaga leisabi macha aduda pire, aduga leisabi macha aduna madu mamada amuk pirammi. ");
INSERT INTO mni_vpl VALUES ("MK6_29","071_6_29","MRK","6","29","29","Adudagi John-gi tung-inbasingna pao adu tarabada makhoina laktuna John-gi hakchang adu louraga mongphamda leirol challe. ");
INSERT INTO mni_vpl VALUES ("MK6_30","071_6_30","MRK","6","30","30","Pakhonchatpasing aduna Jisugi manakta laklaga makhoina touruba amadi makhoina tambirubasing adu Ibungoda tamlammi. ");
INSERT INTO mni_vpl VALUES ("MK6_31","071_6_31","MRK","6","31","31","Mapham aduda yamkhraba miyamna lakthok laksin touba maramna, Jisu amadi mahakki tung-inbasingna chak chanaba matam phaoba phanglamde. Maram aduna Jisuna makhoida hairak-i, “Eikhoina ngaihak pottharunaba mi tadaba achikpa mapham amada eikhoi chatsi.” ");
INSERT INTO mni_vpl VALUES ("MK6_32","071_6_32","MRK","6","32","32","Maram aduna makhoina hi amada tongduna achikpa mapham amada chatlammi. ");
INSERT INTO mni_vpl VALUES ("MK6_33","071_6_33","MRK","6","33","33","Adumakpu miyam amana makhoina chatpa adu urammi amasung khudakta makhoibu sak khanglammi. Maram aduna khun pumnamaktagi misingna kangphalda khongna mang thana chenkhiduna Jisu amadi mahakki tung-inbasingdagi makhoina hanna mapham aduda thungle. ");
INSERT INTO mni_vpl VALUES ("MK6_34","071_6_34","MRK","6","34","34","Aduga Jisuna hidagi hek kumtharakpaga yamlaba miyam adu ure, aduga Ibungogi thammoida makhoibu nungsiba pokle maramdi makhoisingdu yaosenba leitraba yaosinggum oirammi. Maram aduna Ibungona makhoida hiram kaya tambiba houre. ");
INSERT INTO mni_vpl VALUES ("MK6_35","071_6_35","MRK","6","35","35","Amasung numidangwairam oiraklabada Ibungogi tung-inbasingna Ibungoda laklaga hairak-i, “Matam asi thengjinkhre, aduga mapham asisu mi tadaba lamni. ");
INSERT INTO mni_vpl VALUES ("MK6_36","071_6_36","MRK","6","36","36","Miyam asina akoiba maphamsing amadi manak nakpa khunsingda chattuna makhoi makhoigi chananaba karigumba khara leijarunaba thabikhro.” ");
INSERT INTO mni_vpl VALUES ("MK6_37","071_6_37","MRK","6","37","37","Jisuna khumlak-i, “Nakhoina makhoida chanaba piyu.” Maduda makhoina Ibungoda hairak-i, “Eikhoina chattuna makhoina chananabagidamak dinari chanigi tal leirugadra?” ");
INSERT INTO mni_vpl VALUES ("MK6_38","071_6_38","MRK","6","38","38","Maduda Jisuna makhoida hanglak-i, “Nakhoida tal kaya yaoribage haibadu chattuna yenglu!” Makhoina madu khangdoklaga Ibungoda hairak-i, “Tal manga-ga nga aniga yaori.” ");
INSERT INTO mni_vpl VALUES ("MK6_39","071_6_39","MRK","6","39","39","Maduda Jisuna misingdu kangbu kangbu semlaga asangba napi mathakta phamhannaba mahakki tung-inbasingda hairammi. ");
INSERT INTO mni_vpl VALUES ("MK6_40","071_6_40","MRK","6","40","40","Maram aduna mising adu chamagi kangbu amadi yangkheigi kangbu semduna pareng naina phamthare. ");
INSERT INTO mni_vpl VALUES ("MK6_41","071_6_41","MRK","6","41","41","Adudagi Jisuna tal manga amadi nga anidu louraga swargaromda yengkhattuna Mapu Ibungobu thagatchare. Adudagi Ibungona talsingdu segaire aduga miyamsingduda yenthoknaba mahakki tung-inbasingda pire. Aduga Ibungona nga anidusu makhoi pumnamak aduda yenthokle. ");
INSERT INTO mni_vpl VALUES ("MK6_42","071_6_42","MRK","6","42","42","Amasung makhoi pumnamakna mabuk thanna chare. ");
INSERT INTO mni_vpl VALUES ("MK6_43","071_6_43","MRK","6","43","43","Adudagi Ibungogi tung-inbasingna lemhouba tal amasung nga machetsing adu thumok taranithoi thanna khomgatle. ");
INSERT INTO mni_vpl VALUES ("MK6_44","071_6_44","MRK","6","44","44","Maduda chaba yaokhiba nupasinggi masingdu lising manga oirammi. ");
INSERT INTO mni_vpl VALUES ("MK6_45","071_6_45","MRK","6","45","45","Jisuna miyamdu thadoklingeida, mahakki tung-inbasingbu khudak aduda hida tong-hallaga mahakki mang thana pat adugi wangmada leiba Bethsaida-da thare. ");
INSERT INTO mni_vpl VALUES ("MK6_46","071_6_46","MRK","6","46","46","Adudagi miyamdu thadokkhraba matungda Ibungona haijanabagidamak ching amada chatlammi. ");
INSERT INTO mni_vpl VALUES ("MK6_47","071_6_47","MRK","6","47","47","Aduga numidang oiraklabada mahakki tung-inbasingna tongliba hi adu patyaida leirammi aduga Ibungona mathanta kangphalda leirammi. ");
INSERT INTO mni_vpl VALUES ("MK6_48","071_6_48","MRK","6","48","48","Amasung hi adu nungsitka maiyoknaba maramna Ibungogi tung-inbasingna yamna wana hi honbadu Ibungona ure. Maram aduna nongngallamdai pung ahumdagi ayukki pung taruk phaobagi manunggi pungpham amada, Ibungona makhoi tamna ising mathakta khongna lakle. Amasung Ibungona makhoibu hendoktuna chatnaba tourammi. ");
INSERT INTO mni_vpl VALUES ("MK6_49","071_6_49","MRK","6","49","50","Adubu Ibungona ising mathakta khongna chatpa adu ubada makhoina lai phattabani khanduna yamna kiraduna kanna laorammi. Adubu khudak aduda Jisuna makhoida hairak-i, “Nathouna leiyu! Eini, kiganu!” ");
INSERT INTO mni_vpl VALUES ("MK6_51","071_6_51","MRK","6","51","51","Adudagi Ibungona makhoigi marakta hida kakhatle, aduga nungsit adu lepkhre. Maduda Ibungogi tung-inbasingdu yamna ngaklammi. ");
INSERT INTO mni_vpl VALUES ("MK6_52","071_6_52","MRK","6","52","52","Maramdi makhoina thammoi kanmanbagi maramna mi lising mangada tal pijakhiba adugi nunggi oiba wapham adu makhoina khangba ngamlamde. ");
INSERT INTO mni_vpl VALUES ("MK6_53","071_6_53","MRK","6","53","53","Adudagi makhoina pat adu lanthoklaga Gennesaret lamdamda laklammi aduga mapham aduda makhoina hi adu thangle. ");
INSERT INTO mni_vpl VALUES ("MK6_54","071_6_54","MRK","6","54","54","Aduga makhoina hi adudagi hek kumthabaga misingna Ibungobu khudakta masak khanglammi. ");
INSERT INTO mni_vpl VALUES ("MK6_55","071_6_55","MRK","6","55","55","Maram aduna makhoina mapham adu sinba thungna chelladuna makhoina anaba misingbu masa masagi hipphamsingda hipphallaga Ibungo lei haina taba maphamsingda purakle. ");
INSERT INTO mni_vpl VALUES ("MK6_56","071_6_56","MRK","6","56","56","Amasung Jisuna khunggangsing, saharsing amadi apikpa khunsingda chatpa mapham khudingmakta miyamna makhoigi anaba misingbu keithelsingda puthoraklammi, aduga anabasingbu Ibungogi phiji aduta sok-hanbiyu haina makhoina Ibungoda haijarammi. Aduga Ibungogi phiji sokchaba makheina anaba phajarammi. ");
INSERT INTO mni_vpl VALUES ("MK7_1","071_7_1","MRK","7","1","1","Nongma Jerusalem-dagi lakpa Pharisee-sing amadi Wayel Yathanggi ojasing kharana Jisugi maphamda koina tillare. ");
INSERT INTO mni_vpl VALUES ("MK7_2","071_7_2","MRK","7","2","2","Amasung Ibungogi tung-inbasing kharana maangna haibadi chadringeigi mamangda chatnabigi oiba makhut hamba adu pangthoktana chaba adu ure. ");
INSERT INTO mni_vpl VALUES ("MK7_3","071_7_3","MRK","7","3","3","Pharisee-sing amadi atei Jihudising pumnakna makhoigi ahal lamansingna tambiba chatnabi ngakna chatli. Makhoina chatnabigi oiba khut hamba adu pangthoktriba makhei keidounungdasu chaba toude. ");
INSERT INTO mni_vpl VALUES ("MK7_4","071_7_4","MRK","7","4","4","Makhoina keitheldagi hallakpada hanna isingna chamthoktuna sengdoktrabadi makhoina karigumba amata chade. Makhoina atoppa chatnabi mayam amasu illi, madudi tenggotsing, chaphusing, pithraigi kolliksing amasung phamungbu chatnabigi matung inna isingna chamthokpani. ");
INSERT INTO mni_vpl VALUES ("MK7_5","071_7_5","MRK","7","5","5","Maram aduna Pharisee-sing amadi Wayel Yathanggi ojasingna Jisuda hairak-i, “Nahakki tung-inbasingna eikhoigi ahal lamansingna tambiba chatnabi adu indaduna karigi amaangba khutna charibano?” ");
INSERT INTO mni_vpl VALUES ("MK7_6","071_7_6","MRK","7","6","6","Jisuna makhoida khumlak-i, “He aphasasinnabasa! Nakhoigi maramda maichou Isaiah-na Mapu Ibungogi wa phongdokkhiba adu kayada chumkhraba! Maramdi Mahakna asumna irammi, ‘Mapu Ibungona hai, Mising asina eibu makhoigi chinbanthongda ikai khumnei, Adubu makhoigi thamoidi eingondagi lapna lei. ");
INSERT INTO mni_vpl VALUES ("MK7_7","071_7_7","MRK","7","7","7","Makhoina eibu arembada khurummi, Maramdi makhoina mioibana semba chatna pathapsingbu Eigi wayel yathanggumna tambi!’ ");
INSERT INTO mni_vpl VALUES ("MK7_8","071_7_8","MRK","7","8","8","“Nakhoina Tengban Mapugi yathangbu thadoklaga mioibana tambiba chatnabisingbu illi.” ");
INSERT INTO mni_vpl VALUES ("MK7_9","071_7_9","MRK","7","9","9","Jisuna makha taraduna hairak-i, “Aduga nakhoina nakhoigi chatnabibu ngaknanaba Tengban Mapugi Wayel Yathangbu yamna heina theidok-i. ");
INSERT INTO mni_vpl VALUES ("MK7_10","071_7_10","MRK","7","10","10","Maramdi Moses-na nakhoida yathang asi pikhi, ‘Nama napabu ikai-khumnou,’ aduga, ‘Mama mapabu thina ngangba mahak adu hatkadabani.’ ");
INSERT INTO mni_vpl VALUES ("MK7_11","071_7_11","MRK","7","11","11","Adubu nakhoina tambibadi, mi amana mahakki mama nattraga mapada mateng pangba yaba karigumba khara leirabasu, ‘Masi Corban-ni’ (haibadi Mapu Ibungoda katkhraba khudonni) hairabadi, ");
INSERT INTO mni_vpl VALUES ("MK7_12","071_7_12","MRK","7","12","12","mahakna mama nattraga mapagidamak toupham thokpa adu touhandre. ");
INSERT INTO mni_vpl VALUES ("MK7_13","071_7_13","MRK","7","13","13","Asumna nakhoida thangtharakpa nakhoigi chatnabina Tengban Mapugi wabu aremba oihalli. Aduga asiga manaba mayam amasu nakhoina tou-i.” ");
INSERT INTO mni_vpl VALUES ("MK7_14","071_7_14","MRK","7","14","14","Adudagi Jisuna miyam adubu manakta amuk kousillaga hairak-i, “Nakhoi pumnamak eina haiba tao aduga masi khang-u. ");
INSERT INTO mni_vpl VALUES ("MK7_15","071_7_15","MRK","7","15","15","Mi amada mapandagi changlakpa karigumba amatana mahakpu maang-hanba ngamloi. Adubu mi adugi nungdagi thoklakpa aduna mahakpu maang-halli. ");
INSERT INTO mni_vpl VALUES ("MK7_16","071_7_16","MRK","7","16","16","Tanaba nakong panba mahak aduna tajasanu.” ");
INSERT INTO mni_vpl VALUES ("MK7_17","071_7_17","MRK","7","17","17","Adudagi Ibungona miyam adu thadoklamlaga yumda changba matamda Ibungogi tung-inbasingna Ibungoda pandam adu sandokna takpinaba haijarammi. ");
INSERT INTO mni_vpl VALUES ("MK7_18","071_7_18","MRK","7","18","18","Maduda Ibungona makhoida khumlak-i, “Nakhoisu houjik phaoba khangdribra? Mapandagi mi amada changba karigumba amatana mahakpu maang-hanba ngamloi, ");
INSERT INTO mni_vpl VALUES ("MK7_19","071_7_19","MRK","7","19","19","Maramdi maduna mahakki thamoida changde adubu puknungda changkhi adudagi hakchanggi mapanda amuk thokkhi.” (Asumna Jisuna chinjak pumnamak seng-i haina phongdokpire.) ");
INSERT INTO mni_vpl VALUES ("MK7_20","071_7_20","MRK","7","20","20","Aduga Ibungona makha taraduna hairak-i, “Mi amagi nungdagi thoklakpa aduna mahakpu maang-halli. ");
INSERT INTO mni_vpl VALUES ("MK7_21","071_7_21","MRK","7","21","22","Maramdi phattaba wakhal, nupa nupigi oibagi lamchat naidaba, huranba, mi hatpa, mitu miwa ngangnaba, karamba, makhal makha kayagi phattaba thabak touba, lounamba, lamchat phajadaba, kallakpa, mibu phattana ngangba, napan touba, amadi apangba pumnamaksing asi nakhoigi thamoidagi thorak-i. ");
INSERT INTO mni_vpl VALUES ("MK7_23","071_7_23","MRK","7","23","23","Hairiba pumnamaksing asina nakhoigi nungdagi thoraklaga nakhoibu maang-halli.” ");
INSERT INTO mni_vpl VALUES ("MK7_24","071_7_24","MRK","7","24","24","Adudagi Jisuna mapham adu thadoklaga Tyre sahargi manakta leiba maphamsingda chatlammi aduga Ibungona yum amada changlammi. Ibungona mi kana amatada mahak kadaida leibage haiba khang-hanningdrabasu mahak lotpa ngamlamde. ");
INSERT INTO mni_vpl VALUES ("MK7_25","071_7_25","MRK","7","25","25","Aduga phattaba thawai changba nupimacha amagi mamana Ibungogi maramda hek tabaga Ibungogi nakta laktuna Ibungogi khuyakhada tuthajarammi. ");
INSERT INTO mni_vpl VALUES ("MK7_26","071_7_26","MRK","7","26","26","Nupi adu Syria-gi Phoenicia-da pokpa Greek ningolni. Mahakki machanupidagi lai phattaba adu tanthokpinaba nupi aduna Ibungoda haijarammi. ");
INSERT INTO mni_vpl VALUES ("MK7_27","071_7_27","MRK","7","27","27","Maduda Jisuna khumlak-i, “Eigi imung-manung oiriba angangsing haibadi Jihudisingda eina hanna pijapham thok-i. Angangsinggi chanababu louraga huisingda hunjinba asi chumde.” ");
INSERT INTO mni_vpl VALUES ("MK7_28","071_7_28","MRK","7","28","28","Nupiduna khumlak-i, “Chummi Ibungo, adubu table makhada leiba huisingnaphao angangsingna chabadagi tarakpa chanaba machet-makaisingdu chai!” ");
INSERT INTO mni_vpl VALUES ("MK7_29","071_7_29","MRK","7","29","29","Maduda Ibungona mangonda hairak-i, “Nahakki adugumba paokhum adugi maramna, nahak yumda hanjaro; nahakki nachanupidagi lai phattaba adu thokkhre.” ");
INSERT INTO mni_vpl VALUES ("MK7_30","071_7_30","MRK","7","30","30","Nupi aduna mayumda hanba matamda machanupidu phamungda hiptuna leiramba thengnare aduga lai phattaba adusu machanupi adudagi thokkhiramle. ");
INSERT INTO mni_vpl VALUES ("MK7_31","071_7_31","MRK","7","31","31","Jisuna Tyre-gi lam thadoktuna Sidon phaoraga Galilee pat tanna chatle. Ibungona Decapolis haina khangnaba Sahar Taragi manakki lam phaoduna chatlammi. ");
INSERT INTO mni_vpl VALUES ("MK7_32","071_7_32","MRK","7","32","32","Aduga mi kharana mana pangba lonthoktaba nupa amabu Ibungoda puraktuna mahakki mathakta khut thambiduna naba phahanbinaba haijarammi. ");
INSERT INTO mni_vpl VALUES ("MK7_33","071_7_33","MRK","7","33","33","Adudagi Ibungona nupa adubu miyamdagi tonganna puthoklaga Ibungogi khudombina mahakki manakong animakta thingjinbirammi. Aduga Ibungona mahakki khudombida tin sitlaga nupadugi marei sokpirammi. ");
INSERT INTO mni_vpl VALUES ("MK7_34","071_7_34","MRK","7","34","34","Amasung Ibungona swargaromda yengkhatlaga sor phuina holladuna hairak-i, “Ephphatha!” masigi wahanthokti “Hangdoklo” haibani. ");
INSERT INTO mni_vpl VALUES ("MK7_35","071_7_35","MRK","7","35","35","Khudaktuda nupa adu taba ngamle aduga wa ngangbada apanba leirambadu louthokkhiduna mahak phajana ngangba ngamle. ");
INSERT INTO mni_vpl VALUES ("MK7_36","071_7_36","MRK","7","36","36","Adudagi Jisuna makhoida mi kana amatada haidoktanaba yathang pirammi. Adubu Ibungona makhoida haidoktanaba yathang henna piriba makhei, makhoina hennadum haidoklammi. ");
INSERT INTO mni_vpl VALUES ("MK7_37","071_7_37","MRK","7","37","37","Amasung pao adu tabada makhoi yamna ngaklammi. Maduda makhoina hairak-i, “Mahakna touba thabak pumnamak kayada angakpano! Mahakna mana pangbasing phaoba na tahanbi aduga lonthoktabasing phaoba lon thok-hanbi!” ");
INSERT INTO mni_vpl VALUES ("MK8_1","071_8_1","MRK","8","1","1","Matam aduda atoppa yamkhraba miyam ama amuk tillammi. Amasung mising adugi chanaba kari amata leitaba maramna Jisuna mahakki tung-inbasing adubu manakta kousilladuna hairak-i, ");
INSERT INTO mni_vpl VALUES ("MK8_2","071_8_2","MRK","8","2","2","“Mising asigidamak ei nungaitaba phao-i, maramdi makhoina eiga leiminnarakpasi numit humni sure aduga houjik makhoigi chanaba karisu leitre. ");
INSERT INTO mni_vpl VALUES ("MK8_3","071_8_3","MRK","8","3","3","Eina makhoibu karisu pijadana mayumda thakhrabadi makhoi lambida wantharagani maramdi makhoi kharadi lam arappadagi lakpasu yaori.” ");
INSERT INTO mni_vpl VALUES ("MK8_4","071_8_4","MRK","8","4","4","Ibungogi tung-inbasingna Ibungoda hanglak-i, “Lamhang asidabu asuk yamkhraba miyamsing asibu pijaba konnagadaba chinjak kadaidagi lourugani?” ");
INSERT INTO mni_vpl VALUES ("MK8_5","071_8_5","MRK","8","5","5","Jisuna makhoida hanglak-i, “Nakhoida tal kaya yaori?” Makhoina khumlak-i, “Taret yaori.” ");
INSERT INTO mni_vpl VALUES ("MK8_6","071_8_6","MRK","8","6","6","Adudagi Ibungona miyamdu leipakta phamthanaba yathang pire. Amasung Ibungona tal tarettu louduna Mapu Ibungobu thagatcharaga talsingdu machet setladuna miyamda yenthoknaba Ibungogi tung-inbasingda pire; aduga tung-inbasingduna miyamda yenthokle. ");
INSERT INTO mni_vpl VALUES ("MK8_7","071_8_7","MRK","8","7","7","Amasung makhoida nga macha kharasu yaorammi. Aduga Ibungona ngasingdugidamak Mapu Ibungobu thagatcharaga mahakki tung-inbasingda ngasingdusu miyamda yenthoknaba hairammi. ");
INSERT INTO mni_vpl VALUES ("MK8_8","071_8_8","MRK","8","8","9","Aduga makhoi pumnamak mabuk thanna chare. Maphamduda leiba mi masingdu chaorakna lising mariromni. Adudagi Ibungogi tung-inbasingna lemhouba machet makaising adu thummok taret thanna khomjille. Amasung Ibungona miyamsing adu hek thadokkhibaga, ");
INSERT INTO mni_vpl VALUES ("MK8_10","071_8_10","MRK","8","10","10","mahakki tung-inbasingga loinana hida tongkhatladuna Dalmanutha-gi lamda chatlammi. ");
INSERT INTO mni_vpl VALUES ("MK8_11","071_8_11","MRK","8","11","11","Pharisee kharana Jisu lakle tabada manakta laktuna Ibungoda marei yetnaba hourammi. Makhoina Ibungobu themdoktuna asoiba touhanba pamlammi, maram aduna Mapu Ibungona Ibungobu yai haiba utnanaba swargadagi angakpa khudam ama utnaba makhoina Ibungoda hairammi. ");
INSERT INTO mni_vpl VALUES ("MK8_12","071_8_12","MRK","8","12","12","Maduda Ibungona yamna nungaitana sor phuina hollaga hairak-i, “Houjikki mirolsina karigi angakpa khudam thiribano? Eina nakhoida tasengnamak hairi, mirol asida asigumba khudam amata piroi.” ");
INSERT INTO mni_vpl VALUES ("MK8_13","071_8_13","MRK","8","13","13","Adudagi Ibungona makhoibu thanamduna hida amuk tongkhatlaga pat adugi wangmada chatlammi. ");
INSERT INTO mni_vpl VALUES ("MK8_14","071_8_14","MRK","8","14","14","Aduga Ibungogi tung-inbasing aduna chananaba purakpa kaorammi. Amasung makhoigi tal amakhak yaobadu nattana hi aduda makhoigi chananaba kari amata leiramde. ");
INSERT INTO mni_vpl VALUES ("MK8_15","071_8_15","MRK","8","15","15","Amasung Jisuna makhoida cheksin wa hairak-i, “Cheksinna leiyu, aduga Pharisee-sing amadi Herod-ki hameidagi cheksillu.” ");
INSERT INTO mni_vpl VALUES ("MK8_16","071_8_16","MRK","8","16","16","Maduda makhoi masel amaga amaga khannaduna hainarammi, “Ibungona hairiba asi eikhoida tal amata yaodabagini.” ");
INSERT INTO mni_vpl VALUES ("MK8_17","071_8_17","MRK","8","17","17","Makhoina hainaribadu Jisuna khangladuna makhoida hairak-i, “Nakhoina tal yaodabagi maramda karigi khannaribano? Nakhoi houjik phaoba khangdribra aduga wakhal tadribra? Nakhoigi pukning wakhalsingdu iphak phakchillabra? ");
INSERT INTO mni_vpl VALUES ("MK8_18","071_8_18","MRK","8","18","19","Mit panna panna nakhoi udabra? Na panna panna nakhoi tadabra? Eina tal manga machet settuna mi lising mangada pijakhiba aduda nakhoina lemhouba machet makaising adu thummok kaya thanna khomjinkhibage haibadu nakhoi ningsingdabra?” Maduda makhoina khumlak-i, “Taranithoini.” ");
INSERT INTO mni_vpl VALUES ("MK8_20","071_8_20","MRK","8","20","20","Jisuna makhoida hanglak-i, “Eina tal taret machet settuna mi lising marida pijakhiba adudadi nakhoina lemhouba machet makaising thummok kaya thanna khomjinkhibage.” Makhoina khumlak-i, “Taretni.” ");
INSERT INTO mni_vpl VALUES ("MK8_21","071_8_21","MRK","8","21","21","Adudagi Ibungona makhoida hanglak-i, “Aduga nakhoina houjik phaoba khangba ngamdribra?” ");
INSERT INTO mni_vpl VALUES ("MK8_22","071_8_22","MRK","8","22","22","Jisu amadi mahakki tung-inbasingna Bethsaida-da lakpada mioi kharana mamit tangba mi amabu Jisugi manakta puraktuna mahakpu sokpiduna phahanbinaba Ibungoda haijarammi. ");
INSERT INTO mni_vpl VALUES ("MK8_23","071_8_23","MRK","8","23","23","Amasung Ibungona mamit tangba nupa adubu makhut sambiduna khundugi wangmada puthokpire aduga mahakki mitta tin sitlaga Ibungogi khutna mahakki mathakta thamduna hanglak-i, “Houjik nahak karigumba khara uba ngambra?” ");
INSERT INTO mni_vpl VALUES ("MK8_24","071_8_24","MRK","8","24","24","Maduda nupa aduna yengkhatladuna hairak-i, “Hoi, eina mising uba ngamjare, adubu makhoi yengbada u-pambisingna koichat chatpa malli.” ");
INSERT INTO mni_vpl VALUES ("MK8_25","071_8_25","MRK","8","25","25","Jisuna amuk nupa adugi mamit animakta mahakki khut thambire. Handakti nupa aduna munna yenglammi amasung mahakki mittu pungpha phajaduna pumnamak sengna amuk uba ngamjare. ");
INSERT INTO mni_vpl VALUES ("MK8_26","071_8_26","MRK","8","26","26","Adudagi Jisuna mahakpu mayumda tharaduna hairak-i, “Nahakna nayumda chatpada khun aduda halluranu.” ");
INSERT INTO mni_vpl VALUES ("MK8_27","071_8_27","MRK","8","27","27","Jisu amadi mahakki tung-inbasingna Caesarea Philippi-gi akoibada leiba khun khunsingda chatlammi amasung makhoina asum chatlingeida Ibungona makhoida hanglak-i, “Misingna eibu kanani hainabage?” ");
INSERT INTO mni_vpl VALUES ("MK8_28","071_8_28","MRK","8","28","28","Maduda makhoina khumlak-i, “Mi kharanadi Ibungodi Baptize toubiba John-ni hainei; aduga mi kharana Elijah-ni hai; aduga mi khara amanadi Mapu Ibungogi wa phongdokpiba maichousinggi maraktagi amani hainei.” ");
INSERT INTO mni_vpl VALUES ("MK8_29","071_8_29","MRK","8","29","29","Adudagi Ibungona makhoida hanglak-i, “Adubu nakhoinadi eibu kanani haibage?” Maduda Peter-na khumlak-i, “Ibungo nahakti Christta aduni.” ");
INSERT INTO mni_vpl VALUES ("MK8_30","071_8_30","MRK","8","30","30","Adudagi Jisuna makhoida yathang piduna hairak-i, “Eigi maramda nakhoina kanadasu haiganu.” ");
INSERT INTO mni_vpl VALUES ("MK8_31","071_8_31","MRK","8","31","31","Madudagi Jisuna mahakki tung-inbasingda tambiba houre, “Migi Machanupa adu awaba nanggani aduga ahal lamansing, athoiba purohitsing amasung Wayel Yathanggi ojasingna mahakpu yaroi. Mahakpu hatkani, adubu humni suba numitta mahak amuk hinggatkani.” ");
INSERT INTO mni_vpl VALUES ("MK8_32","071_8_32","MRK","8","32","32","Ibungona waphamsing asi makhoida yamna sengna khang-halle. Maduda Peter-na Ibungobu tonganna kouthokladuna Ibungoda cheiba houre. ");
INSERT INTO mni_vpl VALUES ("MK8_33","071_8_33","MRK","8","33","33","Adubu Ibungona onsillaktuna mahakki tung-inbasingda yengle amasung Peter-bu cheiraduna hairak-i, “Eingondagi chatthokkhro, Satan! Nahakna khalliba wakhal adu Mapu Ibungodagi lakpa natte madu mioibagi oiba wakhalni.” ");
INSERT INTO mni_vpl VALUES ("MK8_34","071_8_34","MRK","8","34","34","Adudagi Jisuna miyam amadi mahakki tung-inbasing adu manakta kousillaga hairak-i, “Kanagumba amana eigi itung inninglabadi, mahakna masagi oiba aningba apambasing thadoksanu aduga mahakki cross puduna eigi itung insanu. ");
INSERT INTO mni_vpl VALUES ("MK8_35","071_8_35","MRK","8","35","35","Kanagumba amana mahakki thawai kanjaba pamlabadi mahakki thawaidu mangjagani; adubu eigi amadi Aphaba Paogidamak mahakki thawai mangjarabadi mahakki thawai adu kanba phangjagani. ");
INSERT INTO mni_vpl VALUES ("MK8_36","071_8_36","MRK","8","36","36","Mi amana taibangpan apumba phangjaraga mahakki thawai mangjarabadi, mahakki kari tongjaba leibage? ");
INSERT INTO mni_vpl VALUES ("MK8_37","071_8_37","MRK","8","37","37","Nattraga mi amana mahakki thawaiga kariga sinnaba yabage? ");
INSERT INTO mni_vpl VALUES ("MK8_38","071_8_38","MRK","8","38","38","Thajaba yadaba amadi papna thallaba mirol asida kanagumba amana eigidamak amadi eigi waheigidamak ikairabadi, Migi Machanupa aduna mahakki Mapagi matik mangal amadi asengba swargadutsingga loinana lakpa matam aduda mahakna makhoi adugidamak ikaigani.” ");
INSERT INTO mni_vpl VALUES ("MK9_1","071_9_1","MRK","9","1","1","Amasung Jisuna makhoida makha tana hairak-i, “Eina nakhoida tasengnamak hairibasini, mapham asida lepliba makhoi kharadi Tengban Mapugi Leibak aduna panggalga loinana lakpa adu udriba phaoba sibagi mahao tangloi.” ");
INSERT INTO mni_vpl VALUES ("MK9_2","071_9_2","MRK","9","2","2","Numit taruknigi matungda Jisuna Peter, Jacob amadi John khaktabu tonganna puraduna awangba ching amada kakhatle. Aduga mapham aduda Ibungona makhoigi mamangda sak-ong hongle. ");
INSERT INTO mni_vpl VALUES ("MK9_3","071_9_3","MRK","9","3","3","Amasung Ibungogi phijoldu taibangpanda leiriba phisuba kanana suduna ngouhanba ngamba adudagi thoidok hendokna nganna-langna ngourakle. ");
INSERT INTO mni_vpl VALUES ("MK9_4","071_9_4","MRK","9","4","4","Adudagi makhoina khang-houdana Elijah amadi Moses thoraktuna Jisuga wari sanaba adu ure. ");
INSERT INTO mni_vpl VALUES ("MK9_5","071_9_5","MRK","9","5","5","Maduda Peter-na Jisuda hairak-i, “Oja Ibungo, eikhoina mapham asida leijabasi eikhoigidamak kayada phakhraba! Eikhoina sang ahum haibadi Ibungogi ama, Moses-ki ama, amasung Elijah-gi ama sasi.” ");
INSERT INTO mni_vpl VALUES ("MK9_6","071_9_6","MRK","9","6","6","Peter-na kari haigadage haiba khangdaduna waheising asi haibani, maramdi makhoi adukki matik kirammi. ");
INSERT INTO mni_vpl VALUES ("MK9_7","071_9_7","MRK","9","7","7","Adudagi leichil ama thoraktuna makhoibu khanjinlammi, amasung leichil maraktagi khonjel amana hairak-i, “Masi eigi nungsiraba Ichanupani, mahakna haiba tao!” ");
INSERT INTO mni_vpl VALUES ("MK9_8","071_9_8","MRK","9","8","8","Adudagi makhoina akoibada yengbada, ikhang khang-houdana Jisu nattana atei kana amatabu amuk ukhidre. ");
INSERT INTO mni_vpl VALUES ("MK9_9","071_9_9","MRK","9","9","9","Aduga makhoina chingthak adudagi asum kumtharakpa matamda Jisuna makhoida yathang piraduna hairak-i, “Nakhoina ukhibasing adu Migi Machanupa aduna sibadagi hinggattriba phaoba mi kana amatada tamthokkanu.” ");
INSERT INTO mni_vpl VALUES ("MK9_10","071_9_10","MRK","9","10","10","Makhoina Ibungogi yathangdu ngakcharammi. Adumakpu makhoigi marakta “Sibadagi hinggatpa” haibasigi wahanthok karino haina makhoi masen amaga amaga hangnarammi. ");
INSERT INTO mni_vpl VALUES ("MK9_11","071_9_11","MRK","9","11","11","Amasung makhoina Ibungoda hanglak-i, “Karigi Christtana laktringeida Elijah-na hanna lakkani haina Wayel Yathanggi Ojasingna hairibano?” ");
INSERT INTO mni_vpl VALUES ("MK9_12","071_9_12","MRK","9","12","12","Maduda Jisuna makhoida khumlak-i, “Asengbamak Elijah-na hanna lakkani aduga pot pumnamak masagi oipham thokpa phibhamda hanjinbigani. Aduga Migi Machanupa aduna awa ana kaya khaanggani amasung mahakpu inthokpigani haina Mapugi Puyada karamna iribano? ");
INSERT INTO mni_vpl VALUES ("MK9_13","071_9_13","MRK","9","13","13","Adumakpu eina nakhoida hairi, Elijah-di lakkhre aduga Mapugi Puyada mahakki maramda ikhibagumna, misingna makhoigi apamba adu mangonda toukhre.” ");
INSERT INTO mni_vpl VALUES ("MK9_14","071_9_14","MRK","9","14","14","Adudagi makhoina atei tung-inbasing adugi manakta amuk halakpa matamda, yamlaba miyam amana makhoigi akoibada leiramba aduga Wayel Yathanggi Ojasing kharana tung-inbasing aduga wahang paohangnaduna leiramba adu ure. ");
INSERT INTO mni_vpl VALUES ("MK9_15","071_9_15","MRK","9","15","15","Aduga miyam aduna Jisubu hek ubada yamna ngaklammi, amasung manakta chensinduna mahakpu okcharammi. ");
INSERT INTO mni_vpl VALUES ("MK9_16","071_9_16","MRK","9","16","16","Jisuna makhoida hanglak-i, “Nakhoina makhoiga kari maramda wahang paohangnaribano?” ");
INSERT INTO mni_vpl VALUES ("MK9_17","071_9_17","MRK","9","17","17","Miyam adugi maraktagi nupa amana khumlak-i, “Oja Ibungo, eina eigi ichanupabu Ibungogi nakta pujarakpani maramdi mangonda phattaba thawai ama changduna leire aduga wa ngangbasu thoktre. ");
INSERT INTO mni_vpl VALUES ("MK9_18","071_9_18","MRK","9","18","18","Thawai aduna mahakpu hek laksinba khudingda mahakpu leimaida inthui, aduga mayada konggol kaduna maya krak krak chik-i, amasung masa pumba chap ting-i. Eihakna Ibungogi tung-inbasingda thawai adu tanthokpinaba haijarambani, adubu makhoina tanthokpa ngamdre.” ");
INSERT INTO mni_vpl VALUES ("MK9_19","071_9_19","MRK","9","19","19","Jisuna makhoida hairak-i, “He thajadaba mirol! Kayam kuina eina nakhoiga leiminnakhigadage? Kayam kuina eina nakhoibu khaangkhigadage? Nupamacha adu eigi inakta pusillak-u.” ");
INSERT INTO mni_vpl VALUES ("MK9_20","071_9_20","MRK","9","20","20","Adudagi makhoina nupamacha adu Jisugi manakta pusillaklammi. Aduga phattaba thawai aduna Jisubu hek ubaga nupamacha adubu ot-neiduna nik-hallammi. Adudagi mahak leimaida ture amasung mayada konggol karaduna, tharo tharo onba houre. ");
INSERT INTO mni_vpl VALUES ("MK9_21","071_9_21","MRK","9","21","21","Jisuna mapa aduda hanglak-i, “Mahakna asumna toubasi matam kayam kuiraklabage?” Mapa aduna khumlak-i, “Mahakna angang oiringeidagi touraklabani. ");
INSERT INTO mni_vpl VALUES ("MK9_22","071_9_22","MRK","9","22","22","Phattaba thawai asina mahakpu hatnanaba kayarak meinungda hunjilli amasung isingda langthei. Aduna Ibungona karigumba khara toubiba ngamba oibirabadi, eikhoibu nungsibiyu amasung eikhoibu pangbiyu.” ");
INSERT INTO mni_vpl VALUES ("MK9_23","071_9_23","MRK","9","23","23","Jisuna khumlak-i, “‘Nahakna ngamlabadi’ haibadi karino! Thajaba leiba mahak aduda pumnamak oithokpa ngaktani.” ");
INSERT INTO mni_vpl VALUES ("MK9_24","071_9_24","MRK","9","24","24","Maduda mapa aduna mapi sintharaduna khudak adumaktada laona hairak-i, “Ibungo, eina thajei adubu mapung phade, eina mapungphana thajaba leinaba eibu pangbiyu.” ");
INSERT INTO mni_vpl VALUES ("MK9_25","071_9_25","MRK","9","25","25","Miyam aduna mapham aduda thuna omsillakpa Jisuna urabada, mahakna phattaba thawai aduda cheiraduna hairak-i, “Na pangba amasung lon thoktabagi thawai, nupamacha asidagi thokkhro aduga amuk hanna mangonda changdanaba eina nangonda yathang piri.” ");
INSERT INTO mni_vpl VALUES ("MK9_26","071_9_26","MRK","9","26","26","Maduda thawai aduna houna laoraduna nupamacha adubu tamthina ot-neiduna nik-hallamlaga mangondagi thokkhre. Adudagi nupamacha adu asibagum taduna leirammi amasung mipum khudingmakna hairak-i, “Mahak sire.” ");
INSERT INTO mni_vpl VALUES ("MK9_27","071_9_27","MRK","9","27","27","Adubu Jisuna nupamacha adubu makhut paibiduna chingkhatpire amasung mahak lepkhatlakle. ");
INSERT INTO mni_vpl VALUES ("MK9_28","071_9_28","MRK","9","28","28","Adudagi Jisuna yum manungda changlaklaba matungda mahakki tung inbasingna mangonda lonna hanglak-i, “Eikhoinadi thawai adubu tanthokpa karigi ngamdribano?” ");
INSERT INTO mni_vpl VALUES ("MK9_29","071_9_29","MRK","9","29","29","Ibungona khumlak-i, “Asigumbasing asi charahenba amadi haijabagi mapanna nattanadi atei kari amatana ngamde.” ");
INSERT INTO mni_vpl VALUES ("MK9_30","071_9_30","MRK","9","30","30","Adudagi Jisu amasung mahakki tung inbasingna mapham adu thadoklamlaga Galilee-gi lam phaoduna chatlammi. Aduga Ibungona mahak kadaida leibage haibasi mi kana amatada khang-hanba pamlamde. ");
INSERT INTO mni_vpl VALUES ("MK9_31","071_9_31","MRK","9","31","31","Maramdi Ibungona mahakki tung-inbasingbu tambiduna leirammi. Ibungona hairak-i, “Migi Machanupa adubu misinggi makhutta pithokkani aduga makhoina mahakpu hatkani; adumakpu humnisuba numitta mahak amuk hinggatkani.” ");
INSERT INTO mni_vpl VALUES ("MK9_32","071_9_32","MRK","9","32","32","Adubu Ibungona hairibasing adu makhoina khangba ngamlamde, aduga makhoina Ibungoda hangbasu kirammi. ");
INSERT INTO mni_vpl VALUES ("MK9_33","071_9_33","MRK","9","33","33","Adudagi makhoina Capernaum-da laklammi, aduga yum amada leiringeida Jisuna mahakki tung inbasingda hanglak-i, “Nakhoina lambida yetnakhiba adu kari maramdano?” ");
INSERT INTO mni_vpl VALUES ("MK9_34","071_9_34","MRK","9","34","34","Adubu makhoina Ibungoda paokhum piramde, maramdi lambida makhoina makhoigi marakta kanana khwaidagi henna chaobage haiduna yetnarammi. ");
INSERT INTO mni_vpl VALUES ("MK9_35","071_9_35","MRK","9","35","35","Adudagi Jisuna phamtharaduna tung-inba taranithoi adubu kouraga makhoida hairak-i, “Kanagumbana makok oininglabadi mahakna khwaidagi atonba mapham adu lougadabani amasung pumnamakki thougal touba mi oigadabani.” ");
INSERT INTO mni_vpl VALUES ("MK9_36","071_9_36","MRK","9","36","36","Adudagi Ibungona apikpa angang amabu makhoigi marakta lephalle. Aduga Ibungogi pambomna angang adubu konbiraga makhoida hairak-i, ");
INSERT INTO mni_vpl VALUES ("MK9_37","071_9_37","MRK","9","37","37","“Kanagumba amana asigumba apikpa angangsing asigi maraktagi amabu eigi mingda lousinjarabadi mahakna eibu lousinjabani; aduga kanagumba amana eibu lousinjarabadi, mahakna ei khaktabu lousinjaba natte adubu eibu tharakpa Ibungo Mahak adubusu lousinjabani.” ");
INSERT INTO mni_vpl VALUES ("MK9_38","071_9_38","MRK","9","38","38","John-na Ibungoda hairak-i, “Oja Ibungo, eikhoina Ibungogi mingda lai phattabasing tanthokpa mi ama ujei amasung eikhoina mangonda madu toknanaba hairammi maramdi mahak eikhoigi irakta yaoba mi natte.” ");
INSERT INTO mni_vpl VALUES ("MK9_39","071_9_39","MRK","9","39","39","Jisuna makhoida hairak-i, “Mahakpu khamganu, maramdi eigi mingda angakpa thabak touraga thuna eigi maramda phattaba wa haigadaba mi kanasu leite. ");
INSERT INTO mni_vpl VALUES ("MK9_40","071_9_40","MRK","9","40","40","Maramdi eikhoigi maiyokta leitaba mahak adu eikhoigi mini. ");
INSERT INTO mni_vpl VALUES ("MK9_41","071_9_41","MRK","9","41","41","Eina nakhoida tasengnamak hairibasini, madudi kanagumbana nakhoibu Christtagi misingni haiduna, eigi mingda ising glass ama pirabadi mahakna sungsoi soidana mahakki mana phangjagani. ");
INSERT INTO mni_vpl VALUES ("MK9_42","071_9_42","MRK","9","42","42","“Kanagumba mi amana eibu thajaba apikpa angangsing asigi maraktagi amabu papta tahallabadi, mahakki mangakta achouba chakkri nung ama yansillaga achouba ipakta thadabana mahakkidamaktadi henna phei. ");
INSERT INTO mni_vpl VALUES ("MK9_43","071_9_43","MRK","9","43","43","Maram aduna nahakki khutna nahakpu papta tahallabadi, madu kakthatkho. Maramdi nakhut ani pallaga norokki mutnaidaba meida langsinbabudi, nakhut namata panduna hingbada changbana nahakkidamak henna phei. ");
INSERT INTO mni_vpl VALUES ("MK9_44","071_9_44","MRK","9","44","44","Norok aduda makhoibu chariba hal siba naide, aduga makhoibu chakliba meisu mutpa naide. ");
INSERT INTO mni_vpl VALUES ("MK9_45","071_9_45","MRK","9","45","45","Nahakki khongna nahakpu papta tahallabadi, madu kakthatkho. Maramdi nakhong ani pallaga norokta langsinbabudi, nakhong nama yaodana hingbada changbana nahakkidamak henna phei. ");
INSERT INTO mni_vpl VALUES ("MK9_46","071_9_46","MRK","9","46","46","Norok aduda makhoibu chariba hal siba naide, aduga makhoibu chakliba meisu mutpa naide. ");
INSERT INTO mni_vpl VALUES ("MK9_47","071_9_47","MRK","9","47","47","Nahakki mitna nahakpu papta tahallabadi, madu kotthokkho. Maramdi namit ani pallaga norokta langsinbabudi, namit namatang pallaga Tengban Mapugi leibakta changbana nahakkidamak henna phei. ");
INSERT INTO mni_vpl VALUES ("MK9_48","071_9_48","MRK","9","48","48","Norok aduda makhoibu chariba hal siba naide, aduga makhoibu chakliba meisu mutpa naide. ");
INSERT INTO mni_vpl VALUES ("MK9_49","071_9_49","MRK","9","49","49","“Maramdi iratpot khudingmakpu thumna seng-hanba adugumna mi khudingbu meina seng-hangani. ");
INSERT INTO mni_vpl VALUES ("MK9_50","071_9_50","MRK","9","50","50","“Thumdi aphabani, adubu thumna thumgi mahao mangkhrabadi, nakhoina madu kamdouna amuk mahao leihan-gadage? “Nakhoi nasen-gi marakta thumgi magunsing adu leihallu, aduga nakhoi amaga amaga ingthana leiminnou.” ");
INSERT INTO mni_vpl VALUES ("MK10_1","071_10_1","MRK","10","1","1","Adudagi Jisuna mapham adu thadoktuna Judea-da amadi Jordan turel-gi wangmada chatlammi. Aduga amuk hanna yamlaba miyamna Ibungogi manakta tillarabada, mahousagumna Ibungona makhoibu tambirammi. ");
INSERT INTO mni_vpl VALUES ("MK10_2","071_10_2","MRK","10","2","2","Amasung Pharisee khara laklaga Ibungobu changyengladuna hanglak-i, “Nupa amana mahakki nupi khainabasi eikhoigi wayelna yabra?” ");
INSERT INTO mni_vpl VALUES ("MK10_3","071_10_3","MRK","10","3","3","Jisuna paokhum oina makhoida wahang ama hanglak-i, “Moses-na nakhoida kari yathang pirambage?” ");
INSERT INTO mni_vpl VALUES ("MK10_4","071_10_4","MRK","10","4","4","Makhoina khumlak-i, “Nupa amana khaina-che ama iraga mahakki nupibu khainaba Moses-na yabirammi.” ");
INSERT INTO mni_vpl VALUES ("MK10_5","071_10_5","MRK","10","5","5","Jisuna makhoida hairak-i, “Nakhoina thamoi kanmanbagi maramna Moses-na nakhoida yathang asi irambani. ");
INSERT INTO mni_vpl VALUES ("MK10_6","071_10_6","MRK","10","6","6","Adubu Mapu Ibungogi khutsemgi ahoubadagi houna Mapu Ibungona nupa amadi nupi haina sembikhi. ");
INSERT INTO mni_vpl VALUES ("MK10_7","071_10_7","MRK","10","7","7","Maram asina nupa amana mahakki mama mapabu thadoktuna magi nupida punsin-gani. ");
INSERT INTO mni_vpl VALUES ("MK10_8","071_10_8","MRK","10","8","8","Aduga makhoi ani hakchang amata oigani, maram aduna makhoi amuk hanna ani oidre, adubu amata oire. ");
INSERT INTO mni_vpl VALUES ("MK10_9","071_10_9","MRK","10","9","9","Maram aduna Tengban Mapuna punsinbikhraba adu mi kana amatana khaidoktasanu.” ");
INSERT INTO mni_vpl VALUES ("MK10_10","071_10_10","MRK","10","10","10","Adudagi makhoina yumda amuk hallaklabada hiram asigi matangda tung-inbasingna Ibungoda amuk hanglammi. ");
INSERT INTO mni_vpl VALUES ("MK10_11","071_10_11","MRK","10","11","11","Maduda Ibungona makhoida hairak-i, “Kanagumba nupa amana mahakki nupibu khainaraga atoppa nupi amaga amuk luhonglabadi mahakna mahakki nupidugi mathakta lannabagi thabak tourabani. ");
INSERT INTO mni_vpl VALUES ("MK10_12","071_10_12","MRK","10","12","12","Maduga chap manana nupi amana mahakki mapuroibabu khainaraga atoppa nupa amaga amuk luhonglabadi, mahakna lanabagi thabak tou-i.” ");
INSERT INTO mni_vpl VALUES ("MK10_13","071_10_13","MRK","10","13","13","Nongma mioi kharana Jisuda khut thamhanduna yaipha thoujal pihannabagidamak makhoigi apikpa angangsingbu Jisugi manakta puraklammi. Adubu mahakki tung-inbasingna makhoibu cheibirammi. ");
INSERT INTO mni_vpl VALUES ("MK10_14","071_10_14","MRK","10","14","14","Jisuna madu ubada saoraduna makhoida hairak-i, “Apikpa angangsingdu eigi inakta lakchasanu, makhoibu khamganu, maramdi Tengban Mapugi leibak adu makhoi asigumbasinggini. ");
INSERT INTO mni_vpl VALUES ("MK10_15","071_10_15","MRK","10","15","15","Eina nakhoida tasengnamak hairibasini, apikpa angang amagumna Tengban Mapugi leibak adubu lousindaba kanagumba amatana maduda khak changloi.” ");
INSERT INTO mni_vpl VALUES ("MK10_16","071_10_16","MRK","10","16","16","Adudagi Ibungona angangsing adubu pamkhatpiraduna makhoigi mathakta khut thambiraga yaipha thoujal pibire. ");
INSERT INTO mni_vpl VALUES ("MK10_17","071_10_17","MRK","10","17","17","Adudagi Jisuna maphamdu thadoklamlaga lambida asum lakpada nupa amana chellaklaga Ibungogi mangda khuru khudak kunladuna Ibungoda hangjarak-i, “Aphaba Oja Ibungo, lomba naidaba punsi phangjanaba eina kari toujagadage?” ");
INSERT INTO mni_vpl VALUES ("MK10_18","071_10_18","MRK","10","18","18","Maduda Jisuna mangonda hairak-i, “Karigi nangna eingonda aphaba haina kouribano? Tengban Mapu nattana aphaba kana amata leite. ");
INSERT INTO mni_vpl VALUES ("MK10_19","071_10_19","MRK","10","19","19","‘Mi hatkanu, mitu miwa lannaganu, huran-ganu, aranba sakhi piganu, minamganu, amasung nama napabu ikai khumnou’ haiba Mapu Ibungogi wayel yathangsing asi nahakna khang-i.” ");
INSERT INTO mni_vpl VALUES ("MK10_20","071_10_20","MRK","10","20","20","Nupa aduna khumlak-i, “Oja Ibungo, eina angang oiringeidagi houna hairiba wayel yathang pumnamaksing asi ngakcharak-i.” ");
INSERT INTO mni_vpl VALUES ("MK10_21","071_10_21","MRK","10","21","21","Ibungona nupa aduda yenglammi amasung nungsiba poklammi. Adudagi Ibungona mangonda hairak-i, “Nahakna tougadaba ama watli. Chatlu aduga nahakki leijaba pumba yonthoklaga sel adu lairabasingda pithok-u, adu oirabadi swargada nahakki lan leigani; aduga lak-u, eigi itung illu.” ");
INSERT INTO mni_vpl VALUES ("MK10_22","071_10_22","MRK","10","22","22","Madu tabada nupa adu maithong maksilladuna, pukning wana mapham adudagi chatkhirammi maramdi mahak maran-mathum yamna leiba mi oirammi. ");
INSERT INTO mni_vpl VALUES ("MK10_23","071_10_23","MRK","10","23","23","Adudagi Jisuna koina yengladuna mahakki tung-inbasingduda hairak-i, “Inakkhunba misingna Mapu Ibungogi leibakta changba kayada lukhrabano!” ");
INSERT INTO mni_vpl VALUES ("MK10_24","071_10_24","MRK","10","24","24","Ibungogi wasing asi tabada tung-inbasing adu i-ngak ngaklammi, maduda Jisuna makha tana hairak-i, “Angangsa, lanthumda thajabasing aduna Tengban Mapugi leibakta changba kayada lukhrabano! ");
INSERT INTO mni_vpl VALUES ("MK10_25","071_10_25","MRK","10","25","25","Inakkhunba mi amana Tengban Mapugi leibakta changbabudi ut amana yetum manada litpana henna lai.” ");
INSERT INTO mni_vpl VALUES ("MK10_26","071_10_26","MRK","10","26","26","Maduda tung-inbasingdu amukka henna ngakladuna amaga amaga hangnarak-i, “Adu oirabadi kanana kanbiba phangba ngamgadage?” ");
INSERT INTO mni_vpl VALUES ("MK10_27","071_10_27","MRK","10","27","27","Jisuna makhoida yengladuna hairak-i, “Mioibadadi masi oithoktabani adubu Tengban Mapugi maphamdadi natte; Tengban Mapugi maphamdadi pumnamak oithokpa ngaktani.” ");
INSERT INTO mni_vpl VALUES ("MK10_28","071_10_28","MRK","10","28","28","Maduda Peter-na hairak-i, “Yengbiyu, eikhoina pumnamak thadoktuna Ibungogi tung injari.” ");
INSERT INTO mni_vpl VALUES ("MK10_29","071_10_29","MRK","10","29","29","Jisuna khumlak-i, “Eina nakhoida tasengnamak hairibasini, eigi amadi Aphaba Paogi maramgidamak mayum-makei, nattraga machin-manao, nattraga machan-mache, nattraga mama-mapa, nattraga angangsing, nattraga lou-sing thadokpa makhoising aduna, ");
INSERT INTO mni_vpl VALUES ("MK10_30","071_10_30","MRK","10","30","30","taibangpanda leiringei matamda mayum-makei, machin-manao, machan-mache, mama, macha, amadi lou-singgi saruk chama chama henna phangjagani aduga loinana otpi neibiba amasung lakkadaba matam aduda lomba naidaba punsi phangjagani. ");
INSERT INTO mni_vpl VALUES ("MK10_31","071_10_31","MRK","10","31","31","Adubu houjik ahanba oiribasingna akonba oigani aduga houjik akonba oiribasingna ahanba oigani.” ");
INSERT INTO mni_vpl VALUES ("MK10_32","071_10_32","MRK","10","32","32","Adudagi Jisu amasung mahakki tung-inbasingna Jerusalem maikei panglammi. Amasung Jisuna makhoigi mamang tharaduna chatpa aduda tung-inba taranithoi adu yamna ngaklammi aduga atei tung induna chatlibasing adusu kirammi. Adudagi Jisuna tung-inba taranithoi adubu amuk tonganna puthokladuna mangonda thoklagadabasing adugi maramda amuk hairak-i, ");
INSERT INTO mni_vpl VALUES ("MK10_33","071_10_33","MRK","10","33","33","“Yengu, eikhoina houjik Migi Machanupa adubu athoiba purohit amadi wayel yathanggi ojasinggi makhutta pithokkadaba mapham Jerusalem-da chatli. Makhoina mahakpu sibagi maral pigani aduga Jihudi nattaba misinggi makhutta pithokkani. ");
INSERT INTO mni_vpl VALUES ("MK10_34","071_10_34","MRK","10","34","34","Makhoina mahakpu noknagani amasung tin sitchingani, phugani amasung mahakpu hatkani; aduga humnisuba numitta mahak amuk hanna hinggatkani.” ");
INSERT INTO mni_vpl VALUES ("MK10_35","071_10_35","MRK","10","35","35","Adudagi Zebedee-gi machanupa Jacob amadi John-na Jisugi manakta changlaktuna hairak-i, “Oja Ibungo, Ibungoda eikhoina touhanjaningba eikhoigi pamjaba karigumba khara leijei.” ");
INSERT INTO mni_vpl VALUES ("MK10_36","071_10_36","MRK","10","36","36","Jisuna makhoida hanglak-i, “Nakhoigidamak eina kari toubiba pambage?” ");
INSERT INTO mni_vpl VALUES ("MK10_37","071_10_37","MRK","10","37","37","Makhoina khumlak-i, “Ibungona, Ibungogi matik mangalgi Leibakta, phambalda phamba matamda eikhoibu Ibungoga loinana amana Ibungogi yetta aduga amana Ibungogi oida phamhanbiyu.” ");
INSERT INTO mni_vpl VALUES ("MK10_38","071_10_38","MRK","10","38","38","Jisuna makhoida hairak-i, “Nakhoina hangjariba adu karino haiba nakhoina khangjade. Eihakna thakkadaba awa-anagi tenggot adu nakhoina thakpa ngamgadra? Aduga eina lougadaba awa anagi baptize adu nakhoina louba ngamgadra?” ");
INSERT INTO mni_vpl VALUES ("MK10_39","071_10_39","MRK","10","39","39","Makhoina khumlak-i, “Hoi, eikhoina ngamjagani.” Jisuna makhoida hairak-i, “Achumbamak eina thakpa tenggot adu nakhoina thakkani aduga eibu baptize touba matou aduda nakhoisu tougani. ");
INSERT INTO mni_vpl VALUES ("MK10_40","071_10_40","MRK","10","40","40","Adubu kanana eigi yetta aduga eigi oida phamgadage haibadudi eina haigadaba natte. Adubu masidi makhoigidamak mapham asibu thourangbiraba makhoising adugini.” ");
INSERT INTO mni_vpl VALUES ("MK10_41","071_10_41","MRK","10","41","41","Adudagi atoppa tung-inba tara aduna pao asi tabada Jacob amadi John-gi mathakta saorammi. ");
INSERT INTO mni_vpl VALUES ("MK10_42","071_10_42","MRK","10","42","42","Maduda Jisuna makhoi pumnamakpu mahakki manakta kouraduna hairak-i, “Taibangpanba asigi leingakpani hairibasing aduna misinggi mathakta palli aduga makhoigi luchingbasing aduna makha tabasinggi mathakta pannabagi matik adu lei. ");
INSERT INTO mni_vpl VALUES ("MK10_43","071_10_43","MRK","10","43","43","Adubu nakhoigi naraktadi asumna tougadaba natte. Nakhoigi naraktagi achouba oiningba mahak aduna ateising adugi thougal touba mi oigadabani; ");
INSERT INTO mni_vpl VALUES ("MK10_44","071_10_44","MRK","10","44","44","Aduga nakhoigi naraktagi khwaidagi makok oiningba mahak aduna pumnamakki minai oigadabani. ");
INSERT INTO mni_vpl VALUES ("MK10_45","071_10_45","MRK","10","45","45","Maramdi Migi Machanupa adu phaoba masabu thougal touhannaba lakpa natte adubu misingbu thougal tounanaba aduga mayamgi thadokmal oina mahakki thawai pinabiba lakpani.” ");
INSERT INTO mni_vpl VALUES ("MK10_46","071_10_46","MRK","10","46","46","Adudagi makhoina Jericho-da laklammi, amasung Jisuna mahakki tung-inbasing amadi yamlaba miyamga loinana Jericho-dagi thoklakpada Timaeus-ki machanupa mamit tangba chakniba Bartimaeus-na lambi mapanda phamduna leirammi. ");
INSERT INTO mni_vpl VALUES ("MK10_47","071_10_47","MRK","10","47","47","Aduga lakliba adu Nazareth-ki Jisuni haiba mahakna tarabada, mahakna laoba hourak-i, “David-ki Machanupa Jisu! Eibu chanbiyu!” ");
INSERT INTO mni_vpl VALUES ("MK10_48","071_10_48","MRK","10","48","48","Maduda mi mayam amana mahakpu cheiraduna tuminna leinanaba hairammi. Adubu mahakna hennadum houna laorak-i, “David-ki Machanupa Jisu, eibu chanbiyu!” ");
INSERT INTO mni_vpl VALUES ("MK10_49","071_10_49","MRK","10","49","49","Maduda Jisuna chatlambadagi lepladuna hairak-i, “Mahakpu kourak-u.” Makhoina mamit tangba adubu kouraduna hairak-i, “Haraojaro, hougatlu, Ibungona nahakpu kouri.” ");
INSERT INTO mni_vpl VALUES ("MK10_50","071_10_50","MRK","10","50","50","Maduda mahakna mahakki achonba phi langthoklamduna chongkhatlaga Jisugi manakta lakle. ");
INSERT INTO mni_vpl VALUES ("MK10_51","071_10_51","MRK","10","51","51","Jisuna mangonda hairak-i, “Eina nanggidamak kari toubiba nahakna pambage?” Mamit tangba aduna khumlak-i, “Oja Ibungo, eihakna mit ujaba phangba pamjei.” ");
INSERT INTO mni_vpl VALUES ("MK10_52","071_10_52","MRK","10","52","52","Jisuna mangonda hairak-i, “Chatlu, nahakki thajabana nahakpu phahanbire.” Khudak adumaktada mamit tangba nupa adu uba phangjare amasung Jisugi tung induna lambida chatlibasing aduga loinana mahakna Ibungogi tung injare. ");
INSERT INTO mni_vpl VALUES ("MK11_1","071_11_1","MRK","11","1","1","Jisu amasung mahakki tung-inbasingna Jerusalem naksillaklabada, Chorphon Chinggi manakta leiba Bethphage amasung Bethany-da laklammi. Aduga Ibungona tung-inbasinggi maraktagi makhoi anibu mangjounana tharaduna, ");
INSERT INTO mni_vpl VALUES ("MK11_2","071_11_2","MRK","11","2","2","makhoida hairak-i, “Nakhoigi mangda leiriba khun aduda chatlu, aduga nakhoina maduda hek changbaga mi kana amatana tongdriba lola macha ama punduna leiba thengnagani; madu thouri thoklaga mapham asida purak-u. ");
INSERT INTO mni_vpl VALUES ("MK11_3","071_11_3","MRK","11","3","3","Aduga kanagumbana karigi nakhoina adumna touribano haina hanglaklabadi, ‘Ibungona masi sijinnaba pammi aduga thinthadana mapham asida amuk thilakkani’ haina haiyu.” ");
INSERT INTO mni_vpl VALUES ("MK11_4","071_11_4","MRK","11","4","4","Adudagi makhoina chatkhibada lola macha adu lambi mapanda leiba yumgi thong amagi manakta punduna leiba thengnare. Aduga makhoina thouri adu thoklingeida, ");
INSERT INTO mni_vpl VALUES ("MK11_5","071_11_5","MRK","11","5","5","manak aduwaida leptuna leiramba kharana hanglak-i, “Karigi nakhoina lola macha adugi thouri adu thoklibano?” ");
INSERT INTO mni_vpl VALUES ("MK11_6","071_11_6","MRK","11","6","6","Maduda Jisuna makhoida haikhiba adumak makhoina khumlammi, aduga mising adunasu makhoina loladu puduna chatkhibada yabire. ");
INSERT INTO mni_vpl VALUES ("MK11_7","071_11_7","MRK","11","7","7","Adudagi makhoina lola machadu Jisugi manakta purakladuna madugi mathakta makhoigi phi thare hairaga Ibungona madugi mathakta tongle. ");
INSERT INTO mni_vpl VALUES ("MK11_8","071_11_8","MRK","11","8","8","Aduga mi mayam amana makhoigi phi tingthoktuna lambida tharammi amasung atoppasingna upal-singdagi mana panba anouba masasing kaktuna lambida tharammi. ");
INSERT INTO mni_vpl VALUES ("MK11_9","071_11_9","MRK","11","9","9","Amasung Ibungogi mang tharibasing amadi tung induna chatlibasing aduna laorak-i, “Hosanna! Mapu Ibungogi mingda lengbirakliba Mahak yaiphabani! ");
INSERT INTO mni_vpl VALUES ("MK11_10","071_11_10","MRK","11","10","10","Lakkadouriba, eikhoigi ipa-ipu oiriba David ningthougi leibak adu yaiphabani! Hosanna haina khwaidagi wangba swargada laosanu!” ");
INSERT INTO mni_vpl VALUES ("MK11_11","071_11_11","MRK","11","11","11","Adudagi Jisuna Jerusalem-da thunglabada, Mapugi Sanglenda changduna pumnamak ikoi- koina yenglammi. Adubu matam thengjillaklabada, Ibungona tung-inba taranithoi aduga loinana Bethany-da hallaklammi. ");
INSERT INTO mni_vpl VALUES ("MK11_12","071_11_12","MRK","11","12","12","Mathanggi numitta makhoina Bethany-dagi hallakpada, Ibungo mabuk lamlaklammi. ");
INSERT INTO mni_vpl VALUES ("MK11_13","071_11_13","MRK","11","13","13","Amasung Ibungona athappada mana pungba heiyit pambi ama urabada, madudagi mahei khara phanglabadi haiduna yengnaba changsillammi. Adubu mapham aduda changsinba matamdadi pambi aduda mana nattana mahei amata panba thengnakhide, maramdi matam adu heiyit panbagi pantha oiramde. ");
INSERT INTO mni_vpl VALUES ("MK11_14","071_11_14","MRK","11","14","14","Adudagi Jisuna heiyit pambi aduda hairak-i, “Kana amatana nangondagi mahei amuk hanna chadasanu.” Aduga Ibungona haiba adu tung-inbasing aduna tare. ");
INSERT INTO mni_vpl VALUES ("MK11_15","071_11_15","MRK","11","15","15","Adudagi makhoina Jerusalem-da thunglabada, Jisuna Mapugi Sanglenda changduna maphamduda leiri-yollibasing pumnamakpu tanthokpa houre. Aduga Ibungona sel kaithok kaisin touribasinggi table amadi khunu yollibasinggi phampham adu mathak-makha onthoklammi; ");
INSERT INTO mni_vpl VALUES ("MK11_16","071_11_16","MRK","11","16","16","Amasung misingna Mapugi Sanglen phaoduna potchei puba Ibungona thinglammi. ");
INSERT INTO mni_vpl VALUES ("MK11_17","071_11_17","MRK","11","17","17","Adudagi Ibungona makhoibu tambiraduna hairak-i, “Eigi yumbu mioi kanglup pumnamakki haijabagi yum kougani haina Mapugi puyada iduna leiba nattra? Adubu nakhoina masibu huranbasinggi makon onthokle!” ");
INSERT INTO mni_vpl VALUES ("MK11_18","071_11_18","MRK","11","18","18","Athoiba purohitsing amadi Wayel Yathanggi ojasingna hairibasing adu tabada Jisubu hatnanaba lambi thiba houre, maramdi Ibungogi tambiba aduna miyam pumnamakpu sumhatpagi maramna makhoina Ibungobu kirammi. ");
INSERT INTO mni_vpl VALUES ("MK11_19","071_11_19","MRK","11","19","19","Adudagi numidangwairam oiraklabada Jisu amadi mahakki tung-inbasingna sahar adudagi chatkhirammi. ");
INSERT INTO mni_vpl VALUES ("MK11_20","071_11_20","MRK","11","20","20","Mathang numitki ayukta makhoina lambida asum lakpada heiyit pambi adu marudagi houna pumkang kangsillamba makhoina ure. ");
INSERT INTO mni_vpl VALUES ("MK11_21","071_11_21","MRK","11","21","21","Maduda Peter-na thokkhiba thoudoktu ningsinglaktuna Jisuda hairak-i, “Yengbiyu, Oja Ibungo, Ibungona mang taknaba haikhiba heiyit pambi asi kangsillamle.” ");
INSERT INTO mni_vpl VALUES ("MK11_22","071_11_22","MRK","11","22","22","Jisuna makhoida khumlak-i, “Tengban Mapuda thajou, ");
INSERT INTO mni_vpl VALUES ("MK11_23","071_11_23","MRK","11","23","23","Eina nakhoida tasengnamak hairibasini, kanagumbana chingjao asida, nasa nathanta phuktuna patta langthajou hairaga, mahakki thammoida chingnaba amata leitraba amasung mahakna hairiba adumak thokkani haiba mahakna thajarabadi, madumak mangonda oirakkani. ");
INSERT INTO mni_vpl VALUES ("MK11_24","071_11_24","MRK","11","24","24","Maram asina eina nakhoida hairi, nakhoina haija-nijaba matamda nijariba adumak nakhoina phangle haina thajou, adu oirabadi nakhoina nijariba khudingmak adu nakhoida pinabigani. ");
INSERT INTO mni_vpl VALUES ("MK11_25","071_11_25","MRK","11","25","25","Aduga nakhoina leptuna haija-nijaba matamda nakhoina toujakhiba ayol arandu swargada leiba nakhoigi Napa Ibungona kokpinanaba, kanagumbagi mathakta nakhoigi nungaitaba leirabadi mahakpu kokpiyu. ");
INSERT INTO mni_vpl VALUES ("MK11_26","071_11_26","MRK","11","26","26","Adubu nahakna mahakpu kokpidrabadi, swargada leiba nakhoigi Ipanasu nakhoigi ayol-aral kokpiroi.” ");
INSERT INTO mni_vpl VALUES ("MK11_27","071_11_27","MRK","11","27","27","Jisu amasung mahakki tung-inbasingna amuk hanna Jerusalem-da laklammi. Aduga Jisuna Mapugi Sanglen manungda chatligeida athoiba purohitsing, Wayel Yathanggi ojasing amadi ahal lamansingna Ibungogi manakta laktuna ");
INSERT INTO mni_vpl VALUES ("MK11_28","071_11_28","MRK","11","28","28","Ibungoda hanglak-i, “Nahakki karamba matik leiduna asigumba thabaksing asi touribano? Aduga kanana thabaksing asi tounaba matik asi nangonda pibage?” ");
INSERT INTO mni_vpl VALUES ("MK11_29","071_11_29","MRK","11","29","29","Jisuna makhoida khumlak-i, “Eisu nakhoida wahang ama hangge, nakhoina madugi paokhum eingonda piragadi eigi karamba itik leiduna asigumba thabaksing asi touribano haibadu eina nakhoida haige. ");
INSERT INTO mni_vpl VALUES ("MK11_30","071_11_30","MRK","11","30","30","John-da leiriba baptize tounabagi matik adu Mapu Ibungodagira nattraga misingdagira? Eingonda khummu.” ");
INSERT INTO mni_vpl VALUES ("MK11_31","071_11_31","MRK","11","31","31","Makhoina kari khumgadage haibadu makhoi masel khannarammi. “Eikhoina swargadagini haina khumlagadi, mahakna haigani, ‘Adu oirabadi nakhoina John-bu karigi thajadribano?’ ");
INSERT INTO mni_vpl VALUES ("MK11_32","071_11_32","MRK","11","32","32","Aduga amaromda eikhoina madu misingdagini hairagadi, eikhoi khudong thibasu yai.” Makhoina misingbu kirammi maramdi mi pumnamakna John-bu Mapu Ibungogi wa phongdokpiba maichou amani haina lounarammi. ");
INSERT INTO mni_vpl VALUES ("MK11_33","071_11_33","MRK","11","33","33","Maram aduna makhoina Jisuda khumlak-i, “Eikhoi khangde.” Maduda Jisuna makhoida hairak-i, “Adu oirabadi, eigi karamba itik leiduna asigumba thabaksing asi touribano haibadu einasu nakhoida hairaroi.” ");
INSERT INTO mni_vpl VALUES ("MK12_1","071_12_1","MRK","12","1","1","Adudagi Jisuna pandam piduna makhoida tambiba hourak-i, “Nupa amana anggur ingkhol ama koirammi. Madugi akoibada mahakna sambal khare, aduga anggur mahi sumnaba kom ama toure, amasung ingkhol ngaknaba awangba loutangsang amasu sare. Madudagi mahakna anggur ingkhol adu ingkhol koiba misingda sandoklamlaga atoppa lam amada chatkhre. ");
INSERT INTO mni_vpl VALUES ("MK12_2","071_12_2","MRK","12","2","2","Aduga mahei lokpagi matam youraklabada mahakna mahakki minai amabu ingkhol koibasing adudagi mahakki phangpham thokpa saruk lourunaba thare. ");
INSERT INTO mni_vpl VALUES ("MK12_3","071_12_3","MRK","12","3","3","Adubu ingkhol koibasing aduna minai adubu phaduna phuraga khut hangna halhankhre. ");
INSERT INTO mni_vpl VALUES ("MK12_4","071_12_4","MRK","12","4","4","Adudagi mapu aduna atoppa minai ama amuk thare, madusu ingkhol koibasing aduna makok thugaibire aduga ikaiba piduna thina toubire. ");
INSERT INTO mni_vpl VALUES ("MK12_5","071_12_5","MRK","12","5","5","Amuk hanna mapu aduna atoppa minai amaga amuk tharabada makhoina mahakpu hatle. Asumna makhoina, mapu aduna tharakpa atoppa minai kayabu, kharana phubire aduga kharabuna hatle. ");
INSERT INTO mni_vpl VALUES ("MK12_6","071_12_6","MRK","12","6","6","Aduga houjik nupa adugi thananaba leihouriba haibabu mahakki nungsijaraba machanupa aduta ngaihoure. Ikon konbada, ‘Makhoina eigi ichanupabudi ikai khumnabigani’ haina mahakna khalladuna machanupa adubu makhoigi manakta thare. ");
INSERT INTO mni_vpl VALUES ("MK12_7","071_12_7","MRK","12","7","7","Adubu ingkhol koibasing aduna amaga amaga hainarammi, ‘Mahak asi yumlep charani, lak-o, eikhoina mahakpu hatlasi, adu oirabadi mahakki phangpham thokpa lanthum asi eikhoigi oihouragani!’ ");
INSERT INTO mni_vpl VALUES ("MK12_8","071_12_8","MRK","12","8","8","Adudagi makhoina mahakpu phaduna hatlaga anggur ingkholgi wangmada hundokle. ");
INSERT INTO mni_vpl VALUES ("MK12_9","071_12_9","MRK","12","9","9","“Matamduda anggur ingkholgi mapu aduna kari tougadage? Mahakna laktuna ingkhol koibasing adubu hatkani aduga anggur ingkhol adu atoppasingda pithokkani. ");
INSERT INTO mni_vpl VALUES ("MK12_10","071_12_10","MRK","12","10","10","Nakhoina Mapugi puyada masi pakhidabra? ‘Yumsabasingna kanadre haiduna hundoklaba nung adu Oirakle khwaidagi maruoiba chithekki nung. ");
INSERT INTO mni_vpl VALUES ("MK12_11","071_12_11","MRK","12","11","11","Mapu Ibungona masi toubire, Eikhoigi mityengda masi kayada angakpano!’ ” ");
INSERT INTO mni_vpl VALUES ("MK12_12","071_12_12","MRK","12","12","12","Maduda Jihudigi luchingbasing aduna Jisubu phananaba hotnarammi, maramdi Ibungona pandam adu makhoigi maiyokta haibani haiba makhoi khanglammi. Adubu makhoina miyam adubu kiba maramna Ibungobu thadoktuna chatkhre. ");
INSERT INTO mni_vpl VALUES ("MK12_13","071_12_13","MRK","12","13","13","Madugi matungda Jisugi waheida asoiba thiduna mahakpu phananaba Pharisee amadi Herod-ki misingdagi mi kharabu Jisugi manakta tharakle. ");
INSERT INTO mni_vpl VALUES ("MK12_14","071_12_14","MRK","12","14","14","Amasung makhoina Ibungogi manakta laktuna hairak-i, “Oja, nahakna mina kari khanbage haiba karisu kiba toudana achumba adutamak ngang-i. Nahakna misak mimai yengde; adubu Tengban Mapugi lambi adu chumna tambi. Eikhoida haibiyu, Caesar-da eikhoina kanggat thiba asi eikhoigi Wayelgi maiyoktara nattraga nattabra?” ");
INSERT INTO mni_vpl VALUES ("MK12_15","071_12_15","MRK","12","15","15","Eikhoina masi makhoida thipham thokpra nattraga thoktabra? Maduda makhoigi aphasasinnaba adu Jisuna khangladuna makhoida khumlak-i, “Nakhoina eibu karigi chang yenglibano? Eingonda dinari ama puraktuna utlu.” ");
INSERT INTO mni_vpl VALUES ("MK12_16","071_12_16","MRK","12","16","16","Makhoina madu Ibungoda purakle. Adudagi Ibungona hanglak-i, “Sel mayek asida namliba saktam amadi maming asi kanagino?” Makhoina khumlak-i, “Caesar-gini.” ");
INSERT INTO mni_vpl VALUES ("MK12_17","071_12_17","MRK","12","17","17","Adudagi Jisuna makhoida hairak-i, “Phare, adu oirabadi Caesar-gi oiba aduna Caesar-da aduga Tengban Mapugi oiba aduna Mapu Ibungoda piyu.” Amasung Ibungogi paokhum aduda makhoi pumngak ngaklammi. ");
INSERT INTO mni_vpl VALUES ("MK12_18","071_12_18","MRK","12","18","18","Adudagi sibadagi hinggatpa haibasi leite hairiba Sadducee-sing kharana Jisugi manakta laktuna hairak-i, ");
INSERT INTO mni_vpl VALUES ("MK12_19","071_12_19","MRK","12","19","19","“Oja Ibungo, Moses-na eikhoigidamak yathang asi ibirammi madudi, ‘Kanagumba nupa amana macha amata thamlamdana magi nupibu thanamlaga sikhiba thoklabadi, hairiba nupa asigi charol-surol thamlamnabagidamak magi machin manaona lukhrabi asibu amuk lougadabani.’ ");
INSERT INTO mni_vpl VALUES ("MK12_20","071_12_20","MRK","12","20","20","Adu oirabadi, nupa amagi machin manao taret leirammi. Adudagi mayamba ahal adu nupi thire adubu macha amata thamamdana sire. ");
INSERT INTO mni_vpl VALUES ("MK12_21","071_12_21","MRK","12","21","21","Aduga nupi adu machin-manao anisuba aduna amuk loure adubu mahaksu macha amata thamlamdana sire. Masiga chap manana ahumsuba adudasu thokle. ");
INSERT INTO mni_vpl VALUES ("MK12_22","071_12_22","MRK","12","22","22","Asumna makhoi taretmakna nupi adubu louramlaga macha amata thamlamdana sire. Aduga ikon konbada nupi adusu sire. ");
INSERT INTO mni_vpl VALUES ("MK12_23","071_12_23","MRK","12","23","23","Houjik, hinggatpagi numit aduda makhoina amuk hougatlakpa matamda nupi asi kanagi nupi oigadage? Maramdi makhoi taretmakna nupi adubu lourammi.” ");
INSERT INTO mni_vpl VALUES ("MK12_24","071_12_24","MRK","12","24","24","Jisuna makhoida khumlak-i, “Nakhoina Mapugi puya amadi Tengban Mapugi panggal adu khangdabagi maramna nakhoibu lalhallaba nattra? ");
INSERT INTO mni_vpl VALUES ("MK12_25","071_12_25","MRK","12","25","25","Maramdi asibasingna amuk hougatlakpa matamduda makhoina amuk luhonglaroi aduga luhongnabagidamaktasu thajararoi adubu makhoi swargada leiba swargadutsinggumna oigani. ");
INSERT INTO mni_vpl VALUES ("MK12_26","071_12_26","MRK","12","26","26","Aduga asibasingna hinggatpagi maramda Moses-gi lairikta yaoriba mei chakpa mongsonggi wari aduda Tengban Mapuna Moses-ta kari haikhibage haibadu nakhoi padabra? Tengban Mapuna Moses-ta hai, ‘Eidi Abraham-gi Tengban Mapu, Isaac-ki Tengban Mapu, amasung Jacob-ki Tengban Mapuni.’ ");
INSERT INTO mni_vpl VALUES ("MK12_27","071_12_27","MRK","12","27","27","Mahakti asibasinggi Mapu Ibungo natte, adubu ahingbasinggi Mapu Ibungoni. Aduna nakhoi yamna lalle.” ");
INSERT INTO mni_vpl VALUES ("MK12_28","071_12_28","MRK","12","28","28","Wayel Yathanggi Ojasinggi maraktagi amana mapham aduda leptuna makhoina khannariba adu taduna leirammi. Aduga Jisuna saducee-singda phajana paokhumkhibadu mahakna taraduna Ibungoda hanglak-i, “Mapu Ibungogi yathangsinggi maraktagi karamba yathangna khwaidagi athoibano?” ");
INSERT INTO mni_vpl VALUES ("MK12_29","071_12_29","MRK","12","29","29","Jisuna khumlak-i, “Khwaidagi athoiba Mapu Ibungogi yathangdu asini, ‘Tao, he Israel, eikhoigi Tengban Mapu, MAPU IBUNGO-di amakhakta ngairaba MAPU IBUNGO-ni. ");
INSERT INTO mni_vpl VALUES ("MK12_30","071_12_30","MRK","12","30","30","Nahakna nahakki Tengban Mapu, MAPU IBUNGO-bu nahakki thamoi apumba, thawai apumba, pukning apumba amadi panggal apumba yaona nungsigadabani.’ ");
INSERT INTO mni_vpl VALUES ("MK12_31","071_12_31","MRK","12","31","31","Aduga anisuba athoiba yathang aduna asini, ‘Nahakna nahakki yumlon-keironnabasingbu nasamakkum nungsigadabani.’ Mapu Ibungogi yathang ani asidagi henba athoiba yathang atoppa ama leitre.” ");
INSERT INTO mni_vpl VALUES ("MK12_32","071_12_32","MRK","12","32","32","Wayel Yathanggi Oja aduna Jisuda hairak-i, “Ningthijana khumbire, Oja! Nahakna haibagumna masi achumbani, Mahakkhaktana Mapu Ibungoni, aduga mahak nattana atei atoppa amata leite. ");
INSERT INTO mni_vpl VALUES ("MK12_33","071_12_33","MRK","12","33","33","Aduga Mapu Ibungobu thammoi apumba, pukning apumba amadi panggal apumba yaona amasung yumlon-keironabasingbu masamakkum nungsigadabani. Masigi yathang ani asi inbana meida thaduna katpa iratpot amadi atei iratpotsingdagi henna maru-oi.” ");
INSERT INTO mni_vpl VALUES ("MK12_34","071_12_34","MRK","12","34","34","Mahakna wakhan tana paokhum pirakpadu urabada Jisuna mangonda hairak-i, “Nahak Mapu Ibungogi leibak adudagi laptre.” Masigi matungda kana amatana Jisuda atei wahang ama amuk hangnabagi thouna leikhidre. ");
INSERT INTO mni_vpl VALUES ("MK12_35","071_12_35","MRK","12","35","35","Adudagi Jisuna Mapugi Sanglen-gi manggolda tambiringeida makhoida wahang ama hanglak-i, “Christta adu David-ki machanupani haina Wayel Yathanggi Ojasingna matou karamna hairibano? ");
INSERT INTO mni_vpl VALUES ("MK12_36","071_12_36","MRK","12","36","36","Maramdi Thawai Asengbagi mapanna David masamakna haikhi, ‘MAPU IBUNGO-na eigi Mapu Ibungoda hai, Phammu, eigi yetthangbada nahakna, Thamdriphaoba eina nahakki yeknabasingbu, nanggi nakhong makhada.’ ");
INSERT INTO mni_vpl VALUES ("MK12_37","071_12_37","MRK","12","37","37","David masamakna phaoba mangonda ‘Mapu Ibungo’ haina kourabadi Christta adu David-ki machanupa kamdouna oiribano?” Yamlaba miyam aduna Ibungogi wa adu haraona tarammi. ");
INSERT INTO mni_vpl VALUES ("MK12_38","071_12_38","MRK","12","38","38","Aduga Jisuna makhoibu tambiraduna hairak-i, “Wayel Yathanggi Ojasing adudagi cheksillu. Makhoina achonba phi settuna koina chatpa amadi keithelnachingba miyam tinba maphamda misingna makhoibu ikai khumnabaga loinana koubirakpa adu pammi. ");
INSERT INTO mni_vpl VALUES ("MK12_39","071_12_39","MRK","12","39","39","Aduga Jihudisinggi tinnapham sanglen synagogue-singda akhannaba phamphamda phamba amadi chakkhangphamda ikaikhumnaba misinggi phamphamda phamba makhoina pammi. ");
INSERT INTO mni_vpl VALUES ("MK12_40","071_12_40","MRK","12","40","40","Makhoina lukhrabisingdagi khudongchaba louduna mayum-makei mulli, aduga misingna unanaba tousinaduna Mapu Ibungoda haijaba adu sangna haijei. Asigumba mising asina henna kanba cheirak phanggani.” ");
INSERT INTO mni_vpl VALUES ("MK12_41","071_12_41","MRK","12","41","41","Adudagi Jisuna Mapugi Sanglengi sel katpham manakta phamduna miyam aduna sel katchaba adu yenglammi. Inakkhunba mi kaya amadi sel yamna yamna katlammi; ");
INSERT INTO mni_vpl VALUES ("MK12_42","071_12_42","MRK","12","42","42","aduga lairabi lukhrabi amasu laktuna apikpa korigi selmayek ani katlare. ");
INSERT INTO mni_vpl VALUES ("MK12_43","071_12_43","MRK","12","43","43","Adudagi Ibungona magi tung-inbasingbu manakta kousilladuna hairak-i, “Eina nakhoida tasengnamak hairibasini, lairabi lukhrabi asina atei pumnamaktagi khwaidagi henna sel katchare. ");
INSERT INTO mni_vpl VALUES ("MK12_44","071_12_44","MRK","12","44","44","Maramdi ateising asina makhoigi marangkaiba lan-geidagi saruk khara katle; adubu nupi asinadi lairajarabasu mahakki leijaba pumnamak, haibadi mahakki hingbada changliba areiba pumba katchare.” ");
INSERT INTO mni_vpl VALUES ("MK13_1","071_13_1","MRK","13","1","1","Adudagi Jisuna Mapugi Sanglendagi thorakpada, mahakki tung-inbasinggi maraktagi amana hairak-i, “Yengbiyu Oja Ibungo! Kayada ningthijakhraba nungsing amadi sangsingno?” ");
INSERT INTO mni_vpl VALUES ("MK13_2","071_13_2","MRK","13","2","2","Jisuna khumlak-i, “Nahakna chaoraba sangsing asi ubra? Masi pumnamaksing asi thugaiduna manghan-gani, ningkhaidaba lonnaba nung amata phaoba maphamsida thanamloi.” ");
INSERT INTO mni_vpl VALUES ("MK13_3","071_13_3","MRK","13","3","3","Adudagi Jisuna Mapugi Sanglen-ga maiyoknana, Chorphon chingthakta phamlingeida Peter, Jacob, John amadi Andrew-na Ibungogi manakta laktuna lonna hanglak-i, ");
INSERT INTO mni_vpl VALUES ("MK13_4","071_13_4","MRK","13","4","4","“Masi pumnamaksing asi karamba matamda thokkadage? Aduga hairibasing asi thokadaba matamdu lakle haibagi khudamsing aduna karino haibadu eikhoida haibiyu.” ");
INSERT INTO mni_vpl VALUES ("MK13_5","071_13_5","MRK","13","5","5","Jisuna makhoida hairak-i, “Kananasu nakhoibu lanna lamjingdanaba cheksillu. ");
INSERT INTO mni_vpl VALUES ("MK13_6","071_13_6","MRK","13","6","6","Maramdi mi kaya amana eigi mingda laktuna haigani, ‘Ei Christtani!’ aduga makhoina mi kaya amabu lanna lamjinggani. ");
INSERT INTO mni_vpl VALUES ("MK13_7","071_13_7","MRK","13","7","7","Amasung nakhoina lan amasung lan-gi paoninkhol tagani adubu mipaiganu. Asigumba thoudoksing asi soidana thokkani, adubu aroiba matam adudi thoudoksing asi hek thokpagadi lakloi. ");
INSERT INTO mni_vpl VALUES ("MK13_8","071_13_8","MRK","13","8","8","Maramdi mioi kanglup amana mioi kanglup amagi mathakta; aduga ningthou leibak amana ningthou leibak amagi mathakta lan hourakkani; aduga malemgi tongan tonganba mapham kayada yuhar haba amadi chak tangba thokkani. Pumnamaksing asi naoyekpa hek hourakpagi ahanba cheinakhol adugumbani. ");
INSERT INTO mni_vpl VALUES ("MK13_9","071_13_9","MRK","13","9","9","“Nakhoi nasana nasabu cheksinjou! Maramdi makhoina nakhoibu phaduna wayelsangda pukhatkani. Synagogue-singda makhoina nakhoibu phugani; eigi maramgidamak nakhoina leingakpasing amasung ningthousinggi mamangda eibu thajabagi maramda sakhi pinanaba lepkani. ");
INSERT INTO mni_vpl VALUES ("MK13_10","071_13_10","MRK","13","10","10","Adubu aroiba matam adu laktringeigi mamangda malemgi mioi kanglup khudingmakki mioi pumnamakta Aphaba Pao sandokkani. ");
INSERT INTO mni_vpl VALUES ("MK13_11","071_13_11","MRK","13","11","11","Aduga makhoina nakhoibu phaduna wayelsangda pukhatpa matamda nakhoina kari haigadage haibagidamak hanna karisu waruganu; adubu pungpham aduna lakpada nakhoigi thammoida khanghan khanghanbiba adu haiyu. Maramdi nakhoina nganggadouriba wa adu nakhoidagi natte, adubu Thawai Asengbadagini. ");
INSERT INTO mni_vpl VALUES ("MK13_12","071_13_12","MRK","13","12","12","Aduga machin manaona machin manaobu hat-hannaba pithokkani, matou asigumna mapana machasingbusu pithokkani amasung machasingna mama-mapagi maiyokta leptuna makhoibu hat-han-gani. ");
INSERT INTO mni_vpl VALUES ("MK13_13","071_13_13","MRK","13","13","13","Mi pumnamakna eigi maramgidamak nakhoibu yengthigani. Adubu aroiba phaoba chetna lepchaba mahak adubu kanbigani. ");
INSERT INTO mni_vpl VALUES ("MK13_14","071_13_14","MRK","13","14","14","“Aduga Mapu Ibungogi wa phongdokpa maichou Daniel-na haikhibagumna Mapugi Sanglenbu mang-han tak-hanba thok-halliba tukkachaningai oiba mahak aduna mahakna leppham thoktaba maphamda leppa nakhoina uba matamda (Apaba mahak aduna khangsanu), Judea-da leiba makhoising adu chingda chenkhisanu. ");
INSERT INTO mni_vpl VALUES ("MK13_15","071_13_15","MRK","13","15","15","Yumthakta leiba mahak aduna imungda amuk kumthaduna mahakki punanaba pot louduna matam manghandasanu. ");
INSERT INTO mni_vpl VALUES ("MK13_16","071_13_16","MRK","13","16","16","Loubukta leiba mahak adunasu maphi lounanaba mayumda amuk halaktasanu. ");
INSERT INTO mni_vpl VALUES ("MK13_17","071_13_17","MRK","13","17","17","Adubu numitsing aduda mironlibising amasung chajenlibisinggidamakti kayada awaba oiragaba! ");
INSERT INTO mni_vpl VALUES ("MK13_18","071_13_18","MRK","13","18","18","Hairibasing asi ningthamthada thoktanaba Mapu Ibungoda haijou. ");
INSERT INTO mni_vpl VALUES ("MK13_19","071_13_19","MRK","13","19","19","Maramdi numitsing adu adukki matik awaba oigani, madudi Tengban Mapuna malem hek leisemlakpadagi matam asi phaobada asigumba awa ana amukta thokkhidri. Aduga asigumna waba asi amuk hannasu thoklaroi. ");
INSERT INTO mni_vpl VALUES ("MK13_20","071_13_20","MRK","13","20","20","Aduga Mapu Ibungona numitsing adu kaksinbiba nattanadi mi kana amata hinglamloidabani. Adumakpu, khan-gatpikhraba makhoigidamak, Mapu Ibungona numitsing adu kaksinbikhre. ");
INSERT INTO mni_vpl VALUES ("MK13_21","071_13_21","MRK","13","21","21","“Matam aduda kanagumbana, ‘Yeng-u, Christta asida leire,’ nattraga ‘Christta aduda leire’ haina hairaklabadi, nakhoina maduda thajaganu. ");
INSERT INTO mni_vpl VALUES ("MK13_22","071_13_22","MRK","13","22","22","Maramdi Christta sasinnaba amadi Mapu Ibungogi wa phongdoksannaba kaya thorakkani. Makhoina angakpa khudam amadi angakpa thabak kaya touduna, ngamlabadi Mapu Ibungona khangatkhrabasing adu phaoba lanna lamjinggani. ");
INSERT INTO mni_vpl VALUES ("MK13_23","071_13_23","MRK","13","23","23","Nakhoi cheksillu, eina nakhoida pumnamaksing asi mangjounana haire. ");
INSERT INTO mni_vpl VALUES ("MK13_24","071_13_24","MRK","13","24","24","“Aduga awa anagi numitsing adugi matungda numitna mamsin-gani, thana amuk hanna ngallaroi, ");
INSERT INTO mni_vpl VALUES ("MK13_25","071_13_25","MRK","13","25","25","thawanmichaksingna nongdon atiyadagi tarakkani, aduga nongdon atiyagi panggalsingbu kanna nik-han-gani. ");
INSERT INTO mni_vpl VALUES ("MK13_26","071_13_26","MRK","13","26","26","Aduga matam aduda Migi Machanupa aduna thoihellaba panggal amadi matik mangalga loinana leichinda lenglakpa mipum khudingmakna ugani. ");
INSERT INTO mni_vpl VALUES ("MK13_27","071_13_27","MRK","13","27","27","Adudagi Ibungona swargadutsingbu malemgi maikei marida thaduna Ibungona khan-gatkhrabasingbu atiya amadi malemgi mapham khudingmaktagi khomjin-gani. ");
INSERT INTO mni_vpl VALUES ("MK13_28","071_13_28","MRK","13","28","28","“Houjik heiyit pambidagi nakhoina pandam asi khangjillu. Upal asigi masasingda yening hullaktuna manasing panba houraklabada nakhoina kalentha naksillakle haiba khang-i. ");
INSERT INTO mni_vpl VALUES ("MK13_29","071_13_29","MRK","13","29","29","Matou asumna nakhoina thoudoksing asi thoklakpa urabadi matam adu naksillakle, thongjin yousillakle haiba khang-u. ");
INSERT INTO mni_vpl VALUES ("MK13_30","071_13_30","MRK","13","30","30","Eina nakhoida tasengnamak hairibasini, mirol asina houkhidringei mamangda thoudok pumnamak asi thokkani. ");
INSERT INTO mni_vpl VALUES ("MK13_31","071_13_31","MRK","13","31","31","Atiya amadi malemdi mangkhigani adubu Eigi waheisingdi keidounungda manglaroi. ");
INSERT INTO mni_vpl VALUES ("MK13_32","071_13_32","MRK","13","32","32","“Aduga karamba matamda numit adu, aduga pungpham adu lakkadage haiba mi kana amatana khangde, swargada leiba swargadutsingnasu aduga Machanupa adunasu khangde, adubu Mapa adukhaktana khang-i. ");
INSERT INTO mni_vpl VALUES ("MK13_33","071_13_33","MRK","13","33","33","Cheksillu, mitseng khang-u amasung haijou, maramdi matam adu keidoungei oigadage haiba nakhoina khangde. ");
INSERT INTO mni_vpl VALUES ("MK13_34","071_13_34","MRK","13","34","34","Masi mahakki manaisingda thoudang pumnamak sinnaramlaga, magi magi tounanaba thabak piramlaba matungda, thongngakpa aduda mitseng khangnaba hairamlaga mayum thadoktuna langphei chatkhiba yumbu amagumbani. ");
INSERT INTO mni_vpl VALUES ("MK13_35","071_13_35","MRK","13","35","35","Aduna mitseng khang-u, maramdi yumbu aduna karamba matamda hallakadage haiba nakhoina khangde, madu numidangda nattraga ahing nongyaida nattraga chingkhei hullakpada nattraga ayukki matamda oibasu yai. ");
INSERT INTO mni_vpl VALUES ("MK13_36","071_13_36","MRK","13","36","36","Aduga mahakna khanghoudana hallakpada, nakhoina tumba mahakna thengnahan-ganu. ");
INSERT INTO mni_vpl VALUES ("MK13_37","071_13_37","MRK","13","37","37","Aduna eina nakhoida hairiba asi eina pumnamakta hairibani, ‘Mitseng khang-u.’ ” ");
INSERT INTO mni_vpl VALUES ("MK14_1","071_14_1","MRK","14","1","1","Matamdu Lanthokpibagi Chakkhangba amasung Hamei Yaodaba Talgi Chakkhangba kumhei pangthokkadaba numit nini watlingei matam oirammi. Athoiba purohitsing amadi Wayel Yathanggi Ojasingna lonna Jisubu phananaba amadi hatnanaba khudongchaba yengduna leirammi. ");
INSERT INTO mni_vpl VALUES ("MK14_2","071_14_2","MRK","14","2","2","Adubu Chakkhangbagi kumhei manungda madu tourabadi miyamna irang hourakpa yabagi maramna makhoina madu kumhei pangthoklingei manungda toudananaba hainarammi. ");
INSERT INTO mni_vpl VALUES ("MK14_3","071_14_3","MRK","14","3","3","Jisuna Bethany-da leiringeida, yamna kiningai oiraba unsagi lainana naramba mi ama Simon-gi yumda leirammi. Amasung Jisuna charingeida nupi amana asengba nard-na semba tanglaba, manam nungsiraba teinathao thanna yaoba alabaster kouba nungouna saba chaphu ama puduna laklammi. Aduga mahakna chaphu adu thugairaduna hangdoklaga manam nungsiraba teinathao adu Ibungogi kokthakta heithabirammi. ");
INSERT INTO mni_vpl VALUES ("MK14_4","071_14_4","MRK","14","4","4","Maduda mapham aduda leiriba mi kharadi saoraduna amaga amaga hainarak-i, “Manam nungsiraba teinathao asi mang-hanbagi kari kanaba leibage? ");
INSERT INTO mni_vpl VALUES ("MK14_5","071_14_5","MRK","14","5","5","Masi yollamlabadi denarii chahumdagi henna yollamgadabani aduga sel aduna lairabasingda pinaramba yarambani!” Aduna makhoina nupi adubu minungsi leitana cheirammi. ");
INSERT INTO mni_vpl VALUES ("MK14_6","071_14_6","MRK","14","6","6","Adubu Jisuna hairak-i, “Mahakki apamba adu adum toujasanu, nakhoina mangonda karigi yetlibano? Mahakna eihakkidamak yamna phaba amadi phajaraba thabak ama toubire. ");
INSERT INTO mni_vpl VALUES ("MK14_7","071_14_7","MRK","14","7","7","Maramdi nakhoina lairabasingga matam pumnamakta loinadunata lei, aduga nakhoina hek pamba matam amada hekta nakhoina makhoibu mateng pangbasu yai. Adubu eidi nakhoiga matam pumnamakta leiminnaroi. ");
INSERT INTO mni_vpl VALUES ("MK14_8","071_14_8","MRK","14","8","8","Mahakna touba ngamjaba adu mahakna toukhre; mahakna eigi hakchangda manam nungsiraba teinathao asi heibiduna mangjounana eibu leirol channabagidamak thourang toujare. ");
INSERT INTO mni_vpl VALUES ("MK14_9","071_14_9","MRK","14","9","9","Houjik, eina nakhoida tasengnamak hairibasini, Aphaba Pao sandokpa malemgi mapham khudingda, mahakpu ningsingba oina mahakna toukhiba adu phongdokkani.” ");
INSERT INTO mni_vpl VALUES ("MK14_10","071_14_10","MRK","14","10","10","Adudagi, tung-inba taranithoi adugi ama oiriba Judas Iscariot-na Jisubu athoiba purohitsingda pithoknanabagidamak makhoigi manakta chatlammi. ");
INSERT INTO mni_vpl VALUES ("MK14_11","071_14_11","MRK","14","11","11","Makhoina mahakna haiba adu tabada haraorammi amasung mangonda sel pigani haiduna wasaklammi. Adudagi Judas-na Jisubu makhoida pithoknabagi achaba tanja yengba hourammi. ");
INSERT INTO mni_vpl VALUES ("MK14_12","071_14_12","MRK","14","12","12","Hamei Yaodaba Talgi Chakkhangbagi ahouba numit, Lanthokpibagi Chakkhangbagi yaomachasing hatpa numit aduda, Jisugi tung-inbasingna Ibungoda hanglak-i, “Eikhoina kadaida chattuna Ibungogidamak Lanthokpibagi Chakkhangbagi chaklen adu thourang toujaba Ibungona pambibage?” ");
INSERT INTO mni_vpl VALUES ("MK14_13","071_14_13","MRK","14","13","13","Adudagi Jisuna tung-inbasinggi maraktagi makhoi ani tharaduna hairak-i, “Nakhoina sahar aduda chatlu, aduga nakhoina ising pun puba nupa ama thengnagani. Mahakki tung illu. ");
INSERT INTO mni_vpl VALUES ("MK14_14","071_14_14","MRK","14","14","14","Aduga mahakna changba yum adugi yumbu aduda haiyu, ‘Oja Ibungona hairi, Eina eihakki tung-inbasingga loinana Lanthokpibagi Chakkhangba chagadaba ka adu kadaidano?’ ");
INSERT INTO mni_vpl VALUES ("MK14_15","071_14_15","MRK","14","15","15","Adudagi mahakna, sem-saduna thourang pumnamak loiraba, chaoraba mathakki ka ama nakhoida utlakkani. Mapham aduda eikhoigidamak chaklen thourang tou.” ");
INSERT INTO mni_vpl VALUES ("MK14_16","071_14_16","MRK","14","16","16","Adudagi tung-inbasing aduna mapham adu thadoktuna sahar aduda chatkhraga Ibungona makhoida haikhibagumna pumnamaksing adu makhoina thengnarammi; amasung makhoina maphamduda Lanthokpibagi Chakkhangbagi chaklen thourang toure. ");
INSERT INTO mni_vpl VALUES ("MK14_17","071_14_17","MRK","14","17","17","Numidang matam oiraklabada, Jisuna tung-inba taranithoi aduga loinana lakle. ");
INSERT INTO mni_vpl VALUES ("MK14_18","071_14_18","MRK","14","18","18","Aduga makhoina phamduna charingeida, Jisuna hairak-i, “Eina nakhoida tasengnamak hairibasini, eiga chaminariba nakhoigi naraktagi amana eihakpu pithokkadouri.” ");
INSERT INTO mni_vpl VALUES ("MK14_19","071_14_19","MRK","14","19","19","Maduda makhoi mapukning warammi. Amasung makhoina Ibungoda amamamta oina mathang mathang hanglak-i, “Madu eira?” ");
INSERT INTO mni_vpl VALUES ("MK14_20","071_14_20","MRK","14","20","20","Jisuna khumlak-i, “Nakhoi taranithoigi maraktagi eihakka loinana tenggotta tal lupminariba mahaknani. ");
INSERT INTO mni_vpl VALUES ("MK14_21","071_14_21","MRK","14","21","21","Mapugi Puyada haikhibagumna Migi Machanupa adu sigani adubu Migi Machanupa adubu pithokpa mahak adudi kayada awaba oigadaba! Mahakkidamakti mahak poklamdabana henna pharamgadabani!” ");
INSERT INTO mni_vpl VALUES ("MK14_22","071_14_22","MRK","14","22","22","Makhoina charingeida, Jisuna tal ama louduna Mapu Ibungobu thagatcharaga machet machet setladuna mahakki tung-inbasingda piraga hairak-i, “Tal asi louduna chao, masi eigi hakchangni.” ");
INSERT INTO mni_vpl VALUES ("MK14_23","071_14_23","MRK","14","23","23","Amasung Ibungona anggur mahi tenggot ama amuk loukhatladuna madugidamak Mapu Ibungobu thagatcharaga makhoida thaknanaba pire, amasung makhoi pumnamakna madu thakle. ");
INSERT INTO mni_vpl VALUES ("MK14_24","071_14_24","MRK","14","24","24","Adudagi Jisuna makhoida hairak-i, “Masi Mapu Ibungo amadi mahakki misinggi oiba anouba warepnaba adugidamak, miyamgidamak tabikhraba eigi eeni. ");
INSERT INTO mni_vpl VALUES ("MK14_25","071_14_25","MRK","14","25","25","Eina nakhoida tasengnamak hairibasini, Tengban Mapugi leibakta nouna anggur mahi thakkadaba numit adu laktriba phaoba eina amuk hanna anggur mahi asi thaklaroi.” ");
INSERT INTO mni_vpl VALUES ("MK14_26","071_14_26","MRK","14","26","26","Adudagi makhoina Mapu Ibungo thagatpa isei ama saklamlaga Chorphon Chingda chatkhre. ");
INSERT INTO mni_vpl VALUES ("MK14_27","071_14_27","MRK","14","27","27","Jisuna makhoida hairak-i, “Nakhoi pumnamakna eibu thadoklamgadouri, maramdi Mapugi Puyana hai, ‘Eina yaosenbabu yeithugani, aduga yaosing adu chaithokkani.’ ");
INSERT INTO mni_vpl VALUES ("MK14_28","071_14_28","MRK","14","28","28","Adubu eina hinggatlaba matungda nakhoidagi hanna eina Galilee-da chatkani.” ");
INSERT INTO mni_vpl VALUES ("MK14_29","071_14_29","MRK","14","29","29","Peter-na khumlak-i, “Atei pumnamakna thadoklabasu eina Ibungobu keidounungda thadokloi.” ");
INSERT INTO mni_vpl VALUES ("MK14_30","071_14_30","MRK","14","30","30","Jisuna Peter-da hairak-i, “Eina nangonda tasengnamak hairibasini, ngasi ahing yenbarabana anirak khongdringeigi mamangda nangna eibu khangde haina ahumlak haigani.” ");
INSERT INTO mni_vpl VALUES ("MK14_31","071_14_31","MRK","14","31","31","Maduda Peter-na henna kanthi thokna khumlak-i, “Eihakna Ibungoga loinana siminnaba taraba phaobada eina madu keidounungda hairoi.” Aduga tung-inba atei pumnamaksu matou adugumna loina hairammi. ");
INSERT INTO mni_vpl VALUES ("MK14_32","071_14_32","MRK","14","32","32","Makhoina Gethsamane kouba maphamda laklabada Jisuna mahakki tung-inbasingduda hairak-i, “Eina haijaringeida maphamsida phamlammu.” ");
INSERT INTO mni_vpl VALUES ("MK14_33","071_14_33","MRK","14","33","33","Aduga Ibungona Peter, Jacob amadi John-bu mahakka loinana purammi. Amasung Ibungogi pukning amadi thawai waba houraklammi, ");
INSERT INTO mni_vpl VALUES ("MK14_34","071_14_34","MRK","14","34","34","Aduga Ibungona makhoida hairak-i, “Eigi thammoisi sigadaba makhei khamthengna ware. Aduna nakhoi mapham asida mitseng khangduna leirammu.” ");
INSERT INTO mni_vpl VALUES ("MK14_35","071_14_35","MRK","14","35","35","Adudagi Ibungona manglomda khara chatlaga leimaida tuthajaduna, yarabadi awa anagi pungpham asi mangondagi lanthokkhinaba haijakhi. ");
INSERT INTO mni_vpl VALUES ("MK14_36","071_14_36","MRK","14","36","36","Ibungona haijarak-i, “Abba, Ipa Ibungo, nahakki naphamdadi pumnamak oithokpa ngaktani. Awa-anagi tenggot asi eingondagi louthokpiyu. Adumakpu eihakki aningba oidaduna nahakki aningba adumak toubiyu.” ");
INSERT INTO mni_vpl VALUES ("MK14_37","071_14_37","MRK","14","37","37","Adudagi Ibungona halakpada tung-inba ahum adu tumduna leiramba thengnare. Maduda Ibungona Peter-da hairak-i, “Simon, nahak tumlibra? Nahakna pung amakhak phaoba mitseng khangba ngamdabra?” ");
INSERT INTO mni_vpl VALUES ("MK14_38","071_14_38","MRK","14","38","38","Aduga Ibungona makhoida hairak-i, “Nakhoina athembada tadananaba mitseng khang-u amadi haijou. Thawainadi maningngi adubu hakchangnadi masolli.” ");
INSERT INTO mni_vpl VALUES ("MK14_39","071_14_39","MRK","14","39","39","Adudagi Ibungona amuk chatthokkhiduna hanna haikhiba waheising adu chap mannana haiduna haija-nijarammi. ");
INSERT INTO mni_vpl VALUES ("MK14_40","071_14_40","MRK","14","40","40","Amasung Ibungona amuk halakpada tung-inbasing adu tumduna leiramba thengnare; maramdi makhoi tumningbana mamittu lumtharammi. Aduga makhoina Ibungoda kari haigadage haibasu khanglamde. ");
INSERT INTO mni_vpl VALUES ("MK14_41","071_14_41","MRK","14","41","41","Ibungona ahumlaksuba oina halakpa matamda mahakna makhoida haikhi, “Nakhoi houjikphaoba tumduna amadi potthaduna leiribra? Yare okle! Pungpham adu lakle. Yeng-u, Migi Machanupa adubu pap chenbasinggi makhutta pithokkadouri. ");
INSERT INTO mni_vpl VALUES ("MK14_42","071_14_42","MRK","14","42","42","Hougatlu, eikhoi chatsi, eibu pithokkadaba mi adu asida leire.” ");
INSERT INTO mni_vpl VALUES ("MK14_43","071_14_43","MRK","14","43","43","Jisuna nganglingeimaktada, taranithoigi maraktagi ama oiriba Judas-na, athoiba purohitsing, Wayel Yathanggi ojasing, amadi ahal lamansingna tharakpa thangsang amadi cheitup paiba yamlaba miyam amaga loinana lakle. ");
INSERT INTO mni_vpl VALUES ("MK14_44","071_14_44","MRK","14","44","44","Ibungobu pithokpa mahak aduna miyam aduda inggit touraduna hairak-i, “Eina chupkadouriba nupa asi nakhoina pamliba mi aduni, mahakpu phaduna cheksinna sennaduna pukho.” ");
INSERT INTO mni_vpl VALUES ("MK14_45","071_14_45","MRK","14","45","45","Judas-na maphamduda hek thungbaga, Jisugi manakta changduna “Oja Ibungo, Oja Ibungo” haina kouraduna Ibungobu chuple. ");
INSERT INTO mni_vpl VALUES ("MK14_46","071_14_46","MRK","14","46","46","Adudagi makhoina Jisubu phare. ");
INSERT INTO mni_vpl VALUES ("MK14_47","071_14_47","MRK","14","47","47","Adubu mapham aduda leptuna leirambasinggi maraktagi amana mahakki thangsang sattoktuna Purohitlen-gi manaida yanduna mahakki mana kakthatle. ");
INSERT INTO mni_vpl VALUES ("MK14_48","071_14_48","MRK","14","48","48","Adudagi Jisuna makhoising aduda hairak-i, “Nakhoina eihakpu leibakki wayel pathap thugaiba tamthiba mi ama phagadoubagumna thangsang amadi cheitup paiduna laklibra? ");
INSERT INTO mni_vpl VALUES ("MK14_49","071_14_49","MRK","14","49","49","Numit khudinggi eina Mapugi Sanglenda tambiduna nakhoiga loinana leiminnarammi maduda nakhoina eibu phakhide. Adubu madu Mapugi Puyagi wa adu thungnanabani.” ");
INSERT INTO mni_vpl VALUES ("MK14_50","071_14_50","MRK","14","50","50","Adudagidi tung-inba pumnamakna Ibungobu thadoklamlaga chenkhre. ");
INSERT INTO mni_vpl VALUES ("MK14_51","071_14_51","MRK","14","51","51","Aduga kanagumba muga manbi phi amatamak setpa naha amasu Jisugi matung illakpada yaorammi. Makhoina mahakpu phananaba hotnarammi, ");
INSERT INTO mni_vpl VALUES ("MK14_52","071_14_52","MRK","14","52","52","adubu mahakna maphi adu hundoklamduna maphi amata yaodana chenkhirammi. ");
INSERT INTO mni_vpl VALUES ("MK14_53","071_14_53","MRK","14","53","53","Adudagi makhoina Jisubu Purohitlen-gi manakta purammi amasung athoiba purohitsing, ahal lamansing amadi Wayel Yathanggi ojasing pumnamak tillare. ");
INSERT INTO mni_vpl VALUES ("MK14_54","071_14_54","MRK","14","54","54","Tallaktuda Peter-na laptakna Ibungogi tung illaktuna Purohitlen-gi sumangda changlakle. Aduga maphamduda mahakna ngaksenbagi thabak touribasingga phamminnaduna mei tiklammi. ");
INSERT INTO mni_vpl VALUES ("MK14_55","071_14_55","MRK","14","55","55","Amasung Jisubu hatnabagi yathang pinanaba athoiba purohitsing amadi Sanhedrin apumbana mahakki maiyokta maralgi sakhi pinaba mi thirammi. Adubu makhoina mi kana amata phanglamde. ");
INSERT INTO mni_vpl VALUES ("MK14_56","071_14_56","MRK","14","56","56","Maramdi sakhi mayam amana Jisugi maiyokta minamba sakhi pirabasu makhoina hairibasingdu amaga amaga amata mannaramde. ");
INSERT INTO mni_vpl VALUES ("MK14_57","071_14_57","MRK","14","57","57","Adudagi mi kharana hougatlaktuna Jisugi maiyokta minamba sakhi piraduna hairak-i, ");
INSERT INTO mni_vpl VALUES ("MK14_58","071_14_58","MRK","14","58","58","“ ‘Mioibagi khutna saba Mapugi Sanglen asi eina mang-han-gani, aduga numit humnigi manungda mioibagi khutna saba nattaba atoppa Mapugi Sanglen ama eina sagani’ haina nupa asina haiba eikhoina tahou-i.” ");
INSERT INTO mni_vpl VALUES ("MK14_59","071_14_59","MRK","14","59","59","Adumakpu makhoisu, makhoina piriba sakhi adu amata manaramde. ");
INSERT INTO mni_vpl VALUES ("MK14_60","071_14_60","MRK","14","60","60","Adudagi Purohitlen aduna makhoi pumnamakki mamangda lepkhatladuna Jisuda hanglak-i, “Nahakna paokhum amata piraroidra? Mising asina nahakki maiyokta siriba naralsing asi karino?” ");
INSERT INTO mni_vpl VALUES ("MK14_61","071_14_61","MRK","14","61","61","Adubu Jisuna paokhum amata pidana tumminna leirammi. Adudagi Purohitlen aduna amuk Jisuda hanglak-i, “Nahak miyamna thagatnariba Ibungo adugi Machanupa Christta adura?” ");
INSERT INTO mni_vpl VALUES ("MK14_62","071_14_62","MRK","14","62","62","Jisuna khumlak-i, “Eimakni, aduga Migi Machanupa aduna Ingam-ngamba Mapu Ibungogi yetthangbada phamba amadi nongmadon leichilakta lenglakpa nakhoina ugani!” ");
INSERT INTO mni_vpl VALUES ("MK14_63","071_14_63","MRK","14","63","63","Adudagi Purohitlen aduna maphi segairaduna hairak-i, “Eikhoina sakhi ama amuk karigi mathou taribage? ");
INSERT INTO mni_vpl VALUES ("MK14_64","071_14_64","MRK","14","64","64","Mahakna Mapu Ibungobu thina ngangba nakhoina tare. Nakhoina kari khallibage?” Amasung makhoi pumnamakna Ibungogi mathakta sibada matik chai haiduna maral pire. ");
INSERT INTO mni_vpl VALUES ("MK14_65","071_14_65","MRK","14","65","65","Adudagi makhoi kharana Ibungoda tin sitchinba hourammi amasung mamit khumjillaga phuduna “Kanana nangbu phubano haiyu” haiduna makhoina hairammi. Amasung ngaksenbagi thabak toubasing aduna Ibungobu lousilladuna khupakna thare. ");
INSERT INTO mni_vpl VALUES ("MK14_66","071_14_66","MRK","14","66","66","Peter-na makhada, sumangda mei tiktuna leiringeida Purohitlen-gi manai nupisinggi maraktagi ama laklammi. ");
INSERT INTO mni_vpl VALUES ("MK14_67","071_14_67","MRK","14","67","67","Peter-na mei tiklibadu mahakna urabada, mahakna Peter-da munna yengladuna hairak-i, “Nahaksu Nazareth-ki Jisuga loinarambani.” ");
INSERT INTO mni_vpl VALUES ("MK14_68","071_14_68","MRK","14","68","68","Peter-na maduda khumlak-i, “Nahakna hairibadu karino haiba ei khangde aduga wakhal tabasu ngamde.” Adudagi Peter-na hojanglomda thokkhre. Matam adumaktada yenbarabana khonglakle. ");
INSERT INTO mni_vpl VALUES ("MK14_69","071_14_69","MRK","14","69","69","Aduga manai nupi aduna mapham aduda Peter-bu amuk urabada akoibada leplibasing aduda amuk hairak-i, “Mahak asi makhoisinggi maraktagi amani!” ");
INSERT INTO mni_vpl VALUES ("MK14_70","071_14_70","MRK","14","70","70","Adubu Peter-na amuk hanna natte haina khumle. Ngaihak amuk leiraga manakta leplambasing aduna Peter-da amuk hairak-i, “Awoibamak nahak makhoisinggi maraktagi amani, maramdi nahak Galilee-dagini.” ");
INSERT INTO mni_vpl VALUES ("MK14_71","071_14_71","MRK","14","71","71","Handakti Peter-na wasakladuna makhoida hairak-i, “Karigumba eina chin thiramlabadi Mapu Ibungona eingonda sirap touba oisanu. Nakhoina ngangnariba nupa adu ei tasengna khangde.” ");
INSERT INTO mni_vpl VALUES ("MK14_72","071_14_72","MRK","14","72","72","Matam adumaktada yenbarabana aniraksuba oina khonglakle. Aduga Jisuna mangonda haikhiba, “Yenbarabana anirak khongdringeigi mamangda nangna eibu khangde haina ahumlak haigani” haina haikhibadu ningsinglakle. Amasung madu khallubada mahak thammoi sokladuna kaple. ");
INSERT INTO mni_vpl VALUES ("MK15_1","071_15_1","MRK","15","1","1","Ayuk hek oibaga athoiba purohitsingna ahal lamansing, Wayel Yathanggi Ojasing, amadi Sanhedrin-gi mi apumbaga unaraduna makhoigi poram yatle. Adudagi makhoina Jisubu yotli thangduna puraga Pilate-ki makhutta sinnare. ");
INSERT INTO mni_vpl VALUES ("MK15_2","071_15_2","MRK","15","2","2","Amasung Pilate-na Ibungoda hangkhi, “Nahak Jihudisinggi ningthoura?” Jisuna khumlak-i, “Hoi, nahakna madu haidokchare.” ");
INSERT INTO mni_vpl VALUES ("MK15_3","071_15_3","MRK","15","3","3","Athoiba purohitsingduna Jisugi mathakta maral kaya ama sirammi. ");
INSERT INTO mni_vpl VALUES ("MK15_4","071_15_4","MRK","15","4","4","Maram aduna Pilate-na Ibungoda amuk hanglak-i, “Nahakna paokhum amata piraroidra? Yeng-u, makhoina nangonda naral kaya yamna siribano!” ");
INSERT INTO mni_vpl VALUES ("MK15_5","071_15_5","MRK","15","5","5","Adubu Jisuna amuk hanna paokhum amata pikhidre, amasung maduda Pilate yamna ngaklammi. ");
INSERT INTO mni_vpl VALUES ("MK15_6","071_15_6","MRK","15","6","6","Lanthokpibagi chakkhangba khudingda Pilate-na miyamgi apamba phadok amabu thadokpibagi chatnabi leirammi. ");
INSERT INTO mni_vpl VALUES ("MK15_7","071_15_7","MRK","15","7","7","Matam aduda maming Barabbas kouba phadok ama leirammi. Barabbas amadi mahakka phadok taminnaribasingdu leibakki maiyokta houba ihou amada mi hatlubagidamak phabani. ");
INSERT INTO mni_vpl VALUES ("MK15_8","071_15_8","MRK","15","8","8","Amasung miyam aduna Pilate-ki manakta laktuna mahousagum phadok amabu thadokpinanaba hangjarammi. ");
INSERT INTO mni_vpl VALUES ("MK15_9","071_15_9","MRK","15","9","9","Maduda Pilate-na makhoida hanglak-i, “Nakhoina Jihudisinggi ningthou adubu eina nakhoigidamak thadokpiba pambra?” ");
INSERT INTO mni_vpl VALUES ("MK15_10","071_15_10","MRK","15","10","10","Maramdi kalak mihoubagi maramna athoiba purohitsing aduna Jisubu phaduna mangonda sinnarakpani haiba Pilate-na munna khanglammi. ");
INSERT INTO mni_vpl VALUES ("MK15_11","071_15_11","MRK","15","11","11","Adubu Jisugi mahutta Barabbas-pu makhoigidamak thadokpinaba Pilate-ta haijanaba athoiba purohitsingna miyam aduda insillammi. ");
INSERT INTO mni_vpl VALUES ("MK15_12","071_15_12","MRK","15","12","12","Adudagi Pilate-na miyam aduda amuk hanna hairak-i, “Adudi nakhoina Jihudisinggi ningthou kouriba mangonda eina kari touba nakhoina pambage?” ");
INSERT INTO mni_vpl VALUES ("MK15_13","071_15_13","MRK","15","13","13","Makhoina laorak-i, “Mahakpu cross-ta pang tingduna hatlu!” ");
INSERT INTO mni_vpl VALUES ("MK15_14","071_15_14","MRK","15","14","14","Maduda Pilate-na hanglak-i, “Adubu mahakna kari aranba toukhrabage?” Adubu makhoina hennadum kanna laorak-i, “Mahakpu cross-ta pang tingduna hatlu!” ");
INSERT INTO mni_vpl VALUES ("MK15_15","071_15_15","MRK","15","15","15","Maduda Pilate-na miyam adubu pelhanba pamladuna mahakna Barabbas-pu makhoigidamak thadokpire. Aduga mahakna Jisubu phuhallaga cross-ta hatnanaba pithokle. ");
INSERT INTO mni_vpl VALUES ("MK15_16","071_15_16","MRK","15","16","16","Adudagi lanmising aduna Jisubu leingak-mapugi leipham Praetorium-gi sumang manungda pusille aduga lanmi kangbu apumbabu punna kousille. ");
INSERT INTO mni_vpl VALUES ("MK15_17","071_15_17","MRK","15","17","17","Makhoina Ibungobu manggra machugi phi setchinbire aduga tingkhanggi luhup ama semladuna Ibungogi kokthakta upsinbire. ");
INSERT INTO mni_vpl VALUES ("MK15_18","071_15_18","MRK","15","18","18","Adudagi makhoina karem-kathainaduna khurumlaga hairak-i, “Khurumjari, Jihudigi Ningthou!” ");
INSERT INTO mni_vpl VALUES ("MK15_19","071_15_19","MRK","15","19","19","Adudagi makhoina Ibungogi makokta cheina phubire, tin sitchinbire amasung khuru khudak kullaga noknaduna Ibungoda khurumle. ");
INSERT INTO mni_vpl VALUES ("MK15_20","071_15_20","MRK","15","20","20","Makhoina Ibungobu noknaraba matungda Ibungodagi manggra machugi phi adu louthoklaga mahakki masagi maphi adu amuk setchinbire. Aduga makhoina Ibungobu cross-ta hatnanaba puthorakle. ");
INSERT INTO mni_vpl VALUES ("MK15_21","071_15_21","MRK","15","21","21","Adudagi makhoina Alexander amadi Rufus-ki mapa, maming Simon kouba, khunggangdagi changlakpa Cyrene lamgi nupa ama lambida thengnarammi amasung lanmising aduna mahakpu namduna Jisugi cross adu puhallammi. ");
INSERT INTO mni_vpl VALUES ("MK15_22","071_15_22","MRK","15","22","22","Aduga makhoina Jisubu Golgotha haibadi handokpada “Kokki Sarugi Mapham” haina kouba mapham aduda purakle. ");
INSERT INTO mni_vpl VALUES ("MK15_23","071_15_23","MRK","15","23","23","Maphamduda makhoina yuda myrrh yansinduna Ibungoda pithaknaba hotnarammi adubu Ibungona madu thakkhide. ");
INSERT INTO mni_vpl VALUES ("MK15_24","071_15_24","MRK","15","24","24","Adudagi makhoina Ibungobu cross-ta pang tingle aduga Ibungogi maphising adu kana kanagi oigadage haiduna makhoi masel laibak chang yengnaduna yennarammi. ");
INSERT INTO mni_vpl VALUES ("MK15_25","071_15_25","MRK","15","25","25","Makhoina Ibungobu cross-ta pang tingba matamdu ayukki pung mapan tabada oirammi. ");
INSERT INTO mni_vpl VALUES ("MK15_26","071_15_26","MRK","15","26","26","Amasung Ibungobu maral siba warol “Jihudisinggi Ningthou” haina i-ba adu cross aduda thetlammi. ");
INSERT INTO mni_vpl VALUES ("MK15_27","071_15_27","MRK","15","27","27","Makhoina Ibungoga loinana huranba anibusu, amana Ibungogi yetta aduga amana oida cross-ta pang tinglammi. ");
INSERT INTO mni_vpl VALUES ("MK15_28","071_15_28","MRK","15","28","28","Aduga Mapugi Puyada haiba “Ibungo mahakpu wayel yathang thugaibasinggi marakta challe” haiba wa adu thungle. ");
INSERT INTO mni_vpl VALUES ("MK15_29","071_15_29","MRK","15","29","29","Adudagi manak aduwaida chatthok chatsin touriba misingna Ibungoda thina nganglammi amasung mangak nomladuna Ibungoda noknaduna hairak-i, “Mapugi Sanglen thugaiduna numit humnida sagatkadaba nahak, ");
INSERT INTO mni_vpl VALUES ("MK15_30","071_15_30","MRK","15","30","30","houjik cross-tagi kumtharaktuna nasabu kanjou!” ");
INSERT INTO mni_vpl VALUES ("MK15_31","071_15_31","MRK","15","31","31","Matou adugumna athoiba purohitsing amasung Wayel Yathanggi Ojasingnasu Jisubu noknaduna amaga amaga hainarak-i, “Mahakna mi ateibudi kanbi adubu mahak masabudi kanjaba ngamjade! ");
INSERT INTO mni_vpl VALUES ("MK15_32","071_15_32","MRK","15","32","32","Eikhoina uduna thajananaba Israel-gi Ningthou, Christta asi houjik cross-tagi kumtharaksanu.” Aduga Jisuga loinana cross-ta pang tingminnariba makhoi ani adunasu mahakpu ikaiba pirammi. ");
INSERT INTO mni_vpl VALUES ("MK15_33","071_15_33","MRK","15","33","33","Numityungba matamda leibak sinba thungna pung ahum amambana kupsillammi. ");
INSERT INTO mni_vpl VALUES ("MK15_34","071_15_34","MRK","15","34","34","Pung ahum tarakpa matamduda Jisuna ahouba khonjelga loinana laorak-i, “Eloi, Eloi, lama sabachtani?” masigi wahanthokti “Eigi Tengban Mapu Ibungo, eigi Tengban Mapu Ibungo, nangna eibu karigi thadokpiribano?” haibani. ");
INSERT INTO mni_vpl VALUES ("MK15_35","071_15_35","MRK","15","35","35","Mapham aduda leiriba makhoi kharana madu tarabada hairak-i, “Yeng-u, mahakna Elijah-bu kouri!” ");
INSERT INTO mni_vpl VALUES ("MK15_36","071_15_36","MRK","15","36","36","Makhoigi maraktagi amana chenkhiduna sponge ama asinba yuda luptuna chei amagi matonda lengsillaga madu thaknanaba Ibungogi chinbalda thamladuna hairak-i, “Ngaikho! Mangonda kari amata touganu, mahakpu cross-tagi louthanaba Elijah lakpra haibadu eikhoi yengkhisi.” ");
INSERT INTO mni_vpl VALUES ("MK15_37","071_15_37","MRK","15","37","37","Adudagi Jisuna khonjel houna laoramlaga, thawai thakhre. ");
INSERT INTO mni_vpl VALUES ("MK15_38","071_15_38","MRK","15","38","38","Matam aduda Mapugi Sanglen-gi asengba maphamgi phijang adu mathaktagi makha phaoba ani thokna segairammi. ");
INSERT INTO mni_vpl VALUES ("MK15_39","071_15_39","MRK","15","39","39","Amasung Ibungona laoramba amadi kamdouna thawai thakhibage haibadu cross mamangda lepliba lanmi chamagi makok aduna urabada, mahakna hairak-i, “Nupa asi asengbamak Tengban Mapugi Machanupani.” ");
INSERT INTO mni_vpl VALUES ("MK15_40","071_15_40","MRK","15","40","40","Mapham aduda nupi kharasu arappadagi yengduna leirammi. Makhoigi marakta Magdalene Mary, naha oiba Jacob amadi Joseph-ki mama Mary, amasung Salome yaorammi. ");
INSERT INTO mni_vpl VALUES ("MK15_41","071_15_41","MRK","15","41","41","Jisuna Galilee-da leiringeida makhoina Ibungogi matung injaduna thougal toujarammi. Amasung Ibungoga loinana Jerusalem-da lakminnakhiba nupi kaya amasu mapham aduda leirammi. ");
INSERT INTO mni_vpl VALUES ("MK15_42","071_15_42","MRK","15","42","42","Numit adu Thourang Langba numit haibadi potthaba Numitki mamanggi numit oirammi. Maram aduna numidangwairam naksillaklabada, ");
INSERT INTO mni_vpl VALUES ("MK15_43","071_15_43","MRK","15","43","43","Sanhedrin-gi ikai khumnaraba mihut ama oiriba, aduga Tengban Mapugi leibakpu khourangna ngaijariba misak amasu oiriba, Arimathea-gi Joseph-na Pilate-ki manakta thouna phana chattuna Jisugi hakchang adu nijakhi. ");
INSERT INTO mni_vpl VALUES ("MK15_44","071_15_44","MRK","15","44","44","Aduga asuk thuna Jisu sire tabada Pilate ingak ngaklammi. Adudagi mahakna lanmi chamagi makok adu koukhattuna Jisu siba kuirabra haina mangonda hanglammi. ");
INSERT INTO mni_vpl VALUES ("MK15_45","071_15_45","MRK","15","45","45","Aduga lanmi chamagi makok adugi paodam tarabada, Pilate-na hakchang adu Joseph-ta sinnakhi. ");
INSERT INTO mni_vpl VALUES ("MK15_46","071_15_46","MRK","15","46","46","Aduga Joseph-na muga manbi phi ama leiraga, Ibungobu louthaduna phi aduna yomlaga nungjaoda huttuna semba mongphamda thamlammi. Adudagi mahakna mongphamgi changpham aduda chaoraba nungjao ama onsinduna thamle. ");
INSERT INTO mni_vpl VALUES ("MK15_47","071_15_47","MRK","15","47","47","Amasung Magdalene Mary, amadi Joseph-ki mama Mary-na Jisugi hakchang adu kadaida thambage haibadu yeng-hourammi. ");
INSERT INTO mni_vpl VALUES ("MK16_1","071_16_1","MRK","16","1","1","Potthaba numitki matam lanthokkhraba matungda, Magdalene Mary, Jacob-ki mama Mary amasung Salome-na Jisugi manakta chattuna mahakki hakchangda teirunaba manam nungsiba pot leirammi. ");
INSERT INTO mni_vpl VALUES ("MK16_2","071_16_2","MRK","16","2","2","Aduga chayolgi ahanba numitki ayuk anganbada, numitna hek thorakpaga makhoina mongphamda chatlammi. ");
INSERT INTO mni_vpl VALUES ("MK16_3","071_16_3","MRK","16","3","3","Amasung lambida makhoi masel amana amada hangnarammi, “Kanana eikhoigidamak mongphamgi changphamda thingliba nung adu onthokpigadage?” ");
INSERT INTO mni_vpl VALUES ("MK16_4","071_16_4","MRK","16","4","4","Adubu makhoina maphamdu youraduna yengba matamdadi chaoraba nungjao adu hanana onthoktuna leiramba ure. ");
INSERT INTO mni_vpl VALUES ("MK16_5","071_16_5","MRK","16","5","5","Aduga makhoina mongpham manungda changbada achonba angouba phi setpa naha oiriba nupa ama yetthangba nakanda phamduna leiba ure, amasung maduda makhoi yamna ngaklammi amasung akiba phaorammi. ");
INSERT INTO mni_vpl VALUES ("MK16_6","071_16_6","MRK","16","6","6","Adubu mahakna makhoida hairak-i, “Ngakkanu! Cross-ta pang tingduna hatkhraba Nazareth-ki Jisu nakhoina thiribani haiba ei khang-i. Ibungodi hinggatkhre! Mahak mapham asida leitre. Yeng-u, Ibungobu thamlamba mapham adu asini. ");
INSERT INTO mni_vpl VALUES ("MK16_7","071_16_7","MRK","16","7","7","Nakhoina houjik chattuna pao asi Peter amadi Ibungogi atei tung inbasingda tamlu, ‘Ibungodi nakhoigi mang thaduna Galilee-da chatkhre; mahakna nakhoida haikhibagumna nakhoina Ibungobu mapham aduda ujagani.’ ” ");
INSERT INTO mni_vpl VALUES ("MK16_8","071_16_8","MRK","16","8","8","Adudagi nupising adu kibana nikladuna amadi ngakpaga loinana mongpham adudagi thuna thoraktuna chenkhirammi. Aduga makhoina kibadagi mi kana amatada karisu haidre.  ");
INSERT INTO mni_vpl VALUES ("MK16_9","071_16_9","MRK","16","9","9","Chayolgi ahanba numitki ayuk anganbada Jisuna sibadagi hinggatlaba matungda mahakna lai phattaba taret tanthokpikhiba Magdalene Mary-da ihan hanna uhanbire. ");
INSERT INTO mni_vpl VALUES ("MK16_10","071_16_10","MRK","16","10","10","Amasung Mary-na chatkhiduna tengtha naowoiduna leiriba Ibungoga loinarambasing aduda thoudok adu tamle. ");
INSERT INTO mni_vpl VALUES ("MK16_11","071_16_11","MRK","16","11","11","Adum oinamak Ibungo hinggatle aduga mahakna Ibungobu ujare haina Mary-na makhoida tamba aduda makhoina thajaramde. ");
INSERT INTO mni_vpl VALUES ("MK16_12","071_16_12","MRK","16","12","12","Madugi matungda Ibungona tung-inba anina khunggangda asum chatlingeida Ibungona tonganba sakwongda makhoida uhanbire. ");
INSERT INTO mni_vpl VALUES ("MK16_13","071_16_13","MRK","16","13","13","Makhoi anina hallaklaga Ibungoga loinarambasing aduda thoudok adu tamle, adubu makhoina makhoi anigi wa adubusu thajaramde. ");
INSERT INTO mni_vpl VALUES ("MK16_14","071_16_14","MRK","16","14","14","Ikon konbada, tung-inba makhoi taramathoina chaminnaduna leiringeida Jisuna makhoida uhanbire. Makhoigi thajaba leitaba amadi Ibungona hinggatlaba matungda Ibungobu ujarabasing adubu thajadaba makhoigi akanba thamoi adugidamak makhoibu cheirammi. ");
INSERT INTO mni_vpl VALUES ("MK16_15","071_16_15","MRK","16","15","15","Adudagi Ibungona makhoida hairak-i, “Taibangpan-gi mapham khudingda chattuna mipum khudingda Aphaba Pao sandok-u. ");
INSERT INTO mni_vpl VALUES ("MK16_16","071_16_16","MRK","16","16","16","Thajaduna baptize louraba makhoi adubu kanbigani adubu thajadaba makhoi adubudi maral leihan-gani. ");
INSERT INTO mni_vpl VALUES ("MK16_17","071_16_17","MRK","16","17","17","Aduga thajabasingda angakpa thabaksing tounaba panggal pigani. Makhoina eigi mingda lai phattabasing tanthokkani; makhoina anouba lonsing nganggani; ");
INSERT INTO mni_vpl VALUES ("MK16_18","071_16_18","MRK","16","18","18","Makhoina makhoigi makhutna lilsing paikhatlabasu aduga hu thaklabasu maduna makhoida amangba karisu thok-halloi; makhoina anabasinggi mathakta khut thambibada anabasingna phajagani.” ");
INSERT INTO mni_vpl VALUES ("MK16_19","071_16_19","MRK","16","19","19","Ibungo Jisuna makhoida wa ngangba loiraba matungda, Ibungobu swargada loukhatkhre aduga Tengban Mapugi yetthangbada Ibungona phamle. ");
INSERT INTO mni_vpl VALUES ("MK16_20","071_16_20","MRK","16","20","20","Adudagi Ibungogi tung-inbasingna mapham khudingda chattuna Aphaba Pao sandokle, aduga Ibungona makhoiga loinana thabak tourammi amasung makhoina sandokliba pao adu achumbani haibadu makhoigi angakpa thabaksing aduna utlammi. Amen.");
INSERT INTO mni_vpl VALUES ("LK1_1","072_1_1","LUK","1","1","1","Nungsijaraba Theophilus: Eikhoigi irakta thunghanbikhraba thoudoksing adugi paodam adubu inanaba mioi kaya amana kanna hotnakhi. ");
INSERT INTO mni_vpl VALUES ("LK1_2","072_1_2","LUK","1","2","2","Ahoubadagi houna thoudoksing asibu mamitmakna uhoubasing amasung Mapugi waheigi thougal toubasing aduna eikhoida phongdokpirambasing adu makhoina ikhi. ");
INSERT INTO mni_vpl VALUES ("LK1_3","072_1_3","LUK","1","3","3","Aduga, he ikai khumnaraba Theophilus, pumnamaksing adu eihakna ahoubadagi houna changkhonna thijillaba maramna, thoudoksing adu mathang manao naina nahakki naphamda iba phagani haina eihaknasu ningle. ");
INSERT INTO mni_vpl VALUES ("LK1_4","072_1_4","LUK","1","4","4","Nangonda tambikhraba pumnamaksing adugi mapungphaba achumba adu nahakna khangnanaba eina masi naphamda ibani. ");
INSERT INTO mni_vpl VALUES ("LK1_5","072_1_5","LUK","1","5","5","Herod-na Judea leibakki ningthou oina pallingei matamda, Abijah-gi purohit kanglupta Zechariah kouba purohit ama leirammmi. Mahakki nupigi maming Elijabeth kou-i; aduga Elizabeth-su purohit Aaron-gi charon suron oirammi. ");
INSERT INTO mni_vpl VALUES ("LK1_6","072_1_6","LUK","1","6","6","Makhoi animakna Mapu Ibungogi yathangsing amadi pathap pumnamaksing mapungphana ngakchaduna Tengban Mapugi mityengda chumna chatchaba punsi mahing amada hinglammi. ");
INSERT INTO mni_vpl VALUES ("LK1_7","072_1_7","LUK","1","7","7","Adubu makhoi macha amata leiramde maramdi Elizabeth chaboktabi oirammi aduga makhoi animak ahalsu yamna oirammi. ");
INSERT INTO mni_vpl VALUES ("LK1_8","072_1_8","LUK","1","8","8","Nongmagi numitta Zechariah-gi purohit kangbuna thougal toubagi palli taraduna mahakna Mapugi Sanglenda purohit ama oina Tengban Mapugi thougal tourammi. ");
INSERT INTO mni_vpl VALUES ("LK1_9","072_1_9","LUK","1","9","9","Aduga latnapungda mengkruk thanaba purohitsinggi chatnabi matung inna changyengnabada mangonda tare. Maram aduna mahakna Mapu Ibungogi sanglen manungda changle. ");
INSERT INTO mni_vpl VALUES ("LK1_10","072_1_10","LUK","1","10","10","Amasung mengkruk chukhatpagi pungpham aduda tilliba miyam aduna mapanda haija nijaduna leirammi. ");
INSERT INTO mni_vpl VALUES ("LK1_11","072_1_11","LUK","1","11","11","Adudagi Mapu Ibungogi dut amana mengkruk thariba iratpung adugi yet thangbada leptuna mangonda uhanbirammi. ");
INSERT INTO mni_vpl VALUES ("LK1_12","072_1_12","LUK","1","12","12","Zechariah-na mahakpu ubada masada thukatpa amadi akiba phaorammi. ");
INSERT INTO mni_vpl VALUES ("LK1_13","072_1_13","LUK","1","13","13","Adubu swarga dut aduna mangonda hairak-i, “Kiganu, Zechariah! Nahakna haijaba adu Tengban Mapuna tabire. Nahakki nupi Elizabeth-na nachanupa ama poklagani aduga nahakna mahakki maming John haina thongadabani. ");
INSERT INTO mni_vpl VALUES ("LK1_14","072_1_14","LUK","1","14","14","Mahak pokpa matamda nahakna kayada haraoba amadi nungaiba oigadaba! Amasung mi kayana kayada harao nungaiba oigadaba! ");
INSERT INTO mni_vpl VALUES ("LK1_15","072_1_15","LUK","1","15","15","Maramdi Mapu Ibungogi mityengda mahak matik chaogani. Mahakna yu amadi mayai kaba mahi amata thakloi, aduga mama puknungdagi houna mahak Thawai Asengbana than-gani. ");
INSERT INTO mni_vpl VALUES ("LK1_16","072_1_16","LUK","1","16","16","Amasung mahakna Israel macha kayabu makhoigi Tengban Mapu, Mapu Ibungoda hallak-han-gani. ");
INSERT INTO mni_vpl VALUES ("LK1_17","072_1_17","LUK","1","17","17","Mahakna Tengban Mapugi wa phongdokpa maichou Elijah-gi machat amadi matikka loinana Ibungogi mang thana chatkani. Mahakna misingbu Ibungona lenglakkadaba adugidamak thourang langhannaba mapasingbu machasingga amuk yasinnahangani amasung haiba indabasingbu achumba chatpasinggi lousing aduda hongdokpigani.” ");
INSERT INTO mni_vpl VALUES ("LK1_18","072_1_18","LUK","1","18","18","Adudagi Zechariah-na dut aduda hairak-i, “Masi soidana thokkani haibasi eihakna kamdouna khanggadage? Eidi ahal oiraba mini aduga eigi nupisu ahal oire.” ");
INSERT INTO mni_vpl VALUES ("LK1_19","072_1_19","LUK","1","19","19","Maduda dut aduna khumlak-i, “Ei Grabriel-ni. Nangonda wa hainanaba amasung aphaba pao asibu tamnanaba eibu thabirakpa Tengban Mapugi mangda eina lepli. ");
INSERT INTO mni_vpl VALUES ("LK1_20","072_1_20","LUK","1","20","20","Adubu achaba matamda soidanamak thoklagadaba eigi wasing asi nahakna thajade. Aduga nahakna thajadabagi maramna eina nangonda haikhibasing asi thoktriba numit adu phaoba nahak wa ngangba thokloi aduga wa amata ngangdana tumminna leigani.” ");
INSERT INTO mni_vpl VALUES ("LK1_21","072_1_21","LUK","1","21","21","Cheirak aduda mising aduna Zechariah-bu mapanda ngaiduna leirammi amasung mahakna karigi Mapugi Sanglen manungda matam asuk kuina leiribano haina makhoi ngaklammi. ");
INSERT INTO mni_vpl VALUES ("LK1_22","072_1_22","LUK","1","22","22","Amasung mahakna mapanda thorakpa matamda, mahakna makhoida wa ngangba ngamkhide. Aduga mahakna Mapugi Sanglen manungda uhanbiba ama ukhre haiba makhoina khanglammi, maramdi mahakna makhoida ingit touduna nganglammi adubu wa ngangbadi adumak ngamkhide. ");
INSERT INTO mni_vpl VALUES ("LK1_23","072_1_23","LUK","1","23","23","Aduga Mapugi Sanglenda mahakki thougal toubagi numitsing adu loirabada Zachariah mayumda amuk halaklammi. ");
INSERT INTO mni_vpl VALUES ("LK1_24","072_1_24","LUK","1","24","24","Matam kharagi matungda Elizabeth mironlaklammi aduga mahakna tha manga yumdagi mapan thoklamde. ");
INSERT INTO mni_vpl VALUES ("LK1_25","072_1_25","LUK","1","25","25","Mahakna haikhi, “Houjik mameithangda Mapu Ibungona eibu pangbire. Miyam mangda eina ikaiba nanglamba adu Ibungona louthokpire!” ");
INSERT INTO mni_vpl VALUES ("LK1_26","072_1_26","LUK","1","26","26","Elizabeth-na mironba tha taruk surakpada Tengban Mapuna swargadut Grabriel-bu Nazareth kouba Galilee-gi khungangda tharakle. ");
INSERT INTO mni_vpl VALUES ("LK1_27","072_1_27","LUK","1","27","27","Mahakna Mary haina koubi, David ningthougi chada-naoda oiriba Joseph kouba nupa amada luhongnaba waroinakhrabi leisabi asengbi amagi pao puduna laklammi. ");
INSERT INTO mni_vpl VALUES ("LK1_28","072_1_28","LUK","1","28","28","Aduga dut aduna mangonda laktuna hairak-i, “Khurumjari, thoujal phanglabi! Mapu Ibungona nahakpu loinabiri; nupisinggi maraktagi nahakti yaipahabini.” ");
INSERT INTO mni_vpl VALUES ("LK1_29","072_1_29","LUK","1","29","29","Maryna dut adugi wahei aduda yamna cha-ngaknarammi amasung mahakki waheising aduna kari phongdoklibano haiduna khallammi. ");
INSERT INTO mni_vpl VALUES ("LK1_30","072_1_30","LUK","1","30","30","Maduda dut aduna hairak-i, “Kiganu Mary, Tengban Mapudagi nahakna thoujal phangjare. ");
INSERT INTO mni_vpl VALUES ("LK1_31","072_1_31","LUK","1","31","31","Nahakna mironduna nacha nupa ama pokkani aduga nahakna mahakki maming Jisu thongadabani. ");
INSERT INTO mni_vpl VALUES ("LK1_32","072_1_32","LUK","1","32","32","Mahak matik chaogani aduga Wangthoiraba Mapu Ibungogi machanupa kougani. Mapu Ibungo Tengban Mapuna mangonda mapa David-ki phambal adu pibigani, ");
INSERT INTO mni_vpl VALUES ("LK1_33","072_1_33","LUK","1","33","33","Aduga mahakna Jacob-ki chada-naodasinggi ningthou oina matam pumbagi oina pan-gani, amadi mahakki leibak adu lomba nairoi.” ");
INSERT INTO mni_vpl VALUES ("LK1_34","072_1_34","LUK","1","34","34","Adudagi Mary-na dut aduda hairak-i, “Eihakti luhongdribi leisabini, adu oirabadi masi kamdouna oithokkadouribano?” ");
INSERT INTO mni_vpl VALUES ("LK1_35","072_1_35","LUK","1","35","35","Dut aduna khumlak-i, “Thawai Asengbana nahakki nathakta lengthabirakkani aduga Wangthoiraba Ibungo adugi panggalna nahakpu lumsinbigani. Maram asina pokkadouriba asengba angang adubu Tengban Mapugi Machanupa kougani. ");
INSERT INTO mni_vpl VALUES ("LK1_36","072_1_36","LUK","1","36","36","Yengu, nahakki mari mata Elizabeth-su ahal oiraklaba matamsida macha ama phangjagadoure, chaboktabi hainarambi mahakna houjikti tha tarukki angang naopure. ");
INSERT INTO mni_vpl VALUES ("LK1_37","072_1_37","LUK","1","37","37","Maramdi Tengban Mapugi maphamda oithoktaba kari amata leite.” ");
INSERT INTO mni_vpl VALUES ("LK1_38","072_1_38","LUK","1","38","38","Maduda Mary-na hairak-i, “Eihak Mapu Ibungogi manainupini; nahakna haikhibagum masi eingongda thokpa oirasanu.” Adudagi dut adu mahakpu thadoktuna chatkhre. ");
INSERT INTO mni_vpl VALUES ("LK1_39","072_1_39","LUK","1","39","39","Madugi matung ikui kuidana Mary-na thourang touraduna chinggi lamdamda leiba, Judea-gi apikpa sahar amada thuna chatlammi. ");
INSERT INTO mni_vpl VALUES ("LK1_40","072_1_40","LUK","1","40","40","Amasung mahakna Zechariah-gi yumda changduna Elizabeth-pu khurumjarammi. ");
INSERT INTO mni_vpl VALUES ("LK1_41","072_1_41","LUK","1","41","41","Aduga Mary-na khurumjabagi khonjel adu Elizabeth-na tabada mahakki pibuknungda angang aduna chonglammi. Amasung Elizabeth Thawai Asengbana thallammi. ");
INSERT INTO mni_vpl VALUES ("LK1_42","072_1_42","LUK","1","42","42","Aduga mahakna khonjel wangna hairak-i, “Nupilaktagi nahakti khwaidagi henna yaiphabini, amasung nahakna naopugadouriba angang adu yaiphabani! ");
INSERT INTO mni_vpl VALUES ("LK1_43","072_1_43","LUK","1","43","43","Eigi Ibungogi imana eigi inakta lengbiraktuna eibu asuk ekai khumnabiriba asi karamnano? ");
INSERT INTO mni_vpl VALUES ("LK1_44","072_1_44","LUK","1","44","44","Maramdi nahakna khurumjabagi khonjel adu eina hek tabaga eigi pibuknunggi angang asina haraoduna chongkhatli. ");
INSERT INTO mni_vpl VALUES ("LK1_45","072_1_45","LUK","1","45","45","Mapu Ibungona mahakki maphamda haikhrabasing adu thunghanbigani haina thajaribi mahak adu yaiphabini!” ");
INSERT INTO mni_vpl VALUES ("LK1_46","072_1_46","LUK","1","46","46","Maduda Maryna hairak-i, “Eigi thawaina Mapu Ibungobu thagatchei, ");
INSERT INTO mni_vpl VALUES ("LK1_47","072_1_47","LUK","1","47","47","Eigi thawaina eigi Kanbiba Mapu, Tengban Mapuda haraojei, ");
INSERT INTO mni_vpl VALUES ("LK1_48","072_1_48","LUK","1","48","48","Maramdi mahakna tollabi manainupi eihakpu ningsingbire! Houjiktagi houduna miron khudingna kougani eibu yaiphabi; ");
INSERT INTO mni_vpl VALUES ("LK1_49","072_1_49","LUK","1","49","49","Maramdi toubire Pangallaba mahakna, eigidamak achouba thabak kaya. Ibungo mahakki minglendi asengbani; ");
INSERT INTO mni_vpl VALUES ("LK1_50","072_1_50","LUK","1","50","50","Mahakpu kina chatchabasingda, utpi mahakna chanbiba; miron miron khudingda. ");
INSERT INTO mni_vpl VALUES ("LK1_51","072_1_51","LUK","1","51","51","Toubire mahakki pambomna, matik leiba thabak kaya; aduga chaikhaire mahakna, mathamoida napal touba misingbu. ");
INSERT INTO mni_vpl VALUES ("LK1_52","072_1_52","LUK","1","52","52","Chingthakhi mahakna matik leiba ningthousingbu makhoigi ningthou phambaldagi, aduga thanggatpikhi mahakna nollukpasingbu. ");
INSERT INTO mni_vpl VALUES ("LK1_53","072_1_53","LUK","1","53","53","Thalhanbikhi mahakna aram-khourangbasingbu aphabana, adubu thakhi inakhunbasingbu khut hangna. ");
INSERT INTO mni_vpl VALUES ("LK1_54","072_1_54","LUK","1","54","54","Ngakkhi mahakna sakkhiba washaktu, eikhoigi ipa-ipusingda, aduga lakkhi pangbinaba mahakki manai Israel-bu. ");
INSERT INTO mni_vpl VALUES ("LK1_55","072_1_55","LUK","1","55","55","Ningsingbikhi mahakna, matam pumnamakta chanbiba utpigani haibadu, Abraham amadi mahakki charon suronsingda!” ");
INSERT INTO mni_vpl VALUES ("LK1_56","072_1_56","LUK","1","56","56","Adudagi Mary-na tha ahummuk Elizabeth-ka leiminnaramlaga mayumda hankhirammi. ");
INSERT INTO mni_vpl VALUES ("LK1_57","072_1_57","LUK","1","57","57","Elizabeth-ki angang unabagi matam oiraklabada, mahakna machanupa ama pokkhi. ");
INSERT INTO mni_vpl VALUES ("LK1_58","072_1_58","LUK","1","58","58","Aduga mahakki keirol-leikaisingna amadi mari-matasingna Mapu Ibungona mahakpu kayada chanbibage haibadu tare amasung makhoi pumnamakna mahakka loinana haraominare. ");
INSERT INTO mni_vpl VALUES ("LK1_59","072_1_59","LUK","1","59","59","Angang aduna numit nipanni subada makhoina mahakpu un kakpa lakle, amasung makhoina angang adubu mapagi maming louduna Zechariah thonnaba tourammi. ");
INSERT INTO mni_vpl VALUES ("LK1_60","072_1_60","LUK","1","60","60","Adubu Elizabeth-na makhoida haikhi, “Natte, mahakki maming John haina thongadabani.” ");
INSERT INTO mni_vpl VALUES ("LK1_61","072_1_61","LUK","1","61","61","Maduda makhoina mangonda hairak-i, “Nakhoigi sagei natei marakta ming adu kouba mi amatasu yaode.” ");
INSERT INTO mni_vpl VALUES ("LK1_62","072_1_62","LUK","1","62","62","Adudagi makhoina angang adugi mapa Zechariah-da ingit touduna, mahakna angang adugi maming kari thonba pambage haiduna hanglammi. ");
INSERT INTO mni_vpl VALUES ("LK1_63","072_1_63","LUK","1","63","63","Maduda mahakna mangonda inanaba korbak ama pinaba hairammi, aduga maduda mahakna “Mahakki maming John kou-i” haina ire. Maduda makhoi pumnamak pumngak ngakle. ");
INSERT INTO mni_vpl VALUES ("LK1_64","072_1_64","LUK","1","64","64","Khudak adumaktada Zechariah amuk hanna wa ngangba ngamle aduga mahakna Tengban Mapubu thagatchaba houre. ");
INSERT INTO mni_vpl VALUES ("LK1_65","072_1_65","LUK","1","65","65","Aduga thokkhibasing asina maram oiduna mahakki keirol-leikai pumnamak akibana thallammi, amasung thoudok pumnamak asigi paona Judah-gi chinggi lamdam adu sinba thungna sandokkhirammi. ");
INSERT INTO mni_vpl VALUES ("LK1_66","072_1_66","LUK","1","66","66","Amasung pao adu taba mi khudingmakna, madugi maramda wakhal touraduna hanglak-i, “Angang asina kari oirakkadaba?” Maramdi Mapu Ibungogi pangalna mahakki mathakta lei haiba makhoina khanglammi. ");
INSERT INTO mni_vpl VALUES ("LK1_67","072_1_67","LUK","1","67","67","Amasung John-gi mapa Zechariah Thawai Asengbana thallammi aduga mahakna Tengban Mapugi wa phongdoktuna hairak-i: ");
INSERT INTO mni_vpl VALUES ("LK1_68","072_1_68","LUK","1","68","68","“Eikhoina Israel-gi Tengban Mapu, Mapu Ibungobu thagatlasi! Mahakna mahakki misingbu pangbinaba lakle amasung makhoibu handokpire! ");
INSERT INTO mni_vpl VALUES ("LK1_69","072_1_69","LUK","1","69","69","Mahakna mahakki manai David-ki charon surondagi, Pinabire eikhoigidamak matik leiba Kanbiba Mapu ama. ");
INSERT INTO mni_vpl VALUES ("LK1_70","072_1_70","LUK","1","70","70","Mahakna mamangngeida mahakki wa phongdokpiba asengba maichousingi mapanna washakpikhi, ");
INSERT INTO mni_vpl VALUES ("LK1_71","072_1_71","LUK","1","71","71","Kanbigani haina Mahakna, eikhoibu eikhoigi yeknabasingdagi, amadi eikhoibu yengthiba pumnamakki makhuttagi. ");
INSERT INTO mni_vpl VALUES ("LK1_72","072_1_72","LUK","1","72","72","Haibikhi mahakna eikhoigi ipa ipusingda, chanbiba utpigani haina, aduga mahakki asengba warepnaba adu mahakna ningsingbikhi. ");
INSERT INTO mni_vpl VALUES ("LK1_73","072_1_73","LUK","1","73","73","Wasakpikhi mahakna Ipa Abraham-da, ");
INSERT INTO mni_vpl VALUES ("LK1_74","072_1_74","LUK","1","74","74","Kanbigani haina Mahakna eikhoibu yeknabasingi makhuttagi aduga ngamhanbigani haina eikhoibu akiba leitana mahakpu thouganjaba, ");
INSERT INTO mni_vpl VALUES ("LK1_75","072_1_75","LUK","1","75","75","Punsi chuppa eikhoina Mahakki mangda asengba amadi achumba chatpa oinaba. ");
INSERT INTO mni_vpl VALUES ("LK1_76","072_1_76","LUK","1","76","76","Aduga, eigi ichanupa, nahakpu wangthoiraba Tengban Mapugi wa phongdokpiba maichou haina kougani; Ibungogi lambi thourang tounaba, Chatkani nahakna Ibungogi mang thaduna. ");
INSERT INTO mni_vpl VALUES ("LK1_77","072_1_77","LUK","1","77","77","Ibungogi misingda hainanaba, makhoigi papsingdu kokpibagi mapanna, Makhoibu kanbigani haina. ");
INSERT INTO mni_vpl VALUES ("LK1_78","072_1_78","LUK","1","78","78","Maramdi eikhoigi Tengban Mapudi chanbiheibani amadi nungsiheibani. Thok-hanbigani Mahakna, aran-khubamgi langlaba ayukki korou mangal adu eikhoida. ");
INSERT INTO mni_vpl VALUES ("LK1_79","072_1_79","LUK","1","79","79","Ngalhannanaba korouthaktagi, asibagi mamlaba mamida leiriba pumnamakki mathakta. Chingbinanaba eikhoigi khongthangbu, ingthabagi lambida.” ");
INSERT INTO mni_vpl VALUES ("LK1_80","072_1_80","LUK","1","80","80","Adudagi angang adu hakchang amadi thawaida chaokhatlaklammi. Aduga mahakna masabu Israel-gi miyamda phongdoktringeigi matam adu phaoba lamjao lamhangda leirammi. ");
INSERT INTO mni_vpl VALUES ("LK2_1","072_2_1","LUK","2","1","1","Matam aduda Rome-na panba leibak punamakta mikok thinabagidamak Caesar Augustus-na yathang ama thokkhi. ");
INSERT INTO mni_vpl VALUES ("LK2_2","072_2_2","LUK","2","2","2","Masigi ahanba mikok thiba asi Quirinius-na Syria-gi leingak mapu oiringei matamda thokkhibani. ");
INSERT INTO mni_vpl VALUES ("LK2_3","072_2_3","LUK","2","3","3","Matam aduda mipum khudingmakna masa masagi hourakpham saharda maming ikhatnaba chatnarammi. ");
INSERT INTO mni_vpl VALUES ("LK2_4","072_2_4","LUK","2","4","4","Aduga Joseph-su David ningthougi charon-suron oiba maramna Galilee-gi Nazareth sahar thadoktuna Judea-da leiba David ningthougi sahar Bethlehemda chatlammi. ");
INSERT INTO mni_vpl VALUES ("LK2_5","072_2_5","LUK","2","5","5","Amasung mahakka luhongnabagidamak waroinakhrabi Mary-ga loinana mahakna mapham aduda ming ikhatnabagidmak chatminnarammi. Mary mirollibini. ");
INSERT INTO mni_vpl VALUES ("LK2_6","072_2_6","LUK","2","6","6","Aduga makhoina Bethlehem-da leiringeida Mary-gi angang unabagi matam adu yousillakle. ");
INSERT INTO mni_vpl VALUES ("LK2_7","072_2_7","LUK","2","7","7","Aduga mahakna mahakki ahanba machanupa ama pokle. Amasung mahakna angang adubu phina yomsinbiraga sabam amada hiphallammi, maramdi makhoina mithungsang aduda leinanaba mapham amata phanglamde. ");
INSERT INTO mni_vpl VALUES ("LK2_8","072_2_8","LUK","2","8","8","Lamdam adumaktada yaosenba kharana ahing aduda loubuk lamhangsingda makhoigi yao sanggusing sennaduna leirammi. ");
INSERT INTO mni_vpl VALUES ("LK2_9","072_2_9","LUK","2","9","9","Adudagi ikhang khanghoudana Mapu Ibungogi dut amana makhoigi mamangda thoraklammi amasung Mapu Ibungogi matik mangalna makhoigi akoibada ngallammi. Maduda makhoi adukki matik kirammi. ");
INSERT INTO mni_vpl VALUES ("LK2_10","072_2_10","LUK","2","10","10","Adubu swarga dut aduna makhoida hairak-i, “Kiganu! Eina mi pumnamakki oigadaba yamna harao nungngaibagi aphaba pao nakhoida purakli. ");
INSERT INTO mni_vpl VALUES ("LK2_11","072_2_11","LUK","2","11","11","Ngasigi numitta David-ki saharda nakhoigi kanbiba mapu pokle; mahakti Ibungo Christtani. ");
INSERT INTO mni_vpl VALUES ("LK2_12","072_2_12","LUK","2","12","12","Aduga khudam asigi mapanna nakhoina mahakpu khanggani; madudi phina yomsillaba angang ama sabamda hiplamba nakhoina thengnagani.” ");
INSERT INTO mni_vpl VALUES ("LK2_13","072_2_13","LUK","2","13","13","Aduga ikhang khanghoudana swarga dut aduga loinana masing yamlaba swarga dut kanglup ama thoraktuna Tengban Mapubu thagatladuna hairak-i, ");
INSERT INTO mni_vpl VALUES ("LK2_14","072_2_14","LUK","2","14","14","“Oirare wangthoiraba swargada, Tengban Mapugi maphamda matik mangal, aduga pibire malemda, magi apenba oiriba misinggi mathakta ingthaba!” ");
INSERT INTO mni_vpl VALUES ("LK2_15","072_2_15","LUK","2","15","15","Adudagi swarga dutsing aduna makhoibu thadoktuna swargada amuk kakhrabada, makhoi masel amaga amaga hainarak-i, “Houjik eikhoina Bethlehem-da chattuna Mapu Ibungona eikhoida hairamba thokkhraba thoudok adu yenglusi.” ");
INSERT INTO mni_vpl VALUES ("LK2_16","072_2_16","LUK","2","16","16","Adudagi makhoina thunamak lakle amasung Mary amadi Joseph-pu phangjaduna sabamda hipliba angang adubu uba phangjare. ");
INSERT INTO mni_vpl VALUES ("LK2_17","072_2_17","LUK","2","17","17","Amasung yao senbasing aduna angang adubu uraba matungda swarga dut aduna angang adugi maramda hairambasing adu Mary amadi Joseph-ta tamle. ");
INSERT INTO mni_vpl VALUES ("LK2_18","072_2_18","LUK","2","18","18","Aduga yaosenbasing aduna tambadu tabada tariba pumnamak ingak ngakkhi. ");
INSERT INTO mni_vpl VALUES ("LK2_19","072_2_19","LUK","2","19","19","Adubu Mary-nadi masi pumnamaksing asi ningsingjadunata leijakhi amasung thoudoksing adugi maramda munna wakhal toujakhi. ");
INSERT INTO mni_vpl VALUES ("LK2_20","072_2_20","LUK","2","20","20","Aduga yaosenbasing aduna makhoida hairamba aduga chap mannana, makhoina takhiba amadi ukhiba pumnamaksing adugidamak Tengban Mapubu matik mangal pijaduna amadi thagatchaduna hankhirammi. ");
INSERT INTO mni_vpl VALUES ("LK2_21","072_2_21","LUK","2","21","21","Numit nipanni subada, angang adugi un kakpa matam laklabada, mahakna pibuknungda mitamdringei mamangda swarga dut aduna thollambagumna mahakki maming Jisu haina tholle. ");
INSERT INTO mni_vpl VALUES ("LK2_22","072_2_22","LUK","2","22","22","Adudagi Moses-ki wayel yathang matung-inna makhoigi sengdokpagi thouram pangthoknaba matam adu laklammi. Aduga Joseph amadi Mary-na Jisubu Mapu Ibungoda katchanabagidamak Jerusalem-da puraklammi. ");
INSERT INTO mni_vpl VALUES ("LK2_23","072_2_23","LUK","2","23","23","Madu Mapu Ibungogi wayel yathangda ikhiba, “Ahanba pokpa machanupa khudingmak MAPU IBUNGO-gidamak tonganna khaidoktuna thamjagadabani” haiba adugi matung-innani. ");
INSERT INTO mni_vpl VALUES ("LK2_24","072_2_24","LUK","2","24","24","Aduga makhoina Mapu Ibungogi wayel yathang matung-inna lamkhunu pungba ama nattraga khunu macha ani iratpot oina katnanabagidamaktasu chatlammi. ");
INSERT INTO mni_vpl VALUES ("LK2_25","072_2_25","LUK","2","25","25","Matam aduda Simeon kouba achumba chatpa, Mapu Ibungobu chetna ningjaba nupa ama Jerusalem-da leirammi. Mahakna Israel-bu kanbigadaba adubu khourangna ngaijaduna leirammi. Aduga Thawai Asengbana mahakka loinarammi. ");
INSERT INTO mni_vpl VALUES ("LK2_26","072_2_26","LUK","2","26","26","Amasung Mapu Ibungona wasakpikhraba Christta adubu udriba phaoba mahak siroi haiduna Thawai Asengbana mangonda phongdokpirammi. ");
INSERT INTO mni_vpl VALUES ("LK2_27","072_2_27","LUK","2","27","27","Adudagi Thawaina chingduna Simeon-na Mapugi Sanglenda laklammi. Amasung Mary amadi Joseph-na angang oiriba Jisubu wayel yathanggi matung inna mahakkidamak toupham thokpasing adu tounanabagidamak Mapugi Sanglenda purakpa matamda, ");
INSERT INTO mni_vpl VALUES ("LK2_28","072_2_28","LUK","2","28","28","Simeon-na mahakpu pamladuna Tengban Mapubu thagatcharak-i: ");
INSERT INTO mni_vpl VALUES ("LK2_29","072_2_29","LUK","2","29","29","“Mapu Ibungo, nahakna wasakpikhibagi matung-inna, Houjikti, nanai eihakpu nahakna ingthana thadokpire. ");
INSERT INTO mni_vpl VALUES ("LK2_30","072_2_30","LUK","2","30","30","Maramdi eigi imit makna nahakki aran-khubham adu ujare, ");
INSERT INTO mni_vpl VALUES ("LK2_31","072_2_31","LUK","2","31","31","Nahakna madu mi pumnamakki mamangda thourang toubire: ");
INSERT INTO mni_vpl VALUES ("LK2_32","072_2_32","LUK","2","32","32","Jihudi nattaba phurupsingda nahakki aningba phongdoknaba amadi nahakki mi Israel-gi maphamda matik ma-ngal puraknaba ma-ngal ama.” ");
INSERT INTO mni_vpl VALUES ("LK2_33","072_2_33","LUK","2","33","33","Ibungogi maramda Simeon-na hairibasing asi tabada Ibungogi mapa amadi mama ngaktuna leirammi. ");
INSERT INTO mni_vpl VALUES ("LK2_34","072_2_34","LUK","2","34","34","Adudagi Simeon-na makhoibu yaipha-thoujal pibiraduna Ibungogi mama Mary-da hairak-i, “Angang asi Israel-gi mi kaya amabu tuhannaba aduga kaya amabuna hougat-hannaba Tengban Mapuna khandokkhrabani. Aduga mahak mi kaya amana maiyokta nganggadaba Tengban Mapudagi lakpa khudam ama oigani. ");
INSERT INTO mni_vpl VALUES ("LK2_35","072_2_35","LUK","2","35","35","Masi mi kayagi thamoigi wa adu phongdoknabani. Aduga awabana, thouraba thangsanggi matougumna nasamakki thamoida thin-gani.” ");
INSERT INTO mni_vpl VALUES ("LK2_36","072_2_36","LUK","2","36","36","Aduga Anna koubi Tengban Mapugi wa phongdokpi amasu Mapugi Sanglenda leirammi. Mahak Asher salaigi Phanuel-gi machanupini amasung mahak yamna ahal oirammi. Mahakki mapuroiba adu luhonglaba matung chahi taretkhak mahakka leiminnaramlga sikhirammi. ");
INSERT INTO mni_vpl VALUES ("LK2_37","072_2_37","LUK","2","37","37","Adudagi mahakna masagi chahi mariphumari suba phaoba lukhrabi ama oina leirammi. Mahakna Mapugi Sanglenbu keidounungda thadoklamde adubu mahakna ahing nungthil animakta Tengban Mapubu khurumjaduna, chara henduna amadi haijaduna mapham aduda leirammi. ");
INSERT INTO mni_vpl VALUES ("LK2_38","072_2_38","LUK","2","38","38","Aduga pungpham adumaktada mahaksu laktuna Tengban Mapubu thagatcharammi amasung Jerusalem-bu handokpiba ngaijariba makhoi pumnamakki maphamda angang asigi maramda wa nganglammi. ");
INSERT INTO mni_vpl VALUES ("LK2_39","072_2_39","LUK","2","39","39","Aduga Joseph amasung Mary-na Mapu Ibungogi wayel yathanggi matung-inna toupham thokpa pumnamak pangthokpa loiraba matungda makhoina Galilee-da leiba masamakki apikpa sahar Nazareth-ta halaklammi. ");
INSERT INTO mni_vpl VALUES ("LK2_40","072_2_40","LUK","2","40","40","Amasung angang adu asum chaokhatlaklammi amasung pangal kallaklammi. Mahak lousingna thallammi aduga Tengban Mapugi thoujalna mahakki mathakta leirammi. ");
INSERT INTO mni_vpl VALUES ("LK2_41","072_2_41","LUK","2","41","41","Aduga chahi khudinggi Ibungogi mama-mapana lanthokpibagi chakkhangba kumheigidamak Jerusalem-da chatlammi. ");
INSERT INTO mni_vpl VALUES ("LK2_42","072_2_42","LUK","2","42","42","Amasung Ibungona chahi taranithoi suba matamda mahousagumna Jerusalem-da chakkhangba yaoba chatlammi. ");
INSERT INTO mni_vpl VALUES ("LK2_43","072_2_43","LUK","2","43","43","Adudagi makhoina lanthokpibagi chakkhangba kumhei loiduna yumda hallabada, angang oiriba Jisudi Jerusalem-da leithahourammi. Adubu Ibungogi mama mapanadi madu khanglamde. ");
INSERT INTO mni_vpl VALUES ("LK2_44","072_2_44","LUK","2","44","44","Adudagi makhoina Ibungobu makhoiga chatminnariba khongloising adugi marakta yaoramgani haina khanduna numit chuppa chatlaba tungda makhoina Ibungobu mari-matasinggi marakta amadi marup-mapangsinggi marakta thiba hourammi. ");
INSERT INTO mni_vpl VALUES ("LK2_45","072_2_45","LUK","2","45","45","Aduga makhoina Ibunggobu thiba phangdrabada mahakpu thinabagidamak Jerusalem-da amuk hallammi. ");
INSERT INTO mni_vpl VALUES ("LK2_46","072_2_46","LUK","2","46","46","Amasung numit humnigi matungda makhoina mahakpu Mapugi Sanglenda Jihudi ojasinggi marakta phamduna makhoina ngangba taduna amadi mahakna makhoida wahang hangduna leiramba adu thengnare. ");
INSERT INTO mni_vpl VALUES ("LK2_47","072_2_47","LUK","2","47","47","Amasung Ibungona ngangba tariba makhoi pumnamakna mahakki lousing amadi paokhum aduda ingak-ngaklammi. ");
INSERT INTO mni_vpl VALUES ("LK2_48","072_2_48","LUK","2","48","48","Aduga Ibungogi mama mapana Ibungobu uba matamda ingak-ngaklammi, amasung Ibungogi mamana Ibungoda hairak-i, “Icha-nupa, nahakna eikhoida asumna touribasi karigino? Napaga eigana kayada pukning wana nahakpu thirakli.” ");
INSERT INTO mni_vpl VALUES ("LK2_49","072_2_49","LUK","2","49","49","Maduda Ibungona khumlak-i, “Nakhoina eibu karigidamak thiribano? Eina eigi Ipagi yumda leipham thok-i haiba nakhoina khangdabra?” ");
INSERT INTO mni_vpl VALUES ("LK2_50","072_2_50","LUK","2","50","50","Adubu Ibungona makhoida hairiba adu karino haiba makhoina khangba ngamkhide. ");
INSERT INTO mni_vpl VALUES ("LK2_51","072_2_51","LUK","2","51","51","Adudagi Jisuna mama mapaga loinana Nazareth-ta hallaklammi amasung mahakna makhoina haiba illammi. Aduga Ibungogi mamana thokhiba pumnamaksing adu mathamoida lengdana thamjarammi. ");
INSERT INTO mni_vpl VALUES ("LK2_52","072_2_52","LUK","2","52","52","Amasung Jisuna hakchang amadi lousing animakta chaokhatlaklammi amadi Tengban Mapu amadi misingdagi chanbiba phangjarammi. ");
INSERT INTO mni_vpl VALUES ("LK3_1","072_3_1","LUK","3","1","1","Caesar Tiberius-na panba chahi taramangasuba chahida Pontius Pilate-na Judea-gi leingak mapu, Herodna Galilee-gi leingakpa amasung manaonupa Philipna Iturea amadi Trachonitis-ki leingakpa; Lysanias-na Abilene-gi leingakpa, ");
INSERT INTO mni_vpl VALUES ("LK3_2","072_3_2","LUK","3","2","2","Amasung Annas amadi Caiaphas-na athoiba purohitlen oiringeida lamjao-lamhangda leiriba Zechariah-gi machanupa John-gi maphamda Tengban Mapuna wa ngangbirammi. ");
INSERT INTO mni_vpl VALUES ("LK3_3","072_3_3","LUK","3","3","3","Maram aduna pap kokchanabagidamak pukning hongbagi baptize lounabagi pao miyamda sandoktuna John-na Jordan turelgi akoibada leiba lam pumnamakta chatlammi. ");
INSERT INTO mni_vpl VALUES ("LK3_4","072_3_4","LUK","3","4","4","Masi Tengban Mapugi wa phongdokpiba maichou Isaiah-gi lairikta ikhibagumbani: “Kanagumba amana lamjao-lamhangda laori: ‘MAPU IBUNGO-gi lambi thourang tou; Ibungona chatnaba lambi chumhallu! ");
INSERT INTO mni_vpl VALUES ("LK3_5","072_3_5","LUK","3","5","5","Tampak khudingmak thongatkani, Ching amadi chingjao khudingmakpu temthokkani. Akhoiba lambisingbu chumhangani, Akut atong leiba lambisingbu nalhangani. ");
INSERT INTO mni_vpl VALUES ("LK3_6","072_3_6","LUK","3","6","6","Aduga mi pumnamakna Tengban Mapugi aran-khubham uba phangjagani.’ ” ");
INSERT INTO mni_vpl VALUES ("LK3_7","072_3_7","LUK","3","7","7","Adudagi mangonda baptize touhannaba lakliba miyam aduda John-na hairak-i, “He lilgi chada naodasa, lakkadouriba Tengban Mapugi asaoba adudagi chennaba nakhoida kanana haibage? ");
INSERT INTO mni_vpl VALUES ("LK3_8","072_3_8","LUK","3","8","8","Nakhoina paptagi pukning hongbagi matik chaba mahei yallu. Aduga ‘Eikhoigi ipa Abraham lei’ haina nakhoigi napukningda haijaganu. Maramdi, eina nakhoida hairi madudi nungsing asidagisu Tengban Mapuna Abraham-gi machasing thokhanba ngammi. ");
INSERT INTO mni_vpl VALUES ("LK3_9","072_3_9","LUK","3","9","9","Houjiksu upalsing asigi maruda singjang thaduna lei amasung aphaba mahei pandaba upal pumnamakpu kakthattuna meinungda langsingani.” ");
INSERT INTO mni_vpl VALUES ("LK3_10","072_3_10","LUK","3","10","10","Maduda miyam aduna John-da hanglak-i, “Adu oirabadi eikhoina kari tougadage?” ");
INSERT INTO mni_vpl VALUES ("LK3_11","072_3_11","LUK","3","11","11","Mahakna makhoida khumlak-i, “Phurit ani leiba mahak aduna amata phaoba leijadaba mahak aduda ama pisanu aduga chananaba chinjak leiba mahak adunasu matou adugumna tousanu.” ");
INSERT INTO mni_vpl VALUES ("LK3_12","072_3_12","LUK","3","12","12","Adudagi kanggat khomba kharasu baptize lounaba laklammi amasung makhoina Johnda hanglak-i, “Oja Ibungo, Eikhoina kari tougadage?” ");
INSERT INTO mni_vpl VALUES ("LK3_13","072_3_13","LUK","3","13","13","Mahakna makhoida khumlak-i, “Loupham thokpa adudagi henna nakhoina louganu.” ");
INSERT INTO mni_vpl VALUES ("LK3_14","072_3_14","LUK","3","14","14","Adudagi lanmi kharanasu mangonda hanglak-i, “Aduga eikhoinadi kari tougadage?” Mahakna makhoida khumlak-i, “Mi kanadagisu nam-haduna sel louganu aduga kanadasu aranba maral thangjinganu. Amasung nanggi nanggi asuman aduda apenba oiyu.” ");
INSERT INTO mni_vpl VALUES ("LK3_15","072_3_15","LUK","3","15","15","Aduga mi pumnamakna Christtana lakkadaba adu ngaiduna leiba maramna John-bu Christta adu oigadara haina makhoigi thamoinungda hangjarammi. ");
INSERT INTO mni_vpl VALUES ("LK3_16","072_3_16","LUK","3","16","16","Maram aduna John-na makhoi pumnamakta hairak-i, “Einadi nakhoibu isingda baptize toubi, adubu eingondagi henna matik leiba kanagumba ama lenglakli aduga eidi Ibungo magi sandal mari louthokpa phaoba matik chade. Mahaknadi nakhoibu Thawai Asengbada amasung meida baptize toubigani. ");
INSERT INTO mni_vpl VALUES ("LK3_17","072_3_17","LUK","3","17","17","Ibungona mahei marong yeipham adu sengdoktuna gehusing adubu keida peisinnaba makhutta mahakki phou-inthok paiduna leiri; adubu mahakna mahamsing adubudi mutpa naidaba meida thajingani.” ");
INSERT INTO mni_vpl VALUES ("LK3_18","072_3_18","LUK","3","18","18","Aduga John-na khetnaba mawong matou kaya amada mising aduda Aphaba Pao sandoklammi amasung makhoigi lambi adu hongdoknaba thougatlammi. ");
INSERT INTO mni_vpl VALUES ("LK3_19","072_3_19","LUK","3","19","19","Adubu mahakna Galilee-gi leingakpa Herod-pu manaonupa Philip-ki nupi Herodias-pu loubagidamak amasung mahakna toukhiba phattaba thabak pumnamak adugidamak cheirammi. ");
INSERT INTO mni_vpl VALUES ("LK3_20","072_3_20","LUK","3","20","20","Aduga Herod-na John-bu keisumsangda thamjinduna amukka henna tamthiba pap langsinjarammi. ");
INSERT INTO mni_vpl VALUES ("LK3_21","072_3_21","LUK","3","21","21","Nongma John-na miyam amabu baptize touringei matamda Jisubusu baptize tourammi. Aduga Ibungona haijaringeida swarga hangdoktuna, ");
INSERT INTO mni_vpl VALUES ("LK3_22","072_3_22","LUK","3","22","22","Thawai Asengbana hakchang oina khunugi mawongda Ibungogi mathakta lengtharaklammi. Aduga swargadagi khonjel amana hairak-i, “Nahak eigi nungsijaraba Ichanupani, eina nangonda yamna pelle.” ");
INSERT INTO mni_vpl VALUES ("LK3_23","072_3_23","LUK","3","23","23","Jisuna thougal touba hourakpa matamda masagi chahi kunthramuk surammi. Ibungodi, misingna khanbagum Joseph-ki machanupani. Joseph-ti Heli-gi machanupani. ");
INSERT INTO mni_vpl VALUES ("LK3_24","072_3_24","LUK","3","24","24","Heli-di Matthat-ki machanupani, Matthat-na Levi-gi machanupani, Levi-na Melki-gi machanupani. Melki-na Jannai-gi machanupani, Jannai-na Joseph-ki machanupani. ");
INSERT INTO mni_vpl VALUES ("LK3_25","072_3_25","LUK","3","25","25","Joseph-na Mattathias-ki machanupani, Mattathias-na Amos-ki machanupani, Amos-na Nahum-gi machanupani, Nahum-na Esli-gi machanupani, Esli-na Naggai-gi machanupani. ");
INSERT INTO mni_vpl VALUES ("LK3_26","072_3_26","LUK","3","26","26","Naggai-na Maath-ki machanupani, Maath-na Mattathias-ki machanupani, Mattathias-na Semein-gi machanupani, Semein-na Josech-ki machanupani. Josech-na Joda-gi machanupani. ");
INSERT INTO mni_vpl VALUES ("LK3_27","072_3_27","LUK","3","27","27","Joda-na Joanan-gi machanupani, Joanan-na Rhesa-gi machanupani, Rhesa-na Zerubbabel-gi machanupani, Zerubbabel-na Shealtiel machanupani, Shealtiel-na Neri-gi machanupani. ");
INSERT INTO mni_vpl VALUES ("LK3_28","072_3_28","LUK","3","28","28","Neri-na Melki-gi machanupani, Melki-na Addi-gi machanupani, Addi-na Cosam-gi machanupani, Cosam-na Elmadam-gi machanupani, Elmadam-na Er-gi machanupani. ");
INSERT INTO mni_vpl VALUES ("LK3_29","072_3_29","LUK","3","29","29","Er-na Joshua-gi machanupani, Joshua-na Eliezer-gi machanupani, Eliezer-na Jorim-gi machanupani, Jorim-na Matthat-ki machanupani, Matthat-na Levi-gi machanupani. ");
INSERT INTO mni_vpl VALUES ("LK3_30","072_3_30","LUK","3","30","30","Levi-na Simeon-gi machanupani, Simeon-na Judah-gi machanupani, Judah-na Joseph-ki machanupani, Joseph-na Jonam-gi machanupani, Jonam-na Eliakim-gi machanupani. ");
INSERT INTO mni_vpl VALUES ("LK3_31","072_3_31","LUK","3","31","31","Eliakim-na Melea-gi machanupani, Melea-na Menna-gi machanupani, Menna-na Mattatha-gi machanupani, Mattatha-na Nathan-gi machanupani, Nathan-na David-ki machanupani. ");
INSERT INTO mni_vpl VALUES ("LK3_32","072_3_32","LUK","3","32","32","David-na Jesse-gi machanupani, Jesse-na Obed-ki machanupani, Obed-na Boaz-ki machanupani, Boaz-na Salmon-gi machanupani, Salmon-na Nahshon-gi machanupani. ");
INSERT INTO mni_vpl VALUES ("LK3_33","072_3_33","LUK","3","33","33","Nashon-na Amminadab-ki machanupani, Amminadab-na Admin-gi machanupani, Admin-na Arni-gi machanupani, Arni-na Hezron-gi machanupani, Hezron-na Perez-ki machanupani, Perez-na Judah-gi machanupani. ");
INSERT INTO mni_vpl VALUES ("LK3_34","072_3_34","LUK","3","34","34","Judah-na Jacob-ki machanupani, Jacob-na Isaac-ki machanupani, Isaac-na Abraham-gi machanupani, Abraham-na Terah-gi machanupani, Terah-na Nahor-gi machanupani. ");
INSERT INTO mni_vpl VALUES ("LK3_35","072_3_35","LUK","3","35","35","Nahor-na Serug-ki machanupani, Serug-na Reu-gi machanupani, Reu-na Peleg-ki machanupani, Peleg-na Eber-gi machanupani, Eber-na Shelah-gi machanupani. ");
INSERT INTO mni_vpl VALUES ("LK3_36","072_3_36","LUK","3","36","36","Shelah-na Cainan-gi machanupani, Cainan-na Arphaxad-ki machanupani, Arphaxad-na Shem-gi machanupani, Shem-na Noah-gi machanupani, Noah-na Lamech-ki machanupani. ");
INSERT INTO mni_vpl VALUES ("LK3_37","072_3_37","LUK","3","37","37","Lamech-na Methuselah-gi machanupani, Methuselah-na Enoch-ki machanupani, Enoch-na Jared-ki machanupani, Jared-na Mahalaleel-gi machanupani, Mahalaleel-na Kenan-gi machanupani. ");
INSERT INTO mni_vpl VALUES ("LK3_38","072_3_38","LUK","3","38","38","Kenan-na Enosh-ki machanupani, Enosh-na Seth-ki machanupani, Seth-na Adam-gi machanupani, Adam-na Tengban Mapugi machanupani. ");
INSERT INTO mni_vpl VALUES ("LK4_1","072_4_1","LUK","4","1","1","Adudagi Jisu Thawai Asengbana thalladuna Jordan-dagi hallakle amasung Thawai Asengbana mahakpu lamjao-lamhangda chingbirammi. ");
INSERT INTO mni_vpl VALUES ("LK4_2","072_4_2","LUK","4","2","2","Aduga mapham aduda Devil-na Ibungobu numit niphuni themkhi. Numitsing aduda Ibungona karigumba amata charamde amasung numitsing adu loirabada Ibungo mabuk lamlaklammi. ");
INSERT INTO mni_vpl VALUES ("LK4_3","072_4_3","LUK","4","3","3","Adudagi Devil-na Ibungoda hairak-i, “Nahakna Tengban Mapugi machanupa oirabadi nung asida tal ollu haina yathang piyu.” ");
INSERT INTO mni_vpl VALUES ("LK4_4","072_4_4","LUK","4","4","4","Adubu Jisuna mangonda khumlak-i, “Mapugi puyada masi iduna lei, ‘Tal khaktagi mapanna mioibana hingloi, adubu Tengban Mapugi wahei khudinggi mapanna hinggani.’ ” ");
INSERT INTO mni_vpl VALUES ("LK4_5","072_4_5","LUK","4","5","5","Adudagi Devilna Ibungobu awangba chingthak amada pukhattuna mikup amada taibangpanbagi ningthou leibak pumnamakpu uhalle. ");
INSERT INTO mni_vpl VALUES ("LK4_6","072_4_6","LUK","4","6","6","Aduga mahakna Ibungoda hairak-i, “Eina nangonda pumnamak asigi mathakta panbagi matik amadi masigi matik mangal pumnamak nangonda pigani; maramdi masi eingonda sinnakhrabani aduga eina pamba kanagumba amada masi amuk piba ngammi. ");
INSERT INTO mni_vpl VALUES ("LK4_7","072_4_7","LUK","4","7","7","Karigumba nangna eibu khurumlabadi pumnamaksing asi nahakkini.” ");
INSERT INTO mni_vpl VALUES ("LK4_8","072_4_8","LUK","4","8","8","Maduda Jisuna khumlak-i, “Mapugi puyada masi iduna lei, ‘Nangna nanggi Tengban Mapu, MAPU IBUNGO mahak khaktabu khurumjagadabani amadi thouganjagadabani.’ ” ");
INSERT INTO mni_vpl VALUES ("LK4_9","072_4_9","LUK","4","9","9","Adudagi devilna Ibungobu Jerusalem-da puraduna Mapugi Sanglen matonda lephallaga Ibungoda hairak-i, “Nahakna Tengban Mapugi macha oirabadi mapham asidagi chongthajou. ");
INSERT INTO mni_vpl VALUES ("LK4_10","072_4_10","LUK","4","10","10","Maramdi Mapugi puyada masi iduna lei, ‘Nahakpu ngak-senbinabagidamak Tengban Mapuna mahakki swargadutsingda yathang pigani, ");
INSERT INTO mni_vpl VALUES ("LK4_11","072_4_11","LUK","4","11","11","Aduga nahakki khongna nungda yeisindanaba makhoina nahakpu pamkhatpigani.’ ” ");
INSERT INTO mni_vpl VALUES ("LK4_12","072_4_12","LUK","4","12","12","Maduda Jisuna mangonda khumlak-i, “Mapugi puyada asumna hai, ‘Nahakna nahakki Tengban Mapu, Mapu Ibungobu changyengpharoi.’ ” ");
INSERT INTO mni_vpl VALUES ("LK4_13","072_4_13","LUK","4","13","13","Adudagi Devilna Jisubu themba pumnamak loirabada mathanggi khudongchaba laktriba phaoba Jisubu thadoktuna chatkhre. ");
INSERT INTO mni_vpl VALUES ("LK4_14","072_4_14","LUK","4","14","14","Adudagi Jisuna Thawai Asengbagi panggalga loinana Galilee-da halaklammi. Aduga Ibungogi paona lam sinbathungna sangdokkhirammi. ");
INSERT INTO mni_vpl VALUES ("LK4_15","072_4_15","LUK","4","15","15","Ibungona synagogue-singda tambirammi amasung mipum khudingmakna mahakpu thagatlammi. ");
INSERT INTO mni_vpl VALUES ("LK4_16","072_4_16","LUK","4","16","16","Adudagi Jisuna mahakki hourakpham Nazareth-ta lakle. Aduga mahousagum mahakna Potthaba Numitta synagogue-ta chatlammi amasung Mapugi puya pananaba lepkhatlammi. ");
INSERT INTO mni_vpl VALUES ("LK4_17","072_4_17","LUK","4","17","17","Amasung Tengban Mapugi wa phongdokpiba maichou Isaiahgi lairik makol adu Ibungoda pirabada mahakna hangdoktuna parak-i, ");
INSERT INTO mni_vpl VALUES ("LK4_18","072_4_18","LUK","4","18","18","“MAPU IBUNGO-gi Thawaina ithakta leibirare, Maramdi lairabasingda Aphaba Pao sandoknabagidamak mahakna eibu khandokpire. Thamoi kairabasingbu phahannaba Lanpha oirabasingda ningtamba laothoknanaba, Mit tangbasingbu uhanbinaba, Otpi neibiba phanglabasingbu maning tamhannaba, ");
INSERT INTO mni_vpl VALUES ("LK4_19","072_4_19","LUK","4","19","19","Aduga MAPU IBUNGOna mahakki misingbu kanbinaba matam adu lakle haina laothoknaba, Mahakna eibu thabire.” ");
INSERT INTO mni_vpl VALUES ("LK4_20","072_4_20","LUK","4","20","20","Adudagi Jisuna lairik makol adu konsilladuna thougal touriba nupa aduda amuk piraga phamtharammi. Amasung synagogue aduda leiriba mi pumnamakna Ibungoda pukning changna yenglammi. ");
INSERT INTO mni_vpl VALUES ("LK4_21","072_4_21","LUK","4","21","21","Aduga Ibungona makhoida haiba hourak-i, “Nakhoina houjik takhraba Mapugi puyagi wahei adu ngasidi achumba oina thoklare.” ");
INSERT INTO mni_vpl VALUES ("LK4_22","072_4_22","LUK","4","22","22","Aduga mi pumnamakna Ibungogi maramda thagatnaduna ngangnarammi amasung Ibungogi chinbaldagi thorakpa thoujalgi waheising adu tabada makhoi ngaklammi. Amasung makhoina hainarak-i, “Mahak asibu Josephki machanupa nattra?” ");
INSERT INTO mni_vpl VALUES ("LK4_23","072_4_23","LUK","4","23","23","Ibungona makhoida hairak-i, “Nakhoina eingonda soidana paorou asi haigani, ‘Laiyengba mi, nahak nasabu phahallu! Aduga Capernaum-da nahakna toukhi haina eikhoina takhibasing adu nahakki naramdam asidasu tou.’ ” ");
INSERT INTO mni_vpl VALUES ("LK4_24","072_4_24","LUK","4","24","24","Ibungona makha tana hairak-i, “Eina nakhoida tasengnamak hairibasini, Tengban Mapugi wa phongdokpiba maichousingbu keidoungeida masagi maramdamda lousinbide. ");
INSERT INTO mni_vpl VALUES ("LK4_25","072_4_25","LUK","4","25","25","“Adubu yeng-u, achumba adu eina hairi, Elijah-gi matamda chahi ahum makhai nongdon atiya thingkhiduna leibak pumnamakta achouba chak tangba thokpa matamda Israelda lukhrabi mayam ama leirammi. ");
INSERT INTO mni_vpl VALUES ("LK4_26","072_4_26","LUK","4","26","26","Adumakpu makhoi kana amatagi manakta Elijah-bu thakhide adubu Sidon lamdamgi Zarephath-ta leibi lukhrabi amagi manakta thabikhi. ");
INSERT INTO mni_vpl VALUES ("LK4_27","072_4_27","LUK","4","27","27","Aduga Tengban Mapugi wa phongdokpiba maichou Elisha-gi matamda Israel lamdamda kiningngai oiba unsagi lainana naba mi kaya ama leirabasu makhoi kana amatabu phahanbikhide adubu Syria-gi Naaman khaktabu phahanbikhi.” ");
INSERT INTO mni_vpl VALUES ("LK4_28","072_4_28","LUK","4","28","28","Madu tabada synagogue aduda leiriba mi pumnamak mei houna saorammi. ");
INSERT INTO mni_vpl VALUES ("LK4_29","072_4_29","LUK","4","29","29","Amasung makhoina hougattuna Ibungobu sahar adudagi chingthoktuna chingcheptagi hunthanabagidamak sahar adu leiriba ching adugi chingdonda purakle. ");
INSERT INTO mni_vpl VALUES ("LK4_30","072_4_30","LUK","4","30","30","Adubu Ibungona miyam adugi marakmaktada phaoraduna chatkhirammi. ");
INSERT INTO mni_vpl VALUES ("LK4_31","072_4_31","LUK","4","31","31","Adudagi Jisuna Galilee-gi Capernaum-da chatlammi amasung potthaba numitsingda miyamda tambirammi. ");
INSERT INTO mni_vpl VALUES ("LK4_32","072_4_32","LUK","4","32","32","Aduga Ibungogi tambiba matou aduda makhoi pumnmak ingak ngaklammi maramdi Ibungona matik leina nganglammi. ");
INSERT INTO mni_vpl VALUES ("LK4_33","072_4_33","LUK","4","33","33","Matamduda synagogue aduda phattaba thawai changba nupa ama leirammi. Aduga mahakna khonjel houna laorak-i, ");
INSERT INTO mni_vpl VALUES ("LK4_34","072_4_34","LUK","4","34","34","“He Nazareth-ki Jisu, eikhoiga nangga kari mari leinabage? Nahak eikhoibu mang-hannaba mapham asida laklibra? Nahak kanano haiba ei khang-i: nahak Tengban Mapuna thabirakpa Asengba Mahak aduni.” ");
INSERT INTO mni_vpl VALUES ("LK4_35","072_4_35","LUK","4","35","35","Maduda Jisuna thawai aduda yathang pirammi, “Tumin leiyu aduga mangondagi thokkhro.” Adudagi lai phattaba aduna nupa adubu makhoi pumnamakki mamangmaktada inthuramlaga karisu sokhanba touramdana mangondagi mapan thokkhre. ");
INSERT INTO mni_vpl VALUES ("LK4_36","072_4_36","LUK","4","36","36","Maduda mi pumnamak ngakladuna makhoi masel amaga amaga hainarak-i, “Nupa asigi waheising asi kayada matik amadi panggal leiriba! Phattaba thawai phaobana mahakna haiba illi aduga mahakki yathang tabada chelli.” ");
INSERT INTO mni_vpl VALUES ("LK4_37","072_4_37","LUK","4","37","37","Amasung Ibungogi paona akoibada leiba mapham khudingmakta sandokkhre. ");
INSERT INTO mni_vpl VALUES ("LK4_38","072_4_38","LUK","4","38","38","Adudagi Jisuna synagogue adu thadoktuna Simon-gi yumda chatlammi. Matam aduda Simon-gi manembok arum kanna houduna leirammi amasung makhoina Ibungoda mahakki anaba adubu phahanbinaba haijarammi. ");
INSERT INTO mni_vpl VALUES ("LK4_39","072_4_39","LUK","4","39","39","Maduda Jisuna mahakki manakta nontharaduna mahakpu thadoktuna chatkhinanaba arum aduda yathang pikhi. Amasung maduda arum houramba adu phajaduna mahakna khudak aduda hougatlaga makhoibu thougal toujare. ");
INSERT INTO mni_vpl VALUES ("LK4_40","072_4_40","LUK","4","40","40","Numit tasillaklabada misingna makhal makha kayagi lainana naraba anaba kaya amabu Jisugi manakta purakle. Amasung Ibungona makhoi khudingmakki mathakta khut thambiraduna anaba pumnamakpu phahanbirammi. ");
INSERT INTO mni_vpl VALUES ("LK4_41","072_4_41","LUK","4","41","41","Adugisu mathakta, mioi kaya amadagi lai phattabasing aduna “Nahakti Tengban Mapugi Machanupa Christa aduni” haina laoramlaga thokkhirammi. Adubu Jisuna lai phattabasing aduda cheiraduna makhoibu wa nganghallamde, maramdi makhoina Ibungobu Christani haiba khanglammi. ");
INSERT INTO mni_vpl VALUES ("LK4_42","072_4_42","LUK","4","42","42","Nongngallabada Jisuna mapham adu thadoktuna achikpa mapham amada chatlammi. Aduga miyam aduna Ibungobu thiba hourammi amasung makhoina Ibungobu thengnarabada makhoibu thadoktuna chatkhidanaba kanna hotnarammi. ");
INSERT INTO mni_vpl VALUES ("LK4_43","072_4_43","LUK","4","43","43","Adubu Ibungona makhoida hairak-i, “Eihakna Tengban Mapugi leibakki Aphaba Pao adu atoppa saharsingdasu sandokpa tai, maramdi thabak adugidamak eihakpu tharakpani.” ");
INSERT INTO mni_vpl VALUES ("LK4_44","072_4_44","LUK","4","44","44","Asum touna Ibungona leibak adu sinba thungna synagogue synagogue-singda pao sandoklammi. ");
INSERT INTO mni_vpl VALUES ("LK5_1","072_5_1","LUK","5","1","1","Nongma Jisuna Gennesaret-ki pat mapanda pao sandoklammi. Amasung yamlaba miyam amana Tengban Mapugi wa tananaba Ibungogi manak tanna changsinnanaba innarammi. ");
INSERT INTO mni_vpl VALUES ("LK5_2","072_5_2","LUK","5","2","2","Matamduda pat mapan aduda hi anikhak thangduna leiba Ibungona ure aduga nga phabasing aduna hising adudagi khumthaduna makhoigi insing adu chamduna leirammi. ");
INSERT INTO mni_vpl VALUES ("LK5_3","072_5_3","LUK","5","3","3","Ibungona hi adugi maraktagi amada haibadi Simon-gi hida tongduna Simon-da hi adu pat mapan adudagi khajiktang inthoknaba hairammi. Adudagi Ibungona hi aduda phamduna miyam adubu tambirammi. ");
INSERT INTO mni_vpl VALUES ("LK5_4","072_5_4","LUK","5","4","4","Amasung Ibungona ngangba loirabada Simon-da hairak-i, “Houjik hi asi aruba maphamda hondoktuna nga khara phananaba nakhoina insing adu hunlu.” ");
INSERT INTO mni_vpl VALUES ("LK5_5","072_5_5","LUK","5","5","5","Maduda Simonna khumlak-i, “Eikhoina ahing chuppa kanna hotnajarabani adubu nga amata phaba ngamdre. Adumakpu Ibungona asumna takpirabanina eina in amuk hunjage.” ");
INSERT INTO mni_vpl VALUES ("LK5_6","072_5_6","LUK","5","6","6","Adudagi makhoina in hunlammi amasung yamlaba ngayam ama phare. Aduga ngasing adu yammankhibana makhoigi in adu segaiba houre. ");
INSERT INTO mni_vpl VALUES ("LK5_7","072_5_7","LUK","5","7","7","Maram aduna makhoina atoppa hisingda leiriba nga phaminnabasing adubu khut khatladuna mateng pangbinaba kourammi. Aduga makhoina laktuna ngasing adubu hi ani adu pik thanna hapminnare amasung ngasing adu yammankhibana hising adu lupthaba houraklammi. ");
INSERT INTO mni_vpl VALUES ("LK5_8","072_5_8","LUK","5","8","8","Madu ubada Simon Peter-na Jisugi khuyada tuthajaduna hairak-i, “He Ibungo, eingondagi chatthokpikhro, maramdi eihak pap chellaba mini!” ");
INSERT INTO mni_vpl VALUES ("LK5_9","072_5_9","LUK","5","9","9","Maramdi makhoina pharakliba yamlaba ngasing adugi maramna Simon amadi mahakka loinaribasing adu yamna ngaklammi. ");
INSERT INTO mni_vpl VALUES ("LK5_10","072_5_10","LUK","5","10","10","Matou adugumna Simon-gi mapang Zebedee-gi machanupa Jacob amasung Johnsu ingak ngaklammi. Adudagi Jisuna Simon-da hairak-i, “Kiganu, houjiktagi houna nahakna mising pharagani.” ");
INSERT INTO mni_vpl VALUES ("LK5_11","072_5_11","LUK","5","11","11","Amasung makhoina makhoigi hisingdu kangphalda chingkhatladuna, pumnamak thadoklamlaga Ibungogi tung injare. ");
INSERT INTO mni_vpl VALUES ("LK5_12","072_5_12","LUK","5","12","12","Adudagi Jisuna sahar amada leiringeida kiningai oiba unsagi lainana naba nupa ama laklammi. Nupa aduna Jisubu ubada leimaida tuthajaraduna haijarak-i, “Ibungo, nahakna yabirabadi, nahakna eibu seng-hanbiba ngammi.” ");
INSERT INTO mni_vpl VALUES ("LK5_13","072_5_13","LUK","5","13","13","Maduda Ibungona khut tingthokladuna mahakpu soklaga hairak-i, “Eina yare, nahak sengjaro.” Khudak aduda nupa adudagi anaba adu phakhirammi. ");
INSERT INTO mni_vpl VALUES ("LK5_14","072_5_14","LUK","5","14","14","Adudagi Jisuna nupa aduda yathang piraduna hairak-i, “Nahakna masi mi kanadasu haiganu, adubu chatuna nasabu purohitta utcharu, aduga nahak phajare haibadu pumnamakna sakhi oinaba Moses-na yathang pikhiba matung-inna iratpot adu katcharu.” ");
INSERT INTO mni_vpl VALUES ("LK5_15","072_5_15","LUK","5","15","15","Adumakpu Ibungogi pao adu hennadum henna pak-sanna sandokkhirammi amasung yamlaba miyamna Ibungona pao sandokpa adu tananaba amadi makhoigi lainasing adu phahanbinaba Ibungogi manakta laklammi. ");
INSERT INTO mni_vpl VALUES ("LK5_16","072_5_16","LUK","5","16","16","Adubu Ibungona tattana theidoktuna achikpa maphamsingda chattuna haijarammi. ");
INSERT INTO mni_vpl VALUES ("LK5_17","072_5_17","LUK","5","17","17","Nongma Jisuna tambiringeida Galilee amadi Judea-gi khul khudingdagi aduga Jerusalem-dagi lakpa Pharisee-sing amadi Wayel Yathanggi ojasingna manakta phamduna leirammmi. Aduga Ibungoda anaba phahannaba Mapu Ibungogi panggal adu leirammi. ");
INSERT INTO mni_vpl VALUES ("LK5_18","072_5_18","LUK","5","18","18","Adudagi mi kharana pangtha-sithabagi lainana naba nupa amabu hipnaphamda hiphalladuna puraklammi amasung makhoina anaba adubu Ibungogi mangda thamnabagidamak imungda pusinnaba hotnarammi. ");
INSERT INTO mni_vpl VALUES ("LK5_19","072_5_19","LUK","5","19","19","Adubu miyam adugi maramna mahakpu imungda pusinnabagi lambi leiramde. Maram aduna makhoina yumthakta kakhattuna yumthak adu phaktoklaga mahakpu hipnapham aduga loinana miyamdugi marak Jisugi mamangmaktada tapna tapna thadharaklammi. ");
INSERT INTO mni_vpl VALUES ("LK5_20","072_5_20","LUK","5","20","20","Makhoigi thajaba adu Ibungona urabada nupa aduda hairak-i, “Nupa, Nahakki napapsing adu kokpirabani.” ");
INSERT INTO mni_vpl VALUES ("LK5_21","072_5_21","LUK","5","21","21","Adudagi wayel yathanggi ojasing amadi Pharisee-sing aduna makhoi masel hainaba hourak-i, “Tengban Mapubu asumna thina ngangliba asi kanano? Pap kokpiba ngambadi Tengban Mapu mahak khaktani.” ");
INSERT INTO mni_vpl VALUES ("LK5_22","072_5_22","LUK","5","22","22","Makhoina khallibadu Jisuna khangladuna makhoida hairak-i, “Nakhoina nakhoigi thamoida karigi adugumna khallibano? ");
INSERT INTO mni_vpl VALUES ("LK5_23","072_5_23","LUK","5","23","23","‘Nahakki napapsing adu kokpirabani’ haibaga ‘Hougattuna chatlu’ haibaga kanana henna laibage? ");
INSERT INTO mni_vpl VALUES ("LK5_24","072_5_24","LUK","5","24","24","Aduga Migi Machanupa aduna taibangpan asida pap kokpinaba matik lei haibadu nakhoina khangnanaba eina nakhoida utkani.” Adudagi Ibungona pangtha-sithabagi leinana naba nupa aduda hairak-i, “Eina nangonda hairi, hougatlu aduga nahakki hipnapham adu loukhattuna nayumda chatlu.” ");
INSERT INTO mni_vpl VALUES ("LK5_25","072_5_25","LUK","5","25","25","Khudak adumaktada nupa aduna makhoi mayamgi mamangda hougatle, aduga mahakki hipnapham adu loukhatlaga Tengban Mapubu thagatladuna mayumda chatkhirammi. ");
INSERT INTO mni_vpl VALUES ("LK5_26","072_5_26","LUK","5","26","26","Maduda makhoi pumnamak angakpa amadi akibana thallammi amasung makhoina Tengban Mapubu thagatladuna hairak-i, “Ngasi eikhoina angakpana thallaba thoudok ama uba phangjare!” ");
INSERT INTO mni_vpl VALUES ("LK5_27","072_5_27","LUK","5","27","27","Madugi matungda, Jisuna mapham adu thadoktuna lakpada maming Levi kouba kanggat khomba nupa amana kanggat thipham loisangda phamduna leiba urabada nupa aduda hairak-i, “Eigi itung illu.” ");
INSERT INTO mni_vpl VALUES ("LK5_28","072_5_28","LUK","5","28","28","Maduda Levi-na hougattuna pumnamak thadoklamlaga Ibungogi matung injare. ");
INSERT INTO mni_vpl VALUES ("LK5_29","072_5_29","LUK","5","29","29","Adudagi Jisugidamak Levi-na achouba chaklen ama mayumda sillammi aduga yamlaba kanggat khombasing amadi atoppa mioi kaya amasu chaklen aduda makhoiga chaminnarammi. ");
INSERT INTO mni_vpl VALUES ("LK5_30","072_5_30","LUK","5","30","30","Adubu phariseesing amadi makhoigi kanglupta chanba wayel yathanggi ojasing kharana Ibungogi tung-inbasinggi mathakta wakatladuna hairak-i, “Nakhoina kanggat khombasing aduga atoppa papchenbasing asiga chamin-thakminnariba karigino?” ");
INSERT INTO mni_vpl VALUES ("LK5_31","072_5_31","LUK","5","31","31","Maduda Jisuna makhoida khumlak-i, “Masa phabasinggidi laiyengba mi mathou tade adubu anabasinggidamaktadi mathou tai. ");
INSERT INTO mni_vpl VALUES ("LK5_32","072_5_32","LUK","5","32","32","Eina achumba chatpasingbu kouba lakpa natte adubu pappisingbu pukning honglaknaba kouba lakpani.” ");
INSERT INTO mni_vpl VALUES ("LK5_33","072_5_33","LUK","5","33","33","Nongma mioi kharana Jisuda hai, “John amadi mahakki tung-inbasingnadi itat-tattana chara henduna haijei, aduga matou adumna pharisee-singnasu tou-i; adubu nahakki tung-inbasingnadi adumak cha-thaktuna leiriba karigino?” ");
INSERT INTO mni_vpl VALUES ("LK5_34","072_5_34","LUK","5","34","34","Maduda Jisuna makhoida khumlak-i, “Borgi marup-mapangsingna borga loinaringei matamda nakhoina makhoibu chara helhanba ngambra? ");
INSERT INTO mni_vpl VALUES ("LK5_35","072_5_35","LUK","5","35","35","Adubu makhoidagi bor adubu pukhigadaba matam ama lakkani, numitsing aduda makhoina chara hengani.” ");
INSERT INTO mni_vpl VALUES ("LK5_36","072_5_36","LUK","5","36","36","Jisuna makhoida pandam amasu hairak-i, “Mi kananasu amanba phida ahanba phi machet photchinde, karigumba mahakna photchinlabadi ahanba phi adu segairakkani, aduga ahanba phi machet aduga amanba aduga chunaroi. ");
INSERT INTO mni_vpl VALUES ("LK5_37","072_5_37","LUK","5","37","37","Aduga kananasu amanba sawun khaoda anouba yu hapnade, karigumba mahakna haplabadi anouba yu aduna sawun khao adu pokhaihangani amasung yu adu heidokkani aduga khao adusu manggani. ");
INSERT INTO mni_vpl VALUES ("LK5_38","072_5_38","LUK","5","38","38","Madugi mahutta anouba yudi ahanba sawun khaosingda hapkadabani. ");
INSERT INTO mni_vpl VALUES ("LK5_39","072_5_39","LUK","5","39","39","Aduga kananasu ariba yu thaklaba matungda anouba yu pamloi. Maramdi mahakna haigani, ‘Ariba asina henna phei.’ ” ");
INSERT INTO mni_vpl VALUES ("LK6_1","072_6_1","LUK","6","1","1","Potthaba numit amada Jisuna mahei maronggi loubuk phaoduna chatlammi. Amasung Ibungogi tung-inbasingna gehu charong khara heklaga makhutna noithoktuna charammi. ");
INSERT INTO mni_vpl VALUES ("LK6_2","072_6_2","LUK","6","2","2","Maduda pharisee kharana makhoida hanglak-i, “Nakhoina Potthaba numitta touphade haina eikhoigi wayel yathangna haiba adu nakhoina touriba karigino?” ");
INSERT INTO mni_vpl VALUES ("LK6_3","072_6_3","LUK","6","3","3","Jisuna makhoida khumlak-i, “David amadi mahakka loinabasingna lamlaba matamda David-na kari toukhibage haibadu nakhoina Mapugi puyada padabra? ");
INSERT INTO mni_vpl VALUES ("LK6_4","072_6_4","LUK","6","4","4","Mahakna Tengban Mapugi yumda changduna purohitsing khaktana chagadaba Tengban Mapuda katthokkhraba tal adu louduna chakhi amasung mahakka loinabasingdasu pikhi.” ");
INSERT INTO mni_vpl VALUES ("LK6_5","072_6_5","LUK","6","5","5","Adudagi Jisuna makhoida haikhi, “Migi machanupa adu Potthaba numitkisu Mapuni.” ");
INSERT INTO mni_vpl VALUES ("LK6_6","072_6_6","LUK","6","6","6","Atoppa Potthaba numit amada Jisuna synagogue-ta changduna misingda tambirammi. Amasung mapham aduda yet-thangba makhut pangtha-sithaduna naba nupa ama leirammi. ");
INSERT INTO mni_vpl VALUES ("LK6_7","072_6_7","LUK","6","7","7","Aduga Pharisee amadi Wayel Yathanggi oja kharana Jisubu aranba tou-i haina maral siba yanaba maram thiduna leirammi. Maram aduna makhoina Potthaba Numitta Ibungona anaba phahanbra haiduna Ibungobu cheksinna yenglammi. ");
INSERT INTO mni_vpl VALUES ("LK6_8","072_6_8","LUK","6","8","8","Adubu Ibungona makhoigi wakhaldu khangladuna makhut nama pangtha-sithaba nupa aduda hairak-i, “Hougattuna mamang asida lak-u.” Aduga nupa aduna hougattuna mapham aduda leple. ");
INSERT INTO mni_vpl VALUES ("LK6_9","072_6_9","LUK","6","9","9","Adudagi Jisuna makhoida hairak-i, “Ei nakhoida wahang ama hangge, Wayel yathangna potthaba numitta touba yabasi karino: Aphaba thabak toubra nattraga phattaba thabak toubra? Kanagumbagi thawai kanbara nattraga mang-hanbra?” ");
INSERT INTO mni_vpl VALUES ("LK6_10","072_6_10","LUK","6","10","10","Amasung Ibungona makhoi pumnamakta koina yenglaga nupa aduda hairak-i, “Nahakki nakhut adu tingthok-u.” Aduga mahakna madu toujare, amasung makhuttu hannagum pungpha phajare. ");
INSERT INTO mni_vpl VALUES ("LK6_11","072_6_11","LUK","6","11","11","Maduda makhoi mei houna saorammi amasung Jisugi maiyokta makhoina kari touba yabage haiduna amaga amaga wa tanaba houre. ");
INSERT INTO mni_vpl VALUES ("LK6_12","072_6_12","LUK","6","12","12","Madugi matung matam ikan kannadana nongma Jisuna haijanabagidamak ching amada kakhatlammi amasung mahakna ahing chuppa Tengban Mapuda haijaduna mapham aduda leirammi. ");
INSERT INTO mni_vpl VALUES ("LK6_13","072_6_13","LUK","6","13","13","Amasung ayuk matam oiraklabada Ibungona mahakki tung-inbasing pumnamakpu manakta kourammi amasung makhoi taranithoibu khandoktuna pakhonchatpa haina koure. Makhoising adudi: ");
INSERT INTO mni_vpl VALUES ("LK6_14","072_6_14","LUK","6","14","14","Mahakna Peter hainasu kouba Simon amadi mahakki manao Andrew; Jacob, John, Philip, Bartholomew, ");
INSERT INTO mni_vpl VALUES ("LK6_15","072_6_15","LUK","6","15","15","Matthew, Thomas, Alphaeus-ki machanupa Jacob, Mareibak ningba hainasu kounaba Simon, ");
INSERT INTO mni_vpl VALUES ("LK6_16","072_6_16","LUK","6","16","16","Jacob-ki machanupa Judas amasung yeknabagi michang oikhiba Judas Iscariot-ni. ");
INSERT INTO mni_vpl VALUES ("LK6_17","072_6_17","LUK","6","17","17","Adudagi Jisuna makhoiga loinana chingthaktagi kumtharaktuna leitem manaba mapham amada masing yamlaba mahakki tung-inbasing aduga loinana leplammi. Aduga Judea apumbadagi amasung Jerusalem-dagi aduga Tyre amadi Sidon-gi samudra mapandagi yamlaba miyam amasu mapham aduda leirammi. ");
INSERT INTO mni_vpl VALUES ("LK6_18","072_6_18","LUK","6","18","18","Makhoising adu Ibungogi wa tananaba amasung makhoigi lainasing adu Ibungona phahanbinabagidamak lakpani. Aduga phattaba thawaisingna wahallibasingsu laklammi amasung makhoina madudagi phajarammi. ");
INSERT INTO mni_vpl VALUES ("LK6_19","072_6_19","LUK","6","19","19","Amasung mipum khudingmakna Ibungobu soknaba hotnarammi maramdi Ibungodagi anaba phahanbagi panggal thoraklammi amasung makhoi pumnamakpu anaba phahanbirammi. ");
INSERT INTO mni_vpl VALUES ("LK6_20","072_6_20","LUK","6","20","20","Adudagi Jisuna mahakki tung-inbasing aduda yengladuna hairak-i, “Lairaba nakhoi yaiphabani, Maramdi Tengban Mapugi ningthou leibak adu nakhoigini! ");
INSERT INTO mni_vpl VALUES ("LK6_21","072_6_21","LUK","6","21","21","Houjik lamliba nakhoi yaiphabani, Maramdi nakhoibu thalhanbigani! Houjik kaplibasa nakhoi yaphabani, Maramdi nakhoina nokchagani!” ");
INSERT INTO mni_vpl VALUES ("LK6_22","072_6_22","LUK","6","22","22","“Migi machanupa adugi maramgidamak misingna nakhoibu yengthiraba, inthoklaba, ikaiba piraba, aduga nakhoigi ming thinaba hairaba nakhoi yaiphabani! ");
INSERT INTO mni_vpl VALUES ("LK6_23","072_6_23","LUK","6","23","23","Numit aduda nungaijou amadi haraoduna chongkhatchou maramdi swargada nakhoigi mana chao-i. Maramdi matou adugumna makhoigi mapa mapusingna Tengban Mapugi wa phongdokpiba maichousingdasu toukhi.” ");
INSERT INTO mni_vpl VALUES ("LK6_24","072_6_24","LUK","6","24","24","“Adubu inak-khunba nakhoidi awabanida, Maramdi nakhoina nungngai yaiphaba adu phangkhre! ");
INSERT INTO mni_vpl VALUES ("LK6_25","072_6_25","LUK","6","25","25","Houjik puk thanduna leiriba nakhoi awabanida, Maramdi nakhoina lamgani! Houjik nokliba nakhoi awabanida, Maramdi nakhoina tengtha nao-oigani amasung kapkani!” ");
INSERT INTO mni_vpl VALUES ("LK6_26","072_6_26","LUK","6","26","26","“Mi pumnamakna nakhoigi maramda aphaba haiba matamda nakhoi awabanida; maramdi matou asigumna makhoigi mapa mapusingna Tengban Mapugi wa phongdoksinabasingda toukhi.” ");
INSERT INTO mni_vpl VALUES ("LK6_27","072_6_27","LUK","6","27","27","“Adubu eigi wahei tariba nakhoida eina hairi: Nakhoina nakhoigi yeknabasingbu nungsiyu, nakhoibu yengthibasingda aphaba toubiyu, ");
INSERT INTO mni_vpl VALUES ("LK6_28","072_6_28","LUK","6","28","28","Nakhoibu sirap toubasingbu bor pibiyu, aduga nakhoibu thina toubasinggidamak Tengban Mapuda haijabiyu. ");
INSERT INTO mni_vpl VALUES ("LK6_29","072_6_29","LUK","6","29","29","Kanagumbana nanggi nakhajai namada khupakna tharabadi atoppa nakhajai nama adusu onsillu; kanagumbana nahakki mapangi phurit adu loukhrabadi, nahakki manunggi phurit adubusu loubada thinganu. ");
INSERT INTO mni_vpl VALUES ("LK6_30","072_6_30","LUK","6","30","30","Nangonda nijaba mi khudingmakta pinou, aduga kanagumbana nahakki napot-nachei loukhrabadi amuk hanna piraknanaba hairuganu. ");
INSERT INTO mni_vpl VALUES ("LK6_31","072_6_31","LUK","6","31","31","Misingna nakhoida touhanningba adumak nakhoinasu makhoida tou.” ");
INSERT INTO mni_vpl VALUES ("LK6_32","072_6_32","LUK","6","32","32","“Nakhoibu nungsiba mising adukhaktabu nakhoina nungsirabadi nakhoida kari thagatpham leibage? Maramdi papchenbasing phaobana makhoibu nungsibasingbudi adumak nungsi. ");
INSERT INTO mni_vpl VALUES ("LK6_33","072_6_33","LUK","6","33","33","Aduga nakhoida aphaba thabak touba mising adukhaktada nakhoina aphaba tourabadi nakhoida kari thagatpham leibage? Maramdi papchenbasing phaobanasu adumna adumak tou-i. ");
INSERT INTO mni_vpl VALUES ("LK6_34","072_6_34","LUK","6","34","34","Aduga nakhoida amuk singlakkani haina asha touba mising adukhaktada sel puthoklabadi nakhoida kari thagatpham leibage? Maramdi papchenbasing phaobanasu puthokkhiba senpham adu amuk phanggani haina asha touduna papchenbasingda adumak puthok-i. ");
INSERT INTO mni_vpl VALUES ("LK6_35","072_6_35","LUK","6","35","35","Adubu nakhoina yeknabasingbu nungsiyu, makhoida aphaba toubiyu, aduga singlakpagi wakhal amuk toudana makhoida puthok-u. Adu oirabadi nakhoigi mana chaogani, aduga nakhoina wangthoiraba Tengban Mapugi asengba machasing oigani. Maramdi toubimal khangdabasing amasung phattabasinggi maphamdasu mahakti chanbi hei. ");
INSERT INTO mni_vpl VALUES ("LK6_36","072_6_36","LUK","6","36","36","Aduga nakhoigi napana chanbiheibagum nakhoisu chanbi heiyu.” ");
INSERT INTO mni_vpl VALUES ("LK6_37","072_6_37","LUK","6","37","37","“Kanadasu wayelluganu aduga nakhoibusu wayenbiroi. Kanadasu maral leihanluganu aduga nakhoibusu naral leihanbiroi. Ngakpiyu aduga nakhoibusu ngakpigani. ");
INSERT INTO mni_vpl VALUES ("LK6_38","072_6_38","LUK","6","38","38","Piyu aduga nakhoida pinabigani. Ahenba changda, namsinduna, niksinduna, aduga pathokna nakhoigi phigaoda happigani. Maramdi nakhoina olluriba chang adumakna nakhoidasu amuk ollagani.” ");
INSERT INTO mni_vpl VALUES ("LK6_39","072_6_39","LUK","6","39","39","Aduga Ibungona makhoida pandam asisu haikhi, “Mitangba amana mitangba amabu lamjingba ngambra?” Adumna tourabadi makhoi animak komda taroidra? ");
INSERT INTO mni_vpl VALUES ("LK6_40","072_6_40","LUK","6","40","40","Maheiroi amana mahakki ojadagi henna chaode, adubu mapung phana tamlaba pumnamakna oja adugumna oirakkani. ");
INSERT INTO mni_vpl VALUES ("LK6_41","072_6_41","LUK","6","41","41","“Aduga karigi nahakki namitta leiba ujao adu khangba ngamdraga nachin nanaogi mamitta leiba apikpa u-makup aduda karigi yenglibano? ");
INSERT INTO mni_vpl VALUES ("LK6_42","072_6_42","LUK","6","42","42","Nahakki namitta leiba ujao adu nahakna uba ngamdraga, ‘Ichin inao, nahakki namitta leiba u-makup adu ei louthokpige’ haina nahakki nachin nanaoda nahakna karamna haigani? He, aphasasinnabasa! Nangna ahanbada namitta leiriba ujao adu hanna louthokkho, adudagidi nahakna nachin-nanaogi mittagi u makup adu louthokpada sengna uba ngamgani.” ");
INSERT INTO mni_vpl VALUES ("LK6_43","072_6_43","LUK","6","43","43","“Maramdi aphaba upalda phattaba mahei pande aduga phattaba upalda aphaba mahei pande. ");
INSERT INTO mni_vpl VALUES ("LK6_44","072_6_44","LUK","6","44","44","Upal khudingmakki masak magi mahei adudagi khangngi. Maramdi tingkhang pambidagi heiyit heknade aduga tingkhanggi mongsongdagi anggur heknade. ");
INSERT INTO mni_vpl VALUES ("LK6_45","072_6_45","LUK","6","45","45","Aphaba mina mahakki thamoigi aphaba langeidagi aphaba thabak puthok-i, aduga phattaba mina mahakki thamoigi phattaba langeidagi phattaba thabak puthok-i. Maramdi mathamoida leiribasingdu machinna ngangthok-i. ");
INSERT INTO mni_vpl VALUES ("LK6_46","072_6_46","LUK","6","46","46","“Eina haiba adudi toudraga karigi nakhoina eingonda Ibungo, Ibungo haina kouribano? ");
INSERT INTO mni_vpl VALUES ("LK6_47","072_6_47","LUK","6","47","47","Eingonda laktuna eigi wa taraga madubu thabak oina touba mahak adu kariga manabage haibadu ei nakhoida utke. ");
INSERT INTO mni_vpl VALUES ("LK6_48","072_6_48","LUK","6","48","48","Mahak adudi nungjao mathakta luna touthaduna yumpham thollaga yum sariba mi amagumbani. Aduga ising ichao lakpada ichelna yum aduda saphu kanna yeire, adubu yum adu nungjao mathakta cheksinna saba maramna lenghanba ngamkhide. ");
INSERT INTO mni_vpl VALUES ("LK6_49","072_6_49","LUK","6","49","49","Adubu eigi wa taraga madubu thabak oina toudaba mahak adudi yumpham yaodana leibakta yum saba mi amagumbani. Aduga ising ichao aduna yeibada yum adu ture amasung madubu machet tana thugaire.” ");
INSERT INTO mni_vpl VALUES ("LK7_1","072_7_1","LUK","7","1","1","Jisuna pumnamaksing asi misingda tambiba loiraba matungda Capernaum-da amuk chatlammi. ");
INSERT INTO mni_vpl VALUES ("LK7_2","072_7_2","LUK","7","2","2","Matam aduda lanmi chamagi luchingba amagi yamna luna toujaba manai ama kanna naduna leirammi amasung mahak sigadourammi. ");
INSERT INTO mni_vpl VALUES ("LK7_3","072_7_3","LUK","7","3","3","Aduga lanmi chamagi luchingba aduna Jisugi maramda tarabada, Ibungona lakpiduna mahakki manai adubu phahanbinabagidamak haijarunaba Jihudisinggi ahal-lamansingbu tharammi. ");
INSERT INTO mni_vpl VALUES ("LK7_4","072_7_4","LUK","7","4","4","Adudagi makhoina Jisugi manakta laktuna asumna kanna haijare, “Nupa asi nahakna mateng pangbada matik chaba mini. ");
INSERT INTO mni_vpl VALUES ("LK7_5","072_7_5","LUK","7","5","5","Maramdi mahak Jihudigi misingbu nungsijaba mini aduga mahakna eikhoigidamak synagogue amasu sabire.” ");
INSERT INTO mni_vpl VALUES ("LK7_6","072_7_6","LUK","7","6","6","Adudagi Jisuna makhoiga loinana chatminnare. Amasung makhoina yum yousillakkadaba panglap laptraba matam aduwaida lanmi chamagi luchingba aduna mahakki pao puhalladuna mahakki marupsingbu tharaklaga asumna Ibungoda haihallare, “Ibungo, Nahakna eigi yumda amuk lengbiraktuna nasabu amuk wahanbiraganu. Maramdi Ibungobu eigi yumda kousinjaba ei matik chajade. ");
INSERT INTO mni_vpl VALUES ("LK7_7","072_7_7","LUK","7","7","7","Aduga ei isamak phaoba Ibungogi nanakta laktuna Ibungobu unajaba matik chajade haina ningjei. Aduna yathang aduta pibiyu aduga eigi inaigi anaba phajagani. ");
INSERT INTO mni_vpl VALUES ("LK7_8","072_7_8","LUK","7","8","8","Maramdi ei isamaksu mathakthongba phamnaibasinggi makhada leiba mini, aduga eigi ikhada eigi lanmisingna lei. Makhoigi maraktagi amada ‘Chatlu’ hairaga mahakna chatli aduga amada amuk ‘Lak-u’ hairaga mahakna lak-i. Aduga eigi inaida ‘Madu tou’ hairaga mahakna tou-i.” ");
INSERT INTO mni_vpl VALUES ("LK7_9","072_7_9","LUK","7","9","9","Madu tabada Jisu ngaklammi amasung mahakki tung-illiba miyam aduda onsilladuna hairak-i, “Eina nakhoida hairibasini, Israelsinggi maraktagi phaoba asigumna asuk yamna thajaba asi eina keidoungeida thengnadri!” ");
INSERT INTO mni_vpl VALUES ("LK7_10","072_7_10","LUK","7","10","10","Adudagi pao purakpa mising aduna yumda hankhiba matamda naduna leihouba manai adu phaduna leiramba thengnare. ");
INSERT INTO mni_vpl VALUES ("LK7_11","072_7_11","LUK","7","11","11","Mathanggi numitta Jisuna Nain kouba apikpa sahar amada chatlammi. Aduga mahakki tung-inbasing amasung yamkhraba miyam amana Ibungoga loinarammi. ");
INSERT INTO mni_vpl VALUES ("LK7_12","072_7_12","LUK","7","12","12","Amasung Ibungona apikpa sahar adugi changpham thong yousillakpa matam aduda asiba hakchang ama aroiba mathou mangam pangthoknabagidamak puthoraklammi. Siriba nupa adu lukhrabi amagi amata ngairaba machanupa oirammi, aduga apikpa sahar adugi yamlaba miyam amasu mama aduga loinaraklammi. ");
INSERT INTO mni_vpl VALUES ("LK7_13","072_7_13","LUK","7","13","13","Nupi adu ubada Ibungona nungsiba pokladuna hairak-i, “Kapkanu.” ");
INSERT INTO mni_vpl VALUES ("LK7_14","072_7_14","LUK","7","14","14","Aduga Ibungona changsinduna ku adu sokpada ku puribasing adu chatpa leplammi. Adudagi Ibungona hairak-i, “Pakhang, Eina nangonda hairi hougatlu.” ");
INSERT INTO mni_vpl VALUES ("LK7_15","072_7_15","LUK","7","15","15","Maduda asiba nupa aduna hougatlaktuna phamlaga wa ngangba houre! Amasung Jisuna mahakpu mamada amuk sinnare. ");
INSERT INTO mni_vpl VALUES ("LK7_16","072_7_16","LUK","7","16","16","Maduda makhoi pumnamak akibana thallammi amasung makhoina Tengban Mapubu thagatladuna hairak-i, “Tengban Mapugi wa phongdokpiba matik leiba maichou ama eikhoigi irakta phaorakle, amasung Tengban Mapuna mahakki misingbu kanbinaba lakle!” ");
INSERT INTO mni_vpl VALUES ("LK7_17","072_7_17","LUK","7","17","17","Adudagi Jisugi pao asina Judea apumba amadi akoibada leiba lam pumnamak sin-thungna sandokhre. ");
INSERT INTO mni_vpl VALUES ("LK7_18","072_7_18","LUK","7","18","18","Baptize toubiba Johngi tung-inbasingna masi pumnamaksing asigi maramda Johnda tamlammi. ");
INSERT INTO mni_vpl VALUES ("LK7_19","072_7_19","LUK","7","19","19","Adudagi John-na mahakki tung-inbasinggi maraktagi anibu kouraduna, “Lengbirakkadouriba mahak adu Ibungora, nattraga eikhoina atoppa amabu ngaijakhigadra” haina hangnanaba Jisugi manakta tharaklammi. ");
INSERT INTO mni_vpl VALUES ("LK7_20","072_7_20","LUK","7","20","20","Amasung makhoina Jisugi manakta lakladuna hairak-i, “ ‘Lengbirakkadouriba mahak adu Ibungora, nattraga eikhoina atoppa amabu ngaijakhigadra’ haina hangnanaba baptize toubiba Johnna eikhoibu tharakpani.” ");
INSERT INTO mni_vpl VALUES ("LK7_21","072_7_21","LUK","7","21","21","Matam adumaktada Jisuna anaba mi kayabu makhoigi anabadagi, lainadagi amadi phattaba thawai changbadagi phahanbirammi. Aduga mamit tangba kayabusu uhanbirammi. ");
INSERT INTO mni_vpl VALUES ("LK7_22","072_7_22","LUK","7","22","22","Adudagi Jisuna John-gi pao purakpasing aduda khumlak-i, “Nakhoina John-gi manakta chattuna nakhoina uraba amadi taraba pumnamak tammu: Mit tangbasingna uba phangjare, khongtekpasingna chatpa ngamjare, kiningai oiba unsagi leinana nabasingna sengjare, na pangbasingna taba phangjare, asibasingna hinggatchare amasung lairabasingda Aphaba pao sandokle. ");
INSERT INTO mni_vpl VALUES ("LK7_23","072_7_23","LUK","7","23","23","Aduga eigi maramda chingnaba leitaba mahak adu yaiphabani.” ");
INSERT INTO mni_vpl VALUES ("LK7_24","072_7_24","LUK","7","24","24","Adudagi John-gi pao pubasing aduna chatkhraba matungda Jisuna miyam aduda Johngi maramda haiba hourak-i, “Nakhoina lamjao lamhangda kari yengba chatlubage? Nungsitna yeibada koihum humba awangba napibura? ");
INSERT INTO mni_vpl VALUES ("LK7_25","072_7_25","LUK","7","25","25","Nattragana nakhoina lamjao lamhangda kari yengba chatlubage? Atangba phijol setpa mi amabura? Yengngu, mamal yamba phijol setpa amadi ke-mouduna leiba makhoising adudi ningthou konungsingda leibani. ");
INSERT INTO mni_vpl VALUES ("LK7_26","072_7_26","LUK","7","26","26","Adubu nakhoina kari yengba chatlubage? Tengban Mapugi wa phongdokpiba maichou amabura? Hoi, eina nakhoida hairibasini, mahakti Tengban Mapugi wa takthokpa maichou amadagisu henna chao-i. ");
INSERT INTO mni_vpl VALUES ("LK7_27","072_7_27","LUK","7","27","27","Mapugi puyada iduna leiriba asi mahak asigi maramdani, ‘Eina eigi pao pubabu nahakki lambi thourang tounanaba nahakki namang thana thagani.’ ");
INSERT INTO mni_vpl VALUES ("LK7_28","072_7_28","LUK","7","28","28","Eina nakhoida hairibasini, mioibasinggi marakta Johndagi henna chaoba kanasu leite. Adubu Tengban Mapugi ningthou leibakta khwadagi henna pikpa mahak aduna John-dagi henna chao-i.” ");
INSERT INTO mni_vpl VALUES ("LK7_29","072_7_29","LUK","7","29","29","Adudagi Ibungona haiba adu tarabada kanggat khombasing phaoba yaona, mi pumnamakna John-dagi baptize louduna Tengban Mapugi lambidi achumbani haiba yajakhi. ");
INSERT INTO mni_vpl VALUES ("LK7_30","072_7_30","LUK","7","30","30","Adubu Pharisee-sing amadi wayel yathang khang-heibasing adunadi Johndagi baptize loudaduna Tengban Mapuna makhoigidamak thourangbiba adu yajakhide. ");
INSERT INTO mni_vpl VALUES ("LK7_31","072_7_31","LUK","7","31","31","Adudagi Jisuna amuk makha tana hairak-i, “Adudi eina miron asigi mising asiga kariga changdamnagadage? Makhoiga kariga manabage? ");
INSERT INTO mni_vpl VALUES ("LK7_32","072_7_32","LUK","7","32","32","Makhoidi keithelda sanariba angang machasinggumbani, makhoina amaga amaga kounaduna hai, ‘Eikhoina nakhoigidamak bashi khongngi adubu nakhoina jagoi sade; Aduga eikhoina tengtha nao-oibagi eshei shak-i adubu nakhoina kapte.’ ");
INSERT INTO mni_vpl VALUES ("LK7_33","072_7_33","LUK","7","33","33","Maramdi Baptize toubiba John-na chadana amadi yu thaktana lakle; aduga nakhoina mahakpu lai phattaba leiba mini haibire. ");
INSERT INTO mni_vpl VALUES ("LK7_34","072_7_34","LUK","7","34","34","Aduga amuk Migi Machanupa aduna cha-thaktuna lakle aduga nakhoina mahakpu mapuklaoba, yuthakpa, amadi kanggat khomba amasung pappisinggi marupni haibire. ");
INSERT INTO mni_vpl VALUES ("LK7_35","072_7_35","LUK","7","35","35","Adumakpu, Tengban Mapugi lousingdi achumbani haibasi mabu lousinjariba pumnamakki punsina utle.” ");
INSERT INTO mni_vpl VALUES ("LK7_36","072_7_36","LUK","7","36","36","Pharisee-singgi maraktagi amana Jisubu mayumda chak chaminnanaba kourammi. Amasung Ibungona pharisee adugi yumda chattuna chananabagidamak phamthare. ");
INSERT INTO mni_vpl VALUES ("LK7_37","072_7_37","LUK","7","37","37","Apikpa sahar aduda papki punsida hingbi nupi amasu leirammi. Jisuna pharisee gi yumda laktuna chak chabagi pao adu mahakna tarabada manam nungsiba mamal tanglaba thao happa alabaster nunggi chaphu ama puraklammi. ");
INSERT INTO mni_vpl VALUES ("LK7_38","072_7_38","LUK","7","38","38","Aduga mahakna Jisugi makhong mayada tunglomda lepladuna hikna hikna kapcharammi. Amasung sintharakliba mahakki pirang aduna Ibungogi makhong adu chothallammi. Adudagi mahakna phamtharaduna Ibungogi makhong adu mahakki masamna theithokcharammi amasung Ibungogi makhong adu chupladuna manam nungsiba thao adu teirammi. ");
INSERT INTO mni_vpl VALUES ("LK7_39","072_7_39","LUK","7","39","39","Amasung Ibungobu mayumda koujariba pharisee aduna madu uba matamda mathanta thamoinungda khanjarammi, “Nupa asina karigumba asengbamak Tengban Mapugi wa phongdokpiba maichou oiramlabadi mangonda sokliba nupi asi kanano, karamba nupino haibadi papchenbini haiba mahakna khanglamgadabani.” ");
INSERT INTO mni_vpl VALUES ("LK7_40","072_7_40","LUK","7","40","40","Maduda Jisuna pharisee aduda hairak-i, “Simon, Eina nangonda haigadaba karigumba khara lei.” Mahakna khumlak-i, “Hoi, haibiyu oja Ibungo.” ");
INSERT INTO mni_vpl VALUES ("LK7_41","072_7_41","LUK","7","41","41","Jisuna mangonda hairak-i, “Sel puthokpa nupa amada sel tonba nupa anikhak leirammi. Makhoi anigi maraktagi nupa amana denari chamanga aduga amana yangkhei tollammi. ");
INSERT INTO mni_vpl VALUES ("LK7_42","072_7_42","LUK","7","42","42","Adubu makhoi animakna sel adu singba ngamdrabada nupa aduna makhoina tolliba sel adu kokpire. Adu oirabadi makhoi anigi maraktagi karambana mahakpu henna nungsigadage?” ");
INSERT INTO mni_vpl VALUES ("LK7_43","072_7_43","LUK","7","43","43","Simon-na khumlak-i, “Eina ningjabadadi sendon henna kokpikhipa mahak aduna henna nungsigani.” Jisuna hairak-i, “Nahakna chumna khumle.” ");
INSERT INTO mni_vpl VALUES ("LK7_44","072_7_44","LUK","7","44","44","Adudagi Ibungona nupi aduda onsilladuna Simon-da hairak-i, “Nahakna nupi asi ubra? Eina nanggi yumda changlakpa matamda eigi khong chamnabagidamak nangnadi ishing pikhide, adubu nupi asinadi mahakki mapina eigi khong chamthokpikhi aduga mahakki masamna khong asi teithokpikhi. ");
INSERT INTO mni_vpl VALUES ("LK7_45","072_7_45","LUK","7","45","45","Nahaknadi eibu chuppiduna taramna okkhide, adubu nupi asinadi eina hek changlakpadagi houjik phaoba eigi ikhong asi chuppiba leptri. ");
INSERT INTO mni_vpl VALUES ("LK7_46","072_7_46","LUK","7","46","46","Nangnadi eigi kokta thao teibide, adubu nupi asinadi eigi khongda tanglaba manam nungsiba thao teibiri. ");
INSERT INTO mni_vpl VALUES ("LK7_47","072_7_47","LUK","7","47","47","Eina nakhoida hairi, mahakki pap mayam adu kokpire, maram aduna mahakna thoina henna nungsiba adu utle. Adubu pap khajiktamak kokpikhiba mahak aduna khajiktamak nungsi.” ");
INSERT INTO mni_vpl VALUES ("LK7_48","072_7_48","LUK","7","48","48","Adudagi Jisuna nupi aduda hairak-i, “Nahakki papsing adu kokpire.” ");
INSERT INTO mni_vpl VALUES ("LK7_49","072_7_49","LUK","7","49","49","Maduda chaklen aduda Ibungoga loinana phamminnaribasing aduna makhoi maselgi marakta hainaba hourak-i, “Pap phaoba kokpiba ngamba mahak asi kanano?” ");
INSERT INTO mni_vpl VALUES ("LK7_50","072_7_50","LUK","7","50","50","Adudagi Jisuna nupi aduda hairik-i, “Nahakki thajabana nahakpu kanbire; ingthana chatcharo.” ");
INSERT INTO mni_vpl VALUES ("LK8_1","072_8_1","LUK","8","1","1","Masigi matungda Jisuna Tengban Mapugi Ningthou leibakki Aphaba Pao sandoktuna sahar saharda amadi khunggang khunggangda chatlammi. Aduga tung-inba taranithoi adu Ibungoga loinarammi. ");
INSERT INTO mni_vpl VALUES ("LK8_2","072_8_2","LUK","8","2","2","Amasung lai phattaba changlambadagi amadi anaba singdagi Ibungona phahanbikhiba nupi khara haibadi phattaba thawai taret tanthokkhiba Magdalene hainasu koubi Mary, ");
INSERT INTO mni_vpl VALUES ("LK8_3","072_8_3","LUK","8","3","3","Herod-ki thabak pannaba Cuza-gi nupi Joanna, Susanna amadi atei nupisingsu Ibungoga loinarammi. Makhoina makhoi masagi leijaba maran mathumdagi Jisu amadi mahakki tung-inbasingbu mateng panglammi. ");
INSERT INTO mni_vpl VALUES ("LK8_4","072_8_4","LUK","8","4","4","Amasung tongan tonganba saharsingdagi misingna Jisugi manakta laktuna mi chonna tillarabada, Ibungona makhoida pandam asi hairak-i, ");
INSERT INTO mni_vpl VALUES ("LK8_5","072_8_5","LUK","8","5","5","“Lou uba nupa amana maru hunba chatlammi. Amasung mahakna marusing adu loubukta asum hullakpada maru kharana lambida tare aduga madu misingna khongna netkhaire amasung atiyagi ucheksingnasu chakthokle. ");
INSERT INTO mni_vpl VALUES ("LK8_6","072_8_6","LUK","8","6","6","Maru kharana nung marakta tare aduga madu hek hourakpaga ising inin leitabana thuna kangsille. ");
INSERT INTO mni_vpl VALUES ("LK8_7","072_8_7","LUK","8","7","7","Maru kharana tingkang pambi marakta tare aduga tingkhang pambising aduna maduga loinana houminnaraktuna madubu namhatle. ");
INSERT INTO mni_vpl VALUES ("LK8_8","072_8_8","LUK","8","8","8","Atei marusing aduna leihao leiba leibak mathakta tare aduga hougatlaktuna thakhiba adugi saruk chama chama henna mahei yalle.” Amasung Ibungona masi hairaba tungda, khonjel houna hairak-i, “Tananaba nakhong panba mahak aduna tasanu.” ");
INSERT INTO mni_vpl VALUES ("LK8_9","072_8_9","LUK","8","9","9","Adudagi Ibungogi tung-inbasing aduna Ibungoda hanglak-i, “Pandam asigi wahanthok karino?” ");
INSERT INTO mni_vpl VALUES ("LK8_10","072_8_10","LUK","8","10","10","Maduda Ibungona khumlak-i, “Tengban Mapu leibakki athuppa adu nakhoidadi khanghanbire adubu ateisingdadi makhoina una una udanaba aduga tana tana khangdanaba eina pandam oina ngangle.” ");
INSERT INTO mni_vpl VALUES ("LK8_11","072_8_11","LUK","8","11","11","“Pandam asigi wahanthokti asini: Maru adu Tengban Mapugi waheini. ");
INSERT INTO mni_vpl VALUES ("LK8_12","072_8_12","LUK","8","12","12","Aduga lambida tariba marusing aduna Tengban Mapugi wa tarabasing aduni; adubu makhoina thajaduna kanbiba phangdanaba Devilna laktuna makhoigi thamoidagi Tengban Mapugi wa adu louthokhi. ");
INSERT INTO mni_vpl VALUES ("LK8_13","072_8_13","LUK","8","13","13","Nunglakta taba marusing aduna Tengban Mapugi wa taraga haraona lousinbasing aduni, Adubu makhoigi marasingdu luna tadaba maramna makhoina matam khara thajaramlaga changyeng lakpa matamda hekta tukhi. ");
INSERT INTO mni_vpl VALUES ("LK8_14","072_8_14","LUK","8","14","14","Tingkhang pambi marakta taba marusing aduna Tengban Mapugi wa tabasing aduni. Adubu punsigi langtaknaba, lanthum amadi punsigi harao nungaibana namhatkhi, amasung makhoigi maheidu keidoungeida heijing phade. ");
INSERT INTO mni_vpl VALUES ("LK8_15","072_8_15","LUK","8","15","15","Adubu leihao leiba leibak mathakta taba marusing adudi Tengban Mapugi wa adu taraga aphaba amasung haiba injaba thamoida madubu chetna thamjaduna mahei pandriba phaoba khanglibasing aduni.” ");
INSERT INTO mni_vpl VALUES ("LK8_16","072_8_16","LUK","8","16","16","“Mi kananasu thaomei than-gatlaga thumokna kupsinde nattraga kangkhada thamnade. Adubu manungda changlakpasing aduna mangal adu unanaba thaomei makhongda thaomei adu thammi. ");
INSERT INTO mni_vpl VALUES ("LK8_17","072_8_17","LUK","8","17","17","“Maramdi phongdokloidaba arotpa karisu leite, aduga khangloidaba nattraga phongloidaba athuppa karisu leite. ");
INSERT INTO mni_vpl VALUES ("LK8_18","072_8_18","LUK","8","18","18","“Maram aduna nakhoina karamna tabage haibadu cheksillu. Maramdi areiba mahak aduda henna pibigani aduga leitaba mangondagi mahakna leijei haina khanjaba khajiktang adu phaoba louthokkani.” ");
INSERT INTO mni_vpl VALUES ("LK8_19","072_8_19","LUK","8","19","19","Adudagidi Jisugi mama amasung manaosingna mahakpu unaba laklammi, adubu miyam adugi maramna makhoina Ibungogi manakta changba ngamlamde. ");
INSERT INTO mni_vpl VALUES ("LK8_20","072_8_20","LUK","8","20","20","Amasung kanagumba amana Ibungoda hairak-i, “Ibungogi ima amasung inaosingna Ibungobu unaningbagi mapanda leptuna leiri.” ");
INSERT INTO mni_vpl VALUES ("LK8_21","072_8_21","LUK","8","21","21","Maduda Jisuna khumladuna makhoi pumnamak aduda hairak-i, “Tengban Mapugi wa taraga madubu inba makhoi adu eigi ima amasung ichil-inaosingni.” ");
INSERT INTO mni_vpl VALUES ("LK8_22","072_8_22","LUK","8","22","22","Nongma Jisuna magi tung-inbasingda hairak-i, “Eikhoi pat asigi wangmada chatsi.” Adudagi makhoina hida kakhattuna hidu hondokle. ");
INSERT INTO mni_vpl VALUES ("LK8_23","072_8_23","LUK","8","23","23","Amasung makhoina asum hi honduna lakpada Ibungo tumthakhirammi. Adudagi ikhang khanghoudana akanba nonglei nungsit ama pat aduda humjillakle amasung hi aduda ising hajillaktuna makhoi pumnamak yamna khudongthibada tarammi. ");
INSERT INTO mni_vpl VALUES ("LK8_24","072_8_24","LUK","8","24","24","Matamduda tung-inbasing aduna Ibungogi manakta laktuna mahakpu houdoktuna hairak-i, “Oja Ibungo, oja Ibungo! Eikhoi siba tare!” Maduda Ibungona hougatladuna nungsit amasung ithak ipom aduda lepnanaba yathang pirammi. Adudagi nonglei nungshit adu lepkhirammi amasung pumnamak tumin leikhirammi. ");
INSERT INTO mni_vpl VALUES ("LK8_25","072_8_25","LUK","8","25","25","Aduga Ibungona tung-inbasing aduda hanglak-i, “Nakhoigi thajaba adu kadaino?” Maduda makhoina akiba amadi angakpaga loinana amaga amaga hangnarak-i, “Mahak asi karamba mino? Mahakna nungsit amadi ithak-ipomda phaoba yathang pi aduga makhoina mahakna haiba illi.” ");
INSERT INTO mni_vpl VALUES ("LK8_26","072_8_26","LUK","8","26","26","Adudagi Jisu amadi mahakki tung-inbasingna Galilee ipak lanthoktuna Gerasa lamdamda laklammi. ");
INSERT INTO mni_vpl VALUES ("LK8_27","072_8_27","LUK","8","27","27","Amasung Jisuna hidagi kangphalda kumthaba matam aduda sahar aduda leiba lai phattaba changba nupa amaga thengnarammi. Mahak matam kuinadagi maphi marol settana leirammi amasung mayumda leiramde. Adubu mahak mongphamsingda leirammi. ");
INSERT INTO mni_vpl VALUES ("LK8_28","072_8_28","LUK","8","28","28","Mahakna Jisubu hek ubaga kanna laoraduna Ibugogi khuyakhada tuthajaraga ahouba khonjelda hairak-i, “Jisu, Wangthoiraba Tengban Mapugi Macha, nangga eiga kari mari leinabage? Eina nangonda haijari, eibu awaba pibiganu.” ");
INSERT INTO mni_vpl VALUES ("LK8_29","072_8_29","LUK","8","29","29","Mahakna asumna hairibasi Jisuna hanna phattaba thawai aduda mangondagi chatkhinaba yathang pibagi maramnani. Phattaba thawai aduna mahakpu kayarak hanna pharammi, aduga mahakpu phajinduna makhong makhut yotling phalang chanduna thamlabasu mahakna madu pumnamaktu thadatli aduga phattaba thawai aduna chingduna mahakpu lamhang tumhangda puthok-i. ");
INSERT INTO mni_vpl VALUES ("LK8_30","072_8_30","LUK","8","30","30","Adudagi Jisuna mangonda hanglak-i, “Naming kari kou-i?” Maduda mahakna khumlak-i, “Tenggol kou-i.” Maramdi mangonda lai phattaba mayam ama changlammi. ");
INSERT INTO mni_vpl VALUES ("LK8_31","072_8_31","LUK","8","31","31","Adudagi lai phattabasing aduna Ibungoda makhoibu makha naidaba komda chatnanaba yathang pibidanaba hanna hanna haijarammi. ");
INSERT INTO mni_vpl VALUES ("LK8_32","072_8_32","LUK","8","32","32","Aduga yamlaba ok sanggu ama manak nakpa chingmai aduwaida machinjak chaduna leirammi. Amasung phattaba laising aduna Ibungoda makhoibu oksing aduda changhanbinaba haijare. Aduga maduda Ibungona yabire. ");
INSERT INTO mni_vpl VALUES ("LK8_33","072_8_33","LUK","8","33","33","Adudagi lai phattabasing aduna nupa adudagi thoraktuna oksing aduda changlammi amasung angamba chingmai adudagi patta chentharaklaga iraknaduna sire. ");
INSERT INTO mni_vpl VALUES ("LK8_34","072_8_34","LUK","8","34","34","Ok senbasing aduna thokkhiba thoudok adu ubada chenkhiduna saharsing amadi khul khulsingda pao adu talammi. ");
INSERT INTO mni_vpl VALUES ("LK8_35","072_8_35","LUK","8","35","35","Aduga thoudok adu yengnaba misingna thoraklammi. Adudagi makhoina Jisugi manakta lakpa matamda lai phattaba changlambadagi thokkhraba nupa adu maphi settuna wakhal tana Jisugi khuyada phamduna leiba adu makhoina thengnarammi amasung maduda makhoi kirammi. ");
INSERT INTO mni_vpl VALUES ("LK8_36","072_8_36","LUK","8","36","36","Amasung thoudok adubu uhouba mising aduna phattaba lai changba nupa aduna kamdouna phakhibage haibadu mising aduda tamlammi. ");
INSERT INTO mni_vpl VALUES ("LK8_37","072_8_37","LUK","8","37","37","Adudagi Gerasa-gi akoibada leiba miyam apumba aduna Jisuda mapham adu thadoktuna chatpikhinaba haijarammi, maramdi makhoi adukki matik kirammi. Maram aduna Jisuna hida tongladuna mapham adu thadoknaba touba matamda, ");
INSERT INTO mni_vpl VALUES ("LK8_38","072_8_38","LUK","8","38","38","Lai phattaba changlamba nupa aduna Jisuda haijarak-i, “Eihaksu Ibungoga loinana chatchage.” Adubu Jisuna asumna hairaduna nupa adu thakhirammi, ");
INSERT INTO mni_vpl VALUES ("LK8_39","072_8_39","LUK","8","39","39","“Nahakna yumda handuna Tengban Mapuna nangonda kayada chaoba thabak toubikhre haibadu tamlu” Aduga nupa aduna chatkhraga Jisuna mangonda kayada chaoba thabak toubikhibage haibadu sahar sinba thungna tamlammi. ");
INSERT INTO mni_vpl VALUES ("LK8_40","072_8_40","LUK","8","40","40","Jisuna patki wangmada halakpa matamda miyamna mabu haraona oklammi, maramdi makhoi pumnamakna Ibungobu ngaiduna leirammi. ");
INSERT INTO mni_vpl VALUES ("LK8_41","072_8_41","LUK","8","41","41","Adudagi maming Jairus kouba synagogue-ki luchingba ama laktuna Jisugi khuyada tuthajaduna mahakki yumda Ibungona lakpinaba haijarammi, ");
INSERT INTO mni_vpl VALUES ("LK8_42","072_8_42","LUK","8","42","42","Maramdi mahakki chahi taranithoi surabi amata pokchabi machanupi sigadourammi. Aduga Jisuna lambida lakpada miyam aduna Ibungogi maikei khudingmakta yomsillammi. ");
INSERT INTO mni_vpl VALUES ("LK8_43","072_8_43","LUK","8","43","43","Makhoisingdugi marakta chahi taranithoi chupna ee taduna naraklabi ama yaorammi. Mahakna laiyengba mi kaya amada mahakki leijaba pumanmak puthoktuna layenglurabasu kana amatana mahakpu phahanba ngamlamde. ");
INSERT INTO mni_vpl VALUES ("LK8_44","072_8_44","LUK","8","44","44","Amasung mahakna Ibungogi tungda laktuna Ibungogi phijida sokcharammi aduga khudak aduda mahakki ee taramba adu lepkhirammi. ");
INSERT INTO mni_vpl VALUES ("LK8_45","072_8_45","LUK","8","45","45","Maduda Jisuna hanglak-i, “Kanana eingonda sokhibage?” Aduga pumnamakna sokte hairabada, Peter-na Ibungoda hairak-i, “Oja Ibungo, Mi pumnamakna Ibungoda omsinduna insinnabanani .” ");
INSERT INTO mni_vpl VALUES ("LK8_46","072_8_46","LUK","8","46","46","Adubu Jisuna hairak-i, “Kanagumba amana eibu sokkhre maramdi eingondagi panggal thokkhiba adu ei khangngi.” ");
INSERT INTO mni_vpl VALUES ("LK8_47","072_8_47","LUK","8","47","47","Adudagi nupi aduna lotpa yararoi haiba khanglabada tanik tanikna laklaga Ibungogi khuyada tuthajarammi. Aduga mahakna Ibungoda kari maramgidamak sokkhiba aduga kamdouna mahakki anabadu khudaktuda phakhibage haibadu miyam adugi mangda mahakna haidokle. ");
INSERT INTO mni_vpl VALUES ("LK8_48","072_8_48","LUK","8","48","48","Maduda Ibungona mangonda hairak-i, “Ichanupi, Nanggi thajabana nahakpu phahanbire; ingthana chatcharo.” ");
INSERT INTO mni_vpl VALUES ("LK8_49","072_8_49","LUK","8","49","49","Jisuna wa asi hairingei matamduda synagogue-ki luchingba Jairus-ki yumdagi paopuba mi ama laktuna Jairus-ta hairak-i, “Nahakki nachanupi sire, aduna oja Ibungobu amuk wahalluraganu.” ");
INSERT INTO mni_vpl VALUES ("LK8_50","072_8_50","LUK","8","50","50","Hairiba adu tabada Jisuna Jairus-ta hairak-i, “Kiganu, thada thajou aduga mahakpu soidana phahanbigani.” ");
INSERT INTO mni_vpl VALUES ("LK8_51","072_8_51","LUK","8","51","51","Adudagi makhoina Jairus-ki yumda thunglabada, Jisuna Peter, John, Jacob amadi nupimacha adugi mama mapa nattana kana amatabu manungda changhallamde. ");
INSERT INTO mni_vpl VALUES ("LK8_52","072_8_52","LUK","8","52","52","Aduga mi pumnamakna nupimacha adugidamak kaplammi amasung tengtha nawoirammi. Adubu Jisuna hairak-i, “Kapkanu, mahak siba natte, mahak tumlibani.” ");
INSERT INTO mni_vpl VALUES ("LK8_53","072_8_53","LUK","8","53","53","Maduda makhoi pumnamakna mahak sire haiba khangbana Ibungobu noknarammi. ");
INSERT INTO mni_vpl VALUES ("LK8_54","072_8_54","LUK","8","54","54","Adubu Jisuna mahakki makhuttu pairaduna houna hairak-i, “Nupimacha, hougatlu.” ");
INSERT INTO mni_vpl VALUES ("LK8_55","072_8_55","LUK","8","55","55","Maduda nupimacha adugi thawaidu amuk hallaktuna mahak khudak aduda lepkhatlakle. Adudagi Jisuna nupimacha aduda chananaba karigumba khara pinanaba makhoida hairammi. ");
INSERT INTO mni_vpl VALUES ("LK8_56","072_8_56","LUK","8","56","56","Amasung nupimacha adugi mama mapa adu ingak ngaklammi, adubu thokhiba thoudok adu mi kana amatada tamthoktanaba Ibungona makhoida yathang pirammi. ");
INSERT INTO mni_vpl VALUES ("LK9_1","072_9_1","LUK","9","1","1","Nongma Jisuna tung-inba taranithoibu punna kouraduna lai phattaba pumnamakpu tanthokpa ngamnaba amadi laina makheibu phahanba ngamnaba panggal amadi matik pirammi. ");
INSERT INTO mni_vpl VALUES ("LK9_2","072_9_2","LUK","9","2","2","Adudagi Ibungona makhoibu Tengban Mapugi ningthou leibak sandoknaba amasung anabasingbu phahannaba tharammi. ");
INSERT INTO mni_vpl VALUES ("LK9_3","072_9_3","LUK","9","3","3","Aduga mahakna makhoida hairak-i, “Nakhoina chatpa matamda khongchat adugidamakta cheisu, khao, chananaba pot, sen amadi phurit phaoba anisuna puganu. ");
INSERT INTO mni_vpl VALUES ("LK9_4","072_9_4","LUK","9","4","4","Nakhoina changba yum aduda nakhoina mapham adu hek thadoktriphaoba leiyu. ");
INSERT INTO mni_vpl VALUES ("LK9_5","072_9_5","LUK","9","5","5","Aduga kanagumbana nakhoibu lousindrabadi nakhoina sahar adu thadokpa matamda makhoigi mathakta cheksin wa oinanaba nakhoigi khongya uphul adu kanthoklammu.” ");
INSERT INTO mni_vpl VALUES ("LK9_6","072_9_6","LUK","9","6","6","Adudagi makhoina mapham adu thadoktuna khunggang khunggangsingda chattuna mapham khudingmakta Aphaba Pao sandoklammi amasung anabasingbu phahallammi. ");
INSERT INTO mni_vpl VALUES ("LK9_7","072_9_7","LUK","9","7","7","Galilee-gi leingak mapu Herod-na Jisuna touriba pumnamaksing asi tabada mahak yamna chamamnarammi. Maramdi baptize toubiba John asibadagi hinggatkhre haina mi kharana hairammi. ");
INSERT INTO mni_vpl VALUES ("LK9_8","072_9_8","LUK","9","8","8","Aduga atoppa kharana Elijah thorakle hairammi aduga atoppa kharana amuk mamangngeigi Tengban Mapugi wa phongdokpiba maichousinggi maraktagi ama sibadagi hinggatlakle haina hainarammi. ");
INSERT INTO mni_vpl VALUES ("LK9_9","072_9_9","LUK","9","9","9","Maduda Herod na hai, “John-di eina mangak kak-hankhrabani; adu oiragadi, eina pao mayam ama tariba mahak asina kanano?” Adudagi mahakna Jisubu unanaba hotnarammi. ");
INSERT INTO mni_vpl VALUES ("LK9_10","072_9_10","LUK","9","10","10","Aduga pakhonchatpasingna halaklabada makhoina toukhiba pumnamaksing adu Jisuda tamlammi. Adudagi Ibungona makhoibu puraduna makhoikhaktamak Bethsaida sahargi achikpa mapham amada chatlammi. ");
INSERT INTO mni_vpl VALUES ("LK9_11","072_9_11","LUK","9","11","11","Adubu miyam aduna madu khangladuna Ibungogi matung illaklammi. Amasung Ibungona makhoibu taramna okladuna Tengban Mapu leibakki maramda takpirammi amadi anabasingbu phahanbirammi. ");
INSERT INTO mni_vpl VALUES ("LK9_12","072_9_12","LUK","9","12","12","Numit taramdai matamda tung-inba taranithoi aduna Ibungogi manakta changlaktuna hairak-i, “Miyam asina akoibada leiba khungangsingda amadi khunsingda chattuna thungpham chapham thijarunaba makhoibu thabikhro. Maramdi eikhoina leiriba asi mi tadaba lamhangni.” ");
INSERT INTO mni_vpl VALUES ("LK9_13","072_9_13","LUK","9","13","13","Maduda Jisuna makhoida hairak-i, “Nakhoina makhoida chananaba karigumba khara piyu.” Makhoina khumlak-i, “Eikhoina chattuna miyam pumnamak asigi chananaba leiruba nattragadi, eikhoida leiriba haibabu tal manga amadi nga ani asida mangaire.” ");
INSERT INTO mni_vpl VALUES ("LK9_14","072_9_14","LUK","9","14","14","Maramdi mapham aduda nupa lising mangarom leirammi. Adudagi Jisuna tung-inbasing aduda hairak-i, “Mising adubu mi yangkhei yangkheigi kangbu semduna phamhallu.” ");
INSERT INTO mni_vpl VALUES ("LK9_15","072_9_15","LUK","9","15","15","Aduga tung-inbasing aduna adumna touduna makhoi pumnamakpu phamhalle. ");
INSERT INTO mni_vpl VALUES ("LK9_16","072_9_16","LUK","9","16","16","Adudagi Jisuna tal manga amadi nga ani adu louraga swargada yengkhattuna Tengban Mapubu thagatchare. Aduga Ibungona talsing amadi nga adu segairaduna miyam aduda yenthoknanaba mahakki tung-inbasingda pire. ");
INSERT INTO mni_vpl VALUES ("LK9_17","072_9_17","LUK","9","17","17","Amasung makhoi pumnamakna mapuk thanna chare. Aduga makhoina chabagi lemhouba tal amasung nga machetsing adu Ibungogi tung-inbasingna thumok taranithoi thanna khomgatle. ");
INSERT INTO mni_vpl VALUES ("LK9_18","072_9_18","LUK","9","18","18","Nongma Jisuna mathanta haijaduna leirammi. Amasung mahakki manakta tung-inbasing khaktamak mahakka loinarammi. Ibungona makhoida hanglak-i, “Miyamna eibu kanani haina hainabage?” ");
INSERT INTO mni_vpl VALUES ("LK9_19","072_9_19","LUK","9","19","19","Maduda makhoina khumlak-i, “Mi kharanadi Ibungobu baptize toubiba John-ni hainei, aduga mi kharana Elijah-ni hai, aduga mi khara amanadi mamangeigi Tengban Mapugi wa phongdokpiba maichousinggi maraktagi amana amuk hingatlakpani hainei.” ");
INSERT INTO mni_vpl VALUES ("LK9_20","072_9_20","LUK","9","20","20","Adudagi Ibungona makhoida hanglak-i, “Adubu nakhoinadi eibu kanani hainabage?” Maduda Peter-na khumlak-i, “Ibungo nahakti Tengban Mapuna thabirakpa Christta aduni.” ");
INSERT INTO mni_vpl VALUES ("LK9_21","072_9_21","LUK","9","21","21","Adudagi Jisuna makhoida madu mi kanadasu haidananaba akanba yathang pirammi. ");
INSERT INTO mni_vpl VALUES ("LK9_22","072_9_22","LUK","9","22","22","Aduga Jisuna makhoida asimasu hairak-i, “Migi Machanupa adu awaba nangba tai aduga ahal lamansing, athoiba purohitsing amasung wayel yathanggi ojasingna mahakpu yadaba tai. Mahakpu hatkani, adubu humni suba numitta mahakna amuk hinggatkani.” ");
INSERT INTO mni_vpl VALUES ("LK9_23","072_9_23","LUK","9","23","23","Adudagi mahakna makhoi pumnamakta hairak-i, “Kanagumba amana eigi itung inninglabadi, mahakna masabu yajadasanu aduga numit khuding masagi cross thanggatchaduna eigi itung insanu. ");
INSERT INTO mni_vpl VALUES ("LK9_24","072_9_24","LUK","9","24","24","Kanagumba amana mathawai kanjaba pamlabadi madu mangjagani, adubu eigi maramgidamak mathawai mangjarabadi mahakki thawai adu kanba phangjagani. ");
INSERT INTO mni_vpl VALUES ("LK9_25","072_9_25","LUK","9","25","25","Mi amana taibangpan apumba phangjaraga mahak masamak mangjarabadi nattraga maithijarabadi, mahakki kari tongjaba leibage? ");
INSERT INTO mni_vpl VALUES ("LK9_26","072_9_26","LUK","9","26","26","Kanagumbana eigidamak amasung eigi waheigidamak ikairabadi, Migi Machanupa aduna mahak masagi, Mapagi amadi asengba swarga dutsinggi matik mangalga loinana lenglakpa matam aduda mahak adugidamak ikaigani. ");
INSERT INTO mni_vpl VALUES ("LK9_27","072_9_27","LUK","9","27","27","Eina nakhoida tasengnamak hairibasini, mapham asida lepliba makhoi kharadi Tengban Mapugi ningthouleibak aduna lakpa udriba phaoba sibagi mahao tangloi.” ");
INSERT INTO mni_vpl VALUES ("LK9_28","072_9_28","LUK","9","28","28","Ibungona waheising asi haikhiba matung numit nipannimukki matungda, Peter, John amadi Jacob-pu puraduna Ibungona ching amada haijananabagidamak kakhatlammi. ");
INSERT INTO mni_vpl VALUES ("LK9_29","072_9_29","LUK","9","29","29","Aduga Ibungona haijaringeida Ibungogi maithong honglakle aduga mahakki phijondu nganna langna ngourakle. ");
INSERT INTO mni_vpl VALUES ("LK9_30","072_9_30","LUK","9","30","30","Amasung ikhang khanghoudana nupa anikhak thoraktuna Ibungoga wari sanarammi. Makhoi ani adudi Moses amasung Elijah-ni. ");
INSERT INTO mni_vpl VALUES ("LK9_31","072_9_31","LUK","9","31","31","Makhoina swargagi matik mangalga loinana thoraklammi. Amasung makhoina, Ibungona thuna thunghangadouriba Tengban Mapugi thourang haibadi mahakna Jerusalemda sibigadouba matou adugi maramda Jisuga wari sannarammi. ");
INSERT INTO mni_vpl VALUES ("LK9_32","072_9_32","LUK","9","32","32","Peter amasung mahakka loinabasing adudi ningngaidana tumlammi, adubu makhoina hougatpa matamda Jisugi matik mangal amadi mahakka loinana lepminnariba nupa ani adu ure. ");
INSERT INTO mni_vpl VALUES ("LK9_33","072_9_33","LUK","9","33","33","Aduga Moses amadi Elijah-na Jisuga khainaramdai matam aduda Peter-na Ibungoda hairak-i, “Oja Ibungo, eikhoina mapham asida leijabasi eikhoigidamak kayada phakhraba! Eikhoina sang ahum, Ibungogi ama, Moses-gi ama, amasung Elijah-gi ama sasi.” (Mahakna haijariba adu kari hairibano haiba Peter-na khangjaramde.) ");
INSERT INTO mni_vpl VALUES ("LK9_34","072_9_34","LUK","9","34","34","Mahakna nganglingeimaktada leichil ama thoraktuna makhoibu khanjinlammi; aduga leichil aduna makhoibu kupsinba aduda tung-inbasing adu kirammi. ");
INSERT INTO mni_vpl VALUES ("LK9_35","072_9_35","LUK","9","35","35","Adudagi leichil marak adudagi khonjel amana hairak-i, “Masi eina khandoklaba eigi nungsiraba Ichanupani, mahakna haiba tao!” ");
INSERT INTO mni_vpl VALUES ("LK9_36","072_9_36","LUK","9","36","36","Khonjel aduna lepkhraba matungda tung-inbasing aduna mapham aduda Jisukhaktamak leiba urammi. Aduga thokkhiba pumnamaksing adugi maramda makhoi tumin leirammi amasung makhoina ukhibasing adu matam aduda makhoina mi kanadasu tamthoklamde. ");
INSERT INTO mni_vpl VALUES ("LK9_37","072_9_37","LUK","9","37","37","Mathanggi numitta makhoina chingthaktagi kumtharaklammi, aduga yamlaba miyam amana Ibungoga unarammi. ");
INSERT INTO mni_vpl VALUES ("LK9_38","072_9_38","LUK","9","38","38","Aduga miyam adugi maraktagi nupa amana laoraduna hairak-i, “Oja, eina nangonda haijari, eigi ichanupa asibu yengbiyu, mahak eigi amata ngairaba ichanupani. ");
INSERT INTO mni_vpl VALUES ("LK9_39","072_9_39","LUK","9","39","39","Phattaba thawai amana mahakpu phajinduna mahakpu khanghoudana lao-khonghalli aduga mahakpu tamthina nikhanduna mayada konggol kahalli. Aduga mahakpu thina asok apan thokhallaga phattaba thawai adu thokningdana mangondagi thokkhi. ");
INSERT INTO mni_vpl VALUES ("LK9_40","072_9_40","LUK","9","40","40","Eina Ibungogi tung-inbasingda phattaba thawai adubu tanthokpinaba haijarambani, adubu makhoina tanthokpa ngamdre.” ");
INSERT INTO mni_vpl VALUES ("LK9_41","072_9_41","LUK","9","41","41","Maduda Jisuna hairak-i, “He thajaba leitaba amadi phattaba miron! Kayam kuina eina nakhoiga leiminnaduna khangkhigadage?” Adudagi Ibungona nupa aduda hairak-i, “Nachanupa adu maphamasida pusillak-u.” ");
INSERT INTO mni_vpl VALUES ("LK9_42","072_9_42","LUK","9","42","42","Nupamacha aduna changlakpa matam adudasu phattaba thawai aduna mahakpu leimaida inthuduna mahakpu tamthina nikhallammi. Adubu Jisuna phattaba thawai aduda yathang piraduna nupamacha adubu phahanbiraga, mahakpu mapada amuk pibirammi. ");
INSERT INTO mni_vpl VALUES ("LK9_43","072_9_43","LUK","9","43","43","Aduga makhoi pumnamakna Tengban Mapugi matik leiraba pangal aduda yamna ngaklammi. Jisuna toukhibasing aduda miyam aduna ingak ngaktuna leiringeida Ibungona mahakki tung-inbasing aduda hairak-i, ");
INSERT INTO mni_vpl VALUES ("LK9_44","072_9_44","LUK","9","44","44","“Eina haigadouriba wasing asi pukning changna tao! Migi Machanupa adubu misinggi makhutta pithokkadouri.” ");
INSERT INTO mni_vpl VALUES ("LK9_45","072_9_45","LUK","9","45","45","Adubu Ibungona hairiba adu karino haiba tung-inbasing aduna khangba ngamlamde. Makhoina madu khangba ngamdanaba wa adugi nunggi oiba wahandok adu lottuna thamlammi. Aduga makhoina madugi maramda Ibungoda hangbasu kirammi. ");
INSERT INTO mni_vpl VALUES ("LK9_46","072_9_46","LUK","9","46","46","Adudagi makhoigi marakta kanana khwaidagi henna chaobage haiduna tung-inbasinggi marakta yetnaba hourammi. ");
INSERT INTO mni_vpl VALUES ("LK9_47","072_9_47","LUK","9","47","47","Makhoina khalliba wakhal adu Jisuna khangladuna apikpa angang amabu pairaduna mahakki nakalda lephallaga, ");
INSERT INTO mni_vpl VALUES ("LK9_48","072_9_48","LUK","9","48","48","Makhoida hairak-i, “Kanagumbana apikpa angang asibu eigi mingda lousillabadi eibu lousinbani; aduga kanagumbana eibu lousillabadi eibu tharakpa Ibungo mahakpu lousillabani. Maramdi nakhoigi maraktagi khwadagi tonthajaba mahak aduna khwadagi chaoba oigani.” ");
INSERT INTO mni_vpl VALUES ("LK9_49","072_9_49","LUK","9","49","49","Aduga John-na hairak-i, “Oja Ibungo, eikhoina Ibungogi mingda lai phattabasing tanthokpa mi ama ujei amasung eikhoina mangonda madu toknanaba hairammi maramdi mahak eikhoigi irakta yaoba mi natte.” ");
INSERT INTO mni_vpl VALUES ("LK9_50","072_9_50","LUK","9","50","50","Maduda Jisuna hairak-i, “Mahakpu thingluganu, maramdi eikhoigi maiyokta leitaba mahak adu eikhoigini.” ");
INSERT INTO mni_vpl VALUES ("LK9_51","072_9_51","LUK","9","51","51","Jisubu swargada loukhatkadaba matam adu naksillaklabada Ibungona Jerusalemda chatnanaba chetna leplammi. ");
INSERT INTO mni_vpl VALUES ("LK9_52","072_9_52","LUK","9","52","52","Aduga Ibungona mahakki thungpham thourang tounanaba pao-pubasingbu mahakki mang thana Samaria-gi khunggangda tharammi. ");
INSERT INTO mni_vpl VALUES ("LK9_53","072_9_53","LUK","9","53","53","Adubu mapham adugi misingna mahakpu lousillamde. Maramdi Ibungona Jerusalemda chatlibani haibadu sengna khanglammi. ");
INSERT INTO mni_vpl VALUES ("LK9_54","072_9_54","LUK","9","54","54","Aduga tung-inba Jacob amadi John-na madu ubada, makhoina Jisuda hairak-i, “Ibungo, Elijah-na toukhibagum makhoibu mang-hannaba eikhoina swargadagi mei kouthaba Ibungona pambibra?” ");
INSERT INTO mni_vpl VALUES ("LK9_55","072_9_55","LUK","9","55","55","Maduda Jisuna makhoida onsillaktuna makhoibu cheirammi, aduga hairak-i, “Nakhoi karamba thawaigi oiba misingno haibadu nakhoi khangdre. ");
INSERT INTO mni_vpl VALUES ("LK9_56","072_9_56","LUK","9","56","56","Maramdi Migi Machanupa adu migi punsibu manghannanaba lakpa natte adubu makhoibu kanbinanaba lakpani.” Adudagi Jisu amasung mahakki tung-inbasing aduna atoppa khunggang amada chatkhirammi. ");
INSERT INTO mni_vpl VALUES ("LK9_57","072_9_57","LUK","9","57","57","Aduga makhoina lambida asum chatlingeida kanagumba nupa amana Jisuda hairak-i, “Ibungona chatpa mapham khudingda eina Ibungogi tung-injagani.” ");
INSERT INTO mni_vpl VALUES ("LK9_58","072_9_58","LUK","9","58","58","Maduda Jisuna mangonda hairak-i, “Lamhuisinggi makon lei, aduga atiyagi ucheksingsu mahum lei, adubu Migi Machanupa adugidi makok ngathapham mapham phaoba leite.” ");
INSERT INTO mni_vpl VALUES ("LK9_59","072_9_59","LUK","9","59","59","Aduga Ibungona atoppa nupa amada hairak-i, “Itung illu.” Adubu nupa aduna hairak-i, “Ibungo, eina yumda hanna hanjaduna ipabu leiron chanjarukhige!” ");
INSERT INTO mni_vpl VALUES ("LK9_60","072_9_60","LUK","9","60","60","Maduda Jisuna mangonda hairak-i, “Asibasingna masagi asibasingbu leiron chanjasanu; adubu nahakti chattuna Tengban Mapugi leibak adu sandok-u.” ");
INSERT INTO mni_vpl VALUES ("LK9_61","072_9_61","LUK","9","61","61","Aduga atoppa amanasu hairak-i, “Ibungo, eina nanggi natung injagani, adubu eina hanna yumda hanjaduna eigi imung manunggi misingda khainabagi wa haijaruge.” ");
INSERT INTO mni_vpl VALUES ("LK9_62","072_9_62","LUK","9","62","62","Adubu Jisuna mangonda hairak-i, “Langgol khutna pairaga tunglomda yengba mi kana amatana Tengban Mapugi leibakkidamak matik chade.” ");
INSERT INTO mni_vpl VALUES ("LK10_1","072_10_1","LUK","10","1","1","Madugi matungda Ibungona atoppa humphutaranithoi khandoktuna makhoibu ani ani semlaga mahakna chatkadaba sahar khudingda amadi mapham khudingda mahakki mang thana tharammi. ");
INSERT INTO mni_vpl VALUES ("LK10_2","072_10_2","LUK","10","2","2","Aduga Ibungona makhoida hairak-i, “Lokkadaba loudi yammi, adubu lokpinaba midi yamde; maram aduna mahakki lou lokphamda thabak suba mi thabiraknaba lourok mapuda haijou. ");
INSERT INTO mni_vpl VALUES ("LK10_3","072_10_3","LUK","10","3","3","Chatlu! Eina nakhoibu keisalsinggi marakta yao machasinggum thari. ");
INSERT INTO mni_vpl VALUES ("LK10_4","072_10_4","LUK","10","4","4","Nakhoina sengao, khao nattraga sandal puduna chatkanu aduga lambida kanagasu kouna-saknabagidamak panganu. ");
INSERT INTO mni_vpl VALUES ("LK10_5","072_10_5","LUK","10","5","5","Adubu nakhoina kanagumbagi yumda changba matamda asumna hanna haiyu, ‘Yum asigi mathakta ingthaba oisanu.’ ");
INSERT INTO mni_vpl VALUES ("LK10_6","072_10_6","LUK","10","6","6","Aduga imung aduda kanagumba ingthaba pamba mi leiramlabadi nakhoigi ingthabagi yaipha-thoujal adu mahakki mathakta leisanu. Adubu ingthaba pamba mi leiramdrabadi nakhoina pikhiba ingthabagi yaipha-thoujal adu nakhoida amuk halaksanu. ");
INSERT INTO mni_vpl VALUES ("LK10_7","072_10_7","LUK","10","7","7","Aduga nakhoibu lousilliba imung aduda makhoina pirakpasing adu cha-thaktuna leiyu maramdi thabak suba mina magi asuman phangba matik chai. Amasung nakhoina yum amadagi amada khoihong hongganu. ");
INSERT INTO mni_vpl VALUES ("LK10_8","072_10_8","LUK","10","8","8","Nakhoina sahar amada changba matamda nakhoibu taram taramna lousillabadi nakhoida pija pijaba adu chao. ");
INSERT INTO mni_vpl VALUES ("LK10_9","072_10_9","LUK","10","9","9","Aduga mapham aduda leiba anabasingbu phahallammu amasung makhoida haiyu, ‘Tengban Mapugi ningthou leibak adu nakhoida naksillakle.’ ");
INSERT INTO mni_vpl VALUES ("LK10_10","072_10_10","LUK","10","10","10","Adubu nakhoina saharda changba matamda misingna nakhoibu taramna lousindrabadi maphamdugi lambisingda chattuna haiyu, ");
INSERT INTO mni_vpl VALUES ("LK10_11","072_10_11","LUK","10","11","11","‘Eikhoigi khongyada pakliba nakhoigi sahar asigi uphul asiphaoba eikhoina nakhoigi maiyokta kanthoklabani. Adumakpu Tengban Mapugi leibak adu naksillakle haiba asi ningsing-u!’ ");
INSERT INTO mni_vpl VALUES ("LK10_12","072_10_12","LUK","10","12","12","Eina nakhoida hairiba asini, madudi Wayenba Numit aduda sahar adudagidi Sodom-na henna saphagani! ");
INSERT INTO mni_vpl VALUES ("LK10_13","072_10_13","LUK","10","13","13","“He Chorazin, nangdi awabanida! He Bethsaida, nangdi awabanida! Maramdi nakhoida toukhiba angakpa thabaksing adu Tyre amadi Sidon-da touramlabadi makhoina bora phi settuna amadi utta phamduna mamang mamangda paptagi pukning honglamgadabani. ");
INSERT INTO mni_vpl VALUES ("LK10_14","072_10_14","LUK","10","14","14","Aduga wayenba numitta nakhoidagidi Tyre amadi Sidonna henna saphagani. ");
INSERT INTO mni_vpl VALUES ("LK10_15","072_10_15","LUK","10","15","15","Aduga he Capernaum! Nangbu swargada thanggatpigadra? Natte, nangdi khamnung leibakta hunthagani.” ");
INSERT INTO mni_vpl VALUES ("LK10_16","072_10_16","LUK","10","16","16","Adudagi Jisuna mahakki tung-inbasingduda hairak-i, “Nakhoigi wa taba mahak aduna eigi wa tarabani; aduga nakhoibu yadaba mahak aduna eibu yadabani; amasung eibu yadaba mahak aduna eibu tharakpa Ibungo mahakpu yadabani.” ");
INSERT INTO mni_vpl VALUES ("LK10_17","072_10_17","LUK","10","17","17","Adudagi tung-inba humphutaraithoi aduna haraona halaktuna Jisuda hairak-i, “Ibungo, eikhoina Ibungogi mingda yathang pibada lai phattabasingna phaoba eikhoigi yathang illi!” ");
INSERT INTO mni_vpl VALUES ("LK10_18","072_10_18","LUK","10","18","18","Jisuna makhoida hairak-i, “Swargadagi nongthang kuppagumna Satan-na tarakpa eina urammi. ");
INSERT INTO mni_vpl VALUES ("LK10_19","072_10_19","LUK","10","19","19","Yengngu, nakhoina lil amadi brichiksinggi mathakta netnanaba aduga Yeknaba adugi panggal pumnamakpu ngamnanaba eina nakhoida matik pire, aduga karigumba amatanasu nakhoibu sok-halloi. ");
INSERT INTO mni_vpl VALUES ("LK10_20","072_10_20","LUK","10","20","20","Adumakpu, lai phattabasingna nakhoina haiba illi haibagidamak haraoganu; adubu swargada nakhoigi ming ikhre haibagidamak haraojou.” ");
INSERT INTO mni_vpl VALUES ("LK10_21","072_10_21","LUK","10","21","21","Matam adumaktada Jisu Thawai Asengbagi mapanna haraobana thalladuna hairak-i, “He Ipa, swarga malem pumnamakki Mapu Ibungo! Eina nahakpu thagatchari maramdi nahakna hiramsing asibu asingbasing amadi akhang-aheisingdagi lottuna thambiraga apikpa angangsing asida phongdokpire. Hoi, Ipa, masimak nahakki naphamdadi apenbani. ");
INSERT INTO mni_vpl VALUES ("LK10_22","072_10_22","LUK","10","22","22","“Eigi Ipana hiram pumnamak eingongda sinabire. Aduga Mapa adu nattana kananasu machanupa adubu khangde amasung machanupa adu nattana aduga mapa adubu phongdoknaba machanupa aduna khandokkhraba makhoi adu nattana kananasu mapa adubu khangde.” ");
INSERT INTO mni_vpl VALUES ("LK10_23","072_10_23","LUK","10","23","23","Adudagi Jisuna tung-inbasing aduda onsillaktuna tonganna makhoikhaktada hairak-i, “Nakhoina houjik uriba asibu uba phangjariba nakhoi kayada yaiphakhraba! ");
INSERT INTO mni_vpl VALUES ("LK10_24","072_10_24","LUK","10","24","24","Eina nakhoida hairi, Tengban Mapugi wa phongdokpiba maichou amadi ningthou kayana nakhoina uriba asibu ujaninglammi adubu makhoina uba phangkhide. Aduga nakhoina taba adubu makhoina tajaninglammi adubu makhoina takhide.” ");
INSERT INTO mni_vpl VALUES ("LK10_25","072_10_25","LUK","10","25","25","Nongma wayel yathanggi oja amana hougatlaga Jisubu chang yengladuna wahang ama hanglak-i, “Oja Ibungo, lomba naidaba punsi phangnaba eina kari toujagadage?” ");
INSERT INTO mni_vpl VALUES ("LK10_26","072_10_26","LUK","10","26","26","Maduda Jisuna khumlak-i, “Wayel yathangna kari haibage? Madu nahakna kamdouna handokpage?” ");
INSERT INTO mni_vpl VALUES ("LK10_27","072_10_27","LUK","10","27","27","Nupa aduna khumlak-i, “‘Nahakna nahakki Tengban Mapu, MAPU IBUNGO-bu thamoi apumba, thawai apumba, panggal apumba, amadi pukning wakhal apumba yaona nungsigadabani;’ aduga ‘nahakki yumlon keironnababu nasamakkum nungsigadabani.’ ” ");
INSERT INTO mni_vpl VALUES ("LK10_28","072_10_28","LUK","10","28","28","Jisuna khumlak-i, “Nahakna chumna khumle; madumak tou, aduga nahakna hinggani.” ");
INSERT INTO mni_vpl VALUES ("LK10_29","072_10_29","LUK","10","29","29","Adubu wayel yathanggi oja aduna achumba sajaningduna Jisuda hairak-i, “Adudi eigi yumlon-keironnababu adu kanano?” ");
INSERT INTO mni_vpl VALUES ("LK10_30","072_10_30","LUK","10","30","30","Maduda Jisuna khumlak-i, “Nongma nupa amana Jerusalemdagi Jericho tanna chatlingeida huranbasinggi makhutta tarammi. Makhoina mahakki maphi marol munbire amasung mahakpu sigadaba makhei phubiraga hundoklamduna chatkhre. ");
INSERT INTO mni_vpl VALUES ("LK10_31","072_10_31","LUK","10","31","31","Tanja adumaktada kanagumba purohit ama lambi aduda laklammi. Amasung mahakna nupa adubu ubada lambigi nakanda theidoktuna chatkhre. ");
INSERT INTO mni_vpl VALUES ("LK10_32","072_10_32","LUK","10","32","32","Matou adugumduna levigi nupa amasu lambi aduda laklaga nupa adubu ubada lambigi atoppa nakanda theidoktuna chatkhre. ");
INSERT INTO mni_vpl VALUES ("LK10_33","072_10_33","LUK","10","33","33","Adubu kanagumba Samaria-gi mi amana lambi adomda asum langphei lakpada nupa adu thengnare amasung nupa adubu ubada mahakki thamoida nungsiba pokle. ");
INSERT INTO mni_vpl VALUES ("LK10_34","072_10_34","LUK","10","34","34","Adudagi mahakna nupa adugi manakta changsinduna asokpa mapham aduda thao amadi yu heibiduna phina kisinbire. Aduga mahakna nupa adubu mahak masamakki lola aduda tonghanduna mithungsang amada pusinbiraga mahakpu seba toubire. ");
INSERT INTO mni_vpl VALUES ("LK10_35","072_10_35","LUK","10","35","35","Mathanggi numitta mahakna denari ani louthoktuna mithungsang pannaba nupa aduda piraduna hairak-i, ‘Mahakpu ningthina yengsinbiyu, aduga masidagi henna mangonda chading touba pumnamak eina halakpa matamda singgani.’ ” ");
INSERT INTO mni_vpl VALUES ("LK10_36","072_10_36","LUK","10","36","36","“Houjik nahakki wakhalda makhoi ahum asigi manungda karambana huranbagi makhutta taraba nupa adugi yumlon-keirolnabani haina khanbage?” ");
INSERT INTO mni_vpl VALUES ("LK10_37","072_10_37","LUK","10","37","37","Maduda wayel yathanggi oja aduna khumlak-i, “Nupa aduda minungsi utpiriba mahak aduni.” Adudagi Jisuna nupa aduda hairak-i, “Chatlu, aduga madugumna nahaksu tou.” ");
INSERT INTO mni_vpl VALUES ("LK10_38","072_10_38","LUK","10","38","38","Jisu amasung mahakki tung-inbasingna asum lakpada makhoina khunggang amada thunglammi. Amasung maming Martha koubi nupi amana Ibungobu mayumda taramna kousinjare. ");
INSERT INTO mni_vpl VALUES ("LK10_39","072_10_39","LUK","10","39","39","Mahakki manaonupi Mary koubi ama leirammi amasung mahakna Ibungogi khuyada phamduna Ibungona tambiba adu tajarammi. ");
INSERT INTO mni_vpl VALUES ("LK10_40","072_10_40","LUK","10","40","40","Adubu Martha-na, tougadaba thabak adu yammankhibana warammi. Maram aduna mahakna laktuna Ibungoda hairak-i, “Ibungo, thabak pumnamaksing asibu ei ithantana tounanaba eigi inaonupina eibu thadokliba asibu Ibungona kari amata khanbidabra? Mahakna laktuna eibu mateng pangnanaba khara haibiyu.” ");
INSERT INTO mni_vpl VALUES ("LK10_41","072_10_41","LUK","10","41","41","Maduda Ibungona mangonda khumlak-i, “Martha, Martha! Nahakna thabak mayam amagi maramda langtaknari amasung wari. ");
INSERT INTO mni_vpl VALUES ("LK10_42","072_10_42","LUK","10","42","42","Adubu thabak amakhaktangdi yamna tangaiphadabani. Mary-na madugi aphaba saruk adu khankhre aduga madu mangondagi amuk louthoklaroi.” ");
INSERT INTO mni_vpl VALUES ("LK11_1","072_11_1","LUK","11","1","1","Nongma Jisuna mapham amada haijaduna leirammi. Amasung mahakna haijaba loibaga mahakki tung-inbasinggi maraktagi amana Ibungoda hairak-i, “Ibungo, John-na magi tung-inbasingda tambibagum eikhoida haijaba tambiyu.” ");
INSERT INTO mni_vpl VALUES ("LK11_2","072_11_2","LUK","11","2","2","Maduda Ibungona makhoida khumlak-i, “Nakhoina haijaba matamda asumna haiyu: ‘Swargada leiba Ipa, Nahakki minglen asengba oisanu; Nahakki leibak laksanu. ");
INSERT INTO mni_vpl VALUES ("LK11_3","072_11_3","LUK","11","3","3","Eikhoigi nongmagi chananaba chinjak numit khudinggi pinabiyu. ");
INSERT INTO mni_vpl VALUES ("LK11_4","072_11_4","LUK","11","4","4","Eikhoida aranba toubasingbu eikhoina kokpibagum, eikhoigi pap kokpiyu. Amasung eikhoibu athembada tahanbiganu adubu eikhoibu phattaba adudagi kanbiyu.’ ” ");
INSERT INTO mni_vpl VALUES ("LK11_5","072_11_5","LUK","11","5","5","Adudagi Jisuna mahakki tung-inbasing aduda hairak-i, “Nakhoigi naraktagi kanagumba amana mahakki marup amagi yumda ahing nongyaida chattuna asumna hai haina khallasi, ‘Marup, tal ahumdang pujage. ");
INSERT INTO mni_vpl VALUES ("LK11_6","072_11_6","LUK","11","6","6","Langphei lakpa marup ama eigi yumda thunglare, adubu mangonda pijanaba eigi kari amata leitre.’ ");
INSERT INTO mni_vpl VALUES ("LK11_7","072_11_7","LUK","11","7","7","Aduga mahakna imungdagi asumna khumlak-i haina khallasi, ‘Eibu wahanbiraganu. Thong asisu lonkhre aduga eigi ichasingsu eiga loinana phamungda leire. Aduna eina hougattuna nangonda kari amata piba ngamdre.’ ");
INSERT INTO mni_vpl VALUES ("LK11_8","072_11_8","LUK","11","8","8","Adubu eina nakhoida hairi madudi marup ama oibagidamak mahakna hougattuna mangonda tal adu pidraba phaobada, nupa aduna hanjin hanjin hangbada ikaidabagi maramna mahakna hougattuna mathou taba pumnamak mangonda pibigani.” ");
INSERT INTO mni_vpl VALUES ("LK11_9","072_11_9","LUK","11","9","9","“Maram aduna eina nakhoida hairibasini: Nijou, aduga madu nakhoida pinabigani; thijou nakhoina phangjagani; thong adu thinjou, nakhoida thong hangdokpigani. ");
INSERT INTO mni_vpl VALUES ("LK11_10","072_11_10","LUK","11","10","10","Maramdi nijaba mi khudingna phangjei, thijaba mahak aduna phangjei, aduga thong thinjaba mahak aduda hangdokpigani. ");
INSERT INTO mni_vpl VALUES ("LK11_11","072_11_11","LUK","11","11","11","Nakhoigi narakta mapa oiribasa! Karigumba nakhoigi nachasingna nakhoida tal niraga nakhoina makhoida nung oina pigadra? Nattraga nga niraga madugi mahutta lil oina pigadra? ");
INSERT INTO mni_vpl VALUES ("LK11_12","072_11_12","LUK","11","12","12","Nattraga makhoina yerum niraga yerumgi mahutta brichik oina pigadra? ");
INSERT INTO mni_vpl VALUES ("LK11_13","072_11_13","LUK","11","13","13","Nakhoina phattaba oidunasu nachasingda karamna aphaba khudol pigadage haiba khanglabadi swargada leiba nakhoigi napana mangonda nijaba makhoida kayamuk thoidok hendokna Thawai Asengbabu pibigadaba!” ");
INSERT INTO mni_vpl VALUES ("LK11_14","072_11_14","LUK","11","14","14","Nongma Jisuna nupa amadagi lonthoktaba lai phattaba ama tanthoklammi. Amasung lai phattaba adu thokakhrabada nupa adu wa nganglakle. Maduda miyam pumnamak ngaklakmi. ");
INSERT INTO mni_vpl VALUES ("LK11_15","072_11_15","LUK","11","15","15","Adubu makhoi kharana hairak-i, “Mahakna lai phattabasinggi makok Beelzebul-gi mapanna lai phattabasingbu tanthok-i.” ");
INSERT INTO mni_vpl VALUES ("LK11_16","072_11_16","LUK","11","16","16","Adudagi atoppa kharana Jisubu chang yengladuna mahakki matik adu Tengban Mapudagini haiba utnanaba angakpa khudam ama tounanaba hairammi. ");
INSERT INTO mni_vpl VALUES ("LK11_17","072_11_17","LUK","11","17","17","Adubu Jisuna makhoigi wakhal adu khangladuna makhoida hairak-i, “Leibak amagi manungda kanglup kanglup tokhai tanajarabadi leibak adu manggani, aduga imung amada tokhai tokhai tanarabadi imung adu leikha tagani. ");
INSERT INTO mni_vpl VALUES ("LK11_18","072_11_18","LUK","11","18","18","Satan-gi leibak manungda kanglup masel amaga amaga khatnaba leirabadi, leibak adu kayam kuina leigani? Eina lai phattabasing tanthokliba asi Beelzebul-gi mapanna toubani haina nakhoina haibagi maramna eina masi haibani. ");
INSERT INTO mni_vpl VALUES ("LK11_19","072_11_19","LUK","11","19","19","Houjik eina Beelzebul-gi mapanna lai phattabasing tanthoklabadi, nakhoigi tung-inbasingnadi kanagi mapanna lai phattabasingbu tanthokpage? Adunadi nakhoi nasamakki tung-inbasingna nakhoi lalle haibadu utchare. ");
INSERT INTO mni_vpl VALUES ("LK11_20","072_11_20","LUK","11","20","20","Adubu eina Tengban Mapugi panggalna lai phattabasingbu tanthoklabadi, Tengban Mapugi ningthou leibak adu nakhoida lakle. ");
INSERT INTO mni_vpl VALUES ("LK11_21","072_11_21","LUK","11","21","21","“Maramdi akanba nupa amana khulai matikchana paiduna masagi mayumbu ngaklabadi mahakki mapot-machei adu tekta kaidana lei. ");
INSERT INTO mni_vpl VALUES ("LK11_22","072_11_22","LUK","11","22","22","Adubu mangondagi henna kanba kanagumba amana mangonda landaduna mahakpu khudum challabadi, mahakna mapan tangjaramba khutlai pumnamak loukhigani aduga mahakki mapot macheising adusu yennakhigani. ");
INSERT INTO mni_vpl VALUES ("LK11_23","072_11_23","LUK","11","23","23","“Eigi oidaba mahak aduna eigi maiyokta lei; aduga khomjinbada eibu mateng pangdaba mahak aduna madubu chaithok-i. ");
INSERT INTO mni_vpl VALUES ("LK11_24","072_11_24","LUK","11","24","24","“Phattaba thawaina mi amada changlambadagi thokkhiba matamda mahakna pothapham thiduna akangba maphamsingda chatli. Adubu pothapham phangdrabada mahak masa mathanta haijei, ‘Eina eigi hannagi yum aduda amuk hallage.’ ");
INSERT INTO mni_vpl VALUES ("LK11_25","072_11_25","LUK","11","25","25","Asumna mahakna hallakpa matamda hannagi yum adu sit-sengduna ningthina thamlamba thengnare. ");
INSERT INTO mni_vpl VALUES ("LK11_26","072_11_26","LUK","11","26","26","Adudagi mahakna chatkhiduna mangondagi henna phattaba thawai taret puraktuna makhoina nupa aduda changduna mapham aduda leire. Adudagi nupa adu hannagi phibam adudagi henna phattaba phibam oirak-i.” ");
INSERT INTO mni_vpl VALUES ("LK11_27","072_11_27","LUK","11","27","27","Jisuna waheising asi hairingeida miyam adugi maraktagi nupi amana ahouba khonjelda hairak-i, “Nahakpu pokchabi amadi khomlang inbikhiba nama adu kayada yaiphabino?” ");
INSERT INTO mni_vpl VALUES ("LK11_28","072_11_28","LUK","11","28","28","Maduda Jisuna khumlak-i, “Madudagi henna Tengban Mapugi wahei taraga ngaakchaba makhoi aduna henna yaiphabani.” ");
INSERT INTO mni_vpl VALUES ("LK11_29","072_11_29","LUK","11","29","29","Tilliba miyam aduna yamlaklabada, Jisuna wa ngangba hourak-i, “Ngasigi miron asi phattaba mironni, makhoina khudam thidunata lei; adubu Jonahgi khudam adu nattana eina makhoida atoppa khudam amata piraroi. ");
INSERT INTO mni_vpl VALUES ("LK11_30","072_11_30","LUK","11","30","30","Maramdi Jonah-na Nineveh-gi misingda khudam oikhiba aduga chap mannana Migi Machanupa aduna ngasigi miron asida khudam oigani. ");
INSERT INTO mni_vpl VALUES ("LK11_31","072_11_31","LUK","11","31","31","Wayenba Numitta Sheba leibakki Leimarembina ngasigi miron asiga lepminnagani aduga miron asibu maral pigani, maramdi mahakna ningthou Solomon-gi lousing tanabagidamak lapkhraba maphamdagi lakhi. Aduga, eina nakhoida tasengnamak hairi madudi Solomon-dagi henna chaoba ama mapham asida leiri. ");
INSERT INTO mni_vpl VALUES ("LK11_32","072_11_32","LUK","11","32","32","Aduga Nineveh-gi misingnasu Wayenba Numitta leptuna miron asigi mising asibu maral pigani, maramdi makhoina Jonah-gi paosandokpada paptagi pukning honglammi aduga houjik maphamsida Jonah-dagi henna chaoba ama lei. ");
INSERT INTO mni_vpl VALUES ("LK11_33","072_11_33","LUK","11","33","33","“Mi kananasu thaomei thanlaga lotsinduna nattraga thumok makhada thamnade; adubu manungda changlakpa mi pumnamakna mangal adubu unanaba thaomei makhong mathakta thamnei. ");
INSERT INTO mni_vpl VALUES ("LK11_34","072_11_34","LUK","11","34","34","Hakchanggi thaomeidi mitni. Maram aduna nahakki mit pharabadi nahakki hakchang apumba mangalna thangani. Adubu mit aduna phattrabadi nahakki hakchang apumba amambana thangani. ");
INSERT INTO mni_vpl VALUES ("LK11_35","072_11_35","LUK","11","35","35","Aduna nangonda leiriba mangal adu mamdanaba cheksillu. ");
INSERT INTO mni_vpl VALUES ("LK11_36","072_11_36","LUK","11","36","36","Karigumba nahakki hakchang apumba mangalna thallabadi, aduga amamba saruk amata leitrabadi, thaomeigi anganba mangalna nangonda nganbagum, madu pumngan-ngangani.” ");
INSERT INTO mni_vpl VALUES ("LK11_37","072_11_37","LUK","11","37","37","Jisuna wa ngangba loibaga pharisee amana Ibungobu mahakka loinanana chaminanaba haijarammi. Maram aduna Ibungona lengsinduna chananaba phamthare. ");
INSERT INTO mni_vpl VALUES ("LK11_38","072_11_38","LUK","11","38","38","Adubu Ibungona chakcha mangda khut hamdaba adu ubada pharisee adu ngaklammi. ");
INSERT INTO mni_vpl VALUES ("LK11_39","072_11_39","LUK","11","39","39","Maduda Ibungona mangonda hairak-i, “Nakhoi pharisee-singnadi pukham tenggotki mapanthanba saruk adu ningthina sengdok-i, adubu manungdadi namja namtheknabana amadi phattabana thalli. ");
INSERT INTO mni_vpl VALUES ("LK11_40","072_11_40","LUK","11","40","40","He, Apangbasa! Mapanthangbabu sembiba Tengban Mapu mahakna manungbusu sembiba nattra? ");
INSERT INTO mni_vpl VALUES ("LK11_41","072_11_41","LUK","11","41","41","Adubu pukham amadi tenggot adugi manungda yaoribasing adubu lairabasingda pinou, aduga pumnamak nahakkidamak senggani. ");
INSERT INTO mni_vpl VALUES ("LK11_42","072_11_42","LUK","11","42","42","“Pharisee nakhoidi awabanida! Maramdi nakhoina nungsihidak, arud, amadi ingkholda houba atoppa mana masing khibikki saruk taragi ama katli adubu achumba wayel amadi Tengban Mapubu nungsiba adubudi thaoide. Adubu nakhoina ahanba adubusu thaoidaba toudana akonba asibusu touramgadabani. ");
INSERT INTO mni_vpl VALUES ("LK11_43","072_11_43","LUK","11","43","43","“Pharisee-sa nakhoidi awabanida! Maramdi nakhoina synagogue-singda ikai khumnaba misinggi phamphamda phamba aduga misingna nakhoibu keithelsingda ikai khumnabaga loinana koujaba adu nakhoina pammi. ");
INSERT INTO mni_vpl VALUES ("LK11_44","072_11_44","LUK","11","44","44","Pharisee-sa nakhoidi awabanida! Nakhoidi misingna khangdaduna mathakta nettuna chatliba uba phangdaba mongphamgumbani.” ");
INSERT INTO mni_vpl VALUES ("LK11_45","072_11_45","LUK","11","45","45","Adudagi wayen yathanggi oja amana Ibungoda hairak-i, “Oja Ibungo, Nahakna wasing asi haiduna eikhoibusu ikaiba pibire.” ");
INSERT INTO mni_vpl VALUES ("LK11_46","072_11_46","LUK","11","46","46","Maduda Jisuna khumlaki, “Wayen Yathanggi oja nakhoisu awabanida! Maramdi pubada wagadaba potlum kaya ama nakhoina misinggi mathakta thonggatli adubu nakhoinadi makhoibu mateng pangnabagidamak khutsa ama phaoba thanggatte. ");
INSERT INTO mni_vpl VALUES ("LK11_47","072_11_47","LUK","11","47","47","Nakhoidi awabanida! Maramdi nakhoinadi Tengban Mapugi wa phongdokpiba maichousinggi phajaraba mongpham sai adubu makhoibu hatkhibadi nakhoigi napa napusingnani. ");
INSERT INTO mni_vpl VALUES ("LK11_48","072_11_48","LUK","11","48","48","Aduga nakhoigi napa napusingna toukhiba thabak adu nokhoina sougatli haibagi sakhi nakhoi nasamakna oiri. Maramdi makhoina Tengban Mapugi wa phongdokpa maichousingbu hatle aduga nakhoina makhoigi mongpham sare. ");
INSERT INTO mni_vpl VALUES ("LK11_49","072_11_49","LUK","11","49","49","Maram asimakna Tengban Mapugi lousingna hai, ‘Eina makhoida eigi wa phongdokpiba maichousing aduga pakhonchatpasingbu thagani, adubu makhoina makhoi kharabu hatkani aduga ateisingbuna otpi-neibigani.’ ");
INSERT INTO mni_vpl VALUES ("LK11_50","072_11_50","LUK","11","50","50","Maram aduna taibangpan houngeidagi tarakliba Tengban Mapugi wa phongdokpiba maichou pumnamakki ee-gi cheirak adu ngasigi mirol asigi mathakta tahangani. ");
INSERT INTO mni_vpl VALUES ("LK11_51","072_11_51","LUK","11","51","51","Haibadi Abel-gi ee-dagi houduna iratpung amadi Asengba Maphamgi marakta hatkhiba Zechariah-gi ee phaobagi cheirak pigani. Eina nakhoida hairibasini, masi pumnamakki cheirak adu miron asigi mathakta tagani. ");
INSERT INTO mni_vpl VALUES ("LK11_52","072_11_52","LUK","11","52","52","“Wayel Yathanggi ojasing, nakhoidi awabanida! Maramdi nakhoina lousinggi so adu loukhre. Adubu nakhoina nasasu maduda changde aduga maduda changlakpasing adubusu nakhoina thingngi.” ");
INSERT INTO mni_vpl VALUES ("LK11_53","072_11_53","LUK","11","53","53","Jisuna mapham adu thadokkhrabada Wayel Yathanggi ojasing amadi Pharisee-sing aduna Ibungobu thamthiba matouga loinana magi mayokta leppa hourammi amasung hiram kayagi wahang hangbasu hourammi. ");
INSERT INTO mni_vpl VALUES ("LK11_54","072_11_54","LUK","11","54","54","Maramdi Ibungogi chindagi thorakpa asoiba wahei thiduna mahakpu phananaba hotnarammi. ");
INSERT INTO mni_vpl VALUES ("LK12_1","072_12_1","LUK","12","1","1","Talak adumaktada, mioi lising lisingna, amaga amaga netsinnaba makhei tillarabada, Jisuna mahakki tung-inbasing aduda hanna haiba hourak-i, “Pharisee-singgi hamei haibadi makhoigi aphasasinnaba adudagi cheksillu. ");
INSERT INTO mni_vpl VALUES ("LK12_2","072_12_2","LUK","12","2","2","Maramdi phongdokloidaba kupsinba karisu leite, aduga khangloidaba arotpa karisu leite. ");
INSERT INTO mni_vpl VALUES ("LK12_3","072_12_3","LUK","12","3","3","Adunadi nakhoina amambada ngangkhiba khuding anganbada tagani aduga nakhoina thong thingjinba kanungda nakongda lonna ngangnakhiba khudingmak yumthaktagi laothokkani.” ");
INSERT INTO mni_vpl VALUES ("LK12_4","072_12_4","LUK","12","4","4","“Marupsa, eina nakhoida hairibasini, hakchangbu hatlaga matungda madudagi henna karisu touba ngamdaba makhoi adubu kiganu. ");
INSERT INTO mni_vpl VALUES ("LK12_5","072_12_5","LUK","12","5","5","Adubu nakhoina kanabu kigadabano haibadu eina nakhoida haige. Madudi hatlaba matungda norokta langsingnaba matik leiba Tengban Mapu mahakpu kiyu. Eina nakhoida hairibasini, nakhoina kigadaba adu mahak asini. ");
INSERT INTO mni_vpl VALUES ("LK12_6","072_12_6","LUK","12","6","6","“Nakhoina sendrang mangabu peisa anida yonba nattra? Adumak oidunasu Tengban Mapuna makhoi amabusu kaothokpa toude. ");
INSERT INTO mni_vpl VALUES ("LK12_7","072_12_7","LUK","12","7","7","Aduga madudagi hendokna nakhoigi kokta houriba sam adu phaoba masing thiribani. Maram aduna kiganu, nakhoidi sendrang mayam amadagisu mamal yamba helli. ");
INSERT INTO mni_vpl VALUES ("LK12_8","072_12_8","LUK","12","8","8","“Eina nakhoida masimasu hairi, madudi misinggi mangda eigi tung-inbasingni haina phongdokpa makhoi adubu Migi Machanupa adunasu Tengban Mapugi swarga dutsinggi mamangda maduga chap manana makhoida toubigani. ");
INSERT INTO mni_vpl VALUES ("LK12_9","072_12_9","LUK","12","9","9","Adubu misinggi mangda eigini haiba yajadaba makhoi adubudi Tengban Mapugi swargadutsingi mangda yabiroi. ");
INSERT INTO mni_vpl VALUES ("LK12_10","072_12_10","LUK","12","10","10","“Amasung Migi Machanupa adugi maiyokta wa ngangba mahak adubudi kokpigani, adubu Thawai Asengbagi mathakta thina ngangba mahak adubudi kokpiroi. ");
INSERT INTO mni_vpl VALUES ("LK12_11","072_12_11","LUK","12","11","11","“Aduga nakhoibu wayennaba synagogue-singda, aduga leingak mapusinggi nattraga leingakpasinggi mangda puthokpa matamda nakhoina nasa ngakthokchanaba kari khumgadage amadi kari haigadage haibagidamak karisu waganu. ");
INSERT INTO mni_vpl VALUES ("LK12_12","072_12_12","LUK","12","12","12","Maramdi matam aduda nakhoina kari haigadabano haibadu Thawai Asengbana takpigani.” ");
INSERT INTO mni_vpl VALUES ("LK12_13","072_12_13","LUK","12","13","13","Adudagi miyam adugi maraktagi nupa amana Jisuda hanglak-i, “Oja Ibungo, Ipana eikhoigidamak thambiramba lanthum adu eiga yenthoknanaba iyambada khara haibiyu.” ");
INSERT INTO mni_vpl VALUES ("LK12_14","072_12_14","LUK","12","14","14","Maduda Jisuna mangonda khumlak-i, “He Nupa, kanana eingonda nakhoibu wayelnaba nattraga nakhoi anigi lanthum adubu yenthokpinaba matik pibage?” ");
INSERT INTO mni_vpl VALUES ("LK12_15","072_12_15","LUK","12","15","15","Adudagi Jisuna miyam aduda hairak-i, “Cheksillu aduga makhal khudingmakki kalak mihoubadagi nasabu ngak-senjou; maramdi nahakki punsi adu nahakki lanthum kaya yamna leibage haibaduna chang ongadaba natte.” ");
INSERT INTO mni_vpl VALUES ("LK12_16","072_12_16","LUK","12","16","16","Adudagi Jisuna makhoida pandam asi hairak-i, “Kanagumba inakhunba nupa amagi mahei marong marang kaina thokpa loupham ama leirammi. ");
INSERT INTO mni_vpl VALUES ("LK12_17","072_12_17","LUK","12","17","17","Mahakna masa mathanta asumna khanjarammi, ‘Eigi mahei marong pumnamak asi peisinnaba mapham leitre. Aduna ei houjik kari tougani?’ ");
INSERT INTO mni_vpl VALUES ("LK12_18","072_12_18","LUK","12","18","18","Amasung mahak masa mathanta haijarammi, ‘Eina asumna tourage, eina eigi kei asi sidoklaga eigi mahei marongsing amadi atei potsing pumnamak thamnanaba henna chaoba kei ama sarage. ");
INSERT INTO mni_vpl VALUES ("LK12_19","072_12_19","LUK","12","19","19","Adudagi eina isa ithanta haijagani, Laibakphaba nupa! Nahakna chahi kaya chatlagadaba aphaba pot pumnamak peisille; pothajaro, charo, thaklo amadi nungaijaro.’ ");
INSERT INTO mni_vpl VALUES ("LK12_20","072_12_20","LUK","12","20","20","Adubu Tengban Mapuna mangonda hairak-i, ‘He Apangba! Ngasi ahing asimaktada nahakki thawai louragani. Adu oirabadi nahakna nahak nasagidamak langkhatchariba pumnamaksing asi kanagi oihougadage?’ ” ");
INSERT INTO mni_vpl VALUES ("LK12_21","072_12_21","LUK","12","21","21","“Makhoi masagidamak lanthum peikhatchariba adubu Tengban Mapugi mityengdadi inak khundaba makhoising aduda thokkadaba adumak masini.” ");
INSERT INTO mni_vpl VALUES ("LK12_22","072_12_22","LUK","12","22","22","Adudagi Jisuna mahakki tung-inbasing aduda hairak-i, “Maram aduna eina nakhoida hairi, nakhoina hingnanabagidamak kari chagani aduga hakchanggidamak nakhoina kari setkani haina karisu langtaknaganu. ");
INSERT INTO mni_vpl VALUES ("LK12_23","072_12_23","LUK","12","23","23","Maramdi hingbana chinjaktagi aduga hakchangna phijoldagi yamna henna maru oi. ");
INSERT INTO mni_vpl VALUES ("LK12_24","072_12_24","LUK","12","24","24","Kwaksinggi maramda nakhoi wakhal tou; makhoina marusu hunde, loksu lokte aduga makhoigi machinjak peisinpham kei-su leite; adum oinamakpu Tengban Mapuna makhoibu machinjak pibi! Aduga nakhoidi ucheksing asidagi kayada henna mamal yamliba? ");
INSERT INTO mni_vpl VALUES ("LK12_25","072_12_25","LUK","12","25","25","Nakhoi kanana pukning lantaknabana masagi punsi adu mikup ama sangdokhanba ngambra? ");
INSERT INTO mni_vpl VALUES ("LK12_26","072_12_26","LUK","12","26","26","Aduga nakhoina asigumba apikpa thabak asi phaoba touba ngamdraga ateisinggi maramda nakhoina karigi langtaknabano? ");
INSERT INTO mni_vpl VALUES ("LK12_27","072_12_27","LUK","12","27","27","Lamlakki leirangsingna karamna houriba, nakhoi wakhal tou. Makhoina thabaksu sude aduga makhoi masagidamak phisu sade. Adubu eina nakhoida hairi, Solomonmaknasu mahakki matik mangal pumnamakka loinana phijet leitenglabasu leising asigi maraktagi amana phajaba adugumna phijet leitengkhide. ");
INSERT INTO mni_vpl VALUES ("LK12_28","072_12_28","LUK","12","28","28","Aduga ngasidi houriba, hayengdi leirangda hunjingadouriba loubukki napi phaoba Tengban Mapuna asumna phijet leitengbirabadi, he thajaba watpasa, mahakna nakhoibu kayada henna phijet leitengbiroidra? ");
INSERT INTO mni_vpl VALUES ("LK12_29","072_12_29","LUK","12","29","29","“Maram aduna nakhoina kari chagani, kari thakkani haiba adu thiganu, aduga wasu waruganu. ");
INSERT INTO mni_vpl VALUES ("LK12_30","072_12_30","LUK","12","30","30","Maramdi taibangpanda leiriba Tengban Mapu thajadaba mi pumnamakna pot pumnamak asi thi, adubu nakhoigi Napana pumnamaksing asi nakhoida mathou tai haiba khangbi. ");
INSERT INTO mni_vpl VALUES ("LK12_31","072_12_31","LUK","12","31","31","Madugi mahutta nakhoina Tengban Mapugi Leibak adu thiyu aduga pot pumnamaksing asi mahakna nakhoida pinabigani. ");
INSERT INTO mni_vpl VALUES ("LK12_32","072_12_32","LUK","12","32","32","“Yao sanggu macha, nakhoi kiganu. Maramdi nakhoida ningthou leibak adu pibiba haibasi nakhoigi Napagi apenbani. ");
INSERT INTO mni_vpl VALUES ("LK12_33","072_12_33","LUK","12","33","33","Nakhoigi leijaba pumba yonthoktuna lairabasingda pinou. Aduga nakhoi nasagidamak manthaba naidraba sengao adu thourang toujou, amasung lan-thum hanthaba leiraroidaba, huranbanasu huba ngamlaroidaba, amadi til-kangnasu madubu manghanba ngamlaroidaba mapham swargada nakhoigi lan peisinjou. ");
INSERT INTO mni_vpl VALUES ("LK12_34","072_12_34","LUK","12","34","34","Maramdi nakhoigi lan leiba maphamda nakhoigi thamoisu lei.” ");
INSERT INTO mni_vpl VALUES ("LK12_35","072_12_35","LUK","12","35","35","“Thougal tounabagidamak naphi semduna amadi thaomei thanggatuna leiyu. ");
INSERT INTO mni_vpl VALUES ("LK12_36","072_12_36","LUK","12","36","36","Luhongbagi chaklendagi mapu aduna halakpa ngairiba misinggum nakhoi oiyu. Madu mahakna halaktuna thong thillaba matamda makhoina khudakta thong adubu hangbagumna oinanabani. ");
INSERT INTO mni_vpl VALUES ("LK12_37","072_12_37","LUK","12","37","37","Mapu aduna halakpa matamda mitseng khangduna leiramba manaising adu yaiphabani. Eina nakhoida tasengnamak hairibasini, madudi mahakna thougal tounaba maphi semgani amasung makhoibu chananaba phamthahangani aduga mahakna makhoibu thougal tougani. ");
INSERT INTO mni_vpl VALUES ("LK12_38","072_12_38","LUK","12","38","38","Mahakna ahing nongyaida lakpasu yai natraga madugi matungda lakpasu yai. Adubu mahakna halakpa matamda mitseng khangduna leiramba makhoi adu yaiphabani. ");
INSERT INTO mni_vpl VALUES ("LK12_39","072_12_39","LUK","12","39","39","Aduga masisu khangngu, karigumba yumbu aduna huranbana lakkadaba pungpham adu khanglamlabadi mahakna mitseng khangduna yum adu sagun touhallamoidabani. ");
INSERT INTO mni_vpl VALUES ("LK12_40","072_12_40","LUK","12","40","40","Maram aduna nakhoisu thourang touduna leiyu maramdi nakhoina ningludaba pungphamda Migi Machanupa adu lenglakkani.” ");
INSERT INTO mni_vpl VALUES ("LK12_41","072_12_41","LUK","12","41","41","Adudagi Peter-na hanglak-i, “Ibungo, nahakna pandam asi eikhoikhaktada haibiribra natraga mi pumnamaktara?” ");
INSERT INTO mni_vpl VALUES ("LK12_42","072_12_42","LUK","12","42","42","Maduda Ibungona khumlak-i, “Adu oiragadi, mapu aduna imung manung adugi thabak asin arang tounaba amasung atoppa minaising aduda matam chana makhoigi chananaba sharuk pinanabagidamak pannahalliba thajaba yaba amadi asingba minai adu kanano? ");
INSERT INTO mni_vpl VALUES ("LK12_43","072_12_43","LUK","12","43","43","Mapu aduna halakpa matamda asumna touramba thengnaba minai adu kayada yaiphabano? ");
INSERT INTO mni_vpl VALUES ("LK12_44","072_12_44","LUK","12","44","44","Eina nakhoida achumba adu hairibasini, mahakpu mapu aduna mahakki leijaba lanthum pumnamakki mathakta pannaba mi oihanbigani. ");
INSERT INTO mni_vpl VALUES ("LK12_45","072_12_45","LUK","12","45","45","Adubu minai aduna mapukningda mapu adu matam kuina halakkhiroi khanduna mahakna atoppa minai nupasing amadi nupising animakpu phuba, thak-chaba amadi yu ngaoba hourabadi, ");
INSERT INTO mni_vpl VALUES ("LK12_46","072_12_46","LUK","12","46","46","minai aduna halakkani ningludaba amadi mahakna khangdaba numit amada mapu aduna hallakani. Aduga mahakpu matup thokna kakthatkani amasung haiba indabasing mapham adu mahakkisu saruk phanghangani. ");
INSERT INTO mni_vpl VALUES ("LK12_47","072_12_47","LUK","12","47","47","“Amasung mapugi aningba adu khangba minai amana thourang toudrabadi aduga mapugi aningba adu pangthoktrabadi mahakpu cheiphu kayarak phuduna cheirak pigani. ");
INSERT INTO mni_vpl VALUES ("LK12_48","072_12_48","LUK","12","48","48","Adubu mapugi aningba adudi khangdaba aduga cheirak phangba yaba aranba kharadi touba mahak adubu cheiphu kharatamak phuduna cheirak pigani. Maramdi yamna pibikhiba mahak adudagi yamna tangani aduga yamna henna sinnakhiba mahak adudagi yamna henna tangani. ");
INSERT INTO mni_vpl VALUES ("LK12_49","072_12_49","LUK","12","49","49","“Eina malem asi mei chakhannaba lakpani; aduga mei adu hannana chakhallamba eina kayada pamjaba! ");
INSERT INTO mni_vpl VALUES ("LK12_50","072_12_50","LUK","12","50","50","Adubu eina lougadaba baptize ama lei, aduga madu thungdriba paoba eina kayada wariba? ");
INSERT INTO mni_vpl VALUES ("LK12_51","072_12_51","LUK","12","51","51","Eina taibangpan asida ingthaba piba lakpani haina khanbra? Eina nakhoida hairibasini, natte, adubu khaidok-hannabani. ");
INSERT INTO mni_vpl VALUES ("LK12_52","072_12_52","LUK","12","52","52","Ngasidagi houna mi manga leiba imung adu tokhai tokhai tanagani; madudi ahumna anigi maiyokta aduga anina ahumgi maiyokta leigani. ");
INSERT INTO mni_vpl VALUES ("LK12_53","072_12_53","LUK","12","53","53","Mapana machagi maiyokta leigani aduga machana mapagi maiyokta leigani; mamana machanupigi maiyokta aduga machanupigi maiyokta mamana leigani; manemna mamougi maiyokta aduga mamouna manemgi maiyokta leigani.” ");
INSERT INTO mni_vpl VALUES ("LK12_54","072_12_54","LUK","12","54","54","Jisuna miyam aduda masimasu hairak-i, “Nakhoina nongchuplomdagi amuba leichil pairakpa ubada nong chugadoure haina nakhoina khudakta haigani aduga madu thok-i. ");
INSERT INTO mni_vpl VALUES ("LK12_55","072_12_55","LUK","12","55","55","Aduga khagi nungsit sitlakpa matamda ngasidi omchaknaba numit oigani haina nakhoina hai aduga madu thok-i. ");
INSERT INTO mni_vpl VALUES ("LK12_56","072_12_56","LUK","12","56","56","Aphasasinnabasa! Nakhoina atiya malemgi phibam yenglaga nongju nungsagi maramda khang-i; adu oiragadi houjikki matam asigi maramda karamna handokkani haiba khangdriba karigino? ");
INSERT INTO mni_vpl VALUES ("LK12_57","072_12_57","LUK","12","57","57","“Achumba adu tounanaba nakhoi nasana karigi wayenjadribano? ");
INSERT INTO mni_vpl VALUES ("LK12_58","072_12_58","LUK","12","58","58","Nahakna nahakki maiyokta naral siriba mahakka wayelsangda chatpa matamda, nahakna wayelsang youdringeida yetnaba adu yariba makei yasinnanaba nahakna ngamjaba adu hotnou. Adu nattragadi mahakna nahakpu wayel mapugi mangda chingthokpa yai aduga mahakna nangbu phamnaibada sinnagani aduga nahakpu keisumsangda thajingani. ");
INSERT INTO mni_vpl VALUES ("LK12_59","072_12_59","LUK","12","59","59","Eina nangonda hairibasini, nahakna singdokkadaba aroiba senpham adu hek singdoktriba makheidi nahakna mapham adudagi thorakpa yaroi.” ");
INSERT INTO mni_vpl VALUES ("LK13_1","072_13_1","LUK","13","1","1","Matam aduda, Galilee-gi misingna Tengban Mapuda iratpot katlingeida Pilate-na makhoibu hatkhibagi maramda Jisuda pao tamlamba mioi khara mapham aduda leirammi. ");
INSERT INTO mni_vpl VALUES ("LK13_2","072_13_2","LUK","13","2","2","Maduda Jisuna makhoida khumlak-i, “Makhoina asumna sikhiba asigi maramna Galilee-da leiba mi ateisingdagi makhoina henna phattaba papisingni haina nakhoina khanbra? ");
INSERT INTO mni_vpl VALUES ("LK13_3","072_13_3","LUK","13","3","3","Eina nakhoida hairibasini, madu natte! Adubu nakhoina paptagi pukning hongdrabadi makhoida toukhibagumna nakhoi pumnamaksu manggani. ");
INSERT INTO mni_vpl VALUES ("LK13_4","072_13_4","LUK","13","4","4","Aduga Siloam-da leiba awangba yum ningkhaibada nanduna sikhiba makhoi taranipan aduna Jerusalem-da leiriba mising ateidagi henna papchenba misingni haina nakhoina khanbra? ");
INSERT INTO mni_vpl VALUES ("LK13_5","072_13_5","LUK","13","5","5","Eina nakhoida hairi, madu natte! Adubu nakhoina pukning hongdrabadi matou adugumna nakhoi pumnamaksu manggani.” ");
INSERT INTO mni_vpl VALUES ("LK13_6","072_13_6","LUK","13","6","6","Adudagi Jisuna makhoida pandam asi hairak-i, “Kanagumba nupa amagi anggur ingkholda thajaba heiyit pambi ama hourammi. Amasung mahakna laktuna pambi aduda mahei panbra haiduna yenglammi adubu mahakna mahei amata panba thengnaramde. ");
INSERT INTO mni_vpl VALUES ("LK13_7","072_13_7","LUK","13","7","7","Maram aduna mahakna mahakki ingkhol koiba nupa aduda hairak-i, ‘Yengngu, chahi ahum eina heiyit pambi asida mahei panbra haina yengba lakli adubu mahei amata phaoba panba thengnadre. Aduna pambisi yanthatkhro, masina lam manghanduna karibu tougadouribano?’ ");
INSERT INTO mni_vpl VALUES ("LK13_8","072_13_8","LUK","13","8","8","Adubu ingkhol koiba nupa aduna khumlak-i, ‘Ibungo, chahi amatangga masi leijakhisanu; eina akoibada touthoktuna leihao hapchage. ");
INSERT INTO mni_vpl VALUES ("LK13_9","072_13_9","LUK","13","9","9","Maduda mahei pallabadi phare adubu pandrabadi nahakna masi yanthatpiyu.’ ” ");
INSERT INTO mni_vpl VALUES ("LK13_10","072_13_10","LUK","13","10","10","Nongma Potthaba numit amada Jisuna synagogue amada tambirammi. ");
INSERT INTO mni_vpl VALUES ("LK13_11","072_13_11","LUK","13","11","11","Mapham aduda phattaba thawai amana soinaihallabi nupi ama leirammi. Mahakna chahi taranipan manam ponduna tingkhatchaba ngamdana leirammi. ");
INSERT INTO mni_vpl VALUES ("LK13_12","072_13_12","LUK","13","12","12","Jisuna mahakpu ubada kouthokladuna hairak-i, “Nahakki anaba adudagi nahakpu thadokpirabani.” ");
INSERT INTO mni_vpl VALUES ("LK13_13","072_13_13","LUK","13","13","13","Adudagi mahakna nupi aduda khut thambiba khudak aduda nupi adu tingkhatchaba ngamjarammi amasung Tengban Mapubu thagatchakhi. ");
INSERT INTO mni_vpl VALUES ("LK13_14","072_13_14","LUK","13","14","14","Adubu Jisuna Potthaba numitta anaba phahanba aduda synagogue-ki phamnaibasing aduna saoraduna miyam aduda hairak-i, “Hapta amada misingna thabak sunaba numit tarukni lei. Maram aduna numitsing aduda nakhoigi anaba phahanbinaba lak-u, adubu potthaba numitadi lakkanu.” ");
INSERT INTO mni_vpl VALUES ("LK13_15","072_13_15","LUK","13","15","15","Maduda Ibungona mangonda khumlak-i, “He, Aphasasinnabasa! Nakhoi khudingmakna Potthaba numitta nakhoi nakhoigi sal laba nattraga lolabu sanggoldagi thadoktuna ising pithaknaba puthoktabra? ");
INSERT INTO mni_vpl VALUES ("LK13_16","072_13_16","LUK","13","16","16","Adu oirabadi Abrahamgi charon suron oiribi Satan-na chahi taranipan punduna leirurabi mahakpudi Potthaba Numitta pulliba adudagi thadokpipham thoktra?” ");
INSERT INTO mni_vpl VALUES ("LK13_17","072_13_17","LUK","13","17","17","Ibungogi paokhum asina mahakki yeknaba pumnamak ikaiba nanghallammi aduga Ibungona toukhiba angakpa thabaksing adugidamak miyam pumnamak haraojarammi. ");
INSERT INTO mni_vpl VALUES ("LK13_18","072_13_18","LUK","13","18","18","Adudagi Jisuna hairak-i, “Tengban Mapugi Leibak adu kariga manabage? Madu eina kariga changdamnagadage? ");
INSERT INTO mni_vpl VALUES ("LK13_19","072_13_19","LUK","13","19","19","Madu mi amana louraga mahakki ingkholda hunkhiba hangam marugumbani. Madu houraktuna achouba pambi oirak-i aduga atiyagi ucheksingna madugi masada mahum sai.” ");
INSERT INTO mni_vpl VALUES ("LK13_20","072_13_20","LUK","13","20","20","Jisuna amukka hanna hairak-i, “Tengban Mapugi Leibak adu kariga manabage? Madu eina kariga changdamnagadage? ");
INSERT INTO mni_vpl VALUES ("LK13_21","072_13_21","LUK","13","21","21","Madu nupi amana louduna yam thumok amada yansinduna anoiba yam pumnamak aduna kamkhattriphaoba thamba hameigumbani.” ");
INSERT INTO mni_vpl VALUES ("LK13_22","072_13_22","LUK","13","22","22","Aduga Jisuna Jerusalem tamna chatpada sahar amadi khunggangsing phaora phaoraduna misingbu tambirammi. ");
INSERT INTO mni_vpl VALUES ("LK13_23","072_13_23","LUK","13","23","23","Matam aduda kanagumba amana Ibungoda hairak-i, “Ibungo, mi khara khaktamak kanbiba phanggadabra?” Maduda Jisuna makhoida hairak-i, ");
INSERT INTO mni_vpl VALUES ("LK13_24","072_13_24","LUK","13","24","24","“Akhuba thong aduda changnanaba kanna hotnou. Eina nakhoida hairibasini, mi kaya amana maduda changnaba hotnagani adubu ngamloi. ");
INSERT INTO mni_vpl VALUES ("LK13_25","072_13_25","LUK","13","25","25","Aduga yumbu aduna hougattuna thong adu thingjinkhrabadi, nakhoina mapanda lepkani aduga nakhoina thong thinduna haijagani, ‘Ibungo, thong asi eikhoida hangdokpiyu.’ Adubu mahakna nakhoida haigani, ‘Nakhoi kanano aduga kadaidagi lakpano haiba ei khangde.’ ");
INSERT INTO mni_vpl VALUES ("LK13_26","072_13_26","LUK","13","26","26","Adudagi nakhoina haigani, ‘Eikhoina nahakka chaminnakhi amasung thakminnakhi aduga nahakna eikhoigi lambisingda tambikhi.’ ");
INSERT INTO mni_vpl VALUES ("LK13_27","072_13_27","LUK","13","27","27","Adubu mahakna amuk haigani, ‘Nakhoi kanano aduga kadaidagi lakpano haiba ei khangde. He phattaba thabak toubasa! Nakhoi pumnamak Eingondagi chatthokhro.’ ");
INSERT INTO mni_vpl VALUES ("LK13_28","072_13_28","LUK","13","28","28","Aduga nakhoina Abraham, Isaac, Jacob amasung Tengban Mapugi wa phongdokpiba maichou pumnamakna Tengban Mapugi leibakta uraga nakhoibuna mapanda hundokpiba matam aduda nakhoina kapkani amasung naya krak-krak chikkani. ");
INSERT INTO mni_vpl VALUES ("LK13_29","072_13_29","LUK","13","29","29","Misingna nongpok, nongchup, kha amadi awangdagi lakkani aduga makhoina Tengban Mapugi ningthou leibakki chaklen aduda phamgani. ");
INSERT INTO mni_vpl VALUES ("LK13_30","072_13_30","LUK","13","30","30","Aduga yengu! Houjik akonba oibasing aduna ahanba oigani aduga houjik ahanba oibasing aduna akonba oigani.” ");
INSERT INTO mni_vpl VALUES ("LK13_31","072_13_31","LUK","13","31","31","Matam adumaktada Jisugi manakta Pharisee khara laktuna mangonda hairak-i, “Nahak mapham asi thadoktuna mapham kadaidano ama chatkhro, maramdi Herod-na nahakpu hatpa pamli.” ");
INSERT INTO mni_vpl VALUES ("LK13_32","072_13_32","LUK","13","32","32","Maduda Jisuna makhoida khumlak-i, “Chatlu aduga lamhui aduda hairu, ‘ngasisu hayengsu eina lai phattabasingbu tanthokhigani aduga anabasingbusu phahankhigani aduga humnisuba numitta eina eigi thabak adu loisingani.’ ");
INSERT INTO mni_vpl VALUES ("LK13_33","072_13_33","LUK","13","33","33","Adum oinamakpu, ngasisu, hayengsu aduga hangchitsu eina eigi lambi aduda adumak chakhiba tari; maramdi Tengban Mapugi wa phongdokpiba maichou kanabusu Jerusalemda nattana atei maphamda hatte. ");
INSERT INTO mni_vpl VALUES ("LK13_34","072_13_34","LUK","13","34","34","“Ho Jerusalem, Jerusalem! Tengban Mapugi wa phongdokpiba maichousingbu nahakna hatli aduga Tengban Mapuna nangonda thakhiba pao pubasingbu nungna thai! Yenbina machasingbu mathanungda konsinjabagum eina nanggi nachasingbu kayada toina konsinjaba pamjaramba! Adubu nahakna eingonda kolhankhide. ");
INSERT INTO mni_vpl VALUES ("LK13_35","072_13_35","LUK","13","35","35","Houjikti yengu, nahakki yum thadoktuna thanamlabani. Aduga eina nakhoida hairibasini, ‘MAPU IBUNGO-gi mingda lenglakliba mahak adu yaiphabani’ haina nakhoina haidriba matam adu phaoba nakhoina eibu amuk hanna uba phanglaroi.” ");
INSERT INTO mni_vpl VALUES ("LK14_1","072_14_1","LUK","14","1","1","Nongma Potthaba Numit amada Jisuna Pharisee-singgi luchingba amagi mayumda chaklen chanaba lengsinba matamda misingna mahakpu kupna yenglammi. ");
INSERT INTO mni_vpl VALUES ("LK14_2","072_14_2","LUK","14","2","2","Aduga mapham aduda phugamna naduna makhong makhut pomthokpa nupa ama Ibungogi nakta laklammi. ");
INSERT INTO mni_vpl VALUES ("LK14_3","072_14_3","LUK","14","3","3","Maduda Jisuna Wayeng Yathanggi ojasing amadi Pharisee-sing aduda hanglak-i, “Potthaba Numitta anaba phahanbasi wayel yathangna yabra nattraga yadabra?” ");
INSERT INTO mni_vpl VALUES ("LK14_4","072_14_4","LUK","14","4","4","Adubu maduda makhoina paokhum amata piramde. Aduga Ibungona nupa aduda khut thambiduna naba phahanbiraga thakhirammi. ");
INSERT INTO mni_vpl VALUES ("LK14_5","072_14_5","LUK","14","5","5","Adudagi Ibungona makhoida hanglak-i, “Nakhoi kanagumbagi nachanupa nattraga sal laba ama Potthaba Numitta komda tarabadi, nakhoina Potthaba Numit oirabasu khudak aduda madubu loukhatloidra?” ");
INSERT INTO mni_vpl VALUES ("LK14_6","072_14_6","LUK","14","6","6","Adubu wapham asida makhoina paokhum amata khumba ngamlamde. ");
INSERT INTO mni_vpl VALUES ("LK14_7","072_14_7","LUK","14","7","7","Aduga chaklen aduda lenglaklibasing aduna ikaikhumnabasinggi phamphamsing adu khanba adu Jisuna ubada mahakna pandam ama piraduna hairak-i, ");
INSERT INTO mni_vpl VALUES ("LK14_8","072_14_8","LUK","14","8","8","“Kanagumbana nakhoibu luhongbagi chaklenda kourabadi ikaikhumnabasinggi phampham aduda phamganu maramdi nangondagi henna maruoiba mi ama thouramduda kourambasu yai? ");
INSERT INTO mni_vpl VALUES ("LK14_9","072_14_9","LUK","14","9","9","Karigumba kouramlabadi, yumbu aduna laktuna nangonda haigani, ‘Phampham asida nupa asibu phamhansi.’ Maduda nangna ikaiba nangbaga loinanana hanthaba phamphamda amuk phamgani. ");
INSERT INTO mni_vpl VALUES ("LK14_10","072_14_10","LUK","14","10","10","Madugi mahutta thouram yaobinaba nahakpu kourabadi, thoubu aduna laktuna nangongda, ‘Marup, henna phaba phampham asida kakhatpiyu’ haina hainanaba nahakna chattuna khwaidagi hanthaba phampham aduda phammu. Maduna chaklen aduda nahakka phamminariba pumnamakki mamangda nahakpu ikai khumnagani. ");
INSERT INTO mni_vpl VALUES ("LK14_11","072_14_11","LUK","14","11","11","Maramdi masana masabu chaohanjabasing adubu nollukhangani aduga masana nollukchabasing adubuna chaohanbigani.” ");
INSERT INTO mni_vpl VALUES ("LK14_12","072_14_12","LUK","14","12","12","Adudagi Jisuna mahakpu lakpinaba koujariba yumbu aduda hairak-i, “Nahakna ayukki chaklen nattraga numidang charagidamak chakkouba matamda nahakki marup-mapang nachin nanao, sagei natei nattraga inakhunba yumlon keironnaba gi mibu kouganu maramdi makhoinasu nahakpu amuk kouraktuna nahakna toukhiba adugi laman hallakpasu yai. ");
INSERT INTO mni_vpl VALUES ("LK14_13","072_14_13","LUK","14","13","13","Adubu nahakna chaklen langba matamda laira-anangsing, soinairabasing, khongtekpasing amadi mitangbasingbu kou. ");
INSERT INTO mni_vpl VALUES ("LK14_14","072_14_14","LUK","14","14","14","Aduga makhoina nangongda amuk laman singba ngamjadaba maramna nahak yaiphaba oijagani. Maramdi achumba chatpasingna hinggatpa numit aduda Tengban Mapuna nangongda amuk hanbigani.” ");
INSERT INTO mni_vpl VALUES ("LK14_15","072_14_15","LUK","14","15","15","Jisuga chaklen aduda phamminnariba amana madu tabada Jisuda hairak-i, “Tengban Mapugi leibakki chaklen aduda phamgadaba makhoising adu kayada yaiphaba!” ");
INSERT INTO mni_vpl VALUES ("LK14_16","072_14_16","LUK","14","16","16","Maduda Jisuna mangonda hairak-i, “Kanagumba mi amana achouba chaklen ama langladuna mi mayam ama koujare. ");
INSERT INTO mni_vpl VALUES ("LK14_17","072_14_17","LUK","14","17","17","Aduga chaklen adugi matam laklabada, mahakna manaising tharaduna mahakna lakpinaba haijakhibasing aduda asumna haihankhi, ‘Lakpiro, pumnamak thourang touduna leire.’ ");
INSERT INTO mni_vpl VALUES ("LK14_18","072_14_18","LUK","14","18","18","Adubu makhoi pumnamak chap manana leithokpa houraklammi. Ahanba aduna hairak-i, ‘Eina loubuk ama leisillure aduna eina chattuna madu yengluba tare; aduna eibu ngakpinaba haijari.’ ");
INSERT INTO mni_vpl VALUES ("LK14_19","072_14_19","LUK","14","19","19","Atoppa amana amuk hairak-i, ‘Eina sal laba pabot manga leirure aduna madu chang yenglunaba ei chatlibani. Aduna eibu ngakpinaba haijari.’ ");
INSERT INTO mni_vpl VALUES ("LK14_20","072_14_20","LUK","14","20","20","Adudagi atoppa amana amuk hairak-i, ‘Ei luhongbada ngairi, maram aduna ei lakpa ngamlaroi.’ ");
INSERT INTO mni_vpl VALUES ("LK14_21","072_14_21","LUK","14","21","21","Adudagi minai aduna handuna pumnamaksing asi mapu aduda tamlare. Maduda mapu aduna saoraduna mahakki minai aduda hairak-i, ‘Houjikmak sahargi lambi lambida aduga leirak leirakta thuna chattuna laira-anangsing, soinaibasing, mit-tangbasing amadi khongtekpasingbu mapham asida purak-u.’ ");
INSERT INTO mni_vpl VALUES ("LK14_22","072_14_22","LUK","14","22","22","Madu pangthoklaba matungda minai aduna laktuna hairak-i, ‘Ibungo nahakna haibadu toujare adubu houjiksu mapham hangli.’ ");
INSERT INTO mni_vpl VALUES ("LK14_23","072_14_23","LUK","14","23","23","Maduda mapu aduna minai aduda hairak-i, ‘Nakhoina khullakki lambising amadi leirak leirakta chattuna yum asi thannanaba misingbu mapham asida changhallak-u. ");
INSERT INTO mni_vpl VALUES ("LK14_24","072_14_24","LUK","14","24","24","Eina nakhoi pumnamakta hairi, madudi eina hanna lakpinaba haijakhiba makhoi amatana chaklen asigi mahao tangba phangloi.’ ” ");
INSERT INTO mni_vpl VALUES ("LK14_25","072_14_25","LUK","14","25","25","Adudagi yamlaba miyam ama Jisuga loinana chatminnarammi. Aduga Ibungona makhoida onsillaktuna hairak-i, ");
INSERT INTO mni_vpl VALUES ("LK14_26","072_14_26","LUK","14","26","26","“Eigi inakta lakpa mi amana mahakki mama-mapa, nupi-angang, machin-manao, machal-mache aduga masamakki punsidagi phaoba henna eibu nungsidragadi mahakna eigi tung-inba oiba ngamloi. ");
INSERT INTO mni_vpl VALUES ("LK14_27","072_14_27","LUK","14","27","27","Aduga kanagumba masagi crosspu pujadaba aduga eigi itung illaktaba mahak aduna eigi tung-inba oiba ngamloi. ");
INSERT INTO mni_vpl VALUES ("LK14_28","072_14_28","LUK","14","28","28","Nakhoigi maraktagi kanagumba amana awangba yum ama saninglabadi nahakna phamthaduna madu saba loisinba phaobada konnagadaba nahakki sel leigadra haina changgadaba adu hanna pathokloidra? ");
INSERT INTO mni_vpl VALUES ("LK14_29","072_14_29","LUK","14","29","29","Maramdi nahakna madu toudragadi, yumphamdi hougatlaga awangba yum adu saba loisinba ngamloi; aduga madu awuba misingna nahakpu noknaduna haigani, ");
INSERT INTO mni_vpl VALUES ("LK14_30","072_14_30","LUK","14","30","30","‘Nahakna yum sabadi hougatlamlaga loisinbadi ngamdrene.’ ");
INSERT INTO mni_vpl VALUES ("LK14_31","072_14_31","LUK","14","31","31","Aduga lanmi lising tara leiba ningthou amana lanmi lising kun puduna lakpa atoppa ningthou amaga lanthengnaba chatlabadi, chattringeigi mamangda mahakna ningthou aduga maiyoknaba ngamgadra haina mahakna hanna phamthaduna khantharoidra? ");
INSERT INTO mni_vpl VALUES ("LK14_32","072_14_32","LUK","14","32","32","Aduga mahakna maipakloidaba oiragadi, atoppa ningthou aduna lapna leiringeida karamba phibhamda ingthaba purakpa yagadage haina hangnabagidamak mahakki pao pubasingbu manakta thagani. ");
INSERT INTO mni_vpl VALUES ("LK14_33","072_14_33","LUK","14","33","33","Matou asigumna nakhoigi maraktagi kanagumbana mahakki areiba pumnamaksing adu hek thadoktriba makeidi mahakna eigi tung-inba oiba ngamloi. ");
INSERT INTO mni_vpl VALUES ("LK14_34","072_14_34","LUK","14","34","34","“Thumdi aphaba potni, adubu mahakna mahao mangkhrabadi madubu amuk karamna mahao leihangadage? ");
INSERT INTO mni_vpl VALUES ("LK14_35","072_14_35","LUK","14","35","35","Mahao yaodraba thumdi leibakkidamaksu aduga leihaogidamaksu karisu kannade. Amasung madu langthoknei. Tannanaba manakong panba mahak aduna tajasanu.” ");
INSERT INTO mni_vpl VALUES ("LK15_1","072_15_1","LUK","15","1","1","Nongma kanggat khomba amadi atoppa papchengba pumnamakna Jisuna tambiba tananabagidamak mahakki manakta laklammi. ");
INSERT INTO mni_vpl VALUES ("LK15_2","072_15_2","LUK","15","2","2","Maduda pharisee-sing amadi wayel yathanggi ojasingna marum marum sonduna hainarak-i, “Nupa asina papisingbu taramna ok-i amasung makhoiga chasu chaminnei!” ");
INSERT INTO mni_vpl VALUES ("LK15_3","072_15_3","LUK","15","3","3","Maduda Jisuna pandam asi makhoida hairak-i, ");
INSERT INTO mni_vpl VALUES ("LK15_4","072_15_4","LUK","15","4","4","“Nakhoigi marakta yao chama leiba kanagumba amagi yao ama mangkhrabadi nahakna kari tougani? Nahakna atoppa yao maraphutara mapan adubu lamhangda hundoklamduna mangkhraba yao adubu phangdriphaoba thiroidra? ");
INSERT INTO mni_vpl VALUES ("LK15_5","072_15_5","LUK","15","5","5","Aduga nahakna madubu phangba matamda adukki matik haraoduna nahakna madubu lengbanda thonggatli. ");
INSERT INTO mni_vpl VALUES ("LK15_6","072_15_6","LUK","15","6","6","Aduga nahakna yumda halaktuna nahakki marup-mapangsing amadi keirol-leikaisingbu kouraduna makhoida hai, ‘Eina eigi mangluraba yao adu amuk hanna phangjare, aduna eikhoi haraominnasi.’ ");
INSERT INTO mni_vpl VALUES ("LK15_7","072_15_7","LUK","15","7","7","Eina nakhoida hairi madudi, matou adugumduna pukning hongba mathou tadaba achumba chatpa makhoi maraphutara mapandagi papchenba amana pukning hongbada swargada henna haraoba oigani. ");
INSERT INTO mni_vpl VALUES ("LK15_8","072_15_8","LUK","15","8","8","“Nattraga lupagi senmayek tara leibi nupi amagi senmayek ama mangkhrabadi mahakna thaomei chukhattuna amadi yumdu sumjit sittuna senmayek adu phangdriba phaoba cheksinna thiroidra? ");
INSERT INTO mni_vpl VALUES ("LK15_9","072_15_9","LUK","15","9","9","Aduga mahakna madu phangba matamda mahakna magi marup-mapangsing amadi keirol-leikaisingbu kouraduna hai, ‘Eina eigi mangluraba senmayek adu amuk phangjare, aduna eikhoi haraominnasi.’ ");
INSERT INTO mni_vpl VALUES ("LK15_10","072_15_10","LUK","15","10","10","Eina nakhoida hairi madudi matou adugumduna pap chengba amana paptagi pukning hongba matamda Tengban Mapugi swargadutsingna harao-i.” ");
INSERT INTO mni_vpl VALUES ("LK15_11","072_15_11","LUK","15","11","11","Jisuna makha tana hairak-i, “Kanagumba nupa amagi machanupa ani leirammi. ");
INSERT INTO mni_vpl VALUES ("LK15_12","072_15_12","LUK","15","12","12","Aduga machanupa atomba aduna mapada hairammi, ‘Ipa, Eigi phangpham thokpa lanthumgi saruk adu eingonda pibiro.’ Adudagi mapa aduna mahakki areiba lanthum adu makhoi anida yenthokpire. ");
INSERT INTO mni_vpl VALUES ("LK15_13","072_15_13","LUK","15","13","13","Madugi matung numit kharagi matungda machanupa atomba aduna mahakki lanthumgi saruk adu yonthoktuna senpham adu puraga mayum thadoktuna chatkhre. Aduga mahakna arappa leibak amada chatuna cheksindaba punsi mahing amada hingduna maran-mathum pumnamak manghallammi. ");
INSERT INTO mni_vpl VALUES ("LK15_14","072_15_14","LUK","15","14","14","Amasung mahakki leijaba pumnamak adu sijinnathokhraba matungda leibak aduda sathina chak tangba thokle aduga mahak awatpana thallakle. ");
INSERT INTO mni_vpl VALUES ("LK15_15","072_15_15","LUK","15","15","15","Adudagi mahakna lam aduda leiba mi amagida chattuna mahakpu thabakta sijinnabinaba haijarure amasung nupa aduna mahakpu ok sennanaba thare. ");
INSERT INTO mni_vpl VALUES ("LK15_16","072_15_16","LUK","15","16","16","Aduga mahak adukki matik mabuk lamlammi madudi okta pijariba okchak adu chaduna mabuk thalhanninglammi. Adubu kana amatana mangonda kari amata pibiramde. ");
INSERT INTO mni_vpl VALUES ("LK15_17","072_15_17","LUK","15","17","17","Mameithangda mahakna wakhal tarakladuna masa mathanta haijarammi, ‘Eigi ipagi anekpa minaisingna phaoba chananaba lem pana lei aduga eina maphamsida lambana sigadoure! ");
INSERT INTO mni_vpl VALUES ("LK15_18","072_15_18","LUK","15","18","18","Eina hougattuna ipagi manakta chatlaga haigani, Ipa, eina Tengban Mapu amadi nahakki maiyokta pap toukhre. ");
INSERT INTO mni_vpl VALUES ("LK15_19","072_15_19","LUK","15","19","19","Eihak amuk hanna nahakki nachanupa koubada matik chadre; eihakpu nahakki anekpa minai amagumna lousinbiyu.’ ");
INSERT INTO mni_vpl VALUES ("LK15_20","072_15_20","LUK","15","20","20","Adudagi mahakna hougattuna mapagi manakta halakle. “Aduga mahakna mayum yougadaba thaplingeidagi mahakna lakpa adu mapana urammi. Amasung thamoida nungsibana thalladuna mahakna machagi manakta chenthoraklaga mahakpu konsinduna chupkhi. ");
INSERT INTO mni_vpl VALUES ("LK15_21","072_15_21","LUK","15","21","21","Matamduta machanupa aduna hairak-i, ‘Ipa, Eina Tengban Mapu amadi nahakki maiyokta pap toukhre. Eihak amuk hanna nahakki nachanupa koubada matik chadre.’ ");
INSERT INTO mni_vpl VALUES ("LK15_22","072_15_22","LUK","15","22","22","Adubu mapa aduna mahakki minaisingbu kouraduna hairak-i, ‘Thuna mahakkidamak khwaidagi phaba phijol puraktuna setchinbiyu, khutsada khudop sijinbiyu amasung makhongda khong-up tongsinbiyu. ");
INSERT INTO mni_vpl VALUES ("LK15_23","072_15_23","LUK","15","23","23","Aduga masa noiba sa ama puraktuna hatlu. Eikhoina chaklen ama sinduna harao nungaiba phongdoksi. ");
INSERT INTO mni_vpl VALUES ("LK15_24","072_15_24","LUK","15","24","24","Maramdi eigi ichanupa asi sirurabani adubu amuk hinglakle; mahak manglurabani adubu amuk phangjare.’ Adudagi makhoina harao nungaiminaba houre. ");
INSERT INTO mni_vpl VALUES ("LK15_25","072_15_25","LUK","15","25","25","“Matam aduda machanupa ahal adudi loubukta leirammi. Aduga mahakna halaktuna yum naksilaklabada isei-nongmai amasung jagoi sabagi makhol tarammi. ");
INSERT INTO mni_vpl VALUES ("LK15_26","072_15_26","LUK","15","26","26","Adudagi mahakna manaising amabu kouduna mapham asida touribasing asi karino haina hanglammi. ");
INSERT INTO mni_vpl VALUES ("LK15_27","072_15_27","LUK","15","27","27","Maduda manai aduna khumlak-i, ‘Nahakki nanaonupa aduk amuk halakle, aduga mahakna asoi angam karisu yaodana halakpa adugidamak nahakki napana masa noihallaba sa ama hatlibani.’ ");
INSERT INTO mni_vpl VALUES ("LK15_28","072_15_28","LUK","15","28","28","Maduda machanupa ahal adu adukki matik saorammi amasung mayumda changlamde. Maram aduna mapa aduna thoraktuna mahakpu yumda changlaknaba haijarammi. ");
INSERT INTO mni_vpl VALUES ("LK15_29","072_15_29","LUK","15","29","29","Adubu mahakna mapada hairak-i, ‘Yengngu, chahi kaya asi eina minai amagumna nahakkidamak thabak surakli aduga nongmatasu nahakki yathang indaba toukhidri. Adubu eigi marup mapangsingga chaminnaduna haraominnanaba hameng macha amatang phaoba nahakna eingonda keidoungeidasu pikhidri. ");
INSERT INTO mni_vpl VALUES ("LK15_30","072_15_30","LUK","15","30","30","Adubu nahakki naral nathum apumba oktabi nupisingda hundokluraga halakpa nahakki nachanupa asigidamaktadi nahakna anoiba sa hattuna haraoba phongdokli.’ ");
INSERT INTO mni_vpl VALUES ("LK15_31","072_15_31","LUK","15","31","31","Maduda mapa aduna mangonda khumlak-i, ‘Yengu, ichanupa, nahakti matam pumnamakta eihakka leiminnari aduga eigi areiba pumnamaksisu nahakkini. ");
INSERT INTO mni_vpl VALUES ("LK15_32","072_15_32","LUK","15","32","32","Aduga asumna harao nungaiminnabagi thouram asisu pangthokpada matik chai, maramdi nahakki nanaonupa asi sirurabani adubu amuk hinglakle; mahak manglurabani adubu amuk phangjare.’ ” ");
INSERT INTO mni_vpl VALUES ("LK16_1","072_16_1","LUK","16","1","1","Jisuna pandam asimasu mahakki tung-inbasingda hairak-i, “Kanagumba inakhunba nupa amagi thabak asin-arang touba nupa ama leirammi. Amasung mahakki asin arang touba nupa asina mahakki maran mathum manghalle haiduna inakhunba nupa aduda kanagumba amana tamlammi. ");
INSERT INTO mni_vpl VALUES ("LK16_2","072_16_2","LUK","16","2","2","Maram aduna mahakna thabak asin-arang touba nupa adubu kouraduna hairak-i, ‘Eina nanggi maramda taribasi karino? Nahakna yumgi thabak asin arang toubagi chaga-chading pumnamak piyu maramdi nahak makha-tana eigi asin aran touba mi oiba yararoi.’ ");
INSERT INTO mni_vpl VALUES ("LK16_3","072_16_3","LUK","16","3","3","Maduda thabak asin arang touba nupa aduna mathanta khanjarammi, ‘Eina houjik kari tougani? Eigi mapu asina eibu thabaktagi louthoklagani. Leibak touba ngambagi panggalsu eingonda leite aduga nibasu ikaijei. ");
INSERT INTO mni_vpl VALUES ("LK16_4","072_16_4","LUK","16","4","4","Um! Houjikti mana eibu thabaktagi louthoklaba tungda misingna eibu makhoi makhoigi mayumda lousinbinanaba eina kari tougadage haibadu ei khangle.’ ");
INSERT INTO mni_vpl VALUES ("LK16_5","072_16_5","LUK","16","5","5","Maram aduna mahakna mahakki mapugi lal tonba makhoi khudingmakpu kourammi. Aduga mahakna ahanba aduda hanglak-i, ‘Nahakna Ibungogi lal kaya yamna tollibage?’ ");
INSERT INTO mni_vpl VALUES ("LK16_6","072_16_6","LUK","16","6","6","Nupa aduna khumlak-i, ‘Chorphon thao gallon chanipan tolli.’ Maduda mahakna nupa aduda haikhi, ‘Nahakki ayiba che adu sida leire, thuna phamthaduna madu chamari yangkheida oihallo.’ ");
INSERT INTO mni_vpl VALUES ("LK16_7","072_16_7","LUK","16","7","7","Adudagi mahakna atoppa amada amuk hanglak-i, ‘Aduga nahakkina kaya tollibage?’ Nupa aduna khumlak-i, ‘Gehu bora lising amamuk tolli.’ Maduna mahakna nupa aduda haikhi, ‘Nahakki ayiba che adu sida leire, madu nahakna chanipanda oihallo.’ ");
INSERT INTO mni_vpl VALUES ("LK16_8","072_16_8","LUK","16","8","8","Madugi mahei oina mapu aduna pukchel sengdaba thabak asin arang touba nupa adubu asigumba heisingba thabak asigidamak thagatlammi. Maramdi taibangpan asigi machasingna makhoigi mirol asida mangalgi machasingdagi henna sing-i.” ");
INSERT INTO mni_vpl VALUES ("LK16_9","072_16_9","LUK","16","9","9","Eina nakhoida hairibasini, asumna nakhoina taibangpanbagi lan thum sijinnaduna nakhoi nasagidamak marup semmu aduga langi kanapham leitraba matam aduda makhoina nakhoibu lomba naidaba yumda lousinbigani. ");
INSERT INTO mni_vpl VALUES ("LK16_10","072_16_10","LUK","16","10","10","Khajiktada thajaba yaba mahak adu ayambadasu thajaba yabani aduga khajiktada pukchel sengdaba mahak adu ayambadasu pukchel sengdabani. ");
INSERT INTO mni_vpl VALUES ("LK16_11","072_16_11","LUK","16","11","11","Aduga nakhoina taibangpanba asigi lan-thum sijinnabada thajaba yaba oidrabadi kanana nakhoida asengba lan adu sinnabada thajagadage? ");
INSERT INTO mni_vpl VALUES ("LK16_12","072_16_12","LUK","16","12","12","Aduga atoppa misinggi lanthumda nakhoibu thajaba yaba oidrabadi kanana nakhoida nasagi oiba lan-thum pibigani? ");
INSERT INTO mni_vpl VALUES ("LK16_13","072_16_13","LUK","16","13","13","“Minai kananasu mapu anigi thougal touba ngamde. Maramdi mahakna amabu tukachagani aduga amabuna nungsigani nattraga amabu luna ningjaraga amabuna thaoiroi. Nakhoina Tengban Mapu amadi lan animakpu punna thougal touba ngamloi.” ");
INSERT INTO mni_vpl VALUES ("LK16_14","072_16_14","LUK","16","14","14","Pharisee-singna masi pumnamaksing asi tabada makhoina Jisubu noknarammi maramdi makhoi sel-thumda ngaojarammi. ");
INSERT INTO mni_vpl VALUES ("LK16_15","072_16_15","LUK","16","15","15","Maduda Jisuna makhoida hairak-i, “Nakhoina misinggi mamangda achumba chatpa sasinnei adubu Tengban Mapuna nakhoigi thamoi khang-i. Maramdi misingna mamal leina loujaba potsaksing adu Tengban Mapugi mityengdadi tukkachaningaini.” ");
INSERT INTO mni_vpl VALUES ("LK16_16","072_16_16","LUK","16","16","16","“Baptize toubiba Johngi matam adu phaoba Moses-ki wayel yathangsing amadi Tengban Mapugi wa phongdokpiba maichousinggi wa adu sandoklammi. Adubu houjikti Tengban Mapu leibakki aphaba pao adu sandokli aduga mipum khudingna maduda changnanaba hotnari. ");
INSERT INTO mni_vpl VALUES ("LK16_17","072_16_17","LUK","16","17","17","Wayel yathanggi khwaidagi pikpa saruk ama mangkhibadagidi swarga amadi malem taibangpan mangkhibana henna lai. ");
INSERT INTO mni_vpl VALUES ("LK16_18","072_16_18","LUK","16","18","18","“Kanagumba nupa amana mahakki nupibu khainaraga atoppa nupi amaga luhonglabadi mahakna lannabagi thabak tou-i; aduga mapuroibaga khainarabi nupi louba nupa adusu lannabagi thabak tourabani.” ");
INSERT INTO mni_vpl VALUES ("LK16_19","072_16_19","LUK","16","19","19","“Matam amada atangba masaknaiba mangra machu amadi mugamanbigi phirol setpa kanagumba inak-khunba nupa ama leirammi. Mahakna matam pumba awatpa leitana nungai yaiphana pallammi. ");
INSERT INTO mni_vpl VALUES ("LK16_20","072_16_20","LUK","16","20","20","Aduga mahakki thongalda Lazarus kouba masa pumba patpa lairaba nupa amasu hiptuna leirammi. ");
INSERT INTO mni_vpl VALUES ("LK16_21","072_16_21","LUK","16","21","21","Mahakna Inak-khunba nupa adugi chanaba phandagi tarakpa acha athak makup matasing adu chajanaba asha toujarammi. Aduga huisingna laktuna mahakki apatpa adu leklammi. ");
INSERT INTO mni_vpl VALUES ("LK16_22","072_16_22","LUK","16","22","22","Adudagi nongma lairaba nupa adu sirammi amasung swargadutsingna mahakpu Abrahamgi mathada pukhre. Aduga inak-khunba nupa adusu siraduna phumle. ");
INSERT INTO mni_vpl VALUES ("LK16_23","072_16_23","LUK","16","23","23","Amasung khamnung leibakta mahakna awaba khangduna mathakta yengkhatpa matamda thapna Abraham amasung mahakki nakanda Lazarus leiba urammi. ");
INSERT INTO mni_vpl VALUES ("LK16_24","072_16_24","LUK","16","24","24","Maduda inak-khunba nupa aduna laorak-i, ‘Ipa Abraham! Eibu nungsibiyu aduga Lazarus-na mahakki khudombi isingda luptuna eigi irei asibu ingthahanbinaba mahakpu thabirak-u, maramdi meiri marak asida ei yamna ware.’ ");
INSERT INTO mni_vpl VALUES ("LK16_25","072_16_25","LUK","16","25","25","Adubu Abrahamna khumlak-i, ‘Ningsing-u ichanupa, nahakna hinglingei matamda aphaba pot pumnamak phangkhi aduga Lazarus-nadi phattaba pumnamak phangkhi. Adubu mahakna houjikti mapham asida nungngaiba phangle aduga nahakna awa meichak khangli. ");
INSERT INTO mni_vpl VALUES ("LK16_26","072_16_26","LUK","16","26","26","Pumnamak asigi mathakta mapham asidagi nakhoigi manakta chatningba misingna chatpa ngamdanaba aduga mapham adudagi eikhoigi inakta lakningbasingna lakpa ngamdananaba lukhraba kom ama lei.’ ");
INSERT INTO mni_vpl VALUES ("LK16_27","072_16_27","LUK","16","27","27","Maduda inak-khunba nupa aduna hairak-i, ‘Adu oirabadi eina nangonda haijari, Ipa Abraham, nahakna Lazaras-pu eigi ipagi yumda thabiyu. ");
INSERT INTO mni_vpl VALUES ("LK16_28","072_16_28","LUK","16","28","28","Maramdi eigi ichin-inao manga lei, aduga makhoina awa meichakki mapham asida laktananaba makhoida mahakna cheksin-wa haihanbiyu.’ ");
INSERT INTO mni_vpl VALUES ("LK16_29","072_16_29","LUK","16","29","29","Abraham-na hairak-i, ‘Nahakki nachin-nanaosinggi maphamda cheksin wa hainabagidamak Moses amasung Tengban Mapugi wa phongdokpiba maichousing lei, makhoigi wa adu nahakki nachin-nanaosingna tasanu.’ ");
INSERT INTO mni_vpl VALUES ("LK16_30","072_16_30","LUK","16","30","30","Inak-khunba nupa aduna khumlak-i, ‘Natte ipa Abraham, madukhaktanadi yaroi! Adubu asibasinggi maraktagi kanagumba amana makhoida chatlabadi makhoina paptagi pukning honggani.’ ");
INSERT INTO mni_vpl VALUES ("LK16_31","072_16_31","LUK","16","31","31","Adubu Abrahamna mangonda hairak-i, ‘Makhoina Moses amadi Tengban Mapugi wa phongdokpiba maichousinggi wa tadrabadi kanagumbana sibadagi hinggatlabasu makhoibu thajahanba ngamloi.’ ” ");
INSERT INTO mni_vpl VALUES ("LK17_1","072_17_1","LUK","17","1","1","Nongma Jisuna mahakki tung-inbasingda hairak-i, “Misingbu papta tahanba athembasingdi adumak lakkani, adubu masi thok-halliba mahak adudi awabanida! ");
INSERT INTO mni_vpl VALUES ("LK17_2","072_17_2","LUK","17","2","2","Mahakna apikpa angangsing asigi maraktagi amabu papta tahallabadi, mahakki mangakta achouba chakri nung ama yansillaga achouba ipakta thadabana mahakkidamak henna phei. ");
INSERT INTO mni_vpl VALUES ("LK17_3","072_17_3","LUK","17","3","3","Maram aduna nasamak cheksillu. “Karigumba nahakki nachin nanaona pap tourabadi mahakpu warak watembiyu. Aduga mahakna pukning honglabadi mahakpu kokpiyu. ");
INSERT INTO mni_vpl VALUES ("LK17_4","072_17_4","LUK","17","4","4","Mahakna nahakki nathakta nongmada pap taretlak touraba aduga atouba khudingmakta mahakna nagonda laktuna, ‘Ei pukning hongjare’ haijarabadi nahakna mahakpu kokpigadabani.” ");
INSERT INTO mni_vpl VALUES ("LK17_5","072_17_5","LUK","17","5","5","Pakhonchatpasing aduna Ibungoda hairak-i, “Eikhoigi thajaba hengathanbiyu.” ");
INSERT INTO mni_vpl VALUES ("LK17_6","072_17_6","LUK","17","6","6","Maduda Ibungona khumlak-i, “Nakhoida hangam marumuk chaoba thajaba leirabadi nakhoina kabrangchak pambi asida nasana maru phukchaduna achouba ipakta houru haibada pambi asina nakhoigi yathang ingani.” ");
INSERT INTO mni_vpl VALUES ("LK17_7","072_17_7","LUK","17","7","7","“Nakhoigi maraktagi amagi lou khoiba nattraga yao senba minai ama lei haina khallasi. Aduga minai aduna loubuktagi halakpa matamda nahakna minai aduda thuna laktuna chak chananaba phamlo haigadra? ");
INSERT INTO mni_vpl VALUES ("LK17_8","072_17_8","LUK","17","8","8","Hairoi nattra! Madugi mahutta mahakna minai aduda haigani, ‘Eigi chaklen thourang tou, aduga thourang toujaduna eina chari thaklingeida eibu thougal tou; aduga madu loiraga nahak amuk chaba yagani.’ ");
INSERT INTO mni_vpl VALUES ("LK17_9","072_17_9","LUK","17","9","9","Aduga minai aduna mangonda tounaba haibasing adu inbagidamak mapu aduna mahakpu thagatkadra? Thagatkani haina eina khande. ");
INSERT INTO mni_vpl VALUES ("LK17_10","072_17_10","LUK","17","10","10","Maram aduna, matou asigumduna nakhoida tounanaba haikhiba pumnamaksing adu pangthokpa matamda nakhoinasu haiyu, ‘Eikhoi matik chadaba minaisingni, eikhoina eikhoigi ithoudangsing adu pangthokchaba khaktani.’ ” ");
INSERT INTO mni_vpl VALUES ("LK17_11","072_17_11","LUK","17","11","11","Adudagi Jisuna Jerusalem tamna asum lakpada Samaria amadi Galilee-gi tainapham maphamdu phaoduna chatlammi. ");
INSERT INTO mni_vpl VALUES ("LK17_12","072_17_12","LUK","17","12","12","Aduga mahakna khunggang amada changlakpa matamda tamthiba unsagi leinana naba makhoi taraga thengnarammi. Amasung makhoina lapna lepladuna, ");
INSERT INTO mni_vpl VALUES ("LK17_13","072_17_13","LUK","17","13","13","khonjel houna kouraduna hairak-i, “Jisu! Ibungo! Eikhoibu nungsibiyu!” ");
INSERT INTO mni_vpl VALUES ("LK17_14","072_17_14","LUK","17","14","14","Aduga Ibungona makhoibu ubada makhoida hairak-i, “Chatlu aduga nakhoi nasamakpu purohitta utcharu.” Amasung makhoina lambida asum chatlingeida makhoigi anaba adu sengjare. ");
INSERT INTO mni_vpl VALUES ("LK17_15","072_17_15","LUK","17","15","15","Aduga makhoigi maraktagi amana mahakki anabadu Jisuna phahanbire haibadu ujabada mahakna Ibungogi manakta halaktuna khonjel houna Tengban Mapubu thagatlak-i. ");
INSERT INTO mni_vpl VALUES ("LK17_16","072_17_16","LUK","17","16","16","Mahakna Jisugi khuyakhada tuthajaduna mahakpu thagatcharammi. Amasung nupa adu Samaria-gi mi oirammi. ");
INSERT INTO mni_vpl VALUES ("LK17_17","072_17_17","LUK","17","17","17","Maduda Jisuna hairak-i, “Eina makhoi taramakpu senghanbikhiba nattra? Aduga atoppa mapan adudi kadai? ");
INSERT INTO mni_vpl VALUES ("LK17_18","072_17_18","LUK","17","18","18","Atoppa phurupki nupa asi nattana Tengban Mapubu thagatnanaba atei kana amata halaktrabra?” ");
INSERT INTO mni_vpl VALUES ("LK17_19","072_17_19","LUK","17","19","19","Adudagi Jisuna nupa aduda hairak-i, “Hougattuna chatcharo, nahakki thajabana nahakpu phahanbire.” ");
INSERT INTO mni_vpl VALUES ("LK17_20","072_17_20","LUK","17","20","20","Nongma pharisee kharana Tengban Mapugi leibak adu karamba matamda lakkadage haina hangbada Jisuna khumlak-i, “Tengban Mapugi Leibak adu uba ngamba phibamsingga loinana lakte. ");
INSERT INTO mni_vpl VALUES ("LK17_21","072_17_21","LUK","17","21","21","Aduga mi kana amatana ‘Yengu, asisa leire nattraga maduda leire’ haina haiba ngamloi; maramdi Tengban Mapugi leibak adu nakhoigi nungda lei.” ");
INSERT INTO mni_vpl VALUES ("LK17_22","072_17_22","LUK","17","22","22","Adudagi Ibungona mahakki tung-inbasing aduda hairak-i, “Migi Machanupa adugi numitsing adudagi numit amabu nakhoina yamna ujaningba matam ama lakkani, adubu nakhoina madu uroi. ");
INSERT INTO mni_vpl VALUES ("LK17_23","072_17_23","LUK","17","23","23","Amasung misingna nakhoida haigani, ‘Yengu mahak asida leire, nattraga yengu mahak aduda leire!’ Adubu nakhoina madu yengnabagidamak chatthokkanu, makhoigi matung inganu. ");
INSERT INTO mni_vpl VALUES ("LK17_24","072_17_24","LUK","17","24","24","Maramdi atiyagi nakal amada nongthang kuppada nakal adudagi atoppa nakal amagi ngamkhei phaoba nganbagumna Migi Machanupa adugi numit adusu matou adugumna oigani.” ");
INSERT INTO mni_vpl VALUES ("LK17_25","072_17_25","LUK","17","25","25","Adubu ahanbada mahakna awa-anang kaya khangba tai amasung miron asina mahakpu inthokpa tai. ");
INSERT INTO mni_vpl VALUES ("LK17_26","072_17_26","LUK","17","26","26","Noah-gi haktakta oikhiba adugumna migi Machanupa adugi numit adusu adugumna oigani. ");
INSERT INTO mni_vpl VALUES ("LK17_27","072_17_27","LUK","17","27","27","Noah-na hijao adugi manungda changdringei matam adu phaoba misingna cha-thaktuna, luhongduna amadi luhongnabagidamak piduna leirammi. Adudagi ising ichao laktuna makhoi pumnamakpu manghankhi. ");
INSERT INTO mni_vpl VALUES ("LK17_28","072_17_28","LUK","17","28","28","Matou adugumduna Lotki matamdasu thokkhi. Misingna cha-thaktuna, lei-yonduna, mahei-marong thaduna amadi yum saduna leirammi. ");
INSERT INTO mni_vpl VALUES ("LK17_29","072_17_29","LUK","17","29","29","Aduga Lot-na Sodom thadokpa numit aduda atiyadagi mei amadi kantrukki nong taraktuna makhoi pumnamakpu manghankhi. ");
INSERT INTO mni_vpl VALUES ("LK17_30","072_17_30","LUK","17","30","30","Asumna Migi Machanupa adubu phongdokpa numit adudasu oigani. ");
INSERT INTO mni_vpl VALUES ("LK17_31","072_17_31","LUK","17","31","31","“Numit aduda yumthakta leiba mahakna mapot-machei lounanaba imungda amuk kumthadasanu; matou asigumduna loubukta leiba mahakna yumda amuk halaktasanu. ");
INSERT INTO mni_vpl VALUES ("LK17_32","072_17_32","LUK","17","32","32","Lot-ki nupibu ningsingu! ");
INSERT INTO mni_vpl VALUES ("LK17_33","072_17_33","LUK","17","33","33","Kanagumba mathawai kanjaningba mahak aduna madubu mangjagani, aduga mathawai mangjaba mahak aduna madubu phangjagani. ");
INSERT INTO mni_vpl VALUES ("LK17_34","072_17_34","LUK","17","34","34","Eina nakhoida hairibasini, ahing aduda phamung amada mi ani hipminnagani, aduga mi amabu pukhigani aduga amabuna thanamgani. ");
INSERT INTO mni_vpl VALUES ("LK17_35","072_17_35","LUK","17","35","35","Nupi ani chakkri takminnagani, amasung nupi amabu pukhigani aduga amabuna thanamgani.” ");
INSERT INTO mni_vpl VALUES ("LK17_36","072_17_36","LUK","17","36","36","Mi ani loubukta thabak suminnagani; amabu pukhigani, aduga atoppa amabu thanamgani. ");
INSERT INTO mni_vpl VALUES ("LK17_37","072_17_37","LUK","17","37","37","Maduda tung-inbasingduna hanglak-i, “Masi kadaida thokkadabano, Ibungo?” Jisuna khumlak-i, “Asiba hakchang leiba mapham aduda langjasingna tingani.” ");
INSERT INTO mni_vpl VALUES ("LK18_1","072_18_1","LUK","18","1","1","Adudagi Jisuna mahakki tung inbasing aduda, matam pumnamakta haijagadabani aduga keidounungda pukning hantharoidabani haiba tambinaba pandam ama hairak-i, ");
INSERT INTO mni_vpl VALUES ("LK18_2","072_18_2","LUK","18","2","2","“Karigumba Sahar amada Tengban Mapu kidaba migidamak karisu khandaba wayel mapu ama leirammi. ");
INSERT INTO mni_vpl VALUES ("LK18_3","072_18_3","LUK","18","3","3","Aduga sahar adumaktada lukhrabi amasu leirammi. Mahakna wayen mapu aduda tattana laktuna, ‘Eihakki yeknabagi mathakta achumba wayel toubiyu’ haina haijarammi. ");
INSERT INTO mni_vpl VALUES ("LK18_4","072_18_4","LUK","18","4","4","Matam kuina wayen mapu aduna yaramde adubu mameidadi mahak masa mathanta haijarammi, ‘Eina Tengban Mapubu kidrabasu aduga migidamak karisu khandrabasu, ");
INSERT INTO mni_vpl VALUES ("LK18_5","072_18_5","LUK","18","5","5","lukhrabi asina eingonda awaba piduna leibagi maramna mahakkidamak ei achumba wayel tourage. Eina masi toudragadi mahakna asum laktuna eibu yetlaragani.’ ” ");
INSERT INTO mni_vpl VALUES ("LK18_6","072_18_6","LUK","18","6","6","Adudagi Ibungona makha tana hairak-i, “Wayel chumdaba mapu aduna haiba adu tao. ");
INSERT INTO mni_vpl VALUES ("LK18_7","072_18_7","LUK","18","7","7","Adunadi Tengban Mapuda ahing nungthil animakta mateng panbinaba haijariba Ibungo masamakki khandokkhraba mising adugidamak mahakna achumba wayel toubiroidra? Mahakna makhoibu mateng pangbada thinthaduna leigadra? ");
INSERT INTO mni_vpl VALUES ("LK18_8","072_18_8","LUK","18","8","8","Eina nakhoida hairibasini, mahakna makhoigidmak achumba wayel thunamak toubigani. Adubu Migi Machanupa aduna lakpa matamda malem asida mangonda thajaba mi mahakna phanggadra?” ");
INSERT INTO mni_vpl VALUES ("LK18_9","072_18_9","LUK","18","9","9","Adudagi Jisuna masa mathantabu achumba chatpani haina thajajaba aduga mi ateibuna hanthana khanba makhoising aduda pandam asimasu hairak-i, ");
INSERT INTO mni_vpl VALUES ("LK18_10","072_18_10","LUK","18","10","10","“Nupa anikhak Mapugi Sanglenda haijanabagidamak kakhatlammi. Nupa amana phariseeni aduga amna kanggat khombani. ");
INSERT INTO mni_vpl VALUES ("LK18_11","072_18_11","LUK","18","11","11","Adudagi pharisee aduna lepkhattuna masagi maramda asumna haijakhi, ‘Tengban Mapu, eina nangbu thagatchari, eidi atoppa misinggumna namja-namtheknaba, pukchel sengdaba, amasung nupi lannaba mi natte aduga mapham asida leiriba kanggat khomba mi asigumbasu natte. ");
INSERT INTO mni_vpl VALUES ("LK18_12","072_18_12","LUK","18","12","12","Eina chayol amada anirak chara helli aduga eigi leijaba pumnamakki saruk taragi ama nangonda pi.’ ");
INSERT INTO mni_vpl VALUES ("LK18_13","072_18_13","LUK","18","13","13","Adubu kanggat khomba adunadi lapna leplaga mamai phaoba swargaromda yengkhatchaba ngamjadana leirammi aduga mahakna mathabak yeijaraduna hairak-i, ‘Tengban Mapu, papchenba eibu chanbiyu.’ ");
INSERT INTO mni_vpl VALUES ("LK18_14","072_18_14","LUK","18","14","14","Eina nakhoida hairibasini, madudi pharisee adu nattaduna kanggat khomba adubu Tengban Mapuna achumba chatpa oina singthanabiduna mayumda hankhirammi. Maramdi masa mathantabu chaohanjaba mi adubu nollukhangani aduga masa mathanta nollukchaba mi adubu chaohanbigani.” ");
INSERT INTO mni_vpl VALUES ("LK18_15","072_18_15","LUK","18","15","15","Nongma mioi kharana makhoigi apikpa angangsingbu Jisuna khut thambiduna yaipha-thoujal pihannabagidamak Jisugi nakta puraklammi. Ibungogi tung-inbasing aduna madu ubada makhoida cheirammi. ");
INSERT INTO mni_vpl VALUES ("LK18_16","072_18_16","LUK","18","16","16","Adubu Jisuna makhoibu kousinduna hairak-i, “Apikpa angangsingna eigi inakna lakchasanu, makhoibu khamganu, maramdi Tengban Mapugi leibak adu makhoi asigumbasinggini. ");
INSERT INTO mni_vpl VALUES ("LK18_17","072_18_17","LUK","18","17","17","Eina nakhoida tasengnamak hairibasini, apikpa angang amagumna Tengban Mapugi leibak adubu lousindaba kanagumba amatana Tengban Mapugi leibakta khak changloi.” ");
INSERT INTO mni_vpl VALUES ("LK18_18","072_18_18","LUK","18","18","18","Nongma Jihudigi luchingba amana Jisuda asumna hanglammi, “Aphaba Oja Ibungo, lomba naidaba punsi phangjanaba eina kari toujagadage?” ");
INSERT INTO mni_vpl VALUES ("LK18_19","072_18_19","LUK","18","19","19","Maduda Jisuna mangonda hairak-i, “Karigi nangna eingonda aphaba haina kouribano? Tengban Mapu nattana aphaba kana amata leite. ");
INSERT INTO mni_vpl VALUES ("LK18_20","072_18_20","LUK","18","20","20","Nahakna Tengban Mapugi wayel yathangsing asi khang-i: ‘Mitu-miwa lannaganu, mi hatkanu, huran-ganu, aranba sakhi piganu, amasung nama napabu ikai khumnou.’ ” ");
INSERT INTO mni_vpl VALUES ("LK18_21","072_18_21","LUK","18","21","21","Nupa aduna khumlak-i, “Eina angang oiringeidagi houna hairiba wayel yathang pumnamaksing asi ngakcharak-i.” ");
INSERT INTO mni_vpl VALUES ("LK18_22","072_18_22","LUK","18","22","22","Jisuna mahakki paokhum adu tarabada nupa aduda hairak-i, “Houjik nahakna tougadaba ama watli. Nahakki leijaba pumba yonthoklaga sel adu lairabasingda pithok-u, adu oirabadi swargada nahakki lan leigani; aduga lak-u, eigi itung illu.” ");
INSERT INTO mni_vpl VALUES ("LK18_23","072_18_23","LUK","18","23","23","Adubu nupa aduna madu tabada pukning yamna warammi, maramdi mahak inak yamna khunlammi. ");
INSERT INTO mni_vpl VALUES ("LK18_24","072_18_24","LUK","18","24","24","Maduda nupa aduna pukning yamna waba adu Jisuna uraduna hairakki, “Inakkhunba misingna Tengban Mapugi leibakta changba kayada lukhrabano! ");
INSERT INTO mni_vpl VALUES ("LK18_25","072_18_25","LUK","18","25","25","Inakkhunba mi amana Tengban Mapugi leibakta changbabudi ut amana yetum manada litpana henna lai.” ");
INSERT INTO mni_vpl VALUES ("LK18_26","072_18_26","LUK","18","26","26","Maduda wa adu taba mising aduna hairak-i, “Adu oirabadi kanana kanbiba phangba ngamgadage?” ");
INSERT INTO mni_vpl VALUES ("LK18_27","072_18_27","LUK","18","27","27","Jisuna khumlak-i, “Mioibagi maphamda oithoktaba adu Tengban Mapugi maphamdadi oithokpa ngaktani.” ");
INSERT INTO mni_vpl VALUES ("LK18_28","072_18_28","LUK","18","28","28","Maduda Peter-na hairak-i, “Yengbiyu, eikhoina eikhoigi leijaba pumnamak thadoktuna Ibungogi tung injari.” ");
INSERT INTO mni_vpl VALUES ("LK18_29","072_18_29","LUK","18","29","29","Jisuna makhoida hairak-i, “Eina nakhoida tasengnamak hairibasini, Tengban Mapu leibakkidamak mayum-makei, nattraga mama-mapa, nattraga machin-manao, nattraga nupi- angang thadoklaga ");
INSERT INTO mni_vpl VALUES ("LK18_30","072_18_30","LUK","18","30","30","mahakna taibangpanda leiringei matamda madudagi saruk yamna henna phangloidaba amasung lakkadaba matam aduda lomba naidaba punsi phangloidaba mi kana amata leite.” ");
INSERT INTO mni_vpl VALUES ("LK18_31","072_18_31","LUK","18","31","31","Adudagi Jisuna tung-inba taranithoi adubu tonganna puthokladuna makhoida hairak-i, “Yengu, eikhoina Jerusalem-da chatli, aduga Migi Machanupa adugi maramda Tengban Mapugi wa phongdokpiba maichousingna irambasing adu thunglagani. ");
INSERT INTO mni_vpl VALUES ("LK18_32","072_18_32","LUK","18","32","32","Mahakpu Jihudi nattaba phurupsinggi makhutta pithokkani. Makhoina mahakpu noknagani, ikaiba pigani amasung tin sitchingani. ");
INSERT INTO mni_vpl VALUES ("LK18_33","072_18_33","LUK","18","33","33","Makhoina mahakpu phugani amasung mahakpu hatkani, aduga humnisuba numitta mahakna amuk hinggatkani.” ");
INSERT INTO mni_vpl VALUES ("LK18_34","072_18_34","LUK","18","34","34","Adubu tung-inbasing aduna hairibasing adu amata khangba ngamlamde. Waheising adugi nunggi oiba wahandok adu makhoida lotlammi amasung Ibungona hairiba adugi maramda makhoina khangba ngamkhide. ");
INSERT INTO mni_vpl VALUES ("LK18_35","072_18_35","LUK","18","35","35","Aduga Jisuna Jericho naksillaklabada mimit tangba nupa ama chakniduna lambi mapanda phamduna leirammi. ");
INSERT INTO mni_vpl VALUES ("LK18_36","072_18_36","LUK","18","36","36","Mahakna miyam amana lambi aduda chatpagi khonjel adu tabada, mahakna kari thoklabage haiduna hanglammi. ");
INSERT INTO mni_vpl VALUES ("LK18_37","072_18_37","LUK","18","37","37","Maduda makhoina mangonda hairak-i, “Nazareth-ki Jisu chatli.” ");
INSERT INTO mni_vpl VALUES ("LK18_38","072_18_38","LUK","18","38","38","Maduda mahakna laoraduna hairak-i, “David-ki Machanupa, Jisu! Eibu chanbiyu!” ");
INSERT INTO mni_vpl VALUES ("LK18_39","072_18_39","LUK","18","39","39","Maduda mang thaduna chatlibasing aduna cheiraduna mahakpu tumin leinanaba hairammi. Adubu mahakna hennadum houna laorak-i, “David-ki Machanupa! Eibu chanbiyu!” ");
INSERT INTO mni_vpl VALUES ("LK18_40","072_18_40","LUK","18","40","40","Maduda Jisuna chatlambadagi lepladuna mahakpu puraknaba yathang pirammi. Aduga mahakna manakta laklabada, Jisuna mangonda hanglak-i, ");
INSERT INTO mni_vpl VALUES ("LK18_41","072_18_41","LUK","18","41","41","“Eina nanggidamak kari toubiba nahakna pambage?” Mahakna khumlak-i, “Oja Ibungo, eihakna mit ujaba pamjei.” ");
INSERT INTO mni_vpl VALUES ("LK18_42","072_18_42","LUK","18","42","42","Maduda Jisuna mangonda hairak-i, “Nahak uba phangjaro, nahakki thajabana nahakpu phahanbire.” ");
INSERT INTO mni_vpl VALUES ("LK18_43","072_18_43","LUK","18","43","43","Khudak adumaktada nuba adu uba phangjare, aduga Tengban Mapubu thagatchaduna Jisugi tung injare. Aduga madu ubada miyam adunasu Tengban Mapubu thagatcharammi. ");
INSERT INTO mni_vpl VALUES ("LK19_1","072_19_1","LUK","19","1","1","Adudagi Jisuna Jericho-da changduna sahar adu phaoduna chatlammi. ");
INSERT INTO mni_vpl VALUES ("LK19_2","072_19_2","LUK","19","2","2","Aduga mapham aduda maiming Zacchaeus kouba kanggat khombasinggi makok oiba inak-khunba nupa ama leirammi. ");
INSERT INTO mni_vpl VALUES ("LK19_3","072_19_3","LUK","19","3","3","Mahakna Jisu kanano haibadu yengnanaba hotnarammmi adubu miyam adugi maramna mahakna Jisubu uba phanglamde. Maramdi mahak marep nemba mi oirammi ");
INSERT INTO mni_vpl VALUES ("LK19_4","072_19_4","LUK","19","4","4","Maram aduna mahakna mang thana chenkhiduna Jisubu unanaba lambi mapanda houba heibong pambi amada kakhatle, maramdi Jisu lambi aduda lakkadourammi. ");
INSERT INTO mni_vpl VALUES ("LK19_5","072_19_5","LUK","19","5","5","Aduga Jisuna mapham adu yourakpa matamda mahakna mathakta yengkhatladuna hairak-i, “Zacchaeus, thuna khumtharak-u, ei ngasi nanggi yumda thungba tare.” ");
INSERT INTO mni_vpl VALUES ("LK19_6","072_19_6","LUK","19","6","6","Adudagi Zacchaeus-na kumtharaktuna Ibungobu yamna haoraobaga loinana taramna okchare. ");
INSERT INTO mni_vpl VALUES ("LK19_7","072_19_7","LUK","19","7","7","Aduga madu uba mi pumnamakna murum murum sonba hourak-i, “Nupa asina pappi asigi yumda thungnanaba chatkhre!” ");
INSERT INTO mni_vpl VALUES ("LK19_8","072_19_8","LUK","19","8","8","Adudagi Zacchaeusna hougatladuna Ibungoda hairak-i, “Yengbiyu, Ibungo, Eina eigi leijaba lan-thumgi saruk tangkhai ama lairabasingda pijagani, aduga eina kanagumbabu kanggat louba matamda minamlabadi eina mangonda senpham adu saruk mari hanbigani.” ");
INSERT INTO mni_vpl VALUES ("LK19_9","072_19_9","LUK","19","9","9","Maduda Jisuna mangonda hairak-i, “Ngasi imung asida aran-khubham lakle, maramdi nupa asina mahak masamak Abrahamgi asengba machani haibadu utchare. ");
INSERT INTO mni_vpl VALUES ("LK19_10","072_19_10","LUK","19","10","10","Maramdi Migi Machanupa adu mangkhraba adubu thinaba amadi kanbinaba lakpani.” ");
INSERT INTO mni_vpl VALUES ("LK19_11","072_19_11","LUK","19","11","11","Miyam aduna Ibungona haibadu taringeida makha tana makhoida pandam amasu hairammi. Maramdi Ibungona Jerusalem naksillaklammi, amasung Tengban Mapugi leibak adu thuna uragani haina makhoina khallammi. ");
INSERT INTO mni_vpl VALUES ("LK19_12","072_19_12","LUK","19","12","12","Maram aduna Ibungona hairak-i, “Kanagumba awangba pham paiba nupa amana ningthou khubam lourunaba aduga amuk halaknaba thourangduna arappa leibak amada chatlammi. ");
INSERT INTO mni_vpl VALUES ("LK19_13","072_19_13","LUK","19","13","13","Mahakna chatringeida mahakki manai tarabu kouraga sanagi senmayek amamam piraduna hairak-i, ‘Eina chatkhringeida masina sel kaya tanba ngambage haibadu yeng-u.’ ");
INSERT INTO mni_vpl VALUES ("LK19_14","072_19_14","LUK","19","14","14","Adubu mahak masamakki misingna mahakpu yengthirammi aduga mahakna eikhoigi ningthou oiba pamde haina haihallunabagidamak mahakki tungda pao pubasing tharammi. ");
INSERT INTO mni_vpl VALUES ("LK19_15","072_19_15","LUK","19","15","15","“Adudagi nupa aduna ningthou phamthol phanglaba matungda mayumda halaklammi. Aduga mahakna sel piramba manaising aduna sel kaya kaya yamna tonglabage haibadu khangnanaba makhoibu manakta kouraknaba yathang pirammi. ");
INSERT INTO mni_vpl VALUES ("LK19_16","072_19_16","LUK","19","16","16","Aduga ahanba manai aduna laktuna hairak-i, ‘Ibungo, eina nahakna piramba sanagi senmayek ama aduna tara tongba ngamjare.’ ");
INSERT INTO mni_vpl VALUES ("LK19_17","072_19_17","LUK","19","17","17","Maduda mabungo aduna hairak-i, ‘Nahakna yamna phajana toure, eigi aphaba inai. Nahakna thabak machada thajaba yabagi maramna sahar taragi mathakta mapu oijaro.’ ");
INSERT INTO mni_vpl VALUES ("LK19_18","072_19_18","LUK","19","18","18","Adudagi anisuba manai adu laktuna hairak-i, ‘Ibungo, eina nahakna piramba sanagi senmayek ama aduna manga tongba ngamjare.’ ");
INSERT INTO mni_vpl VALUES ("LK19_19","072_19_19","LUK","19","19","19","Maduda mabungo aduna hairak-i, ‘Nahaksu sahar mangagi mathakta mapu oijaro.’ ");
INSERT INTO mni_vpl VALUES ("LK19_20","072_19_20","LUK","19","20","20","Aduga atoppa manai ama laktuna hairak-i, ‘Ibungo, yengbiyu, nahakki sanagi senmayek adu asida leijare; eina masibu phi macha amada lottuna thamlambani. ");
INSERT INTO mni_vpl VALUES ("LK19_21","072_19_21","LUK","19","21","21","Maramdi nahak sathiba mi oibanina eina nangbu kijarammi. Nahakna nahakki nattaba adu lou-i aduga hunkhidaba adu lok-i.’ ");
INSERT INTO mni_vpl VALUES ("LK19_22","072_19_22","LUK","19","22","22","Maduda mabungo aduna hairak-i, ‘He phattaba manai! Nahak nasamakki wahei aduna eina nahakpu wayengani. Nahakna eibu eigi nattaba adubu louba aduga eina hunkhidaba adubu lokpa shathiba mini haiba khanglibanine? ");
INSERT INTO mni_vpl VALUES ("LK19_23","072_19_23","LUK","19","23","23","Adu oirabadi karigi nangna sel adu sel tungsinphamda thamlamdribano? Adu oiramlabadi eina halakpada madu sendoiga loinana phanglamgadabani.’ ");
INSERT INTO mni_vpl VALUES ("LK19_24","072_19_24","LUK","19","24","24","Adudagi mahakna leplibasing aduda hairak-i, ‘Minai asidagi sanagi sen mayek adu louthoktuna sanagi senmayek tara leiba mangonda piyu.’ ");
INSERT INTO mni_vpl VALUES ("LK19_25","072_19_25","LUK","19","25","25","Adubu makhoina mangonda hairak-i, ‘Ibungo, mahakki senmayek tara hanna leire.’ ");
INSERT INTO mni_vpl VALUES ("LK19_26","072_19_26","LUK","19","26","26","Maduda mahakna hairak-i. ‘Eina nakhoida hairibasini madudi areiba mi khudingmakta hennadum henna pibigani, aduga leitaba mahak adudagi mahakki areiba khara adu phaoba louthokkani. ");
INSERT INTO mni_vpl VALUES ("LK19_27","072_19_27","LUK","19","27","27","Aduga eina ningthou oiba pamdaba eigi yeknabasing adubu mapham asida puraktuna makhoibu eigi imang asida hatlu.’ ” ");
INSERT INTO mni_vpl VALUES ("LK19_28","072_19_28","LUK","19","28","28","Jisuna wa asi hairaba matungda mang tharaduna Jerusalem maikei panglammi. ");
INSERT INTO mni_vpl VALUES ("LK19_29","072_19_29","LUK","19","29","29","Aduga Ibungona Chorphon Chingda leiba Bethphage amasung Bethany naksillaklabada, tung-inba anibu mangjounana wa asi hairaduna tharammi, ");
INSERT INTO mni_vpl VALUES ("LK19_30","072_19_30","LUK","19","30","30","“Nakhoigi mangda leiriba khun aduda chatlu, aduga nakhoina maduda hek changbaga mi kana amatana tongdriba lola macha ama punduna leiba nakhoina thengnagani. Madu thouri thoktuna eigi nakta purak-u. ");
INSERT INTO mni_vpl VALUES ("LK19_31","072_19_31","LUK","19","31","31","Aduga kanagumbana nakhoida karigi madu thouri thoklibano haina hanglaklabadi, Ibungona masi mathou tai haina mangonda haiyu.” ");
INSERT INTO mni_vpl VALUES ("LK19_32","072_19_32","LUK","19","32","32","Aduga makhoina chatkhiduna Jisuna makhoida haikhiba adumak thengnare. ");
INSERT INTO mni_vpl VALUES ("LK19_33","072_19_33","LUK","19","33","33","Amasung makhoina lola macha adu thouri thoklingeida mapusingna laktuna makhoida hairak-i, “Nakhoina lola macha adugi thouri adu karigi thoklibano?” ");
INSERT INTO mni_vpl VALUES ("LK19_34","072_19_34","LUK","19","34","34","Maduda makhoina khumlak-i, “Ibungona masi mathou tai” ");
INSERT INTO mni_vpl VALUES ("LK19_35","072_19_35","LUK","19","35","35","Aduga makhoina lola macha adu Jisugi nakta purakle. Adudagi makhoina lola adugi mathakta makhoigi maphi thaduna Jisubu tonghalle. ");
INSERT INTO mni_vpl VALUES ("LK19_36","072_19_36","LUK","19","36","36","Amasung Ibungona asum chatlingeida miyam aduna makhoigi maphising lambi aduda tharammi. ");
INSERT INTO mni_vpl VALUES ("LK19_37","072_19_37","LUK","19","37","37","Aduga Ibungona Jerusalem nasillaklabada, chorphon chinggi kumthapham lambi leiriba mapham aduda Ibungogi tung-inba miyam aduna makhoina ukhiba matik leiba thabaksing adugidamak haraona Tengban Mapubu khonjel wangna thagatpa hourak-i: ");
INSERT INTO mni_vpl VALUES ("LK19_38","072_19_38","LUK","19","38","38","“MAPU IBUNGO-gi mingda lenglakliba ningthou adu yaiphabani! Oire swargada ingthaba amadi Tengban Mapuda matik mangal!” ");
INSERT INTO mni_vpl VALUES ("LK19_39","072_19_39","LUK","19","39","39","Adudagi miyam adugi maraktagi pharisee kharana Jisuda hanglak-i, “Oja Ibungo, nahakki tung-inbasing asibu tuminna leinaba cheibiyu!” ");
INSERT INTO mni_vpl VALUES ("LK19_40","072_19_40","LUK","19","40","40","Maduda Jisuna makhoida khumlak-i, “Eina nakhoida hairibasini, karigumba makhoina tuminna leirabasu nungsing asina laorakkani.” ");
INSERT INTO mni_vpl VALUES ("LK19_41","072_19_41","LUK","19","41","41","Adudagi Jisuna sahar adu naksillaklammi amasung mahakna sahar adu ubada sahar adugidamak kapladuna, ");
INSERT INTO mni_vpl VALUES ("LK19_42","072_19_42","LUK","19","42","42","hairak-i, “Numit asida, nahak khaktana oiraba phaoba, ingthabagi lambi adu khanglamlabadiko! Adubu houjikti madu nahakki mityengdagi lotkhre. ");
INSERT INTO mni_vpl VALUES ("LK19_43","072_19_43","LUK","19","43","43","Maramdi Nahakki yeknabasingna nahakki akoibada pal khajingadaba, nahakpu thattuna amasung maikei pumnamaktagi nahakpu koisinduna thamgadaba numitsing adu lakkani. ");
INSERT INTO mni_vpl VALUES ("LK19_44","072_19_44","LUK","19","44","44","Makhoina nahakpu amadi chekpal manungda leiriba nachasing pumnamakpu pummang manghallagani, makhoina nung amaphaoba maphamduda lonnaduna thanamloi. Maramdi Tengban Mapuna nahakpu kanbiba lakkhiba matam adu nahakna khangkhide.” ");
INSERT INTO mni_vpl VALUES ("LK19_45","072_19_45","LUK","19","45","45","Adudagi Jisuna Mapugi Sanglenda changduna lalonbagi thabak touriba masing adubu tanthokpa horammi. ");
INSERT INTO mni_vpl VALUES ("LK19_46","072_19_46","LUK","19","46","46","Ibungona makhoida hairak-i, “Mapugi puyada masi iduna lei, ‘Eigi yumbu haijanabagi yum kougani’ adubu nakhoina masibu huranbasinggi makon oihalle.” ");
INSERT INTO mni_vpl VALUES ("LK19_47","072_19_47","LUK","19","47","47","Numit khudinggi Ibungona Mapugi Sanglenda tambirammi. Adubu athoiba purohitsing, wayen yathanggi ojasing amadi miyamgi luchingbasingna Ibungobu hatnanaba hotnarammi. ");
INSERT INTO mni_vpl VALUES ("LK19_48","072_19_48","LUK","19","48","48","Adumakpu makhoina madu pangthoknaba lambi amata phanglamde, maramdi mi pumnamakna Ibungogi ngangba adu wahei amata phaoba chithadana adumak tadunata leirammi. ");
INSERT INTO mni_vpl VALUES ("LK20_1","072_20_1","LUK","20","1","1","Nongma Mapugi Sanglenda Jisuna miyamda tambiduna amadi aphaba pao sandoktuna leiringeida, athoiba purohit amadi wayen-yathanggi ojasingna ahal lamansingga loinana punna lakladuna, ");
INSERT INTO mni_vpl VALUES ("LK20_2","072_20_2","LUK","20","2","2","Ibungoda hairak-i, “Nahakna kari matik leiduna pumnamaksing asi touribano? Eikhoida haiyu. Kanana nangonda matik adu pibage?” ");
INSERT INTO mni_vpl VALUES ("LK20_3","072_20_3","LUK","20","3","3","Maduda Jisuna makhoida khumlak-i. “Eisu nakhoida wahang ama hangge, nakhoi eingonda khummu, ");
INSERT INTO mni_vpl VALUES ("LK20_4","072_20_4","LUK","20","4","4","John-na baptize toubagi matik adu swargadagira nattraga misingdagira?” ");
INSERT INTO mni_vpl VALUES ("LK20_5","072_20_5","LUK","20","5","5","Maduda makhoina makhoi masel khannaraduna hainarammi, “Eikhoina kari haigadage? Eikhoina swargadagini hairagadi, mahakna eikhoida haigani, ‘Adu oirabadi nakhoina mahakpu karigi thajadribano?’ ");
INSERT INTO mni_vpl VALUES ("LK20_6","072_20_6","LUK","20","6","6","Aduga eikhoina madu misingdagini hairagadi mi pumnamakna eikhoibu nungna thagani, maramdi mi pumnamakna Johnbu Tengban Mapugi wa phongdokpiba maichou amani haina lou-i.” ");
INSERT INTO mni_vpl VALUES ("LK20_7","072_20_7","LUK","20","7","7","Maram aduna makhoina khumlak-i, “Eikhoina madu kadaidagino haiba khangde.” ");
INSERT INTO mni_vpl VALUES ("LK20_8","072_20_8","LUK","20","8","8","Adudagi Jisuna makhoida hairak-i, “Adu oirabadi, eina karamba itik leiduna pumnamaksing asi touribano haibadu einasu hairaroi.” ");
INSERT INTO mni_vpl VALUES ("LK20_9","072_20_9","LUK","20","9","9","Adudagi Jisuna mising aduda amuk onsillaktuna pandam asi hairak-i, “Kanagumba nupa amana anggur ingkhol ama koirammi. Aduga mahakna madu sandoklamlaga mayum thadoktuna arappa lam amada matam kuina chatkhirammi. ");
INSERT INTO mni_vpl VALUES ("LK20_10","072_20_10","LUK","20","10","10","Adudagi anggur mahei lokpa matam youraklabada mahakna mahakki manai amabu anggur ingkhol koibasing adudagi mahakki angur saruk lourunaba tharammi. Adubu makhoina manai adubu phuraga khut hangna halhankhirammi. ");
INSERT INTO mni_vpl VALUES ("LK20_11","072_20_11","LUK","20","11","11","Maram aduna mahakna atoppa manai ama amuk tharammi; adubu mahakpusu phuduna ikaiba piraga khut hangna thakhirammi. ");
INSERT INTO mni_vpl VALUES ("LK20_12","072_20_12","LUK","20","12","12","Adudagi mahakna ahumsuba manai ama amuk tharammi; aduga makhoina mahakpu thina asok-apan nanghanduna mapanda langthoklammi. ");
INSERT INTO mni_vpl VALUES ("LK20_13","072_20_13","LUK","20","13","13","Adudagi anggur ingkholgi mapu aduna mathanta hangjarak-i, ‘Eina houjik kari tousige? Eina eigi nungsijaraba ichanupabu tharage, mahakpudi makhoina ikai khumnabibasu yai.’ ");
INSERT INTO mni_vpl VALUES ("LK20_14","072_20_14","LUK","20","14","14","Adubu ingkhol koibasing aduna mahakpu ubada makhoi masel tanaduna hainarammi, ‘Mahak asi yulep charani. Eikhoina mahakpu hatlasi, adu oirabadi mahakki lan adu eikhoigi oihouragani.’ ");
INSERT INTO mni_vpl VALUES ("LK20_15","072_20_15","LUK","20","15","15","Maram aduna makhoina mahakpu anggur ingkholgi mapanda chingthoklammi aduga mahakpu hatlammi. “Adu oiragadi ingkholgi mapu aduna makhoida houjik kari tougadage? ");
INSERT INTO mni_vpl VALUES ("LK20_16","072_20_16","LUK","20","16","16","Mahakna chattuna ingkhol koibasing adubu hattuna anggur ingkhol adu atoppa ingkhol koibasingda pithokkani.” Hairiba adu tabada, mising aduna hairak-i, “Madu keidounungda oidasanu.” ");
INSERT INTO mni_vpl VALUES ("LK20_17","072_20_17","LUK","20","17","17","Aduga Jisuna makhoida yengladuna hairak-i, “Adu oiragadi Mapugi puyada iduna leiriba wa asigi wahandok adu karino? ‘Yumsabasingna kanadare haiduna langsekpa nung adu, Oirakle khwaidagi maruoiba chithekki nung.’ ");
INSERT INTO mni_vpl VALUES ("LK20_18","072_20_18","LUK","20","18","18","Nung aduda tuba mi khudingmakna machet tana kaigani aduga nung aduna nanba mahak aduna makup tana takkhaigani.” ");
INSERT INTO mni_vpl VALUES ("LK20_19","072_20_19","LUK","20","19","19","Wayen yathanggi ojasing amadi athoiba purohitsingna Ibungobu khudakta phananaba lambi thirammi maramdi pandam adu Ibungona makhoigi mathakta haibani haiba makhoi khanglammi. Adubu makhoina misingbu kirammi. ");
INSERT INTO mni_vpl VALUES ("LK20_20","072_20_20","LUK","20","20","20","Maram aduna makhoina khudongchaba ama yengduna leirammi. Aduga makhoina Ibungogi waheida asoiba thiduna mahakpu phaduna Rome-gi leingak mapugi pangal amadi matikta pithoknanaba pukchel sengba mi sasinnaba lanjabasing tharammi. ");
INSERT INTO mni_vpl VALUES ("LK20_21","072_20_21","LUK","20","21","21","Aduga lanjabasing aduna Jisuda hairak-i, “Oja Ibungo, Nahakti achumba ngangi amasung chumna tambi, aduga nahakna michang mikhai naide adubu Tengban Mapugi lambi adu chumna tambi. ");
INSERT INTO mni_vpl VALUES ("LK20_22","072_20_22","LUK","20","22","22","Eikhoida haibiyu, eikhoina Caesar-da kanggat thiba asi eikhoigi wayel yathanggi maiyoktara, nattabra?” ");
INSERT INTO mni_vpl VALUES ("LK20_23","072_20_23","LUK","20","23","23","Adubu Jisuna makhoigi lounam adu khangladuna makhoida hairak-i, ");
INSERT INTO mni_vpl VALUES ("LK20_24","072_20_24","LUK","20","24","24","“Eingonda denari ama utlu. Yeng-u, masida namliba saktam amasung maming asi kanagino?” Maduda makhoina khumlak-i, “Caesar-gini” ");
INSERT INTO mni_vpl VALUES ("LK20_25","072_20_25","LUK","20","25","25","Adudagi Jisuna makhoida hairak-i, “Phare, adu oirabadi Caesar-gi oiba aduna Caesar-da katlo aduga Tengban Mapugi oiba aduna Tengban Mapuda katlo.” ");
INSERT INTO mni_vpl VALUES ("LK20_26","072_20_26","LUK","20","26","26","Aduga Ibungogi paokhumda asoiba phangdabana miyam mangda makhoina Ibungobu phaba ngamkhide. Amasung makhoina Ibungogi paokhum aduda ingak ngakladuna tuminna leikhi. ");
INSERT INTO mni_vpl VALUES ("LK20_27","072_20_27","LUK","20","27","27","Adudagi sibadagi hinggatpa haibasi leite hairiba sadducee-sing khara Jisugi manakta laktuna hairak-i, ");
INSERT INTO mni_vpl VALUES ("LK20_28","072_20_28","LUK","20","28","28","“Oja Ibungo, Moses-na eikhoigidamak yathang asi ibirammi madudi: ‘Kanagumba nupa amana macha amata thamlamdana magi nupibu thanamlaga sikhiba thoklabadi, hairiba nupa asigi charol-surol thamlamnabagidamak magi machil-manaona lukrabi asibu amuk lougadabani.’ ");
INSERT INTO mni_vpl VALUES ("LK20_29","072_20_29","LUK","20","29","29","Adu oirabadi, nupa amagi machin manao taret leirammi. Adudagi mayamba ahal adu nupi thire adubu macha amata thamamdana sikhre. ");
INSERT INTO mni_vpl VALUES ("LK20_30","072_20_30","LUK","20","30","30","Aduga nupi adu machin-manao anisuba aduna amuk loure, adubu mahaksu macha thamamdana sire. ");
INSERT INTO mni_vpl VALUES ("LK20_31","072_20_31","LUK","20","31","31","Adudagi ahumsuba adunasu mahakpu loure. Matou adugumna makhoi taretmakna loure, aduga macha amata thamamadana sire. ");
INSERT INTO mni_vpl VALUES ("LK20_32","072_20_32","LUK","20","32","32","Aduga ikon konbada nupi adusu sire. ");
INSERT INTO mni_vpl VALUES ("LK20_33","072_20_33","LUK","20","33","33","Adu oirabadi, houjik asibasingna hinggatlakpa numit aduda nupi asi kanagi nupi oigadage, maramdi makhoi taretmakna mahakpu makhoigi nupi oina lourammi.” ");
INSERT INTO mni_vpl VALUES ("LK20_34","072_20_34","LUK","20","34","34","Maduda Jisuna makhoida khumlak-i, “Chak asidadi misingna luhong-i, aduga machasingbu luhongnaba thajei-yonjei. ");
INSERT INTO mni_vpl VALUES ("LK20_35","072_20_35","LUK","20","35","35","Adubu sibadagi hinggatpada amadi lakkadaba matam aduda leibada matik chaba nupa nupising adunadi maduda luhonglaroi. ");
INSERT INTO mni_vpl VALUES ("LK20_36","072_20_36","LUK","20","36","36","Makhoina amuk hanna siraroi, maramdi makhoi swardutsinggum oigani. Makhoi Tengban Mapugi machasing oigani maramdi makhoina sibadagi hinggatle. ");
INSERT INTO mni_vpl VALUES ("LK20_37","072_20_37","LUK","20","37","37","Aduga asiba misingna hinggatli haibadu Mosesmaknasu mayek sengna utkhre. Mei chakpa mongsong yaoba Mapugi Puyagi saruk aduda Moses-na Mapu Ibungoda Abraham-gi Tengban Mapu, Isaac-ki Tengban Mapu, amasung Jacob-ki Tengban Mapu haina koukhi. ");
INSERT INTO mni_vpl VALUES ("LK20_38","072_20_38","LUK","20","38","38","Maram aduna mahakti asibasinggi Tengban Mapu natte adubu ahingbasinggi Tengban Mapuni maramdi mahakki maphamdadi pumnamak hing-i.” ");
INSERT INTO mni_vpl VALUES ("LK20_39","072_20_39","LUK","20","39","39","Maduda wayen-yathanggi oja kharana hairak-i, “Ibungo, nahakna yamna phajana haire” ");
INSERT INTO mni_vpl VALUES ("LK20_40","072_20_40","LUK","20","40","40","Madugi matung mi kana amatana Ibungoda wahang hangnabagi thouna leiramde. ");
INSERT INTO mni_vpl VALUES ("LK20_41","072_20_41","LUK","20","41","41","Adudagi Jisuna makhoida hanglaki, “Makhoina kamdouna Christta adu David-ki machanupani hairibano? ");
INSERT INTO mni_vpl VALUES ("LK20_42","072_20_42","LUK","20","42","42","Maramdi David masamakna Thagat Iseigi lairikta asumna phongdok-i, ‘MAPU IBUNGO-na eigi Ibungoda hai: Phammu, nahakna eigi yet thangbada, ");
INSERT INTO mni_vpl VALUES ("LK20_43","072_20_43","LUK","20","43","43","Oihandriphaoba eina nahakki yeknabasingbu, nahakki khonggi khongnetpham.’ ");
INSERT INTO mni_vpl VALUES ("LK20_44","072_20_44","LUK","20","44","44","David-na mahakpu ‘Ibungo’ haina kourabadi, Kamdouna mahakna David-ki macha oigadouribano?” ");
INSERT INTO mni_vpl VALUES ("LK20_45","072_20_45","LUK","20","45","45","Aduga miyam aduna Ibungogi wa taringeida Ibungona mahakki tung-inbasing aduda hairak-i, ");
INSERT INTO mni_vpl VALUES ("LK20_46","072_20_46","LUK","20","46","46","“Wayel yathanggi ojasing adudagi cheksillu. Makhoina achonba phi settuna koina chatpa amadi keithelnachingba maphamsingda misingna makhoibu ikai khumnabaga loinana koubirakpa adu pammi, Aduga Jihudisinggi tinnapham sanglen synagogue-singda akhannaba phamphamda phamba amadi chak khangphamda ikai khumnaba misinggi phamphamda phamba makhoina pammi. ");
INSERT INTO mni_vpl VALUES ("LK20_47","072_20_47","LUK","20","47","47","Makhoina lukhrabisingdagi khudongchaba louduna mayum-makei mulli, aduga misingna unanaba tousinaduna Tengban Mapuda haijaba adu sangna haijei. Asigumba mising asina henna kanba cheirak phanggani.” ");
INSERT INTO mni_vpl VALUES ("LK21_1","072_21_1","LUK","21","1","1","Jisuna Mapugi Sanglenda koina yengbada inak-khunba misingna Mapugi Sanglengi sel thadaphamda makhoigi khudolsing thadaba urammi. ");
INSERT INTO mni_vpl VALUES ("LK21_2","072_21_2","LUK","21","2","2","Aduga yamna lairabi lukhrabi amanasu apikpa korigi senmayek ani thadaba Ibugona urammi. ");
INSERT INTO mni_vpl VALUES ("LK21_3","072_21_3","LUK","21","3","3","Maduda Ibungona hairak-i, “Eina nakhoida tasengnamak hairibasini, lairabi lukhrabi asina atei pumnamaktagi khwaidagi henna yamna katchare. ");
INSERT INTO mni_vpl VALUES ("LK21_4","072_21_4","LUK","21","4","4","Maramdi ateising aduna makhoigi marang kaiba langeidagi khaidoktuna saruk kharatamak pire; adubu nupi asinadi lairajarabasu mahakki leijaba pumnamak haibadi mahakki hingbada changliba areiba pumba katchare.” ");
INSERT INTO mni_vpl VALUES ("LK21_5","072_21_5","LUK","21","5","5","Aduga ningthiraba nungsingna amadi Tengban Mapuda katlakpa khudolpotsingna kayada phajana leitengliba Mapugi Sanglenno haina Ibungogi tung-inbasing kharana Mapugi Sanglengi maramda wari sanarammi. Adubu Jisuna makhoida hairak-i, ");
INSERT INTO mni_vpl VALUES ("LK21_6","072_21_6","LUK","21","6","6","“Nakhoina uriba pumnamaksing asi pummang manglagadaba matam adu lakli. Matam aduda lonnaba nung amata ningkhaihandana maphamsida thanamloi.” ");
INSERT INTO mni_vpl VALUES ("LK21_7","072_21_7","LUK","21","7","7","Maduda makhoina Jisuda hangjarak-i, “Oja Ibungo, hairibasing adu karamba matamda thokkadage? Aduga pumnamaksing asi thokkadoure haibagi khudamsing aduna karino?” ");
INSERT INTO mni_vpl VALUES ("LK21_8","072_21_8","LUK","21","8","8","Jisuna makhoida hairak-i, “Nakhoibu serannana chingdanaba cheksillu. Maramdi mi kayana eigi mingda laktuna, ‘Ei Christtani’ aduga ‘Matam adu lakle’ haigani. Adubu nakhoina makhoigi matung inganu. ");
INSERT INTO mni_vpl VALUES ("LK21_9","072_21_9","LUK","21","9","9","Aduga nakhoina lan amadi lal houba tarabada kiganu. Maramdi hairibasing asi hanna thokkani adubu aroiba matam adu matam adumaktadi lakloi.” ");
INSERT INTO mni_vpl VALUES ("LK21_10","072_21_10","LUK","21","10","10","Aduga Ibungona makhoida makha tana hairak-i, “Phurup amana phurup amagi mathakta, ningthou leibak amana ningthou leibak amagi mathakta lal hourakkani. ");
INSERT INTO mni_vpl VALUES ("LK21_11","072_21_11","LUK","21","11","11","Aduga mapham kayada akanba yuhar haba, chak tangba amasung sathiba laina kaya thokkani amasung kiningngai oiba thoudoksing amadi atiyada achouba angakpa khudamsing ugani. ");
INSERT INTO mni_vpl VALUES ("LK21_12","072_21_12","LUK","21","12","12","Aduga hairibasing asi thoktringeigi mamangda nakhoibu phagani amasung ot-neigani; nakhoibu wayennabagidamak synagogue-singda pithokkani amasung keisumsangda thamgani. Aduga eigi minggi maramgidamak nakhoibu ningthousinggi amadi leingak mapugi mangda puthokkani. ");
INSERT INTO mni_vpl VALUES ("LK21_13","072_21_13","LUK","21","13","13","Adubu masina nakhoigidamak aphaba wapao sandoknabagi khudongchaba oigani. ");
INSERT INTO mni_vpl VALUES ("LK21_14","072_21_14","LUK","21","14","14","Aduga nakhoina nasabu ngakthokchanaba kari haigadage haina hanna wadanaba napukningda leppu. ");
INSERT INTO mni_vpl VALUES ("LK21_15","072_21_15","LUK","21","15","15","Maramdi nakhoina hairibasing adubu kakthatpa amadi yetpa ngamloidaba wahei amadi lousing eina nakhoida pibigani. ");
INSERT INTO mni_vpl VALUES ("LK21_16","072_21_16","LUK","21","16","16","Aduga nakhoigi nama-napa, nachin-nanao, mari-mata amadi marup-mapangsingna nakhoibu pithokkani. Amasung nakhoi kharabu makhoina hatpa phaoba hatkani. ");
INSERT INTO mni_vpl VALUES ("LK21_17","072_21_17","LUK","21","17","17","Aduga mi pumnamakna nakoibu eigi maramgidamak tukkatchagani. ");
INSERT INTO mni_vpl VALUES ("LK21_18","072_21_18","LUK","21","18","18","Adubu nakhoigi kokki samna ama phaoba mangloi. ");
INSERT INTO mni_vpl VALUES ("LK21_19","072_21_19","LUK","21","19","19","Nakhoina chetna lepchabana nakhoina hingba phangjagani.” ");
INSERT INTO mni_vpl VALUES ("LK21_20","072_21_20","LUK","21","20","20","“Nakhoina Jerusalem-bu lanmisingna koisinba urabadi, sahar adu thuna mang taklagani haiba nakhoina khang-u. ");
INSERT INTO mni_vpl VALUES ("LK21_21","072_21_21","LUK","21","21","21","Adudagi Judea-da leibasing aduna chingjaosingda chensanu; saharda leibasing aduna sahar thadoksanu, aduga leibak adugi mapanda leibasingna leibak aduda amuk changdasanu. ");
INSERT INTO mni_vpl VALUES ("LK21_22","072_21_22","LUK","21","22","22","Maramdi masi Mapugi puyana haikhiba ‘Cheirak Pibagi Numitsing’ adu thungbagi matam aduni. ");
INSERT INTO mni_vpl VALUES ("LK21_23","072_21_23","LUK","21","23","23","Aduga numitsing aduda naopuribising amadi chajellibisinggidamaktadi kayada awaba oiragaba! Maramdi lam asigi mathakta tamthiba awa-anang lakkani amadi lam adugi misinggi mathakta Tengban Mapugi Cheirak lakkani. ");
INSERT INTO mni_vpl VALUES ("LK21_24","072_21_24","LUK","21","24","24","Makhoi kharabu thangsangna hatkani aduga makhoibu leibak pumnamakta lanpha oina pugani. Aduga Jihudi nattaba phurupsinggi matam aduna loidriba phaoba atoppa phurupsingna Jerusalem-bu khongnetnagani.” ");
INSERT INTO mni_vpl VALUES ("LK21_25","072_21_25","LUK","21","25","25","“Matam aduda numit, tha amadi thawanmichaksingda angakpa khudamsing ugani. Aduga malem asida leiriba leibak pumnamakki misingna samudragi iraokhon amadi kallaba ithak-ipomsingda kiduna chamamnaba thokkani. ");
INSERT INTO mni_vpl VALUES ("LK21_26","072_21_26","LUK","21","26","26","Akiba amadi malem asida kari thoklagadage haiba khanbada misingna wanthagani maramdi atiyada leiba panggal pumnamak nikkani. ");
INSERT INTO mni_vpl VALUES ("LK21_27","072_21_27","LUK","21","27","27","Adudagi Migi Machanupa aduna achouba panggal amadi matik mangalga loinana leichilakta lenglakpa adu makhoina ugani. ");
INSERT INTO mni_vpl VALUES ("LK21_28","072_21_28","LUK","21","28","28","Pumnamaksing asina thokpa hourakpada, lepkhattuna na-ngak adu thanggatlu, maramdi nakhoibu handokpibagi matam adu nakle.” ");
INSERT INTO mni_vpl VALUES ("LK21_29","072_21_29","LUK","21","29","29","Adudagi Jisuna makhoida pandam ama hairak-i, “Heiyit pambi amadi atei upalsingda yeng-u. ");
INSERT INTO mni_vpl VALUES ("LK21_30","072_21_30","LUK","21","30","30","Makhoina yening hullakpa matamda nakhoina kalentha naksillakle haiba khang-i. ");
INSERT INTO mni_vpl VALUES ("LK21_31","072_21_31","LUK","21","31","31","Maduga chap manana pumnamaksing asi nakhoina thokpa uba matamda Tengban Mapugi leibak adu naksillakle haiba khang-u. ");
INSERT INTO mni_vpl VALUES ("LK21_32","072_21_32","LUK","21","32","32","“Eina nakhoida tasengnamak hairibasini, miron asina houkhidringeigi mamangda thoudok pumnamaksing asi thokkani. ");
INSERT INTO mni_vpl VALUES ("LK21_33","072_21_33","LUK","21","33","33","Atiya amadi malemdi mangkhigani adubu eigi waheisingdi keidounungda manglaroi. ");
INSERT INTO mni_vpl VALUES ("LK21_34","072_21_34","LUK","21","34","34","“Nakhoi cheksillu! Chaman thakmanbana, yu ngaoba, amadi punsigi oiba langtaknabana nakhoigi thamoibu khudum chalhanganu, nattrabadi Numit aduna langgi matougum khanghoudana nakhoibu phagani. ");
INSERT INTO mni_vpl VALUES ("LK21_35","072_21_35","LUK","21","35","35","Maramdi numitsing aduna malem asida leiriba mipum khudingmakki mathakta lakkani. ");
INSERT INTO mni_vpl VALUES ("LK21_36","072_21_36","LUK","21","36","36","Aduga thokkadouriba pumnamak asida nakhoina nanthokchaba ngamnanaba amadi Migi Machanupa adugi mangda lepchaba ngamnanaba nakhoina mitseng khangduna amadi matam pumnamakta haijaduna leiyu.” ");
INSERT INTO mni_vpl VALUES ("LK21_37","072_21_37","LUK","21","37","37","Jisuna nungti numit khudinggi Mapugi Sanglenda tambirammi aduga numidang lakpa khudingda Chorphon Chingda ahing lennanaba chatlammi. ");
INSERT INTO mni_vpl VALUES ("LK21_38","072_21_38","LUK","21","38","38","Aduga Ibungogi wa tananabagidamak ayuk anganba khudingda miyam pumnamakna Mapugi Sanglenda laklammi. ");
INSERT INTO mni_vpl VALUES ("LK22_1","072_22_1","LUK","22","1","1","Matamdu Lanthokpibagi Chakkhangba haina kouba Hamei yaodaba talgi chakkhangba kumheigi matam naksillaklammi. ");
INSERT INTO mni_vpl VALUES ("LK22_2","072_22_2","LUK","22","2","2","Aduga athoiba purohitsing amadi wayel yathanggi ojasingna Jisubu hatnanaba aronba lambi thirammi; maramdi makhoina Jisubu phongna phaba matamda misingna kari tourakkadage haina misingbu kirammi. ");
INSERT INTO mni_vpl VALUES ("LK22_3","072_22_3","LUK","22","3","3","Adudagi tung-inba taranithoigi maraktagi ama oiriba Judas Iscariotta Satan-na changlammi. ");
INSERT INTO mni_vpl VALUES ("LK22_4","072_22_4","LUK","22","4","4","Maram aduna Judas-na chatkhiduna athoiba purohitsing amadi Mapugi Sanglen ngakliba luchingbasingga karamna mahakna Jisubu makhoida pithokkadage haina hairammi. ");
INSERT INTO mni_vpl VALUES ("LK22_5","072_22_5","LUK","22","5","5","Maduda makhoi haraorammi amasung makhoina mangonda sel pibada yanarammi. ");
INSERT INTO mni_vpl VALUES ("LK22_6","072_22_6","LUK","22","6","6","Aduga Judas-na maduda yarammi amasung miyam leitaba matamda Jisubu makhoida pithoknaba khudongchaba yengduna leirammi. ");
INSERT INTO mni_vpl VALUES ("LK22_7","072_22_7","LUK","22","7","7","Adudagi Lanthokpibagi Chakhanggi yao macha adu hatkadaba numit haibadi Hamei yaodaba Talgi chakkhangba numit adu lakle. ");
INSERT INTO mni_vpl VALUES ("LK22_8","072_22_8","LUK","22","8","8","Maduda Ibungona Peter amadi John-bu mangjounana tharaduna hairak-i, “Nakhoina chattuna eikhoina chananaba Lanthokpibagi chaklen thourang tou.” ");
INSERT INTO mni_vpl VALUES ("LK22_9","072_22_9","LUK","22","9","9","Maduda makhoina Ibungoda hanglak-i, “Eikhoina mapham kadaida chaklen adu thourang touba Ibungona pambibage?” ");
INSERT INTO mni_vpl VALUES ("LK22_10","072_22_10","LUK","22","10","10","Ibungona khumlak-i, “Nakhoina sahar aduda hek changbaga ising pun puba nupa ama nakhoina thengnagani. Nakhoina mahakna changba yum adu phaoba matung induna chatlu. ");
INSERT INTO mni_vpl VALUES ("LK22_11","072_22_11","LUK","22","11","11","Aduga yum adugi yumbu aduda asumna haiyu, ‘Eina eihakki tung-inbasinga loinana Lanthokpibagi chaklen chagadaba ka adu kadaidano?’ haina Oja Ibungona naphamda hanglak-i. ");
INSERT INTO mni_vpl VALUES ("LK22_12","072_22_12","LUK","22","12","12","Aduga mahakna, sem-saduna thourang pumnamak loiraba, chaoraba mathakki ka ama nakhoida utlakkani. Maphamduda eikhoigidamak chaklen thourang tou.” ");
INSERT INTO mni_vpl VALUES ("LK22_13","072_22_13","LUK","22","13","13","Adudagi makhoina sahar aduda chatkhirammi aduga Jisuna makhoida haikhibagumna pumnamak adu phangladuna makhoina mapham aduda Lanthokpibagi Chaklen thourang toure. ");
INSERT INTO mni_vpl VALUES ("LK22_14","072_22_14","LUK","22","14","14","Aduga pungpham aduna laklabada Jisuna pakhonchatpa taranithoi aduga loinana chananaba phamtharammi. ");
INSERT INTO mni_vpl VALUES ("LK22_15","072_22_15","LUK","22","15","15","Aduga Ibungona makhoida hairak-i, “Eina awa ana khangdringeigi mamangda eina nakhoiga loinana Lanthokpibagi chaklen asi chaminnaba adukki matik pamkhi. ");
INSERT INTO mni_vpl VALUES ("LK22_16","072_22_16","LUK","22","16","16","Maramdi eina nakhoida hairibasini, madudi Tengban Mapugi Leibakta Lanthokpibagi Chakkhangba asigi mapungphaba wahanthok adu thungdriba phaoba eina masi amuk hanna chararoi.” ");
INSERT INTO mni_vpl VALUES ("LK22_17","072_22_17","LUK","22","17","17","Adudagi mahakna tenggot adu louraduna Tengban Mapubu thagatcharaga asumna hairak-i, “Masi louduna nakhoigi narakta lannou. ");
INSERT INTO mni_vpl VALUES ("LK22_18","072_22_18","LUK","22","18","18","Eina nakhoida hairibasini, Tengban Mapugi Ningthou Leibak aduna laktriba phaoba eina anggur mahi asi amuk hanna thaklaroi.” ");
INSERT INTO mni_vpl VALUES ("LK22_19","072_22_19","LUK","22","19","19","Adudagi Jisuna tal ama louduna Tengban Mapubu thagatcharaga machet machet settuna makhoida piraga hairak-i, “Masi nakhoigidamak pithoklaba eigi hakchangni. Eibu ningsingnabagidak nakhoina masi pangthok-u.” ");
INSERT INTO mni_vpl VALUES ("LK22_20","072_22_20","LUK","22","20","20","Aduga madu chaba loiraba matungda, maduga chap manana Ibungona tenggot adu louraduna hairak-i, “Tengot asi nakhoigidamak tabikhraba eigi eena chum namlaba Tengban Mapugi anouba warepnabani. ");
INSERT INTO mni_vpl VALUES ("LK22_21","072_22_21","LUK","22","21","21","“Adubu, yengu! Eibu pithokkadouriba mahak adu eiga loinana table asida leiminnari. ");
INSERT INTO mni_vpl VALUES ("LK22_22","072_22_22","LUK","22","22","22","Aduga Migi Machanupa aduna Tengban Mapuna mahakkidamak warepkhraba adugi matung-inna sigani adubu eibu pithokkadouriba mahak adudi awabanida!” ");
INSERT INTO mni_vpl VALUES ("LK22_23","072_22_23","LUK","22","23","23","Maduda, makhoigi marakta thabak asi tougadouriba mahak adu kana oigadouribano haiduna makhoi masel hangnaba hourammi. ");
INSERT INTO mni_vpl VALUES ("LK22_24","072_22_24","LUK","22","24","24","Aduga makhoigi marakta kanana khwaidagi henna chaobage haiduna yetnarammi. ");
INSERT INTO mni_vpl VALUES ("LK22_25","072_22_25","LUK","22","25","25","Maduda Jisuna makhoida hairak-i, “Atoppa phurupsingi ningthousingna makhoigi leibak miyamgi mathakta mapu oina palli, aduga makhoigi mathakta matik leiribasing aduna masana masabu Miyamgidamak khanbasing haina koujei. ");
INSERT INTO mni_vpl VALUES ("LK22_26","072_22_26","LUK","22","26","26","Adubu nakhoidi asumna oidasanu. Madugi mahutta nakhoigi marakta khwaidagi chaoba mahak aduna khwaidagi tonba oisanu aduga luchingba mahak aduna thougal touba mi oisanu. ");
INSERT INTO mni_vpl VALUES ("LK22_27","072_22_27","LUK","22","27","27","Maramdi chananabagidamak tableda phamliba mahak aduga thougal touriba mahak aduga kanana henna chaobage? Tableda phamliba mahak adu nattra? Adubu nakhoigi narakta eina thougal touba mi ama oina leiri. ");
INSERT INTO mni_vpl VALUES ("LK22_28","072_22_28","LUK","22","28","28","“Nakhoidi eibu changyengba khudingmakta eiga loinana lepminnakhrabasingni. ");
INSERT INTO mni_vpl VALUES ("LK22_29","072_22_29","LUK","22","29","29","Aduga Eigi Ipana eingonda leingaknaba matik pibiba adugumna einasu nakhoida chap manaba matik adumak pibigani. ");
INSERT INTO mni_vpl VALUES ("LK22_30","072_22_30","LUK","22","30","30","Nakhoina eigi Leibak aduda eigi tableda chagani amasung thakkani, aduga Israel-gi salai taranithoigi mathakta pannanaba phambanda phamgani. ");
INSERT INTO mni_vpl VALUES ("LK22_31","072_22_31","LUK","22","31","31","“Simon, Simon! Yengngu! Satan-na nakhoibu gehudagi maham humdokpagumna humnaba, nakhoi pumnamakpu changyengnaba ayaba phangkhre. ");
INSERT INTO mni_vpl VALUES ("LK22_32","072_22_32","LUK","22","32","32","Adubu Simon, nahakki thajaba adu mangdanaba eina nahakkidamak haijare. Aduga nahakna eingonda amuk halakpa matamda nahakna nahakki nachin-nanaosingbu pangal kankhathallak-u.” ");
INSERT INTO mni_vpl VALUES ("LK22_33","072_22_33","LUK","22","33","33","Maduda Peter-na khumlak-i, “Ibungo, Eihakna nahakka loinana keisumsangdabu oirabasu nattraga siba tarabasu chatnanaba sem sajare.” ");
INSERT INTO mni_vpl VALUES ("LK22_34","072_22_34","LUK","22","34","34","Adubu Jisuna hairak-i, “Peter, eina nangonda hairi, ngasi nahakna eibu masak khangde haina ahumlak haidriba phaoba yenbarabana khongloi.” ");
INSERT INTO mni_vpl VALUES ("LK22_35","072_22_35","LUK","22","35","35","Adudagi Jisuna tung-inbasing aduda hairak-i, “Eina nakhoibu sengao, khao, aduga sandal yaodana thaba matamda nakhoigi karigumba awatpa leikhibra?” Maduda makhoina haikhi, “Kari amata leikhide.” ");
INSERT INTO mni_vpl VALUES ("LK22_36","072_22_36","LUK","22","36","36","Jisuna makhoida hairak-i, “Adubu houjikti sengao amadi khao leiba mahak aduna madu pusanu; aduga thangsang leitaba mahak aduna maphi yonduna thangsang leisanu. ");
INSERT INTO mni_vpl VALUES ("LK22_37","072_22_37","LUK","22","37","37","Maramdi eina nakhoida hairi madudi Mapugi Puyada, ‘Aduga mahak ayon-aran toubasinggi marakta masing challe’ haina phongdokpiramaba adu eingonda thunglaba tare. Maramdi eigi maramda irambasing adu thunglare.” ");
INSERT INTO mni_vpl VALUES ("LK22_38","072_22_38","LUK","22","38","38","Maduda tung-inbasingduna hairak-i, “Yengbiyu Ibungo, Mapham asida thangsang ani leire.” Aduga Ibungona makhoida hairak-i, “Maduna okle.” ");
INSERT INTO mni_vpl VALUES ("LK22_39","072_22_39","LUK","22","39","39","Adudagi Jisuna sahar adu thadoktuna mahousagumna Chorphon Chingda chatlammi amasung mahakki tung-inbasingsu mahakki matung illammi. ");
INSERT INTO mni_vpl VALUES ("LK22_40","072_22_40","LUK","22","40","40","Ibungona mapham adu yourabada mahakna makhoida hairak-i, “Nakhoina athembada tadanaba haijou.” ");
INSERT INTO mni_vpl VALUES ("LK22_41","072_22_41","LUK","22","41","41","Adudagi mahakna makhoidagi nungna hunbamuk lappa maphamda chatthoklaga khuru-khudak kunduna haijare, ");
INSERT INTO mni_vpl VALUES ("LK22_42","072_22_42","LUK","22","42","42","“Ipa, nahakna yabirabadi, awa-anagi tenggot asi eingondagi louthokpiyu. Adumakpu eihakki aningba oidaduna nahakki aningba adumak toubiyu.” ");
INSERT INTO mni_vpl VALUES ("LK22_43","072_22_43","LUK","22","43","43","Adudagi swargadagi dut ama thoraktuna Ibungobu kanhathanbirammi. ");
INSERT INTO mni_vpl VALUES ("LK22_44","072_22_44","LUK","22","44","44","Aduga pukning wakhal wamankhibana, Ibungona henna pukning hakchang yaona haijarammi; amasung mahakki humang adu ee marikna leimaida tabagumna tarammi. ");
INSERT INTO mni_vpl VALUES ("LK22_45","072_22_45","LUK","22","45","45","Adudagi Ibungona haijarambadagi hougattuna tunginbasinggi manakta halakpada, tung-inbasing adu pukning wamanbana tumduna leiramba thengnare. ");
INSERT INTO mni_vpl VALUES ("LK22_46","072_22_46","LUK","22","46","46","Maduda Ibungona makhoida hairak-i, “Nakhoi tumduna leiriba karigino? Hougatlu aduga nakhoina athembada tadanaba haijou.” ");
INSERT INTO mni_vpl VALUES ("LK22_47","072_22_47","LUK","22","47","47","Amasung Jisuna wa nganglingeida, Yengu, tung-inba taranithoigi manungda ama oiriba Judasna chingduna miyam ama tunglare. Aduga Judasna Ibungobu chupnanaba manakta changsillammi. ");
INSERT INTO mni_vpl VALUES ("LK22_48","072_22_48","LUK","22","48","48","Maduda Jisuna hairak-i, “Judas, nahakna Migi Machanupa adubu chuptuna pithoklibra?” ");
INSERT INTO mni_vpl VALUES ("LK22_49","072_22_49","LUK","22","49","49","Jisuga loinariba tung-inbasingduna thokkadouriba adu ubada hairak-i, “Ibungo, eikhoina eikhoigi thangsang asi sijinnarasira?” ");
INSERT INTO mni_vpl VALUES ("LK22_50","072_22_50","LUK","22","50","50","Aduga makhoigi maraktagi amana Purohitlengi minai adubu thangna yanduna yetthangba mana adu kakthatle. ");
INSERT INTO mni_vpl VALUES ("LK22_51","072_22_51","LUK","22","51","51","Adubu Jisuna makhoida hairak-i, “Masina yare, okle.” Adudagi Ibungona nupa adugi mana adu sokladuna phahanbire. ");
INSERT INTO mni_vpl VALUES ("LK22_52","072_22_52","LUK","22","52","52","Adudagi Jisuna mahakpu phaba lakliba athoiba purohitsing, Mapugi Sanglen ngakpa loisanggi phamnaibasing, aduga ahal-lamansing aduda Jisuna hairak-i, “Nakhoina eihakpu leibakki wayel pathap thugaiba tamthiba mi ama phagadoubagumna thangsang amadi cheitup paiduna laklibra? ");
INSERT INTO mni_vpl VALUES ("LK22_53","072_22_53","LUK","22","53","53","Eina nakhoiga loinana Mapugi Sanglenda numit khudinggi leiminnarammi aduga nakhoina eibu phakhide. Adubu amambagi panggalna panba pungpham asi nakhoigi pungphamni.” ");
INSERT INTO mni_vpl VALUES ("LK22_54","072_22_54","LUK","22","54","54","Adudagi makhoina Ibungobu pharaduna puthoraklaga Purohitlengi yumda purakle aduga Peter-na laptakna makhoigi tung illaklammi. ");
INSERT INTO mni_vpl VALUES ("LK22_55","072_22_55","LUK","22","55","55","Sumang adugi mayaida makhoina mei hougatladuna madugi akoibada phamlammi. Aduga makhoising adugi marakta Peter-su yaosillammi. ");
INSERT INTO mni_vpl VALUES ("LK22_56","072_22_56","LUK","22","56","56","Peter-na mapham aduda phamba adu kanagumbi minai leisabi amana uraduna mangonda munna yengladuna hairak-i, “Nupa asisu Jisuga loinarambani.” ");
INSERT INTO mni_vpl VALUES ("LK22_57","072_22_57","LUK","22","57","57","Adubu Peterna maduda yaramde amasung mahakna hairak-i, “Nupi, eina mahakpu masakphaoba khangde.” ");
INSERT INTO mni_vpl VALUES ("LK22_58","072_22_58","LUK","22","58","58","Ngaihak leiraba matungda nupa amanasu mahakpu amuk uraduna hairak-i, “Nahaksu makhoigi marakta amani.” Adubu Peterna khumlak-i, “Natte Nupa, ei natte.” ");
INSERT INTO mni_vpl VALUES ("LK22_59","072_22_59","LUK","22","59","59","Pung amamuk leiraba matungda atoppa nupa amanasu yamna kanna takladuna hairak-i, “Tasengnamak nupa asi Jisuga loinarambani, maramdi mahaksu Galilee-gi mini.” ");
INSERT INTO mni_vpl VALUES ("LK22_60","072_22_60","LUK","22","60","60","Adubu Peter-na khumlak-i, “Nupa, nahakna hairibadu karino ei khangde.” Khudak aduda Peterna wa nganglingei maktada yenbarabana khonglaklammi. ");
INSERT INTO mni_vpl VALUES ("LK22_61","072_22_61","LUK","22","61","61","Matam adumaktada Ibungona leithoraktuna Peterda yenglaklammi, aduga Peterna Ibungona mangonda haikhiba “Ngasi nahakna eibu masak khangde haina ahumlak yadriba phaoba yenbarabana khongloi” haibadu ningsinglaklammi. ");
INSERT INTO mni_vpl VALUES ("LK22_62","072_22_62","LUK","22","62","62","Adudagi Peterna mapanda thokkhraga thamoi sokna kapkhi. ");
INSERT INTO mni_vpl VALUES ("LK22_63","072_22_63","LUK","22","63","63","Adudagi Jisubu sennariba mising aduna mahakpu noknarammi amasung phubirammi. ");
INSERT INTO mni_vpl VALUES ("LK22_64","072_22_64","LUK","22","64","64","Makhoina Ibungobu mamit punsinduna mamaida phuraduna, “Nahakpu kanana phubano? Phongdok-u” haiduna hanglammi. ");
INSERT INTO mni_vpl VALUES ("LK22_65","072_22_65","LUK","22","65","65","Aduga makhoina atoppa athiba wa kaya amasu nganglammi. ");
INSERT INTO mni_vpl VALUES ("LK22_66","072_22_66","LUK","22","66","66","Nong hek nganbaga athoiba purohitsing amadi Wayel-Yathanggi ojasing yaona leibakki ahal-laman punna tinnare. Aduga Jisubu makhoigi Sanhedrin-gi mangda puthokladuna, ");
INSERT INTO mni_vpl VALUES ("LK22_67","072_22_67","LUK","22","67","67","Makhoina hairak-i, “Nahak Christta adura? Eikhoida haiyu.” Maduda Jisuna makhoida khumlak-i, “Eina nakhoida hairabasu nakhoina eibu thajaroi. ");
INSERT INTO mni_vpl VALUES ("LK22_68","072_22_68","LUK","22","68","68","Aduga eina nakhoida wahang ama hanglabasu nakhoina paokhum pirakloi. ");
INSERT INTO mni_vpl VALUES ("LK22_69","072_22_69","LUK","22","69","69","Adubu houjiktagi houduna Migi Machanupa aduna matik leiba Tengban Mapugi yet thangbada phamgani.” ");
INSERT INTO mni_vpl VALUES ("LK22_70","072_22_70","LUK","22","70","70","Maduda makhoi pumnamakna hanglak-i, “Adu oirabadi nahak Tengban Mapugi Machanupa adura?” Ibungona makhoida khumlak-i, “Eini haibadu nakhoina haire.” ");
INSERT INTO mni_vpl VALUES ("LK22_71","072_22_71","LUK","22","71","71","Adudagi makhoina hairak-i, “Eikhoina atei sakhi ama amuk karigi mathou taribage! Maramdi eikhoi isamakna madu mahakki machinmaktagi tare.” ");
INSERT INTO mni_vpl VALUES ("LK23_1","072_23_1","LUK","23","1","1","Adudagi miyam apumba aduna hougattuna Jisubu Pilate-ki mamangda purakle. ");
INSERT INTO mni_vpl VALUES ("LK23_2","072_23_2","LUK","23","2","2","Aduga makhoina Ibungobu maran siba houraduna hairak-i, “Nupa asina leibak miyambu lanna lamjingle. Mahakna miyamda Caesar-da kanggat thidanaba hai aduga masana masabu Christta ningthouni haijei.” ");
INSERT INTO mni_vpl VALUES ("LK23_3","072_23_3","LUK","23","3","3","Maduda Pilate-na Ibungoda hanglak-i, “Nahak Jihudigi ningthou adura?” Jisuna khumlak-i, “Nahakna hairiba aduni.” ");
INSERT INTO mni_vpl VALUES ("LK23_4","072_23_4","LUK","23","4","4","Adudagi Pilatena athoiba purohitsing amadi miyam aduda hairak-i, “Eina nupa asida maral amata phangde.” ");
INSERT INTO mni_vpl VALUES ("LK23_5","072_23_5","LUK","23","5","5","Adubu makhoina henna kanna taksinduna hairak-i, “Galilee-dagi houduna Jerusalem phaoba, Judea sinba-thungna mahakna tambiduna miyam marakta irang sagatli.” ");
INSERT INTO mni_vpl VALUES ("LK23_6","072_23_6","LUK","23","6","6","Madu tabada Pilate-na mangonda hanglak-i, “Mahak asi Galileegi mira?” ");
INSERT INTO mni_vpl VALUES ("LK23_7","072_23_7","LUK","23","7","7","Makhoina Jisubu Galilee-gi mini hairabada Pilate-na mahakpu Herod-ki manakta tharammi maramdi Galilee asi Herod-ki leingak makhada leirammi. Matam aduda Herod masamaksu Jerusalem-da leirammi. ");
INSERT INTO mni_vpl VALUES ("LK23_8","072_23_8","LUK","23","8","8","Herodna Jisubu uba matamda yamna haraojarammi, maramdi mahakna Ibungogi maramda pao tarammi amasung matam kuinadagi Ibungobu uba pamlammi. Aduga Jisuna angakpa thabak touba khara mahakna ujagani haina asha tourammi. ");
INSERT INTO mni_vpl VALUES ("LK23_9","072_23_9","LUK","23","9","9","Maram aduna Herodna Jisuda wahang kaya ama hanglammi adubu Ibungona mangonda paokhum amata pikhide. ");
INSERT INTO mni_vpl VALUES ("LK23_10","072_23_10","LUK","23","10","10","Aduga athoiba purohitsing amadi Wayen Yathanggi ojasingna lepkhattuna Ibungoda akanba maral sirammi. ");
INSERT INTO mni_vpl VALUES ("LK23_11","072_23_11","LUK","23","11","11","Adudagi Herod amadi mahakki lanmisingna Jisubu noknarammi amasung karemnarammi. Aduga Ibungobu phajaba phijol ama setpiduna Pilate-ki manakta amuk hanna thakhirammi. ");
INSERT INTO mni_vpl VALUES ("LK23_12","072_23_12","LUK","23","12","12","Numit adumaktada Herod amadi Pilate marup oikhi, madugi mamangda makhoi ani yeknarammi. ");
INSERT INTO mni_vpl VALUES ("LK23_13","072_23_13","LUK","23","13","13","Adudagi Pilate-na athoiba purohitsing, luchingbasing, amadi misingbu punna kouraduna, ");
INSERT INTO mni_vpl VALUES ("LK23_14","072_23_14","LUK","23","14","14","Makhoida hairak-i, “Nakhoina nupa asibu eigi inakta puraktuna misingbu lanna lamjingngi hairi. Aduga yengngu, eina nakhoigi namangmaktada mahakpu wahang paohang toure, adubu nakhoina mangonda siriba maral asigi maramda maral amata phangdre. ");
INSERT INTO mni_vpl VALUES ("LK23_15","072_23_15","LUK","23","15","15","Aduga Herodnasu mahakki maral amata phangdre maramdi mahakna nupa asibu eikhoida amuk hanna tharakle. Mahakna sibagi cheirak phangba yaba karigumba thabak amatasu toukhide. ");
INSERT INTO mni_vpl VALUES ("LK23_16","072_23_16","LUK","23","16","16","Maram aduna eina mahakpu cheirak khara piraga thadoklagani.” ");
INSERT INTO mni_vpl VALUES ("LK23_17","072_23_17","LUK","23","17","17","Maramdi Chakkhangba kummei khudinggi miyamgidamak Pilatena phadok amabu thadokpa tarammi. ");
INSERT INTO mni_vpl VALUES ("LK23_18","072_23_18","LUK","23","18","18","Adubu miyam apumba aduna laorak-i, “Mahakpu hatlu! Aduga Barabbaspu eikhoigidamak thadok-u!” ");
INSERT INTO mni_vpl VALUES ("LK23_19","072_23_19","LUK","23","19","19","(Barabbas asi sahar aduda leibak irang thokhanbada saruk yabagi amadi mi hatlubagidamak keisumsangda thambani.) ");
INSERT INTO mni_vpl VALUES ("LK23_20","072_23_20","LUK","23","20","20","Aduga Pilate-na Jisubu thadokningduna miyam aduda amukka hanna hairammi. ");
INSERT INTO mni_vpl VALUES ("LK23_21","072_23_21","LUK","23","21","21","Adubu makhoina, “Cross-ta hatlu! Cross-ta hatlu!” haiduna laoduna leirammi. ");
INSERT INTO mni_vpl VALUES ("LK23_22","072_23_22","LUK","23","22","22","Ahumlaksuba oina Pilatena makhoida hairammi, “Karigi mahakpu hatkadouribano? Mahakna kari phataba toukhrabage? Eina mangondagi sibagi cheirak piba yaba maran amata phangde. Maram aduna eina mahakpu cheirak khara piraga thadoklagani.” ");
INSERT INTO mni_vpl VALUES ("LK23_23","072_23_23","LUK","23","23","23","Adubu makhoina houna lao-laoduna Ibungobu crossta pang tingduna hatnanaba taksillammi, aduga makhoigi khonjel aduna ngamkhirammi. ");
INSERT INTO mni_vpl VALUES ("LK23_24","072_23_24","LUK","23","24","24","Maram aduna Pilate-na makhoigi apamba adu pinanaba Jisubu hatnanaba laothoklammi. ");
INSERT INTO mni_vpl VALUES ("LK23_25","072_23_25","LUK","23","25","25","Aduga mahakna makhoina thadoknaba nijaba, leibak irang thokhanba amadi mi hatpagidamak keisumsangda thamliba Barabaspu thadoklaga makhoigi apambagi matunginna Jisubu makhoigi makhutta pithoklammi. ");
INSERT INTO mni_vpl VALUES ("LK23_26","072_23_26","LUK","23","26","26","Adudagi lanmisingna Jisubu puthokkhibada khunggangdagi sahar aduda changlakpa Cyrene-gi Simon-ga thengnare. Aduga makhoina mahakpu phaduna cross adu thonggatlaga Jisugi matung innaduna puhallammi. ");
INSERT INTO mni_vpl VALUES ("LK23_27","072_23_27","LUK","23","27","27","Aduga Ibungogidamak kaplibi amadi tengtharibi nupising yaona yamlaba miyam amana Ibungogi matung illammi. ");
INSERT INTO mni_vpl VALUES ("LK23_28","072_23_28","LUK","23","28","28","Adubu Jisuna makhoida onsilladuna hairak-i, “Jerusalemgi machanupising! Eihakkidamak kapkanu; adubu nakhoi nasagidamak amadi nachasinggidamak kappu. ");
INSERT INTO mni_vpl VALUES ("LK23_29","072_23_29","LUK","23","29","29","Maramdi ‘Chaboktabising, naopudabi nupising amadi khom-indabi nupising adu yaiphabini’ haigadaba matam adu lakli. ");
INSERT INTO mni_vpl VALUES ("LK23_30","072_23_30","LUK","23","30","30","Matam aduda misingna chingjaosingda haigani, ‘Eikhoigi ithakta tasinbiro’ aduga makhoina chingsingda haigani, ‘Eikhoibu kupsinbiro.’ ");
INSERT INTO mni_vpl VALUES ("LK23_31","072_23_31","LUK","23","31","31","Asangba upalda misingna asigumna touragadi akangba upaldadi kari thokkadage?” ");
INSERT INTO mni_vpl VALUES ("LK23_32","072_23_32","LUK","23","32","32","Aduga wayel thugaiba nupa ani amasu Ibungoga loinana hatnanaba puthoklammi. ");
INSERT INTO mni_vpl VALUES ("LK23_33","072_23_33","LUK","23","33","33","Aduga makhoina “Kokki saru akangba” kouba mapham aduda laklabada makhoina Ibungobu amadi phattaba touba makhoi anibu amana Ibungogi yetta amana oida crossta pang tingkhi. ");
INSERT INTO mni_vpl VALUES ("LK23_34","072_23_34","LUK","23","34","34","Adudagi Jisuna hairak-i, “Ipa, makhoibu kokpiyu, maramdi makhoina kari touribano haibadu makhoina khangjade.” Aduga lanmising aduna Ibungogi phironsing adubu laibak chang yengnaduna yennarammi. ");
INSERT INTO mni_vpl VALUES ("LK23_35","072_23_35","LUK","23","35","35","Miyam aduna leptuna yenglammi amasung Jihudigi luchingbasing aduna Ibungoda keramnarammi. Makhoina hairak-i, “Mahakna atoppa misingbudi kanbikhi. Mahak asi Tengban Mapuna khandoklaba, Christa adu oirabadi mahak masasu kanjasanu.” ");
INSERT INTO mni_vpl VALUES ("LK23_36","072_23_36","LUK","23","36","36","Aduga lanmising adusu laktuna Ibungobu noknarammi. Makhoina Ibungoda asinba yu piraduna, ");
INSERT INTO mni_vpl VALUES ("LK23_37","072_23_37","LUK","23","37","37","hairak-i, “Nahakna Jihudigi ningthou oirabadi nasamakpu kanjou.” ");
INSERT INTO mni_vpl VALUES ("LK23_38","072_23_38","LUK","23","38","38","Amasung Ibungogi kokthaklomda “Masi Jihudigi ningthouni” haina Greek, Latin amadi Hebrew londa iba ayiba ama thetlammi. ");
INSERT INTO mni_vpl VALUES ("LK23_39","072_23_39","LUK","23","39","39","Aduga Ibungogi nakanda yalliba phattaba toubasing adugi maraktagi amana Ibungobu thina ngangladuna hairak-i, “Nahakna Christa oirabadi nasabusu amadi eikhoibusu kallu.” ");
INSERT INTO mni_vpl VALUES ("LK23_40","072_23_40","LUK","23","40","40","Adubu atoppa phattaba touba ama aduna mahakpu cheiraduna hairak-i, “Nahak Tengban Mapubu kidabara? Mahakna phangba cheirak adumak nahaknasu chap manana phangli. ");
INSERT INTO mni_vpl VALUES ("LK23_41","072_23_41","LUK","23","41","41","Adumakpu eikhoinadi achumba cheirak adu phangli maramdi eikhoina toujaruba thabakki phangbada matik chaba adu eikhoina phangjari. Adubu nupa asinadi aranba kari amata toukhide.” ");
INSERT INTO mni_vpl VALUES ("LK23_42","072_23_42","LUK","23","42","42","Aduga mahakna Jisuda hairak-i, “Jisu, nahakna nahakki ningthou leibak changbada eibu ningsingbiyu.” ");
INSERT INTO mni_vpl VALUES ("LK23_43","072_23_43","LUK","23","43","43","Maduda Jisuna mangonda hairak-i, “Eina nangonda tasengnamak hairibasini, ngasi nahakna eiga loinana Paradise-ta leiminnagani.” ");
INSERT INTO mni_vpl VALUES ("LK23_44","072_23_44","LUK","23","44","44","Matam adu chaorakna pung taranithoimuk tarammi. Aduga amambana lam adu sinba tungna pung ahum taba phaoba kupsillammi, ");
INSERT INTO mni_vpl VALUES ("LK23_45","072_23_45","LUK","23","45","45","maramdi numitki mangal mangkhirammi. Aduga Mapugi Sanglen-gi maikhanphi adu anithokna segairammi. ");
INSERT INTO mni_vpl VALUES ("LK23_46","072_23_46","LUK","23","46","46","Adudagi Jisuna ahouba khonjelda laorak-i, “Ipa! Eina eigi thawai asi nanggi khutta sinajari.” Asi hairamlaga Ibungona thawai thakhirammi. ");
INSERT INTO mni_vpl VALUES ("LK23_47","072_23_47","LUK","23","47","47","Aduga lanmi chamagi luchingba aduna thokkhiba adu ubada, Tengban Mapubu thagatladuna hairak-i, “Tasengnamak mahak achumba chatpa mini.” ");
INSERT INTO mni_vpl VALUES ("LK23_48","072_23_48","LUK","23","48","48","Amasung thoudok adu yengnanabagidamak tilliba miyam aduna thokkhiba adu urabada thabak yeiraduna hannakhirammi. ");
INSERT INTO mni_vpl VALUES ("LK23_49","072_23_49","LUK","23","49","49","Adubu Ibungoga khangnaba makhoising haibadi Galilee-dagi mahakki tung illakpi nupising adu yaona makhoi pumnamakna thaptakna lepladuna yenglammi. ");
INSERT INTO mni_vpl VALUES ("LK23_50","072_23_50","LUK","23","50","50","Aduga maming Joseph kouba aphaba amasung achumba chatpa mi ama leirammi. Mahak sanhedringi mioisinggi maraktagi ama oirammi, ");
INSERT INTO mni_vpl VALUES ("LK23_51","072_23_51","LUK","23","51","51","adubu mahakna makhoigi warep amadi thabak adu yaninglamde. Mahak Judea-gi Arimathea lamdagini aduga mahakna Tengban Mapugi leibak aduna lakpa khourangna ngaijarammi. ");
INSERT INTO mni_vpl VALUES ("LK23_52","072_23_52","LUK","23","52","52","Mahakna Pilate-ki manakta chattuna Jisugi hakchang adubu nijarammi. ");
INSERT INTO mni_vpl VALUES ("LK23_53","072_23_53","LUK","23","53","53","Adudagi mahakna hachang adubu loutharaduna linengi phina yomsillaga nungjaoda haktuna thamba mi kana amata thamnadriba mongpham amada thamkhi. ");
INSERT INTO mni_vpl VALUES ("LK23_54","072_23_54","LUK","23","54","54","Numit adu thourang langba numit oirammi amasung Potthaba Numit hougadourammi. ");
INSERT INTO mni_vpl VALUES ("LK23_55","072_23_55","LUK","23","55","55","Aduga Galilee-dagi Jisugi tung illakpising aduna Joseph-ki tung illaktuna mongphamda Jisugi hakchang adu karamna thambage haibadu yenglammi. ");
INSERT INTO mni_vpl VALUES ("LK23_56","072_23_56","LUK","23","56","56","Adudagi makhoina halaktuna hakchang adugidamak manam nungsiba machal amadi teinanaba thao thourang toujare. Adubu potthaba numit adudi wayel yathang matung-inna makhoina pottharammi. ");
INSERT INTO mni_vpl VALUES ("LK24_1","072_24_1","LUK","24","1","1","Chayolgi ahouba numitki ayuk anganbada nupising aduna makhoina thourang langkhraba manam nungsiba machalsing adu puduna mongphamda laklammi. ");
INSERT INTO mni_vpl VALUES ("LK24_2","072_24_2","LUK","24","2","2","Aduga makhoina mongpham changphamgi nung adu inthoklamba makhoina thengnare. ");
INSERT INTO mni_vpl VALUES ("LK24_3","072_24_3","LUK","24","3","3","Adubu makhoina manungda changba matamda Ibungo Jisugi hakchang adu leiramdre. ");
INSERT INTO mni_vpl VALUES ("LK24_4","072_24_4","LUK","24","4","4","Aduga makhoina madugi maramda chamamnaduna leiringeida, ikhang-khanghoudana langna-nganba phijol setpa nupa anina makhoigi manakta leplare. ");
INSERT INTO mni_vpl VALUES ("LK24_5","072_24_5","LUK","24","5","5","Maduda makhoina kimankhraduna leimaida mamai nonthaduna kuntharaga leirammi. Adudagi nupasing aduna makhoida hairak-i, “Karigi nakhoina asibasinggi marakta ahingba mahakpu thiribano? ");
INSERT INTO mni_vpl VALUES ("LK24_6","072_24_6","LUK","24","6","6","Mahak mapham asida leitre; mahak hinggatkhre. Mahakna Galilee-da nakhoiga leiminnaringeida kari hairambage haibadu ningsingu: ");
INSERT INTO mni_vpl VALUES ("LK24_7","072_24_7","LUK","24","7","7","‘Migi Machanupa adubu pappisinggi makhutta pithokkani, mahakpu cross-ta hatkani aduga humnisuba numitta amuk hanna hinggatkani.’ ” ");
INSERT INTO mni_vpl VALUES ("LK24_8","072_24_8","LUK","24","8","8","Adudagi nupising aduna mahakna waheising asi haikhibadu ningsinglaklammi. ");
INSERT INTO mni_vpl VALUES ("LK24_9","072_24_9","LUK","24","9","9","Aduga makhoina mongphamdagi halaklaga thokhibasing pumnamak adu tung-inba taramathoi amadi atei pumnamaksing aduda tamlammi. ");
INSERT INTO mni_vpl VALUES ("LK24_10","072_24_10","LUK","24","10","10","Pakhonchatpasing aduda thokhibasing pumnamak adubu tamkhiba nupising adudi Magdalene-gi Mary, Joanna, amadi Jacob-ki mama Mary oirammi. ");
INSERT INTO mni_vpl VALUES ("LK24_11","072_24_11","LUK","24","11","11","Adubu nupising aduna hairibasing adu makhoina pangangda ngangbani haina lourammi aduga makhoina nupising adubu thajakhide. ");
INSERT INTO mni_vpl VALUES ("LK24_12","072_24_12","LUK","24","12","12","Adumakpu Peterna hougattuna mongpham aduda chenkhirammi. Aduga mahakna lukthaduna yengbada Ibungobu mongphamda thambada yetkhiba linen phi adukhakta taduna leiba ure. Adudagi mahakna kari thokkhrabajatno haina ngakpaga loinana amuk hankhirammi. ");
INSERT INTO mni_vpl VALUES ("LK24_13","072_24_13","LUK","24","13","13","Numit adumaktada Jisugi tung-inbasinggi maraktagi makhoi anina Emmaus kouba Jerusalem-dagi mile taretmuk lappa khunggang aduda chatlammi. ");
INSERT INTO mni_vpl VALUES ("LK24_14","072_24_14","LUK","24","14","14","Amasung thokhiba thoudok pumnamaksing adugi maramda makhoina chatna chatna lambida wari sanarammi. ");
INSERT INTO mni_vpl VALUES ("LK24_15","072_24_15","LUK","24","15","15","Aduga makhoina thokkhibasing adugi maramda wari sanaduna khannaringeida ikhang khanghoudana Jisu masamak makhoigi manakta changsillaktuna makhoiga loinana chatminnarammi. ");
INSERT INTO mni_vpl VALUES ("LK24_16","072_24_16","LUK","24","16","16","Adubu Tengban Mapuna makhoida Ibungobu masak khanghallamde. ");
INSERT INTO mni_vpl VALUES ("LK24_17","072_24_17","LUK","24","17","17","Adudagi Jisuna makhoida hanglak-i, “Nakhoina chatna chatna kari maramda khannaribano aduga karigi pukning waribano?” ");
INSERT INTO mni_vpl VALUES ("LK24_18","072_24_18","LUK","24","18","18","Maduda makhoigi maraktagi maming Cleopas kouba amana Ibungoda khumlak-i, “Houkhiba numit kharani asigi manungda thokkhiba thoudoksing asi khangdaba Jerusalemda thunglaba misi nahak khakta oiramgadra?” ");
INSERT INTO mni_vpl VALUES ("LK24_19","072_24_19","LUK","24","19","19","Maduda Ibungona makhoida hanglak-i, “Kari kari thoudok thokkhrabage?” Makhoina Ibungoda khumlak-i, “Thokkhibasing adu Nazareth-ki Jisugi maramdani. Mahak Tengban Mapu amadi misinggi mangda wahei amadi thabakta matik leiba Tengban Mapugi wa phongdokpiba maichou amani. ");
INSERT INTO mni_vpl VALUES ("LK24_20","072_24_20","LUK","24","20","20","Adubu eikhoigi athoiba purohitsing amadi leingakpasingna mahakpu sibagi maral pinanaba khusinnakhi aduga makhoina mahakpu cross-thakta pang tingduna hatkhi. ");
INSERT INTO mni_vpl VALUES ("LK24_21","072_24_21","LUK","24","21","21","Eikhoinadi Israel-bu maning tamhanbigadaba misak adu Ibungomakni haina asha toujarambani! Pumnamaksing asi thokkhiba ngasina humni subani. ");
INSERT INTO mni_vpl VALUES ("LK24_22","072_24_22","LUK","24","22","22","Adugisu mathakta eikhoigi maraktagi nupi kharana ngasi ayuk nganta mongphamda chatluraga angakpa pao puduna halaktuna makhoina eikhoibu ngakhallare. ");
INSERT INTO mni_vpl VALUES ("LK24_23","072_24_23","LUK","24","23","23","Makhoina Ibungogi hakchang adu mangkhre, aduga makhoida ‘Jisu hinggatkhre’ haina hairakpa swarga dut ani thengnarak-i, haiduna eikhoida tamkhi. ");
INSERT INTO mni_vpl VALUES ("LK24_24","072_24_24","LUK","24","24","24","Aduga eikhoigi maraktagi makhoi kharana madu yengnanabagidamak chatlubada nupising aduna haikhiba aduga chap manana ahangba mongpham adu thengnakhi adubu makhoina mahakpudi uba phangkhide.” ");
INSERT INTO mni_vpl VALUES ("LK24_25","072_24_25","LUK","24","25","25","Maduda Jisuna makhoida hairak-i, “Nakhoisi kayada pangkhraba! Tengban Mapugi wa phongdokpiba maichousingna hairambasing adu thajabada kayada thinthariba! ");
INSERT INTO mni_vpl VALUES ("LK24_26","072_24_26","LUK","24","26","26","Christtana matik ma-ngal phangdringeigi mamangda awa anang pumnamaksingsi khaanggadaba nattabra? Christtana awa anang pumnamak asi khanglaga matik mangal phanggadaba nattabra?” ");
INSERT INTO mni_vpl VALUES ("LK24_27","072_24_27","LUK","24","27","27","Adudagi Jisuna Moses-ki lairik amadi Tengban Mapugi wa phongdokpiba maichousinggi lairiktagi houraga mahak masamakki maramda puya pumnamakta hairibasing adu sandokna makhoida taklammi. ");
INSERT INTO mni_vpl VALUES ("LK24_28","072_24_28","LUK","24","28","28","Aduga makhoina chatliba khunggang adu naksillaklaba matamda, Jisuna mapham adudagi makha tana chatkhigadabagi matou makhoida utlammi. ");
INSERT INTO mni_vpl VALUES ("LK24_29","072_24_29","LUK","24","29","29","Adubu makhoina Ibungoda kanna taksinduna haijakhi, “Numit asi thengjillakkhre, aduga mamsu mamsillakle, aduna eikhoiga loinana leiminnarasi.” Maduda Ibungona makhoiga loinana leiminnanaba changminnare. ");
INSERT INTO mni_vpl VALUES ("LK24_30","072_24_30","LUK","24","30","30","Aduga Ibungona makhoiga loinana chaminnanaba phamthaba matamda, mahakna tal adu louraduna Tengban Mapubu thagatcharammi. Adudagi mahakna tal adu machet setladuna makhoida pirammi. ");
INSERT INTO mni_vpl VALUES ("LK24_31","072_24_31","LUK","24","31","31","Matam aduda makhoigi mamit pangthok-hallammi amasung makhoina Ibungobu sak khanglaklammi. Aduga Ibungona makhoigi mityengdagi mangkhirammi. ");
INSERT INTO mni_vpl VALUES ("LK24_32","072_24_32","LUK","24","32","32","Adudagi makhoi masel hainarak-i, “Mahakna lambida eikhoida wari saringei amadi Tengban Mapugi Puya eikhoida sandokna taklingei matamda eikhoida nunggi harao-nungaibana thankhidra?” ");
INSERT INTO mni_vpl VALUES ("LK24_33","072_24_33","LUK","24","33","33","Adudagi makhoina khudak adumaktada hougattuna Jerusalemda amuk halakle. Amasung makhoina mapham aduda tung-inba taramathoi amadi makhoiga loinaramba ateising pulap tinnaramba thengnare. ");
INSERT INTO mni_vpl VALUES ("LK24_34","072_24_34","LUK","24","34","34","Aduga makhoina, “Ibungo tasengnamak hinggatkhre amasung Simon-da uhanbikhre” haiba adu tare. ");
INSERT INTO mni_vpl VALUES ("LK24_35","072_24_35","LUK","24","35","35","Adudagi makhoi aninasu lambida thokkhiba thoudoksing, amadi Ibungona tal thugaiba matam aduda makhoina kamdouna Ibungobu sak khanglakkhiba haibadu makhoida tamle. ");
INSERT INTO mni_vpl VALUES ("LK24_36","072_24_36","LUK","24","36","36","Makhoi anina thoudoksing adu tamlingeimaktada, ikhang khanghoudana Ibungona makhoigi marakta leplare aduga mahakna makhoida hairak-i, “Nakhoida ingthaba leisanu.” ");
INSERT INTO mni_vpl VALUES ("LK24_37","072_24_37","LUK","24","37","37","Maduda makhoina uribadu thawaini haina khanduna makhoi adukki matik kirammi. ");
INSERT INTO mni_vpl VALUES ("LK24_38","072_24_38","LUK","24","38","38","Adubu Ibungona makhoida hairak-i, “Nakhoina karigi aduk kiribano? Nakhoigi thamoida karigi chingnabasing asi laklibano? ");
INSERT INTO mni_vpl VALUES ("LK24_39","072_24_39","LUK","24","39","39","Eigi khut asida yeng-u! Eigi khong asida yeng-u! Eimakni. Eibu soktuna yengu, maramdi eina lu-tong panba nakhoina uriba asigumna thawaigidi lu-tong pande.” ");
INSERT INTO mni_vpl VALUES ("LK24_40","072_24_40","LUK","24","40","40","Mahakna masi haiduna makhoida mahakki makhut amadi makhong adu yenghallammi. ");
INSERT INTO mni_vpl VALUES ("LK24_41","072_24_41","LUK","24","41","41","Amasung makhoina haraobagi amadi ngakpagi maramna thajaba ngamdaduna leiringeida Ibungona makhoida hanglak-i, “Mapham asida nakhoigi karigumba chananabaga leibra?” ");
INSERT INTO mni_vpl VALUES ("LK24_42","072_24_42","LUK","24","42","42","Maduda makhoina mangonda nga ayaiba machet ama pire, ");
INSERT INTO mni_vpl VALUES ("LK24_43","072_24_43","LUK","24","43","43","aduga mahakna madu louraduna makhoigi mamangda chare. ");
INSERT INTO mni_vpl VALUES ("LK24_44","072_24_44","LUK","24","44","44","Adudagi Ibungona makhoida hairak-i, “Eina nakhoiga leiminnaringei matamda haikhiba wasing adu asimakni. Moseski Wayel Yathangda, Tengban Mapugi wa phongdokpibasinggi lairikta, amasung thagat iseigi lairikta eigi maramda hairamba wa khudingmak thungba tai.” ");
INSERT INTO mni_vpl VALUES ("LK24_45","072_24_45","LUK","24","45","45","Adudagi makhoina Mapugi puya adu khangnanaba Ibungona makhoigi pukning hangdokpikhi. ");
INSERT INTO mni_vpl VALUES ("LK24_46","072_24_46","LUK","24","46","46","Aduga Ibungona makhoida hairak-i, “Masi iduna leiribasing aduni: Christana awaba khaangba tai aduga humni suba numitta sibadagi hingatpa tai. ");
INSERT INTO mni_vpl VALUES ("LK24_47","072_24_47","LUK","24","47","47","Aduga Jerusalemdagi houduna phurup khudingmakta, paptagi pukning hongbagi amadi pap kokpibagi pao adu mahakki mingda sandokkadabani. ");
INSERT INTO mni_vpl VALUES ("LK24_48","072_24_48","LUK","24","48","48","Nakhoina pumnamaksing asigi sakhini. ");
INSERT INTO mni_vpl VALUES ("LK24_49","072_24_49","LUK","24","49","49","Aduga Ipana wasakpikhiba adu eina nakhoida tharakkani. Adubu mathaklomdagi panggal aduna nakhoigi nathakta laktriba phaoba nakhoina sahar aduda ngaiduna leiyu.” ");
INSERT INTO mni_vpl VALUES ("LK24_50","072_24_50","LUK","24","50","50","Adudagi Ibungona makhoibu Bethany phaoba chingbiraklaga khut thangattuna makhoibu yaipha-thoujal pibire. ");
INSERT INTO mni_vpl VALUES ("LK24_51","072_24_51","LUK","24","51","51","Aduga Ibungona makhoibu yaipha-thoujal piringeida makhoibu thadoklamduna Ibungobu swargada pukhatkhre. ");
INSERT INTO mni_vpl VALUES ("LK24_52","072_24_52","LUK","24","52","52","Aduga makhoina Ibungobu khurumjaraga haraobana thanbaga loinanana Jerusalemda hankhirammi. ");
INSERT INTO mni_vpl VALUES ("LK24_53","072_24_53","LUK","24","53","53","Amasung makhoina Mapugi Sanglenda makha tana leiduna Tengban Mapubu thagattuna leirammi. Amen.");
INSERT INTO mni_vpl VALUES ("JN1_1","073_1_1","JHN","1","1","1","Ahoubada Wahei adu leirammi; Wahei adu Tengban Mapuga leiminnarammi amasung Wahei adu Tengban Mapu oirammi. ");
INSERT INTO mni_vpl VALUES ("JN1_2","073_1_2","JHN","1","2","2","Hek houba adudagi houna Wahei adu Tengban Mapuga leiminnarammi. ");
INSERT INTO mni_vpl VALUES ("JN1_3","073_1_3","JHN","1","3","3","Ibungo mahakki mapanna Tengban Mapuna pot pumnamak sembikhi; Ibungo mahak yaodana semkhiba khutsem amata leite. ");
INSERT INTO mni_vpl VALUES ("JN1_4","073_1_4","JHN","1","4","4","Ibungoda hingba leirammi aduga hingba aduna misinggi mangal oirammi. ");
INSERT INTO mni_vpl VALUES ("JN1_5","073_1_5","JHN","1","5","5","Mangal aduna amambada ngalle aduga amamba aduna mangal adubu ngamde. ");
INSERT INTO mni_vpl VALUES ("JN1_6","073_1_6","JHN","1","6","6","Tengban Mapuna thabirakpa John kouba mi ama leirammi. ");
INSERT INTO mni_vpl VALUES ("JN1_7","073_1_7","JHN","1","7","7","Mi khudingmak mahakki mapanna thajaraknaba, mahakna misingda mangal adugi maramda hainaba lakpani. ");
INSERT INTO mni_vpl VALUES ("JN1_8","073_1_8","JHN","1","8","8","Mahak masamakti mangal adu natte adubu mahakti mangal adugi maramda hainanaba lakpani. ");
INSERT INTO mni_vpl VALUES ("JN1_9","073_1_9","JHN","1","9","9","Mi khudingmakta mangal pibiba achumba mangal adu taibangpanda laklammi. ");
INSERT INTO mni_vpl VALUES ("JN1_10","073_1_10","JHN","1","10","10","Wahei adu taibangpanda leirammi, aduga Mapu Ibungona taibangpan asi Ibungo mahakki mapanna sembikhiba oirabasu, taibangpannadi Ibungo mahakpu khanglamde. ");
INSERT INTO mni_vpl VALUES ("JN1_11","073_1_11","JHN","1","11","11","Ibungo mahakna masagi oiba maphamda laklammi adubu mahakmakki misingna Ibungobu lousillamde. ");
INSERT INTO mni_vpl VALUES ("JN1_12","073_1_12","JHN","1","12","12","Adubu mi kharanadi Ibungobu lousinjarammi amadi Ibungobu thajarammi; maram aduna Ibungona makhoida Tengban Mapugi machasing oinaba matik pibire. ");
INSERT INTO mni_vpl VALUES ("JN1_13","073_1_13","JHN","1","13","13","Makhoina Tengban Mapugi machasing oirakpa asi mama mapana nattraga mioibagi apambana nattraga mapuroibagi warepna pokpiba adugumba natte adubu Mapu Ibungona pokpibani. ");
INSERT INTO mni_vpl VALUES ("JN1_14","073_1_14","JHN","1","14","14","Wahei aduna sayollaktuna thoujal amadi achumbana pik thanduna eikhoigi irakta leibirare. Aduga eikhoina Ibungo mahakki matik mangal haibadi Mapagi amatta ngairaba Macha oibagi matik mangal adu ujare. ");
INSERT INTO mni_vpl VALUES ("JN1_15","073_1_15","JHN","1","15","15","John-na Ibungo mahakki maramda hairammi. Mahakna houna hairak-i, “‘Ibungona eigi tungda lengbirakli adubu Ibungo mahakti eina poktringeida hannana leirabani maram asina Ibungona eingondagi henna chao-i,’ haina eina nakhoida haikhiba Ibungo mahak adu asini.” ");
INSERT INTO mni_vpl VALUES ("JN1_16","073_1_16","JHN","1","16","16","Athanba thoujalgi pukkei oiriba Ibungo mangondagi yaipha thoujal amagi mathakta yaipha thoujal ama eikhoi pumnamakna phangjare. ");
INSERT INTO mni_vpl VALUES ("JN1_17","073_1_17","JHN","1","17","17","Wayel Yathangdi Moses-ki mapanna pibibani adubu thoujal amasung achumbadi Jisu Christtagi mapanna lakpani. ");
INSERT INTO mni_vpl VALUES ("JN1_18","073_1_18","JHN","1","18","18","Mi kana amatana Tengban Mapubu kheidounungdasu ukhidri. Adubu Mapaga yamna naknana leiriba amatta ngairaba Machanupa Mapu Ibungona Ibungo mahakpu phongdokle. ");
INSERT INTO mni_vpl VALUES ("JN1_19","073_1_19","JHN","1","19","19","Jerusalem-da leiba Jihudisingna, John-bu kanano haina hangnaba purohitsing amasung Levi-singbu John-gi manakta tharaklammi. ");
INSERT INTO mni_vpl VALUES ("JN1_20","073_1_20","JHN","1","20","20","Mahakna paokhum piningdaba touramde aduga i-phong phongna sengna hairak-i, “Eidi Christta adu natte.” ");
INSERT INTO mni_vpl VALUES ("JN1_21","073_1_21","JHN","1","21","21","Maduda makhoina hanglak-i, “Adu oirabadi nahak kanano? Nahak Elijah-ra?” John-na khumlak-i, “Ei natte.” Adudagi makhoina hanglak-i, “Adudi Mapu Ibungogi wa phongdokpa maichou ama lakkani haibadu nahakla?” Mahakna khumlak-i, “Natte” ");
INSERT INTO mni_vpl VALUES ("JN1_22","073_1_22","JHN","1","22","22","Aroibada makhoina hairak-i, “Adu oirabadi nahak kanano haibasi eikhoida haibirak-u. Eikhoibu tharakpa makhoising aduda tamlunaba nahakna paokhum amadi pibiyu. Nahakna nasagi maramda kari haijabage?” ");
INSERT INTO mni_vpl VALUES ("JN1_23","073_1_23","JHN","1","23","23","Mapu Ibungogi wa phongdokpa maichou Isaiah-gi waheising sijinnaduna John-na paokhum pirak-i: “Lamjao lamhangda laoriba kanagumba amagi khonjel adu eini: ‘MAPU IBUNGO mahakna chatnanaba lambi adu chumhallu!’ ” ");
INSERT INTO mni_vpl VALUES ("JN1_24","073_1_24","JHN","1","24","24","Pharisee kharasu John-gi maphamda tharak-i, ");
INSERT INTO mni_vpl VALUES ("JN1_25","073_1_25","JHN","1","25","25","makhoina John-da hanglak-i, “Nahak Christta adusu Elijah adusu Mapu Ibungogi wa phongdokpa maichou adusu nattrabadi karigi nahakna baptize touribano?” ");
INSERT INTO mni_vpl VALUES ("JN1_26","073_1_26","JHN","1","26","26","Maduda John-na khumlak-i, “Einadi isingda baptize tou-i adubu nakhoina khangdaba kanagumba ama nakhoigi narakta lepli. ");
INSERT INTO mni_vpl VALUES ("JN1_27","073_1_27","JHN","1","27","27","Ibungo mahakna eigi tungda lakli aduga eidi Ibungo mahakki sandal mari louthokpa phaoba matik chade.” ");
INSERT INTO mni_vpl VALUES ("JN1_28","073_1_28","JHN","1","28","28","John-na baptize toubiba mapham Jordan turen-gi nongpok thangba wangmada leiba Bethany-da masigi thoudok asi thokkhibani. ");
INSERT INTO mni_vpl VALUES ("JN1_29","073_1_29","JHN","1","29","29","Mathanggi numitta Jisuna John-gi manakta lakpadu ure maduda John-na hairak-i, “Yeng-u, taibangpanbagi pappu pubiduna louthokpiba Tengban Mapugi Yaomacha adu! ");
INSERT INTO mni_vpl VALUES ("JN1_30","073_1_30","JHN","1","30","30","Ibungo asigi maramdani eina haikhibadu, ‘Kanagumba ama eigi tungda lengbirakli, Ibungo mahakti eina poktringeidagi hannana leirabani maramsina Ibungona eingondagi henna chao-i.’ ");
INSERT INTO mni_vpl VALUES ("JN1_31","073_1_31","JHN","1","31","31","Einadi Ibungobu kanano haiba khanglamde adubu eina isingda baptize toubasi Ibungo mahakpu Israel-da phongdoknabani.” ");
INSERT INTO mni_vpl VALUES ("JN1_32","073_1_32","JHN","1","32","32","Adudagi John-na sakhi asi pirammi: “Thawai aduna swargadagi khunugumna lengtharaktuna Ibungoda leiba adu eina ure. ");
INSERT INTO mni_vpl VALUES ("JN1_33","073_1_33","JHN","1","33","33","Eibu isingda baptize tounaba thabiba Ibungo mahakna eingonda, ‘Thawai aduna kanagumba amagi mathakta lengtharaktuna leiba nahakna ugani; mahak aduna Thawai Asengbada baptize toubigani,’ haina haibiramdrabadi eina Ibungo mahakpu khanglamloidabani. ");
INSERT INTO mni_vpl VALUES ("JN1_34","073_1_34","JHN","1","34","34","Eina madumak ujare aduga Ibungo mahak asi Tengban Mapugi Machanupani haina eina nakhoida hairi.” ");
INSERT INTO mni_vpl VALUES ("JN1_35","073_1_35","JHN","1","35","35","Mathanggi numitta John-na mahakki tung-inba aniga loinana leptuna leirammi. ");
INSERT INTO mni_vpl VALUES ("JN1_36","073_1_36","JHN","1","36","36","Jisuna mapham aduda chatpadu ubada mahakna hairak-i, “Yeng-u, Tengban Mapugi Yaomacha adu.” ");
INSERT INTO mni_vpl VALUES ("JN1_37","073_1_37","JHN","1","37","37","John-na haiba adu mahakki tung-inba aniduna tarabada makhoina Jisugi matung induna chatkhirammi. ");
INSERT INTO mni_vpl VALUES ("JN1_38","073_1_38","JHN","1","38","38","Jisuna leithorakpada makhoina mahakki tung illakliba adu ure maduda Ibungona hanglak-i, “Nakhoi kari pambage?” Maduda makhoina khumlak-i, “Rabbi” (Masigi wahanthokti “Oja Ibungo” haibani), “Ibungo nahak kadaida leibibage?” ");
INSERT INTO mni_vpl VALUES ("JN1_39","073_1_39","JHN","1","39","39","Ibungona khumlak-i, “Lak-u aduga nakhoina u-gani.” (Matam adu numit yungba matung pung marimuk tabada oirammi.) Maram aduna makhoina Ibungoga loinana chattuna Ibungona leiba mapham adu ujare aduga numit aduma makhoina Ibungoga loinana leiminnarammi. ");
INSERT INTO mni_vpl VALUES ("JN1_40","073_1_40","JHN","1","40","40","John-na haiba adu taduna Jisugi tung inkhiba makhoi anigi marakta amadi Simon Peter-gi manao Andrew-ni. ");
INSERT INTO mni_vpl VALUES ("JN1_41","073_1_41","JHN","1","41","41","Andrew-na ihan hanna mahakki mayamba Simon-bu thiraga mangonda hairammi, “Eikhoina Messiah adu phangjare.” (Madudi “Christta” haibani) ");
INSERT INTO mni_vpl VALUES ("JN1_42","073_1_42","JHN","1","42","42","Adudagi mahakna Simon-bu Jisugi manakta purakle. Jisuna Simon-da yenglaga hairak-i, “Nahakti John-gi machanupa Simon-ni, adubu nahakki naming Cephas kougani.” (Masigi wahanthokti “Peter” haibani.) ");
INSERT INTO mni_vpl VALUES ("JN1_43","073_1_43","JHN","1","43","43","Mathanggi numitta Galilee-da Jisuna chatke leple. Ibungona Philip-pu thengnarabada mangonda hairak-i, “Eigi itung illak-u!” ");
INSERT INTO mni_vpl VALUES ("JN1_44","073_1_44","JHN","1","44","44","(Andrew amadi Peter-gumna Philip-su Bethsaida sahardagini.) ");
INSERT INTO mni_vpl VALUES ("JN1_45","073_1_45","JHN","1","45","45","Philip-na Nathanael-bu phanglabada mangonda hairammi, “Moses-na Wayel Yathangda amasung Mapu Ibungogi wa phongdokpa maichousingnasu ibiramba mahak adu eikhoina phangle. Mahak adudi Joseph-ki machanupa, Nazareth-ki Jisuni.” ");
INSERT INTO mni_vpl VALUES ("JN1_46","073_1_46","JHN","1","46","46","Nathanael-na hanglak-i, “Nazareth-tagibu karigumba aphaba thorakpa ngambra?” Maduda Philip-na khumlak-i, “Laktuna yeng-u.” ");
INSERT INTO mni_vpl VALUES ("JN1_47","073_1_47","JHN","1","47","47","Mahakki manakta Nathanael-na lakpadu urabada Jisuna mangonda hairak-i, “Mapham asida tasengba Israel-gi mi ama leire; mangonda lounamba leite.” ");
INSERT INTO mni_vpl VALUES ("JN1_48","073_1_48","JHN","1","48","48","Nathanael-na Ibungoda hanglak-i, “Ibungona eibu karamna khangbibage?” Maduda Jisuna paokhum pirak-i, “Philip-na nahakpu koudringeida, nahakna heiyit pambi makhada leiba matam aduda eina nangbu ure.” ");
INSERT INTO mni_vpl VALUES ("JN1_49","073_1_49","JHN","1","49","49","Nathanael-na khumlak-i, “Oja Ibungo, nahak Tengban Mapugi Machanupa aduni! Nahak Israel-gi Ningthouni!” ");
INSERT INTO mni_vpl VALUES ("JN1_50","073_1_50","JHN","1","50","50","Jisuna mangonda hairak-i, “Nahakna heiyit pambi makhada leiringeida eina nangbu ure haina eina nangonda haibagi maramna nahakna thajaribra? Masidagi henna chaoba thabaksing nahakna ukhigani.” ");
INSERT INTO mni_vpl VALUES ("JN1_51","073_1_51","JHN","1","51","51","Adudagi Ibungona makha tarak-i, “Eina nakhoida tasengnamak hairiba asini, swarga hangdokpa amadi Tengban Mapugi dutsingna Migi Machanupa adugi mathakta kakhat khumtha touba adu nakhoina ugani.” ");
INSERT INTO mni_vpl VALUES ("JN2_1","073_2_1","JHN","2","1","1","Numit ninigi matungda Galilee-gi Cana kouba khun aduda luhongba ama leirammi. Jisugi mamasu maduda yaorammi, ");
INSERT INTO mni_vpl VALUES ("JN2_2","073_2_2","JHN","2","2","2","aduga Jisu amadi mahakki tung-inbasingsu luhongba adu yaobinanaba haijaraklammi. ");
INSERT INTO mni_vpl VALUES ("JN2_3","073_2_3","JHN","2","3","3","Anggur mahi loikhrabada Jisugi mamana Ibungoda hairak-i, “Makhoigi anggur mahi loikhre.” ");
INSERT INTO mni_vpl VALUES ("JN2_4","073_2_4","JHN","2","4","4","Maduda Jisuna khumlak-i, “Masida nahakna eibu karigi yaohallibano? Eigi matam laktri.” ");
INSERT INTO mni_vpl VALUES ("JN2_5","073_2_5","JHN","2","5","5","Thougal touriba mioising aduda Jisugi mamana hairak-i, “Mahakna haiba haiba khudingmak nakhoina tou.” ");
INSERT INTO mni_vpl VALUES ("JN2_6","073_2_6","JHN","2","6","6","Isingna sengdokpagi chatnabi ama Jihudisinggi lei, maram adugidamak ising hapnaba nunggi kharung taruk mapham aduda leirammi, kharung ama-mamda chourakna ising litre chamamuk chan-gani. ");
INSERT INTO mni_vpl VALUES ("JN2_7","073_2_7","JHN","2","7","7","Thougal touribasing aduda Jisuna hairak-i, “Kharungsing aduda ising thanna hapchillu.” Maram aduna makhoina kharungsing aduda ising pik-thanna hapchille. ");
INSERT INTO mni_vpl VALUES ("JN2_8","073_2_8","JHN","2","8","8","Adudagi Ibungona makhoida hairak-i, “Houjik khara kanthoklaga arang-purel aduda purucho.” Ibungona haiba adu makhoina toure, ");
INSERT INTO mni_vpl VALUES ("JN2_9","073_2_9","JHN","2","9","9","aduga arang-purel aduna anggur mahi onkhraba ising adu mahao tangle. Ising adu kallakpa thougal toubasing aduna khanglabasu mahaknadi kadaidagi anggur mahi adu puraklibano haiba khanglamde. Adudagi mahakna luhonggadouriba nupa adu koure ");
INSERT INTO mni_vpl VALUES ("JN2_10","073_2_10","JHN","2","10","10","aduga hairak-i, “Mi khudingna ahanbada khwaidagi phaba anggur mahi adu puthoknei aduga misingna marang kaina thaklaba matungda khara hanthaba aduna konna puthoknei; adubu nahakti houjik phaoba khwaidagi phaba asi khaklamli.” ");
INSERT INTO mni_vpl VALUES ("JN2_11","073_2_11","JHN","2","11","11","Jisuna touba ahanba angakpa khudam asi Galilee-gi Cana-da pangthokkhi; mapham aduda Ibungona mahakki matik mangal utpire aduga Ibungogi tung-inbasingna Ibungobu thajare. ");
INSERT INTO mni_vpl VALUES ("JN2_12","073_2_12","JHN","2","12","12","Masigi matungda Jisuna mahakki mama, machin manao amadi mahakki tung-inbasingga loinana Capernaum-da chatlammi. Mapham aduda makhoina numit khara leirammi. ");
INSERT INTO mni_vpl VALUES ("JN2_13","073_2_13","JHN","2","13","13","Lanthokpibagi Chakkhangbagi matam naksillaklammi maram aduna Jisuna Jerusalem-da chatlammi. ");
INSERT INTO mni_vpl VALUES ("JN2_14","073_2_14","JHN","2","14","14","Mapugi Sanglenda misingna sa-sal, yao amasung khunusing yonbadu Ibungona thengnare aduga mapham aduda phamliba sel-kaibasing adusu ure. ");
INSERT INTO mni_vpl VALUES ("JN2_15","073_2_15","JHN","2","15","15","Maram aduna Ibungona thouridagi sajei semlaga yao amadi sa-sal loina Ningnasangdagi tanthokle; Ibungona sel-kaibasingdugi table-singdu mathak makha onthokle aduga makhoigi sel achoibasingdu chaikhaire; ");
INSERT INTO mni_vpl VALUES ("JN2_16","073_2_16","JHN","2","16","16","aduga Ibungona khunu yonbasing aduda hairak-i, “Khunusingdu mapham asidagi puthokkho! Eigi Ipagi yumbu keithel onthokkanu.” ");
INSERT INTO mni_vpl VALUES ("JN2_17","073_2_17","JHN","2","17","17","Ibungogi tung-inbasingna Mapu Ibungogi puyada i-ba wahei haibadi, “Ibungo nahakki yumgidamak thawai yaojabana eigi nungda meigumna chakle” haiba asi ningsinglakle. ");
INSERT INTO mni_vpl VALUES ("JN2_18","073_2_18","JHN","2","18","18","Jihudigi luchingbasingna Jisuda hanglak-i, “Masising asi toubagi nahakki matik lei haiba utnanaba nahakna karamba angakpa khudam eikhoida utpa ngamgani” ");
INSERT INTO mni_vpl VALUES ("JN2_19","073_2_19","JHN","2","19","19","Maduda Jisuna makhoida paokhum pirak-i, “Mapugi Sanglen asi thugaiyu aduga eina numit humnigi manungda amuk hanna sage.” ");
INSERT INTO mni_vpl VALUES ("JN2_20","073_2_20","JHN","2","20","20","Makhoina khumlak-i, “Mapugi Sanglen asi chahi niphu-taruk changna sakhibani aduga nahakna numit humnida sagadouribra?” ");
INSERT INTO mni_vpl VALUES ("JN2_21","073_2_21","JHN","2","21","21","Adubu Ibungona hairiba sanglen adudi Ibungo mahakki hakchang adubuni. ");
INSERT INTO mni_vpl VALUES ("JN2_22","073_2_22","JHN","2","22","22","Maram aduna Ibungona sibadagi hinggatlakpa matamduda mahakki tung-inbasingna Ibungona haikhiba asi ningsinglakkhi aduga makhoina Mapugi puya amadi Jisuna haikhiba wasing aduda thajare. ");
INSERT INTO mni_vpl VALUES ("JN2_23","073_2_23","JHN","2","23","23","Lanthokpibagi chakkhangba matamda Jisusu Jerusalem-da leirammi aduga Ibungona touba angakpa khudamsing adu miyamna ure aduga makhoina Ibungobu thajare. ");
INSERT INTO mni_vpl VALUES ("JN2_24","073_2_24","JHN","2","24","24","Adubu Jisuna masana masabu makhoida thajana sinnade maramdi mahakna mi khudingmakpu khanglammi. ");
INSERT INTO mni_vpl VALUES ("JN2_25","073_2_25","JHN","2","25","25","Kanagumba amatana mioibagi maramda Ibungoda haibagi kanaba leite maramdi Ibungo masana mioibagi nungda kari lei haiba khanglammi. ");
INSERT INTO mni_vpl VALUES ("JN3_1","073_3_1","JHN","3","1","1","Pharisee-singgi maraktagi Nicodemus kouba Jihudisinggi luchingba ama leirammi. ");
INSERT INTO mni_vpl VALUES ("JN3_2","073_3_2","JHN","3","2","2","Nongma numidang amada mahakna Jisugi manakta laklaga hairak-i, “Oja Ibungo, nahakti Tengban Mapuna thabirakpa oja amani haiba eikhoina khangjei. Maramdi nahakna touriba angakpa khudamsing asi Mapu Ibungona loinabidrabadi kana amatana touba ngamloi.” ");
INSERT INTO mni_vpl VALUES ("JN3_3","073_3_3","JHN","3","3","3","Jisuna khumlak-i, “Eina nakhoida tasengnamak hairiba asini, kanagumba amana amuk-hanna poktrabadi mahakna Tengban Mapugi Leibak adu uba ngamloi.” ");
INSERT INTO mni_vpl VALUES ("JN3_4","073_3_4","JHN","3","4","4","Maduda Nicodemus-na Ibungoda hanglak-i, “Karamna ahal oiraba mi amana amuk hanna pokpa yagadouribano? Mahakna mamagi puknungda aniraksuba oina changduna amuk pokpa haibasi sukya yaroidaba amani!” ");
INSERT INTO mni_vpl VALUES ("JN3_5","073_3_5","JHN","3","5","5","Jisuna khumlak-i, “Eina nakhoida tasengna hairiba asini, kanagumba amana ising amasung Thawaidagi poktrabadi mahakna Tengban Mapugi Leibakta changba ngamloi. ");
INSERT INTO mni_vpl VALUES ("JN3_6","073_3_6","JHN","3","6","6","Hakchanggi oinadi mama mapana pokpibani adubu thawaigi oinadi Thawaina pokpibani. ");
INSERT INTO mni_vpl VALUES ("JN3_7","073_3_7","JHN","3","7","7","‘Nakhoi amuk-hanna pokkadabani’ haina eina hairiba asida nahak ngakkanu. ");
INSERT INTO mni_vpl VALUES ("JN3_8","073_3_8","JHN","3","8","8","Nungsitna sitning sitningba maphamsingda sitli aduga nahakna madugi makholdi tai adubu madu kadaidagi lakpano aduga kadaida chatlibano haiba adudi nahakna khangde. Adugumduna Thawaina poklaba makhoi adusuni.” ");
INSERT INTO mni_vpl VALUES ("JN3_9","073_3_9","JHN","3","9","9","Maduda Nicodemus-na hanglak-i, “Masi kamdouna oithokkadouribano?” ");
INSERT INTO mni_vpl VALUES ("JN3_10","073_3_10","JHN","3","10","10","Jisuna khumlak-i, “Nahak Israel-gi oja ama oiraga masising asi khangdabra? ");
INSERT INTO mni_vpl VALUES ("JN3_11","073_3_11","JHN","3","11","11","Eina nakhoida tasengnamak hairibasini, eikhoina khangba amadi uba adu eikhoina hai adubu nakhoinadi eikhoina haiba adu louningde. ");
INSERT INTO mni_vpl VALUES ("JN3_12","073_3_12","JHN","3","12","12","Eina nakhoida taibangpanbagi oibasing adugi maramda haibada nakhoina thajade adu oirabadi swargagi oibasing adugi maramda haibada nakhoina kamdouna thajagani? ");
INSERT INTO mni_vpl VALUES ("JN3_13","073_3_13","JHN","3","13","13","Swargadagi kumthabirakpa Migi Machanupa adu nattana kana amatana swargada kadri.” ");
INSERT INTO mni_vpl VALUES ("JN3_14","073_3_14","JHN","3","14","14","Korina saba lil adu Moses-na lamjao lamhangda thanggatkhiba adugumduna Migi Machanupa adubusu thanggatpa tai, ");
INSERT INTO mni_vpl VALUES ("JN3_15","073_3_15","JHN","3","15","15","madu mahakpu thajaba mi khudingna lomba naidaba punsi phangnanabani. ");
INSERT INTO mni_vpl VALUES ("JN3_16","073_3_16","JHN","3","16","16","Tengban Mapuna taibangpanbabu asukki matik nungsibire aduna mahakki amatta ngairaba Machanupa adu pibire, maram aduna Machanupa adubu thajaba mi khudingna mangdaduna lomba naidaba hingba phangjananabani. ");
INSERT INTO mni_vpl VALUES ("JN3_17","073_3_17","JHN","3","17","17","Tengban Mapuna mahakki Machanupa adubu wayennaba taibangpanda thabiba natte adubu mahakki mapanna taibangpanbabu kanbinanabani. ");
INSERT INTO mni_vpl VALUES ("JN3_18","073_3_18","JHN","3","18","18","Machanupa adubu thajaba makhoi adu wayen toubide adubu thajadaba makhoi adugidi wayen loikhre maramdi makhoina amatta ngairaba Tengban Mapugi Machanupa adubu thajade. ");
INSERT INTO mni_vpl VALUES ("JN3_19","073_3_19","JHN","3","19","19","Wayen adu asini madudi mangal aduna taibangpanda lakle adubu misingnadi amamba thabakna henna pambagi maramna makhoina mangaldagi amambana henna pammi maramdi makhoigi thabaksing phattaba oirammi. ");
INSERT INTO mni_vpl VALUES ("JN3_20","073_3_20","JHN","3","20","20","Phattaba touba mi khudingna mangal adubu tukkachei maramdi makhoigi thabaksingdu phongdokkani haiba kibagi maramna makhoina mangalda lakloi. ");
INSERT INTO mni_vpl VALUES ("JN3_21","073_3_21","JHN","3","21","21","Adubu achumba toubasingnadi mangalda lak-i maramdi makhoina touba thabaksing adu Tengban Mapugi haiba inba oina toubani haibadu mangal aduna utnanabani. ");
INSERT INTO mni_vpl VALUES ("JN3_22","073_3_22","JHN","3","22","22","Masigi matungda Jisu amadi mahakki tung-inbasingna Judea-gi lamda chatlammi aduga mapham aduda Ibungona makhoiga loinana matam khara leiminnarammi amasung misingbu baptize toubirammi. ");
INSERT INTO mni_vpl VALUES ("JN3_23","073_3_23","JHN","3","23","23","Salim-dagi panglap laptana leiba Aenon-da ising marang kaina leibagi maramna John-nasu mapham aduda baptize tourammi. Misingna mahakki manakta chatlammi aduga mahakna makhoibu baptize toubirammi. ");
INSERT INTO mni_vpl VALUES ("JN3_24","073_3_24","JHN","3","24","24","(Masi John-bu keisumsangda thamdringeigi mamangdani.) ");
INSERT INTO mni_vpl VALUES ("JN3_25","073_3_25","JHN","3","25","25","John-gi tung-inba kharaga Jihudi amaga laininggi oiba isingna chamthokpagi maramda makhoi yetnarammi. ");
INSERT INTO mni_vpl VALUES ("JN3_26","073_3_26","JHN","3","26","26","Makhoina John-gi manakta chattuna John-da hairammi, “Oja Ibungo, Jordan-gi wangmada nahakka leiminnaramba nupa haibadi nahakna mahakki maramda haibikhiba mahak aduna houjik baptize toubiri aduga mi pumnamakna mahakki manakta chatli.” ");
INSERT INTO mni_vpl VALUES ("JN3_27","073_3_27","JHN","3","27","27","Maduda John-na khumlak-i, “Mapu Ibungona pibiba nattana kana amatana karisu phangba ngamloi. ");
INSERT INTO mni_vpl VALUES ("JN3_28","073_3_28","JHN","3","28","28","‘Eidi Christta adu natte, adubu eidi Ibungo mahakki mang thana thabirakpani’ haina eina haikhiba adu nakhoina khanglibaduni. ");
INSERT INTO mni_vpl VALUES ("JN3_29","073_3_29","JHN","3","29","29","Mou anoubi phangliba mahak adu bor aduni adubu bor adugi marup adudi mapham aduda bor adugidamak leijabani amadi mahakki khonjel tajaba aduni, marup aduna bor adugi khonjel tajabada adukki matik haraojei. Madugi haraoba adu eihakkini aduga haraoba adu houjik mapung phare. ");
INSERT INTO mni_vpl VALUES ("JN3_30","073_3_30","JHN","3","30","30","Ibungo mahakti chaokhatlakpa tai aduga eidi hantharakpa tai.” ");
INSERT INTO mni_vpl VALUES ("JN3_31","073_3_31","JHN","3","31","31","Mathaktagi lengthabirakpa Ibungo mahakti pumnamakki mathakta lei. Taibangpanbagi oiba mahak adudi taibangpanba asigini aduga mahakna taibangpanbagi oiba mi amagumna wa ngang-i adubu swargadagi lengthabirakpa Ibungo mahakti pumnamakki mathakta lei. ");
INSERT INTO mni_vpl VALUES ("JN3_32","073_3_32","JHN","3","32","32","Ibungo mahakna ukhraba amadi takhraba adu haibi adubu mi kana amatanadi Ibungogi wa adu loubide. ");
INSERT INTO mni_vpl VALUES ("JN3_33","073_3_33","JHN","3","33","33","Adum oinamak Ibungogi wa adubu lousinjaba makhoina Tengban Mapudi achumbani haibadu yajare. ");
INSERT INTO mni_vpl VALUES ("JN3_34","073_3_34","JHN","3","34","34","Tengban Mapuna thabirakpa mahak adudi Tengban Mapugi wa ngang-i maramdi Tengban Mapuna mangonda Thawai adu mapan naidana pibi. ");
INSERT INTO mni_vpl VALUES ("JN3_35","073_3_35","JHN","3","35","35","Mapa aduna mahakki Machanupa adubu nungsi aduga Machanupa adugi makhutta pumnamak sinnabire. ");
INSERT INTO mni_vpl VALUES ("JN3_36","073_3_36","JHN","3","36","36","Machanupa adubu thajaba mi aduna lomba naidaba hingba adu phangle; Machanupa adugi wa indaba mahak aduna hingba phangloi adubu Mapu Ibungogi asaoba mahakki mathakta leigani. ");
INSERT INTO mni_vpl VALUES ("JN4_1","073_4_1","JHN","4","1","1","Ibungona John-dagi mi masing henna tung-inbasing semduna baptize toure haiba Pharisee-singna tare haibasi Jisuna khangle. ");
INSERT INTO mni_vpl VALUES ("JN4_2","073_4_2","JHN","4","2","2","Asengbamakti Jisu masanadi makhoibu baptize touba natte mahakki tung inbasingna toubani. ");
INSERT INTO mni_vpl VALUES ("JN4_3","073_4_3","JHN","4","3","3","Maram asina Ibungona Judea thadoktuna Galilee-da amuk hallammi. ");
INSERT INTO mni_vpl VALUES ("JN4_4","073_4_4","JHN","4","4","4","Ibungogi khongchat adu Samaria phaoduna chatpa tarammi. ");
INSERT INTO mni_vpl VALUES ("JN4_5","073_4_5","JHN","4","5","5","Ibungona asum lakpada Sychar kouba Samaria-gi sahar amada thunglammi. Mapham adu Jacob-na mahakki machanupa Joseph-ta pikhiba lam machet adugi manaktani. ");
INSERT INTO mni_vpl VALUES ("JN4_6","073_4_6","JHN","4","6","6","Jacob-ki oiramba guha adu mapham aduda leirammi; Ibungona lamsang chatpadagi waraduna guha adugi manakta phamthare. Pungpham adu numit yungba matamni. ");
INSERT INTO mni_vpl VALUES ("JN4_7","073_4_7","JHN","4","7","7","Tanja aduda Samaria-gi nupi amana mapham aduda ising sokpa laklammi, maduda Ibungona mangonda hairak-i, “Eingonda thaknaba ising khara pibiyu.” ");
INSERT INTO mni_vpl VALUES ("JN4_8","073_4_8","JHN","4","8","8","(Matamdu Ibungogi tung-inbasingna khunggang aduda chana thaknaba leiba chatkhibagi maramna Ibungo mathantamak leirammi.) ");
INSERT INTO mni_vpl VALUES ("JN4_9","073_4_9","JHN","4","9","9","Maduda nupi aduna hairak-i, “Nahakti Jihudini aduga eina Samaria-gi nupini aduga kamdouna nahakna eingonda thaknaba ising piyu hairibano?” (Jihudisingdi Samaria-gi misingna sijinnaba kol-lik sijinnade.) ");
INSERT INTO mni_vpl VALUES ("JN4_10","073_4_10","JHN","4","10","10","Jisuna khumlak-i, “Nahakna Tengban Mapugi khudol adu khanglamlaba aduga nangonda thaknaba ising piyu hairiba mahak adu kanano haiba khanglamlabadi, nahakna mangonda nijaramgadabani aduga mahakna nangonda hingba piba ising adu pibiramgadabani.” ");
INSERT INTO mni_vpl VALUES ("JN4_11","073_4_11","JHN","4","11","11","Nupi aduna hairak-i, “Ibungo, guha asisu yamna lui aduga nangonda ising sokkatnaba kon amattasu yaode aduga kadaidagi hingba piba ising adu lougadouribano? ");
INSERT INTO mni_vpl VALUES ("JN4_12","073_4_12","JHN","4","12","12","Guha asibu piramba eikhoigi ipa ipu oiriba Jacob-tagi nahakna henna chaobra? Mahak masamak, machasing amadi mahakki sa sansingsu guha asigi ising thakkhi.” ");
INSERT INTO mni_vpl VALUES ("JN4_13","073_4_13","JHN","4","13","13","Maduda Jisuna khumlak-i, “Guha asigi ising thakpa mi khudingmak amuk khouranglakkani ");
INSERT INTO mni_vpl VALUES ("JN4_14","073_4_14","JHN","4","14","14","adubu eina piba ising adu thakpa mi khudingmak adudi makhoida khourangba amuk hanna leiraroi. Eina pigadaba ising aduna makhoida hingba piba iphut oiraktuna makhoida lomba naidaba hingba pibigani.” ");
INSERT INTO mni_vpl VALUES ("JN4_15","073_4_15","JHN","4","15","15","Nupi aduna hairak-i, “Ibungo, eingonda khourangba amuk leitanaba aduga mapham asida ising sokpa amuk laktanaba eingonda ising adu pibiyu.” ");
INSERT INTO mni_vpl VALUES ("JN4_16","073_4_16","JHN","4","16","16","Maduda Jisuna mangonda hairak-i, “Chatlu, nahakki napuroiba kouraklaga mapham asida lak-u.” ");
INSERT INTO mni_vpl VALUES ("JN4_17","073_4_17","JHN","4","17","17","Nupi aduna khumlak-i, “Eigi ipuroiba leijade.” Maduda Jisuna hairak-i, “Nahakki napuroiba leite haibadu achumbani. ");
INSERT INTO mni_vpl VALUES ("JN4_18","073_4_18","JHN","4","18","18","Achumbamakti, nahakki napuroiba manga leirammi aduga nahakka houjik leiminnariba nupa adusu nahakki napuroiba natte. Nahakna houjik haikhibadu yamna chummi.” ");
INSERT INTO mni_vpl VALUES ("JN4_19","073_4_19","JHN","4","19","19","Nupi aduna hairak-i, “Ibungo, nahak asi Mapu Ibungogi wa phongdokpa maichou ama oigani haiba eina khangjare. ");
INSERT INTO mni_vpl VALUES ("JN4_20","073_4_20","JHN","4","20","20","Eikhoi Samaria-gi ipa ipusingnadi Gerizim chingthak asida Tengban Mapubu khurumjei adubu nakhoi Jihudisingnadi Tengban Mapu khurumgadaba maphamdi Jerusalem-da oigadabani haina karigi hairibano?” ");
INSERT INTO mni_vpl VALUES ("JN4_21","073_4_21","JHN","4","21","21","Jisuna mangonda hairak-i, “Nupi, eibu thajou, nakhoina Ipa adubu ching asida chatlaga nattraga Jerusalem-da chatlaga khurumloidaba matam adu lakli. ");
INSERT INTO mni_vpl VALUES ("JN4_22","073_4_22","JHN","4","22","22","Nakhoi Samaria-singdi nakhoina khurumliba Mapu Ibungo mahakpu munna khangde adubu eikhoi Jihudisingdi eikhoina khurumliba Mapu Ibungo mahakpu khang-i maramdi aran-khubham asi Jihudisingdagi lakpani. ");
INSERT INTO mni_vpl VALUES ("JN4_23","073_4_23","JHN","4","23","23","Thamoi sengna khurumjaribasingna Ipa adubu thawaida amadi achumbada khurumgadaba matam adu lakli aduga matam adu houjik oisu oiri. Ipa aduna adugumna khurumjabasing adubu thiri. ");
INSERT INTO mni_vpl VALUES ("JN4_24","073_4_24","JHN","4","24","24","Tengban Mapudi Thawaini maram aduna Ibungo mahakpu khurumjabasingna thawaida amadi achumbada khurumjagadabani.” ");
INSERT INTO mni_vpl VALUES ("JN4_25","073_4_25","JHN","4","25","25","Nupi aduna Ibungoda hairak-i, “Christta kouba Messiah adu lakkani haiba eina khang-i aduga mahakna lakpa matamda mahakna eikhoida maram pumnamak loina sandokna takpigani.” ");
INSERT INTO mni_vpl VALUES ("JN4_26","073_4_26","JHN","4","26","26","Adudagi Jisuna mangonda hairak-i, “Nangonda wari sariba eihak asi mahak aduni.” ");
INSERT INTO mni_vpl VALUES ("JN4_27","073_4_27","JHN","4","27","27","Tanja adumaktada Jisugi tung-inbasing adu mapham aduda hallaklammi. Ibungona nupi amaga wari sanaramba adu ubada makhoi yamna ngaklammi adum oinamak “Ibungona mangondagi kari pambage?” nattraga “Ibungona karigi mahakka wari saribano?” haina makhoina Ibungoda hanglamde. ");
INSERT INTO mni_vpl VALUES ("JN4_28","073_4_28","JHN","4","28","28","Nupi aduna mahakki ising pun adu guha manakta thanamlaga mahakki khunda chenkhiduna khundugi misingda hairammi, ");
INSERT INTO mni_vpl VALUES ("JN4_29","073_4_29","JHN","4","29","29","“Eina toukhi toukhiba khudingmak eingonda loina haibiba nupa ama yeng-u lao. Mahaksibu Christta adu oiramgadra?” ");
INSERT INTO mni_vpl VALUES ("JN4_30","073_4_30","JHN","4","30","30","Maram aduna miyam aduna khun adudagi thoraktuna Jisugi manakta laklammi. ");
INSERT INTO mni_vpl VALUES ("JN4_31","073_4_31","JHN","4","31","31","Cheirak aduda Jisugi tung-inbasingna Jisuda kanna haijarammi, “Oja Ibungo, khara chabiyu.” ");
INSERT INTO mni_vpl VALUES ("JN4_32","073_4_32","JHN","4","32","32","Maduda Ibungona khumlak-i, “Nakhoina sungkhang khangdaba eigi chanaba chinjak leire.” ");
INSERT INTO mni_vpl VALUES ("JN4_33","073_4_33","JHN","4","33","33","Maram aduna Ibungogi tung-inbasing aduna makhoi masel amaga amaga hangnarammi, “Eikhoina chatthoklingeida kanagumba amana Ibungogi chanaba puraklamba oigadra?” ");
INSERT INTO mni_vpl VALUES ("JN4_34","073_4_34","JHN","4","34","34","Jisuna makhoida hairak-i, “Eigi chinjakti eibu thabirakpa Ibungo mahakki aningba touba amadi mahakki thabakpu mapung phana loisinba aduni. ");
INSERT INTO mni_vpl VALUES ("JN4_35","073_4_35","JHN","4","35","35","Nakhoina asumna hainaba nattra, ‘Tha mari leiraga lourok tha oirani?’ Adubu eina nakhoida hairi, loubuksing asida yeng-u! Makhoi khoingang sare khaoba yare. ");
INSERT INTO mni_vpl VALUES ("JN4_36","073_4_36","JHN","4","36","36","Maru hunba mahakka akhaoba mahakka punna haraominnanaba, akhaoba mahak adu khutsuman phang-i amasung lomba naidaba hingbagi mahei khomjilli. ");
INSERT INTO mni_vpl VALUES ("JN4_37","073_4_37","JHN","4","37","37","Hainaba asi achumbani, ‘Kanagumba mi amana maru hulli aduga atoppa kanagumba mi amana khao-i.’ ");
INSERT INTO mni_vpl VALUES ("JN4_38","073_4_38","JHN","4","38","38","Nakhoina thabak suba yaorudaba loubukta khaorunanaba eina nakhoibu thare. Atoppa misingna awaba thabaksing adu subiramle aduga makhoina subirambagi kannaba adu nakhoina phangle.” ");
INSERT INTO mni_vpl VALUES ("JN4_39","073_4_39","JHN","4","39","39","“Eina toukhi toukhiba khudingmak mahakna eingonda loina haibi” haina nupi aduna haibagi maramna khun adugi Samaria macha mayam amana Jisubu thajarammi. ");
INSERT INTO mni_vpl VALUES ("JN4_40","073_4_40","JHN","4","40","40","Makhoina Ibungogi manakta lakpa matamda, Ibungobu makhoiga leiminnanaba makhoina Ibungoda kanna haijarammi, maram aduna Ibungona mapham aduda numit nini amaga leire. ");
INSERT INTO mni_vpl VALUES ("JN4_41","073_4_41","JHN","4","41","41","Aduga atoppa mi mayam amasu Ibungona haiba wa tabadagi thajare. ");
INSERT INTO mni_vpl VALUES ("JN4_42","073_4_42","JHN","4","42","42","Makhoina nupi aduda hairak-i, “Houjikti nahakna haiba khaktadagi eikhoina thajaba nattre adubu eikhoi isamak Ibungona haiba tajare. Tasengnamak Ibungo mahak asi taibangpan asigi Kanbiba Mapu aduni.” ");
INSERT INTO mni_vpl VALUES ("JN4_43","073_4_43","JHN","4","43","43","Mapham aduda numit nini leiramlaba matungda, Jisuna Galilee-da chatlammi. ");
INSERT INTO mni_vpl VALUES ("JN4_44","073_4_44","JHN","4","44","44","Ibungo masamakna asumna haikhi, “Mapu Ibungogi wa phongdokpa maichousingdi makhoi masagi lamsingda ikai khumnabide.” ");
INSERT INTO mni_vpl VALUES ("JN4_45","073_4_45","JHN","4","45","45","Ibungona Galilee-da thungba matamda mapham adugi misingna Ibungobu taramna oklammi maramdi makhoina Lanthokpibagi chakkhangbagi thouramgidamak Jerusalem-da chatlubada mapham aduda Ibungona toukhiba thabak pumnamak loina makhoina ukhibagini. ");
INSERT INTO mni_vpl VALUES ("JN4_46","073_4_46","JHN","4","46","46","Jisuna isingbu anggur mahi olhanbikhiba mapham Galilee-gi Cana kouba khun aduda Ibungona amuk hanna chatlammi. Aduga Capernaum-da leiba ningthougi phamnaiba amagi machanupa ama narammi. ");
INSERT INTO mni_vpl VALUES ("JN4_47","073_4_47","JHN","4","47","47","Jisuna Judea-dagi Galilee-da lakle haiba tabadagi mahakki sigadabagi phibamda nariba machanupa adubu phahanbinaba mahakna Jisugi manakta chattuna Capernaum-da lakpinanaba haijarammi. ");
INSERT INTO mni_vpl VALUES ("JN4_48","073_4_48","JHN","4","48","48","Maduda Jisuna mangonda hairak-i, “Nakhoina khudamsing amadi angak angakpasing udriba phaoba nakhoina keidounungda thajaroi.” ");
INSERT INTO mni_vpl VALUES ("JN4_49","073_4_49","JHN","4","49","49","Phamnaiba aduna khumlak-i, “Ibungo, eigi angang adu sidringeida lakpiyu.” ");
INSERT INTO mni_vpl VALUES ("JN4_50","073_4_50","JHN","4","50","50","Jisuna mangonda hairak-i, “Nayumda hallo, nahakki nachanupa naba pharagani.” Maduda phamnaiba aduna Jisuna mangonda haibiba wahei adu thajaduna mahakki mayumda chatpa hourammi. ");
INSERT INTO mni_vpl VALUES ("JN4_51","073_4_51","JHN","4","51","51","Mahakna hallakpagi lambida leireingeida mahakki macha adu naba phaduna hingle haibagi pao mahakki manaisingna mangonda puraklammi. ");
INSERT INTO mni_vpl VALUES ("JN4_52","073_4_52","JHN","4","52","52","Karamba matamda angang adu phagatlakkhibage hangbada makhoina khumlak-i, “Ngarang numit yungba matung pung ama taba matamda mahakki laihou adu khanghoudana thakhre.” ");
INSERT INTO mni_vpl VALUES ("JN4_53","073_4_53","JHN","4","53","53","Maduda Jisuna mangonda, “Nahakki nachanupa adu pharagani” haibikhiba pungja adumaktadani haiba mapa aduna khangle. Maram aduna mahak amadi mahakki imung manung loina Jisubu thajare. ");
INSERT INTO mni_vpl VALUES ("JN4_54","073_4_54","JHN","4","54","54","Masi Jisuna Judea-dagi Galilee-da laklaba matungda touba anisuba angakpa khudamni. ");
INSERT INTO mni_vpl VALUES ("JN5_1","073_5_1","JHN","5","1","1","Masigi matung matam khara leiraga Jisuna Jihudisinggi chakkhangba amagidamak Jerusalem-da chatlammi. ");
INSERT INTO mni_vpl VALUES ("JN5_2","073_5_2","JHN","5","2","2","Jerusalem-da leiba Yaogi Thong adugi manakta hojang manga leiba pukhri ama lei; pukhri adu Hebrew londa Bethesda kou-i. ");
INSERT INTO mni_vpl VALUES ("JN5_3","073_5_3","JHN","5","3","3","Hojangsing aduda anaba mayam ama leirammi; makhoi kharana mit tangba, kharana khong tekpa amadi pangthaduna nabasing oirammi. Makhoina pukhri adugi ising adu lenglakpa ngairammi. ");
INSERT INTO mni_vpl VALUES ("JN5_4","073_5_4","JHN","5","4","4","Maramdi marak marakta Mapu Ibungogi dut amana kumtharaktuna ising adu leng-halli aduga ising adu lenglingeida pukhri aduda i-han hanna kumthaba mi aduda leiramba leina ama hekta oirabasu pharammi. ");
INSERT INTO mni_vpl VALUES ("JN5_5","073_5_5","JHN","5","5","5","Mapham aduda chahi kunthranipan chupna naraklaba nupa ama leirammi. ");
INSERT INTO mni_vpl VALUES ("JN5_6","073_5_6","JHN","5","6","6","Mahakna mapham aduda hiptuna leibadu ubada mahak asi kuina naraklaba mini haiba Jisuna khangladuna mangonda hanglak-i, “Nahak phaningbra?” ");
INSERT INTO mni_vpl VALUES ("JN5_7","073_5_7","JHN","5","7","7","Anaba mi aduna khumlak-i, “Ibungo, ising asi leng-hallakpa matamda eibu pukhri asida puthabinaba eigidamak kanagumba amata leijade. Aduga eina kumthanaba hotnaringeida atoppa mi amana hanna hekta kumthakhi.” ");
INSERT INTO mni_vpl VALUES ("JN5_8","073_5_8","JHN","5","8","8","Maduda Jisuna mangonda hairak-i, “Hougatlu, nahakki hipnapham adu loukhatlaga chatlu!” ");
INSERT INTO mni_vpl VALUES ("JN5_9","073_5_9","JHN","5","9","9","Khudak aduda nupa adugi anaba adu phare aduga mahakna mahakki hipnapham adu loukhattuna chatpa hourammi. Angakpa thoudok asi potthaba numitta thokkhibani. ");
INSERT INTO mni_vpl VALUES ("JN5_10","073_5_10","JHN","5","10","10","Maram aduna anaba phakhiba nupa aduda Jihudigi luchingbasingna hairak-i, “Ngasi asi potthaba numitni aduna potthaba numitta nahakna nahakki hipnapham puba adu wayel yathangna ayaba pide.” ");
INSERT INTO mni_vpl VALUES ("JN5_11","073_5_11","JHN","5","11","11","Maduda mahakna khumlak-i, “Eibu phahanbiba nupa aduna eingonda, ‘Nahakki hipnapham adu loukhatlaga chatlu,’ haina eingonda haibirak-i.” ");
INSERT INTO mni_vpl VALUES ("JN5_12","073_5_12","JHN","5","12","12","Makhoina nupa aduda hanglak-i, “Nangonda nahakki hipnapham adu loukhatlaga chatlu hairakliba nupa adu kanano?” ");
INSERT INTO mni_vpl VALUES ("JN5_13","073_5_13","JHN","5","13","13","Adubu anaba phakhiba nupa adunadi Jisubu kanano haiba khanglamde maramdi Jisuna mapham aduda leiramba miyamsing adugi marakta changsillaga litthokkhirammi. ");
INSERT INTO mni_vpl VALUES ("JN5_14","073_5_14","JHN","5","14","14","Madugi matungda Jisuna mahakpu ningnasangda thengnare aduga mangonda hairak-i, “Yeng-u, houjik nahak phare maram aduna nahak pap amuk hanna touraganu nattrabadi nangonda henna phattaba thoklakpa yai.” ");
INSERT INTO mni_vpl VALUES ("JN5_15","073_5_15","JHN","5","15","15","Adudagi nupa aduna Jihudigi luchingbasing adugi manakta chattuna mahakpu anaba phahanbiba nupa adu Jisuni haina pao tamlure. ");
INSERT INTO mni_vpl VALUES ("JN5_16","073_5_16","JHN","5","16","16","Jisuna asigumba thabaksing asi potthaba numitta toubagi maramna makhoina Jisubu ot-neiba houre. ");
INSERT INTO mni_vpl VALUES ("JN5_17","073_5_17","JHN","5","17","17","Adubu Jisuna makhoida hairak-i, “Eigi Ipadi matam pumnamakta thabak tou-i maram aduna eihaksu thabak touba tabani.” ");
INSERT INTO mni_vpl VALUES ("JN5_18","073_5_18","JHN","5","18","18","Maram asina Jihudigi luchingbasingna Ibungobu hatnanaba henna kanna hotnarammi maramdi potthaba numitpu Ibungona thugaiba khakta nattana Tengban Mapubu mahakmakki Mapa haina kouduna mahak masamakpu Tengban Mapuga mannahalli. ");
INSERT INTO mni_vpl VALUES ("JN5_19","073_5_19","JHN","5","19","19","Maram aduna Jisuna makhoida hairak-i, “Eina nakhoida tasengna hairiba asini, Machanupa adu mahak masana karisu touba ngamde adubu mahakki Mapa aduna touri touriba adu uba adukhakta mahakna tou-i. Mapa aduna touba touba makhei Machanupa adunasu tou-i. ");
INSERT INTO mni_vpl VALUES ("JN5_20","073_5_20","JHN","5","20","20","Maramdi Mapa aduna Machanupa adubu nungsi amadi mahak masana touriba pumnamak Machanupa aduda utpi. Masidagi henna chaoba thabaksing phaoba mahakna Machanupa aduda utpigani maduda nakhoi angakpa oigani. ");
INSERT INTO mni_vpl VALUES ("JN5_21","073_5_21","JHN","5","21","21","Mapa aduna sibadagi hinggat-hanbiba makhoida mahakna hingba pibibagumna Machanupa adunasu mahakna piningba makhoida hingba pibi. ");
INSERT INTO mni_vpl VALUES ("JN5_22","073_5_22","JHN","5","22","22","Madugisu mathakta Mapa aduna kanagumba amatabu wayende adubu wayel pumba Machanupa aduda sinnei, ");
INSERT INTO mni_vpl VALUES ("JN5_23","073_5_23","JHN","5","23","23","masina Mapa aduda ikai khumnabagum Machanupa adudasu ikai khumnanabani. Machanupa adubu ikai khumnadaba mahak aduna Machanupa adubu thabirakliba Mapa adubusu ikai khumnade. ");
INSERT INTO mni_vpl VALUES ("JN5_24","073_5_24","JHN","5","24","24","“Eina nakhoida tasengnamak hairiba asini, eigi wa taba amadi eibu thabirakpa Ibungo mahakpu thajaba makhoi adu lomba naidaba hingba phangle. Makhoigi mathakta wayenba leiraroi; makhoidi sibadagi hingbada hannana lanthokkhre. ");
INSERT INTO mni_vpl VALUES ("JN5_25","073_5_25","JHN","5","25","25","Eina nakhoida tasengnamak hairiba asini, asibasingna Tengban Mapugi Machanupa adugi khonjel adu tagadaba matam adu lakli thanggeisengnamakti matam adu houjik oire aduga khonjel adu tabasingna hingjagani. ");
INSERT INTO mni_vpl VALUES ("JN5_26","073_5_26","JHN","5","26","26","Mapa masamak adu hingbagi hourakpham oiba adugumna Ibungo mahaknasu mahakki Machanupa adubu hingbagi hourakpham oihalli. ");
INSERT INTO mni_vpl VALUES ("JN5_27","073_5_27","JHN","5","27","27","Aduga mahak asi Migi Machanupa oibagi maramna Mapa aduna mangonda wayennabagi matik pibire. ");
INSERT INTO mni_vpl VALUES ("JN5_28","073_5_28","JHN","5","28","28","Masida nakhoi ngakkanu, asibasingna Migi Machanupa adugi khonjel tagadaba matam adu lakli ");
INSERT INTO mni_vpl VALUES ("JN5_29","073_5_29","JHN","5","29","29","aduga makhoina makhoigi mongphamsingdagi thorakkani: aphaba toukhibasingna hingnanaba hougatlakkani aduga phattaba toukhibasingna maral leire haibagi wayen phangnanaba hougatlakkani. ");
INSERT INTO mni_vpl VALUES ("JN5_30","073_5_30","JHN","5","30","30","“Ei isa ithantana karisu touba ngamde; Mapu Ibungona eingonda haibiraklaga eina wayelli. Eigi wayendi achumbani maramdi eina eigi aningba adu toude adubu eibu thabirakpa Ibungo mahakki aningba adu tou-i. ");
INSERT INTO mni_vpl VALUES ("JN5_31","073_5_31","JHN","5","31","31","“Eina isagi maramda haijarabadi, eina haijariba adu chatnaba yaroi. ");
INSERT INTO mni_vpl VALUES ("JN5_32","073_5_32","JHN","5","32","32","Adubu kanagumba amana eigi maramda haibiri aduga mahakna eigi maramda hairiba pumnamak adu achumbani haiba eina khang-i. ");
INSERT INTO mni_vpl VALUES ("JN5_33","073_5_33","JHN","5","33","33","Nakhoina John-gi maphamda thijinba mi tharure aduga mahakna achumba adugi maramda haire. ");
INSERT INTO mni_vpl VALUES ("JN5_34","073_5_34","JHN","5","34","34","Adubu mioibana eigi maramda haibiba adu eina louba natte adubu nakhoina kanbiba phangnanaba eina masi haibani. ");
INSERT INTO mni_vpl VALUES ("JN5_35","073_5_35","JHN","5","35","35","John-di chaktuna ngalliba thaomei amagum oirammi aduga nakhoina mahakki mangal aduda matam kharagi oina harao nungaiba pambani. ");
INSERT INTO mni_vpl VALUES ("JN5_36","073_5_36","JHN","5","36","36","Adubu John-na eigi maramda haibiba adudagi henna chaoba eigi maramda haibiba lei madudi eina touba thabaksingni haibadi Ipana eingonda mapung phana loisinnaba pibirakpa thabaksing asina eibu Ipana thabirakpani haiba utpi. ");
INSERT INTO mni_vpl VALUES ("JN5_37","073_5_37","JHN","5","37","37","Aduga eibu thabirakpa Ipa adunasu eigi maramda haibi. Nakhoinadi Ibungo mahakki khonjel amukta takhidri aduga mahakki maithongsu ukhidri, ");
INSERT INTO mni_vpl VALUES ("JN5_38","073_5_38","JHN","5","38","38","amadi nakhoigi thamoinungda Ibungo mahakki wahei leite maramdi Ibungona tharakpa mahak adubu nakhoina thajade. ");
INSERT INTO mni_vpl VALUES ("JN5_39","073_5_39","JHN","5","39","39","Nakhoina Mapugi puyabu thawai yaona neinei maramdi puyaduda nakhoina lomba naidana hingba adu phanggani haina khalli. Adubu Mapugi puya adumakna eigi maramda hairi! ");
INSERT INTO mni_vpl VALUES ("JN5_40","073_5_40","JHN","5","40","40","Aduga nakhoina hingba phangjanaba eigi inakta lakpasu lakningde. ");
INSERT INTO mni_vpl VALUES ("JN5_41","073_5_41","JHN","5","41","41","“Eidi mioibagi thagatpa adu thide. ");
INSERT INTO mni_vpl VALUES ("JN5_42","073_5_42","JHN","5","42","42","Adubu eina nakhoibu khang-i. Nakhoigi thamoinungda Tengban Mapubu nungsiba adu leite haiba eina khang-i. ");
INSERT INTO mni_vpl VALUES ("JN5_43","073_5_43","JHN","5","43","43","Eina eigi Ipagi mingda nakhoigi nakta lakle adubu nakhoina eibu lousinbide aduga kanagumba amana masagi mingda laklabadi nakhoina mahakpu lousin-gani. ");
INSERT INTO mni_vpl VALUES ("JN5_44","073_5_44","JHN","5","44","44","Amatta ngairaba Tengban Mapu mangondagi thagatpa phangnaba nakhoina hotnadraga nakhoi nasen amana amadagi thagatnaba lounaba pamliba nakhoina kamdouna eibu thajaba ngamgani. ");
INSERT INTO mni_vpl VALUES ("JN5_45","073_5_45","JHN","5","45","45","Ipagi maphamda nakhoibu maral sigadaba misak adu eini haina nakhoina khan-ganu. Nakhoina thajaba thamjariba Moses masamakna nakhoibu maral sigani. ");
INSERT INTO mni_vpl VALUES ("JN5_46","073_5_46","JHN","5","46","46","Nakhoina Moses-pu tasengna thajaramlabadi, nakhoina eibu thajaramgadabani maramdi mahakna eigi maramda irammi. ");
INSERT INTO mni_vpl VALUES ("JN5_47","073_5_47","JHN","5","47","47","Adubu mahakna iramba adu nakhoina thajadrabadi kamdouna eina haiba wa nakhoina thajagadage?” ");
INSERT INTO mni_vpl VALUES ("JN6_1","073_6_1","JHN","6","1","1","Masigi matung matam khara leiraga Jisuna Tiberias-gi pat hainasu khangnaba Galilee-gi pat adugi wangmada lanthoktuna chatlammi. ");
INSERT INTO mni_vpl VALUES ("JN6_2","073_6_2","JHN","6","2","2","Yamkhraba miyam amana Ibungogi tung induna chatlammi maramdi Ibungona anaba phahanbagi angakpa khudamsing adu makhoina ubagini. ");
INSERT INTO mni_vpl VALUES ("JN6_3","073_6_3","JHN","6","3","3","Adudagi Jisuna ching amada kakhattuna mahakki tung-inbasingga loinana mapham aduda phamlammi. ");
INSERT INTO mni_vpl VALUES ("JN6_4","073_6_4","JHN","6","4","4","Jihudisinggi Lanthokpibagi Chakkhangba matam adu naksillaklammi. ");
INSERT INTO mni_vpl VALUES ("JN6_5","073_6_5","JHN","6","5","5","Ibungona yengkhatlakpada yamlaba miyam amana Ibungogi nakta lakpa adu urabada Ibungona Philip-ta onsillaklaga hairak-i, “Makhoising asi pijananaba tal eikhoina kadaidagi leigadage?” ");
INSERT INTO mni_vpl VALUES ("JN6_6","073_6_6","JHN","6","6","6","Ibungona kari tougadabano haiba hannana khanglabani adubu Philip-pu chang yengnanaba Ibungona masi haibani. ");
INSERT INTO mni_vpl VALUES ("JN6_7","073_6_7","JHN","6","7","7","Maduda Philip-na khumlak-i, “Sinmi amagi tha nipanmukki khutsuman-gi peisana pijananaba tal adu leiraba phaoba makhoi khudingmakna khajik khajiktang charabasu konnaroi.” ");
INSERT INTO mni_vpl VALUES ("JN6_8","073_6_8","JHN","6","8","8","Ibungogi tung-inba ama oiriba aduga Simon Peter-gidi manaonupa Andrew-na Ibungoda hairak-i, ");
INSERT INTO mni_vpl VALUES ("JN6_9","073_6_9","JHN","6","9","9","“Barley-gi tal manga amadi nga macha ani yaoriba nupamacha ama mapham asida leire. Adubu asuk yamkhraba miyam asida asising asinadi kari tourugani?” ");
INSERT INTO mni_vpl VALUES ("JN6_10","073_6_10","JHN","6","10","10","Maduda Jisuna makhoida hairak-i, “Miyam adu phamthahallu.” Mapham aduda napi marang kaina hourammi. Maram aduna makhoi phamthare. (Nupa khaktada lising mangamukni.) ");
INSERT INTO mni_vpl VALUES ("JN6_11","073_6_11","JHN","6","11","11","Adudagi Jisuna tal adu louraga Mapu Ibungobu thagatle aduga phamliba miyam aduda yenthokle. Matou adugumna ngasing adusu yenthokle aduga makhoi loina oktri phaoba chare. ");
INSERT INTO mni_vpl VALUES ("JN6_12","073_6_12","JHN","6","12","12","Makhoina mapuk thanna charabada, Jisuna mahakki tung-inbasingda hairak-i, “Kari amata manghan-ganu; lemhouba machet makaising adu khomjillu.” ");
INSERT INTO mni_vpl VALUES ("JN6_13","073_6_13","JHN","6","13","13","Maram aduna makhoina lemhouba machet makaising adu khomjille amasung miyam aduna barley-gi tal manga adudagi chakhraga lemhouba machet makaising aduna thumok taranithoi thalle. ");
INSERT INTO mni_vpl VALUES ("JN6_14","073_6_14","JHN","6","14","14","Mising aduna Ibungona touba angakpa khudam adu ubada makhoina hairak-i. “Tasengnamak taibangpan asida lengbirakkadaba Mapu Ibungogi wa phongdokpa Maichou adu mahak asini.” ");
INSERT INTO mni_vpl VALUES ("JN6_15","073_6_15","JHN","6","15","15","Makhoina Ibungobu pharaga namphuda ningthou semgadoure haiba khangladuna Ibungona matomta ching amada chatthokkhre. ");
INSERT INTO mni_vpl VALUES ("JN6_16","073_6_16","JHN","6","16","16","Numidangwairam oiraklabada Jisugi tung-inbasingna patta kumthare ");
INSERT INTO mni_vpl VALUES ("JN6_17","073_6_17","JHN","6","17","17","aduga hi amada tonglaga Capernaum-gidamak pat adugi wangmada chatlammi. Matam adu mamsinkhre adubu Jisudi makhoigi manakta laktri. ");
INSERT INTO mni_vpl VALUES ("JN6_18","073_6_18","JHN","6","18","18","Matam aduda akanba nungsit ama laktuna pat adu ithak hourammi. ");
INSERT INTO mni_vpl VALUES ("JN6_19","073_6_19","JHN","6","19","19","Ibungogi tung-inbasingna mile ahum marirom hi hollaba matungda Jisuna ising mathakta khongna chattuna hi adugi manakta changsillakpa adu makhoina ubada makhoi yamna kirammi. ");
INSERT INTO mni_vpl VALUES ("JN6_20","073_6_20","JHN","6","20","20","Maduda Jisuna makhoida hairak-i, “Eini, kiganu.” ");
INSERT INTO mni_vpl VALUES ("JN6_21","073_6_21","JHN","6","21","21","Adudagi makhoina yaningna Ibungobu hida changhalle aduga khudak aduda hi adu makhoina chatliba mapham adugi torbanda thungle. ");
INSERT INTO mni_vpl VALUES ("JN6_22","073_6_22","JHN","6","22","22","Mathanggi numitta pat adugi wangmada leihouba mising aduna mapham aduda hi amakhakta leirambani aduga hi aduda Jisugi tung-inbasingna chatkhibada Jisudi yaokhide haiba makhoina khanglammi. ");
INSERT INTO mni_vpl VALUES ("JN6_23","073_6_23","JHN","6","23","23","Mapu Ibungobu thagatcharaba matungda misingna tal chakhiba mapham adugi manakki torbanda Tiberias-tagi hi khara laklammi. ");
INSERT INTO mni_vpl VALUES ("JN6_24","073_6_24","JHN","6","24","24","Miyam aduna Jisu amadi mahakki tung-inbasing mapham aduda leitre haiba khanglabada makhoina hising aduda tonglaga Capernaum tana Ibungobu thiba chatlammi. ");
INSERT INTO mni_vpl VALUES ("JN6_25","073_6_25","JHN","6","25","25","Aduga makhoina pat adugi wangmada Jisubu phanglabada makhoina Ibungoda hairak-i, “Oja Ibungo, karamba matamda Ibungona mapham sida lengbirakpage?” ");
INSERT INTO mni_vpl VALUES ("JN6_26","073_6_26","JHN","6","26","26","Jisuna makhoida khumlak-i, “Eina nakhoida tasengnamak hairibasini, nakhoina angakpa khudamsing adu khangbagi maramna nakhoina eibu thirakpa natte adubu nakhoina tal pukthanna chakhibagi maramnani. ");
INSERT INTO mni_vpl VALUES ("JN6_27","073_6_27","JHN","6","27","27","Manggadaba chinjakkidamak thabak suganu adubu lomba naidaba hingba phaoba leiba chinjak adugidamak thabaksu. Masigi chinjak asidi Migi Machanupa aduna nakhoida pibigani maramdi Tengban Mapu Mapa Ibungo aduna mangonda yabibagi khudam nambire.” ");
INSERT INTO mni_vpl VALUES ("JN6_28","073_6_28","JHN","6","28","28","Maram aduna makhoina Ibungoda hanglak-i, “Eikhoina Tengban Mapugi thabaksing adu tounaba eikhoina kari touba tabage?” ");
INSERT INTO mni_vpl VALUES ("JN6_29","073_6_29","JHN","6","29","29","Maduda Jisuna khumlak-i, “Ibungo mahakna thabiraklaba mahak adubu nakhoina thajaba haiba asi Tengban Mapugi thabak aduni.” ");
INSERT INTO mni_vpl VALUES ("JN6_30","073_6_30","JHN","6","30","30","Makhoina khumlak-i, “Eikhoina ujaraga Ibungobu thajanaba Ibungona kari angakpa khudam toubigani? Ibungona kari toubigani? ");
INSERT INTO mni_vpl VALUES ("JN6_31","073_6_31","JHN","6","31","31","‘Mahakna makhoida swargadagi chanaba tal pibikhi’ haina Mapu Ibungogi puyada ibagumna eikhoigi ipa ipusingna leikanglada leiringeida makhoina manna chakhi.” ");
INSERT INTO mni_vpl VALUES ("JN6_32","073_6_32","JHN","6","32","32","Maduda Jisuna hairak-i, “Eina nakhoida tasengnamak hairibasini, swargadagi tal pikhiba adu Moses-na natte adubu eigi Ipana nakhoida swargadagi achumba tal adu pibi. ");
INSERT INTO mni_vpl VALUES ("JN6_33","073_6_33","JHN","6","33","33","Tengban Mapugi tal adudi swargadagi kumtharakpa amadi taibangpanda hingba pibiba mahak aduni.” ");
INSERT INTO mni_vpl VALUES ("JN6_34","073_6_34","JHN","6","34","34","Makhoina hairak-i, “Ibungo, tal adu matam pumnamakta eikhoida pibiyu.” ");
INSERT INTO mni_vpl VALUES ("JN6_35","073_6_35","JHN","6","35","35","Maduda Jisuna makhoida hairak-i, “Hingbagi tal adu eini. Eingonda lakpa mi adu keidoungeidasu lamlaroi; eingonda thajaba mi adu keidoungeidasu khouranglaroi. ");
INSERT INTO mni_vpl VALUES ("JN6_36","073_6_36","JHN","6","36","36","Adubu eina nakhoida hannana haikhre adudi nakhoina eibu ukhre adubu houjiksu nakhoina thajade. ");
INSERT INTO mni_vpl VALUES ("JN6_37","073_6_37","JHN","6","37","37","Eigi Ipana eingonda pibiba makhoi pumnamak adu eingonda lakkani aduga eingonda lakpa mi amatabu eina khak tanthokloi. ");
INSERT INTO mni_vpl VALUES ("JN6_38","073_6_38","JHN","6","38","38","Maramdi eina eigi aningba tounaba swargadagi kumtharakpa natte adubu eibu thabirakpa Ibungo mahakki aningba tounanaba kumtharakpani. ");
INSERT INTO mni_vpl VALUES ("JN6_39","073_6_39","JHN","6","39","39","Eibu thabirakpa Ibungo mahakki aningba adudi asini, Ibungo mahakna eingonda pibikhraba makhoi kana amatabu eina mang-handaduna aroiba numitta makhoibu hinggat-hanba aduni. ");
INSERT INTO mni_vpl VALUES ("JN6_40","073_6_40","JHN","6","40","40","Eigi Ipagi aningba adudi Machanupa adubu ujaba amadi Ibungo mahakpu thajaba makhoi pumnamakna lomba naidaba hingba phangbani aduga eina makhoibu aroiba numitta hinggat-hanbigani.” ");
INSERT INTO mni_vpl VALUES ("JN6_41","073_6_41","JHN","6","41","41","“Swargadagi kumtharakpa tal adu eini” haina Ibungona haibagi maramna Jihudisingna Ibungogi maramda yaningdabagi murum murum sonba hourammi. ");
INSERT INTO mni_vpl VALUES ("JN6_42","073_6_42","JHN","6","42","42","“Mahak asi Joseph-ki machanupa Jisu adu nattra? Mahakki mama mapa eikhoina khang-i. Aduga kamdouna mahakna ‘Ei swargadagi kumtharakpani’ haina hairibano?” ");
INSERT INTO mni_vpl VALUES ("JN6_43","073_6_43","JHN","6","43","43","Maduda Jisuna khumlak-i, “Nakhoi nasen-gi narakta murum murum sonnariba adu leppu. ");
INSERT INTO mni_vpl VALUES ("JN6_44","073_6_44","JHN","6","44","44","Eibu thabirakpa Ipa aduna chingsinbidrabadi kanagumba amatana eigi inakta lakpa ngamde aduga aroiba numitta eina makhoibu hinggat-hanbigani. ");
INSERT INTO mni_vpl VALUES ("JN6_45","073_6_45","JHN","6","45","45","Mapu Ibungogi wa phongdokpibasingna asumna irammi, ‘Tengban Mapuna makhoi pumnamakpu tambigani.’ Ipagi khonjel taba amadi Ibungo mangondagi tamjaba makhoina eingonda lakkani. ");
INSERT INTO mni_vpl VALUES ("JN6_46","073_6_46","JHN","6","46","46","Masina Ipa adubu kanagumba amana ukhare haibadi natte; Tengban Mapudagi lakpa mahak adu khaktana Ipa adubu ukhre. ");
INSERT INTO mni_vpl VALUES ("JN6_47","073_6_47","JHN","6","47","47","Eina nakhoida tasengnamak hairibasini, eibu thajaba mahak aduna lomba naidaba hingba phangle. ");
INSERT INTO mni_vpl VALUES ("JN6_48","073_6_48","JHN","6","48","48","Hingbagi tal adu eini. ");
INSERT INTO mni_vpl VALUES ("JN6_49","073_6_49","JHN","6","49","49","Nakhoigi napa napusingna lamjao lamhangda manna chakhi adubu makhoi sikhi. ");
INSERT INTO mni_vpl VALUES ("JN6_50","073_6_50","JHN","6","50","50","Adubu kanagumba amana swargadagi kumtharakpa tal adu charabadi mahak siraroi. ");
INSERT INTO mni_vpl VALUES ("JN6_51","073_6_51","JHN","6","51","51","Swargadagi kumtharakpa ahingba tal adu eini. Kanagumbana tal asi charabadi mahak lomba naidana hinggani. Taibangpan asina hingjanaba eina pigadouriba tal adu eigi hakchangni.” ");
INSERT INTO mni_vpl VALUES ("JN6_52","073_6_52","JHN","6","52","52","Masina Jihudisinggi marakta kanna yetnaduna hainarak-i, “Kamdouna mi asina eikhoida mahakki hakchangbu chanaba oina pigadouribano?” ");
INSERT INTO mni_vpl VALUES ("JN6_53","073_6_53","JHN","6","53","53","Maduda Jisuna makhoida hairak-i, “Eina nakhoida tasengnamak hairibasini, nakhoina Migi Machanupa adugi hakchang adu chadraba aduga mahakki ee adu thaktrabadi nakhoida hingba leiroi. ");
INSERT INTO mni_vpl VALUES ("JN6_54","073_6_54","JHN","6","54","54","Adubu eigi hakchang charaba amadi eigi ee thaklaba mi aduna lomba naidana hingba phangle aduga eina mahakpu aroiba numitta hinggat-hanbigani. ");
INSERT INTO mni_vpl VALUES ("JN6_55","073_6_55","JHN","6","55","55","Eigi hakchangdi tasengnamak chinjakni aduga eigi eedi tasengnamak thaknabani. ");
INSERT INTO mni_vpl VALUES ("JN6_56","073_6_56","JHN","6","56","56","Eigi hakchangbu chaba amadi eigi eebu thakpa makhoina eingonda lei aduga eina makhoida lei. ");
INSERT INTO mni_vpl VALUES ("JN6_57","073_6_57","JHN","6","57","57","Ahingba Ipa aduna eibu thabirakpani aduga Ibungo mahakki maramna ei hingbani, matou adugumna eibu chaba mahak aduna eigi maramna hinggani. ");
INSERT INTO mni_vpl VALUES ("JN6_58","073_6_58","JHN","6","58","58","Masini swargadagi kumtharaklaba tal adu. Nakhoigi napa napusingna manna chakhi aduga sikhi adubu tal asi chaba mahak adudi lomba naidana hinggani.” ");
INSERT INTO mni_vpl VALUES ("JN6_59","073_6_59","JHN","6","59","59","Waramsing asi Ibungona Capernaum-da leiba synagogue-ta tambiringeida haibani. ");
INSERT INTO mni_vpl VALUES ("JN6_60","073_6_60","JHN","6","60","60","Ibungogi tung-inba mayam amana masi tabada hairak-i, “Masigi tambiba asi yamna lui. Kanana masibu lousinba ngamgani?” ");
INSERT INTO mni_vpl VALUES ("JN6_61","073_6_61","JHN","6","61","61","Mahakki tung-inbasingna murum murum sonnariba adu khangladuna Ibungona hairak-i, “Masina nakhoida tokningba phaohanbra? ");
INSERT INTO mni_vpl VALUES ("JN6_62","073_6_62","JHN","6","62","62","Adu oirabadi Migi Machanupa aduna mahakna hanna leiramba mapham aduda amuk kakhatkhiba nakhoina uba tarabadi kari khan-gani? ");
INSERT INTO mni_vpl VALUES ("JN6_63","073_6_63","JHN","6","63","63","Hingba piba adu Mapu Ibungogi Thawainani. Mioibagi panggaldi kari amata kannade. Eina nakhoida haikhiba waheising adu thawai amasung hingbani. ");
INSERT INTO mni_vpl VALUES ("JN6_64","073_6_64","JHN","6","64","64","Adubu nakhoi kharanadi eibu thajade.” (Ibungobu kana kanana thajaroidage aduga kanana Ibungobu pithokkadage haibasi houbadagi Ibungona khang-i.) ");
INSERT INTO mni_vpl VALUES ("JN6_65","073_6_65","JHN","6","65","65","Jisuna makha tana hairak-i, “Maram aduna eina nakhoida haikhre, Ipa aduna makhoibu ngamhanbidrabadi makhoi kana amatana eingonda lakpa ngamloi.” ");
INSERT INTO mni_vpl VALUES ("JN6_66","073_6_66","JHN","6","66","66","Maram asina Ibungogi tung-inba mayam ama hankhre aduga Ibungoga amuk chatminnakhidre. ");
INSERT INTO mni_vpl VALUES ("JN6_67","073_6_67","JHN","6","67","67","Maram aduna Ibungona mahakki tung-inba taranithoi aduda hanglak-i, “Nakhoisu eibu thadoktuna chatninglabra?” ");
INSERT INTO mni_vpl VALUES ("JN6_68","073_6_68","JHN","6","68","68","Maduda Simon Peter-na khumlak-i, “Ibungo, eikhoina kanada chatlugani? Ibungoda lomba naidaba hingba pibiba waheising adu lei. ");
INSERT INTO mni_vpl VALUES ("JN6_69","073_6_69","JHN","6","69","69","Aduga Ibungodi Tengban Mapudagi lakpiba Asengba Mahak aduni haiba eikhoina thajei amadi khangjei.” ");
INSERT INTO mni_vpl VALUES ("JN6_70","073_6_70","JHN","6","70","70","Jisuna makhoida hairak-i, “Eina nakhoi taranithoibu khanba nattra? Adubu nakhoigi marakta amadi devil-ni!” ");
INSERT INTO mni_vpl VALUES ("JN6_71","073_6_71","JHN","6","71","71","Ibungona hairiba adu Simon Iscariot-ki machanupa Judas-gi maramdani. Judas asi Ibungogi tung-inba taranithoigi marakta ama oirabasu mahakna Ibungobu pithokkani. ");
INSERT INTO mni_vpl VALUES ("JN7_1","073_7_1","JHN","7","1","1","Masigi matungda Jisuna Galilee-gi lamda koina chatlammi. Maramdi Judea-da leiba Jihudisingna Ibungobu hatnaba hotnabagi maramna Ibungona Judea-da chatpa pamlamde. ");
INSERT INTO mni_vpl VALUES ("JN7_2","073_7_2","JHN","7","2","2","Khangpoksanggi chakkhangba hairiba Jihudigi chakkhangba adugi matam naksillaklammi, ");
INSERT INTO mni_vpl VALUES ("JN7_3","073_7_3","JHN","7","3","3","maram aduna Ibungogi manaosingna Ibungoda hairak-i, “Nahakna touriba angakpa thabaksing adu nahakki tung-inbasingna ujanaba mapham asi thadoktuna Judea-da chatlu. ");
INSERT INTO mni_vpl VALUES ("JN7_4","073_7_4","JHN","7","4","4","Masak naiba mi ama oiba pamba kana amatana lonna karisu toude. Nahakna thabaksing asi touribanina nahak taibangpanda phongdok-u.” ");
INSERT INTO mni_vpl VALUES ("JN7_5","073_7_5","JHN","7","5","5","Ibungogi manaosing phaobana Ibungobu thajaramde. ");
INSERT INTO mni_vpl VALUES ("JN7_6","073_7_6","JHN","7","6","6","Maduda Jisuna makhoida hairak-i, “Eigi achaba matam adu laktri adubu nakhoigidamakti matam khudingmak achabani. ");
INSERT INTO mni_vpl VALUES ("JN7_7","073_7_7","JHN","7","7","7","Taibangpan asina nakhoibudi yengthiba ngamde adubu makhoina eibudi yengthi maramdi makhoina toubasing adu phatte haina eina makhoida hai. ");
INSERT INTO mni_vpl VALUES ("JN7_8","073_7_8","JHN","7","8","8","Nakhoidi chakkhangba aduda chatlu adubu eidi chakkhangba aduda chatkhiroi maramdi eigi achaba matam adu laktri.” ");
INSERT INTO mni_vpl VALUES ("JN7_9","073_7_9","JHN","7","9","9","Masi hairaba matungda Ibungona Galilee-da makha tana leitharammi. ");
INSERT INTO mni_vpl VALUES ("JN7_10","073_7_10","JHN","7","10","10","Ibungogi manaosingna chakkhangba aduda chatkhraba matungda Ibungosu chakkhangba aduda chatlammi adubu phongna nattaduna lonna chatlammi. ");
INSERT INTO mni_vpl VALUES ("JN7_11","073_7_11","JHN","7","11","11","Jihudigi luchingbasingna Ibungobu chakkhangba aduda thirammi aduga “Mahak kadaida lei?” haiduna makhoina koihang hanglammi. ");
INSERT INTO mni_vpl VALUES ("JN7_12","073_7_12","JHN","7","12","12","Miyamsing adugi marakta Ibungogi maramda murum murum sonnaduna ngangnarammi. Kharana hai, “Mahak aphaba mi amani.” Aduga khara amana amuk hai, “Natte, mahakti miyambu lanna lamjingba mini.” ");
INSERT INTO mni_vpl VALUES ("JN7_13","073_7_13","JHN","7","13","13","Adum oinamak Jihudigi luchingbasingbu kibagi maramna makhoina Ibungogi maramda phongna wari saramde. ");
INSERT INTO mni_vpl VALUES ("JN7_14","073_7_14","JHN","7","14","14","Chakkhangba adu mayai chansillaklabada Jisuna Mapugi Sanglenda chatlaga tambiba hourammi. ");
INSERT INTO mni_vpl VALUES ("JN7_15","073_7_15","JHN","7","15","15","Maduda Jihudigi luchingbasing adu yamna ngakladuna hairak-i, “Mahakna suktamsu tamdana kamdouna asuk yamna khanglibano?” ");
INSERT INTO mni_vpl VALUES ("JN7_16","073_7_16","JHN","7","16","16","Maram aduna Jisuna makhoida hairak-i, “Eigi tambiba asi eingondagi natte adubu eibu thabirakpa Ibungo mangondagini. ");
INSERT INTO mni_vpl VALUES ("JN7_17","073_7_17","JHN","7","17","17","Kanagumbana Tengban Mapugi aningba adu touninglabadi eigi tambiba asi Tengban Mapudagira nattraga eigi isadagira haibadu mahakna khanggani. ");
INSERT INTO mni_vpl VALUES ("JN7_18","073_7_18","JHN","7","18","18","Masagi matikna ngangba makhoidi thagatchaba makhoina phangnaba hotnabani. Adubu mahakpu thabirakpa Ibungo mahak adubu thagat-hannaba hotnariba mi adudi achumbani aduga mangonda chumdaba amata leite. ");
INSERT INTO mni_vpl VALUES ("JN7_19","073_7_19","JHN","7","19","19","Moses-na nakhoida Wayel Yathang adu pibiba nattra? Adubu nakhoi kana amatana Wayel Yathang adubu inde. Aduga karigi nakhoina eibu hatnaba hotnaribano?” ");
INSERT INTO mni_vpl VALUES ("JN7_20","073_7_20","JHN","7","20","20","Maduda miyam aduna khumlak-i, “Nahak lai phattaba changba mini. Nahakpu kanana hatke hotnaribage?” ");
INSERT INTO mni_vpl VALUES ("JN7_21","073_7_21","JHN","7","21","21","Jisuna makhoida hairak-i, “Eina angakpa thabak ama tou-i aduga maduda nakhoi loinamak ngak-i. ");
INSERT INTO mni_vpl VALUES ("JN7_22","073_7_22","JHN","7","22","22","Moses-na nakhoigi nachasingbu un-kakpagi yathang adu pire (tasengbadi madu Moses-tagi hourakpadi natte adubu ipa ipusingdagini), aduga nakhoina angang adubu potthaba numitta un-kak-i. ");
INSERT INTO mni_vpl VALUES ("JN7_23","073_7_23","JHN","7","23","23","Karigumba angang amagi un-kakpagi numit adu potthaba numitta tarabadi nakhoina potthaba numit aduda adumak un kak-i. Madu toubada Wayel Yathang kaidraga eina potthaba numitta mi amabu anaba mapung phana phahanbada nakhoina karigi saogadouribano? ");
INSERT INTO mni_vpl VALUES ("JN7_24","073_7_24","JHN","7","24","24","Mapanthongdata yenglaga wayel touganu adubu achumba wayelna wayel tou!” ");
INSERT INTO mni_vpl VALUES ("JN7_25","073_7_25","JHN","7","25","25","Matang asida Jerusalem-da leiba mi kharana hairak-i, “Makhoina hatke haina hotnariba mi adu asi nattra? ");
INSERT INTO mni_vpl VALUES ("JN7_26","073_7_26","JHN","7","26","26","Yeng-u! Mahakna iphong pongna ngangli aduga makhoina mangonda wahei amatasu haide. Eikhoigi luchingbasingna mahakpu Christtani haina tasengna lepkhrabara? ");
INSERT INTO mni_vpl VALUES ("JN7_27","073_7_27","JHN","7","27","27","Adubu mahak asidi kadaidagi lakpano haiba eikhoina khang-i adubu Christta aduna lakpa matamdadi kana amatana mahak kadaidagino haiba khangloidabani.” ");
INSERT INTO mni_vpl VALUES ("JN7_28","073_7_28","JHN","7","28","28","Mapugi Sanglenda Jisuna tambi tambina laona hairak-i, “Hoi, ei kanano amadi ei kadaidagi lakpano haiba nakhoina khang-i. Adubu ei isana iranai oina mapham asida lakpadi natte. Eibu thabirakpa Ibungo mahak adu achumbani. Nakhoinadi mahakpu khangde. ");
INSERT INTO mni_vpl VALUES ("JN7_29","073_7_29","JHN","7","29","29","Adubu einadi Ibungo mahakpu khang-i maramdi ei mangondagi lakpani amadi mahakna eibu thabirakpani.” ");
INSERT INTO mni_vpl VALUES ("JN7_30","073_7_30","JHN","7","30","30","Maduda makhoina Ibungobu phanaba hotnarammi adubu Ibungo mahakki matam adu laktriba maramna makhoina khut tharamde. ");
INSERT INTO mni_vpl VALUES ("JN7_31","073_7_31","JHN","7","31","31","Adubu mi mayam amana Ibungobu thajare aduga makhoina hairak-i, “Christta aduna lakpa matamda mi asina toukhibasing adudagi henna mahakna angakpa thabaksing toukhigadra?” ");
INSERT INTO mni_vpl VALUES ("JN7_32","073_7_32","JHN","7","32","32","Jisugi maramda mayamna ngangnaribasing adu tabada Pharisee-sing amadi athoiba purohitsingna Jisubu phananaba Mapugi Sanglen-gi lanmising tharaklammi. ");
INSERT INTO mni_vpl VALUES ("JN7_33","073_7_33","JHN","7","33","33","Maduda Jisuna hairak-i, “Eina nakhoiga matam kharaga leiminnakhigani adugi matungda eibu thabirakpa Ibungogi maphamda ei chatlagani. ");
INSERT INTO mni_vpl VALUES ("JN7_34","073_7_34","JHN","7","34","34","Nakhoina eibu thigani adubu nakhoina eibu phangloi maramdi eina leigadouriba mapham aduda nakhoi lakpa ngamloi.” ");
INSERT INTO mni_vpl VALUES ("JN7_35","073_7_35","JHN","7","35","35","Maduda Jihudigi luchingbasingna makhoi masel amaga amaga hangnarak-i, “Eikhoina mahakpu phangloi hairibasi mahak kadaida chatke khallibano? Jihudi taba Greek-ki saharsingda chatkadouribra aduga Greek-ki misingbu tambigadouribra? ");
INSERT INTO mni_vpl VALUES ("JN7_36","073_7_36","JHN","7","36","36","‘Nakhoina eibu thigani aduga nakhoina eibu phangloi’ aduga ‘Eina leiba maphamda nakhoi lakpa ngamloi’ haina mahakna hairibasi kari haininglibano?” ");
INSERT INTO mni_vpl VALUES ("JN7_37","073_7_37","JHN","7","37","37","Chakkhangba adugi aroiba amadi khwaidagi maru-oiba numit aduda Jisuna lepkhatlaklaga ahouba khonjelna hairak-i, “Kanagumba mina khouranglabadi mahak eingonda laksanu ");
INSERT INTO mni_vpl VALUES ("JN7_38","073_7_38","JHN","7","38","38","aduga eingonda thajaba mahak aduna thakchasanu. Mapugi Puyana asumna takpi, ‘Mahakki nungdagi hingba piba isinggi iphutsing chellakkani.’ ” ");
INSERT INTO mni_vpl VALUES ("JN7_39","073_7_39","JHN","7","39","39","Jisubu thajabasingna phangjagadouriba Thawai adugi maramda masi Jisuna haibani. Ibungogi matik mangal chaohandriba maramna houjik phaobadi Thawai Asengba asi pibidri. ");
INSERT INTO mni_vpl VALUES ("JN7_40","073_7_40","JHN","7","40","40","Ibungona hairiba asi tabada mi kharana hairak-i, “Tasengnamak mahak asi eikhoina ngaijariba Mapu Ibungogi wa phongdokpa maichou adumak oigani.” ");
INSERT INTO mni_vpl VALUES ("JN7_41","073_7_41","JHN","7","41","41","Atoppa kharana hai, “Mahak asi Christta aduni.” Aduga atoppa mi khara amana amuk hairak-i, “Adubu kamdouna Christtabu Galilee-dagi lakkadouribano? ");
INSERT INTO mni_vpl VALUES ("JN7_42","073_7_42","JHN","7","42","42","Maramdi Christta adudi David ningthougi charon surondagi amadi David-na leiramba Bethlehem sahardagi oigani haina Mapugi puyana sengna takpiba nattra?” ");
INSERT INTO mni_vpl VALUES ("JN7_43","073_7_43","JHN","7","43","43","Asumna Jisugi maramna miyamsing adu napak tanare. ");
INSERT INTO mni_vpl VALUES ("JN7_44","073_7_44","JHN","7","44","44","Mi kharana Jisubu phaba pamlammi adubu mi kana amatana Ibungoda khut tharamde. ");
INSERT INTO mni_vpl VALUES ("JN7_45","073_7_45","JHN","7","45","45","Mapugi Sanglen-gi lanmisingna Jisubu pharaktana hallakpa matamda athoiba purohitsing amadi Pharisee-singna makhoida hanglak-i, “Nakhoina mahakpu karigi puraktribano?” ");
INSERT INTO mni_vpl VALUES ("JN7_46","073_7_46","JHN","7","46","46","“Nupa asina ngangbagumna mi kana amatanasu amukta ngangkhidri.” haina makhoina khumlak-i. ");
INSERT INTO mni_vpl VALUES ("JN7_47","073_7_47","JHN","7","47","47","Maduda Pharisee-sing aduna makhoida hairak-i, “Mahakna nakhoibusu lanna lamjingkhrabra? ");
INSERT INTO mni_vpl VALUES ("JN7_48","073_7_48","JHN","7","48","48","Luchingbasinggi maraktagi nattraga Pharisee-singgi maraktagi kana amatana mangonda thajaba yaobra? ");
INSERT INTO mni_vpl VALUES ("JN7_49","073_7_49","JHN","7","49","49","Masigi miyam asidi wayel yathang khangdaba sirapki makhada leiba ngaktani.” ");
INSERT INTO mni_vpl VALUES ("JN7_50","073_7_50","JHN","7","50","50","Mamangngeida Jisugi manakta chatluba aduga Pharisee amasu oiriba Nicodemus-na makhoida hairak-i, ");
INSERT INTO mni_vpl VALUES ("JN7_51","073_7_51","JHN","7","51","51","“Eikhoigi wayel yathangna mi amabu mahakna haiba hanna tadringei aduga mahakna touriba adu hanna khangdringeida mi adubu eikhoina wayenba yabra?” ");
INSERT INTO mni_vpl VALUES ("JN7_52","073_7_52","JHN","7","52","52","Maduda makhoina khumlak-i, “Nahaksu Galilee-dagira? Mapu Ibungogi puya adu ningthijana neinou adu oirabadi Mapu Ibungogi wa phongdokpa maichou amata Galilee-dagi thorakte haibasi nahakna khanggani.” ");
INSERT INTO mni_vpl VALUES ("JN7_53","073_7_53","JHN","7","53","53","Adudagi mi khudingmak magi magi mayumda hannakhre. ");
INSERT INTO mni_vpl VALUES ("JN8_1","073_8_1","JHN","8","1","1","Adubu Jisudi Olives chingda chatlammi. ");
INSERT INTO mni_vpl VALUES ("JN8_2","073_8_2","JHN","8","2","2","Ayuk anganbada Ibungona Mapugi Sanglenda amuk hanna chatlammi maduda mi pumnamakna Ibungogi akoibada tillammi aduga Ibungona phamthaduna makhoida tambiba hourammi. ");
INSERT INTO mni_vpl VALUES ("JN8_3","073_8_3","JHN","8","3","3","Ibungona asum tambiringeida Wayel Yathanggi ojasing amadi Pharisee-singna nupaga oktaba lichat chatlingeimaktada pharabi nupi amabu Ibungogi manakta puraktuna miyam mamangda lep-halle, ");
INSERT INTO mni_vpl VALUES ("JN8_4","073_8_4","JHN","8","4","4","aduga makhoina Ibungoda hairak-i, “Oja, nupi asi nupaga oktaba lichat chatlingeimaktada pharakpani. ");
INSERT INTO mni_vpl VALUES ("JN8_5","073_8_5","JHN","8","5","5","Eikhoigi Wayel Yathangda Moses-na asigumba nupidi nungna thaduna hatkadabani haina yathang pirammi masida nahak kari haining-i?” ");
INSERT INTO mni_vpl VALUES ("JN8_6","073_8_6","JHN","8","6","6","Ibungobu maral siba yaba yumpham phangnanaba makhoina wahang asina laanggumna sijinnabani. Adubu Ibungona nontharaga khudombina leimaigi uphunda i-ba hourammi. ");
INSERT INTO mni_vpl VALUES ("JN8_7","073_8_7","JHN","8","7","7","Maduda makhoina makha tana paokhum piraknaba asum hanglaklabada Ibungona nongkhatlaklaga makhoida hairak-i, “Nakhoigi narakta pap toudaba mahak aduna nupi asida ihan hanna nungna thasanu.” ");
INSERT INTO mni_vpl VALUES ("JN8_8","073_8_8","JHN","8","8","8","Adudagi Ibungona amuk nontharaga leimaigi uphunda ire. ");
INSERT INTO mni_vpl VALUES ("JN8_9","073_8_9","JHN","8","9","9","Masi tabada, ahansingdagi houraga amamam oina makhoi loina chatkhre. Mahakki mangda leptuna leiribi nupi aduga Ibungo Jisu khaktaga ngaihoure. ");
INSERT INTO mni_vpl VALUES ("JN8_10","073_8_10","JHN","8","10","10","Maduda Ibungona nongkhatlaktuna nupi aduda hairak-i, “Nahakpu naran siramba makhoising adu kadaida chatkhre? Kana amatana nahakpu lalhandrabra?” ");
INSERT INTO mni_vpl VALUES ("JN8_11","073_8_11","JHN","8","11","11","Nupi aduna khumlak-i, “Ibungo, kana amatana eibu lalhandre.” Maduda Jisuna mangonda hairak-i, “Einasu nahakpu lalhandre. Chatlu, pap amuk touraganu.” ");
INSERT INTO mni_vpl VALUES ("JN8_12","073_8_12","JHN","8","12","12","Jisuna makhoida amuk hairak-i, “Eidi taibangpan-gi mangalni. Kanagumbana eigi itung illabadi mahak keidoungeidasu amambada chatlaroi adubu hingbagi mangal adu mahakna phangjagani.” ");
INSERT INTO mni_vpl VALUES ("JN8_13","073_8_13","JHN","8","13","13","Pharisee-singna singnaraduna Ibungoda hairak-i, “Nahak nasana nasagi maramda sakhi pijare. Adugumba sakhi adu chatnaba yade.” ");
INSERT INTO mni_vpl VALUES ("JN8_14","073_8_14","JHN","8","14","14","Maduda Jisuna khumlak-i, “Eina isagi maramda sakhi pirabasu eina haidokliba adu achumbani maramdi ei kadaidagi lakpano aduga ei kadaida chatlibano haiba eihakna khang-i. Adubu nakhoinadi ei kadaidagi lakpano aduga ei kadaida chatlibano haiba khangde. ");
INSERT INTO mni_vpl VALUES ("JN8_15","073_8_15","JHN","8","15","15","Mioibana wayenba ma-ongda nakhoina wayelli adubu eina mi kana amatabu wayende. ");
INSERT INTO mni_vpl VALUES ("JN8_16","073_8_16","JHN","8","16","16","Adubu eina wayellabadi eigi wayel adu achumbani maramdi ei ithanta natte adubu eibu thabirakpa Ipa adu eiga loinari. ");
INSERT INTO mni_vpl VALUES ("JN8_17","073_8_17","JHN","8","17","17","Mi anigi sakhidi achumbani haina nakhoigi wayel yathangda iduna leiri. ");
INSERT INTO mni_vpl VALUES ("JN8_18","073_8_18","JHN","8","18","18","Eina eigi isagi maramda sakhi pi aduga eigi maramda sakhi pibiba atoppa adudi eibu thabirakpa Ipa aduni.” ");
INSERT INTO mni_vpl VALUES ("JN8_19","073_8_19","JHN","8","19","19","Adudagi makhoina Ibungoda hanglak-i, “Nahakki napabu kadaida leibage?” Maduda Jisuna khumlak-i, “Nakhoina eibusu eigi Ipabusu khangde. Nakhoina eibu khanglamlabadi eigi Ipabusu nakhoina khanglamgadabani.” ");
INSERT INTO mni_vpl VALUES ("JN8_20","073_8_20","JHN","8","20","20","Senkhai happa upusing thamba Mapugi Sanglen-gi ka aduda waphamsing asi Jisuna tambiringeida haibani. Adubu Ibungogi pungpham adu laktriba maramna Ibungobu kana amatana phaba-punba touramde. ");
INSERT INTO mni_vpl VALUES ("JN8_21","073_8_21","JHN","8","21","21","Jisuna makhoida amuksu hairak-i, “Eidi chatkhragani. Nakhoina eibu thigani adubu nakhoidi nakhoigi papta sigani. Eina chatpa mapham aduda nakhoina lakpa ngamloi.” ");
INSERT INTO mni_vpl VALUES ("JN8_22","073_8_22","JHN","8","22","22","Maram aduna Jihudigi luchingbasing aduna hairak-i, “‘Eina chatpa mapham aduda nakhoi lakpa ngamloi’ haina mahakna hairibasi mahak masa matomta sijagadouribra?” ");
INSERT INTO mni_vpl VALUES ("JN8_23","073_8_23","JHN","8","23","23","Jisuna makha tana makhoida hairak-i, “Nakhoidi makhadagini adubu eidi mathaktagini. Nakhoidi taibangpan asidagini adubu eidi taibangpan asidagi natte. ");
INSERT INTO mni_vpl VALUES ("JN8_24","073_8_24","JHN","8","24","24","Maram asinani nakhoina nakhoigi papta sigani haina eina nakhoida haikhiba adu. Eihakti eina hairiba mahak aduni haiba nakhoina thajadrabadi nakhoi nakhoigi papta sijagani.” ");
INSERT INTO mni_vpl VALUES ("JN8_25","073_8_25","JHN","8","25","25","Adudagi makhoina Ibungoda hanglak-i, “Nahak kanano?” Maduda Jisuna makhoida khumlak-i, “Hek houbadi eina nakhoida haiduna lakkhiba mahak adumakni. ");
INSERT INTO mni_vpl VALUES ("JN8_26","073_8_26","JHN","8","26","26","Nakhoigi maramda eina nakhoida haiba yaba amadi nakhoibu wayenba yaba mayam ama lei adubu ei madu touroi. Eibu thabirakpa Ibungo mahak adudi achumbani aduga eidi Ibungo mangondagi taba taba adukhakta eina taibangpanda haidok-i.” ");
INSERT INTO mni_vpl VALUES ("JN8_27","073_8_27","JHN","8","27","27","Jisuna Mapa Ibungo adugi maramda haibani haibasi makhoina khanglamde. ");
INSERT INTO mni_vpl VALUES ("JN8_28","073_8_28","JHN","8","28","28","Maram asina Jisuna makhoida hairak-i, “Nakhoina Migi Machanupa adubu thanggatpa matamda eihakti eina hairiba mahak adumakni haiba nakhoina khanggani. Aduga ei isa ithantana karisu toude adubu Ipa aduna eingonda takpi takpiba adukhakta eina hai haibasi nakhoina khanggani ");
INSERT INTO mni_vpl VALUES ("JN8_29","073_8_29","JHN","8","29","29","Eibu thabirakpa Ibungo mahak adu eiga loinari; mahakna eibu itompta thadokpide maramdi Ibungo mahakpu pelhanba thabaksing eina matam pumbada tou-i.” ");
INSERT INTO mni_vpl VALUES ("JN8_30","073_8_30","JHN","8","30","30","Ibungona haiba wasing asi taba mi mayam amana Ibungobu thajare. ");
INSERT INTO mni_vpl VALUES ("JN8_31","073_8_31","JHN","8","31","31","Ibungo Jisubu thajaraba makhoising aduda Jisuna hairak-i, “Eina tambiba adu nakhoina itattattana illabadi tasengnamak nakhoi eigi tung-inbasingni. ");
INSERT INTO mni_vpl VALUES ("JN8_32","073_8_32","JHN","8","32","32","Adu oirabadi nakhoina achumba adu khanggani amadi achumba aduna nakhoibu ningtamhanbigani.” ");
INSERT INTO mni_vpl VALUES ("JN8_33","073_8_33","JHN","8","33","33","Maduda makhoina khumlak-i, “Eikhoidi Abraham-gi charol suronni aduga eikhoina kanagumba mi amatagi minai oikhidri. ‘Nakhoibu ningtamhanbigani’ haina nahakna karamna hairibano?” ");
INSERT INTO mni_vpl VALUES ("JN8_34","073_8_34","JHN","8","34","34","Maduda Jisuna makhoida khumlak-i, “Eina nakhoida tasengnamak hairibasini, pap touba mi khudingmak papki minaini. ");
INSERT INTO mni_vpl VALUES ("JN8_35","073_8_35","JHN","8","35","35","Minaidi imung aduda matam pumbagi oina leite adubu machanupa adudi matam pumbagi oina lei. ");
INSERT INTO mni_vpl VALUES ("JN8_36","073_8_36","JHN","8","36","36","Machanupa aduna nakhoibu ningtamhanbirabadi, nakhoi tasengnamak ningtamgani. ");
INSERT INTO mni_vpl VALUES ("JN8_37","073_8_37","JHN","8","37","37","Nakhoi Abraham-gi charol suronni haiba ei khang-i. Adubu nakhoina eibu hatnaba hotnari maramdi nakhoigi thamoinungda eigi waheigi mapham leite. ");
INSERT INTO mni_vpl VALUES ("JN8_38","073_8_38","JHN","8","38","38","Eina Ipaga loinana leiringeida ukhraba adu eina nakhoida hairi. Adubu nakhoidi nakhoigi napana haiba adu tou-i.” ");
INSERT INTO mni_vpl VALUES ("JN8_39","073_8_39","JHN","8","39","39","Maduda makhoina khumlak-i, “Eikhoigi ipadi Abraham-ni.” Jisuna makhoida hairak-i, “Nakhoi Abraham-gi machasing oiramlabadi mahakna toukhiba thabaksing adu nakhoina touramgadabani. ");
INSERT INTO mni_vpl VALUES ("JN8_40","073_8_40","JHN","8","40","40","Eina Tengban Mapudagi taraba achumba adu nakhoida hairi aduga nakhoina eibu hatnaba hotnari. Madugumba thabak adu Abraham-di khak toukhide. ");
INSERT INTO mni_vpl VALUES ("JN8_41","073_8_41","JHN","8","41","41","Nakhoidi nakhoigi napa aduna touba adu nakhoina touribani.” Maduda makhoina khumlak-i, “Eikhoidi chatnabi kaina pokpa machasing natte, eikhoigi Ipa amakhakta lei mahak adudi Tengban Mapuni.” ");
INSERT INTO mni_vpl VALUES ("JN8_42","073_8_42","JHN","8","42","42","Jisuna makhoida hairak-i, “Tengban Mapubu nakhoigi napa Ibungomak oiramlabadi nakhoina eibu nungsiramgadabani maramdi eihak Ibungo mangondagi lakpani aduga houjik ei mapham asida leire. Ei isana iranai oina mapham asida lakpa natte adubu Ibungo mahakna eibu thabirakpani. ");
INSERT INTO mni_vpl VALUES ("JN8_43","073_8_43","JHN","8","43","43","Eina hairibasi nakhoina karigi wakhal taba ngamdribano? Masigi maramdi eina haiba nakhoina lousinba ngamdabagini. ");
INSERT INTO mni_vpl VALUES ("JN8_44","073_8_44","JHN","8","44","44","Nakhoidi nakhoigi napa Satan-gi machasingni, nakhoina napagi apambasing touba pammi. Mahakti ahoubadagi mihatpa oire aduga mangonda achumba leitaba maramna mahak achumbada lepte. Mahakna minamba ngangba matamda mahakki mahousagi oiba adu ngangbani maramdi mahakti minamba ngangbani aduga minamba pumnamakki mapani. ");
INSERT INTO mni_vpl VALUES ("JN8_45","073_8_45","JHN","8","45","45","Adubu eina achumba adu ngangba maramna nakhoina eibu thajade. ");
INSERT INTO mni_vpl VALUES ("JN8_46","073_8_46","JHN","8","46","46","Nakhoigi naraktagi kanagumba amana eibu pap toubagi maral lei haiba utpa ngamgadra? Eina achumba adu hairabada nakhoina eibu thajadriba karigino? ");
INSERT INTO mni_vpl VALUES ("JN8_47","073_8_47","JHN","8","47","47","Tengban Mapugi oiba mina Tengban Mapugi wasing tai. Adubu nakhoidi Tengban Mapugi oidaba maramna nakhoina tadabani.” ");
INSERT INTO mni_vpl VALUES ("JN8_48","073_8_48","JHN","8","48","48","Makhoina Jisuda hanglak-i, “Nahakti Samaria-gi mini aduga nangonda lai phattaba chang-i haina eikhoina haibasi chumlaba nattra?” ");
INSERT INTO mni_vpl VALUES ("JN8_49","073_8_49","JHN","8","49","49","Maduda Jisuna khumlak-i, “Eingonda lai phattaba changde. Eidi eigi Ipabu ikai khumnei aduga nakhoinadi eibu ikai khumnade. ");
INSERT INTO mni_vpl VALUES ("JN8_50","073_8_50","JHN","8","50","50","Eina isabu ikai khumnanaba thide adubu eibu ikai khumnahanba pamba kanagumba ama lei mahakti wayen toubani. ");
INSERT INTO mni_vpl VALUES ("JN8_51","073_8_51","JHN","8","51","51","Eina nakhoida tasengnamak hairibasini, kanagumbana eigi wa illabadi mahak keidoungeidasu siraroi.” ");
INSERT INTO mni_vpl VALUES ("JN8_52","073_8_52","JHN","8","52","52","Maduda makhoina Ibungoda hairak-i, “Nangonda lai phattaba sungsoi soidana changle haibasi houjikti eikhoi khangle. Abraham sikhi aduga Mapu Ibungogi wa phongdokpa maichousingsu sikhi adubu nahaknadi ‘Kanagumbana eigi wa illabadi mahak keidoungeidasu siraroi’ haina hairi. ");
INSERT INTO mni_vpl VALUES ("JN8_53","073_8_53","JHN","8","53","53","Nahakna eikhoigi ipa Abraham-dagi henna chaobra? Mahak sikhi aduga Tengban Mapugi wa phongdokpiba maichousingsu sikhi. Nahak nasasi kanani haina khanjaribano?” ");
INSERT INTO mni_vpl VALUES ("JN8_54","073_8_54","JHN","8","54","54","Jisuna khumlak-i, “Ei isana ithantabu thagatcharabadi eigi thagatchaba adu karisu natte. Adubu eibu thagatpibadi nakhoina nakhoigi Tengban Mapuni haijariba adu eigi Ipa adunani. ");
INSERT INTO mni_vpl VALUES ("JN8_55","073_8_55","JHN","8","55","55","Nakhoinadi Ibungo mahakpu khangde adubu einadi mahakpu khang-i. Eina Ibungo mahakpu khangde hairabadi eisu nakhoigumna minamba ngangba mi ama oiramgadabani. Adubu eidi Ibungo mahakpu khang-i aduga mahakki wa illi. ");
INSERT INTO mni_vpl VALUES ("JN8_56","073_8_56","JHN","8","56","56","Eina lakkadabagi numit adu ugani khallubada nakhoigi napa ibungo Abraham yamna haraojakhi, madu mahakna ujakhi amadi nungaijakhi.” ");
INSERT INTO mni_vpl VALUES ("JN8_57","073_8_57","JHN","8","57","57","Maduda makhoina Ibungoda hairak-i, “Chahi yangkhei phaoba sudriba nahakna Abraham-bu ukhraba!” ");
INSERT INTO mni_vpl VALUES ("JN8_58","073_8_58","JHN","8","58","58","Jisuna khumlak-i, “Eina nakhoida tasengna hairiba asini, Abraham poktringei mamangda ei leirabani.” ");
INSERT INTO mni_vpl VALUES ("JN8_59","073_8_59","JHN","8","59","59","Maram aduna makhoina Ibungoda thananaba nung paikhatle. Adubu Ibungona mahak masabu lotlaga makhoigi marak phaoduna Mapugi Sanglendagi chatkhre. ");
INSERT INTO mni_vpl VALUES ("JN9_1","073_9_1","JHN","9","1","1","Jisuna asum chatlingeida pokpadagi mit tanglaklaba nupa ama urammi. ");
INSERT INTO mni_vpl VALUES ("JN9_2","073_9_2","JHN","9","2","2","Maduda Ibungogi tung-inbasingna Ibungoda hanglak-i, “Oja Ibungo, kanana pap toubagi nupa asi mit tangna poklibano? Mahakna pap toubagira nattraga mahakki mama mapana pap toubagira?” ");
INSERT INTO mni_vpl VALUES ("JN9_3","073_9_3","JHN","9","3","3","Maduda Jisuna khumlak-i, “Mahakna nattraga mahakki mama mapana pap toubagi natte adubu Tengban Mapugi panggalna mahakki punsida thabak toubiba adu unanabani. ");
INSERT INTO mni_vpl VALUES ("JN9_4","073_9_4","JHN","9","4","4","Numit leiringeida eibu thabirakpa Ibungo mahakki thabak eikhoina touba tai. Kana amatana thabak touba ngamloidaba ahing adu lakli. ");
INSERT INTO mni_vpl VALUES ("JN9_5","073_9_5","JHN","9","5","5","Eina taibangpanda leiringeida, ei taibangpan-gi mangalni.” ");
INSERT INTO mni_vpl VALUES ("JN9_6","073_9_6","JHN","9","6","6","Ibungona masi hairaba matungda leimaida tin sitle aduga tin aduna leikhom semlaga nupa adugi mitta madu teibire ");
INSERT INTO mni_vpl VALUES ("JN9_7","073_9_7","JHN","9","7","7","aduga Ibungona nupa aduda hairak-i, “Siloam-gi pukhrida chatlaga chamthoklu.” (Siloam haibagi wahanthokti “Thakhraba” haibani). Maram aduna nupa aduna chattuna chamthoklure aduga mahakki mit uba phangjaraga hallakle. ");
INSERT INTO mni_vpl VALUES ("JN9_8","073_9_8","JHN","9","8","8","Mahakki yumlon keironnabasing amadi mahakna chakniba oiringeida ukhibasingna hainarak-i, “Phamduna chakniramba nupa adubu asi nattra?” ");
INSERT INTO mni_vpl VALUES ("JN9_9","073_9_9","JHN","9","9","9","Kharana hairak-i, “Nupa asini” adubu khara amana amuk hairak-i, “Nupa asi natte masak manabani.” Maduda nupa aduna hairak-i, “Ei mahak adumakni.” ");
INSERT INTO mni_vpl VALUES ("JN9_10","073_9_10","JHN","9","10","10","Maram aduna makhoina mangonda hanglak-i, “Adudi nahak kamdouna uba ngamlaklibano?” ");
INSERT INTO mni_vpl VALUES ("JN9_11","073_9_11","JHN","9","11","11","Mahakna khumlak-i, “Jisu kouba nupa amana leikhom semlaga eigi mitta teibire aduga Siloam pukhrida chatlaga chamthoklunaba eingonda haibi. Madu eina chattuna chamthoklubada ei uba ngamlakpani.” ");
INSERT INTO mni_vpl VALUES ("JN9_12","073_9_12","JHN","9","12","12","Maduda makhoina mangonda hanglak-i, “Mahak houjik kadaida leibage?” Mahakna khumlak-i, “Ei khangjade.” ");
INSERT INTO mni_vpl VALUES ("JN9_13","073_9_13","JHN","9","13","13","Adudagi makhoina mit tanglamba nupa adu Pharisee-singgi manakta purakle. ");
INSERT INTO mni_vpl VALUES ("JN9_14","073_9_14","JHN","9","14","14","Jisuna leikhom semduna nupa adubu mit tangbadagi phahanbikhiba numit adu Potthaba numit oirammi. ");
INSERT INTO mni_vpl VALUES ("JN9_15","073_9_15","JHN","9","15","15","Maram aduna Pharisee-singnasu mahak kamdouna mit uba ngamkhibage haina amuk hanglammi. Maduda mahakna khumlak-i, “Mahakna eigi mitta leikhom haple aduga eina madu chamthokpada ei uba phanglakpani.” ");
INSERT INTO mni_vpl VALUES ("JN9_16","073_9_16","JHN","9","16","16","Maduda Pharisee kharana hairak-i, “Madu touriba nupa adu Tengban Mapudagi oiroi maramdi mahak potthaba numit ngakte.” Adubu mi kharana hairak-i, “Pap chenba mi amana karamna asigumba angakpa khudamsing asi touba ngamgadouribano?” Asumna makhoi masel tokhai tanare. ");
INSERT INTO mni_vpl VALUES ("JN9_17","073_9_17","JHN","9","17","17","Maram aduna Pharisee-singna nupa aduda amukkasu hanglak-i, “Nahakki mit uhalliba mi adugi maramda nahak kari haining-i?” Nupa aduna khumlak-i, “Mahak asi Mapu Ibungogi wa phongdokpa maichou amani haina eina khanjei.” ");
INSERT INTO mni_vpl VALUES ("JN9_18","073_9_18","JHN","9","18","18","Jihudigi luchingbasingna nupa asi hanna mit tanglammi aduga konna uba phanglakpani haibasi makhoina thajaramde maram asina makhoina nupa adugi mama mapa koure ");
INSERT INTO mni_vpl VALUES ("JN9_19","073_9_19","JHN","9","19","19","aduga makhoida hanglak-i, “Nakhoina pokpadagi mit tanglak-i haiba nachanupa adu mahak asira? Aduga kamdouna mahak houjik uba ngamlibano?” ");
INSERT INTO mni_vpl VALUES ("JN9_20","073_9_20","JHN","9","20","20","Nupa adugi mama mapa aduna khumlak-i, “Mahak eikhoigi ichanupani aduga mahak pokpadagi mit tanglak-i haiba eikhoi khangjei. ");
INSERT INTO mni_vpl VALUES ("JN9_21","073_9_21","JHN","9","21","21","Adubu kamdouna mahak uba ngamlakkhibano aduga kanana mahakpu mit tangba phahanbiribano haibasidi eikhoi khangjade. Mangonda hangbiyu, mahak chahi yamlabani. Mahak masana paokhum pijasanu.” ");
INSERT INTO mni_vpl VALUES ("JN9_22","073_9_22","JHN","9","22","22","Jihudigi luchingbasing adubu kibadagi makhoina asumna haibani maramdi Jisubu Christtani haina haidokchabasing adu synagogue-tagi tanthokkani haina hanana makhoina warep lepnakhre. ");
INSERT INTO mni_vpl VALUES ("JN9_23","073_9_23","JHN","9","23","23","Maram adunani “Mahak chahi yamlabani. Mahak masana paokhum pijasanu.” haina makhoina hairibani. ");
INSERT INTO mni_vpl VALUES ("JN9_24","073_9_24","JHN","9","24","24","Aniraksuba oina makhoina mit tanglamba nupa adu kouraga hairak-i, “Tengban Mapuda matik mangal piyu, nahakpu phahanba mi asi pap chenba mini haiba eikhoina khang-i.” ");
INSERT INTO mni_vpl VALUES ("JN9_25","073_9_25","JHN","9","25","25","Maduda nupa aduna khumlak-i, “Mahak pap chenba nattraga chendaba mira haibadi ei khangjade. Asimatangdi ei khangjei madudi ei mit tanglammi adubu houjik ei uba phangjare.” ");
INSERT INTO mni_vpl VALUES ("JN9_26","073_9_26","JHN","9","26","26","Adudagi makhoina mangonda hairak-i, “Mahakna nangonda kari toukhi? Aduga kamdouna mahakna nahakki mit u-hankhibano?” ");
INSERT INTO mni_vpl VALUES ("JN9_27","073_9_27","JHN","9","27","27","Nupa aduna khumlak-i, “Eina nakhoida hanna haikhre adubu nakhoina tade. Aduga karigi nakhoina amuk hanna taninglibano? Nakhoisu mahakki tung-inba mising oiba pamlibra?” ");
INSERT INTO mni_vpl VALUES ("JN9_28","073_9_28","JHN","9","28","28","Maduda makhoina mahakpu ikaiba piraduna hairak-i, “Nahakti mahakki tung-inba mini adubu eikhoidi Moses-ki tung-inba misingni! ");
INSERT INTO mni_vpl VALUES ("JN9_29","073_9_29","JHN","9","29","29","Moses-ta Tengban Mapuna wa ngangbi haiba eikhoina khang-i adubu nupa asidi kadaidagi lakpano haiba phaoba eikhoi khangde.” ");
INSERT INTO mni_vpl VALUES ("JN9_30","073_9_30","JHN","9","30","30","Nupa aduna khumlak-i, “Madudi angakpani! Mahak kadaidagi lakpano haiba nakhoina khangde adubu mahakna eigi mit uhanbire. ");
INSERT INTO mni_vpl VALUES ("JN9_31","073_9_31","JHN","9","31","31","Pap chenbasinggi haijabadi Tengban Mapuna tabide haiba eikhoi khang-i. Adubu Ibungo mahakpu khurumjaba amadi mahakki aningba toubasinggi haijabadi tabi. ");
INSERT INTO mni_vpl VALUES ("JN9_32","073_9_32","JHN","9","32","32","Pokpadagi mit tanglakpa mi amabu uhanbiba haibasi taibangpan houbadagi kana amatana tadri. ");
INSERT INTO mni_vpl VALUES ("JN9_33","073_9_33","JHN","9","33","33","Nupa asi Tengban Mapudagi oiramdrabadi mahakna karisu touba ngamlamloi.” ");
INSERT INTO mni_vpl VALUES ("JN9_34","073_9_34","JHN","9","34","34","Makhoina mangonda khumlak-i. “Papna yomlaga poklakpa nangna kari natik leiduna eikhoibu tambiriba?” Adudagi makhoina mahakpu synagogue-tagi tanthokkhre. ");
INSERT INTO mni_vpl VALUES ("JN9_35","073_9_35","JHN","9","35","35","Makhoina mahakpu tanthokkhre haiba Jisuna tare aduga Ibungona mahakpu thengnarabada mangonda hanglak-i, “Nahak Migi Machanupa adubu thajabra?” ");
INSERT INTO mni_vpl VALUES ("JN9_36","073_9_36","JHN","9","36","36","Nupa aduna khumlak-i, “Ibungo, mahak adu kanano? Eina mahakpu thajanaba Ibungona eingonda takpiyu.” ");
INSERT INTO mni_vpl VALUES ("JN9_37","073_9_37","JHN","9","37","37","Jisuna mangonda hairak-i, “Nahakna mahakpu hanana ukhre, mahak adudi nangonda houjik wari sariba mahak aduni.” ");
INSERT INTO mni_vpl VALUES ("JN9_38","073_9_38","JHN","9","38","38","Nupa aduna hairak-i, “Mapu Ibungo, ei thajei.” Aduga mahakna Jisubu khurumjarammi. ");
INSERT INTO mni_vpl VALUES ("JN9_39","073_9_39","JHN","9","39","39","Maduda Jisuna hairak-i, “Wayennabagidamak ei taibangpan asida lakpani aduna mit tangbasingna unanaba aduga mit ubasingna tangnanabani.” ");
INSERT INTO mni_vpl VALUES ("JN9_40","073_9_40","JHN","9","40","40","Ibungogi manakta leiramba Pharisee kharana hairiba adu tarabada makhoina Ibungoda hairak-i, “Nahakna hairibasi eikhoi mit tang-i hairibra?” ");
INSERT INTO mni_vpl VALUES ("JN9_41","073_9_41","JHN","9","41","41","Maduda Jisuna khumlak-i, “Nakhoi mit tanglamlabadi nakhoida papki naral leiramloidabani adubu nakhoina ui haina haijarabanina nakhoida papki naral leire.” ");
INSERT INTO mni_vpl VALUES ("JN10_1","073_10_1","JHN","10","1","1","Jisuna hairak-i, “Eina nakhoida tasengnamak hairibasini, thongdagi changdaduna atoppa maphamdagi karaga yaokonda changba mi adu huranba amadi migi mapot munba mini. ");
INSERT INTO mni_vpl VALUES ("JN10_2","073_10_2","JHN","10","2","2","Adubu thongdagi yaokonda changba mi adudi yaosing adugi yaosenbani. ");
INSERT INTO mni_vpl VALUES ("JN10_3","073_10_3","JHN","10","3","3","Thongngakpa aduna mahakkidamak thong adu hangdokpi aduga yaosing aduna mahakki khonjel tai. Mahakna mahakki yaosing adubu maming panduna koubi aduga mahakna makhoibu yaokon adugi mapanda chingbi. ");
INSERT INTO mni_vpl VALUES ("JN10_4","073_10_4","JHN","10","4","4","Mahakki yaosing adubu mapanda puthokpiba matamda mahakna makhoigi mang thaduna chatli aduga makhoina mahakki matung illi maramdi makhoina mahakki khonjel khang-i. ");
INSERT INTO mni_vpl VALUES ("JN10_5","073_10_5","JHN","10","5","5","Makhoina mitop amagi matung khak illoi madugi mahutta makhoina mitop adudagi chenkhigani maramdi makhoina mitopsinggi khonjel khangde.” ");
INSERT INTO mni_vpl VALUES ("JN10_6","073_10_6","JHN","10","6","6","Jisuna makhoida pandam asi haibire adubu Ibungona makhoida kari haininglibano haibadudi makhoina wakhal taba ngamlamde. ");
INSERT INTO mni_vpl VALUES ("JN10_7","073_10_7","JHN","10","7","7","Maram asina Jisuna makhoida amuk hairak-i, “Eina nakhoida tasengnamak hairibasini, yaosing adugi thong adu eini. ");
INSERT INTO mni_vpl VALUES ("JN10_8","073_10_8","JHN","10","8","8","Eigi mangda lakkhiba makhoi pumnamak huranba amadi migi mapot munba mi ngaktani aduga yaosing aduna makhoigi khonjel tade. ");
INSERT INTO mni_vpl VALUES ("JN10_9","073_10_9","JHN","10","9","9","Thong adu eini. Eigi ipanna changlakpa mi khudingmak kanbigani. Makhoina changthok changsin tougani amadi sanjabung phangjagani. ");
INSERT INTO mni_vpl VALUES ("JN10_10","073_10_10","JHN","10","10","10","Huranba aduna lakpadi hurannanaba, hatnanaba amadi mang-hantak-hannanabata lakpani. Adubu eina lakpadi makhoina hingba phangnanaba aduga hingba adu marang kaina phangnanaba lakpani. ");
INSERT INTO mni_vpl VALUES ("JN10_11","073_10_11","JHN","10","11","11","“Aphaba yaosenba adu eini. Aphaba yaosenba aduna yaosinggidamak thawai thabi. ");
INSERT INTO mni_vpl VALUES ("JN10_12","073_10_12","JHN","10","12","12","Anekpa mi haibadi yaosing adu masagi nattaba adunadi keisal lakpa ubada yaosing adu thadoklamlaga chenkhi. Aduga keisal aduna yaosing adubu laktuna phai amadi chaikhai. ");
INSERT INTO mni_vpl VALUES ("JN10_13","073_10_13","JHN","10","13","13","Anekpa mi aduna chenkhibagi maramdi mahak anekpani aduga mahakna yaosing adugidamak karisu thousade. ");
INSERT INTO mni_vpl VALUES ("JN10_14","073_10_14","JHN","10","14","15","Aphaba yaosenba adu eini. Eigi Ipana eibu khangbiba amadi eina Ipabu khangjaba adugumna eina eigi yaosingbu khang-i aduga eigi yaosingna eibu khang-i. Amasung eina yaosinggidamak thawai thabi. ");
INSERT INTO mni_vpl VALUES ("JN10_16","073_10_16","JHN","10","16","16","Yaokon asida leitaba eigi atei yaosingsu leiri. Eina makhoibusu purakpa tai. Makhoinasu eigi khonjel tagani aduga yaosenba ama leiba yao sanggu ama oirakkani. ");
INSERT INTO mni_vpl VALUES ("JN10_17","073_10_17","JHN","10","17","17","“Eigi Ipana eibu nungsi maramdi eina eigi thawaibu amuk hanna lousinnaba eina thawai thai. ");
INSERT INTO mni_vpl VALUES ("JN10_18","073_10_18","JHN","10","18","18","Kana amatana eingondagi eigi thawai louba natte. Ei isana yana thawai thabani. Eina eigi thawai thaba amadi amuk lousinbagi itik eingonda lei. Yathang asi eigi Ipadagi phangjabani.” ");
INSERT INTO mni_vpl VALUES ("JN10_19","073_10_19","JHN","10","19","19","Ibungona haiba waheising asigi maramna Jihudisinggi marakta amuk tokhai tanare. ");
INSERT INTO mni_vpl VALUES ("JN10_20","073_10_20","JHN","10","20","20","Makhoi mayam amana hairak-i, “Mahak lai phattaba changba amadi angaoba mini. Mahakki wabu karigi eikhoina tagadouribano?” ");
INSERT INTO mni_vpl VALUES ("JN10_21","073_10_21","JHN","10","21","21","Adubu atoppa kharana amuk hairak-i, “Masi lai phattaba changba mi amana nganggadaba wahei natte. Lai phattabanabu mit tangba migi mitpu uhanba ngamgadra?” ");
INSERT INTO mni_vpl VALUES ("JN10_22","073_10_22","JHN","10","22","22","Matam adu ningthamthagi matam oirammi, Jerusalem-da Mapugi Sanglen katthokpagi chakkhangba numit adu lakle. ");
INSERT INTO mni_vpl VALUES ("JN10_23","073_10_23","JHN","10","23","23","Mapugi Sanglen aduda Solomon-gi hojang kouba mapham aduda Jisuna chattuna leirammi. ");
INSERT INTO mni_vpl VALUES ("JN10_24","073_10_24","JHN","10","24","24","Maduda Jihudisingna Ibungogi akoibada koisillaklaga hairak-i, “Nahakna eikhoibu kayam kuina chingnahanduna thamgadouribano? Nahak Christta adu oirabadi eikhoida sengna haiyu.” ");
INSERT INTO mni_vpl VALUES ("JN10_25","073_10_25","JHN","10","25","25","Jisuna makhoida khumlak-i, “Eina nakhoida hanna haikhre adubu nakhoina eibu thajade. Eina Ipagi mingda touba thabaksing aduna eigi maramda khang-halli. ");
INSERT INTO mni_vpl VALUES ("JN10_26","073_10_26","JHN","10","26","26","Adubu nakhoina eibu thajade maramdi nakhoi eigi yaosing natte. ");
INSERT INTO mni_vpl VALUES ("JN10_27","073_10_27","JHN","10","27","27","Eigi yaosingdi eigi khonjel tai; eina makhoibu khang-i aduga makhoina eigi itung illi. ");
INSERT INTO mni_vpl VALUES ("JN10_28","073_10_28","JHN","10","28","28","Eina makhoida lomba naidaba hingba pibi aduga makhoi keidoungeidasu siraroi. Kana amatana makhoibu eigi khuttagi munba ngamloi. ");
INSERT INTO mni_vpl VALUES ("JN10_29","073_10_29","JHN","10","29","29","Makhoibu eingonda pibiriba eigi Ipa aduna pumnamaktagi chaoba helli. Kana amatana makhoibu Ipagi khuttagi munba ngamloi. ");
INSERT INTO mni_vpl VALUES ("JN10_30","073_10_30","JHN","10","30","30","Eiga Ipaga amatani.” ");
INSERT INTO mni_vpl VALUES ("JN10_31","073_10_31","JHN","10","31","31","Adudagi Jihudisingna Ibungoda thanaba nung amuk khun-gatlammi. ");
INSERT INTO mni_vpl VALUES ("JN10_32","073_10_32","JHN","10","32","32","Maduda Jisuna makhoida hairak-i, “Eigi Ipana eingonda tounaba pibiba aphaba thabak mayam ama eina nakhoigi mangda toukhre. Thabaksing adugi maraktagi karamba thabakkidamak nakhoina eibu nungna thagadouribano?” ");
INSERT INTO mni_vpl VALUES ("JN10_33","073_10_33","JHN","10","33","33","Makhoina khumlak-i, “Nahakna touba aphaba thabaksing adugidamak eikhoina nahakpu nungna thagadaba natte adubu nahakna Tengban Mapubu thina ngangbagini. Nahakna mi ama oiraga nasabu Mapu Ibungoni haijari.” ");
INSERT INTO mni_vpl VALUES ("JN10_34","073_10_34","JHN","10","34","34","Maduda Jisuna makhoida khumlak-i, “Nakhoigi wayel yathangda asumna iduna leiba nattra madudi Ishworna hai, ‘Nakhoi mapu ibungosingni?’ ");
INSERT INTO mni_vpl VALUES ("JN10_35","073_10_35","JHN","10","35","35","Eikhoina khang-i adudi Mapugi puyadi kaiba yade. Maram asina Ishworna mahakki wahei pibiba makhoisingbu ‘ishworsing’ haina haibire. ");
INSERT INTO mni_vpl VALUES ("JN10_36","073_10_36","JHN","10","36","36","Eigi oinadi, Ipana eibu khandokpibani amadi taibangpan asida thabirakpani. Adu oiragadi ‘Ei Tengban Mapugi Machanupani’ haina eina haibasida kamdouna Mapu Ibungobu thina ngang-i haina nakhoina hairibano? ");
INSERT INTO mni_vpl VALUES ("JN10_37","073_10_37","JHN","10","37","37","Eina Ipagi thabaksing adu toudrabadi eibu thajaganu. ");
INSERT INTO mni_vpl VALUES ("JN10_38","073_10_38","JHN","10","38","38","Adubu eina Ipagi thabaksing adu tourabadi nakhoina eibu thajadrabasu, Ipana eingonda lei aduga eina Ipada lei haibasi nakhoina khang-nanaba amadi thajananaba thabaksing adubudi thajou.” ");
INSERT INTO mni_vpl VALUES ("JN10_39","073_10_39","JHN","10","39","39","Amuk hanna makhoina Ibungobu phananaba hotnarammi adubu Ibungona makhoigi makhuttagi nanthokle. ");
INSERT INTO mni_vpl VALUES ("JN10_40","073_10_40","JHN","10","40","40","Adudagi Jisuna Jordan wangmada chatlammi aduga John-na i-han hanna baptize touramba mapham aduda leire ");
INSERT INTO mni_vpl VALUES ("JN10_41","073_10_41","JHN","10","41","41","aduga mi mayam amana Ibungogi maphamda laklammi. Maduda makhoi masel hainarak-i, “John-di angakpa thabak amatadi toukhide adubu mahakna mi asigi maramda haikhiba pumnamak adudi achumbani.” ");
INSERT INTO mni_vpl VALUES ("JN10_42","073_10_42","JHN","10","42","42","Mapham aduda mi mayam amana Ibungobu thajare. ");
INSERT INTO mni_vpl VALUES ("JN11_1","073_11_1","JHN","11","1","1","Lazarus kouba nupa ama naduna leirammi. Mahakti mache Mary amadi Martha-ga loinana Bethany khunggangda leibani. ");
INSERT INTO mni_vpl VALUES ("JN11_2","073_11_2","JHN","11","2","2","Lazarus-ki mache Mary asi Mapu Ibungogi makhongda manam nungsiba thao heiduna masamna teithokkhiba nupi aduni. ");
INSERT INTO mni_vpl VALUES ("JN11_3","073_11_3","JHN","11","3","3","Machem ani asina Jisuda pao asumna tharammi, “Ibungo, nahakna nungsijaba marup adu nare.” ");
INSERT INTO mni_vpl VALUES ("JN11_4","073_11_4","JHN","11","4","4","Jisuna pao asi tabada hairak-i, “Anaba asi siraga loisin-gadaba anaba natte adubu Tengban Mapugi matik mangal oinanaba amadi masigi mapanna Tengban Mapugi Machanupa adubu matik mangal phangnanabani.” ");
INSERT INTO mni_vpl VALUES ("JN11_5","073_11_5","JHN","11","5","5","Martha, mahakki manaonupi amadi Lazarus-pu Jisuna nungsijarammi. ");
INSERT INTO mni_vpl VALUES ("JN11_6","073_11_6","JHN","11","6","6","Adubu Ibungona Lazarus nare haiba tabada Ibungona leiriba mapham aduda numit nini amaga amuk makha tana leitharammi. ");
INSERT INTO mni_vpl VALUES ("JN11_7","073_11_7","JHN","11","7","7","Adudagi Ibungona mahakki tung-inbasingda hairak-i, “Eikhoi Judea-da hallasi.” ");
INSERT INTO mni_vpl VALUES ("JN11_8","073_11_8","JHN","11","8","8","Maduda Ibungogi tung-inbasingna khumlak-i, “Oja Ibungo, mapham aduda Jihudisingna Ibungobu nungna thanaba hotnakhibadu ikui kuikhidri aduga Ibungona mapham aduda amuk chatke hairibra?” ");
INSERT INTO mni_vpl VALUES ("JN11_9","073_11_9","JHN","11","9","9","Jisuna khumlak-i, “Nongmada pung taranithoi nungthil oiba nattra? Nungthilda chatpa mi amana khudi thide maramdi taibangpan asigi mangalna mahakna uba phang-i. ");
INSERT INTO mni_vpl VALUES ("JN11_10","073_11_10","JHN","11","10","10","Adubu numidangda chatpa mahak adudi khudi thi maramdi mangonda mangal leite.” ");
INSERT INTO mni_vpl VALUES ("JN11_11","073_11_11","JHN","11","11","11","Masi hairaba tungda Ibungona makhoida makha tana hairak-i, “Eikhoigi marup Lazarus tumkhre adubu mahak houdoknaba ei houjik chatkani.” ");
INSERT INTO mni_vpl VALUES ("JN11_12","073_11_12","JHN","11","12","12","Maduda tung-inbasing aduna khumlak-i, “Ibungo, mahak tumlabadi, mahak naba pharagani.” ");
INSERT INTO mni_vpl VALUES ("JN11_13","073_11_13","JHN","11","13","13","Jisuna hainingba adudi Lazarus sire haibani adubu makhoinadi Ibungona hairibadu tumduna potthabagi maramda haibani haina khallammi. ");
INSERT INTO mni_vpl VALUES ("JN11_14","073_11_14","JHN","11","14","14","Maram aduna Jisuna makhoida sengna haibire, “Lazarus sire, ");
INSERT INTO mni_vpl VALUES ("JN11_15","073_11_15","JHN","11","15","15","nakhoina thajanaba eina mahakka loinana mapham aduda leiminnaramdaba asi nakhoigidamak ei harao-i. Eikhoi mahakki manakta chatlasi.” ");
INSERT INTO mni_vpl VALUES ("JN11_16","073_11_16","JHN","11","16","16","Didymus hainasu kouba Thomas-na mahakka loinariba tung-inbasing aduda hairak-i, “Ibungoga loinana siminnanaba eikhoisu chatlasi.” ");
INSERT INTO mni_vpl VALUES ("JN11_17","073_11_17","JHN","11","17","17","Jisuna Bethany-da thunglaba matamda Lazarus leirol chankhiba numit marini sukhre. ");
INSERT INTO mni_vpl VALUES ("JN11_18","073_11_18","JHN","11","18","18","Bethany asi Jerusalem-dagi mile animuk lapna leibani. ");
INSERT INTO mni_vpl VALUES ("JN11_19","073_11_19","JHN","11","19","19","Jihudi mayam amana Martha amadi Mary-gi manakta makhoigi moupuwa leikhidaba adugi themjinbinaba laklammi. ");
INSERT INTO mni_vpl VALUES ("JN11_20","073_11_20","JHN","11","20","20","Jisu lakle tabada Martha-na Ibungobu unanaba thoklammi adubu Mary-di yumda leihourammi. ");
INSERT INTO mni_vpl VALUES ("JN11_21","073_11_21","JHN","11","21","21","Martha-na Jisuda hairak-i, “Ibungo, nahakna mapham asida leiramlabadi eigi ipuwa adu siramloidabani. ");
INSERT INTO mni_vpl VALUES ("JN11_22","073_11_22","JHN","11","22","22","Adubu houjikmaksu Ibungona nijaba khudingmak Tengban Mapuna pibigani haiba ei khangjei.” ");
INSERT INTO mni_vpl VALUES ("JN11_23","073_11_23","JHN","11","23","23","Jisuna mangonda hairak-i, “Nahakki noupuwa amuk hinggatkani.” ");
INSERT INTO mni_vpl VALUES ("JN11_24","073_11_24","JHN","11","24","24","Maduda Martha-na khumlak-i, “Aroiba numit aduda mahak amuk hinggatkani haibasi ei khangjei.” ");
INSERT INTO mni_vpl VALUES ("JN11_25","073_11_25","JHN","11","25","25","Jisuna mangonda hairak-i, “Hinggatpa amadi hingba adu eini. Eibu thajaba mahak adu sirabasu hinggani. ");
INSERT INTO mni_vpl VALUES ("JN11_26","073_11_26","JHN","11","26","26","Eingonda leiba aduga eibu thajaba mi khudingna keidoungeidasu siraroi. Nahak masi thajabra?” ");
INSERT INTO mni_vpl VALUES ("JN11_27","073_11_27","JHN","11","27","27","Maduda Martha-na khumlak-i, “Hoi, Ibungo. Ibungodi taibangpanda lengbirakkadaba Tengban Mapugi Machanupa, Christta aduni haiba ei thajei.” ");
INSERT INTO mni_vpl VALUES ("JN11_28","073_11_28","JHN","11","28","28","Martha-na masi hairaba tungda mahakna mahakki manaonupi Mary-gi manakta chatlammi aduga mahakpu tonganna kouthoklaga hairak-i, “Mapham asida Oja lak-le, nahakpu hangli.” ");
INSERT INTO mni_vpl VALUES ("JN11_29","073_11_29","JHN","11","29","29","Mary-na masi tabada thunamak hougattuna Ibungobu unanaba chatlammi. ");
INSERT INTO mni_vpl VALUES ("JN11_30","073_11_30","JHN","11","30","30","Jisudi khunggang aduda youraktri adubu Martha-na unaramba mapham aduda adumak leirammi. ");
INSERT INTO mni_vpl VALUES ("JN11_31","073_11_31","JHN","11","31","31","Yum aduda Mary-bu themjinbiramba Jihudising aduna mahakna yamna thuna hougattuna chatkhiba adu ubada, mahak Lazarus-ki mongphamda kappa chatlibani haina khanduna makhoina mahakki matung illammi. ");
INSERT INTO mni_vpl VALUES ("JN11_32","073_11_32","JHN","11","32","32","Jisuna leiriba mapham aduda Mary-na thunglabada mahakna Ibungobu ujare aduga Ibungogi khuyakhada tuthajaraga hairak-i, “Ibungo, nahakna mapham asida leiramlabadi eigi ipuwa adu siramloidabani.” ");
INSERT INTO mni_vpl VALUES ("JN11_33","073_11_33","JHN","11","33","33","Mahakna kappa amasung mahakka loinariba Jihudising aduna kappa adu ubada Ibungogi thamoi soklammi amadi yamna nungaitaba phaorammi. ");
INSERT INTO mni_vpl VALUES ("JN11_34","073_11_34","JHN","11","34","34","“Nakhoina mahakpu kadaida leirol chankhibage?” haina Ibungona makhoida hanglammi. Maduda makhoina khumlak-i, “Ibungo, lakpiduna yengbiyu.” ");
INSERT INTO mni_vpl VALUES ("JN11_35","073_11_35","JHN","11","35","35","Jisu kaplammi. ");
INSERT INTO mni_vpl VALUES ("JN11_36","073_11_36","JHN","11","36","36","Maduda Jihudisingna hairak-i, “Yeng-u, mahakna Lazarus-pu kayada nungsiriba!” ");
INSERT INTO mni_vpl VALUES ("JN11_37","073_11_37","JHN","11","37","37","Adubu mi kharanadi asumna hairak-i, “Mit tangba mibudi uhanba ngamlaga mahakna Lazarus-pudi sihandana thambadi ngamdabra?” ");
INSERT INTO mni_vpl VALUES ("JN11_38","073_11_38","JHN","11","38","38","Amuk hanna yamna nungaitaba phaoraduna Jisuna mongpham aduda laklammi. Mongpham adu nungjao amana changphamda thingjinduna thamba surung amani. ");
INSERT INTO mni_vpl VALUES ("JN11_39","073_11_39","JHN","11","39","39","Jisuna makhoida hairak-i, “Nung adu louthokkhoǃ” Leikhidraba nupa adugi mache Martha-na Ibungoda hairak-i, “Ibungo, manam namthiramlagani maramdi mahak mapham aduda thamkhiba numit marini sukhre.” ");
INSERT INTO mni_vpl VALUES ("JN11_40","073_11_40","JHN","11","40","40","Maduda Jisuna mangonda hairak-i, “Nahakna thajarabadi nahak Tengban Mapugi matik mangal uba phanggani haina eina nangonda haikhiba nattra?” ");
INSERT INTO mni_vpl VALUES ("JN11_41","073_11_41","JHN","11","41","41","Maram aduna makhoina nung adu louthokkhre. Adudagi Jisuna swargaromda yengkhatlaga hairak-i, “Ipa, eina haijaba Ibungona tabibagi thagatchari. ");
INSERT INTO mni_vpl VALUES ("JN11_42","073_11_42","JHN","11","42","42","Matam pumnamakta eina haijaba Ibungona tabi haiba eina khangjei adubu Ibungona eibu thabirakpani haiba mapham asida leiriba miyamsing asina thajananaba makhoigidamak eina khon thokna haidokchabani.” ");
INSERT INTO mni_vpl VALUES ("JN11_43","073_11_43","JHN","11","43","43","Masi hairaba tungda Ibungona ahouba khonjelna laorak-i, “Lazarus, thoklak-u!” ");
INSERT INTO mni_vpl VALUES ("JN11_44","073_11_44","JHN","11","44","44","Maduda mahakki makhong makhuttu phumbada sijinnaba phi masangsingna yetsillammi aduga mamaidu phi amana yetlaga thoklakle. Maduda Jisuna makhoida hairak-i, “Pulliba mongphamgi phising adu louthok-u aduga mahak chatchasanu.” ");
INSERT INTO mni_vpl VALUES ("JN11_45","073_11_45","JHN","11","45","45","Mary-gi manakta lakpa Jihudi mayam ama Jisuna toukhiba thabak adu urammi aduga makhoina Ibungobu thajare. ");
INSERT INTO mni_vpl VALUES ("JN11_46","073_11_46","JHN","11","46","46","Adubu makhoi kharanadi Pharisee-singgi manakta chatlaga Jisuna toukhiba thabak adu tamle. ");
INSERT INTO mni_vpl VALUES ("JN11_47","073_11_47","JHN","11","47","47","Maram aduna Pharisee-sing amadi athoiba purohitsingna Sanhedrin-gi mitin ama koure. Maduda makhoi masel hangnarak-i, “Eikhoi kari tousige? Mi asina touriba angakpa thabak pumnamak asi yeng-u. ");
INSERT INTO mni_vpl VALUES ("JN11_48","073_11_48","JHN","11","48","48","Eikhoina mahakpu asumna thadoklabadi mi khudingna mahakpu thajakhragani madu oirabadi Rome-gi misingna laktuna eikhoigi Mapu Sanglen amadi eikhoigi phurup asi loukhragani.” ");
INSERT INTO mni_vpl VALUES ("JN11_49","073_11_49","JHN","11","49","49","Makhoigi maraktagi Caiaphas kouba chahi adugi Purohitlen oiba mahakna hairak-i, “Nakhoi karisu khangde! ");
INSERT INTO mni_vpl VALUES ("JN11_50","073_11_50","JHN","11","50","50","Phurup apumba amabu pummang mangbagi mahutta mi amana miyamgidamak sibibana nakhoigidamak henna phei haibasi nakhoi khangdabra?” ");
INSERT INTO mni_vpl VALUES ("JN11_51","073_11_51","JHN","11","51","51","Masi mahakna masagi aningbadagi haiba natte adubu mahakna chahi adugi Purohitlen ama oina Jihudi phurupkidamak Jisuna sibigani haina Tengban Mapugi wa phongdokpani, ");
INSERT INTO mni_vpl VALUES ("JN11_52","073_11_52","JHN","11","52","52","madu Jihudi phurup khaktagi nattana chaithoktuna leiriba Tengban Mapugi machasingbu khomjinduna amata oihannanabani. ");
INSERT INTO mni_vpl VALUES ("JN11_53","073_11_53","JHN","11","53","53","Numit adudagi Jihudigi luchingbasingna Jisubu hatnanaba thourang touba houre. ");
INSERT INTO mni_vpl VALUES ("JN11_54","073_11_54","JHN","11","54","54","Maram aduna Jisuna Jihudisinggi marakta phongna chattre. Madugi mahutta lamjao lamhangda manakta leiba Ephraim kouba khun amada chatlammi aduga mapham aduda mahakki tung-inbasingga loinana leirammi. ");
INSERT INTO mni_vpl VALUES ("JN11_55","073_11_55","JHN","11","55","55","Jihudisinggi oiba Lanthokpibagi Chakkhangba adugi matam naksillaklabada, lam adugi miyamna Chakkhangba adugi mang-oinana laininggi oiba sengdoknabagidamak Jerusalem-da chatlammi. ");
INSERT INTO mni_vpl VALUES ("JN11_56","073_11_56","JHN","11","56","56","Makhoina Jisubu thirammi aduga makhoina Ningnasangda lepna lepna makhoi masel amaga amaga hangnarak-i, “Nakhoi kari khalli? Mahaksibu Chakkhangba asida lakloidra?” ");
INSERT INTO mni_vpl VALUES ("JN11_57","073_11_57","JHN","11","57","57","Athoiba purohitsing amadi pharisee-singna Jisubu phananabagidamak, kanagumbana Jisubu kadaida leibage haiba khanglabadi mahakna pao pirakkadabani haina yathang pirammi. ");
INSERT INTO mni_vpl VALUES ("JN12_1","073_12_1","JHN","12","1","1","Lanthokpibagi chakkhangba hougadaba numit taruknigi mamangda, Jisuna sibadagi hinggat-hanbikhiba Lazarus-na leiba mapham Bethany-da Jisuna laklammi. ");
INSERT INTO mni_vpl VALUES ("JN12_2","073_12_2","JHN","12","2","2","Jisugidamak numidanggi chaklen ama langlammi maduda Martha-na chana-thaknabagi semsabagi thougal adu tourammi aduga Ibungoga loinana phamminnaribasinggi marakta Lazarus yaorammi. ");
INSERT INTO mni_vpl VALUES ("JN12_3","073_12_3","JHN","12","3","3","Adudagi Mary-na mamal atangba asengba nard-ki manam nungsiba mahi litre makhaimuk oigadaba ama puraktuna Jisugi khongda heirammi aduga mahakki masamna Ibungogi khong teithoklammi. Maduda yum adu nungsiba manam aduna pumthal thallammi. ");
INSERT INTO mni_vpl VALUES ("JN12_4","073_12_4","JHN","12","4","4","Adubu Jisugi tung-inba ama oiriba aduga Jisubu konna pithokkadouriba Judas Iscariot-na yaningdana hairak-i, ");
INSERT INTO mni_vpl VALUES ("JN12_5","073_12_5","JHN","12","5","5","“Chahi amagi khutsuman oigadaba manam nungsiba thao asi yollaga senpham adu lairabasingda pidriba karigino?” ");
INSERT INTO mni_vpl VALUES ("JN12_6","073_12_6","JHN","12","6","6","Mahakna masi haibasi lairabasinggi khanbadagi haiba natte adubu mahak huranba mi ama oibagi maramnani. Mahak sen-gao panaba ama oiraga mahakna sen-gao aduda haplakpa sel adu hek hek sijinnathok-i. ");
INSERT INTO mni_vpl VALUES ("JN12_7","073_12_7","JHN","12","7","7","Maduda Jisuna hairak-i, “Mangonda ayetpa piganu! Masi eihakpu leirol chan-gadaba numit adugidamak mahakna khaktuna thamlibani. ");
INSERT INTO mni_vpl VALUES ("JN12_8","073_12_8","JHN","12","8","8","Lairabasingdi nakhoigi narakta matam pumbada leigani adubu eidi nakhoiga matam pumnamakta leigadaba natte.” ");
INSERT INTO mni_vpl VALUES ("JN12_9","073_12_9","JHN","12","9","9","Yamlaba Jihudi miyam amana Bethany-da Jisu leire haiba tarabada makhoina Jisugi maram khaktagi nattana Ibungona sibadagi hinggat-hanbikhraba Lazarus-pusu yengnaba laklammi. ");
INSERT INTO mni_vpl VALUES ("JN12_10","073_12_10","JHN","12","10","10","Maram aduna athoiba purohitsingna Lazarus-pusu hatnaba thourang tourammi, ");
INSERT INTO mni_vpl VALUES ("JN12_11","073_12_11","JHN","12","11","11","maramdi mahakki maramdagi Jihudi mayam amana makhoibu thadoklamlaga Jisuda thajaba thamle. ");
INSERT INTO mni_vpl VALUES ("JN12_12","073_12_12","JHN","12","12","12","Mathanggi numitta Lanthokpibagi Chakkhangba aduda laklamba yamkhraba miyam amana Jisuna Jerusalem tamna lakli haiba tarammi. ");
INSERT INTO mni_vpl VALUES ("JN12_13","073_12_13","JHN","12","13","13","Maram aduna makhoina thangtup pambigi masasing puduna Ibungobu okpa chatlammi aduga makhoina laorak-i, “Hosanna! MAPU IBUNGO-gi mingda lenglakliba mahak adu yaiphabani! Israel-gi Ningthou adu yaiphabani!” ");
INSERT INTO mni_vpl VALUES ("JN12_14","073_12_14","JHN","12","14","14","Jisuna lola ama phangladuna mathakta tongkhatlammi, Mapugi puyada asumna ikhibagumbani: ");
INSERT INTO mni_vpl VALUES ("JN12_15","073_12_15","JHN","12","15","15","“Kiganu, he Zion-gi sahar! Yeng-u nahakki ningthou, lola macha ama tongduna lakli.” ");
INSERT INTO mni_vpl VALUES ("JN12_16","073_12_16","JHN","12","16","16","Matam aduda Ibungogi tung-inbasingna waram asi khangba ngamlamde. Adubu Jisubu matik mangal phang-hallaba matungda hairibasing asi Ibungo mahakki maramda ibani aduga makhoina masising asi Ibungoda toubani haiba ningsinglakkhi. ");
INSERT INTO mni_vpl VALUES ("JN12_17","073_12_17","JHN","12","17","17","Ibungona Lazarus-pu mongphamdagi kouthoktuna asibadagi hinggat-hankhiba matamda Ibungoga loinakhiba mising aduna thoudok adugi matangda koisan sandoklammi. ");
INSERT INTO mni_vpl VALUES ("JN12_18","073_12_18","JHN","12","18","18","Mi mayam amana Ibungobu unanaba hotnarammi maramdi Ibungona toukhiba angakpa khudam adugi matangda tarammi. ");
INSERT INTO mni_vpl VALUES ("JN12_19","073_12_19","JHN","12","19","19","Pharisee-singna makhoi masel amaga amaga asumna hainarak-i, “Khangledana, eikhoi karisu touba ngamdre haibasi. Yeng-u, taibangpan asigi mi pumnamakna mahakki matung inkhre!” ");
INSERT INTO mni_vpl VALUES ("JN12_20","073_12_20","JHN","12","20","20","Chakkhangba aduda Mapu Ibungobu khurumjanaba Jerusalem-da chatpasing adugi marakta Greek-ki mi kharasu yaorammi. ");
INSERT INTO mni_vpl VALUES ("JN12_21","073_12_21","JHN","12","21","21","Galilee-gi Bethsaida hairiba mapham asidagi lakpa nupa Philip-ki maphamda makhoina laklaga hairak-i, “Ibungo, eikhoi Jisubu unajaba pamjei.” ");
INSERT INTO mni_vpl VALUES ("JN12_22","073_12_22","JHN","12","22","22","Maduda Philip-na chattuna Andrew-da tamlure aduga makhoi anina chattuna Jisuda tamle. ");
INSERT INTO mni_vpl VALUES ("JN12_23","073_12_23","JHN","12","23","23","Jisuna makhoida khumlak-i, “Migi Machanupa adu matik mangal chaohan-gadaba pungpham adu lakle. ");
INSERT INTO mni_vpl VALUES ("JN12_24","073_12_24","JHN","12","24","24","Eina nakhoida tasengnamak hairibasini, gehu maru amana leipakta taraga sidrabadi madu maru ama oina adum leigani. Adubu maru aduna sirabadi mahei yamna yan-gani. ");
INSERT INTO mni_vpl VALUES ("JN12_25","073_12_25","JHN","12","25","25","Mahakki thawaibu nungsiba aduna madu mangjagani adubu taibangpan asida leiringeida mahakki thawaibu tukkachaba mahak aduna lomba naidana hingba phaoba madu thamgani ");
INSERT INTO mni_vpl VALUES ("JN12_26","073_12_26","JHN","12","26","26","Kanagumbana eibu thougal tourabadi mahak eigi itung in-gadabani; eina leiba maphamda eigi i-naisingsu leigani. Eibu thougal touba mahak adu eigi Ipana ikai khumnabigani. ");
INSERT INTO mni_vpl VALUES ("JN12_27","073_12_27","JHN","12","27","27","“Houjik ei thawai ware, eibu kari haisige? ‘Ipa, eibu pungpham asidagi kanbiyu?’ Natte, masigi maramgidamak eina pungpham asida lakpani. ");
INSERT INTO mni_vpl VALUES ("JN12_28","073_12_28","JHN","12","28","28","Ipa, nahakki minglen matik mangal chaohallu!” Adudagi khonjel amana swargadagi hairak-i, “Eina eigi ming matik mangal chaohankhre aduga amuk henna chaohan-gani.” ");
INSERT INTO mni_vpl VALUES ("JN12_29","073_12_29","JHN","12","29","29","Mapham aduda lepliba miyamsing aduna khonjel adu tarammi aduga mi kharana hai, masi nong khongbani, adubu ateising kharana hai, swarga dut amana mangonda wa ngangbani. ");
INSERT INTO mni_vpl VALUES ("JN12_30","073_12_30","JHN","12","30","30","Maduda Jisuna makhoida hairak-i, “Khonjel adu eigi kananaba hairakpa natte adubu nakhoigi kananabani. ");
INSERT INTO mni_vpl VALUES ("JN12_31","073_12_31","JHN","12","31","31","Houjik taibangpan asibu wayenba matamni; aduga taibangpan asigi mapu adu tanthokkhragani. ");
INSERT INTO mni_vpl VALUES ("JN12_32","073_12_32","JHN","12","32","32","Eibu malem asidagi thanggatpa matamda eina mi pumnamakpu eigi i-nakta chingsin-gani.” ");
INSERT INTO mni_vpl VALUES ("JN12_33","073_12_33","JHN","12","33","33","Ibungona masi haibasi mahak karamba maongda sigani haiba adu khang-hanbani. ");
INSERT INTO mni_vpl VALUES ("JN12_34","073_12_34","JHN","12","34","34","Miyamsing aduna khumlak-i, “Wayel Yathangdagi eikhoina khangle adudi Christtadi matam pumnamakta hingduna leigani. Aduga ‘Migi Machanupa adu thanggatpa tai’ haina nahakna kamdouna hairibano? Migi Machanupa hairibasi kanano?” ");
INSERT INTO mni_vpl VALUES ("JN12_35","073_12_35","JHN","12","35","35","Maduda Jisuna khumlak-i, “Nakhoigi narakta mangal adu atenba matam kharaga leithakhigani. Nakhoina amamba nangdanaba mangal leiringeida chatlu. Amambada chatpa mi aduna mahak kadaida chatlibano haiba khangde. ");
INSERT INTO mni_vpl VALUES ("JN12_36","073_12_36","JHN","12","36","36","Nakhoi mangalgi machasing oinanaba, mangal adu leiringeida nakhoina mangal adubu thajou.” Jisuna waphamsing asi hairamlaga chatkhre aduga masamak makhoidagi lotkhre. ");
INSERT INTO mni_vpl VALUES ("JN12_37","073_12_37","JHN","12","37","37","Makhoigi mamangda Ibungona angakpa khudam pumnamaksing asi tourabasu makhoina Ibungobu thajaramde. ");
INSERT INTO mni_vpl VALUES ("JN12_38","073_12_38","JHN","12","38","38","Masi Mapu Ibungogi wa phongdokpa maichou Isaiah-na haikhiba wa adu thungnanabani: “Mapu Ibungo, eikhoina haijaba paodam kanana thajabibage? Kanada MAPU IBUNGO-gi panggal phongdokpibage?” ");
INSERT INTO mni_vpl VALUES ("JN12_39","073_12_39","JHN","12","39","39","Makhoina thajaba ngamdabagi maramdi Isaiah-na mapham amada asumnasu haikhi, ");
INSERT INTO mni_vpl VALUES ("JN12_40","073_12_40","JHN","12","40","40","“Ibungona makhoigi mamit tang-halle aduga makhoigi thamoibu kalhalle, madu oirabadi makhoigi mitna uraroi, aduga makhoigi thamoina wakhal taroi, aduga eina makhoibu phahanbinaba makhoina eingonda hallaklaroi” ");
INSERT INTO mni_vpl VALUES ("JN12_41","073_12_41","JHN","12","41","41","Isaiah-na masi haikhibasi mahakna Jisugi matik mangal ubadagi Ibungo mahakki maramda haibani. ");
INSERT INTO mni_vpl VALUES ("JN12_42","073_12_42","JHN","12","42","42","Adum oinamak Jihudi luchingba mayam amana Jisubu thajarammi. Adubu Pharisee-singna makhoibu synagogue-tagi tanthokkani haibagi kiba maramna makhoina makhoigi thajaba adu phongdoklamde. ");
INSERT INTO mni_vpl VALUES ("JN12_43","073_12_43","JHN","12","43","43","Masi misingna makhoibu thagatpa aduna Tengban Mapuna makhoibu thagatpiba adudagi henna makhoina pambagi maramnani. ");
INSERT INTO mni_vpl VALUES ("JN12_44","073_12_44","JHN","12","44","44","Jisuna ahouba khonjelna hairak-i, “Mi amana eibu thajaba matamda mahakna eitabu thajaba natte adubu eibu thabirakpa Ibungo mahakpusu thajare. ");
INSERT INTO mni_vpl VALUES ("JN12_45","073_12_45","JHN","12","45","45","Eibu uba mahak aduna eibu thabirakpa Ibungo mahakpusu ujare. ");
INSERT INTO mni_vpl VALUES ("JN12_46","073_12_46","JHN","12","46","46","Eibu thajaba misingna amambada leitanaba ei taibangpanda mangal oina lakpani. ");
INSERT INTO mni_vpl VALUES ("JN12_47","073_12_47","JHN","12","47","47","Kanagumbana eigi wahei taraga indrabadi eina mahakpu wayelloi. Maramdi eihak taibangpan asibu wayelnaba lakpa natte adubu taibangpan asibu kanbinaba lakpani. ");
INSERT INTO mni_vpl VALUES ("JN12_48","073_12_48","JHN","12","48","48","Eibu yadaba amadi eigi waheibu loudaba makhoibu wayenba ama lei. Eina ngangthokkhraba waheising aduna makhoibu aroiba numitta wayen-gani. ");
INSERT INTO mni_vpl VALUES ("JN12_49","073_12_49","JHN","12","49","49","Ei isa inthantadagi eina ngangba natte adubu eina kari haigadaba amadi ngangadaba haibadu eibu thabirakpa Ipana eingonda yathang pibi. ");
INSERT INTO mni_vpl VALUES ("JN12_50","073_12_50","JHN","12","50","50","Ibungo mahakki yathangdi lomba naidana hingba aduda chingbi haiba eina khang-i. Maram aduna eina haiba khudingmak adu Ipana eingonda hainanaba haibibasingni.” ");
INSERT INTO mni_vpl VALUES ("JN13_1","073_13_1","JHN","13","1","1","Masi Lanthokpibagi Chakkhangba numitki nongma mamangdani. Taibangpan asi thadoktuna Mapa Ibungogi manakta chatkadaba matam adu lakle haiba Jisuna khangle. Taibangpanda leiriba Ibungo masagi oiba misingbu Ibungona matam pumbada nungsi aduga Ibungona makhoibu aroiba phaoba nungsibire. ");
INSERT INTO mni_vpl VALUES ("JN13_2","073_13_2","JHN","13","2","2","Numidanggi chaklen charingeida, Devil-na Simon-gi machanupa Judas Iscariot-ki thamoida Jisubu pithoknaba insinkhre. ");
INSERT INTO mni_vpl VALUES ("JN13_3","073_13_3","JHN","13","3","3","Mapa Ibungo Tengban Mapuna pumnamakki mathakta pannaba matik Ibungoda pibire amadi mahak Tengban Mapudagi lakpani aduga Tengban Mapugi maphamda amuk han-gadouri haiba khanglammi. ");
INSERT INTO mni_vpl VALUES ("JN13_4","073_13_4","JHN","13","4","4","Maram aduna Ibungona numidanggi chaklen charambadagi hougatlaga Ibungogi mapan thangba achonba phi adu louthoklaga khudei amana khwangda yetsille. ");
INSERT INTO mni_vpl VALUES ("JN13_5","073_13_5","JHN","13","5","5","Madugi matungda Ibungona khudeng amada ising heiraga mahakki tung-inbasinggi makhong isingna hamdokpire aduga Ibungogi khwangda yetliba khudei aduna teithokpiba houre. ");
INSERT INTO mni_vpl VALUES ("JN13_6","073_13_6","JHN","13","6","6","Asumna Ibungona Simon Peter-gi manakta lakpada Peter-na Ibungoda hairak-i, “Ibungo, Ibungona eigi khong hambigadouribra?” ");
INSERT INTO mni_vpl VALUES ("JN13_7","073_13_7","JHN","13","7","7","Maduda Jisuna khumlak-i, “Eina touriba asi houjik nahakna khangde adubu tungda nahakna khanglakkani.” ");
INSERT INTO mni_vpl VALUES ("JN13_8","073_13_8","JHN","13","8","8","Peter-na hairak-i, “Ibungo, Ibungona keidoungeidasu eigi khong hambiroidabani.” Maduda Jisuna khumlak-i, “Eina nahakki khong hambidrabadi nahak eihakka karisu mari leinade.” ");
INSERT INTO mni_vpl VALUES ("JN13_9","073_13_9","JHN","13","9","9","Adudagi Simon Peter-na hairak-i, “Adu oirabadi Ibungo, eigi khongda natte eigi khut amadi kokpusu chambiyu!” ");
INSERT INTO mni_vpl VALUES ("JN13_10","073_13_10","JHN","13","10","10","Maduda Jisuna khumlak-i, “Irujaraba mi amana mahakki khong nattana atei chamningai leite makhoigi hakchang pumba senglabani. Aduga mi amakhak nattana nakhoi pumnamak seng-i.” ");
INSERT INTO mni_vpl VALUES ("JN13_11","073_13_11","JHN","13","11","11","Jisuna mahakpu kanana pithokkani haiba hannana khangbagi maramna “Mi amakhak nattana nakhoi pumnamak sengle” haina haibani. ");
INSERT INTO mni_vpl VALUES ("JN13_12","073_13_12","JHN","13","12","12","Jisuna makhoigi khong hambiraba matungda mahakki mapan thangba achonba phi adu amuk setchille aduga hannagi phamphamda amuk phamthare aduga Ibungona makhoida hanglak-i, “Eina nakhoida toukhiba adu nakhoina khangba ngambra?” ");
INSERT INTO mni_vpl VALUES ("JN13_13","073_13_13","JHN","13","13","13","“Nakhoina eibu Mapu Ibungo amadi Oja haina kou-i, madu achumbani maramdi nakhoina kouriba adumak eihak oiribani. ");
INSERT INTO mni_vpl VALUES ("JN13_14","073_13_14","JHN","13","14","14","Nakhoigi Mapu amadi Oja oiriba eihakna nakhoigi khongsing hambire, nakhoinasu nakhoi amana amagi khong hambipham thok-i. ");
INSERT INTO mni_vpl VALUES ("JN13_15","073_13_15","JHN","13","15","15","Eina nakhoida toukhibagumna nakhoinasu tounaba eina nakhoida thabak oina utle. ");
INSERT INTO mni_vpl VALUES ("JN13_16","073_13_16","JHN","13","16","16","Eina nakhoida tasengnamak hairibasini manaina mapudagi henna chaode aduga pao puriba mi amana mahakpu thariba mi adudagi henna chaode. ");
INSERT INTO mni_vpl VALUES ("JN13_17","073_13_17","JHN","13","17","17","Houjikti nakhoina masising asi khangle aduna hairibasing asi nakhoina tourabadi nakhoi yaiphagani. ");
INSERT INTO mni_vpl VALUES ("JN13_18","073_13_18","JHN","13","18","18","“Eina masising asi nakhoi pumnamakki maramda haibadi natte; eina khanggatlaba makhoi adu eina khang-i. Adubu ‘Eigi tal chaba mahak aduna eigi maiyokta leple’ haiba Mapugi puyagi wa adu thungnanabani. ");
INSERT INTO mni_vpl VALUES ("JN13_19","073_13_19","JHN","13","19","19","Thoudok adu thokpa matamda, eihak asi eina hairiba mahak aduni haiba nakhoina thajanaba thoudok adu thoktringeida eina nakhoida hanna haibani. ");
INSERT INTO mni_vpl VALUES ("JN13_20","073_13_20","JHN","13","20","20","Eina nakhoida tasengnamak hairibasini, kanagumbana eina thaba mi amabu lousillabadi mahakna eibu lousillabani aduga eibu lousinba mahak aduna eibu thabirakpa Ibungo mahakpu lousillabani.” ");
INSERT INTO mni_vpl VALUES ("JN13_21","073_13_21","JHN","13","21","21","Jisuna masi hairaba tungda mahak thawai waraduna phongna hairak-i, “Eina nakhoida tasengnamak hairibasini, nakhoigi naraktagi amana eibu pithokkani.” ");
INSERT INTO mni_vpl VALUES ("JN13_22","073_13_22","JHN","13","22","22","Ibungona haikhibadu kanagi maramda haibano haiba chamamnaduna Ibungogi tung-inbasingna makhoi masel amaga amaga yengnarammi. ");
INSERT INTO mni_vpl VALUES ("JN13_23","073_13_23","JHN","13","23","23","Tung-inbasing adugi maraktagi Jisuna nungsijaba tung-inba aduna Jisugi manakta phamlammi. ");
INSERT INTO mni_vpl VALUES ("JN13_24","073_13_24","JHN","13","24","24","Simon Peter-na mangonda inggit piduna hairak-i, “Ibungona hairibadu kanagi maramdano hang-u.” ");
INSERT INTO mni_vpl VALUES ("JN13_25","073_13_25","JHN","13","25","25","Maram aduna tung-inba aduna Ibungogi manakta naksallaga hanglak-i, “Ibungo, mahaktu kanano?” ");
INSERT INTO mni_vpl VALUES ("JN13_26","073_13_26","JHN","13","26","26","Maduda Jisuna khumlak-i, “Eina tal machet ama tenggotta luplaga pigadouriba mahak aduni.” Adudagi Ibungona tal machet ama loure aduga tenggotta luplaga Simon Iscariot-ki machanupa Judas-ta pirammi. ");
INSERT INTO mni_vpl VALUES ("JN13_27","073_13_27","JHN","13","27","27","Judas-na tal adu hek loubaga Satan-na mahakki nungda changkhre. Maduda Jisuna hairak-i, “Nahakna tougadaba adu thuna touro.” ");
INSERT INTO mni_vpl VALUES ("JN13_28","073_13_28","JHN","13","28","28","Chaklen aduda yaoriba kana amatana Jisuna hairiba adu karino haiba khanglamde. ");
INSERT INTO mni_vpl VALUES ("JN13_29","073_13_29","JHN","13","29","29","Judas-na sen-gao panaba oibanina Jisuna mangonda Chakkhangba adugi changgadaba potlamsing leirunaba nattraga lairabasingda karigumba khara pirunaba haibani haina makhoina khallammi. ");
INSERT INTO mni_vpl VALUES ("JN13_30","073_13_30","JHN","13","30","30","Judas-na tal adu hek loubaga khudakta thokkhre. Matam adu numidang oirammi. ");
INSERT INTO mni_vpl VALUES ("JN13_31","073_13_31","JHN","13","31","31","Judas-na thokkhrabada Jisuna hairak-i, “Houjik Migi Machanupa adubu matik mangal chaohalle aduga mahakki mapanna Tengban Mapubu matik mangal chaohalle. ");
INSERT INTO mni_vpl VALUES ("JN13_32","073_13_32","JHN","13","32","32","Mahakki mapanna Tengban Mapubu matik mangal chaohallabadi Migi Machanupa adubu Tengban Mapu mahakki mapanna matik mangal chaohan-gani aduga thunamak mahakpu matik mangal chaohan-gani. ");
INSERT INTO mni_vpl VALUES ("JN13_33","073_13_33","JHN","13","33","33","Nungsiba angangsa, matam kharadang eina nakhoiga loinakhigani. Eina Jihudisingda haibagumna houjik eina nakhoida hairi, ‘Nakhoina eibu thigani adubu eina chatpa mapham aduda nakhoina lakpa ngamloi.’ ");
INSERT INTO mni_vpl VALUES ("JN13_34","073_13_34","JHN","13","34","34","Eina nakhoida anouba yathang ama piri madudi nakhoi amaga amaga nungsinou. Eina nakhoibu nungsibagumna nakhoinasu amaga amaga nungsinou. ");
INSERT INTO mni_vpl VALUES ("JN13_35","073_13_35","JHN","13","35","35","Nakhoi amaga amaga nungsinarabadi mi khudingna nakhoi eigi tung-inbasingni haiba khanggani.” ");
INSERT INTO mni_vpl VALUES ("JN13_36","073_13_36","JHN","13","36","36","Simon Peter-na Ibungoda hanglak-i, “Ibungo, kadaida chatpigadouribano?” Maduda Jisuna khumlak-i, “Eina chatpa mapham aduda nakhoi houjik tung illakpa ngamloi adubu nakhoina konna itung in-gani.” ");
INSERT INTO mni_vpl VALUES ("JN13_37","073_13_37","JHN","13","37","37","Peter-na hanglak-i, “Ibungo, karigi houjik eina Ibungogi tung inba ngamloidouribano? Ei Ibungogidamak thawai thajagani.” ");
INSERT INTO mni_vpl VALUES ("JN13_38","073_13_38","JHN","13","38","38","Jisuna khumlak-i, “Tasengnamak nahak eigidamak thawai thagadra? Eina nangonda tasengnamak hairibasini yenbarabana khongdringeida nahakna eibu khangde haina ahumlak haigani .” ");
INSERT INTO mni_vpl VALUES ("JN14_1","073_14_1","JHN","14","1","1","Jisuna mahakki tung-inbasingda hairak-i, “Nakhoi pukning langtaknaganu. Tengban Mapubu thajou aduga eibusu thajou. ");
INSERT INTO mni_vpl VALUES ("JN14_2","073_14_2","JHN","14","2","2","Eigi Ipagi yumda leipham yamna lei madu natlamdrabadi eina nakhoida hairamgadabani. Eina nakhoigidamak mapham thourang touba chatli. ");
INSERT INTO mni_vpl VALUES ("JN14_3","073_14_3","JHN","14","3","3","Aduga eina chattuna nakhoigidamak mapham thourang touraba matungda, eina leiba mapham aduda nakhoisu eiga leiminnanaba eina nakhoibu louba lakkani. ");
INSERT INTO mni_vpl VALUES ("JN14_4","073_14_4","JHN","14","4","4","Eina chatkadaba mapham adugi lambi adu nakhoina khang-i.” ");
INSERT INTO mni_vpl VALUES ("JN14_5","073_14_5","JHN","14","5","5","Maduda Thomas-na hairak-i, “Ibungo, Ibungona kadaida lenglibano haiba eikhoi khangjade aduna kamdouna eikhoina lambi adu khanggadouribano?” ");
INSERT INTO mni_vpl VALUES ("JN14_6","073_14_6","JHN","14","6","6","Jisuna khumlak-i, “Lambi adusu achumba adusu hingba adusu eini. Eigi ipanna nattana kana amatana eigi Ipagi maphamda thungba ngamloi. ");
INSERT INTO mni_vpl VALUES ("JN14_7","073_14_7","JHN","14","7","7","Nakhoina eibu tasengna khanglamlabadi eigi Ipabusu khanglamgadabani. Houjiktagidi nakhoina Ibungo mahakpu khangle amasung ure.” ");
INSERT INTO mni_vpl VALUES ("JN14_8","073_14_8","JHN","14","8","8","Maduda Philip-na hairak-i, “Ibungo, Ibungogi Ipa adu eikhoida uhanbiyu, maduna eikhoigi apenba oijagani.” ");
INSERT INTO mni_vpl VALUES ("JN14_9","073_14_9","JHN","14","9","9","Jisuna khumlak-i, “Philip, asuk kuina eina nahakka loinaraba phaoba nahakna houjik phaoba eibu khangdribra? Eibu uba mahak aduna Ipa adubu ure. Aduna karamna nahakna ‘Ipa adu eikhoida uhanabiyu’ haina hairibano? ");
INSERT INTO mni_vpl VALUES ("JN14_10","073_14_10","JHN","14","10","10","Eina Ipada lei aduga Ipana eingonda lei haibasi nahak thajadabra? Eina nakhoida haiba waheising asi eigi isadagi natte. Adubu eingonda leiriba Ipa aduna thabak touribani. ");
INSERT INTO mni_vpl VALUES ("JN14_11","073_14_11","JHN","14","11","11","Eina Ipada lei aduga Ipana eingonda lei haiba asida eibu thajou. Nattraga eina touba thabaksing adugi maramna eibu thajou. ");
INSERT INTO mni_vpl VALUES ("JN14_12","073_14_12","JHN","14","12","12","Eina nakhoida tasengnamak hairibasini, eibu thajaba misingna eina touba thabaksing tougani. Makhoina masising asidagi henna chaoba thabaksing tougani maramdi eina Ipagi maphamda chatli. ");
INSERT INTO mni_vpl VALUES ("JN14_13","073_14_13","JHN","14","13","13","Machanupa adugi mapanna Mapa adubu matik mangal phang-hannaba nakhoina eigi mingda nija nijaba khudingmak eina toubigani. ");
INSERT INTO mni_vpl VALUES ("JN14_14","073_14_14","JHN","14","14","14","Nakhoina eingonda karigumba ama eigi mingda nijarabadi nijariba adu eina toubigani. ");
INSERT INTO mni_vpl VALUES ("JN14_15","073_14_15","JHN","14","15","15","“Nakhoina eibu nungsirabadi, nakhoina eigi yathangsing ngakkani. ");
INSERT INTO mni_vpl VALUES ("JN14_16","073_14_16","JHN","14","16","16","Eina Ipada haijagani aduga Ipana nakhoida atoppa Pangbiba ama thabirakkani aduga mahakna nakhoiga matam pumbada loinabigani. ");
INSERT INTO mni_vpl VALUES ("JN14_17","073_14_17","JHN","14","17","17","Ibungo mahakti Mapu Ibungogi oiba achumba adubu phongdokpiba Thawai aduni. Taibangpanna Ibungo mahakpu lousinba ngamde maramdi makhoina Ibungo mahakpu usu ude khangsu khangde. ");
INSERT INTO mni_vpl VALUES ("JN14_18","073_14_18","JHN","14","18","18","“Eina nakhoibu pidat padatpa machasinggum thanamloi; eina nakhoigi nanakta amuk lakkani. ");
INSERT INTO mni_vpl VALUES ("JN14_19","073_14_19","JHN","14","19","19","Matam khara leiraga taibangpanbana eibu amuk uraroi adubu nakhoinadi eibu ugani. Eina hingbagi maramna nakhoisu hinggani. ");
INSERT INTO mni_vpl VALUES ("JN14_20","073_14_20","JHN","14","20","20","Eina Ipada lei, nakhoina eingonda lei aduga eina nakhoida lei haibasi numit aduda nakhoina khanggani. ");
INSERT INTO mni_vpl VALUES ("JN14_21","073_14_21","JHN","14","21","21","“Eigi yathangsingbu louba amadi yathangsing adubu inba makhoi adu eibu nungsibani. Eibu nungsiba makhoi adubu eigi Ipana nungsigani aduga einasu nungsigani amadi eisamak makhoida phongdokpigani.” ");
INSERT INTO mni_vpl VALUES ("JN14_22","073_14_22","JHN","14","22","22","Adudagi Judas-na (Judas Iscariot nattaba) hairak-i, “Ibungo, Ibungona nasabu eikhoida phongdokpigani aduga taibangpanbadadi phongdokpiroi hairibasigi maram karino?” ");
INSERT INTO mni_vpl VALUES ("JN14_23","073_14_23","JHN","14","23","23","Maduda Jisuna khumlak-i, “Kanagumbana eibu nungsirabadi, mahakna eigi wa in-gani. Eigi Ipana mahakpu nungsigani aduga eikhoina mangonda laktuna mahakka loinana leiminnagani. ");
INSERT INTO mni_vpl VALUES ("JN14_24","073_14_24","JHN","14","24","24","Eibu nungsidaba mahak aduna eigi wasing ngakloi. Nakhoina tariba waheising asi ei isagi natte waheising asi eibu thabirakliba Ipa mahakkini. ");
INSERT INTO mni_vpl VALUES ("JN14_25","073_14_25","JHN","14","25","25","“Eina nakhoiga leiminnaringeida masising asi eina haibani. ");
INSERT INTO mni_vpl VALUES ("JN14_26","073_14_26","JHN","14","26","26","Eigi mingda Ipana nakhoida thabirakkadaba Pangbiba haibadi Thawai Asengba Ibungo mahakna pumnamak nakhoida tambigani aduga eina nakhoida haikhiba pumnamak nakhoida ningsing-hanbirakkani. ");
INSERT INTO mni_vpl VALUES ("JN14_27","073_14_27","JHN","14","27","27","“Eina nakhoida ingthaba thanammi; eigi ingthaba eina nakhoida pi. Taibangpanna pibagumna eina madu nakhoida piba natte. Maram asina nakhoi kiganu amadi pukning langtaknaganu. ");
INSERT INTO mni_vpl VALUES ("JN14_28","073_14_28","JHN","14","28","28","‘Ei chatlagani aduga nakhoigi nanakta amuk lakkani’ haina eina haiba asi nakhoina tare. Nakhoina eibu nungsirabadi, eina Ipagi maphamda chatkadaba maramna nakhoi haraogani maramdi Ipana eingondagi henna chao-i. ");
INSERT INTO mni_vpl VALUES ("JN14_29","073_14_29","JHN","14","29","29","Thoudok asi thokpa matamda nakhoina thajananaba thoktringeida eina masi nakhoida haibani. ");
INSERT INTO mni_vpl VALUES ("JN14_30","073_14_30","JHN","14","30","30","Eina nakhoiga yamna ngangnararoi maramdi taibangpan asigi mapu mahak lakli. Eigi ithakta mahakki panggal leite. ");
INSERT INTO mni_vpl VALUES ("JN14_31","073_14_31","JHN","14","31","31","Eina Ipabu nungsi haiba taibangpanbana khangnanaba Ipana eingonda pibiba yathang adumak eina tou-i. “Hougatlo, eikhoi mapham asidagi chatlasi. ");
INSERT INTO mni_vpl VALUES ("JN15_1","073_15_1","JHN","15","1","1","“Achumba anggur mari adu eini aduga eigi Ipana ingkhol koiba mi aduni. ");
INSERT INTO mni_vpl VALUES ("JN15_2","073_15_2","JHN","15","2","2","Mahei yandaba masasing adu Ibungo mahakna kakthatli aduga mahei yanba masasing adubu mahei henna yananaba masa mareng kakthatpi. ");
INSERT INTO mni_vpl VALUES ("JN15_3","073_15_3","JHN","15","3","3","Eina nakhoida haikhiba wa adugi maramna nakhoi sengle. ");
INSERT INTO mni_vpl VALUES ("JN15_4","073_15_4","JHN","15","4","4","Eingonda tattana leiyu aduga eina nakhoida tattana leigani. Masa amatana masa mathanta mahei yanba ngamde aduna masa adu anggur pambi aduda leiba tai. Adugumduna nakhoina eingonda tattana leiba nattana mahei yanba ngamloi. ");
INSERT INTO mni_vpl VALUES ("JN15_5","073_15_5","JHN","15","5","5","“Anggur mari adu eini aduga nakhoina masasingni. Nakhoina eingonda itattattana leirabadi eina nakhoida lei aduga nakhoina mahei yan-gani; ei yaodana nakhoi karisu touba ngamloi. ");
INSERT INTO mni_vpl VALUES ("JN15_6","073_15_6","JHN","15","6","6","Nakhoina eingonda tattana leitrabadi nakhoi hundoklaba amadi kangsillaba masa amagumle. Adugumba masasing adudi loukhattuna meinungda langsilli aduga mei thadok-i. ");
INSERT INTO mni_vpl VALUES ("JN15_7","073_15_7","JHN","15","7","7","Nakhoina eingonda tattana leirabadi eigi waheising nakhoida tattana lei, adu oirabadi nakhoina niningba adu nijou madu nakhoida pibigani. ");
INSERT INTO mni_vpl VALUES ("JN15_8","073_15_8","JHN","15","8","8","Nakhoina mahei yamna yanduna eigi tung-inbasingni haina utpa aduda eigi Ipagi matik mangal oihalli. ");
INSERT INTO mni_vpl VALUES ("JN15_9","073_15_9","JHN","15","9","9","Eigi Ipana eibu nungsibagumna eina nakhoibu nungsi. Eigi nungsibada tattana leiyu. ");
INSERT INTO mni_vpl VALUES ("JN15_10","073_15_10","JHN","15","10","10","Eina Ipagi yathang ngaktuna Ibungo mahakki nungsibada leibagumna, nakhoina eigi yathang ngaklabadi nakhoina eigi nungsibada leigani. ");
INSERT INTO mni_vpl VALUES ("JN15_11","073_15_11","JHN","15","11","11","“Eigi haraoba nakhoida leiduna nakhoigi haraoba mapung phananaba eina masi nakhoida haibani. ");
INSERT INTO mni_vpl VALUES ("JN15_12","073_15_12","JHN","15","12","12","Eina nakhoibu nungsibagum nakhoinasu amaga amaga nungsinou: masi eigi yathangni. ");
INSERT INTO mni_vpl VALUES ("JN15_13","073_15_13","JHN","15","13","13","Mi amana mahakki marupsinggidamak leiba khwaidagi athoiba nungsiba adudi makhoigidamak mahakki thawai thadokpa aduni. ");
INSERT INTO mni_vpl VALUES ("JN15_14","073_15_14","JHN","15","14","14","Eina nakhoida piba yathangsing asi nakhoina tourabadi nakhoi eigi marupni. ");
INSERT INTO mni_vpl VALUES ("JN15_15","073_15_15","JHN","15","15","15","Eina nakhoibu amuk hanna minai kouraroi maramdi minaina mahakki mapuna kari touribano haibadu khangde. Adubu eina nakhoibu marup koure maramdi eina Ipadagi taba pumnamak adu nakhoida khang-halle. ");
INSERT INTO mni_vpl VALUES ("JN15_16","073_15_16","JHN","15","16","16","Nakhoina eibu khanba natte adubu nakhoina chattuna tattana leiba mahei yannanaba nakhoibu eina khalle amadi pham haple. Eigi mingda Ipagi maphamda nakhoina niningba adu nijabada Ipana nakhoida pibigani. ");
INSERT INTO mni_vpl VALUES ("JN15_17","073_15_17","JHN","15","17","17","Eina nakhoida piba yathang adudi masini: Nakhoi amaga amaga nungsinou. ");
INSERT INTO mni_vpl VALUES ("JN15_18","073_15_18","JHN","15","18","18","“Taibangpanbana nakhoibu tukkacharabadi nakhoibu tukkachadringeida eibu hanna tukkachei haibasi nakhoina ningsing-u. ");
INSERT INTO mni_vpl VALUES ("JN15_19","073_15_19","JHN","15","19","19","Nakhoi taibangpanbagi mi oiramlabadi, taibangpanbana nakhoibu masagi oibagum nungsiramgadabani. Nakhoina taibangpanbagi mi oirambadagi eina nakhoibu khandoklabanina nakhoi taibangpanbagi oidre. Maram aduna taibangpanbana nakhoibu tukkachabani. ");
INSERT INTO mni_vpl VALUES ("JN15_20","073_15_20","JHN","15","20","20","‘Minaina mahakki mapudagi henna chaode’ haina eina nakhoida haikhiba adu ningsing-u. Makhoina eibu ot-neirabadi nakhoibusu ot-neigani, makhoina eigi tambiba adu illabadi nakhoigi tambibasu in-gani. ");
INSERT INTO mni_vpl VALUES ("JN15_21","073_15_21","JHN","15","21","21","Nakhoi eigi oiba maramna makhoina nakhoida pumnamak asi tougani maramdi makhoina eibu thabirakpa Ibungo mahakpu khangde. ");
INSERT INTO mni_vpl VALUES ("JN15_22","073_15_22","JHN","15","22","22","Eina laktuna makhoida wa nganglamdrabadi makhoi papki maral leiramloidabani. Adubu houjikti makhoi pap kupsinpham leite. ");
INSERT INTO mni_vpl VALUES ("JN15_23","073_15_23","JHN","15","23","23","Kanagumba amana eibu tukkacharabadi mahakna eigi Ipabusu tukkachare. ");
INSERT INTO mni_vpl VALUES ("JN15_24","073_15_24","JHN","15","24","24","Eina makhoigi marakta mi kana amatana toukhidriba thabaksing touramdrabadi makhoi papki maral leiramloidabani. Adubu houjikti makhoina angakpa thabaksing ure aduga makhoina eibusu eigi Ipabusu tukkachare. ");
INSERT INTO mni_vpl VALUES ("JN15_25","073_15_25","JHN","15","25","25","‘Makhoina maram leitana eibu tukkachei’ haina Wayel Yathangda ikhiba adu thungnanabani. ");
INSERT INTO mni_vpl VALUES ("JN15_26","073_15_26","JHN","15","26","26","“Ipana nakhoida thabirakkadaba achumbagi Thawai oiriba Ipadagi lakkadaba Pangbiba Ibungo mahakna eigi maramda haigani. ");
INSERT INTO mni_vpl VALUES ("JN15_27","073_15_27","JHN","15","27","27","Houbadagi nakhoina eiga loinarakpa maramna nakhoinasu eigi maramda wa nganggadabani. ");
INSERT INTO mni_vpl VALUES ("JN16_1","073_16_1","JHN","16","1","1","“Nakhoigi thajaba mangdananaba eina nakhoida pumnamak asi hairibani. ");
INSERT INTO mni_vpl VALUES ("JN16_2","073_16_2","JHN","16","2","2","Makhoina nakhoibu Synagogue-singdagi tanthokkani aduga nakhoibu hatpa misingna Tengban Mapuda thougal toubani haina khan-gadaba matam adu lakli. ");
INSERT INTO mni_vpl VALUES ("JN16_3","073_16_3","JHN","16","3","3","Makhoina Ipabusu eibusu khangdabagi maramna makhoina hairibasing asi nakhoida tougani. ");
INSERT INTO mni_vpl VALUES ("JN16_4","073_16_4","JHN","16","4","4","Matam adu lakpada eina nakhoida hannana cheksin wa haikhre haiba nakhoina ningsingnanaba eina waphamsing asi nakhoida hairibani. “Eina nakhoiga loinaduna leiba maramna ahanbadadi eina masi nakhoida haidabani. ");
INSERT INTO mni_vpl VALUES ("JN16_5","073_16_5","JHN","16","5","5","Houjikti eihak eibu thabirakpa Ibungo mahakki maphamda chatlagani adubu nakhoi kana amatana ‘Nahak kadaida chatkadouribano’ haina eingonda hangde. ");
INSERT INTO mni_vpl VALUES ("JN16_6","073_16_6","JHN","16","6","6","Adubu eina waphamsing asi haibagi maramna nakhoigi pukning awabana thalle. ");
INSERT INTO mni_vpl VALUES ("JN16_7","073_16_7","JHN","16","7","7","Adubu eina nakhoida tasengnamak hairibasini, eina chatthokpa asi nakhoigidamak aphabani. Karigumba eina chatthoktrabadi Pangbiba Ibungo mahak adu nakhoigi naphamda lakloi. Aduga eina chatthoklabadi Ibungo mahakna nakhoigi naphamda lakkani. ");
INSERT INTO mni_vpl VALUES ("JN16_8","073_16_8","JHN","16","8","8","Ibungo mahakna lakpa matamda papki oiba maram, achumba chatpagi maram amasung wayen-gi matangda taibangpanbabu lalli haiba utkani. ");
INSERT INTO mni_vpl VALUES ("JN16_9","073_16_9","JHN","16","9","9","Papki matangdadi misingna eibu thajadabagi maramdani; ");
INSERT INTO mni_vpl VALUES ("JN16_10","073_16_10","JHN","16","10","10","achumba chatpagi matangdadi ei Ipagi maphamda chatli aduga nakhoina eibu amuk uraroi; ");
INSERT INTO mni_vpl VALUES ("JN16_11","073_16_11","JHN","16","11","11","aduga wayen-gi matangdadi taibangpan-gi mapu adu wayenkhre. ");
INSERT INTO mni_vpl VALUES ("JN16_12","073_16_12","JHN","16","12","12","“Eina nakhoida haigadaba yamna leiri adubu houjik nakhoina madu puba ngamloi. ");
INSERT INTO mni_vpl VALUES ("JN16_13","073_16_13","JHN","16","13","13","Achumbagi Thawai aduna lakpa matamda Ibungo mahakna nakhoibu achumba pumnamakta chingbigani. Ibungo mahakna mahakki masagi oibadagi ngangloi adubu mahakna taba adu khakta nganggani aduga Ibungo mahakna tungda thoklagadabasing adu nakhoida haibigani. ");
INSERT INTO mni_vpl VALUES ("JN16_14","073_16_14","JHN","16","14","14","Ibungo mahakna eina haiba adu louraga nakhoida haibiduna eingonda matik mangal oihan-gani. ");
INSERT INTO mni_vpl VALUES ("JN16_15","073_16_15","JHN","16","15","15","Ipagi areiba pumnamak eigini; maram aduna eigi oiba adudagi louraga Thawai aduna nakhoida haibigani haina eina hairibani. ");
INSERT INTO mni_vpl VALUES ("JN16_16","073_16_16","JHN","16","16","16","“Matam khara leiraga nakhoina eibu uraroi aduga matam khara leiraga nakhoina eibu amuk ugani.” ");
INSERT INTO mni_vpl VALUES ("JN16_17","073_16_17","JHN","16","17","17","Ibungogi tung-inba kharana makhoi masel amaga amaga ngangnarak-i, “Ibungona hairibasi kari hairibano? ‘Matam khara leiraga nakhoina eibu uraroi aduga matam khara leiraga nakhoina eibu amuk ugani,’ aduga mahakna asisu hai ‘Maramdi ei Ipagi maphamda chatkadouri.’ ");
INSERT INTO mni_vpl VALUES ("JN16_18","073_16_18","JHN","16","18","18","‘Matam khara leiraga’ hairibasi Ibungona kari haininglibano? Ibungona hairibasi karino haiba eikhoi khangba ngamde.” ");
INSERT INTO mni_vpl VALUES ("JN16_19","073_16_19","JHN","16","19","19","Makhoina hiram asigi matangda hangningle haiba Jisuna khangladuna makhoida hairak-i, “Eina nakhoida ‘Matam khara leiraga nakhoina eibu uraroi aduga matam khara leiraga nakhoina eibu amuk ugani’ haina nakhoida haiba adugi wahanthok karino haina nakhoi nasen hangnaribra? ");
INSERT INTO mni_vpl VALUES ("JN16_20","073_16_20","JHN","16","20","20","Eina nakhoida tasengnamak hairibasini, taibangpanbana haraoringeida nakhoina kapkani. Nakhoi wagani adubu nakhoigi awaba adu haraobada onthokkani. ");
INSERT INTO mni_vpl VALUES ("JN16_21","073_16_21","JHN","16","21","21","Nupi amana angang unaramdaida naoyek-i maramdi mahakki pungpham adu lakle. Adubu mahakna angang adu hek pokpada, angang ama taibangpanbada pokle haibagi haraobana mahakki awaba adu kaothok-i. ");
INSERT INTO mni_vpl VALUES ("JN16_22","073_16_22","JHN","16","22","22","Adugumduna houjik nakhoigi awaba matamni adubu eina nakhoiga amuk unagani maduda nakhoi haraogani aduga kana amatana nakhoidagi haraobadu louthokpa ngamloi. ");
INSERT INTO mni_vpl VALUES ("JN16_23","073_16_23","JHN","16","23","23","“Numit adu lakpada nakhoina eingonda karisu hangloi. Eina nakhoida tasengnamak hairibasini, nakhoina eigi mingda Ipagi maphamda nijaba adu Ipana nakhoida pibigani. ");
INSERT INTO mni_vpl VALUES ("JN16_24","073_16_24","JHN","16","24","24","Houjik phaoba nakhoina eigi mingda karisu nijadri; nakhoigi haraoba mapung phanaba nijou aduga nakhoina phangjagani. ");
INSERT INTO mni_vpl VALUES ("JN16_25","073_16_25","JHN","16","25","25","“Eina nakhoida pandamsing sijinnaduna haibani adubu pandamsing sijinnadana Ipagi maramda phongna eina nakhoida haigadaba matam adu lakli. ");
INSERT INTO mni_vpl VALUES ("JN16_26","073_16_26","JHN","16","26","26","Numit aduda nakhoina eigi mingda Ipada nijagani. Eina nakhoigidamak Ipada haijagani haiba natte, ");
INSERT INTO mni_vpl VALUES ("JN16_27","073_16_27","JHN","16","27","27","maramdi Ipa Ibungo mahakmakna nakhoibu nungsi. Nakhoina eibu nungsiba amadi eihak Ipagi maphamdagi lakpani haina nakhoina thajabagi maramna Ipana nakhoibu nungsi. ");
INSERT INTO mni_vpl VALUES ("JN16_28","073_16_28","JHN","16","28","28","Eina Ipagi maphamdagi thoraklaga taibangpan asida lakpani aduga houjikti eihak taibangpan asi thadoktuna Ipagi maphamda hallagani.” ");
INSERT INTO mni_vpl VALUES ("JN16_29","073_16_29","JHN","16","29","29","Maduda Ibungogi tung-inbasingna Ibungoda hairak-i, “Houjikti Ibungona pandam sijinnadana sengna haibire. ");
INSERT INTO mni_vpl VALUES ("JN16_30","073_16_30","JHN","16","30","30","Ibungona pumnamak khang-i haiba houjikti eikhoina khangle aduga kanagumba amana Ibungoda wahang hangbagi kanaba leitre. Masina Ibungodi Tengban Mapudagi lakpani haibasi eikhoida thajahalli.” ");
INSERT INTO mni_vpl VALUES ("JN16_31","073_16_31","JHN","16","31","31","Jisuna makhoida khumlak-i, “Houjikti nakhoina thajarabra? ");
INSERT INTO mni_vpl VALUES ("JN16_32","073_16_32","JHN","16","32","32","Nakhoi pumnamakna nasa nasagi maphamda ichai chaithokkhiduna eihak ithanta thadoklamgadaba pungpham adu lakkadouri, hoi, madu houjik lakle. Adubu ei ithanta oide maramdi Ipana eiga loinabiri. ");
INSERT INTO mni_vpl VALUES ("JN16_33","073_16_33","JHN","16","33","33","Nakhoina eingonda leiraga ingthaba phangnanaba eina nakhoida masi haibani. Taibangpan asida nakhoida awaba nungaitaba leigani adubu nathouna phou maramdi eina taibangpanbabu ngamle!” ");
INSERT INTO mni_vpl VALUES ("JN17_1","073_17_1","JHN","17","1","1","Jisuna masi hairaba matungda Ibungona swargada yengkhatlaga hairak-i, “Ipa matam adu lakle. Ibungogi Nachanupana Ibungobu natik nangal chaohannaba Nachanupabu matik mangal chaohanbiyu. ");
INSERT INTO mni_vpl VALUES ("JN17_2","073_17_2","JHN","17","2","2","Ibungona mangonda mi pumnamakki mathakta matik pibire madu Ibungona mangonda pibiba makhoi pumnamakta mahakna lomba naidaba hingba pinanabani. ");
INSERT INTO mni_vpl VALUES ("JN17_3","073_17_3","JHN","17","3","3","Amatta ngairaba achumba Tengban Mapu nahakpu khangba amadi Ibungona thabirakpa Jisu Christtabu khangba asi lomba naidana hingba aduni. ");
INSERT INTO mni_vpl VALUES ("JN17_4","073_17_4","JHN","17","4","4","Eina pangthoknanaba Ibungona eingonda pibiba thabak adu pangthokpa loiraduna taibangpan asida eihakna Ibungogi matik mangal chaohalle. ");
INSERT INTO mni_vpl VALUES ("JN17_5","073_17_5","JHN","17","5","5","Ipa, taibangpan asi semdringeida eina Ibungoga loinana leiramba matik mangal adumak houjik eibu Ibungogi manakta matik mangal chaohanbiyu. ");
INSERT INTO mni_vpl VALUES ("JN17_6","073_17_6","JHN","17","6","6","“Taibangpan asidagi Ibungona eingonda pibiba makhoida eina Ibungo nahakpu phongdokle. Makhoi Ibungogini, Ibungona eingonda pibibani. Makhoina Ibungogi wa injare. ");
INSERT INTO mni_vpl VALUES ("JN17_7","073_17_7","JHN","17","7","7","Eigi leijaba pumnamak Ibungo nahakna pibibani haiba makhoina houjikti khangle. ");
INSERT INTO mni_vpl VALUES ("JN17_8","073_17_8","JHN","17","8","8","Ibungona eingonda pibiba wasing adu eina makhoida pire aduga makhoina wasing adu lousille. Eihak Ibungodagi lakpani haiba makhoina tasengna khangle aduga Ibungona eibu thabirakpani haiba makhoina thajare. ");
INSERT INTO mni_vpl VALUES ("JN17_9","073_17_9","JHN","17","9","9","“Eina makhoigidamak haijabani. Eina taibangpan-gidamak haijaba natte adubu Ibungona eingonda pibikhiba makhoising adugidamak haijabani maramdi makhoi Ibungogini. ");
INSERT INTO mni_vpl VALUES ("JN17_10","073_17_10","JHN","17","10","10","Eigi leijaba pumnamak Ibungogini aduga Ibungogi areiba pumnamak eigini. Aduga makhoigi mapanna eingonda matik mangal lakle. ");
INSERT INTO mni_vpl VALUES ("JN17_11","073_17_11","JHN","17","11","11","Aduga houjik eihak Ibungogi maphamda laklani. Eidi taibangpanda leiraroi adubu makhoidi taibangpanda leiri. Asengba Ipa, eikhoina amata oibagumna makhoisu amata oinanaba Ibungona eingonda pibiba Ibungogi ming adugi panggalna makhoibu ngak senbiyu. ");
INSERT INTO mni_vpl VALUES ("JN17_12","073_17_12","JHN","17","12","12","Eina makhoiga loinaringeida Ibungona eingonda pibiba ming aduna eina makhoibu ngak sellammi. Mapu Ibungogi puyada ikhiba adu thungnanaba amangbagi machanupa adu nattana kana mata mangde. ");
INSERT INTO mni_vpl VALUES ("JN17_13","073_17_13","JHN","17","13","13","Houjikti ei Ibungogi maphamda laklani. Eigi haraoba asi makhoida mapung phana leinanaba waphamsing asi eina taibangpanda leiringei haibani. ");
INSERT INTO mni_vpl VALUES ("JN17_14","073_17_14","JHN","17","14","14","Eina Ibungo nahakki wa makhoida pire aduga taibangpanbana makhoibu tukkachare maramdi eina taibangpanbagi oidabagumna makhoisu taibangpanbagi natte. ");
INSERT INTO mni_vpl VALUES ("JN17_15","073_17_15","JHN","17","15","15","Makhoibu taibangpan asidagi louthokpiyu haina eina Ibungoda haijaba natte adubu Phattaba Mahak adudagi makhoibu ngak senbiyu haijabani. ");
INSERT INTO mni_vpl VALUES ("JN17_16","073_17_16","JHN","17","16","16","Eina taibangpanbagi oidabagum makhoisu taibangpanbagi natte. ");
INSERT INTO mni_vpl VALUES ("JN17_17","073_17_17","JHN","17","17","17","Achumba aduna makhoibu sengdokpiyu; Ibungogi wadi achumbani. ");
INSERT INTO mni_vpl VALUES ("JN17_18","073_17_18","JHN","17","18","18","Ibungona eibu taibangpanda thabibagumna einasu makhoibu taibangpanda thare. ");
INSERT INTO mni_vpl VALUES ("JN17_19","073_17_19","JHN","17","19","19","Ibungogi achumba aduna makhoibu sengdoknaba makhoigidamak eina isamak sengdokchei. ");
INSERT INTO mni_vpl VALUES ("JN17_20","073_17_20","JHN","17","20","20","“Eina makhoi khaktagi haijaba natte adubu makhoigi wadagi thajarakkadaba makhoisinggisu haijari. ");
INSERT INTO mni_vpl VALUES ("JN17_21","073_17_21","JHN","17","21","21","Makhoi pumnamak amata oinanaba eina haijari. Ipa, Ibungona eingonda aduga eina Ibungoda leibagum makhoinasu eikhoida leinanaba haijabani aduga masina Ibungona eibu thabirakpani haiba taibangpanbana thajanabani. ");
INSERT INTO mni_vpl VALUES ("JN17_22","073_17_22","JHN","17","22","22","Eikhoina amata oibagum makhoisu amata oinanaba, Ibungona eingonda pibiba matik mangal adu eina makhoida pire. ");
INSERT INTO mni_vpl VALUES ("JN17_23","073_17_23","JHN","17","23","23","Eina makhoida lei aduga Ibungona eingonda lei. Ibungona eibu thabirakpani aduga Ibungona eibu nungsibagum Ibungona makhoibu nungsi haibasi taibangpanbana khangnanaba makhoibu mapung phana amata oihanbiyu. ");
INSERT INTO mni_vpl VALUES ("JN17_24","073_17_24","JHN","17","24","24","“Ipa, taibangpan asi semdringeigi mamangda Ibungona eibu nungsibagi maramna Ibungona eingonda pibikhiba matik mangal adu makhoina ujanaba, Ibungona eingonda pibiba makhoi pumnamak eina leiba maphamda eiga leiminnaba pamjei. ");
INSERT INTO mni_vpl VALUES ("JN17_25","073_17_25","JHN","17","25","25","Achumba chatpa Ipa, taibangpanbana nahakpu khangdrabasu einadi Ibungo nahakpu khang-i aduga Ibungona eibu thabirakpani haibasi eigi tung-inbasing makhoina khang-i. ");
INSERT INTO mni_vpl VALUES ("JN17_26","073_17_26","JHN","17","26","26","Ibungona eibu nungsiba manungsi adu makhoida leinanaba aduga eina makhoida leinanaba, Ibungobu makhoida khang-halle aduga makhoida makha tana khang-hankhigani.” ");
INSERT INTO mni_vpl VALUES ("JN18_1","073_18_1","JHN","18","1","1","Jisuna haijaba loirabada Ibungona mahakki tung-inbasingga loinana Kidron lok lanthokle. Mapham aduda ingkhol ama leirammi maduda Jisu amadi mahakki tung-inbasingna chatlammi. ");
INSERT INTO mni_vpl VALUES ("JN18_2","073_18_2","JHN","18","2","2","Jisuna mahakki tung-inbasingga toina unaba mapham oibanina mapham asi Jisubu pithokpa Judas-na khanglammi. ");
INSERT INTO mni_vpl VALUES ("JN18_3","073_18_3","JHN","18","3","3","Maram asina Judas-na Rome-gi lanmising amadi Ningnasanggi lanmi kangbu ama puduna athoiba purohitsing amasung pharisee-singga loinana ingkhol aduda laklammi. Makhoina meira, thaomei amadi khutlai pairaklammi. ");
INSERT INTO mni_vpl VALUES ("JN18_4","073_18_4","JHN","18","4","4","Ibungona mangonda thoklagadaba pumnamak adu khangladuna Ibungona thoraktuna makhoida hairak-i, “Nakhoina kanabu thiribano?” ");
INSERT INTO mni_vpl VALUES ("JN18_5","073_18_5","JHN","18","5","5","“Eikhoi Nazareth-ki Jisubu thiribani,” haina makhoina khumlak-i. Maduda Jisuna hairak-i, “Mahak adu eini.” Jisubu pithokpa Judas mapham aduda makhoiga loinana leptuna leirammi. ");
INSERT INTO mni_vpl VALUES ("JN18_6","073_18_6","JHN","18","6","6","“Mahak adu eini” haina Jisuna haiba matamda makhoina tung hallaga leimaida ture. ");
INSERT INTO mni_vpl VALUES ("JN18_7","073_18_7","JHN","18","7","7","Ibungona makhoida amuk hanglak-i, “Nakhoina kanabu thiribano?” Maduda makhoina khumlak-i, “Eikhoi Nazareth-ki Jisubu thiribani,” ");
INSERT INTO mni_vpl VALUES ("JN18_8","073_18_8","JHN","18","8","8","“Mahak adu eini haina eina nakhoida haikhre,” haina Jisuna khumlak-i. “Nakhoina eibu thiba oirabadi makhoising adu chat-hankhro” ");
INSERT INTO mni_vpl VALUES ("JN18_9","073_18_9","JHN","18","9","9","(“Ipa, nahakna eingonda pibiba makhoi kana amatabu eina mang-hande,” haiba Ibungogi wahei adu thungnaba Ibungona masi haibani.) ");
INSERT INTO mni_vpl VALUES ("JN18_10","073_18_10","JHN","18","10","10","Maduda Simon Peter-na mahakki thangsang adu satlaga purohitlen-gi manaigi yet thangba mana adu kakthatlammi. Manai adugi maming Malchus kou-i. ");
INSERT INTO mni_vpl VALUES ("JN18_11","073_18_11","JHN","18","11","11","Jisuna Peter-da hairak-i, “Thangsang adu makhumda hapchillu. Ipana eingonda piba awabagi tenggot adu eina thakloidra?” ");
INSERT INTO mni_vpl VALUES ("JN18_12","073_18_12","JHN","18","12","12","Rome-gi lanmi kangbu amadi makhoigi luchingbasing aduga ningnasanggi lanmisinggana Jisubu pharammi amadi pullammi ");
INSERT INTO mni_vpl VALUES ("JN18_13","073_18_13","JHN","18","13","13","aduga makhoina Jisubu Annas-ki manakta hanna puraklammi. Annas chahi adugi Purohitlen oiriba Caiaphas-ki makubokni. ");
INSERT INTO mni_vpl VALUES ("JN18_14","073_18_14","JHN","18","14","14","Mi amana miyamgi mahutta sibana henna phei haina Jihudisinggi luchingbasingda paotak pikhiba mi adu Caiaphas asini. ");
INSERT INTO mni_vpl VALUES ("JN18_15","073_18_15","JHN","18","15","15","Simon Peter amadi atoppa tung-inba aduna Jisugi tung illammi. Atoppa tung-inba aduga purohitlen aduga munna khangnaba maramna mahakna Jisuga loinana purohitlen-gi sumangda changlammi. ");
INSERT INTO mni_vpl VALUES ("JN18_16","073_18_16","JHN","18","16","16","Adubu Peter-di mapanda thong manakta leplammi. Purohitlenna masak khangba atoppa tung-inba aduna hallaktuna mapham aduda thong sangbagi mathou touribi nupimacha aduda hairaga Peter-bu manungda pusillammi. ");
INSERT INTO mni_vpl VALUES ("JN18_17","073_18_17","JHN","18","17","17","Thongsangbi nupimacha aduna Peter-da hairak-i, “Nahaksu mi asigi tung-inabasinggi marakta ama nattra?” Maduda Peter-na khumlak-i, “Ei natte.” ");
INSERT INTO mni_vpl VALUES ("JN18_18","073_18_18","JHN","18","18","18","Matam adu ingbagi maramna minaising amadi ngaksellibasing aduna meitan thagatlaga madugi akoibada leptuna mei tiklammi. Peter-su makhoiga loinana leptuna mei tikminnarammi. ");
INSERT INTO mni_vpl VALUES ("JN18_19","073_18_19","JHN","18","19","19","Purohitlenna Ibungogi tung-inbasing amadi Ibungogi tambibagi matangda Ibungoda hanglammi. ");
INSERT INTO mni_vpl VALUES ("JN18_20","073_18_20","JHN","18","20","20","Maduda Jisuna khumlak-i, “Eina taibangpanda iphong phongna wa hai aduga Jihudisingna tinnaba maphamsing haibadi synagogue-sing amadi Mapugi Sanglenda eina tambibani. Eina kari amata lonna haikhide. ");
INSERT INTO mni_vpl VALUES ("JN18_21","073_18_21","JHN","18","21","21","Aduga karigi nahakna eingonda madugi wahang adu hanglibano? Eina haiba takhiba makhoi aduda eina kari kari haikhi haibadu hang-u. Eina haikhiba adu makhoina khangbani.” ");
INSERT INTO mni_vpl VALUES ("JN18_22","073_18_22","JHN","18","22","22","Jisuna masi haiba matamda lanmi amana Ibungogi maida khubakna tharaga hairak-i, “Nangna adumna Purohitlenda khumbra?” ");
INSERT INTO mni_vpl VALUES ("JN18_23","073_18_23","JHN","18","23","23","Maduda Jisuna hairak-i, “Eina aranba haikhiba leiradi madu leiriba mayam mamang asida haiyu. Aduga eina achumba hairabadi karigi nahakna eingonda nakhut tharibano?” ");
INSERT INTO mni_vpl VALUES ("JN18_24","073_18_24","JHN","18","24","24","Madudagi Annas-na pullaga leiriba Ibungobu Purohitlen Caiaphas-ki maphamda tharammi. ");
INSERT INTO mni_vpl VALUES ("JN18_25","073_18_25","JHN","18","25","25","Mapham aduda Peter leptuna mei tiklammi. Maduda makhoina Peter-da hanglak-i, “Nahaksu mi asigi tung-inba ama nattra?” Madu Peter-na yaramde aduga hairak-i, “Ei natte.” ");
INSERT INTO mni_vpl VALUES ("JN18_26","073_18_26","JHN","18","26","26","Peter-na mana kakkhiba nupa adugi mari mata oiba purohitlen-gi manai amana Peter-da hairak-i, “Ingkhol aduda nahakna mahakka loinana leiba adu eina ukhidabra?” ");
INSERT INTO mni_vpl VALUES ("JN18_27","073_18_27","JHN","18","27","27","Madu Peter-na amuk hanna yaramde. Khudak aduda yenbarabana khonglak-i. ");
INSERT INTO mni_vpl VALUES ("JN18_28","073_18_28","JHN","18","28","28","Jihudisingna Jisubu Caiaphas-ki maphamdagi Rome-gi leingak mapugi sanggaida puraklammi. Matam adu ayuk anganba oirammi. Makhoina Lanthokpibagi chakkhangba adu yaoba yananaba laininggi oiba masa sengna leinanaba makhoina sanggai manungdadi changlamde. ");
INSERT INTO mni_vpl VALUES ("JN18_29","073_18_29","JHN","18","29","29","Maram aduna Pilate-na mapanda thoraktuna makhoida hanglak-i, “Nakhoina mi asi kari maral lei hairibano?” ");
INSERT INTO mni_vpl VALUES ("JN18_30","073_18_30","JHN","18","30","30","Maduda makhoina khumlak-i, “Mahak asi phattaba touba mi oiramdrabadi eikhoina mahakpu nahakki naphamda puraklamloi.” ");
INSERT INTO mni_vpl VALUES ("JN18_31","073_18_31","JHN","18","31","31","Pilate-na hairak-i, “Nakhoina mahakpu puduna nakhoigi wayel yathanggi matung inna wayellu.” Maduda makhoina khumlak-i, “Mi amabu hatpa yabagi ayaba adu eikhoida pide.” ");
INSERT INTO mni_vpl VALUES ("JN18_32","073_18_32","JHN","18","32","32","Masi Jisuna mahak karamba ma-ongda sigani haina haikhiba adu thungnanabani. ");
INSERT INTO mni_vpl VALUES ("JN18_33","073_18_33","JHN","18","33","33","Madudagi Pilate-na sanggai manungda amuk changle aduga Jisubu kousillaga hanglak-i, “Nahak Jihudisinggi ningthoura?” ");
INSERT INTO mni_vpl VALUES ("JN18_34","073_18_34","JHN","18","34","34","Jisuna khumlak-i, “Madu nahak nasadagi lakpa wahangla nattraga atoppa misingna nangonda eigi maramda haibagira?” ");
INSERT INTO mni_vpl VALUES ("JN18_35","073_18_35","JHN","18","35","35","Pilate-na khumlak-i, “Eibu Jihudira? Nahakki mising amadi athoiba purohitsingna nahakpu eingonda sinnarakpani. Nahakna kari toukhrabage?” ");
INSERT INTO mni_vpl VALUES ("JN18_36","073_18_36","JHN","18","36","36","Maduda Jisuna hairak-i, “Eigi leibakti taibangpan asigi natte. Taibangpan asigi oiramlabadi Jihudisingna eibu phaba thingnanaba eigi inaisingna lan soknaramgadabani. Adubu eigi leibakti mapham asigi natte.” ");
INSERT INTO mni_vpl VALUES ("JN18_37","073_18_37","JHN","18","37","37","Pilate-na hairak-i, “Adu oirabadi nahak ningthounine!” Maduda Jisuna khumlak-i, “Ei ningthouni haina nahakna haiba adu nahakna chumna haire. Maram asigidamak eihak pokpani amadi achumbagi maramda hainanaba taibangpan asida lakpani. Achumbagi maikeida leiba mi khudingna eigi khonjel tai.” ");
INSERT INTO mni_vpl VALUES ("JN18_38","073_18_38","JHN","18","38","38","Pilate-na Ibungoda hanglak-i, “Achumba haibasi karino?” Madudagi Pilate-na mapanda thoktuna makhoida hairak-i, “Eina mangonda maral piba yaba kari amata phangde. ");
INSERT INTO mni_vpl VALUES ("JN18_39","073_18_39","JHN","18","39","39","Adubu Lanthokpibagi chakkhangba matamda eina mi amabu thadokpagi nakhoigi chatnabi lei. Maram aduna Jihudisinggi ningthou adu nakhoigidamak thadokpa pambra?” ");
INSERT INTO mni_vpl VALUES ("JN18_40","073_18_40","JHN","18","40","40","Maduda makhoina kanna laorak-i, “Natte, mahak natte! Barabbas-pu thadok-u!” (Barabbas asi daku amani.) ");
INSERT INTO mni_vpl VALUES ("JN19_1","073_19_1","JHN","19","1","1","Adudagi Pilate-na yathang piduna Jisubu phuhallammi. ");
INSERT INTO mni_vpl VALUES ("JN19_2","073_19_2","JHN","19","2","2","Lanmising aduna tingkhanggi luhup ama semlaga Ibungogi makokta upsinbire aduga makhoina manggra machugi phi ama insinbire. ");
INSERT INTO mni_vpl VALUES ("JN19_3","073_19_3","JHN","19","3","3","Makhoina Ibungogi manakta changsillaga hairak-i, “Khurumjari, he Jihudisinggi Ningthou!” Adudagi makhoina Ibungogi mamaida khubakna tharammi. ");
INSERT INTO mni_vpl VALUES ("JN19_4","073_19_4","JHN","19","4","4","Pilate-na amuk hanna mapanda thoraklaga makhoida hairak-i, “Yeng-u, Eina mangonda maral piba yaba kari amata phangde haiba nakhoina khangnanaba mahakpu nakhoigi namangda puthorakli.” ");
INSERT INTO mni_vpl VALUES ("JN19_5","073_19_5","JHN","19","5","5","Jisuna tingkhanggi luhuptu uplaga amadi manggra machugi phi adu induna thorakle aduga pilate-na makhoida hairak-i, “Yeng-u, mi adu asida leire!” ");
INSERT INTO mni_vpl VALUES ("JN19_6","073_19_6","JHN","19","6","6","Athoiba purohitsing amadi Mapugi Sanglen-gi ngaksenbasing aduna Ibungobu ubada kanna laorak-i, “Mahakpu cross-ta hatlu! Mahakpu cross-ta hatlu!” Maduda Pilate-na makhoida khumlak-i, “Adu oirabadi nakhoina mahakpu cross-ta hatlu. Aduga eigi oinadi, mangonda maral piba yaba kari amata phangde.” ");
INSERT INTO mni_vpl VALUES ("JN19_7","073_19_7","JHN","19","7","7","Jihudisingna mangonda khumlak-i, “Eikhoigi wayel yathang lei aduga wayel yathang adugi matung inna mahak sipham thok-i maramdi mahakna masabu Tengban Mapugi Machanupani haina haijei.” ");
INSERT INTO mni_vpl VALUES ("JN19_8","073_19_8","JHN","19","8","8","Pilate-na wa asi tabada mahak amukka henna kirammi. ");
INSERT INTO mni_vpl VALUES ("JN19_9","073_19_9","JHN","19","9","9","Mahakna sanggaida amuk changlaga Jisuda hanglak-i, “Nahak kadaidagi lakpano?” Adubu Jisuna paokhum amata piramde. ");
INSERT INTO mni_vpl VALUES ("JN19_10","073_19_10","JHN","19","10","10","Maduda Pilate-na Jisuda hairak-i, “Nahak eingonda wa amata nganglaroidra? Eina nahakpu cross-ta hatpa nattraga thadokpagi matik eingonda lei haibasi nahak khangdabra?” ");
INSERT INTO mni_vpl VALUES ("JN19_11","073_19_11","JHN","19","11","11","Maduda Jisuna khumlak-i, “Mapu Ibungona nangonda pibiba nattrabadi nahakna eigi ithakta matik leiramloidabani. Maram asina eibu nangonda pithokpa mahak aduna maral henna chao-i.” ");
INSERT INTO mni_vpl VALUES ("JN19_12","073_19_12","JHN","19","12","12","Pilate-na masi tabada Ibungobu thadoknaba hotnarammi adubu Jihudi luchingbasing aduna laorak-i, “Nahakna mahakpu thadoklabadi, nahak Caesar-gi marup natte. Kanagumba amana masabu ningthouni haijarabadi mahak Caesar-gi yeknabani.” ");
INSERT INTO mni_vpl VALUES ("JN19_13","073_19_13","JHN","19","13","13","Pilate-na wasi tabada Jisubu mapanda puthokle aduga Nungna Chanba Mapham kouba (Hebrew londa Gabbatha haina kouba) adugi wayel phambeida mahakna phamle. ");
INSERT INTO mni_vpl VALUES ("JN19_14","073_19_14","JHN","19","14","14","Madu Lanthokpibagi Chakkhangbagi nongma watlingei aduga numit yungba aduwaidani. Pilate-na Jihudisingda hairak-i, “Nakhoigi ningthou mapham asida leire.” ");
INSERT INTO mni_vpl VALUES ("JN19_15","073_19_15","JHN","19","15","15","Makhoina kanna laorak-i, “Mahak puthokkhro! Mahak Puthokkhro! Mahakpu cross-ta hatlu!” Maduda Pilate-na hanglak-i, “Eina nakhoigi ningthoubu cross-ta hatkadra?” Athoiba purohitsingna khumlak-i, “Caesar nattana eikhoigi ningthou atei leite.” ");
INSERT INTO mni_vpl VALUES ("JN19_16","073_19_16","JHN","19","16","16","Adudagi Pilate-na Ibungobu cross-ta hatnanaba makhoida sinakhre. Maram aduna makhoina Jisubu pukhre. ");
INSERT INTO mni_vpl VALUES ("JN19_17","073_19_17","JHN","19","17","17","Lukang haina khangnaba (Hebrew londa Golgotha haina kouba) mapham aduda Ibungona masagi cross adu puduna chatlammi. ");
INSERT INTO mni_vpl VALUES ("JN19_18","073_19_18","JHN","19","18","18","Mapham aduda makhoina Ibungobu cross-ta pang tingle aduga Ibungogi oi yettasu mi ani amagasu pang tinglammi. ");
INSERT INTO mni_vpl VALUES ("JN19_19","073_19_19","JHN","19","19","19","Iraga khanghanba ama semsaraga Pilate-na cross mathakta thetle. Maduda iriba adudi asini, “Nazareth-ki Jisu, Jihudisinggi Ningthou.” ");
INSERT INTO mni_vpl VALUES ("JN19_20","073_19_20","JHN","19","20","20","Jisubu pang tingliba maphamdu sahar manak oibanina Jihudi mayam amana thetlaga khanghalliba a-iba adu parammi. Thetlaga khanghalliba adu Hebrew, Latin amadi Greek londa ibani. ");
INSERT INTO mni_vpl VALUES ("JN19_21","073_19_21","JHN","19","21","21","Athoiba purohitsing aduna Pilate-ta hairak-i, “‘Jihudisinggi Ningthou’ haina iganu madugi mahutta ‘Masana masabu Jihudisinggi ningthouni haijaba mi’ haina ibiyu.” ");
INSERT INTO mni_vpl VALUES ("JN19_22","073_19_22","JHN","19","22","22","Maduda Pilate-na khumlak-i, “Eina ikhraba adu ikhre.” ");
INSERT INTO mni_vpl VALUES ("JN19_23","073_19_23","JHN","19","23","23","Lanmising aduna Jisubu pang tinglaba matungda makhoina Ibungogi maphising loure aduga makhoina amamam phangnanaba phising adu saruk mari thok-halle. Makhoina Ibungogi achonba phi adubusu loure. Achonba phi adu langdai leitaba phi amatadagi sabani. ");
INSERT INTO mni_vpl VALUES ("JN19_24","073_19_24","JHN","19","24","24","Lanmising aduna makhoi masel hainarammi, “Phi asidi eikhoi segaigumsi. Masi kanagi oigadage haiba laibak chang yengnasi.” Thoudok asi Mapugi puyada ikhraba adu thungnanabani, madudi: “Makhoina eigi phiron makhoigi marakta yennagani aduga eigi achonba phigidamak laibak chang yengnagani.” Masimak lanmising aduna tourammi. ");
INSERT INTO mni_vpl VALUES ("JN19_25","073_19_25","JHN","19","25","25","Ibungogi cross adugi manakta Ibungogi mama, mamagi manaonupi, Clopas-ki nupi Mary amadi Mary Magdalene leptuna leirammi. ");
INSERT INTO mni_vpl VALUES ("JN19_26","073_19_26","JHN","19","26","26","Jisuna mama amadi manakta lepliba mahakna nungsijaba tung-inba adu ubada mamada hairak-i, “Nungsirabi nupi, nahakki nachanupa asida leire.” ");
INSERT INTO mni_vpl VALUES ("JN19_27","073_19_27","JHN","19","27","27","Adudagi Ibungona tung-inba aduda hairak-i, “Mahak nahakki namani.” Matam adudagi houna tung-inba aduna Mary-bu mahakki yumda purammi. ");
INSERT INTO mni_vpl VALUES ("JN19_28","073_19_28","JHN","19","28","28","Houjikti thabak pumnamak loire haiba Jisuna khangladuna Mapugi puyada i-ba adu thungnanaba Ibungona hairak-i, “Ei khourangle.” ");
INSERT INTO mni_vpl VALUES ("JN19_29","073_19_29","JHN","19","29","29","Mapham aduda asinba yuna thanna yaoba chaisen ama leirammi maduda makhoina sponge ama luplaga asinba yu adu chupsilhalle aduga hyssop macheida haplaga Jisugi chinbanda thamlammi. ");
INSERT INTO mni_vpl VALUES ("JN19_30","073_19_30","JHN","19","30","30","Jisuna madu tanglabada Ibungona hairak-i, “Loire.” Madudagi Ibungona kok lekthaduna thawai thakhre. ");
INSERT INTO mni_vpl VALUES ("JN19_31","073_19_31","JHN","19","31","31","Numit adu maru oiba Potthaba numitki nongma watlingei semsaba numit oirammi. Maram aduna Potthaba numitta hakchangsing adu cross-ta yanduna leiba adu pamdabadagi Jihudisingna Pilate-ki maphamda laktuna cross-ta yalliba hakchangsing adu makhong thudeklaga cross-tagi puthanaba haijarammi. ");
INSERT INTO mni_vpl VALUES ("JN19_32","073_19_32","JHN","19","32","32","Maram aduna lanmising aduna Jisuga loinana pang tingkhraba ahanba mi adugi makhong hanna thudekle aduga atoppa mi adugi makhong thudekle. ");
INSERT INTO mni_vpl VALUES ("JN19_33","073_19_33","JHN","19","33","33","Adubu lanmising aduna Jisugi manakta lakpadadi Jisudi hannana siramle maram aduna makhoina Ibungogi khongdi thudektre. ");
INSERT INTO mni_vpl VALUES ("JN19_34","073_19_34","JHN","19","34","34","Adubu lanmi amanadi Ibungogi puknopta tana thillammi aduga khudak adumaktada eega isingga thoklaklammi. ");
INSERT INTO mni_vpl VALUES ("JN19_35","073_19_35","JHN","19","35","35","(Thoudok adumak uhouba mi amana haibani aduga mahakna haiba adu achumbani. Mahakna achumba haibani haiba mahak khang-i aduga nakhoinasu thajananaba mahakna haibani.) ");
INSERT INTO mni_vpl VALUES ("JN19_36","073_19_36","JHN","19","36","36","Thoudok asi Mapugi puyada ikhiba “Ibungogi saru ama phaoba tekloi” haina ikhiba wa adu thungnanabani. ");
INSERT INTO mni_vpl VALUES ("JN19_37","073_19_37","JHN","19","37","37","Aduga Mapugi puyagi mapham amada asumna hai, “Tana thinkhraba Ibungoda makhoina yenggani.” ");
INSERT INTO mni_vpl VALUES ("JN19_38","073_19_38","JHN","19","38","38","Masigi matungda Arimathea-dagi lakpa Joseph-na Pilate-ki maphamda chattuna Jisugi hakchang pibinaba haijarammi. (Joseph asi Jihudisingbu kibagi maramna lonna Jisugi tung-inba amani.) Pilate-na ayaba adu pibadagi mahakna hakchang adu pure. ");
INSERT INTO mni_vpl VALUES ("JN19_39","073_19_39","JHN","19","39","39","Nongma ahing amada Jisubu unaba chatluba Nicodemus-su mahakka loinarammi. Nicodemus-na myrrh amadi agor-ga yansinnaba manam nungsiba pot kilo kunthramarimuk puduna laklammi. ");
INSERT INTO mni_vpl VALUES ("JN19_40","073_19_40","JHN","19","40","40","Makhoi anina Jisugi hakchang adu loure aduga Jihudisinggi chatnabigi matung inna manam nungsiba machalsingga loinana ananba limon phina yomsille. ");
INSERT INTO mni_vpl VALUES ("JN19_41","073_19_41","JHN","19","41","41","Jisubu cross-ta hatkhiba mapham aduda ingkhol ama leirammi aduga ingkhol aduda mi kana amata phumdriba mongpham ama leirammi. ");
INSERT INTO mni_vpl VALUES ("JN19_42","073_19_42","JHN","19","42","42","Jihudisinggi Potthabagi Thourang langbagi numit oibagi maram amadi mongpham adu manak nakna leibagi maramna Jisugi hakchang adu mongpham manung aduda thamle. ");
INSERT INTO mni_vpl VALUES ("JN20_1","073_20_1","JHN","20","1","1","Chayolgi ahanba nummitki ayuk yamna ngallingei mamlingei matamda Mary Magdalene-na mongphamda lakpada mongpham changphamgi nung adu louthoklamba thengnare. ");
INSERT INTO mni_vpl VALUES ("JN20_2","073_20_2","JHN","20","2","2","Mahakna Simon Peter amadi Jisuna nungsiba atoppa tung-inba adugi manakta chellaklaga makhoida hairak-i, “Makhoina Ibungobu mongphamdagi louthokkhre aduga makhoina Ibungobu kadaida thamkhrabano haiba eikhoi khangdre.” ");
INSERT INTO mni_vpl VALUES ("JN20_3","073_20_3","JHN","20","3","3","Adudagi Peter amadi atoppa tung-inba aduna mongpham tana chenkhirammi. ");
INSERT INTO mni_vpl VALUES ("JN20_4","073_20_4","JHN","20","4","4","Makhoi ani chenminnei adubu atoppa tung-inba aduna Peter-gi mang thana chenkhatkhiduna mongphamda hanna thunglammi. ");
INSERT INTO mni_vpl VALUES ("JN20_5","073_20_5","JHN","20","5","5","Mahakna nonthaduna yengbada mapham aduda ananba limon phi adu thamba urammi adubu mahak mongpham adugi manungdadi changlamde. ");
INSERT INTO mni_vpl VALUES ("JN20_6","073_20_6","JHN","20","6","6","Madugi matungda mahakki tungda leihouba Simon Peter-su yourakle aduga Simon Peter-na mongpham manungda changlammi. Mapham aduda ananba limon-gi phi adu leiramba urammi ");
INSERT INTO mni_vpl VALUES ("JN20_7","073_20_7","JHN","20","7","7","amadi Ibungogi kokthakta yetlamba phi adu thuplaga ananba limon phi adudagi tonganna leiramba thengnare. ");
INSERT INTO mni_vpl VALUES ("JN20_8","073_20_8","JHN","20","8","8","Akonbada mongpham aduda hanna thungba Ibungogi tung-inba adusu mongpham manungda changlakle. Mahakna uraduna thajare. ");
INSERT INTO mni_vpl VALUES ("JN20_9","073_20_9","JHN","20","9","9","(Jisuna sibadagi hinggatpa tai haina Mapugi puyada i-ba adu houjik phaoba makhoina wakhal taba ngamlamdri.) ");
INSERT INTO mni_vpl VALUES ("JN20_10","073_20_10","JHN","20","10","10","Adudagi Ibungogi tung-inbasing adu makhoigi mayumda hankhre. ");
INSERT INTO mni_vpl VALUES ("JN20_11","073_20_11","JHN","20","11","11","Mary-di mongpham adugi mapanda leplaga kaptuna leirammi. Mahakna kapna kapna luktharaga mongpham manungda yenglammi. ");
INSERT INTO mni_vpl VALUES ("JN20_12","073_20_12","JHN","20","12","12","Maduda mahakna phingou setpa swargagi dut ani Ibungogi hakchang thamlamba mapham aduda phamduna leiba ure, amana lukhumda amana khuyada phamlammi. ");
INSERT INTO mni_vpl VALUES ("JN20_13","073_20_13","JHN","20","13","13","Makhoina Mary-da hanglak-i, “Nupi, nahak karigi kaplibano?” Maduda mahakna khumlak-i, “Makhoina eigi Ibungobu puthokkhre aduga makhoina Ibungobu kadaida thamkhrabano haiba ei khangdre.” ");
INSERT INTO mni_vpl VALUES ("JN20_14","073_20_14","JHN","20","14","14","Mary-na masi hek haibaga mahakna leithorakpada Jisuna mapham aduda leptuna leiramba adu mahakna ure adubu mahakna Jisuni haibadi khanglamde. ");
INSERT INTO mni_vpl VALUES ("JN20_15","073_20_15","JHN","20","15","15","Jisuna mangonda hanglak-i, “Nupi, nahak karigi kaplibano? Nahak kanabu thiribano?” Ibungobu ingkhol koiba mini haina Mary-na khanduna Ibungoda hairak-i, “Nahakna Ibungobu puthokkhiba oirabadi nahakna Ibungobu kadaida thambage haibadu eingonda takpiyu aduga eina Ibungobu louthokchage.” ");
INSERT INTO mni_vpl VALUES ("JN20_16","073_20_16","JHN","20","16","16","Jisuna mangonda hairak-i, “Mary!” Maduda mahakna Ibungolomda onsillaklaga Hebrew londa hairak-i, “Rabboni!” (Masigi wahanthokti “Oja” haibani.) ");
INSERT INTO mni_vpl VALUES ("JN20_17","073_20_17","JHN","20","17","17","Jisuna mangonda hairak-i, “Eingonda paiganu maramdi eihak houjik phaoba Ipagi maphamda kakhattri. Adubu nahakna eigi ichin inaosingda chattuna makhoida hairu, ‘Eina eigi Ipa Ibungo amadi nakhoigi Napa Ibungo aduga eigi Tengban Mapu amadi nakhoigi Tengban Mapu oiriba Ibungo mahakki manakta hallagani.’ ” ");
INSERT INTO mni_vpl VALUES ("JN20_18","073_20_18","JHN","20","18","18","Maram aduna Mary Magdalene-na Ibungogi tung-inbasinggi manakta chattuna mahakna Ibungobu ujare haina tamle. Aduga Ibungona mangonda haibasing adusu makhoida tamle. ");
INSERT INTO mni_vpl VALUES ("JN20_19","073_20_19","JHN","20","19","19","Chayolgi ahanba numit adugi numidang wairamda Jihudisingbu kibadagi Ibungogi tung-inbasingna yumgi thong lonsillaga makhoi punna tinnaduna leirammi. Aduga khanghoudana Jisuna makhoigi marakta laktuna leplaga hairak-i, “Nakhoida ingthaba oisanu.” ");
INSERT INTO mni_vpl VALUES ("JN20_20","073_20_20","JHN","20","20","20","Masi hairaba tungda Ibungona mahakki khut amadi puknop makhoida utlammi. Ibungogi tung-inbasingna Ibungobu ujabada haraobana thallammi. ");
INSERT INTO mni_vpl VALUES ("JN20_21","073_20_21","JHN","20","21","21","Jisuna makhoida hairak-i, “Nakhoida ingthaba oisanu. Eigi Ipana eibu thaba adugumna einasu nakhoibu thari.” ");
INSERT INTO mni_vpl VALUES ("JN20_22","073_20_22","JHN","20","22","22","Madudagi Ibungona makhoida sor kamsinbiraga hairak-i, “Nakhoi Thawai Asengba phangjaro. ");
INSERT INTO mni_vpl VALUES ("JN20_23","073_20_23","JHN","20","23","23","Nakhoina kanagumbagi pap kokpirabadi makhoigi pap adu kokpirabani; nakhoina kanagumbagi pap kokpidrabadi makhoigi pap adu kokpidrabani.” ");
INSERT INTO mni_vpl VALUES ("JN20_24","073_20_24","JHN","20","24","24","Makhoi taranithoigi marakta ama oiriba Didymus hainasu kouba Thomas-ti Jisuna tung-inbasinggi manakta lakpa matamda mahak yaoramde. ");
INSERT INTO mni_vpl VALUES ("JN20_25","073_20_25","JHN","20","25","25","Maram aduna Ibungogi tung-inbasingna mangonda hairak-i, “Eikhoina Ibungobu ujare!” Maduda Thomas-na makhoida khumlak-i, “Eina Ibungogi khutta taba yotpi makhul adu udriphaoba, eigi khudombina yotpi makhulsing aduda thamdriphaoba aduga eigi khutna Ibungogi puknopta thamdriphaoba keidoungeidasu thajaroi.” ");
INSERT INTO mni_vpl VALUES ("JN20_26","073_20_26","JHN","20","26","26","Chayol amagi matungda Ibungogi tung-inbasingna yum amada amuk punna leirammi maduda Thomas-su yaorammi. Yum adugi thong adu lonkhrabasu Jisuna laklaga makoigi marakta leptuna makhoida hairak-i, “Nakhoida ingthaba oisanu.” ");
INSERT INTO mni_vpl VALUES ("JN20_27","073_20_27","JHN","20","27","27","Madudagi Ibungona Thomas-ta hairak-i, “Nahakki khudombi adu mapham asida thammu aduga eigi khut ani asi yeng-u; nahakki khut adu tingthoktuna eigi puknopta thammu. Chingnaba thadok-u amasung thajou!” ");
INSERT INTO mni_vpl VALUES ("JN20_28","073_20_28","JHN","20","28","28","Maduda Thomas-na Ibungoda hairak-i, “Eigi Ibungo, eigi Tengban Mapu!” ");
INSERT INTO mni_vpl VALUES ("JN20_29","073_20_29","JHN","20","29","29","Jisuna mangonda hairak-i, “Thomas nahakti eibu urabanina thajare adubu eibu udrabasu thajaba makhoi adu yaiphabani.” ");
INSERT INTO mni_vpl VALUES ("JN20_30","073_20_30","JHN","20","30","30","Lairik asida isindaba atei angakpa thabak kaya amasu Jisuna mahakki tung-inbasinggi mamangda toukhi. ");
INSERT INTO mni_vpl VALUES ("JN20_31","073_20_31","JHN","20","31","31","Adubu Jisudi Tengban Mapugi Machanupa Christta aduni haiba nakhoina thajananaba amadi Ibungo mangonda thajabagi mapanna nakhoina lomba naidaba hingba phangnanaba masising asi isinkhrabani. ");
INSERT INTO mni_vpl VALUES ("JN21_1","073_21_1","JHN","21","1","1","Masigi matungda Tiberias pat mapanda Jisuna mahakki tung-inbasingda amuk uhanbirammi. Masi asumna thokkhi. ");
INSERT INTO mni_vpl VALUES ("JN21_2","073_21_2","JHN","21","2","2","Simon Peter, Didymus hainasu kouba Thomas, Galilee-gi Cana haiba maphamdagi Nathanael, Zebedee-gi machanupasing amadi atoppa Jisugi tung-inba ani hairiba makhoising asi punna leiminarammi. ");
INSERT INTO mni_vpl VALUES ("JN21_3","073_21_3","JHN","21","3","3","Simon Peter-na makhoida hairak-i, “Ei nga phaba chatlage.” Maduda makhoina hairak-i, “Eikhoisu nahakka loinana chatke.” Maram aduna makhoina hi amada tongduna chatle adubu ahing chuppa makhoi kari amata phadre. ");
INSERT INTO mni_vpl VALUES ("JN21_4","073_21_4","JHN","21","4","4","Ayuk anganbada Jisuna pat mapanda leptuna leirammi adubu Ibungogi tung-inbasing adunadi Ibungoni haiba khanglamde. ");
INSERT INTO mni_vpl VALUES ("JN21_5","073_21_5","JHN","21","5","5","Adudagi Ibungona makhoida hairak-i, “Marupsing, nakhoi kari amata phadrabra?” Maduda makhoina khumlak-i, “Kari amata phadre.” ");
INSERT INTO mni_vpl VALUES ("JN21_6","073_21_6","JHN","21","6","6","Ibungona makhoida hairak-i, “In adu hi adugi yet thangba nakanda hullu, nakhoina nga kharadi phagani.” Maram aduna makhoina in adu hulle maduda nga yamna lakpadagi makhoina in adu chingkhatpa ngamdre. ");
INSERT INTO mni_vpl VALUES ("JN21_7","073_21_7","JHN","21","7","7","Jisuna nungsiba tung-inba aduna Peter-da hairak-i, “Mahak Ibungoni!” Simon Peter-na Ibungoni haiba hek tabaga mahakna mahakki mapan thangba phi adu setchillaga patta chongtharammi (Maramdi mahak phi setlamde). ");
INSERT INTO mni_vpl VALUES ("JN21_8","073_21_8","JHN","21","8","8","Nga thanna yaoraba in adu atoppa Ibungogi tung-inbasing aduna hi amada tongduna pat mapan tanna chinglaklammi maramdi makhoi pat mapandagi lapna leiramde, chourakna khudup chanimukta lapna leirammi. ");
INSERT INTO mni_vpl VALUES ("JN21_9","073_21_9","JHN","21","9","9","Makhoina kangphal youbada achakpa meitan mathakta nga thamba aduga tal khara leiba urammi. ");
INSERT INTO mni_vpl VALUES ("JN21_10","073_21_10","JHN","21","10","10","Jisuna makhoida hairak-i, “Nakhoina houjik pharakpa nga khara purak-u.” ");
INSERT INTO mni_vpl VALUES ("JN21_11","073_21_11","JHN","21","11","11","Maduda Simon Peter-na hida kakhattuna nga achouba chama yangkheihumdoi yaoba in adu kangphalda chingkhatle. Nga yamna yaorabasu in adu segairamde. ");
INSERT INTO mni_vpl VALUES ("JN21_12","073_21_12","JHN","21","12","12","Jisuna makhoida hairak-i, “Chararo lak-u.” Ibungogi tung-inba amatana “Nahak kanano?” haina hangba ngamlamde maramdi Ibungoni haiba makhoina khanglammi. ");
INSERT INTO mni_vpl VALUES ("JN21_13","073_21_13","JHN","21","13","13","Adudagi Jisuna laktuna nga amadi tal adu louraga makhoida pirammi. ");
INSERT INTO mni_vpl VALUES ("JN21_14","073_21_14","JHN","21","14","14","Jisuna sibadagi hinggatlaba matungda mahakki tung-inbasingda uhanbibasi masina ahumlak subani. ");
INSERT INTO mni_vpl VALUES ("JN21_15","073_21_15","JHN","21","15","15","Makhoina charaba matungda Jisuna Simon Peter-da hanglak-i, “John-gi machanupa Simon, makhoising asidagi henna nahakna eibu nungsibra?” Simon Peter-na khumlak-i, “Hoi Ibungo, eina Ibungobu nungsi haibasi Ibungona khangbi.” Jisuna mangonda hairak-i, “Eigi yaomachasingbu pijabiyu.” ");
INSERT INTO mni_vpl VALUES ("JN21_16","073_21_16","JHN","21","16","16","Aniraksuba oina Jisuna hairak-i, “John-gi machanupa Simon, nahak eibu nungsibra?” Simon Peter-na khumlak-i, “Hoi Ibungo, eina Ibungobu nungsi haibasi Ibungona khangbi.” Jisuna mangonda hairak-i, “Eigi yaosingbu senbiyu.” ");
INSERT INTO mni_vpl VALUES ("JN21_17","073_21_17","JHN","21","17","17","Ahumlaksuba oina Ibungona mangonda hanglak-i, “John-gi machanupa Simon, nahak eibu nungsibra?” Jisuna mangonda “Nahak eibu nungsibra?” haina ahumlak suna hangba aduda mahak thamoi sokle. Maduda mahakna hairak-i, “Ibungo, Ibungona pumnamak khangbibani; eina Ibungobu nungsi haibasi Ibungona khangbi.” Jisuna mangonda hairak-i, “Eigi yaosingbu pijabiyu. ");
INSERT INTO mni_vpl VALUES ("JN21_18","073_21_18","JHN","21","18","18","Eina nangonda tasengnamak hairibasini, nahakna naha oiringeida nasana phiron setchei aduga nahakna chatningba maphamda chatlammi adubu nahakna ahal oiraba matamdadi nahakna nakhut tingthokkani aduga atoppa mi amana nahakpu phi setpigani aduga nahakna chatpa pamdaba maphamda nahakpu pugani.” ");
INSERT INTO mni_vpl VALUES ("JN21_19","073_21_19","JHN","21","19","19","(Jisuna masi haibasi Peter-na karamba maongda siduna Tengban Mapubu matik mangal chaohan-gadage haibadu khang-hanbibani.) Adudagi Jisuna mangonda hairak-i, “Eigi itung illu.” ");
INSERT INTO mni_vpl VALUES ("JN21_20","073_21_20","JHN","21","20","20","Peter-na leithorakpada Jisuna nungsiba tung-inba aduna makhoigi tung illakpa adu urammi. Mahak asi numidang chaklen aduda Ibungogi manakta naksallaga “Ibungo, nahakpu pithokkadaba mahaktubu kanano?” haina hangkhiba tung-inba aduni. ");
INSERT INTO mni_vpl VALUES ("JN21_21","073_21_21","JHN","21","21","21","Peter-na mahakpu ubada Ibungoda hanglak-i, “Ibungo, mahakkidi kari oigadage?” ");
INSERT INTO mni_vpl VALUES ("JN21_22","073_21_22","JHN","21","22","22","Jisuna mangonda khumlak-i, “Eina laktri phaoba eina mahak hing-hanba pamlabadi maduda nangonda kari toubage? Nahak eigi itung illu.” ");
INSERT INTO mni_vpl VALUES ("JN21_23","073_21_23","JHN","21","23","23","Masina maram oiraga tung-inba mahak asi siraroi haiba wapham Ibungogi tung-inbasinggi marakta sandoklammi. Adubu Jisuna mahak siroi haiba natte; “Eina laktri phaoba eina mahak hing-hanba pamlabadi maduda nangonda kari toubage?” haina Ibungona haibani. ");
INSERT INTO mni_vpl VALUES ("JN21_24","073_21_24","JHN","21","24","24","Tung-inba mahak adudi waramsing asi haiba amadi i-ba mahak asini. Mahakna haiba asi achumbani haiba eikhoina khang-i. ");
INSERT INTO mni_vpl VALUES ("JN21_25","073_21_25","JHN","21","25","25","Jisuna touramba thabak mayam amasu leiri adubu makhoising adu amamam oina loina irabadi, igadaba lairiksing adu taibangpan asida thamba challoi haina eina khalli.");
INSERT INTO mni_vpl VALUES ("AC1_1","074_1_1","ACT","1","1","2","Nungsijaraba Theophilus, eigi ahanba lairikta Jisuna thabak touba houba matam adudagi houraga, Ibungona pakhonchatpa oina khandokkhrabasing aduda Thawai Asengbagi panggalgi mapanna yathang piraba matung, Ibungobu swargada loukhatkhiba matam adu phaobada mahakna toukhiba amadi tambikhiba pumnamaksing adugi maramda ikhre. ");
INSERT INTO mni_vpl VALUES ("AC1_3","074_1_3","ACT","1","3","3","Ibungona siraba matungda, mahakna makhoida numit niphuni chupna masamakpu uhanbirammi amasung mahak hingli haibagi soiphadraba khudam kaya utlammi. Makhoina Ibungobu ujarammi aduga Ibungona makhoida Tengban Mapugi leibakki maramda haibirammi. ");
INSERT INTO mni_vpl VALUES ("AC1_4","074_1_4","ACT","1","4","4","Nongma Ibungona makhoiga chaminnaringeida yathang asi makhoida pirak-i, “Nakhoi Jerusalem thadoktuna chatkhiganu, eina nakhoida haikhiba Ipana pibigani wasakpikhiba khudol adugidamak ngaiyu. ");
INSERT INTO mni_vpl VALUES ("AC1_5","074_1_5","ACT","1","5","5","John-nadi isingda baptize tou-i adubu numit kharanigi manungda nakhoibu Thawai Asengbada baptize toubigani.” ");
INSERT INTO mni_vpl VALUES ("AC1_6","074_1_6","ACT","1","6","6","Adudagi pakhonchatpasingna Ibungogi akoibada pulladuna Ibungoda hanglak-i, “Ibungo, matam asida Ibungona ningthou leibak adu Israel-da hanjinbigadouribra?” ");
INSERT INTO mni_vpl VALUES ("AC1_7","074_1_7","ACT","1","7","7","Maduda Jisuna makhoida khumlak-i, “Eigi Ipana masakhaktagi matikki mapanna lepkhraba matam amadi makum matha adu karamba matamda oigani haiba adu nakhoina khangpham thokte. ");
INSERT INTO mni_vpl VALUES ("AC1_8","074_1_8","ACT","1","8","8","Adubu Thawai Asengbana nakhoigi nathakta lengthabirakpa matamda nakhoina panggal phangjagani aduga nakhoina Jerusalem, Judea amadi Samaria apumba aduga malem-gi aroiba ngamkhei phaoba eigi maramda sakhi oigani.” ");
INSERT INTO mni_vpl VALUES ("AC1_9","074_1_9","ACT","1","9","9","Masi hairaba matungda makhoina yengna yengna Ibungobu swargada loukhatkhre aduga leichin amana Ibungobu makhoigi mityengdagi khanjinkhre. ");
INSERT INTO mni_vpl VALUES ("AC1_10","074_1_10","ACT","1","10","10","Ibungona asum lengkhatlingei aduga makhoina nongthaklomda mityeng hongdana yenglingeida, yeng-u, khanghoudana phingou setpa nupa anina makhoigi manakta leplare. ");
INSERT INTO mni_vpl VALUES ("AC1_11","074_1_11","ACT","1","11","11","Aduga makhoina hairak-i, “Galilee-gi misa, nakhoina mapham asida leptuna nongthaklomda karigi yenglibano? Nakhoigi naraktagi swargada loukhatkhraba Jisu asimak mahakna swargada chatkhiba matou asiga chap mannana Ibungona amuk hallakkhigani.” ");
INSERT INTO mni_vpl VALUES ("AC1_12","074_1_12","ACT","1","12","12","Adudagi pakhonchatpasingna Chorophon Chingdagi Jerusalem-da laklammi. Mapham adudagi Jerusalem asi chaorakna kilometre amamuk lappi. ");
INSERT INTO mni_vpl VALUES ("AC1_13","074_1_13","ACT","1","13","13","Makhoina sahar aduda thunglabada, makhoina leiramba mathakki ka aduda kakhatlammi. Maduda yaobasing adudi Peter, John, Jacob, Andrew, Philip, Thomas, Bartholomew, Matthew, Alphaeus-ki machanupa Jacob, mareibak ningba Simon amasung Jacob-ki machanupa Judas-ni. ");
INSERT INTO mni_vpl VALUES ("AC1_14","074_1_14","ACT","1","14","14","Makhoina nupising, Jisugi mama Mary amadi Ibungogi manaosingga loinana pukning amata oina tattana Tengban Mapuda haijaminnarammi. ");
INSERT INTO mni_vpl VALUES ("AC1_15","074_1_15","ACT","1","15","15","Numit kharanigi matungda thajaba ichil-inao chama kunmuk mapham aduda tinnarammi amasung maduda Peter-na lepkhattuna hairak-i, ");
INSERT INTO mni_vpl VALUES ("AC1_16","074_1_16","ACT","1","16","16","“Ichil inaosa, Jisubu phabada lamjingkhiba Judas-ki maramda mamangeida David-ki mapanna Thawai Asengbana haikhiba Mapugi puyagi wa adu thungba tabani. ");
INSERT INTO mni_vpl VALUES ("AC1_17","074_1_17","ACT","1","17","17","Mahak eikhoigi irakta masing challammi amasung eikhoigi thougal touba asida mahaksu saruk yaminnarammi.” ");
INSERT INTO mni_vpl VALUES ("AC1_18","074_1_18","ACT","1","18","18","Mahakna toukhiba phattaba thabak adudagi phangkhiba sel aduna Judas-na loubuk ama leikhi aduga mapham aduda mahak mamaina leimaida upna taduna mabuk kaikhi aduga makhoi maril chongthokkhi. ");
INSERT INTO mni_vpl VALUES ("AC1_19","074_1_19","ACT","1","19","19","Jerusalem-da leiba mi khudingna pao adu tare aduga makhoina makhoigi londa loubuk adubu Akeldama haina koukhi haibadi handokpada “Eegi loubuk” haibani. ");
INSERT INTO mni_vpl VALUES ("AC1_20","074_1_20","ACT","1","20","20","Peter-na makha taraduna hairak-i, “Laison iseigi lairikta asumna iduna lei, ‘Mahakki yum hangsanu; Aduga maduda mi kana amata leitasanu.’ Asumnasu iduna lei, ‘Kanagumba amana mahakki luchingbagi pham adu lousanu.’ ” ");
INSERT INTO mni_vpl VALUES ("AC1_21","074_1_21","ACT","1","21","22","“Maram aduna, Ibungo Jisuna sibadagi hinggatkhiba adugi sakhi oinaba kanagumba ama eikhoiga punba tare. Mahak adu John-na baptize touba houbadagi Ibungo Jisubu eikhoigi iraktagi swargada loukhatkhiba matam adu phaoba, Ibungona eikhoiga punminnaringei matam pumbada yaoba mi ama oigadabani” ");
INSERT INTO mni_vpl VALUES ("AC1_23","074_1_23","ACT","1","23","23","Adudagi makhoina mi ani khandokle. Makhoi adudi Barsabbas haina kounaba Joseph (Justus hainasu khangnaba) amadi Matthias-ni. ");
INSERT INTO mni_vpl VALUES ("AC1_24","074_1_24","ACT","1","24","25","Adudagi makhoina haija-nijaduna hairak-i, “Ibungo, nahakti mi pumnamakki thamoibu khangbibani. Judas-na masagi oiba mapham aduda chatkhibada thadoklamlaba pakhonchatpagi thougal asi lounanaba, makhoi ani asigi maraktagi Ibungona karambabu khandokpibage haibadu eikhoida utpiyu” ");
INSERT INTO mni_vpl VALUES ("AC1_26","074_1_26","ACT","1","26","26","Adudagi makhoi anigi maraktagi amabu khannanaba makhoina laibak chang yengnabada madu Matthias-ta tare. Maram aduna mahakpu pakhonchatpa taramathoi aduga loinana masing chanminnare. ");
INSERT INTO mni_vpl VALUES ("AC2_1","074_2_1","ACT","2","1","1","Pentecost-ki numit laklabada thajaba makhoi pumnamak mapham amada punna tinnarammi. ");
INSERT INTO mni_vpl VALUES ("AC2_2","074_2_2","ACT","2","2","2","Aduga khanghoudana akanba nonglei nungsitki makhol-gumba ama swargadagi laktuna makhoina tinnaduna leiriba yum apumbadu pumnil nillammi. ");
INSERT INTO mni_vpl VALUES ("AC2_3","074_2_3","ACT","2","3","3","Adudagi meigi leiton manbasingna khaidokkhiduna maphamduda leiriba makhoi pumnamakki mathakta tongba makhoina ure. ");
INSERT INTO mni_vpl VALUES ("AC2_4","074_2_4","ACT","2","4","4","Aduga makhoi pumnamak Thawai Asengbana thallammi amasung Thawai Asengbana makhoibu ngamhanbibagi mapanna makhoina atoppa lonsing ngangba hourammi. ");
INSERT INTO mni_vpl VALUES ("AC2_5","074_2_5","ACT","2","5","5","Matam aduda malemgi mapham pumnamaktagi Tengban Mapubu kina chatchaba Jihudi kaya matam aduda Jerusalem-da laktuna leirammi. ");
INSERT INTO mni_vpl VALUES ("AC2_6","074_2_6","ACT","2","6","6","Makhol adu tabada yamlaba miyam adu changaknaduna mapham aduda omsillaklammi, maramdi thajabasing aduna ngangliba adu makhoi masa masagi londa ngangba oina tarammi. ");
INSERT INTO mni_vpl VALUES ("AC2_7","074_2_7","ACT","2","7","7","Makhoina pungngak ngakladuna hainarak-i, “Yeng-u, asumna ngangliba makhoi pumnamaksing asi Galilee-gi mising nattra? ");
INSERT INTO mni_vpl VALUES ("AC2_8","074_2_8","ACT","2","8","8","Adu oirabadi kamdouna makhoina ngangliba adu eikhoi isa isagi londa ngangba oina taribano? ");
INSERT INTO mni_vpl VALUES ("AC2_9","074_2_9","ACT","2","9","9","Eikhoi kharana Parthia, Media amadi Elam-dagini. Khara amana Mesopotamia, Judea, Cappadocia, Pontus, Asia, ");
INSERT INTO mni_vpl VALUES ("AC2_10","074_2_10","ACT","2","10","10","Phrygia, Pamphylia, Egypt amadi Cyrene manakta leiba Libya-gi maphamsingdagini. Eikhoi khara amana Rome-dagini, ");
INSERT INTO mni_vpl VALUES ("AC2_11","074_2_11","ACT","2","11","11","Jihudi amadi Jihudigi laining loubasingni. Aduga eikhoi kharana Crete amadi Arabia-dagini. Adumakpu Tengban Mapuna touba angakpa thabaksing adugi maramda eikhoi isa isagi londa makhoina ngangba adu eikhoi pumnamakna tari!” ");
INSERT INTO mni_vpl VALUES ("AC2_12","074_2_12","ACT","2","12","12","Maduda ngakladuna amadi chamamnaduna makhoi masel hangnarak-i, “Masibu kari matouno?” ");
INSERT INTO mni_vpl VALUES ("AC2_13","074_2_13","ACT","2","13","13","Adubu makhoi kharana thajabasingbu karemnaduna hairak-i, “Makhoi yu yamna thakle!” ");
INSERT INTO mni_vpl VALUES ("AC2_14","074_2_14","ACT","2","14","14","Adudagi pakhonchatpa makhoi taramathoiga loinana Peter-na lepkhattuna khonjel houna mayam aduda hairak-i, “Jihudi ichil inaosing amadi Jerusalem-da leiba pumnamak, thoudok asigi maramda ei haijage, mayamna ningthina tabiyu. ");
INSERT INTO mni_vpl VALUES ("AC2_15","074_2_15","ACT","2","15","15","Nakhoina khanbagumna makhoi asi yu ngaoba natte. Houjik ayukki pung mapan tabada ngairi. ");
INSERT INTO mni_vpl VALUES ("AC2_16","074_2_16","ACT","2","16","16","Adubu masi Tengban Mapugi wa phongdokpiba maichou Joel-na haibikhiba aduni: ");
INSERT INTO mni_vpl VALUES ("AC2_17","074_2_17","ACT","2","17","17","Tengban Mapuna hai, ‘Aroiba numitsingda eina eigi Thawaibu mi pumnamakki mathakta heithabigani. Nakhoigi nachanupasing amadi nachanupisingna eigi wa phongdokkani; nakhoigi naha oiriba nupasingna uhanbibasing adu ujagani, aduga nakhoigi ahal oirabasingna mang manggani. ");
INSERT INTO mni_vpl VALUES ("AC2_18","074_2_18","ACT","2","18","18","Eigi inai nupasing amadi inai nupising animakki mathakta phaoba, numitsing aduda eina eigi Thawai heithagani, aduga makhoina eigi wa phongdokkani. ");
INSERT INTO mni_vpl VALUES ("AC2_19","074_2_19","ACT","2","19","19","Eina atiya mathakta angakpasing aduga malemgi makhada khudamsing utkani. Maduda ee, mei amadi meikhu mapei leigani; ");
INSERT INTO mni_vpl VALUES ("AC2_20","074_2_20","ACT","2","20","20","MAPU IBUNGO-gi achouba amadi matik mangalgi numit aduda Numitna mamkhigani aduga thana eegumna nganggani. ");
INSERT INTO mni_vpl VALUES ("AC2_21","074_2_21","ACT","2","21","21","Adubu MAPU IBUNGO-gi ming koujaba mi pumnamakpu kanbigani.’ ” ");
INSERT INTO mni_vpl VALUES ("AC2_22","074_2_22","ACT","2","22","22","“Israel-gi misa, masi tabiyu! Tengban Mapuna Ibungo mangonda angakpa thabaksing amadi khudamsing pangthok-hanbiduna Nazareth-ki Jisu asi Tengban Mapuna yaba mini haibasi mayek sengna utpire. Masi nakhoi nasamakna khangliba aduni, maramdi pumnamaksing adu nakhoigi narakta thokkhibani. ");
INSERT INTO mni_vpl VALUES ("AC2_23","074_2_23","ACT","2","23","23","Tengban Mapuna hanna lepkhraba mahakki thourang matung-inna Ibungo Jisubu nakhoigi khutta sinnabani aduga nakhoina wayel yathang indaba misingda Ibungobu cross-ta pang ting-handuna hatpani. ");
INSERT INTO mni_vpl VALUES ("AC2_24","074_2_24","ACT","2","24","24","Adubu Tengban Mapuna Ibungobu sibadagi hinggat-hanbire, asibagi panggaldagi thadokpire maramdi asibana Ibungobu phaduna thamba oithokte. ");
INSERT INTO mni_vpl VALUES ("AC2_25","074_2_25","ACT","2","25","25","Maramdi David ningthouna Ibungogi maramda asumna hairammi, ‘MAPU IBUNGO-bu matam pumbada eina eigi mangda ujei; Ibungona eigi nakta leiba maramna, eibu keidounungda lenghanba ngamloi. ");
INSERT INTO mni_vpl VALUES ("AC2_26","074_2_26","ACT","2","26","26","Maram asina ei nungaibana thalle, aduga eigi leiton-na haraojare. Aduga eidi sigadaba oirabasu eigi hakchangna asada hingjagani. ");
INSERT INTO mni_vpl VALUES ("AC2_27","074_2_27","ACT","2","27","27","Maramdi Ibungona eibu khamnung leibakta hundokpiroi; Nahakna nahakki Asengba Mahak adubu mongphamda pattha-pumthanhanbiroi, ");
INSERT INTO mni_vpl VALUES ("AC2_28","074_2_28","ACT","2","28","28","Ibungona eingonda hingbagi lambising khanghanbire, Ibungogi mangda eibu haraobana thalhanbire.’ ” ");
INSERT INTO mni_vpl VALUES ("AC2_29","074_2_29","ACT","2","29","29","“Eigi ichil-inaosa, eina nakhoida eikhoigi ipa ipu oiriba David ningthougi maramda thouna phana hairibasini. Mahak sikhi amadi leirol chankhi aduga ngasisu mahakki mongpham mapham asida leiri. ");
INSERT INTO mni_vpl VALUES ("AC2_30","074_2_30","ACT","2","30","30","Mahak Tengban Mapugi wa phongdokpiba maichou amani, amasung mahakki charol surol amana mahakki phambalda phamhan-gani haina Tengban Mapuna mangonda wasakpiba adu mahakna khanglammi. ");
INSERT INTO mni_vpl VALUES ("AC2_31","074_2_31","ACT","2","31","31","Tengban Mapuna tungda tourakkadaba adu David-na ukhi maram aduna mahakna Christtana sibadagi hinggatpagi maramda asumna haikhi, ‘Ibungobu khamnung leibakta hundokpide; Ibungogi hakchang mongphamda pattha-pumthahanbide.’ ");
INSERT INTO mni_vpl VALUES ("AC2_32","074_2_32","ACT","2","32","32","Aduga Tengban Mapuna Ibungo Jisu asimakpu asibadagi hinggat-hanbire haiba achumba asigi sakhi eikhoi pumnamakna oiri. ");
INSERT INTO mni_vpl VALUES ("AC2_33","074_2_33","ACT","2","33","33","Ibungo mahakpu Tengban Mapugi yet thangbada thanggatpire. Mapa Ibungona wasakpikhibagumna Ibungona Thawai Asengba phangjare aduga nakhoina uriba amadi taribasi Ibungona eikhoigi ithakta Thawai adu heithabibani. ");
INSERT INTO mni_vpl VALUES ("AC2_34","074_2_34","ACT","2","34","34","Maramdi swargada kakhiba adu David natte adubu mahakna haikhi, ‘Mapu Ibungona eigi Mapu Ibungoda hai: Eina nahakki yeknabasingbu nahakki khongnetpham oihandriphaoba ");
INSERT INTO mni_vpl VALUES ("AC2_35","074_2_35","ACT","2","35","35","eigi yet thangbada phammu.’ ” ");
INSERT INTO mni_vpl VALUES ("AC2_36","074_2_36","ACT","2","36","36","“Israel-gi mi khudingmakna masi khangsanu: nakhoina cross-ta pang tingduna hatkhraba Jisu asi Tengban Mapuna Ibungo amadi Christta oihanbire.” ");
INSERT INTO mni_vpl VALUES ("AC2_37","074_2_37","ACT","2","37","37","Mising aduna wapham asi tabada thamoi yamna soklammi aduga Peter amadi atei pakhonchatpasingda hairak-i, “Ichil-inaosa, eikhoina kari toujagadage?” ");
INSERT INTO mni_vpl VALUES ("AC2_38","074_2_38","ACT","2","38","38","Maduda Peter-na makhoida khumlak-i, “Nakhoigi paptagi pukning hong-u aduga Jisu Christtagi mingda baptize lou adu oirabadi nakhoigi papsing kokpigani aduga nakhoina Tengban Mapugi khudol Thawai Asengba adu phangjagani. ");
INSERT INTO mni_vpl VALUES ("AC2_39","074_2_39","ACT","2","39","39","Maramdi wasakpiba asi nakhoi amadi nakhoigi nachasingda amadi arappada leiba pumnamakta haibadi eikhoigi Mapu Ibungo Tengban Mapuna koubigadaba pumnamakkini.” ");
INSERT INTO mni_vpl VALUES ("AC2_40","074_2_40","ACT","2","40","40","Atoppa wahei kayaga loinana Peter-na makhoida cheksin wa hairammi. Adudagi mahakna thougatladuna hairak-i, “Nakhoina phattaba mirol asidagi kanjou” ");
INSERT INTO mni_vpl VALUES ("AC2_41","074_2_41","ACT","2","41","41","Makhoi mayam amana mahakki wada thajaduna baptize lourammi. Numit aduda mi lising ahumlom makhoigi marakta tinsillammi. ");
INSERT INTO mni_vpl VALUES ("AC2_42","074_2_42","ACT","2","42","42","Makhoina pakhonchatpasinggi tambibada, tinnabada, tal thugaiba yaona chaminnabada amasung haijaminnabada tattana pukning changlammi. ");
INSERT INTO mni_vpl VALUES ("AC2_43","074_2_43","ACT","2","43","43","Pakhonchatpasinggi mapanna angakpa thabaksing amasung khudamsing tourammi maduda mi khudingmak angakpana thallammi. ");
INSERT INTO mni_vpl VALUES ("AC2_44","074_2_44","ACT","2","44","44","Thajaba pumnamak punna leiminnarammi aduda makhoigi areiba pumnamak mayamgi oina sijinnarammi. ");
INSERT INTO mni_vpl VALUES ("AC2_45","074_2_45","ACT","2","45","45","Makhoina makhoigi lanthum amadi potchei yonthoklammi aduga phanglakpa aduna makhoigi marakta awatpa leibasingda yenthoklammi. ");
INSERT INTO mni_vpl VALUES ("AC2_46","074_2_46","ACT","2","46","46","Numit khuding makhoina Mapugi Sanglenda tinnarammi aduga makhoigi yum yumda tal thugaiduna haraona amasung pukchel tingna chaminnarammi, ");
INSERT INTO mni_vpl VALUES ("AC2_47","074_2_47","ACT","2","47","47","Tengban Mapubu thagatcharammi amasung mi pumnamaktagi chanbiba phangjarammi. Aduga kanbiba phanglabasingbu numit khudinggi Ibungona makhoida tinsinhanbirammi. ");
INSERT INTO mni_vpl VALUES ("AC3_1","074_3_1","ACT","3","1","1","Nongma Peter amadi John-na haijabagi pungpham haibadi numit yungba matung pung ahum tabada Mapugi Sanglenda chatlammi. ");
INSERT INTO mni_vpl VALUES ("AC3_2","074_3_2","ACT","3","2","2","Ningthijaba haina kouba Mapugi Sanglen-gi thonggal aduda mama puknungdagi makhong soinairaklaba nupa ama Mapugi Sanglenda lakpa misingdagi sel ninanaba numit khudinggi maphamduda puraktuna thamlammi. ");
INSERT INTO mni_vpl VALUES ("AC3_3","074_3_3","ACT","3","3","3","Peter amadi John-na changlakpa adu mahakna ubada makhoida sel pibinaba nijarammi. ");
INSERT INTO mni_vpl VALUES ("AC3_4","074_3_4","ACT","3","4","4","Maduda makhoina mangonda munna yenglammi aduga Peter-na mangonda hairak-i, “Eikhoida yenglak-u” ");
INSERT INTO mni_vpl VALUES ("AC3_5","074_3_5","ACT","3","5","5","Maram aduna mahakna makhoidagi karigumba khara phanglagani khanduna makhoida yenglammi. ");
INSERT INTO mni_vpl VALUES ("AC3_6","074_3_6","ACT","3","6","6","Adubu Peter-na mangonda hairak-i, “Eingonda sana lupa amata leite adubu eigi areiba adu nangonda piri. Nazareth-ki Jisu Christtagi mingda nahak hougattuna chatlu” ");
INSERT INTO mni_vpl VALUES ("AC3_7","074_3_7","ACT","3","7","7","Adudagi Peter-na mahakpu makhut yet paiduna chingkhatpirammi. Khudak aduda nupa adugi khong amadi khujeng kankhatkhi. ");
INSERT INTO mni_vpl VALUES ("AC3_8","074_3_8","ACT","3","8","8","Maduda mahakna chongkhatlaga leplammi aduga koichat chatpa hourammi. Mahakna chattuna chongduna amadi Tengban Mapubu thagattuna Peter amadi John-ga loinana Mapugi Sanglenda changlammi. ");
INSERT INTO mni_vpl VALUES ("AC3_9","074_3_9","ACT","3","9","9","Mahakna chatliba amadi Tengban Mapubu thagatliba adu mi pumnamakna ubada, ");
INSERT INTO mni_vpl VALUES ("AC3_10","074_3_10","ACT","3","10","10","mahak asi Mapugi Sanglen-gi Ningthijaba Thonggal kouba maphamda phamduna sel niba mi aduni haiba makhoina khangle aduga mangonda thokpa thoudok aduda makhoi angakpana amadi changaknabana thallammi. ");
INSERT INTO mni_vpl VALUES ("AC3_11","074_3_11","ACT","3","11","11","Solomon-gi Hojang kouba mapham aduda nupa aduna Peter amadi John-da paiduna leiba aduda mi pumnamakna ngakladuna makhoigi manakta chensillaklammi. ");
INSERT INTO mni_vpl VALUES ("AC3_12","074_3_12","ACT","3","12","12","Peter-na madu ubada makhoida hairak-i, “Israel-gi misa, thoudok asida nakhoi karigi ngaklibano? Eikhoigi panggalna nattraga eikhoigi Tengban Mapu ningbagi mapanna nupa asi chat-hanbani haina khanduna eikhoida munna karigi yenglibano? ");
INSERT INTO mni_vpl VALUES ("AC3_13","074_3_13","ACT","3","13","13","Abraham, Isaac, Jacob amadi eikhoigi ipa-ipugi Tengban Mapu mahakna Ibungo mahakki manai Jisubu matik mangal chaohanbire. Adubu nakhoinadi Ibungo Jisubu hatnanaba pithokle aduga Pilate-na Ibungobu thadoknaba leplabasu nakhoina Pilate-ki mangda Ibungobu yakhide. ");
INSERT INTO mni_vpl VALUES ("AC3_14","074_3_14","ACT","3","14","14","Aduga nakhoina achumba chatpa amasung asengba Ibungo mahakpu yadre aduga mihatpa amabu thadoknaba nakhoina nijare. ");
INSERT INTO mni_vpl VALUES ("AC3_15","074_3_15","ACT","3","15","15","Nakhoina hingbagi mapubu hatle adubu Tengban Mapuna Ibungo mahakpu amuk hinggat-hanbire. Eikhoi madugi sakhini. ");
INSERT INTO mni_vpl VALUES ("AC3_16","074_3_16","ACT","3","16","16","Jisugi mingda thajabagi mapanna nakhoina uriba amadi khangba nupa asibu kalhanbire. Aduga nakhoina ubagumna mahakna pumpha phajariba asi Jisugi ming amadi mangonda thajaba adugi mapalnani.” ");
INSERT INTO mni_vpl VALUES ("AC3_17","074_3_17","ACT","3","17","17","“Ichil-inaosa, nakhoi amadi nakhoigi luchingbasingna Jisuda toukhiba adu nakhoina khangdabagi toukhibani haiba ei khang-i. ");
INSERT INTO mni_vpl VALUES ("AC3_18","074_3_18","ACT","3","18","18","Christta adu awa-ana khanggani haina Tengban Mapugi wa phongdokpiba maichousinggi mapanna Tengban Mapuna khanghankhiba adu thunghanbire. ");
INSERT INTO mni_vpl VALUES ("AC3_19","074_3_19","ACT","3","19","19","Ibungona nakhoigi napapsing adu kokpinanaba pukning hong-u aduga Tengban Mapuda onsillak-u. Nakhoina madu tourabadi, ");
INSERT INTO mni_vpl VALUES ("AC3_20","074_3_20","ACT","3","20","20","thawaigi oiba panggal adu Ibungodagi lakkani aduga nakhoigidamak khandokpiraba Jisu haibadi Christtabu mahakna thabirakkani. ");
INSERT INTO mni_vpl VALUES ("AC3_21","074_3_21","ACT","3","21","21","Tengban Mapugi asengba maichousinggi mapanna kuirabagi mamangda khanghanbikhibagumna, Tengban Mapuna pot pumnamakpu hanjinhanbibagi matam adu laktriba phaoba Jisudi swargada leiba tai. ");
INSERT INTO mni_vpl VALUES ("AC3_22","074_3_22","ACT","3","22","22","Maramdi Moses-na haikhi, ‘Nakhoigi Tengban Mapu, MAPU IBUNGO-na nakhoigi maraktagi eiga manaba Tengban Mapugi wa phongdokpiba maichou ama thok-hanbirakkani, mahakna haiba pumnamak nakhoina in-gadabani. ");
INSERT INTO mni_vpl VALUES ("AC3_23","074_3_23","ACT","3","23","23","Maichou aduna haiba indaba mi khudingmak Tengban Mapugi misinggi maraktagi khaidoktuna mang-hangani.’ ");
INSERT INTO mni_vpl VALUES ("AC3_24","074_3_24","ACT","3","24","24","Samuel-dagi houraga Tengban Mapugi wa phongdokpiba maichou pumnamakna numitsing asigi matangda mangjounana haikhi. ");
INSERT INTO mni_vpl VALUES ("AC3_25","074_3_25","ACT","3","25","25","Maichousinggi mapanna Tengban Mapuna pibikhiba wasaksing adu nakhoigini aduga Tengban Mapuna nakhoigi napa napusingga walepnakhiba aduda nakhoigi saruk yao-i. Ibungo mahakna Abraham-da haibikhiba, ‘Nahakki charol-surolgi mapanna malemda leiba mioi kanglup pumnamak yaipha thoujal phangjagani.’ ");
INSERT INTO mni_vpl VALUES ("AC3_26","074_3_26","ACT","3","26","26","Maram aduna Tengban Mapuna mahakki manai Jisubu khanbiduna nakhoi pumnamak ayol arandagi pukning hong-handuna yaipha thoujal pibinaba nakhoigi narakta hanna thabire.” ");
INSERT INTO mni_vpl VALUES ("AC4_1","074_4_1","ACT","4","1","1","Peter amadi John-na miyam aduda wa nganglingeida purohitsing, Mapugi Sanglen ngakpasinggi makok amadi Sadducee khara laklammi. ");
INSERT INTO mni_vpl VALUES ("AC4_2","074_4_2","ACT","4","2","2","Pakhonchatpa ani aduna Jisu sibadagi hinggatle haina misingda tambiba aduda makhoi nungairamde maramdi tambiba aduna asibasing hinggatkani haiba utle. ");
INSERT INTO mni_vpl VALUES ("AC4_3","074_4_3","ACT","4","3","3","Maram aduna makhoina Peter amadi John-bu phare aduga makhoibu mathanggi numit phaoba keisumsangda thamlammi maramdi matam adu numidang oire. ");
INSERT INTO mni_vpl VALUES ("AC4_4","074_4_4","ACT","4","4","4","Adubu wa adu taba mi mayam amana thajare maram aduna thajaba mi masing lising mangamuk sure. ");
INSERT INTO mni_vpl VALUES ("AC4_5","074_4_5","ACT","4","5","5","Mathanggi numitta Jihudisinggi luchingbasing, ahal lamansing, Wayel Yathanggi ojasingna Jerusalem-da tillammi. ");
INSERT INTO mni_vpl VALUES ("AC4_6","074_4_6","ACT","4","6","6","Makhoina Purohitlen Annas, Caiaphas, John, Alexander amadi Purohitlen-gi mari-matasingga unarammi. ");
INSERT INTO mni_vpl VALUES ("AC4_7","074_4_7","ACT","4","7","7","Makhoina John amadi Peter-bu makhoigi mangda lep-hallaga hanglak-i, “Kari panggalna nattraga kanagi mingda masi touribano” ");
INSERT INTO mni_vpl VALUES ("AC4_8","074_4_8","ACT","4","8","8","Madudagi Peter-na Thawai Asengbana thalladuna makhoida hairak-i, “Miyamgi luchingbasing amadi ahal lamansing, ");
INSERT INTO mni_vpl VALUES ("AC4_9","074_4_9","ACT","4","9","9","khong tekpa mi amabu phahanduna aphaba thabak toubagidamak mahakpu karamna phahanbano haina eikhoibu wahang paohanglabadi ");
INSERT INTO mni_vpl VALUES ("AC4_10","074_4_10","ACT","4","10","10","nakhoi pumnamak amadi Israel-gi mi pumnamak masi khangsanu madudi nakhoigi mangda lepliba mi asi nakhoina cross-ta pangtingduna hatkhraba aduga Tengban Mapuna hinggat-hanbiraba Nazareth-ki Jisu Christtagi minggi mapanna pumpha phahanbani. ");
INSERT INTO mni_vpl VALUES ("AC4_11","074_4_11","ACT","4","11","11","Mapugi puyana haibiba mahak adu Jisu asini, ‘Yumsaba nakhoina yadraba nung adu chuthekki nung oire.’ ");
INSERT INTO mni_vpl VALUES ("AC4_12","074_4_12","ACT","4","12","12","Atei kanagi maphamda aran-khubham leite, maramdi madugi mapanna eikhoibu kanbigadaba misinggi marakta pibiba atoppa ming amata atiyagi makhada leite.” ");
INSERT INTO mni_vpl VALUES ("AC4_13","074_4_13","ACT","4","13","13","Makhoina Peter amadi John-gi thouna adu ubada amadi makhoi ani asi lairik laisu tamdaba achamba mini haiba khanglabada ngaklammi aduga makhoi Jisuga loinaramba mini haibadu khanglakle. ");
INSERT INTO mni_vpl VALUES ("AC4_14","074_4_14","ACT","4","14","14","Naba phahankhraba nupa adu Peter-ga John-ga loinana leptuna leiba maramna makhoi karisu haiba ngamdre. ");
INSERT INTO mni_vpl VALUES ("AC4_15","074_4_15","ACT","4","15","15","Maram aduna makhoina Peter amadi John-bu Sanhedrin-dagi thokkhinaba yathang pirammi aduga makhoi masel wa tanarammi. ");
INSERT INTO mni_vpl VALUES ("AC4_16","074_4_16","ACT","4","16","16","Makhoi amaga amaga hangnarak-i, “Makhoida eikhoina kari tousige? Makhoina angakpa thabak ama toure haibasi Jerusalem-da leiba mi pumnamakna khang-i. Madu eikhoina yadaba ngamloi. ");
INSERT INTO mni_vpl VALUES ("AC4_17","074_4_17","ACT","4","17","17","Adubu masi makha tana misinggi marakta sandoktanaba Jisugi ming sijinnaduna misingda ngangdanaba akanba mawongda kihansi.” ");
INSERT INTO mni_vpl VALUES ("AC4_18","074_4_18","ACT","4","18","18","Maram aduna makhoina pakhonchatpasing adubu amuk kousille aduga makhoida Jisugi ming sijinnaduna amuk hanna ngangdanaba amadi tambidanaba yathang pire. ");
INSERT INTO mni_vpl VALUES ("AC4_19","074_4_19","ACT","4","19","19","Maduda Peter amadi John-na makhoida khumlak-i, “Nakhoina haiba inbaga Tengban Mapuna haiba inbaga Tengban Mapugi mityengda karambana chumgani haibadu nakhoi wayel tou. ");
INSERT INTO mni_vpl VALUES ("AC4_20","074_4_20","ACT","4","20","20","Eikhoina ukhraba amadi takhraba adu eikhoi haidaba ngamloi” ");
INSERT INTO mni_vpl VALUES ("AC4_21","074_4_21","ACT","4","21","21","Maram aduna mipham aduna makhoida makha tana kihallaba matungda makhoibu thadokle. Thoudok adugi maramna mi pumnamakna Tengban Mapubu thagatpa maramna makhoina karamna makhoibu cheirak pigadabano haiba khanglamde. ");
INSERT INTO mni_vpl VALUES ("AC4_22","074_4_22","ACT","4","22","22","Maramdi anaba phahanbibagi angakpa thabak toubikhraba nupa adu chahi niphu hellaba mi oirammi. ");
INSERT INTO mni_vpl VALUES ("AC4_23","074_4_23","ACT","4","23","23","Peter amadi John-bu hek thadokpaga makhoina makhoigi loinabasinggi manakta laktuna athoiba purohitsing amadi ahal-lamansingna makhoida hairakpa pumnamak adu makhoida tamle. ");
INSERT INTO mni_vpl VALUES ("AC4_24","074_4_24","ACT","4","24","24","Makhoina madu tabada makhoi punna khonjel wangna Tengban Mapugi maphamda haijarammi. Makhoina hairak-i, “Mapu Ibungo, nahakti swarga, malem, changjourel ipak amadi madugi manungda leiba pumnamakpu sembibani. ");
INSERT INTO mni_vpl VALUES ("AC4_25","074_4_25","ACT","4","25","25","Thawai Asengbagi mapanna eikhoigi ipa aduga Ibungo nahakkidi nanai oiba David-ki chindagi Ibungona haibikhi, ‘Karigi Jihudi nattaba phurupsingna kanna saoribano; karigi misingna arembada loutunaribano? ");
INSERT INTO mni_vpl VALUES ("AC4_26","074_4_26","ACT","4","26","26","Mapu Ibungo amadi mahakki Christtagi maiyokta, malemgi ningthousingna lan-gidamak sem-sare, amadi leingakpasingna punsille.’ ");
INSERT INTO mni_vpl VALUES ("AC4_27","074_4_27","ACT","4","27","27","Ibungo nahakna thao noibikhraba nahakki asengba nanai Jisugi maiyokta loutunanaba tasengnamak Herod, Pontius Pilate-na amadi Jihudi nattaba phurupsing amasung Israel-gi misingga punna sahar asida tinnare. ");
INSERT INTO mni_vpl VALUES ("AC4_28","074_4_28","ACT","4","28","28","Masi Ibungogi panggalna amadi aningbana hanna thoknaba lepkhraba adu makhoina pangthokpani. ");
INSERT INTO mni_vpl VALUES ("AC4_29","074_4_29","ACT","4","29","29","Mapu Ibungo, houjik makhoina kihallakliba asi yengbiyu, Ibungogi nanaisingna thouna phana Ibungogi wa ngangthokpa ngamhanbiyu. ");
INSERT INTO mni_vpl VALUES ("AC4_30","074_4_30","ACT","4","30","30","Ibungogi asengba nanai Jisugi minggi mapanna anaba phahannaba amadi angakpa thabak amasung khudamsing pangthoknaba Ibungogi khut tingthokpiyu.” ");
INSERT INTO mni_vpl VALUES ("AC4_31","074_4_31","ACT","4","31","31","Makhoina haijaba asi loibada, makhoina tinnariba mapham adu niklammi. Aduga makhoi pumnamak Thawai Asengbana thallammi amasung Tengban Mapugi wa thouna phana nganglammi. ");
INSERT INTO mni_vpl VALUES ("AC4_32","074_4_32","ACT","4","32","32","Thajaba mi pumnamak pukning wakhal amata oina leirammi. Makhoi kana amatana masagi leijaba pot amata masagini haijade adubu makhoigi leijaba pumnamak punna sijinminnarammi. ");
INSERT INTO mni_vpl VALUES ("AC4_33","074_4_33","ACT","4","33","33","Akanba panggalga loinana pakhonchatpasingna Mapu Ibungo Jisuna hinggatkhibagi maramda sakhi pirammi aduga Tengbang Mapuna makhoi pumnamakki mathakta yaipha thoujal marang kaina heithabirammi. ");
INSERT INTO mni_vpl VALUES ("AC4_34","074_4_34","ACT","4","34","34","Makhoigi marakta kanagisu awatpa leiramde maramdi lam nattraga yum leibasingna madu yonthoklaga senpham adu puraklaga ");
INSERT INTO mni_vpl VALUES ("AC4_35","074_4_35","ACT","4","35","35","pakhonchatpasinggi khuyakhada thamlammi aduga kanagumbagi awatpa leibagi matung inna senpham adu yenthoklammi. ");
INSERT INTO mni_vpl VALUES ("AC4_36","074_4_36","ACT","4","36","36","Pakhonchatpasingna Barnabas haina kouba (handokpada “Thougatpiba mi” haibani) Cyprus-tagi Levi sageigi Joseph mahakna ");
INSERT INTO mni_vpl VALUES ("AC4_37","074_4_37","ACT","4","37","37","mahakki loubuk ama yonthoklaga senpham adu pakhonchatpasinggi khuyakhada thamlammi. ");
INSERT INTO mni_vpl VALUES ("AC5_1","074_5_1","ACT","5","1","1","Ananias kouba nupa amana mahakki nupi Sapphira-ga loinana makhoigi lam machet ama yonthoklammi. ");
INSERT INTO mni_vpl VALUES ("AC5_2","074_5_2","ACT","5","2","2","Adubu mahakki nupiga yanaduna mahakna senpham adudagi saruk khara masagidamak khak-houraga ateising adu pakhonchatpasinggi khuyakhada thamlammi. ");
INSERT INTO mni_vpl VALUES ("AC5_3","074_5_3","ACT","5","3","3","Maduda Peter-na mangonda hairak-i, “Ananias, lam adudagi phanglakpa senpham khara nasagidamak khak-houduna Satan-na nahakpu khudum chalhanduna Thawai Asengbada minamliba karigino? ");
INSERT INTO mni_vpl VALUES ("AC5_4","074_5_4","ACT","5","4","4","Lam adu yondringeida nahakki oiramba nattra? Madu yollaba matungdasu senpham adu nahakna sijinnabagi naning leiramba nattra? Karigi nahakna asigumba thabak asi touribano? Nahakna misingda minamba natte adubu Tengban Mapuda minambani.” ");
INSERT INTO mni_vpl VALUES ("AC5_5","074_5_5","ACT","5","5","5","Ananias-na masi hek tabaga mahak leimaida haithaduna sire. Thoudok asi taba mi pumnamak yamna kiba phaorammi. ");
INSERT INTO mni_vpl VALUES ("AC5_6","074_5_6","ACT","5","6","6","Adudagi naha oiriba nupasingna changlaktuna Ananias-ki hakchang adu phina yomduna puraga mahakpu leirol challe. ");
INSERT INTO mni_vpl VALUES ("AC5_7","074_5_7","ACT","5","7","7","Pung ahummukki matungda thokkhiba thoudok adu karisu khangdana mahakki nupina changlakkhi. ");
INSERT INTO mni_vpl VALUES ("AC5_8","074_5_8","ACT","5","8","8","Peter-na mangonda hanglak-i, “Nahak amadi nahakki napuroibana lam adudagi phanglakpa apunba senpham adu asira?” Mahakna khumlak-i, “Hoi, senpham adumakni” ");
INSERT INTO mni_vpl VALUES ("AC5_9","074_5_9","ACT","5","9","9","Maduda Peter-na mangonda hairak-i, “Nakhoi anina karigi Mapu Ibungogi Thawaibu chang yengbada yanaribano? Yeng-u, nahakki napuroibabu leirol challuba mising adu houjik thongjinda leiri, makhoina nahakpusu puthoklagani.” ");
INSERT INTO mni_vpl VALUES ("AC5_10","074_5_10","ACT","5","10","10","Khudak aduda mahak Peter-gi khuyada tuthaduna sire. Aduga naha oiriba nupasing aduna changlakpada mahak siduna leiramba ure aduna makhoina mahakpu puthoklaga mahakki mapuroibagi manakta leirol challe. ");
INSERT INTO mni_vpl VALUES ("AC5_11","074_5_11","ACT","5","11","11","Singlup apumba amadi thokkhiba thoudok asi taba mi pumnamak akiba poklammi. ");
INSERT INTO mni_vpl VALUES ("AC5_12","074_5_12","ACT","5","12","12","Pakhonchatpasingna angakpa thabaksing amadi khudam kaya misinggi marakta tourammi. Aduga thajaba makhoi pumnamak Solomon-gi Hojangda tattana unarammi. ");
INSERT INTO mni_vpl VALUES ("AC5_13","074_5_13","ACT","5","13","13","Makhoibu misingna ikai khumnarabasu atoppa mi kana amatana makhoigi marakta yaonanaba thounadi leiramde. ");
INSERT INTO mni_vpl VALUES ("AC5_14","074_5_14","ACT","5","14","14","Adum oinamak nupa amadi nupising henna henna Ibungoda thajaraktuna makhoigi marakta tinsillaklammi. ");
INSERT INTO mni_vpl VALUES ("AC5_15","074_5_15","ACT","5","15","15","Maram asina Peter-na lakpada mahakki mami khaktang oirabasu makhoigi mathakta tananaba misingna anabasingbu lambida puthoraklaga kangtholsing amadi phaksingda hipphallammi. ");
INSERT INTO mni_vpl VALUES ("AC5_16","074_5_16","ACT","5","16","16","Jerusalem-gi akoibada leiba saharsingdagisu miyamsingna laktuna anabasing amadi phattaba thawai changbasingbu puraklammi aduga makhoi pumnamak anaba pharammi. ");
INSERT INTO mni_vpl VALUES ("AC5_17","074_5_17","ACT","5","17","17","Adudagi Purohitlen amadi mahakka loinariba haibadi Sadducee-singgi khutpusing adu kallakpana thallammi. ");
INSERT INTO mni_vpl VALUES ("AC5_18","074_5_18","ACT","5","18","18","Makhoina pakhonchatpasingbu phaduna keisumsangda thamlammi. ");
INSERT INTO mni_vpl VALUES ("AC5_19","074_5_19","ACT","5","19","19","Adubu ahing aduda Mapu Ibungogi dut ama laklaga keisumsang adugi thongsing adu hangdokle aduga makhoibu puthoklaga hairak-i, ");
INSERT INTO mni_vpl VALUES ("AC5_20","074_5_20","ACT","5","20","20","“Chatlu aduga Mapugi Sanglen-gi sumangda leptuna misingda anouba punsi asigi wa pumnamak sandok-u.” ");
INSERT INTO mni_vpl VALUES ("AC5_21","074_5_21","ACT","5","21","21","Makhoida haikhiba adugumna pakhonchatpasing aduna ayuk anganbada Mapugi Sanglen-gi sumangda changlaga misingda tambiba hourammi. Purohitlen amadi mahakka loinabasingna laklaga Jihudisinggi ahal laman pumnamakpu kouduna mipham pangthoklammi aduga keisumsangdagi pakhonchatpasingbu puraknaba mi tharammi. ");
INSERT INTO mni_vpl VALUES ("AC5_22","074_5_22","ACT","5","22","22","Adubu phamnaibasing aduna lakpada keisumsangda pakhonchatpasing adu phangdre maram aduna makhoina hallaktuna paodamlak-i, ");
INSERT INTO mni_vpl VALUES ("AC5_23","074_5_23","ACT","5","23","23","“Eikhoina keisumsang youbada keisumsang adu so chetna londuna thinglammi amadi thongngakpasingna thong manakta leplamba eikhoina thengnei adubu eikhoina thong hangbada mapham aduda kana amata leiramdre” ");
INSERT INTO mni_vpl VALUES ("AC5_24","074_5_24","ACT","5","24","24","Athoiba purohitsing amadi Mapugi Sanglen ngakpasinggi makok aduna madu tabada kari thoklagadaba haina langtaknarammi. ");
INSERT INTO mni_vpl VALUES ("AC5_25","074_5_25","ACT","5","25","25","Adudagi nupa amana changlaktuna makhoida tamlak-i, “Yeng-u, nakhoina keisumsangda thamba misingdu Mapugi Sanglen-gi sumangda leptuna misingda tambiri” ");
INSERT INTO mni_vpl VALUES ("AC5_26","074_5_26","ACT","5","26","26","Maram aduna Mapugi Sanglen ngakpa makok aduna mahakki lanmisingga loinana chattuna pakhonchatpasing adubu puraklammi. Adubu miyamsing aduna makhoida nungna thagani haiba kibagi maramna makhoina nam-haduna purakpadi touramde. ");
INSERT INTO mni_vpl VALUES ("AC5_27","074_5_27","ACT","5","27","27","Purohitlenna makhoibu wahang paohang tounanaba makhoina pakhonchatpasing adubu Sanhedrin adugi mangda lep-halle. ");
INSERT INTO mni_vpl VALUES ("AC5_28","074_5_28","ACT","5","28","28","Mahakna hairak-i, “Ming asi sijinnaduna tambidanaba eikhoina nakhoida akanba yathang pikhre. Aduga nakhoina Jerusalem-gi mapham pumbada nakhoigi tambiba asina pumsan sandokle amadi nupa adu sibagi maral adu eikhoida theijinnaba hotnei.” ");
INSERT INTO mni_vpl VALUES ("AC5_29","074_5_29","ACT","5","29","29","Maduda Peter amadi atei pakhonchatpasingna khumlak-i, “Migi yathang inbadagi henna Tengban Mapugi yathang inba tabani. ");
INSERT INTO mni_vpl VALUES ("AC5_30","074_5_30","ACT","5","30","30","Nakhoina Jisubu cross-ta hatkhraba tungda eikhoigi ipa-ipusinggi Tengban Mapuna Ibungobu sibadagi hinggat-hanbire. ");
INSERT INTO mni_vpl VALUES ("AC5_31","074_5_31","ACT","5","31","31","Israel-gi misingda pukning hongba amadi pap kokpiba pibinanaba Tengban Mapuna Ibungo mahakpu Luchingba amadi Kanbiba Mapu oina Ibungo mahakki yet thangba nakanda thanggatpire. ");
INSERT INTO mni_vpl VALUES ("AC5_32","074_5_32","ACT","5","32","32","Eikhoi masising asigi sakhini amasung Tengban Mapuna mahakpu haiba inbasingda pibiba Thawai Asengba adunasu sakhini.” ");
INSERT INTO mni_vpl VALUES ("AC5_33","074_5_33","ACT","5","33","33","Masi tabada makhoi mei houna saorammi amasung makhoibu hatpa pamlammi. ");
INSERT INTO mni_vpl VALUES ("AC5_34","074_5_34","ACT","5","34","34","Adubu makhoigi maraktagi maming Gamaliel kouba Pharisee-singna ikai khumnaba Wayel Yathanggi oja asina lepkhatlaga pakhonchatpasingbu ngaihaktang mapanda puthoknaba yathang pirammi. ");
INSERT INTO mni_vpl VALUES ("AC5_35","074_5_35","ACT","5","35","35","Aduga mahakna makhoida hairak-i, “Israel-gi ichil inaosa, nakhoina mising asida touge khalliba adu munna khanthabiyu. ");
INSERT INTO mni_vpl VALUES ("AC5_36","074_5_36","ACT","5","36","36","Matam kharagi mamangda masabu athoiba misakni haijaba Theudas thoraklammi aduga mi chamarimukna mahakki tung illammi. Adubu mahak hatkhi amasung mahakki tung-inba pumnamak ichai chaithokkhi aduga mahakki ihou adu mutkhi. ");
INSERT INTO mni_vpl VALUES ("AC5_37","074_5_37","ACT","5","37","37","Mahakki tungda, mikok thibagi matamda Galilee-dagi Judas thoraktuna mahakna mi mayam amabu chingkhi. Mahaksu hatkhi aduga mahakki tung-inba pumnamak ichai chaikhaikhi. ");
INSERT INTO mni_vpl VALUES ("AC5_38","074_5_38","ACT","5","38","38","Maram asina houjikki phibham asida eina nakhoida hairi, mising asida yetlunu! Makhoi thadokkho. Maramdi makhoigi thourang nattraga thabak asi mioibadagi hourakpa oirabadi madu mangkhigani. ");
INSERT INTO mni_vpl VALUES ("AC5_39","074_5_39","ACT","5","39","39","Adubu madu Tengbang Mapudagi oirabadi nakhoina mising asi thingba ngamloi, nakhoina Tengban Mapugi maiyokta leppa oina thokkani.” Gamaliel-gi paotak adu makhoina loure. ");
INSERT INTO mni_vpl VALUES ("AC5_40","074_5_40","ACT","5","40","40","Makhoina pakhonchatpasingbu kousillaga phuhalle aduga Jisugi ming sijinnaduna amuk hanna ngangdanaba yathang piraga makhoibu thadokle. ");
INSERT INTO mni_vpl VALUES ("AC5_41","074_5_41","ACT","5","41","41","Pakhonchatpasing aduna haraona Sanhedrin-dagi thorakkhi maramdi Jisugi minggidamak ikaiba khaangbagi awaba nangba matik chai haina Tengbang Mapuna makhoibu singthanabire. ");
INSERT INTO mni_vpl VALUES ("AC5_42","074_5_42","ACT","5","42","42","Aduga numit khudinggi Mapugi Sanglen-gi sumangda amadi yumthong yumthongda chattuna Jisudi Christta aduni haiduna tambiba amadi sandokpa leplamde. ");
INSERT INTO mni_vpl VALUES ("AC6_1","074_6_1","ACT","6","1","1","Matam aduda tung-inbasinggi masing asum yamkhatlaklabada, Greek lon ngangba Jihudisingna Hebrew lon ngangba Jihudisinggi mathakta pendaba haibadi makhoigi lukhrabisingbu chana-thaknaba yenthokpada thouoibide haibagi wakat thanggatlammi. ");
INSERT INTO mni_vpl VALUES ("AC6_2","074_6_2","ACT","6","2","2","Maram asina pakhonchatpa taranithoi aduna thajaba makhoi pumnamak kouraga hairak-i, “Chana-thaknabagi thougal tounabagidamak eikhoina Tengbang Mapugi wa sandokpa thouoidaba chumloi. ");
INSERT INTO mni_vpl VALUES ("AC6_3","074_6_3","ACT","6","3","3","Ichil-inaosa, eikhoina thabak asi sinnanaba nakhoigi naraktagi Thawai Asengbana amadi lousingna thanba mioi taret khandok-u. ");
INSERT INTO mni_vpl VALUES ("AC6_4","074_6_4","ACT","6","4","4","Aduga eikhoidi haijabada amadi Tengbang Mapugi wa thougal toubada eikhoigi matam pumnamak pige.” ");
INSERT INTO mni_vpl VALUES ("AC6_5","074_6_5","ACT","6","5","5","Hairiba wapham asida makhoi loina pellammi. Aduna thajaba amadi Thawai Asengbana thanba Stephen-bu makhoina khandokle aduga Philip, Procorus, Nicanor, Timon, Parmenas amadi Antioch-tagi Jihudi lainingda ollaklaba Nicolas-su khandokle. ");
INSERT INTO mni_vpl VALUES ("AC6_6","074_6_6","ACT","6","6","6","Makhoina hairiba nupasing asi pakhonchatpasinggi maphamda purakle aduga pakhonchatpasingna makhoigidamak haijabirammi amadi makhoigi mathakta khut thambirammi. ");
INSERT INTO mni_vpl VALUES ("AC6_7","074_6_7","ACT","6","7","7","Maram aduna Tengbang Mapugi wa makha tana leptana sandoklammi. Jerusalem-da tung-inbasinggi masing asum yamna hen-gatlaklammi aduga purohit mayam amasu thajaba asi lousillammi. ");
INSERT INTO mni_vpl VALUES ("AC6_8","074_6_8","ACT","6","8","8","Tengbang Mapugi thoujal amadi panggalna thallaba Stephen-na misinggi marakta achouba angakpa thabaksing amadi khudamsing tourammi. ");
INSERT INTO mni_vpl VALUES ("AC6_9","074_6_9","ACT","6","9","9","Adubu Cyrene amadi Alexandria-dagi Jihudising yaoba Ningtamlaba Misinggi synagogue haina kounaba adugi mising kharana mahakki maiyokta leplammi. Makhoi amadi Cilicia amasung Asia lamdamsinggi Jihudisingna Stephen-da marei yetnaba hourammi. ");
INSERT INTO mni_vpl VALUES ("AC6_10","074_6_10","ACT","6","10","10","Adubu Stephen-na ngangba matamda Thawaina pibiba lousing adugi maiyokta makhoina leppa ngamlamde. ");
INSERT INTO mni_vpl VALUES ("AC6_11","074_6_11","ACT","6","11","11","Maram aduna makhoina mi kharabu insinduna asumna haihallak-i, “Mahakna Moses amadi Tengbang Mapugi maiyokta thina ngangba eikhoina tare” ");
INSERT INTO mni_vpl VALUES ("AC6_12","074_6_12","ACT","6","12","12","Asumna makhoina mising, ahal-lamansing amadi Wayel Yathanggi ojasingbu irang houhallammi. Adudagi makhoina Stephen-bu pharaga Sanhedrin-gi mangda purakle. ");
INSERT INTO mni_vpl VALUES ("AC6_13","074_6_13","ACT","6","13","13","Makhoina mahakki maramda aranba sakhi pihannanaba mi khara purakle. Makhoina hairak-i, “Mi asina eikhoigi asengba Mapugi Sanglen amadi Wayel Yathanggi maiyokta ngangba tokpa leite. ");
INSERT INTO mni_vpl VALUES ("AC6_14","074_6_14","ACT","6","14","14","Nazareth-ki Jisuna Mapugi Sanglen asi thugaigani amadi Moses-na eikhoida pibiramba chatnabising adu mahakna honghan-gani haina haiba eikhoina tare.” ");
INSERT INTO mni_vpl VALUES ("AC6_15","074_6_15","ACT","6","15","15","Sanhedrin aduda phamliba pumnamakna Stephen-da munna yenglammi aduga mahakki maithong adu swargadut amagi maithonggum urami. ");
INSERT INTO mni_vpl VALUES ("AC7_1","074_7_1","ACT","7","1","1","Adudagi Purohitlenna Stephen-da hanglak-i, “Nangonda siriba maralsing asi achumbra?” ");
INSERT INTO mni_vpl VALUES ("AC7_2","074_7_2","ACT","7","2","2","Maduda Stephen-na khumlak-i, “Eigi ichil-inaosa amadi ipa ipansa, eina haijaba tabiyu! Eikhoigi ipa ipu oiriba Abraham-na Haran-da leitringei, Mesopotamia-da leiringeida matik mangalgi Tengban Mapuna mangonda uhanbikhi. ");
INSERT INTO mni_vpl VALUES ("AC7_3","074_7_3","ACT","7","3","3","Aduga Tengban Mapuna mangonda hairak-i, ‘Nahakki nareibak amadi nahakki mari matasingbu thadoktuna eina nangonda utpi-gadouriba leibak aduda chatlu.’ ");
INSERT INTO mni_vpl VALUES ("AC7_4","074_7_4","ACT","7","4","4","Maram aduna mahakna Chaldea machasinggi lam adu thadoklaga Haran-da leirammi. Mahakki mapa leikhidraba matungda Tengban Mapuna mahakpu nakhoina houjik leiriba mapham asida thabirakkhi. ");
INSERT INTO mni_vpl VALUES ("AC7_5","074_7_5","ACT","7","5","5","Adubu Tengban Mapuna mapham asida mangonda phangpham thokpa lam machet ama phaoba pikhide, adubu matam aduda Abraham-gi macha amata leitrabasu Tengban Mapuna mangonda mapham asi mahak amadi mahakki tunggi charol surolda pibigani haina wasakpikhi. ");
INSERT INTO mni_vpl VALUES ("AC7_6","074_7_6","ACT","7","6","6","Tengban Mapuna mangonda asumna hai, ‘Nahakki charol surolna mireibakta leigani aduga mapham aduda makhoi minai oigani amadi makhoibu chahi chamari tathi-tawoina toubigani. ");
INSERT INTO mni_vpl VALUES ("AC7_7","074_7_7","ACT","7","7","7","Adubu makhoina minai oirugadaba phurup adubu eina wayen-gani amasung madugi matungda nahakki charol surolna leibak adudagi thorakkani aduga mapham asida makhoina eihakpu khurumjagani.’ ");
INSERT INTO mni_vpl VALUES ("AC7_8","074_7_8","ACT","7","8","8","Aduga Tengban Mapuna Abraham-da un-kakpagi walepnaba adu pibikhi. Maram aduna Abraham-na Isaac pokpa matung numit ni panni subada mahakpu un-kakkhi; Isaac-na mahakki machanupa Jacob-pu un-kakkhi aduga Jacob-na mahakki machanupasing aduga eikhoigi masak nairaba ipa ipusing makhoi taranithoibu un-kakkhi.” ");
INSERT INTO mni_vpl VALUES ("AC7_9","074_7_9","ACT","7","9","9","“Jacob-ki machasing aduna makhoigi machin manao oiriba Joseph-pu kallakpadagi mahakpu Egypt-ta minai oina yonkhi. Adubu Tengban Mapuna mahakpu loinabikhi ");
INSERT INTO mni_vpl VALUES ("AC7_10","074_7_10","ACT","7","10","10","aduga mahakki khudongthiba awa-ana pumnamaktagi Tengban Mapuna mahakpu kanbikhi. Egypt ningthougi mamangda Joseph-na leppa matamda Tengban Mapuna mangonda changkhonba matou amasung lousing pibirammi adudagi ningthou aduna Joseph-pu Egypt leibak amadi konung apumbagi leingak mapu oihanbikhi. ");
INSERT INTO mni_vpl VALUES ("AC7_11","074_7_11","ACT","7","11","11","Adudagi Egypt amadi Canaan-gi leibak apumbada chak tangba thoktuna yamna awa ana thoklammi. Eikhoigi ipa ipusing adu chanaba chinjak amata phanglamde. ");
INSERT INTO mni_vpl VALUES ("AC7_12","074_7_12","ACT","7","12","12","Egypt-ta chanaba mahei marong lei haiba Jacob-na tabada mahakki machanupasing haibadi eikhoigi ipa ipusing oiriba makhoibu ahanba khongchat oina mapham aduda tharammi. ");
INSERT INTO mni_vpl VALUES ("AC7_13","074_7_13","ACT","7","13","13","Anisuba khongchattadi Joseph-na mahakki machin manaosing aduda mahak kanano haiba masak khanghalle amasung Egypt-ki ningthouna Joseph-ki imung manunggi maramda khanglaklammi. ");
INSERT INTO mni_vpl VALUES ("AC7_14","074_7_14","ACT","7","14","14","Maram aduna Joseph-na mahakki mapa Jacob-ta pao thaduna mahak amadi mahakki imung manunggi mi apumba haibadi mioi humphutara-manga adu Egypt-ta lakpinaba kourammi. ");
INSERT INTO mni_vpl VALUES ("AC7_15","074_7_15","ACT","7","15","15","Adudagi Jacob-na Egypt-ta chatlammi, mapham aduda mahak amadi mahakki machanupasing sikhi. ");
INSERT INTO mni_vpl VALUES ("AC7_16","074_7_16","ACT","7","16","16","Makhoigi hakchangsing adu Shechem tanna puraklaga Abraham-na Hamor-gi machanupasingdagi sel khara piduna leikhiba mongpham aduda leirol chankhi.” ");
INSERT INTO mni_vpl VALUES ("AC7_17","074_7_17","ACT","7","17","17","“Tengban Mapuna Abraham-da wasakpikhiba adu thunghannaba matam adu naksillaklabada Egypt-ta eikhoigi misinggi masing yamna yamkhatlakkhi. ");
INSERT INTO mni_vpl VALUES ("AC7_18","074_7_18","ACT","7","18","18","Mameithangda Joseph-ki maramda karisu khangdaba ningthou amana Egypt-ta pallammi. ");
INSERT INTO mni_vpl VALUES ("AC7_19","074_7_19","ACT","7","19","19","Mahakna eikhoigi ipa ipusingbu lounam toukhi amadi makhoigi nouna pokpa angangsingbu sinanaba namduna langthok-handuna thina toukhi. ");
INSERT INTO mni_vpl VALUES ("AC7_20","074_7_20","ACT","7","20","20","Matam aduda Moses pokkhi, mahak yamna phajaba angang ama oirammi. Mahakki mapagi yumda tha ahum yokpi thakpirammi. ");
INSERT INTO mni_vpl VALUES ("AC7_21","074_7_21","ACT","7","21","21","Mahakpu mahakki yumgi mapanda thamlabada, ningthou adugi machanupina mahakpu louduna mahak masagi machanupa oina yokkhatlakkhi. ");
INSERT INTO mni_vpl VALUES ("AC7_22","074_7_22","ACT","7","22","22","Mahakpu Egypt-ki lousing pumnamak tambikhi aduga mahak waheida amadi thabakta matik leiba mi ama oirakkhi.” ");
INSERT INTO mni_vpl VALUES ("AC7_23","074_7_23","ACT","7","23","23","“Mahak chahi niphu surammi, mahakna mahakki Israel-gi misingbu kamdouna loinabiri haiba yengge leplammi. ");
INSERT INTO mni_vpl VALUES ("AC7_24","074_7_24","ACT","7","24","24","Makhoigi maraktagi amabu Egypt-ki mi amana thina touba urammi. Maram aduna mahakna mahakpu mateng pangnaba changlammi aduga Egypt-ki mi adubu hattuna laman khumlammi. ");
INSERT INTO mni_vpl VALUES ("AC7_25","074_7_25","ACT","7","25","25","Makhoibu kanbinaba Tengban Mapuna mahakpu sijinnaribani haiba mahakki misingna khangbigani haina Moses-na khallammi adubu makhoina madu khanglamde. ");
INSERT INTO mni_vpl VALUES ("AC7_26","074_7_26","ACT","7","26","26","Mathanggi numitta Israel-gi macha ani khatnariba adu ubada makhoibu taisinnanaba hotnarammi. Mahakna hairak-i, ‘Ibungokhoi, nakhoi nachil nanaosingni. Karigi nakhoina asumna khatnaribano?’ ");
INSERT INTO mni_vpl VALUES ("AC7_27","074_7_27","ACT","7","27","27","Thina touriba mi aduna Moses-pu inthoklaga hairak-i, ‘Nahakpu eikhoigi ithakta mapu amadi wayel mapu oina kanana happage?’ ");
INSERT INTO mni_vpl VALUES ("AC7_28","074_7_28","ACT","7","28","28","‘Ngarang nangna Egypt-ki mi adu hatpagumna eibusu hatpa pamlibra?’ ");
INSERT INTO mni_vpl VALUES ("AC7_29","074_7_29","ACT","7","29","29","Moses-na masi tabada Egypt-tagi chenkhiduna Midian-gi lamda lamlanba oina leirammi. Mapham aduda machanupa ani phangkhi.” ");
INSERT INTO mni_vpl VALUES ("AC7_30","074_7_30","ACT","7","30","30","“Chahi niphu houkhraba matungda Sinai ching manakki leikanglada achakpa mongsong amagi meirilakta dut amana Moses-ta uhanbirammi. ");
INSERT INTO mni_vpl VALUES ("AC7_31","074_7_31","ACT","7","31","31","Mahakna uriba adu Moses ngaklammi, henna ningthina unaba mongsong adugi manakta changsillammi. Adubu mahakna Mapu Ibungogi khonjel tarammi: ");
INSERT INTO mni_vpl VALUES ("AC7_32","074_7_32","ACT","7","32","32","‘Eihak nahakki napa napusinggi Tengban Mapuni, Abraham, Isaac amadi Jacob-ki Tengban Mapuni.’ Maduda Moses-na kibana niklammi amadi mahakna yengbagi thouna leiramde. ");
INSERT INTO mni_vpl VALUES ("AC7_33","074_7_33","ACT","7","33","33","Adudagi MAPU IBUNGO-na mangonda hairak-i, ‘Nahakki khong-up louthok-u maramdi nahakna lepliba mapham adu asengba maphamni. ");
INSERT INTO mni_vpl VALUES ("AC7_34","074_7_34","ACT","7","34","34","Egypt-ta eigi misingbu ot neiba adu eina ure. Makhoigi naheba adu eina tare amasung makhoibu kanbinaba eihak kumtharaklabani. Houjik lak-u, eina nangbu Egypt-ta thagani.’ ” ");
INSERT INTO mni_vpl VALUES ("AC7_35","074_7_35","ACT","7","35","35","“Hairiba Moses asimakni Israel-gi misingna yakhidaba mahak adu. ‘Nahakpu eikhoigi ithakta mapu amadi wayel mapu oina kanana happage?’ haiduna makhoina mangonda hangkhi. Achakpa mongsongda uhanbikhiba dut adugi mapanna Israel-gi misinggi mathakta pannanaba amadi makhoibu ningtamhanbinaba Tengban Mapuna thabikhiba adu mahakni. ");
INSERT INTO mni_vpl VALUES ("AC7_36","074_7_36","ACT","7","36","36","Mahakna makhoibu Egypt-tagi chingbirakkhi, angakpa thabaksing amadi khudamsing Egypt-ta amasung Angangba Ipakta aduga chahi niphu lamjao lamhangda toukhi. ");
INSERT INTO mni_vpl VALUES ("AC7_37","074_7_37","ACT","7","37","37","‘Eibu thabirakpagumna Tengban Mapugi wa phongdokpiba maichou ama Tengban Mapuna thabirakkani aduga mahak nakhoigi naraktagi mi oigani’ haina Israel-gi misingda haikhiba mahak adu Moses asini. ");
INSERT INTO mni_vpl VALUES ("AC7_38","074_7_38","ACT","7","38","38","Lamjao lamhangda Israel-gi misingna punna leiba aduda leiminnaramba adu mahak asini. Mapham aduda mahak eikhoigi ipa ipusingga loinana amasung Sinai chingda mangonda wa ngangbiba dut aduga leiminnarammi aduga eikhoida pinaba Tengban Mapugi ahingba waheising adu mahakna phangjakhi.” ");
INSERT INTO mni_vpl VALUES ("AC7_39","074_7_39","ACT","7","39","39","“Adubu eikhoigi ipa ipusingna mahakna haiba illu yakhide, makhoina mahakpu inthoktuna makhoigi thamoinadi Egypt-ta amuk hankhi. ");
INSERT INTO mni_vpl VALUES ("AC7_40","074_7_40","ACT","7","40","40","Maram aduna makhoina Aaron-da hairak-i, ‘Eikhoibu chingbinaba laising sabiyu. Eikhoibu Egypt-tagi chinglakpa nupa Moses aduda kari thokkhrabano haiba eikhoina khangde.’ ");
INSERT INTO mni_vpl VALUES ("AC7_41","074_7_41","ACT","7","41","41","Matam adudani makhoina sannao ama saduna maduda iratpot katkhi aduga makhoigi khutna saba pot aduda makhoina haraokhi. ");
INSERT INTO mni_vpl VALUES ("AC7_42","074_7_42","ACT","7","42","42","Maram aduna Tengban Mapuna makhoidagi mai leithokkhiduna atiyada leiriba numit, tha amadi thawanmichaksingbu makhoina khurumnaba makhoibu thadoklammi. Tengban Mapugi wa phongdokpiba maichousinggi lairikta asumna ikhibagumbani: ‘Israel-gi misa! Lamjao lamhangda chahi niphu nakhoina sasing hattuna katkhiba adu eingonda katpa natte. ");
INSERT INTO mni_vpl VALUES ("AC7_43","074_7_43","ACT","7","43","43","Molech laigi phi-sang adu nakhoina pui, aduga nakhoigi thawanmichak lai Rephan-gi murti pui; murtising adu nakhoina khurumnaba sabani. Maram aduna eina nakhoibu Babylon-gi wangmada loi thagani.’ ” ");
INSERT INTO mni_vpl VALUES ("AC7_44","074_7_44","ACT","7","44","44","“Tengban Mapuna loinabibagi Phi-sang adu eikhoigi ipa ipusingna lamjao lamhangda makhoiga loinana thamlammi. Madu Tengban Mapuna Moses-ta haikhiba amadi Moses-ta utpikhiba mawong adugi matung inna sabani. ");
INSERT INTO mni_vpl VALUES ("AC7_45","074_7_45","ACT","7","45","45","Phi-sang adu phangjaraba matungda, Tengban Mapuna makhoigi mangda tanthokkhraba phurupsing adudagi lousinkhraba lam aduda Joshua-gi luching makhada makhoina phi-sang adu purakkhi. Aduga phi-sang adu lam aduda David-ki matam phaoba leirammi. ");
INSERT INTO mni_vpl VALUES ("AC7_46","074_7_46","ACT","7","46","46","David-na Tengban Mapugi thoujal phangjaduna Jacob-ki Tengban Mapugi leipham ama mahakna sajanabagidamak nijarammi. ");
INSERT INTO mni_vpl VALUES ("AC7_47","074_7_47","ACT","7","47","47","Adubu Ibungogidamak yum sajakhiba adu Solomon-nani.” ");
INSERT INTO mni_vpl VALUES ("AC7_48","074_7_48","ACT","7","48","48","“Adum oinamak Wangthoiraba Tengban Mapudi mioibagi khutna saba yumda leite. Tengban Mapugi wa phongdokpiba maichouna asumna haikhi, ");
INSERT INTO mni_vpl VALUES ("AC7_49","074_7_49","ACT","7","49","49","‘MAPU IBUNGO-na hai, swargadi eigi phambalni aduga malemna eigi khongnetphamni. Eigidamak nakhoina karamba yum sagadage? Nattraga eina leigada mapham kadaidano? ");
INSERT INTO mni_vpl VALUES ("AC7_50","074_7_50","ACT","7","50","50","Eigi khutna pot pumnamaksing asi semkhiba nattra?’ ” ");
INSERT INTO mni_vpl VALUES ("AC7_51","074_7_51","ACT","7","51","51","Stephen-na makha tarak-i, “Nakhoisi kayada nangak kallibano! Nakhoigi thamoidi kayada Tengban Mapu khangdaba thamoi oiriba aduga Tengban Mapugi waheida nakhoigi nana kayada kalliba! Nakhoi nakhoigi napa napusing aduga chap manei: nakhoisu matam pumbada Thawai Asengbabu yeknei! ");
INSERT INTO mni_vpl VALUES ("AC7_52","074_7_52","ACT","7","52","52","Tengban Mapugi wa phongdokpiba maichou amata nakhoigi napa napusingna ot-neikhidaba yaobra? Achumba chatpa Ibungo adu lakkani haina hanna phongdokpasing adu makhoina hatkhi. Aduga houjikti nakhoina Ibungo mahakpu pithokle amasung hatle. ");
INSERT INTO mni_vpl VALUES ("AC7_53","074_7_53","ACT","7","53","53","Swargadutsinggi mapanna piramba Tengban Mapugi wayel yathang adu nakhoina phangle adubu nakhoina madu ngakte.” ");
INSERT INTO mni_vpl VALUES ("AC7_54","074_7_54","ACT","7","54","54","Makhoina masi tabada Stephen-gi mathakta mei houna saorammi amadi maya krak krak chiklammi. ");
INSERT INTO mni_vpl VALUES ("AC7_55","074_7_55","ACT","7","55","55","Adubu Thawai Asengbana thalladuna Stephen-na swargada yengkhatle aduga Tengban Mapugi matik mangal amadi Jisuna Tengban Mapugi yet thangbada lepliba adu urammi. ");
INSERT INTO mni_vpl VALUES ("AC7_56","074_7_56","ACT","7","56","56","Maduda mahakna hairak-i, “Yeng-u, swarga hangdokpa amadi Migi Machanupa aduna Tengban Mapugi yet thangbada lepliba asi eina ujare!” ");
INSERT INTO mni_vpl VALUES ("AC7_57","074_7_57","ACT","7","57","57","Masida makhoina makhoigi manakong makhutna mensillaga akanba khonjelna laoraduna makhoi pumnamakna Stephen tamna chensillammi ");
INSERT INTO mni_vpl VALUES ("AC7_58","074_7_58","ACT","7","58","58","aduga mahakpu sahargi wangmada chingthoklaga mahakpu nungna thaba hourammi. Sakhi oiribasing aduna makhoigi maphising adu Saul kouba naha oiriba nupa amagi makhongda thamlammi. ");
INSERT INTO mni_vpl VALUES ("AC7_59","074_7_59","ACT","7","59","59","Makhoina Stephen-bu nungna tharingeida mahakna Tengban Mapuda haijarak-i, “Ibungo Jisu, eigi thawai lousinbiyu.” ");
INSERT INTO mni_vpl VALUES ("AC7_60","074_7_60","ACT","7","60","60","Adudagi mahakna khuru khudak kunduna ahouba khonjelda laorak-i, “Mapu Ibungo, pap asi makhoigi mathakta singthanabiganu.” Masi hairamlaga mahak sikhre. ");
INSERT INTO mni_vpl VALUES ("AC8_1","074_8_1","ACT","8","1","1","Stephen-bu hatpada Saul-na ayaba pikhi. Numit adumaktada Jerusalem-da leiba singlup adugi mathakta akanba ot-neiba thoklammi. Pakhonchatpasing nattana thajaba makhoi pumnamak Judea amadi Samaria-gi mapham pumnamakta ichai chaithoklammi. ");
INSERT INTO mni_vpl VALUES ("AC8_2","074_8_2","ACT","8","2","2","Tengban Mapubu chetna ningba mi kharana Stephen-bu leirol challammi amadi mahakkidamak kanna tengtharammi. ");
INSERT INTO mni_vpl VALUES ("AC8_3","074_8_3","ACT","8","3","3","Adubu Saul-na yum yumda changduna thajaba nupa nupisingbu chingthoklaga keisumsangda thamjinduna singluppu manghanba hotnarammi. ");
INSERT INTO mni_vpl VALUES ("AC8_4","074_8_4","ACT","8","4","4","Chaithokkhraba thajabasing aduna makhoina chatpa chatpa mapham khudingda Tengban Mapugi wa sandoklammi. ");
INSERT INTO mni_vpl VALUES ("AC8_5","074_8_5","ACT","8","5","5","Philip-na Samaria-gi sahar amada chatlammi aduga mapham adugi misingda Christtagi maramda sandoklammi. ");
INSERT INTO mni_vpl VALUES ("AC8_6","074_8_6","ACT","8","6","6","Miyam aduna Philip-ki wa tabada amadi mahakna touba angakpa khudamsing adu ubada mahakna haiba wa aduda makhoi pukning changna tarammi. ");
INSERT INTO mni_vpl VALUES ("AC8_7","074_8_7","ACT","8","7","7","Phattaba thawaisingna mi kayadagi ahouba khonjel laoduna thoraklammi pangthaduna naba kaya amadi khong tekpa kaya ama pharammi. ");
INSERT INTO mni_vpl VALUES ("AC8_8","074_8_8","ACT","8","8","8","Maram aduna sahar aduda yamna haraorammi. ");
INSERT INTO mni_vpl VALUES ("AC8_9","074_8_9","ACT","8","9","9","Mapham aduda Simon kouba nupa ama leirammi, mahakna matam khara hikap-yaikap touduna Samaria-gi misingbu ngak-hallammi. Mahakna masabu athoiba mi amani haiduna chaothokcharammi. ");
INSERT INTO mni_vpl VALUES ("AC8_10","074_8_10","ACT","8","10","10","Aduga sahar adugi achou pisak mi pumnamakna mahakna haiba wa pukning changna tarammi. Makhoina hairak-i, “Mahak asi ‘Thoihellaba Panggal’ kouba Tengban Mapugi panggal aduni.” ");
INSERT INTO mni_vpl VALUES ("AC8_11","074_8_11","ACT","8","11","11","Matam kuina mahakna mahakki hikap-yeikapna makhoibu ngak-hanbagi maramna makhoina mahakki matung illammi. ");
INSERT INTO mni_vpl VALUES ("AC8_12","074_8_12","ACT","8","12","12","Adubu Philip-na Tengban Mapugi leibakki amadi Jisu Christtagi maramda sandokpa aphaba pao adu makhoina thajaduna nupa nupi animak yaona makhoi baptize lourammi. ");
INSERT INTO mni_vpl VALUES ("AC8_13","074_8_13","ACT","8","13","13","Simon masamaksu thajaduna baptize lourammi. Philip-na chatpa mapham khuding mahak matung illammi amasung mahakna angakpa khudamsing amadi angakpa thabaksing adu ubada ngaklammi. ");
INSERT INTO mni_vpl VALUES ("AC8_14","074_8_14","ACT","8","14","14","Samaria-gi misingna Tengban Mapugi wa lousille haiba tabada Jerusalem-da leiba pakhonchatpasingna Peter amadi John-bu makhoigi manakta tharammi. ");
INSERT INTO mni_vpl VALUES ("AC8_15","074_8_15","ACT","8","15","15","Makhoina thunglabada thajabasing adu Thawai Asengba phangnanaba makhoigidamak haijabirammi. ");
INSERT INTO mni_vpl VALUES ("AC8_16","074_8_16","ACT","8","16","16","Maramdi Thawai Asengbana makhoi kana amatagi mathakta laklamdri; makhoidi Ibungo Jisugi mingda baptize toubatani. ");
INSERT INTO mni_vpl VALUES ("AC8_17","074_8_17","ACT","8","17","17","Adudagi Peter amadi John-na makhoigi mathakta khut thambirammi amasung makhoina Thawai Asengba phangjarammi. ");
INSERT INTO mni_vpl VALUES ("AC8_18","074_8_18","ACT","8","18","18","Pakhonchatpasingna makhoigi mathakta khut thambibada Thawai Asengba pibiba adu Simon-na ubada mahakna makhoida sel kattuna ");
INSERT INTO mni_vpl VALUES ("AC8_19","074_8_19","ACT","8","19","19","hairak-i, “Eina khut thamba mi khudingmakna Thawai Asengba phangnanaba matik adu eingondasu pibiyu.” ");
INSERT INTO mni_vpl VALUES ("AC8_20","074_8_20","ACT","8","20","20","Maduda Peter-na mangonda khumlak-i, “Selna Tengban Mapugi khudolbu leiba yai haina nahakna khanba maram asina nahakki sel nahakka loinana mangba oisanu! ");
INSERT INTO mni_vpl VALUES ("AC8_21","074_8_21","ACT","8","21","21","Eikhoigi thabak asida nahakki saruk amadi thoudang amata yaode maramdi Tengban Mapugi mangda nahakki thamoi adu chumde. ");
INSERT INTO mni_vpl VALUES ("AC8_22","074_8_22","ACT","8","22","22","Phattaba asidagi nahak pukning hong-u aduga nahakki thamoida adugumba wakhal leiba adugidamak Mapu Ibungoda haijou adu oirabadi nahakpu kokpiba yai. ");
INSERT INTO mni_vpl VALUES ("AC8_23","074_8_23","ACT","8","23","23","Nahak kalakpana thalle amadi ayol aranna pulle haiba eina u-i.” ");
INSERT INTO mni_vpl VALUES ("AC8_24","074_8_24","ACT","8","24","24","Maduda Simon-na Peter amadi John-da hairak-i, “Nakhoina haikhibasing adu ithakta tadanaba eigidamak Mapu Ibungoda haijabiyu.” ");
INSERT INTO mni_vpl VALUES ("AC8_25","074_8_25","ACT","8","25","25","Makhoina sakhi piraba amadi Mapu Ibungogi wa adu sandoklaba matungda Peter amadi John Samaria-gi khun kayada Aphaba Pao sandok sandokna Jerusalem tanna hallammi. ");
INSERT INTO mni_vpl VALUES ("AC8_26","074_8_26","ACT","8","26","26","Mapu Ibungogi swargadut amana Philip-ta hairak-i, “Kha pangna Jerusalem-dagi Gaza taba leikanglagi lambi aduda chatlu.” (Houjikti lambi asi sijinnadre.) ");
INSERT INTO mni_vpl VALUES ("AC8_27","074_8_27","ACT","8","27","27","Maram aduna mahakna chatpa hourammi, mahakki khongchat manungda Ethopia-gi leimarembi Candace-gi lan-thum pumnamak panaba masa onba maru-oiba phamnaiba ama thengnarammi. Mahak Jerusalem-da Tengban Mapubu khurumjaba chatlubani. ");
INSERT INTO mni_vpl VALUES ("AC8_28","074_8_28","ACT","8","28","28","Aduga mahakna mayum hallakpagi lambida mahakki sagol gari mathakta phamduna Tengban Mapugi wa phongdokpa maichou Isaiah-gi lairik adu paduna leirammi. ");
INSERT INTO mni_vpl VALUES ("AC8_29","074_8_29","ACT","8","29","29","Maduda Thawai Asengbana Philip-ta hairak-i, “Sagol gari adugi manakta changsillaga leiyu.” ");
INSERT INTO mni_vpl VALUES ("AC8_30","074_8_30","ACT","8","30","30","Adudagi Philip-na sagol gari adugi manakta chensillammi aduga mahakna maichou Isaiah-gi lairik pariba adu tare. Maduda Philip-na mangonda hanglak-i, “Nahakna pariba adu khangba ngambra?” ");
INSERT INTO mni_vpl VALUES ("AC8_31","074_8_31","ACT","8","31","31","Mahakna khumlak-i, “Kanagumba amana eingonda takpidrabadi karamna khanggani?” Maram aduna mahakna Philip-pu sagol gari mathakta kakhatlaga mahakka phamminnanaba haijarammi. ");
INSERT INTO mni_vpl VALUES ("AC8_32","074_8_32","ACT","8","32","32","Mahakna pariba Mapugi puya adugi saruk adu asini: “Sa hatphamda puba yaogum Ibungobu chingle, yao machana magi matu kakpagi mangda tumin leibagumna Ibungona wa ngangkhide. ");
INSERT INTO mni_vpl VALUES ("AC8_33","074_8_33","ACT","8","33","33","Ibungobu ikaiba pire amadi Ibungoda achumba wayel phanghandre. Kananasu Ibungogi mirolgi maramda haiba ngamlaroi, maramdi Ibungogi thawai malemdagi louthokkhre.” ");
INSERT INTO mni_vpl VALUES ("AC8_34","074_8_34","ACT","8","34","34","Phamnaiba aduna Philip-ta hanglak-i, “Maichou asina kanagi maramda hairibano? Mahak masagi maramdara nattraga kanagumba amagi maramdara?” ");
INSERT INTO mni_vpl VALUES ("AC8_35","074_8_35","ACT","8","35","35","Adudagi Philip-na puyagi mapham asidagi houraga mangonda Jisugi maramgi Aphaba Pao adu sandoklammi. ");
INSERT INTO mni_vpl VALUES ("AC8_36","074_8_36","ACT","8","36","36","Makhoina lam aduda asum lakpada ising leiba mapham ama youraklammi maduda phamnaiba aduna hairak-i, “Mapham asida ising khara leire. Eibu baptize toubibada kari apanba leibage?” ");
INSERT INTO mni_vpl VALUES ("AC8_37","074_8_37","ACT","8","37","37","Maduda Philip-na mangonda hairak-i, “Nahakna nahakki thamoi pumnamak yaona thajarabadi yai.” Maduda mahakna khumlak-i, “Tengban Mapugi Machanupa adu Jisu Christtani haiba eina thajei.” ");
INSERT INTO mni_vpl VALUES ("AC8_38","074_8_38","ACT","8","38","38","Phamnaiba aduna sagol gari adu lepnaba yathang pirammi aduga makhoi ani haibadi Philip amadi phamnaiba aduna isingda kumtharammi aduga Philip-na mahakpu baptize toubire. ");
INSERT INTO mni_vpl VALUES ("AC8_39","074_8_39","ACT","8","39","39","Makhoina isingdagi kakhatlakpa matamda Mapu Ibungogi Thawaina Philip-pu khanghoudana puthokkhre aduga phamnaiba aduna mahakpu ukhidre adubu mahak haraona chatkhi. ");
INSERT INTO mni_vpl VALUES ("AC8_40","074_8_40","ACT","8","40","40","Adubu Philip masamak Azotus-ta leire haiba khangle mahakna Caesarea youdriphaoba mahakna lakpada sahar pumnamakta Aphaba Pao sandoklammi. ");
INSERT INTO mni_vpl VALUES ("AC9_1","074_9_1","ACT","9","1","1","Matam aduda Saul-na Ibungogi tung-inbasingbu hatkani haibagi kihanba adu makha tana chattharammi. Mahakna Purohitlen-gi manakta chatlammi ");
INSERT INTO mni_vpl VALUES ("AC9_2","074_9_2","ACT","9","2","2","aduga Mapu Ibungogi Lambi adugi matung-inbasingbu karigumba mahakna phanglabadi nupa oirabasu nupi oirabasu phaduna Jerusalem-da purakpa yanaba mangondagi Damascus-ki synagogue-singda i-ba chithising pibinaba nirammi. ");
INSERT INTO mni_vpl VALUES ("AC9_3","074_9_3","ACT","9","3","3","Saul-na asum lakpada mahakna Damascus naksallaklabada khanghoudana swargadagi mangal amana mahakki akoibada ngallammi. ");
INSERT INTO mni_vpl VALUES ("AC9_4","074_9_4","ACT","9","4","4","Maduda mahak leimaida turammi aduga “Saul, Saul! Karigi nahakna eibu ot-neiribano?” haiba khonjel ama mahakna tare. ");
INSERT INTO mni_vpl VALUES ("AC9_5","074_9_5","ACT","9","5","5","Aduga mahakna hanglak-i, “Ibungo, nahak kanano?” Khonjel aduna khumlak-i, “Eidi nahakna ot-neiriba Jisu aduni; tingkhangda nakhongna kaoba asi nahakkidamak awabani.” ");
INSERT INTO mni_vpl VALUES ("AC9_6","074_9_6","ACT","9","6","6","Maduda mahak niklammi amadi ngakladuna hairak-i, “Ibungo, ei kari toujou haibage?” Maduda Ibungona mangonda hairak-i, “Hougattuna sahar aduda chang-u, aduga nahakna kari tougadage haibadu mapham aduda nangonda haigani.” ");
INSERT INTO mni_vpl VALUES ("AC9_7","074_9_7","ACT","9","7","7","Saul-ga chatminnariba mising adu wa amata ngangdana leptuna leirammi, makhoina khonjel adudi tarammi adubu kana amatadi uramde. ");
INSERT INTO mni_vpl VALUES ("AC9_8","074_9_8","ACT","9","8","8","Saul-na leimaidagi hougatle aduga mahakna mamit pangthokpada kari amata uba ngamdre. Maram aduna makhoina mahakpu Damascus tanna khut sambiduna puraklammi. ");
INSERT INTO mni_vpl VALUES ("AC9_9","074_9_9","ACT","9","9","9","Mahak numit humni uba ngamdana amadi karigumba amata chada thaktana leirammi. ");
INSERT INTO mni_vpl VALUES ("AC9_10","074_9_10","ACT","9","10","10","Damascus-ta Ananias kouba thajaba nupa ama leirammi. Mapu Ibungona mangonda uhanbiduna hairak-i, “Ananias!” Maduda mahakna khumlak-i, “Takpiyu, Ibungo.” ");
INSERT INTO mni_vpl VALUES ("AC9_11","074_9_11","ACT","9","11","11","Mapu Ibungona mangonda hairak-i, “Hougatlu, aduga Achumba kouba lambi aduda chatlu amasung Judas-ki yumda Saul kouba Tarsus-tagi nupa amabu hang-u maramdi mahak houjik haijaduna leiri. ");
INSERT INTO mni_vpl VALUES ("AC9_12","074_9_12","ACT","9","12","12","Uhanbiba amada Ananias kouba nupa ama laktuna mahakpu amuk ujaba phangnaba mahakki mathakta khut thambiba mahakna ure.” ");
INSERT INTO mni_vpl VALUES ("AC9_13","074_9_13","ACT","9","13","13","Maduda Ananias-na khumlak-i, “Ibungo, nupa asina Jerusalem-da leiba Ibungogi misingda phattaba kaya toukhibagi maramda mi kayadagi eina tajare. ");
INSERT INTO mni_vpl VALUES ("AC9_14","074_9_14","ACT","9","14","14","Aduga mahakna mapham asida Ibungogi mingbu koujabasing phananaba athoiba purohitsingdagi ayabaga loinana lakpani.” ");
INSERT INTO mni_vpl VALUES ("AC9_15","074_9_15","ACT","9","15","15","Maduda Ibungona mangonda hairak-i, “Chatlu, maramdi Jihudi nattaba phurupsingda amadi makhoigi ningthousing amasung Israel-gi misingda eigi mingbu khanghannaba eina mahakpu khandoklabani. ");
INSERT INTO mni_vpl VALUES ("AC9_16","074_9_16","ACT","9","16","16","Mahakna eigidamak kayamuk awaba khanggadage haiba eina mangonda utkani.” ");
INSERT INTO mni_vpl VALUES ("AC9_17","074_9_17","ACT","9","17","17","Maram aduna Ananias-na Saul-na leiba yum aduda changlaga mahakki mathakta khut thambiraga hairak-i, “Ichil inao Saul, nahak amuk uba phangnaba amadi Thawai Asengbana thannanaba nahakna lakpa lambida nangonda uhanbikhiba Ibungo Jisuna eibu thabirakpani.” ");
INSERT INTO mni_vpl VALUES ("AC9_18","074_9_18","ACT","9","18","18","Khudak adumaktada Saul-gi mittagi ngagi makugumba karigumba khara tarakkhi aduga mahak amuk uba phangjare. Adudagi mahakna hougattuna baptize loujakhi. ");
INSERT INTO mni_vpl VALUES ("AC9_19","074_9_19","ACT","9","19","19","Adudagi mahakna chanaba karigumba khara charaba matungda mahak kankhatlakkhi. Saul-na numit khara Damascus-ta thajabasingga loinana leiminarammi. ");
INSERT INTO mni_vpl VALUES ("AC9_20","074_9_20","ACT","9","20","20","Khudak adudagi mahakna Jisudi Tengban Mapugi Machanupani haina synagogue-singda sandokpa hourammi. ");
INSERT INTO mni_vpl VALUES ("AC9_21","074_9_21","ACT","9","21","21","Mahakki wa taba mi khudingmakna ngakladuna hangnarak-i, “Jisugi mingda koujaba Jerusalem-da leiba misingbu awaba yamna nanghankhiba mi adu nupa asi nattra? Aduga makhoibu pharaga athoiba purohitsingda punaba mahak mapham asida lakpa nattra?” ");
INSERT INTO mni_vpl VALUES ("AC9_22","074_9_22","ACT","9","22","22","Adubu Saul-na sandokpa adu henna henna panggal kankhatlaklammi amasung Jisudi Christta aduni haina mahakna praman piba aduda Damascus-ta leiba Jihudingna khumba ngamlamde. ");
INSERT INTO mni_vpl VALUES ("AC9_23","074_9_23","ACT","9","23","23","Numit kayani houkhraba matungda Jihudisingna Saul-bu hatnanaba sarou sillammi ");
INSERT INTO mni_vpl VALUES ("AC9_24","074_9_24","ACT","9","24","24","adubu makhoigi sarou sinba adu Saul-na khanglaklammi. Ahing nungthil animakta makhoina mahakpu hatnanaba sahar adugi thongjaosingda sangduna leirammi. ");
INSERT INTO mni_vpl VALUES ("AC9_25","074_9_25","ACT","9","25","25","Adubu nongma ahing amada mahakki tung-inbasingna mahakpu puraga achouba thumok amada haplaga sahar adugi chekpaldagi tapna tapna thadaraklammi. ");
INSERT INTO mni_vpl VALUES ("AC9_26","074_9_26","ACT","9","26","26","Saul-na Jerusalem-da laklabada, mahakna thajabasingga tinnajanaba hotnarammi adubu mahak tung-inba ama oire haiba makhoina thajadaduna makhoi pumnamakna mahakpu kirammi. ");
INSERT INTO mni_vpl VALUES ("AC9_27","074_9_27","ACT","9","27","27","Adubu Barnabas-na Saul-bu pakhonchatpasinggi manakta puraklammi aduga matou karamna Damascus chatpagi lambida Ibungobu mahakna ujakhiba amadi Ibungona mangonda wa ngangbikhiba amasung Damascus-ta mahakna Jisugi mingda thouna phana sandokkhibasing adu makhoida tamlammi. ");
INSERT INTO mni_vpl VALUES ("AC9_28","074_9_28","ACT","9","28","28","Maram aduna Saul-na makhoiga leiminnare aduga Jerusalem-gi mapham pumnamakta chattuna Ibungogi mingda thouna phana sandoklammi. ");
INSERT INTO mni_vpl VALUES ("AC9_29","074_9_29","ACT","9","29","29","Mahakna Greek lon ngangba Jihudisinggasu ngangnaduna yetnakhi adubu makhoina mahakpu hatnaba hotnarammi. ");
INSERT INTO mni_vpl VALUES ("AC9_30","074_9_30","ACT","9","30","30","Thajabasingna madu khanglaklabada makhoina Saul-bu Caesarea-da puraga Tarsus-ta tharammi. ");
INSERT INTO mni_vpl VALUES ("AC9_31","074_9_31","ACT","9","31","31","Maram aduna Judea, Galilee amadi Samaria-da leiba singlupsingna ingthaba phanglammi. Makhoina Mapu Ibungobu kijana hingjarammi amasung Thawai Asengbagi pangbibagi mapanna kankhatlammi amadi makhoigi masing hen-gatlammi. ");
INSERT INTO mni_vpl VALUES ("AC9_32","074_9_32","ACT","9","32","32","Peter-na mapham khudingda chatlammi, nongmadi mahakna Lydda-da leiba Ibungogi misingbu unaba chatlammi. ");
INSERT INTO mni_vpl VALUES ("AC9_33","074_9_33","ACT","9","33","33","Mapham aduda pangthaduna naba Aeneas kouba nupa ama thengnare mahak chahi nipan phamungdagi thokpa ngamdana leibani. ");
INSERT INTO mni_vpl VALUES ("AC9_34","074_9_34","ACT","9","34","34","Maduda Peter-na mangonda hairak-i, “Aeneas, Jisu Christtana nahakpu phahanbire. Hougattuna nahakki phamung loisillu.” Khudak adumaktada mahak hougatlammi. ");
INSERT INTO mni_vpl VALUES ("AC9_35","074_9_35","ACT","9","35","35","Lydda amadi Sharon-da leiba mi pumnamakna mahakpu urammi aduga makhoina Mapu Ibungoda mai onsille. ");
INSERT INTO mni_vpl VALUES ("AC9_36","074_9_36","ACT","9","36","36","Joppa-da Tabitha koubi thajaba nupi ama leirammi. (Mahakki maming asi Greek londa Dorcas haibani madu handokpada “Saji” haibani.) Mahak matam pumnamakta aphaba thabak tourammi amadi lairabasingda mateng panglammi. ");
INSERT INTO mni_vpl VALUES ("AC9_37","074_9_37","ACT","9","37","37","Matam aduda mahak nabadagi sire aduga mahakki hakchang adu isingna chamthokpiraga mathak thangba kada thamlammi. ");
INSERT INTO mni_vpl VALUES ("AC9_38","074_9_38","ACT","9","38","38","Joppa asi Lydda-ga naknana leiba maramna Joppa-da leiba thajabasingna Peter-gi manakta, “Thinthadana eikhoigi i-nakta lakpiyu” haina haijarunaba mi ani tharammi. ");
INSERT INTO mni_vpl VALUES ("AC9_39","074_9_39","ACT","9","39","39","Maram aduna Peter-na hougatlaga makhoiga loinana chatminnarammi. Mahakna mapham aduda thunglabada makhoina mahakpu mathakki kada pukhatlammi. Lukhrabi pumnamakna mahakki akoibada lepladuna Dorcas-na hinglingeida tubiramba phurit amadi phirolsing adu mangonda uttuna kaplammi. ");
INSERT INTO mni_vpl VALUES ("AC9_40","074_9_40","ACT","9","40","40","Peter-na makhoi pumnamakpu ka adugi mapanda thok-hankhraga khuru khudak kunduna haijarammi. Maduda mahakna asiba nupi aduda onsillaga hairak-i, “Tabitha, hougatlu.” Maduda mahak mamit pangthokle aduga mahakna Peter-bu ubada hougattuna phamlammi. ");
INSERT INTO mni_vpl VALUES ("AC9_41","074_9_41","ACT","9","41","41","Peter-na mahakpu khut paibiduna chingkhatpiraga mahakna lukhrabising amadi thajabasing pumnamak kouraga makhoida mahakpu hingna sinnarammi. ");
INSERT INTO mni_vpl VALUES ("AC9_42","074_9_42","ACT","9","42","42","Pao asi Joppa sinba thungna sandokkhirammi aduga mi kaya amana Mapu Ibungobu thajare. ");
INSERT INTO mni_vpl VALUES ("AC9_43","074_9_43","ACT","9","43","43","Aduga numit kayamarum Peter-na Joppa-da leiba Simon kouba sawun noiba amaga leiminnarammi. ");
INSERT INTO mni_vpl VALUES ("AC10_1","074_10_1","ACT","10","1","1","“Italy-gi lanmi tenggol” haina kouba Rome lanmi chamagi luchingba Cornelius kouba nupa ama Caesarea-da leirammi. ");
INSERT INTO mni_vpl VALUES ("AC10_2","074_10_2","ACT","10","2","2","Mahak amadi mahakki imung manung pumnamak laining chetpa amadi Tengban Mapubu kina chatpa mini. Leita lairabasingda yamna pinaheiba amadi Tengban Mapuda tattana haijaba mi ama oirammi. ");
INSERT INTO mni_vpl VALUES ("AC10_3","074_10_3","ACT","10","3","3","Nongma numit yungba matung pung ahumlom taba aduwaida mangonda uhanbiba amada Tengban Mapugi dut amana mahakki manakta lakpa urammi. Aduga dut aduna mangonda hairak-i, “Cornelius.” ");
INSERT INTO mni_vpl VALUES ("AC10_4","074_10_4","ACT","10","4","4","Maduda mahakna dut aduda kina munna yenglaga hairak-i, “Ibungo, kari oirabano?” Dut aduna khumlak-i, “Nahakki haijabasing amadi chanbibagi thabaksing aduda Tengban Mapuna penbire aduga nangonda paokhum pibinaba sem sare. ");
INSERT INTO mni_vpl VALUES ("AC10_5","074_10_5","ACT","10","5","5","Houjik Joppa-da mi thaduna Simon Peter kouba nupa adubu kouhallu. ");
INSERT INTO mni_vpl VALUES ("AC10_6","074_10_6","ACT","10","6","6","Mahak sawun noiba Simon-gida leibani, mahakki yumna ipak mapanda leibani. Nahakna tougadaba adu mahakna hairakkani.” ");
INSERT INTO mni_vpl VALUES ("AC10_7","074_10_7","ACT","10","7","7","Masi hairamlaga dut adu chatkhre. Madudagi Cornelius-na mahakki manai ani amasung mahakpu tattana thougal touba lanmisingdagi laining chetpa mi amabu kourammi. ");
INSERT INTO mni_vpl VALUES ("AC10_8","074_10_8","ACT","10","8","8","Thokkhiba thoudok adu mahakna makhoida tamlammi aduga makhoibu Joppa-da tharammi. ");
INSERT INTO mni_vpl VALUES ("AC10_9","074_10_9","ACT","10","9","9","Mathanggi numitta makhoina asum lakpada numit yungba matam aduwaida Joppa naksillaklammi, Peter-di yumthakta haijanaba kakhatlammi. ");
INSERT INTO mni_vpl VALUES ("AC10_10","074_10_10","ACT","10","10","10","Mahak mapuk lamlakladuna karigumba khara chaninglammi; adubu makhoina chanaba thourang touringeida uhanbiba ama mahakna urammi. ");
INSERT INTO mni_vpl VALUES ("AC10_11","074_10_11","ACT","10","11","11","Swarga hangdokpa aduga apakpa phigumba ama chuthek marida kanagumbana paiba manna malemda thadaraklammi. ");
INSERT INTO mni_vpl VALUES ("AC10_12","074_10_12","ACT","10","12","12","Madugi manungda makhal pumnamakki sasing, leipakta mapukna sittuna chatpasing amadi atiyagi ucheksing yaorammi. ");
INSERT INTO mni_vpl VALUES ("AC10_13","074_10_13","ACT","10","13","13","Aduga khonjel amana mangonda hairak-i, “Hougatlu Peter, hattuna chao.” ");
INSERT INTO mni_vpl VALUES ("AC10_14","074_10_14","ACT","10","14","14","Maduda Peter-na khumlak-i, “Natte, Ibungo! Keidoungeidasu eina sengdaba amadi amaangba amata chajadri.” ");
INSERT INTO mni_vpl VALUES ("AC10_15","074_10_15","ACT","10","15","15","Khonjel aduna mangonda amuk hairak-i, “Tengban Mapuna senghanbikhraba adubu nahakna sengdabani haina hairoidabani.” ");
INSERT INTO mni_vpl VALUES ("AC10_16","074_10_16","ACT","10","16","16","Masi asumna ahumlak hanna thoklammi aduga madugi matungda apakpa phigumba adu swargada loukhatkhirammi. ");
INSERT INTO mni_vpl VALUES ("AC10_17","074_10_17","ACT","10","17","17","Uhanbiba adugi wahanthok karino haina Peter-na changaknaduna leiringeida Cornelius-na tharakpa mising aduna Simon-gi yum adu phangladuna thongganda leptuna leirammi. ");
INSERT INTO mni_vpl VALUES ("AC10_18","074_10_18","ACT","10","18","18","Makhoina kouraga Simon Peter kouba mi ama mapham aduda leibra haina hanglammi. ");
INSERT INTO mni_vpl VALUES ("AC10_19","074_10_19","ACT","10","19","19","Uhanbiba adugi maramda Peter-na khallingeida Thawai Asengbana mangonda hairak-i, “Yeng-u, mi ahumna nahakpu thiri. ");
INSERT INTO mni_vpl VALUES ("AC10_20","074_10_20","ACT","10","20","20","Aduna nahak makhada kumthou aduga nahak makhoiga chatminnabada chingnaganu maramdi eina makhoibu tharakpani.” ");
INSERT INTO mni_vpl VALUES ("AC10_21","074_10_21","ACT","10","21","21","Maram aduna Peter-na makhada kumtharaga mising aduda hairak-i, “Nakhoina thiriba mi adu eini. Nakhoi kari maramgi lakpano?” ");
INSERT INTO mni_vpl VALUES ("AC10_22","074_10_22","ACT","10","22","22","Mising aduna khumlak-i, “Lanmi chamagi mapu, Cornelius-na tharakpani. Mahak achumba chatpa amasung Tengban Mapubu kiba amadi Jihudi pumnamakna ikai khumnaba misakni. Mahakki yumda nahakpu kounaba amadi nahakki wa tanaba Tengban Mapugi dut amana mangonda takpire.” ");
INSERT INTO mni_vpl VALUES ("AC10_23","074_10_23","ACT","10","23","23","Peter-na makhoibu yum aduda kousinduna leihalle. Mathanggi numitta Peter-na makhoiga loinana chatlammi aduga Joppa-da leiba thajaba mi kharasu mahakka loinana chatpada yaorammi. ");
INSERT INTO mni_vpl VALUES ("AC10_24","074_10_24","ACT","10","24","24","Thangnaba numitta makhoi Caesarea-da thunglammi aduga mapham aduda Cornelius-na mahakki mari matasing amadi naknaba marup mapangsingga loinana makhoibu ngaiduna leirammi. ");
INSERT INTO mni_vpl VALUES ("AC10_25","074_10_25","ACT","10","25","25","Peter-na yum manungda changlakpada Cornelius-na mahakpu thengnare aduga mahakna Peter-gi khuyada tuthaduna ikai khumnarammi. ");
INSERT INTO mni_vpl VALUES ("AC10_26","074_10_26","ACT","10","26","26","Adubu Peter-na mahakpu hougatpiduna hairak-i, “Lepkhatlu, eisu mini.” ");
INSERT INTO mni_vpl VALUES ("AC10_27","074_10_27","ACT","10","27","27","Peter-na Cornelius-ka wari sana sana yum aduda changlakpada mi mayam ama punduna leiramba thengnarammi. ");
INSERT INTO mni_vpl VALUES ("AC10_28","074_10_28","ACT","10","28","28","Aduga Peter-na makhoida hairak-i, “Jihudi amana Jihudi nattaba amaga tinnaba nattraga unaba changba haibasi eikhoigi wayel kai haibasi nahakna henna khanglibani. Adubu mi kana amatabu amaangba nattraga sengdaba haina kouroidabani haiba Tengban Mapuna eingonda utpire. ");
INSERT INTO mni_vpl VALUES ("AC10_29","074_10_29","ACT","10","29","29","Maram aduna nakhoina eibu kouba lakpada eina karisu yetpa toudana laklabani. Maram aduna eina nakhoida hangjari, eibu kari maramgi koubibano?” ");
INSERT INTO mni_vpl VALUES ("AC10_30","074_10_30","ACT","10","30","30","Maduda Cornelius-na khumlak-i, “Numit humnigi mamangda pungja asimaktada, numit yungba matung pung ahum tabada eigi yumda eina haijarammi. Khanghoudana arangba phijol setpa nupa ama eigi mangda leplammi ");
INSERT INTO mni_vpl VALUES ("AC10_31","074_10_31","ACT","10","31","31","aduga eingonda hairak-i, ‘Cornelius, nahakki haijaba Tengban Mapuna tabire aduga nahakna leita lairabasingda pibibasing adu ubire. ");
INSERT INTO mni_vpl VALUES ("AC10_32","074_10_32","ACT","10","32","32","Maram aduna Joppa-da mi thaduna Simon Peter kouba nupa adubu kouhallu. Mahak ipak mapanda leiba sawun noiba Simon-gi yumda leibani.’ ");
INSERT INTO mni_vpl VALUES ("AC10_33","074_10_33","ACT","10","33","33","Maram aduna eina khudak aduda nahakpu kounaba mi thabani, nahakna lakpiba yamna phare. Houjikti Mapu Ibungona eikhoida hainaba nangonda yathang pikhiba pumnamak adu tajanaba eikhoi pumnamak Tengban Mapugi mangda leijare.” ");
INSERT INTO mni_vpl VALUES ("AC10_34","074_10_34","ACT","10","34","34","Adudagi Peter-na makhoida haiba hourak-i, “Tengban Mapuna misak mimai yengde haibasi kayada chumkhrabano haibasi houjik ei tasengna khangle. ");
INSERT INTO mni_vpl VALUES ("AC10_35","074_10_35","ACT","10","35","35","Adubu phurup khudingdagi Tengban Mapubu kiba aduga achumba touba mi adubu Ibungona yabi. ");
INSERT INTO mni_vpl VALUES ("AC10_36","074_10_36","ACT","10","36","36","Tengban Mapuna Israel-gi misingda thabiba paojel adu nakhoina khang-i, pumnamakki Mapu Ibungo Jisu Christtagi mapanna ingthabagi Aphaba Pao adu laothokpani. ");
INSERT INTO mni_vpl VALUES ("AC10_37","074_10_37","ACT","10","37","37","John-na baptize toubagi maramda sandoklaba matungda Galilee-dagi houraga Judea-gi mapham pumnamakta thokkhiba thoudok adu nakhoina khang-i. ");
INSERT INTO mni_vpl VALUES ("AC10_38","074_10_38","ACT","10","38","38","Nazareth-ki Jisugi maramda amasung karamna Tengban Mapuna Ibungo mahakki mathakta Thawai Asengba amadi panggal heithabikhiba haibadu nakhoina khang-i. Mahakna mapham khudingda chattuna aphaba touduna amadi Satan-gi panggalgi makhada leiba makhoi pumnamakpu anaba phahanbikhi, maramdi Tengban Mapuna mahakka loinabirammi. ");
INSERT INTO mni_vpl VALUES ("AC10_39","074_10_39","ACT","10","39","39","Ibungo mahakna Jihudisinggi lamda amadi Jerusalem-da toukhiba pumnamak adugi eikhoina sakhini. Makhoina Ibungobu cross-ta yotpi thaduna hatkhi. ");
INSERT INTO mni_vpl VALUES ("AC10_40","074_10_40","ACT","10","40","40","Adubu Tengban Mapuna Ibungobu numit humni subada asibadagi hinggat-hanbiduna phongdokpire. ");
INSERT INTO mni_vpl VALUES ("AC10_41","074_10_41","ACT","10","41","41","Mi pumnamakna Ibungobu ukhiba natte adubu Ibungogi maramda misingda sakhi pinaba Tengban Mapuna mangjounana khandokpikhraba eikhoi haibadi Ibungona sibadagi hinggatlaba matungda Ibungoga chamin thakminnakhiba eikhoina ukhi. ");
INSERT INTO mni_vpl VALUES ("AC10_42","074_10_42","ACT","10","42","42","Aphaba Pao sandoknaba amasung Ibungo Jisubu Tengban Mapuna ahingba amadi asibasinggi wayel mapu oina khalle haiba sakhi pinanaba Ishworna eikhoida yangthang pibire. ");
INSERT INTO mni_vpl VALUES ("AC10_43","074_10_43","ACT","10","43","43","Tengban Mapugi wa phongdokpiba maichousingna Ibungo mahakki maramda haikhi madudi Ibungobu thajaba mi khudingna Ibungogi minggi mapanna pap kokchaba phangjagani.” ");
INSERT INTO mni_vpl VALUES ("AC10_44","074_10_44","ACT","10","44","44","Peter-na wasing asi nganglingeida wa adu tariba mi pumnamakki mathakta Thawai Asengbana lengthabiraklammi. ");
INSERT INTO mni_vpl VALUES ("AC10_45","074_10_45","ACT","10","45","45","Jihudi nattabasinggi mathakta Tengban Mapuna mahakki khudol Thawai Asengbabu heithabiba adu ubada Peter-ga Joppa-dagi lakminnaba thajaba Jihudising aduna ngaklammi. ");
INSERT INTO mni_vpl VALUES ("AC10_46","074_10_46","ACT","10","46","46","Maramdi makhoina atoppa lon ngangba amadi Tengban Mapubu thagatpa adu makhoina tarammi. Maduda Peter-na hairak-i, ");
INSERT INTO mni_vpl VALUES ("AC10_47","074_10_47","ACT","10","47","47","“Eikhoina Thawai Asengba phangbagumna makhoinasu phangle. Adu oirabadi makhoina isingda baptize louba kanana thingba ngamgani.” ");
INSERT INTO mni_vpl VALUES ("AC10_48","074_10_48","ACT","10","48","48","Maram aduna makhoibu Jisu Christtagi mingda baptize lounaba mahakna makhoida yathang pirammi. Aduga makhoina mahakpu numit khara leithabinaba haijarammi. ");
INSERT INTO mni_vpl VALUES ("AC11_1","074_11_1","ACT","11","1","1","Jihudi nattabasingnasu Tengban Mapugi wa lousille haiba pakhonchatpasingna amadi Judea-da leiba thajabasingna tarammi. ");
INSERT INTO mni_vpl VALUES ("AC11_2","074_11_2","ACT","11","2","2","Maram aduna Peter-na Jerusalem-da chatpada atoppa phurupsingsu un-kakkadabani haina thajabasingna mangonda yetladuna hairak-i, ");
INSERT INTO mni_vpl VALUES ("AC11_3","074_11_3","ACT","11","3","3","“Nahakna un-kaktaba migi yumda changduna makhoiga chamin thakminnei.” ");
INSERT INTO mni_vpl VALUES ("AC11_4","074_11_4","ACT","11","4","4","Maduda Peter-na thokkhiba thoudok pumnak adu ahoubadagi liba houraduna hairak-i, ");
INSERT INTO mni_vpl VALUES ("AC11_5","074_11_5","ACT","11","5","5","“Eina Joppa saharda haijaduna leiringeida uhanbiba ama urammi. Swarga hangdokpa aduga apakpa phigumba ama chuthek marida kanagumbana paiba manna swargadagi thadaraklammi aduga madu eigi inak yourakkhi. ");
INSERT INTO mni_vpl VALUES ("AC11_6","074_11_6","ACT","11","6","6","Aduga eina maduda munna yengbada malemgi makhong mari panba sasing, lamlakki sasing, mapukna sittuna chatpasing amadi atiyagi ucheksing yaoba urammi. ");
INSERT INTO mni_vpl VALUES ("AC11_7","074_11_7","ACT","11","7","7","Adudagi khonjel amana eingonda hairak-i, ‘Hougatlu Peter, hattuna chao’ ");
INSERT INTO mni_vpl VALUES ("AC11_8","074_11_8","ACT","11","8","8","Maduda eina khumkhi, ‘Natte, Ibungo! Keidoungeidasu amaangba amasung sengdaba amata eigi chinda khak changkhidri.’ ");
INSERT INTO mni_vpl VALUES ("AC11_9","074_11_9","ACT","11","9","9","Adubu khonjel aduna swargadagi amukka hairak-i, ‘Tengban Mapuna senghanbikhraba adubu nahakna sengdabani haina louroidabani.’ ");
INSERT INTO mni_vpl VALUES ("AC11_10","074_11_10","ACT","11","10","10","Madu ahumlak thokkhi aduga pumnamak adu swargada amuk chingkhatkhi. ");
INSERT INTO mni_vpl VALUES ("AC11_11","074_11_11","ACT","11","11","11","Aduga khudak adumaktada Caesarea-dagi tharakpa nupa ahumna eina leiriba yum aduda thunglare. ");
INSERT INTO mni_vpl VALUES ("AC11_12","074_11_12","ACT","11","12","12","Eina makhoiga chingnaba leitana chatminnanaba Thawai Asengbana eingonda hairammi. Ichil inao taruk asisu eiga loinana chatlammi aduga eikhoi loina Cornelius-ki yumda changlammi. ");
INSERT INTO mni_vpl VALUES ("AC11_13","074_11_13","ACT","11","13","13","Mahakna swarga dut ama mahakki yumda ukhiba adu eikhoida tamlammi aduga dut aduna mangonda hai, ‘Joppa-dagi Simon Peter kouba nupa amabu mi thaduna kouru. ");
INSERT INTO mni_vpl VALUES ("AC11_14","074_11_14","ACT","11","14","14","Nahak amadi nahakki imung pumnamak aran-khubham phangnaba mahakna nangonda wa nganggani.’ ");
INSERT INTO mni_vpl VALUES ("AC11_15","074_11_15","ACT","11","15","15","Hourakpada eikhoigi ithakta Thawai Asengbana lakpibagumna, eina wa ngangba hourakpada makhoigi mathaktasu lakpikhi. ");
INSERT INTO mni_vpl VALUES ("AC11_16","074_11_16","ACT","11","16","16","Maduda ‘John-nadi isingda baptize toubi adubu einadi nakhoibu Thawai Asengbada baptize toubigani’ haina Ibungona haikhiba wa adu eina ningsinglakkhi. ");
INSERT INTO mni_vpl VALUES ("AC11_17","074_11_17","ACT","11","17","17","Eikhoina Ibungo Jisu Christtabu thajaba matamda Tengban Mapuna eikhoida pibiba khudol adumak pibirabadi, eina kana oiduna Tengban Mapubu thinggadouribano?” ");
INSERT INTO mni_vpl VALUES ("AC11_18","074_11_18","ACT","11","18","18","Wa asi tabada makhoi tumin leire. Aduga makhoina Tengban Mapubu thagattuna hairak-i, “Tengban Mapuna Jihudi nattabasingsu hingba phangnabagi pukning hongba adu pibire.” ");
INSERT INTO mni_vpl VALUES ("AC11_19","074_11_19","ACT","11","19","19","Stephen-bu hatkhiba matamda thokkhiba ot-neiba adugi maramna Phoenicia, Cyprus, amadi Antioch tanna chaithokkhraba thajabasing aduna Jihudising khaktada Tengban Mapugi wa sandoklammi. ");
INSERT INTO mni_vpl VALUES ("AC11_20","074_11_20","ACT","11","20","20","Adubu Cyprus amadi Cyrene-dagi lakpa thajaba kharanadi Antioch-ta chattuna Greek-ki misingdasu Ibungo Jisugi maramda Aphaba Pao sandoklammi. ");
INSERT INTO mni_vpl VALUES ("AC11_21","074_11_21","ACT","11","21","21","Aduga Ibungogi panggalna makhoiga loinarammi amasung mi mayam amana thajaraktuna Mapu Ibungoda mai onsillaklammi. ");
INSERT INTO mni_vpl VALUES ("AC11_22","074_11_22","ACT","11","22","22","Pao asi Jerusalem-da leiba singlupki maphamda youraklammi maram aduna makhoina Barnabas-pu Antioch-ta tharaklammi. ");
INSERT INTO mni_vpl VALUES ("AC11_23","074_11_23","ACT","11","23","23","Mahakna thungba matamda Tengban Mapuna makhoibu yaipha thoujal pibiba adu urammi maduda mahak haraorammi aduga makhoina thajaba yana amadi thamoi sengna Ibungoda leinaba mahakna makhoida pukning thougatpirammi. ");
INSERT INTO mni_vpl VALUES ("AC11_24","074_11_24","ACT","11","24","24","Barnabas Thawai Asengbana amadi thajabana thanba aphaba mi amani. Mahakna mi kaya ama Mapu Ibungogi maphamda puraklammi. ");
INSERT INTO mni_vpl VALUES ("AC11_25","074_11_25","ACT","11","25","25","Adudagi Barnabas-na Saul-bu thiba Tarsus-ta chatlammi. ");
INSERT INTO mni_vpl VALUES ("AC11_26","074_11_26","ACT","11","26","26","Mahakna Saul-bu thengnarabada mahakpu Antioch-ta puraklammi aduga chahi ama chupna makhoi singlupka loinana tinnarammi amadi mi kaya amabu tambirammi. Antioch-ta thajabasingbu ihan hanna Christian haina koukhi. ");
INSERT INTO mni_vpl VALUES ("AC11_27","074_11_27","ACT","11","27","27","Matam asida Tengban Mapugi wa phongdokpiba maichou khara Jerusalem-dagi Antioch-ta laklammi. ");
INSERT INTO mni_vpl VALUES ("AC11_28","074_11_28","ACT","11","28","28","Makhoigi maraktagi Agabus kouba amana lepkhattuna taibangpanbagi mapham pumnamakta tamthiba chak tangba ama thokkani haina Thawaigi mapanna phongdoklammi. (Madu Claudius-na ningthourel oiba matamda thokkhi) ");
INSERT INTO mni_vpl VALUES ("AC11_29","074_11_29","ACT","11","29","29","Antioch-ta leiba thajabasingna makhoi makhoigi ngamjaba matung inna Judea-da leiba thajabasingda mateng pinanaba lepnarammi. ");
INSERT INTO mni_vpl VALUES ("AC11_30","074_11_30","ACT","11","30","30","Madumak makhoina pangthoklammi aduga makhoina khudol adu Barnabas amasung Saul-gi khuthangda singlupki ahal lamansingda tharammi. ");
INSERT INTO mni_vpl VALUES ("AC12_1","074_12_1","ACT","12","1","1","Matam aduwaida Herod Ningthouna singlupki mi kharabu ot-neiba hourammi. ");
INSERT INTO mni_vpl VALUES ("AC12_2","074_12_2","ACT","12","2","2","Mahakna John-gi mayamba Jacob-pu thangsangna kaktuna hat-hallammi. ");
INSERT INTO mni_vpl VALUES ("AC12_3","074_12_3","ACT","12","3","3","Masina Jihudisingbu pelhalli haiba Herod-na ubada mahakna Peter-busu pharammi. (Masi Hameiyaodaba Chakkhangba matamda thokkhibani.) ");
INSERT INTO mni_vpl VALUES ("AC12_4","074_12_4","ACT","12","4","4","Peter-bu pharaba matungda mahak keisumsangda thamlammi. Aduga mahakpu lanmi mari marina semba kangbu marida mahakpu ngak-sennaba sinnarammi maramdi Lanthokpibagi Chakkhangba matungda mahakna Peter-bu miyam mamangda wayennaba puthokke khallammi. ");
INSERT INTO mni_vpl VALUES ("AC12_5","074_12_5","ACT","12","5","5","Maram aduna Peter-bu keisumsangda thamlammi adubu singlupna mahakkidamak Tengban Mapugi maphamda yamna kanna haijarammi. ");
INSERT INTO mni_vpl VALUES ("AC12_6","074_12_6","ACT","12","6","6","Herod-na mahakpu puthokkadaba numit adugi mamanggi ahing aduda Peter-du lanmi anigi marakta yotli anina punduna tumlammi aduga thongngakpasingna keisumsang adugi thong adu ngak-senduna leirammi. ");
INSERT INTO mni_vpl VALUES ("AC12_7","074_12_7","ACT","12","7","7","Khanghoudana Mapu Ibungogi dut amana mapham aduda leplammi aduga mangal amana keisumsanggi mapham adu ngallammi. Dut aduna Peter-gi lengjumda nomlaga mahakpu houdoklammi aduga hairak-i, “Thuna hougatlu!” Khudak aduda yotlising adu Peter-gi makhuttagi takhi. ");
INSERT INTO mni_vpl VALUES ("AC12_8","074_12_8","ACT","12","8","8","Aduga dut aduna mangonda hairak-i. “Nahakki naphi narol setchillu amasung sandal tongsillu.” Peter-na madumak tourammi adudagi dut aduna mangonda hairak-i, “Nahakki achonba phi adu insinduna eigi itung illak-u.” ");
INSERT INTO mni_vpl VALUES ("AC12_9","074_12_9","ACT","12","9","9","Peter-na keisumsangdagi thoklaktuna mahakki matung illammi adubu dut aduna touriba adu asengbamak thoklibani haiba mahakna khanglamde, mahakna khanbadi madu uhanbiba ama mahakna ubani haina khallammi. ");
INSERT INTO mni_vpl VALUES ("AC12_10","074_12_10","ACT","12","10","10","Makhoina ahanba amasung anisuba ngaklibasing adu lanthoklammi aduga sahar adu taba yotki thongjao aduda youraklammi. Makhoigidamak thongjao adu mathanta hangdoklammi aduga makhoina madu lanthoklaga lambi amada chatlammi; aduga khudakta dut aduna mahakpu thadokkhre. ");
INSERT INTO mni_vpl VALUES ("AC12_11","074_12_11","ACT","12","11","11","Madudagi Peter-na wakhal taraktuna hairak-i, “Thoudok asi asengba thokpani haiba ei houjikti khangle. Mapu Ibungona mahakki dut thabiraktuna eibu Herod-ki khuttagi amadi Jihudisingna eingonda thok-hanningba thoudoksing adudagi kanbire.” ");
INSERT INTO mni_vpl VALUES ("AC12_12","074_12_12","ACT","12","12","12","Aduga mahakna masi khanglaklabada Mary-gi yum haibadi Mark hainasu kouba John-gi mamagi yumda mahakna laklammi. Mapham aduda mi mayam ama tinaduna haijarammi. ");
INSERT INTO mni_vpl VALUES ("AC12_13","074_12_13","ACT","12","13","13","Peter-na mapan-gi thongda thinbada Rodha koubi minai leisabi amana thong hangdoknaba thoraklammi. ");
INSERT INTO mni_vpl VALUES ("AC12_14","074_12_14","ACT","12","14","14","Mahakna Peter-gi khonjelni khangbadagi haraomanduna thong adu hangdoktana chensillaktuna makhoi pumnamakta “Peter thongjinda leptuna leire,” haina tamlammi. ");
INSERT INTO mni_vpl VALUES ("AC12_15","074_12_15","ACT","12","15","15","Maduda makhoina mangonda hairak-i, “Nahak ngaore!” Adubu madu achumbani haina mahakna kanna hairammi. Maram aduna makhoina khumlak-i, “Madu mahakki swarga dut oiramgani.” ");
INSERT INTO mni_vpl VALUES ("AC12_16","074_12_16","ACT","12","16","16","Adubu Peter-na thong adu thinduna leirammi. Makhoina thong adu hangdokpada mahakpu ure maduda makhoi ingak ngaklammi. ");
INSERT INTO mni_vpl VALUES ("AC12_17","074_12_17","ACT","12","17","17","Maduda makhoi tumin leinaba mahakna makhut hairammi aduga Mapu Ibungona mahakpu keisumsangdagi kamdouna puthokpirakpage haibadu makhoida sandokna hairammi. Aduga mahakna hairak-i, “Thoudok asi Jacob amadi ichil inao ateisingda tambiyu,” masi hairamlaga mahak atoppa mapham amada chatkhre. ");
INSERT INTO mni_vpl VALUES ("AC12_18","074_12_18","ACT","12","18","18","Nongngalakpaga Peter-da kari thokkhrabano haiduna lanmisinggi marakta yamna charangnaba thoklammi. ");
INSERT INTO mni_vpl VALUES ("AC12_19","074_12_19","ACT","12","19","19","Herod-na Peter-bu koithi thihallammi adubu mahakpu thiba phangdrabada mahakna ngaksellibasing adubu wahang paohanglaga makhoibu hatnanaba yathang pirammi. Masigi matungda Herod-na Judea thadoklaga Caesarea-da chatkhirammi aduga mapham aduda matam khara leirammi. ");
INSERT INTO mni_vpl VALUES ("AC12_20","074_12_20","ACT","12","20","20","Herod-na Tyre amadi Sidon-gi misinggi mathakta yamna saorammi maram aduna makhoi punna mahakpu unaba laklammi. Ahanbada makhoina ningthougi sanggai panaba Blastus-bu makhoigi mateng pangbinaba yahallammi. Adudagi makhoina Herod-ta changduna ingna leiminnanaba haijarammi maramdi ningthougi lamdagi makhoigi leibakki chana-thaknaba phangjarammi. ");
INSERT INTO mni_vpl VALUES ("AC12_21","074_12_21","ACT","12","21","21","Akaknaba numit amada Herod-na ningthougi oiba phijol setlaga phambalda phamduna miyamda wa nganglammi. ");
INSERT INTO mni_vpl VALUES ("AC12_22","074_12_22","ACT","12","22","22","Maduda makhoina laorak-i, “Masi migi khonjel natte laigi khonjelni.” ");
INSERT INTO mni_vpl VALUES ("AC12_23","074_12_23","ACT","12","23","23","Herod-na Tengban Mapuda matik mangal pidaba maramna khudak aduda Mapu Ibungogi dut amana mahakpu yeithure aduga mahak tinna chaduna sikhre. ");
INSERT INTO mni_vpl VALUES ("AC12_24","074_12_24","ACT","12","24","24","Adubu Tengban Mapugi wadi makha tana sandoklammi amasung nouna thajaba mi masing hen-gatlaklammi. ");
INSERT INTO mni_vpl VALUES ("AC12_25","074_12_25","ACT","12","25","25","Barnabas amadi Saul-na makhoigi tougadaba thougal adu loiraduna Mark hainasu kouba John-bu puduna Jerusalem-dagi hallaklammi. ");
INSERT INTO mni_vpl VALUES ("AC13_1","074_13_1","ACT","13","1","1","Antioch-ki Singlupta Tengban Mapugi wa phongdokpiba maichousing amadi tambiba ojasing kayamuk leirammi. Makhoising adudi Barnabas, Niger hainasu kouba Simeon, Cyrene-dagi Lucius, Manaen (Mahak Herod tetrarch-ka houminnarakpa) amadi Saul-ni. ");
INSERT INTO mni_vpl VALUES ("AC13_2","074_13_2","ACT","13","2","2","Makhoina Ibungobu khurumjaringei amadi chara hellingeida Thawai Asengbana makhoida hairak-i, “Eina makhoibu tounanaba koukhraba thabak adugidamak Barnabas amadi Saul-bu eigidamak khaidok-u.” ");
INSERT INTO mni_vpl VALUES ("AC13_3","074_13_3","ACT","13","3","3","Maram aduna makhoina chara henduna haijaraba matungda makhoigi mathakta khut thambiraga makhoibu thare. ");
INSERT INTO mni_vpl VALUES ("AC13_4","074_13_4","ACT","13","4","4","Thawai Asengbana makhoibu thabiduna makhoina Seleucia-da chatlammi aduga mapham adudagi Cyprus tanna hida chatlammi. ");
INSERT INTO mni_vpl VALUES ("AC13_5","074_13_5","ACT","13","5","5","Makhoina Salamis-ta thungba matamda Jihudisinggi Synagogue-singda chattuna Tengban Mapugi wa sandoklammi. Makhoibu mateng pangnanaba John Mark-su makhoiga loinarammi. ");
INSERT INTO mni_vpl VALUES ("AC13_6","074_13_6","ACT","13","6","6","Makhoina ithat adu phaoduna chatlaga Paphos-ta thunglammi. Mapham aduda masana masabu Tengban Mapugi wa phongdokpa maichou amani haijaba Bar-Jisu kouba hikap yaikap touba Jihudi nupa ama thengnarammi. ");
INSERT INTO mni_vpl VALUES ("AC13_7","074_13_7","ACT","13","7","7","Mahak asi ithat adugi heisinglaba leingak mapu Sergius Paulus-ka tinnabani. Leingak mapu asina Tengban Mapugi wa taningbadagi Barnabas amadi Saul-bu kourammi. ");
INSERT INTO mni_vpl VALUES ("AC13_8","074_13_8","ACT","13","8","8","Hikap yaikap touba Elymas-na (Ming asi Greek londani) makhoigi mayokta leplammi amadi leingak mapu adubu thajabadagi leithok-hannaba hotnarammi. ");
INSERT INTO mni_vpl VALUES ("AC13_9","074_13_9","ACT","13","9","9","Paul hainasu kouba Saul-na Thawai Asengbana thalladuna Elymas-ta munna yengduna hairak-i, ");
INSERT INTO mni_vpl VALUES ("AC13_10","074_13_10","ACT","13","10","10","“Nahak asi aphaba pumnamakki yeknaba amadi Devil-gi machani. Nahakti makhal-makha pumnamakki lounamba amadi marei mara pumnamakna thallaba mini. Ibungogi achumba lambising adubu serannahannaba hotnaba nahak keidounungda toklaroidra? ");
INSERT INTO mni_vpl VALUES ("AC13_11","074_13_11","ACT","13","11","11","Houjik Mapu Ibungogi khut adu nahakki maiyokta lei, nahak matam khara numitki mangal uroi.” Khudak aduda amamba leichin amana mahakki mit kupsinkhre aduga mahakpu chingbinaba kanagumba amabu phangnaba mahakna koima marammi. ");
INSERT INTO mni_vpl VALUES ("AC13_12","074_13_12","ACT","13","12","12","Thoudok adu leingak mapu aduna ubada mahak thajarammi maramdi Ibungogi maramda tambiba aduda mahak ngaklammi. ");
INSERT INTO mni_vpl VALUES ("AC13_13","074_13_13","ACT","13","13","13","Paul amadi mahakka loinabasing adu Paphos-tagi Pamphylia-gi sahar Perga-da hi tongduna laklammi. Mapham aduda John Mark-na makhoibu thadoklamlaga Jerusalem-da hankhirammi. ");
INSERT INTO mni_vpl VALUES ("AC13_14","074_13_14","ACT","13","14","14","Madudagi makhoina Perga-dagi chatkhiduna Pisidia-gi Antioch-ta thunglammi aduga Potthaba numitta synagogue-ta changduna phamtharammi. ");
INSERT INTO mni_vpl VALUES ("AC13_15","074_13_15","ACT","13","15","15","Wayel Yathang amadi Tengban Mapugi wa phongdokpiba maichousinggi lairiktagi paraba matungda synagogue-ki luchingbasing aduna makhoida pao asi pirak-i, “Ichil inaosa, misingda pukning thougatnaba wa leirabadi madu haibiyu.” ");
INSERT INTO mni_vpl VALUES ("AC13_16","074_13_16","ACT","13","16","16","Maduda Paul-na lepkhattuna mahakna haiba wa tuminna tabinaba makhut thanggatlaga hairak-i, “Israel-gi mising amadi Tengban Mapubu khurumjaba atoppa phurupki mioi pumnamak, eina haiba tabiyu! ");
INSERT INTO mni_vpl VALUES ("AC13_17","074_13_17","ACT","13","17","17","Israel phurup asigi Tengban Mapuna eikhoigi ipa ipusingbu khandokpire amadi makhoina Egypt-ta lamlanba oina leiringeida Ibungona makhoibu achouba phurup ama oihanbire aduga Ibungogi panggallaba khutna makhoibu Egypt-tagi puthokpirakle ");
INSERT INTO mni_vpl VALUES ("AC13_18","074_13_18","ACT","13","18","18","amasung chahi niphu chupna lamjao lamhanggi lamdamda Ibungona makhoigi lamchatsingbu khaangbikhi. ");
INSERT INTO mni_vpl VALUES ("AC13_19","074_13_19","ACT","13","19","19","Aduga Ibungona Canaan-gi phurup taretpu mang-hallaga makhoigi leibak adu Ibungogi misingda makhoigi lam oina pibikhi. ");
INSERT INTO mni_vpl VALUES ("AC13_20","074_13_20","ACT","13","20","20","Pumnamak asi chahi chamari yangkheirom changlammi.” “Masigi matungda Tengban Mapuna makhoida Tengban Mapugi wa phongdokpa maichou Samuel phaoba wayel mapusing pibikhi. ");
INSERT INTO mni_vpl VALUES ("AC13_21","074_13_21","ACT","13","21","21","Makhoina ningthou ama pibinaba nijabada Tengban Mapuna makhoida Benjamin salaidagi Kish-ki machanupa Saul-bu makhoigi ningthou oina pibikhi aduga mahakna chahi niphu pankhi. ");
INSERT INTO mni_vpl VALUES ("AC13_22","074_13_22","ACT","13","22","22","Adubu Tengban Mapuna Saul-bu louthoklaba matungda David-pu makhoigi ningthou oihanbikhi. Mahakki maramda Ishworna haikhiba adu asini, ‘Eina Jesse-gi machanupa eigi thamoina khoidajaba David-pu phangle, eina mahakpu touhanningba pumnamak mahakna tougani.’ ");
INSERT INTO mni_vpl VALUES ("AC13_23","074_13_23","ACT","13","23","23","Tengban Mapuna wasakpikhibagi matung-inna David-ki charol suroldagi Israel-da Kanbiba Mapu Jisubu pubirakle. ");
INSERT INTO mni_vpl VALUES ("AC13_24","074_13_24","ACT","13","24","24","Jisuna mahakki thabak houdringei mamangda John-na Israel-gi mi pumnamakta paptagi pukning hongnaba amadi baptize lounaba sandoklammi. ");
INSERT INTO mni_vpl VALUES ("AC13_25","074_13_25","ACT","13","25","25","Aduga John-na mahakki thabak loisillamdaida hairak-i, ‘Nakhoina Eihak kanani haina khanbage? Nakhoina ngairiba Ibungo mahak adu ei natte. Adubu Ibungo mahakti eigi tungda lakli, eidi Ibungo mahakki sandal mari louthokpa phaoba matik chade.’ ” ");
INSERT INTO mni_vpl VALUES ("AC13_26","074_13_26","ACT","13","26","26","“Abraham-gi charol surol oiriba ichil inaosa amadi Tengban Mapubu khurumjaba atoppa phurupki mioi pumnamak, aran-khubhamgi paojel asi eikhoida thabirakle. ");
INSERT INTO mni_vpl VALUES ("AC13_27","074_13_27","ACT","13","27","27","Jerusalem-gi mising amadi makhoigi luchingbasingna Jisubu Kanbiba Mapuni haiba khanglamde aduga Potthaba numit khudingda paba Tengban Mapugi wa phongdokpiba maichousinggi wa adusu khanglamde. Adubu makhoina Ibungoda maral theijinduna maichousing adugi wa adu thung-halle. ");
INSERT INTO mni_vpl VALUES ("AC13_28","074_13_28","ACT","13","28","28","Makhoina Ibungobu hatnanaba maram phangdrabasu, Ibungobu hatnanaba Pilate-ta haijakhi. ");
INSERT INTO mni_vpl VALUES ("AC13_29","074_13_29","ACT","13","29","29","Mapugi Puyada ikhiba Ibungogi maram khudingmak makhoina pangthoklabada makhoina Ibungobu cross-tagi loutharaga mongpham amagi manungda thamkhi. ");
INSERT INTO mni_vpl VALUES ("AC13_30","074_13_30","ACT","13","30","30","Adubu Tengban Mapuna Ibungobu sibadagi hinggat-hanbikhi ");
INSERT INTO mni_vpl VALUES ("AC13_31","074_13_31","ACT","13","31","31","aduga Galilee-dagi Jerusalem tanna Ibungoga chatminnakhiba makhoisingna Ibungobu ujakhi. Houjik makhoina Israel-gi misingda sakhi oiri. ");
INSERT INTO mni_vpl VALUES ("AC13_32","074_13_32","ACT","13","32","33","Eikhoina Aphaba Pao asi nakhoida purakli: Tengban Mapuna eikhoigi ipa ipusingda toubigani haina wasakpikhiba adu Jisubu sibadagi hinggat-hanbiduna makhoigi macha masu oiriba eikhoigidamak toubire. Thagat Iseigi anisuba iseida ibagumbani; ‘Nahak eigi Ichanupani; ngasi eihak nahakki Napa Ibungo oirabani.’ ");
INSERT INTO mni_vpl VALUES ("AC13_34","074_13_34","ACT","13","34","34","Ibungobu sibadagi hinggat-hanbiba amadi Ibungogi hakchangbu mongphamda patthahalloi haibagi maramda Tengban Mapuna haibiba adudi asini: ‘Eina David-ta wasakpikhiba asengba amadi lengdraba yaipha thoujal adu eina nangonda pibigani.’ ");
INSERT INTO mni_vpl VALUES ("AC13_35","074_13_35","ACT","13","35","35","Thagat Iseigi atoppa mapham amada asumnasu hai, ‘Tengban Mapugi asengba mahak adugi hakchang adu Tengban Mapuna keidoungeida pattha pumthahalloi.’ ");
INSERT INTO mni_vpl VALUES ("AC13_36","074_13_36","ACT","13","36","36","David-na mahakki mirolgi matamda Tengban Mapugi aningba matung inna Tengban Mapubu thougal touramlaga mahak sikhi amadi mahakki mapa mapusingga loinana leirol chankhi aduga mahakki hakchang mongphamda pattha pumthakhi. ");
INSERT INTO mni_vpl VALUES ("AC13_37","074_13_37","ACT","13","37","37","Adubu Tengban Mapuna asibadagi hinggat-hanbikhraba Ibungo mangondadi pattha pumthaba thokte. ");
INSERT INTO mni_vpl VALUES ("AC13_38","074_13_38","ACT","13","38","39","Maram aduna eigi ichil inaosing, Jisugi mapanna pap kokpiba asi nakhoida sandokpani haibasi nakhoina khangba adu eina pammi. Moses-ki Wayel Yathanggi mapanna nakhoibu chumhanbiba ngamdaba adu Ibungogi mapanna thajaba mi khudingmakpu paptagi ningtamle. ");
INSERT INTO mni_vpl VALUES ("AC13_40","074_13_40","ACT","13","40","40","Tengban Mapugi wa phongdokpibasingna haikhiba adu nakhoida thoktanaba nakhoi cheksillu: ");
INSERT INTO mni_vpl VALUES ("AC13_41","074_13_41","ACT","13","41","41","‘Yeng-u, karemnabasa ngaksu ngaklo mangsu manglo! Maramdi nakhoigi haktakta eina thabak ama tou-i madu kanagumba amana nakhoida hairaba phaoba nakhoina keidoungeidasu thajaroi!’ ” ");
INSERT INTO mni_vpl VALUES ("AC13_42","074_13_42","ACT","13","42","42","Paul amadi Barnabas-na synagogue-tagi thorakpada mising aduna mathanggi Potthaba numitta makhoida waramsing adu makha tana haibinaba haijarammi. ");
INSERT INTO mni_vpl VALUES ("AC13_43","074_13_43","ACT","13","43","43","Synagogue-ta tinnaba adu kainarabada Jihudising amadi Jihudi laining louraba laining chetpa Jihudi nattaba mi mayam amana Paul amadi Barnabas-ki matung illammi. Tengban Mapugi thoujalda chetna leinanaba Pakhonchatpasing aduna makhoida wari saduna pukning thougatpirammi. ");
INSERT INTO mni_vpl VALUES ("AC13_44","074_13_44","ACT","13","44","44","Mathanggi Potthaba numitta sahar adugi mi ayambana Mapu Ibungogi wa tanaba laklammi. ");
INSERT INTO mni_vpl VALUES ("AC13_45","074_13_45","ACT","13","45","45","Jihudisingna miyam adu ubada kallakpana thallammi; maram aduna Paul-na haiba wasing aduda makhoina yettuna mahakpu thina nganglammi. ");
INSERT INTO mni_vpl VALUES ("AC13_46","074_13_46","ACT","13","46","46","Adubu Paul amadi Barnabas-na thouna phana paokhum pirak-i, “Eikhoina Tengban Mapugi wa adu nakhoida hanna haiba tabani adubu nakhoina madu loudrabanina nakhoi lomba naidana hingba phangba matik chade haina nasana khanjare. Houjikti eikhoi nakhoibu thadoktuna Jihudi nattaba phurupsingda chatlagani. ");
INSERT INTO mni_vpl VALUES ("AC13_47","074_13_47","ACT","13","47","47","Mapu Ibungona eikhoida pibiba yathang adu asini: ‘Malemgi aroiba maphamsing phaoba kanbiba phangnanaba Eina nahakpu Jihudi nattaba phurupsinggi mangal oihalle.’ ” ");
INSERT INTO mni_vpl VALUES ("AC13_48","074_13_48","ACT","13","48","48","Jihudi nattaba mising aduna madu tabada makhoi haraorammi amadi Mapu Ibungogi wa adu thagatcharammi aduga lomba naidana hingba phangnaba khandokpirabasingna thajare. ");
INSERT INTO mni_vpl VALUES ("AC13_49","074_13_49","ACT","13","49","49","Lam adu sinba thungna Mapu Ibungogi wa sandoklammi. ");
INSERT INTO mni_vpl VALUES ("AC13_50","074_13_50","ACT","13","50","50","Adubu sahar adugi athoiba nupasing amadi ikai khumnaba yabi laining chetpi nupisingbu Jihudisingna thoujillammi. Makhoina Paul amadi Barnabas-ki maiyokta irang thok-handuna ot-neihallaga makhoibu makhoigi lamdagi tanthoklammi. ");
INSERT INTO mni_vpl VALUES ("AC13_51","074_13_51","ACT","13","51","51","Maram aduna Paul amadi Barnabas-na yaningdaba oina makhonggi khongyagi uphul makhoigi maiyokta kanthoklamlaga Iconium-da chatlammi. ");
INSERT INTO mni_vpl VALUES ("AC13_52","074_13_52","ACT","13","52","52","Aduga Antioch-ta leiba thajabasingdu haraobaga amadi Thawai Asengbagana thallammi. ");
INSERT INTO mni_vpl VALUES ("AC14_1","074_14_1","ACT","14","1","1","Iconium-da Paul amadi Barnabas-na mahousagumna Synagogue-ta changlammi aduga makhoina matik leina wa ngangbadagi masing yamlaba Jihudising amadi Jihudi nattaba kaya amana thajarammi. ");
INSERT INTO mni_vpl VALUES ("AC14_2","074_14_2","ACT","14","2","2","Adubu thajadaba Jihudisingna Jihudi nattabasingbu thoujinduna thajabasing adugi maiyokta lepphallammi. ");
INSERT INTO mni_vpl VALUES ("AC14_3","074_14_3","ACT","14","3","3","Pakhonchatpasing aduna thouna phana Mapu Ibungogi maramda nganglammi amadi mapham aduda matam kuina leirammi. Aduga Ibungona makhoida angakpa thabaksing amadi khudamsing tounanaba panggal pibiduna makhoina ngangliba Ibungogi thoujalgi paojel adu achumbani haiba utpirammi. ");
INSERT INTO mni_vpl VALUES ("AC14_4","074_14_4","ACT","14","4","4","Sahar adugi miyam adu tokhai tokhai tanarammi; mi kharana Jihudisinggi maikeida aduga kharana pakhonchatpasinggi maikeida leirammi. ");
INSERT INTO mni_vpl VALUES ("AC14_5","074_14_5","ACT","14","5","5","Adudagi Jihudi nattabasing amadi Jihudising kharana makhoigi luchingbasingga loinana pakhonchatpasingbu thina tounaba amadi nungna thanaba lepnare. ");
INSERT INTO mni_vpl VALUES ("AC14_6","074_14_6","ACT","14","6","6","Adubu pakhonchatpasingna madu khanglabada makhoina Lycaonia-gi Lystra amasung Derbe saharsing amadi akoibada leiba maphamsingda chellammi. ");
INSERT INTO mni_vpl VALUES ("AC14_7","074_14_7","ACT","14","7","7","Aduga maphamsing aduda Aphaba Pao sandoklammi. ");
INSERT INTO mni_vpl VALUES ("AC14_8","074_14_8","ACT","14","8","8","Pokpadagi makhong soinairaklaba amadi mapunsida amukta chatpa ngamlaktriba nupa ama Lystra-da leirammi ");
INSERT INTO mni_vpl VALUES ("AC14_9","074_14_9","ACT","14","9","9","Mahakna mapham aduda phamduna Paul-na hairiba wa adu taduna leirammi. Mangonda anaba phahanbiba yaba thajaba lei haiba Paul-na ubada mangonda munna yenglaga ");
INSERT INTO mni_vpl VALUES ("AC14_10","074_14_10","ACT","14","10","10","khonjel houna hairak-i, “Nakhong chumna leppu!” Maduda mahakna chongkhattuna koichat chatpa hourammi. ");
INSERT INTO mni_vpl VALUES ("AC14_11","074_14_11","ACT","14","11","11","Miyam aduna Paul-na toukhiba adu ubada khonjel wangna Lycaonia-gi londa laorak-i, “Laisingna mioibagi sak-ong louduna eikhoigi inakta lakle!” ");
INSERT INTO mni_vpl VALUES ("AC14_12","074_14_12","ACT","14","12","12","Makhoina Barnabas-pu Zeus aduga Paul-buna athoiba wangangloi oiba maramna Hermes haina kourammi. ");
INSERT INTO mni_vpl VALUES ("AC14_13","074_14_13","ACT","14","13","13","Sahar adugi wangmada leiba Zeus laigi laisang adugi purohit amadi miyam aduna pakhonchatpasingda iratnaba sallabasing amadi lei parengsing sahar adugi thongjaoda puraklammi. ");
INSERT INTO mni_vpl VALUES ("AC14_14","074_14_14","ACT","14","14","14","Makhoina touriba adu Barnabas amadi Paul-na tabada makhoina makhoigi maphi segaiduna miyam adugi marakta chensillaga laorak-i, ");
INSERT INTO mni_vpl VALUES ("AC14_15","074_14_15","ACT","14","15","15","“Nakhoina madu karigi touribano? Eikhoisu nakhoigumna mioibani. Asigumba kanadraba thabaksing asidagi nakhoina namai onthoraktuna swarga, malem, ipak amadi madugi manungda leiba pumnamak adubu sembiba ahingba Tengban Mapu aduda namai onsillaknaba Aphaba Pao asi nakhoida puraknaba eikhoi mapham asida lakpani. ");
INSERT INTO mni_vpl VALUES ("AC14_16","074_14_16","ACT","14","16","16","Houkhraba mirolsingdadi phurup pumnamakna makhoigi aningbada chatpa Ibungo mahakna yabirammi. ");
INSERT INTO mni_vpl VALUES ("AC14_17","074_14_17","ACT","14","17","17","Adum oinamak Ibungo mahakna toubiba aphaba thabaksing aduna Ibungo mahak lei haibasi matam pumbada utpi: Ibungo mahakna atiyadagi nong chuhanbiduna matam matamgi oiba mahei marong pibi; mahakna nakhoida chinjak pibi amadi nakhoigi thamoibu haraobana thalhanbi.” ");
INSERT INTO mni_vpl VALUES ("AC14_18","074_14_18","ACT","14","18","18","Makhoina wasing asi hairaba phaobada miyam aduna makhoida iratpot katnaba hotnaba adu makhoina yamna wana thinglammi. ");
INSERT INTO mni_vpl VALUES ("AC14_19","074_14_19","ACT","14","19","19","Jihudi khara Antioch amadi Iconium-dagi laklammi. Makhoina miyam adubu insille aduga makhoina Paul-bu nungna thare aduga mahak sire khanduna sahar adugi mapanda chingthoklammi. ");
INSERT INTO mni_vpl VALUES ("AC14_20","074_14_20","ACT","14","20","20","Adubu thajabasing aduna mahakki akoibada koisillammi maduda mahak hougatlaktuna sahar aduda amuk changkhi. Mathanggi numitta mahak amadi Barnabas Derbe-da chatkhre. ");
INSERT INTO mni_vpl VALUES ("AC14_21","074_14_21","ACT","14","21","21","Paul amadi Barnabas-na Derbe-da Aphaba Pao sandoklammi amasung tung-inba mayam ama semlammi aduga makhoina Lystra, Iconium amadi Antioch-ta hallammi. ");
INSERT INTO mni_vpl VALUES ("AC14_22","074_14_22","ACT","14","22","22","Makhoina thajabasing adubu pukning chet-hallammi aduga thajabada chumna leinaba pukning thougatpirammi. “Eikhoina awa ana kaya khaangduna Tengban Mapugi ningthou leibak adu changba tai” haina makhoina tambirammi. ");
INSERT INTO mni_vpl VALUES ("AC14_23","074_14_23","ACT","14","23","23","Makhoina singlup khudingda ahal lamansing khanbirammi aduga chara henduna haijaraga makhoina thajariba Mapu Ibungogi maphamda makhoibu sinnarammi. ");
INSERT INTO mni_vpl VALUES ("AC14_24","074_14_24","ACT","14","24","24","Makhoina Pisidia-gi lam phaoraga Pamphylia-da laklammi. ");
INSERT INTO mni_vpl VALUES ("AC14_25","074_14_25","ACT","14","25","25","Makhoina Perga-da Tengban Mapugi wa sandoklaga Attalia-da chatlammi. ");
INSERT INTO mni_vpl VALUES ("AC14_26","074_14_26","ACT","14","26","26","Adudagi makhoina houjik loisillaba thabak adugidamak makhoibu Tengban Mapugi thoujalda sinnakhiba mapham Antioch tanna hi tongduna Attalia-dagi hallammi. ");
INSERT INTO mni_vpl VALUES ("AC14_27","074_14_27","ACT","14","27","27","Adudagi makhoina Antioch-ta thunglabada makhoina singlup adugi misingbu khomjillaga Tengban Mapuna makhoigi mapanna toukhiba thabak pumnamak amasung Tengban Mapuna Jihudi nattabasingda thajabagi thong hangbiba adu makhoida tamlammi. ");
INSERT INTO mni_vpl VALUES ("AC14_28","074_14_28","ACT","14","28","28","Aduga mapham aduda makhoina thajabasing aduga loinana kuina leirammi. ");
INSERT INTO mni_vpl VALUES ("AC15_1","074_15_1","ACT","15","1","1","Judea-dagi mi khara Antioch-ta laklaga “Moses-ki Wayel Yathanggi matung inna nakhoina un-kaktrabadi nakhoi kanbiba phangloi” haina thajabasingda tambirammi. ");
INSERT INTO mni_vpl VALUES ("AC15_2","074_15_2","ACT","15","2","2","Masigi matangda Paul amasung Barnabas-na makhoiga yamna kanna yetnarammi. Maram aduna Paul amasung Barnabas amadi Antioch-tagi thajaba kharaga loinana Jerusalem-da masigi matangda pakhonchatpasing amadi ahal lamansing unaba chatnaba leplammi. ");
INSERT INTO mni_vpl VALUES ("AC15_3","074_15_3","ACT","15","3","3","Singlupna makhoibu thabirammi aduga makhoina Phoenicia amadi Samaria phaoduna chatpada Jihudi nattabasingna Tengban Mapuda mai onsillakpagi pao makhoina tamlammi maduda thajaba pumnamak yamna haraorammi. ");
INSERT INTO mni_vpl VALUES ("AC15_4","074_15_4","ACT","15","4","4","Makhoina Jerusalem-da thungbada singlup amasung pakhonchatpasing amadi ahal lamansingna makhoibu taramna oklammi aduga Tengban Mapuna makhoigi mapanna toubikhiba thabak pumnamak makhoida tamlammi. ");
INSERT INTO mni_vpl VALUES ("AC15_5","074_15_5","ACT","15","5","5","Adubu Pharisee-singgi kangluptagi thajaraba mioi kharana lepkhatlaktuna hairak-i, “Jihudi nattaba makhoi un-kakpa tai aduga Moses-ki Wayel Yathang innaba haiba tai.” ");
INSERT INTO mni_vpl VALUES ("AC15_6","074_15_6","ACT","15","6","6","Maram aduna wapham asi khannanaba pakhonchatpasing amadi ahal lamansing punna unarammi. ");
INSERT INTO mni_vpl VALUES ("AC15_7","074_15_7","ACT","15","7","7","Makhoina kuina khannaraba matungda Peter-na lepkhattuna hairak-i, “Ichil-inaosa, Jihudi nattaba phurupsingna eigi chindagi Aphaba Pao asi taraga thajaraknaba matam kharagi mamangda nakhoigi naraktagi eibu Tengban Mapuna khandopikkhiba adu nakhoina khang-i. ");
INSERT INTO mni_vpl VALUES ("AC15_8","074_15_8","ACT","15","8","8","Mi pumnamakki thamoibu khangbiba Tengban Mapu mahakna makhoibu yabi haibasi Ibungo mahakna eikhoida Thawai Asengba pibibagumna makhoidasu Thawai Asengba pibiduna utpire. ");
INSERT INTO mni_vpl VALUES ("AC15_9","074_15_9","ACT","15","9","9","Ibungona eikhoiga makhoigagi marakta karisu khennaba thambide, maramdi makhoigi thajabagi mapanna Ibungona makhoigi thamoibu sengdokpire. ");
INSERT INTO mni_vpl VALUES ("AC15_10","074_15_10","ACT","15","10","10","Maram aduna eikhoigi ipa ipusingnasu aduga eikhoinasu puba ngamdaba potlum adubu thajabasinggi mathakta thanggattuna eikhoina karigi Tengban Mapubu chang yenggadouribano? ");
INSERT INTO mni_vpl VALUES ("AC15_11","074_15_11","ACT","15","11","11","Madu touroidabani! Makhoida oibagumna, eikhoisu Ibungo Jisugi thoujalna kanbiba phangle haiba eikhoina thajei.” ");
INSERT INTO mni_vpl VALUES ("AC15_12","074_15_12","ACT","15","12","12","Tengban Mapuna makhoigi mapanna Jihudi nattabasinggi marakta angakpa thabaksing amadi khudamsing toukhiba adu Paul amadi Barnabas-na paodamba aduda miyam pumnakna tumin leiduna tarammi. ");
INSERT INTO mni_vpl VALUES ("AC15_13","074_15_13","ACT","15","13","13","Makhoina ngangba loirabada Jacob-na hairak-i, “Ichil-inaosa, eina haiba tabiyu. ");
INSERT INTO mni_vpl VALUES ("AC15_14","074_15_14","ACT","15","14","14","Jihudi nattabasingdagi Ibungo mahakki oiba mising khandokpiduna Tengban Mapuna makhoigidamak khanbi haibasi ahanba oina utpiba adu Simon-na sandokna haibikhre. ");
INSERT INTO mni_vpl VALUES ("AC15_15","074_15_15","ACT","15","15","15","Masigi thoudok asi Tengban Mapugi wa phongdokpiba maichousingna haikhiba wasing aduga chanei. Mapugi puyada asumna iduna lei, ");
INSERT INTO mni_vpl VALUES ("AC15_16","074_15_16","ACT","15","16","16","‘Masigi matungda ei hallakkani, haibi Ibungona, aduga David-ki tukhraba phiyum amuk sagatpigani. Ningkhaikhraba adu eina amuk sagatkani aduga hannagi phibhamda thambigani. ");
INSERT INTO mni_vpl VALUES ("AC15_17","074_15_17","ACT","15","17","17","Aduga mioi atei pumnamak MAPU IBUNGO-bu thijagani, eigi oinaba koukhraba Jihudi nattabasing pumnamaksu. ");
INSERT INTO mni_vpl VALUES ("AC15_18","074_15_18","ACT","15","18","18","Matam kuirabagi mamangda khanghanbiraba Mapu Ibungona masi haibire.’ ” ");
INSERT INTO mni_vpl VALUES ("AC15_19","074_15_19","ACT","15","19","19","Jacob-na makha tana hairak-i, “Eigi oinadi, Jihudi nattabasingna Tengban Mapuda mai onsillakpada eikhoina wahanba oihan-gumsi. ");
INSERT INTO mni_vpl VALUES ("AC15_20","074_15_20","ACT","15","20","20","Madugi mahutta lai murtida kattuna mangthoklaba chinjak, nupa nupi oktaba lamchat chatpa, mangak leithattuna hatpa sa amadi ee chaba hairibasing asidagi lapthoknaba eikhoina makhoida i-si. ");
INSERT INTO mni_vpl VALUES ("AC15_21","074_15_21","ACT","15","21","21","Maramdi mamangngeidagi houna Moses-ki Wayel Yathang asi synagogue-singda Potthaba numit khudingda pari aduga mahakki waheisingbu sahar khudingda sandokli.” ");
INSERT INTO mni_vpl VALUES ("AC15_22","074_15_22","ACT","15","22","22","Adudagi makhoigi maraktagi mi khara khallaga Paul amadi Barnabas-ka loinana Antioch-ta thanaba pakhonchatpasing, ahal lamansing amasung singlup apunbana lepnarammi. Thajabasinggi marakta luchingba oiriba mioi ani haibadi Barsabbas hainasu kouba Judas amadi Silas-pu makhoina khallammi. ");
INSERT INTO mni_vpl VALUES ("AC15_23","074_15_23","ACT","15","23","23","Makhoina masigi ayiba che adu makhoida puhallammi: “Pakhonchatpasing, ahal lammansing amasung nakhoigi nachin nanaosing eikhoina, Antioch, Syria amadi Cilicia-da leiba eikhoigi Jihudi nattaba ichil inaosing nakhoibu khurumjari. ");
INSERT INTO mni_vpl VALUES ("AC15_24","074_15_24","ACT","15","24","24","Eikhoigi iraktagi chatkhiba mioi kharana haiba waphamdagi nakhoigi pukning olang onsaonahalle amasung nungaihandre. Adubu makhoidi eikhoidagi ayaba yaoraga chatkhiba natte. ");
INSERT INTO mni_vpl VALUES ("AC15_25","074_15_25","ACT","15","25","26","Maram aduna eikhoi punna tinnare aduga nakhoigi nanakta thananaba pao puba khara eikhoina khandokpa yanare. Eikhoigi Mapu Ibungo Jisu Christtagidamak thawai katthoklaba nungsijaraba marup Paul amadi Barnabas-ka loinana makhoi chatminnagani. ");
INSERT INTO mni_vpl VALUES ("AC15_27","074_15_27","ACT","15","27","27","Maram aduna eikhoina i-khraba adumak makhoimakna hainanaba nakhoigi nanakta Judas amadi Silas-pu eikhoina thare. ");
INSERT INTO mni_vpl VALUES ("AC15_28","074_15_28","ACT","15","28","28","Maru oiba hiramsing asi nattana atoppa potlum amamuk nakhoida thanggattaba haibasi Thawai Asengbanasu eikhoinasu phei haina khalle: ");
INSERT INTO mni_vpl VALUES ("AC15_29","074_15_29","ACT","15","29","29","madudi lai murtida katpa chinjak chadaba; ee chadaba; mangak leithattuna hatpa sa chadaba; nupa nupigi oiba lamchat naidaba thabaktagi lapthokpa hairibasing asini. Nakhoina hairibasing asi toudaba haibasi nakhoigi aphabani. Kainarasi.” ");
INSERT INTO mni_vpl VALUES ("AC15_30","074_15_30","ACT","15","30","30","Pao pubasing adu thakhrabada makhoina Antioch-ta chatlammi aduga mapham aduda makhoina thajabasingbu khomjillaga ayiba che adu makhoida sinnarammi. ");
INSERT INTO mni_vpl VALUES ("AC15_31","074_15_31","ACT","15","31","31","Mising aduna madu parammi aduga madugi pukning thougatpa waheising aduda makhoi haraorammi. ");
INSERT INTO mni_vpl VALUES ("AC15_32","074_15_32","ACT","15","32","32","Judas amadi Silas makhoi animak Tengban Mapugi wa phongdokpa maichou oiba maramna makhoibu pukning thougatpiduna amadi panggal happiduna matam sangna wa nganglammi. ");
INSERT INTO mni_vpl VALUES ("AC15_33","074_15_33","ACT","15","33","33","Mapham aduda matam khara leiraba tungda thajabasing aduna makhoibu thabirakpasing adugi maphamda ingthana thabire. ");
INSERT INTO mni_vpl VALUES ("AC15_34","074_15_34","ACT","15","34","34","Adum oinamak Silas-nadi mapham aduda leithaba phagani haina khankhi. ");
INSERT INTO mni_vpl VALUES ("AC15_35","074_15_35","ACT","15","35","35","Adubu Paul amasung Barnabas-ti mi kaya amaga loinana tambiduna amasung Mapu Ibungogi wa sandoktuna matam khara Antioch-ta leitharammi. ");
INSERT INTO mni_vpl VALUES ("AC15_36","074_15_36","ACT","15","36","36","Matam khara leiraga Paul-na Barnabas-ta hairak-i, “Eikhoina Mapu Ibungogi wa sandoklamba saharsingda amuk hanna chattuna thajabasing adu karam touribage haibadu yenglusi.” ");
INSERT INTO mni_vpl VALUES ("AC15_37","074_15_37","ACT","15","37","37","Barnabas-na John Mark-pu makhoiga loinana puba pamlammi ");
INSERT INTO mni_vpl VALUES ("AC15_38","074_15_38","ACT","15","38","38","adubu mahakna thabak loiba phaoba makhoiga leiminnadana mahakna Pamphylia-da makhoibu thadoklamlaga hankhiba maramna Paul-nadi mahak puba haibasi chumde haina khallammi. ");
INSERT INTO mni_vpl VALUES ("AC15_39","074_15_39","ACT","15","39","39","Kanna yetnaba thorakpadagi makhoi ani khainarammi: Barnabas-na Mark-pu puduna Cyprus-ta hi tongduna chatkhi ");
INSERT INTO mni_vpl VALUES ("AC15_40","074_15_40","ACT","15","40","40","adubu thajabasingna makhoibu Mapu Ibungogi thoujalda sinnabiraga Paul-na Silas-pu khallaga chatkhirammi. ");
INSERT INTO mni_vpl VALUES ("AC15_41","074_15_41","ACT","15","41","41","Mahakna Syria amadi Cilicia phaoduna chatlaga singlupsingbu panggal happirammi. ");
INSERT INTO mni_vpl VALUES ("AC16_1","074_16_1","ACT","16","1","1","Paul-na Derbe amadi Lystra-da chatlammi, mapham aduda Timothy kouba tung-inba ama leirammi. Mahakki mamadi thajabi Jihudi oirammi aduga mahakki mapana Greek-ni. ");
INSERT INTO mni_vpl VALUES ("AC16_2","074_16_2","ACT","16","2","2","Lystra amadi Iconium-da leiba thajabasingna mahakki maramda phajana hainarammi. ");
INSERT INTO mni_vpl VALUES ("AC16_3","074_16_3","ACT","16","3","3","Paul-na Timothy-bu puduna chatpa pamlammi maram asina mahakpu un kaklammi maramdi maphamsing aduda leiba Jihudi pumnamakna mahakki mapa Greek-ni haiba khanglammi. ");
INSERT INTO mni_vpl VALUES ("AC16_4","074_16_4","ACT","16","4","4","Adudagi makhoina sahar amadagi sahar amada chattuna Jerusalem-da Pakhonchatpasing amadi ahal lamansingna lepkhiba warepsing adu thajabasingda hairammi amadi madu ngaknaba makhoida hairammi. ");
INSERT INTO mni_vpl VALUES ("AC16_5","074_16_5","ACT","16","5","5","Maram aduna singlupsingna thajabada kankhatlammi amasung numit khudinggi masing hen-gatlammi. ");
INSERT INTO mni_vpl VALUES ("AC16_6","074_16_6","ACT","16","6","6","Asia-gi lamda Pao sandokpa Thawai Asengbana thingbagi maramna makhoina Phrygia amadi Galatia-gi lam phaoduna chatlammi. ");
INSERT INTO mni_vpl VALUES ("AC16_7","074_16_7","ACT","16","7","7","Mysia-gi ngamkhei yourabada makhoina Bithynia-gi lamda changnaba hotnarammi adubu Jisugi Thawaina makhoibu maduda changba yaramde. ");
INSERT INTO mni_vpl VALUES ("AC16_8","074_16_8","ACT","16","8","8","Maram aduna makhoina Mysia phaoraga Troas-ta chatlammi. ");
INSERT INTO mni_vpl VALUES ("AC16_9","074_16_9","ACT","16","9","9","Aduga ahing aduda Macedonia-gi nupa amana leptuna mangonda “Macedonia-da lakpiduna eikhoibu pangbiyu” haina haijaba amagi uhanbiba ama Paul-na urammi. ");
INSERT INTO mni_vpl VALUES ("AC16_10","074_16_10","ACT","16","10","10","Uhanbiba adu Paul-na ubaga, Macedonia-da khongsannaba eikhoi sem sarammi maramdi mapham adugi misingda Aphaba Pao sandoknaba Tengban Mapuna eikhoibu koubire haina eikhoina leplammi. ");
INSERT INTO mni_vpl VALUES ("AC16_11","074_16_11","ACT","16","11","11","Eikhoina hi tongduna Troas-tagi Samothrace-ta chatlammi aduga mathanggi numitta Neapolis-ta chatlammi. ");
INSERT INTO mni_vpl VALUES ("AC16_12","074_16_12","ACT","16","12","12","Aduga mapham adudagi eikhoina Macedonia-gi athoiba sahar ama oiriba amasung Rome-na loi chanba Philippi saharda chatlammi. Mapham aduda eikhoi numit kayanimuk leirammi. ");
INSERT INTO mni_vpl VALUES ("AC16_13","074_16_13","ACT","16","13","13","Potthaba numitta eikhoina sahar adugi thongjao mapanda thoklaga turel torban amada chatlammi, mapham aduda Jihudisingna pullaga haijanaba mapham ama leiramgani haina eikhoina khallammi. Aduga eikhoina phamtharabada tillamba nupising aduda wari saba hourammi. ");
INSERT INTO mni_vpl VALUES ("AC16_14","074_16_14","ACT","16","14","14","Eikhoina haiba taribising adugi manungda Thyatira-dagi manggra machugi phi lalonbi Lydia koubi Tengban Mapubu ningjabi nupi ama yaorammi. Paul-na hairiba adu pukning changna tananaba mahakki thamoi Mapu Ibungona hangdokpirammi. ");
INSERT INTO mni_vpl VALUES ("AC16_15","074_16_15","ACT","16","15","15","Mahak amadi mahakki imung manunggi misingbu baptize touraba matungda mahakna eikhoida hairak-i, “Eibu Mapu Ibungobu thajabini haina nakhoina khanbirabadi eigi yumda lakpiduna leibiyu.” Asumna mahakna eikhoida kanna haijarammi. ");
INSERT INTO mni_vpl VALUES ("AC16_16","074_16_16","ACT","16","16","16","Nongma eikhoina haijanaba mapham aduda chatlingeida phattaba thawai changbi minai leisabi ama eikhoina thengnare. Mahakna laibao phaobagi mapanna mahakki mapusinggidamak sel yamna tanbirammi. ");
INSERT INTO mni_vpl VALUES ("AC16_17","074_16_17","ACT","16","17","17","Leisabi asina Paul amadi eikhoigi itung illaga laorak-i, “Karamna kanbiba phanggani haina nakhoida laothokliba mising asi Wangthoiraba Tengban Mapu mahakki manaisingni.” ");
INSERT INTO mni_vpl VALUES ("AC16_18","074_16_18","ACT","16","18","18","Asumna mahakna numit kayamarum chattharammi. Akonbada Paul-na yamna nungaitaduna onsillaklaga thawai aduda hairak-i, “Jisu Christtagi mingda mangondagi thokkhinaba eina nangonda yathang piri!” Khudak aduda thawai adu nupi adudagi thokkhirammi. ");
INSERT INTO mni_vpl VALUES ("AC16_19","074_16_19","ACT","16","19","19","Mahakki mapusing aduna makhoigi sel tanbagi khudongchaba adu mangkhre haiba khanglabada makhoina Paul amadi Silas-pu pharaga angambasinggi manak tanna keithel manungda chingduna puraklammi. ");
INSERT INTO mni_vpl VALUES ("AC16_20","074_16_20","ACT","16","20","20","Makhoina wayel mapusinggi mangda makhoibu puraklaga hairak-i, “Mising asi Jihudisingni makhoina eikhoigi sahar asi irang langhalle. ");
INSERT INTO mni_vpl VALUES ("AC16_21","074_16_21","ACT","16","21","21","Eikhoigi wayelda kaiba chatnabising makhoina tambi; eikhoi Rome-gi mi ama oina chatnabising adu louba nattraga ngakpa yade.” ");
INSERT INTO mni_vpl VALUES ("AC16_22","074_16_22","ACT","16","22","22","Aduga miyam adusu yaona Paul amadi Silas-ki maiyokta houraklammi. Maduda wayel mapusing aduna makhoi anigi maphi segairaga phunaba yathang pirammi. ");
INSERT INTO mni_vpl VALUES ("AC16_23","074_16_23","ACT","16","23","23","Makhoibu tamthina phuraba matungda keisumsangda thamjillammi aduga keisumsang panaba aduda makhoibu cheksinna ngak sennaba yathang pirammi. ");
INSERT INTO mni_vpl VALUES ("AC16_24","074_16_24","ACT","16","24","24","Yathang asi phanglabada keisumsang panaba aduna makhoibu keisumsanggi manung thangba ka aduda thamlammi aduga makhoigi makhong adu kurao hang challammi. ");
INSERT INTO mni_vpl VALUES ("AC16_25","074_16_25","ACT","16","25","25","Ahing nongyai aduwaida Paul amadi Silas-na Tengban Mapuda haijarammi amadi thagat isei saklammi madu atei phadoksing aduna tarammi. ");
INSERT INTO mni_vpl VALUES ("AC16_26","074_16_26","ACT","16","26","26","Khanghoudana kanna yuhar haraktuna keisumsang adugi yumpham adu nikkhi. Khudakta keisumsang adugi thong pumnamak hangdoklammi aduga phadok pumnamakki yotlising adu nanthokkhi. ");
INSERT INTO mni_vpl VALUES ("AC16_27","074_16_27","ACT","16","27","27","Keisumsang panaba aduna tumbadagi hougatlakkhi aduga keisumsanggi thongsing adu hangdokpa ubada phadoksing nanthokkhre haina mahakna khallammi. Maram aduna mahak masa mathanta sijanaba mahakna mahakki thangsang satlammi. ");
INSERT INTO mni_vpl VALUES ("AC16_28","074_16_28","ACT","16","28","28","Adubu Paul-na khonjel wangna laorak-i, “Nasa nathantabu manghanjaganu! Eikhoi pumnamak mapham asida leiri!” ");
INSERT INTO mni_vpl VALUES ("AC16_29","074_16_29","ACT","16","29","29","Keisumsang panaba aduna mei puraknaba kouraga mahakna chensillaklammi aduga kibana nikladuna Paul amadi Silas-ki mangda tutharammi. ");
INSERT INTO mni_vpl VALUES ("AC16_30","074_16_30","ACT","16","30","30","Adudagi mahakna makhoibu mapanda puthoklaga hairak-i, “Ibungokhoi, kanbiba phangnaba ei kari toujaba tabage?” ");
INSERT INTO mni_vpl VALUES ("AC16_31","074_16_31","ACT","16","31","31","Maduda makhoina khumlak-i, “Ibungo Jisubu thajou aduga nahak amadi nahakki imung manungna kanbiba phanggani.” ");
INSERT INTO mni_vpl VALUES ("AC16_32","074_16_32","ACT","16","32","32","Adudagi makhoina Mapu Ibungogi wahei adu mahak amadi mahakki imungda leiminnaba pumnamakta sandoklammi. ");
INSERT INTO mni_vpl VALUES ("AC16_33","074_16_33","ACT","16","33","33","Ahing adugi pungpham adumaktada keisumsang panaba aduna makhoibu puraga makhoigi asok apansing adu chamthokpirammi aduga khudakta mahak amadi mahakki imunggi mi pumnamak baptize lourammi. ");
INSERT INTO mni_vpl VALUES ("AC16_34","074_16_34","ACT","16","34","34","Adudagi mahakna Paul amadi Silas-pu mahakki yumda pusillaga makhoida chana thaknaba pirammi. Tengban Mapubu thajabagi maramna mahak amadi mahakki imung manung pumnamak haraobana thallammi. ");
INSERT INTO mni_vpl VALUES ("AC16_35","074_16_35","ACT","16","35","35","Nongngallaklabada wayel mapusing aduna phamnaibasing tharaktuna keisumsang panaba aduda yathang piduna hairak-i. “Mising adu thadokkhro.” ");
INSERT INTO mni_vpl VALUES ("AC16_36","074_16_36","ACT","16","36","36","Maram aduna keisumsang panaba aduna Paul-da hairk-i, “Wayel mapusing aduna nahak amadi Silas-pu thadoknaba yathang pirakle. Houjikti chatpikhiba yarani, ingthana lengbiro.” ");
INSERT INTO mni_vpl VALUES ("AC16_37","074_16_37","ACT","16","37","37","Adubu phamnaibasing aduda Paul-na hairak-i, “Wayen toudana Rome-gi mi oiba eikhoibu miyam mamangda phuraga keisumsangda thamjinbire aduga houjikna makhoina eikhoibu lonna thadokpa pamlibra? Madu khak yaroi! Makhoi masamak mapham asida laktuna eikhoibu thindoksanu.” ");
INSERT INTO mni_vpl VALUES ("AC16_38","074_16_38","ACT","16","38","38","Phamnaibasing aduna waphamsing asi wayel mapusing aduda tamlure maduda makhoina Paul amadi Silas asi Rome-gi mini haiba tabada makhoi yamna kirammi. ");
INSERT INTO mni_vpl VALUES ("AC16_39","074_16_39","ACT","16","39","39","Maram aduna makhoina chattuna makhoida nonjarammi aduga makhoina keisumsangdagi makhoibu puthokle aduga sahar adu thadoktuna chatpikhinaba haijarammi. ");
INSERT INTO mni_vpl VALUES ("AC16_40","074_16_40","ACT","16","40","40","Paul amadi Silas-na keisumsang adudagi thoraklaga Lydia-gi yumda chatlammi. Mapham aduda thajabasing unaraga makhoida pukning thougatpa wasing haibiramlaga chatkhirammi. ");
INSERT INTO mni_vpl VALUES ("AC17_1","074_17_1","ACT","17","1","1","Paul amadi Silas-na Amphipolis amadi Apollonia phaoduna chatlaga Thessalonica-da lakle, mapham aduda synagogue ama leirammi. ");
INSERT INTO mni_vpl VALUES ("AC17_2","074_17_2","ACT","17","2","2","Mahakki hounabi matung inna Paul-na synagogue aduda chatlammi. Potthaba numit ahumlak mapham aduda mahakna mising aduga Mapugi puyadagi neinaduna ");
INSERT INTO mni_vpl VALUES ("AC17_3","074_17_3","ACT","17","3","3","Christtadi awaba khangba tai amadi sibadagi hinggatpa tai haiba adu sandokna taktuna utlammi. Mahakna hairak-i, “Eina nakhoida sandokliba Jisu asi Christta aduni.” ");
INSERT INTO mni_vpl VALUES ("AC17_4","074_17_4","ACT","17","4","4","Jihudisinggi maraktagi khara aduga Tengban Mapubu kina chatchaba Greek-ki mi mayam amaga athoiba nupi mayam amagana thajaduna Paul amadi Silas-ka pulle. ");
INSERT INTO mni_vpl VALUES ("AC17_5","074_17_5","ACT","17","5","5","Adubu Jihudising kharana kalakpadagi phattaba mi khara lambidagi khomjillaga kangbu ama semduna sahar adu irang houhalle. Aduga makhoina Paul amadi Silas-pu miyam mamangda puthoknaba Jason kouba nupa asigi yumda makhoina thomjinlammi. ");
INSERT INTO mni_vpl VALUES ("AC17_6","074_17_6","ACT","17","6","6","Adubu makhoina makhoibu phangdrabada, makhoina Jason amadi thajaba mioi khara chingduna sahar adugi angambasinggi mamangda puraklaga laorak-i, “Taibangpanbu mathak makha olhalliba mising asi mapham asidasu lakle, ");
INSERT INTO mni_vpl VALUES ("AC17_7","074_17_7","ACT","17","7","7","aduga Jason-na makhoibu mahakki yumda taramna oktuna thamle. Jisu kouba atoppa ningthou ama lei haiduna makhoi pumnamakna Caesar-gi wayel yathangsing thugaire.” ");
INSERT INTO mni_vpl VALUES ("AC17_8","074_17_8","ACT","17","8","8","Waheising asi tabada miyam amadi sahar adugi angambasing adu irang houhalle. ");
INSERT INTO mni_vpl VALUES ("AC17_9","074_17_9","ACT","17","9","9","Adudagi angambasing aduna Jason amasung ateising adu jamin pihallaga thadoklammi. ");
INSERT INTO mni_vpl VALUES ("AC17_10","074_17_10","ACT","17","10","10","Ahing hek oibaga thajabasingna Paul amadi Silas-pu Berea-da tharammi. Makhoina mapham aduda thungbaga synagogue-ta chatlammi. ");
INSERT INTO mni_vpl VALUES ("AC17_11","074_17_11","ACT","17","11","11","Thessalonica-da leiba misingdagidi mapham aduda leiba misingna henna wakhal chao-i. Makhoina pao adu yamna khourangna tai aduga Paul-na hairiba adu chumbra haibadu numit khudinggi Mapugi puya neinaduna kupna thijillammi. ");
INSERT INTO mni_vpl VALUES ("AC17_12","074_17_12","ACT","17","12","12","Greek-ki masak naiba nupi kaya ama amadi Greek-ki nupa kaya amasu yaona makhoi mayam amana thajarammi. ");
INSERT INTO mni_vpl VALUES ("AC17_13","074_17_13","ACT","17","13","13","Adubu Paul-na Berea-dasu Tengban Mapugi wa sandokle haiba Thessalonica-da leiba Jihudisingna tabada makhoina mapham aduda laktuna miyambu thoujinduna irang houhallammi. ");
INSERT INTO mni_vpl VALUES ("AC17_14","074_17_14","ACT","17","14","14","Thajabasing aduna Paul-bu khudakta Ipak mapan tanna thakhre adubu Silas amadi Timothy-di Berea-da leihourammi. ");
INSERT INTO mni_vpl VALUES ("AC17_15","074_17_15","ACT","17","15","15","Paul-bu thillakpa mising aduna mahakpu Athens phaoba pubire aduga Silas amadi Timothy-bu yariba makhei thuna mahakki manakta laknaba mahakna hairakpa wahei adu puduna makhoina Berea-da hallakle. ");
INSERT INTO mni_vpl VALUES ("AC17_16","074_17_16","ACT","17","16","16","Paul-na Athens-ta Silas amadi Timothy ngairingeida, mahakna sahar adu lai murtisingna thanna leiba adu ubada mahak thamoi yamna soklammi. ");
INSERT INTO mni_vpl VALUES ("AC17_17","074_17_17","ACT","17","17","17","Maram aduna mahakna synagogue-ta Jihudisingga amasung Tengban Mapubu kina chatchaba Jihudi nattabasingga khanna neinarammi aduga numit khudinggi keithelda lakpa misinggasu neinaminarami. ");
INSERT INTO mni_vpl VALUES ("AC17_18","074_17_18","ACT","17","18","18","Epicure amadi Stoic-ki mahei masing heiba kharagasu mahakka yetnarammi. Makhoi kharana hanglak-i. “Pang-ngangda ngangba asina haininglabasi karino?” Atoppasingna khumlak-i, “Mahakna miramgi laisinggi maramda sandokpa malli.” Paul-na Jisugi amadi Ibungona hinggatkhibagi maramda sandokpagi maramna makhoina masi haibani. ");
INSERT INTO mni_vpl VALUES ("AC17_19","074_17_19","ACT","17","19","19","Maram aduna makhoina Paul-bu Areopagus hairiba wa tanapham adugi mangda puraklaga makhoina mangonda hairak-i, “Nahakna sandokliba anouba tambiba adu eikhoi khangjaba yagadra? ");
INSERT INTO mni_vpl VALUES ("AC17_20","074_17_20","ACT","17","20","20","Nahakna haiba kharadi eikhoina tabada itong tongalli aduna hairibasing adu kari hairibano haiba eikhoi khangning-i.” ");
INSERT INTO mni_vpl VALUES ("AC17_21","074_17_21","ACT","17","21","21","(Athens-ki mi pumnamak amadi mapham aduda leiba mireibak machasingna anou anouba wa haiba amadi taba nattana karisu toudana matam lelli.) ");
INSERT INTO mni_vpl VALUES ("AC17_22","074_17_22","ACT","17","22","22","Paul-na Areopagus-ki mipham mamangda lepkhattuna hairak-i, “Athens-ki miyam! Nakhoi asi hiram pumnamakta laining chetpa misingni haiba eina ure. ");
INSERT INTO mni_vpl VALUES ("AC17_23","074_17_23","ACT","17","23","23","Eina nakhoigi sahar asida asum chatpada amadi nakhoina khurumba maphamsing adu eina asum yengbada khubham amada, ‘Khangdaba Tengban Mapuda’ haina iba ama eina thengnare. Nakhoina khangdana khurumliba Ibungo mahakki maramda eina nakhoida sandokpani. ");
INSERT INTO mni_vpl VALUES ("AC17_24","074_17_24","ACT","17","24","24","Taibangpan amadi masida leiriba pumnamakpu sembiba Tengban Mapudi swarga amadi malemgi Mapuni, mahakti mioibagi khutna saba laisangsingda leite. ");
INSERT INTO mni_vpl VALUES ("AC17_25","074_17_25","ACT","17","25","25","Eikhoina Ibungo mahakkidamak thabak sujaraga Ibungoda piba yaba Ibungogi awatpa amatasu leite maramdi Ibungona pumnamakta thawai, nungsasor amasung pot pumnamak pibi. ");
INSERT INTO mni_vpl VALUES ("AC17_26","074_17_26","ACT","17","26","26","Ibungo mahakna mi amadagi mioiba phurup khudingbu sembiduna malemgi mapham pumnamakta makhoibu leihanbi. Makhoina leigadaba akaknaba matam amadi akaknaba maphamgi ngamkhei adu Ibungona mangjounana leppi. ");
INSERT INTO mni_vpl VALUES ("AC17_27","074_17_27","ACT","17","27","27","Ibungona masi toubiribasi mioibana Ibungo mahakpu thijaraknaba amadi koima majaduna Ibungo mahakpu phangjaba yanabani adum oinamak Tengban Mapudi eikhoi pumnamaktagi lapna leite. ");
INSERT INTO mni_vpl VALUES ("AC17_28","074_17_28","ACT","17","28","28","Kanagumba amana asumna haikhibagumbani, ‘Ibungo mahakki mapanna eikhoi hingli, lengli amasung palli.’ Nakhoigi seireng i-ba kharana asumna haikhibagumbani, ‘Eikhoidi Ibungo mahakki machasingni.’ ");
INSERT INTO mni_vpl VALUES ("AC17_29","074_17_29","ACT","17","29","29","Maram aduna eikhoi Tengban Mapugi machasing oibanina Tengban Mapu asi mioibagi heisingba amadi wakhalna semba sana nattraga lupa nattraga nunggi murti amagumbani haina eikhoina khalloidabani. ");
INSERT INTO mni_vpl VALUES ("AC17_30","074_17_30","ACT","17","30","30","Mamangeigi khangdaba matam adu Tengban Mapuna singthanabidre adubu houjikti mapham khudingmakta mi pumnamakna pukning honglaknaba Ibungona yathang pire. ");
INSERT INTO mni_vpl VALUES ("AC17_31","074_17_31","ACT","17","31","31","Maramdi Ibungona khandokpikhraba mi adugi mapanna taibangpan pumbabu achumbana wayen-gadaba numit ama leppikhre. Ibungona mahakpu asibadagi hinggat-hanbiduna mi pumnamakta khudam utpire.” ");
INSERT INTO mni_vpl VALUES ("AC17_32","074_17_32","ACT","17","32","32","Sibadagi hinggatpagi maramda Paul-na haiba adu tabada makhoi kharana mahakpu noknarammi adubu atei kharana hairak-i, “Masigi maramda eikhoina nangondagi amukka taning-i.” ");
INSERT INTO mni_vpl VALUES ("AC17_33","074_17_33","ACT","17","33","33","Adudagi Paul-na mitin adudagi chatkhre. ");
INSERT INTO mni_vpl VALUES ("AC17_34","074_17_34","ACT","17","34","34","Mi kharadi Paul-gi tung inba oire amadi thajare. Makhoigi marakta Areopagus-ki mioi Dionysius, Damaris koubi nupi amasung mi atoppa kharasu yaorammi. ");
INSERT INTO mni_vpl VALUES ("AC18_1","074_18_1","ACT","18","1","1","Masigi matungda Paul-na Athens thadoklaga Corinth-ta chatlammi. ");
INSERT INTO mni_vpl VALUES ("AC18_2","074_18_2","ACT","18","2","2","Pontus-ta pokpa Aquila kouba Jihudi nupa ama mahakna thengnarammi. Ningthourel Claudius-na Jihudi pumnamak Rome thadoktuna chatnaba yathang pibagi maramna mahak amadi mahakki nupi Priscilla-ga loinana Italy-dagi ikui kuidana mapham aduda lakpani. Paul-na makhoibu unaba chatlammi. ");
INSERT INTO mni_vpl VALUES ("AC18_3","074_18_3","ACT","18","3","3","Makhoiga sinpham manaba maramna mahakna makhoiga leiminnaduna thabak suminnarammi. Makhoigi sinphamdi phiyum sabani. ");
INSERT INTO mni_vpl VALUES ("AC18_4","074_18_4","ACT","18","4","4","Potthaba numit khudinggi mahakna synagogue-ta chattuna khanna neinarammi aduga Jihudising amadi Greek-ki misingbu thajahannaba hotnarammi. ");
INSERT INTO mni_vpl VALUES ("AC18_5","074_18_5","ACT","18","5","5","Silas amadi Timothy-na Macedonia-dagi thunglarabada, Paul-na mahakki matam pumnamak pao sandokpada pirammi, mahakna Jisudi Christta aduni haiduna Jihudisingda sakhi pirammi. ");
INSERT INTO mni_vpl VALUES ("AC18_6","074_18_6","ACT","18","6","6","Adubu makhoina mahakki maiyokta leptuna ikaiba piraklabada mahakna mahakki maphi kanthoktuna makhoida hairak-i, “Nakhoigi ee nasagi kokthakta tasanu! Eigidi iran leitre. Houjiktagi houna eihak Jihudi nattaba phurupsinggi maphamda chatlagani.” ");
INSERT INTO mni_vpl VALUES ("AC18_7","074_18_7","ACT","18","7","7","Maram aduna mahakna makhoibu thadoklamlaga Jihudi phurupki mi nattaba Titius Justus kouba Tengban Mapu ningba nupa adugi yumda leinaba chatlammi. Mahakki yum adu synagogue-ka thangnana leirammi. ");
INSERT INTO mni_vpl VALUES ("AC18_8","074_18_8","ACT","18","8","8","Synagogue adugi luchingba Crispus amadi mahakki imung manung pumnamak Mapu Ibungobu thajarammi. Aduga Corinth-ki mi mayam amanasu Paul-na sandokpa adu tabadagi thajaduna baptize lourammi. ");
INSERT INTO mni_vpl VALUES ("AC18_9","074_18_9","ACT","18","9","9","Nongma ahing amada uhanbiba amada Mapu Ibungona Paul-da hairammi: “Kiganu, haiba lepkanu, tuminna leiganu, ");
INSERT INTO mni_vpl VALUES ("AC18_10","074_18_10","ACT","18","10","10","Maramdi eina nahakka loinari. Aduga mi kana amatana nangbu sok palhanba ngamloi, maramdi sahar asida eigi mi yamna lei.” ");
INSERT INTO mni_vpl VALUES ("AC18_11","074_18_11","ACT","18","11","11","Maram aduna Paul-na mapham aduda chahi amaga makhai leiduna misingda Tengban Mapugi wa tambirammi. ");
INSERT INTO mni_vpl VALUES ("AC18_12","074_18_12","ACT","18","12","12","Gallio-na Achaia-gi leingak mapu oiringeida Jihudisingna makhoi amata oina pullaga Paul-bu phaduna wayel sangda puraklammi. ");
INSERT INTO mni_vpl VALUES ("AC18_13","074_18_13","ACT","18","13","13","Maduda makhoina hairak-i. “Eikhoigi wayel yathanggi onna teinabada Tengban Mapubu khurumgadabani haina nupa asina misingbu themmi.” ");
INSERT INTO mni_vpl VALUES ("AC18_14","074_18_14","ACT","18","14","14","Paul-na wa ngangge hek toubaga Gallio-na Jihudisingda hairak-i, “Masi karigumba aranba nattraga yamna phattaba thabak tourambagi oiramlabadi nakhoina hairiba adu eina tabagi maram charamgadabani. ");
INSERT INTO mni_vpl VALUES ("AC18_15","074_18_15","ACT","18","15","15","Adubu masi waheigi amasung ming amadi nakhoi Jihudisinggi wayel yathanggi maramda yetnaba oibanina nakhoi nasel yanaba punajarak-u. Asigumba hiramsing asigi wayenba ei oiroi.” ");
INSERT INTO mni_vpl VALUES ("AC18_16","074_18_16","ACT","18","16","16","Adudagi mahakna makhoibu wayel sangdagi tanthokkhre. ");
INSERT INTO mni_vpl VALUES ("AC18_17","074_18_17","ACT","18","17","17","Adudagi makhoi pumnamakna synagogue-ki luchingba Sosthenes-pu pharaga wayel sang adugi mamangda phurammi. Adubu Gallio-na maduda karisu thousaramde. ");
INSERT INTO mni_vpl VALUES ("AC18_18","074_18_18","ACT","18","18","18","Matam khara Paul-na thajabasingga loinana Corinth-ta leirammi adudagi mahakna Priscilla amadi Aquila-ga loinana Syria-da hi tongduna chatlammi. Mahakna hi tongduna Cenchreae thadoktringeida mahakna sakkhiba wasak amagidamak mahakki maru kokthoklammi. ");
INSERT INTO mni_vpl VALUES ("AC18_19","074_18_19","ACT","18","19","19","Makhoina Ephesus-ta thunglabada mapham aduda Paul-na Priscilla amadi Aquila thanamlaga mahakna synagogue-ta changduna Jihudisingga khanna neinarammi. ");
INSERT INTO mni_vpl VALUES ("AC18_20","074_18_20","ACT","18","20","20","Mising aduna mahakpu makhoiga matam kharaga makha tana leithabinaba haijarammi adubu mahakna yaramde. ");
INSERT INTO mni_vpl VALUES ("AC18_21","074_18_21","ACT","18","21","21","Adubu mahakna chatlamdaida makhoida hai, “Tengban Mapugi aningba oirabadi ei nakhoigi nanakta amuk lakkani.” Adudagi mahakna Ephesus-tagi hi tongduna chatkhre. ");
INSERT INTO mni_vpl VALUES ("AC18_22","074_18_22","ACT","18","22","22","Mahakna Caesarea-da thunglabada mahakna Jerusalem-da chattuna singluppu unaruraga Antioch-ta chatlammi. ");
INSERT INTO mni_vpl VALUES ("AC18_23","074_18_23","ACT","18","23","23","Mapham aduda matam khara leiramlaga mahakna Galatia amadi Phrygia-gi lamsingda mathang mathang chattuna thajaba pumnamakpu panggal kankhat-hanbirammi. ");
INSERT INTO mni_vpl VALUES ("AC18_24","074_18_24","ACT","18","24","24","Matam aduda Alexandria-da pokpa Apollos kouba Jihudi nupa ama Ephesus-ta laklammi. Mahak wa ngangba heiba amadi Mapugi puyabu ningthina khangba nupa ama oirammi. ");
INSERT INTO mni_vpl VALUES ("AC18_25","074_18_25","ACT","18","25","25","Mahak Mapu Ibungogi lambigi maramda tambiraklaba amani aduga mahakna misingda thawai yaona amadi chumna Jisugi maramda nganglammi amadi tambirammi. Adubu mahak John-na baptize touba aduta khanglammi. ");
INSERT INTO mni_vpl VALUES ("AC18_26","074_18_26","ACT","18","26","26","Synagogue-ta mahakna thouna phana ngangba hourammi. Mahakna ngangba adu Priscilla amadi Aquila-na tarabada mahakpu makhoigi yumda purammi aduga makhoina mangonda Tengban Mapugi Lambi adugi maramda henna chumna sandokna takpirammi. ");
INSERT INTO mni_vpl VALUES ("AC18_27","074_18_27","ACT","18","27","27","Adudagi Apollos-na Achaia-da chatnaba leplammi, maram aduna mahakpu mateng pangba oina Ephesus-ta leiba thajabasing aduna Achaia-da leiba thajabasingda mahakpu taramna okpinaba irammi. Mahakna mapham aduda thungbada Tengban Mapugi thoujalgi mapanna thajakhraba makhoising aduda mahak yamna mateng oirammi. ");
INSERT INTO mni_vpl VALUES ("AC18_28","074_18_28","ACT","18","28","28","Maramdi miyam mamangda yetnabada Jisudi Christtani haina mahakna Mapugi puyadagi uttuna Jihudisingbu maithiba pirammi. ");
INSERT INTO mni_vpl VALUES ("AC19_1","074_19_1","ACT","19","1","1","Apollos-na Corinth-ta leiringeida, Paul-na manung changsinna leiba lambida laklaga Ephesus-ta thunglammi. Mapham aduda tung-inba khara thengnarammi ");
INSERT INTO mni_vpl VALUES ("AC19_2","074_19_2","ACT","19","2","2","aduga mahakna makhoida hanglak-i, “Nakhoina thajaba matamda Thawai asengba phangkhibra?” Maduda makhoina khumlak-i, “Thawai Asengba ama lei haiba phaoba eikhoidi tajadri.” ");
INSERT INTO mni_vpl VALUES ("AC19_3","074_19_3","ACT","19","3","3","“Adu oirabadi nakhoina loukhiba baptize adu karambano?” haina Paul-na hanglak-i. Maduda makhoina khumlak-i, “John-gi baptize toubiba aduni.” ");
INSERT INTO mni_vpl VALUES ("AC19_4","074_19_4","ACT","19","4","4","Maduda Paul-na hairak-i, “John-gi baptize touba adudi paptagi pukning honglaba makhoigini. Mahakki tungda lengbirakliba Ibungo Jisubu thajanaba mahakna Israel-gi misingda hairammi.” ");
INSERT INTO mni_vpl VALUES ("AC19_5","074_19_5","ACT","19","5","5","Masi tabada makhoina Ibungo Jisugi mingda baptize lourammi. ");
INSERT INTO mni_vpl VALUES ("AC19_6","074_19_6","ACT","19","6","6","Paul-na makhoigi mathakta khut thambibada Thawai Asengbana makhoigi mathakta lengthabiraklammi aduga makhoina atoppa lon nganglammi amasung Tengban Mapugi wa phongdoklammi. ");
INSERT INTO mni_vpl VALUES ("AC19_7","074_19_7","ACT","19","7","7","Mapham aduda makhoi punna mi taranithoirom leirammi. ");
INSERT INTO mni_vpl VALUES ("AC19_8","074_19_8","ACT","19","8","8","Paul-na synagogue-ta changduna tha ahum chupna misingga thouna phana wa nganglammi, Tengban Mapugi leibakki maramda makhoiga khanna neinaduna makhoibu thajahannaba hotnarammi. ");
INSERT INTO mni_vpl VALUES ("AC19_9","074_19_9","ACT","19","9","9","Adubu makhoi kharadi thamoi kallammi amasung thajou haiba yaramde aduga mi pumnamakki mamangda Mapu Ibungogi Lambi adugi maramda phattana nganglammi. Maram aduna Paul-na makhoibu thadokle aduga mahakna thajabasingbu puraga Tyrannus-ki mahei tampham sangda numit khudinggi khanna neinarammi. ");
INSERT INTO mni_vpl VALUES ("AC19_10","074_19_10","ACT","19","10","10","Masi chahi ani chatharammi, maram aduna Asia-gi lamda leiba mi pumnamakna Jihudi oirabasu Jihudi nattabasing oirabasu Mapu Ibungogi wa tajakhi. ");
INSERT INTO mni_vpl VALUES ("AC19_11","074_19_11","ACT","19","11","11","Paul-gi mapanna Tengban Mapuna thoidok hendokpa angakpa thabaksing tourammi. ");
INSERT INTO mni_vpl VALUES ("AC19_12","074_19_12","ACT","19","12","12","Paul-na sijinnaruraba khutpaiphi nattraga phi phaobana anabasinggi maphamda purakpada makhoigi anabasing pharammi amadi phattaba thawaisingna makhoidaggi thokkhirammi. ");
INSERT INTO mni_vpl VALUES ("AC19_13","074_19_13","ACT","19","13","13","Mapham amadagi mapham amada koichat chattuna phattaba thawaisingbu tanthokpa Jihudi khara leirammi. Makhoinasu Ibungo Jisugi ming sijinnaduna tanthoknaba hotnarammi. Makhoina phattaba thawaising aduda hairak-i, “Paul-na sandokpa Jisugi mingda nakhoi thoklaknaba eina yathang piri.” ");
INSERT INTO mni_vpl VALUES ("AC19_14","074_19_14","ACT","19","14","14","Athoiba Purohit Sceva-gi machanupa taretna masi toubani. ");
INSERT INTO mni_vpl VALUES ("AC19_15","074_19_15","ACT","19","15","15","Adubu phattaba thawai aduna makhoida hairak-i, “Eina Jisubu khang-i, Paul-busu khang-i adubu nakhoidi kanano?” ");
INSERT INTO mni_vpl VALUES ("AC19_16","074_19_16","ACT","19","16","16","Adudagi phattaba thawai changba nupa aduna makhoigi mathakta chongsillaktuna makhoi pumnamakpu khudum challammi. Adudagi makhoina maphi marol yaodana sok panduna yum adudagi chenthoraklammi. ");
INSERT INTO mni_vpl VALUES ("AC19_17","074_19_17","ACT","19","17","17","Ephesus-ta leiba Jihudising amadi Greek-ki mising pumnamakna masi tabada akiba poklammi amadi Ibungo Jisugi mingbu henna ikai khumnarammi. ");
INSERT INTO mni_vpl VALUES ("AC19_18","074_19_18","ACT","19","18","18","Thajakhraba mioi kayana thoraktuna makhoina toukhiba phattabasing adu phongna haidoklammi. ");
INSERT INTO mni_vpl VALUES ("AC19_19","074_19_19","ACT","19","19","19","Hikap yaikappa touba mi kayanasu makhoigi lairiksing adu puthoraktuna miyam mamangda mei thadoklammi. Makhoina lairiksing adugi mamal pathokpada punna lupa mayek lising yangkhei oirammi. ");
INSERT INTO mni_vpl VALUES ("AC19_20","074_19_20","ACT","19","20","20","Matou asumna Mapu Ibungogi wahei adu pak sanna sandoklammi amadi panggal hen-gatlammi. ");
INSERT INTO mni_vpl VALUES ("AC19_21","074_19_21","ACT","19","21","21","Thoudoksing asi thoklaba matungda Paul-na Macedonia amadi Achaia phaoraga Jerusalem-da chatnaba leplammi. Mahakna hairak-i, “Eina mapham aduda chatlaba tungda Rome-dasu ei chatpa tai.” ");
INSERT INTO mni_vpl VALUES ("AC19_22","074_19_22","ACT","19","22","22","Mahakpu mateng pangliba Timothy amasung Erastus-pu mahakna Macedonia-da tharammi aduga mahakna Asia-da matam kharaga leitharammi. ");
INSERT INTO mni_vpl VALUES ("AC19_23","074_19_23","ACT","19","23","23","Matam aduwaida Mapu Ibungogi Lambi adugi maramda Ephesus-ta achouba irang ama thoklammi. ");
INSERT INTO mni_vpl VALUES ("AC19_24","074_19_24","ACT","19","24","24","Maramdi Demetrius kouba lupagi potchei saba nupa amana Artemis lairembigi laisanggi mawongda lupagi laisang machasing sarammi. Aduga mahakki thabak asina khutsa heibasingda kanaba yamna pirammi. ");
INSERT INTO mni_vpl VALUES ("AC19_25","074_19_25","ACT","19","25","25","Maram aduna mahakna makhoibu amadi sinpham asiga mari leinaba thabaksuba pumnamak kouraga hairak-i, “Marupsa, sinpham asidagi eikhoina sel yamna phanglibani haiba nakhoina khangliba aduni. ");
INSERT INTO mni_vpl VALUES ("AC19_26","074_19_26","ACT","19","26","26","Houjik Paul hairiba nupa asina touriba asi nakhoina uriba amadi taribani. Eikhoi mioibagi khutna saba laisingdi Tengban Mapu natte haiduna Ephesus asida leiba mising amadi Asia-gi mapham ayambada mi mayam amabu mahakna thajahalle. ");
INSERT INTO mni_vpl VALUES ("AC19_27","074_19_27","ACT","19","27","27","Maram aduna eikhoigi sinpham asi khakta khudong thiningai oibata nattana matik chaorabi Artemis lairembigi sang asisu khudong thiningai oire aduga Asia pumnamak amadi taibangpan-gi mapham pumnamakta khurumlibi lairembi asigi matik magunsu manghallagani.” ");
INSERT INTO mni_vpl VALUES ("AC19_28","074_19_28","ACT","19","28","28","Makhoina masi tabada mei houna saoraduna laorak-i, “Ephesus-ki Artemis-ti matik chaobini!” ");
INSERT INTO mni_vpl VALUES ("AC19_29","074_19_29","ACT","19","29","29","Sahar adugi mapham pumnamakta charangnaba aduna thallammi. Miyamsing aduna Paul-ga chatminnaba Macedonia-gi mi ani haibadi Gaius amadi Aristarchus-pu pharaga kummei yengpham sang aduda makhoi punna hotchillammi. ");
INSERT INTO mni_vpl VALUES ("AC19_30","074_19_30","ACT","19","30","30","Miyam adugi mangda Paul-na thokpa pamlammi adubu thajabasingna mahakpu thinglammi. ");
INSERT INTO mni_vpl VALUES ("AC19_31","074_19_31","ACT","19","31","31","Paul-ga tinnaba, mapham adugi angambasing aduna mahakpu kummei yengpham sang aduda thoraktanaba haijaba warol ama mangonda tharaklammi. ");
INSERT INTO mni_vpl VALUES ("AC19_32","074_19_32","ACT","19","32","32","Tilliba mitin adu yamna charanglammi; mi kharana wa ama laorammi aduga atei mi kharana atoppa wa amamuk laorammi maramdi mi ayambana makhoi karigi mapham aduda laklibano haiba phaoba khanglamde. ");
INSERT INTO mni_vpl VALUES ("AC19_33","074_19_33","ACT","19","33","33","Miyam marakta yaoba Jihudising aduna Alexander-bu mayam mamangda inthorakpagi maramna mi kharana mahakna thok-hanbani haina khallammi. Maduda mahakna masa ngakthokchanaba wa ngangnaba mayambu tumminna leibinaba magi makhut hairammi. ");
INSERT INTO mni_vpl VALUES ("AC19_34","074_19_34","ACT","19","34","34","Adubu miyam aduna mahak asi Jihudini haiba khanglaklabada makhoi pumnamakna amata oina pung anirom “Ephesus-ki Artemis-ti matik chaobini” haina laorammi. ");
INSERT INTO mni_vpl VALUES ("AC19_35","074_19_35","ACT","19","35","35","Akonbada sahar adugi che chang panaba aduna miyam adubu tumin leihalammi. Mahakna hairak-i. “Ephesia-gi nupasa, matik chaobi Artemis-ki laisang amadi swargadagi tarakpa mahakki murti adubu Ephesus sahar asina ngak sellibani haibasi taibangpan-gi mipum khudingmakna khang-i. ");
INSERT INTO mni_vpl VALUES ("AC19_36","074_19_36","ACT","19","36","36","Hairibasing asi kana amatana yadaba ngamde. Maram aduna nakhoina ingthapham thok-i aduga khanthadana karisu touroidabani. ");
INSERT INTO mni_vpl VALUES ("AC19_37","074_19_37","ACT","19","37","37","Makhoina laisangdagi karisu huranba natte aduga eikhoigi lairembida thina ngangkhibasu leite adubu nakhoina makhoibu mapham asida purakle. ");
INSERT INTO mni_vpl VALUES ("AC19_38","074_19_38","ACT","19","38","38","Aduga Demetrius amadi mahakki khutsa heiba marup mapangsingna kanagumba amagi mathakta nungaitaba leirabadi mapham asida wayel sang amadi leingak mapusing leiri, maduda makhoina maralsing adu pukhatpa yai. ");
INSERT INTO mni_vpl VALUES ("AC19_39","074_19_39","ACT","19","39","39","Aduga nakhoina makha tana karigumba ama pukhatpa pamlabasu wayelgi oiba miyam tinnaba aduna lepkadabani. ");
INSERT INTO mni_vpl VALUES ("AC19_40","074_19_40","ACT","19","40","40","Ngasi thokliba thoudok asigi matungda irang houhanbagi eikhoigi ithakta maral siba yabagi akiba lei. Irang asi thok-hanbagi maram amata leite aduga eikhoina masigidamak maram piba ngamloi.” ");
INSERT INTO mni_vpl VALUES ("AC19_41","074_19_41","ACT","19","41","41","Masi hairaba matungda mahakna miyam tinba adu kainahankhre. ");
INSERT INTO mni_vpl VALUES ("AC20_1","074_20_1","ACT","20","1","1","Charangnaba adu loikhraba matungda Paul-na thajabasingbu punna kouraga makhoibu pukning thougatpirammi. Adudagi mahakna makhoida kaina wahei hairamlaga makhoibu thadoktuna Macedonia-da chatlammi. ");
INSERT INTO mni_vpl VALUES ("AC20_2","074_20_2","ACT","20","2","2","Mahakna lamdam adu phaoduna chatpada misingda pukning thougatpa wasing ngangbirammi. Adudagi mahak Greece-ta thungle ");
INSERT INTO mni_vpl VALUES ("AC20_3","074_20_3","ACT","20","3","3","aduga mapham aduda mahakna tha ahum leirammi. Mahakna Syria-da chatnaba thourang touringeida Jihudisingna mahakki maiyokta sarou sille haiba mahakna khanglaklammi maram aduna mahakna Macedonia phaoduna hannaba leple. ");
INSERT INTO mni_vpl VALUES ("AC20_4","074_20_4","ACT","20","4","4","Berea-dagi Pyrrhus-ki machanupa Sopater, Thessalonica-dagi Aristarchus amadi Secundus, Derbe-dagi Gaius, Asia-dagi Tychicus amasung Trophimus aduga Timothy-su yaona makhoising asina mahakka loinana chatminnarammi. ");
INSERT INTO mni_vpl VALUES ("AC20_5","074_20_5","ACT","20","5","5","Makhoina mang thana chatkhiduna Troas-ta eikhoibu ngairammi. ");
INSERT INTO mni_vpl VALUES ("AC20_6","074_20_6","ACT","20","6","6","Hamei yaodaba Talgi Chakkhangbagi matungda eikhoi hi tongduna Philippi-dagi chatlammi aduga numit mangani leiraga Troas-ta makhoigi manakta thunglammi. Mapham aduda eikhoi chayol ama leirammi. ");
INSERT INTO mni_vpl VALUES ("AC20_7","074_20_7","ACT","20","7","7","Chayolgi ahanba numitta tal thugainabagidamak eikhoi punna tinnarammi. Mathanggi numitta mapham adu thadoktuna chatkadaba maramna Paul-na ahing nongyai phaoba wa nganglammi. ");
INSERT INTO mni_vpl VALUES ("AC20_8","074_20_8","ACT","20","8","8","Eikhoina tinnariba mathak thangba ka aduda thaomei yamna thallammi. ");
INSERT INTO mni_vpl VALUES ("AC20_9","074_20_9","ACT","20","9","9","Naha oiriba Eutychus kouba nupa ama thongnaoda phamlammi, Paul-na leppa leitana ngangduna leiringeida mahak yamna kanna tumtharammi. Akonbadadi mahak dolan mathol ahumsuba adudagi leimaida tarammi. Makhoina mahakpu loukhatpa matamda mahak siramle. ");
INSERT INTO mni_vpl VALUES ("AC20_10","074_20_10","ACT","20","10","10","Adubu Paul-na makhada kumthaduna naha aduda nontharaga mahakpu konbirammi. Aduga mahakna hairak-i, “Pukning langtaknaganu, mahak hingli!” ");
INSERT INTO mni_vpl VALUES ("AC20_11","074_20_11","ACT","20","11","11","Adudagi makhoi loina mathak thangba kada amuk chatlammi aduga tal thugairaga charammi. Nongnganba phaoba Paul-na wa nganglammi aduga mahak chatkhre. ");
INSERT INTO mni_vpl VALUES ("AC20_12","074_20_12","ACT","20","12","12","Makhoina naha oiriba nupa adu yumda hingna pure amasung makhoi yamna haraojarammi. ");
INSERT INTO mni_vpl VALUES ("AC20_13","074_20_13","ACT","20","13","13","Eikhoina mang thana hi tongduna Assos-ta chatlammi, mapham adudagi eikhoina Paul-bu puraga hida chatminnagadabani. Mahakna Assos phaoba makhongna chatke haibagi mahakna masi eikhoida haibani. ");
INSERT INTO mni_vpl VALUES ("AC20_14","074_20_14","ACT","20","14","14","Assos-ta mahakna eikhoiga unaba matamda eikhoina mahakpu hida tong-hallaga Mitylene-da chatlammi. ");
INSERT INTO mni_vpl VALUES ("AC20_15","074_20_15","ACT","20","15","15","Mathanggi numitta mapham adudagi eikhoina hi tongduna chatlammi aduga Chios manakta thunglammi. Numit amagi matungda eikhoi Samos lanthoklammi aduga thangnaba numitta Miletus-ta thunglammi. ");
INSERT INTO mni_vpl VALUES ("AC20_16","074_20_16","ACT","20","16","16","Asia-gi lamda matam kuina leithadanaba Paul-na Ephesus lanthoklaga chatnaba leplammi. Maramdi Pentecost numitta Jerusalem youba yarabadi haiduna mahak taha taharammi. ");
INSERT INTO mni_vpl VALUES ("AC20_17","074_20_17","ACT","20","17","17","Miletus-tagi Paul-na Ephesus singlupki ah