﻿USE sofia;
DROP TABLE IF EXISTS sofia.mnh_vpl;
CREATE TABLE mnh_vpl (
  verseID VARCHAR(16) NOT NULL PRIMARY KEY,
  canon_order VARCHAR(12) NOT NULL,
  book VARCHAR(3) NOT NULL,
  chapter VARCHAR(3) NOT NULL,
  startVerse VARCHAR(3) NOT NULL,
  endVerse VARCHAR(3) NOT NULL,
  verseText TEXT CHARACTER SET UTF8 NOT NULL) ENGINE=MyISAM;
LOCK TABLES mnh_vpl WRITE;
INSERT INTO mnh_vpl VALUES ("MT1_1","070_1_1","MAT","1","1","1","Asœke kœdœ ɨ'ɨrɨ aata Yisu Kristu, ata Davidi á tshe dœ ndje ata Abrayamo. ");
INSERT INTO mnh_vpl VALUES ("MT1_2","070_1_2","MAT","1","2","2","Abrayamo zu Izaka, Izaka zu Yakobo, Yakobo zu Yuda œdœ aayanœ. ");
INSERT INTO mnh_vpl VALUES ("MT1_3","070_1_3","MAT","1","3","3","Yuda zu Perese œdœ Zara, ayi endje kœdœ lima Tamare. Perese zu Eserone, Eserone zu Arame. ");
INSERT INTO mnh_vpl VALUES ("MT1_4","070_1_4","MAT","1","4","4","Arame zu Aminadabe, Aminadabe zu Nashone, Nashone zu Salma. ");
INSERT INTO mnh_vpl VALUES ("MT1_5","070_1_5","MAT","1","5","5","Salma zu Boaz, Rahabe kœdœ lima ayinœ. Boaz zu Obede, Luta kœdœ lima ayinœ. Obede zu Yese. ");
INSERT INTO mnh_vpl VALUES ("MT1_6","070_1_6","MAT","1","6","6","Yese zu gbozugo Davidi, yé Davidi zu Salomo tœ yashe á tshe dœ lima awo Uri. ");
INSERT INTO mnh_vpl VALUES ("MT1_7","070_1_7","MAT","1","7","7","Salomo zu Robowame, Robowame zu Abiya, Abiya zu Asafe. ");
INSERT INTO mnh_vpl VALUES ("MT1_8","070_1_8","MAT","1","8","8","Asafe zu Yozafate, Yozafate zu Yorame, Yorame kœdœ ata Oziase. ");
INSERT INTO mnh_vpl VALUES ("MT1_9","070_1_9","MAT","1","9","9","Oziase zu Yotame, Yotame zu Akaze, Akaze zu Ezekiase. ");
INSERT INTO mnh_vpl VALUES ("MT1_10","070_1_10","MAT","1","10","10","Ezekiase zu Manase, Manase zu Amɔ, Amɔ zu Yoziase. ");
INSERT INTO mnh_vpl VALUES ("MT1_11","070_1_11","MAT","1","11","11","Yoziase zu Yekonia œdœ aayanœ dœ lɔndɔ á endje ko lima azu Israyele gu tœnœ ga tshakudu kanga ɓa lœ Babilone. ");
INSERT INTO mnh_vpl VALUES ("MT1_12","070_1_12","MAT","1","12","12","Manda kœko lima azu Israyele gu tœnœ ga tshakudu kanga ɓa lœ Babilone, Yekonia zu Shaletiele, yé Shaletiele zu Zorobabele. ");
INSERT INTO mnh_vpl VALUES ("MT1_13","070_1_13","MAT","1","13","13","Zorobabele zu Abiwude, Abiwude zu Eliyakimi, yé Eliyakimi zu Azore. ");
INSERT INTO mnh_vpl VALUES ("MT1_14","070_1_14","MAT","1","14","14","Azore zu Shadɔke, Shadɔke zu Akimi, yé Akimi zu Eliwude. ");
INSERT INTO mnh_vpl VALUES ("MT1_15","070_1_15","MAT","1","15","15","Eliwude zu Eleazare, Eleazare zu Matane, yé Matane zu Yakobo. ");
INSERT INTO mnh_vpl VALUES ("MT1_16","070_1_16","MAT","1","16","16","Yakobo zu Yozefu akɔ Mareya ayi Yisu, á endje sœ kœ'e she Kristu. ");
INSERT INTO mnh_vpl VALUES ("MT1_17","070_1_17","MAT","1","17","17","Ataa, kœto kpœtœ Abrayamo œrrr ga tœ Davidi, uwu aatazu sœ ndjokpa dœ vana. Kœto kpœtœ Davidi œrrr ga tœ lɔndɔ á endje ko lima azu Israyele gu tœnœ ga tshakudu kanga ɓa lœ Babilone, uwu aatazu sœ ndje ndjokpa dœ vana; yé kœto kpœtœ lɔndɔnœ asœmœ œrrr ga tœ kœzu Kristu, uwu aatazu sœ ndje ndjokpa dœ vana. ");
INSERT INTO mnh_vpl VALUES ("MT1_18","070_1_18","MAT","1","18","18","Ndœ budu kœzu Yisu Kristu sœ atake: Ayinœ dœ Mareya kœdœ lima koje nœ Yozefu. Kashe utshunœ adœke endje ngbɔtœ endje awa bale ga tœ œsœnœ, tshe gbɔ nguzu lœ awa gbɔgbɔ nœ Ɔtshɔ Ɨshirɨ. ");
INSERT INTO mnh_vpl VALUES ("MT1_19","070_1_19","MAT","1","19","19","Koje nœ ye dœ Yozefu kœdœ lima uzu á tshe sœ ndjii, yé tshe yiyi lima kœmɨtshelœ ye ngbɨ fœ azu nene. Tshe yi lima kœkatœ ye tɨ lœ ubunœ. ");
INSERT INTO mnh_vpl VALUES ("MT1_20","070_1_20","MAT","1","20","20","Ɓata á tshe sœ lima kœgbe atake, anga andjelu nœ Gbozu wuta ga tœ ye lœ ulu œ pa fœ she adœke: «Yozefu, ata Davidi, awa zaza ɓœ kœza Mareya tœ awo zœ nene. Gbambanœ nene, nguzunœ á sœ lœ ye asœmœ to lœ gbɔgbɔ nœ Ɔtshɔ Ɨshirɨ. ");
INSERT INTO mnh_vpl VALUES ("MT1_21","070_1_21","MAT","1","21","21","Tshe zu bala gbolo yakoshe yé ɓœ ta ɨ'ɨrɨ ye Yisu; gbambanœ nene, tshe she bala azu nœ ye lœ ekperœ nœ endje.» ");
INSERT INTO mnh_vpl VALUES ("MT1_22","070_1_22","MAT","1","22","22","Œneke kɔ mbœrœtœ endje ataa mbœrœ o'onœ á Gbozu pa lima lœ awa nœ ayi kœgbara o'o kœmbœrœtœ endje: ");
INSERT INTO mnh_vpl VALUES ("MT1_23","070_1_23","MAT","1","23","23","«Ɔkpɔ yawuru œ gbɔ nguzu yé œ zu gbolo yakoshe yé endje ta ɨ'ɨrɨ ye Emanwele.» Ádá ɨ'ɨrɨ Emanwele kœdœ «Ndjaba awa bale dœ azœ.» ");
INSERT INTO mnh_vpl VALUES ("MT1_24","070_1_24","MAT","1","24","24","Lɔkɔ á Yozefu jo, tshe mbœrœtœ ye ɓata á andjelu nœ Gbozu mɨ lima ndɨ nœ fœ she, yé œ za Mareya tœ awonœ. ");
INSERT INTO mnh_vpl VALUES ("MT1_25","070_1_25","MAT","1","25","25","Kashe tshe ngbɔngbɔpa gbarœ olo bale dœ she nene œrrr ga tœ kœzu gbolo yakoshe nœ ye ga pa ɔshɔ, yé á Yozefu ta ɨ'ɨrɨ Yisu ga pa ye. ");
INSERT INTO mnh_vpl VALUES ("MT2_1","070_2_1","MAT","2","1","1","Endje zu Yisu ɓa lœ Beteleme, ɓa lœ ogo Yuda dœ lɔndɔ á Erode dœ́ lima gbozugo. Manda kœzu she, agbangba kœwusœ ádá angerepe to lima ɓa tœ osho á ɔlɔ œ wuta tœnœ yé œ na. Endje yi lima kumu endje ga lœ Yerusaleme, ");
INSERT INTO mnh_vpl VALUES ("MT2_2","070_2_2","MAT","2","2","2","yé á yu adœke: «Gbozugo nœ Ayuda á endje zu she ngɔngɔ sœ kpœta a? 'A wu angerepe nœ ye œ wuta ɓa tœ osho á ɔlɔ œ wuta tœnœ, yé á 'a na kœgote ga utshu ye.» ");
INSERT INTO mnh_vpl VALUES ("MT2_3","070_2_3","MAT","2","3","3","Lɔkɔ á gbozugo Erode djindœ upunœ ataa, tshelœ ɔkɔrɔ ye œdœ œnœ azu ogo Yerusaleme djigi tshanga ye. ");
INSERT INTO mnh_vpl VALUES ("MT2_4","070_2_4","MAT","2","4","4","Tshe vwa osho ndœ agbozu tshapa anganga Ndjaba œdœ aayi kœyisœ awa akwa, yé œ yu endje tœ osho á endje li kœzu Masiya tœnœ. ");
INSERT INTO mnh_vpl VALUES ("MT2_5","070_2_5","MAT","2","5","5","Endje gi fœ she adœke: «Ɓa lœ Beteleme, ɓa lœ ogo Yuda. Gbambanœ nene, œneke á ayi kœgbara o'o su dœke: ");
INSERT INTO mnh_vpl VALUES ("MT2_6","070_2_6","MAT","2","6","6","“Œɓœ Beteleme, lœ ogo Yuda, ɓœ sœsœ adja teasho ugurutœ tshalakpɨ á sœ lœ ogo Yuda nene; gbambanœ nene, gbozunœ á tshe te bala utshu azu nœ mœ, azu Israyele, œ to ɓa ndœ zœ.”» ");
INSERT INTO mnh_vpl VALUES ("MT2_7","070_2_7","MAT","2","7","7","Dœ tœnœ ataa, Erode vwa osho ndœ agbangba kœwusœ ádá angerepe lœ ubunœ yé œ yu endje tœ kœwusœ adja lɔkɔnœ á angerepe wuta lima dœ tœnœ. ");
INSERT INTO mnh_vpl VALUES ("MT2_8","070_2_8","MAT","2","8","8","Manda nœ, tshe vwa endje ga lœ Beteleme dœ kœpa fœ endje adœke: «'E na œ yu osho pa upu nœ gbolo asœmœ dœ ɔtshɔnœ; yé œdœ 'e kœgbɔ she, 'e pandœ nœ fœ mœ adœke œmœ ndje, mœ na kœgote ga utshu ye.» ");
INSERT INTO mnh_vpl VALUES ("MT2_9","070_2_9","MAT","2","9","9","Manda kœdji o'o á gbozugonœ pa fœ endje, endje tetœ awa dœ kœro endje. Ngbewo, endje wu angerepe á endje wu má utshunœ ɓa tœ osho á ɔlɔ œ wuta tœnœ kœna utshu endje, œrrr œ ka ɓa pa osho á gbolonœ sœ lima tœnœ. ");
INSERT INTO mnh_vpl VALUES ("MT2_10","070_2_10","MAT","2","10","10","Endje sœ lima dœ egerœ yanga manda kœwu tœnœ. ");
INSERT INTO mnh_vpl VALUES ("MT2_11","070_2_11","MAT","2","11","11","Endje li ga lœ anda yé œ wu kpengbe gbolo dœ ayinœ, Mareya. Endje gote ga utshu ye yé œ donga she. Endje kɔrɔ gbarœ nœ endje yé œ ko makabo fœ she: Ɔrœ, zuwa yombo œdœ kada mire. ");
INSERT INTO mnh_vpl VALUES ("MT2_12","070_2_12","MAT","2","12","12","Manda nœ, Ndjaba pa fœ endje lœ ulu adœke endje kwakwatœ endje ga ndœ Erode nene. Ataa, endje za anga angbɨ awa á gu dœ tœnœ ga lœ ogo nœ endje. ");
INSERT INTO mnh_vpl VALUES ("MT2_13","070_2_13","MAT","2","13","13","Lɔkɔ á agbangba kœwusœ ádá angerepenœ asœmœ gu daye, anga andjelu nœ Gbozu bale wuta ga ndœ Yozefu lœ ulu yé œ pa fœ she adœke: «Aafo, œ za kpengbe gbolo dœ ayinœ yé œ kpa dœ endje ga lœ Ezipito. Sœ ɓa zœ œrrr œdœ mœ kœpa fœ ɓœ adœke ɓœ gu yekane. Gbambanœ nene, Erode œ para gbolonœ mbœrœ kœwo she.» ");
INSERT INTO mnh_vpl VALUES ("MT2_14","070_2_14","MAT","2","14","14","Ataa, Yozefu kœalafo, kœza kpengbe gbolonœ œdœ ayinœ potœ ye lœ butshɔ yé á kpa ga lœ Ezipito. ");
INSERT INTO mnh_vpl VALUES ("MT2_15","070_2_15","MAT","2","15","15","Tshe sœ ɓa zœ œrrr ga tœ kuzu Erode. Œ sœ ataa, mbœrœ á œneke á Gbozu pandœ nœ lœ awa nœ ayi kœgbara o'o kœmbœrœtœ endje. Tshe pandœ nœ adœke: «Mœ e gbolo nœ mœ adœke tshe wuta lœ Ezipito ye.» ");
INSERT INTO mnh_vpl VALUES ("MT2_16","070_2_16","MAT","2","16","16","Lɔkɔ á Erode wusœ nœ adœke agbangba kœwusœ ádá angerepe fara œne, ókó za lima she tɔpanœ kpuru. Tshe za o'o adœke endje wo agbolo yakoshe á ungu endje sœ ga tshakudu ungu bisha lakpɨ Beteleme œdœ lakpɨ á sœ dje ɨndɨrɨnœ para kɔkɔ. Ungunœ á tshe ka ga panœ asœmœ sœ lindœ œneke á agbangba kœwusœ ádá angerepenœ za lima fœ she. ");
INSERT INTO mnh_vpl VALUES ("MT2_17","070_2_17","MAT","2","17","17","Kɔkɔ asœmœ mbœrœtœ endje ɓata á ayi kœgbara o'o Yilimiya pa lima adœke: ");
INSERT INTO mnh_vpl VALUES ("MT2_18","070_2_18","MAT","2","18","18","«Endje dji tshama á sœ kœwuta tœnœ ɓa lœ ogo Rama, ɨkɨ œdœ egerœ dɨtshelœma. Rashele dá sœ kœkɨ agbolo nœ ye, tshe yiyindœ nœ adœke endje u œne nene, mbœrœ agbolo nœ ye tshu kɔ ye.» ");
INSERT INTO mnh_vpl VALUES ("MT2_19","070_2_19","MAT","2","19","19","Manda kuzu Erode, anga andjelu nœ Gbozu bale wuta ga tœ Yozefu lœ ulu ɓa lœ Ezipito. ");
INSERT INTO mnh_vpl VALUES ("MT2_20","070_2_20","MAT","2","20","20","Tshe pa fœ she adœke: «Aalafo œ za gbolo œdœ ayinœ potœ zœ yé œ kwatœ zœ ga lœ ogo Israyele. Gbambanœ nene, endjeneke á endje sœ lima kœpara awa kœwo gbolonœ tshu ye.» ");
INSERT INTO mnh_vpl VALUES ("MT2_21","070_2_21","MAT","2","21","21","Yozefu áalafo, œ za gbolonœ dœ pe ayinœ potœ ye, yé á endje gu ga lœ ogo Israyele. ");
INSERT INTO mnh_vpl VALUES ("MT2_22","070_2_22","MAT","2","22","22","Kashe kœdjindœ nœ adœke Arkelawose dá te gbozugo Yuda manda abanœ dœ Erode, awa kœgu ga zœ za she. Ndjaba yisœ osho fœ she lœ ulu á tshe gitœ ye á gu ga lœ ogo Galilayi. ");
INSERT INTO mnh_vpl VALUES ("MT2_23","070_2_23","MAT","2","23","23","Tshe na œ sœ ɓa lœ ongbo á ɨ'ɨrɨnœ kœdœ Nazarete. Œ sœ ataa yeka á o'o á aayi kœgbara o'o pa lima kœmbœrœtœ endje. Endje pa lima adœke: «Endje e she bala uzu Nazarete.» ");
INSERT INTO mnh_vpl VALUES ("MT3_1","070_3_1","MAT","3","1","1","Dœ lɔndɔnœ asœmœ, Yowane ayi kœza batisimu wuta lima œ sœ kœyisœ œrœ ɓa lœ kpagagasho nœ ogo Yuda adœke: ");
INSERT INTO mnh_vpl VALUES ("MT3_2","070_3_2","MAT","3","2","2","«'E fatshalɔsu 'e, gbambanœ nene, Ogo gbozu nœ tshalafo ndo ye!» ");
INSERT INTO mnh_vpl VALUES ("MT3_3","070_3_3","MAT","3","3","3","Yowane kœdœ uzu á ayi kœgbara o'o Isaya pa lima tœ ye lɔkɔnœ á tshe pa adœke: «Anga uzu sœ kœta rawa ɓa lœ kpagagasho adœke: 'E guma ala awa Gbozu, 'e yɔrɔ ala awa ye ndjii!» ");
INSERT INTO mnh_vpl VALUES ("MT3_4","070_3_4","MAT","3","4","4","Yowane verœ lima lœba á endje mbœrœ dœ usu shamo, yé œ i lima uwu tshapa lœba á endje mbœrœ dœ ɔkɔ agea ga lœ nguku ye; tshe zɨ lima ayila yé œ la adja ojoro awaterœ. ");
INSERT INTO mnh_vpl VALUES ("MT3_5","070_3_5","MAT","3","5","5","Azu tshalakpɨ Yerusaleme dœ azu ogo Yuda kɔ œdœ pe azu ogo kɔ á sœ mashenga dœ ungu Yɔrdane, na lima ga ndœ ye. ");
INSERT INTO mnh_vpl VALUES ("MT3_6","070_3_6","MAT","3","6","6","Endje sœ lima kœpandœ ekperœ nœ endje, yé Yowane sœ lima kœza batisimu fœ endje ɓa la Yɔrdane. ");
INSERT INTO mnh_vpl VALUES ("MT3_7","070_3_7","MAT","3","7","7","Yowane wu adœke Afarisayi œdœ Asadukayi ndjoro sœ kœna lima ga tœ œsœ batisimu nœ ye, tshe pa fœ endje adœke: «Ukpulu ekpe ayakoro! Uzu ɗe dá yisœ nœ fœ 'e adœke 'e kpa awa kœwa ngbanga nœ Ndjaba á ndo kœna tœnœ a? ");
INSERT INTO mnh_vpl VALUES ("MT3_8","070_3_8","MAT","3","8","8","'E mbœrœ œrœ á sœ kœma adœke adja 'e fatshalɔsu 'e ye, ");
INSERT INTO mnh_vpl VALUES ("MT3_9","070_3_9","MAT","3","9","9","yé 'e papa mbœrœ 'e dœ tœ 'e nene adœke: “Abrayamo kœdœ ata azœ.” Gbambanœ nene, mœ sœ kœmɨndœ nœ fœ 'e adœke, Ndjaba li kœfa badja asœke tœ aata Abrayamo! ");
INSERT INTO mnh_vpl VALUES ("MT3_10","070_3_10","MAT","3","10","10","Gonda sœ yindjindjinœ mbœrœ kœvwa dœ ɔyɔ tɔtœ œshenœ kɔ ye, ɔyɔ kɔ á elenœ kœgaga nene, endje de yé œ ko va ga tœ owo. ");
INSERT INTO mnh_vpl VALUES ("MT3_11","070_3_11","MAT","3","11","11","Œmœ, mœ sœ kœza batisimu fœ 'e dœ ungu mbœrœ kœma adœke 'e yapa ɔtshɔ 'e ye. Kashe tsheneke á tshe na manda mœ, tshe za bala batisimu fœ 'e dœ Ɔtshɔ Ɨshirɨ œdœ dœ owo. Tshe ropa mœ dœ gbɔgbɔ ye, mœ lili kœka ga utshu ye dœ pe kœzu uwu œrada nœ ye nene. ");
INSERT INTO mnh_vpl VALUES ("MT3_12","070_3_12","MAT","3","12","12","Tshe za tshekara kœpe dœ tshelœ indji ngwarœ ga tshaabrœ ye, yé tshe mea indji ngwarœ mbœrœ kœkurutshelœ nœ dœ oforo. Tshe gumasœ indji ngwarœ ga la kogba, yé œ ko oforonœ va ga tœ owo neke á ru nene.» ");
INSERT INTO mnh_vpl VALUES ("MT3_13","070_3_13","MAT","3","13","13","Anga ɔlɔ bale, Yisu to ɓa lœ Galilayi yé œ ro ɓa ndœ Yowane ɓa langu Yɔrdane, tshe na ndoo dœ Yowane mbœrœ adœke tshe za batisimu fœ œne. ");
INSERT INTO mnh_vpl VALUES ("MT3_14","070_3_14","MAT","3","14","14","Yowane yi lima ndœ kœvwaratœ ye, yé á pa adœke: «Œmœ dá li má adœke ɓœ za batisimu fœ mœ, yé ɓœ kpa na ga ndœ mœ adœke mœ za batisimu fœ ɓœ a!» ");
INSERT INTO mnh_vpl VALUES ("MT3_15","070_3_15","MAT","3","15","15","Kashe Yisu gi fœ she adœke: «Yindœ nœ adœke œ mbœrœtœ ye ngɔngɔnœ asœke ataa. Gbambanœ nene, mara á li adœke a mbœrœ œrœ á sœ ndjii dœmœ.» Yé Yowane kœyindœ nœ ye. ");
INSERT INTO mnh_vpl VALUES ("MT3_16","070_3_16","MAT","3","16","16","Manda kœgbɔ batisimu nœ Yisu, tshe wuta langu. Kolœ pe dœ lɔndɔnœ asœmœ, tshalafo kɔrɔ ga pa ye, tshe wu Ɨshirɨ nœ Ndjaba œ jerœ ga pa ye ɓata mbepa. ");
INSERT INTO mnh_vpl VALUES ("MT3_17","070_3_17","MAT","3","17","17","Yé tshama to ɓa lafo œ pa adœke: «Tsheneke asœke kœdœ Gbolo nœ mœ á mœ yindœ ye waa, mœ za yanga nœ mœ kɔ ga ndœ ye.» ");
INSERT INTO mnh_vpl VALUES ("MT4_1","070_4_1","MAT","4","1","1","Manda nœ, Ɨshirɨ nœ Ndjaba to Yisu na tœnœ ga lœ kpagagasho mbœrœ adœke djaboro wu lɔsu ye. ");
INSERT INTO mnh_vpl VALUES ("MT4_2","070_4_2","MAT","4","2","2","Manda kœmbœrœ ɔlɔ zazu bisha œdœ butshɔ zazu bisha ndœ kœyotshelœma, Yisu sœ lima dœ ogo. ");
INSERT INTO mnh_vpl VALUES ("MT4_3","070_4_3","MAT","4","3","3","Djaboro, ayi kœwu lɔsu, na ndoo dœ she yé œ pa adœke: «Œdœ ɓœ kœdœ Gbolo nœ Ndjaba, pa fœ badja asœke œ fatœ ye tœ mapa.» ");
INSERT INTO mnh_vpl VALUES ("MT4_4","070_4_4","MAT","4","4","4","Kashe Yisu gi adœke: «Endje sú ɓa la Buku nœ Ndjaba adœke: “Uzu œ sœ dœ soro kolœ mbœrœ mapa nene, kashe dœ o'o kɔ á wuta lœ ama Ndjaba.”» ");
INSERT INTO mnh_vpl VALUES ("MT4_5","070_4_5","MAT","4","5","5","Dœ tœnœ ataa, djaboro na dœ she œrrr ɓa lœ Yerusaleme á dœ ongbo á sœ yerœ, œ za she tɔ ɓa pa kumu Tepelo, ");
INSERT INTO mnh_vpl VALUES ("MT4_6","070_4_6","MAT","4","6","6","á œ pa fœ she adœke: «Œdœ ɓœ kœdœ Gbolo nœ Ndjaba, i dœ tœ zœ tshirɨ ga atɨ. Gbambanœ nene, endje sú ɓa la buku nœ Ndjaba adœke: “Ndjaba œ za awa o'o fœ aandjelu nœ ye mbœrœ ɓœ, endje za ɓœ ga atɨ dœ kane endje mbœrœ á ɓœ kœzaza ada zœ tɔ badja nene.”» ");
INSERT INTO mnh_vpl VALUES ("MT4_7","070_4_7","MAT","4","7","7","Yé Yisu gi fœ she adœke: «Endje su ndje ɓa la Buku nœ Ndjaba adœke: “Wuwu lɔsu Gbozu Ndjaba nœ zœ nene.”» ");
INSERT INTO mnh_vpl VALUES ("MT4_8","070_4_8","MAT","4","8","8","Djaboro kpa ɔ dœ she œrrr ɓa tœ leta kumu ɨngɨrɨ kaga œ ma ogo gbozu tshapashɔ djigi dœ ɔtshɔrœ, ndje dœ mokɔnœ fœ she, ");
INSERT INTO mnh_vpl VALUES ("MT4_9","070_4_9","MAT","4","9","9","yé á pa fœ she adœke: «Mœ ko œrœnœ asœke kɔ fœ ɓœ œdœ ɓœ kœgote ga utshu mœ mbœrœ kœdonga mœ.» ");
INSERT INTO mnh_vpl VALUES ("MT4_10","070_4_10","MAT","4","10","10","Yé Yisu kœgi fœ she adœke: «Gitœ zœ ga zœ, Satana! Gbambanœ nene, endje sú ɓa la buku nœ Ndjaba adœke: “Donga Gbozu Ndjaba nœ zœ, yé œ za avwala kolœ fœ she tshebabale.”» ");
INSERT INTO mnh_vpl VALUES ("MT4_11","070_4_11","MAT","4","11","11","Ndara tœ asœke, djaboro kœkatœ ye yé. Aandjelu kœgitœ endje ndoo dœ she, yé á kœtetœ kœmbœrœ akwa fœ she. ");
INSERT INTO mnh_vpl VALUES ("MT4_12","070_4_12","MAT","4","12","12","Lɔkɔ á Yisu dji adœke endje za Yowane ayi kœza batisimu ga lœ kánga, tshe kwatœ ye ga lœ Galilayi. ");
INSERT INTO mnh_vpl VALUES ("MT4_13","070_4_13","MAT","4","13","13","Tshe katœ Nazarete tɨ, œ na kœsœ ɓa lœ Kaparnawumu, ongbo á sœ tœ mangu egerœ ungu adanga nœ Galilayi, ɓa lœ ogo Zabulone œdœ pe ɓa lœ Nefetali. ");
INSERT INTO mnh_vpl VALUES ("MT4_14","070_4_14","MAT","4","14","14","Œ sœ lima ataa mbœrœ adœke o'o á ayi kœgbara o'o Isaya pa tœnœ, kœmbœrœtœ endje. Tshe pa o'onœ adœke: ");
INSERT INTO mnh_vpl VALUES ("MT4_15","070_4_15","MAT","4","15","15","«Ogo Zabulone œdœ Nefetali, á sœ tœ awa kœro ga la egerœ ungu adanga, ɓa kele ungu Yɔrdane, ogo Galilayi á angbɨ azu sœ lœnœ asœmœ! ");
INSERT INTO mnh_vpl VALUES ("MT4_16","070_4_16","MAT","4","16","16","Azunœ á endje sœ lœ ubu osho asœmœ, wu egerœ ɨngbɨsho! Mbœrœ endjeneke á endje sœ lœ ubu osho nœ kuzu, ɨngbɨsho wuta ga pa endje!» ");
INSERT INTO mnh_vpl VALUES ("MT4_17","070_4_17","MAT","4","17","17","Pe dœ lɔkɔnœ asœmœ, Yisu tetœ kœyisœ œrœ adœke: «'E yapa ɔtshɔ 'e, gbambanœ nene, Ogo gbozu nœ tshalafo ndo ye!» ");
INSERT INTO mnh_vpl VALUES ("MT4_18","070_4_18","MAT","4","18","18","Ɔlɔ bale, Yisu sœ lima kœna tœ mangu egerœ ungu adanga nœ Galilayi, yé œ wu aayazu bisha, Shimu á anga ɨ'ɨrɨ ye kœdœ Petro œdœ ayanœ dœ Andere á endje dœ lima aayi kœpara ageatshalangu. Endje sœ lima kœvwi gbanda ɓa la egerœ ungu adanga. ");
INSERT INTO mnh_vpl VALUES ("MT4_19","070_4_19","MAT","4","19","19","Yisu pa fœ endje adœke: «'E na manda mœ, mœ fa 'e tœ aayi kœpara azu.» ");
INSERT INTO mnh_vpl VALUES ("MT4_20","070_4_20","MAT","4","20","20","Pe kpœtœ œsœnœ, endje ka lima tœ gbanda nœ endje tɨ yé œ na manda ye. ");
INSERT INTO mnh_vpl VALUES ("MT4_21","070_4_21","MAT","4","21","21","Tshe na lœ ɨngɨrɨnœ, œ kpa wu anga aayazu bisha, Ayakobo dœ ayanœ dœ Yowane, endje kœdœ agbolo nœ Zebedayi. Endje sœ lima lœ agba nœ endje awa bale dœ aba endje dœ Zebedayi, yé œ sœ lima tœ kœguma gbanda nœ endje. Yisu e endje. ");
INSERT INTO mnh_vpl VALUES ("MT4_22","070_4_22","MAT","4","22","22","Pe kpœtœ œsœnœ, endje katœ agba œdœ aba endje tɨ, yé œ na manda ye. ");
INSERT INTO mnh_vpl VALUES ("MT4_23","070_4_23","MAT","4","23","23","Yisu ro djelœ ogo Galilayi djigi; tshe sœ lima kœyisœ œrœ ɓa lœ Sinagoga para. Tshe sœ lima kœmɨndœ Ɔtshɔ O'o nœ ogo gbozu yé œ sœ lima kœshe azu lœ koɓa œdœ lœ gbakɨndɨ nœ endje kɔ. ");
INSERT INTO mnh_vpl VALUES ("MT4_24","070_4_24","MAT","4","24","24","Upu nœ ye za lima ogo Siri djigi, yé endje sœ lima kœna dœ azu á endje sœ lima dœ tshelœ aka koɓa kɔ fœ she, azu á endje sœ dœ ekpe ɨshirɨ pa endje, dœ azu á endje sœ dœ koɓa ɔkɔ œdœ endjeneke á ada endje tshu. Yé Yisu she lima endje ye. ");
INSERT INTO mnh_vpl VALUES ("MT4_25","070_4_25","MAT","4","25","25","Ukpulu azu ndjoro na lima manda ye: Endje to lima ɓa lœ Galilayi, ɓa lœ ogonœ á endje e ɨ'ɨrɨnœ adœke tshalakpɨ ndjokpa asœmœ, dœ azu Yerusaleme ndje dœ ogo Yuda, œdœ endjeneke ɓa lœ ogo á sœ ɓa kele ungu Yɔrdane. ");
INSERT INTO mnh_vpl VALUES ("MT5_1","070_5_1","MAT","5","1","1","Lɔkɔ á Yisu wu ukpulu azu asœmœ, tshe ɔ ga pa kaga yé œ sœ ga atɨ. Ayambarœ nœ ye na ga ɨndɨrɨ ye, ");
INSERT INTO mnh_vpl VALUES ("MT5_2","070_5_2","MAT","5","2","2","yé á tshe tetœ kœyisœ œrœ fœ endje adœke: ");
INSERT INTO mnh_vpl VALUES ("MT5_3","070_5_3","MAT","5","3","3","«Yanga nœ azu á endje sœ dœ lɔsu nœ oyo, gbambanœ nene, Ogo gbozu nœ tshalafo kœdœ œnœ endje! ");
INSERT INTO mnh_vpl VALUES ("MT5_4","070_5_4","MAT","5","4","4","Yanga nœ azu á endje sœ tœ ɨkɨ, gbambanœ nene, Ndjaba œ turu ngola endje! ");
INSERT INTO mnh_vpl VALUES ("MT5_5","070_5_5","MAT","5","5","5","Yanga nœ azu á endje sœ dœ lɔsu zɨtɨ, gbambanœ nene, endje gbɔ bala ogonœ á Ndjaba pa tœnœ! ");
INSERT INTO mnh_vpl VALUES ("MT5_6","070_5_6","MAT","5","6","6","Yanga nœ azu á endje sœ dœ adja ogo kœmbœrœ œrœ á sœ ndjii, gbambanœ nene, Ndjaba œ to gbɔgbɔ kœmbœrœ tœnœ fœ endje! ");
INSERT INTO mnh_vpl VALUES ("MT5_7","070_5_7","MAT","5","7","7","Yanga nœ azu á endje wu oyo anga endje, gbambanœ nene, Ndjaba œ wu oyo endje! ");
INSERT INTO mnh_vpl VALUES ("MT5_8","070_5_8","MAT","5","8","8","Yanga nœ azu á lɔsu endje sœ yerœ, gbambanœ nene, endje wu bala Ndjaba! ");
INSERT INTO mnh_vpl VALUES ("MT5_9","070_5_9","MAT","5","9","9","Yanga nœ azu á endje sœ kœmbœrœ adœke kœsœ gee sœ ugurutœ azu, gbambanœ nene, Ndjaba œ e endje agbolo nœ ye! ");
INSERT INTO mnh_vpl VALUES ("MT5_10","070_5_10","MAT","5","10","10","Yanga nœ endjeneke á endje sœ kœmbœrœ œrœ kanga fœ endje mbœrœ œneke á sœ ndjii; gbambanœ nene, Ogo gbozu nœ tshalafo sœ mbœrœ endje! ");
INSERT INTO mnh_vpl VALUES ("MT5_11","070_5_11","MAT","5","11","11","Yanga nœ 'e œ kœsœ adœke azu gu 'e, œ mbœrœ œrœ kanga fœ 'e yé œ pa tshelœ áká ekpe o'o kɔ ga tœ 'e mbœrœ upu nœ mœ. ");
INSERT INTO mnh_vpl VALUES ("MT5_12","070_5_12","MAT","5","12","12","'E mɔtœ 'e yé œ sœ dœ egerœ yanga; gbambanœ nene, œrœ tshangbanœ sœ kœkate 'e tœ egerœnœ ɓa lafo. Kolœ dœ maranœ ataa, endje mbœrœ ndje lima œrœ kanga fœ aayi kœgbara o'o á endje sœ lima utshu 'e.» ");
INSERT INTO mnh_vpl VALUES ("MT5_13","070_5_13","MAT","5","13","13","«E'e kœdœ ɨngbɨrɨ tshapashɔ. Kashe œ kœsœ adœke kœnga ɨngbɨrɨ ka lœnœ ye, endje kpa gi ga lœnœ koto o? Endje kpa li kœmbœrœ tœnœ dœ akwa bale nene. Endje za va e ga ushu, yé azu œ na pa nœ dœ ada endje. ");
INSERT INTO mnh_vpl VALUES ("MT5_14","070_5_14","MAT","5","14","14","«E'e kœdœ ɨngbɨsho tshapashɔ. Ongbo á sœ ɓa pa kaga, œ li kœzatœ ye yiwa tœnœ nene. ");
INSERT INTO mnh_vpl VALUES ("MT5_15","070_5_15","MAT","5","15","15","Endje tata owo ga tœ miinda mbœrœ kœza ga tshakudu losú nene. Kashe endje za ɓa pa gbarœ kœza miinda ga panœ yekane á kœtshi pa azu kɔ á endje sœ lœ anda. ");
INSERT INTO mnh_vpl VALUES ("MT5_16","070_5_16","MAT","5","16","16","Awa bale ndje, œ li adœke ɨngbɨsho nœ 'e tshi ɓa utshu azu mbœrœ adœke endje wu ɔtshɔrœ á 'e sœ kœmbœrœ tœnœ, yeka á kœdonga Aba 'e á tshe sœ ɓa lafo.» ");
INSERT INTO mnh_vpl VALUES ("MT5_17","070_5_17","MAT","5","17","17","«'E gbegbe adœke mœ na kœwo awa akwa œdœ aayi kœgbara o'o nene. Mœ nana kœwo tœnœ œ wo nene, kashe mœ na adœke œneke á endje pa kœmbœrœtœ endje. ");
INSERT INTO mnh_vpl VALUES ("MT5_18","070_5_18","MAT","5","18","18","Mœ mɨndœ nœ fœ 'e dœ adjapu adœke: Ɓata œndœ tshalafo dœ pe tshapashɔ sœpe kœdɨ tœnœ, tshakanea a'eara uwu mbeti œneke á endje sú ala buku nœ awa akwa œ 'ɨ nene œrrr ga tœ adœke œrœ kɔ mbœrœtœ ye yekane. ");
INSERT INTO mnh_vpl VALUES ("MT5_19","070_5_19","MAT","5","19","19","Mbœrœ tœnœ ataa, œdœ uzu kœvwaratœ ye kœlɨsœ anga awa o'o teasho lœ awa akwanœ asœke yé á sœ kœyisœ nœ fœ anga azu adœke endje mbœrœ ndje awa bale, uzunœ asœmœ œ dœ bala aya uzu ɓa lœ Ogo gbozu nœ tshalafo. Kashe uzu á tshe lɨsœ awa akwanœ yé á yisœ nœ fœ anga azu adœke endje lɨsœ nœ, uzunœ asœmœ œ dœ bala egerœ uzu ɓa lœ Ogo gbozu nœ tshalafo. ");
INSERT INTO mnh_vpl VALUES ("MT5_20","070_5_20","MAT","5","20","20","Mœ sœ kœpa fœ 'e adœke, œdœ 'e kœsœsœ kœmbœrœ œrœ á sœ ndjii kœropa œnœ aayi kœyisœ awa akwa œdœ Afarisayi nene, 'e li kœli ga lœ Ogo gbozu nœ tshalafo nene.» ");
INSERT INTO mnh_vpl VALUES ("MT5_21","070_5_21","MAT","5","21","21","«'E dji adœke endje pa lima fœ aata azœ adœke: “Ɓœ wo uzu nene. Uzu kɔ á tshe wo yanganœ, œ li adœke endje na dœ she ga utshu aayi kœwa ngbanga.”» ");
INSERT INTO mnh_vpl VALUES ("MT5_22","070_5_22","MAT","5","22","22","Yé œmœ, mœ mɨndœ nœ fœ 'e adœke: «Uzu kɔ á tshe kœsœ dœ ókó ga tœ ayanœ, œ li adœke endje na dœ she ɓa utshu aayi kœwa ngbanga. Uzu á tshe kœgu ayanœ adœke: “Wusœrœ wu”, œ li adœke endje na dœ she ɓa lœ anda kœwa ngbanga nœ azu nœ Ndjaba. Uzu á tshe kœgu ayanœ adœke: “Iyi sœ lœ kumu zœ!” Œ li adœke endje vwi she ga lœ lifelo.» ");
INSERT INTO mnh_vpl VALUES ("MT5_23","070_5_23","MAT","5","23","23","Œdœ ɓœ kœna kœkatœ makabo nœ zœ ga pa ndaba fœ Ndjaba, á ɓœ gbetshelœ zœ ɓa zœ adœke aya zœ sœ dœ o'o ga tœ zœ, ");
INSERT INTO mnh_vpl VALUES ("MT5_24","070_5_24","MAT","5","24","24","katœ makabo nœ zœ tɨ kpœtœmœ, ɓa utshu ndabanœ yé œ na utshunœ œ guma tshagurutœ zœ dœ aya zœ, yeka á kœna kœkatœ makabonœ fœ Ndjaba. ");
INSERT INTO mnh_vpl VALUES ("MT5_25","070_5_25","MAT","5","25","25","«Œdœ ɓœ kœsœ dœ upu dœ yanga zœ, pa avwara katsha adœke ɓœ djitœ zœ dœ she damba á 'e sœpe tœ ala awa. Œdœ ɓœ kœmbœmbœrœ ataa nene, tshe za ɓœ ga utshu ayi kœwa ngbanga, ayi kœwa ngbanga œ za ɓœ fœ aprusu, yé aprusunœ œ za ɓœ vwi ga lœ kánga. ");
INSERT INTO mnh_vpl VALUES ("MT5_26","070_5_26","MAT","5","26","26","Mœ mɨndœ nœ fœ ɓœ dœ adjapu adœke, œdœ endje kœvwi ɓœ ga lœ kánga, œrrr ɓœ ko ngendja á endje dɨ fœ ɓœ para kɔkɔ yekane á wuta.» ");
INSERT INTO mnh_vpl VALUES ("MT5_27","070_5_27","MAT","5","27","27","«'E dji o'o á endje pa lima adœke: “Ɓœ para awo uzu nene.” ");
INSERT INTO mnh_vpl VALUES ("MT5_28","070_5_28","MAT","5","28","28","Yé œmœ, mœ mɨndœ nœ fœ 'e adœke: uzu kɔ á tshe kœsœ kœtondœ awo yanganœ dœ ala nœ kœyindœsho, tshe para she ye dœmœ. ");
INSERT INTO mnh_vpl VALUES ("MT5_29","070_5_29","MAT","5","29","29","Yé œdœ ɓœ kœsœ kœli ga lœ ekperœ mangba ala zœ á sœ ga tœ kuni zœ, œ li adœke ɓœ vwata œ za vwi'i lœ ɨngɨrɨnœ tœ zœ. Gbambanœ nene, œ sœ dœ ɔtshɔnœ mbœrœ ɓœ adœke anga œrœ kote zœ bale ndɨ, tœ œsœnœ adœke endje za undu zœ djigi vwi ga lœ lifelo. ");
INSERT INTO mnh_vpl VALUES ("MT5_30","070_5_30","MAT","5","30","30","Œdœ ɓœ kœsœ kœli ga lœ ekperœ mangba kuni zœ, œ li adœke ɓœ de œ za vwi'i lœ ɨngɨrɨnœ tœ zœ. Gbambanœ nene, œ sœ dœ ɔtshɔnœ mbœrœ ɓœ adœke anga tshakala kane zœ bale ndɨ, tœ œsœnœ adœke endje za undu zœ djigi vwi ga lœ lifelo.» ");
INSERT INTO mnh_vpl VALUES ("MT5_31","070_5_31","MAT","5","31","31","«Endje kpa pa lima adœke: “Œdœ uzu kœkatœ awonœ tɨ, œ li adœke tshe za mbeti kœkurutshelœ totœ fœ she.” ");
INSERT INTO mnh_vpl VALUES ("MT5_32","070_5_32","MAT","5","32","32","Yé œmœ, mœ mɨndœ nœ fœ 'e adœke: Uzu kɔ á tshe katœ awonœ tɨ mbœrœ á tshe mbœrœ angba budu tshakane ye nene, tshe vwa yashenœ asœmœ ndœ kœmbœrœ angba budu. Yé uzu kɔ á tshe to yashe á akɔnœ katœ ye tɨ, tshe mbœrœ ndje angba budu dœ yashenœ asœmœ.» ");
INSERT INTO mnh_vpl VALUES ("MT5_33","070_5_33","MAT","5","33","33","«'E kpa dji o'o á endje pa lima fœ aata azœ. Endje pa lima adœke: “Wawa ɨgɨ zœ ndœ wala nene, kashe mbœrœ œrœ á ɓœ wa ɨgɨ zœ ɓa utshu Gbozu Ndjaba tœ upunœ.” ");
INSERT INTO mnh_vpl VALUES ("MT5_34","070_5_34","MAT","5","34","34","Yé œmœ, mœ pa fœ 'e adœke 'e wawa ɨgɨ 'e bale nene. 'E wawa dœ ɨ'ɨrɨ tshalafo nene; gbambanœ nene, œtœnœ kœdœ ngande tshagbozu nœ Ndjaba. ");
INSERT INTO mnh_vpl VALUES ("MT5_35","070_5_35","MAT","5","35","35","'E wawa ɨgɨ 'e dœ ɨ'ɨrɨ ɔshɔ nene; gbambanœ nene, œtœnœ kœdœ osho kœsœ á Ndjaba œ ko ada ye ga tœnœ. 'E wawa ɨgɨ 'e dœ ɨ'ɨrɨ Yerusaleme nene; gbambanœ nene, œtœnœ kœdœ ongbo nœ egerœ Gbozugo. ");
INSERT INTO mnh_vpl VALUES ("MT5_36","070_5_36","MAT","5","36","36","Adja wawa ɨgɨ zœ bale dœ kumu zœ nene; gbambanœ nene, ɓœ li kœmbœrœ adœke anga sukumu zœ bale wuta tœ imbinœ too tœ ubunœ nene. ");
INSERT INTO mnh_vpl VALUES ("MT5_37","070_5_37","MAT","5","37","37","Pa kolœnœ “Œ̃” œ kœdœ “Œ̃”, yé “œ̃œ̃” œ kœdœ “œ̃œ̃”. Œneke kɔ á ɓœ kpa ko ga pa nœ asœmœ, œ to ɓa ndœ Satana.» ");
INSERT INTO mnh_vpl VALUES ("MT5_38","070_5_38","MAT","5","38","38","«'E dji œneke á endje pa lima adœke: “Uzu kœsu ala zœ, ɓœ su ndje ala ye; yé uzu kœkɔ iji zœ, ɓœ kɔ ndje iji ye.” ");
INSERT INTO mnh_vpl VALUES ("MT5_39","070_5_39","MAT","5","39","39","Yé œmœ, mœ pa fœ 'e adœke 'e gigi ekperœ fœ uzu á tshe mbœrœ ekperœ fœ 'e nene. Œdœ uzu kœda baga zœ ga tœ kuni, fa œnœ gele fœ she yé tshe kpa da ndje. ");
INSERT INTO mnh_vpl VALUES ("MT5_40","070_5_40","MAT","5","40","40","Œdœ uzu kœtɔ meza pa zœ fœ ayi kœwa ngbanga adœke œne za lœba okoro nœ zœ tœ zœ ye, ka ndje tœ yɔgbɔdɔ lœba nœ zœ tɨ fœ she yé tshe za ndje. ");
INSERT INTO mnh_vpl VALUES ("MT5_41","070_5_41","MAT","5","41","41","Œdœ uzu kœza ɓœ dœ ɔgbɔ adœke ɓœ za gbarœ œ gi dœ œne mangba uwu ada kutu bale, za gbarœnœ œ gi dœ she mangba uwu ada kutu bisha. ");
INSERT INTO mnh_vpl VALUES ("MT5_42","070_5_42","MAT","5","42","42","To œrœ fœ uzu á tshe esho ndœ œrœ tœ zœ. Œdœ uzu kœ'esho ndœ kuɗa ɓa ndœ zœ, vwavwaratœ zœ tœ kœza fœ she nene.» ");
INSERT INTO mnh_vpl VALUES ("MT5_43","070_5_43","MAT","5","43","43","«'E dji œneke á endje pa lima adœke: “Yindœ yanga zœ yé œ yiangba yingba zœ.” ");
INSERT INTO mnh_vpl VALUES ("MT5_44","070_5_44","MAT","5","44","44","Yé œmœ, mœ pa fœ 'e adœke 'e yindœ ayingba 'e, yé œ za avwala fœ Ndjaba mbœrœ endjeneke á endje sœ kœmbœrœ œrœ kanga fœ 'e, ");
INSERT INTO mnh_vpl VALUES ("MT5_45","070_5_45","MAT","5","45","45","yeka á 'e kœwuta agbolo nœ Aba 'e á tshe sœ ɓa lafo. Gbambanœ nene, tshe sœ kœmbœrœ adœke ɔlɔ nœ ye tɔ ga pa aayi kœmbœrœ ekperœ dœ aayi kœmbœrœ ɔtshɔrœ. Tshe sœ kœmbœrœ ndje adœke yavuru ni ga pa azu á endje sœ ndjii dœ azu á endje sœsœ ndjii nene. ");
INSERT INTO mnh_vpl VALUES ("MT5_46","070_5_46","MAT","5","46","46","Gbambanœ nene, œdœ 'e kœyi kolœ ndœ azu á endje yindœ 'e, œrœ tshangbanœ á 'e gbɔ kœdœ gaɗe? Aayi kœko ngendja lapo mbœmbœrœ ndje dœ tœ endje atamœ nene a? ");
INSERT INTO mnh_vpl VALUES ("MT5_47","070_5_47","MAT","5","47","47","Œdœ 'e kœsœ kœbala kolœ aaya 'e, 'e gbe adœke 'e mbœrœ egerœ œrœ a? Azu á endje wuwusœ Ndjaba nene mbœmbœrœ ndje atamœ nene a? ");
INSERT INTO mnh_vpl VALUES ("MT5_48","070_5_48","MAT","5","48","48","Ataa, Aba 'e ɓa lafo sœ yerœ, e'e ndje 'e sœ ɓata she.» ");
INSERT INTO mnh_vpl VALUES ("MT6_1","070_6_1","MAT","6","1","1","«Ala 'e gbɔ tœ mara á 'e sœ kœmbœrœ dœ akwa nœ Ndjaba tœ ala azu kane. 'E mbœmbœrœ ɔtshɔrœ á Ndjaba yindœ nœ kolœ adœke azu wu 'e nene. Œdœ 'e kœmbœrœ ataa, 'e gbɔ œrœ tshangba nœ ɓa ndœ Aba 'e á tshe sœ ɓa lafo asœmœ nene. ");
INSERT INTO mnh_vpl VALUES ("MT6_2","070_6_2","MAT","6","2","2","Ataa, lɔkɔ á ɓœ kœto œrœ fœ ayi oyo, ɓiɓi dœ itshi adœke ala azu kɔ sœ ga tœ zœ nene, ɓata á awulapatshɔ œ mbœrœ ɓa lœ Sinagoga œdœ ɓa tœ ala awa. Endje sœ kœmbœrœ ataa adœke azu donga œne. Mœ mɨndœ nœ dœ adjapu fœ 'e adœke: Endje gbɔ œrœ tshangba œnœ endje ye. ");
INSERT INTO mnh_vpl VALUES ("MT6_3","070_6_3","MAT","6","3","3","Kashe œɓœ, œdœ ɓœ kœto œrœ fœ ayi oyo, mbœmbœrœ adœke gele zœ wusœ œneke á kuni zœ mbœrœ nene. ");
INSERT INTO mnh_vpl VALUES ("MT6_4","070_6_4","MAT","6","4","4","Ataa, œ li adœke œrœnœ á ɓœ to asœmœ sœpe lœ ubunœ. Yé Aba zœ á tshe wu œrœ á mbœrœtœ endje lœ ubunœ, œ gi œrœ tshangbanœ fœ ɓœ.» ");
INSERT INTO mnh_vpl VALUES ("MT6_5","070_6_5","MAT","6","5","5","«Œdœ 'e kœsœ kœza avwala fœ Ndjaba, 'e sœsœ ɓata awulapatshɔ nene. Endje yindœ nœ adœke œne li ɓa lœ Sinagoga too œne wuta ɓa lœ shangbeda awa, œ ka dœ ada œne yeka á kœza avwala adœke azu kɔ kœwu œne. Mœ pa fœ 'e dœ adjapu adœke: Endje gbɔ œrœ tshangba œnœ endje ye. ");
INSERT INTO mnh_vpl VALUES ("MT6_6","070_6_6","MAT","6","6","6","Kashe œɓœ, œdœ ɓœ kœyindœ kœza avwala, li ga lœ gbɔshɔ nœ zœ œ tshu manda ga tœnœ, yé œ za avwala fœ Aba zœ á tshe sœ ɓa zœ ɓa tœ osho á sœ lœ ubunœ. Yé Aba zœ á tshe wusœ œrœ kɔ á sœ lœ ubunœ, œ gi œrœ tshangba nœ fœ ɓœ.» ");
INSERT INTO mnh_vpl VALUES ("MT6_7","070_6_7","MAT","6","7","7","«Œdœ 'e kœsœ kœza avwala, 'e papa o'o œrrr ɓata azu á endje wuwusœ Ndjaba nene œ pa. Endje sœ kœgbe adœke œdœ œne kœpa o'o œrrr dá Ndjaba œ dji œne dœ ɔtshɔnœ. ");
INSERT INTO mnh_vpl VALUES ("MT6_8","070_6_8","MAT","6","8","8","'E mbœmbœrœ ɓata endje nene; gbambanœ nene, Aba 'e wusœ œneke á 'e sœ dœ ogonœ utshunœ adœke 'e yu she tœnœ. ");
INSERT INTO mnh_vpl VALUES ("MT6_9","070_6_9","MAT","6","9","9","'E wu mara á li adœke 'e za dœ avwala: “Aba 'a á ɓœ sœ ɓa lafo, kaka azu kɔ wusœ nœ adœke ɨ'ɨrɨ zœ sœ yerœ. ");
INSERT INTO mnh_vpl VALUES ("MT6_10","070_6_10","MAT","6","10","10","Kaka Ogo gbozu nœ zœ na, kaka gbetshelœ nœ zœ mbœrœtœ endje ɓa pa ɔshɔ ɓata á mbœrœtœ endje ɓa lafo. ");
INSERT INTO mnh_vpl VALUES ("MT6_11","070_6_11","MAT","6","11","11","To rœgo á li adœke 'a zɨ kpesheke fœ 'a. ");
INSERT INTO mnh_vpl VALUES ("MT6_12","070_6_12","MAT","6","12","12","Djerœndœ ekperœ nœ 'a, ɓata 'a djerœ ndje ndœ ekperœ nœ endjeneke á endje mbœrœ fœ 'a. ");
INSERT INTO mnh_vpl VALUES ("MT6_13","070_6_13","MAT","6","13","13","Yé kakatœ 'a tɨ adœke 'a li ga lœ kœwu lɔsu nene, kashe vwara 'a lœ ekperœ. Gbambanœ nene, œɓœ kœdœ Gbozu, á ɓœ sœ dœ gbɔgbɔ œdœ mokɔ waa dœ waa. Ame.” ");
INSERT INTO mnh_vpl VALUES ("MT6_14","070_6_14","MAT","6","14","14","«Yé œdœ 'e kœdjerœndœ ekperœ nœ azu, Aba 'e á tshe sœ ɓa lafo œ djerœ ndje ndœ ekperœ nœ 'e. ");
INSERT INTO mnh_vpl VALUES ("MT6_15","070_6_15","MAT","6","15","15","Kashe œdœ 'e kœdjedjerœndœ ekperœ nœ azu nene, Aba 'e œ djerœndœ ekperœ nœ 'e á 'e mbœrœ bale nene.» ");
INSERT INTO mnh_vpl VALUES ("MT6_16","070_6_16","MAT","6","16","16","«Lɔkɔ á 'e kœsœ kœyotshelœma 'e, 'e sœsœ dœ oyo ɓata á awulapatshɔ œ mbœrœ nene. Endje sœ kœndɨ tshatshu endje dœ mara adœke azu kɔ wusœ nœ adœke œne sœ kœyotshelœma œne. Mœ mɨndœ nœ fœ 'e dœ adjapu adœke: Endje gbɔ œrœ tshangba œnœ endje ye. ");
INSERT INTO mnh_vpl VALUES ("MT6_17","070_6_17","MAT","6","17","17","Kashe œɓœ, œdœ ɓœ kœsœ kœyotshelœma zœ, djutɔ tshatshu zœ, yé œ da kada, ");
INSERT INTO mnh_vpl VALUES ("MT6_18","070_6_18","MAT","6","18","18","mbœrœ azu kœwuwusœ nœ adœke ɓœ sœ kœyotshelœma zœ nene. Kashe kolœ Aba zœ á tshe sœ ɓa zœ lœ ubunœ, œshe dá wusœ nœ. Œdœ ɓœ kœmbœrœ ataa, Aba zœ á tshe wu œrœ á sœ lœ ubunœ asœmœ, œ to œrœ tshangbanœ fœ ɓœ.» ");
INSERT INTO mnh_vpl VALUES ("MT6_19","070_6_19","MAT","6","19","19","«'E ngbɔngbɔɓa kœgbɔrœ tshapashɔ asœke nene. Gbambanœ nene, ɓa zœ akɔkɔ œ zɨ, ngbandji œ ndɨ kotenœ yé aayi angba œ kavwa manda œ zɨangba nœ ye. ");
INSERT INTO mnh_vpl VALUES ("MT6_20","070_6_20","MAT","6","20","20","Kashe 'e ngbɔɓa kœgbɔrœ ɓa lafo. Gbambanœ nene, ɓa zœ œdœ akɔkɔ œ zɨ nene, œdœ ngbandji œ ndɨ nene, yé aayi angba gugu ndje tœ kœkavwa manda á kœzɨ angbanœ nene. ");
INSERT INTO mnh_vpl VALUES ("MT6_21","070_6_21","MAT","6","21","21","Gbambanœ nene, osho á kœgbɔrœ nœ zœ sœ tœnœ, lɔsu zœ œ sœ ndje kpœtœmœ.» ");
INSERT INTO mnh_vpl VALUES ("MT6_22","070_6_22","MAT","6","22","22","«Ala uzu kœdœ miinda nœ undu ye. Œdœ ala zœ kœsœ dœ ɔtshɔnœ, undu zœ djigi œ sœ lœ ɨngbɨsho. ");
INSERT INTO mnh_vpl VALUES ("MT6_23","070_6_23","MAT","6","23","23","Kashe œdœ ala zœ kœsœ dœ koɓa, undu zœ djigi œ sœ lœ ubu osho. Ataa, œdœ ɨngbɨsho á sœ lœ zœ kœdœ ubu osho, ubu oshonœ asœmœ kpa sœ narɨ!» ");
INSERT INTO mnh_vpl VALUES ("MT6_24","070_6_24","MAT","6","24","24","«Uzu bale lili kœmbœrœ akwa fœ agbozu bisha nene. Gbambanœ nene, œdœ tshe kœyiangba anga bale, tshe yindœ udu anga. Tshe kœzatœ ye fœ anga bale, tshe tɨtœ ye tœ udu anga. 'E lili kœmbœrœ akwa fœ Ndjaba yé œ kpa za ndje tœ 'e fœ ngendja nene.» ");
INSERT INTO mnh_vpl VALUES ("MT6_25","070_6_25","MAT","6","25","25","«'E wu ádánœ á mœ mɨndœ nœ fœ 'e adœke: 'E zaza lɔsu 'e ga lafo tœ upu nœ kœzɨrœ œdœ kœndjorœ á 'e gbe dœ tœnœ mbœrœ soro 'e nene, too kœgbe dœ lœba á 'e yindœ kœverœ ga tœ kote 'e nene. Soro uzu roropa kœzɨrœ nene a? Yé undu uzu roropa lœba nene a? ");
INSERT INTO mnh_vpl VALUES ("MT6_26","070_6_26","MAT","6","26","26","'E tondœ ayanu kane. Endje lulu ngwarœ nene, œ kɔkɔ ndje œrœ nene yé œ gugu dœ kogba kœgumasœ rœgo ga lœnœ nene, kashe Aba 'e á tshe sœ ɓa lafo sœ kœto kœzɨrœ fœ endje. 'E roropa endje nene a? ");
INSERT INTO mnh_vpl VALUES ("MT6_27","070_6_27","MAT","6","27","27","Œɗe ugurutœ 'e, lœ kœgbetshelœ ye, dá li kœza anga olo bale ga pa olo soro ye a? ");
INSERT INTO mnh_vpl VALUES ("MT6_28","070_6_28","MAT","6","28","28","«Yé mbœrœ gaɗe á 'e sœ kœza lɔsu 'e ga lafo tœ upu nœ lœba a? 'E wu mara á ndɔkɔ leyɔ œ wuta dœ tœnœ ɓa lœ kɨndɨ kane: Œ sœ kœmbœrœ akwa nene, œ sœ ndje kœsu lœba nene. ");
INSERT INTO mnh_vpl VALUES ("MT6_29","070_6_29","MAT","6","29","29","Kashe mœ pa fœ 'e adœke, Salomo á tshe dœ́ lima ayi kœgbɔrœ waa, veverœ lima lœba bale ɓata anga ndɔkɔ leyɔnœ asœke nene. ");
INSERT INTO mnh_vpl VALUES ("MT6_30","070_6_30","MAT","6","30","30","Ndjaba dá verœ lœba kpesheke ga tœ gusu á sœ lœ kɨndɨ yé ɓa mbatsha owo œ ju. Œdœ Ndjaba kœmbœrœ ataa ga tœ a'eara ɔyɔ, tshe lili kœko lœba fœ 'e kœropa nœ nene a? E'e kœdœ azu á kœyindœrœ nœ 'e sœ teasho! ");
INSERT INTO mnh_vpl VALUES ("MT6_31","070_6_31","MAT","6","31","31","'E zaza lɔsu 'e ga lafo tœ kœyutœ 'e nene adœke: “'A zɨ gaɗe? 'A ndjo gaɗe? 'A verœ lœba gaɗe?” ");
INSERT INTO mnh_vpl VALUES ("MT6_32","070_6_32","MAT","6","32","32","Azu á endje wuwusœ Ndjaba nene dá para œrœnœ asœmœ kɔ. Kashe Aba 'e á tshe sœ ɓa lafo wusœ nœ adœke 'e gbe dœ tœnœ kɔ. ");
INSERT INTO mnh_vpl VALUES ("MT6_33","070_6_33","MAT","6","33","33","'E para utshunœ Ogo gbozu nœ Ndjaba, œdœ œrœ á sœ ndjii ɓa utshu Ndjaba, yé udu œrœ kɔkɔ, Ndjaba œ to fœ 'e. ");
INSERT INTO mnh_vpl VALUES ("MT6_34","070_6_34","MAT","6","34","34","Ataa, 'e zaza lɔsu 'e ga lafo tœ upu nœ œrœ á mbœrœtœ endje ɓa mbatsha nene. Tshambatsha sœ ndje dœ upu nœ ye. Olo bale dœ bale sœ dœ o'o nœ ye.» ");
INSERT INTO mnh_vpl VALUES ("MT7_1","070_7_1","MAT","7","1","1","«'E wawa ngbanga pa uzu bale nene, mbœrœ á Ndjaba kœwawa ndje ngbanga pa 'e nene. ");
INSERT INTO mnh_vpl VALUES ("MT7_2","070_7_2","MAT","7","2","2","Gbambanœ nene, Ndjaba œ wa ngbanga pa 'e ɓata á 'e wa ga pa anga 'e. Adja mara œrœ á 'e li dœ anga 'e dá tshe li ndje dœ 'e. ");
INSERT INTO mnh_vpl VALUES ("MT7_3","070_7_3","MAT","7","3","3","Mbœrœ gaɗe á ɓœ sœ kœtondœ oforo ebe á sœ lœ ala aya zœ yé á gbegbe dœ maɓaya á sœ lœ ala zœ nene a? ");
INSERT INTO mnh_vpl VALUES ("MT7_4","070_7_4","MAT","7","4","4","Koto á ɓœ pa fœ aya zœ adœke: “Kaka mœ tshakavwa oforo ebe á sœ lœ ala zœ”, andaa maɓaya sœ lœ œnœ zœ a? ");
INSERT INTO mnh_vpl VALUES ("MT7_5","070_7_5","MAT","7","5","5","Wulapatshɔ, tshakavwa maɓaya á sœ lœ ala zœ asœmœ utshunœ œ wu osho ngbɨ yeka á kœtshakavwa oforo ebe á sœ lœ ala aya zœ. ");
INSERT INTO mnh_vpl VALUES ("MT7_6","070_7_6","MAT","7","6","6","«'E toto œrœ neke á sœ yerœ fœ ayavoro nene. Œdœ 'e kœmbœrœ ataa, endje fatshelœtœ endje tœ 'e œ lo 'e. 'E koko agbɔ œrœ tshelœ ɨgɨ nœ 'e va fœ akɔso nene kparawa adœke endje kœzurutshelœ nœ nene.» ");
INSERT INTO mnh_vpl VALUES ("MT7_7","070_7_7","MAT","7","7","7","«'E kœyɔndœ œrœ, endje to fœ 'e ye; 'e kœpara œrœ, 'e gbɔ ye; 'e kœnge manda, endje kɔrɔ fœ 'e ye. ");
INSERT INTO mnh_vpl VALUES ("MT7_8","070_7_8","MAT","7","8","8","Gbambanœ nene, uzu kɔ á tshe yɔndœ œrœ, endje to fœ she; tsheneke á tshe para œrœ, tshe gbɔ; yé tsheneke á tshe nge manda, endje kɔrɔ fœ she. ");
INSERT INTO mnh_vpl VALUES ("MT7_9","070_7_9","MAT","7","9","9","Œɗe ugurutœ 'e dá za badja fœ gbolo nœ ye œdœ tshe kœyɔndœ kœzɨrœ a? ");
INSERT INTO mnh_vpl VALUES ("MT7_10","070_7_10","MAT","7","10","10","Too œdœ tshe kœyu she ndœ ageatshalangu, tshe za yakoro fœ she a? ");
INSERT INTO mnh_vpl VALUES ("MT7_11","070_7_11","MAT","7","11","11","Ataa, œdœ 'e á 'e dœ akpe azu, 'e wusœ kœto ɔtshɔrœ fœ agbolo nœ 'e, yekane Aba 'e á tshe sœ ɓa lafo kœtoto ɔtshɔrœ fœ endjeneke á endje yɔndœ nœ ɓa ndœ ye nene a? ");
INSERT INTO mnh_vpl VALUES ("MT7_12","070_7_12","MAT","7","12","12","«'E mbœrœ fœ anga 'e ɓata œneke á 'e yindœ nœ adœke endje mbœrœ fœ 'e. Asœ kœdœ œneke á awa akwa œdœ aayi kœgbara o'o nœ Ndjaba yisœ nœ.» ");
INSERT INTO mnh_vpl VALUES ("MT7_13","070_7_13","MAT","7","13","13","«'E li tœ aya manda. Gbambanœ nene, manda kœro ga ndœ kuzu sœ tœ egerœnœ, awa kœ li ga zœ sœ ndje ngbɨ yé azu á endje ro tœnœ lœ ndjoro. ");
INSERT INTO mnh_vpl VALUES ("MT7_14","070_7_14","MAT","7","14","14","Kashe manda nœ soro á ka nene sœ teasho, awa á ro ga zœ mi dœ gusu yé azu kœro tœnœ mɨmɨ.» ");
INSERT INTO mnh_vpl VALUES ("MT7_15","070_7_15","MAT","7","15","15","«'E sœ dœ gbɔdjela tœ aayi kœgbara o'o nœ wala. Gbambanœ nene, endje sœ kœna ga ndœ 'e ɓata apata kashe lɔsu endje sœ ɓata lɔsu amuru á endje wo osho. ");
INSERT INTO mnh_vpl VALUES ("MT7_16","070_7_16","MAT","7","16","16","'E wusœ endje mbœrœ akwa tshelœ endje. Gbambanœ nene, endje kɔkɔ ɔtshɔ leyɔ ɓa tœ ekpe ɔyɔ nene, endje kɔkɔ ndje ele fige ɓa tœ batima nene. ");
INSERT INTO mnh_vpl VALUES ("MT7_17","070_7_17","MAT","7","17","17","Ɔtshɔ ɔyɔ kɔ sœ kœzu ɔtshɔ elenœ, yé ɔyɔ á sœ dœ koɓa sœ kœzu ndje elenœ tœ ekpenœ. ");
INSERT INTO mnh_vpl VALUES ("MT7_18","070_7_18","MAT","7","18","18","Ɔtshɔ ɔyɔ lili kœzu elenœ tœ ekpenœ nene, yeka ɔyɔ á sœ dœ koɓa œ zu ndje ɔtshɔ elenœ nene. ");
INSERT INTO mnh_vpl VALUES ("MT7_19","070_7_19","MAT","7","19","19","Ɔyɔ kɔ á elenœ kœgaga nene, endje de yé œ ko va ga tœ owo. ");
INSERT INTO mnh_vpl VALUES ("MT7_20","070_7_20","MAT","7","20","20","Ataa, 'e wusœ aayi kœgbara o'o nœ wala mbœrœ akwa tshelœ endje.» ");
INSERT INTO mnh_vpl VALUES ("MT7_21","070_7_21","MAT","7","21","21","«Œ dœ́dœ́ uzu kɔ á tshe e mœ adœke: “Gbozu, Gbozu”, dá li ga lœ Ogo gbozu nœ tshalafo nene, kashe kolœ endjeneke á endje sœ kœmbœrœ œrœ á Aba mœ á tshe sœ ɓa lafo yindœ nœ, dá li ga zœ. ");
INSERT INTO mnh_vpl VALUES ("MT7_22","070_7_22","MAT","7","22","22","Dœ lɔkɔnœ asœmœ, azu ndjoro œ pa bala adœke: “Gbozu, Gbozu”, 'a gbara lima o'o dœ ɨ'ɨrɨ zœ; 'a gɔrɔ lima ekpe ɨshirɨ dœ ɨ'ɨrɨ zœ; 'a mbœrœ lima afá ndjoro dœ ɨ'ɨrɨ zœ! ");
INSERT INTO mnh_vpl VALUES ("MT7_23","070_7_23","MAT","7","23","23","Yé mœ pa bala ngbɨ fœ endje adœke: “Mœ wuwusœ 'e bale nene, e'e dœ́ aayi kœmbœrœ ekperœ, 'e gitœ 'e tœ ala mœ!”» ");
INSERT INTO mnh_vpl VALUES ("MT7_24","070_7_24","MAT","7","24","24","Yisu kpa pa adœke: «Uzu kɔ á tshe kœdji o'o á mœ totœ kœpa tœnœ asœke yé á za ga tœ akwa, tshe sœ ɓata uzu nœ kœwusœrœ á tshe mɔ anda nœ ye ga pa badja. ");
INSERT INTO mnh_vpl VALUES ("MT7_25","070_7_25","MAT","7","25","25","Yavuru ni, ungu sú yé egerœ yugu na œ za kpɨkpɨkpɨ, kashe andanœ tete nene. Gbambanœ nene, endje mɔ lima kiti andanœ ga pa badja. ");
INSERT INTO mnh_vpl VALUES ("MT7_26","070_7_26","MAT","7","26","26","Kashe uzu kɔ á tshe kœdji o'o á mœ totœ kœpa tœnœ asœke yé á kœzaza ga tœ akwa nene, tshe sœ ɓata ayi ɨndɨ á tshe mɔ anda nœ ye ga pa mindu. ");
INSERT INTO mnh_vpl VALUES ("MT7_27","070_7_27","MAT","7","27","27","Yavuru ni, ungu sú, egerœ yugu na œ za andanœ yé œ kavwa 'uru ga atɨ.» ");
INSERT INTO mnh_vpl VALUES ("MT7_28","070_7_28","MAT","7","28","28","Lɔkɔ á Yisu yi lima sœ œrœnœ á ka, azu kɔ ka lima tœ ama ndje tɨ ɔsɔ tœ mara kœyisœrœ nœ ye. ");
INSERT INTO mnh_vpl VALUES ("MT7_29","070_7_29","MAT","7","29","29","Gbambanœ nene, tshe yiyi lima sœ œrœ ɓata aayi kœyisœ awa akwa nœ endje nene, kashe tshe yi lima sœ nœ ɓata uzu á tshe sœ dœ tshagbozu. ");
INSERT INTO mnh_vpl VALUES ("MT8_1","070_8_1","MAT","8","1","1","Yisu sœ lima kœtara kaga gu tœnœ yé ukpulu azu sœ kœna manda ye. ");
INSERT INTO mnh_vpl VALUES ("MT8_2","070_8_2","MAT","8","2","2","Yé anga ayi boroma bale gitœ ye ndoo dœ she œ gote ga utshu ye, œ pa adœke: «Gbozu, œdœ ɓœ kœyindœ nœ, ɓœ mbœrœ adœke mœ wuta yerœ.» ");
INSERT INTO mnh_vpl VALUES ("MT8_3","070_8_3","MAT","8","3","3","Yisu yi kane ye, œ goro she yé œ pa adœke: «Mœ yindœ nœ adœke ɓœ wuta yerœ ye.» Petœ œsœnœ, tshe wuta yerœ lœ boroma nœ ye. ");
INSERT INTO mnh_vpl VALUES ("MT8_4","070_8_4","MAT","8","4","4","Yé Yisu kœpa fœ she adœke: «Mesho! Papandœ nœ fœ uzu bale nene. Kashe gu œ matœ zœ fœ nganga Ndjaba yé œ to tokóró ɓata á Moyize pa lima ndœ nœ, mbœrœ kœma fœ azu kɔ adœke ɓœ wuta yerœ ye.» ");
INSERT INTO mnh_vpl VALUES ("MT8_5","070_8_5","MAT","8","5","5","Lɔkɔ á Yisu sœ lima kœli ga lœ Kaparnawumu, anga gbozu tshapa aturugu tshelœ Roma na ndoo dœ she œ kɨ fœ she ");
INSERT INTO mnh_vpl VALUES ("MT8_6","070_8_6","MAT","8","6","6","adœke: «Gbozu, ayi akwa nœ mœ lo ɓa sœnda, ada ye tshu tshakudu ye yé tshe sœ kœwu oyo tɔpanœ kpuru.» ");
INSERT INTO mnh_vpl VALUES ("MT8_7","070_8_7","MAT","8","7","7","Yisu pa fœ she adœke: «A gu dœ́ mœ she she.» ");
INSERT INTO mnh_vpl VALUES ("MT8_8","070_8_8","MAT","8","8","8","Kashe gbozu tshapa aturugunœ gi adœke: «Gbozu, mœ sœsœ ɓata azu á ɓœ li anda nœ endje nene. Œdœ ɓœ kœyindœ nœ, pa kolœ o'o bale, ayi akwa nœ mœ œ she ye. ");
INSERT INTO mnh_vpl VALUES ("MT8_9","070_8_9","MAT","8","9","9","Gbambanœ nene, œmœ ndje, mœ sœ dœ agbozu tshapa mœ yé mœ dœ́ ndje gbozu tshapa aturugu. Œdœ mœ kœpa fœ anga bale adœke: “Na”, ngbewo tshe na. Œdœ mœ kpa kœpa fœ anga adœke: “Na ga mœ”, ngbewo tshe na ga ndœ mœ. Yé œdœ mœ kœpa fœ anga ayi akwa nœ mœ adœke “mbœrœ œneke”, ngbewo tshe mbœrœ.» ");
INSERT INTO mnh_vpl VALUES ("MT8_10","070_8_10","MAT","8","10","10","Lɔkɔ á yisu dji o'o á gbozu tshapa aturugu sœmœ pa, tshe katœ ama ye tɨ ɔsɔ œ pa fœ azu á endje sœ lima kœna manda ye adœke: «Mœ sœ kœmɨndœ nœ fœ 'e dœ adjapu adœke, mœ gbɔgbɔ anga mara kœyindœrœ asœke ndœ anga uzu bale lœ Israyele nene. ");
INSERT INTO mnh_vpl VALUES ("MT8_11","070_8_11","MAT","8","11","11","Mœ sœ kœpa ndje fœ 'e adœke, azu ndjoro œ to ɓa tœ osho á ɔlɔ œ wuta tœnœ œdœ ɓa tœ osho á ɔlɔ œ li tœnœ, yé œ gbɔ osho kœsœ ɓa pa ndaba ɓa lœ Ogo gbozu nœ tshalafo awa bale dœ Abrayamo, dœ Izaka œdœ pe Yakobo. ");
INSERT INTO mnh_vpl VALUES ("MT8_12","070_8_12","MAT","8","12","12","Kashe endjeneke á li ma lima adœke endje kœli ga lœ Ogo gbozu nœ Ndjaba, endje vwi endje ga lœ ubu osho ɓa shu. Yé ɓa zœ, endje kɨ œ zɨ tshelœ daji endje.» ");
INSERT INTO mnh_vpl VALUES ("MT8_13","070_8_13","MAT","8","13","13","Yé Yisu kœpa fœ gbozu tshapa aturugunœ adœke: «Gu ga ndœ zœ, Ndjaba mbœrœ œneke á ɓœ yɔndœ nœ liaka kœyindœrœ nœ zœ ye.» Yé kolœ dœ ada ɔlɔnœ asœmœ, ayi akwa nœ gbozu tshapa aturugu she ye. ");
INSERT INTO mnh_vpl VALUES ("MT8_14","070_8_14","MAT","8","14","14","Manda nœ, Yisu na ɓa lœ anda nœ Petro, œ gbɔ ayi mbeyanœ, tshe lo ga atɨ dœ koɓa biwa. ");
INSERT INTO mnh_vpl VALUES ("MT8_15","070_8_15","MAT","8","15","15","Tshe za kane ye, yé koɓa biwanœ katœ ye yé. Ayi mbeya Petro áafo œ tetœ kœmbœrœ akwa fœ Yisu. ");
INSERT INTO mnh_vpl VALUES ("MT8_16","070_8_16","MAT","8","16","16","Dœ lɔndɔ á ɔlɔ li, endje na dœ azu ndjoro á ekpe ɨshirɨ sœ pa endje fœ Yisu. Tshe gɔrɔ ekpe ɨshirɨ pa azunœ asœmœ dœ o'o ama ye, yé œ she ndje anga aayi koɓa kɔ. ");
INSERT INTO mnh_vpl VALUES ("MT8_17","070_8_17","MAT","8","17","17","Tshe mbœrœ lima ataa mbœrœ o'onœ á Isaya ayi kœgbara o'o nœ Ndjaba pa lima kœmbœrœtœ endje. Tshe pa lima adœke: «Œshe dá ko gbakɨndɨ nœ azœ yé á ko koɓa nœ azœ ga pa ye.» ");
INSERT INTO mnh_vpl VALUES ("MT8_18","070_8_18","MAT","8","18","18","Lɔkɔ á Yisu wu ukpulu azu á endje ndɨvwɨrɨ lima she, tshe za o'o fœ ayambarœ nœ ye adœke œne zu ɓa ɨtshi egerœ ungu adanga. ");
INSERT INTO mnh_vpl VALUES ("MT8_19","070_8_19","MAT","8","19","19","Anga ayi kœyisœ awa akwa gitœ ye ndoo œ pa fœ she adœke: «Ayi kœyisœrœ, mœ na manda zœ tœ osho kɔ á ɓœ na tœnœ.» ");
INSERT INTO mnh_vpl VALUES ("MT8_20","070_8_20","MAT","8","20","20","Yisu gi fœ she adœke: «Angbangewo sœ dœ anda nœ endje ɓa lœ ɔshɔ, yé ayanu sœ ndje dœ koma endje ɓa lafo, kashe Gbolo nœ uzu gugu dœ osho kœlo tœnœ nene.» ");
INSERT INTO mnh_vpl VALUES ("MT8_21","070_8_21","MAT","8","21","21","Anga yambarœ nœ Yisu bale pa fœ she adœke: «Gbozu, za awa fœ mœ, mœ na œ shi aba mœ utshunœ yekane.» ");
INSERT INTO mnh_vpl VALUES ("MT8_22","070_8_22","MAT","8","22","22","Yé Yisu kœgi fœ she adœke: «Na manda mœ, yé œ katœ akuzu endje shi akuzu nœ endje.» ");
INSERT INTO mnh_vpl VALUES ("MT8_23","070_8_23","MAT","8","23","23","Yisu ɔ ga lœ agba yé ayambarœ nœ ye ro awa bale dœ she. ");
INSERT INTO mnh_vpl VALUES ("MT8_24","070_8_24","MAT","8","24","24","Ngbangi atake, ndavuru yugu za gu tœnœ kpɨkpɨkpɨ pa egerœ ungu adanga, lokonœ na yé ungu yi lima kœtu ga lœ agba. Kashe Yisu lo lima œnœ ye yé. ");
INSERT INTO mnh_vpl VALUES ("MT8_25","070_8_25","MAT","8","25","25","Ayambarœ gitœ endje ndoo dœ she, á jo she lœ olo dœ kœpa dœ ɔgbɔ adœke: «Gbozu, she azœ kane! A tshu ke a!» ");
INSERT INTO mnh_vpl VALUES ("MT8_26","070_8_26","MAT","8","26","26","Yisu gi fœ endje adœke: «Mbœrœ gaɗe á 'e sœ dœ awaa? Kœyindœrœ nœ 'e sœ teasho! Yé tshe kœaafo á kœra yugu œdœ egerœ ungu adanganœ, osho kœyi tá.» ");
INSERT INTO mnh_vpl VALUES ("MT8_27","070_8_27","MAT","8","27","27","Azu kɔkɔ kɨtœ œsœnœ yé œ sœ lima kœpa adœke: «Uzunœ asœke kœdœ ɗe? Tshe sœ kœpa o'o fœ yugu œdœ fœ ungu yé œ sœ kœdji o'o ama ye!» ");
INSERT INTO mnh_vpl VALUES ("MT8_28","070_8_28","MAT","8","28","28","Lɔkɔ á Yisu yi kumu ye ɓa atshi egerœ ungu adanga, ɓa lœ ogo nœ Agadaraye, azu bisha á ekpe ɨshirɨ sœ pa endje to ɓa pa udu yé œ na gu tœnœ ga ndœ ye. Endje nga lima waa dœ mara adœke uzu bale œ li kœsɔ dœ awanœ asœmœ nene. ");
INSERT INTO mnh_vpl VALUES ("MT8_29","070_8_29","MAT","8","29","29","Endje tetœ kœta rawa adœke: «Yisu Gbolo nœ Ndjaba, ɓœ yindœ kœmbœrœ œrœ gaɗe tœ 'a a? Ɓœ na ɓa ke kœgaga kumu 'a a? Olo nœ 'a lili damba nene.» ");
INSERT INTO mnh_vpl VALUES ("MT8_30","070_8_30","MAT","8","30","30","Andaa egerœ ukpulu akɔso sœ lima kœpara kœzɨrœ ndoo kpœmœ. ");
INSERT INTO mnh_vpl VALUES ("MT8_31","070_8_31","MAT","8","31","31","Aekpe ɨshirɨnœ dɨ tshelœma endje fœ Yisu adœke: «Œdœ ɓœ kœyindœ kœgɔrɔ 'a, vwa 'a, 'a li ga lœ ukpulu akɔso asœ.» ");
INSERT INTO mnh_vpl VALUES ("MT8_32","070_8_32","MAT","8","32","32","Yé Yisu kœpa fœ endje adœke: «'E na zœ!» Endje wuta lœ azu asœmœ yé œ na œ li ga lœ akɔso. Ngbewo akɔso sœmœ ndjoro to ɓa pa kaga 'uru 'uru 'uru dœ ɔrɔ tra tœnœ œrrr ga la egerœ ungu adanga, yé œ nduru kɔ ye. ");
INSERT INTO mnh_vpl VALUES ("MT8_33","070_8_33","MAT","8","33","33","Azu á endje sœ lima kœgbɔndœ akɔsonœ kpa ye. Endje kpagu ɓa lœ ongbo œ mɨndœ œrœ kɔ á mbœrœtœ endje ga tœ azu sœmœ bisha á ekpe ɨshirɨ sœ pa endje fœ azu. ");
INSERT INTO mnh_vpl VALUES ("MT8_34","070_8_34","MAT","8","34","34","Yé azu tshelœ ongbonœ para kɔkɔ wuta kœgbɔtœ endje dœ Yisu. Lɔkɔ á endje wu she, endje kɨ fœ she adœke tshe gitœ ye lœ ogo nœ œne ye. ");
INSERT INTO mnh_vpl VALUES ("MT9_1","070_9_1","MAT","9","1","1","Yisu ɔ ga lœ agba, œ zu egerœ ungu adanga yé œ gu ga lœ ongbo nœ ye. ");
INSERT INTO mnh_vpl VALUES ("MT9_2","070_9_2","MAT","9","2","2","Endje za anga uzu á ada ye tshu, á tshe lo ga pa kelekpa, na tœnœ fœ she. Lɔkɔ á Yisu wu kœyindœrœ nœ azunœ asœmœ, tshe pa fœ uzunœ á ada ye tshu adœke: «Sœ dœ gbɔgbɔ, gbolo nœ mœ! Mœ djerœndœ ekperœ nœ zœ ye!» ");
INSERT INTO mnh_vpl VALUES ("MT9_3","070_9_3","MAT","9","3","3","Kœdji atamœ, anga aayi kœyisœ awa akwa tetœ kœpa ugurutœ endje dœ tœ endje adœke: «Uzu asœke sœ kœgu œsœ Ndjaba!» ");
INSERT INTO mnh_vpl VALUES ("MT9_4","070_9_4","MAT","9","4","4","Kashe Yisu wu lima sœ gbetshelœ nœ endje yé œ pa fœ endje adœke: «Mbœrœ gaɗe á 'e sœ dœ ekpe gbetshelœ tœ lɔsu 'e ata a? ");
INSERT INTO mnh_vpl VALUES ("MT9_5","070_9_5","MAT","9","5","5","Œdœ mœ kœpa adœke: “Mœ djerœndœ ekperœ nœ zœ”, too mœ kœpa ndje adœke: “Aalafo œ na ana”, o'o neketa dá dœ ɔgbɔ o'o a? ");
INSERT INTO mnh_vpl VALUES ("MT9_6","070_9_6","MAT","9","6","6","Kashe mœ yindœ nœ adœke 'e wusœ nœ adœke: Gbolo nœ uzu sœ dœ gbɔgbɔ pa ɔshɔ tœ kœdjerœndœ ekperœ.» Manda nœ, tshe kœpa fœ uzu á ada ye tshu asœmœ adœke: «Aalafo, za kelekpa nœ zœ yé œ gu ga ndœ zœ!» ");
INSERT INTO mnh_vpl VALUES ("MT9_7","070_9_7","MAT","9","7","7","Uzunœ asœmœ kœalafo á kœgu ga lœ anda nœ ye. ");
INSERT INTO mnh_vpl VALUES ("MT9_8","070_9_8","MAT","9","8","8","Lɔkɔ á ukpulu azu wu ataa, awa litœ endje yé endje tetœ kœdonga Ndjaba tœ mara gbɔgbɔ neke á tshe to fœ azu. ");
INSERT INTO mnh_vpl VALUES ("MT9_9","070_9_9","MAT","9","9","9","Yisu katœ tshakpœmœ tɨ yé œ tetœ kœro tœnœ, ngbewo œ wu anga uzu a ɨ'ɨrɨ ye kœdœ Matie á tshe sœ ga atɨ ɓa lœ anda kœko ngendja lapo. Tshe pa fœ she adœke: «Na manda mœ!» Matie áalafo yé œ na manda ye. ");
INSERT INTO mnh_vpl VALUES ("MT9_10","070_9_10","MAT","9","10","10","Manda nœ, Yisu sœ lima kœzɨrœ ɓa sœnda nœ Matie. Aayi kœko ngendja lapo ndjoro dœ pe azu kœmbœrœ ekperœ sœ lima kœzɨ œrœ awa bale dœ she œdœ ayambarœ nœ ye. ");
INSERT INTO mnh_vpl VALUES ("MT9_11","070_9_11","MAT","9","11","11","Afarisayi wu lima ataa œ yu ayambarœ nœ ye adœke: «Mbœrœ gaɗe á ayi kœyisœrœ nœ 'e œ zɨ œrœ tœ œsœnœ bale dœ aayi kœko ngendja lapo œdœ dœ azu kœmbœrœ ekperœ a?» ");
INSERT INTO mnh_vpl VALUES ("MT9_12","070_9_12","MAT","9","12","12","Yisu dji endje yé œ pa adœke: «Uzu á tshelœ ɔkɔ ye sœ yerœ gbegbe dœ monganga nene, kashe aayi koɓa dá gbe dœ she. ");
INSERT INTO mnh_vpl VALUES ("MT9_13","070_9_13","MAT","9","13","13","'E gu œ para ádá o'o á endje sú ɓa la buku nœ Ndjaba adœke: “'E sœ dœ lɔsu nœ kœwu oyo ga ndœ azu, œtœnœ dá mœ yindœ nœ, kashe tokóró nene.” Gbambanœ nene, mœ nana mbœrœ kœ'e azu neke á endje sœ ndjii nene, kashe mœ na mbœrœ aayi kœmbœrœ ekperœ.» ");
INSERT INTO mnh_vpl VALUES ("MT9_14","070_9_14","MAT","9","14","14","Ayambarœ nœ Yowane ayi kœza batisimu na ga ndœ Yisu yé œ yu she adœke: «Mbœrœ gaɗe á a'a œdœ Afarisayi, 'a sœ kœyotshelœma 'a kpala kpala yekane á ayambarœ nœ zœ mbœmbœrœ ataa nene a?» ");
INSERT INTO mnh_vpl VALUES ("MT9_15","070_9_15","MAT","9","15","15","Yé Yisu gi fœ endje adœke: «'E gbe adœke azu á endje e endje ndœ angbo totœ œ sœ dœ oyo dœ lɔkɔ á ayi kœto yashe sœ kpœtœ œsœnœ bale dœ endje a? Œ̃ œ̃ nene! Kashe manda nœ œrrr, lɔkɔ á endje kœza she tshakane endje dá endje yotshelœma endje. ");
INSERT INTO mnh_vpl VALUES ("MT9_16","070_9_16","MAT","9","16","16","«Yé Yisu kpa kœpa fœ endje adœke uzu bale zaza tafo lœba œ pi ga pa ongboronœ nene. Gbambanœ nene, tafo ndœma lœbanœ œ suru tshelœ ongboronœ, yé ogoronœ œ kpa sœ dœ egerœnœ. ");
INSERT INTO mnh_vpl VALUES ("MT9_17","070_9_17","MAT","9","17","17","Endje susu tafo ipi ga lœ ongboro anga nene. Atamœ nene, tshelœ anga œ 'u, ipinœ œ tu, yé anganœ œ ndɨ ye. Kashe endje sú tafo ipi ga lœ tafo anga, atamœ œrœ bale œ ndɨ nene.» ");
INSERT INTO mnh_vpl VALUES ("MT9_18","070_9_18","MAT","9","18","18","Lɔkɔ á Yisu sœ kœpa o'onœ asœmœ fœ endje ataa, anga gbozu nœ Ayuda yikumu ye œ gote ga utshu ye, yé œ pa adœke: «Yawuru nœ mœ tshu ngɔngɔnœ asœke, kashe na œ to kane zœ ga pa ye yé tshe sœ dœ soro.» ");
INSERT INTO mnh_vpl VALUES ("MT9_19","070_9_19","MAT","9","19","19","Yisu áalafo yé endje te manda ye, œshe dœ pe ayambarœ nœ ye. ");
INSERT INTO mnh_vpl VALUES ("MT9_20","070_9_20","MAT","9","20","20","Andaa anga yashe bale á tshe sœ lima kœwu oyo dœ koɓa indji manda ungu ndjokpa dœ bisha, na djagamanda Yisu œ goro ama lœba ye. ");
INSERT INTO mnh_vpl VALUES ("MT9_21","070_9_21","MAT","9","21","21","Tshe sœ lima kœpa ɓa lœ ye adœke: «Œdœ mœ kœgoro kolœ ama lœba nœ ye, mœ she ye.» ");
INSERT INTO mnh_vpl VALUES ("MT9_22","070_9_22","MAT","9","22","22","Kashe Yisu fatœ ye œ wu she yé á pa adœke: «Sœ dœ gbɔgbɔ yawuru nœ mœ! Kœyindœrœ nœ zœ she ɓœ ye.» Yé kolœ dœ ada ɔlɔnœ asœmœ, yashenœ she lœ koɓa nœ ye yé. ");
INSERT INTO mnh_vpl VALUES ("MT9_23","070_9_23","MAT","9","23","23","Yisu wuta ɓa lœ anda nœ gbozunœ asœmœ. Lɔkɔ á tshe wu aayi kœ'uru ngbake œdœ ukpulu azu á endje sœ kœta rawa, ");
INSERT INTO mnh_vpl VALUES ("MT9_24","070_9_24","MAT","9","24","24","tshe pa adœke: «'E wuta ga shu, gbambanœ nene, yawurunœ asœke tshutshu nene. Tshe sœ tœ olo.» Kashe endje sœ lima kœmɔ she. ");
INSERT INTO mnh_vpl VALUES ("MT9_25","070_9_25","MAT","9","25","25","Lɔkɔ á endje gɔrɔ ukpulu azunœ ga ushu, Yisu li ɓa tœ osho á gbolonœ sœ tœnœ, œ za kane ye yé tshe áalafo. ");
INSERT INTO mnh_vpl VALUES ("MT9_26","070_9_26","MAT","9","26","26","Yé o'onœ za tshelœ ogo djigi. ");
INSERT INTO mnh_vpl VALUES ("MT9_27","070_9_27","MAT","9","27","27","Lɔndɔ á Yisu katœ tshakpœtœmœ tɨ á sœ kœro tœnœ, anga aayibula bisha te manda ye dœ rawa adœke: «Wu oyo 'a, Gbolo nœ Davidi!» ");
INSERT INTO mnh_vpl VALUES ("MT9_28","070_9_28","MAT","9","28","28","Lɔkɔ á Yisu wuta ɓa lœ anda, aayibulanœ bisha na ndoo dœ she yé tshe yu endje adœke: «Adja 'e yindœ nœ adœke mœ mbœrœ ala 'e œ kɔrɔ a?» Endje gi fœ she adœke: «Œ̃, Gbozu.» ");
INSERT INTO mnh_vpl VALUES ("MT9_29","070_9_29","MAT","9","29","29","Yisu to kane ye ga pa ala endje yé œ pa adœke: «Kaka œ mbœrœtœ ye fœ 'e liaka kœyindœrœ nœ 'e.» ");
INSERT INTO mnh_vpl VALUES ("MT9_30","070_9_30","MAT","9","30","30","Yé ala endje kɔrɔ. Á Yisu kœpa fœ endje dœ ɔgbɔ adœke: «'E dji mœ dœ ɔtshɔnœ, 'e papandœ nœ fœ uzu bale nene!» ");
INSERT INTO mnh_vpl VALUES ("MT9_31","070_9_31","MAT","9","31","31","Kashe endje wuta, œ pandœ o'o nœ Yisu lœ ogonœ djigi. ");
INSERT INTO mnh_vpl VALUES ("MT9_32","070_9_32","MAT","9","32","32","Lɔkɔ á endje yi lima ndœ kœwuta tœnœ, endje na dœ anga uzu á tshe papa o'o nene fœ she. Tshe sœ lima dœ ekpe ɨshirɨ pa ye. ");
INSERT INTO mnh_vpl VALUES ("MT9_33","070_9_33","MAT","9","33","33","Yé Yisu gɔrɔ ekpe ɨshirɨnœ pa ye, á tshe tetœ kœpa o'o. Ukpulu azu kɨ lima tœ œsœnœ, œ pa adœke: «'A wuwu ɓalima mara anga œrœ atake bale lœ Israyele nene!» ");
INSERT INTO mnh_vpl VALUES ("MT9_34","070_9_34","MAT","9","34","34","Kashe Afarisayi pa lima adœke: «Gbozu tshapa aekpe ɨshirɨ dá to gbɔgbɔ kœgɔrɔ dœ ekpe ɨshirɨ fœ she asœmœ!» ");
INSERT INTO mnh_vpl VALUES ("MT9_35","070_9_35","MAT","9","35","35","Yisu na lima dje lœ ongbo œdœ dje lakpɨ kɔ, tshe sœ lima kœyisœ œrœ ɓa lœ Sinagoga nœ endje. Tshe sœ lima kœyisœ Ɔtshɔ O'o nœ Ogo gbozu nœ Ndjaba yé œ sœ lima kœshe azu lœ aka koɓa kɔ œdœ lœ gbakɨndɨ kɔ. ");
INSERT INTO mnh_vpl VALUES ("MT9_36","070_9_36","MAT","9","36","36","Kœwu ukpulu azu, tshe sœ lima dœ oyo tœ lɔsu ye. Gbambanœ nene, endje mɔ lima lœ gbetshelœ nœ endje yé œ gugu lima dœ gbɔgbɔ nene ɓata apata á aayi kœgbɔndœ endje gugu nene. ");
INSERT INTO mnh_vpl VALUES ("MT9_37","070_9_37","MAT","9","37","37","Yé tshe kœpa fœ ayambarœ nœ ye adœke: «Leyɔ doro ndjoro lœ kɨndɨ, kashe aayi akwa ngbangba nene. ");
INSERT INTO mnh_vpl VALUES ("MT9_38","070_9_38","MAT","9","38","38","Ataa, 'e kɨ fœ ayengɔ kɨndɨnœ adœke tshe kpa vwa anga aayi akwa mbœrœ kœkɔ tœnœ.» ");
INSERT INTO mnh_vpl VALUES ("MT10_1","070_10_1","MAT","10","1","1","Yisu e ayambarœ nœ ye ndjokpa dœ bisha asœmœ, œ to gbɔgbɔ kœgɔrɔ dœ ekpe ɨshirɨ fœ endje adœke endje kœgɔrɔ dœ endje yé œ she azu lœ aka koɓa kɔ dœ lœ gbakɨndɨ kɔ. ");
INSERT INTO mnh_vpl VALUES ("MT10_2","070_10_2","MAT","10","2","2","Ɨ'ɨrɨ aayi avwanœ ndjokpa dœ bisha dœke: Utshunœ kœdœ Shimu á anga ɨ'ɨrɨ ye kœdœ Petro œdœ ayanœ dœ Andere. Ajake dœ Yowane á endje kœdœ agbolo nœ Zebedayi, ");
INSERT INTO mnh_vpl VALUES ("MT10_3","070_10_3","MAT","10","3","3","Filipo œdœ Bartelemi, dœ Toma, dœ Matie ayi kœko ngendja lapo, dœ Jake gbolo nœ Alefe, dœ Tade, ");
INSERT INTO mnh_vpl VALUES ("MT10_4","070_10_4","MAT","10","4","4","dœ Shimu uzu kanana, dœ Yudasi Isikariote, œshe á tshe ka Yisu. ");
INSERT INTO mnh_vpl VALUES ("MT10_5","070_10_5","MAT","10","5","5","Yisu vwa aayi avwanœ ndjokpa dœ bisha dœ kœza 'o fœ endje adœke: «'E nana œ li ga lœ ogo nœ angbɨ azu nene, 'e lili ndje ga lœ ongbo nœ azu Samariya nene. ");
INSERT INTO mnh_vpl VALUES ("MT10_6","070_10_6","MAT","10","6","6","Kashe 'e na ga ndœ apata á endje djingili awa á endje dœ́ azu Israyele. ");
INSERT INTO mnh_vpl VALUES ("MT10_7","070_10_7","MAT","10","7","7","Tœ awa na tœnœ, 'e mɨndœ o'o adœke: “Ogo gbozu nœ tshalafo ndo ye!” ");
INSERT INTO mnh_vpl VALUES ("MT10_8","070_10_8","MAT","10","8","8","'E she aayi koɓa, 'e mbœrœ adœke akuzu kpa kwatœ endje ga lœ soro, 'e mbœrœ adœke aayi boroma wuta yerœ, 'e gɔrɔ ekpe ɨshirɨ. Ɓata á 'e gbɔgbɔ lœ awa nœ ngendja nene, 'e toto ndje lœ awa nœ kœ'esho ndœ ngendja nene. ");
INSERT INTO mnh_vpl VALUES ("MT10_9","070_10_9","MAT","10","9","9","Adja 'e zaza ɔrœ too anga langere ngendja bale ga lœ uwu tœ 'e nene, ");
INSERT INTO mnh_vpl VALUES ("MT10_10","070_10_10","MAT","10","10","10","too ngbade kœna dœ ana nene. 'E koko lœba okoro bisha nene, œdœ œrada, œdœ tshɔngbɔlɔ potœ 'e nene. Gbambanœ nene, ayi akwa li kœgbɔ œrœ tshangba akwa nœ ye. ");
INSERT INTO mnh_vpl VALUES ("MT10_11","070_10_11","MAT","10","11","11","«Lɔkɔ á 'e kœwuta ga lakpɨ too ga lœ anga ongbo, 'e para uzu neke á tshe li kœza osho kœsœ fœ 'e dœ ɔtshɔnœ, yé œ sœ kpœndœ ye kpœtœmœ œrrr ga tœ kœkatœ tshalakpɨnœ asœmœ tɨ. ");
INSERT INTO mnh_vpl VALUES ("MT10_12","070_10_12","MAT","10","12","12","Lɔkɔ á 'e kœli ga lœ anda nœ uzu, 'e pa adœke: “Kœsœ gee sœ dœ 'e.” ");
INSERT INTO mnh_vpl VALUES ("MT10_13","070_10_13","MAT","10","13","13","Œdœ azu tshasœndanœ kœza osho kœsœ fœ 'e, kœsœ gee nœ 'e œ sœ dœ endje. Kashe œdœ endje kœzaza osho kœsœ fœ 'e nene, 'e gi kœsœ gee nœ 'e pa endje ye. ");
INSERT INTO mnh_vpl VALUES ("MT10_14","070_10_14","MAT","10","14","14","Yé œdœ azu anga tshalakpɨ bale too anga tshasœnda bale kœvwaratœ endje tœ kœza osho kœsœ fœ 'e, too tœ kœdji o'o ama 'e ye, 'e katœ tshakpœtœmœ tɨ, yé œ gɔrɔ trusha tshada 'e tɨ kpœtœmœ. ");
INSERT INTO mnh_vpl VALUES ("MT10_15","070_10_15","MAT","10","15","15","Mœ sœ kœpa dœ adjapu fœ 'e adœke, dœ lɔkɔnœ á Ndjaba œ wa ngbanga pa azu, azu ogonœ asœmœ œ gbɔ djofele kœropa œnœ azu Sodomo dœ Gomora. ");
INSERT INTO mnh_vpl VALUES ("MT10_16","070_10_16","MAT","10","16","16","«'E wu! Mœ sœ kœvwa 'e ɓata apata ɓa ugurutœ amuru. 'E sœ dœ gbɔdjela ɓata ayakoro yé œ sœ dœ ɔmɔ lɔsu ɓata ambepa. ");
INSERT INTO mnh_vpl VALUES ("MT10_17","070_10_17","MAT","10","17","17","Ala 'e gbɔ tœ azu. Gbambanœ nene, endje ko 'e na tœnœ ga utshu aayi kœwa ngbanga nœ azu nœ Ndjaba yé œ sɔ 'e dœ ndjapa ɓa lœ Sinagoga nœ endje. ");
INSERT INTO mnh_vpl VALUES ("MT10_18","070_10_18","MAT","10","18","18","Endje ko ndje 'e bala tɔ ɓa utshu agboro agbozu œdœ pe agbozugo mbœrœ á 'e kœdœ azu nœ mœ. Ataa, œ za awa fœ 'e adœke 'e pa o'o tœ upu nœ mœ fœ endje, azunœ œdœ endje á endje dœ́dœ́ Ayuda nene asœmœ. ");
INSERT INTO mnh_vpl VALUES ("MT10_19","070_10_19","MAT","10","19","19","Lɔkɔ á endje kœto 'e na tœnœ ɓa tœ osho kœwa ngbanga, 'e tɔtɔ lɔsu 'e tœ mara á 'e gi dœ o'o nene. Gbambanœ nene, dœ ada ɔlɔnœ asœmœ, endje to o'o á li adœke 'e pa fœ 'e. ");
INSERT INTO mnh_vpl VALUES ("MT10_20","070_10_20","MAT","10","20","20","Œ dœ́dœ́ 'e dá pa o'onœ nene, kashe Ɨshirɨ nœ Aba 'e œ pa o'o lœ 'e. ");
INSERT INTO mnh_vpl VALUES ("MT10_21","070_10_21","MAT","10","21","21","«Ayazu œ va ɔtɔ ayanœ adœke endje wo she, yé aba kœzu uzu œ mbœrœ ndje ataa fœ gbolo nœ ye; agbolo œ yiangba aayi kœzu endje yé œ ko endje adœke endje wo endje ye. ");
INSERT INTO mnh_vpl VALUES ("MT10_22","070_10_22","MAT","10","22","22","Azu para kɔkɔ œ yiangba 'e mbœrœ ɨ'ɨrɨ mœ kashe uzu á tshe shi gbɨ œrrr ga tœ ndɔngɔlɔnœ, Ndjaba œ she she. ");
INSERT INTO mnh_vpl VALUES ("MT10_23","070_10_23","MAT","10","23","23","Œdœ endje kœmbœrœ œrœ kanga fœ 'e ɓa lœ anga ongbo bale, 'e kpa ga lœ anga angbɨnœ. Mœ pa fœ 'e dœ adjapu adœke, Gbolo nœ uzu œ na, damba 'e nana dje lœ ongbo Israyele kɔkɔ nene. ");
INSERT INTO mnh_vpl VALUES ("MT10_24","070_10_24","MAT","10","24","24","«Yambarœ bale roropa ayi kœyisœrœ fœ she nene, yé ayi akwa roro ndje pa gbozu nœ ye nene. ");
INSERT INTO mnh_vpl VALUES ("MT10_25","070_10_25","MAT","10","25","25","Kashe yambarœ œ sœ dœ yanga œdœ endje kœwu she ɓata ayi kœyisœrœ nœ ye, yé ayi akwa œ sœ ndje dœ yanga œdœ endje kœwu she ɓata gbozu nœ ye. Œdœ azu kœna œrrr á e ayengɔ anda Belezebula, ɨ'ɨrɨ gaɗe dá endje e ga tœ azu tshasœnda nœ ye a?» ");
INSERT INTO mnh_vpl VALUES ("MT10_26","070_10_26","MAT","10","26","26","«Awa uzu bale zaza 'e nene. Œrœ neke kɔ á zatœ endje yiwa tœnœ œ matœ endje ngbɨ ga shu, yé œneke kɔ á sœ lœ ubunœ, azu œ wusœ nœ kɔ. ");
INSERT INTO mnh_vpl VALUES ("MT10_27","070_10_27","MAT","10","27","27","O'o á mœ sœ kœpa fœ 'e lœ ubunœ asœmœ, 'e pa tshandœnœ dœ ɔlɔ, yé angba o'o á endje sœ kœpa ga lœ utu 'e, 'e pandœ nœ ngbɨ ga shu. ");
INSERT INTO mnh_vpl VALUES ("MT10_28","070_10_28","MAT","10","28","28","'E kpakpa awa azu á endje wo undu uzu kashe á endje lili kœwo ɨshirɨ uzu nene; 'e kpa awa Ndjaba á tshe li kœwo undu uzu œdœ ɨshirɨ ye ɓa lœ lifelo. ");
INSERT INTO mnh_vpl VALUES ("MT10_29","070_10_29","MAT","10","29","29","Endje kaka a'eara ayanu bisha ndœ kœgbɔ langere ngendja bale nene a? Andaa, anga bale ugurutœ endje œ te ga tœ ɔshɔ nene œdœ Aba 'e kœyiyindœ nœ nene. ");
INSERT INTO mnh_vpl VALUES ("MT10_30","070_10_30","MAT","10","30","30","Kashe e'e, œdœ sukumu 'e, Ndjaba dɨ kɔ. ");
INSERT INTO mnh_vpl VALUES ("MT10_31","070_10_31","MAT","10","31","31","Mbœrœ tœnœ ataa, 'e sœsœ dœ awa nene, gbambanœ nene, 'e ropa a'eara ayanu ye.» ");
INSERT INTO mnh_vpl VALUES ("MT10_32","070_10_32","MAT","10","32","32","«Uzu kɔ á tshe yindœ nœ ɓa tœ ala azu adœke œne kœdœ yambarœ nœ mœ, mœ yi ndje ndœ ye ɓa utshu Aba mœ á tshe sœ ɓa lafo adœke œshe kœdœ uzu nœ mœ. ");
INSERT INTO mnh_vpl VALUES ("MT10_33","070_10_33","MAT","10","33","33","Kashe tsheneke á tshe 'ea mœ ɓa utshu azu, mœ 'ea ndje she ɓa utshu Aba mœ á tshe sœ ɓa lafo.» ");
INSERT INTO mnh_vpl VALUES ("MT10_34","070_10_34","MAT","10","34","34","«'E gbegbe adœke mœ na mbœrœ kœza kœsœ gee ɓa pa ɔshɔ nene. Mœ nana mbœrœ kœza kœsœ gee nene, kashe mœ na dœ ɨngɨrɨ yakamba. ");
INSERT INTO mnh_vpl VALUES ("MT10_35","070_10_35","MAT","10","35","35","Adjapu, mœ na kœkurutshelœ gbolo yakoshe dœ abanœ, yawuru dœ ayinœ, yashe dœ yinɨnœ dœ yashe. ");
INSERT INTO mnh_vpl VALUES ("MT10_36","070_10_36","MAT","10","36","36","Uzu dœ uzu œ sœ dœ ayingba ye lœ anda nœ ye. ");
INSERT INTO mnh_vpl VALUES ("MT10_37","070_10_37","MAT","10","37","37","Uzu á tshe yindœ abanœ too ayinœ kœropa mœ, tshe lili kœdœ uzu nœ mœ nene. Uzu á tshe kœyindœ gbolo yakoshe too gbolo yawuru nœ ye kœropa mœ, tshe lili kœdœ uzu nœ mœ nene. ");
INSERT INTO mnh_vpl VALUES ("MT10_38","070_10_38","MAT","10","38","38","Uzu á tshe kœza kurushi nœ ye yé á na manda mœ nene, tshe lili kœdœ uzu nœ mœ nene. ");
INSERT INTO mnh_vpl VALUES ("MT10_39","070_10_39","MAT","10","39","39","Uzu á tshe kœyindœ kœgbɔndœ soro ye, œ yiwatœ ye yé. Kashe tsheneke á tshe kœyindœ kœtshu mbœrœ mœ, tshe sœ dœ soro.» ");
INSERT INTO mnh_vpl VALUES ("MT10_40","070_10_40","MAT","10","40","40","«Uzu neke á tshe kœza osho kœsœ fœ 'e, dá tshe za ndje fœ mœ ye. Uzu neke á tshe kœza osho kœsœ fœ mœ, dá tshe za ndje fœ tsheneke á tshe vwa mœ. ");
INSERT INTO mnh_vpl VALUES ("MT10_41","070_10_41","MAT","10","41","41","Uzu á tshe kœza osho kœsœ fœ anga ayi kœgbara o'o nœ Ndjaba mbœrœ á tshe kœdœ ayi kœgbara o'o asœmœ, tshe gbɔ œrœ tshangbanœ ɓata á Ndjaba sœ kœto fœ ayi kœgbara o'o. Yé tsheneke á tshe za osho kœsœ fœ uzu á tshe sœ ndjii mbœrœ á tshe kœdœ uzu ndjii utshu Ndjaba, tshe gbɔ ndje œrœ tshangbanœ ɓata uzu á tshe sœ ndjii. ");
INSERT INTO mnh_vpl VALUES ("MT10_42","070_10_42","MAT","10","42","42","Mœ mɨndœ nœ dœ adjapu fœ 'e adœke, uzu kɔ á tshe su ungu kœndjoondjo, œdœ œ kœdœ yashi zɨtɨ ungu tshebabale fœ anga aya gbolo lœ agbolonœ asœke mbœrœ á tshe dœ́ yambarœ nœ mœ, Ndjaba œ to œrœ tshangbanœ fœ she.» ");
INSERT INTO mnh_vpl VALUES ("MT11_1","070_11_1","MAT","11","1","1","Lɔndɔ á Yisu za o'o fœ ayambarœ nœ ye ndjokpa dœ bisha á ka, tshe katœ tshakpœtœmœ tɨ œ ro kœyisœ œrœ œdœ kœmɨndœ Ɔtshɔ O'o nœ Ndjaba dje lœ ongbo nœ endje. ");
INSERT INTO mnh_vpl VALUES ("MT11_2","070_11_2","MAT","11","2","2","Andaa, Yowane ayi kœza batisimu sœ lœ kánga, yé tshe djindœ o'o akwa á Kristu sœ kœmbœrœ tœnœ, ngbewo á vwa anga ayambarœ nœ ye ");
INSERT INTO mnh_vpl VALUES ("MT11_3","070_11_3","MAT","11","3","3","kœyu Yisu adœke: «Œɓœ kœdœ tsheneke á tshe sœ kœna tœnœ a, too 'a kate anga angbɨ uzu?» ");
INSERT INTO mnh_vpl VALUES ("MT11_4","070_11_4","MAT","11","4","4","Yé Yisu kœgi fœ endje adœke: «'E gu œ pandœ œneke á 'e dji yé á wu fœ Yowane adœke: ");
INSERT INTO mnh_vpl VALUES ("MT11_5","070_11_5","MAT","11","5","5","Aayibula tetœ kœwu osho, aayi gbada na ana, aayi boroma wuta yerœ, aayi bitu dji o'o, akuzu kwatœ endje ga lœ soro, yé endje mɨndœ Ɔtshɔ O'o fœ aayi oyo. ");
INSERT INTO mnh_vpl VALUES ("MT11_6","070_11_6","MAT","11","6","6","Yanga nœ uzu á tshe kakatœ kœyindœrœ nœ ye ga ndœ mœ nene!» ");
INSERT INTO mnh_vpl VALUES ("MT11_7","070_11_7","MAT","11","7","7","Lɔndɔ á ayambarœ nœ Yowane gu da ye, Yisu tetœ kœpandœ Yowane fœ ukpulu azu adœke: «Œrœ gaɗe dá 'e na kœwu tœnœ ɓa lœ kpagagasho a? A'eara ɔyɔ á yugu sœ kœmea tœnœ a? Œ̃ œ̃ nene. ");
INSERT INTO mnh_vpl VALUES ("MT11_8","070_11_8","MAT","11","8","8","Yé œrœ gaɗe dá 'e na kœwu tœnœ a? 'E na kœwu anga uzu á tshe verœ ɔtshɔ lœba a? Œ̃ œ̃ nene, azu á endje verœ ɔtshɔ lœba sœ ɓa lœ anda nœ agbozugo. ");
INSERT INTO mnh_vpl VALUES ("MT11_9","070_11_9","MAT","11","9","9","Yé ataa, œrœ gaɗe dá 'e na kœwu tœnœ a? 'E na kœwu ayi kœgbara o'o a? Œ̃, mœ mɨndœ nœ dœ adjapu fœ 'e adœke tshe ropa ayi kœgbara o'o ye. ");
INSERT INTO mnh_vpl VALUES ("MT11_10","070_11_10","MAT","11","10","10","Gbambanœ nene, Yowane ayi kœza batisimu kœdœ uzu á endje sú o'o tœ upu nœ ye ɓa la buku nœ Ndjaba adœke: “Mœ vwa ayi avwa nœ mœ utshu zœ mbœrœ kœguma ala awa zœ.” ");
INSERT INTO mnh_vpl VALUES ("MT11_11","070_11_11","MAT","11","11","11","Mœ mɨndœ nœ dœ adjapu fœ 'e adœke, ugurutœ azu tshapashɔnœ asœke kɔ, anga uzu bale á tshe ropa Yowane ayi kœza batisimu gugu nene. Andaa, tsheneke á tshe sœ teasho ɓa lœ Ogo gbozu nœ tshalafo ropa ye yé. ");
INSERT INTO mnh_vpl VALUES ("MT11_12","070_11_12","MAT","11","12","12","Kœto tœ lɔkɔ á Yowane ayi kœza batisimu wuta kœyisœ œrœ œrrr ga tœ kpesheke, Ogo gbozu nœ tshalafo to toro kœgerœ tœnœ. Aayi gbɔgbɔ dá sœ kœpara awa nœ kœgbɔtœ nœ. ");
INSERT INTO mnh_vpl VALUES ("MT11_13","070_11_13","MAT","11","13","13","Aayi kœgbara o'o kɔ œdœ awa akwa, gbara o'o œrrr ga tœ Yowane. ");
INSERT INTO mnh_vpl VALUES ("MT11_14","070_11_14","MAT","11","14","14","Yé œdœ 'e kœyindœ kœwusœ nœ dœ ɔtshɔnœ, Yowane kœdœ Eliya á endje pa lima ndœ kœna she. ");
INSERT INTO mnh_vpl VALUES ("MT11_15","070_11_15","MAT","11","15","15","Kaka uzu á tshe kœsœ dœ utu, tshe dji! ");
INSERT INTO mnh_vpl VALUES ("MT11_16","070_11_16","MAT","11","16","16","«Mœ li azu nœ tshakpesheke dœ azu ɗe? Endje liili dœ agbolo á endje ka ɓa la wutu kœka œrœ yé á sœ kœpa o'o ugurutœ endje adœke: ");
INSERT INTO mnh_vpl VALUES ("MT11_17","070_11_17","MAT","11","17","17","“'A 'uru ngbake fœ 'e, kashe 'e vivi ipi nene! 'A ɓi itshi kuzu fœ 'e, kashe 'e kɨkɨ nene.” ");
INSERT INTO mnh_vpl VALUES ("MT11_18","070_11_18","MAT","11","18","18","Gbambanœ nene, Yowane ayi kœza batisimu na yé œ vwaratœ ye tœ kœzɨ œrœ œdœ kœndjo ipi, endje pa adœke: “Tshe sœ dœ ekpe ɨshirɨ pa ye!” ");
INSERT INTO mnh_vpl VALUES ("MT11_19","070_11_19","MAT","11","19","19","Gbolo nœ uzu na œ sœ kœzɨ œrœ yé œ sœ kœndjo ipi, endje sœ kœpa adœke: “'E wu makœzɨrœ, mœndjondjo. Anganœ kœdœ kolœ aayi kœko ngendja lapo œdœ azu kœmbœrœ ekperœ!” Kashe kœwusœtœ nœ Ndjaba sœ kœmatœ ye ndjii lœ awa akwa nœ ye.» ");
INSERT INTO mnh_vpl VALUES ("MT11_20","070_11_20","MAT","11","20","20","Yé Yisu tetœ kœgbagbara azu tshelœ ongbo á tshe mbœrœ lima afá ndjoro lœnœ; gbambanœ nene, endje yayapa lima ɔtshɔ endje nene. Tshe pa fœ endje adœke: ");
INSERT INTO mnh_vpl VALUES ("MT11_21","070_11_21","MAT","11","21","21","«Oyo nœ zœ, Koraze! Oyo nœ zœ Betesayida! Gbambanœ nene, œdœ afá á mbœrœtœ endje ɓa ndœ 'e kœmbœrœ má tœ endje ɓa lœ Tire œdœ ɓa lœ Sidona, azu ɓa zœ œ verœ má sake, yé œ dja má tshelœ kumu endje dœ vorowo mbœrœ kœma adœke œne fatshalɔsu œne ye. ");
INSERT INTO mnh_vpl VALUES ("MT11_22","070_11_22","MAT","11","22","22","Mbœrœ tœnœ ataa, mœ sœ kœmɨndœ nœ fœ 'e adœke dœ lɔkɔ kœwa ngbanga, mœ wa o'o tœ ɔgbɔnœ ga tœ 'e kœropa œnœ azu Tire œdœ Sidona. ");
INSERT INTO mnh_vpl VALUES ("MT11_23","070_11_23","MAT","11","23","23","Yé e'e dœ azu Kaparnawumu, 'e gbe adœke 'e ɔ œrrr ga lafo zœ a? 'E jerœ bala œrrr ɓa lœ ogo nœ akuzu. Gbambanœ nene, œdœ afá á mbœrœtœ endje ɓa ndœ 'e, kœmbœrœ má lima tœ endje ɓa lœ Sodomo ataa, ongbonœ asœmœ œ sœ má œrrr ga tœ kpesheke. ");
INSERT INTO mnh_vpl VALUES ("MT11_24","070_11_24","MAT","11","24","24","Mbœrœ tœnœ ataa, mœ sœ kœmɨndœ nœ fœ 'e adœke dœ lɔkɔ kœwa ngbanga, mœ wa o'o nœ 'e tœ ɔgbɔnœ kœropa œnœ azu ogo Sodomo.» ");
INSERT INTO mnh_vpl VALUES ("MT11_25","070_11_25","MAT","11","25","25","Dœ lɔndɔnœ asœmœ, Yisu pa dœ ɔgbɔ adœke: «Uu Aba, Gbozu nœ tshalafo dœ tshapashɔ, mœ gi mershe fœ ɓœ mbœrœ á ɓœ má ngbɨ fœ azu á endje wuwusœ œrœ nene adjapu á ɓœ za yiwa tœnœ tœ azu kœwusœtœ œdœ agbangba kœwusœrœ. ");
INSERT INTO mnh_vpl VALUES ("MT11_26","070_11_26","MAT","11","26","26","Aba, œɓœ dá yindœ nœ adœke œ mbœrœtœ ye ataa. ");
INSERT INTO mnh_vpl VALUES ("MT11_27","070_11_27","MAT","11","27","27","«Aba mœ ko œrœ kɔ fœ mœ. Uzu bale wuwusœ Gbolo nene, kolœ Aba dá wusœ ye. Uzu bale wuwusœ Aba nene, kolœ Gbolo dá wusœ ye, œdœ tsheneke á Gbolo yindœ kœma Aba fœ she tako. ");
INSERT INTO mnh_vpl VALUES ("MT11_28","070_11_28","MAT","11","28","28","«E'e dœ azu kɔ á 'e mɔ dœ kœko ogboro gbarœ, 'e na ga ndœ mœ, mœ ko gbarœnœ lœ kumu 'e dœ́ 'e yatœ 'e. ");
INSERT INTO mnh_vpl VALUES ("MT11_29","070_11_29","MAT","11","29","29","'E za ngbongbo awa bale dœ mœ, yé œ li ga lœ lakɔrɔ nœ mœ; gbambanœ nene, mœ dœ́dœ́ ayi gbɔkumu nene kashe mœ dœ́ ayi ɔmɔ lɔsu. Ataa, 'e li kœyatœ 'e dœ tœ 'e. ");
INSERT INTO mnh_vpl VALUES ("MT11_30","070_11_30","MAT","11","30","30","Ngbongbo nœ mœ gbɔgbɔ nene, yé gbarœnœ á a za dœ 'e œ lɨ 'e nene.» ");
INSERT INTO mnh_vpl VALUES ("MT12_1","070_12_1","MAT","12","1","1","Manda nœ teasho atake, Yisu ro lima tɔ lœ kɨndɨ ble dœ anga lɔkɔ sabata. Ogo li lima tœ ayambarœ nœ ye yé endje tetœ kœverœ ele blenœ asœmœ á sœ kœzɨ tœnœ. ");
INSERT INTO mnh_vpl VALUES ("MT12_2","070_12_2","MAT","12","2","2","Lɔkɔ á Afarisayi wu ataa, endje pa fœ Yisu adœke: «Wu, ayambarœ nœ zœ sœ kœmbœrœ œrœ á awa akwa vwaratœ ye tœnœ dœ olo sabata!» ");
INSERT INTO mnh_vpl VALUES ("MT12_3","070_12_3","MAT","12","3","3","Yisu gi fœ endje adœke: «'E dɨdɨ œneke á Davidi mbœrœ lima anga ɔlɔ bale á ogo mi lima she dœ azu nœ ye á tshe na lima tœ awanœ dœ endje nene a? ");
INSERT INTO mnh_vpl VALUES ("MT12_4","070_12_4","MAT","12","4","4","Tshe li, œshe œdœ azu nœ ye ɓa lœ anda Ndjaba, yé endje zɨ mapa á endje to dœ tokóró fœ Ndjaba; mapa má œdœ she œdœ azu nœ ye, endje lili má kœzɨ tœnœ nene, kashe á sœ kolœ mbœrœ anganga Ndjaba kutɨ endje. ");
INSERT INTO mnh_vpl VALUES ("MT12_5","070_12_5","MAT","12","5","5","Too 'e dɨdɨ ndje ɓa la buku awa akwa nene adœke dœ lɔkɔ sabata, ata anganga Ndjaba sœ kœmbœrœ akwa lœ Tepelo gbaa, endje sœ kœmbœrœ œrœ kpi tœ awa akwa, kashe Ndjaba sœsœ kœwu lœ ala ye ɓata ekperœ nene. ");
INSERT INTO mnh_vpl VALUES ("MT12_6","070_12_6","MAT","12","6","6","Andaa mœ sœ kœmɨndœ nœ dœ adjapu fœ 'e adœke, œrœ á 'e wu asœke, œ ropa Tepelo ye. ");
INSERT INTO mnh_vpl VALUES ("MT12_7","070_12_7","MAT","12","7","7","Œdœ 'e kœwu má sœ ádá o'o á endje sú ala buku nœ Ndjaba adœke: “Mœ yindœ nœ adœke, 'e wu oyo anga 'e kashe tokóró nene;” 'e wawa ngbanga pa azu á endje mbœmbœrœ œrœ bale nene. ");
INSERT INTO mnh_vpl VALUES ("MT12_8","070_12_8","MAT","12","8","8","Gbambanœ nene, Gbolo nœ uzu kœdœ ayengɔ lɔkɔ sabata.» ");
INSERT INTO mnh_vpl VALUES ("MT12_9","070_12_9","MAT","12","9","9","Yisu katœ tshakpœtœmœ tɨ, œ na œ li ga lœ Sinagoga nœ endje. ");
INSERT INTO mnh_vpl VALUES ("MT12_10","070_12_10","MAT","12","10","10","Anga uzu bale á kane ye tshu sœ lima kpœtœmœ. Afarisayi yu lima Yisu dœ o'o adœke: «Awa akwa nœ azœ sœ kœyindœ nœ adœke endje she uzu dœ lɔkɔ sabata a?» Endje yu lima she ataa mbœrœ á kœgbɔ awa kœtɔ meza pa ye. ");
INSERT INTO mnh_vpl VALUES ("MT12_11","070_12_11","MAT","12","11","11","Yisu gi fœ endje adœke: «Œdœ anga uzu ugurutœ 'e kœsœ dœ pata nœ ye tshebabale, á tshe te ga lœ kudu dœ lɔkɔ sabata, tshe lili kœza she ga ushu nene a? ");
INSERT INTO mnh_vpl VALUES ("MT12_12","070_12_12","MAT","12","12","12","Uzu ropa pata! Mbœrœ tœnœ ataa, awa akwa nœ azœ za awa fœ azœ ndœ kœmbœrœ ɔtshɔrœ dœ lɔkɔ sabata.» ");
INSERT INTO mnh_vpl VALUES ("MT12_13","070_12_13","MAT","12","13","13","Yé Yisu kœpa fœ uzunœ á kane ye tshu adœke: «Yɔrɔ tshelœ kane zœ.» Tshe yɔrɔ tshelœ kane ye, yé œ gumatœ ye ɓata anga tshakalanœ. ");
INSERT INTO mnh_vpl VALUES ("MT12_14","070_12_14","MAT","12","14","14","Afarisayi gu œ vwarandœ o'o ugurutœ endje tœ kœpara awa ndœ kœwo Yisu. ");
INSERT INTO mnh_vpl VALUES ("MT12_15","070_12_15","MAT","12","15","15","Lɔndɔ á Yisu djindœ o'onœ asœmœ, tshe gitœ ye kpœtœmœ, yé azu ndjoro na manda ye. Tshe she aayi koɓa kɔ, ");
INSERT INTO mnh_vpl VALUES ("MT12_16","070_12_16","MAT","12","16","16","kashe œ pa fœ endje dœ ɔgbɔ adœke endje papa o'o tœ upu nœ œne fœ uzu bale nene. ");
INSERT INTO mnh_vpl VALUES ("MT12_17","070_12_17","MAT","12","17","17","Tshe mbœrœ lima ataa adœke o'o á Ndjaba pa dœ awa nœ ayi kœgbara o'o Isaya kœmbœrœ tœ endje. ");
INSERT INTO mnh_vpl VALUES ("MT12_18","070_12_18","MAT","12","18","18","Tshe pa lima adœke: «Wu ayi akwa nœ mœ á mœ ke she dœke, mœ yindœ ye waa yé mœ sœ dœ yanga mbœrœ she. Mœ vwa Ɨshirɨ nœ mœ kœjerœ ga pa ye, yé tshe yisœ ɔtshɔ awa fœ azu tshapashɔ kɔ. ");
INSERT INTO mnh_vpl VALUES ("MT12_19","070_12_19","MAT","12","19","19","Tshe bœrœtœ ye dœ uzu bale nene, yé œ ta ndje rawa nene; endje dji she kœpa o'o tœ ala awa nene. ");
INSERT INTO mnh_vpl VALUES ("MT12_20","070_12_20","MAT","12","20","20","Tshe kavwa tshelœ wara á lu nene, yé tshe ru miinda á ndoo kœru tœnœ nene, œrrr ga tœ adœke œneke á sœ ndjii ropa œrœ kɔ yekane. ");
INSERT INTO mnh_vpl VALUES ("MT12_21","070_12_21","MAT","12","21","21","Yé azu kɔ á endje wuwusœ mœ nene œ ko lɔsu endje ga pa ye.» ");
INSERT INTO mnh_vpl VALUES ("MT12_22","070_12_22","MAT","12","22","22","Endje na dœ anga uzu bale á ala ye bu yé á tshe papa o'o nene fœ Yisu. Tshe sœ lima dœ ekpe ɨshirɨ pa ye. Yisu she uzunœ dœ mara adœke tshe tetœ kœpa o'o dœ pe kœwu osho. ");
INSERT INTO mnh_vpl VALUES ("MT12_23","070_12_23","MAT","12","23","23","Ukpulu azu á endje sœ lima kpœtœmœ, kɨtœ œsœnœ yé œ sœ lima kœpa adœke: «Uzunœ asœke kœdœ ata Davidi nene a?» ");
INSERT INTO mnh_vpl VALUES ("MT12_24","070_12_24","MAT","12","24","24","Lɔkɔ á Afarisayi dji endje kœpa o'o ataa, endje pa ngbɨ adœke: «Belezebula gbozu nœ ekpe ɨshirɨ sœ pa ye. Œshe dá za gbɔgbɔ fœ she tœ kœgɔrɔ dœ ekpe ɨshirɨ pa azu asœmœ!» ");
INSERT INTO mnh_vpl VALUES ("MT12_25","070_12_25","MAT","12","25","25","Kashe yisu wu lima sœ gbetshelœ nœ endje, yé œ pa fœ endje adœke: «Ogo gbozu kɔ á azu tshelœnœ kœsœ kœnga koshe ugurutœ endje, tshelœ ogonœ asœmœ œ ndɨ ye. Œdœ azu tshelœ ongbo bale too lœ bɨngɨ bale kœsœ kœnga koshe ugurutœ endje, tshelœ ongbonœ too bɨngɨnœ œ ndɨ ye. ");
INSERT INTO mnh_vpl VALUES ("MT12_26","070_12_26","MAT","12","26","26","Œdœ Satana kœsœ kœgɔrɔ œneke á dœ́ œnœ Satana, asœmœ dá tshe sœ kœnga koshe ga tœ ye dœ tœ ye. Ataa, Ogo gbozu nœ ye œ sœpe koto o? ");
INSERT INTO mnh_vpl VALUES ("MT12_27","070_12_27","MAT","12","27","27","'E sœ kœpa adœke Belezebula dá to gbɔgbɔ fœ mœ yeka á mœ sœ kœgɔrɔ dœ ekpe ɨshirɨ. Yé azu nœ 'e gɔrɔ ndje ekpe ɨshirɨ dœ gbɔgbɔ nœ ɗe? Ataa, azu nœ 'e dœ tœ endje œ yisœ nœ adœke 'e te dœ o'o ye. ");
INSERT INTO mnh_vpl VALUES ("MT12_28","070_12_28","MAT","12","28","28","Kashe œdœ mœ kœsœ kœgɔrɔ ekpe ɨshirɨ dœ Ɨshirɨ nœ Ndjaba, dá œ sœ kœma adœke Ogo gbozu nœ Ndjaba wuta ga ndœ 'e ye. ");
INSERT INTO mnh_vpl VALUES ("MT12_29","070_12_29","MAT","12","29","29","«Too ndje, œdœ uzu kœyindœ kœli kœko œrœ dœ ɔgbɔ ɓa lœ anda nœ uzu nœ gbɔgbɔ; œ li adœke tshe i she vwagbagba ga tœnœ utshunœ yeka á kœli kœko œrœ nœ ye. ");
INSERT INTO mnh_vpl VALUES ("MT12_30","070_12_30","MAT","12","30","30","Uzu á tshe sœsœ awa bale dœ mœ nene, œshe kœdœ yingba mœ. Yé tsheneke á tshe sœsœ kœtɨ kane mœ adœke 'a ngboɓa azu nene, sœ kœndjɔtshelœ endje. ");
INSERT INTO mnh_vpl VALUES ("MT12_31","070_12_31","MAT","12","31","31","Mbœrœ tœnœ ataa, mœ sœ kœmɨndœ nœ fœ 'e adœke, Ndjaba œ djerœndœ ekperœ nœ azu kɔ œdœ pe kœgu œsœ Ndjaba á endje sœ kœgu tœnœ. Kashe tsheneke á tshe kœsœ kœgu œsœ Ɔtshɔ Ɨshirɨ, Ndjaba œ djerœndœ ekperœ nœ ye nene. ");
INSERT INTO mnh_vpl VALUES ("MT12_32","070_12_32","MAT","12","32","32","Uzu á tshe pa ekpe o'o dœ upu nœ Gbolo nœ uzu, Ndjaba œ djerœndœ ekperœ nœ ye kashe œdœ tshe kœpa ekpe o'o goro œsœ́ Ɔtshɔ Ɨshirɨ, Ndjaba œ djerœndœ ekperœ nœ ye bale nene œdœ lœ soro ye pa ɔshɔ œdœ manda kuzu ye.» ");
INSERT INTO mnh_vpl VALUES ("MT12_33","070_12_33","MAT","12","33","33","«Œdœ ɔyɔ kœdœ ɔtshɔ ɔyɔ, elenœ œ sœ ndje dœ ɔtshɔnœ. Yé œdœ ɔyɔ kœdœ ɔyɔ á sœ dœ koɓa, elenœ œ sœ ndje dœ koɓa. Gbambanœ nene, endje wusœ ɔyɔ mbœrœ elenœ. ");
INSERT INTO mnh_vpl VALUES ("MT12_34","070_12_34","MAT","12","34","34","Ukpulu ekpe ayakoro! Ɓata 'e kœdœ aekpe azu asœke, mara gaɗe dá 'e li kœpa ɔtshɔ o'o a? Gbambanœ nene, o'o á wuta lœ ama uzu to ɓa tœ lɔsu ye. ");
INSERT INTO mnh_vpl VALUES ("MT12_35","070_12_35","MAT","12","35","35","Ɔtshɔ uzu sœ kœmbœrœ ɔtshɔrœ á sœ kœto lœ ɔtshɔ lɔsu nœ ye; yé ekpe uzu sœ kœmbœrœ ndje ekperœ á sœ kœto lœ ekpe lɔsu nœ ye. ");
INSERT INTO mnh_vpl VALUES ("MT12_36","070_12_36","MAT","12","36","36","Mœ sœ kœmɨndœ nœ fœ 'e adœke, dœ lɔkɔ kœwa ngbanga, Ndjaba œ yu azu tœ o'o á endje pa lima ngbɨlɨngbɨlɨ asœmœ kɔ. ");
INSERT INTO mnh_vpl VALUES ("MT12_37","070_12_37","MAT","12","37","37","Gbambanœ nene, kolœ lindœ o'o á wuta lœ ama zœ dá ɓœ te dœ o'o too ɓœ te ndje dœ o'o nene.» ");
INSERT INTO mnh_vpl VALUES ("MT12_38","070_12_38","MAT","12","38","38","Yé anga aayi kœyisœ awa akwa œdœ anga Afarisayi pa fœ Yisu adœke: «Gbozu, 'a yindœ nœ adœke ɓœ ma anga ambárá afá bale fœ 'a kane.» ");
INSERT INTO mnh_vpl VALUES ("MT12_39","070_12_39","MAT","12","39","39","Yisu kœgi fœ endje adœke: «Azu nœ tshakpesheke, endje kœdœ aekpe azu yé œ zazatœ endje fœ Ndjaba nene; endje yindœ nœ adœke œne wu anga ambárá afá bale. Kashe endje wu œrœ bale nene, kolœ ambárá afá á Ndjaba ma lœ awa nœ ayi kœgbara o'o nœ ye dœ Yona asœmœ. ");
INSERT INTO mnh_vpl VALUES ("MT12_40","070_12_40","MAT","12","40","40","Gbambanœ nene, ɓata á Yona mbœrœ ɔlɔ votɔ œdœ butshɔ votɔ ɓa lœ egerœ ageatshalangu, awa bale Gbolo nœ uzu œ mbœrœ ndje ɔlɔ votɔ dœ butshɔ votɔ lœ ɔshɔ. ");
INSERT INTO mnh_vpl VALUES ("MT12_41","070_12_41","MAT","12","41","41","Dœ lɔkɔ kœwa ngbanga nœ azu pa ɔshɔ, azu Ninive œ áalafo œ wa o'o ga pa azu nœ tshakpesheke asœke. Gbambanœ nene, azu Ninive fa lima tshalɔsu endje lɔkɔ á endje dji Yona kœmɨndœ o'o ama Ndjaba. Kashe uzunœ á tshe sœ kpœke asœke ropa Yona ye! ");
INSERT INTO mnh_vpl VALUES ("MT12_42","070_12_42","MAT","12","42","42","Dœ lɔkɔ kœwa bala ngbanga, gbozugo yashe tshapa ogo Saba œ wa o'o ga pa 'e. Gbambanœ nene, tshe to ɓa tœ ndɔngɔlɔ tshakala ogo pa ɔshɔ á sœ lœ ɨngɨrɨnœ, á na kœdji o'o kœwusœtœ nœ Salomo. Kashe uzunœ á tshe sœ kpœke asœke ropa Salomo ye!» ");
INSERT INTO mnh_vpl VALUES ("MT12_43","070_12_43","MAT","12","43","43","«Œdœ ekpe ɨshirɨ kœgitœ ye pa uzu, tshe sœ kœkɔrɔ na tœnœ djezœ lœ kpagagasho mbœrœ kœpara osho kœsœ tœnœ. Œdœ tshe kœgbɔgbɔ osho kœsœ tœnœ nene, ");
INSERT INTO mnh_vpl VALUES ("MT12_44","070_12_44","MAT","12","44","44","tshe sœ kœpa adœke: “Mœ kwatœ mœ ga lœ anda nœ mœ á mœ wuta lœ nœ.” Kashe lɔkɔ á tshe kœkwatœ ye yé á wu adœke uzu gugu lœ andanœ nene, endje ngbɔ tshelœnœ œ guma œrœ tshelœnœ dœ awanœ, ");
INSERT INTO mnh_vpl VALUES ("MT12_45","070_12_45","MAT","12","45","45","tshe na œ e anga angbɨ aekpe ɨshirɨ mindu dœ bisha (7) á endje sœ tœ ekpenœ kœrosœ ye. Tshe gu dœ endje awa bale œ li ga sœndanœ yé œ gumatœ endje kpœtœmœ. Ataa, oyo á uzunœ asœmœ œ kpa wu œ ropa œneke má utshunœ. Œ sœ ndje awa bale ataa mbœrœ aekpe azu nœ tshakpesheke.» ");
INSERT INTO mnh_vpl VALUES ("MT12_46","070_12_46","MAT","12","46","46","Lɔndɔ á Yisu sœpe lima kœpa o'o fœ ukpulu azu atake, ayinœ œdœ pe aayanœ yi kumu endje. Endje ka lima ɓa ushu yé œ sœ kœpara awa kœpa o'o dœ she. ");
INSERT INTO mnh_vpl VALUES ("MT12_47","070_12_47","MAT","12","47","47","Yé anga uzu bale kœpa fœ Yisu adœke: «Ayi zœ œdœ aaya ka ɓa ushu œ yindœ kœpa o'o dœ ɓœ.» ");
INSERT INTO mnh_vpl VALUES ("MT12_48","070_12_48","MAT","12","48","48","Yisu kœgi fœ uzunœ asœmœ adœke: «Œɗe dá dœ ayi mœ a? Œɗe dá dœ aaya mœ a?» ");
INSERT INTO mnh_vpl VALUES ("MT12_49","070_12_49","MAT","12","49","49","Yé tshe yisœ ayambarœ nœ ye dœ kane ye, œ pa adœke: «'E Wu ayi mœ œdœ aaya mœ, endje dá sœ atɨ asœke. ");
INSERT INTO mnh_vpl VALUES ("MT12_50","070_12_50","MAT","12","50","50","Gbambanœ nene, uzu á tshe sœ kœmbœrœ œneke á Aba mœ á tshe sœ ɓa lafo yindœ nœ, œshe kœdœ aya mœ, yingɔ mœ too ayi mœ.» ");
INSERT INTO mnh_vpl VALUES ("MT13_1","070_13_1","MAT","13","1","1","Dœ lɔkɔnœ asœmœ, Yisu wuta lœ anda œ na kœsœ ga atɨ ɓa tœ mangu egerœ ungu adanga. ");
INSERT INTO mnh_vpl VALUES ("MT13_2","070_13_2","MAT","13","2","2","Ukpulu azu ngbɔtœ endje dje ɨndɨrɨ ye á tshe ɔ ga lœ egerœ agba yé á sœ ga atɨ. Ukpulu azunœ ka lima ɓa tœ mangunœ. ");
INSERT INTO mnh_vpl VALUES ("MT13_3","070_13_3","MAT","13","3","3","Tshe sœ lima kœpa o'o ndjoro lœ ndœma toro, yé œ pa lima fœ endje adœke: «Ɔlɔ bale, anga uzu na lima ga lœ kɨndɨ nœ ye mbœrœ kœlu indji ngwarœ. ");
INSERT INTO mnh_vpl VALUES ("MT13_4","070_13_4","MAT","13","4","4","Ɓata á tshe sœ lima kœlu indji ngwarœnœ, anganœ yo ga tœ ama awa, ayanu wu œ de ye. ");
INSERT INTO mnh_vpl VALUES ("MT13_5","070_13_5","MAT","13","5","5","Anganœ yo lima ga lœ oporo badja ɓa tœ osho á ɔshɔ sœsœ ndjoro tœnœ nene. Indji ngwarœnœ ko lima katsha mbœrœ embe ɔshɔnœ lili lima nene. ");
INSERT INTO mnh_vpl VALUES ("MT13_6","070_13_6","MAT","13","6","6","Lɔkɔ á ɔlɔ tɔ dœ ɔgbɔ, ungbu ngwarœnœ kɔkɔ œ ɔrɔ ye; gbambanœ nene, œshenœ lili waa ga lœ ɔshɔ nene. ");
INSERT INTO mnh_vpl VALUES ("MT13_7","070_13_7","MAT","13","7","7","Anga indji ngwarœnœ yo ga lœ ɔyɔ ishi. Ɔyɔ ishinœ gboro yé œ napa ungbu ngwarœnœ, awa kœgerœ tœnœ gugu nene. ");
INSERT INTO mnh_vpl VALUES ("MT13_8","070_13_8","MAT","13","8","8","Kashe anga indji ngwarœ kpa yo ga lœ ɔtshɔ ɔshɔ, yé œ zu ɔtshɔ elenœ: Bale le kama, anganœ le zazu votɔ (60) yé anganœ le ndje zazu bale dœ ndjokpa (30).» ");
INSERT INTO mnh_vpl VALUES ("MT13_9","070_13_9","MAT","13","9","9","Yé Yisu kœpa adœke: «Œdœ 'e kœsœ dœ utu, kaka 'e dji!» ");
INSERT INTO mnh_vpl VALUES ("MT13_10","070_13_10","MAT","13","10","10","Ayambarœ gitœ endje ndoo dœ she, œ yu she adœke: «Mbœrœ gaɗe á ɓœ sœ kœpa o'o lœ ndœma toro a?» ");
INSERT INTO mnh_vpl VALUES ("MT13_11","070_13_11","MAT","13","11","11","Tshe gi fœ endje adœke: «Tœ e'e, 'e li œnœ 'e kœwusœ o'o nœ ádá Ogo gbozu nœ tshalafo á zatœ endje yiwa tœnœ ye, kashe anga azu, endje lili kœwusœ nœ nene. ");
INSERT INTO mnh_vpl VALUES ("MT13_12","070_13_12","MAT","13","12","12","Gbambanœ nene, uzu á tshe sœ dœ œrœ, endje kpa ko anganœ ga pa nœ yé œ ngba tœ ye waa. Kashe tsheneke á tshe kœgugu dœ œrœ nene, endje kpa ko œneke teasho á tshe sœ dœ tœnœ, tœ ye yé. ");
INSERT INTO mnh_vpl VALUES ("MT13_13","070_13_13","MAT","13","13","13","'E wu ádánœ á mœ sœ kœpa o'o fœ endje lœ ndœma toro mbœrœ endje sœ kœwu œrœ kashe endje sœsœ kœwu tœnœ nene, yé endje sœ kœdji o'o kashe endje sœsœ kœdji tœnœ œdœ kœdji tshelœ katanœ kpœrœ nene. ");
INSERT INTO mnh_vpl VALUES ("MT13_14","070_13_14","MAT","13","14","14","Atamœ, œ mbœrœtœ ye lindœ kœgbara o'o nœ Isaya, á tshe pa adœke: “'E dji o'o waa kashe 'e dji tshelœ katanœ nene, 'e wu œrœ waa kashe 'e wu nene. ");
INSERT INTO mnh_vpl VALUES ("MT13_15","070_13_15","MAT","13","15","15","Gbambanœ nene, lɔsu azu asœke wuta dœ ɔgbɔnœ adœke; endje be utu endje ga tœnœ, endje be ala endje ga tœnœ mbœrœ á ala endje wuwu osho nene, mbœrœ á utu endje djidji o'o nene, mbœrœ á lɔsu endje zaza ádánœ kpœrœ nene yé ataa endje kpa kwa ga ndœ mœ nene mbœrœ á mœ kœshe endje.” ");
INSERT INTO mnh_vpl VALUES ("MT13_16","070_13_16","MAT","13","16","16","«Tœ e'e nœ 'e, 'e sœ œnœ 'e dœ yanga gbambanœ nene, ala 'e sœ kœwu osho zœ, yé utu 'e sœ kœdji o'o zœ. ");
INSERT INTO mnh_vpl VALUES ("MT13_17","070_13_17","MAT","13","17","17","Mœ sœ kœmɨndœ nœ dœ adjapu adœke, aayi kœgbara o'o ndjoro œdœ azu á endje sœ ndjii gbe ndœ kœwu œneke á 'e sœ kœwu tœnœ, kashe endje wuwu nene. Endje gbe ndje kœdji œneke á 'e sœ kœdji tœnœ, kashe endje djidji nene.» ");
INSERT INTO mnh_vpl VALUES ("MT13_18","070_13_18","MAT","13","18","18","«E'e, 'e dji ádá ndœma toro nœ ayi kœlu ngwarœnœ kane. ");
INSERT INTO mnh_vpl VALUES ("MT13_19","070_13_19","MAT","13","19","19","Azu á endje pandœ ogo gbozu fœ endje yé á endje sœsœ kœdji tshelœ katanœ nene, endje lœ ɓata ama awa á indji ngwarœ yo ga tœnœ: Satana na œ kakara œneke á endje lu ga tœ lɔsu endje ye. ");
INSERT INTO mnh_vpl VALUES ("MT13_20","070_13_20","MAT","13","20","20","Anga azu sœ ɓata ɔshɔ lœ oporo badja á indji ngwarœ yo ga lœnœ: Endje sœ kœdji o'o yé œ sœ kœyindœ nœ katsha dœ yanga. ");
INSERT INTO mnh_vpl VALUES ("MT13_21","070_13_21","MAT","13","21","21","Kashe œshe endje gugu nene. Endje yindœ nœ kolœ kwata œndœ nœ œ dɨ nene, lɔkɔ á endje kœtetœ kœwu oyo too endje kœsœ kœmbœrœ œrœ kanga fœ endje lœ kumu o'o ama Ndjaba, endje ka ngbɨrɨ lœ kœyindœrœ nœ endje nene. ");
INSERT INTO mnh_vpl VALUES ("MT13_22","070_13_22","MAT","13","22","22","Anga endje sœ ɓata indji ngwarœ á yo ɓa ugurutœ ɔyɔ ishi. Endje dji o'o ama Ndjaba kashe ogo œrœ tshapashɔ œdœ yanga kœgbɔ œrœ ndjoro á sœ kœfara azu, œ na pa o'onœ yé œ zuzu elenœ nene. ");
INSERT INTO mnh_vpl VALUES ("MT13_23","070_13_23","MAT","13","23","23","Anga azu sœ ɓata indji ngwarœ a yo ga lœ ɔtshɔ ɔshɔ. Endje sœ kœdji o'o ama Ndjaba yé œ sœ kœdji tshelœ katanœ. Ataa, endje sœ kœzu elenœ: Anganœ kama bale (100), anganœ zazu votɔ yé anganœ ndje zazu bale dœ ndjokpa.» ");
INSERT INTO mnh_vpl VALUES ("MT13_24","070_13_24","MAT","13","24","24","Yisu kpa pa anga angbɨ ndœma toro fœ endje adœke: «Ogo gbozu nœ tshalafo sœ ɓata anga uzu bale á tshe lu ɔtshɔ ngwarœ ga lœ kɨndɨ nœ ye. ");
INSERT INTO mnh_vpl VALUES ("MT13_25","070_13_25","MAT","13","25","25","Dœ anga butshɔ bale, dœ lɔndɔ á azu lo lima, anga yingba ye bale na, œ lu ekpe gusu ɓa uguru ble yé œ gu daye. ");
INSERT INTO mnh_vpl VALUES ("MT13_26","070_13_26","MAT","13","26","26","Lɔkɔ á blenœ gerœ lima yé á tetœ kœle tœnœ, ekpe gusunœ wuta ndje. ");
INSERT INTO mnh_vpl VALUES ("MT13_27","070_13_27","MAT","13","27","27","Aayi akwa nœ ayengɔ kɨndɨnœ na œ pandœ nœ fœ she adœke: “Gbozu, ɓœ lu lima ɔtshɔ ngwarœ ga lœ kɨndɨ nœ zœ, yé ekpe gusunœ kpa to kpœta a?” ");
INSERT INTO mnh_vpl VALUES ("MT13_28","070_13_28","MAT","13","28","28","Tshe gi fœ endje adœke: “Anga yingba bale dá mbœrœ œrœnœ asœmœ.” Yé aayi akwanœ kœyu she adœke: “Ɓœ yindœ nœ adœke, 'a na œ su ekpe gusunœ ye a?” ");
INSERT INTO mnh_vpl VALUES ("MT13_29","070_13_29","MAT","13","29","29","Tshe gi adœke: “Œ̃ œ̃ nene. Gbambanœ nene, œdœ 'e kœsœ kœsu tœnœ, œ mbœrœ adœke 'e ngbɔɓa dœ blenœ œ su va 'e. ");
INSERT INTO mnh_vpl VALUES ("MT13_30","070_13_30","MAT","13","30","30","'E katœ nœ œ gerœ awa bale œrrr ga tœ kœgbɔ tœnœ, yé dœ lɔkɔ kœkɔ tœnœ, mœ pa bala fœ aayi kœkɔ ngwarœ adœke: 'E su ekpe gusunœ utshunœ œ i agbanœ dœ agbanœ mbœrœ kœko va ga tœ owo. Manda nœ, 'e ko ble gu tœnœ ga la kogba nœ mœ.”» ");
INSERT INTO mnh_vpl VALUES ("MT13_31","070_13_31","MAT","13","31","31","Yisu kpa pandœ anga ndœma toro fœ endje adœke: «Ogo gbozu nœ tshalafo sœ ɓata ele ɔyɔ á ɨ'ɨrɨnœ kœdœ mutarde á uzu œ za á lu ga lœ kɨndɨ nœ ye. ");
INSERT INTO mnh_vpl VALUES ("MT13_32","070_13_32","MAT","13","32","32","Œtœnœ kœdœ leyɔ á sœ teasho lœ indji ngwarœ kɔ, kashe œ kœgerœ, œ ropa kako dɔngɔ kɔ lœ kɨndɨ yé œ fa egerœ ɔyɔ á ayanu sœ kœna kœmɔ koma endje ga lœ ganeanœ.» ");
INSERT INTO mnh_vpl VALUES ("MT13_33","070_13_33","MAT","13","33","33","Yisu kpa pa anga angbɨ ndœma toro fœ endje adœke: «Ogo gbozu nœ tshalafo sœ ɓata ɔyɔ kœsuku mapa á anga yashe bale za, á djanga dœ kilo zuwa ble votɔ œrrr adœke zuwa blenœ suku.» ");
INSERT INTO mnh_vpl VALUES ("MT13_34","070_13_34","MAT","13","34","34","Yisu pa o'onœ kɔ asœmœ fœ ukpulu azu lœ ndœma toro. Tshe sœ lima kœpa o'o fœ endje kolœ lœ ndœma toro. ");
INSERT INTO mnh_vpl VALUES ("MT13_35","070_13_35","MAT","13","35","35","Tshe mbœrœ lima ataa mbœrœ á o'o á ayi kœgbara o'o gbara lima kœmbœrœtœ endje. Tshe gbara lima adœke: «Mœ pa bala o'o lœ ndœma toro, mœ mɨndœ œrœ á zatœ ye yiwa tœnœ kœto ɓa tœ ali kœmbœrœ tshapashɔ.» ");
INSERT INTO mnh_vpl VALUES ("MT13_36","070_13_36","MAT","13","36","36","Manda nœ, Yisu katœ ukpulu azunœ œ gu ga sœnda. Ayambarœ nœ ye na ndoo dœ she, yé œ yu she adœke: «Mɨndœ ádá ndœma toro nœ ekpe gusu á sœ ɓa lœ kɨndɨ fœ 'a kane.» ");
INSERT INTO mnh_vpl VALUES ("MT13_37","070_13_37","MAT","13","37","37","Yisu gi fœ endje atake: «Uzu á tshe lu ɔtshɔ indji ngwarœ, œshe kœdœ Gbolo nœ uzu. ");
INSERT INTO mnh_vpl VALUES ("MT13_38","070_13_38","MAT","13","38","38","Kɨndɨ kœdœ tshapashɔ. Ɔtshɔ indji ngwarœ sœ kœma azu neke á endje zatœ endje ga tshakudu ogo gbozu. Ekpe gusu sœ kœma azu neke á endje sœ kœza awa ekperœ. ");
INSERT INTO mnh_vpl VALUES ("MT13_39","070_13_39","MAT","13","39","39","Yingba á tshe lu ekpe gusu kœdœ djaboro. Kœgbɔ ngwarœ kœdœ kœka tshapashɔ; yé aayi kœkɔ ngwarœnœ kœdœ aandjelu. ");
INSERT INTO mnh_vpl VALUES ("MT13_40","070_13_40","MAT","13","40","40","Awa bale mara á endje ngbɔɓa ekpe gusu ndœ kœsho tœnœ ɓa tœ ala owo, œ sœ ndje awa bale dœ lɔkɔ nœ kœka tshapashɔ. ");
INSERT INTO mnh_vpl VALUES ("MT13_41","070_13_41","MAT","13","41","41","Gbolo nœ uzu œ vwa aandjelu nœ ye, endje gi azu kɔ á endje sœ kœfa gbetshelœ nœ anga endje tœ kœyindœrœ œdœ pe azu á endje sœ kœmbœrœ ekperœ, ga ushu lœ Ogo gbozu nœ Ndjaba. ");
INSERT INTO mnh_vpl VALUES ("MT13_42","070_13_42","MAT","13","42","42","Tshe ko endje va ga la owo; ɓa zœ endje kɨ dœ ngola endje ye yé œ zɨ tshelœ daji endje gbagbara gbagbara. ");
INSERT INTO mnh_vpl VALUES ("MT13_43","070_13_43","MAT","13","43","43","Kashe endjeneke á endje zatœ endje fœ Ndjaba, endje tshi ɓata ɨshirɨ ɔlɔ ɓa lœ Ogo gbozu nœ Aba endje. Kaka uzu á tshe sœ dœ utu, tshe dji!» ");
INSERT INTO mnh_vpl VALUES ("MT13_44","070_13_44","MAT","13","44","44","«Ogo gbozu nœ tshalafo sœ ɓata ɔtshɔrœ nœ ngendja á zatœ endje yiwa tœnœ ɓa lœ kɨndɨ á uzu gbɔ yé á kpa za tshandœnœ yiwa tœnœ. Tshe sœ dœ yanga kœrosœ nœ, œ gu œ ka œrœ nœ ye kɔ á tshe sœ dœ tœnœ yé á kwatœ ye á yɔ kɨndɨnœ asœmœ.» ");
INSERT INTO mnh_vpl VALUES ("MT13_45","070_13_45","MAT","13","45","45","«Ogo gbozu nœ tshalafo sœ ɓata ayi kœka œrœ á tshe sœ kœpara ɔgbɔ œrœ tshelœgɨ. ");
INSERT INTO mnh_vpl VALUES ("MT13_46","070_13_46","MAT","13","46","46","Lɔkɔ á tshe kœgbɔ œrœnœ á œsœnœ lɨ, tshe ka œrœ kɔ á tshe sœ dœ tœnœ yé œ yɔ dœ ɔgbɔ œrœ tshelœgɨnœ asœmœ ye.» ");
INSERT INTO mnh_vpl VALUES ("MT13_47","070_13_47","MAT","13","47","47","«Ogo gbozu nœ tshalafo kpa sœ ɓata gbánda á endje vwi ga la egerœ ungu adanga yé á sœ kœko tshelœ aka ageatshalangu kɔ. ");
INSERT INTO mnh_vpl VALUES ("MT13_48","070_13_48","MAT","13","48","48","Lɔndɔ á kœsu kperœ, aayi kœpara ageatshalangu œ gbota ga tœ mangu, manda nœ endje sœ ga atɨ mbœrœ kœko ageatshalangunœ lœnœ. Endje ko ɔtshɔ endje ga lœ kingi yé œ ko endjeneke á endje lili nene va e. ");
INSERT INTO mnh_vpl VALUES ("MT13_49","070_13_49","MAT","13","49","49","Bala kœka ndje tshapashɔ œ sœ ndje kolœ ataa: aandjelu œ na bala kœkurutshelœ aayi katshalɔsu dœ aayi ɔtshɔ azu ");
INSERT INTO mnh_vpl VALUES ("MT13_50","070_13_50","MAT","13","50","50","mbœrœ kœko endje va ga la owo. Ɓa zœ dá azu ndjoro œ kɨ yé á zɨ tshelœ daji endje gbagbara gbagbara.» ");
INSERT INTO mnh_vpl VALUES ("MT13_51","070_13_51","MAT","13","51","51","Yisu yu endje adœke: «'E wusœ ádá o'onœ asœmœ kɔ yé a?» Endje gi adœke: «Œ̃.» ");
INSERT INTO mnh_vpl VALUES ("MT13_52","070_13_52","MAT","13","52","52","Yé tshe kœpa fœ endje adœke: «Dœ tœnœ ataa, ayi kœyisœ awa akwa kɔ á tshe te yambarœ nœ Ogo gbozu nœ tshalafo, tshe sœ ɓata anga ayengɔ œrœ á tshe gbɔ tafo œrœ œdœ pe ongboro œrœ lœ kœgbɔrœ nœ ye.» ");
INSERT INTO mnh_vpl VALUES ("MT13_53","070_13_53","MAT","13","53","53","Lɔndɔ á Yisu pa o'o lœ ndœma toronœ asœmœ á ka, tshe katœ tshakpœtœmœ tɨ, ");
INSERT INTO mnh_vpl VALUES ("MT13_54","070_13_54","MAT","13","54","54","yé œ gu ga lakpɨ nœ ye. Tshe tetœ kœyisœ œrœ neke á sœ ndjii ɓa lœ Sinagoga nœ endje yé azu kɔ á endje sœ lima kpœtœmœ, kɨ lima tœ œsœnœ. Endje pa lima adœke: «Tshe gbɔ kœwusœtœ œdœ pe gbɔgbɔ nœ kœmbœrœ dœ afánœ asœke kpœta a? ");
INSERT INTO mnh_vpl VALUES ("MT13_55","070_13_55","MAT","13","55","55","Œ dœ́dœ́ gbolo nœ ayi kœguma maɓaya dœke nene a? Ayinœ dœ́dœ́ Mareya nene a? Jake, Yozefu, Shimu œdœ pe Yuda kœdœ aaya nœ nene a? ");
INSERT INTO mnh_vpl VALUES ("MT13_56","070_13_56","MAT","13","56","56","Yé ayingɔnœ kɔ sœsœ ɓa ugurutœ azœ nene a? Tshe gbɔ gbɔgbɔnœ asœke kɔ kpœta a?» ");
INSERT INTO mnh_vpl VALUES ("MT13_57","070_13_57","MAT","13","57","57","Yé œrœnœ asœmœ mbœrœ lima adœke endje sœ dœ kœyindœrœ ga ndœ ye nene. Á Yisu kœpa fœ endje adœke: «Endje lɨsœ ayi kœgbara o'o tœ osho kɔ, kashe ɓa lakpɨ nœ ye œdœ ɓa lœ bɨngɨ nœ ye, endje lɨsœ ye nene.» ");
INSERT INTO mnh_vpl VALUES ("MT13_58","070_13_58","MAT","13","58","58","Yisu mbœmbœrœ afá ɓa zœ ndjoro nene kolœ mangba kœtshapu kœyindœrœ nœ endje. ");
INSERT INTO mnh_vpl VALUES ("MT14_1","070_14_1","MAT","14","1","1","Dœ lɔndɔnœ asœmœ, Erode á tshe dœ́ lima gbozu tshapa ogo Galilayi, djindœ œneke kɔ á Yisu mbœrœ ");
INSERT INTO mnh_vpl VALUES ("MT14_2","070_14_2","MAT","14","2","2","yé œ pa fœ aayi akwa nœ ye adœke: «Yowane ayi kœza batisimu dœmœ! Œshe dá she lœ akuzu asœmœ! Mbœrœ tœnœ ataa á tshe sœ dœ gbɔgbɔ ndœ kœfarœ asœmœ.» ");
INSERT INTO mnh_vpl VALUES ("MT14_3","070_14_3","MAT","14","3","3","Andaa, Erode za lima awa adœke endje za Yowane œ i she dœ djingiri, yé œ vwi she ga lœ anda kánga mangba Erodiade, awo ayanœ dœ Filipo. ");
INSERT INTO mnh_vpl VALUES ("MT14_4","070_14_4","MAT","14","4","4","Gbambanœ nene, Yowane sœ lima kœpa fœ Erode adœke: «Œ lili adœke ɓœ za Erodiade tœ awo zœ nene!» ");
INSERT INTO mnh_vpl VALUES ("MT14_5","070_14_5","MAT","14","5","5","Erode yi lima ndœ kœwo Yowane kashe awa Ayuda dá sœ lima kœza she. Gbambanœ nene, endje kɔ, endje wu lima Yowane ɓata ayi kœgbara o'o tako. ");
INSERT INTO mnh_vpl VALUES ("MT14_6","070_14_6","MAT","14","6","6","Ataa, dœ lɔkɔ angbo olo kœzu Erode, yawuru nœ Erodiade vitœ ye ɓa utshu azu á endje na ndœ angbonœ. Tshe za lima yanga fœ Erode tɔpanœ kpuru, ");
INSERT INTO mnh_vpl VALUES ("MT14_7","070_14_7","MAT","14","7","7","yé Erode dara ama ye adœke œne to œrœ kɔ á tshe yu œne tœnœ fœ she ye. ");
INSERT INTO mnh_vpl VALUES ("MT14_8","070_14_8","MAT","14","8","8","Tshe dji upu á ayinœ mɨ fœ she yé œ yɔsho ndœ œrœ ɓa ndœ Erode adœke: «Za kumu Yowane ayi kœza batisimu ga lœ saani fœ mœ!» ");
INSERT INTO mnh_vpl VALUES ("MT14_9","070_14_9","MAT","14","9","9","Oyo za gbozugo. Kashe kolœ mangba kœdarama ye á tshe dara ɓa utshu azu nœ ye á tshe e endje, tshe za awa adœke endje za tœnœ fœ she. ");
INSERT INTO mnh_vpl VALUES ("MT14_10","070_14_10","MAT","14","10","10","Tshe vwa anga uzu bale adœke tshe na œ wa kumu Yowane ayi kœza batisimu ɓa lœ anda kánga. ");
INSERT INTO mnh_vpl VALUES ("MT14_11","070_14_11","MAT","14","11","11","Endje za kumu ye ga lœ saani gutœnœ, œ za fœ ovoro yawurunœ yé á tshe za fœ ayinœ. ");
INSERT INTO mnh_vpl VALUES ("MT14_12","070_14_12","MAT","14","12","12","Ayambarœ nœ Yowane na œ za lima oko ye á shi. Manda nœ, endje na lima œ pandœ œneke á mbœrœtœ endje asœmœ fœ Yisu. ");
INSERT INTO mnh_vpl VALUES ("MT14_13","070_14_13","MAT","14","13","13","Lɔkɔ á Yisu dji o'onœ asœmœ, tshe katœ tshakpœtœmœ tɨ yé œ ɔ ga lœ egerœ agba mbœrœ kœro ga tœ osho á azu gugu tœnœ nene. Kashe ukpulu azu lakpɨ djezœ dji œsœnœ yé œ na manda ye. ");
INSERT INTO mnh_vpl VALUES ("MT14_14","070_14_14","MAT","14","14","14","Lɔkɔ á Yisu wuta lœ egerœ agba, tshe wu ukpulu azu ndjoro, œ sœ dœ oyo tœ lɔsu ye mbœrœ endje yé œ tetœ kœshe agbakɨndɨ nœ endje. ");
INSERT INTO mnh_vpl VALUES ("MT14_15","070_14_15","MAT","14","15","15","Dœ lɔndɔ á ɔlɔ te lima tœ kœdɨ tœnœ, ayambarœ nœ Yisu na ndoo dœ she œ pa adœke: «Ɔlɔ dɨ ye yé oshonœ asœke azu gugu tœnœ nene; gi ukpulu azunœ asœke dœ́ endje gu ga lakpɨ œ yɔ kœzɨrœ nœ endje.» ");
INSERT INTO mnh_vpl VALUES ("MT14_16","070_14_16","MAT","14","16","16","Yisu gi fœ endje adœke: «Ádánœ adœke endje gu, gugu nene. 'E to kœzɨrœ fœ endje dœ tœ 'e!» ");
INSERT INTO mnh_vpl VALUES ("MT14_17","070_14_17","MAT","14","17","17","Kashe endje pa fœ she adœke: «'A sœ kolœnœ kpœke dœ mapa mindu œdœ dœ ageatshalangu bisha.» ");
INSERT INTO mnh_vpl VALUES ("MT14_18","070_14_18","MAT","14","18","18","Yisu kœpa fœ endje adœke: «'E ko rotœnœ fœ mœ ga mœ.» ");
INSERT INTO mnh_vpl VALUES ("MT14_19","070_14_19","MAT","14","19","19","Manda nœ, tshe pa fœ ukpulu azunœ adœke endje sœ ga atɨ ga pa gusu. Tshe ko mapa sœmœ mindu dœ ageatshalangu bisha œ tɨ ala ye ga lafo, yé œ donga Ndjaba. Tshe kavwa tshelœ mapa œ ko fœ ayambarœ nœ ye, á endje kurutshelœnœ tœ ukpulu azunœ. ");
INSERT INTO mnh_vpl VALUES ("MT14_20","070_14_20","MAT","14","20","20","Uzu dœ uzu zɨ œrrr kpœtœ ama ogo nœ ye. Ayambarœ ko udunœ á sœpe kperœ kperœ dœ kingi ndjokpa dœ bisha. ");
INSERT INTO mnh_vpl VALUES ("MT14_21","070_14_21","MAT","14","21","21","Tœ kœdɨ ayashe dœ pe agbolo nene, azu á endje zɨ lima œrœnœ, sœ ga pa œrœ nœ́ ayakoshe kutu mindu (5.000). ");
INSERT INTO mnh_vpl VALUES ("MT14_22","070_14_22","MAT","14","22","22","Manda nœ atake, Yisu pa fœ ayambarœ nœ ye adœke endje ɔ ga lœ egerœ agba dœ́ œ zu ga ɨtshi egerœ ungu adanga utshu œne. Andaa, tshe sœpe œnœ ye lima kœgi ukpulu azunœ ga manda endje. ");
INSERT INTO mnh_vpl VALUES ("MT14_23","070_14_23","MAT","14","23","23","Yé manda kœgi ukpulu azunœ asœmœ ga manda endje, tshe ɔ ɓa pa kaga mbœrœ kœza avwala. Lɔkɔ á ɔlɔ dɨ, tshe sœpe lima ɓa zœ kutɨ ye; ");
INSERT INTO mnh_vpl VALUES ("MT14_24","070_14_24","MAT","14","24","24","egerœ agba wuta lima lœ ɨngɨrɨnœ tœ ɔshɔ ye. Loko sœ lima kœyakpa egerœ agbanœ; gbambanœ nene, yugu sœ lima kœza gu tœnœ dja ga utshunœ. ");
INSERT INTO mnh_vpl VALUES ("MT14_25","070_14_25","MAT","14","25","25","Dœ ɔgbɔ butshɔ, Yisu na pa ɔkɔ ungu dœ ada ye ga ndœ ayambarœ nœ ye. ");
INSERT INTO mnh_vpl VALUES ("MT14_26","070_14_26","MAT","14","26","26","Lɔkɔ á endje wu lima she kœna pa ɔkɔ ungu atake, awa za endje yé endje pa adœke: «Asœke kœdœ ngandoro!» Yé endje ve rawa dœ awa kɔ. ");
INSERT INTO mnh_vpl VALUES ("MT14_27","070_14_27","MAT","14","27","27","Kashe ngbewo, Yisu kœpa fœ endje adœke: «'E sœ dœ gbɔgbɔ, œmœ dœmœ! Awa zaza 'e nene!» ");
INSERT INTO mnh_vpl VALUES ("MT14_28","070_14_28","MAT","14","28","28","Yé á Petro kœpa fœ she adœke: «Gbozu, œ kœdœ adja œɓœ dœmœ, za awa adœke mœ na pa ɔkɔ ungu ga ndœ zœ.» ");
INSERT INTO mnh_vpl VALUES ("MT14_29","070_14_29","MAT","14","29","29","Yisu gi fœ she adœke: «Na ga mœ zœ!» Petro kœjerœ lœ egerœ agba yé œ kœtetœ kœna pa ɔkɔ ungu na tœnœ ga ndœ Yisu. ");
INSERT INTO mnh_vpl VALUES ("MT14_30","070_14_30","MAT","14","30","30","Kashe lɔndɔ á tshe wu adœke yugu rosœ nœ ye, awa za she, tshe tetœ kœnduru tœnœ ga la ungu yé œ ta rawa adœke: «Gbozu, she mœ kane!» ");
INSERT INTO mnh_vpl VALUES ("MT14_31","070_14_31","MAT","14","31","31","Ngbewo Yisu kœyi kane ye á kœtepa ye, yé á kœpa fœ she adœke: «Uzu á tshe sœ dœ kœyindœrœ teasho! Mbœrœ gaɗe á ɓœ sœ kœshara upu a?» ");
INSERT INTO mnh_vpl VALUES ("MT14_32","070_14_32","MAT","14","32","32","Endje ɔ bibisha ga lœ egerœ agba yé yugu katœ nœ ye. ");
INSERT INTO mnh_vpl VALUES ("MT14_33","070_14_33","MAT","14","33","33","Ayambarœ á endje sœ lima ɓa lœ egerœ agba, gote dœ matshukuda endje ga utshu Yisu yé œ pa adœke: «Adja œɓœ kœdœ Gbolo nœ Ndjaba!» ");
INSERT INTO mnh_vpl VALUES ("MT14_34","070_14_34","MAT","14","34","34","Manda kœzu ungunœ, endje wuta ga lœ ogo Genazarete. ");
INSERT INTO mnh_vpl VALUES ("MT14_35","070_14_35","MAT","14","35","35","Azu oshonœ asœmœ wu lima sœ Yisu ye, œ pandœ kœyikumu ye fœ azu dje lœ ogonœ kɔ, yé á endje ko aayi koɓa kɔ natœnœ fœ she. ");
INSERT INTO mnh_vpl VALUES ("MT14_36","070_14_36","MAT","14","36","36","Endje sœ lima kœdɨtshelœma endje fœ she adœke tshe katœ amba ama yɔgbɔdɔ lœba nœ ye fœ endje dœ́ endje goro. Yé endjeneke kɔ á endje sœ lima kœgoro tœnœ, she lima lœ koɓa nœ endje ye. ");
INSERT INTO mnh_vpl VALUES ("MT15_1","070_15_1","MAT","15","1","1","Afarisayi œdœ aayi kœyisœ awa akwa to ɓa lœ Yerusaleme œ na ga ndœ Yisu, yé œ yu she adœke: ");
INSERT INTO mnh_vpl VALUES ("MT15_2","070_15_2","MAT","15","2","2","«Mbœrœ gaɗe á ayambarœ nœ zœ sœsœ kœmbœrœtœ endje liaka o'o ama agbozu Ikrizia nene a? Gbambanœ nene, endje sœsœ kœdjutɔ kane endje utshu kœzɨrœ nene.» ");
INSERT INTO mnh_vpl VALUES ("MT15_3","070_15_3","MAT","15","3","3","Yisu gi fœ endje adœke: «Ka e'e a, mbœrœ gaɗe á 'e zaza awa o'o nœ Ndjaba ga tœ akwa nene yé á sœ kœmbœrœtœ 'e lindœ o'o ama alata 'e a? ");
INSERT INTO mnh_vpl VALUES ("MT15_4","070_15_4","MAT","15","4","4","Gbambanœ nene, Ndjaba pa adœke: “Lɨ œsœ aba zœ dœ ayi zœ.” Tshe pa ndje adœke: “Tsheneke á tshe kœgu œsœ abanœ too œsœ ayinœ, tshe li kœgbɔ djofele nœ kuzu.” ");
INSERT INTO mnh_vpl VALUES ("MT15_5","070_15_5","MAT","15","5","5","Kashe e'e, 'e sœ kœpa adœke uzu kœpa fœ abanœ too fœ ayinœ adœke: “Œrœ á mœ yi má ndœ kœto tœnœ fœ ɓœ kœdœ makabo á mœ gumasœ nœ fœ Ndjaba”, ");
INSERT INTO mnh_vpl VALUES ("MT15_6","070_15_6","MAT","15","6","6","uzunœ asœmœ œ lɨsœ abanœ too ayinœ nene. Œtœnœ ataa á 'e za o'o ama Ndjaba vwi'i, yé á ga kolœ ndœ kœmbœrœ œrœ lindœ o'o ama aata 'e. ");
INSERT INTO mnh_vpl VALUES ("MT15_7","070_15_7","MAT","15","7","7","Wulapatshɔ! Ayi kœgbara o'o Isaya gbara lima o'o dœ ɔtshɔnœ tœ upu nœ 'e lɔkɔ á tshe pa adœke: ");
INSERT INTO mnh_vpl VALUES ("MT15_8","070_15_8","MAT","15","8","8","“Azu asœ sœ kœlɨsœ mœ kolœ lœ ama endje, kashe lɔsu endje sœ zara tœ mœ. ");
INSERT INTO mnh_vpl VALUES ("MT15_9","070_15_9","MAT","15","9","9","Kœdonga osho nœ endje sœ gbambanœ, gbambanœ nene, œrœ á endje sœ kœyisœ nœ kœdœ kolœ o'o á to lœ ama azu.”» ");
INSERT INTO mnh_vpl VALUES ("MT15_10","070_15_10","MAT","15","10","10","Manda nœ, Yisu e ukpulu azu yé œ pa fœ endje adœke: «'E dji yé œ wusœ œneke dœ ɔtshɔnœ kane: ");
INSERT INTO mnh_vpl VALUES ("MT15_11","070_15_11","MAT","15","11","11","Œ dœ́dœ́ œrœ á li ga lœ ama uzu dá fa she tœ ayi uburu nene. Kashe œneke á wuta lœ ama ye dá fa she tœ ayi uburu.» ");
INSERT INTO mnh_vpl VALUES ("MT15_12","070_15_12","MAT","15","12","12","Ayambarœ nœ Yisu kœgitœ endje ga ndœ ye, yé á kœyu she adœke: «Ɓœ wusœ nœ adœke o'o zœ za ókó ga tœ lɔsu Afarisayi i?» ");
INSERT INTO mnh_vpl VALUES ("MT15_13","070_15_13","MAT","15","13","13","Tshe gi adœke: «Ɔyɔ kɔ á dœ́dœ́ Aba mœ á tshe sœ ɓa lafo dá lu nene, endje sú ye. ");
INSERT INTO mnh_vpl VALUES ("MT15_14","070_15_14","MAT","15","14","14","'E katœ endje ye: Endje kœdœ aayibula á endje sœ kœyisœ awa fœ aayibula anga endje. Andaa œdœ ayibula kœsœ kœyisœ awa fœ anga ayibula, endje yo kɔkɔ bibisha ga lœ kudu.» ");
INSERT INTO mnh_vpl VALUES ("MT15_15","070_15_15","MAT","15","15","15","Petro za o'o œ pa fœ she adœke: «Mɨndœ ádá o'o nœ asœmœ fœ a'a kane.» ");
INSERT INTO mnh_vpl VALUES ("MT15_16","070_15_16","MAT","15","16","16","Yisu kœgi adœke: «E'e ndje, 'e gugu damba dœ kœwusœrœ nene a? ");
INSERT INTO mnh_vpl VALUES ("MT15_17","070_15_17","MAT","15","17","17","'E wuwusœ nœ adœke œrœ kɔ á li ga lœ ama uzu sœ kœli ga lœ ye, yé manda nœ á tshe nu ga lœ gbakoto nene a? ");
INSERT INTO mnh_vpl VALUES ("MT15_18","070_15_18","MAT","15","18","18","Kashe œneke á wuta ɓa lœ ama uzu to ɓa lɔsu, yé œtœnœ dá fa she tœ ayi uburu. ");
INSERT INTO mnh_vpl VALUES ("MT15_19","070_15_19","MAT","15","19","19","Gbambanœ nene, gbetshelœ nœ kœmbœrœ ekperœ to ɓa tœ lɔsu uzu, gbetshelœ ɓata: Kœwo azu, kœpara awo azu, kœmbœrœ angba budu, kœzɨ angba, kœpa ekpe o'o tœ upu nœ uzu dœ pe kœgu osho. ");
INSERT INTO mnh_vpl VALUES ("MT15_20","070_15_20","MAT","15","20","20","Œrœ á fa uzu tœ ayi uburu dœ mœ! Kashe utshu kœzɨ œrœ á ɓœ kœdjudjutɔ kane zœ nene, œ fa ɓœ tœ ayi uburu nene.» ");
INSERT INTO mnh_vpl VALUES ("MT15_21","070_15_21","MAT","15","21","21","Manda nœ, Yisu áalafo lakpɨnœ asœmœ, œ gitœ ye ga lœ ogo Tire dœ pe Sidona. ");
INSERT INTO mnh_vpl VALUES ("MT15_22","070_15_22","MAT","15","22","22","Anga yashe Kanana bale á tshe sœ lima kœsœ kpœtœmœ na, yé œ tetœ kœtarawa adœke: «Wu oyo mœ, Gbozu, Gbolo nœ Davidi! Ekpe ɨshirɨ sœ kœndanga yawuru nœ mœ tɔpanœ kpuru.» ");
INSERT INTO mnh_vpl VALUES ("MT15_23","070_15_23","MAT","15","23","23","Kashe Yisu gigi o'o bale fœ she nene. Ayambarœ nœ ye na á kɨ ga tœ ye adœke: «Gɔrɔ she ye, mbœrœ tshe sœ kœna manda azœ dœ rawa.» ");
INSERT INTO mnh_vpl VALUES ("MT15_24","070_15_24","MAT","15","24","24","Yisu kœgi adœke: «Endje vwa mœ kolœ fœ agbolo Israyele á endje sœ ɓata apata á endje yiwa.» ");
INSERT INTO mnh_vpl VALUES ("MT15_25","070_15_25","MAT","15","25","25","Kashe yashenœ asœmœ na œ gote ga utshu ye, yé œ pa adœke: «Gbozu, tɨ kane mœ ga lafo!» ");
INSERT INTO mnh_vpl VALUES ("MT15_26","070_15_26","MAT","15","26","26","Yisu gi adœke: «Œ sœsœ dœ ɔtshɔnœ kœko kɨzɨrœ nœ agbolo mbœrœ kœko tœnœ va fœ ayavoro nene.» ");
INSERT INTO mnh_vpl VALUES ("MT15_27","070_15_27","MAT","15","27","27","Yashenœ gi adœke: «Adjapu Gbozu, kashe ayavoro zɨ ndœma kœzɨrœ á yo tœ ama gbozu nœ endje ga tshakudu ndaba kɨzɨrœ.» ");
INSERT INTO mnh_vpl VALUES ("MT15_28","070_15_28","MAT","15","28","28","Yé Yisu gi fœ she adœke: «Yashe, kœyindœrœ nœ zœ gerœ waa! Œ mbœrœtœ endje fœ ɓœ ɓata á ɓœ yindœ nœ.» Yé ngbewo, yawuru nœ ye kœshe pe dœ lɔkɔnœ asœmœ ye. ");
INSERT INTO mnh_vpl VALUES ("MT15_29","070_15_29","MAT","15","29","29","Yisu wuta lœ ogonœ asœmœ yé œ ro ga tœ mangu egerœ ungu adanga lœ Galilayi. Tshe ɔ ga pa kaga yé œ sœ ga atɨ. ");
INSERT INTO mnh_vpl VALUES ("MT15_30","070_15_30","MAT","15","30","30","Azu ndjoro na ga ndœ ye. Endje na dœ azu á ada endje ndɨ, dœ aayibula, dœ aayi vwɨrɨtɨ, dœ aayi bitu, dœ pe anga aayi koɓa ndjoro. Endje katœ endje ga utshu Yisu, yé á tshe she endje. ");
INSERT INTO mnh_vpl VALUES ("MT15_31","070_15_31","MAT","15","31","31","Azu katœ ama endje tɨ ɔsɔ lɔkɔ á endje wu aayi bitu kœpa o'o; dœ azu á endje ndɨ, kœshe tœnœ; dœ azu á ada endje ndɨ, kœna ana; dœ pe azu á ala endje bu, á tetœ kœwu osho. Yé á azu kɔ donga mokɔ nœ Ndjaba nœ Israyele. ");
INSERT INTO mnh_vpl VALUES ("MT15_32","070_15_32","MAT","15","32","32","Yisu e ayambarœ nœ ye, œ pa fœ endje adœke: «Oyo azunœ asœ ka mœ waa, gbambanœ nene, endje mbœrœ olo votɔ dœ mœ, yé endje gugu dœ kœzɨrœ nene. Mœ yiyindœ kœgi endje dœ ogo nene: Ete nene, endje mbombo tœ ala awa ye.» ");
INSERT INTO mnh_vpl VALUES ("MT15_33","070_15_33","MAT","15","33","33","Ayambarœ pa fœ she adœke: «A gbɔ má rœgo lœ kpagagashonœ asœke kpœta yeka á kœto fœ endje á endje kœzɨ, á kœle endje a?» ");
INSERT INTO mnh_vpl VALUES ("MT15_34","070_15_34","MAT","15","34","34","Yisu yu endje adœke: «'E sœ dœ mapa koto o?» Endje gi fœ she adœke: «Mindu dœ bisha dœ pe a'eara ageatshalangu teasho.» ");
INSERT INTO mnh_vpl VALUES ("MT15_35","070_15_35","MAT","15","35","35","Yé á tshe kœpa fœ ukpulu azunœ asœmœ adœke endje lœ ga tœ ɔshɔ. ");
INSERT INTO mnh_vpl VALUES ("MT15_36","070_15_36","MAT","15","36","36","Tshe ko mapa mindu dœ bisha dœ pe ageatshalangunœ œ donga Ndjaba, œ ko fœ ayambarœ, yé á ayambarœ kœkurutshelœ nœ tœ ukpulu azunœ. ");
INSERT INTO mnh_vpl VALUES ("MT15_37","070_15_37","MAT","15","37","37","Uzu dœ uzu zɨ œrrr œ le she kpœtœ ama ogo nœ ye. Ayambarœ rɔ ama udu rœgo á sœpe ga lœ kingi mindu dœ bisha (7). ");
INSERT INTO mnh_vpl VALUES ("MT15_38","070_15_38","MAT","15","38","38","Andaa, azu á endje zɨ lima œrœnœ sœ ayakoshe kutu vana, endje dɨdɨ ayashe dœ agbolo nene. ");
INSERT INTO mnh_vpl VALUES ("MT15_39","070_15_39","MAT","15","39","39","Manda kœgi azu gangba endje, Yisu ɔ ga lœ egerœ agba yé œ ro ga lœ ogo Magadane. ");
INSERT INTO mnh_vpl VALUES ("MT16_1","070_16_1","MAT","16","1","1","Afarisayi dœ Asadukayi na ga ndœ Yisu œ tetœ kœgɨ uku ga tœ awa ye. Endje yu she adœke tshe ma anga ambárá afá tœ kœma adœke œ to ɓa lafo. ");
INSERT INTO mnh_vpl VALUES ("MT16_2","070_16_2","MAT","16","2","2","Yisu gi fœ endje adœke: «Dœ adɨla, 'e sœ kœpa adœke: “Yavuru œ ni nene, mbœrœ tshalafo sœ tshee.” ");
INSERT INTO mnh_vpl VALUES ("MT16_3","070_16_3","MAT","16","3","3","Yé pe dœ amazɨ tuu, 'e sœ kœpa adœke: “Kpesheke yavuru œ ni zœ, mbœrœ tshalafo bu shoshosho.” Ataa 'e wusœ kœpandœ mara á tshalafo sœ dœ tœnœ ye, kashe 'e lili kœpandœ ambárá nœ œrœ nœ tshakpesheke asœ nene. ");
INSERT INTO mnh_vpl VALUES ("MT16_4","070_16_4","MAT","16","4","4","Azu nœ tshakpesheke á endje dœ aekpe azu yé á zazatœ endje fœ Ndjaba nene, sœ kœyɔndœ ambárá! Kashe endje wu anga angbɨ ambárá bale nene, kolœ œnœ Yona œ ka ye. Manda nœ, tshe katœ endje tɨ kpœtœmœ yé œ ro daye.» ");
INSERT INTO mnh_vpl VALUES ("MT16_5","070_16_5","MAT","16","5","5","Lɔkɔ kœzu ayambarœ ga itshi kota, œndœ kœko kœzɨrœ djerœ endje ye. ");
INSERT INTO mnh_vpl VALUES ("MT16_6","070_16_6","MAT","16","6","6","Yisu kœpa fœ endje adœke: «Ala 'e gbɔ dœ ɔyɔ kœsuku mapa nœ Afarisayi dœ pe Asadukayi kane.» ");
INSERT INTO mnh_vpl VALUES ("MT16_7","070_16_7","MAT","16","7","7","Ayambarœnœ te lima tœ kœpa ugurutœ endje adœke: «Tshe sœ kœpa ataa mbœrœ á a nana dœ mapa nene.» ");
INSERT INTO mnh_vpl VALUES ("MT16_8","070_16_8","MAT","16","8","8","Kashe Yisu wu lima sœ gbetshelœ nœ endje, yé œ pa fœ endje adœke: «E'e dœ azu á kœyindœrœ nœ 'e sœ teasho, mbœrœ gaɗe á 'e sœ kœyutœ 'e ugurutœ 'e adœke 'e gugu dœ mapa nene a? ");
INSERT INTO mnh_vpl VALUES ("MT16_9","070_16_9","MAT","16","9","9","Œrrr kpesheke, 'e wuwu damba sœ œrœ nene a? Œndœ mapa mindu á 'e kurutshelœ nœ tœ azu kutu mindu (5.000) œdœ kingi kotoo á 'e ko lima dœ udunœ, djerœ 'e ye a? ");
INSERT INTO mnh_vpl VALUES ("MT16_10","070_16_10","MAT","16","10","10","Œndœ mapa mindu dœ bisha (7) á 'e kuru lima tshelœ nœ tœ azu kutu vana œdœ kingi kotoo á 'e ko lima dœ udunœ, djerœ 'e ye a? ");
INSERT INTO mnh_vpl VALUES ("MT16_11","070_16_11","MAT","16","11","11","Mbœrœ gaɗe á 'e wuwusœ nœ adœke mœ sœsœ lima kœpa o'o tœ mapa fœ 'e nene lɔkɔ á mœ sœ lima kœpa fœ 'e adœke: Ala 'e gbɔ tœ ɔyɔ kœsuku mapa nœ Afarisayi dœ Asadukayi a?» ");
INSERT INTO mnh_vpl VALUES ("MT16_12","070_16_12","MAT","16","12","12","Yé á ayambarœnœ kœwusœ nœ adœke tshe papa o'o tœ upu nœ kœsœ dœ gbɔdjela tœ ɔyɔ kœsuku mapa nene, kashe tshe pa tœ kœyisœrœ nœ Afarisayi dœ pe Asadukayi. ");
INSERT INTO mnh_vpl VALUES ("MT16_13","070_16_13","MAT","16","13","13","Lɔkɔ á Yisu yi kumu ye ga lœ ogo Sezaré, ogo gbozu Filipo, tshe yu ayambarœ nœ ye adœke: «Azu sœ kœpa má kotoo tœ upu nœ Gbolo nœ uzu a?» ");
INSERT INTO mnh_vpl VALUES ("MT16_14","070_16_14","MAT","16","14","14","Endje gi adœke: «Anga azu sœ kœpa adœke, œɓœ kœdœ Yowane ayi kœza batisimu; anga endje sœ kœpa ndje adœke œɓœ kœdœ Eliya; yé anga endje kpa sœ kœ pa œnœ endje adœke, œɓœ kœdœ Yilimiya too anga ayi kœgbara o'o ugurutœ aayi kœgbara o'o liya.» ");
INSERT INTO mnh_vpl VALUES ("MT16_15","070_16_15","MAT","16","15","15","Yé Yisu kœyu endje adœke: «Yé ka e'e a, 'e sœ kœpa má œnœ 'e adœke œmœ kœdœ ɗe?» ");
INSERT INTO mnh_vpl VALUES ("MT16_16","070_16_16","MAT","16","16","16","Shimu Petro za o'o yé á gi adœke: «Œɓœ kœdœ Kristu, Gbolo nœ Ndjaba nœ soro.» ");
INSERT INTO mnh_vpl VALUES ("MT16_17","070_16_17","MAT","16","17","17","Yisu kœpa fœ she adœke: «Yanga nœ zœ, Shimu gbolo nœ Yona, mbœrœ œ dœ́dœ́ ɔkɔ dœ indji dá pandœ o'o asœ fœ ɓœ nene, kashe Aba mœ á tshe sœ ɓa lafo dá pandœ nœ. ");
INSERT INTO mnh_vpl VALUES ("MT16_18","070_16_18","MAT","16","18","18","Yé œmœ, mœ sœ kœpandœ nœ fœ ɓœ adœke œɓœ kœdœ Badja, ga pa badjanœ asœmœ dá mœ mɔ bala Ikrizia nœ mœ, yé kuzu œ sœ bala dœ gbɔgbɔ ga pa Ikrizianœ nene. ");
INSERT INTO mnh_vpl VALUES ("MT16_19","070_16_19","MAT","16","19","19","Mœ za bala herela nœ Ogo gbozu nœ tshalafo fœ ɓœ; œrœ kɔ á ɓœ i ga tœnœ ɓa pa ɔshɔ, Ndjaba œ i ndje ga tœnœ ɓa lafo; œrœ kɔ á ɓœ vwara tshelœnœ ɓa pa ɔshɔ, Ndjaba œ vwara ndje tshelœnœ ɓa lafo.» ");
INSERT INTO mnh_vpl VALUES ("MT16_20","070_16_20","MAT","16","20","20","Manda nœ, Yisu kœkɔ lima ayambarœ nœ ye dœ ɔgbɔ adœke endje papandœ nœ fœ uzu bale adœke œne kœdœ Kristu nene. ");
INSERT INTO mnh_vpl VALUES ("MT16_21","070_16_21","MAT","16","21","21","Kœto kpœtœ lɔkɔnœ asœmœ, Yisu Kristu tetœ kœpandœ nœ fœ ayambarœ nœ ye adœke: «Œ li adœke mœ ro ga lœ Yerusaleme yé œ wu œrœ kanga waa tshakane agbozu Ikrizia, agbozu tshapa anganga Ndjaba ndje dœ aayi kœyisœ awa akwa yekane. Endje wo mœ, yé manda olo votɔ, Ndjaba œ she mœ lœ akuzu.» ");
INSERT INTO mnh_vpl VALUES ("MT16_22","070_16_22","MAT","16","22","22","Yé Petro gi she ga ɨndɨrɨnœ yé œ tetœ kœgbagbara she adœke: «Gbozu, Ndjaba œ gbɔndœ zœ lœnœ ye! Œrœ ataa œ wuta ga tœ zœ nene.» ");
INSERT INTO mnh_vpl VALUES ("MT16_23","070_16_23","MAT","16","23","23","Kashe Yisu fatœ yé œ pa fœ Petro adœke: «Gitœ zœ tœ mœ, Satana! Œɓœ kœdœ uzu nœ kœza o'o ga pa mœ adœke mœ te. Gbetshelœ nœ zœ lili dœ œnœ Ndjaba bale nene, kashe œ li dœ œnœ azu.» ");
INSERT INTO mnh_vpl VALUES ("MT16_24","070_16_24","MAT","16","24","24","Manda nœ, Yisu pa fœ ayambarœ nœ ye adœke: «Œdœ uzu kœyindœ kœna manda mœ, œ li adœke tshe vwaratœ ye tœ undu ye dœ tœ ye, œ za kurushi nœ ye yeka á kœna manda mœ. ");
INSERT INTO mnh_vpl VALUES ("MT16_25","070_16_25","MAT","16","25","25","Gbambanœ nene, uzu kɔ á tshe sœ dœ ogo kœsœ dœ soro œ tshu ye; kashe tsheneke á tshe tshu mbœrœ mœ, œshe dá sœ dœ soro. ");
INSERT INTO mnh_vpl VALUES ("MT16_26","070_16_26","MAT","16","26","26","Ataa uzu kœgbɔ œrœ tshapashɔ asœke kɔ gbaa, œ sœ dœ she kotoo ɓata á soro ye ndɨ a? Œrœ gaɗe dá tshe ka á kpa yɔ dœ soro ye a? ");
INSERT INTO mnh_vpl VALUES ("MT16_27","070_16_27","MAT","16","27","27","Gbolo nœ uzu œ kwa bala tœ ye awa bale dœ aandjelu nœ ye lœ mokɔ nœ Abanœ, yé tshe gi bala fœ uzu dœ uzu liaka akwa tshelœ ye. ");
INSERT INTO mnh_vpl VALUES ("MT16_28","070_16_28","MAT","16","28","28","Mœ sœ kœpa fœ 'e dœ adjapu adœke, ugurutœ 'e á 'e sœ asœ, anga 'e œ tshu nene utshu kœwu Gbolo nœ uzu kœna ɓata gbozugo.» ");
INSERT INTO mnh_vpl VALUES ("MT17_1","070_17_1","MAT","17","1","1","Manda olo mindu dœ bale, Yisu za Petro, Jake œdœ pe ayanœ dœ Yowane po tœ ye, œ gitœ ye dœ endje ga ɨndɨrɨnœ ga pa egerœ kaga. ");
INSERT INTO mnh_vpl VALUES ("MT17_2","070_17_2","MAT","17","2","2","Tshe fatœ ye dœ ala endje; tshatshu ye tetœ kœtshi tœnœ ɓata ɔlɔ, lœba ye wuta tœ imbinœ urrr ɓata ɨshirɨ osho. ");
INSERT INTO mnh_vpl VALUES ("MT17_3","070_17_3","MAT","17","3","3","Ngbewo, Eliya œdœ Moyize wuta ga utshu endje, yé œ sœ kœpa tshama endje dœ Yisu. ");
INSERT INTO mnh_vpl VALUES ("MT17_4","070_17_4","MAT","17","4","4","Petro pa fœ Yisu adœke: «Gbozu, œ sœ dœ ɔtshɔnœ adœke a lœ kpœke. Œdœ ɓœ kœyindœ nœ, mœ mɔ anda tande votɔ: Bale fœ ɓœ, bale fœ Moyize œdœ bale ndje fœ Eliya.» ");
INSERT INTO mnh_vpl VALUES ("MT17_5","070_17_5","MAT","17","5","5","Tshe sœpe damba kœpa 'o atake, trale ondoro jerœ ga pa endje, yé anga tshama wu ɓa lœnœ adœke: «Tsheneke kœdœ Gbolo nœ mœ á mœ yindœ ye waa, mœ za yanga nœ mœ djigi ga ndœ ye. 'E dji she!» ");
INSERT INTO mnh_vpl VALUES ("MT17_6","070_17_6","MAT","17","6","6","Lɔkɔ á ayambarœ dji tshamanœ asœmœ ataa, awa litœ endje kpakpakpa yé endje yo ga atɨ œ fa tshatshu endje ga tœ ɔshɔ. ");
INSERT INTO mnh_vpl VALUES ("MT17_7","070_17_7","MAT","17","7","7","Yisu na ndoo dœ endje œ turutœ endje yé á pa adœke: «'E alafo, 'e sœsœ dœ awa nene.» ");
INSERT INTO mnh_vpl VALUES ("MT17_8","070_17_8","MAT","17","8","8","Kœmesho ga lafo atake, endje wu kolœ Yisu kutɨ ye. ");
INSERT INTO mnh_vpl VALUES ("MT17_9","070_17_9","MAT","17","9","9","Ɓata endje sœ lima kœjerœ kaga, Yisu kɔ endje adœke: «'E papandœ œrœ kɔ á 'e wu asœke fœ uzu bale nene, œrrr ga tœ adœke Gbolo nœ uzu she lœ akuzu yekane.» ");
INSERT INTO mnh_vpl VALUES ("MT17_10","070_17_10","MAT","17","10","10","Yé ayambarœ nœ ye yu she adœke: «Mbœrœ gaɗe á ayi kœyisœ awa akwa pa lima adœke Eliya œ na utshunœ yekane a?» ");
INSERT INTO mnh_vpl VALUES ("MT17_11","070_17_11","MAT","17","11","11","Tshe gi fœ endje adœke: «Adjapu, Eliya œ na utshunœ mbœrœ kœguma œrœ kɔkɔ. ");
INSERT INTO mnh_vpl VALUES ("MT17_12","070_17_12","MAT","17","12","12","Kashe mœ sœ kœpa fœ 'e adœke: Eliya na ɓa lima ye, yé azu yiyindœ ye nene, kashe endje mbœrœ fœ she œneke kɔ á endje yi lima ndœ nœ. Awa bale ndje endje mbœrœ œrœ kanga fœ Gbolo nœ uzu.» ");
INSERT INTO mnh_vpl VALUES ("MT17_13","070_17_13","MAT","17","13","13","Yé á ayambarœ nœ ye kœwusœ nœ adœke, tshe sœ lima kœpa o'onœ fœ œne tœ Yowane ayi kœza batisimu. ");
INSERT INTO mnh_vpl VALUES ("MT17_14","070_17_14","MAT","17","14","14","Lɔkɔ á endje wuta lima ndoo dœ ukpulu azu, anga yakoshe bale na ga ndœ Yisu, œ gote dœ matshukuda ye ga utshu ye á pa adœke: ");
INSERT INTO mnh_vpl VALUES ("MT17_15","070_17_15","MAT","17","15","15","«Gbozu, wu oyo gbolo yakoshe nœ mœ. Tshe sœ dœ koɓa ɔkɔ á sœ ndœ kœka she waa, œ geta she kpala kpala ga tawo too ga langu. ");
INSERT INTO mnh_vpl VALUES ("MT17_16","070_17_16","MAT","17","16","16","Mœ na dœ she fœ ayambarœ nœ zœ, kashe endje lili tœ kœshe she nene.» ");
INSERT INTO mnh_vpl VALUES ("MT17_17","070_17_17","MAT","17","17","17","Yisu kœpa adœke: «E'e kœdœ aekpe azu, yé 'e gugu dœ kœyindœrœ nene! Mœ kpa sœpe dœ 'e œrrr manda olo koto yekane a? Mœ kpa ru lɔsu mœ mbœrœ 'e manda olo koto o? 'E na dœ gbolonœ fœ mœ ga mœ.» ");
INSERT INTO mnh_vpl VALUES ("MT17_18","070_17_18","MAT","17","18","18","Yisu nga fœ ekpe ɨshirɨnœ; tshe wuta lœ gbolonœ yé á tshe kœshe pe dœ lɔndɔnœ asœmœ ye. ");
INSERT INTO mnh_vpl VALUES ("MT17_19","070_17_19","MAT","17","19","19","Ayambarœ gitœ endje ndoo dœ Yisu, yé á yu she yaa adœke: «Yé ká a'a, mbœrœ gaɗe á 'a lili má œnœ 'a kœgɔrɔ ekpe ɨshirɨnœ nene a?» ");
INSERT INTO mnh_vpl VALUES ("MT17_20","070_17_20","MAT","17","20","20","Yisu pa fœ endje adœke: «Mbœrœ kœyindœrœ nœ 'e sœ teasho. Mœ sœ kœpa tœnœ fœ 'e dœ adjapu, œdœ anga ɔlɔ bale 'e kœsœ dœ kœyindœrœ á sœ dœ egerœnœ ɓata ele ɔyɔ á ɨ'ɨrɨnœ kœdœ mutarde, 'e pa fœ kaga asœke adœke: “Aafo kpœke œ tɔ ɓa e”, kaga œ mbœrœtœ ye liakanœ ye. Œrœ bale á sœ dœ sharapu ɓa ndœ 'e œ gugu nene.  ");
INSERT INTO mnh_vpl VALUES ("MT17_21","070_17_21","MAT","17","21","21","Kashe kolœ lœ awa nœ avwala œdœ lœ œnœ kœyotshelœma dá endje li kœgɔrɔ dœ mara ekpe ɨshirɨnœ asœke.» ");
INSERT INTO mnh_vpl VALUES ("MT17_22","070_17_22","MAT","17","22","22","Anga ɔlɔ bale, ayambarœ ngbɔɓa lima tœ endje ɓa lœ ogo Galilayi, Yisu pa fœ endje adœke: «Endje ka Gbolo nœ uzu ga tshaabrœ azu; ");
INSERT INTO mnh_vpl VALUES ("MT17_23","070_17_23","MAT","17","23","23","endje wo she yé manda olo votɔ, Ndjaba œ she she lœ akuzu.» Ayambarœ nœ ye sœ lima dœ oyo waa. ");
INSERT INTO mnh_vpl VALUES ("MT17_24","070_17_24","MAT","17","24","24","Ɔlɔ á endje li ga lœ Kaparnawumu, azu á endje ka lapo ɓa lœ Tepelo na ga ndœ Petro, yé á pa fœ she adœke: «Gbozu nœ 'e œ yɔ lapo nœ Tepelo nene a?» ");
INSERT INTO mnh_vpl VALUES ("MT17_25","070_17_25","MAT","17","25","25","Petro gi adœke: «Œ̃, tshe yɔ ye.» Ɔlɔ á Petro yi kumu ye ga sœnda, Yisu yu she adœke: «Gbetshelœ nœ zœ kœdœ gaɗe Shimu? Aɗe dá yɔ walaka lapo nœ agbozugo nœ tshapashɔ a? Agbolo nœ endje too anga angbɨ azu?» ");
INSERT INTO mnh_vpl VALUES ("MT17_26","070_17_26","MAT","17","26","26","Petro gi adœke: «Angbɨ azu.» Yé Yisu kœpa fœ she adœke: «Agbolo nœ endje yɔyɔ ka nene. ");
INSERT INTO mnh_vpl VALUES ("MT17_27","070_17_27","MAT","17","27","27","Kashe a yɔ œnœ azœ ye, mbœrœ á kœzaza ókó fœ azunœ asœ nene. Mbœrœ tœnœ, na ga la kota œ vwi ngada; ali ageatshalangu á ɓœ djɔ she, a tshelœma ye, ɓœ gbɔ langere ngendja lœnœ. Za œ gu dœ tœnœ, œ za fœ endje mbœrœ mœ œdœ pe ɓœ.» ");
INSERT INTO mnh_vpl VALUES ("MT18_1","070_18_1","MAT","18","1","1","Dœ lɔndɔnœ asœmœ, ayambarœ nœ Yisu gitœ endje ga ɨndɨrɨ ye, yé á pa fœ she adœke: «Œɗe dá ropa azu kɔ ɓa lœ Ogo gbozu nœ tshalafo a?» ");
INSERT INTO mnh_vpl VALUES ("MT18_2","070_18_2","MAT","18","2","2","Yisu e anga gbolo œ za she tɔ ga ugurutœ endje ");
INSERT INTO mnh_vpl VALUES ("MT18_3","070_18_3","MAT","18","3","3","yé œ pa adœke: «Mœ sœ kœpa fœ 'e dœ adjapu adœke, œdœ 'e kœyayapatœ 'e yé á sœ ɓata aya agbolo nene, 'e li bala ga lœ Ogo gbozu nœ tshalafo nene. ");
INSERT INTO mnh_vpl VALUES ("MT18_4","070_18_4","MAT","18","4","4","Ataa, tsheneke á tshe mbœrœtœ ye ɓata aya gbolonœ asœ, œshe dá ropa azu kɔ ɓa lœ Ogo gbozu nœ tshalafo. ");
INSERT INTO mnh_vpl VALUES ("MT18_5","070_18_5","MAT","18","5","5","Uzu á tshe za osho kœsœ fœ gbolo lœ ɨ'ɨrɨ mœ ɓata tsheneke asœ, za osho kœsœ fœ mœ dœ tœ mœ ye. ");
INSERT INTO mnh_vpl VALUES ("MT18_6","070_18_6","MAT","18","6","6","«Kashe uzu á tshe mbœrœ adœke anga aya gbolo bale ugurutœ agbolo asœke á endje sœ dœ kœyindœrœ ga ndœ mœ, li ga lœ ekperœ, œ li adœke endje du egerœ badja ga lœ ɨgɨ ye, œ na dœ́ œ geta she ga la egerœ ungu. ");
INSERT INTO mnh_vpl VALUES ("MT18_7","070_18_7","MAT","18","7","7","Oyo nœ azu tshapashɔ á endje sœ kœmbœrœ adœke azu li ga lœ ekperœ! Œ li adœke œrœ ataa mbœrœtœ endje, kashe oyo nœ uzu neke á yanganœ œ te mbœrœ she. ");
INSERT INTO mnh_vpl VALUES ("MT18_8","070_18_8","MAT","18","8","8","Œdœ kane zœ too ada zœ dá sœ kœmbœrœ adœke ɓœ te, wa œ ko va e zara tœ zœ; œ li dœ ɔtshɔnœ mbœrœ ɓœ adœke ɓœ li ga lœ adja soro dœ kane zœ bale too dœ ada zœ bale, tœ œsœnœ adœke ɓœ sœpe dœ kane zœ bibisha œdœ pe ada zœ bibisha yé endje vwi ɓœ ga lœ kudu owo á ru nene. ");
INSERT INTO mnh_vpl VALUES ("MT18_9","070_18_9","MAT","18","9","9","Yé œdœ ala zœ kœvwa ɓœ ndœ ekperœ, vwata yé œ za vwi'i zara tœ zœ, œ li dœ ɔtshɔnœ mbœrœ ɓœ adœke ɓœ li ga lœ adja soro dœ ala zœ bale, tœ œsœnœ adœke ɓœ sœpe dœ ala zœ bibisha yé endje vwi ɓœ ga lœ kudu owo nœ lifelo.» ");
INSERT INTO mnh_vpl VALUES ("MT18_10","070_18_10","MAT","18","10","10","«Ala 'e gbɔ adœke 'e kœgugu œsœ anga gbolo bale ugurutœ aya agbolo asœke nene. Gbambanœ nene, mœ sœ kœpa fœ 'e, aandjelu nœ endje sœ ɔlɔ dœ ɔlɔ ɨndɨrɨ Aba mœ á tshe sœ ɓa lafo.  ");
INSERT INTO mnh_vpl VALUES ("MT18_11","070_18_11","MAT","18","11","11","Gbambanœ nene, Gbolo nœ uzu na ndœ kœshe azu á endje sœ lima lœ djingili. ");
INSERT INTO mnh_vpl VALUES ("MT18_12","070_18_12","MAT","18","12","12","«'E gbe œnœ 'e koto o? Œdœ anga uzu kœsœ dœ apata kama bale (100), yé anga bale lœ ugurutœ endje kœyiwa, ataa tshe katœ udu endje zazu vana dœ ndjokpa dœ mindu dœ amanœ vana (99) ɓa pa kaga, ndœ kœna kœpara tsheneke tshebale á tshe yiwa asœmœ nene a? ");
INSERT INTO mnh_vpl VALUES ("MT18_13","070_18_13","MAT","18","13","13","Œ kœsœ adœke tshe gbɔ she, mœ sœ kœpa fœ 'e dœ adjapu adœke, tshe sœ dœ yanga ye kœropa udu endje zazu vana dœ ndjokpa dœ mindu dœ amanœ vana (99) á endje yiyiwa nene asœmœ. ");
INSERT INTO mnh_vpl VALUES ("MT18_14","070_18_14","MAT","18","14","14","Awa bale, Aba 'e á tshe sœ ɓa lafo asœmœ, yiyindœ nœ adœke anga gbolo bale ugurutœ aya agbolonœ asœmœ yiwa nene.» ");
INSERT INTO mnh_vpl VALUES ("MT18_15","070_18_15","MAT","18","15","15","«Œdœ anga aya zœ kœmbœrœ ekperœ ga tœ zœ, na ga ndœ ye kutu zœ œ gbagbara she tœ ekperœ á tshe mbœrœ, œdœ tshe kœdji ɓœ, dá tshe kpa wuta aya zœ. ");
INSERT INTO mnh_vpl VALUES ("MT18_16","070_18_16","MAT","18","16","16","Œdœ tshe kœdjidji ɓœ nene, kpa za anga uzu bale too bisha ga ndœ zœ yeka á 'e kœwa o'onœ “mbœrœ œ li adœke atimu bisha too votɔ yindœ o'onœ yekane.” ");
INSERT INTO mnh_vpl VALUES ("MT18_17","070_18_17","MAT","18","17","17","Œdœ tshe kœvwaratœ ye ndœ kœdji endje, pandœ nœ ga lœ Ikrizia, yé tshe kœdjidji ndje azu Ikrizia nene, za she ɓata angbɨ uzu too ɓata ayi kœka lapo. ");
INSERT INTO mnh_vpl VALUES ("MT18_18","070_18_18","MAT","18","18","18","«Mœ sœ kœpa fœ 'e dœ adjapu adœke: Œrœ kɔ á 'e i ga tœnœ pa ɔshɔ asœ, endje i ndje ga tœnœ ɓa lafo; yé œrœ kɔ á 'e vwara tshelœ nœ pa ɔshɔ asœ, endje vwara ndje tshelœ nœ ɓa lafo. ");
INSERT INTO mnh_vpl VALUES ("MT18_19","070_18_19","MAT","18","19","19","«Mœ kpa sœ kœpa fœ 'e dœ adjapu adœke, œdœ azu bisha ugurutœ 'e pa ɔshɔ kœpa upu ama endje bale ndœ kœyɔndœ œrœ gaɗe, Aba mœ ɓa lafo œ to œrœnœ asœmœ fœ endje ye. ");
INSERT INTO mnh_vpl VALUES ("MT18_20","070_18_20","MAT","18","20","20","Gbambanœ nene, osho á azu bisha too votɔ œ ngbɔtœ endje ga tœnœ dœ ɨ'ɨrɨ mœ, mœ sœ ugurutœ endje zœ.» ");
INSERT INTO mnh_vpl VALUES ("MT18_21","070_18_21","MAT","18","21","21","Ataa, á Petro na ga ndœ ye á yu she adœke: «Gbozu, œdœ aya mœ kœmbœrœ ekperœ fœ mœ, mœ djerœndœ ekperœnœ awa kotoo? Œrrr ga tœ awa mindu dœ bisha a (7)?» ");
INSERT INTO mnh_vpl VALUES ("MT18_22","070_18_22","MAT","18","22","22","Yisu kœgi fœ she adœke: «Mœ papa fœ ɓœ adœke awa mindu dœ bisha nene, kashe œrrr ga tœ awa zazu votɔ dœ ndjokpa awa mindu dœ bisha. ");
INSERT INTO mnh_vpl VALUES ("MT18_23","070_18_23","MAT","18","23","23","Ogo gbozu nœ tshalafo œ sœ bala kolœnœ ataa: Œ sœ ɓata anga gbozugo bale á tshe yi lima ndœ kœtondœ o'o tœ upu nœ kuɗa nœ ye dœ aayi akwa nœ ye. ");
INSERT INTO mnh_vpl VALUES ("MT18_24","070_18_24","MAT","18","24","24","Tœ ali nœ, endje na dœ anga ayi akwa á tshe sœ dœ kuɗa nœ ye tɔpanœ kpuru fœ she. ");
INSERT INTO mnh_vpl VALUES ("MT18_25","070_18_25","MAT","18","25","25","Ɓata á tshe sœsœ lima dœ œrœ bale ndœ kœgi tœnœ nene, gbozunœ za awa adœke endje za she yɔ œrœ dœ awonœ, agbolo nœ ye, œdœ ndje pe dœ œrœ kɔ á tshe sœ dœ tœnœ lœ okoro kuɗa nœ ye. ");
INSERT INTO mnh_vpl VALUES ("MT18_26","070_18_26","MAT","18","26","26","Ayi akwanœ gote ga tœ ada ye, œ dɨ tshelœma ye fœ she adœke: “Gbozu, sœ dœ ugu lɔsu ga ndœ mœ, yé mœ gi fœ ɓœ para zœ.” ");
INSERT INTO mnh_vpl VALUES ("MT18_27","070_18_27","MAT","18","27","27","Oyo za gbozu nœ ayi akwanœ, tshe katœ ye adœke tshe gu zœ yé œ katœ kuɗa nœ ye lœ kumu ye tɨ ye. ");
INSERT INTO mnh_vpl VALUES ("MT18_28","070_18_28","MAT","18","28","28","«Kœwuta ayi akwa asœmœ atake, tshe togba dœ anga yanganœ á tshe sœ dœ kuɗa nœ ye teasho lœ kumu ye; tshe za ɔngɔrɔ yanganœ kperœ ndœ kœwo she dœ kœpa fœ she adœke: “Gi kuɗa nœ mœ fœ mœ.” ");
INSERT INTO mnh_vpl VALUES ("MT18_29","070_18_29","MAT","18","29","29","Ayi akwa nganœ sœmœ kœgote ga tœ ada ye, yé œ dɨ tshelœma ye fœ she dœ kœpa adœke: “Sœ dœ ugu lɔsu ga ndœ mœ, mœ gi fœ ɓœ zœ.” ");
INSERT INTO mnh_vpl VALUES ("MT18_30","070_18_30","MAT","18","30","30","Kashe tshe vwaratœ ye, yé ga pa nœ tshe na dœ she œ za she vwi ga lœ anda kánga ndœ kœkate adœke tshe gi kuɗa nœ œne yekane. ");
INSERT INTO mnh_vpl VALUES ("MT18_31","070_18_31","MAT","18","31","31","Kœwu œrœ á tshe mbœrœ asœmœ ataa, œ za oyo tœ lɔsu aayi akwa anganœ, yé endje na œ pandœ œrœ kɔ á ro asœmœ fœ gbozu nœ endje. ");
INSERT INTO mnh_vpl VALUES ("MT18_32","070_18_32","MAT","18","32","32","Yé gbozu e she, á pa fœ she adœke: “Ekpe ayi akwa, mœ katœ kuɗa nœ mœ lœ kumu zœ tɨ kɔ mbœrœ á ɓœ dɨtshelœma zœ fœ mœ. ");
INSERT INTO mnh_vpl VALUES ("MT18_33","070_18_33","MAT","18","33","33","Œɓœ ndje, ɓœ lili má ndœ kœwu oyo ayi akwa nga zœ ɓata á œmœ dœ tœmœ mœ wu oyo zœ nene a?” ");
INSERT INTO mnh_vpl VALUES ("MT18_34","070_18_34","MAT","18","34","34","Oko za gbozu, tshe za she vwi ga lœ anda kánga ndœ kœkate ndje adœke tshe kœgi kuɗa nœ œne kɔ fœ œne yekane.» ");
INSERT INTO mnh_vpl VALUES ("MT18_35","070_18_35","MAT","18","35","35","«Ataa, Aba mœ ɓa lafo œ mbœrœ bala mara œrœnœ asœmœ fœ 'e, œdœ uzu dœ uzu ugurutœ 'e kœdjedjerœndœ ekperœ nœ ayanœ dœ lɔsu ye bale nene.» ");
INSERT INTO mnh_vpl VALUES ("MT19_1","070_19_1","MAT","19","1","1","Ɔlɔ á Yisu katœ kœmɨndœ upu asœmœ, tshe gitœ ye lœ Galilayi ndœ kœro ga lœ ogo Yuda ɓa kele ungu Yɔrdane. ");
INSERT INTO mnh_vpl VALUES ("MT19_2","070_19_2","MAT","19","2","2","Azu ndjoro na manda ye, yé ɓa zœ tshe sœ kœshe endje. ");
INSERT INTO mnh_vpl VALUES ("MT19_3","070_19_3","MAT","19","3","3","Anga Afarisayi na ga ndœ ye dœ gbetshelœ nœ kœgɨ uku ga tœ awa ye, yé á yu she adœke: «Œ li dœ yakoshe kovwaratœ ye tœ awonœ lœ upu kɔ a?» ");
INSERT INTO mnh_vpl VALUES ("MT19_4","070_19_4","MAT","19","4","4","Tshe gi fœ endje adœke: «'E dɨdɨ lima œneke á endje sú ɓa la buku nœ Ndjaba adœke, lœ kœmbœrœ œrœ ga pa ɔshɔ asœke, Ndjaba mbœrœ lima yakoshe œdœ yashe nene a? ");
INSERT INTO mnh_vpl VALUES ("MT19_5","070_19_5","MAT","19","5","5","Manda nœ, tshe pa adœke: Mbœrœ tœnœ ataa á yakoshe œ katœ abanœ dœ ayinœ tɨ, á sœ ga tœ œsœnœ dœ awonœ, yeka á endje bisha œ wuta undu uzu tshebale. ");
INSERT INTO mnh_vpl VALUES ("MT19_6","070_19_6","MAT","19","6","6","Ataa, endje kpa sœsœ azu bisha nene kashe undu uzu tshebale. Kaka adœke uzu ndjɔndjɔ tshelœ œneke á Ndjaba ngbɔɓa ga tœ nœ nene.» ");
INSERT INTO mnh_vpl VALUES ("MT19_7","070_19_7","MAT","19","7","7","Endje pa fœ she adœke: «Mbœrœ gaɗe á Moyize za lima awa adœke yakoshe su mbeti kœkurutshelœ totœ ga tshakane yashe lɔkɔ á tshe kœkatœ ye tɨ a?» ");
INSERT INTO mnh_vpl VALUES ("MT19_8","070_19_8","MAT","19","8","8","Yisu gi fœ endje adœke: «Moyize za lima awa ndœ kœkatœ awo 'e tɨ mbœrœ agbɔ lɔsu nœ 'e, kashe utshunœ œ sœsœ lima ataa nene. ");
INSERT INTO mnh_vpl VALUES ("MT19_9","070_19_9","MAT","19","9","9","Mœ sœ kœpandœ nœ fœ 'e adœke, œdœ uzu kœkatœ awonœ tɨ, á kœdœ́dœ́ tœ upu nœ angba budu nene, á tshe kpa to anga angbɨ yashe, tshe sœ kœpara awo uzu.» ");
INSERT INTO mnh_vpl VALUES ("MT19_10","070_19_10","MAT","19","10","10","Ayambarœ kœpa fœ she adœke: «Œdœ upu nœ kœtotœsho nœ yakoshe dœ yashe kœsœ ataa, ádá nœ kœtotœsho gugu nene.» ");
INSERT INTO mnh_vpl VALUES ("MT19_11","070_19_11","MAT","19","11","11","Yisu gi fœ endje adœke: «Œ dœ́dœ́ uzu kɔ dá dji tshelœ kata o'o asœ nene, kashe kolœ endjeneke á Ndjaba za awa fœ endje. ");
INSERT INTO mnh_vpl VALUES ("MT19_12","070_19_12","MAT","19","12","12","Gbambanœ nene, ádá á azu œ vwaratœ endje kœto ayashe sœ ndjoro: Endje zu anga azu dœ koɓa kutshu; anga kœsœ angara to tshakane azu; yé anga azu yiyindœ kœto ayashe nene mbœrœ kœpara Ogo gbozu nœ tshalafo. Uzu á tshe li kœdji tshelœkata o'o asœke kɔ, kaka tshe dji!» ");
INSERT INTO mnh_vpl VALUES ("MT19_13","070_19_13","MAT","19","13","13","Azu na dœ agbolo fœ Yisu adœke tshe to kane ye ga pa endje kashe ayambarœ nœ ye sœ lima kœgeta endje. ");
INSERT INTO mnh_vpl VALUES ("MT19_14","070_19_14","MAT","19","14","14","Yisu pa adœke: «'E katœ agbolo endje na ga ndœ mœ, 'e kɔkɔ endje nene mbœrœ Ogo gbozu nœ tshalafo sœ mbœrœ azu á endje lœ ɓata endje.» ");
INSERT INTO mnh_vpl VALUES ("MT19_15","070_19_15","MAT","19","15","15","Yé manda kœto kane ye ga pa endje, tshe gitœ ye kpœtœmœ ye. ");
INSERT INTO mnh_vpl VALUES ("MT19_16","070_19_16","MAT","19","16","16","Anga uzu bale na ga ndœ Yisu, yé œ yu she adœke: «Ayi kœyisœrœ, ɔtshɔrœ gaɗe dá mœ kœmbœrœ yeka á kœgbɔ soro neke á ka nene a?» ");
INSERT INTO mnh_vpl VALUES ("MT19_17","070_19_17","MAT","19","17","17","Yisu kœpa fœ she adœke: «Mbœrœ gaɗe á ɓœ sœ kœyu mœ pa ɔtshɔrœ a? Kolœ Ndjaba kutɨ ye dá dœ ɔtshɔ uzu. Œdœ ɓœ kœyindœ kœgbɔ soro, gbɔndœ awa o'o ama Ndjaba.» ");
INSERT INTO mnh_vpl VALUES ("MT19_18","070_19_18","MAT","19","18","18","Tshe yu Yisu adœke: «Œneketa a?» Yisu gi fœ she adœke: «Ɓœ wo uzu nene, ɓœ para awo uzu nene, ɓœ zɨ angba nene, ɓœ wa o'o dœ wala ga pa uzu nene. ");
INSERT INTO mnh_vpl VALUES ("MT19_19","070_19_19","MAT","19","19","19","Lɨ œsœ aba zœ dœ ayi zœ, yé ɓœ yindœ yanga zœ ɓata á ɓœ yindœtœ zœ dœ tœ zœ.» ");
INSERT INTO mnh_vpl VALUES ("MT19_20","070_19_20","MAT","19","20","20","Gbolo modonœ gi fœ she adœke: «Œrœnœ asœmœ kɔ, mœ sœ kœmbœrœtœ mœ liakanœ zœ. Œrœ gaɗe dá kpa sœpe adœke mœ mbœrœ a?» ");
INSERT INTO mnh_vpl VALUES ("MT19_21","070_19_21","MAT","19","21","21","Yisu pa fœ she adœke: «Ɓœ kœyindœ kœsœ ndjii tœ ala Ndjaba, gu œ ka œrœ nœ zœ, œ kurutshelœnœ tœ aayi oyo, yé ɓœ gbɔ bala kœgbɔrœ ɓa lafo. Manda nœ, fatœ zœ œ na manda mœ.» ");
INSERT INTO mnh_vpl VALUES ("MT19_22","070_19_22","MAT","19","22","22","Manda o'onœ asœmœ, tshe gu dœ oyo tœ ye, mbœrœ tshe sœ lima dœ œrœ waa. ");
INSERT INTO mnh_vpl VALUES ("MT19_23","070_19_23","MAT","19","23","23","Yé Yisu kœpa fœ ayambarœ nœ ye adœke: «Mœ sœ kœpa dœ adjapu fœ 'e, œ sœ tœ ɔgbɔnœ bala tœ ayi kœgbɔrœ kœli ga lœ Ogo gbozu nœ tshalafo. ");
INSERT INTO mnh_vpl VALUES ("MT19_24","070_19_24","MAT","19","24","24","Yisu kpa pa fœ endje adœke: Œ gbɔɔgbɔ adœke agea á ɨ'ɨrɨ ye kœdœ shamo li tɔlœ ogoro ɨmbɨlɨ. Kashe œ kpa gbɔ kœrosœ nœ adœke ayi kœgbɔrœ li ga lœ Ogo gbozu nœ Ndjaba.» ");
INSERT INTO mnh_vpl VALUES ("MT19_25","070_19_25","MAT","19","25","25","Kœdji o'onœ asœmœ ataa, ayambarœ katœ ama endje tɨ ɔsɔ, yé œ pa adœke: «Atamœ, uzu ɗe dá li kœshe tœnœ a?» ");
INSERT INTO mnh_vpl VALUES ("MT19_26","070_19_26","MAT","19","26","26","Yisu tondœ endje, yé œ pa fœ endje adœke: «Ɓa tœ azu, œ li nene; kashe ɓa tœ Ndjaba, œrœ kɔ li ye.» ");
INSERT INTO mnh_vpl VALUES ("MT19_27","070_19_27","MAT","19","27","27","Yé Petro kœza 'o, á kœpa fœ she adœke: «Wu kane, 'a katœ œrœ nœ 'a tɨ kɔ á na manda zœ asœ; œ sœ bala dœ a'a koto o?.» ");
INSERT INTO mnh_vpl VALUES ("MT19_28","070_19_28","MAT","19","28","28","Yisu pa fœ endje adœke: «Mœ pa fœ 'e dœ adjapu adœke: Ɔlɔ á Ndjaba kpa mbœrœ tshandœ œrœ kɔ tœ tafonœ, olo á Gbolo nœ uzu œ sœ ga lœ ngande mokɔ nœ ye ndœ kœwa ngbanga, e'e á 'e na lima manda mœ, 'e sœ ndje ga pa ngande tshagbozu mokɔ ndjokpa dœ bisha ndœ kœwa ngbanga pa mara azu Israyele ndjokpa dœ bisha. ");
INSERT INTO mnh_vpl VALUES ("MT19_29","070_19_29","MAT","19","29","29","Yé uzu kɔ á tshe katœ anda nœ ye, dœ aayanœ, ayingɔnœ, abanœ, aayinœ, agbolo nœ ye, kɨndɨ nœ ye tɨ mbœrœ ɨ'ɨrɨ mœ, tshe kpa gbɔ œrœ kœropanœ ye, tshe gbɔ ndje soro nœ waa dœ waa. ");
INSERT INTO mnh_vpl VALUES ("MT19_30","070_19_30","MAT","19","30","30","Azu ndjoro á endje sœ utshunœ, endje sœ bala tœ ndɔngɔlɔnœ, yé endje nœ ndɔngɔlɔnœ œ te bala azu nœ tshatshunœ.» ");
INSERT INTO mnh_vpl VALUES ("MT20_1","070_20_1","MAT","20","1","1","«Kœgbɔ Ogo gbozu nœ tshalafo sœ ɓata anga gbozu akwa, á tshe wuta dœ amazɨ kœpara aayi akwa nœ tshelœ kɨndɨ vinu nœ ye. ");
INSERT INTO mnh_vpl VALUES ("MT20_2","070_20_2","MAT","20","2","2","Tshe djitœ ye dœ endje dœ ɔtshɔnœ pa denari bale á li adœke endje gbɔ dœ ɔlɔ bale, yeka á vwa endje ga lœ kɨndɨ vinu nœ ye. ");
INSERT INTO mnh_vpl VALUES ("MT20_3","070_20_3","MAT","20","3","3","Kœwuta she dœ ada ɔlɔ mindu dœ vana utshu kakpi ɔlɔ, tshe wu anga azu, endje sœ gbambanœ, ");
INSERT INTO mnh_vpl VALUES ("MT20_4","070_20_4","MAT","20","4","4","tshe pa fœ endje adœke: “E'e ndje, 'e na ga lœ kɨndɨ vinu nœ mœ, mœ to ndje ngendja á li dœ ɔlɔ bale fœ 'e.” ");
INSERT INTO mnh_vpl VALUES ("MT20_5","070_20_5","MAT","20","5","5","Endje ro ndje da ye. Tshe kpa wuta dœ kakpi ɔlɔ œdœ dœ ada ɔlɔ votɔ manda kakpi ɔlɔ, œ pa kolœnœ ata fœ anga azu á tshe gbɔ endje. ");
INSERT INTO mnh_vpl VALUES ("MT20_6","070_20_6","MAT","20","6","6","Kœwuta ga pa œrœ nœ́ ada ɔlɔ mindu dœ adɨla, tshe kpa wuta ndje, œ kpa gbɔ anga azu á endje sœ ndje ɓa zœ yé œ pa fœ endje adœke: “Mbœrœ gaɗe dá 'e sœ kpœke œrrr kpii á mbœmbœrœ akwa nene a?” ");
INSERT INTO mnh_vpl VALUES ("MT20_7","070_20_7","MAT","20","7","7","Endje gi fœ she adœke: “Uzu bale zaza akwa fœ 'a nene.” Gbozu akwanœ kœpa fœ endje adœke: “E'e ndje, 'e na ga lœ kɨndɨ vinu nœ mœ.” ");
INSERT INTO mnh_vpl VALUES ("MT20_8","070_20_8","MAT","20","8","8","«Kœwuta ga tœ umbru osho, ayengɔ kɨndɨ vinunœ pa fœ kapeta adœke: “E ayi akwanœ para dœ́ œ ko ngendja tshangba akwa nœ endje fœ endje, kœto tœ endjeneke á mœ e endje tœ ndɔngɔlɔnœ asœmœ œrrr ga tœ endjeneke á mœ e má endje utshunœ.” ");
INSERT INTO mnh_vpl VALUES ("MT20_9","070_20_9","MAT","20","9","9","Azunœ ada ɔlɔ mindu nœ adɨla na œ gbɔ uzu dœ uzu denari bale. ");
INSERT INTO mnh_vpl VALUES ("MT20_10","070_20_10","MAT","20","10","10","Kœwuta ga tœ azu á endje na má utshunœ, endje gbe œnœ endje adœke œne dá gbɔ tɔpanœ kpuru; kashe endje gbɔ ndje uzu dœ uzu denari bale. ");
INSERT INTO mnh_vpl VALUES ("MT20_11","070_20_11","MAT","20","11","11","Lɔkɔ á endje gbɔ ngendjanœ, endje te lima tœ kœpulœma endje tœ ayengɔ kɨndɨnœ. ");
INSERT INTO mnh_vpl VALUES ("MT20_12","070_20_12","MAT","20","12","12","Endje pa lima adœke: “Aayi akwa á endje na manda nœ, endje mbœrœ akwa kolœ manda ada ɔlɔ bale, ɓœ to ngendja fœ endje awa bale dœ 'a á a wu oyo œrrr kpii tshakudu ɔlɔ dœ kœwosho!” ");
INSERT INTO mnh_vpl VALUES ("MT20_13","070_20_13","MAT","20","13","13","Kashe tshe gi fœ anga bale ugurutœ endje adœke: “Yanga mœ, mœ mbœmbœrœ ekperœ fœ ɓœ nene; a djidjimatœ azœ dœ mœ tœ denari bale lœ ɔlɔ bale nene a? ");
INSERT INTO mnh_vpl VALUES ("MT20_14","070_20_14","MAT","20","14","14","Za œneke á sœ tshakane zœ asœmœ, œ gu dœ tœnœ zœ. Mœ yindœ kœto ngendja fœ uzu á tshe na tœ ndɔngɔlɔnœ asœmœ awa bale dœ ɓœ. ");
INSERT INTO mnh_vpl VALUES ("MT20_15","070_20_15","MAT","20","15","15","Œ lili dœ mœ kœmbœrœ œneke á mœ yindœ nœ dœ œrœ nœ mœ nene a? Too ɓœ sœ dœ uku ga tœ mœ mbœrœ á mœ sœ dœ ɔtshɔ lɔsu a?” ");
INSERT INTO mnh_vpl VALUES ("MT20_16","070_20_16","MAT","20","16","16","Atamœ, azu á endje sœ tœ ndɔngɔlɔnœ œ wuta bala azu utshunœ; yé endjeneke á endje sœ utshunœ, œ wuta tœ ndɔngɔlɔnœ.» ");
INSERT INTO mnh_vpl VALUES ("MT20_17","070_20_17","MAT","20","17","17","Yisu dœ ayambarœ nœ ye ndjokpa dœ bisha (12) sœ lima kœro ga lœ Yerusaleme, yé á tshe sœ kœpa fœ endje na tœnœ tœ awa adœke: ");
INSERT INTO mnh_vpl VALUES ("MT20_18","070_20_18","MAT","20","18","18","«'E wu, a sœ kœɔ ga lœ Yerusaleme, ɓa tœ osho á endje ka Gbolo nœ uzu fœ agbozu tshapa anganga Ndjaba œdœ fœ aayi kœyisœ awa akwa. Endje wa agbɔ ngbanga ga pa ye adœke endje wo she. ");
INSERT INTO mnh_vpl VALUES ("MT20_19","070_20_19","MAT","20","19","19","Yé œ za she fœ angbɨ azu mbœrœ á endje kœmɔ she, á kœsɔ she, á kœkuru she ga pa kurushi, yé manda olo votɔ Ndjaba œ she she lœ akuzu.» ");
INSERT INTO mnh_vpl VALUES ("MT20_20","070_20_20","MAT","20","20","20","Awo Zebedayi na ga ndœ Yisu dœ agbolo yakoshe nœ ye bisha, œ gote ga utshu ye mbœrœ kœyɔndœ œrœ bale. ");
INSERT INTO mnh_vpl VALUES ("MT20_21","070_20_21","MAT","20","21","21","Yisu yu she adœke: «Ɓœ yindœ gaɗe?» Tshe pa fœ Yisu adœke: «Mœ kɨ ga tœ zœ, ɓœ kœgu bala ga lœ ogo tshagbozu nœ zœ, lœ agbolo yakoshe nœ mœ bisha asœke, za anga bale ga tœ kuni zœ, yé anga bale ga tœ gele zœ.» ");
INSERT INTO mnh_vpl VALUES ("MT20_22","070_20_22","MAT","20","22","22","Yisu gi adœke: «'E wuwusœ œrœnœ á 'e esho ndœnœ asœmœ nene. Adja 'e li kœndjo ungu lœ yashi nœ œrœ kanga á mœ ndjo bala ye a?» Endje pa fœ Yisu adœke: «'A li dœ tœnœ ye.» ");
INSERT INTO mnh_vpl VALUES ("MT20_23","070_20_23","MAT","20","23","23","Yisu kœpa fœ endje adœke: «Adjapu, 'e ndjo ungu lœ yashi œrœ kanganœ á mœ ndjo ye. Kashe tœ kœza awa fœ uzu kœsœ ga atɨ ga pa kuni mœ too ga pa gele mœ, asœmœ lili dœ mœ nene. Mbœrœ tœnœ kœdœ osho á sœ fœ endjeneke á Aba mœ guma endje.» ");
INSERT INTO mnh_vpl VALUES ("MT20_24","070_20_24","MAT","20","24","24","Udu ayambarœnœ ndjokpa dji o'onœ ataa œ tetœ kœso ókó ga tœ aayazu bisha, Ajake dœ Yowane. ");
INSERT INTO mnh_vpl VALUES ("MT20_25","070_20_25","MAT","20","25","25","Kashe Yisu e endje œ pa fœ endje adœke: «'E wusœ nœ adœke agbozu sœ kœko azu ogo dœ ɔgbɔ ga tshakudu tshagbozu nœ endje, yé agboro azu sœ kœma gbɔgbɔ endje ga pa aaya azu. ");
INSERT INTO mnh_vpl VALUES ("MT20_26","070_20_26","MAT","20","26","26","Œ lili adœke œrœ ataa mbœrœtœ endje ɓa ugurutœ 'e nene. Kashe œdœ anga uzu bale kœgbe kœsœ tœ egerœ uzu ugurutœ 'e, œ li adœke tshe fatœ ye tœ ayi akwa nœ 'e yekane. ");
INSERT INTO mnh_vpl VALUES ("MT20_27","070_20_27","MAT","20","27","27","Yé œdœ anga uzu bale kœyindœ kœsœ utshunœ ugurutœ 'e, œ li adœke tshe dœ kanga nœ 'e. ");
INSERT INTO mnh_vpl VALUES ("MT20_28","070_20_28","MAT","20","28","28","Mbœrœ tœnœ ataa, Gbolo nœ uzu nana adœke azu mbœrœ akwa fœ she nene, kashe tshe na kœmbœrœ akwa fœ azu dœ pe ndje kœzatœ ye fœ kuzu mbœrœ kœshe ukpu azu.» ");
INSERT INTO mnh_vpl VALUES ("MT20_29","070_20_29","MAT","20","29","29","Lɔkɔ á endje sœ lima kœwuta lœ Yeriko, ukpulu azu te manda Yisu. ");
INSERT INTO mnh_vpl VALUES ("MT20_30","070_20_30","MAT","20","30","30","Anga aayibula bisha sœ lima ga atɨ ɨndɨrɨ awa. Kœdji adœke Yisu dá ro asœmœ, endje tetœ kœta rawa adœke: «Gbozu, ata Davidi, wu oyo 'a kane!» ");
INSERT INTO mnh_vpl VALUES ("MT20_31","070_20_31","MAT","20","31","31","Ukpulu azu sœ lima kœgbagbara endje adœke endje sœ koko, kashe endje kpa ta tshandœ rawanœ dœ agbɔ adœke: «Gbozu, ata Davidi, wu oyo 'a kane!» ");
INSERT INTO mnh_vpl VALUES ("MT20_32","070_20_32","MAT","20","32","32","Yisu ka, œ e endje, yé œ pa fœ endje adœke: «Œrœ gaɗe dá 'e yindœ nœ adœke mœ mbœrœ fœ 'e a?» ");
INSERT INTO mnh_vpl VALUES ("MT20_33","070_20_33","MAT","20","33","33","Endje kœpa fœ she adœke: «Gbozu, kolœnœ adœke ala 'a kɔrɔ.» ");
INSERT INTO mnh_vpl VALUES ("MT20_34","070_20_34","MAT","20","34","34","Yisu wu oyo endje, yé œ goro ala endje. Trale ala endje kɔrɔ ye, yé endje te manda ye. ");
INSERT INTO mnh_vpl VALUES ("MT21_1","070_21_1","MAT","21","1","1","Lɔkɔ á endje ndo dœ ongbo Yerusaleme œdœ dœ tshalakpɨ Betefaje, ɓa pa gaga á ɨ'ɨrɨnœ kœdœ kaga ɔyɔ Olive, Yisu vwa anga ayambarœ nœ ye bisha utshunœ ");
INSERT INTO mnh_vpl VALUES ("MT21_2","070_21_2","MAT","21","2","2","dœ kœpa fœ endje adœke: «'E na ɓa lakpɨ á sœ utshu 'e ɓa e. Kœli 'e tshendja, 'e wu aya ane á endje du she kpœtœmœ dœ ayinœ, 'e vwara she œ gu dœ she fœ mœ. ");
INSERT INTO mnh_vpl VALUES ("MT21_3","070_21_3","MAT","21","3","3","Yé œdœ uzu kœpa o'o fœ 'e; 'e gi fœ she adœke: “Gbozu dá gbe dœ she.” Yé ataa, tshe gi kane ye tœ ye katsha fœ 'e ye.» ");
INSERT INTO mnh_vpl VALUES ("MT21_4","070_21_4","MAT","21","4","4","Œ wuta ataa mbœrœ á o'o á ayi kœgbara o'o pa lima kœmbœrœtœ endje. Tshe pa lima adœke: ");
INSERT INTO mnh_vpl VALUES ("MT21_5","070_21_5","MAT","21","5","5","«'E pandœ nœ fœ yawuru nœ Siyona adœke: Wu, gbozugo nœ zœ sœ kœna ga ndœ zœ. Tshe sœ kœna ɓata amba uzu. Tshe ɔ ga pa ayi ane, œdœ ga pa ayanœ á tshe dœ aya agea nœ akwa.» ");
INSERT INTO mnh_vpl VALUES ("MT21_6","070_21_6","MAT","21","6","6","Ayambarœ ro œ mbœrœ œneke á Yisu pa tœnœ fœ endje. ");
INSERT INTO mnh_vpl VALUES ("MT21_7","070_21_7","MAT","21","7","7","Endje gu dœ ayi ane œdœ ayanœ, yé endje ko lœba nœ endje œ guma ga pa endje, á Yisu ɔ á sœ ga pa nœ. ");
INSERT INTO mnh_vpl VALUES ("MT21_8","070_21_8","MAT","21","8","8","Ukpulu azu ndjoro saka lœba nœ endje ga tœ ala awa; anga endje de lima ganea ɔyɔ, yé œ guma ga tœ awa. ");
INSERT INTO mnh_vpl VALUES ("MT21_9","070_21_9","MAT","21","9","9","Azu á endje sœ lima kœna ɓa utshu ye dœ pe endjeneke á endje sœ lima kœna manda ye, sœ lima kœta rawa adœke: «Ozana nœ ata Davidi! Kaka Ndjaba to kane ye ga pa uzu á tshe na dœ ɨ'ɨrɨ Gbozu! Ozana fœ Ndjaba á tshe sœ ɓa lafo!» ");
INSERT INTO mnh_vpl VALUES ("MT21_10","070_21_10","MAT","21","10","10","Ɔlɔ á Yisu li ga lœ Yerusaleme, tshelœ ongbo djigi turu, azu tetœ kœyu osho adœke: «Uzu ɗe dá a?» ");
INSERT INTO mnh_vpl VALUES ("MT21_11","070_21_11","MAT","21","11","11","Azu á endje na lima dœ Yisu gi adœke: «Ayi kœgbara o'o Yisu dœmœ, uzu Nazarete, lœ ogo Galilayi.» ");
INSERT INTO mnh_vpl VALUES ("MT21_12","070_21_12","MAT","21","12","12","Manda nœ, Yisu li ga lœ Tepelo, yé œ gɔrɔ azu á endje sœ lima kœka œrœ dœ pe endjeneke á endje sœ lima kœyɔ œrœ kɔ ga ushu. Tshe ɨvwɨ ndaba nœ azu kœyapa ngendja, œ geta ngande nœ aayi kœka ambepa. ");
INSERT INTO mnh_vpl VALUES ("MT21_13","070_21_13","MAT","21","13","13","Yé tshe pa fœ endje adœke: «Endje sú ɓa la buku nœ Ndjaba adœke: “Anda nœ mœ œ dœ bala anda nœ kœza avwala, kashe 'e fa tœ wutu nœ aayi angba!”» ");
INSERT INTO mnh_vpl VALUES ("MT21_14","070_21_14","MAT","21","14","14","Aayibula dœ pe agbangevweta na ga ndœ Yisu ɓa lœ Tepelo yeka á tshe she endje. ");
INSERT INTO mnh_vpl VALUES ("MT21_15","070_21_15","MAT","21","15","15","Agbozu tshapa anganga Ndjaba œdœ pe aayi kœyisœ awa akwa so ókó ndœ kœwu mara œrœ kœza uvuru osho á tshe sœ lima kœmbœrœ tœnœ dœ pe agbolo á endje sœ lima kœta rawa ɓa lœ Tepelo adœke: «Ozana nœ ata Davidi!» ");
INSERT INTO mnh_vpl VALUES ("MT21_16","070_21_16","MAT","21","16","16","Yé endje pa fœ Yisu adœke: «Ɓœ sœ kœdji œneke á endje pa asœ zœ a?» Kashe Yisu pa fœ endje adœke: «Mœ dji ye, ataa 'e dɨdɨ lima mbetinœ asœmœ nene a? Mbetinœ á pa adœke: “Ɓœ mbœrœ dœ mara adœke œdœ agbolo dœ pe aayi mangɔ donga ɓœ.”» ");
INSERT INTO mnh_vpl VALUES ("MT21_17","070_21_17","MAT","21","17","17","Manda nœ, tshe katœ endje lœ ongbonœ asœmœ, œ gu kœlo ɓa lœ Betani. ");
INSERT INTO mnh_vpl VALUES ("MT21_18","070_21_18","MAT","21","18","18","Osho kɔrɔ panœ dœ amazɨ, lɔkɔ á tshe sœ kœkwatœ ye ga lœ ongbonœ, ogo mi she. ");
INSERT INTO mnh_vpl VALUES ("MT21_19","070_21_19","MAT","21","19","19","Tshe wu anga ɔyɔ fige ndoo dœ ama awa, œ na ndoo dœ tœnœ, kashe tshe gbɔgbɔ elenœ bale nene, kolœ kakonœ. Yé tshe pa fœ ɔyɔ figenœ adœke: «Ɓœ kpa le bale nene!» Trale, ɔyɔ figenœ asœmœ ɔrɔ ye. ");
INSERT INTO mnh_vpl VALUES ("MT21_20","070_21_20","MAT","21","20","20","Kœwu œrœnœ ataa, ayambarœ katœ ama endje tɨ ɔsɔ, yé œ yu Yisu adœke: «Kotoo trale á ɔyɔ fige asœke ɔrɔ ata a?» ");
INSERT INTO mnh_vpl VALUES ("MT21_21","070_21_21","MAT","21","21","21","Yisu gi fœ endje adœke: «Mœ sœ kœmɨndœ nœ fœ 'e dœ adjapu, œdœ anga ɔlɔ bale á 'e kœsœ dœ kœyindœrœ yé á sœsœ dœ sharapu nene, 'e mbœrœ kolœ œrœ á mœ mbœrœ tœ ɔyɔ fige asœ nene, kashe œdœ 'e kœpa fœ kaga asœ adœke: “Gitœ zœ kpœke dœ́ œ na œ te ga la egerœ ungu adanga”, œ mbœrœ ndje tœ endje liaka nœ. ");
INSERT INTO mnh_vpl VALUES ("MT21_22","070_21_22","MAT","21","22","22","Œrœ kɔ á 'e yɔndœ nœ lœ avwala dœ kœyindœrœ, 'e gbɔ ye.» ");
INSERT INTO mnh_vpl VALUES ("MT21_23","070_21_23","MAT","21","23","23","Ɔlɔ á tshe li ga lœ Tepelo, agbozu tshapa anganga Ndjaba dœ pe agbozu Ikrizia na ga ndœ ye ɔlɔ á tshe sœ kœyisœ œrœ, á yu she adœke: «Ɓœ gbɔ awa kœmbœrœ akwa nœ zœ asœke kpœta a? Œɗe dá za awa kœmbœrœ akwa ata fœ ɓœ a?» ");
INSERT INTO mnh_vpl VALUES ("MT21_24","070_21_24","MAT","21","24","24","Yisu gi fœ endje adœke: «Mœ yindœ kœyu 'e dœ o'o bale, œ kœsœ adœke 'e gi o'o fœ mœ gbá yekane á mœ kœyisœ osho á mœ gbɔ awa kœmbœrœ dœ œrœnœ asœ kɔ fœ 'e. ");
INSERT INTO mnh_vpl VALUES ("MT21_25","070_21_25","MAT","21","25","25","Œɗe dá vwa lima Yowane kœza batisimu fœ azu a? Œ dœ lima Ndjaba too azu?» Yé endje tetœ kœmirœtshelœ endje ugurutœ endje yé œ pa adœke: «Œdœ a kœgi fœ she adœke: “Ndjaba dá vwa lima she”, tshe yu azœ adœke: “Mbœrœ gaɗe á 'e yiyi lima ndœ o'o ama ye nene a?” ");
INSERT INTO mnh_vpl VALUES ("MT21_26","070_21_26","MAT","21","26","26","Yé a kpa pa adœke: “Azu dá vwa lima she”, œ li adœke a kpa awa ukpulu azu, mbœrœ azu para wusœ nœ adœke Yowane kœdœ lima ayi kœgbara o'o.» ");
INSERT INTO mnh_vpl VALUES ("MT21_27","070_21_27","MAT","21","27","27","Yé á endje gi fœ Yisu adœke: «'A wuwusœ nœ nene.» A Yisu gi fœ endje adœke: «Œmœ ndje awa bale, mœ pa ndje ndœ uzu á tshe za awa nœ kœmbœrœ œrœnœ asœke kɔ fœ 'e nene.» ");
INSERT INTO mnh_vpl VALUES ("MT21_28","070_21_28","MAT","21","28","28","«'E gbe œneke adœ gaɗe tœ o'o asœ a? Anga yakoshe sœ dœ agbolo yakoshe bisha. Tshe na ga ndœ ali gbolonœ, œ pa fœ she adœke: “Na kpesheke ga lœ kɨndɨ vinu œ mbœrœ akwa ɓa zœ.” ");
INSERT INTO mnh_vpl VALUES ("MT21_29","070_21_29","MAT","21","29","29","Alinœ gi fœ she adœke: “Œ ngba mœ ye;” manda nœ tshe gbetshelœ ye œ na da ye. ");
INSERT INTO mnh_vpl VALUES ("MT21_30","070_21_30","MAT","21","30","30","Tshe kpa na ga ndœ bishanœ, œ pa kolœ nœ ata fœ she. Tsheneke asœ gi fœ she adœke: “Mœ na zœ Gbozu”, kashe tshe nana ga zœ nene. ");
INSERT INTO mnh_vpl VALUES ("MT21_31","070_21_31","MAT","21","31","31","Uzu ɗe ugurutœ endje bisha dá mbœrœ gbetshelœ nœ abanœ a?» Endje gi adœke: «Ali gbolonœ.» Á Yisu pa fœ endje adœke: «Dœ adjapu, mœ sœ kœmɨndœ nœ fœ 'e, ayi kœko ngendja lapo dœ pe ayi angba budu œ wuta utshu 'e ga lœ Ogo gbozu nœ Ndjaba. ");
INSERT INTO mnh_vpl VALUES ("MT21_32","070_21_32","MAT","21","32","32","Gbambanœ nene, Yowane na lima ndœ kœyisœ awa á sœ ndjii fœ 'e, 'e yiyindœ nœ nene. Kashe aayi kœko ngendja lapo dœ pe aayi angba budu dá yindœ ye. Yé ataa 'e wu gbaa, 'e fafatshalɔsu 'e ndœ kpa kœyindœ ye nene.» ");
INSERT INTO mnh_vpl VALUES ("MT21_33","070_21_33","MAT","21","33","33","«'E kpa dji anga ndœma toro. Anga uzu bale djo kɨndɨ vinu. Tshe tɔ gbadjadja dji tœnœ tshakpata, œ dji kudu mbœrœ kœpu ele vinunœ ga lœnœ, yé œ mɔ anda kœgbɔndœ œrœ ga lœ nœ. Manda nœ, tshe za kɨndɨ nœ fœ aayi akwa kɨndɨ vinu, yé œ na ana. ");
INSERT INTO mnh_vpl VALUES ("MT21_34","070_21_34","MAT","21","34","34","Ɔlɔ kœkɔ ele vinunœ li, tshe vwa anga aayi akwa nœ ye fœ aayi akwa kɨndɨ vinunœ adœke endje vwa œsœ œnœ œne ele vinu nœ fœ œne. ");
INSERT INTO mnh_vpl VALUES ("MT21_35","070_21_35","MAT","21","35","35","Kashe endje ko aayi akwa nœ ye asœmœ, œ ɓi anga bale, œ wo anga yé œ wo votɔnœ dœ badja. ");
INSERT INTO mnh_vpl VALUES ("MT21_36","070_21_36","MAT","21","36","36","Tshe kpa vwa anga aayi akwa ndjoro, kœropa endjeneke má utshunœ, endje mbœrœ kolœ nœ fœ endje awa bale. ");
INSERT INTO mnh_vpl VALUES ("MT21_37","070_21_37","MAT","21","37","37","Tœ ndɔngɔlɔ nœ, tshe vwa gbolo yakoshe nœ ye fœ endje dœ gbetshelœ adœke: “Endje kpa lɨ ndara œsœ ye yé.” ");
INSERT INTO mnh_vpl VALUES ("MT21_38","070_21_38","MAT","21","38","38","Kashe lɔkɔ á endje wu gbolonœ kœna ga ndœ endje, endje guma o'o lœ ugurutœ endje adœke: “'E wu, gbolonœ á tshe sœpe dœ œrœ manda abanœ dœke. A wo she yeka á kɨndɨnœ kœte œnœ azœ.” ");
INSERT INTO mnh_vpl VALUES ("MT21_39","070_21_39","MAT","21","39","39","Endje za she œ vwi she ga ushu lœ kɨndɨ vinunœ yeka á wo she.» ");
INSERT INTO mnh_vpl VALUES ("MT21_40","070_21_40","MAT","21","40","40","«Ataa, lɔkɔ á ayengɔ kɨndɨnœ kœna, tshe mbœrœ œrœ gaɗe tœ aayi akwa kɨndɨ vinunœ a?» ");
INSERT INTO mnh_vpl VALUES ("MT21_41","070_21_41","MAT","21","41","41","Endje gi fœ she adœke: «Tshe na œ wo aayi akwa kɨndɨnœ kɔ dœ oyo nene yé œ kpa za kɨndɨnœ fœ anga angbɨ aayi akwa á endje li kœko ele vinunœ fœ she liaka olo á tshe gbe dœ tœnœ.» ");
INSERT INTO mnh_vpl VALUES ("MT21_42","070_21_42","MAT","21","42","42","Yisu kœpa fœ endje adœke: «'E dɨdɨ damba o'onœ asœke ala buku nœ Ndjaba nene a? Endje su adœke: “Badja á ayi kœmɔ anda za vwi'i, tœnœ dá wuta sharagunda. Œ to ɓa ndœ Gbozu, yé œ ga tœ ala 'a waa!”» ");
INSERT INTO mnh_vpl VALUES ("MT21_43","070_21_43","MAT","21","43","43","«Mœ kpa pa ndje fœ 'e adœke: Endje gi 'e lœ Ogo gbozu nœ Ndjaba, yé œ za fœ angbɨ azu á endje li kœmbœrœ akwa á œrœ tshangbanœ sœ dœ ɔtshɔnœ.  ");
INSERT INTO mnh_vpl VALUES ("MT21_44","070_21_44","MAT","21","44","44","Uzu á tshe te pa badja asœmœ, tshe kɔ ngende ngende. Yé tsheneke á badja œ te ga pa ye, œ ndɨ tshelœ ye krœna.» ");
INSERT INTO mnh_vpl VALUES ("MT21_45","070_21_45","MAT","21","45","45","Manda kœdji o'o asœmœ, agbozu tshapa anganga Ndjaba dœ pe Afarisayi wusœ nœ adœke Yisu sœ kœpa o'o asœ tœ œne. ");
INSERT INTO mnh_vpl VALUES ("MT21_46","070_21_46","MAT","21","46","46","Endje para lima awa ndœ kœtepa ye, kashe endje kpa awa ukpulu azu, mbœrœ endje sœ lima kœza she ɓata ayi kœgbara o'o. ");
INSERT INTO mnh_vpl VALUES ("MT22_1","070_22_1","MAT","22","1","1","Yisu tetœ kœpa 'o fœ endje dœ ndœma toro adœke: ");
INSERT INTO mnh_vpl VALUES ("MT22_2","070_22_2","MAT","22","2","2","«Ogo gbozu nœ tshalafo sœ ɓata anga gbozugo á tshe guma kœzɨrœ angbo totœ nœ gbolo yakoshe nœ ye. ");
INSERT INTO mnh_vpl VALUES ("MT22_3","070_22_3","MAT","22","3","3","Tshe vwa aayi akwa nœ ye fœ azu á tshe e má endje ndœ angbonœ, kashe endje yiyindœ kœna tœnœ nene. ");
INSERT INTO mnh_vpl VALUES ("MT22_4","070_22_4","MAT","22","4","4","Tshe kpa vwa anga angbɨ aayi akwa ndœ kœmɨndœ nœ fœ azu á tshe e endje adœke: “'E na ga mœ ngɔngɔ asœ, mœ guma kœzɨrœnœ ye; mœ wo angombe nœ mœ dœ pe agea ojoro. 'E na ga mœ ndœ angbo totœnœ, œrœ kɔ gumatœ endje ye.” ");
INSERT INTO mnh_vpl VALUES ("MT22_5","070_22_5","MAT","22","5","5","Kashe azunœ gbegbe dœ angbonœ nene, yé œ na ndœ akwa nœ endje: Anga na ga lœ kɨndɨ, anga na kœpara ngendja nœ ye; ");
INSERT INTO mnh_vpl VALUES ("MT22_6","070_22_6","MAT","22","6","6","anga endje tepa aayi akwanœ, á mbœrœ œrœ kanga fœ endje yé á wo endje. ");
INSERT INTO mnh_vpl VALUES ("MT22_7","070_22_7","MAT","22","7","7","Gbozugo su dœ ókó, œ vwa aturugu nœ ye endje wo azu á endje wo aayi akwa nœ ye, yé œ sho ongbo nœ endje. ");
INSERT INTO mnh_vpl VALUES ("MT22_8","070_22_8","MAT","22","8","8","Manda nœ, tshe pa fœ aayi akwa nœ ye adœke: “Mœ guma kœzɨrœ angbo ye, kashe azu á mœ e endje, œ dœ́dœ́ azu á li má adœke mœ e endje dœmœ nene. ");
INSERT INTO mnh_vpl VALUES ("MT22_9","070_22_9","MAT","22","9","9","'E ro ɓa lœ shangbeda awa, dœ́ œ e azu kɔ á 'e gbɔ endje gu tœnœ ndœ kœzɨrœ.” ");
INSERT INTO mnh_vpl VALUES ("MT22_10","070_22_10","MAT","22","10","10","Aayi akwanœ asœmœ wuta ga lœ shangbeda awa, œ ngbɔɓa azu kɔ á endje gbɔ endje gu tœnœ: Œdœ aekpe azu, œdœ ɔtshɔ azu. Yé dœ tœnœ ataa, anda angbonœ su kperœ dœ azu. ");
INSERT INTO mnh_vpl VALUES ("MT22_11","070_22_11","MAT","22","11","11","«Lɔkɔ á gbozugo li ndœ kœwu azu á endje sœ pa ndaba nœ kœzɨrœ, tshe wu anga uzu bale, tshe veverœ lœba angbonœ nene. ");
INSERT INTO mnh_vpl VALUES ("MT22_12","070_22_12","MAT","22","12","12","Tshe yu she adœke: “Yanga mœ, ɓœ sœsœ dœ lœba angbo nene, ɓœ li ga mœ koto o?” Tshe gigi o'o nene. ");
INSERT INTO mnh_vpl VALUES ("MT22_13","070_22_13","MAT","22","13","13","Yé á gbozugo kœpandœ nœ fœ aayi akwa nœ ye adœke: “'E i ada ye dœ kane ye ga tœnœ, œ vwi she ga ushu ɓa lœ ubu osho, osho á azu sœ kœkɨ tœnœ dœ kœzɨ tshelœ daji endje gbagbara gbagbara.” ");
INSERT INTO mnh_vpl VALUES ("MT22_14","070_22_14","MAT","22","14","14","Adjapu, endje e azu ndjoro, kashe endjeneke á endje ke endje ngbangba nene.» ");
INSERT INTO mnh_vpl VALUES ("MT22_15","070_22_15","MAT","22","15","15","Yé Afarisayi ngbɔtœ endje ga tœnœ ndœ kœvwarandœ Yisu adœke œne gbɔ she tœ o'o ama ye. ");
INSERT INTO mnh_vpl VALUES ("MT22_16","070_22_16","MAT","22","16","16","Endje vwa anga ayambarœ nœ endje dœ pe azu nœ Erode mbœrœ kœpa fœ Yisu adœke: «Ayi kœyisœrœ, 'a wusœ nœ adœke ɓœ sœ kœpa okporo o'o, ɓœ sœ kœyisœ adja awa Ndjaba, ɓœ sœ ndje kœkatœ zœ tɨ fœ uzu adœke tshe li ga lœ zœ dœ ekpe o'o nene. Ɓœ kpakpa awa uzu nene, œ wuwu ndje tshatshu uzu nene. ");
INSERT INTO mnh_vpl VALUES ("MT22_17","070_22_17","MAT","22","17","17","Ataa, pandœ gbetshelœ nœ zœ fœ a'a kane: œ li adœke azu yɔ lapo nœ Sezare a, too nene?» ");
INSERT INTO mnh_vpl VALUES ("MT22_18","070_22_18","MAT","22","18","18","Kashe Yisu wu lima sœ ekpe gbetshelœ nœ endje ye, yé œ pa fœ endje adœke: «Awulapatshɔ, mbœrœ gaɗe á 'e sœ kœyu tshelœma mœ a? ");
INSERT INTO mnh_vpl VALUES ("MT22_19","070_22_19","MAT","22","19","19","'E ma anga ngendja bale nœ kœyɔ dœ laponœ gamœ mœ wu kane.» Endje ma anga denarinœ bale fœ she. ");
INSERT INTO mnh_vpl VALUES ("MT22_20","070_22_20","MAT","22","20","20","Yisu yu endje adœke: «Tshatshu uzu asœke dœ pe ɨ'ɨrɨ á endje sú asœke kœdœ œnœ ɗe?» ");
INSERT INTO mnh_vpl VALUES ("MT22_21","070_22_21","MAT","22","21","21","Endje gi adœke: «Œnœ Sezare». Yé Yisu kœpa fœ endje adœke: «'E gi œrœ nœ Sezare fœ Sezare, œnœ Ndjaba fœ Ndjaba.» ");
INSERT INTO mnh_vpl VALUES ("MT22_22","070_22_22","MAT","22","22","22","Kœdji o'onœ asœmœ ataa, endje katœ ama endje tɨ ɔsɔ, œ katœ ye yé œ ro da ye. ");
INSERT INTO mnh_vpl VALUES ("MT22_23","070_22_23","MAT","22","23","23","Kolœ dœ ɔlɔnœ asœmœ, anga Asadukayi na ga ndœ Yisu. Endje dá sœ kœpa adœke kœshe lœ akuzu gugu nene. Á endje yu Yisu adœke: ");
INSERT INTO mnh_vpl VALUES ("MT22_24","070_22_24","MAT","22","24","24","«Ayi kœyisœrœ, Moyize pa adœke, œdœ uzu kœtshu á kœzuzu gbolo nene, ayanœ œ to koyanœ manda ye mbœrœ á tshe kœmbœrœ angwa fœ ayanœ á tshe tshu asœmœ. ");
INSERT INTO mnh_vpl VALUES ("MT22_25","070_22_25","MAT","22","25","25","Andaa ɓa ndœ 'a, 'a sœ dœ anga ayazu mindu dœ bisha (7). Alinœ to yashe, œ zuzu gbolo dœ she nene, œ tshu ye; ɓata á endje zuzu lima dœ yashenœ asœmœ nene, tshe katœ ye tɨ fœ ayanœ. ");
INSERT INTO mnh_vpl VALUES ("MT22_26","070_22_26","MAT","22","26","26","Œ mbœrœtœ endje awa bale ataa ga tœ bisha ayanœ, ga tœ votɔ ayanœ œrrr ga tœ tshenœ mindu dœ bisha. ");
INSERT INTO mnh_vpl VALUES ("MT22_27","070_22_27","MAT","22","27","27","Manda endje para, yashenœ kœtshu ye. ");
INSERT INTO mnh_vpl VALUES ("MT22_28","070_22_28","MAT","22","28","28","Atamœ, dœ olo kœshe lœ akuzu yashenœ asœmœ œdœ awo ɗe? Mbœrœ endje mindu dœ bisha (7) kɔ to lima she tœ awo endje yema a!» ");
INSERT INTO mnh_vpl VALUES ("MT22_29","070_22_29","MAT","22","29","29","Yisu gi fœ endje adœke: «'E sœ lœ djingili, mbœrœ 'e wuwusœ buku nœ Ndjaba dœ pe gbɔgbɔ nœ ye nene. ");
INSERT INTO mnh_vpl VALUES ("MT22_30","070_22_30","MAT","22","30","30","Ɔlɔ kœshe lœ akuzu, ayakoshe dœ ayashe œ totœ endje nene kashe endje lœ ɓata aandjelu ɓa lafo. ");
INSERT INTO mnh_vpl VALUES ("MT22_31","070_22_31","MAT","22","31","31","Œ kœdœ tœ o'o nœ kœshe lœ akuzu, 'e dɨdɨ o'o á Ndjaba pa fœ 'e ala buku nœ ye nene a? Tshe pa adœke: ");
INSERT INTO mnh_vpl VALUES ("MT22_32","070_22_32","MAT","22","32","32","“Œmœ kœdœ Ndjaba nœ Abrayamo, Ndjaba nœ Izaka œdœ Ndjaba nœ Yakobo.” Yisu kpa pa adœke, Ndjaba kœdœ Ndjaba nœ asoro kashe tshenœ akuzu nene.» ");
INSERT INTO mnh_vpl VALUES ("MT22_33","070_22_33","MAT","22","33","33","Kœdji o'onœ ataa, ukpulu azu za lima ama endje tɨ ɔsɔ tœ kœyisœrœ nœ ye. ");
INSERT INTO mnh_vpl VALUES ("MT22_34","070_22_34","MAT","22","34","34","Lɔkɔ á Afarisayi dji adœke Yisu ngbɔ ama Asadukayi ga tœnœ, endje ngbɔtœ endje ga tœnœ. ");
INSERT INTO mnh_vpl VALUES ("MT22_35","070_22_35","MAT","22","35","35","Yé anga ayi kœyisœ awa akwa yu she ndœ kœdji gbetshelœ nœ ye adœke: ");
INSERT INTO mnh_vpl VALUES ("MT22_36","070_22_36","MAT","22","36","36","«Ayi kœyisœrœ, awa o'o gaɗe dá ropa anganœ lœ awa akwa a?» ");
INSERT INTO mnh_vpl VALUES ("MT22_37","070_22_37","MAT","22","37","37","Yisu gi fœ she adœke: «Œ li adœke ɓœ yindœ Gbozu Ndjaba nœ zœ dœ lɔsu zœ bale, dœ ɨshirɨ zœ kɔ, dœ pe gbetshelœ nœ zœ kɔ. ");
INSERT INTO mnh_vpl VALUES ("MT22_38","070_22_38","MAT","22","38","38","Asœmœ kœdœ awa o'o á ropa anganœ yé œ sœ ndje dœ ádá waa. ");
INSERT INTO mnh_vpl VALUES ("MT22_39","070_22_39","MAT","22","39","39","Bisha awa o'onœ á sœ ndje dœ ádá waa awa bale dœke: “Ɓœ yindœ yanga zœ ɓata á ɓœ yindœtœ zœ dœ tœ zœ.” ");
INSERT INTO mnh_vpl VALUES ("MT22_40","070_22_40","MAT","22","40","40","Awa akwa kɔ œdœ pe aayi kœgbara o'o kɔ to lœ awa o'onœ bisha asœke.» ");
INSERT INTO mnh_vpl VALUES ("MT22_41","070_22_41","MAT","22","41","41","Afarisayi ngbɔɓa lima tœ endje ga tœnœ yé Yisu yu endje dœ o'o atake: ");
INSERT INTO mnh_vpl VALUES ("MT22_42","070_22_42","MAT","22","42","42","«'E gbe má œnœ 'e kotoo tœ upu nœ Masiya a? Œshe kœdœ ata ɗe?» Endje gi fœ she adœke: «Ata Davidi.» ");
INSERT INTO mnh_vpl VALUES ("MT22_43","070_22_43","MAT","22","43","43","Yisu pa fœ endje adœke: «Koto yeka á ɨshirɨ pa lima fœ Davidi adœke tshe e she “Gbozu” a? Gbambanœ nene, Davidi pa adœke: ");
INSERT INTO mnh_vpl VALUES ("MT22_44","070_22_44","MAT","22","44","44","“Gbozu pa fœ Gbozu nœ mœ adœke: na œ sœ ga pa kuni mœ, œrrr ga tœnœ adœke mœ ko ayingba zœ ga tshakudu ada zœ yekane.” ");
INSERT INTO mnh_vpl VALUES ("MT22_45","070_22_45","MAT","22","45","45","«Œdœ Davidi kœ'e she lima Gbozu ataa, koto á tshe pkpa dœ ata nœ a?» ");
INSERT INTO mnh_vpl VALUES ("MT22_46","070_22_46","MAT","22","46","46","Uzu bale lili lima kœgi o'o fœ she nene. Yé kœto kpœtœ olonœ asœmœ, uzu bale kpa yuyu she dœ o'o nene. ");
INSERT INTO mnh_vpl VALUES ("MT23_1","070_23_1","MAT","23","1","1","Yé Yisu sœ lima kœpa 'o fœ ukpulu azu dœ pe fœ ayambarœ nœ ye adœke: ");
INSERT INTO mnh_vpl VALUES ("MT23_2","070_23_2","MAT","23","2","2","«Aayi kœyisœ awa akwa œdœ Afarisayi kœdœ azu á endje sœ mbœrœ kœpandœ awa akwa nœ Moyize. ");
INSERT INTO mnh_vpl VALUES ("MT23_3","070_23_3","MAT","23","3","3","Ataa, 'e mbœrœtœ 'e lindœ o'o endje yé œ mbœrœ œneke kɔ á endje pa fœ 'e; Kashe 'e zaza angwa kœmbœrœ œrœ nœ endje nene, mbœrœ endje sœsœ kœza œneke á endje sœ kœyisœ nœ ga tœ akwa nene. ");
INSERT INTO mnh_vpl VALUES ("MT23_4","070_23_4","MAT","23","4","4","Endje sœ kœi kɨkɨlɨ kongba yé œ sœ kœko ga pa kanga azu; kashe endje dœ tœ endje, endje gogoro bale dœ yɔkɔne endje nene. ");
INSERT INTO mnh_vpl VALUES ("MT23_5","070_23_5","MAT","23","5","5","Œrœ kɔ á endje sœ kœmbœrœ tœnœ, endje sœ kœmbœrœ dœ mara adœke azu wusœ œne. Ataa, œnœ endje ndœma lœba á endje sú o'o ama Ndjaba ga tœnœ yé á i ga pa ala endje too ga tœ kane endje sœ tœ egerœnœ. Œnœ endje apara yɔgbɔdɔ lœba sœ kpi tœ œnœ anga endje. ");
INSERT INTO mnh_vpl VALUES ("MT23_6","070_23_6","MAT","23","6","6","Endje yindœ kœsœ ɓa utshunœ ɓa tœ osho á œsœnœ lɨ œdœ kœsœ lœ ngande á sœ ɓa utshunœ lœ Sinagoga. ");
INSERT INTO mnh_vpl VALUES ("MT23_7","070_23_7","MAT","23","7","7","Endje yindœ nœ adœke azu bala œne tœ osho angbɔtœ yé œ e œne “Rabi” yekane. ");
INSERT INTO mnh_vpl VALUES ("MT23_8","070_23_8","MAT","23","8","8","«Kashe e'e, 'e eetœ 'e “Rabi” nene, mbœrœ e'e kɔ kœdœ ayazu, yé 'e sœ dœ Rabi kolœ tshebale. ");
INSERT INTO mnh_vpl VALUES ("MT23_9","070_23_9","MAT","23","9","9","'E ee uzu bale pa ɔshɔ asœ “Aba” nene, mbœrœ 'e sœ dœ Aba 'e kolœ tshebale á tshe sœ ɓa lafo. ");
INSERT INTO mnh_vpl VALUES ("MT23_10","070_23_10","MAT","23","10","10","'E yiyindœ nœ adœke endje e 'e “Agbangba kœyisœrœ” nene, mbœrœ 'e sœ kolœ dœ gbangba kœyisœrœ bale á tshe kœdœ Kristu. ");
INSERT INTO mnh_vpl VALUES ("MT23_11","070_23_11","MAT","23","11","11","Œ li adœke uzu á tshe dœ egerœ uzu ugurutœ 'e dœ ayi akwa nœ 'e. ");
INSERT INTO mnh_vpl VALUES ("MT23_12","070_23_12","MAT","23","12","12","Uzu á tshe tɨtœ ye ga lafo, endje ku she ga atɨ, yé tsheneke á tshe zatœ ye ga atɨ, endje tɨ she ga lafo.» ");
INSERT INTO mnh_vpl VALUES ("MT23_13","070_23_13","MAT","23","13","13","«Oyo nœ 'e dœ ayi kœyisœ awa akwa œdœ awulapatshɔ Afarisayi! 'E sœ kœtshu manda Ogo gbozu nœ tshalafo utshu azu. E'e dœ tœ 'e, 'e sœsœ kœli ga zœ nene, yé 'e sœ kœkɔ endjeneke á endje gbe ndœ kœli tœnœ, kœli ga zœ.»  ");
INSERT INTO mnh_vpl VALUES ("MT23_14","070_23_14","MAT","23","14","14","«Oyo nœ 'e dœ aayi kœyisœ awa akwa œdœ awulapatshɔ Afarisayi; 'e sœ kœpara awa kɔ kœko œrœ á ayashe koya sœ dœ tœnœ kɔ tœ endje, 'e sœ ndje kœza avwala dœ o'o ndjoro mbœrœ kœmatœ 'e. Mbœrœ tœnœ ataa, Ndjaba œ wa bala ɔgbɔ ngbanga ga tœ 'e.» ");
INSERT INTO mnh_vpl VALUES ("MT23_15","070_23_15","MAT","23","15","15","«Oyo nœ 'e dœ aayi kœyisœ awa akwa œdœ awulapatshɔ Afarisayi, 'e sœ kœkɔrɔ na tœnœ djezœ mbœrœ kœpara anga uzu bale adœke tshe fatshalɔsu ye, yé lɔndɔ á 'e mbœrœ á tshe fatshalɔsu ye, 'e kpa sœ kœyi she ga lœ kudu owo nœ lifelo awa bisha kœropa 'e.» ");
INSERT INTO mnh_vpl VALUES ("MT23_16","070_23_16","MAT","23","16","16","«Oyo nœ 'e, agbozu aayibula! 'E sœ kœpa adœke: “Œdœ uzu kœdarama ye dœ ɨ'ɨrɨ anda Ndjaba, œ sœsœ dœ o'o nene; kashe œdœ uzu kœdarama ye dœ ɨ'ɨrɨ ɔrœ á sœ ɓa lœ anda Ndjaba, dá tshe mbœrœ dœ ɔtshɔnœ.” ");
INSERT INTO mnh_vpl VALUES ("MT23_17","070_23_17","MAT","23","17","17","Aayi ɨndɨ, aayibula, œrœ gaɗe dá sœ dœ ádá kœropa nœ a: Ɔrœ too Tepelo á mbœrœ adœke ɔrœnœ wuta yerœ a? ");
INSERT INTO mnh_vpl VALUES ("MT23_18","070_23_18","MAT","23","18","18","'E kpa sœ kœpa adœke: “Œdœ uzu kœdarama ye dœ ɨ'ɨrɨ ndaba á endje to œrœ ga panœ fœ Ndjaba, œ sœsœ dœ o'o nene; kashe œdœ uzu kœdarama ye tœ tokóró á endje ko ga panœ, dá tshe mbœrœ dœ ɔtshɔnœ.” ");
INSERT INTO mnh_vpl VALUES ("MT23_19","070_23_19","MAT","23","19","19","Aayibula! Œrœ gaɗe dá sœ dœ ádá kœropa nœ a: Tokóró too ndaba á mbœrœ adœke tokórónœ wuta yerœ a? ");
INSERT INTO mnh_vpl VALUES ("MT23_20","070_23_20","MAT","23","20","20","Ataa, uzu á tshe dara ama ye dœ ɨ'ɨrɨ ndaba, dá tshe dara ama ye pa ndabanœ œdœ ndje pe pa œrœ kɔ á sœ panœ. ");
INSERT INTO mnh_vpl VALUES ("MT23_21","070_23_21","MAT","23","21","21","Uzu á tshe dara ama ye dœ ɨ'ɨrɨ Tepelo, dá tshe dara ndje ama ye dœ ɨ'ɨrɨ Ndjaba á tshe sœ ɓa zœ. ");
INSERT INTO mnh_vpl VALUES ("MT23_22","070_23_22","MAT","23","22","22","Uzu á tshe dara ama ye dœ ɨ'ɨrɨ tshalafo, dá tshe dara ama ye dœ ɨ'ɨrɨ ngande tshagbozu œdœ ndje dœ ɨ'ɨrɨ Ndjaba á tshe sœ panœ.» ");
INSERT INTO mnh_vpl VALUES ("MT23_23","070_23_23","MAT","23","23","23","«Oyo nœ 'e, aayi kœyisœ awa akwa œdœ awulapatshɔ Afarisayi! 'E sœ kœko bale lœ ndjokpa lœ kako dɔngɔ á tshafunœ ga waa, kashe 'e sœsœ kœmbœrœtœ 'e lindœ awa akwa á sœ dœ ádá waa nene ɓata: Kœsœ ndjii, kœwu oyo azu dœ pe kœyindœrœ. Œrœ á li má adœke 'e za ga tœ akwa dœmœ, yé œ tshapu kœmbœrœ udunœ nene. ");
INSERT INTO mnh_vpl VALUES ("MT23_24","070_23_24","MAT","23","24","24","Agbozu ayibula! 'E sœ kœsa ipi mbœrœ kœwo dœ aya voma, kashe 'e sœ kœmerœ shamo!» ");
INSERT INTO mnh_vpl VALUES ("MT23_25","070_23_25","MAT","23","25","25","«Oyo nœ 'e, aayi kœyisœ awa akwa œdœ awulapatshɔ Afarisayi! 'E sœ kœdjutɔ tshapa yashi œdœ pe tshapa saani, kashe tshelœnœ su dœ œrœ nœ angba œdœ dœ œrœ nœ ogo ekperœ nœ 'e. ");
INSERT INTO mnh_vpl VALUES ("MT23_26","070_23_26","MAT","23","26","26","Farisayi ayibula, djutɔ tshelœ yashi utshunœ yeka á tshapa nœ kœga ndje.» ");
INSERT INTO mnh_vpl VALUES ("MT23_27","070_23_27","MAT","23","27","27","«Oyo nœ 'e, aayi kœyisœ awa akwa œdœ awulapatshɔ Afarisayi! 'E sœ ɓata udu á endje dja tshapanœ dœ imbi ngbeya, á ga kolœ dja ga pa nœ, kashe tshelœnœ su kperœ dœ ngbabi akuzu œdœ dœ tshelœ aka mara ufu œrœ kɔ. ");
INSERT INTO mnh_vpl VALUES ("MT23_28","070_23_28","MAT","23","28","28","E'e ndje awa bale dja ga ushu, 'e sœ kœmatœ 'e ɓata azu á endje sœ ndjii tœ ala azu, kashe ɓa lœ 'e, e'e kœdœ awulapatshɔ œdœ aayi ngbɨndɨrœ.» ");
INSERT INTO mnh_vpl VALUES ("MT23_29","070_23_29","MAT","23","29","29","«Oyo nœ 'e, aayi kœyisœ awa akwa œdœ awulapatshɔ Afarisayi! 'E sœ kœmbœrœ ɔtshɔ udu mbœrœ aayi kœgbara o'o, yé œ sœ kœguma tshapadu azu á endje sœ ndjii dœ ambara. ");
INSERT INTO mnh_vpl VALUES ("MT23_30","070_23_30","MAT","23","30","30","Yé 'e sœ kœpa adœke: “Œdœ 'a kœsœ lima lɔndɔ nœ alata 'a zœ, 'a ngbɔtœ 'a lima dœ endje ndœ kœwo aayi kœgbara o'o nene.” ");
INSERT INTO mnh_vpl VALUES ("MT23_31","070_23_31","MAT","23","31","31","Ataa, 'e wusœ nœ dœ tœ 'e adœke e'e kœdœ aata azu á endje wo lima aayi kœgbara o'o ye! ");
INSERT INTO mnh_vpl VALUES ("MT23_32","070_23_32","MAT","23","32","32","Yé ngɔngɔ asœke, 'e te lœ kumu kœmbœrœ udu akwa nœ aata 'e! ");
INSERT INTO mnh_vpl VALUES ("MT23_33","070_23_33","MAT","23","33","33","E'e kœdœ ayakoro, ukpulu akatsha ayakoro! 'E gbe koto kœkpa awa adœke endje wa ngbanga djofele nœ lifelo 'e a? ");
INSERT INTO mnh_vpl VALUES ("MT23_34","070_23_34","MAT","23","34","34","Mbœrœ tœnœ ataa, mœ sœ kœvwa aayi kœgbara o'o, dœ aayi kœwusœtœ dœ pe aayi kœyisœ awa akwa fœ 'e. 'E wo anga endje, œ kuru anga endje ga pa kurushi, 'e kpa sɔ anga endje dœ ndjapa ɓa lœ Sinagoga nœ 'e œ gɔrɔ endje lœ ongbo dœ ongbo. ");
INSERT INTO mnh_vpl VALUES ("MT23_35","070_23_35","MAT","23","35","35","Yé indji azu á endje sœ ndjii á tu lima ga pa ɔshɔ asœmœ, sœ ga pa kumu 'e, kœto ɓa tœ indji Abele á tshe sœ ndjii œrrr ga tœ indji Zakariya, gbolo nœ Barashi á 'e wo lima she ɓa ugurutœ œyerœ osho œdœ ndaba lœ anda Ndjaba. ");
INSERT INTO mnh_vpl VALUES ("MT23_36","070_23_36","MAT","23","36","36","Mœ sœ kœpa fœ 'e dœ adjapu adœke: Tshangba œrœnœ asœmœ kɔ œ sœ ga pa kumu 'e dœ azu nœ tshakpesheke asœke!» ");
INSERT INTO mnh_vpl VALUES ("MT23_37","070_23_37","MAT","23","37","37","«Yerusaleme, Yerusaleme, œɓœ á ɓœ sœ kœwo aayi kœgbara o'o yé á sœ kœve endjeneke á Ndjaba sœ kœvwa endje fœ ɓœ dœ badja, awa ndjoro mœ yi lima ndœ kœngbɔɓa azu nœ zœ ga tœ œsœnœ bale ɓata á ayi ngato œ ngbɔɓa ayanœ ga tshakudu ombo ye, kashe 'e yiyi lima ndœ nœ nene! ");
INSERT INTO mnh_vpl VALUES ("MT23_38","070_23_38","MAT","23","38","38","Mbœrœ tœnœ ataa, Ndjaba œ gi ala ye pa anda nœ 'e, yé anga œrœ bale kpa gu nene. ");
INSERT INTO mnh_vpl VALUES ("MT23_39","070_23_39","MAT","23","39","39","Gbambanœ nene, mœ sœ kœpa fœ 'e adœke: Kœto ngɔngɔnœ asœke, 'e kpa wu mœ nene œrrr ga tœ lɔkɔ á 'e pa adœke: “Kaka Ndjaba to kane ye ga pa uzu á tshe na dœ ɨ'ɨrɨ Gbozu.”» ");
INSERT INTO mnh_vpl VALUES ("MT24_1","070_24_1","MAT","24","1","1","Lɔkɔ á Yisu wuta lima lœ Tepelo á tetœ kœro tœnœ, ayambarœ nœ ye na ndoo dœ she mbœrœ kœma mara á endje mɔ dœ Tepelo. ");
INSERT INTO mnh_vpl VALUES ("MT24_2","070_24_2","MAT","24","2","2","Yisu za o'o yé œ pa fœ endje adœke: «'E wu œrœnœ asœmœ kɔ? Mœ sœ kœpa dœ adjapu adœke anga badja bale œ kpa ka ga pa anganœ nene; tshelœnœ œ ndɨ para ye.» ");
INSERT INTO mnh_vpl VALUES ("MT24_3","070_24_3","MAT","24","3","3","Lɔkɔ á Yisu sœ ga atɨ ɓa pa kaga ɔyɔ olive, ayambarœ nœ ye gitœ endje ndoo dœ she ga ɨndɨrɨnœ, yé œ yu she adœke: «Pa fœ 'a kane, dœ ɔlɔ gaɗe dá œrœnœ asœmœ œ mbœrœ má tœ endje a? Yé ambárá gaɗe dá matœ endje dœ olo kœkwa ɓœ œdœ dœ olo kœka tshapashɔ a?» ");
INSERT INTO mnh_vpl VALUES ("MT24_4","070_24_4","MAT","24","4","4","Yisu gi fœ endje adœke: «Ala 'e gbɔ, uzu bale fafara 'e nene. ");
INSERT INTO mnh_vpl VALUES ("MT24_5","070_24_5","MAT","24","5","5","Gbambanœ nene, azu ndjoro œ na bala dœ ɨ'ɨrɨ mœ, œ pa adœke: “Œmœ kœdœ Masiya!” Yé endje fara azu ndjoro. ");
INSERT INTO mnh_vpl VALUES ("MT24_6","070_24_6","MAT","24","6","6","Ɔlɔ á 'e kœdjindœ upu nœ koshe á sœ lœ ondonœ œdœ œneke á sœ lœ ɨngɨrɨnœ, awa zaza 'e nene; œ li adœke œrœ ataa wuta yeka, kashe œ dœ́dœ́ damba kœka tshapashɔ dœmœ nene. ");
INSERT INTO mnh_vpl VALUES ("MT24_7","070_24_7","MAT","24","7","7","Ogo bale œ nga koshe dœ anga ogo, yé ogo gbozu bale œ nga koshe dœ anga ogo gbozu, egerœ ogo œdœ kœturu ɔshɔ œ za osho ngbangbangba. ");
INSERT INTO mnh_vpl VALUES ("MT24_8","070_24_8","MAT","24","8","8","Œrœnœ asœmœ kɔ œ sœ bala ɓata ali kœka œrœ á ka yashe utshu kœzu gbolo. ");
INSERT INTO mnh_vpl VALUES ("MT24_9","070_24_9","MAT","24","9","9","«Azu œ ko 'e bala mbœrœ adœke endje ndanga 'e yé œ wo 'e. Angbɨ azu kɔ œ yiangba 'e mbœrœ ɨ'ɨrɨ mœ. ");
INSERT INTO mnh_vpl VALUES ("MT24_10","070_24_10","MAT","24","10","10","Yé azu ndjoro œ katœ kœyindœrœ nœ endje; endje tɔ gbandatœ endje dœ pe kœyiangbatœ endje ugurutœ endje. ");
INSERT INTO mnh_vpl VALUES ("MT24_11","070_24_11","MAT","24","11","11","Ayi kœgbara o'o nœ wala œ wuta yé œ djingili tshelœ azu ndjoro. ");
INSERT INTO mnh_vpl VALUES ("MT24_12","070_24_12","MAT","24","12","12","Manda nœ, ngbɨndɨrœ œ gerœ lœ azu, yé kœyindœsho œ gerœ nene. ");
INSERT INTO mnh_vpl VALUES ("MT24_13","070_24_13","MAT","24","13","13","Kashe uzu neke á tshe ka ngbɨrɨ œrrr ga tœ ndɔngɔlɔnœ, œshe asœmœ dá she. ");
INSERT INTO mnh_vpl VALUES ("MT24_14","070_24_14","MAT","24","14","14","Endje mɨndœ Ɔtshɔ O'o ogo gbozu pa ɔshɔ djigi; angbɨ azu kɔ œ dji yeka á manda nœ á tshapashɔ œ ka.» ");
INSERT INTO mnh_vpl VALUES ("MT24_15","070_24_15","MAT","24","15","15","«'E wu bala tsheneke á endje e she “ayi kœndɨ œrœ” á ayi kœgbara o'o Daniyele pa lima tœ ye ɓa tœ œyerœ osho. Kaka tsheneke á tshe dɨ mbetinœ asœke wusœ ádánœ! ");
INSERT INTO mnh_vpl VALUES ("MT24_16","070_24_16","MAT","24","16","16","Yé œ li adœke endjeneke á endje sœ ɓa lœ ogo Yuda, kpa ga pa kaga. ");
INSERT INTO mnh_vpl VALUES ("MT24_17","070_24_17","MAT","24","17","17","Tsheneke á tshe kœsœ ɓa pa anda, œ lili adœke tshe jerœ ga atɨ mbœrœ kœko gbarœ nœ ye ɓa sœnda nœ ye nene. ");
INSERT INTO mnh_vpl VALUES ("MT24_18","070_24_18","MAT","24","18","18","Tsheneke á tshe kœsœ ɓa lœ kɨndɨ, œ lili adœke tshe kwatœ ye ndœ kœza yɔgbɔdɔ lœba nœ ye nene. ");
INSERT INTO mnh_vpl VALUES ("MT24_19","070_24_19","MAT","24","19","19","«Oyo nœ ayashe nguzu œdœ endjeneke á endje sœ kœko ɔngɔ ga lœ ama agbolo dœ olonœ asœmœ! ");
INSERT INTO mnh_vpl VALUES ("MT24_20","070_24_20","MAT","24","20","20","'E za avwala fœ Ndjaba mbœrœ á 'e kœkpakpa dœ yapu nœ ɨzɨ too dœ olo sabata nene. ");
INSERT INTO mnh_vpl VALUES ("MT24_21","070_24_21","MAT","24","21","21","Gbambanœ nene, dœ lɔkɔnœ asœmœ, egerœ oyo œ sœ zœ; œ sœ tœ egerœnœ kœrosœ œneke á endje wu ɓa lima kœto kpœtœ ali kœmbœrœ tshapashɔ œrrr ga tœ ngɔngɔ asœke, yé mara œrœ ataa œ kpa mbœrœtœ endje bale nene. ");
INSERT INTO mnh_vpl VALUES ("MT24_22","070_24_22","MAT","24","22","22","Œdœ Gbozu kœgbe má lima tœ kœgi ata olonœ nene, uzu bale œ sœpe má dœ soro nene; kashe mbœrœ endjeneke á tshe ke endje dá tshe kundœ átá olonœ asœmœ. ");
INSERT INTO mnh_vpl VALUES ("MT24_23","070_24_23","MAT","24","23","23","«Yé œdœ anga uzu kœpa fœ 'e adœke: “Masiya sœ ɓa ke” too “tshe sœ ɓa e”, 'e yiyindœ nœ fœ she nene. ");
INSERT INTO mnh_vpl VALUES ("MT24_24","070_24_24","MAT","24","24","24","Gbambanœ nene, aekpe masiya œdœ aayi kœgbara o'o nœ wala œ wuta ndjoro. Endje mbœrœ afá yé œ ma ambárá œrœ ndjoro dœ mara adœke œne djingili tshelœ kumu azu. Œdœ œ kœli ndje, endje mbœrœ ndje awa bale fœ endjeneke á Ndjaba ke endje. ");
INSERT INTO mnh_vpl VALUES ("MT24_25","070_24_25","MAT","24","25","25","'E dji kane! Mœ va tshelœ utu 'e tœnœ utshunœ ye. ");
INSERT INTO mnh_vpl VALUES ("MT24_26","070_24_26","MAT","24","26","26","«Œdœ endje kœpa fœ 'e adœke: “'E wu, tshe sœ ɓa lœ kpagagasho”, 'e nana ga zœ nene. Too œdœ endje kœpa fœ 'e adœke: “'e wu, tshe zatœ ye yiwa tœnœ ɓa ke”, 'e yiyindœ nœ nene. ");
INSERT INTO mnh_vpl VALUES ("MT24_27","070_24_27","MAT","24","27","27","Ɓata á yavuru œ yerœwa ɓa lafo, kœto ɓa tœ osho á ɔlɔ œ wuta tœnœ œrrr ga tœ osho á ɔlɔ œ li tœnœ, dœ mara ataa dá Gbolo nœ uzu œ na bala dœ tœnœ. ");
INSERT INTO mnh_vpl VALUES ("MT24_28","070_24_28","MAT","24","28","28","Osho á oko uzu sœ tœnœ dá adivumbala œ ngbɔtœ endje ɓa zœ.» ");
INSERT INTO mnh_vpl VALUES ("MT24_29","070_24_29","MAT","24","29","29","«Manda kœwu oyo nœ olonœ asœmœ, ɔlɔ œ te ubunœ, yapu œ kpa tɔ nene, angerepe œ to ɓa lafo œ yo ga atɨ, gbɔgbɔ nœ tshalafo œ turu. ");
INSERT INTO mnh_vpl VALUES ("MT24_30","070_24_30","MAT","24","30","30","Yé ambárá Gbolo nœ uzu œ wuta ɓa lafo; azu kɔ pa ɔshɔ œ dɨtshelœma endje, endje wu Gbolo nœ uzu kœna lœ ondoro dœ gbɔgbɔ djigi œdœ lœ mokɔ. ");
INSERT INTO mnh_vpl VALUES ("MT24_31","070_24_31","MAT","24","31","31","Tshe vwa bala aandjelu nœ ye ndœ kœ'uru ngbake tœ osho kɔ pa ɔshɔ: Tshe ngbɔɓa bala endjeneke á tshe ke endje tœ osho kɔ ga tœnœ.» ");
INSERT INTO mnh_vpl VALUES ("MT24_32","070_24_32","MAT","24","32","32","«'E dji ádá kœyisœrœ á to lœ ɔyɔ fige: Lɔndɔ á ganeanœ kœyɔrɔtshelœtœ endje, 'e wusœ nœ adœke yapu kœlu ngwarœ ndo ye. ");
INSERT INTO mnh_vpl VALUES ("MT24_33","070_24_33","MAT","24","33","33","Œ sœ ndje atamœ fœ 'e, ɔlɔ á 'e kœwu ndje œrœ ataa kœmbœrœtœ endje, 'e wusœ nœ adœke Gbolo nœ uzu ndo ye, tshe sœ lœ manda 'e. ");
INSERT INTO mnh_vpl VALUES ("MT24_34","070_24_34","MAT","24","34","34","Mœ sœ kœpa fœ 'e dœ adjapu, azu nœ tshakpesheke, endje tshu kɔ nene á œrœnœ œ mbœrœtœ endje. ");
INSERT INTO mnh_vpl VALUES ("MT24_35","070_24_35","MAT","24","35","35","Tshalafo dœ tshapa ɔshɔ œ ro ye, kashe o'o ama mœ œ ro nene.» ");
INSERT INTO mnh_vpl VALUES ("MT24_36","070_24_36","MAT","24","36","36","«Kashe olonœ œdœ ada ɔlɔnœ asœmœ, uzu bale wuwusœ nœ nene; œdœ aandjelu ɓa lafo, œdœ Gbolo nœ uzu, endje wuwusœ nœ nene, Aba kutɨ ye dá wusœ nœ. ");
INSERT INTO mnh_vpl VALUES ("MT24_37","070_24_37","MAT","24","37","37","Lɔndɔ nœ kœna Gbolo nœ uzu, œrœ œ mbœrœtœ endje kolœ ɓata mara œrœ á mbœrœ lima tœ endje dœ lɔkɔ nœ Nowa. ");
INSERT INTO mnh_vpl VALUES ("MT24_38","070_24_38","MAT","24","38","38","Gbambanœ nene, dœ lɔndɔnœ asœmœ, utshu lɔkɔ egerœ kœsu ungu pa ɔshɔ djigi, azu sœ lima kœzɨrœ dœ kœndjorœ, endje sœ lima kœtotœ endje too kœko ayawuru nœ endje ndœ totœ œrrr ga tœ olo á Nowa li lima ga lœ egerœ agba. ");
INSERT INTO mnh_vpl VALUES ("MT24_39","070_24_39","MAT","24","39","39","Endje sœsœ lima kœgbe dœ œrœ bale nene œrrr á egerœ kœsu ungu na, á endje tara para kɔkɔ. Œ sœ ndje ataa lɔkɔ á Gbolo nœ uzu œ na bala. ");
INSERT INTO mnh_vpl VALUES ("MT24_40","070_24_40","MAT","24","40","40","Yé ayakoshe bisha œ sœ ɓa lœ kɨndɨ, endje za anga bale, œ katœ anga tɨ. ");
INSERT INTO mnh_vpl VALUES ("MT24_41","070_24_41","MAT","24","41","41","Ayashe bisha œ sœ kœtɔ œrœ lœ kafuru, endje za anga bale, œ katœ anga tɨ. ");
INSERT INTO mnh_vpl VALUES ("MT24_42","070_24_42","MAT","24","42","42","Ataa, ala 'e gbɔ mbœrœ 'e wuwusœ olo neke á Gbozu nœ 'e œ na dœ tœnœ nene. ");
INSERT INTO mnh_vpl VALUES ("MT24_43","070_24_43","MAT","24","43","43","'E wusœ nœ adœke, œdœ ayengɔ anda kœwusœ ada ɔlɔ nœ butshɔ á ayi angba œ na kœzɨ angba œrœ nœ ye, tshe lo olo nene yé tshe katœ ye adœke tshe to ogoro lœ anda nœ ye nene. ");
INSERT INTO mnh_vpl VALUES ("MT24_44","070_24_44","MAT","24","44","44","Mbœrœ tœnœ ataa, e'e ndje, ala 'e gbɔ mbœrœ Gbolo nœ uzu œ na dœ ada ɔlɔ neke á 'e wuwusœ nœ nene.» ");
INSERT INTO mnh_vpl VALUES ("MT24_45","070_24_45","MAT","24","45","45","«Ataa, œɗe dá dœ ayi akwa á tshe sœ kœmbœrœtœ ye lindœ o'o gbozu nœ ye, yé á sœ ndje dœ kœwusœrœ á gbozu akwa nœ ye za she tœ kapeta nœ anganœ, mbœrœ kœto kœzɨrœ fœ endje liaka ada ɔlɔ dali a? ");
INSERT INTO mnh_vpl VALUES ("MT24_46","070_24_46","MAT","24","46","46","Yanga nœ ayi akwanœ asœmœ œdœ gbozunœ kœgu á gbɔ she lœma akwanœ! ");
INSERT INTO mnh_vpl VALUES ("MT24_47","070_24_47","MAT","24","47","47","Mœ sœ kœpa dœ adjapu fœ 'e: gbozu œ za she tœ kapeta tshapa œrœ nœ ye kɔ. ");
INSERT INTO mnh_vpl VALUES ("MT24_48","070_24_48","MAT","24","48","48","Kashe œdœ œshe kœdœ ekpe ayi akwa, á pa ɓa lɔsu ye adœke: “Gbozu nœ mœ œ gu katsha nene”, ");
INSERT INTO mnh_vpl VALUES ("MT24_49","070_24_49","MAT","24","49","49","yé á tetœ kœɓi aayi akwa anganœ, kœzɨ œrœ dœ pe kœndjo œrœ awa bale dœ aayi kœndjorœ, ");
INSERT INTO mnh_vpl VALUES ("MT24_50","070_24_50","MAT","24","50","50","gbozu nœ ayi akwanœ asœmœ œ gu dœ olo œdœ dœ ada ɔlɔ á ayi akwanœ wuwusœ nœ nene. ");
INSERT INTO mnh_vpl VALUES ("MT24_51","070_24_51","MAT","24","51","51","Tshe gɔrɔ ayi akwanœ, œ mbœrœ œrœ kanga nœ awulapatshɔ fœ she, ɓa tœ osho á azu œ kɨ dœ pe kœzɨ tshelœ daji endje gbagbara gbagbara.» ");
INSERT INTO mnh_vpl VALUES ("MT25_1","070_25_1","MAT","25","1","1","«Yé Ogo gbozu nœ tshalafo sœ ɓata ɔkpɔ ayawuru ndjokpa á endje ko miinda nœ endje, yé á wuta kœna kœtogba dœ yakoshe totœ. ");
INSERT INTO mnh_vpl VALUES ("MT25_2","070_25_2","MAT","25","2","2","Anga endje mindu kœdœ aayi ɨndɨ, anga endje mindu kœdœ aayi kœwusœrœ. ");
INSERT INTO mnh_vpl VALUES ("MT25_3","070_25_3","MAT","25","3","3","Kœko miindanœ, aayi ɨndɨnœ mindu susu lima kada ga lœ œnœ endje nene; ");
INSERT INTO mnh_vpl VALUES ("MT25_4","070_25_4","MAT","25","4","4","kashe aayi kœwusœrœnœ mindu su lima kada ga lœ anga á na dœ tœnœ dœ miinda nœ endje. ");
INSERT INTO mnh_vpl VALUES ("MT25_5","070_25_5","MAT","25","5","5","Ɓata œndœ yakoshenœ sœ lima kœdɨ tœnœ waa, olo mbœrœ endje, endje lo para ye. ");
INSERT INTO mnh_vpl VALUES ("MT25_6","070_25_6","MAT","25","6","6","«Lœ ɔgbɔ butshɔ, anga uzu bale tetœ rawa adœke: “'E wu, yakoshenœ dá yi kumu ye asœ; 'e wuta ndœ ye.” ");
INSERT INTO mnh_vpl VALUES ("MT25_7","070_25_7","MAT","25","7","7","Ɔkpɔ ayawurunœ kœjo para yé kœtetœ kœguma miinda nœ endje. ");
INSERT INTO mnh_vpl VALUES ("MT25_8","070_25_8","MAT","25","8","8","Aayi ɨndɨnœ kœpa fœ ayi kœwusœrœ adœke: “'E su anga kada nœ 'e fœ 'a mbœrœ œnœ 'a miindanœ sœ kœru tœnœ.” ");
INSERT INTO mnh_vpl VALUES ("MT25_9","070_25_9","MAT","25","9","9","Aayi kœwusœrœ kœgi fœ endje adœke: “Œ ngba 'a ye, œ gegerœ yeka á 'a kœsu mbœrœ 'a œdœ fœ 'e nene. 'E na œ yɔ œne 'e ɓa ndœ aayi kœka œrœ.” ");
INSERT INTO mnh_vpl VALUES ("MT25_10","070_25_10","MAT","25","10","10","Lɔndɔ á aayi ɨndɨnœ ro kœyɔ kadanœ ga zœ atake, yakoshe totœnœ yi kumu ye. Akpɔ ayawuru mindu á endje guma má tœ endje yindjindjinœ asœmœ, li dœ she ga sœnda angbo totœnœ, yé endje kœtshu mandanœ ga tœnœ ye. ");
INSERT INTO mnh_vpl VALUES ("MT25_11","070_25_11","MAT","25","11","11","Œndœnœ dɨ manda nœ, ɔkpɔ ayawuru ɨndɨnœ gu œ tetœ kœ'e osho adœke: “Gbozu, gbozu, kɔrɔ manda fœ 'a ka!” ");
INSERT INTO mnh_vpl VALUES ("MT25_12","070_25_12","MAT","25","12","12","Kashe tshe gi adœke: “Mœ sœ kœpa dœ adjapu fœ 'e adœke, mœ wuwusœ 'e nene.” ");
INSERT INTO mnh_vpl VALUES ("MT25_13","070_25_13","MAT","25","13","13","Atamœ, ala 'e gbɔ, mbœrœ 'e wuwusœ olo dœ pe ada ɔlɔ nene.» ");
INSERT INTO mnh_vpl VALUES ("MT25_14","070_25_14","MAT","25","14","14","«Œ sœ bala ɓata anga yakoshe á tshe yi lima ndœ kœna ana: Tshe e aayi akwa nœ ye œ katœ œrœ nœ ye fœ endje. ");
INSERT INTO mnh_vpl VALUES ("MT25_15","070_25_15","MAT","25","15","15","Tshe ko fœ anga talata mindu, anga talata bisha, fœ votɔnœ talata bale: Tshe ko fœ uzu dœ uzu liaka gbɔgbɔ nœ ye. Manda nœ, tshe ro daye. ");
INSERT INTO mnh_vpl VALUES ("MT25_16","070_25_16","MAT","25","16","16","Ayi akwa á tshe gbɔ talata mindu gu œ za ga tœ akwa, yé œ kpa gbɔ anganœ mindu ga panœ. ");
INSERT INTO mnh_vpl VALUES ("MT25_17","070_25_17","MAT","25","17","17","Tsheneke á tshe gbɔ talata bisha mbœrœ ndje awa bale, yé œ kpa gbɔ talata bisha ga panœ. ");
INSERT INTO mnh_vpl VALUES ("MT25_18","070_25_18","MAT","25","18","18","Kashe tsheneke á tshe gbɔ talata bale, gu œ dji kudu ɓa lœ ɔshɔ, yé œ za talata bale nœ gbozu akwa nœ ye yiwa tœnœ ga lœ nœ.» ");
INSERT INTO mnh_vpl VALUES ("MT25_19","070_25_19","MAT","25","19","19","«Œndœnœ kœdɨ œrrr manda nœ, gbozu nœ aayi akwanœ asœmœ gu, yé œ tetœ kœyu endje tœ akwa á tshe ka lima tœnœ fœ endje. ");
INSERT INTO mnh_vpl VALUES ("MT25_20","070_25_20","MAT","25","20","20","Tsheneke á tshe gbɔ lima talata mindu gitœ ye ndoo, œ pa adœke: “Gbozu, wu, ɓœ ko lima talata mindu fœ mœ. Anganœ mindu á mœ gbɔ ga panœ dœke.” ");
INSERT INTO mnh_vpl VALUES ("MT25_21","070_25_21","MAT","25","21","21","Gbozu nœ ye pa fœ she adœke: “Œ sœ dœ ɔtshɔnœ, œɓœ kœdœ ɔtshɔ ayi akwa yé ɓœ mbœrœtœ zœ lindœ nœ. Ɓata á ɓœ mbœrœtœ zœ lindœ nœ lœ aya akwa ataa, mœ za ɓœ ga pa egerœnœ. Na ga mœ œ sœ dœ yanga awa bale dœ gbozu nœ zœ.” ");
INSERT INTO mnh_vpl VALUES ("MT25_22","070_25_22","MAT","25","22","22","Tsheneke á tshe gbɔ lima talata bisha na ndje œne ye, yé œ pa adœke: “Gbozu, ɓœ ko lima talata bisha fœ mœ. Anganœ bisha á mœ gbɔ ga panœ dœke.” ");
INSERT INTO mnh_vpl VALUES ("MT25_23","070_25_23","MAT","25","23","23","Gbozu nœ ye pa fœ she adœke: “Œ sœ dœ ɔtshɔnœ, œɓœ kœdœ ɔtshɔ ayi akwa yé ɓœ mbœrœtœ zœ lindœ nœ. Ɓata á ɓœ mbœrœtœ zœ lindœ nœ lœ aya akwa ataa, mœ za ɓœ ga pa egerœnœ. Na ga mœ œ sœ dœ yanga awa bale dœ gbozu nœ zœ.” ");
INSERT INTO mnh_vpl VALUES ("MT25_24","070_25_24","MAT","25","24","24","«Tsheneke á tshe gbɔ lima talata bale kœna, yé á kœpa œnœ ye adœke: “Gbozu, mœ wu lima sœ nœ adœke œɓœ kœdœ gbozu á ɓœ ngaanga: Ɓœ sœ kœkɔ ngwarœ á œ dœ́dœ́ ɓœ dá lu nene, ɓœ sœ kœkɔ ngwarœ ɓa tœ osho á ɓœ lulu œrœ bale nene. ");
INSERT INTO mnh_vpl VALUES ("MT25_25","070_25_25","MAT","25","25","25","Awa za mœ, yé á mœ na á za talata nœ zœ yiwa tœnœ ga lœ ɔshɔ. Wu, œrœ nœ zœ dœke.” ");
INSERT INTO mnh_vpl VALUES ("MT25_26","070_25_26","MAT","25","26","26","Kashe gbozu nœ ye gi fœ she adœke: “Ekpe ayi akwa, ayi ɔdɔ! Ɓœ wu lima sœ nœ adœke mœ sœ kœkɔ ngwarœ á œ dœ́dœ́ mœ dá lu nene, mœ sœ kœkɔ ngwarœ ɓa tœ osho á mœ lulu œrœ bale nene. ");
INSERT INTO mnh_vpl VALUES ("MT25_27","070_25_27","MAT","25","27","27","Ataa, œ li má adœke ɓœ ko ngendja nœ mœ ga lœ anda kœgumasœ ngendja, yé á mœ kœgu má atake, á kœgbɔ anga œrœ nœ mœ ga pa nœ. ");
INSERT INTO mnh_vpl VALUES ("MT25_28","070_25_28","MAT","25","28","28","'E za talatanœ asœmœ bale tœ ye, yé œ za fœ tsheneke á tshe sœ dœ tœnœ ndjokpa asœmœ. ");
INSERT INTO mnh_vpl VALUES ("MT25_29","070_25_29","MAT","25","29","29","Gbambanœ nene, uzu kɔ á tshe sœ dœ œrœ ndjoro, endje to anganœ ga panœ fœ she. Tsheneke á tshe gugu dœ œrœ nene, endje ko œneke teasho á tshe sœpe dœ tœnœ, tœ ye yé. ");
INSERT INTO mnh_vpl VALUES ("MT25_30","070_25_30","MAT","25","30","30","Tœ ayi akwanœ á ádá ye gugu nene asœ, 'e vwi she ga lœ ubu osho ɓa shu: Ɓa zœ kœdœ kolœ ɨkɨ œdœ kœ zɨ tshelœ daji gbagbara gbagbara.”» ");
INSERT INTO mnh_vpl VALUES ("MT25_31","070_25_31","MAT","25","31","31","«Lɔkɔ á Gbolo nœ uzu œ na bala lœ mokɔ nœ ye dœ aandjelu para, tshe sœ ɓa pa ngande tshagbozu nœ mokɔ nœ ye. ");
INSERT INTO mnh_vpl VALUES ("MT25_32","070_25_32","MAT","25","32","32","Azu ogo kɔ pa ɔshɔ œ ngbɔtœ endje ɓa utshu ye, yé tshe kurutshelœ azu dœ azu ɓata á ayi kœgbɔndœ ayarœ œ kurutshelœ apata dœ ayaburu. ");
INSERT INTO mnh_vpl VALUES ("MT25_33","070_25_33","MAT","25","33","33","Tshe ko apata ga tœ kuni ye, yé œ ko ayaburu ga tœ gele ye. ");
INSERT INTO mnh_vpl VALUES ("MT25_34","070_25_34","MAT","25","34","34","Yé gbozugo œ pa fœ endjeneke á endje sœ ga tœ kuni ye adœke: “'E na ga mœ, e'e á Aba mœ to kane ye ga pa 'e. 'E li ga lœ ogo tshagbozu á endje guma ɓa lima sœ nœ fœ 'e, kœtotœ kœmbœrœ tshapashɔ. ");
INSERT INTO mnh_vpl VALUES ("MT25_35","070_25_35","MAT","25","35","35","Gbambanœ nene, mœ sœ lima dœ ogo yé 'e to kœzɨrœ fœ mœ; mœ sœ lima dœ ogo ungu yé 'e su ungu fœ mœ; mœ dœ lima gene yé 'e za osho kœsœ fœ mœ; ");
INSERT INTO mnh_vpl VALUES ("MT25_36","070_25_36","MAT","25","36","36","mœ sœ lima kpendronœ yé 'e za lœba fœ mœ; mœ sœ lima dœ koɓa yé 'e na ndœ kœtɨtœ mœ; mœ sœ lima lœ anda kánga yé 'e na kœwu mœ.” ");
INSERT INTO mnh_vpl VALUES ("MT25_37","070_25_37","MAT","25","37","37","«Yé azu á endje sœ ndjii gi fœ she adœke: “Gbozu, lɔkɔ gaɗe á 'a wu lima ɓœ dœ ogo yé á to kœzɨrœ fœ ɓœ a, dœ ogo ungu yé á su ungu fœ ɓœ a? ");
INSERT INTO mnh_vpl VALUES ("MT25_38","070_25_38","MAT","25","38","38","Lɔkɔ gaɗe á 'a wu lima ɓœ tœ gene yé á za osho kœsœ fœ ɓœ a? Lɔkɔ gaɗe dá 'a wu lima ɓœ kpendronœ yé á za lœba fœ ɓœ a? ");
INSERT INTO mnh_vpl VALUES ("MT25_39","070_25_39","MAT","25","39","39","Lɔkɔ gaɗe dá 'a wu lima ɓœ dœ koɓa too lœ anda kánga yé á 'a na kœwu ɓœ a?” ");
INSERT INTO mnh_vpl VALUES ("MT25_40","070_25_40","MAT","25","40","40","Yé gbozugo œ gi fœ endje adœke: “Mœ sœ kœpa fœ 'e dœ adjapu adœke: Ɔlɔ kɔ á 'e sœ lima kœmbœrœ œrœnœ asœmœ fœ anga aaya lœ aaya mœ á œsœ endje lɨlɨ nene, œmœ dá 'e sœ lima kœmbœrœ tœnœ fœ mœ asœmœ.” ");
INSERT INTO mnh_vpl VALUES ("MT25_41","070_25_41","MAT","25","41","41","«Manda nœ, tshe pa bala fœ endjeneke á endje sœ ga pa gele ye adœke: “'E gitœ 'e zara tœ mœ, e'e dœ azu á endje darandœ 'e! 'E na œ yo ga la owo á ru nene, á endje guma fœ djaboro dœ aandjelu nœ ye. ");
INSERT INTO mnh_vpl VALUES ("MT25_42","070_25_42","MAT","25","42","42","Gbambanœ nene, mœ sœ lima dœ ogo yé 'e toto kœzɨrœ fœ mœ nene; mœ sœ lima dœ ogo ungu yé 'e susu ungu kœndjo tœnœ fœ mœ nene; ");
INSERT INTO mnh_vpl VALUES ("MT25_43","070_25_43","MAT","25","43","43","mœ na lima tœ gene yé 'e zaza osho kœsœ fœ mœ nene; mœ sœ lima kpendronœ yé 'e zaza lœba fœ mœ nene; mœ sœ lima dœ koɓa yé 'e nana œ tɨtœ mœ nene; mœ sœ lima lœ anda kánga yé 'e nana œ wu mœ nene.” ");
INSERT INTO mnh_vpl VALUES ("MT25_44","070_25_44","MAT","25","44","44","Yé endje ndje, endje gi bala adœke: “Gbozu, ɔlɔ gaɗe dá 'a wu lima ɓœ dœ ogo too dœ ogo ungu, tœ gene too kpendronœ a, dœ koɓa too lœ anda kánga yeka á gbegbe lima dœ ɓœ nene a?” ");
INSERT INTO mnh_vpl VALUES ("MT25_45","070_25_45","MAT","25","45","45","Yé tshe gi bala fœ endje adœke: “Mœ sœ kœpa fœ 'e dœ adjapu, ɔlɔ dœ ɔlɔ á 'e mbœmbœrœ lima œrœnœ asœmœ fœ anga aya bale ugurutœ aaya mœ á œsœ endje lɨlɨ nene, 'e mbœmbœrœ ndje lima fœ mœ nene.” ");
INSERT INTO mnh_vpl VALUES ("MT25_46","070_25_46","MAT","25","46","46","Yé endjeneke œ li bala ga lœ djofele neke á ka nene. Andaa, azu á endje sœ ndjii œ li bala ga lœ soro nœ waa dœ waa.» ");
INSERT INTO mnh_vpl VALUES ("MT26_1","070_26_1","MAT","26","1","1","Lɔkɔ á Yisu mɨndœ upunœ asœmœ kɔkɔ ye, tshe pa fœ ayambarœ nœ ye adœke: ");
INSERT INTO mnh_vpl VALUES ("MT26_2","070_26_2","MAT","26","2","2","«'E wusœ nœ adœke œ sœpe olo bisha kœwuta ga tœ angbo nœ pake: Endje za Gbolo nœ uzu yɔ œrœ ndœ kœkuru she ga pa kurushi.» ");
INSERT INTO mnh_vpl VALUES ("MT26_3","070_26_3","MAT","26","3","3","Yé agbozu tshapa anganga Ndjaba dœ pe agbozu Ikrizia ngbɔtœ endje ɓa sœnda nœ egerœ nganga Ndjaba á ɨ'ɨrɨ ye kœdœ Kayifa. ");
INSERT INTO mnh_vpl VALUES ("MT26_4","070_26_4","MAT","26","4","4","Endje djitœ endje yé œ wa adœke œne frandœ Yisu œ tepa ye yeka á kœ wo she. ");
INSERT INTO mnh_vpl VALUES ("MT26_5","070_26_5","MAT","26","5","5","Endje sœ lima kœpa adœke: «Œ lili adœke a za she dœ lɔndɔ angbonœ nene, ete nene azu œ oma ye.» ");
INSERT INTO mnh_vpl VALUES ("MT26_6","070_26_6","MAT","26","6","6","Lɔkɔ á Yisu sœ lima ɓa lœ Betani ɓa sœnda nœ ayi boroma Shimu, ");
INSERT INTO mnh_vpl VALUES ("MT26_7","070_26_7","MAT","26","7","7","anga yashe bale na dœ yombo nœ ye lœ anga á endje mbœrœ dœ albatre, ama yombonœ gbɔ waa. Tshe su yombonœ ga lœ kumu Yisu lɔndɔ á tshe sœ pa ndaba kœzɨ œrœ. ");
INSERT INTO mnh_vpl VALUES ("MT26_8","070_26_8","MAT","26","8","8","Lɔkɔ á ayambarœ nœ ye wu ataa, endje sœ dœ ekpe lɔsu yé œ pa adœke: «Mbœrœ gaɗe á tshe ndɨ ungu yombonœ asœ ataa? ");
INSERT INTO mnh_vpl VALUES ("MT26_9","070_26_9","MAT","26","9","9","Œ li má adœke endje ka yombonœ asœmœ dœ amanœ tœ ɔgbɔnœ yé œ kurutshelœ ngendjanœ tœ aayi oyo.» ");
INSERT INTO mnh_vpl VALUES ("MT26_10","070_26_10","MAT","26","10","10","Yisu wusœ nœ lima adœke endje sœ kœpa ataa, yé œ pa fœ endje adœke: «Mbœrœ gaɗe á 'e sœ kœndanga yashenœ asœke a? Œrœ á tshe mbœrœ fœ mœ kœdœ ɔtshɔrœ. ");
INSERT INTO mnh_vpl VALUES ("MT26_11","070_26_11","MAT","26","11","11","Gbambanœ nene, 'e sœ tœ œsœnœ dœ aayi oyo ɔlɔ dœ ɔlɔ. Kashe œmœ, 'e sœ dœ mœ awa bale waa nene. ");
INSERT INTO mnh_vpl VALUES ("MT26_12","070_26_12","MAT","26","12","12","Tshe su yombonœ asœmœ kpɔɔ ga tœ ɔkɔ mœ mbœrœ kœguma mœ ndœ kœshi mœ. ");
INSERT INTO mnh_vpl VALUES ("MT26_13","070_26_13","MAT","26","13","13","Mœ sœ kœpa dœ adjapu fœ 'e adœke: Osho kɔ á endje pandœ Ɔtshɔ O'onœ asœke tœnœ pa tshapashɔ djigi, endje pandœ œrœ á yashe asœke mbœrœ, yé endje gbe dœ she.» ");
INSERT INTO mnh_vpl VALUES ("MT26_14","070_26_14","MAT","26","14","14","Yé anga yambarœ bale lœ andjokpa dœ bisha á ɨ'ɨrɨ ye kœdœ Yudasi Isikariote, na ga ndœ agbozu tshapa anganga Ndjaba, ");
INSERT INTO mnh_vpl VALUES ("MT26_15","070_26_15","MAT","26","15","15","yé œ pa fœ endje adœke: «Œrœ gaɗe dá 'e za fœ mœ œdœ mœ kœza she yɔ œrœ fœ 'e a?» Endje dɨ langere ngendja zazu bale dœ ndjokpa (30), yé á ko fœ she. ");
INSERT INTO mnh_vpl VALUES ("MT26_16","070_26_16","MAT","26","16","16","Kœto pe dœ lɔkɔnœ asœmœ, Yuda tetœ kœpara awa ndœ kœza Yisu fœ endje. ");
INSERT INTO mnh_vpl VALUES ("MT26_17","070_26_17","MAT","26","17","17","Dœ ali olo nœ angbo nœ mapa á susuku nene, ayambarœ na kœyu Yisu adœke: «Ɓœ yindœ nœ adœke 'a guma kœzɨrœ nœ pake fœ ɓœ kpœta a?» ");
INSERT INTO mnh_vpl VALUES ("MT26_18","070_26_18","MAT","26","18","18","Tshe pa fœ endje adœke: «'E na ɓa ndœ anga uzu bale lœ ongbo yé œ pa fœ she adœke: “Gbozu pa adœke: Ada ɔlɔ nœ mœ li ye; mœ mbœrœ angbo pake dœ ayambarœ nœ mœ ɓa ndœ zœ.”» ");
INSERT INTO mnh_vpl VALUES ("MT26_19","070_26_19","MAT","26","19","19","Ayambarœnœ mbœrœ ɓata á tshe pa tœnœ fœ endje, yé œ guma œrœ angbo Pakenœ. ");
INSERT INTO mnh_vpl VALUES ("MT26_20","070_26_20","MAT","26","20","20","Lɔkɔ á ɔlɔ dɨ, Yisu sœ pa ndaba kœzɨrœ dœ ayambarœ ndjokpa dœ bisha. ");
INSERT INTO mnh_vpl VALUES ("MT26_21","070_26_21","MAT","26","21","21","Lɔndɔ á endje sœ kœzɨrœ, tshe kœpa adœke: «Mœ sœ kœpa fœ 'e dœ adjapu, anga yanga 'e bale œ za mœ yɔ œrœ zœ.» ");
INSERT INTO mnh_vpl VALUES ("MT26_22","070_26_22","MAT","26","22","22","Oyo kœza endje, endje kœtetœ kœyu she uzu dœ uzu adœke: Œ dœ mœ a, Gbozu? ");
INSERT INTO mnh_vpl VALUES ("MT26_23","070_26_23","MAT","26","23","23","Tshe kœgi adœke: «Œshe á tshe ngbɔ kane ye lœ gbarœ kœzɨrœ awa bale dœ mœ asœmœ, œshe dá za mœ yɔ œrœ. ");
INSERT INTO mnh_vpl VALUES ("MT26_24","070_26_24","MAT","26","24","24","Gbolo nœ uzu œ tshu ɓata á endje sú lima ala buku nœ Ndjaba tœ upu nœ ye. Kashe oyo nœ uzu á tshe za Gbolo nœ uzu yɔ œrœ. Œ sœ má dœ ɔtshɔnœ mbœrœ uzunœ adœke adja endje zuzu she nene!» ");
INSERT INTO mnh_vpl VALUES ("MT26_25","070_26_25","MAT","26","25","25","Yudasi, á tshe sœ kœza she yɔ œrœ, za o'o œ pa adœke: «Œdœ mœ a, Gbozu?» Yisu gi fœ she adœke: «Œɓœ dœ tœ zœ ɓœ pa ye.» ");
INSERT INTO mnh_vpl VALUES ("MT26_26","070_26_26","MAT","26","26","26","Dœ lɔndɔ kœzɨ œrœ, Yisu za mapa œ donga Ndjaba, œ kavwa tshelœnœ, œ ko fœ ayambarœ nœ ye, yé œ pa adœke: «'E ko œ zɨ, asœ kœdœ undu mœ.» ");
INSERT INTO mnh_vpl VALUES ("MT26_27","070_26_27","MAT","26","27","27","Manda nœ, tshe za ndje yashi vinu, œ donga Ndjaba, yé œ za fœ endje dœ kœpa adœke: «E'e kɔ 'e ndjo, ");
INSERT INTO mnh_vpl VALUES ("MT26_28","070_26_28","MAT","26","28","28","mbœrœ asœke kœdœ indji mœ, indji á guma ayo ugurutœ Ndjaba dœ azu, indji á tu mbœrœ azu ndjoro œdœ mbœrœ kœdjerœndœ ekperœ nœ azu. ");
INSERT INTO mnh_vpl VALUES ("MT26_29","070_26_29","MAT","26","29","29","Mœ sœ kœpa dœ adjapu fœ 'e adœke, mœ kpa ndjo vinu nene œrrr ga tœ lɔkɔ á mœ ndjo bala tafonœ dœ 'e ɓa lœ Ogo gbozu nœ Aba mœ.» ");
INSERT INTO mnh_vpl VALUES ("MT26_30","070_26_30","MAT","26","30","30","Manda kœdonga Ndjaba dœ itshi, endje wuta ndœ kœɔ ga pa kaga ɔyɔ Olive. ");
INSERT INTO mnh_vpl VALUES ("MT26_31","070_26_31","MAT","26","31","31","Yé Yisu kœpa fœ endje adœke: «Lœ butshɔ asœ, e'e kɔ 'e katœ mœ tɨ ye. Gbambanœ nene, endje sú ɓa la buku nœ Ndjaba adœke: “Mœ ɓi bala ayi kœgbɔndœ apata, yé ukpulu apatanœ œ ndjɔtshelœtœ endje.” ");
INSERT INTO mnh_vpl VALUES ("MT26_32","070_26_32","MAT","26","32","32","Kashe, Yisu kpa pa adœke: Lɔkɔ á Ndjaba kœshe mœ lœ kuzu, mœ na utshu 'e ga lœ Galilayi.» ");
INSERT INTO mnh_vpl VALUES ("MT26_33","070_26_33","MAT","26","33","33","Petro za o'o œ pa fœ she adœke: «Œdœ azu kɔ kœkatœ zœ tɨ, œmœ, mœ katœ zœ tɨ nene.» ");
INSERT INTO mnh_vpl VALUES ("MT26_34","070_26_34","MAT","26","34","34","Yisu gi fœ she adœke: «Mœ pa fœ ɓœ dœ adjapu adœke, dœ butshɔnœ asœke utshunœ adœke kɔngato kɨ, ɓœ 'ea mœ awa votɔ.» ");
INSERT INTO mnh_vpl VALUES ("MT26_35","070_26_35","MAT","26","35","35","Petro pa fœ she adœke: «Œdœ œ kœsœ adœke a tshu dœ ɓœ, mœ 'ea ɓœ bale nene.» Yé ayambarœnœ kɔ pa ndje awa bale. ");
INSERT INTO mnh_vpl VALUES ("MT26_36","070_26_36","MAT","26","36","36","Yisu wuta dœ ayambarœ nœ ye ɓa tœ anga osho á endje e ɨ'ɨrɨnœ Getesemane, yé á pa fœ endje adœke: «'E sœ ga atɨ kpœke, mœ sœ kœna kœza avwala ɓa 'e.» ");
INSERT INTO mnh_vpl VALUES ("MT26_37","070_26_37","MAT","26","37","37","Tshe za Petro œdœ agbolo yakoshe nœ Zebedayi bisha á na dœ endje. Tshe tetœ kœgbɔ oyo tœ lɔsu ye, yé awa li she gɔrɔ. ");
INSERT INTO mnh_vpl VALUES ("MT26_38","070_26_38","MAT","26","38","38","Yé á tshe kœpa fœ endje adœke: «Lɔsu mœ su kperœ dœ oyo nœ kuzu. 'E sœ kpœke yé œ lolo nene awa bale dœ mœ.» ");
INSERT INTO mnh_vpl VALUES ("MT26_39","070_26_39","MAT","26","39","39","Tshe gitœ ye zara œ te dœ tshatshu ye ga tœ ɔshɔ, œ za avwala adœke: «Aba mœ, œdœ œ kœli, gi yashi œrœ kanganœ asœke zara tœ mœ ye. Œ sœsœ adœke ɓœ mbœrœ œneke á mœ yindœ nœ nene, kashe mbœrœ ɓata á ɓœ yindœ nœ.» ");
INSERT INTO mnh_vpl VALUES ("MT26_40","070_26_40","MAT","26","40","40","Manda nœ, tshe gu ga ndœ ayambarœ yé œ gbɔ endje lœ olo. Tshe pa fœ Petro adœke: «Shimu, 'e sœsœ dœ gbɔgbɔ kœsœ dœ uburu ala 'e awa bale dœ mœ manda ada ɔlɔ bale nene a? ");
INSERT INTO mnh_vpl VALUES ("MT26_41","070_26_41","MAT","26","41","41","'E lolo nene yé œ za avwala mbœrœ adœke 'e yoyo ga lœ kœwu lɔsu nene. Ɨshirɨ uzu su dœ gbɔgbɔ, kashe undu ye gugu dœ gbɔgbɔ nene.» ");
INSERT INTO mnh_vpl VALUES ("MT26_42","070_26_42","MAT","26","42","42","Tshe kpa gitœ ye zara tœ bishanœ kœza avwala dœ kœpa adœke: «Aba mœ, œdœ œ kœli, za yashi œrœ kanganœ asœke adœke mœ ndjondjo nene. Kaka ɓœ mbœrœ ɓata á ɓœ yindœ nœ!» ");
INSERT INTO mnh_vpl VALUES ("MT26_43","070_26_43","MAT","26","43","43","Tshe kpa gu ga ndœ ayambarœ nœ ye, œ gbɔ endje kolœ lœ olo, mbœrœ ala endje sœ lima dœ kɨkɨlɨnœ, awa kœkɔrɔ tœnœ gugu nene. ");
INSERT INTO mnh_vpl VALUES ("MT26_44","070_26_44","MAT","26","44","44","Tshe kpa gitœ ye, yé œ za avwala tœ votɔnœ kolœ dœ kœpa tshetœ o'onœ asœmœ. ");
INSERT INTO mnh_vpl VALUES ("MT26_45","070_26_45","MAT","26","45","45","Manda nœ, tshe kpa gu ga ndœ ayambarœ œ pa fœ endje adœke: «'E sœpe kœlo tœnœ œdœ pe kœyatœ 'e! Ngɔngɔnœ asœke, ada ɔlɔ á endje za Gbolo nœ uzu ga tshakane aayi kœmbœrœ ekperœ li ye. ");
INSERT INTO mnh_vpl VALUES ("MT26_46","070_26_46","MAT","26","46","46","'E alafo, a na zœ. Ayi kumu mœ á tshe za mœ ga tshakane endje na ye.» ");
INSERT INTO mnh_vpl VALUES ("MT26_47","070_26_47","MAT","26","47","47","Yisu sœpe kœpa o'o kolœnœ atake, Yudasi, anga yambarœ bale lœ andjokpa dœ bisha yi kumu ye. Tshe na awa bale dœ ukpulu azu ndjoro dœ ɨngɨrɨ yakamba œdœ pe ndɨndɨ ɔyɔ tshakane endje. Agbozu tshapa anganga Ndjaba œdœ agbozu Ikrizia dá vwa endje. ");
INSERT INTO mnh_vpl VALUES ("MT26_48","070_26_48","MAT","26","48","48","Uzu á tshe za Yisu ga tshakane endje yi lima œsœ ambárá œrœ adœke: «Uzu á mœ kœ'uru tshelœ utu ye, dá œshe dœmœ; 'e za she.» ");
INSERT INTO mnh_vpl VALUES ("MT26_49","070_26_49","MAT","26","49","49","Trale atake, Yudasi wuta œ na ga ndœ Yisu á pa fœ she adœke: «Abala, Rabi!» Manda nœ, tshe 'uru tshelœ utu ye. ");
INSERT INTO mnh_vpl VALUES ("MT26_50","070_26_50","MAT","26","50","50","Yisu pa fœ she adœke: «Yanga mœ, mbœrœ œrœ á ɓœ gbe dœ tœnœ.» Yé azunœ tepa ye, á za she. ");
INSERT INTO mnh_vpl VALUES ("MT26_51","070_26_51","MAT","26","51","51","Anga bale lœ ugurutœ endje á endje na dœ Yisu gbota ɨngɨrɨ yakamba nœ ye á de anga ayi akwa nœ egerœ nganga Ndjaba, yé á wa utu ye ndja tœnœ. ");
INSERT INTO mnh_vpl VALUES ("MT26_52","070_26_52","MAT","26","52","52","Á Yisu pa fœ she adœke: «Gi ɨngɨrɨ yakamba nœ zœ ga mangbanœ, mbœrœ azu kɔ á endje nga koshe dœ ɨngɨrɨ yakamba, endje tshu kolœ kuzu nœ ɨngɨrɨ yakamba. ");
INSERT INTO mnh_vpl VALUES ("MT26_53","070_26_53","MAT","26","53","53","Ɓœ wuwusœ nœ adœke œdœ mœ kœyɔndœ azu ɓa ndœ Aba mœ, tshe vwa ngɔngɔnœ asœ ukpulu aandjelu kœro pa ndjokpa dœ bisha fœ mœ adœke endje tɨ kane mœ nene a? ");
INSERT INTO mnh_vpl VALUES ("MT26_54","070_26_54","MAT","26","54","54","Kashe, tœ œneke, dœ mara gaɗe dá o'o ala buku nœ Ndjaba li kœmbœrœtœ endje lindœnœ adœke œ sœ ataa.» ");
INSERT INTO mnh_vpl VALUES ("MT26_55","070_26_55","MAT","26","55","55","Dœ ada ɔlɔnœ asœmœ, Yisu pa fœ ukpulu azu adœke: «'E na kœza mœ dœ ɨngɨrɨ yakamba œdœ pe dœ ndɨndɨ ɔyɔ, ɓata œmœ kœdœ ayi angba a? Ɔlɔ dœ ɔlɔ, mœ sœ lima kœsœ ga atɨ ɓa lœ Tepelo kœyisœ œrœ, yé 'e zaza lima mœ nene. ");
INSERT INTO mnh_vpl VALUES ("MT26_56","070_26_56","MAT","26","56","56","Kashe œneke kɔ wuta mbœrœ á o'o aayi kœgbara o'o pa lima kœmbœrœtœ endje.» Yé, ayambarœ kɔ katœ ye tɨ, œ kpa ye. ");
INSERT INTO mnh_vpl VALUES ("MT26_57","070_26_57","MAT","26","57","57","Endje á endje za lima Yisu, gu dœ she ɓa ndœ Kayifa, egerœ nganga Ndjaba á aayi kœyisœ awa akwa œdœ ndje dœ agbozu Ikrizia ngbɔtœ endje ɓa ndœ ye. ");
INSERT INTO mnh_vpl VALUES ("MT26_58","070_26_58","MAT","26","58","58","Petro sœ lima kœna manda Yisu yima yima lœ ɨngɨrɨnœ œrrr ɓa lœ gbagba nœ egerœ nganga Ndjaba. Tshe li ga zœ œ sœ ga ɨndɨrɨ aayi akwa ndœ kœwu mara á o'onœ œ ka dœ tœnœ. ");
INSERT INTO mnh_vpl VALUES ("MT26_59","070_26_59","MAT","26","59","59","Andaa, agbozu tshapa anganga Ndjaba dœ pe aayi kœwa ngbanga nœ azu nœ Ndjaba kɔ, lœ lima kœpara awa adœke œne gbɔ anga uzu á tshe kœpa anga ekpe o'o goro œsœ Yisu yeka á œne kœgbɔ awa kœwa ngbanga nœ kuzu ga tœ ye. ");
INSERT INTO mnh_vpl VALUES ("MT26_60","070_26_60","MAT","26","60","60","Kashe ataa aayi kœpa ekpe o'onœ ma lima tœ endje ndjoro gbaa, endje gbɔgbɔ œrœ bale nene. Kwata œrrr, anga endje bisha matœ endje ");
INSERT INTO mnh_vpl VALUES ("MT26_61","070_26_61","MAT","26","61","61","yé œ pa adœke: «Uzunœ asœ pa adœke: “Mœ li kœndɨ tshelœ Tepelo nœ Ndjaba yé œ mɔ ga mangbanœ manda olo votɔ.”» ");
INSERT INTO mnh_vpl VALUES ("MT26_62","070_26_62","MAT","26","62","62","Egerœ nganga Ndjaba álafo œ pa fœ she adœke: «Ɓœ gugu dœ o'o kœgi tœnœ tœ œneke kɔ á azu asœ pa ga pa zœ nene a?» ");
INSERT INTO mnh_vpl VALUES ("MT26_63","070_26_63","MAT","26","63","63","Kashe Yisu sœ lima kokoko. Yé egerœ nganga Ndjabanœ kœyu she adœke: «Mœ sœ kœyu ɓœ, ɓœ dara ama zœ dœ ɨ'ɨrɨ Ndjaba nœ soro: Œɓœ kœdœ Masiya Gbolo nœ Ndjaba a?» ");
INSERT INTO mnh_vpl VALUES ("MT26_64","070_26_64","MAT","26","64","64","Yisu gi fœ she adœke: «Ɓœ pa dœ tœ zœ ye. Kashe mœ sœ kœpa ngbɨ fœ 'e adœke: Kœto ngɔngɔnœ asœ, 'e wu Gbolo nœ uzu kœsœ ga atɨ ga tœ kuni Ndjaba nœ gbɔgbɔ kɔ; 'e wu ndje she kœjerœ ɓa pa ondoro ɓa lafo.» ");
INSERT INTO mnh_vpl VALUES ("MT26_65","070_26_65","MAT","26","65","65","Yé egerœ nganga Ndjaba suru tshelœ lœba tœ ye œ pa adœke: «Tshe gu œsœ Ndjaba! A kpa gbegbe dœ atimu nene! 'E totœ kœdji kœgu osho á tshe gu tœ Ndjaba ye. ");
INSERT INTO mnh_vpl VALUES ("MT26_66","070_26_66","MAT","26","66","66","'E gbe má œne 'e tœnœ kotoo?» Endje gi adœke: «Tshe li dœ kuzu.» ");
INSERT INTO mnh_vpl VALUES ("MT26_67","070_26_67","MAT","26","67","67","Manda nœ, endje tetœ kœtu ngusha ga tshatshu ye œ sœ kœdu she, yé anga endje sœ kœda ala ye. ");
INSERT INTO mnh_vpl VALUES ("MT26_68","070_26_68","MAT","26","68","68","Endje pa fœ she adœke: «Masiya, œdœ ɓœ kœdœ ayi kœgbara o'o, pandœ nœ fœ 'a: Œɗe dá ɓi ɓœ a?» ");
INSERT INTO mnh_vpl VALUES ("MT26_69","070_26_69","MAT","26","69","69","Andaa Petro sœ lima ga atɨ ɓa ushu ɓa lœ gbagba, anga yashe akwa na ndoo dœ she yé œ pa fœ she adœke: «Œɓœ ndje, ɓœ sœ lima awa bale dœ Yisu uzu Galilayi!» ");
INSERT INTO mnh_vpl VALUES ("MT26_70","070_26_70","MAT","26","70","70","Kashe tshe vusœ nœ utshu azu kɔ dœ kœpa adœke: «Mœ wuwusœ o'onœ á ɓœ yindœ kœpa tœnœ asœ nene.» ");
INSERT INTO mnh_vpl VALUES ("MT26_71","070_26_71","MAT","26","71","71","Ɓata á tshe sœ lima kœna gu ndœ œsœ manda gbagbanœ, anga angbɨ yashe akwa kpa wu she yé œ pa fœ azu á endje sœ lima kpœtœmœ adœke: «Uzu asœ sœ lima awa bale dœ Yisu uzu Nazarete.» ");
INSERT INTO mnh_vpl VALUES ("MT26_72","070_26_72","MAT","26","72","72","Petro kpa vusœ nœ dœ kœdarama ye adœke: «Mœ wuwusœ uzunœ asœke nene.» ");
INSERT INTO mnh_vpl VALUES ("MT26_73","070_26_73","MAT","26","73","73","Manda nœ teasho, azu á endje sœ lima kpœtœmœ gitœ endje ndoo dœ Petro, yé œ pa fœ she adœke: «Adja, œɓœ kœdœ anga uzu nœ endje, yé o'o zœ sœ kœma ɓœ ataa.» ");
INSERT INTO mnh_vpl VALUES ("MT26_74","070_26_74","MAT","26","74","74","Yé Petro tetœ kœdarama ye dœ kœpa o'o adœke: «Kaka Ndjaba za djofele fœ mœ œdœ mœ kœpa wala! Mœ wuwusœ uzunœ asœke nene.» Ngbewo, kɔngato kɨ. ");
INSERT INTO mnh_vpl VALUES ("MT26_75","070_26_75","MAT","26","75","75","Yé Petro gbetshelœ ye ndœ o'onœ á Yisu pa lima fœ she adœke: «Utshunœ adœke kɔngato kɨ, ɓœ 'ea mœ awa votɔ adœke ɓœ wuwusœ mœ nene.» Tshe wuta ga ushu, yé kɨ dœ oyo. ");
INSERT INTO mnh_vpl VALUES ("MT27_1","070_27_1","MAT","27","1","1","Dœ amazɨ tuu, agbozu tshapa anganga Ndjaba kɔ dœ pe agbozu Ikrizia ngbɔtœ endje ga tœnœ kœwa o'o ndœ kœwo Yisu. ");
INSERT INTO mnh_vpl VALUES ("MT27_2","070_27_2","MAT","27","2","2","Manda nœ, endje i Yisu ga tœnœ, œ na dœ she yé á za she fœ gbozugo á ɨ'ɨrɨ ye kœdœ Pilato. ");
INSERT INTO mnh_vpl VALUES ("MT27_3","070_27_3","MAT","27","3","3","Yudasi á tshe za she yɔ œrœ, wu adœke endje wa ngbanga ndœ kœwo Yisu, egerœ gbetshelœ za she, tshe kwa œ gi langere ngendjanœ zazu bale dœ ndjokpa fœ agbozu tshapa anganga Ndjaba dœ pe fœ agbozu Ikrizia, ");
INSERT INTO mnh_vpl VALUES ("MT27_4","070_27_4","MAT","27","4","4","yé á pa fœ endje adœke: «Mœ mbœrœ ekperœ, mœ za uzu á tshe mbœmbœrœ ekperœ nene fœ kuzu.» Kashe endje gi fœ she adœke: «'A sœsœ lœnœ nene! Tœnœ kœdœ o'o nœ zœ!» ");
INSERT INTO mnh_vpl VALUES ("MT27_5","070_27_5","MAT","27","5","5","Yudasi ko ngendjanœ va ga lœ Tepelo, yé á na kœdu uwu ga lœ ɨgɨ ye ndœ kœwotœ ye. ");
INSERT INTO mnh_vpl VALUES ("MT27_6","070_27_6","MAT","27","6","6","Agbozu tshapa anganga Ndjaba rɔ ngendjanœ yé á pa adœke: «Awa akwa nœ azœ yiyindœ nœ adœke a ko mara ngendja ataa ga ugurutœ kœgbɔrœ nœ Tepelo nene, mbœrœ tœnœ á to lœ ngendja indji uzu.» ");
INSERT INTO mnh_vpl VALUES ("MT27_7","070_27_7","MAT","27","7","7","Manda kœdjitœ endje, endje za œ yɔ dœ kɨndɨ nœ ayi kœmbœrœ lɔsú mbœrœ kœza tœ tshapa udu nœ agene. ");
INSERT INTO mnh_vpl VALUES ("MT27_8","070_27_8","MAT","27","8","8","Mbœrœ tœnœ ataa œrrr ga tœ kpesheke, ɨ'ɨrɨ kɨndɨnœ asœmœ kœdœ: «Kɨndɨ indji uzu.» ");
INSERT INTO mnh_vpl VALUES ("MT27_9","070_27_9","MAT","27","9","9","Yé œ mbœrœtœ endje ataa mbœrœ o'o á ayi kœgbara o'o Yilimiya pa lima kœmbœrœtœ endje, tshe pa adœke: «Endje za ngendja zazu bale dœ ndjokpa, œtœnœ kœdœ ama ngendja á agbolo Israyele wa lima tœ upu nœ ye; ");
INSERT INTO mnh_vpl VALUES ("MT27_10","070_27_10","MAT","27","10","10","yeka á endje za ndœ kɨndɨ nœ ayi kœmbœrœ lɔsú, ɓata á Gbozu vwa lima mœ ndœ kœpandœ nœ.» ");
INSERT INTO mnh_vpl VALUES ("MT27_11","070_27_11","MAT","27","11","11","Yisu ka ɓa utshu gbozugo á ɨ'ɨrɨ ye kœdœ Pilato. Gbozugo yu she adœke: «Œɓœ kœdœ gbozugo nœ Ayuda a?» Yisu gi fœ she adœke: «Œɓœ dá sœ kœpa ataa.» ");
INSERT INTO mnh_vpl VALUES ("MT27_12","070_27_12","MAT","27","12","12","Kashe o'o á agbozu tshapa anganga Ndjaba dœ pe agbozu Ikrizia sœ kœpa ga pa ye, tshe gigi lima o'o nene. ");
INSERT INTO mnh_vpl VALUES ("MT27_13","070_27_13","MAT","27","13","13","Pilato pa fœ she adœke: «Ɓœ djidji o'o á endje sœ kœpa ga pa zœ asœ nene a?» ");
INSERT INTO mnh_vpl VALUES ("MT27_14","070_27_14","MAT","27","14","14","Tshe gigi lima o'o ndœ nœ bale nene, yé gbozugo za lima ama ye tɨ ɔsɔ. ");
INSERT INTO mnh_vpl VALUES ("MT27_15","070_27_15","MAT","27","15","15","Dœ lɔndɔ angbo Pake bale dœ bale kɔ, gbozugo sœ lima kœvwara anga ayi kánga bale á ukpulu azu yindœ ye. ");
INSERT INTO mnh_vpl VALUES ("MT27_16","070_27_16","MAT","27","16","16","Andaa, endje sœ lima dœ anga ayi kánga á endje para wu lima sœ ye, ɨ'ɨrɨ ye kœdœ Yisu Barabase. ");
INSERT INTO mnh_vpl VALUES ("MT27_17","070_27_17","MAT","27","17","17","Pilato yu ukpulu azunœ á endje ngbɔtœ endje ga tœnœ adœke: «Œɗe dá 'e yindœ nœ adœke mœ katœ ye a? Yisu Barabase too Yisu á endje e she Kristu?» ");
INSERT INTO mnh_vpl VALUES ("MT27_18","070_27_18","MAT","27","18","18","Mbœrœ tshe wu lima sœ nœ adœke endje sœ dœ úkú ga tœ ye yeka á za she na tœnœ asœmœ. ");
INSERT INTO mnh_vpl VALUES ("MT27_19","070_27_19","MAT","27","19","19","Ɔlɔ á Pilato sœ kœwa ngbanganœ ɓa lœ anda kœwa ngbanga, awonœ pa fœ she adœke: «Lili ga lœ o'o nœ uzunœ asœ nene, tshe sœ ndjii. Mbœrœ mœ lu dœ abutshɔ asœ, lɔsu mœ ka mœ mbœrœ she waa.» ");
INSERT INTO mnh_vpl VALUES ("MT27_20","070_27_20","MAT","27","20","20","Agbozu tshapa anganga Ndjaba dœ pe agbozu Ikrizia sœ kœli ga lœ azu adœke endje katœ Barabase kashe œ wo Yisu. ");
INSERT INTO mnh_vpl VALUES ("MT27_21","070_27_21","MAT","27","21","21","Gbozugo kpa yu endje adœke: «Œɗe ugurutœ endje bisha á 'e yindœ nœ adœke mœ katœ ye fœ 'e a?.» Endje gi adœke: «Barabase.» ");
INSERT INTO mnh_vpl VALUES ("MT27_22","070_27_22","MAT","27","22","22","Pilato yu endje adœke: «Œrœ gaɗe á mœ kœmbœrœ tœ Yisu á endje e she Kristu a?» Endje para gi adœke: «'E kuru she ga pa kurushi.» ");
INSERT INTO mnh_vpl VALUES ("MT27_23","070_27_23","MAT","27","23","23","Pilato yu endje adœke: «Ekperœ gaɗe dá tshe mbœrœ a?» Kashe endje tetœ kœta rawa dœ agbɔ adœke: «'E kuru she ga pa kurushi.» ");
INSERT INTO mnh_vpl VALUES ("MT27_24","070_27_24","MAT","27","24","24","Lɔkɔ á tshe wu adœke œne kpa wusœ œrœ á œne mbœrœ nene, tshe su ungu œ djutɔ dœ kane ye utshu ukpulu azu dœ kœpa adœke: «Mœ dœ́dœ́ ayi kumu upu kuzu ye nene; œtœnœ kœdœ upu nœ 'e.» Gbambanœ nene, azu sœ lima kœoma dœ o'onœ waa. ");
INSERT INTO mnh_vpl VALUES ("MT27_25","070_27_25","MAT","27","25","25","Azu para gi adœke: «Kaka adœke indji ye sœ ga pa 'a dœ agbolo nœ 'a.» ");
INSERT INTO mnh_vpl VALUES ("MT27_26","070_27_26","MAT","27","26","26","Yeka á tshe kœkatœ Barabase, yé manda kœsɔ Yisu dœ ndjapa, tshe za she fœ endje adœke endje kœkuru she ga pa kurushi. ");
INSERT INTO mnh_vpl VALUES ("MT27_27","070_27_27","MAT","27","27","27","Manda nœ aturugu nœ gbozugo gu dœ Yisu ga lœ gbagba nœ ye, yé ukpulu azu kpa dji she djikpata. ");
INSERT INTO mnh_vpl VALUES ("MT27_28","070_27_28","MAT","27","28","28","Endje verœ lœba tœ ye, yé á verœ yɔgbɔdɔ odoro lœba ga tœ ye. ");
INSERT INTO mnh_vpl VALUES ("MT27_29","070_27_29","MAT","27","29","29","Endje verœ kpoto nœ ishi ga tœ kumu ye ɓata gbozugo, endje za tshɔngbɔlɔ ga tœ kuni ye, á tetœ kœgote ga utshu ye dœ pe kœmɔ she adœke: «'A bala ɓœ gbozugo nœ Ayuda.» ");
INSERT INTO mnh_vpl VALUES ("MT27_30","070_27_30","MAT","27","30","30","Endje sœ kœtu ngusha ga tœ ye, œ za tshɔngbɔlɔnœ asœmœ á sɔ dœ kumu ye. ");
INSERT INTO mnh_vpl VALUES ("MT27_31","070_27_31","MAT","27","31","31","Manda kœmɔ she, endje verœ yɔgbɔdɔ lœbanœ tœ ye á gi œne ye ga tœ ye, yé á za she na tœnœ ndœ kœkuru she ga pa kurushi. ");
INSERT INTO mnh_vpl VALUES ("MT27_32","070_27_32","MAT","27","32","32","Ɓata endje sœ lima kœwuta tœnœ, endje gbɔ uzu tshalakpɨ Sirene, á ɨ'ɨrɨ ye kœdœ Shimu, endje vwa she dœ agbɔ ndœ kœza átá kurushi tœ Yisu. ");
INSERT INTO mnh_vpl VALUES ("MT27_33","070_27_33","MAT","27","33","33","Endje wuta ga tœ osho á ɨ'ɨrɨnœ kœdœ Gologota, œ yindœ kœpa adœke «Osho gbayashi kɔrɔ.» ");
INSERT INTO mnh_vpl VALUES ("MT27_34","070_27_34","MAT","27","34","34","Endje sú ipi á endje ngbɔɓa dœ shundɔɗɔ œrœ œ za fœ Yisu adœke tshe ndjo. Tshe dji ɔtshɔnœ kashe tshe yiyi lima ndœ kœndjo tœnœ nene. ");
INSERT INTO mnh_vpl VALUES ("MT27_35","070_27_35","MAT","27","35","35","Endje kuru she ga pa kurushi yé œ ta wuka mbœrœ kœkurutshelœ lœba nœ ye. ");
INSERT INTO mnh_vpl VALUES ("MT27_36","070_27_36","MAT","27","36","36","Manda nœ, endje sœ ga atɨ ɓa zœ mbœrœ kœgbɔndœ ye. ");
INSERT INTO mnh_vpl VALUES ("MT27_37","070_27_37","MAT","27","37","37","Endje su ádá kœwo she ga pa tsheporo maɓaya yé œ za ga pa kumu ye. O'onœ pa adœke: «Uzu asœ kœdœ Yisu, gbozugo nœ Ayuda.» ");
INSERT INTO mnh_vpl VALUES ("MT27_38","070_27_38","MAT","27","38","38","Endje kuru anga aayi angba bisha ga pa kurushi ga ɨndɨrɨ ye; anga ga pa kuni, yé anga ga pa gele ye. ");
INSERT INTO mnh_vpl VALUES ("MT27_39","070_27_39","MAT","27","39","39","Azu á endje sœ lima kœvwanga tœnœ, sœ kœgu she dœ kœmea kumu endje, ");
INSERT INTO mnh_vpl VALUES ("MT27_40","070_27_40","MAT","27","40","40","yé œ sœ lima kœpa adœke: «Œɓœ á ɓœ pa lima adœke ɓœ ndɨ tshelœ Tepelo yé œ kpa mɔ anganœ manda olo votɔ; œdœ ɓœ kœdœ Gbolo nœ Ndjaba, shetœ zœ dœ tœ zœ yé œ jerœ pa kurushi ga atɨ!» ");
INSERT INTO mnh_vpl VALUES ("MT27_41","070_27_41","MAT","27","41","41","Awa bale, agbozu tshapa anganga Ndjaba, aayi kœyisœ awa akwa œdœ pe agbozu Ikrizia sœ lima kœmɔ she yé œ sœ kœpa adœke: ");
INSERT INTO mnh_vpl VALUES ("MT27_42","070_27_42","MAT","27","42","42","«Tshe she lima anga azu, tshe shetœ ye dœ tœ ye! Œshe kœdœ gbozugo nœ Israyele, tshe jerœ ngɔngɔnœ asœ pa kurushi yé a kœyindœ nœ ga ndœ ye. ");
INSERT INTO mnh_vpl VALUES ("MT27_43","070_27_43","MAT","27","43","43","Tshe za lɔsu ye ga pa Ndjaba yé œ pa ngbɨ adœke: “Œmœ kœdœ Gbolo nœ Ndjaba.” Œdœ Ndjaba kœyindœ ye, tshe she she ngɔngɔnœ asœ!» ");
INSERT INTO mnh_vpl VALUES ("MT27_44","070_27_44","MAT","27","44","44","Aayi angba á endje kuru lima endje ga pa kurushi dœ she gu ndje she awa bale dœ mara ataa. ");
INSERT INTO mnh_vpl VALUES ("MT27_45","070_27_45","MAT","27","45","45","Dœ kakpi ɔlɔ, osho bu kporokoto pa ogo djigi œrrr ga tœ ada ɔlɔ votɔ manda kakpi ɔlɔ. ");
INSERT INTO mnh_vpl VALUES ("MT27_46","070_27_46","MAT","27","46","46","Kœwuta ga tœ ada ɔlɔ votɔnœ asœmœ, Yisu ta rawa dœ ɔgbɔ tshama ye adœke: «Eli, Eli, lema sabakatani?» Œ yindœ kœpa adœke: «Ndjaba nœ mœ, Ndjaba nœ mœ, mbœrœ gaɗe á ɓœ katœ mœ tɨ a?» ");
INSERT INTO mnh_vpl VALUES ("MT27_47","070_27_47","MAT","27","47","47","Anga azu ugurutœ endjeneke á endje sœ lima kpœtœmœ dji she yé œ pa adœke: «'E dji ka, tshe sœ kœ'e Eliya!» ");
INSERT INTO mnh_vpl VALUES ("MT27_48","070_27_48","MAT","27","48","48","Trale, anga uzu bale ugurutœ endje kpa œ nduru ndɔhɔrɔ ga la ikpi vinu yé œ vwele ga tœ kumu wara yeka á yi ga tœ ama ye adœke tshe ndjo. ");
INSERT INTO mnh_vpl VALUES ("MT27_49","070_27_49","MAT","27","49","49","Anga endje pa adœke: «'E kaka kane! A wu œdœ Eliya œ na kœshe she!» ");
INSERT INTO mnh_vpl VALUES ("MT27_50","070_27_50","MAT","27","50","50","Kashe Yisu kpa ta rawa dœ ɔgbɔ tshama ye, yé œ tshu ye. ");
INSERT INTO mnh_vpl VALUES ("MT27_51","070_27_51","MAT","27","51","51","Dœ lɔndɔnœ asœmœ, lœba á endje du ɓa lœ Tepelo suru tshelœtœ ye bisha kœto ɓa lafo œrrr ga atɨ. Ɔshɔ turu, tshelœ ogboro badja 'oro, ");
INSERT INTO mnh_vpl VALUES ("MT27_52","070_27_52","MAT","27","52","52","udu kɔrɔ, yé ayindœ Ndjaba ndjoro á endje tshu, kwatœ endje ga lœ soro. ");
INSERT INTO mnh_vpl VALUES ("MT27_53","070_27_53","MAT","27","53","53","Manda Ndjaba kœshe Yisu lœ akuzu, manda kœwuta endje lœ udu, endje li ga lœ œyerœ ongbo Yerusaleme, yé á azu ndjoro wu endje ɓa zœ. ");
INSERT INTO mnh_vpl VALUES ("MT27_54","070_27_54","MAT","27","54","54","Gbozu tshapa aturugu Roma œdœ aturugu á endje sœ kœgbɔ lima ndœ Yisu dœ she, wu ɔshɔ á turu œdœ œneke kɔ á wuta lima asœmœ, awa za endje tɔpanœ kpuru yé endje pa adœke: «Uzu asœke kœdœ lima adja Gbolo nœ Ndjaba tako.» ");
INSERT INTO mnh_vpl VALUES ("MT27_55","070_27_55","MAT","27","55","55","Ayashe ndjoro ka lima zara á sœ kœtondœ osho: Endje te lima mangba Yisu kœto ɓa lœ Galilayi mbœrœ kœmbœrœ akwa fœ she. ");
INSERT INTO mnh_vpl VALUES ("MT27_56","070_27_56","MAT","27","56","56","Mareya uzu tshalakpɨ Magadala, dœ Mareya ayi Jake dœ Yozefu, œdœ pe ayi agbolo nœ Zebedayi, sœ lima ugurutœ endje. ");
INSERT INTO mnh_vpl VALUES ("MT27_57","070_27_57","MAT","27","57","57","Dœ adɨla, anga ayi kœgbɔrœ ɓa lœ Arimateyo á ɨ'ɨrɨ ye kœdœ Yozefu yikumu ye; œshe kœdœ ndje lima yambarœ nœ Yisu. ");
INSERT INTO mnh_vpl VALUES ("MT27_58","070_27_58","MAT","27","58","58","Tshe na ga ndœ Pilato yé œ yu she tœ oko Yisu. Yé Pilato za awa adœke endje za fœ she. ");
INSERT INTO mnh_vpl VALUES ("MT27_59","070_27_59","MAT","27","59","59","Yozefu za oko Yisu œ vwele ga tœnœ dœ ɔtshɔ lœba, ");
INSERT INTO mnh_vpl VALUES ("MT27_60","070_27_60","MAT","27","60","60","yé á za ga lœ tafo udu á tshe totœ kœdji tœnœ ɓa lœ ɔngɔ badja. Manda nœ, tshe vwɨrɨ egerœ badja ga tœ mandanœ yé œ gu da ye. ");
INSERT INTO mnh_vpl VALUES ("MT27_61","070_27_61","MAT","27","61","61","Andaa, Mareya uzu Magadala œdœ anga angbɨ Mareyanœ sœ lima ga atɨ ɓa utshu udunœ. ");
INSERT INTO mnh_vpl VALUES ("MT27_62","070_27_62","MAT","27","62","62","Olo bale manda nœ, tœnœ kœdœ lima lɔkɔ utshu sabata, agbozu tshapa anganga Ndjaba dœ pe Afarisayi na awa bale ga ndœ Pilato. ");
INSERT INTO mnh_vpl VALUES ("MT27_63","070_27_63","MAT","27","63","63","Endje pa fœ she adœke: «Gbozu, 'a gbe dœ o'o á ayi wala asœ pa lima lɔkɔ á tshe sœpe dœ soro. Tshe pa lima adœke: “Manda olo votɔ, Ndjaba œ she mœ lœ akuzu ye.” ");
INSERT INTO mnh_vpl VALUES ("MT27_64","070_27_64","MAT","27","64","64","Za awa adœke endje gbɔndœ tshapa udu asœ œrrr ga tœ votɔ olo yekane, ete nene ayambarœ nœ ye œ zɨ angba ye, yé œ pa fœ azu adœke: “Ndjaba she lœ akuzu ye.” Yé walanœ asœ œ kpa ropa œneke lima utshunœ ye.» ");
INSERT INTO mnh_vpl VALUES ("MT27_65","070_27_65","MAT","27","65","65","Pilato kœpa fœ endje adœke: «Aturugu kœgbɔndœ œrœ dœke. 'E na dœ endje dœ́ endje gbɔndœ tshapa udunœ ɓata á 'e wa asœmœ.» ");
INSERT INTO mnh_vpl VALUES ("MT27_66","070_27_66","MAT","27","66","66","Ataa, endje na ga pa udu œ guma mara kœgbɔndœ nœ: Endje ɨvwɨ badjanœ œ tshu dœ mandanœ yé á katœ aturugu ndœ kœgbɔndœ nœ. ");
INSERT INTO mnh_vpl VALUES ("MT28_1","070_28_1","MAT","28","1","1","Manda olo sabata, kœli ga lœ ali olo nœ pɔsɔ, Mareya uzu Magadala dœ pe anga angbɨ Mareyanœ na kœwu tshapa udu. ");
INSERT INTO mnh_vpl VALUES ("MT28_2","070_28_2","MAT","28","2","2","Trale atake, ɔshɔ turu dœ agbɔnœ. Anga andjelu nœ Gbozu to ɓa lafo œ jerœ, œ vwɨrɨ egerœ badja tœ manda udunœ yé á sœ ga pa nœ. ");
INSERT INTO mnh_vpl VALUES ("MT28_3","070_28_3","MAT","28","3","3","Tshe sœ lima ɓata kœyerœwa yavuru, yé lœba ye sœ dœ imbinœ ɓata ondoro. ");
INSERT INTO mnh_vpl VALUES ("MT28_4","070_28_4","MAT","28","4","4","Aturugu sœ lima kœde gbaragbara dœ awa, yé œ sœ ɓata azu á endje tshu ye. ");
INSERT INTO mnh_vpl VALUES ("MT28_5","070_28_5","MAT","28","5","5","Kashe andjelu za o'o yé œ pa fœ ayashenœ adœke: «Awa zaza 'e nene, mœ wusœ nœ adœke 'e sœ kœpara Yisu á endje kuru she ga pa kurushi. ");
INSERT INTO mnh_vpl VALUES ("MT28_6","070_28_6","MAT","28","6","6","Tshe gugu kpeke nene, mbœrœ Ndjaba she she lœ akuzu ɓata á tshe pandœ nœ lima fœ 'e. 'E na ga mœ œ wu osho á tshe lo lima tœnœ. ");
INSERT INTO mnh_vpl VALUES ("MT28_7","070_28_7","MAT","28","7","7","Yé 'e gu katsha œ pandœ nœ fœ ayambarœ nœ ye adœke: “Ndjaba shé she lœ akuzu ye, yé tshe ro utshu 'e ga lœ Galilayi da ye; 'e wu she ɓa zœ.” Œtœnœ dá mœ pandœ nœ fœ 'e asœmœ.» ");
INSERT INTO mnh_vpl VALUES ("MT28_8","070_28_8","MAT","28","8","8","Endje katœ tshapa udu tɨ dœ awa œdœ pe dœ yanga, œ kpagu kœpandœ nœ fœ ayambarœ nœ ye. ");
INSERT INTO mnh_vpl VALUES ("MT28_9","070_28_9","MAT","28","9","9","Trale, endje wu Yisu kœna ga ndœ endje, á pa fœ endje adœke: «Mœ bala 'e!» Endje gitœ endje ndoo ga ndœ ye, œ tepa ada ye yé á gote ga utshu ye. ");
INSERT INTO mnh_vpl VALUES ("MT28_10","070_28_10","MAT","28","10","10","Yé Yisu pa fœ endje adœke: «Awa zaza 'e bale nene. 'E gu œ pandœ nœ fœ aaya mœ adœke endje ro ga lœ Galilayi: ɓa zœ dá endje wu mœ.» ");
INSERT INTO mnh_vpl VALUES ("MT28_11","070_28_11","MAT","28","11","11","Lɔkɔ á endje sœpe lima tœ ala awa, anga aturugu lœ ugurutœ aturugu kœgbɔndœ udu ro ga lœ ongbo, œ pandœ œrœ kɔ á ro ɓa zœ fœ agbozu tshapa anganga Ndjaba. ");
INSERT INTO mnh_vpl VALUES ("MT28_12","070_28_12","MAT","28","12","12","Manda kœngbɔtœ dœ kœdjitœ agbozu nganga Ndjaba dœ pe agbozu Ikrizia, endje to ngendja dœ egerœ nœ fœ aturugu, ");
INSERT INTO mnh_vpl VALUES ("MT28_13","070_28_13","MAT","28","13","13","yé œ pa fœ endje adœke: «'E pa ngbɨ adœke: Lɔkɔ á 'e sœ tœ olo, ayambarœ nœ ye na dœ butshɔ œ za angba oko ye yé. ");
INSERT INTO mnh_vpl VALUES ("MT28_14","070_28_14","MAT","28","14","14","Yé œdœ gbozugo kœdji o'onœ asœ, a'a dá ru alanœ yé á mbœrœ adœke 'e gbɔgbɔ o'o nene.» ");
INSERT INTO mnh_vpl VALUES ("MT28_15","070_28_15","MAT","28","15","15","Aturugu za ngendjanœ yé œ tetœ kœmbœrœtœ endje lindœ o'onœ á endje za fœ endje asœmœ. Ataa, o'onœ asœ kaka osho ɓa ndœ Ayuda œrrr ga tœ kpesheke. ");
INSERT INTO mnh_vpl VALUES ("MT28_16","070_28_16","MAT","28","16","16","Ayambarœ nœ ye ndjokpa dœ bale na ga lœ Galilayi ɓa pa kaga á Yisu yi lima sœ nœ fœ endje. ");
INSERT INTO mnh_vpl VALUES ("MT28_17","070_28_17","MAT","28","17","17","Lɔkɔ á endje wu lima she, endje gote ga utshu ye; kashe anga endje ugurutœ endje sœ lima dœ sharapu. ");
INSERT INTO mnh_vpl VALUES ("MT28_18","070_28_18","MAT","28","18","18","Yisu na ndoo dœ endje, œ pa fœ endje adœke: «Ndjaba za tshagbozu kɔ nœ œrœ tshalafo dœ pe œnœ tshapa shɔ fœ mœ. ");
INSERT INTO mnh_vpl VALUES ("MT28_19","070_28_19","MAT","28","19","19","'E na djelœ ogo kɔ, 'e fa azu tœ ayambarœ nœ mœ, yé œ za batisimu fœ endje dœ ɨ'ɨrɨ Aba, dœ Gbolo dœ pe Ɔtshɔ ɨshirɨ, ");
INSERT INTO mnh_vpl VALUES ("MT28_20","070_28_20","MAT","28","20","20","'e yisœ nœ fœ endje adœke endje gbɔndœ œneke kɔ á mœ za lima dœ o'o fœ 'e. Yé œmœ, mœ sœ dœ 'e awa bale ɔlɔ dœ ɔlɔ œrrr ga tœ kœka tshapashɔ.»");
INSERT INTO mnh_vpl VALUES ("AC1_1","074_1_1","ACT","1","1","1","Gbozu Teofile, ɓa la ali mbeti á mœ su fœ ɓœ, mœ pandœ œrœ kɔ á Yisu mbœrœ lima œdœ pe ndje œneke kɔ á tshe yi lima sœ nœ kœto ɓa tœ adanœ ");
INSERT INTO mnh_vpl VALUES ("AC1_2","074_1_2","ACT","1","2","2","œrrr ga tœ olo kœɔ she lima ga lafo. Utshu kœɔ she, tshe za o'o fœ aayi avwa nœ ye dœ gbɔgbɔ nœ Ɔtshɔ Ɨshirɨ. ");
INSERT INTO mnh_vpl VALUES ("AC1_3","074_1_3","ACT","1","3","3","Tshe ma lima tœ ye fœ endje manda kuzu á tshe tshu tœ kœma fœ endje adœke tshe sœ dœ soro. Tshe ma lima tœ ye fœ endje yé œ tetœ kœpa o'o tœ upu nœ Ogo gbozu nœ Ndjaba manda olo zazu bisha. ");
INSERT INTO mnh_vpl VALUES ("AC1_4","074_1_4","ACT","1","4","4","Anga lɔkɔ bale á tshe sœ lima kœzɨ œrœ dœ endje, tshe za o'o fœ endje adœke: «'E gigi damba tœ 'e lœ Yerusaleme nene kashe 'e kate œneke á Aba pa lima ndœ nœ adœke œne za fœ 'e ɓata á 'e dji lima lœ ama mœ. ");
INSERT INTO mnh_vpl VALUES ("AC1_5","074_1_5","ACT","1","5","5","Gbambanœ nene, Yowane za lima batisimu nœ ungu, kashe lœ ondonœ asœke, Ndjaba œ za batisimu nœ Ɔtshɔ Ɨshirɨ fœ 'e.» ");
INSERT INTO mnh_vpl VALUES ("AC1_6","074_1_6","ACT","1","6","6","Aayi avwanœ á endje ngbɔɓa lima tœ endje, yu Yisu adœke: «Gbozu, kolœ ngɔngɔnœ asœke dá ɓœ gi tshagbozu nœ ogo Israyele a?» ");
INSERT INTO mnh_vpl VALUES ("AC1_7","074_1_7","ACT","1","7","7","Tshe kœpa fœ endje adœke: «O'o nœ 'e gugu mbœrœ kœwusœ ada ɔlɔnœ too olonœ á Aba za lœ tshagbozu nœ ye nene. ");
INSERT INTO mnh_vpl VALUES ("AC1_8","074_1_8","ACT","1","8","8","Kashe Ɔtshɔ Ɨshirɨ œ jerœ ga pa 'e, yé 'e gbɔ gbɔgbɔ mbœrœ kœna kœmɨndœ o'o nœ mœ lœ Yerusaleme, lœ ogo Yuda œdœ lœ Samariya djigi œrrr vesho ga tœ osho kɔ pa ɔshɔ.» ");
INSERT INTO mnh_vpl VALUES ("AC1_9","074_1_9","ACT","1","9","9","Manda kœgi o'onœ ataa, tshe ɔ ngarrr dœ ala endje ga lafo yé œ yiwa lœ ondoro tœ ala endje. ");
INSERT INTO mnh_vpl VALUES ("AC1_10","074_1_10","ACT","1","10","10","Ɓata á endje sœpe lima kœmesho ɨrɨrrr ga lafo, anga azu bisha dœ imbi lœba á endje ka lima ndoo dœ endje ");
INSERT INTO mnh_vpl VALUES ("AC1_11","074_1_11","ACT","1","11","11","kœpa fœ endje adœke: «Azu Galilayi, mbœrœ gaɗe á 'e sœpe kœmesho ga lafo a? Yisunœ á tshe ɔ dœ ala 'e asœmœ, tshe kwa ndje bala tœ ye ɓata á 'e wu she kœɔ tœnœ ga lafo asœmœ.» ");
INSERT INTO mnh_vpl VALUES ("AC1_12","074_1_12","ACT","1","12","12","Manda nœ, aayi avwanœ to ɓa pa kaga ɔyɔ Olive yé œ jerœ ga lœ Yerusaleme; kaganœ sœ lima ga pa œrœ nœ́ Kelometere bale tœ Yerusaleme. ");
INSERT INTO mnh_vpl VALUES ("AC1_13","074_1_13","ACT","1","13","13","Lɔkɔ á endje wuta, endje li ga lœ gbɔshɔ á endje lœ lima kœlo lœ nœ ɓa lafo. Œ dœ lima Petro, Yowane, Jake dœ Andere; Filipo dœ Toma; Bartelemi dœ Matie; Jake gbolo nœ Alefe, Shimu uzu kœ'e osho ndœ lipanda œdœ pe Yudasi gbolo nœ Jake. ");
INSERT INTO mnh_vpl VALUES ("AC1_14","074_1_14","ACT","1","14","14","Endje kɔ, endje sœ lima dœ gbetshelœ bale, yé œ ngbɔɓatœ endje mbœrœ kœkɨ fœ Ndjaba ɔlɔ dœ ɔlɔ awa bale dœ anga ayashe ɓata Mareya á tshe zu Yisu œdœ pe ndje aaya Yisu. ");
INSERT INTO mnh_vpl VALUES ("AC1_15","074_1_15","ACT","1","15","15","Lœ anga olonœ asœmœ bale, Petro áalafo ɓa ugurutœ ayindœ Yisu kama bale dœ zazu bale á endje ngbɔɓa lima tœ endje, yé œ pa ngbɨ adœke: ");
INSERT INTO mnh_vpl VALUES ("AC1_16","074_1_16","ACT","1","16","16","«Aaya, œ li adœke o'o á Ɔtshɔ Ɨshirɨ pa lima ndœ nœ ala Buku nœ Ndjaba, lœ ama gbozu Davidi tœ upu nœ Yudasi á tshe to lima azu na tœnœ ndœ kœza Yisu, mbœrœtœ endje. ");
INSERT INTO mnh_vpl VALUES ("AC1_17","074_1_17","ACT","1","17","17","Andaa Yudasi sœ lima awa bale dœ 'a yé tshe sœ lima ndje dœ akwa nœ ye. ");
INSERT INTO mnh_vpl VALUES ("AC1_18","074_1_18","ACT","1","18","18","Uzunœ asœmœ yɔ lima kɨndɨ dœ ngendja á endje ko lima fœ she manda ekperœ nœ ye. Tshe te lima dœ kumu ye, uvu ye de wuruu yé sheta ye yaranga ga atɨ. ");
INSERT INTO mnh_vpl VALUES ("AC1_19","074_1_19","ACT","1","19","19","Azu lœ Yerusaleme kɔ wusœ o'o asœke. Ádánœ á endje e ɨ'ɨrɨ kɨndɨnœ dœ o'o ama ogo endje adœke: Hakeldama, œ yindœ kœpa adœke “ɔshɔ indji”. ");
INSERT INTO mnh_vpl VALUES ("AC1_20","074_1_20","ACT","1","20","20","Yé endje sú ala mbeti nœ Itshi adœke: “Tshelœ gbagba nœ ye œ fa gusu yé uzu bale œ sœ lœ nœ nene.” Yé ga pa nœ dœmœ: “Anga angbɨ uzu œ za akwa nœ ye.” ");
INSERT INTO mnh_vpl VALUES ("AC1_21","074_1_21","ACT","1","21","21","A sœ dœ anga azu á endje na lima tœ awa dœ 'a dœ lɔkɔ á Gbozu Yisu sœ lima pa 'a, ");
INSERT INTO mnh_vpl VALUES ("AC1_22","074_1_22","ACT","1","22","22","kœto kpœpa batisimu nœ Yowane œrrr ga tœ olo kœɔ she ga lafo. Œ li adœke anga uzu bale ugurutœ endje, te timu awa bale dœ 'a ndœ kœmɨndœ kœshe nœ ye ugurutœ akuzu.» ");
INSERT INTO mnh_vpl VALUES ("AC1_23","074_1_23","ACT","1","23","23","Endje yisœ azu bisha: Yozefu á endje e she Barsabase á endje donga ndje she dœ ɨ'ɨrɨ Yustushe œdœ pe Matiase. ");
INSERT INTO mnh_vpl VALUES ("AC1_24","074_1_24","ACT","1","24","24","Yé manda nœ endje za avwala nœ endje para kɔkɔ adœke: «Œɓœ, Gbozu á ɓœ wusœ lɔsu uzu kɔ. Yisœ uzu tsheneke á ɓœ ke she ugurutœ azu bisha asœke ");
INSERT INTO mnh_vpl VALUES ("AC1_25","074_1_25","ACT","1","25","25","adœke tshe mbœrœ akwa nœ aayi avwa lœ kudu Yudasi á tshe katœ nœ tɨ, á na ga tœ osho á li dœ she asœmœ.» ");
INSERT INTO mnh_vpl VALUES ("AC1_26","074_1_26","ACT","1","26","26","Endje ta wuka mbœrœ kœgbɔ uzu bale yé wukanœ te ga pa Matiase. Ádánœ á tshe li ga ugurutœ aayi avwanœ ndjokpa dœ bale dœmœ. ");
INSERT INTO mnh_vpl VALUES ("AC2_1","074_2_1","ACT","2","1","1","Lɔkɔ á olo angbo Patekɔte li, ayindœ Yisu ngbɔɓatœ endje para kɔkɔ ga tœnœ. ");
INSERT INTO mnh_vpl VALUES ("AC2_2","074_2_2","ACT","2","2","2","Trale, ɨngɨrɨ to ɓa lafo ɓata egerœ yugu yé œ su tshelœ anda á endje sœ lima tœnœ djigi. ");
INSERT INTO mnh_vpl VALUES ("AC2_3","074_2_3","ACT","2","3","3","Endje wu œrœ á wuta ga ndœ endje ɓata owo, œ kurutshelœtœ endje á sœ ga pa kumu uzu dœ uzu. ");
INSERT INTO mnh_vpl VALUES ("AC2_4","074_2_4","ACT","2","4","4","Endje para kɔkɔ gbɔ Ɔtshɔ Ɨshirɨ yé œ tetœ kœpa angbɨ o'o ama ogo ɓata á Ɨshirɨ to fœ endje. ");
INSERT INTO mnh_vpl VALUES ("AC2_5","074_2_5","ACT","2","5","5","Anga Ayuda nœ ɔtshɔ lɔsu sœ ndje lima lœ Yerusaleme, endje to lima djelœ ogo kɔ pa ɔshɔ. ");
INSERT INTO mnh_vpl VALUES ("AC2_6","074_2_6","ACT","2","6","6","Ɨngɨrɨ yugunœ za lima osho djigi, yé ukpulu azu ngbɔɓatœ endje œ sœ kœkɨtœ œsœnœ, mbœrœ uzu dœ uzu sœ lima kœdji o'o dœ adja o'o ama ogo ye. ");
INSERT INTO mnh_vpl VALUES ("AC2_7","074_2_7","ACT","2","7","7","Endje kɨtœ œsœnœ, œ sœ dœ yanga yé á pa adœke: «Azunœ asœ para kɔkɔ á endje pa o'o asœ, dœ́dœ́ azu Galilayi nene a? ");
INSERT INTO mnh_vpl VALUES ("AC2_8","074_2_8","ACT","2","8","8","Œ mbœrœ koto á uzu dœ uzu lœ ugurutœ azœ sœ kœdji endje dœ o'o ama ogo ye a? ");
INSERT INTO mnh_vpl VALUES ("AC2_9","074_2_9","ACT","2","9","9","Ugurutœ azœ, a sœ dœ Aparte, Amede dœ Elame, azu ogo Mezopotami, azu ogo Yuda dœ kapadose, azu ogo Ponte dœ Azi, ");
INSERT INTO mnh_vpl VALUES ("AC2_10","074_2_10","ACT","2","10","10","azu ogo Friji dœ Pafili, azu ogo Ezipito dœ azu tshakala ogo Sirene ɓa lœ Libi; anga endje kœdœ endjeneke á endje to lœ Roma, ");
INSERT INTO mnh_vpl VALUES ("AC2_11","074_2_11","ACT","2","11","11","adja Ayudanœ œdœ azu neke á endje wuta aayi kœdonga Ndjaba nœ Ayuda asœmœ; azu ogo Krete dœ endje nœ Arabi. Kashe azœ para kɔkɔ, a dji endje kœpa o'o dœ ama ogo azœ, kœgbara ogboro œrœ á Ndjaba mbœrœ.» ");
INSERT INTO mnh_vpl VALUES ("AC2_12","074_2_12","ACT","2","12","12","Endje kɔkɔ, endje kɨ lima tœ œsœnœ, yé œ yutœ endje adœke: «Œ yindœ kœpa adœke gaɗe dœ mœ a?» ");
INSERT INTO mnh_vpl VALUES ("AC2_13","074_2_13","ACT","2","13","13","Kashe anga azu sœ lima kœmɔ endje adœke: «Ipi dá mbœrœ endje asœmœ.» ");
INSERT INTO mnh_vpl VALUES ("AC2_14","074_2_14","ACT","2","14","14","Yé Petro kœza o'o ugurutœ aayi avwa ndjokpa dœ bale á endje sœ lima tœ œsœnœ, á kœpa dœ ɔgbɔ adœke: «E'e dœ Ayuda œdœ pe 'e dœ azu para kɔkɔ á 'e sœ lœ Yerusaleme kpœke, 'e wusœ œneke á sœ kœrotœ nœ, 'e dara utu 'e yé œ dji mœ dœ ɔtshɔnœ. ");
INSERT INTO mnh_vpl VALUES ("AC2_15","074_2_15","ACT","2","15","15","Wala, azunœ asœke ndjondjo ipi ɓata á 'e sœ kœgbe tœnœ asœmœ nene: mbœrœ a sœ damba kolœ dœ ada ɔlɔ mindu dœ vana gbambanœ. ");
INSERT INTO mnh_vpl VALUES ("AC2_16","074_2_16","ACT","2","16","16","Kashe œneke á sœ kœmatœ endje ngɔngɔ asœke kœdœ o'o á ayi kœgbara o'o Jowele pa lima. Tshe gbara lima adœke: ");
INSERT INTO mnh_vpl VALUES ("AC2_17","074_2_17","ACT","2","17","17","“Ndjaba pa adœke: Lɔkɔ kœka tshapashɔ, mœ vwa Ɨshirɨ nœ mœ ga pa azu kɔ, agbolo yakoshe œdœ pe ayawuru nœ 'e œ te aayi kœgbara o'o, alanga nœ 'e œ wu bala œrœ lœ ulu, ayagbozu nœ 'e œ wu ndje bala œrœ lœ ulu. ");
INSERT INTO mnh_vpl VALUES ("AC2_18","074_2_18","ACT","2","18","18","Adjapu, ɔlɔnœ asœmœ mœ vwa Ɨshirɨ nœ mœ ga pa aayi akwa nœ mœ dœ ayakoshe œdœ pe ayashe, yé endje te bala aayi kœgbara o'o. ");
INSERT INTO mnh_vpl VALUES ("AC2_19","074_2_19","ACT","2","19","19","Mœ mbœrœ bala ogboro œrœ ɓa lafo, yé œ ma ambara afá ɓa pa ɔshɔ ɓa ke: indji œ tu, owo œ tshi yé ngawo œ da. ");
INSERT INTO mnh_vpl VALUES ("AC2_20","074_2_20","ACT","2","20","20","Ɔlɔ œ fa butshɔ, yé yapu œ sœ ɓata indji, utshunœ adœke olo kœna Gbozu li, egerœ olo œdœ olo nœ mokɔ. ");
INSERT INTO mnh_vpl VALUES ("AC2_21","074_2_21","ACT","2","21","21","Yé uzu kɔ á tshe kɨ dœ ɨ'ɨrɨ Gbozu, tshe she.” ");
INSERT INTO mnh_vpl VALUES ("AC2_22","074_2_22","ACT","2","22","22","«Azu tshelœ Israyele, 'e dji o'o mœ: Yisu, uzu tshœlœ Nazarete kœdœ lima uzu á Ndjaba ma gbɔgbɔ nœ ye fœ 'e lœ ye dœ awa nœ kœmbœrœ afá, ogboro œrœ œdœ kœma ambárá œrœ ɓa ugurutœ 'e ɓata á 'e wusœ nœ dœ tœ'e. ");
INSERT INTO mnh_vpl VALUES ("AC2_23","074_2_23","ACT","2","23","23","Uzunœ asœmœ, 'e za lima she ga tshaabrœ azu á endje wuwusœ Ndjaba nene, yekane á endje wo she á kuru she ga pa kurushi lindœ agbe nœ Ndjaba á tshe guma. ");
INSERT INTO mnh_vpl VALUES ("AC2_24","074_2_24","ACT","2","24","24","Kashe Ndjaba she she, yé œ gbota she lœ kanga nœ kuzu mbœrœ œ lili adœke kuzu ropa ye dœ gbɔgbɔ nene. ");
INSERT INTO mnh_vpl VALUES ("AC2_25","074_2_25","ACT","2","25","25","Davidi pa lima o'o tœ upu nœ ye adœke: “Ɔlɔ dœ ɔlɔ mœ sœ kœwu Gbozu utshu mœ, mbœrœ á tshe sœ ga tœ kuni mœ adja awa œ za mœ bale nene. ");
INSERT INTO mnh_vpl VALUES ("AC2_26","074_2_26","ACT","2","26","26","Mbœrœ tœnœ ataa, lɔsu mœ su dœ yanga yé ama mœ œ ɓi ndje itshi dœ yanga. Ga pa nœ kɔ, undu mœ œ yatœ ye lœ kœsœ gee mbœrœ á mœ za lɔsu mœ ga tœ zœ. ");
INSERT INTO mnh_vpl VALUES ("AC2_27","074_2_27","ACT","2","27","27","Gbambanœ nene, Gbozu, ɓœ katœ mœ tɨ lœ ogo nœ akuzu nene, ɓœ yi ndje ndœ nœ adœke œmœ dœ́ œyerœ uzu nœ zœ mœ fu lœ koto akuzu nene. ");
INSERT INTO mnh_vpl VALUES ("AC2_28","074_2_28","ACT","2","28","28","Ɓœ yi lima sœ awa soro fœ mœ, lɔsu mœ œ su dœ yanga mbœrœ kœsœ awa bale dœ ɓœ.” ");
INSERT INTO mnh_vpl VALUES ("AC2_29","074_2_29","ACT","2","29","29","«Aaya, œ li adœke mœ pa o'ara fœ 'e tœ upu nœ ata azœ dœ Davidi: tshe tshu lima, endje shi she yé tshapa udu ye sœpe damba œrrr kpesheke ndœ azœ. ");
INSERT INTO mnh_vpl VALUES ("AC2_30","074_2_30","ACT","2","30","30","Kashe œshe kœdœ lima ayi kœgbara o'o, yé tshe wusœ nœ adœke Ndjaba dara lima ama ye adœke anga gbolo tshelœ ye œ te gbozu manda ye. ");
INSERT INTO mnh_vpl VALUES ("AC2_31","074_2_31","ACT","2","31","31","Davidi wu lima sœ œrœ á yindœ kœwuta bala tœnœ, yé tshe gbara lima o'o kœshe nœ Masiya. Tœnœ dá tshe pa lima adœke: “Tshe sœsœpe lima lœ ogo nœ akuzu nene, yé tshe fufu lima nene.” ");
INSERT INTO mnh_vpl VALUES ("AC2_32","074_2_32","ACT","2","32","32","Adja Ndjaba she Yisu lœ akuzu. A'a para kɔkɔ kœdœ atimu nœ o'onœ. ");
INSERT INTO mnh_vpl VALUES ("AC2_33","074_2_33","ACT","2","33","33","Ndjaba za she ɓa tœ kuni ye, œ to Ɔtshɔ Ɨ'ɨrɨ á tshe pa lima tœ ye fœ she á tshe kurutshelœ nœ tœ 'a ɓata á 'e sœ kœwu tœnœ á sœ kœdji tœnœ. ");
INSERT INTO mnh_vpl VALUES ("AC2_34","074_2_34","ACT","2","34","34","Davidi ɔɔ ga lafo nene gbaa, kashe tshe pa adœke: “Gbozu Ndjaba pa fœ Gbozu nœ mœ: sœ ga atɨ ga tœ kuni mœ, ");
INSERT INTO mnh_vpl VALUES ("AC2_35","074_2_35","ACT","2","35","35","œrrr ga tœ lɔkɔ á mœ fa azu á endje yiangba zœ, ga tshada zœ ɓata mbata.” ");
INSERT INTO mnh_vpl VALUES ("AC2_36","074_2_36","ACT","2","36","36","«Azu Israyele, 'e wusœ nœ dœ ɔtshɔnœ adœke: Yisu á 'e kuru she lima ga pa kurushi asœmœ, Ndjaba mbœrœ adœke tshe fa Gbozu, yé œ fa Kristu.» ");
INSERT INTO mnh_vpl VALUES ("AC2_37","074_2_37","ACT","2","37","37","Lɔkɔ á azu dji o'onœ asœmœ ataa, lɔsu endje ka endje, yé endje yu Petro œdœ pe anga udu aayi avwa adœke: «Aaya, 'a mbœrœ gaɗe?» ");
INSERT INTO mnh_vpl VALUES ("AC2_38","074_2_38","ACT","2","38","38","Petro gi fœ endje adœke: «'E fatshalɔsu 'e: uzu dœ uzu gbɔ batisimu dœ ɨ'ɨrɨ Yisu Kristu yeka á Ndjaba kœdjerœndœ ekperœ nœ 'e. Yé Ndjaba œ to Ɔtshɔ Ɨshirɨ fœ 'e. ");
INSERT INTO mnh_vpl VALUES ("AC2_39","074_2_39","ACT","2","39","39","Gbambanœ nene, o'o nœ Ɔtshɔ Ɨshirɨ á Ndjaba pa lima tœnœ, œ sœ mbœrœ e'e dœ agbolo nœ 'e, œdœ ndje pe azu á endje sœ lœ ɨngɨrɨnœ, endjeneke á Gbozu Ndjaba nœ azœ œ 'e bala endje.» ");
INSERT INTO mnh_vpl VALUES ("AC2_40","074_2_40","ACT","2","40","40","Petro kpa pa o'o ndjoro fœ endje. Tshe pa ala o'o kɔ adœke endje yindœ œneke á œne pa, yé œ gbota gbetshelœ nœ endje dœ kœpa adœke: « 'E yindœ soro á Ndjaba za fœ 'e mbœrœ á kœgitœ 'e ugurutœ azu osho asœ á ɔtshɔ endje gaga nene!» ");
INSERT INTO mnh_vpl VALUES ("AC2_41","074_2_41","ACT","2","41","41","Endje neke á endje yi lima ndœ o'o nœ ye, endje gbɔ batisimu. Yé dœ ɔlɔnœ asœmœ, azu ga pa œrœ nœ́ kutu votɔ te lima ga ndœ ukpulu ayindœ Yisu. ");
INSERT INTO mnh_vpl VALUES ("AC2_42","074_2_42","ACT","2","42","42","Endje zatœ endje djigi ga tœ kœyisœrœ nœ aayi avwa yé œ sœ kœngbɔɓatœ endje lœ yazu, œ sœ kœkurutshelœ mapa tœ endje dœ pe kœkɨ fœ Ndjaba kpœtœ œsœnœ awa bale. ");
INSERT INTO mnh_vpl VALUES ("AC2_43","074_2_43","ACT","2","43","43","Awa li lima tœ endje kpa kpa kpa ye: Aayi avwa mbœrœ ogboro œrœ yé œ má ndje ambáránœ. ");
INSERT INTO mnh_vpl VALUES ("AC2_44","074_2_44","ACT","2","44","44","Ayindœ Yisu para kɔkɔ sœ lima kpœtœ œsœnœ bale yé œ ngboɓa œrœ nœ endje kɔ ga tœ nœ bale. ");
INSERT INTO mnh_vpl VALUES ("AC2_45","074_2_45","ACT","2","45","45","Endje ka lima kɨndɨ nœ endje ndje dœ œrœ nœ endje á kurutshelœ ngendjanœ dœ mara adœke uzu dœ uzu gbɔ liaka ogo nœ ye. ");
INSERT INTO mnh_vpl VALUES ("AC2_46","074_2_46","ACT","2","46","46","Endje sœ lima kœngbɔɓatœ endje ɔlɔ dœ ɔlɔ ɓa lœ Tepelo, yé œ sœ lima kœzɨ œrœ kpœtœ œsœnœ bale ɓa lœ anda nœ endje. Endje sœ lima kœzɨ œrœ dœ yanga œdœ ɔtshɔ lɔsu. ");
INSERT INTO mnh_vpl VALUES ("AC2_47","074_2_47","ACT","2","47","47","Endje sœ lima kœdonga Ndjaba, yé azu kɔ yi lima ndœ endje waa. Ɔlɔ dœ ɔlɔ, Gbozu sœ kœyi endjeneke á endje gbɔ kœshe ga ugurutœ azu Ikrizia. ");
INSERT INTO mnh_vpl VALUES ("AC3_1","074_3_1","ACT","3","1","1","Anga kɨdala bale dœ ada ɔlɔ votɔ, Apetro dœ Yowane ro lima kœdonga Ndjaba ɓa lœ Tepelo. ");
INSERT INTO mnh_vpl VALUES ("AC3_2","074_3_2","ACT","3","2","2","Anga yakoshe bale á ada ye tshu tshakudu ye pe lœ gbolo ye sœ lima kœsœ ndoo dœ manda gbagba Tepelo á endje e «Ɔtshɔ Manda». Endje sœ lima kœna dœ she ɔlɔ dœ ɔlɔ ga zœ mbœrœ á tshe kœyɔndœ œrœ tshakane azu á endje sœ kœli ga lœ Tepelonœ. ");
INSERT INTO mnh_vpl VALUES ("AC3_3","074_3_3","ACT","3","3","3","Lɔkɔ á tshe wu Petro œdœ Yowane kœli ga lœ Tepelonœ, tshe yɔndœ œrœ tœ endje. ");
INSERT INTO mnh_vpl VALUES ("AC3_4","074_3_4","ACT","3","4","4","Yé Apetro dœ Yowane tondœ ye, œ pa fœ she adœke: «Tondœ 'a.» ");
INSERT INTO mnh_vpl VALUES ("AC3_5","074_3_5","ACT","3","5","5","Uzunœ tondœ endje dœ gbetshelœ adœke endje to œrœ fœ œne zœ. ");
INSERT INTO mnh_vpl VALUES ("AC3_6","074_3_6","ACT","3","6","6","Á Petro kœpa fœ she adœke: «Mœ gugu dœ ngendja bale nene, kashe œneke á mœ sœ dœ tœnœ, mœ to fœ ɓœ: dœ ɨ'ɨrɨ Yisu Kristu, uzu Nazarete, áalafo œ na ana!» ");
INSERT INTO mnh_vpl VALUES ("AC3_7","074_3_7","ACT","3","7","7","Petro za kuni ye, œ tɨ she ga lafo. Trale, ada ye dœ tshelœ porongato ada ye yɔrɔ tshelœ tœ endje; ");
INSERT INTO mnh_vpl VALUES ("AC3_8","074_3_8","ACT","3","8","8","yé gbɨkɨvwɨgbɨ, tshe áalafo œ tetœ ana. Tshe li awa bale dœ aayi avwa ga lœ Tepelonœ, œ ka, œ i kpitikpiti dœ pe kœdonga Ndjaba. ");
INSERT INTO mnh_vpl VALUES ("AC3_9","074_3_9","ACT","3","9","9","Azu para kɔkɔ sœ lima kœwu she kœna ana œdœ pe kœdonga Ndjaba. ");
INSERT INTO mnh_vpl VALUES ("AC3_10","074_3_10","ACT","3","10","10","Azu tra she tuu, œ pa adœke: «Œ dœ́dœ́ œshe dá sœ kœsœ lima ɓa pa ɔtshɔ manda Tepelo yekane á sœ kœyɔndœ œrœ nene a!» Uvuru endje kpa lima lœ nœ tœ kœwu œrœ á mbœrœtœ endje lima fœ uzunœ á ada ye tshu asœmœ. ");
INSERT INTO mnh_vpl VALUES ("AC3_11","074_3_11","ACT","3","11","11","Ɓata á uzu sœmœ yiyi lima ndœ kœgitœ ye tœ Apetro dœ Yowane nene, azu para do ga lafo œ sœ kœkpa ga ndœ endje ngbɔlɔɔ tshakudu mbarasane á endje e ɨ'ɨrɨnœ adœke mbarasane nœ Salomo. ");
INSERT INTO mnh_vpl VALUES ("AC3_12","074_3_12","ACT","3","12","12","Petro kœwu endje á kœpa adœke: «Azu Israyele, mbœrœ gaɗe á uvuru 'e œ kpa lœ nœ tœ kœshenœ asœke a? Mbœrœ gaɗe dá 'e sœ kœtondœ 'a ɓata gbɔgbɔ nœ 'a dœ tœ 'a too manda Ndjaba á tshe sœ dœ 'a dá mbœrœ adœke á uzunœ asœke na ana a? ");
INSERT INTO mnh_vpl VALUES ("AC3_13","074_3_13","ACT","3","13","13","'E wusœ nœ adœke Ndjaba nœ Abrayamo, Ndjaba nœ Izaka œdœ Yakobo, Ndjaba nœ aata azœ, œshe dá ma mokɔ nœ ayi akwa nœ ye dœ Yisu. E'e dá ka lima she adœke endje wo she; yé ɔlɔ á Pilato yi lima ndœ kœkatœ ye tɨ, 'e vwara lima tœ 'e ye. ");
INSERT INTO mnh_vpl VALUES ("AC3_14","074_3_14","ACT","3","14","14","'E vwaratœ 'e tœ uzu á tshe sœ yerœ, á sœ ndjii, yeka á yu lima Pilato adœke tshe za anga ayi kœwo azu fœ 'e. ");
INSERT INTO mnh_vpl VALUES ("AC3_15","074_3_15","ACT","3","15","15","'E wo lima Gbozu nœ soro, kashe Ndjaba she she ugurutœ akuzu yé 'a kœdœ atimunœ. ");
INSERT INTO mnh_vpl VALUES ("AC3_16","074_3_16","ACT","3","16","16","Ngɔngɔ asœ 'e wu yakoshe asœke. 'E wusœ ye dœ ɔtshɔnœ: ɨ'ɨrɨ Yisu dá she she mbœrœ 'a sœ dœ kœyindœrœ ga ndœ ye. Mbœrœ gbɔgbɔ nœ ɨ'ɨrɨ ye dá tshe wuta dœ ɔtshɔ ɔkɔ ɓata á 'e wu utshu 'e para kɔkɔ asœke. ");
INSERT INTO mnh_vpl VALUES ("AC3_17","074_3_17","ACT","3","17","17","«Kashe aaya, mœ wusœ nœ adœke e'e dœ agbozu nœ 'e, 'e mbœrœ lima atamœ mbœrœ á 'e wuwusœ adja o'o nene. ");
INSERT INTO mnh_vpl VALUES ("AC3_18","074_3_18","ACT","3","18","18","Kashe Ndjaba mbœrœ ndœma ye á tshe pa lima tœnœ lœ ama aayi kœgbara o'o. Tshe pa lima adœke Masiya á tshe na, tshe wu oyo waa. ");
INSERT INTO mnh_vpl VALUES ("AC3_19","074_3_19","ACT","3","19","19","Mbœrœ tœnœ atamœ, aaya, 'e fatshalɔsu 'e dœ́ œ kwa ga ndœ Ndjaba. Œdœ 'e kœmbœrœ ataa, tshe mbœrœ adœke ekperœ nœ 'e yiwa ye. ");
INSERT INTO mnh_vpl VALUES ("AC3_20","074_3_20","ACT","3","20","20","Atamœ ndje, Gbozu Ndjaba œ mbœrœ adœke 'e gbɔ ɔtshɔ olo nœ kœyatœ 'e, yé tshe vwa Masiya á tshe ke lima she utshunœ katshatsha mbœrœ 'e asœmœ, fœ 'e. Œshe kœdœ Yisu. ");
INSERT INTO mnh_vpl VALUES ("AC3_21","074_3_21","ACT","3","21","21","Kashe ngɔngɔ asœke, Yisu Kristu œ sœ ɓa lafo œrrr ga tœ lɔkɔ á œrœ kɔ œ gumatœ ye liaka œneke á Ndjaba pa lima ndœ nœ lœ ama ayerœ aayi kœgbara o'o nœ ye. ");
INSERT INTO mnh_vpl VALUES ("AC3_22","074_3_22","ACT","3","22","22","Moyize pa lima adœke: “Gbozu Ndjaba œ vwa bala ayi kœgbara o'o bale ɓata mœ, tshe dœ anga aya 'e. 'E dji bala œneke kɔ á tshe pa fœ 'e. ");
INSERT INTO mnh_vpl VALUES ("AC3_23","074_3_23","ACT","3","23","23","Azu á endje tshapu kœdji she, endje sœ ugurutœ azu nœ Ndjaba nene yé endje tshu.” ");
INSERT INTO mnh_vpl VALUES ("AC3_24","074_3_24","ACT","3","24","24","Yé aayi kœgbara o'o kɔ, kœto kpœpa Samwele œrrr ga tœ azu á endje sœ angba ye, uzu dœ uzu gbara lima o'o tœ upu nœ lɔkɔnœ asœke. ");
INSERT INTO mnh_vpl VALUES ("AC3_25","074_3_25","ACT","3","25","25","E'e kœdœ agbolo nœ ayi kœgbara o'o, 'e kœdœ ndje agbolo ayo á Ndjaba guma lima dœ aata azœ lɔkɔ á tshe pa lima fœ Abrayamo adœke: “Lœ awa nœ aata zœ, mœ to kane mœ ga pa azu kɔ pa ɔshɔ.” ");
INSERT INTO mnh_vpl VALUES ("AC3_26","074_3_26","ACT","3","26","26","Mbœrœ 'e dá Ndjaba vwa ayi akwa nœ ye utshunœ. Tshe vwa she adœke tshe to kane ye ga pa 'e, yé uzu dœ uzu katœ kœmbœrœ ekperœ.» ");
INSERT INTO mnh_vpl VALUES ("AC4_1","074_4_1","ACT","4","1","1","Lɔkɔ á Apetro dœ Yowane sœpe kœpu o'o, agbozu tshapa anganga Ndjaba, gbozu tshapa aayi kœgbɔndœ Tepelo œdœ Asadukayi, yi lima kumu endje. ");
INSERT INTO mnh_vpl VALUES ("AC4_2","074_4_2","ACT","4","2","2","Endje sœ lima dœ ókó tɔpanœ kpuru kœwu adœke aayi avwa sœmœ bisha sœ kœyisœ œrœ yé œ sœ kœpandœ nœ adœke ɓata á Yisu shé lœ kuzu, azu á endje tshu lima, endje she ndje lœ kuzu. ");
INSERT INTO mnh_vpl VALUES ("AC4_3","074_4_3","ACT","4","3","3","Endje tepa endje, œ ko endje va ga lœ kánga œrrr ga tœ kœkɔrɔ osho mbœrœ ɔlɔ dɨ lima ye. ");
INSERT INTO mnh_vpl VALUES ("AC4_4","074_4_4","ACT","4","4","4","Lœ ugurutœ azu á endje dji lima Ɔtshɔ O'o, azu ndjoro sœ lima dœ kœyindœrœ ga ndœ Yisu, yé ayindœ Yisunœ wuta azu ga pa œrœ nœ́ kutu mindu (5.000) dœ ɔlɔnœ asœmœ. ");
INSERT INTO mnh_vpl VALUES ("AC4_5","074_4_5","ACT","4","5","5","Osho kɔrɔ pa nœ yeka á agbozu tshapa Ayuda, agbozu Ikrizia, aayi kœyisœ awa akwanœ á endje sœ lœ Yerusaleme, ngbɔɓa lima tœ endje. ");
INSERT INTO mnh_vpl VALUES ("AC4_6","074_4_6","ACT","4","6","6","Ana á tshe dœ́ egerœ nganga Ndjaba, dœ Kayifa, dœ Yowane, dœ Alekezandre œdœ pe azu kɔ lœ bɨngɨ nœ agboro anganga Ndjaba dá ngbɔɓa lima tœ endje ɓa zœ. ");
INSERT INTO mnh_vpl VALUES ("AC4_7","074_4_7","ACT","4","7","7","Endje to Apetro dœ Yowane ro tœnœ ga utshu endje, yé endje yu endje adœke: «'E mbœrœ œrœnœ asœke dœ gbɔgbɔ ndje pe dœ ɨ'ɨrɨ ɗe e?» ");
INSERT INTO mnh_vpl VALUES ("AC4_8","074_4_8","ACT","4","8","8","Yé Petro á tshe sœ lima dœ gbɔgbɔ nœ Ɔtshɔ Ɨshirɨ kœpa fœ endje adœke: «Agbozu tshapa azu ogo œdœ agbozu, ");
INSERT INTO mnh_vpl VALUES ("AC4_9","074_4_9","ACT","4","9","9","'a mbœrœ ɔtshɔrœ fœ uzu á ada ye tshu yekane á endje sœ kœyu 'a kpesheke adœke 'a pandœ mara œrœ á 'a mbœrœ á uzunœ asœ she. ");
INSERT INTO mnh_vpl VALUES ("AC4_10","074_4_10","ACT","4","10","10","Ataa œ li adœke e'e kɔkɔ œdœ azu Israyele, 'e wusœ nœ dœ ɔtshɔnœ adœke uzunœ á tshe ka utshu 'e asœke, tshe she mbœrœ ɨ'ɨrɨ Yisu Kristu, uzu Nazarete á 'e kuru lima she ga pa kurushi yeka á Ndjaba she she lœ akuzu. ");
INSERT INTO mnh_vpl VALUES ("AC4_11","074_4_11","ACT","4","11","11","Œshe kœdœ badja á e'e dœ aayi kœmɔ anda za lima vwi'i, tshe fa badja á anda œ shi mbœrœ tœnœ. ");
INSERT INTO mnh_vpl VALUES ("AC4_12","074_4_12","ACT","4","12","12","Azu œ gbɔ kœshe kolœ ɓa ndœ ye. Gbambanœ nene, pa ɔshɔnœ asœke, anga angbɨ ɨ'ɨrɨ á Ndjaba za adœke azu gbɔ kœshe lœ awanœ, gugu nene.» ");
INSERT INTO mnh_vpl VALUES ("AC4_13","074_4_13","ACT","4","13","13","Kœwu adœke Apetro dœ Yowane ka kolœ mbɨmbɨmbɨ ga pa o'o nœ endje, aayi kœwa ngbanga i lima gbandjuru mbœrœ endje kœdœ amba azu á endje wuwusœ œrœ nene. Kashe endje wu ndje lima sœ nœ adœke endje kœdœ azu á endje sœ lima awa bale dœ Yisu. ");
INSERT INTO mnh_vpl VALUES ("AC4_14","074_4_14","ACT","4","14","14","Kashe ɓata á endje sœ lima kœtondœ uzunœ á tshe she, á tshe ka lima utshu endje, awa kœgi o'o tœ endje gugu lima nene. ");
INSERT INTO mnh_vpl VALUES ("AC4_15","074_4_15","ACT","4","15","15","Á endje kœza awa fœ Apetro dœ Yowane kœwuta damba ga shu yé endje kœtetœ kœyutœ endje ugurutœ endje: ");
INSERT INTO mnh_vpl VALUES ("AC4_16","074_4_16","ACT","4","16","16","«A mbœrœ gaɗe tœ azunœ asœke a? Mbœrœ azu para kɔkɔ lœ Yerusaleme wusœ nœ ngbɨ adœke, endje dá mbœrœ afá asœ, yé a shara nene. ");
INSERT INTO mnh_vpl VALUES ("AC4_17","074_4_17","ACT","4","17","17","Kashe œ li adœke a mbœrœ kɔ adœke o'onœ tete lœ utu azu para kɔkɔ nene. A za uvuru endje adœke endje kpa papa o'o bale dœ ɨ'ɨrɨ uzu nœ endje asœmœ nene.» ");
INSERT INTO mnh_vpl VALUES ("AC4_18","074_4_18","ACT","4","18","18","Manda nœ, endje 'e endje, œ pakata endje kœpa o'o œdœ pe kœyisœ œrœ dœ ɨ'ɨrɨ Yisu. ");
INSERT INTO mnh_vpl VALUES ("AC4_19","074_4_19","ACT","4","19","19","Kashe Apetro dœ Yowane gi fœ endje adœke: «Œrœ gaɗe dá sœ ndjii utshu Ndjaba a? 'A dji 'e too 'a dji Ndjaba? 'E wa ngbanganœ dœ tœ 'e kane. ");
INSERT INTO mnh_vpl VALUES ("AC4_20","074_4_20","ACT","4","20","20","Yé tœ a'a nœ 'a, 'a vu ama 'a tœ œrœ á 'a wu dœ ala 'a yé á dji dœ utu 'a nene.» ");
INSERT INTO mnh_vpl VALUES ("AC4_21","074_4_21","ACT","4","21","21","Kœdji o'onœ ataa, aayi kœwa ngbanganœ gbagbara endje œrrr œ katœ endje tɨ. Endje gbɔgbɔ lima awa ndœ kœwa ngbanga ga tœ ɔkɔ endje nene gbambanœ nene, azu para kɔkɔ sœ lima kœdonga Ndjaba mbœrœ œrœnœ á wuta. ");
INSERT INTO mnh_vpl VALUES ("AC4_22","074_4_22","ACT","4","22","22","Yakoshenœ á endje she she lœ awa nœ afá asœmœ, sœ lima dœ ungu kœropa zazu bisha. ");
INSERT INTO mnh_vpl VALUES ("AC4_23","074_4_23","ACT","4","23","23","Apetro dœ Yowane gu ga ndœ anga endje lɔkɔ á aayi kœwa ngbanganœ mɨ lima kane endje tœ endje, œ pandœ neke kɔ á agboro anganga Ndjaba dœ agbɔ Ayuda pa fœ endje. ");
INSERT INTO mnh_vpl VALUES ("AC4_24","074_4_24","ACT","4","24","24","Manda kœdji o'onœ, aka endje para kɔkɔ awa bale, endje za avwala fœ Ndjaba dœ o'onœ atake: «Gbozu Ndjaba, œɓœ dá mbœrœ tshalafo, dœ ɔshɔ, dœ ungu œdœ pe œneke kɔ á sœ lœnœ, ");
INSERT INTO mnh_vpl VALUES ("AC4_25","074_4_25","ACT","4","25","25","œɓœ dá za o'onœ asœke lœ awa nœ Ɔtshɔ Ɨshirɨ ga lœ ama ata 'a dœ Davidi á tshe kœdœ ayi akwa nœ zœ: “Mbœrœ gaɗe á ogo kɔ sœ kœturu tœnœ, yé mbœrœ gaɗe á azu sœ kœvwarandœ kœmbœrœ œrœ kashe œ gugu dœ ádá nene? ");
INSERT INTO mnh_vpl VALUES ("AC4_26","074_4_26","ACT","4","26","26","Agbozu tshapa ɔshɔ gumatœ endje, yé agbozu kuma akwa ngbɔtœ endje mbœrœ kœnga koshe ga tœ Gbozu Ndjaba œdœ pe ga tœ Masiya nœ ye.” ");
INSERT INTO mnh_vpl VALUES ("AC4_27","074_4_27","ACT","4","27","27","Gbamba nœ nene, œtœnœ kœdœ adjapu adœke Aerode dœ Pose Pilato ngbɔɓatœ endje dœ angbɨ azu œdœ pe azu ogo Israyele ɓa lœ ongbonœ asœke mbœrœ kœnga koshe ga tœ Yisu, œyerœ ayi akwa nœ zœ á tshe dœ Masiya nœ zœ. ");
INSERT INTO mnh_vpl VALUES ("AC4_28","074_4_28","ACT","4","28","28","Dœ tœnœ ataa, endje mbœrœ liaka gbetshelœ nœ zœ kɔ á ɓœ za lima dœ gbɔgbɔ œdœ œneke kɔ á ɓœ yi lima ndje ndœ nœ dœ tœ zœ. ");
INSERT INTO mnh_vpl VALUES ("AC4_29","074_4_29","ACT","4","29","29","Yé ngɔngɔ asœke Gbozu, tondœ mara á endje ndanga 'a asœke yé œ to uvuru fœ aayi akwa nœ zœ dœ́ endje mɨndœ o'o ama zœ dœ gbɔgbɔ kɔ. ");
INSERT INTO mnh_vpl VALUES ("AC4_30","074_4_30","ACT","4","30","30","To kane zœ ga pa kumu azu kɔ mbœrœ adœke kœshe azu, ambárá œrœ dœ pe afá, mbœrœtœ endje dœ ɨ'ɨrɨ Yisu á tshe dœ œyerœ ayi akwa nœ zœ.» ");
INSERT INTO mnh_vpl VALUES ("AC4_31","074_4_31","ACT","4","31","31","Manda kœza avwala nœ endje, osho á endje sœ lima tœnœ turu yé endje para kɔkɔ, endje gbɔ Ɔtshɔ Ɨshirɨ œ tetœ kœpandœ Ɔtshɔ O'o dœ gbɔgbɔ. ");
INSERT INTO mnh_vpl VALUES ("AC4_32","074_4_32","ACT","4","32","32","Ukpulu azu á endje fa lima ayindœ Yisu, sœ lima dœ lɔsu œdœ pe dœ gbetshelœ bale. Anga uzu bale pa pa lima adœke œrœ nœ œne sœ pa undu œne dœ tœ œne nene, kashe endje sœ kœngbɔɓa lima kɔ ga tœ œsœnœ bale. ");
INSERT INTO mnh_vpl VALUES ("AC4_33","074_4_33","ACT","4","33","33","Aayi avwa nœ Yisu sœ lima kœmɨndœ o'o kœshe nœ Gbozu Yisu ugurutœ akuzu dœ gbɔgbɔ, yé Ndjaba sœ lima kœza ɔtshɔ lɔsu ye ga pa endje kɔ. ");
INSERT INTO mnh_vpl VALUES ("AC4_34","074_4_34","ACT","4","34","34","Uzu bale dœ́dœ́ lima ayi oyo ugurutœ endje nene. Gbambanœ nene, endjeneke á endje sœ lima dœ kɨndɨ too dœ anda, endje ka lima œ na dœ ngendjanœ, ");
INSERT INTO mnh_vpl VALUES ("AC4_35","074_4_35","ACT","4","35","35","yé œ ko fœ aayi avwa. Lœ kœkurutshelœ nœ, uzu dœ uzu sœ lima kœgbɔ lindœ œneke á li dœ she. ");
INSERT INTO mnh_vpl VALUES ("AC4_36","074_4_36","ACT","4","36","36","Anga uzu bale lœ mara nœ Alevi sœ ndje lima ugurutœ endje. Ɨ'ɨrɨ ye kœdœ Yozefu á endje zu she lakpɨ Shipre. Aayi avwa e ndje lima she Barnabase, œ yindœ kœpa adœke «uzu kœto gbɔgbɔ». ");
INSERT INTO mnh_vpl VALUES ("AC4_37","074_4_37","ACT","4","37","37","Tshe sœ ndje lima dœ kɨndɨ nœ ye, yé œ ka, œ na dœ ngendjanœ yeka á ko fœ aayi avwa. ");
INSERT INTO mnh_vpl VALUES ("AC5_1","074_5_1","ACT","5","1","1","Anga uzu bale á ɨ'ɨrɨ ye kœdœ Anania, dji lima tœ ye dœ awonœ yé œ ka kɨndɨ nœ endje. ");
INSERT INTO mnh_vpl VALUES ("AC5_2","074_5_2","ACT","5","2","2","Manda nœ, endje sœ lima dœ egerœ lɔsu dœ awonœ, yé œ gumasœ tshakala ngendjanœ mbœrœ endje yeka á na dœ udunœ fœ aayi avwa. ");
INSERT INTO mnh_vpl VALUES ("AC5_3","074_5_3","ACT","5","3","3","Kashe Petro pa adœke: «Anania, mbœrœ gaɗe á Satana li ga lɔsu zœ ata a? Ɓœ fara Ɔtshɔ Ɨshirɨ, yé œ gbɔtœ tshakala ngendja kɨndɨ. ");
INSERT INTO mnh_vpl VALUES ("AC5_4","074_5_4","ACT","5","4","4","Ɓœ ka má tœ kœka kɨndɨnœ ye nene a? Too ɓœ kœka, mbœrœ gaɗe ɓœ mbœrœ má œrœ á ɓœ yindœ nœ dœ ngendjanœ nene a? Gbetshelœnœ asœmœ li ga lɔsu zœ koto o? Œ dœ́dœ́ azu dá ɓœ fara endje nene, kashe Ndjaba dá ɓœ fara she asœmœ.» ");
INSERT INTO mnh_vpl VALUES ("AC5_5","074_5_5","ACT","5","5","5","Lɔkɔ á tshe dji o'onœ asœmœ ataa, tshe nɔ vwɨ œ te, œ tshu ye. Awa za azu á endje dji lima o'onœ. ");
INSERT INTO mnh_vpl VALUES ("AC5_6","074_5_6","ACT","5","6","6","Agbolo modo vwele lima she dœ lœba, yé œ na œ shi she ye. ");
INSERT INTO mnh_vpl VALUES ("AC5_7","074_5_7","ACT","5","7","7","Manda ada ɔlɔ votɔ, awonœ wuwusœ œneke á mbœrœtœ endje nene, yé œ li tɔndu tɔndu ga sœnda ga zœ. ");
INSERT INTO mnh_vpl VALUES ("AC5_8","074_5_8","ACT","5","8","8","Petro kœyu she adœke: «Pandœ nœ fœ mœ kane, pa ngendja kɨndɨnœ á 'e ka dœ mœ a?» Tshe kœyindœ nœ adœke: «Adjapu, pa ngendjanœ dœ mœ!» ");
INSERT INTO mnh_vpl VALUES ("AC5_9","074_5_9","ACT","5","9","9","Yé Petro kpa yu she adœke: «Mbœrœ gaɗe á ɓœ djitœ zœ dœ akɔ zœ á fara Ɔtshɔ Ɨshirɨ nœ Gbozu Ndjaba a? Dji kane, azu á endje to tœ kœshi akɔ zœ, endje ka ɓa lœ manda ɓa zœ. Œɓœ ndje awa bale, endje shi ndje ɓœ.» ");
INSERT INTO mnh_vpl VALUES ("AC5_10","074_5_10","ACT","5","10","10","Pe kpœlœ ma ye atake, tshe te ga tœ ada Petro œ tshu ye. Lɔkɔ á agbolo modo li lima, endje wu adœke tshe tshu ye, yé œ za lima she á na á shi ndje she ndoo dœ akɔnœ. ");
INSERT INTO mnh_vpl VALUES ("AC5_11","074_5_11","ACT","5","11","11","Egerœ awa li lima tœ azu Ikrizia œdœ pe azu á endje dji lima ndœ o'onœ asœmœ. ");
INSERT INTO mnh_vpl VALUES ("AC5_12","074_5_12","ACT","5","12","12","Aayi avwa sœ lima kœmbœrœ afá ndjoro, yé œ sœ lima kœma ambáránœ ɓa ugurutœ azu. Ayindœ Yisu sœ lima kœngbɔtœ endje kɔ ɓa tshakudu mbarasane nœ Salomo dœ gbetshelœ bale. ");
INSERT INTO mnh_vpl VALUES ("AC5_13","074_5_13","ACT","5","13","13","Uzu á tshe gugu dœ kœyindœrœ nene œ li kœli ga ndœ endje nene, andaa azu sœ lima kœpandœ ɔtshɔrœ nœ ayindœ Yisu. ");
INSERT INTO mnh_vpl VALUES ("AC5_14","074_5_14","ACT","5","14","14","Ayakoshe dœ pe ayashe ndjoro sœ lima kœfatshalɔsu endje ga ndœ Gbozu, yé œ sœ lima ga ugurutœ ayindœ Yisu asœmœ. ");
INSERT INTO mnh_vpl VALUES ("AC5_15","074_5_15","ACT","5","15","15","Endje sœ lima kœwuta dœ aayi koɓa ga tœ ala awa, yé œ sœ lima kœko endje ga pa kelekpa œdœ ga pa kondja mbœrœ adœke Petro kœsœ kœro tœnœ, á ɨshirɨ ye kœna ga pa anga endje ugurutœ endje. ");
INSERT INTO mnh_vpl VALUES ("AC5_16","074_5_16","ACT","5","16","16","Anga ukpulu azu ogo á sœ mashenga dœ Yerusaleme na ndje lima dœ aayi koɓa œdœ pe azu á ekpe ɨshirɨ sœ pa endje, yé endje she lima para kɔkɔ. ");
INSERT INTO mnh_vpl VALUES ("AC5_17","074_5_17","ACT","5","17","17","Dœ lɔkɔnœ asœmœ, egerœ nganga Ndjaba œdœ endjeneke kɔ á endje sœ ɨndɨrɨ ye, œ yindœ kœpa adœke azu tshelœ ngbɔtœ nœ Asadukayi, endje sœ lima dœ ókó. ");
INSERT INTO mnh_vpl VALUES ("AC5_18","074_5_18","ACT","5","18","18","Endje ko aayi avwa, yé œ vwi endje ga lœ kánga. ");
INSERT INTO mnh_vpl VALUES ("AC5_19","074_5_19","ACT","5","19","19","Kashe dœ butshɔ, andjelu nœ Gbozu kɔrɔ manda kánga yé œ ko endje ga shu, á pa fœ endje adœke: ");
INSERT INTO mnh_vpl VALUES ("AC5_20","074_5_20","ACT","5","20","20","«'E na œ sœ ɓa lœ Tepelo. Yé ɓa zœ, 'e pandœ o'o upu nœ tafo soro fœ azu.» ");
INSERT INTO mnh_vpl VALUES ("AC5_21","074_5_21","ACT","5","21","21","Manda kœdji o'onœ, endje ro pe dœ amazɨ tuu ga lœ Tepelo, yé œ tetœ kœyisœ œrœ ɓa zœ. Egerœ nganga Ndjaba yikumu ye, œshe œdœ azu á endje sœ ɨndɨrɨ ye. Endje e lima osho ndœ angbɔtœ nœ endje dœ agboro azu kœwa ngbanga, yé œ vwa azu adœke endje e aayi avwa á endje sœ ɓa lœ kánga. ");
INSERT INTO mnh_vpl VALUES ("AC5_22","074_5_22","ACT","5","22","22","Kashe lɔkɔ á aayi akwa wuta lima ɓa lœ kánga ɓa zœ, endje gbɔgbɔ lima endje nene. Endje gu yé œ pa adœke: ");
INSERT INTO mnh_vpl VALUES ("AC5_23","074_5_23","ACT","5","23","23","«'A wu manda kánganœ, endje tshu dœ ɔtshɔnœ yé aayi kœgbɔndœ manda nœ ka ga pa nœ. Kashe lɔkɔ á 'a kɔrɔ atake, a wuwu uzu bale ɓa lœ nœ ɓa zœ nene.» ");
INSERT INTO mnh_vpl VALUES ("AC5_24","074_5_24","ACT","5","24","24","Kœdji o'onœ ataa, gbozu nœ aayi kœgbɔndœ Tepelo œdœ pe agboro anganga Ndjaba i gbɔndjuru tœ upunœ, yé œ tetœ kœyutœ endje tœ neke á mbœrœtœ endje asœmœ. ");
INSERT INTO mnh_vpl VALUES ("AC5_25","074_5_25","ACT","5","25","25","Kashe anga uzu na lima œ pandœ nœ fœ endje adœke: «'E wu, azu á 'e ko lima endje ga lœ kánga asœmœ, endje ka ɓa lœ Tepelo yé œ sœ kœyisœ œrœ fœ azu.» ");
INSERT INTO mnh_vpl VALUES ("AC5_26","074_5_26","ACT","5","26","26","Yé gbozu tshapa aayi kœgbɔndœ Tepelo na dœ aturugu nœ ye, œ to aayi avwa lœ zɨtɨnœ kparawa adœke azu kœveve œne dœ badja nene. ");
INSERT INTO mnh_vpl VALUES ("AC5_27","074_5_27","ACT","5","27","27","Endje na dœ endje ga lœ osho kœwa ngbanga, yé egerœ nganga Ndjaba te lima tœ kœwa ngbanga ga pa endje. ");
INSERT INTO mnh_vpl VALUES ("AC5_28","074_5_28","ACT","5","28","28","Tshe pa fœ endje adœke: «'A kɔ 'e lima dœ ɔgbɔ tœ kœyisœ œrœ dœ ɨ'ɨrɨ uzu asœmœ ye. 'E wu, 'e mbœrœ œrrr kœyisœrœ nœ 'e za tshelœ ongbo Yerusaleme djigi. Atamœ, 'e yindœ kœmɨndœ nœ adœke a'a dá wo yakoshenœ asœke a?» ");
INSERT INTO mnh_vpl VALUES ("AC5_29","074_5_29","ACT","5","29","29","Kashe Apetro dœ anga udu aayi avwa gi adœke: «Œ li adœke a mbœrœtœ azœ lindœ o'o ama Ndjaba, kashe œ dœ́dœ́ lindœ œnœ azu nene. ");
INSERT INTO mnh_vpl VALUES ("AC5_30","074_5_30","ACT","5","30","30","Ndjaba nœ aata azœ she Yisu á e'e, 'e wo lima she á za she ga pa kurushi ugurutœ akuzu. ");
INSERT INTO mnh_vpl VALUES ("AC5_31","074_5_31","ACT","5","31","31","Tshe za she ga pa kuni ye, œ fa she tœ Gbozu œdœ ayi kœshe azu mbœrœ adœke azu Israyele fatshalɔsu endje yekane á Ndjaba kœdjerœndœ ekperœ nœ endje. ");
INSERT INTO mnh_vpl VALUES ("AC5_32","074_5_32","ACT","5","32","32","Yé tshe vwa 'a ndœ kœmɨndœ o'onœ asœke, a'a œdœ Ɔtshɔ Ɨshirɨ á Ndjaba za fœ azu neke á endje sœ kœmbœrœtœ endje liaka o'o ama ye.» ");
INSERT INTO mnh_vpl VALUES ("AC5_33","074_5_33","ACT","5","33","33","Kœdji o'onœ ataa, aayi kœwa ngbanga sœ dœ ókó tɔ pa nœ kpuru, yé œ yindœ kœwo aayi avwa. ");
INSERT INTO mnh_vpl VALUES ("AC5_34","074_5_34","ACT","5","34","34","Kashe anga Farisayi bale á ɨ'ɨrɨ ye kœdœ Gamaliyele, œshe kœdœ egerœ ayi kœyisœ awa akwa á azu kɔ yindœ ye, sœ lima kpœtœmœ zœ. Tshe áalafo ɓa ugurutœ aayi kœwa ngbanga asœmœ, yé á pa adœke endje ko damba aayi avwa ga shu kane. ");
INSERT INTO mnh_vpl VALUES ("AC5_35","074_5_35","ACT","5","35","35","Manda nœ, tshe pa ngbɨ adœke: «Azu tshelœ Israyele, 'e gbetshelœ 'e tœ œneke á 'e yindœ kœmbœrœ fœ azu asœke kane. ");
INSERT INTO mnh_vpl VALUES ("AC5_36","074_5_36","ACT","5","36","36","Œndœnœ dɨdɨ damba nene, Teyudase má kpœke tœ ye ɓata uzu á œsœ ye lɨ, yé azu ga pa œrœ nœ́ kama vana te mangba ye. Endje wo she yé endjeneke kɔ á endje te lima mangba ye, endje kurutshelœtœ endje dœ ɔrɔ yé anga œrœ bale kpa gugu manda endje nene. ");
INSERT INTO mnh_vpl VALUES ("AC5_37","074_5_37","ACT","5","37","37","«Manda ye, dœ lɔkɔ kœdɨ azu, Yudasi uzu tshelœ Galilayi kpa wuta, yé azu ndjoro te mangba ye. Kashe œshe ndje tshe tshu lima, yé endjeneke kɔ á endje te lima mangba ye kpa kuru ndje tshelœtœ endje. ");
INSERT INTO mnh_vpl VALUES ("AC5_38","074_5_38","ACT","5","38","38","Ngɔngɔ asœke, mœ pa fœ 'e adœke 'e kpa gbegbe dœ azunœ asœke nene; 'e katœ endje dœ́ endje ro. Mbœrœ œdœ gbetshelœ too akwa nœ endje kœto ɓa ndœ azu, œ yiwa dœ tœ endje zœ. ");
INSERT INTO mnh_vpl VALUES ("AC5_39","074_5_39","ACT","5","39","39","Œdœ œ kœto ɓa ndœ Ndjaba, 'e li kœwo tœnœ nene. 'E mbœmbœrœ adœke 'e gbɔ o'o dœ Ndjaba nene!» Aayi kœwa ngbanga para kɔkɔ yindœ o'o Gamaliyele ngbɨɨ. ");
INSERT INTO mnh_vpl VALUES ("AC5_40","074_5_40","ACT","5","40","40","Yé œ kpa e aayi avwa, œ sɔ endje dœ ndjapa. Manda kœmɨ upu fœ endje adœke endje kpa tata ɨ'ɨrɨ Yisu nene, endje katœ endje tɨ. ");
INSERT INTO mnh_vpl VALUES ("AC5_41","074_5_41","ACT","5","41","41","Aayi avwa gitœ endje utshu aayi kœwa ngbanga yé lɔsu endje sú dœ yanga, mbœrœ á endje wu oyo mangba ɨ'ɨrɨ Yisu. ");
INSERT INTO mnh_vpl VALUES ("AC5_42","074_5_42","ACT","5","42","42","Ɔlɔ dœ ɔlɔ, œdœ ɓa lœ Tepelo too ɓa sœnda, endje sœ kolœ kœyisœ œrœ nœ endje dœ pe kœpandœ Ɔtshɔ O'onœ adœke Yisu kœdœ Masiya. ");
INSERT INTO mnh_vpl VALUES ("AC6_1","074_6_1","ACT","6","1","1","Dœ lɔkɔnœ asœmœ, ayindœ Yisu wuta lima ndjoro. Ayudanœ á endje zu endje lima lœ angbɨ ogo, á endje sœ kœpa o'o ama Greke tetœ kœpulœma endje tœ upu nœ anga endje á endje zu endje ɓa lœ ogo Israyele. Gbambanœ nene, endje pa lima adœke ɔlɔ dœ ɔlɔ á endje sœ kœkurutshelœ œrœ, endje sœsœ kœgbe dœ ayashe koya á endje to lœ angbɨ ogo dœ ɔtshɔnœ nene. ");
INSERT INTO mnh_vpl VALUES ("AC6_2","074_6_2","ACT","6","2","2","Aayi avwa ndjokpa dœ bisha ngbɔɓa ayindœ Yisu kɔ ga tœ œsœnœ, yé œ pa adœke: «Œ lili adœke 'a katœ kœyisœ o'o ama Ndjaba tɨ yé œ gbe kolœ dœ akwa nœ kœzɨrœ nene. ");
INSERT INTO mnh_vpl VALUES ("AC6_3","074_6_3","ACT","6","3","3","Mbœrœ tœnœ ataa, aaya, 'e ke azu mindu dœ bisha (7) ugurutœ 'e á ɔtshɔ endje ga, endjeneke á endje sú dœ Ɔtshɔ Ɨshirɨ œdœ pe kœwusœtœ yeka á a kœza akwanœ asœmœ fœ endje. ");
INSERT INTO mnh_vpl VALUES ("AC6_4","074_6_4","ACT","6","4","4","Tœ a'a nœ 'a, 'a sœpe kœza avwala œdœ kœyisœ Ɔtshɔ O'o.» ");
INSERT INTO mnh_vpl VALUES ("AC6_5","074_6_5","ACT","6","5","5","Ayindœ Yisu para kɔkɔ yindœ o'onœ asœmœ ngbɨɨ fœ endje. Endje ke Etiene, uzu nœ kœyindœrœ œdœ Ɔtshɔ Ɨshirɨ, Filipo, Prokɔre, Nikanɔre, Timo, Paremenase œdœ pe Nikola á tshe kœdœ uzu á tshe yindœ Ndjaba nœ Ayuda ɓa lœ ongbo Atiɔshe. ");
INSERT INTO mnh_vpl VALUES ("AC6_6","074_6_6","ACT","6","6","6","Endje ma endje fœ aayi avwa yeka á endje za avwala, yé á to kane endje ga pa endje. ");
INSERT INTO mnh_vpl VALUES ("AC6_7","074_6_7","ACT","6","7","7","O'o ama Ndjaba sœ lima kœza osho kɔ, yé ayindœ Yisu kpa ngba tɔpanœ kpuru lœ Yerusaleme. Anganga Ndjaba ndjoro fa lima lɔsu endje, œ yindœ o'o nœ Yisu. ");
INSERT INTO mnh_vpl VALUES ("AC6_8","074_6_8","ACT","6","8","8","Ɔtshɔ lɔsu œdœ pe gbɔgbɔ nœ Ndjaba su lima Etiene kperœ, tshe fa lima œrœ yé œ má ambáránœ lœ ugurutœ azu. ");
INSERT INTO mnh_vpl VALUES ("AC6_9","074_6_9","ACT","6","9","9","Kashe dœ lɔkɔ asœmœ, azu tshelœ Sinagoga á endje e endje «akanga á endje za awa fœ endje», endje kœdœ anga azu ogo Sirene, dœ anga azu ogo Alekezandri, dœ anga azu tshelœ Silisi œdœ pe endje nœ Azi tetœ kœgbugburu tshelœ o'o dœ Etiene. ");
INSERT INTO mnh_vpl VALUES ("AC6_10","074_6_10","ACT","6","10","10","Kashe ɓata á tshe sœ lima kœpa o'o lœ kœwusœtœ á Ɔtshɔ Ɨshirɨ to fœ she, awa adœke endje shara she gugu lima nene. ");
INSERT INTO mnh_vpl VALUES ("AC6_11","074_6_11","ACT","6","11","11","Endje fara lima azu dœ kowo mbœrœ á endje kœpa adœke: «'A dji she kœpa ekpe o'o ga tœ Moyize œdœ pe ga tœ Ndjaba!» ");
INSERT INTO mnh_vpl VALUES ("AC6_12","074_6_12","ACT","6","12","12","Endje bɨlɨ azu, agbɔ Ayuda œdœ aayi kœyisœ awa akwa. Yé endje na ndoo dœ Etiene œ bopa ye, á to she rotœnœ ga lœ angbɔtœ kœwa ngbanga. ");
INSERT INTO mnh_vpl VALUES ("AC6_13","074_6_13","ACT","6","13","13","Endje na dœ ekpe atimu ɓa zœ, yé á endje pa adœke: «Uzunœ á tshe sœ asœke kakatœ kœpa o'o tœ œyerœ Tepelo nœ zœ œdœ pe tœ awa akwa nœ Moyize nene. ");
INSERT INTO mnh_vpl VALUES ("AC6_14","074_6_14","ACT","6","14","14","'A dji she kœpa adœke, Yisu, uzu tshelœ Nazaretenœ asœmœ œ ndɨ tshelœ Tepelo asœke, yé œ yapa ndje mara kœsœ nœ aata azœ á Moyize ka lima tœ nœ fœ azœ.» ");
INSERT INTO mnh_vpl VALUES ("AC6_15","074_6_15","ACT","6","15","15","Endjeneke kɔ á endje sœ lima tœ œsœ angbɔtœ kœwa ngbanganœ, endje to lima ndœ Etiene, yé œ wu tshatshu ye ɓata œnœ andjelu. ");
INSERT INTO mnh_vpl VALUES ("AC7_1","074_7_1","ACT","7","1","1","Egerœ nganga Ndjaba yu Etiene adœke: «Œneke á endje pa dœ ɨ'ɨrɨ zœ kœdœ adja o'o a?» ");
INSERT INTO mnh_vpl VALUES ("AC7_2","074_7_2","ACT","7","2","2","Etiene gi adœke: «Alaya mœ œdœ pe alaba mœ, 'e dji mœ kane. Ndjaba nœ mokɔ wuta lima ga tœ ata azœ dœ Abrayamo lɔkɔ á tshe sœ lima ɓa lakpɨ Mezopotami, utshunœ adœke tshe gu kœmbœrœ ogo Harane. ");
INSERT INTO mnh_vpl VALUES ("AC7_3","074_7_3","ACT","7","3","3","Tshe pa lima fœ she adœke: “Katœ ogo zœ œdœ pe bɨngɨ nœ zœ tɨ, yé œ gu ndœ ogo á mœ yisœ nœ fœ ɓœ.” ");
INSERT INTO mnh_vpl VALUES ("AC7_4","074_7_4","ACT","7","4","4","Yé Abrayamo katœ ogo nœ ye ɓa lakpɨ Kalade tɨ, œ ro kœmbœrœ ogo ɓa lakpɨ Harane. Aba Abrayamo tshu ɓa zœ yé manda kuzu ye, Ndjaba gi lima Abrayamo ga lœ ogo á 'e sœ lœ nœ ngɔngɔ asœke. ");
INSERT INTO mnh_vpl VALUES ("AC7_5","074_7_5","ACT","7","5","5","Kashe Ndjaba fafa lima Abrayamo tœ ayengɔ ɔshɔnœ bale nene, á œdœ ndje osho nœ kœto ada ye ga tœnœ nene. Kashe tshe pa lima ndœ nœ fœ she adœke œne za bala ogonœ asœke fœ she dœ aatanœ, andaa œshe dœ́ Abrayamo gugu lima damba dœ gbolo nene. ");
INSERT INTO mnh_vpl VALUES ("AC7_6","074_7_6","ACT","7","6","6","Yé Ndjaba kpa pa lima fœ she atake: “Aata zœ œ mbœrœ bala angbɨ ogo. Endje te bala akanga ɓa zœ, yé œ wu oyo manda ungu kama vana. ");
INSERT INTO mnh_vpl VALUES ("AC7_7","074_7_7","ACT","7","7","7","Kashe œmœ Ndjaba, mœ pa adœke mœ wa bala ngbanga ga tœ ogo á endje te akanga lœ nœ. Manda nœ, endje wuta ɓa zœ yé œ gu ndœ kœza avwala fœ mœ kpœtœ oshonœ asœke.” ");
INSERT INTO mnh_vpl VALUES ("AC7_8","074_7_8","ACT","7","8","8","«Ndjaba lu madu dœ Abrayamo yé ambáránœ kœdœ kœwa gaza ayakoshe. Mbœrœ tœnœ dá Abrayamo wa gbolo nœ ye dœ Izaka tœ gaza ɔlɔ á tshe mbœrœ olo mindu dœ votɔ manda kœzu she. Awa bale Izaka wa lima gbolo nœ ye dœ Yakobo yé Yakobo wa ndje agbolo yakoshe nœ ye ndjokpa dœ bisha, á endje dœ́ aata azœ tœ gaza.» ");
INSERT INTO mnh_vpl VALUES ("AC7_9","074_7_9","ACT","7","9","9","«Aata azœ mbœrœ lima uku ga tœ Yozefu yé œ ka lima she mbœrœ kœte kanga ɓa lœ Ezipito, kashe Ndjaba sœ lima dœ she awa bale. ");
INSERT INTO mnh_vpl VALUES ("AC7_10","074_7_10","ACT","7","10","10","Tshe gi she lœ oyo nœ ye kɔ, œ to kœwusœtœ fœ she yé á mbœrœ adœke tshe wuta ɔtshɔ uzu utshu Farawo, gbozugo Ezipito. Farawo za she tœ ayi kœtondœ ogo Ezipito œdœ pe œrœ tshasœnda nœ ye kɔ. ");
INSERT INTO mnh_vpl VALUES ("AC7_11","074_7_11","ACT","7","11","11","A sœ atake, egerœ ogo za Ezipito œdœ pe ogo Kanana djigi. Oyo ro lima sœ nœ yé awa kœgbɔ kœzɨrœ gugu lima tœ aata azœ nene. ");
INSERT INTO mnh_vpl VALUES ("AC7_12","074_7_12","ACT","7","12","12","Lɔkɔ á Yakobo dji lima adœke kœzɨrœ sœ ɓa lœ Ezipito, tshe vwa aata azœ utshunœ. ");
INSERT INTO mnh_vpl VALUES ("AC7_13","074_7_13","ACT","7","13","13","Tœ bisha kœro endje ga zœ, Yozefu pandœtœ ye fœ aayanœ, yé œ pandœ mara nœ ye fœ Farawo. ");
INSERT INTO mnh_vpl VALUES ("AC7_14","074_7_14","ACT","7","14","14","Manda nœ, Yozefu vwa osho adœke endje para abanœ dœ Yakobo œdœ pe ayonœ kɔ na tœnœ. Endje sœ lima kɔ azu zazu votɔ dœ ndjokpa dœ mindu. ");
INSERT INTO mnh_vpl VALUES ("AC7_15","074_7_15","ACT","7","15","15","Yakobo na ga lœ Ezipito, yé œ tshu ɓa zœ œdœ ndje pe aata azœ. ");
INSERT INTO mnh_vpl VALUES ("AC7_16","074_7_16","ACT","7","16","16","Endje ko lima oko endje ro tœnœ ɓa lœ Sikeme yeka á shi endje ɓa lœ udu á Abrayamo yɔ lima tshakane agbolo nœ Amore. ");
INSERT INTO mnh_vpl VALUES ("AC7_17","074_7_17","ACT","7","17","17","«Ɓata á olo kœmbœrœ œrœ má Ndjaba pa lima tœnœ fœ Abrayamo ndo ye, aata azœ zu lima azu yé œ kpa wuta ndjoro lœ ogo Ezipito, ");
INSERT INTO mnh_vpl VALUES ("AC7_18","074_7_18","ACT","7","18","18","yekane á anga tafo gbozugo á tshe wuwu lima sœ o'o tœ upu nœ Yozefu nene, za akwa kœgbɔndœ ogo Ezipito. ");
INSERT INTO mnh_vpl VALUES ("AC7_19","074_7_19","ACT","7","19","19","Gbozugonœ sœ lima kœfara azu nœ azœ, tshe ma lima ekpe ɔtshɔ ye fœ aata azœ œrrr ga tœ kœpa fœ endje adœke endje ko aaya agbolo nœ endje á endje sœpe kœɔ ɔngɔ va e mbœrœ adœke endje tshu ye.» ");
INSERT INTO mnh_vpl VALUES ("AC7_20","074_7_20","ACT","7","20","20","Dœ lɔkɔnœ asœmœ dá endje zu lima Moyize. Tshe kœdœ lima ɔtshɔ gbolo tœ ala Ndjaba. Tshe mbœrœ lima yapu votɔ ɓa lœ anda nœ abanœ. ");
INSERT INTO mnh_vpl VALUES ("AC7_21","074_7_21","ACT","7","21","21","Yé manda nœ, endje katœ ye tɨ, yawuru nœ Farawo za she œ gbɔndœ ye lima ɓata adja gbolo nœ ye. ");
INSERT INTO mnh_vpl VALUES ("AC7_22","074_7_22","ACT","7","22","22","Endje yi lima sœ œrœ tshelœ Ezipito kɔ fœ she, yé tshe sœ lima dœ gbɔgbɔ lœ o'o œdœ pe lœ akwa nœ ye. ");
INSERT INTO mnh_vpl VALUES ("AC7_23","074_7_23","ACT","7","23","23","«Lɔkɔ á tshe wuta lima ga tœ ungu zazu bisha, tshe gbɔ gbetshelœ kœro ɓa ugurutœ aayanœ, azu tshelœ Israyele. ");
INSERT INTO mnh_vpl VALUES ("AC7_24","074_7_24","ACT","7","24","24","Tshe wu lima uzu Ezipito kœɓi anga uzu Israyele bale. Mbœrœ kœnga pa ayanœ asœmœ œdœ pe kœtɔ geda tshangba ye, tshe ɓi uzu Ezipitonœ yerœwa fœ kuzu. ");
INSERT INTO mnh_vpl VALUES ("AC7_25","074_7_25","ACT","7","25","25","Tshe gbe lima adœke aaya œne wusœ nœ adœke Ndjaba œ she endje lœ awa nœ œne. Andaa endje wuwu lima sœ nœ nene. ");
INSERT INTO mnh_vpl VALUES ("AC7_26","074_7_26","ACT","7","26","26","Olo bale manda nœ, Moyize kɔ tshelœ azu Israyele bisha á endje sœ tœ koshe, yé œ ngbɔɓa endje ga tœnœ dœ o'o atake: “Anga mœ, e'e kœdœ aayazu! Mbœrœ gaɗe á 'e ɓitœ 'e a?” ");
INSERT INTO mnh_vpl VALUES ("AC7_27","074_7_27","ACT","7","27","27","Kashe tsheneke á tshe sœ kœɓi yanganœ gɔrɔ Moyize dœ o'o take: “Uzu ɗe dá za ɓœ tœ gbozu œdœ ayi kœwa ngbanga pa 'a? ");
INSERT INTO mnh_vpl VALUES ("AC7_28","074_7_28","ACT","7","28","28","Ɓœ yindœ kœwo mœ ɓata á ɓœ wo libi uzu Ezipito a?” ");
INSERT INTO mnh_vpl VALUES ("AC7_29","074_7_29","ACT","7","29","29","Kœdji o'onœ asœmœ ata, Moyize kpa œ zatœ ye yiwa tœnœ ɓa lœ ogo nœ Amadiane. Tshe zu lima agbolo bisha ɓa zœ.» ");
INSERT INTO mnh_vpl VALUES ("AC7_30","074_7_30","ACT","7","30","30","«Manda ungu zazu bisha, andjelu wuta ga tœ ye ɓala laɓa owo, ɓa lœ a'eara ɔyɔ á sœ ɓa lœ kpagagasho kaga Sinayi. ");
INSERT INTO mnh_vpl VALUES ("AC7_31","074_7_31","ACT","7","31","31","Moyize i gbɔndjuru lɔkɔ á tshe wu œrœnœ asœmœ. Œne gitœ œne ndoo á kœtondœ nœ kane, tshe dji tshama Gbozu Ndjaba kœpa adœke: ");
INSERT INTO mnh_vpl VALUES ("AC7_32","074_7_32","ACT","7","32","32","“Œmœ kœdœ Ndjaba nœ aaba zœ, Ndjaba nœ Abrayamo, nœ Izaka dœ pe Yakobo.” Awa litœ Moyize kpa kpa kpa ye; awa adœke tshe tondœ oshonœ gugu tœ ye nene. ");
INSERT INTO mnh_vpl VALUES ("AC7_33","074_7_33","ACT","7","33","33","Á Gbozu Ndjaba kœpa fœ she adœke: “Gi ada zœ lœ œrada mbœrœ osho á ɓœ ka ga tœnœ kœdœ œyerœ osho. ");
INSERT INTO mnh_vpl VALUES ("AC7_34","074_7_34","ACT","7","34","34","Adjapu, mœ wu oyo á azu nœ mœ sœ kœwu tœnœ ɓa lœ ogo Ezipito, œ dji ndœ ɨkɨ endje; mbœrœ tœnœ ataa dá mœ jerœ kœshe endje. Na zœ, mœ yindœ kœvwa ɓœ ngɔngɔ asœke ɓa lœ Ezipito.” ");
INSERT INTO mnh_vpl VALUES ("AC7_35","074_7_35","ACT","7","35","35","«Tshetœ Moyize á azu Israyele gɔrɔ lima she á pa fœ she adœke: “Œɗe dá za ɓœ tœ gbozu œdœ ayi kœwa ngbanga a?” Œshe dá Ndjaba vwa she ɓata gbozu, ɓata ayi kœshe azu lœ awa nœ andjelu á tshe wuta ga ndœ ye ɓa lœ a'eara ɔyɔ. ");
INSERT INTO mnh_vpl VALUES ("AC7_36","074_7_36","ACT","7","36","36","Œshe dá ko endje wuta tœ nœ ga shu lœ ogo Ezipito. Tshe fa œrœ yé œ má ambáránœ lœ ogo Ezipito, ɓa tœ egerœ ungu Fala œdœ ɓa lœ kpagagasho manda ungu zazu bisha. ");
INSERT INTO mnh_vpl VALUES ("AC7_37","074_7_37","ACT","7","37","37","Moyize dá kpa pa fœ azu Israyele adœke: “Ndjaba œ to bala ayi kœgbara o'o bale ɓata mœ fœ 'e lœ ugurutœ aaya 'e.” ");
INSERT INTO mnh_vpl VALUES ("AC7_38","074_7_38","ACT","7","38","38","Œshe dá ka lima lœ ugurutœ aata azœ dœ pe andjelu á tshe pa lima o'o fœ she ɓa pa kaga Sinayi. Moyize dá sœ lima kœgbɔ o'o nœ soro ɓa ndœ Ndjaba mbœrœ kœyisœ nœ fœ azœ. ");
INSERT INTO mnh_vpl VALUES ("AC7_39","074_7_39","ACT","7","39","39","«Kashe aata azœ yiyi lima ndœ kœdji she nene; endje vwaratœ endje tœ ye yé œ yi lima ndœ kœkwatœ endje ga lœ ogo Ezipito. ");
INSERT INTO mnh_vpl VALUES ("AC7_40","074_7_40","ACT","7","40","40","Endje pa lima fœ Aro adœke: “Mbœrœ anga andjaba fœ 'a adœke endje gbɔndœ 'a, mbœrœ Moyize má á tshe ko azœ wuta tœnœ ga shu lœ ogo Ezipitonœ asœmœ, 'a wuwusœ œrœ á wuta ga tœ ye nene.” ");
INSERT INTO mnh_vpl VALUES ("AC7_41","074_7_41","ACT","7","41","41","Endje mbœrœ lima ɨshirɨ aya ngombe dœ ɔlɔnœ asœmœ œ sœ kœto okoro ga tœnœ, yé œ mbœrœ angbo dœ yanga mbœrœ œneke á endje mbœrœ lima dœ tœ endje. ");
INSERT INTO mnh_vpl VALUES ("AC7_42","074_7_42","ACT","7","42","42","Tœ kœgi œrœ tshangbanœ fœ endje, Ndjaba dɔ tshapa ye gbɔ endje yé œ katœ endje adœke endje donga angerepe ɓa lafo, ɓata á endje sú ɓa la mbeti nœ ayi kœgbara o'o adœke: “Azu Israyele, œmœ dá 'e to lima agea œdœ pe tokóró fœ mœ manda ungu zazu bisha ɓa lœ kpagagasho a? ");
INSERT INTO mnh_vpl VALUES ("AC7_43","074_7_43","ACT","7","43","43","Œ̃ œ̃ nene. 'E za gbanda tande nœ ndjaba Moloke, œdœ ɨshirɨ nœ ndjaba angerepe nœ e'e dœ Refane, ɨshirɨnœ á 'e mbœrœ dœ tœ 'e á sœ kœdonga tœnœ asœmœ. Mbœrœ tœnœ ataa, mœ gɔrɔ 'e lœ ogo nœ 'e dœ́ œ vwa 'e waa ɓa kele Babilone.” ");
INSERT INTO mnh_vpl VALUES ("AC7_44","074_7_44","ACT","7","44","44","«Aata azœ sœ lima dœ gbanda tande á sœ kœma adœke Ndjaba sœ dœ azœ awa bale ɓa lœ kpagagasho. Ndjaba pa lima fœ Moyize adœke tshe mɔ anda tandenœ ɓata œneke á tshe wu lima. ");
INSERT INTO mnh_vpl VALUES ("AC7_45","074_7_45","ACT","7","45","45","Aata azœ gbɔ gbanda tande ɓa ndœ aba endje, yé œ te œnœ endje. Lɔkɔ á Yosuwa sœ lima kœgbɔndœ endje, endje li dœ tœnœ djelœ ogo neke á endje gbɔtœnœ lœ koshe, ogo á Ndjaba gɔrɔ azu lœnœ utshu endje. Gbanda tandenœ sœ kpœtœmœ œrrr ga tœ lɔkɔ á Davidi wuta lima gbozugonœ. ");
INSERT INTO mnh_vpl VALUES ("AC7_46","074_7_46","ACT","7","46","46","Davidi gbɔ ɔtshɔrœ ɓa ndœ Ndjaba, yé œ yu osho adœke œne mɔ anda fœ Ndjaba nœ Yakobo. ");
INSERT INTO mnh_vpl VALUES ("AC7_47","074_7_47","ACT","7","47","47","Kashe Salomo dá mɔ lima andanœ fœ she. ");
INSERT INTO mnh_vpl VALUES ("AC7_48","074_7_48","ACT","7","48","48","«Andaa Ndjaba á tshe ropa œrœ kɔ sœsœ lœ anda á azu mbœrœ dœ kane endje nene. Ɓata á Ndjaba pa lœ awa nœ aayi kœgbara o'o adœke: ");
INSERT INTO mnh_vpl VALUES ("AC7_49","074_7_49","ACT","7","49","49","“Tshalafo kœdœ osho tshagbozu nœ mœ, yé ɔshɔ kœdœ osho kœto ada mœ ga tœnœ. Anda gaɗe dá 'e mɔ fœ mœ a? Yé osho gaɗe dá mœ kœyatœ mœ tœnœ a? ");
INSERT INTO mnh_vpl VALUES ("AC7_50","074_7_50","ACT","7","50","50","Œ dœ́dœ́ kane mœ dá mbœrœ œrœnœ asœmœ kɔ nene a?” ");
INSERT INTO mnh_vpl VALUES ("AC7_51","074_7_51","ACT","7","51","51","«Etiene kpa pa fœ azu kœwa ngbanga adœke: “Azu gbɔkumu, lɔsu 'e œdœ utu 'e be pa 'e tœ upu nœ Ndjaba, 'e sœ kœvwaratœ 'e ɔlɔ dœ ɔlɔ tœ Ɔtshɔ ɨshirɨ. 'E sœ adja awa bale ɓata aata 'e. ");
INSERT INTO mnh_vpl VALUES ("AC7_52","074_7_52","ACT","7","52","52","Aayi kœgbara o'o neketa dá aata 'e ndandanga she nene a? Endje wo lima endjeneke á endje sœ kœpandœ kœna uzu á tshe sœ ndjii. Yé ngɔngɔ nœ asœke, tshetœ ye dá 'e va ɔtɔ ye yé á wo she. ");
INSERT INTO mnh_vpl VALUES ("AC7_53","074_7_53","ACT","7","53","53","'E dji awa akwa nœ Ndjaba á aandjelu pandœ nœ fœ 'e, yé œ tshapu kœza ga tœ akwa ye.”» ");
INSERT INTO mnh_vpl VALUES ("AC7_54","074_7_54","ACT","7","54","54","Lɔkɔ á aayi kœwangbanga dji o'onœ asœmœ ataa, tshatshu endje fa agba ɔkɔ, yé endje zɨ tshelœ daji endje gbagbara gbagbara dœ ókó ga tœ Etiene. ");
INSERT INTO mnh_vpl VALUES ("AC7_55","074_7_55","ACT","7","55","55","Kashe ɓata á Etiene su lima dœ Ɔtshɔ Ɨshirɨ, tshe tondœ tshalafo, œ wu mokɔ nœ Ndjaba œdœ Yisu á tshe ka ga tœ kuni ye. ");
INSERT INTO mnh_vpl VALUES ("AC7_56","074_7_56","ACT","7","56","56","Tshe pa adœke: «'E wu, mœ tondœ tshalafo ngbɨ yé Gbolo nœ uzu ka ga tœ kuni Ndjaba.» ");
INSERT INTO mnh_vpl VALUES ("AC7_57","074_7_57","ACT","7","57","57","Kœdji o'onœ ata, endje ve ɔgbɔ rawa yé œ be utu endje ga tœnœ. Manda nœ, endje tshu kɔ ga pa ye. ");
INSERT INTO mnh_vpl VALUES ("AC7_58","074_7_58","ACT","7","58","58","Endje gbota she lœ ongbo ga shu yeka á tetœ kœve lima she dœ badja. Atimunœ ka lima tœ lœba nœ endje ga tœ ada anga gbolo yakoshe bale á ɨ'ɨrɨ ye kœdœ Sawulo. ");
INSERT INTO mnh_vpl VALUES ("AC7_59","074_7_59","ACT","7","59","59","Lɔkɔ á endje sœ lima kœve Etiene dœ badja, tshe sœ lima kœza avwala adœke: «Gbozu Yisu, za ɨshirɨ mœ.» ");
INSERT INTO mnh_vpl VALUES ("AC7_60","074_7_60","ACT","7","60","60","Manda nœ, tshe te dœ matshukuda ye, yé œ ve ɔgbɔ rawa adœke: «Gbozu, gbegbe dœ ekperœ nœ endje nene.» Manda kœpu o'o asœmœ, tshe tshu ye. ");
INSERT INTO mnh_vpl VALUES ("AC8_1","074_8_1","ACT","8","1","1","Sawulo sœ lima ugurutœ azu á endje yindœ nœ adœke endje wo Etiene ye. Dœ ɔlɔnœ asœmœ, Ikrizia tshelœ Yerusaleme te lima tœ kœwu ɔgbɔ œrœ kanga. Kolœ aayi avwa dá lœpe lima lœ Yerusaleme kashe ayindœ Yisu para kɔkɔ kuru lima tshelœtœ endje lœ ogo Yuda œdœ pe lœ Samariya. ");
INSERT INTO mnh_vpl VALUES ("AC8_2","074_8_2","ACT","8","2","2","Azu nœ ɔtshɔ lɔsu shi lima Etiene manda kœkɨ she dœ oyo kɔ. ");
INSERT INTO mnh_vpl VALUES ("AC8_3","074_8_3","ACT","8","3","3","Andaa Sawulo sœ lima kœpa avwara kœndɨ Ikrizia. Tshe sœ lima kœli anda bale dœ bale yekane á gbota ayindœ Yisu, ayakoshe, ayashe yé á gu kœko endje va ga lœ kánga. ");
INSERT INTO mnh_vpl VALUES ("AC8_4","074_8_4","ACT","8","4","4","Endjeneke á endje ndjɔ lima tshelœtœ endje, tetœ kœpandœ Ɔtshɔ O'o djelœ ogo djezœ kɔ. ");
INSERT INTO mnh_vpl VALUES ("AC8_5","074_8_5","ACT","8","5","5","Filipo na œnœ ye ɓa lœ anga ongbo bale lœ Samariya, œ sœ kœyisœ œrœ dœ upu nœ Kristu ɓa zœ. ");
INSERT INTO mnh_vpl VALUES ("AC8_6","074_8_6","ACT","8","6","6","Ukpulu azu kɔ yindœ o'o ama Filipo mbœrœ á endje sœ lima kœdji she, á sœ ndje kœwu afá á tshe sœ lima kœmbœrœ tœnœ. ");
INSERT INTO mnh_vpl VALUES ("AC8_7","074_8_7","ACT","8","7","7","Ekpe ɨshirɨ ndjoro sœ lima kœwuta lœ aayi koɓa dœ kœve ɔgbɔ rawa. Azu ndjoro á ada endje tshu œdœ pe agbakɨndɨ she ndje lima ye. ");
INSERT INTO mnh_vpl VALUES ("AC8_8","074_8_8","ACT","8","8","8","Yé egerœ yanga sœ lima lœ ongbonœ asœmœ. ");
INSERT INTO mnh_vpl VALUES ("AC8_9","074_8_9","ACT","8","9","9","Anga uzu má ɨ'ɨrɨ ye kœdœ Shimu, á tshe sœ ndje utshunœ lœ ongbo sœmœ, sœ lima kœfa œrœ tsharawo yé azu tshelœ Samariya kɨ lima tœ œsœnœ waa. Tshe zatœ ye lima ɓata egerœ uzu. ");
INSERT INTO mnh_vpl VALUES ("AC8_10","074_8_10","ACT","8","10","10","Azu para kɔkɔ, kœto tœ aaya agbolo œrrr ga tœ agbozu, dji lima she tɔpanœ kpuru. Endje pa lima adœke: «Yakoshenœ asœke sœ dœ gbɔgbɔ nœ Ndjaba, á endje e tœnœ egerœ gbɔgbɔ.» ");
INSERT INTO mnh_vpl VALUES ("AC8_11","074_8_11","ACT","8","11","11","Endje zatœ endje lima ga tœ ye mbœrœ kœfa œrœ tsharawo nœ ye á sœ kœza uvuru endje lœ nœ. ");
INSERT INTO mnh_vpl VALUES ("AC8_12","074_8_12","ACT","8","12","12","Kashe lɔkɔ á endje dji lima Ɔtshɔ O'o á Filipo yisœ nœ tœ upu tshagbozu nœ Ndjaba œdœ pe ɨ'ɨrɨ Yisu Kristu, ayakoshe œdœ ayashe gbɔ lima batisimu. ");
INSERT INTO mnh_vpl VALUES ("AC8_13","074_8_13","ACT","8","13","13","Shimu yindœ nœ dœ tœ ye, yé œ gbɔ batisimu. Manda nœ, tshe te mangba Filipo. Tshe sœ lima kœwu ogboro ambárá œdœ pe afá á Filipo sœ kœmbœrœ tœnœ, œ kɨ tœ œsœnœ dœ yanga. ");
INSERT INTO mnh_vpl VALUES ("AC8_14","074_8_14","ACT","8","14","14","Aayi avwa á endje sœ lima ɓa lœ Yerusaleme dji adœke, azu tshelœ Samariya yindœ Ɔtshɔ O'o, yé œ vwa Apetro dœ Yowane fœ endje. ");
INSERT INTO mnh_vpl VALUES ("AC8_15","074_8_15","ACT","8","15","15","Lɔkɔ á endje wuta ɓa zœ, endje 'e tshalafo mbœrœ azu Samariya adœke endje gbɔ Ɔtshɔ Ɨshirɨ, ");
INSERT INTO mnh_vpl VALUES ("AC8_16","074_8_16","ACT","8","16","16","mbœrœ Ɨshirɨ jejerœ lima damba ga pa uzu bale ugurutœ endje nene; endje gbɔ lima kolœ batisimu dœ ɨ'ɨrɨ Gbozu Yisu. ");
INSERT INTO mnh_vpl VALUES ("AC8_17","074_8_17","ACT","8","17","17","Apetro dœ Yowane to kane endje ga pa endje, yé azu Samariya gbɔ Ɔtshɔ Ɨshirɨ. ");
INSERT INTO mnh_vpl VALUES ("AC8_18","074_8_18","ACT","8","18","18","Kashe lɔkɔ á Shimu wu adœke aayi avwa to kane endje ga pa endje yeka á endje gbɔ Ɔtshɔ Ɨshirɨ, tshe yindœ kœto ngendja fœ endje. ");
INSERT INTO mnh_vpl VALUES ("AC8_19","074_8_19","ACT","8","19","19","Œ pa fœ endje adœke: «'E to ndje gbɔgbɔnœ asœke fœ mœ, mbœrœ œdœ mœ kœto kane mœ ga pa anga azu, endje gbɔ ndje Ɔtshɔ Ɨshirɨ.» ");
INSERT INTO mnh_vpl VALUES ("AC8_20","074_8_20","ACT","8","20","20","Petro kœgi fœ she adœke: «Kaka Ndjaba mbœrœ adœke ɓœ yiwa awa bale dœ ngendja nœ zœ, mbœrœ á ɓœ gbe adœke endje yɔ œrœ á Ndjaba œ to fœ azu gbambanœ dœ ngendja. ");
INSERT INTO mnh_vpl VALUES ("AC8_21","074_8_21","ACT","8","21","21","Ɓœ lili kœsœ dœ 'a awa bale lœ akwanœ asœke nene, ɓœ gbɔ ndje anga œrœ bale lœ nœ nene, mbœrœ á lɔsu zœ sœsœ ndjii ɓa utshu Ndjaba nene. ");
INSERT INTO mnh_vpl VALUES ("AC8_22","074_8_22","ACT","8","22","22","Fa tshalɔsu zœ yé œ donga Gbozu á œ kœli yekane á tshe djerœndœ ekpe gbetshelœ á li ga lɔsu zœ. ");
INSERT INTO mnh_vpl VALUES ("AC8_23","074_8_23","ACT","8","23","23","Mbœrœ tœnœ ataa, mœ wu adœke ɓœ sœ dœ egerœ lɔsu, yé ɓœ fa kanga nœ ngbɨndɨrœ.» ");
INSERT INTO mnh_vpl VALUES ("AC8_24","074_8_24","ACT","8","24","24","Shimu gi adœke: «Adja e'e kœdonga Gbozu mbœrœ mœ, kparawa adœke œneke á 'e pa kœwuwuta ga tœ mœ nene.» ");
INSERT INTO mnh_vpl VALUES ("AC8_25","074_8_25","ACT","8","25","25","Manda kœgbara o'o ndje dœ kœyisœ o'o ama Gbozu, Apetro dœ Yowane kwatœ endje lima ga lœ Yerusaleme. Kœgu endje tœ ala awa, endje yi lima sœ Ɔtshɔ O'o lakpɨ ndjoro lœ ogo Samariya. ");
INSERT INTO mnh_vpl VALUES ("AC8_26","074_8_26","ACT","8","26","26","Ɔlɔ bale, andjelu nœ Gbozu pa fœ Filipo adœke: «Aafo œ na yorrr dœ awa á ro ga lœ Sudi, tœ awa á jerœ kœto lœ Yerusaleme kœna ga tœ Gaza. Tœnœ kœdœ awa á azu kpa sœsœ kœna tœnœ nene.» ");
INSERT INTO mnh_vpl VALUES ("AC8_27","074_8_27","ACT","8","27","27","Ngbewo, Filipo áalafo dœ kœro she. Kœna she yorrr tœ awanœ asœmœ, tshe wu anga uzu tshelœ ogo Etiopi bale, á tshe dœ́ egerœ ayi akwa nœ Kandase, gbozu yashe ogo Etiopi. Uzunœ asœmœ kœdœ ndje lima ayi kœgbɔndœ ngendja œdœ ukpulu œrœ nœ gbozu yashenœ yekane á ro lima ga lœ Yerusaleme mbœrœ kœdonga Ndjaba, ");
INSERT INTO mnh_vpl VALUES ("AC8_28","074_8_28","ACT","8","28","28","yé á sœ kœgu tœnœ ga ndœ ye. Tshe sœ lima ga lœ share nœ ye œ sœ kœdɨ mbeti á ayi kœgbara o'o Isaya su. ");
INSERT INTO mnh_vpl VALUES ("AC8_29","074_8_29","ACT","8","29","29","Ɔtshɔ Ɨshirɨ kœpa fœ Filipo adœke: «Gitœ zœ ga utshunœ œ togba dœ sharenœ asœmœ.» ");
INSERT INTO mnh_vpl VALUES ("AC8_30","074_8_30","ACT","8","30","30","Filipo na dœ ɔrɔ, œ dji uzu ogo Etiopinœ á tshe sœ kœdɨ mbeti á ayi kœgbara o'o Isaya su dœ avwara ga lafo. Á tshe kœyu she adœke: «Adja ɓœ wusœ ádá œneke á ɓœ dɨ asœke ye a?» ");
INSERT INTO mnh_vpl VALUES ("AC8_31","074_8_31","ACT","8","31","31","Uzunœ gi fœ she adœke: «Œdœ uzu kœyisœ ádánœ ngbɨ fœ mœ nene, mœ wu má sœ nœ koto o?» Yé tshe e Filipo adœke tshe ɔ œ sœ ga ɨndɨrɨ œne. ");
INSERT INTO mnh_vpl VALUES ("AC8_32","074_8_32","ACT","8","32","32","Œneke á endje sú lima ɓa la mbetinœ á tshe sœ kœdɨ lima tœnœ dœke: «Tshe sœ ɓata pata á endje na dœ she ga tœ osho kœwo apata, tshe sœ ɓata aya pata á tshe kɨkɨ utshu ayi kœlɨ usu kote ye nene, tshe ɨɨ lima ama ye bale nene. ");
INSERT INTO mnh_vpl VALUES ("AC8_33","074_8_33","ACT","8","33","33","Endje za tshula fœ she, yé œ wa ɔgbɔ ngbanga ga pa ye. Œɗe dá pa bala o'o mbœrœ agbolo tshangba ye a? Gbambanœ nene, endje wa tshelœ olo ye pa ɔshɔ.» ");
INSERT INTO mnh_vpl VALUES ("AC8_34","074_8_34","ACT","8","34","34","Uzu ogo Etiopi sœmœ yu Filipo adœke: «Wu oyo mœ kane, œɗe dá ayi kœgbara o'o patœ ye ataa? Tshe patœ ye dœ tœ ye too tshe patœ anga angbɨ uzu?» ");
INSERT INTO mnh_vpl VALUES ("AC8_35","074_8_35","ACT","8","35","35","Filipo kœto kpœpa œneke á endje sú ɓa la mbeti asœmœ yeka á yisœ Ɔtshɔ O'o nœ Yisu fœ she. ");
INSERT INTO mnh_vpl VALUES ("AC8_36","074_8_36","ACT","8","36","36","Endje ngbɔtœ awa ana nœ endje œ na œrrr, œ wuta ga tœ anga ungu á sœ ɓa ɨndɨrɨ awa, yé uzu Etiopi kœyu adœke: «Wu ungu asœke, œrœ gaɗe dá pakata mœ ndœ kœgbɔ batisimu a?»  ");
INSERT INTO mnh_vpl VALUES ("AC8_37","074_8_37","ACT","8","37","37","Filipo kœpa fœ she adœke: «Œdœ ɓœ kœyindœ nœ dœ lɔsu zœ bale, mœ za batisimu fœ ɓœ ye.» Yé uzu sœmœ kœgi fœ she adœke: «Mœ yindœ nœ adœke Yisu Kristu kœdœ Gbolo nœ Ndjaba.» ");
INSERT INTO mnh_vpl VALUES ("AC8_38","074_8_38","ACT","8","38","38","Tshe kœpa fœ ayi kœkpa dœ share adœke endje ka kpœke. Afilipo kœjerœ dœ she ga la ngu yé Filipo kœza lima batisimu fœ she. ");
INSERT INTO mnh_vpl VALUES ("AC8_39","074_8_39","ACT","8","39","39","Lɔkɔ á endje wuta langunœ, Ɨshirɨ nœ Gbozu za Filipo yé uzu Etiopi kpa wuwu she nene. Kashe tshe te lima tœ awa kœgu she dœ yanga. ");
INSERT INTO mnh_vpl VALUES ("AC8_40","074_8_40","ACT","8","40","40","Filipo wuta ɓa lakpɨ Azote, yé tshe ro kœyisœ Ɔtshɔ O'o na tœnœ lœ ongbo bale dœ bale djezœ œrrr vesho ga lakpɨ Sezaré. ");
INSERT INTO mnh_vpl VALUES ("AC9_1","074_9_1","ACT","9","1","1","Dœ lɔkɔnœ asœmœ, Sawulo sœ kolœ dœ gbetshelœ nœ kœmbœrœ œrœ kanga fœ azu Ikrizia œdœ pe kœpara awa nœ kœyiangwa endje. Tshe na ga ndœ egerœ nganga Ndjabanœ, ");
INSERT INTO mnh_vpl VALUES ("AC9_2","074_9_2","ACT","9","2","2","œ yɔndœ mbeti á za awa fœ she kœli djelœ Sinagoga á sœ lakpɨ Damaseke. Œdœ tshe kœwuta ɓa zœ á gbɔ azu, ayakoshe too ayashe má endje sœ kœza awa Yisu, tshe i endje dœ djingiri yé œ gu dœ endje ga lœ Yerusaleme. ");
INSERT INTO mnh_vpl VALUES ("AC9_3","074_9_3","ACT","9","3","3","Lɔkɔ á tshe te lima tœ awa yé á wuta lima ndoo dœ Damaseke, ɨshirɨ owo to ngbai ɓa lafo œ jerœ ga pa ye zakpɨ. ");
INSERT INTO mnh_vpl VALUES ("AC9_4","074_9_4","ACT","9","4","4","Tshe te ga tœ ɔshɔ, œ dji tshama uzu kœpa adœke: «Sawulo, Sawulo, mbœrœ gaɗe á ɓœ mbœrœ œrœ kanga fœ mœ ataa?» ");
INSERT INTO mnh_vpl VALUES ("AC9_5","074_9_5","ACT","9","5","5","Tshe yu adœke: «Gbozu, œɓœ kœdœ ɗe?» Yé tshamanœ kœgi adœke: «Œmœ kœdœ Yisu, œmœ á ɓœ mbœrœ œrœ kanga fœ mœ. ");
INSERT INTO mnh_vpl VALUES ("AC9_6","074_9_6","ACT","9","6","6","Kashe aalafo œ li ga lœ ongbo, yé ɓa zœ dá endje pandœ œneke á li adœke ɓœ mbœrœ, fœ ɓœ.» ");
INSERT INTO mnh_vpl VALUES ("AC9_7","074_9_7","ACT","9","7","7","Azu á endje na tœ ala awa dœ Sawulo ka lima, œ sœ kokoko; endje dji lima tshama uzu kashe endje wuwu lima she nene. ");
INSERT INTO mnh_vpl VALUES ("AC9_8","074_9_8","ACT","9","8","8","Sawulo áalafo lœ ɔshɔ, kashe ataa tshe kɔrɔ ala ye gbaa, tshe wuwu lima osho bale nene. Anganœ á tshe na lima tœ ala awanœ dœ endje dá za ama kane ye yeka á gbota she duru duru rotœnœ ga lakpɨ Damaseke. ");
INSERT INTO mnh_vpl VALUES ("AC9_9","074_9_9","ACT","9","9","9","Tshe mbœrœ lima olo votɔ lœ bula; tshe zɨzɨ lima œrœ yé œ ndjo ndje ungu nene. ");
INSERT INTO mnh_vpl VALUES ("AC9_10","074_9_10","ACT","9","10","10","Anga yindœ Yisu bale á ɨ'ɨrɨ ye kœdœ Anania sœ lima ɓa lœ Damaseke. Gbozu e she lœ ulu adœke: «Anania!» Tshe gi fœ she adœke: «Mœ sœ kea, Gbozu!» ");
INSERT INTO mnh_vpl VALUES ("AC9_11","074_9_11","ACT","9","11","11","Gbozu kpa pa adœke: «Na dœ ala awa má endje e tœnœ awa Ndjii, œ yu osho ɓa lœ anda nœ Yudasi tœ anga yakoshe tshalakpɨ Tarse bale á ɨ'ɨrɨ wu Sawulo. Tshe sœ kœza avwala ɓa zœ, ");
INSERT INTO mnh_vpl VALUES ("AC9_12","074_9_12","ACT","9","12","12","yé lœ ulu, tshe wu anga yakoshe bale á ɨ'ɨrɨ ye kœdœ Anania kœli yé á to kane ye ga pa ye adœke tshe kpa wu osho.» ");
INSERT INTO mnh_vpl VALUES ("AC9_13","074_9_13","ACT","9","13","13","Anania gi adœke: «Gbozu, mœ dji azu ndjoro kœpa o'o tœ yakoshenœ asœke œdœ kœpandœ ngbɨndɨrœ kɔ á tshe mbœrœ fœ azu kœyindœ zœ ɓa lœ Yerusaleme. ");
INSERT INTO mnh_vpl VALUES ("AC9_14","074_9_14","ACT","9","14","14","Yé ngɔngɔ asœ, tshe wuta ɓa ke dœ mbeti á tshe gbɔ ɓa ndœ agbozu tshapa anganga Ndjaba mbœrœ kœi endjeneke kɔ á endje e ɨ'ɨrɨ zœ lœ ama endje, dœ djingiri.» ");
INSERT INTO mnh_vpl VALUES ("AC9_15","074_9_15","ACT","9","15","15","Kashe Gbozu pa fœ she adœke: «Na zœ, gbambanœ nene, mœ ke yakoshenœ asœmœ tœ uzu akwa nœ mœ, yé kpœpa ye dá ɨ'ɨrɨ mœ œ to lœ ogo nœ angbɨ azu, ɓa utshu agbozugo œdœ pe ndje ɓa utshu azu Israyele. ");
INSERT INTO mnh_vpl VALUES ("AC9_16","074_9_16","ACT","9","16","16","Œmœ dœ tœ mœ, mœ yisœ mara á li dœ she kœwu œrœ kanga mbœrœ ɨ'ɨrɨ mœ.» ");
INSERT INTO mnh_vpl VALUES ("AC9_17","074_9_17","ACT","9","17","17","Anania ro œ li ga lœ anda, œ to kane ye ga pa Sawulo yé œ pa adœke: «Aya mœ, Sawulo! Gbozu dá vwa mœ. Yisu á tshe wuta lima ga tœ zœ tœ ala awa á ɓœ na lima tœnœ, œshe dá vwa mœ adœke ɓœ kpa tondœ osho yé œ gbɔ Ɔtshɔ Ɨshirɨ.» ");
INSERT INTO mnh_vpl VALUES ("AC9_18","074_9_18","ACT","9","18","18","Pe kpœtœ œsœnœ, œrœ ɓata djepe yo lœ ala ye dœ́ Sawulo. Tshe tetœ kœwu osho, œ áalafo yé œ gbɔ batisimu. ");
INSERT INTO mnh_vpl VALUES ("AC9_19","074_9_19","ACT","9","19","19","Manda nœ, tshe zɨ œrœ yeka á uvuru gu ga lœ nœ. Tshe mbœrœ lima olo teasho dœ ayambarœ nœ Yisu á endje sœ lima lœ Damaseke. ");
INSERT INTO mnh_vpl VALUES ("AC9_20","074_9_20","ACT","9","20","20","Œndœ ye dɨdɨ lima nene á tshe tetœ kœpandœ nœ lœ Sinagoga adœke, Yisu kœdœ Gbolo nœ Ndjaba. ");
INSERT INTO mnh_vpl VALUES ("AC9_21","074_9_21","ACT","9","21","21","Endjeneke kɔ á endje sœ lima kœdji she, endje katœ ama endje tɨ ɔsɔ yé œ pa adœke: «Œ dœ́dœ́ yakoshe asœ dá sœ lima kœmbœrœ œrœ kanga fœ azu á endje yindœ ɨ'ɨrɨ Yisu ɓa lœ Yerusaleme nene a? Tshe nana lima ndœ kœi endje dœ djingiri, yé á kœgu dœ endje fœ agbozu tshapa anganga Ndjaba nene a?» ");
INSERT INTO mnh_vpl VALUES ("AC9_22","074_9_22","ACT","9","22","22","Kashe gbɔgbɔ kœyisœ Ɔtshɔ O'o nœ Sawulo gerœ lima dœ pa nœ: ɓata á tshe sœ lima kœma ngbɨ adœke Yisu kœdœ Masiya, Ayuda á endje mbœrœ lima ogo lakpɨ Damaseke kpa gugu lima dœ o'o ndœ kœgi fœ she nene. ");
INSERT INTO mnh_vpl VALUES ("AC9_23","074_9_23","ACT","9","23","23","Œndœnœ dɨ manda nœ œrrr atake, Ayuda vwarandœ upu kœwo she. ");
INSERT INTO mnh_vpl VALUES ("AC9_24","074_9_24","ACT","9","24","24","Kashe Sawulo wusœ kœvwarandœ upu nœ endje asœmœ ye. Endje sœ kœgbɔndœ egerœ manda ongbonœ butshɔ dœ ɔlɔ mbœrœ á endje kœwo she. ");
INSERT INTO mnh_vpl VALUES ("AC9_25","074_9_25","ACT","9","25","25","Dœ anga butshɔ bale, ayambarœ nœ ye za she ga lœ kingi, œ gi she dœ uwu yorrr ga atɨ dja gakele gbagba. ");
INSERT INTO mnh_vpl VALUES ("AC9_26","074_9_26","ACT","9","26","26","Sawulo wuta ɓa lœ Yerusaleme œ yindœ kœli ga ugurutœ ayindœ Yisu, kashe endje kpa lima awa ye kɔ mbœrœ endje yiyi lima ndœ nœ katsha nene adœke tshe te yindœ Yisu. ");
INSERT INTO mnh_vpl VALUES ("AC9_27","074_9_27","ACT","9","27","27","Yé Barnabase za she po tœ ye, œ gi she fœ aayi avwa. Tshe pandœ mara á Sawulo wu Gbozu tœ ala awa œdœ mara á Gbozu pa lima o'o fœ she. Tshe kpa pa ndje fœ endje mara á tshe sœ lima kœyisœ œrœ ngbɨ dœ ɨ'ɨrɨ Yisu ɓa lœ Damaseke. ");
INSERT INTO mnh_vpl VALUES ("AC9_28","074_9_28","ACT","9","28","28","Pe ndœ lɔkɔnœ asœmœ, Sawulo te ga ndœ endje yé endje tetœ kœyisœ œrœ ngbɨ dœ ɨ'ɨrɨ Gbozu lœ Yerusaleme. ");
INSERT INTO mnh_vpl VALUES ("AC9_29","074_9_29","ACT","9","29","29","Tshe pa lima o'o fœ Ayuda á endje sœ kœpa o'o ama Greke yé endje sœ lima kœgbugburu tshelœ o'o dœ endje. Kashe endje sœ lima kœpara awa ndœ kœwo she. ");
INSERT INTO mnh_vpl VALUES ("AC9_30","074_9_30","ACT","9","30","30","Aayanœ lœ Yisu dji o'onœ ataa, œ to she ro tœnœ ga lœ Sezaré yeka á gbɔ awa kœgi she ga lœ Tarse. ");
INSERT INTO mnh_vpl VALUES ("AC9_31","074_9_31","ACT","9","31","31","Azu Ikrizia sœ lima gee lœ ogo Yuda djigi, lœ ogo Galilayi œdœ pe ndje lœ Samariya. Endje sœ lima kœkpa awa Gbozu, yé Ɔtshɔ Ɨshirɨ za lima gbɔgbɔ fœ endje adœke kœyindœrœ nœ endje gerœ. ");
INSERT INTO mnh_vpl VALUES ("AC9_32","074_9_32","ACT","9","32","32","Petro á tshe sœ lima kœro dje lœ ogonœ asœmœ kɔ, na dœ anga ɔlɔ bale ɓa ndœ ayindœ Yisu á endje sœ lima ɓa lœ Lida. ");
INSERT INTO mnh_vpl VALUES ("AC9_33","074_9_33","ACT","9","33","33","Tshe gbɔ anga yakoshe á ɨ'ɨrɨ ye kœdœ Ene á tshe lo ga atɨ dœ koɓa mangba ungu mindu dœ votɔ, gbambanœ nene, ada ye tshu lima tshakudu ye. ");
INSERT INTO mnh_vpl VALUES ("AC9_34","074_9_34","ACT","9","34","34","Petro pa fœ she adœke: «Ene, Yisu Kristu she ɓœ ye. Aalafo œ guma gbarœ olo zœ!» Yé katsha Ene áalafo. ");
INSERT INTO mnh_vpl VALUES ("AC9_35","074_9_35","ACT","9","35","35","Azu kɔ lakpɨ Lida œdœ pe endje nœ akpala osho Sarone wu she ataa, œ fatshalɔsu endje ga ndœ Gbozu. ");
INSERT INTO mnh_vpl VALUES ("AC9_36","074_9_36","ACT","9","36","36","Anga yashe bale sœ lima ɓa lœ Yope, œshe lima kœdœ yindœ Yisu; endje e she lima Tabita. Endje fa tshelœ ɨ'ɨrɨnœ lima dœ o'o ama Greke «Dorkase», œ yindœ kœpa adœke «mbele». Tshe sœ lima kœmbœrœ ɔtshɔrœ waa, yé œ sœ kœto œrœ fœ aayi oyo. ");
INSERT INTO mnh_vpl VALUES ("AC9_37","074_9_37","ACT","9","37","37","Dœ olonœ asœmœ, tshe gbɔ koɓa yé œ tshu. Manda kœdjutɔ she, endje za she ga lœ gbɔshɔ ɓa lafo. ");
INSERT INTO mnh_vpl VALUES ("AC9_38","074_9_38","ACT","9","38","38","Ɓata á tshalakpɨ Lida sœ ndoo dœ Yope, ayindœ Yisu dji lima ndœ nœ adœke Petro sœ lœ Lida, œ vwa azu bisha dœ o'o fœ she adœke: «Vava ada zœ nene, na ga ndœ 'a katsha ga mœ kane.» ");
INSERT INTO mnh_vpl VALUES ("AC9_39","074_9_39","ACT","9","39","39","Petro na ga ndœ endje katsha. Lɔkɔ á tshe wuta ɓa zœ, endje 'ɔ dœ she ɓa lœ gbɔshɔ á sœ ɓa lafo, yé ayashe koya para kɔkɔ ka ga utshu ye dœ ngola lœ ala endje. Endje yisœ lœba okoro œdœ pe yɔgbɔdɔ lœba á Dorkase sœ lima kœmbœrœ tœnœ lɔkɔ á tshe sœ dœ soro. ");
INSERT INTO mnh_vpl VALUES ("AC9_40","074_9_40","ACT","9","40","40","Petro gɔrɔ azu ga shu para kɔkɔ œ gote dœ matshukuda ye, yé œ kɨ fœ Ndjaba. Manda nœ, tshe fatœ ye yorrr ga tœ oko uzunœ, œ pa adœke: «Tabita, áalafo.» Tshe kɔrɔ ala ye œ tondœ Petro, œ yɔrɔtshelœtœ ye yé œ sœ ga atɨ dœ budu ye. ");
INSERT INTO mnh_vpl VALUES ("AC9_41","074_9_41","ACT","9","41","41","Petro bopa kane ye œ tɨ she ga lafo, yé œ e ayindœ Yisu œdœ pe ayashe koya yeka á ma she dœ soro fœ endje. ");
INSERT INTO mnh_vpl VALUES ("AC9_42","074_9_42","ACT","9","42","42","Endje dji o'onœ lœ ongbo Yope djigi, yé azu ndjoro fatshalɔsu endje ga ndœ Gbozu. ");
INSERT INTO mnh_vpl VALUES ("AC9_43","074_9_43","ACT","9","43","43","Petro lo olo ndjoro ɓa lakpɨ Yope ɓa ndœ Shimu á tshe dœ ayi kœguma ɔkɔ agea. ");
INSERT INTO mnh_vpl VALUES ("AC10_1","074_10_1","ACT","10","1","1","Anga yakoshe bale ɓa lœ Sezaré, ɨ'ɨrɨ ye kœdœ Korneye; œshe kœdœ gbozu tshapa ukpulu aturugu lœ Roma á endje e tœnœ «ukpulu aturugu tshelœ Itali». ");
INSERT INTO mnh_vpl VALUES ("AC10_2","074_10_2","ACT","10","2","2","Tshe sœ dœ kœyindœrœ ga ndœ Ndjaba, œ sœ kœkpa awa ye awa bale ndje dœ azu tshasœnda nœ ye. Dœ tœnœ ataa, tshe sœ lima kœto œrœ fœ Ayuda á endje sœ lima dœ oyo, yé œ sœ ndje kœkɨ lima fœ Ndjaba ɔlɔ dœ ɔlɔ. ");
INSERT INTO mnh_vpl VALUES ("AC10_3","074_10_3","ACT","10","3","3","Anga ɔlɔ bale, dœ ada ɔlɔ votɔ manda kakpi ɔlɔ, tshe wu andjelu nœ Ndjaba lœ ulu kœli ga ndœ ye, yé andjelunœ e she adœke: «Korneye!» ");
INSERT INTO mnh_vpl VALUES ("AC10_4","074_10_4","ACT","10","4","4","Korneye tondœ ye dœ awa, yé œ gi fœ she adœke: «O'o gaɗe, Gbozu?» Andjelu pa fœ she adœke: «Ndjaba dji avwala nœ zœ œdœ pe ɔtshɔrœ á ɓœ sœ kœmbœrœ tœnœ fœ aayi oyo yé tshe djedjerœndœ zœ nene. ");
INSERT INTO mnh_vpl VALUES ("AC10_5","074_10_5","ACT","10","5","5","Ngɔngɔ asœke, vwa azu ɓa lakpɨ Yope kœ'e Shimu á anga ɨ'ɨrɨ ye kœdœ Petro gu tœnœ ga mœ. ");
INSERT INTO mnh_vpl VALUES ("AC10_6","074_10_6","ACT","10","6","6","Tshe sœ kœlo ɓa ndœ anga ayi akwa kœguma ɔkɔ agea á ɨ'ɨrɨ ye kœdœ Shimu; á anda nœ ye sœ ɓa tœ ama egerœ ungu.» ");
INSERT INTO mnh_vpl VALUES ("AC10_7","074_10_7","ACT","10","7","7","Lɔkɔ má andjelu á tshe pa o'o fœ she yiwa, Korneye e anga aayi akwa nœ ye bisha œdœ pe anga turugu nœ ɔtshɔ lɔsu á tshe sœ tshakudu ye katshatsha. ");
INSERT INTO mnh_vpl VALUES ("AC10_8","074_10_8","ACT","10","8","8","Tshe yisœ œrœ kɔ á mbœrœtœ ye fœ endje, yé œ vwa endje ɓa lakpɨ Yope. ");
INSERT INTO mnh_vpl VALUES ("AC10_9","074_10_9","ACT","10","9","9","Osho kɔrɔ pa nœ, endje sœpe tœ awa kœro tœnœ œ wuta ndoo dœ Yope, Petro ɔ ga tœ akpala osho ɓa pa kumu anda mbœrœ kœza avwala fœ Ndjaba. Ɔlɔ wuta lima ga pa œrœ nœ́ kakpi ɔlɔ. ");
INSERT INTO mnh_vpl VALUES ("AC10_10","074_10_10","ACT","10","10","10","Kashe tshe sœ lima dœ ogo, yé œ yindœ kœzɨ œrœ. Lɔkɔ á endje sœ lima kœfa kœzɨrœ fœ she, tshe wu œrœ lœ ulu. ");
INSERT INTO mnh_vpl VALUES ("AC10_11","074_10_11","ACT","10","11","11","Tshe wu tshalafo kɔrɔ yé anga œrœ ɓata egerœ lœba tshapa meza á endje du uwu ga tœ amanœ vavana kɔ sœ kœjerœ ga atɨ. ");
INSERT INTO mnh_vpl VALUES ("AC10_12","074_10_12","ACT","10","12","12","Yé agea kɔ á ada endje sœ vana, endjeneke á endje sœ kœ'ɔrɔ dœ lavu endje tœ ɔshɔ œdœ pe endjeneke á endje sœ kœru ɓa lafo, sœ lima ɓa lœ nœ. ");
INSERT INTO mnh_vpl VALUES ("AC10_13","074_10_13","ACT","10","13","13","Tshe dji tshama uzu kœpa fœ she adœke: «Petro! Áafo, œ wo ageanœ asœ yé œ zɨ endje.» ");
INSERT INTO mnh_vpl VALUES ("AC10_14","074_10_14","ACT","10","14","14","Petro gi fœ she adœke: «Bale nene, Gbozu. Mbœrœ lœ soro mœ, mœ zɨzɨ œrœ uburu too ekperœ nene.» ");
INSERT INTO mnh_vpl VALUES ("AC10_15","074_10_15","ACT","10","15","15","Tshe kpa dji tshama uzu kœpa fœ she tœ bishanœ adœke: «Œneke á Ndjaba mbœrœ yerœ, œ lili dœ ɓœ kœpa adœke œtœnœ kœdœ œrœ uburu nene.» ");
INSERT INTO mnh_vpl VALUES ("AC10_16","074_10_16","ACT","10","16","16","Tshamanœ wu awa votɔ yé katsha manda nœ, œrœnœ ɔ ga lafo. ");
INSERT INTO mnh_vpl VALUES ("AC10_17","074_10_17","ACT","10","17","17","Petro sœ kœyutœ ye tœ ádá œrœ á tshe wu lœ ulu atake, tshokombele azu á Korneye vwa endje á endje sœ kœyu osho djezœ djezœ tœ anda nœ Shimu, kœyi kumu endje ga pa egerœ manda gbagba. ");
INSERT INTO mnh_vpl VALUES ("AC10_18","074_10_18","ACT","10","18","18","Endje e osho yé, œ yu adœke: «Shimu á anga ɨ'ɨrɨ ye kœdœ Petro sœ kœlo kpœke a?» ");
INSERT INTO mnh_vpl VALUES ("AC10_19","074_10_19","ACT","10","19","19","Petro sœpe lima kolœ kœgbe tshelœ ye tœ œrœ á tshe wu lœ ulu asœmœ, kashe Ɨshirɨ pa fœ she adœke: «Wu, azu votɔ á endje sœ kœpara ɓœ asœke. ");
INSERT INTO mnh_vpl VALUES ("AC10_20","074_10_20","ACT","10","20","20","Aafo œ Jerœ yé œ gu tœ awanœ bale dœ endje. Awa zaza ɓœ nene mbœrœ œmœ dá vwa endje.» ");
INSERT INTO mnh_vpl VALUES ("AC10_21","074_10_21","ACT","10","21","21","Petro jerœ ga ndœ endje, œ pa fœ endje adœke: «Œmœ dœke. Uzunœ á 'e sœ kœpara she kœdœ œmœ. 'E na ndœ gaɗe?» ");
INSERT INTO mnh_vpl VALUES ("AC10_22","074_10_22","ACT","10","22","22","Endje gi fœ she adœke: «Gbozu tshapa ukpulu aturugu á ɨ'ɨrɨ ye kœdœ Korneye dá vwa 'a. Œshe kœdœ ɔtshɔ uzu á tshe sœ kœkpawa Ndjaba, yé Ayuda para kɔkɔ yindœ ye waa. Anga andjelu nœ Ndjaba bale dá pandœ nœ fœ she lœ ulu adœke tshe 'e ɓœ ɓa lœ anda nœ ye á kœdji œneke á ɓœ pa fœ she.» ");
INSERT INTO mnh_vpl VALUES ("AC10_23","074_10_23","ACT","10","23","23","Petro pa adœke endje li gasœnda, yé œ yisœ osho olo fœ endje. Osho kɔrɔ pa nœ bale, tshe gu tœ awanœ dœ endje. Anga ayindœ Yisu lakpɨ Yope gu tœ awanœ dœ endje. ");
INSERT INTO mnh_vpl VALUES ("AC10_24","074_10_24","ACT","10","24","24","Yé tœ bisha olo manda nœ, tshe wuta ga lœ Sezaré. Dá asœmœ ɓa ndœ Korneye, tshe e ayo nœ ye œdœ pe anganœ á tshe yindœtœ ye dœ endje waa, yeka á endje sœ lima kœkate endje. ");
INSERT INTO mnh_vpl VALUES ("AC10_25","074_10_25","ACT","10","25","25","Lɔkɔ á Petro yi kumu ye, Korneye na para tshatshu ye œ gote ga tœ ada ye mbœrœ kœma ɔtshɔ lɔsu ga ndœ ye. ");
INSERT INTO mnh_vpl VALUES ("AC10_26","074_10_26","ACT","10","26","26","Petro pa fœ she dœ kœtɨ she ga lafo adœke: «Aalafo, œmœ ndje kœdœ amba uzu gbambanœ.» ");
INSERT INTO mnh_vpl VALUES ("AC10_27","074_10_27","ACT","10","27","27","Manda nœ, tshe sœ kœpu o'o dœ Korneye li tœnœ ga sœnda, tshe wu azu ndjoro á endje ngbɔtœ endje ɓa zœ. ");
INSERT INTO mnh_vpl VALUES ("AC10_28","074_10_28","ACT","10","28","28","Tshe pa ngbɨ fœ endje adœke: «Ɓata á 'e wusœ nœ, œ sœ dœ ekpenœ adœke Ayuda yindœ angbɨ uzu too kœsœ dœ she tœ œsœnœ bale. Kashe Ndjaba má fœ mœ adœke, mœ papa fœ uzu bale adœke œshe kœdœ ayi uburu too adœke Ndjaba vwaratœ ye tœ ye nene. ");
INSERT INTO mnh_vpl VALUES ("AC10_29","074_10_29","ACT","10","29","29","Mbœrœ tœnœ ataa dá mœ vwavwaratœ mœ kœna ga mœ lɔkɔ á ɓœ vwa osho ndœ mœ nene. Kashe ngɔngɔ asœke, mœ yindœ kœwusœ ádá á ɓœ 'e mœ ga mœ.» ");
INSERT INTO mnh_vpl VALUES ("AC10_30","074_10_30","ACT","10","30","30","Korneye kœgi fœ she adœke: «Mœ sœ lima kœza avwala fœ Ndjaba ɓa sœnda nœ mœ, œ mbœrœ lima olo votɔ dœ ada ɔlɔ votɔ manda kakpi ɔlɔ. Mœ sœ atake, anga uzu bale á tshe verœ imbi lœba uruuu ka ga utshu mœ, ");
INSERT INTO mnh_vpl VALUES ("AC10_31","074_10_31","ACT","10","31","31","yé œ pa fœ mœ adœke: “Korneye, Ndjaba dji avwala nœ zœ yé œ djedjerœndœ œrœ á ɓœ to lima fœ aayi oyo nene. ");
INSERT INTO mnh_vpl VALUES ("AC10_32","074_10_32","ACT","10","32","32","Vwa anga uzu ɓa lœ Yope kœ'e Shimu á anga ɨ'ɨrɨ ye kœdœ Petro kœgu ɓa ke. Tshe sœ kœlo ɓa sœnda nœ Shimu, ayi kœguma ɔkɔ agea á anda nœ ye sœ ɓa tœ mangu egerœ ungu.” ");
INSERT INTO mnh_vpl VALUES ("AC10_33","074_10_33","ACT","10","33","33","Mœ vwa uzu ndœ kœpara ɓœ, yé ɓœ yindœ kœna tœnœ dœ ɔtshɔnœ. Ngɔngɔ asœke, a'a kɔ 'a ka ga utshu Ndjaba mbœrœ kœdji œneke á Gbozu za awa fœ ɓœ adœke ɓœ pandœ nœ fœ 'a.» ");
INSERT INTO mnh_vpl VALUES ("AC10_34","074_10_34","ACT","10","34","34","Yé Petro za o'o œ pa adœke: «Mœ wu adja sœ nœ ngɔngɔ asœ adœke Ndjaba keke azu mbœrœ tshatshu endje nene. ");
INSERT INTO mnh_vpl VALUES ("AC10_35","074_10_35","ACT","10","35","35","Yé lœ ogo kɔ, uzu á tshe sœ kœkpawa Ndjaba yé á sœ kœmbœrœ œrœ á sœ ndjii, Ndjaba œ yindœ ye. ");
INSERT INTO mnh_vpl VALUES ("AC10_36","074_10_36","ACT","10","36","36","Tshe vwa o'o fœ azu tshelœ Israyele, Ɔtshɔ O'o kœsœ gee lœ awa nœ Yisu Kristu á tshe dœ Gbozu nœ azu kɔ. ");
INSERT INTO mnh_vpl VALUES ("AC10_37","074_10_37","ACT","10","37","37","«'E wusœ œneke á wuta lima utshunœ ɓa lœ Galilayi, lœ ogo Yuda djigi dœ lɔkɔ á Yowane sœ lima kœyisœ œrœ, á sœ ndje kœza batisimu fœ azu. ");
INSERT INTO mnh_vpl VALUES ("AC10_38","074_10_38","ACT","10","38","38","'E wusœ mara á Ndjaba to gbɔgbɔ nœ Ɔtshɔ Ɨshirɨ fœ Yisu á tshe dœ uzu Nazarete. Tshe na djetœ osho kɔ dœ kœmbœrœ ɔtshɔrœ, tshe she endjeneke para á endje dœ lima akanga nœ djaboro, mbœrœ Ndjaba sœ lima awa bale dœ she. ");
INSERT INTO mnh_vpl VALUES ("AC10_39","074_10_39","ACT","10","39","39","«Yé a'a, 'a kœdœ atimu nœ œrœ kɔ á tshe mbœrœ ɓa lœ ogo nœ Ayuda œdœ ɓa lœ Yerusaleme. Endje wo she œ kuru she ga pa kurushi. ");
INSERT INTO mnh_vpl VALUES ("AC10_40","074_10_40","ACT","10","40","40","Kashe Ndjaba she she ugurutœ akuzu manda olo votɔ, yé œ to uvuru fœ she adœke tshe kpa matœ ye. ");
INSERT INTO mnh_vpl VALUES ("AC10_41","074_10_41","ACT","10","41","41","Œ dœ́dœ́ mbœrœ azu djigi nene, kashe fœ 'a á Ndjaba ke 'a katshatsha utshunœ ɓata atimu. 'A zɨ œrœ œ ndjo œrœ awa bale dœ she manda kœshe she ugurutœ akuzu. ");
INSERT INTO mnh_vpl VALUES ("AC10_42","074_10_42","ACT","10","42","42","Mbœrœ tœnœ ataa, tshe pa fœ 'a adœke 'a yisœ nœ fœ azu yé œ ma ndœlanœ fœ endje adœke, œshe dá Ndjaba za she ndœ kœwa ngbanga pa asoro œdœ akuzu. ");
INSERT INTO mnh_vpl VALUES ("AC10_43","074_10_43","ACT","10","43","43","Aayi kœgbara o'o kɔ pa lima tœ ye adœke uzu kɔ á tshe sœ dœ kœyindœrœ ga ndœ Yisu, lœ gbɔgbɔ nœ ɨ'ɨrɨ ye dœ́ Yisu dá Ndjaba œ djerœndœ ekperœ nœ ye.» ");
INSERT INTO mnh_vpl VALUES ("AC10_44","074_10_44","ACT","10","44","44","Lɔkɔ á Petro sœpe lima kœpu o'o, Ɔtshɔ Ɨshirɨ jerœ ga pa endjeneke kɔ á endje dji lima o'o ye. ");
INSERT INTO mnh_vpl VALUES ("AC10_45","074_10_45","ACT","10","45","45","Ayindœ Yisu á endje kœdœ Ayuda á endje na lima tœ awanœ dœ Petro ka lima tœ ama endje tɨ ɔsɔ kœwu adœke: Ɔtshɔ Ɨshirɨ á Ndjaba vwa, jerœ ndje lima ga pa angbɨ azu. ");
INSERT INTO mnh_vpl VALUES ("AC10_46","074_10_46","ACT","10","46","46","Yé endje sœ lima kœdji angbɨ azunœ kœdonga Ndjaba ndje kœpa o'o ama ogo á endje sœsœ lima kœdji tœnœ nene. Petro kpa kœpa adœke: ");
INSERT INTO mnh_vpl VALUES ("AC10_47","074_10_47","ACT","10","47","47","«Ɓata á azu asœke gbɔ ndje Ɔtshɔ Ɨshirɨ ɓata azœ, œɗe dá kpa kɔ endje tœ kœgbɔ batisimu dœ ungu a?» ");
INSERT INTO mnh_vpl VALUES ("AC10_48","074_10_48","ACT","10","48","48","Tshe za o'o adœke endje za batisimu fœ endje dœ ɨ'ɨrɨ Yisu Kristu. Manda nœ, angbɨ azunœ yu she adœke œne yatœ œne dœ she manda olo teasho kane. ");
INSERT INTO mnh_vpl VALUES ("AC11_1","074_11_1","ACT","11","1","1","Aayi avwa œdœ ayindœ Yisu á endje sœ lima ɓa lœ Yuda dji adœke angbɨ azu yi ndje ndœ o'o ama Ndjaba. ");
INSERT INTO mnh_vpl VALUES ("AC11_2","074_11_2","ACT","11","2","2","Lɔkɔ á Petro ɔ ga lœ Yerusaleme, anga ayindœ Yisu á endje dœ́ Ayuda, tetœ kœgbugburu tshelœ o'o dœ she ");
INSERT INTO mnh_vpl VALUES ("AC11_3","074_11_3","ACT","11","3","3","adœke: «Ɓœ li ga ndœ angbɨ azu yé œ zɨ œrœ dœ endje!» ");
INSERT INTO mnh_vpl VALUES ("AC11_4","074_11_4","ACT","11","4","4","Yé Petro pandœ œneke kɔ á ro, kœto ɓa tœ adanœ bale dœ bale fœ endje adœke: ");
INSERT INTO mnh_vpl VALUES ("AC11_5","074_11_5","ACT","11","5","5","«Lɔkɔ á mœ sœ lima kœkɨ fœ Ndjaba ɓa lakpɨ Yope, mœ wu œrœ lœ ulu: anga œrœ bale ɓata egerœ lœba tshapa meza á endje du uwu ga tœ amanœ vavana kɔ. Œrœnœ asœmœ to ɓa lafo, œ jerœ ga atɨ ndɔɔ ndoo dœ mœ. ");
INSERT INTO mnh_vpl VALUES ("AC11_6","074_11_6","ACT","11","6","6","Mœ to lima ndœ nœ yima yé œ wu agea gusu á ada endje sœ vana, endjeneke á endje ɔrɔ dœ lavu endje œdœ pe endjeneke á endje ru ɓa lafo. ");
INSERT INTO mnh_vpl VALUES ("AC11_7","074_11_7","ACT","11","7","7","Manda nœ, mœ dji tshama uzu kœpa fœ mœ adœke: “Petro! Aalafo, œ wo agea asœke yé œ zɨ endje.” ");
INSERT INTO mnh_vpl VALUES ("AC11_8","074_11_8","ACT","11","8","8","Yé mœ pa adœke: “Bale nene, Gbozu. Gbambanœ nene, lœ soro mœ, mœ zɨzɨ œrœ uburu too ekperœ nene.” ");
INSERT INTO mnh_vpl VALUES ("AC11_9","074_11_9","ACT","11","9","9","«Tœ bishanœ, tshama uzu to ɓa lafo adœke: “Œneke á Ndjaba mbœrœ yerœ, œ lili dœ ɓœ kœpa adœke œtœnœ kœdœ uburu nene.” ");
INSERT INTO mnh_vpl VALUES ("AC11_10","074_11_10","ACT","11","10","10","Œrœnœ wu ata awa votɔ, yé œ ɔ ga lafo. ");
INSERT INTO mnh_vpl VALUES ("AC11_11","074_11_11","ACT","11","11","11","Yé tshokombele, azu tshelœ Sezaré votɔ yi kumu endje ɓa tœ anda á 'a sœ tœnœ. Endje na ndœ kœpara mœ. ");
INSERT INTO mnh_vpl VALUES ("AC11_12","074_11_12","ACT","11","12","12","Ɔtshɔ Ɨshirɨ pa fœ mœ adœke mœ gu katsha tœ awanœ dœ endje. Ayakoshenœ mindu dœ bale á mœ to endje rotœnœ ga mœ asœke, 'a na tœ awanœ dœ endje œrrr ɓa lœ Sezaré yé œ li dœ endje kɔ ga lœ anda nœ yakoshenœ asœmœ á ɨ'ɨrɨ ye kœdœ Korneye. ");
INSERT INTO mnh_vpl VALUES ("AC11_13","074_11_13","ACT","11","13","13","Tshe pandœ mara á andjelu wuta ga tœ ye ɓa sœnda yé á pa fœ she adœke: “Vwa anga uzu ɓa lœ Yope kœ'e Shimu á anga ɨ'ɨrɨ ye kœdœ Petro, tshe gu ɓa ke. ");
INSERT INTO mnh_vpl VALUES ("AC11_14","074_11_14","ACT","11","14","14","Tshe pandœ o'o á za kœshe fœ ɓœ dœ azu tshasœnda nœ zœ kɔ.” ");
INSERT INTO mnh_vpl VALUES ("AC11_15","074_11_15","ACT","11","15","15","«Lɔkɔ á mœ sœ kœpa o'o, Ɔtshɔ Ɨshirɨ jerœ ga pa endje ɓata á jerœ lima utshunœ ga pa azœ. ");
INSERT INTO mnh_vpl VALUES ("AC11_16","074_11_16","ACT","11","16","16","Mœ gbe tshelœ mœ ndœ o'o á Gbozu pa lima adœke: “Yowane za lima batisimu nœ ungu, kashe e'e, 'e gbɔ batisimu lœ Ɔtshɔ Ɨshirɨ.” ");
INSERT INTO mnh_vpl VALUES ("AC11_17","074_11_17","ACT","11","17","17","Œdœ Ndjaba kœto ɔtshɔrœ fœ azunœ asœke ɓata á tshe to fœ azœ á ayindœ o'o Gbozu Yisu Kristu, œmœ kœdœ œɗe yeka á kɔ Ndjaba tœ kœmbœrœ œrœ a?» ");
INSERT INTO mnh_vpl VALUES ("AC11_18","074_11_18","ACT","11","18","18","Manda kœdji o'onœ asœmœ, endje sœ koko yé œ za mokɔ fœ Ndjaba dœ kœpa adœke: «Adjapu, Ndjaba to ndje awa kœfatshalɔsu œdœ pe awa kœgbɔ soro fœ angbɨ azu.» ");
INSERT INTO mnh_vpl VALUES ("AC11_19","074_11_19","ACT","11","19","19","Œrœ kanga á mbœrœtœ endje lima dœ lɔndɔ á endje wo lima Etiene, mbœrœ adœke ayindœ Yisu ndjɔ lima tshelœtœ endje ngbangbangba djezœ. Anga endje ro lima ga lœ Fenisi, ga lœ Shipre œdœ ga lœ Atiɔshe; kashe endje sœ lima kœyisœ Ɔtshɔ O'o nœ Ndjaba kolœ fœ Ayuda. ");
INSERT INTO mnh_vpl VALUES ("AC11_20","074_11_20","ACT","11","20","20","Andaa, anga endje ugurutœ endje á endje kœdœ azu tshelœ Shipre œdœ Sirene, endje na ɓa lœ Atiɔshe yé œ yi ndje sœ Ɔtshɔ O'o nœ Gbozu Yisu fœ Agreke. ");
INSERT INTO mnh_vpl VALUES ("AC11_21","074_11_21","ACT","11","21","21","Gbɔgbɔ nœ Gbozu sœ lima dœ endje awa bale dœ mara adœke azu ndjoro fatœ endje ga ndœ Gbozu yé œ wuta ayindœ Yisu. ");
INSERT INTO mnh_vpl VALUES ("AC11_22","074_11_22","ACT","11","22","22","Azu Ikrizia lœ Yerusaleme dji o'onœ, yé œ vwa Barnabase ɓa lœ Atiɔshe. ");
INSERT INTO mnh_vpl VALUES ("AC11_23","074_11_23","ACT","11","23","23","Lɔkɔ á Barnabase yi kumu ye á wu mara ɔtshɔrœ á Ndjaba mbœrœ fœ ayindœ Yisunœ asœmœ, tshe sœ dœ yanga yé œ pa fœ endje kɔ adœke endje za lɔsu endje djigi fœ Gbozu. ");
INSERT INTO mnh_vpl VALUES ("AC11_24","074_11_24","ACT","11","24","24","Barnabase kœdœ ɔtshɔ uzu, tshe sœ dœ Ɔtshɔ Ɨshirɨ œdœ pe kœyindœrœ waa. Ukpulu azu ndjoro te lima azu nœ Gbozu. ");
INSERT INTO mnh_vpl VALUES ("AC11_25","074_11_25","ACT","11","25","25","Manda nœ, Barnabase na kœpara Sawulo ɓa lœ Tarse. ");
INSERT INTO mnh_vpl VALUES ("AC11_26","074_11_26","ACT","11","26","26","Tshe gbɔ she ɓa zœ œ gu dœ she ga lœ Atiɔshe. Endje bibisha, endje mbœrœ lima ungu bale ɓa lœ Ikrizianœ asœmœ yé œ yisœ œrœ fœ azu ndjoro. Ɓa lœ Atiɔshe dá endje e ɨ'ɨrɨ «Akristu» tœ alinœ ga tœ ayindœ Yisu. ");
INSERT INTO mnh_vpl VALUES ("AC11_27","074_11_27","ACT","11","27","27","Dœ lɔkɔnœ asœmœ, anga aayi kœgbara o'o to ɓa lœ Yerusaleme œ sœ kœna ga lœ Atiɔshe. ");
INSERT INTO mnh_vpl VALUES ("AC11_28","074_11_28","ACT","11","28","28","Anga bale á ɨ'ɨrɨ ye kœdœ Agabuse, á Ɔtshɔ Ɨshirɨ sœ kœma œrœ fœ she, mɨndœ nœ adœke egerœ ogo œ za tshapashɔ djigi lœ ondonœ zœ. Manda nœ, œ mbœrœtœ endje lima dœ lɔndɔ á Klode dœ lima gbozugo Roma. ");
INSERT INTO mnh_vpl VALUES ("AC11_29","074_11_29","ACT","11","29","29","Mbœrœ tœnœ ataa, ayindœ Yisu wa o'o adœke œne vwa œrœ fœ anga œne á endje sœ ɓa lœ Yuda. Uzu dœ uzu œ to liaka gbɔgbɔ nœ ye. ");
INSERT INTO mnh_vpl VALUES ("AC11_30","074_11_30","ACT","11","30","30","Endje mbœrœ lindœ œneke á endje wa, yé œ vwa œrœ á endje gbɔ, lœ awa nœ Abarnabase dœ Sawulo fœ agbozu lœ ogo Yuda. ");
INSERT INTO mnh_vpl VALUES ("AC12_1","074_12_1","ACT","12","1","1","Dœ lɔndɔnœ asœmœ, gbozugo Erode sœ lima kœmbœrœ œrœ kanga fœ anga azu Ikrizia. ");
INSERT INTO mnh_vpl VALUES ("AC12_2","074_12_2","ACT","12","2","2","Tshe mbœrœ adœke endje wo Jake, aya Yowane, dœ ugu kamba. ");
INSERT INTO mnh_vpl VALUES ("AC12_3","074_12_3","ACT","12","3","3","Yé lɔkɔ á tshe wu adœke œrœ má œne mbœrœ za yanga fœ Ayuda waa, tshe kpa pa adœke, endje za Petro. Œ sœ lima dœ lɔkɔ angbo nœ mapa á susuku nene. ");
INSERT INTO mnh_vpl VALUES ("AC12_4","074_12_4","ACT","12","4","4","Tshe bopa ye œ vwi she ga lœ kánga, yé œ pa fœ ukpulu aturugu vana á ngbɔɓa aturugu vana vana, mbœrœ kœgbɔndœ ye. Tshe sœ kœgbe lima adœke manda angbo Pake yeka á œne kœdji she ɓa utshu azu para kɔkɔ. ");
INSERT INTO mnh_vpl VALUES ("AC12_5","074_12_5","ACT","12","5","5","Endje gbɔ lima ndœ Petro ɓa lœ kánga, kashe azu Ikrizia kaka lima tœ kœza avwala dœ ɨ'ɨrɨ ye fœ Ndjaba nene. ");
INSERT INTO mnh_vpl VALUES ("AC12_6","074_12_6","ACT","12","6","6","Erode yi lima ndœ kœwa ngbanga nœ ye tœ ala azu para kɔkɔ. Dœ butshɔnœ asœmœ, Petro lo ɓa ugurutœ aturugu bisha, endje i she vwagbagba dœ djingiri bisha yé aayi kœgbɔndœ manda ka ɓa utshu manda kánganœ. ");
INSERT INTO mnh_vpl VALUES ("AC12_7","074_12_7","ACT","12","7","7","Kashe tshokombele, andjelu nœ Gbozu yikumu ye, yé ɨshirɨ owo za osho djigi. Andjelu turutœ ye œ jo she, á pa fœ she adœke: «Aalafo katsha!» Djingirinœ kœzu tœ kane Petro. ");
INSERT INTO mnh_vpl VALUES ("AC12_8","074_12_8","ACT","12","8","8","Yé andjelu kpa pa fœ she adœke: «I uwu tshapa lœba nœ zœ, œ soro uwu œrada nœ zœ.» Petro mbœrœtœ ye lindœ o'o ye. Andjelu kpa pa adœke: «Verœ yɔgbɔdɔ lœba nœ zœ yé œ te manda mœ.» ");
INSERT INTO mnh_vpl VALUES ("AC12_9","074_12_9","ACT","12","9","9","Petro wuta lœ kánga œ te manda andjelu. Tshe gbe œnœ ye adœke œneke á andjelu mbœrœ asœmœ dœ́dœ́ adja œrœ nene, kashe œne wu œrœ lœ ulu. ");
INSERT INTO mnh_vpl VALUES ("AC12_10","074_12_10","ACT","12","10","10","Endje ro ali azu kœgbɔndœ manda, manda nœ endje ro bisha endje yé œ wuta ga tœ manda yarakowo á wuta kpuru ga lœ ongbo: mandanœ kɔrɔ dœ tœ ye utshu endje. Lɔkɔ á endje wuta ga shu, endje ro tshatœ ama gbɔlɔ, yé tɨtɨvwɨrɨ andjelu kœyiwa ye. ");
INSERT INTO mnh_vpl VALUES ("AC12_11","074_12_11","ACT","12","11","11","Uvuru Petro kœkwa ga lœ nœ, á tshe kœpa adœke: «Ngɔngɔ asœke, mœ wu adœke œ dœ́ adjapu: Gbozu vwa andjelu nœ ye á tshe vwara mœ tshakane Erode dœ pe lœma ekperœ á Ayuda guma ndœ mœ.» ");
INSERT INTO mnh_vpl VALUES ("AC12_12","074_12_12","ACT","12","12","12","Manda kœgbe tshelœ ye tœ œneke á mbœrœ fœ she, tshe gu ga lœ anda nœ Mareya, ayi Yowane á anga ɨ'ɨrɨ ye kœdœ Marke. Azu ndjoro sœ lima kœdonga Ndjaba ɓa zœ. ");
INSERT INTO mnh_vpl VALUES ("AC12_13","074_12_13","ACT","12","13","13","Lɔkɔ á tshe nge manda, anga yawuru akwa bale á ɨ'ɨrɨ ye kœdœ Rode, na mbœrœ kœkɔrɔ tœnœ. ");
INSERT INTO mnh_vpl VALUES ("AC12_14","074_12_14","ACT","12","14","14","Tshe dji tshama Petro œ sœ dœ yanga, œ tshapu kœkɔrɔ manda, yé œ kpa dœ ɔrɔ mbœrœ kœpandœ nœ adœke, Petro ka ɓa pa manda ɓa shu. ");
INSERT INTO mnh_vpl VALUES ("AC12_15","074_12_15","ACT","12","15","15","Endje pa fœ she adœke: «Iyi sœ lœ kumu zœ a!» Kashe tshe pa fœ endje adœke, œneke á œne sœ kœpa fœ endje kœdœ adjapu. Á endje kœpa adœke: «Asœmœ kœdœ andjelu á tshe sœ kœgbɔndœ Petro dœmœ.» 16 ");
INSERT INTO mnh_vpl VALUES ("AC12_16","074_12_16","ACT","12","16","16","Petro sœpe kolœ kœnge manda. Lɔkɔ á endje kɔrɔ manda, endje wu she yé œ i gbɔndjuru. ");
INSERT INTO mnh_vpl VALUES ("AC12_17","074_12_17","ACT","12","17","17","Tshe mbœrœ kane ye fœ endje adœke endje sœ koko, yé œ pandœ mara á Gbozu za she ga shu lœ kánga fœ endje. Tshe kpa pa adœke: «'E na œ pandœ nœ fœ Jake œdœ pe fœ anga ayindœ Yisu.» Manda nœ, tshe wuta yé œ na ga tœ angbɨ osho. ");
INSERT INTO mnh_vpl VALUES ("AC12_18","074_12_18","ACT","12","18","18","Osho kɔrɔ, aturugu yakatœ endje ngbangbangba. Endje tetœ kœyutœ endje lœtœ endje adœke Petro fatœ ye tœ ɗe! ");
INSERT INTO mnh_vpl VALUES ("AC12_19","074_12_19","ACT","12","19","19","Erode vwa azu kœpara Petro œrrr toroboka, endje gbɔ gbɔ she nene. Tshe yu aayi kœgbɔndœ manda kánganœ, yé á pa adœke endje wo endje ye. Manda nœ, Erode to ɓa lœ ogo Yuda œ na ga lœ Sezaré, yé œ mbœrœ olo teasho ɓa zœ. ");
INSERT INTO mnh_vpl VALUES ("AC12_20","074_12_20","ACT","12","20","20","Erode sœ lima dœ geda dœ azu ogo Tire œdœ azu ogo Sidona. Azu ogonœ bibisha asœke yindœ kœwuta ga utshu ye. Endje u Blastuse á tshe dœ uzu tshapa ayi akwa nœ Erode, œ dji o'o tshelœ ye. Endje na kœyu Erode adœke tshe mbœrœ adœke œne sœ gee. Gbambanœ nene, ogo nœ endje gbɔ œrœ kœto ɓa lœ œnœ ye dœ gbozugo. ");
INSERT INTO mnh_vpl VALUES ("AC12_21","074_12_21","ACT","12","21","21","Dœ lɔkɔnœ á endje guma tœ kœgbɔtœ endje, Erode verœ lœba tshagbozu nœ ye, œ sœ ga pa ngande gbozu nœ ye, yé œ tetœ kœpu o'o ɓa utshu azu kɔ. ");
INSERT INTO mnh_vpl VALUES ("AC12_22","074_12_22","ACT","12","22","22","Azu tetœ kœta rawa adœke: «Asœ kœdœ tshama ndjaba, œ dœ́dœ́ œnœ uzu nene!» ");
INSERT INTO mnh_vpl VALUES ("AC12_23","074_12_23","ACT","12","23","23","Kashe, pe tœ œsœnœ, andjelu nœ Gbozu ɓi Erode mbœrœ á tshe tshapu kœdonga Ndjaba tɨ, yé á sœ kœlɨsœtœ ye adœke œne kœdœ Ndjaba. Angɔzu zɨ she lœ ɔkɔnœ yé tshe tshu. ");
INSERT INTO mnh_vpl VALUES ("AC12_24","074_12_24","ACT","12","24","24","O'o ama Ndjaba ka aka osho kɔ, yé azu á endje yindœ nœ wuta lima ndjoro. ");
INSERT INTO mnh_vpl VALUES ("AC12_25","074_12_25","ACT","12","25","25","Lɔkɔ á akwa nœ Abarnabase dœ Sawulo ka lima lœ Yerusaleme, endje za lima Yowane á anga ɨ'ɨrɨ ye kœdœ Marke potœ endje á gu dœ she. ");
INSERT INTO mnh_vpl VALUES ("AC13_1","074_13_1","ACT","13","1","1","Aayi kœgbara o'o œdœ aayi kœyisœrœ sœ lima ɓa lœ Ikrizia nœ Atiɔshe. Œ dœ lima Barnabase, Shimeyo á anga ɨ'ɨrɨ ye kœdœ Ubu Uzu œdœ pe Lukiyuse uzu tshelœ Sirene, dœ Sawulo œ ga ndœ Manaene yanga Erode á tshe sœ lima kœna tœ awanœ dœ she pe dœ tshagbolo ye. ");
INSERT INTO mnh_vpl VALUES ("AC13_2","074_13_2","ACT","13","2","2","Anga ɔlɔ bale á endje sœ lima kœdonga Gbozu yé á sœ kœyotshelœma endje, Ɔtshɔ Ɨshirɨ pa adœke: «'E ko Abarnabase dœ Sawulo ga ɨndɨrɨnœ mbœrœ adœke endje mbœrœ œrœ œneke á mœ e endje ndœ nœ.» ");
INSERT INTO mnh_vpl VALUES ("AC13_3","074_13_3","ACT","13","3","3","Yé manda kœyotshelœma endje dœ pe kœdonga Ndjaba, endje to kane endje ga pa endje yé œ za awa fœ endje. ");
INSERT INTO mnh_vpl VALUES ("AC13_4","074_13_4","ACT","13","4","4","Ɓata á Ɔtshɔ Ɨshirɨ vwa Barnabase dœ Sawulo, endje na ɓa lakpɨ Selœsi, œ ɔ egerœ agba ɓa zœ yeka á ro ga lœ Shipre. ");
INSERT INTO mnh_vpl VALUES ("AC13_5","074_13_5","ACT","13","5","5","Lɔkɔ á endje wuta ga lœ Salamine, endje tetœ kœmɨndœ o'o ama Ndjaba ɓa lœ Sinagoga nœ Ayuda. Yowane á anga ɨ'ɨrɨ ye kœdœ Marke sœ ndje lima kpœtœmœ mbœrœ kœtɨ kane endje. ");
INSERT INTO mnh_vpl VALUES ("AC13_6","074_13_6","ACT","13","6","6","Manda kœzu tshiki para œrrr kœwuta ɓa lœ Pafose, endje gbɔ anga ayi kœpandœ ulu bale á ɨ'ɨrɨ ye kœdœ Bare Yisu; œshe kœdœ Yuda á tshe zatœ ye ɓata ayi kœgbara o'o. ");
INSERT INTO mnh_vpl VALUES ("AC13_7","074_13_7","ACT","13","7","7","Tshe sœ lima ɓa ndœ gbozu Sereyuse Pawuluse á tshe kœdœ ayi kœwusœrœ, á tshe e Barnabase dœ Sawulo mbœrœ tshe sœ lima dœ ogo kœdji o'o ama Ndjaba. ");
INSERT INTO mnh_vpl VALUES ("AC13_8","074_13_8","ACT","13","8","8","Kashe ayi kœpandœ ulu Elimase (ɨ'ɨrɨ Bare Yisu dœ Greke dœmœ) yiyi lima ndœ o'o ama endje nene, yé œ para awa kœndɨ tshelœ gbetshelœ nœ gbozu asœmœ adœke tshe sœsœ kœyindœrœ ga ndœ Yisu nene. ");
INSERT INTO mnh_vpl VALUES ("AC13_9","074_13_9","ACT","13","9","9","Yé Sawulo á anga ɨ'ɨrɨ ye kœdœ Polo á Ɔtshɔ Ɨshirɨ su she kperœ, za ala ye kukuku ga tœ ye, ");
INSERT INTO mnh_vpl VALUES ("AC13_10","074_13_10","ACT","13","10","10","yé œ pa adœke: «Œɓœ, afara œdœ pe ekperœ su ɓœ kperœ. Œɓœ kœdœ gbolo nœ djaboro, uzu á tshe yiyindœ djakata o'o nene. Ɓœ katœ kœndɨ awa nœ Gbozu á sœ ndjii nene a? ");
INSERT INTO mnh_vpl VALUES ("AC13_11","074_13_11","ACT","13","11","11","Ngɔngɔ asœke, kane Ndjaba sœ pa zœ. Ɓœ fa ayibula, yé ɓœ wu ɔlɔ nene œrrr ga tœ olo á tshe yindœ nœ.» Pe kpœtœ œsœnœ, tshelœ ala ye wu shuu yé osho bu kporokoto tœ ye. Tshe fatœ ye djikɨrɨli djikɨrɨli kœpara uzu adœke tshe za ama kane œne. ");
INSERT INTO mnh_vpl VALUES ("AC13_12","074_13_12","ACT","13","12","12","Lɔkɔ á gbozugo wu œneke á mbœrœtœ endje, tshe te yindœ Yisu; gbambanœ nene, o'o ama Gbozu za lima uvuru ye lœnœ. ");
INSERT INTO mnh_vpl VALUES ("AC13_13","074_13_13","ACT","13","13","13","Polo dœ anganœ á tshe na tœ awa dœ endje ɔ lima ga lœ egerœ agba ɓa lœ Pafose, œ ro ga lœ Perje ɓa lœ Pafili. Yé Yowane katœ endje, œ kwatœ ye ga lœ Yerusaleme. ");
INSERT INTO mnh_vpl VALUES ("AC13_14","074_13_14","ACT","13","14","14","Endje katœ tshalakpɨ Perje tɨ, yé œ wuta ɓa lœ Atiɔshe nœ ogo Pisidi. Lɔkɔ sabata, endje li ga lœ Sinagoga yé œ sœ lima ga atɨ. ");
INSERT INTO mnh_vpl VALUES ("AC13_15","074_13_15","ACT","13","15","15","Manda kœdɨ buku á ngbɔɓa awa akwa nœ Moyize dœ œnœ aayi kœgbara o'o, agbozu tshelœ Sinagoga pa fœ endje adœke: «Aaya, 'e kœsœ dœ anga o'o á sœ kœto gbɔgbɔ fœ uzu, 'e pa!» ");
INSERT INTO mnh_vpl VALUES ("AC13_16","074_13_16","ACT","13","16","16","Polo áalafo œ mbœrœ kane ye, yé œ pa adœke: «Azu tshelœ Israyele œdœ pe e'e dœ angbɨ azu á 'e sœ kœkpa awa Ndjaba, 'e dji mœ kane. ");
INSERT INTO mnh_vpl VALUES ("AC13_17","074_13_17","ACT","13","17","17","Ndjaba nœ azu Israyele ke aata 'a. Tshe mbœrœ adœke endje ngba lɔkɔ á endje sœ lima ɓa lœ Ezipito. Manda nœ, tshe ko endje lima ga shu dœ gbɔgbɔ nœ ye. ");
INSERT INTO mnh_vpl VALUES ("AC13_18","074_13_18","ACT","13","18","18","Tshe gbɔndœ endje lima ɓa lœ kpagagasho manda ungu zazu bisha. ");
INSERT INTO mnh_vpl VALUES ("AC13_19","074_13_19","ACT","13","19","19","Manda nœ, tshe wo lima ogo mindu dœ bisha lœ ogo Kanana yé œ kurutshelœ nœ tœ azu nœ ye. ");
INSERT INTO mnh_vpl VALUES ("AC13_20","074_13_20","ACT","13","20","20","Œtœnœ kɔ mbœrœ lima ga pa œrœ nœ́ ungu kama vana dœ zazu bisha dœ ndjokpa (450). «Manda nœ, tshe ko aayi kœwa ngbanga fœ endje œrrr ga tœ ayi kœgbara o'o Samwele. ");
INSERT INTO mnh_vpl VALUES ("AC13_21","074_13_21","ACT","13","21","21","Endje yu osho tœ gbozugo yé Ndjaba za Sawulo, gbolo nœ Kise á tshe kœdœ uzu lœ mara nœ Bendjame, fœ endje. Tshe sœ pa endje manda ungu zazu bisha. ");
INSERT INTO mnh_vpl VALUES ("AC13_22","074_13_22","ACT","13","22","22","Manda kœza Sawulo ga shu tœ akwa, Ndjaba za Davidi tœ gbozugo. Tshe ma o'o nœ ye ngbɨ adœke: “Mœ gbɔ Davidi, gbolo nœ Yese, uzu á lɔsu mœ yindœ ye. Tshe mbœrœ œneke kɔ á mœ gbe dœ tœnœ.” ");
INSERT INTO mnh_vpl VALUES ("AC13_23","074_13_23","ACT","13","23","23","Ɓa lœ aatanœ dá Ndjaba za Yisu tœ ayi kœshe azu Israyele ɓata á tshe pa lima tœnœ. ");
INSERT INTO mnh_vpl VALUES ("AC13_24","074_13_24","ACT","13","24","24","Utshu kœna lima Yisu, Yowane pandœ nœ lima fœ azu Israyele adœke endje fatshalɔsu endje, yé œ gbɔ batisimu. ");
INSERT INTO mnh_vpl VALUES ("AC13_25","074_13_25","ACT","13","25","25","Yé lɔkɔ á Yowane mbœrœ lima akwa nœ ye á ka ye, tshe sœ lima kœpa adœke: “'E gbe adœke œmœ kœdœ eɗe e? Œ dœ́dœ́ mœ kœdœ tsheneke á 'e kate she nene! Kashe anga uzu á tshe na manda mœ, mœ li kœzu uwu œrada nœ ye nene.” ");
INSERT INTO mnh_vpl VALUES ("AC13_26","074_13_26","ACT","13","26","26","«E'e dœ aaya mœ, aata Abrayamo ndje dœ angbɨ azu á 'e sœ kœkpa awa Ndjaba asœke, endje vwa Ɔtshɔ O'onœ asœke á pandœ kœshe fœ azœ. ");
INSERT INTO mnh_vpl VALUES ("AC13_27","074_13_27","ACT","13","27","27","Azu Yerusaleme œdœ pe agbozu tshapa endje wuwusœ Yisu nene, endje wuwu ndje sœ ádá o'o má aayi kœgbara o'o su á endje sœ kœdɨ tœnœ ɔlɔ sabata bale dœ bale nene. Kashe endje wa ɔgbɔ ngbanga ga pa Yisu liaka o'onœ asœmœ. ");
INSERT INTO mnh_vpl VALUES ("AC13_28","074_13_28","ACT","13","28","28","Ataa endje para lima awa kœwo she œrrr toro ye, endje kapa Pilato adœke tshe wo she. ");
INSERT INTO mnh_vpl VALUES ("AC13_29","074_13_29","ACT","13","29","29","Lɔkɔ á endje mbœrœ lima œneke kɔ á Buku nœ Ndjaba pandœ nœ tœ upu nœ ye, endje za lima she pa kurushi ga atɨ, yé œ shi lima she ɓa lœ anga udu bale. ");
INSERT INTO mnh_vpl VALUES ("AC13_30","074_13_30","ACT","13","30","30","Kashe Ndjaba she lima she lœ akuzu ye. ");
INSERT INTO mnh_vpl VALUES ("AC13_31","074_13_31","ACT","13","31","31","Tshe wuta lima lœ olo ndjoro ga tœ endjeneke á endje na lima dœ she awa bale kœto ɓa lakpɨ Galilayi œrrr ga lœ Yerusaleme, endje á endje kœdœ atimu ngɔngɔ asœke ɓa utshu azu ogo Israyele. ");
INSERT INTO mnh_vpl VALUES ("AC13_32","074_13_32","ACT","13","32","32","«A'a ndje, 'a sœ kœyisœ Ɔtshɔ O'onœ asœke fœ 'e, œrœ á Ndjaba pa lima tœ nœ fœ aata 'a adœke œne mbœrœ, ");
INSERT INTO mnh_vpl VALUES ("AC13_33","074_13_33","ACT","13","33","33","tshe mbœrœ fœ azœ má a dœ agbolo nœ endje, lɔkɔ á tshe she lima Yisu lœ akuzu ɓata á endje sú ɓala bisha mbeti nœ Ɨtshi adœke: “Œɓœ kœdœ gbolo nœ mœ, kœto kpesheke, œmœ dá zu ɓœ.” ");
INSERT INTO mnh_vpl VALUES ("AC13_34","074_13_34","ACT","13","34","34","Ndjaba pa lima adœke œne shé she lœ akuzu, yé tshe gba nene. Tshe pa lima ngbɨ adœke: “Mœ to kane nœ mœ dœ adja œyerœ kœto kane ga pa 'e, ɓata á mœ pa lima ndœ kœto fœ Davidi.” ");
INSERT INTO mnh_vpl VALUES ("AC13_35","074_13_35","ACT","13","35","35","Mbœrœ tœnœ dá Davidi pa ndje ala anga mbeti adœke: “Ɓœ katœ œyerœ uzu nœ zœ adœke tshe gba nene.” ");
INSERT INTO mnh_vpl VALUES ("AC13_36","074_13_36","ACT","13","36","36","Lɔkɔ á Davidi sœpe lima dœ soro, tshe mbœrœ lima œneke á Ndjaba yisœ nœ. Manda nœ, tshe tshu lima, endje shi she ndoo dœ aatanœ yé ɔkɔ ye gba. ");
INSERT INTO mnh_vpl VALUES ("AC13_37","074_13_37","ACT","13","37","37","Kashe tsheneke á Ndjaba shé she, gbagba lima nene. ");
INSERT INTO mnh_vpl VALUES ("AC13_38","074_13_38","ACT","13","38","38","Aaya mœ, 'e wusœ nœ dœ ɔtshɔnœ adœke mangba Yisu dá endje pandœ o'o kœdjerœndœ ekperœ fœ 'e á awa akwa nœ Moyize lili lima ndœ kœvwara 'e lœnœ nene. ");
INSERT INTO mnh_vpl VALUES ("AC13_39","074_13_39","ACT","13","39","39","Uzu kɔ á tshe sœ dœ kœyindœrœ ga ndœ ye, tshe wuta uzu ndjii tœ ala Ndjaba. ");
INSERT INTO mnh_vpl VALUES ("AC13_40","074_13_40","ACT","13","40","40","Mbœrœ tœnœ ataa, 'e sœ dœ gbɔdjela mbœrœ á o'o neke á aayi kœgbara o'o su kœwuwuta ga tœ 'e nene: ");
INSERT INTO mnh_vpl VALUES ("AC13_41","074_13_41","ACT","13","41","41","“'E wu kane! E'e dœ adjipudji, 'e katœ ama 'e tɨ ɔsɔ yé œ ndjɔtshelœtœ 'e! Gbambanœ nene, mœ yindœ kœmbœrœ anga œrœ bale lœ soro 'e, œrœ neke á 'e yindœ nœ nene, œdœ uzu kœpandœ nœ fœ 'e.”» ");
INSERT INTO mnh_vpl VALUES ("AC13_42","074_13_42","ACT","13","42","42","Lɔkɔ á Polo dœ Barnabase sœ lima kœwuta tœnœ, endje tetœ kœkɨ fœ endje adœke endje kwa dœ ɔlɔ sabata manda nœ œ kpa yisœ o'onœ asœmœ. ");
INSERT INTO mnh_vpl VALUES ("AC13_43","074_13_43","ACT","13","43","43","Manda angbɔtœnœ, Ayuda œdœ pe angbɨ azu á endje sœ kœkpa awa Ndjaba te manda Polo dœ Barnabase. Lœ o'o á endje sœ kœpa tœnœ, Polo dœ Barnabase pa fœ endje adœke: «'E zatœ 'e djigi ga tœ ɔtshɔrœ nœ Ndjaba.» ");
INSERT INTO mnh_vpl VALUES ("AC13_44","074_13_44","ACT","13","44","44","Lɔkɔ sabata manda nœ, œ sœ ɓata azu kɔ lœ ongbo ngbɔtœ endje lima mbœrœ kœdji o'o ama Gbozu. ");
INSERT INTO mnh_vpl VALUES ("AC13_45","074_13_45","ACT","13","45","45","Kœwu ukpulu azunœ ataa, Ayuda mbœrœ uku yé œ tetœ kœgu Polo dœ kœyiangba o'o ye. ");
INSERT INTO mnh_vpl VALUES ("AC13_46","074_13_46","ACT","13","46","46","Polo dœ Barnabase mɨndœ nœ dœ awanœ adœke: «Œ li má lima adœke endje yisœ Ɔtshɔ O'onœ asœke utshunœ fœ 'e! Ɓata á 'e vwaratœ 'e tœnœ, yé á wa ngbanga dœ tœ 'e adœke 'e lili kœgbɔ soro nœ wa dœ wa nene asœmœ, 'a fatœ 'a ngɔngɔ asœ ga ndœ angbɨ azu. ");
INSERT INTO mnh_vpl VALUES ("AC13_47","074_13_47","ACT","13","47","47","Awa akwanœ á Gbozu pa tœnœ fœ 'a dœke: “Mœ za ɓœ ɓata ɔlɔ kœtshi pa angbɨ azu lœ ogo kɔ, mbœrœ adœke ɓœ yisœ o'o nœ kœshe œrrr tɔ ga tœ ndɔngɔlɔ osho.”» ");
INSERT INTO mnh_vpl VALUES ("AC13_48","074_13_48","ACT","13","48","48","Kœdji o'onœ asœmœ ataa, angbɨ azu tetœ kœdonga Gbozu dœ yanga. Endjeneke á endje sœ lima mbœrœ soro nœ wa dœ wa, endje te lima ayindœ Yisu. ");
INSERT INTO mnh_vpl VALUES ("AC13_49","074_13_49","ACT","13","49","49","O'o ama Gbozu za lima tshelœ ogonœ djigi. ");
INSERT INTO mnh_vpl VALUES ("AC13_50","074_13_50","ACT","13","50","50","Kashe Ayuda bɨlɨ ayashe á œsœ endje lɨ, á endje sœ kœdonga Ndjaba œdœ pe agbozu tshapa ongbo. Endje mbœrœ œrœ kanga ga tœ Polo dœ Barnabase, yé œ gɔrɔ endje lœ ogo nœ endje ye. ");
INSERT INTO mnh_vpl VALUES ("AC13_51","074_13_51","ACT","13","51","51","Polo œdœ Barnabase gɔrɔ trusha tshada endje fœ endje, yé œ ro ga lœ Ikoniyume. ");
INSERT INTO mnh_vpl VALUES ("AC13_52","074_13_52","ACT","13","52","52","Dá asœmœ ayindœ Yisu ɓa lakpɨ Atiɔshe sœ lima dœ yanga waa, yé œ su dœ Ɔtshɔ Ɨshirɨ. ");
INSERT INTO mnh_vpl VALUES ("AC14_1","074_14_1","ACT","14","1","1","Polo œdœ Barnabase na ɓa lakpɨ Ikoniyume œ li ndje ga lœ Sinagoga nœ Ayuda œ pa o'o yé Ayudanœ dœ pe Agreke ndjoro te lima ayindœ Yisu. ");
INSERT INTO mnh_vpl VALUES ("AC14_2","074_14_2","ACT","14","2","2","Kashe Ayuda neke á endje yiyi lima ndœ nœ nene, to gbetshelœ kœmbœrœ ekperœ ga tœ ayindœ Yisu fœ angbɨ azu. ");
INSERT INTO mnh_vpl VALUES ("AC14_3","074_14_3","ACT","14","3","3","Andaa Polo œdœ Barnabase mbœrœ lima olo ndjoro ɓa lœ Ikoniyume. Endje pa lima o'o dœ awa nene lœ kœyindœrœ nœ endje ga ndœ Gbozu. Kœwu tœnœ ataa, Gbozu ma adœke o'onœ á endje sœ kœpa tœnœ tœ upu ɔtshɔrœ nœ ye kœdœ adja o'o, á tshe to gbɔgbɔ nœ kœfa œrœ dœ kœma ambáránœ fœ endje. ");
INSERT INTO mnh_vpl VALUES ("AC14_4","074_14_4","ACT","14","4","4","Azu tshelœ ongbo kurutshelœtœ endje: anga endje yindœ Ayuda yé anga endje yindœ aayi avwa. ");
INSERT INTO mnh_vpl VALUES ("AC14_5","074_14_5","ACT","14","5","5","Angbɨ azu, Ayuda dœ pe agbozu tshapa endje vwara lima ndœ kœmbœrœ œrœ kanga ga tœ Polo dœ Barnabase œdœ kœve endje dœ badja. ");
INSERT INTO mnh_vpl VALUES ("AC14_6","074_14_6","ACT","14","6","6","Endje wusœ o'onœ yé œ kpa gu tœnœ dœ awa ongbo Listre œdœ Derbe lœ ogo Likawoni œdœ pe ndje ogo para ɨndɨrɨnœ. ");
INSERT INTO mnh_vpl VALUES ("AC14_7","074_14_7","ACT","14","7","7","Endje sœ lima kœpa ndje ndœ Ɔtshɔ O'o ɓa zœ. ");
INSERT INTO mnh_vpl VALUES ("AC14_8","074_14_8","ACT","14","8","8","Anga yakoshe bale á ada ye tshu, sœ lima ɓa lakpɨ Listre. Ɓata á endje zu lima she tœ ayi vwɨrɨtɨ, tshe nana lima ana bale nene. ");
INSERT INTO mnh_vpl VALUES ("AC14_9","074_14_9","ACT","14","9","9","Anga ɔlɔ bale á tshe sœ kœdji o'o á Polo sœ kœpa tœnœ, Polo za ala ye kukuku ga tœ ye, yé œ wu adœke tshe sœ dœ kœyindœrœ mbœrœ kœshe tœnœ. ");
INSERT INTO mnh_vpl VALUES ("AC14_10","074_14_10","ACT","14","10","10","Polo pa dœ ɔgbɔ fœ she adœke: «Aalafo œ ka ndjii dœ ada zœ!» Yakoshenœ i ga lafo yé œ tetœ kœna lima ana. ");
INSERT INTO mnh_vpl VALUES ("AC14_11","074_14_11","ACT","14","11","11","Kœwu œneke á Polo mbœrœ asœmœ, azu ndjoro oma kekeke œ pa dœ o'o ama ogo Likawoni adœke: «Andjaba fatœ endje tœ azu yé á jerœ ga ndœ azœ asœke.» ");
INSERT INTO mnh_vpl VALUES ("AC14_12","074_14_12","ACT","14","12","12","Endje e Barnabase «Zewuse», yé œ e Polo «Ermese» mbœrœ œshe dá sœ lima kœmɨndœ o'o. ");
INSERT INTO mnh_vpl VALUES ("AC14_13","074_14_13","ACT","14","13","13","Nganga ndjaba lœ anda nœ Zewuse á sœ ɓa ushu nœ ongbo, na dœ akɔ angombe á endje guma endje dœ flere. Œshe œdœ azu ndjoro, endje yi lima ndœ kœsho endje tœ tokóró fœ Polo dœ Barnabase. ");
INSERT INTO mnh_vpl VALUES ("AC14_14","074_14_14","ACT","14","14","14","Dœ lɔndɔ á endje dji ataa, endje súru lima tshelœ lœba tœ endje yé œ gbɔgbɔtœ endje dœ ana gutœnœ ga lœ ukpulu azu. Endje pa dœ ɔgbɔ adœke: ");
INSERT INTO mnh_vpl VALUES ("AC14_15","074_14_15","ACT","14","15","15","«Uu aaya, mbœrœ gaɗe á 'e mbœrœ ataa? A'a kœdœ ndje azu ɓata 'e! 'A sœ kœpandœ Ɔtshɔ O'o fœ 'e adœke 'e katœ œrœ á ádánœ gugu nene, mbœrœ kœfatœ 'e ga ndœ Ndjaba á tshe sœ dœ soro yé á mbœrœ tshalafo, dœ ɔshɔ, dœ egerœ kota œdœ pe œneke kɔ á sœ lœnœ. ");
INSERT INTO mnh_vpl VALUES ("AC14_16","074_14_16","ACT","14","16","16","Lɔkɔ nœ aata azœ, tshe ka lima tœ azu ogo para kœza awa nœ endje dœ tœ endje. ");
INSERT INTO mnh_vpl VALUES ("AC14_17","074_14_17","ACT","14","17","17","Kashe atamœ gbaa, tshe kakatœ kœma adœke œne sœ zœ lœ awa nœ ɔtshɔrœ nœ ye fœ endje nene. Ɔtshɔrœnœ asœmœ dœke: tshe vwa yavuru fœ 'e mbœrœ kœmɔ ɔshɔ tshelœ kɨndɨ nœ 'e adœke 'e gbɔ kœzɨrœ á li, yé lɔsu 'e sœ dœ yanga.» ");
INSERT INTO mnh_vpl VALUES ("AC14_18","074_14_18","ACT","14","18","18","Ataa ukpulu azunœ dji lima o'o nœ aayi avwa gbaa, endje sœ lima dœ sharapu utshu kœkatœ kœza tokórónœ fœ endje. ");
INSERT INTO mnh_vpl VALUES ("AC14_19","074_14_19","ACT","14","19","19","Anga Ayuda á endje to ɓa lœ Atiɔshe œdœ ɓa lœ Ikoniyume, te ga ndœ ukpulu azu asœmœ. Endje ve lima Polo dœ badja, yé œ gbe adœke tshe tshu ye yeka á gbota she lœ ongbo ga shu. ");
INSERT INTO mnh_vpl VALUES ("AC14_20","074_14_20","ACT","14","20","20","Kashe lɔkɔ á ayindœ Yisu ngbɔtœ endje ga ɨndɨrɨ ye, tshe áalafo yé œ kwatœ ye ga lœ ongbonœ. Osho kɔrɔ pa nœ, endje ro dœ Barnabase ga lœ Derbe. ");
INSERT INTO mnh_vpl VALUES ("AC14_21","074_14_21","ACT","14","21","21","Endje pandœ Ɔtshɔ O'o lœ ongbo Derbe yé œ gbɔ ayindœ Yisu ndjoro. Manda nœ, endje kpa kwatœ endje tɔ lœ Listre, lœ Ikoniyume œdœ pe tɔ lœ Atiɔshe. ");
INSERT INTO mnh_vpl VALUES ("AC14_22","074_14_22","ACT","14","22","22","Endje sœ lima kœto gbɔgbɔ ga tœ lɔsu ayindœ Yisu yé œ pa fœ endje adœke endje shi gbɨ lœ kœyindœrœ. Endje pa adœke: «Œ li adœke a wu oyo waa yeka á kœli ga lœ tshagbozu nœ Ndjaba.» ");
INSERT INTO mnh_vpl VALUES ("AC14_23","074_14_23","ACT","14","23","23","Lœ Ikrizia bale dœ bale, endje ke agbozu Ikrizia fœ endje, œ donga Ndjaba dœ kœyotshelœma endje, yé œ katœ endje tɨ fœ Gbozu á endje sœ dœ kœyindœrœ ga ndœ ye. ");
INSERT INTO mnh_vpl VALUES ("AC14_24","074_14_24","ACT","14","24","24","Endje ro tɔ lœ Pisidi, yé á na ga lœ Pafili. ");
INSERT INTO mnh_vpl VALUES ("AC14_25","074_14_25","ACT","14","25","25","Endje pandœ Ɔtshɔ O'o ɓa tœ Perje, manda nœ á ro ga lœ Atali. ");
INSERT INTO mnh_vpl VALUES ("AC14_26","074_14_26","ACT","14","26","26","Endje ɔ ga lœ egerœ agba ɓa zœ yé á gu ga lœ Atiɔshe nœ Siri, tshalakpɨ á endje ko lima endje ga tshakane Gbozu adœke endje gbɔ ɔtshɔrœ nœ Ndjaba mbœrœ akwa á endje totœ kœmbœrœ tœnœ. ");
INSERT INTO mnh_vpl VALUES ("AC14_27","074_14_27","ACT","14","27","27","Lɔkɔ á endje wuta lima ga lœ Atiɔshe, endje ngbɔɓa azu Ikrizia yé œ pandœ œneke kɔ á Ndjaba mbœrœ lima fœ endje dœ pe mara á tshe kɔrɔ awa kœyindœrœ fœ angbɨ azu. ");
INSERT INTO mnh_vpl VALUES ("AC14_28","074_14_28","ACT","14","28","28","Yé endje lo olo ndjoro tœ œsœnœ bale dœ ayindœ Yisu. ");
INSERT INTO mnh_vpl VALUES ("AC15_1","074_15_1","ACT","15","1","1","Anga ayakoshe to ɓa lœ Yuda, œ tetœ kœyisœ œrœ fœ aayazu lœ Yisu adœke: «Œdœ 'e kœvwaratœ 'e tœ kœwa gaza ɓata awa akwa nœ Moyize pandœ nœ, 'e gbɔ kœshe nene.» ");
INSERT INTO mnh_vpl VALUES ("AC15_2","074_15_2","ACT","15","2","2","Polo œdœ Barnabase vwaratœ endje tœ kœyisœ œrœ nœ ayakoshenœ asœmœ, œ gbugburu tshelœ o'o dœ endje tœ upunœ. Manda nœ, endje wa adœke Polo œdœ Barnabase, ndje dœ anga aayazu lœ Yisu ɔ ga lœ Yerusaleme ndœ kœgbɔtœ endje dœ aayi avwa œdœ agbɔ Azu Ikrizia mbœrœ kœyɔrɔ o'onœ asœmœ. ");
INSERT INTO mnh_vpl VALUES ("AC15_3","074_15_3","ACT","15","3","3","Azu Ikrizia lœ Atiɔshe to œrœ á li mbœrœ ananœ fœ endje. Kœro endje tɔ lœ Fenisi dœ Samariya, endje sœ kœpandœ mara á angbɨ azu fa lɔsu endje yé œ za yanga waa fœ aayazu lœ Yisu para. ");
INSERT INTO mnh_vpl VALUES ("AC15_4","074_15_4","ACT","15","4","4","Ɔlɔ á endje wuta ga lœ Yerusaleme, azu Ikrizia, aayi avwa dœ pe agbozu Ikrizia za osho kœsœ fœ endje yé endje pandœ œrœ kɔ á Ndjaba mbœrœ lœ awa nœ endje fœ endje. ");
INSERT INTO mnh_vpl VALUES ("AC15_5","074_15_5","ACT","15","5","5","Kashe anga ayindœ Yisu á endje to lœ Afarisayi za o'o œ pa adœke: «Œ li adœke angbɨ azu á endje wuta ayindœ Yisu wa gaza, œ lɨ ndje sœ awa akwa nœ Moyize.» ");
INSERT INTO mnh_vpl VALUES ("AC15_6","074_15_6","ACT","15","6","6","Aayi avwa œdœ agbozu Ikrizia ngbɔɓatœ endje mbœrœ kœgbe o'o tœ upunœ asœmœ. ");
INSERT INTO mnh_vpl VALUES ("AC15_7","074_15_7","ACT","15","7","7","Manda kœgbugburu tshelœ o'o œrrr, Petro áalafo yé œ pa adœke: «Aaya, 'e wusœ nœ adœke Ndjaba ke lima mœ ugurutœ 'e katshatsha ndœ kœpandœ Ɔtshɔ O'o fœ angbɨ azu adœke endje dji, œ yindœ nœ. ");
INSERT INTO mnh_vpl VALUES ("AC15_8","074_15_8","ACT","15","8","8","Yé Ndjaba á tshe wusœ lɔsu azu para kɔkɔ, za Ɔtshɔ Ɨshirɨ fœ endje tœ kœma adœke œne yi ndje ndœ endje awa bale ɓata á tshe mbœrœ ndje fœ azœ. ");
INSERT INTO mnh_vpl VALUES ("AC15_9","074_15_9","ACT","15","9","9","Tshe yiyi ko ndœ azœ yé œ vwaratœ ye tœ endje nene; gbambanœ nene, lœ awa nœ kœyindœrœ nœ endje ga ndœ Yisu, tshe djutɔ ekperœ nœ endje. ");
INSERT INTO mnh_vpl VALUES ("AC15_10","074_15_10","ACT","15","10","10","Ngɔngɔ asœ, mbœrœ gaɗe á 'e sœ kœshokɔ o'o dœ Ndjaba a? 'E yindœ kœza egerœ gbarœ á azœ dœ aata azœ, a zaza lima nene ga pa kumu ayindœ Yisu a? ");
INSERT INTO mnh_vpl VALUES ("AC15_11","074_15_11","ACT","15","11","11","Kashe a wusœ nœ adœke, a she kolœ mangba ɔtshɔ lɔsu nœ Gbozu Yisu, yé endje ndje awa bale.» ");
INSERT INTO mnh_vpl VALUES ("AC15_12","074_15_12","ACT","15","12","12","Manda nœ, azu lœ kokoko ndœ kœdji Polo œdœ Barnabase, á endje sœ kœmɨndœ œrœ á sœ kœma mara œrœ á Ndjaba mbœrœ lœ awa nœ endje ugurutœ angbɨ azunœ asœmœ. ");
INSERT INTO mnh_vpl VALUES ("AC15_13","074_15_13","ACT","15","13","13","Lɔkɔ á endje pa o'o nœ endje á ka, Jake áalafo œ pa adœke: «Aaya, 'e dji mœ kane. ");
INSERT INTO mnh_vpl VALUES ("AC15_14","074_15_14","ACT","15","14","14","Shimu wuta kœmɨndœ nœ fœ azœ mara á Ndjaba gbe ɓalima katshatsha á ke anga azu ugurutœ angbɨ azu adœke endje dœ azu nœ œne. ");
INSERT INTO mnh_vpl VALUES ("AC15_15","074_15_15","ACT","15","15","15","Œrœ á Ndjaba mbœrœ li dœ o'o ama aayi kœgbara o'o. Gbambanœ nene, Ndjaba pa adœke: ");
INSERT INTO mnh_vpl VALUES ("AC15_16","074_15_16","ACT","15","16","16","“Manda nœ kɔ, mœ kpa kwatœ mœ ndœ kpa kœmɔ anda nœ Davidi á te. Agbanœ á sœ atɨ, mœ kpa mɔ tshandœnœ, yé mœ kpa za ga lafo. ");
INSERT INTO mnh_vpl VALUES ("AC15_17","074_15_17","ACT","15","17","17","Kœto kpœtœmœ, udu azu œ para awa Gbozu, œdœ pe angbɨ azu kɔ á mœ ke endje. Œmœ Gbozu dá pa o'onœ asœke, mœ sœ kœguma o'o nœ mœ ");
INSERT INTO mnh_vpl VALUES ("AC15_18","074_15_18","ACT","15","18","18","á mœ gbe ɓalima katshatsha.”» ");
INSERT INTO mnh_vpl VALUES ("AC15_19","074_15_19","ACT","15","19","19","Jake kpa kœpa adœke: «Mœ gbe œnœ mœ adœke œ lili adœke a mbœrœ œrœ kanga fœ azu á endje fatshalɔsu endje fœ Yisu nene. ");
INSERT INTO mnh_vpl VALUES ("AC15_20","074_15_20","ACT","15","20","20","Kashe a su kolœ mbeti fœ endje adœke, endje zɨzɨ agea á to ɓa pa ndaba nœ andjaba nene, endje zɨzɨ songba agea á tshe tshu á indji ye tutu nene, endje zɨzɨ indji nene yé adja endje mbœmbœrœ angba budu nene. ");
INSERT INTO mnh_vpl VALUES ("AC15_21","074_15_21","ACT","15","21","21","Mbœrœ katshatsha ɓalima, endje yisœ awa akwa nœ Moyize dje lakpɨ kɔ mbœrœ á endje sœ kœdɨ tœnœ lɔkɔ sabata bale dœ bale lœ anda ngbɔtœ.» ");
INSERT INTO mnh_vpl VALUES ("AC15_22","074_15_22","ACT","15","22","22","Ataa aayi avwa, dœ agbozu Ikrizia œdœ pe azu Ikrizia para kɔkɔ wu dœ ɔtshɔnœ adœke, endje ke anga azu ugurutœ œne dœ́ vwa endje ɓa lœ Atiɔshe awa bale dœ Polo œdœ Barnabase. Yekane á endje ke Yuda á anga ɨ'ɨrɨ ye kœdœ Barsabase œdœ pe Sila. Endje bibisha kœdœ azu á endje sœ lima kœlɨsœ endje ugurutœ ayindœ Yisu. ");
INSERT INTO mnh_vpl VALUES ("AC15_23","074_15_23","ACT","15","23","23","Mbeti á endje sú ga tshakane endje pa adœke: «Aaya 'a dœ angbɨ azu á 'e sœ lœ Atiɔshe, lœ Siri, œdœ ndje lœ Silisi: aayi avwa, dœ agbozu Ikrizia œdœ azu Ikrizia para kɔkɔ za abala fœ 'e. ");
INSERT INTO mnh_vpl VALUES ("AC15_24","074_15_24","ACT","15","24","24","A dji adœke anga azu á endje to ɓa ndœ 'a ɓa ke, á na ga ndœ 'e kœdjingili tshelœ kumu 'e, endje ndɨ gbetshelœ nœ 'e kashe œ dœ́dœ́ 'a dá vwa endje nene. ");
INSERT INTO mnh_vpl VALUES ("AC15_25","074_15_25","ACT","15","25","25","Ádánœ á 'a wa kɔ dœ lɔsu 'a bale adœke 'a ke anga azu dœ́ vwa endje fœ 'e. Endje ro tœ awanœ dœ aaya 'a á 'a yindœ endje waa, Polo œdœ Barnabase ");
INSERT INTO mnh_vpl VALUES ("AC15_26","074_15_26","ACT","15","26","26","á endje za soro endje djigi mbœrœ akwa nœ Gbozu nœ azœ dœ Yisu Kristu. ");
INSERT INTO mnh_vpl VALUES ("AC15_27","074_15_27","ACT","15","27","27","'A vwa Yuda dœ Sila adœke endje kpa pandœ œneke kɔ á 'a su ala mbetinœ asœke fœ 'e dœ ama endje. ");
INSERT INTO mnh_vpl VALUES ("AC15_28","074_15_28","ACT","15","28","28","Gbambanœ nene, Ɔtshɔ Ɨshirɨ dœ pe a'a wa adœke, 'a kpa za egerœ gbarœ ga pa kumu 'e nene. Kashe œrœ á li dœ 'e kœmbœrœ tœnœ dœke: ");
INSERT INTO mnh_vpl VALUES ("AC15_29","074_15_29","ACT","15","29","29","adja 'e zɨzɨ agea á to ɓa pa ndaba nœ andjaba nene, 'e zɨzɨ indji nene, 'e zɨzɨ songba agea á tshe tshu á indji tutu nene, 'e mbœmbœrœ angbabudu nene. Œdœ 'e kœlɨsœ œrœnœ asœke kɔ, dá 'e mbœrœ dœ ɔtshɔnœ waa. 'E sœpe dœ ɔtshɔnœ.» ");
INSERT INTO mnh_vpl VALUES ("AC15_30","074_15_30","ACT","15","30","30","Endje za awa fœ endje yé endje ro ga lœ Atiɔshe. Lɔkɔ kœwuta endje ɓa zœ, endje ngbɔɓa ayindœ Yisu, œ za mbetinœ fœ endje. ");
INSERT INTO mnh_vpl VALUES ("AC15_31","074_15_31","ACT","15","31","31","Manda kœdɨ mbetinœ, ayindœ Yisu sœ lima dœ yanga waa mbœrœ mbetinœ guma gbetshelœ nœ endje. ");
INSERT INTO mnh_vpl VALUES ("AC15_32","074_15_32","ACT","15","32","32","Yuda dœ Sila á endje dœ lima aayi kœgbara o'o, endje mɨ upu fœ endje adœke endje shi gbɨ yé œ gbɔndœ kœyindœrœ nœ endje. ");
INSERT INTO mnh_vpl VALUES ("AC15_33","074_15_33","ACT","15","33","33","Endje mbœrœ lima olo teasho kpœtœmœ. Manda nœ, ayindœ Yisu za awa fœ endje adœke endje gu dœ kœsœ gee ga ndœ azu á endje vwa lima endje.  ");
INSERT INTO mnh_vpl VALUES ("AC15_34","074_15_34","ACT","15","34","34","Kashe Sila wa lima kœsœpe œnœ ye kpœtœmœ. ");
INSERT INTO mnh_vpl VALUES ("AC15_35","074_15_35","ACT","15","35","35","Polo œdœ Barnabase sœ lima œnœ endje ɓa lœ Atiɔshe. Ɓa zœ, endje sœ kœyisœ œrœ œdœ pe kœmɨndœ Ɔtshɔ O'o nœ Gbozu awa bale dœ anga azu ndjoro. ");
INSERT INTO mnh_vpl VALUES ("AC15_36","074_15_36","ACT","15","36","36","Olo teasho manda nœ, Polo pa fœ Barnabase adœke: «A kwatœ azœ lakpɨ bale dœ bale á a yi lima sœ o'o ama Gbozu tœnœ dœ́ œ wu mara á aaya azœ sœ dœ tœnœ.» ");
INSERT INTO mnh_vpl VALUES ("AC15_37","074_15_37","ACT","15","37","37","Barnabase yi lima ndœ kœkwa dœ Yowane á anga ɨ'ɨrɨ ye kœdœ Marke. ");
INSERT INTO mnh_vpl VALUES ("AC15_38","074_15_38","ACT","15","38","38","Kashe Polo gbe adœke kœkwa dœ she œ li nene, mbœrœ tshe ka lima tœ endje tɨ ɓa lœ Pafili, œ vwara lima tœ ye kœna dœ endje lœ ma akwa nœ Ndjaba. ");
INSERT INTO mnh_vpl VALUES ("AC15_39","074_15_39","ACT","15","39","39","Mbœrœ tœnœ ataa, endje djidji lima tœ endje nene, yé endje kurutshelœtœ endje. Barnabase za Marke po tœ ye, œ za egerœ agba œ ro ga lœ Shipre, ");
INSERT INTO mnh_vpl VALUES ("AC15_40","074_15_40","ACT","15","40","40","kashe Polo ke Sila ndœ kœro dœ she. Manda nœ, ayindœ Yisu ko endje ga tshakane Ndjaba adœke ɔtshɔ lɔsu nœ Gbozu gbɔndœ endje. ");
INSERT INTO mnh_vpl VALUES ("AC15_41","074_15_41","ACT","15","41","41","Endje ro lima tɔ lœ Siri œdœ Silisi, œ yisœ œrœ fœ azu Ikrizia adœke endje gbɔndœ kœyindœrœ nœ endje. ");
INSERT INTO mnh_vpl VALUES ("AC16_1","074_16_1","ACT","16","1","1","Polo li ndje ga lœ Derbe dœ pe Listre. Ɓa zœ anga yindœ Yisu á ɨ'ɨrɨ ye kœdœ Timote, gbolo yakoshe nœ anga uyu Yuda á tshe yindœ Yisu, abanœ dœ́dœ́ Yuda nene. ");
INSERT INTO mnh_vpl VALUES ("AC16_2","074_16_2","ACT","16","2","2","Ɔtshɔ ye ga lima waa ugurutœ aayanœ lœ Listre dœ pe Ikoniyume. ");
INSERT INTO mnh_vpl VALUES ("AC16_3","074_16_3","ACT","16","3","3","Polo gbe lima kœgu dœ she awa bale. Kœwu adœke Ayuda lœ ndjoro tœ oshonœ ɓa zœ, tshe za she, œ wa she tœ gaza lindœ awa akwa nœ Ayudanœ, mbœrœ Ayuda kɔ á endje sœ lima dœ endje tœ œsœnœ wu lima sœ nœ adœke abanœ dœ́dœ́ Yuda nene. ");
INSERT INTO mnh_vpl VALUES ("AC16_4","074_16_4","ACT","16","4","4","Lœ ongbo á endje ro lima tœnœ, Polo dœ Sila sœ lima kœmɨndœ o'o á aayi avwa nœ Yisu dœ agbozu lœ Yerusaleme wa, á endje sœ kœpa fœ endje adœke endje mbœrœ tœ endje lindœ nœ. ");
INSERT INTO mnh_vpl VALUES ("AC16_5","074_16_5","ACT","16","5","5","Azu Ikrizia sœ lima kœru lɔsu endje lœ kœyindœrœ nœ endje, ɔlɔ dœ ɔlɔ anga azu sœ lima kœli ga ndœ endje yé endje te lima kœngba tœnœ. ");
INSERT INTO mnh_vpl VALUES ("AC16_6","074_16_6","ACT","16","6","6","Polo œdœ Sila na lœ Friji œdœ pe lœ Galate; gbambanœ nene, Ɔtshɔ Ɨshirɨ pakata lima endje kœpandœ Ɔtshɔ O'o ɓa lœ Azi. ");
INSERT INTO mnh_vpl VALUES ("AC16_7","074_16_7","ACT","16","7","7","Kœwuta endje ga tœ ndɔngɔlɔ ogo Misi, endje gbe kœro ga lœ Bitini yeka á Ɨshirɨ nœ Yisu pakata endje. ");
INSERT INTO mnh_vpl VALUES ("AC16_8","074_16_8","ACT","16","8","8","Endje ro tɔ lœ Misi yé œ jerœ ga lœ Trowase. ");
INSERT INTO mnh_vpl VALUES ("AC16_9","074_16_9","ACT","16","9","9","Anga butshɔ bale, Polo kœwu œrœ lœ ulu: anga yakoshe Masedwane bale na ga ndœ ye, œ ka kœdɨ tshelœma ye fœ she adœke: «Fa djaga lœ Masedwane, mbœrœ kœtɨ kane 'a ga lafo!» ");
INSERT INTO mnh_vpl VALUES ("AC16_10","074_16_10","ACT","16","10","10","Manda kœwu œrœ lœ ulu nœ Polo asœmœ, trale 'a para awa kœro ga lœ Masedwane, mbœrœ 'a wu lima sœ nœ adœke Ndjaba sœ kœ e 'a kœna kœpandœ Ɔtshɔ O'o ɓa zœ. ");
INSERT INTO mnh_vpl VALUES ("AC16_11","074_16_11","ACT","16","11","11","'A ɔ ga lœ egerœ agba lœ Trowase, 'a za awa ndjii ndœ Samotrase mbœrœ á osho kœkɔrɔ á 'a kœwuta ga lœ Neyapolise. ");
INSERT INTO mnh_vpl VALUES ("AC16_12","074_16_12","ACT","16","12","12","Yé ɓa zœ 'a na ga lœ Filipo, egerœ ongbo lœ ogo Masedwane, azu á endje sœ lœ nœ sœ tshakudu tshagbozu nœ ogo Roma. Œndœ 'a dɨ lima teasho lœ ongbonœ asœmœ. ");
INSERT INTO mnh_vpl VALUES ("AC16_13","074_16_13","ACT","16","13","13","Dœ lɔkɔ sabata, 'a wuta lœ ongbonœ kœna ga lakpɨ ogo neke á sœ ndoo dœ ama ungu, tœnœ kœdœ lima œsœ osho nœ kœdonga Ndjaba, yeka á 'a sœ ga atɨ, á pa o'o dœ ayashe á endje ngbɔtœ endje kpœtœmœ. ");
INSERT INTO mnh_vpl VALUES ("AC16_14","074_16_14","ACT","16","14","14","Anga bale ugurutœ endje, ɨ'ɨrɨ ye kœdœ Lidi, œshe kœdœ lima yashe lœ ongbo Tiyatire á tshe sœ kœka odoro lœba yé á wu lima sœ kœdonga Ndjaba. Tshe dji 'a yé Ndjaba kɔrɔ gbetshelœ nœ ye adœke tshe yindœ o'o kɔ á Polo pa. ");
INSERT INTO mnh_vpl VALUES ("AC16_15","074_16_15","ACT","16","15","15","Manda kœgbɔ batisimu, œshe dœ azu sœnda nœ ye para, tshe pa fœ 'a adœke: «Œdœ 'e kœwusœ nœ adœke, œmœ kœdœ uzu á mœ yindœ Ndjaba ye, 'e na œ lo ɓa ndœ mœ.» Yé tshe tovworogbo 'a kœyindœ nœ. ");
INSERT INTO mnh_vpl VALUES ("AC16_16","074_16_16","ACT","16","16","16","Ɔlɔ bale á 'a sœ lima kœna ndœ kœ e Ndjaba, anga yashe kanga bale á tshe sœ lima dœ ekpe ɨshirɨ nœ kœgbara o'o sœ ugurutœ 'a. Ayengɔ ye sœ lima kœgbɔ œrœ waa manda akwa nœ ye. ");
INSERT INTO mnh_vpl VALUES ("AC16_17","074_16_17","ACT","16","17","17","Tshe te manda 'a dœ Polo, yé œ sœ kœpa dœ ɔgbɔ adœke: «Ayakoshenœ asœ kœdœ aayi akwa nœ Ndjaba á tshe ropa œrœ kɔ; endje sœ kœyisœ awa kœgbɔ kœshe fœ 'e.» ");
INSERT INTO mnh_vpl VALUES ("AC16_18","074_16_18","ACT","16","18","18","Yé tshe mbœrœ ataa manda olo ndjoro. Polo mɔ dœ she, á kœfatœ ye yé á kœpa fœ ɨshirɨnœ adœke: «Dœ ɨ'ɨrɨ Yisu Kristu, mœ pa fœ ɓœ adœke: wuta lœ yashe asœke!» Trale ɨshirɨ wuta lœ ye yé. ");
INSERT INTO mnh_vpl VALUES ("AC16_19","074_16_19","ACT","16","19","19","Ɓata aayengɔ yashe kanga asœmœ wu adœke œne kpa gbɔ œrœ lœ awa nœ ye nene, endje tepa Polo œdœ Sila œ gbota endje na tœnœ fœ agbozu kœwa ngbanga œrrr ɓa la wutu ga utshu azu kɔ. ");
INSERT INTO mnh_vpl VALUES ("AC16_20","074_16_20","ACT","16","20","20","Endje ko endje na tœnœ fœ agbozunœ asœmœ yé œ pa adœke: «Ayakoshenœ asœ kœdœ Ayuda, endje ndɨ tshalakpɨ nœ azœ kpa ye. ");
INSERT INTO mnh_vpl VALUES ("AC16_21","074_16_21","ACT","16","21","21","Endje sœ kœpara awa ndœ kœyisœ angbɨ mara kœsœ neke á azœ dœ́ azu Roma á lili adœke a mbœrœ nene.» ");
INSERT INTO mnh_vpl VALUES ("AC16_22","074_16_22","ACT","16","22","22","Yé œ ɨvwɨ azu kekeke ga tœ Polo œdœ Sila. Agbozu kœwa ngbanga kœza o'o adœke endje sɔ lœba tœ endje dœ́ œ ɓi endje dœ ndjapa. ");
INSERT INTO mnh_vpl VALUES ("AC16_23","074_16_23","ACT","16","23","23","Manda kœɓi endje dœ ndjaba, endje ko endje va ga lœ kánga, yé œ pa fœ ayi kœgbɔndœ manda kánga adœke ala ye gbɔ dœ endje. ");
INSERT INTO mnh_vpl VALUES ("AC16_24","074_16_24","ACT","16","24","24","Ayi kœgbɔndœ manda kánga dji ataa, œ ko endje li tœnœ waa ɓa ndœ kumu gbɔshɔ kánga yé œ soro ada endje dœ djingiri. ");
INSERT INTO mnh_vpl VALUES ("AC16_25","074_16_25","ACT","16","25","25","Dœ butshɔ, Polo œdœ Sila tetœ kœza avwala fœ Ndjaba dœ pe kœdonga she dœ itshi yé anga aayi kánga dji endje. ");
INSERT INTO mnh_vpl VALUES ("AC16_26","074_16_26","ACT","16","26","26","Kolœ ngbangi atake, ɔshɔ turu dœ ɔgbɔ, muru anda turu, Trale manda kɔrɔ wuu, yé tshelœ djingiri sɔ tœ aayi kánga para. ");
INSERT INTO mnh_vpl VALUES ("AC16_27","074_16_27","ACT","16","27","27","Ayi kœgbɔndœ manda kánga kœjo, œ kœwu adœke manda kánga kɔrɔ wuu á kœgbe adœke aayi kánga kpa para kɔkɔ ye. Tshe kœgbota ugu yakamba nœ ye á yindœ kœwotœ ye. ");
INSERT INTO mnh_vpl VALUES ("AC16_28","074_16_28","ACT","16","28","28","Á Polo kœra she dœ ɔgbɔ adœke: «Wowotœ zœ nene, 'a lœ para kɔkɔ zœ!» ");
INSERT INTO mnh_vpl VALUES ("AC16_29","074_16_29","ACT","16","29","29","Ayi kœgbɔndœ manda kánga kœ'e osho ndœ owo, kœgbɔgbɔtœ ye li tœnœ dœ awa, á kœgote ga tœ ada Polo dœ Sila. ");
INSERT INTO mnh_vpl VALUES ("AC16_30","074_16_30","ACT","16","30","30","Manda nœ, tshe kœto Polo œdœ Sila wuta tœnœ ga shu, á kœpa fœ endje adœke: «Agbozu, œrœ gaɗe dá mœ kœmbœrœ yeka á kœshe a?» ");
INSERT INTO mnh_vpl VALUES ("AC16_31","074_16_31","ACT","16","31","31","Polo œdœ Sila kœgi fœ she adœke: «Sœ dœ kœyindœrœ adœke Yisu kœdœ Gbozu yekane á tshe kœshe ɓœ awa bale dœ azu tshasœnda nœ zœ.» ");
INSERT INTO mnh_vpl VALUES ("AC16_32","074_16_32","ACT","16","32","32","Endje kœpandœ o'o ama Gbozu fœ she, dœ azu kɔ á endje sœ lima sœnda nœ ye. ");
INSERT INTO mnh_vpl VALUES ("AC16_33","074_16_33","ACT","16","33","33","Kolœ dœ abutshɔnœ asœmœ, ayi kœgbɔndœ manda kánga na dœ endje na tœnœ œ djutɔ uku tœ endje yé pe kpœtœmœ tshe gbɔ batisimu awa bale dœ azu tshasœnda nœ ye kɔ. ");
INSERT INTO mnh_vpl VALUES ("AC16_34","074_16_34","ACT","16","34","34","Tshe to Polo dœ Sila gu tœnœ ga sœnda nœ ye, œ to kœzɨrœ fœ endje, yé tshe sœ lima dœ yanga awa bale dœ azu tshasœnda nœ ye kɔ, mbœrœ endje yi lima ndœ Ndjaba. ");
INSERT INTO mnh_vpl VALUES ("AC16_35","074_16_35","ACT","16","35","35","Osho kɔrɔ pa nœ, agbozu kœwa ngbanga vwa aturugu fœ ayi kœgbɔndœ manda kánga adœke: «Tshe za awa fœ azu asœmœ!» ");
INSERT INTO mnh_vpl VALUES ("AC16_36","074_16_36","ACT","16","36","36","Á tshe kœpa fœ Polo adœke: «Agbozu kœwa ngbanga vwa osho fœ mœ adœke mœ za awa fœ 'e. Ngɔngɔ asœke, 'e li kœwuta tœnœ, yé œ gu dœ kœsœ gee.» ");
INSERT INTO mnh_vpl VALUES ("AC16_37","074_16_37","ACT","16","37","37","Kashe Polo pa fœ aturugu adœke: «Endje yuyu lima 'a nene, œ ɓi 'a tœ ala azu kɔ, andaa a'a kœdœ adja azu Roma. Endje ko 'a va ga lœ kánga, yé endje yindœ kœko 'a ngɔngɔ asœ ga shu lœ ubunœ. Œ mbœrœtœ endje atamœ nene. Ɔtshɔ nœ kœdœ adœke endje na ga mœ dœ tœ endje œ ko 'a ga shu!» ");
INSERT INTO mnh_vpl VALUES ("AC16_38","074_16_38","ACT","16","38","38","Aturugunœ gu œ pandœ nœ fœ agbozu kœwa ngbanganœ, yé awa za endje mbœrœ kœdji adœke endje kœdœ ndje azu Roma. ");
INSERT INTO mnh_vpl VALUES ("AC16_39","074_16_39","ACT","16","39","39","Endje na kœkɨ fœ Polo dœ Sila adœke endje wu oyo œne. Manda nœ, endje za awa fœ endje kœwuta lœ kánga yé œ pa fœ endje adœke endje wuta lœ ongbo ye. ");
INSERT INTO mnh_vpl VALUES ("AC16_40","074_16_40","ACT","16","40","40","Manda kœwuta endje lœ kánganœ, endje na ga lœ Lidi. Ɓa zœ, endje gbɔ ayindœ Yisu œ pa fœ endje adœke endje shi gbɨ lœ kœyindœrœ nœ endje, yé manda nœ endje ro da ye. ");
INSERT INTO mnh_vpl VALUES ("AC17_1","074_17_1","ACT","17","1","1","Endje ro tɔ lœ Afipolisi dœ Apoloni yeka á wuta ga lœ Tesalonike, ɓa zœ Ayuda sœ lima dœ Sinagoga. ");
INSERT INTO mnh_vpl VALUES ("AC17_2","074_17_2","ACT","17","2","2","Ɓata á tshe mbœrœ ɓa lima katshatsha, Polo li ga lœ Sinagoganœ. Manda lɔkɔ sabata votɔ, tshe sœ lima kœpu o'o pa Buku nœ Ndjaba awa bale dœ azu á endje sœ kpœtœmœ. ");
INSERT INTO mnh_vpl VALUES ("AC17_3","074_17_3","ACT","17","3","3","Tshe sœ lima kœyisœ nœ fœ endje ngbɨ adœke, œ li adœke Masiya wu oyo, œ tshu, œ she ugurutœ akuzu. Tshe pa fœ endje adœke: «Yisunœ á mœ mɨndœ ye fœ 'e asœke kœdœ Masiyanœ.» ");
INSERT INTO mnh_vpl VALUES ("AC17_4","074_17_4","ACT","17","4","4","Anga Ayuda ugurutœ endje yindœ o'o á Polo pa, yé œ te ga ndœ Polo dœ Sila. Awa bale ndje dœ angbɨ azu Agrekenœ ndjoro á endje donga Ndjaba œdœ pe ndje ayashe ndjoro á azu sœ kœlɨsœ endje, te ga ndœ Polo dœ Sila. ");
INSERT INTO mnh_vpl VALUES ("AC17_5","074_17_5","ACT","17","5","5","Kashe anga Ayudanœ mbœrœ úkú. Endje rɔ anga ekpe azu á endje na tœ ala awa kpɔɔ, œ zɨ tshelœ o'o dœ endje yé œ ndɨ kœsœ gee lakpɨ ogo. Endje na ɓa sœnda nœ Jasone kœpara Polo dœ Sila á kœko endje wuta tœnœ ga utshu azu tshalakpɨnœ. ");
INSERT INTO mnh_vpl VALUES ("AC17_6","074_17_6","ACT","17","6","6","Ɓata á endje gbɔgbɔ Polo dœ Sila nene, endje za Jasone awa bale dœ anga ayindœ Yisu, œ gbota endje gu tœnœ ga utshu aayi kœwa ngbanga tshalakpɨnœ asœmœ, yé œ pa adœke: «Azu á endje djingili tshelœ kumu azu pa ɔshɔ djigi, endje dá wuta ngɔngɔ asœ ɓa ke asœke. ");
INSERT INTO mnh_vpl VALUES ("AC17_7","074_17_7","ACT","17","7","7","Jasone za osho kœsœ fœ endje ɓa sœnda nœ ye yé endje kɔ, endje mbœmbœrœ œrœ á awa akwa nœ gbozugo Roma yindœ nœ nene; endje pa adœke anga angbɨ gbozu kpi sœ zœ, yé ɨ'ɨrɨ ye kœdœ Yisu.» ");
INSERT INTO mnh_vpl VALUES ("AC17_8","074_17_8","ACT","17","8","8","O'o ama endje za ókó fœ azu para kɔkɔ, œ za ndje ókó fœ agbozu tshelœ ongbonœ, ");
INSERT INTO mnh_vpl VALUES ("AC17_9","074_17_9","ACT","17","9","9","yé endje dɨ lima ngendja fœ Jasone œdœ anga ayindœ Yisunœ yekane á endje za awa fœ endje adœke endje gu. ");
INSERT INTO mnh_vpl VALUES ("AC17_10","074_17_10","ACT","17","10","10","Pe dœ lɔkɔnœ asœmœ dœ abutshɔ, ayindœ Yisu gi Polo œdœ Sila ga tœ awa á endje ro ga lœ Bere. Endje wuta ɓa zœ yé œ na ga lœ Sinagoga nœ Ayuda. ");
INSERT INTO mnh_vpl VALUES ("AC17_11","074_17_11","ACT","17","11","11","Ayuda nœ Bere sœ lima dœ ɔtshɔ lɔsu kœropa endjeneke lœ Tesalonike, endje yindœ Ɔtshɔ O'o dœ lɔsu endje djigi, yé ɔlɔ dœ ɔlɔ, endje sœ lima kœdɨ Mbeti nœ Ndjaba, mbœrœ kœwu œdœ ádá o'onœ á Polo œdœ Sila pa asœmœ kœdœ adjapu. ");
INSERT INTO mnh_vpl VALUES ("AC17_12","074_17_12","ACT","17","12","12","Anga azu ndjoro ugurutœ endje sœ dœ kœyindœrœ ga ndœ Yisu, yé ugurutœ azu Greke, ayashe ndjoro á azu œ lɨsœ endje dœ pe ayakoshe. ");
INSERT INTO mnh_vpl VALUES ("AC17_13","074_17_13","ACT","17","13","13","Kashe, ɔlɔ á Ayuda lœ Tesalonike dji adœke Polo sœ kpa kœmɨndœ Ɔtshɔ O'o lœ Bere, endje wuta ɓa zœ yé œ tetœ kœndɨ tshelœ gbetshelœ nœ azu ndjoro. ");
INSERT INTO mnh_vpl VALUES ("AC17_14","074_17_14","ACT","17","14","14","Yé pe kpœtœmœ, ayindœ Yisu gi Polo na tœnœ ga tœ ama egerœ ungu kashe Asila dœ Timote lœpe lima œnœ endje kpœtœmœ lœ Bere. ");
INSERT INTO mnh_vpl VALUES ("AC17_15","074_17_15","ACT","17","15","15","Azu á endje za lima Polo kpatœnœ œrrr ɓa lœ Atene, endje gu dœ o'o adœke Sila dœ Timote ro katsha manda œne. ");
INSERT INTO mnh_vpl VALUES ("AC17_16","074_17_16","ACT","17","16","16","Ɔlɔ á Polo sœ lima kœkate Asila dœ Timote lœ Atene, tshe sœ dœ oyo tœ lɔsu ye mbœrœ kœwu adœke ongbonœ sœ lima dœ andjaba waa lœnœ. ");
INSERT INTO mnh_vpl VALUES ("AC17_17","074_17_17","ACT","17","17","17","Tshe sœ lima kœpa o'o pa o'o ama Ndjaba dœ Ayuda œdœ angbɨ azu á endje sœ kœdonga Ndjaba lœ Sinagoga œdœ pe ndje azu neke á tshe li kœgbɔtœ ye dœ endje ɔlɔ dœ ɔlɔ ala wutunœ asœmœ. ");
INSERT INTO mnh_vpl VALUES ("AC17_18","074_17_18","ACT","17","18","18","Anga azu kœwusœrœ á endje sœ kœyisœ gbetshelœ nœ Aepikure ndje dœ astoyise tetœ kœpa o'o dœ she. Anga endje sœ lima kœpa adœke: «O'o gaɗe dá kulupunœ asœ œ pa ata a?» Anga endje á endje dji she kœpa o'o tœ upu nœ Yisu œdœ pe tœ o'o kœshe nœ ye lœ kuzu pa adœke: «Œ sœ ɓata tshe kœdœ ayi kœyisœ o'o ama andjaba tshelœ anga angbɨ ogo.» ");
INSERT INTO mnh_vpl VALUES ("AC17_19","074_17_19","ACT","17","19","19","Yé endje za she, œ ro dœ she ga tœ osho kœwa ngbanga tœnœ á ɨ'ɨrɨnœ kœdœ Areopaje yé œ yu she adœke: «'A li kœwusœ tafo kœyisœrœ nœ zœ á ɓœ sœ kœyisœ nœ asœ nene a? ");
INSERT INTO mnh_vpl VALUES ("AC17_20","074_17_20","ACT","17","20","20","Gbambanœ nene, asœ kɔ kœdœ tafo œrœ yé ɓœ sœ kœpa o'o á sœ kœko uvuru 'a lœnœ, yé 'a yindœ kœwusœ ádánœ.» ");
INSERT INTO mnh_vpl VALUES ("AC17_21","074_17_21","ACT","17","21","21","Mbœrœ azu kɔ lœ ogo Atene œdœ pe agene á endje sœ ɓa zœ, sœ ɔlɔ dœ ɔlɔ kolœ mbœrœ kœdji too mbœrœ kœpatœ œsœ tafo œrœnœ á wuta asœ. ");
INSERT INTO mnh_vpl VALUES ("AC17_22","074_17_22","ACT","17","22","22","Yé Polo ka kpœguru Areopaje, œ pa adœke: «E'e dœ azu lœ Atene, mœ wu adœke e'e kœdœ azu á 'e sœ kœzatœ 'e waa ga tœ andjaba nœ 'e. ");
INSERT INTO mnh_vpl VALUES ("AC17_23","074_17_23","ACT","17","23","23","Ɔlɔ á mœ sœ kœna lœ ongbo nœ 'e, mœ sœ kœwu œrœ á 'e gɨ á ko tɔ ɓata andjaba nœ 'e œdœ pe ndaba á 'e mbœrœ á su mbeti ga tœ nœ adœke: “Fœ anga ndjaba á 'a wuwusœ ye nene.” Andaa mœ na kœpandœ Ndjaba á 'e sœ kœdonga she, ataa 'e wuwusœ ye nene. ");
INSERT INTO mnh_vpl VALUES ("AC17_24","074_17_24","ACT","17","24","24","Ndjabanœ asœke kœdœ tsheneke á tshe mbœrœ tshapa ɔshɔ asœ dœ œrœ kɔ pa nœ, œshe kœdœ Gbozu nœ tshalafo dœ tsha atɨ. Tshe sœsœ lœ anda á azu mbœrœ dœ kane endje nene. ");
INSERT INTO mnh_vpl VALUES ("AC17_25","074_17_25","ACT","17","25","25","Tshe sœsœ dœ gbetshelœ adœke azu gbe dœ œne ɓata tshe sœ dœ ogo anga œrœ nene, kashe œshe dá sœ kœto soro fœ azu kɔ, dœ ɨzɨ á azu œ wu asœmœ œdœ pe udu œrœ kɔ. ");
INSERT INTO mnh_vpl VALUES ("AC17_26","074_17_26","ACT","17","26","26","«Kœto tœ uzu bale, tshe mbœrœ azu kɔ adœke endje sœ pa ɔshɔnœ asœke. Kashe utshu kœmbœrœ endje, tshe dɨ olo kœsœ nœ endje yé œ wa mapaka ogo kɔ á li adœke endje sœ tœnœ. ");
INSERT INTO mnh_vpl VALUES ("AC17_27","074_17_27","ACT","17","27","27","Ndjaba mbœrœ endje adœke endje para œne, œdœ endje kœsœ kœtaɓa osho na tœnœ, endje gbɔ œne á œne sœsœ lœ ɨngɨrɨnœ tœ azœ nene asœmœ. ");
INSERT INTO mnh_vpl VALUES ("AC17_28","074_17_28","ACT","17","28","28","Gbambanœ nene, “lœ awa nœ ye dá a sœ dœ soro, á sœ kœna ana, yé á sœpe dœ soro.”» «Mbœrœ tœnœ atamœ dá anga aayi kœsu itshi nœ 'e pa lima ndœ nœ adœke: “Azœ kœdœ ndje agbolo nœ ye.”» ");
INSERT INTO mnh_vpl VALUES ("AC17_29","074_17_29","ACT","17","29","29","«Ɓata azœ kœdœ agbolo nœ ye, a katœ kœgbe adœke Ndjaba li dœ œrœ á endje gɨ dœ ɔrœ, dœ kowo œdœ dœ badja á endje mbœrœ dœ kane liaka gbetshelœ nœ uzu. ");
INSERT INTO mnh_vpl VALUES ("AC17_30","074_17_30","ACT","17","30","30","Utshunœ liya, Ndjaba djerœndœ nœ kɔ gbambanœ nene, azu wuwu lima sœ œrœ á endje sœ kœmbœrœ tœnœ nene. Kashe ngɔngɔ asœke, tshe pa fœ azu kɔ, tœ osho kɔ adœke endje fatshalɔsu endje. ");
INSERT INTO mnh_vpl VALUES ("AC17_31","074_17_31","ACT","17","31","31","Mbœrœ tœnœ ataa, tshe guma anga olo bale tœ kœwa ngbanga pa azu para dœ mara ndjii lœ awa nœ uzu á tshe ke she. Tshe she uzunœ asœmœ lœ akuzu mbœrœ kœma fœ azu adœke œne dá ke she.» ");
INSERT INTO mnh_vpl VALUES ("AC17_32","074_17_32","ACT","17","32","32","Kœdji adœke Polo pa o'o nœ kœshe lœ akuzu, anga endje tetœ ɔmɔ, yé anga endje pa fœ she adœke: «'A kpa dji ɓœ kœpa o'o asœ lœ anga olo.» ");
INSERT INTO mnh_vpl VALUES ("AC17_33","074_17_33","ACT","17","33","33","Ataa, Polo kœwuta lima ugurutœ endje. ");
INSERT INTO mnh_vpl VALUES ("AC17_34","074_17_34","ACT","17","34","34","Kashe, anga endje na lima manda ye, yé œ te ayindœ Yisu. Azunœ dœke: Denise anga ayi kœwa ngbanga lœ Areopaje dœ anga yashe bale á ɨ'ɨrɨ ye kœdœ Damarise œdœ pe anga azunœ. ");
INSERT INTO mnh_vpl VALUES ("AC18_1","074_18_1","ACT","18","1","1","Manda Atene, Polo ro ga lœ Koriti. ");
INSERT INTO mnh_vpl VALUES ("AC18_2","074_18_2","ACT","18","2","2","Tshe togba dœ anga uzu Yudanœ bale ɨ'ɨrɨ ye kœdœ Akila, endje zu she ɓa lœ ogo Pone. Tshe to lima kolœ olonœ asœmœ ɓa lœ Itali awa bale dœ awonœ dœ Prisile, mbœrœ gbozugo Klode za o'o adœke Ayuda para wuta lœ Roma. Polo sœ lima kœna ga ndœ endje. ");
INSERT INTO mnh_vpl VALUES ("AC18_3","074_18_3","ACT","18","3","3","Yé ɓata á endje sœ lima lœ akwa bale, ayi kœmbœrœ ɔkɔ agea dœ gbanda, tshe gu ndœ kœlo ɓa ndœ endje yé endje sœ liya kœmbœrœ akwanœ asœmœ. ");
INSERT INTO mnh_vpl VALUES ("AC18_4","074_18_4","ACT","18","4","4","Lɔkɔ sabata bale dœ bale, Polo sœ lima kœmɨndœ Ɔtshɔ O'o sœnda Sinagoga œdœ pe kœtetœ kœfa gbetshelœ nœ Ayuda dœ Agreke. ");
INSERT INTO mnh_vpl VALUES ("AC18_5","074_18_5","ACT","18","5","5","Lɔkɔ á Atimote dœ Sila yi lima kumu endje kœto lœ Masedwane, Polo zatœ ye tɨ djigi ndœ Ɔtshɔ O'o, tshe ma fœ Ayuda adœke Yisu kœdœ Masiya. ");
INSERT INTO mnh_vpl VALUES ("AC18_6","074_18_6","ACT","18","6","6","Kashe endje sœ lima kœshara she dœ kœgu she, Polo mea lœba ye, œ pa fœ endje adœke: «Indji 'e œ sœ pa kumu 'e dœ tœ 'e, mœ sœ yerœ lœ nœ, yé kœto kpesheke, mœ na ga ndœ angbɨ azu.» ");
INSERT INTO mnh_vpl VALUES ("AC18_7","074_18_7","ACT","18","7","7","Manda kœgitœ ye kpœtœmœ, tshe na ga ndœ anga uzu bale á ɨ'ɨrɨ ye kœdœ Titiuse Justuse, á tshe kœdœ uzu kœdonga Ndjaba nœ Ayuda yé anda nœ ye sœ lima ɨndɨrɨ Sinagoga. ");
INSERT INTO mnh_vpl VALUES ("AC18_8","074_18_8","ACT","18","8","8","Krispuse, gbozu tshapa Sinagoganœ asœmœ, yi lima ndœ Gbozu, œshe dœ azu tshasœnda nœ ye para. Anga azu ndjoro lœ Koriti á endje sœ ndje lima kœdji Polo, yi ndje ndœ Yisu yé œ gbɔ batisimu. ");
INSERT INTO mnh_vpl VALUES ("AC18_9","074_18_9","ACT","18","9","9","Anga butshɔ bale, Gbozu pa fœ Polo lœ ulu adœke: «Sœsœ dœ awa nene, sœsœ ndje koko nene, ");
INSERT INTO mnh_vpl VALUES ("AC18_10","074_18_10","ACT","18","10","10","gbambanœ nene, mœ sœ dœ ɓœ awa bale. Uzu bale œ li kœto kane ye ga tœ zœ á kœmbœrœ œrœ kanga fœ ɓœ nene, mbœrœ ɨlɨ azu á endje sœ lœ ongbonœ asœ kœdœ azu nœ mœ.» ");
INSERT INTO mnh_vpl VALUES ("AC18_11","074_18_11","ACT","18","11","11","Polo lo lœ Koriti ungu bale dœ yapu mindu dœ bale, ndœ kœyisœ o'o ama Ndjaba. ");
INSERT INTO mnh_vpl VALUES ("AC18_12","074_18_12","ACT","18","12","12","Lɔkɔ á Galiyo kœdœ lima gbozugo Akayi, Ayuda zɨ tshelœ o'o ndœ kœmbœrœ ekperœ tœ Polo, endje za she œ na dœ she ɓa tœ osho kœwa ngbanga. ");
INSERT INTO mnh_vpl VALUES ("AC18_13","074_18_13","ACT","18","13","13","Yé œ pa adœke: «Uzu asœ sœ kœdjingili tshelœ kumu azu dœ o'o adœke endje donga Ndjaba neke á awa akwa ogo nœ azœ wa adœke 'a dodonga she nene.» ");
INSERT INTO mnh_vpl VALUES ("AC18_14","074_18_14","ACT","18","14","14","Polo kœyindœ kœpa o'o kane, Galiyo kœgi fœ Ayuda adœke: «Œ kœdœ má adœke uzu asœ mbœrœ ekperœ, too œ ta ɓango, mœ dji ma 'e ye. ");
INSERT INTO mnh_vpl VALUES ("AC18_15","074_18_15","ACT","18","15","15","Kashe ɓata œ sœ tœ upu nœ kœshara o'o ugurutœ ye tœ kœyisœrœ, dœ anga ɨ'ɨrɨ œdœ pe ndje awa o'o nœ 'e dœ tœ 'e, œ wu 'e. Mœ yiyindœ mara ngbanga atake nene.» ");
INSERT INTO mnh_vpl VALUES ("AC18_16","074_18_16","ACT","18","16","16","Yé á gɔrɔ endje tœ œsœ kœwa ngbanga ye. ");
INSERT INTO mnh_vpl VALUES ("AC18_17","074_18_17","ACT","18","17","17","Endje para tepa Sosetene gbozu tshapa Sinagoga, œ ɓi she ɓa utshu osho kœwa ngbanga. Kashe Galiyo gbegbe lima dœ tœnœ nene. ");
INSERT INTO mnh_vpl VALUES ("AC18_18","074_18_18","ACT","18","18","18","Œndœ Polo dɨ lima waa lœ Koriti, manda nœ á tshe katœ aayanœ lœ Yisu, á za awa kœro ga lœ Siri. Prisile dœpe Akila ro lima tœ awanœ dœ she. Ɓa tœ mangu nœ ongbo Sakre utshu kœli she ga lœ egerœ agba, tshe tshowa sukumu ye pa ye mbœrœ uvu á tshe za liya fœ Ndjaba. ");
INSERT INTO mnh_vpl VALUES ("AC18_19","074_18_19","ACT","18","19","19","Ɔlɔ á endje wuta ga lœ Efeze, Polo katœ Akila dœ Prisile tɨ kpœtœmœ á na œnœ ye ga lœ Sinagoga ndœ kœpa o'o dœ Ayuda. ");
INSERT INTO mnh_vpl VALUES ("AC18_20","074_18_20","ACT","18","20","20","Ɓata endje kpœtœmœ sœ lima kœdɨ tshelœma endje adœke œndœ ye dɨ dœ œne kane, Polo vwaratœ ye. ");
INSERT INTO mnh_vpl VALUES ("AC18_21","074_18_21","ACT","18","21","21","Kashe ndœ kœro lima she ga utshunœ, tshe pa o'o fœ endje adœke: «Mœ kwa bala tœmœ ga ndœ 'e, œdœ Ndjaba kœyindœ nœ.» Tshe kœɔ ga lœ egerœ agba la ungu lœ Efeze. ");
INSERT INTO mnh_vpl VALUES ("AC18_22","074_18_22","ACT","18","22","22","Kœjerœ ga lœ Sezaré, tshe ro ga lœ Yerusaleme mbœrœ kœbala azu tshelœ anda Ndjaba, manda nœ dœ kœro she ga lœ Atiɔshe. ");
INSERT INTO mnh_vpl VALUES ("AC18_23","074_18_23","ACT","18","23","23","Ɓa zœ, olo ye ngbangba lima nene. Manda nœ, tshe kœkwa lakpɨ bale dœ bale lœ ogo Galate dœ Friji, tshe ka kœpa fœ ayindœ Yisu adœke endje shi gbɨ lœ kœyindœrœ nœ endje. ");
INSERT INTO mnh_vpl VALUES ("AC18_24","074_18_24","ACT","18","24","24","Anga uzu Yuda bale ɨ'ɨrɨ ye kœdœ Apolo, uzu lakpɨ Alekezandri lœ ogo Ezipito, na lima ga lœ Efeze. Œshe kœdœ uzu nœ kœwusœ kœpa o'o dœ ɔtshɔnœ, œ wu ndje sœ Buku nœ Ndjaba tœ ɔtshɔnœ waa. ");
INSERT INTO mnh_vpl VALUES ("AC18_25","074_18_25","ACT","18","25","25","Endje yi lima sœ œrœ fœ she tœ upu nœ awa nœ Gbozu. Ɨshirɨ ye su dœ gbɔgbɔ, tshe mɨndœ o'o yé œ yisœ œrœ tœ pu nœ Yisu dœ ɔtshɔnœ waa. Kashe tshe wu lima kolœ œsœ batisimu á Yowane za lima fœ azu. ");
INSERT INTO mnh_vpl VALUES ("AC18_26","074_18_26","ACT","18","26","26","Tshe sœ lima kœpandœ Yisu dœ gbɔgbɔ kɔ lœ Sinagoga. Kashe manda kœdji she, Prisile œdœ Akila e she ɓa ndœ endje, yé œ kpa ma adja awa nœ Ndjaba fœ she. ");
INSERT INTO mnh_vpl VALUES ("AC18_27","074_18_27","ACT","18","27","27","Ɓata á tshe sœ lima dœ gbetshelœ nœ kœro ga lœ Akayi, ayanœ lœ Yisu sœ dœ yanga nœ agbe nœ ye, yé œ su mbeti fœ ayindœ Yisu ɓa zœ adœke endje za osho kœsœ fœ she. Manda kœwuta she ɓa zœ, tshe tɨ kane ayindœ Yisu ndjoro dœ ɔtshɔ lɔsu nœ Ndjaba. ");
INSERT INTO mnh_vpl VALUES ("AC18_28","074_18_28","ACT","18","28","28","Gbambanœ nene, tshe pa ngbɨ fœ Ayuda tœ ala azu adœke endje dji awa adja o'o, yé œ sœ lima kœma lœ awa nœ Buku nœ Ndjaba adœke Yisu kœdœ Masiya. ");
INSERT INTO mnh_vpl VALUES ("AC19_1","074_19_1","ACT","19","1","1","Ɔlɔ á Apolo sœ lima ɓa lœ Koriti, Polo ro lima tɔ lœ kaga lœ aya Azi yeka á jerœ ga lœ Efeze. Ɓa zœ, tshe gbɔ lima anga ayindœ Yisu, ");
INSERT INTO mnh_vpl VALUES ("AC19_2","074_19_2","ACT","19","2","2","á yu endje adœke: «'E gbɔ lima Ɔtshɔ Ɨshirɨ ɔlɔ á 'e te ayindœ Yisu ye a?» Endje kœgi fœ she adœke: «'A djidji ndje anga nœ adœke Ɔtshɔ Ɨshirɨ sœ zœ nene.» ");
INSERT INTO mnh_vpl VALUES ("AC19_3","074_19_3","ACT","19","3","3","Polo kpa kœyu endje adœke: «Ka batisimu gaɗe dá 'e gbɔ a?» Endje kœgi fœ she adœke: «'A gbɔ batisimunœ á Yowane ayi kœza Batisimu yisœ nœ.» ");
INSERT INTO mnh_vpl VALUES ("AC19_4","074_19_4","ACT","19","4","4","Polo kœgi adœke: «Adjapu Yowane sœ lima kœza batisimu fœ azu á endje fatshalɔsu endje, yé tshe sœ lima kœpa fœ endje adœke endje yindœ uzu á tshe na manda œne, œ yindœ kœpa adœke Yisu.» ");
INSERT INTO mnh_vpl VALUES ("AC19_5","074_19_5","ACT","19","5","5","Endje dji o'onœ asœmœ, yé œ gbɔ lima batisimu dœ ɨ'ɨrɨ Gbozu Yisu. ");
INSERT INTO mnh_vpl VALUES ("AC19_6","074_19_6","ACT","19","6","6","Polo kœto kane ye ga pa endje, yé endje kœgbɔ Ɔtshɔ Ɨshirɨ. Endje tetœ kœpa tafo o'o ama ogo dœ pe kœmɨndœ o'o á to ɓa ndœ Ndjaba. ");
INSERT INTO mnh_vpl VALUES ("AC19_7","074_19_7","ACT","19","7","7","Azu wuta lima kɔkɔ ga pa œrœ nœ́ ndjokpa dœ bisha. ");
INSERT INTO mnh_vpl VALUES ("AC19_8","074_19_8","ACT","19","8","8","Polo sœ lima kœro ga lœ Sinagoga, yé lœ yapu votɔ, tshe sœ lima kœyisœ œrœ tœ upu nœ Ogo gbozu nœ Ndjaba dœ awa nene, yé œ pa o'o dœ mara adœke endje á endje dji she, yindœ o'o á tshe sœ kœpa tœnœ. ");
INSERT INTO mnh_vpl VALUES ("AC19_9","074_19_9","ACT","19","9","9","Kashe anga azu sœ lima dœ gbɔkumu, œ vwaratœ endje tœ kœyindœ nœ yé œ sœ kœmɔ awa nœ Gbozu kpœtœ ala angbɔtœ. Polo katœ endje tɨ œ ko ayindœ Yisu potœ ye, yé œ tetœ kœyisœ œrœ fœ endje ɔlɔ dœ ɔlɔ ɓa lœ anda lakɔrɔ nœ Tiranuse. ");
INSERT INTO mnh_vpl VALUES ("AC19_10","074_19_10","ACT","19","10","10","Tshe mbœrœ lima ataa manda ungu bisha yeka á azu kɔ á endje sœ lœ ogo Azi, œdœ Ayuda œdœ Agreke, endje dji lima o'o nœ Gbozu. ");
INSERT INTO mnh_vpl VALUES ("AC19_11","074_19_11","ACT","19","11","11","Ndjaba sœ lima kœmbœrœ ogboro œrœ lœ awa nœ Polo. ");
INSERT INTO mnh_vpl VALUES ("AC19_12","074_19_12","ACT","19","12","12","Mbœrœ tœnœ ataa, anga azu sœ lima kœgu dœ siriki á goro ɔkɔ Polo fœ aayi koɓa. Koɓa nœ endje ka lima tœ endje yé ekpe ɨshirɨ gi lima tœ ye pa azu. ");
INSERT INTO mnh_vpl VALUES ("AC19_13","074_19_13","ACT","19","13","13","Anga Ayuda á endje sœ lima kœro dje tœ osho kɔ kœgɔrɔ ekpe ɨshirɨ pa azu koɓa asœmœ yamba lima kœgɔrɔ ekpe ɨshirɨ dœ ɨ'ɨrɨ Gbozu. Endje pa lima adœke: «Mœ pa fœ 'e adœke dœ ɨ'ɨrɨ Gbozu Yisu á Polo œ yisœ œrœ tœ upu nœ ye asœmœ, 'e wuta ye!» ");
INSERT INTO mnh_vpl VALUES ("AC19_14","074_19_14","ACT","19","14","14","Azu á endje le lima œrœ nœ asœmœ kœdœ agbolo yakoshe mindu dœ bisha (7) nœ anga gbozu nganga Ndjaba nœ Ayuda á ɨ'ɨrɨ ye kœdœ Seva. ");
INSERT INTO mnh_vpl VALUES ("AC19_15","074_19_15","ACT","19","15","15","Kashe ɔlɔ bale, ekpe ɨshirɨ gi lima fœ endje adœke: «Yisu a? Mœ wusœ ye, yé mœ wu ndje sœ Polo. Kashe e'e a, 'e kœdœ aɗe e?» ");
INSERT INTO mnh_vpl VALUES ("AC19_16","074_19_16","ACT","19","16","16","Yé yakoshe á tshe sœ dœ ekpe ɨshirɨnœ pa ye kœi ga ugurutœ endje dœ gbɔgbɔ kɔ, œ kœtetœ kœɓi lima endje, œ suru tshelœ lœba, dœ pe kœtu uku tœ endje, á endje tɔ lima sœnda dœ ɔrɔ á kpa ye. ");
INSERT INTO mnh_vpl VALUES ("AC19_17","074_19_17","ACT","19","17","17","Azu para lœ Efeze, Ayuda dœ pe angbɨ azu dji lima o'onœ asœmœ, yé awa za endje yeka á endje lɨ lima œsœ ɨ'ɨrɨ Gbozu Yisu. ");
INSERT INTO mnh_vpl VALUES ("AC19_18","074_19_18","ACT","19","18","18","Azu ndjoro á endje yi lima ndœ Yisu, tetœ kœna tœnœ mbœrœ kœpandœ ekperœ á endje mbœrœ lima dœ tshama endje ga lafo. ");
INSERT INTO mnh_vpl VALUES ("AC19_19","074_19_19","ACT","19","19","19","Anga endje ndjoro á endje sœ lima kœfa œrœ tsharawo, ko œrœ nœ endje para ga shu, yé á endje sho lima ukpulunœ tœ ala azu para. Endje dɨ lima œrœnœ kɔ mbœrœ kœwusœ amanœ, œ wu lima adœke mbetinœ kɔ á endje sho li dœ Langere ngendja kutu zazu bisha dœ ndjokpa (250.000). ");
INSERT INTO mnh_vpl VALUES ("AC19_20","074_19_20","ACT","19","20","20","Mbœrœ tœnœ ataa, Ɔtshɔ O'o za lima osho, azu ndjoro yi lima ndœ nœ lœ awa nœ gbɔgbɔ nœ Gbozu. ");
INSERT INTO mnh_vpl VALUES ("AC19_21","074_19_21","ACT","19","21","21","Manda o'onœ asœmœ, Polo wa o'o lœ awa nœ Ɨshirɨ kœro ga lœ Yerusaleme yé tshe vwanga tɔ lœ Masedwane dœ pe Akayi. Tshe pa ndje adœke: «Ɔlɔ á mœ kœwuta ɓa zœ, œ li ndje adœke mœ kpa ro ndje ga lœ Roma.» ");
INSERT INTO mnh_vpl VALUES ("AC19_22","074_19_22","ACT","19","22","22","Tshe vwa anga anganœ bisha, Atimote dœ Eraste ga lœ Masedwane, yé œ sœpe damba œnœ ye lima kœlo lœ Azi. ");
INSERT INTO mnh_vpl VALUES ("AC19_23","074_19_23","ACT","19","23","23","Kolœ dœ lɔndɔnœ asœmœ dá egerœ djingili wuta lima tœ upu nœ awa nœ Gbozu ɓa lœ Efeze. ");
INSERT INTO mnh_vpl VALUES ("AC19_24","074_19_24","ACT","19","24","24","Anga ayi kœfatshelœ ɔrœ, á ɨ'ɨrɨ ye kœdœ Demetriyuse, sœ lima kœmbœrœ a 'eara anda tepelo nœ Artemise dœ kœwo, yé œ sœ lima kœte ngendja fœ endje waa. ");
INSERT INTO mnh_vpl VALUES ("AC19_25","074_19_25","ACT","19","25","25","Tshe ngbɔɓa lima aayi kœfatshelœ ɔrœ dœ pe anga aayi akwa kɔ á endje sœ lima kœmbœrœ mara akwanœ asœmœ, á pa fœ endje adœke: «'E wusœ nœ ye anga mœ; a kœsœ dœ ɔtshɔnœ, œ to kolœ manda akwa nœ azœ asœ. ");
INSERT INTO mnh_vpl VALUES ("AC19_26","074_19_26","ACT","19","26","26","Yé 'e sœ kœwu tœnœ too 'e sœ kœdji azu kœpa adœke: Polonœ asœmœ sœ kœmɨndœ nœ adœke andjaba á azu mbœrœ endje dœ kane endje dœ́dœ́ ɔtshɔ andjaba nene. Azu ndjoro dji o'onœ yé œ fa lɔsu endje ndœ nœ. Tshe mbœmbœrœ kolœ ɓa lœ Efeze nene, kashe dje ndje lœ Azi para. ");
INSERT INTO mnh_vpl VALUES ("AC19_27","074_19_27","ACT","19","27","27","Œ dœ́dœ́ kolœ azœ dá o'onœ asœ œ ndɨ akwa nœ azœ nene, kashe œ ndɨ ndje anda Tepelo nœ egerœ ndjaba yashe Artemise. Azu œ wu andanœ gbambanœ yé endje kpa lɨsœ nœ nene. Mbœrœ Azi dœ pe ogo djigi sœ lima kœdonga ndjabanœ asœmœ.» ");
INSERT INTO mnh_vpl VALUES ("AC19_28","074_19_28","ACT","19","28","28","Manda kœpa o'onœ asœmœ ataa, azu kɔ á endje dji djerœ ókó, œ sœ kœta rawa adœke: «Artemise, egerœ ndjaba yashe lœ ongbo Efeze!» ");
INSERT INTO mnh_vpl VALUES ("AC19_29","074_19_29","ACT","19","29","29","Azu tshelœ ongbonœ djigi oma dœ o'o kekeke. Endje ko anga Polo á endje na tœ awa akwanœ bale dœ she, Agayuse dœ pe Aristarke azu Masedwane, na tœnœ ga la wutu mɔlɔ. ");
INSERT INTO mnh_vpl VALUES ("AC19_30","074_19_30","ACT","19","30","30","Polo yi lima ndœ kœwuta ga utshu azunœ ga zœ, kashe ayambarœ pakata she yé. ");
INSERT INTO mnh_vpl VALUES ("AC19_31","074_19_31","ACT","19","31","31","Anga aayi akwa nœ lita á endje dœ lima anga Polo mɨ lima upu fœ she adœke, tshe kpa nana ga la wutu mɔlɔnœ nene. ");
INSERT INTO mnh_vpl VALUES ("AC19_32","074_19_32","ACT","19","32","32","Dœ lɔndɔnœ asœmœ, uzu dœ uzu sœ lima kœta rawa nœ ye dœ o'o nœ ye kpikpikpi, yé azu ndjoro ugurutœ endje kpa wuwusœ ádá á endje ngbɔtœ endje ndœ nœ nene. ");
INSERT INTO mnh_vpl VALUES ("AC19_33","074_19_33","ACT","19","33","33","Anga azu lœ ukpulu azunœ mɨndœ upunœ fœ anga uzu bale á ɨ'ɨrɨ ye kœdœ Alekezandre á Ayuda gavwa she ɓa utshu endje. Á tshe yi kane ye ga lafo ndœ kœyu o'o. ");
INSERT INTO mnh_vpl VALUES ("AC19_34","074_19_34","ACT","19","34","34","Kashe ɔlɔ á ndje wusœ nœ adœke œshe kœdœ uzu Yuda, endje kpa ta rawa manda ada ɔlɔ bisha adœke: «A donga Artemise lœ Efeze!» ");
INSERT INTO mnh_vpl VALUES ("AC19_35","074_19_35","ACT","19","35","35","Manda nœ, anga gbozu tshelœ ongbonœ u endje ga tœnœ yé á pa adœke: «Azu Efeze, uzu ɗe dá wuwusœ nœ adœke ongbo Efeze sœ dœ anda tepelo nœ Artemise œdœ pe œrœ á endje gɨ á to ɓa lafo á te nene a? ");
INSERT INTO mnh_vpl VALUES ("AC19_36","074_19_36","ACT","19","36","36","Uzu bale œ shara o'onœ asœ nene, œ li adœke a sœ koko, yé a katœ kœmbœrœ œrœ á ádánœ gugu nene. ");
INSERT INTO mnh_vpl VALUES ("AC19_37","074_19_37","ACT","19","37","37","Azu á 'e to endje na tœnœ ga mœ asœ gugu œsœ ndjaba nœ azœ nene, endje zɨzɨ ndje angba nene. ");
INSERT INTO mnh_vpl VALUES ("AC19_38","074_19_38","ACT","19","38","38","Œ kœsœ adœke Demetriyuse dœ pe azu akwa nœ ye asœ sœ dœ o'o dœ uzu, uzunœ na œ tɔ meza pa ye, ayi kœwa o'o sœ zœ dœ pe olo ngbanga sœ ndje zœ. ");
INSERT INTO mnh_vpl VALUES ("AC19_39","074_19_39","ACT","19","39","39","Yé anga o'o kœsœ ndje zœ, osho á azu œ ngbɔtœ endje ga tœnœ kœguma o'o, œ wa o'onœ zœ. ");
INSERT INTO mnh_vpl VALUES ("AC19_40","074_19_40","ACT","19","40","40","A gbɔ o'o tœ œrœ á a ngbɔtœ azœ ga tœnœ kpesheke á mbœrœ asœ. Azu œ e azœ tœ aayi kœoma dœ o'o. Gbambanœ nene, anga uzu kœtɔ meza pa azœ, o'o nœ kœpa tœnœ œ gu nene.» Manda o'onœ asœ, tshe pa fœ azu adœke endje gu ga mangba endje. ");
INSERT INTO mnh_vpl VALUES ("AC20_1","074_20_1","ACT","20","1","1","Ɔlɔ á djingili o'onœ ka ye, Polo ngbɔɓa ayambarœ ga tœnœ œ mɨ upu fœ endje, œ bala endje dœ kœza awa ga lœ Masedwane. ");
INSERT INTO mnh_vpl VALUES ("AC20_2","074_20_2","ACT","20","2","2","Kœro she tɔ lœ ogonœ asœmœ, tshe mɨ lima upu waa fœ ayanœ lœ Yisu, manda nœ á wuta ga lœ Grese. ");
INSERT INTO mnh_vpl VALUES ("AC20_3","074_20_3","ACT","20","3","3","Tshe mbœrœ lima yapu votɔ ɓa zœ. Ɔlɔ á tshe yi lima ndœ kœɔ ga lœ egerœ agba kœro ga lœ Siri, ɓata Ayuda sœ lima kœvwarandœ ye á tshe dji, á kpa kwa dja ga lœ Masedwane. ");
INSERT INTO mnh_vpl VALUES ("AC20_4","074_20_4","ACT","20","4","4","Anganœ lœ ana kœdœ lima: Sapatrose gbolo yakoshe nœ Piruse uzu Bere, Aristarke dœ pe Sekunduse azu Tesalonike, Gayushi uzu Derbe, Timote, Tishike dœ pe Trofime azu ogo Azi. ");
INSERT INTO mnh_vpl VALUES ("AC20_5","074_20_5","ACT","20","5","5","Kœwuta ga lœ ogo Masedwane, endje ro lima œnœ endje utshunœ kœkate 'a ɓa lœ Trowase. ");
INSERT INTO mnh_vpl VALUES ("AC20_6","074_20_6","ACT","20","6","6","Yé a'a nœ 'a, manda angbo nœ mapa á susuku nene, á ɔ ga lœ egerœ agba tœ mangu Filipo œ mbœrœ olo mindu, á togba dœ endje lœ Trowase á mbœrœ pɔsɔ bale dœ endje. ");
INSERT INTO mnh_vpl VALUES ("AC20_7","074_20_7","ACT","20","7","7","Dœ ɔlɔ yenga dœ akɨdala, 'a ngbɔ lima tœ 'a ga tœnœ ndœ kœkurutshelœ mapa, Polo sœ kœmɨndœ 'o ama Ndjaba fœ aayanœ lœ Yisu œrrr ga tœ tshaguru butshɔ mbœrœ œ li lima adœke osho kœkɔrɔ tshe ro. ");
INSERT INTO mnh_vpl VALUES ("AC20_8","074_20_8","ACT","20","8","8","Miinda sœ lima zœ lœ gbɔshɔ ɓa lafo á angbɔtœ 'a ga lœ nœ. ");
INSERT INTO mnh_vpl VALUES ("AC20_9","074_20_9","ACT","20","9","9","Anga djagbala yakoshe á ɨ'ɨrɨ ye kœdœ Etike, tshe sœ lima ga tœ ape ɨzɨ, olo za she kpakpakpa, ɓata Polo kaka lima damba tœ o'onœ nene, lœ olo, tshe djɔ œ te kœto ɓa tœ votɔ gbɔshɔ ɓa lafo œrrr ɓa atɨ. Kœyindœ kœti she ga lafo atake tshe tshu lima ye. ");
INSERT INTO mnh_vpl VALUES ("AC20_10","074_20_10","ACT","20","10","10","Polo jerœ ga atɨ, á na katsha ga ndœ ye á za she ga lakoro ye á pa adœke: «Awa zaza 'e nene, tshe sœpe dœ soro!» ");
INSERT INTO mnh_vpl VALUES ("AC20_11","074_20_11","ACT","20","11","11","Kpa kœɔ she ga lafo ga zœ, Polo kurutshelœ mapa tœ endje yé endje zɨ, manda nœ tshe pa 'o œrrr o 'ara yeka á ro. ");
INSERT INTO mnh_vpl VALUES ("AC20_12","074_20_12","ACT","20","12","12","Gbolo yakoshe asœmœ she ye, endje gu dœ she ga ndœ endje, yé lɔsu azu para kɔkɔ zɨ tɨɨ. ");
INSERT INTO mnh_vpl VALUES ("AC20_13","074_20_13","ACT","20","13","13","'A afo utshunœ, œ li ga lœ egerœ agba ndœ kœro ga lœ Asose. 'A yindœ kœza Polo ga ndœ 'a mbœrœ tshe yi lima ndœ kœro ga zœ dœ ada ye. ");
INSERT INTO mnh_vpl VALUES ("AC20_14","074_20_14","ACT","20","14","14","Ɔlɔ á tshe gbɔ 'a ɓa lœ Asose, 'a za she ga ndœ 'a ga lœ egerœ agba mbœrœ kœro ga lœ Mitilene. ");
INSERT INTO mnh_vpl VALUES ("AC20_15","074_20_15","ACT","20","15","15","Osho kɔrɔ panœ, 'a to kpœtœmœ 'a na ndoo dœ tshiki Kio. Manda olo bale 'a wuta ga tœ tshiki Samose, tœ bisha olo yeka á 'a wuta ga lœ Mile. ");
INSERT INTO mnh_vpl VALUES ("AC20_16","074_20_16","ACT","20","16","16","Polo wa lima adœke œne ka lœ Efeze nene, mbœrœ olo œ ro tœ œne lœ ogo Azi waa. Ogo nœ ye kœdœ lima kœwuta katsha ga lœ Yerusaleme lɔkɔ Patekɔte. ");
INSERT INTO mnh_vpl VALUES ("AC20_17","074_20_17","ACT","20","17","17","Ɓa lœ Mile, Polo vwa osho ndœ agbozu Ikrizia lœ Efeze. ");
INSERT INTO mnh_vpl VALUES ("AC20_18","074_20_18","ACT","20","18","18","Ɔlɔ á endje wuta ga ndœ ye, tshe pa fœ endje adœke: «'E wusœ ɔtshɔ mœ ugurutœ 'e, kœto tœ ali olo mœ á mœ na ga ndœ 'e lœ ogo Azi. ");
INSERT INTO mnh_vpl VALUES ("AC20_19","074_20_19","ACT","20","19","19","Mœ zaza tœmœ lœ ama akwa nœ Gbozu nene, mœ mbœrœ akwa dœ ngola lœ ala mœ, mœ wu oyo waa mbœrœ Ayuda sœ lima kœvwarandœ mœ. ");
INSERT INTO mnh_vpl VALUES ("AC20_20","074_20_20","ACT","20","20","20","Mœ zaza anga œrœ á li kœtɨ kane 'e yiwatœ nœ tœ 'e nene, mœ mɨndœ Yisu fœ 'e, mœ yisœ œrœ fœ 'e lœ ukpulu azu too ɓa sœnda nœ 'e. ");
INSERT INTO mnh_vpl VALUES ("AC20_21","074_20_21","ACT","20","21","21","O'o mœ sœ lima kœ'e Ayuda dœ Agreke adœke endje fa lɔsu endje fœ Ndjaba dœ pe kœyindœ Gbozu nœ azœ dœ Yisu. ");
INSERT INTO mnh_vpl VALUES ("AC20_22","074_20_22","ACT","20","22","22","«Ngɔngɔ asœ, Ɨshirɨ sœ kœvwa mœ ga lœ Yerusaleme, mœ wuwusœ neke á wuta ga tœ mœ ɓa zœ nene. ");
INSERT INTO mnh_vpl VALUES ("AC20_23","074_20_23","ACT","20","23","23","Kashe œneke á mœ wusœ nœ kœdœ lœ ongbo kɔ á mœ ro lœ nœ, Ɔtshɔ Ɨshirɨ sœ kœma fœ mœ adœke, kánga dœ pe œrœ oyo kɔ sœ kœkate mœ. ");
INSERT INTO mnh_vpl VALUES ("AC20_24","074_20_24","ACT","20","24","24","Kashe mœ wu adœke soro mœ sœ ɓata œrœ gbambanœ, ogo nœ mœ kœdœ mœ na œrrr ga tœ ndɔngɔlɔ akwa nœ mœ, yé ga tœ kœka akwa á Gbozu Yisu za fœ mœ adœke: mœ mɨndœ Ɔtshɔ O'o nœ ɔtshɔ lɔsu nœ Ndjaba ga ndœ azu. ");
INSERT INTO mnh_vpl VALUES ("AC20_25","074_20_25","ACT","20","25","25","«Ngɔngɔ nœ asœ, mœ wusœ nœ adœke 'e kpa wu mœ nene, e'e má mœ sœ lima ugurutœ 'e mbœrœ kœpandœ Ogo gbozu nœ Ndjaba fœ 'e. ");
INSERT INTO mnh_vpl VALUES ("AC20_26","074_20_26","ACT","20","26","26","Mbœrœ tœnœ ataa á mœ sœ kœpandœ nœ fœ 'e kɔ kpesheke adœke: indji 'e œ tu ga lœ kumu mœ nene. ");
INSERT INTO mnh_vpl VALUES ("AC20_27","074_20_27","ACT","20","27","27","Gbambanœ nene, mœ zaza anga o'onœ yiwa tœnœ tœ 'e nene, mœ pandœ awa akwa nœ Ndjaba para fœ 'e ye. ");
INSERT INTO mnh_vpl VALUES ("AC20_28","074_20_28","ACT","20","28","28","'E gbɔndœtœ 'e dœ tœ 'e, yé œ gbɔndœ azu á Ɔtshɔ Ɨshirɨ ko 'e tœ aayi kœgbɔndœ endje. 'E gbɔndœ Ikrizia nœ Ndjaba ɓata aayi kœgbɔndœ apata. 'E gbɔndœ nœ mbœrœ Ndjaba dá yɔ dœ indji Gbolo nœ ye dœ tœ ye. ");
INSERT INTO mnh_vpl VALUES ("AC20_29","074_20_29","ACT","20","29","29","Mœ wusœ nœ adœke aekpe azu œ na manda mœ, endje sœ ɓata amuru, endje wu oyo apatanœ nene. ");
INSERT INTO mnh_vpl VALUES ("AC20_30","074_20_30","ACT","20","30","30","Ugurutœ 'e ndje, anga anga 'e œ tetœ kœpa wala mbœrœ kœgbota ayindœ Yisu ga ndœ endje. ");
INSERT INTO mnh_vpl VALUES ("AC20_31","074_20_31","ACT","20","31","31","Ataa, ala 'e gbɔ, adja œndœ tœ 'e roro 'e nene. 'E gbe dœ ungu votɔ butshɔ dœ ɔlɔ dœ ngola lœ la mœ, mœ sœ lima kolœ kœna manda uzu dœ uzu ndœ kœgi she ga ugurutœ 'e. ");
INSERT INTO mnh_vpl VALUES ("AC20_32","074_20_32","ACT","20","32","32","«Yé ngɔngɔ asœ, mœ sœ kœko 'e ga tshakane Ndjaba, Ɔtshɔ O'o nœ ɔtshɔ lɔsu nœ ye gbɔndœ 'e, œ li kœza gbɔgbɔ fœ 'e ndje dœ kœko œrœ kɔ á tshe guma mbœrœ azu á tshe ke endje fœ 'e. ");
INSERT INTO mnh_vpl VALUES ("AC20_33","074_20_33","ACT","20","33","33","Mœ sœsœ lima dœ ogo œrœ nœ uzu bale nene, œdœ ngendja, ɔrœ too lœba. ");
INSERT INTO mnh_vpl VALUES ("AC20_34","074_20_34","ACT","20","34","34","'E wusœ nœ dœ tœ 'e adœke mœ mbœrœ lima akwa dœ kane mœ dœ tœ mœ yé á gbɔ œrœ á li dœ mœ dœ pe anga mœ á mœ na tœ awanœ bale dœ endje. ");
INSERT INTO mnh_vpl VALUES ("AC20_35","074_20_35","ACT","20","35","35","Mbœrœ tœnœ ataa, mœ sœ lima kœma fœ 'e adœke, 'e mbœrœ akwa yeka á kœto œrœ fœ endjeneke á endje mɔmɔ ugurutœ 'e, 'e gbe dœ o'o á Gbozu Yisu pa dœ tœ ye lima adœke: “Yanga nœ kœto œrœ fœ azu ropa œnœ kœgbɔ tœnœ ye.”» ");
INSERT INTO mnh_vpl VALUES ("AC20_36","074_20_36","ACT","20","36","36","Manda o'onœ, Polo gote ga atɨ dœ endje para ndœ kœ e Ndjaba. ");
INSERT INTO mnh_vpl VALUES ("AC20_37","074_20_37","ACT","20","37","37","Endje para endje tetœ ɨkɨ ye, œ yo ga dagɨ Polo ndœ kœ'uru tshelœ utu ye. ");
INSERT INTO mnh_vpl VALUES ("AC20_38","074_20_38","ACT","20","38","38","Endje sœ lima dœ oyo mbœrœ Polo pa fœ endje adœke, œne kpa wutœ œne dœ endje nene. Manda nœ á endje gi she na tœnœ œrrr ga lœ egerœ agba. ");
INSERT INTO mnh_vpl VALUES ("AC21_1","074_21_1","ACT","21","1","1","Manda kœkurutshelœtœ 'a dœ endje, 'a li ga lœ egerœ agba, 'a ro ga lœ tshiki Kose, osho kɔrɔ panœ 'a wuta ga lœ Rode, kœto kpœtœmœ dá 'a ro ga lœ Patara. ");
INSERT INTO mnh_vpl VALUES ("AC21_2","074_21_2","ACT","21","2","2","Kpœtœmœ, 'a gbɔ anga egerœ agba á sœ kœro ga lœ Fenisi, yeka 'a ɔ ga lœ nœ á ro. ");
INSERT INTO mnh_vpl VALUES ("AC21_3","074_21_3","ACT","21","3","3","Kœndo dœ Shipre, 'a katœ tshikinœ ga pa gele 'a, 'a za awa Siri, 'a jerœ ɓa lœ Tire ɓa tœ osho á endje yi lima ndœ kœko œrœ lœ egerœ agba ga shu. ");
INSERT INTO mnh_vpl VALUES ("AC21_4","074_21_4","ACT","21","4","4","'A mbœrœ lima pɔsɔ bale kpœtœmœ mbœrœ 'a gbɔ ayindœ Yisu. Lœ awa nœ Ɨshirɨ, endje pa fœ Polo adœke tshe nana ga lœ Yerusaleme nene. ");
INSERT INTO mnh_vpl VALUES ("AC21_5","074_21_5","ACT","21","5","5","Kashe ɔlɔ á olo 'a ka, endje na kœkatœ 'a ga tœ awa dœ awo endje dœ pe agbolo nœ endje. Yeka á 'a gote ɓa tœ mangu yé á za avwala. ");
INSERT INTO mnh_vpl VALUES ("AC21_6","074_21_6","ACT","21","6","6","Manda kœbala ndangba tœ 'a dœ endje, 'a ɔ ga lœ egerœ agba yeka á endje gu ga ndœ endje. ");
INSERT INTO mnh_vpl VALUES ("AC21_7","074_21_7","ACT","21","7","7","Kœto lœ Tire, 'a ro œrrr ga lœ Petolemayise, 'a mbœrœ kpœtœmœ olo bale ndœ kœbalatœ 'a dœ aaya 'a lœ Yisu. ");
INSERT INTO mnh_vpl VALUES ("AC21_8","074_21_8","ACT","21","8","8","Osho kɔrɔ panœ, 'a ro ga lœ Sezaré, ɓa zœ 'a ro ga ndœ ayi kœyisœ Ɔtshɔ O'o á ɨ'ɨrɨ ye kœdœ Filipo, 'a lo ɓa ndœ ye. Œshe kœdœ anga aayi kœtɨ kane aayi avwa á 'a ke lima endje mindu dœ bisha (7) lœ Yerusaleme. ");
INSERT INTO mnh_vpl VALUES ("AC21_9","074_21_9","ACT","21","9","9","Tshe sœ dœ ayawuru vana á endje sœpe dœ akpɔnœ, á sœ kœgbara o'o á to ɓa ndœ Ndjaba. ");
INSERT INTO mnh_vpl VALUES ("AC21_10","074_21_10","ACT","21","10","10","Yé 'a mbœrœ olo ndjoro lima kpœtœmœ, anga ayi kœgbara o'o to lœ Yuda œ na, ɨ'ɨrɨ ye kœdœ Agabuse. ");
INSERT INTO mnh_vpl VALUES ("AC21_11","074_21_11","ACT","21","11","11","Kœgbɔ 'a, tshe za uwu tshapa lœba nœ Polo á i dœ ada ye dœ pe kane ye, á pa adœke: «Ɔtshɔ Ɨshirɨ pa adœke mara á Ayuda œ i bala dœ ayengɔ uwu tshapa lœbanœ asœ ɓa lœ Yerusaleme á za she fœ anga angbɨ azu dœmœ.» ");
INSERT INTO mnh_vpl VALUES ("AC21_12","074_21_12","ACT","21","12","12","Manda kœdji o'onœ asœ, a'a dœ pe aaya lœ Yisu lœ ongbonœ, dɨ tshelœma 'a fœ Polo adœke, tshe nana ga lœ Yerusaleme nene. ");
INSERT INTO mnh_vpl VALUES ("AC21_13","074_21_13","ACT","21","13","13","Kashe Polo gi adœke: «Mbœrœ gaɗe dá 'e sœ kœkɨ tœnœ á sœ kœyi awa ga lɔsu mœ a? Mœ guma tœ mœ ndje adœke, endje za mœ ga lœ kánga dœ pe kœwo mœ ɓa lœ Yerusaleme mangba ɨ'ɨrɨ Gbozu Yisu ye.» ");
INSERT INTO mnh_vpl VALUES ("AC21_14","074_21_14","ACT","21","14","14","Ɓata á tshe yiyindœ o'o nœ 'a lima nene, 'a katœ kœshosho she yé á pa adœke: «Kaka adœke Gbozu mbœrœ lindœ gbetshelœ nœ ye.» ");
INSERT INTO mnh_vpl VALUES ("AC21_15","074_21_15","ACT","21","15","15","Manda olo teasho, 'a guma tœ 'a ndœ kœro ga lœ Yerusaleme. ");
INSERT INTO mnh_vpl VALUES ("AC21_16","074_21_16","ACT","21","16","16","Anga ayindœ Yisu lœ Sezaré á 'a ro tœ awanœ dœ endje lima, endje gbɔ osho kœlo tœnœ fœ 'a ɓa ndœ anga uzu bale lœ Shipre, ɨ'ɨrɨ ye kœdœ Manasone, œshe kœdœ anga yindœ Yisu ɓalima katshatsha. ");
INSERT INTO mnh_vpl VALUES ("AC21_17","074_21_17","ACT","21","17","17","Ɔlɔ á 'a wuta ga lœ Yerusaleme, alaya lœ Yisu uru tshelœ utu 'a dœ yanga. ");
INSERT INTO mnh_vpl VALUES ("AC21_18","074_21_18","ACT","21","18","18","Osho kɔrɔ panœ, 'a ro tœ awanœ bale dœ Polo ga ndœ Jake, osho á agbozu kuma akwa kɔ lœ Ikrizia œ ngbɔtœ endje ga tœnœ. ");
INSERT INTO mnh_vpl VALUES ("AC21_19","074_21_19","ACT","21","19","19","Manda kœbala endje, Polo pandœ œrœ kɔ á Ndjaba mbœrœ lima dœ she awa bale lœma akwa nœ ye ugurutœ angbɨ azu. ");
INSERT INTO mnh_vpl VALUES ("AC21_20","074_21_20","ACT","21","20","20","Endje dji Polo, yé œ donga Ndjaba. Á pa fœ she adœke: «Ɓœ wu, aya, Ayuda andjoro yindœ Yisu, endje kɔ sœ kœpara awa kœmbœrœtœ endje liaka awa akwa á Ndjaba za fœ Moyize dœ lɔsu endje bale. ");
INSERT INTO mnh_vpl VALUES ("AC21_21","074_21_21","ACT","21","21","21","Kashe endje dji adœke, ɓœ yisœ œrœ fœ Ayuda para á endje sœ lœ oporotœ angbɨ azu adœke, endje katœ awa akwa nœ Moyize yé œ ka ndje tœ kœwa agbolo nœ endje tœ gaza dœ pe kœmbœrœ œrœ mara ogo nœ azœ. ");
INSERT INTO mnh_vpl VALUES ("AC21_22","074_21_22","ACT","21","22","22","A mbœrœ kotoo? Mbœrœ endje dji ndœ zœ adœke ɓœ sœ kpœke zœ. ");
INSERT INTO mnh_vpl VALUES ("AC21_23","074_21_23","ACT","21","23","23","Mbœrœtœ zœ lindœ neke á 'a pa fœ ɓœ asœke. 'A sœ dœ anga azu vana á endje dra ama endje fœ Ndjaba. ");
INSERT INTO mnh_vpl VALUES ("AC21_24","074_21_24","ACT","21","24","24","Ko endje potœ zœ dœ́ 'e na œ mbœrœ adœke ɔkɔ 'e sœ yerœ, gi œrœ tokóró tshangba endje. Endje li ndje kœwa sukumu endje yé azu para œ gbe adœke o'o á kɨ dœ ɨ'ɨrɨ zœ kœdœ wala. Kashe œ li ndje adœke ɓœ mbœrœtœ zœ liaka awa akwa. ");
INSERT INTO mnh_vpl VALUES ("AC21_25","074_21_25","ACT","21","25","25","Yé mbœrœ angbɨ azu á endje te ayindœ Yisu, 'a su mbeti dœ o'o á 'a wa adœke: endje zɨzɨ œrœ á endje to dœ okoro fœ andjaba nene, indji, dœ agea á indji ye tutu ga atɨ nene, yé endje mbœmbœrœ angba budu nene.» ");
INSERT INTO mnh_vpl VALUES ("AC21_26","074_21_26","ACT","21","26","26","Osho kɔrɔ panœ, Polo ko ayakoshe asœmœ yé œ mbœrœ adœke ɔkɔ œne sœ yerœ awa bale dœ endje. Endje na dœ endje ga lœ Tepelo mbœrœ kœpandœ kœka olo nœ kœmbœrœ adœke ɔkɔ œne sœ yerœ, yekane á uzu dœ uzu kœzo agea tokórónœ ga utshu Ndjaba. ");
INSERT INTO mnh_vpl VALUES ("AC21_27","074_21_27","ACT","21","27","27","Œ sœpe lima teasho adœke olo mindu dœ bisha nœ kœmbœrœ adœke ɔkɔ azu sœ yerœ ka, yeka Ayuda lœ ogo Azi wu Polo lœ Tepelo. Endje bɨlɨ azu ndjoro ndœ ye yé á za she. ");
INSERT INTO mnh_vpl VALUES ("AC21_28","074_21_28","ACT","21","28","28","Endje sœ lima kœta rawa adœke: «Azu Israyele, 'e na ga mœ œ tɨ kane 'a ga lafo! Uzunœ á tshe sœ kœyisœ œrœ fatœnœ djezœ, á tshe sœ kœndɨ tshelœ kœlɨsœtœ ogo Israyele, á yiyindœ awa akwa nœ Moyize nene, á tshe ko angbɨ azu ga lœ Tepelo, á ndɨ œyerœ osho dœke.» ");
INSERT INTO mnh_vpl VALUES ("AC21_29","074_21_29","ACT","21","29","29","Mbœrœ endje wu lima Trofime uzu Efeze dœ she ɓa lœ ongbo á gbe adœke Polo li dœ she ga lœ Tepelo. ");
INSERT INTO mnh_vpl VALUES ("AC21_30","074_21_30","ACT","21","30","30","Tshelœ ongbo djigi turu dœ o'onœ, yé azu ndjoro na lima ye. Endje tepa Polo lœ Tepelo œ wuta dœ she ga shu, trale dœ kœtshu mandanœ ga tœnœ. ");
INSERT INTO mnh_vpl VALUES ("AC21_31","074_21_31","ACT","21","31","31","Ɓata á endje sœ lima ndœ kœpara awa kœwo she, o'onœ wuta lima ɓa ndœ gbozu tshapa aturugu nœ Roma lœ Yerusaleme adœke: «Ekpe o'o li ga lœ Yerusaleme ye!» ");
INSERT INTO mnh_vpl VALUES ("AC21_32","074_21_32","ACT","21","32","32","Katsha, tshe ngbɔɓa aturugu dœ agbozu tshapa endje, á endje na ga tœ osho á o'o sœ tœnœ. Lɔkɔ á azu wu aturugu dœ gbozu tshapa endje yeka á katœ kœɓi Polo. ");
INSERT INTO mnh_vpl VALUES ("AC21_33","074_21_33","ACT","21","33","33","Yé gbozu tshapa aturugu na ndoo dœ she, á za 'o fœ endje adœke endje i Polo ga tœnœ dœ djingiri bisha. Manda nœ á tshe yu osho adœke œshe kœdœ ɗe yé œrœ gaɗe dá tshe mbœrœ a. ");
INSERT INTO mnh_vpl VALUES ("AC21_34","074_21_34","ACT","21","34","34","Kashe lœ ukpulu azu, uzu dœ uzu sœ kœta rawa dœ o'o nœ ye kpi, ɓata gbozu nœ aturugu sœ lima kœdji ádá o'onœ dœ ɔtshɔ nœ nene mbœrœ ukpulu azu, á wa adœke endje gu dœ Polo ga lœ pada nœ aturugu. ");
INSERT INTO mnh_vpl VALUES ("AC21_35","074_21_35","ACT","21","35","35","Lɔkɔ á endje wuta ga pa esekaliye, aturugu za Polo ga lafo mbœrœ azu sœ lima kœndanga endje waa. ");
INSERT INTO mnh_vpl VALUES ("AC21_36","074_21_36","ACT","21","36","36","Yé azu kɔ te manda endje dœ rawa adœke: «'E wo she!» ");
INSERT INTO mnh_vpl VALUES ("AC21_37","074_21_37","ACT","21","37","37","Ɔlɔ á endje yindœ kœli dœ she ga lœ padanœ, Polo pa fœ gbozu nœ aturugunœ adœke: «Ɓœ yindœ nœ adœke mœ pa o'o ye a?» Tshe gi fœ she adœke: «Ɓœ wu ndje sœ o'o ama Greke ye! ");
INSERT INTO mnh_vpl VALUES ("AC21_38","074_21_38","ACT","21","38","38","Œ dœ́dœ́ ɓœ kœdœ uzu Ezipito á tshe za djingili lœ olo á ro kpœke ga ugurutœ azu, yé á bɨlɨ azu á kpa ndje dœ azu koshe kutu vana ga lœ kpagagasho nene a?» ");
INSERT INTO mnh_vpl VALUES ("AC21_39","074_21_39","ACT","21","39","39","Polo gi fœ she adœke: «Œ̃œ̃ nene, œmœ kœdœ uzu Yuda, endje zu mœ lœ Tarse lœ ogo Silisi. Œmœ kœdœ gbolo ongbo á ɨ'ɨrɨnœ to waa. Wu oyo mœ, œ za awa fœ mœ, mœ pa o'o fœ azu.» ");
INSERT INTO mnh_vpl VALUES ("AC21_40","074_21_40","ACT","21","40","40","Tshe za awa fœ she, Polo ka ga pa esekaliye, œ tɨ kane ye ga lafo ndœ kœma adœke azu katœ kœta rawa, azu wu œ sœ kokoko. Yé tshe tetœ kœpa 'o fœ endje dœ o'o ama ogo Ayuda á dœ Ebre adœke: ");
INSERT INTO mnh_vpl VALUES ("AC22_1","074_22_1","ACT","22","1","1","«Alaba dœ pe alaya, 'e dji o'o ngbanga nœ mœ á mœ yindœ kœgi ngɔngɔ asœke ga utshu 'e kane.» ");
INSERT INTO mnh_vpl VALUES ("AC22_2","074_22_2","ACT","22","2","2","Kœdji adœke Polo sœ kœpa 'o fœ endje dœ o'o ama Ebre, osho kpa yi taa, yé á tshe pa fœ endje adœke: ");
INSERT INTO mnh_vpl VALUES ("AC22_3","074_22_3","ACT","22","3","3","«Œmœ kœdœ uzu Yuda, endje zu mœ lœ Tarse lœ ogo Silisi, kashe mœ gerœ lœ ongbonœ asœ, mœ mbœrœ lakɔrɔ á sœ kœyisœ o'o á pandœ awa akwa nœ aata azœ tshakudu Gamaliyele, œmœ kœdœ lima uzu á mœ zatœ mœ waa fœ Ndjaba ɓata 'e para kɔkɔ á 'e sœ kœmbœrœ tœnœ kpesheke. ");
INSERT INTO mnh_vpl VALUES ("AC22_4","074_22_4","ACT","22","4","4","Mœ sœ ndje lima kœwo azu á ndje sœ kœza awa Gbozu, mœ ko ayakoshe dœ pe ayashe va ga lœ kánga. ");
INSERT INTO mnh_vpl VALUES ("AC22_5","074_22_5","ACT","22","5","5","Egerœ nganga Ndjaba dœ ukpulu agbozu tshapa azu o'o œ pa ndje ndœmanœ fœ 'e ye. Endje dá vwa lima mœ adœke mœ na œ katœ mbeti á sœ kœza awa fœ mœ kœro ndœ aaya mœ dœ Ayuda á endje sœ ɓa lœ Damaseke. Mœ na lima ga zœ ndœ kœko azunœ asœmœ, kœgu dœ endje ga lœ Yerusaleme mbœrœ á endje kœgbɔ djofele.» ");
INSERT INTO mnh_vpl VALUES ("AC22_6","074_22_6","ACT","22","6","6","«Mœ sœ lima lœ awa ana, yé lɔkɔ á mœ ndo dœ tshalakpɨ Damaseke, ngbangi dœ gbɔku ɔlɔ atake, ɨshirɨ owo to ɓa lafo œ za mœ djigi. ");
INSERT INTO mnh_vpl VALUES ("AC22_7","074_22_7","ACT","22","7","7","Mœ te ga atɨ, yé œ dji tshama uzu kœ'e mœ adœke: “Sawulo, Sawulo, mbœrœ gaɗe á ɓœ mbœrœ œrœ kanga fœ mœ ata a?” ");
INSERT INTO mnh_vpl VALUES ("AC22_8","074_22_8","ACT","22","8","8","Mœ gi adœke: “Œɓœ kœdœ œɗe, Gbozu?” Tshama uzu kpa pa adœke: “Œmœ kœdœ Yisu ɓa lœ Nazarete, œmœ dá ɓœ mbœrœ œrœ kanga fœ mœ asœmœ.” ");
INSERT INTO mnh_vpl VALUES ("AC22_9","074_22_9","ACT","22","9","9","Anga mœ á 'a na lima dœ endje wu ɨshirɨ owonœ ye, kashe endje djidji lima o'onœ á uzunœ sœ kœpa tœnœ fœ mœ nene. ");
INSERT INTO mnh_vpl VALUES ("AC22_10","074_22_10","ACT","22","10","10","Mœ yu adœke: “Œrœ gaɗe dá mœ kœmbœrœ a, Gbozu nœ mœ?” Yeka á Gbozu gi fœ mœ adœke: “Alafo œ na ga lœ Damaseke, yé ɓa zœ, endje yisœ akwa á li adœke ɓœ mbœrœ.” ");
INSERT INTO mnh_vpl VALUES ("AC22_11","074_22_11","ACT","22","11","11","Ɓata ɨshirɨ owonœ bu lima ala mœ ye, anga mœ dá za kane mœ wuta tœnœ ga lœ Damaseke. ");
INSERT INTO mnh_vpl VALUES ("AC22_12","074_22_12","ACT","22","12","12","«Anga uzu lima bale ɓa zœ ɨ'ɨrɨ ye kœdœ Anania, œshe kœdœ uzu nœ ɔtshɔ lɔsu, tshe sœ kœgbɔndœ awa akwa nœ Moyize waa, yé Ayuda para á endje sœ lima kpœtœmœ sœ kœpa ɔtshɔ o'o nœ ye waa. ");
INSERT INTO mnh_vpl VALUES ("AC22_13","074_22_13","ACT","22","13","13","Tshe na œ gbɔ mœ œ pa fœ mœ adœke: “Sawulo, aya mœ, ala zœ kɔrɔ!” Trale ala mœ kɔrɔ yé mœ mesho œ wu she. ");
INSERT INTO mnh_vpl VALUES ("AC22_14","074_22_14","ACT","22","14","14","Yeka á tshe kœpa fœ mœ adœke: “Ndjaba nœ aata azœ ke ɓœ adœke ɓœ wusœ œrœ á tshe yindœ nœ, ɓœ wu uzu á tshe sœ ndjii yé ɓœ dji o'o nœ ye. ");
INSERT INTO mnh_vpl VALUES ("AC22_15","074_22_15","ACT","22","15","15","Mbœrœ ɓœ dœ́ bala timu nœ ye utshu azu para, tœ œrœ á ɓœ wu dœ pe neke á ɓœ dji. ");
INSERT INTO mnh_vpl VALUES ("AC22_16","074_22_16","ACT","22","16","16","Ɓœ sœ kœkate œrœ gaɗe? 'A ro ɓœ gbɔ batisimu dœ ɨ'ɨrɨ Yisu yé œ ta ɨ'ɨrɨ ye dœ́ ekperœ nœ zœ kœyiwa.” ");
INSERT INTO mnh_vpl VALUES ("AC22_17","074_22_17","ACT","22","17","17","«Mœ gu ga lœ Yerusaleme, yé anga ɔlɔ bale mœ sœ kœ'e Ndjaba ɓa lœ Tepelo, mœ wu œrœ lœ ulu. ");
INSERT INTO mnh_vpl VALUES ("AC22_18","074_22_18","ACT","22","18","18","Mœ wu lima Gbozu á tshe sœ kœpa fœ mœ adœke: “Katœ Yerusaleme ngɔngɔ asœ tɨ, mbœrœ azunœ œ yi bala ndœ o'o á ɓœ pa fœ endje dœ ɨ'ɨrɨ mœ nene.” ");
INSERT INTO mnh_vpl VALUES ("AC22_19","074_22_19","ACT","22","19","19","Mœ gi adœke: “Kashe Gbozu, endje wusœ nœ adœke mœ sœ lima kœna kœli ga lœ Sinagoga kœko azu á endje sœ dœ kœyindœrœ ga ndœ zœ, œ ɓi endje yé œ ko endje gu tœnœ ga lœ kánga. ");
INSERT INTO mnh_vpl VALUES ("AC22_20","074_22_20","ACT","22","20","20","Ɔlɔ á endje wo lima Etiene, timu nœ zœ, mœ sœ lima zœ; mœ yindœ nœ ga ndœ endje, yé œ gbɔndœ lœba nœ endje.” ");
INSERT INTO mnh_vpl VALUES ("AC22_21","074_22_21","ACT","22","21","21","Yeka á Gbozu pa fœ mœ adœke: “Na zœ, mœ yindœ kœvwa ɓœ lœ ɨngɨrɨnœ, ɓa ndœ angbɨ azu.”» ");
INSERT INTO mnh_vpl VALUES ("AC22_22","074_22_22","ACT","22","22","22","Ayuda á endje sœ lima kpœtœmœ dji o'o nœ ataa, œ oma dœ Polo yé œ tetœ kœta rawa adœke: «'E wo mara uzu atake ye! Tshe lili kœsœpe dœ soro nene!» ");
INSERT INTO mnh_vpl VALUES ("AC22_23","074_22_23","ACT","22","23","23","Ɓata endje sœ lima kœta rawa, kœko lœba nœ endje va e dœ pe kœgɨ trusha ga lafo, ");
INSERT INTO mnh_vpl VALUES ("AC22_24","074_22_24","ACT","22","24","24","gbozu tshapa aturugu pa adœke endje za Polo li tœnœ ga lœ pada œ sɔ she, yeka á kœwusœ ádá rawanœ á endje ta pa ye asœmœ. ");
INSERT INTO mnh_vpl VALUES ("AC22_25","074_22_25","ACT","22","25","25","Endje sœ kœi she dœ uwu ga tœnœ, Polo yu gbozu nœ aturugu adœke: «Œ li adœke endje ɓi gbolo ogo Roma utshu kœwa ngbanga nœ ye ye a?» ");
INSERT INTO mnh_vpl VALUES ("AC22_26","074_22_26","ACT","22","26","26","Manda kœdji o'onœ ataa, gbozu nœ aturugunœ pandœ nœ fœ gbozu tshapa endje adœke: «Ɓœ mbœrœ kotoo! Mbœrœ uzu asœ kœdœ gbolo ogo Roma!» ");
INSERT INTO mnh_vpl VALUES ("AC22_27","074_22_27","ACT","22","27","27","Gbozu tshapa aturugu kwatœ ye œ yu Polo adœke: «Pandœ nœ fœ mœ ka, adja ɓœ kœdœ gbolo ogo Roma a?» Polo yindœ nœ adœke: «Œ̃.» ");
INSERT INTO mnh_vpl VALUES ("AC22_28","074_22_28","ACT","22","28","28","Gbozu tshapa aturugu kpa pa adœke: «Œmœ, mœ ko egerœ ngendja ndœ kœfa gbolo ogo Roma.» Polo pa adœke: «Œmœ, mœ kœdœ adja gbolo ogo Roma.» ");
INSERT INTO mnh_vpl VALUES ("AC22_29","074_22_29","ACT","22","29","29","Trale, azu á endje sœ lima kœɓi she, gitœ endje ɨndɨrɨ ye yé. Awa za ndje lima gbozu tshapa aturugunœ mbœrœ kœwusœ nœ adœke œnœ i gbolo ogo Roma ga tœnœ dœ uwu. ");
INSERT INTO mnh_vpl VALUES ("AC22_30","074_22_30","ACT","22","30","30","Osho kɔrɔ panœ, gbozu tshapa aturugu yindœ kœwusœ ádá á Ayuda sœ kœza o'o ga pa Polo. Tshe zu djingiri tœ ye, yé manda nœ á e angbɔtœ nœ agbozu tshapa anganga Ndjaba dœ pe aayi kœwa ngbanga para, á jerœ dœ Polo, á za she tɔ ga utshu endje. ");
INSERT INTO mnh_vpl VALUES ("AC23_1","074_23_1","ACT","23","1","1","Polo ko ala ye tɔ lœ la agboro aayi kœwa ngbanganœ, á pa fœ endje adœke: «Alaya, soro mœ sœ yerœ utshu Ndjaba œrrr ga tœ ngɔngɔ asœke yé lɔsu mœ sœ dœ kœsœ gee mbœrœ tœnœ.» ");
INSERT INTO mnh_vpl VALUES ("AC23_2","074_23_2","ACT","23","2","2","Kashe egerœ nganga Ndjaba á ɨ'ɨrɨ ye kœdœ Anania za o'o fœ azu á endje sœ ndoo dœ Polo adœke endje du ama ye. ");
INSERT INTO mnh_vpl VALUES ("AC23_3","074_23_3","ACT","23","3","3","Yé Polo pa fœ she adœke: «Ndjaba œ ɓi ɓœ, ɓœ sœ ɓata imbi muru anda á kavwa! Ɓœ sœ ɓa zœ mbœrœ kœwa ngbanga pa mœ liaka œneke á awa akwa pandœ nœ, yé ɓœ kpa katœ awa akwa tɨ œ pa adœke endje da mœ a?» ");
INSERT INTO mnh_vpl VALUES ("AC23_4","074_23_4","ACT","23","4","4","Azu á endje ka lima ndoo dœ Polo pa fœ she adœke: «Ɓœ gu egerœ nganga Ndjaba a?» ");
INSERT INTO mnh_vpl VALUES ("AC23_5","074_23_5","ACT","23","5","5","Polo gi fœ endje adœke: «Alaya, mœ wuwusœ nœ nene adœke œshe kœdœ egerœ nganga Ndjaba. Gbambanœ nene, Buku nœ Ndjaba pa adœke: “Ɓœ pa ekpe o'o goro œsœ gbozu tshapa azu nœ zœ nene.”» ");
INSERT INTO mnh_vpl VALUES ("AC23_6","074_23_6","ACT","23","6","6","Polo wu lima sœ nœ adœke anga aayi kœwa ngbanganœ kœdœ Asadukayi, yé anga endje kœdœ Afarisayi. Mbœrœ tœnœ, tshe pa o'o ga utshu endje adœke: «Aaya, œmœ kœdœ uzu Farisayi, aata mœ kœdœ Afarisayi. Endje yindœ kœwa ngbanga pa mœ mbœrœ á mœ za lɔsu mœ ga pa neke á pa adœke azu á endje tshu, endje she bala lœ akuzu ye.» ");
INSERT INTO mnh_vpl VALUES ("AC23_7","074_23_7","ACT","23","7","7","Trale manda o'onœ á Polo pa ataa, a'ea wuta ugurutœ Afarisayi dœ pe Asadukayi, yé endje kurutshelœtœ endje. ");
INSERT INTO mnh_vpl VALUES ("AC23_8","074_23_8","ACT","23","8","8","Gbambanœ nene, Asadukayi pa adœke azu á endje tshu endje she lœ akuzu nene yé aandjelu dœ pe ɨshirɨ azu gugu nene. Kashe Afarisayi yi œnœ endje ndœ o'onœ asœmœ kɔ. ");
INSERT INTO mnh_vpl VALUES ("AC23_9","074_23_9","ACT","23","9","9","O'o wuta lima ngbangbangba, yé anga aayi kœyisœ awa akwa á endje dœ Afarisayi áafo, œ vwaratœ endje dœ ɔgbɔ, œ pa adœke: «'A wuwusœ ekperœ bale á yakoshe asœ mbœrœ nene. Anganœ nene ɨshirɨ dá pa o'o fœ she a, too andjelu a?» ");
INSERT INTO mnh_vpl VALUES ("AC23_10","074_23_10","ACT","23","10","10","Ɓata o'onœ sœ lima kœgerœ tœnœ, kœkpa awa adœke endje súru tshelœ Polo nene, gbozu tshapa aturugu za o'o adœke aturugu jerœ œ za Polo ugurutœ endje dœ́ œ gi she ga lœ pada. ");
INSERT INTO mnh_vpl VALUES ("AC23_11","074_23_11","ACT","23","11","11","Dœ abutshɔ manda nœ, Gbozu wuta ga utshu Polo á pa fœ she adœke: «Ka ngbɨrɨ, ɓata á ɓœ pa djakata o'o tœ upu nœ mœ lœ Yerusaleme kpœke, awa bale œ li adœke ɓœ mbœrœ ndje ataa ɓa lœ Roma.» ");
INSERT INTO mnh_vpl VALUES ("AC23_12","074_23_12","ACT","23","12","12","Osho kɔrɔ panœ pe dœ amazɨ, anga Ayuda ngbɔtœ endje ga tœnœ mbœrœ kœvwarandœ o'o. Endje dara ama endje adœke, œne zɨ œrœ nene, œ ndjo ndje œrœ nene œrrr adœke œne wo Polo yekane. ");
INSERT INTO mnh_vpl VALUES ("AC23_13","074_23_13","ACT","23","13","13","Azu á endje dara lima ama endje sœ kœropa zazu bisha. ");
INSERT INTO mnh_vpl VALUES ("AC23_14","074_23_14","ACT","23","14","14","Endje ro ga ndœ agbozu tshapa anganga Ndjaba œdœ pe agbɔ Ayudanœ œ pa adœke: «'A dara ama 'a dœ ɨ'ɨrɨ Ndjaba adœke, 'a kpa zɨ œrœ nene yé 'a ndjo ndje ungu nene œrrr adœke 'a wo Polo yekane. ");
INSERT INTO mnh_vpl VALUES ("AC23_15","074_23_15","ACT","23","15","15","Yé e'e dœ́ agboro aayi kœwa ngbanga kɔ, 'e vwa osho fœ gbozu tshapa aturugu adœke, endje za Polo na tœnœ mbœrœ 'e kpa tondœ o'o nœ ye kpœrœ kpœrœ kane. Kashe kolœ 'a, 'a gbe adœke 'a wo she utshunœ adœke tshe yi kumu ye kpœke.» ");
INSERT INTO mnh_vpl VALUES ("AC23_16","074_23_16","ACT","23","16","16","Kashe gbolo yakoshe nœ yingɔ Polo dji lengere o'onœ asœmœ, œ na ga lœ pada ndœ kœva Polo nea dœ o'onœ. ");
INSERT INTO mnh_vpl VALUES ("AC23_17","074_23_17","ACT","23","17","17","Yé Polo kœ'e anga turugu á tshe kœdœ gbozu tshapa aturugu kama, á kœpa fœ she adœke: «Na dœ gbolo yakoshe asœ fœ gbozu tshapa 'e, tshe sœ dœ o'o kœpandœ nœ fœ she.» ");
INSERT INTO mnh_vpl VALUES ("AC23_18","074_23_18","ACT","23","18","18","Turugunœ asœmœ kœna dœ gbolo yakoshenœ asœmœ fœ gbozu tshapa endje, œ kœpa fœ she adœke: «Ayi kánga Polo dá e mœ á pa adœke, mœ na dœ gbolo yakoshe asœ fœ ɓœ, mbœrœ tshe sœ dœ o'o kœpa fœ ɓœ.» ");
INSERT INTO mnh_vpl VALUES ("AC23_19","074_23_19","ACT","23","19","19","Gbozu tshapa aturugu kœza ama kane ye, kœgitœ ye dœ she ga ɨndɨrɨnœ, kœyu she adœke: «O'o gaɗe dá ɓœ yindœ kœpandœ nœ fœ mœ a?» ");
INSERT INTO mnh_vpl VALUES ("AC23_20","074_23_20","ACT","23","20","20","Gbolo yakoshenœ kœgi fœ she adœke: «Ayuda zɨ tshelœ o'o ndœ kœfara ɓœ adœke, ɓœ za Polo na tœnœ ɓa mbatsha ga utshu agboro aayi kœwa ngbanga. Endje mbœrœ adœke œne gbe kœtondœ o'o nœ ye dœ ɔtshɔnœ kane. ");
INSERT INTO mnh_vpl VALUES ("AC23_21","074_23_21","ACT","23","21","21","Kashe yiyindœ nœ nene. Gbambanœ nene, endje lœ kœropa azu zazu bisha á endje gɨ uku ga tœ awa ye. Endje dara ama endje dœ ɨ'ɨrɨ Ndjaba adœke œne zɨ œrœ nene, œ ndjo ndje ungu nene œrrr adœke œne wo Polo yekane. Adja endje gumatœ endje kɔ yé œ sœ kolœ kœkate adœke ɓœ yindœ nœ awa bale dœ œne.» ");
INSERT INTO mnh_vpl VALUES ("AC23_22","074_23_22","ACT","23","22","22","Utshu kœza awa fœ gbolo yakoshenœ, gbozu tshapa aturugunœ pa fœ she adœke: «Kpa mɨmɨndœ nœ fœ anga uzu bale nene.» ");
INSERT INTO mnh_vpl VALUES ("AC23_23","074_23_23","ACT","23","23","23","Gbozu tshapa aturugu kœ'e anga aturugu nœ ye bisha, kœpa fœ endje adœke: «'E gumatœ 'e mbœrœ kœro ga lœ Sezaré, dœ ada ɔlɔ mindu dœ vana lœ butshɔ asœ, e ko aturugu kama bisha, endjeneke á endje ɔ ga pa ambarata zazu votɔ dœ ndjokpa dœ azu kœnɔ wele kama bisha. ");
INSERT INTO mnh_vpl VALUES ("AC23_24","074_23_24","ACT","23","24","24","'E ko ndje ambarata mbœrœ kœgi dœ Polo dœ soro fœ gbozu Felikisi.» ");
INSERT INTO mnh_vpl VALUES ("AC23_25","074_23_25","ACT","23","25","25","Yé tshe kœsu mbeti adœke: ");
INSERT INTO mnh_vpl VALUES ("AC23_26","074_23_26","ACT","23","26","26","«Abala nœ zœ. Œmœ Klode Lisiyase, mœ sœ kœsu mbetinœ asœke fœ ɓœ dœ gbozu Felikisi, á endje lɨsœ zœ waa asœmœ. ");
INSERT INTO mnh_vpl VALUES ("AC23_27","074_23_27","ACT","23","27","27","Ayuda za uzu asœ yé œ yindœ kœwo she. Lɔkɔ á mœ dji adœke œshe kœdœ gbolo ogo Roma, mœ na dœ aturugu nœ mœ á za she tshakane endje. ");
INSERT INTO mnh_vpl VALUES ("AC23_28","074_23_28","ACT","23","28","28","Ɓata á mœ yi lima ndœ kœwusœ ádá o'o á endje tɔ lima meza pa ye ndœ nœ, mœ na dœ she ga utshu agboro aayi kœwa ngbanga nœ Ayuda. ");
INSERT INTO mnh_vpl VALUES ("AC23_29","074_23_29","ACT","23","29","29","Mœ wu adœke, endje tɔ mezanœ pa ye mbœrœ o'o á wu awa akwa nœ endje dœ tœ endje. Kashe tshe mbœmbœrœ anga ekperœ bale á li adœke endje wo she too endje za she ga lœ kánga nene. ");
INSERT INTO mnh_vpl VALUES ("AC23_30","074_23_30","ACT","23","30","30","Ɓata endje pandœ nœ fœ mœ adœke, Ayuda sœ dœ ekpe gbetshelœ tœ kœwo she, mœ vwa she fœ ɓœ, œ pa fœ endje adœke endje na ndje kœtɔ mezanœ pa ye ɓa utshu zœ.» ");
INSERT INTO mnh_vpl VALUES ("AC23_31","074_23_31","ACT","23","31","31","Aturugu mbœrœtœ endje liaka o'o á gbozu tshapa endje pa. Endje za Polo yé œ gi she na tœnœ butshɔ butshɔ œrrr ga ndœ Atipatrisi. ");
INSERT INTO mnh_vpl VALUES ("AC23_32","074_23_32","ACT","23","32","32","Osho kɔrɔ panœ, aturugu á endje sœ lima kœna dœ ada endje kwatœ endje ga lœ padanœ, yé á katœ endjeneke á endje ɔ ga pa ambarata kœro tœ awanœ dœ Polo. ");
INSERT INTO mnh_vpl VALUES ("AC23_33","074_23_33","ACT","23","33","33","Lɔkɔ á endje wuta ga lœ Sezaré, ayi kœkpa dœ ambarata za mbetinœ fœ gbozu tshapa ogo lœ ongbonœ, yé œ katœ Polo tɨ ga tshakane ye. ");
INSERT INTO mnh_vpl VALUES ("AC23_34","074_23_34","ACT","23","34","34","Gbozu tshapa ogo lœ ongbo Yuda kœdɨ mbetinœ yé á yu Polo tœ kœwusœ ogo nœ ye. Manda kœwusœ nœ adœke œshe kœdœ uzu lœ ogo Silisi, ");
INSERT INTO mnh_vpl VALUES ("AC23_35","074_23_35","ACT","23","35","35","tshe pa fœ she adœke: «Mœ dji ɓœ dœ lɔkɔ á azu kœtɔ meza pa zœ kœyikumu endje.» Tshe kœpa fœ aturugu nœ ye adœke endje gbɔndœ Polo ɓa sœnda nœ gbozu Erode. ");
INSERT INTO mnh_vpl VALUES ("AC24_1","074_24_1","ACT","24","1","1","Manda olo mindu, gbozu nganga Ndjaba Anania wuta ɓa lœ Sezaré awa bale dœ agbɔ Ayuda ndje dœ ayi kɔkɔ bale á ɨ'ɨrɨ ye kœdœ Tertuluse. Endje wuta ga utshu gbozu Felikisi ndœ kœtɔ meza pa Polo. ");
INSERT INTO mnh_vpl VALUES ("AC24_2","074_24_2","ACT","24","2","2","Endje e Polo, yé Tertuluse tetœ kœpa œnœ ye ngbanganœ dœ o'o atake: «Gbozu Felikisi, mœ lɨsœ zœ waa! Œ ga mbœrœ kœwusœtœ nœ zœ dá ɓœ guma ogonœ asœ adœke œ ga waa. Mbœrœ ɓœ dá 'a sœ dœ adja kœsœ gee lœ ogo nœ 'a. ");
INSERT INTO mnh_vpl VALUES ("AC24_3","074_24_3","ACT","24","3","3","'A lɨsœ zœ, gbozu Felikisi, mbœrœ œrœ kɔ 'a gbɔ tœ osho dœ osho. ");
INSERT INTO mnh_vpl VALUES ("AC24_4","074_24_4","ACT","24","4","4","Kashe mœ yiyindœ kœwo ada ɔlɔ nœ zœ nene. Mœ kɨ fœ ɓœ adœke ɓœ sœ dœ ɔtshɔ lɔsu ndœ kœdji mœ teasho kane. ");
INSERT INTO mnh_vpl VALUES ("AC24_5","074_24_5","ACT","24","5","5","'A wu adœke uzu asœ kœdœ ekpe uzu tɔpanœ kpuru, tshe sœ kœli dœ djingili ga ugurutœ Ayuda tœ osho kɔ, yé œshe kœdœ gbozu tshapa Anazareye. ");
INSERT INTO mnh_vpl VALUES ("AC24_6","074_24_6","ACT","24","6","6","Tshe yi ndje lima ndœ kœndɨ Tepelo á dœ œyerœ anda nœ Ndjaba dœ uburu yeka á 'a za she.  'A yi lima ndœ kœwa ngbanga ga tœ ye liaka awa akwa nœ 'a, ");
INSERT INTO mnh_vpl VALUES ("AC24_7","074_24_7","ACT","24","7","7","kashe gbozu tshapa aturugu á tshe dœ́ Lisiyase, kakara she dœ ɔgbɔ tshakane 'a, ");
INSERT INTO mnh_vpl VALUES ("AC24_8","074_24_8","ACT","24","8","8","yeka á vwa 'a adœke 'a na kœtɔ meza pa ye ɓa ndœ zœ. Œdœ ɓœ kœyu she dœ tœ zœ, ɓœ wu adœke o'o á 'a tɔ meza pa ye ndœ nœ kœdœ adja o'o.» ");
INSERT INTO mnh_vpl VALUES ("AC24_9","074_24_9","ACT","24","9","9","Manda o'o nœ ye, Ayuda para kœyindœ nœ adœke: «Adja upu dá tshe pa.» ");
INSERT INTO mnh_vpl VALUES ("AC24_10","074_24_10","ACT","24","10","10","Gbozu tshapa ogo lœ ongbo kœza awa fœ she ndœ kœpa o'o. Polo kœgi adœke: «Mœ wusœ nœ adœke œɓœ dá wa ngbanga ɓa lima lœ ogo nœ 'a manda ungu ndjoro. Mœ sœ dœ yanga ndœ kœpa o'o utshu zœ. ");
INSERT INTO mnh_vpl VALUES ("AC24_11","074_24_11","ACT","24","11","11","Ɓœ kœyu ndje osho dœ tœ zœ, œ mbœrœ kolœ olo ndjokpa dœ bisha ɔlɔ á mœ ro ga lœ Yerusaleme kœdonga Ndjaba. ");
INSERT INTO mnh_vpl VALUES ("AC24_12","074_24_12","ACT","24","12","12","Ɔlɔ bale á endje na á gbɔ mœ ɓa sœnda Tepelo too ɓa lœ Sinagoga too lœ ongbo, á mœ sœ tœ œbœrœ, too kœvwa azu adœke endje shoka ama dœ anga endje gugu nene. ");
INSERT INTO mnh_vpl VALUES ("AC24_13","074_24_13","ACT","24","13","13","Azu asœ tɔ meza pa mœ kolœnœ gbambanœ. ");
INSERT INTO mnh_vpl VALUES ("AC24_14","074_24_14","ACT","24","14","14","Andaa œneke á mœ yindœ nœ kœdœ adœke mœ sœ kœmbœrœ akwa fœ Ndjaba nœ aata 'a lœ awa nœ Gbozu kashe endje pa adœke awanœ dœ́dœ́ ɔtshɔ awa nene. Mœ yi ndje ndœ o'o á endje sú ala mbeti nœ awa akwa œdœ pe œneke á aayi kœgbara o'o pa. ");
INSERT INTO mnh_vpl VALUES ("AC24_15","074_24_15","ACT","24","15","15","Œmœ dœ pe endje, 'a sœ kœza lɔsu 'a ga pa Ndjaba tœ œneke á pa adœke ɔtshɔ azu œdœ ekpe azu œ she bala lœ akuzu. ");
INSERT INTO mnh_vpl VALUES ("AC24_16","074_24_16","ACT","24","16","16","Mbœrœ tœnœ ataa á mœ sœ kœpa avwara adœke mœ mbœrœ ekperœ utshu Ndjaba nœ mœ œdœ pe azu nene. ");
INSERT INTO mnh_vpl VALUES ("AC24_17","074_24_17","ACT","24","17","17","«Mœ mbœrœ ungu ndjoro lœ ana, yé á mœ gu mbœrœ kœto œrœ fœ azu ogo nœ mœ œdœ pe makabo fœ Ndjaba. ");
INSERT INTO mnh_vpl VALUES ("AC24_18","074_24_18","ACT","24","18","18","Yeka á endje na á gbɔ mœ lœ awa kœmbœrœ adœke ɔkɔ mœ sœ yerœ ɓa lœ Tepelo. Kashe azu sœsœ lima ndjoro nene, yé œbœrœ gugu ndje nene. ");
INSERT INTO mnh_vpl VALUES ("AC24_19","074_24_19","ACT","24","19","19","Anga Ayuda lœ Azi, endje dá sœ lima kpœtœmœ, endje dá li má ndœ kœtɔ meza pa mœ œdœ endje kœsœ má dœ o'o dœ mœ. ");
INSERT INTO mnh_vpl VALUES ("AC24_20","074_24_20","ACT","24","20","20","Yé azu á endje sœ asœ, endje pandœ ekperœ á mœ mbœrœ lima ɔlɔ á endje sœ kœyu mœ utshu ayi kœwa ngbanga. ");
INSERT INTO mnh_vpl VALUES ("AC24_21","074_24_21","ACT","24","21","21","Too kolœ manda rawa á mœ ta dœ o'o adœke: “Mbœrœ á mœ yindœ nœ adœke akuzu œ she lœ akuzu dá 'e yindœ kœwa ngbanga ga tœ mœ a?”» ");
INSERT INTO mnh_vpl VALUES ("AC24_22","074_24_22","ACT","24","22","22","Felikisi á tshe wu lima sœ o'o nœ ayindœ Yisu dœ ɔtshɔnœ, kœpa fœ endje adœke: «'E gu zœ, ɔlɔ á Lisiyase gbozu tshapa aturugu œ na, dá mœ kœwa ngbanga nœ 'e.» ");
INSERT INTO mnh_vpl VALUES ("AC24_23","074_24_23","ACT","24","23","23","Tshe kœvwa anga turugu ndœ kœgi Polo ga lœ kánga. Kashe tshe sœsœ kœnga tœ ye nene, tshe za awa fœ azu nœ ye ndœ kœna kœwu she. ");
INSERT INTO mnh_vpl VALUES ("AC24_24","074_24_24","ACT","24","24","24","Manda olo teasho, Felikisi kœna ɓa lœ kánga dœ awonœ á ɨ'ɨrɨ ye kœdœ Drusile, œshe kœdœ uyu Yuda. Tshe e Polo mbœrœ tshe sœ lima dœ ogo ndœ kœdji o'o nœ Yisu. ");
INSERT INTO mnh_vpl VALUES ("AC24_25","074_24_25","ACT","24","25","25","Kashe, ɓata á Polo sœ lima kœmɨndœ o'o nœ ɔtshɔ ɔtshɔ uzu, mara nœ kœgbɔndœ tœ zœ dœ uzu dœ pe mara á Ndjaba œ wa bala ngbanga nœ azu, awa za Felikisi yé tshe pa adœke: «Ɓœ lii kœgu œnœ zœ ngɔngɔ asœ da ye. Mœ e ɓœ bala manda nœ.» ");
INSERT INTO mnh_vpl VALUES ("AC24_26","074_24_26","ACT","24","26","26","Tshe sœ kœgbe adœke Polo œ to ngendja fœ œne, yeka á sœ lima kœ'e she kpœpanœ kpœpanœ ndœ kœpa o'o dœ she. ");
INSERT INTO mnh_vpl VALUES ("AC24_27","074_24_27","ACT","24","27","27","Manda ungu bisha, Porsiyuse Festuse kœza akwa manda Felikisi. Ɓata á Felikisi yindœ nœ adœke Ayuda yindœ œne, á ka lima tœ Polo tɨ lœ kánga. ");
INSERT INTO mnh_vpl VALUES ("AC25_1","074_25_1","ACT","25","1","1","Olo votɔ manda kœwuta Festuse ga lœ ogonœ asœmœ, tshe to ɓa lœ Sezaré œ ro ga lœ Yerusaleme. ");
INSERT INTO mnh_vpl VALUES ("AC25_2","074_25_2","ACT","25","2","2","Agbozu tshapa anganga Ndjaba dœ pe agbozu Yuda na kœtɔ meza pa Polo fœ she. Endje yu lima she kpœpanœ kpœpanœ adœke ");
INSERT INTO mnh_vpl VALUES ("AC25_3","074_25_3","ACT","25","3","3","tshe za awa fœ œne dœ́ œne to she gu tœnœ ga lœ Yerusaleme. Andaa, endje vwara lima ndœ kœwo she tœ ala awa. ");
INSERT INTO mnh_vpl VALUES ("AC25_4","074_25_4","ACT","25","4","4","Kashe Festuse gi adœke tshe sœ lœ kánga ɓa lœ Sezaré, yé œne yindœ kœro dœ tœ œne ga zœ ngɔngɔnœ asœke. ");
INSERT INTO mnh_vpl VALUES ("AC25_5","074_25_5","ACT","25","5","5","Tshe kpa pa ga pa nœ adœke: «Œ li adœke agbozu tshapa 'e ro tœ awanœ bale dœ mœ ɓa lœ Sezaré, yé œ kœsœ adœke uzunœ asœmœ mbœrœ lima ekperœ á endje kœtɔ mezanœ pa ye.» ");
INSERT INTO mnh_vpl VALUES ("AC25_6","074_25_6","ACT","25","6","6","Festuse mbœrœ lima kolœ olo mindu dœ votɔ too ndjokpa gbambanœ ɓa ndœ endje kpœtœmœ, yeka á gu ga lœ Sezaré. Osho kɔrɔpa nœ, tshe sœ ga atɨ ɓa tœ osho kœwa ngbanga yé á za awa adœke endje na œ to Polo na tœnœ. ");
INSERT INTO mnh_vpl VALUES ("AC25_7","074_25_7","ACT","25","7","7","Lɔkɔ á Polo yi kumu ye, Ayuda á endje to lima ɓa lœ Yerusaleme ndɨvwɨrɨ she yé œ te lima tœ kœpa ogboro o'o ga pa ye, ogboro o'o neke á endje kœyu endje tœ ádá o'onœ, endje li kœpandœ nœ nene. ");
INSERT INTO mnh_vpl VALUES ("AC25_8","074_25_8","ACT","25","8","8","Kashe Polo pa lima ngbanga nœ ye adœke: «Œdœ ga tœ awa akwa nœ Ayuda, œdœ ga tœ Tepelo too fœ egerœ gbozugo, mœ mbœmbœrœ ekperœ bale nene.» ");
INSERT INTO mnh_vpl VALUES ("AC25_9","074_25_9","ACT","25","9","9","Festuse yindœ kœza yanga fœ Ayuda yé œ yu Polo adœke: «Ɓœ yindœ kœro ga lœ Yerusaleme adœke endje wa ngbanga nœ zœ ɓa utshu mœ a?» ");
INSERT INTO mnh_vpl VALUES ("AC25_10","074_25_10","ACT","25","10","10","Polo gi adœke: «Mœ ka ga utshu osho kœwa ngbanga nœ egerœ gbozugo, yé kpœke dá endje wa ngbanga nœ mœ. Mœ mbœmbœrœ ekperœ bale fœ Ayuda nene ɓata á ɓœ wusœ nœ dœ ɔtshɔ nœ dœ tœ zœ asœmœ. ");
INSERT INTO mnh_vpl VALUES ("AC25_11","074_25_11","ACT","25","11","11","Œdœ adja mœ kœmbœrœ má ekperœ, yé á mbœrœ ekperœ neke á li dœ kuzu, mœ vwaratœ mœ ndœ kœtshu tœnœ nene. Kashe œdœ o'o á endje tɔ meza pa mœ ndœ nœ kœdœ́dœ́ okporo o'o nene, uzu bale á tshe za mœ ga tshakane endje gugu nene. Mœ yindœ nœ adœke mœ wuta ga utshu egerœ gbozugo.» ");
INSERT INTO mnh_vpl VALUES ("AC25_12","074_25_12","ACT","25","12","12","Festuse kœte ga ndœ aayi kœmɨ upu nœ ye, œ kœgi fœ Polo adœke: «Ɓata á ɓœ yindœ kœwu egerœ gbozugo ndœ kœwa ngbanga nœ zœ, ɓœ ro ga utshu ye tako.» ");
INSERT INTO mnh_vpl VALUES ("AC25_13","074_25_13","ACT","25","13","13","Olo teasho manda nœ, gbozu Agripa dœ pe yingɔ nœ á ɨ'ɨrɨ ye kœdœ Berenise, ro ga lœ Sezaré yé œ na kœwu Festuse. ");
INSERT INTO mnh_vpl VALUES ("AC25_14","074_25_14","ACT","25","14","14","Ɓata œndœ ndje dɨ lima ndje kpœtœmœ, Festuse pandœ o'o nœ Polo fœ Agripa adœke: «Anga yakoshe bale á Felikisi ka lima tœ ye tɨ lœ kánga sœ kpœke. ");
INSERT INTO mnh_vpl VALUES ("AC25_15","074_25_15","ACT","25","15","15","Lɔkɔ á mœ na lima ga lœ Yerusaleme, agbozu tshapa anganga Ndjaba dœ pe agbɔ Ayuda na kœtɔ meza pa ye, yé endje pa fœ mœ adœke mœ wa ɔgbɔ ngbanga ga tœ ye. ");
INSERT INTO mnh_vpl VALUES ("AC25_16","074_25_16","ACT","25","16","16","Yeka á mœ gi fœ endje adœke, awa akwa nœ azu Roma pa adœke: œdœ endje kœtɔ meza pa uzu, œ li adœke endje dji she tshe pa o'o ɔkɔ ye ɓa utshu aayi kœtɔ mezanœ yekane á endje kœwa ngbanga ga tœ ye. ");
INSERT INTO mnh_vpl VALUES ("AC25_17","074_25_17","ACT","25","17","17","Endje kœaafo, á 'a kœgu tœ awanœ dœ endje ga mœ. Mœ kpakpalatœ mœ lɔkɔ á osho kɔrɔ nene, yé mœ na œ sœ ga atɨ ɓa tœ osho kœwa ngbanga yeka á vwa osho adœke endje gu dœ uzunœ ga mœ. ");
INSERT INTO mnh_vpl VALUES ("AC25_18","074_25_18","ACT","25","18","18","Azunœ á endje tɔ meza pa ye áafo kashe endje papa anga ngbɨndɨ o'o tœ upu nœ ye liaka œneke á mœ gbe má kœdji tœnœ nene. ");
INSERT INTO mnh_vpl VALUES ("AC25_19","074_25_19","ACT","25","19","19","Endje sœ lima kœshara upu dœ she pa mara kœdonga Ndjaba nœ endje dœ tœ endje, ndje tœ upu nœ anga uzu á ɨ'ɨrɨ ye kœdœ Yisu á tshe tshu ye, yeka á Polo kpa pa adœke, tshe sœ dœ soro zœ. ");
INSERT INTO mnh_vpl VALUES ("AC25_20","074_25_20","ACT","25","20","20","Mœ wuwu lima sœ œrœ á mœ mbœrœ tœ kœwa mara ngbanga atamœ nene. Mbœrœ tœnœ dá mœ yu Polo adœke tshe yindœ nœ dœ́ endje na ga lœ Yerusaleme adœke endje wa ngbanga pa ye tœ o'onœ asœmœ. ");
INSERT INTO mnh_vpl VALUES ("AC25_21","074_25_21","ACT","25","21","21","Kashe Polo yindœ nœ lima adœke œne wuta ɓa utshu egerœ gbozugo yeka á tshe kœwa ngbanga pa o'o nœ œne. Yé á kœpa adœke endje gbɔndœ ye lœ kánga œrrr ga tœ olo á mœ vwa she fœ egerœ gbozunœ.» ");
INSERT INTO mnh_vpl VALUES ("AC25_22","074_25_22","ACT","25","22","22","Agripa kœpa fœ Festuse adœke: «Mœ yi ndje ndœ kœdji ndje yakoshenœ asœmœ.» Festuse kœgi fœ Agripa adœke: «Ɓa mbatsha ɓœ dji she zœ.» ");
INSERT INTO mnh_vpl VALUES ("AC25_23","074_25_23","ACT","25","23","23","Osho kœkɔrɔ pa nœ, Agripa dœ Berenise na, dœ azu ndjoro, yé œ li dœ kœlɨsœtœ ga sœnda awa bale dœ agbozu tshapa aturugu dœ pe agbozu tshapa ongbo. Festuse vwa osho yé endje na œ za Polo gu tœnœ. ");
INSERT INTO mnh_vpl VALUES ("AC25_24","074_25_24","ACT","25","24","24","Festuse kœpa adœke: «Gbozu Agripa œdœ pe 'e kɔ á 'e sœ dœ 'a atɨ asœke, 'e wu yakoshenœ asœ. Ayuda ndjoro na kœtɔ meza pa ye ɓa ndœ mœ, ɓa lœ Yerusaleme, dœ pe ndje ɓa lakpɨnœ asœke. Endje pa dœ ɔgbɔ adœke, tshe lili kœsœpe dœ soro nene. ");
INSERT INTO mnh_vpl VALUES ("AC25_25","074_25_25","ACT","25","25","25","Ɓa ndœ mœ, mœ wusœ nœ adœke tshe mbœmbœrœ anga ekperœ bale á li adœke tshe tshu lœ kumunœ nene. Kashe ɓata á Polo dœ tœ ye yindœ nœ adœke, egerœ gbozu kœwa ngbanga pa œne, mœ wa o'o tœ kœvwa she fœ egerœ gbozunœ. ");
INSERT INTO mnh_vpl VALUES ("AC25_26","074_25_26","ACT","25","26","26","Ɓata á mœ wuwusœ o'o neke á mœ kœsu pa ye fœ egerœ gbozu nene, dá mœ sœ kœyu she utshu 'e, utshu œɓœ dœ gbozu Agripa, adœke ɓœ yu she yeka á mœ kœgbɔ o'o kœsu fœ she tœ upu nœ ye. ");
INSERT INTO mnh_vpl VALUES ("AC25_27","074_25_27","ACT","25","27","27","Mœ wu adœke œ sœsœ dœ ɔtshɔnœ nene kœvwa ayi kánga fœ egerœ gbozu œdœ ádá o'o á endje tɔ meza pa ye kœsœsœ ngbɨ nene.» ");
INSERT INTO mnh_vpl VALUES ("AC26_1","074_26_1","ACT","26","1","1","Agripa kœpa fœ Polo adœke: «Mœ za awa fœ ɓœ ndœ kœpa ngbanga nœ zœ.» Polo kœtɨ kane ye ga lafo ndœ kœpa o'o yé œ pa adœke: ");
INSERT INTO mnh_vpl VALUES ("AC26_2","074_26_2","ACT","26","2","2","«Gbozu Agripa, mœ sœ dœ yanga kpesheke ndœ kœpa ngbanga ɓa utshu zœ tœ o'o kɔ á Ayuda tɔ meza pa mœ tœnœ, ");
INSERT INTO mnh_vpl VALUES ("AC26_3","074_26_3","ACT","26","3","3","gbambanœ nene, ɓœ wusœ mara kœmbœrœtœ nœ Ayuda dœ pe kœshara upu pa mara kœdonga Ndjaba nœ endje dœ ɔtshɔnœ. Mœ kɨ fœ ɓœ adœke lɔsu zœ zɨ tɨɨ á ɓœ kœdji mœ. ");
INSERT INTO mnh_vpl VALUES ("AC26_4","074_26_4","ACT","26","4","4","«Ayuda para wusœ soro mœ pe dœ gbolo mœ ye, mbœrœ mœ gerœ lœ Yerusaleme ugurutœ azu ogo nœ mœ. ");
INSERT INTO mnh_vpl VALUES ("AC26_5","074_26_5","ACT","26","5","5","Endje wusœ mœ katshatsha. Œdœ endje kœyindœ nœ, endje pa adœke œmœ kœdœ anga Afarisayinœ á endje ro anga Ayuda dœ kœdonga Ndjaba dœ pe kœlɨsœ awa akwa nœ azœ waa. ");
INSERT INTO mnh_vpl VALUES ("AC26_6","074_26_6","ACT","26","6","6","Yé ngɔngɔ asœke, mœ sœ kœpa ngbanga mbœrœ á mœ za lɔsu mœ ga pa anga o'o á Ndjaba pa lima fœ aata azœ. ");
INSERT INTO mnh_vpl VALUES ("AC26_7","074_26_7","ACT","26","7","7","Mara azu ndjokpa dœ bisha (12) lœ Israyele sœ kœdonga Ndjaba butshɔ dœ ɔlɔ dœ lɔsu adœke œne wu œrœnœ asœmœ. Uu gbozu Agripa! Mangba o'onœ á mœ za lɔsu mœ ga tœ nœ asœmœ dá Ayuda tɔ meza pa mœ. ");
INSERT INTO mnh_vpl VALUES ("AC26_8","074_26_8","ACT","26","8","8","Ayuda, mbœrœ gaɗe á 'e gbe adœke Ndjaba œ she azu á endje tshu lœ kuzu nene a? ");
INSERT INTO mnh_vpl VALUES ("AC26_9","074_26_9","ACT","26","9","9","«Œmœ ndje lima, mœ sœ kœpakata azu adœke endje yiyindœ Yisu uzu Nazarete nene. ");
INSERT INTO mnh_vpl VALUES ("AC26_10","074_26_10","ACT","26","10","10","Œtœnœ dá mœ mbœrœ lima lœ Yerusaleme. Agbozu tshapa anganga Ndjaba za awa fœ mœ yé mœ ko ayindœ Yisu ndjoro gu tœnœ ga lœ kánga. Yé œ kœsœ lima adœke endje wo endje ye, mœ sœ lima kœyindœ nœ. ");
INSERT INTO mnh_vpl VALUES ("AC26_11","074_26_11","ACT","26","11","11","Mœ mbœrœ lima kɔ adœke endje wu œrœ kanga lœ Sinagoga, adœke endje katœ kœyindœrœ nœ endje ga ndœ Yisu tɨ ye. Tshelœ mœ fa lima ga tœ endje dœ mara adœke, mœ sœ lima kœza awa endje œrrr dje lœ ongbo á sœ lœ ɨngɨrɨnœ.» ");
INSERT INTO mnh_vpl VALUES ("AC26_12","074_26_12","ACT","26","12","12","«Mbœrœ tœnœ ataa, mœ sœ lima kœna ɔlɔ bale ga lœ Damaseke dœ mbeti á agbozu tshapa anganga Ndjaba su fœ mœ adœke œ za awa nœ kœmbœrœ œrœ fœ mœ. ");
INSERT INTO mnh_vpl VALUES ("AC26_13","074_26_13","ACT","26","13","13","Uu gbozu! Tɨ damba tœ ala awa, ndoo dœ midi, mœ wu ɨshirɨ owo á ropa ɔlɔ kœto ɓa lafo kœjerœ ga pa mœ, dœ pe anga mœ á 'a sœ lima kœro tœ awanœ dœ endje. ");
INSERT INTO mnh_vpl VALUES ("AC26_14","074_26_14","ACT","26","14","14","'A kœyo kɔ ga lœ ɔshɔ, mœ kœdji tshama uzu kœ e mœ dœ o'o ama Ebre adœke: “Sawulo, Sawulo, mbœrœ gaɗe á ɓœ sœ kœmbœrœ œrœ kanga fœ mœ a? Ɓœ sœ kœwu oyo tœ zœ ɓata yaburu á ayengɔ ye du uwu ga lœ ɨgɨ ye á sœ kœgbota she á tshe sœ kœvwaratœ ye tœ kœna manda ye.” ");
INSERT INTO mnh_vpl VALUES ("AC26_15","074_26_15","ACT","26","15","15","«Mœ kœyu adœke: “Œɓœ kœdœ ɗe, Gbozu?” Gbozu kœpa adœke: “Œmœ kœdœ Yisu, œmœ dá ɓœ mbœrœ œrœ kanga fœ mœ asœmœ. ");
INSERT INTO mnh_vpl VALUES ("AC26_16","074_26_16","ACT","26","16","16","Kashe alafo, œ ka dœ ada zœ! Wu, mœ wuta ga ndœ zœ mbœrœ kœfa ɓœ tœ ayi akwa nœ mœ. Ɓœ dœ́ timu nœ mœ adœke ɓœ pandœ nœ fœ azu mara á ɓœ wu dœ mœ kpesheke dœ pe œneke á mœ kpa yisœ nœ fœ ɓœ manda nœ. ");
INSERT INTO mnh_vpl VALUES ("AC26_17","074_26_17","ACT","26","17","17","Œdœ ɓa ndœ Ayuda, œdœ ɓa ndœ angbɨ azu, mœ gbɔndœ zœ tœ osho kɔ á mœ vwa ɓœ tœnœ, ");
INSERT INTO mnh_vpl VALUES ("AC26_18","074_26_18","ACT","26","18","18","mbœrœ kœkɔrɔ ala endje, ndœ kœgi endje lœ ubu osho ga tœ ɨngbɨsho, mbœrœ endje vwaratœ endje tœ Satana yé œ na ga ndœ Ndjaba. Œdœ endje kœsœ dœ kœyindœrœ ga ndœ mœ, mœ djerœndœ ekperœ nœ endje yé œ za osho kœsœ ugurutœ ayerœ azu nœ Ndjaba fœ endje.”» ");
INSERT INTO mnh_vpl VALUES ("AC26_19","074_26_19","ACT","26","19","19","«Kœto tœ olonœ asœmœ, gbozu Agripa, mœ mbœrœ œneke kɔ á to ɓa ndœ Ndjaba á tshe yisœ nœ fœ mœ. ");
INSERT INTO mnh_vpl VALUES ("AC26_20","074_26_20","ACT","26","20","20","Utshunœ, mœ tetœ kœmɨndœ nœ fœ azu tshalakpɨ Damaseke dœ Yerusaleme. Manda nœ, mœ mɨndœ nœ fœ azu tshelœ ogo Yuda kɔ ndje dœ angbɨ azu. Mœ sœ kœpa fœ endje adœke endje fatshalɔsu endje, œ na ga ndœ Ndjaba yé œ mbœrœ akwa á sœ kœma adœke endje fa adja tshalɔsu endje ye. ");
INSERT INTO mnh_vpl VALUES ("AC26_21","074_26_21","ACT","26","21","21","Ádánœ á Ayuda tepa mœ ɓa lœ Tepelo, á yindœ kœwo mœ dœ mœ. ");
INSERT INTO mnh_vpl VALUES ("AC26_22","074_26_22","ACT","26","22","22","Kashe Ndjaba sœ kœgbɔndœ mœ œrrr ga tœ kpesheke, yé mœ sœpe damba dœ soro mbœrœ kœpa œneke asœke fœ azu para kɔkɔ, fœ agbolo ndje fœ agbozu. Œneke á mœ sœ kœpandœ nœ asœke kœdœ kolœ œneke á aayi kœgbara o'o œdœ mbeti nœ Moyize pa lima ndœ nœ adœke œ wuta. ");
INSERT INTO mnh_vpl VALUES ("AC26_23","074_26_23","ACT","26","23","23","Endje mɨ lima ndœ nœ adœke, Masiya œ wu oyo, yé œ tshu yeka á she lœ akuzu utshu azu kɔ. Tshe mɨndœ o'o nœ Ndjaba á sœ ɓata ɔlɔ á za kœshe fœ Ayuda dœ pe angbɨ azu.» ");
INSERT INTO mnh_vpl VALUES ("AC26_24","074_26_24","ACT","26","24","24","Polo sœpe damba kœpa ngbanga, á Festuse pa o'o dœ ɔgbɔ adœke: «Iyi te lœ kumu zœ a! Œrœnœ á ɓœ wusœ nœ waa dá mbœrœtœ zœ asœke a!» ");
INSERT INTO mnh_vpl VALUES ("AC26_25","074_26_25","ACT","26","25","25","Kashe Polo kœgi adœke: «Mœ sœsœ dœ iyi nene, gbozu Festuse, o'onœ á mœ sœ kœpa tœnœ kœdœ adja o'o, yé ádánœ sœ zœ. ");
INSERT INTO mnh_vpl VALUES ("AC26_26","074_26_26","ACT","26","26","26","Gbozu Agripa dji o'onœ asœke, yé mœ li kœpa o'o ɓa utshu ye dœ awa nene. Tshe wusœ o'onœ asœ bale bale kɔ, gbambanœ nene, œ mbœmbœrœtœ endje wutœnœ nene. ");
INSERT INTO mnh_vpl VALUES ("AC26_27","074_26_27","ACT","26","27","27","Gbozu Agripa, ɓœ yindœ o'o á aayi kœgbara o'o pa lima ye a? Mœ wusœ nœ adœke ɓœ yindœ nœ.» ");
INSERT INTO mnh_vpl VALUES ("AC26_28","074_26_28","ACT","26","28","28","Agripa kœpa fœ Polo adœke: «Œ sœpe teasho adœke ɓœ fa gbetshelœ nœ mœ adœke mœ wuta uzu nœ Kristu!» ");
INSERT INTO mnh_vpl VALUES ("AC26_29","074_26_29","ACT","26","29","29","Polo gi adœke: «Olo sœ ndoo, olo sœ lœ ɨngɨrɨnœ, mœ sœ kœ'e Ndjaba mbœrœ œɓœ dœ pe azu para á endje sœ kœdji mœ kpesheke asœ adœke 'e wuta ɓata mœ, kashe endje ii 'e dœ uwu ga tœnœ ɓata mœ nene!» ");
INSERT INTO mnh_vpl VALUES ("AC26_30","074_26_30","ACT","26","30","30","Gbozu Agripa kœaafo awa bale dœ gbozu ongbo Festuse dœ Berenise, dœ pe azu para á endje sœ lima kpœtœmœ, ");
INSERT INTO mnh_vpl VALUES ("AC26_31","074_26_31","ACT","26","31","31","yé kœgitœ endje ga ɨndɨrɨnœ, kœpa lœ ugurutœ endje adœke: «Uzunœ asœ mbœmbœrœ ekperœ á li adœke a wo she too a za she ga lœ kánga nene.» ");
INSERT INTO mnh_vpl VALUES ("AC26_32","074_26_32","ACT","26","32","32","Agripa kœpa fœ Festuse adœke: «Œdœ uzu asœ kœyɔyɔ lima ndœ nœ adœke gbozu Roma kœwa o'o nœ œne nene, dá a za má she ga shu ye.» ");
INSERT INTO mnh_vpl VALUES ("AC27_1","074_27_1","ACT","27","1","1","Ɔlɔ á endje gbe adœke 'a ro ga lœ Itali dœ egerœ agba, endje za Polo dœ pe anga aayi kánga fœ anga gbozu nœ aturugu bale á ɨ'ɨrɨ ye kœdœ Juliyuse, tshe kœdœ gbozu uguru ukpulu aturugu lœ ogo Roma á endje e endje adœke «ukpulu aturugu nœ egerœ gbozu.» ");
INSERT INTO mnh_vpl VALUES ("AC27_2","074_27_2","ACT","27","2","2","'A ɔ ga lœ egerœ agba á to ɓa lœ Adramite á yindœ kœro kœka ga tœ mangu lœ ogo Azi. 'A ro lima tœ awanœ dœ Aristarke uzu Tesalonike lœ ogo Masedwane. ");
INSERT INTO mnh_vpl VALUES ("AC27_3","074_27_3","ACT","27","3","3","Osho kɔrɔ pa nœ, 'a ka lima ɓa tœ Sidona, Juliyuse sœ kœmbœrœ ɔtshɔrœ ga tœ Polo, á za awa fœ she kœna ndœ kœwu anganœ á endje kœto œrœ á tshe sœ dœ ogonœ fœ she. ");
INSERT INTO mnh_vpl VALUES ("AC27_4","074_27_4","ACT","27","4","4","Manda kœkatœ Sidona tɨ, 'a áafo, œ ro ndoo dœ tshiki lœ Shipre mbœrœ yugu sœ lima kœgi 'a ga ngbanœ. ");
INSERT INTO mnh_vpl VALUES ("AC27_5","074_27_5","ACT","27","5","5","'A zu ungu kota ga tœ ama ungu ndoo dœ Silisi œdœ Pafili, yeka á 'a wuta ga lœ Mire lœ ogo Lisi. ");
INSERT INTO mnh_vpl VALUES ("AC27_6","074_27_6","ACT","27","6","6","Ɓa zœ, gbozu nœ aturugu wu anga egerœ agba á to ɓa lœ Alekezandri, á sœ kœro ga lœ Itali, á ko 'a ga lœ nœ. ");
INSERT INTO mnh_vpl VALUES ("AC27_7","074_27_7","ACT","27","7","7","'A mbœrœ lima olo ndjoro la ngu mbœrœ egerœ agba sœ lima kœkpa yima yima, yé 'a wu lima oyo á wuta lima ga lœ Kinide. Ɓata 'a lili kœna ndjii ga zœ nene mbœrœ yugunœ á sœ kœndanga 'a, 'a fa dja ga lœ Salemone tœ osho á tshiki Krete ko 'a yiwa tœnœ tœ yugunœ. ");
INSERT INTO mnh_vpl VALUES ("AC27_8","074_27_8","ACT","27","8","8","Yé manda nœ, 'a mbœrœ oyo tœ 'a, á wuta ga tœ osho á ɨ'ɨrɨnœ kœdœ Ɔtshɔ Mangu ndoo dœ ongbo Lase. ");
INSERT INTO mnh_vpl VALUES ("AC27_9","074_27_9","ACT","27","9","9","Kashe œndœ 'a dɨ lima lœ ananœ waa, yé loko dopa nœ, awa adœke egerœ agba na ana gugu nene. Olo á Ayuda œ yo tshelœ ama endje ro lima ye, á Polo kœpa fœ endje adœke: ");
INSERT INTO mnh_vpl VALUES ("AC27_10","074_27_10","ACT","27","10","10","«Anga mœ, mœ wu adœke ana asœ ngaanga dœ azœ. Anganœ ete, egerœ agba dœ pe œrœ kɔ á sœ lœ nœ œ ndɨ, azœ ndje 'a tshu.» ");
INSERT INTO mnh_vpl VALUES ("AC27_11","074_27_11","ACT","27","11","11","Kashe gbozu nœ aturugu vwaratœ ye kœdji Polo, yé á dji kolœ ayi kœkpa dœ egerœ agba dœ pe ayingɔ egerœ agbanœ. ");
INSERT INTO mnh_vpl VALUES ("AC27_12","074_27_12","ACT","27","12","12","Ɓata mangunœ gaga lima adœke endje sœ tœnœ dœ lɔkɔ nœ ɨzɨ nene, ɨlɨ azu yindœ nœ adœke œne ro. Endje yindœ kœro ga lœ Fenikise, anga mangu ogo Krete, á sœ ga tœ osho á ɔlɔ œ li tœnœ. ");
INSERT INTO mnh_vpl VALUES ("AC27_13","074_27_13","ACT","27","13","13","Aya yugu to ɓa aki á sœ kœna tœnœ, yé endje gbe adœke œne li kœmbœrœ œneke á œne yindœ nœ. Endje gbota longonœ yé œ afo kœro tœnœ kperœ tœ ama mangu tshiki Krete. ");
INSERT INTO mnh_vpl VALUES ("AC27_14","074_27_14","ACT","27","14","14","Kashe œndœnœ dɨ teasho, ndavuru yugu á to ga pa gele ndo dœ osho á ɔlɔ œ wuta tœnœ, ɓa pa kaga tshiki á jerœ ga pa endje. ");
INSERT INTO mnh_vpl VALUES ("AC27_15","074_27_15","ACT","27","15","15","Yugunœ gi agba dœ ɔgbɔ ga manda nœ, awa adœke 'a mbœrœ anga œrœ gugu nene yé 'a katœ nœ tɨ adœke œ gi 'a. ");
INSERT INTO mnh_vpl VALUES ("AC27_16","074_27_16","ACT","27","16","16","Á ro tɔ ɨndɨrɨ aya tshiki bale á ɨ'ɨrɨnœ kœdœ Koda á sœ lima kœwandœ ata gbɔgbɔ yugunœ pa 'a, yé uvuru 'a kpa lima lœ nœ tœ kœza aya agba kœshe dœ azu. ");
INSERT INTO mnh_vpl VALUES ("AC27_17","074_27_17","ACT","27","17","17","Manda kœtɨ tœnœ ga lafo, endje ko ogboro uwu á du ga tœ egerœ agbanœ mbœrœ loko kœkakavwa nene. Ɓata awa kœshi pa mindu dja ga tœ Libi sœ lima kœza endje, endje geta egerœ maɓaya á endje du ga tœ egerœ agbanœ vwi ga la ngu, á tetœ kœna la ngu yima yima. ");
INSERT INTO mnh_vpl VALUES ("AC27_18","074_27_18","ACT","27","18","18","Osho kɔrɔ pa nœ, ɓata yugunœ sœpe lima kœvwi 'a dœ agbɔnœ, 'a tetœ kœko ata gbarœ va ga la ngu. ");
INSERT INTO mnh_vpl VALUES ("AC27_19","074_27_19","ACT","27","19","19","Yé olo bisha manda nœ, aayi kœmbœrœ akwa lœ egerœ agbanœ dœ tœ endje, te ndje tœ kœko œrœ kote egerœ agbanœ va e. ");
INSERT INTO mnh_vpl VALUES ("AC27_20","074_27_20","ACT","27","20","20","'A kpa sœ lima kœwu ɔlɔ too angerepe nene, manda olo ndjoro, yugu sœ kœna kolœ dœ agbɔ, yé gbetshelœ nœ soro kpa gugu lima lœ kumu 'a nene. ");
INSERT INTO mnh_vpl VALUES ("AC27_21","074_27_21","ACT","27","21","21","Azu á endje lœ lima lœnœ zɨzɨ œrœ nene manda olo ndjoro, yé Polo afo ugurutœ endje á pa adœke: «'E wu, anga mœ, œdœ 'e kœdji lima o'o mœ, á 'a sœpe lœ Krete, gbarœ œdœ œrœ kote egerœ agba œ ndɨ má nene. ");
INSERT INTO mnh_vpl VALUES ("AC27_22","074_27_22","ACT","27","22","22","Kashe ngɔngɔ asœ, mœ sœ kœpa fœ 'e adœke 'e ru lɔsu 'e, uzu bale ugurutœ 'e œ tshu nene, kolœ egerœ agba dá ndɨ. ");
INSERT INTO mnh_vpl VALUES ("AC27_23","074_27_23","ACT","27","23","23","Ndjaba nœ mœ á mœ mbœrœ akwa fœ she vwa anga andjelu fœ mœ dœ abutshɔnœ asœ. ");
INSERT INTO mnh_vpl VALUES ("AC27_24","074_27_24","ACT","27","24","24","Tshe pa fœ mœ adœke: “Polo, awa zaza ɓœ nene, œ li adœke ɓœ pa ngbanga utshu egerœ gbozu yeka. Ndjaba œ she azu para lœ egerœ agbanœ asœ mbœrœ ɔtshɔ lɔsu nœ ye ga ndœ zœ.” ");
INSERT INTO mnh_vpl VALUES ("AC27_25","074_27_25","ACT","27","25","25","'E ru lɔsu 'e alaya, gbambanœ nene, mœ za lɔsu mœ ga tœ Ndjaba yé œrœ œ mbœrœtœ ye liaka œneke á andjelu pandœ nœ fœ mœ asœmœ. ");
INSERT INTO mnh_vpl VALUES ("AC27_26","074_27_26","ACT","27","26","26","Kashe egerœ agbanœ œ zatœ ye tɔ ama ɔshɔ tœ ama anga tshiki bale.» ");
INSERT INTO mnh_vpl VALUES ("AC27_27","074_27_27","ACT","27","27","27","Manda pɔsɔ bisha, egerœ yugunœ vwi 'a lima na tœnœ œrrr ga la egerœ ungu á ɨ'ɨrɨnœ kœdœ Adriyatike. Kœndo dœ ɔgbɔ butshɔ, azu akwa tshelœ egerœ agba gbe adœke 'a ndo dœ ama ɔshɔ ye. ");
INSERT INTO mnh_vpl VALUES ("AC27_28","074_27_28","ACT","27","28","28","Endje du uwu ga tœ badja, á vwi ga la ngu ndœ kœwusœ dili ungunœ. Endje wu adœke ungunœ li metere zazu bale dœ ndjokpa dœ amanœ mindu dœ bisha. Yé endje gitœ endje ga utshunœ, œ kpa vwi uwunœ, á wu adœke œ sœ dœ metere zazu bisha dœ amanœ mindu dœ votɔ. ");
INSERT INTO mnh_vpl VALUES ("AC27_29","074_27_29","ACT","27","29","29","Endje sœ lima dœ awa adœke egerœ agbanœ zazatœ ye tɔ badja nene. Mbœrœ tœnœ ataa, endje du longo vana ga tœ budunœ, á ko va ga la ngu, yé á sœ lima kœkate dœ lɔsu endje ga lafo adœke osho kɔrɔ. ");
INSERT INTO mnh_vpl VALUES ("AC27_30","074_27_30","ACT","27","30","30","Ɓata aayi akwa yi lima ndœ kœkpa tœnœ, endje gi lima aya agba kœshe dœ azu ga la ngu yé œ fara adœke œne jerœ ga lœ nœ á kœdu longonœ ga utshu egerœ agbanœ. ");
INSERT INTO mnh_vpl VALUES ("AC27_31","074_27_31","ACT","27","31","31","Polo kœpa fœ gbozu nœ aturugu dœ pe aturugu adœke: «Œdœ azu asœ kœsœsœpe lœ egerœ agbanœ asœ nene, e'e, 'e sœpe dœ soro nene.» ");
INSERT INTO mnh_vpl VALUES ("AC27_32","074_27_32","ACT","27","32","32","Yeka á aturugu na, á wa tshelœ uwu tœ aya agbanœ, yé á ka tœnœ tɨ á te ga la ngu. ");
INSERT INTO mnh_vpl VALUES ("AC27_33","074_27_33","ACT","27","33","33","Kœkate adœke osho kɔrɔ, Polo kœkɨ ga tœ azu para adœke endje zɨ œrœ. Tshe pa fœ endje adœke: «'E wu, œ mbœrœ kpesheke pɔsɔ bisha á 'e sœ kœgugu dœ awa yugu yé á zɨzɨ anga œrœ bale nene asœke. ");
INSERT INTO mnh_vpl VALUES ("AC27_34","074_27_34","ACT","27","34","34","Mœ sœ kœkɨ ga tœ 'e adœke 'e zɨ œrœ, gbambanœ nene, œ li adœke 'e mbœrœ ataa yekane á kœshe. Uzu bale ugurutœ 'e œ tshu nene.» ");
INSERT INTO mnh_vpl VALUES ("AC27_35","074_27_35","ACT","27","35","35","Manda kœpa ataa, Polo za mapa, á gi mershe fœ Ndjaba tœ ala endje para, á tetœ kœzɨ tœnœ. ");
INSERT INTO mnh_vpl VALUES ("AC27_36","074_27_36","ACT","27","36","36","Yeka á endje gbɔ gbɔgbɔ á tetœ kœzɨ œnœ endje rœgonœ. ");
INSERT INTO mnh_vpl VALUES ("AC27_37","074_27_37","ACT","27","37","37","A'a para lœ egerœ agbanœ 'a sœ lima azu kama bisha dœ zazu votɔ dœ ndjokpa dœ amanœ mindu dœ bale. ");
INSERT INTO mnh_vpl VALUES ("AC27_38","074_27_38","ACT","27","38","38","Manda kœzɨrœ, uvu azu para su, yé endje tetœ kœko ble va ga la ngu mbœrœ egerœ agbanœ kœlɨlɨ nene. ");
INSERT INTO mnh_vpl VALUES ("AC27_39","074_27_39","ACT","27","39","39","Manda kœkɔrɔ osho, aayi kœmbœrœ akwa lœ egerœ agba wu adœke œne ndo dœ ɔshɔ ye. Kashe endje wuwu lima sœ ogo mangunœ nene, ɓata á endje wu osho á ungu li ga lœ mindu, endje gbe kœpara awa kœza agba ga tœ ama ɔshɔ ɓa zœ. ");
INSERT INTO mnh_vpl VALUES ("AC27_40","074_27_40","ACT","27","40","40","Endje wa uwu tœ longonœ á katœ nœ tɨ ga la egerœ ungunœ, endje vwara kayi œ jerœ ga la ngu. Manda nœ, endje du lœba siriki ga utshunœ adœke yugu kœmbœrœ tœnœ á kœvwi egerœ agbanœ ga utshunœ yé œ tetœ kœna gutœnœ ga tœ ama ɔshɔ. ");
INSERT INTO mnh_vpl VALUES ("AC27_41","074_27_41","ACT","27","41","41","Kashe egerœ agbanœ shi pa mindu á sœ uguru gbɔgbɔ ungu bisha. Tshatshu egerœ agbanœ li lima ga lœ mindu, œ sœsœ lima kœturutœ ye nene, yé gbɔgbɔ loko kavwa lima budunœ ye. ");
INSERT INTO mnh_vpl VALUES ("AC27_42","074_27_42","ACT","27","42","42","Aturugu kœwu adœke egerœ agba sœ kœndɨ tœnœ, á gbe kœwo aayi kánga mbœrœ endje kœdɔ ungu yeka á kœkpa nene. ");
INSERT INTO mnh_vpl VALUES ("AC27_43","074_27_43","ACT","27","43","43","Kashe gbozu nœ aturugu yindœ kœshe lima Polo, yé á pakata aturugunœ, yé á pa fœ azu neke á endje wusœ ungu adœke endje i ga la nœ, œ dɔ zutœnœ ga pa ɔshɔ. ");
INSERT INTO mnh_vpl VALUES ("AC27_44","074_27_44","ACT","27","44","44","Anga endje zu dœ maɓaya too dœ agba ndɨndɨ egerœ agbanœ. Mara á azu para zu lima ungu dœ ɔtshɔ nœ dœ mœ. ");
INSERT INTO mnh_vpl VALUES ("AC28_1","074_28_1","ACT","28","1","1","Manda kœshe 'a, 'a dji adœke ɨ'ɨrɨ tshikinœ asœ kœdœ Malte. ");
INSERT INTO mnh_vpl VALUES ("AC28_2","074_28_2","ACT","28","2","2","Ayengɔ ogonœ mbœrœ ɔtshɔrœ fœ 'a. Endje ngbɔ egerœ owo, á e 'a para ga ɨndɨrɨnœ, mbœrœ yavuru sœ kœni tœnœ yé ɨzɨ sœ waa. ");
INSERT INTO mnh_vpl VALUES ("AC28_3","074_28_3","ACT","28","3","3","Polo rɔ lima agba yawo á za vwi ga ta wo, anga yakoro wuta mbœrœ katsha owonœ, á de kane ye á tɔpe tœnœ. ");
INSERT INTO mnh_vpl VALUES ("AC28_4","074_28_4","ACT","28","4","4","Kœwu adœke yakoronœ de kane Polo, ayengɔ ogonœ pa lœ tœ endje adœke: «Adjapu, yakoshe asœ kœdœ ayi kœwo azu, tshe tshɔ lœnœ la ngu, kashe ayi kœwa ngbanga tshalafo yiyindœ nœ adœke tshe sœ dœ soro nene.» ");
INSERT INTO mnh_vpl VALUES ("AC28_5","074_28_5","ACT","28","5","5","Yé Polo vwi tshelœ kane ye, yakoronœ te ga ta wo, kashe katsha yakoronœ mbœmbœrœ she nene. ");
INSERT INTO mnh_vpl VALUES ("AC28_6","074_28_6","ACT","28","6","6","Anga azunœ sœ lima kœkate kœwu mara á katsha yakoronœ œ mbœrœ she too ndje tshe gbɔ kukuku œ tshu, kashe endje ka œrrr anga œrœ bale mbœmbœrœ nene. Endje kœfa tshelœ o'o ama endje á kœpa adœke: «Yakoshe asœ kœdœ anga ndjaba.» ");
INSERT INTO mnh_vpl VALUES ("AC28_7","074_28_7","ACT","28","7","7","Egerœ uzu bale ndo dœ osho á sœ ɨndɨrɨnœ á ɨ'ɨrɨ ye kœdœ Publiyuse, sœ lima dœ osho kœsœ ndo dœ tshikinœ asœmœ kpœtœmœ. Tshe za osho kœsœ fœ 'a dœ ɔtshɔ lɔsu yé 'a lo kpœtœmœ olo votɔ. ");
INSERT INTO mnh_vpl VALUES ("AC28_8","074_28_8","ACT","28","8","8","Aba Publiyuse sœ lima dœ koɓa biwa œdœ pe awa. Polo na kœwu she, á e Ndjaba tœ ayi koɓanœ, á to kane ye ga pa ye ngbewo á koɓa nœ ye kœka ye. ");
INSERT INTO mnh_vpl VALUES ("AC28_9","074_28_9","ACT","28","9","9","Manda nœ, anga azu tshikinœ á endje sœ lima dœ koɓa, na ga ndœ Polo ndœ kœgbɔ kœshe yé tshe she endje ye. ");
INSERT INTO mnh_vpl VALUES ("AC28_10","074_28_10","ACT","28","10","10","Endje lɨsœ 'a lima waa, ɔlɔ á 'a jerœ ga la ngu ndœ kœro tœnœ, endje to œrœ kɔ á 'a sœ lima dœ ogonœ fœ 'a. ");
INSERT INTO mnh_vpl VALUES ("AC28_11","074_28_11","ACT","28","11","11","'A mbœrœ yapu votɔ lœ Malte, manda nœ 'a ɔ ga lœ egerœ agba, á sœpe lima lœ tshiki lœ ɨzɨ á sœ ɓa zœ. Tœnœ kœdœ lima egerœ agba tshelœ Alekezandri á ɨ'ɨrɨ ye kœdœ: «Ameya ndjaba.» ");
INSERT INTO mnh_vpl VALUES ("AC28_12","074_28_12","ACT","28","12","12","'A na œrrr yé œ wuta ɓa lakpɨ Sirakuse, yé 'a mbœrœ kpœtœ olo votɔ. ");
INSERT INTO mnh_vpl VALUES ("AC28_13","074_28_13","ACT","28","13","13","Kœto kpœtœmœ, 'a afo kpœtœ, 'a za tshandɨrɨ mangunœ œ ro œrrr gbuu ga lœ Rejio. Osho kɔrɔ pa nœ, yugu to dja ga mangba 'a yé á tagala 'a manda olo bisha á 'a wuta ga lœ Puzole. ");
INSERT INTO mnh_vpl VALUES ("AC28_14","074_28_14","ACT","28","14","14","Ɓa zœ, 'a gbɔ anga ayindœ Yisu, á endje kɨ ga tœ 'a adœke 'a mbœrœ dœ œne pɔsɔ bale, yeka manda nœ á 'a kœli ga lœ Roma. ");
INSERT INTO mnh_vpl VALUES ("AC28_15","074_28_15","ACT","28","15","15","Aaya lœ Yisu ɓa lœ Roma dji ndœ 'a, á na para tshatshu 'a, á kate 'a ɓa lœ zando Apiuse œdœ osho á endje e «anda agene». Lɔkɔ á Polo wu endje, tshe gbɔ gbɔgbɔ, yé œ za mershe fœ Ndjaba. ");
INSERT INTO mnh_vpl VALUES ("AC28_16","074_28_16","ACT","28","16","16","Kœyi kumu 'a ga lœ Roma, endje za awa fœ Polo ndœ kœgbɔ anda nœ ye kœlo tœnœ dœ pe turugu á tshe sœ kœza ala ye tœ ye. ");
INSERT INTO mnh_vpl VALUES ("AC28_17","074_28_17","ACT","28","17","17","Manda olo votɔ, Polo kœvwa osho fœ agbozu tshapa Ayuda ndœ kœngbɔtœ endje ga tœ nœ. Ɔlɔ á endje ngbɔtœ endje ga tœnœ, Polo kœpa fœ endje adœke: «Alaya, mœ mbœmbœrœ ekperœ ga tœ azu ogo nœ azœ nene, too ga tœ o'o á aata azœ katœ nœ tɨ fœ azœ nene, yeka á Ayuda nœ Yerusaleme tɔ meza pa mœ fœ azu nœ Roma asœ. ");
INSERT INTO mnh_vpl VALUES ("AC28_18","074_28_18","ACT","28","18","18","Endje yu osho œ yindœ kœkatœ mœ; gbambanœ nene, endje gbɔgbɔ ekperœ bale á mœ mbœrœ yeka á endje kœwa o'o ndœ kœwo mœ nene. ");
INSERT INTO mnh_vpl VALUES ("AC28_19","074_28_19","ACT","28","19","19","Kashe Ayuda vwaratœ endje ye, mœ sœsœ lima dœ anga œrœ kœmbœrœ tœnœ nene, á mœ yɔndœ nœ adœke gbozugo Roma kœwa ngbanga nœ mœ. Kashe mœ sœsœ dœ gbetshelœ kœndɨ ogo nœ azœ nene. ");
INSERT INTO mnh_vpl VALUES ("AC28_20","074_28_20","ACT","28","20","20","Mbœrœ tœnœ ataa á mœ vwa osho ndœ 'e adœke a pa 'o mbœrœ tœnœ kane. Adja upu adœke endje i kane mœ mbœrœ uzu á azu Israyele sœ kœza lɔsu endje ga tœ ye.» ");
INSERT INTO mnh_vpl VALUES ("AC28_21","074_28_21","ACT","28","21","21","Endje gi fœ she adœke: «'A gbɔgbɔ anga mbeti á to lœ Yuda mbœrœ o'o nœ zœ nene, yé lœ ugurutœ alaya á endje na asœ, anga bale á tshe na dœ ndœ trœrœ zœ too tshe pa ekpe o'o mbœrœ ɓœ gugu nene. ");
INSERT INTO mnh_vpl VALUES ("AC28_22","074_28_22","ACT","28","22","22","Kashe 'a yindœ kœdji ɓœ kœmɨndœ neke á ɓœ na dœ tœnœ mbœrœ osho kɔ, azu sœ kœvwaratœ endje tœ awa nœ zœ á ɓœ zatœ zœ ndœ nœ.» ");
INSERT INTO mnh_vpl VALUES ("AC28_23","074_28_23","ACT","28","23","23","Endje kœdɨ mbulu dœ Polo, yé lɔkɔnœ, endje kœna ndjoro ga lœ bɨngɨ nœ ye. Kœto dœ amazɨ œrrr kpii, Polo sœ kolœ kœyisœ 'o tœ upu nœ Ogo gbozu nœ Ndjaba fœ endje kœto tœ mbeti nœ Moyize dœ pe œnœ aayi kœgbara o'o mbœrœ kœma fœ endje adœke endje yindœ Yisu. ");
INSERT INTO mnh_vpl VALUES ("AC28_24","074_28_24","ACT","28","24","24","Anga endje sœ lima kœyindœ o'o á tshe sœ kœpa tœnœ, kashe anga endje vwaratœ endje kœyindœ nœ ye. ");
INSERT INTO mnh_vpl VALUES ("AC28_25","074_28_25","ACT","28","25","25","Kœgu endje tœ awa, endje sœ lima kœdjitœ endje lœ tœ endje nene; á Polo kpa kœpa ga pa nœ fœ endje adœke: «Tœnœ kœdœ adja o'o nœ Ɔtshɔ Ɨshirɨ á ayi kœgbara o'o Isaya mɨ lima ndœ nœ fœ aata 'e adœke: ");
INSERT INTO mnh_vpl VALUES ("AC28_26","074_28_26","ACT","28","26","26","“Na ga ndœ azu asœmœ yé œ pa fœ endje adœke: 'e dji dœ ɔtshɔnœ kashe 'e wusœ adanœ nene, 'e mesho dœ ɔtshɔnœ kashe 'e wu dœ ɔtshɔnœ nene. ");
INSERT INTO mnh_vpl VALUES ("AC28_27","074_28_27","ACT","28","27","27","Gbambanœ nene, lɔsu azu asœ gbɔɔgbɔ; endje be utu endje dœ pe ala endje ye, mbœrœ endje yiyindœ kœwu œrœ nene, yé œ yiyi ndje ndœ kœdji o'o nene, endje yiyindœ kœfa lɔsu endje fœ mœ dœ́ Ndjaba nene. Yé mœ she bala endje koto o?”» ");
INSERT INTO mnh_vpl VALUES ("AC28_28","074_28_28","ACT","28","28","28","Polo kœpa fœ endje adœke: «'E wusœ nœ adœke, Ndjaba vwa kœshe fœ anga angbɨ azu; endje, endje dji bala zœ.»  ");
INSERT INTO mnh_vpl VALUES ("AC28_29","074_28_29","ACT","28","29","29","Kœdji Polo ataa, Ayuda gitœ endje yé œ tetœ kœshara o'o ugurutœ endje dœ tœ endje. ");
INSERT INTO mnh_vpl VALUES ("AC28_30","074_28_30","ACT","28","30","30","Polo mbœrœ lima ungu bisha tshakudu anda dœ ngendja nœ ye dœ tœ ye, yé tshe sœ kœpa o'o dœ azu kɔ á endje sœ lima kœna ga ndœ ye. ");
INSERT INTO mnh_vpl VALUES ("AC28_31","074_28_31","ACT","28","31","31","Tshe sœ lima kœmɨndœ Ogo gbozu nœ Ndjaba, kœyisœ o'o nœ Gbozu Yisu Kristu dœ awa nene, yé uzu bale kœpakata she gugu lima nene.");
INSERT INTO mnh_vpl VALUES ("RM1_1","075_1_1","ROM","1","1","1","Œmœ Polo, ayi akwa nœ Yisu Kristu mœ sœ kœsu mbetinœ asœke fœ 'e. Ndjaba e mœ mbœrœ kœdœ ayi avwa yé tshe ke mœ ndœ kœpandœ Ɔtshɔ O'o nœ ye. ");
INSERT INTO mnh_vpl VALUES ("RM1_2","075_1_2","ROM","1","2","2","Ɔtshɔ O'onœ á Tshe pa lima ndœ nœ lœ awa nœ aayi kœgbara o'o ala œyerœ Buku, ");
INSERT INTO mnh_vpl VALUES ("RM1_3","075_1_3","ROM","1","3","3","tœ upu nœ Gbolo nœ ye, á endje zu she ɓata uzu lœ uwu aata Davidi. ");
INSERT INTO mnh_vpl VALUES ("RM1_4","075_1_4","ROM","1","4","4","Á lœ awa nœ Ɔtshɔ Ɨshirɨ, Ndjaba she lima she lœ akuzu. Tshe yi lima sœ nœ adœke, tshe kœdœ gbolo nœ œne á tshe sœ dœ gbɔgbɔ waa. ");
INSERT INTO mnh_vpl VALUES ("RM1_5","075_1_5","ROM","1","5","5","Dœ awa nœ ye œdœ mbœrœ mokɔ nœ ye dá Ndjaba ma ɔtshɔ lɔsu nœ ye ga ndœ mœ yeka á e mœ adœke mœ te ayi avwa nœ ye, dœ́ mœ gbara fœ angbɨ azu kɔ adœke endje sœ dœ kœyindœrœ ga ndœ Yisu Kristu, yé œ dji o'o ama ye. ");
INSERT INTO mnh_vpl VALUES ("RM1_6","075_1_6","ROM","1","6","6","E'e ndje, 'e lœ ugurutœ azunœ asœmœ mbœrœ á Yisu Kristu e ndje 'e. ");
INSERT INTO mnh_vpl VALUES ("RM1_7","075_1_7","ROM","1","7","7","Ga ndœ 'e dœ́ azu Roma kɔ, Ndjaba yindœ 'e yé tshe e 'e adœke 'e wuta ayerœ azu. Kaka adœke Aba azœ dœ Ndjaba œdœ Gbozu nœ azœ dœ Yisu Kristu ma ɔtshɔ lɔsu nœ endje fœ 'e, yé œ za kœsœ gee fœ 'e. ");
INSERT INTO mnh_vpl VALUES ("RM1_8","075_1_8","ROM","1","8","8","Utshunœ kɔ, mœ donga Ndjaba nœ mœ lœ awa nœ Yisu Kristu mbœrœ 'e para kɔkɔ. Gbambanœ nene, tshapashɔ djigi sœ kœpa o'o tœ upu nœ kœyindœrœ nœ 'e. ");
INSERT INTO mnh_vpl VALUES ("RM1_9","075_1_9","ROM","1","9","9","Mœ kœsœ tœ kœyisœ Ɔtshɔ O'o nœ Gbolo nœ Ndjaba, mœ sœ kœmbœrœ akwa nœ Ndjaba dœ lɔsu mœ bale. Yé tshe wusœ nœ adœke mœ sœ tœ kœpa adja o'o, adœke mœ sœ kœgbe dœ e'e lœ avwala nœ mœ. ");
INSERT INTO mnh_vpl VALUES ("RM1_10","075_1_10","ROM","1","10","10","Ɔlɔ dœ ɔlɔ, mœ sœ kœkɨ fœ Ndjaba adœke œdœ tshe kœyindœ nœ, tshe kɔrɔ awa fœ mœ dœ́ mœ wuta ga ndœ 'e. ");
INSERT INTO mnh_vpl VALUES ("RM1_11","075_1_11","ROM","1","11","11","Gbambanœ nene, mœ sœ adja dœ ogo kœwutœ mœ dœ 'e yeka á gbɔgbɔ kœmbœrœ akwa nœ Ɔtshɔ Ɨshirɨ kœmatœ ye lœ 'e adœke kœyindœrœ nœ 'e kœgerœ. ");
INSERT INTO mnh_vpl VALUES ("RM1_12","075_1_12","ROM","1","12","12","Adja mœ yindœ kœna kœwutœ mœ dœ 'e mbœrœ a ngbɔɓa gbetshelœ nœ azœ lœ kœyindœrœ á a sœ dœ tœnœ á kœza gbɔgbɔ fœ azœ kɔ. ");
INSERT INTO mnh_vpl VALUES ("RM1_13","075_1_13","ROM","1","13","13","Aaya mœ, 'e wusœ nœ adœke mœ gbe tœ kœna ga ndœ 'e awa ndjoro kashe œrrr ngɔngɔ asœke, awa kɔkɔrɔ fœ mœ nene. Mœ yi lima ndœ nœ adœke ndœla akwa nœ mœ wuta ngbɨ ugurutœ 'e ɓata á wuta ndje ngbɨ ugurutœ anga angbɨ azu á endje wuwusœ Yisu nene. ");
INSERT INTO mnh_vpl VALUES ("RM1_14","075_1_14","ROM","1","14","14","Mœ sœ dœ kuɗa nœ azu kɔ: azu á ala endje kɔrɔ œdœ endjeneke á ala endje kɔkɔrɔ nene, azu á endje sœ dœ kœwusœrœ dœ endjeneke á endje gugu dœ kœwusœrœ nene; ");
INSERT INTO mnh_vpl VALUES ("RM1_15","075_1_15","ROM","1","15","15","kuɗanœ asœmœ kœdœ kœna kœyisœ Ɔtshɔ O'o fœ endje. Atamœ, mœ yi ndje ndœ kœna ɓa lœ Roma mbœrœ kœyisœ Ɔtshɔ O'onœ asœmœ fœ 'e. ");
INSERT INTO mnh_vpl VALUES ("RM1_16","075_1_16","ROM","1","16","16","Mœ sœsœ dœ tshula mbœrœ kœyisœ Ɔtshɔ O'o nene. Tœnœ kœdœ gbɔgbɔ nœ Ndjaba mbœrœ kœshe uzu kɔ á tshe sœ dœ kœyindœrœ: Ayuda utshunœ œdœ ndje angbɨ azu manda nœ. ");
INSERT INTO mnh_vpl VALUES ("RM1_17","075_1_17","ROM","1","17","17","Gbambanœ nene, Ɔtshɔ O'onœ asœ dá yisœ kœsœ ndjii nœ Ndjaba á uzu œ wuta ga tœ nœ lœ awa nœ kœyindœrœ. Mbœrœ endje sú ɓala Buku adœke: «Uzu neke á tshe wuta ndjii lœ awa nœ kœyindœrœ, tshe gbɔ soro.» ");
INSERT INTO mnh_vpl VALUES ("RM1_18","075_1_18","ROM","1","18","18","Ndjaba ma lima ókó nœ ye kœto ɓa lafo ga tœ ekperœ œdœ ga tœ azu kɔ á endje sœ kœmbœrœ œrœ á sœsœ ndjii nene. Gbambanœ nene, ekperœnœ asœmœ sœ kœmbœrœ adœke endje za œrœ ku ala awa adja o'o. ");
INSERT INTO mnh_vpl VALUES ("RM1_19","075_1_19","ROM","1","19","19","Andaa, œneke á œ li adœke a wusœ nœ ɓa ndœ Ndjaba sœ ngbɨ mbœrœ azu kɔ. Ndjaba dœ tœ ye dá ma ngbɨ fœ endje. ");
INSERT INTO mnh_vpl VALUES ("RM1_20","075_1_20","ROM","1","20","20","Pe tœ ali kœmbœrœ tshapashɔ, œrœ á Ndjaba mbœrœ sœ kœma gbɔgbɔ nœ ye waa dœ waa œdœ ndje mara ye dœ tœ ye. Ataa, ɓata azu wuwusœ nœ nene adœke tshe kœdœ Ndjaba, endje gbɔ o'o ye. ");
INSERT INTO mnh_vpl VALUES ("RM1_21","075_1_21","ROM","1","21","21","Endje wusœ Ndjaba kashe endje sœsœ kœdonga she ɓata Ndjaba nene, œ sœsœ ndje kœgi mershe fœ she nene. Andaa gbetshelœ nœ endje ndɨ yé kœwusœrœ nœ endje sœ kolœ ubu osho. ");
INSERT INTO mnh_vpl VALUES ("RM1_22","075_1_22","ROM","1","22","22","Endje sœ kœpa adœke œne kœdœ azu nœ kœwusœtœ, andaa endje kœdœ aayi ɨndɨ. ");
INSERT INTO mnh_vpl VALUES ("RM1_23","075_1_23","ROM","1","23","23","Tœ œsœ kœdonga Ndjaba á tshe tshutshu nene, endje tetœ kœdonga œrœ á endje mbœrœ dœ kane azu á tshutshu, ɓata ayanu, agea too ayakoro. ");
INSERT INTO mnh_vpl VALUES ("RM1_24","075_1_24","ROM","1","24","24","Mbœrœ tœnœ ataa dá Ndjaba katœ endje tɨ kœmbœrœ œneke á endje gbe dœ tœnœ, á endje lœ kœdjatœ endje lœ ngbɨndɨrœ yeka á sœ kœgbɔ tshula. ");
INSERT INTO mnh_vpl VALUES ("RM1_25","075_1_25","ROM","1","25","25","Endje ka ɓalima tœ Ndjaba tɨ œ yi kolœ ndœ wala, endje sœ kolœ kœdonga œrœ á Ndjaba mbœrœ. Kashe Ndjaba á tshe mbœrœ lima œrœ kɔ, endje yiyindœ kœdonga she nene. Œshe kœdœ Ndjaba má œ li adœke azu donga she waa dœ waa. Ame. ");
INSERT INTO mnh_vpl VALUES ("RM1_26","075_1_26","ROM","1","26","26","Ádánœ á Ndjaba katœ endje tɨ adœke endje za awa œrœ á endje gbɔ tshula manda nœ dœmœ. Awo endje sœsœ kœlo dœ ayakoshe nene, kashe endje lo kolœ dœ ayashe anga endje. ");
INSERT INTO mnh_vpl VALUES ("RM1_27","075_1_27","ROM","1","27","27","Ayakoshe mbœrœ ndje awa bale. Endje katœ kœlo dœ ayashe, œ sœ dœ ogo anga endje dœ ayakoshe, á sœ kœlo dœ endje. Endje mbœrœ ugurutœ endje œrœ á gaga nene yé endje gbɔ œrœ tshangba djingili nœ endje. ");
INSERT INTO mnh_vpl VALUES ("RM1_28","075_1_28","ROM","1","28","28","Ɓata á endje vwaratœ endje tœ kœwusœ Ndjaba, Ndjaba katœ endje tɨ adœke endje sœpe lœ ɨndɨ kœwusœrœ nœ endje. Ataa, endje sœ kœmbœrœ œrœ á li adœke endje mbœrœ nene. ");
INSERT INTO mnh_vpl VALUES ("RM1_29","075_1_29","ROM","1","29","29","Endje su dœ tshelœ aka œrœ á sœsœ ndjii nene, dœ ekperœ, dœ egerœ lɔsu, kœmbœrœ anga endje dœ ɔgbɔ œrœ, endje sú dœ uku, dœ kœwo azu, dœ œbœrœ, afara, œdœ pe ndje kœpa wala, ");
INSERT INTO mnh_vpl VALUES ("RM1_30","075_1_30","ROM","1","30","30","kœpatœ osho, ayingba Ndjaba, kœgu osho, egerœ kumu œdœ pe kœzatœ endje. Endje sœ kœpara dœ awa kɔ ndœ kœmbœrœ ekperœ, yé endje lɨlɨsœ aayi kœzu endje nene. ");
INSERT INTO mnh_vpl VALUES ("RM1_31","075_1_31","ROM","1","31","31","Endje gugu dœ kœwusœrœ nene, endje mbœmbœrœ œrœ liaka ndœma endje nene, endje sœ dœ ɔgbɔ lɔsu yé endje wuwu ndje oyo azu nene. ");
INSERT INTO mnh_vpl VALUES ("RM1_32","075_1_32","ROM","1","32","32","Endje wusœ nœ dœ ɔtshɔnœ adœke Ndjaba pa liya adœke: azu á endje mbœrœ mara œrœ ataa li dœ kuzu. Kashe endje lœ kolœ kœmbœrœ œrœ atake, yé œ sœ ndje dœ yanga azu á endje lœ kœmbœrœ mara ekperœ œrœ asœmœ. ");
INSERT INTO mnh_vpl VALUES ("RM2_1","075_2_1","ROM","2","1","1","Endje wu oyo zœ nene, œɓœ, œdœ ɓœ kœdœ œɗe, á sœ kœwa ngbanga pa anga zœ. Gbambanœ nene, ɓœ kœsœ kœwa ngbanga pa uzu, ɓœ sœ ndje kœwa o'o ga tœ zœ dœ tœ zœ mbœrœ ɓœ sœ ndje awa bale œɓœ á ɓœ sœ kœwa ngbanga. ");
INSERT INTO mnh_vpl VALUES ("RM2_2","075_2_2","ROM","2","2","2","Andaa a wusœ nœ adœke kœwa ngbanga nœ Ndjaba sœ kœmbœrœtœ ye lœ adja o'o mbœrœ azu á endje sœ kœmbœrœ mara œrœ ataa. ");
INSERT INTO mnh_vpl VALUES ("RM2_3","075_2_3","ROM","2","3","3","Yé œɓœ á ɓœ sœ kœpa adœke azu sœ kœmbœrœ ekperœ, andaa œɓœ ndje ɓœ sœ tœ kœmbœrœ awa bale, ɓœ gbe adœke Ndjaba œ wa ngbanga pa zœ nœ zœ nene a? ");
INSERT INTO mnh_vpl VALUES ("RM2_4","075_2_4","ROM","2","4","4","Ɓœ sœ kœwu egerœ ayo nœ Ndjaba, dœ ɔtshɔ lɔsu ndje dœ ugu lɔsu nœ ye ga ndœ zœ gbambanœ a? Ɓœ wuwusœ nœ nene adœke ayo nœ Ndjaba sœ kœmbœrœ adœke ɓœ fa lɔsu zœ a? ");
INSERT INTO mnh_vpl VALUES ("RM2_5","075_2_5","ROM","2","5","5","Kashe mbœrœ ɔgbɔ lɔsu nœ zœ, dœ gbɔkumu nœ zœ, ɓœ sœ kœpara adœke Ndjaba za egerœ djofele fœ ɓœ dœ lɔkɔ á tshe ma ókó á ma kœwa ngbanga nœ ye á sœ ndjii. ");
INSERT INTO mnh_vpl VALUES ("RM2_6","075_2_6","ROM","2","6","6","Gbambanœ nene, Ndjaba œ to fœ uzu dœ uzu kœli dœ œneke á tshe mbœrœ. ");
INSERT INTO mnh_vpl VALUES ("RM2_7","075_2_7","ROM","2","7","7","Ndjaba œ za soro á ka nene fœ azu neke á endje sœ kœmbœrœ ɔtshɔ akwa, á sœ dœ kœru lɔsu, á sœ kœpara awa kœgbɔ mokɔ, kœlɨsœtœ œdœ pe ɔkɔ á tshu nene. ");
INSERT INTO mnh_vpl VALUES ("RM2_8","075_2_8","ROM","2","8","8","Kashe azu á endje vwaratœ endje tœ adja o'o á tshapu kœza awa œrœ á sœ ndjii, ókó œdœ kœyiangbarœ nœ Ndjaba œ te ga pa endje. ");
INSERT INTO mnh_vpl VALUES ("RM2_9","075_2_9","ROM","2","9","9","Azu kɔ á endje sœ kœmbœrœ ekperœ, œ wu kanga œdœ egerœ oyo: œdœ Ayuda œdœ ndje angbɨ Azu. ");
INSERT INTO mnh_vpl VALUES ("RM2_10","075_2_10","ROM","2","10","10","Kashe uzu kɔ á tshe kœsœ kœmbœrœ ɔtshɔrœ, Ndjaba œ za mokɔ, kœlɨsœtœ œdœ kœsœ gee fœ she; Yuda utshunœ œdœ angbɨ uzu manda nœ. ");
INSERT INTO mnh_vpl VALUES ("RM2_11","075_2_11","ROM","2","11","11","Gbambanœ nene, Ndjaba wuwu tshatshu uzu nene. ");
INSERT INTO mnh_vpl VALUES ("RM2_12","075_2_12","ROM","2","12","12","Azu á endje wuwusœ awa akwa nene, œdœ endje kœtshu, awa akwa gugu dœ ádá bale pa endje nene. Kashe endjeneke kɔ á endje wusœ awa akwa, œdœ endje kœmbœrœ ekperœ, Ndjaba œ wa ngbanga pa endje liaka awa akwa. ");
INSERT INTO mnh_vpl VALUES ("RM2_13","075_2_13","ROM","2","13","13","Gbambanœ nene, azu á endje dji awa akwa kolœ ndœ kœdji tœnœ, endje sœsœ ndjii tœ ala Ndjaba nene. Kashe endjeneke á endje mbœrœtœ endje lindœ awa akwa, endje dá lœ ndjii tœ ala Ndjaba. ");
INSERT INTO mnh_vpl VALUES ("RM2_14","075_2_14","ROM","2","14","14","Lɔkɔ á angbɨ azu á endje wuwusœ awa akwa nene kœsœ kœmbœrœtœ endje lindœ nœ, œ sœ kœma ɓata œ sœ lœ endje andaa endje gugu dœ tœnœ nene. ");
INSERT INTO mnh_vpl VALUES ("RM2_15","075_2_15","ROM","2","15","15","Atamœ, œ sœ kœma ɓata endje sú awa akwanœ ga tœ lɔsu endje. Œdœ endje kœmbœrœ ɔtshɔrœ, œdœ endje kœmbœrœ ndje ekperœ; gbetshelœ nœ endje sœ kœyisœ nœ fœ endje kɔ œdœ ndje œneke á sœ tœ lɔsu endje á sœ kœwa ngbanga too kœpa o'o tshapa endje. ");
INSERT INTO mnh_vpl VALUES ("RM2_16","075_2_16","ROM","2","16","16","Kɔkɔ asœke œ wuta bala ngbɨ dœ lɔkɔ á Ndjaba œ wa ngbanga pa kœmbœrœtœ lœ ubunœ nœ azu lœ awa nœ Yisu Kristu. Asœ kœdœ Ɔtshɔ O'onœ á mœ sœ tœ kœpandœ nœ. ");
INSERT INTO mnh_vpl VALUES ("RM2_17","075_2_17","ROM","2","17","17","Kashe œɓœ á ɓœ dœ Yuda, á ɓœ ka ga pa awa akwa á sœ tœ kœdu okoro zœ mbœrœ Ndjaba nœ zœ, ");
INSERT INTO mnh_vpl VALUES ("RM2_18","075_2_18","ROM","2","18","18","œɓœ á ɓœ wusœ gbetshelœ nœ ye, œɓœ á awa akwa nœ ye yisœ œrœ fœ ɓœ adœke ɓœ wusœ kœke œrœ á sœ dœ ɔtshɔnœ, ");
INSERT INTO mnh_vpl VALUES ("RM2_19","075_2_19","ROM","2","19","19","œɓœ á ɓœ gbe adœke ɓœ kœdœ ayi kœgbota aayibula, ɨngbɨsho mbœrœ azu á endje sœ lœ ubu osho, ");
INSERT INTO mnh_vpl VALUES ("RM2_20","075_2_20","ROM","2","20","20","œɓœ, ɓœ gbe adœke ɓœ kœdœ ayi kœmbœrœ ala fœ azu á endje wuwusœ œrœ nene œdœ amba azu. Ɓata á ɓœ wusœ awa akwa á dœ́ ada kœwusœrœ œdœ adja o'o. ");
INSERT INTO mnh_vpl VALUES ("RM2_21","075_2_21","ROM","2","21","21","Œɓœ á ɓœ kœdœ ayi kœyisœrœ fœ azu, mbœrœ gaɗe á ɓœ sœsœ kœyisœ œrœ fœ ɓœ dœ tœ zœ nene a? Ɓœ sœ kœyisœ œrœ adœke: Zɨzɨ angba nene, yé mbœrœ gaɗe á ɓœ sœ kœzɨ angba a? ");
INSERT INTO mnh_vpl VALUES ("RM2_22","075_2_22","ROM","2","22","22","Ɓœ sœ kœpakata kœlo dœ awo azu, mbœrœ gaɗe á ɓœ lo dœ awo azu a? Ɓœ sœ kœtshene andjaba, yé mbœrœ gaɗe á ɓœ kpa zɨ angba œrœ tshelœ anda kœdonga dœ andjaba a? ");
INSERT INTO mnh_vpl VALUES ("RM2_23","075_2_23","ROM","2","23","23","Ɓœ sœ kœdu okoro zœ adœke ɓœ wusœ awa akwa, kashe ɓœ sœsœ kœlɨsœ ɨ'ɨrɨ Ndjaba nene dœ kœmbœrœ œrœ á sœ kœndɨ awa akwa. ");
INSERT INTO mnh_vpl VALUES ("RM2_24","075_2_24","ROM","2","24","24","Gbambanœ nene, endje sú ɓala Buku nœ Ndjaba adœke: «Angbɨ azu œ gu œsœ Ndjaba kolœ manda 'e.» ");
INSERT INTO mnh_vpl VALUES ("RM2_25","075_2_25","ROM","2","25","25","Ádá gaza sœ tœnœ œdœ ɓœ kœsœ kœmbœrœtœ zœ lindœ awa akwa. Ká ɓœ kœsœsœ kœmbœrœtœ zœ lindœ awa akwa nene, ɓœ li ndje dœ uzu á tshe wawa gaza nene. ");
INSERT INTO mnh_vpl VALUES ("RM2_26","075_2_26","ROM","2","26","26","Œdœ angbɨ uzu á tshe wawa gaza nene kœsœ kœmbœrœtœ ye lindœ awa akwa, endje wu ndje she ɓata uzu á tshe wa gaza. ");
INSERT INTO mnh_vpl VALUES ("RM2_27","075_2_27","ROM","2","27","27","Uzu á tshe wawa gaza nene, á tshe kœsœ kœmbœrœtœ ye lindœ awa akwa, tshe wa ngbanga pa zœ; œɓœ á ɓœ wa gaza, á sœ dœ awa akwa kashe á sœsœ kœmbœrœtœ zœ lindœ nœ nene. ");
INSERT INTO mnh_vpl VALUES ("RM2_28","075_2_28","ROM","2","28","28","Œ dœ́dœ́ œneke á a wu ɓa ushu dá mbœrœ uzu tœ Yuda nene, œ dœ́dœ́ ndje sherœwa uku gaza nœ ɔkɔ dá mbœrœ gaza nene. ");
INSERT INTO mnh_vpl VALUES ("RM2_29","075_2_29","ROM","2","29","29","Kashe adja Yuda kœdœ tsheneke á tshe dœ Yuda ɓa tœ lɔsu ye. Adja gaza kœdœ œnœ lɔsu uzu, œneke á to lœ Ɨshirɨ kashe œ toto lœ mbeti nœ awa akwa nene. Mara uzu ataa, kolœ Ndjaba dá donga she kashe azu nene. ");
INSERT INTO mnh_vpl VALUES ("RM3_1","075_3_1","ROM","3","1","1","Atamœ, Ayuda ropa angbɨ azu dœ gaɗe? Ɔtshɔrœ nœ kœwa gaza kœdœ gaɗe e? ");
INSERT INTO mnh_vpl VALUES ("RM3_2","075_3_2","ROM","3","2","2","Adjapu, ɔtshɔrœnœ sœ waa kashe œneke á ropa nœ kɔ utshunœ kœdœ adœke Ndjaba za lima o'o ama ye fœ Ayuda. ");
INSERT INTO mnh_vpl VALUES ("RM3_3","075_3_3","ROM","3","3","3","Atamœ, œdœ anga Ayudanœ kœvwaratœ endje tœ kœyindœ o'o ama Ndjaba, œ mbœrœ adœke Ndjaba kpa gbe dœ o'o ama ye á tshe pa nene a? ");
INSERT INTO mnh_vpl VALUES ("RM3_4","075_3_4","ROM","3","4","4","Œ sœ atamœ nene. A wusœ œneke: Ndjaba sœ kœpa adja o'o kashe uzu tshapashɔ kœdœ ayi wala. Ɓata endje sú ɓala Buku nœ Ndjaba adœke: «Œ li adœke azu para kɔkɔ wusœ nœ adœke ɓœ sœ ndjii lœ o'o ama zœ, yé œdœ endje kœtɔ meza pa zœ ɓœ te dœ ngbanga nene.» ");
INSERT INTO mnh_vpl VALUES ("RM3_5","075_3_5","ROM","3","5","5","Kashe œdœ kœmbœrœ œrœ nœ azœ á sœsœ ndjii nene kœsœ kœma adœke Ndjaba sœ ndjii, atamœ a pa koto o? Mœ sœ kœyutœ mœ ɓata uzu kɔ œ yutœ ye: «Ndjaba sœsœ ndjii nene yeka á za djofele fœ azœ asœmœ a?» Mœ sœ kœpa o'o asœ ɓata azu. ");
INSERT INTO mnh_vpl VALUES ("RM3_6","075_3_6","ROM","3","6","6","Bale nene! Gbambanœ nene, œdœ Ndjaba kœsœsœ ndjii nene, kotoo á tshe wa ngbanga pa tshapashɔ a? ");
INSERT INTO mnh_vpl VALUES ("RM3_7","075_3_7","ROM","3","7","7","Kashe œ kœsœ adœke kœpa wala nœ mœ ma adja o'o nœ Ndjaba ngbɨ mbœrœ mokɔ nœ ye, ataa mbœrœ gaɗe á tshe kpa wa ngbanga ga tœ mœ ɓata uzu kœmbœrœ ekperœ a? ");
INSERT INTO mnh_vpl VALUES ("RM3_8","075_3_8","ROM","3","8","8","Yé mbœrœ gaɗe a tete má lima tœ kœmbœrœ ekperœ œrrr yeka á kœwuta ga tœ ɔtshɔrœ nene, ɓata anga aayi wala lœ kœmɨndœ nœ fœ azœ nene a? Azunœ alœmœ œ yo dœ ngbanga nœ Ndjaba ɓata œ li dœ endje. ");
INSERT INTO mnh_vpl VALUES ("RM3_9","075_3_9","ROM","3","9","9","Atamœ o'o gaɗe dá a kpa kœpa a? Azœ dœ Ayuda, a ropa angbɨ azu dœ gaɗe e? Bale nene. Mœ yisœ nœ ngbɨ fœ 'e adœke, œdœ Ayuda œdœ angbɨ azu ndje, endje kɔ kœdœ akanga nœ ekperœ. ");
INSERT INTO mnh_vpl VALUES ("RM3_10","075_3_10","ROM","3","10","10","Ɓata endje sú ɓala Buku nœ Ndjaba adœke: «Uzu á tshe sœ ndjii gugu, amba anga bale gugu nene.» ");
INSERT INTO mnh_vpl VALUES ("RM3_11","075_3_11","ROM","3","11","11","Uzu kœwusœ tshelœ kata o'o gugu, uzu bale kœpara awa Ndjaba gugu nene. ");
INSERT INTO mnh_vpl VALUES ("RM3_12","075_3_12","ROM","3","12","12","Azu para kɔkɔ fa tshaangba endje fœ Ndjaba, endje djingili awa. Uzu kœmbœrœ ɔtshɔrœ gugu, amba uzu bale nene. ");
INSERT INTO mnh_vpl VALUES ("RM3_13","075_3_13","ROM","3","13","13","Tshadɔngɔrɔ endje sœ ɓata udu á kɔrɔ. Tima endje sœ tœ kœfara dœ azu, kongwa ama endje sú dœ gɨrɨshi yakoro. ");
INSERT INTO mnh_vpl VALUES ("RM3_14","075_3_14","ROM","3","14","14","O'o kœdarandœ azu dá su pete dœ tshelœ ama endje œdœ pe ushu o'o. ");
INSERT INTO mnh_vpl VALUES ("RM3_15","075_3_15","ROM","3","15","15","Endje sœ gbɔgbɔtœ endje ndœ kœwo azu. ");
INSERT INTO mnh_vpl VALUES ("RM3_16","075_3_16","ROM","3","16","16","Endje sœ kœndɨ azu œdœ kœmbœrœ œrœ kanga fœ endje. ");
INSERT INTO mnh_vpl VALUES ("RM3_17","075_3_17","ROM","3","17","17","Endje wuwusœ awa nœ kœsœ gee nene. ");
INSERT INTO mnh_vpl VALUES ("RM3_18","075_3_18","ROM","3","18","18","Endje sœ kœlɨsœ Ndjaba nene. ");
INSERT INTO mnh_vpl VALUES ("RM3_19","075_3_19","ROM","3","19","19","Andaa a wusœ nœ adœke, o'o á awa akwa pa, œ sœ kœpa tœnœ fœ azu á endje sœ tshakudu awa akwa adœke azu vu ama endje yé tshapashɔ djigi wu adœke œne gbɔ o'o utshu Ndjaba. ");
INSERT INTO mnh_vpl VALUES ("RM3_20","075_3_20","ROM","3","20","20","Ádánœ á ɓa utshu Ndjaba, uzu bale sœsœ ndjii lœ awa nœ akwa nene. Gbambanœ nene, awa akwa sœ kolœ tœ kœma fœ azu adœke endje mbœrœ ekperœ. ");
INSERT INTO mnh_vpl VALUES ("RM3_21","075_3_21","ROM","3","21","21","Ngɔngɔ asœke, Ndjaba yisœ mara á tshe mbœrœ adœke azu wuta ndjii fœ azœ yé œ dœ́dœ́ lœ awa nœ kœna manda awa akwa nene. Kashe awa akwa œdœ aayi kœgbara o'o dá sœ kœpa o'o tœ upu nœ. ");
INSERT INTO mnh_vpl VALUES ("RM3_22","075_3_22","ROM","3","22","22","Ndjaba mbœrœ adœke azu kɔ á endje sœ dœ kœyindœrœ ga ndœ Yisu Kristu wuta ndjii. Tshe mbœrœ atamœ mbœrœ azu kɔkɔ sœ awa bale. ");
INSERT INTO mnh_vpl VALUES ("RM3_23","075_3_23","ROM","3","23","23","Azu para kɔkɔ mbœrœ ekperœ yé endje lili kœli ga lœ mokɔ nœ Ndjaba nene. ");
INSERT INTO mnh_vpl VALUES ("RM3_24","075_3_24","ROM","3","24","24","Kashe Ndjaba yisœ ɔtshɔ lɔsu nœ ye fœ endje á mbœrœ adœke endje wuta ndjii gbambanœ. Tshe mbœrœ adœke lœ awa nœ Yisu Kristu endje she lœ ekperœ ye. ");
INSERT INTO mnh_vpl VALUES ("RM3_25","075_3_25","ROM","3","25","25","Ndjaba vwa Yisu Kristu adœke tshe tshu yeka á indji ye kœdjutɔ ekperœ nœ azu, lœ awa nœ kœyindœrœ mbœrœ kœma œrœ á sœ ndjii. Ndjaba mbœrœ ataa tœ kœma adœke ekperœ á azu mbœrœ lima œne kpa gbe dœ tœnœ nene. ");
INSERT INTO mnh_vpl VALUES ("RM3_26","075_3_26","ROM","3","26","26","Mbœrœ Ndjaba lœ ugu lɔsu nœ ye, yindœ kœma fœ azu adœke œne kœdœ ayi kœmbœrœ œrœ á sœ ndjii. Tshe sœ kœma kœsœ ndjii nœ ye ngɔngɔ asœ adœke azu á endje sœ dœ kœyindœrœ ga ndœ Yisu wuta Ndjii tœ ala œne. ");
INSERT INTO mnh_vpl VALUES ("RM3_27","075_3_27","ROM","3","27","27","Atamœ, adja œɗe dá li kœdu okoro ye a? Uzu bale nene. Mbœrœ gaɗe? Akwa nœ awa akwa a? Bale nene, kashe kolœ dœ ɨ'ɨrɨ kœyindœrœ. ");
INSERT INTO mnh_vpl VALUES ("RM3_28","075_3_28","ROM","3","28","28","Azu wuwuta ndjii mbœrœ kœmbœrœtœ endje liaka akwa nœ awa akwa nene, kashe kolœ mbœrœ kœsœ dœ kœyindœrœ. ");
INSERT INTO mnh_vpl VALUES ("RM3_29","075_3_29","ROM","3","29","29","A gbe kane. Ndjaba kœdœ kolœ Ndjaba nœ Ayuda a? Tshe dœ́dœ́ Ndjaba nœ angbɨ azu nene a? Tshe kœdœ ndje Ndjaba nœ angbɨ azu. ");
INSERT INTO mnh_vpl VALUES ("RM3_30","075_3_30","ROM","3","30","30","Gbambanœ nene, Ndjaba sœ tshebale á sœ kœmbœrœ adœke Ayuda œdœ pe angbɨ azu wuta ndjii lœ awa nœ kœyindœrœ. ");
INSERT INTO mnh_vpl VALUES ("RM3_31","075_3_31","ROM","3","31","31","Yé ɓata a sœ dœ kœyindœrœ, œ li adœke a wu awa akwa gbambanœ a? Œ sœsœ atamœ nene. Kashe a za awa akwa ga tœ adja œsœ awa akwa. ");
INSERT INTO mnh_vpl VALUES ("RM4_1","075_4_1","ROM","4","1","1","O'o gaɗe dá a kpa pa tœ ata azœ dœ Abrayamo ɓata uzu a? Œrœ gaɗe dá tshe gbɔ a? ");
INSERT INTO mnh_vpl VALUES ("RM4_2","075_4_2","ROM","4","2","2","Œdœ tshe kœwuta lima ndjii utshu Ndjaba mbœrœ akwa, tshe li kœdu okoro ye. Kashe tshe lili lima kœdu okoro ye utshu Ndjaba nene. ");
INSERT INTO mnh_vpl VALUES ("RM4_3","075_4_3","ROM","4","3","3","Gbambanœ nene, endje sú ala Buku nœ Ndjaba adœke: «Abrayamo sœ lima dœ kœyindœrœ ga ndœ Ndjaba, yé mbœrœ kœyindœrœ nœ ye, Ndjaba wu she tœ ala ye ndjii.» ");
INSERT INTO mnh_vpl VALUES ("RM4_4","075_4_4","ROM","4","4","4","Ayi akwa gbɔ ngendja tshangba akwa á tshe mbœrœ, gbozu nœ ye œ ko ngendja fœ she gbambanœ nene. Tshe ko fœ she mbœrœ akwa á tshe mbœrœ. ");
INSERT INTO mnh_vpl VALUES ("RM4_5","075_4_5","ROM","4","5","5","Kashe œdœ uzu kœsœsœ kœmbœrœ akwa nene, á kœsœ dœ kœyindœrœ ga ndœ Ndjaba á tshe sœ kœmbœrœ adœke ekpe azu wuta ndjii tœ ala œne, Ndjaba œ wu she ndjii tœ ala ye mbœrœ kœyindœrœ nœ ye. ");
INSERT INTO mnh_vpl VALUES ("RM4_6","075_4_6","ROM","4","6","6","Mbœrœ tœnœ dá Davidi sœ kœdonga kœlɨsœtœ nœ uzu á Ndjaba wu she ndjii tœ ala ye kashe œ dœ́dœ́ lœ kumu akwa nœ ye nene. Endje su ala Buku nœ Ndjaba adœke: ");
INSERT INTO mnh_vpl VALUES ("RM4_7","075_4_7","ROM","4","7","7","«Yanga nœ azu á Ndjaba djerœndœ ekperœ nœ endje yé á gi pa endje ye. ");
INSERT INTO mnh_vpl VALUES ("RM4_8","075_4_8","ROM","4","8","8","Yanga nœ uzu á Gbozu gbegbe dœ ekperœ nœ ye nene.» ");
INSERT INTO mnh_vpl VALUES ("RM4_9","075_4_9","ROM","4","9","9","Yanganœ asœmœ sœ kolœ mbœrœ Ayuda a? Bale nene. Yanganœ sœ ndje mbœrœ angbɨ azu, gbambanœ nene a sœ kœpa adœke: «Ndjaba wu lima Abrayamo ndjii tœ ala ye mbœrœ tshe sœ lima dœ kœyindœrœ ga ndœ ye.» ");
INSERT INTO mnh_vpl VALUES ("RM4_10","075_4_10","ROM","4","10","10","Kashe lɔkɔ gaɗe dá œrœnœ asœke wuta lima a? Œ sœ lima utshunœ adœke Abrayamo wa gaza too manda kœwa gaza? Œ sœsœ lima manda kœwa gaza nene kashe utshu kœwa gaza. ");
INSERT INTO mnh_vpl VALUES ("RM4_11","075_4_11","ROM","4","11","11","Gazanœ yi lima sœ nœ adœke tshe gbɔ ambárá, yé œ wuta ndjii tœ ala Ndjaba lœ kumu kœyindœrœ nœ ye. Mbœrœ œtœnœ ataa, Abrayamo wuta aba azu á endje sœ dœ kœyindœrœ, á endje wawa gaza nene á Ndjaba sœ ndje kœwu endje ɓata ndjii tœ ala ye. ");
INSERT INTO mnh_vpl VALUES ("RM4_12","075_4_12","ROM","4","12","12","Œshe kœdœ ndje aba aayi kœwa gaza, œ yindœ kœpa adœke, kolœ endjeneke á endje za lɔsu endje ga pa kœ wa gaza, kashe ndje endjeneke á endje sœ kœna tœ awa nœ kœyindœrœ nœ aba azœ dœ Abrayamo utshu adœke tshe wa gaza. ");
INSERT INTO mnh_vpl VALUES ("RM4_13","075_4_13","ROM","4","13","13","Ndjaba pa lima fœ Abrayamo dœ aatanœ adœke endje gbɔ tshapashɔnœ asœke djigi ɓata œrœ nœ endje. Tshe papa lima o'o asœ fœ Abrayamo mbœrœ á tshe sœ lima kœmbœrœtœ ye liaka awa akwa nene, kashe mbœrœ á tshe sœ lima ndjii tœ ala ye lœ awa nœ kœyindœrœ. ");
INSERT INTO mnh_vpl VALUES ("RM4_14","075_4_14","ROM","4","14","14","Œdœ Ndjaba kœsœ má kœto œrœ á tshe pa lima tœnœ kolœ fœ azu á endje lœ kœmbœrœtœ endje lindœ awa akwa, atamœ ádá kœyindœrœ gugu nene, yé ádá œrœnœ á tshe pa tœnœ gugu ndje nene. ");
INSERT INTO mnh_vpl VALUES ("RM4_15","075_4_15","ROM","4","15","15","Gbambanœ nene, awa akwa sœ kœmbœrœ adœke ókó nœ Ndjaba te ga pa azu. Kashe osho á awa akwa gugu tœnœ nene, awa kœvwaratœ azu tœ awa akwa gugu bale nene. ");
INSERT INTO mnh_vpl VALUES ("RM4_16","075_4_16","ROM","4","16","16","Ataa, azu œ gbɔ œrœ á Ndjaba pa tœnœ mbœrœ kœyindœrœ adœke œ dœ kœtorœ á tshe to gbambanœ, á ádánœ sœ zœ mbœrœ aata Abrayamo para. Œ dœ́dœ́ kolœ mbœrœ endjeneke á endje sœ kœna manda awa akwa nene, kashe ndje mbœrœ azu á endje sœ dœ kœyindœrœ ɓata Abrayamo. Abrayamo kœdœ aba azœ para kɔkɔ. ");
INSERT INTO mnh_vpl VALUES ("RM4_17","075_4_17","ROM","4","17","17","Ɓata á endje sú ala Buku adœke: «Mœ za ɓœ kœsœ tœ ata ukpulu azu ogo.» Tshe kœdœ ata azœ ɓa utshu Ndjaba á tshe sœ dœ kœyindœrœ ga ndœ ye, tsheneke á tshe sœ kœshe azu lœ kuzu yé á sœ kœmbœrœ adœke œneke á gugu nene sœ zœ. ");
INSERT INTO mnh_vpl VALUES ("RM4_18","075_4_18","ROM","4","18","18","Abrayamo sœ lima dœ kœyindœrœ dœ pe kœza lɔsu ye ga pa Ndjaba. Andaa, gbetshelœ kɔ ka lima ye yeka á tshe kpa wuta lima ata ukpulu azu ogonœ, liaka o'o á endje sú adœke: aata zœ œ ngba atake. ");
INSERT INTO mnh_vpl VALUES ("RM4_19","075_4_19","ROM","4","19","19","Abrayamo ndo lima dœ ngbugu ga pa œrœ nœ́ kama bale (100), kashe tshe mɔmɔ lima lœ kœyindœrœ nœ ye nene. Tshe wu lima sœ nœ adœke œne mɔ, yé awo œne dœ Sara kœdœ lima ayi mara. ");
INSERT INTO mnh_vpl VALUES ("RM4_20","075_4_20","ROM","4","20","20","Tshe sœsœ lima dœ sharapu tœ œrœ á Ndjaba pa lima tœnœ fœ she nene. Kashe kœyindœrœ nœ ye ga ndœ Ndjaba za lima gbɔgbɔ fœ she yé tshe donga lima Ndjaba. ");
INSERT INTO mnh_vpl VALUES ("RM4_21","075_4_21","ROM","4","21","21","Tshe wu lima sœ nœ adœke œneke á ndjaba pa tœnœ, tshe sœ dœ gbɔgbɔ nœ kœmbœrœ tœnœ. ");
INSERT INTO mnh_vpl VALUES ("RM4_22","075_4_22","ROM","4","22","22","Ádánœ á Ndjaba wu lima she ndjii tœ ala ye dœmœ. ");
INSERT INTO mnh_vpl VALUES ("RM4_23","075_4_23","ROM","4","23","23","Andaa, o'o á endje sú ala Buku nœ Ndjaba adœke: «Ndjaba wu Abrayamo Ndjii tœ ala ye», endje súsú kolœ mbœrœ œshe dœ kutɨ ye nene, ");
INSERT INTO mnh_vpl VALUES ("RM4_24","075_4_24","ROM","4","24","24","kashe endje sú ndje mbœrœ azœ á Ndjaba sœ kœwu ndje azœ ɓata azu á endje sœ ndjii mbœrœ kœyindœrœ nœ azœ ga ndœ tsheneke á tshe she Gbozu nœ azœ dœ Yisu lœ akuzu. ");
INSERT INTO mnh_vpl VALUES ("RM4_25","075_4_25","ROM","4","25","25","Œshe á endje wo she mbœrœ ekperœ nœ azœ, á Ndjaba she she lœ akuzu adœke tshe mbœrœ a wuta ndjii. ");
INSERT INTO mnh_vpl VALUES ("RM5_1","075_5_1","ROM","5","1","1","Ɓata á Ndjaba wu azœ ndjii mbœrœ kœyindœrœ, a sœ dœ kœsœ gee ugurutœ azœ dœ Ndjaba lœ awa nœ Gbozu nœ azœ dœ Yisu Kristu. ");
INSERT INTO mnh_vpl VALUES ("RM5_2","075_5_2","ROM","5","2","2","Yisu á a sœ dœ kœyindœrœ ga ndœ ye dá kɔrɔ awa adœke a wusœ ɔtshɔ lɔsunœ á Ndjaba sœ dœ tœnœ ga ndœ azœ. A sœ dœ yanga mbœrœ ɔtshɔ lɔsunœ asœmœ yekane á kœza lɔsu azœ ga tœ kœli ga lœ mokɔ nœ Ndjaba. ");
INSERT INTO mnh_vpl VALUES ("RM5_3","075_5_3","ROM","5","3","3","Ga pa nœ, ata lœ œrœ kanga nœ azœ gbaa, a sœ ndje dœ yanga mbœrœ a wusœ nœ adœke œrœ kanga œ za kœru lɔsu fœ azœ; ");
INSERT INTO mnh_vpl VALUES ("RM5_4","075_5_4","ROM","5","4","4","kœru lɔsu œ to gbɔgbɔ adœke a ropa ɔgbɔ œrœ á na ga ndœ azœ, kœropa ɔgbɔ œrœ á ro ga ndœ azœ œ mbœrœ adœke a ko lɔsu azœ ga tœ œrœ á Ndjaba pa lima tœnœ fœ azœ. ");
INSERT INTO mnh_vpl VALUES ("RM5_5","075_5_5","ROM","5","5","5","Yé tshangba kœko lɔsu azœ ga tœ Ndjaba œ sœ gbambanœ nene, mbœrœ á tshe yisœ kœyindœsho ga ndœ azœ lœ awa nœ Ɔtshɔ Ɨshirɨ á tshe za she fœ azœ. ");
INSERT INTO mnh_vpl VALUES ("RM5_6","075_5_6","ROM","5","6","6","Gbambanœ nene, ɔlɔ á a gugu lima damba dœ gbɔgbɔ nene, dœ lɔkɔ á Ndjaba guma, Kristu tshu lima lœ kumu aayi kœmbœrœ ekperœ. ");
INSERT INTO mnh_vpl VALUES ("RM5_7","075_5_7","ROM","5","7","7","Œ sœ tœ ɔgbɔnœ waa kœyindœ nœ adœke uzu á tshe sœ ndjii tshu. Anga uzu œ yi ete ndœ nœ adœke œne tshu mbœrœ ɔtshɔ uzu. ");
INSERT INTO mnh_vpl VALUES ("RM5_8","075_5_8","ROM","5","8","8","Kashe Ndjaba ma kœyindœsho nœ ye ga ndœ azœ. A dœ́ lima aayi kœmbœrœ ekperœ yé Kristu tshu mbœrœ azœ. ");
INSERT INTO mnh_vpl VALUES ("RM5_9","075_5_9","ROM","5","9","9","Yé ɓata ngɔngɔ asœ, ɓata indji ye mbœrœ adœke a wuta ndjii tœ ala Ndjaba, œ ma adja adœke tshe she bala azœ lœ awa nœ ye lœ ókó nœ Ndjaba. ");
INSERT INTO mnh_vpl VALUES ("RM5_10","075_5_10","ROM","5","10","10","Gbambanœ nene, a dœ́ lima utshunœ ayingba Ndjaba, kashe Ndjaba guma tshaguru tœ ye dœ azœ lœ awa nœ kuzu Gbolo nœ ye. Asœke ma adja adœke Ndjaba œ she bala azœ lœ awa soro nœ Gbolo nœ ye. ");
INSERT INTO mnh_vpl VALUES ("RM5_11","075_5_11","ROM","5","11","11","Ga pa nœ ngɔngɔ asœke, a sœ kœdu okoro azœ mbœrœ Gbozu nœ azœ dœ Yisu Kristu á lœ awa nœ ye dá Ndjaba guma tshagurutœ ye dœ azœ. ");
INSERT INTO mnh_vpl VALUES ("RM5_12","075_5_12","ROM","5","12","12","Ekperœ li lima ga pa tshapashɔ mangba uzu bale, á tshe kœdœ Adamo. Yé ekperœnœ mbœrœ adœke azu tshu kuzu. Yé kuzu te ga pa azu kɔ mbœrœ azu kɔ mbœrœ ekperœ. ");
INSERT INTO mnh_vpl VALUES ("RM5_13","075_5_13","ROM","5","13","13","Ekperœ sœ lima pa tshapashɔ zœ utshunœ adœke Ndjaba za awa akwa. Kashe Ndjaba gbegbe lima dœ ekperœ nene mbœrœ awa akwa gugu lima nene. ");
INSERT INTO mnh_vpl VALUES ("RM5_14","075_5_14","ROM","5","14","14","Andaa, kœto tœ Adamo œrrr ga tœ Moyize, kuzu sœ lima tœ kœwo azu zœ. Yé azu á endje mbœmbœrœ lima ekperœ ɓata Adamo mbœrœ nene tshu ndje lima. Adamo kœdœ lima ɨshirɨ uzu á sœ adœke tshe na manda nœ. ");
INSERT INTO mnh_vpl VALUES ("RM5_15","075_5_15","ROM","5","15","15","Kashe ɔtshɔ lɔsu á Ndjaba za fœ azœ ropa ekperœ á Adamo mbœrœ ye. Ekperœ nœ uzu bale za kuzu ga pa azu para kɔkɔ. Kashe ɔtshɔ lɔsu á Ndjaba to gbambanœ lœ awa nœ uzu bale, Yisu Kristu na ga pa azu para kɔkɔ. ");
INSERT INTO mnh_vpl VALUES ("RM5_16","075_5_16","ROM","5","16","16","Ɔtshɔ lɔsu nœ Ndjaba lili dœ ekperœ á uzu bale mbœrœ nene. Gbambanœ nene, mbœrœ ekperœ nœ uzu bale, Ndjaba wa ɔgbɔ ngbanga ga pa azu para kɔkɔ. Kashe mbœrœ ekperœ ndjoro, ɔtshɔ lɔsu á ndjaba to gbambanœ mbœrœ adœke azu para kɔkɔ wuta lœ ngbanga. ");
INSERT INTO mnh_vpl VALUES ("RM5_17","075_5_17","ROM","5","17","17","Gbambanœ nene, mbœrœ uzu bale, lœ awa ekperœ nœ ye bale á kuzu na ga pa azu para kɔkɔ; awa bale lœ awa nœ Yisu Kristu bale, azu á ɔtshɔ lɔsu nœ Ndjaba œ tu ga pa endje œ sœ bala dœ soro yé endje œ wuta ndjii gbambanœ. ");
INSERT INTO mnh_vpl VALUES ("RM5_18","075_5_18","ROM","5","18","18","Ɓata ekperœ nœ Adamo bale gbota ngbanga ga pa azu para kɔkɔ, akwa nœ kœsœ ndjii nœ uzu bale mbœrœ adœke azu para kɔkɔ wuta ndjii tœ ala Ndjaba, yé œ sœ dœ soro. ");
INSERT INTO mnh_vpl VALUES ("RM5_19","075_5_19","ROM","5","19","19","Ɓata azu para kɔkɔ wuta aayi kœmbœrœ ekperœ lœ kumu uzu bale, awa bale ndje azu para kɔkɔ wuta ndjii mbœrœ uzu bale á tshe dji o'o ama Ndjaba. ");
INSERT INTO mnh_vpl VALUES ("RM5_20","075_5_20","ROM","5","20","20","Awa akwa wuta lima yé ekperœ wuta lima ndjoro, kashe tœ osho á ekperœ wuta ndjoro, ɔtshɔ lɔsu nœ Ndjaba kpa gerœ kœropa nœ. ");
INSERT INTO mnh_vpl VALUES ("RM5_21","075_5_21","ROM","5","21","21","Yé ɓata ekperœ sœ lima dœ gbɔgbɔ ndœ kœwo azu, awa bale ɔtshɔ lɔsu nœ Ndjaba sœ dœ gbɔgbɔ tœ kœshe azu adœke œ to azœ na tœnœ ndœ soro á ka nene lœ awa nœ Gbozu nœ azœ dœ Yisu Kristu. ");
INSERT INTO mnh_vpl VALUES ("RM6_1","075_6_1","ROM","6","1","1","Atamœ, a kpa pa koto o? A lœpe kolœ kœmbœrœ ekperœ yekane á Ndjaba kœma ɔtshɔ lɔsu waa ga ndœ azœ a? ");
INSERT INTO mnh_vpl VALUES ("RM6_2","075_6_2","ROM","6","2","2","Bale nene. Lœ kumu ekperœ, a sœ lima ɓata akuzu, yé kotoo yeka a kpa sœpe kœmbœrœ ekperœ a? ");
INSERT INTO mnh_vpl VALUES ("RM6_3","075_6_3","ROM","6","3","3","Yé a wusœ nœ adœke a gbɔ batisimu kœma adœke a ngbɔɓatœ azœ awa bale lœ kuzu nœ Yisu Kristu. ");
INSERT INTO mnh_vpl VALUES ("RM6_4","075_6_4","ROM","6","4","4","Batisimu nœ azœ má adœke, a tshu yé endje shi azœ awa bale dœ she, adœke ɓata gbɔgbɔ mokɔ nœ Aba dá she Kristu lœ akuzu, azœ ndje a wuta dœ tafo soro. ");
INSERT INTO mnh_vpl VALUES ("RM6_5","075_6_5","ROM","6","5","5","Gbambanœ nene, ɓata á a ngbɔɓatœ azœ bale, á kuzu nœ azœ li dœ œnœ ye, a ngboɓa bala ndje tœ azœ dœ she dœ Kristu lœ kœshe lœ akuzu nœ ye. ");
INSERT INTO mnh_vpl VALUES ("RM6_6","075_6_6","ROM","6","6","6","A wusœ nœ dœ ɔtshɔnœ adœke, Ndjaba wo ongboro uzu nœ azœ awa bale dœ Kristu pa Kurushi adœke ɔkɔ nœ ekperœ ndɨ yekane a kpa kœdœ́dœ́ akanga nœ ekperœ nene. ");
INSERT INTO mnh_vpl VALUES ("RM6_7","075_6_7","ROM","6","7","7","Gbambanœ nene, uzu kœtshu, tshe kpa dœ́dœ́ kanga nœ ekperœ nene. ");
INSERT INTO mnh_vpl VALUES ("RM6_8","075_6_8","ROM","6","8","8","Kashe œdœ a kœtshu awa bale dœ Kristu, a sœ dœ kœyindœrœ adœke a sœ ndje bala dœ soro awa bale dœ she. ");
INSERT INTO mnh_vpl VALUES ("RM6_9","075_6_9","ROM","6","9","9","Mbœrœ a wusœ nœ adœke Ndjaba she Kristu lœ akuzu, tshe kpa tshu bale nene yé kuzu kpa sœsœ dœ gbɔgbɔ pa ye nene. ");
INSERT INTO mnh_vpl VALUES ("RM6_10","075_6_10","ROM","6","10","10","Gbambanœ nene, tshe tshu lima awa bale ngbewo mbœrœ ekperœ œ ka, yé tshe kpa tshu nene. Ngɔngɔ asœke, tshe sœ dœ soro mbœrœ Ndjaba. ");
INSERT INTO mnh_vpl VALUES ("RM6_11","075_6_11","ROM","6","11","11","E'e ndje awa bale, 'e wutœ 'e adœke 'e tshu ndje tœ upu nœ ekperœ yé ngɔngɔ asœke 'e sœ dœ soro mbœrœ Ndjaba lœ awa nœ Yisu Kristu. ");
INSERT INTO mnh_vpl VALUES ("RM6_12","075_6_12","ROM","6","12","12","Kaka adœke ekperœ kpa sœsœ dœ gbɔgbɔ bale pa ɔkɔ 'e á tshu nene. Adja 'e kpa mbœmbœrœ ogo kœza awa ekpe gbetshelœ nœ ɔkɔ nene. ");
INSERT INTO mnh_vpl VALUES ("RM6_13","075_6_13","ROM","6","13","13","Adja 'e kpa koko œrœ kote 'e ga tœ akwa nœ ekperœ ɓata œrœ kœmbœrœ dœ ekperœ nene. Kashe 'e zatœ 'e fœ Ndjaba ɓata azu á endje to lœ kuzu á kwa ga lœ soro, 'e kotœ 'e djigi ga tœ akwa nœ ye ɓata œrœ mbœrœ akwa á sœ ndjii. ");
INSERT INTO mnh_vpl VALUES ("RM6_14","075_6_14","ROM","6","14","14","Gbambanœ nene, ekperœ kpa li tœ kœsœ tœ gbozu pa 'e nene mbœrœ 'e kpa sœsœ tshakudu awa akwa nene, kashe 'e sœ tshakudu ɔtshɔ lɔsu nœ Ndjaba. ");
INSERT INTO mnh_vpl VALUES ("RM6_15","075_6_15","ROM","6","15","15","Ataa, a kpa pa koto o? A mbœrœ ekperœ mbœrœ a sœsœ tshakudu awa akwa nene, kashe a sœ tshakudu ɔtshɔ lɔsu a? Bale nene. ");
INSERT INTO mnh_vpl VALUES ("RM6_16","075_6_16","ROM","6","16","16","'E wusœ nœ dœ ɔtshɔnœ adœke œdœ 'e kœzatœ 'e tœ akanga nœ uzu bale ndœ kœdji she, 'e wuta akanga nœ uzunœ á 'e sœ kœdji she. Œdœ ekperœ, œ to uzu ga lœ kuzu; œdœ kœdji o'o, œ to uzu na tœnœ ga tœ awa nœ œrœ á sœ ndjii. ");
INSERT INTO mnh_vpl VALUES ("RM6_17","075_6_17","ROM","6","17","17","A gi mershe fœ Ndjaba mbœrœ lima utshunœ, 'e kœdœ akanga nœ ekperœ, kashe ngɔngɔ asœke 'e dji kœyisœrœ á endje yisœ nœ fœ 'e yé 'e yindœ nœ dœ lɔsu 'e bale. ");
INSERT INTO mnh_vpl VALUES ("RM6_18","075_6_18","ROM","6","18","18","'E kpa dœ́dœ́ akanga nœ ekperœ nene, kashe 'e wuta akanga nœ œrœ á sœ ndjii. ");
INSERT INTO mnh_vpl VALUES ("RM6_19","075_6_19","ROM","6","19","19","Mara kœpa o'o nœ mœ sœ mbœrœ kœza awa fœ 'e kœdji tshelœ kata o'o á mœ sœ kœpa tœnœ. Utshunœ lima, 'e zatœ 'e djigi ndœ kœmbœrœ œrœ tshula œdœ pe ekperœ á fa lima 'e tœ azu kœyiangba Ndjaba. Awa bale œ li adœke 'e zatœ 'e ngɔngɔ asœke ɓata akanga nœ kœmbœrœ œrœ á sœ ndjii á sœ kœmbœrœ adœke azu wuta yerœ. ");
INSERT INTO mnh_vpl VALUES ("RM6_20","075_6_20","ROM","6","20","20","Ɔlɔ á 'e dœ lima akanga nœ ekperœ, œrœ bale á tovworogbo 'e lima ndœ kœmbœrœ œrœ á sœ ndjii gugu nene. ");
INSERT INTO mnh_vpl VALUES ("RM6_21","075_6_21","ROM","6","21","21","Leyɔ gaɗe dá 'e ko lima lœnœ a? Kpœsheke tshula tshangbanœ zaza 'e nene a? Œrœ tshangba nœ kœdœ kuzu. ");
INSERT INTO mnh_vpl VALUES ("RM6_22","075_6_22","ROM","6","22","22","Kashe ngɔngɔ asœke 'e kpa dœ́dœ́ akanga nœ ekperœ nene, 'e wuta akanga nœ Ndjaba. Atamœ 'e zu leyɔ á sœ kœmbœrœ adœke 'e wuta yerœ, gbambanœ nene, œrœ tshangba nœ kœdœ soro á ka nene. ");
INSERT INTO mnh_vpl VALUES ("RM6_23","075_6_23","ROM","6","23","23","Gbambanœ nene, œrœ tshangba ekperœ kœdœ kuzu, kashe œrœ á Ndjaba œ to gbambanœ kœdœ soro á ka nene lœ awa nœ Gbozu nœ azœ dœ Yisu Kristu. ");
INSERT INTO mnh_vpl VALUES ("RM7_1","075_7_1","ROM","7","1","1","Aaya, e'e á 'e wusœ awa akwa, 'e wusœ nœ adœke awa akwa sœ dœ gbɔgbɔ pa azœ dœ azu kolœ dœ ɔlɔ á a sœ dœ soro. ");
INSERT INTO mnh_vpl VALUES ("RM7_2","075_7_2","ROM","7","2","2","Ɓata tœ awo uzu, awa akwa pa adœke œdœ yakoshe kœtshutshu nene, yashenœ lili kœpara anga angbɨ yakoshe nene. Œ kœsœ adœke yakoshe tshu yeka á yashe totœ œ wuta tshakudu awa akwa asœmœ. ");
INSERT INTO mnh_vpl VALUES ("RM7_3","075_7_3","ROM","7","3","3","Œ kœsœ adœke yakoshe sœpe dœ soro á tshe katœ ye tɨ á kpa para anga angbɨ yakoshe, endje pa adœke tshe mbœrœ angba budu. Kashe akɔnœ kœtshu dá tshe wuta tshakudu awa akwanœ. Á tshe kœpara anga angbɨ yakoshe, endje pa adœke tshe mbœrœ angba dœ yakoshenœ asœmœ nene. ");
INSERT INTO mnh_vpl VALUES ("RM7_4","075_7_4","ROM","7","4","4","Aaya, œ sœ ndje awa bale mbœrœ 'e. Ɓata á Kristu tshu lima, 'e tshu awa bale dœ she yé awa akwa kpa sœsœ dœ gbɔgbɔ pa 'e nene. Ngɔngɔ asœke, 'e ngbɔɓatœ 'e dœ Kristu á Ndjaba shé she lœ akuzu asœmœ. Atamœ œ li adœke a zu leyɔ fœ Ndjaba. ");
INSERT INTO mnh_vpl VALUES ("RM7_5","075_7_5","ROM","7","5","5","Mbœrœ lɔkɔ á a sœpe lima lœ ɔkɔ, ekpe gbetshelœ lœ awa nœ awa akwa sœ lima kœmbœrœ akwa lœ undu azœ djigi adœke a zu leyɔ fœ kuzu. ");
INSERT INTO mnh_vpl VALUES ("RM7_6","075_7_6","ROM","7","6","6","Kashe ngɔngɔ asœke, a kpa dœ́dœ́ akanga nœ awa akwa nene, a wuta ɓata azu á endje tshu ɓalima tœ upu nœ awa akwa. Ataa, a kpa mbœmbœrœ akwa fœ Ndjaba dœ kœro manda ongboro mbeti nene, kashe a mbœrœ akwa fœ Ndjaba dœ tafo awa kwa nœ Ɨshirɨ. ");
INSERT INTO mnh_vpl VALUES ("RM7_7","075_7_7","ROM","7","7","7","Atamœ a kpa pa koto o? Awa akwa kœdœ ekperœ a? Œ sœ ataa bale nene. Kashe awa akwa dá yisœ ekperœ fœ mœ. Ataa, mœ wu má ndje lima œsœ egerœ lɔsu nene œdœ awa akwa kœpa fœ mœ nene adœke: «Sœsœ dœ egerœ lɔsu nene.» ");
INSERT INTO mnh_vpl VALUES ("RM7_8","075_7_8","ROM","7","8","8","Yé mbœrœ awa akwa, ekperœ za awa fœ mœ kœza lɔsu mœ ga tœ tshelœ aka egerœ lɔsu kɔ lœ awa nœ awa o'o. Gbambanœ nene, œdœ awa akwa kœgugu nene, ekperœ tshu ye. ");
INSERT INTO mnh_vpl VALUES ("RM7_9","075_7_9","ROM","7","9","9","Utshunœ lima adœke awa akwa wuta, mœ sœ lima dœ soro. Yé ɔlɔ á awa o'o na, ekperœ gbɔ soro, ");
INSERT INTO mnh_vpl VALUES ("RM7_10","075_7_10","ROM","7","10","10","yeka á e kuzu ga pa mœ. Ataa, awa akwa á li má lima adœke œ za soro fœ mœ, œ kpa e kuzu ga pa mœ. ");
INSERT INTO mnh_vpl VALUES ("RM7_11","075_7_11","ROM","7","11","11","Gbambanœ nene, ekperœ gbɔ awa kœfara mœ lœ awa nœ awa o'o yé, lœ awa nœ ye, œ za kuzu ga pa mœ. ");
INSERT INTO mnh_vpl VALUES ("RM7_12","075_7_12","ROM","7","12","12","Atamœ, awa akwa sœ yerœ yé awa o'o sœ yerœ, ndjii œdœ pe dœ ɔtshɔnœ. ");
INSERT INTO mnh_vpl VALUES ("RM7_13","075_7_13","ROM","7","13","13","Ataa ɔtshɔrœ li kœwo uzu a? Œ sœ ataa bale nene. Kashe ekperœ dá wo mœ, œtœnœ dá matœ ye ngbɨɨ. Tshe za œrœ á sœ dœ ɔtshɔnœ á fa tœ kuzu. Œ yindœ kœpa adœke, ekperœ sœ kœmatœ ye tœ egerœnœ kœropanœ dœ tœ ye. ");
INSERT INTO mnh_vpl VALUES ("RM7_14","075_7_14","ROM","7","14","14","A wusœ nœ adœke awa akwa kœdœ ɨshirɨ kashe œmœ kœdœ uzu nœ ɔkɔ, endje ka mœ ɓata kanga nœ ekperœ. ");
INSERT INTO mnh_vpl VALUES ("RM7_15","075_7_15","ROM","7","15","15","Mœ wuwusœ ádá œrœ á mœ sœ kœmbœrœ tœnœ nene. Œrœ á mœ gbe kœmbœrœ tœnœ, mœ sœsœ kœmbœrœ œtœnœ nene yé œneke á mœ sœ kœyiangba nœ, mœ sœ kœmbœrœ œtœnœ. ");
INSERT INTO mnh_vpl VALUES ("RM7_16","075_7_16","ROM","7","16","16","Andaa œdœ œneke á mœ yiyindœ nœ nene, mœ kœsœ kœmbœrœ œtœnœ, mœ sœ awa bale dœ awa akwa yé mœ yindœ nœ adœke awa akwa sœ dœ ɔtshɔnœ. ");
INSERT INTO mnh_vpl VALUES ("RM7_17","075_7_17","ROM","7","17","17","Œ dœ́dœ́ mœ dá sœ kœmbœrœ ataa nene, kashe ekperœ á sœ lœ mœ. ");
INSERT INTO mnh_vpl VALUES ("RM7_18","075_7_18","ROM","7","18","18","Gbambanœ nene, mœ wusœ nœ adœke lœ mœ – mœ yindœ kœpa adœke lœ ɔkɔ mœ – ɔtshɔrœ sœsœ lœ mœ nene: kœgbe kœmbœrœ ɔtshɔrœ sœ zœ kashe kœza ga tœ akwa gugu nene, ");
INSERT INTO mnh_vpl VALUES ("RM7_19","075_7_19","ROM","7","19","19","mbœrœ ɔtshɔrœ á mœ gbe dœ tœnœ, mœ sœsœ kœmbœrœ tœnœ nene, yé ekperœ á mœ gbegbe dœ tœnœ nene, mœ sœ kœmbœrœ tœnœ. ");
INSERT INTO mnh_vpl VALUES ("RM7_20","075_7_20","ROM","7","20","20","Andaa, œdœ mœ kœsœ kœmbœrœ œrœ á mœ gbegbe dœ tœnœ nene, œ dœ́dœ́ mœ dá sœ kœmbœrœ tœnœ nene, kashe ekperœ á sœ lœ mœ. ");
INSERT INTO mnh_vpl VALUES ("RM7_21","075_7_21","ROM","7","21","21","Mœ sœ kœgbɔ awa akwa asœke: œmœ á mœ sœ kœyindœ kœmbœrœ ɔtshɔrœ, mœ sœ kolœ dœ gbɔgbɔ ndœ kœmbœrœ ekperœ. ");
INSERT INTO mnh_vpl VALUES ("RM7_22","075_7_22","ROM","7","22","22","Gbambanœ nene, ɓa tœ lɔsu mœ, mœ sœ dœ yanga awa akwa nœ Ndjaba, ");
INSERT INTO mnh_vpl VALUES ("RM7_23","075_7_23","ROM","7","23","23","kashe ɓa lœ undu mœ, mœ sœ kœwu angbɨ awa akwa á sœ kœnga koshe dœ awa akwa neke á kœwusœrœ nœ mœ yindœ nœ yé œ i mœ ɓata kanga nœ ekperœ á sœ lœ mœ. ");
INSERT INTO mnh_vpl VALUES ("RM7_24","075_7_24","ROM","7","24","24","Œmœ kœdœ adja ayi oyo! Œɗe dá vwara mœ lœ ɔkɔ á sœ kœvwi mœ ga lœ kuzu asœke a? ");
INSERT INTO mnh_vpl VALUES ("RM7_25","075_7_25","ROM","7","25","25","A gi mershe fœ Ndjaba lœ awa nœ Yisu Kristu, Gbozu nœ azœ! Ataa, mœ sœ kanga nœ awa akwa nœ Ndjaba lœ awa kœwusœrœ nœ mœ, kashe ɓata uzu, mœ kœdœ kanga nœ awa akwa nœ ekperœ. ");
INSERT INTO mnh_vpl VALUES ("RM8_1","075_8_1","ROM","8","1","1","Ataa, ngɔngɔ asœke Ndjaba kpa wa ɔgbɔ ngbanga ga tœ azu á endje ngbɔɓatœ endje dœ Yisu Kristu nene. ");
INSERT INTO mnh_vpl VALUES ("RM8_2","075_8_2","ROM","8","2","2","Gbambanœ nene, awa akwa nœ Ɨshirɨ á za soro lœ Yisu Kristu, vwara ɓœ lœ awa akwa nœ ekperœ œdœ pe œnœ kuzu. ");
INSERT INTO mnh_vpl VALUES ("RM8_3","075_8_3","ROM","8","3","3","Awa akwa lili kœvwara uzu lœ ekperœ nene, mbœrœ awa akwa nœ ɔkɔ sœ kœmbœrœ adœke œ sœ dœ gbɔgbɔ nene. Kashe Ndjaba dá mbœrœ œtœnœ. Ndjaba vwa adja Gbolo nœ ye kœna ga pa ɔshɔ ɓata azœ dœ azu kœmbœrœ ekperœ, yé tshe wo gbɔgbɔ nœ ekperœ lœ ɔkɔ. ");
INSERT INTO mnh_vpl VALUES ("RM8_4","075_8_4","ROM","8","4","4","Tshe mbœrœ adœke a wuta azu nœ kœmbœrœ œrœ á sœ ndjii ɓata œneke á awa akwa yindœ nœ. Gbambanœ nene, a kpa sœsœpe dœ ogo kœmbœrœ œrœ nœ ɔkɔ nene kashe a za awa á Ɔtshɔ Ɨshirɨ yisœ nœ fœ azœ. ");
INSERT INTO mnh_vpl VALUES ("RM8_5","075_8_5","ROM","8","5","5","Gbambanœ nene, azu á ɔkɔ kœdœ gbozu ga pa endje, endje sœ kœpara œrœ á ɔkɔ endje sœ dœ ogonœ. Kashe endjeneke á Ɨshirɨ kœdœ Gbozu pa endje, endje para œrœ á Ɨshirɨ yindœ nœ. ");
INSERT INTO mnh_vpl VALUES ("RM8_6","075_8_6","ROM","8","6","6","Uzu á tshe sœ kœpara œrœ á ɔkɔ ye sœ dœ ogonœ, sœ kœpara awa kuzu. Kashe tsheneke á tshe sœ kœpara œrœ á Ɨshirɨ yindœ nœ, za awa soro œdœ pe awa kœsœ gee. ");
INSERT INTO mnh_vpl VALUES ("RM8_7","075_8_7","ROM","8","7","7","Gbambanœ nene, endjeneke á endje sœ kœpara awa œrœ á ɔkɔ endje sœ dœ ogonœ, kœdœ ayingba Ndjaba. Endje sœsœ kœmbœrœtœ endje lindœ awa akwa nœ Ndjaba nene yé endje sœsœ ndje dœ gbɔgbɔ kœro manda nœ nene. ");
INSERT INTO mnh_vpl VALUES ("RM8_8","075_8_8","ROM","8","8","8","Azu neke á endje para œrœ á ɔkɔ endje sœ dœ ogonœ, endje ga tœ ala Ndjaba nene. ");
INSERT INTO mnh_vpl VALUES ("RM8_9","075_8_9","ROM","8","9","9","Kashe e'e, 'e kpa nana manda œrœ á ɔkɔ sœ dœ ogonœ nene, kashe 'e para awa Ɨshirɨ nœ Ndjaba mbœrœ á tshe sœ lœ 'e. Uzu á Ɨshirɨ nœ Kristu sœsœ lœ ye nene, tshe dœ́dœ́ uzu nœ Kristu nene. ");
INSERT INTO mnh_vpl VALUES ("RM8_10","075_8_10","ROM","8","10","10","Œdœ Kristu kœsœ lœ 'e, ɔkɔ 'e tshu tœ upu nœ ekperœ, kashe Ɨshirɨ kœdœ soro 'e adœke 'e wuta ndjii tœ ala Ndjaba. ");
INSERT INTO mnh_vpl VALUES ("RM8_11","075_8_11","ROM","8","11","11","Yé œdœ Ɨshirɨ nœ tsheneke á tshe she Yisu lœ akuzu kœsœ lœ 'e, tsheneke á tshe she Yisu lœ akuzu œ za bala ndje soro fœ ɔkɔ 'e á tshu lœ awa nœ Ɨshirɨ á tshe sœ lœ 'e. ");
INSERT INTO mnh_vpl VALUES ("RM8_12","075_8_12","ROM","8","12","12","Atamœ aaya, a sœ dœ kuɗa pa azœ. Kashe œ dœ́dœ́ kuɗa nœ kœpara awa ndœ kœna manda ogo nœ ɔkɔ azœ nene. ");
INSERT INTO mnh_vpl VALUES ("RM8_13","075_8_13","ROM","8","13","13","Gbambanœ nene, œ kœsœ adœke 'e na manda ogo nœ ɔkɔ 'e, 'e tshu. Kashe œ kœsœ adœke 'e wo ogo nœ ɔkɔ 'e dœ gbɔgbɔ nœ Ɨshirɨ, 'e she. ");
INSERT INTO mnh_vpl VALUES ("RM8_14","075_8_14","ROM","8","14","14","Mbœrœ azu neke á Ɨshirɨ nœ Ndjaba sœ kœyisœ awa fœ endje, kœdœ agbolo nœ Ndjaba. ");
INSERT INTO mnh_vpl VALUES ("RM8_15","075_8_15","ROM","8","15","15","Yé Ɨshirɨnœ á Ndjaba za she fœ 'e asœmœ, mbœmbœrœ adœke 'e dœ akanga yé 'e sœ dœ awa nene; kashe tshe mbœrœ adœke 'e te agbolo nœ Ndjaba yé tshe za awa fœ azœ ndœ kœ'e Ndjaba adœke: «Aba!» ");
INSERT INTO mnh_vpl VALUES ("RM8_16","075_8_16","ROM","8","16","16","Ɨshirɨ nœ Ndjaba sœ kœpa dœ tœ ye lœ gbetshelœ nœ azœ adœke azœ kœdœ agbolo nœ Ndjaba. ");
INSERT INTO mnh_vpl VALUES ("RM8_17","075_8_17","ROM","8","17","17","Yé ɓata agbolo nœ Ndjaba, a gbɔ ndje œrœ manda Ndjaba. A gbɔ awa bale dœ Kristu; gbambanœ nene, œ kœsœ adœke a wu oyo awa bale dœ Kristu, a sœ ndje bala dœ she awa bale lœ mokɔ nœ ye. ");
INSERT INTO mnh_vpl VALUES ("RM8_18","075_8_18","ROM","8","18","18","Mœ wusœ nœ adœke mokɔ nœ Ndjaba á agbolo nœ ye œ wu bala ropa oyonœ á a sœ kœwu tœnœ ngɔngɔ asœke ye. ");
INSERT INTO mnh_vpl VALUES ("RM8_19","075_8_19","ROM","8","19","19","Œrœ kɔ á Ndjaba mbœrœ sœ kœkate dœ lɔsu ga lafo adœke œne wu ɔlɔnœ á tshe ma mokɔ nœ agbolo nœ ye. ");
INSERT INTO mnh_vpl VALUES ("RM8_20","075_8_20","ROM","8","20","20","Gbambanœ nene, œrœnœ kɔ œ yo ga tshakudu tshagbozu nœ gbɔgbɔ á ádánœ gugu nene, œ sœsœ mbœrœ á œrœnœ yindœ nœ nene kashe mbœrœ á Ndjaba yindœ nœ ataa. Kashe œrœnœ ko lɔsu endje ga tœ Ndjaba. ");
INSERT INTO mnh_vpl VALUES ("RM8_21","075_8_21","ROM","8","21","21","Œ yindœ kœpa adœke œrœ á ndjaba mbœrœ sœ kœkate kœwuta ɔlɔ bale tshakudu gbɔgbɔ kœndɨrœ á sœ kœtepa œrœnœ tœ akanga, yé œ gbɔ kœvwara osho œdœ mokɔ nœ agbolo nœ ye. ");
INSERT INTO mnh_vpl VALUES ("RM8_22","075_8_22","ROM","8","22","22","A wusœ nœ adœke œrœ kɔ á Ndjaba mbœrœ sœ ngɔngɔ asœke kœwu oyo mara á yashe œ wu dœ lɔkɔ kœzu gbolo. ");
INSERT INTO mnh_vpl VALUES ("RM8_23","075_8_23","ROM","8","23","23","Œ dœ́dœ́ kolœ œrœ á Ndjaba mbœrœ nene. Œ dœ ndje azœ á a gbɔ Ɨshirɨ ɓata ali tshakala kœtorœ nœ Ndjaba, a sœ ndje kœwu oyo tœ lɔsu azœ kœkate adœke Ndjaba fa azœ tœ agbolo nœ ye yé œ vwara azœ djigi. ");
INSERT INTO mnh_vpl VALUES ("RM8_24","075_8_24","ROM","8","24","24","Gbambanœ nene, a she lima kolœ lœ awa nœ kœza lɔsu azœ ga ndœ Ndjaba, Kashe a kœsœ kœwu œrœ á a za lɔsu azœ ga pa nœ, œ kpa dœ́dœ́ kœza lɔsu ga pa œrœ nene. Uzu ɗe dá za lɔsu ye ga tœ œrœ á tshe wu a? ");
INSERT INTO mnh_vpl VALUES ("RM8_25","075_8_25","ROM","8","25","25","Kashe œ kœsœ adœke a za lɔsu azœ ga tœ œrœ á a wuwu damba nene, œ li adœke a kate dœ kœru lɔsu. ");
INSERT INTO mnh_vpl VALUES ("RM8_26","075_8_26","ROM","8","26","26","Ga pa nœ dœmœ, Ɨshirɨ œ tɨ kane azœ lœ kœmɔ nœ azœ mbœrœ a wuwusœtœ azœ tœ kœza avwala fœ Ndjaba ɓata á li nene. Kashe Ɨshirɨ dœ tœ ye œ za avwala mbœrœ azœ fœ Ndjaba dœ mara á uzu œ li kœza œtœnœ nene. ");
INSERT INTO mnh_vpl VALUES ("RM8_27","075_8_27","ROM","8","27","27","Yé Ndjaba á tshe wusœ lɔsu azœ dœ azu kɔ, tshe wusœ œneke á Ɨshirɨ yindœ kœyu she tœnœ ye. Gbambanœ nene, Ɨshirɨ sœ kœza avwala nœ ye mbœrœ ayerœ azu liaka gbetshelœ nœ Ndjaba. ");
INSERT INTO mnh_vpl VALUES ("RM8_28","075_8_28","ROM","8","28","28","A wusœ nœ adœke Ndjaba mbœrœ adœke œrœ kɔ sœ dœ ɔtshɔnœ mbœrœ azu á endje yindœ ye, á tshe e endje liaka œneke á tshe guma lima utshunœ. ");
INSERT INTO mnh_vpl VALUES ("RM8_29","075_8_29","ROM","8","29","29","Gbambanœ nene, Ndjaba ke endje utshunœ, á wa adœke endje li dœ ɨshirɨ Gbolo nœ ye á tshe kœdœ eya nœ aaya ndjoro. ");
INSERT INTO mnh_vpl VALUES ("RM8_30","075_8_30","ROM","8","30","30","Azunœ á Ndjaba wa o'o mbœrœ endje utshunœ asœmœ, tshe e ndje endje; endjeneke á tshe e endje, tshe mbœrœ adœke endje wuta ndjii yé endjeneke á tshe mbœrœ adœke endje wuta ndjii, tshe mbœrœ adœke endje sœ lœ mokɔ nœ ye. ");
INSERT INTO mnh_vpl VALUES ("RM8_31","075_8_31","ROM","8","31","31","Ataa, a kpa pa koto o? Œdœ Ndjaba kœsœ mbœrœ azœ, œɗe dá yiangba azœ a? ");
INSERT INTO mnh_vpl VALUES ("RM8_32","075_8_32","ROM","8","32","32","Ndjaba vwavwara lima tœ ye tœ kœza Gbolo nœ ye tshebale fœ azœ nene, kashe tshe za lima she mbœrœ azœ para kɔkɔ. Ɓata á tshe za Gbolo nœ ye tshebale fœ azœ, œrœ gaɗe dá tshe kpa duru azœ tœnœ a? ");
INSERT INTO mnh_vpl VALUES ("RM8_33","075_8_33","ROM","8","33","33","Œɗe dá tɔ meza pa azu á Ndjaba ke endje a? Uzu bale nene. Gbambanœ nene, Ndjaba mbœrœ adœke endje wuta ndjii. ");
INSERT INTO mnh_vpl VALUES ("RM8_34","075_8_34","ROM","8","34","34","Œɗe dá wa ɔgbɔ ngbanga pa endje a? Uzu bale nene! Gbambanœ nene, Yisu Kristu tshu œ she lœ kuzu yé œ sœ ga tœ kuni Ndjaba; á sœ kœza avwala tœ upu nœ azœ. ");
INSERT INTO mnh_vpl VALUES ("RM8_35","075_8_35","ROM","8","35","35","Œɗe dá li kœkurutshelœ azœ dœ kœyindœsho nœ Kristu a? Œdœ œrœ kanga, œdœ awa, œdœ kœwu œrœ kanga, œdœ ogo, œdœ oyo œrœ tshapashɔ, œdœ œrœ á yindœ kœndɨ soro œdœ pe ugu kamba a? Œrœ bale nene! ");
INSERT INTO mnh_vpl VALUES ("RM8_36","075_8_36","ROM","8","36","36","Gbambanœ nene, endje sú adœke: «Ɔlɔ dœ ɔlɔ endje para awa nœ kœwo 'a lœ kumu zœ; endje wu 'a ɓata apata á endje na kœwo endje.» ");
INSERT INTO mnh_vpl VALUES ("RM8_37","075_8_37","ROM","8","37","37","Kashe lœ œrœnœ kɔ asœke, a wuta kœropa nœ kolœ dœ gbɔgbɔ nœ Ndjaba á tshe yi ndœ azœ. ");
INSERT INTO mnh_vpl VALUES ("RM8_38","075_8_38","ROM","8","38","38","Gbambanœ nene, mœ wu adja sœ nœ adœke: œdœ kuzu œdœ ndje soro, œdœ aandjelu œdœ ndje ekpe ɨshirɨ, œdœ kpesheke œdœ ɓa mbatsha, œdœ gbɔgbɔ, ");
INSERT INTO mnh_vpl VALUES ("RM8_39","075_8_39","ROM","8","39","39","œdœ gbɔgbɔ ɓa lafo, œdœ ndje ɓa budu ɔshɔ, œdœ anga œrœ á Ndjaba mbœrœ, œrœ bale nene œ li kœkurutshelœ azœ dœ kœyindœsho nœ Ndjaba, á matœ ye lœ Gbozu nœ azœ dœ Yisu Kristu gugu nene. ");
INSERT INTO mnh_vpl VALUES ("RM9_1","075_9_1","ROM","9","1","1","Œneke á mœ sœ kœpa fœ 'e kœdœ adja o'o. Gbambanœ nene, mœ kœdœ uzu nœ Kristu; mœ sœsœ kœpa wala nene, gbetshelœ nœ mœ sœ kœpa tœ upu nœ mœ lœ awa nœ Ɔtshɔ Ɨshirɨ. ");
INSERT INTO mnh_vpl VALUES ("RM9_2","075_9_2","ROM","9","2","2","Lɔsu mœ su dœ egerœ oyo yé œ sœ kœka mœ ɔlɔ dœ ɔlɔ. ");
INSERT INTO mnh_vpl VALUES ("RM9_3","075_9_3","ROM","9","3","3","Mœ sœ má kœyindœ nœ adœke Ndjaba darandœ mœ yé œ kurutshelœ mœ dœ Kristu lœ kumu aaya mœ dœ Ayuda á endje zu mœ dœ endje lœ mara bale. ");
INSERT INTO mnh_vpl VALUES ("RM9_4","075_9_4","ROM","9","4","4","Endje kœdœ azu Israyele, á Ndjaba ke lima endje adœke endje dœ agbolo nœ œne á yi lima sœ mokɔ nœ ye fœ endje. Tshe guma lima ayo dœ endje, œ za lima awa akwa nœ ye fœ endje yé œ yi lima sœ mara á endje li kœdonga dœ she fœ endje. Tshe pa lima tœ œrœ fœ endje. ");
INSERT INTO mnh_vpl VALUES ("RM9_5","075_9_5","ROM","9","5","5","Endje kœdœ aata azœ. Kristu wuta uzu yé endje zu she lœ mara nœ endje. Tshe ropa œrœ kɔ. Œshe kœdœ Ndjaba á endje donga she waa dœ waa. Ame! ");
INSERT INTO mnh_vpl VALUES ("RM9_6","075_9_6","ROM","9","6","6","Andaa, o'o á Ndjaba katœ nœ lima fœ endje sœsœ gbambanœ nene. Kashe œ dœ́dœ́ azu Israyele para kɔkɔ dá dœ azu Israyele nene. ");
INSERT INTO mnh_vpl VALUES ("RM9_7","075_9_7","ROM","9","7","7","Ugurutœ aata Abrayamo kɔ, anga endje dœ́dœ́ agbolo nœ ye nene. Mbœrœ tœnœ dá Ndjaba pa liya adœke: «Agbolo á mœ pa tœ endje fœ ɓœ, endje to lœ Izaka.» ");
INSERT INTO mnh_vpl VALUES ("RM9_8","075_9_8","ROM","9","8","8","Œ má adœke: œ dœ́dœ́ agbolo nœ ɔkɔ dá dœ agbolo nœ Ndjaba nene. Kashe kotœ agbolo á Abrayamo zu lima endje liaka o'o á Ndjaba pa tœnœ dá dœ adja agbolo nœ ye. ");
INSERT INTO mnh_vpl VALUES ("RM9_9","075_9_9","ROM","9","9","9","Ndjaba ka lima tœ o'o fœ Abrayamo adœke: «Ngbugu manda nœ, mœ kwa bala tœ mœ ga ndœ zœ kolœ dœ olonœ asœke, yé awo zœ dœ Sara œ zu gbolo yakoshe.» ");
INSERT INTO mnh_vpl VALUES ("RM9_10","075_9_10","ROM","9","10","10","Œ dœ́dœ́ kolœ asœmœ nene, kashe Rebeka gbɔ ndje lima nguzu ameya á aba endje bale kœdœ ata azœ dœ Izaka. ");
INSERT INTO mnh_vpl VALUES ("RM9_11","075_9_11","ROM","9","11","12","Andaa, utshu kœzu endje, damba endje wuwu lima sœ tshelœ kata ekperœ dœ ɔtshɔrœ nene, Ndjaba pa lima fœ Rebeka adœke: «Ɔgbɔ gbolonœ œ dœ kanga nœ ɨngɨnœ.» Tshe pa lima atamœ mbœrœ kœma adœke œne ke liaka gbetshelœ nœ œne. Tshe para kolœ endjeneke á tshe e endje, tshe wuwu akwa nœ endje nene. ");
INSERT INTO mnh_vpl VALUES ("RM9_13","075_9_13","ROM","9","13","13","Endje su ɓala Buku nœ Ndjaba adœke: «Mœ yindœ Yakobo yé mœ yiangba Esawu.» ");
INSERT INTO mnh_vpl VALUES ("RM9_14","075_9_14","ROM","9","14","14","Ataa a kpa pa koto o? Ndjaba sœsœ ndjii nene a? Bale nene! ");
INSERT INTO mnh_vpl VALUES ("RM9_15","075_9_15","ROM","9","15","15","Ndjaba pa lima fœ Moyize adœke: «Mœ wu oyo uzu á mœ yindœ kœwu oyo ye, yé mœ má ɔtshɔ lɔsu ga tœ uzu á mœ yindœ kœma ɔtshɔ lɔsu ga tœ ye.» ");
INSERT INTO mnh_vpl VALUES ("RM9_16","075_9_16","ROM","9","16","16","Œ yindœ kœpa adœke ɔtshɔ lɔsu nœ Ndjaba sœsœ mbœrœ œneke á azu yindœ nœ too ndje mbœrœ gbɔgbɔ nœ azu nene, kashe œ sœ kolœ mbœrœ á tshe wu oyo uzu dœ tœ ye. ");
INSERT INTO mnh_vpl VALUES ("RM9_17","075_9_17","ROM","9","17","17","Endje su lima adœke Ndjaba pa fœ gbozugo Ezipito adœke: «Mœ za ɓœ tɔ ɓata gbozu mbœrœ kœma gbɔgbɔ nœ mœ á azu tshapashɔ djigi kœwu mokɔ nœ mœ.» ");
INSERT INTO mnh_vpl VALUES ("RM9_18","075_9_18","ROM","9","18","18","Œtœnœ ataa dá Ndjaba kœyindœ nœ yekane á tshe wu oyo uzu; yé tshe kœyi ndje ndœ nœ, tshe mbœrœ adœke uzu sœ dœ gbɔkumu. ");
INSERT INTO mnh_vpl VALUES ("RM9_19","075_9_19","ROM","9","19","19","Anganœ uzu œ yu mœ adœke: «Œ kœsœ ataa, œ mbœrœ kotoo á Ndjaba œ gbagbara azœ dœ azu a? Ka œɗe dá li kœvwaratœ ye tœ œrœ á tshe yindœ kœmbœrœ tœnœ a?» ");
INSERT INTO mnh_vpl VALUES ("RM9_20","075_9_20","ROM","9","20","20","Kashe ɓœ kœdœ œɗe yekane á vwaratœ zœ tœ upu nœ Ndjaba a? Œɗe dá wu ɓalima lɔsú kœyu uzu á tshe mbœrœ she adœke: «Mbœrœ gaɗe á ɓœ mbœrœ mœ atake a?» ");
INSERT INTO mnh_vpl VALUES ("RM9_21","075_9_21","ROM","9","21","21","Ayi kœmbœrœ lɔsú lili kœmbœrœ œneke á tshe yindœ nœ dœ óto nœ ye nene a? Tshe li kœa ótó: œ mbœrœ anganœ dœ ɔgbɔ lɔsú yé œ mbœrœ ndje anganœ dœ amba lɔsú. Œ sœsœ ataa nene a? ");
INSERT INTO mnh_vpl VALUES ("RM9_22","075_9_22","ROM","9","22","22","A wusœ nœ adœke Ndjaba yi lima ndœ kœma ókó nœ ye œdœ pe gbɔgbɔ nœ ye. Kashe tshe sœ lima dœ ugu lɔsu mbœrœ azu á li lima adœke endje gbɔ djofele, á endje li lima dœ kuzu. ");
INSERT INTO mnh_vpl VALUES ("RM9_23","075_9_23","ROM","9","23","23","Tshe mbœrœ ataa, mbœrœ kœyisœ egerœ mokɔ nœ ye ga ndœ azu á tshe wu oyo endje yé á ke endje lima utshunœ á guma endje kœli ga lœ mokɔ nœ ye. ");
INSERT INTO mnh_vpl VALUES ("RM9_24","075_9_24","ROM","9","24","24","Azœ kœdœ azunœ á tshe e endje asœmœ, azœ á tshe e azœ ko ugurutœ Ayuda nene kashe ugurutœ angbɨ azu ndje. ");
INSERT INTO mnh_vpl VALUES ("RM9_25","075_9_25","ROM","9","25","25","Tœnœ kœdœ o'o ama Ndjaba á Oze su lima adœke: «Azu ogo á endje dœ́dœ́ azu nœ mœ nene, mœ e endje bala azu nœ mœ; yé angbɨ azu á mœ yiyi lima ndœ endje nene, mœ yindœ endje waa. ");
INSERT INTO mnh_vpl VALUES ("RM9_26","075_9_26","ROM","9","26","26","Ɓa tœ osho á endje pa lima fœ endje adœke: “'E dœ́dœ́ azu nœ mœ nene”, ɓa zœ asœmœ, endje e endje agbolo nœ Ndjaba nœ soro.» ");
INSERT INTO mnh_vpl VALUES ("RM9_27","075_9_27","ROM","9","27","27","Isaya gbara ndje lima atake tœ upu nœ azu Israyele: «Œdœ azu Israyele kœngba ndje ɓata mindu tshatœ ama kota gbaa, kolœ udu endje teasho dá she. ");
INSERT INTO mnh_vpl VALUES ("RM9_28","075_9_28","ROM","9","28","28","Gbambanœ nene, œneke á Ndjaba pa tœnœ, tshe mbœrœ adœke œ mbœrœtœ endje djigi œdœ gbara pa ɔshɔ.» ");
INSERT INTO mnh_vpl VALUES ("RM9_29","075_9_29","ROM","9","29","29","Kolœ Isaya kpa pa ndje lima utshunœ adœke: «Œdœ Gbozu nœ gbɔgbɔ kɔ kœkaka lima tœ anga aata azœ tɨ fœ azœ nene, dá a wuta má ndje ɓata azu ongbo Sodomo, a liili má ɓata azu ongbo Gomora.» ");
INSERT INTO mnh_vpl VALUES ("RM9_30","075_9_30","ROM","9","30","30","Atamœ a kpa pa kotoo? A pa adœke: azu neke á endje dœ́dœ́ Ayuda nene yé á papara awa adœke œne wuta ndjii tœ ala Ndjaba nene, Ndjaba mbœrœ adœke endje wuta ndjii tœ ala œne mbœrœ kœyindœrœ. ");
INSERT INTO mnh_vpl VALUES ("RM9_31","075_9_31","ROM","9","31","31","Andaa, azu Israyele para lima awa adœke œne wuta ndjii tœ ala Ndjaba lœ awa nœ kœmbœrœtœ endje liaka awa akwa kashe endje wuwuta lima ndjii nene. ");
INSERT INTO mnh_vpl VALUES ("RM9_32","075_9_32","ROM","9","32","32","Mbœrœ gaɗe e? Ádánœ kœdœ adœke endje gbegbe lima kœsœ dœ kœyindœrœ nene kashe endje za lima lɔsu endje ga pa akwa nœ endje. Endje za ada endje tɔ badja á sœ kœko endje vesho. ");
INSERT INTO mnh_vpl VALUES ("RM9_33","075_9_33","ROM","9","33","33","Endje su ala Buku nœ Ndjaba adœke: «'E dji, mœ za badja tɔ ɓa lakpɨ Siyona, œtœnœ kœdœ badja á azu œ ko ada endje tɔ tœnœ á ko endje vesho. Kashe uzu á tshe kœsœ dœ kœyindœrœ ga ndœ ye, tshe gbɔ tshula nene.» ");
INSERT INTO mnh_vpl VALUES ("RM10_1","075_10_1","ROM","10","1","1","Aaya, œrœ á mœ yindœ nœ dœ lɔsu mœ bale, yé á sœ kœza avwala nœ mœ fœ Ndjaba tœnœ kœdœ adœke tshe she Ayuda. ");
INSERT INTO mnh_vpl VALUES ("RM10_2","075_10_2","ROM","10","2","2","Gbambanœ nene, mœ wusœ nœ adœke endje sœ dœ egerœ ogo kœmbœrœ akwa nœ Ndjaba kashe endje wuwusœ awa kœmbœrœ tœnœ dœ ɔtshɔnœ nene. ");
INSERT INTO mnh_vpl VALUES ("RM10_3","075_10_3","ROM","10","3","3","Endje wuwusœ mara á Ndjaba mbœrœ adœke uzu wuta ndjii tœ ala ye nene. Endje para kœwuta ndjii dœ awa nœ endje dœ tœ endje. Mbœrœ tœnœ atamœ, endje zazatœ endje fœ Ndjaba yeka á tshe kœmbœrœ adœke endje wuta ndjii nene. ");
INSERT INTO mnh_vpl VALUES ("RM10_4","075_10_4","ROM","10","4","4","Gbambanœ nene, Kristu mbœrœ œneke kɔ á li má adœke awa akwa mbœrœ yekane á endjeneke kɔ á endje sœ dœ kœyindœrœ ga ndœ ye kœwuta ndjii tœ ala Ndjaba. ");
INSERT INTO mnh_vpl VALUES ("RM10_5","075_10_5","ROM","10","5","5","'E dji o'o á Moyize sú tœ upu nœ kœsœ ndjii á to lœ awa akwa: uzu kœro manda awa akwa, œ sœ dœ soro lœ awa nœ awa akwa. ");
INSERT INTO mnh_vpl VALUES ("RM10_6","075_10_6","ROM","10","6","6","Kashe tœ kœwuta ndjii dœ awa nœ kœyindœrœ, tshe pa lima adœke: «Yuyutœ zœ nene adœke: œɗe dá ɔ ga lafo a?» Œ sœ ɓata kœza Yisu jerœ tœnœ ga atɨ. ");
INSERT INTO mnh_vpl VALUES ("RM10_7","075_10_7","ROM","10","7","7","'E yuyu ndje tœ 'e nene adœke: «Œɗe dá jerœ ga lœ ogo nœ akuzu a?» Œ sœ ɓata 'e kpa yindœ kœmbœrœ adœke Yisu kpa she lœ akuzu. ");
INSERT INTO mnh_vpl VALUES ("RM10_8","075_10_8","ROM","10","8","8","Kashe Moyize pa lima kotoo? Tshe pa lima atake: «O'o ama Ndjaba sœ ndoo dœ ɓœ, œ sœ lœ ama zœ; œ sœ ndje tœ lɔsu zœ.» O'onœ asœmœ kœdœ o'o nœ kœyindœrœ á a sœ kœmɨndœ nœ. ");
INSERT INTO mnh_vpl VALUES ("RM10_9","075_10_9","ROM","10","9","9","Œdœ ɓœ kœpa dœ ama zœ adœke Yisu kœdœ Gbozu, á yindœ nœ dœ lɔsu zœ adœke Ndjaba she she lœ akuzu ye, ɓœ she bala ye. ");
INSERT INTO mnh_vpl VALUES ("RM10_10","075_10_10","ROM","10","10","10","Mbœrœ kœyindœ nœ dœ lɔsu zœ dá Ndjaba œ mbœrœ adœke ɓœ sœ ndjii, yé ɓœ kœpandœ nœ dœ ama zœ dá Ndjaba œ she ɓœ. ");
INSERT INTO mnh_vpl VALUES ("RM10_11","075_10_11","ROM","10","11","11","Gbambanœ nene, endje sú ɓala Bukunœ adœke: «Uzu kɔ á tshe sœ dœ kœyindœrœ ga ndœ Yisu, tshe gbɔ tshula nene.» ");
INSERT INTO mnh_vpl VALUES ("RM10_12","075_10_12","ROM","10","12","12","Ádánœ á Ayuda dœ angbɨ azu sœsœ kpi nene. Gbozu nœ endje kœdœ Yisu Kristu á tshe to ɔtshɔrœ nœ ye fœ azu para kɔkɔ á endje e ɨ'ɨrɨ ye. ");
INSERT INTO mnh_vpl VALUES ("RM10_13","075_10_13","ROM","10","13","13","Mbœrœ á endje sú ɓala Buku nœ Ndjaba adœke: «Uzu kɔ á tshe e ɨ'ɨrɨ Gbozu, tshe she.» ");
INSERT INTO mnh_vpl VALUES ("RM10_14","075_10_14","ROM","10","14","14","Kashe endje e ɨ'ɨrɨ ye kotoo œdœ endje kœsœ dœ kœyindœrœ ga ndœ ye nene a? Yé endje sœ dœ kœyindœrœ ga ndœ ye kotoo œdœ endje kœdjidji damba o'o nœ ye nene a? Endje dji o'o nœ ye kotoo œdœ a kœmɨmɨndœ nœ nene a? ");
INSERT INTO mnh_vpl VALUES ("RM10_15","075_10_15","ROM","10","15","15","Endje mɨndœ o'onœ kotoo œdœ endje kœvwavwa azu nene a? Endje su ɓala Buku nœ Ndjaba adœke: «Yanga waa kœwu azu á endje na dœ Ɔtshɔ O'o fœ azu.» ");
INSERT INTO mnh_vpl VALUES ("RM10_16","075_10_16","ROM","10","16","16","Kashe azu para kɔkɔ dá yindœ Ɔtshɔ O'onœ nene. Isaya pa lima tœ upunœ adœke: «Gbozu, œɗe dá yindœ o'onœ á 'a sœ kœmɨndœ nœ a?» ");
INSERT INTO mnh_vpl VALUES ("RM10_17","075_10_17","ROM","10","17","17","Ataa, kœyindœrœ to lœ kœmɨndœ o'o ama Ndjaba yé kœmɨndœ o'o ama Ndjaba kœdœ kœmɨndœ Ɔtshɔ O'o nœ Kristu. ");
INSERT INTO mnh_vpl VALUES ("RM10_18","075_10_18","ROM","10","18","18","Mœ sœ kœyu adœke: ataa azu Israyele djidji lima o'onœ asœke nene a? Adjapu, endje dji lima kɔ. Mbœrœ Buku nœ Ndjaba pa adœke: «Endje dji tshama endje na tœnœ pa ɔshɔ djigi, yé o'o ama endje œ na rotœnœ tœ osho kɔ pa ɔshɔnœ asœke.» ");
INSERT INTO mnh_vpl VALUES ("RM10_19","075_10_19","ROM","10","19","19","Mœ sœ kpa kœyu adœke: Ataa azu Israyele djidji lima dœ ɔtshɔnœ nene a? Ndjaba pa lima ndœ nœ lœ ama Moyize adœke: «Mœ mbœrœ adœke 'e sœ dœ úkú ga tœ azu á endje dœ́dœ́ azu nœ mœ nene. Mœ mbœrœ adœke 'e sœ dœ ókó ga tœ angbɨ azu á endje gugu dœ kœwusœrœ nene.» ");
INSERT INTO mnh_vpl VALUES ("RM10_20","075_10_20","ROM","10","20","20","Isaya kpa na œrrr kœpa adœke: «Azu á endje sœsœ lima kœpara mœ nene, gbɔ mœ, mœ matœ mœ fœ azu neke á endje sœsœ lima kœyu mœ tœ œrœ nene.» ");
INSERT INTO mnh_vpl VALUES ("RM10_21","075_10_21","ROM","10","21","21","Yé mbœrœ azu Israyele, tshe pa lima adœke: «Ɔlɔ kɔ, mœ yi lima kane mœ mbœrœ kœ'e endje kashe endje djidji lima o'o ama mœ nene. Endje kœdœ aayi gbɔkumu œdœ adjipudji.» ");
INSERT INTO mnh_vpl VALUES ("RM11_1","075_11_1","ROM","11","1","1","Mœ sœ kœyutœ mœ adœke: Adja Ndjaba vwaratœ ye tœ azu nœ ye ye a? Bale nene! Gbambanœ nene, œmœ ndje kœdœ uzu Israyele, ata Abrayamo lœ mara nœ Abendjame. ");
INSERT INTO mnh_vpl VALUES ("RM11_2","075_11_2","ROM","11","2","2","Ndjaba vwavwaratœ ye tœ azu nœ ye á tshe ke lima endje katshatsha nene. 'E wuwusœ o'o á Eliya pa lima ala Buku nœ Ndjaba ɔlɔ á tshe sœ kœkɨ oyo tœ upu nœ azu Israyele fœ Ndjaba nene a? ");
INSERT INTO mnh_vpl VALUES ("RM11_3","075_11_3","ROM","11","3","3","Tshe kɨ lima adœke: «Gbozu, endje wo aayi kœgbara o'o nœ zœ, œ kavwa wopa nœ zœ. Mœ sœpe dœ kutɨ mœ tshebale yé endje kpa sœ kœpara awa ndœ kœwo mœ.» ");
INSERT INTO mnh_vpl VALUES ("RM11_4","075_11_4","ROM","11","4","4","Kashe Ndjaba gi lima o'o gaɗe fœ she a? Tshe gi lima fœ she adœke: «Mœ gumasœ azu kutu mindu dœ bisha á endje kukuku ga utshu ndjaba Bala nene.» ");
INSERT INTO mnh_vpl VALUES ("RM11_5","075_11_5","ROM","11","5","5","Awa bale ndje ngɔngɔ asœke, anga udu azu á Ndjaba ke endje liaka ɔtshɔ lɔsu nœ ye sœpe zœ. ");
INSERT INTO mnh_vpl VALUES ("RM11_6","075_11_6","ROM","11","6","6","Tshe keke lima endje mbœrœ akwa nœ endje nene, kashe kolœ mbœrœ ɔtshɔ lɔsu nœ ye. Ete nene, ɔtshɔ lɔsu nœ Ndjaba kpa dœ ɔtshɔ lɔsu nene. ");
INSERT INTO mnh_vpl VALUES ("RM11_7","075_11_7","ROM","11","7","7","Atamœ a kpa pa kotoo? Azu Israyele gbɔgbɔ œrœ á endje sœ lima kœpara tœnœ nene, kolœ endjeneke á Ndjaba ke endje dá gbɔ. Anga endje wuta lima dœ gbɔkumu, ");
INSERT INTO mnh_vpl VALUES ("RM11_8","075_11_8","ROM","11","8","8","ɓata á endje sú ala Bukunœ adœke: «Ndjaba mbœrœ adœke kœwusœrœ nœ endje papara awa kœwusœ ádá o'o nene. Tshe pakata ala endje kœwu œrœ œdœ utu endje kœdji o'o œrrr ngɔngɔ asœke.» ");
INSERT INTO mnh_vpl VALUES ("RM11_9","075_11_9","ROM","11","9","9","Davidi pa ndje adœke: «Kaka kœzɨrœ nœ endje fa úkú œdœ gbanda, œ kɔrɔ awa kœyo endje dœ́ endje gbɔ œneke á li dœ endje, ");
INSERT INTO mnh_vpl VALUES ("RM11_10","075_11_10","ROM","11","10","10","Kaka adœke endje kpa wuwu œrœ nene œrrr ala endje bu, mbœrœ adja adœke ovoro endje lu ga tœnœ.» ");
INSERT INTO mnh_vpl VALUES ("RM11_11","075_11_11","ROM","11","11","11","Mœ kpa sœ kœyutœ mœ adœke: «Lɔkɔ á Ayuda ko lima ada endje tɔsho, endje yo lima waa ye a?» Bale nene. Kashe ekperœ nœ endje kɔrɔ awa fœ angbɨ azu adœke endje gbɔ kœshe, á kœvwa Ayuda kœmbœrœ úkú. ");
INSERT INTO mnh_vpl VALUES ("RM11_12","075_11_12","ROM","11","12","12","Andaa, œdœ ekperœ nœ Ayuda kœza kœgbɔrœ fœ tshapashɔ, á kœyo endje kœza kœgbɔrœ fœ angbɨ azu, ataa ɔtshɔrœ kpa ropa nœ ɔlɔ á endje kpa kwatœ endje kɔ ga pa awa kœshe. ");
INSERT INTO mnh_vpl VALUES ("RM11_13","075_11_13","ROM","11","13","13","Mœ sœ kœpa fœ e'e dœ́ azu á 'e dœ́dœ́ Ayuda nene: œmœ kœdœ ayi avwa á Ndjaba ke mœ mbœrœ angbɨ azu yé mbœrœ tœnœ ataa, mœ sœ dœ yanga mbœrœ akwa á mœ mbœrœ asœke waa. ");
INSERT INTO mnh_vpl VALUES ("RM11_14","075_11_14","ROM","11","14","14","Mœ gbe kœmbœrœ ataa adœke aaya mœ wuta dœ úkú yeka anga endje kœshe. ");
INSERT INTO mnh_vpl VALUES ("RM11_15","075_11_15","ROM","11","15","15","Gbambanœ nene, ɔlɔ á Ndjaba vwara lima tœ ye tœ Ayuda, tshe guma lima tshaguru tœ ye dœ tshapashɔ. Atamœ ɔlɔ á tshe kpa kœguma tshagurutœ ye dœ endje, œ sœ ɓata uzu to lœ kuzu á kwa ga lœ soro nene a? ");
INSERT INTO mnh_vpl VALUES ("RM11_16","075_11_16","ROM","11","16","16","Œdœ uzu kœza ali kumu œrœ kɨndɨ nœ ye fœ Ndjaba, udu œrœnœ kɔ kœdœ œnœ Ndjaba. Œdœ uzu kœza ndje eshe ɔyɔ fœ Ndjaba, ganeanœ ndje kœdœ œnœ ye. ");
INSERT INTO mnh_vpl VALUES ("RM11_17","075_11_17","ROM","11","17","17","Azu Israyele sœ ɓata ɔyɔ olive á Ndjaba de anga ganeanœ tœnœ yé tœ œsœ ganeanœ asœmœ, tshe za ɓœ tɔrɔ ga zœ œɓœ dœ́ angbɨ uzu ɓata ganea olive tshelœ gusu. Ɓœ sœ ndje kœgbɔ kœzɨrœ á sœ kœto lœ eshe ɔyɔ olive á sœ kœɔ tœnœ. ");
INSERT INTO mnh_vpl VALUES ("RM11_18","075_11_18","ROM","11","18","18","Ádánœ á lili adœke ɓœ sœ dœ egerœ kumu nene utshu ganea á endje de. Kotoo á ɓœ tɨ kanga zœ a? Œ dœ́dœ́ ɓœ dá sœ kœza eshe ɔyɔ nene kashe eshe ɔyɔ dá sœ kœza ɓœ. ");
INSERT INTO mnh_vpl VALUES ("RM11_19","075_11_19","ROM","11","19","19","Anganœ ɓœ sœ kœpa ndje adœke: «Endje de lima ganea ɔyɔ asœke yeka á mœ kœgbɔ osho kœsœ tœnœ.» ");
INSERT INTO mnh_vpl VALUES ("RM11_20","075_11_20","ROM","11","20","20","Adjapu. Endje de ganeanœ asœmœ mbœrœ á endje gugu lima dœ kœyindœrœ nene yeka á ɓœ gbɔ osho tshangbanœ mbœrœ kœyindœrœ. Kashe dudu okoro zœ nene, yé ala zœ gbɔ kane. ");
INSERT INTO mnh_vpl VALUES ("RM11_21","075_11_21","ROM","11","21","21","Gbambanœ nene, œdœ Ndjaba kœde Ayuda á endje kœdœ adja ganea ɔyɔ, ala zœ gbɔ anganœ tshe de ndje ɓœ awa bale. ");
INSERT INTO mnh_vpl VALUES ("RM11_22","075_11_22","ROM","11","22","22","'E wu mara á Ndjaba sœ kœma ɔtshɔ lɔsu nœ ye œdœ kœza djofele nœ ye kane: tshe za djofele fœ azu á endje yo yé œ má ɔtshɔ lɔsu ga ndœ zœ. Mbœrœ adœke œndœ zœ dɨ lœ ɔtshɔ lɔsunœ asœmœ ete nene, endje de ndje ɓœ ye. ");
INSERT INTO mnh_vpl VALUES ("RM11_23","075_11_23","ROM","11","23","23","Kashe lɔkɔ á Ayuda kpa kœfatshalɔsu endje, endje kwa ga tœ osho á endje sœ lima tœnœ utshunœ. Gbambanœ nene, Ndjaba sœ dœ gbɔgbɔ kœgi endje ga tœ ɔyɔ ga manda œsœ endje. ");
INSERT INTO mnh_vpl VALUES ("RM11_24","075_11_24","ROM","11","24","24","Œɓœ dœ́ angbɨ uzu, ɓœ kœdœ ganea tshelœ gusu á ndjaba de ɓœ á za ɓœ tɔrɔ ga tœ ɔyɔ á ɓœ sœsœ lima tœnœ nene. Kashe Ayuda, endje kœdœ adja ganea ɔyɔ olivenœ, Ndjaba li kpa kœgi endje ga manda endje tɔrɔ ga tœ ɔyɔ á endje sœ lima tœnœ. ");
INSERT INTO mnh_vpl VALUES ("RM11_25","075_11_25","ROM","11","25","25","Aaya, mœ yindœ nœ adœke, 'e wusœ o'o nœ Ndjaba á zatœ ye yiwa tœnœ asœke, á 'e kœzazatœ 'e nene adœke 'e kœdœ aayi kœwusœtœ. O'onœ asœke dœke: anga tshakala azu Israyele œ wuta kœdji tshelœ kata o'o asœ nene œrrr adœke angbɨ azu djigi wuta ga tœ kœshe. ");
INSERT INTO mnh_vpl VALUES ("RM11_26","075_11_26","ROM","11","26","26","Yé manda nœ dá Azu Israyele kɔ œ she ɓata á endje sú ala Buku nœ Ndjaba adœke: «Ayi kœvwara azu œ to ɓa lakpɨ Siyona, tshe gi ekperœ tœ aata Yakobo. ");
INSERT INTO mnh_vpl VALUES ("RM11_27","075_11_27","ROM","11","27","27","'E wu ayo á mœ mbœrœ bala dœ endje, lɔkɔ á mœ ɨ ekperœ nœ endje.» ");
INSERT INTO mnh_vpl VALUES ("RM11_28","075_11_28","ROM","11","28","28","Ayuda vwara lima tœ endje tœ Ɔtshɔ O'o yé œ wuta lima ayingba Ndjaba yekane á kɔrɔ awa fœ 'e. Kashe Ndjaba sœ kœyindœ endje waa dœ waa mbœrœ á tshe ke lima aata endje. ");
INSERT INTO mnh_vpl VALUES ("RM11_29","075_11_29","ROM","11","29","29","Gbambanœ nene, Ndjaba kœza œrœ fœ uzu tshe kpa za tshakane ye nene. Tshe kœ'e uzu, tshe kpa fatshelœ ama ye nene. ");
INSERT INTO mnh_vpl VALUES ("RM11_30","075_11_30","ROM","11","30","30","Utshunœ lima 'e sœsœ kœdji Ndjaba nene yé ngɔngɔ asœke Ndjaba wu oyo 'e mbœrœ Ayuda vwaratœ endje tœ kœdji she. ");
INSERT INTO mnh_vpl VALUES ("RM11_31","075_11_31","ROM","11","31","31","Awa bale ngɔngɔ asœke endje vwaratœ endje tœ kœdji o'o adœke Ndjaba kœwu oyo 'e, á manda nœ yekane á tshe kœwu ndje oyo endje. ");
INSERT INTO mnh_vpl VALUES ("RM11_32","075_11_32","ROM","11","32","32","Gbambanœ nene Ndjaba mbœrœ lima adœke azu para kɔkɔ vwara lima tœ endje tœ kœdji o'o ama œne. Tshe mbœrœ lima atamœ adœke œne ma lɔsu kœwu oyo endje para kɔkɔ. ");
INSERT INTO mnh_vpl VALUES ("RM11_33","075_11_33","ROM","11","33","33","Adja Ndjaba gerœ waa. Œsœ kœwusœtœ nœ ye dœ pe kœwusœrœ nœ ye gerœ ndje waa. Uzu bale á tshe wusœ ada kœwa o'o nœ ye gugu, uzu bale á tshe wu ndje sœ œrœ á tshe yindœ kœmbœrœ tœnœ gugu nene. ");
INSERT INTO mnh_vpl VALUES ("RM11_34","075_11_34","ROM","11","34","34","Buku nœ Ndjaba pa adœke: «Œɗe dá wusœ gbetshelœ nœ Ndjaba? Œɗe dá li tœ kœmɨ upu fœ she a? ");
INSERT INTO mnh_vpl VALUES ("RM11_35","075_11_35","ROM","11","35","35","Œɗe dá to œrœ tœ alinœ fœ she, yekane á tshe kœgi tshangbanœ fœ she a?» ");
INSERT INTO mnh_vpl VALUES ("RM11_36","075_11_36","ROM","11","36","36","Gbambanœ nene, œrœ kɔ to ɓa ndœ ye, œrœ kɔ sœ dœ soro lœ awa nœ ye yé œrœ kɔ sœ mbœrœ she. Kaka mokɔ nœ Ndjaba sœ waa dœ waa. Ame! ");
INSERT INTO mnh_vpl VALUES ("RM12_1","075_12_1","ROM","12","1","1","Aaya, ɓata á Ndjaba má ɔtshɔ lɔsu nœ ye fœ azœ, mœ yindœ nœ adœke 'e zatœ 'e fœ she ɓata tokóró nœ soro, á endje gi ga ɨndɨrɨnœ yé á sœ kœza yanga fœ she. Asœke kœdœ adja mara kœdonga Ndjaba á li dœ 'e kœdonga dœ she. ");
INSERT INTO mnh_vpl VALUES ("RM12_2","075_12_2","ROM","12","2","2","'E mbœmbœrœtœ 'e ɓata azu tshapashɔnœ asœke nene kashe 'e za awa fœ Ndjaba kœto tafo kœwusœrœ fœ 'e yeka á 'e kœwusœ œneke á Ndjaba yindœ nœ, œneke á sœ dœ ɔtshɔnœ, œneke á za yanga fœ she, œneke á li. ");
INSERT INTO mnh_vpl VALUES ("RM12_3","075_12_3","ROM","12","3","3","Yé mbœrœ ɔtshɔ lɔsu nœ Ndjaba ga ndœ mœ, mœ sœ kœpa fœ 'e adœke 'e zazatœ 'e ga lafo kœro mara á 'e sœ dœ tœnœ nene. Kashe 'e sœ dœ gbetshelœ neke á li, adœke uzu dœ uzu wutœ ye liaka kœyindœrœ á Ndjaba to fœ she. ");
INSERT INTO mnh_vpl VALUES ("RM12_4","075_12_4","ROM","12","4","4","Gbambanœ nene, undu azœ sœ bale kashe œrœ kotenœ ngba waa. Akwa á œrœ kote undu azœ bale dœ bale œ mbœrœ sœsœ awa bale nene. ");
INSERT INTO mnh_vpl VALUES ("RM12_5","075_12_5","ROM","12","5","5","Awa bale a ngba waa, kashe a wuta undu uzu bale lœ kœngbɔtœ azœ bale dœ Kristu yé uzu dœ uzu kœdœ œrœ kote undunœ. ");
INSERT INTO mnh_vpl VALUES ("RM12_6","075_12_6","ROM","12","6","6","Uzu dœ uzu sœ dœ gbɔgbɔ kœmbœrœ dœ akwa kpikpi dœ mara á Ndjaba to fœ she lœ ɔtshɔ lɔsu nœ ye. Œ kœsœ adœke Ndjaba to gbɔgbɔ nœ kœgbara dœ o'o fœ uzu, œ li adœke tshe gbara lindœ kœyindœrœ. ");
INSERT INTO mnh_vpl VALUES ("RM12_7","075_12_7","ROM","12","7","7","Uzu á tshe kœsœ dœ gbɔgbɔ nœ kœtɨ kane anganœ, kaka adœke tshe tɨ kane anganœ. Yé uzu á tshe kœsœ dœ gbɔgbɔ nœ kœyisœ œrœ, kaka tshe yisœ œrœ. ");
INSERT INTO mnh_vpl VALUES ("RM12_8","075_12_8","ROM","12","8","8","Uzu á tshe kœsœ dœ gbɔgbɔ nœ kœto gbɔgbɔ fœ anganœ, kaka tshe to gbɔgbɔ fœ anganœ. Uzu á tshe kœsœ dœ gbɔgbɔ nœ kœto œrœ, kaka tshe to dœ lɔsu ye bale. Uzu á tshe kœsœ tœ gbozu tshapa anganœ, kaka tshe zatœ ye djigi ndœ nœ. Uzu a tshe kœsœ dœ gbɔgbɔ ndœ kœwu oyo azu, kaka tshe mbœrœ dœ yanga. ");
INSERT INTO mnh_vpl VALUES ("RM12_9","075_12_9","ROM","12","9","9","Œ li adœke 'e yindœ anga 'e dœ adja kœyindœsho. 'E kpa awa ekperœ yé œ zatœ 'e djigi ndœ kœmbœrœ ɔtshɔrœ. ");
INSERT INTO mnh_vpl VALUES ("RM12_10","075_12_10","ROM","12","10","10","'E yindœtœ 'e ugurutœ 'e ɓata aaya azu: 'e lɨsœtœ 'e ugurutœ 'e. ");
INSERT INTO mnh_vpl VALUES ("RM12_11","075_12_11","ROM","12","11","11","'E mbœrœ akwa dœ gbɔgbɔ yé 'e mbœmbœrœ ɔdɔ nene. 'E mbœrœ akwa fœ Gbozu dœ lɔsu 'e bale. ");
INSERT INTO mnh_vpl VALUES ("RM12_12","075_12_12","ROM","12","12","12","'E sœ dœ yanga lœ kœko lɔsu nœ 'e ga tœ Ndjaba. 'E sœ dœ ugu lɔsu lœ oyo yé œ sœ dœ kœru lɔsu lœ avwala. ");
INSERT INTO mnh_vpl VALUES ("RM12_13","075_12_13","ROM","12","13","13","'E tɨ kane ayerœ azu nœ Ndjaba á endje sœ lœ oyo yé œ za osho kœsœ ɔlɔ dœ ɔlɔ fœ agene. ");
INSERT INTO mnh_vpl VALUES ("RM12_14","075_12_14","ROM","12","14","14","'E pa ɔtshɔ o'o ga tœ azu á endje sœ kœmbœrœ œrœ kanga fœ 'e. 'E to kane 'e ga pa endje kashe 'e dadarandœ endje nene. ");
INSERT INTO mnh_vpl VALUES ("RM12_15","075_12_15","ROM","12","15","15","'E sœ dœ yanga awa bale dœ azu á endje sœ dœ yanga, œ kɨ awa bale dœ azu á endje sœ dœ ɨkɨ. ");
INSERT INTO mnh_vpl VALUES ("RM12_16","075_12_16","ROM","12","16","16","'E sœ dœ gbetshelœ bale ugurutœ 'e. 'E kpa awa kœsœ dœ egerœ kumu kashe 'e zatœ 'e ga atɨ. Adja 'e gbegbe nene adœke 'e kœdœ azu nœ kœwusœtœ. ");
INSERT INTO mnh_vpl VALUES ("RM12_17","075_12_17","ROM","12","17","17","Œdœ uzu kœmbœrœ ekperœ fœ 'e, 'e gigi ekperœ fœ she nene kashe 'e para awa kœmbœrœ ɔtshɔrœ utshu azu para kɔkɔ. ");
INSERT INTO mnh_vpl VALUES ("RM12_18","075_12_18","ROM","12","18","18","'E mbœrœ œneke kɔ á li dœ gbɔgbɔ nœ 'e adœke tshagurutœ 'e sœ dœ kœsœ gee. ");
INSERT INTO mnh_vpl VALUES ("RM12_19","075_12_19","ROM","12","19","19","Aaya á mœ yindœ 'e, œdœ azu kœmbœrœ ekperœ fœ 'e, 'e gigi ekperœ dœ tœ 'e nene. Kashe 'e za awa adœke ókó nœ Ndjaba kœmbœrœ akwa. Gbambanœ nene, endje sú ala Buku nœ Ndjaba adœke: «Œmœ dá gi tshangba ekperœ, œmœ ndje dá gi kuɗa tshangba ekperœ kɔ», Ndjaba dá pa ataa. ");
INSERT INTO mnh_vpl VALUES ("RM12_20","075_12_20","ROM","12","20","20","Yé ga pa nœ, endje kpa su ndje adœke: «Œdœ yingba zœ kœsœ dœ ogo, to kœzɨrœ fœ she; œdœ tshe kœsœ dœ ogo ungu, su ungu fœ she; gbambanœ nene, œdœ ɓœ kœsœ kœmbœrœ atamœ, ɓœ sœ kœva jiwo ga pa kumu ye.» ");
INSERT INTO mnh_vpl VALUES ("RM12_21","075_12_21","ROM","12","21","21","Zaza awa fœ ekperœ adœke œ ropa zœ nene kashe ropa ekperœ lœ awa nœ kœmbœrœ ɔtshɔrœ. ");
INSERT INTO mnh_vpl VALUES ("RM13_1","075_13_1","ROM","13","1","1","Œ li adœke uzu kɔ zatœ ye ga tshakudu agbozu nœ Lita mbœrœ akwa tshagbozu kɔ to ɓa ndœ Ndjaba; yé agbozu á a sœ dœ endje, Ndjaba dá ko endje. ");
INSERT INTO mnh_vpl VALUES ("RM13_2","075_13_2","ROM","13","2","2","Atamœ uzu kɔ á tshe kœvwaratœ ye tœ kœzatœ ye ga tshakudu agbozu nœ Lita, tshe vwaratœ ye tœ kœmbœrœtœ ye liaka œneke á Ndjaba guma yé Ndjaba œ wa ɔgbɔ ngbanga ga tœ ye. ");
INSERT INTO mnh_vpl VALUES ("RM13_3","075_13_3","ROM","13","3","3","Gbambanœ nene, azu á endje sœ kœmbœrœ ɔtshɔrœ, endje kpa awa agbozu nœ Lita nene kashe azu neke á endje mbœrœ ekperœ dá kpa awa endje. Œdœ uzu kœyindœ nœ adœke awa agbozu nœ Lita mbœrœ œne nene, œ li adœke tshe mbœrœ ɔtshɔrœ yekane á endje kœlɨsœ ye. ");
INSERT INTO mnh_vpl VALUES ("RM13_4","075_13_4","ROM","13","4","4","Gbambanœ nene, agbozu nœ lita kœdœ aayi akwa nœ Ndjaba mbœrœ kœyisœ kœmbœrœ ɔtshɔrœ fœ azu. Œdœ ɓœ kœmbœrœ ekperœ, œ li adœke awa endje mbœrœ ɓœ, mbœrœ endje gbɔgbɔ akwanœ gbambanœ nene. Lœ kœza djofele fœ azu, endje sœ tœ akwa nœ Ndjaba adœke œne ma ókó nœ ye ga ndœ azu á endje sœ kœmbœrœ ekperœ. ");
INSERT INTO mnh_vpl VALUES ("RM13_5","075_13_5","ROM","13","5","5","Mbœrœ tœnœ ataa, œ li adœke a zatœ azœ ga tshakudu agbozu nœ Lita. 'E kpakpa kolœ awa ókó nœ Ndjaba nene kashe 'e zatœ 'e ga tshakudu agbozu nœ Lita mbœrœ á a wusœ nœ adœke œ li dœ azœ kœmbœrœ atamœ. ");
INSERT INTO mnh_vpl VALUES ("RM13_6","075_13_6","ROM","13","6","6","Œtœnœ kœdœ ndje ádánœ á li dœ 'e adœke 'e yɔ lapo. Ndjaba ko aayi akwa nœ kœko ngendja lapo adœke endje zatœ endje ga tœ akwanœ dœ ɔtshɔnœ. ");
INSERT INTO mnh_vpl VALUES ("RM13_7","075_13_7","ROM","13","7","7","Yé 'e gi kuɗa nœ uzu kɔ fœ she. 'E yɔ lapo á li adœke 'e yɔ, 'e yɔ takeshe á li adœke 'e yɔ, œ kpa awa azu neke á li dœ 'e kœkpa awa endje yé œ lɨsœ endjeneke á li dœ 'e kœlɨsœ endje. ");
INSERT INTO mnh_vpl VALUES ("RM13_8","075_13_8","ROM","13","8","8","'E sœsœ dœ kuɗa nœ uzu bale pa 'e nene. 'E sœ kolœ dœ kuɗa á li dœ 'e kœsœ dœ tœnœ adœke: 'e yindœtœ 'e. Uzu á tshe sœ kœyindœ anganœ sœ kœmbœrœtœ ye liaka awa akwa djigi. ");
INSERT INTO mnh_vpl VALUES ("RM13_9","075_13_9","ROM","13","9","9","Gbambanœ nene, awa o'o pa adœke: «Papara awo yanga zœ nene, wowo uzu nene, zɨzɨ angba nene; zaza lɔsu zœ ga pa œrœ nœ́ yanga zœ nene.» Awa akwanœ asœke œdœ pe udu awa akwa para kɔkɔ li ga lœ awa akwa bale á pa adœke: «Yindœ yanga zœ ɓata á ɓœ yindœtœ zœ dœ tœ zœ.» ");
INSERT INTO mnh_vpl VALUES ("RM13_10","075_13_10","ROM","13","10","10","Uzu á tshe kœyindœ yanganœ, tshe mbœrœ ekperœ fœ she nene, ádánœ á uzu á tshe sœ kœyindœ yanganœ tshe sœ kœmbœrœtœ ye liaka awa akwa djigi. ");
INSERT INTO mnh_vpl VALUES ("RM13_11","075_13_11","ROM","13","11","11","Ɓata 'e wusœ lɔndɔ á a sœ dœ tœnœ, lɔkɔ kœjo 'e lœ olo wuta ye. Kpœsheke kœshe na ndo dœ azœ kœto tœ ɔlɔ á a yi lima ndœ œrœ. ");
INSERT INTO mnh_vpl VALUES ("RM13_12","075_13_12","ROM","13","12","12","Œndœ butshɔ dɨ yé osho ndo kœkɔrɔ tœnœ ye. A katœ akwa nœ ubu osho yé a ko œrœ kœnga dœ koshe nœ ɨngbɨsho. ");
INSERT INTO mnh_vpl VALUES ("RM13_13","075_13_13","ROM","13","13","13","Œ li adœke akwa tshelœ azœ dœ akwa nœ ɨngbɨsho, a katœ egerœ lɔsu, dœ kœndjo ipi tɔpanœ kpuru, dœ angba budu, dœ œrœ tshula, dœ œbœrœ œdœ úkú. ");
INSERT INTO mnh_vpl VALUES ("RM13_14","075_13_14","ROM","13","14","14","Kashe 'a matœ azœ ɓata azu nœ Yisu Kristu, yé 'e papara kœmbœrœ œneke á ogo nœ ɔkɔ 'e œ vwa 'e ndœ kœmbœrœ tœnœ nene. ");
INSERT INTO mnh_vpl VALUES ("RM14_1","075_14_1","ROM","14","1","1","'E za osho kœsœ fœ uzu á kœyindœrœ nœ ye sœ teasho, kashe 'e wawa ngbanga pa gbetshelœ nœ ye nene. ");
INSERT INTO mnh_vpl VALUES ("RM14_2","075_14_2","ROM","14","2","2","Anga uzu sœ dœ kœyindœrœ adœke œne li kœzɨ œrœ kɔ, andaa anga á kœyindœrœ sœ teasho, sœ kœzɨ kolœ dɔngɔ. ");
INSERT INTO mnh_vpl VALUES ("RM14_3","075_14_3","ROM","14","3","3","Atamœ uzu á tshe sœ kœzɨ œrœ tshetshene tsheneke á tshe zɨzɨ nene, yé tsheneke á tshe zɨzɨ nene wawa o'o ga tœ tsheneke á tshe sœ kœzɨ tœnœ nene. Gbambanœ nene, Ndjaba za osho kœsœ fœ she ndje. ");
INSERT INTO mnh_vpl VALUES ("RM14_4","075_14_4","ROM","14","4","4","Œɓœ kœdœ ɗe á kœwa ngbanga pa ayi akwa á tshe dœ́dœ́ tshenœ zœ nene a? Œdœ tshe kœmbœrœ akwa nœ ye dœ ɔtshɔnœ œdœ tshe mbœmbœrœ dœ ɔtshɔnœ nene, œ dœ́ o'o nœ ayengɔ ye. Tshe shi gbɨ; gbambanœ nene, Gbozu sœ dœ gbɔgbɔ kœtɨ kane ye. ");
INSERT INTO mnh_vpl VALUES ("RM14_5","075_14_5","ROM","14","5","5","Tœ upu nœ anga bale, olo sœ kpikpikpi, andaa tœ anga olo kɔ liili. Kaka uzu dœ uzu wusœ nœ ɓa lɔsu ye dœ tœ ye adœke œneke á œne gbe kœdœ adjapu. ");
INSERT INTO mnh_vpl VALUES ("RM14_6","075_14_6","ROM","14","6","6","Uzu á tshe kœgbe adœke anga olo bale ropa udu olo kɔ, sœ kœmbœrœ tœnœ mbœrœ kœlɨsœ Gbozu; uzu á tshe sœ kœzɨ œrœ kɔ, sœ ndje kœmbœrœ tœnœ mbœrœ kœlɨsœ Gbozu; gbambanœ nene, tshe sœ kœza mershe fœ Ndjaba mbœrœ kœzɨrœ nœ ye. Tsheneke á tshe zɨzɨ œrœ nene sœ kœmbœrœ tœnœ mbœrœ kœlɨsœ Gbozu yé œ sœ ndje kœza mershe fœ Ndjaba. ");
INSERT INTO mnh_vpl VALUES ("RM14_7","075_14_7","ROM","14","7","7","Uzu bale ugurutœ azœ á tshe sœ dœ soro mbœrœ tœ ye dœ tœ ye gugu nene yé uzu bale á tshe tshu mbœrœ tœ ye dœ tœ ye gugu nene. ");
INSERT INTO mnh_vpl VALUES ("RM14_8","075_14_8","ROM","14","8","8","Œdœ a kœsœ dœ soro, a sœ dœ tœnœ mbœrœ Gbozu, yé œdœ á kœtshu, a tshu mbœrœ Gbozu. Atamœ œdœ a kœsœ dœ soro, œdœ á kœtshu, a kœdœ azu nœ Gbozu. ");
INSERT INTO mnh_vpl VALUES ("RM14_9","075_14_9","ROM","14","9","9","Gbambanœ nene, Kristu tshu yé Ndjaba she she lœ akuzu adœke tshe dœ Gbozu nœ akuzu œdœ asoro. ");
INSERT INTO mnh_vpl VALUES ("RM14_10","075_14_10","ROM","14","10","10","Kashe œɓœ, mbœrœ gaɗe á ɓœ wa ngbanga pa aya zœ a? Yé œɓœ, mbœrœ gaɗe á ɓœ tshene aya zœ a? A ka bala utshu Ndjaba adœke tshe wa ngbanga pa azœ. ");
INSERT INTO mnh_vpl VALUES ("RM14_11","075_14_11","ROM","14","11","11","Gbambanœ nene, endje sú ala Buku nœ ndjaba adœke: Œmœ Gbozu nœ soro, mœ pa adœke: azu kɔ œ gote ga utshu mœ, yé uzu dœ uzu œ pa dœ ama ye adœke œmœ kœdœ Ndjaba. ");
INSERT INTO mnh_vpl VALUES ("RM14_12","075_14_12","ROM","14","12","12","Atamœ uzu dœ uzu ugurutœ azœ œ pa o'o utshu Ndjaba tœ upu nœ ye dœ tœ ye. ");
INSERT INTO mnh_vpl VALUES ("RM14_13","075_14_13","ROM","14","13","13","Mbœrœ tœnœ ataa, a kate kœwa ngbanga ugurutœ azœ dœ anga azœ. Kashe uzu dœ uzu wa ngbanga ɓa tœ lɔsu ye adœke, œne mbœrœ œrœ á mbœrœ adœke aya œne zaza ada ye tɔsho too tshe tete ga lœ ekperœ nene. ");
INSERT INTO mnh_vpl VALUES ("RM14_14","075_14_14","ROM","14","14","14","Lœ Gbozu Yisu, mœ wusœ nœ adœke anga rœgo á dœ uburu dœ tœ ye gugu nene. Rœgo sœ kœfa uburu mbœrœ uzu á tshe gbe adœke œtœnœ kœdœ uburu. ");
INSERT INTO mnh_vpl VALUES ("RM14_15","075_14_15","ROM","14","15","15","Œ kœsœ adœke ɓœ sœ kœzɨ rœgo á sœ kœza oyo fœ aya zœ, œ yindœ kœpa adœke ɓœ mbœmbœrœtœ zœ liaka kœyindœsho nene. Mbœmbœrœ adœke, rœgo ama zœ ndɨ yanga zœ á Kristu tshu tœ upu nœ ye. ");
INSERT INTO mnh_vpl VALUES ("RM14_16","075_14_16","ROM","14","16","16","Kaka adœke, œrœ á 'e wu tœ ɔtshɔnœ tœ ala 'e, zaza awa fœ anga azu kœpa ekpe o'o tœnœ nene. ");
INSERT INTO mnh_vpl VALUES ("RM14_17","075_14_17","ROM","14","17","17","Gbambanœ nene, Ogo gbozu nœ Ndjaba wuwu kœzɨrœ too kœndjorœ nene, kashe œ wu kœsœ ndjii, kœsœ gee œdœ pe yanga lœ Ɔtshɔ Ɨshirɨ. ");
INSERT INTO mnh_vpl VALUES ("RM14_18","075_14_18","ROM","14","18","18","Uzu á tshe sœ kœmbœrœ akwa nœ Kristu dœ mara atake, sœ kœza yanga fœ Ndjaba yé azu œ lɨsœ ye. ");
INSERT INTO mnh_vpl VALUES ("RM14_19","075_14_19","ROM","14","19","19","Atamœ a para awa kœmbœrœ œrœ á yi kœsœ gee ga ugurutœ azœ yé á li kœmbœrœ adœke a gerœ awa bale lœ kœyindœrœ. ");
INSERT INTO mnh_vpl VALUES ("RM14_20","075_14_20","ROM","14","20","20","Adja a ndɨndɨ akwa nœ Ndjaba mbœrœ o'o nœ kœzɨrœ nene. A li kœzɨrœ kɔ kashe œ sœ tœ ekpenœ tœ kœzɨ anga œrœ á vwa uzu ga lœ ekperœ. ");
INSERT INTO mnh_vpl VALUES ("RM14_21","075_14_21","ROM","14","21","21","Œ ga waa adœke ɓœ vwaratœ zœ tœ kœzɨ agea, kœndjo ipi, kœvwaratœ zœ tœ œrœ kɔ á mbœrœ adœke aya zœ te ga lœ ekperœ. ");
INSERT INTO mnh_vpl VALUES ("RM14_22","075_14_22","ROM","14","22","22","Œneke á ɓœ gbe adœke œ dœ ekperœ too ɔtshɔrœ, œ wu kolœ œɓœ dœ Ndjaba nœ zœ. Yanga nœ uzu á gbetshelœ nœ ye sœsœ kœwa ngbanga ga tœ ye nene. ");
INSERT INTO mnh_vpl VALUES ("RM14_23","075_14_23","ROM","14","23","23","Kashe uzu á tshe zɨ œrœ á tshe sœ dœ sharapu tœnœ, Ndjaba œ wa ɔgbɔ ngbanga pa ye. Gbambanœ nene, tshe mbœrœ œrœ á sœsœ ga pa kœyindœrœ nœ ye nene. Yé œrœ kɔ á sœsœ ga pa kœyindœrœ nene kœdœ ekperœ. ");
INSERT INTO mnh_vpl VALUES ("RM15_1","075_15_1","ROM","15","1","1","Azœ á sœ dœ egerœ kœyindœrœ, œ li dœ azœ kœtɨ kane anga azœ á kœyindœrœ nœ endje gegerœ nene yé œ katœ kœmbœrœ œrœ á za yanga ko fœ azœ dœ tœ azœ. ");
INSERT INTO mnh_vpl VALUES ("RM15_2","075_15_2","ROM","15","2","2","Kaka uzu dœ uzu ugurutœ azœ para awa ndœ kœmbœrœ œrœ á za yanga fœ mashenga mbœrœ ɔtshɔrœ nœ ye. Lœ awanœ ataa, œ tɨ kane ye yé œ mbœrœ adœke kœyindœrœ nœ ye gerœ. ");
INSERT INTO mnh_vpl VALUES ("RM15_3","075_15_3","ROM","15","3","3","Gbambanœ nene, Kristu mbœmbœrœ lima kolœ œrœ á za yanga fœ she dœ tœ ye nene. Ɓata endje sú ala Buku nœ Ndjaba adœke: «Kœgu osho á endje gu lima ɓœ, yo ga pa mœ.» ");
INSERT INTO mnh_vpl VALUES ("RM15_4","075_15_4","ROM","15","4","4","O'o kɔ á endje sú ala Buku nœ Ndjaba, endje sú mbœrœ kœyisœrœ fœ azœ. Gbambanœ nene, œ tɨ kane azœ adœke a sœ dœ ugu lɔsu, dœ kœru lɔsu yé á kœwuta dœ kœko lɔsu azœ ga tœ Ndjaba. ");
INSERT INTO mnh_vpl VALUES ("RM15_5","075_15_5","ROM","15","5","5","Kaka Ndjaba á tshe za ugu lɔsu œdœ pe kœto gbɔgbɔ mbœrœ adœke 'e sœ dœ gbetshelœ bale ɓata á Yisu Kristu yisœ nœ fœ azœ. ");
INSERT INTO mnh_vpl VALUES ("RM15_6","075_15_6","ROM","15","6","6","Atamœ dœ lɔsu bale œdœ ama bale, 'e donga Ndjaba á tshe dœ́ Aba Gbozu nœ azœ dœ Yisu Kristu. ");
INSERT INTO mnh_vpl VALUES ("RM15_7","075_15_7","ROM","15","7","7","Atamœ 'e za osho kœsœ ugurutœ 'e dœ anga 'e ɓata á Kristu za osho kœsœ fœ 'e mbœrœ mokɔ nœ Ndjaba. ");
INSERT INTO mnh_vpl VALUES ("RM15_8","075_15_8","ROM","15","8","8","Mœ sœ kœpa fœ 'e dœ adjapu adœke, Kristu te lima ayi akwa nœ Ayuda liaka o'o á Ndjaba pa lima tœnœ utshunœ fœ aata endje. Tshe ma adœke Ndjaba yayapa o'o ama ye nene. ");
INSERT INTO mnh_vpl VALUES ("RM15_9","075_15_9","ROM","15","9","9","Tshe na ndje adœke angbɨ azu donga ndje Ndjaba mbœrœ ɔtshɔ lɔsu nœ ye ɓata á endje sú ala Buku nœ Ndjaba adœke: «Mbœrœ tœnœ ataa mœ donga ɓœ ugurutœ angbɨ azu yé œ ɓi itshi fœ ɓœ.» ");
INSERT INTO mnh_vpl VALUES ("RM15_10","075_15_10","ROM","15","10","10","Endje su ndje adœke: «'E dœ angbɨ azu, 'e sœ dœ yanga awa bale dœ azu á Ndjaba ke endje!» ");
INSERT INTO mnh_vpl VALUES ("RM15_11","075_15_11","ROM","15","11","11","Endje kpa su ndje lima adœke: «'E dœ angbɨ azu, 'e donga Gbozu, 'e ɓi itshi fœ she, 'e dœ́ azu para kɔkɔ!» ");
INSERT INTO mnh_vpl VALUES ("RM15_12","075_15_12","ROM","15","12","12","Isaya pa ndje lima adœke: «Anga ata Yese œ wuta, tshe sœ gbozu tshapa angbɨ azu, endje ko lɔsu endje ga pa ye.» ");
INSERT INTO mnh_vpl VALUES ("RM15_13","075_15_13","ROM","15","13","13","Kaka adœke Ndjaba á tshe mbœrœ adœke azu za lɔsu endje ga pa ye, mbœrœ adœke lɔsu 'e su dœ yanga œdœ kœsœ gee, mbœrœ kœyindœrœ nœ 'e ga ndœ ye. Ɔtshɔ Ɨshirɨ za gbɔgbɔ fœ 'e adœke 'e za lɔsu 'e djigi fœ Ndjaba. ");
INSERT INTO mnh_vpl VALUES ("RM15_14","075_15_14","ROM","15","14","14","Aaya mœ, mœ wusœ nœ adœke 'e dœ azu nœ ɔtshɔ lɔsu. 'E wu ndje sœ œrœ kɔ á sœ adœke 'e wusœ nœ, yé 'e li kœmɨ upu ugurutœ 'e dœ tœ 'e. ");
INSERT INTO mnh_vpl VALUES ("RM15_15","075_15_15","ROM","15","15","15","Yé mœ su anga o'o ala mbetinœ asœke ngbewo fœ 'e adœke 'e kpa gbe dœ o'o á endje yi lima sœ nœ fœ 'e kane. Mœ su œneke kolœ mbœrœ ɔtshɔ lɔsu á Ndjaba za fœ mœ, ");
INSERT INTO mnh_vpl VALUES ("RM15_16","075_15_16","ROM","15","16","16","adœke mœ te ayi akwa nœ Yisu Kristu mbœrœ angbɨ azu. Œshe dá za akwa nœ kœyisœ Ɔtshɔ O'o nœ Ndjaba tœ nganga Ndjaba adœke angbɨ azu wuta ɔtshɔ makabo á wuta yerœ lœ awa nœ Ɔtshɔ Ɨshirɨ adœke œ ga tœ ala Ndjaba. ");
INSERT INTO mnh_vpl VALUES ("RM15_17","075_15_17","ROM","15","17","17","Lœ kœngbɔtœ mœ dœ Kristu, mœ sœ kœdu okoro mœ tœ akwanœ á mœ sœ kœmbœrœ fœ Ndjaba. ");
INSERT INTO mnh_vpl VALUES ("RM15_18","075_15_18","ROM","15","18","18","Atamœ œdœ mœ kœyindœ kœpa o'o tœ anga œrœ, mœ pa kolœ tœ œrœ á Kristu mbœrœ lœ awa nœ mœ adœke angbɨ azu wuta kœdji Ndjaba. Tshe mbœrœ lœ awa nœ o'o œdœ akwa, ");
INSERT INTO mnh_vpl VALUES ("RM15_19","075_15_19","ROM","15","19","19","dœ gbɔgbɔ nœ ambárá afá, dœ gbɔgbɔ nœ Ɨshirɨ. Ataa, kœto lœ Yerusaleme œrrr ga lœ ogo Iliri, mœ mɨndœ Ɔtshɔ O'o nœ Kristu tœ osho kɔ. ");
INSERT INTO mnh_vpl VALUES ("RM15_20","075_15_20","ROM","15","20","20","Kashe mœ yi lima ndœ kœmɨndœ Ɔtshɔ O'onœ kotœ osho á azu djidji damba ɨ'ɨrɨ Kristu nene. Mœ mbœrœ atamœ mbœrœ á mœ yiyindœ kœsœ ɓata uzu á tshe mɔ anda nœ ye ga pa kiti anda á yanganœ mɔ nene. ");
INSERT INTO mnh_vpl VALUES ("RM15_21","075_15_21","ROM","15","21","21","Ataa, mœ gbe dœ œneke á endje sú ala Buku nœ Ndjaba adœke: «Azu neke á endje yiyisœ œrœ fœ endje nene tœ upu nœ ye, endje wu she. Endjeneke á endje djidji lima o'o nene tœ upu nœ ye, endje dji.» ");
INSERT INTO mnh_vpl VALUES ("RM15_22","075_15_22","ROM","15","22","22","Œtœnœ kœdœ œrœ á kundœ mœ awa ndjoro tœ kœna ga ndœ 'e. ");
INSERT INTO mnh_vpl VALUES ("RM15_23","075_15_23","ROM","15","23","23","Yé ngɔngɔ asœ akwa nœ mœ lœ ogo ɓa ke ka ye. Yé ungu ndjoro ro, mœ sœ dœ ogo kœna ga ndœ 'e, ");
INSERT INTO mnh_vpl VALUES ("RM15_24","075_15_24","ROM","15","24","24","mœ gbe adœke ɔlɔ á mœ za awa kœro ga lœ Espane dá mœ ro tɔ tshandœ 'e yé mœ gbe kœgbɔ kœtɨ kane nœ 'e mbœrœ ananœ asœmœ. Yé œtœnœ manda yanga nœ kœwutœ azœ dœ 'e. ");
INSERT INTO mnh_vpl VALUES ("RM15_25","075_15_25","ROM","15","25","25","Kashe ngɔngɔ asœ, mœ sœ kœro damba ga lœ Yerusaleme mbœrœ kœtɨ kane ayerœ azu nœ Ndjaba: ");
INSERT INTO mnh_vpl VALUES ("RM15_26","075_15_26","ROM","15","26","26","gbambanœ nene, aaya azœ lœ Masedwane œdœ endjeneke lœ Akayi gbe lima ndœ kœrɔ makabo mbœrœ azu nœ Ndjaba ɓa lœ Yerusaleme á endje sœ lœ oyo. ");
INSERT INTO mnh_vpl VALUES ("RM15_27","075_15_27","ROM","15","27","27","Endje dœ tœ endje yi lima ndœ kœmbœrœ ataa. Kashe dœ adjapu, endje sœ dœ kuɗa nœ Ayuda. Gbambanœ nene, akristu Ayuda kuru lima tshelœ ɔtshɔrœ nœ ɨshirɨ nœ endje dœ endjeneke á endje dœ́dœ́ Ayuda nene. Mbœrœ tœnœ ataa, endje tɨ ndje kane Ayuda dœ œrœ á dœ́dœ́ œnœ ɨshirɨ nene, á endje sœ dœ oyonœ. ");
INSERT INTO mnh_vpl VALUES ("RM15_28","075_15_28","ROM","15","28","28","Lɔkɔ á mœ kœko œrœnœ fœ endje dá akwanœ ka ye, yé mœ tara ga lœ Espane dœ kœro tɔ tshandœ 'e. ");
INSERT INTO mnh_vpl VALUES ("RM15_29","075_15_29","ROM","15","29","29","Yé mœ wusœ nœ adœke ɔlɔ á mœ wuta ga ndœ 'e, mœ na dœ ɔtshɔrœ nœ Kristu ndjoro fœ 'e. ");
INSERT INTO mnh_vpl VALUES ("RM15_30","075_15_30","ROM","15","30","30","Kashe aaya, 'e wu œneke á mœ sœ kœ'eshondœ nœ lœ Gbozu nœ azœ dœ Yisu Kristu œdœ lœ kœyindœsho á Ɔtshɔ Ɨshirɨ œ za adœke 'e nga koshe awa bale dœ mœ tœ kœza avwala fœ Ndjaba tœ upu nœ mœ. ");
INSERT INTO mnh_vpl VALUES ("RM15_31","075_15_31","ROM","15","31","31","'E za avwala adœke Ayuda á endje vwaratœ endje tœ Kristu mbœmbœrœ ekperœ ga tœ mœ nene yé ayindœ Yisu lœ Yerusaleme yindœ kœtɨ kane oshonœ á mœ sœ kœna dœ tœnœ fœ endje dœ ɔtshɔnœ. ");
INSERT INTO mnh_vpl VALUES ("RM15_32","075_15_32","ROM","15","32","32","Atamœ œdœ Ndjaba kœyindœ nœ, mœ wuta ɓa ndœ 'e dœ egerœ yanga ndœ kœyatœ mœ teasho ugurutœ 'e. ");
INSERT INTO mnh_vpl VALUES ("RM15_33","075_15_33","ROM","15","33","33","Kaka adœke Ndjaba á tshe za kœsœ gee fœ azu sœ dœ 'e para kɔkɔ! Ame. ");
INSERT INTO mnh_vpl VALUES ("RM16_1","075_16_1","ROM","16","1","1","Mœ yindœ kœyisœ Foebe á tshe dœ yingɔ azœ lœ kœyindœrœ, á tshe sœ kœmbœrœ akwa lœ Ikrizia ɓa lakpɨ Sakre fœ 'e adœke 'e wusœ ye. ");
INSERT INTO mnh_vpl VALUES ("RM16_2","075_16_2","ROM","16","2","2","'E za osho kœsœ fœ she dœ ɨ'ɨrɨ Gbozu liaka œneke á ayerœ azu œ mbœrœ. 'E tɨ kane ye lœ œrœ kɔ á tshe sœ dœ ogonœ ɓa ndœ 'e. Gbambanœ nene, tshe tɨ kane azu waa œdœ pe ndje mœ. ");
INSERT INTO mnh_vpl VALUES ("RM16_3","075_16_3","ROM","16","3","3","'E bala Prisika œdœ Akilase á endje dœ anga mœ lœ akwa nœ Yisu Kristu. ");
INSERT INTO mnh_vpl VALUES ("RM16_4","075_16_4","ROM","16","4","4","Œ sœpe lima teasho adœke endje tshu mbœrœ kœshe mœ, yé œ dœ́dœ́ kolœ mœ dá za mershe fœ endje nene kashe Ikrizia kɔ lœ tshapashɔ nœ angbɨ azu gi ndje mershe fœ endje. ");
INSERT INTO mnh_vpl VALUES ("RM16_5","075_16_5","ROM","16","5","5","'E za abala nœ mœ fœ Ikrizia á sœ kœngbɔɓatœ ye ɓa lœ anda nœ endje. 'E za ndje abala fœ yanga mœ dœ Epayinete á tshe kœdœ ali uzu kœyindœ Kristu ɓa lœ ogo Azi. ");
INSERT INTO mnh_vpl VALUES ("RM16_6","075_16_6","ROM","16","6","6","'E za abala fœ Mareya á tshe za lima tœ ye tɨ djigi mbœrœ 'e asœmœ. ");
INSERT INTO mnh_vpl VALUES ("RM16_7","075_16_7","ROM","16","7","7","'E za abala fœ Andronikuse œdœ Juniyase á endje kœdœ ayo mœ œdœ anga mœ á a li lima kánga dœ endje awa bale. Endje wuta azu nœ Kristu utshu mœ, yé endje dœ́ aayi avwa á œsœ endje lɨ. ");
INSERT INTO mnh_vpl VALUES ("RM16_8","075_16_8","ROM","16","8","8","'E za abala fœ Apliyatuse á mœ yindœ ye waa lœ Gbozu. ");
INSERT INTO mnh_vpl VALUES ("RM16_9","075_16_9","ROM","16","9","9","'E za abala fœ Urbe á tshe kœdœ yanga azœ lœ ma akwa nœ Kristu, œdœ pe Stakisi á mœ yindœ ye waa. ");
INSERT INTO mnh_vpl VALUES ("RM16_10","075_16_10","ROM","16","10","10","'E za abala fœ Apelese á tshe má lima tœ ye adœke œne yindœ Kristu waa. 'E za abala fœ azu kɔ lœ anda nœ Aristobile. ");
INSERT INTO mnh_vpl VALUES ("RM16_11","075_16_11","ROM","16","11","11","'E za abala fœ Erodiyone, á tshe kœdœ uzu lœ bɨngɨ nœ mœ. 'E za abala fœ azu kɔ lœ anda nœ Narsise á endje sœ lœ Gbozu. ");
INSERT INTO mnh_vpl VALUES ("RM16_12","075_16_12","ROM","16","12","12","'E za abala fœ Trifene œdœ Trifose. Endje kœdœ ayashe á endje zatœ endje ga tœ akwa nœ Gbozu, œdœ Pereside á tshe mbœrœ akwa waa mbœrœ she. ");
INSERT INTO mnh_vpl VALUES ("RM16_13","075_16_13","ROM","16","13","13","'E za abala fœ Rufusi á Gbozu ke she, œ bala pe ayinœ á tshe dœ ndje ayi mœ. ");
INSERT INTO mnh_vpl VALUES ("RM16_14","075_16_14","ROM","16","14","14","'E za abala fœ Asikrite, Flegɔne, Ermese, Patrobase, Ermase œdœ pe aaya á endje sœ awa bale dœ endje. ");
INSERT INTO mnh_vpl VALUES ("RM16_15","075_16_15","ROM","16","15","15","'E za abala fœ Filologe, dœ Juliyuse, Nere dœ yingɔnœ, Olipase œdœ ndje ayerœ azu kɔ á endje sœ awa bale dœ endje. ");
INSERT INTO mnh_vpl VALUES ("RM16_16","075_16_16","ROM","16","16","16","'E za œyerœ abala ugurutœ 'e. Azu Ikrizia nœ Kristu para kɔkɔ vwa abala nœ endje fœ 'e. ");
INSERT INTO mnh_vpl VALUES ("RM16_17","075_16_17","ROM","16","17","17","Aaya, mœ pa fœ 'e adœke, ala 'e gbɔ tœ azu á endje œ kurutshelœ azu yé á ndɨ kœyindœrœ nœ anga endje. Endje sœ kœvwaratœ endje tœ kœyisœrœ á endje gbɔ lima utshunœ; 'e kpa awa endje. ");
INSERT INTO mnh_vpl VALUES ("RM16_18","075_16_18","ROM","16","18","18","Gbambanœ nene mara azu atamœ, sœsœ kœmbœrœ akwa fœ Kristu nene, kashe endje sœ kœgbe kolœ dœ uvu endje. Endje sœ kœndɨ tshelœ ɔkɔrɔ azu á endje wuwusœ œrœ nene dœ o'o nœ wala. ");
INSERT INTO mnh_vpl VALUES ("RM16_19","075_16_19","ROM","16","19","19","Azu para kɔkɔ wusœ mara á 'e sœ tœ kœdji Gbozu yé mœ sœ dœ yanga mbœrœ 'e, kashe mœ yindœ nœ adœke 'e sœ dœ kœwusœtœ á kœmbœrœ ɔtshɔrœ, yé œ sœsœ dœ uburu nene á kœkpa awa ekperœ. ");
INSERT INTO mnh_vpl VALUES ("RM16_20","075_16_20","ROM","16","20","20","Œ sœpe teasho adœke Ndjaba á tshe za kœsœ gee fœ azu zuru tshelœ Satana ga tshada 'e. Kaka adœke ɔtshɔ lɔsu nœ Gbozu nœ azœ dœ Yisu sœ dœ 'e. ");
INSERT INTO mnh_vpl VALUES ("RM16_21","075_16_21","ROM","16","21","21","Timote á tshe kœdœ yanga mœ lœ akwa nœ Gbozu dœ Lukiyuse, dœ Jasone, dœ Sosipatrose á endje kɔ kœdœ azu bɨngɨ nœ mœ vwa abala fœ 'e. ");
INSERT INTO mnh_vpl VALUES ("RM16_22","075_16_22","ROM","16","22","22","Œmœ Tertiyuse, á mœ su o'o ama Polo fœ 'e asœke, mœ za abala ndje fœ 'e lœ Gbozu. ");
INSERT INTO mnh_vpl VALUES ("RM16_23","075_16_23","ROM","16","23","23","Gayushi á mœ lo lœ anda nœ ye œdœ aayi kœyindœrœnœ á endje ngbɔɓatœ endje ɓa ndœ ye bala 'e. Eraste ayi kœgbɔndœ ngendja lakpɨ asœke, dœ aya azœ dœ Kwartuse vwa abala fœ 'e.  ");
INSERT INTO mnh_vpl VALUES ("RM16_24","075_16_24","ROM","16","24","24","Kaka adœke ɔtshɔ lɔsu nœ Gbozu nœ azœ dœ Yisu Kristu sœ dœ 'e kɔ! Ame. ");
INSERT INTO mnh_vpl VALUES ("RM16_25","075_16_25","ROM","16","25","25","A donga Ndjaba mbœrœ á tshe sœ dœ gbɔgbɔ nœ kœmbœrœ adœke a gerœ lœ kœyindœrœ nœ azœ liaka Ɔtshɔ O'o nœ Yisu Kristu á mœ mɨ lima ndœ nœ. Ɔtshɔ O'onœ kœdœ avwanœ á Ndjaba za ɓalima yiwa tœnœ katshatsha. ");
INSERT INTO mnh_vpl VALUES ("RM16_26","075_16_26","ROM","16","26","26","Kashe ngɔngɔ asœke, œneke á za lima tœ ye yiwa tœnœ, endje va ɔtɔnœ ngbɨ lœ awa nœ mbeti nœ aayi kœgbara o'o liaka o'o ama Ndjaba á tshe sœ waa dœ waa; tshe mbœrœ adœke angbɨ azu para kɔkɔ wusœ nœ á kœsœ dœ kœyindœrœ ga ndœ ye yé œ lɨsœ ye. ");
INSERT INTO mnh_vpl VALUES ("RM16_27","075_16_27","ROM","16","27","27","Kaka endje donga Ndjaba á tshe dœ́ Uzu kœwusœtœ tshebale lœ Yisu Kristu waa dœ waa! Ame.");
INSERT INTO mnh_vpl VALUES ("C11_1","076_1_1","1CO","1","1","1","Œmœ Polo, Ndjaba e mœ lindœ gbetshelœ nœ ye adœke mœ te ayi avwa nœ Yisu Kristu. Œmœ œdœ aya mœ dœ Sostene, ");
INSERT INTO mnh_vpl VALUES ("C11_2","076_1_2","1CO","1","2","2","'a su mbeti asœke fœ 'e dœ́ azu Ikrizia nœ Ndjaba ɓa lœ Koriti. Ndjaba ke 'e adœke 'e dœ adja azu nœ œne yé 'e wuta ayerœ azu lœ kœngbɔtœ 'e bale dœ Yisu Kristu, 'e dœ azu nœ ye awa bale dœ endjeneke á endje sœ kœlɨsœ Gbozu nœ azœ dœ Yisu Kristu. Œshe kœdœ Gbozu nœ endje œdœ œnœ azœ. ");
INSERT INTO mnh_vpl VALUES ("C11_3","076_1_3","1CO","1","3","3","Kaka Aba azœ dœ Ndjaba œdœ Gbozu Yisu Kristu ma ɔtshɔ lɔsu ga tœ 'e, yé œ za kœsœ gee fœ 'e. ");
INSERT INTO mnh_vpl VALUES ("C11_4","076_1_4","1CO","1","4","4","Mœ sœ kœgi mershe fœ Ndjaba ɔlɔ dœ ɔlɔ tœ upu nœ ɔtshɔ lɔsu á tshe ma fœ 'e lœ awa nœ Yisu Kristu. ");
INSERT INTO mnh_vpl VALUES ("C11_5","076_1_5","1CO","1","5","5","Gbambanœ nene, lœ kœngbɔtœ 'e dœ Kristu, Ndjaba to kœtorœ kɔ fœ 'e, œnœ o'o œdœ pe œnœ kœwusœrœ nœ Ndjaba. ");
INSERT INTO mnh_vpl VALUES ("C11_6","076_1_6","1CO","1","6","6","Œneke kœdœ kœmarœ tœ upu nœ Yisu Kristu á to gbɔgbɔ ga lœ kœyindœrœ nœ 'e. ");
INSERT INTO mnh_vpl VALUES ("C11_7","076_1_7","1CO","1","7","7","Ataa, e'e á 'e sœ kœkate lɔkɔ á Gbozu nœ azœ dœ Yisu Kristu œ kwatœ ye, 'e sœ kœgbɔ kœtorœ nœ Ndjaba. ");
INSERT INTO mnh_vpl VALUES ("C11_8","076_1_8","1CO","1","8","8","Ndjaba œ mbœrœ ndje bala adœke 'e shi gbɨ œrrr ga tœ ndɔngɔlɔnœ adœke, lɔkɔ kœkwa Gbozu nœ azœ dœ Yisu Kristu, á endje kœgbagbagbara 'e tœ ekperœ bale nene. ");
INSERT INTO mnh_vpl VALUES ("C11_9","076_1_9","1CO","1","9","9","Ndjaba sœ kœmbœrœtœ ye lindœ œneke á tshe pa, œshe dá e 'e adœke 'e ngbɔtœ 'e awa bale dœ Gbolo nœ œne Yisu Kristu, á tshe dœ Gbozu nœ azœ. ");
INSERT INTO mnh_vpl VALUES ("C11_10","076_1_10","1CO","1","10","10","Kashe alaya, mœ sœ kœkɨ fœ 'e dœ ɨ'ɨrɨ Gbozu nœ azœ dœ Yisu Kristu adœke: o'o ama 'e sœ bale, yé 'e kukurutshelœtœ 'e nene. 'E ngbɔtœ 'e ga tœ œsœnœ bale, œ sœ dœ lɔsu bale œdœ ndje pe dœ gbetshelœ bale. ");
INSERT INTO mnh_vpl VALUES ("C11_11","076_1_11","1CO","1","11","11","Gbambanœ nene, aaya mœ, azu tshelœ bɨngɨ nœ Kolowe pandœ nœ fœ mœ adœke 'e kurutshelœtœ 'e ye. ");
INSERT INTO mnh_vpl VALUES ("C11_12","076_1_12","1CO","1","12","12","Œneke á mœ yindœ kœpa tœnœ fœ 'e dœke: lœ ugurutœ 'e, uzu dœ uzu sœ kœpa adœke: «Œmœ, mœ kœdœ uzu nœ Polo»; anga: «Œmœ kœdœ uzu nœ Apolo»; anga kpa sœ kœpa adœke: «Œmœ kœdœ uzu nœ Petro»; yeka á anga pa adœke: «Œmœ kœdœ uzu nœ Kristu.» ");
INSERT INTO mnh_vpl VALUES ("C11_13","076_1_13","1CO","1","13","13","'E sœ kœgbe adœke endje lii kœkurutshelœ Kristu ye a? Polo dá tshu lima pa kurushi mbœrœ 'e a? Yé ataa, endje za batisimu fœ 'e dœ ɨ'ɨrɨ Polo a? ");
INSERT INTO mnh_vpl VALUES ("C11_14","076_1_14","1CO","1","14","14","Mœ gi mershe fœ Ndjaba mbœrœ á mœ zaza batisimu fœ uzu bale ugurutœ 'e nene, kashe mœ za kolœnœ fœ Krispuse dœ Gayushi. ");
INSERT INTO mnh_vpl VALUES ("C11_15","076_1_15","1CO","1","15","15","Ataa, uzu bale lili kœpa adœke endje za batisimu fœ 'e dœ ɨ'ɨrɨ mœ nene. ");
INSERT INTO mnh_vpl VALUES ("C11_16","076_1_16","1CO","1","16","16","Ha! Œ sœ adjapu adœke mœ za ndje batisimu fœ azu tshelœ bɨngɨ nœ Esetefanase, kashe mœ kpa wuwusœ anga uzu á mœ za fœ she nene. ");
INSERT INTO mnh_vpl VALUES ("C11_17","076_1_17","1CO","1","17","17","Gbambanœ nene, Yisu Kristu vwavwa lima mœ ndœ kœza batisimu fœ azu nene, kashe tshe vwa mœ mbœrœ kœmɨndœ Ɔtshɔ O'o. Mœ yiyisœ nœ dœ kœwusœtœ nœ azu nene, mbœrœ á gbɔgbɔ kuzu nœ Kristu pa kurushi kœsœsœ gbambanœ tœ ala azu nene. ");
INSERT INTO mnh_vpl VALUES ("C11_18","076_1_18","1CO","1","18","18","Ɓa tœ azu á endje sœ lœ djingili, kœpandœ kuzu Yisu pa kurushi kœdœ agba o'o, kashe ɓa tœ azœ á a sœ kœshe mbœrœ tœnœ, tœnœ kœdœ gbɔgbɔ nœ Ndjaba. ");
INSERT INTO mnh_vpl VALUES ("C11_19","076_1_19","1CO","1","19","19","Gbambanœ nene, endje sú ɓala Buku nœ Ndjaba adœke: «Mœ ndɨtshelœ kœwusœtœ nœ azu á endje wusœtœ endje, yé œ fa kœwusœrœ nœ azu á endje wusœ œrœ, gbambanœ.» ");
INSERT INTO mnh_vpl VALUES ("C11_20","076_1_20","1CO","1","20","20","Azu á endje wusœtœ endje sœ kpœta a? Agbangba kœwusœ awa akwa sœ kpœta a? Azu nœ tshakpesheke á endje wusœ kœtondœ ádá o'o sœ kpœta a? Ndjaba mama adœke kœwusœtœ nœ azu tshapashɔ kœdœ agba o'o nene a? ");
INSERT INTO mnh_vpl VALUES ("C11_21","076_1_21","1CO","1","21","21","Yé ataa, azu tshapashɔ dœ kœwusœtœ nœ endje kɔ, lili lima kœwusœ Ndjaba lœ kœwusœtœ nœ ye nene. Mbœrœ tœnœ ataa á Ndjaba wa o'o adœke œne she azu á endje sœ dœ kœyindœrœ tœ upu nœ kuzu Yisu pa kurushi lœ awa nœ kœyisœrœ á sœ ɓata agba œrœ asœmœ. ");
INSERT INTO mnh_vpl VALUES ("C11_22","076_1_22","1CO","1","22","22","Ayuda sœ kœyu osho tœ ambárá, yé Agreke sœ œnœ endje kœpara kœwusœtœ. ");
INSERT INTO mnh_vpl VALUES ("C11_23","076_1_23","1CO","1","23","23","Kashe tœ a'a nœ 'a, 'a sœ kœmɨndœ O'o kuzu Masiya pa kurushi. Œtœnœ kœdœ O'o á sœ kœɓi tshelœ ada Ayuda, yé á dœ agba o'o ɓa tœ ala angbɨ azu. ");
INSERT INTO mnh_vpl VALUES ("C11_24","076_1_24","1CO","1","24","24","Kashe tœ endjeneke á Ndjaba e endje, Ayuda too Agreke, Masiya kœdœ gbɔgbɔ œdœ kœwusœtœ nœ Ndjaba. ");
INSERT INTO mnh_vpl VALUES ("C11_25","076_1_25","1CO","1","25","25","Gbambanœ nene, agba o'o nœ Ndjaba rosœ kœwusœtœ nœ azu ye, yé kœmɔ nœ Ndjaba ro ndje gbɔgbɔ nœ azu ye. ");
INSERT INTO mnh_vpl VALUES ("C11_26","076_1_26","1CO","1","26","26","Alaya mœ, 'e gbe dœ mara á 'e sœ lima dœ tœnœ lɔkɔ á Ndjaba e 'e kane: azu nœ kœwusœtœ tœ ala azu ngbangba ugurutœ 'e nene, azu á endje sœ dœ gbɔgbɔ waa ngbangba nene, endjeneke á endje sœ lœ ɔtshɔ bɨngɨ ngbangba ndje nene. ");
INSERT INTO mnh_vpl VALUES ("C11_27","076_1_27","1CO","1","27","27","Kashe œneke á dœ agba o'o ɓa pa tshapashɔ, Ndjaba ke mbœrœ kœza tshula fœ endjeneke á endje sœ dœ kœwusœtœ, tshe ke ɔmɔ œrœ mbœrœ kœza tshula fœ œneke á sœ dœ gbɔgbɔ. ");
INSERT INTO mnh_vpl VALUES ("C11_28","076_1_28","1CO","1","28","28","Œneke á sœ ɓa pa tshapashɔ, á gugu dœ ádá bale nene yé á azu yiyi ndje ndœ nœ nene, Ndjaba ke mbœrœ kœndɨ œneke á azu sœ kœgbe adœke œ sœ dœ ádá waa, ");
INSERT INTO mnh_vpl VALUES ("C11_29","076_1_29","1CO","1","29","29","mbœrœ adœke anga uzu bale pa ɔshɔ asœke lili kœdu okoro ye ɓa utshu Ndjaba nene. ");
INSERT INTO mnh_vpl VALUES ("C11_30","076_1_30","1CO","1","30","30","Lœ awa nœ Ndjaba dá 'e ngbɔɓatœ 'e ga tœnœ dœ Yisu Kristu á tshe dœ́ kœwusœtœ nœ azœ á to ɓa ndœ Ndjaba, yé tshe sœ kœmbœrœ adœke á sœ ndjii, á sœ yerœ dœ pe kœwuta lœ ekperœ. ");
INSERT INTO mnh_vpl VALUES ("C11_31","076_1_31","1CO","1","31","31","Dœ tœnœ ataa, endje sú ɓala Buku nœ Ndjaba adœke: «Œdœ uzu kœyindœ kœdu okoro, tshe du okoro ye tœ œneke á Gbozu mbœrœ.» ");
INSERT INTO mnh_vpl VALUES ("C12_1","076_2_1","1CO","2","1","1","Aaya mœ, lɔkɔ á mœ na lima ɓa ndœ 'e ndœ kœyisœ O'o ama Ndjaba á zatœ ye yiwatœnœ fœ 'e, mœ mamatœ mœ adœke mœ wusœ kœpa o'o too mœ wusœ œrœ waa ye nene. ");
INSERT INTO mnh_vpl VALUES ("C12_2","076_2_2","1CO","2","2","2","Gbambanœ nene, mœ wa o'o adœke adja mœ gbegbe kœwusœ anga angbɨ œrœ nene, kashe kolœ dœ Yisu Kristu, œshe á endje kuru she ga pa kurushi. ");
INSERT INTO mnh_vpl VALUES ("C12_3","076_2_3","1CO","2","3","3","Ádá nœ ataa, mœ ka ga utshu 'e dœ kœmɔ œdœ pe dœ kœgugu dœ awa. ");
INSERT INTO mnh_vpl VALUES ("C12_4","076_2_4","1CO","2","4","4","Mœ sœsœ lima kœyisœ œrœ dœ kœwusœtœ nœ azu tshapashɔ nene, kashe mœ sœ lima kœyisœ nœ dœ gbɔgbɔ nœ Ɔtshɔ Ɨshirɨ, á sœ kœma fœ azu adœke tœnœ kœdœ adjapu. ");
INSERT INTO mnh_vpl VALUES ("C12_5","076_2_5","1CO","2","5","5","Ataa, kœyindœrœ nœ 'e sœsœ ga pa kœwusœtœ nœ azu nene, kashe œ sœ ga pa gbɔgbɔ nœ Ndjaba. ");
INSERT INTO mnh_vpl VALUES ("C12_6","076_2_6","1CO","2","6","6","Andaa, 'a sœ kœyisœ kœwusœtœ fœ ayindœ Kristu á endje dœ agbozu lœ ɨshirɨ, kashe 'a yiyisœ œrœ dœ kœwusœtœ nœ azu tshapashɔ œdœ dœ kœwusœtœ nœ agbozugo tshapashɔ á sœ mbœrœ kœndɨ tœ nœ nene. ");
INSERT INTO mnh_vpl VALUES ("C12_7","076_2_7","1CO","2","7","7","'A sœ kœyisœ kœwusœtœ nœ Ndjaba á zatœ ye yiwa tœnœ tœ azu, kœwusœtœ neke á lili adœke azu wusœ ádánœ nene, á Ndjaba guma lima utshunœ adœke tshe mbœrœ tshapashɔ, yé á sœ mbœrœ mokɔ nœ azœ. ");
INSERT INTO mnh_vpl VALUES ("C12_8","076_2_8","1CO","2","8","8","Anga uzu bale lœ agbozugo tshapashɔnœ asœke sœsœ dœ kœwusœtœnœ asœmœ nene. Œdœ endje kœsœ má dœ tœnœ, dá endje kuru Gbozu nœ mokɔ ga pa kurushi nene. ");
INSERT INTO mnh_vpl VALUES ("C12_9","076_2_9","1CO","2","9","9","Kashe ɓata á endje sú ɓala Buku nœ Ndjaba adœke: «Œneke á uzu bale wuwu yé á dji dœ utu ye nene, œneke á uzu bale sœsœ dœ gbetshelœnœ nene, Ndjaba guma mbœrœ endjeneke á endje yindœ ye.» ");
INSERT INTO mnh_vpl VALUES ("C12_10","076_2_10","1CO","2","10","10","Andaa, azœ dá Ndjaba ma œrœnœ asœmœ fœ azœ lœ awa nœ Ɔtshɔ Ɨshirɨ asœmœ. Gbambanœ nene, Ɨshirɨ wusœ kœtondœ œrœ kɔ dœ ádánœ, ataa œdœ gbetshelœ nœ Ndjaba. ");
INSERT INTO mnh_vpl VALUES ("C12_11","076_2_11","1CO","2","11","11","Œɗe ugurutœ azu dá wusœ gbetshelœ nœ uzu, á kœdœ́dœ́ ɨshirɨ á sœ lœ ye nene a? Awa bale ndje, gbetshelœ nœ Ndjaba, uzu bale wuwusœ nœ nene, kolœ Ɨshirɨ nœ Ndjaba dœ tœ ye dá wusœ nœ. ");
INSERT INTO mnh_vpl VALUES ("C12_12","076_2_12","1CO","2","12","12","Tœ upu nœ azœ, a gbɔgbɔ ɨshirɨ ɓa ndœ azu tshapashɔ asœ nene, kashe a gbɔ Ɨshirɨ á to ɓa ndœ Ndjaba yeka á kœwusœ kœtorœ á Ndjaba to dœ ɔtshɔ lɔsu ye fœ azœ. ");
INSERT INTO mnh_vpl VALUES ("C12_13","076_2_13","1CO","2","13","13","Yé 'a sœsœ kœyisœ œrœ dœ kœwusœtœ nœ azu tshapashɔ nene, kashe 'a sœ kœyisœ nœ dœ Ɨshirɨ á Ndjaba to fœ 'a. Œtœnœ ataa á 'a sœ kœyisœ adjapu tœ upu nœ Ɨshirɨ nœ Ndjaba fœ azu á endje lœ dœ tœnœ lœ endje. ");
INSERT INTO mnh_vpl VALUES ("C12_14","076_2_14","1CO","2","14","14","Uzu á tshe sœ kolœ kœgbe dœ kœwusœrœ nœ ye dœ tœ ye, yiyindœ o'o neke á to ɓa ndœ Ɨshirɨ nœ Ndjaba nene. Tshe sœ kœdji ɓata agba o'o lœ utu ye, yé tshe lili kœwusœ ádánœ nene, mbœrœ uzu œ wusœ ádánœ kolœ œdœ tshe kœsœ dœ Ɨshirɨ nœ Ndjaba. ");
INSERT INTO mnh_vpl VALUES ("C12_15","076_2_15","1CO","2","15","15","Uzu á tshe sœ dœ Ɨshirɨ nœ Ndjaba, tshe sœ kœwa ngbanga kɔ ga tœ undu ye, kashe uzu bale œ wa ngbanga ga tœ ye nene. ");
INSERT INTO mnh_vpl VALUES ("C12_16","076_2_16","1CO","2","16","16","Gbambanœ nene, endje sú ɓala Buku nœ Ndjaba adœke: «Uzu ɗe dá wusœ gbetshelœ nœ Gbozu a? Uzu ɗe dá li kœmɨ upu fœ she a?» Kashe tœ azœ, a lii kœwusœ ádánœ mbœrœ á a sœ dœ gbetshelœ nœ Kristu. ");
INSERT INTO mnh_vpl VALUES ("C13_1","076_3_1","1CO","3","1","1","Tœ upu nœ mœ, aaya mœ, lɔkɔ á mœ sœ lima awa bale dœ 'e, mœ papa o'o fœ 'e ɓata á mœ pa fœ azu á endje sœ dœ Ɨshirɨ nœ Ndjaba nene, kashe mœ pa o'o fœ 'e kolœ ɓata fœ azu nœ tshapashɔ, ɓata fœ aaya agbolo lœ kœyindœrœ ga ndœ Kristu. ");
INSERT INTO mnh_vpl VALUES ("C13_2","076_3_2","1CO","3","2","2","Ungu ɔngɔ dá mœ to fœ 'e, kashe œ dœ́dœ́ adja kœzɨrœ nene. Gbambanœ nene, 'e li má kœru lɔsu 'e tœnœ nene. Ataa ngɔngɔnœ asœke, 'e li má ndje nene, ");
INSERT INTO mnh_vpl VALUES ("C13_3","076_3_3","1CO","3","3","3","mbœrœ 'e sœpe kœmbœrœtœ 'e ɓata mara œrœ nœ azu nœ tshapashɔ. 'E sœ kœmbœrœ úkú œdœ kœbœrœtœ 'e ugurutœ 'e. Atamœ sœmœ 'e dœ́dœ́ azu nœ tshapashɔ asœke yé œ sœ kœmbœrœ mara œrœ nœ azu kɔ nene a? ");
INSERT INTO mnh_vpl VALUES ("C13_4","076_3_4","1CO","3","4","4","Dœ lɔkɔ á anga yanga 'e bale kœpa ngbɨ adœke: «Œmœ kœdœ uzu nœ Polo», yé anga kpa pa adœke: «Œmœ kœdœ uzu nœ Apolo», 'e mbœmbœrœtœ 'e ɓata azu nœ tshapashɔ kɔ nene dœ mœ a? ");
INSERT INTO mnh_vpl VALUES ("C13_5","076_3_5","1CO","3","5","5","Apolo kœdœ ɗe? Yé á Polo kœdœ ndje ɗe? Endje kɔ kœdœ aayi akwa nœ Ndjaba á endje gi 'e ga lœ kœyindœrœ ga ndœ Kristu. Kashe lœ ugurutœ endje, uzu dœ uzu sœ dœ mara kœmbœrœ akwa nœ ye á Gbozu to fœ she. ");
INSERT INTO mnh_vpl VALUES ("C13_6","076_3_6","1CO","3","6","6","Œmœ, mœ lu ngwarœ yé Apolo dá su ungu ga panœ. Kashe Ndjaba dá mbœrœ adœke ngwarœnœ gboro. ");
INSERT INTO mnh_vpl VALUES ("C13_7","076_3_7","1CO","3","7","7","Ataa, œdœ ayi kœlu ngwarœ œdœ ayi kœsu ungu ga panœ, endje gugu dœ ádá bale nene. Kashe kolœ Ndjaba dá sœ dœ ádá, œshe á tshe mbœrœ adœke ngwarœnœ gboro asœmœ. ");
INSERT INTO mnh_vpl VALUES ("C13_8","076_3_8","1CO","3","8","8","Tsheneke á tshe lu ngwarœ dœ tsheneke á tshe su ungu ga panœ, endje sœ awa bale yé uzu dœ uzu œ gbɔ œrœ tshangba akwa nœ ye kœli dœ mara akwa nœ ye dœ tœ ye. ");
INSERT INTO mnh_vpl VALUES ("C13_9","076_3_9","1CO","3","9","9","Gbambanœ nene, a'a, 'a sœ kœmbœrœ akwa nœ Ndjaba awa bale, yé e'e kœdœ kɨndɨ nœ Ndjaba. E'e ndje kœdœ anda nœ Ndjaba. ");
INSERT INTO mnh_vpl VALUES ("C13_10","076_3_10","1CO","3","10","10","Mœ mbœrœ akwa ɓata ɔtshɔ ayi kœmɔ anda, œ tɔ kiti anda lindœ kœtorœ á Ndjaba to fœ mœ, yé anga uzu dá mɔ udunœ ga panœ. Kashe ala uzu dœ uzu gbɔ tœ mara á tshe sœ kœmɔ dœ andanœ. ");
INSERT INTO mnh_vpl VALUES ("C13_11","076_3_11","1CO","3","11","11","Gbambanœ nene, kiti andanœ sœ zœ, œtœnœ kœdœ Yisu Kristu. Uzu bale kpa lili kœmɔ anga angbɨ kiti anda nene. ");
INSERT INTO mnh_vpl VALUES ("C13_12","076_3_12","1CO","3","12","12","Ataa anga endje kœmɔ udu andanœ ga pa kitinœ dœ ɔrœ, dœ kowo, dœ badja á amanœ gbɔ waa, dœ ɔyɔ, dœ muru too dœ ebe gbaa, ");
INSERT INTO mnh_vpl VALUES ("C13_13","076_3_13","1CO","3","13","13","akwa nœ uzu dœ uzu œ matœ ye ngbɨ ɔlɔ kœwa ngbanga. Gbambanœ nene, dœ ɔlɔnœ asœmœ, owo œ tshi yé akwa nœ uzu dœ uzu œ matœ ye ngbɨ. ");
INSERT INTO mnh_vpl VALUES ("C13_14","076_3_14","1CO","3","14","14","Tsheneke á akwa nœ ye kœjuju nene, tshe gbɔ œrœ tshangbanœ ye. ");
INSERT INTO mnh_vpl VALUES ("C13_15","076_3_15","1CO","3","15","15","Tsheneke á akwa nœ ye kœju, tshe gbɔ œrœ tshangbanœ bale nene, œshe kutu ye tshe she ye, kashe œ sœ ɓata tshe ro tɔ la owo. ");
INSERT INTO mnh_vpl VALUES ("C13_16","076_3_16","1CO","3","16","16","'E wusœ nœ dœ ɔtshɔnœ adœke e'e kœdœ Tepelo nœ Ndjaba, yé Ɨshirɨ nœ Ndjaba sœ lœ 'e. ");
INSERT INTO mnh_vpl VALUES ("C13_17","076_3_17","1CO","3","17","17","Œdœ uzu kœndɨ tshelœ Tepelo nœ Ndjaba, Ndjaba œ ndɨ ndje tshelœ ye. Gbambanœ nene, Tepelo nœ Ndjaba sœ yerœ, yé e'e dá dœ Tepelonœ asœmœ. ");
INSERT INTO mnh_vpl VALUES ("C13_18","076_3_18","1CO","3","18","18","Uzu bale fafaratœ ye nene. Œdœ anga uzu ugurutœ 'e bale kœsœ kœgbe adœke œne sœ dœ kœwusœtœ waa dœ mara nœ tshapashɔ asœ, iyi za she mbœrœ adœke tshe sœ adja dœ kœwusœtœ. ");
INSERT INTO mnh_vpl VALUES ("C13_19","076_3_19","1CO","3","19","19","Gbambanœ nene, kœwusœtœ dœ mara nœ tshapashɔ asœke kœdœ agba o'o tœ ala Ndjaba. Mbœrœ tœnœ ataa, endje sú ɓala buku nœ Ndjaba adœke: «Ndjaba sœ kœgbɔ aayi kœwusœtœ lœ afara nœ endje dœ tœ endje.» ");
INSERT INTO mnh_vpl VALUES ("C13_20","076_3_20","1CO","3","20","20","Buku nœ kpa sœ kœpa adœke: «Gbozu wusœ gbetshelœ nœ ayi kœwusœtœ ye, tshe wusœ nœ adœke œ gugu dœ ádá bale nene.» ");
INSERT INTO mnh_vpl VALUES ("C13_21","076_3_21","1CO","3","21","21","Ataa, uzu bale dudu okoro ye ga pa azu nene, mbœrœ œrœ kɔ kœdœ œnœ 'e: ");
INSERT INTO mnh_vpl VALUES ("C13_22","076_3_22","1CO","3","22","22","Œdœ Polo, œdœ Apolo too Petro, œdœ tshapashɔ, œdœ soro, œdœ kuzu, œdœ œrœ á sœ ngɔngɔ asœke, œdœ œrœ á sœ bala mbatsha, kɔkɔ kœdœ œnœ 'e. ");
INSERT INTO mnh_vpl VALUES ("C13_23","076_3_23","1CO","3","23","23","Kashe e'e nœ 'e kœdœ azu nœ Kristu, yé Kristu kœdœ uzu nœ Ndjaba. ");
INSERT INTO mnh_vpl VALUES ("C14_1","076_4_1","1CO","4","1","1","Ataa, œ li adœke 'e wu 'a ɓata aayi akwa nœ Kristu œdœ ɓata endje á endje sœ mbœrœ kœgbɔndœ adja o'o nœ Ndjaba á zatœ ye yiwa tœnœ. ");
INSERT INTO mnh_vpl VALUES ("C14_2","076_4_2","1CO","4","2","2","Andaa, œrœ kɔ á endje sœ kœyɔndœ nœ ɓa ndœ aayi kœgbɔndœrœ, kœdœ kœmbœrœtœ osho lindœ nœ. ");
INSERT INTO mnh_vpl VALUES ("C14_3","076_4_3","1CO","4","3","3","Tœ œmœ, œdœ e'e too anga azu kœwa ngbanga pa mœ, œ mbœrœ œrœ tœ mœ nene. Gapa nœ, mœ wa ngbanga nœ mœ dœ tœ mœ nene. ");
INSERT INTO mnh_vpl VALUES ("C14_4","076_4_4","1CO","4","4","4","Dœ adjapu, gbetshelœ nœ mœ sœsœ kœgbagbara mœ tœ œrœ bale nene, kashe œ dœ́dœ́ œtœnœ dá sœ kœma adœke mœ sœ ndjii nene. Tsheneke á tshe wa ngbanga nœ mœ kœdœ Gbozu. ");
INSERT INTO mnh_vpl VALUES ("C14_5","076_4_5","1CO","4","5","5","Mbœrœ tœnœ ataa, 'e wawa ngbanga ga pa uzu utshu nœ lɔkɔ kœwa ngbanga nene. 'E kate adœke Gbozu na yeka. Œshe dá ma œneke kɔ á zatœ endje yiwa tœnœ œdœ gbetshelœ á sœ ɓa lɔsu azu ngbɨ ga ushu. Dœ tœnœ ataa, uzu dœ uzu œ gbɔ kœdonga osho nœ Ndjaba á kwatœ endje ga ndœ ye. ");
INSERT INTO mnh_vpl VALUES ("C14_6","076_4_6","1CO","4","6","6","Alaya mœ, mœ pa o'onœ asœmœ tœ upu nœ mœ œdœ tœ upu nœ Apolo mbœrœ adœke œ yisœ œrœ fœ 'e. Mœ yindœ nœ adœke lœ awa nœ kœmarœ nœ 'a, 'e wusœ ádá awa o'onœ asœ: «Œ li adœke 'e ka kpœpa mapaka neke á endje sú», yé 'e dudu okoro 'e kolœ pa uzu bale nene, yé œ yiangba anga nene. ");
INSERT INTO mnh_vpl VALUES ("C14_7","076_4_7","1CO","4","7","7","Gbambanœ nene, ɓœ ropa uzu ɗe? Œ dœ́dœ́ Ndjaba dá to œrœ á ɓœ sœ dœ tœnœ fœ ɓœ nene a? Yé á kœdœ Ndjaba dá to fœ ɓœ, mbœrœ gaɗe á ɓœ sœ kœdu okoro zœ ɓata ɓœ gbɔgbɔ ɓa ndœ ye nene a? ");
INSERT INTO mnh_vpl VALUES ("C14_8","076_4_8","1CO","4","8","8","E'e, 'e gbɔ œnœ 'e œrœ kɔ á 'e gbe dœ tœnœ ye! 'E te œnœ 'e aayi kœgbɔrœ ye! Ataa 'a dœ́dœ́ agbozugo nene, 'e te œnœ 'e agbozugo ye! Adjapu dœ mœ a? 'A yindœ nœ adœke 'e dœ adja agbozugo mbœrœ á ɨ'ɨrɨ 'a kœto ndje dœ 'e awa bale. ");
INSERT INTO mnh_vpl VALUES ("C14_9","076_4_9","1CO","4","9","9","Gbambanœ nene, mœ sœ kœgbe adœke Ndjaba ko 'a dœ aayi avwa tɔ ɓa tœ ndɔngɔlɔ azu kɔ: 'a sœ ɓata azu á endje wa agbɔ ngbanga nœ kuzu ga tœ endje, endje fa 'a tœ œrœ mɔlɔ nœ tshapashɔ, ɓa tœ ala aandjelu œdœ ɓa tœ ala azu kɔ. ");
INSERT INTO mnh_vpl VALUES ("C14_10","076_4_10","1CO","4","10","10","Anga azu sœ kœwu 'a tœ aayi iyi mangba Kristu, kashe e'e, 'e sœ kœzatœ 'e ɓata aayi kœwusœtœ lœ kœngbɔtœ 'e bale dœ Kristu. Anga azu sœ kœwu adœke 'a mɔɔmɔ, kashe e'e, 'e sœ kœzatœ 'e tœ aayi gbɔgbɔ. Endje sœ kœlɨsœ 'e, kashe œ sœ kœwu 'a tœ ayi odo. ");
INSERT INTO mnh_vpl VALUES ("C14_11","076_4_11","1CO","4","11","11","Lœ ada ɔlɔnœ asœ, 'a sœ kœwu oyo dœ ogo kœzɨrœ œdœ dœ ogo ungu, 'a gugu dœ lœba nene, endje sœ kœɓi 'a, 'a na yame yame djezœ; ");
INSERT INTO mnh_vpl VALUES ("C14_12","076_4_12","1CO","4","12","12","'a sœ kœwu djofele dœ akwa dœ kane 'a yeka á gbɔ kœzɨrœ. Œdœ endje kœgu 'a, 'a sœ kœgi ɔtshɔ o'o. Lɔkɔ á endje kœsœ kœmbœrœ œrœ kanga fœ 'a, 'a sœ kœru lɔsu 'a. ");
INSERT INTO mnh_vpl VALUES ("C14_13","076_4_13","1CO","4","13","13","Lɔkɔ á endje kœsœ kœpa ekpe o'o nœ 'a, 'a sœ kœgi o'o dœ ɔtshɔ lɔsu. Ngɔngɔ asœke, endje kpa wu 'a ɓata tshapandikɔ nœ tshapashɔ, ɓata uyu œrœ nœ tshapashɔ. ");
INSERT INTO mnh_vpl VALUES ("C14_14","076_4_14","1CO","4","14","14","Mœ sœsœ kœsu mbeti asœmœ mbœrœ kœza tshula fœ 'e nene, kashe mœ su mbœrœ kœgbota tshelœ utu 'e ɓata agbolo nœ mœ á mœ yindœ endje waa. ");
INSERT INTO mnh_vpl VALUES ("C14_15","076_4_15","1CO","4","15","15","Gbambanœ nene, ataa œdœ 'e kœsœ dœ aayi kœyisœ o'o nœ Kristu kutu ndjokpa gbaa, 'e sœ kolœ dœ aba tshebabale. Œmœ dá zu 'e lœ Yisu Kristu lœ awa nœ kœyisœ Ɔtshɔ O'o fœ 'e. ");
INSERT INTO mnh_vpl VALUES ("C14_16","076_4_16","1CO","4","16","16","Mœ sœ kœkɨ fœ 'e adœke 'e mbœrœtœ 'e lindœ mara kœmbœrœtœ nœ mœ. ");
INSERT INTO mnh_vpl VALUES ("C14_17","076_4_17","1CO","4","17","17","Mbœrœ tœnœ ataa dá mœ vwa Timote fœ 'e, gbolo nœ mœ á mœ yindœ ye waa yé á tshe sœ kœzatœ ye fœ Gbozu. Tshe kpa yi bala sœ awa akwa nœ soro nœ mœ ga ndœ Kristu fœ 'e ɓata á mœ sœ kœyisœ nœ tœ osho kɔ œdœ pe djelœ Ikrizia kɔ. ");
INSERT INTO mnh_vpl VALUES ("C14_18","076_4_18","1CO","4","18","18","Andaa, anga azu ugurutœ 'e gbe adœke mœ na nene, yé mbœrœ tœnœ ataa á endje sœ kœdu okoro endje. ");
INSERT INTO mnh_vpl VALUES ("C14_19","076_4_19","1CO","4","19","19","Kashe œdœ Gbozu kœyindœ nœ, mœ na lœ ondonœ asœke kœwu 'e zœ. Dœ tœnœ ataa, mœ para adœke mœ tondœ kolœ o'o nœ aayi kœdu okoro endje asœmœ nene, kashe mœ para ndje awa kœwu mara akwa á endje sœ kœmbœrœ tœnœ. ");
INSERT INTO mnh_vpl VALUES ("C14_20","076_4_20","1CO","4","20","20","Gbambanœ nene, Ogo gbozu nœ Ndjaba dœ́dœ́ o'o nœ tshelœ ama nene, kashe tœnœ kœdœ kœmbœrœ akwa dœ gbɔgbɔ nœ Ndjaba. ");
INSERT INTO mnh_vpl VALUES ("C14_21","076_4_21","1CO","4","21","21","Œrœ gaɗe dá 'e gbe dœ tœnœ a? 'E yindœ nœ adœke mœ na ga ndœ 'e dœ ndjapa too dœ ɔmɔ lɔsu a? ");
INSERT INTO mnh_vpl VALUES ("C15_1","076_5_1","1CO","5","1","1","Azu sœ kœpa tœ osho kɔ adœke anga o'o bale tœ upu nœ angba budu, angba budu neke á endje lili kœgbɔ tœnœ ɓa ndœ angbɨ azu nene: anga yanga 'e bale sœ kœlo dœ awo abanœ. ");
INSERT INTO mnh_vpl VALUES ("C15_2","076_5_2","1CO","5","2","2","Yé 'e sœ kœdu okoro 'e tɔpanœ kpuru! Œ li má adœke 'e sœ dœ oyo tœ lɔsu 'e yé œ gɔrɔ má ayi kœmbœrœ œrœnœ asœmœ ugurutœ 'e. ");
INSERT INTO mnh_vpl VALUES ("C15_3","076_5_3","1CO","5","3","3","Tœ œmœ nœ mœ, mœ gugu ugurutœ 'e dœ undu mœ nene kashe mœ sœ dœ 'e ngɔngɔnœ asœke bale lœ ɨshirɨ, yé mœ wa ngbanga nœ uzu á tshe mbœrœ mara œrœnœ asœmœ ɓata mœ sœ má lima tœ œsœnœ zœ: ");
INSERT INTO mnh_vpl VALUES ("C15_4","076_5_4","1CO","5","4","4","lɔndɔ á 'e kœngbɔtœ 'e ga tœnœ yé á mœ sœ ugurutœ 'e lœ ɨshirɨ, 'e wa ngbanganœ asœmœ lœ gbɔgbɔ nœ Gbozu nœ azœ dœ Yisu, ");
INSERT INTO mnh_vpl VALUES ("C15_5","076_5_5","1CO","5","5","5","dœ mara adœke 'e za uzu ataa fœ Satana mbœrœ adœke undu ye ndɨ, yeka á ɨshirɨ ye kœshe dœ lɔkɔ á Gbozu œ wa dœ ngbanga. ");
INSERT INTO mnh_vpl VALUES ("C15_6","076_5_6","1CO","5","6","6","Ádá nœ kœdu okoro 'e gugu nene. 'E wuwusœ nœ dœ ɔtshɔnœ adœke ɔyɔ kœsuku mapa kœsœ teasho, œ suku kœdjanga mapa djigi nene a? ");
INSERT INTO mnh_vpl VALUES ("C15_7","076_5_7","1CO","5","7","7","'E gitœ 'e lœ ongboro ɔyɔ kœsuku mapa yé œ te tafo mapa, mbœrœ ɔyɔ kœsuku mapa gugu lœ 'e nene. Gbambanœ nene, Kristu á tshe dœ Aya pata Pake nœ azœ, endje za lima she tœ tokóró. ");
INSERT INTO mnh_vpl VALUES ("C15_8","076_5_8","1CO","5","8","8","Ataa, a mbœmbœrœ angbo nœ azœ dœ mapa á suku dœ ongboro ɔyɔ kœsuku mapa too dœ ɔyɔ kœsuku mapa nœ ngbɨndɨrœ nene, kashe a mbœrœ tœnœ dœ mapa neke á gugu dœ ɔyɔ kœsuku mapa lœnœ nene, œneke á sœ yerœ œdœ lœ adjapu. ");
INSERT INTO mnh_vpl VALUES ("C15_9","076_5_9","1CO","5","9","9","Ɓala mbeti á mœ su utshunœ, mœ su o'o fœ 'e adœke 'e sœsœ tœ œsœnœ bale dœ azu á endje sœ kœmbœrœ angba budu nene. ");
INSERT INTO mnh_vpl VALUES ("C15_10","076_5_10","1CO","5","10","10","Mœ gbegbe lima ga pa azu kɔ pa ɔshɔ á endje sœ kœmbœrœ angba budu, á endje sœ dœ tshalɔsu, á endje dœ aayi angba too aayi kœdonga andjaba nene. Œ kœsœ má ataa, œ li má adœke 'e gi tœ 'e pa tshapashɔ asœke ye. ");
INSERT INTO mnh_vpl VALUES ("C15_11","076_5_11","1CO","5","11","11","Mœ su ga la mbetinœ fœ 'e adœke 'e ngbɔngbɔtœ 'e dœ uzu á tshe za ɨ'ɨrɨ Kristu ga pa ye, yé á dœ ayi angba budu, aayi tshalɔsu, aayi kœdonga andjaba, aayi kœpa o'o nœ wala, amœndjondjo too aayi angba nene. Œ lili adœke 'e zɨ œrœ tœ œsœnœ dœ mara uzu ataa nene. ");
INSERT INTO mnh_vpl VALUES ("C15_12","076_5_12","1CO","5","12","12","Yé upu nœ mœ kœdœ adœke mœ wa ngbanga nœ azu á endje sœ ɓa ushu a? Œ̃ œ̃ nene. Kashe, œ dœ́dœ́ azu nœ Kristu dá 'e li má kœwa ngbanga nœ endje nene a? ");
INSERT INTO mnh_vpl VALUES ("C15_13","076_5_13","1CO","5","13","13","Ndjaba dá wa bala ngbanga nœ azu tshashu. 'E gɔrɔ hawo uzu ugurutœ 'e ye. ");
INSERT INTO mnh_vpl VALUES ("C16_1","076_6_1","1CO","6","1","1","Lɔkɔ á 'e kœsœ dœ o'o ugurutœ 'e, mbœrœ gaɗe á 'e sœ kœgbe kœna kœtɔ meza ɓa ndœ ayingba Ndjaba adœke endje wa ngbanganœ, yé á tshapu kœna ga ndœ ayerœ azu a? ");
INSERT INTO mnh_vpl VALUES ("C16_2","076_6_2","1CO","6","2","2","E wuwusœ nœ adœke azu á endje sœ yerœ œ wa bala ngbanga nœ azu tshapashɔ asœke nene a? Yé á kœsœ adœke 'e wa ngbanga nœ azu tshapashɔ, 'e li kœwa ngbanga nœ o'o á sœ dœ ádá teasho nene a? ");
INSERT INTO mnh_vpl VALUES ("C16_3","076_6_3","1CO","6","3","3","'E wuwusœ nœ adœke a wa bala ngbanga nœ aandjelu nene a, yeka á kœdœ tœ o'o nœ soro asœ a? ");
INSERT INTO mnh_vpl VALUES ("C16_4","076_6_4","1CO","6","4","4","Andaa, lɔkɔ á 'e kœsœ dœ mara ngbanga ataa, 'e sœ kœpandœ nœ fœ angbɨ azu á endje gugu lœ Ikrizia nene adœke endje wa o'onœ a? ");
INSERT INTO mnh_vpl VALUES ("C16_5","076_6_5","1CO","6","5","5","Mœ sœ kœpa tœnœ mbœrœ kœza tshula fœ 'e. Ataa, anga uzu kœwusœrœ á tshe li kœwa ngbanga ugurutœ aayazu gugu ugurutœ 'e nene a? ");
INSERT INTO mnh_vpl VALUES ("C16_6","076_6_6","1CO","6","6","6","Kashe, œ li adja adœke anga yazu bale pa ngbanga dœ ayanœ ɓa utshu ayingba Ndjaba ye a? ");
INSERT INTO mnh_vpl VALUES ("C16_7","076_6_7","1CO","6","7","7","Œ sœ adjapu adœke kœpa ngbanga ugurutœ 'e sœ kœma adœke 'e yo ye. Mbœrœ gaɗe á 'e wuwusœ kœru lɔsu 'e tœ œrœ á sœsœ ndjii nene, tœ œsœnœ adœke 'e pa ngbanga dœ aaya 'e a? Mbœrœ gaɗe á 'e kakatœ nœ adœke endje ko œrœ tœ 'e nene a? ");
INSERT INTO mnh_vpl VALUES ("C16_8","076_6_8","1CO","6","8","8","Kashe e'e dá sœ kœmbœrœ œrœ á sœsœ ndjii nene, yé á sœ kœko œrœ tœ anga azu. 'E sœ kœmbœrœ ataa ga tœ aaya 'e! ");
INSERT INTO mnh_vpl VALUES ("C16_9","076_6_9","1CO","6","9","9","'E wuwusœ nœ adœke azu á endje sœ kœmbœrœ œrœ á sœsœ ndjii nene œ gbɔ bala Ogo gbozu nœ Ndjaba nene a? Uzu fafara 'e nene! Œdœ aayi angba budu, œdœ aayi kœdonga andjaba, œdœ aayi kœpara awo azu, œdœ ayakoshe á endje sœ ɓata ayashe, œdœ ayakoshe too ayashe á endje sœ kœlo dœ anga endje, ");
INSERT INTO mnh_vpl VALUES ("C16_10","076_6_10","1CO","6","10","10","œdœ aayi angba, œdœ aayi tshalɔsu, œdœ amœndjondjo, œdœ aayi kœpa o'o nœ wala, œdœ agbangba kœzɨ angba, uzu bale œ gbɔ Ogo gbozu nœ Ndjaba nene. ");
INSERT INTO mnh_vpl VALUES ("C16_11","076_6_11","1CO","6","11","11","'E wu mara á anga anga 'e sœ lima dœ tœnœ ugurutœ 'e dœ mœ. Kashe Ndjaba nœ azœ djutɔ 'e, tshe fa 'e tœ ayerœ azu, tshe fa 'e tœ azu ndjii lœ ɨ'ɨrɨ Gbozu Yisu Kristu œdœ pe lœ awa Ɨshirɨ nœ ye. ");
INSERT INTO mnh_vpl VALUES ("C16_12","076_6_12","1CO","6","12","12","Anga azu ugurutœ 'e sœ kœpa adœke: «Endje papakata mœ tœ œrœ bale nene», kashe œ dœ́dœ́ œrœ kɔ dá sœ dœ ɔtshɔnœ nene. Mœ li má kœpa adœke: «Endje papakata mœ tœ œrœ bale nene», kashe mœ yiyindœ nœ adœke mœ te kanga nœ œrœ bale nene. ");
INSERT INTO mnh_vpl VALUES ("C16_13","076_6_13","1CO","6","13","13","'E sœ kœpa adœke: «Rœgo sœ mbœrœ uvu, yé uvu sœ mbœrœ rœgo.» Œ sœ adjapu, kashe Ndjaba œ ndɨ tshelœ nœ kɔ bibisha ye. Kashe undu uzu sœsœ mbœrœ angba budu nene. Undu uzu sœ mbœrœ Gbozu, yé Gbozu sœ mbœrœ undu uzu. ");
INSERT INTO mnh_vpl VALUES ("C16_14","076_6_14","1CO","6","14","14","Andaa Ndjaba á tshe she Gbozu lœ akuzu, tshe she ndje azœ bala lœ akuzu dœ gbɔgbɔ nœ ye. ");
INSERT INTO mnh_vpl VALUES ("C16_15","076_6_15","1CO","6","15","15","'E wuwusœ nœ adœke undu 'e kœdœ œrœ kotœ undu Yisu Kristu nene a? Mœ lii kœza œrœ kotœ undu Yisu bale adœke mœ fa tœ œrœ kotœ undu gugatɨ ye a? Adja mœ mbœrœ ataa bale nene! ");
INSERT INTO mnh_vpl VALUES ("C16_16","076_6_16","1CO","6","16","16","'E wuwu ndje sœ nœ adœke uzu á tshe kœngbɔtœ ye bale dœ gugatɨ, endje wuta dœ she undu bale nene a? Gbambanœ nene, endje sú ɓala buku nœ Ndjaba adœke: «Endje bibisha œ wuta uzu bale.» ");
INSERT INTO mnh_vpl VALUES ("C16_17","076_6_17","1CO","6","17","17","Kashe uzu á tshe ngbɔtœ ye bale dœ Gbozu, endje ngbɔtœ endje dœ she bale lœ ɨshirɨ. ");
INSERT INTO mnh_vpl VALUES ("C16_18","076_6_18","1CO","6","18","18","'E kpa awa angba budu. Anga ekperœ kɔ á uzu œ mbœrœ, sœ ɓa ushu tœ undu ye. Kashe ayi angba budu sœ kœndɨ undu ye dœ tœ ye. ");
INSERT INTO mnh_vpl VALUES ("C16_19","076_6_19","1CO","6","19","19","'E wuwusœ nœ adœke undu 'e kœdœ Tepelo nœ Ɔtshɔ Ɨshirɨ dá sœ lœ 'e asœmœ nene a? Œ dœ́dœ́ Ndjaba dá to fœ 'e nene a? Yé e'e kœdœ ayengɔ undu 'e a? ");
INSERT INTO mnh_vpl VALUES ("C16_20","076_6_20","1CO","6","20","20","Ndjaba yɔɔyɔ 'e œ yɔ. Ataa, œ li adœke 'e donga she dœ undu 'e. ");
INSERT INTO mnh_vpl VALUES ("C17_1","076_7_1","1CO","7","1","1","Ngɔngɔ asœke, mœ yindœ kœgi o'o tœ upu á 'e yu lima mœ dœ tœnœ la mbeti nœ 'e adœke: «Œ sœ dœ ɔtshɔnœ adœke yakoshe lolo dœ yashe nene.» ");
INSERT INTO mnh_vpl VALUES ("C17_2","076_7_2","1CO","7","2","2","Andaa, ndœ kœkatœ kœmbœrœ œrœ tshula kɔ, œ li dœ ɔtshɔnœ adœke yakoshe bale dœ bale sœ dœ awonœ, yé yashe ndje bale dœ bale sœ dœ akɔnœ. ");
INSERT INTO mnh_vpl VALUES ("C17_3","076_7_3","1CO","7","3","3","Œ li adœke yakoshe mbœrœ akwa tsha yakoshe nœ ye ga tœ awonœ, yé yashe ndje awa bale, tshe mbœrœ akwa tsha yashe nœ ye ga tœ akɔnœ. ");
INSERT INTO mnh_vpl VALUES ("C17_4","076_7_4","1CO","7","4","4","Yashe lili kœmbœrœ œneke á tshe yindœ nœ ga tœ undu ye dœ tœ ye nene, undu ye sœ mbœrœ akɔnœ. Awa bale ndje, yakoshe lili kœmbœrœ œneke á tshe yindœ nœ ga tœ undu ye dœ tœ ye nene, undu ye sœ mbœrœ awonœ. ");
INSERT INTO mnh_vpl VALUES ("C17_5","076_7_5","1CO","7","5","5","'E kukurutshelœtœ 'e pa gbarœ olo nene, kolœnœ adœke 'e kœdjitœ 'e awa bale ndœ olo teasho mbœrœ kœza avwala yekane. Kashe manda nœ, 'e kwatœ 'e ga pa gbarœ olo 'e. Ete nene, 'e li kœru lɔsu 'e nene yé œ za awa fœ Satana adœke tshe wu lɔsu 'e. ");
INSERT INTO mnh_vpl VALUES ("C17_6","076_7_6","1CO","7","6","6","O'onœ á mœ sœ kœpa fœ 'e asœmœ, œ dœ́dœ́ adœke mœ sœ kœshosho 'e nene, kashe tœnœ kœdœ œrœ á 'e gbe dœ tœnœ á mœ li kœyindœ nœ. ");
INSERT INTO mnh_vpl VALUES ("C17_7","076_7_7","1CO","7","7","7","Mœ yi má ndœ nœ adœke uzu kɔ sœ tœ angara ɓata mœ; kashe Ndjaba sœ kœto kœtorœ fœ uzu dœ uzu kpi tœ œnœ yanga, œneke asœ fœ anga, œneke ɓa 'e fœ angbɨ anga. ");
INSERT INTO mnh_vpl VALUES ("C17_8","076_7_8","1CO","7","8","8","Ataa, mœ sœ kœpa fœ aangara œdœ pe fœ ayashe koya adœke: œ sœ dœ ɔtshɔnœ adœke endje sœpe ataa, ɓata mœ. ");
INSERT INTO mnh_vpl VALUES ("C17_9","076_7_9","1CO","7","9","9","Kashe œdœ endje kœlili kœru lɔsu endje nene, endje totœ endje. Gbambanœ nene, œ sœ dœ ɔtshɔnœ kœro panœ kœtotœ endje tœ œsœnœ adœke undu ndɨ dœ ogo nœ ɔkɔ. ");
INSERT INTO mnh_vpl VALUES ("C17_10","076_7_10","1CO","7","10","10","Tœ upu nœ endjeneke á endje totœ endje ye, mœ za awa o'o á toto ɓa ndœ mœ nene kashe á to ɓa ndœ Gbozu, fœ endje adœke: œ lili adœke yashe kurutshelœtœ ye dœ akɔnœ nene. ");
INSERT INTO mnh_vpl VALUES ("C17_11","076_7_11","1CO","7","11","11","Œdœ tshe kœkurutshelœtœ ye dœ akɔnœ, œ li adœke tshe kpa i anga yakoshe nene, too œ li adœke tshe kpa djitœ ye dœ akɔnœ. Yé œ lili ndje adœke yakoshe gɔrɔ awonœ nene. ");
INSERT INTO mnh_vpl VALUES ("C17_12","076_7_12","1CO","7","12","12","Tœ upu nœ anga endje, œmœ dœ tœ mœ dá sœ kœpa tœnœ kashe œ dœ́dœ́ Gbozu nene, adœke: œdœ yakoshe bale á tshe dœ yindœ Ndjaba kœto yashe á tshe dœ́dœ́ yindœ Ndjaba nene, yé á yashenœ yindœ kœsœ dœ she, tshe gɔgɔrɔ she nene. ");
INSERT INTO mnh_vpl VALUES ("C17_13","076_7_13","1CO","7","13","13","Yé œdœ anga yashe bale á tshe dœ yindœ Ndjaba kœi ndje yakoshe á tshe dœ́dœ́ yindœ Ndjaba nene yé á yakoshenœ yindœ kœsœ dœ she, tshe vwavwaratœ ye tœ ye nene. ");
INSERT INTO mnh_vpl VALUES ("C17_14","076_7_14","1CO","7","14","14","Gbambanœ nene, yakoshe á tshe dœ́dœ́ yindœ Ndjaba nene, tshe wuta ndoo dœ Ndjaba mbœrœ awonœ á tshe dœ yindœ Ndjaba. Awa ndje bale dœ yashe á tshe dœ́dœ́ yindœ Ndjaba nene, tshe wuta ndje ndoo dœ Ndjaba mbœrœ akɔnœ á tshe dœ yindœ Ndjaba. Œ kœsœsœ má atamœ nene, agbolo nœ 'e œ sœ má yerœ nene andaa endje sœ yerœ. ");
INSERT INTO mnh_vpl VALUES ("C17_15","076_7_15","1CO","7","15","15","Kashe œdœ tsheneke á tshe dœ́dœ́ yindœ Ndjaba nene kœyindœ kœkurutshelœtœ ye dœ yindœ Ndjaba á endje totœ endje dœ she, endje katœ ye tshe wuta kolœnœ. Dœ mara o'o ataa, ayindœ Ndjaba á endje totœ endje, œdœ yakoshe too yashe, uzu kaka pa endje nene, mbœrœ Ndjaba e 'e adœke 'e sœ gee lœ soro 'e. ");
INSERT INTO mnh_vpl VALUES ("C17_16","076_7_16","1CO","7","16","16","Yé œɓœ dœ yashe, dœ mara gaɗe dá ɓœ she akɔ zœ a? Too œɓœ ndje dœ yakoshe, dœ mara gaɗe dá ɓœ she awo zœ a? ");
INSERT INTO mnh_vpl VALUES ("C17_17","076_7_17","1CO","7","17","17","Andaa, œ li adœke uzu dœ uzu mbœrœtœ ye lindœ kœtorœ á Gbozu to fœ she, yé á tshe sœ lœnœ lɔkɔ á Ndjaba e lima she. Œneke á mœ sœ kœpandœ nœ lœ Ikrizia kɔ dœmœ. ");
INSERT INTO mnh_vpl VALUES ("C17_18","076_7_18","1CO","7","18","18","Œdœ endje kœwa lima anga uzu bale tœ gaza dœ lɔkɔ á Ndjaba e she, tshe papara awa kœmbœrœ adœke œ yiwa nene. Yé œdœ tsheneke á endje kœwawa lima she tœ gaza utshunœ adœke Ndjaba e she nene, œ lili adœke endje wa she nene. ");
INSERT INTO mnh_vpl VALUES ("C17_19","076_7_19","1CO","7","19","19","Kœwa gaza too kœwawa gaza nene, œ gugu dœ ádá bale nene, kolœnœ adœke 'e mbœrœtœ 'e lindœ awa o'o nœ Ndjaba. ");
INSERT INTO mnh_vpl VALUES ("C17_20","076_7_20","1CO","7","20","20","Œ li adœke uzu dœ uzu sœ kolœ lœ mara á tshe sœ lima dœ tœnœ lɔkɔ á Ndjaba e she. ");
INSERT INTO mnh_vpl VALUES ("C17_21","076_7_21","1CO","7","21","21","Œɓœ kœdœ lima kanga lɔkɔ á Ndjaba e ɓœ a? Tɔtɔ lɔsu zœ nene. Kashe œdœ awa kœsœ zœ adœke ɓœ wuta lœ kanga, mbœrœtœ zœ lindœ nœ. ");
INSERT INTO mnh_vpl VALUES ("C17_22","076_7_22","1CO","7","22","22","Gbambanœ nene, kanga á Gbozu e she kœdœ uzu á tshe kpa dœ́dœ́ kanga nene yé tshe te uzu nœ Gbozu. Awa bale ndje dœ uzu á tshe dœ́dœ́ kanga nene yé á Ndjaba e lima she, œshe kœdœ kanga nœ Kristu. ");
INSERT INTO mnh_vpl VALUES ("C17_23","076_7_23","1CO","7","23","23","Ndjaba yɔ lima 'e lœ kanga ye; 'e tete akanga nœ azu nene. ");
INSERT INTO mnh_vpl VALUES ("C17_24","076_7_24","1CO","7","24","24","Aaya mœ, œ li adœke uzu dœ uzu sœpe tœ ala Ndjaba kolœ ɓata á tshe sœ lima utshunœ lɔkɔ á tshe e she. ");
INSERT INTO mnh_vpl VALUES ("C17_25","076_7_25","1CO","7","25","25","Tœ upu nœ aangara, Gbozu kakatœ awa o'o tɨ fœ mœ nene, kashe mœ sœ kœza gbetshelœ nœ mœ ɓata uzu á tshe zatœ ye ndjii, mbœrœ Gbozu ma ɔtshɔ lɔsu nœ ye ga ndœ mœ. ");
INSERT INTO mnh_vpl VALUES ("C17_26","076_7_26","1CO","7","26","26","Mbœrœ oyo nœ ngɔngɔ asœke, œneke á mœ sœ kœgbe tœnœ dœke: œ sœ dœ ɔtshɔnœ adœke uzu dœ uzu sœ kolœnœ ɓata á tshe sœ asœmœ. ");
INSERT INTO mnh_vpl VALUES ("C17_27","076_7_27","1CO","7","27","27","Œdœ ɓœ kœto yashe ye, papara adœke ɓœ kurutshelœtœ zœ dœ she nene. Œdœ ɓœ kœtoto yashe nene, papara ndje adœke ɓœ to yashe nene. ");
INSERT INTO mnh_vpl VALUES ("C17_28","076_7_28","1CO","7","28","28","Kashe œdœ ɓœ kœto yashe, ɓœ mbœmbœrœ ekperœ nene. Yé œdœ ovoro yawuru kœi yakoshe, tshe mbœmbœrœ ndje ekperœ nene. Kashe endje á endje totœ endje asœmœ, endje gbɔ kœndanga osho lœ soro nœ endje œnœ ɔkɔ, yé œmœ, mœ yi má ndœ kœgbɔndœ 'e mbœrœ tœnœ. ");
INSERT INTO mnh_vpl VALUES ("C17_29","076_7_29","1CO","7","29","29","Aaya mœ, o'o á mœ yindœ kœpa fœ 'e dœke: a kpa sœsœpe dœ olo ndjoro nene. Kœto ngɔngɔnœ asœke, œ li adœke endjeneke á endje to ayashe, endje sœ ɓata endje gugu dœ ayashe nene; ");
INSERT INTO mnh_vpl VALUES ("C17_30","076_7_30","1CO","7","30","30","endjeneke á endje sœ tœ ɨkɨ, endje sœ ɓata endje sœsœ tœ ɨkɨ nene; endjeneke á endje sœ dœ yanga, endje sœ ɓata endje gugu dœ yanga nene; endjeneke á endje sœ kœyɔ œrœ, endje sœ ɓata endje gugu dœ tœnœ nene. ");
INSERT INTO mnh_vpl VALUES ("C17_31","076_7_31","1CO","7","31","31","Œ li adœke azu á endje sœ kœshe mbœrœ œrœ nœ tshapashɔ asœke, sœ ɓata endje sheshe mbœrœ tœnœ nene. Gbambanœ nene, tshapashɔnœ ɓata á sœ asœ, œndœnœ œ dɨ nene. ");
INSERT INTO mnh_vpl VALUES ("C17_32","076_7_32","1CO","7","32","32","Mœ yiyindœ nœ adœke 'e sœ dœ gbetshelœ nene. Tsheneke á tshe toto yashe nene, tshe sœ kœzatœ ye ga tœ akwa nœ Gbozu: Tshe sœ kœpara adœke œne mbœrœ œrœ á sœ kœza yanga fœ Gbozu. ");
INSERT INTO mnh_vpl VALUES ("C17_33","076_7_33","1CO","7","33","33","Kashe tsheneke á tshe to yashe ye, tshe sœ kœgbe kolœ dœ œrœ nœ tshapashɔ asœke: tshe sœ kœpara adœke œne mbœrœ œrœ á sœ kœza yanga fœ awo œne. ");
INSERT INTO mnh_vpl VALUES ("C17_34","076_7_34","1CO","7","34","34","Yé dœ tœnœ ataa, lɔsu ye sœ ga pa œrœ bisha. Œ sœ ndje awa bale ataa mbœrœ yashe too ovoro yawuru á tshe i i yakoshe nene, yé á sœ kœgbe kolœ kœmbœrœ akwa nœ Gbozu mbœrœ á kœsœ yerœ lœ undu ye œdœ lœ ɨshirɨ. Kashe yashe á tshe i yakoshe, tshe sœ kœgbe dœ œrœ nœ tshapashɔ asœke yé œ sœ kœpara adœke œne mbœrœ œrœ á sœ kœza yanga fœ akɔ œne. ");
INSERT INTO mnh_vpl VALUES ("C17_35","076_7_35","1CO","7","35","35","Mœ pa o'onœ asœmœ mbœrœ ɔtshɔrœ á sœ mbœrœ 'e, kashe mœ sœsœ kœkapa 'e nene. Mœ yindœ nœ adœke 'e mbœrœ œneke á li adœke 'e sœ dœ ɔtshɔnœ, yé œ zatœ 'e djigi fœ Gbozu. ");
INSERT INTO mnh_vpl VALUES ("C17_36","076_7_36","1CO","7","36","36","Œdœ anga ovoro yakoshe kœyindœ kœto yashe, yé á endje kpa wa adœke œne totœ œne nene, endje mbœrœ dœ ɔtshɔnœ. Á ovoro yakoshenœ kœwu adœke œne sœ dœ ogo awo œne tɔpanœ kpuru, yé á wu ndje adœke œne kœtoto she nene dá œne mbœrœ ekperœ, œ sœ dœ ɔtshɔnœ adœke endje totœ endje ɓata á endje gbe dœ tœnœ. Asœmœ dœ́dœ́ ekperœ nene. ");
INSERT INTO mnh_vpl VALUES ("C17_37","076_7_37","1CO","7","37","37","Kashe œdœ ovoro yakoshenœ kœdjidji azu á endje sœ kœshosho she nene, yé á wa dœ tœ ye ɓa lɔsu ye adœke œne to koje nœ œne nene, œdœ tshe kœli kœru lɔsu ye tœ ogo ɔkɔ, tshe mbœrœ ɔtshɔrœ. ");
INSERT INTO mnh_vpl VALUES ("C17_38","076_7_38","1CO","7","38","38","Ataa, tsheneke á tshe kœto koje nœ ye, tshe mbœrœ ɔtshɔrœ. Kashe tsheneke á tshe kœvwaratœ ye kœto koje nœ ye, œshe asœmœ kpa mbœrœ ɔtshɔrœ kœrosœnœ. ");
INSERT INTO mnh_vpl VALUES ("C17_39","076_7_39","1CO","7","39","39","Yashe á tshe dœ awo uzu, sœ tœ œsœnœ dœ ɔkɔnœ lɔkɔ á tshe sœpe dœ soro. Kashe œdœ akɔnœ kœtshu ye, tshe li kœi angbɨ yakoshe á tshe yindœ ye. Œ li ndje adœke yakoshenœ dœ yindœ Kristu. ");
INSERT INTO mnh_vpl VALUES ("C17_40","076_7_40","1CO","7","40","40","Andaa, tœ mœ, mœ gbe adœke tshe sœ dœ yanga kœrosœ nœ œdœ tshe kœsœ kolœ ataa. Yé œmœ ndje, mœ wusœ nœ adœke Ɨshirɨ nœ Ndjaba sœ dœ mœ awa bale. ");
INSERT INTO mnh_vpl VALUES ("C18_1","076_8_1","1CO","8","1","1","Tœ upu nœ songba agea á endje to dœ tokóró fœ andjaba, œ sœ adjapu adœke azœ kɔ, a sœ dœ kœwusœrœ lœ nœ ɓata á 'e sœ kœpa tœnœ. Kœwusœrœ sœ kœza egerœ kumu fœ uzu, kashe kœyindœsho sœ kœto gbɔgbɔ ga ugurutœ azu. ");
INSERT INTO mnh_vpl VALUES ("C18_2","076_8_2","1CO","8","2","2","Œdœ uzu kœsœ kœgbe adœke œne wusœ œrœ waa, asœmœ sœ kœma adœke tshe wuwu damba sœ œrœ ɓata á li má adœke tshe wusœ nœ nene. ");
INSERT INTO mnh_vpl VALUES ("C18_3","076_8_3","1CO","8","3","3","Kashe tsheneke á tshe yindœ Ndjaba, Ndjaba wu ndje sœ ye yé. ");
INSERT INTO mnh_vpl VALUES ("C18_4","076_8_4","1CO","8","4","4","Ataa, a li kœzɨ songba agea á endje za tœ tokóró fœ andjaba ye a? A wusœ nœ adœke andjaba kœdœ œrœ gbambanœ pa tshapashɔ, yé anga andjaba gugu nene, kolœ Ndjaba tshebabale. ");
INSERT INTO mnh_vpl VALUES ("C18_5","076_8_5","1CO","8","5","5","Gbambanœ nene, ataa œdœ anga azu kœgbe adœke andjaba sœ ɓa lafo too ɓa pa ɔshɔ, œ sœ adjapu adœke andjaba œdœ agbozu sœ ndjoro, ");
INSERT INTO mnh_vpl VALUES ("C18_6","076_8_6","1CO","8","6","6","a wusœ nœ adœke Ndjaba sœ kolœ tshebabale. Œshe kœdœ Aba azœ á tshe mbœrœ œrœ kɔ, yé a sœ kœshe mbœrœ she. A sœ dœ Gbozu nœ azœ tshebabale Yisu Kristu. Lœ awa nœ ye dá Ndjaba mbœrœ œrœ kɔ, yé a sœ dœ soro mbœrœ she. ");
INSERT INTO mnh_vpl VALUES ("C18_7","076_8_7","1CO","8","7","7","Kashe ayindœ Kristu kɔ wuwusœ adjapunœ asœ nene. Anga endje sœpe dœ gbetshelœ nœ andjabanœ asœmœ lœ kumu endje dœ mara adœke œdœ endje kœzɨ songba agea á endje to tœ tokóró fœ andjaba, endje sœ kœgbe adœke endje to fœ adja Ndjaba, yé endje mɔ lœ gbetshelœ nœ endje. Mbœrœ tœnœ ataa, endje gbe adœke œne kœdœ aayi uburu. ");
INSERT INTO mnh_vpl VALUES ("C18_8","076_8_8","1CO","8","8","8","Andaa, œ dœ́dœ́ rœgo dá gi azœ ndoo dœ Ndjaba nene. Œdœ a kœvwaratœ azœ kœzɨ tœnœ, a sœ ga manda nœ nene. Yé œdœ a kœzɨ ndje gbaa na, a gbɔ œrœ bale nene. ");
INSERT INTO mnh_vpl VALUES ("C18_9","076_8_9","1CO","8","9","9","Kashe, 'e sœ dœ gbɔdjela adœke mara á 'e sœ kœmbœrœ dœ œrœ kɔ asœmœ, yiyi endjeneke á endje mɔɔmɔ lœ kœyindœrœ nœ endje ga lœ ekperœ nene. ");
INSERT INTO mnh_vpl VALUES ("C18_10","076_8_10","1CO","8","10","10","Gbambanœ nene, œdœ uzu á tshe mɔɔmɔ lœ kœwusœrœ nœ ye asœmœ kœwu ɓœ á ɓœ sœ dœ kœwusœrœ, yé á ɓœ li ga lœ Tepelo nœ andjaba, tshe gbɔ gbɔgbɔ nœ kœzɨ songba agea á endje to dœ tokóró fœ andjabanœ asœmœ nene a? ");
INSERT INTO mnh_vpl VALUES ("C18_11","076_8_11","1CO","8","11","11","Yé mbœrœ tœnœ ataa, kœwusœrœ nœ zœ œ ndɨ uzu á tshe mɔɔmɔ asœmœ. Kashe wusœ nœ adœke œshe kœdœ aya zœ á Kristu tshu mbœrœ she! ");
INSERT INTO mnh_vpl VALUES ("C18_12","076_8_12","1CO","8","12","12","Œdœ 'e kœmbœrœ mara ekperœ ataa ga tœ aaya 'e yé á ndɨ gbetshelœ nœ uzu á tshe mɔɔmɔ, dá 'e mbœrœ ekperœ fœ Kristu dœ tœ ye. ");
INSERT INTO mnh_vpl VALUES ("C18_13","076_8_13","1CO","8","13","13","Mbœrœ tœnœ ataa, œdœ kœzɨrœ kœsœ kœyi aya mœ ga lœ ekperœ, mœ kpa zɨ songba agea bale nene, mbœrœ á kœyiyi aya mœ ga lœ djingili nene. ");
INSERT INTO mnh_vpl VALUES ("C19_1","076_9_1","1CO","9","1","1","Œmœ kœdœ kanga a? Mœ dœ́dœ́ ayi avwa nene a? Mœ wuwu Yisu á tshe dœ́ Gbozu nœ azœ nene a? 'E dœ́dœ́ azu ndœla akwa nœ mœ lœ Gbozu nene a? ");
INSERT INTO mnh_vpl VALUES ("C19_2","076_9_2","1CO","9","2","2","Œdœ mbœrœ anga azu mœ kœdœ́dœ́ ayi avwa nene, kashe mbœrœ 'e nœ 'e, œmœ kœdœ ayi avwa. Gbambanœ nene, e'e kœdœ œrœ á sœ kœma tshambele akwa nœ mœ ɓata ayi avwa lœ Gbozu. ");
INSERT INTO mnh_vpl VALUES ("C19_3","076_9_3","1CO","9","3","3","O'o á mœ sœ kœgi fœ azu á endje sœ kœpatœ mœ dœke: ");
INSERT INTO mnh_vpl VALUES ("C19_4","076_9_4","1CO","9","4","4","'A lili má kœyɔndœ kœzɨrœ too kœndjorœ ɓa ndœ 'e nene a? ");
INSERT INTO mnh_vpl VALUES ("C19_5","076_9_5","1CO","9","5","5","'A lili má kœna dœ anga yashe á tshe dœ yindœ Kristu ɓata anga aayi avwa, aaya Gbozu œdœ pe Petro sœ kœmbœrœ tœnœ nene a? ");
INSERT INTO mnh_vpl VALUES ("C19_6","076_9_6","1CO","9","6","6","Kolœ mœ kutu mœ œdœ Barnabase dá li ndœ kœmbœrœ akwa yeka á kœzɨ œrœ a? ");
INSERT INTO mnh_vpl VALUES ("C19_7","076_9_7","1CO","9","7","7","Œɗe lœ akwa turugu dá mbœrœ akwa dœ ngendja nœ ye dœ tœ ye a? Œɗe dá lu ɔyɔ vinu, yé á zɨzɨ elenœ nene a? Too uzu ɗe dá sœ kœgbɔndœ angombe yé á ndjondjo ungu ɔngɔ endje nene a? ");
INSERT INTO mnh_vpl VALUES ("C19_8","076_9_8","1CO","9","8","8","Tœnœ kœdœ kolœ o'o nœ azu dá mœ pa asœmœ, too awa akwa sœsœ kœpa awa bale ataa nene a? ");
INSERT INTO mnh_vpl VALUES ("C19_9","076_9_9","1CO","9","9","9","Gbambanœ nene, endje sú ɓala buku nœ awa akwa nœ Moyize adœke: «Ɓœ i ama ngombe ga tœnœ nene lɔkɔ á ɓœ kœsœ kœmbœrœ she dœ akwa ble.» Ndjaba sœ kœkɨtœ œsœ angombe a? ");
INSERT INTO mnh_vpl VALUES ("C19_10","076_9_10","1CO","9","10","10","Œ dœ́dœ́ azœ dá tshe sœ kœpa o'onœ tœ azœ nene a? Adjapu, endje sú o'onœ asœmœ mbœrœ azœ. Gbambanœ nene, uzu á tshe djo kɨndɨ dœ pe tsheneke á tshe ɓi indji ngwarœ, uzu dœ uzu sœ kœmbœrœ dœ gbetshelœ nœ kœgbɔ œsœ œnœ ye. ");
INSERT INTO mnh_vpl VALUES ("C19_11","076_9_11","1CO","9","11","11","Œdœ 'a kœyi lima sœ o'o ama Ndjaba fœ 'e, œ sœ má dœ ekpenœ waa ye adœke 'a yɔndœ œrœ tœ 'e a? ");
INSERT INTO mnh_vpl VALUES ("C19_12","076_9_12","1CO","9","12","12","Œdœ anga azu kœsœ kœyɔndœ œrœ tœ 'e, mbœrœ gaɗe á a'a nene a? Andaa, 'a yɔyɔ lima ndœ œrœ nene. Kashe 'a gbɔndœtœ 'a mbœrœ á 'a kœzaza œrœ ku lœ awa Ɔtshɔ O'o nœ Kristu nene. ");
INSERT INTO mnh_vpl VALUES ("C19_13","076_9_13","1CO","9","13","13","'E wuwusœ nœ adœke azu neke á endje sœ kœmbœrœ akwa ɓa lœ anda nœ Ndjaba sœ kœgbɔ kœzɨrœ kpœtœmœ nene a? Yé endjeneke á endje sœ kœto tokóró ɓa pa ndaba, sœsœ ndje kœgbɔ œsœ œnœ endje kœzɨrœ kpœpa ndabanœ nene a? ");
INSERT INTO mnh_vpl VALUES ("C19_14","076_9_14","1CO","9","14","14","Awa bale, Gbozu za awa tœ upu nœ endjeneke á endje sœ kœpandœ Ɔtshɔ O'o adœke endje sœ ndje dœ soro mbœrœ tœnœ. ");
INSERT INTO mnh_vpl VALUES ("C19_15","076_9_15","1CO","9","15","15","Kashe œmœ, mœ zaza awa o'onœ asœmœ bale ga tœ akwa nene, yé mœ susu mbetinœ asœmœ mbœrœ kœyɔndœ œrœ nene. Mœ yi má ndœ kœtshu tœnœ, tœ œsœnœ adœke endje gbɔtœ upu nœ egerœ kumunœ asœ tœ mœ. ");
INSERT INTO mnh_vpl VALUES ("C19_16","076_9_16","1CO","9","16","16","Dœ adjapu, kœpandœ Ɔtshɔ O'o dœ́dœ́ œrœ nœ egerœ kumu ɓa ndœ mœ nene, kashe tœnœ kœdœ œrœ á li adœke mœ mbœrœ. Mœ sœ dœ oyo tœ lɔsu mœ œdœ mœ kœpapandœ Ɔtshɔ O'o nene. ");
INSERT INTO mnh_vpl VALUES ("C19_17","076_9_17","1CO","9","17","17","Œdœ mœ dœ tœ mœ dá wa lima adœke mœ mbœrœ akwanœ asœmœ, mœ yi má lima ndœ nœ adœke endje ko ngendja tshangbanœ fœ mœ ye. Kashe ɓata á endje za mœ dœ ɔgbɔ ga tœnœ, mœ mbœrœ kolœ akwa á Gbozu za fœ mœ. ");
INSERT INTO mnh_vpl VALUES ("C19_18","076_9_18","1CO","9","18","18","Ataa, ngendja tshangba akwa nœ mœ kœdœ ga ɗe? Tœnœ kœdœ kœpandœ Ɔtshɔ O'o gbambanœ á mœ sœ kœpandœ nœ, kashe mœ zaza awa o'o á Ɔtshɔ O'onœ asœmœ za fœ mœ ga tœ akwa nene. ");
INSERT INTO mnh_vpl VALUES ("C19_19","076_9_19","1CO","9","19","19","Mœ dœ́dœ́ kanga nœ uzu bale nene. Andaa, mœ zatœ mœ tœ kanga nœ azu para mbœrœ kœgbɔ azu ndjoro fœ Yisu. ");
INSERT INTO mnh_vpl VALUES ("C19_20","076_9_20","1CO","9","20","20","Mœ sœ lima kœsœ ugurutœ Ayuda ɓata Yuda mbœrœ kœgbɔ Ayuda. Ataa mœ sœsœ tshakudu awa akwa nœ Moyize nene gbaa, mœ sœ kœmbœrœtœ mœ ɓata azu á endje sœ tshakudunœ mbœrœ kœgbɔ endjeneke á endje sœ tshakudu awa akwa. ");
INSERT INTO mnh_vpl VALUES ("C19_21","076_9_21","1CO","9","21","21","Awa bale ndje, lɔkɔ á mœ kœsœ dœ endjeneke á endje sœsœ tshakudu awa akwa nene, mœ sœ kœmbœrœtœ mœ ɓata endje, kashe mœ sœsœ kœgbe dœ awa akwanœ asœmœ nene mbœrœ kœgbɔ endje. Œ yiyindœ kœpa adœke mœ wuwusœ awa akwa nœ Ndjaba nene, gbambanœ nene, mœ zatœ mœ ga tshakudu awa akwa nœ Kristu. ");
INSERT INTO mnh_vpl VALUES ("C19_22","076_9_22","1CO","9","22","22","Mœ sœ ugurutœ azu á endje mɔɔmɔ lœ kœyindœrœ ɓata œmœ ndje mœ mɔɔmɔ mbœrœ kœgbɔ endje. Mœ zatœ mœ djigi fœ endje para mbœrœ kœshe angata endje dœ mara kɔ. ");
INSERT INTO mnh_vpl VALUES ("C19_23","076_9_23","1CO","9","23","23","Yé œneke asœmœ kɔ, mœ sœ kœmbœrœ tœnœ mbœrœ Ɔtshɔ O'o yeka á kœgbɔ œrœ á to lœ awa nœ Ɔtshɔ O'onœ asœmœ. ");
INSERT INTO mnh_vpl VALUES ("C19_24","076_9_24","1CO","9","24","24","'E wuwusœ nœ adœke aayi kœkpa ɔrɔ kœkpa ɔrɔ nœ endje œrrr, kolœ anga bale dá gbɔ œrœ tshangbanœ nene a? 'E kpa ɔrɔnœ dœ mara adœke 'e wuta utshunœ. ");
INSERT INTO mnh_vpl VALUES ("C19_25","076_9_25","1CO","9","25","25","Aayi mɔlɔ kɔ sœ kœpa avwara ndœ kœgbɔ kpoto tshagbozu á ndɨ bala ye, kashe œnœ azœ kœdœ kpoto tshagbozu á ndɨ bala bale nene. ");
INSERT INTO mnh_vpl VALUES ("C19_26","076_9_26","1CO","9","26","26","Mbœrœ tœnœ ataa, œmœ, mœ sœ kœkpa ɔrɔ dœ mara ataa: mœ sœsœ kœkpa ɔrɔ nœ ayibula nene; yé mœ sœ kœdu koshe atake: mœ dudu koshe lœ angbalanœ nene. ");
INSERT INTO mnh_vpl VALUES ("C19_27","076_9_27","1CO","9","27","27","Kashe mœ sœ kœmbœrœ ɔgbɔrœ ga tœ undu mœ, yé œ sœ kœgbɔndœ nœ dœ ɔgbɔ kparawa adœke manda kœmɨndœ Ɔtshɔ O'o fœ anga azu, á Ndjaba kœvwaratœ ye tœ mœ nene. ");
INSERT INTO mnh_vpl VALUES ("C110_1","076_10_1","1CO","10","1","1","Alaya, mœ yiyindœ nœ adœke œndœ œrœ á wuta lima ga tœ alata azœ lɔndɔ nœ Moyize djedjerœ 'e nene: ondoro gbɔ lima ndœ alata azœ para, endje para kɔkɔ zu lima tɔ la egerœ ungu. ");
INSERT INTO mnh_vpl VALUES ("C110_2","076_10_2","1CO","10","2","2","Endje para gbɔ lima batisimu lœ kœngbɔtœ endje bale dœ Moyize ɓa lœ ondoro dœ pe la egerœ ungu. ");
INSERT INTO mnh_vpl VALUES ("C110_3","076_10_3","1CO","10","3","3","Endje para sœ lima kœzɨ ala œrœ bale nœ ɨshirɨ. ");
INSERT INTO mnh_vpl VALUES ("C110_4","076_10_4","1CO","10","4","4","Endje para sœ lima kœndjo ungu bale nœ ɨshirɨ. Gbambanœ nene, ungu á endje sœ lima kœndjo tœnœ to lœ badja nœ ɨshirɨ á sœ kœna dœ endje awa bale. Badjanœ asœmœ kœdœ lima Kristu. ");
INSERT INTO mnh_vpl VALUES ("C110_5","076_10_5","1CO","10","5","5","Andaa, ɔtshɔ anga endje ndjoro ugurutœ endje gaga lima tœ ala Ndjaba nene, mbœrœ endje sœ lima kœtshu tœnœ kpɔɔ lœ kpagagasho. ");
INSERT INTO mnh_vpl VALUES ("C110_6","076_10_6","1CO","10","6","6","Œrœ ataa mbœrœ lima tœ endje mbœrœ á ala azœ kœgbɔ adœke a kœsœsœ dœ ekpe ogo œrœ ɓata á endje sœ lima dœ tœnœ nene. ");
INSERT INTO mnh_vpl VALUES ("C110_7","076_10_7","1CO","10","7","7","'E dodonga andjaba ɓata anga endje ugurutœ endje mbœrœ nene. Ataa, endje sú ɓa la buku nœ Ndjaba adœke: «Azu sœ lima ga atɨ ndœ kœzɨ œrœ dœ pe kœndjo œrœ; manda nœ endje alafo ndœ mɔlɔ.» ");
INSERT INTO mnh_vpl VALUES ("C110_8","076_10_8","1CO","10","8","8","A kakatœ tœ azœ tɨ ndœ angba budu ɓata anga endje ugurutœ endje mbœrœ lima nene: azu tshu kutu zazu bale dœ votɔ (23.000) kolœ ndœ ɔlɔ bale. ");
INSERT INTO mnh_vpl VALUES ("C110_9","076_10_9","1CO","10","9","9","A papara kœwu lɔsu Gbozu nœ azœ nene, ɓata anga azu ugurutœ endje mbœrœ yeka á tshu lima kuzu kœde osho nœ ayakoro. ");
INSERT INTO mnh_vpl VALUES ("C110_10","076_10_10","1CO","10","10","10","Ataa, 'e pupu lœ ma 'e ɓata anga endje ugurutœ endje sœ lima kœpu lœ ma endje nene, yé á andjelu nœ kuzu wo lima endje. ");
INSERT INTO mnh_vpl VALUES ("C110_11","076_10_11","1CO","10","11","11","Œrœ ataa wuta lima ga tœ endje mbœrœ adœke ala anga endje kœgbɔ, yé endje sú ga la mbeti ndœ kœmɨ dœ upu fœ azœ á a ndo dœ ndɔngɔlɔ tshapashɔ. ");
INSERT INTO mnh_vpl VALUES ("C110_12","076_10_12","1CO","10","12","12","Ataa, kaka tsheneke á tshe gbe adœke œne ka dœ ada œne, zatœ ye ga lœ vola adœke œne tete nene. ");
INSERT INTO mnh_vpl VALUES ("C110_13","076_10_13","1CO","10","13","13","Kœwu lɔsu á 'e sœ lœnœ, sœ awa bale mbœrœ azu kɔ. Ndjaba sœ kœmbœrœtœ ye lindœ o'o ye; tshe yindœ nœ adœke endje wu lɔsu 'e kœropa gbɔgbɔ nœ 'e nene. Lœ kœwu lɔsu, tshe yisœ mara nœ kœwuta lœ nœ œdœ gbɔgbɔ nœ kœshi gbɨ lœ nœ fœ 'e. ");
INSERT INTO mnh_vpl VALUES ("C110_14","076_10_14","1CO","10","14","14","Mbœrœ tœnœ ataa, aaya mœ á mœ yindœ 'e waa, 'e tɨtœ 'e tœ andjaba. ");
INSERT INTO mnh_vpl VALUES ("C110_15","076_10_15","1CO","10","15","15","Mœ sœ kœpa o'o fœ 'e ɓata fœ azu á endje wusœ kœtondœ o'o, 'e wa œneke á mœ sœ kœpa fœ 'e asœ dœ tœ 'e. ");
INSERT INTO mnh_vpl VALUES ("C110_16","076_10_16","1CO","10","16","16","Yashi á a sœ kœdonga Ndjaba mbœrœ tœnœ, ngbɔngbɔɓa azœ ga tœnœ bale dœ indji Kristu nene a? Mapa á a sœ kœkavwatshelœ nœ, ngbɔngbɔɓa azœ ga tœnœ bale dœ undu Kristu nene a? ");
INSERT INTO mnh_vpl VALUES ("C110_17","076_10_17","1CO","10","17","17","Mapa sœ tshebabale, ataa a sœ ndjoro gbaa, a wuta undu tshebabale. Gbambanœ nene, azœ para a sœ kœzɨ kolœ mapanœ á sœ tshebabale asœmœ. ");
INSERT INTO mnh_vpl VALUES ("C110_18","076_10_18","1CO","10","18","18","'E wu azu Israyele: endje á endje sœ kœzɨ agea á endje to tœ tokóró, ngbɔngbɔtœ endje awa bale ndœ kœdonga Ndjaba ɓa ɨndɨrɨ ndaba nene a? ");
INSERT INTO mnh_vpl VALUES ("C110_19","076_10_19","1CO","10","19","19","O'o gaɗe dá mœ kœpa a? Songba agea á endje to tœ tokóró fœ andjaba too andjabanœ dœ tœ endje sœ dœ ádá waa ye a? ");
INSERT INTO mnh_vpl VALUES ("C110_20","076_10_20","1CO","10","20","20","Œ̃ œ̃ nene! Kashe tokórónœ á ayingba Ndjaba sœ kœto tœnœ, kœdœ œnœ ekpe ɨshirɨ yé œ dœ́dœ́ œnœ Ndjaba nene. Mœ yiyindœ nœ adœke 'e ngbɔɓatœ 'e ga tœ œsœnœ bale dœ aekpe ɨshirɨ nene. ");
INSERT INTO mnh_vpl VALUES ("C110_21","076_10_21","1CO","10","21","21","Œ lili adœke 'e sœ kœndjo œrœ dœ yashi nœ Gbozu œdœ ndje dœ œnœ ekpe ɨshirɨ nene. Œ lili adœke 'e zɨ œrœ pa ndaba kœzɨrœ nœ Gbozu œdœ ndje pa œnœ ekpe ɨshirɨ nene. ");
INSERT INTO mnh_vpl VALUES ("C110_22","076_10_22","1CO","10","22","22","Too a yindœ kœɨvwɨ úkú nœ Gbozu ga lafo a? A sœ dœ gbɔgbɔ kœropa ye a? ");
INSERT INTO mnh_vpl VALUES ("C110_23","076_10_23","1CO","10","23","23","«Endje papakata œrœ bale nene», kashe œ dœ́dœ́ œrœ kɔ dá ga nene. «Endje papakata œrœ bale nene», kashe œ dœ́dœ́ œrœ kɔ dá sœ kœmbœrœ adœke uzu gerœ lœ kœyindœrœ nœ ye nene. ");
INSERT INTO mnh_vpl VALUES ("C110_24","076_10_24","1CO","10","24","24","Œ lili adœke uzu gbe kolœ dœ undu ye dœ tœ ye nene, kashe tshe gbe ndje dœ œnœ anga azu. ");
INSERT INTO mnh_vpl VALUES ("C110_25","076_10_25","1CO","10","25","25","Œrœ kɔ á endje za yɔ œrœ ɓala wutu kœka songba agea, 'e zɨ, kashe 'e yuyu osho tœ ádánœ yeka á kœza oyo ga tœ lɔsu 'e nene. ");
INSERT INTO mnh_vpl VALUES ("C110_26","076_10_26","1CO","10","26","26","Gbambanœ nene, ɔshɔ œdœ œrœ lœnœ kɔ kœdœ œnœ Gbozu. ");
INSERT INTO mnh_vpl VALUES ("C110_27","076_10_27","1CO","10","27","27","Œdœ anga uzu á tshe yiyindœ Ndjaba nene kœ'e 'e, á 'e yindœ kœna ga ndœ ye, 'e zɨ œrœ kɔ á tshe to fœ 'e, yé 'e yuyu osho tœ ádánœ yeka á kœza oyo ga tœ lɔsu 'e nene. ");
INSERT INTO mnh_vpl VALUES ("C110_28","076_10_28","1CO","10","28","28","Kashe œdœ anga uzu kœpa fœ 'e adœke: «Asœ kœdœ songba agea á endje to dœ tokóró fœ andjaba», 'e zɨzɨ nene, mangba uzunœ á tshe pandœ ádánœ fœ 'e, yé mbœrœ á kœzaza oyo ga tœ lɔsu nene. ");
INSERT INTO mnh_vpl VALUES ("C110_29","076_10_29","1CO","10","29","29","Mœ sœsœ kœpa o'o ndœ lɔsu 'e nene, kashe ndœ œnœ uzunœ á tshe pa o'o nœ asœmœ. Kashe mbœrœ gaɗe á lɔsu anga angbɨ uzu œ wa mapaka pa œrœ á mœ li kœmbœrœ tœnœ a? ");
INSERT INTO mnh_vpl VALUES ("C110_30","076_10_30","1CO","10","30","30","Œdœ mœ kœgi mershe fœ Ndjaba mbœrœ kœzɨrœ á mœ sœ kœzɨ tœnœ, mbœrœ gaɗe á endje yiangba mœ tœ œneke á mœ gi mershe fœ Ndjaba pa nœ a? ");
INSERT INTO mnh_vpl VALUES ("C110_31","076_10_31","1CO","10","31","31","Œdœ 'e kœsœ kœzɨ œrœ, œdœ 'e kœsœ kœndjo œrœ, œdœ œrœ gaɗe á 'e yindœ kœmbœrœ tœnœ, 'e mbœrœ kɔ mbœrœ mokɔ nœ Ndjaba. ");
INSERT INTO mnh_vpl VALUES ("C110_32","076_10_32","1CO","10","32","32","'E mbœmbœrœ adœke uzu te mbœrœ 'e nene: œdœ Ayuda, œdœ Agreke, œdœ azu Ikrizia nœ Ndjaba. ");
INSERT INTO mnh_vpl VALUES ("C110_33","076_10_33","1CO","10","33","33","'E mbœrœtœ 'e ɓata œmœ: mœ sœ kœpa avwara tœ mœ dœ tœ mœ adœke mœ za yanga fœ azu kɔ lœ œrœ kɔ, mœ gbegbe kolœ dœ undu mœ dœ tœ mœ nene, kashe mœ gbe dœ œnœ ukpulu azu ndjoro mbœrœ adœke endje she. ");
INSERT INTO mnh_vpl VALUES ("C111_1","076_11_1","1CO","11","1","1","'E mbœrœtœ 'e liaka mœ ɓata á mœ sœ kœmbœrœtœ mœ liaka Kristu. ");
INSERT INTO mnh_vpl VALUES ("C111_2","076_11_2","1CO","11","2","2","Mœ sœ kœdonga 'e mbœrœ 'e sœ kœgbe dœ mœ lœ œrœ kɔ, yé 'e sœ kœgbɔndœ mara kœmbœrœtœ osho liaka œneke á mœ yi lima sœ nœ fœ 'e. ");
INSERT INTO mnh_vpl VALUES ("C111_3","076_11_3","1CO","11","3","3","Andaa, mœ yindœ nœ adœke 'e wusœ neke: gbozu tshapa azu para kœdœ Kristu, gbozu tshapa yashe kœdœ yakoshe; gbozu tshapa Kristu kœdœ Ndjaba. ");
INSERT INTO mnh_vpl VALUES ("C111_4","076_11_4","1CO","11","4","4","Yakoshe kɔ á tshe sœ kœza avwala too á tshe sœ kœgbara o'o ama Ndjaba á i kumu ye, gu œsœ gbozu nœ ye. ");
INSERT INTO mnh_vpl VALUES ("C111_5","076_11_5","1CO","11","5","5","Kashe yashe kɔ á tshe sœ kœza avwala too á tshe sœ kœgbara o'o ama Ndjaba á i i kumu ye nene, gu œsœ gbozu nœ ye. Gbambanœ nene, œ sœ adja ɓata tshe lɨ sukumu ye pa ye. ");
INSERT INTO mnh_vpl VALUES ("C111_6","076_11_6","1CO","11","6","6","Œdœ yashe kœi i kumu ye dœ siriki nene, tshe lɨ sukumu ye! Kashe œsœ tshula mbœrœ yashe kœlɨ sukumu ye too kœwa tshapanœ; œ li adœke tshe i kumu ye dœ siriki. ");
INSERT INTO mnh_vpl VALUES ("C111_7","076_11_7","1CO","11","7","7","Œ lili adœke yakoshe i kumu ye dœ siriki nene; œshe kœdœ ɨshirɨ dœ pe mokɔ nœ Ndjaba. Kashe yashe kœdœ mokɔ nœ yakoshe. ");
INSERT INTO mnh_vpl VALUES ("C111_8","076_11_8","1CO","11","8","8","Gbambanœ nene, œ dœ́dœ́ yakoshe dá to lœ yashe nene, kashe yashe dá to lœ yakoshe. ");
INSERT INTO mnh_vpl VALUES ("C111_9","076_11_9","1CO","11","9","9","Yé Ndjaba mbœmbœrœ yakoshe mbœrœ yashe nene, kashe yashe dá tshe mbœrœ she mbœrœ yakoshe. ");
INSERT INTO mnh_vpl VALUES ("C111_10","076_11_10","1CO","11","10","10","Mbœrœ tœnœ ataa, œ li adœke yashe i kumu ye dœ siriki ndœ kœma ambárá tshagbozu nœ ye ɓa utshu aandjelu. ");
INSERT INTO mnh_vpl VALUES ("C111_11","076_11_11","1CO","11","11","11","Andaa ɓa utshu Gbozu, yashe sœ mbœrœ yakoshe, yé yakoshe sœ mbœrœ yashe. ");
INSERT INTO mnh_vpl VALUES ("C111_12","076_11_12","1CO","11","12","12","Gbambanœ nene, ataa yashe to lima lœ yakoshe gbaa, yashe dá zu yakoshe, yé kɔkɔ to ɓa ndœ Ndjaba. ");
INSERT INTO mnh_vpl VALUES ("C111_13","076_11_13","1CO","11","13","13","'E wa ngbanganœ dœ tœ 'e, œ sœ dœ ɔtshɔnœ adœke yashe kœsœ kœza avwala fœ Ndjaba, tshe i i kumu ye dœ siriki nene a? ");
INSERT INTO mnh_vpl VALUES ("C111_14","076_11_14","1CO","11","14","14","Tshapashɔ dœ tœ ye yiyisœ œrœ fœ 'e adœke œ sœ dœ ekpenœ mbœrœ yakoshe kœsœ dœ ugu sukumu nene na a? ");
INSERT INTO mnh_vpl VALUES ("C111_15","076_11_15","1CO","11","15","15","Tœnœ kœdœ mokɔ mbœrœ yashe, gbambanœ nene, Ndjaba to lima ugu sukumu fœ she tœ œsœ siriki. ");
INSERT INTO mnh_vpl VALUES ("C111_16","076_11_16","1CO","11","16","16","Kashe œdœ uzu kœyindœ kœshara tœnœ, a'a œdœ azu Ikrizia nœ Ndjaba, 'a sœsœ dœ anga angbɨ mara kœsœ nene. ");
INSERT INTO mnh_vpl VALUES ("C111_17","076_11_17","1CO","11","17","17","Ɓata á mœ sœ kœmɨ upu fœ 'e, mœ sœsœ kœdonga 'e nene. Gbambanœ nene, angbɔtœ nœ 'e sœsœ kœgi 'e ga utshunœ nene, kashe œ sœ kœyi 'e ga lœ ekperœ. ");
INSERT INTO mnh_vpl VALUES ("C111_18","076_11_18","1CO","11","18","18","Utshunœ kɔ, azu sœ kœpa fœ mœ adœke lɔkɔ á 'e sœ kœngbɔtœ 'e lœ angbɔtœ, 'e sœ kœkurutshelœtœ 'e ugurutœ 'e, yé mœ wu adœke anganœ, œtœnœ kœdœ adjapu. ");
INSERT INTO mnh_vpl VALUES ("C111_19","076_11_19","1CO","11","19","19","Œ li adœke 'e kurutshelœtœ 'e ataa yeka á a kœwusœ endjeneke ugurutœ 'e á endje sœ kœshi gbɨ lœ kœwu lɔsunœ asœmœ. ");
INSERT INTO mnh_vpl VALUES ("C111_20","076_11_20","1CO","11","20","20","Kashe, lɔkɔ á 'e sœ kœngbɔtœ 'e awa bale ndœ kœzɨrœ nœ Gbozu, œ dœ́dœ́ adja kœzɨrœ nœ Gbozu dá 'e sœ kœzɨ tœnœ nene. ");
INSERT INTO mnh_vpl VALUES ("C111_21","076_11_21","1CO","11","21","21","Gbambanœ nene, dœ lɔkɔ kœzɨ œrœ, uzu dœ uzu sœ kœgbɔgbɔtœ ye ndœ kœzɨrœ nœ ye dœ tœ ye, dœ mara adœke anga uzu sœ dœ ogo, yé anga ndjo œrœ œ mbœrœ she. ");
INSERT INTO mnh_vpl VALUES ("C111_22","076_11_22","1CO","11","22","22","Ataa, 'e sœsœ dœ anda ndœ kœzɨ œrœ dœ pe kœndjo œrœ nene a? Too 'e sœ kœtshene Ikrizia nœ Ndjaba yé œ yindœ kœgu endjeneke á endje gugu dœ œrœ nene a? O'o gaɗe á mœ kœpa fœ 'e a? Œ li adœke mœ donga 'e a? Bale nene, kpœpa o'onœ asœmœ, mœ sœsœ kœdonga 'e nene. ");
INSERT INTO mnh_vpl VALUES ("C111_23","076_11_23","1CO","11","23","23","Yé, 'e wu œneke á mœ gbɔ ɓa ndœ Gbozu dá mœ sœ kœyisœ nœ fœ 'e asœ: Gbozu Yisu, lœ butshɔ á endje za lima she ga tshaabrœ azu asœmœ, tshe za mapa, ");
INSERT INTO mnh_vpl VALUES ("C111_24","076_11_24","1CO","11","24","24","yé manda kœdonga Ndjaba, tshe kavwa tshelœnœ yé á pa adœke: «Asœke kœdœ undu mœ á sœ mbœrœ 'e, 'e mbœrœ atamœ mbœrœ kœgbe dœ mœ.» ");
INSERT INTO mnh_vpl VALUES ("C111_25","076_11_25","1CO","11","25","25","Tshe mbœrœ awa bale ataa manda kœzɨrœ, œ za yashi á pa adœke: «Yashinœ asœke kœdœ tafo ayo lœ indji mœ, 'e mbœrœ ataa ɔlɔ dœ ɔlɔ á 'e kœsœ kœndjo tœnœ, mbœrœ kœgbe dœ mœ.» ");
INSERT INTO mnh_vpl VALUES ("C111_26","076_11_26","1CO","11","26","26","Gbambanœ nene, ɔlɔ dœ ɔlɔ á 'e kœsœ kœzɨ mapa asœ dœ pe kœndjo vinu asœ, 'e sœ kœmɨndœ kuzu Gbozu œrrr ga tœ olo kœkwa she. ");
INSERT INTO mnh_vpl VALUES ("C111_27","076_11_27","1CO","11","27","27","Mbœrœ tœnœ ataa, tsheneke á tshe sœ kœzɨ mapa too á tshe sœ kœndjo vinu nœ Gbozu dœ mara adœke tshe lɨlɨsœ ye nene, tshe gbɔ bala o'o mbœrœ undu œdœ indji Gbozu. ");
INSERT INTO mnh_vpl VALUES ("C111_28","076_11_28","1CO","11","28","28","Uzu dœ uzu tondœtœ ye dœ tœ ye utshu nœ yeka á kœzɨ mapa œdœ kœndjo vinu asœ. ");
INSERT INTO mnh_vpl VALUES ("C111_29","076_11_29","1CO","11","29","29","Gbambanœ nene, tsheneke á tshe zɨ yé á ndjo tœnœ, á wuwusœ ádánœ nene, sœ kœwa ɔgbɔ ngbanga ga tœ ye dœ tœ ye. ");
INSERT INTO mnh_vpl VALUES ("C111_30","076_11_30","1CO","11","30","30","Wu mbœrœ tœnœ ataa, aayi koɓa dœ agbakɨndɨ sœ ugurutœ 'e ndjoro, yé anga endje ndjoro tshu ye. ");
INSERT INTO mnh_vpl VALUES ("C111_31","076_11_31","1CO","11","31","31","Œdœ a kœsœ kœtondœtœ azœ dœ tœ azœ, Gbozu œ wa ngbanga ga tœ azœ nene. ");
INSERT INTO mnh_vpl VALUES ("C111_32","076_11_32","1CO","11","32","32","Kashe Gbozu sœ kœwa ngbanga ga tœ azœ mbœrœ kœyɔrɔ azœ adœke endje kœwawa ɔgbɔ ngbanga ga tœ azœ œdœ azu nœ tshapashɔ nene. ");
INSERT INTO mnh_vpl VALUES ("C111_33","076_11_33","1CO","11","33","33","Ataa, aaya mœ, lɔkɔ á 'e kœngbɔtœ 'e ndœ kœzɨ kœzɨrœ nœ Gbozu, 'e kate anga anga 'e. ");
INSERT INTO mnh_vpl VALUES ("C111_34","076_11_34","1CO","11","34","34","Œdœ uzu kœsœ dœ ogo, tshe zɨ œrœ ɓa sœnda nœ ye mbœrœ adœke 'e kœgbogbota kœwa ɔgbɔ ngbanga ga pa 'e lœ kœngbɔtœ 'e nene. Mbœrœ udu anga o'o, mœ guma dœ lɔkɔ á mœ na bala ga ndœ 'e. ");
INSERT INTO mnh_vpl VALUES ("C112_1","076_12_1","1CO","12","1","1","Alaya, tœ upu nœ kœtorœ nœ Ɔtshɔ Ɨshirɨ, mœ yiyindœ nœ adœke 'e tshapu kœwusœ nœ nene. ");
INSERT INTO mnh_vpl VALUES ("C112_2","076_12_2","1CO","12","2","2","'E wusœ nœ adœke, lɔkɔ á 'e dœ́dœ́ lima ayindœ Yisu nene, 'e lili lima kœru lɔsu 'e nene kœna manda andjaba á endje sœsœ kœpa o'o nene. ");
INSERT INTO mnh_vpl VALUES ("C112_3","076_12_3","1CO","12","3","3","Mbœrœ tœnœ ataa, mœ sœ kœpandœ nœ fœ 'e adœke: uzu bale nene á tshe sœ dœ Ɨshirɨ nœ Ndjaba, lili kœpa nene adœke: «Mœ darandœ Yisu» yé uzu bale nene lili kœpa nene adœke: «Yisu kœdœ Gbozu», œdœ Ɔtshɔ Ɨshirɨ kœpapandœ nœ fœ she nene. ");
INSERT INTO mnh_vpl VALUES ("C112_4","076_12_4","1CO","12","4","4","Tshelœ aka kœtorœ nœ ɔtshɔ lɔsu ngba waa, kashe kolœ tshetœ Ɨshirɨnœ asœmœ kutu ye dá sœ kœkurutshelœ nœ. ");
INSERT INTO mnh_vpl VALUES ("C112_5","076_12_5","1CO","12","5","5","Tshelœ aka kœmbœrœ akwa fœ Gbozu ngba waa, kashe a sœ kœmbœrœ kolœ fœ tshetœ Gbozu. ");
INSERT INTO mnh_vpl VALUES ("C112_6","076_12_6","1CO","12","6","6","Tshelœ aka mara kœmbœrœ dœ akwa ngba waa, kashe kolœ Ndjaba tshebabale dá sœ kœza kɔ ga tœ akwa. ");
INSERT INTO mnh_vpl VALUES ("C112_7","076_12_7","1CO","12","7","7","Ɔtshɔ Ɨshirɨ sœ kœmatœ ye lœ uzu dœ uzu mbœrœ ɔtshɔrœ nœ azu para. ");
INSERT INTO mnh_vpl VALUES ("C112_8","076_12_8","1CO","12","8","8","Ɨshɨrɨ sœ kœto o'o nœ kœwusœtœ fœ anga uzu, yé tshetœ Ɨshirɨnœ asœmœ sœ kœto o'o nœ kœwusœrœ fœ anga. ");
INSERT INTO mnh_vpl VALUES ("C112_9","076_12_9","1CO","12","9","9","Tshetœ Ɨshirɨnœ asœmœ sœ kœto egerœ kœyindœrœ fœ anga uzu, yé œ sœ kœto kœtorœ nœ kœshe azu lœ koɓa fœ anga. ");
INSERT INTO mnh_vpl VALUES ("C112_10","076_12_10","1CO","12","10","10","Ɨshirɨ sœ kœto fœ anga uzu gbɔgbɔ nœ kœmbœrœ afá ndjoro; fœ anga, kœtorœ nœ kœgbara o'o; fœ anga uzu, kœtorœ nœ kœwusœ kœkurutshelœ ekpe ɨshirɨ dœ adja Ɨshɨrɨ; fœ anga uzu, kœtorœ nœ kœpa angbɨ o'o ama ogo ndjoro; yé fœ anga, kœtorœ nœ kœpandœ tshelœkata angbɨ o'o ama ogonœ. ");
INSERT INTO mnh_vpl VALUES ("C112_11","076_12_11","1CO","12","11","11","Kashe œrœnœ asœmœ kɔ, kolœ tshetœ Ɨshirɨnœ á tshe sœ kœto mara kœtorœ ndjoro fœ uzu dœ uzu asœmœ, œ za tœnœ ga tœ akwa ɓata á tshe yindœ nœ. ");
INSERT INTO mnh_vpl VALUES ("C112_12","076_12_12","1CO","12","12","12","Kristu sœ ɓata undu uzu á œrœ kotœnœ ngba waa, kashe œ ngbɔtœ endje ga tœnœ, yé œ wuta undu uzu bale. ");
INSERT INTO mnh_vpl VALUES ("C112_13","076_12_13","1CO","12","13","13","Gbambanœ nene, azœ para, a gbɔ lima batisimu mbœrœ kœwuta undu bale lœ awa nœ Ɨshirɨ. Ayuda too Greke, akanga too akanga nene, kashe Ndjaba to Ɨshirɨ bale asœmœ ga lœ azœ kɔ. ");
INSERT INTO mnh_vpl VALUES ("C112_14","076_12_14","1CO","12","14","14","Undu uzu bale sœsœ dœ œrœ kolœ bale nene, kashe dœ œrœ kotœnœ ndjoro. ");
INSERT INTO mnh_vpl VALUES ("C112_15","076_12_15","1CO","12","15","15","Œdœ ada kœpa lima adœke: «Ɓata á mœ dœ́dœ́ kane nene, mœ dœ́dœ́ œrœ kotœ undu uzu nene», mbœrœ tœnœ ataa œ li má adœke tshe katœ kœsœ ga tœ undu uzu ye a? ");
INSERT INTO mnh_vpl VALUES ("C112_16","076_12_16","1CO","12","16","16","Œdœ utu kœpa lima adœke: «Ɓata á mœ dœ́dœ́ ala nene, mœ dœ́dœ́ anga œrœ kotœ undu uzu nene», mbœrœ tœnœ ataa œ li má adœke tshe katœ kœsœ ga tœ undu uzu ye a? ");
INSERT INTO mnh_vpl VALUES ("C112_17","076_12_17","1CO","12","17","17","Œdœ undu uzu djigi kœdœ lima ala ye, utu ye œ sœ má kpœta a? Œdœ undu uzu djigi kœdœ lima utu ye, ngawu œ sœ má kpœta a? ");
INSERT INTO mnh_vpl VALUES ("C112_18","076_12_18","1CO","12","18","18","Kashe Ndjaba ko œrœ kotœ bale dœ bale ga tœ undu uzu dœ mara á tshe yindœ nœ. ");
INSERT INTO mnh_vpl VALUES ("C112_19","076_12_19","1CO","12","19","19","Œdœ œrœ kotœ uzu kɔ kœsœ lima tshebale, ataa undu uzu œ sœ má koto o? ");
INSERT INTO mnh_vpl VALUES ("C112_20","076_12_20","1CO","12","20","20","Dœ tœnœ ataa, œrœ kotœ undu uzu sœ ndjoro, kashe undu uzu sœ tshebale. ");
INSERT INTO mnh_vpl VALUES ("C112_21","076_12_21","1CO","12","21","21","Ala lili kœpa fœ kane nene adœke: «Mœ gbegbe dœ ɓœ nene.» Yé kumu lili ndje ndœ kœpa fœ ada nene adœke: «Mœ gbegbe dœ 'e nene.» ");
INSERT INTO mnh_vpl VALUES ("C112_22","076_12_22","1CO","12","22","22","Ga panœ, œrœ kotœ undu uzu á sœ ɓata œ gugu dœ gbɔgbɔ nene, sœ dœ ádá waa. ");
INSERT INTO mnh_vpl VALUES ("C112_23","076_12_23","1CO","12","23","23","Yé œneke á a zaza dœ ádá nene, œtœnœ dá a sœ kœlɨsœ nœ. Œneke á sœ kœza tshula, a sœ kœgbɔndœ nœ dœ ɔtshɔnœ. ");
INSERT INTO mnh_vpl VALUES ("C112_24","076_12_24","1CO","12","24","24","Œneke á sœsœ kœza tshula fœ azœ nene, a sœsœ dœ ogo kœgbɔndœ nœ nene. Kashe Ndjaba mbœrœ undu uzu dœ mara adœke œrœ kotœnœ á gugu dœ ádá nene, endje lɨsœ nœ kœrosœ nœ: ");
INSERT INTO mnh_vpl VALUES ("C112_25","076_12_25","1CO","12","25","25","ataa, undu uzu œ kurutshelœtœ ye nene, kashe œrœ kotœ kɔ sœ dœ gbetshelœ bale mbœrœ kœtɨ kane endje ugurutœ endje dœ anga endje. ");
INSERT INTO mnh_vpl VALUES ("C112_26","076_12_26","1CO","12","26","26","Œdœ anga œrœ kotœ bale kœsœ dœ koɓa, undu uzu kɔ œ sœ dœ koɓa; œdœ endje kœlɨsœ anga œrœ kotœ bale, œrœ kotœ kɔ œ sœ dœ yanga awa bale dœ she. ");
INSERT INTO mnh_vpl VALUES ("C112_27","076_12_27","1CO","12","27","27","Andaa, e'e kœdœ undu Kristu, yé uzu bale dœ bale ugurutœ 'e kœdœ anga œrœ kotœ bale nœ undunœ asœmœ. ");
INSERT INTO mnh_vpl VALUES ("C112_28","076_12_28","1CO","12","28","28","Dœ tœnœ ataa dá Ndjaba kurutshelœ akwa kpikpikpi tœ azu lœ Ikrizia: utshunœ kœdœ aayi avwa, bishanœ kœdœ aayi kœgbara o'o yé votɔnœ kœdœ aayi kœyisœrœ. Manda nœ, tshe to kœtorœ nœ kœmbœrœ dœ afá, œnœ kœshe dœ aayi koɓa, œnœ kœtɨ kane osho, œnœ kœdœ gbozu tshapa akwa œdœ œnœ kœpa angbɨ o'o ama ogo. ");
INSERT INTO mnh_vpl VALUES ("C112_29","076_12_29","1CO","12","29","29","Œ dœ́dœ́ endje kɔ dá dœ aayi avwa, aayi kœgbara o'o too aayi kœyisœrœ nene. Œ dœ́dœ́ endje kɔ dá sœ dœ kœtorœ nœ kœmbœrœ afá, ");
INSERT INTO mnh_vpl VALUES ("C112_30","076_12_30","1CO","12","30","30","nœ kœshe dœ aayi koɓa, nœ kœpa angbɨ o'o ama ogo too nœ kœpa tshelœ katanœ nene. ");
INSERT INTO mnh_vpl VALUES ("C112_31","076_12_31","1CO","12","31","31","Ataa, 'e sœ dœ egerœ agbe nœ kœtorœ á ga waa. Yé ga pa nœ, mœ yindœ kœyisœ awa nœ waa dœ waa á ropanœ kɔ fœ 'e. ");
INSERT INTO mnh_vpl VALUES ("C113_1","076_13_1","1CO","13","1","1","Mœ li má kœpa angbɨ o'o ama ogo dœ pe œnœ aandjelu, kashe œdœ mœ kœgugu dœ kœyindœsho nene, œmœ kœdœ ngbongolo á sœ kœkɨ tœnœ too lenga á sœ kœkɨ klu klu klu. ");
INSERT INTO mnh_vpl VALUES ("C113_2","076_13_2","1CO","13","2","2","Mœ li má kœsœ dœ kœtorœ nœ kœgbara o'o, œnœ kœwusœrœ nœ œrœ kɔ á zatœ ye yiwatœnœ dœ pe œnœ kœwusœrœ kɔ; mœ li má kœsœ dœ kœyindœrœ djigi á li kœza kaga na tœnœ ga tœ anga osho, kashe œdœ mœ kœgugu dœ kœyindœsho nene, mœ sœ gbambanœ. ");
INSERT INTO mnh_vpl VALUES ("C113_3","076_13_3","1CO","13","3","3","Mœ li má kœkurutshelœ œrœ nœ mœ kɔ tœ aayi ogo, mœ li má kœzatœ mœ adœke endje sho mœ dœ owo, kashe œdœ mœ kœgugu dœ kœyindœsho nene, mœ gbɔ œrœ bale nene. ");
INSERT INTO mnh_vpl VALUES ("C113_4","076_13_4","1CO","13","4","4","Kœyindœsho kœdœ kœsœ dœ ugu lɔsu, tœnœ kœdœ kœmbœrœ akwa fœ yanga zœ, œ sœsœ dœ úkú nene, œ sœsœ kœmatœ ye nene, œ sœsœ dœ egerœ kumu nene. ");
INSERT INTO mnh_vpl VALUES ("C113_5","076_13_5","1CO","13","5","5","Kœyindœsho sœsœ kœmbœrœ œrœ tshula nene, œ sœsœ kœgbe kolœ dœ undu ye dœ tœ ye nene, œ sœsœ dœ oko nene, œ sœsœ dœ œ'ele nene. ");
INSERT INTO mnh_vpl VALUES ("C113_6","076_13_6","1CO","13","6","6","Kœyindœsho sœsœ dœ yanga nœ ekperœ nene, kashe œ sœ dœ yanga lœ adjapu. ");
INSERT INTO mnh_vpl VALUES ("C113_7","076_13_7","1CO","13","7","7","Kœyindœsho sœ kœru lɔsu tœ œrœ kɔ, œ sœ dœ kœyindœrœ lœ œrœ kɔ, œ sœ kœza lɔsu ga pa œrœ kɔ, œ sœ kœshi gbɨ lœ œrœ kɔ. ");
INSERT INTO mnh_vpl VALUES ("C113_8","076_13_8","1CO","13","8","8","Kœyindœsho œ ka bale nene. Kashe kœgbara o'o œ kpa gu nene. Kœpa angbɨ o'o ama ogo œ ka ye. Kœwusœrœ œ kpa gu nene. ");
INSERT INTO mnh_vpl VALUES ("C113_9","076_13_9","1CO","13","9","9","Gbambanœ nene, kœwusœrœ nœ azœ sœ dœ mapaka, yé kœgbara o'o nœ azœ sœsœ ga pa œrœ kɔ nene. ");
INSERT INTO mnh_vpl VALUES ("C113_10","076_13_10","1CO","13","10","10","Kashe lɔkɔ á œrœ kɔ œ li bala, œneke á sœ dœ mapaka œ kpa gu nene. ");
INSERT INTO mnh_vpl VALUES ("C113_11","076_13_11","1CO","13","11","11","Lɔkɔ á mœ sœ lima tœ gbolo, mœ sœ lima kœpa o'o ɓata gbolo, mœ sœ lima dœ gbetshelœ dœ pe kœwusœrœ ɓata gbolo. Lɔkɔ á mœ wuta gbozu, mœ katœ œrœ tshagbolo ye. ");
INSERT INTO mnh_vpl VALUES ("C113_12","076_13_12","1CO","13","12","12","Ngɔngɔ asœke, a sœ kœwu ɨshirɨ ngbangbangba ala wushirɨ, kashe a wu bala tshatshu azœ dœ Ndjaba. Ngɔngɔ asœke, kœwusœrœ nœ mœ sœ dœ mapaka; yé dœ anga lɔndɔ bale, mœ wusœ Ndjaba ɓata á tshe wu ndje sœ mœ. ");
INSERT INTO mnh_vpl VALUES ("C113_13","076_13_13","1CO","13","13","13","Ngɔngɔ asœke, œrœnœ asœmœ votɔ sœpe: kœyindœrœ, kœza lɔsu ga pa œrœ œdœ kœyindœsho; kashe kœyindœsho dá sœ tœ egerœnœ kœropanœ kɔ. ");
INSERT INTO mnh_vpl VALUES ("C114_1","076_14_1","1CO","14","1","1","Utshunœ kɔ, 'e para kœyindœsho. 'E sœ dœ egerœ ogo ndœ kœgbɔ kœtorœ nœ Ɨshirɨ, kœropa nœ kɔ, œnœ kœgbara dœ o'o. ");
INSERT INTO mnh_vpl VALUES ("C114_2","076_14_2","1CO","14","2","2","Gbambanœ nene, tsheneke á tshe sœ kœpa angbɨ o'o ama ogo, tshe sœsœ kœpa fœ azu nene, kashe tshe sœ kœpa fœ Ndjaba. Uzu bale œ dji tshelœ katanœ nene: lœ awa nœ Ɨshirɨ, tshe sœ kœpa tœ œrœ á a wuwusœ ádánœ nene. ");
INSERT INTO mnh_vpl VALUES ("C114_3","076_14_3","1CO","14","3","3","Kashe tsheneke á tshe sœ kœgbara o'o sœ kœpa o'o fœ azu: tshe sœ kœmbœrœ adœke azu gboro lœ kœyindœrœ, tshe sœ kœto gbɔgbɔ fœ azu, yé œ sœ kœu endje ga tœnœ. ");
INSERT INTO mnh_vpl VALUES ("C114_4","076_14_4","1CO","14","4","4","Tsheneke á tshe sœ kœpa angbɨ o'o ama ogo, tshe sœ kœmbœrœ adœke kolœ kœyindœrœ nœ œne kutɨ œne kœgerœ, kashe tsheneke á tshe sœ kœgbara o'o sœ kœmbœrœ adœke azu Ikrizia gboro lœ kœyindœrœ nœ endje. ");
INSERT INTO mnh_vpl VALUES ("C114_5","076_14_5","1CO","14","5","5","Mœ sœ kœyindœ nœ adœke e'e para kɔkɔ 'e pa angbɨ o'o ama ogo, kashe kœropa nœ kɔ, ogo nœ mœ kœdœ adœke 'e gbara o'o nœ Ndjaba. Uzu á tshe sœ kœgbara o'o nœ Ndjaba ropa tsheneke á tshe sœ kœpa angbɨ o'o ama ogo ye. Kashe tshe ropa ye nene œdœ uzu á tshe sœ kœpa angbɨ o'o ama ogo kœsœ dœ anga uzu á tshe wusœ kœpandœ ádánœ mbœrœ adœke azu Ikrizia gboro lœ kœyindœrœ. ");
INSERT INTO mnh_vpl VALUES ("C114_6","076_14_6","1CO","14","6","6","Atamœ alaya, œ kœsœ adœke mœ kœna kœwu 'e yé á sœ kœpa angbɨ o'o ama ogo fœ 'e, mœ sœ dœ ádá ɓa ndœ 'e lœ œrœ gaɗe? Lœ œrœ bale nene. Mœ sœ dœ ádá ɓa ndœ 'e œdœ mœ kœpandœ o'o tœ upu nœ adjapu á zatœ ye yiwa tœnœ, tœ upu nœ kœwusœrœ, tœ upu nœ kœgbara o'o ama Ndjaba œdœ pe tœ upu nœ kœyisœrœ fœ 'e yekane. ");
INSERT INTO mnh_vpl VALUES ("C114_7","076_14_7","1CO","14","7","7","Œ sœ ndje ataa tœ œrœ kœɓi dœ itshi, ɓata ngbake too kundi: œ kœsœsœ kœwa tshelœ itshinœ ngbɨ nene, ɓœ wusœ itshinœ á yindœ kœɓi tœnœ koto o? ");
INSERT INTO mnh_vpl VALUES ("C114_8","076_14_8","1CO","14","8","8","Yé œdœ aga kœmama tshelœ ɨkɨnœ ngbɨɨ nene, œɗe dá guma tœ ye ndœ kœna ndœ koshe a? ");
INSERT INTO mnh_vpl VALUES ("C114_9","076_14_9","1CO","14","9","9","E'e ndje, œdœ o'o á 'e kœsœ kœpa tœnœ kœsœsœ ngbɨ nene, azu œ dji tshelœkata œneke á 'e sœ kœpa tœnœ koto o? 'E pa o'o ga lœ yugu. ");
INSERT INTO mnh_vpl VALUES ("C114_10","076_14_10","1CO","14","10","10","Mara o'o ama ogo ngba waa pa tshapashɔ, kashe anganœ bale á azu sœsœ kœdji ádánœ nene gugu nene. ");
INSERT INTO mnh_vpl VALUES ("C114_11","076_14_11","1CO","14","11","11","Andaa, œdœ mœ kœsœsœ kœdji tshelœ kata angbɨ o'o ama ogo á uzu sœ kœpa tœnœ nene, mœ wu she ɓata gene, yé tshe wu ndje mœ ɓata gene. ");
INSERT INTO mnh_vpl VALUES ("C114_12","076_14_12","1CO","14","12","12","E'e ndje awa bale, 'e sœ dœ egerœ ogo kœpara kœtorœ nœ Ɨshirɨ, kashe 'e para œneke á li adœke kœyindœrœ nœ azu Ikrizia gerœ. ");
INSERT INTO mnh_vpl VALUES ("C114_13","076_14_13","1CO","14","13","13","Mbœrœ tœnœ ataa, uzu á tshe sœ kœpa angbɨ o'o ama ogo, œ li adœke tshe za avwala fœ Ndjaba á kœgbɔ kœtorœ nœ kœmɨndœ ádánœ. ");
INSERT INTO mnh_vpl VALUES ("C114_14","076_14_14","1CO","14","14","14","Œdœ mœ kœsœ kœza avwala dœ angbɨ o'o ama ogo, Ɨshirɨ á sœ lœ mœ dá sœ kœmbœrœ akwa, kashe œ dœ́dœ́ kœwusœrœ nœ mœ nene. ");
INSERT INTO mnh_vpl VALUES ("C114_15","076_14_15","1CO","14","15","15","Ataa, mœ mbœrœ koto o? Mœ za avwala lœ awa nœ Ɨshirɨ, kashe mœ za ndje avwala dœ mara nœ kœwusœrœ. Mœ ɓi itshi lœ awa nœ Ɨshirɨ, kashe mœ ɓi ndje itshi dœ mara nœ kœwusœrœ. ");
INSERT INTO mnh_vpl VALUES ("C114_16","076_14_16","1CO","14","16","16","Gbambanœ nene, œdœ ɓœ kœsœ kœdonga Ndjaba kolœ lœ awa nœ Ɨshirɨ, uzu á tshe sœ kolœ kœdji o'onœ œ yindœ nœ adœke «Ame» kotoo ndœ avwala nœ kœgi mershe nœ zœ a? Gbambanœ nene, tshe djidji ndje ádá o'o á ɓœ sœ kœpa tœnœ nene. ");
INSERT INTO mnh_vpl VALUES ("C114_17","076_14_17","1CO","14","17","17","Ataa avwala nœ kœgi mershe nœ zœ kœsœ dœ ádá waa ye gbaa, œ sœsœ kœmbœrœ adœke kœyindœrœ nœ anga uzu gerœ nene. ");
INSERT INTO mnh_vpl VALUES ("C114_18","076_14_18","1CO","14","18","18","Mœ gi mershe fœ Ndjaba mbœrœ á mœ sœ kœpa angbɨ o'o ama ogo kœrosœ 'e kɔ. ");
INSERT INTO mnh_vpl VALUES ("C114_19","076_14_19","1CO","14","19","19","Kashe lœ angbɔtœ, mœ sœ kœgbe kœpa o'o nœ kœwusœrœ mindu mbœrœ kœyi ndje sœ œrœ fœ anga azu tœ œsœnœ adœke mœ pa angbɨ o'o ama ogo kutu ndjokpa (10.000). ");
INSERT INTO mnh_vpl VALUES ("C114_20","076_14_20","1CO","14","20","20","Alaya, 'e gbegbe o'o ɓata agbolo nene; lœ ekperœ, 'e sœ ɓata aaya agbolo, kashe 'e gbe o'o ɓata agbozu. ");
INSERT INTO mnh_vpl VALUES ("C114_21","076_14_21","1CO","14","21","21","Endje su ɓala buku nœ Ndjaba adœke: «Gbozu pa adœke: “mœ pa o'o fœ azu nœ mœ lœ awa nœ angbɨ o'o ama ogo œdœ lœ awa nœ o'o ama agene.” Yé ataa atamœ gbaa, endje dji mœ nene.» ");
INSERT INTO mnh_vpl VALUES ("C114_22","076_14_22","1CO","14","22","22","Mbœrœ tœnœ ataa, kœpa angbɨ o'o ama ogo dœ́dœ́ ambárá mbœrœ ayindœ Ndjaba nene, kashe tœnœ kœdœ ambárá mbœrœ ayingba Ndjaba. Kœgbara o'o dœ́dœ́ ambárá mbœrœ ayingba Ndjaba nene, kashe œtœnœ kœdœ ambárá mbœrœ ayindœ Ndjaba. ");
INSERT INTO mnh_vpl VALUES ("C114_23","076_14_23","1CO","14","23","23","Œdœ azu Ikrizia djigi kœngbɔtœ endje, yé á endje para sœ kœpa angbɨ o'o ama ogo, azu á endje sœ kœdjiidji gbambanœ too ayingba Ndjaba á endje li ga zœ, œ wu endje ɓa ta aayi iyi nene a? ");
INSERT INTO mnh_vpl VALUES ("C114_24","076_14_24","1CO","14","24","24","Kashe œdœ azu para kœsœ kœgbara o'o, uzu á tshe dœ yingba Ndjaba too uzu á tshe djiidji gbambanœ yé á sœ kœli ga zœ, tshe wusœ ekperœ nœ ye yé œneke kɔ á tshe sœ kœdji tœnœ œ wa ngbanga nœ ye. ");
INSERT INTO mnh_vpl VALUES ("C114_25","076_14_25","1CO","14","25","25","O'o á zatœ ye wutœnœ ɓa tœ lɔsu ye œ matœ endje ngbɨ ga shu. Tshe gote dœ kœfa tshatshu ye ga tœ ɔshɔ, yé œ donga Ndjaba dœ kœpa adœke: «Ndjaba sœ adja ugurutœ 'e!» ");
INSERT INTO mnh_vpl VALUES ("C114_26","076_14_26","1CO","14","26","26","Œrœ gaɗe dá a kœmbœrœ a, alaya? Lɔkɔ á 'e kœngbɔtœ 'e, uzu dœ uzu li ndœ kœɓi itshi, kœyisœ œrœ too kœpandœ adjapu á zatœ ye yiwatœnœ, kœpa angbɨ o'o ama ogo too kœpandœ ádánœ: œ li adœke œrœ ataa mbœrœtœ endje á kœyindœrœ nœ azu kœgerœ awa bale. ");
INSERT INTO mnh_vpl VALUES ("C114_27","076_14_27","1CO","14","27","27","Œdœ azu kœtetœ kœpa angbɨ o'o ama ogo, œ li adœke azu bisha too votɔ kœropanœ pa ndje o'onœ asœmœ, uzu dœ uzu manda anga, yé anga uzu kœsœ kœpandœ ádánœ. ");
INSERT INTO mnh_vpl VALUES ("C114_28","076_14_28","1CO","14","28","28","Œdœ uzu kœpandœ ádánœ kœgugu nene, ayi kœpa angbɨ o'o ama ogonœ sœ koko lœ angbɔtœ yé œ pa o'o ga tœ ye dœ tœ ye œdœ fœ Ndjaba. ");
INSERT INTO mnh_vpl VALUES ("C114_29","076_14_29","1CO","14","29","29","Tœ upu nœ kœgbara o'o, œ li adœke azu bisha too votɔ pa o'o yé anga endje kœwa o'onœ. ");
INSERT INTO mnh_vpl VALUES ("C114_30","076_14_30","1CO","14","30","30","Œdœ anga uzu ugurutœ endje kœwusœ o'o á sœ kœto ɓa ndœ Ndjaba, œ li adœke tsheneke á tshe sœ kœpa o'o sœ koko. ");
INSERT INTO mnh_vpl VALUES ("C114_31","076_14_31","1CO","14","31","31","E'e para, 'e li kœgbara o'o, kashe uzu dœ uzu pa œsœ œnœ ye mbœrœ adœke uzu kɔ kœwusœ œrœ, yé á kœsœ dœ gbɔgbɔ. ");
INSERT INTO mnh_vpl VALUES ("C114_32","076_14_32","1CO","14","32","32","Œ li adœke ayi kœgbara o'o dœ ayengɔ kœtorœ nœ kœgbara o'o nœ ɨshirɨ á sœ kœmbœrœ akwa lœ ye. ");
INSERT INTO mnh_vpl VALUES ("C114_33","076_14_33","1CO","14","33","33","Gbambanœ nene, Ndjaba dœ́dœ́ Ndjaba nœ djingili nene, kashe œshe kœdœ Ndjaba nœ kœsœ gee. Ɓata á sœ kœmbœrœtœ endje lœ Ikrizia para nœ azu á endje sœ yerœ, ");
INSERT INTO mnh_vpl VALUES ("C114_34","076_14_34","1CO","14","34","34","œ li adœke ayashe sœ koko lœ angbɔtœ: endje zaza awa fœ endje ndœ kœpapa o'o nene. Œ li adœke endje zatœ endje ga atɨ ɓata á awa akwa nœ Moyize sœ kœpa ndje tœ nœ. ");
INSERT INTO mnh_vpl VALUES ("C114_35","076_14_35","1CO","14","35","35","Œdœ endje kœyindœ kœwusœ anga ádá o'o bale dœ bale, œ li adœke endje yu akɔ endje ɓa sœnda. Œ sœsœ dœ ɔtshɔnœ nene adœke yashe pa o'o lœ angbɔtœ. ");
INSERT INTO mnh_vpl VALUES ("C114_36","076_14_36","1CO","14","36","36","'E gbe adœke, o'o ama Ndjaba to ɓa ndœ 'e a? Œ na kolœnœ mbœrœ 'e a? ");
INSERT INTO mnh_vpl VALUES ("C114_37","076_14_37","1CO","14","37","37","Œdœ uzu kœgbe adœke, œne kœdœ ayi kœgbara o'o too œne gbɔ Ɨshirɨ, œ li adœke tshe wusœ nœ adœke o'o á mœ su fœ 'e kœdœ awa o'o nœ Gbozu. ");
INSERT INTO mnh_vpl VALUES ("C114_38","076_14_38","1CO","14","38","38","Œdœ uzu kœwuwusœ nœ nene, œ yindœ kœpa adœke Ndjaba wuwu ndje sœ ye nene. ");
INSERT INTO mnh_vpl VALUES ("C114_39","076_14_39","1CO","14","39","39","Ataa, alaya mœ, 'e sœ dœ ogo nœ kœte aayi kœgbara o'o yé 'e papakata adœke endje pa angbɨ o'o ama ogo nene. ");
INSERT INTO mnh_vpl VALUES ("C114_40","076_14_40","1CO","14","40","40","Kashe, 'e sœ dœ gbɔdjela adœke œrœnœ kɔ mbœrœtœ endje dœ ɔtshɔnœ œdœ pe dœ awanœ. ");
INSERT INTO mnh_vpl VALUES ("C115_1","076_15_1","1CO","15","1","1","Alaya, mœ kpa yindœ kœpandœ Ɔtshɔ O'o á mœ pa lima ndœ nœ fœ 'e, á 'e yi lima ndœ nœ, á 'e sœpe kœyindœ nœ œrrr kpesheke. ");
INSERT INTO mnh_vpl VALUES ("C115_2","076_15_2","1CO","15","2","2","Œdœ 'e kœtepa nœ kperœ ɓata á mœ yisœ nœ fœ 'e, œ she 'e lœ awanœ ye. Œdœ 'e kœtete lima pa nœ kperœ nene, kœyindœrœ nœ 'e sœ má gbambanœ. ");
INSERT INTO mnh_vpl VALUES ("C115_3","076_15_3","1CO","15","3","3","O'o nœ utshunœ kɔ kœdœ œneke á mœ gbɔ yé á mɨndœ nœ fœ 'e kœdœ adœke: Kristu tshu mbœrœ ekperœ nœ azœ, ɓata á endje sú lima ga la buku nœ Ndjaba. ");
INSERT INTO mnh_vpl VALUES ("C115_4","076_15_4","1CO","15","4","4","Endje shi she, yé tœ votɔ olo, tshe she lœ ugurutœ akuzu, ɓata endje sú ɓala buku nœ Ndjaba. ");
INSERT INTO mnh_vpl VALUES ("C115_5","076_15_5","1CO","15","5","5","Tshe wuta ga ndœ Petro, manda nœ ga ndœ Andjokpa dœ bisha (12). ");
INSERT INTO mnh_vpl VALUES ("C115_6","076_15_6","1CO","15","6","6","Tshe kpa wuta ga ndœ ayambarœ nœ ye kœropa kama mindu (500), awa bale. Anga endje ndjoro ugurutœ endje sœpe dœ soro, kashe anga ata endje tshu ye. ");
INSERT INTO mnh_vpl VALUES ("C115_7","076_15_7","1CO","15","7","7","Manda nœ, tshe kpa wuta ndje ga ndœ Jake, yé œ kpa wuta ga ndœ aayi avwa para. ");
INSERT INTO mnh_vpl VALUES ("C115_8","076_15_8","1CO","15","8","8","Manda nœ para, tshe kpa wuta ga ndœ mœ ndje, œmœ á mœ sœ ɓata endje zu mœ tœ uzunœ. ");
INSERT INTO mnh_vpl VALUES ("C115_9","076_15_9","1CO","15","9","9","Gbambanœ nene, œmœ kœdœ aya ayi avwa kœrosœnœ lœ ugurutœ aayi avwa para, œ lili adœke endje e mœ ayi avwa nene, mbœrœ mœ mbœrœ lima œrœ kanga fœ azu Ikrizia nœ Ndjaba. ");
INSERT INTO mnh_vpl VALUES ("C115_10","076_15_10","1CO","15","10","10","Kashe lœ ɔtshɔ lɔsu nœ Ndjaba dá mœ sœ ɓata á mœ sœ asœ. Ɔtshɔ lɔsu nœ ye ga ndœ mœ sœsœ gbambanœ nene. Kashe mœ mbœrœ akwa kœrosœ endje para. Dœ adjapu, œ dœ́dœ́ mœ dá sœ kœmbœrœ akwa nene, kashe ɔtshɔ lɔsu nœ Ndjaba dá sœ kœmbœrœ akwa lœ mœ. ");
INSERT INTO mnh_vpl VALUES ("C115_11","076_15_11","1CO","15","11","11","Ataa, kœto ɓa ndœ mœ too ɓa ndœ anga aayi avwa, tœnœ kœdœ o'o kœshe nœ Yisu lœ akuzu á 'a mɨndœ nœ yé á 'e yindœ nœ. ");
INSERT INTO mnh_vpl VALUES ("C115_12","076_15_12","1CO","15","12","12","Œdœ 'a kœsœ kœmɨndœ nœ adœke Kristu she lœ akuzu, mbœrœ gaɗe á anga azu ugurutœ 'e sœ kœpa adœke kœshe lœ akuzu gugu nene a? ");
INSERT INTO mnh_vpl VALUES ("C115_13","076_15_13","1CO","15","13","13","Œdœ kœshe lœ akuzu kœgugu nene, Kristu sheshe ndje lœ akuzu nene, ");
INSERT INTO mnh_vpl VALUES ("C115_14","076_15_14","1CO","15","14","14","œdœ Kristu kœsheshe lœ akuzu nene, kœpandœ o'o nœ 'a sœ gbambanœ, yé kœyindœrœ nœ 'e sœ ndje gbambanœ. ");
INSERT INTO mnh_vpl VALUES ("C115_15","076_15_15","1CO","15","15","15","Œ sœ kœmatœ endje ɓata a'a kœdœ akpe atimu nœ Ndjaba, mbœrœ 'a pa wala kœyindœ nœ adœke Ndjaba she Kristu lœ akuzu andaa tshe sheshe she nene, œdœ œ kœsœ adjapu adœke akuzu œ she nene. ");
INSERT INTO mnh_vpl VALUES ("C115_16","076_15_16","1CO","15","16","16","Gbambanœ nene, œdœ akuzu kœsheshe nene, Kristu sheshe ndje lœ akuzu nene. ");
INSERT INTO mnh_vpl VALUES ("C115_17","076_15_17","1CO","15","17","17","Œdœ Kristu kœsheshe lœ akuzu nene, kœyindœrœ nœ 'e sœ gbambanœ, 'e sœpe damba lœ ekperœ nœ 'e. ");
INSERT INTO mnh_vpl VALUES ("C115_18","076_15_18","1CO","15","18","18","Œ yindœ kœpa adœke, ataa endjeneke á endje tshu lœ kœyindœrœ ga ndœ Kristu, djingili ndje ye. ");
INSERT INTO mnh_vpl VALUES ("C115_19","076_15_19","1CO","15","19","19","Œdœ œ kœsœ kolœ mbœrœ soronœ asœke dá a sœ kœza lɔsu azœ ga pa Kristu, azœ kœdœ aayi oyo kœropa azu para. ");
INSERT INTO mnh_vpl VALUES ("C115_20","076_15_20","1CO","15","20","20","Kashe dœ adjapu, Kristu she lœ akuzu ye; tshe she lœ akuzu utshu endjeneke á endje tshu ɓalima ɓata ali ngwarœ á endje kɔ mbœrœ kœmɨndœ nœ adœke akuzu œ she bala lœ akuzu. ");
INSERT INTO mnh_vpl VALUES ("C115_21","076_15_21","1CO","15","21","21","Ɓata á kuzu na lima lœ awa nœ uzu bale, kœshe lœ akuzu na ndje lœ awa nœ uzu bale: ");
INSERT INTO mnh_vpl VALUES ("C115_22","076_15_22","1CO","15","22","22","ɓata azu para œ tshu lœ awa nœ Adamo, azu para œ gbɔ bala soro lœ awa nœ Kristu. ");
INSERT INTO mnh_vpl VALUES ("C115_23","076_15_23","1CO","15","23","23","Kashe, uzu dœ uzu sœ dœ ɔlɔ nœ ye: Kristu dá sœ utshunœ, yé manda nœ kœdœ endjeneke á endje dœ azu nœ Kristu lɔkɔ á tshe kwa bala tœ ye. ");
INSERT INTO mnh_vpl VALUES ("C115_24","076_15_24","1CO","15","24","24","Yé manda nœ kɔ, ndɔngɔlɔ osho œ na bala lɔkɔ á Kristu œ gi akwa nœ ogo tshagbozu fœ Aba azœ dœ Ndjaba manda kœndɨ tshelœ tshagbozu kɔ œdœ gbɔgbɔ nœ ɨshirɨ kɔ. ");
INSERT INTO mnh_vpl VALUES ("C115_25","076_15_25","1CO","15","25","25","Gbamba nœ nene, œ li adœke Kristu mbœrœ akwa tshagbozu nœ ye œrrr ga tœ adœke Ndjaba fa ayingba ye ga tshada ye. ");
INSERT INTO mnh_vpl VALUES ("C115_26","076_15_26","1CO","15","26","26","Ndɔngɔlɔ yingba á Ndjaba œ ndɨtshelœ ye kœdœ kuzu. ");
INSERT INTO mnh_vpl VALUES ("C115_27","076_15_27","1CO","15","27","27","Gbambanœ nene, endje sú ɓala buku nœ Ndjaba adœke: «Ndjaba ko œrœ kɔ ga tshakudu ada ye.» Kashe Ndjaba á tshe sœ kœko œrœ nœ kɔ ga tshakudu ada Kristu asœmœ, sœsœ lœ nœ nene. ");
INSERT INTO mnh_vpl VALUES ("C115_28","076_15_28","1CO","15","28","28","Lɔkɔ á Ndjaba œ ko œrœ kɔ ga tshakudu ada Kristu, Gbolo nœ Ndjaba dœ tœ ye œ zatœ ye ga tshakudu Ndjaba á tshe ko œrœ kɔ ga tshakudu ada ye asœmœ. Ataa, Ndjaba œ dœ gbozu tshapa œrœ kɔ. ");
INSERT INTO mnh_vpl VALUES ("C115_29","076_15_29","1CO","15","29","29","Œdœ œ kœsœ lima kpi, œrœ gaɗe dá azu á endje sœ kœgbɔ batisimu mbœrœ akuzu sœ lima kœpara tœ nœ a? Œ kœsœ adjapu adœke akuzu œ she lœ akuzu nene, mbœrœ gaɗe á azu sœ kœgbɔ batisimu mbœrœ endje a? ");
INSERT INTO mnh_vpl VALUES ("C115_30","076_15_30","1CO","15","30","30","Yé a'a dœ tœ 'a, mbœrœ gaɗe á 'a sœ kœzatœ 'a ɔlɔ dœ ɔlɔ ga tœ œrœ á li kœndɨ 'a? ");
INSERT INTO mnh_vpl VALUES ("C115_31","076_15_31","1CO","15","31","31","Alaya, ɔlɔ dœ ɔlɔ mœ sœ lœ kuzu. Œ sœ ndje adjapu adœke mœ sœ kœdu okoro mœ pa 'e mbœrœ á 'e ngbɔtœ 'e bale dœ Yisu Kristu á tshe dœ Gbozu nœ azœ. ");
INSERT INTO mnh_vpl VALUES ("C115_32","076_15_32","1CO","15","32","32","Koshe á mœ nga ga tœ aagea ɓa lœ Efeze, œ mbœrœ má lima gaɗe ɓa ndœ mœ œdœ œ kœsœ má lima dœ mara kœtondœrœ nœ azu a? Œdœ akuzu kœsœsœ kœshe lœ akuzu nene, a zɨ œrœ œ ndjo œrœ, mbœrœ mbatsha a tshu ye. ");
INSERT INTO mnh_vpl VALUES ("C115_33","076_15_33","1CO","15","33","33","'E fafaratœ 'e nene: «Ekpe uzu á tshe na tœ awa dœ anga uzu, sœ kœndɨ ɔtshɔ tshasœmœ.» ");
INSERT INTO mnh_vpl VALUES ("C115_34","076_15_34","1CO","15","34","34","'E kwatœ 'e ndœ gbetshelœ nœ 'e ɓata á li, yé œ tshapu kœmbœrœ ekperœ! Gbambanœ nene, mœ sœ kœpa o'onœ tœ œrœ tshula nœ 'e adœke anga azu ugurutœ 'e wuwusœ Ndjaba nene. ");
INSERT INTO mnh_vpl VALUES ("C115_35","076_15_35","1CO","15","35","35","Kashe anga azu sœ kœyu osho adœke: «Dœ mara gaɗe á akuzu sœ kœshe lœ akuzu a? Endje sœ kœkwa dœ undu asœta a?» ");
INSERT INTO mnh_vpl VALUES ("C115_36","076_15_36","1CO","15","36","36","Œɓœ kœdœ gbakɨndɨ! Œdœ ɓœ kœlu indji ngwarœ, œ tshu yeka á rœgo œ ko. ");
INSERT INTO mnh_vpl VALUES ("C115_37","076_15_37","1CO","15","37","37","Yé œneke á ɓœ sœ kœlu tœnœ dœ́dœ́ dɔngɔ á sœ kœwuta tœnœ nene, kashe œtœnœ kœdœ djameya indji ngwarœ, indji ble too anga angbɨ œrœ. ");
INSERT INTO mnh_vpl VALUES ("C115_38","076_15_38","1CO","15","38","38","Manda nœ, Ndjaba sœ kœmbœrœ adœke indji ngwarœ to undu fœ dɔngɔ ɓata á tshe yindœ nœ. Indji ngwarœ bale dœ bale sœ dœ ala dɔngɔ nœ ye dœ tœ ye. ");
INSERT INTO mnh_vpl VALUES ("C115_39","076_15_39","1CO","15","39","39","Anga songba bale á liili dœ anganœ gugu nene: azu sœ dœ œne endje kpi, agea sœ dœ œne ndje kpi, ayanu sœ dœ œne endje kpi, ageatshalangu sœ ndje dœ œne endje kpi. ");
INSERT INTO mnh_vpl VALUES ("C115_40","076_15_40","1CO","15","40","40","Œrœ tshalafo sœ zœ, yé œnœ tshapa ɔshɔ sœ ndje zœ, kashe kœtshinœ sœsœ awa bale nene. ");
INSERT INTO mnh_vpl VALUES ("C115_41","076_15_41","1CO","15","41","41","Kœtshi ɔlɔ sœ kpi, kœtshi yapu sœ kpi, kœtshi angerepe sœ kpi. Angerepe ndje dœ tœ ye sœ kœtshi ndje kpi tœ anganœ. ");
INSERT INTO mnh_vpl VALUES ("C115_42","076_15_42","1CO","15","42","42","Œsœ ndje ataa mbœrœ kœshe lœ akuzu nœ akuzu. Lɔkɔ á endje kœshi undu uzu, undu œ gba ye. Lɔkɔ á tshe kœshe lœ akuzu, tshe kpa tshu nene. ");
INSERT INTO mnh_vpl VALUES ("C115_43","076_15_43","1CO","15","43","43","Lɔkɔ á endje kœshi undu uzu, œtœnœ kœdœ œrœ á gaga nene yé œ gugu dœ gbɔgbɔ nene. Lɔkɔ á œ kœshe lœ akuzu ye, œ sœ dœ mokɔ œdœ dœ gbɔgbɔ. Œ dœ undu uzu kœ sœ zœ, ");
INSERT INTO mnh_vpl VALUES ("C115_44","076_15_44","1CO","15","44","44","Lɔkɔ á endje kœshi undu uzu, œtœnœ kœdœ amba undu uzu á sœ lima dœ soro. Lɔkɔ á œ kœshe lœ akuzu, œ fa undu uzu á sœ kœmbœrœ akwa lœ awa nœ Ɨshirɨ. Ataa, amba undu uzu á sœ dœ soro sœ zœ, yé undu uzu á sœ kœmbœrœ akwa lœ awa nœ Ɨshirɨ sœ ndje zœ. ");
INSERT INTO mnh_vpl VALUES ("C115_45","076_15_45","1CO","15","45","45","Mbœrœ tœnœ ataa, endje sú ga la buku nœ Ndjaba adœke: «Ali uzu lima, Adamo, fa lima uzu á tshe sœ dœ soro.» Kashe ndɔngɔlɔ Adamo kœdœ Ɨshirɨ á sœ kœza soro. ");
INSERT INTO mnh_vpl VALUES ("C115_46","076_15_46","1CO","15","46","46","Œ dœ́dœ́ œneke á dœ Ɨshirɨ dá na utshunœ nene, kashe œneke á dœ amba undu uzu á sœ dœ soro. Œneke á sœ kœmbœrœ akwa lœ awa nœ Ɨshirɨ na manda nœ. ");
INSERT INTO mnh_vpl VALUES ("C115_47","076_15_47","1CO","15","47","47","Ndjaba mbœrœ lima ali uzu dœ ɔshɔ. Bisha uzu to ɓa lafo. ");
INSERT INTO mnh_vpl VALUES ("C115_48","076_15_48","1CO","15","48","48","Azu tshapa ɔshɔ liili dœ tsheneke á endje mbœrœ lima she dœ ɔshɔ, yé azu tshalafo liili ndje dœ uzu á tshe to ɓa lafo. ");
INSERT INTO mnh_vpl VALUES ("C115_49","076_15_49","1CO","15","49","49","Yé awa bale a sœ ɓata ɨshirɨ uzu á endje mbœrœ she dœ ɔshɔ, awa bale ndje, a sœ ndje bala ɓata tœ ɨshirɨ uzu á tshe to ɓa lafo. ");
INSERT INTO mnh_vpl VALUES ("C115_50","076_15_50","1CO","15","50","50","Alaya, 'e wu œneke á mœ yindœ kœpa tœnœ dœke: Œneke á to lœ songba œdœ lœ indji lili kœli ga lœ Ogo gbozu nœ Ndjaba nene, yé œneke á gbaagba lili kœsœ awa bale dœ œneke á gba nene. ");
INSERT INTO mnh_vpl VALUES ("C115_51","076_15_51","1CO","15","51","51","Mœ sœ ndœ kœma o'o neke á zatœ ye yiwatœnœ fœ 'e. A tshu kɔ nene, kashe a fa bala tœ azœ kɔ ");
INSERT INTO mnh_vpl VALUES ("C115_52","076_15_52","1CO","15","52","52","ngbangi, dœ ɨkɨ aga ɓa tœ ndɔngɔlɔ osho. Gbambanœ nene, lɔkɔ á endje kœuru aga, akuzu œ she lœ kuzu dœ mara adœke endje kpa gba nene, yé azœ, a fatœ azœ bala ye. ");
INSERT INTO mnh_vpl VALUES ("C115_53","076_15_53","1CO","15","53","53","Œ li adœke œneke á gbaagba fa tœ œrœ á gba nene, yé œneke á tshuutshu fatœ endje tœ œneke á tshu nene. ");
INSERT INTO mnh_vpl VALUES ("C115_54","076_15_54","1CO","15","54","54","Ataa, lɔkɔ á œneke á gbaagba kœfa tœ œrœ á gba nene, yé œneke á tshuutshu kœfatœ endje tœ œneke á tshu nene, o'o ɓa la buku nœ Ndjaba á mbœrœ bala tœ endje dœke: «Kuzu kpa gugu nene! Gbɔgbɔ nœ Ndjaba ropa kuzu ye!» ");
INSERT INTO mnh_vpl VALUES ("C115_55","076_15_55","1CO","15","55","55","«Kuzu, gbɔgbɔ nœ zœ sœ kpœta a? Kuzu, œrœ kowo kœwo dœ azu nœ zœ sœ kpœta a?» ");
INSERT INTO mnh_vpl VALUES ("C115_56","076_15_56","1CO","15","56","56","Œrœ kowo nœ kuzu kœdœ ekperœ, yé gbɔgbɔ nœ ekperœ kœdœ awa akwa. ");
INSERT INTO mnh_vpl VALUES ("C115_57","076_15_57","1CO","15","57","57","Kashe a donga Ndjaba á tshe sœ kœmbœrœ adœke a ropa ekperœ œdœ kuzu lœ awa nœ Gbozu nœ azœ dœ Yisu Kristu! ");
INSERT INTO mnh_vpl VALUES ("C115_58","076_15_58","1CO","15","58","58","Ataa, alaya á mœ yindœ 'e waa, 'e shi gbɨ, 'e tuturutœ 'e nene, 'e zatœ 'e ɔlɔ dœ ɔlɔ ndœ akwa nœ Gbozu, mbœrœ á 'e wusœ nœ adœke ɔgbɔ akwa á 'e sœ kœmbœrœ tœnœ sœsœ gbambanœ lœ akwa nœ Gbozu nene. ");
INSERT INTO mnh_vpl VALUES ("C116_1","076_16_1","1CO","16","1","1","Tœ upu nœ kœngbɔɓa ngendja mbœrœ azu nœ Ndjaba ɓa lœ Yerusaleme, 'e mbœrœtœ 'e lindœ awa o'o á mœ za fœ azu Ikrizia kɔ ɓa lœ Galate. ");
INSERT INTO mnh_vpl VALUES ("C116_2","076_16_2","1CO","16","2","2","Ali olo lœ pɔsɔ bale dœ bale, uzu dœ uzu œ ko ngendja á tshe gbɔndœ nœ ga ɨndɨrɨnœ mbœrœ adœke endje kpa kœkakate adœke mœ na yeka á endje kœngbɔɓa nene. ");
INSERT INTO mnh_vpl VALUES ("C116_3","076_16_3","1CO","16","3","3","Lɔkɔ á mœ kœwuta ga zœ, mœ vwa endjeneke á 'e ke endje dœ mbeti adœke endje na dœ kœtorœ nœ 'e fœ azu Ikrizia ɓa lœ Yerusaleme. ");
INSERT INTO mnh_vpl VALUES ("C116_4","076_16_4","1CO","16","4","4","Œ kœli adœke mœ na ga zœ dœ tœ mœ, endje na tœ awanœ bale dœ mœ. ");
INSERT INTO mnh_vpl VALUES ("C116_5","076_16_5","1CO","16","5","5","Mœ na ga ndœ 'e manda kœro tɔ lœ Masedwane; gbambanœ nene, œ li adœke mœ vwanga djaga zœ. ");
INSERT INTO mnh_vpl VALUES ("C116_6","076_16_6","1CO","16","6","6","Mœ sœ kœwu adœke œndœ mœ ɨdɨ teasho kpœndœ 'e zœ, anganœ yapu nœ ɨzɨ djigi œ ro ye, mbœrœ á 'e kœtɨ kane mœ lœ udu ana gene nœ mœ. ");
INSERT INTO mnh_vpl VALUES ("C116_7","076_16_7","1CO","16","7","7","Mœ yiyindœ kœwu 'e ndara kolœ lafo nene, œdœ Gbozu kœyindœ nœ, mœ gbe ndœ kœlo kpœtœ manda olo ndjoro. ");
INSERT INTO mnh_vpl VALUES ("C116_8","076_16_8","1CO","16","8","8","Kashe mœ sœ lœ Efeze œrrr ga tœ olo nœ Patekɔte. ");
INSERT INTO mnh_vpl VALUES ("C116_9","076_16_9","1CO","16","9","9","Gbambanœ nene, manda kɔrɔ kpœmœ dœ egerœnœ adœke mœ mbœrœ akwa nœ mœ ye, ataa ayingba sœ ndjoro gbaa. ");
INSERT INTO mnh_vpl VALUES ("C116_10","076_16_10","1CO","16","10","10","Œdœ Timote kœna, 'e mbœrœ adœke tshe sœsœ dœ awa ugurutœ 'e nene, mbœrœ tshe sœ kœmbœrœ akwa nœ Gbozu ɓata mœ. ");
INSERT INTO mnh_vpl VALUES ("C116_11","076_16_11","1CO","16","11","11","Uzu bale vwavwaratœ ye tœ Timote nene. 'E tɨ kane ye ga lafo adœke tshe gu dœ kœsœ gee ga ndœ mœ, mbœrœ mœ sœ kœkate she dœ aaya lœ kœyindœrœ. ");
INSERT INTO mnh_vpl VALUES ("C116_12","076_16_12","1CO","16","12","12","Tœ upu nœ aya azœ dœ Apolo, mœ sœ kœto gbɔgbɔ fœ she adœke tshe ro ga ndœ 'e, œshe dœ aaya lœ kœyindœrœ, kashe tshe yiyindœ kœna ngɔngɔnœ asœ nene. Tshe na ga zœ œdœ tshe kœgbɔ awa. ");
INSERT INTO mnh_vpl VALUES ("C116_13","076_16_13","1CO","16","13","13","Ala 'e gbɔ, 'e shi gbɨ lœ kœyindœrœ, 'e sœ tœ ayakoshe, 'e sœ dœ gbɔgbɔ. ");
INSERT INTO mnh_vpl VALUES ("C116_14","076_16_14","1CO","16","14","14","'E mbœrœ akwa kɔ dœ kœyindœsho. ");
INSERT INTO mnh_vpl VALUES ("C116_15","076_16_15","1CO","16","15","15","Aaya lœ kœyindœrœ, anga o'o bale á kpa sœ mbœrœ 'e dœke: 'e wusœ nœ adœke Esetefanase dœ azu tshelœ bɨngɨ nœ ye kœdœ azu á endje yindœ Ndjaba utshunœ ɓa lœ Akayi; endje zatœ endje djigi ndœ kœmbœrœ akwa nœ azu nœ Ndjaba. ");
INSERT INTO mnh_vpl VALUES ("C116_16","076_16_16","1CO","16","16","16","Ataa, 'e mbœrœtœ 'e lindœ o'o mara azu ataa œdœ fœ endjeneke kɔ á endje sœ kœmbœrœ ɔgbɔ akwa awa bale dœ endje. ");
INSERT INTO mnh_vpl VALUES ("C116_17","076_16_17","1CO","16","17","17","Mœ sœ dœ yanga ndœ kœwu Esetefanase, Fortunatuse dœ pe Akayikuse. Lɔkɔ á mœ wu endje, œsœ ɓata mœ wu 'e para. ");
INSERT INTO mnh_vpl VALUES ("C116_18","076_16_18","1CO","16","18","18","Gbambanœ nene, endje mbœrœ adœke lɔsu mœ œdœ œnœ 'e sœ zɨtɨ. 'E wusœ kœlɨsœ mara azu ataa. ");
INSERT INTO mnh_vpl VALUES ("C116_19","076_16_19","1CO","16","19","19","Azu lœ Ikrizia kɔ ɓa lœ Azi vwa abala fœ 'e. Akilase, Prisika œdœ pe azu Ikrizia á endje sœ kœngbɔtœ endje ga tœnœ ɓa ndœ endje, vwa abala fœ 'e lœ ɨ'ɨrɨ Gbozu. ");
INSERT INTO mnh_vpl VALUES ("C116_20","076_16_20","1CO","16","20","20","Alaya para kɔkɔ lœ kœyindœrœ bala 'e. 'E za œyerœ abala lœ ugurutœ 'e. ");
INSERT INTO mnh_vpl VALUES ("C116_21","076_16_21","1CO","16","21","21","Œmœ Polo, mœ bala 'e, mœ su abala asœ dœ adja kane mœ dœ tœ mœ. ");
INSERT INTO mnh_vpl VALUES ("C116_22","076_16_22","1CO","16","22","22","Œdœ uzu kœyiyindœ Gbozu nene, endje darandœ ye. Maranata! ");
INSERT INTO mnh_vpl VALUES ("C116_23","076_16_23","1CO","16","23","23","Kaka ɔtshɔ lɔsu nœ Gbozu Yisu sœ dœ 'e. ");
INSERT INTO mnh_vpl VALUES ("C116_24","076_16_24","1CO","16","24","24","Mœ yindœ 'e kɔ lœ kœngbɔtœ 'e bale dœ Yisu Kristu.");
INSERT INTO mnh_vpl VALUES ("C21_1","077_1_1","2CO","1","1","1","Œmœ Polo, Ndjaba e mœ lindœ gbetshelœ nœ ye adœke mœ te ayi avwa nœ Yisu Kristu. A'a dœ aya azœ dœ Timote dá su mbetinœ asœke fœ 'e dœ azu Ikrizia nœ Ndjaba ɓa lœ Koriti œdœ fœ ayerœ azu nœ Ndjaba kɔ ɓa lœ ogo Akayi djigi. ");
INSERT INTO mnh_vpl VALUES ("C21_2","077_1_2","2CO","1","2","2","Kaka adœke Aba azœ dœ Ndjaba œdœ Gbozu nœ azœ dœ Yisu Kristu ma ɔtshɔ lɔsu ga ndœ 'e yé œ za kœsœ gee fœ 'e. ");
INSERT INTO mnh_vpl VALUES ("C21_3","077_1_3","2CO","1","3","3","A donga Ndjaba, Aba Gbozu nœ azœ dœ Yisu Kristu, Aba á tshe sœ dœ lɔsu nœ kœwu oyo yé á dœ Ndjaba á tshe sœ kœto gbɔgbɔ fœ azœ dœ mara kɔ. ");
INSERT INTO mnh_vpl VALUES ("C21_4","077_1_4","2CO","1","4","4","Tshe sœ kœto gbɔgbɔ fœ azœ lœ oyo nœ azœ kɔ mbœrœ adœke a li kœto ndje gbɔgbɔ á a gbɔ dœ tœ azœ ɓa ndœ Ndjaba fœ endjeneke á endje sœ lœ oyo. ");
INSERT INTO mnh_vpl VALUES ("C21_5","077_1_5","2CO","1","5","5","Gbambanœ nene, ɓata á a ngbɔtœ azœ awa bale dœ Kristu lœ kœwu œrœ kanga nœ ye asœmœ, Ndjaba œ to ndje egerœ gbɔgbɔ fœ azœ lœ awa nœ Kristu. ");
INSERT INTO mnh_vpl VALUES ("C21_6","077_1_6","2CO","1","6","6","Yé œdœ 'a kœsœ kœwu oyo, œ sœ mbœrœ adœke 'e gbɔ gbɔgbɔ œdœ kœshe. Œdœ 'a kœgbɔ gbɔgbɔ, œ sœ mbœrœ adœke 'e gbɔ gbɔgbɔ á mbœrœ adœke 'e shi gbɨ dœ ugu lɔsu lœ tshetœ oyo nœ 'a ndje á 'a sœ kœwu tœnœ. ");
INSERT INTO mnh_vpl VALUES ("C21_7","077_1_7","2CO","1","7","7","Ataa, 'a ko lɔsu 'a djigi ga pa 'e. Gbambanœ nene, 'a wusœ nœ adœke ɓata á 'e wu oyo awa bale dœ 'a asœmœ, Ndjaba œ to ndje gbɔgbɔ á tshe to ndje fœ 'a asœmœ fœ 'e. ");
INSERT INTO mnh_vpl VALUES ("C21_8","077_1_8","2CO","1","8","8","Alaya 'a, 'a yindœ nœ adœke 'e wusœ mara oyo á 'a wu ɓa lœ ogo Azi: kɨkɨlɨ oyo ro lima pa 'a ye, 'a lili lima kœru lɔsu 'a nene yé 'a kpa gbegbe lima adœke 'a sœ dœ soro nene. ");
INSERT INTO mnh_vpl VALUES ("C21_9","077_1_9","2CO","1","9","9","Dœ adjapu, 'a sœ lima kœwu adœke endje wa ɔgbɔ ngbanga nœ kuzu ga tœ 'a. Œ mbœrœtœ ye lima ataa mbœrœ á 'a kœzaza lɔsu 'a ga tœ 'a dœ tœ 'a nene, kashe kolœ fœ Ndjaba á tshe sœ dœ gbɔgbɔ kœshe azu lœ kuzu. ");
INSERT INTO mnh_vpl VALUES ("C21_10","077_1_10","2CO","1","10","10","Œshe dá she 'a lœ mara kuzu asœmœ, tshe kpa she 'a bala zœ. Dœ adjapu, 'a ko lɔsu 'a ga tœ ye adœke tshe kpa she 'a zœ. ");
INSERT INTO mnh_vpl VALUES ("C21_11","077_1_11","2CO","1","11","11","E'e ndje, 'e sœ kœtɨ kane 'a ga lafo lœ awa nœ avwala nœ 'e. Ataa, Ndjaba œ ma ɔtshɔ lɔsu mangba avwala á azu ndjoro za tœ upu nœ 'a, tshe to bala ɔtshɔrœnœ asœmœ fœ 'a yé azu ndjoro œ gi bala mershe fœ she tœ upu nœ 'a. ");
INSERT INTO mnh_vpl VALUES ("C21_12","077_1_12","2CO","1","12","12","Œrœ á a sœ kœzatœ azœ dœ yanga tœnœ dœke: ɓata á lɔsu 'a sœ kœma tœnœ, mara kœmbœrœtœ 'a pa tshapashɔnœ œdœ mara kœmbœrœtœ 'a ga ndœ 'e, 'a sœ kœmbœrœ dœ ɔmɔ lɔsu œdœ dœ adjapu nœ Ndjaba, 'a mbœmbœrœ dœ kœwusœtœ nœ azu nene, kashe 'a mbœrœ lœ awa nœ ɔtshɔ lɔsu nœ Ndjaba. ");
INSERT INTO mnh_vpl VALUES ("C21_13","077_1_13","2CO","1","13","13","Yé ɓala mbeti nœ 'a, 'a su kolœ œneke á 'e sœ kœdɨ tœnœ yé á sœ kœwusœ ádánœ. Kashe mœ wu adœke 'e wu bala sœ ádá œneke dœ ɔtshɔnœ, ");
INSERT INTO mnh_vpl VALUES ("C21_14","077_1_14","2CO","1","14","14","mbœrœ 'e wu kolœ sœ tshakalanœ: 'a dœ bala yanga nœ 'e ɓata e'e ndje, 'e dœ bala œnœ 'a dœ olo kœkwa Gbozu Yisu. ");
INSERT INTO mnh_vpl VALUES ("C21_15","077_1_15","2CO","1","15","15","Yé lœ kœko lɔsu mœ asœmœ, mœ gbe lima kœna ga ndœ 'e utshunœ mbœrœ adœke Ndjaba to bisha ɔtshɔ lɔsu nœ ye fœ 'e. ");
INSERT INTO mnh_vpl VALUES ("C21_16","077_1_16","2CO","1","16","16","Mœ yi lima ndœ kœna ɓa ndœ 'e, manda nœ á kœro ga lœ Masedwane. Lɔkɔ á mœ katœ Masedwane tɨ, mœ kwatœ mœ ga ndœ 'e mbœrœ adœke 'e tɨ kane mœ lœ ana nœ mœ ga lœ ogo Yuda. ");
INSERT INTO mnh_vpl VALUES ("C21_17","077_1_17","2CO","1","17","17","Lɔkɔ á mœ pa fœ 'e adœke mœ mbœrœ ataa, mœ pa o'o bisha lœ ama mœ a? Lɔkɔ á mœ kœka ga pa œneke á mœ yindœ kœmbœrœ tœnœ, mœ sœ kœmbœrœ tœnœ ɓata azu tshapashɔ dœ kœpa pa tshetœ œrœ adœke «œ̃» œdœ «œ̃œ̃» a? ");
INSERT INTO mnh_vpl VALUES ("C21_18","077_1_18","2CO","1","18","18","Ndjaba kœdœ timu nœ mœ tœ œneke á mœ pa lima fœ 'e, mœ papa fœ 'e «œ̃» œdœ «œ̃œ̃» pa tshetœ œrœ bale nene. ");
INSERT INTO mnh_vpl VALUES ("C21_19","077_1_19","2CO","1","19","19","Gbambanœ nene, Yisu Kristu, Gbolo nœ Ndjaba á 'a mɨndœ ye fœ 'e: Silve, Timote œdœ œmœ, papa «œ̃» œdœ «œ̃œ̃» pa tshetœ œrœ bale nene. Kashe, œshe kœdœ kolœ «œ̃». ");
INSERT INTO mnh_vpl VALUES ("C21_20","077_1_20","2CO","1","20","20","Yé œshe kœdœ «œ̃» á sœ kœma œneke á Ndjaba pa tœnœ. Lœ awa nœ Yisu Kristu dá 'a sœ kœpa «Ame» mbœrœ kœza mokɔ fœ Ndjaba. ");
INSERT INTO mnh_vpl VALUES ("C21_21","077_1_21","2CO","1","21","21","Yé Ndjaba dœ tœ ye dá sœ kœtepa azœ dœ 'e ngbɨrɨ lœ kœngbɔtœ azœ dœ Kristu. Ndjaba dá sœ kœke azœ dœ tœ ye. ");
INSERT INTO mnh_vpl VALUES ("C21_22","077_1_22","2CO","1","22","22","Tshe ta ambara á sœ kœma adœke azœ kœdœ agbolo nœ ye ga tœ azœ, yé œ to Ɔtshɔ Ɨshirɨ ga lɔsu azœ ɓata ɔtshɔrœ á tshe gbɔndœ nœ fœ azœ. ");
INSERT INTO mnh_vpl VALUES ("C21_23","077_1_23","2CO","1","23","23","Mœ za Ndjaba tœ timu œdœ mœ kœsœ kœpa wala, tshe wo mœ ye: œ sœ mbœrœ kœgbɔndœ 'e dá mœ wa adœke mœ kwatœ mœ ga lœ Koriti nene. ");
INSERT INTO mnh_vpl VALUES ("C21_24","077_1_24","2CO","1","24","24","'A sœsœ kœpara awa kœza œneke á li dœ kœyindœrœ nœ 'e dœ ɔgbɔ fœ 'e nene, kashe 'a gbe ndœ kœte ga ndœ yanga nœ 'e mbœrœ á 'e zatœ 'e dœ ɔtshɔnœ lœ kœyindœrœ. ");
INSERT INTO mnh_vpl VALUES ("C22_1","077_2_1","2CO","2","1","1","Tœ mœ nœ mœ, mœ wa adœke mœ kwatœ mœ ga ndœ 'e mbœrœ á kpa kœza oyo fœ 'e nene. ");
INSERT INTO mnh_vpl VALUES ("C22_2","077_2_2","2CO","2","2","2","Gbambanœ nene, œdœ mœ kœza oyo fœ 'e, eɗe dá za yanga fœ mœ a? Œ dœ́dœ́ uzunœ á mœ za oyo fœ she asœmœ nene a? ");
INSERT INTO mnh_vpl VALUES ("C22_3","077_2_3","2CO","2","3","3","Mbœrœ tœnœ ataa dá mœ su mbetinœ asœ fœ 'e kparawa adœke lɔkɔ á mœ kœwuta ɓa zœ, azu á sœ má adœke endje za yanga fœ mœ kœzaza oyo fœ mœ nene. Andaa mœ wusœ 'e kɔ, mœ wusœ nœ adœke œdœ mœ kœsœ dœ yanga, e'e ndje kɔ 'e sœ dœ yanga. ");
INSERT INTO mnh_vpl VALUES ("C22_4","077_2_4","2CO","2","4","4","Lɔkɔ á mœ su mbetinœ asœmœ fœ 'e, mœ sœ lima dœ oyo œdœ dœ gbetshelœ waa œrrr ga tœ ɨkɨ. Mœ susu mbetinœ mbœrœ kœza oyo fœ 'e nene, kashe mœ su mbœrœ 'e wusœ nœ adœke mœ yindœ 'e kœrosœ nœ. ");
INSERT INTO mnh_vpl VALUES ("C22_5","077_2_5","2CO","2","5","5","Œdœ uzu kœmbœrœ œrœ oyo fœ mœ, œ dœ́dœ́ kolœ fœ mœ kutɨ mœ dá tshe mbœrœ fœ mœ nene, kashe mbœrœ 'e kɔ yé a papa tœ œsœ nœ kœropanœ nene. ");
INSERT INTO mnh_vpl VALUES ("C22_6","077_2_6","2CO","2","6","6","Mbœrœ mara uzu ataa, œ li adœke azu ndjoro ugurutœ 'e gbagbara she. ");
INSERT INTO mnh_vpl VALUES ("C22_7","077_2_7","2CO","2","7","7","Mbœrœ tœnœ ataa, ngɔngɔnœ asœke, œ li adœke 'e ma ɔtshɔ lɔsu yé œ to gbɔgbɔ fœ she kparawa adœke tshe sœsœ kolœ lœ egerœ oyo waa nene. ");
INSERT INTO mnh_vpl VALUES ("C22_8","077_2_8","2CO","2","8","8","Mœ sœ kœpa fœ 'e adœke, 'e ma kœyindœsho nœ 'e ga ndœ ye. ");
INSERT INTO mnh_vpl VALUES ("C22_9","077_2_9","2CO","2","9","9","Gbambanœ nene, ádánœ á mœ su mbetinœ fœ 'e dœke: mœ yi má ndœ kœwu lɔsu 'e œdœ 'e kœsœ kœmbœrœtœ 'e djigi lindœ o'o ama mœ. ");
INSERT INTO mnh_vpl VALUES ("C22_10","077_2_10","2CO","2","10","10","Œdœ 'e kœdjerœndœ ekperœ nœ uzu, mœ djerœ ndje ndœ nœ ye. Yé œdœ mœ kœdjerœndœ ekperœ nœ ye dœ mara ɓata á mœ mbœrœ asœmœ, mœ mbœrœ mbœrœ 'e ɓa utshu Kristu, ");
INSERT INTO mnh_vpl VALUES ("C22_11","077_2_11","2CO","2","11","11","mbœrœ adœke Satana kœgbɔgbɔ awa kœfara azœ nene. Gbambanœ nene, a wusœ gbetshelœ nœ ye dœ ɔtshɔnœ. ");
INSERT INTO mnh_vpl VALUES ("C22_12","077_2_12","2CO","2","12","12","Lɔkɔ á mœ wuta ɓa lœ Trowase mbœrœ kœpandœ Ɔtshɔ O'o nœ Kristu, mœ wu adœke Gbozu za lima ɔtshɔ awa á li fœ mœ adœke mœ pandœ nœ. ");
INSERT INTO mnh_vpl VALUES ("C22_13","077_2_13","2CO","2","13","13","Andaa, mœ sœ lima dœ awa waa mbœrœ á mœ gbɔgbɔ lima aya mœ dœ Tito nene. Mœ ka lima tœ azu Trowase tɨ yé á ro ga lœ Masedwane. ");
INSERT INTO mnh_vpl VALUES ("C22_14","077_2_14","2CO","2","14","14","A donga Ndjaba mbœrœ á tshe gi azœ na tœnœ adœke a ropa koshe lœ awa nœ Kristu, yé á sœ kœmbœrœ adœke tshafu yombo nœ kœwusœ ye za osho djigi lœ awa nœ azœ. ");
INSERT INTO mnh_vpl VALUES ("C22_15","077_2_15","2CO","2","15","15","Yé azœ kœdœ yombo nœ Kristu á tshafunœ ga waa á tshe to fœ Ndjaba mbœrœ endjeneke á endje she œdœ endjeneke á endje sœ lœ djingili. ");
INSERT INTO mnh_vpl VALUES ("C22_16","077_2_16","2CO","2","16","16","Mbœrœ anga azu, œtœnœ kœdœ tshafu kuzu á sœ kœyi osho ga lœ kuzu; mbœrœ anga endje, œtœnœ kœdœ tshafu soro á sœ kœyi osho ga lœ soro. Yé eɗe dá li kœmbœrœ mara akwanœ ata a? ");
INSERT INTO mnh_vpl VALUES ("C22_17","077_2_17","2CO","2","17","17","'A sœsœ ɓata anga azu á endje za o'o ama Ndjaba tœ kœyɔrœ nene, kashe mbœrœ á Ndjaba dá vwa 'a, 'a sœ kœpa dœ adjapu ɓa utshu ye lœ kœngbɔtœ 'a awa bale dœ Kristu. ");
INSERT INTO mnh_vpl VALUES ("C23_1","077_3_1","2CO","3","1","1","'A kpa donga tœ 'a dœ tœ 'a a? Too 'a gbe kœmbœrœ ɓata anga azu adœke 'a ma mbeti á endje donga 'a alanœ fœ 'e too 'a yɔshondœ nœ ɓa ndœ e'e a? ");
INSERT INTO mnh_vpl VALUES ("C23_2","077_3_2","2CO","3","2","2","Mbeti nœ 'a kœdœ e'e, mbeti á endje sú ga lɔsu 'a á azu kɔ wusœ nœ ye á dɨ. ");
INSERT INTO mnh_vpl VALUES ("C23_3","077_3_3","2CO","3","3","3","Œ sœ adjapu adœke, e'e kœdœ mbeti á Kristu su yé 'a sœ kœgbɔndœ nœ. Mbetinœ asœmœ, tshe susu dœ tadja nene kashe tshe su dœ Ɨshirɨ nœ Ndjaba nœ soro; tshe susu tœnœ ga pa ndaba tame nene, kashe tshe su ga pa ndaba songba ɓa tœ lɔsu 'e. ");
INSERT INTO mnh_vpl VALUES ("C23_4","077_3_4","2CO","3","4","4","'A sœ kœpa ataa gbambanœ nene, 'a za lɔsu 'a ga pa Ndjaba lœ awa nœ Kristu. ");
INSERT INTO mnh_vpl VALUES ("C23_5","077_3_5","2CO","3","5","5","'A wusœ nœ adœke 'a lili kœmbœrœ ataa dœ gbɔgbɔ nœ 'a dœ tœ 'a nene, kashe gbɔgbɔ nœ 'a to ɓa ndœ Ndjaba. ");
INSERT INTO mnh_vpl VALUES ("C23_6","077_3_6","2CO","3","6","6","Œshe dá to gbɔgbɔ fœ 'a adœke 'a wuta aayi akwa tœ upu nœ kœmɨndœ tafo ayo. Tafo ayonœ asœmœ dœ́dœ́ awa akwa á endje sú nene, kashe Ɔtshɔ Ɨshirɨ dá sœ kœyisœ awa fœ 'a. Awa akwa á endje sú sœ kœyi azu ga lœ kuzu utshu Ndjaba, kashe Ɔtshɔ Ɨshirɨ sœ kœto soro. ");
INSERT INTO mnh_vpl VALUES ("C23_7","077_3_7","2CO","3","7","7","Ndjaba su lima akwa nœ kuzu dœ mbeti ga pa tame yé mokɔ nœ ye sœ lima kœtshi panœ. Tshatshu Moyize sœ lima kœtshi tœnœ dœ mara adœke azu Israyele li kœtondœ ye nene, andaa œndœ kœtshi tœnœ dɨdɨ lima nene. ");
INSERT INTO mnh_vpl VALUES ("C23_8","077_3_8","2CO","3","8","8","Ataa, akwa neke á Ɨshirɨ sœ kœmbœrœ tœnœ œ sœ dœ mokɔ tɔpanœ kpuru nene a? ");
INSERT INTO mnh_vpl VALUES ("C23_9","077_3_9","2CO","3","9","9","Yé œdœ akwa á sœ lima kœyi azu ga lœ kuzu kœsœ dœ mokɔ, œneke á sœ kœmbœrœ adœke azu sœ ndjii ɓa utshu Ndjaba œ sœ dœ mokɔ tɔpanœ kpuru ye! ");
INSERT INTO mnh_vpl VALUES ("C23_10","077_3_10","2CO","3","10","10","A li kœpa ndje adœke mokɔ á sœ lima kœtshi tœnœ katshatsha, œ djerœwa ɓa utshu mokɔ neke á ropanœ ngɔngɔ asœke. ");
INSERT INTO mnh_vpl VALUES ("C23_11","077_3_11","2CO","3","11","11","Gbambanœ nene, œdœ œneke á œndœnœ dɨdɨ lima nene kœsœ dœ mokɔ, œnœ œneke á sœ waa dœ waa œ sœ koto o? ");
INSERT INTO mnh_vpl VALUES ("C23_12","077_3_12","2CO","3","12","12","Ɓata á 'a sœ kœko lɔsu 'a ga tœ adja o'onœ asœmœ ataa, 'a yindœ nœ dœ lɔsu 'a. ");
INSERT INTO mnh_vpl VALUES ("C23_13","077_3_13","2CO","3","13","13","'A sœsœ kœmbœrœ ɓata Moyize á tshe za lima siriki tshu ga utshu ye mbœrœ adœke agbolo Israyele kœwuwu mara á kœtshinœ, á œndœnœ dɨdɨ nene asœmœ, œ yiwa dœ tœnœ nene. ");
INSERT INTO mnh_vpl VALUES ("C23_14","077_3_14","2CO","3","14","14","Kashe kœwusœrœ nœ endje sœ lima lœ ubu osho! Yé œrrr ga tœ olo asœke, tshetœ sirikinœ asœmœ sœ zœ lɔkɔ á endje kœsœ kœdɨ buku nœ ongboro ayo. Kolœ lœ awa nœ Kristu dá sirikinœ asœmœ œ yiwa. ");
INSERT INTO mnh_vpl VALUES ("C23_15","077_3_15","2CO","3","15","15","Dœ adjapu, œrrr kpesheke nœ asœ, lɔkɔ bale dœ bale á endje kœsœ kœdɨ buku nœ Moyize, siriki sœ ɓa lɔsu endje. ");
INSERT INTO mnh_vpl VALUES ("C23_16","077_3_16","2CO","3","16","16","Œ sœ kolœ lœ awa nœ kœfatshalɔsu ga ndœ Gbozu dá sirikinœ œ te. ");
INSERT INTO mnh_vpl VALUES ("C23_17","077_3_17","2CO","3","17","17","Gbambanœ nene, Gbozu kœdœ Ɨshirɨ. Yé osho á Ɨshɨrɨ nœ Gbozu sœ tœnœ, œtœnœ kœdœ osho á azu dœ́dœ́ akanga nene. ");
INSERT INTO mnh_vpl VALUES ("C23_18","077_3_18","2CO","3","18","18","Azœ kɔ a gi siriki tshatshu azœ ye, a ma mokɔ nœ Gbozu. Ataa, a fatœ azœ mbœrœ kœsœ awa bale ɓata Gbozu dœ mokɔ á sœ kolœ tœ egerœnœ lœ awa nœ ye á tshe dœ Ɨshirɨ. ");
INSERT INTO mnh_vpl VALUES ("C24_1","077_4_1","2CO","4","1","1","Ɓata á Ndjaba wu oyo 'a yé á za akwanœ asœke fœ 'a, 'a mɔmɔ lœ ɔkɔ 'a nene. ");
INSERT INTO mnh_vpl VALUES ("C24_2","077_4_2","2CO","4","2","2","'A vwaratœ 'a tœ œrœ nœ tshula kɔ á zatœ endje yiwa tœnœ, 'a sœsœ kœmbœrœ œrœ dœ afara nene yé œ sœsœ ndje kœfatshelœ o'o ama Ndjaba nene. Kashe 'a sœ kœyisœ adjapu ngbɨ, yé œ sœ kœpara awa adœke azu kɔ yindœ 'a ɓa utshu Ndjaba. ");
INSERT INTO mnh_vpl VALUES ("C24_3","077_4_3","2CO","4","3","3","Andaa, œdœ Ɔtshɔ O'o á 'a sœ kœmɨndœ nœ kœsœsœ ngbɨ nene, œ sœ kolœ mbœrœ azu á endje sœsœ dœ kœyindœrœ nene. ");
INSERT INTO mnh_vpl VALUES ("C24_4","077_4_4","2CO","4","4","4","Endje sœsœ dœ kœyindœrœ nene mbœrœ ndjaba nœ tshapashɔ asœke, bu ala endje dœ kœwusœrœ nœ endje ga tœnœ ye. Tshe sœ kœpakata endje adœke endje wu ɨshirɨ osho á Ɔtshɔ O'o tœ upu nœ mokɔ nœ Kristu á tshe dœ ɨshirɨ Ndjaba, sœ kœmɨndœ nœ. ");
INSERT INTO mnh_vpl VALUES ("C24_5","077_4_5","2CO","4","5","5","'A yiyisœ œrœ tœ 'a dœ tœ 'a nene, kashe á sœ kœyisœ œrœ tœ upu nœ Gbozu Yisu Kristu. Tœ a'a nœ 'a, 'a sœ kœpa ngbɨ adœke a'a kœdœ aayi akwa nœ 'e mangba Yisu. ");
INSERT INTO mnh_vpl VALUES ("C24_6","077_4_6","2CO","4","6","6","Gbambanœ nene, Ndjaba á tshe pa lima adœke: «Kaka adœke ɨshirɨ osho tshi ɓa ugurutœ ubu osho narɨ!» Œshe dœ tœ ye dá tshi ɓa tœ lɔsu 'a mbœrœ kœto kœwusœrœ lœ mokɔ nœ ye á matœ ye ɓa tshatshu Kristu. ");
INSERT INTO mnh_vpl VALUES ("C24_7","077_4_7","2CO","4","7","7","Kashe a'a dá Ndjaba za kœgbɔrœnœ asœmœ fœ 'a, yé á sœ kœgbɔndœ nœ ɓa lœ lɔsú. 'A sœ kœyisœ nœ adœke gbɔgbɔnœ á rosœ nœ asœmœ to ɓa ndœ Ndjaba, kashe œ toto ɓa ndœ a'a nene. ");
INSERT INTO mnh_vpl VALUES ("C24_8","077_4_8","2CO","4","8","8","'A sœ kœwu tshelœ áká oyo ngbangbangba kashe œ roropa 'a nene; 'a sœ dœ awa tœ lɔsu 'a, kashe 'a gigi lɔsu 'a tœ Ndjaba nene. ");
INSERT INTO mnh_vpl VALUES ("C24_9","077_4_9","2CO","4","9","9","Azu mbœrœ œrœ kanga fœ 'a, kashe Ndjaba kakatœ 'a nene. Endje ko 'a vesho, kashe 'a tshutshu nene. ");
INSERT INTO mnh_vpl VALUES ("C24_10","077_4_10","2CO","4","10","10","Ɔlɔ dœ ɔlɔ, 'a sœ dœ koɓa kuzu nœ Yisu lœ ɔkɔ 'a mbœrœ adœke soro nœ ye yi ndje tœ ye ga lœ ɔkɔ 'a. ");
INSERT INTO mnh_vpl VALUES ("C24_11","077_4_11","2CO","4","11","11","Lœ soro nœ 'a djigi, 'a sœ lœma kuzu mangba Yisu, mbœrœ adœke soro nœ ye li ndje ga lœ undu 'a œnœ kuzu. ");
INSERT INTO mnh_vpl VALUES ("C24_12","077_4_12","2CO","4","12","12","Ataa, kuzu sœ kœli dœ akwa ga lœ 'a, kashe 'e sœ kœgbɔ soro. ");
INSERT INTO mnh_vpl VALUES ("C24_13","077_4_13","2CO","4","13","13","Endje sú ɓa la Buku nœ Ndjaba adœke: «Mœ sœ dœ kœyindœrœ mbœrœ tœnœ á mœ pa o'o.» A'a ndje lœ tshetœ gbetshelœ nœ kœyindœrœ asœmœ, 'a sœ dœ kœyindœrœ yé mbœrœ tœnœ dá 'a sœ kœpa o'o. ");
INSERT INTO mnh_vpl VALUES ("C24_14","077_4_14","2CO","4","14","14","Gbambanœ nene, 'a wusœ nœ adœke Ndjaba á tshe she Gbozu Yisu lœ akuzu, tshe she ndje azœ awa bale dœ Yisu yé œ ko 'a dœ 'e ga ɨndɨrɨ ye. ");
INSERT INTO mnh_vpl VALUES ("C24_15","077_4_15","2CO","4","15","15","Œneke kɔ á 'a sœ kœshi gbɨ lœ nœ, œ sœ mbœrœ 'e mbœrœ adœke azu sœ kœli ga panœ ga panœ ga lœ ɔtshɔ lɔsu nœ Ndjaba. Ataa, azu œ ngba mbœrœ kœgi mershe œdœ mbœrœ kœdonga mokɔ nœ Ndjaba. ");
INSERT INTO mnh_vpl VALUES ("C24_16","077_4_16","2CO","4","16","16","Mbœrœ tœnœ ataa, 'a mɔmɔ nene. Ataa œdœ soro nœ 'a œnœ azu kœsœ kœmɔ tœnœ yima yima, soro nœ 'a œnœ ɨshirɨ sœ kœkwa tœnœ ɔlɔ dœ ɔlɔ. ");
INSERT INTO mnh_vpl VALUES ("C24_17","077_4_17","2CO","4","17","17","Gbambanœ nene, oyo á 'a sœ kœwu tœnœ manda olo teasho, œ sœ kœguma mokɔ neke á sœ waa dœ waa yé á gerœ kœropanœ, fœ azœ. ");
INSERT INTO mnh_vpl VALUES ("C24_18","077_4_18","2CO","4","18","18","'A koko lɔsu 'a nene ga pa œrœ á a wu, kashe 'a ko lɔsu 'a ga pa œneke á a wuwu nene. Gbambanœ nene, œndœ œrœ á a wu dɨdɨ nene, kashe œndœ œneke á a wuwu nene sœ kœdɨ tœnœ waa dœ waa. ");
INSERT INTO mnh_vpl VALUES ("C25_1","077_5_1","2CO","5","1","1","Gbambanœ nene, a wusœ nœ adœke œdœ undu azœ œnœ ɔshɔ asœke á sœ ɓata anda tande kœndɨ, a sœ dœ anga anda á Ndjaba mɔ á sœ waa dœ waa ɓa lafo. Œ dœ́dœ́ azu dá mɔ andanœ asœmœ dœ kane endje nene. ");
INSERT INTO mnh_vpl VALUES ("C25_2","077_5_2","2CO","5","2","2","Ngɔngɔ asœke, a sœ kœpulœma azœ mbœrœ á a sœ dœ egerœ ogo adœke a li ga lœ anda œnœ tshalafo. ");
INSERT INTO mnh_vpl VALUES ("C25_3","077_5_3","2CO","5","3","3","Œ mbœrœtœ endje kolœnœ adœke a sœ dœ lœba tœ azœ yé a sœsœ kpendronœ nene. ");
INSERT INTO mnh_vpl VALUES ("C25_4","077_5_4","2CO","5","4","4","Adjapu, ɓata á a sœpe damba lœ anda tandenœ asœmœ, a pulœma zœ ɓata a gbɔ upu. Œ sœsœ adœke a yindœ kœ'eatœ azœ tœ ɔkɔ azœ œnœ tshapashɔ nene, a yindœ kœverœ tafo ɔkɔ azœ œnœ tshalafo ga panœ mbœrœ adœke œneke á tshuutshu, fa tœ œneke á tshu nene. ");
INSERT INTO mnh_vpl VALUES ("C25_5","077_5_5","2CO","5","5","5","Tsheneke á tshe guma azœ mbœrœ tshambatshanœ asœmœ, kœdœ Ndjaba. Tshe za Ɨshirɨ nœ ye fœ azœ tœ ndanga nœ ɔtshɔrœ á tshe gbɔndœ nœ fœ azœ ɓa lafo. ");
INSERT INTO mnh_vpl VALUES ("C25_6","077_5_6","2CO","5","6","6","Mbœrœ tœnœ ataa, a su kolœnœ dœ kœyindœrœ tœ lɔsu azœ. A wusœ nœ adœke ɓata á a sœpe damba lœ ɔkɔnœ asœke, a sœ ɓa ushu tœ anda nœ azœ, lœ ɨngɨrɨnœ tœ Gbozu. ");
INSERT INTO mnh_vpl VALUES ("C25_7","077_5_7","2CO","5","7","7","Gbambanœ nene, a sœ kœro manda kœyindœrœ kashe œ dœ́dœ́ manda œneke á a sœ kœwu dœ ala azœ nene. ");
INSERT INTO mnh_vpl VALUES ("C25_8","077_5_8","2CO","5","8","8","Adjapu, a su dœ kœyindœrœ tœ lɔsu azœ yé a gbe kœkatœ anda œnœ ɔkɔ azœ asœke mbœrœ kœna kœsœ ndoo dœ Gbozu. ");
INSERT INTO mnh_vpl VALUES ("C25_9","077_5_9","2CO","5","9","9","Kashe ataa œdœ a kœsœ lœ ɔkɔ asœke too a kœgitœ azœ lœnœ, ogo nœ azœ utshunœ kɔ kœdœ adœke a za yanga fœ she. ");
INSERT INTO mnh_vpl VALUES ("C25_10","077_5_10","2CO","5","10","10","Gbambanœ nene, œ li adœke azœ kɔ a na ga utshu Kristu mbœrœ adœke tshe wa ngbanga nœ azœ. Dœ tœnœ ataa, uzu dœ uzu œ gbɔ œrœ tshangba œneke á tshe mbœrœ lœ soro ye ɓa pa ɔshɔ, too lœ ɔtshɔrœ too lœ ekperœ. ");
INSERT INTO mnh_vpl VALUES ("C25_11","077_5_11","2CO","5","11","11","Ɓata á 'a wusœ mara á li adœke a kpa dœ awa Gbozu asœmœ, 'a sœ kœmbœrœ kɔ adœke azu yindœ o'onœ asœmœ. Ndjaba wusœ azœ dœ ɔtshɔnœ yé mœ sœ kœgbe adœke ɓa lœ 'e dœ tœ 'e, 'e wu ndje sœ mœ ye. ");
INSERT INTO mnh_vpl VALUES ("C25_12","077_5_12","2CO","5","12","12","'A kpa yiyindœ kœdonga tœ 'a dœ tœ 'a ɓa utshu 'e nene, kashe 'a sœ kœgbe adœke 'e donga tœ 'e mbœrœ 'a. Ataa, á 'e kœwusœ kœgi o'o fœ azu á endje sœ kœdonga tœ endje tœ œneke á sœ kœmatœ endje ngbɨ ga tœ ala azu, kashe á endje wuwusœ œneke á sœ ɓa lɔsu uzu nene. ");
INSERT INTO mnh_vpl VALUES ("C25_13","077_5_13","2CO","5","13","13","Œ kœsœ dœ adjapu adœke 'a wuta agbakɨndɨ azu, 'a wuta ataa mbœrœ upu nœ Ndjaba. Kashe œ kœsœ adœke 'a wuta azu nœ ɔtshɔ gbetshelœ, 'a wuta ataa mbœrœ 'e. ");
INSERT INTO mnh_vpl VALUES ("C25_14","077_5_14","2CO","5","14","14","Gbambanœ nene, kœyindœsho nœ Kristu ropa azœ, yé a wusœ nœ adœke uzu bale tshu tœ upu nœ azu kɔ, azu kɔ tshu dœ she awa bale. ");
INSERT INTO mnh_vpl VALUES ("C25_15","077_5_15","2CO","5","15","15","Tshe tshu tœ upu nœ azu kɔ mbœrœ adœke endjeneke á endje sœ dœ soro, kœsœsœ dœ tœnœ mbœrœ endje dœ tœ endje nene, kashe endje sœ dœ tœnœ mbœrœ tsheneke á tshe tshu yé á kwatœ ye ga lœ soro mbœrœ endje. ");
INSERT INTO mnh_vpl VALUES ("C25_16","077_5_16","2CO","5","16","16","Mbœrœ tœnœ ataa, kœto kpesheke, 'a kpa wuwusœ uzu bale tœ mara nœ azu nene. Ataa œdœ 'a kœwu lima sœ Kristu ɓata uzu gbaa, ngɔngɔnœ asœke 'a kpa wuwusœ ye atamœ nene. ");
INSERT INTO mnh_vpl VALUES ("C25_17","077_5_17","2CO","5","17","17","Œdœ uzu kœngbɔtœ ye bale dœ Kristu, tshe wuta tafo uzu ye: œneke á dœ ongboro œrœ yiwa ye, kashe tafo œrœ dá sœ zœ. ");
INSERT INTO mnh_vpl VALUES ("C25_18","077_5_18","2CO","5","18","18","Œrœ asœmœ kɔ to ɓa ndœ Ndjaba. Tshe gi ayo ga ugurutœ azœ dœ she lœ awa nœ Kristu yé œ za akwa nœ kœgi ayo fœ azœ. ");
INSERT INTO mnh_vpl VALUES ("C25_19","077_5_19","2CO","5","19","19","Gbambanœ nene, lœ awa nœ Kristu, Ndjaba gi ayo ga ugurutœ ye dœ azu kɔ; tshe gbegbe dœ ekperœ nœ endje nene. Yé tshe za o'o nœ kœgi ayonœ asœmœ fœ azœ. ");
INSERT INTO mnh_vpl VALUES ("C25_20","077_5_20","2CO","5","20","20","Dœ ɨ'ɨrɨ Kristu dá 'a dœ aayi avwa, yé Ndjaba dœ tœ ye dá sœ kœ'e 'e lœ awa nœ 'a. 'A sœ kœkɨ fœ 'e dœ ɨ'ɨrɨ Kristu adœke 'e zatœ 'e tɨ adœke Ndjaba gi ayo ga ugurutœ 'e dœ she. ");
INSERT INTO mnh_vpl VALUES ("C25_21","077_5_21","2CO","5","21","21","Kristu mbœmbœrœ lima ekperœ nene, tshe gbɔ œtœnœ mbœrœ azœ. Tshe li ga lœ ekperœ nœ asœmœ mbœrœ adœke a kœwuta ndjii tœ ala Ndjaba lœ awa nœ ye. ");
INSERT INTO mnh_vpl VALUES ("C26_1","077_6_1","2CO","6","1","1","Ataa, ɓata á 'a sœ kœmbœrœ akwa awa bale dœ Ndjaba, 'a sœ kœkɨ fœ 'e adœke 'e wuwu ɔtshɔ lɔsu á tshe ma ga ndœ 'e gbambanœ nene. ");
INSERT INTO mnh_vpl VALUES ("C26_2","077_6_2","2CO","6","2","2","Gbambanœ nene, Ndjaba pa adœke: «Dœ lɔndɔ á mœ sœ lima kœma ɔtshɔ lɔsu nœ mœ, mœ dji lima ɓœ. Dœ olo nœ kœshe, mœ tɨ kane zœ ga lafo.» 'E wu ngɔngɔ asœke lɔkɔ á li dœ Ndjaba kœma ɔtshɔ lɔsu nœ ye ga ndœ azu dœke. Œtœnœ kœdœ olo kœgbɔ kœshe. ");
INSERT INTO mnh_vpl VALUES ("C26_3","077_6_3","2CO","6","3","3","'A yiyindœ kœmbœrœ œrœ á li adœke uzu bale te nene mbœrœ 'a yiyindœ nœ adœke endje kɨtœ œsœ akwa nœ 'a nene. ");
INSERT INTO mnh_vpl VALUES ("C26_4","077_6_4","2CO","6","4","4","Kashe 'a sœ kœpara lœ œrœ kɔ adœke 'a sœ ɓata ɔtshɔ aayi akwa nœ Ndjaba, 'a sœ kœru lɔsu 'a lœ œrœ oyo kɔ tœ lɔsu 'a, lœ œrœ kanga kɔ œdœ lœ œneke kɔ á sœ kœza lɔsu 'a ga lafo. ");
INSERT INTO mnh_vpl VALUES ("C26_5","077_6_5","2CO","6","5","5","Endje ɓi 'a yé œ ko 'a ga lœ kánga, endje tshi azu ga lafo ndœ 'a. 'A mɔ dœ ɔgbɔ akwa, 'a lolo olo yé œ zɨ œrœ nene. ");
INSERT INTO mnh_vpl VALUES ("C26_6","077_6_6","2CO","6","6","6","'A matœ 'a tœ aayi akwa nœ Ndjaba lœ awa nœ œyerœ lɔsu 'a, lœ awa nœ kœwusœrœ nœ 'a, lœ awa nœ ugu lɔsu, lœ awa nœ ɔtshɔ́ ɔtshɔ, lœ awa nœ akwa nœ Ɔtshɔ Ɨshirɨ, œdœ pe lœ awa nœ adja kœyindœsho nœ 'a. ");
INSERT INTO mnh_vpl VALUES ("C26_7","077_6_7","2CO","6","7","7","'A matœ 'a tœ aayi akwa nœ Ndjaba lœ awa nœ kœyisœ adja o'o œdœ mangba gbɔgbɔ nœ Ndjaba. Kowo nœ 'a kœyi dœ koshe œdœ kœkɔ dœ koshe kœdœ kœmbœrœ œneke á sœ ndjii tœ ala Ndjaba. ");
INSERT INTO mnh_vpl VALUES ("C26_8","077_6_8","2CO","6","8","8","Azu sœ kœlɨsœ 'a, anga endje sœ kœmɔ 'a. Azu sœ kœpa ekpe o'o tœ upu nœ 'a, anga endje sœ kœpa ɔtshɔ o'o nœ 'a. Azu sœ kœwu 'a ɓata aayi wala andaa 'a sœ kœpa adja o'o. ");
INSERT INTO mnh_vpl VALUES ("C26_9","077_6_9","2CO","6","9","9","Azu sœ kœwu 'a ɓata angbɨ azu, andaa endje wusœ 'a dœ ɔtshɔnœ. Azu sœ kœwu 'a ɓata a'a kœdœ akuzu, andaa 'a sœ dœ soro. Azu sœ kœza djofele fœ 'a, kashe endje wowo 'a nene. ");
INSERT INTO mnh_vpl VALUES ("C26_10","077_6_10","2CO","6","10","10","Azu sœ kœza oyo ga tœ lɔsu 'a, andaa 'a sœ kolœ dœ yanga. A'a kœdœ aayi oyo, kashe azu ndjoro te aayi kœgbɔrœ mangba 'a. 'A sœ ɓata azu á endje gugu dœ œrœ nene, andaa 'a sœ dœ œrœ kɔ. ");
INSERT INTO mnh_vpl VALUES ("C26_11","077_6_11","2CO","6","11","11","E'e dœ azu Koriti, 'a pa adja o'o fœ 'e, 'a kɔrɔ lɔsu 'a tœ egerœnœ fœ 'e. ");
INSERT INTO mnh_vpl VALUES ("C26_12","077_6_12","2CO","6","12","12","'A yindœ 'e waa, kashe e'e dá yiyindœ 'a nene. ");
INSERT INTO mnh_vpl VALUES ("C26_13","077_6_13","2CO","6","13","13","Mbœrœ tœnœ ataa, mœ sœ kœpa fœ 'e ɓata mœ sœ kœpa fœ agbolo nœ mœ adœke, 'e yi ndje ndœ 'a ɓata á 'a yindœ 'e asœmœ yé œ kɔrɔ lɔsu 'e tœ egerœnœ fœ 'a. ");
INSERT INTO mnh_vpl VALUES ("C26_14","077_6_14","2CO","6","14","14","Adja 'e ngbɔngbɔtœ 'e awa bale dœ azu á endje gugu dœ kœyindœrœ ga ndœ Kristu asœmœ nene. Gbambanœ nene, œrœ á sœ ndjii li kœngbɔtœ ye dœ ekperœ ye a? Ɨngbɨsho li kœngbɔtœ ye dœ ubu osho ye a? ");
INSERT INTO mnh_vpl VALUES ("C26_15","077_6_15","2CO","6","15","15","Kristu li kœdjitœ ye dœ djaboro ye a? Too ga panœ, œrœ gaɗe dá yindœ Kristu œ gbɔ awa bale dœ uzu á tshe yiyindœ Kristu nene a? ");
INSERT INTO mnh_vpl VALUES ("C26_16","077_6_16","2CO","6","16","16","Œrœ gaɗe bale dá li kœngbɔɓa Tepelo nœ Ndjaba dœ andjaba nœ angbɨ azu a? Gbambanœ nene, a'a, 'a kœdœ Tepelo nœ Ndjaba nœ soro ɓata á Ndjaba pa dœ tœ ye adœke: «Mœ sœ bala yé œ na bala ana ugurutœ endje. Mœ dœ bala Ndjaba nœ endje yé endje dœ bala azu nœ mœ.» ");
INSERT INTO mnh_vpl VALUES ("C26_17","077_6_17","2CO","6","17","17","Mbœrœ tœnœ ataa, Gbozu pa adœke: «Œ li adœke 'e gitœ 'e tœ endje yé œ sœ kpi. 'E tuturu tœ œrœ uburu nœ endje nene, yé atamœ, mœ yi bala ndœ 'e. ");
INSERT INTO mnh_vpl VALUES ("C26_18","077_6_18","2CO","6","18","18","Œmœ Gbozu nœ gbɔgbɔ kɔ, mœ pa adœke mœ dœ bala aba 'e, yé 'e dœ ndje bala agbolo yakoshe œdœ ayawuru nœ mœ.» ");
INSERT INTO mnh_vpl VALUES ("C27_1","077_7_1","2CO","7","1","1","E'e dœ anga mœ á mœ yindœ 'e waa, œrœnœ asœmœ kɔ á Ndjaba pandœ nœ sœ dœ ɔtshɔnœ mbœrœ azœ. Mbœrœ tœnœ ataa, a vwaratœ azœ tœ œrœ kɔ á mbœrœ adœke ɔkɔ uzu too ɨshirɨ uzu sœ dœ uburu. A pa avwara kœsœ adja ayerœ azu lœ kœkpa awa Ndjaba. ");
INSERT INTO mnh_vpl VALUES ("C27_2","077_7_2","2CO","7","2","2","'E kɔrɔ lɔsu 'e fœ 'a! 'A mbœmbœrœ ekperœ fœ uzu bale nene, 'a mbœmbœrœ adœke uzu bale te nene, 'a bɨbɨlɨ ndje anga uzu bale mbœrœ kœgbɔ œrœ tshaabrœ ye nene. ");
INSERT INTO mnh_vpl VALUES ("C27_3","077_7_3","2CO","7","3","3","Mœ sœsœ kœpa ataa mbœrœ kœwa ɔgbɔ ngbanga ga tœ 'e nene. Gbambanœ nene, mœ pandœ nœ fœ 'e adœke e'e kœdœ azu á 'e sœ ɓa tœ lɔsu 'a, azu á 'a ngbɔtœ 'a bale dœ endje lœ soro too lœ kuzu. ");
INSERT INTO mnh_vpl VALUES ("C27_4","077_7_4","2CO","7","4","4","Mœ za lɔsu mœ tœ egerœnœ ga ndœ 'e, mœ donga tœ mœ mbœrœ 'e waa. Lœ oyo nœ 'a kɔ tœ lɔsu 'a, mœ sœ kolœ dœ gbɔgbɔ œdœ dœ yanga kœropa nœ. ");
INSERT INTO mnh_vpl VALUES ("C27_5","077_7_5","2CO","7","5","5","Ataa ndje dœ lɔkɔ kœwuta 'a ga lœ ogo Masedwane, 'a yaya lima tœ 'a nene. 'A gbɔ tshelœ aka oyo kɔ tœ lɔsu 'a: oyo neke á sœ ɓa shu tœ 'a œdœ awa á sœ ɓa ugurutœ 'a. ");
INSERT INTO mnh_vpl VALUES ("C27_6","077_7_6","2CO","7","6","6","Kashe Ndjaba á tshe sœ kœgi gbɔgbɔ fœ azu neke á endje mɔ, to gbɔgbɔ fœ 'a lœ awa nœ kœyi kumu Tito. ");
INSERT INTO mnh_vpl VALUES ("C27_7","077_7_7","2CO","7","7","7","Yé œ dœ́dœ́ kolœ mbœrœ kœyi kumu ye asœmœ dá to gbɔgbɔ fœ 'a nene, kashe lœ awa nœ gbɔgbɔ á tshe gbɔ ɓa ndœ 'e. Tshe pandœ egerœ agbe nœ 'e ndœ kpa kœwu mœ, ɨkɨ nœ 'e œdœ ɔtshɔ lɔsu nœ 'e ga ndœ mœ, fœ 'a ye. Yé mbœrœ tœnœ ataa, mœ kpa sœ dœ yanga kœropanœ. ");
INSERT INTO mnh_vpl VALUES ("C27_8","077_7_8","2CO","7","8","8","Ataa œdœ mbeti á mœ su fœ 'e kœza oyo ga tœ lɔsu 'e, mœ gbegbetshelœ mœ ndœ nœ ngɔngɔnœ asœke nene. Mœ gbe má tshelœ mœ œdœ mœ kœwu má adœke œndœ oyo á mbetinœ asœmœ za fœ 'e œ dɨ nene. ");
INSERT INTO mnh_vpl VALUES ("C27_9","077_7_9","2CO","7","9","9","Kashe ngɔngɔnœ asœke mœ sœ dœ yanga; œ dœ́dœ́ mbœrœ á za oyo ga tœ lɔsu 'e nene, kashe mbœrœ á oyonœ asœmœ mbœrœ adœke 'e fatshalɔsu 'e. Ataa 'a mbœmbœrœ ekperœ bale fœ 'e nene gbaa, oyonœ asœmœ, Ndjaba dá yi lima ndœ nœ. ");
INSERT INTO mnh_vpl VALUES ("C27_10","077_7_10","2CO","7","10","10","Gbambanœ nene, oyo tœ lɔsu á sœ lindœ gbetshelœ nœ Ndjaba sœ kœto tœ kœfatshalɔsu uzu á sœ kœgi osho ndœ kœshe dœ mara adœke gbetshelœ sœ mbœrœ tœnœ nene. Kashe oyo tœ lɔsu á to tœ tshapashɔ asœke, sœ kœza kuzu. ");
INSERT INTO mnh_vpl VALUES ("C27_11","077_7_11","2CO","7","11","11","Ngɔngɔnœ asœke, 'e wu œrœ tshangba oyo tœ lɔsu 'e á sœ lindœ gbetshelœ nœ Ndjaba dœke: 'a sœ dœ yanga kœpa o'o tshapa 'e, 'e vwaratœ 'e tœ œneke á ro utshunœ, 'e sœ kœkpa awa Ndjaba, 'e sœ dœ ogo nœ kpa kœwu mœ, 'e sœ kœzatœ 'e ga tœ akwa yé œ sœ kœza djofele fœ uzu á tshe mbœrœ lima ekperœ. Kɔkɔ asœmœ sœ kœma ngbɨ adœke 'e gugu lima dœ upu lœ o'onœ asœmœ nene. ");
INSERT INTO mnh_vpl VALUES ("C27_12","077_7_12","2CO","7","12","12","Ataa œdœ mœ kœsu lima mbeti asœke fœ 'e, œ sœsœ lima mbœrœ uzu á tshe mbœrœ ekperœ nene, œ sœsœ ndje lima mbœrœ tsheneke á endje mbœrœ ekperœ fœ she nene. Kashe œ sœ lima mbœrœ kœma ɓa utshu 'e ɓa tœ ala Ndjaba adœke ogo nœ 'e ga ndœ 'a sœ tœ egerœnœ. ");
INSERT INTO mnh_vpl VALUES ("C27_13","077_7_13","2CO","7","13","13","Mbœrœ tœnœ ataa, œrœ á 'e mbœrœ to gbɔgbɔ fœ 'a. Œ dœ́dœ́ kolœ mbœrœ tœnœ nene, kashe 'a sœ dœ yanga kœropa nœ kœwu mara á Tito sœ lima dœ yanga mbœrœ á 'e mbœrœ lima adœke lɔsu ye sœ zɨtɨ. ");
INSERT INTO mnh_vpl VALUES ("C27_14","077_7_14","2CO","7","14","14","Œdœ mœ kœsœ kœdonga tœ mœ tœ upu nœ 'e ɓa utshu ye, œ sœ mbœrœ á 'e zaza ókó fœ mœ nene. Kashe ɓata o'o kɔ á 'a pa fœ 'e kœdœ adja o'o, awa bale ndje, kœdonga tœ 'a tœ upu nœ 'e ɓa utshu Tito wuta ndje adja o'o. ");
INSERT INTO mnh_vpl VALUES ("C27_15","077_7_15","2CO","7","15","15","Yé ataa, lɔkɔ á tshe kœsœ kœgbe dœ mara á 'e zatœ 'e fœ she œdœ dœ mara á 'e za osho kœsœ fœ she dœ kœkpa awa ye dopanœ, kœyindœsho nœ ye ga ndœ 'e sœ kœgerœ tœnœ. ");
INSERT INTO mnh_vpl VALUES ("C27_16","077_7_16","2CO","7","16","16","Mœ sœ dœ yanga mbœrœ kœza lɔsu mœ djigi á mœ za ga pa 'e. ");
INSERT INTO mnh_vpl VALUES ("C28_1","077_8_1","2CO","8","1","1","Alaya, 'a yindœ nœ adœke 'e wusœ mara á Ndjaba ma ɔtshɔ lɔsu nœ ye ga ndœ azu Ikrizia ɓa lœ ogo Masedwane. ");
INSERT INTO mnh_vpl VALUES ("C28_2","077_8_2","2CO","8","2","2","Lœ oyo ndjoro tœ lɔsu endje, endje sœ dœ egerœ yanga. Yé ataa endje sœ lœ egerœ oyo gbaa, endje to œrœ kœrosœ nœ. ");
INSERT INTO mnh_vpl VALUES ("C28_3","077_8_3","2CO","8","3","3","Œmœ kœdœ timunœ, endje to œrœ lindœ kœgbɔ œrœ nœ endje. Endje to œrrr tɔpanœ kpuru. Endje to œrœnœ lindœ gbetshelœ nœ endje. ");
INSERT INTO mnh_vpl VALUES ("C28_4","077_8_4","2CO","8","4","4","Endje shendœ kœyu 'a adœke 'a za awa fœ œne dœ́ œne ngbɔtœ œne dœ 'a tœ upu nœ kœvwa œrœ fœ ayindœ Ndjaba ɓa lœ ongbo Yerusaleme. ");
INSERT INTO mnh_vpl VALUES ("C28_5","077_8_5","2CO","8","5","5","Endje to œrœ kœrosœ œneke á 'a gbe má adœke endje to. Utshunœ, endje zatœ endje fœ Gbozu, yé manda nœ, endje zatœ endje fœ 'a lindœ œrœ á Ndjaba yindœ nœ. ");
INSERT INTO mnh_vpl VALUES ("C28_6","077_8_6","2CO","8","6","6","Mbœrœ tœnœ ataa, 'a kɨ fœ Tito adœke tshe na ɓa ndœ 'e ɓa zœ œ mbœrœ udu akwa nœ ɔtshɔ lɔsunœ asœmœ œrrr ga tœ ndɔngɔlɔnœ, akwanœ á tshe te lima kœmbœrœ tœnœ asœmœ. ");
INSERT INTO mnh_vpl VALUES ("C28_7","077_8_7","2CO","8","7","7","'E sœsœ dœ oyo œrœ bale nene: kœyindœrœ, kœwusœ kœpa o'o, kœwusœrœ, egerœ ogo kœmbœrœ akwa œdœ pe kœyindœsho á 'a yisœ nœ fœ 'e. Mbœrœ tœnœ ataa, 'a yindœ nœ adœke 'e ma ndje tœ 'e tœ aayi kœgbɔrœ lœ kœto œrœ nœ 'e dœ lɔsu nœ yanga. ");
INSERT INTO mnh_vpl VALUES ("C28_8","077_8_8","2CO","8","8","8","Œ dœ́dœ́ awa o'o dá mœ sœ kœza fœ 'e nene, kashe mœ kœsœ kœpandœ kœmbœrœ œrœ dœ yanga nœ anga azu fœ 'e, mœ sœ kœza awa fœ 'e adœke 'e tondœ adja kœyindœsho nœ 'e. ");
INSERT INTO mnh_vpl VALUES ("C28_9","077_8_9","2CO","8","9","9","Gbambanœ nene, 'e wusœ ɔtshɔ lɔsu nœ Gbozu nœ azœ dœ Yisu Kristu ye. Ataa tshe dœ lima ayi kœgbɔrœ gbaa, tshe zatœ ye tœ ayi oyo mbœrœ 'e adœke 'e gbɔ œrœ ndjoro lœ oyo nœ œne. ");
INSERT INTO mnh_vpl VALUES ("C28_10","077_8_10","2CO","8","10","10","Ataa, mœ sœ kœza gbetshelœ nœ mœ lœ upunœ asœke fœ 'e: œ li dœ 'e adœke 'e mbœrœ kolœ akwa ɓata á 'e mbœrœ lima ungu utshunœ, e'e lima kœdœ azu á 'e gbɔ gbetshelœnœ asœmœ utshunœ œdœ aayi kœmbœrœ tœnœ dœ akwa. ");
INSERT INTO mnh_vpl VALUES ("C28_11","077_8_11","2CO","8","11","11","Ataa, ngɔngɔ asœke, 'e mbœrœ adœke akwanœ asœmœ ka. 'E mbœrœ akwanœ dœ lɔsu 'e bale adœke œ ka ɓata á 'a pa tœnœ yé dœ tœnœ ataa, lindœ kœgbɔrœ nœ 'e. ");
INSERT INTO mnh_vpl VALUES ("C28_12","077_8_12","2CO","8","12","12","Gbambanœ nene, œdœ uzu kœza lɔsu ye bale ga panœ, Ndjaba œ yindœ œrœ nœ uzunœ asœmœ á tshe to dœ kœgbe dœ œrœ á tshe sœ dœ tœnœ, kashe œ dœ́dœ́ dœ kœgbe dœ œneke á tshe gugu dœ tœnœ nene. ");
INSERT INTO mnh_vpl VALUES ("C28_13","077_8_13","2CO","8","13","13","Œ sœsœ adœke uzu ko œrœ nœ ye kɔ mbœrœ kœshe dœ anganœ á kpa kœsœ œnœ ye lœ oyo nene, kashe œ li adœke tshe kurutshelœnœ li tœnœ œ li. ");
INSERT INTO mnh_vpl VALUES ("C28_14","077_8_14","2CO","8","14","14","Mbœrœ tœnœ ataa, e'e kœdœ aayi kœgbɔrœ yé œ li adœke 'e tɨ kane endjeneke á endje gugu dœ œrœ nene ga lafo. Manda nœ, œdœ 'e kœgugu dœ œrœ nene yé á endje sœ dœ tœnœ ndjoro, endje li kœtɨ ndje kane 'e ga lafo. Atamœ dá 'e liili, ");
INSERT INTO mnh_vpl VALUES ("C28_15","077_8_15","2CO","8","15","15","ɓata á endje sú ɓa la Buku nœ Ndjaba adœke: «Uzu á tshe rɔ lima rœgo ndjoro, œ ngbangba tshaabrœ ye nene, yé tsheneke á tshe rɔ lima teasho, sœ dœ œrœ ndjoro.» ");
INSERT INTO mnh_vpl VALUES ("C28_16","077_8_16","2CO","8","16","16","'A gi ɔtshɔrœ fœ Ndjaba á tshe za egerœ ogo nœ kœmbœrœ awa bale ɓata á 'a sœ ndje dœ tœnœ, fœ Tito adœke tshe mbœrœ fœ 'e. ");
INSERT INTO mnh_vpl VALUES ("C28_17","077_8_17","2CO","8","17","17","Tito yindœ kœyɔndœrœ nœ 'a. Ga panœ dœmœ, tshe kpa yi lima ndœ nœ dœ tœ ye adœke œne na ɓa ndœ 'e. ");
INSERT INTO mnh_vpl VALUES ("C28_18","077_8_18","2CO","8","18","18","'A vwa she awa bale dœ anga aya azœ á azu Ikrizia kɔ sœ kœdonga she tœ upu nœ kœyisœ Ɔtshɔ O'o. ");
INSERT INTO mnh_vpl VALUES ("C28_19","077_8_19","2CO","8","19","19","Ga panœ, azu Ikrizia dá ke she adœke tshe ro tœ awanœ bale dœ 'a mbœrœ kœmbœrœ akwa nœ ɔtshɔ lɔsu. 'A sœ kœmbœrœ akwanœ mbœrœ mokɔ nœ Gbozu dœ tœ ye œdœ kœmbœrœ œrœ dœ ɔtshɔ gbetshelœ. ");
INSERT INTO mnh_vpl VALUES ("C28_20","077_8_20","2CO","8","20","20","'A sœ kœmbœrœ adœke azu gbagbagbara 'a tœ mara kœkurutshelœ ngendja ndjoro á 'a sœ kœgbɔndœ nœ nene. ");
INSERT INTO mnh_vpl VALUES ("C28_21","077_8_21","2CO","8","21","21","'A yiyindœ kœmbœrœ kolœ ɔtshɔrœ ga tœ ala Gbozu nene, kashe 'a yi ndje ndœ kœmbœrœ ɓa tœ ala azu kɔ. ");
INSERT INTO mnh_vpl VALUES ("C28_22","077_8_22","2CO","8","22","22","'A vwa azunœ bisha tœ awanœ bale dœ anga aya azœ á 'a sœ kœwu lɔsu ye ɔlɔ dœ ɔlɔ, yé tshe sœ dœ egerœ ogo kœmbœrœ akwa dœ ɔtshɔ lɔsu. Kashe ngɔngɔnœ asœke, egerœ ogo kœmbœrœ akwa dœ ɔtshɔ lɔsu nœ ye kpa gerœ kœrosœ nœ. Gbambanœ nene, tshe ma ɔtshɔ lɔsu nœ ye ga ndœ 'e. ");
INSERT INTO mnh_vpl VALUES ("C28_23","077_8_23","2CO","8","23","23","Tœ upu nœ Tito, œshe kœdœ yanga mœ á 'a na tœ awa bale dœ she ɓa ndœ 'e, œshe ndje kœdœ uzu á 'a sœ lœ ama akwa bale dœ she. Kashe tœ udu aaya azœ bisha asœke, azu Ikrizia dá vwa endje fœ 'e yé endje sœ kœmbœrœ akwa mbœrœ mokɔ nœ Kristu. ");
INSERT INTO mnh_vpl VALUES ("C28_24","077_8_24","2CO","8","24","24","'E ma fœ endje adœke 'e yindœ endje tako mbœrœ á azu Ikrizia kœyindœ nœ yé á kœwusœ nœ adœke 'a sœ kœdu okoro 'a mbœrœ 'e. ");
INSERT INTO mnh_vpl VALUES ("C29_1","077_9_1","2CO","9","1","1","Adja ádá adœke mœ su mbeti fœ 'e tœ upu nœ kœtɨ kane ayindœ Ndjaba ɓa lœ ongbo Yerusaleme gugu nene. ");
INSERT INTO mnh_vpl VALUES ("C29_2","077_9_2","2CO","9","2","2","Gbambanœ nene, mœ wusœ ɔtshɔ gbetshelœ nœ 'e ye, yé mœ sœ kœdu okoro mœ tœ upu nœ 'e fœ azu ogo Masedwane adœke: «Azu Akayi gumatœ endje kœto œrœ dœ ngbugu á ro lima utshunœ asœke.» Egerœ ogo kœmbœrœ akwa dœ ɔtshɔ lɔsu nœ 'e ndjingɨvwɨ azu Ikrizia ndjoro. ");
INSERT INTO mnh_vpl VALUES ("C29_3","077_9_3","2CO","9","3","3","Mœ vwa anga aaya azœ fœ 'e mbœrœ adœke kœdu okoro mœ mbœrœ 'e tœ upunœ asœmœ kœsœsœ gbambanœ nene. Mœ yindœ nœ adœke 'e kotœ 'e ga lœ vola ɓata á mœ pa lima ndœ nœ. ");
INSERT INTO mnh_vpl VALUES ("C29_4","077_9_4","2CO","9","4","4","Gbambanœ nene, œdœ 'a kœna ɓa zœ awa bale dœ azu ogo Masedwane yé á kœgbɔ 'e á 'e kœgugumatœ 'e nene, 'a gbɔ tshula mbœrœ á 'a ko adja lɔsu 'a ga pa 'e. Yé atamœ, tshulanœ œdœ ndje œnœ 'e. ");
INSERT INTO mnh_vpl VALUES ("C29_5","077_9_5","2CO","9","5","5","Mbœrœ tœnœ ataa, mœ gbe dœ ɔtshɔnœ adœke mœ vwa aaya azœ asœke utshunœ ɓa ndœ 'e mbœrœ kœngbɔɓa œrœ á 'e pa lima tœnœ. Ataa œ kœsœ zœ á mœ yikumu mœ ga zœ, œ ma adœke 'e to dœ lɔsu 'e bale kashe œ dœ́dœ́ dœ lɔsu bisha nene. ");
INSERT INTO mnh_vpl VALUES ("C29_6","077_9_6","2CO","9","6","6","'E gbe dœ o'o asœke kane: uzu á tshe lu ngwarœ teasho, tshe kɔ ndje teasho, yé tsheneke á tshe lu ndjoro, tshe kɔ ndje ndjoro. ");
INSERT INTO mnh_vpl VALUES ("C29_7","077_9_7","2CO","9","7","7","Œ li adœke uzu dœ uzu to ɓata á lɔsu ye yindœ nœ, kashe dœ oyo tœ lɔsu ye too adœke uzu kakapa ye nene. Gbambanœ nene, Ndjaba yindœ uzu á tshe sœ kœto œrœ dœ yanga. ");
INSERT INTO mnh_vpl VALUES ("C29_8","077_9_8","2CO","9","8","8","Yé Ndjaba li tœ kœgi tshelœ aka anga œrœ kɔ ga mangbanœ fœ 'e mbœrœ adœke 'e sœ kolœ dœ œrœ á li, yé ga panœ dœmœ 'e sœ dœ œrœ yeka á kœsœ kœto ndœ ɔtshɔ akwa kɔ. ");
INSERT INTO mnh_vpl VALUES ("C29_9","077_9_9","2CO","9","9","9","Ɓata á endje sú ɓa la Buku nœ Ndjaba adœke: «Tshe kurutshelœ œrœ, œ to fœ aayi oyo, yé mara kœmbœrœ œrœ nœ ye ndjii sœpe waa dœ waa.» ");
INSERT INTO mnh_vpl VALUES ("C29_10","077_9_10","2CO","9","10","10","Ndjaba á tshe sœ kœto indji ngwarœ fœ aayi kœlu ngwarœ œdœ kœzɨrœ, tshe to bala indji ngwarœ kɔ á 'e gbe dœ tœnœ fœ 'e. Tshe mbœrœ adœke 'e mbœrœ œrœ á sœ ndjii waa dœ waa. ");
INSERT INTO mnh_vpl VALUES ("C29_11","077_9_11","2CO","9","11","11","Tshe fa 'e tœ aayi kœgbɔrœ dœ mara kɔ œdœ dœ ada ɔlɔ kɔ mbœrœ adœke á 'e kœkakatœ kœto œrœ fœ anga 'e nene. Ataa, azu ndjoro œ gi mershe fœ Ndjaba tœ upu nœ 'e mbœrœ œrœ á 'e sœ kœto fœ endje lœ awa nœ 'a. ");
INSERT INTO mnh_vpl VALUES ("C29_12","077_9_12","2CO","9","12","12","Gbambanœ nene, akwa á 'e sœ kœmbœrœ tœnœ sœsœ kolœnœ adœke ayindœ Ndjaba gbɔ œrœ á endje gbe dœ tœnœ nene, kashe œ sœ ndje kœmbœrœ adœke azu ndjoro gi mershe fœ Ndjaba mbœrœ tœnœ. ");
INSERT INTO mnh_vpl VALUES ("C29_13","077_9_13","2CO","9","13","13","Azu ndjoro á endje wu adœke akwanœ asœke sœ dœ ádá waa, endje donga bala Ndjaba mbœrœ mara kœmbœrœtœ 'e lindœ Ɔtshɔ O'o nœ Kristu asœmœ. Endje donga ndje Ndjaba mbœrœ mara á 'e kurutshelœ œrœ nœ 'e tœ endje œdœ tœ anga azu kɔ. ");
INSERT INTO mnh_vpl VALUES ("C29_14","077_9_14","2CO","9","14","14","Endje za bala avwala mbœrœ 'e dœ kœma kœyindœsho nœ endje ga ndœ 'e mangba ɔtshɔ lɔsu á ropa nœ, á Ndjaba za fœ 'e. ");
INSERT INTO mnh_vpl VALUES ("C29_15","077_9_15","2CO","9","15","15","Kaka adœke a gi mershe fœ Ndjaba mbœrœ kœtorœ nœ ye á ropa œrœ kɔ. ");
INSERT INTO mnh_vpl VALUES ("C210_1","077_10_1","2CO","10","1","1","Œmœ Polo, mœ sœ kœpa fœ 'e dœ tœ mœ dœ ɔmɔ lɔsu œdœ dœ ɔtshɔ lɔsu nœ Kristu adœke, anga azu sœ kœpa adœke œdœ mœ kœsœ ugurutœ 'e, mœ sœ kœzatœ mœ ga atɨ ga ndœ 'e, yé œdœ mœ kœgugu ugurutœ 'e nene, mœ gbɔɔgbɔ ga ndœ 'e. ");
INSERT INTO mnh_vpl VALUES ("C210_2","077_10_2","2CO","10","2","2","Mœ sœ kœkɨ fœ 'e adœke 'e kakapa mœ adœke mœ mbœrœ œrœ dœ ɔgbɔ, lɔkɔ á mœ kœna ɓa ndœ 'e nene. Gbambanœ nene, mœ gbe kœyisœ gbɔgbɔ nœ mœ fœ azu á endje sœ kœpa adœke 'a sœ kœmbœrœ akwa tœ mara nœ azu nœ tshapashɔ. ");
INSERT INTO mnh_vpl VALUES ("C210_3","077_10_3","2CO","10","3","3","Œ sœ adjapu adœke a'a kœdœ azu tshapashɔ, kashe 'a sœsœ kœnga koshe dœ mara nœ adja azu tshapashɔ nene. ");
INSERT INTO mnh_vpl VALUES ("C210_4","077_10_4","2CO","10","4","4","Lœ kœnga koshe nœ 'a, œrœ kœnga dœ koshe nœ 'a toto ɓa ndœ azu nene, kashe gbɔgbɔnœ to ɓa ndœ Ndjaba mbœrœ kœndɨ tshelœ gbɔgbɔ nœ ayingba. 'A sœ kœndɨ tshelœ gbetshelœ nœ egerœ kumu ");
INSERT INTO mnh_vpl VALUES ("C210_5","077_10_5","2CO","10","5","5","œdœ gbɔgbɔ kɔ á sœ kœza egerœ kumu adœke azu kœwuwusœ Ndjaba nene. 'A sœ kœmbœrœ adœke endje fa gbetshelœ nœ endje kɔ mbœrœ adœke endje mbœrœtœ endje lindœ Kristu. ");
INSERT INTO mnh_vpl VALUES ("C210_6","077_10_6","2CO","10","6","6","Yé lɔkɔ á 'e kœsœ kœmbœrœtœ 'e dœ ɔtshɔnœ, 'a kpalatœ 'a nene kœza djofele fœ endjeneke á endje sœsœ kœmbœrœtœ endje dœ awanœ nene. ");
INSERT INTO mnh_vpl VALUES ("C210_7","077_10_7","2CO","10","7","7","'E sœ kœwu kolœ tshapa œrœ. Œdœ anga uzu kœgbe adœke œne kœdœ uzu nœ Kristu, tshe gbetshelœ ye tœ œrœ asœke kane: azœ kœdœ azu nœ Kristu awa bale dœ she ndje. ");
INSERT INTO mnh_vpl VALUES ("C210_8","077_10_8","2CO","10","8","8","Ataa œdœ mœ kœdu okoro mœ tœ tshagbozu á Gbozu Yisu za lima fœ mœ, mœ sœ dœ tshula mbœrœ tœnœ nene. Tshe za lima fœ mœ mbœrœ kœguma 'e, kashe œ dœ́dœ́ mbœrœ adœke œ ndɨ 'e nene. ");
INSERT INTO mnh_vpl VALUES ("C210_9","077_10_9","2CO","10","9","9","Mœ yiyindœ nœ adœke mbeti nœ mœ á mœ su za awa fœ 'e nene. ");
INSERT INTO mnh_vpl VALUES ("C210_10","077_10_10","2CO","10","10","10","Gbambanœ nene, anga azu sœ kœpa adœke: «Mbeti nœ Polo lɨɨlɨ dœ pe gbɔgbɔ, kashe lɔkɔ á tshe kœsœ ugurutœ azœ, tshe mɔmɔ yé mara kœpa o'o ye lɨlɨ nene.» ");
INSERT INTO mnh_vpl VALUES ("C210_11","077_10_11","2CO","10","11","11","Œ li adœke uzu á tshe pa mara o'o ataa wusœ nœ dœ ɔtshɔnœ adœke, mara á 'a su dœ mbeti nœ 'a lœ ɨngɨrɨnœ, tshetœ maranœ asœmœ dá 'a mbœrœ dœ tœnœ œdœ 'a kœsœ ɓa ugurutœ 'e. ");
INSERT INTO mnh_vpl VALUES ("C210_12","077_10_12","2CO","10","12","12","'A yiyindœ kœzatœ 'a awa bale too kœzatœ 'a ɓata anga azu á endje sœ kœdonga tœ endje dœ tœ endje asœmœ nene. Gbambanœ nene, endje kœdœ agbakɨndɨ azu. Endje sœ kœwutœ endje dœ tœ endje. Endje sœ kœzatœ endje ɓata kœgerœ œrœ. ");
INSERT INTO mnh_vpl VALUES ("C210_13","077_10_13","2CO","10","13","13","Tœ a'a nœ 'a, 'a sœ dœ egerœ kumu adœke 'a rosœ mapaka kɔ nene, kashe 'a mbœrœ akwa kolœ kpœtœ ama osho neke á Ndjaba to fœ 'a, yé á yindœ nœ adœke 'a wuta œrrr ɓa ndœ 'e. ");
INSERT INTO mnh_vpl VALUES ("C210_14","077_10_14","2CO","10","14","14","Gbambanœ nene, a'a dá dœ adja azu utshunœ á 'a na dœ Ɔtshɔ O'o nœ Kristu fœ 'e. 'A roropa mapaka nœ akwa nœ 'a nene ataa œdœ 'a kœroro má ga ndœ 'e nene. ");
INSERT INTO mnh_vpl VALUES ("C210_15","077_10_15","2CO","10","15","15","Dœ tœnœ ataa, 'a sœsœ kœdu okoro 'a kœropanœ mbœrœ akwa nœ anga angbɨ azu nene, kashe 'a wusœ nœ adœke kœyindœrœ nœ 'e œ gerœ yé 'a kpa mbœrœ adœke œ sœ kolœ kœgerœ tœnœ lindœ mapaka nœ 'a. ");
INSERT INTO mnh_vpl VALUES ("C210_16","077_10_16","2CO","10","16","16","Manda nœ, 'a na kœyisœ Ɔtshɔ O'o ɓa lœ anga angbɨ ogo djagakele 'e. Ataa, 'a du okoro 'a mbœrœ akwa nœ anga angbɨ azu á endje mbœrœ ɓa tœ osho akwa nœ endje nene. ");
INSERT INTO mnh_vpl VALUES ("C210_17","077_10_17","2CO","10","17","17","Andaa, endje sú ɓa la buku nœ Ndjaba adœke: «Œdœ uzu kœyindœ kœdu okoro ye, tshe du okoro ye tœ œneke á Gbozu mbœrœ.» ");
INSERT INTO mnh_vpl VALUES ("C210_18","077_10_18","2CO","10","18","18","Gbambanœ nene, endje dodonga uzu á tshe sœ kœzatœ ye mbœrœ gbetshelœ nœ ye dœ tœ ye bale nene, kashe endje donga tsheneke á Gbozu sœ kœma o'o tœ upu nœ ye. ");
INSERT INTO mnh_vpl VALUES ("C211_1","077_11_1","2CO","11","1","1","Mœ yindœ nœ adœke 'e ru lɔsu 'e tœ o'o mœ á sœ ɓata œnœ ayi iyi. Adja 'e ru lɔsu 'e tœ mœ. ");
INSERT INTO mnh_vpl VALUES ("C211_2","077_11_2","2CO","11","2","2","Mœ sœ dœ úkú tœ upu nœ 'e waa, yé úkúnœ asœmœ to ɓa ndœ Ndjaba. Gbambanœ nene, mœ pandœ kœko 'e fœ anga yakoshe bale adœke 'e i she, yakoshenœ kœdœ Kristu. Yé mœ gbe ndœ kœma 'e fœ she ɓata akpɔ yawuru á tshe wuwu damba sœ yakoshe nene. ");
INSERT INTO mnh_vpl VALUES ("C211_3","077_11_3","2CO","11","3","3","Kashe mœ sœ dœ awa adœke, ɓata á yakoro fara lima Eva dœ ekpe ɔtshɔ ye, mœ sœ kœgbe adœke anga uzu fafara ndje kœwusœrœ nœ 'e yé œ gi 'e zara tœ mara á 'e zatœ 'e yé á sœ yerœ ga ndœ Kristu nene. ");
INSERT INTO mnh_vpl VALUES ("C211_4","077_11_4","2CO","11","4","4","Gbambanœ nene, mœ wu adœke œdœ anga uzu kœna kœmɨndœ anga angbɨ Yisu á 'a mɨmɨndœ ye fœ 'e nene, 'e sœ kolœ kœdji she; 'e sœ kœyindœ ɨshirɨ á sœ kpi tœ Ɨshirɨ neke á 'e gbɔ lima; 'e sœ ndje kœyindœ Ɔtshɔ O'o á sœ kpi tœ œneke á 'a yi lima sœ nœ fœ 'e. ");
INSERT INTO mnh_vpl VALUES ("C211_5","077_11_5","2CO","11","5","5","Azu á 'e sœ kœwu endje ɓata agboro aayi avwa nœ 'e asœmœ, roropa mœ nene. ");
INSERT INTO mnh_vpl VALUES ("C211_6","077_11_6","2CO","11","6","6","Ataa mœ wuwusœ kœpa o'o dœ ɔtshɔnœ nene gbaa, kashe œ dœ́dœ́ tœ upu nœ kœwusœrœ nene. 'A yi lima sœ nœ fœ 'e para œdœ dœ mara kɔ. ");
INSERT INTO mnh_vpl VALUES ("C211_7","077_11_7","2CO","11","7","7","Lɔkɔ á mœ yisœ Ɔtshɔ O'o nœ Ndjaba fœ 'e, mœ yi lima sœ nœ gbambanœ. Mœ za lima tœ mœ ga atɨ mbœrœ kœtɨ 'e ga lafo. Ataa, œrœnœ á mœ mbœrœ asœmœ kœdœ ekperœ a? ");
INSERT INTO mnh_vpl VALUES ("C211_8","077_11_8","2CO","11","8","8","Azu tshelœ anga angbɨ Ikrizia dá to lima œrœ fœ mœ, yé œ ma lima tœ ye adœke mœ sœ kœshe mbœrœ endje mbœrœ kœmbœrœ akwa fœ 'e. ");
INSERT INTO mnh_vpl VALUES ("C211_9","077_11_9","2CO","11","9","9","Yé dœ lɔndɔ á mœ sœ lima ɓa ndœ 'e, ataa mœ sœ lima dœ ogo œrœ gbaa, mœ yɔyɔndœ œrœ tshaabrœ uzu bale nene. Gbambanœ nene, aaya azœ á endje to ɓa lœ Masedwane dá na lima dœ œrœ á mœ gbe lima dœ tœnœ fœ mœ. Mœ gbɔndœtœ mœ lima mbœrœ kœdœ́dœ́ egerœ kongba pa 'e nene, yé mœ gbɔndœtœ mœ kolœ atamœ waa dœ waa. ");
INSERT INTO mnh_vpl VALUES ("C211_10","077_11_10","2CO","11","10","10","Lœ awa nœ adja o'o nœ Kristu á sœ lœ mœ, mœ sœ kœpa tœnœ ngbɨ adœke: uzu bale ɓa lœ ogo Akayi œ li kœkɔ mœ tœ upu nœ kœdongatœshonœ asœmœ nene. ");
INSERT INTO mnh_vpl VALUES ("C211_11","077_11_11","2CO","11","11","11","Mbœrœ gaɗe á mœ pa o'onœ asœmœ a? Œ sœ kœma adœke mœ yiyindœ 'e nene a? Ndjaba wusœ nœ dœ adœke mœ yindœ 'e ye! ");
INSERT INTO mnh_vpl VALUES ("C211_12","077_11_12","2CO","11","12","12","Mœ sœpe kolœ kœmbœrœ ɓata á mœ mbœrœ ngɔngɔ nœ asœke mbœrœ á kœgi ekpe gbetshelœ lœ azu á endje sœ kœdu okoro endje ɓata endje liili dœ 'a. ");
INSERT INTO mnh_vpl VALUES ("C211_13","077_11_13","2CO","11","13","13","Azunœ asœmœ kœdœ aayi avwa nœ wala, endje sœ kœfatœ endje adœke œne kœdœ aayi avwa nœ Kristu. ");
INSERT INTO mnh_vpl VALUES ("C211_14","077_11_14","2CO","11","14","14","Anga œrœ bale kœkatœ ama osho tɨ ɔsɔ ndœnœ gugu kpœtœmœ nene, Satana dœ tœ ye sœ kœfatœ ye tœ andjelu nœ ɔlɔ. ");
INSERT INTO mnh_vpl VALUES ("C211_15","077_11_15","2CO","11","15","15","Ataa œdœ aayi akwa nœ ye kœsœ kœfatœ endje adœke œne kœdœ aayi akwa á œne sœ ndjii, œ dœ́dœ́ upu kœkɨtœ œsœnœ nene. Ɓa tœ ndɔngɔlɔnœ, endje gbɔ kolœ œrœ neke á liili dœ akwa nœ endje. ");
INSERT INTO mnh_vpl VALUES ("C211_16","077_11_16","2CO","11","16","16","Mœ kpa sœ kœpa o'onœ asœmœ adœke: uzu bale zaza mœ ɓata ayi iyi nene. Kashe œdœ 'e kœgbe adœke mœ sœ dœ iyi, 'e yindœ nœ adœke mœ sœ dœ tœnœ mbœrœ adœke mœ donga tœ mœ ndje teasho. ");
INSERT INTO mnh_vpl VALUES ("C211_17","077_11_17","2CO","11","17","17","Adjapu, œneke á mœ sœ kœpa tœnœ ngɔngɔ asœke, mœ sœsœ kœpa ɓata á Gbozu yindœ nœ nene, kashe mœ sœ kœpa ɓata mœ sœ dœ iyi lœ kœza lɔsu mœ ga pa œneke á mœ sœ kœdongatœ mœ tœnœ. ");
INSERT INTO mnh_vpl VALUES ("C211_18","077_11_18","2CO","11","18","18","Ɓata á azu ndjoro sœ kœdonga tœ endje tœ œrœ nœ endje œnœ tshapashɔ, œmœ ndje mœ donga ndje bala tœ mœ. ");
INSERT INTO mnh_vpl VALUES ("C211_19","077_11_19","2CO","11","19","19","E'e dœ azu á 'e sœ dœ kœwusœtœ, 'e yindœ nœ dœ tœ 'e kœru lɔsu 'e tœ aayi iyi. ");
INSERT INTO mnh_vpl VALUES ("C211_20","077_11_20","2CO","11","20","20","'E sœ kœru lɔsu 'e adœke endje mbœrœ œrœ ɓata akanga fœ 'e, endje gbɔtœ œrœ nœ 'e, endje fara 'e, endje wu 'e gbambanœ tœ ala endje yé œ da ala 'e. ");
INSERT INTO mnh_vpl VALUES ("C211_21","077_11_21","2CO","11","21","21","Mœ sœ dœ tshula kœpa adœke a'a kœdœ azu á 'a mɔɔmɔ. Andaa, o'o á endje sœ kœpa tœnœ, mœ sœ kœpa ɓata ayi iyi: œmœ ndje, mœ lii kœpa tœnœ. ");
INSERT INTO mnh_vpl VALUES ("C211_22","077_11_22","2CO","11","22","22","Endje sœ kœdonga tœ endje adœke œne kœdœ Aebre, œmœ ndje kœdœ Ebre! Endje kœdœ azu ogo Israyele, œmœ ndje kœdœ uzu ogo Israyele! Endje kœdœ aata Abrayamo, œmœ ndje kœdœ atanœ. ");
INSERT INTO mnh_vpl VALUES ("C211_23","077_11_23","2CO","11","23","23","Endje kœdœ aayi akwa nœ Kristu, œmœ ndje, mœ mbœrœ akwa nœ ye kœropa endje. Mœ sœ kœpa o'o ɓata mœ sœ dœ iyi. Mœ mɔ lima lœ akwa kœrosœ endje, endje za mœ ga lœ kánga kœropa endje, endje ɓi mœ kœrosœ endje, mœ li lima ga lœ kuzu awa ndjoro kœrosœ endje. ");
INSERT INTO mnh_vpl VALUES ("C211_24","077_11_24","2CO","11","24","24","Ayuda sɔ mœ dœ ndjapa zazu bale dœ ndjokpa dœ mindu dœ amanœ vana. Endje sɔ mœ ataa awa mindu. ");
INSERT INTO mnh_vpl VALUES ("C211_25","077_11_25","2CO","11","25","25","Azu ogo Roma sɔ mœ dœ ndjapa awa votɔ yé œ ve mœ dœ badja awa bale. Mœ nduru dœ agba awa votɔ yé œ mbœrœ olo bale dœ butshɔ bale la ungu. ");
INSERT INTO mnh_vpl VALUES ("C211_26","077_11_26","2CO","11","26","26","Lœ ana nœ mœ ndjoro á mœ na dœ ada mœ, ɔgbɔ œrœ á wuta ga tœ mœ to ɓa tœ ungu á sœ kœtu ga lœ agba too ɓa ndœ aayi angba; ɔgbɔ œrœ á to ɓa ndœ anga mœ dœ Ayuda too ɓa ndœ angbɨ azu; ɔgbɔ œrœ á wuta ga tœ mœ ɓa lœ ongbo too ɓa lœ kpagagasho, œ wuta ga tœ mœ ɓa la ungu ɨngbɨrɨ œdœ ɓa ugurutœ ekpe azu á endje pa adœke œne kœdœ azu nœ Kristu. ");
INSERT INTO mnh_vpl VALUES ("C211_27","077_11_27","2CO","11","27","27","Mœ mɔ dœ akwa yé œ wu oyo waa. Kpala kpala, mœ lolo olo nene; mœ sœ kœsœ dœ ogo kœzɨrœ œdœ pe dœ ogo ungu yé œ sœ kœmbœrœ lima adœke mœ sœ kœyotshelœma mœ kpala kpala. Mœ wu oyo dœ ɨzɨ œdœ tœ upu nœ lœba waa. ");
INSERT INTO mnh_vpl VALUES ("C211_28","077_11_28","2CO","11","28","28","Tœ kœdɨ udu œrœnœ kɔ nene, ɔlɔ dœ ɔlɔ mœ sœ kœgbe dœ Ikrizia para kɔkɔ. ");
INSERT INTO mnh_vpl VALUES ("C211_29","077_11_29","2CO","11","29","29","Œdœ anga uzu nœ Kristu kœmɔ, ngbewo mœ mɔ ndje ye. Œdœ anga kœtɨtœ ye tœ kœyindœrœ, ngbewo lɔsu mœ sœ kœka mœ. ");
INSERT INTO mnh_vpl VALUES ("C211_30","077_11_30","2CO","11","30","30","Œ kœsœ adœke mœ donga tœ mœ, mœ donga tœ mœ tœ kœmɔ nœ mœ. ");
INSERT INTO mnh_vpl VALUES ("C211_31","077_11_31","2CO","11","31","31","Ndjaba, Aba Gbozu nœ azœ dœ Yisu á endje sœ kœdonga she waa dœ waa, wusœ nœ adœke mœ sœsœ kœpa wala nene. ");
INSERT INTO mnh_vpl VALUES ("C211_32","077_11_32","2CO","11","32","32","Lɔkɔ á mœ sœ lima ɓa lœ Damaseke, gbozu á tshe sœ kœmbœrœ akwa nœ gbozugo Aretase, ko azu ɓa tœ manda ongbo mbœrœ á endje kœza mœ. ");
INSERT INTO mnh_vpl VALUES ("C211_33","077_11_33","2CO","11","33","33","Kashe endje za mœ ga lœ kingi yé œ yi mœ ga atɨ ɓa ushu lœ anga ogoro bale á sœ lœ egerœ muru nœ ongbonœ, yé á mœ kpa. ");
INSERT INTO mnh_vpl VALUES ("C212_1","077_12_1","2CO","12","1","1","Œ li adœke mœ donga tœ mœ ataa œ gugu dœ ádá nene gbaa. Kashe ngɔngɔnœ asœke mœ yindœ kœpa o'o tœ upu nœ kœwu œrœ lœ ulu œdœ tœ upu nœ kœma œrœ á Gbozu yisœ nœ fœ mœ. ");
INSERT INTO mnh_vpl VALUES ("C212_2","077_12_2","2CO","12","2","2","Manda ungu ndjokpa dœ vana, mœ wusœ anga uzu nœ Kristu bale á Ndjaba tɨ she œrrr ɓa lafo ɓa ndœ ye. Œdœ undu ye dá ɔ adja lima ga lafo too œdœ ulu dá mœ lu, mœ wuwusœ nœ nene, kashe kolœ Ndjaba kutɨ ye dá wusœ nœ. ");
INSERT INTO mnh_vpl VALUES ("C212_3","077_12_3","2CO","12","3","4","Adjapu, mœ wusœ nœ adœke Ndjaba tɨ uzunœ asœmœ œrrr ɓa lœ paradizo. (Œdœ undu ye dá ɔ adja ga lafo too œdœ ulu dá mœ lu, mœ wuwusœ nœ nene, kashe kolœ Ndjaba kutɨ ye dá wusœ nœ). Ɓa zœ, tshe dji o'o á azu lili kœpa tœnœ nene yé endje zaza ndje awa fœ uzu bale ɓa pa ɔshɔ kpa kœpa tœnœ nene. ");
INSERT INTO mnh_vpl VALUES ("C212_5","077_12_5","2CO","12","5","5","Mœ donga bala tœ mœ tœ upu nœ uzunœ asœmœ ye, kashe tœ œmœ nœ mœ, mœ donga bala kolœ tœ mœ tœ kœmɔ nœ mœ. ");
INSERT INTO mnh_vpl VALUES ("C212_6","077_12_6","2CO","12","6","6","Œdœ mœ kœyi má ndœ kœdonga tœ mœ, mœ sœ má dœ iyi nene, mbœrœ mœ pa má adja o'o. Kashe mœ sœ kœkpawa kœdonga tœ mœ. Gbambanœ nene, mœ yiyindœ nœ adœke endje gbɔ gbetshelœ neke á ropa œrœ á endje sœ kœwu mœ kœmbœrœ tœnœ too œneke á endje sœ kœdji ɓa ndœ mœ nene. ");
INSERT INTO mnh_vpl VALUES ("C212_7","077_12_7","2CO","12","7","7","Yé mbœrœ kœmarœnœ asœmœ á ro lima panœ ye, kparawa adœke mœ dodonga tœ mœ nene, Satana za koɓa ga lœ ɔkɔ mœ lœ awa nœ andjelu nœ ye á tshe sœ kœɓi mœ kparawa adœke mœ dodonga tœ mœ nene. ");
INSERT INTO mnh_vpl VALUES ("C212_8","077_12_8","2CO","12","8","8","Tœ upunœ asœke, mœ za avwala fœ Gbozu awa votɔ adœke tshe gi koɓanœ lœ ɔkɔ mœ ye. ");
INSERT INTO mnh_vpl VALUES ("C212_9","077_12_9","2CO","12","9","9","Tshe gi fœ mœ adœke: «Ɔtshɔ lɔsu nœ mœ ga ndœ zœ li dœ ɓœ ye. Gbɔgbɔ nœ mœ œ matœ ye œdœ ɓœ kœmɔɔmɔ.» Mœ gbe kœdonga tœ mœ tœ kœmɔ nœ mœ mbœrœ adœke gbɔgbɔ nœ Kristu kœsœ ga pa mœ. ");
INSERT INTO mnh_vpl VALUES ("C212_10","077_12_10","2CO","12","10","10","Mbœrœ tœnœ ataa dá mœ sœ dœ yanga lœ kœmɔ, lœ kœgu osho, lœ œrœ neke á mœ yiyi má kœmbœrœ tœnœ nene, lœ œrœ kanga œdœ lœ œneke á sœ kœza lɔsu mœ ga lafo tœ upu nœ Kristu. Gbambanœ nene, lɔndɔ á mœ kœsœ dœ kœmɔ, dœ lɔndɔnœ asœmœ dá mœ sœ kœsœ dœ gbɔgbɔ. ");
INSERT INTO mnh_vpl VALUES ("C212_11","077_12_11","2CO","12","11","11","Mœ sœ kœpa o'o ɓata mœ sœ dœ iyi, kashe e'e dá shosho mœ ndœ nœ. E'e dá pa má o'o tshapa mœ. Gbambanœ nene, ataa mœ sœ gbambanœ gbaa, agboro aayi avwanœ asœmœ, roropa mœ nene. ");
INSERT INTO mnh_vpl VALUES ("C212_12","077_12_12","2CO","12","12","12","Yé dœ lɔkɔ á mœ sœ lima ɓa ndœ 'e, mœ mbœrœ lima akwa dœ ugu lɔsu, yé Ndjaba mbœrœ ambárá afá dœ afá œdœ pe akwa nœ gbɔgbɔ ndjoro lœ awa nœ mœ. Ambáránœ asœmœ ngbangbangba sœ kœma adœke œmœ kœdœ adja ayi avwa. ");
INSERT INTO mnh_vpl VALUES ("C212_13","077_12_13","2CO","12","13","13","Œrœ gaɗe dá mœ ko fœ anga angbɨ Ikrizia yé á tshaapu kœko tœnœ fœ 'e a? Mbœrœ á mœ yɔyɔndœ œrœ ɓa ndœ 'e nene a? 'E wu oyo mœ tœ mara á mœ sœsœ ndjii nene asœmœ. ");
INSERT INTO mnh_vpl VALUES ("C212_14","077_12_14","2CO","12","14","14","Mœ ndo kœna votɔ ana gene nœ mœ ga ndœ 'e ye, yé mœ yɔndœ œrœ tshaabrœ 'e nene. E'e dá mœ sœ kœpara 'e, kashe œ dœ́dœ́ œrœ nœ 'e nene. Gbambanœ nene, œ dœ́dœ́ agbolo dá ngbɔɓa œrœ fœ agbozu nœ endje nene, kashe agbozu dá ngbɔɓa fœ agbolo nœ endje. ");
INSERT INTO mnh_vpl VALUES ("C212_15","077_12_15","2CO","12","15","15","Tœ œmœ nœ mœ, mœ sœ dœ yanga kœndɨ œneke kɔ á mœ sœ dœ tœnœ œdœ kœzatœ mœ djigi fœ 'e. Œdœ mœ kœyindœ 'e tɔpanœ kpuru ataa, 'e yindœ mœ kœrosœ nœ nene a? ");
INSERT INTO mnh_vpl VALUES ("C212_16","077_12_16","2CO","12","16","16","Adja 'e wusœ nœ adœke mœ yɔyɔ lima ndœ œrœ tshaabrœ 'e nene. Kashe anga endje ugurutœ 'e pa adœke mœ na dœ afara mbœrœ kœko œrœ tshaabrœ 'e. ");
INSERT INTO mnh_vpl VALUES ("C212_17","077_12_17","2CO","12","17","17","'E za tsheneke á 'e gbe kœza she ugurutœ azu á mœ vwa endje fœ 'e: mœ ko œrœ tshaabrœ 'e lœ awa nœ anga bale ugurutœ endje a? ");
INSERT INTO mnh_vpl VALUES ("C212_18","077_12_18","2CO","12","18","18","Mœ shosho Tito adœke tshe na ga ndœ 'e, mœ vwa she awa bale dœ aya azœ á 'e wusœ ye. Tito ko œrœ tshaabrœ 'e a? A'a dœ she, 'a mbœmbœrœ lima œrœ dœ she dœ gbetshelœ bale nene a? 'A sœsœ ndje lima kœza awa tshebabale nene a? ");
INSERT INTO mnh_vpl VALUES ("C212_19","077_12_19","2CO","12","19","19","Katshatsha 'e sœ kœgbe adœke 'a sœ kœpara awa kœpa ngbanga ɓa utshu 'e a? Œ̃! 'A sœ kœpa o'o lœ awa nœ Kristu ɓa utshu Ndjaba. Yé e'e dœ aaya 'a á 'a yindœ 'e waa, 'a sœ kœpa o'onœ asœmœ fœ 'e ataa mbœrœ á kœgi 'e lœ kœyindœrœ ga utshunœ. ");
INSERT INTO mnh_vpl VALUES ("C212_20","077_12_20","2CO","12","20","20","Mœ sœ dœ awa adœke dœ lɔkɔ á mœ kœwuta ga ndœ 'e, 'e mbœrœtœ 'e kpi tœ œneke á mœ yindœ nœ yé œ gbɔ ndje mœ kpi tœ œneke á 'e gbe dœ tœnœ. Mœ sœ dœ awa adœke mœ gbɔ œbœrœ œdœ úkú, ókó œdœ kœsœ dœ gbetshelœ kpi, kœpa ekpe o'o œdœ kœdondœrœ, kœtshapu kœlɨsœ uzu œdœ pe djingili. ");
INSERT INTO mnh_vpl VALUES ("C212_21","077_12_21","2CO","12","21","21","Mœ sœ dœ awa adœke mœ kpa kœna ga ndœ 'e, Ndjaba nœ mœ zaza tshula ga tœ ala mœ ɓa utshu 'e nene, yé á mœ kœkɨkɨ nene mbœrœ azu ndjoro á endje mbœrœ lima ekperœ utshunœ yé á tshaapu kœfatshalɔsu endje tœ œrœ uburu nœ endje, tœ ekpe ɔtshɔ endje œdœ tœ angba budu nœ endje. ");
INSERT INTO mnh_vpl VALUES ("C213_1","077_13_1","2CO","13","1","1","Awa votɔ kœna mœ ga ndœ 'e dœke. Œdœ atimu bisha too votɔ kœpa o'o ama endje bale, endje wa o'o ye. ");
INSERT INTO mnh_vpl VALUES ("C213_2","077_13_2","2CO","13","2","2","Mœ sœ dœ o'o bale kœpa fœ azu á endje mbœrœ ekperœ œdœ fœ udu azu kɔ. Mœ pa lima o'onœ lœ bisha ana nœ mœ ga ndœ 'e ye, kashe mœ kpa sœ kœpa tœnœ ngɔngɔ asœke ɓata á mœ gugu nene; mœ kpa kœkwatœ mœ manda nœ kœwu 'e, mœ sœ dœ lɔsu nœ kœwu oyo uzu bale nene. ");
INSERT INTO mnh_vpl VALUES ("C213_3","077_13_3","2CO","13","3","3","'E sœ kœyindœ nœ adœke mœ ma adœke Kristu sœ kœpa o'o lœ awa nœ mœ. Kristu mama kœmɔ ga ndœ 'e nene, kashe tshe sœ kœma gbɔgbɔ nœ ye ɓa ugurutœ 'e. ");
INSERT INTO mnh_vpl VALUES ("C213_4","077_13_4","2CO","13","4","4","Adjapu, tshe sœ lima dœ kœmɔ lɔkɔ á endje kuru she ga pa kurushi, kashe ngɔngɔnœ asœke tshe sœ dœ soro lœ awa nœ gbɔgbɔ nœ Ndjaba. A'a ndje, 'a sœ dœ kœmɔ mbœrœ á 'a ngbɔtœ 'a bale dœ she. Kashe 'a sœ kœyisœ nœ fœ 'e adœke 'a sœ bala dœ soro dœ she lœ awa nœ gbɔgbɔ nœ Ndjaba. ");
INSERT INTO mnh_vpl VALUES ("C213_5","077_13_5","2CO","13","5","5","'E tondœtœ 'e dœ tœ 'e, 'e ma œdœ 'e kœsœ dœ kœyindœrœ. 'E wuwusœ nœ adœke Yisu Kristu sœ ugurutœ 'e nene a? 'E wu lɔsu 'e dœ tœ 'e. Too 'e kœma ete adœke 'e te yekane. ");
INSERT INTO mnh_vpl VALUES ("C213_6","077_13_6","2CO","13","6","6","Mœ gbe adœke 'e wu bala sœ nœ adœke 'a mbœrœ œnœ 'a œrœnœ ye. ");
INSERT INTO mnh_vpl VALUES ("C213_7","077_13_7","2CO","13","7","7","'A sœ kœza avwala fœ Ndjaba adœke 'e mbœmbœrœ ekperœ bale nene. 'A gbegbe kœguma o'onœ ɓa utshu 'e nene, kashe 'a gbe adœke 'e mbœrœ ɔtshɔrœ ataa á kœmatœ endje adœke 'a te. ");
INSERT INTO mnh_vpl VALUES ("C213_8","077_13_8","2CO","13","8","8","Gbambanœ nene, 'a lili kœmbœrœ œrœ neke á sœ kpi tœ adja o'o nene, 'a mbœrœ kolœ œneke á dœ adja o'o. ");
INSERT INTO mnh_vpl VALUES ("C213_9","077_13_9","2CO","13","9","9","'A sœ kœsœ dœ yanga lɔkɔ kɔ á 'a kœmɔ, yé á 'e sœ dœ gbɔgbɔ. Ádá kœza avwa nœ 'a kœdœ adœke 'e wuta azu á endje li. ");
INSERT INTO mnh_vpl VALUES ("C213_10","077_13_10","2CO","13","10","10","Mbœrœ tœnœ ataa dá mœ su mbetinœ asœ fœ 'e lœ ɨngɨrɨnœ adœke: œ sœsœ mbœrœ adœke mœ kœsœ ugurutœ 'e, mœ wa o'o dœ ɔgbɔ ga tœ 'e lindœ tshagbozu á Gbozu za fœ mœ nene. Tshagbozunœ asœmœ sœ mbœrœ kœgi kœyindœrœ nœ 'e ga utshunœ, kashe œ dœ́dœ́ mbœrœ kœndɨ tœnœ nene. ");
INSERT INTO mnh_vpl VALUES ("C213_11","077_13_11","2CO","13","11","11","Yé ngɔngɔ asœke alaya, 'e sœ dœ yanga, 'e mbœrœ akwa adœke œ gi 'e ga utshunœ, 'e to gbɔgbɔ lœ tœ 'e, 'e djitœ 'e dœ ɔtshɔnœ, 'e sœ gee, yé Ndjaba nœ kœyindœsho œdœ œnœ kœsœ gee, œ sœ dœ 'e awa bale. ");
INSERT INTO mnh_vpl VALUES ("C213_12","077_13_12","2CO","13","12","12","'E za œyerœ abala nœ ayazu ugurutœ 'e. Ayerœ azu nœ Ndjaba para bala 'e. ");
INSERT INTO mnh_vpl VALUES ("C213_13","077_13_13","2CO","13","13","13","Kaka adœke ɔtshɔ lɔsu nœ Gbozu Yisu Kristu, dœ kœyindœsho nœ Ndjaba œdœ pe Ɔtshɔ Ɨshirɨ á ngbɔtœ ye dœ endje bale ga tœnœ, sœ dœ 'e para kɔkɔ.");
INSERT INTO mnh_vpl VALUES ("GL1_1","078_1_1","GAL","1","1","1","Œmœ Polo, ayi avwa nœ Yisu Kristu, œ dœ́dœ́ azu dá ke mœ kœdœ ayi avwa nene. Œ dœ́dœ́ ndje uzu dá vwa mœ adœke mœ wuta ayi avwa nene. Kashe Yisu Kristu œdœ Aba dœ Ndjaba á tshe she she lœ akuzu asœmœ dá vwa mœ. ");
INSERT INTO mnh_vpl VALUES ("GL1_2","078_1_2","GAL","1","2","2","Aaya kɔ á endje sœ dœ mœ kpœke te ga ndœ mœ yekane á 'a su mbetinœ asœke fœ Ikrizia lœ ogo Galate: ");
INSERT INTO mnh_vpl VALUES ("GL1_3","078_1_3","GAL","1","3","3","Kaka Aba azœ dœ Ndjaba œdœ pe Gbozu Yisu Kristu ma ɔtshɔ lɔsu nœ endje ga ndœ 'e yé œ za kœsœ gee fœ 'e. ");
INSERT INTO mnh_vpl VALUES ("GL1_4","078_1_4","GAL","1","4","4","Kristu tshu lima lœ kumu ekperœ nœ azœ, tshe gbota azœ lœ ekperœ nœ tshapashɔnœ asœ, liaka œneke á Aba azœ dœ Ndjaba yi lima ndœ nœ adœke tshe mbœrœ. ");
INSERT INTO mnh_vpl VALUES ("GL1_5","078_1_5","GAL","1","5","5","Kaka tshe sœ dœ mokɔ ngbugu dœ ngbugu. Ame. ");
INSERT INTO mnh_vpl VALUES ("GL1_6","078_1_6","GAL","1","6","6","Mœ katœ ama mœ tɨ ɔsɔ kœwu adœke 'e fa tshangba 'e katsha gbɔ tsheneke á tshe e 'e lœ awa nœ ɔtshɔ lɔsu nœ Kristu, mbœrœ kœkpa mangba anga tafo Ɔtshɔ O'o. ");
INSERT INTO mnh_vpl VALUES ("GL1_7","078_1_7","GAL","1","7","7","Anga tafo Ɔtshɔ O'o gugu nene, kashe anga azu dá sœ kœdjingili tshelœ kumu 'e yé á sœ kœfa tshelœ Ɔtshɔ O'o nœ Kristu. ");
INSERT INTO mnh_vpl VALUES ("GL1_8","078_1_8","GAL","1","8","8","Kashe œdœ anga uzu bale, œdœ a'a, œdœ ndje anga andjelu á tshe kœto ɓa lafo, á kœmɨndœ anga Ɔtshɔ O'o á kœsœ kpi tœ œneke á 'a mɨ lima ndœ nœ fœ 'e, kaka Ndjaba darandœ ye. ");
INSERT INTO mnh_vpl VALUES ("GL1_9","078_1_9","GAL","1","9","9","'A pa lima ndœ nœ utshunœ yé mœ kpa sœ kœpa tœnœ ngɔngɔ asœ adœke: Uzu á tshe kœpandœ Ɔtshɔ O'o á sœ kpi tœ œneke á 'e gbɔ lima, kaka Ndjaba darandœ ye. ");
INSERT INTO mnh_vpl VALUES ("GL1_10","078_1_10","GAL","1","10","10","Yé atamœ 'e sœ kœgbe ngɔngɔ asœ adœke mœ sœ kœpara awa adœke azu yindœ mœ a? Bale nene, mœ sœ kœpara awa adœke mœ za yanga fœ Ndjaba. Œdœ mœ kœpara awa kœza yanga fœ azu, mœ kpa dœ ayi kœmbœrœ akwa nœ Kristu nene. ");
INSERT INTO mnh_vpl VALUES ("GL1_11","078_1_11","GAL","1","11","11","Aaya mœ, mœ sœ kœpa ngbɨ fœ 'e adœke: Ɔtshɔ O'onœ á mœ mɨ lima ndœ nœ fœ 'e asœmœ toto lœ gbetshelœ nœ uzu nene. ");
INSERT INTO mnh_vpl VALUES ("GL1_12","078_1_12","GAL","1","12","12","Gbambanœ nene, mœ gbɔgbɔ tshakane uzu nene, œ dœ́dœ́ ndje uzu dá yisœ nœ fœ mœ nene. Kashe Yisu Kristu dá ma lima fœ mœ. ");
INSERT INTO mnh_vpl VALUES ("GL1_13","078_1_13","GAL","1","13","13","'E dji lima ndœ mara kœmbœrœtœ mœ lɔkɔ á mœ sœpe lima lœ awa akwa nœ Ayuda. Mœ mbœrœ lima œrœ kanga fœ Ikrizia nœ Ndjaba waa, yé mœ para lima dœ awa kɔ adœke œ ndɨ ye. ");
INSERT INTO mnh_vpl VALUES ("GL1_14","078_1_14","GAL","1","14","14","Mœ sœ lima dœ kœyindœrœ ga tœ awa akwa nœ Ayuda dœ kœza ga tœ akwa, yé œ za lima tœ mœ ga tœ awa nœ aata azœ kœropa anga anga mœ kɔ á 'a gerœ dœ endje lœ ogo nœ azœ. ");
INSERT INTO mnh_vpl VALUES ("GL1_15","078_1_15","GAL","1","15","15","Kashe, lɔkɔ á Ndjaba wu lima dœ ɔtshɔnœ, tshe ke lima mœ katshatsha utshunœ adœke endje zu mœ, yé œ e lima mœ lœ ɔtshɔ lɔsu nœ ye. ");
INSERT INTO mnh_vpl VALUES ("GL1_16","078_1_16","GAL","1","16","16","Tshe mbœrœ lima adœke mœ wusœ Gbolo nœ ye, yekane á kœyisœ Ɔtshɔ O'o nœ ye fœ azu á endje dœ́dœ́ Ayuda nene. Ataa, mœ nana ga ndœ anga uzu kœyu she ndœ kœmɨ upu fœ mœ nene. ");
INSERT INTO mnh_vpl VALUES ("GL1_17","078_1_17","GAL","1","17","17","Mœ nana ndje lima ga lœ Yerusaleme ndœ kœwu endjeneke á endje dœ lima aayi avwa nœ Kristu utshunœ nene. Kashe mœ ro lima ɓa lœ ogo Arabi, yeka manda nœ, á mœ kwatœ mœ ga lœ Damaseke. ");
INSERT INTO mnh_vpl VALUES ("GL1_18","078_1_18","GAL","1","18","18","Yé manda ungu votɔ, mœ na ga lœ Yerusaleme mbœrœ kœgbɔtœ mœ dœ Petro. Mœ lo ɓa ndœ ye olo ndjokpa dœ mindu. ");
INSERT INTO mnh_vpl VALUES ("GL1_19","078_1_19","GAL","1","19","19","Mœ wuwu anga angbɨ ayi avwa bale nene, kashe kolœ Jake á tshe kœdœ aya Gbozu. ");
INSERT INTO mnh_vpl VALUES ("GL1_20","078_1_20","GAL","1","20","20","Œneke á mœ sœ kœsu fœ 'e asœke, mœ sœ kœpa adja utshu Ndjaba adœke œ dœ́dœ́ wala nene. ");
INSERT INTO mnh_vpl VALUES ("GL1_21","078_1_21","GAL","1","21","21","Manda nœ, mœ na ɓa lœ ogo Siri dœ pe Silisi, ");
INSERT INTO mnh_vpl VALUES ("GL1_22","078_1_22","GAL","1","22","22","kashe endje wuwu lima sœ mœ ɓa lœ Ikrizia nœ Kristu lœ ogo Yuda nene. ");
INSERT INTO mnh_vpl VALUES ("GL1_23","078_1_23","GAL","1","23","23","Endje djidji lima kolœnœ adœke: «Œshe á tshe sœ lima kœmbœrœ œrœ kanga fœ azœ, dá kpa tetœ kœyisœ œrœ ngɔngɔnœ asœ tœ upu nœ kœyindœrœnœ á tshe pa lima avwara adœke œne wo ye.» ");
INSERT INTO mnh_vpl VALUES ("GL1_24","078_1_24","GAL","1","24","24","Yé endje te lima tœ kœdonga Ndjaba tœ upu nœ mœ. ");
INSERT INTO mnh_vpl VALUES ("GL2_1","078_2_1","GAL","2","1","1","Yé manda ungu ndjokpa dœ vana, 'a kpa kwatœ 'a dœ Barnabase ga lœ Yerusaleme; mœ za ndje lima Tito potœ mœ. ");
INSERT INTO mnh_vpl VALUES ("GL2_2","078_2_2","GAL","2","2","2","Mœ kwa lima tœ mœ mbœrœ á Ndjaba ma lima tœ ye, á pa fœ mœ adœke mœ na ga zœ. 'A ngbɔɓa lima tœ 'a kolœ dœ agbozu Ikrizia á œsœ endje lɨ, á mœ pandœ œsœ́ Ɔtshɔ O'onœ á mœ sœ kœmɨndœ nœ fœ azu á endje dœ́dœ́ Ayuda nene fœ endje. Gbambanœ nene, mœ sœ dœ awa adœke akwa á mœ sœ kœmbœrœ tœnœ œdœ pe œneke á mœ kpa mbœrœ sœsœ gbambanœ nene. ");
INSERT INTO mnh_vpl VALUES ("GL2_3","078_2_3","GAL","2","3","3","Kashe Tito, uzu Greke á 'a na tœ awanœ dœ she, endje shoshosho she adœke endje wa she tœ gaza nene. ");
INSERT INTO mnh_vpl VALUES ("GL2_4","078_2_4","GAL","2","4","4","Anga aayi kœna manda Yisu dœ wala yi lima ndœ nœ adœke endje wa she tœ gaza. Endje li lima yagele ga ugurutœ 'a mbœrœ kœwu mara á 'a wuta lœ awa akwa nœ Ayuda, á ngbɔtœ 'a bale dœ Yisu Kristu asœmœ. Endje para awa adœke œne kpa gi 'a ga lœ œrœ kanga nœ awa akwa nœ Ayudanœ. ");
INSERT INTO mnh_vpl VALUES ("GL2_5","078_2_5","GAL","2","5","5","'A vwara tœ 'a kara kœdji azunœ asœmœ, mbœrœ 'a yi lima ndœ kœgbɔndœ adjapu nœ Ɔtshɔ O'o ugurutœ 'e. ");
INSERT INTO mnh_vpl VALUES ("GL2_6","078_2_6","GAL","2","6","6","Kashe agbɔ agbozunœ á œsœ endje lɨ asœmœ, œdœ mara á endje lœ dœ tœnœ wuwu mœ nene. Gbambanœ nene, utshu Ndjaba, azu kɔ sœ awa bale. Endje papa anga o'o kpi ga pa œneke á mœ pa nene. ");
INSERT INTO mnh_vpl VALUES ("GL2_7","078_2_7","GAL","2","7","7","Kashe endje wu adœke Ndjaba za akwa kœyisœ Ɔtshɔ O'o fœ angbɨ azu ga tshakane mœ ɓata á tshe za lima fœ Petro adœke tshe yisœ nœ fœ Ayuda. ");
INSERT INTO mnh_vpl VALUES ("GL2_8","078_2_8","GAL","2","8","8","Gbambanœ nene, Ndjaba á tshe mbœrœ lima akwa lœ Petro adœke tshe yisœ Ɔtshɔ O'o fœ Ayuda, dá mbœrœ ndje lœ mœ adœke mœ yisœ nœ fœ angbɨ azu. ");
INSERT INTO mnh_vpl VALUES ("GL2_9","078_2_9","GAL","2","9","9","Jake, Petro œdœ Yowane á azu nœ Kristu wu lima endje ɓata agbozu tshapa endje, endje yi lima ndœ nœ adœke Ndjaba dá za akwanœ asœke fœ mœ. Mbœrœ tœnœ atamœ, 'a ko lima tshelœ ama kane 'a dœ endje tœ kœma fœ azu adœke 'a ngbɔ lœma akwanœ asœke bale dœ endje. Atamœ, 'a yi lima ndœ nœ awa bale dœ endje adœke, a'a dœ Barnabase 'a na kœmɨndœ Ɔtshɔ O'o fœ angbɨ azu, yé endje na œnœ endje kœyisœ nœ fœ Ayuda. ");
INSERT INTO mnh_vpl VALUES ("GL2_10","078_2_10","GAL","2","10","10","Endje pa lima fœ 'a kolœnœ adœke 'a gbe dœ aayi oyo. Yé mœ za lima tœ mœ djigi ndœ kœmbœrœ tœnœ. ");
INSERT INTO mnh_vpl VALUES ("GL2_11","078_2_11","GAL","2","11","11","Kashe lɔkɔ á Petro na ɓa lœ Atiɔshe, mœ gbagbara she tœ ala azu mbœrœ œrœ á tshe mbœrœ lima sœsœ dœ ɔtshɔnœ nene. ");
INSERT INTO mnh_vpl VALUES ("GL2_12","078_2_12","GAL","2","12","12","Yé utshunœ adœke azu á Yakobo vwa endje na, tshe sœ lima kœzɨ œrœ tœ œsœnœ dœ angbɨ azu. Kashe manda kœyi kumu endje, tshe gitœ ye ugurutœ angbɨ azu œ kpa katœ kœzɨ œrœ awa bale dœ endje kparawa Ayuda. ");
INSERT INTO mnh_vpl VALUES ("GL2_13","078_2_13","GAL","2","13","13","Anga Ayuda mbœrœtœ endje ndje ɓata Petro, yé œ bɨlɨ Barnabase á tshe te ndje ga lœ mara kœmbœrœ œrœ nœ endje. ");
INSERT INTO mnh_vpl VALUES ("GL2_14","078_2_14","GAL","2","14","14","Kashe lɔkɔ á mœ wu adœke endje sœsœ lima kœna ndjii lœ adja awa nœ Ɔtshɔ O'o nene, mœ pa fœ Petro tœ ala azu kɔkɔ adœke: «Œɓœ á ɓœ dœ Yuda, ɓœ sœsœ kœmbœrœtœ zœ ɓata Yuda nene, kashe ɓata angbɨ uzu. Ɓœ ka pa angbɨ azu adœke endje mbœrœtœ endje ɓata Ayuda kotoo?» ");
INSERT INTO mnh_vpl VALUES ("GL2_15","078_2_15","GAL","2","15","15","Azœ kœdœ adja Ayuda tako, a dœ́dœ́ angbɨ azu á ndje dœ́ aayi kœmbœrœ ekperœ nene. ");
INSERT INTO mnh_vpl VALUES ("GL2_16","078_2_16","GAL","2","16","16","A wusœ nœ adœke uzu œ wuta ndjii tœ ala Ndjaba mbœrœ kœlɨsœ awa akwa nœ Ayuda nene, kashe tshe wuta ndjii mbœrœ kœyindœrœ nœ ye ga ndœ Yisu Kristu. Azœ ndje awa bale, a yindœ Yisu Kristu mbœrœ a kœwuta ndjii mbœrœ kœyindœrœ nœ azœ ga ndœ Kristu, kashe œ sœsœ mbœrœ kœlɨsœ awa akwa nene. Gbambanœ nene, lœ awa nœ kœlɨsœ awa akwa, uzu bale œ sœ ndjii nene. ");
INSERT INTO mnh_vpl VALUES ("GL2_17","078_2_17","GAL","2","17","17","Kashe, œdœ 'a kœpara awa kœte azu ndjii lœ Kristu, œ sœ ɓata 'a dœ ndje lima ekpe azu ɓata angbɨ azu. Atamœ, œ yindœ kœpa adœke Kristu dá sœ kœvwa azu ga lœ ama ekperœ a? Œ̃, œ sœsœ ataa bale nene. ");
INSERT INTO mnh_vpl VALUES ("GL2_18","078_2_18","GAL","2","18","18","Œdœ mœ kpa kœkwatœ mœ ndœ kœlɨsœ awa akwa á mœ vwaratœ mœ tœnœ, dá mœ sœ kœma dœ tœ mœ adœke œmœ kœdœ ayi kœmbœrœ ekperœ. ");
INSERT INTO mnh_vpl VALUES ("GL2_19","078_2_19","GAL","2","19","19","Gbambanœ nene, tœ œmœ nœ mœ, tœ upu á wu awa akwa, mœ sœ ɓata uzu á tshe tshu ye. Awa akwanœ dá wo mœ, mbœrœ adœke mœ sœ dœ tafo soro á kœmbœrœ akwa fœ Ndjaba. Endje kuru mœ ga pa kurushi awa bale dœ Kristu. ");
INSERT INTO mnh_vpl VALUES ("GL2_20","078_2_20","GAL","2","20","20","Soro á mœ sœ dœ tœnœ dœ́dœ́ tœ mœ nene, kashe Kristu dá sœ dœ soro lœ mœ. Gbambanœ nene, mbœrœ lœ soro nœ mœ ngɔngɔ asœ lœ ɔkɔ, mœ sœ dœ tœnœ lœ kœyindœrœ ga ndœ Gbolo nœ Ndjaba á tshe yindœ mœ yé á tshu mbœrœ mœ. ");
INSERT INTO mnh_vpl VALUES ("GL2_21","078_2_21","GAL","2","21","21","Mœ yiyindœ nœ adœke ɔtshɔ lɔsu nœ Ndjaba ga ndœ mœ sœ gbambanœ nene. Mbœrœ œdœ uzu kœsœ kœpara kœwuta ndjii lœ awa nœ kœmbœrœtœ ye liaka awa akwa, œ yindœ kœpa adœke ádá kuzu nœ Kristu gugu nene. ");
INSERT INTO mnh_vpl VALUES ("GL3_1","078_3_1","GAL","3","1","1","Uu, azu ogo Galate, œrœ sœ lœ kumu 'e a! Œɗe dá mbœrœ œrœ e'e a? Andaa mœ yi lima sœ mara kuzu á Yisu tshu pa kurushi dœ tœnœ fœ 'e ngbɨ ye o! ");
INSERT INTO mnh_vpl VALUES ("GL3_2","078_3_2","GAL","3","2","2","Mœ yindœ kœyu 'e dœ o'o bale: 'E gbɔ Ɨshirɨ nœ Ndjaba mbœrœ á 'e lɨsœ awa akwa nœ Ayuda a, too 'e gbɔ Ɨshirɨ nœ Ndjaba mbœrœ Ɔtshɔ O'o á 'e dji yé á yindœ nœ? ");
INSERT INTO mnh_vpl VALUES ("GL3_3","078_3_3","GAL","3","3","3","Kotoo, œrœ sœ lœ kumu 'e a? 'E te lima tœ kœna mangba Kristu dœ gbɔgbɔ nœ Ɔtshɔ Ɨshirɨ yé ngɔngɔ asœ, 'e yindœ kœwuta ga tœ ndɔngɔlɔnœ dœ gbɔgbɔ nœ 'e dœ tœ 'e a? ");
INSERT INTO mnh_vpl VALUES ("GL3_4","078_3_4","GAL","3","4","4","Atamœ, œneke kɔ á 'e wu sœ gbambanœ a? Œ li adœke œ sœ gbambanœ nene. ");
INSERT INTO mnh_vpl VALUES ("GL3_5","078_3_5","GAL","3","5","5","Lɔkɔ á Ndjaba sœ kœto Ɨshirɨ nœ ye fœ 'e yé á sœ kœmbœrœ afá ugurutœ 'e, tshe sœ kœmbœrœ tœnœ mbœrœ á 'e sœ kœlɨsœ awa akwa a? Bale nene, tshe sœ kœmbœrœ tœnœ mbœrœ á 'e dji Ɔtshɔ O'o yé á yindœ nœ. ");
INSERT INTO mnh_vpl VALUES ("GL3_6","078_3_6","GAL","3","6","6","'E gbe dœ Abrayamo kane. Endje sú ɓa la Buku nœ Ndjaba adœke: «Abrayamo sœ lima dœ kœyindœrœ ga ndœ Ndjaba, yé Ndjaba za she ɓata uzu á tshe sœ ndjii lœ kumu kœyindœrœ nœ ye.» ");
INSERT INTO mnh_vpl VALUES ("GL3_7","078_3_7","GAL","3","7","7","'E wusœ nœ ngɔngɔ asœke adœke ayindœ Yisu kœdœ adja agbolo nœ Abrayamo. ");
INSERT INTO mnh_vpl VALUES ("GL3_8","078_3_8","GAL","3","8","8","Endje sú ɓa la Buku nœ Ndjaba utshunœ adœke, Ndjaba œ fa bala angbɨ azu tœ azu á endje sœ ndjii mbœrœ kœyindœrœ nœ endje. Ndjaba pa lima ndœ ɔtshɔ o'onœ asœ utshunœ fœ Abrayamo adœke: «Mœ to kane mœ ga pa azu tshapashɔnœ asœke kɔ lœ awa nœ zœ.» ");
INSERT INTO mnh_vpl VALUES ("GL3_9","078_3_9","GAL","3","9","9","Abrayamo yindœ nœ, yé Ndjaba to kane ye ga pa ye, ataa azu kɔ á endje sœ dœ kœyindœrœ, Ndjaba œ to kane ye ga pa endje ɓata á tshe to kane ye ga pa Abrayamo. ");
INSERT INTO mnh_vpl VALUES ("GL3_10","078_3_10","GAL","3","10","10","Kashe azu á endje sœ kœgbe adœke œne she mbœrœ kœlɨsœ awa akwa asœmœ, Ndjaba darandœ endje kɔ. Gbambanœ nene, endje sú ala Buku nœ Ndjaba adœke: «Uzu á tshe kœsœsœ kœlɨsœ œrœ kɔ á endje sú ga la Buku awa akwa yé á sœ kœza ga tœ akwa nene, Ndjaba darandœ ye yé.» ");
INSERT INTO mnh_vpl VALUES ("GL3_11","078_3_11","GAL","3","11","11","Œ matœ endje ngbɨ adœke uzu bale œ sœ ndjii utshu Ndjaba lœ kœmbœrœtœ ye lindœ awa akwa nene. Gbambanœ nene, endje sú ala Bukunœ adœke: «Uzu á tshe kœsœ ndjii tœ ala Ndjaba lœ awa nœ kœyindœrœ, tshe sœ bala dœ soro.» ");
INSERT INTO mnh_vpl VALUES ("GL3_12","078_3_12","GAL","3","12","12","Andaa kœlɨsœ awa akwa lili dœ kœsœ dœ kœyindœrœ nene. Kashe uzu á tshe lɨsœ awa akwa kɔ, tshe gbɔ soro lœ awa nœ awa akwanœ asœmœ. ");
INSERT INTO mnh_vpl VALUES ("GL3_13","078_3_13","GAL","3","13","13","Kristu yɔ azœ lœ ndœkidji nœ awa akwa á yi ma ndœ kœte ga pa azœ. Ndœkidjinœ te ga pa ye lœ kudu azœ. Gbambanœ nene, endje sú ala Buku nœ Ndjaba adœke: «Uzu kɔ á endje kuru she ga pa ɔyɔ, Ndjaba darandœ ye yé.» ");
INSERT INTO mnh_vpl VALUES ("GL3_14","078_3_14","GAL","3","14","14","Dœ tœnœ ataa, kœto kane á endje pa lima tœnœ fœ Abrayamo œ wuta ga ndœ angbɨ azu lœ awa nœ Yisu Kristu, yé azœ kɔ a gbɔ Ɔtshɔ Ɨshirɨ á Ndjaba pa lima tœnœ lœ awa nœ kœyindœrœ. ");
INSERT INTO mnh_vpl VALUES ("GL3_15","078_3_15","GAL","3","15","15","Aaya mœ, a tondœ kœmbœrœ œrœ nœ azu: Lɔkɔ á uzu kœsu mbeti kœkatœ uvu, uzu bale á tshe li kœvwara tœ ye tœnœ too kpa kœsu anga angbɨ œrœ ga pa nœ gugu nene. ");
INSERT INTO mnh_vpl VALUES ("GL3_16","078_3_16","GAL","3","16","16","A wusœ nœ dœ ɔtshɔnœ adœke Abrayamo dœ atanœ dá Ndjaba pa lima ndœ kœmbœrœ œrœ fœ endje. Endje susu ala Bukunœ adœke: «dœ aatanœ», ɓata azu ndjoro dá endje pa tœ endje nene. Kashe endje sú ala Bukunœ adœke: «dœ ata zœ», tœ kœyisœ uzu bale á tshe kœdœ Kristu. ");
INSERT INTO mnh_vpl VALUES ("GL3_17","078_3_17","GAL","3","17","17","Ádá o'onœ á mœ yindœ kœpa fœ 'e dœke: lima utshunœ, Ndjaba guma ayo dœ Abrayamo yé œ pandœ nœ adœke œne gbɔndœ nœ. Manda nœ, œndœnœ dɨ ngbugu kama vana dœ zazu bale dœ ndjokpa yekane á awa akwanœ wuta. Ɓata awa akwa lili kœwo ayo á Ndjaba guma lima utshunœ nene, œ li ndje ndœ kœwo o'o á Ndjaba pa lima ndœ nœ nene. ");
INSERT INTO mnh_vpl VALUES ("GL3_18","078_3_18","GAL","3","18","18","Kashe œ kœsœ adœke Ndjaba to anga œrœ mbœrœ kœlɨsœ awa akwa, azu œ gbɔ ma œneke á tshe pa lima ndœ nœ nene. Andaa lœ awa nœ kœpandœ œrœ dá Ndjaba má lima ɔtshɔ lɔsu nœ ye ga ndœ Abrayamo. ");
INSERT INTO mnh_vpl VALUES ("GL3_19","078_3_19","GAL","3","19","19","Ataa, ádá awa akwa kœdœ gaɗe? Ndjaba za lima awa akwa mbœrœ kœma ekperœ œrrr ga tœ kœwuta ata Abrayamonœ á tshe pa lima o'o tœ upu nœ ye. Aandjelu ko lima awa akwanœ ga tshakane uzu á tshe sœ lima ugurutœ Ndjaba dœ azu. ");
INSERT INTO mnh_vpl VALUES ("GL3_20","078_3_20","GAL","3","20","20","Andaa, Ndjaba za lima o'o fœ abrayamo lɔkɔ á tshe sœ kutɨ ye. Yé œ kœsœ adœke uzu mbœrœ œrœ dœ kutɨ ye, anga uzu œ gu ugurutœ ye dœ anga azu nene. ");
INSERT INTO mnh_vpl VALUES ("GL3_21","078_3_21","GAL","3","21","21","Œneke yindœ kœpa adœke, awa akwa vwaratœ ye tœ o'o á Ndjaba pa lima ndœ nœ ye a? Œ̃ œ̃ nene. Œdœ awa akwa kœsœ ma dœ gbɔgbɔ tœ kœto soro fœ azu, œ mbœrœ ma adœke azu wuta ndjii utshu Ndjaba mbœrœ á endje sœ kœlɨsœ awa akwa. ");
INSERT INTO mnh_vpl VALUES ("GL3_22","078_3_22","GAL","3","22","22","Kashe endje sú ɓa la Buku nœ Ndjaba adœke, ekperœ vwele azu tshapashɔ kɔ ga tœnœ yekane á ayindœ Yisu kœgbɔ ɔtshɔrœ á Ndjaba pa lima ndœ nœ lœ awa nœ kœyindœrœ nœ endje ga ndœ Yisu Kristu. ");
INSERT INTO mnh_vpl VALUES ("GL3_23","078_3_23","GAL","3","23","23","Lima utshunœ, damba Kristu nana lima adœke a sœ dœ kœyindœrœ ga ndœ ye nene, awa akwa vwele lima azœ ɓata akanga. Œ mbœrœ lima tœ ye atamœ œrrr ga tœ lɔkɔ á Ndjaba yisœ kœyindœrœ fœ azœ. ");
INSERT INTO mnh_vpl VALUES ("GL3_24","078_3_24","GAL","3","24","24","Yé atamœ, awa akwa dá sœ lima kœtondœ azœ œrrr ga tœ kœna Kristu, adœke a wuta azu á endje sœ ndjii tœ ala ye lœ awa nœ kœyindœrœ. ");
INSERT INTO mnh_vpl VALUES ("GL3_25","078_3_25","GAL","3","25","25","Kashe manda kœna kœyindœrœ, a kpa sœsœ tshakudu awa akwa nene. ");
INSERT INTO mnh_vpl VALUES ("GL3_26","078_3_26","GAL","3","26","26","Gbambanœ nene, e'e kɔkɔ kœdœ agbolo nœ Ndjaba lœ awa nœ kœyindœrœ á sœ kœngbɔɓa 'e dœ Yisu Kristu. ");
INSERT INTO mnh_vpl VALUES ("GL3_27","078_3_27","GAL","3","27","27","Adjapu, e'e kɔkɔ á 'e gbɔ batisimu, 'e ngbɔtœ 'e bale dœ Kristu, yé ngɔngɔ asœke, 'e za mara Kristu dœ tœ ye. ");
INSERT INTO mnh_vpl VALUES ("GL3_28","078_3_28","GAL","3","28","28","Ádá kœkuru tshagurutœ azu kpa gugu nene. Œdœ Ayuda, œdœ angbɨ azu, œdœ akanga, œdœ ayengɔ ogo, œdœ ayakoshe, œdœ ayashe, e'e para kɔkɔ 'e wuta uzu bale lœ kœngbɔtœ 'e dœ Yisu Kristu. ");
INSERT INTO mnh_vpl VALUES ("GL3_29","078_3_29","GAL","3","29","29","Yé œdœ 'e kœdœ azu nœ Kristu, dá 'e kœdœ aata Abrayamo, yé 'e dœ ayengɔ kœgbɔ œrœ tshangbanœ á Ndjaba pa lima tœnœ. ");
INSERT INTO mnh_vpl VALUES ("GL4_1","078_4_1","GAL","4","1","1","'E wu gbetshelœ nœ mœ: Œdœ uzu á tshe kœdœ ayengɔ kœgbɔrœ tshangbanœ kœsœ pe damba gbolo, œdœ œrœ para kɔkɔ kœdœ œnœ ye gbaa, tshe sœ kolœ ɓata kanga. ");
INSERT INTO mnh_vpl VALUES ("GL4_2","078_4_2","GAL","4","2","2","Kashe tshe zatœ ye ga atɨ, yé aayi kœgbɔndœ ye œ gbɔndœ ye dœ œrœ nœ ye kɔ œrrr ga tœ olo á abanœ za. ");
INSERT INTO mnh_vpl VALUES ("GL4_3","078_4_3","GAL","4","3","3","Azœ ndje awa bale, a dœ lima akanga lɔkɔ á a dœ lima agbolo tshakudu œrœ nœ tshapashɔ. ");
INSERT INTO mnh_vpl VALUES ("GL4_4","078_4_4","GAL","4","4","4","Kashe lɔkɔ á olo á Ndjaba za lima li, tshe vwa Gbolo nœ ye á tshe wuta lœ yashe yé á sœ lima kœlɨsœ awa akwa nœ Ayuda, ");
INSERT INTO mnh_vpl VALUES ("GL4_5","078_4_5","GAL","4","5","5","mbœrœ kœvwara endjeneke á endje sœ tshakudu awa akwa ga ushu, dœ pe kœza awa fœ azœ adœke a te agbolo nœ Ndjaba. ");
INSERT INTO mnh_vpl VALUES ("GL4_6","078_4_6","GAL","4","6","6","Tœ kœma adœke e'e kœdœ agbolo nœ Ndjaba, tshe vwa Ɨshirɨ nœ Gbolo nœ ye ga tœ lɔsu azœ, á sœ kœpa adœke: «Aba!» ");
INSERT INTO mnh_vpl VALUES ("GL4_7","078_4_7","GAL","4","7","7","Ataa, ɓœ kpa dœ́dœ́ kanga nene, kashe gbolo. Yé ɓata gbolo, ɓœ kœdœ ayengɔ kœgbɔ œrœ tshangbanœ: œtœnœ kœdœ akwa nœ Ndjaba. ");
INSERT INTO mnh_vpl VALUES ("GL4_8","078_4_8","GAL","4","8","8","Utshunœ, 'e wuwu lima sœ Ndjaba nene yé 'e dœ lima akanga nœ andjaba á endje dœ́dœ́ adja andjaba nene. ");
INSERT INTO mnh_vpl VALUES ("GL4_9","078_4_9","GAL","4","9","9","Kashe ngɔngɔ asœke ɓata á 'e wusœ Ndjaba, too Ndjaba wusœ 'e ye, œ li adœke 'e kpa kwatœ 'e ndœ œrœ tshapashɔ á gugu dœ gbɔgbɔ nene yé á sœ gbambanœ, dœ mara adœke 'e kpa dœ akanganœ ye a? ");
INSERT INTO mnh_vpl VALUES ("GL4_10","078_4_10","GAL","4","10","10","'E sœpe tœ kœlɨsœ olo, dœ yapu, dœ tshakala ungu œdœ ungu! ");
INSERT INTO mnh_vpl VALUES ("GL4_11","078_4_11","GAL","4","11","11","Œneke á 'e mbœrœ asœke sœ kœza awa fœ mœ waa. Œrrr á tshangba akwa nœ mœ ugurutœ 'e œ sœ gbambanœ a! ");
INSERT INTO mnh_vpl VALUES ("GL4_12","078_4_12","GAL","4","12","12","Alaya mœ, mœ sœ kœkɨ fœ 'e adœke 'e mbœrœtœ 'e ɓata mœ; gbambanœ nene, mœ sœ kœmbœrœ ndje tœ mœ ɓata 'e. Bale 'e mbœmbœrœ lima anga ekperœ fœ mœ nene. ");
INSERT INTO mnh_vpl VALUES ("GL4_13","078_4_13","GAL","4","13","13","'E wusœ nœ dœ ɔtshɔnœ adœke, œ sœ lima dœ lɔkɔ á mœ sœ dœ koɓa dá mœ yi lima sœ Ɔtshɔ O'o ama Ndjaba tœ alinœ utshunœ fœ 'e. ");
INSERT INTO mnh_vpl VALUES ("GL4_14","078_4_14","GAL","4","14","14","'E wu lima oyo dœ mœ dœ koɓanœ waa, yé bale 'e mɔmɔ lima dœ mœ nene yé œ wuwu mœ djerœ djerœ lœ ala 'e nene. 'E fafa ndje tshangba 'e fœ mœ nene. Kashe 'e za lima osho kœsœ fœ mœ ɓata œmœ kœdœ andjelu nœ Ndjaba, too ɓata œmœ kœdœ Kristu Yisu má dœ tœ ye. ");
INSERT INTO mnh_vpl VALUES ("GL4_15","078_4_15","GAL","4","15","15","'E sœ lima dœ yanga utshunœ waa, yé ngɔngɔnœ asœ, œ kpa mbœrœ kotoo o? Mœ pa ngbɨ adœke, œdœ 'e kœgbɔ liya awa, 'e tshagavwa ala 'e mbœrœ kœko fœ mœ. ");
INSERT INTO mnh_vpl VALUES ("GL4_16","078_4_16","GAL","4","16","16","Yé ngɔngɔ asœke, 'e sœ kœyiangba mœ, mbœrœ á mœ sœ kœpa adja o'o a? ");
INSERT INTO mnh_vpl VALUES ("GL4_17","078_4_17","GAL","4","17","17","Anga azu sœ kœma adœke œne sœ dœ egerœ ogo 'e tœ lɔsu œne, kashe gbetshelœ nœ endje sœsœ dœ ɔtshɔnœ nene. Endje sœ kœpara kœkuru tshagurutœ azœ dœ 'e yekane á 'e kœsœ dœ egerœ ogo endje. ");
INSERT INTO mnh_vpl VALUES ("GL4_18","078_4_18","GAL","4","18","18","Œneke á ga kœdœ kœma ogo nœ kœmbœrœ ɔtshɔrœ á ka nene, œdœ mœ sœ ugurutœ 'e œdœ mœ sœ ugurutœ 'e nene. ");
INSERT INTO mnh_vpl VALUES ("GL4_19","078_4_19","GAL","4","19","19","Agbolo nœ mœ, mœ kpa sœ kœwu oyo mbœrœ 'e ɓata yashe á tshe sœ dœ koɓa kœzu œrrr adœke 'e wuta kœmbœrœtœ 'e ɓata Kristu yekane. ");
INSERT INTO mnh_vpl VALUES ("GL4_20","078_4_20","GAL","4","20","20","Uu! Mœ gbe má adœke 'a sœ dœ 'e ngɔngɔnœ asœke, mbœrœ á mœ kœwusœ mara á li adœke mœ pa dœ o'o fœ 'e. Gbambanœ nene, mœ kpa wuwusœ o'o á mœ pa nene. ");
INSERT INTO mnh_vpl VALUES ("GL4_21","078_4_21","GAL","4","21","21","'E pandœ nœ fœ mœ ka, e'e á 'e yindœ kœzatœ 'e ga tœ awa akwa nœ Ayudanœ asœke, 'e sœsœ kœdji œneke á awa akwa sœ kœpa tœnœ nene a? ");
INSERT INTO mnh_vpl VALUES ("GL4_22","078_4_22","GAL","4","22","22","Endje su lima adœke, Abrayamo zu lima agbolo yakoshe bisha. Anga bale tœ Agare á tshe dœ yashe kanga, anga tœ Sara á tshe dœ́dœ́ yashe kanga nene. ");
INSERT INTO mnh_vpl VALUES ("GL4_23","078_4_23","GAL","4","23","23","Kashe tshe zu gbolo tœ yashe kanganœ lœ awa nœ ɔkɔ, yé gbolo nœ yashenœ á tshe dœ́dœ́ kanga nene, tshe zu she liaka o'o á Ndjaba pa lima tœnœ fœ she. ");
INSERT INTO mnh_vpl VALUES ("GL4_24","078_4_24","GAL","4","24","24","O'onœ á ro liya asœ sœ kœma anga œrœ fœ azœ. Œ sœ atake: ayashenœ bibisha asœ sœ kœma ayo bisha á Ndjaba guma lima. Bale kœdœ ayo á to ɓa pa kaga Sinayi, œtœnœ kœdœ Agare. Ayonœ asœke dá sœ kœzu agbolo kanga. ");
INSERT INTO mnh_vpl VALUES ("GL4_25","078_4_25","GAL","4","25","25","Agare kœdœ kaga Sinayi á sœ ɓa lœ ogo Arabi. Tshe kpa sœ ɓata ongbo Yerusaleme nœ ngɔngɔ asœke, mbœrœ ongbonœ dœ agbolo tshelœnœ kɔ kœdœ akanga. ");
INSERT INTO mnh_vpl VALUES ("GL4_26","078_4_26","GAL","4","26","26","Kashe Yerusaleme nœ tshalafo dœ́dœ́ kanga nene, yé œtœnœ kœdœ ayi azœ. ");
INSERT INTO mnh_vpl VALUES ("GL4_27","078_4_27","GAL","4","27","27","Gbambanœ nene, endje sú ala Buku nœ Ndjaba adœke: «Sœ dœ yanga, œɓœ dœ yashe mara á ɓœ sœsœ lima kœzu tœnœ nene. Ta rawa dœ yanga, œɓœ á koɓa kœzu agbolo kaka ɓœ nene, gbambanœ nene, yashe á akɔnœ katœ ye, tshe zu agbolo ndjoro kœropa yashe á tshe sœ dœ akɔnœ.» ");
INSERT INTO mnh_vpl VALUES ("GL4_28","078_4_28","GAL","4","28","28","Yé alaya mœ, e'e kœdœ ndje agbolo á endje zu 'e liaka o'o á Ndjaba pa lima tœnœ, ɓata endje zu ndje dœ Izaka. ");
INSERT INTO mnh_vpl VALUES ("GL4_29","078_4_29","GAL","4","29","29","Kashe utshunœ lima, gbolo á endje zu she ɓata agbolo á azu œ zu endje, sœ lima kœmbœrœ œrœ kanga fœ gbolo á endje zu she lœ awa nœ Ɨshirɨ. Yé ngɔngɔ asœke, œrœnœ sœpe ndje kœmbœrœtœ ye awa bale. ");
INSERT INTO mnh_vpl VALUES ("GL4_30","078_4_30","GAL","4","30","30","Yé Buku sœ kœpa o'o kotoo o? Œ sœ kœpa adœke: «Gɔrɔ yashe kanga dœ gbolo yakoshe nœ ye, gbambanœ nene, œ lili adœke gbolo nœ yashe kanga ngbɔpa kœgbɔ œrœ tshangba abanœ awa bale dœ gbolo nœ yashe á tshe dœ́dœ́ kanga nene.» ");
INSERT INTO mnh_vpl VALUES ("GL4_31","078_4_31","GAL","4","31","31","Mbœrœ tœnœ ataa alaya mœ, a dœ́dœ́ agbolo nœ yashe kanga nene, kashe azœ kœdœ agbolo nœ yashe á tshe dœ́dœ́ kanga nene. ");
INSERT INTO mnh_vpl VALUES ("GL5_1","078_5_1","GAL","5","1","1","Kristu gi azœ lœ kanga mbœrœ adœke a kpa dœ́dœ́ akanga nene. Adja 'e shi gbɨ yé 'e mbœmbœrœ adœke 'e kpa kwatœ 'e dœ akanga nene. ");
INSERT INTO mnh_vpl VALUES ("GL5_2","078_5_2","GAL","5","2","2","Œmœ Polo, mœ sœ kœpa fœ 'e adœke, œdœ endje kœsœ kœwa 'e tœ gaza, 'e kœsœpe kœza lɔsu 'e ga pa gaza, œ yindœ kœpa adœke ádá œrœnœ á Kristu mbœrœ fœ 'e gugu nene. ");
INSERT INTO mnh_vpl VALUES ("GL5_3","078_5_3","GAL","5","3","3","Yé mœ kpa sœ kœpandœ nœ fœ uzu kɔ adœke angbɨ uzu á tshe kœyindœ nœ adœke endje wa œne tœ gaza, œ li adœke tshe mbœrœtœ ye lindœ awa akwa djigi. ");
INSERT INTO mnh_vpl VALUES ("GL5_4","078_5_4","GAL","5","4","4","Œdœ 'e kœsœ kœpara kœsœ ndjii ɓa utshu Ndjaba lœ awa akwa, dá œ yindœ kœpa adœke 'e kurutshelœtœ 'e dœ Kristu ye. Atamœ, 'e wusœ nœ adœke 'e vwaratœ 'e tœ ɔtshɔ lɔsu nœ Ndjaba ye. ");
INSERT INTO mnh_vpl VALUES ("GL5_5","078_5_5","GAL","5","5","5","Tœ azœ, a za gbetshelœ nœ azœ ga tœ Ndjaba á tshe sœ kœmbœrœ adœke a sœ ndjii tœ ala ye, yé œtœnœ dá a sœ kœkate tœnœ lœ awa nœ Ɔtshɔ Ɨshirɨ á sœ kœmbœrœ akwa lœ kœyindœrœ nœ azœ. ");
INSERT INTO mnh_vpl VALUES ("GL5_6","078_5_6","GAL","5","6","6","Gbambanœ nene, uzu á tshe ngbɔtœ ye bale dœ Yisu Kristu, endje wa she too endje wa she nene, œ gugu dœ ada bale nene. Œneke á sœ dœ ádá kœdœ kœsœ dœ kœyindœrœ á sœ kœmatœ endje lœ awa nœ kœyindœsho. ");
INSERT INTO mnh_vpl VALUES ("GL5_7","078_5_7","GAL","5","7","7","Utshunœ, 'e sœ lima kœmbœrœtœ 'e dœ ɔtshɔnœ. Œɗe dá kpa ko œrœ ku lœ awa 'e, yé á pakata 'e kœmbœrœtœ 'e lindœ adja o'o a? ");
INSERT INTO mnh_vpl VALUES ("GL5_8","078_5_8","GAL","5","8","8","Œneke á endje pa fœ 'e á 'e yindœ nœ asœmœ, toto ɓa ndœ Ndjaba á tshe e 'e nene. ");
INSERT INTO mnh_vpl VALUES ("GL5_9","078_5_9","GAL","5","9","9","Azu pa walaka adœke: «Œdœ ɔyɔ kœsuku mapa kœsœ teasho, á endje djanga dœ zuwa mapanœ, œ suku mapanœ djigi.» ");
INSERT INTO mnh_vpl VALUES ("GL5_10","078_5_10","GAL","5","10","10","Œmœ, mœ za lɔsu mœ fœ Gbozu mbœrœ 'e. Mœ wusœ nœ adœke 'e za anga angbɨ awa kpi tœ œnœ mœ nene. Kashe uzu á tshe sœ kœdjingili kumu 'e asœmœ, tshe dœ uzu œɗe gbaa, Ndjaba œ za djofele fœ she. ");
INSERT INTO mnh_vpl VALUES ("GL5_11","078_5_11","GAL","5","11","11","Alaya mœ, tœ upu nœ mœ, œdœ mœ kœsœ pe kœyisœ o'o kœwa gaza, mbœrœ gaɗe á endje mbœrœ œrœ kanga fœ mœ a? Œ kœsœ atamœ, kœmɨndœ upu kuzu Kristu pa kurushi œdœ œrœ kœza o'o fœ uzu bale nene. ");
INSERT INTO mnh_vpl VALUES ("GL5_12","078_5_12","GAL","5","12","12","Tœ upu nœ azu á endje sœ kœdjingili tshelœ kumu 'e asœmœ, kaka endje 'oro tshashe endje. ");
INSERT INTO mnh_vpl VALUES ("GL5_13","078_5_13","GAL","5","13","13","Alaya mœ, Ndjaba e 'e adœke 'e wuta lœ kanga ye. 'E gbegbe adœke ɓata á 'e wuta lœ kanga asœmœ, 'e kpa na kœmbœrœ œrœ á ogo ɔkɔ 'e œ vwa 'e ndœ nœ nene. Kashe œ li adœke 'e mbœrœ akwa fœ anga 'e lœ awa nœ kœyindœsho. ");
INSERT INTO mnh_vpl VALUES ("GL5_14","078_5_14","GAL","5","14","14","Gbambanœ nene, awa akwa kɔ sœ lœ o'o tshebabale asœ: «Yindœ yanga zœ ɓata á ɓœ sœ kœyindœtœ zœ dœ tœ zœ.» ");
INSERT INTO mnh_vpl VALUES ("GL5_15","078_5_15","GAL","5","15","15","Kashe œdœ 'e kœsœ kœlotœ 'e yé á sœ kœto uku tœ 'e dœ tœ 'e ɓata agea tshelœ gusu, ala 'e gbɔ: ete nene, 'e wotœ 'e ugurutœ 'e kɔ ye. ");
INSERT INTO mnh_vpl VALUES ("GL5_16","078_5_16","GAL","5","16","16","Mbœrœ tœnœ, mœ sœ kœpa fœ 'e adœke: 'e mbœrœtœ 'e liaka œneke á Ɔtshɔ Ɨshirɨ œ yisœ nœ fœ 'e. Œdœ 'e kœsœ kœmbœrœ ataa, 'e mbœrœ œrœ á ɔkɔ œ vwa 'e ndœ kœmbœrœ tœnœ nene. ");
INSERT INTO mnh_vpl VALUES ("GL5_17","078_5_17","GAL","5","17","17","Gbambanœ nene, agbe nœ Ɔtshɔ Ɨshirɨ sœsœ awa bale dœ œnœ ɔkɔ nene yé œnœ ɔkɔ lili ndje dœ œnœ Ɔtshɔ Ɨshirɨ nene. Adjapu, ɔkɔ œdœ Ɔtshɔ Ɨshirɨ sœ kœnga koshe ugurutœ endje. Mbœrœ tœnœ ataa, 'e kpa lili kœmbœrœ œrœ á 'e gbe má kœmbœrœ tœnœ asœmœ nene. ");
INSERT INTO mnh_vpl VALUES ("GL5_18","078_5_18","GAL","5","18","18","Kashe, œ kœdœ Ɔtshɔ Ɨshirɨ dá sœ kœyisœ awa fœ 'e, dá 'e kpa sœsœ tshakudu awa akwa nene. ");
INSERT INTO mnh_vpl VALUES ("GL5_19","078_5_19","GAL","5","19","19","'E wu mara kœmbœrœtœsho œneke á ogo kœna manda ɔkɔ œ vwa azu kœmbœrœ tœnœ: kœmbœrœ angba budu, kœmbœrœ œrœ uburu, kœmbœrœ œrœ tshula, ");
INSERT INTO mnh_vpl VALUES ("GL5_20","078_5_20","GAL","5","20","20","kœdonga andjaba, kœmbœrœ afá, kœsœ dœ ekpe lɔsu, kœkurutshelœtœ osho, kœmbœrœ uku, kœsœ dœ ókó, kœgbugburu tshelœtœ osho, kœ'ea osho, kœli ga lœ anga ukpulu azu, ");
INSERT INTO mnh_vpl VALUES ("GL5_21","078_5_21","GAL","5","21","21","kœsœ dœ egerœ lɔsu, kœndjorœ dopa nœ, kœzɨrœ tɔpanœ kpuru œdœ pe anga œrœ á li dœ œneke kɔ. Mœ sœ kœpandœ nœ fœ 'e ngɔngɔ asœke ɓata á mœ pa lima utshunœ adœke: «Azu á endje sœ kœmbœrœ œrœnœ asœ, endje gbɔ Ogo gbozu nœ Ndjaba nene.» ");
INSERT INTO mnh_vpl VALUES ("GL5_22","078_5_22","GAL","5","22","22","Kashe akwa á Ɔtshɔ Ɨshirɨ œ vwa uzu kœmbœrœ tœnœ dœke: Kœyindœsho, kœsœ dœ yanga, kœsœ gee, kœsœ dœ ugu lɔsu, kœsœ dœ ɔtshɔ lɔsu, kœmbœrœ ayo, kœyindœrœ, ");
INSERT INTO mnh_vpl VALUES ("GL5_23","078_5_23","GAL","5","23","23","kœsœ dœ ɔmɔ lɔsu, kœdœ gbozu tshapa undu zœ. Awa akwa á vwaratœ ye tœ œrœnœ asœ gugu nene. ");
INSERT INTO mnh_vpl VALUES ("GL5_24","078_5_24","GAL","5","24","24","Endjeneke á endje ngbɔtœ endje bale dœ Yisu Kristu, endje wo ekpe ogo nœ ɔkɔ á vwa lima endje kœmbœrœ ekperœ ɓa pa kurushi. ");
INSERT INTO mnh_vpl VALUES ("GL5_25","078_5_25","GAL","5","25","25","Ɓata a sœ dœ soro lœ awa nœ Ɔtshɔ Ɨshirɨ, œ li adœke a na kolœ tœ awa á tshe sœ kœyisœ nœ fœ azœ. ");
INSERT INTO mnh_vpl VALUES ("GL5_26","078_5_26","GAL","5","26","26","Adja a sœsœ dœ egerœ kumu nene, a katœ kœshokɔ anga azœ dœ ama œdœ kœsœ dœ egerœ lɔsu ugurutœ azœ. ");
INSERT INTO mnh_vpl VALUES ("GL6_1","078_6_1","GAL","6","1","1","Alaya mœ, œdœ 'e kœgbɔ anga uzu bale á tshe kœsœ kœmbœrœ ekperœ, e'e má 'e sœ dœ Ɔtshɔ Ɨshirɨ asœmœ, 'e za she ga tœ awa ndjii dœ ɔmɔ lɔsu adœke tshe wuta lœ ekperœ. Yé ala 'e gbɔ, uzu dœ uzu adœke adja lɔsu ye bɨbɨlɨ she ndje nene. ");
INSERT INTO mnh_vpl VALUES ("GL6_2","078_6_2","GAL","6","2","2","'E tɨ kane anga 'e lœ ɔgbɔ œrœ kɔ. Œdœ 'e kœmbœrœ atamœ dá 'e mbœrœtœ 'e liaka awa akwa nœ Kristu. ");
INSERT INTO mnh_vpl VALUES ("GL6_3","078_6_3","GAL","6","3","3","Gbambanœ nene, œdœ uzu bale kœgbe adœke œne ropa anga œne, andaa tshe kœsœsœ ataa nene, tshe sœ kœfaratœ ye dœ tœ ye. ");
INSERT INTO mnh_vpl VALUES ("GL6_4","078_6_4","GAL","6","4","4","Kashe uzu dœ uzu tondœ ɔtshɔ ye dœ tœ ye kane. Œdœ œ kœsœ dœ ɔtshɔnœ, tshe sœ dœ yanga tœ akwa á tshe mbœrœ dœ tœ ye. Kashe œ dœ́dœ́ mbœrœ á tshe ropa anga yanganœ nene. ");
INSERT INTO mnh_vpl VALUES ("GL6_5","078_6_5","GAL","6","5","5","Gbambanœ nene, uzu dœ uzu œ za kongba tshangba œrœ á tshe mbœrœ dœ tœ ye. ");
INSERT INTO mnh_vpl VALUES ("GL6_6","078_6_6","GAL","6","6","6","Œ li adœke uzu á endje sœ kœyisœ o'o ama Ndjaba fœ she, ko anga tshakala œrœ nœ ye djigi fœ tsheneke á tshe sœ kœyisœrœnœ fœ she. ");
INSERT INTO mnh_vpl VALUES ("GL6_7","078_6_7","GAL","6","7","7","Adja lɔsu 'e fafara 'e nene: endje mɔmɔ Ndjaba nene. Uzu dœ uzu œ kɔ œneke á tshe lu. ");
INSERT INTO mnh_vpl VALUES ("GL6_8","078_6_8","GAL","6","8","8","Œdœ uzu kœlu œrœ kolœ mbœrœ ogo ɔkɔ ye, ngwarœ á tshe kɔ kœdœ kuzu. Kashe œdœ tshe kœlu œrœ neke á za yanga fœ Ɔtshɔ Ɨshirɨ, ataa Ɨshirɨ nœ Ndjaba œ to soro á ka nene fœ she. ");
INSERT INTO mnh_vpl VALUES ("GL6_9","078_6_9","GAL","6","9","9","Ɓata œ sœ ataa, œ li adœke a mɔ dœ kœmbœrœ ɔtshɔrœ nene. Gbambanœ nene, lɔkɔnœ kœwuta, a kœgbɔ œrœ tshangba œneke á lu œdœ a kœkakatœ kœmbœrœ tœnœ nene. ");
INSERT INTO mnh_vpl VALUES ("GL6_10","078_6_10","GAL","6","10","10","Dœ tœnœ ataa, œdœ a kœgbɔ awa tœ kœmbœrœ ɔtshɔrœ, a mbœrœ fœ azu para kɔkɔ. Kœropa nœ, a mbœrœ fœ aaya azœ dœ ayindœ Kristu. ");
INSERT INTO mnh_vpl VALUES ("GL6_11","078_6_11","GAL","6","11","11","'E wu ogboro mbetinœ asœke: mœ su fœ 'e dœ adja kane mœ! ");
INSERT INTO mnh_vpl VALUES ("GL6_12","078_6_12","GAL","6","12","12","Azu á endje sœ kœgbɔgbɔ 'e adœke endje wa 'e tœ gaza asœmœ, endje kœdœ azu á endje sœ kœpu awa adœke œne matœ œne ɓata ɔtshɔ azu lœ ɔkɔ. Endje mbœrœ ataa adœke azu kœmbœmbœrœ œrœ kanga ga tœ œne lœ kumu kœyisœ œrœ tœ upu nœ kuzu Kristu pa kurushi nene. ");
INSERT INTO mnh_vpl VALUES ("GL6_13","078_6_13","GAL","6","13","13","Œdœ ndje azunœ á endje wa endje tœ gaza asœmœ, endje lɨlɨ ndje sœ awa akwa nœ Ayudanœ nene. Kashe endje yindœ nœ adœke, endje wa 'e yekane á œne kœdonga tœ œne mbœrœ á 'e dji o'o ama œne. ");
INSERT INTO mnh_vpl VALUES ("GL6_14","078_6_14","GAL","6","14","14","Tœ mœ nœ mœ, mœ sœ kœdonga tœ mœ kolœ mbœrœ kuzu Gbozu nœ azœ dœ Yisu Kristu pa kurushi. Yé lœ awa nœ kurushi, œrœ tshapashɔnœ asœke wuta ɓata œrœ á tshu ye mbœrœ mœ yé œmœ ndje mœ wuta ɓata uzu á tshe tshu utshu œrœ kɔ pa ɔshɔnœ asœke. ");
INSERT INTO mnh_vpl VALUES ("GL6_15","078_6_15","GAL","6","15","15","Dœ tœnœ ataa, endje wa uzu too endje wawa uzu nene, œ gugu dœ ádá bale nene. Kashe œneke á ropa nœ kœdœ adœke, Ndjaba sœ kœmbœrœ azœ dœ atafo azu. ");
INSERT INTO mnh_vpl VALUES ("GL6_16","078_6_16","GAL","6","16","16","Kaka Ndjaba yisœ lɔsu kœwu oyo œdœ pe kœsœ gee nœ ye ga ndœ azu kɔ á endje za awa kœyisœrœnœ asœke, œdœ ndje ga pa adja azu nœ Ndjaba. ");
INSERT INTO mnh_vpl VALUES ("GL6_17","078_6_17","GAL","6","17","17","Kœto ngɔngɔ asœ, uzu bale kpa ndandanga mœ nene, gbambanœ nene, sherœwa á sœ tœ ɔkɔ mœ asœke, má adœke œmœ kœdœ uzu nœ Yisu. ");
INSERT INTO mnh_vpl VALUES ("GL6_18","078_6_18","GAL","6","18","18","Aaya mœ, kaka Gbozu nœ azœ dœ Yisu Kristu ma ɔtshɔ lɔsu nœ ye ga ndœ 'e. Ame.");
INSERT INTO mnh_vpl VALUES ("EP1_1","079_1_1","EPH","1","1","1","Œmœ Polo, ayi avwa nœ Yisu Kristu lindœ gbetshelœ nœ Ndjaba, mœ sœ kœsu mbetinœ asœke fœ 'e dœ ayerœ azu lakpɨ Efeze á 'e sœ dœ kœyindœrœ ga ndœ Yisu Kristu. ");
INSERT INTO mnh_vpl VALUES ("EP1_2","079_1_2","EPH","1","2","2","Kaka Aba azœ dœ Ndjaba, dœ Gbozu Yisu Kristu ma ɔtshɔ lɔsu nœ endje ga ndœ 'e yé œ za kœsœ gee fœ 'e. ");
INSERT INTO mnh_vpl VALUES ("EP1_3","079_1_3","EPH","1","3","3","Kaka a donga Ndjaba, Aba Gbozu nœ azœ dœ Yisu Kristu: Tshe to kane ye ga pa azœ lœ awa nœ Kristu á a ngbɔtœ azœ dœ she bale, yé á to ɔtshɔrœ nœ ɨshirɨ kɔ ɓa lafo fœ azœ. ");
INSERT INTO mnh_vpl VALUES ("EP1_4","079_1_4","EPH","1","4","4","Gbambanœ nene, Ndjaba ke lima azœ utshunœ adœke tshe mbœrœ tshapashɔnœ asœ, adœke a sœ yerœ yé œ sœsœ ndje dœ ekperœ teasho utshu ye nene. Lœ ayo nœ ye, ");
INSERT INTO mnh_vpl VALUES ("EP1_5","079_1_5","EPH","1","5","5","Ndjaba wa lima o'o utshunœ dœ tœ ye adœke a wuta agbolo nœ œne lœ awa nœ Kristu. Tshe yi lima ndœ kœmbœrœ œtœnœ ataa mbœrœ á ga tœ ala ye. ");
INSERT INTO mnh_vpl VALUES ("EP1_6","079_1_6","EPH","1","6","6","Ataa, a donga she mbœrœ ɔtshɔ lɔsu á tshe yisœ nœ fœ azœ lœ awa nœ Gbolo nœ ye á tshe yindœ ye waa asœmœ. ");
INSERT INTO mnh_vpl VALUES ("EP1_7","079_1_7","EPH","1","7","7","Gbambanœ nene, lœ awa indji Kristu Ndjaba vwara azœ lœ ngbɨndɨrœ, yé œ djerœndœ ekperœ nœ azœ liaka egerœ ɔtshɔ lɔsu nœ ye. ");
INSERT INTO mnh_vpl VALUES ("EP1_8","079_1_8","EPH","1","8","8","Tshe yisœ egerœ ɔtshɔ lɔsu nœ ye ga ndœ azœ ropa nœ ye, yé œ za awa tœ kœwusœtœ œdœ pe kœwusœrœ fœ azœ. ");
INSERT INTO mnh_vpl VALUES ("EP1_9","079_1_9","EPH","1","9","9","Tshe yisœ gbetshelœ nœ ye á tshe za yiwatœnœ adœke a wusœ nœ, gbetshelœ á tshe gbe lima katshatsha utshunœ ndœ kœza ga tœ akwa lœ awa nœ Kristu. ");
INSERT INTO mnh_vpl VALUES ("EP1_10","079_1_10","EPH","1","10","10","Œtœnœ, Ndjaba œ mbœrœ dœ lɔkɔ á tshapashɔ œ ka dœ tœnœ. Tshe ngbɔɓa œneke á sœ ɓa lafo dœ œnœ tshaatɨ adœke Kristu te Gbozu tshebabale panœ. ");
INSERT INTO mnh_vpl VALUES ("EP1_11","079_1_11","EPH","1","11","11","Lœ kœngbɔtœ nœ azœ dœ Kristu, a wuta ndje azu nœ Ndjaba. Gbambanœ nene, tshe ke lima azœ katshatsha utshunœ lindœ œneke á tshe guma; yé tshe sœ kœmbœrœ œrœ kɔ liaka œneke á tshe wa á ga tœ ala ye. ");
INSERT INTO mnh_vpl VALUES ("EP1_12","079_1_12","EPH","1","12","12","Atamœ, a donga she ɓata tshe sœ tœ egerœnœ, azœ á a dœ́ ali azu kœko lɔsu azœ ga tœ Kristu. ");
INSERT INTO mnh_vpl VALUES ("EP1_13","079_1_13","EPH","1","13","13","E'e ndje, lɔkɔ á 'e dji o'o tœ upu nœ adjapu, Ɔtshɔ O'o á za kœshe fœ 'e, 'e sœ dœ kœyindœrœ ga ndœ Kristu. Ataa, Ndjaba ta ambara nœ ye ga tœ 'e lœ awa nœ kœto Ɔtshɔ Ɨshirɨ á tshe pa lima tœnœ fœ 'e. ");
INSERT INTO mnh_vpl VALUES ("EP1_14","079_1_14","EPH","1","14","14","Yé Ɔtshɔ Ɨshirɨ kœdœ ndanga mbœrœ kœgbɔ ɔtshɔrœ á Ndjaba gumasœ nœ mbœrœ azu nœ ye. Œ sœ ataa œrrr bala dœ lɔkɔ á azu nœ Ndjaba œ gbɔ kœshe. Kaka a donga Ndjaba mbœrœ egerœ œrœ á tshe mbœrœ. ");
INSERT INTO mnh_vpl VALUES ("EP1_15","079_1_15","EPH","1","15","15","Wu mbœrœ tœnœ ataa, œmœ ndje, lɔkɔ á mœ djindœ kœyindœrœ nœ 'e ga ndœ Gbozu Yisu œdœ kœyindœsho nœ 'e ga tœ ayerœ azu kɔ, ");
INSERT INTO mnh_vpl VALUES ("EP1_16","079_1_16","EPH","1","16","16","mœ sœsœ kœkatœ kœgi mershe fœ Ndjaba mbœrœ 'e nene, mœ sœ kœgbe dœ 'e lœ avwala nœ mœ. ");
INSERT INTO mnh_vpl VALUES ("EP1_17","079_1_17","EPH","1","17","17","Mœ za avwala nœ mœ adœke, Ndjaba nœ Gbozu nœ azœ dœ Yisu Kristu á tshe dœ́ Aba nœ mokɔ, tshe za ɨshirɨ nœ kœwusœtœ fœ 'e, œ yisœ ye fœ 'e adœke 'e wusœ ye dœ ɔtshɔnœ. ");
INSERT INTO mnh_vpl VALUES ("EP1_18","079_1_18","EPH","1","18","18","Mœ kpa za avwala nœ mœ fœ she adœke tshe kɔrɔ tshalɔsu 'e adœke 'e wusœ œrœ á tshe e 'e mbœrœ tœnœ dœ ɔtshɔnœ, œdœ œneke á 'e li kœko lɔsu 'e ga pa nœ. Yé á 'e kpa kœwusœ ɔtshɔrœ ndjoro á ga waa á tshe gumasœ nœ kate ayerœ azu nœ ye asœmœ. ");
INSERT INTO mnh_vpl VALUES ("EP1_19","079_1_19","EPH","1","19","19","Mœ kpa za avwala nœ mœ adœke 'e wusœ gbɔgbɔ nœ ye á ropa œrœ kɔ á tshe za fœ azœ dœ ayindœ Ndjaba. Gbɔgbɔnœ asœmœ kœdœ œneke á Ndjaba ma dœ gbɔgbɔ kɔ. ");
INSERT INTO mnh_vpl VALUES ("EP1_20","079_1_20","EPH","1","20","20","Tshe za lima œtœnœ ga tœ akwa lɔkɔ á tshe she lima Kristu lœ akuzu, á za she ga pa kuni ye ɓa lafo. ");
INSERT INTO mnh_vpl VALUES ("EP1_21","079_1_21","EPH","1","21","21","Kristu sœ ga pa tshagbozu kɔ, ga pa awa kœmbœrœ œrœ, ga pa gbɔgbɔ kɔ, ga pa œrœ para kɔkɔ yé ga pa ɨ'ɨrɨ á ropa ɨ'ɨrɨ kɔkɔ, œdœ pa ɔshɔnœ asœke œdœ pa ɔshɔ á na manda nœ. ");
INSERT INTO mnh_vpl VALUES ("EP1_22","079_1_22","EPH","1","22","22","Ndjaba ko œrœ kɔ ga tshada Kristu, œ za she tɔ ga tœ kumu œrœ kɔ adœke tshe dœ kumu Ikrizia, ");
INSERT INTO mnh_vpl VALUES ("EP1_23","079_1_23","EPH","1","23","23","á dœ́ undu ye djigi, lœ Ikrizia, Kristu sœ djigi zœ, œshe á tshe sœ ndje djigi tœ osho kɔ. ");
INSERT INTO mnh_vpl VALUES ("EP2_1","079_2_1","EPH","2","1","1","Lima utshunœ, 'e lœ ɓata azu á endje tshu lima mbœrœ ngbɨndɨrœ œdœ ekperœ nœ 'e. ");
INSERT INTO mnh_vpl VALUES ("EP2_2","079_2_2","EPH","2","2","2","'E sœ lima kœmbœrœtœ 'e lindœ mara azu tshapashɔ asœke. 'E sœ lima kœmbœrœtœ 'e lindœ o'o gbozu nœ gbɔgbɔ nœ aekpe ɨshirɨ lœ ɨzɨ, ekpe ɨshirɨ á tshe sœ kœmbœrœ akwa ngɔngɔ asœke lœ ayingba Ndjaba. ");
INSERT INTO mnh_vpl VALUES ("EP2_3","079_2_3","EPH","2","3","3","Azœ para kɔkɔ, 'a sœ lima ɓata endje. A sœ lima kœmbœrœtœ azœ lindœ mara nœ azœ dœ tœ azœ, a sœ lima kœmbœrœ œneke á undu azœ œdœ lɔsu azœ yindœ nœ. Adjapu, a sœ lima ɓata azu kɔ, mara kœmbœrœtœ nœ azœ sœ lima kœza ókó nœ Ndjaba ga pa azœ. ");
INSERT INTO mnh_vpl VALUES ("EP2_4","079_2_4","EPH","2","4","4","Kashe Ndjaba wu oyo azœ waa, yé œ yi ndje ndœ azœ tɔpanœ kpuru. ");
INSERT INTO mnh_vpl VALUES ("EP2_5","079_2_5","EPH","2","5","5","Gbambanœ nene, a sœ lima ɓata azu á endje tshu mbœrœ ekperœ nœ azœ, tshe za soro fœ azœ dœ awa nœ kœngbɔtœ azœ dœ Kristu. Adja 'e she mbœrœ ɔtshɔ lɔsu nœ Ndjaba. ");
INSERT INTO mnh_vpl VALUES ("EP2_6","079_2_6","EPH","2","6","6","Lœ kœngbɔtœ azœ dœ Yisu Kristu, Ndjaba she azœ lœ kuzu, yé œ guma ɔtshɔ osho kœsœ fœ azœ ɓa lafo. ");
INSERT INTO mnh_vpl VALUES ("EP2_7","079_2_7","EPH","2","7","7","Tshe ma ayo nœ ye ga ndœ azœ lœ awa nœ Yisu Kristu, tshe mbœrœ lima kɔ adœke azu kœwu ɔtshɔ lɔsu nœ ye á dopa nœ asœmœ manda osho á na manda œneke asœke. ");
INSERT INTO mnh_vpl VALUES ("EP2_8","079_2_8","EPH","2","8","8","Yé mbœrœ ɔtshɔ lɔsu nœ Ndjaba dá 'e she lœ awa nœ kœyindœrœ. Œ toto lœ gbɔgbɔ nœ 'e nene kashe tœnœ kœdœ œrœ á Ndjaba to fœ 'e gbambanœ. ");
INSERT INTO mnh_vpl VALUES ("EP2_9","079_2_9","EPH","2","9","9","Œ toto lœ akwa nœ 'e yekane á uzu kœdu okoro ye mbœrœ tœnœ nene. ");
INSERT INTO mnh_vpl VALUES ("EP2_10","079_2_10","EPH","2","10","10","Gbambanœ nene, Ndjaba dá mbœrœ azœ ataa. Tshe mbœrœ azœ lima lœ kœngbɔtœ azœ bale dœ Yisu Kristu adœke a mbœrœ ɔtshɔ akwa á tshe guma lima katshatsha adœke a zatœ azœ ndœ nœ. ");
INSERT INTO mnh_vpl VALUES ("EP2_11","079_2_11","EPH","2","11","11","'E gbe dœ mara á 'e sœ lima dœ tœnœ utshunœ. Ayuda pa lima adœke 'e dœ́dœ́ azu nœ Ndjaba nene, mbœrœ á 'e wawa gaza nene. Kolœ endje dá dœ lima azu nœ Ndjaba mbœrœ á endje wa gaza nœ ɔkɔ. ");
INSERT INTO mnh_vpl VALUES ("EP2_12","079_2_12","EPH","2","12","12","'E wusœ nœ adœke dœ lɔkɔnœ asœmœ, 'e wuwu lima damba sœ Kristu nene; 'e dœ́dœ́ ndje lima azu Israyele nene. 'E dœ́dœ́ lima azu á endje li kœgbɔ œrœ tshangba madu á Ndjaba lu nene. 'E gugu lima dœ œrœ kœko lɔsu 'e ga pa nœ pa ɔshɔ nene, yé 'e wuwu lima ndje sœ Ndjaba nene. ");
INSERT INTO mnh_vpl VALUES ("EP2_13","079_2_13","EPH","2","13","13","Kashe ngɔngɔ asœke, e'e á 'e sœ lima lœ ɨngɨrɨnœ tœ Ndjaba, 'e wuta ndoo dœ she lœ kœngbɔtœ 'e bale dœ Yisu Kristu mbœrœ indji ye á tu lima mbœrœ 'e. ");
INSERT INTO mnh_vpl VALUES ("EP2_14","079_2_14","EPH","2","14","14","Gbambanœ nene, œshe dá dœ kœsœ gee nœ azœ, œshe dá mbœrœ adœke Ayuda œdœ pe angbɨ azu wuta uzu bale. Lœ kœza undu ye fœ kuzu, tshe ndjɔtshœlœ muru nœ kœyiangbatœsho á kuru lima tshagurutœ azu. ");
INSERT INTO mnh_vpl VALUES ("EP2_15","079_2_15","EPH","2","15","15","Tshe wo awa akwa œdœ pe awa o'onœ dœ œrœ kɔ á yindœ nœ adœke endje mbœrœ. Tshe ngboɓa endje ga tœnœ bale dœ angbɨ azu adœke endje wuta tafo azu lœ kœngbɔtœsho dœ she; dœ mara ataa dá tshe za kœsœ gee ga ugurutœ endje. ");
INSERT INTO mnh_vpl VALUES ("EP2_16","079_2_16","EPH","2","16","16","Yé dœ awa kuzu nœ ye pa kurushi, tshe ndɨ tshelœ kœtshene osho ugurutœ endje bibisha, œ guma tshagurutœ Ndjaba dœ endje mbœrœ adœke endje wuta uzu bale. ");
INSERT INTO mnh_vpl VALUES ("EP2_17","079_2_17","EPH","2","17","17","Tshe na kœmɨndœ kœsœ gee fœ azu á endje sœ lœ ɨngɨrɨnœ dœ Ndjaba œdœ pe ndje endjeneke á endje lœ ndoo dœ Ndjaba. ");
INSERT INTO mnh_vpl VALUES ("EP2_18","079_2_18","EPH","2","18","18","Yé mbœrœ Kristu, azœ dœ Ayuda dœ pe angbɨ azu, a gbɔ awa nœ kœli ga ndœ Aba dœ awa nœ Ɨshirɨ bale. ");
INSERT INTO mnh_vpl VALUES ("EP2_19","079_2_19","EPH","2","19","19","Ataa, e'e dœ azu á 'e dœ́dœ́ Ayuda nene, 'e kpa dœ́dœ́ angbɨ azu nene, 'e dœ́dœ́ ndje agene nene; kashe 'e kœdœ azu bɨngɨ nœ Ndjaba. 'E wuta agbolo ogo awa bale dœ azu nœ Ndjaba. ");
INSERT INTO mnh_vpl VALUES ("EP2_20","079_2_20","EPH","2","20","20","E'e œdœ endje kɔ 'e sœ ɓata badja á Ndjaba sœ kœmɔ dœ anda nœ ye. Aayi avwa œdœ pe aayi kœgbara o'o kœdœ kitinœ yeka á Kristu kœdœ egerœ badja neke á tepa andanœ djigi. ");
INSERT INTO mnh_vpl VALUES ("EP2_21","079_2_21","EPH","2","21","21","Œshe dá sœ kœto gbɔgbɔ fœ anda djigi yé á sœ kœtɨ tœnœ adœke œ gerœ yé œ fa œyerœ Tepelo nœ Gbozu. ");
INSERT INTO mnh_vpl VALUES ("EP2_22","079_2_22","EPH","2","22","22","Lœ kœngbɔtœ 'e bale dœ Kristu, e'e ndje 'e sœ lœ kœmɔ anda mbœrœ kœwuta dœ anga azu kɔ, anda nœ Ndjaba lœ awa nœ Ɨshirɨ. ");
INSERT INTO mnh_vpl VALUES ("EP3_1","079_3_1","EPH","3","1","1","Mbœrœ tœnœ ataa, œmœ Polo, mœ wuta ayi kánga ndœ akwa nœ Yisu Kristu mbœrœ e'e dœ angbɨ azu. ");
INSERT INTO mnh_vpl VALUES ("EP3_2","079_3_2","EPH","3","2","2","Adjapu, 'e djindœ o'o tœ upu nœ ɔtshɔ lɔsu á Ndjaba ma fœ mœ mbœrœ kœmbœrœ dœ akwa nœ ye mbœrœ 'e. ");
INSERT INTO mnh_vpl VALUES ("EP3_3","079_3_3","EPH","3","3","3","Ndjaba dœ tœ ye dá yisœ gbetshelœ á tshe za lima yiwa tœnœ fœ mœ, yeka á mœ su dœ aya mbetinœ asœke. ");
INSERT INTO mnh_vpl VALUES ("EP3_4","079_3_4","EPH","3","4","4","Yé 'e kœsœ kœdɨ mbetinœ asœke dá 'e wusœ mara á mœ wusœ gbetshelœnœ á zatœ ye yiwa tœnœ asœmœ tœ upu nœ Kristu. ");
INSERT INTO mnh_vpl VALUES ("EP3_5","079_3_5","EPH","3","5","5","Lima utshunœ, Ndjaba mama gbetshelœnœ fœ azu nene. Kashe ngɔngɔ asœke, Ɔtshɔ Ɨshirɨ nœ ye pandœ nœ ngbɨ fœ œyerœ aayi avwa œdœ aayi kœgbara o'o. ");
INSERT INTO mnh_vpl VALUES ("EP3_6","079_3_6","EPH","3","6","6","Gbetshelœnœ asœmœ kœdœ adœke, angbɨ azu li ndje kœgbɔ ɔtshɔrœ á Ndjaba guma fœ azu nœ ye dœ awa nœ kœyindœ Ɔtshɔ O'o awa bale dœ Ayuda. Endje wuta uzu bale yé Ndjaba œ to œrœ á tshe pa lima tœnœ fœ endje kɔ. ");
INSERT INTO mnh_vpl VALUES ("EP3_7","079_3_7","EPH","3","7","7","Mœ te ayi akwa kœyisœ Ɔtshɔ O'onœ asœ mbœrœ ɔtshɔ lɔsu nœ Ndjaba œdœ pe gbɔgbɔnœ á tshe za lima fœ mœ. ");
INSERT INTO mnh_vpl VALUES ("EP3_8","079_3_8","EPH","3","8","8","Œmœ kœdœ ndɔngɔlɔ uzu ugurutœ ayerœ azu nœ Ndjaba para kɔkɔ. Ngɔngɔ asœke, Ndjaba má ɔtshɔ lɔsu ga ndœ mœ adœke mœ yisœ dili kœgbɔrœ nœ Kristu fœ angbɨ azu. ");
INSERT INTO mnh_vpl VALUES ("EP3_9","079_3_9","EPH","3","9","9","Ndjaba á tshe mbœrœ œrœ kɔ za lima o'onœ asœ yiwa tœnœ katshatsha, yé ngɔngɔ asœke tshe za mœ adœke mœ kœyisœ nœ fœ azu kɔ adœke endje wusœ œneke á tshe yindœ kœmbœrœ tœnœ. ");
INSERT INTO mnh_vpl VALUES ("EP3_10","079_3_10","EPH","3","10","10","Atamœ, lœ mara akwa á Ikrizia sœ kœmbœrœ tœnœ ngɔngɔnœ asœke, tshagbozu œdœ pe gbɔgbɔ ɓa lafo wusœ egerœ kœwusœtœ nœ Ndjaba lœ aka œrœ kɔ. ");
INSERT INTO mnh_vpl VALUES ("EP3_11","079_3_11","EPH","3","11","11","Ndjaba mbœrœ adja liaka œneke á tshe gbe lima ndœ kœmbœrœ tœ nœ lœ awa nœ Gbozu nœ azœ dœ Yisu Kristu. ");
INSERT INTO mnh_vpl VALUES ("EP3_12","079_3_12","EPH","3","12","12","Mbœrœ kœyindœrœ ga ndœ Kristu, a ngbɔtœ azœ bale dœ she yé a li kœna ga utshu Ndjaba dœ lɔsu zɨtɨ. ");
INSERT INTO mnh_vpl VALUES ("EP3_13","079_3_13","EPH","3","13","13","Mbœrœ tœnœ ataa, mœ kɨ fœ 'e adœke 'e mɔmɔ lœ ɔkɔ 'e mbœrœ egerœ oyo á mœ sœ kœwu mbœrœ 'e nene. Œ sœ mbœrœ ɔtshɔrœ nœ 'e. ");
INSERT INTO mnh_vpl VALUES ("EP3_14","079_3_14","EPH","3","14","14","Mbœrœ tœnœ ataa, mœ gote dœ koda mœ ɓa utshu Ndjaba Aba, ");
INSERT INTO mnh_vpl VALUES ("EP3_15","079_3_15","EPH","3","15","15","á mbœrœ she dá bɨngɨ kɔ, œdœ ɓa lafo œdœ ɓa pa ɔshɔ gbɔ ɨ'ɨrɨ ye. ");
INSERT INTO mnh_vpl VALUES ("EP3_16","079_3_16","EPH","3","16","16","Lindœ kœgbɔrœ nœ mokɔ nœ ye, mœ yindœ nœ adœke tshe to gbɔgbɔ ga lœ 'e dœ awa nœ Ɨshirɨ nœ ye yeka á 'e kœwuta agbozu lœ kœyindœrœ. ");
INSERT INTO mnh_vpl VALUES ("EP3_17","079_3_17","EPH","3","17","17","Yé dœ tœnœ ataa á Kristu kœsœ tœ lɔsu 'e lœ awa nœ kœyindœrœ. Mœ yindœ nœ adœke 'e ka ngbɨrɨ yé œ shi gbɨ lœ kœyindœsho. ");
INSERT INTO mnh_vpl VALUES ("EP3_18","079_3_18","EPH","3","18","18","Atamœ, e'e œdœ ayerœ azu para kɔkɔ, 'e sœ dœ gbɔgbɔ kœwusœ kœyindœsho nœ Kristu á ropa nœ yé á gugu dœ ndɔngɔlɔnœ nene; ");
INSERT INTO mnh_vpl VALUES ("EP3_19","079_3_19","EPH","3","19","19","œ ro ndje sœ kœwusœrœ djigi. Œrœ á mœ eosho ndœ nœ ga ndœ 'e kœdœ adœke 'e su dœ gbɔgbɔ nœ Ndjaba. ");
INSERT INTO mnh_vpl VALUES ("EP3_20","079_3_20","EPH","3","20","20","Ndjaba li kœmbœrœ œrœ kœropa œneke á a gbe dœ tœnœ. Tshe mbœrœ œrœ kɔ dœ gbɔgbɔ á sœ kœmbœrœ akwa lœ azœ. ");
INSERT INTO mnh_vpl VALUES ("EP3_21","079_3_21","EPH","3","21","21","Kaka mokɔ nœ Ndjaba matœ ye ugurutœ azu Ikrizia, œ ma ndje tœ ye dœ awa nœ Yisu Kristu manda ngbugu dœ ngbugu. Ame! ");
INSERT INTO mnh_vpl VALUES ("EP4_1","079_4_1","EPH","4","1","1","Mbœrœ tœnœ ataa, œmœ á mœ te kanga mbœrœ kœmbœrœ akwa nœ Gbozu, mœ yindœ nœ adœke 'e mbœrœtœ 'e liaka mara á Ndjaba yindœ nœ. ");
INSERT INTO mnh_vpl VALUES ("EP4_2","079_4_2","EPH","4","2","2","'E zatœ 'e ga atɨ, dœ lɔsu 'e zɨtɨ œdœ ndje pe dœ ugu lɔsu. 'E sœ dœ kœru lɔsu ga tœ anga 'e yé œ mbœrœ akwa dœ kœyindœsho. ");
INSERT INTO mnh_vpl VALUES ("EP4_3","079_4_3","EPH","4","3","3","'E pa avwara kœgbɔndœ kœngbɔtœsho bale á Ɔtshɔ Ɨshirɨ to lœ awa nœ kœsœ gee. ");
INSERT INTO mnh_vpl VALUES ("EP4_4","079_4_4","EPH","4","4","4","Azu nœ Kristu sœ kolœ undu bale, yé Ɔtshɔ Ɨshirɨ sœ ndje bale, awa bale Ndjaba e azœ adœke a ko lɔsu azœ bale. ");
INSERT INTO mnh_vpl VALUES ("EP4_5","079_4_5","EPH","4","5","5","Gbozu sœ bale, kœyindœrœ sœ bale, batisimu sœ ndje bale. ");
INSERT INTO mnh_vpl VALUES ("EP4_6","079_4_6","EPH","4","6","6","Ndjaba sœ bale. Tshe kœdœ Aba azœ kɔ, tshe sœ kœmbœrœ akwa lœ azœ kɔ yé œ sœ ndje lœ azu kɔ. ");
INSERT INTO mnh_vpl VALUES ("EP4_7","079_4_7","EPH","4","7","7","Andaa, gbɔgbɔ nœ kœmbœrœ dœ akwa á a gbɔ sœsœ awa bale nene. A gbɔ liaka œneke á Kristu yindœ kœto fœ uzu dœ uzu. ");
INSERT INTO mnh_vpl VALUES ("EP4_8","079_4_8","EPH","4","8","8","Œ sœ liaka œneke á endje sú ala Buku nœ Ndjaba adœke: «Lɔkɔ á tshe ɔ lima ga lafo, tshe tepa akanga, tshe to gbɔgbɔ kœmbœrœ dœ akwa fœ azu.» ");
INSERT INTO mnh_vpl VALUES ("EP4_9","079_4_9","EPH","4","9","9","Tshe ɔ lima ga lafo! Œ yindœ kœpa kotoo? Œ má ndje adœke Kristu jerœ ga atɨ ɓa budu ɔshɔ a? ");
INSERT INTO mnh_vpl VALUES ("EP4_10","079_4_10","EPH","4","10","10","Uzu á tshe jerœ lima, œshe ndje kœdœ uzu á tshe ɔ waa kœropa tshalafo djigi adœke tshe su tshelœ osho kɔ. ");
INSERT INTO mnh_vpl VALUES ("EP4_11","079_4_11","EPH","4","11","11","Œshe dá kurutshelœ gbɔgbɔ kœmbœrœ dœ akwa fœ azu. Tshe ko anga azu kœsœ dœ aayi avwa, anga azu tœ aayi kœgbara o'o, anga azu tœ aayi kœmɨndœ Ɔtshɔ O'o, anga azu tœ aayi kœgbɔndœ Ikrizia, anga azu tœ aayi kœyisœrœ. ");
INSERT INTO mnh_vpl VALUES ("EP4_12","079_4_12","EPH","4","12","12","Tshe mbœrœ kɔ atamœ mbœrœ kœguma azu nœ Ndjaba adœke endje mbœrœ akwa nœ ye dœ mara adœke endje mɔ undu Kristu, ");
INSERT INTO mnh_vpl VALUES ("EP4_13","079_4_13","EPH","4","13","13","œrrr ga tœ adœke a wuta kɔ dœ kœyindœrœ bale yé a wusœ Gbolo nœ Ndjaba. Ataa, a te agbɔ azu yé œ wuta adja ɓata Kristu. ");
INSERT INTO mnh_vpl VALUES ("EP4_14","079_4_14","EPH","4","14","14","Dœ mara atamœ, a kpa dœ́dœ́ aya agbolo á endje yaka kumu endje dœ tshelœ aka kœyisœrœ kɔ nene. Aayi kœbɨlɨ osho œ ko ndje azœ lœ gbanda nœ endje dœ o'o lɨma nœ endje nene. A kpa za awa aayi djingili yeka á endje kœgaga kumu azœ dœ kœyisœrœ wala nœ endje nene. ");
INSERT INTO mnh_vpl VALUES ("EP4_15","079_4_15","EPH","4","15","15","Kashe œdœ a kœsœ kœpa adja o'o lœ kœyindœsho, a gerœ bala lœ œrœ kɔ ga ndœ Kristu á tshe dœ́ kumu Ikrizia. ");
INSERT INTO mnh_vpl VALUES ("EP4_16","079_4_16","EPH","4","16","16","Yé œshe dá ngbɔɓa œrœ kɔ á sœ tœ undu ye ga tœnœ bale. Œdœ œrœ bale dœ bale á sœ tœ undu ye kœmbœrœ akwa nœ ye dœ kœyindœrœ dœ ɔtshɔnœ, undu djigi œ gerœ dœ ɔtshɔnœ yé œ gerœ lœ kœyindœsho. ");
INSERT INTO mnh_vpl VALUES ("EP4_17","079_4_17","EPH","4","17","17","'E wu œneke á mœ sœ kœyu 'e kpalakpala tœnœ dœ ɨ'ɨrɨ Gbozu: 'e katœ ongboro kœmbœrœtœ 'e ɓata azu á endje wuwusœ Ndjaba nene, á kœwusœrœ nœ endje fu ye. ");
INSERT INTO mnh_vpl VALUES ("EP4_18","079_4_18","EPH","4","18","18","Ubu osho ndɨ tshelœ gbetshelœ nœ endje, yé endje wuwusœ soro á Ndjaba za fœ azu nene lœ kumu kœwusœrœ nene œdœ lœ kumu ɔgbɔ lɔsu nœ endje. ");
INSERT INTO mnh_vpl VALUES ("EP4_19","079_4_19","EPH","4","19","19","Endje kpa gugu dœ tshula nene; endje zatœ endje kɔ ndœ kœmbœrœ angba budu yé œ kaka ndje tœ kœmbœrœ anga angbɨ œrœ tshula nene. ");
INSERT INTO mnh_vpl VALUES ("EP4_20","079_4_20","EPH","4","20","20","Mbœrœ e'e nœ 'e, œ dœ́dœ́ mara á endje yisœ o'o tœ upu nœ Kristu fœ 'e dœmœ nene. ");
INSERT INTO mnh_vpl VALUES ("EP4_21","079_4_21","EPH","4","21","21","Œdœ o'o á 'e dji lima kœsœ adja tœ upu nœ ye, œdœ endje kœyi lima sœ ye fœ 'e kœli dœ adja o'o á dœ Kristu, ");
INSERT INTO mnh_vpl VALUES ("EP4_22","079_4_22","EPH","4","22","22","'e katœ ongboro kœmbœrœtœ 'e lima utshunœ, œtœnœ á ogo kœmbœrœ œrœ œ vwa osho ga lœ kuzu. ");
INSERT INTO mnh_vpl VALUES ("EP4_23","079_4_23","EPH","4","23","23","Œ li adœke Ɨshirɨ nœ Ndjaba fa lɔsu 'e dœ pe ɨshirɨ 'e adœke 'e wuta atafo azu. ");
INSERT INTO mnh_vpl VALUES ("EP4_24","079_4_24","EPH","4","24","24","'E za angwa kœmbœrœ œrœ nœ atafo azu, mbœrœ 'e te atafo azu á Ndjaba mbœrœ endje liaka angwa ye dœ tœ ye lœ œrœ á sœ ndjii œdœ yerœ, á to lœ adja o'o. ");
INSERT INTO mnh_vpl VALUES ("EP4_25","079_4_25","EPH","4","25","25","Mbœrœ tœnœ ataa, 'e katœ wala ye. Uzu dœ uzu pa adja o'o fœ yanganœ; gbambanœ nene, azœ para kɔkɔ a wuta œrœ kote undu uzu bale. ");
INSERT INTO mnh_vpl VALUES ("EP4_26","079_4_26","EPH","4","26","26","Œdœ 'e kœsœ dœ ókó, 'e mbœmbœrœ ekperœ nene. 'E gbɔgbɔndœ nœ œrrr adœke ɔlɔ li tœnœ nene. ");
INSERT INTO mnh_vpl VALUES ("EP4_27","079_4_27","EPH","4","27","27","'E zaza awa fœ djaboro bale nene. ");
INSERT INTO mnh_vpl VALUES ("EP4_28","079_4_28","EPH","4","28","28","Uzu á tshe sœ lima kœzɨ angba, kpa zɨzɨ angba nene, kashe œ li dœ she kœmbœrœ akwa dœ kane ye yeka á kœgbɔ œrœ tshangba nœ, yekane á tshe kœto ndje anganœ fœ aayi oyo. ");
INSERT INTO mnh_vpl VALUES ("EP4_29","079_4_29","EPH","4","29","29","Kaka adœke ekpe o'o bale wuwuta lœ ama 'e nene. Kashe œdœ o'o kœsœ zœ, œ li dœ 'e kœpa o'o á li kœguma azu yé á to ɔtshɔ lɔsu fœ endjeneke á endje sœ kœdji tœnœ. ");
INSERT INTO mnh_vpl VALUES ("EP4_30","079_4_30","EPH","4","30","30","'E mbœmbœrœ adœke Ɔtshɔ Ɨshirɨ nœ Ndjaba sœ dœ oyo nene. Gbambanœ nene, œshe kœdœ ambara á Ndjaba ta ga tœ 'e mbœrœ olo á tshe she bala 'e lœ ekperœ djigi. ");
INSERT INTO mnh_vpl VALUES ("EP4_31","079_4_31","EPH","4","31","31","'E katœ ushu lɔsu, kœyi uzu ga lœ ókó, kœsœ dœ ókó, kœpa o'o dœ ɔgbɔ tshama œdœ kœgu osho ye. 'E katœ kœmbœrœ œrœnœ asœmœ kɔ ye. ");
INSERT INTO mnh_vpl VALUES ("EP4_32","079_4_32","EPH","4","32","32","'E sœ dœ ɔtshɔ lɔsu yé œ yindœtœ 'e ugurutœ 'e, 'e wu oyo ekperœ nœ anga 'e ɓata á Ndjaba wu lima oyo 'e lœ awa nœ Kristu. ");
INSERT INTO mnh_vpl VALUES ("EP5_1","079_5_1","EPH","5","1","1","E'e kœdœ agbolo á Ndjaba yindœ 'e waa. Mbœrœ tœnœ ataa, œ li adœke 'e mbœrœtœ 'e ɓata she. ");
INSERT INTO mnh_vpl VALUES ("EP5_2","079_5_2","EPH","5","2","2","'E yindœtœ 'e ɓata á Kristu yi lima ndœ azœ, yé á za lima tœ ye fœ kuzu mbœrœ azœ ɓata makabo œdœ ɓata tokóró á endje zo á tshafunœ ga waa tœ Ndjaba. ");
INSERT INTO mnh_vpl VALUES ("EP5_3","079_5_3","EPH","5","3","3","E'e kœdœ ayerœ azu nœ Ndjaba, 'e katœ kœmbœrœ angba budu, kœsœ dœ egerœ lɔsu, kœmbœrœ œrœ tshula œdœ pe kœsœ dœ ogo ukpulu œrœ. ");
INSERT INTO mnh_vpl VALUES ("EP5_4","079_5_4","EPH","5","4","4","Œ lili ndje dœ 'e kœpa o'o nœ egerœ kumu nene, kœpa o'o ngbɨlɨngbɨlɨ ɓata agbakɨndɨ azu nene. Œ li dœ 'e kœza mershe fœ Ndjaba. ");
INSERT INTO mnh_vpl VALUES ("EP5_5","079_5_5","EPH","5","5","5","'E wusœ nœ adœke ayi angba budu, dœ ayi ngbɨndɨrœ dœ pe ayi kœgbɔtœ œrœ nœ anga endje asœmœ – ayi kœdonga andjaba – endje gbɔ œrœ ɓa lœ ogo nœ Kristu œdœ œnœ Ndjaba nene. ");
INSERT INTO mnh_vpl VALUES ("EP5_6","079_5_6","EPH","5","6","6","Anga uzu bale bɨbɨlɨ 'e dœ gbetshelœ nœ afara nene. Tœnœ dá sœ kœgbota ókó nœ Ndjaba ga pa azu á endje djidji she nene. ");
INSERT INTO mnh_vpl VALUES ("EP5_7","079_5_7","EPH","5","7","7","'E ngbɔngbɔtœ 'e dœ endje lœ ekperœnœ á endje mbœrœ asœmœ nene. ");
INSERT INTO mnh_vpl VALUES ("EP5_8","079_5_8","EPH","5","8","8","'E lœ lima utshunœ lœ ubu osho, ngɔngɔ asœke 'e ngbɔtœ 'e bale dœ Gbozu, yé 'e wuta azu nœ ɨngbɨsho. ");
INSERT INTO mnh_vpl VALUES ("EP5_9","079_5_9","EPH","5","9","9","Gbambanœ nene, azu nœ ɨngbɨsho mbœrœ kolœ ɔtshɔrœ, œrœ á sœ ndjii œdœ pe ndje adja o'o. ");
INSERT INTO mnh_vpl VALUES ("EP5_10","079_5_10","EPH","5","10","10","'E pa avwara kœwusœ œrœ œneke á ga tœ Gbozu. ");
INSERT INTO mnh_vpl VALUES ("EP5_11","079_5_11","EPH","5","11","11","'E ngbɔngbɔtœ 'e nene dœ azu nœ ubu osho á endje mbœrœ œrœ á ádánœ gugu nene asœmœ. Kashe 'e gbara ekperœ nœ endje á endje mbœrœ ngbɨ ga ushu. ");
INSERT INTO mnh_vpl VALUES ("EP5_12","079_5_12","EPH","5","12","12","Œrœ á endje mbœrœ yaa lœ ubunœ, œ sœ tshula tœ kœpa tœnœ. ");
INSERT INTO mnh_vpl VALUES ("EP5_13","079_5_13","EPH","5","13","13","Kashe 'e dœ azu nœ ɨngbɨsho, œ li dœ 'e kœpa tœnœ ga utshu azu. ");
INSERT INTO mnh_vpl VALUES ("EP5_14","079_5_14","EPH","5","14","14","Gbambanœ nene, œrœ kɔ á sœ tœ ɨngbɨsho wuta ɨngbɨsho. Mbœrœ tœnœ ataa dá endje pa adœke: «Œɓœ á ɓœ sœ tœ lo, jo ga lafo, yé œ she ugurutœ akuzu, yeka ɨshirɨ nœ Kristu kœma ɓœ ngbɨ ga ushu.» ");
INSERT INTO mnh_vpl VALUES ("EP5_15","079_5_15","EPH","5","15","15","Ala 'e gbɔ tœ ɔtshɔ 'e. Adja 'e mbœmbœrœtœ 'e ɓata aayi ɨndɨ nene kashe 'e mbœrœtœ 'e ɓata azu nœ kœwusœtœ. ");
INSERT INTO mnh_vpl VALUES ("EP5_16","079_5_16","EPH","5","16","16","'E gbɔgbɔtœ 'e kœmbœrœ ɔtshɔrœ; gbambanœ nene, olo á a sœ lœnœ asœ sœ tœ ekpenœ. ");
INSERT INTO mnh_vpl VALUES ("EP5_17","079_5_17","EPH","5","17","17","Ataa, 'e dœ́dœ́ aayi ɨndɨ nene, kashe 'e para awa kœwusœ œrœ á Gbozu yindœ nœ. ");
INSERT INTO mnh_vpl VALUES ("EP5_18","079_5_18","EPH","5","18","18","'E ndjondjo ipi adœke œ mbœrœ 'e nene. Ete nene 'e li ga lœ djingili, kashe 'e su dœ Ɔtshɔ Ɨshirɨ. ");
INSERT INTO mnh_vpl VALUES ("EP5_19","079_5_19","EPH","5","19","19","'E to gbɔgbɔ lœ tœ 'e dœ tshelœ aka itshi kɔ œdœ anganœ á Ɔtshɔ Ɨshirɨ yisœ nœ; 'e ɓi itshi yé œ donga Gbozu dœ lɔsu 'e djigi. ");
INSERT INTO mnh_vpl VALUES ("EP5_20","079_5_20","EPH","5","20","20","'E gi mershe fœ Ndjaba Aba dœ ɨ'ɨrɨ Gbozu nœ azœ dœ Yisu Kristu dœ ɔlɔ kɔ œdœ mbœrœ œrœ kɔ. ");
INSERT INTO mnh_vpl VALUES ("EP5_21","079_5_21","EPH","5","21","21","'E dœ azu á 'e sœ kœkpawa Kristu, 'e lɨsœtœ 'e ugurutœ 'e dœ tœ 'e. ");
INSERT INTO mnh_vpl VALUES ("EP5_22","079_5_22","EPH","5","22","22","E'e dœ ayashe, 'e lɨsœ aakɔ 'e ɓata á 'e lɨsœ Kristu. ");
INSERT INTO mnh_vpl VALUES ("EP5_23","079_5_23","EPH","5","23","23","Gbambanœ nene, yakoshe kœdœ gbozu tshapa yashe ɓata á Kristu dœ ndje gbozu tshapa Ikrizia. Dœ mara ataa, Kristu kœdœ ayi kœshe Ikrizia á dœ undu ye dœ tœ ye. ");
INSERT INTO mnh_vpl VALUES ("EP5_24","079_5_24","EPH","5","24","24","Ataa, œ li dœ ayashe kœlɨsœ aakɔ endje lœ œrœ para kɔkɔ ɓata Ikrizia œ lɨsœ Kristu. ");
INSERT INTO mnh_vpl VALUES ("EP5_25","079_5_25","EPH","5","25","25","E'e dœ ayakoshe, 'e yindœ awo 'e ɓata Kristu yi lima ndœ Ikrizia yé á zatœ ye fœ kuzu mbœrœ tœnœ. ");
INSERT INTO mnh_vpl VALUES ("EP5_26","079_5_26","EPH","5","26","26","Tshe djutɔ Ikrizia dœ ungu batisimu œdœ pe o'o ama Ndjaba adœke Ikrizia wuta yerœ. ");
INSERT INTO mnh_vpl VALUES ("EP5_27","079_5_27","EPH","5","27","27","Tshe yindœ nœ adœke œ wuta tœ ala ye ɓata ɔtshɔ yashe á œsœ́ ye lɨ. Tshe yindœ nœ adœke Ikrizia wuta adja yerœ yé œ sœ dœ ekpenœ bale nene. ");
INSERT INTO mnh_vpl VALUES ("EP5_28","079_5_28","EPH","5","28","28","Dœ mara ataa, œ li adœke ayakoshe yindœ aawo endje ɓata á endje yindœ undu endje dœ tœ endje. Uzu á tshe yindœ awonœ, yindœtœ ye dœ tœ ye. ");
INSERT INTO mnh_vpl VALUES ("EP5_29","079_5_29","EPH","5","29","29","Œ dœ adjapu adœke uzu bale lili kœtshene undu ye dœ tœ ye nene. Kashe tshe to rœgo fœ undu ye, œ gbɔndœ nœ ɓata á Kristu œ mbœrœ dœ Ikrizia. ");
INSERT INTO mnh_vpl VALUES ("EP5_30","079_5_30","EPH","5","30","30","Gbambanœ nene, azœ kœdœ œrœ kote ye. ");
INSERT INTO mnh_vpl VALUES ("EP5_31","079_5_31","EPH","5","31","31","Endje su adœke: «Mbœrœ tœnœ ataa, yakoshe œ katœ abanœ dœ ayinœ tɨ, œ ngbɔtœ ye dœ awonœ, yé endje bibisha kɔ œ wuta uzu bale.» ");
INSERT INTO mnh_vpl VALUES ("EP5_32","079_5_32","EPH","5","32","32","Adja o'onœ asœ sœ tœ egerœnœ: œmœ, mœ pa fœ 'e ngbɨ adœke œ sœ tœ upu nœ Kristu œdœ pe Ikrizia. ");
INSERT INTO mnh_vpl VALUES ("EP5_33","079_5_33","EPH","5","33","33","Kashe œ wu ndje 'e: Œ li dœ yakoshe bale dœ bale kœyindœ awonœ ɓata á tshe yindœ tœ ye dœ tœ ye, yé œ li ndje dœ yashe bale dœ bale kœzatœ ga atɨ fœ akɔnœ. ");
INSERT INTO mnh_vpl VALUES ("EP6_1","079_6_1","EPH","6","1","1","Agbolo, 'e dji aayi kœzu 'e. 'E mbœrœ ataa liaka œneke á Gbozu yindœ nœ; gbambanœ nene, asœmœ dá sœ ndjii. ");
INSERT INTO mnh_vpl VALUES ("EP6_2","079_6_2","EPH","6","2","2","O'o á Ndjaba pa lima tœnœ lœ awa o'o nœ ye utshunœ kœdœ adœke: Dji aba zœ dœ ayi zœ, ");
INSERT INTO mnh_vpl VALUES ("EP6_3","079_6_3","EPH","6","3","3","mbœrœ á ɓœ kœsœ dœ yanga á œndœ zœ kœdɨ waa pa ɔshɔ. ");
INSERT INTO mnh_vpl VALUES ("EP6_4","079_6_4","EPH","6","4","4","E'e dœ́ aayi kœzu agbolo, 'e mbœmbœrœ œrœ adœke œ za ókó ga lœ agbolo nœ 'e nene, kashe 'e gbɔndœ endje dœ kœyisœrœ œdœ kœmɨ upu dœ o'o á to ɓa ndœ Gbozu. ");
INSERT INTO mnh_vpl VALUES ("EP6_5","079_6_5","EPH","6","5","5","E'e dœ akanga, 'e dji agbozu tshapa 'e pa ɔshɔ asœke. 'E mbœrœtœ 'e lindœ o'o endje yé œ dji endje dœ lɔsu 'e bale ɓata 'e sœ kœmbœrœ akwa fœ Kristu. ");
INSERT INTO mnh_vpl VALUES ("EP6_6","079_6_6","EPH","6","6","6","'E mbœmbœrœ kolœ ataa dœ lɔndɔ á endje sœ kœko ala endje tœ 'e nene, œ sœ ɓata 'e sœ kœpara awa kœza yanga fœ endje. Kashe 'e mbœrœ dœ lɔsu 'e kɔ ɓata akanga nœ Kristu á endje zatœ endje tœ kœmbœrœ œneke á Ndjaba yindœ nœ. ");
INSERT INTO mnh_vpl VALUES ("EP6_7","079_6_7","EPH","6","7","7","'E mbœrœ akwa fœ agbozu tshapa 'e dœ ɔtshɔnœ ɓata 'e sœ kœmbœrœ fœ Gbozu, kashe œ dœ́dœ́ mbœrœ azu nene. ");
INSERT INTO mnh_vpl VALUES ("EP6_8","079_6_8","EPH","6","8","8","'E wusœ nœ adœke, œdœ kanga œdœ tsheneke á tshe dœ́dœ́ kanga nene, uzu dœ uzu œ gbɔ tshangba ɔtshɔrœ á tshe mbœrœ ɓa ndœ Gbozu. ");
INSERT INTO mnh_vpl VALUES ("EP6_9","079_6_9","EPH","6","9","9","Yé e'e dœ́ agbozu, 'e mbœrœ ndje awa bale ga ndœ akanga nœ 'e. 'E katœ kœmbœrœ ɔgbɔrœ ga tœ endje, mbœrœ 'e wusœ nœ adœke e'e dœ endje; 'e sœ dœ Gbozu pa 'e bale ɓa lafo á tshe keke azu mbœrœ tshatshu endje nene. ");
INSERT INTO mnh_vpl VALUES ("EP6_10","079_6_10","EPH","6","10","10","Tœ ndɔngɔlɔnœ, 'e para gbɔgbɔ lœ kœngbɔtœ 'e bale dœ Gbozu lœ awa gbɔgbɔ nœ ye á ropanœ. ");
INSERT INTO mnh_vpl VALUES ("EP6_11","079_6_11","EPH","6","11","11","'E ko œrœ koshe kɔ á Ndjaba ko fœ 'e á kœka dœ tœnœ ngbɨrɨ adœke djaboro kœkoko 'e vesho nene. ");
INSERT INTO mnh_vpl VALUES ("EP6_12","079_6_12","EPH","6","12","12","Gbambanœ nene, a sœsœ kœnga koshenœ dœ azu ɓata azœ nene. Kashe a sœ kœnga koshenœ dœ aekpe ɨshirɨ nœ tshapashɔ, dœ agboro azu, dœ gbɔgbɔ œdœ dœ aayi gbɔgbɔ nœ ubu osho nœ tshapashɔnœ asœke. ");
INSERT INTO mnh_vpl VALUES ("EP6_13","079_6_13","EPH","6","13","13","Mbœrœ tœnœ ataa, 'e ko œrœ koshenœ kɔ á Ndjaba ko fœ 'e mbœrœ lɔkɔ á ekpe olo kœli, á 'e kœka ngbɨrɨ utshu ayingba 'e. Yé manda kœnga koshenœ œrrr ga tœ ndɔngɔlɔnœ, 'e shi gbɨ. ");
INSERT INTO mnh_vpl VALUES ("EP6_14","079_6_14","EPH","6","14","14","Ataa, 'e kote 'e ga lœ vola. 'E za adja o'o ɓata uwu tshapa lœba tœ budu 'e; 'e za œrœ á sœ ndjii ɓata balangba nœ 'e. ");
INSERT INTO mnh_vpl VALUES ("EP6_15","079_6_15","EPH","6","15","15","'E sœ dœ yanga nœ kœmɨndœ Ɔtshɔ O'o nœ kœsœ gee fœ azu ɓata œrada tœ ada 'e. ");
INSERT INTO mnh_vpl VALUES ("EP6_16","079_6_16","EPH","6","16","16","'E za kœyindœrœ ɔlɔ dœ ɔlɔ ɓata balangba nœ 'e: œ za awa fœ 'e adœke 'e ru owo tœ wele á yiangba 'e sœ kœnɔ tœnœ. ");
INSERT INTO mnh_vpl VALUES ("EP6_17","079_6_17","EPH","6","17","17","'E yindœ kœshe ɓata kpoto wáyá yé œ tepa o'o ama Ndjaba ngbɨrɨ ɓata ɨngɨrɨ yakamba á Ɔtshɔ Ɨshirɨ za fœ 'e. ");
INSERT INTO mnh_vpl VALUES ("EP6_18","079_6_18","EPH","6","18","18","'E za avwala nœ 'e tœ œrœnœ asœmœ kɔ fœ Ndjaba yé ɔlɔ dœ ɔlɔ, Ɔtshɔ Ɨshirɨ sœ dœ 'e lœnœ. Mbœrœ tœnœ ataa, ala 'e gbɔ yé 'e zatœ 'e waa dœ waa ga tœnœ. 'E za ndje avwala nœ 'e mbœrœ azu nœ Ndjaba para kɔkɔ. ");
INSERT INTO mnh_vpl VALUES ("EP6_19","079_6_19","EPH","6","19","19","'E za ndje avwala nœ 'e fœ Ndjaba mbœrœ mœ adœke tshe yisœ Ɔtshɔ O'onœ á zatœ ye yiwa tœnœ fœ mœ yeka á mœ kœpapandœ nœ dœ awa nene. ");
INSERT INTO mnh_vpl VALUES ("EP6_20","079_6_20","EPH","6","20","20","Œmœ kœdœ ayi kœyisœ Ɔtshɔ O'o fœ azu, mbœrœ tœnœ dá mœ sœ lœ kánga. 'E za avwala fœ Ndjaba adœke adja awa mbœmbœrœ mœ bale nene, kashe tshe to gbɔgbɔ á li dœ mœ kœpandœ œneke á li adœke mœ pa. ");
INSERT INTO mnh_vpl VALUES ("EP6_21","079_6_21","EPH","6","21","21","Aya azœ dœ Tishike á tshe sœ kœmbœrœ akwa nœ Gbozu dœ lɔsu ye bale asœmœ, œshe dá pandœ o'o nœ mœ kɔ fœ 'e á 'e kœdji dœ ɔtshɔnœ yé á kœwu ndje sœ œneke á mœ sœ kœmbœrœ tœnœ. ");
INSERT INTO mnh_vpl VALUES ("EP6_22","079_6_22","EPH","6","22","22","Mœ sœ kœvwa she fœ 'e adœke 'e wusœ mara kœsœ nœ 'a ɓa ke yeka á kœza kœru lɔsu fœ 'e. ");
INSERT INTO mnh_vpl VALUES ("EP6_23","079_6_23","EPH","6","23","23","Kaka Ndjaba Aba œdœ Gbozu Yisu Kristu za kœsœ gee, dœ kœyindœsho, œdœ pe kœyindœrœ fœ 'e dœ́ aayazu lœ Yisu kɔkɔ. ");
INSERT INTO mnh_vpl VALUES ("EP6_24","079_6_24","EPH","6","24","24","Kaka Ndjaba to kane ye ga pa azu para kɔkɔ á endje yindœ Gbozu nœ azœ dœ Yisu Kristu dœ kœyindœsho á ka nene.");
INSERT INTO mnh_vpl VALUES ("PP1_1","080_1_1","PHP","1","1","1","Œmœ Polo œdœ Timote, a'a dœ aayi akwa nœ Yisu Kristu, 'a sœ kœsu mbetinœ asœke fœ 'e dœ ayerœ azu nœ Yisu Kristu para kɔkɔ ɓa lakpɨ Filipo, dœ agbozu Ikrizia œdœ ndje aayi akwa tshelœ Ikrizia. ");
INSERT INTO mnh_vpl VALUES ("PP1_2","080_1_2","PHP","1","2","2","Kaka Aba azœ dœ Ndjaba œdœ Gbozu Yisu Kristu ma ɔtshɔ lɔsu nœ endje ga ndœ 'e, yé œ za kœsœ gee nœ endje fœ 'e. ");
INSERT INTO mnh_vpl VALUES ("PP1_3","080_1_3","PHP","1","3","3","Ɔlɔ kɔ á mœ kœsœ kœgbe dœ 'e, mœ sœ kœgi mershe fœ Ndjaba nœ mœ. ");
INSERT INTO mnh_vpl VALUES ("PP1_4","080_1_4","PHP","1","4","4","Œ kœsœ adœke mœ za avwala nœ mœ fœ Ndjaba tœ upu nœ 'e, mœ sœ kœza tœnœ dœ yanga, ");
INSERT INTO mnh_vpl VALUES ("PP1_5","080_1_5","PHP","1","5","5","mbœrœ mara á 'e sœ kœtɨ kane mœ lœ kœmɨndœ Ɔtshɔ o'o nœ Kristu kœto tœ ali olo œrrr ga tœ ngɔngɔ asœke. ");
INSERT INTO mnh_vpl VALUES ("PP1_6","080_1_6","PHP","1","6","6","Adja mœ wusœ nœ adœke Ndjaba á tshe te lima tœ kœmbœrœ ɔtshɔ akwa ugurutœ 'e asœmœ, tshe sœpe kœmbœrœ tœnœ œrrr ga tœ kœkwa Yisu Kristu. ");
INSERT INTO mnh_vpl VALUES ("PP1_7","080_1_7","PHP","1","7","7","Œ sœ dœ ɔtshɔnœ adœke mœ sœ dœ gbetshelœ atamœ ga ndœ 'e para kɔkɔ. Mœ sœ kœgbɔndœ 'e ga tœ lɔsu mœ. Gbambanœ nene, 'e tɨ kane mœ waa lœ akwa á Ndjaba za fœ mœ lœ ɔtshɔ lɔsu nœ ye œdœ dœ lɔkɔ á mœ sœ ɓa lœ kánga œdœ ndje dœ lɔkɔ á mœ gugu lœ kánga nene, mbœrœ kœma ngbɨ adœke Ɔtshɔ O'onœ kœdœ adjapu yé azu sœ kœka ga mangba nœ. ");
INSERT INTO mnh_vpl VALUES ("PP1_8","080_1_8","PHP","1","8","8","Ndjaba wusœ nœ dœ ɔtshɔnœ adœke mœ yindœ 'e para kɔkɔ waa dœ kœyindœsho á to lœ Yisu Kristu. ");
INSERT INTO mnh_vpl VALUES ("PP1_9","080_1_9","PHP","1","9","9","Œ kœsœ adœke mœ sœ kœza avwala nœ mœ fœ Ndjaba tœ upu nœ 'e, mœ sœ kœkɨ adœke 'e yindœ Ndjaba yé œ yi ndje ndœtœ 'e tɔpanœ kpuru, tshe to kœwusœrœ fœ 'e yé œ kɔrɔ ala 'e, ");
INSERT INTO mnh_vpl VALUES ("PP1_10","080_1_10","PHP","1","10","10","yeka á 'e kœwusœ kœke œrœ á sœ dœ ɔtshɔnœ ndœ kœmbœrœ tœnœ. Atamœ 'e wuta azu á ekperœ gugu lœ endje nene, á anga œrœ kœgbagbara endje tœnœ œ gu nene dœ lɔkɔ kœkwa Yisu Kristu, ");
INSERT INTO mnh_vpl VALUES ("PP1_11","080_1_11","PHP","1","11","11","dœ mara adœke œneke kɔ á 'e mbœrœ dœ adja ɔtshɔrœ á na ga ndœ azœ lœ awa nœ Yisu Kristu, mbœrœ kœgi mokɔ fœ Ndjaba yé œ donga she. ");
INSERT INTO mnh_vpl VALUES ("PP1_12","080_1_12","PHP","1","12","12","Aaya mœ, mœ yindœ nœ adœke 'e wusœ o'onœ asœke: Œneke á wuta ga tœ mœ, œ mbœrœ adœke Ɔtshɔ O'o na ga utshunœ. ");
INSERT INTO mnh_vpl VALUES ("PP1_13","080_1_13","PHP","1","13","13","Mbœrœ tœnœ dá aayi kœgbɔndœ anda nœ egerœ gbozu œdœ pe anga azu para kɔkɔ, wusœ nœ adœke mœ li ga lœ kánga mbœrœ upu nœ Kristu. ");
INSERT INTO mnh_vpl VALUES ("PP1_14","080_1_14","PHP","1","14","14","Yé kœwu mœ lœ kánga, aaya azœ ndjoro sœ kœza lɔsu endje ga pa Gbozu dœ mara adœke, endje tetœ kœpa avwaratœ endje yé endje kpa sœsœ dœ awa tœ kœmɨndœ o'o ama Ndjaba nene. ");
INSERT INTO mnh_vpl VALUES ("PP1_15","080_1_15","PHP","1","15","15","Œ dœ́ adjapu adœke anga azu sœ kœyisœ œrœ tœ upu nœ Kristu dœ gbetshelœ nœ kœmbœrœ úkú œdœ gbetshelœ nœ kœgbugburu tshelœ o'o dœ mœ, anga endje sœ kœyisœ nœ dœ ɔtshɔ gbetshelœ. ");
INSERT INTO mnh_vpl VALUES ("PP1_16","080_1_16","PHP","1","16","16","Endjeneke asœke, endje sœ kœyisœ nœ dœ kœyindœsho ga ndœ mœ, mbœrœ á endje wusœ nœ adœke mœ sœ lœ kánga tœ upu nœ kœmbœrœ adœke azu yi adja ndœ Ɔtshɔ O'o. ");
INSERT INTO mnh_vpl VALUES ("PP1_17","080_1_17","PHP","1","17","17","Anga azu, endjeneke á endje sœ dœ úkú, endje sœ kœyisœ upu nœ Kristu dœ gbetshelœ adœke œne ropa anga œne. Œneke á endje gbe kœmbœrœ tœnœ sœsœ ndjii nene, endje dá yindœ kpa kœwo tshandœ mœ. ");
INSERT INTO mnh_vpl VALUES ("PP1_18","080_1_18","PHP","1","18","18","Œ mbœrœ œrœ bale nene! Œdœ endje kœyisœ œrœnœ dœ ɔtshɔ gbetshelœ too dœ ekpe gbetshelœ, kolœnœ adœke endje mɨndœ upu nœ Kristu. Yé mœ sœ dœ yanga tœnœ, mœ sœpe ndje sheko kolœ dœ yanga mbœrœ tœnœ. ");
INSERT INTO mnh_vpl VALUES ("PP1_19","080_1_19","PHP","1","19","19","Gbambanœ nene, mœ wusœ nœ adœke œneke kɔ œ kɔrɔ awa adœke endje vwara mœ lœ kánga mbœrœ á 'e sœ kœza avwala nœ 'e fœ Ndjaba tœ upu nœ mœ yé Ɨshirɨ nœ Yisu Kristu sœ ndje dœ mœ awa bale. ");
INSERT INTO mnh_vpl VALUES ("PP1_20","080_1_20","PHP","1","20","20","Œrœ á mœ sœ kœkate dœ lɔsu mœ bale, á sœ kœza gbetshelœ nœ mœ djigi ga tœnœ, œtœnœ kœdœ adœke mœ gbɔgbɔ tshula bale nene. Kashe gbetshelœ nœ mœ djigi ngɔngɔ asœke œdœ pe ɔlɔ dœ ɔlɔ kœdœ adœke mœ lɨsœ Kristu dœ undu mœ djigi, œdœ lœ soro mœ, œdœ lœ kuzu mœ. ");
INSERT INTO mnh_vpl VALUES ("PP1_21","080_1_21","PHP","1","21","21","Gbambanœ nene, ɓa tœ mœ, soro kœdœ Kristu yé kuzu kœdœ kœgbɔ œrœ tshangba akwa. ");
INSERT INTO mnh_vpl VALUES ("PP1_22","080_1_22","PHP","1","22","22","Kashe œ kœsœ adœke mœ sœpe dœ soro, œ li dœ mœ adœke mœ mbœrœ ɔtshɔ akwa, ataa mœ wuwusœ œrœ á mœ mbœrœ nene. ");
INSERT INTO mnh_vpl VALUES ("PP1_23","080_1_23","PHP","1","23","23","Mœ sœ ugurutœ o'o bisha á sœ kœgbota mœ: mœ yindœ kœkatœ kœsœ dœ soro pa ɔshɔ asœke ndœ kœsœ dœ soro awa bale dœ Kristu. Œtœnœ dá sœ dœ ɔtshɔnœ kœropa nœ. ");
INSERT INTO mnh_vpl VALUES ("PP1_24","080_1_24","PHP","1","24","24","Kashe œ sœ ndje dœ ɔtshɔnœ adœke mœ sœpe dœ soro mbœrœ 'e. ");
INSERT INTO mnh_vpl VALUES ("PP1_25","080_1_25","PHP","1","25","25","Mbœrœ tœnœ ataa, mœ sœsœ dœ sharapu nene. Mœ wusœ nœ adœke mœ sœ dœ 'e awa bale mbœrœ kœko ala mœ tœ 'e adœke 'e gerœ, yé œ sœ ndje dœ yanga lœ kœyindœrœ. ");
INSERT INTO mnh_vpl VALUES ("PP1_26","080_1_26","PHP","1","26","26","Atamœ, lɔkɔ á mœ kœkwatœ mœ ga ndœ 'e, 'e kpa li kœdonga tœ 'e tœ œneke á Yisu Kristu mbœrœ fœ 'e lœ awa nœ mœ. ");
INSERT INTO mnh_vpl VALUES ("PP1_27","080_1_27","PHP","1","27","27","Ngɔngɔ asœke œrœ á ropanœ kɔ kœdœ adœke, mara kœmbœrœtœ 'e li dœ Ɔtshɔ O'o nœ Kristu. Atamœ œdœ mœ kœna kœwu 'e too mœ kœnana nene, mœ yindœ kœdji adœke 'e sœpe kœru lɔsu 'e dœ gbetshelœ bale, 'e sœ dœ lɔsu bale mbœrœ kœnga koshe nœ kœyindœrœ á Ɔtshɔ O'o yisœ nœ fœ 'e. ");
INSERT INTO mnh_vpl VALUES ("PP1_28","080_1_28","PHP","1","28","28","'E sœsœ dœ awa ayingba 'e bale nene. Asœmœ dá ma ambárá fœ endje adœke awa kuzu endje dá endje za, kashe 'e za œnœ 'e awa kœshe; œneke á to ɓa ndœ Ndjaba. ");
INSERT INTO mnh_vpl VALUES ("PP1_29","080_1_29","PHP","1","29","29","Gbambanœ nene, Ndjaba yisœ ɔtshɔ lɔsu nœ ye ga ndœ 'e, adœke 'e wuta azu nœ Kristu. Tshe mbœmbœrœ kolœnœ adœke 'e sœ dœ kœyindœrœ nene, kashe mbœrœ adœke 'e wu ndje oyo tœ upu nœ ye. ");
INSERT INTO mnh_vpl VALUES ("PP1_30","080_1_30","PHP","1","30","30","Ngɔngɔ asœke, a ngbɔtœ koshenœ á 'e wu mœ kœnga tœnœ adœke azu yi adja ndœ Ɔtshɔ O'o. Œtœnœ kœdœ koshe á 'e wu mœ lima kœnga tœnœ yé mœ sœpe kœnga tœnœ adœke azu yi adja ndœ Ɔtshɔ O'o ɓata á 'e wusœ nœ ngɔngɔ asœke. ");
INSERT INTO mnh_vpl VALUES ("PP2_1","080_2_1","PHP","2","1","1","Ɓata á kœyindœrœ nœ 'e ga ndœ Kristu za gbɔgbɔ fœ 'e, yé á kœyindœsho nœ ye to uvuru ga lœ 'e, ɓata 'e ngbɔtœ 'e bale dœ Ɔtshɔ Ɨshirɨ, 'e yindœtœ 'e dœ́ œ mbœrœ ayo ugurutœ 'e. ");
INSERT INTO mnh_vpl VALUES ("PP2_2","080_2_2","PHP","2","2","2","Atamœ, 'e mbœrœ adœke lɔsu mœ su dœ yanga mbœrœ kœngbɔtœ o'o ama 'e bale, dœ kœyindœtœ 'e, dœ kœsœ dœ lɔsu 'e bale œdœ ndje dœ gbetshelœ bale. ");
INSERT INTO mnh_vpl VALUES ("PP2_3","080_2_3","PHP","2","3","3","'E mbœmbœrœ œrœ bale dœ gbetshelœ nœ kœropa anga 'e nene, 'e dodonga tœ 'e nene kashe lœ kœzatœ 'e ga atɨ, 'e wu anga anga 'e ɓata endje ropa 'e ye. ");
INSERT INTO mnh_vpl VALUES ("PP2_4","080_2_4","PHP","2","4","4","Uzu gbegbe kolœ dœ undu ye dœ tœ ye nene, kashe œ li adœke tshe gbe ndje dœ anga azu anganœ. ");
INSERT INTO mnh_vpl VALUES ("PP2_5","080_2_5","PHP","2","5","5","'E sœ dœ gbetshelœ ɓata á Yisu Kristu sœ lima dœ tœnœ: ");
INSERT INTO mnh_vpl VALUES ("PP2_6","080_2_6","PHP","2","6","6","Mara kœsœ nœ ye kœdœ lima œnœ Ndjaba. Œshe kœdœ lima adja Ndjaba, kashe tshe gbegbe lima kœpara awa kœgbɔndœ kœdœ kolœ Ndjaba nœ ye nene. ");
INSERT INTO mnh_vpl VALUES ("PP2_7","080_2_7","PHP","2","7","7","Kashe tshe katœ œneke kɔ á tshe sœ lima dœ tœnœ tɨ, yé œ za lima mara kœsœ nœ kanga. Tshe wuta lima ɓata azu para kɔkɔ, yé œ za mara kœsœ á azu sœ dœ tœnœ. ");
INSERT INTO mnh_vpl VALUES ("PP2_8","080_2_8","PHP","2","8","8","Tshe za lima tœ ye ga atɨ yé œ za o'o ama Ndjaba ga tœ akwa lœ œrœ kɔ á tshe mbœrœ œrrr ga tœ kuzu, adja kuzu ɓa pa kurushi. ");
INSERT INTO mnh_vpl VALUES ("PP2_9","080_2_9","PHP","2","9","9","Mbœrœ tœnœ ataa, Ndjaba tɨ she galafo kœropa nœ yé œ za ɨ'ɨrɨ á ropa ɨ'ɨrɨ kɔ fœ she. ");
INSERT INTO mnh_vpl VALUES ("PP2_10","080_2_10","PHP","2","10","10","Tshe yindœ nœ adœke tœ kœlɨsœ ɨ'ɨrɨ Yisu, endjeneke kɔ á endje sœ ɓa lafo, ɓa pa ɔshɔ, ɓa ndœ akuzu, endje gote ga utshu ye. ");
INSERT INTO mnh_vpl VALUES ("PP2_11","080_2_11","PHP","2","11","11","Yé endje kɔ, endje mɨndœ nœ adœke Yisu Kristu kœdœ Gbozu, ɓa lœ mokɔ nœ Aba dœ Ndjaba. ");
INSERT INTO mnh_vpl VALUES ("PP2_12","080_2_12","PHP","2","12","12","Ataa, e'e dœ aaya mœ á mœ yindœ 'e waa, 'e sœ lima kœlɨsœ o'o mœ dœ ɔlɔ kɔ á mœ sœ lima ugurutœ 'e. Ɓata á mœ sœsœ ugurutœ 'e nene, 'e kpa lɨsœ nœ ropa nœ. 'E mbœrœ akwa manda kœshe nœ 'e dœ awa kɔ. ");
INSERT INTO mnh_vpl VALUES ("PP2_13","080_2_13","PHP","2","13","13","Gbambanœ nene, Ndjaba dá sœ kœmbœrœ akwa ugurutœ 'e, adœke 'e yindœ nœ, yé œ mbœrœ œneke á tshe yindœ nœ. ");
INSERT INTO mnh_vpl VALUES ("PP2_14","080_2_14","PHP","2","14","14","Œ li adœke 'e kparawa kœle lœ ama 'e œdœ kœgbugburu tshelœ o'o, ");
INSERT INTO mnh_vpl VALUES ("PP2_15","080_2_15","PHP","2","15","15","adœke azu kœgbɔgbɔ ádá kœpa ekpe o'o nœ 'e nene, á kœwuwu ekperœ lœ 'e nene. Atamœ, 'e dœ agbolo nœ Ndjaba á ekperœ gugu lœ 'e nene ugurutœ azu tshapashɔ á endje sœ kolœ kœmbœrœ ekperœ. Œ li adœke 'e tshi ugurutœ endje ɓata angerepe á tshi ɓa lafo, ");
INSERT INTO mnh_vpl VALUES ("PP2_16","080_2_16","PHP","2","16","16","lɔkɔ á 'e sœ kœma o'o nœ soro. Œdœ 'e kœsœ kœmbœrœ atamœ, mœ sœ dœ yanga lɔkɔ á Kristu œ kwatœ ye, yé œ ma ndje adœke akwa á mœ mbœrœ lima œdœ ɨlɨ á mœ vwi, œ sœsœ gbambanœ nene. ");
INSERT INTO mnh_vpl VALUES ("PP2_17","080_2_17","PHP","2","17","17","Œ kœsœ ndje adœke endje wo mœ, yé indji mœ tu, á gbɔtœ ye dœ tokóró nœ 'e á dœ́ kœyindœrœ nœ 'e ga ndœ Ndjaba, mœ sœ dœ yanga mbœrœ tœnœ yé e'e para 'e te ndje ga ndœ yanga nœ mœ awa bale dœ mœ. ");
INSERT INTO mnh_vpl VALUES ("PP2_18","080_2_18","PHP","2","18","18","E'e ndje ataa, 'e sœ dœ yanga yé mœ te ndje ga ndœ yanga nœ 'e awa bale dœ 'e. ");
INSERT INTO mnh_vpl VALUES ("PP2_19","080_2_19","PHP","2","19","19","Œdœ Gbozu Yisu kœyindœ nœ, mœ wusœ nœ adœke mœ vwa Timote ɓa ndœ 'e lœ ondonœ asœke, adœke tshe gu dœ o'o tshandœ 'e fœ mœ yeka á mœ kœgbɔ gbɔgbɔ mbœrœ tœnœ. ");
INSERT INTO mnh_vpl VALUES ("PP2_20","080_2_20","PHP","2","20","20","Mœ sœpe kolœ dœ Timote á gbetshelœ nœ ye sœ ɓata œnœ mœ yé tshe sœ kœgbe kolœ o'o nœ 'e. ");
INSERT INTO mnh_vpl VALUES ("PP2_21","080_2_21","PHP","2","21","21","Gbambanœ nene, anga udu azu para kɔkɔ sœ kœgbe kolœ o'o nœ kœmbœrœ œrœ nœ endje dœ tœ endje, kashe endje gbegbe dœ upu nœ Yisu Kristu nene. ");
INSERT INTO mnh_vpl VALUES ("PP2_22","080_2_22","PHP","2","22","22","'E wusœ nœ dœ tœ 'e mara á tshe ma ɔtshɔ akwa nœ ye. Tshe zatœ ye djigi mbœrœ kœmɨndœ Ɔtshɔ O'o awa bale dœ mœ ɓata á gbolo yakoshe œ tɨ kane abanœ. ");
INSERT INTO mnh_vpl VALUES ("PP2_23","080_2_23","PHP","2","23","23","Mœ sœ kœgbe kœvwa she fœ 'e œdœ mœ kœwu upu nœ mœ ngbɨ yekane. ");
INSERT INTO mnh_vpl VALUES ("PP2_24","080_2_24","PHP","2","24","24","Mœ sœ dœ kœyindœrœ ga ndœ Gbozu adœke mœ yi ndje kumu mœ ndœ kœwu 'e lœ ondonœ asœke. ");
INSERT INTO mnh_vpl VALUES ("PP2_25","080_2_25","PHP","2","25","25","Mœ wu adœke œ sœ dœ ɔtshɔnœ kœgi aya mœ dœ Epafrodite, yanga mœ lœ ama akwa œdœ lœ koshe á 'e vwa lima she adœke tshe mbœrœ akwa fœ mœ lɔkɔ á mœ sœ lima lœ oyo. ");
INSERT INTO mnh_vpl VALUES ("PP2_26","080_2_26","PHP","2","26","26","Tshe sœ dœ ogo kpa kœwu 'e para kɔkɔ, yé lɔsu ye sú dœ oyo kœropa nœ mbœrœ á 'e dji lima adœke tshe sœ dœ koɓa. ");
INSERT INTO mnh_vpl VALUES ("PP2_27","080_2_27","PHP","2","27","27","Adja Koɓanœ za she lima ndoo dœ kuzu, kashe Ndjaba wu oyo ye. Œ dœ́dœ́ kolœ oyo ye bale nene, kashe Ndjaba wu ndje oyo mœ mbœrœ adœke adja anga oyo kpa wuwuta ga pa oyo nene. ");
INSERT INTO mnh_vpl VALUES ("PP2_28","080_2_28","PHP","2","28","28","Mbœrœ tœnœ dá mœ yindœ kœgi she katsha fœ 'e adœke lɔkɔ á 'e kpa kœwu she, yeka á 'e kœsœ dœ yanga á átá oyo nœ mœ kœka. ");
INSERT INTO mnh_vpl VALUES ("PP2_29","080_2_29","PHP","2","29","29","Atamœ, 'e za osho kœsœ fœ she dœ yanga kɔ ɓata aya uzu lœ ngbɔtœ nœ Gbozu. Œ li adœke 'e lɨsœ mara azu ɓata she. ");
INSERT INTO mnh_vpl VALUES ("PP2_30","080_2_30","PHP","2","30","30","Gbambanœ nene, tshe yi lima kœtshu mbœrœ akwa nœ Kristu. Tshe za undu ye fœ kuzu mbœrœ kœtɨ kane mœ galafo dœ œneke á 'e lili má kœmbœrœ tœnœ fœ mœ dœ tœ 'e nene. ");
INSERT INTO mnh_vpl VALUES ("PP3_1","080_3_1","PHP","3","1","1","Yé ngɔngɔ asœ aaya mœ, 'e sœ dœ yanga mbœrœ kœngbɔtœ 'e bale dœ Gbozu. Mœ wusœ nœ adœke mœ sú lima o'onœ asœke fœ 'e utshunœ ye. Kashe mœ mɔ nene ndœ kpa kœsu tœnœ mbœrœ á kœli œrrr ga tœ lɔsu 'e. ");
INSERT INTO mnh_vpl VALUES ("PP3_2","080_3_2","PHP","3","2","2","Ala 'e gbɔ dœ azu á endje sœ kœmbœrœ ekperœ. Endje sœ ɓata ekpe ayavoro. Endje kœdœ azu á endje sœ kœ'e tœ endje tœ azu nœ Ndjaba mbœrœ á endje za lɔsu endje ga pa gaza ɓata egerœ œrœ. ");
INSERT INTO mnh_vpl VALUES ("PP3_3","080_3_3","PHP","3","3","3","Adja azu nœ Ndjaba kœdœ azœ; gbambanœ nene, azœ kœdœ azu á a sœ kœdonga Ndjaba dœ awanœ, dœ gbɔgbɔ nœ Ɨshirɨ yé á sœ kœza lɔsu azœ ga pa Yisu Kristu, kashe a koko lɔsu azœ ga tœ undu azœ nene. ");
INSERT INTO mnh_vpl VALUES ("PP3_4","080_3_4","PHP","3","4","4","Andaa, mœ li má ndje kœza lɔsu mœ ga tœ undu mœ dœ tœ mœ. Œ kœsœ adœke anga azu gbe adœke œne li kœza lɔsu œne ga tœ undu œne dœ tœ œne, mœ li ndje kœmbœrœ tœnœ kœropa nœ. ");
INSERT INTO mnh_vpl VALUES ("PP3_5","080_3_5","PHP","3","5","5","Gbambanœ nene, endje wa mœ tœ gaza olo mindu dœ votɔ manda kœzu mœ mara á awa akwa pa tœnœ. Ogo mœ kœdœ Israyele yé mara mœ kœdœ Bendjame. Œmœ kœdœ uzu Ebre yé aata mœ kœdœ ndje Aebre. Lœ o'o á wu awa akwa, mœ za lima tœ mœ djigi ndœ nœ, œmœ kœdœ lima Farisayi. ");
INSERT INTO mnh_vpl VALUES ("PP3_6","080_3_6","PHP","3","6","6","Tœ upunœ kœmbœrœ akwa dœ egerœ ogo, mœ mbœrœ lima œrœ kanga fœ Ikrizia. Mœ za lima lɔsu mœ adœke awa akwa œ fa mœ ndjii tœ ala Ndjaba, mbœrœ tœnœ ataa mœ sœ lima kœlɨsœ awa akwa waa. ");
INSERT INTO mnh_vpl VALUES ("PP3_7","080_3_7","PHP","3","7","7","Kashe œrœ kɔ á mœ sœ lima kœwu ɓata œ sœ dœ ádánœ waa, ngɔngɔ asœke mœ wu ɓata œrœ á te tshakane mœ, mbœrœ kœza lɔsu mœ ga pa Kristu. ");
INSERT INTO mnh_vpl VALUES ("PP3_8","080_3_8","PHP","3","8","8","Kœropa nœ, œ dœ́dœ́ kolœ œrœ bale nene. Mœ sœ kœwu œrœ para kɔkɔ lœ ala mœ ɓata œ kpa dœ́ tafo œrœ nene, mbœrœ tafo œrœ á ropa œrœ para kɔkɔ kœdœ kœwusœ Gbozu nœ mœ dœ Yisu Kristu. Mbœrœ she, mœ kpa yiyindœ nœ adœke œrœ kɔ á sœ lima tœ ɔtshɔnœ tœ ala mœ, kpa dœ́dœ́ ɔtshɔrœ tœ ala mœ nene. Mœ sœ kœwu œrœ para kɔkɔ ɓata œrœ kœko va ga pa ndikɔ, mbœrœ á mœ gbɔ Kristu, ");
INSERT INTO mnh_vpl VALUES ("PP3_9","080_3_9","PHP","3","9","9","yé á ngbɔtœ mœ dœ she bale. Mœ wuwuta ɔtshɔ uzu mbœrœ œrœ á mœ mbœrœ lœ awa nœ kœlɨsœ awa akwa nene, kashe lœ awa nœ kœyindœrœ ga ndœ Kristu. Atamœ, mara kœwuta uzu ndjii to ɓa ndœ Ndjaba lœ awa nœ kœyindœrœ ga ndœ Kristu. ");
INSERT INTO mnh_vpl VALUES ("PP3_10","080_3_10","PHP","3","10","10","Ogo nœ mœ adœke mœ wusœ Kristu, dœ gbɔgbɔ á she she lœ akuzu asœmœ yé œ ngbɔtœ mœ dœ she lœ œrœ kanga nœ ye kɔ adœke mœ wuta ɓata she lœ kuzu nœ ye. ");
INSERT INTO mnh_vpl VALUES ("PP3_11","080_3_11","PHP","3","11","11","Mbœrœ tœnœ ataa, mœ za lɔsu mœ ga tœ Ndjaba adœke, mœ she ndje bala lœ akuzu ye. ");
INSERT INTO mnh_vpl VALUES ("PP3_12","080_3_12","PHP","3","12","12","Mœ sœsœ kœpa adœke mœ gbɔ œrœ tshangba kœkpa ɔrɔ nœ mœ ye nene, too ndje adœke mara kœmbœrœtœ nœ mœ wuta tœ ɔtshɔnœ nene. Kashe mœ sœpe kœpa avwaratœ mœ adœke mœ gbɔ œrœ tshangba nœ. Wu ádánœ á Yisu Kristu gbe lima dœ tœnœ yeka á ke mœ. ");
INSERT INTO mnh_vpl VALUES ("PP3_13","080_3_13","PHP","3","13","13","Aaya mœ, mœ gbegbe adœke mœ gbɔ œrœ tshangba nœ ye nene. Kashe mœ sœ kœmbœrœ œrœ bale: mœ kpa za ala mœ ga tœ œrœ á mœ ro ga manda mœ nene, kashe mœ sœ kœpa avwara kœwuta ga tœ œrœ á sœ ɓa utshu mœ. ");
INSERT INTO mnh_vpl VALUES ("PP3_14","080_3_14","PHP","3","14","14","Ataa, mœ sœ kœkpa ɔrɔ kœwuta ga tœ osho á mœ yindœ kœwuta ga tœnœ adœke mœ gbɔ œrœ á Ndjaba e azœ kœgbɔ ɓa lafo lœ awa nœ Yisu Kristu. ");
INSERT INTO mnh_vpl VALUES ("PP3_15","080_3_15","PHP","3","15","15","Azœ para kɔkɔ á a dœ́ agbozu lœ kœyindœrœ, œ li adœke a sœ dœ mara gbetshelœnœ asœmœ. Yé œ kœsœ adœke 'e sœ dœ anga angbɨ gbetshelœ tœ œneke, Ndjaba œ yisœ nœ ngbɨ fœ 'e. ");
INSERT INTO mnh_vpl VALUES ("PP3_16","080_3_16","PHP","3","16","16","Ataa atamœ gbaa, œ li adœke a sœpe kœna ga utshunœ tœ awa á a tetœ nœ œrrr kpesheke asœke. ");
INSERT INTO mnh_vpl VALUES ("PP3_17","080_3_17","PHP","3","17","17","Aaya mœ, e'e para kɔkɔ 'e za mara kœmbœrœtœ nœ mœ. 'E ko ala 'e ga tœ endjeneke á mara kœmbœrœtœ nœ endje li dœ œneke á 'a yisœ nœ fœ 'e. ");
INSERT INTO mnh_vpl VALUES ("PP3_18","080_3_18","PHP","3","18","18","Mœ pa lima o'onœ asœke fœ 'e yeka á kpa pa dœ ngola adœke: mara kœmbœrœtœ azu ndjoro sœ kœma adœke endje kœdœ ayingba kurushi nœ Kristu. ");
INSERT INTO mnh_vpl VALUES ("PP3_19","080_3_19","PHP","3","19","19","Endje za awa kuzu mbœrœ ndjaba nœ endje kœdœ uvu endje. Endje sœ kœdonga tœ endje tœ œrœ á za tshula fœ endje yé gbetshelœ nœ endje sœ kolœ ga pa œrœ tshapashɔ asœke. ");
INSERT INTO mnh_vpl VALUES ("PP3_20","080_3_20","PHP","3","20","20","Kashe azœ, tshalakpɨ nœ azœ sœ ɓa lafo, ɓa tœ osho á sœ kœkate Ayi kœshe azœ, á tshe kœdœ Gbozu Yisu Kristu. ");
INSERT INTO mnh_vpl VALUES ("PP3_21","080_3_21","PHP","3","21","21","Tshe fa undu azœ, œnœ tshapashɔnœ asœke adœke œ li dœ undu ye œnœ mokɔ. Tshe mbœrœ œneke kɔ dœ gbɔgbɔ á za awa fœ she adœke tshe dœ Gbozu pa œrœ kɔ. ");
INSERT INTO mnh_vpl VALUES ("PP4_1","080_4_1","PHP","4","1","1","Mbœrœ tœnœ ataa, aaya mœ á mœ yindœ 'e waa, mœ sœ dœ egerœ ogo kpa kœwu 'e. 'E sœ kœmbœrœ adœke yanga nœ mœ sœ tœ egerœnœ yé mœ donga tœ mœ mbœrœ 'e. 'E dœ aaya mœ á mœ yindœ 'e waa, 'e wu mara á li dœ 'e kœshi gbɨ lœ soro 'e bale dœ Gbozu. ");
INSERT INTO mnh_vpl VALUES ("PP4_2","080_4_2","PHP","4","2","2","Mœ za o'o fœ Evodi œdœ Setishe adœke endje sœ dœ gbetshelœ bale mbœrœ endje kœdœ azu nœ Gbozu. ");
INSERT INTO mnh_vpl VALUES ("PP4_3","080_4_3","PHP","4","3","3","Œɓœ ndje á ɓœ dœ́ adja yanga mœ lœ ama akwa, mœ yindœ nœ adœke ɓœ u ayashe bisha asœke adœke endje katœ kœle lœ ama endje. Gbambanœ nene, endje zatœ endje ga tœ akwa dœ mœ ndœ kœmɨndœ Ɔtshɔ o'o, awa bale dœ Klema œdœ pe ndje anga udu anga mœ lœ ama akwa para kɔkɔ á ɨ'ɨrɨ endje sœ ala buku nœ soro. ");
INSERT INTO mnh_vpl VALUES ("PP4_4","080_4_4","PHP","4","4","4","'E sœ dœ yanga ɔlɔ dœ ɔlɔ mbœrœ e'e kœdœ azu nœ Gbozu. Mœ kpa pa adœke: 'e sœ dœ yanga. ");
INSERT INTO mnh_vpl VALUES ("PP4_5","080_4_5","PHP","4","5","5","'E sœ dœ ɔtshɔ lɔsu ga ndœ azu para kɔkɔ. Lɔkɔ kœkwa Gbozu ndo ye. ");
INSERT INTO mnh_vpl VALUES ("PP4_6","080_4_6","PHP","4","6","6","'E zaza lɔsu 'e ga lafo mbœrœ œrœ bale nene. Kashe lœ œrœ kɔ, œ li adœke 'e za avwala nœ 'e fœ Ndjaba tœ œrœ á oyonœ za 'e. Yé lɔkɔ á 'e kœsœ kœza avwalanœ, 'e za dœ kœgi mershe. ");
INSERT INTO mnh_vpl VALUES ("PP4_7","080_4_7","PHP","4","7","7","Yé kœsœ gee nœ Ndjaba á ropa kœwusœrœ kɔ, œ gbɔndœ lɔsu 'e dœ pe gbetshelœ nœ 'e lœ Yisu Kristu. ");
INSERT INTO mnh_vpl VALUES ("PP4_8","080_4_8","PHP","4","8","8","Aaya mœ, ndɔngɔlɔ o'o á mœ yindœ kœpa fœ 'e dœke: œ li adœke 'e gbe kolœ dœ œrœ á sœ dœ ɔtshɔnœ, œrœ á li kœdonga tœnœ, œrœ á sœ ndjii, œrœ á ekperœ gugu lœ nœ nene, œrœ á azu yindœ nœ, œrœ á endje lɨsœ nœ, œrœ á endje pa ɔtshɔ o'o mbœrœ tœnœ, 'e ko œrœnœ kɔ asœke ga lœ kumu 'e. ");
INSERT INTO mnh_vpl VALUES ("PP4_9","080_4_9","PHP","4","9","9","Œrœ á mœ yisœ nœ fœ 'e á 'e wusœ nœ, œrœ á 'e dji yé á wu mœ kœmbœrœ tœnœ, 'e za ga tœ akwa. 'E za œneke á mœ yisœ nœ fœ 'e ga tœ akwa. Yé Ndjaba á tshe za kœsœ gee fœ azu, tshe sœ awa bale dœ 'e. ");
INSERT INTO mnh_vpl VALUES ("PP4_10","080_4_10","PHP","4","10","10","Mœ sœ lima dœ egerœ yanga lœ kœsœ bale dœ Gbozu tœ kœwu adœke 'e kpa gbɔ lima awa ndœ kœgbe dœ mœ. Adja 'e sœ lima kœgbe dœ mœ zœ yeka á 'e gbɔgbɔ lima awa ndœ kœyisœ nœ ngbɨ nene. ");
INSERT INTO mnh_vpl VALUES ("PP4_11","080_4_11","PHP","4","11","11","Mœ sœsœ kœpa atake mbœrœ á mœ sœ dœ ogo kœgbɔ œrœ bale nene. Gbambanœ nene, mœ wusœ kœza lɔsu mœ kolœ ga tœ œneke á mœ sœ dœ tœnœ. ");
INSERT INTO mnh_vpl VALUES ("PP4_12","080_4_12","PHP","4","12","12","Tœ osho kɔ á mœ sœ tœnœ, lœ œrœ kɔ á wuta ga tœ mœ, mœ wusœ kœru lɔsu mœ œdœ mœ kœsœ dœ kœzɨrœ œdœ mœ sœ dœ ogo, too œdœ mœ kœsœ dœ œrœ ndjoro œdœ mœ kœgugu dœ œrœ kœli dœ gbetshelœ nœ mœ nene. ");
INSERT INTO mnh_vpl VALUES ("PP4_13","080_4_13","PHP","4","13","13","Kristu sœ kœto gbɔgbɔ fœ mœ lœ œrœ para kɔkɔ á wuta ga tœ mœ. ");
INSERT INTO mnh_vpl VALUES ("PP4_14","080_4_14","PHP","4","14","14","Kashe 'e mbœrœ lima tœ ɔtshɔnœ kœgbe dœ mœ lɔkɔ á mœ sœ lima lœ oyo. ");
INSERT INTO mnh_vpl VALUES ("PP4_15","080_4_15","PHP","4","15","15","E'e dœ azu Filipo, 'e wusœ nœ dœ tœ 'e adœke pe dœ lɔkɔ á mœ ka lima tœ Masedwane tɨ mbœrœ kœna kœtetœ kœyisœ Ɔtshɔ O'onœ, anga azu angbɨ Ikrizia tɨtɨ kane mœ nene, kolœ e'e dá tɨ kane mœ lœ awa nœ kœto makabo nœ ngendja fœ mœ. ");
INSERT INTO mnh_vpl VALUES ("PP4_16","080_4_16","PHP","4","16","16","Lɔkɔ á mœ sœ lima lœ Tesalonike, 'e tɨ lima kane mœ lœ awa nœ kœvwa œrœ á mœ sœ lima dœ ogo nœ. ");
INSERT INTO mnh_vpl VALUES ("PP4_17","080_4_17","PHP","4","17","17","Mœ sœsœ kœpara awa adœke 'e to œrœ fœ mœ nene. Kashe mœ sœ kœpara adœke anga angbɨ œrœ ndjoro kpa te ga pa œneke á 'e sœ dœ tœnœ. ");
INSERT INTO mnh_vpl VALUES ("PP4_18","080_4_18","PHP","4","18","18","Mœ gbɔ œrœnœ kɔ á 'e vwa fœ mœ asœmœ yé œ dopa nœ ye. Œrœ á 'e vwa dœ Epafrodite fœ mœ asœmœ, œ li adja ngɔngɔ asœke dœ ogo nœ mœ yé œ sœ ɓata yombo á tshafunœ ga, á sœ ndje ɓata tokóró á ga tœ Ndjaba, á tshe sœ dœ yanga mbœrœ tœnœ. ");
INSERT INTO mnh_vpl VALUES ("PP4_19","080_4_19","PHP","4","19","19","Yé Ndjaba nœ mœ œ to œneke kɔ á 'e gugu dœ tœnœ nene fœ 'e, lœ awa nœ kœngbɔtœ 'e dœ Yisu Kristu liaka adja kœngba œrœ nœ ye. ");
INSERT INTO mnh_vpl VALUES ("PP4_20","080_4_20","PHP","4","20","20","Kaka Aba azœ dœ Ndjaba sœ dœ mokɔ waa dœ waa. Ame. ");
INSERT INTO mnh_vpl VALUES ("PP4_21","080_4_21","PHP","4","21","21","'E za abala fœ ayerœ azu nœ Yisu Kristu bale dœ bale kɔ. Aaya azœ á mœ sœ dœ endje ɓa ke, bala ndje 'e. ");
INSERT INTO mnh_vpl VALUES ("PP4_22","080_4_22","PHP","4","22","22","Azu nœ Ndjaba para kɔkɔ za abala fœ 'e, yé kœropa nœ endjeneke á endje sœ lœ gbagba nœ egerœ gbozu Sezare. ");
INSERT INTO mnh_vpl VALUES ("PP4_23","080_4_23","PHP","4","23","23","Kaka adœke Gbozu Yisu Kristu gbɔndœ ɨshirɨ 'e lœ awa nœ ɔtshɔ lɔsu nœ ye.");
INSERT INTO mnh_vpl VALUES ("CL1_1","081_1_1","COL","1","1","1","Œmœ Polo á Ndjaba ke mœ adœke mœ te ayi avwa nœ Yisu Kristu, œmœ œdœ aya azœ dœ Timote, ");
INSERT INTO mnh_vpl VALUES ("CL1_2","081_1_2","COL","1","2","2","a sœ kœsu mbetinœ asœ fœ 'e dœ́ ayerœ azu nœ Ndjaba ɓa lakpɨ Kolose, á 'e sœ kœmbœrœtœ 'e lindœ kœyindœrœ ga ndœ Kristu. Kaka Aba azœ dœ Ndjaba ma ɔtshɔ lɔsu nœ ye ga ndœ 'e yé œ za kœsœ gee nœ ye fœ 'e. ");
INSERT INTO mnh_vpl VALUES ("CL1_3","081_1_3","COL","1","3","3","Ɔlɔ dœ ɔlɔ 'a sœ kœza mershe fœ Ndjaba, Aba Gbozu nœ azœ dœ Yisu Kristu, lœ avwala nœ 'a fœ she tœ upu nœ 'e. ");
INSERT INTO mnh_vpl VALUES ("CL1_4","081_1_4","COL","1","4","4","Gbambanœ nene, 'a djindœ kœyindœrœ nœ 'e ga ndœ Yisu Kristu œdœ pe mara kœyindœsho á 'e sœ dœ tœnœ ga ndœ ayerœ azu nœ Ndjaba para kɔkɔ. ");
INSERT INTO mnh_vpl VALUES ("CL1_5","081_1_5","COL","1","5","5","'E sœ kœmbœrœ atamœ mbœrœ á 'e sœ kœza lɔsu 'e ga pa ɔtshɔrœ á Ndjaba gbɔndœ nœ kate 'e ɓa lafo. Gbambanœ nene, gbɔgbɔ nœ kœza lɔsu 'e to lœ awa nœ adjapu á 'e dji lima utshunœ á dœ́ Ɔtshɔ O'o. ");
INSERT INTO mnh_vpl VALUES ("CL1_6","081_1_6","COL","1","6","6","Ɔtshɔ O'onœ kurutshelœtœ ye pa ɔshɔ djigi yé œ sœ kœmbœrœ akwa na tœnœ veveve ko ɓata á ma lima tœ ye ugurutœ 'e, pe dœ lɔkɔ á 'e gbɔ lima yé á wu ndje sœ ɔtshɔ lɔsu nœ Ndjaba á tshe ma adja fœ azu. ");
INSERT INTO mnh_vpl VALUES ("CL1_7","081_1_7","COL","1","7","7","Aya 'a dœ Epafraze á a yindœ ye waa, á tshe sœ kœmbœrœ akwa awa bale dœ 'a dá yi lima sœ nœ fœ 'e. Tshe sœ ga lœ kudu 'a ɓa ndœ 'e ɓata adja ayi akwa nœ Kristu, ");
INSERT INTO mnh_vpl VALUES ("CL1_8","081_1_8","COL","1","8","8","yé tshe pa lima ndœ mara kœyindœsho á Ɔtshɔ Ɨshirɨ za ga lœ 'e fœ 'a kɔ. ");
INSERT INTO mnh_vpl VALUES ("CL1_9","081_1_9","COL","1","9","9","Mbœrœ tœnœ atamœ, á kœto kpœtœ olo á 'a djindœ nœ, 'a kakatœ kœza avwala nœ 'a fœ Ndjaba tœ upu nœ 'e nene. 'A sœ kœyu she adœke tshe yisœ gbetshelœ nœ ye djigi fœ 'e, mangba kœwusœtœ kɔ œdœ kœwusœrœ á Ɔtshɔ Ɨshirɨ to. ");
INSERT INTO mnh_vpl VALUES ("CL1_10","081_1_10","COL","1","10","10","Ataa, 'e mbœrœtœ 'e ɓata azu nœ Gbozu nœ azœ yé kœmbœrœ œrœ nœ 'e œ za yanga waa dœ waa fœ she. Lœ œrœ kɔ, 'e li kœmbœrœ ɔtshɔrœ yé 'e wusœ Ndjaba kœropa nœ. ");
INSERT INTO mnh_vpl VALUES ("CL1_11","081_1_11","COL","1","11","11","Ndjaba to gbɔgbɔ nœ ye á sœ dœ mokɔ waa fœ 'e adœke 'e sœ dœ ugu lɔsu, yé œ wusœ kœshi gbɨ lœ œneke kɔ á wuta ga tœ 'e. ");
INSERT INTO mnh_vpl VALUES ("CL1_12","081_1_12","COL","1","12","12","'E gi mershe dœ yanga fœ Aba azœ dœ Ndjaba á tshe guma 'e adœke 'e gbɔ ndje ɔtshɔrœ á tshe gbɔndœ nœ kate ayerœ azu ɓa lœ ogo ɨshirɨ nœ ye. ");
INSERT INTO mnh_vpl VALUES ("CL1_13","081_1_13","COL","1","13","13","Tshe ko azœ lœ kanga nœ ubu osho, yé œ gi azœ ga lœ ogo tshagbozu nœ Gbolo nœ ye á tshe yindœ ye kœropa nœ. ");
INSERT INTO mnh_vpl VALUES ("CL1_14","081_1_14","COL","1","14","14","Dœ awa nœ Gbolonœ, a kpa dœ́dœ́ akanga nene yé tshe djerœndœ ekperœ nœ azœ ye. ");
INSERT INTO mnh_vpl VALUES ("CL1_15","081_1_15","COL","1","15","15","Kristu za tshatshu Ndjaba á uzu bale wuwu she nene, œshe kœdœ Eya Gbolo nœ Ndjaba á tshe ropa azu œdœ pe œrœ para kɔkɔ á tshe mbœrœ. ");
INSERT INTO mnh_vpl VALUES ("CL1_16","081_1_16","COL","1","16","16","Gbambanœ nene, Ndjaba mbœrœ œrœ kɔ lœ awa nœ ye, œrœ á sœ ɓalafo œdœ ɓa atɨ, œneke á a sœ kœwutœ nœ dœ pe œneke á a sœsœ kœwutœ nœ nene, dœ gbɔgbɔ kɔ œdœ ndje ɨshirɨ kɔ á sœ ɓata agbozu lœ yugu dœ pe tshaatɨ. Ndjaba mbœrœ lima œrœ kɔ lœ awa nœ Kristu adœke œrœ kɔ sœ mbœrœ she. ");
INSERT INTO mnh_vpl VALUES ("CL1_17","081_1_17","COL","1","17","17","Ataa tshe sœ utshu œrœ kɔ yé œrœ kɔ á li kœsœ tœnœ, ka mbœrœ she. ");
INSERT INTO mnh_vpl VALUES ("CL1_18","081_1_18","COL","1","18","18","Tshe kœdœ ndje Gbozu nœ Ikrizia, œshe kœdœ kumu Ikrizia, Ikrizia kœdœ undu ye, tshe kœdœ ali uzu, tshe kœdœ ali uzu á tshe she lœ kuzu ugurutœ akuzu; Mbœrœ tœnœ dá tshe wuta Gbozu pa œrœ kɔ á Ndjaba mbœrœ. ");
INSERT INTO mnh_vpl VALUES ("CL1_19","081_1_19","COL","1","19","19","Gbambanœ nene, Ndjaba dœ tœ ye dá yi lima ndœ nœ adœke Kristu za angwa œne djigi. ");
INSERT INTO mnh_vpl VALUES ("CL1_20","081_1_20","COL","1","20","20","Lœ awa nœ Kristu, Ndjaba gbe ndje lima kœgi ayo ga ugurutœ ye dœ œrœ para kɔkɔ á tshe mbœrœ. Adjapu adœke lœ awa nœ kuzu Gbolo nœ ye lɔkɔ á indji ye tu pa kurushi, tshe guma tshaguru tœ ye dœ œrœ kɔ á sœ ɓalafo dœ ɓa atɨ. ");
INSERT INTO mnh_vpl VALUES ("CL1_21","081_1_21","COL","1","21","21","Yé e'e ndje, 'e sœ lima lœ ɨngɨrɨnœ tœ Ndjaba, 'e dœ́ lima azu kœyiangba ye mangba ekperœ á 'e sœ lima kœgbe dœ tœnœ á sœ ndje kœmbœrœ tœnœ. ");
INSERT INTO mnh_vpl VALUES ("CL1_22","081_1_22","COL","1","22","22","Kashe ngɔngɔ asœke, lœ awa nœ kuzu á wo ɔkɔ Gbolo nœ ye, Ndjaba guma tshaguru tœ ye dœ 'e adœke 'e te ayerœ azu neke á endje li tœ ala ye. ");
INSERT INTO mnh_vpl VALUES ("CL1_23","081_1_23","COL","1","23","23","Œ li adœke 'e tepa kœyindœrœ nœ 'e ngbɨrɨ, uzu bale fafara 'e nene. 'E za kolœ lɔsu 'e ga tœ ɔtshɔrœnœ á Ndjaba gumasœ nœ kate 'e ɓata á 'e dji lima lœ Ɔtshɔ O'o. Ɔtshɔ O'onœ asœmœ, endje yisœ nœ fœ azu kɔ pa ɔshɔ, yé œtœnœ dá œmœ dœ Polo wuta ayi akwa mbœrœ kœyisœ nœ. ");
INSERT INTO mnh_vpl VALUES ("CL1_24","081_1_24","COL","1","24","24","Ngɔngɔ asœke, mœ sœ dœ yanga mbœrœ oyo á mœ sœ kœwu tœnœ tœ upu nœ 'e. Gbambanœ nene, oyo á mœ sœ kœwu lœ ɔkɔ mœ asœke te ga lœ kumu œneke á Kristu wu lima. Mœ yindœ kœza oyonœ mbœrœ ɔtshɔrœ nœ Ikrizia á dœ́ undu ye. ");
INSERT INTO mnh_vpl VALUES ("CL1_25","081_1_25","COL","1","25","25","Mœ te ayi akwa lœ Ikrizia mbœrœ á Ndjaba za mœ adœke mœ mbœrœ akwa ugurutœ 'e. Tshe vwa mœ adœke mœ gbara o'o ama ye djigi. ");
INSERT INTO mnh_vpl VALUES ("CL1_26","081_1_26","COL","1","26","26","Œ yindœ kœpa adœke: O'o á Ndjaba sœ kœza yiwa tœnœ ɓalima katshatsha tœ azu. Ngɔngɔ asœke, tshe sœ kœyisœ nœ fœ azu á tshe ke endje. ");
INSERT INTO mnh_vpl VALUES ("CL1_27","081_1_27","COL","1","27","27","Ndjaba yi lima ndœ kœyisœ nœ fœ azu adœke, œrœ á œne za yiwa tœnœ asœmœ kœdœ egerœ œrœ á ropa œrœ kɔ, yé á dœ mokɔ á sœ ɓa ugurutœ angbɨ azu. O'onœ á zatœ ye yiwatœnœ asœmœ kœdœ: Kristu sœ ugurutœ 'e yé dœ awa nœ ye, 'e ngbɔtœ 'e dœ she bale lœ mokɔ nœ Ndjaba. ");
INSERT INTO mnh_vpl VALUES ("CL1_28","081_1_28","COL","1","28","28","Ataa, Kristunœ asœke dá 'a sœ kœpandœ o'o nœ ye. 'A sœ kœmɨ upu fœ uzu dœ uzu, œ sœ kœyisœ œrœ lœ kœwusœtœ kɔ adœke á guma endje dœ́ endje ngbɔtœ endje bale dœ Kristu yeka á endje kœgerœ lœ kœyindœrœ. ");
INSERT INTO mnh_vpl VALUES ("CL1_29","081_1_29","COL","1","29","29","Mbœrœ tœnœ ataa, mœ sœ kœmbœrœ akwanœ yé œsœ kœnga koshe dœ gbɔgbɔ nœ Kristu, œtœnœ dá sœ kœmbœrœ akwa lœ mœ dœ gbɔgbɔ. ");
INSERT INTO mnh_vpl VALUES ("CL2_1","081_2_1","COL","2","1","1","Mœ yindœ nœ adœke 'e wusœ mara ɔgbɔ koshe á mœ sœ kœnga tœ upu nœ 'e, tœ upu nœ azu Lawudukiya œdœ pe tœ upu nœ endjeneke kɔ á endje wuwu damba mœ nene. ");
INSERT INTO mnh_vpl VALUES ("CL2_2","081_2_2","COL","2","2","2","Mœ sœ kœmbœrœ ataa mbœrœ á 'e kœshi gbɨ, mbœrœ á 'e kœsœ kœyindœtœ 'e dœ lɔsu 'e bale. Mœ yi ndje ndœ nœ adœke Ndjaba to kane ye ga pa 'e yeka á 'e kœsœ dœ kœwusœrœ neke á li dœ kœwusœ adja o'o nœ Ndjaba á zatœ ye yiwatœnœ: O'onœ á zatœ ye yiwa tœnœ asœmœ kœdœ Kristu dœ tœ ye, ");
INSERT INTO mnh_vpl VALUES ("CL2_3","081_2_3","COL","2","3","3","á kœwusœtœ kɔ sœ ɓa ndœ ye. Œshe dá sœ kœkɔrɔ awa nœ kœwusœ œrœ fœ azœ ");
INSERT INTO mnh_vpl VALUES ("CL2_4","081_2_4","COL","2","4","4","Mœ pa o'onœ asœ fœ 'e mbœrœ adœke anga uzu bale kpa kœfafara 'e dœ undú o'o nene. ");
INSERT INTO mnh_vpl VALUES ("CL2_5","081_2_5","COL","2","5","5","Ataa mœ gugu ugurutœ 'e nene gbaa, lɔsu mœ sœ ɓa ndœ 'e. Mœ sœ dœ yanga kœwu mara á 'e ka ngbɨrɨ yé á sœ kœshi gbɨgbɨgbɨ lœ kœyindœrœ nœ 'e ga ndœ Kristu. ");
INSERT INTO mnh_vpl VALUES ("CL2_6","081_2_6","COL","2","6","6","Ataa, ɓata á 'e yindœ nœ adœke Yisu Kristu dœ Gbozu nœ 'e asœmœ, 'e ngbɔtœ 'e bale dœ she ɔlɔ dœ ɔlɔ. ");
INSERT INTO mnh_vpl VALUES ("CL2_7","081_2_7","COL","2","7","7","'E li ga lœ ye ɓata á eshe ɔyɔ œ li ga lœ ɔshɔ yé 'e za soro djigi ga tshakane ye. 'E shi ngbɨrɨ lœ kœyindœrœ nœ 'e ɓata mara á endje yi lima sœ nœ fœ 'e, yé œ sœ kœgi ɔtshɔrœ fœ Ndjaba ɔlɔ dœ ɔlɔ. ");
INSERT INTO mnh_vpl VALUES ("CL2_8","081_2_8","COL","2","8","8","'E sœ dœ gbɔdjela adœke uzu bale fafara 'e dœ kœwusœtœ nœ wala á sœ gbambanœ nene. Mara o'onœ asœmœ œ ka kolœ ga pa gbetshelœ nœ azu œdœ ga pa gbɔgbɔ nœ ɨshirɨ tshapashɔ; kashe œ kaka ga pa Kristu nene. ");
INSERT INTO mnh_vpl VALUES ("CL2_9","081_2_9","COL","2","9","9","Gbambanœ nene, undu Ndjaba djigi sœ lœ Kristu; ");
INSERT INTO mnh_vpl VALUES ("CL2_10","081_2_10","COL","2","10","10","yé 'e gbɔ soro djigi lœ awa nœ kœngbɔtœ 'e dœ she. Œshe kœdœ Gbozu nœ Ɨshirɨ kɔ á sœ dœ gbɔgbɔ. ");
INSERT INTO mnh_vpl VALUES ("CL2_11","081_2_11","COL","2","11","11","Lœ kœngbɔtœ 'e bale dœ Kristu, tshe wa 'e tœ gaza. Gazanœ asœmœ dœ́dœ́ œneke á azu sœ kœwa tœnœ nene, kashe œtœnœ kœdœ gaza á to ɓa ndœ Kristu yé á gi 'e lœ ekpe ɔtshɔ 'e lima utshunœ. ");
INSERT INTO mnh_vpl VALUES ("CL2_12","081_2_12","COL","2","12","12","Lɔkɔ á 'e gbɔ lima batisimu, œ sœ ɓata endje shi 'e awa bale dœ Kristu yé 'e she ndje awa bale dœ she mbœrœ á 'e sœ dœ kœyindœrœ ga tœ gbɔgbɔ nœ Ndjaba á she lima she lœ akuzu. ");
INSERT INTO mnh_vpl VALUES ("CL2_13","081_2_13","COL","2","13","13","Utshunœ, 'e tshu lima lœ ɨshirɨ mbœrœ á 'e sœ lima kœmbœrœ ekperœ œdœ pe mbœrœ á 'e dœ́dœ́ lima azu nœ Ndjaba nene. Ngɔngɔ asœke Ndjaba she 'e lœ kuzu awa bale dœ Yisu Kristu, yé œ djerœndœ ekperœ nœ azœ kɔ ye. ");
INSERT INTO mnh_vpl VALUES ("CL2_14","081_2_14","COL","2","14","14","Utshunœ, a yo lima dœ ngbanga mbœrœ á a tsha lima upu kœmbœrœtœ azœ lindœ awa akwa nœ Ndjaba, kashe Ndjaba wo mbeti á wa lima ngbanganœ ga tœ azœ, œ za ekperœ lœ kumu azœ œ za ga pa kumu Kristu lɔkɔ á tshe tshu pa kurushi. ");
INSERT INTO mnh_vpl VALUES ("CL2_15","081_2_15","COL","2","15","15","Ɨshirɨ kɔ á sœ lima dœ gbɔgbɔ, Ndjaba gbɔtœ gbɔgbɔnœ yé œ ko ɨshirɨnœ kɔ ga tœ ala azu, lɔkɔ á tshe i endje dœ djingiri á sœ kœna dœ endje mbœrœ kœma adœke, œne ropa endje lœ awa nœ kuzu Kristu pa kurushi. ");
INSERT INTO mnh_vpl VALUES ("CL2_16","081_2_16","COL","2","16","16","Ngɔngɔ asœ, uzu bale wawa ngbanga ga pa 'e tœ upu nœ kœzɨrœ too kœndjorœ nene. Œdœ tœ upu nœ olo angbo too olo kœwuta tafo yapu too ndje tœ upu nœ olo kœyatœ osho, uzu bale wawa ngbanga pa 'e nene. ");
INSERT INTO mnh_vpl VALUES ("CL2_17","081_2_17","COL","2","17","17","Alœmœ para kɔkɔ sœ kœma kolœ ɨshirɨ œrœ á wuta má lima, kashe adjapunœ kœdœ Kristu. ");
INSERT INTO mnh_vpl VALUES ("CL2_18","081_2_18","COL","2","18","18","Uzu bale mbœmbœrœ adœke 'e yo nene! Anga azu sœ kœdu okoro endje lœ kœzatœ endje ga atɨ yé á sœ kœpa adœke azu donga aandjelu. Endje sœ kœzatœ endje kolœ ga tœ o'o neke á na ga lœ ɔkɔrɔ endje lœ ulu. Mara azunœ asœmœ sœ dœ egerœ kumu waa lœ kœwusœrœ nœ ɔkɔ nœ endje. ");
INSERT INTO mnh_vpl VALUES ("CL2_19","081_2_19","COL","2","19","19","Azunœ asœmœ ngbɔngbɔtœ endje dœ Kristu á tshe dœ kumu Ikrizia nene. Kashe Kristu dá to kœzɨrœ fœ azu Ikrizia, á sœ kœmbœrœ adœke endje ngbɔtœ endje ga tœ nœ bale yeka á kœgerœ ɓata á Ndjaba yindœ nœ. ");
INSERT INTO mnh_vpl VALUES ("CL2_20","081_2_20","COL","2","20","20","Ɓata á 'e tshu awa bale dœ Kristu á wuta tshakudu gbɔgbɔ nœ ɨshirɨ tshapashɔ, mbœrœ gaɗe á 'e sœ kœmbœrœtœ 'e ɓata 'e sœpe azu nœ tshapashɔ á sœ kœyindœ mara o'o atamœ a? 'E yindœ nœ adœke endje pa fœ 'e adœke: ");
INSERT INTO mnh_vpl VALUES ("CL2_21","081_2_21","COL","2","21","21","«Zaza œrœ asœ nene, zɨzɨ œrœ asœ nene, yé tuturutœ œneke nene.» ");
INSERT INTO mnh_vpl VALUES ("CL2_22","081_2_22","COL","2","22","22","Alœmœ kɔ, kolœ mbœrœ œrœ á œndœ nœ œ dɨ nene. Azu dá guma awa akwanœ asœmœ kɔ yekane á yisœ nœ. ");
INSERT INTO mnh_vpl VALUES ("CL2_23","081_2_23","COL","2","23","23","Œ dœ́ adjapu adœke awa akwanœ asœmœ matœ ye ɓata œnœ kœwusœtœ, mbœrœ œ sœ kœza awa fœ azu adœke endje donga Ndjaba dœ mara á endje yindœ nœ, endje sœ kœzatœ endje ga atɨ yé œ sœ kœmbœrœ œrœ kanga ga tœ ɔkɔ endje. Kashe œ dœ́dœ́ tœnœ dá kɔ uzu tœ kœsœ dœ ogo œrœ á tshe yindœ nœ nene. ");
INSERT INTO mnh_vpl VALUES ("CL3_1","081_3_1","COL","3","1","1","Ɓata á Ndjaba she 'e lœ kuzu awa bale dœ Kristu, 'e para awa kœgbɔ œrœ tshalafo ɓa tœ osho á Kristu sœ tœnœ ga pa kuni Ndjaba. ");
INSERT INTO mnh_vpl VALUES ("CL3_2","081_3_2","COL","3","2","2","'E gbe kolœ dœ œrœ tshalafo. Adja 'e kpa gbegbe dœ œrœ tshapashɔ nene. ");
INSERT INTO mnh_vpl VALUES ("CL3_3","081_3_3","COL","3","3","3","Gbambanœ nene, 'e wuta ɓata azu á endje tshu yé soro 'e zatœ ye wutœnœ awa bale dœ Kristu ɓa tshakane Ndjaba. ");
INSERT INTO mnh_vpl VALUES ("CL3_4","081_3_4","COL","3","4","4","Kristu kœdœ soro nœ 'e. Lɔkɔ á kœsœ adœke tshe kpa kwatœ ye, 'e wuta ndje awa bale dœ she lœ mokɔ nœ ye. ");
INSERT INTO mnh_vpl VALUES ("CL3_5","081_3_5","COL","3","5","5","Mbœrœ tœnœ ataa, 'e wo ogo œrœ tshapashɔ á sœ tœ lɔsu 'e, ɓata kœmbœrœ angba budu, kœmbœrœ œrœ uburu, kœmbœrœ œrœ tshula, ekpe gbetshelœ œdœ kœsœ dœ ogo kœgbɔ ukpulu œrœ, gbambanœ nene, ogo kœgbɔ ukpulu œrœ sœ ɓata kœdonga anga andjaba. ");
INSERT INTO mnh_vpl VALUES ("CL3_6","081_3_6","COL","3","6","6","Œrœnœ para kɔkɔ asœke sœ kœgbota ókó nœ Ndjaba ga tœ azu á endje vwaratœ endje tœ kœdji O'o ama ye. ");
INSERT INTO mnh_vpl VALUES ("CL3_7","081_3_7","COL","3","7","7","E'e ndje, ɔlɔ á 'e sœ lima pe kœro manda ogo ekperœnœ asœke; 'e mbœrœ ndje lima tœ 'e ɓata azunœ asœmœ. ");
INSERT INTO mnh_vpl VALUES ("CL3_8","081_3_8","COL","3","8","8","Kashe ngɔngɔ asœke 'e katœ ongboro ɔtshɔ 'e asœmœ tɨ: kœsœ dœ ókó, kœoma dœ o'o œdœ kœsœ dœ ogo kœmbœrœ ekperœ ga tœ azu, kœpa ekpe o'o ga tœ uzu œdœ pe kœpa o'o tshula. ");
INSERT INTO mnh_vpl VALUES ("CL3_9","081_3_9","COL","3","9","9","'E fafaratœ 'e ugurutœ 'e nene mbœrœ á 'e katœ ongboro ɔtshɔ 'e lima tɨ ye, ");
INSERT INTO mnh_vpl VALUES ("CL3_10","081_3_10","COL","3","10","10","yé 'e wuta adja atafo azu. Ndjaba á tshe mbœrœ adœke 'e wuta atafo azu asœmœ, tshe sœpe kœmbœrœ tœ 'e dœ mara adœke 'e wuta ɓata œne yé 'e wu ndje sœ œne dœ ɔtshɔnœ. ");
INSERT INTO mnh_vpl VALUES ("CL3_11","081_3_11","COL","3","11","11","Ngɔngɔ asœke, œrœ á kurutshelœ Ayuda dœ angbɨ azu kpa gugu nene, œdœ azu á endje wa gaza œdœ endjeneke á endje wawa gaza nene, a sœ awa bale. Œdœ kara, œdœ uzu á tshe wuwusœ œrœ nene, œdœ kanga œdœ uzu neke á tshe dœ́dœ́ kanga nene a sœ bale tœ ala Ndjaba. Kolœ Kristu bale á tshe sœ ga pa œrœ kɔ, œshe dá sœ dœ azœ para kɔkɔ. ");
INSERT INTO mnh_vpl VALUES ("CL3_12","081_3_12","COL","3","12","12","Ndjaba ke 'e ɓalima katshatsha yé tshe yindœ 'e, e'e kœdœ adja azu nœ ye. Mbœrœ tœnœ ataa, 'e wu oyo anga 'e yé œ sœ dœ ɔtshɔ lɔsu ga ndœ endje. 'E zatœ 'e ga atɨ, œ sœ dœ lɔsu zɨtɨ œdœ ugu lɔsu. ");
INSERT INTO mnh_vpl VALUES ("CL3_13","081_3_13","COL","3","13","13","'E sœ ndje dœ kœru lɔsu ugurutœ 'e. Œ kœsœ adœke anga uzu sœ dœ o'o ga tœ yanganœ, 'e djitœ 'e dœ́ œ djerœndœ ekperœ nœ anga 'e ugurutœ 'e dœ tœ 'e. 'E mbœrœ ɓata Gbozu; gbambanœ nene, œshe ndje tshe djerœ lima ndje ndœ ekperœ nœ 'e. ");
INSERT INTO mnh_vpl VALUES ("CL3_14","081_3_14","COL","3","14","14","Lœnœ kɔ, œrœ á ropa nœ kœdœ adœke: 'e yindœtœ 'e, mbœrœ kœyindœsho dá ngbɔɓa 'e ga tœ œsœnœ bale. ");
INSERT INTO mnh_vpl VALUES ("CL3_15","081_3_15","COL","3","15","15","Kaka adœke kœsœ gee nœ Kristu za osho tœ lɔsu 'e. Gbambanœ nene, Ndjaba ke lima 'e adœke 'e ngbɔɓa tœ 'e ga tœnœ adœke 'e wuta uzu bale yé œ sœ dœ kœsœ gee ugurutœ 'e. 'E za kolœ mershe fœ she. ");
INSERT INTO mnh_vpl VALUES ("CL3_16","081_3_16","COL","3","16","16","Kaka adœke o'o ama Kristu œdœ pe ɔtshɔrœ lœ nœ djigi sœ tœ lɔsu 'e: 'e yisœ œrœ ugurutœ 'e, œ gbagbaratœ 'e ugurutœ 'e dœ kœwusœtœ kɔ. 'E ɓi itshi kœdonga Ndjaba dœ lɔsu 'e djigi. 'E za mershe fœ she, œ ɓi itshi á to lœ Ɔtshɔ Ɨshirɨ. ");
INSERT INTO mnh_vpl VALUES ("CL3_17","081_3_17","COL","3","17","17","Œneke kɔ á 'e pa, œdœ œneke á 'e gbe kœmbœrœ tœnœ, 'e mbœrœ dœ ɨ'ɨrɨ Gbozu Yisu yé œ gi mershe fœ Ndjaba Aba dœ awa nœ ye. ");
INSERT INTO mnh_vpl VALUES ("CL3_18","081_3_18","COL","3","18","18","E'e dœ ayashe, 'e lɨsœ aakɔ 'e ɓata œ li tœ ala Gbozu. ");
INSERT INTO mnh_vpl VALUES ("CL3_19","081_3_19","COL","3","19","19","E'e dœ ayakoshe, 'e yindœ aawo 'e yé 'e sœsœ dœ ɔgbɔ lɔsu ga tœ endje nene. ");
INSERT INTO mnh_vpl VALUES ("CL3_20","081_3_20","COL","3","20","20","E'e dœ agbolo, 'e dji o'o ama ayi kœzu 'e lœ œrœ kɔ gbambanœ nene, asœmœ dá za yanga fœ Gbozu. ");
INSERT INTO mnh_vpl VALUES ("CL3_21","081_3_21","COL","3","21","21","E'e dœ aaba agbolo, adja 'e zaza awa adœke agbolo nœ 'e so ókó, œ mɔ lœ gbetshelœ nœ endje nene. ");
INSERT INTO mnh_vpl VALUES ("CL3_22","081_3_22","COL","3","22","22","E'e dœ akanga, 'e dji o'o ama agbozu tshapa 'e lœ œrœ kɔ. 'E mbœmbœrœ asœmœ mbœrœ á endje sœ kœwu 'e tœ kœza yanga fœ endje nene, kashe 'e mbœrœ atamœ dœ ɔtshɔ lɔsu tœ kœkpa awa Gbozu. ");
INSERT INTO mnh_vpl VALUES ("CL3_23","081_3_23","COL","3","23","23","Akwa para kɔkɔ á 'e mbœrœ, 'e mbœrœ dœ lɔsu 'e djigi ɓata 'e sœ kœmbœrœ fœ Gbozu, kashe œ sœsœ adœke 'e sœ kœmbœrœ fœ azu nene. ");
INSERT INTO mnh_vpl VALUES ("CL3_24","081_3_24","COL","3","24","24","'E wusœ nœ adœke, Gbozu œ to œrœ tshamanda akwanœ á tshe guma fœ azu nœ ye fœ 'e. Gbambanœ nene adja ayengɔ 'e á 'e sœ kœmbœrœ akwanœ fœ she kœdœ Kristu. ");
INSERT INTO mnh_vpl VALUES ("CL3_25","081_3_25","COL","3","25","25","Kashe uzu á tshe sœ kolœ kœmbœrœ ekperœ, tshe gbɔ o'o manda ekperœ nœ ye asœmœ, mbœrœ Gbozu keke azu dœ kœwu tshatshu endje nene. ");
INSERT INTO mnh_vpl VALUES ("CL4_1","081_4_1","COL","4","1","1","E'e dœ agbozu, 'e mbœrœ œrœ á sœ ndjii, yé á sœ dœ awanœ ga tœ akanga nœ 'e. 'E wusœ nœ adœke 'e sœ ndje dœ Gbozu pa 'e ɓa lafo. ");
INSERT INTO mnh_vpl VALUES ("CL4_2","081_4_2","COL","4","2","2","Adja 'e kakatœ kœza avwala nœ 'e fœ Ndjaba tɨ nene. 'E kœsœ kœza avwalanœ, ala 'e gbɔ, yé 'e gi kolœ mershe fœ Ndjaba. ");
INSERT INTO mnh_vpl VALUES ("CL4_3","081_4_3","COL","4","3","3","'E za ndje avwala nœ 'e tœ 'a adœke, Ndjaba kɔrɔ awa fœ 'a tœ kœgbara o'o ama ye, o'o nœ Kristu á zatœ ye wutœnœ á mœ li kánga mbœrœ tœnœ. ");
INSERT INTO mnh_vpl VALUES ("CL4_4","081_4_4","COL","4","4","4","'E za avwala nœ 'e fœ Ndjaba adœke, mœ gbara œneke ndjii ɓata á li dœ mœ kœmbœrœ tœnœ. ");
INSERT INTO mnh_vpl VALUES ("CL4_5","081_4_5","COL","4","5","5","Ala 'e gbɔ lœ kœsœ 'e ugurutœ azu á endje yiyindœ Yisu nene. Œdœ 'e kœgbɔ awa tœ kœmbœrœ ɔtshɔrœ fœ endje, 'e mbœrœ œneke á li dœ 'e kœmbœrœ tœnœ. ");
INSERT INTO mnh_vpl VALUES ("CL4_6","081_4_6","COL","4","6","6","Kaka adœke o'o ama 'e ga tœ endje ɓata rœgo á li dœ ama uzu, yé 'e wusœ kœgi o'o á li tœ kœgi fœ uzu dœ uzu. ");
INSERT INTO mnh_vpl VALUES ("CL4_7","081_4_7","COL","4","7","7","Aya mœ dœ Tishike á mœ yindœ ye dœ lɔsu mœ bale, œshe dá pandœ o'o nœ mœ kɔ fœ 'e. Tshe sœ kœzatœ ye mbœrœ akwa nœ Gbozu dœ lɔsu bale, tshe kœdœ yanga mœ lœma akwa. ");
INSERT INTO mnh_vpl VALUES ("CL4_8","081_4_8","COL","4","8","8","Ádánœ á mœ vwa she fœ 'e kœdœ adœke tshe mɨndœ mara á 'a sœ dœ tœnœ ɓa ke fœ 'e yeka á kœza kœru lɔsu fœ 'e. ");
INSERT INTO mnh_vpl VALUES ("CL4_9","081_4_9","COL","4","9","9","Endje ro tœ awanœ dœ Onezime, aya 'a á 'a yindœ ye waa á tshe sœ kœmbœrœ akwa dœ lɔsu bale. Tshe kœdœ uzu nœ 'e, endje bibisha dá mɨndœ œrœ á sœ kœmbœrœtœ ye ɓa ke fœ 'e. ");
INSERT INTO mnh_vpl VALUES ("CL4_10","081_4_10","COL","4","10","10","Aristarke dá sœ œnœ ye lœ kánga awa bale dœ mœ. Tshe vwa abala fœ 'e, dœ Marke yiwu Barnabase. 'E dji o'o dœ ɔtshɔnœ tœ upu nœ Marke, œdœ tshe kœwuta ga ndœ 'e, 'e za osho kœsœ fœ she. ");
INSERT INTO mnh_vpl VALUES ("CL4_11","081_4_11","COL","4","11","11","Yisu á endje e ndje ɨ'ɨrɨ ye Yustushe vwa ndje abala fœ 'e. Ugurutœ Ayudanœ á endje te ayindœ Yisu, kolœ endje dá sœ kœtɨ kane mœ lœ akwa nœ ogo nœ Ndjaba yeka á sœ kœza kœru lɔsu fœ mœ. ");
INSERT INTO mnh_vpl VALUES ("CL4_12","081_4_12","COL","4","12","12","Epafraze á tshe dœ́ uzu nœ 'e kpa vwa ndje abala fœ 'e. Œshe kœdœ ayi akwa nœ Kristu Yisu á tshe mɔmɔ tœ kœza avwala nœ ye fœ Ndjaba tœ 'e nene adœke, 'e ka ngbɨrɨ ɓata azu á endje li yeka á kœmbœrœ œrœ para kɔkɔ á Ndjaba yindœ nœ. ");
INSERT INTO mnh_vpl VALUES ("CL4_13","081_4_13","COL","4","13","13","Adja mœ wu mara á tshe sœ kœzatœ ye ndœ akwa mbœrœ 'e, dœ azu lœ Lawudukiya œdœ pe endjeneke á endje sœ lœ Hierapolise. ");
INSERT INTO mnh_vpl VALUES ("CL4_14","081_4_14","COL","4","14","14","Monganga Lukasi, yanga azœ œdœ pe Demasi, endje vwa abala fœ 'e. ");
INSERT INTO mnh_vpl VALUES ("CL4_15","081_4_15","COL","4","15","15","'E za abala fœ aaya œdœ ayingɔ lœ Yisu á endje sœ ɓa lœ Lawudukiya, dœ pe yingɔ azœ dœ Nifa œdœ ayindœ Yisu kɔ á endje ngbɔɓa tœ endje ɓasœnda nœ ye. ");
INSERT INTO mnh_vpl VALUES ("CL4_16","081_4_16","COL","4","16","16","'E kœdɨ mbetinœ asœke œ kœka, 'e vwa ndje fœ azu Ikrizia lœ Lawudukiya adœke ayindœ Yisu ɓa zœ dɨ ndje. 'E dɨ ndje mbeti á mœ su fœ azu Ikrizia nœ Lawudukiya á endje vwa fœ 'e. ");
INSERT INTO mnh_vpl VALUES ("CL4_17","081_4_17","COL","4","17","17","'E pa fœ Arkipe adœke: gbɔndœ akwa á Gbozu za fœ ɓœ yeka á ɓœ kœmbœrœ dœ ɔtshɔnœ. ");
INSERT INTO mnh_vpl VALUES ("CL4_18","081_4_18","COL","4","18","18","Œmœ Polo, mœ vwa abala fœ 'e. Mœ sœ kœsu abalanœ asœke dœ adja kane mœ dœ tœ mœ. 'E gbe dœ mœ lœ kánganœ á mœ sœ lœnœ asœke kane. Kaka adœke Ndjaba ma ɔtshɔ lɔsu nœ ye ga ndœ 'e.");
INSERT INTO mnh_vpl VALUES ("H21_1","083_1_1","2TH","1","1","1","Œmœ Polo, Silase œdœ pe Timote, 'a vwa abala asœke fœ 'e dœ́ ayindœ Yisu lœ Ikrizia ɓa lœ Tesalonike. ");
INSERT INTO mnh_vpl VALUES ("H21_2","083_1_2","2TH","1","2","2","Kaka Aba azœ dœ Ndjaba œdœ Gbozu Yisu Kristu má ɔtshɔ lɔsu nœ endje ga ndœ 'e yé œ za kœsœ gee fœ 'e. ");
INSERT INTO mnh_vpl VALUES ("H21_3","083_1_3","2TH","1","3","3","Alaya, œ li adœke 'a za mershe fœ Ndjaba ɔlɔ dœ ɔlɔ tœ upu nœ 'e, yé œ sœ adja ndjii adœke 'a sœ kœmbœrœ tœnœ ataa. Gbambanœ nene, kœyindœrœ nœ 'e sœ kœgerœ tœnœ, yé kœyindœsho á 'e sœ dœ tœnœ ga ndœ anga 'e sœ ndje kœgerœ tœnœ waa. ");
INSERT INTO mnh_vpl VALUES ("H21_4","083_1_4","2TH","1","4","4","Mbœrœ tœnœ ataa, 'a sœ kœdu okoro 'a pa 'e ugurutœ azu lœ Ikrizia ndjoro nœ Ndjaba, mbœrœ kœshi gbɨ nœ 'e lœ kœyindœrœ nœ 'e lœ œrœ kanga œdœ oyo kɔ á na ga ndœ 'e á 'e ru lɔsu tœnœ. ");
INSERT INTO mnh_vpl VALUES ("H21_5","083_1_5","2TH","1","5","5","Œrœnœ asœmœ kɔ sœ kœma ngbɨ adœke kœwa ngbanga á Ndjaba œ wa, œ dœ adja kœwa ngbanga. Gbambanœ nene, œrœ kanga dœ oyo á 'e gbɔ, guma 'e adœke 'e li dœ Ogo gbozu nœ Ndjaba. ");
INSERT INTO mnh_vpl VALUES ("H21_6","083_1_6","2TH","1","6","6","Adja upu, Ndjaba sœ ndjii, tshe gi oyo ga pa azu á endje sœ kœmbœrœ œrœ kanga fœ 'e, ");
INSERT INTO mnh_vpl VALUES ("H21_7","083_1_7","2TH","1","7","7","yé tshe mbœrœ adœke, e'e dœ azu á 'e wu œrœ kanganœ asœmœ, 'e yatœ 'e awa bale dœ 'a lɔkɔ á Gbozu Yisu œ kwa bala dœ gbɔgbɔ kœto ɓa lafo dœ aandjelu nœ ye. ");
INSERT INTO mnh_vpl VALUES ("H21_8","083_1_8","2TH","1","8","8","Tshe na bala lœ laɓa owo, ndœ kœza ɔgbɔ djofele fœ endjeneke á endje wuwusœ Ndjaba nene, á vwaratœ endje tœ Ɔtshɔ O'o nœ Gbozu nœ azœ dœ Yisu. ");
INSERT INTO mnh_vpl VALUES ("H21_9","083_1_9","2TH","1","9","9","Ɔgbɔ djofele á endje wu bala dœke: oyo nœ waa dœ waa, endje sœ zara tœ ala Gbozu yé endje wu gbɔgbɔ nœ mokɔ nœ ye nene. ");
INSERT INTO mnh_vpl VALUES ("H21_10","083_1_10","2TH","1","10","10","Lɔkɔ á tshe kwa bala dœ olonœ asœmœ adœke ayerœ azu nœ ye za mokɔ fœ she œdœ adœke azu á endje sœ dœ kœyindœrœ ga ndœ ye lɨsœ ye. 'E sœ ndje ugurutœ endje mbœrœ á 'e yindœ Ɔtshɔ O'o á 'a mɨndœ nœ fœ 'e. ");
INSERT INTO mnh_vpl VALUES ("H21_11","083_1_11","2TH","1","11","11","Mbœrœ tœnœ ataa, 'a sœ kœza avwala ɔlɔ dœ ɔlɔ tœ upu nœ 'e adœke Ndjaba guma 'e, 'e li dœ kœke osho á tshe ke 'e. 'A sœ kœkɨ fœ Ndjaba adœke lœ gbɔgbɔ nœ ye, 'e mbœrœ ɔtshɔrœ kɔ á 'e gbe tœ kœmbœrœ tœnœ yé tshe kpa mbœrœ adœke 'e za kœyindœrœ nœ 'e ga tœ akwa. ");
INSERT INTO mnh_vpl VALUES ("H21_12","083_1_12","2TH","1","12","12","Ataa, azu œ donga ɨ'ɨrɨ Gbozu nœ azœ dœ Yisu mbœrœ 'e, yé endje donga ndje e'e mbœrœ she. Œ mbœrœtœ ye ataa liaka ɔtshɔ lɔsu nœ Ndjaba nœ azœ œdœ Gbozu Yisu Kristu. ");
INSERT INTO mnh_vpl VALUES ("H22_1","083_2_1","2TH","2","1","1","Alaya, tœ upu nœ kœkwa bala Gbozu nœ azœ dœ Yisu Kristu dœ pe kœngbɔtœ azœ ɨndɨrɨ ye, 'a sœ kœkɨ ga tœ 'e adœke: aaya ");
INSERT INTO mnh_vpl VALUES ("H22_2","083_2_2","2TH","2","2","2","œdœ azu kœpa fœ 'e adœke olo kœkwa Yisu li ye, kaka gbetshelœ nœ 'e sœ zɨtɨ yé 'e yiyindœ nœ nene. Œdœ ndje uzu kœgbara o'o dœ ɨ'ɨrɨ Ndjaba, œdœ endje kœpa ndje fœ 'e adœke a'a dá su ga la mbeti gbaa, adja 'e zaza lɔsu 'e ga lafo nene. ");
INSERT INTO mnh_vpl VALUES ("H22_3","083_2_3","2TH","2","3","3","Kaka uzu bale bɨbɨlɨ 'e dœ anga angbɨ mara nene. Gbambanœ nene, utshunœ adœke olonœ li, azu œ vwaratœ endje tœ Ndjaba yé ekpe Uzu œ matœ ye. Œshe kœdœ uzu á Ndjaba œ wo she. ");
INSERT INTO mnh_vpl VALUES ("H22_4","083_2_4","2TH","2","4","4","Uzunœ asœmœ œ vwaratœ ye tœ œneke kɔ á azu sœ kœdonga tœnœ yé á sœ kœza ɓata ndjaba. Tshe yiangba œrœnœ asœmœ kɔ, œ na œ sœ ɓa lœ Tepelo nœ Ndjaba, yé œ mɨndœ nœ adœke œne kœdœ Ndjaba. ");
INSERT INTO mnh_vpl VALUES ("H22_5","083_2_5","2TH","2","5","5","'E gbegbe shema dœ o'o á mœ sœ lima kœpa fœ 'e lɔkɔ á mœ sœ lima damba ugurutœ 'e nene a? ");
INSERT INTO mnh_vpl VALUES ("H22_6","083_2_6","2TH","2","6","6","Yé ngɔngɔ asœ, 'e wusœ œrœ á sœ kœpakata she ye, dœ mara adœke tshe matœ ye yé. Ataa, tshe matœ ye kolœ dœ lɔkɔ á Ndjaba guma. ");
INSERT INTO mnh_vpl VALUES ("H22_7","083_2_7","2TH","2","7","7","Gbambanœ nene, gbɔgbɔ nœ uzunœ asœmœ tetœ kœmbœrœ akwa yaa ugurutœ azu ye. Kashe akwanœ asœmœ œ wuta ngbɨ nene œrrr adœke uzu á tshe pakata Ekpe Uzunœ kɔrɔ awa fœ she yekane. ");
INSERT INTO mnh_vpl VALUES ("H22_8","083_2_8","2TH","2","8","8","Yé Ekpe Uzu œ matœ ye, Gbozu Yisu œ uru ɨzɨ ga tœ ye adœke tshe tshu yé œ ndɨ tshelœ ye lœ awa nœ ɨshirɨ nœ kœkwa she. ");
INSERT INTO mnh_vpl VALUES ("H22_9","083_2_9","2TH","2","9","9","Tœ upu nœ kœna Ekpe Uzunœ, kœnanœ œ sœ lœ awa akwa nœ Satana, œ matœ ye lœ awa nœ tshelœ áká akwa nœ gbɔgbɔ, dœ afá œdœ œrœ kœbɨlɨ dœ azu, ");
INSERT INTO mnh_vpl VALUES ("H22_10","083_2_10","2TH","2","10","10","œdœ lœ awa nœ mara tshelœ áká kœbɨlɨ osho kɔ á sœsœ ndjii nene mbœrœ azu á endje sœ lœ ala awa nœ kuzu. Gbambanœ nene, endje vwaratœ endje tœ adja o'o nœ Ndjaba á li má adœke œ she endje. ");
INSERT INTO mnh_vpl VALUES ("H22_11","083_2_11","2TH","2","11","11","Mbœrœ tœnœ ataa, Ndjaba vwa gbɔgbɔ nœ djingili á sœ kœmbœrœ adœke endje yindœ o'o nœ wala. ");
INSERT INTO mnh_vpl VALUES ("H22_12","083_2_12","2TH","2","12","12","Ataa, azu kɔ á endje sœsœ dœ kœyindœrœ mbœrœ adja 'o nene, kashe á sœ dœ yanga kœmbœrœ ekperœ, endje wa ɔgbɔ ngbanga ga tœ endje. ");
INSERT INTO mnh_vpl VALUES ("H22_13","083_2_13","2TH","2","13","13","Tœ a'a nœ 'a, alaya, œ li adœke 'a za kolœ mershe fœ Ndjaba ɔlɔ dœ ɔlɔ mbœrœ 'e á Gbozu yindœ 'e. Gbambanœ nene, Ndjaba ke 'e ɓalima katshatsha utshunœ adœke 'e gbɔ kœshe, yé 'e wuta ayerœ azu lœ awa nœ Ɔtshɔ Ɨshirɨ œdœ ndje kœyindœrœ lœ adja o'o. ");
INSERT INTO mnh_vpl VALUES ("H22_14","083_2_14","2TH","2","14","14","Mbœrœ tœnœ dá tshe e 'e kœgbɔ œtœnœ lœ awa nœ Ɔtshɔ O'o á 'a mɨndœ nœ fœ 'e. Tshe yindœ nœ adœke 'e gbɔ mokɔ awa bale dœ Gbozu nœ azœ dœ Yisu Kristu. ");
INSERT INTO mnh_vpl VALUES ("H22_15","083_2_15","2TH","2","15","15","Yé ataa, alaya, 'e shi gbɨ yé œ gbɔndœ kœyisœrœ á 'a yisœ nœ fœ 'e œdœ dœ ama 'a œdœ ala mbeti á 'a su. ");
INSERT INTO mnh_vpl VALUES ("H22_16","083_2_16","2TH","2","16","16","Kaka Gbozu nœ azœ dœ Yisu Kristu dœ tœ ye œdœ Aba azœ dœ Ndjaba á tshe yindœ azœ, tshe mbœrœ adœke lœ awa nœ ɔtshɔ lɔsu nœ ye, tshe to gbɔgbɔ waa dœ waa fœ azœ yé œ mbœrœ adœke a ko lɔsu azœ ga pa ɔtshɔrœ á wuta ɓa mbatsha. ");
INSERT INTO mnh_vpl VALUES ("H22_17","083_2_17","2TH","2","17","17","Kaka endje to gbɔgbɔ fœ azœ adœke 'a sœ kœmbœrœ kolœ ɔtshɔrœ œdœ kœpa ndje kolœ ɔtshɔ o'o. ");
INSERT INTO mnh_vpl VALUES ("H23_1","083_3_1","2TH","3","1","1","Ɓa tœ ndɔngɔlɔnœ kɔ, alaya, 'e za avwala mbœrœ 'a, yeka á o'o ama Gbozu nœ azœ kœna ga utshunœ dœ mara adœke azu donga œtœnœ ɓata á sœ ndje ɓa ndœ 'e. ");
INSERT INTO mnh_vpl VALUES ("H23_2","083_3_2","2TH","3","2","2","'E za ndje avwala fœ Ndjaba adœke tshe vwara 'a lœma ekpe azu dœ ahawo azu. Gbambanœ nene, œ dœ́dœ́ azu kɔ dá sœ dœ kœyindœrœ nene. ");
INSERT INTO mnh_vpl VALUES ("H23_3","083_3_3","2TH","3","3","3","Gbozu sœ kœmbœrœ œrœ nœ ye lindœ o'o ama ye. Tshe to gbɔgbɔ fœ 'e yé œ gbɔndœ 'e tshakane Ekpe Uzu. ");
INSERT INTO mnh_vpl VALUES ("H23_4","083_3_4","2TH","3","4","4","'A sœ kœza lɔsu 'a ga ndœ Gbozu tœ upu nœ 'e: o'o á 'a za fœ 'e, 'e sœ kœmbœrœ tœnœ zœ yé 'e te lœma kœmbœrœ tœnœ ye. ");
INSERT INTO mnh_vpl VALUES ("H23_5","083_3_5","2TH","3","5","5","Kaka Gbozu guma lɔsu 'e adœke 'e sœ dœ kœyindœsho ga ndœ Ndjaba œdœ ga ndœ kœshi gbɨ nœ Kristu. ");
INSERT INTO mnh_vpl VALUES ("H23_6","083_3_6","2TH","3","6","6","Alaya, 'a sœ kœmɨndœ nœ fœ 'e dœ ɨ'ɨrɨ Gbozu Yisu Kristu adœke: 'e gitœ 'e zara tœ aaya kɔ á endje sœ lœ ɔdɔ, á sœsœ kœmbœrœtœ endje liaka o'o á 'a yi lima sœnœ fœ endje nene. ");
INSERT INTO mnh_vpl VALUES ("H23_7","083_3_7","2TH","3","7","7","E'e, 'e wusœ mara á li adœke 'e mbœrœtœ 'e liaka 'a ye. Gbambanœ nene, 'a sœsœ lima ugurutœ 'e lœ ɔdɔ nene. ");
INSERT INTO mnh_vpl VALUES ("H23_8","083_3_8","2TH","3","8","8","'A kakate lima kœzɨrœ nœ uzu bale nene, kashe lœ kœvwi ɨlɨ œdœ kœmɔ, butshɔ dœ ɔlɔ, 'a mbœrœ lima akwa kparawa adœke 'a wuwuta kongba pa kumu anga uzu bale ugurutœ 'e nene. ");
INSERT INTO mnh_vpl VALUES ("H23_9","083_3_9","2TH","3","9","9","Adja 'a li má lima kœ'esho ndœ œrœ tshakane 'e, kashe 'a mbœmbœrœ ataa nene. Gbambanœ nene, 'a yi lima ndœ nœ adœke 'e yamba œrœ á 'a sœ kœmbœrœ tœnœ. ");
INSERT INTO mnh_vpl VALUES ("H23_10","083_3_10","2TH","3","10","10","Yé lɔkɔ á 'a sœ lima ugurutœ 'e, 'a pa lima fœ 'e adœke: «Œdœ uzu kœyiyindœ kœmbœrœ akwa nene, tshe zɨzɨ ndje œrœ nene.» ");
INSERT INTO mnh_vpl VALUES ("H23_11","083_3_11","2TH","3","11","11","Andaa, 'a sœ kœdji adœke, ayi ɔdɔ sœ ugurutœ 'e, œ sœ gbambanœ á sœ kolœ kœli ga lœ o'o nœ azu. ");
INSERT INTO mnh_vpl VALUES ("H23_12","083_3_12","2TH","3","12","12","Mbœrœ azunœ asœmœ, 'a sœ kœza o'o dœ ɔgbɔ dœ ɨ'ɨrɨ Gbozu Yisu Kristu fœ endje adœke: endje mbœrœ akwa dœ lɔsu zɨtɨ yekane á kœzɨ rœgo manda kane endje dœ tœ endje. ");
INSERT INTO mnh_vpl VALUES ("H23_13","083_3_13","2TH","3","13","13","Mbœrœ 'e, alaya, 'e mɔmɔ dœ kœmbœrœ ɔtshɔrœ nene. ");
INSERT INTO mnh_vpl VALUES ("H23_14","083_3_14","2TH","3","14","14","Œdœ uzu kœzaza œneke á 'a pa ga la mbetinœ asœ ga tœ akwa nene, 'e sœ dœ gbɔdjela ga tœ ye yé 'e kpa awa kœsœ awa bale dœ she adœke ala ye kœtshu she. ");
INSERT INTO mnh_vpl VALUES ("H23_15","083_3_15","2TH","3","15","15","'E yiyiangba ye œyi nene, kashe 'e yɔrɔ she ɓata á uzu œ yɔrɔ ayanœ. ");
INSERT INTO mnh_vpl VALUES ("H23_16","083_3_16","2TH","3","16","16","Kaka Gbozu nœ kœsœ gee to kœsœ gee dœ tœ ye fœ 'e butshɔ dœ ɔlɔ œdœ lœ mara kɔ. Kaka Gbozu sœ dœ 'e para kɔkɔ. ");
INSERT INTO mnh_vpl VALUES ("H23_17","083_3_17","2TH","3","17","17","Œmœ Polo dá sú abala fœ 'e dœ kane mœ. Mœ sœ kœza kane mœ ga la mbeti kɔ atake: œtœnœ kœdœ œndœ kane mœ. ");
INSERT INTO mnh_vpl VALUES ("H23_18","083_3_18","2TH","3","18","18","Kaka Gbozu nœ azœ dœ Yisu Kristu ma ɔtshɔ lɔsu nœ ye ga ndœ 'e para kɔkɔ.");
INSERT INTO mnh_vpl VALUES ("T11_1","084_1_1","1TI","1","1","1","Œmœ Polo, mœ kœdœ ayi avwa nœ Yisu Kristu á ayi kœshe azœ dœ Ndjaba œdœ Yisu Kristu á a ko lɔsu azœ ga pa ye, za akwanœ asœ fœ mœ. ");
INSERT INTO mnh_vpl VALUES ("T11_2","084_1_2","1TI","1","2","2","Mœ sœ kœsu mbetinœ asœ fœ ɓœ dœ́ Timote, adja gbolo nœ mœ lœ kœyindœrœ: Kaka adœke Aba azœ dœ Ndjaba œdœ Gbozu nœ azœ dœ Yisu Kristu ma ɔtshɔ lɔsu, kœwu oyo ekperœ œdœ kœsœ gee nœ endje ga ndœ zœ. ");
INSERT INTO mnh_vpl VALUES ("T11_3","084_1_3","1TI","1","3","3","Sœpe lœ ongbo Efeze, ɓata á mœ za lima o'o fœ ɓœ ɔlɔ á mœ yi lima ndœ kœro ga lœ ogo Masedwane. Œ li adœke ɓœ pa o'o dœ ɔgbɔ fœ anga azu á endje sœ kœyisœ anga angbɨ o'o kpi, adœke endje katœ nœ tɨ. ");
INSERT INTO mnh_vpl VALUES ("T11_4","084_1_4","1TI","1","4","4","Pandœ nœ fœ endje adœke endje katœ kœdji ekpe ndœma toro, dœ kœdɨ uwu ɨ'ɨrɨ aata ndjoro. Mbœrœ, œ sœ kœmbœrœ adœke azu le lœma endje yé œ katœ kœmesho ga tœ gbetshelœ nœ Ndjaba á a wusœ nœ lœ awa nœ kœyindœrœ. ");
INSERT INTO mnh_vpl VALUES ("T11_5","084_1_5","1TI","1","5","5","O'o á mœ za tɨ asœ sœ mbœrœ adœke kœyindœsho gerœ, œneke á to tœ œyerœ lɔsu, tœ ɔtshɔ gbetshelœ œdœ tœ adja kœyindœrœ. ");
INSERT INTO mnh_vpl VALUES ("T11_6","084_1_6","1TI","1","6","6","Mbœrœ anga azu katœ œrœnœ asœ tɨ, œ djingili awa, á tetœ kœpa o'o á œsœnœ lɨlɨ nene. ");
INSERT INTO mnh_vpl VALUES ("T11_7","084_1_7","1TI","1","7","7","Endje sœ kœzatœ endje adœke œne kœdœ ayi kœyisœ awa akwa, kashe endje wuwusœ neke kɔ á endje sœ kœyisœ nœ dœ gbɔgbɔ nene. ");
INSERT INTO mnh_vpl VALUES ("T11_8","084_1_8","1TI","1","8","8","A wusœ nœ adœke awa akwa sœ dœ ɔtshɔnœ lœ mara á a mbœrœtœ azœ lindœ nœ. ");
INSERT INTO mnh_vpl VALUES ("T11_9","084_1_9","1TI","1","9","9","Œ li adœke a wusœ neke dœ ɔtshɔnœ adœke: Awa akwa sœsœ mbœrœ azu á endje sœ ndjii nene, kashe œ sœ mbœrœ aayi sharapu dœ aayi gbɔkumu, aayi kœvwaratœ endje tœ Ndjaba dœ aayi kœmbœrœ ekperœ, aayi kœtshapu kœdji Ndjaba dœ kœtsha ndje upu kœlɨsœ œyerœ œrœ, aayi kœwo aaba endje dœ aayi endje, œdœ aayi kœwo azu, ");
INSERT INTO mnh_vpl VALUES ("T11_10","084_1_10","1TI","1","10","10","aayi kœpara awo azu dœ pe aayi kœpara akɔ azu, aayi kœlo dœ ayakoshe anga endje, aayi kœko azu yɔ œrœ, aayi wala, aayi kœdra œrœ wala, œdœ pe endjeneke kɔ á endje vwaratœ endje tœ ɔtshɔ kœyisœrœ. ");
INSERT INTO mnh_vpl VALUES ("T11_11","084_1_11","1TI","1","11","11","Wu œneke á li dœ Ɔtshɔ O'o á to ɓa ndœ Ndjaba á tshe sœ lœ mokɔ dœ yanga. Œshe dá za fœ mœ adœke mœ yisœ nœ. ");
INSERT INTO mnh_vpl VALUES ("T11_12","084_1_12","1TI","1","12","12","Mœ gi mershe fœ Gbozu nœ azœ dœ Yisu Kristu á tshe to gbɔgbɔ fœ mœ ndœ kœmbœrœ dœ akwanœ asœke. Tshe wu lima sœ nœ adœke mœ mbœrœ akwanœ dœ lɔsu mœ bale yekane á ke mœ ndœ akwa nœ ye. ");
INSERT INTO mnh_vpl VALUES ("T11_13","084_1_13","1TI","1","13","13","Ataa mœ kœpa lima ekpe o'o ga tœ ɔkɔ ye, á mbœrœ lima œrœ kanga fœ she, á mbœrœ lima œrœ dœ gbɔkote ga tœ ye, kashe tshe wu oyo mœ mbœrœ œneke á mœ wuwu lima sœ œrœ á li dœ mœ adœke mœ mbœrœ nene yé mœ gugu lima ndje dœ kœyindœrœ nene. ");
INSERT INTO mnh_vpl VALUES ("T11_14","084_1_14","1TI","1","14","14","Ɔtshɔ lɔsu nœ Gbozu nœ azœ sœ ga ndœ mœ tɔpanœ kpuru. Tshe mbœrœ adœke mœ sœ dœ kœyindœrœ œdœ pe kœyindœsho á to lœ kœngbɔtœ azœ dœ Yisu Kristu. ");
INSERT INTO mnh_vpl VALUES ("T11_15","084_1_15","1TI","1","15","15","Wu adja o'onœ á li dœ azu para kɔkɔ kœyindœ nœ dœ lɔsu bale: Kristu Yisu na ga pashɔ mbœrœ kœshe azu á endje mbœrœ ekperœ. Œmœ, mœ kœdœ uzu á ekperœ nœ mœ ropanœ ugurutœ azu kœmbœrœ ekperœnœ asœmœ. ");
INSERT INTO mnh_vpl VALUES ("T11_16","084_1_16","1TI","1","16","16","Kashe Ndjaba wu oyo mœ, œ yindœ nœ adœke Yisu Kristu ma ugu lɔsu nœ ye lœ awa nœ mœ dœ́ uzu á ekperœ nœ mœ ropa œnœ azu kɔ, ɓata kœyisœrœ mbœrœ azu neke á endje sœ dœ kœyindœrœ, á gbɔ soro neke á ka nene. ");
INSERT INTO mnh_vpl VALUES ("T11_17","084_1_17","1TI","1","17","17","Kaka Gbozu á tshe sœ sheko, Ndjaba á tshe tshu nene, á uzu wuwu she nene yé á tshe sœ tshebabale, sœ dœ kœlɨsœtœ œdœ mokɔ waa dœ waa. Ame! ");
INSERT INTO mnh_vpl VALUES ("T11_18","084_1_18","1TI","1","18","18","Timote gbolo nœ mœ, mœ za o'onœ asœke fœ ɓœ lindœ œneke á endje gbara lima tœ upu nœ zœ. O'onœ asœmœ za gbɔgbɔ fœ ɓœ yekane á ɓœ kœnga ɔtshɔ koshe. ");
INSERT INTO mnh_vpl VALUES ("T11_19","084_1_19","1TI","1","19","19","Gbɔndœ kœyindœrœ œdœ ɔtshɔ gbetshelœ. Anga azu vwaratœ endje tœ kœna manda gbetshelœ nœ endje yé œ ndɨ kœyindœrœ nœ endje ga ndœ Yisu. ");
INSERT INTO mnh_vpl VALUES ("T11_20","084_1_20","1TI","1","20","20","Aimini dœ Alekezandre sœ ugurutœ azunœ asœmœ. Mœ ko endje tɨ ga tshakane Satana mbœrœ á endje kœwusœ nœ adœke œ lili dœ endje kœgu œsœ́ Ndjaba nene. ");
INSERT INTO mnh_vpl VALUES ("T12_1","084_2_1","1TI","2","1","1","Mœ sœ kœza o'o utshunœ kɔ adœke ayindœ Yisu yɔndœ œrœ ga ndœ Ndjaba, œ za avwala nœ endje fœ she yé œ kɨ ga tœ ye dœ́ œ za ndje mershe fœ she mbœrœ azu para kɔkɔ. ");
INSERT INTO mnh_vpl VALUES ("T12_2","084_2_2","1TI","2","2","2","Œ li adœke endje za avwala fœ Ndjaba tœ upu nœ agbozu nœ Lita œdœ agbozu tshapa akwa kɔ adœke kœsœ nœ azœ sœ lœ kœsœ gee yeka a kœkpa awa Ndjaba lœ kœzatœ azœ dœ mara á li fœ she. ");
INSERT INTO mnh_vpl VALUES ("T12_3","084_2_3","1TI","2","3","3","Wu œrœ á sœ tœ ɔtshɔnœ, á za yanga fœ Ayi kœshe azœ dœ Ndjaba, ");
INSERT INTO mnh_vpl VALUES ("T12_4","084_2_4","1TI","2","4","4","á tshe yindœ nœ adœke azu para gbɔ kœshe yé œ li kœwusœ adjapu. Œtœnœ dœmœ. ");
INSERT INTO mnh_vpl VALUES ("T12_5","084_2_5","1TI","2","5","5","Gbambanœ nene, Ndjaba sœ tshebale yé ayi kœguma tshagurutœ ye dœ azu ndje bale. Uzunœ kœdœ Yisu Kristu, ");
INSERT INTO mnh_vpl VALUES ("T12_6","084_2_6","1TI","2","6","6","á tshe zatœ ye fœ kuzu mbœrœ kœshe azu kɔ lœ kanga. Tshe mbœrœ dœ lɔkɔnœ á li tœ kœma adœke Ndjaba yindœ kœshe azu para kɔkɔ. ");
INSERT INTO mnh_vpl VALUES ("T12_7","084_2_7","1TI","2","7","7","Mbœrœ tœnœ dá Ndjaba ke mœ adœke mœ dœ uzu kœpandœ ama œne, ayi avwa nœ œne. Mœ wuta ayi kœyisœrœ fœ angbɨ azu adœke endje sœ dœ kœyindœrœ ga ndœ Yisu, œdœ kœyi ndje sœ adja o'o. Mœ sœ kœpa adja o'o, mœ papa wala nene. ");
INSERT INTO mnh_vpl VALUES ("T12_8","084_2_8","1TI","2","8","8","Mœ yindœ nœ adœke tœ osho kɔ á ayakoshe œ za avwala nœ endje fœ Ndjaba, endje sœ lɔsu endje ngbɨ lɔkɔ á endje sœ kœtɨ kane endje ga lafo. Endje katœ ókó yé œ lele lœ ama endje nene. ");
INSERT INTO mnh_vpl VALUES ("T12_9","084_2_9","1TI","2","9","9","Mœ yi ndje ndœ nœ adœke ayashe verœ lœba nœ endje dœ mara á li, á sœ dœ ɔtshɔnœ kashe dœ egerœ kumu nene yé œ mbœrœ kumu endje dœ mara á sœ dœ ɔtshɔnœ. Endje katœ kœguma kumu endje dœ œrœ nœ ɔrœ, dœ ɔgbɔ akidji œdœ pe ndje kœverœ lœba á amanœ ropa nœ ye. ");
INSERT INTO mnh_vpl VALUES ("T12_10","084_2_10","1TI","2","10","10","Kashe endje guma ɔkɔ endje dœ kœmbœrœ ɔtshɔrœ ɓata mara á li dœ ayashe á endje sœ kœpa adœke œne sœ kœkpa awa Ndjaba. ");
INSERT INTO mnh_vpl VALUES ("T12_11","084_2_11","1TI","2","11","11","Dœ lɔkɔ kœyambarœ, œ li adœke yashe sœ koko yé œ zatœ ye ga atɨ. ");
INSERT INTO mnh_vpl VALUES ("T12_12","084_2_12","1TI","2","12","12","Mœ zaza awa fœ yashe adœke tshe yisœ œrœ, ndje adœke tshe dœ gbozu ga pa yakoshe nene. Kashe œ li adœke tshe sœ koko. ");
INSERT INTO mnh_vpl VALUES ("T12_13","084_2_13","1TI","2","13","13","Gbambanœ nene, Ndjaba mbœrœ lima Adamo utshunœ yekane á mbœrœ Eva manda nœ. ");
INSERT INTO mnh_vpl VALUES ("T12_14","084_2_14","1TI","2","14","14","Yé œ dœ́dœ́ Adamo dá Satana bɨlɨ lima she utshunœ nene, kashe yashe dá tshe bɨlɨ lima she yekane á tshe li lima ga lœ ekperœ. ");
INSERT INTO mnh_vpl VALUES ("T12_15","084_2_15","1TI","2","15","15","Kashe œdœ yashe kœgbɔndœ kœyindœrœ œdœ kœyindœsho, á kœsœ yerœ yé á sœ ndjii tœ ala Ndjaba, adja Ndjaba œ she she lœ kœzu agbolo nœ ye. ");
INSERT INTO mnh_vpl VALUES ("T13_1","084_3_1","1TI","3","1","1","Wu adja o'onœ á li dœ azu para kɔkɔ: Œdœ uzu kœpara awa kœte gbozu tshapa Ikrizia, dá tshe yindœ ɔtshɔ akwa. ");
INSERT INTO mnh_vpl VALUES ("T13_2","084_3_2","1TI","3","2","2","Œ li adœke gbozu tshapa Ikrizia dœ uzu á endje gbagbagbara she nene. Tshe dœ ɔkɔ yashe bale, gbozu pa undu ye dœ tœ ye, uzu nœ ɔtshɔ gbetshelœ, uzu á œsœ́ ye lɨ, uzu nœ kœza osho kœsœ fœ agene œdœ uzu á tshe li kœyisœ œrœ, ");
INSERT INTO mnh_vpl VALUES ("T13_3","084_3_3","1TI","3","3","3","tshe dœ́dœ́ kanga nœ ipi nene, ayi kœyi awa ga lœ azu nene, kashe tshe dœ uzu á tshe sœ lɔsu ye zɨtɨ, tshe dœ́dœ́ ayi œbœrœ too ayi egerœ lɔsu ga pa ngendja nene. ");
INSERT INTO mnh_vpl VALUES ("T13_4","084_3_4","1TI","3","4","4","Œ li adœke tshe wusœ kœgbɔndœ azu tshelœ bɨngɨ nœ ye dœ tœ ye yé œ yisœ œrœ fœ agbolo nœ ye adœke endje dji upu dœ lɔsu endje bale. ");
INSERT INTO mnh_vpl VALUES ("T13_5","084_3_5","1TI","3","5","5","Uzu neke á tshe wuwusœtœ ye tœ kœgbɔndœ azu tshelœ bɨngɨ nœ ye nene, tshe gbɔndœ azu tshelœ Ikrizia nœ Ndjaba kotoo? ");
INSERT INTO mnh_vpl VALUES ("T13_6","084_3_6","1TI","3","6","6","Uzunœ dœ́dœ́ uzu á tshe fatshalɔsu ye ngɔngɔ nene, ete nene tshe tetœ kœdu okoro ye yé Ndjaba œ wa agbɔ ngbanga ga tœ ye ɓata á tshe wa lima ga tœ Satana. ");
INSERT INTO mnh_vpl VALUES ("T13_7","084_3_7","1TI","3","7","7","Œ li adœke azu á endje gugu lœ Ikrizia nene pa ɔtshɔ o'o tœ mara ɔtshɔ ye, mbœrœ á tshe kœgbɔgbɔ tshula nene yé á tshe kœtete lœ gbanda nœ djaboro nene. ");
INSERT INTO mnh_vpl VALUES ("T13_8","084_3_8","1TI","3","8","8","Œ li ndje adœke aayi akwa tshelœ Ikrizia dœ azu á œsœ́ endje lɨ, á endje sœ ndjii lœ o'o endje. Œ lili adœke endje dœ akanga nœ ipi nene œdœ ndje azu nœ kœgbɔ ngendja lœ ekpe awa nene. ");
INSERT INTO mnh_vpl VALUES ("T13_9","084_3_9","1TI","3","9","9","Œ li adœke endje sœ dœ ɔtshɔ gbetshelœ lœ kœyindœrœ ga ndœ o'o á Ndjaba mɨndœ nœ. ");
INSERT INTO mnh_vpl VALUES ("T13_10","084_3_10","1TI","3","10","10","Œ li adœke endje tondœ endje utshunœ, manda nœ œdœ endje kœwuwu ekperœ lœ endje nene yeka á endje kœmbœrœ akwa nœ aayi akwa Ikrizianœ. ");
INSERT INTO mnh_vpl VALUES ("T13_11","084_3_11","1TI","3","11","11","Awo endje awa bale ndje, endje dœ ayashe á œsœ́ endje lɨ, á endje dœ́dœ́ aayi parœ nene, agbozu tshapa undu endje dœ tœ endje, yé endje zatœ endje lindœ nœ lœ œrœ kɔ. ");
INSERT INTO mnh_vpl VALUES ("T13_12","084_3_12","1TI","3","12","12","Œ li adœke ayi akwa lœ Ikrizia dœ ɔkɔ yashe bale yé œ wusœ kœgbɔndœ agbolo nœ ye dœ pe azu bɨngɨ nœ ye para kɔkɔ. ");
INSERT INTO mnh_vpl VALUES ("T13_13","084_3_13","1TI","3","13","13","Gbambanœ nene, ayi akwa lœ Ikrizia á tshe sœ kœmbœrœ akwa nœ ye dœ ɔtshɔnœ, azu œ lɨsœ endje yé endje pa o'o dœ awa nene lœ kœyindœrœ ga ndœ Yisu Kristu. ");
INSERT INTO mnh_vpl VALUES ("T13_14","084_3_14","1TI","3","14","14","Mœ sœ kœsu mbetinœ fœ ɓœ dœ gbetshelœ adœke mœ yi kumu mœ ga ndœ zœ lœ ondonœ asœke. ");
INSERT INTO mnh_vpl VALUES ("T13_15","084_3_15","1TI","3","15","15","Ataa œndœ mœ kœsœpe kœdɨ tœnœ damba, mœ su mbetinœ asœke fœ ɓœ adœke ɓœ wusœ mara nœ á li dœ uzu kœgbɔndœtœ ye dœ tœ ye ugurutœ azu bɨngɨ nœ Ndjaba. Bɨngɨnœ asœmœ kœdœ Ikrizia nœ Ndjaba nœ soro, á sœ ɓata sharagunda dœ pe œrœ á sœ kœgbɔndœ adja o'o. ");
INSERT INTO mnh_vpl VALUES ("T13_16","084_3_16","1TI","3","16","16","Adjapu, o'onœ á a yindœ nœ, á za lima tœ ye yiwa tœnœ, sœ dœ egerœnœ. Œtœnœ dœke: Kristu na œ matœ ye lœ ɔkɔ uzu, Ɔtshɔ Ɨshirɨ pandœ nœ adœke œshe kœdœ uzu á tshe sœ ndjii, yé aandjelu wu lima she ye, endje mɨndœ ye fœ angbɨ azu, azu ndjoro yindœ ye pa ɔshɔ, Ndjaba za she ga lœ mokɔ ɓa lafo. ");
INSERT INTO mnh_vpl VALUES ("T14_1","084_4_1","1TI","4","1","1","Ɔtshɔ Ɨshirɨ sœ kœpa ngbɨ adœke: Dœ lɔkɔ kœka tshapashɔ bala, anga azu œ katœ awa kœyindœrœ nœ endje tɨ, œ te manda ɨshirɨ nœ afara dœ pe kœyisœrœ nœ adjabro. ");
INSERT INTO mnh_vpl VALUES ("T14_2","084_4_2","1TI","4","2","2","Ekpe azu dœ pe aayi kœpa wala œ fara endje dœ o'o ama endje. Afara nœ aayi walanœ ndɨ gbetshelœ nœ endje. ");
INSERT INTO mnh_vpl VALUES ("T14_3","084_4_3","1TI","4","3","3","Endje sœ kœpakata azu tœ kœtotœ endje, œ sœ kœpakata azu tœ kœzɨ anga kœzɨrœ. Andaa Ndjaba dá mbœrœ kœzɨrœ. Ayindœ Yisu á endje wusœ adja o'o lindœ kœzɨ tœnœ yé œ za mershe fœ she. ");
INSERT INTO mnh_vpl VALUES ("T14_4","084_4_4","1TI","4","4","4","Mbœrœ œrœ kɔ á Ndjaba mbœrœ sœ tœ ɔtshɔnœ, œneke á endje pakata nœ gugu nene œdœ a kœsœ kœzɨ tœnœ lœ kœgi mershe fœ Ndjaba. ");
INSERT INTO mnh_vpl VALUES ("T14_5","084_4_5","1TI","4","5","5","Gbambanœ nene, o'o ama Ndjaba œdœ avwala sœ kœmbœrœ adœke œrœnœ asœmœ sœ yerœ. ");
INSERT INTO mnh_vpl VALUES ("T14_6","084_4_6","1TI","4","6","6","Œdœ ɓœ kœyisœ o'o asœ kɔ fœ aaya œdœ aayingɔ, ɓœ te bala ɔtshɔ ayi akwa nœ Yisu Kristu. Asœke œ ma adœke ɓœ te manda o'o nœ kœyindœrœ œdœ pe ɔtshɔrœ á endje yisœ nœ fœ ɓœ dœ ɔtshɔnœ. ");
INSERT INTO mnh_vpl VALUES ("T14_7","084_4_7","1TI","4","7","7","Kashe œ li adœke ɓœ vwaratœ zœ tœ kœdji ekpe ndœma toro nœ ayawaza á sœ kpi tœ kœyindœrœ. Kashe zatœ zœ djigi fœ Ndjaba. ");
INSERT INTO mnh_vpl VALUES ("T14_8","084_4_8","1TI","4","8","8","Kœkpa ɔrɔ á uzu sœ kœkpa tœnœ adœke tshelœ ɔkɔ œne sœ hara, œ sœ yara tœ ɔtshɔnœ; kashe kœzatœ osho djigi fœ Ndjaba dá ropa œrœ kɔ. Gbambanœ nene, uzu á tshe zatœ ye djigi fœ Ndjaba, tshe gbɔ soro nœ kpesheke dœ œnœ tshambatsha. ");
INSERT INTO mnh_vpl VALUES ("T14_9","084_4_9","1TI","4","9","9","Wu adja o'onœ á li dœ azu para kɔkɔ kœyindœ nœ dœ lɔsu bale. ");
INSERT INTO mnh_vpl VALUES ("T14_10","084_4_10","1TI","4","10","10","Gbambanœ nene, œdœ a kœsœ kœwu oyo yé á sœ kœnga koshe, œ sœ mbœrœ a za lɔsu azœ djigi ga tœ Ndjaba nœ soro, á tshe dœ Ayi kœshe azu para kɔkɔ, kashe ayindœ Yisu kœropa nœ. ");
INSERT INTO mnh_vpl VALUES ("T14_11","084_4_11","1TI","4","11","11","Wu œneke á li adœke ɓœ mɨndœ nœ, yé œ yisœ nœ. ");
INSERT INTO mnh_vpl VALUES ("T14_12","084_4_12","1TI","4","12","12","Uzu bale yiyiangba zœ mbœrœ á ɓœ dœ gbolo modo nene, kashe ma ɔtshɔ ɔtshɔ zœ ga ndœ ayindœ Yisu, lœ o'o zœ, lœ kœsœ ɓœ, lœ kœyindœsho nœ zœ, lœ kœyindœrœ nœ zœ œdœ lœ kœsœ yerœ nœ zœ. ");
INSERT INTO mnh_vpl VALUES ("T14_13","084_4_13","1TI","4","13","13","Kœka œrrr ga tœ kœkwa mœ, zatœ zœ ko ga tœ kœdɨ Buku nœ Ndjaba, kœmɨ upu ndœ nœ œdœ kœyisœ nœ. ");
INSERT INTO mnh_vpl VALUES ("T14_14","084_4_14","1TI","4","14","14","Kakatœ kœza gbɔgbɔ nœ Ɔtshɔ Ɨshirɨ á sœ lœ zœ ga tœ akwa nene. Tœ nœ kœdœ gbɔgbɔ á ɓœ gbɔ lima lɔkɔ kœgbara o'o tœ upu nœ zœ, á agbozu Ikrizia to lima kane endje ga pa zœ. ");
INSERT INTO mnh_vpl VALUES ("T14_15","084_4_15","1TI","4","15","15","Gbe dœ kœmbœrœ œrœnœ asœke dœ ɔtshɔnœ yé zatœ zœ kɔ ndœ nœ mbœrœ azu kɔ kœwusœ mara á ɓœ sœ kœgerœ tœnœ lœ Yisu. ");
INSERT INTO mnh_vpl VALUES ("T14_16","084_4_16","1TI","4","16","16","Gbɔndœtœ zœ dœ tœ zœ œdœ ndje dœ kœyisœrœ nœ zœ dœ ɔtshɔnœ kane yé œ ru lɔsu zœ lœ œrœ kɔ. Mbœrœ lœ awa nœ kœmbœrœ atamœ dá ɓœ shetœ zœ dœ tœ zœ œdœ ndje azu á endje sœ kœdji ɓœ. ");
INSERT INTO mnh_vpl VALUES ("T15_1","084_5_1","1TI","5","1","1","Mɨmɨ upu dœ ɔgbɔ o'o fœ yagbozu nene, kashe mɨ upu fœ she ɓata aba zœ. Mɨ upu fœ amodo ɓata aaya zœ, ");
INSERT INTO mnh_vpl VALUES ("T15_2","084_5_2","1TI","5","2","2","fœ ayawaza ɓata aayi zœ, fœ ayawuru ɓata ayingɔ zœ, lœ kœsœ yerœ nœ zœ. ");
INSERT INTO mnh_vpl VALUES ("T15_3","084_5_3","1TI","5","3","3","Lɨ œsœ ayashe koya, endjeneke á endje dœ́ adja ayashe koya. ");
INSERT INTO mnh_vpl VALUES ("T15_4","084_5_4","1TI","5","4","4","Kashe yashe koya neke á tshe sœ dœ agbolo too dœ aatanœ, œ li adœke endje za kœyindœrœ nœ endje ga tœ akwa ga ndœ azu tshelœ adja bɨngɨ nœ endje yé œ mbœrœ œneke á li adœke endje mbœrœ fœ aayi kœzu endje too fœ aata endje. Gbambanœ nene, asœmœ dá sœ dœ ɔtshɔnœ utshu Ndjaba. ");
INSERT INTO mnh_vpl VALUES ("T15_5","084_5_5","1TI","5","5","5","Yashe koya neke á tshe dœ adja yashe koya, á tshe gugu dœ uzu kœgbɔndœ ye nene, tshe za lɔsu ga tœ Ndjaba. Tshe eshondœ œrœ ɓa ndœ ye, œ kɨ fœ she butshɔ dœ ɔlɔ. ");
INSERT INTO mnh_vpl VALUES ("T15_6","084_5_6","1TI","5","6","6","Kashe ayashe koya á endje kœsœ kolœ dœ yanga œrœ tshapashɔ, ataa endje sœ dœ soro gbaa, endje tshu lœ ɨshirɨ endje ye. ");
INSERT INTO mnh_vpl VALUES ("T15_7","084_5_7","1TI","5","7","7","Wu œneke á li adœke ɓœ mɨndœ nœ, mbœrœ á endje kœmbœrœtœ endje adœke azu kœgbagbara endje nene. ");
INSERT INTO mnh_vpl VALUES ("T15_8","084_5_8","1TI","5","8","8","Œdœ uzu kœwuwusœ kœgbɔndœ bɨngɨ nœ ye nene, adja azu neke á endje sœ sœnda nœ ye, dá tshe vwaratœ ye tœ kœyindœrœ yé tshe kœdœ ekpe uzu kœropa uzu á tshe yiyindœ Ndjaba nene. ");
INSERT INTO mnh_vpl VALUES ("T15_9","084_5_9","1TI","5","9","9","Yashe á endje sú ɨ'ɨrɨ ye gala mbeti nœ ayashe koya, kœdœ yashe á tshe sœ dœ ungu kœto kpœpa zazu votɔ, á i lima kolœ yakoshe bale. ");
INSERT INTO mnh_vpl VALUES ("T15_10","084_5_10","1TI","5","10","10","Œ li adœke azu wusœ ye dœ ɔtshɔ akwa nœ ye: tshe dœ yashe neke á tshe gbɔ lima ndœ agbolo, á tshe sœ kœza osho kœsœ fœ azu, á tshe sœ kœdjutɔ ada ayindœ Yisu yé á sœ kœgbe dœ azu á endje sœ lœ oyo. Tshe dœ ndje yashe á tshe li tœ kœmbœrœ tshelœ aka ɔtshɔrœ kɔ. ");
INSERT INTO mnh_vpl VALUES ("T15_11","084_5_11","1TI","5","11","11","Kashe susu ɨ'ɨrɨ avoro ayashe koya nene, mbœrœ lɔkɔ á endje kœsœ dœ ogo nœ ɔkɔ, endje vwaratœ endje tœ Kristu yé œ kpa yindœ kœi ayakoshe. ");
INSERT INTO mnh_vpl VALUES ("T15_12","084_5_12","1TI","5","12","12","Ataa, Ndjaba œ wa ɔgbɔ ngbanga ga tœ endje mbœrœ á endje ndɨ tshelœ ali o'o á endje wa lima. ");
INSERT INTO mnh_vpl VALUES ("T15_13","084_5_13","1TI","5","13","13","Gapa nœ, ɓata endje sœsœ dœ akwa bale kœmbœrœ tœnœ nene, endje sœ kœna ana yoo yoo djelœ manda azu, kœpu lœma endje, kœli ga lœ o'o á dœ́dœ́ œnœ endje nene dœ kœpa o'o neke á gaga nene. ");
INSERT INTO mnh_vpl VALUES ("T15_14","084_5_14","1TI","5","14","14","Mbœrœ tœnœ ataa, mœ yindœ nœ adœke avoro ayashe koya kpa i ayakoshe, œ zu agbolo, œ gbɔndœ tshasœnda nœ endje, mbœrœ ayingba azœ kœgbɔgbɔ awa kœpatœ osho nene. ");
INSERT INTO mnh_vpl VALUES ("T15_15","084_5_15","1TI","5","15","15","Gbambanœ nene, ɨlɨ anga endje djingili awa yé œ te manda Satana. ");
INSERT INTO mnh_vpl VALUES ("T15_16","084_5_16","1TI","5","16","16","Œdœ anga yashe á tshe yindœ Yisu kœsœ dœ ayingɔnœ á endje dœ ayashe koya, œ li adœke tshe to œrœ fœ endje; tshe kakatœ endje tɨ tœ Ikrizia nene, mbœrœ adœke Ikrizia kœgbe dœ endjeneke á endje dœ adja ayashe koya. ");
INSERT INTO mnh_vpl VALUES ("T15_17","084_5_17","1TI","5","17","17","Agbozu Ikrizia neke á endje lœ kœko ala endje tœ ayindœ Yisu dœ ɔtshɔnœ, endje li adja kœgbɔ kœlɨsœtœ awa bisha, mbœrœ endje sœ kœzatœ endje ga tœ akwa nœ o'o ama Ndjaba yé œ sœ kœyisœ nœ. ");
INSERT INTO mnh_vpl VALUES ("T15_18","084_5_18","1TI","5","18","18","Mbeti nœ Ndjaba pa adœke: «Œdœ 'e kœsœ kœwa ngwarœ dœ ngombe lœ kɨndɨ, i i ama ye ga tœnœ nene, yé œ li adœke ayi akwa gbɔ œrœ tshangba akwa nœ ye.» ");
INSERT INTO mnh_vpl VALUES ("T15_19","084_5_19","1TI","5","19","19","Tœ kœwa ngbanga pa gbozu Ikrizia, œ li adœke atimu bisha too votɔ yindœ o'onœ yekane á ɓœ kœwa ngbanganœ. Ete nene, œ li dœ ɓœ kœvwaratœ zœ tœ mezanœ á endje tɔ pa ye asœmœ ye. ");
INSERT INTO mnh_vpl VALUES ("T15_20","084_5_20","1TI","5","20","20","Azu á endje sœ kœmbœrœ ekperœ, za ala endje tœ ala azu kɔ, á kœza ndje awa fœ anga udu azu kœmbœrœ ndje ekperœ. ");
INSERT INTO mnh_vpl VALUES ("T15_21","084_5_21","1TI","5","21","21","Mœ sœ kœyu ɓœ dœ ɔgbɔ ɓa utshu Ndjaba, ɓa utshu Yisu Kristu œdœ pe ɓa utshu aandjelu nœ Ndjaba adœke, ɓœ mbœrœtœ zœ lindœ œrœnœ asœke kɔ, dœ anga angbɨ gbetshelœ á sœ utshunœ nene, yé œ yindœ azu kɔ awa bale. ");
INSERT INTO mnh_vpl VALUES ("T15_22","084_5_22","1TI","5","22","22","Toto kane zœ katsha ga pa uzu á tshe yindœ kœmbœrœ akwa fœ Ndjaba nene. Lili ndje ga lœ ekperœ nœ azu nene. Gbɔndœtœ zœ adœke ɓœ sœ yerœ. ");
INSERT INTO mnh_vpl VALUES ("T15_23","084_5_23","1TI","5","23","23","Ndjondjo kolœ ungu nene. Kashe ndjo ndje vinu teasho mbœrœ koɓa tshelœ nœ zœ, mbœrœ á ɓœ sœ ndje kœte kpɔɔkpɔɔ dœ koɓa. ");
INSERT INTO mnh_vpl VALUES ("T15_24","084_5_24","1TI","5","24","24","Anga azu lœ zœ á ekperœ nœ endje sœ ngbɨ utshu kœwa ngbanga pa endje kashe ɓa ndœ anga endje, a wusœ ekperœ nœ endje kolœ manda kœwa ngbanga pa endje. ");
INSERT INTO mnh_vpl VALUES ("T15_25","084_5_25","1TI","5","25","25","Awa bale ndje, ɔtshɔ akwa sœ kœmatœ endje ngbɨ kashe á lili kœmatœ endje nene, œ za ndje tœ endje yiwa tœnœ nene. ");
INSERT INTO mnh_vpl VALUES ("T16_1","084_6_1","1TI","6","1","1","Azu neke kɔ á endje dœ́ akanga, œ li adœke endje lɨsœ ayengɔ endje lœ œrœ kɔ, mbœrœ adœke azu kœgugusœ ɨ'ɨrɨ Ndjaba œdœ kœyisœrœ nœ azœ nene. ");
INSERT INTO mnh_vpl VALUES ("T16_2","084_6_2","1TI","6","2","2","Akanga má agbozu tshapa endje kœdœ ayindœ Yisu, endje vwavwaratœ endje kœlɨsœ ayengɔ endje mbœrœ adœke endje kœdœ alaya endje nene. Kashe, endje kpa mbœrœ ɔtshɔ akwa fœ endje kœropa nœ, mbœrœ ayengɔ endje á endje sœ kœtɨ kane endje dœ akwa galafo, endje kœdœ ayindœ Yisu á endje kɔ, endje yindœtœ endje. Wu o'o á li adœke ɓœ yisœ nœ, œ za o'o mbœrœ tœnœ. ");
INSERT INTO mnh_vpl VALUES ("T16_3","084_6_3","1TI","6","3","3","Œdœ anga uzu kœna dœ angbɨ kœyisœrœ, á kœsœsœ liaka o'o nœ adja o'o nœ Gbozu nœ azœ Yisu Kristu nene, too dœ kœyisœrœ nœ azu á li dœ kœyindœrœ nœ azœ nene, ");
INSERT INTO mnh_vpl VALUES ("T16_4","084_6_4","1TI","6","4","4","uzu nœ asœmœ kœdœ uzu á kœzatœ osho bu ala ye. Tshe kœdœ uzu á tshe wuwusœ œrœ nene, ayi koɓa nœ sharapu á tshe sœ kœpara awa ndœ kœgbugburu tshelœ o'o gbambanœ. Œrœnœ kɔ asœmœ sœ kœza awa fœ úkú, kœbœrœtœ azu pa o'o, kœgu osho, ekpe gbetshelœ, ");
INSERT INTO mnh_vpl VALUES ("T16_5","084_6_5","1TI","6","5","5","kœbœrœtœ azu pa o'o á ádánœ gugu nene ugurutœ azu á kœwusœrœ nœ endje fu. Endje kpa sœsœ kœwu adja o'o nene yé œ gbe adœke kœzatœ uzu fœ Ndjaba kœdœ kœte ayi kœgbɔ ukpulu œrœ. ");
INSERT INTO mnh_vpl VALUES ("T16_6","084_6_6","1TI","6","6","6","Œ dœ́ adjapu adœke kœzatœ uzu fœ Ndjaba kœdœ kœte ayi kœgbɔ ukpulu œrœ kashe œ li adœke uzu za lɔsu ye ga pa œneke á tshe sœ dœ tœnœ. ");
INSERT INTO mnh_vpl VALUES ("T16_7","084_6_7","1TI","6","7","7","Mbœrœ a na lima tshakane azœ gbambanœ ga pashɔ, awa bale a gu ndje tshakane azœ gbambanœ. ");
INSERT INTO mnh_vpl VALUES ("T16_8","084_6_8","1TI","6","8","8","Yé œdœ a kœsœ dœ kœzɨrœ, œdœ a kœsœ dœ lœba kœverœ ga tœ azœ, œ li dœ azœ kolœnœ ataa. ");
INSERT INTO mnh_vpl VALUES ("T16_9","084_6_9","1TI","6","9","9","Kashe azu neke á endje yindœ kœgbɔ ukpulu œrœ, endje li ga lœ afara. Endje yo ga lœ ama úkú mbœrœ ogo ɨndɨ nœ endje dœ ekperœ, á ndɨ azu yé á mbœrœ adœke azu djingili awa. ");
INSERT INTO mnh_vpl VALUES ("T16_10","084_6_10","1TI","6","10","10","Gbambanœ nene, ekperœ kɔ to lœ kœsœ dœ egerœ lɔsu ngendja. Anga ɨlɨ azu para awanœ, œ gitœ endje zara lœ kœyindœrœ nœ endje. Endje shokɔ o'o ga tœ ɔkɔ endje dœ tœ endje. ");
INSERT INTO mnh_vpl VALUES ("T16_11","084_6_11","1TI","6","11","11","Kashe œɓœ, uzu nœ Ndjaba, kpa awa œrœnœ kɔ asœke. Para awa tœ kœsœ ndjii, kœzatœ zœ fœ Ndjaba, kœsœ dœ kœyindœrœ, kœsœ dœ kœyindœsho, ugu lɔsu œdœ pe kœsœ dœ lɔsu zɨtɨ. ");
INSERT INTO mnh_vpl VALUES ("T16_12","084_6_12","1TI","6","12","12","Nga ɔtshɔ koshe tœ upu nœ kœyindœrœ, tepa soro á ka nene dœ ɔgbɔ, á Ndjaba e ɓœ ndœ nœ yé á ɓœ pa lima o'o kœyindœrœ utshu azu ndjoro. ");
INSERT INTO mnh_vpl VALUES ("T16_13","084_6_13","1TI","6","13","13","Atamœ, mœ sœ kœza o'o fœ ɓœ utshu Ndjaba á tshe za soro fœ œrœ kɔ, dœ Yisu Kristu á tshe pa lima ɔtshɔ o'o ngbɨ tœ upu nœ kœyindœrœ lɔkɔ á Pose Pilato sœ lima kœwa ngbanga pa ye, mœ za o'o fœ ɓœ adœke: ");
INSERT INTO mnh_vpl VALUES ("T16_14","084_6_14","1TI","6","14","14","gbɔndœ awa akwa á ɓœ gbɔ, sœ yerœ adœke azu gbagbagbara ɓœ nene œrrr ga tœ lɔkɔ kœkwa Gbozu nœ azœ dœ Yisu Kristu, ");
INSERT INTO mnh_vpl VALUES ("T16_15","084_6_15","1TI","6","15","15","á Ndjaba œ ma dœ lɔkɔ á tshe guma. Ndjaba kœdœ Gbozu nœ gbɔgbɔ kɔ, Gbozu nœ yanga kɔ, Gbozugo nœ agbozugo œdœ Gbozu nœ agbozu, ");
INSERT INTO mnh_vpl VALUES ("T16_16","084_6_16","1TI","6","16","16","kolœ œshe á tshe wuwu kuzu nene, tshe sœ lœ ɔlɔ á uzu bale œ li kœwuta ɓa zœ nene. Uzu bale á tshe wu lia she gugu nene yé uzu á tshe li kœwu ndje she gugu nene. Kaka mokɔ œdœ gbɔgbɔ á ka nene sœ fœ she! Ame. ");
INSERT INTO mnh_vpl VALUES ("T16_17","084_6_17","1TI","6","17","17","Mɨ upu fœ ayi kœgbɔ ukpulu œrœ ɓa pa ɔshɔ adœke endje dudu okoro endje nene yé œ zaza lɔsu endje djigi ga pa œrœ á œndœnœ œ dɨ nene, kashe endje za lɔsu endje ga pa Ndjaba, á tshe sœ kœto œrœ fœ azu adœke endje sœ dœ yanga mbœrœ tœnœ. ");
INSERT INTO mnh_vpl VALUES ("T16_18","084_6_18","1TI","6","18","18","Za o'o fœ endje adœke endje mbœrœ ɔtshɔ akwa, endje te ayi ukpulu œrœ lœ ɔtshɔ akwa yé œ sœ hara hara tœ kœkurutshelœ œrœ nœ endje dœ anga azu. ");
INSERT INTO mnh_vpl VALUES ("T16_19","084_6_19","1TI","6","19","19","Atamœ, endje gbɔ ɔtshɔrœ á œndœnœ œ dɨ mbœrœ endje dœ tœ endje bala mbatsha, mbœrœ kœtepa adja soro. ");
INSERT INTO mnh_vpl VALUES ("T16_20","084_6_20","1TI","6","20","20","Uu Timote, gbɔndœ kœyisœrœ á endje yi lima sœ nœ fœ ɓœ dœ ɔtshɔnœ kane. Kpa awa kœpa o'o ngbɨlɨ ngbɨlɨ á sœ kœyiangba Ndjaba œdœ o'o á azu gbe adœke œtœnœ kœdœ adja kœwusœrœ, kashe œ dœ́dœ́ tœnœ nene. ");
INSERT INTO mnh_vpl VALUES ("T16_21","084_6_21","1TI","6","21","21","Anga azu gbe lima adœke œne sœ dœ mara kœwusœrœ atamœ, œ gitœ endje zara lœ kœyindœrœ nœ endje. Kaka ɔtshɔ lɔsu nœ Ndjaba sœ dœ 'e.");
INSERT INTO mnh_vpl VALUES ("T21_1","085_1_1","2TI","1","1","1","Œmœ Polo, œmœ kœdœ ayi avwa nœ Yisu Kristu á Ndjaba ke mœ, á vwa mœ kœpa fœ azu tœ upu nœ soro á tshe pa lima ndœ nœ lœ awa nœ Yisu Kristu. ");
INSERT INTO mnh_vpl VALUES ("T21_2","085_1_2","2TI","1","2","2","Mœ sœ kœsu mbetinœ fœ ɓœ Timote á ɓœ dœ́ gbolo nœ mœ á mœ yindœ zœ waa. Kaka ɔtshɔ lɔsu dœ kœdjerœndœ ekperœ œdœ pe kœsœ gee nœ Ndjaba Aba dœ Yisu Kristu Gbozu nœ azœ, sœ dœ ɓœ. ");
INSERT INTO mnh_vpl VALUES ("T21_3","085_1_3","2TI","1","3","3","Mœ sœ kœgi mershe fœ Ndjaba kœgbe dœ mara á aata mœ donga lima she, yé mœ kpa donga ndje she dœ gbetshelœ á sœ yerœ. Butshɔ dœ ɔlɔ á mœ sœ kœza avwala nœ mœ fœ she, mœ kakatœ kœgbe dœ ɓœ nene. ");
INSERT INTO mnh_vpl VALUES ("T21_4","085_1_4","2TI","1","4","4","Mœ kœgbe dœ ngola zœ á tu lima, ngbewo mœ kpa sœ dœ ogo nœ kœwu ɓœ yeka á lɔsu mœ kœsœ dœ yanga. ");
INSERT INTO mnh_vpl VALUES ("T21_5","085_1_5","2TI","1","5","5","Mœ sœ ndje kœgbe dœ mara adja kœyindœrœ nœ zœ. Œneke á sœ lima lœ ata zœ dœ Loyisi dœ pe ayi zœ dœ Enise, endje dá sœ lima dœ kœyindœrœnœ asœmœ utshu zœ. Mœ yindœ nœ adœke tœnœ dá sœ ndje adja lœ zœ. ");
INSERT INTO mnh_vpl VALUES ("T21_6","085_1_6","2TI","1","6","6","Mbœrœ tœnœ ataa, mœ za o'o fœ ɓœ adœke ɓœ mbœrœ adœke, gbɔgbɔ á Ndjaba za fœ ɓœ ndœ kœmbœrœ dœ akwa pe dœ lɔkɔ á mœ to lima kane mœ ga pa zœ asœmœ, kpa djedjerowa nene. ");
INSERT INTO mnh_vpl VALUES ("T21_7","085_1_7","2TI","1","7","7","Gbambanœ nene, œ dœ́dœ́ Ɨshirɨ nœ awa dá Ndjaba za fœ azœ nene kashe tshe za Ɨshirɨ á tshe mbœrœ adœke a sœ dœ gbɔgbɔ, dœ kœyindœsho œdœ ndje kœdœ agbozu ga pa undu azœ. ");
INSERT INTO mnh_vpl VALUES ("T21_8","085_1_8","2TI","1","8","8","Sœsœ dœ tshula tœ kœpandœ o'o tœ upu nœ Gbozu nœ azœ nene, sœsœ ndje dœ tshula tœ mœ dœ́ ayi kánga tœ upu nœ ye nene. Kashe dœ awa nœ gbɔgbɔ á Ndjaba za fœ ɓœ, œ li adœke ɓœ wu oyo awa bale dœ mœ ndœ kœgbara Ɔtshɔ O'onœ. ");
INSERT INTO mnh_vpl VALUES ("T21_9","085_1_9","2TI","1","9","9","Tshe she azœ yeka á e azœ adœke á dœ azu nœ ye. Œ dœ́dœ́ mbœrœ akwa nœ azœ nene, kashe liaka œneke á tshe guma katshatsha œdœ ndje ɔtshɔ lɔsu nœ ye. Tshe ma lima ɔtshɔ lɔsunœ fœ azœ lœ ngbɔtœ nœ azœ dœ Yisu Kristu utshu kœmbœrœ tshapashɔ. ");
INSERT INTO mnh_vpl VALUES ("T21_10","085_1_10","2TI","1","10","10","Ndjaba ma ɔtshɔ lɔsu nœ ye ngbɨ lœ awa nœ kœna Ayi kœshe azœ dœ Yisu Kristu ga pa ɔshɔ. Œshe dá wo gbɔgbɔ nœ kuzu, á gbara o'o nœ soro á ka nene lœ awa nœ Ɔtshɔ O'o. ");
INSERT INTO mnh_vpl VALUES ("T21_11","085_1_11","2TI","1","11","11","Mbœrœ tœnœ dá Ndjaba ke mœ adœke mœ dœ uzu kœpandœ ama œne, ayi avwa nœ œne œdœ ayi kœyisœrœ. ");
INSERT INTO mnh_vpl VALUES ("T21_12","085_1_12","2TI","1","12","12","Mbœrœ tœnœ dá mœ sœ kœwu oyonœ kɔ asœke. Kashe mœ sœsœ dœ tshula nene mbœrœ mœ wusœ tsheneke á mœ za lɔsu mœ ga pa ye. Mœ wusœ nœ adœke tshe sœ dœ gbɔgbɔ kœgbɔndœ œneke á tshe to fœ mœ œrrr ga tœ lɔkɔ kœwa ngbanga pa azu. ");
INSERT INTO mnh_vpl VALUES ("T21_13","085_1_13","2TI","1","13","13","Na kolœ manda adja o'o á mœ yisœ nœ fœ ɓœ, yé ka ngbɨrɨ lœ kœyindœrœ dœ pe kœyindœsho á a gbɔ lœ ngbɔtœ nœ azœ dœ Yisu Kristu. ");
INSERT INTO mnh_vpl VALUES ("T21_14","085_1_14","2TI","1","14","14","Dœ awa nœ Ɔtshɔ Ɨshirɨ á tshe sœ lœ azœ, gbɔndœ Ɔtshɔ O'onœ á endje yi lima sœ nœ fœ ɓœ dœ ɔtshɔnœ kane. ");
INSERT INTO mnh_vpl VALUES ("T21_15","085_1_15","2TI","1","15","15","Ɓata á ɓœ wusœ nœ, azu kɔ á endje sœ lœ Azi katœ mœ tɨ para kɔkɔ. Fijele ndje dœ Ermojene lœ ndje ugurutœ endje. ");
INSERT INTO mnh_vpl VALUES ("T21_16","085_1_16","2TI","1","16","16","Kaka Gbozu wu oyo azu lœ bɨngɨ nœ Onezifore, mbœrœ tshe sœ kœu mœ ga tœnœ waa yé tshe sœsœ dœ tshula mbœrœ á mœ sœ lœ kánga nene. ");
INSERT INTO mnh_vpl VALUES ("T21_17","085_1_17","2TI","1","17","17","Gbambanœ nene, kolœ kœyi kuma ye ga lœ Roma, tshe para mœ œrrr yé, œ gbɔ mœ. ");
INSERT INTO mnh_vpl VALUES ("T21_18","085_1_18","2TI","1","18","18","Kaka Gbozu Ndjaba wu oyo ye dœ lɔkɔ kœwa ngbanga pa azu. Œɓœ dœ tœ zœ ndje ɓœ wusœ œneke kɔ á tshe mbœrœ lima fœ mœ ɓa lœ ongbo Efeze ye. ");
INSERT INTO mnh_vpl VALUES ("T22_1","085_2_1","2TI","2","1","1","Kashe œɓœ, gbolo nœ mœ, kaka ɔtshɔrœ á Yisu Kristu to fœ ɓœ, za gbɔgbɔ fœ ɓœ. ");
INSERT INTO mnh_vpl VALUES ("T22_2","085_2_2","2TI","2","2","2","Œrœ á ɓœ dji mœ kœmɨndœ nœ utshu azu ndjoro, yisœ nœ fœ azu á endje li adœke endje yi ndje sœ nœ fœ anga azu. ");
INSERT INTO mnh_vpl VALUES ("T22_3","085_2_3","2TI","2","3","3","Wu ndje œsœ́ œnœ zœ oyonœ mbœrœ Yisu Kristu ɓata ɔtshɔ turugu. ");
INSERT INTO mnh_vpl VALUES ("T22_4","085_2_4","2TI","2","4","4","Uzu á tshe mbœrœ akwa turugu, tshe kpa li ga lœ o'o nœ azu á endje dœ́dœ́ aturugu nene, kashe tshe para kolœ awa nœ kœza yanga fœ gbozu nœ ye. ");
INSERT INTO mnh_vpl VALUES ("T22_5","085_2_5","2TI","2","5","5","Awa bale ɓa ndœ ayi kœkpa ɔrɔ, uzu á tshe wuta utshunœ kœdœ uzu neke á tshe mbœrœtœ ye liaka awa akwa nœ ɔrɔ. ");
INSERT INTO mnh_vpl VALUES ("T22_6","085_2_6","2TI","2","6","6","Ayi kœdjo kɨndɨ neke á tshe shi kɔ'dɔɔ lœma akwa kɨndɨ nœ ye, œshe dá dœ uzu utshunœ kœzɨ ngwarœnœ. ");
INSERT INTO mnh_vpl VALUES ("T22_7","085_2_7","2TI","2","7","7","Dji o'o á mœ pa asœ dœ ɔtshɔnœ: Gbozu dœ tœ ye dá to kœwusœrœ nœ kœdji tshelœ katanœ kɔ fœ ɓœ dœ ɔtshɔnœ. ");
INSERT INTO mnh_vpl VALUES ("T22_8","085_2_8","2TI","2","8","8","Gbe dœ Yisu Kristu á tshe to lœ aata Davidi, á tshe she lœ akuzu. Œneke á Ɔtshɔ O'onœ pa tœnœ á mœ sœ kœpandœ nœ. ");
INSERT INTO mnh_vpl VALUES ("T22_9","085_2_9","2TI","2","9","9","Mœ sœ kœwu oyo lœ kumunœ, yé mbœrœ tœnœ dá endje i mœ dœ djingiri ɓata uzu kœmbœrœ ngbɨndɨrœ, kashe endje li kœi o'o ama Ndjaba nene! ");
INSERT INTO mnh_vpl VALUES ("T22_10","085_2_10","2TI","2","10","10","Mbœrœ tœnœ ataa, mœ sœ kœru lɔsu mœ lœ œrœ kɔ mbœrœ azu á Ndjaba ke endje adœke endje gbɔ kœshe á Yisu Kristu to yé endje li ga lœ mokɔ nœ waa dœ waa. ");
INSERT INTO mnh_vpl VALUES ("T22_11","085_2_11","2TI","2","11","11","O'onœ asœke kœdœ adjapu: Œdœ a kœtshu dœ she, a sœ dœ soro awa bale dœ she. ");
INSERT INTO mnh_vpl VALUES ("T22_12","085_2_12","2TI","2","12","12","Œdœ á kœshi gbɨ, a wuta agbozu awa bale dœ she. Œdœ a kœvwaratœ azœ tœ ye, tshe vwara ndje tœ ye tœ azœ. ");
INSERT INTO mnh_vpl VALUES ("T22_13","085_2_13","2TI","2","13","13","Œdœ a kœzazatœ azœ lindœ o'o ama ye nene, tshe zatœ ye lindœ nœ, mbœrœ tshe li kœvwaratœ ye tœ undu ye dœ tœ ye nene. ");
INSERT INTO mnh_vpl VALUES ("T22_14","085_2_14","2TI","2","14","14","Pa fœ azu, endje gbe dœ o'onœ asœke. Kpa pa fœ endje utshu Ndjaba adœke endje zazatœ endje ga tœ kœgbugburu tshelœ o'o gbambanœ á ádánœ gugu nene yé œ sœ kolœ kœndɨ azu á endje sœ kœdji tœnœ. ");
INSERT INTO mnh_vpl VALUES ("T22_15","085_2_15","2TI","2","15","15","Mbœrœ kɔ adœke ɓœ wuta uzu á tshe li tœ ala Ndjaba yé, yisœ adja o'o ɓata ayi akwa neke á tshe li kœgbɔ tshula lœma akwa nœ ye nene. ");
INSERT INTO mnh_vpl VALUES ("T22_16","085_2_16","2TI","2","16","16","Kpa awa kœpa o'o ngbɨlɨ ngbɨlɨ á sœ kœyiangba Ndjaba, mbœrœ azu kœpa o'onœ asœmœ vwaratœ endje tœ Ndjaba. ");
INSERT INTO mnh_vpl VALUES ("T22_17","085_2_17","2TI","2","17","17","Kœyisœrœ nœ endje sœ ɓata uku á dele katshakatsha. Mœ gbe dœ Imini œdœ Filete ugurutœ azu asœmœ. ");
INSERT INTO mnh_vpl VALUES ("T22_18","085_2_18","2TI","2","18","18","Endje katœ adja o'o yé œ sœ kœpa wala fœ azu adœke kœshe lœ akuzu nœ azu mbœrœ ɓalima tœ endje ye. Ataa, endje sœ kœndɨ tshelœ kœyindœrœ nœ anga azu. ");
INSERT INTO mnh_vpl VALUES ("T22_19","085_2_19","2TI","2","19","19","Kashe kiti anda neke á Ndjaba tɔ, œ ka ngbɨrɨ. Gapa nœ dœmœ, endje sú ala Mbeti adœke: «Gbozu wusœ endje nœ ye», yé: «Uzu kɔ á tshe pa adœke œne kœdœ uzu nœ Gbozu, œ li adœke tshe vwaratœ ye tœ ekperœ.» ");
INSERT INTO mnh_vpl VALUES ("T22_20","085_2_20","2TI","2","20","20","Ɓa lœ egerœ anda, œ dœ́dœ́ kolœ gbarœ á endje mbœrœ dœ ɔrœ œdœ ngendja dá sœ lœnœ nene. Anga gbara á endje mbœrœ dœ ɔyɔ œdœ ɔshɔ œ sœ ndje zœ. Anga gbarœ sœ mbœrœ angbo kpi yekane anganœ sœ mbœrœ akwa kɔ. ");
INSERT INTO mnh_vpl VALUES ("T22_21","085_2_21","2TI","2","21","21","Œdœ uzu kœvwaratœ ye tœ ekperœ kɔ, uzunœ wuta ɓata gbarœ á sœ ga angbo di, á li tœ ala ayengɔnœ yé á li ndje ndœ kœmbœrœ dœ ɔtshɔ akwa kɔ. ");
INSERT INTO mnh_vpl VALUES ("T22_22","085_2_22","2TI","2","22","22","Kpa awa ogo œrœ tshagbolo, para awa kœsœ ndjii, kœyindœrœ, kœyindœsho, kœsœ gee dœ azu má endje sœ dœ ɔtshɔ lɔsu, á sœ kœza avwala fœ Gbozu. ");
INSERT INTO mnh_vpl VALUES ("T22_23","085_2_23","2TI","2","23","23","Vwaratœ zœ tœ kœgbugburu tshelœ o'o nœ gbambanœ mbœrœ œ sœ kœgbota azu ga lœ œbœrœ waa. ");
INSERT INTO mnh_vpl VALUES ("T22_24","085_2_24","2TI","2","24","24","Mbœrœ ayi akwa nœ Gbozu lili kœbœrœtœ ye dœ azu nene, kashe œ li dœ she kœsœ dœ lɔsu ye zɨtɨ ga ndœ azu para kɔkɔ. Tshe wusœ kœyisœ œrœ, œ wu ndje sœ kœru lɔsu ye. ");
INSERT INTO mnh_vpl VALUES ("T22_25","085_2_25","2TI","2","25","25","Azu á endje sœ kœshara o'o lœ ama ye, œ li dœ she kœpara awa nœ kœyisœ œrœ fœ endje dœ lɔsu zɨtɨ. Anganœ, Ndjaba œ mbœrœ adœke endje fatshalɔsu endje yé œ wusœ adja o'o. ");
INSERT INTO mnh_vpl VALUES ("T22_26","085_2_26","2TI","2","26","26","Yé endje kpa gbɔ gbetshelœ á sœ ndjii, œ wuta lœ gbanda nœ djaboro á tshe te lima pa endje adœke endje mbœrœ kolœ gbetshelœ nœ œne. ");
INSERT INTO mnh_vpl VALUES ("T23_1","085_3_1","2TI","3","1","1","Wusœ nœ dœ ɔtshɔnœ adœke, osho sœ tœ ɔgbɔnœ mbœrœ tœ kœka tshapashɔ. ");
INSERT INTO mnh_vpl VALUES ("T23_2","085_3_2","2TI","3","2","2","Gbambanœ nene, azu œ dœ aayi otoro, aayi egerœ lɔsu ga pa ngendja, aayi kœdonga tœ endje, aayi egerœ kumu, aayi kœgu œsœ Ndjaba, azu á endje lɨsœ aayi kœzu endje nene, azu á endje wusœ kœgi mershe nene yé œ kpa ndje awa Ndjaba nene. ");
INSERT INTO mnh_vpl VALUES ("T23_3","085_3_3","2TI","3","3","3","Ala endje œ ɔrɔ yé endje wu oyo uzu bale nene, œ dœ aayi kœpa ngbɨndɨ o'o ga tœ azu, aayi djipudji, aayi kœmbœrœ ɔgbɔrœ ga tœ azu, ayingba ɔtshɔrœ. ");
INSERT INTO mnh_vpl VALUES ("T23_4","085_3_4","2TI","3","4","4","Aayi kœva ɔtɔ anga endje, aayi ókó, aayibula lœ egerœ kumu nœ endje, aayi kœyindœ tshapashɔ kœropa Ndjaba. ");
INSERT INTO mnh_vpl VALUES ("T23_5","085_3_5","2TI","3","5","5","Endje matœ endje ɓata aayi kœkpa awa Ndjaba kashe endje wuwusœ gbɔgbɔ nœ ye nene. Kpa awa mara azu ataa. ");
INSERT INTO mnh_vpl VALUES ("T23_6","085_3_6","2TI","3","6","6","Anga azu ugurutœ endje œ li gasœnda, œ gbota ayashe á endje mɔɔmɔ, yé œ bɨlɨ endje adœke endje yindœ o'o nœ œne. Ayashenœ asœmœ mbœrœ ekperœ waa, gbetshelœ nœ endje sœ dœ ogo kœmbœrœ ekperœ kɔ. ");
INSERT INTO mnh_vpl VALUES ("T23_7","085_3_7","2TI","3","7","7","Endje sœ kœyamba œrœ waa kashe endje lili kœwusœ adja o'o nene. ");
INSERT INTO mnh_vpl VALUES ("T23_8","085_3_8","2TI","3","8","8","Aayi kœyisœrœ nœ walanœ asœmœ vwaratœ endje tœ adja o'o ɓata Ayane dœ Yambele vwara lima tœ endje tœ o'o ama Moyize. Endje kœdœ azu á kœwusœrœ nœ endje fu, á ádá kœyindœrœ nœ endje gugu nene, ");
INSERT INTO mnh_vpl VALUES ("T23_9","085_3_9","2TI","3","9","9","kashe endje na ga utshunœ nene mbœrœ azu kɔ œ wusœ nœ adœke, endje ndɨ lœ gbetshelœ nœ endje awa bale ɓata endje wu lima sœ ɨndɨ Ayane dœ Yambele. ");
INSERT INTO mnh_vpl VALUES ("T23_10","085_3_10","2TI","3","10","10","Kashe œɓœ, ɓœ dji mœ dœ ɔtshɔnœ lœ kœyisœrœ nœ mœ, ɓœ wusœ ɔtshɔ mœ, dœ œrœ á mœ gbe kœmbœrœ tœnœ, dœ kœyindœrœ nœ mœ, dœ ugu lɔsu nœ mœ, dœ kœyindœsho nœ mœ, dœ kœshi gbɨ nœ mœ lœ awa akwa, ");
INSERT INTO mnh_vpl VALUES ("T23_11","085_3_11","2TI","3","11","11","ɓœ wusœ œrœ kanga œdœ oyo má mœ wu ɓa lœ Atiɔshe, ɓa lœ Ikoniyume, œdœ pe ɓa lœ Listre, œrœ kanga gaɗe dá mœ wuwu nene a! Kashe, Gbozu she mœ lœ nœ kɔ. ");
INSERT INTO mnh_vpl VALUES ("T23_12","085_3_12","2TI","3","12","12","Adjapu, azu kɔ á endje yindœ kœna manda Yisu Kristu, á yindœ kœzatœ endje djigi fœ Ndjaba, endje wu kanga. ");
INSERT INTO mnh_vpl VALUES ("T23_13","085_3_13","2TI","3","13","13","Kashe akpe azu dœ pe aayi kœbɨlɨ osho, endje li vwerema ga lœ ekperœ, endje bɨlɨ anga azu yé œ bɨlɨtœ endje dœ tœ endje. ");
INSERT INTO mnh_vpl VALUES ("T23_14","085_3_14","2TI","3","14","14","Kashe ɓœ, sœ kolœ kœna manda œrœ á ɓœ yamba á yindœ nœ dœ lɔsu zœ bale asœmœ. Ɓœ wusœ uzunœ á tshe yisœ nœ fœ ɓœ dœ ɔtshɔnœ. ");
INSERT INTO mnh_vpl VALUES ("T23_15","085_3_15","2TI","3","15","15","Ɓœ wusœ œyerœ Buku nœ Ndjaba pe dœ gbolo zœ, œ li tœ kœto kœwusœtœ á na dœ ɓœ œrrr ga lœ kœshe lœ awa nœ kœyindœrœ ga ndœ Yisu Kristu. ");
INSERT INTO mnh_vpl VALUES ("T23_16","085_3_16","2TI","3","16","16","Œneke kɔ á endje sú ala Buku nœ Ndjaba asœmœ, endje sú lœ awa nœ Ɔtshɔ Ɨshirɨ. Bukunœ asœmœ li tœ kœyisœrœ, kœma ekperœ ngbɨ, kœyɔrɔ uzu œdœ kœmbœrœ adœke uzu wuta tœ ɔtshɔnœ tœ ala Ndjaba, ");
INSERT INTO mnh_vpl VALUES ("T23_17","085_3_17","2TI","3","17","17","yeka á uzu nœ Ndjaba kœgumatœ ye dœ ɔtshɔnœ, á kœli tœ kœmbœrœ kolœ ɔtshɔ akwa. ");
INSERT INTO mnh_vpl VALUES ("T24_1","085_4_1","2TI","4","1","1","Mœ sœ kœpa ngbɨ fœ ɓœ, utshu Ndjaba, dœ pe utshu Yisu Kristu á tshe kwa bala tœ ye ndœ kœwa ngbanga nœ asoro dœ akuzu, lœ gbetshelœ nœ kpa kœkwa she œdœ ndje kœsœ Gbozu pa œrœ kɔ. ");
INSERT INTO mnh_vpl VALUES ("T24_2","085_4_2","2TI","4","2","2","Mɨndœ o'o ama Ndjaba, mbœrœ ɔlɔ dœ ɔlɔ yé kaka tœnœ nene. Azu dji too endje dji nene, sœpe kœyisœ nœ. Yɔrɔ endje, za ala endje yé œ mɨ upu fœ endje. Mbœrœ œneke kɔ dœ ugu lɔsu lœ awa nœ kœyisœrœ nœ zœ. ");
INSERT INTO mnh_vpl VALUES ("T24_3","085_4_3","2TI","4","3","3","Gbambanœ nene, dœ anga lɔkɔ bale, endje li tœ kœru lɔsu endje ndœ kœdji kœyisœrœ nœ adja o'o nene, mbœrœ gbetshelœ nœ endje sœ kolœ kœna manda ogo undu endje dœ tœ endje. Mbœrœ tœnœ ataa, endje œ ko aayi kœyisœrœ ndjoro, endjeneke á o'o ama endje sœ kolœ kœga tœ endje. ");
INSERT INTO mnh_vpl VALUES ("T24_4","085_4_4","2TI","4","4","4","Endje be utu endje ga tœnœ tœ kœdji adja o'o, yé œ fatœ endje kolœ ndœ kœdji ndœma toro. ");
INSERT INTO mnh_vpl VALUES ("T24_5","085_4_5","2TI","4","5","5","Kashe ɓœ, œ li adœke ɓœ dœ gbozu tshapa undu zœ dœ tœ zœ lœ œrœ kɔ. Sœ dœ kœru lɔsu lœ kœwu oyo, mɨndœ Ɔtshɔ O'o fœ azu yé œ mbœrœ akwa á Ndjaba za fœ ɓœ dœ ɔtshɔnœ djigi kane. ");
INSERT INTO mnh_vpl VALUES ("T24_6","085_4_6","2TI","4","6","6","Mbœrœ mœ, ɔlɔ kuzu mœ ndo ye. Mœ za soro mœ ɓata tokóró fœ Ndjaba. ");
INSERT INTO mnh_vpl VALUES ("T24_7","085_4_7","2TI","4","7","7","Mœ nga ɔtshɔ koshe. Mœ wuta ga tœ ndɔngɔlɔ ɔrɔ nœ mœ, mœ sœ kolœ kœgbɔndœ kœyindœrœ. ");
INSERT INTO mnh_vpl VALUES ("T24_8","085_4_8","2TI","4","8","8","Ngɔngɔ asœke, œrœ tshangba ɔtshɔ akwanœ á mœ mbœrœ sœ kœkatœ mœ zœ. Gbozu á tshe kœdœ ayi kœwa adja ngbanga dá za fœ mœ dœ lɔkɔ kœwa ngbanganœ asœmœ. Tshe za œrœ tshangba ɔtshɔ akwanœ kolœ fœ mœ dœ kutɨ mœ nene, kashe tshe za ndje fœ endjeneke kɔ á endje sœ kœkate kœkwa she. ");
INSERT INTO mnh_vpl VALUES ("T24_9","085_4_9","2TI","4","9","9","Mbœrœ kɔ adœke ɓœ na kœgbɔtœ zœ dœ mœ katsha. ");
INSERT INTO mnh_vpl VALUES ("T24_10","085_4_10","2TI","4","10","10","Gbambanœ nene, Demasi katœ mœ tɨ ye, mbœrœ á tshe yindœ œrœ tshapashɔ nœ asœke. Tshe ro ga lœ Tesalonike, Kresene ro ga lœ Galate yé Tito ro œne ye ga lœ Dalamati. ");
INSERT INTO mnh_vpl VALUES ("T24_11","085_4_11","2TI","4","11","11","Kolœ Lukasi dá sœpe dœ mœ kpœke. Œ kœsœ adœke ɓœ na gamœ asœke, za Marke potœ zœ mbœrœ á sthe kœtɨ kane mœ lœ akwa nœ Ndjaba. ");
INSERT INTO mnh_vpl VALUES ("T24_12","085_4_12","2TI","4","12","12","Mœ vwa Tishike ga lœ Efeze. ");
INSERT INTO mnh_vpl VALUES ("T24_13","085_4_13","2TI","4","13","13","Kœna ɓœ, za lœba ɨzɨ á mœ katœnœ ɓa lœ Trowase ɓa ndœ Karposi, œ na dœ tœnœ fœ mœ. Ko ndje bukunœ na tœnœ fœ mœ, kœropanœ kɔ, œneke á endje mbœrœ dœ ɔkɔ agea. ");
INSERT INTO mnh_vpl VALUES ("T24_14","085_4_14","2TI","4","14","14","Alekezandre, ayi ndawonœ, mbœrœ ekperœ fœ mœ waa. Gbozu œ gi tshangba œneke á tshe mbœrœ fœ mœ kœ li dœ ekperœ nœ ye asœmœ zœ. ");
INSERT INTO mnh_vpl VALUES ("T24_15","085_4_15","2TI","4","15","15","Œɓœ ndje, tɨtœ zœ tœ ye mbœrœ á tshe vwaratœ ye tœ œrœnœ kɔ á a yi lima sœ nœ. ");
INSERT INTO mnh_vpl VALUES ("T24_16","085_4_16","2TI","4","16","16","Ali kœka mœ ga utshu ayi kœwa ngbanga, uzu bale nana manda mœ nene, endje katœ mœ tɨ kɔ. Kaka Ndjaba gbegbe dœ ekperœ nœ endje nene. ");
INSERT INTO mnh_vpl VALUES ("T24_17","085_4_17","2TI","4","17","17","Kashe Gbozu sœ lima dœ mœ awa bale. Œshe dá to gbɔgbɔ nœ ye fœ mœ yeka á mœ mɨndœ o'o nœ ye ga tœ ndɔngɔlɔ nœ. Endje neke kɔ á endje dœ́dœ́ Ayuda nene, dji yé Ndjaba she mœ lœ ama bamara. ");
INSERT INTO mnh_vpl VALUES ("T24_18","085_4_18","2TI","4","18","18","Gbozu œ she mœ lœ oyo kɔ, œ mbœrœ adœke mœ li ga lœ ogo tshagbozu nœ ye ɓa lafo. Kaka adœke azu za mokɔ fœ she ngbugu dœ ngbugu. Ame! ");
INSERT INTO mnh_vpl VALUES ("T24_19","085_4_19","2TI","4","19","19","Za abala nœ mœ fœ Prisile dœ Akilase œdœ pe ndje azu lœ bɨngɨ nœ Onezifore. ");
INSERT INTO mnh_vpl VALUES ("T24_20","085_4_20","2TI","4","20","20","Eraste sœpe ɓa lœ Koriti yé mœ ka ndje tœ Trofime ɓa lœ Mile mbœrœ á tshe sœ lima dœ koɓa. ");
INSERT INTO mnh_vpl VALUES ("T24_21","085_4_21","2TI","4","21","21","Mbœrœ kɔ adœke ɓœ wuta ɓa ke utshu nœ yapu nœ ɨzɨ. Ebule, dœ Pudese, dœ Linuse, dœ Klodia, ndje dœ pe ayindœ Yisu kɔ bala ɓœ. ");
INSERT INTO mnh_vpl VALUES ("T24_22","085_4_22","2TI","4","22","22","Kaka Gbozu sœ dœ ɓœ. Kaka ɔtshɔ lɔsu nœ Ndjaba sœ dœ 'e para kɔkɔ.");
INSERT INTO mnh_vpl VALUES ("TT1_1","086_1_1","TIT","1","1","1","Œmœ Polo, œmœ kœdœ ayi akwa nœ Ndjaba œdœ ayi avwa nœ Yisu Kristu á tshe e mœ mbœrœ kœyisœ œrœ fœ azu á Ndjaba ke endje, adœke endje sœ dœ kœyindœrœ ga ndœ ye yé œ wusœ adjapu lœ kœzatœ endje fœ she. ");
INSERT INTO mnh_vpl VALUES ("TT1_2","086_1_2","TIT","1","2","2","Mœ sœ kœmbœrœ akwa mbœrœ endje wusœ nœ adœke, œne gbɔ soro neke á ka nene, á Ndjaba pa lima ndœ nœ katshatsha utshu nœ kœmbœrœ tshapashɔnœ asœ, adœke œne za lima fœ endje. Tshe kœdœ Ndjaba á tshe fafa tshelœ ama ye nene. ");
INSERT INTO mnh_vpl VALUES ("TT1_3","086_1_3","TIT","1","3","3","Tshe za o'o ama ye ga tœ awa akwa liaka olo á tshe guma. Ayi kœshe azœ dœ Ndjaba dá za o'o ama ye fœ mœ yeka á vwa mœ adœke mœ mɨndœ nœ. ");
INSERT INTO mnh_vpl VALUES ("TT1_4","086_1_4","TIT","1","4","4","Mœ sœ kœsu mbetinœ asœ fœ ɓœ dœ́ Tito, adja gbolo nœ mœ lœ kœyindœrœ á a sœ dœ tœnœ ga ndœ Yisu Kristu. Kaka Ndjaba Aba œdœ Yisu Kristu ayi kœshe azœ, ma ɔtshɔ lɔsu nœ endje ga ndœ zœ œ za kœsœ gee nœ endje fœ ɓœ. ");
INSERT INTO mnh_vpl VALUES ("TT1_5","086_1_5","TIT","1","5","5","Œdœ mœ kœkatœ zœ ɓa lœ Kelete, œ sœ mbœrœ ɓœ guma œneke á sœpe adœke ɓœ guma, yé œ ke agbozu Ikrizia lakpɨ bale dœ bale liaka awa akwa á mœ pandœ nœ fœ ɓœ. ");
INSERT INTO mnh_vpl VALUES ("TT1_6","086_1_6","TIT","1","6","6","Œ li adœke ɔtshɔ gbozu sœ dœ ɔtshɔnœ adœke azu lele lœ endje mbœrœ she nene, tshe sœ dœ yashe tshebale, agbolo nœ ye dœ ayindœ Yisu mbœrœ azu kœpapa o'o tœ endje adœke ɔtshɔ endje gaga nene too endje kœdœ aayi sharapu nene. ");
INSERT INTO mnh_vpl VALUES ("TT1_7","086_1_7","TIT","1","7","7","Gbambanœ nene, endje ke gbozu tshelœ Ikrizia adœke tshe ko ala ye tœ œrœ nœ Ndjaba, ádánœ á li adœke azu lele lœ endje mbœrœ she nene dœmœ. Tshe dœ́dœ́ uzu kœzatœ ye nene, uzu ókó nene, uzu kœza ama ye tɨ lœ ipi nene, uzu nœ koshe hawo hawo nene, uzu á tshe sœ kœgbɔ ngendja dœ ekpe awa nene. ");
INSERT INTO mnh_vpl VALUES ("TT1_8","086_1_8","TIT","1","8","8","Kashe tshe dœ uzu kœza osho kœsœ fœ azu sœnda nœ ye, á tshe yindœ ɔtshɔrœ. Tshe dœ uzu nœ ɔtshɔ gbetshelœ á tshe sœ ndjii á sœ ndje yerœ, yé tshe wu ndje sœ kœgbɔndœtœ ye. ");
INSERT INTO mnh_vpl VALUES ("TT1_9","086_1_9","TIT","1","9","9","Œ li dœ she kœzatœ ye kolœ ga tœ o'o á endje yisœ nœ fœ she. Atamœ tshe li tœ kœmɨ upu fœ anga azu lœ adjapu yé œ sɔ akpa aayi kœyisœrœ dœ wala. ");
INSERT INTO mnh_vpl VALUES ("TT1_10","086_1_10","TIT","1","10","10","Gbambanœ nene, azu ndjoro, kœropa nœ kɔ ɨlɨ endje ugurutœ Ayuda á endje te ayindœ Yisu, endje sœsœ kœmbœrœtœ endje liaka kœyisœrœnœ nene, endje sœ kœpa o'o ngbɨlɨ ngbɨlɨ yé endje sœ kœfara azu. ");
INSERT INTO mnh_vpl VALUES ("TT1_11","086_1_11","TIT","1","11","11","Mbœrœ tœnœ ataa, œ li adœke ɓœ mbœrœ adœke endje ngbɔɓa ama endje ga tœnœ. Endje sœ kœndɨ gbetshelœ nœ azu kɔ lœ bɨngɨ, lœ awa nœ kœyisœ œrœ á lili adœke endje yisœ nœ nene, endje yisœ nœ mbœrœ kœgbɔ ngendja. ");
INSERT INTO mnh_vpl VALUES ("TT1_12","086_1_12","TIT","1","12","12","Anga uzu nœ endje bale lœ Kelete á endje wu she ɓata ayi kœgbara o'o, pa lima adœke: «Azu Kelete kœdœ aayi wala, endje kœdœ akatshagea, aayi ɔdɔ yé endje yi kolœ ndœ kœzɨrœ.» ");
INSERT INTO mnh_vpl VALUES ("TT1_13","086_1_13","TIT","1","13","13","O'o kɔ á tshe pa kœdœ adjapu. Ádánœ á li dœ ɓœ kœza ala endje adœke endje sœ dœ adja kœyindœrœ, ");
INSERT INTO mnh_vpl VALUES ("TT1_14","086_1_14","TIT","1","14","14","endje katœ kœdji ndœmatoro nœ Ayuda, endje ka ndje tœ kœmbœrœtœ endje liaka awa akwa á azu á endje vwaratœ endje tœ adja kœyisœrœ guma. ");
INSERT INTO mnh_vpl VALUES ("TT1_15","086_1_15","TIT","1","15","15","Œrœ kɔ á azu nœ ɔtshɔ lɔsu œ mbœrœ dœ akwa sœ yerœ, kashe azu uburu á endje gugu dœ kœyindœrœ nene, endje wu œrœ kɔ tœ œrœ uburu, mbœrœ kœwusœrœ nœ endje œdœ pe gbetshelœ nœ endje sú dœ ekperœ. ");
INSERT INTO mnh_vpl VALUES ("TT1_16","086_1_16","TIT","1","16","16","Endje sœ kœpa adœke œne wusœ Ndjaba kashe akwa tshelœ endje sœ kœma adœke endje wuwusœ ye nene. Endje yiangba endje mbœrœ ekpe akwa tshelœ endje, endje kœdœ aayi gbɔkumu yé endje lili kœmbœrœ ɔtshɔ œrœ bale nene. ");
INSERT INTO mnh_vpl VALUES ("TT2_1","086_2_1","TIT","2","1","1","Kashe ɓœ, yisœ o'o neke á li dœ adja kœyisœrœ. ");
INSERT INTO mnh_vpl VALUES ("TT2_2","086_2_2","TIT","2","2","2","Pa fœ agbɔ ayakoshe adœke endje dœ agbozu tshapa undu endje, azu á endje lɨsœ endje á endje sœ dœ ɔtshɔ gbetshelœ. Lœ œrœ kɔ, endje matœ endje tœ azu á endje ka ngbɨrɨ lœ kœyindœrœ, azu nœ kœyindœsho, azu nœ kœru lɔsu. ");
INSERT INTO mnh_vpl VALUES ("TT2_3","086_2_3","TIT","2","3","3","Awa bale fœ agbɔ ayashe. Œ li adœke endje mbœrœ tœ endje ɓata ayerœ azu, endje papatœ azu nene, yé endje fafatœ endje tœ akanga nœ ipi nene. Endje yisœ ɔtshɔrœ, ");
INSERT INTO mnh_vpl VALUES ("TT2_4","086_2_4","TIT","2","4","4","endje yisœ mara á li dœ avoro ayashe kœyindœ akɔ endje dœ agbolo nœ endje, ");
INSERT INTO mnh_vpl VALUES ("TT2_5","086_2_5","TIT","2","5","5","avoro ayashenœ sœ dœ ɔtshɔ gbetshelœ yé œ mbœmbœrœ angba budu nene. Endje mbœrœ akwa tshasœnda nœ endje dœ ɔtshɔnœ, endje dœ ɔtshɔ ayashe, œ lɨsœ akɔ endje adœke endje kœgugusœ o'o ama Ndjaba nene. ");
INSERT INTO mnh_vpl VALUES ("TT2_6","086_2_6","TIT","2","6","6","Mɨ upu ndje fœ adjagbala adœke endje sœ dœ ɔtshɔ gbetshelœ ");
INSERT INTO mnh_vpl VALUES ("TT2_7","086_2_7","TIT","2","7","7","lœ œrœ kɔ. Œ li ndje dœ ɓœ dœ tœ zœ kœma ambárá ɔtshɔ akwa fœ endje lœ soro zœ dœ mara adœke, adja kœyisœrœ nœ zœ sœ ndjii yé œsœnœ lɨ. ");
INSERT INTO mnh_vpl VALUES ("TT2_8","086_2_8","TIT","2","8","8","Za kolœ adja o'o á li ga tœ akwa yeka azu kœshara upu mbœrœ akwa nœ azœ yé á kœfafatshelœ nœ nene. Ataa, endje gbɔ tshula yé œ gbɔ awa kœpa ekpe o'o nœ azœ nene. ");
INSERT INTO mnh_vpl VALUES ("TT2_9","086_2_9","TIT","2","9","9","Mɨ upu fœ akanga adœke endje lɨsœ agbozu tshapa endje lœ œrœ kɔ, endje mbœrœ œrœ á za yanga fœ endje. Adja endje gbugbugburu tshelœ o'o dœ agbozu tshapa endje nene. ");
INSERT INTO mnh_vpl VALUES ("TT2_10","086_2_10","TIT","2","10","10","Endje zɨzɨangba œrœ nœ endje nene, endje zatœ endje mbœrœ akwa dœ lɔsu bale yé œ kakatœ anga tshakala akwa tɨ teasho nene yeka azu kœlɨsœ o'onœ á a sœ kœyisœ nœ tœ upu nœ Ndjaba á tshe she azœ. ");
INSERT INTO mnh_vpl VALUES ("TT2_11","086_2_11","TIT","2","11","11","Ndjaba ma ɔtshɔ lɔsu nœ ye á li kœshe azu para kɔkɔ. ");
INSERT INTO mnh_vpl VALUES ("TT2_12","086_2_12","TIT","2","12","12","Ɔtshɔ lɔsunœ yisœ œrœ adœke, a katœ kœvwaratœ azœ tœ Ndjaba œdœ kœna manda ogo œrœ tshapashɔnœ asœke yeka a kœgbɔndœtœ azœ, á kœte azu kœlɨsœ Ndjaba, azu á endje sœ ndjii tœ ala ye. ");
INSERT INTO mnh_vpl VALUES ("TT2_13","086_2_13","TIT","2","13","13","A sœ kœmbœrœ atamœ, kœvu olo yanganœ á sœ kœkate azœ dœ lɔkɔ á a wu mokɔ nœ Yisu Kristu, á tshe kœdœ Ndjaba œdœ Ayi kœshe azœ. ");
INSERT INTO mnh_vpl VALUES ("TT2_14","086_2_14","TIT","2","14","14","Tshe zatœ ye fœ kuzu tœ œsœ́ azœ mbœrœ kœshe azœ lœ ekperœ kɔ. Tshe djutɔ azœ adœke a te azu nœ ye, azu á endje sœ kœpa avwara ndœ kœmbœrœ ɔtshɔ akwa. ");
INSERT INTO mnh_vpl VALUES ("TT2_15","086_2_15","TIT","2","15","15","Œ li dœ ɓœ kœmɨndœ upunœ asœ kɔ fœ azu. Yisœ awa akwa fœ endje yé œ za ala endje dœ gbɔgbɔ á Ndjaba za fœ ɓœ. Kaka adœke uzu bale dɨdɨ ɓœ nene. ");
INSERT INTO mnh_vpl VALUES ("TT3_1","086_3_1","TIT","3","1","1","Kpa mɨndœ nœ fœ azu nœ Ndjaba adœke endje lɨsœ agbozu tshapa akwa kɔ nœ Lita. Endje dji o'o ama endje yé œ yindœ kœmbœrœ ɔtshɔ akwa. ");
INSERT INTO mnh_vpl VALUES ("TT3_2","086_3_2","TIT","3","2","2","Endje gugu œsœ uzu bale nene, endje para kœsœ gee dœ azu yé œ dœ aayi kœmbœrœ ayo, œ sœ dœ ɔtshɔ lɔsu ga ndœ azu kɔ. ");
INSERT INTO mnh_vpl VALUES ("TT3_3","086_3_3","TIT","3","3","3","Gbambanœ nene, azœ kɔ a djingili lima awa yé œ dœ́ lima azu nœ ekpe gbetshelœ, a dœ́ lima aayi sharapu, aayi ɨndɨ, akanga nœ ogo ekperœ kɔ. A sœ lima hawo hawo yé œ sœ dœ úkú, endje yi lima angba azœ mbœrœ ekpe ɔtshɔ azœ yé a sœ ndje lima kœyiangba anga azœ. ");
INSERT INTO mnh_vpl VALUES ("TT3_4","086_3_4","TIT","3","4","4","Kashe, Ndjaba ayi kœshe azœ má fœ azœ ɔtshɔ lɔsu nœ ye dœ pe kœyindœsho nœ ye. ");
INSERT INTO mnh_vpl VALUES ("TT3_5","086_3_5","TIT","3","5","5","Tshe sheshe azœ mbœrœ akwa nœ azœ á sœ ndjii nene, kashe œshe dœ tœ ye dá wu oyo azœ. Tshe she azœ dœ gbɔgbɔ nœ Ɔtshɔ Ɨshirɨ, á djutɔ azœ lœ ekperœ yé á a wuta atafo azu yeka a gbɔ tafo mara nœ kœmbœrœtœ azœ. ");
INSERT INTO mnh_vpl VALUES ("TT3_6","086_3_6","TIT","3","6","6","Ndjaba vwa Ɔtshɔ Ɨshirɨnœ tonge tonge ga pa azœ dœ awa nœ Yisu Kristu Ayi kœshe azœ, ");
INSERT INTO mnh_vpl VALUES ("TT3_7","086_3_7","TIT","3","7","7","tshe mbœrœ adœke a wuta ndjii tœ ala ye lœ awa nœ ɔtshɔ lɔsu nœ ye, dœ́ œ gbɔ soro á ka nene á a sœ kœvu tœnœ. ");
INSERT INTO mnh_vpl VALUES ("TT3_8","086_3_8","TIT","3","8","8","O'onœ asœ kœdœ adjapu yé mœ yindœ nœ adœke ɓœ ka ga pa kœyisœrœ nœ adœke azu á endje yindœ Ndjaba wotœ endje ndœ kœmbœrœ ɔtshɔrœ. Wu œrœ œneke á sœ dœ ɔtshɔnœ, á li dœ azu kœmbœrœ tœnœ. ");
INSERT INTO mnh_vpl VALUES ("TT3_9","086_3_9","TIT","3","9","9","Kashe ɓœ kpa awa kœgbugburu tshelœ o'o á ádánœ gugu nene, kœgbugburutshelœ o'o tœ upu nœ kœdɨ ɨ'ɨrɨ aata, œbœrœ œdœ kœnga koshe pa awa akwa, vwaratœ zœ tœ œrœnœ asœmœ. Œ sœ gbambanœ yé ádánœ gugu nene. ");
INSERT INTO mnh_vpl VALUES ("TT3_10","086_3_10","TIT","3","10","10","Tsheneke á tshe para awa kœkurutshelœ ayindœ Yisu, za ala ye awa bale too awa bisha. Á tshe kœdjidji ɓœ nene, katœ ye tɨ. ");
INSERT INTO mnh_vpl VALUES ("TT3_11","086_3_11","TIT","3","11","11","Wusœ nœ adœke, uzu ataa sœ lœ djingili, tshe kœdœ ayi kœmbœrœ ekperœ yé tshe sœ kœwa ngbanga ga tœ ye dœ tœ ye. ");
INSERT INTO mnh_vpl VALUES ("TT3_12","086_3_12","TIT","3","12","12","Ɔlɔ á mœ kœvwa Artemase too Tishike fœ ɓœ, pa avwara kœna kœgbɔ mœ ɓa lœ Nikopolise. Ɓa zœ, dá œndœ mœ œ dɨ mbœrœ yapu nœ ɨzɨ. ");
INSERT INTO mnh_vpl VALUES ("TT3_13","086_3_13","TIT","3","13","13","Mbœrœ kɔ tœ kœgi Zenase á tshe kœdœ avoka œdœ pe Apolo ga tœ awa ana nœ endje. Mbœrœ œneke kɔ á li fœ endje. ");
INSERT INTO mnh_vpl VALUES ("TT3_14","086_3_14","TIT","3","14","14","Mbœrœ adœke aaya azœ dœ ayindœ Yisu zatœ endje ndœ ɔtshɔ akwa dœ lɔsu endje bale, mbœrœ kœtɨ kane anga azu á endje sœ lœ oyo. Ataa, mara ɔtshɔ endje œ sœ gbambanœ nene. ");
INSERT INTO mnh_vpl VALUES ("TT3_15","086_3_15","TIT","3","15","15","Azu para á endje sœ dœ mœ ɓa ke vwa abala fœ ɓœ. Za ndje abala fœ anga azœ dœ ayindœ Yisu. Kaka Ndjaba yisœ ɔtshɔ lɔsu nœ ye ga ndœ 'e para kɔkɔ.");
INSERT INTO mnh_vpl VALUES ("PM1_1","087_1_1","PHM","1","1","1","Œmœ Polo, á endje za mœ vwi ga lœ kánga mbœrœ akwa nœ Yisu Kristu, dá sœ kœsu mbetinœ asœke œdœ aya azœ dœ Timote. 'A su mbetinœ fœ ɓœ Filemɔ, yanga 'a lœ ama akwa. ");
INSERT INTO mnh_vpl VALUES ("PM1_2","087_1_2","PHM","1","2","2","Dœ yingɔ 'a dœ Apia, dœ Arkipe yanga 'a lœ koshe œdœ ndje fœ anga ayindœ Yisu á endje ngbɔtœ endje ɓa sœnda nœ zœ. ");
INSERT INTO mnh_vpl VALUES ("PM1_3","087_1_3","PHM","1","3","3","Kaka Aba azœ dœ Ndjaba, dœ Gbozu Yisu Kristu yisœ ɔtshɔ lɔsu nœ endje ga ndœ 'e yé œ za kœsœ gee nœ endje fœ 'e. ");
INSERT INTO mnh_vpl VALUES ("PM1_4","087_1_4","PHM","1","4","4","Ɔlɔ dœ ɔlɔ mœ sœ kœgbe dœ ɓœ lœ kœza avwala nœ mœ fœ Ndjaba, yé œ sœ kœgi ndje mershe waa fœ she tœ upu nœ zœ; ");
INSERT INTO mnh_vpl VALUES ("PM1_5","087_1_5","PHM","1","5","5","gbambanœ nene, mœ dji azu kœpa o'o mbœrœ kœyindœsho nœ zœ ga ndœ ayerœ azu nœ Ndjaba para kɔkɔ œdœ pe ndje kœyindœrœ nœ zœ ga ndœ Gbozu Yisu. ");
INSERT INTO mnh_vpl VALUES ("PM1_6","087_1_6","PHM","1","6","6","Mœ sœ kœyu Ndjaba adœke kœyindœrœ á ngbɔɓa azœ dœ ɓœ ga tœnœ ma akwa, yeka á ɓœ kœwusœ ɔtshɔrœ kɔ á a gbɔ lœ kœngbɔtœ azœ bale dœ Kristu dœ ɔtshɔnœ. ");
INSERT INTO mnh_vpl VALUES ("PM1_7","087_1_7","PHM","1","7","7","Aya, yanga nœ mœ dopa nœ kolœ mbœrœ kœyindœsho nœ zœ ga ndœ anga ayindœ Yisu yé mœ ru lɔsu mœ mbœrœ tœnœ. Gbambanœ nene, ɓœ mbœrœ adœke lɔsu ayerœ azu nœ Ndjaba zɨ tɨɨ. ");
INSERT INTO mnh_vpl VALUES ("PM1_8","087_1_8","PHM","1","8","8","Mbœrœ tœnœ ndje ataa, Kristu za awa fœ mœ kœpa fœ ɓœ, œneke kɔ á li adœke ɓœ mbœrœ, ");
INSERT INTO mnh_vpl VALUES ("PM1_9","087_1_9","PHM","1","9","9","kashe mœ sœ kœ'eshondœ nœ adœke ɓœ mbœrœ kolœ lœ kœyindœsho nœ zœ. Mœ yindœ kœyu ɓœ tœ œrœ bale, œmœ dœ́ yagbozu Polo, á mœ sœ ngɔngɔ asœke lœ kánga mbœrœ Yisu Kristu, ");
INSERT INTO mnh_vpl VALUES ("PM1_10","087_1_10","PHM","1","10","10","mœ yu ɓœ tœ upu nœ Onezime, á tshe wuta gbolo nœ mœ á mœ zu she lœ kánga ɓa ke. ");
INSERT INTO mnh_vpl VALUES ("PM1_11","087_1_11","PHM","1","11","11","Utshunœ lima, tshe sœsœ lima kœmbœrœ œrœ bale fœ ɓœ nene, kashe ngɔngɔ asœke, tshe li kœmbœrœ œrœ fœ azœ dœ ɓœ. ");
INSERT INTO mnh_vpl VALUES ("PM1_12","087_1_12","PHM","1","12","12","Mœ gi she fœ ɓœ, œshe á tshe sœ ɓata tshakala kote mœ. ");
INSERT INTO mnh_vpl VALUES ("PM1_13","087_1_13","PHM","1","13","13","Œ li má dœ mœ kœgbɔndœ ye ɓa ɨndɨrɨ mœ ɓa ke á tshe kœmbœrœ akwa fœ mœ tœ́ œsœ́ zœ lœ kánga á mœ li lœ kumu Ɔtshɔ O'o. ");
INSERT INTO mnh_vpl VALUES ("PM1_14","087_1_14","PHM","1","14","14","Kashe mœ gbegbe kœmbœrœ ataa utshu kœdji gbetshelœ nœ zœ nene. Mœ sœsœ kœtovworogbo ɓœ kœmbœrœ ɔtshɔrœ fœ mœ dœ ɔgbɔ nene, kashe œ li dœ ɓœ kœmbœrœ œneke á lɔsu zœ yindœ nœ dœ tœ zœ. ");
INSERT INTO mnh_vpl VALUES ("PM1_15","087_1_15","PHM","1","15","15","Anganœ endje kurutshelœ 'e dœ Onezime ndœ olo teasho adœke ɓœ kpa kœkwatœ zœ ga ndœ ye waa dœ waa. ");
INSERT INTO mnh_vpl VALUES ("PM1_16","087_1_16","PHM","1","16","16","Ngɔngɔ asœke, tshe kpa dœ́dœ́ kolœ kanga nene, tshe ropa kanga ye. Tshe wuta aya azœ á mœ yindœ ye tɔpanœ kpuru. Mœ yindœ ye waa kashe œɓœ, ɓœ kpa yindœ ye tɔpanœ kpuru œdœ ɓata uzu œdœ ɓata yindœ Kristu. ");
INSERT INTO mnh_vpl VALUES ("PM1_17","087_1_17","PHM","1","17","17","Œdœ ɓœ kœwusœ nœ adœke œmœ kœdœ adja yanga zœ, za osho kœsœ fœ she ɓata á li dœ ɓœ kœza má fœ mœ. ");
INSERT INTO mnh_vpl VALUES ("PM1_18","087_1_18","PHM","1","18","18","Œdœ tshe kœmbœrœ lima ekperœ fœ ɓœ, œdœ kuɗa nœ zœ kœsœ ndje lima lœ kumu ye, za djigi ga pa mœ. ");
INSERT INTO mnh_vpl VALUES ("PM1_19","087_1_19","PHM","1","19","19","O'o asœke adja mœ dœ́ Polo dá su: œmœ mœ gi kuɗa tshaangba ye para kɔkɔ fœ ɓœ. Kashe œɓœ ndje, ɓœ gbe dœ kuɗa nœ mœ á sœ pa zœ kane: kuɗanœ asœmœ kœdœ soro zœ. ");
INSERT INTO mnh_vpl VALUES ("PM1_20","087_1_20","PHM","1","20","20","Atamœ aya, mœ yu ɓœ adœke ɓœ mbœrœ ɔtshɔrœ fœ mœ adœke lɔsu mœ zɨ tɨɨ mbœrœ a sœ bale lœ ɨ'ɨrɨ Kristu. ");
INSERT INTO mnh_vpl VALUES ("PM1_21","087_1_21","PHM","1","21","21","Mœ sú mbetinœ asœke fœ ɓœ dœ lɔsu adœke ɓœ mbœrœ œneke á mœ eshondœ nœ ga tœ zœ yé mœ wusœ nœ adœke ɓœ kpa mbœrœ kœropa œneke á mœ gbe dœ tœnœ. ");
INSERT INTO mnh_vpl VALUES ("PM1_22","087_1_22","PHM","1","22","22","Ga pa nœ, œ li adœke ɓœ guma osho olo fœ mœ mbœrœ mœ wu adœke Ndjaba œ dji avwala nœ 'e yé œ kɔrɔ awa fœ mœ ndœ kœna ga ndœ 'e zœ. ");
INSERT INTO mnh_vpl VALUES ("PM1_23","087_1_23","PHM","1","23","23","Epafraze á 'a sœ dœ she lœ kánga mbœrœ Yisu Kristu, vwa abala fœ ɓœ. ");
INSERT INTO mnh_vpl VALUES ("PM1_24","087_1_24","PHM","1","24","24","Aanga mœ lœ ama akwa: Marke, Aristarke, Demasi œdœ pe Lukasi á 'a sœ tœ kœmbœrœ akwa nœ Ndjaba awa bale dœ endje asœmœ, para kɔkɔ endje vwa abala fœ ɓœ. ");
INSERT INTO mnh_vpl VALUES ("PM1_25","087_1_25","PHM","1","25","25","Kaka adœke Gbozu nœ azœ dœ Yisu Kristu ma ɔtshɔ lɔsu nœ ye ga ndœ 'e.");
INSERT INTO mnh_vpl VALUES ("HB1_1","088_1_1","HEB","1","1","1","Utshunœ lima, Ndjaba pa o'o fœ aata azœ, tshe pa o'o lœ awa nœ aayi kœgbara o'o; tshe pa o'o fœ endje kpalakpala œdœ pe lœ tshelœ aka mara ndjoro, ");
INSERT INTO mnh_vpl VALUES ("HB1_2","088_1_2","HEB","1","2","2","yé ngɔngɔ tœ ndɔngɔlɔ oshonœ asœke á a sœ lœ nœ, tshe pa o'o fœ azœ lœ awa nœ Gbolo á tshe za she kœsœ tœ ayengɔ œrœ kɔ, lœ awa nœ ye ndje dá tshe mbœrœ tshapashɔ. ");
INSERT INTO mnh_vpl VALUES ("HB1_3","088_1_3","HEB","1","3","3","Gbolo kœdœ kœtshi nœ mokɔ nœ ye, tshe kœdœ adja angwa ye. O'o ama ye sœ dœ gbɔgbɔ yé œtœnœ dá mbœrœ adœke œrœ tshapashɔ para kɔkɔ sœ zœ. Mangba kœdjutɔ ekperœ nœ azu, tshe sœ ga pa kuni Ndjaba á tshe sœ dœ gbɔgbɔ kœropa nœ kɔ ɓa lafo. ");
INSERT INTO mnh_vpl VALUES ("HB1_4","088_1_4","HEB","1","4","4","Gbolo ropa aandjelu ye. Dœ tœnœ ataa á Ndjaba za ɨ'ɨrɨ kpi á rosœ œnœ endje fœ she. ");
INSERT INTO mnh_vpl VALUES ("HB1_5","088_1_5","HEB","1","5","5","Atamœ, Ndjaba papa fœ anga andjelu nœ ye bale nene adœke: «Ɓœ kœdœ Gbolo nœ mœ, yé kœto kpesheke, œmœ kœdœ Aba zœ.» Yé tshe papa ndje o'o tœ upu nœ anga andjelu bale nene adœke: «Mœ dœ bala Abanœ, yé tshe dœ bala Gbolo nœ mœ.» ");
INSERT INTO mnh_vpl VALUES ("HB1_6","088_1_6","HEB","1","6","6","Kashe dœ lɔndɔ á Ndjaba vwa lima eya Gbolo nœ ye ga pa tshapashɔ, tshe pa adœke: «Œ li adœke aandjelu nœ Ndjaba kɔ gote ga tshatshu ye.» ");
INSERT INTO mnh_vpl VALUES ("HB1_7","088_1_7","HEB","1","7","7","Tshe kpa pa o'o tœ upu nœ aandjelu adœke: «Mœ mbœrœ adœke aandjelu nœ mœ sœ ɓata ɨshirɨ, yé mœ mbœrœ adœke aayi akwa nœ ye sœ ɓata laɓa owo.» ");
INSERT INTO mnh_vpl VALUES ("HB1_8","088_1_8","HEB","1","8","8","Kashe tœ upu nœ Gbolo, tshe pa adœke: «Uu Ndjaba, ngande tshagbozu nœ zœ sœ waa dœ waa. Ɓœ sœ kœmbœrœ akwa tshagbozu nœ zœ dœ mara á sœ ndjii. ");
INSERT INTO mnh_vpl VALUES ("HB1_9","088_1_9","HEB","1","9","9","Ɓœ sœ kœyindœ œrœ á sœ ndjii, yé ɓœ sœ kœyiangba ekperœ, mbœrœ tœnœ ataa, uu Ndjaba, Ndjaba nœ zœ dá ke ɓœ adœke ɓœ sœ dœ yanga, yé tshe ma adœke œne yindœ zœ kœropa anga zœ.» ");
INSERT INTO mnh_vpl VALUES ("HB1_10","088_1_10","HEB","1","10","10","Tshe kpa pa ndje adœke: «Gbozu, œɓœ dá mbœrœ ɔshɔ pe tœ alinœ utshunœ, tshalafo kœdœ tshangba akwa ndœ kane zœ. ");
INSERT INTO mnh_vpl VALUES ("HB1_11","088_1_11","HEB","1","11","11","Œrœnœ asœke kɔ œ yiwa bala ye, kashe œɓœ, ɓœ sœpe zœ. Tshalafo œdœ tshaatɨ œ wuta ɓata ongboro lœba; ");
INSERT INTO mnh_vpl VALUES ("HB1_12","088_1_12","HEB","1","12","12","ɓœ vwele œtœnœ bala ga tœnœ ɓata á endje vwele yɔgbɔdɔ lœba, yé endje yapa œtœnœ ɓata lœba. Kashe œɓœ, ɓœ sœ kolœ ɓata á ɓœ sœ asœmœ yé ndɔngɔlɔ zœ œ sœ tœnœ nene.» ");
INSERT INTO mnh_vpl VALUES ("HB1_13","088_1_13","HEB","1","13","13","Ndjaba papa fœ anga andjelu nœ ye bale nene adœke: «Na œ sœ ga pa kuni mœ, mœ ko ayingba zœ ga tshakudu ada zœ.» ");
INSERT INTO mnh_vpl VALUES ("HB1_14","088_1_14","HEB","1","14","14","Aandjelu kœdœ aɗe e? Endje para kɔkɔ kœdœ ɨshirɨ á sœ kœmbœrœ akwa fœ Ndjaba: Tshe sœ kœvwa endje adœke endje tɨ kane azu á endje li kœgbɔ kœshe. ");
INSERT INTO mnh_vpl VALUES ("HB2_1","088_2_1","HEB","2","1","1","Mbœrœ tœnœ ataa, œ li adœke a shi gbɨ lœ o'o á a dji œdœ a kœyindœ nœ adœke a djingili awa nene. ");
INSERT INTO mnh_vpl VALUES ("HB2_2","088_2_2","HEB","2","2","2","Gbambanœ nene, œdœ o'o á aandjelu pa lima ndœ nœ kœmatœ ye adœke œtœnœ kœdœ adja o'o, yé œdœ azu á endje ndɨ lima tshelœnœ, œdœ azu á endje vwara lima tœ endje tœ kœlɨsœ o'onœ asœmœ kœgbɔ lima djofele á li dœ endje, ");
INSERT INTO mnh_vpl VALUES ("HB2_3","088_2_3","HEB","2","3","3","azœ dœ tœ azœ a kpa lœ manœ kotoo œdœ a kœsœ kœmbœrœtœ mara kœshe ataa? Gbozu dá yi lima sœ œrœ tœ upu nœ utshunœ, manda nœ á azu á endje dji lima she ma kɨkɨlɨnœ fœ azœ. ");
INSERT INTO mnh_vpl VALUES ("HB2_4","088_2_4","HEB","2","4","4","Ndjaba to ndje gbɔgbɔ nœ ye ga lœ kœmarœ nœ endje lœ awa nœ ambárá ndjoro, ogboro œrœ dœ tshelœ áká afá kɔ, œ ga ndœ lœ awa nœ kœto œrœ nœ Ɔtshɔ Ɨshirɨ fœ azu lindœ œneke á lɔsu ye yindœ nœ. ");
INSERT INTO mnh_vpl VALUES ("HB2_5","088_2_5","HEB","2","5","5","Gbambanœ nene, Ndjaba zaza tshapashɔ nœ tshambatsha á a sœ kœpa tœnœ, fœ aandjelu nene. ");
INSERT INTO mnh_vpl VALUES ("HB2_6","088_2_6","HEB","2","6","6","Andaa, anga uzu bale su o'o ala Buku nœ Ndjaba adœke: «Uzu kœdœ ɗe yeka á ɓœ kœsœ kœgbe dœ she a? Too gbolo nœ uzu kœdœ ɗe á ɓœ kœko ala zœ ga pa ye a? ");
INSERT INTO mnh_vpl VALUES ("HB2_7","088_2_7","HEB","2","7","7","Ɓœ za she teasho ga tshakudu aandjelu, ɓœ za mokɔ œdœ kœlɨsœtœ fœ she. ");
INSERT INTO mnh_vpl VALUES ("HB2_8","088_2_8","HEB","2","8","8","Ɓœ ko œrœ kɔ ga tshada ye.» Ɓata á Ndjaba za she tœ gbozu tshapa œrœ kɔ, anga œrœ bale á tshapu kœsœ ga tshakudu ye gugu nene. Andaa, a wuwu damba nene adœke Ndjaba ko œrœ para ga tshakudu ye. ");
INSERT INTO mnh_vpl VALUES ("HB2_9","088_2_9","HEB","2","9","9","Kashe œrœ á a sœ kœwu tœnœ dœke: Yisu á Ndjaba za lima she teasho ga tshakudu aandjelu, gbɔ mokɔ œdœ pe kœlɨsœtœ lœ kumu kœwu œrœ kanga nœ kuzu á tshe tshu. Ataa lœ awa nœ ɔtshɔ lɔsu nœ Ndjaba, tshe tshu kuzu tœ upu nœ azu kɔ. ");
INSERT INTO mnh_vpl VALUES ("HB2_10","088_2_10","HEB","2","10","10","Gbambanœ nene, œ li adœke Ndjaba á tshe mbœrœ œrœ kɔ, á sœ kœmbœrœ adœke œrœnœ sœ zœ asœmœ, za Yisu tœ uzu á tshe li lœ awa nœ kœwu oyo mbœrœ adœke agbolo ndjoro kœwu mokɔ nœ ye. Gbambanœ nene, Yisu kœdœ uzu á tshe sœ kœyisœ awa kœshe fœ endje. ");
INSERT INTO mnh_vpl VALUES ("HB2_11","088_2_11","HEB","2","11","11","Andaa Yisu á tshe sœ kœmbœrœ adœke azu wuta yerœ lœ ekperœ nœ endje dœ pe endjeneke á endje wuta yerœ, endje sœ dœ Aba bale. Mbœrœ tœnœ ataa dá Yisu sœsœ dœ tshula kœ'e endje adœke aaya œne nene. ");
INSERT INTO mnh_vpl VALUES ("HB2_12","088_2_12","HEB","2","12","12","Yé tshe pa adœke: «Uu Ndjaba, mœ pa bala o'o tœ upu nœ ɨ'ɨrɨ zœ fœ aaya mœ, yé mœ ɓi itshi kœdonga dœ ɓœ ugurutœ ukpulu azu lœ angbɔtœ.» ");
INSERT INTO mnh_vpl VALUES ("HB2_13","088_2_13","HEB","2","13","13","Tshe kpa pa adœke: «Mœ za bala lɔsu mœ djigi fœ Ndjaba.» Yé ga pa nœ: «Wu mœ, œmœ œdœ agbolo á Ndjaba ko endje fœ mœ dœke.» ");
INSERT INTO mnh_vpl VALUES ("HB2_14","088_2_14","HEB","2","14","14","Ataa, ɓata á agbolo kœdœ azu á endje sœ dœ songba œdœ dœ indji, Yisu wuta ndje awa bale ɓata endje, tshe mbœrœ œrœ kɔ nœ mara nœ endje dœ azu. Lœ awa kuzu nœ ye, tshe ropa djaboro á tshe sœ lima dœ gbɔgbɔ nœ kuzu, ");
INSERT INTO mnh_vpl VALUES ("HB2_15","088_2_15","HEB","2","15","15","œdœ dœ œnœ kœvwara azu á awa kuzu fa lima endje tœ akanga lœ soro endje djigi. ");
INSERT INTO mnh_vpl VALUES ("HB2_16","088_2_16","HEB","2","16","16","Gbambanœ nene, tshe nana mbœrœ kœtɨ kane aandjelu nene, kashe tshe na mbœrœ aata Abrayamo. ");
INSERT INTO mnh_vpl VALUES ("HB2_17","088_2_17","HEB","2","17","17","Mbœrœ tœnœ ataa, œ li lima adœke tshe wuta awa bale ɓata aayanœ lœ áká œrœ kɔ yeka á kœte egerœ nganga Ndjaba nœ lɔsu kœwu oyo, á tshe sœ ndjii utshu Ndjaba mbœrœ kœdjerœndœ ekperœ nœ azu. ");
INSERT INTO mnh_vpl VALUES ("HB2_18","088_2_18","HEB","2","18","18","Gbambanœ nene, ɓata á tshe wu lima oyo dœ tœ ye lœ kœwu lɔsu nœ Satana, tshe li ndje kœtɨ kane endjeneke á Satana sœ kœwu lɔsu endje ye. ");
INSERT INTO mnh_vpl VALUES ("HB3_1","088_3_1","HEB","3","1","1","Atamœ, aaya mœ, e'e kœdœ ayerœ azu nœ Ndjaba á tshe e 'e ndœ kœmbœrœ ogo nœ ye ɓa lafo, 'e meosho ga tœ Yisu á tshe dœ ayi avwa œdœ egerœ nganga Ndjaba nœ kœyindœrœ á a sœ kœmɨndœ nœ. ");
INSERT INTO mnh_vpl VALUES ("HB3_2","088_3_2","HEB","3","2","2","Œ dœ adjapu adœke tshe sœ lima ndjii utshu Ndjaba á tshe ke she ndœ akwa ɓata á Moyize sœ ndje lima ndjii lœ anda nœ Ndjaba djigi. ");
INSERT INTO mnh_vpl VALUES ("HB3_3","088_3_3","HEB","3","3","3","Endje donga ayi kœmɔ anda kœropa anda dœ tœ ye. Gbambanœ nene, mokɔ nœ Yisu ropa œnœ Moyize. ");
INSERT INTO mnh_vpl VALUES ("HB3_4","088_3_4","HEB","3","4","4","Anda bale dœ bale kɔ sœ dœ uzu á tshe mɔ, yé uzu á tshe mɔ kɔ kœdœ Ndjaba. ");
INSERT INTO mnh_vpl VALUES ("HB3_5","088_3_5","HEB","3","5","5","Andaa, Moyize za lima tœ ye kœmbœrœ akwa dœ lɔsu ye bale lœ anda nœ Ndjaba djigi ɓata ayi akwa mbœrœ kœma œneke á li má adœke Ndjaba pa. ");
INSERT INTO mnh_vpl VALUES ("HB3_6","088_3_6","HEB","3","6","6","Kashe Kristu zatœ ye kœmbœrœ akwa dœ lɔsu ye bale ɓata Gbolo, yé Ndjaba za she ga tœ kumu akwa lœ anda nœ ye. Anda nœ ye kœdœ azœ œdœ a kœsœpe kolœ kœyindœ nœ yé á sœ kœko lɔsu azœ ga tœ œrœ á a sœ kœkate kœgbɔ tœnœ dœ yanga. ");
INSERT INTO mnh_vpl VALUES ("HB3_7","088_3_7","HEB","3","7","7","Mbœrœ tœnœ dá Ɔtshɔ Ɨshirɨ pa adœke: «Kpesheke, œdœ 'e kœsœ kœdji tshama ye, ");
INSERT INTO mnh_vpl VALUES ("HB3_8","088_3_8","HEB","3","8","8","'e sœsœ dœ ɔgbɔ lɔsu nene ɓata lɔndɔ á 'e oma lima dœ Ndjaba, dœ olo á 'e wu lima lɔsu ye ɓa lœ kpagagasho. ");
INSERT INTO mnh_vpl VALUES ("HB3_9","088_3_9","HEB","3","9","9","Ɓa zœ, alaba 'e kœwu lima lɔsu mœ dœ kœpara awa kœyu tshelœ mœ, yé endje wu lima akwa ndœ kane mœ ");
INSERT INTO mnh_vpl VALUES ("HB3_10","088_3_10","HEB","3","10","10","manda ungu zazu bisha (40). Mbœrœ tœnœ ataa, mœ sœ dœ ókó ga tœ azu nœ oshonœ asœmœ yé á mœ pa adœke: “Gbetshelœ nœ endje sœ kœndɨ waa dœ waa, azunœ asœmœ wuwu lima sœ awa mœ nene.” ");
INSERT INTO mnh_vpl VALUES ("HB3_11","088_3_11","HEB","3","11","11","Gbambanœ nene, mœ dara ama mœ lœ ókó nœ mœ adœke: A wu bala zœ, œdœ endje œ li bala kœyatœ endje ɓa ndœ mœ!» ");
INSERT INTO mnh_vpl VALUES ("HB3_12","088_3_12","HEB","3","12","12","Alaya mœ, 'e sœ dœ gbɔdjela. Kaka adœke uzu bale ugurutœ 'e sœsœ dœ ekpe lɔsu dœ pe sharapu neke á vwa she kœfa tshangba ye fœ Ndjaba nœ soro nene. ");
INSERT INTO mnh_vpl VALUES ("HB3_13","088_3_13","HEB","3","13","13","Kashe 'e to gbɔgbɔ ugurutœ 'e dœ anga 'e ɔlɔ dœ ɔlɔ ɓata á endje sú ala Buku adœke œndœ «tshakpesheke» sœpe kœdɨ tœnœ, mbœrœ adœke ekperœ bɨbɨlɨ uzu bale ugurutœ 'e, á tshe kœwuta dœ ɔgbɔ lɔsu nene. ");
INSERT INTO mnh_vpl VALUES ("HB3_14","088_3_14","HEB","3","14","14","Gbambanœ nene, œdœ a kœsœpe kœshi gbɨ œrrr ga tœ ndɔngɔlɔ soro azœ lœ kœyindœrœ ɓata á a gbɔ lima tœ alinœ, a wuta aayi kœmbœrœ akwa awa bale dœ Kristu. ");
INSERT INTO mnh_vpl VALUES ("HB3_15","088_3_15","HEB","3","15","15","Endje su ɓala buku nœ Ndjaba adœke: «Kpesheke, œdœ 'e kœsœ kœdji tshama ye, 'e sœsœ dœ ɔgbɔ lɔsu ɓata dœ lɔkɔ á 'e oma lima dœ Ndjaba nene.» ");
INSERT INTO mnh_vpl VALUES ("HB3_16","088_3_16","HEB","3","16","16","Azu aɗe dá dji lima tshama ye, yé á oma dœ she a? Œ dœ́dœ́ lima azu kɔ á Moyize ko endje wuta tœnœ ga ushu lœ ogo Ezipito nene a? ");
INSERT INTO mnh_vpl VALUES ("HB3_17","088_3_17","HEB","3","17","17","Yé aɗe dá Ndjaba sœ lima dœ ókó ga tœ endje manda ungu zazu bisha a? Œ dœ́dœ́ ga tœ azu á endje mbœrœ lima ekperœ yekane á tshu ɓa lœ kpagagasho nene a? ");
INSERT INTO mnh_vpl VALUES ("HB3_18","088_3_18","HEB","3","18","18","Yé aɗe dá Ndjaba dara lima ama ye adœke endje li kœyatœ endje ɓa ndœ œne nene a? Œ dœ́dœ́ mbœrœ azu á endje oma lima asœmœ nene a? ");
INSERT INTO mnh_vpl VALUES ("HB3_19","088_3_19","HEB","3","19","19","Yé a wu adœke endje lili lima kœli ga zœ nene mangba ɔgbɔ lɔsu nœ endje. ");
INSERT INTO mnh_vpl VALUES ("HB4_1","088_4_1","HEB","4","1","1","Ndjaba pa lima ndœ nœ fœ azœ adœke a li bala kœyatœ azœ ɓa tœ osho á œne guma fœ azœ. Ataa, ala azœ gbɔ adœke anga uzu bale ugurutœ azœ tshatshapu kœli ga zœ nene. ");
INSERT INTO mnh_vpl VALUES ("HB4_2","088_4_2","HEB","4","2","2","Gbambanœ nene, a gbɔ Ɔtshɔ O'o ɓata á azunœ asœmœ gbɔ ndje lima. Kashe o'o á endje dji lima mbœmbœrœ œrœ bale tœ endje nene, mbœrœ aayi kœdji tœnœ dji lima tako kashe endje yiyi lima ndœ nœ nene. ");
INSERT INTO mnh_vpl VALUES ("HB4_3","088_4_3","HEB","4","3","3","Yé azœ á a sœ dœ kœyindœrœ, a li bala kœyatœ azœ ɓa tœ osho á Ndjaba pa lima o'o tœ upunœ adœke: «Mœ dara ama mœ lœ ókó nœ mœ: Endje li bala kœyatœ endje ɓa tœ osho kœyatœsho nœ mœ nene!» Ndjaba pa atamœ, kashe osho kœyatœshonœ asœmœ, tshe guma lima kœto tœ ali kœmbœrœ tshapashɔ. ");
INSERT INTO mnh_vpl VALUES ("HB4_4","088_4_4","HEB","4","4","4","Gbambanœ nene, endje sú tœ upu nœ olo mindu dœ bisha (7) adœke: «Yé Ndjaba ya lima tœ ye dœ olo mindu dœ bisha manda kœka akwa nœ ye kɔ.» ");
INSERT INTO mnh_vpl VALUES ("HB4_5","088_4_5","HEB","4","5","5","Yé endje kpa su o'onœ asœmœ adœke: «Endje li kœyatœ endje ɓa tœ osho nœ mœ nene.» ");
INSERT INTO mnh_vpl VALUES ("HB4_6","088_4_6","HEB","4","6","6","Dœ tœnœ ataa, azu á endje dœ lima azu utshunœ kœdji Ɔtshɔ O'o, endje lili lima kœyatœ endje ɓa tœ oshonœ asœmœ nene, mbœrœ endje vwara lima tœ endje kœlɨsœ Ndjaba ye, andaa anga azu li kœli tœnœ ye. ");
INSERT INTO mnh_vpl VALUES ("HB4_7","088_4_7","HEB","4","7","7","Ndjaba kpa za anga olo kœli ga zœ, á tshe e ɨ'ɨrɨnœ «kpesheke». Olo ndjoro manda nœ, tshe pa lima o'o waa lœ awa nœ Davidi lœ ada mbeti á endje pa tœnœ utshunœ adœke: «Kpesheke, œdœ 'e kœdji tshama ye, 'e sœsœ dœ ɔgbɔ lɔsu nene.» ");
INSERT INTO mnh_vpl VALUES ("HB4_8","088_4_8","HEB","4","8","8","Yé œdœ Yosuwa kœto lima azu li tœnœ ɓa tœ osho nœ kœyatœsho, Ndjaba œ kpa pa má o'o tœ anga angbɨ olo bala nene. ");
INSERT INTO mnh_vpl VALUES ("HB4_9","088_4_9","HEB","4","9","9","Ataa, olo kœyatœsho nœ lɔkɔ sabata sœ mbœrœ azu nœ Ndjaba. ");
INSERT INTO mnh_vpl VALUES ("HB4_10","088_4_10","HEB","4","10","10","Gbambanœ nene, uzu á tshe li ga lœ kœyatœsho nœ ye, sœ ndje kœyatœ ye manda akwa á tshe mbœrœ ɓata á Ndjaba ya ndje lima tœ ye manda œnœ ye. ");
INSERT INTO mnh_vpl VALUES ("HB4_11","088_4_11","HEB","4","11","11","A pa avwaratœ azœ kœli ga lœ kœyatœshonœ asœmœ, adœke adja mara ɔgbɔ lɔsunœ asœke kœmbœmbœrœ adœke uzu bale te nene. ");
INSERT INTO mnh_vpl VALUES ("HB4_12","088_4_12","HEB","4","12","12","Gbambanœ nene, o'o ama Ndjaba sœ dœ soro œdœ dœ gbɔgbɔ, yé amanœ ki kœropa ɨngɨrɨ yakamba á amanœ sœ bisha. Œ sœ kœli œrrr ga tœ kœkurutshelœ uvuru dœ ɨshirɨ, tshelœ kpoto ngbabi dœ vwala. Œ sœ kœwa ngbanga ugurutœ gbetshelœ œdœ o'o á sœ ɓa lɔsu uzu. ");
INSERT INTO mnh_vpl VALUES ("HB4_13","088_4_13","HEB","4","13","13","Anga œrœ bale á Ndjaba mbœrœ á zatœ ye yiwatœ nœ tœ ala ye gugu nene. Œrœ kɔ sœ kpendro, ngbɨ tœ ala ye, yé fœ she dá a li kœpa o'o tœ upu nœ œrœnœ kɔ á a mbœrœ. ");
INSERT INTO mnh_vpl VALUES ("HB4_14","088_4_14","HEB","4","14","14","A sœ dœ egerœ nganga Ndjaba á œsœ ye lɨ, œshe kœdœ Yisu, Gbolo nœ Ndjaba. Tshe ro tɔ lœ tshalafo œ gu ga ndœ Ndjaba. Atamœ, a shi gbɨ lœ kœyindœrœ nœ azœ. ");
INSERT INTO mnh_vpl VALUES ("HB4_15","088_4_15","HEB","4","15","15","Gbambanœ nene, egerœ nganga Ndjaba nœ azœ awa bale dœ azœ lœ kœmɔ nœ azœ sœ zœ. Satana wu lima lɔsu ye lœ œrœ kɔ ɓata á tshe sœ kœmbœrœ dœ azœ, kashe tshe mbœmbœrœ ekperœ bale nene. ");
INSERT INTO mnh_vpl VALUES ("HB4_16","088_4_16","HEB","4","16","16","Ataa, a na dœ lɔsu azœ djigi ga tœ ngande tshagbozu nœ ɔtshɔ lɔsu nœ Ndjaba mbœrœ á tshe kœwu oyo azœ yekane á kœma ɔtshɔ lɔsu nœ ye ga ndœ azœ mbœrœ kœtɨ kane azœ dœ lɔkɔnœ á tshe yindœ nœ. ");
INSERT INTO mnh_vpl VALUES ("HB5_1","088_5_1","HEB","5","1","1","Egerœ nganga Ndjaba kɔ, endje ke she ugurutœ azu mbœrœ kœmbœrœ akwa tshagurutœ azu dœ Ndjaba tœ upu nœ endje. Akwa nœ ye kœdœ kœko kœtorœ œdœ tokóró mbœrœ ekperœ. ");
INSERT INTO mnh_vpl VALUES ("HB5_2","088_5_2","HEB","5","2","2","Tshe li kœsœ dœ ɔmɔ lɔsu ga ndœ azu á endje wuwusœ œrœ nene yé á sœ lœ djingili. Gbambanœ nene, œshe ndje dœ tœ ye kœdœ uzu á tshe sœ dœ kœmɔ. ");
INSERT INTO mnh_vpl VALUES ("HB5_3","088_5_3","HEB","5","3","3","Yé mbœrœ kœmɔnœ, œ li adœke tshe to tokóró mbœrœ ekperœ nœ azu œdœ ndje mbœrœ œnœ ye dœ tœ ye. ");
INSERT INTO mnh_vpl VALUES ("HB5_4","088_5_4","HEB","5","4","4","Uzu bale lili kœketœ ye dœ tœ ye adœke œne dœ egerœ nganga Ndjaba nene. Kashe Ndjaba dá e uzu ndœ kœmbœrœ tœnœ, ɓata á tshe e lima Aro. ");
INSERT INTO mnh_vpl VALUES ("HB5_5","088_5_5","HEB","5","5","5","Œtœnœ ataa dá Kristu zaza kœlɨsœtœ nœ kœwuta egerœ nganga Ndjaba ga tœ ye dœ tœ ye nene; kashe tshe gbɔ ɓa ndœ tsheneke á tshe pa fœ she adœke: «Œɓœ kœdœ Gbolo nœ mœ kpesheke, œmœ kœdœ Aba zœ.» ");
INSERT INTO mnh_vpl VALUES ("HB5_6","088_5_6","HEB","5","6","6","Yé ɓa tœ anga oshonœ, tshe pa adœke: «Œɓœ kœdœ nganga Ndjaba waa dœ waa ɓa lœ mara nœ Melekisedeke.» ");
INSERT INTO mnh_vpl VALUES ("HB5_7","088_5_7","HEB","5","7","7","Lœ soro ye ɓa pa ɔshɔ, tshe sœ lima kœza avwala dœ ɔgbɔ rawa œdœ dœ ngola fœ tsheneke á tshe li lima kœshe she lœ akuzu, yé Ndjaba yi lima ndœ nœ mbœrœ á tshe lɨ lima œsœ ye dœ kœzatœ ye ga atɨ fœ she. ");
INSERT INTO mnh_vpl VALUES ("HB5_8","088_5_8","HEB","5","8","8","Ataa œshe kœdœ lima Gbolo nœ Ndjaba gbaa, tshe wusœ kœlɨsœ Ndjaba lœ awa nœ œrœ kanga nœ ye kɔ á tshe wu. ");
INSERT INTO mnh_vpl VALUES ("HB5_9","088_5_9","HEB","5","9","9","Yé manda nœ á Ndjaba fa she lima tœ uzu á tshe li, tshe wuta lima ayi kœza kœshe nœ waa dœ waa fœ azu á endje sœ kœlɨsœ o'o ama ye. ");
INSERT INTO mnh_vpl VALUES ("HB5_10","088_5_10","HEB","5","10","10","Ndjaba ma she ngbɨ tœ egerœ nganga Ndjaba lœ mara nœ Melekisedeke. ");
INSERT INTO mnh_vpl VALUES ("HB5_11","088_5_11","HEB","5","11","11","'A sœ dœ o'o ndjoro kœpa tœ upu nœ asœ, kashe kœpandœ ádánœ gbɔ waa mbœrœ 'e kpa sœsœ kœdji tshelœkata o'o katsha katsha nene. ");
INSERT INTO mnh_vpl VALUES ("HB5_12","088_5_12","HEB","5","12","12","'E dœ má ɓalima aayi kœyisœrœ katshatsha ye. Kashe 'e kpa gbe adœke endje yisœ ali o'o nœ o'o ama Ndjaba fœ 'e. 'E sœpe damba kœgbe dœ kœa ɔngɔ, tœ œsœnœ adœke 'e zɨ ɔgbɔ rœgo. ");
INSERT INTO mnh_vpl VALUES ("HB5_13","088_5_13","HEB","5","13","13","Uzu kɔ á tshe sœpe kœa ɔngɔ, tshe lili kœmirœtshelœ ye pa upu nœ œrœ á sœ ndjii nene, mbœrœ œshe kœdœ awaya. ");
INSERT INTO mnh_vpl VALUES ("HB5_14","088_5_14","HEB","5","14","14","Kashe ɔgbɔ kœzɨrœ sœ mbœrœ agbozu á lœ awa nœ œrœ kɔ á endje mbœrœ, li kœkurutshelœ ekperœ dœ ɔtshɔrœ. ");
INSERT INTO mnh_vpl VALUES ("HB6_1","088_6_1","HEB","6","1","1","Mbœrœ tœnœ ataa, a fatœ azœ ndœ kœyisœrœ nœ agbozu yé œ katœ kœyisœrœ nœ agbolo ga manda azœ tœ upu nœ Kristu. A kpa kwakwatœ azœ ndœ œrœ á endje guma utshunœ nene: kœfatshalɔsu tœ œrœ á sœ kœyi osho ga lœ kuzu nœ ɨshirɨ yé œ sœ dœ kœyindœrœ ga ndœ Ndjaba, ");
INSERT INTO mnh_vpl VALUES ("HB6_2","088_6_2","HEB","6","2","2","kœyisœrœ tœ upu nœ batisimu, tœ upu nœ kœto kane ga pa azu, tœ upu nœ kœshe lœ akuzu œdœ pe tœ upu nœ kœwa ngbanga nœ waa dœ waa. ");
INSERT INTO mnh_vpl VALUES ("HB6_3","088_6_3","HEB","6","3","3","'E wu œrœ á li dœ azœ adœke a mbœrœ bala œdœ Ndjaba kœyindœ nœ, dœ mœ. ");
INSERT INTO mnh_vpl VALUES ("HB6_4","088_6_4","HEB","6","4","4","Gbambanœ nene, azu á endje wu ɨngbɨsho nœ Ndjaba, endje á endje wusœ kœtorœ nœ tshalafo á Ndjaba to fœ endje, endje á endje te azu nœ Ɔtshɔ Ɨshirɨ, ");
INSERT INTO mnh_vpl VALUES ("HB6_5","088_6_5","HEB","6","5","5","endje á endje dji o'o ama Ndjaba dœ ɔtshɔnœ œdœ gbɔgbɔ nœ tshapashɔ á na ɓa mbatsha ");
INSERT INTO mnh_vpl VALUES ("HB6_6","088_6_6","HEB","6","6","6","yekane á kpa yo, œ li nene adœke endje kpa fatshalɔsu endje. Andaa endje kpa sœ kœkuru Gbolo nœ Ndjaba ga pa kurushi mbœrœ kœfatshalɔsu nœ endje yé œ sœ kœgu she tœ ala azu. ");
INSERT INTO mnh_vpl VALUES ("HB6_7","088_6_7","HEB","6","7","7","Œdœ ɔshɔ kœsœ kœndjoro ungu yavuru ɔlɔ dœ ɔlɔ yé á ɔkɔ ngwarœ nœ azu á endje lu kœsœ kœga tœnœ, œ yindœ kœpa adœke Ndjaba to kane ye ga pa ɔshɔnœ ye. ");
INSERT INTO mnh_vpl VALUES ("HB6_8","088_6_8","HEB","6","8","8","Kashe œdœ œ kœsœ kœzu ishi œdœ gusu á sœ dœ ishi, œ sœ dœ ádá bale nene. Œ sœ ndoo adœke Ndjaba darandœ nœ yé œ sho. ");
INSERT INTO mnh_vpl VALUES ("HB6_9","088_6_9","HEB","6","9","9","Tœ 'e dœ aaya 'a á 'a yindœ 'e waa, 'a yindœ nœ lœ o'o á 'a sœ kœpa tœnœ adœke, 'e sœ kœza ɔtshɔ awa á sœ kœto 'e na tœnœ ndœ kœshe. ");
INSERT INTO mnh_vpl VALUES ("HB6_10","088_6_10","HEB","6","10","10","Yé Ndjaba sœ ndjii, tshe lili kœdjerœndœ akwa œdœ kœyindœsho á 'e ma ga tœ ɨ'ɨrɨ ye lœ awa nœ kœmbœrœ akwa á 'e mbœrœ lima fœ ayerœ azu œrrr ga tœ ngɔngɔ asœke nene. ");
INSERT INTO mnh_vpl VALUES ("HB6_11","088_6_11","HEB","6","11","11","Kashe ogo nœ 'a sœ adœke uzu dœ uzu zatœ ye djigi ndœ kœmbœrœ atamœ œrrr ga tœ ndɔngɔlɔnœ yekane á kœgbɔ œneke á tshe za lɔsu ye ga pa nœ. ");
INSERT INTO mnh_vpl VALUES ("HB6_12","088_6_12","HEB","6","12","12","'E mɔmɔ nene, kashe 'e za mara kœmbœrœ œrœ nœ azu á endje gbɔ œrœ á Ndjaba pa tœnœ lœ awa nœ kœyindœrœ œdœ kœru lɔsu nœ endje ga ndœ ye. ");
INSERT INTO mnh_vpl VALUES ("HB6_13","088_6_13","HEB","6","13","13","Lɔndɔ á Ndjaba pa lima tœ œrœ fœ Abrayamo, tshe dara lima ama ye dœ ɨ'ɨrɨ ye dœ tœ ye; gbambanœ nene, anga uzu á tshe ropa ye adœke tshe dara ama ye dœ ɨ'ɨrɨ ye gugu nene. ");
INSERT INTO mnh_vpl VALUES ("HB6_14","088_6_14","HEB","6","14","14","Yé tshe pa adœke: «Adjapu, mœ to kane mœ ga pa zœ waa, yé mœ mbœrœ adœke aata zœ ngba kœropanœ.» ");
INSERT INTO mnh_vpl VALUES ("HB6_15","088_6_15","HEB","6","15","15","Abrayamo sœ lima kœvu dœ ugu lɔsu yé tshe gbɔ lima œneke á Ndjaba pa lima tœnœ fœ she ye. ");
INSERT INTO mnh_vpl VALUES ("HB6_16","088_6_16","HEB","6","16","16","Azu dara ama endje dœ ɨ'ɨrɨ uzu á tshe ropa endje, yé œ sœ kœmbœrœ adœke sharapu sœ ugurutœ endje pa o'o á endje dara ama endje lœ kumunœ nene. ");
INSERT INTO mnh_vpl VALUES ("HB6_17","088_6_17","HEB","6","17","17","Andaa, Ndjaba yindœ kœma fœ azu á endje gbɔ bala œrœnœ á tshe pa lima tœnœ fœ Abrayamo adœke, sharapu œ sœ tœ upunœ nene. Tshe dara ama ye ndœ kœma adœke, o'o á œne pa dœ lɔsu œne bale asœmœ, œne kpa yapa nene. ");
INSERT INTO mnh_vpl VALUES ("HB6_18","088_6_18","HEB","6","18","18","Atamœ, Ndjaba mbœrœ œrœ bisha neke á tshe lili kœyapa tœnœ nene œdœ ndje kœpa wala tœ upunœ nene, mbœrœ kœto gbɔgbɔ á rosœ nœ fœ azœ. Mbœrœ tœnœ ataa, a sœ dœ ugu lɔsu, azœ á a sœ kœkate kœgbɔ œrœnœ á a ko lɔsu azœ ga panœ asœmœ. ");
INSERT INTO mnh_vpl VALUES ("HB6_19","088_6_19","HEB","6","19","19","Œrœnœ á a ko lɔsu azœ ga pa nœ mbœrœ adœke a shi mbœrœ tœnœ. Soro azœ shi mbœrœ tœnœ ɓata egerœ agba œ shi mbœrœ longo. Œrœnœ asœmœ li kpuru djagakele rido, ");
INSERT INTO mnh_vpl VALUES ("HB6_20","088_6_20","HEB","6","20","20","á Yisu li ɓa zœ utshunœ mbœrœ azœ, yé œ te egerœ nganga Ndjaba waa dœ waa ɓata Melekisedeke. ");
INSERT INTO mnh_vpl VALUES ("HB7_1","088_7_1","HEB","7","1","1","Melekisedeke kœdœ lima gbozugo Saleme œdœ nganga Ndjaba nœ Ndjaba á tshe ropa œrœ kɔ. Melekisedeke na para tshatshu Abrayamo dœ lɔkɔ á tshe sœ lima kœgu tœnœ manda kœnga koshe dœ agbozugo, yé œ to kane ye ga pa ye. ");
INSERT INTO mnh_vpl VALUES ("HB7_2","088_7_2","HEB","7","2","2","Œshe dá Abrayamo ko lima œrœ bale lœ ndjokpanœ á tshe gbɔ, fœ she. Utshunœ kɔ, ádá ɨ'ɨrɨ ye kœdœ «gbozugo nœ o'o á sœ ndjii», yé ga pa nœ, œshe kœdœ gbozugo Saleme á yindœ kœpa adœke «gbozugo nœ kœsœ gee». ");
INSERT INTO mnh_vpl VALUES ("HB7_3","088_7_3","HEB","7","3","3","Endje wuwusœ abanœ dœ ayinœ nene, endje wuwusœ o'o tœ upu nœ uwu aalatanœ œdœ olo kœzu she nene, endje wuwu ndje sœ ndɔngɔlɔ soro ye nene; kashe tshe sœ ɓata Gbolo nœ Ndjaba: tshe dœ́ nganga Ndjaba nœ waa dœ waa. ");
INSERT INTO mnh_vpl VALUES ("HB7_4","088_7_4","HEB","7","4","4","'E wu mara á tshe dœ egerœ uzu, œshe á ata azœ dœ Abrayamo ko œrœ bale lœ ndjokpa á tshe gbɔ lœ koshenœ fœ she. ");
INSERT INTO mnh_vpl VALUES ("HB7_5","088_7_5","HEB","7","5","5","Andaa, kœli dœ awa akwa, aata Levi á endje dœ lima anganga Ndjaba dá lima kœ'eshondœ œrœ bale lœ ndjokpa nœ azu Israyele, œ yindœ kœpa adœke aaya endje á endje kœdœ aata Abrayamo. ");
INSERT INTO mnh_vpl VALUES ("HB7_6","088_7_6","HEB","7","6","6","Melekisedeke sœsœ lima lœ uwu aata Levi nene, kashe Abrayamo to lima œrœ bale lœ ndjokpa fœ she. Gapa nœ, tshe to kane ye ga pa Abrayamo á Ndjaba pa lima tœ œrœ fœ she. ");
INSERT INTO mnh_vpl VALUES ("HB7_7","088_7_7","HEB","7","7","7","Andaa dœ sharapu nene, egerœ uzu dá to kane ye ga pa aya uzu asœmœ. ");
INSERT INTO mnh_vpl VALUES ("HB7_8","088_7_8","HEB","7","8","8","Yé endjeneke á endje sœ kœgbɔ œrœ bale lœ ndjokpa kœdœ azu á endje tshuutshu, kashe tœ upu nœ Melekisedeke, endje pa adœke œshe kœdœ uzu á tshe sœ dœ soro. ");
INSERT INTO mnh_vpl VALUES ("HB7_9","088_7_9","HEB","7","9","9","Tœ ndɔngɔlɔnœ kɔ, œneke yindœ kœpa adœke, lɔkɔ á Abrayamo ko bale lœ ndjokpa asœmœ, œ yindœ kœpa adœke Levi á tshe sœ lima kœgbɔ œrœ bale lœ ndjokpa ko ndje œnœ ye yé. ");
INSERT INTO mnh_vpl VALUES ("HB7_10","088_7_10","HEB","7","10","10","Gbambanœ nene, ataa endje zuzu lima Levi nene gbaa, œ sœ ɓata tshe sœ lima ɓa lœ atanœ dœ Abrayamo zœ lɔkɔ á Melekisedeke na lima para tshatshu ye. ");
INSERT INTO mnh_vpl VALUES ("HB7_11","088_7_11","HEB","7","11","11","Awa akwa pa adœke anganga Ndjaba œ wuta lœ uwu aata Levi. Andaa œdœ anganga Ndjaba lœ uwu aata Levi kœmbœrœ lima akwa á li, ádá nœ kœgbɔ má anga angbɨ anganga Ndjaba ɓa lœ uwu aata Melekisedeke gugu nene tœ œsœnœ adœke endje ke endje ɓa lœ uwu aata Aro. ");
INSERT INTO mnh_vpl VALUES ("HB7_12","088_7_12","HEB","7","12","12","Gbambanœ nene, œdœ endje kœyapa uwu kœmbœrœ akwa nœ anganga Ndjaba, œ li adja adœke endje yapa awa akwa. ");
INSERT INTO mnh_vpl VALUES ("HB7_13","088_7_13","HEB","7","13","13","Yé Gbozu nœ azœ á a pa o'o tœ upu nœ ye asœke, tshe sœ lœ anga angbɨ mara á anga uzu bale lœnœ mbœmbœrœ akwa nganga Ndjaba ɓa pa ndaba nene. ");
INSERT INTO mnh_vpl VALUES ("HB7_14","088_7_14","HEB","7","14","14","Azu kɔ wusœ nœ adœke tshe to lœ mara nœ Yuda, á Moyize papa lima o'o bale ala mbeti nœ ye tœ upu nœ anganga Ndjaba nene. ");
INSERT INTO mnh_vpl VALUES ("HB7_15","088_7_15","HEB","7","15","15","Yé œneke á sœ kœma œtœnœ ngbɨ kœdœ adœke: Anga nganga Ndjaba á tshe wuta, tshe sœ ɓata Melekisedeke. ");
INSERT INTO mnh_vpl VALUES ("HB7_16","088_7_16","HEB","7","16","16","Tshe wuwuta nganga Ndjaba lindœ awa akwa tœ upu nœ aata uzu nene, kashe tshe wuta nganga Ndjaba lœ awa nœ gbɔgbɔ nœ soro á ndɔngɔlɔnœ gugu nene. ");
INSERT INTO mnh_vpl VALUES ("HB7_17","088_7_17","HEB","7","17","17","Yé buku nœ Ndjaba má adœke: «Ɓœ kœdœ nganga Ndjaba nœ waa dœ waa ɓata Melekisedeke.» ");
INSERT INTO mnh_vpl VALUES ("HB7_18","088_7_18","HEB","7","18","18","Ataa, endje ka lima tœ ongboro awa akwa mbœrœ á gbɔgbɔnœ œdœ ádánœ gugu lima nene. ");
INSERT INTO mnh_vpl VALUES ("HB7_19","088_7_19","HEB","7","19","19","Gbambanœ nene, awa akwa mbœmbœrœ adœke uzu dœ uzu á tshe li nene. Kashe anga ɔtshɔrœ kœropa nœ á a za lɔsu azœ ga pa nœ mbœrœtœ ye fœ azœ, yé lœ awanœ, a li kœgitœ azœ ndoo dœ Ndjaba. ");
INSERT INTO mnh_vpl VALUES ("HB7_20","088_7_20","HEB","7","20","20","Yé œ mbœrœtœ endje dœ kœdarama nœ Ndjaba. Anga azu tete anganga Ndjaba lœ awa nœ kœdarama nene. ");
INSERT INTO mnh_vpl VALUES ("HB7_21","088_7_21","HEB","7","21","21","Kashe mbœrœ she, tshe wuta lima nganga Ndjaba lœ awa nœ kœdarama lɔkɔ má Ndjaba pa tœ upu nœ ye adœke: «Gbozu dara ama ye yé tshe yapa bala o'o ama ye nene: “ɓœ kœdœ nganga Ndjaba nœ waa dœ waa.”» ");
INSERT INTO mnh_vpl VALUES ("HB7_22","088_7_22","HEB","7","22","22","Mbœrœ tœnœ dá tafo ayo á Yisu wuta ayi kœgi sharapu ugurutœ Ndjaba dœ azœ, sœ dœ ɔtshɔnœ kœropa ongboronœ. ");
INSERT INTO mnh_vpl VALUES ("HB7_23","088_7_23","HEB","7","23","23","Ga panœ, anganga Ndjaba ngba lima waa mbœrœ endje sœ lima kœtshu tœnœ, endje lili lima kœmbœrœ akwa nœ endje waa dœ waa nene. ");
INSERT INTO mnh_vpl VALUES ("HB7_24","088_7_24","HEB","7","24","24","Kashe Yisu sœ dœ soro nœ waa dœ waa yé akwa nganga Ndjaba nœ ye œ ka nene. ");
INSERT INTO mnh_vpl VALUES ("HB7_25","088_7_25","HEB","7","25","25","Mbœrœ tœnœ ataa, tshe li kœshe dœ mara nœ waa dœ waa endjeneke á endje na lœ awa nœ ye ga ndœ Ndjaba; gbambanœ nene, tshe sœ dœ soro á ka nene ndœ kœza avwala nœ ye fœ Ndjaba tœ upu nœ endje. ");
INSERT INTO mnh_vpl VALUES ("HB7_26","088_7_26","HEB","7","26","26","Ataa, Yisu kœdœ egerœ nganga Ndjaba á tshe li má dœ azœ. Tshe sœ yerœ, tshe gugu dœ o'o nœ uzu nene, tshe mbœmbœrœ ekperœ nene. Ndjaba za she kpi tœ aayi kœmbœrœ ekperœ yé œ za she ga pa œrœ kɔ. ");
INSERT INTO mnh_vpl VALUES ("HB7_27","088_7_27","HEB","7","27","27","Tshe sœsœ ɓata anga angbɨ agboro anganga Ndjaba nene: tshe gbegbe kœza tokóró ɔlɔ dœ ɔlɔ utshunœ mbœrœ ekperœ nœ ye dœ tœ ye, yé manda nœ, mbœrœ œnœ azu ogo nene. Tshe za tokóró kolœ awa tshebabale lɔkɔ á tshe za lima tœ ye dœ tœ ye tœ tokóró. ");
INSERT INTO mnh_vpl VALUES ("HB7_28","088_7_28","HEB","7","28","28","Andaa, awa akwa sœ kœko azu á endje mɔɔmɔ tœ agboro anganga Ndjaba; kashe o'o nœ kœdarama nœ Ndjaba á na manda awa akwa, za Gbolo á tshe guma œrœ ga tœ ndɔngɔlɔnœ djigi, tœ egerœ nganga Ndjaba mbœrœ waa dœ waa. ");
INSERT INTO mnh_vpl VALUES ("HB8_1","088_8_1","HEB","8","1","1","Andaa, gilida o'o nœ azœ á a yindœ kœpa tœnœ kœdœ mara egerœ nganga Ndjaba á a sœ dœ she, œshe á tshe sœ ga atɨ ga tœ kuni ngande tshagbozu nœ Ndjaba ɓa lafo, ");
INSERT INTO mnh_vpl VALUES ("HB8_2","088_8_2","HEB","8","2","2","ɓata ayi akwa nœ adja œyerœ osho œdœ œnœ adja gbanda tande á Gbozu mɔ, kashe œ dœ́dœ́ uzu dá mɔ nene. ");
INSERT INTO mnh_vpl VALUES ("HB8_3","088_8_3","HEB","8","3","3","Endje za egerœ nganga Ndjaba kɔ ga tœ akwa mbœrœ kœto kœtorœ œdœ tokóró. Mbœrœ tœnœ ataa, œ sœ dœ ádá waa ye adœke tshe sœ dœ œrœ kœto tœnœ. ");
INSERT INTO mnh_vpl VALUES ("HB8_4","088_8_4","HEB","8","4","4","Œdœ Kristu kœsœ lima ɓa pa ɔshɔ, tshe dœ má nganga Ndjaba nene. Gbambanœ nene, anga anganga Ndjaba á endje sœ kœko kœtorœ lindœ awa akwa, sœ zœ. ");
INSERT INTO mnh_vpl VALUES ("HB8_5","088_8_5","HEB","8","5","5","Kashe endje sœ kœdonga Ndjaba ga tœ ɨshirɨ œrœ, ga tœ desherœ á sœ kœma adjapu nœ tshalafo. Mbœrœ tœnœ ataa dá Ndjaba za lima o'o fœ Moyize utshu nœ kœmɔ gbanda tande. Tshe pa fœ she adœke: «Wu, mbœrœ kɔ lindœ mara á mœ yi lima sœ nœ fœ ɓœ ɓa pa kaga.» ");
INSERT INTO mnh_vpl VALUES ("HB8_6","088_8_6","HEB","8","6","6","Adjapu, tshe sœ kœmbœrœ akwa á ropanœ kɔ, mbœrœ œshe kœdœ uzu ɓa uguru ɔtshɔ ayo á ka ga pa ɔtshɔrœ á Ndjaba pa lima tœ nœ. ");
INSERT INTO mnh_vpl VALUES ("HB8_7","088_8_7","HEB","8","7","7","Œdœ endje kœgbagbagbara o'o tœ upu nœ ayo neke lima utshunœ nene, ádá nœ kœyapa tœnœ dœ bishanœ œ gu má nene. ");
INSERT INTO mnh_vpl VALUES ("HB8_8","088_8_8","HEB","8","8","8","Kashe tœnœ kœdœ kœgbagbara osho dá Ndjaba sœ kœgbagbara dœ azu nœ ye lɔkɔ á tshe sœ kœpa adœke: «Gbozu pa adœke, dœ olo á na manda nœ, á mœ lu tafo ayo ugurutœ mœ dœ azu Israyele œdœ dœ azu ogo Yuda, ");
INSERT INTO mnh_vpl VALUES ("HB8_9","088_8_9","HEB","8","9","9","œ sœsœ ɓata ayo á sœ lima ugurutœ mœ dœ aata endje lɔkɔ á mœ ko endje dœ kane mœ mbœrœ kœko endje ga ushu lœ ogo Ezipito nene. Mbœrœ endje dœ tœ endje, endje mbœmbœrœtœ endje lima lindœ ayo nœ mœ nene. Gbozu pa adœke: œmœ ndje, mœ katœ endje tɨ ye. ");
INSERT INTO mnh_vpl VALUES ("HB8_10","088_8_10","HEB","8","10","10","Gbambanœ nene, wu ayo á mœ lu bala dœ azu Israyele manda olonœ asœmœ dœke: ndœ kœza awa akwa nœ mœ, Mœ su bala awa akwa nœ mœ ga lœ gbetshelœ nœ endje œdœ ga lɔsu endje. Mœ te bala Ndjaba nœ endje, yé endje te bala azu nœ mœ. ");
INSERT INTO mnh_vpl VALUES ("HB8_11","088_8_11","HEB","8","11","11","Uzu bale ugurutœ endje œ yisœ œrœ nene fœ yanganœ too fœ ayanœ adœke tshe wusœ mœ, mbœrœ endje para,œ wu bala sœ mœ ye, kœto kpœtœ aaya azu œrrr ga tœ agboro azu. ");
INSERT INTO mnh_vpl VALUES ("HB8_12","088_8_12","HEB","8","12","12","Gbambanœ nene, mœ djerœ bala ndœ ekperœ nœ endje, yé mœ kpa kwatœ mœ kœtondœ nœ bale nene.» ");
INSERT INTO mnh_vpl VALUES ("HB8_13","088_8_13","HEB","8","13","13","Dœ kœpandœ tafo ayo, Ndjaba fa œneke utshunœ tœ ongboronœ. Andaa, œneke á fa ongboro œrœ yé á gbɔ ye, sœ ndoo kœyiwa tœnœ. ");
INSERT INTO mnh_vpl VALUES ("HB9_1","088_9_1","HEB","9","1","1","Ali ayo sœ lima dœ mara nœ kœdonga dœ Ndjaba œdœ pe Tepelo nœ ɔshɔ. ");
INSERT INTO mnh_vpl VALUES ("HB9_2","088_9_2","HEB","9","2","2","Yé gbanda tande sœ lima kpœtœmœ, ali tshakalanœ sœ tœ osho á ɨ'ɨrɨnœ kœdœ Œyerœ osho, á miinda dœ ndaba œdœ pe mapa á endje sœ kœto fœ Ndjaba sœ lœ nœ. ");
INSERT INTO mnh_vpl VALUES ("HB9_3","088_9_3","HEB","9","3","3","Manda nœ, ɓa ngba bisha ridonœ, gbanda tande á ɨ'ɨrɨnœ kœdœ Œyerœ osho kœropanœ, ");
INSERT INTO mnh_vpl VALUES ("HB9_4","088_9_4","HEB","9","4","4","á sœ dœ ndaba á sœ dœ ɔrœ, á endje zo yombo pa nœ œdœ sanduku nœ ayo á endje dja kotenœ dœ ɔrœ sœ kpœtœmœ. Œrœ á sœ lœnœ dœke: lɔsú á endje mbœrœ dœ ɔrœ á mane sœ lima lœnœ, tshɔngbɔlɔ nœ Aro á ndɔkɔnœ wuta lima tœnœ œdœ pe ndaba nœ ayo. ");
INSERT INTO mnh_vpl VALUES ("HB9_5","088_9_5","HEB","9","5","5","Ɓa pa sandukunœ, endje ko lima œrœ bisha ɓa zœ, œrœnœ sœ lima kœma akeluba, á yindœ kœpa adœke Ndjaba dœ tœ ye sœ lima ɓa zœ zœ. Andjelunœ saka tshelœ ombo endje ga panœ ga tœ osho á endje sœ lima kœto tokóró mbœrœ adœke Ndjaba djerœndœ ekperœ nœ azu. Kashe awa kœli ga lœ kœpandœ ádánœ bale dœ bale gugu nene. ");
INSERT INTO mnh_vpl VALUES ("HB9_6","088_9_6","HEB","9","6","6","Endje guma lima œrœnœ kɔ dœ mara ataa, anganga Ndjaba sœ lima kœli ɔlɔ dœ ɔlɔ ga lœ ali tshakala gbanda tande mbœrœ kœmbœrœ akwa nœ endje. ");
INSERT INTO mnh_vpl VALUES ("HB9_7","088_9_7","HEB","9","7","7","Kashe ɓa lœ bisha tshakala gbanda tandenœ, egerœ nganga Ndjaba sœ kœli ga zœ kolœ awa bale lœ ungu bale. Tshe sœ kœli dœ indji agea kœto dœ makabo fœ Ndjaba mbœrœ ekperœ nœ ye dœ tœ ye œdœ mbœrœ œnœ azu. ");
INSERT INTO mnh_vpl VALUES ("HB9_8","088_9_8","HEB","9","8","8","Ɔtshɔ Ɨshirɨ yindœ kœma adœke awa nœ kœli ga tœ œyerœ osho mamatœ ye damba nene, mbœrœ gbanda tande neke utshunœ sœpe zœ. ");
INSERT INTO mnh_vpl VALUES ("HB9_9","088_9_9","HEB","9","9","9","Tœnœ dá sœ kœma ambárá nœ ngɔngɔ asœ. Œ dœ́dœ́ makabo œdœ tokóró á endje sœ kœto fœ Ndjaba dá sœ kœguma lɔsu uzu adœke tshe li kœdonga Ndjaba nene. ");
INSERT INTO mnh_vpl VALUES ("HB9_10","088_9_10","HEB","9","10","10","Œ sœ mbœrœ kœzɨrœ, kœndjorœ dœ pe kœdjutɔ kotœ uzu lindœ mara o'o nœ alata. Tœnœ kœdœ mara œrœ á azu sœ kœmbœrœ tœnœ œrrr ga tœ adœke endje yapa œrœ para. ");
INSERT INTO mnh_vpl VALUES ("HB9_11","088_9_11","HEB","9","11","11","Kashe Yisu na tœ egerœ nganga Ndjaba nœ ɔtshɔrœ á sœ kœna tœnœ. Tshe li tɔ lœ gbanda tande á sœ tœ egerœnœ yé á li, œ dœ́dœ́ ndje uzu dá mbœrœ nene, œ yindœ kœpa adœke, á dœ́dœ́ œnœ tshapashɔnœ asœ nene. ");
INSERT INTO mnh_vpl VALUES ("HB9_12","088_9_12","HEB","9","12","12","Œ dœ́dœ́ lœ awa nœ indji akɔ ayaburu œdœ avoro angombe nene, kashe lœ awa nœ indji ye dœ tœ ye dá tshe li kolœ awa tshebabale ga tœ œyerœ osho yé á vwara azœ lœ ekperœ nœ azœ waa dœ waa. ");
INSERT INTO mnh_vpl VALUES ("HB9_13","088_9_13","HEB","9","13","13","Gbambanœ nene, œdœ indji akɔ ayaburu dœ akɔ ngombe œdœ pe vorowo ovoro ngombe á endje dja ga tœ azu á endje mbœrœ ekperœ kœsœ kœmbœrœ adœke ɔkɔ endje wuta yerœ, ");
INSERT INTO mnh_vpl VALUES ("HB9_14","088_9_14","HEB","9","14","14","ataa, indji Kristu, á lœ awa nœ ɨshirɨ nœ waa dœ waa, á tshe zatœ ye dœ tœ ye tœ makabo fœ Ndjaba ɓata uzu á tshe mbœmbœrœ ekperœ nene kashe á tshu, rosœ nœ ye. Indji ye œ djutɔ bala lɔsu azœ lœ ekperœ nœ kuzu adœke a mbœrœ akwa fœ Ndjaba nœ soro. ");
INSERT INTO mnh_vpl VALUES ("HB9_15","088_9_15","HEB","9","15","15","Wu mbœrœ tœnœ ataa á Kristu dœ uzu ɓa uguru tafo ayo dœ ongboro ayo. Ɓata á kuzu ye wuta mbœrœ kœyɔ azu lœ kanga nœ ekperœ á mbœrœ lima tœ endje lœ ongboro ayo, endjeneke á Ndjaba e endje li ndœ kœgbɔ œrœ tshangba nœ waa dœ waa á tshe pa lima tœnœ. ");
INSERT INTO mnh_vpl VALUES ("HB9_16","088_9_16","HEB","9","16","16","Gbambanœ nene, œdœ mbeti kœko œrœ tshangba uzu kœwuta, œ sœ dœ ádá waa ye œdœ ayi kœsu mbetinœ kœtshu ye kane. ");
INSERT INTO mnh_vpl VALUES ("HB9_17","088_9_17","HEB","9","17","17","Mbeti kœko œrœ tshangba uzu sœ dœ ádá œdœ uzunœ kœtshu; kashe œdœ tshe kœsœ dœ soro, ádánœ gugu nene. ");
INSERT INTO mnh_vpl VALUES ("HB9_18","088_9_18","HEB","9","18","18","Mbœrœ tœnœ ataa, tœ kœtetœ kœmbœrœ ayo neke lima utshunœ, indji tu lima yeka. ");
INSERT INTO mnh_vpl VALUES ("HB9_19","088_9_19","HEB","9","19","19","Lɔkɔ á Moyize pandœ awa o'o liaka awa akwa fœ azu para, tshe za indji ovoro ngombe dœ œnœ akɔ ayaburu á djanga dœ ungu, á za aya ganea ɔyɔ á i usu agea ga tœnœ yé á yi ga la nœ, yeka á vwi ga tœ buku dœ tœ ye dœ pe ga tœ azu para. ");
INSERT INTO mnh_vpl VALUES ("HB9_20","088_9_20","HEB","9","20","20","Tshe pa adœke: «Asœ kœdœ indji nœ ayo á Ndjaba za awa tœnœ mbœrœ 'e.» ");
INSERT INTO mnh_vpl VALUES ("HB9_21","088_9_21","HEB","9","21","21","Manda nœ, tshe vwi ndje indjinœ ga tœ gbanda tande dœ pe gbarœ para á endje donga Ndjaba dœ tœnœ. ");
INSERT INTO mnh_vpl VALUES ("HB9_22","088_9_22","HEB","9","22","22","Lindœ awa akwa, indji dá sœ kœmbœrœ adœke œrœ kɔ wuta yerœ, yé lœ awa nœ indji dá Ndjaba œ djerœndœ ekperœ. ");
INSERT INTO mnh_vpl VALUES ("HB9_23","088_9_23","HEB","9","23","23","Ataa, œdœ ɨshirɨ œrœ á sœ ɓa lafo kœsœ yerœ lœ awa nœ mara kœdonga oshonœ asœmœ, œ li adœke adja o'o nœ tshalafo dœ tœ endje sœ ndje lœ awa nœ tokóró neke á sœ dœ ɔtshɔnœ kœropa nœ. ");
INSERT INTO mnh_vpl VALUES ("HB9_24","088_9_24","HEB","9","24","24","Gbambanœ nene, œ dœ́dœ́ ɓa tœ œyerœ osho á uzu mbœrœ dœ kane, á azu tondœ nœ yeka á mbœrœ, dá Kristu li ga lœnœ nene, kashe adja ɓa lafo. Ɓa zœ dá tshe sœ kœmatœ ye ngɔngɔnœ asœ ɓa utshu Ndjaba mbœrœ azœ. ");
INSERT INTO mnh_vpl VALUES ("HB9_25","088_9_25","HEB","9","25","25","Yé œ dœ́dœ́ manda kœzatœ ye tœ tokóró awa ndjoro ɓata á egerœ nganga Ndjaba á tshe sœ kœli ungu bale dœ bale ga lœ œyerœ osho dœ angbɨ indji nene. ");
INSERT INTO mnh_vpl VALUES ("HB9_26","088_9_26","HEB","9","26","26","Gbambanœ nene, œ kœsœ má ataa, tshe wu má lima oyo awa ndjoro kœtotœ ali kœmbœrœ tshapashɔ. Kashe tshe matœ ye kolœ awa tshebabale ɓa tœ ndɔngɔlɔ osho mbœrœ kœwo ekperœ lœ awa nœ kœzatœ ye tœ tokóró dœ tœ ye. ");
INSERT INTO mnh_vpl VALUES ("HB9_27","088_9_27","HEB","9","27","27","Yé ɓata uzu kɔ sœ mbœrœ kœtshu tœnœ awa bale yeka manda nœ, á Ndjaba œ wa ngbanga pa ye, ");
INSERT INTO mnh_vpl VALUES ("HB9_28","088_9_28","HEB","9","28","28","awa bale ndje ataa, Kristu zatœ ye tœ tokóró awa tshebabale mbœrœ kœgi ekperœ pa azu ndjoro, yé tshe kwa bala tœ ye tœ bishanœ mbœrœ upu nœ ekperœ nene, kashe mbœrœ kœza kœshe fœ azu á endje sœ kœkate kœna she. ");
INSERT INTO mnh_vpl VALUES ("HB10_1","088_10_1","HEB","10","1","1","Awa akwa nœ Moyize nana lima dœ adja o'o fœ azu nene, kashe œ sœ lima kœma ɨshirɨ ɔtshɔrœ á na bala. Awa akwa lili ndœ kœguma uzu á tshe yindœ kœna ga ndœ ndjaba nene. Mbœrœ tœnœ ataa ungu dœ ungu, endje sœ kœto kolœ tshetœ tokóró waa dœ waa. ");
INSERT INTO mnh_vpl VALUES ("HB10_2","088_10_2","HEB","10","2","2","Œdœ Ndjaba kœdjerœ lima ndœ ekperœ nœ endjeneke á endje sœ kœdonga she kolœ awa bale , endje wu má sœ nœ adœke œne kpa sœsœ lœ ekperœ nene, yé œ ka má tœ kœto tokóró fœ Ndjaba ye. ");
INSERT INTO mnh_vpl VALUES ("HB10_3","088_10_3","HEB","10","3","3","Kashe, ungu dœ ungu, endje sœpe kolœ kœto tokóró fœ Ndjaba mbœrœ kœgbe dœ ekperœ nœ endje. ");
INSERT INTO mnh_vpl VALUES ("HB10_4","088_10_4","HEB","10","4","4","Gbambanœ nene, indji akɔ angombe too œnœ aakɔ ayaburu lili ndœ kœgi ekperœ bale nene. ");
INSERT INTO mnh_vpl VALUES ("HB10_5","088_10_5","HEB","10","5","5","Mbœrœ tœnœ ataa, lɔkɔ kœna Kristu ga pa tshapashɔ, tshe pa lima adœke: «Œdœ tokóró, œdœ makabo, ɓœ yiyindœ nœ nene, kashe ɓœ mbœrœ undu fœ mœ. ");
INSERT INTO mnh_vpl VALUES ("HB10_6","088_10_6","HEB","10","6","6","Ɓœ yiyindœ agea á endje sho endje dœ owo ɓa pa ndaba too tokóró á endje to fœ ɓœ mbœrœ kœdjerœndœ ekperœ nene. ");
INSERT INTO mnh_vpl VALUES ("HB10_7","088_10_7","HEB","10","7","7","Yé mœ pa adœke: “Uu Ndjaba, Œmœ dœke, mœ na ga ndœ zœ dœ tœ mœ mbœrœ kœmbœrœ œneke á ɓœ yindœ nœ, lindœ œneke á endje sú tœ upu nœ mœ ɓa la buku á endje vwele.”» ");
INSERT INTO mnh_vpl VALUES ("HB10_8","088_10_8","HEB","10","8","8","Kristu pa utshunœ adœke: «Œdœ tokóró, œdœ makabo, œdœ agea á endje sho endje dœ owo ɓa pa ndaba, œdœ tokóró á endje to mbœrœ kœdjerœndœ ekperœ, ɓœ yiyindœ œrœ bale nene yé œ gaga ndje tœ zœ nene.» Andaa, œtœnœ kœdœ makabo á sœ lindœ awa akwa. ");
INSERT INTO mnh_vpl VALUES ("HB10_9","088_10_9","HEB","10","9","9","Yé tshe kpa pa adœke: «Wu, mœ na mbœrœ kœmbœrœ œrœ á ɓœ yindœ nœ.» Tshe sœ kœwo ongboro mara kœdonga Ndjaba mbœrœ kœza tafonœ. ");
INSERT INTO mnh_vpl VALUES ("HB10_10","088_10_10","HEB","10","10","10","Yisu Kristu mbœrœtœ ye lindœ œrœ á Ndjaba yindœ nœ; tshe zatœ ye tœ makabo awa tshebabale fœ Ndjaba, yé œtœnœ ataa dá a wuta ayerœ azu mbœrœ she. ");
INSERT INTO mnh_vpl VALUES ("HB10_11","088_10_11","HEB","10","11","11","Ɔlɔ dœ ɔlɔ, nganga Ndjaba bale dœ bale sœ kœka ga lafo ndœ kœmbœrœ akwa nœ ye, yé œ sœ kœto tshetœ tokóró kpœpanœ kpœpanœ; tokórónœ asœmœ á sœsœ kœgi ekperœ pa azu ɔlɔ bale nene. ");
INSERT INTO mnh_vpl VALUES ("HB10_12","088_10_12","HEB","10","12","12","Kashe tœ upu nœ Kristu, manda kœzatœ ye tœ tokóró awa tshebabale ndœ ekperœ nœ azu, tshe sœ ga pa kuni Ndjaba waa dœ waa. ");
INSERT INTO mnh_vpl VALUES ("HB10_13","088_10_13","HEB","10","13","13","Ngɔngɔ asœke, tshe sœ kœkate ɔlɔ á Ndjaba œ ko ayingba ye ga tshada ye. ");
INSERT INTO mnh_vpl VALUES ("HB10_14","088_10_14","HEB","10","14","14","Gbambanœ nene, lœ kœzatœ ye tœ makabo awa tshebabale asœmœ, tshe mbœrœ adœke endjeneke á tshe sœ kœmbœrœ adœke endje wuta yerœ lœ ekperœ nœ endje, te azu á endje li. ");
INSERT INTO mnh_vpl VALUES ("HB10_15","088_10_15","HEB","10","15","15","Tœnœ kœdœ neke á Ɔtshɔ Ɨshirɨ dœ tœ ye sœ kœmatœ nœ fœ azœ. Gbambanœ nene, manda kœpa adœke: ");
INSERT INTO mnh_vpl VALUES ("HB10_16","088_10_16","HEB","10","16","16","«Asœke kœdœ ayo á mœ lu bala dœ endje manda olonœ asœmœ, Gbozu pa adœke: ndœ kœza awa akwa nœ mœ, Mœ su bala awa akwa nœ mœ ga lœ gbetshelœ nœ endje œdœ ga lɔsu endje.» ");
INSERT INTO mnh_vpl VALUES ("HB10_17","088_10_17","HEB","10","17","17","Yé tshe kpa pa adœke: «Mœ kpa gbe dœ ngbɨndɨrœ œdœ dœ ekperœ nœ endje nene.» ");
INSERT INTO mnh_vpl VALUES ("HB10_18","088_10_18","HEB","10","18","18","Andaa, ɓa tœ osho á kœdjerœndœ ekperœ sœ zœ, ádá nœ kœto makabo mbœrœ ekperœ gugu bale nene. ");
INSERT INTO mnh_vpl VALUES ("HB10_19","088_10_19","HEB","10","19","19","Atamœ, alaya, a sœ kœyindœ nœ dœ lɔsu azœ adœke a li ga tœ œyerœ osho lœ awa nœ indji Yisu. ");
INSERT INTO mnh_vpl VALUES ("HB10_20","088_10_20","HEB","10","20","20","Tshe kɔrɔ tafo awa á sœ dœ soro fœ azœ lœ awa nœ rido, œ yindœ kœpa adœke lœ awa nœ undu ye dœ tœ ye. ");
INSERT INTO mnh_vpl VALUES ("HB10_21","088_10_21","HEB","10","21","21","Yé a sœ dœ egerœ nganga Ndjaba á Ndjaba za she ga tœ kumu akwa tshasœnda nœ ye. ");
INSERT INTO mnh_vpl VALUES ("HB10_22","088_10_22","HEB","10","22","22","Ataa, a na ga ndœ Ndjaba dœ lɔsu azœ ndjii œdœ lœ kœyindœrœ djigi mbœrœ tshe gi azœ lœ ngbɨndɨrœ á sœ tœ lɔsu azœ, yé œ djutɔ undu azœ dœ ungu á sœ yerœ ye. ");
INSERT INTO mnh_vpl VALUES ("HB10_23","088_10_23","HEB","10","23","23","A mɔmɔ nene, a sœpe kolœ kœyindœ œrœ á a za lɔsu azœ ga panœ; gbambanœ nene, tshe sœ kœmbœrœ œrœ lindœ œneke á tshe pa tœnœ. ");
INSERT INTO mnh_vpl VALUES ("HB10_24","088_10_24","HEB","10","24","24","A gbɔndœtœ azœ lœ ugurutœ azœ dœ anga azœ á kœmbœrœ adœke a yindœ anga azœ dœ ɔtshɔnœ dœ pe kœmbœrœ ɔtshɔ akwa. ");
INSERT INTO mnh_vpl VALUES ("HB10_25","088_10_25","HEB","10","25","25","A kpakpa lœ angbɔtœ nœ azœ nene ɓata á anga anga azœ sœ kœmbœrœ tœnœ, kashe a to gbɔgbɔ lœ tœ azœ mbœrœ 'e sœ kœwu adœke olonœ sœ kœndo tœnœ. ");
INSERT INTO mnh_vpl VALUES ("HB10_26","088_10_26","HEB","10","26","26","Gbambanœ nene, œdœ a kœsœpe kœmbœrœ ekperœ dœ lɔsu azœ manda kœwusœ adja o'o, tokóró tœ upu nœ ekperœnœ asœmœ kpa gugu nene. ");
INSERT INTO mnh_vpl VALUES ("HB10_27","088_10_27","HEB","10","27","27","Kashe, œ sœpe kolœnœ adœke a kate ɔgbɔ ngbanga á Ndjaba œ wa ga tœ azu dœ pe egerœ owo á ju ayingba ye. ");
INSERT INTO mnh_vpl VALUES ("HB10_28","088_10_28","HEB","10","28","28","Uzu neke á tshe dara pa awa akwa nœ Moyize, endje wu oyo ye nene, œdœ azu bisha too votɔ kœpa timunœ, ngbewo endje wo she ye. ");
INSERT INTO mnh_vpl VALUES ("HB10_29","088_10_29","HEB","10","29","29","Uzu neke á tshe wu Gbolo nœ Ndjaba gbambanœ, á gu œsœ indji ayo á mbœrœ adœke tshe wuta yerœ, yé á dara pa Ɨshirɨ nœ ɔtshɔ lɔsu, 'e sœ dœ gbetshelœ adœke tshe gbɔ bala egerœ djofele á ropa nœ. ");
INSERT INTO mnh_vpl VALUES ("HB10_30","088_10_30","HEB","10","30","30","Gbambanœ nene, a wusœ uzu neke á tshe pa lima adœke: «Œmœ dá gi tshangba ekperœnœ asœmœ fœ endje, œmœ dá za bala djofele fœ endje»; yé ga panœ: «Gbozu œ wa bala ngbanga ga tœ azu nœ ye.» ");
INSERT INTO mnh_vpl VALUES ("HB10_31","088_10_31","HEB","10","31","31","Œ sœ tœ ekpenœ waa adœke uzu gbɔ o'o tshakane Ndjaba nœ soro. ");
INSERT INTO mnh_vpl VALUES ("HB10_32","088_10_32","HEB","10","32","32","Kashe 'e gbe dœ ali olo nœ 'e lima kane: 'e gbɔ ɨngbɨsho yé lɔkɔnœ asœmœ, 'e shi lima gbɨ lœ egerœ koshe á gbɔɔgbɔ. ");
INSERT INTO mnh_vpl VALUES ("HB10_33","088_10_33","HEB","10","33","33","Endje sœ lima kœgu anga anga 'e ugurutœ 'e dœ pe kœmbœrœ œrœ kanga fœ endje tœ ala azu, kashe e'e kɔ, 'e yi lima ndœ kœsœ awa bale dœ anga 'e asœmœ lœ mara kœwu kanganœ ata. ");
INSERT INTO mnh_vpl VALUES ("HB10_34","088_10_34","HEB","10","34","34","Yé 'e sœ ndje lima kœwu oyo dœ aayi kánga; ataa endje gbɔtœ œrœ nœ 'e gbaa, 'e sœ kolœ dœ yanga mbœrœ tœnœ, mbœrœ 'e wusœ nœ adœke 'e gbɔ bala ɔtshɔrœ neke á œndœnœ œ dɨ waa zœ. ");
INSERT INTO mnh_vpl VALUES ("HB10_35","088_10_35","HEB","10","35","35","'E kakatœ kœyindœ œrœ á 'e sœ kœko lɔsu 'e ga pa nœ tɨ nene, mbœrœ 'e gbɔ egerœ œrœ tshangbanœ zœ. ");
INSERT INTO mnh_vpl VALUES ("HB10_36","088_10_36","HEB","10","36","36","Œ li dœ 'e kœshi gbɨ lœ kœru lɔsu 'e, yé á kœmbœrœ œrœ neke á Ndjaba yindœ nœ yeka á kœgbɔ œrœ neke á tshe pa lima tœnœ. ");
INSERT INTO mnh_vpl VALUES ("HB10_37","088_10_37","HEB","10","37","37","Gbambanœ nene, endje sú ɓala buku adœke: «Œ sœpe olo teasho, olo teasho gbambanœ, yé uzu neke á tshe na, œ na bala zœ, tshe kpalatœ ye nene. ");
INSERT INTO mnh_vpl VALUES ("HB10_38","088_10_38","HEB","10","38","38","Andaa, uzu nœ mœ á tshe sœ ndjii œ sœ dœ soro lœ awa nœ kœyindœrœ nœ ye, kashe œdœ tshe kœkwa ga manda nœ, lɔsu mœ œ sœ dœ yanga mbœrœ she nene.» ");
INSERT INTO mnh_vpl VALUES ("HB10_39","088_10_39","HEB","10","39","39","Azœ, a dœ́dœ́ azu nœ kœkwa ga manda nœ yeka á kœli ga lœ kuzu nene, kashe azœ kœdœ azu nœ kœyindœrœ mbœrœ kœshe nœ uvuru azœ. ");
INSERT INTO mnh_vpl VALUES ("HB11_1","088_11_1","HEB","11","1","1","Kœyindœrœ kœdœ mara á uzu gbɔ dœ œrœ neke á tshe za lɔsu ye ga pa nœ, œtœnœ kœdœ mara kœwusœ adja œrœ neke á uzu œ wu dœ ala ye nene. ");
INSERT INTO mnh_vpl VALUES ("HB11_2","088_11_2","HEB","11","2","2","Ndjaba ma lima o'o tœ upu nœ anga azu utshunœ mbœrœ kœyindœrœ nœ endje. ");
INSERT INTO mnh_vpl VALUES ("HB11_3","088_11_3","HEB","11","3","3","Lœ awa nœ kœyindœrœ, a sœ kœwusœ nœ adœke Ndjaba mbœrœ tshapashɔ dœ o'o ama ye. Ataa, œrœ para á a sœ kœwu tœnœ, œ to lœ neke á a wu nene. ");
INSERT INTO mnh_vpl VALUES ("HB11_4","088_11_4","HEB","11","4","4","Lœ awa nœ kœyindœrœ, Abele to ɔtshɔ tokóró fœ Ndjaba kœropa œnœ Kayina. Mbœrœ tœnœ ataa, Ndjaba ma she adœke, œshe kœdœ uzu á tshe sœ ndjii. Gbambanœ nene, Ndjaba ma ngbɨ adœke œne yindœ kœtorœ nœ ye. Mangba kœyindœrœ nœ ye, ataa tshe tshu gbaa, tshe sœpe kœpa o'o zœ. ");
INSERT INTO mnh_vpl VALUES ("HB11_5","088_11_5","HEB","11","5","5","Lœ awa nœ kœyindœrœ, Enoke wuwu kuzu dœ ala ye nene yé endje gbɔgbɔ she nene. Ndjaba za she gutœnœ ga lafo ga ɨndɨrɨ ye; yé utshu nœ kœɔ she ga lafo, endje ma lima o'o tœ upu nœ ye adœke tshe ga lima tœ ala Ndjaba. ");
INSERT INTO mnh_vpl VALUES ("HB11_6","088_11_6","HEB","11","6","6","Andaa œdœ uzu kœgugu dœ kœyindœrœ nene, tshe ga tœ ala Ndjaba nene. Gbambanœ nene, uzu neke á tshe yindœ kœna ga ndœ Ndjaba, œ li adœke tshe yindœ nœ adœke Ndjaba sœ zœ, yé tshe sœ kœgi tshangba œrœ fœ azu á endje sœ kœpara she. ");
INSERT INTO mnh_vpl VALUES ("HB11_7","088_11_7","HEB","11","7","7","Lœ awa nœ kœyindœrœ, Nowa dji lima o'o ama Ndjaba lɔkɔ á tshe ma œrœ á mbœrœtœ endje bala mbatsha fœ she. Nowa za o'onœ dœ ádá yé œ mbœrœ egerœ agba ndœ kœshe azu tshelœ bɨngɨ nœ ye. Ataa, tshe wa ɔgbɔ ngbanga ga pa azu nœ tshapashɔ yeka á wuta lima uzu ndjii tœ ala Ndjaba mbœrœ kœyindœrœ. ");
INSERT INTO mnh_vpl VALUES ("HB11_8","088_11_8","HEB","11","8","8","Lœ awa nœ kœyindœrœ, Abrayamo dji lima Ndjaba á tshe e she kœna ga lœ ogo á tshe pa lima ndœ kœza tœnœ fœ she. Abrayamo katœ ogo ye tɨ ndœ kœna ga tœ osho á tshe wuwusœ nœ nene. ");
INSERT INTO mnh_vpl VALUES ("HB11_9","088_11_9","HEB","11","9","9","Lœ awa nœ kœyindœrœ, Abrayamo na kœsœ ɓata gene ɓa tœ osho á Ndjaba pa tœ nœ fœ she. Tshe sœ lima kœlo sœnda gbanda tande bale dœ Izaka œdœ Yakobo á o'onœ á Ndjaba pa lima ndœ nœ, sœ ndje mbœrœ endje. ");
INSERT INTO mnh_vpl VALUES ("HB11_10","088_11_10","HEB","11","10","10","Gbambanœ nene, Abrayamo sœ lima kœkate ongbo neke á sœ dœ kiti anda ndjoro, á Ndjaba dœ tœ ye dœ ayi kœyisœ mara kœmɔ tœnœ œdœ ayi kœmɔ tœnœ. ");
INSERT INTO mnh_vpl VALUES ("HB11_11","088_11_11","HEB","11","11","11","Lœ awa nœ kœyindœrœ, Sara ndje, ataa ungu nœ kœzu agbolo ro lima ye, tshe zu lima gbolo mbœrœ á tshe za Ndjaba tœ uzu á tshe yayapa o'o ama ye nene. ");
INSERT INTO mnh_vpl VALUES ("HB11_12","088_11_12","HEB","11","12","12","Mbœrœ tœnœ ndje ataa, uzu bale á tshe ndo dœ kuzu, zu azu ndjoro á endje sœ ɓata angerepe ɓa lafo dœ pe mindu tœ ama egerœ ungu á endje li kœdɨ tœnœ nene. ");
INSERT INTO mnh_vpl VALUES ("HB11_13","088_11_13","HEB","11","13","13","Lœ awa nœ kœyindœrœ, azu para á endje tshu lima, endje gbɔgbɔ lima œrœ á Ndjaba pa tœnœ fœ endje nene. Kashe endje wu lima œtœnœ œ yindœ nœ lœ ɨngɨrɨnœ yé œ wusœ nœ adœke œne kœdœ agene œdœ aayi kœna ana pa ɔshɔ. ");
INSERT INTO mnh_vpl VALUES ("HB11_14","088_11_14","HEB","11","14","14","Gbambanœ nene, azu á endje pa mara o'o ataa, sœ kœma ngbɨ adœke œne sœ kœpara ogo nœ œne. ");
INSERT INTO mnh_vpl VALUES ("HB11_15","088_11_15","HEB","11","15","15","Yé œdœ endje kœsœ kœgbe dœ ogo á endje to lima lœnœ, endje kwa má tœ endje ga zœ ye. ");
INSERT INTO mnh_vpl VALUES ("HB11_16","088_11_16","HEB","11","16","16","Dœ adjapu, endje sœ lima kœpara ogo á ga dopanœ, ogo ɓa lafo. Mbœrœ tœnœ ataa, Ndjaba sœsœ dœ tshula adœke endje e œne Ndjaba nœ endje nene; yé tshe guma ongbo bale fœ endje. ");
INSERT INTO mnh_vpl VALUES ("HB11_17","088_11_17","HEB","11","17","17","Lœ awa nœ kœyindœrœ, Ndjaba wu lɔsu Abrayamo, tshe za gbolo nœ ye Izaka tœ tokóró, tshe za gbolo nœ ye tshebabale, andaa Ndjaba pa lima tœ œrœ fœ she. ");
INSERT INTO mnh_vpl VALUES ("HB11_18","088_11_18","HEB","11","18","18","Yé Ndjaba pa lima fœ she adœke: «Lœ awa nœ Izaka dá ɓœ gbɔ bala aata zœ á mœ patœ endje fœ ɓœ.» ");
INSERT INTO mnh_vpl VALUES ("HB11_19","088_11_19","HEB","11","19","19","Abrayamo sœ lima kœpa adœke Ndjaba li kœshe she uzu lœ kuzu. Mbœrœ tœnœ ataa, tshe wu lima gbolo nœ ye ɓata uzu á tshe she lœ kuzu. ");
INSERT INTO mnh_vpl VALUES ("HB11_20","088_11_20","HEB","11","20","20","Lœ awa nœ kœyindœrœ ndje, Izaka to kane ye ga pa Yakobo dœ pe Ezawu ndœ tshambatsha. ");
INSERT INTO mnh_vpl VALUES ("HB11_21","088_11_21","HEB","11","21","21","Lœ awa nœ kœyindœrœ, Yakobo ndo ndœ kœtshu tœnœ, œ to kane ga pa agbolo nœ Yozefu bale dœ bale yé œ gote dœ kœtra kumu ye ga tœ mato tshɔngbɔlɔ, yé á donga Ndjaba. ");
INSERT INTO mnh_vpl VALUES ("HB11_22","088_11_22","HEB","11","22","22","Lœ awa nœ kœyindœrœ, ndoo dœ olo kuzu Yozefu, tshe gbara o'o tœ upu nœ kœwuta agbolo Israyele lœ Ezipito yé œ za awa o'o tœ mara á endje mbœrœ dœ ngbabi ye. ");
INSERT INTO mnh_vpl VALUES ("HB11_23","088_11_23","HEB","11","23","23","Lœ awa nœ kœyindœrœ, Moyize, manda kœzu she, abanœ dœ ayinœ za lima she yiwatœ nœ manda yapu votɔ mbœrœ endje wu lima kœga nœ gbolo nœ endje, yé endje sœsœ lima dœ awa awa o'o nœ gbozugo nene. ");
INSERT INTO mnh_vpl VALUES ("HB11_24","088_11_24","HEB","11","24","24","Lœ awa nœ kœyindœrœ, lɔkɔ á Moyize wuta gbozu, tshe vwara lima tœ ye adœke endje e œne gbolo nœ yawuru nœ Farawo. ");
INSERT INTO mnh_vpl VALUES ("HB11_25","088_11_25","HEB","11","25","25","Tshe yi lima ndœ nœ adœke œne wu oyo awa bale dœ azu nœ Ndjaba, yé œ vwaratœ ye tœ œsœ nœ kœsœ lœ yanga nœ ekperœ á œndœ nœ œ dɨ nene. ");
INSERT INTO mnh_vpl VALUES ("HB11_26","088_11_26","HEB","11","26","26","Tshe wu lima kœyiangba Kristu ɓa ndœ ye ɓata kœgbɔrœ ndjoro á rosœ kœgbɔrœ nœ Ezipito; gbambanœ nene, tshe ko lima ala ye ga pa kœgbɔ bala œrœ tshangbanœ. ");
INSERT INTO mnh_vpl VALUES ("HB11_27","088_11_27","HEB","11","27","27","Lœ awa nœ kœyindœrœ, tshe katœ Ezipito tɨ œ kpakpa awa oko nœ gbozugo nene, yé tshe shi gbɨ ɓata uzu á tshe sœ kœwu Ndjaba á endje sœsœ kœwu she nene. ");
INSERT INTO mnh_vpl VALUES ("HB11_28","088_11_28","HEB","11","28","28","Lœ awa nœ kœyindœrœ, tshe mbœrœ lima angbo Pake dœ azu Israyele, yé œ pa fœ endje adœke endje dja indji agea ga pa manda nœ endje mbœrœ andjelu nœ kœwo azu kœro, á kœwowo aeya agbolo yakoshe nœ endje nene. ");
INSERT INTO mnh_vpl VALUES ("HB11_29","088_11_29","HEB","11","29","29","Lœ awa nœ kœyindœrœ, azu Israyele zu lima egerœ odoro ungu ɨngbɨrɨ ɓata ɔɔrɔ osho, yé azu Ezipito yi lima ndœ kœzu manda endje yeka á ungu su ga pa endje kpɔlirɔ. ");
INSERT INTO mnh_vpl VALUES ("HB11_30","088_11_30","HEB","11","30","30","Lœ awa nœ kœyindœrœ, Azu Israyele fa lima dje ɨndɨrɨ gbagba Yeriko manda olo mindu dœ bisha (7) yeka á kavwa. ");
INSERT INTO mnh_vpl VALUES ("HB11_31","088_11_31","HEB","11","31","31","Lœ awa nœ kœyindœrœ, Rahabe, yashe gugatɨ tshutshu lima awa bale dœ azu á endje vwaratœ endje ndœ kœdji Ndjaba nene, mbœrœ tshe za lima osho kœsœ fœ agene á endje na kœwu osho utshunœ yeka á kœgu kœvatɔ nœ. ");
INSERT INTO mnh_vpl VALUES ("HB11_32","088_11_32","HEB","11","32","32","O'o gaɗe dá mœ kpa pa a? Mœ sœsœ dœ lɔkɔ ndjoro ndœ kœpa o'o tœ upu nœ Jedeyo, Barake, Samesone, Jefete, Davidi, Samwele dœ pe aayi kœgbara o'o nene. ");
INSERT INTO mnh_vpl VALUES ("HB11_33","088_11_33","HEB","11","33","33","Mangba kœyindœrœ, endje gbɔ lima tœ osho nœ anga azu ogo, endje za lima o'o nœ kœsœ ndjii ga tœ akwa, endje gbɔ lima œrœ á Ndjaba pa tœnœ fœ endje ye, endje i lima ama amuru ga tœnœ; ");
INSERT INTO mnh_vpl VALUES ("HB11_34","088_11_34","HEB","11","34","34","endje ru lima gbɔgbɔ nœ owo, endje she lœ kuzu ɨngɨrɨ yakamba, endje á endje sœ lima dœ koɓa she dœ ɔtshɔnœ, endje sœ lima dœ gbɔgbɔ lœ koshe, endje gɔrɔ lima angbɨ aturugu. ");
INSERT INTO mnh_vpl VALUES ("HB11_35","088_11_35","HEB","11","35","35","Ayashe wu lima azu nœ endje á endje tshu, kœkwa dœ soro. Kashe anga azu wu lima oyo waa, ataa endje vwaratœ endje kœwuta lœ ekperœ mbœrœ á kœgbɔ kœshe lœ akuzu. ");
INSERT INTO mnh_vpl VALUES ("HB11_36","088_11_36","HEB","11","36","36","Ayingba endje sœ lima kœmɔ endje dœ kœɓi endje dœ ndjapa, kœi endje dœ djingiri dœ kœko endje va ga lœ anda kánga. ");
INSERT INTO mnh_vpl VALUES ("HB11_37","088_11_37","HEB","11","37","37","Endje ve lima endje dœ badja á wo endje, œ wa tshelœ anga endje dœ sii, œ wo anga endje dœ ɨngɨrɨ yakamba, endje sœ lima kœlo djezœ ngbangbangba, endje verœ lima ɔkɔ apata too œnœ ayaburu; endje gugu lima dœ œrœ nene, endje sœ lima kœmbœrœ œrœ kanga fœ endje, endje sœ lima kœwu oyo waa, ");
INSERT INTO mnh_vpl VALUES ("HB11_38","088_11_38","HEB","11","38","38","endje á tshapashɔ gaga dœ endje nene. Endje sœ lima ɓa lœ kpagagasho œdœ ɓa pa kaga, endje sœ lima ɓa lœ ɔngɔ badja dœ pe ɓa lœ gorokpa. ");
INSERT INTO mnh_vpl VALUES ("HB11_39","088_11_39","HEB","11","39","39","Endje kɔ, endje ma o'o tœ upu nœ endje mangba kœyindœrœ nœ endje, kashe endje gbɔgbɔ œrœ á Ndjaba pa lima tœ nœ nene. ");
INSERT INTO mnh_vpl VALUES ("HB11_40","088_11_40","HEB","11","40","40","Yé Ndjaba kpa guma lima sœ œrœ dœ ɔtshɔnœ kœrosœ nœ fœ azœ, œ li adœke azœ dœ endje, a sœ awa bale á kœli. ");
INSERT INTO mnh_vpl VALUES ("HB12_1","088_12_1","HEB","12","1","1","Ataa, azœ ndje á a sœ dœ atimu ndjoro ɨndɨrɨ azœ, a katœ kongba nœ azœ kɔ œdœ ekperœ á sœ kœlɨ azœ lœ ana nœ azœ, a kpa ɔrɔ dœ kœru lɔsu lœ awa á endje za ga utshu azœ. ");
INSERT INTO mnh_vpl VALUES ("HB12_2","088_12_2","HEB","12","2","2","A ko ala azœ ga pa Yisu á tshe mbœrœ adœke a sœ dœ kœyindœrœ tœ alinœ œrrr ga tœ ndɔngɔlɔnœ. Tshe yindœ kœtshu pa kurushi yé œ gbegbe dœ tshula neke á sœ mbœrœ mara kuzu ataa nene, mbœrœ tshe vwara lima tœ ye tœ yanga neke á endje gumasœ nœ fœ she, yé ngɔngɔ asœ tshe sœ ga pa kuni ngande tshagbozu nœ Ndjaba. ");
INSERT INTO mnh_vpl VALUES ("HB12_3","088_12_3","HEB","12","3","3","'E gbe dœ she tœ mara á tshe ru lɔsu ye lœ œrœ kɔ á aayi kœmbœrœ ekperœ mbœrœ ga tœ ye yeka á 'e kœmɔmɔ lœ gbetshelœ nœ 'e nene. ");
INSERT INTO mnh_vpl VALUES ("HB12_4","088_12_4","HEB","12","4","4","Gbambanœ nene, lœ koshe nœ 'e mbœrœ ekperœ, 'e nganga damba anganœ œrrr ga lœ kuzu nene. ");
INSERT INTO mnh_vpl VALUES ("HB12_5","088_12_5","HEB","12","5","5","Yé œndœ upu á endje sœ kœmɨ fœ 'e ɓata agbolo djerœ 'e ye a? «Gbolo nœ mœ, vwavwaratœ zœ tœ djofele nœ Gbozu nene, mɔmɔ lœ gbetshelœ nœ zœ nene lɔkɔ á tshe kœsœ kœgbagbara ɓœ. ");
INSERT INTO mnh_vpl VALUES ("HB12_6","088_12_6","HEB","12","6","6","Gbambanœ nene, Gbozu sœ kœyɔrɔ uzu á tshe yindœ ye, yé œ sœ kœza djofele fœ gbolo kɔ á tshe yindœ ye.» ");
INSERT INTO mnh_vpl VALUES ("HB12_7","088_12_7","HEB","12","7","7","Mbœrœ kœmbœrœ ala fœ 'e dá 'e sœ kœwu oyo. Ndjaba sœ kœmbœrœ dœ 'e ɓata agbolo nœ ye. Gbolo ɗe dá abanœ zaza djofele fœ she nene a? ");
INSERT INTO mnh_vpl VALUES ("HB12_8","088_12_8","HEB","12","8","8","Œdœ endje kœzaza djofele fœ 'e ɓata á endje za fœ agbolo kɔ nene, dá 'e dœ́dœ́ agbolo nœ Ndjaba nene, kashe 'e kœdœ agbolo á alaba 'e sœ kpi. ");
INSERT INTO mnh_vpl VALUES ("HB12_9","088_12_9","HEB","12","9","9","Alaba azœ pa ɔshɔ kœdœ aayi kœmbœrœ ala fœ azœ, yé a sœ kœdji endje. Tœ kœrosœ nœ kɔ, œ li adœke a dji Aba azœ nœ ɨshirɨ yeka á kœgbɔ soro lœ ye. ");
INSERT INTO mnh_vpl VALUES ("HB12_10","088_12_10","HEB","12","10","10","Yé endje, endje sœ lima kœza djofele fœ azœ ndœ olo teasho ɓata á endje yi lima ndœ nœ. Kashe Ndjaba sœ kœza djofele nœ ye fœ azœ mbœrœ adœke a sœ dœ ɔtshɔnœ dœ pe kœgi mara á tshe sœ yerœ dœ tœnœ fœ azœ. ");
INSERT INTO mnh_vpl VALUES ("HB12_11","088_12_11","HEB","12","11","11","Lɔkɔ á azu sœ kœgbɔ djofele, endje sœ kœwu adœke tœnœ kœdœ œrœ nœ yanga nene, kashe œrœ nœ oyo. Kashe œrrr manda nœ, azu á endje wu mara djofelenœ asœmœ œ gbɔ œrœ á sœ kœza kœsœ gee œdœ kœmbœrœ adœke uzu sœ ndjii. ");
INSERT INTO mnh_vpl VALUES ("HB12_12","088_12_12","HEB","12","12","12","Ataa, 'e yɔrɔ tshelœ kane 'e á mɔɔmɔ œdœ matshukuda 'e á sœ vwelevwele. ");
INSERT INTO mnh_vpl VALUES ("HB12_13","088_12_13","HEB","12","13","13","Yé mbœrœ ada 'e, 'e guma awa ndjii mbœrœ adœke aayi gbada kœkoko ada endje tɔsho dœ uku nene, kashe endje she. ");
INSERT INTO mnh_vpl VALUES ("HB12_14","088_12_14","HEB","12","14","14","'E para kœsœ gee dœ azu kɔ, dœ pe kœsœ yerœ á mbœrœ tœnœ nene, uzu bale œ wu Gbozu nene. ");
INSERT INTO mnh_vpl VALUES ("HB12_15","088_12_15","HEB","12","15","15","Ala 'e gbɔ adœke uzu bale wuwuta lœ ɔtshɔ lɔsu nœ Ndjaba nene. Uzu bale sœsœ ɓata eshe ɔyɔ á shuushu, á kœtetœ kœndanga too kœli ga lœ azu ndjoro nene. ");
INSERT INTO mnh_vpl VALUES ("HB12_16","088_12_16","HEB","12","16","16","Ala 'e gbɔ tœ kœmbœrœ angba budu too ayi kœmbœrœtœ œrœ á sœ yerœ ɓata á Ezawu mbœrœ lima á ka tshagbozu nœ ye kolœ mbœrœ kœzɨrœ awa bale. ");
INSERT INTO mnh_vpl VALUES ("HB12_17","088_12_17","HEB","12","17","17","Gbambanœ nene, 'e wusœ nœ manda nœ adœke, tshe yi lima ndœ nœ adœke aba œne to kane ye ga pa œne á œne kœgbɔ ɔtshɔrœ á Ndjaba pa lima tœnœ, yé tshe lili lima ndœ kœgbɔ tœnœ nene. Tshe gbɔgbɔ awa ndœ kœfa gbetshelœ nœ abanœ nene, ataa kœdɨ tshelœma nœ ye dœ kœkɨ dœ ngola ye gbaa. ");
INSERT INTO mnh_vpl VALUES ("HB12_18","088_12_18","HEB","12","18","18","E'e, 'e nana ndoo dœ anga adja œrœ á endje li kœgoro tœnœ nene: ɓata owo á sœ kœju tœnœ, ubu osho, osho á wu narɨ, ndavuru yugu, ");
INSERT INTO mnh_vpl VALUES ("HB12_19","088_12_19","HEB","12","19","19","tshama ngbake, tshama azu. Azu á endje sœ lima kœdji tshama œrœ ataa, vwaratœ endje ndœ kœdji anga o'o ga pa nœ ye. ");
INSERT INTO mnh_vpl VALUES ("HB12_20","088_12_20","HEB","12","20","20","Gbambanœ nene, endje lili lima kœru lɔsu endje tœ awa o'o asœke nene: «Uzu á tshe ɔ ga pa kaga asœ, œdœ agea, œ li adœke endje ve she dœ badja.» ");
INSERT INTO mnh_vpl VALUES ("HB12_21","088_12_21","HEB","12","21","21","Œrœ á endje sœ lima kœwu tœnœ za awa fœ endje, yé Moyize pa adœke: «Mœ sœ kœde gbaragbara dœ awa.» ");
INSERT INTO mnh_vpl VALUES ("HB12_22","088_12_22","HEB","12","22","22","Kashe e'e, 'e na ndoo dœ kaga siyona dœ pe lœ ongbo nœ Ndjaba nœ soro, dœ Yerusaleme nœ tshalafo, osho á aandjelu kutu dœ kutu sœ dœ angbɔtœ nœ angbo, ");
INSERT INTO mnh_vpl VALUES ("HB12_23","088_12_23","HEB","12","23","23","œdœ angbɔtœ nœ aeya agbolo á endje sú ɨ'ɨrɨ endje ɓa lafo, á Ndjaba ayi kœwa ngbanga nœ azu para, dœ pe ɨshirɨ azu á endje li. ");
INSERT INTO mnh_vpl VALUES ("HB12_24","088_12_24","HEB","12","24","24","'E na ga ndœ Yisu á tshe dœ uzu ugurutœ tafo ayo, á indji ye gɔrɔ ekperœ para yé á kpa sœ kœpa o'o kœropa indji Abele. ");
INSERT INTO mnh_vpl VALUES ("HB12_25","088_12_25","HEB","12","25","25","Ala 'e gbɔ adœke 'e vwavwaratœ 'e ndœ kœdji uzu á tshe sœ kœpa o'o fœ 'e nene! Gbambanœ nene, endje gbɔ lima djofele lɔkɔ á endje vwaratœ endje kœdji uzu á tshe sœ lima kœgbota tshelœ utu endje ɓa pa ɔshɔ. Endje á endje gbɔ djofelenœ ataa, á kœfutœ azœ a? A gbɔ ndje djofele œdœ á kœvwaratœ azœ kœdji tsheneke á tshe sœ kœpa o'o fœ azœ ɓa lafo. ");
INSERT INTO mnh_vpl VALUES ("HB12_26","088_12_26","HEB","12","26","26","Œshe á ɔshɔ sœ kœturu tœnœ ndœ tshama ye, ngɔngɔ asœke tshe sœ kœpa fœ azœ adœke: «Tœ ndɔngɔlɔnœ, mœ mbœrœ adœke kolœ ɔshɔ dá turu nene, kashe tshalafo ndje.» ");
INSERT INTO mnh_vpl VALUES ("HB12_27","088_12_27","HEB","12","27","27","O'onœ á tshe kpa pa awa bale tœ ndɔngɔlɔnœ sœ kœmɨndœ nœ adœke œrœ kɔ á tshe mbœrœ lima ga pa tshapashɔ á sœ kœturu tœnœ œ yiwa, yé œneke á sœsœ kœturu tœnœ nene œ sœpe. ");
INSERT INTO mnh_vpl VALUES ("HB12_28","088_12_28","HEB","12","28","28","Mbœrœ tœnœ ataa, a gbɔ ogo neke á turu nene, a tepa ɔtshɔ lɔsu nœ Ndjaba dœ ɔtshɔnœ. Lœ awa nœ œtœnœ, a mbœrœ akwa fœ Ndjaba dœ mara á tshe yindœ nœ, a dji she dœ pe kœkpa awa ye. ");
INSERT INTO mnh_vpl VALUES ("HB12_29","088_12_29","HEB","12","29","29","Gbambanœ nene, Ndjaba nœ azœ kœdœ owo á ju œrœ. ");
INSERT INTO mnh_vpl VALUES ("HB13_1","088_13_1","HEB","13","1","1","'E sœpe kœyindœtœ 'e dœ anga 'e ɓata aayazu. ");
INSERT INTO mnh_vpl VALUES ("HB13_2","088_13_2","HEB","13","2","2","Œndœ kœza osho kœsœ fœ azu djedjerœ 'e nene. Gbambanœ nene, mangbanœ dá anga azu za lima osho kœsœ fœ aandjelu, kashe endje wuwusœ nœ ataa nene. ");
INSERT INTO mnh_vpl VALUES ("HB13_3","088_13_3","HEB","13","3","3","'E gbe ndje dœ endjeneke á endje sœ lœ anda kánga ɓata 'e dœ aayi kánga awa bale dœ endje kane. 'E gbe ndje dœ endjeneke á endje sœ kœmbœrœ œrœ kanga fœ endje, mbœrœ e'e ndje, 'e sœ dœ ɔkɔ ɓata endje. ");
INSERT INTO mnh_vpl VALUES ("HB13_4","088_13_4","HEB","13","4","4","Œ li adœke azu kɔ lɨsœ totœ, yé anga ayi totœ bale lolo dœ anga angbɨ uzu kpi nene. Gbambanœ nene, Ndjaba œ wa bala ɔgbɔ ngbanga ga tœ aayi angba budu œdœ ga tœ ayi totœ á tshe para angbɨ uzu. ");
INSERT INTO mnh_vpl VALUES ("HB13_5","088_13_5","HEB","13","5","5","Œ lili adœke kœyindœsho mbœrœ ngendja ndɨ ɔtshɔ 'e nene; 'e za lɔsu 'e ga pa neke á 'e sœ dœ tœnœ mbœrœ Ndjaba dœ tœ ye pa adœke: «Mœ katœ zœ tɨ bala nene, œndœ zœ œ djerœ mœ bala nene.» ");
INSERT INTO mnh_vpl VALUES ("HB13_6","088_13_6","HEB","13","6","6","Mbœrœ tœnœ ataa, a li dœ lɔsu azœ djigi kœpa adœke: «Gbozu kœdœ ayi kœtɨ kane mœ, mœ sœsœ dœ awa nœ œrœ bale nene. Œrœ gaɗe dá uzu li kœmbœrœ tœ mœ a?» ");
INSERT INTO mnh_vpl VALUES ("HB13_7","088_13_7","HEB","13","7","7","'E gbe dœ agbozu tshapa 'e á endje pa O'o ama Ndjaba fœ 'e kane. 'E gbe dœ mara á soro endje ka dœ tœnœ, yé œ mbœrœtœ 'e lindœ kœyindœrœ nœ endje. ");
INSERT INTO mnh_vpl VALUES ("HB13_8","088_13_8","HEB","13","8","8","Yisu Kristu yayapatœ ye nene, tshe sœ awa bale libi, kpesheke œdœ waa dœ waa. ");
INSERT INTO mnh_vpl VALUES ("HB13_9","088_13_9","HEB","13","9","9","'E zazatœ 'e tɨ lœ djingili ndœ o'o nœ wala nœ angbɨ azu nene. Gbambanœ nene, œ li adœke ɔtshɔ lɔsu nœ Ndjaba to gbɔgbɔ fœ 'e, 'e zaza lɔsu 'e ga pa awa o'o tœ upu nœ kœzɨrœ nene. Endjeneke á endje sœ kœza o'o nœ kœzɨrœ ga tœ akwa, endje gbɔ tshangbanœ nene. ");
INSERT INTO mnh_vpl VALUES ("HB13_10","088_13_10","HEB","13","10","10","A sœ dœ ndaba á aayi akwa ɓa lœ gbanda tande lili kœko œneke á endje to dœ tokóró ga panœ á kœzɨ nene. ");
INSERT INTO mnh_vpl VALUES ("HB13_11","088_13_11","HEB","13","11","11","Gbambanœ nene, endje sho undu agea, á egerœ nganga Ndjaba œ na dœ indji ye ga tœ œyerœ osho mbœrœ kœyɔndœ kœdjerœndœ ekperœnœ, ɓa ushu tœ gbagba. ");
INSERT INTO mnh_vpl VALUES ("HB13_12","088_13_12","HEB","13","12","12","Mbœrœ tœnœ ataa, Yisu, ndœ kœmbœrœ adœke azu wuta yerœ lœ indji ye dœ tœ ye, tshe wuta ɓa ushu tœ ongbo á tshu. ");
INSERT INTO mnh_vpl VALUES ("HB13_13","088_13_13","HEB","13","13","13","Ataa, a wuta lœ gbagba ndœ kœna kœgbɔtœ azœ dœ she, yé œ yindœ nœ adœke endje gu azœ dœ mara á endje gu lima she. ");
INSERT INTO mnh_vpl VALUES ("HB13_14","088_13_14","HEB","13","14","14","Gbambanœ nene, pa ɔshɔ asœke, a sœsœ dœ ogo kpirɨ nene, kashe a sœ ndœ kœpara awa ogo neke á na bala. ");
INSERT INTO mnh_vpl VALUES ("HB13_15","088_13_15","HEB","13","15","15","Lœ awa nœ Yisu, a kœto makabo nœ kœdonga Ndjaba, tœnœ kœdœ itshi á a donga dœ ɨ'ɨrɨ ye. ");
INSERT INTO mnh_vpl VALUES ("HB13_16","088_13_16","HEB","13","16","16","Œndœ kœmbœrœ ɔtshɔrœ djedjerœ 'e nene, dœ pe kœtɨ kane 'e lœ tœ 'e, mbœrœ mara tokóró ataa dá sœ kœga tœ ala Ndjaba. ");
INSERT INTO mnh_vpl VALUES ("HB13_17","088_13_17","HEB","13","17","17","'E dji agbozu tshapa 'e yé œ zatœ 'e ga atɨ utshu endje. Gbambanœ nene, endje dœ tœ endje dá sœ kœgbɔndœ ɨshirɨ 'e mbœrœ endje dá pa bala ndœ upunœ fœ Ndjaba. Ataa, endje mbœrœ dœ yanga kashe dœ kœpulœma endje nene, ete nene 'e gbɔ œrœ tshangbanœ nene. ");
INSERT INTO mnh_vpl VALUES ("HB13_18","088_13_18","HEB","13","18","18","'E za avwala mbœrœ 'a. Gbambanœ nene, 'a yindœ nœ adœke 'a sœ dœ adja ɔtshɔ gbetshelœ tœ lɔsu 'a ndœ kœmbœrœ ɔtshɔrœ ɔlɔ dœ ɔlɔ. ");
INSERT INTO mnh_vpl VALUES ("HB13_19","088_13_19","HEB","13","19","19","'E mbœrœ œtœnœ, mœ sœ kœyɔndœ nœ ɔlɔ dœ ɔlɔ adœke 'e za avwala tœ upu nœ mœ á Ndjaba kœza awa fœ mœ katsha ndœ kœkwa ga ndœ 'e. ");
INSERT INTO mnh_vpl VALUES ("HB13_20","088_13_20","HEB","13","20","20","Kaka Ndjaba nœ kœsœ gee, á tshe she lima Gbozu nœ azœ dœ Yisu á fa she tœ ayi kœgbɔndœ apata, á tshe mbœrœ ayo nœ waa dœ waa dœ indji ye, ");
INSERT INTO mnh_vpl VALUES ("HB13_21","088_13_21","HEB","13","21","21","to gbɔgbɔ nœ kœmbœrœ ɔtshɔrœ kɔ á tshe yindœ nœ adœke 'e mbœrœ. Tshe mbœrœ fœ azœ œneke á ga tœ ala ye lœ awa nœ Yisu Kristu á mokɔ sœ mbœrœ she lœ ngbugu dœ ngbugu. Ame! ");
INSERT INTO mnh_vpl VALUES ("HB13_22","088_13_22","HEB","13","22","22","Alaya, mœ yɔndœ nœ ga ndœ 'e adœke 'e ru lɔsu 'e tœ kœyisœ o'o ama Ndjaba asœ! Mœ susu o'onœ ndjoro nene. ");
INSERT INTO mnh_vpl VALUES ("HB13_23","088_13_23","HEB","13","23","23","'E wusœ nœ adœke aya azœ dœ Timote wuta lœ kánga ye. Œdœ tshe kœna ga mœ katsha, mœ na kœwu 'e awa bale dœ she zœ. ");
INSERT INTO mnh_vpl VALUES ("HB13_24","088_13_24","HEB","13","24","24","'E bala agbozu tshapa 'e para dœ pe ayerœ azu kɔ. Ayerœ azu tshelœ ogo Itali vwa abala fœ 'e. ");
INSERT INTO mnh_vpl VALUES ("HB13_25","088_13_25","HEB","13","25","25","Kaka ɔtshɔ lɔsu nœ Ndjaba sœ dœ 'e para.");
INSERT INTO mnh_vpl VALUES ("JM1_1","089_1_1","JAS","1","1","1","Abala nœ 'e dœ azu tshelœ mara ndjokpa dœ bisha nœ Ayuda, á 'e ndjɔtshelœtœ 'e lœ ogo djezœ. Œmœ Jake, ayi akwa nœ Ndjaba œdœ Gbozu Yisu Kristu, mœ sœ kœsu mbetinœ asœke fœ 'e. ");
INSERT INTO mnh_vpl VALUES ("JM1_2","089_1_2","JAS","1","2","2","Aaya mœ, œdœ tshelœ áká ɔgbɔ o'o kɔ kœsœ kœna ga tœ 'e, 'e sœ dœ yanga waa mbœrœ tœnœ. ");
INSERT INTO mnh_vpl VALUES ("JM1_3","089_1_3","JAS","1","3","3","Gbambanœ nene, 'e wusœ nœ adœke lɔkɔ á 'e kœli ga lœ ɔgbɔ o'o, á kœyindœrœ nœ 'e kœsœpe sheko ga ndœ Yisu, œ mbœrœ adœke 'e shi gbɨ lœ nœ yé 'e yo nene. ");
INSERT INTO mnh_vpl VALUES ("JM1_4","089_1_4","JAS","1","4","4","Kashe œ li adœke kœshi gbɨ nœ 'e gerœ yeka á mara kœmbœrœtœ 'e kœsœ tœ ɔtshɔnœ lœ œrœ kɔ, yekane anga œrœ bale kœroro 'e nene. ");
INSERT INTO mnh_vpl VALUES ("JM1_5","089_1_5","JAS","1","5","5","Œdœ anga uzu bale ugurutœ 'e kœgugu dœ kœwusœtœ nene, œ li adœke tshe yɔndœ nœ ɓa ndœ Ndjaba á tshe kœto fœ she. Gbambanœ nene, Ndjaba sœ dœ ayo waa lœ mara kœto dœ œrœ fœ azu para kɔkɔ dœ ɔtshɔ lɔsu œdœ dœ kœgbagbara osho nene. ");
INSERT INTO mnh_vpl VALUES ("JM1_6","089_1_6","JAS","1","6","6","Œ li adœke uzu e osho ndœ nœ dœ kœyindœrœ, kashe dœ sharapu nene, mbœrœ ayi sharapu sœ ɓata loko á yugu œ ɨvwɨ na tœnœ tœ osho kɔ. ");
INSERT INTO mnh_vpl VALUES ("JM1_7","089_1_7","JAS","1","7","7","Uzu ataa gbegbe adœke œne œ gbɔ œrœ bale ɓa ndœ Gbozu nene. ");
INSERT INTO mnh_vpl VALUES ("JM1_8","089_1_8","JAS","1","8","8","Mbœrœ adœke gbetshelœ nœ ye sœsœ bale nene yé tshe kaka kpirɨ lœ awa nœ ye nene. ");
INSERT INTO mnh_vpl VALUES ("JM1_9","089_1_9","JAS","1","9","9","Kaka adœke gbolo nœ Ndjaba á tshe kœdœ ayi oyo donga tœ ye tœ œneke á Ndjaba œ tɨ she ga lafo, ");
INSERT INTO mnh_vpl VALUES ("JM1_10","089_1_10","JAS","1","10","10","yé tsheneke á sthe kœdœ ayi kœgbɔrœ donga tœ ye tœ œneke á Ndjaba œ ku she ga atɨ asœmœ. Gbambanœ nene, œndœ ayi kœgbɔrœ œ dɨ nene mbœrœ tshe sœ ɓata aya ɔyɔ tshelœ kpagagasho. ");
INSERT INTO mnh_vpl VALUES ("JM1_11","089_1_11","JAS","1","11","11","Ɔlɔ œ tɔ vwege vwege, œ ɔrɔ ɔyɔnœ, ndɔkɔnœ œ yo ga atɨ yé modonœ œ ka. Awa bale ɓata anga ɔlɔ bale ayi kœgbɔrœ œ ndɨ bala lœ ama akwa nœ ye kɔ. ");
INSERT INTO mnh_vpl VALUES ("JM1_12","089_1_12","JAS","1","12","12","Uzu á tshe wusœ kœru lɔsu ye lœ ɔgbɔ o'o, œshe kœdœ uzu nœ yanga. Gbambanœ nene, manda kœma kœru lɔsu nœ ye lœ ɔgbɔ o'o, Ndjaba œ za soro fœ she ɓata œrœ tshangba akwa á tshe gumasœ nœ tœ kœto fœ endjeneke á endje yindœ ye. ");
INSERT INTO mnh_vpl VALUES ("JM1_13","089_1_13","JAS","1","13","13","Œ kœsœ adœke lɔsu uzu vwa she ndœ kœmbœrœ ekperœ, adja tshe papa adœke: «Ndjaba dá vwa mœ ndœ nœ» nene. Ndjaba gbegbe tœ kœmbœrœ ekperœ nene yé tshe vwa vwa ndje uzu ndœ ekperœ nene. ");
INSERT INTO mnh_vpl VALUES ("JM1_14","089_1_14","JAS","1","14","14","Ogo nœ uzu dœ tœ ye dá mbœrœ adœke lɔsu ye vwa she ga lœ ekperœ. ");
INSERT INTO mnh_vpl VALUES ("JM1_15","089_1_15","JAS","1","15","15","Manda kœgerœ ekpe ogonœ asœmœ, ekperœ œ wuta lœ nœ yé œ kœsœ adœke ekperœnœ gerœ yekane á kuzu œ wuta lœ nœ. ");
INSERT INTO mnh_vpl VALUES ("JM1_16","089_1_16","JAS","1","16","16","Œrœ bale fafara 'e dœ aaya mœ á mœ yindœ 'e waa asœke nene. ");
INSERT INTO mnh_vpl VALUES ("JM1_17","089_1_17","JAS","1","17","17","Ɔtshɔ œrœ kɔ á uzu œ gbɔ gbambanœ to ɓa lafo ɓa ndœ Ndjaba ayi kœmbœrœ ɔlɔ, yapu œdœ pe angerepe. Ɓa ndœ ye, tshe yayapatœ ye nene. Ɓa ndœ ye, aya ubu osho gugu nene. ");
INSERT INTO mnh_vpl VALUES ("JM1_18","089_1_18","JAS","1","18","18","Ndjaba yindœ nœ yeka á za soro fœ azœ dœ awa o'o ama ye á dœ́ adja o'o adœke azœ dœ azu utshunœ ugurutœ œrœ kɔ á tshe mbœrœ. ");
INSERT INTO mnh_vpl VALUES ("JM1_19","089_1_19","JAS","1","19","19","E'e dœ aaya mœ á mœ yindœ 'e waa, 'e wusœ nœ kɔ tœ ɔtshɔnœ adœke: Œ li adœke uzu dœ uzu vwara tœ kœdji o'o kashe tœ kœpa o'o katsha katsha dœ pe kœso ókó katsha katsha nene. ");
INSERT INTO mnh_vpl VALUES ("JM1_20","089_1_20","JAS","1","20","20","Gbambanœ nene, uzu á tshe kœsœ dœ ókó, tshe lili tœ kœmbœrœ œneke á sœ ndjii tœ ala Ndjaba nene. ");
INSERT INTO mnh_vpl VALUES ("JM1_21","089_1_21","JAS","1","21","21","Atamœ, 'e katœ œrœ tshula dœ pe ndje kœmbœrœ ekperœ kɔ tɨ, yé œ yindœ o'o á Ndjaba za fœ 'e dœ ɔmɔ lɔsu. Gbambanœ nene, o'onœ li tœ kœshe 'e. ");
INSERT INTO mnh_vpl VALUES ("JM1_22","089_1_22","JAS","1","22","22","Œ li adœke 'e za o'o ama Ndjaba ga tœ akwa, gbetshelœ nœ 'e vwavwa 'e kolœ ndœ kœdjidji nene. ");
INSERT INTO mnh_vpl VALUES ("JM1_23","089_1_23","JAS","1","23","23","Gbambanœ nene, œdœ uzu kœdji o'o ama Ndjaba, á kœzaza ga tœ akwa nene, tshe sœ ɓata uzu á tshe sœ kœwu tshatshu ye ɓa la wushirɨ. ");
INSERT INTO mnh_vpl VALUES ("JM1_24","089_1_24","JAS","1","24","24","Yé manda kœwu tshatshu ye, tshe gitœ ye yé œndœ tshatshu ye á tshe wu má ro she ye. ");
INSERT INTO mnh_vpl VALUES ("JM1_25","089_1_25","JAS","1","25","25","Kashe œdœ uzu kœza awa akwa nœ Ndjaba á li tœ kœvwara uzu lœ kánga, á yindœ nœ dœ lɔsu bale, œdœ œndœnœ kœroro she nene á tshe kœsœ kœdji tœnœ á sœ kœza ga tœ akwa, uzunœ asœmœ œ sœ dœ yanga lœ œrœ nœ ye para kɔkɔ. ");
INSERT INTO mnh_vpl VALUES ("JM1_26","089_1_26","JAS","1","26","26","Œdœ anga uzu kœgbe adœke œne kœdœ ayi kœdonga Ndjaba, á kœwuwusœ kœgbɔndœ ama ye nene, gbetshelœ nœ ye sœ tœ kœfara she gbambanœ. Kœdonga Ndjaba nœ ye sœ gbambanœ. ");
INSERT INTO mnh_vpl VALUES ("JM1_27","089_1_27","JAS","1","27","27","Œrœ á Aba azœ dœ Ndjaba yindœ nœ adœke uzu mbœrœ tœ kœdonga œne dœ ɔtshɔnœ dœke: kœgbe dœ ayasuru dœ ayashe koya lœ oyo nœ endje, œdœ ndje pe kœgbɔndœ undu ye lœ ekperœ tshapashɔnœ asœke kɔ. ");
INSERT INTO mnh_vpl VALUES ("JM2_1","089_2_1","JAS","2","1","1","Aaya mœ, œ kœsœ adœke 'e sœ dœ kœyindœrœ ga ndœ Gbozu nœ azœ dœ Yisu Kristu á tshe sœ lœ mokɔ, adja 'e keke azu ndœ kœwu tshatshu endje nene. ");
INSERT INTO mnh_vpl VALUES ("JM2_2","089_2_2","JAS","2","2","2","'E gbe dœ o'o asœke kane. Œdœ uzu bale kœverœ œrœ kane asœ dœ ɔrœ, á verœ ɔtshɔ lœba á li ga tœ œsœ́ ngbɔtœ nœ 'e, á anga uzu neke á tshe kœdœ ayi oyo kœverœ agba lœba á li ndje dœ tœnœ, ");
INSERT INTO mnh_vpl VALUES ("JM2_3","089_2_3","JAS","2","3","3","œ kœsœ adœke 'e lɨsœ́ ayi kœverœ ɔtshɔ lœbanœ, á pa fœ she adœke: «Œɓœ á ɓœ sœ ke, sœ ga atɨ kpœke ga tœ ɔtshɔ osho asœke», yé á kœpa fœ ayi oyonœ adœke: «Œɓœ asœke, ka dœ ada zœ ɓa e», too ndje «sœ ga atɨ, ga tœ ɔshɔ ɓa tœ osho á mœ ko ada mœ tɔ ga tœ nœ», ");
INSERT INTO mnh_vpl VALUES ("JM2_4","089_2_4","JAS","2","4","4","œneke á 'e mbœrœ asœmœ má adœke 'e sœ kœwu tshatshu azu, yé 'e wuta ɓata azu kœwa o'o á endje wa ngbanga dœ ekpe gbetshelœ. ");
INSERT INTO mnh_vpl VALUES ("JM2_5","089_2_5","JAS","2","5","5","E'e dœ aaya mœ á mœ yindœ 'e waa, 'e dji mœ kane. Ndjaba ke ayi oyo pa ɔshɔ adœke endje sœ tœ ayi kœgbɔrœ lœ kœyindœrœ ga ndœ Yisu yeka á endje kœli ga lœ ogo gbozu á Ndjaba pandœ nœ adœke, œne za fœ azu á endje yindœ œne. ");
INSERT INTO mnh_vpl VALUES ("JM2_6","089_2_6","JAS","2","6","6","Kashe e'e, 'e wuwu ayi oyo lœ ala 'e gbambanœ nene. Azu aɗe dá sœ kœmbœrœ agbɔ œrœ dœ kumu 'e a? Aɗe dá sœ kœna dœ 'e ga utshu ayi kœwa ngbanga a? Œ dœ́dœ́ ayi kœgbɔrœ nene a? ");
INSERT INTO mnh_vpl VALUES ("JM2_7","089_2_7","JAS","2","7","7","Œ dœ́dœ́ kolœ endje dá sœ kœndɨ ɔtshɔ ɨ'ɨrɨ á Ndjaba za ga pa e'e nene a? ");
INSERT INTO mnh_vpl VALUES ("JM2_8","089_2_8","JAS","2","8","8","Adja 'e sœ kœmbœrœ dœ ɔtshɔnœ œdœ 'e kœsœ kœza awa akwa nœ Gbozu Ndjaba ga tœ akwa. Awa akwanœ á Buku nœ Ndjaba œ pa tœnœ adœke: «Yindœ yanga zœ ɓata á ɓœ yindœtœ zœ dœ tœ zœ.» ");
INSERT INTO mnh_vpl VALUES ("JM2_9","089_2_9","JAS","2","9","9","Kashe œ kœsœ adœke 'e ke azu mbœrœ kœwu tshatshu endje, 'e sœ kœmbœrœ ekperœ. Ataa, awa akwa nœ Ndjaba yisœ nœ adœke 'e te dœ o'o ye. ");
INSERT INTO mnh_vpl VALUES ("JM2_10","089_2_10","JAS","2","10","10","Yé uzu á tshe kœza awa akwanœ djigi ga tœ akwa, á kœkatœ anganœ bale, tshe te dœ tœnœ para kɔkɔ ye. ");
INSERT INTO mnh_vpl VALUES ("JM2_11","089_2_11","JAS","2","11","11","Gbambanœ nene, uzu á tshe pa adœke: «Adja papara awo uzu too akɔ uzu nene», pa ndje adœke: «Adja ɓœ wowo uzu nene.» Œ kœsœ adœke ɓœ papara awo uzu too akɔ uzu nene, kashe ɓœ kœwo uzu, ɓœ te dœ awa akwa nœ Ndjaba para kɔkɔ. ");
INSERT INTO mnh_vpl VALUES ("JM2_12","089_2_12","JAS","2","12","12","'E pa o'o, 'e mbœrœtœ 'e ɓata azu á Ndjaba œ wa ngbanga pa endje liaka awa akwanœ á vwara azœ lœ ekperœ. ");
INSERT INTO mnh_vpl VALUES ("JM2_13","089_2_13","JAS","2","13","13","Gbambanœ nene, Ndjaba œ wu oyo nene œ kœsœ adœke tshe wa ngbanga pa uzu á tshe wuwu ndje oyo azu nene. Kashe kœwu oyo azu ropa kœwa ngbanga ye. ");
INSERT INTO mnh_vpl VALUES ("JM2_14","089_2_14","JAS","2","14","14","Aaya mœ, œ kœsœ adœke anga uzu pa adœke œne sœ dœ kœyindœrœ ga ndœ Ndjaba, á tshe kœmbœmbœrœ ɔtshɔ akwa nene, ádá kœyindœrœ nœ ye sœ zœ dœmœ a? Yé kœyindœrœnœ asœmœ œ she má she kotoo? ");
INSERT INTO mnh_vpl VALUES ("JM2_15","089_2_15","JAS","2","15","15","Œ kœsœ adœke anga aya 'e too yingɔ 'e, á tshe kœgugu dœ lœba kœverœ ga tœ ye nene, too ndje dœ rœgo kœzɨ ɔlɔ dœ ɔlɔ nene, ");
INSERT INTO mnh_vpl VALUES ("JM2_16","089_2_16","JAS","2","16","16","á anga uzu bale ugurutœ e'e kœpa fœ endje adœke: «'E verœ lœba ɨzɨ yé œ gu yé œ zɨ œrœ dœ ɔtshɔnœ», kashe 'e toto œrœ á endje gbe dœ tœnœ fœ endje nene, ataa ádá o'onœ á 'e pa sœ zœ dœmœ a? ");
INSERT INTO mnh_vpl VALUES ("JM2_17","089_2_17","JAS","2","17","17","Œ sœ ndje awa bale mbœrœ kœyindœrœ ga ndœ Ndjaba. Gbambanœ nene, œ kœsœ adœke uzu sœ dœ kœyindœrœ, kashe tshe kœmbœmbœrœ ɔtshɔ akwa nene, kœyindœrœ nœ ye tshu ye. ");
INSERT INTO mnh_vpl VALUES ("JM2_18","089_2_18","JAS","2","18","18","Kashe œ kœsœ adœke anga uzu pa adœke: «Œɓœ á ɓœ sœ ke, sœ dœ kœyindœrœ, yé mœ mbœrœ akwa», mœ gi fœ she adœke: «Ma fœ mœ mara á uzu li kœsœ dœ kœyindœrœ ga ndœ Ndjaba á kœgugu dœ akwa nene, ataa lœ awa akwa nœ mœ, mœ ma mara á mœ sœ dœ kœyindœrœ ga ndœ Ndjaba fœ ɓœ.» ");
INSERT INTO mnh_vpl VALUES ("JM2_19","089_2_19","JAS","2","19","19","Ɓœ wusœ nœ adœke Ndjaba sœ tshebabale? Tœ ɔtshɔnœ. Kashe ekpe ɨshirɨ wu ndje sœ nœ atamœ, yé endje de gbara gbara dœ awa. ");
INSERT INTO mnh_vpl VALUES ("JM2_20","089_2_20","JAS","2","20","20","Ɓœ gugu dœ kœwusœrœ nene. Ɓœ yindœ nœ adœke mœ ma fœ ɓœ adœke kœyindœrœ á gugu dœ akwa nene sœ gbambanœ a? ");
INSERT INTO mnh_vpl VALUES ("JM2_21","089_2_21","JAS","2","21","21","Ata azœ dœ Abrayamo wuta lima ɔtshɔ uzu tœ ala Ndjaba mbœrœ kœmbœrœ ɔtshɔ akwa, á mbœrœ adœke tshe yi lima ndœ kœza gbolo nœ ye Isaka tœ tokóró fœ Ndjaba. ");
INSERT INTO mnh_vpl VALUES ("JM2_22","089_2_22","JAS","2","22","22","Wusœ nœ adœke kœyindœrœ œdœ akwa nœ ye na lima awa bale: kœyindœrœ nœ ye wuta dœ ɔtshɔnœ mbœrœ akwa á tshe mbœrœ. ");
INSERT INTO mnh_vpl VALUES ("JM2_23","089_2_23","JAS","2","23","23","O'onœ mbœrœtœ ye ɓata á Buku nœ Ndjaba pa adœke: «Abrayamo yindœ o'o ama Ndjaba yé mbœrœ tœnœ ataa, Ndjaba wu she tœ uzu á tshe sœ ndjii.» Mbœrœ tœnœ atamœ, Ndjaba e she adœke yanga œne. ");
INSERT INTO mnh_vpl VALUES ("JM2_24","089_2_24","JAS","2","24","24","'E wusœ nœ adœke, uzu œ wuta ndjii tœ ala Ndjaba mbœrœ kœmbœrœ ɔtshɔ akwa, kashe œ sœsœ kolœ mbœrœ kœyindœrœ bale nene. ");
INSERT INTO mnh_vpl VALUES ("JM2_25","089_2_25","JAS","2","25","25","Œ sœ ndje awa bale tœ upu nœ Rahabe yashe gu ga atɨ ɓa lœ Yeriko. Œ dœ́dœ́ mbœrœ akwa nœ ye dá tshe wuta lima uzu ndjii tœ ala Ndjaba na a? Tshe za lima osho kœsœ fœ ayi avwa nœ Ayuda, á ko endje kpa wuta tœnœ dœ angbɨ awa. ");
INSERT INTO mnh_vpl VALUES ("JM2_26","089_2_26","JAS","2","26","26","Ɓata uzu kœwuwu nene, tshe tshu ye, awa bale œdœ kœyindœrœ nœ uzu kœvwavwa she ndœ kœmbœrœ akwa nene, kœyindœrœ nœ tshu ndje ye. ");
INSERT INTO mnh_vpl VALUES ("JM3_1","089_3_1","JAS","3","1","1","Aaya mœ, adja azu ndjoro ugurutœ e'e yiyindœ nœ adœke œne te aayi kœyisœrœ nene. Gbambanœ nene, Ndjaba œ wa bala ɔgbɔ ngbanga pa azœ dœ ayi kœyisœrœ, kœropa œnœ udu anga azu. ");
INSERT INTO mnh_vpl VALUES ("JM3_2","089_3_2","JAS","3","2","2","Azœ kɔ, a sœ kœyo tœnœ ɔlɔ dœ ɔlɔ. Œ kœsœ adœke uzu mbœrœ ekperœ lœ o'o á tshe pa nene, uzunœ asœmœ kœdœ ɔtshɔ uzu tako. Tshe li ndje kœsœ tœ gbozu tshapa undu ye kɔ. ");
INSERT INTO mnh_vpl VALUES ("JM3_3","089_3_3","JAS","3","3","3","A ko yarakowo ga lœ ama ambarata adœke endje dji azœ, yé a yɔrɔ endje adœke endje na tœ awa á a yindœ nœ. ");
INSERT INTO mnh_vpl VALUES ("JM3_4","089_3_4","JAS","3","4","4","'E gbe ndje dœ masuwa: œ sœ tœ egerœnœ gbaa, œdœ ndje ndavuru yugu sœmœ á vwi masuwanœ gbaa, ayi kœgbota tœnœ œ turu kolœ tœ aya yindanœ teasho yekane á fa masuwanœ ngoro ngoro ngoro ga tœ osho á tshe gbe kœfa ga tœ nœ. ");
INSERT INTO mnh_vpl VALUES ("JM3_5","089_3_5","JAS","3","5","5","Awa bale dœ tima azœ: œtœnœ kœdœ aya œrœ teasho lœ undu uzu, yé œ sœ kœmbœrœ ko ogboro œrœ. 'E gbe dœ aya owo teasho á tetœ egerœ gusu, yé gusunœ œ ju kpa. ");
INSERT INTO mnh_vpl VALUES ("JM3_6","089_3_6","JAS","3","6","6","Tima kœdœ œrœ kote uzu á sœ ɓata owo. Œtœnœ kœdœ anda ekperœ. Œ ndɨ undu azœ dœ uburu yé œ tshi ɓata owo lifelo. Œ ju uzu kœto ɓa tœ kœzu she œrrr kpa ga tœ kuzu ye. ");
INSERT INTO mnh_vpl VALUES ("JM3_7","089_3_7","JAS","3","7","7","Uzu kɔ mbœrœ adœke œne dœ gbozu tshapa mara agea kɔ, agea gusu dœ pe ayanu, dœ agea á endje ɔrɔ tœ ɔshɔ, dœ ageatshalangu, yé endje dji she. ");
INSERT INTO mnh_vpl VALUES ("JM3_8","089_3_8","JAS","3","8","8","Kashe uzu bale lili tœ kœsœ tœ gbozu tshapa tima ye nene. Tœnœ kœdœ ekperœ á uzu lili kœtepa nœ pa ɔshɔ nene, œ suusu dœ ekpe ɔyɔ tœ kœwo azu. ");
INSERT INTO mnh_vpl VALUES ("JM3_9","089_3_9","JAS","3","9","9","A donga Gbozu á tshe dœ Aba azœ dœ tima azœ, yé œ darandœ azu, á Ndjaba mbœrœ endje ɓata ɨshirɨ ye dœ tœ ye, kolœ dœ tima bale asœmœ. ");
INSERT INTO mnh_vpl VALUES ("JM3_10","089_3_10","JAS","3","10","10","Ɔtshɔ o'o kœdonga dœ Ndjaba ndje dœ ekpe o'o kœdarandœ azu wuta kɔ kolœ ama azœ. Aaya mœ, œ lili adœke œrœ atake mbœrœtœ ye nene. ");
INSERT INTO mnh_vpl VALUES ("JM3_11","089_3_11","JAS","3","11","11","Adja ɔtshɔ ungu dœ ekpe ungu wuta ɓa lima lœ ogoro bale a? ");
INSERT INTO mnh_vpl VALUES ("JM3_12","089_3_12","JAS","3","12","12","Aaya mœ, ɔyɔ fige zu ele olive yeka œdœ ɔyɔ vinu á zu ele fige ma? Awa bale ungu kœndjoondjo wuwuta lœ ogoro bale dœ ungu ɨngbɨrɨ nene. ");
INSERT INTO mnh_vpl VALUES ("JM3_13","089_3_13","JAS","3","13","13","Œɗe ugurutœ 'e kɔ kœdœ uzu kœwusœtœ œdœ kœwusœrœ a? Kaka tshe yisœ nœ lœ awa kœmatœ ye tœ uzu nœ ɔtshɔ́ ɔtshɔ yé œ mbœrœ akwa nœ ye para kɔkɔ dœ ɔmɔ lɔsu œdœ pe kœwusœrœ. ");
INSERT INTO mnh_vpl VALUES ("JM3_14","089_3_14","JAS","3","14","14","Kashe, 'e kœsœ dœ gbetshelœ kœropa anga 'e, á lɔsu 'e kœsu dœ ekpe úkú, adja 'e koko ombo ga tœ 'e nene yé œ pa wala dœ ɨ'ɨrɨ adja o'o nene. ");
INSERT INTO mnh_vpl VALUES ("JM3_15","089_3_15","JAS","3","15","15","Mara kœwusœtœnœ asœke toto ɓa ndœ Ndjaba nene, œ dœ kœwusœtœ tshapashɔ nœ asœke, kœwusœtœ nœ azu, kœwusœtœ á to lœ ekpe ɨshirɨ. ");
INSERT INTO mnh_vpl VALUES ("JM3_16","089_3_16","JAS","3","16","16","Gbambanœ nene, úkú œdœ pe kœko ombo ga tœ azu dá sœ kœzu djingili œdœ pe ala ekperœ kɔ. ");
INSERT INTO mnh_vpl VALUES ("JM3_17","089_3_17","JAS","3","17","17","Kashe uzu á tshe sœ dœ kœwusœtœ á to ɓa ndœ Ndjaba, tshe kœdœ uzu nœ œyerœ lɔsu, tshe bœbœrœtœ ye nene, tshe sœ dœ ɔtshɔ lɔsu, œ sœ ndje dœ lɔsu nœ kœdji azu, tshe dœ́ uzu nœ kœwu oyo anganœ. Tshe kœdœ uzu nœ kœmbœrœ ɔtshɔ akwa, uzu nœ kœwu tshatshu azu nene yé tshe dœ́dœ́ wulapatshɔ nene. ");
INSERT INTO mnh_vpl VALUES ("JM3_18","089_3_18","JAS","3","18","18","Azu neke á ndje yindœ kœsœ gee, endje lœ ɓata azu kœdjo kɨndɨ á endje gɨ kœsœ gee dji kpata ɨndɨrɨ endje yé ngwarœ á endje rɔ kœdœ soro á sœ ndjii. ");
INSERT INTO mnh_vpl VALUES ("JM4_1","089_4_1","JAS","4","1","1","Œbœrœ œdœ pe koshe ugurutœ 'e to kpœta a? Asœmœ kɔ to lœ ogo nœ e'e dœ tœ 'e á sœ kœdutœ endje lœ gbetshelœ nœ 'e asœmœ nene a? ");
INSERT INTO mnh_vpl VALUES ("JM4_2","089_4_2","JAS","4","2","2","'E sœ dœ ogo kœgbɔ œrœ kashe 'e gbɔ nene yé 'e wuta ayi kœwo azu. 'E sœ dœ úkú mbœrœ œrœ ndjoro yé ɓata á 'e sœsœ kœgbɔ œrœnœ nene, 'e fa ga lœ koshe. 'E gbɔgbɔ œrœ á 'e sœ kœpara nene mbœrœ á 'e ee osho ndœ nœ ga ndœ Ndjaba nene. ");
INSERT INTO mnh_vpl VALUES ("JM4_3","089_4_3","JAS","4","3","3","Œ kœsœ adœke 'e e osho ndœ nœ ga ndœ Ndjaba, 'e gbɔ nene mbœrœ á 'e sœ kœ'e osho nœ dœ ekpe gbetshelœ; gbambanœ nene, 'e e osho ndœ œrœ kɔ mbœrœ ogo undu 'e dœ tœ 'e. ");
INSERT INTO mnh_vpl VALUES ("JM4_4","089_4_4","JAS","4","4","4","'E sœ kœfara Ndjaba, 'e fatœ 'e ɓata ayashe angba. 'E wuwusœ nœ nene adœke kœyindœ tshapashɔ nœ asœke kœdœ kœyiangba Ndjaba a? Uzu á tshe kœyindœ tshapashɔ asœke, tshe wuta ngbewo ayingba Ndjaba. ");
INSERT INTO mnh_vpl VALUES ("JM4_5","089_4_5","JAS","4","5","5","Buku nœ Ndjaba pa adœke: «Ndjaba sœ dœ úkú waa mbœrœ ɨshirɨ á tshe za ga lœ azœ.» 'E gbe adœke o'onœ asœmœ wuta gbambanœ a? ");
INSERT INTO mnh_vpl VALUES ("JM4_6","089_4_6","JAS","4","6","6","Kashe Ndjaba sœ dœ ɔtshɔ lɔsu ga ndœ azœ kœropa nœ, gbambanœ nene Buku nœ ye pa adœke: «Ndjaba vwaratœ ye tœ ayengɔ egerœ kumu, kashe tshe sœ dœ ɔtshɔ lɔsu ga ndœ endjeneke á endje zatœ endje ga atɨ.» ");
INSERT INTO mnh_vpl VALUES ("JM4_7","089_4_7","JAS","4","7","7","Atamœ, 'e zatœ 'e ga tœ o'o ama Ndjaba, œ vwaratœ 'e tœ Satana á tshe kœgitœ ye tœ 'e lœ ɨngɨrɨnœ. ");
INSERT INTO mnh_vpl VALUES ("JM4_8","089_4_8","JAS","4","8","8","'E gitœ 'e ndo dœ Ndjaba yeka á tshe kœgitœ ye ndje ndœ 'e. E'e dœ azu kœmbœrœ ekperœ, 'e yapa ɔtshɔ 'e. E'e á 'e sœ dœ lɔsu bisha bisha, 'e mbœrœ adœke 'e wuta dœ lɔsu bale. ");
INSERT INTO mnh_vpl VALUES ("JM4_9","089_4_9","JAS","4","9","9","'E yindœ nœ adœke 'e dœ́ azu oyo, 'e kɨ. 'E katœ kœmɔtœ 'e yé œ kɨ dœ ngola. 'E katœ kœsœ dœ yanga kashe 'e sœ dœ oyo. ");
INSERT INTO mnh_vpl VALUES ("JM4_10","089_4_10","JAS","4","10","10","'E zatœ 'e ga atɨ utshu Gbozu yeka á tshe kœtɨ 'e ga lafo. ");
INSERT INTO mnh_vpl VALUES ("JM4_11","089_4_11","JAS","4","11","11","Aaya, 'e papa ekpe o'o goro œsœ́ anga 'e nene. Uzu tsheneke á tshe kœpa ekpe o'o goro œsœ́ yanganœ too ndje á kœwa ngbanga pa yanganœ, œ sœ ɓata tshe pa ekpe o'o ga tœ awa akwa nœ Ndjaba too ndje tshe wa ngbanga pa nœ. Œdœ ɓœ kœwa ngbanga pa awa akwa, ɓœ kœdœ ayi kœwa ngbanga pa nœ kashe ɓœ dœ́dœ́ ayi kœza ga tœ akwa nene. ");
INSERT INTO mnh_vpl VALUES ("JM4_12","089_4_12","JAS","4","12","12","Gbambanœ nene, Ndjaba bale dá dœ ayi kœza awa akwa dœ pe ayi kœwa ngbanga, œshe dá li kœshe azu too kœwo endje. Kashe œɓœ kœdœ ɗe yekane á kœwa ngbanga pa yanga zœ a? ");
INSERT INTO mnh_vpl VALUES ("JM4_13","089_4_13","JAS","4","13","13","'E dji mœ dœ ɔtshɔnœ, e'e dœ azu á 'e pa adœke: «Kpœsheke too ɓa mbatsha 'a na ɓa lakpɨ asœke, 'a lo ɓa zœ ngbugu bale, 'a ka œrœ nœ 'a yé 'a gbɔ ngendja.» ");
INSERT INTO mnh_vpl VALUES ("JM4_14","089_4_14","JAS","4","14","14","Andaa 'e wuwusœ œrœ neke á wuta ga tœ e'e ɓa mbatsha nene. 'E sœ ɓata ngawo á da yé œndœnœ œ dɨ nene yeka á yiwa. ");
INSERT INTO mnh_vpl VALUES ("JM4_15","089_4_15","JAS","4","15","15","'E li má kœpa adœke: «Œ kœsœ adœke Gbozu yindœ nœ, á 'a kœsœpe dœ soro, 'a mbœrœ œrœ neke, too ndje œneke asœke.» ");
INSERT INTO mnh_vpl VALUES ("JM4_16","089_4_16","JAS","4","16","16","Kashe ngɔngɔ asœ, 'e sœ kœdonga tœ 'e tœ œrœ á 'e gbe tœ kœmbœrœ tœnœ. Kœdongatœsho kɔ nœ mara asœke sœ tœ ekpenœ. ");
INSERT INTO mnh_vpl VALUES ("JM4_17","089_4_17","JAS","4","17","17","Atamœ, uzu á tshe wusœ kœmbœrœ ɔtshɔrœ á yiyindœ kœmbœrœ tœnœ nene, sœ kœmbœrœ ekperœ. ");
INSERT INTO mnh_vpl VALUES ("JM5_1","089_5_1","JAS","5","1","1","'E dji mœ dœ ɔtshɔnœ, e'e dœ ayi kœgbɔrœ: ngɔngɔ asœ 'e kɨ, 'e sa rawa mbœrœ oyo á sœ kœkate 'e! ");
INSERT INTO mnh_vpl VALUES ("JM5_2","089_5_2","JAS","5","2","2","Œrœ nœ 'e á 'e gbɔ fu yé akɔkɔ zɨ lœba nœ 'e ye. ");
INSERT INTO mnh_vpl VALUES ("JM5_3","089_5_3","JAS","5","3","3","Ɔrœ nœ 'e dœ pe kowo nœ 'e ko ngbandji. Ngbandjinœ má fœ 'e adœke 'e ndo tœ kœsho 'e dœ owo. 'E ngbɔɓa kœgbɔrœ ndjoro mbœrœ e'e dœ tœ 'e, andaa kœka tshapashɔnœ asœke ndo ye. ");
INSERT INTO mnh_vpl VALUES ("JM5_4","089_5_4","JAS","5","4","4","'E wu œrœ tshangba akwa kɨndɨ á ayi akwa nœ e'e mbœrœ fœ 'e á 'e vwaratœ 'e kœko fœ endje. Œ sœsœ ndjii nene! 'E dji mara á endje sœ kœkɨ tœnœ yé Gbozu á tshe sœ dœ gbɔgbɔ kɔ dji ɨkɨ endje. ");
INSERT INTO mnh_vpl VALUES ("JM5_5","089_5_5","JAS","5","5","5","'E gbɔ œrœ waa lœ soro 'e pa ɔshɔ yé 'e mbœrœ œneke á lɔsu 'e yindœ nœ. 'E wuta ɓata ayarœ ojoro á endje gbɔndœ endje tœ kœwo endje. ");
INSERT INTO mnh_vpl VALUES ("JM5_6","089_5_6","JAS","5","6","6","'E wa ɔgbɔ ngbanga pa azu, 'e wo endjeneke á endje sœ ndjii tœ ala Ndjaba yé endje vwavwaratœ endje nene. ");
INSERT INTO mnh_vpl VALUES ("JM5_7","089_5_7","JAS","5","7","7","Atamœ aaya, 'e sœ dœ kœru lɔsu œrrr ga tœ kœkwa Gbozu Yisu. 'E gbe dœ kœru lɔsu nœ ayi kœdjo kɨndɨ: manda kœni ali yavuru, tshe tɔrɔ kɨndɨ nœ ye. Tshe kate anga yavuru œrrr ga tœ anga osho mbœrœ kœzɨ ngwarœ kɨndɨ nœ ye. ");
INSERT INTO mnh_vpl VALUES ("JM5_8","089_5_8","JAS","5","8","8","E'e ndje awa bale, œ li adœke 'e sœ dœ kœru lɔsu, œ shi gbɨ tœ lɔsu 'e; gbambanœ nene, lɔkɔ kœkwa Gbozu ndo ye. ");
INSERT INTO mnh_vpl VALUES ("JM5_9","089_5_9","JAS","5","9","9","Aaya, 'e pupulœma 'e ugurutœ 'e tœ upu nœ anga 'e nene mbœrœ á endje kœwawa ngbanga pa 'e nene. 'E wu: ayi kœwa ngbanga ka lœ talamanda. ");
INSERT INTO mnh_vpl VALUES ("JM5_10","089_5_10","JAS","5","10","10","Aaya, 'e mbœrœ mara œrœ nœ aayi kœgbara o'o á endje sœ lima kœpa o'o dœ ɨ'ɨrɨ Gbozu: mara á endje sœ liya kœru lɔsu endje lœ ɔgbɔ o'o á sœ lima kœna ga ndœ endje. ");
INSERT INTO mnh_vpl VALUES ("JM5_11","089_5_11","JAS","5","11","11","'E wu: a e endje azu yanga mbœrœ kœru lɔsu nœ endje. 'E dji o'o tœ upu kœshi gbɨ nœ Yobo yé 'e wu œneke á Gbozu mbœrœ fœ she manda nœ; gbambanœ nene, Gbozu sœ lima dœ ugu lɔsu œdœ pe lɔsu nœ kœwu oyo. ");
INSERT INTO mnh_vpl VALUES ("JM5_12","089_5_12","JAS","5","12","12","Kœropa nœ kɔ, aaya mœ, adja 'e wawa ɨgɨ 'e ndje dœ ɨ'ɨrɨ Ndjaba nene, too dœ ɨ'ɨrɨ uzu nene, too ndje dœ ɨ'ɨrɨ anga œrœ bale nene. Kaka adœke 'e le «Œ̃» œ kœsœ adœke 'e yindœ o'onœ. Á 'e kœle «œ̃œ̃» œ sœ adœke 'e vwaratœ 'e tœ o'onœ mbœrœ adœke 'e tete dœ o'o utshu Ndjaba nene. ");
INSERT INTO mnh_vpl VALUES ("JM5_13","089_5_13","JAS","5","13","13","Œ kœsœ adœke anga uzu bale ugurutœ 'e sœ kœwu oyo, tshe kɨ ga ndœ Ndjaba. Á œ kœsœ adœke tshe kœsœ dœ yanga, tshe donga Ndjaba. ");
INSERT INTO mnh_vpl VALUES ("JM5_14","089_5_14","JAS","5","14","14","Œ kœsœ adœke anga uzu bale ugurutœ 'e sœ dœ koɓa, tshe e agbozu Ikrizia, yé endje kɨ fœ Ndjaba tœ ye manda kœta kada ga tœ ye dœ ɨ'ɨrɨ Gbozu. ");
INSERT INTO mnh_vpl VALUES ("JM5_15","089_5_15","JAS","5","15","15","Kœkɨ fœ Ndjaba dœ kœyindœrœ œ she uzu lœ koɓa. Gbozu kpa to gbɔgbɔ fœ she œ ɨvwɨ she ga lafo yé œdœ tshe kœmbœrœ ekperœ, Ndjaba œ djerœndœ nœ. ");
INSERT INTO mnh_vpl VALUES ("JM5_16","089_5_16","JAS","5","16","16","Atamœ, œ li adœke 'e pandœ ekperœ nœ 'e uzu dœ uzu fœ yanga nœ, 'e kɨ fœ Ndjaba uzu dœ uzu mbœrœ yanga nœ yekane á 'e kœshe. Gbambanœ nene, ákpálá ɨkɨ nœ uzu á tshe sœ ndjii fœ Ndjaba li kœmbœrœ egerœ akwa. ");
INSERT INTO mnh_vpl VALUES ("JM5_17","089_5_17","JAS","5","17","17","Eliya kœdœ lima uzu ɓata azœ. Tshe kɨ fœ Ndjaba dœ lɔsu ye bale adœke, yavuru nini nene, yé œ mbœrœ ngbugu votɔ dœ yapu mindu dœ amanœ bale, yavuru nini pa ɔshɔ nene. ");
INSERT INTO mnh_vpl VALUES ("JM5_18","089_5_18","JAS","5","18","18","Manda nœ, tshe kpa kɨ fœ Ndjaba, ngbewo yavuru ni, yé ele ɔyɔ ko pa ɔshɔ. ");
INSERT INTO mnh_vpl VALUES ("JM5_19","089_5_19","JAS","5","19","19","Aaya, œdœ uzu bale ugurutœ 'e kœdji awa, yé anga uzu kœgi she ga tœ awa, ");
INSERT INTO mnh_vpl VALUES ("JM5_20","089_5_20","JAS","5","20","20","'e wusœ nœ adœke uzunœ á tshe gi ayi kœmbœrœ ekperœ lœ ekpe awa, she ayanœ yé Ndjaba œ djerœndœ ukpulu ekperœ nœ ye á tshe mbœrœ asœmœ.");
INSERT INTO mnh_vpl VALUES ("P11_1","090_1_1","1PE","1","1","1","Œmœ Petro, ayi avwa nœ Yisu Kristu, mœ sœ kœsu mbetinœ asœke fœ 'e dœ azu á Ndjaba ke 'e, á 'e ndjɔtshelœtœ 'e á wuta agene ɓa lœ ogo Po, Galate, Kapadose, Azi, œdœ pe Bitini. ");
INSERT INTO mnh_vpl VALUES ("P11_2","090_1_2","1PE","1","2","2","Ndjaba Aba wu ɓa lima sœ 'e katshatsha utshunœ, yé á ke 'e adœke 'e dœ azu nœ ye. Tshe mbœrœ adœke 'e wuta ayerœ azu lœ awa nœ Ɨshirɨ nœ ye, adœke 'e dji o'o ama Yisu Kristu yekane á tshe kœdjutɔ ekperœ nœ 'e dœ indji ye. Kaka Ndjaba yisœ ɔtshɔ lɔsu œdœ kœsœ gee nœ ye fœ 'e tɔ pa nœ kpuru. ");
INSERT INTO mnh_vpl VALUES ("P11_3","090_1_3","1PE","1","3","3","A donga Ndjaba á tshe dœ́ Aba Gbozu nœ azœ dœ Yisu Kristu; gbambanœ nene, tshe sœ dœ oyo waa ga ndœ azœ. Mbœrœ tœnœ ataa, tshe za tafo soro fœ azœ lœ awa nœ Yisu Kristu á tshe shé she ugurutœ akuzu. Ndjaba mbœrœ ataa mbœrœ a kœko lɔsu azœ ga tœ soronœ á a gbɔ asœmœ, ");
INSERT INTO mnh_vpl VALUES ("P11_4","090_1_4","1PE","1","4","4","a sœ dœ ɔtshɔrœ á Ndjaba gumasœ nœ kate azœ ɓa lafo. Œtœnœ kœdœ œrœ á yiwa nene, œ za ngbandji nene yé œ gba ndje nene. ");
INSERT INTO mnh_vpl VALUES ("P11_5","090_1_5","1PE","1","5","5","Ndjaba œ gbɔndœ 'e dœ gbɔgbɔ nœ ye mbœrœ kœyindœrœ nœ 'e ga ndœ ye œrrr adœke 'e gbɔ kœshe á ndo tœ kœmatœ ye dœ lɔkɔ kœka tshapashɔ. ");
INSERT INTO mnh_vpl VALUES ("P11_6","090_1_6","1PE","1","6","6","Mbœrœ tœnœ ataa, 'e sœ dœ yanga, œdœ œ kœsœ adœke ngɔngɔ asœke 'e wu oyo tœ tshelœ aka ɔgbɔ œrœ kɔ á wuta ga tœ 'e. ");
INSERT INTO mnh_vpl VALUES ("P11_7","090_1_7","1PE","1","7","7","Œ li adœke endje yamba kœyindœrœ nœ 'e ɓata endje yamba ɔrœ dœ owo. Andaa kœyindœrœ nœ 'e ropa ɔrœ ye; gbambanœ nene, ɔrœ kœdœ œrœ á œndœnœ œ dɨ nene. Œdœ 'e kœtepa kœyindœrœ nœ 'e kperœ, adja Ndjaba œ donga 'e, œ za mokɔ dœ kœlɨsœtœ fœ 'e dœ lɔkɔ á Yisu œ kwatœ ye. ");
INSERT INTO mnh_vpl VALUES ("P11_8","090_1_8","1PE","1","8","8","Œshe á 'e wuwu she dœ ala 'e nene kashe 'e yindœ ye, 'e wuwu she nene kashe 'e sœ dœ kœyindœrœ ga ndœ ye. Mbœrœ tœnœ ataa, 'e sœ dœ egerœ yanga nœ mokɔ, á uzu œ li kœpandœ maranœ kɔ nene. ");
INSERT INTO mnh_vpl VALUES ("P11_9","090_1_9","1PE","1","9","9","Gbambanœ nene, Ndjaba œ za kœshe fœ 'e ɓata œrœ tshamanda kœyindœrœ nœ 'e. ");
INSERT INTO mnh_vpl VALUES ("P11_10","090_1_10","1PE","1","10","10","Aayi kœgbara o'o nœ Ndjaba pa lima o'o tœ upu nœ kœshenœ yé endje gbara o'o tœ upu nœ ɔtshɔ lɔsu nœ Ndjaba ga ndœ 'e asœmœ. ");
INSERT INTO mnh_vpl VALUES ("P11_11","090_1_11","1PE","1","11","11","Gbambanœ nene, Ɨshirɨ nœ Kristu sœ lima pa endje yé œ gbara lima o'o fœ endje tœ upu nœ œrœ kanga á Kristu œ wu, œdœ ndje mokɔ á tshe gbɔ manda nœ. Aayi kœgbara o'onœ para lima awa kɔ adœke œne wusœ lɔkɔnœ œdœ pe mara á œrœnœ asœmœ œ mbœrœtœ endje. ");
INSERT INTO mnh_vpl VALUES ("P11_12","090_1_12","1PE","1","12","12","Yé Ndjaba yi lima sœ nœ fœ aayi kœgbara o'o adœke, endje gbara lima o'onœ asœmœ tœ upu nœ endje dœ tœ endje nene kashe tœ upu nœ 'e dá aayi kœgbara o'onœ gbara lima o'o á ngɔngɔ asœ aayi kœyisœ Ɔtshɔ O'o nœ Yisu Kristu na dœ tœnœ fœ 'e. Endje yi lima sœ nœ lœ awa nœ Ɔtshɔ Ɨshirɨ á Ndjaba vwa lima she kœto ɓa lafo, yé ngɔngɔ asœke aandjelu sœ ndje dœ yanga mbœrœ kœwusœ nœ. ");
INSERT INTO mnh_vpl VALUES ("P11_13","090_1_13","1PE","1","13","13","Mbœrœ tœnœ ataa, 'e guma gbetshelœ nœ 'e mbœrœ kœmbœrœ akwa fœ Ndjaba. 'E dœ agbozu tshapa undu 'e dœ tœ 'e yé 'e ko lɔsu 'e kɔ ga pa ɔtshɔrœ á 'e gbɔ dœ lɔkɔ á Yisu Kristu œ kwatœ ye. ");
INSERT INTO mnh_vpl VALUES ("P11_14","090_1_14","1PE","1","14","14","Ɓata e'e kœdœ agbolo kœdji o'o ama Aba 'e, 'e zaza lɔsu 'e ga pa œrœ nœ́ anga 'e nene ɓata á sœ lima utshunœ adœke 'e wusœ œrœ. ");
INSERT INTO mnh_vpl VALUES ("P11_15","090_1_15","1PE","1","15","15","Kashe ɓata tsheneke á tshe e 'e, œshe kœdœ Œyerœ Ndjaba, œ li adœke e'e, 'e sœ ndje yerœ lœ mara kœmbœrœtœ nœ 'e kɔ. ");
INSERT INTO mnh_vpl VALUES ("P11_16","090_1_16","1PE","1","16","16","Mbœrœ tœnœ dá endje sú ala Buku nœ Ndjaba adœke: «'E sœ yerœ gbambanœ nene, mœ sœ yerœ.» ");
INSERT INTO mnh_vpl VALUES ("P11_17","090_1_17","1PE","1","17","17","Yé œdœ 'e kœsœ kœ'e Ndjaba adœke Aba lɔkɔ á 'e kœsœ kœza avwala nœ 'e fœ she, œ li adœke 'e kpa awa ye lœ olo kœsœ nœ 'e pa ɔshɔ mbœrœ tshe wuwu tshatshu uzu nene, kashe tshe wa o'o nœ uzu dœ uzu kœli dœ akwa nœ ye. ");
INSERT INTO mnh_vpl VALUES ("P11_18","090_1_18","1PE","1","18","18","'E wusœ nœ adœke mara kœmbœrœtœ 'e utshunœ á 'e gbɔ lima manda aata 'e gaga nene. Ndjaba she 'e lœ nœ kɔ, tshe sheshe 'e dœ œrœ á ndɨ ɓata ngendja too ɔrœ nene. ");
INSERT INTO mnh_vpl VALUES ("P11_19","090_1_19","1PE","1","19","19","Kashe tshe she 'e dœ indji Kristu á amanœ gbɔ waa. Tshe sœ ɓata aya pata á anga œrœ kote ye ndɨndɨ bale nene, á œndœ uburu teasho gugu tœ ye nene. ");
INSERT INTO mnh_vpl VALUES ("P11_20","090_1_20","1PE","1","20","20","Ndjaba ke lima she utshunœ adœke tshe mbœrœ tshapashɔ, yeka á mbœrœ adœke tshe na dœ ndɔngɔlɔ oshonœ asœke tœ upu nœ 'e. ");
INSERT INTO mnh_vpl VALUES ("P11_21","090_1_21","1PE","1","21","21","Lœ awa nœ ye, 'e sœ dœ kœyindœrœ ga ndœ Ndjaba á tshe shé she lœ kuzu, yé á za mokɔ fœ she dœ mara adœke kœyindœrœ nœ 'e œdœ pe lɔsu 'e sœ ga pa Ndjaba. ");
INSERT INTO mnh_vpl VALUES ("P11_22","090_1_22","1PE","1","22","22","'E wuta yerœ mbœrœ á 'e tetœ kœza adja o'o ga tœ akwa. Œtœnœ dá sœ kœvwa 'e adœke 'e sœ dœ adja kœyindœsho, ataa 'e kakatœ nœ nene, 'e yindœtœ 'e ugurutœ 'e dœ lɔsu 'e djigi. ");
INSERT INTO mnh_vpl VALUES ("P11_23","090_1_23","1PE","1","23","23","Gbambanœ nene, Ndjaba zu 'e tœ bishanœ lœ awa nœ o'o ama ye á dœ́ soro, á sœpe ungu dœ ungu. Kashe œ sœsœ lœ awa nœ uzu á tshe tshu nene. ");
INSERT INTO mnh_vpl VALUES ("P11_24","090_1_24","1PE","1","24","24","Endje sú ala Buku nœ Ndjaba adœke: «Azu para kɔkɔ sœ ɓata a'eara ɔyɔ, mokɔ nœ endje sœ ɓata ndɔkɔ a'eara ɔyɔ: a'eara ɔyɔ œ ɔrɔ yé ndɔkɔnœ œ yo. ");
INSERT INTO mnh_vpl VALUES ("P11_25","090_1_25","1PE","1","25","25","Kashe o'o ama Gbozu Ndjaba œ sœpe waa dœ waa.» Andaa o'onœ asœmœ, œtœnœ kœdœ Ɔtshɔ O'onœ á endje yisœ nœ fœ 'e. ");
INSERT INTO mnh_vpl VALUES ("P12_1","090_2_1","1PE","2","1","1","Mbœrœ tœ nœ ataa, 'e katœ ekperœ kɔ, dœ kœfara osho kɔ œdœ úkú, dœ mara wulapatshɔ kɔ, dœ egerœ ogo kœgbɔ œrœ, dœ ndje kœpa ekpe o'o ga tœ uzu kɔ tɨ ye. ");
INSERT INTO mnh_vpl VALUES ("P12_2","090_2_2","1PE","2","2","2","Kashe 'e sœ ɓata awaya. Endje sœ kolœ dœ ogo kœa ɔngɔ ayi endje, ɔngɔnœ á li adœke 'e para kœdœ adja o'o yekane á 'e kœgerœ á kœgbɔ kœshe. ");
INSERT INTO mnh_vpl VALUES ("P12_3","090_2_3","1PE","2","3","3","Gbambanœ nene, œ sœ ɓata á endje sú ala Buku nœ Ndjaba adœke: «'E wusœ nœ dœ tœ 'e adœke adja Gbozu sœ dœ ɔtshɔnœ.» ");
INSERT INTO mnh_vpl VALUES ("P12_4","090_2_4","1PE","2","4","4","'E na ga ndœ ye, œshe kœdœ badja soronœ á azu za lima vwi'i kashe Ndjaba ke lima, yé œ wu adœke amanœ gbɔ waa. ");
INSERT INTO mnh_vpl VALUES ("P12_5","090_2_5","1PE","2","5","5","E'e ndje atamœ, 'e wuta ɓata badja soro á Ndjaba sœ kœmbœrœ tœnœ dœ anda á Ɨshirɨ nœ ye sœ lœ nœ. Tshe fa 'e tœ ayerœ anganga Ndjaba, mbœrœ á 'e kœko tokóró nœ Ɨshirɨ neke á za yanga fœ she lœ awa nœ Yisu Kristu. ");
INSERT INTO mnh_vpl VALUES ("P12_6","090_2_6","1PE","2","6","6","Gbambanœ nene, endje sú ala Buku nœ Ndjaba adœke: «'E wu, mœ ke anga badja á anda œ shi mbœrœ tœnœ, á amanœ gbɔ waa á za tɔ ɓa lakpɨ Siyona mbœrœ kœmɔ anda nœ mœ ga pa nœ. Uzu kɔ á tshe za lɔsu ye ga pa nœ, tshe gbɔ tshula bale nene.» ");
INSERT INTO mnh_vpl VALUES ("P12_7","090_2_7","1PE","2","7","7","Mbœrœ 'e á 'e yindœ ye asœmœ, tshe sœ ɓata badja á amanœ gbɔ waa; kashe mbœrœ azu á endje yiyindœ ye nene, ádá badjanœ asœmœ gugu nene. Endje su ala Buku nœ Ndjaba adœke: «Badjanœ á aayi kœmɔ anda vwaratœ endje tœnœ wuta badja á anda œ shi mbœrœ tœnœ.» ");
INSERT INTO mnh_vpl VALUES ("P12_8","090_2_8","1PE","2","8","8","Endje kpa su ndje adœke: «Badjanœ asœmœ, azu œ ko ada endje tɔ tœnœ, yé œ ko endje vesho.» Endje sœ kœko ada endje tɔ tœnœ mbœrœ á endje sœsœ kœyindœ kœdji o'o ama Ndjaba nene. Ataa œrœ á yi lima ndœ kœmbœrœtœ ye fœ endje asœmœ, dá na asœmœ. ");
INSERT INTO mnh_vpl VALUES ("P12_9","090_2_9","1PE","2","9","9","Kashe e'e, 'e kœdœ azu tshelœ mara á Ndjaba ke. E'e kœdœ anganga nœ Gbozu. E'e kœdœ ayerœ azu nœ Ndjaba, á tshe ke 'e adœke 'e gbara ɔtshɔrœ á tshe mbœrœ fœ azu. Œshe dá gbota 'e lœ ubu osho mbœrœ kœko 'e ga lœ mokɔ nœ ye á ropa nœ ye. ");
INSERT INTO mnh_vpl VALUES ("P12_10","090_2_10","1PE","2","10","10","Utshunœ, 'e dœ́dœ́ lima azu nœ Ndjaba nene; kashe ngɔngɔnœ asœ, 'e wuta azu nœ ye. Utshunœ, Ndjaba wuwu lima oyo 'e nene; kashe ngɔngɔ asœ, tshe wu oyo 'e ye. ");
INSERT INTO mnh_vpl VALUES ("P12_11","090_2_11","1PE","2","11","11","Aaya mœ á mœ yindœ 'e waa, 'e sœ ɓata azu á endje sœ kœroro tœnœ, azu á endje dœ agene pa ɔshɔ. Atamœ, mœ sœ kœmɨ upu fœ 'e adœke: 'e vwaratœ 'e tœ ekpe gbetshelœ nœ ɔkɔ á sœ kœnga koshe dœ ɨshirɨ 'e. ");
INSERT INTO mnh_vpl VALUES ("P12_12","090_2_12","1PE","2","12","12","'E mbœrœtœ 'e dœ ɔtshɔnœ ugurutœ ayingba Yisu. Ataa œdœ endje kœpa adœke e'e kœdœ azu kœmbœrœ ngbɨndɨrœ gbaa, endje wu ɔtshɔ akwa nœ 'e á 'e mbœrœ yé endje donga Ndjaba lɔkɔ á tshe kœkwatœ ye. ");
INSERT INTO mnh_vpl VALUES ("P12_13","090_2_13","1PE","2","13","13","'E lɨsœ agbozu tshapa ɔshɔnœ asœke mbœrœ 'e kœdœ azu nœ Gbozu Yisu, œdœ ndje gbozugo á tshe sœ pa azu para kɔkɔ asœmœ, ");
INSERT INTO mnh_vpl VALUES ("P12_14","090_2_14","1PE","2","14","14","ndje dœ pe agbozu á tshe vwa endje ndœ kœza djofele fœ aayi kœmbœrœ ngbɨndɨrœ ndje dœ kœdonga aayi kœmbœrœ ɔtshɔrœ asœmœ. ");
INSERT INTO mnh_vpl VALUES ("P12_15","090_2_15","1PE","2","15","15","Gbambanœ nene, Ndjaba yindœ nœ adœke 'e mbœrœ ɔtshɔrœ yeka azu á endje ndɨ lœ ekperœ á wuwusœ œrœ nene, kœsœsœ dœ o'o ndœ kœpa tœ upu nœ 'e nene. ");
INSERT INTO mnh_vpl VALUES ("P12_16","090_2_16","1PE","2","16","16","'E mbœrœtœ 'e ɓata azu á endje kpa dœ́dœ́ akanga nene. Kashe adja œneke kpa zaza awa fœ 'e kœmbœrœ ekperœ nene, kashe 'e mbœrœtœ 'e ɓata akanga nœ Ndjaba. ");
INSERT INTO mnh_vpl VALUES ("P12_17","090_2_17","1PE","2","17","17","'E lɨsœ azu para kɔkɔ yé œ yindœ aaya 'e. 'E kpa awa Ndjaba, yé œ lɨsœ gbozugo nœ 'e. ");
INSERT INTO mnh_vpl VALUES ("P12_18","090_2_18","1PE","2","18","18","'E dœ aayi akwa, 'e lɨsœ ayengɔ 'e. 'E lɨlɨ kolœ œsœ́ endjeneke á endje sœ dœ ɔtshɔnœ ndje dœ endjeneke á endje sœ dœ ɔtshɔ lɔsu nene, kashe 'e lɨ ndje sœ endjeneke á endje sœ dœ ɔgbɔ lɔsu. ");
INSERT INTO mnh_vpl VALUES ("P12_19","090_2_19","1PE","2","19","19","Gbambanœ nene, œdœ uzu kœru lɔsu ye lœ œrœ kanga á lili má adœke tshe wu nene mbœrœ kœkpa awa Ndjaba, œ ga waa. ");
INSERT INTO mnh_vpl VALUES ("P12_20","090_2_20","1PE","2","20","20","Ataa, ɔtshɔrœ gaɗe dá uzu œ gbɔ œ kœsœ adœke tshe wu oyo mbœrœ kœmbœrœ ekperœ a? Kashe œ kœsœ adœke tshe wu oyo mbœrœ á tshe mbœrœ ɔtshɔrœ, œ sœ dœ ɔtshɔnœ tœ ala Ndjaba. ");
INSERT INTO mnh_vpl VALUES ("P12_21","090_2_21","1PE","2","21","21","Asœmœ kœdœ œrœ á Ndjaba e 'e mbœrœ tœnœ, gbambanœ nene Kristu dœ tœ ye wu lima oyo mbœrœ 'e. Tshe yisœ awa fœ 'e adœke, 'e wu mara á tshe mbœrœ lima asœmœ yé œ mbœrœtœ 'e ndje liaka nœ. ");
INSERT INTO mnh_vpl VALUES ("P12_22","090_2_22","1PE","2","22","22","Tshe mbœmbœrœ lima ekperœ nene yé wala hiaru wuwuta lima lœ ama ye nene. ");
INSERT INTO mnh_vpl VALUES ("P12_23","090_2_23","1PE","2","23","23","Azu gu she, kashe tshe gigi fœ endje nene. Endje mbœrœ ɔgbɔ œrœ ga tœ ye, yé tshe susuku dœ uzu nene kashe tshe za lima tœ ye fœ Ndjaba á tshe wa o'o dœ adjapu. ");
INSERT INTO mnh_vpl VALUES ("P12_24","090_2_24","1PE","2","24","24","Lɔkɔ á endje wo lima she pa kurushi, tshe za lima agba ekperœ nœ azœ ga pa ye. Tshe mbœrœ lima ataa yeka á a kœwuta azu á endje tshu tœ œneke á dœ́ ekperœ yé á sœ dœ soro ndœ kœmbœrœ œrœ á sœ ndjii. Œshe, á ukunœ á tshe gbɔ asœmœ, œ she 'e. ");
INSERT INTO mnh_vpl VALUES ("P12_25","090_2_25","1PE","2","25","25","Gbambanœ nene, 'e sœ lima ɓata apata á endje djingili awa; kashe ngɔngɔnœ asœke, 'e fatœ 'e ga ndœ ayi kœgbɔndœ apata, á tshe kœdœ ayi kœgbɔndœ ɨshirɨ 'e. ");
INSERT INTO mnh_vpl VALUES ("P13_1","090_3_1","1PE","3","1","1","E'e dœ ayashe ndje, 'e lɨsœ aakɔ 'e mbœrœ œ kœsœ adœke anga endje vwaratœ endje tœ kœdji o'o ama Ndjaba, yé œdœ 'e kœyiyi ndje sœ o'o ama Ndjaba fœ endje nene gbaa, endje fatshalɔsu endje mbœrœ kœmbœrœtœ nœ 'e dœ awo endje, ");
INSERT INTO mnh_vpl VALUES ("P13_2","090_3_2","1PE","3","2","2","kœwu kolœ okporo mara kœmbœrœtœ nœ 'e œdœ ndje pe mara á 'e sœ kœlɨsœ endje. ");
INSERT INTO mnh_vpl VALUES ("P13_3","090_3_3","1PE","3","3","3","Adja kœga nœ 'e mama kolœ tœ ye ɓa ushu nene: ɓata mara kœguma dœ sukumu 'e, dœ kœverœ œrœ á endje mbœrœ dœ ɔrœ ga tœ 'e, ndje dœ kœverœ lœba á ga waa. ");
INSERT INTO mnh_vpl VALUES ("P13_4","090_3_4","1PE","3","4","4","Kashe œ li adœke, a sœ dœ kœga á zatœ ye yiwa tœnœ ɓa tœ lɔsu azœ. Asœmœ kœdœ kœga neke á ndɨ nene: kœsœ dœ lɔsu zɨtɨ œdœ kœsœ gee, œtœnœ dá amanœ gbɔ waa tœ ala Ndjaba. ");
INSERT INTO mnh_vpl VALUES ("P13_5","090_3_5","1PE","3","5","5","Atamœ dá ayerœ ayashe liya utshunœ á endje ko lima lɔsu endje ga tœ Ndjaba, á sœ lima kœlɨsœ aakɔ endje, endje guma lima tœ endje dœ maranœ asœke. ");
INSERT INTO mnh_vpl VALUES ("P13_6","090_3_6","1PE","3","6","6","Ɓata Sara á tshe dji lima o'o akɔnœ dœ Abrayamo, yé á e lima she gbozu nœ ye. 'E wuta ayawuru nœ ye œ kœsœ adœke 'e sœ kœmbœrœ ɔtshɔrœ yé œdœ 'e kœkakatœ 'e tɨ adœke anga œrœ bale za awa tœ 'e nene. ");
INSERT INTO mnh_vpl VALUES ("P13_7","090_3_7","1PE","3","7","7","'E dœ ayakoshe ndje, lœ kœsœ nœ 'e dœ awo 'e, 'e wusœ nœ adœke endje kœdœ amɔ azu kœropa 'e. 'E lɨsœ endje, mbœrœ endje ndje, endje gbɔ soronœ á Ndjaba œ za fœ azu awa bale dœ 'e. 'E mbœrœ ataa yeka anga œrœ bale kœkukundœ avwala nœ 'e ga ndœ Ndjaba nene. ");
INSERT INTO mnh_vpl VALUES ("P13_8","090_3_8","1PE","3","8","8","Ndangba o'o nœ mœ fœ 'e kœdœ adœke, e'e para kɔkɔ 'e sœ dœ gbetshelœ bale, 'e sœ dœ lɔsu kœtɨ kane anga 'e, 'e yindœtœ 'e ɓata aaya azu, 'e wu oyo anga 'e yé œ kotœ 'e ga atɨ. ");
INSERT INTO mnh_vpl VALUES ("P13_9","090_3_9","1PE","3","9","9","Adja 'e gigi ekperœ manda ekperœ nene, 'e gugu ndje azu neke á endje gu 'e nene. Kashe 'e to kane 'e ga pa endje gbambanœ nene, mbœrœ tœnœ dá Ndjaba e 'e adœke œne to kane œne ga pa 'e. ");
INSERT INTO mnh_vpl VALUES ("P13_10","090_3_10","1PE","3","10","10","Œ sœ ɓata œneke á endje sú ala Buku nœ Ndjaba adœke: «Uzu á tshe kœyindœ kœsœ dœ ɔtshɔ soro, yé œ sœ dœ yanga pa ɔshɔnœ asœke, œ li adœke adja tshe gbɔndœ tima ye tœ ekpe o'o, yé œ gbɔndœ ama ye tœ kœpa wala. ");
INSERT INTO mnh_vpl VALUES ("P13_11","090_3_11","1PE","3","11","11","Œ li adœke tshe katœ kœmbœrœ ekperœ, yé œ mbœrœ kolœ ɔtshɔrœ. Tshe mbœrœ dœ mara kɔ adœke, œne sœ dœ kœsœ gee dœ azu yé œ shi gbɨ. ");
INSERT INTO mnh_vpl VALUES ("P13_12","090_3_12","1PE","3","12","12","Gbambanœ nene, ala Ndjaba sœ pa azu á endje sœ ndjii, yé utu ye sœ ndœ kœdji avwala nœ endje, kashe tshe fa tshaangba ye fœ aayi kœmbœrœ ekperœ.» ");
INSERT INTO mnh_vpl VALUES ("P13_13","090_3_13","1PE","3","13","13","Œɗe dá mbœrœ ekperœ fœ 'e œdœ 'e kœzatœ 'e djigi ndœ kœmbœrœ ɔtshɔrœ a? ");
INSERT INTO mnh_vpl VALUES ("P13_14","090_3_14","1PE","3","14","14","Œdœ azu kœsœ kœmbœrœ œrœ kanga fœ 'e mbœrœ á 'e sœ kœmbœrœ œrœ á sœ ndjii, 'e sœ dœ yanga. 'E kpakpa awa endje bale nene yé 'e koko lɔsu 'e ga lafo nene. ");
INSERT INTO mnh_vpl VALUES ("P13_15","090_3_15","1PE","3","15","15","Kashe 'e tepa Kristu ga tœ lɔsu 'e ɓata œyerœ Gbozu nœ 'e. 'E gumatœ 'e ɔlɔ dœ ɔlɔ mbœrœ kœpa ádá á 'e za lɔsu 'e ga pa Kristu fœ azu á endje yu 'e tœnœ. ");
INSERT INTO mnh_vpl VALUES ("P13_16","090_3_16","1PE","3","16","16","Kashe 'e gi o'o fœ endje dœ ɔmɔ lɔsu, dœ kœlɨsœ endje œdœ pe ɔtshɔ gbetshelœ yekane azu á endje sœ kœpa adœke e'e kœdœ ekpe azu, á sœ kœpatœ ɔtshɔ 'e kœgbɔ tshula. ");
INSERT INTO mnh_vpl VALUES ("P13_17","090_3_17","1PE","3","17","17","Kashe œ sœ dœ ɔtshɔnœ adœke 'e wu œrœ kanga tœ upu nœ ɔtshɔrœ á 'e sœ kœmbœrœ tœnœ œdœ Ndjaba kœyindœ nœ. Œneke asœ da ga kœropa kœwu œrœ kanga manda kœmbœrœ ekperœ. ");
INSERT INTO mnh_vpl VALUES ("P13_18","090_3_18","1PE","3","18","18","Gbambanœ nene, Kristu dœ tœ ye tshu lima awa bale ngbewo lœ kumu ekperœ nœ azu, œshe á tshe sœ ndjii tshe tshu mbœrœ azu á endje sœsœ ndjii nene, mbœrœ kœko 'e na tœnœ ga ndœ Ndjaba. Endje wo kolœ undu ye kashe tshe she lœ kuzu dœ gbɔgbɔ nœ Ɔtshɔ Ɨshirɨ. ");
INSERT INTO mnh_vpl VALUES ("P13_19","090_3_19","1PE","3","19","19","Yé dœ gbɔgbɔ nœ Ɨshirɨnœ asœmœ, tshe na ndœ kœyisœ œrœ fœ aɨshirɨ endjeneke á endje lœ lœ kánga ɓa lœ ogo nœ akuzu. ");
INSERT INTO mnh_vpl VALUES ("P13_20","090_3_20","1PE","3","20","20","Endje vwara lima tœ endje tœ kœdji o'o ama Ndjaba kashe Ndjaba kate lima endje dœ ugu lɔsu dœ lɔkɔ á Nowa sœ lima kœmbœrœ egerœ agba á kolœ azu teasho, mindu dœ votɔ li lima ga lœ nœ yekane á she lima la ngunœ. ");
INSERT INTO mnh_vpl VALUES ("P13_21","090_3_21","1PE","3","21","21","Ungunœ asœmœ má batisimu á she 'e lœ ekperœ nœ 'e ngɔngɔ asœ: ungunœ œ djutɔ uburu tœ undu uzu nene, kashe œ she uzu œdœ tshe kœzatœ ye fœ Ndjaba dœ ɔtshɔ gbetshelœ. Batisimunœ she 'e mbœrœ á Yisu Kristu she lœ kuzu ye. ");
INSERT INTO mnh_vpl VALUES ("P13_22","090_3_22","1PE","3","22","22","Tshe gu ga lafo yé œ sœ ga atɨ ga pa kuni Ndjaba. Tshe kœdœ Gbozu tshapa aandjelu, ga pa tshagbozu kɔ œdœ ga pa gbɔgbɔ kɔ ɓa lafo. ");
INSERT INTO mnh_vpl VALUES ("P14_1","090_4_1","1PE","4","1","1","Ataa, ɓata á Kristu wu oyo lœ ɔkɔ ye, œ li adœke 'e sœ dœ gbetshelœ nœ kœru lɔsu lœ ɔgbɔ œrœ ɓata œnœ ye. Gbambanœ nene, uzu kɔ á tshe sœ kœwu oyo lœ ɔkɔ ye, katœ kœmbœrœ ekperœ ngbewo. ");
INSERT INTO mnh_vpl VALUES ("P14_2","090_4_2","1PE","4","2","2","Mbœrœ tœnœ ataa, 'e kpa nana manda ogo nœ ɔkɔ nene kashe 'e mbœrœ œrœ á Ndjaba yindœ nœ lœ udu soro 'e pa ɔshɔnœ asœke. ");
INSERT INTO mnh_vpl VALUES ("P14_3","090_4_3","1PE","4","3","3","Lima utshunœ, 'e mbœrœ lima œrœ á azu á endje wuwusœ Ndjaba nene sœ lima dœ yanga kœmbœrœ tœnœ. 'E sœ lima kœmbœrœ angba budu, kœza lɔsu 'e ga pa œrœ nœ́ anga 'e, kœndjo œrœ œrrr adœke œ mbœrœ 'e, kœzɨ œrœ dœ pe kœndjo œrœ dœ wuma tɔpanœ kpuru, kœdonga lima andjaba á dœ́ ekperœ á gaga nene. ");
INSERT INTO mnh_vpl VALUES ("P14_4","090_4_4","1PE","4","4","4","Kashe ngɔngɔ asœ, azu á endje wuwusœ Ndjaba nene za ama endje tɨ asɔ tœ kœwu 'e yé œ tetœ kœgu 'e mbœrœ á 'e kpa sœsœ kœngbɔtœ 'e dœ endje lœ kœmbœrœ kœngba œrœ tshulanœ alœmœ nene. ");
INSERT INTO mnh_vpl VALUES ("P14_5","090_4_5","1PE","4","5","5","Andaa ɔlɔ bale, endje pa o'o tœ mara kœmbœrœtœ endje fœ Ndjaba á tshe gumatœ ye ndœ kœwa ngbanga pa azu á endje sœ dœ soro ndje dœ azu á endje tshu. ");
INSERT INTO mnh_vpl VALUES ("P14_6","090_4_6","1PE","4","6","6","Mbœrœ tœnœ ataa, tshe yi ndje lima sœ Ɔtshɔ O'o fœ akuzu adœke manda kœwa ngbanga pa endje ɓata azu, endje sœ dœ soro ɓata Ndjaba lœ awa nœ Ɨshirɨ. ");
INSERT INTO mnh_vpl VALUES ("P14_7","090_4_7","1PE","4","7","7","Œrœ kɔ ndo kœwuta ga tœ ndɔngɔlɔnœ ye. 'E ma kœwusœtœ yé œ dœ agbozu tshapa undu 'e adœke 'e kœli tœ kœza avwala nœ 'e fœ Ndjaba. ");
INSERT INTO mnh_vpl VALUES ("P14_8","090_4_8","1PE","4","8","8","Utshunœ kɔ, œ li adœke 'e yindœtœ 'e ugurutœ 'e dœ lɔsu 'e bale. Gbambanœ nene, kœyindœshonœ asœ œ za awa fœ 'e adœke 'e djerœndœ ekperœ ndjoro. ");
INSERT INTO mnh_vpl VALUES ("P14_9","090_4_9","1PE","4","9","9","Œ li adœke 'e za osho kœsœ fœ anga 'e kashe 'e mbœmbœrœ dœ kœpulœma 'e nene. ");
INSERT INTO mnh_vpl VALUES ("P14_10","090_4_10","1PE","4","10","10","Ɓata á Ndjaba ko 'e tœ aayi kœgbɔndœ œrœ nœ ye, yé á to gbɔgbɔ liakanœ fœ 'e asœmœ, œ li adœke uzu dœ uzu za gbɔgbɔnœ ga tœ akwa mbœrœ kœtɨ kane anganœ. ");
INSERT INTO mnh_vpl VALUES ("P14_11","090_4_11","1PE","4","11","11","Œdœ anga uzu ugurutœ 'e kœsœ kœpa o'o, œ li adœke tshe pa o'o á to ɓa ndœ Ndjaba. Yé uzu nœ kœmbœrœ akwa fœ azu, tshe mbœrœ dœ gbɔgbɔ á Ndjaba za fœ she. 'E mbœrœ adœke mara kœmbœrœtœ 'e lœ œrœ kɔ donga Ndjaba lœ awa nœ Yisu Kristu, á tshe sœ dœ mokɔ, dœ gbɔgbɔ neke á sœ waa dœ waa. Ame! ");
INSERT INTO mnh_vpl VALUES ("P14_12","090_4_12","1PE","4","12","12","Aaya mœ á mœ yindœ 'e waa, 'e zaza ama 'e tɨ asɔ mbœrœ ɔgbɔrœ á na ga ndœ 'e nene. 'E wuwu ndje ɓata anga œrœ kpi nene. ");
INSERT INTO mnh_vpl VALUES ("P14_13","090_4_13","1PE","4","13","13","Kashe œ kœsœ adœke 'e wu oyo ɓata á Kristu wu lima, 'e sœ dœ yanga adœke lɔkɔ á mokɔ nœ ye œ matœ endje, e'e ndje, 'e sœ dœ yanga kœropa nœ kpuru. ");
INSERT INTO mnh_vpl VALUES ("P14_14","090_4_14","1PE","4","14","14","Œdœ endje kœpa ekpe o'o ga tœ 'e mbœrœ á 'e kœdœ azu nœ Kristu, 'e kœdœ azu nœ yanga. Gbambanœ nene, Ɨshirɨ nœ Ndjaba á sœ dœ mokɔ asœmœ sœ pa 'e. ");
INSERT INTO mnh_vpl VALUES ("P14_15","090_4_15","1PE","4","15","15","Adja anga uzu bale ugurutœ 'e wuwu oyo mbœrœ á tshe kœdœ ayi kœwo azu, too ayi angba, too ayi kœmbœrœ ngbɨndɨrœ, too ayi kœli ga lœ o'o nœ azu nene. ");
INSERT INTO mnh_vpl VALUES ("P14_16","090_4_16","1PE","4","16","16","Kashe œdœ tshe kœwu oyo mbœrœ á tshe dœ uzu nœ Kristu, adja tshe sœsœ dœ tshula tœnœ nene, tshe donga Ndjaba mbœrœ ɨ'ɨrɨnœ á endje za ga pa ye. ");
INSERT INTO mnh_vpl VALUES ("P14_17","090_4_17","1PE","4","17","17","Ɔlɔ kœwa ngbanga nœ Ndjaba tɔ, yé tshe tetœ kœwa tœnœ utshunœ pa azu nœ ye. Œ kœsœ adœke tshe tetœ kœwa ngbanganœ pa azœ, ataa azu á endje vwaratœ endje tœ kœyindœ Ɔtshɔ O'o, endje ka kpœta a? ");
INSERT INTO mnh_vpl VALUES ("P14_18","090_4_18","1PE","4","18","18","Œ sœ ɓata á endje sú ala Buku nœ Ndjaba adœke: «Œ kœsœ adœke uzu á tshe sœ ndjii œ wu oyo utshunœ yekane á Ndjaba œ she she, ataa œrœ gaɗe dá wuta ga tœ uzu á tshe vwaratœ ye tœ Ndjaba œdœ uzu kœmbœrœ ekperœ a?» ");
INSERT INTO mnh_vpl VALUES ("P14_19","090_4_19","1PE","4","19","19","Mbœrœ tœnœ ataa, azu á endje sœ kœwu oyo mbœrœ endje sœ kœmbœrœ œrœ á Ndjaba yindœ nœ, œ li adœke endje sœpe kœmbœrœ ɔtshɔrœ yé œ za lɔsu endje djigi ga tœ Ndjaba á tshe mbœrœ œrœ kɔ, á tshe yayapa o'o ama ye nene. ");
INSERT INTO mnh_vpl VALUES ("P15_1","090_5_1","1PE","5","1","1","Mœ sœ kœmɨ upu fœ agbozu Ikrizia ugurutœ 'e. Œmœ kœdœ ndje gbozu Ikrizia ɓata 'e, mœ wu œrœ kanga á Kristu wu dœ ala mœ yé mœ gbɔ ndje bala mokɔnœ á ndo tœ kœmatœ ye asœmœ. ");
INSERT INTO mnh_vpl VALUES ("P15_2","090_5_2","1PE","5","2","2","'E gbɔndœ azu nœ Ndjaba á tshe ko endje fœ 'e ɓata aayi kœgbɔndœ apata œ mbœrœ. 'E mbœmbœrœ akwanœ ɓata endje vwa 'e ndœ kœmbœrœ tœnœ dœ ɔgbɔ nene, kashe 'e mbœrœ dœ lɔsu 'e bale ɓata á Ndjaba yindœ nœ. Adja 'e gbɔgbɔndœ endje dœ gbetshelœ nœ kœgbɔ œrœ ndjoro lœ kumu endje nene, kashe 'e zatœ 'e kɔ ndœ kœmbœrœ tœnœ. ");
INSERT INTO mnh_vpl VALUES ("P15_3","090_5_3","1PE","5","3","3","Adja 'e zazatœ 'e ga pa endjeneke á Ndjaba ko endje fœ 'e asœmœ ɓata agbozu nene, kashe 'e dœ azu kœyisœ mara ɔtshɔ neke á sœ tœ ɔtshɔnœ fœ endje. ");
INSERT INTO mnh_vpl VALUES ("P15_4","090_5_4","1PE","5","4","4","Yeka lɔkɔ á egerœ Ayi kœgbɔndœ apatanœ kœkwa bala tœ ye, á tshe kœko œrœ tshangbanœ á dœ kpoto mokɔ, á ndɨ nene fœ 'e. ");
INSERT INTO mnh_vpl VALUES ("P15_5","090_5_5","1PE","5","5","5","Awa bale, 'e dœ amodo, 'e lɨsœ agbozu Ikrizia. 'E dœ azu para kɔkɔ, 'e zatœ 'e ga atɨ lœ kœsœ 'e dœ anga 'e; gbambanœ nene, endje sú ala Buku nœ Ndjaba adœke: «Ndjaba vwaratœ ye tœ azu egerœ kumu, kashe tshe ma ɔtshɔ lɔsu ga ndœ azu kœzatœ endje ga atɨ.» ");
INSERT INTO mnh_vpl VALUES ("P15_6","090_5_6","1PE","5","6","6","'E zatœ 'e ga atɨ ga tshagudɨ kane gbɔgbɔ nœ Ndjaba, adœke tshe ko 'e ga lafo dœ lɔkɔ á tshe guma. ");
INSERT INTO mnh_vpl VALUES ("P15_7","090_5_7","1PE","5","7","7","'E katœ gbetshelœnœ á za oyo fœ 'e kɔ fœ Ndjaba; gbambanœ nene, tshe to œrœ á 'e gbe dœ tœnœ fœ 'e. ");
INSERT INTO mnh_vpl VALUES ("P15_8","090_5_8","1PE","5","8","8","'E dœ agbozu tshapa undu 'e, yé ala 'e gbɔ kane! Gbambanœ nene, Satana á tshe kœdœ yingba 'e sœ kœfa djezœ tœ osho kɔ ɓata bamara kœpara uzu ndœ kœsuru tshelœ ye. ");
INSERT INTO mnh_vpl VALUES ("P15_9","090_5_9","1PE","5","9","9","'E vwaratœ 'e tœ ye yé œ ka ngbɨrɨ lœ kœyindœrœ nœ 'e. 'E wusœ nœ adœke, oyonœ á 'e wu asœke, anga anga 'e dœ aayi kœyindœrœnœ lœ ndje kœwu tœnœ pa tshapashɔ asœ djigi. ");
INSERT INTO mnh_vpl VALUES ("P15_10","090_5_10","1PE","5","10","10","Ngɔngɔ asœ 'e sœ kœwu oyo yé œndœnœ œ dɨ nene, kashe Ndjaba á tshe sœ dœ ɔtshɔ lɔsu kɔ, á tshe e 'e kœngbɔtœ 'e bale dœ Kristu lœ mokɔ á ka nene, tshe kpa guma 'e dœ tœ ye manda kœwu oyo teasho tœ 'e, tshe mbœrœ adœke 'e mɔmɔ lœ kœyindœrœ nene, tshe to gbɔgbɔ fœ 'e adœke 'e kœshi gbɨ. ");
INSERT INTO mnh_vpl VALUES ("P15_11","090_5_11","1PE","5","11","11","Kaka tshe dœ Gbozu ga pa œrœ kɔ waa dœ waa. Ame! ");
INSERT INTO mnh_vpl VALUES ("P15_12","090_5_12","1PE","5","12","12","Mœ su ondo mbetinœ asœ fœ 'e lœ awa nœ aya azœ dœ Sila, á tshe zatœ ye djigi fœ Ndjaba. Mœ yindœ kœza kœru lɔsu fœ 'e, œdœ ndje kœpa o'o tœ upu nœ ɔtshɔ lɔsu nœ Ndjaba á dœ́ adjapu, adœke 'e shi ngbɨrɨ lœ nœ. ");
INSERT INTO mnh_vpl VALUES ("P15_13","090_5_13","1PE","5","13","13","Azu Ikrizia lœ Babilone ɓa ke á Ndjaba ke endje ndje ɓata 'e asœmœ vwa abala fœ 'e. Gbolo nœ mœ ndje dœ Marke vwa abala fœ 'e. ");
INSERT INTO mnh_vpl VALUES ("P15_14","090_5_14","1PE","5","14","14","'E za abala kœyindœsho nœ mœ ga ugurutœ 'e ɓata aaya azu. Kaka Ndjaba za kœsœ gee fœ 'e para kɔkɔ, e'e á 'e ngbɔtœ 'e bale dœ Kristu.");
INSERT INTO mnh_vpl VALUES ("P21_1","091_1_1","2PE","1","1","1","Œmœ Shimu Petro, ayi akwa nœ Yisu Kristu œdœ ndje ayi avwa nœ ye, mœ sœ kœsu mbetinœ asœ fœ e'e á 'e wuta aayi kœyindœrœ. 'E gbɔ kœyindœrœ á amanœ gbɔ waa, awa bale ɓata 'a lœ awa nœ Ndjaba nœ azœ á tshe sœ ndjii œdœ Yisu Kristu Ayi kœshe azœ. ");
INSERT INTO mnh_vpl VALUES ("P21_2","091_1_2","2PE","1","2","2","Kaka 'e sœ dœ egerœ kœsœ gee lœ awa nœ kœwusœ Ndjaba œdœ Gbozu nœ azœ dœ Yisu, yé endje ma ɔtshɔ lɔsu nœ endje ga ndœ 'e tɔpanœ kpuru. ");
INSERT INTO mnh_vpl VALUES ("P21_3","091_1_3","2PE","1","3","3","Dœ gbɔgbɔ nœ ye œnœ Ndjaba, Yisu Kristu to œrœ kɔ á li dœ azœ lœ soro ndje dœ ɔtshɔ mara kœmbœrœtœsho utshu Ndjaba. Œshe dá e azœ lœ awa nœ mokɔ nœ ye dœ tœ ye, á mbœrœ adœke a wusœ ye ndje dœ ɔtshɔ akwa nœ ye. ");
INSERT INTO mnh_vpl VALUES ("P21_4","091_1_4","2PE","1","4","4","Ataa, tshe ko œrœ á amanœ gbɔ waa á tshe pa lima ndœ kœko fœ azœ yekane lœ awa nœ kœgbɔ tœnœ, á 'e kœli kœwuta lœ ekperœ tshapashɔnœ á azu sœ dœ ogo kœmbœrœ tœnœ á ndɨ endje asœmœ, yé 'e kœza mara nœ œne dœ Ndjaba. ");
INSERT INTO mnh_vpl VALUES ("P21_5","091_1_5","2PE","1","5","5","Mbœrœ tœnœ ataa, 'e pa avwara adœke 'e za ɔtshɔ kœmbœrœtœsho ga pa kœyindœrœ nœ 'e. Ga pa ɔtshɔ kœmbœrœtœsho nœ 'e asœmœ, 'e dœ azu nœ kœwusœrœ. ");
INSERT INTO mnh_vpl VALUES ("P21_6","091_1_6","2PE","1","6","6","Ga pa kœwusœrœnœ, 'e dœ agbozu tshapa undu 'e; ga pa nœ, 'e sœ dœ kœru lɔsu. Ga pa kœru lɔsunœ, 'e zatœ 'e djigi ndœ kœmbœrœ akwa fœ Ndjaba. ");
INSERT INTO mnh_vpl VALUES ("P21_7","091_1_7","2PE","1","7","7","Ga pa nœ, 'e sœ dœ kœyindœsho, yé œ sœ dœ ayo. ");
INSERT INTO mnh_vpl VALUES ("P21_8","091_1_8","2PE","1","8","8","Gbambanœ nene, œdœ 'e kœsœ kœmbœrœ œneke kɔ ɔlɔ dœ ɔlɔ, œ za awa fœ 'e ndœ kœmbœrœ akwa á zu leyɔ fœ Ndjaba. Ataa, œ mbœrœ adœke 'e wusœ Gbozu nœ azœ dœ Yisu Kristu. ");
INSERT INTO mnh_vpl VALUES ("P21_9","091_1_9","2PE","1","9","9","Kashe uzu á tshe kœsœsœ kœmbœrœtœ ye atake nene, tshe sœ ɓata uzu á ala ye bu á tshe sœ kœtaɓa osho na tœnœ. Tshe djerœndœ nœ adœke Ndjaba djutɔ ekperœnœ á tshe mbœrœ lima kɔ. ");
INSERT INTO mnh_vpl VALUES ("P21_10","091_1_10","2PE","1","10","10","Ataa aaya mœ, 'e kpa pa avwaratœ 'e adœke 'e sœpe azu á Ndjaba e 'e, yé á ke 'e asœmœ. Œdœ 'e kœmbœrœ ataa, 'e yo ga lœ ekperœ bale nene. ");
INSERT INTO mnh_vpl VALUES ("P21_11","091_1_11","2PE","1","11","11","Mbœrœ tœnœ ataa, sharapu œ gu nene, Ndjaba œ kɔrɔ awa fœ 'e tœ kœli ga lœ Ogo gbozu nœ Gbozu nœ azœ dœ Yisu Kristu, Ayi kœshe azœ, yé 'e sœ ɓa zœ waa dœ waa. ");
INSERT INTO mnh_vpl VALUES ("P21_12","091_1_12","2PE","1","12","12","Ádánœ ataa, mœ kpa katœ kœpandœ œrœnœ alœke fœ 'e nene, ataa 'e wu ɓalima sœ nœ yekane á shi gbɨ lœ adjapu á endje yisœ nœ fœ 'e asœmœ. ");
INSERT INTO mnh_vpl VALUES ("P21_13","091_1_13","2PE","1","13","13","Kashe mœ wu ndjii adœke, ɓata á mœ sœ damba lœ ɔkɔnœ asœ, mœ sœ kolœ kœpa o'onœ asœke adœke 'e gbe dœ tœnœ ɔlɔ dœ ɔlɔ. ");
INSERT INTO mnh_vpl VALUES ("P21_14","091_1_14","2PE","1","14","14","Gbambanœ nene, mœ wusœ nœ adœke olo kuzu mœ ndo ye ɓata á Gbozu nœ azœ dœ Yisu Kristu yisœ nœ fœ mœ. ");
INSERT INTO mnh_vpl VALUES ("P21_15","091_1_15","2PE","1","15","15","Kashe mœ mbœrœ kɔ adœke manda kœtshu mœ, 'e li tœ kœgbɔndœ o'onœ asœke tœ osho kɔ. ");
INSERT INTO mnh_vpl VALUES ("P21_16","091_1_16","2PE","1","16","16","'A pa o'o fœ 'e adœke 'e wusœ mara á Gbozu nœ azœ dœ Yisu Kristu œ kwatœ ye dœ gbɔgbɔ. O'onœ asœke dœ́dœ́ ndœmatoro á azu guma liaka gbetshelœ nœ endje nene. Kashe 'a wu she lœ mokɔ nœ ye dœ ala 'a. ");
INSERT INTO mnh_vpl VALUES ("P21_17","091_1_17","2PE","1","17","17","Gbambanœ nene, Ndjaba Aba donga she œ za mokɔ fœ she, mokɔ nœ ye ropa œrœ kɔ, yé á pa lima adœke: «Tsheneke kœdœ Gbolo nœ mœ á mœ yindœ ye waa, mœ sœ dœ yanga mbœrœ she.» ");
INSERT INTO mnh_vpl VALUES ("P21_18","091_1_18","2PE","1","18","18","Adja a'a dœ tœ 'a, 'a dji lima tshamanœ asœ kœto ɓa lafo lɔkɔ á 'a sœ lima tœ œsœnœ dœ she, ɓa pa œyerœ kaga. ");
INSERT INTO mnh_vpl VALUES ("P21_19","091_1_19","2PE","1","19","19","Ga pa œneke asœke, 'a wusœ nœ adœke o'o á aayi kœgbara o'o gbara lima asœmœ, œtœnœ kœdœ adjapu. Œ li adœke 'e dara utu 'e ndœ kœdji kœgbara o'onœ asœmœ, mbœrœ œ sœ ɓata miinda á tshi lœ ubu osho œrrr ga tœ kœkɔrɔ osho yekane á tombele kœtɔ girigiri ɓa tœ lɔsu 'e. ");
INSERT INTO mnh_vpl VALUES ("P21_20","091_1_20","2PE","1","20","20","Utshunœ kɔ, 'e wusœ nœ dœ ɔtshɔnœ adœke, kœgbara o'onœ á aayi kœgbara o'o sú ɓa la Buku nœ Ndjaba asœmœ, anganœ bale toto lœ gbetshelœ nœ endje dœ tœ endje nene. ");
INSERT INTO mnh_vpl VALUES ("P21_21","091_1_21","2PE","1","21","21","Gbambanœ nene, o'o ama aayi kœgbara o'o toto lœ awa akwa nœ azu nene, kashe Ɔtshɔ Ɨshirɨ dá li ga lœ gbetshelœ nœ endje yekane á endje gbara o'o á to ɓa ndœ Ndjaba asœmœ. ");
INSERT INTO mnh_vpl VALUES ("P22_1","091_2_1","2PE","2","1","1","Utshunœ lima, aayi kœgbara o'o dœ wala wuta lima ga ugurutœ azu Israyele. Awa bale, aayi kœyisœrœ dœ wala œ wuta ndje ga ugurutœ 'e, yé œ yisœ œrœ á li tœ kœndɨ tshelœ kœyindœrœ nœ 'e. Endje vwaratœ endje tœ Gbozu á tshe ko lima endje ga shu lœ ekperœ, yé manda aya olo endje gbota kuzu nœ gbaga ga pa endje. ");
INSERT INTO mnh_vpl VALUES ("P22_2","091_2_2","2PE","2","2","2","Azu ndjoro œ za awa œrœ tshula nœ endje asœmœ, yé kpœlœ kumu endje, azu œ gu œsœ́ awa adja o'o nœ Ndjaba. ");
INSERT INTO mnh_vpl VALUES ("P22_3","091_2_3","2PE","2","3","3","Aayi kœyisœrœ dœ walanœ asœmœ, endje sœ dœ egerœ ogo kœgbɔ œrœ waa. Endje pa wala mbœrœ kœbɨlɨ dœ 'e yeka á kœgbɔ œrœ tshakane 'e. Kashe Ndjaba wa ɓa lima ngbanga pa endje ye, yé kuzu nœ gbaga sœ kœkate endje. ");
INSERT INTO mnh_vpl VALUES ("P22_4","091_2_4","2PE","2","4","4","Gbambanœ nene, œdœ ndje aandjelu á endje mbœrœ lima ekperœ, Ndjaba wuwu lima oyo endje nene kashe tshe ko lima endje va ga lœ kudu owo, ɓa tœ osho á bu kongorole dœ djingiri tœ endje. Tshe gbɔndœ endje kœkate lɔkɔ á tshe wa dœ ngbanga. ");
INSERT INTO mnh_vpl VALUES ("P22_5","091_2_5","2PE","2","5","5","Œ sœ ndje ataa awa bale ɓata á Ndjaba wuwu lima oyo azu pa osho nene dœ lɔkɔ á endje vwara lima tœ endje tœ kœdji she. Kashe tshe mbœrœ lima adœke endje nduru dœ lɔkɔ nœ egerœ kœsu ungu pa ɔshɔ djigi. Kashe tshe she lima kolœ Nowa á tshe sœ lima kœmɨndœ o'o á sœ ndjii, awa bale dœ anga azu mindu dœ bisha (7). ");
INSERT INTO mnh_vpl VALUES ("P22_6","091_2_6","2PE","2","6","6","Manda nœ, tshe wa lima ngbanga pa azu ogo Sodomo dœ pe Gomora yé œ sho lima endje dœ owo, yé endje ju lima kɔ. Tshe mbœrœ œneke lima tœ kœma œrœ á wuta mbatsha ga tœ aayi kœmbœrœ ekperœ kɔ. ");
INSERT INTO mnh_vpl VALUES ("P22_7","091_2_7","2PE","2","7","7","Kashe Ndjaba she lima Lota, uzu á tshe sœ ndjii, á lɔsu ye sœ lima kœka she tœ œrœ tshulanœ á azunœ sœ lima kœmbœrœ tœnœ. ");
INSERT INTO mnh_vpl VALUES ("P22_8","091_2_8","2PE","2","8","8","Gbambanœ nene, uzunœ á tshe sœ ndjii, á sœ lima ugurutœ endje asœmœ, wu lima endje kœmbœrœ ekperœ ɔlɔ dœ ɔlɔ, yé œ dji lima endje kœpa ekpe o'o. Kashe ɓata œshe kœdœ lima uzu á tshe sœ ndjii, lɔsu ye sœ lima kœka she tœ ekperœ nœ endje. ");
INSERT INTO mnh_vpl VALUES ("P22_9","091_2_9","2PE","2","9","9","Asœke kɔ sœ kœma adœke, Gbozu Ndjaba wusœ kœmbœrœ adœke azu nœ ye wuta lœ ɔgbɔrœ. Kashe tshe gbɔndœ aayi kœmbœrœ ekperœ ndœ kœza djofele fœ endje dœ lɔkɔ nœ kœwa ngbanga. ");
INSERT INTO mnh_vpl VALUES ("P22_10","091_2_10","2PE","2","10","10","Utshunœ kɔ, tshe za ɔgbɔ djofele fœ aayi kœza ekpe awa nœ ɔkɔ, á endje vwaratœ endje adœke Ndjaba dœ́dœ́ Gbozu nœ œne nene. Aayi kœyisœrœ dœ walanœ asœmœ gbe adœke awa akwa nœ œne dœ tœ œne li ye. Endje kœdœ aayi egerœ kumu, endje sœsœ dœ awa kœgu œsœ aayi mokɔ ɓa lafo nene. ");
INSERT INTO mnh_vpl VALUES ("P22_11","091_2_11","2PE","2","11","11","Andaa œdœ ndje aandjelu á endje ropa endje dœ egerœ gbɔgbɔ, endje papa o'o tœ kœgu œsœ aayi mokɔnœ asœke utshu Ndjaba nene. ");
INSERT INTO mnh_vpl VALUES ("P22_12","091_2_12","2PE","2","12","12","Kashe azunœ asœmœ sœ ɓata agea á endje gugu dœ kœwusœrœ nene, á Ndjaba mbœrœ endje adœke azu gɨ uku endje, œ wo endje, yé endje fu. Endje sœ kœgu œsœ œrœ á endje wuwusœ ádánœ nene. Endje fu ɓata agea. ");
INSERT INTO mnh_vpl VALUES ("P22_13","091_2_13","2PE","2","13","13","Endje gbɔ bala œrœ tshangba ekperœ kɔ á endje sœ kœmbœrœ tœnœ, endje sœ kolœ dœ yanga ndœ kœmbœrœ ekperœ dœ adja ɔlɔ. Œdœ 'e kœsœ kœzɨ œrœ dœ endje tœ osho bale, endje sœ kœsœ dœ yanga kœbɨlɨ 'e yé mara kœmbœrœtœ endje sœ kœndɨ ɨ'ɨrɨ 'e. ");
INSERT INTO mnh_vpl VALUES ("P22_14","091_2_14","2PE","2","14","14","Ala endje fa kolœ ndœ kœmbœrœ angba budu, endje sœsœ kœmɔ dœ kœmbœrœ ekperœ nene yé endje sœ kœbɨlɨ azu á endje mɔɔmɔ ndœ kœmbœrœ ekperœ. Lɔsu endje sú dœ ogo kœgbɔ œrœ. Ataa, Ndjaba œ wa ɔgbɔ ngbanga pa endje tako. ");
INSERT INTO mnh_vpl VALUES ("P22_15","091_2_15","2PE","2","15","15","Endje katœ awa á sœ ndjii yé œ gu ndœ awa Balaame, gbolo nœ Bosɔre á tshe yi lima ndœ kœgbɔ ngendja lœ awa nœ kœmbœrœ ekperœ. ");
INSERT INTO mnh_vpl VALUES ("P22_16","091_2_16","2PE","2","16","16","Kashe Ndjaba gbagbara lima Balaame mbœrœ ekperœ á tshe mbœrœ. Mbœrœ mbarata á tshe papa o'o nene te lima tœ kœpa o'o fœ Balaame ɓata uzu, yé œ pakata ye adœke tshe gbagbara o'o iyinœ asœmœ nene. ");
INSERT INTO mnh_vpl VALUES ("P22_17","091_2_17","2PE","2","17","17","Aayi kœyisœrœ dœ walanœ asœmœ sœ ɓata kumu ungu á ɔrɔ, endje sœ ɓata yavuru á bu kpikpikpi, kashe œ ni nene. Ndjaba guma ɓalima osho kœsœ á bu kporokoto kœ vu dœ endje. ");
INSERT INTO mnh_vpl VALUES ("P22_18","091_2_18","2PE","2","18","18","Endje sœ kœpa o'o á ádánœ gugu nene mbœrœ kœmatœ endje. Endje sœ kœgbota azu á endje wuta damba ngɔngɔ ugurutœ azu á endje sœ lœ djingili, adœke endje kpa kwatœ endje ndœ kœmbœrœ œrœ tshula á undu endje sœ kœvwa endje ndœ nœ. ");
INSERT INTO mnh_vpl VALUES ("P22_19","091_2_19","2PE","2","19","19","Endje sœ kœmɨndœ nœ adœke aayi kœza awa œne wuta tshakudu kanga ye, andaa endje kœdœ adja akanga nœ kœmbœrœ œrœ á yi osho ga lœ ufu œrœ. Gbambanœ nene, œdœ uzu kœtɔpe œrœ deorrr, tshe te kanga nœ œrœnœ asœmœ. ");
INSERT INTO mnh_vpl VALUES ("P22_20","091_2_20","2PE","2","20","20","Azunœ asœmœ wu lima sœ Gbozu nœ azœ dœ Yisu Kristu á tshe kœdœ Ayi kœshe azœ, yé mbœrœ kœwusœrœnœ asœmœ, endje wuta lima lœ œrœ tshapashɔnœ asœke á ndɨ azu. Kashe œ kœsœ adœke endje kpa kwatœ endje ndœ nœ yé á kpa kotœ endje djigi ga lœnœ dœ mara adœke gbɔgbɔnœ ropa endje, atamœ kœsœ nœ endje ngɔngɔ asœ wuta tœ ekpenœ kœropa œneke lima utshunœ. ");
INSERT INTO mnh_vpl VALUES ("P22_21","091_2_21","2PE","2","21","21","Gbambanœ nene, œ sœ má lima dœ ɔtshɔnœ adœke endje wu lima sœ awa kœmbœrœ ɔtshɔrœ nene. Kashe œ sœ tœ ekpenœ kœropa nœ mbœrœ endje á endje wusœ nœ yeka á manda nœ á endje kpa katœ œyerœ awa akwa nœ Ndjaba á endje yi lima sœ nœ fœ endje. ");
INSERT INTO mnh_vpl VALUES ("P22_22","091_2_22","2PE","2","22","22","Œneke á mbœrœtœ endje fœ endje asœke li dœ gbaguru á pa adœke: «Yavoro ndja œ kpa kwatœ ye kœzɨ kœndja nœ ye» too ndje adœke: «Endje djutɔ kote kɔso yé katsha tshe kpa vwɨrɨtœ ye lœ kpata.» ");
INSERT INTO mnh_vpl VALUES ("P23_1","091_3_1","2PE","3","1","1","Aaya mœ á mœ yindœ 'e waa, asœke kpa kœdœ bisha mbeti á mœ su fœ 'e. Yé ɓala mbetinœ kɔ bibisha asœke, mœ su o'o tœ kœjo 'e tœ upu á 'e wu ɓa lima sœ nœ adœke 'e wuta dœ ɔtshɔ gbetshelœ. ");
INSERT INTO mnh_vpl VALUES ("P23_2","091_3_2","2PE","3","2","2","'E gbe dœ o'onœ á ayerœ aayi kœgbara o'o pa lima utshunœ kane, yé œ gbe ndje dœ awa o'onœ á Gbozu á tshe kœdœ Ayi kœshe osho ko lima fœ 'e lœ awa nœ aayi avwa á tshe vwa lima endje fœ 'e. ");
INSERT INTO mnh_vpl VALUES ("P23_3","091_3_3","2PE","3","3","3","Utshunœ kɔ, 'e wusœ nœ adœke, ndo dœ lɔkɔ kœka bala tshapashɔ, aayi kœmɔ osho á endje sœ kœna manda ogo undu endje dœ tœ endje, endje wuta. Endje tetœ kœmɔ 'e, ");
INSERT INTO mnh_vpl VALUES ("P23_4","091_3_4","2PE","3","4","4","yé œ pa adœke: «Adja Yisu œ kwatœ ye liaka œneke á tshe pa lima zœ da a? Gbambanœ nene, aata azœ tshu ɓalima yé œrœ bale yayapatœ ye manda endje nene. Œrœ kɔ sœpe kolœ liaka œneke á Ndjaba mbœrœ lima kœto tœ ali kœmbœrœ œrœ pa ɔshɔnœ asœke.» ");
INSERT INTO mnh_vpl VALUES ("P23_5","091_3_5","2PE","3","5","5","Azunœ á endje pa o'onœ asœke djerœndœ nœ adœke, lima utshunœ Ndjaba pa o'o yé tshalafo dœ tshaatɨ wuta. Tshe mbœrœ ɔshɔnœ asœke lœ awa nœ ungu, yé œ sœ dœ gbɔgbɔ mbœrœ ungu. ");
INSERT INTO mnh_vpl VALUES ("P23_6","091_3_6","2PE","3","6","6","Yé Ndjaba ndɨ ndje lima tshapashɔnœ asœke dœ awa nœ egerœ kœsu ungu á su lima pa osho djigi. ");
INSERT INTO mnh_vpl VALUES ("P23_7","091_3_7","2PE","3","7","7","Kashe kolœ dœ o'o ama ye bale, tshe pa lima adœke œne gbɔndœ tshalafo œdœ tshapashɔ nœ ngɔngɔ asœ ndœ kœsho tœnœ dœ owo dœ lɔkɔ á œne wa ngbanga œdœ dœ lɔkɔ kœndɨ aayi kœmbœrœ ekperœ. ");
INSERT INTO mnh_vpl VALUES ("P23_8","091_3_8","2PE","3","8","8","Kashe e'e dœ aaya mœ á mœ yindœ 'e waa asœke, anga œrœ bale á li adœke 'e djedjerœndœ nœ nene dœke: Gbozu wu olo bale tœ ala ye ɓata ngbugu kutu bale, yé œ wu ndje ngbugu kutu bale tœ ala ye ɓata olo bale. ");
INSERT INTO mnh_vpl VALUES ("P23_9","091_3_9","2PE","3","9","9","Gbozu gbegbeletœ ye tœ kœmbœrœ œrœ á tshe pa tœnœ nene ɓata anga azu œ gbe. Kashe tshe sœ dœ ugu lɔsu ga ndœ 'e mbœrœ á tshe yiyindœ nœ adœke uzu bale ndɨ nene. Kashe tshe yindœ nœ adœke, azu para kɔkɔ fatshalɔsu endje. ");
INSERT INTO mnh_vpl VALUES ("P23_10","091_3_10","2PE","3","10","10","Olo kœkwa Gbozu œ sœ ɓata kœna ayi angba. Dœ olonœ asœmœ, tshalafo œ yiwa yé anga ndavuru tshama œrœ œ kɨ. Owo œ ju œrœ tshalafo para kɔkɔ yé ɔshɔnœ asœ dœ pe œrœ tshapa nœ kɔ œ ju. ");
INSERT INTO mnh_vpl VALUES ("P23_11","091_3_11","2PE","3","11","11","Yé ɓata œrœ kɔ œ ju ataa, œ li dœ 'e kœdœ azu aɗe? 'E mbœrœ kotoo á soro 'e kœsœ yerœ a? 'E mbœrœ kotoo kœlɨsœ Ndjaba a? ");
INSERT INTO mnh_vpl VALUES ("P23_12","091_3_12","2PE","3","12","12","'E kate olo kœwa ngbanga nœ Ndjaba yé 'e kpa pa avwara adœke olonœ wuta gbara. Olonœ asœmœ, owo œ tetœ kœju tshalafo, yé œrœ tshelœnœ kɔ œ tshanga. ");
INSERT INTO mnh_vpl VALUES ("P23_13","091_3_13","2PE","3","13","13","Kashe a sœ kœkate tafo tshalafo œdœ pe tshapashɔnœ á Ndjaba pa lima o'o tœ nœ adœke œne mbœrœ asœmœ. Azu á endje sœ pa nœ œ dœ kolœ aayi kœmbœrœ œrœ á sœ ndjii. ");
INSERT INTO mnh_vpl VALUES ("P23_14","091_3_14","2PE","3","14","14","Mbœrœ tœnœ ataa, 'e dœ aaya mœ á mœ yindœ 'e waa, lœ kœkate olonœ asœmœ, 'e pa avwara adœke œ gbɔ 'e tœ azu á endje sœ ndjii, á Ndjaba œ gbɔ œrœ bale tœ kœgbagbara 'e lœ kumunœ nene yekane á 'e kœsœ dœ kœsœ gee utshu ye. ");
INSERT INTO mnh_vpl VALUES ("P23_15","091_3_15","2PE","3","15","15","'E wusœ nœ adœke ugu lɔsu nœ Gbozu nœ azœ kœdœ awa nœ kœshe 'e. Mbœrœ tœnœ dá aya azœ dœ Polo á a yindœ ye waa asœmœ su lima mbeti fœ 'e lœ awa nœ kœwusœtœ á Ndjaba za lima fœ she asœmœ. ");
INSERT INTO mnh_vpl VALUES ("P23_16","091_3_16","2PE","3","16","16","Œtœnœ ndje dá tshe sœ kœpa tœnœ ɓala mbeti nœ ye para kɔkɔ, kashe átá ádánœ gbɔ waa tœ kœwu tshelœ katanœ kporo.