﻿USE sofia;
DROP TABLE IF EXISTS sofia.mmx_vpl;
CREATE TABLE mmx_vpl (
  verseID VARCHAR(16) NOT NULL PRIMARY KEY,
  canon_order VARCHAR(12) NOT NULL,
  book VARCHAR(3) NOT NULL,
  chapter VARCHAR(3) NOT NULL,
  startVerse VARCHAR(3) NOT NULL,
  endVerse VARCHAR(3) NOT NULL,
  verseText TEXT CHARACTER SET UTF8 NOT NULL) ENGINE=MyISAM;
LOCK TABLES mmx_vpl WRITE;
INSERT INTO mmx_vpl VALUES ("PS1_1","020_1_1","PSA","1","1","1","Lomomo rinedi di raba rulu levelinga loklok tooro at limixin kapmek la dixo mumu asu lampoovo at limixin di lok laxakapmek, kopla dinak lok esogo minedi di paase aksaksa ri ne Moroa. ");
INSERT INTO mmx_vpl VALUES ("PS1_2","020_1_2","PSA","1","2","2","Ketla, di suma ka lomomo atla di mumu asu Laulis Linga at Leeme Silok, la dim doma mumu amisix i at levenaleng kangking la at levenaleng kanimin bok. ");
INSERT INTO mmx_vpl VALUES ("PS1_3","020_1_3","PSA","1","3","3","Di lok ngan larauna di suusu ro at lisigege dan, la di pisix akmokso levempeven at levengaaling pipisik at laxampeeve, la levenang atdi kopmen nak mada si, la na mamang. Mo limixin di ngasang kobot at levempanga axap di lox i. ");
INSERT INTO mmx_vpl VALUES ("PS1_4","020_1_4","PSA","1","4","4","Ketla limixin kapmek dixok lok kuren. Di lok ngan mun levempusuvus at levenbeo, lamanman it mas kepe i. ");
INSERT INTO mmx_vpl VALUES ("PS1_5","020_1_5","PSA","1","5","5","At laaleng ne Moroa na viila mumu loklok at limixin axap, ni naba lok li lumumuat mavana at limixin kapmek, la naba solasu xepe di basinge limixin akmokso ren. ");
INSERT INTO mmx_vpl VALUES ("PS1_6","020_1_6","PSA","1","6","6","Limixin manmanton dit pas keneng at loklok tatao at Leeme Silok, ne Moroa, ketla nedi di mumu asu langas kapmek, dinaba seeve. ");
INSERT INTO mmx_vpl VALUES ("PS2_1","020_2_1","PSA","2","1","1","Tila ba, limixin at levenabung mixin petpes di sevut li leventaangas kapmek kusu dinoxok lok maxopok at ne Moroa? Tila ba limixin di mumu asu lodoxoma gamasa xerepmo? ");
INSERT INTO mmx_vpl VALUES ("PS2_2","020_2_2","PSA","2","2","2","Lavaorong at na lavatbung menemen, di gagas ti esep eburu mi ne Moroa. La luvuttadi amgomgo dit kis buru ri puse ngas ti lox asi Leeme Silok, eburu mi Lanarong no neni ga soxolik ka i. ");
INSERT INTO mmx_vpl VALUES ("PS2_3","020_2_3","PSA","2","3","3","La di lok, “Ata lox asepmus dik basinge lamgomgonga atnedu, la ataba ke xepe levelinga atnedu.” ");
INSERT INTO mmx_vpl VALUES ("PS2_4","020_2_4","PSA","2","4","4","To vana at loxonin orong teren at lebelen laxalibet, Leeme Silok ing longon mumu mo lodoxoma atdi, la i paase kalise ba ridi. ");
INSERT INTO mmx_vpl VALUES ("PS2_5","020_2_5","PSA","2","5","5","La melemu neni i belengatngas tinotno, la i paase sok di la lumukmusak silok teren ing long amarat aleng tinotno di. ");
INSERT INTO mmx_vpl VALUES ("PS2_6","020_2_6","PSA","2","6","6","Ni i lok tidi, “To Saion at lakaana xaala rak, ara vaxaxis aulis li vam loorong tarax e.” ");
INSERT INTO mmx_vpl VALUES ("PS2_7","020_2_7","PSA","2","7","7","Loorong i lok, “Nia anaba vaase asu bok levempanga Leeme Silok i tong atkatla li i. La ni ga lok tia, ‘Nenu ne Nuruk. Ningina nia a lok ngan ne Tamam. ");
INSERT INTO mmx_vpl VALUES ("PS2_8","020_2_8","PSA","2","8","8","Una sing ia, la nia anaba raba u mi larabung mixin axap. Unaba ruuna ka axap lavatbung menemen. ");
INSERT INTO mmx_vpl VALUES ("PS2_9","020_2_9","PSA","2","9","9","La unabam gomgonga di mi lakdak aen i lolos, la unaba sep povorok nedi ngan lengkong sosopen kangka i reporok.’” ");
INSERT INTO mmx_vpl VALUES ("PS2_10","020_2_10","PSA","2","10","10","Kuren la nemi lavaorong, mina xasep at levelinga rak la nemi lubung amgomgo at na lavatbung menemen, mina ronga avukat na levempapaase aronga. ");
INSERT INTO mmx_vpl VALUES ("PS2_11","020_2_11","PSA","2","11","11","Mina lotu saparap ne Moroa mi loklok ngangao, la mina pavanga i mi lanmarat. ");
INSERT INTO mmx_vpl VALUES ("PS2_12","020_2_12","PSA","2","12","12","Minat kis tintiding to melamgo ren. Naba lok kapmek do ni na musak la soso mun nemi axap mina uu. Nedi axap dik sixit uto saparap ne Moroa kusu ne Moroa na lok see atdi, dinaba momo. ");
INSERT INTO mmx_vpl VALUES ("PS3_1","020_3_1","PSA","3","1","1","Leeme Silok, limixin solo di munepen minia. La buaang bok limixin di vas taba rulu xepe nga ia, dira munepen minia. ");
INSERT INTO mmx_vpl VALUES ("PS3_2","020_3_2","PSA","3","2","2","La di paase mumu ia la dik lok keretna, “Moroa noxo lok tooro i.” ");
INSERT INTO mmx_vpl VALUES ("PS3_3","020_3_3","PSA","3","3","3","Ketla nenu, Leeme Silok, amisik nenu Lenban tia at levenaniu. Nenu mene u raba ia mi lolos ti sak tup mi limixin dit kis munepen minia. La nenu mun u lox alolos ia ngan laabelemes. ");
INSERT INTO mmx_vpl VALUES ("PS3_4","020_3_4","PSA","3","4","4","A sing lolos Leeme Silok mo ik lok tovana at lakaana kaala ren Saion la ing tonga ka lanteng tarak kusu ti loklok tooro. ");
INSERT INTO mmx_vpl VALUES ("PS3_5","020_3_5","PSA","3","5","5","A subu midi xopok la a unga, la a nemen avukat at laxanimin axap atla Leeme Silok ik lok see rak. ");
INSERT INTO mmx_vpl VALUES ("PS3_6","020_3_6","PSA","3","6","6","Nia axo marat at legesa sangaun larabin sangaun kobot limixin munepen minia di tu xangkan ia at levengkot axap. ");
INSERT INTO mmx_vpl VALUES ("PS3_7","020_3_7","PSA","3","7","7","Ude u, Leeme Silok! Lox asepsu ia, Moroa rak! Unaba lox i atla uk lox asongot limixin munepen minia, la uk lok kepe lolos basinge di kusu di noxo lox asongor ia. ");
INSERT INTO mmx_vpl VALUES ("PS3_8","020_3_8","PSA","3","8","8","Leeme Silok ik lok tooro limixin teren la di sak tup mi limixin munepen midi. La a sing i xusu neni naba lox anarong limixin teren. ");
INSERT INTO mmx_vpl VALUES ("PS4_1","020_4_1","PSA","4","1","1","O Moroa, nenu Lentupe ria! Una vaase porang ia do ana sing u. Dola nia aga ekip tangarang mi levenmumuat, nenu ga lok tooro ia. Monga una lox asuusu lebelen tuntun taram tia la una ronga lising tarak. ");
INSERT INTO mmx_vpl VALUES ("PS4_2","020_4_2","PSA","4","2","2","Lingisa ba nemi limixin kapmek miba xap ti paase aksaksa ria? Lingisa ba uba xap ti vavara solo ri levempanga xopmen turuturun teren, la ti mumu asu levempanga xaxarang? ");
INSERT INTO mmx_vpl VALUES ("PS4_3","020_4_3","PSA","4","3","3","Ketla mina xasep do Leeme Silok ira soxolik ka vam limixin manmanton kusu tin, la ing tonga ia do a toro rin. ");
INSERT INTO mmx_vpl VALUES ("PS4_4","020_4_4","PSA","4","4","4","Mi guta ke gat lebelemamao na sat arup nimi at laxapmek, la mina ke xepe libilinga. Do minak midi at laraora atnimi, minak midi pilo la minam doma mumu avukat na levelinga. ");
INSERT INTO mmx_vpl VALUES ("PS4_5","020_4_5","PSA","4","5","5","Minaplavang ti Leeme Silok mi levempanga naba lox epovo at lodoxoma ren, la minat kis la mina nunu saga ren. ");
INSERT INTO mmx_vpl VALUES ("PS4_6","020_4_6","PSA","4","6","6","Buaang nedi di ngising keretna, “O Leeme Silok, una raba nema mi laxaloklox anarong solo. Una lox asuusu amisik lebelemulus tinama.” ");
INSERT INTO mmx_vpl VALUES ("PS4_7","020_4_7","PSA","4","7","7","Ketla mo lomomo rak tu, ne Moroa, i volo mo lomomo nedi dinaba ruuna i, ap mo laaleng levempipisik at leventaamang piao eburu mi laxadan vaen na umsu aleng. ");
INSERT INTO mmx_vpl VALUES ("PS4_8","020_4_8","PSA","4","8","8","Dola a subu midi, a unga xeneng at lenmila. O Leeme Silok nenu xusuk, u xok nunuan ia. ");
INSERT INTO mmx_vpl VALUES ("PS5_1","020_5_1","PSA","5","1","1","O Leeme Silok. Una ronga levelinga rak. Una ronga ia, at mes silok. ");
INSERT INTO mmx_vpl VALUES ("PS5_2","020_5_2","PSA","5","2","2","Una ronga res at lerengteng tarak ti loklok tooro. Nu ne Moroa rak la Loorong Silok tarak! Nia a sing tu. O Leeme Silok, ");
INSERT INTO mmx_vpl VALUES ("PS5_3","020_5_3","PSA","5","3","3","ung tonga laxaka rak maxantamak suubu. At laxangking i soo su, a tong asu levesingising tarak, la at kis ngangais ti lovoporang taram tia. ");
INSERT INTO mmx_vpl VALUES ("PS5_4","020_5_4","PSA","5","4","4","Nenu xopmen lomoroa no uk lok momo ri libilinga. Uxo esuuxun mi libilinga. ");
INSERT INTO mmx_vpl VALUES ("PS5_5","020_5_5","PSA","5","5","5","Nenu uxo tu ebelen tinotno minedi limixin loklox aaso. U belengatngas tino rinedi axap limixin kapmek. ");
INSERT INTO mmx_vpl VALUES ("PS5_6","020_5_6","PSA","5","6","6","U sesele utut kepe limixin kaxarang. La u bulunga xepe rino nedi limixin sesep, la nedi di babala vukpuk limixin petpes. ");
INSERT INTO mmx_vpl VALUES ("PS5_7","020_5_7","PSA","5","7","7","Ketla mumu mene labalamu silok taram, u ke avolo ia xusu ana vubeles at loogu laplavang taram i melemelengan. La ana lotu saparav u go, la ana xis tintiding saparav u mi loklok ngangao. ");
INSERT INTO mmx_vpl VALUES ("PS5_8","020_5_8","PSA","5","8","8","O Leeme Silok, buaang limixin di munepen minia! Unamgonga ia xusu ana mumu asu lavavara xa ram. Una lox axasep langas taram kusu nia ana mumu asu i. ");
INSERT INTO mmx_vpl VALUES ("PS5_9","020_5_9","PSA","5","9","9","Levempanga salai limixin munepen minia dina tong i, anoxo mu asu i. Nedi mun limixin sepsep tadi. Levelinga atnedi ik sixit nunuan ketla ni levelinga loklox atdan mun la i umsu mi laxaxarang arup kusu dina sev amet limixin. ");
INSERT INTO mmx_vpl VALUES ("PS5_10","020_5_10","PSA","5","10","10","O Moroa, una vaase asi di la una lox asongot di. Naba lox avukat do mo leveloklok kakapmek atnedi naba lox asuusu levenmumuat silok tidi. Una xala xepe di basinge u, mumu loklok kakapmek mi lorongtonga xepe atnedi saparav u. ");
INSERT INTO mmx_vpl VALUES ("PS5_11","020_5_11","PSA","5","11","11","Ketla nedi dik lok keneng at loklok tatao ram, dina momo la dinak pixan momo amisik. Una lok see atnedi di vavara aleng u. Nedi di momo aleng mumu mun u. ");
INSERT INTO mmx_vpl VALUES ("PS5_12","020_5_12","PSA","5","12","12","O Leeme Silok, uk lox anarong nedi di mumu asu levelinga ram. Labalamu ram i tupe di ngan lenban. ");
INSERT INTO mmx_vpl VALUES ("PS6_1","020_6_1","PSA","6","1","1","O Leeme Silok, nemen uta musak la uta vaase sox ia. Nemen uta lox asongor ia keneng mun at lebelemamao ram. ");
INSERT INTO mmx_vpl VALUES ("PS6_2","020_6_2","PSA","6","2","2","O Leeme Silok, lengkot tarak i molo axap; una lox asuusu lebelen tuntun tia! Una lox alolos ia, nia na ara molos axap. ");
INSERT INTO mmx_vpl VALUES ("PS6_3","020_6_3","PSA","6","3","3","O Leeme Silok, labalak i reng aleng. Lingisa ba unaba lok tooro ia? ");
INSERT INTO mmx_vpl VALUES ("PS6_4","020_6_4","PSA","6","4","4","O Leeme Silok, ude u, la una lox asepsu ia. At lebelen tuntun taram una lox asepsu ia basinge lanmet, ");
INSERT INTO mmx_vpl VALUES ("PS6_5","020_6_5","PSA","6","5","5","atla to at lemenemen at labarongan, limixin kopmen dinam doma su ram, la kopmen tara na emi asu minu go. ");
INSERT INTO mmx_vpl VALUES ("PS6_6","020_6_6","PSA","6","6","6","Lanbulu silok i suxuna ia la lolos tarak i auret na xap. At laxangkanimin axap loora rak mi lavatlingun imlumlu at levengkamkabili dan at lamarak. ");
INSERT INTO mmx_vpl VALUES ("PS6_7","020_6_7","PSA","6","7","7","Axo epovo do ana reven avukat ta. Luxatli rak ira dang pe axap, atla ang teng amisik at limixin munepen minia ding long areng amisix ia. ");
INSERT INTO mmx_vpl VALUES ("PS6_8","020_6_8","PSA","6","8","8","Nemi limixin kapmek, uto nimi basinge ia. Leeme Silok ing tonga lerengteng tarak. ");
INSERT INTO mmx_vpl VALUES ("PS6_9","020_6_9","PSA","6","9","9","I ronga bok lerengteng tarak ti loklok tooro la ni naba sep siam at levesingising tarak. ");
INSERT INTO mmx_vpl VALUES ("PS6_10","020_6_10","PSA","6","10","10","Limixin munepen minia dinaba ekip tangarang mi lainmangan la langsangan lumumuat atla Leeme Silok naba sak tup midi. Soso mun dinaba lok tangtangku la ni naba xala oo di. ");
INSERT INTO mmx_vpl VALUES ("PS7_1","020_7_1","PSA","7","1","1","O Leeme Silok, nu ne Moroa rak. Anaa nia a vot saparav u kusu una lok see rak. Una lok tooro ia la una lox asepsu box ia basinge nedi di xala mu rak. ");
INSERT INTO mmx_vpl VALUES ("PS7_2","020_7_2","PSA","7","2","2","Naba lok kapmek do dina lok ngan lavatlaion la dina xip kepe ia uto vaxalom la kopmen tara go ri lok tooro ia, la dinaba lais axakalik labantuxu rak. ");
INSERT INTO mmx_vpl VALUES ("PS7_3","020_7_3","PSA","7","3","4","O Leeme Silok, la nu ne Moroa rak, dola aga lok pam tibilinga ri tara, la dola aga bala vukpuk tara tarapentangas tarak, kopla aga lok tavanga i lok kapmek tino ti laradi munepen minia la kopmen tavasuun teren, kopla aga xarang taba tara. Dola nia agara lok pam tevempanga at na i, ");
INSERT INTO mmx_vpl VALUES ("PS7_5","020_7_5","PSA","7","5","5","i lox avukat do una ke avolo limixin munepen minia dina mamat mu ia la dina rebeng alis kaka ia la dina sev asi ia la dina sev amer ia, la dina ke xepe labantuxu rak nak midi gamasa go at laxangka! ");
INSERT INTO mmx_vpl VALUES ("PS7_6","020_7_6","PSA","7","6","6","O Leeme Silok, una lox asuusu lebelemamao ram. Una beleku kaxat, la una tupe lumukmusak silok at limixin munepen minia, la una lok tooro ia. Nenu u vavara mene limixin dina rooro ngan limixin manmanton. ");
INSERT INTO mmx_vpl VALUES ("PS7_7","020_7_7","PSA","7","7","7","Kuren la unak lok bubua ka axap limixin saparav u, la unam gomgonga di boro vana at lixitkis orong taram. ");
INSERT INTO mmx_vpl VALUES ("PS7_8","020_7_8","PSA","7","8","8","Nenu laradi rongtonga linga at limixin axap. O Leeme Silok, una ru ria, uklen i do nia laradi sepse. ");
INSERT INTO mmx_vpl VALUES ("PS7_9","020_7_9","PSA","7","9","9","Nenu ne Moroa manmanton la u viila mumu levendoxoma atnema, la lavavara bok atnema. Una lox axap loklok kakapmek at limixin kapmek. La una raba luunun ti limixin nunuan. ");
INSERT INTO mmx_vpl VALUES ("PS7_10","020_7_10","PSA","7","10","10","Moroa ni Lurutu See Pe rak. Neni ik lox asepsu nedi di mumu asu levelinga ren. ");
INSERT INTO mmx_vpl VALUES ("PS7_11","020_7_11","PSA","7","11","11","Moroa ni lagale laradi rongtonga linga la levelinga ren ik mokso. Amisik ni i paase asi limixin kapmek. ");
INSERT INTO mmx_vpl VALUES ("PS7_12","020_7_12","PSA","7","12","12","Dola kopmen dinak lox ekun loklok atdi, Moroa naba sua ka lavarise esep teren la naba rep tong pen labanara ren la na lox agagas li i. ");
INSERT INTO mmx_vpl VALUES ("PS7_13","020_7_13","PSA","7","13","13","Ni naba lok kaka levempanga esep teren, la na lok dola na so asu mi levesoso xao ren. ");
INSERT INTO mmx_vpl VALUES ("PS7_14","020_7_14","PSA","7","14","14","Moroa, una ven ba limixin kapmek di doxoma gagas li leventaangas ti laxakapmek. Dik soxovo li levenmumuat la di xaxarang arup limixin. ");
INSERT INTO mmx_vpl VALUES ("PS7_15","020_7_15","PSA","7","15","15","Ketla nedi xa di onon at larapelixo di lili i ri leventaba vetpes. ");
INSERT INTO mmx_vpl VALUES ("PS7_16","020_7_16","PSA","7","16","16","Kuren la di ruuna ka losongsongot mumu xa laxakapmek atnedi. La lemusak mi leesep di gagas min ti leventaba vetpes i lok kapmek axa di. ");
INSERT INTO mmx_vpl VALUES ("PS7_17","020_7_17","PSA","7","17","17","A tong aorong ti Leeme Silok atla i tong asu lavapaase ramtaba ina mi lodoxoma mokmokso. Ak pixan emi asu ri Leeme Silok, ni Leeme Avolo. ");
INSERT INTO mmx_vpl VALUES ("PS8_1","020_8_1","PSA","8","1","1","Leeme Silok, nenu xusuk mun Leeme Silok atnema. Limixin axap at na lavatbung menemen di ven lempanga uga rudum li i, la kerepmo di ven kibis i do nu u silok aleng. Leemi asu saparav u di ronga i rovana at lebelen laxalibet. ");
INSERT INTO mmx_vpl VALUES ("PS8_2","020_8_2","PSA","8","2","2","Laxamdak mi laxaalik kakalik dik pixan emi asu minu la lubungkadede bok. Uga bos loroboro ri lok pe lebelemamao at limixin dit kis munepen minu la atnedi dik sok tixirixes kepe levelinga ram. ");
INSERT INTO mmx_vpl VALUES ("PS8_3","020_8_3","PSA","8","3","3","Dola a ven laxalibet nu ga rudum li i, lagaaling mi laxampenti uga vaxaxis di at levengkot atnedi la am doma xeretna. ");
INSERT INTO mmx_vpl VALUES ("PS8_4","020_8_4","PSA","8","4","4","Limixin nedi lempanga salai, la uram doma mu solo di. Nedi lempanga gamasa mun, ketla uk lok tatao avukat tino di. ");
INSERT INTO mmx_vpl VALUES ("PS8_5","020_8_5","PSA","8","5","5","Nenu uga raba di mi lolos pana at lempanga axap, ketla lolos atdi i lixilik mun ti lolos taram ne Moroa. La uga lox asilok di mi levenasen silok la lisisinang nunuan. ");
INSERT INTO mmx_vpl VALUES ("PS8_6","020_8_6","PSA","8","6","6","Uga lok katling di xusu dinam gomgonga levempanga axap nu ga rudum li i. Uga lox asilox di mavana at levempanga axap, ");
INSERT INTO mmx_vpl VALUES ("PS8_7","020_8_7","PSA","8","7","7","i ngan levesipsip, laxanbulumaxao, la laxampanga sio axap bok at laxairing, ");
INSERT INTO mmx_vpl VALUES ("PS8_8","020_8_8","PSA","8","8","8","la lavapixa mi levenmat, la levempanga axap at lebelen laras. ");
INSERT INTO mmx_vpl VALUES ("PS8_9","020_8_9","PSA","8","9","9","O Leeme Silok, nenu xusuk mun Leeme Silok atnema. Limixin axap at na lavatbung menemen di ven lempanga uga rudum li i, la kerepmo di ven kibis i do nu u silok aleng. ");
INSERT INTO mmx_vpl VALUES ("PS9_1","020_9_1","PSA","9","1","1","Leeme Silok, nia ana emi asu minu mi labalak axap. Anaba tong asu axap nom levempanga nunuan nu ga lox i. ");
INSERT INTO mmx_vpl VALUES ("PS9_2","020_9_2","PSA","9","2","2","Anabak pixan mi lomomo, lavasuun teren ataram. Anabak pixan emi asu minu, ne Moroa, nu Lanaraavuk. ");
INSERT INTO mmx_vpl VALUES ("PS9_3","020_9_3","PSA","9","3","3","Limixin munepen minia dik sixiro do di ven u, dik sak subu epopolo ri lanmet. ");
INSERT INTO mmx_vpl VALUES ("PS9_4","020_9_4","PSA","9","4","4","Ut kis at loxot tongtonga linga ram, la u tong asu lavapaase mi lodoxoma mokmokso. Uga ronga linga rak la uga ru ria. ");
INSERT INTO mmx_vpl VALUES ("PS9_5","020_9_5","PSA","9","5","5","Uga paase asi lavamolon, la uga sele utut kepe limixin kapmek. La kopmen tara noxo doma asu bok ba atdi. ");
INSERT INTO mmx_vpl VALUES ("PS9_6","020_9_6","PSA","9","6","6","Lavamunepen minema ma noxo ven bok ba di. Ura sele utut kepe vam laramenemen silok atnedi, la limixin axap dira domampe axap pam di. ");
INSERT INTO mmx_vpl VALUES ("PS9_7","020_9_7","PSA","9","7","7","Ketla Leeme Silok, neni Loorong Avolo la naba nemen amisik kuren, la kopmen tekavaxap teren. Ira lox agagas li vam loxonin orong teren ti viila mumu loklok at limixin. ");
INSERT INTO mmx_vpl VALUES ("PS9_8","020_9_8","PSA","9","8","8","Ni im gomgonga lavatbung menemen mi lavapaase mokmokso. Mi lodoxoma mokmokso i viila mumu loklok at limixin boro at larabung mixin. ");
INSERT INTO mmx_vpl VALUES ("PS9_9","020_9_9","PSA","9","9","9","Leeme Silok i tu ngan Loxot Loklox Alipe, la limixin baava di epovo dina vubeles ap mo Loxot Loklox Alipe ren, la dina nemen nunuan e at levenaleng kakapmek. ");
INSERT INTO mmx_vpl VALUES ("PS9_10","020_9_10","PSA","9","10","10","Leeme Silok, nedi dikleklen u, dinaba nunu saga ram. La uxo raba rulu tara do lebelen i ngaongao ru. ");
INSERT INTO mmx_vpl VALUES ("PS9_11","020_9_11","PSA","9","11","11","Minak pixan emi asu ri Leeme Silok, mo it kis ngan Lamgomgo rovana Saion. Mina tong axasev i ri limixin at larabung mixin axap mumu levempanga ni gak lox i. ");
INSERT INTO mmx_vpl VALUES ("PS9_12","020_9_12","PSA","9","12","12","Moroa im doma su amisik atnedi ding songot mi laxanmumuat. Neni ixong tonga xepe lerengteng atnedi, ketla ik lox asongot nedi di lox abaava di. ");
INSERT INTO mmx_vpl VALUES ("PS9_13","020_9_13","PSA","9","13","13","O Leeme Silok, una lox asuusu lebelen tuntun tia! Una ven na levesongsongot limixin munepen minia dik lox i ria! O Leeme Silok. Lox asepsu ia basinge lanmet, ");
INSERT INTO mmx_vpl VALUES ("PS9_14","020_9_14","PSA","9","14","14","kusu anaba tu ro melamgo at limixin to Jerusalem, la ana tong asu i ridi ri levempanga nia a emi asu minu min. La ana lox asuusu lomomo rak atla uga lox asepsu ia. ");
INSERT INTO mmx_vpl VALUES ("PS9_15","020_9_15","PSA","9","15","15","Lavamolon diga xe lemet kusu ti sep limixin taram. Ketla nedi xa diga subu tup teren, nedi xa diga onon at larapelixo atdi. ");
INSERT INTO mmx_vpl VALUES ("PS9_16","020_9_16","PSA","9","16","16","Leeme Silok ira lox asuvos pam i keneng at lorongtonga linga at langas ik mokso, la limixin kakapmek dinaba tu at lavapaase mumu leveloklok atnedi. ");
INSERT INTO mmx_vpl VALUES ("PS9_17","020_9_17","PSA","9","17","17","Lanmet ni langas at limixin axap dik lok laxakapmek, la tinedi axap bok dik sok sisixe ne Moroa. ");
INSERT INTO mmx_vpl VALUES ("PS9_18","020_9_18","PSA","9","18","18","Moroa noxo domampe rino amisik limixin dik pakes. Moroa noxo ke xepe amisik levendoxoma voovo at limixin banbalo ti loklok tooro la ni noxo lox abulubun kepe amisik di. ");
INSERT INTO mmx_vpl VALUES ("PS9_19","020_9_19","PSA","9","19","19","Leeme Silok, ude u! Nemen uta ke xepe limixin dina lox abulubun kepe levelinga ram! Una lam kaka lavamolon uto melamgo ram la una vaxaru di at lavapaase. ");
INSERT INTO mmx_vpl VALUES ("PS9_20","020_9_20","PSA","9","20","20","O Leeme Silok. Una lox amarat di, la una lox asuma xibis di do nedi luvuttadi mun kuren la dina ekip tangarang mi lanmet. ");
INSERT INTO mmx_vpl VALUES ("PS10_1","020_10_1","PSA","10","1","1","Leeme Silok, tila ba u nemen paxalom basinge nama? Tila u lipe basinge nema, dola nema ma ekip tangarang mi lumumuat? ");
INSERT INTO mmx_vpl VALUES ("PS10_2","020_10_2","PSA","10","2","2","Laradi xapmek it las i la ik lox asongot limixin banbalo. Una rebeng alis ka i at larapelixo i lili i xusu ti lox asubu limixin taram. ");
INSERT INTO mmx_vpl VALUES ("PS10_3","020_10_3","PSA","10","3","3","Laradi xapmek it las i mi levendoxoma xakapmek teren. Laradi mokmorong i paase aksaksa ri Leeme Silok la im taba sinta i. ");
INSERT INTO mmx_vpl VALUES ("PS10_4","020_10_4","PSA","10","4","4","Laradi xapmek kopmen nak lok ngangao at Leeme Silok. Ik lox aaso, kuren la at lodoxoma ren i lox abulubun ne Moroa. ");
INSERT INTO mmx_vpl VALUES ("PS10_5","020_10_5","PSA","10","5","5","Laradi xapmek ipnovos at levempanga axap ni ik lox i. Ketla ni ixo epovo na xasep avukat at lavapaase ramtaba ina at ne Moroa. Neni i paase aksaksa ri limixin munepen min. ");
INSERT INTO mmx_vpl VALUES ("PS10_6","020_10_6","PSA","10","6","6","Neni ik lok tin axa xeretna, “Kopmen tepanga naba lox abulu ia la ana ekip tangarang mi levenmumuat at lorooro axap tarak.” ");
INSERT INTO mmx_vpl VALUES ("PS10_7","020_10_7","PSA","10","7","7","Levempapaase ren i umsu mi lavapaase aksaksa, laxaxarang la levelinga xikiilu, la i paase asu soso mun levelinga bilinga. ");
INSERT INTO mmx_vpl VALUES ("PS10_8","020_10_8","PSA","10","8","8","Neni it kis alipe ro at laramenemen, la i gagas kusu nap sev amet limixin nunuan. La neni i kuxut tangais luvuttadi mokmokso, ");
INSERT INTO mmx_vpl VALUES ("PS10_9","020_10_9","PSA","10","9","9","la neni it kis alipe ro at loxot kukuxut teren ngan lavatlaion. Ik midi tangais limixin banbalo, la im tebeng alis kaka di at lelixo ren, la i sasat pes kaka di. ");
INSERT INTO mmx_vpl VALUES ("PS10_10","020_10_10","PSA","10","10","10","Kopmen tara go ti lok tooro di, kuren la ip sev asi di la di subu uto xopok, la lolos silok teren ik lok kakapmek tino di. ");
INSERT INTO mmx_vpl VALUES ("PS10_11","020_10_11","PSA","10","11","11","Laradi xapmek im doma i do, “Moroa xopmen nam doma solo limixin! Ira vamet pam la kopmen na epovo ri ven ia!” ");
INSERT INTO mmx_vpl VALUES ("PS10_12","020_10_12","PSA","10","12","12","O Leeme Silok, una lox asongot mo limixin kakapmek la una doma nedi limixin ua dim suma mo losongsongot! ");
INSERT INTO mmx_vpl VALUES ("PS10_13","020_10_13","PSA","10","13","13","Kereva lodoxoma at limixin kakapmek? Dim taba sinta ne Moroa, la dim doma i do, “Neni noxo lox asongot dik.” ");
INSERT INTO mmx_vpl VALUES ("PS10_14","020_10_14","PSA","10","14","14","Ketla nenu, Leeme Silok, u ven lenget ka mo levenmumuat la levesongsongot dik lox i ri limixin baava, la u gagas amisik kusu una lok tooro di. Limixin pakpakes di vot pasa u xusu una lok tooro di atla nenu laradi loklok tooro at limixin pakpakes. ");
INSERT INTO mmx_vpl VALUES ("PS10_15","020_10_15","PSA","10","15","15","Una lox axap lolos at luvuttadi xapmek, unak lox asongot di mumu levempanga xapmek dira lok pam i, kusu di noxo lok bok ba i. ");
INSERT INTO mmx_vpl VALUES ("PS10_16","020_10_16","PSA","10","16","16","Leeme Silok, neni Loorong Avolo la kopmen tekavaxap teren. Nedi di lotu saparap lomoroa vetpes, dinaba sonao rino basinge lenep kangka ren. ");
INSERT INTO mmx_vpl VALUES ("PS10_17","020_10_17","PSA","10","17","17","O Leeme Silok, unabang tonga levesing at limixin di lox alixilik di maxopok taram. La unaba lox abelemes nedi. ");
INSERT INTO mmx_vpl VALUES ("PS10_18","020_10_18","PSA","10","18","18","Unabang tonga levesing at lubungkarun la atnedi limixin baava. Unaba ru ridi, kusu limixin at lavatkangka di noxo lox amarat bok ba di. ");
INSERT INTO mmx_vpl VALUES ("PS11_1","020_11_1","PSA","11","1","1","Nia a nunu saga at Leeme Silok, ni laradi xumkubak pe ria. Kuren la anoxo ronga res at limixin tangtangku di tong i ria dola, “Una rava oo ngan lapka uto vana at lempatkaana, ");
INSERT INTO mmx_vpl VALUES ("PS11_2","020_11_2","PSA","11","2","2","atla limixin kapmek di gagas kusu dina so u mi levesoso atdi. Di kuxut tangais luvuttadi avukat to at levengkot buxumin kusu do dina soso di. ");
INSERT INTO mmx_vpl VALUES ("PS11_3","020_11_3","PSA","11","3","3","Laradi avukat naba lok lavanga salai, dola limixin axap ding tonga xepe levelinga at lubung amgomgo la kerepmo lorooro at limixin ik lok kapmek aleng?” ");
INSERT INTO mmx_vpl VALUES ("PS11_4","020_11_4","PSA","11","4","4","Leeme Silok, mo it kis at loogu laplavang teren i melemelengan. Loxonin orong teren ik lok toxun pana at lebelen laxalibet. I reven tatao limixin axap at lavatbung menemen la ikleklen levempanga axap dik lox i. ");
INSERT INTO mmx_vpl VALUES ("PS11_5","020_11_5","PSA","11","5","5","I viila mumu loklok at limixin avukat la limixin kapmek bok. Neni i belengatngas tino ti limixin di los polo Laulis Linga ren. ");
INSERT INTO mmx_vpl VALUES ("PS11_6","020_11_6","PSA","11","6","6","Neni naba soli asi laxao bokbolot la nabak bolot limixin kapmek mi la salpa (sulfur). La naba lox asongot di mi lamanman kapmek iplivi aleng. ");
INSERT INTO mmx_vpl VALUES ("PS11_7","020_11_7","PSA","11","7","7","Loklok at Leeme Silok in manton la i vara mun leven gugu nunuan. Laradi ik lok lempanga avukat nabat kis esogo eburu min to at lemenemen teren. ");
INSERT INTO mmx_vpl VALUES ("PS12_1","020_12_1","PSA","12","1","1","O Leeme Silok. Lok tooro nema. Kopmen bok ba taradi avukat go i nemen. U noxo ven kaka bok ba taradi ruturun go ik lok kantubu at limixin axap. ");
INSERT INTO mmx_vpl VALUES ("PS12_2","020_12_2","PSA","12","2","2","Nedi axap di vekarang taba, la di velox atdan ka la kerepmo dira xaxarang arup bok di. ");
INSERT INTO mmx_vpl VALUES ("PS12_3","020_12_3","PSA","12","3","3","O Leeme Silok. Una vamngus nedi limixin di velox atdan ka, la una vamngus bok nedi limixin dim simi aurut di la dik lok keretna, ");
INSERT INTO mmx_vpl VALUES ("PS12_4","020_12_4","PSA","12","4","4","“Mi levelinga atdik dik ta lok kaka levempanga dik ta vara rin. La dik ta tong levempanga nedik ta vara i do ata tong i, la ixo epovo tara na sep pepe dik.” ");
INSERT INTO mmx_vpl VALUES ("PS12_5","020_12_5","PSA","12","5","5","Ketla Leeme Silok i vaase xeretna, “Na nia anaba vot, atla di lox abaava limixin dik pakes. La nedi di sev asongot labantuxu atdi mo dit mes silok mi losongsongot. Anaba raba nedi limixin baava mi nom lixitkis avukat ding kongkat tin.” ");
INSERT INTO mmx_vpl VALUES ("PS12_6","020_12_6","PSA","12","6","6","I epovo rinotno do ata nunu at leveng kakaape at Leeme Silok atla leveng kakaape ren i lok ngan loxon siliva uat gamgames din tin i at laxao bokbolot ise at lavanuti rintin axap la i nunuan axap. ");
INSERT INTO mmx_vpl VALUES ("PS12_7","020_12_7","PSA","12","7","8","Limixin kakapmek di umsu at lengkot axap la nedi axap di emi asu mi laxakapmek. O Leeme Silok. Una lok tatao avukat nema basinge di. La una lok tooro nema xusu limixin kerepmo di noxo lok kapmek nema. ");
INSERT INTO mmx_vpl VALUES ("PS13_1","020_13_1","PSA","13","1","1","O Leeme Silok, ningisa ba unaba doma su rak? Kereva, u domampe rino nga ia? Tila rinotno la u lipe lamaram basinge ia? ");
INSERT INTO mmx_vpl VALUES ("PS13_2","020_13_2","PSA","13","2","2","Ningisa ba unaba lox axap na levenmumuat nia arap kip tutu min? Lavanisa aleng kangking la kanimin lanbulu silok i nemen keneng at lorooro rak? Ningisa ba unaba lok tooro ia xusu anoxok lok bok ba at loklok tatao at limixin munepen minia? ");
INSERT INTO mmx_vpl VALUES ("PS13_3","020_13_3","PSA","13","3","3","O Leeme Silok, nu ne Moroa rak. Doma su rak. Una sep siam at lising tarak. Una raba amlong ia mi lolos tarak. La nemen uta ke xepe ia xusu ana met. ");
INSERT INTO mmx_vpl VALUES ("PS13_4","020_13_4","PSA","13","4","4","Nemen uta ke avolo limixin munepen minia dina tong i do, “Nedik tara sev asubu vam i.” Nemen uta ke avolo di kusu dina lok momo aksaksa ria mumu i nom. ");
INSERT INTO mmx_vpl VALUES ("PS13_5","020_13_5","PSA","13","5","5","Ketla a nunu saga ram, atla labalamu lexen taram tia naba nemen amisik. Anaba momo dola una lox asepsu box ia basinge limixin munepen minia. ");
INSERT INTO mmx_vpl VALUES ("PS13_6","020_13_6","PSA","13","6","6","O Leeme Silok. Anabak pixan tu, atla ugara lox anarong pam ia. ");
INSERT INTO mmx_vpl VALUES ("PS14_1","020_14_1","PSA","14","1","1","Mo limixin di doma i do, “Kopmen tomoroa go.” Nedi limixin tangtangku. Lodoxoma atnedi i bilingot axap tino mi laxakapmek. La dira lok pam levempanga ik lok kapmek aleng tinotno, kopmen tara atdi i lok levempanga i lox avukat. ");
INSERT INTO mmx_vpl VALUES ("PS14_2","020_14_2","PSA","14","2","2","Leeme Silok ik milik si boro vana at lebelen laxalibet, la i reven limixin axap, do ni naba epovo ri ven kaka taradi leklen la tara bok i lotu saparav i. ");
INSERT INTO mmx_vpl VALUES ("PS14_3","020_14_3","PSA","14","3","3","Ketla nedi axap digara oon soogong pam, lorooro atnedi axap ira mau axap pam. Kopmen tinotno tara atdi ik lok lempanga i lox avukat, kopmen tinotno tegesara. ");
INSERT INTO mmx_vpl VALUES ("PS14_4","020_14_4","PSA","14","4","4","Leeme Silok i sue xeretna, “Kopmen dinaklen leventaangas nunuan? Kereva, nedi axap na dik lok laxakapmek, kopmen takleklen atdi? Dip kip pilo amisik limixin tarak, la kopmen tinotno dina ngising tia.” ");
INSERT INTO mmx_vpl VALUES ("PS14_5","020_14_5","PSA","14","5","5","Ketla melemu dinaba lingun aleng, atla ne Moroa i nemen eburu minedi limixin di mumu asu levelinga ren. ");
INSERT INTO mmx_vpl VALUES ("PS14_6","020_14_6","PSA","14","6","6","Nedi dik lox aekarakat levempanga luvuttadi banbalo di vara i do dina lox i. Ketla Leeme Silok nabak lok see atdi. ");
INSERT INTO mmx_vpl VALUES ("PS14_7","020_14_7","PSA","14","7","7","Nia a vara aleng tinotno i do ne Moroa na sak tiki tara boro Saion kusu na lox asepsu limixin me Israel basinge limixin munepen midi. Melemu limixin me Israel dinaba lok momo dola Leeme Silok na lox asang kobot amu manga di. ");
INSERT INTO mmx_vpl VALUES ("PS15_1","020_15_1","PSA","15","1","1","Leeme Silok, nege i epovo na vubeles at loogu xaala ram? Nege i epovo na nemen eburu minu ro Saion at lakaana xaala ram? ");
INSERT INTO mmx_vpl VALUES ("PS15_2","020_15_2","PSA","15","2","2","Neni laradi i mumu asu lavavara at ne Moroa at leventaangas axap, la ik lox amisik leveloklok in manton la levelinga ren i ruturun amisik. ");
INSERT INTO mmx_vpl VALUES ("PS15_3","020_15_3","PSA","15","3","3","La kopmen ni na paase asi taasen at tara ukopok. Kopmen na lok tibilinga ri larapen tangas teren, kopla na paase mumu nedi dik lox auret tin. ");
INSERT INTO mmx_vpl VALUES ("PS15_4","020_15_4","PSA","15","4","4","Neni i rexes nedi no ne Moroa i raba rulu nedi. Ketla neni ip kiv aurut levenasen atnedi di mumu asu levelinga at Leeme Silok. Ik lox epovo amisik leveng kakaape ren, keke i do i lolos aleng tin, ni ixo epovo na ke xepe i. ");
INSERT INTO mmx_vpl VALUES ("PS15_5","020_15_5","PSA","15","5","5","Im taba levendinau, ketla kopmen dina porang i mi luunun i volo. Ixo epovo do tara na un i mi tevempilas kusu na vaxaru taradi manmanton at tavapaase. Laradi i mumu asu na leveloklok, lixitkis teren naba nemen matmatkun. ");
INSERT INTO mmx_vpl VALUES ("PS16_1","020_16_1","PSA","16","1","1","O Moroa, una lok see rak, a nunu saga ram kusu una kubak pe ia basinge limixin munepen minia. ");
INSERT INTO mmx_vpl VALUES ("PS16_2","020_16_2","PSA","16","2","2","A tong i ri Leeme Silok, “Nenu Leeme Silok tarak. Levempanga nunuan axap tarak, nenia a ruuna i, nenu axa um taba ia min.” ");
INSERT INTO mmx_vpl VALUES ("PS16_3","020_16_3","PSA","16","3","3","Limixin tuturun at Leeme Silok, nedi limixin nunuan. Ak lok momo amisik ti nemen eburu midi. ");
INSERT INTO mmx_vpl VALUES ("PS16_4","020_16_4","PSA","16","4","4","Limixin dit pas uto at levenmoroa vetpes, dinaba ekip tangarang mi laxanmumuat solo. Nia noxo nemen eburu midi at levelaplavang atnedi. La nia noxo lotu saparap levenmoroa atnedi. ");
INSERT INTO mmx_vpl VALUES ("PS16_5","020_16_5","PSA","16","5","5","Leeme Silok, nenu mun tarak la kopmen tomoroa bok. Ang sang kobot mumu mun u, la kopmen bok ba tepanga vetpes nia anak pakes tin. Lorooro axap tarak i nemen at lukngam. ");
INSERT INTO mmx_vpl VALUES ("PS16_6","020_16_6","PSA","16","6","6","A ruuna ka leventamtaba nunuan mun taram la di lox avukat tinotno. ");
INSERT INTO mmx_vpl VALUES ("PS16_7","020_16_7","PSA","16","7","7","A emi asu mi Leeme Silok, atla neni im lam lorooro rak, la at leveng kanimin lodoxoma rak i anasa ia mi loklox avukat. ");
INSERT INTO mmx_vpl VALUES ("PS16_8","020_16_8","PSA","16","8","8","Nia a xasep amisik ti Leeme Silok i nemen to melamgo rak. Mi mo i tu saparap lakngak tino la kopmen tavanga noxo sev asubu ia. ");
INSERT INTO mmx_vpl VALUES ("PS16_9","020_16_9","PSA","16","9","9","Kuren la lorooro rak i umsu mi lomomo, la levelinga rak i paase asu mun lososoro. La kopmen tinotno nia na marat tangarang ka tepanga, ");
INSERT INTO mmx_vpl VALUES ("PS16_10","020_16_10","PSA","16","10","10","atla nenu u noxo raba rulu ia xusu anat pas uto at lemenemen at labarongan, la u noxo ke xepe Laradi Melemelengan taram la labantuxu ren napso. ");
INSERT INTO mmx_vpl VALUES ("PS16_11","020_16_11","PSA","16","11","11","Unaba lox ase ia mi langas it pas uto at loxot ti lorooro. Ut kis esogo minia, la a momo amisik. Uk lox aumsu ia mi lososoro mo naba nemen amisik la kopmen tekavaxap teren. ");
INSERT INTO mmx_vpl VALUES ("PS17_1","020_17_1","PSA","17","1","1","O Leeme Silok, una ronga lorotoro rak la una ru ria mi levelinga ruturun. Una ronga res at lerengteng tarak saparav u ri loklok tooro. Una ronga na lising tuturun tarak saparav u. ");
INSERT INTO mmx_vpl VALUES ("PS17_2","020_17_2","PSA","17","2","2","Nenu uklen leveloklok in manton, kuren la unaba ronga linga rak la unaba ru ria. ");
INSERT INTO mmx_vpl VALUES ("PS17_3","020_17_3","PSA","17","3","3","Uklen lorooro rak. Uga vot pasa ia at laxanimin la uga viila mumu axap lorooro rak, u goxo vuse kaka tibilinga rak. Nenia axo paase kapmek, ");
INSERT INTO mmx_vpl VALUES ("PS17_4","020_17_4","PSA","17","4","4","ngan leventaba vetpes di lox i. A mumu asu amisik levelinga ram, la kopmen ana mu asu langas at lemusak la leesep. ");
INSERT INTO mmx_vpl VALUES ("PS17_5","020_17_5","PSA","17","5","5","At pas amisik at langas taram, la kovisi nia ana vas aase ren. ");
INSERT INTO mmx_vpl VALUES ("PS17_6","020_17_6","PSA","17","6","6","O Moroa, a sing saparav u atla uk lox epovo levesingising tarak. Una xa roolong tia la una ronga levelinga rak. ");
INSERT INTO mmx_vpl VALUES ("PS17_7","020_17_7","PSA","17","7","7","Una lox asuusu nom labalamu avukat taram la una lox asepsu ia. Nia at kis esogo minu la kopmen nia ana marat at limixin munepen minia. ");
INSERT INTO mmx_vpl VALUES ("PS17_8","020_17_8","PSA","17","8","8","Una lok see rak ngan uk lok tatao luxatli ram. Una lipe ia at lamamau at luvapa ram, ");
INSERT INTO mmx_vpl VALUES ("PS17_9","020_17_9","PSA","17","9","9","kusu limixin kapmek di noxo sev asi ia. Limixin munepen minia di tu kangkan ia kusu dina sev amer ia. ");
INSERT INTO mmx_vpl VALUES ("PS17_10","020_17_10","PSA","17","10","10","Kopmen dina balamu leventaba vetpes. Dit las amisik di. ");
INSERT INTO mmx_vpl VALUES ("PS17_11","020_17_11","PSA","17","11","11","Nanga ding kan ia, at levengkot nia a tepukus taba ve, di mamat mu amisix ia kusu dina sev asubu ia. ");
INSERT INTO mmx_vpl VALUES ("PS17_12","020_17_12","PSA","17","12","12","Di lok ngan lubunglaion, di kuxut tangais ia, di vara i xusu dina lais koxorop axakalik labantuxu rak. ");
INSERT INTO mmx_vpl VALUES ("PS17_13","020_17_13","PSA","17","13","13","O Leeme Silok, ude u. Una esep tangarang limixin di munepen minia, la una sak tup midi. Una lox asepsu ia basinge limixin kapmek mi lavarise esep taram. ");
INSERT INTO mmx_vpl VALUES ("PS17_14","020_17_14","PSA","17","14","14","O Leeme Silok, una lox asepsu ia mi lolos taram basinge nedi limixin at na lorooro di ruuna ka levempanga axap nedi xa di vara i. Una lox asongot di mi levesongsongot nu ga gagas li i ridi, teventaba bok ti laxamdak mi laxaalik atdi, la teventaba naba volo bok ti luvuttubuno avolo atdi. ");
INSERT INTO mmx_vpl VALUES ("PS17_15","020_17_15","PSA","17","15","15","Ketla nia anaba ven lamaram atla nia goxo lok tibilinga. Dola ana aus, anaba umsu mi lososoro atla anaba nemen eburu minu. ");
INSERT INTO mmx_vpl VALUES ("PS18_1","020_18_1","PSA","18","1","1","O Leeme Silok. A vavara aleng tu! Nenu Lentupe ria. ");
INSERT INTO mmx_vpl VALUES ("PS18_2","020_18_2","PSA","18","2","2","Leeme Silok ik lok see rak basinge limixin munepen, atla neni Loogu Matmatkun tarak. Moroa rak, neni Lurutu See Pe rak, la keneng mun teren nia a nemen matmatkun. I tupe ia ngan Lenban. I tu tooro ia, la i kubak pe ia basinge limixin munepen minia. ");
INSERT INTO mmx_vpl VALUES ("PS18_3","020_18_3","PSA","18","3","3","A toro ri Leeme Silok, la i lox asepsu ia basinge limixin munepen minia. Leemi asu ri Leeme Silok! ");
INSERT INTO mmx_vpl VALUES ("PS18_4","020_18_4","PSA","18","4","4","Loxoxo uu ga suxuna ia ngan ta lovo paxanao sesele utut ga vuulus labaaxin tarak. ");
INSERT INTO mmx_vpl VALUES ("PS18_5","020_18_5","PSA","18","5","5","Loxoxo uu ga suxuna ia ngan ta loos ga itis ia. Lamaaut ga lok do na xonom ia. ");
INSERT INTO mmx_vpl VALUES ("PS18_6","020_18_6","PSA","18","6","6","At lumumuat keneng at lorooro rak, aga ro ke at Leeme Silok. Aga ro ke at ne Moroa rak ti loklok tooro ro xeneng at loogu laplavang teren la ni ga ronga laxaka rak. La ga ronga bok lerengteng tarak ti loklok tooro basinge limixin munepen minia. ");
INSERT INTO mmx_vpl VALUES ("PS18_7","020_18_7","PSA","18","7","7","La ne Moroa ga musak di la ga lox angne lavatkangka la lempar abuxumkun at lempatkaana gang nengne. ");
INSERT INTO mmx_vpl VALUES ("PS18_8","020_18_8","PSA","18","8","8","Lusuxa ga ravasu at lisna ren la langangao at laxao bokbolot tintin asonao vanga eburu mi laxali kao bokbolot ga ravasu at lungusno. ");
INSERT INTO mmx_vpl VALUES ("PS18_9","020_18_9","PSA","18","9","9","Ni ga vaxat kuang laxalibet la ni ga vas si ude xopok, mi loxontakabu bibi maxopok at luxangkedek teren. ");
INSERT INTO mmx_vpl VALUES ("PS18_10","020_18_10","PSA","18","10","10","Ni ga xis pana at lavanga raptava ren (cherubim) la ga rava si soso min ude xopok ngan lamanman silok. ");
INSERT INTO mmx_vpl VALUES ("PS18_11","020_18_11","PSA","18","11","11","Ni ga xua pe i mi lubuxumin. Lengkon takabu lolos ga umsu mi laxadan gak lok kangkan i. ");
INSERT INTO mmx_vpl VALUES ("PS18_12","020_18_12","PSA","18","12","12","Laxampengkos uat gan bun aleng ga subu la laxao mi lavanga ga mam gamgomgo rin, la ga soosoo das su at loxon takabu bibi. ");
INSERT INTO mmx_vpl VALUES ("PS18_13","020_18_13","PSA","18","13","13","To vana at laxalibet, Leeme Silok gap kup butbutki ngan lerepaavat. La limixin axap diga ronga laxaka at Leeme Avolo. ");
INSERT INTO mmx_vpl VALUES ("PS18_14","020_18_14","PSA","18","14","14","Ni ga so limixin munepen mi laxasoso ren, la diga oo epeseves, la diga sixiro basinge laxasep at lavanga ga mam etitit. ");
INSERT INTO mmx_vpl VALUES ("PS18_15","020_18_15","PSA","18","15","15","To maxopok at lebelen laras gamdi saxaven, la lavara buxumkun at lavatkangka bok gamdi saxaven, at loxonaleng nu Leeme Silok uga musak limixin munepen minu, la uga vaase lolos aleng tidi. ");
INSERT INTO mmx_vpl VALUES ("PS18_16","020_18_16","PSA","18","16","16","Leeme Silok ga song asi boroxun pana la ga rebeng tu rak. La ni ga rev asu ka ia boro xeneng at lamaxat. ");
INSERT INTO mmx_vpl VALUES ("PS18_17","020_18_17","PSA","18","17","17","Ni ga lox asepsu ia basinge limixin lolos diga munepen minia, la basinge bok di, di belengatngas tia. Nedi diga lolos polo ia. ");
INSERT INTO mmx_vpl VALUES ("PS18_18","020_18_18","PSA","18","18","18","Nia ga nemen keneng at lumumuat, diga esep minia, ketla Leeme Silok ga lok see rak. ");
INSERT INTO mmx_vpl VALUES ("PS18_19","020_18_19","PSA","18","19","19","Ni ga lok tooro ia basinge laniu, la ga lox asepsu ia atla ni ga lok momo minia. ");
INSERT INTO mmx_vpl VALUES ("PS18_20","020_18_20","PSA","18","20","20","Leeme Silok im taba ia mi luunun atla nia laradi manmanton la ni ik lox anarong ia atla nia laradi sepsen. ");
INSERT INTO mmx_vpl VALUES ("PS18_21","020_18_21","PSA","18","21","21","Agara mumu asu Laulis Linga at Leeme Silok. A goxo raba sinta ne Moroa rak. ");
INSERT INTO mmx_vpl VALUES ("PS18_22","020_18_22","PSA","18","22","22","Agara mumu asu amisik leventaangas axap teren. Nia goxo ronga xepe at levempapaase ali ren. ");
INSERT INTO mmx_vpl VALUES ("PS18_23","020_18_23","PSA","18","23","23","Iklen i do kopmen tibilinga rak, la aga lok tatao avukar axa ia la nia goxo lok taxakapmek. ");
INSERT INTO mmx_vpl VALUES ("PS18_24","020_18_24","PSA","18","24","24","Kuren la im taba ia mi luunun atla nia aga lok mun leveloklok manmanton la iklen i do nenia laradi sepsen. ");
INSERT INTO mmx_vpl VALUES ("PS18_25","020_18_25","PSA","18","25","25","O Leeme Silok, nenu u ruturun tinedi di ruturun saparav u. La uk lox avukat tinotno rinedi din manton tino. ");
INSERT INTO mmx_vpl VALUES ("PS18_26","020_18_26","PSA","18","26","26","La uk lok lempanga i dadat tinedi loklok atdi i dadat. Ketla do tentaba dik lok laxakapmek, nenu u lok ngan laradi munepen midi. ");
INSERT INTO mmx_vpl VALUES ("PS18_27","020_18_27","PSA","18","27","27","Uk lox asepsu nedi di lox asi di ukopok, la uk lox asi nedi dim simi aurut di. ");
INSERT INTO mmx_vpl VALUES ("PS18_28","020_18_28","PSA","18","28","28","O Leeme Silok, um taba ia mi laxasep, la uk lok kepe ia basinge loklok at lamain. ");
INSERT INTO mmx_vpl VALUES ("PS18_29","020_18_29","PSA","18","29","29","Um taba box ia mi lolos ti vesep mi limixin munepen minia, la lolos tip sev asi di. ");
INSERT INTO mmx_vpl VALUES ("PS18_30","020_18_30","PSA","18","30","30","Na ne Moroa, loklok teren in manton tino. Dola ni na xaape mi tavanga, ni naba lox i. La neni Lenban tinedi di vot pasa i xusu na lok see atdi. ");
INSERT INTO mmx_vpl VALUES ("PS18_31","020_18_31","PSA","18","31","31","Leeme Silok, neni xusuk ne Moroa. Moroa xusuk i lok ngan Lentupe ridik. ");
INSERT INTO mmx_vpl VALUES ("PS18_32","020_18_32","PSA","18","32","32","Neni mun ne Moroa ik lox alolos ia, la neni mun ik lok tatao lavatpas tarak. ");
INSERT INTO mmx_vpl VALUES ("PS18_33","020_18_33","PSA","18","33","33","Neni mun i su auru ia at lavatpas tarak ngan lavanga mi lavanuet kangkedek it pas matmatkun. Ik lok tatao box ia rovana at lempatkaana. ");
INSERT INTO mmx_vpl VALUES ("PS18_34","020_18_34","PSA","18","34","34","Ik lox ase ia ri vesep, kusu anaba soso avukat mi lososo lolos. ");
INSERT INTO mmx_vpl VALUES ("PS18_35","020_18_35","PSA","18","35","35","O Leeme Silok, uk lok see rak la uk lox asepsu ia. Loklok tooro ram ira lox asilok pam ia, la lolos bok taram ga kubak pe ia basinge limixin munepen minia. ");
INSERT INTO mmx_vpl VALUES ("PS18_36","020_18_36","PSA","18","36","36","Ugak lok tatao avukar ia basinge di la di goxo xoxo ka ia. La nia goxo subu bok. ");
INSERT INTO mmx_vpl VALUES ("PS18_37","020_18_37","PSA","18","37","37","Nia ga xala limixin munepen la aga rebeng alis kaka di. Nia goxo lok mamas se aga sev amet axap di. ");
INSERT INTO mmx_vpl VALUES ("PS18_38","020_18_38","PSA","18","38","38","Aga bobo amet di, la digoxo epovo na xatu kaxar amlong. Digak midi etaba ro melamgo rak. ");
INSERT INTO mmx_vpl VALUES ("PS18_39","020_18_39","PSA","18","39","39","Uga raba ia mi lolos ti nom leesep, la nia aga sak tup mi limixin diga munepen minia. ");
INSERT INTO mmx_vpl VALUES ("PS18_40","020_18_40","PSA","18","40","40","Uga lox aoo limixin munepen minia la diga sixiro rak. Agap sep kakapmek tino nedi diga belengatngas tia. ");
INSERT INTO mmx_vpl VALUES ("PS18_41","020_18_41","PSA","18","41","41","Digang teng ti loklok tooro, ketla tara goxo lox asepsu di. Diga toro ri Leeme Silok, ketla ni goxo ronga res atdi. ");
INSERT INTO mmx_vpl VALUES ("PS18_42","020_18_42","PSA","18","42","42","Aga long povorok tino di la di lok ngan ta lakbus kao no lamanman it mas kepe i. Aga vas asi di, ngan ta at pas at lapke ro at langas. ");
INSERT INTO mmx_vpl VALUES ("PS18_43","020_18_43","PSA","18","43","43","Uga lox asepsu ia basinge limixin tongtonga xepe la uga lox asilox ia ngan loorong at levenabung mixin axap. Limixin nia goxoklen di, nanga nia am gomgonga di. ");
INSERT INTO mmx_vpl VALUES ("PS18_44","020_18_44","PSA","18","44","44","Limixin boro xadiong dit kis tintiding mi levempatgulom atnedi saparav ia. Dola di ronga ia, di ronga res at levelinga rak. ");
INSERT INTO mmx_vpl VALUES ("PS18_45","020_18_45","PSA","18","45","45","Dixo abelemes bok ba, la di dede aleng, mo do di on basinge laraogu matmatkun atdi. ");
INSERT INTO mmx_vpl VALUES ("PS18_46","020_18_46","PSA","18","46","46","Leeme Silok ni Luntoo Avolo rak. A emi asu min, ni Lentupe ria. Ana tong asu i ri limixin do ne Moroa i silok aleng la ik lox asepsu ia basinge limixin munepen minia. ");
INSERT INTO mmx_vpl VALUES ("PS18_47","020_18_47","PSA","18","47","47","Im taba ia mi lolos ti sak tup mi limixin munepen minia, la i tupe ia at limixin kapmek. La neni mun ik lox asi at larabung mixin axap kusu diba nemen maxopok tarak, ");
INSERT INTO mmx_vpl VALUES ("PS18_48","020_18_48","PSA","18","48","48","la ik lox asepsu ia basinge limixin munepen minia. O Leeme Silok, u raba vam ia mi lolos kusu ti sak tup mi limixin munepen minia, la u lok see rak kusu limixin sepsep di noxo sev asi ia. ");
INSERT INTO mmx_vpl VALUES ("PS18_49","020_18_49","PSA","18","49","49","Ni lavasuun teren la nia ana emi asu minu kantubu at limixin at levenabung mixin petpes. Anak pixan emi asu mi laasen taram. ");
INSERT INTO mmx_vpl VALUES ("PS18_50","020_18_50","PSA","18","50","50","Moroa im taba lolos silok ti loorong teren kusu nak sak tup mi limixin munepen min. Ik lox asuusu labalamu lexen teren ti no lara neni xa ga soxolik kaka i, ti ne Devit la ri luvuttubuno avolo umelemu. ");
INSERT INTO mmx_vpl VALUES ("PS19_1","020_19_1","PSA","19","1","1","Laxalibet ik lox asuusu lisisixam at ne Moroa. La levempanga axap go ik lox asuusu lugugu silok neni ga lox i. ");
INSERT INTO mmx_vpl VALUES ("PS19_2","020_19_2","PSA","19","2","2","At levenaleng kangking axap mo levempanga dik lox asuusu i. La levenaleng kanimin axap bok, dik lox asuusu i. ");
INSERT INTO mmx_vpl VALUES ("PS19_3","020_19_3","PSA","19","3","3","Kopmen dina vaase asu tevelinga la kopmen bok ata ronga asu i. ");
INSERT INTO mmx_vpl VALUES ("PS19_4","020_19_4","PSA","19","4","4","Levempapaase atdi i ravasu ri limixin at lavatbung menemen axap. La levelinga atdi it pas ti latnese at na lavatkangka. Moroa ga lok loxot kitkis to vana at lamavangkap ti laxangking. ");
INSERT INTO mmx_vpl VALUES ("PS19_5","020_19_5","PSA","19","5","5","Ip tavasu maxantamak suubu ngan laradi i epot maxat la i lok momo ri vas su, i ngan bok laradi lolos i lok momo ti sixit at lekampoovo. ");
INSERT INTO mmx_vpl VALUES ("PS19_6","020_19_6","PSA","19","6","6","Laxangking i ravasu ro at lenep kavaxap at lavatbung menemen la ik sixit korop uto at lara lenep kavaxap bok. Kopmen tempanga i epovo na lipe basinge liplivi ren. ");
INSERT INTO mmx_vpl VALUES ("PS19_7","020_19_7","PSA","19","7","7","Laulis Linga at Leeme Silok ik mokso axap. Im taba lolos maxat ti limixin di mu asu i. Levempapaase ali at Leeme Silok, i epovo do dik ata nunu saga ren. La im taba lodoxoma avukat tinedi xopmen todoxoma avukat atnedi. ");
INSERT INTO mmx_vpl VALUES ("PS19_8","020_19_8","PSA","19","8","8","Laulis Linga at Leeme Silok ik mokso aleng, la nedi di mumu asu i di momo. Levempapaase ali at ne Moroa i nunuan, la im taba lodoxoma avukat ti limixin. ");
INSERT INTO mmx_vpl VALUES ("PS19_9","020_19_9","PSA","19","9","9","I lox avukat do laradi na lok ngangao at Leeme Silok, la limixin dinaba lok ngangao epasum amisik. Levelinga loklox akmokso at Leeme Silok in manton la i lox avukat amisik. ");
INSERT INTO mmx_vpl VALUES ("PS19_10","020_19_10","PSA","19","10","10","I lox avukat do limixin dina vara aleng i polo logol. La i so avukat tino ri limisiu. ");
INSERT INTO mmx_vpl VALUES ("PS19_11","020_19_11","PSA","19","11","11","Leeme Silok, leventaangas taram im taba ia mi lakleklen, nia lasaxaruki ram. Anabak lok kaka luunun teren, mo do nia ana mumu asu levelinga ram. ");
INSERT INTO mmx_vpl VALUES ("PS19_12","020_19_12","PSA","19","12","12","Leeme Silok, kopmen tara i epovo xusu ni na ven lenget ka axa libilinga ren, kuren la una doxoma xepe mo libilinga nia xopmen na xasep teren. ");
INSERT INTO mmx_vpl VALUES ("PS19_13","020_19_13","PSA","19","13","13","Una lok tooro ia xusu nia noxo lok laxapmek ua nenia a vara i. Nemen uta ke xepe i na sak pavaa ia xusu nia anaban manton la anaba sepmus basinge lolos at libilinga. ");
INSERT INTO mmx_vpl VALUES ("PS19_14","020_19_14","PSA","19","14","14","Nia a vara i do levempapaase rak mi lodoxoma rak nan manton at lamaram. O Leeme Silok, nenu Loxot Loklox Alipe rak, la nenu Lentu Korop Pe rak. ");
INSERT INTO mmx_vpl VALUES ("PS20_1","020_20_1","PSA","20","1","1","Ma sing Leeme Silok, ni ne Moroa at ne Jakop, do ni naba ronga ram dola una ekip tangarang mi lumumuat, la naba lok see ram! ");
INSERT INTO mmx_vpl VALUES ("PS20_2","020_20_2","PSA","20","2","2","Ma sing box i do loklok tooro ru naba laa boro xeneng at loogu laplavang teren, la loklok tooro bok tu naba vot boro Saion at lakaana ren. ");
INSERT INTO mmx_vpl VALUES ("PS20_3","020_20_3","PSA","20","3","3","Ma sing box i do ni naba siam ka ampana letaba ram, la ni naba momo rino bok mi levelaplavang taram. ");
INSERT INTO mmx_vpl VALUES ("PS20_4","020_20_4","PSA","20","4","4","Ma sing box i do ni naba raba box u mi lempanga ung kongkat tin, la ni naba lox asoxos levendoxoma gagas taram. ");
INSERT INTO mmx_vpl VALUES ("PS20_5","020_20_5","PSA","20","5","5","Do Leeme Silok na lox epovo na levesingising la una sak tup mi limixin munepen minu, manabap kup mi lomomo, la manaba lok katling i mi leemi asu ri ne Moroa. Ma sing Leeme Silok naba lox asoxos axap levesingising taram. ");
INSERT INTO mmx_vpl VALUES ("PS20_6","020_20_6","PSA","20","6","6","Na nia aklen i do Leeme Silok im taba lolos ti loorong soksoxolik teren kusu ti sak tup mi limixin munepen min. Neni i paase porang levelinga ro at loxot melemelengan teren keneng at lebelen laxalibet at ne Moroa. At lolos axa ren neni im taba i mi lolos avolo aleng ti sev asi limixin munepen. ");
INSERT INTO mmx_vpl VALUES ("PS20_7","020_20_7","PSA","20","7","7","Leventaba di nunu saga at leveng karis esep atnedi, la leventaba di nunu saga laxanos atdi. Ketla nedik ta nunu saga at lolos at Leeme Silok, ni ne Moroa atdik. ");
INSERT INTO mmx_vpl VALUES ("PS20_8","020_20_8","PSA","20","8","8","Limixin kerepmo dinaba vas kais la dina subu, ketla nedik tanaba xatu upana la manaba tu tuxuruxun. ");
INSERT INTO mmx_vpl VALUES ("PS20_9","020_20_9","PSA","20","9","9","O Leeme Silok, una raba lolos ti loorong kusu na sak tup mi limixin munepen min. La una ronga atnema do mana toro ke ram. ");
INSERT INTO mmx_vpl VALUES ("PS21_1","020_21_1","PSA","21","1","1","O Leeme Silok. Loorong i lok momo, atla nenu ugam taba i mi lolos. I sosoro atla nenu ugam taba i mi lolos tik sak tup mi limixin munepen min. ");
INSERT INTO mmx_vpl VALUES ("PS21_2","020_21_2","PSA","21","2","2","Uga raba vam i mi levempanga axap lebelen ga tu i. Uga raba box i mi mo lavanga neni ga ngising tin. ");
INSERT INTO mmx_vpl VALUES ("PS21_3","020_21_3","PSA","21","3","3","Uga raba i mi leveloklox anarong silok, la ugara vaxasiga i mi lavatbungorong gol at lavatlak teren. ");
INSERT INTO mmx_vpl VALUES ("PS21_4","020_21_4","PSA","21","4","4","Ni ga sing u ri lorooro, la nu ga raba vam i min, lorooro abao naba baalom aleng. ");
INSERT INTO mmx_vpl VALUES ("PS21_5","020_21_5","PSA","21","5","5","Lisisilok teren i volo, atla nenu uk lok tooro i. Laasen silok mi lisisinang teren, nenu xa uga raba i min. ");
INSERT INTO mmx_vpl VALUES ("PS21_6","020_21_6","PSA","21","6","6","Um taba amisix i mi leveloklox anarong, la ik lok momo atla ut kis esogo amisik min. ");
INSERT INTO mmx_vpl VALUES ("PS21_7","020_21_7","PSA","21","7","7","Loorong i nunu saga at Leeme Silok, ni Lanaraavuk. Nom labalamu lexen at Leeme Silok naba tu amisik, kuren la lixitkis orong teren nabak lox amisik. ");
INSERT INTO mmx_vpl VALUES ("PS21_8","020_21_8","PSA","21","8","8","Loorong naba xoxo alis ka limixin axap di munepen min, la ni naba xoxo alis axap nedi di belengatngas tin. ");
INSERT INTO mmx_vpl VALUES ("PS21_9","020_21_9","PSA","21","9","9","La ni naba sele utut kepe axap di ngan laxao, imsum at laxairing, dola ni na ru asuvos. Leeme Silok naba lox asi axap di mi lebelemamao ren, la laxao naba rin asonao di. ");
INSERT INTO mmx_vpl VALUES ("PS21_10","020_21_10","PSA","21","10","10","La kopmen tara at livipisik li atnedi noxo sepsu at lanmet. Loorong naba sep kepe axap di. ");
INSERT INTO mmx_vpl VALUES ("PS21_11","020_21_11","PSA","21","11","11","Di epaase li la di sevut li leventaangas kusu dinaba lok kapmek loorong, ketla di noxo lox epovo i. ");
INSERT INTO mmx_vpl VALUES ("PS21_12","020_21_12","PSA","21","12","12","Ni naba xala di mi levesoso ren, la dinaba repukus la dinaba sixiro. ");
INSERT INTO mmx_vpl VALUES ("PS21_13","020_21_13","PSA","21","13","13","Leeme Silok, ma emi asu minu, ti mo langsangan lolos taram! Manabak pixan la mana emi asu mi leveloklok taram i lolos aleng. ");
INSERT INTO mmx_vpl VALUES ("PS22_1","020_22_1","PSA","22","1","1","Moroa rak, Moroa rak, tila u raba rulu ia? Arang teng pupuse aleng ti loklok tooro ram, ketla uxo lok tooro ia. ");
INSERT INTO mmx_vpl VALUES ("PS22_2","020_22_2","PSA","22","2","2","Moroa rak, a toro ru at laxanaleng kangking, la uxo vorang lisingising tarak. La at levengkanimin bok a toro ru, ketla uxok lox amamana labalak. ");
INSERT INTO mmx_vpl VALUES ("PS22_3","020_22_3","PSA","22","3","3","Ketla nenu ut kis at loxonin orong taram ngan Laradi Melemelengan. Nenu mun limixin me Israel di emi asu minu. ");
INSERT INTO mmx_vpl VALUES ("PS22_4","020_22_4","PSA","22","4","4","Lavalabat atnema diga nunu saga ram. Diga nunu at levelinga ram, la uga lox asepsu di. ");
INSERT INTO mmx_vpl VALUES ("PS22_5","020_22_5","PSA","22","5","5","Diga ro ke ram la di goxo ekip tangarang mi levenaniu. Diga nunu saga ram la uga lox epovo levendoxoma atdi. ");
INSERT INTO mmx_vpl VALUES ("PS22_6","020_22_6","PSA","22","6","6","Ketla nia xopmen bok ba ana ngan laradi, a lok ngan ta laxalon. Limixin axap di lele abulubun ia! ");
INSERT INTO mmx_vpl VALUES ("PS22_7","020_22_7","PSA","22","7","7","Limixin di ven ia, la di paase aksaksa ria. Dim lem gam tia la dira piripat patlak. ");
INSERT INTO mmx_vpl VALUES ("PS22_8","020_22_8","PSA","22","8","8","Dik lok tia xeretna, “Nenu ga nunu saga at Leeme Silok, tila neni xopmen na mulus ti lox asepsu u? Dola Leeme Silok i vavara ru, tila ni xopmen na lok tooro u?” ");
INSERT INTO mmx_vpl VALUES ("PS22_9","020_22_9","PSA","22","9","9","Nenu mene, ne Moroa, uga lox asu avukar ia at lebelen ne naga at laaleng pipisik tarak. Nenia nove aga xadede, uga lok tatao avukar ia. ");
INSERT INTO mmx_vpl VALUES ("PS22_10","020_22_10","PSA","22","10","10","Agam doma saga ram, ga ru xaka i at laaleng ne naga ga visix ia ren, la at levenaleng axap tarak, nenu mun ne Moroa rak. ");
INSERT INTO mmx_vpl VALUES ("PS22_11","020_22_11","PSA","22","11","11","Nemen uta nemen paxalom basinge ia! Levenmumuat mo i auret, la kopmen tara ri lok tooro ia. ");
INSERT INTO mmx_vpl VALUES ("PS22_12","020_22_12","PSA","22","12","12","Limixin solo di munepen minia, la di tu xangkan ia ngan ta laxanbulumaxao temes, ngan ta laxanbulumaxao mukmusak boro Basan. ");
INSERT INTO mmx_vpl VALUES ("PS22_13","020_22_13","PSA","22","13","13","Di vavangangba la di booro ngan ta lubunglaion, di gagas ti atat lalais ka ia ngan levempanga anan. ");
INSERT INTO mmx_vpl VALUES ("PS22_14","020_22_14","PSA","22","14","14","Lolos tarak ira xap pam, i xap ngan laxadan i soli su ri laxangka. Levennin etudum at levesi rak ira rem kida vam. Labalak i umsu mi lainmarat i silok aleng. ");
INSERT INTO mmx_vpl VALUES ("PS22_15","020_22_15","PSA","22","15","15","Luxukung tarak ira vatmang axap ngan laxakup, la lagam tarak i xis pe langsuk. Nenu xa u ke xepe ia la ak midi ro at laxangka xusu ana met. ");
INSERT INTO mmx_vpl VALUES ("PS22_16","020_22_16","PSA","22","16","16","Libinam tadi at limixin kakapmek nanga di ru xangkan pam ia. Di lok ngan ta lubung man di xala sa rak, di atat lais koxorop luxangkedek tarak mi lukngak. ");
INSERT INTO mmx_vpl VALUES ("PS22_17","020_22_17","PSA","22","17","17","Ara gelegen axap. Limixin munepen minia di reven tooro ia la di paase aksaksa ria. ");
INSERT INTO mmx_vpl VALUES ("PS22_18","020_22_18","PSA","22","18","18","Diga lu buru mi lengkon uat kusu ti lok kisip ka nege ba lok ka levempanga singsiga rak. ");
INSERT INTO mmx_vpl VALUES ("PS22_19","020_22_19","PSA","22","19","19","O Leeme Silok, nemen uta on basinge ia! Ude, una lox asepsu soso mun ia! ");
INSERT INTO mmx_vpl VALUES ("PS22_20","020_22_20","PSA","22","20","20","Lox asepsu ia basinge lemparise at limixin esep. Lox asepsu ia basinge na lubung man. ");
INSERT INTO mmx_vpl VALUES ("PS22_21","020_22_21","PSA","22","21","21","Lox asepsu ia basinge na lubunglaion. Axo epovo kusu ti sixiro basinge na laxanbulumaxao sio. ");
INSERT INTO mmx_vpl VALUES ("PS22_22","020_22_22","PSA","22","22","22","Nenia anaba tong asu laasen taram ti luvutnetak. Anaba emi asu minu ro at lovotpot buru atnedi. ");
INSERT INTO mmx_vpl VALUES ("PS22_23","020_22_23","PSA","22","23","23","Nemi livisik li at ne Jakop me Israel, mi lok ngan lavasaxaruki at Leeme Silok, mina vemi asu amisik min. Mina raba asinorong i la mina lotu saparap amisix i! ");
INSERT INTO mmx_vpl VALUES ("PS22_24","020_22_24","PSA","22","24","24","Leeme Silok ixo raba sinta limixin baava dip kip levesongsongot. La ixo raba rulu bok di, ketla ing tonga di do di toro ri loklok tooro. ");
INSERT INTO mmx_vpl VALUES ("PS22_25","020_22_25","PSA","22","25","25","Anaba emi asu mi laasen taram to at lovotpot buru silok, ti levempanga ugara lok pam i. Anaba tu ro melamgo atnedi di lotu saparav u la anabaplavang tu mi levempanga nia aga xaape min. ");
INSERT INTO mmx_vpl VALUES ("PS22_26","020_22_26","PSA","22","26","26","Limixin banbalo dinaba an mais at leveluxa di vavara rin. Nedi di repukus taba Leeme Silok, dinaba emi asu min. A sing ne Moroa na lox anarong di xusu dina ngasang kobot amisik at levenaleng axap i tu melamgo! ");
INSERT INTO mmx_vpl VALUES ("PS22_27","020_22_27","PSA","22","27","27","Limixin boro at larabung mixin axap dinabam domasu amisik at Leeme Silok. Boro at lengkot axap at lavatbung menemen, dinaba repukus taba i, la levenasen bantuxu axap dinaba lotu saparav i. ");
INSERT INTO mmx_vpl VALUES ("PS22_28","020_22_28","PSA","22","28","28","Leeme Silok neni Loorong Silok mavana at limixin axap. La neni im gomgonga limixin at levenabung mixin axap. ");
INSERT INTO mmx_vpl VALUES ("PS22_29","020_22_29","PSA","22","29","29","Limixin dit las nedi, dinaba xis tiktikbu saparav i. Limixin at lavatbung menemen axap dinaba xis tiktikbu saparav i. ");
INSERT INTO mmx_vpl VALUES ("PS22_30","020_22_30","PSA","22","30","30","Lavaola melemu dinaba gugu taba amisix i. Limixin dinaba tere avolo na loklok at Leeme Silok ti lavaola mo dinabat pot melemu. ");
INSERT INTO mmx_vpl VALUES ("PS22_31","020_22_31","PSA","22","31","31","Limixin kovisi dina visik nedi, dinabaklen i do, “Leeme Silok ga lox asepsu limixin teren basinge limixin munepen midi.” ");
INSERT INTO mmx_vpl VALUES ("PS23_1","020_23_1","PSA","23","1","1","Leeme Silok, ni laradi ik lok tatao ia ngan laradi ik lok tatao levesipsip teren. Kuren la a ruuna ka axap levempanga ak pakes tin. ");
INSERT INTO mmx_vpl VALUES ("PS23_2","020_23_2","PSA","23","2","2","I lox amdi ia ro at lenep kangka i ruuna levempivilis avukat kusu ana lok mamana ren, la i lam kaka box ia uto at laradan i sesen atnaasan kusu ana inin. ");
INSERT INTO mmx_vpl VALUES ("PS23_3","020_23_3","PSA","23","3","3","Neni im taba ia mi lolos maxat. La im lam ase ia keneng at larangas mokmokso, ngan ni gara vaase ali vam i. ");
INSERT INTO mmx_vpl VALUES ("PS23_4","020_23_4","PSA","23","4","4","Keke i do ana vas beles keneng at langsangan lamain bonot, nia noxo marat. Leeme Silok, u nemen eburu amisik minia, luvuukup mi lakdak taram ik lox amenemen amisix ia. ");
INSERT INTO mmx_vpl VALUES ("PS23_5","020_23_5","PSA","23","5","5","U lok gagas li leluxa silok tia, kuren la limixin munepen minia, dinaba ven ia, dola una seega rangarang ia ngan laradi silok. La unantu aumsu aleng lavanga inin tarak. ");
INSERT INTO mmx_vpl VALUES ("PS23_6","020_23_6","PSA","23","6","6","Aklen i do loklok nunuan mi labalamu ram naba kuxun amisik keneng at lorooro axap tarak, la loogu ram naba lok ngan loogu aulis tarak at levenaleng axap nia anaba rooro ren. ");
INSERT INTO mmx_vpl VALUES ("PS24_1","020_24_1","PSA","24","1","1","Lavatbung menemen la levempanga axap di nemen keneng teren, ni at Leeme Silok. Lavatkangka mi levempanga axap di rooro, ateren mun. ");
INSERT INTO mmx_vpl VALUES ("PS24_2","020_24_2","PSA","24","2","2","At lurutu kaxat, neni ga lok li laxangka ro mavana at lamaxat. La ni ga lok li bok levenamkumkun to xa maxopok at lisimaramain. ");
INSERT INTO mmx_vpl VALUES ("PS24_3","020_24_3","PSA","24","3","3","Loklok atnege i lox avukat kusu neni ba epovo na vas urut uto vana at lakaana at Leeme Silok ti lotu saparav i? Loklok atnege i lox avukat kusu neni ba epovo na vubeles uto xeneng at loogu laplavang teren i xaala? ");
INSERT INTO mmx_vpl VALUES ("PS24_4","020_24_4","PSA","24","4","4","Nedi mene di dadat at loklok atnedi la lodoxoma atnedi, la kopmen dina lotu saparap laxampoovo moroa la kopmen dina tong asu leveng kakaape xaxarang. ");
INSERT INTO mmx_vpl VALUES ("PS24_5","020_24_5","PSA","24","5","5","Leeme Silok naba lox anarong di. Moroa ni Luntoo Avolo atdi la naba tong atkatla li i ridi do nedi limixin sepse. ");
INSERT INTO mmx_vpl VALUES ("PS24_6","020_24_6","PSA","24","6","6","Limixin kerepmo di ngaongao ri ne Moroa, la dit pas amisik ti lotu saparap ne Moroa at ne Jakop. ");
INSERT INTO mmx_vpl VALUES ("PS24_7","020_24_7","PSA","24","7","7","Mina suang soso mene lempatban at langas uat, mina suang axap lempatban diga lox i ganoxa kusu Loorong Silok na vubeles. ");
INSERT INTO mmx_vpl VALUES ("PS24_8","020_24_8","PSA","24","8","8","Nege na Loorong i silok solo? Ni Leeme Silok la Lanaraavuk. Lolos teren i volo la ik sak tup mi limixin munepen min at levenaleng at leesep. Neni Leeme Silok. ");
INSERT INTO mmx_vpl VALUES ("PS24_9","020_24_9","PSA","24","9","9","Mina suang soso mene lempatban at langas uat, mina suang axap lempatban diga lox i ganoxa, kusu Loorong Silok na vubeles. ");
INSERT INTO mmx_vpl VALUES ("PS24_10","020_24_10","PSA","24","10","10","Nege na Loorong i silok solo? Neni Leeme Silok, la Lanaraavuk. Neni Loorong Silok. ");
INSERT INTO mmx_vpl VALUES ("PS25_1","020_25_1","PSA","25","1","1","O Leeme Silok, a lok lisingising tu mi lorooro axap tarak. ");
INSERT INTO mmx_vpl VALUES ("PS25_2","020_25_2","PSA","25","2","2","O Moroa rak, a nunu mene ram. Una lok tooro ia kusu ana sak tup mi limixin munepen minia la nia anoxo ruuna ka lainmangan at leesep. Nemen uta ke xepe di xusu dina sev asubu ia la dina lok momo aksaksa ria. ");
INSERT INTO mmx_vpl VALUES ("PS25_3","020_25_3","PSA","25","3","3","Limixin di nunu saga ram, limixin munepen midi noxo epovo na sak tup minedi, ketla nedi mene ding tonga viribang at levelinga ram, dinaba subu at leesep. ");
INSERT INTO mmx_vpl VALUES ("PS25_4","020_25_4","PSA","25","4","4","O Leeme Silok, una anasa ia mi leventaangas taram. Una lox axasev i ria. ");
INSERT INTO mmx_vpl VALUES ("PS25_5","020_25_5","PSA","25","5","5","Una anasa ia xusu ana rooro mu asu levelinga ruturun taram, atla nenu ne Moroa rak, la uk lox asepsu ia. A nunu saga amisik taram. ");
INSERT INTO mmx_vpl VALUES ("PS25_6","020_25_6","PSA","25","6","6","O Leeme Silok, una doma amlong ti lebelemulus taram mi labalamu lexen taram, ugara lox asuusu vam i, ga ruka i ganoxa at lereot. ");
INSERT INTO mmx_vpl VALUES ("PS25_7","020_25_7","PSA","25","7","7","Una doxoma xepe axap leveng kakapmek la levesoogong tarak, aga lok pam i, ganoxa ga laau mun be ia. O Leeme Silok, una domasu rak mumu labalamu lexen taram mi loklox avukat! ");
INSERT INTO mmx_vpl VALUES ("PS25_8","020_25_8","PSA","25","8","8","Loklok at Leeme Silok in manton tino la i lox avukat. Kuren la i lox ase limixin kakapmek mi langas i epovo dina mumu asu i. ");
INSERT INTO mmx_vpl VALUES ("PS25_9","020_25_9","PSA","25","9","9","Nedi dik lox axakalik di, neni im gomgonga di at langas ik mokso. La i lox ase bok di mi lavavara ren. ");
INSERT INTO mmx_vpl VALUES ("PS25_10","020_25_10","PSA","25","10","10","Nedi di mumu asu lekabus teren eburu mi levempapaase ali ren, neni im gomgonga nedi mi loklok tuturun la labalamu. ");
INSERT INTO mmx_vpl VALUES ("PS25_11","020_25_11","PSA","25","11","11","Leeme Silok, una lox epovo laxakaape ram la kerepmo una doxoma xepe laxaloklok kakapmek axap tarak, atla a ruuna laxaloklok kakapmek solo. ");
INSERT INTO mmx_vpl VALUES ("PS25_12","020_25_12","PSA","25","12","12","Nedi ding tonga res at Leeme Silok, ni naba anasa di mi langas dina mumu asu i. ");
INSERT INTO mmx_vpl VALUES ("PS25_13","020_25_13","PSA","25","13","13","Limixin kerepmo dinaba ngasang kobot amisik la laxamdak mi laxaalik atnedi dinaba ruuna ka mo lenep kangka aulis atdi. ");
INSERT INTO mmx_vpl VALUES ("PS25_14","020_25_14","PSA","25","14","14","Leeme Silok neni lentangas atnedi ding tonga res teren, la neni i lox amuat levelinga at lekabus teren eburu minedi. ");
INSERT INTO mmx_vpl VALUES ("PS25_15","020_25_15","PSA","25","15","15","Am tem saga amisik ti Leeme Silok ti loklok tooro, la ik lox asepsu amisix ia basinge levenaniu. ");
INSERT INTO mmx_vpl VALUES ("PS25_16","020_25_16","PSA","25","16","16","O Leeme Silok, una doma amlong tia, la una lox asuusu lebelen tuntun tia, atla ak lok tuntun la kopmen tololos tarak. ");
INSERT INTO mmx_vpl VALUES ("PS25_17","020_25_17","PSA","25","17","17","Una lox asooloo ia basinge lodoxoma saasaa, la una lox asepsu ia at laxanmumuat tarak. ");
INSERT INTO mmx_vpl VALUES ("PS25_18","020_25_18","PSA","25","18","18","Una doma loklok tuntun mi laxaloklox asongot tarak, la una doxoma xepe laxangkakapmek axap tarak. ");
INSERT INTO mmx_vpl VALUES ("PS25_19","020_25_19","PSA","25","19","19","Una doma mumu i do buaang nedi limixin di munepen minia la di belengatngas tia. ");
INSERT INTO mmx_vpl VALUES ("PS25_20","020_25_20","PSA","25","20","20","Una lok see rak, la una lox asepsu ia, kusu limixin di munepen minia di noxo sak tup minia. A vot pasa u kusu una xubak pe ia basinge di. ");
INSERT INTO mmx_vpl VALUES ("PS25_21","020_25_21","PSA","25","21","21","Nia a sing u xusu unaba lok tatao amisix ia atla a nunu saga ram, la loklok tarak i nunuan la i ruturun. ");
INSERT INTO mmx_vpl VALUES ("PS25_22","020_25_22","PSA","25","22","22","O Moroa, una lox asepsu leme Israel basinge levenmumuat axap atdi. Una lox asepsu leme Israel, nedi limixin tinotno ram. ");
INSERT INTO mmx_vpl VALUES ("PS26_1","020_26_1","PSA","26","1","1","O Leeme Silok, una tong atkatla li i ria do, nenia laradi sepsen, atla nia a nunu saga mun taram la ak lox amisik levempanga ik mokso. ");
INSERT INTO mmx_vpl VALUES ("PS26_2","020_26_2","PSA","26","2","2","Una lok tong pen axap na lorooro rak, la una ven mumu avukar ia. La una viila mumu lavavara axap keneng at labalak eburu mi lodoxoma rak. ");
INSERT INTO mmx_vpl VALUES ("PS26_3","020_26_3","PSA","26","3","3","Una lox i na atla um gomgo ria mi labalamu lexen taram, la um lam amisix ia at lavatpas tarak la kopmen tinotno una ke aie xepe ia at tengkon aleng. ");
INSERT INTO mmx_vpl VALUES ("PS26_4","020_26_4","PSA","26","4","4","Nia xopmen ana vemu eburu mi luvuttadi ekarakat. Nia axot kis esogo mi luvuttadi sosolo arup. ");
INSERT INTO mmx_vpl VALUES ("PS26_5","020_26_5","PSA","26","5","5","Nia axo vesum mi limixin kakapmek, la a tu asepsu basinge di. ");
INSERT INTO mmx_vpl VALUES ("PS26_6","020_26_6","PSA","26","6","6","O Leeme Silok, na a gos lukngak ti lox asuusu i do nia laradi sepsen. La at pas emi asu kangkan loxonin laplavang taram. ");
INSERT INTO mmx_vpl VALUES ("PS26_7","020_26_7","PSA","26","7","7","A vixan loxompixan ti tong avukat tu la a tong asu levempanga nunuan ugak lox i. ");
INSERT INTO mmx_vpl VALUES ("PS26_8","020_26_8","PSA","26","8","8","O Leeme Silok. A vara rinotno na loogu laplavang, ua nenu u nemen teren. Ni na loxot lisisixam taram i nemen e. ");
INSERT INTO mmx_vpl VALUES ("PS26_9","020_26_9","PSA","26","9","9","Nemen uta sele utut kepe ia eburu mi limixin kapmek, la una ke ia basinge levenmumuat uba raba limixin sepsev amet min. ");
INSERT INTO mmx_vpl VALUES ("PS26_10","020_26_10","PSA","26","10","10","Nedi limixin dik lox amisik laxakapmek la di gagas amisik ti siam ka lempilas ti lox alolos lenngitngit atdi. ");
INSERT INTO mmx_vpl VALUES ("PS26_11","020_26_11","PSA","26","11","11","Ketla nenia, ak lox amisik leveloklok in manton. Una lox asuusu lebelen tuntun tia la una lox asepsu ia basinge di! ");
INSERT INTO mmx_vpl VALUES ("PS26_12","020_26_12","PSA","26","12","12","La xerepmo nia ana nemen avukat basinge levenaniu. La anaba emi asu mi Leeme Silok to at lovotpot buru at limixin teren. ");
INSERT INTO mmx_vpl VALUES ("PS27_1","020_27_1","PSA","27","1","1","Leeme Silok ni Laxasep la Laradi Loklox Asepsu rak. Nia anoxo marat tangarang ka teta. Leeme Silok neni Loogu Matmatkun tarak ti pe levenaniu. Kuren la nia noxo marat bok ba. ");
INSERT INTO mmx_vpl VALUES ("PS27_2","020_27_2","PSA","27","2","2","Dola limixin kakapmek dina esep tangarang minia xusu dina sev amer ia, dinaba sak kikixin la dinaba subu. ");
INSERT INTO mmx_vpl VALUES ("PS27_3","020_27_3","PSA","27","3","3","Keke i do buaang atnedi limixin esep dina ru xangkan ia, nenia noxo marat. Dola limixin munepen dina lox agagas do dina sev asi ia, nenia move anaba nunu saga at ne Moroa. ");
INSERT INTO mmx_vpl VALUES ("PS27_4","020_27_4","PSA","27","4","4","Nia ara sing pam Leeme Silok mi legesa vanga. Legesa vanga mene nia a vara rin, do at lorooro axap tarak ana nemen ia ro xeneng at loogu ren, la anaba pavanga at leveloklok nunuan teren la nia anaba ngising i kusu nam lam lorooro rak. ");
INSERT INTO mmx_vpl VALUES ("PS27_5","020_27_5","PSA","27","5","5","At levenaleng kakapmek neni naba lox alipe ia ro xeneng at loogu ren. Neni naba xubak pe ia ro xeneng at loogu laplavang, la ni naba vaxaxis aurur ia uto vana at langsangan luuat kis silok kusu anaba nemen matmatkun teren. ");
INSERT INTO mmx_vpl VALUES ("PS27_6","020_27_6","PSA","27","6","6","La kerepmo anaba sak tup mi limixin munepen minia do dina ru xangkan ia. Anabaplavang saparap Leeme Silok mi luxupkup momo ro xeneng at loogu laplavang teren. Anabak pixan, la ana emi asu min. ");
INSERT INTO mmx_vpl VALUES ("PS27_7","020_27_7","PSA","27","7","7","O Leeme Silok, una ronga ia, dola ana toro ru! Una lox asuusu lebelen tuntun tia la una siam mu ia! ");
INSERT INTO mmx_vpl VALUES ("PS27_8","020_27_8","PSA","27","8","8","Uga lok tia, “Ude u, una lotu saparav ia.” Aga vorang i do, “Leeme Silok, anaba vot pasa u.” ");
INSERT INTO mmx_vpl VALUES ("PS27_9","020_27_9","PSA","27","9","9","Kuren la nemen gat uta lipe rak! Nemen uta belemamao ia. Nemen uta musak kepe ia, lasaxaruki ram, atla nenu Laradi Loklok Tooro rak. Nemen uta on basinge ia! Nemen uta raba rulu ia atla nenu ne Moroa, Laradi Loklox Asepsu rak. ");
INSERT INTO mmx_vpl VALUES ("PS27_10","020_27_10","PSA","27","10","10","Keke i do ne tamak mi ne naga duna raba rulu ia, ketla nenu, Leeme Silok, unabak lok tatao ia. ");
INSERT INTO mmx_vpl VALUES ("PS27_11","020_27_11","PSA","27","11","11","O Leeme Silok, una lox ase ia mi langas sala u vara i do nia ana mumu asu i. La unam lam ia at langas nunuan, atla a ruuna buaang limixin munepen. ");
INSERT INTO mmx_vpl VALUES ("PS27_12","020_27_12","PSA","27","12","12","Nemen gat uta on taba rulu xepe ia ri levengkikngen limixin di munepen minia. Di xaxarang taba amisix ia, la di lok momo aleng ti vaaban ia. ");
INSERT INTO mmx_vpl VALUES ("PS27_13","020_27_13","PSA","27","13","13","Nia akleklen i do anaba ven luvukat at Leeme Silok at na lorooro. ");
INSERT INTO mmx_vpl VALUES ("PS27_14","020_27_14","PSA","27","14","14","Kuren la minam doma ngangais ti Leeme Silok, la mina lolos. Nemen gat mita doma abulubun kepe i, mina nunu saga at Leeme Silok. ");
INSERT INTO mmx_vpl VALUES ("PS28_1","020_28_1","PSA","28","1","1","O Leeme Silok, nenu Lentupe ria, na nia a ro ke ram! Una ronga lanteng tarak! Dola u noxo ronga ia, nenia anaba lok ngan nedi diba si uto xopok at lemenemen at labarongan. ");
INSERT INTO mmx_vpl VALUES ("PS28_2","020_28_2","PSA","28","2","2","Una ronga ia at loxonaleng nia anang teng saparav u ri loklok tooro, la at loxonaleng ana xip aurut lukngak ti loogu laplavang taram i xaala aleng. ");
INSERT INTO mmx_vpl VALUES ("PS28_3","020_28_3","PSA","28","3","3","Nemen gat uta lii lumumuat tarak at loxonaleng u vaase asi limixin kakapmek, la eburu minedi dik lok libilinga. Nedi limixin levelinga atnedi ik sixit nunuan, ketla lodoxoma atdi i umsu mi loklok kakapmek. ");
INSERT INTO mmx_vpl VALUES ("PS28_4","020_28_4","PSA","28","4","4","Una lox asongot nedi mumu leveloklok kakapmek atnedi eburu mi lempanga bilinga digara lok pam i. Una lox asongot nedi mumu xa leveloklok atnedi, la una raba bok nedi mi luunun i epovo at loklok atdi. ");
INSERT INTO mmx_vpl VALUES ("PS28_5","020_28_5","PSA","28","5","5","Kopmen dina ven kisip levempanga Leeme Silok gara lok pam i, kopla at levempanga neni ga rudum li i. Kuren la ni naba lox asongot di la naba sele utut kepe axap tino di. ");
INSERT INTO mmx_vpl VALUES ("PS28_6","020_28_6","PSA","28","6","6","Leemi asu ri Leeme Silok, atla ni ira ronga ka vam lanteng tarak ti loklok tooro. ");
INSERT INTO mmx_vpl VALUES ("PS28_7","020_28_7","PSA","28","7","7","Leeme Silok ik lok see rak, la i tupe ia. Labalak it kis saga ren, neni im taba ia mi loklok tooro, la ik lox amomo box ia. A tong avukat tin mi livikpixan momo. ");
INSERT INTO mmx_vpl VALUES ("PS28_8","020_28_8","PSA","28","8","8","Leeme Silok ik lok see at limixin teren la neni i lok ngan lenban tidi, la ik lox asepsu mo loorong ni ga soxolik ka i. ");
INSERT INTO mmx_vpl VALUES ("PS28_9","020_28_9","PSA","28","9","9","Leeme Silok, una lox asepsu limixin taram, la una lox anarong nedi limixin manmanton taram. Una nemen ngan laradi loklok tatao sipsip tinedi, la mo loklok tatao ram noxo xap. ");
INSERT INTO mmx_vpl VALUES ("PS29_1","020_29_1","PSA","29","1","1","Nemi limixin lolos toxun pana at laxalibet, mina emi asu mi Leeme Silok, mina emi asu min mumu lisisixam la lolos teren. ");
INSERT INTO mmx_vpl VALUES ("PS29_2","020_29_2","PSA","29","2","2","Mina emi asu mi laasen silok at Leeme Silok. Mina xis tintiding to melamgo at Laradi Melemelengan do ni na ru asuvos. ");
INSERT INTO mmx_vpl VALUES ("PS29_3","020_29_3","PSA","29","3","3","Limixin di ronga laxaka at Leeme Silok to at levengkot axap at laras la lagale lo Moroa silok ik lox asuusu leretepaavat. Laxaka at Leeme Silok i onon to mavana at laras aaxa. ");
INSERT INTO mmx_vpl VALUES ("PS29_4","020_29_4","PSA","29","4","4","Limixin di ronga i atla laxaka ren i silok la i lolos aleng. ");
INSERT INTO mmx_vpl VALUES ("PS29_5","020_29_5","PSA","29","5","5","Laxaka at Leeme Silok ik sak pirivit larauna Seda (Cedar), keke i do ni larauna i silok aleng to Lebanon. ");
INSERT INTO mmx_vpl VALUES ("PS29_6","020_29_6","PSA","29","6","6","Neni inglong angne larakaana ro Lebanon kusu dinat los ngan laxannatnat bulumaxao, la lakaana Emon nat los ngan lanat bulumaxao temes. ");
INSERT INTO mmx_vpl VALUES ("PS29_7","020_29_7","PSA","29","7","7","Laxaka at Leeme Silok ik lox asuusu lavanga i mam. ");
INSERT INTO mmx_vpl VALUES ("PS29_8","020_29_8","PSA","29","8","8","Laxaka ren i lox angne lamatbin, la ingnengne bok lamatbin to Kades. ");
INSERT INTO mmx_vpl VALUES ("PS29_9","020_29_9","PSA","29","9","9","Laxaka at Leeme Silok ingne larauna Ok la it mas kepe larapavaxan una, at loxonaleng limixin axap to xeneng at loogu laplavang teren dinabap kup silok keretna, “Leemi asu ri ne Moroa.” ");
INSERT INTO mmx_vpl VALUES ("PS29_10","020_29_10","PSA","29","10","10","Leeme Silok ni Loorong mavana at lisimaramain. Ni im gomgonga amisik limixin ngan Loorong Avolo la kopmen tekavaxap teren. ");
INSERT INTO mmx_vpl VALUES ("PS29_11","020_29_11","PSA","29","11","11","Leeme Silok im taba lolos limixin teren la ik lox anarong nedi mi limila. ");
INSERT INTO mmx_vpl VALUES ("PS30_1","020_30_1","PSA","30","1","1","Leeme Silok, nenia a emi asu minu, atla nu uga lox asepsu ia. La uga rupe limixin munepen minia di goxo lok momo aksaksa ria. ");
INSERT INTO mmx_vpl VALUES ("PS30_2","020_30_2","PSA","30","2","2","O Leeme Silok, nia agang teng saparav u ri loklok tooro. Nenu ne Moroa rak, la uga lox aroo ia basinge lanmeres. ");
INSERT INTO mmx_vpl VALUES ("PS30_3","020_30_3","PSA","30","3","3","La uga lox asepsu ia basinge lamaaut atla ga auret kusu ana met. Nia aga mumu langas uto xa xopok at lemenemen at labarongan, ketla nenu uga lox asepsu ia basinge lanmet. ");
INSERT INTO mmx_vpl VALUES ("PS30_4","020_30_4","PSA","30","4","4","Nemi luvuttadi ruturun teren, minak pixan emi asu ri Leeme Silok! Mina doma lempanga silok Laradi Melemelengan gara lok pam i, la mina tong loklox avukat tin. ");
INSERT INTO mmx_vpl VALUES ("PS30_5","020_30_5","PSA","30","5","5","Lumukmusak teren kopmen nak lox abao, ketla loklok nunuan teren i nemen at levenaleng axap at lorooro rak. Kuren la levengkamkabili dan ba sesen su at luxatli rak at laxanimin, ketla lomomo naba ravasu maxantamak suubu. ");
INSERT INTO mmx_vpl VALUES ("PS30_6","020_30_6","PSA","30","6","6","Nia aga nemen avukat, la aga doma i do, tepanga noxo sev asi ia. ");
INSERT INTO mmx_vpl VALUES ("PS30_7","020_30_7","PSA","30","7","7","Leeme Silok, ugak lok lempanga nunuan tia. Uga rupe ia ngan loogu matmatkun to at lempatkaana silok. Ketla melemu uga lox alipe manga rak la nia aga marat. ");
INSERT INTO mmx_vpl VALUES ("PS30_8","020_30_8","PSA","30","8","8","Leeme Silok, gano aga ro ke ram. Aga ngising aleng u ri loklok tooro keretna. ");
INSERT INTO mmx_vpl VALUES ("PS30_9","020_30_9","PSA","30","9","9","O Leeme Silok, uba ruuna ka lavanga salai at lanmet tarak? Luunun salai uba ruuna ka i do nia ana si uto at lamaaut? Kereva, i epovo limixin diga met pam dina emi asu minu? I epovo bok dina tong asu lebelen tuntun lexen taram? ");
INSERT INTO mmx_vpl VALUES ("PS30_10","020_30_10","PSA","30","10","10","Leeme Silok, una ronga ia, la una lox asuusu lebelen tuntun tia! Lok tooro ia, Leeme Silok! ");
INSERT INTO mmx_vpl VALUES ("PS30_11","020_30_11","PSA","30","11","11","Ketla monga lingina ura lok kun pam lanbulu rak mi liriti momo. Ura lok kepe vam lumumuat at labalak, la ura lox aumsu ia mi lososoro. ");
INSERT INTO mmx_vpl VALUES ("PS30_12","020_30_12","PSA","30","12","12","Kuren la nia noxo vamngus, anak pixan emi asu minu. Leeme Silok, nenu ne Moroa rak. Anaba tong avukat amisik tu. ");
INSERT INTO mmx_vpl VALUES ("PS31_1","020_31_1","PSA","31","1","1","Leeme Silok, na a vot parav u xusu unak lok see rak. Nemen uta ke avolo limixin munepen minia dina sep kapmex ia la ana lok mamangan. Loklok taram in manton tino, na a sing u do una lox asepsu ia basinge di. ");
INSERT INTO mmx_vpl VALUES ("PS31_2","020_31_2","PSA","31","2","2","Una ronga ia, na! Una lox asepsu ia basinge di! Nenu una nemen ngan Loxot Loklox Alipe rak, kusu una lok see rak. La una rupe avukar ia, kusu anaba nemen avukat, la limixin munepen minia di noxo sep kapmex ia. ");
INSERT INTO mmx_vpl VALUES ("PS31_3","020_31_3","PSA","31","3","3","Nenu mun Loxot Loklox Alipe rak la Lentupe ria. Unam gomgonga ia, la unam lam ia at nom langas nenu ga xaape min. ");
INSERT INTO mmx_vpl VALUES ("PS31_4","020_31_4","PSA","31","4","4","Una kubak pe ia basinge lelixo no diga lok li ngais ia min. Una xua pe ia mi lolos taram basinge laniu. ");
INSERT INTO mmx_vpl VALUES ("PS31_5","020_31_5","PSA","31","5","5","A lok li loroonan tarak at lukngam. Leeme Silok, nenu ne Moroa u ruturun amisik ti limixin tarak, la unaba lox asepsu ia. ");
INSERT INTO mmx_vpl VALUES ("PS31_6","020_31_6","PSA","31","6","6","U belengatngas tinedi di lotu saparap leven moroa xaxarang. Ketla nia a nunu saga ram. ");
INSERT INTO mmx_vpl VALUES ("PS31_7","020_31_7","PSA","31","7","7","Anaba momo la ana sosoro mumu nom labalamu lexen taram. Ura ven pam laxasongsongot nia a ruuna i. La uklen bok levenmumuat tarak. ");
INSERT INTO mmx_vpl VALUES ("PS31_8","020_31_8","PSA","31","8","8","Nenu u goxo ke xepe limixin munepen minia, gita xoxo ka ia. Nu uga lok tooro ia la nia aga nemen avukat, la nia agat pas tangtagap at lavavara axa rak. ");
INSERT INTO mmx_vpl VALUES ("PS31_9","020_31_9","PSA","31","9","9","Leeme Silok, una lox asuusu lebelen tuntun tia, na nia a ruuna langsangan lumumuat. Luxatli rak ira ung axap at lerengteng. Lengkot tarak ira molo axap. ");
INSERT INTO mmx_vpl VALUES ("PS31_10","020_31_10","PSA","31","10","10","Lanbulu rak at laxanmumuat i lox atmut lorooro rak. Ara molos axap at na laxanmumuat tarak, labantuxu rak ira meramun axap. ");
INSERT INTO mmx_vpl VALUES ("PS31_11","020_31_11","PSA","31","11","11","Limixin munepen minia, la nedi di nemen aurer ia, di ven ia la di paase aksaksa ria mumu lanmeres tarak. Nedi dikleklen ia, dik marat tarak. Dola di ven ia at pas to at langas, dik sixiro rak. ");
INSERT INTO mmx_vpl VALUES ("PS31_12","020_31_12","PSA","31","12","12","Limixin axap dira domampe vam ia, ngan ta dola agara met pam. Nia a lok ngan ta lavanga no digara lu xepe vam min. ");
INSERT INTO mmx_vpl VALUES ("PS31_13","020_31_13","PSA","31","13","13","A ronga buaang limixin munepen di paase siksikma mu ia. Lanmarat silok i suxuna ia. Di seput li leventaangas kusu dina rebeng alis ia la dina sev amer ia. ");
INSERT INTO mmx_vpl VALUES ("PS31_14","020_31_14","PSA","31","14","14","O Leeme Silok, lununu rak i tu mun taram, la nenu ne Moroa rak. ");
INSERT INTO mmx_vpl VALUES ("PS31_15","020_31_15","PSA","31","15","15","Nia a nemen amisik keneng at loklok tatao ram. Una lox asepsu ia basinge limixin munepen minia, la basinge bok nedi di lox asongor ia. ");
INSERT INTO mmx_vpl VALUES ("PS31_16","020_31_16","PSA","31","16","16","Nia lasaxaruki ram, la unak lok tatao ia mi lebelemulus taram. Una lox asepsu ia atla u ruuna labalamu lexen. ");
INSERT INTO mmx_vpl VALUES ("PS31_17","020_31_17","PSA","31","17","17","Leeme Silok, na nia a ro ke ram. Nemen gat uta ke avolo limixin munepen minia dina lox amangan ia. Keke nedi limixin bilinga dina lok mamangan. La dina rakdu aleng kusu dina lok pilo mun at loxonaleng dina si uto xopok at lemenemen at labarongan. ");
INSERT INTO mmx_vpl VALUES ("PS31_18","020_31_18","PSA","31","18","18","Una vamngus limixin di xaxarang, nedi dit las di la dim simi aurut di, di paase aksaksa mumu limixin manmanton, la di paase asi di. ");
INSERT INTO mmx_vpl VALUES ("PS31_19","020_31_19","PSA","31","19","19","Nenu u umsu mi lempanga avukat, mo ura gagas li vam i kusu na lox asuusu i rinedi dim taba asinorong u! Uk lok see atnedi di nunu saga ram, la limixin axap di ven kibis i. ");
INSERT INTO mmx_vpl VALUES ("PS31_20","020_31_20","PSA","31","20","20","Uk lox alipe nedi maxopok at loklok tatao ram basinge lodoxoma ali at limixin kapmek la uk lox amaau di basinge levelinga aksaksa at limixin munepen minedi. ");
INSERT INTO mmx_vpl VALUES ("PS31_21","020_31_21","PSA","31","21","21","Leemi asu ri Leeme Silok! Ni ga lox asuusu nom labalamu nunuan teren tia at laaleng limixin munepen minia diga ru xangkan ia ri leesep! ");
INSERT INTO mmx_vpl VALUES ("PS31_22","020_31_22","PSA","31","22","22","Nia aga marat la nia aga nua i do ni ga lok kepe ia basinge loklok tatao ren. Ketla ni ga ronga lanteng tarak, at levenaleng nia aga sing i ri loklok tooro. ");
INSERT INTO mmx_vpl VALUES ("PS31_23","020_31_23","PSA","31","23","23","Nemi luvuttadi mi nunu saga at levelinga at Leeme Silok. Lebelen nimi na ngaongao rin. Leeme Silok ik lok see atnedi luvuttadi ruturun teren. Ketla ni ik lox asongot nedi dit las di, mo losongsongot i epovo rinedi limixin kerepmo. ");
INSERT INTO mmx_vpl VALUES ("PS31_24","020_31_24","PSA","31","24","24","Nemi axap limixin mina doxoma ngangais ti Leeme Silok. Mina tu tuxuruxun la minam doma abelemes. ");
INSERT INTO mmx_vpl VALUES ("PS32_1","020_32_1","PSA","32","1","1","Nedi, dira sepmus pam basinge laxakapmek atnedi, dina momo. Laxakapmek atnedi ne Moroa ira doxoma xepe vam i. ");
INSERT INTO mmx_vpl VALUES ("PS32_2","020_32_2","PSA","32","2","2","Do taradi go la Leeme Silok kopmen na vuse ka taxapmek teren la kopmen bok taxaxarang teren, ni na lok momo. ");
INSERT INTO mmx_vpl VALUES ("PS32_3","020_32_3","PSA","32","3","3","Ga ruka i nia goxo vaase asu laxakapmek tarak, agang teng amisik at levenaleng kangking la kanimin, kuren la labantuxu rak ira xat molos. ");
INSERT INTO mmx_vpl VALUES ("PS32_4","020_32_4","PSA","32","4","4","At levenaleng kangking la kanimin, nenu Leeme Silok ugap sev aleeng ia. Kuren la lolos tarak gara ravasu axap pam. Ik lok ngan laxangking at lamaares ik lox avatmang laxangka. ");
INSERT INTO mmx_vpl VALUES ("PS32_5","020_32_5","PSA","32","5","5","La na nia aga vaase asu laxakapmek tarak tu, kopmen a goxo lipe toxot teren basinge u. Aga vara i do ana soxomus laxakapmek axap tarak tu, la uga doxoma xepe axav i. ");
INSERT INTO mmx_vpl VALUES ("PS32_6","020_32_6","PSA","32","6","6","Kuren la i lox avukat do limixin tuturun taram dinaba sing saparav u at levenaleng at levenmumuat. Dola langsangan lekarakat i rava beles mu nedi ngan ladanut, kopmen noxo lox abaava di. ");
INSERT INTO mmx_vpl VALUES ("PS32_7","020_32_7","PSA","32","7","7","Nenu Loxot Loklox Alipe rak, la unaba lox asepsu ia basinge levenmumuat. Ak pixan momo at loklok tooro ram, atla nenu uk lok see rak. ");
INSERT INTO mmx_vpl VALUES ("PS32_8","020_32_8","PSA","32","8","8","Leeme Silok i lok keretna, “Nia anaba lox ase u mi langas unabat pas teren. Nia anaba anasa u, la anaba vaase aronga box u. ");
INSERT INTO mmx_vpl VALUES ("PS32_9","020_32_9","PSA","32","9","9","Nemen gat nu tangtangku ngan la os kopla dongki. Limixin di lok li loxonaen at lungusno at lavaros la di xoxo alu labanoos to melemu at lavatlak teren, kusu na ronga res atdi.” ");
INSERT INTO mmx_vpl VALUES ("PS32_10","020_32_10","PSA","32","10","10","Limixin kakapmek dinaba ekip tangarang mi laxasongsongot, ketla nedi di nunu saga at Leeme Silok, di nemen ma xeneng at loxokok at labalamu lexen teren. ");
INSERT INTO mmx_vpl VALUES ("PS32_11","020_32_11","PSA","32","11","11","Nemi limixin manmanton, mina momo la mina sosoro at levempanga Leeme Silok gak lox i. Nemi ming tonga res teren, minap kup momo. ");
INSERT INTO mmx_vpl VALUES ("PS33_1","020_33_1","PSA","33","1","1","Nemi axap limixin manmanton, minap kup mi lomomo mumu levempanga Leeme Silok gak lox i. Nemi axap ming tonga res teren, mina emi asu min! ");
INSERT INTO mmx_vpl VALUES ("PS33_2","020_33_2","PSA","33","2","2","Mina tong loklox avukat ti Leeme Silok mi lempat taaleng. Mina vixan tin mi leven gita. ");
INSERT INTO mmx_vpl VALUES ("PS33_3","020_33_3","PSA","33","3","3","Mina vixan loxompixan maxat saparav i. Mina sep maraanu lerengteng at ligita, kusu naba reng nunuan, la minap kup mi lomomo! ");
INSERT INTO mmx_vpl VALUES ("PS33_4","020_33_4","PSA","33","4","4","Levelinga at Leeme Silok i ruturun, la i epovo do ata nunu saga at leven gugu ren. ");
INSERT INTO mmx_vpl VALUES ("PS33_5","020_33_5","PSA","33","5","5","Leeme Silok i vavara mo leveloklok in manton la i ruturun. Labalamu lexen teren i umsu at lavatbung menemen. ");
INSERT INTO mmx_vpl VALUES ("PS33_6","020_33_6","PSA","33","6","6","Leeme Silok ga rudum li laxalibet mi lavapaase mun teren. Laxangking, lagaaling mi laxampenti ga ravasu mun at levelinga ni ga tong asu i. ");
INSERT INTO mmx_vpl VALUES ("PS33_7","020_33_7","PSA","33","7","7","Ni ga lok bubua laras at lara loxot, la ni ga lok li lisimaramain utou xa xopok at loxot teren. ");
INSERT INTO mmx_vpl VALUES ("PS33_8","020_33_8","PSA","33","8","8","Limixin at lavatkangka axap, mina lotu saparap Leeme Silok! Nemi axap limixin at lavatbung menemen minam taba asinorong i. ");
INSERT INTO mmx_vpl VALUES ("PS33_9","020_33_9","PSA","33","9","9","Ni ga vaase mene, la lavatbung menemen ga raut. At lavapaase mun teren levempanga axap ga ravasu. ");
INSERT INTO mmx_vpl VALUES ("PS33_10","020_33_10","PSA","33","10","10","Leeme Silok ik lox amun lodoxoma ali at limixin amgomgo at levenabung mixin petpes la kopmen dinak lox epovo levendoxoma belemamao atnedi. ");
INSERT INTO mmx_vpl VALUES ("PS33_11","020_33_11","PSA","33","11","11","Ketla leven doxoma gagas teren i nemen amisik, la mo do ni i doma i xusu na lok tavanga, ni nabak lox epovo amisik axa i. ");
INSERT INTO mmx_vpl VALUES ("PS33_12","020_33_12","PSA","33","12","12","Nedi lubung mixin ne Moroa it kis ngan Leeme Silok atnedi, dina momo, atla Moroa ga soxolik ka di ngan teren axa, dina momo. ");
INSERT INTO mmx_vpl VALUES ("PS33_13","020_33_13","PSA","33","13","13","Leeme Silok ik milix asi boro vana laxalibet, la i reven limixin axap. ");
INSERT INTO mmx_vpl VALUES ("PS33_14","020_33_14","PSA","33","14","14","Ni it kis tovana at loxot kitkis orong teren, la ik milik asi ri limixin axap di nemen at na lavatbung menemen. ");
INSERT INTO mmx_vpl VALUES ("PS33_15","020_33_15","PSA","33","15","15","Neni xa ga lox araut lodoxoma atnedi la ikleklen axap levempanga dik lox i. ");
INSERT INTO mmx_vpl VALUES ("PS33_16","020_33_16","PSA","33","16","16","Loorong at lavatbung menemen ixo epovo na sep kepe axap limixin munepen min mumu i do i ruuna buaang limixin esep la di lolos aleng. La laradi esep ixo sak tup mi limixin munepen min mumu lolos axa ren. ");
INSERT INTO mmx_vpl VALUES ("PS33_17","020_33_17","PSA","33","17","17","Laxan os ti leesep ixo epovo ri sev asi limixin munepen mi lolos axa atdi. Lolos silok atnedi ixo epovo na lox asepsu tara. ");
INSERT INTO mmx_vpl VALUES ("PS33_18","020_33_18","PSA","33","18","18","Ketla Leeme Silok i reven tatao nedi dik lok ngangao aleng teren, la nedi di nunu saga at labalamu lexen teren. ");
INSERT INTO mmx_vpl VALUES ("PS33_19","020_33_19","PSA","33","19","19","Neni ik lox asepsu di basinge lanmet, la ni ik lok tatao nedi at levenaleng at loroxo. ");
INSERT INTO mmx_vpl VALUES ("PS33_20","020_33_20","PSA","33","20","20","Ata nunu saga at Leeme Silok. Neni Lurutu See Pe la Laradi Loklok Tooro atdik. ");
INSERT INTO mmx_vpl VALUES ("PS33_21","020_33_21","PSA","33","21","21","Ata momo saga ren, la ata nunu at laasen teren i melemelengan. ");
INSERT INTO mmx_vpl VALUES ("PS33_22","020_33_22","PSA","33","22","22","O Leeme Silok, ma sing u do labalamu lexen taram na nemen eburu amisik minema. La ma doxoma ngangais tu. ");
INSERT INTO mmx_vpl VALUES ("PS34_1","020_34_1","PSA","34","1","1","Nia anaba tong loklox avukat amisik ti Leeme Silok, la anoxo xap mun at leges aleng ti emi asu min. ");
INSERT INTO mmx_vpl VALUES ("PS34_2","020_34_2","PSA","34","2","2","Nia anaba emi asu min ti levempanga ni gak lox i. Nedi limixin baava dina ronga i la dinak lek. ");
INSERT INTO mmx_vpl VALUES ("PS34_3","020_34_3","PSA","34","3","3","Nedik eburu ata tong asuusu i ri limixin do Leeme Silok i silok aleng. Nedik eburu axap ata emi asu mi laasen teren! ");
INSERT INTO mmx_vpl VALUES ("PS34_4","020_34_4","PSA","34","4","4","Nia aga sing saparap Leeme Silok la ni ga ronga ia. Ga lox asepmus ia basinge levenanmarat axap tarak. ");
INSERT INTO mmx_vpl VALUES ("PS34_5","020_34_5","PSA","34","5","5","Limixin baava diba ven tu ren la dinabak lek, la di noxo doma abulubun. ");
INSERT INTO mmx_vpl VALUES ("PS34_6","020_34_6","PSA","34","6","6","Luvuttadi baava di toro ke ren, la ni ing tonga nedi, la ik lox asepmus di basinge laxanmumuat axap atnedi. ");
INSERT INTO mmx_vpl VALUES ("PS34_7","020_34_7","PSA","34","7","7","Laangelo at leeme Silok ik lok tatao nedi dim taba asinorong i, la ik lox asepsu nedi basinge levenaniu. ");
INSERT INTO mmx_vpl VALUES ("PS34_8","020_34_8","PSA","34","8","8","Nemi xa mina ven terek luvukat at Leeme Silok. Laradi ik soxolik ka loxokok at Leeme Silok, ni na sosoro. ");
INSERT INTO mmx_vpl VALUES ("PS34_9","020_34_9","PSA","34","9","9","Nemi axap limixin teren, minam taba asinorong Leeme Silok. La nedi ding tonga res teren, di ruuna xobot kaka levempanga axap dik pakes tin. ");
INSERT INTO mmx_vpl VALUES ("PS34_10","020_34_10","PSA","34","10","10","At lepenaleng lubunglaion dik toxo la dik pakes ti levempanga anan, ketla nedi ding tonga res at Leeme Silok kopmen dinak pakes ti levempanga avukat, atla Leeme Silok im taba amisik di. ");
INSERT INTO mmx_vpl VALUES ("PS34_11","020_34_11","PSA","34","11","11","Ude nimi, laxamdak loklox ase, la mina ronga rak, la ana anasa nimi kusu minaba raba asinorong Leeme Silok. ");
INSERT INTO mmx_vpl VALUES ("PS34_12","020_34_12","PSA","34","12","12","Do nemi mi vara i xusu mina ruuna lorooro nunuan, la mi vara i xusu mina ven levenaleng avukat, ");
INSERT INTO mmx_vpl VALUES ("PS34_13","020_34_13","PSA","34","13","13","mina ke xepe lavapaase kapmek, la mina axav i at laxaxarang. ");
INSERT INTO mmx_vpl VALUES ("PS34_14","020_34_14","PSA","34","14","14","La nemi mina ke xepe laxakapmek la minak lok luvukat, la mina lolos ti lok ka lenmila keneng axap at lorooro axap atnimi. ");
INSERT INTO mmx_vpl VALUES ("PS34_15","020_34_15","PSA","34","15","15","Atla Leeme Silok i reven tatao limixin manmanton la ing tonga res at levesingising atnedi. ");
INSERT INTO mmx_vpl VALUES ("PS34_16","020_34_16","PSA","34","16","16","Ketla ik sok tixirixes kepe nedi dik lok laxakapmek, kusu dola dina met, limixin axap dinaba domampe soso mun nedi. ");
INSERT INTO mmx_vpl VALUES ("PS34_17","020_34_17","PSA","34","17","17","Limixin manmanton di toro ke at Leeme Silok, la ni ing tonga res atnedi. Neni ik lox asepsu di basinge levenmumuat atnedi. ");
INSERT INTO mmx_vpl VALUES ("PS34_18","020_34_18","PSA","34","18","18","Leeme Silok i gagas amisik ti lok tooro nedi dik lok tuntun, la i lox asepsu nedi ua lodoxoma abulubun i suxuna rinotno di. ");
INSERT INTO mmx_vpl VALUES ("PS34_19","020_34_19","PSA","34","19","19","Do laradi nunuan na ekip tangarang mi laxanmumuat solo, Leeme Silok naba lox asepmus i basinge axap mo lempanga. ");
INSERT INTO mmx_vpl VALUES ("PS34_20","020_34_20","PSA","34","20","20","Leeme Silok naba lok tatao axav i, la kopmen toxosi ren naba repit. ");
INSERT INTO mmx_vpl VALUES ("PS34_21","020_34_21","PSA","34","21","21","Limixin kakapmek dinaba met nop loklok kakapmek atdi. Nedi di belengatngas ti limixin manmanton, dinabap kip ka losongsongot. ");
INSERT INTO mmx_vpl VALUES ("PS34_22","020_34_22","PSA","34","22","22","Leeme Silok naba lox asepsu limixin teren. Nedi dinaba repukus taba i ri loklok tooro ren, di noxo ruuna ka lumumuat mavana atdi. ");
INSERT INTO mmx_vpl VALUES ("PS35_1","020_35_1","PSA","35","1","1","Leeme Silok, una tupe nedi di tu tangarang ia, la una esep eburu minedi di vara esep minia! ");
INSERT INTO mmx_vpl VALUES ("PS35_2","020_35_2","PSA","35","2","2","Una lok kaka lenban taram la una siga lisingsiga esep taram la una lox asepsu ia basinge di. ");
INSERT INTO mmx_vpl VALUES ("PS35_3","020_35_3","PSA","35","3","3","Una rebeng aurut lososo mi laasop taram ti esep eburu minedi nom di xaxala mu rak do dina sev ia. Una xaape do unaba lox asepsu ia basinge di. ");
INSERT INTO mmx_vpl VALUES ("PS35_4","020_35_4","PSA","35","4","4","Nedi nom di lok do, dina sev amer ia, una sev asi axap di kusu dinaba lok mamangan. Nedi nom di vengir ia, una sax amlong di la una lox ekarakat lodoxoma atnedi, ");
INSERT INTO mmx_vpl VALUES ("PS35_5","020_35_5","PSA","35","5","5","la dina lok ngan levempavagam mang, lamanman it mas kepe i, at loxonaleng laangelo at Leeme Silok i xaxala mu di! ");
INSERT INTO mmx_vpl VALUES ("PS35_6","020_35_6","PSA","35","6","6","Keke langas atnedi na main pe la na gagai, ap mo loxonaleng laangelo at Leeme Silok na sev asubu di! ");
INSERT INTO mmx_vpl VALUES ("PS35_7","020_35_7","PSA","35","7","7","Gano goxopmen tavasuun teren, la diga lok li pe ia mi lelixo, la diga xe lemeroon kusu anaba subu tup teren la dina rebeng alis kaka ia. ");
INSERT INTO mmx_vpl VALUES ("PS35_8","020_35_8","PSA","35","8","8","Ketla langsangan lumumuat naba vor asangu nedi, la nedi xa dinaba on at lara pelixo atnedi, la dinaba subu tup at langsangan leeteke! ");
INSERT INTO mmx_vpl VALUES ("PS35_9","020_35_9","PSA","35","9","9","Kuren la nia anaba momo ri Leeme Silok. Nia anabak lek atla neni ga lox asepsu ia basinge di. ");
INSERT INTO mmx_vpl VALUES ("PS35_10","020_35_10","PSA","35","10","10","Anaba tong i ri Leeme Silok mi lodoxoma axap tarak keretna, “Kopmen teta i lok ngan u. Uk lok see amisik at limixin kopmen tololos atnedi basinge limixin lolos, la limixin banbalo basinge limixin loklok papavas.” ");
INSERT INTO mmx_vpl VALUES ("PS35_11","020_35_11","PSA","35","11","11","Limixin kakapmek di vaxaru ia at lavapaase la dik sok taba ia mi leveloklok kakapmek mo nenia xopmen anaklen i. ");
INSERT INTO mmx_vpl VALUES ("PS35_12","020_35_12","PSA","35","12","12","Dip sepo loklox avukat tarak mi laxakapmek, kuren la lodoxoma abulubun i suxuna ia. ");
INSERT INTO mmx_vpl VALUES ("PS35_13","020_35_13","PSA","35","13","13","At levenaleng nedi digak meres, aga siga leventamon ti lox asuusu lanbulu rak la agan mun anan. Agat kis tintiding aleng ukopok la agang sing tinedi. ");
INSERT INTO mmx_vpl VALUES ("PS35_14","020_35_14","PSA","35","14","14","Ga ngan ta dola nia aga ngising ti lentangas tarak kopla netak. Nia agat pas tangtagap eburu mi langsangan lanbulu, ga ngan ta do a bulu mu ne naga. ");
INSERT INTO mmx_vpl VALUES ("PS35_15","020_35_15","PSA","35","15","15","Ketla do nia aga ekip tangarang mi levenmumuat, diga lok momo. Diga tu xangkan ia, la diga paase aksaksa ria. Limixin kadiong bok digak lox asongor ia, amisik digap sev ia. ");
INSERT INTO mmx_vpl VALUES ("PS35_16","020_35_16","PSA","35","16","16","Diga lok ngan limixin di lok sese laradi luxangkedek teren i molo, la diga reven angtungun bok tia mi lebelengatngas. ");
INSERT INTO mmx_vpl VALUES ("PS35_17","020_35_17","PSA","35","17","17","Leeme Silok. Kereva ura reven kepe amisik di? Una lox asepsu ia basinge leveloklox asongot atdi. Lox asepsu ia basinge na lubunglaion! ");
INSERT INTO mmx_vpl VALUES ("PS35_18","020_35_18","PSA","35","18","18","Do kuren, nia anaba tong loklox avukat tu ro melamgo at lovotpot buru at limixin taram. Nia anaba emi asu minu ro melamgo atnedi axap. ");
INSERT INTO mmx_vpl VALUES ("PS35_19","020_35_19","PSA","35","19","19","Mo limixin di munepen minia, nedi limixin kaxarang. Nemen gat uta ke avolo di, dina lok momo aksaksa ria mumu lumumuat tarak. Nemen gat uta ke avolo nedi dina lok sese ia. La nemen gat uta ke avolo nedi di belengatngas parang gamasa ria la dina momo mu lanbulu rak. ");
INSERT INTO mmx_vpl VALUES ("PS35_20","020_35_20","PSA","35","20","20","Kopmen dina paase atnaasan, dim doma xaka levelinga xaxarang kusu dina bala raba limixin loklok mulus min. ");
INSERT INTO mmx_vpl VALUES ("PS35_21","020_35_21","PSA","35","21","21","Dik sok taba ia mi levelinga, la dip kup keretna, “Maga ven u, uga lok nom levempanga xapmek!” ");
INSERT INTO mmx_vpl VALUES ("PS35_22","020_35_22","PSA","35","22","22","Ketla nenu, Leeme Silok, ugara ven pam i do nenia ap sepsen. O Leeme Silok, nemen bok ba uta vamngus. Nemen uta nemen paxalom! ");
INSERT INTO mmx_vpl VALUES ("PS35_23","020_35_23","PSA","35","23","23","O Leeme Silok, una xatu la una paase tooro ia. O Moroa rak, una xatu kaxat upana la una ru ria at na levelinga. ");
INSERT INTO mmx_vpl VALUES ("PS35_24","020_35_24","PSA","35","24","24","O Leeme Silok, loklok taram in manton tino. Kuren la una tong atkatla li i ria do nia ap sepse. Nemen uta ke avolo limixin munepen minia dina lok momo aksaksa ria mumu mo lumumuat tarak. ");
INSERT INTO mmx_vpl VALUES ("PS35_25","020_35_25","PSA","35","25","25","Nemen gat uta ke avolo di, dina lok keretna, “I lox avukat tinotno, dik tara lok pes pam i la ta lox epovo ba lavavara atnedik kuren.” ");
INSERT INTO mmx_vpl VALUES ("PS35_26","020_35_26","PSA","35","26","26","Nedi nom di lok momo at levenmumuat i vot saparav ia, una lox ekarakat levelinga atdi la una lox amangan di. Nedi nom di lok do dik mokso polo ia, una lox abaava di la una lox amangan di. ");
INSERT INTO mmx_vpl VALUES ("PS35_27","020_35_27","PSA","35","27","27","Naba lox avukat do nedi nom di vara i do ana sepse, dinap kup momo atla nenia a sepmus pam. La dina tong amu amgo ba i do, “Leeme Silok i silok aleng. Neni ik lok momo mi lasaxaruki ren na nemen avukat.” ");
INSERT INTO mmx_vpl VALUES ("PS35_28","020_35_28","PSA","35","28","28","La kerepmo nia anaba tong asu loklok manmanton taram, la anaba emi asu minu at levenaleng axap. ");
INSERT INTO mmx_vpl VALUES ("PS36_1","020_36_1","PSA","36","1","1","Laxakapmek ik lox atdan laradi xapmek keneng at lebelen. Ik sok sisixe ne Moroa, la kopmen naklen loklok tik lox asuusu loklok ngangao ri ne Moroa. ");
INSERT INTO mmx_vpl VALUES ("PS36_2","020_36_2","PSA","36","2","2","Im doma asilox axa i, kuren la i doma i do ne Moroa ixo epovo na ven lenget ka libilinga ren la noxo vaase asi rino i. ");
INSERT INTO mmx_vpl VALUES ("PS36_3","020_36_3","PSA","36","3","3","Lavapaase ren i lok kapmek la i umsu mi laxaxarang. Ik sok tixirixes kepe lodoxoma avukat la leveloklok i nunuan. ");
INSERT INTO mmx_vpl VALUES ("PS36_4","020_36_4","PSA","36","4","4","Im doma agagas li levempanga xakapmek do ik midi ro at loora ren. Kopmen nak lok tevempanga avukat, la kopmen tinotno nak sok sisixe lempanga xapmek. ");
INSERT INTO mmx_vpl VALUES ("PS36_5","020_36_5","PSA","36","5","5","O Leeme Silok, labalamu lexen taram i silok aleng tinotno la i urut se rovana at laxalibet. La uk lox epovo amisik leveng kakaape ram nade xopok la i se tu at lamavangkap. ");
INSERT INTO mmx_vpl VALUES ("PS36_6","020_36_6","PSA","36","6","6","Loklok manmanton taram i tu tuxuruxun ngan lempatkaana. Lempapaase ramtaba ina ram i lolos aleng ngan laras i ekapus. Limixin axap mi levempanga mi lavanuet kangkedek di nemen maxopok at loklok tatao ram. ");
INSERT INTO mmx_vpl VALUES ("PS36_7","020_36_7","PSA","36","7","7","O Moroa, labalamu lexen taram i lox avukat tinotno! Ma ven kaka loxokok taram tinema maxopok at luvapa ram. ");
INSERT INTO mmx_vpl VALUES ("PS36_8","020_36_8","PSA","36","8","8","Ma anan mais avukat mi laxaluxa solo um taba nema min, la u ke nema ma ruuna ka lorooro nunuan i sesen su ram ngan ladan sen. ");
INSERT INTO mmx_vpl VALUES ("PS36_9","020_36_9","PSA","36","9","9","Nenu lavasuun at lorooro at lempanga axap, la mumu mun lodoxoma xasep taram, nema ma ruuna ka laxakasep. ");
INSERT INTO mmx_vpl VALUES ("PS36_10","020_36_10","PSA","36","10","10","Labalamu ram na tu epasum tinedi dikleklen u. La una lok luvukat tinedi di ruuna loklok in manton tino. ");
INSERT INTO mmx_vpl VALUES ("PS36_11","020_36_11","PSA","36","11","11","Nemen uta ke avolo limixin loklox aaso dina esep minia, kopla limixin kapmek dina lox amarar ia la ana sixiro. ");
INSERT INTO mmx_vpl VALUES ("PS36_12","020_36_12","PSA","36","12","12","Nema ma ven ba no loxot limixin kakapmek di saksubu e. Mo dik midi, la ixo epovo do dina xatu kaxat. ");
INSERT INTO mmx_vpl VALUES ("PS37_1","020_37_1","PSA","37","1","1","Nemen gat mita doma mu solo loklok at limixin kapmek, la nemen mita ngaongao ri loklok atnedi di lok libilinga. ");
INSERT INTO mmx_vpl VALUES ("PS37_2","020_37_2","PSA","37","2","2","La ma lixilik mun dinaba sonao axap ngan levempivilis i mamang, dinabap sopso ngan larauna. ");
INSERT INTO mmx_vpl VALUES ("PS37_3","020_37_3","PSA","37","3","3","Ketla nemi mina nunu saga at Leeme Silok la mina lok luvukat mun, kusu minaba nemen at lenep kangka aulis atnimi la minaba rooro avukat. ");
INSERT INTO mmx_vpl VALUES ("PS37_4","020_37_4","PSA","37","4","4","Mina puse ri lomomo rinimi keneng at Leeme Silok, kusu ni naba raba nimi mi levempanga no lebelen nimi i tu solo i. ");
INSERT INTO mmx_vpl VALUES ("PS37_5","020_37_5","PSA","37","5","5","Mina ke raba Leeme Silok mi lorooro ram. Mina nunu saga ren la ni naba lok tooro nimi, ");
INSERT INTO mmx_vpl VALUES ("PS37_6","020_37_6","PSA","37","6","6","la ni naba lox asaxaven loklok sepse atnimi ri limixin la naba xasep ngan labaranan. La loklok manmanton atnimi naba tu asaxaven ngan laxangking tubu. ");
INSERT INTO mmx_vpl VALUES ("PS37_7","020_37_7","PSA","37","7","7","Mina mulus mun, la mina nemen tangais Leeme Silok na lok tooro nimi. Nemen mita doma mu solo nedi di ngasang kobot, kopla nedi di lox asoorun leventaangas kakapmek atnedi diga vit li i. ");
INSERT INTO mmx_vpl VALUES ("PS37_8","020_37_8","PSA","37","8","8","Nemen gat mita musak, la mina ke xepe lebelemamao atla i sasat ka limixin ukeneng at laxakapmek. ");
INSERT INTO mmx_vpl VALUES ("PS37_9","020_37_9","PSA","37","9","9","Nedi di nunu saga at Leeme Silok, dinaba ruuna ka lenep kangka aulis atdi, ketla Leeme Silok naba sak su limixin bilinga. ");
INSERT INTO mmx_vpl VALUES ("PS37_10","020_37_10","PSA","37","10","10","Soso mun limixin bilinga dinaba xav asonao. Minaba reven tidi, ketla mi noxo vuse ka di. ");
INSERT INTO mmx_vpl VALUES ("PS37_11","020_37_11","PSA","37","11","11","Ketla nedi di lox alixilik nedi, dinaba ruuna ka lenep kangka aulis atdi, la dinaba ngasang kobot la dinaba momo rino mi limila. ");
INSERT INTO mmx_vpl VALUES ("PS37_12","020_37_12","PSA","37","12","12","Limixin kapmek di sevut li levelinga ti sev asi limixin avukat la dik milix angtungun tino rinedi. ");
INSERT INTO mmx_vpl VALUES ("PS37_13","020_37_13","PSA","37","13","13","Ketla Leeme Silok ing longon arup limixin kapmek, atla ni iklen i do ni naba sele utut kepe di. ");
INSERT INTO mmx_vpl VALUES ("PS37_14","020_37_14","PSA","37","14","14","Limixin kakapmek di gagas li levenise esep atnedi mi levesoso, ti sev asi limixin banbalo eburu mi limixin dik pakes, ti sev amet nedi di lok leveloklok in manton. ");
INSERT INTO mmx_vpl VALUES ("PS37_15","020_37_15","PSA","37","15","15","Ketla nedi xa dinaba uu at levenise esep atnedi xa, la levesoso atnedi naba repirivit. ");
INSERT INTO mmx_vpl VALUES ("PS37_16","020_37_16","PSA","37","16","16","I lox avukat do laradi nunuan i ruuna lempanga xakalik mene. Ketla i lok kapmek do laradi i ruuna lapnovos silok la ik lok keneng at laxakapmek. ");
INSERT INTO mmx_vpl VALUES ("PS37_17","020_37_17","PSA","37","17","17","Atla Leeme Silok naba lok kepe lolos at limixin kapmek, la ni naba lok see atnedi loklok atdi i lox avukat. ");
INSERT INTO mmx_vpl VALUES ("PS37_18","020_37_18","PSA","37","18","18","Leeme Silok ik lok tatao nedi ding tonga res teren la at levenaleng axap i tu melamgo dinaba ruuna lenep kangka aulis atdi. ");
INSERT INTO mmx_vpl VALUES ("PS37_19","020_37_19","PSA","37","19","19","Di noxo suma losongsongot at levenaleng kapmek. Dinaba ruuna epovo leveluxa at levenaleng at loroxo. ");
INSERT INTO mmx_vpl VALUES ("PS37_20","020_37_20","PSA","37","20","20","Ketla limixin kapmek dinaba seeve, limixin munepen mi Leeme Silok dinaba xap ngan levempusuvus to laxairing, dinaba sonao ngan lusuxa. ");
INSERT INTO mmx_vpl VALUES ("PS37_21","020_37_21","PSA","37","21","21","Laradi xapmek i ngising panga ketla kopmen na porang amlong i. Ketla laradi avukat ik lok momo rim taba mi leventamtaba ren. ");
INSERT INTO mmx_vpl VALUES ("PS37_22","020_37_22","PSA","37","22","22","Nedi nom Leeme Silok ik lox anarong di, dinaba ruuna ka lenep kangka aulis atdi. Ketla nedi nom Leeme Silok ira lok li vam lasaxaek mavana atdi, ni naba saksu di basinge mo lenep kangka. ");
INSERT INTO mmx_vpl VALUES ("PS37_23","020_37_23","PSA","37","23","23","Leeme Silok im gomgonga laradi at langas i lox avukat kusu ni nat pas teren. La ik lok see atnedi dik lox amomo i. ");
INSERT INTO mmx_vpl VALUES ("PS37_24","020_37_24","PSA","37","24","24","Dola dina subu, di noxok midi ro xopok, atla Leeme Silok naba rebeng axatu di upana. ");
INSERT INTO mmx_vpl VALUES ("PS37_25","020_37_25","PSA","37","25","25","Nia lasioxo nga na, nia gara rooro aba vam, ketla nia agoxovisi na ven taradi avukat Leeme Silok gita raba rulu i, kopla laxamdak mi laxaalik teren gita ngising panga anan. ");
INSERT INTO mmx_vpl VALUES ("PS37_26","020_37_26","PSA","37","26","26","At levenaleng axap laradi avukat im taba gamasa la i sisiam taba limixin mi levempanga ren. Laxamdak mi laxaalik teren di lok ngan leveloklox anarong ti limixin axap. ");
INSERT INTO mmx_vpl VALUES ("PS37_27","020_37_27","PSA","37","27","27","Mina repukus basinge laxapmek la minak lok lununuan. La kerepmo livipisik li atnimi dinaba nemen amisik at lenep kangka aulis atdi. ");
INSERT INTO mmx_vpl VALUES ("PS37_28","020_37_28","PSA","37","28","28","Atla Leeme Silok, i vavara ri loklok i lox avukat, la kopmen ni na raba rulu luvuttadi di nemen tuturun teren. At levenaleng axap ik lok see atdi. Ketla livipisik li at limixin kakapmek ni naba saksu di basinge mo lenep kangka aulis atdi. ");
INSERT INTO mmx_vpl VALUES ("PS37_29","020_37_29","PSA","37","29","29","Limixin manmanton dinaba ruuna xaka lenep kangka aulis atdi la dinaba nemen teren at levenaleng axap i tu melamgo. ");
INSERT INTO mmx_vpl VALUES ("PS37_30","020_37_30","PSA","37","30","30","Levelinga at laradi avukat i ngan levelinga at laradi dokdoxoma, la amisik levelinga ren ik mokso. ");
INSERT INTO mmx_vpl VALUES ("PS37_31","020_37_31","PSA","37","31","31","Laulis Linga at ne Moroa i nemen keneng at lebelen la i mumu asu amisix i, la kopmen na on basinge i. ");
INSERT INTO mmx_vpl VALUES ("PS37_32","020_37_32","PSA","37","32","32","Laradi xapmek i kuxut tangais ti laradi avukat kusu na sev amer i. ");
INSERT INTO mmx_vpl VALUES ("PS37_33","020_37_33","PSA","37","33","33","Ketla Leeme Silok noxo raba rulu taradi manmanton ti limixin munepen min kusu ni na subu tup at levengkikngen di, kopla ni noxo ke avolo i xusu ni na subu at loxonaleng at lavapaase. ");
INSERT INTO mmx_vpl VALUES ("PS37_34","020_37_34","PSA","37","34","34","Mina doma lolos ngangais ti Leeme Silok la minang tonga res at levempapaase ali ren. Dola mina lox i xuren, ni naba raba asinorong nimi mi laramtaba, neni lenep kangka aulis atnimi. La minaba ven limixin kakapmek, Leeme Silok naba saksu di basinge lenep kangka aulis atdi. ");
INSERT INTO mmx_vpl VALUES ("PS37_35","020_37_35","PSA","37","35","35","Nia agaklen laradi xapmek, ni laradi vapavas. Ni ga ru polo limixin axap ngan ta luuna Seda (Cedar) boro Lebanon i ru polo larauna axap. ");
INSERT INTO mmx_vpl VALUES ("PS37_36","020_37_36","PSA","37","36","36","Ketla melemu nia aga volo go, la kopmen ta i go, nia aga reven tin, ketla agoxo vuse xaka i. ");
INSERT INTO mmx_vpl VALUES ("PS37_37","020_37_37","PSA","37","37","37","Mina ven mu asu loklok at laradi nunuan eburu mi laradi manmanton. Laradi lorooro ren i umsu mi limila naba ruuna luvuttubuno avolo, ");
INSERT INTO mmx_vpl VALUES ("PS37_38","020_37_38","PSA","37","38","38","ketla limixin kapmek dinaba ekip tangarang mi leeteke. La Leeme Silok naba xobo pes axap livipisik li atdi. ");
INSERT INTO mmx_vpl VALUES ("PS37_39","020_37_39","PSA","37","39","39","Leeme Silok ik lox asepsu limixin manmanton, la ik lok see atdi at levenaleng kapmek. ");
INSERT INTO mmx_vpl VALUES ("PS37_40","020_37_40","PSA","37","40","40","Ik lok tooro di la ik lox asepsu di basinge limixin kakapmek, atla di vot pasa i xusu ni nak lok see atdi. ");
INSERT INTO mmx_vpl VALUES ("PS38_1","020_38_1","PSA","38","1","1","O Leeme Silok, nemen uta lox asongor ia mi lebelemamao ram! ");
INSERT INTO mmx_vpl VALUES ("PS38_2","020_38_2","PSA","38","2","2","Ura so abi vam ia mi levesoso ram, la ura sev asubu vam ia ukopok. ");
INSERT INTO mmx_vpl VALUES ("PS38_3","020_38_3","PSA","38","3","3","Nia a xip tutu mi langsangan losongsongot mumu lebelemamao ram tia. La labantuxu axap tarak iram suma lanmeres mumu libilinga rak. ");
INSERT INTO mmx_vpl VALUES ("PS38_4","020_38_4","PSA","38","4","4","Laxakapmek tarak i umsu ngan ladan kam la i epovo ana xong keneng teren. I lok ngan laknixip silok i mumuat aleng tia rip kiv i. ");
INSERT INTO mmx_vpl VALUES ("PS38_5","020_38_5","PSA","38","5","5","Nia lavanga rangtangku mun mumu laxakapmek tarak la kerepmo nia a meres la levenabi rak i so mau, la ip sopso. ");
INSERT INTO mmx_vpl VALUES ("PS38_6","020_38_6","PSA","38","6","6","Lantuk iran baloolo, la laxakapmek tarak ik sak palaga rino ia, arang teng tuntun at levenaleng axap. ");
INSERT INTO mmx_vpl VALUES ("PS38_7","020_38_7","PSA","38","7","7","Lanmeres to xeneng at labantuxu rak i lok ngan laxao la i auret kusu ana met. ");
INSERT INTO mmx_vpl VALUES ("PS38_8","020_38_8","PSA","38","8","8","Labantuxu rak ira molos axap, i lok ngan ta lavatpanga mumuat mo ik sak palaga ia. Labalak i lok kapmek tino, la at mes mi labaava at losongsongot. ");
INSERT INTO mmx_vpl VALUES ("PS38_9","020_38_9","PSA","38","9","9","O Leeme Silok, uklen lavanga sala nia a vara aleng tin, nenu uklen losongsongot tarak. U ronga ia at mes silok. ");
INSERT INTO mmx_vpl VALUES ("PS38_10","020_38_10","PSA","38","10","10","Leveve rak itlos etitit, lolos tarak ira xap pam, luxatli rak kopmen bok ba na reven avukat. ");
INSERT INTO mmx_vpl VALUES ("PS38_11","020_38_11","PSA","38","11","11","Larapentangas tarak mi leventaba aurer ia di noxot pas saparav ia, atla a ruuna laxanabi solo, la leventaba bok tarak di noxo nemen eburu minia. ");
INSERT INTO mmx_vpl VALUES ("PS38_12","020_38_12","PSA","38","12","12","Mo limixin di vara na sev amer ia di lili larapelixo ria, la nedi di vara na lox asongor ia, di lok do dina lok kakapmek axav ia. Dixo vaxap ti vengit ia, kusu dina lok kapmex ia. ");
INSERT INTO mmx_vpl VALUES ("PS38_13","020_38_13","PSA","38","13","13","Nia a lok ngan laradi baulang, kopmen nang tonga, la kopmen na paase. ");
INSERT INTO mmx_vpl VALUES ("PS38_14","020_38_14","PSA","38","14","14","Nia xopmen ana paase porang, atla a lok ngan laradi lubaalung teren i rebonot. ");
INSERT INTO mmx_vpl VALUES ("PS38_15","020_38_15","PSA","38","15","15","Ketla a nunu saga ram, Leeme Silok. La nenu Leeme Silok, unaba vaase porang ia. ");
INSERT INTO mmx_vpl VALUES ("PS38_16","020_38_16","PSA","38","16","16","Nemen uta ke avolo limixin munepen minia dina lok momo aksaksa ria mumu lusumsubu rak la dina lok momo mumu lumumuat tarak. ");
INSERT INTO mmx_vpl VALUES ("PS38_17","020_38_17","PSA","38","17","17","Nia na ana subu nga, la a suma amisik langsangan losongsongot silok. ");
INSERT INTO mmx_vpl VALUES ("PS38_18","020_38_18","PSA","38","18","18","Nia a tong asu laxakapmek tarak, atla mo laxakapmek ik lox abulu amisix ia. ");
INSERT INTO mmx_vpl VALUES ("PS38_19","020_38_19","PSA","38","19","19","Limixin di munepen minia di ruuna lorooro avukat mi lolos. Buaang nedi di belengatngas parang gamasa mun tia. ");
INSERT INTO mmx_vpl VALUES ("PS38_20","020_38_20","PSA","38","20","20","Nedi di sepo lununuan mi laxakapmek. Kopmen dina etaba belen minia atla nia a mumu asu langas mokmokso. ");
INSERT INTO mmx_vpl VALUES ("PS38_21","020_38_21","PSA","38","21","21","O Leeme Silok, nemen uta raba rulu ia. Moroa rak, nemen uta nemen paxalom basinge ia! ");
INSERT INTO mmx_vpl VALUES ("PS38_22","020_38_22","PSA","38","22","22","O Leeme Silok, nu Laradi Loklox Asepsu rak! Soso mun! Una lox tooro ia. ");
INSERT INTO mmx_vpl VALUES ("PS39_1","020_39_1","PSA","39","1","1","Nia ara tong pam i, “Nia anaba lok tatao avukat langsuk mi levempanga anaba lox i, kusu noxo sar asoogong ia. Nia anoxo tong tepanga xerepmo mo do luvuttadi xapmek dik lok auret.” ");
INSERT INTO mmx_vpl VALUES ("PS39_2","020_39_2","PSA","39","2","2","Nia agak lox atnaasan, la agoxo tong toxolinga. I ruturun tinotno, nia agoxo tong tepanga mumu levempanga nunuan! Ketla lumumuat tarak ga sisilox amisik, ");
INSERT INTO mmx_vpl VALUES ("PS39_3","020_39_3","PSA","39","3","3","la lodoxoma saasaa ga suxuna lorooro axap tarak. Nia agam doma solo i, la kerepmo labalak gan tun aleng. La nia agoxo epovo na lok pilo mun. La aga ruka i xusu ana sing keretna, ");
INSERT INTO mmx_vpl VALUES ("PS39_4","020_39_4","PSA","39","4","4","“Leeme Silok, lavanisa levenmaares nia ana rooro amisik teren? Ningisa ba ia anaba met? Una tong i ria, do ningisa lorooro rak naba xap.” ");
INSERT INTO mmx_vpl VALUES ("PS39_5","020_39_5","PSA","39","5","5","Nu uga lok lorooro rak kopmen na baalom solo! At levereven taram levenaleng ti lorooro rak ni i lok ngan lavanga gamasa. I ruturun tinotno do, limixin axap di rooro, di lok ngan mene legesa mamas silok, ");
INSERT INTO mmx_vpl VALUES ("PS39_6","020_39_6","PSA","39","6","6","di lok ngan mun lamamau. Levempanga axap, limixin dik lox i, naba ravasu gamasa mun. Dipnovos li lempanga, ketla di xoklen i do nege naba ruuna ka i. ");
INSERT INTO mmx_vpl VALUES ("PS39_7","020_39_7","PSA","39","7","7","Lavanga sala bok ba i mo xusu nia anam doma ngangais tin, Leeme Silok? Nia a nunu saga ram. ");
INSERT INTO mmx_vpl VALUES ("PS39_8","020_39_8","PSA","39","8","8","Una lox asepsu ia basinge laxaloklok kakapmek axap tarak, la nemen gat nu uta ke xepe limixin baulang dina vaase aksaksa ria. ");
INSERT INTO mmx_vpl VALUES ("PS39_9","020_39_9","PSA","39","9","9","Nia anaba lok pilo la anoxo tong toxolinga, atla nenu mun uga raba ia mi na levesongsongot. ");
INSERT INTO mmx_vpl VALUES ("PS39_10","020_39_10","PSA","39","10","10","Nemen bok ba uta sev aleeng solo ia! La ma lixilik kusu ana met at leven akpiksa mun taram. ");
INSERT INTO mmx_vpl VALUES ("PS39_11","020_39_11","PSA","39","11","11","Uk lox asongot laradi mumu laxakapmek teren mi lavapaase kuxurung taram, la u lox asonao axap levempanga neni ing kongkat min ngan levempide ip sep larauna. Laradi i lok ngan mene legesa mamas ip tava su at lungusno! ");
INSERT INTO mmx_vpl VALUES ("PS39_12","020_39_12","PSA","39","12","12","Leeme Silok, una ronga lising tarak. Una ronga ri lanteng tarak. Una lok tooro ia do nia anang teng tuntun. Nia a lok ngan lavalabat tarak diga nemen ngan lavaose ram nade xopok at na lavatbung menemen atla di goxo rooro abao. ");
INSERT INTO mmx_vpl VALUES ("PS39_13","020_39_13","PSA","39","13","13","Una ke xepe mulus ia kusu anaba momo avot ti loonon tarak la di noxo ven tu bok ba rak. ");
INSERT INTO mmx_vpl VALUES ("PS40_1","020_40_1","PSA","40","1","1","Nia aga ngangais atnaasan ti loklok tooro at Leeme Silok tia. La ni ga ronga bok lanteng tarak la ga ronga res tarak. ");
INSERT INTO mmx_vpl VALUES ("PS40_2","020_40_2","PSA","40","2","2","Ni ga sar asu ka ia at lemeroon kapmek, la ga sar asu xaka box ia at lububura. Ni ga vaxaru li avukar ia ro vana at luuat kis silok kusu anat pas avukat la anoxo marat at tempanga. ");
INSERT INTO mmx_vpl VALUES ("PS40_3","020_40_3","PSA","40","3","3","Ga lox ase ia rik pixan loxompixan maxat, loxompixan emi asu ri ne Moroa atnedik. Buaang nedi limixin dinaba ven kibis lolos teren, dina sangu aleng la dina ii doxoma la dinaba nunu saga at Leeme Silok. ");
INSERT INTO mmx_vpl VALUES ("PS40_4","020_40_4","PSA","40","4","4","Lomomo rinedi di nunu saga at Leeme Silok, la rinedi bok kopmen dina repukus mu laxampoovo moroa, kopla dina nemen eburu minedi di lotu saparap laxanmoroa xaxarang. ");
INSERT INTO mmx_vpl VALUES ("PS40_5","020_40_5","PSA","40","5","5","O Leeme Silok, nenu ne Moroa atnema. Buaang laxampanga avukat ugara lok pam i rinema. Kopmen tara i nunuan polo u! Ugara lox asuusu vam buaang lempanga sangsangu nunuan tinema. Ixo epovo xusu nia ana tong ampana leexes atdi atla mo levempanga i umsu aleng! ");
INSERT INTO mmx_vpl VALUES ("PS40_6","020_40_6","PSA","40","6","6","Nenu uxo vavara solo ri levelaplavang mi leventamtaba, nenu uxo ngising ti levempanga mi lavanuet kangkedek kusu mana kotos asonao i ro vana at loxonin laplavang, kopla ri levelaplavang ti ves kepe laxakapmek. Ketla uga raba ia mi lubaalung ting tonga res taram. ");
INSERT INTO mmx_vpl VALUES ("PS40_7","020_40_7","PSA","40","7","7","Kuren la nia aga lok tu xeretna, “Nenia nga na, levelinga mumu ia i nemen keneng at Laulis Linga.” ");
INSERT INTO mmx_vpl VALUES ("PS40_8","020_40_8","PSA","40","8","8","Moroa rak, a vavara mene i xusu ana gugu mu asu mun lavavara ram! Levempanga axap uga lox ase ia min, i nemen keneng at labalak. ");
INSERT INTO mmx_vpl VALUES ("PS40_9","020_40_9","PSA","40","9","9","O Leeme Silok, to melamgo at lovotpot buru at limixin axap taram, nia aga vaase asu lagale lavavang dola uk lox asepsu nema limixin taram. Nu uklen i do nia anoxo vamngus ti tong asu i. ");
INSERT INTO mmx_vpl VALUES ("PS40_10","020_40_10","PSA","40","10","10","Agoxo vam luxun kaka lagale lavavang ti loklok tooro ria xusuk. Nia a tong asu amisik pam i do uk lok tooro limixin la uk lox asoorun levelinga ram tidi. Kopmen agoxo vamngus ti tong asu lixitkis esogo mi labalamu lexen taram to melamgo at lovotpot buru at limixin taram. ");
INSERT INTO mmx_vpl VALUES ("PS40_11","020_40_11","PSA","40","11","11","Leeme Silok, nia aklen i do lebelen tuntun taram tia noxo xap. Labalamu mi loklok tatao tuturun taram naba kok avukat amisix ia. ");
INSERT INTO mmx_vpl VALUES ("PS40_12","020_40_12","PSA","40","12","12","Laxanmumuat solo i tu xangkan ia la nia xo epovo xusu ana exes ampana di! Laxaloklok kakapmek tarak i sak pavaa rino ia, la axo epovo nga ri milik kadas. Di volo aleng ti leexes at levengkabinim at lavatlak tarak, la labalak i doma abulubun. ");
INSERT INTO mmx_vpl VALUES ("PS40_13","020_40_13","PSA","40","13","13","Leeme Silok, una lox asepsu ia! Lok tooro nga ia na! ");
INSERT INTO mmx_vpl VALUES ("PS40_14","020_40_14","PSA","40","14","14","Nedi nom di lok do dina sev amer ia, nia a vara i do una sak tup midi, la una lox ekarakat tinotno di. Nedi nom di momo atla laxanmumuat i sak pavaa ia. A vara i do una xala xepe di la una lox amangan di. ");
INSERT INTO mmx_vpl VALUES ("PS40_15","020_40_15","PSA","40","15","15","Nedi nom di lok kalise ia, una lox amangan tino di mumu loklok di lox i ria. ");
INSERT INTO mmx_vpl VALUES ("PS40_16","020_40_16","PSA","40","16","16","Nia a vara i do nedi di repukus taba u, dina momo la dina sosoro. La nedi nom di tong loklox avukat ti loklok tooro amisik, dina tong i do, “Leeme Silok i nunuan aleng pologat.” ");
INSERT INTO mmx_vpl VALUES ("PS40_17","020_40_17","PSA","40","17","17","O Leeme Silok, labantuxu rak ira xat molos axap la arat kis banbalo nga, ketla kopmen una doxomampe ia. Nenu Laradi Loklox Asepsu rak, la nenu ne Moroa rak. Una lok tooro soso mun ia! ");
INSERT INTO mmx_vpl VALUES ("PS41_1","020_41_1","PSA","41","1","1","Nedi di doma mu solo limixin banbalo, dina momo. Leeme Silok naba lok tooro di mo do dina ekip tangarang mi levenmumuat. ");
INSERT INTO mmx_vpl VALUES ("PS41_2","020_41_2","PSA","41","2","2","Leeme Silok naba lok see atdi la naba xok avukat lorooro atnedi. La ni naba sinang di mi lorooro avukat at lenep kangka me Israel. La ni noxo raba rulu di kusu limixin munepen minedi dina lok kapmek di. ");
INSERT INTO mmx_vpl VALUES ("PS41_3","020_41_3","PSA","41","3","3","Dola dina meres, Leeme Silok naba lok tooro di. La ni naba lok kepe levenanmeres basinge di, la na lox alolos manga nedi. ");
INSERT INTO mmx_vpl VALUES ("PS41_4","020_41_4","PSA","41","4","4","Nia aga tong i do, “Nia ara lok pam libilinga ru, Leeme Silok ne Moroa. Una lox asuusu lebelen tuntun tia la una lox asepsu ia.” ");
INSERT INTO mmx_vpl VALUES ("PS41_5","020_41_5","PSA","41","5","5","Limixin munepen minia di vaase kuxurung mumu ia. Di vara i do nia ana met kusu limixin axap dinaba domampe ia. ");
INSERT INTO mmx_vpl VALUES ("PS41_6","020_41_6","PSA","41","6","6","Nedi dit pot pasa ia, di sosolo asu linga rak. La ding senge ka levelinga xapmek mumu ia la dira tere mumu ia at levengkot axap. ");
INSERT INTO mmx_vpl VALUES ("PS41_7","020_41_7","PSA","41","7","7","Nedi di belengatngas tia, di epaase nemnem mu ia, di nunua i do levempanga xakapmek mo na lok kapmek tino nga ia. ");
INSERT INTO mmx_vpl VALUES ("PS41_8","020_41_8","PSA","41","8","8","Di lok do, “Lanmeres lolos mo ira sogo xaka vam i la ixo epovo do naba roo xat basinge loora mekmeres teren.” ");
INSERT INTO mmx_vpl VALUES ("PS41_9","020_41_9","PSA","41","9","9","Lentangas tino bok tarak, aga nunu saga ren. Neni mo lara ga anan eburu minia, la neni bok ira raba rulu ia. ");
INSERT INTO mmx_vpl VALUES ("PS41_10","020_41_10","PSA","41","10","10","Leeme Silok, una lox asuusu lebelen tuntun tia, kusu ana ruuna ka amlong lorooro nunuan, la ana sepo amlong loklok atnedi di munepen minia. ");
INSERT INTO mmx_vpl VALUES ("PS41_11","020_41_11","PSA","41","11","11","Di noxo epovo ri sak tup minia, la kerepmo nia anabaklen i do uk lok momo minia. ");
INSERT INTO mmx_vpl VALUES ("PS41_12","020_41_12","PSA","41","12","12","Unaba lok tooro ia, atla nia ak lox amisik levempanga ik mokso. Unabat kis esogo eburu minia at levenaleng axap i tu melamgo. ");
INSERT INTO mmx_vpl VALUES ("PS41_13","020_41_13","PSA","41","13","13","Leemi asu ri Leeme Silok, ne Moroa me Israel! Leemi asu rin na, la kopmen tekavaxap teren! Tuturun. Tuturun. ");
INSERT INTO mmx_vpl VALUES ("PS42_1","020_42_1","PSA","42","1","1","Nia ang kongkat mu u, O Moroa, kerekngan lavanga mi lavanuet kangkedek (deer) i minu aleng la ik sixit pupuse dan mumudut ti inin. ");
INSERT INTO mmx_vpl VALUES ("PS42_2","020_42_2","PSA","42","2","2","Nu ne Moroa Luntoo Avolo, labalak i ngaongao amisik tu. Ningisa ba, uba siam ka ia xusu anat pas uto at loogu ram la ana lotu saparav u ro melamgo ram? ");
INSERT INTO mmx_vpl VALUES ("PS42_3","020_42_3","PSA","42","3","3","Levenaleng kangking la kanimin nia ang teng, la kopmen ana anan. Amisik limixin munepen minia di susue ia do, “Ne Moroa ram ua?” ");
INSERT INTO mmx_vpl VALUES ("PS42_4","020_42_4","PSA","42","4","4","Lainbulu i suxuna ia at loxonaleng am doma su at levenaleng migomgo. At nom levenaleng nia aga emu mi limixin solo uto at loogu at ne Moroa. La nia agam gomgonga di at nom lavatpas. Buaang limixin digat pas mi lomomo, livikpixan mi luxupkup mi leemi asu saparap ne Moroa. ");
INSERT INTO mmx_vpl VALUES ("PS42_5","020_42_5","PSA","42","5","5","Tila nia ak bulu amisik? Tila nia am doma saasaa? Nia anam doma ngangais ti ne Moroa, kusu anaba emi asu amu bok min, ni Laradi Loklox Asepsu la ne Moroa rak. ");
INSERT INTO mmx_vpl VALUES ("PS42_6","020_42_6","PSA","42","6","7","Lanbulu i suxuna ia nade at loxokoxo xeneng at lemenemen xadiong. Kuren la lodoxoma rak i repukus tin. Im taba ia mi lanbulu silok ngan leretepit paxanao i tepit pavaa ia. Lentaba ik sak pavaa ia ngan ladanut, la ngan ladan i tem soobang su ro at ladan Joridan mo i sesen boro vana at lukaana Emon la Misar. ");
INSERT INTO mmx_vpl VALUES ("PS42_8","020_42_8","PSA","42","8","8","Leeme Silok na lox asuusu labalamu lexen teren at laaleng kangking, kusu nia anabak pixan at laxanimin, ni lisingising tarak ti ne Moroa mo im gomgonga lorooro rak. ");
INSERT INTO mmx_vpl VALUES ("PS42_9","020_42_9","PSA","42","9","9","Ti ne Moroa, Lentupe ria, nia a vaase xeretna, “Tila u domampe ia? Tila nia anap kip tutu amisik mi losongsongot at na laxanmumuat at longlong kuxurung at limixin di munepen minia?” ");
INSERT INTO mmx_vpl VALUES ("PS42_10","020_42_10","PSA","42","10","10","Labantuxu rak ira meleexot axap at loklok kalise atnedi di susue ulu amisix ia dola, “Moroa nga ua ram?” ");
INSERT INTO mmx_vpl VALUES ("PS42_11","020_42_11","PSA","42","11","11","Tila nia ak bulu amisik? Tila nia am doma saasaa? Nia anam doma ngangais ti ne Moroa, kusu anaba emi asu amu bok min, ni Laradi Loklox Asepsu rak la ne Moroa rak. ");
INSERT INTO mmx_vpl VALUES ("PS43_1","020_43_1","PSA","43","1","1","O Moroa, una tong atkatla li i ria do nia ap sepse, la una ru at lenep tarak tinedi limixin dixo nunu ram. Una lox asepsu ia basinge limixin kaxarang la limixin kapmek. ");
INSERT INTO mmx_vpl VALUES ("PS43_2","020_43_2","PSA","43","2","2","Nenu Lurutu See Pe rak, tila u on taba rulu ia? Tila nia a ekip tangarang amisik mi laxaloklox asongot limixin munepen minia dik lok kuxurung ia min? ");
INSERT INTO mmx_vpl VALUES ("PS43_3","020_43_3","PSA","43","3","3","Una lox asuusu laxasep taram eburu mi levelinga ruturun tia. Dunam gomgonga ia la duna lam ka amlong ia uto Saion, lakaana xaala ram, la uto bok at loogu laplavang taram nenu u nemen teren. ");
INSERT INTO mmx_vpl VALUES ("PS43_4","020_43_4","PSA","43","4","4","Melemu nia anabat pas uto at loxonin laplavang taram, O Moroa. Nenu mun lavasuun at lomomo rak. Nia anabak pixan eburu mi loxontaaleng ti emi asu minu. O Moroa, nenu ne Moroa rak. ");
INSERT INTO mmx_vpl VALUES ("PS43_5","020_43_5","PSA","43","5","5","Tila nia ak bulu amisik? Tila nia amdoma saasaa? Nia anam doma ngangais ti ne Moroa, kusu anaba emi asu amu bok min. Ni Laradi Loklox Asepsu rak la ne Moroa rak. ");
INSERT INTO mmx_vpl VALUES ("PS44_1","020_44_1","PSA","44","1","1","O Moroa, nema maga ronga rinotno mo lempanga matmatkun. Lavalabat atnama diga ga ven i nom levempanga sangsangu ugak lox i at levenaleng atdi gano migomgo. ");
INSERT INTO mmx_vpl VALUES ("PS44_2","020_44_2","PSA","44","2","2","Maga ronga i do nenu xa uga saksu mi lavamolon, la uga vaxaxis limixin taram at lenep kangka atnedi. Uga lox asongot bok limixin at levenabung mixin petpes la uga lox anarong lubung mixin taram la diga ngasang kobot. ");
INSERT INTO mmx_vpl VALUES ("PS44_3","020_44_3","PSA","44","3","3","Lubung mixin taram di goxo ruuna xaka nom lenep kangka at teesep. Kopmen di goxo ruuna xaka box i mi lolos atnedi. Diga ruuna ka i mi lolos mun taram, la digaklen i do uga nemen eburu minedi. Nom i ga lox asuusu i do uga balamu di. ");
INSERT INTO mmx_vpl VALUES ("PS44_4","020_44_4","PSA","44","4","4","Nenu Loorong Silok tarak la ne Moroa rak, uk lok tooro limixin taram la dik sak tup mi limixin munepen midi. ");
INSERT INTO mmx_vpl VALUES ("PS44_5","020_44_5","PSA","44","5","5","La mi lolos mun taram, nema ma sak tup mi limixin munepen minema. Keneng at laasen taram ma sev asi di. ");
INSERT INTO mmx_vpl VALUES ("PS44_6","020_44_6","PSA","44","6","6","Nia xopmen ana nunu at lososo, kopla at lavarise esep tarak ba lok tooro ia xusu na lox asepsu ia. ");
INSERT INTO mmx_vpl VALUES ("PS44_7","020_44_7","PSA","44","7","7","Ketla nenu, ne Moroa, uga lox asepsu nema basinge limixin munepen minema, la uga sak tup minedi diga belengatngas tinema. ");
INSERT INTO mmx_vpl VALUES ("PS44_8","020_44_8","PSA","44","8","8","Nema manaba emi asu amisik minu la manaba tong loklox avukat amisik tu la kopmen tekavaxap teren. ");
INSERT INTO mmx_vpl VALUES ("PS44_9","020_44_9","PSA","44","9","9","Ketla nanga ura sok sisixe nema, kuren la limixin munepen minema diga sak tup minema. Kopmen bok ba una emu buru mi limixin esep atnema. ");
INSERT INTO mmx_vpl VALUES ("PS44_10","020_44_10","PSA","44","10","10","Uga lok nema la maga sixiro at limixin munepen minema, la diga lok kaka levempanga atnema. ");
INSERT INTO mmx_vpl VALUES ("PS44_11","020_44_11","PSA","44","11","11","Uga siam taba di minema xusu dina sev amet nema ngan lubung sipsip, la uga lox epeseves nema uto ri levenabung mixin petpes. ");
INSERT INTO mmx_vpl VALUES ("PS44_12","020_44_12","PSA","44","12","12","I lok ngan ta do uga sesep mi limixin taram ti luunun lixilik mene. Maga lok ngan lempanga gamasa mun. ");
INSERT INTO mmx_vpl VALUES ("PS44_13","020_44_13","PSA","44","13","13","Levenabung mixin petpes dik lok saparap nama, diga ven lavanga uga lox i rinema, di paase kalise la ding longon atnema. ");
INSERT INTO mmx_vpl VALUES ("PS44_14","020_44_14","PSA","44","14","14","Uga ke aie xepe nema la limixin boro at lengkot petpes ding longon arup nema, di piripat patlak la ding longon sese nema at levempanga it pot saparap nema. ");
INSERT INTO mmx_vpl VALUES ("PS44_15","020_44_15","PSA","44","15","15","Lainmangan i umsu at lorooro rak mumu mo levelinga atnedi ");
INSERT INTO mmx_vpl VALUES ("PS44_16","020_44_16","PSA","44","16","16","dit kis munepen minia la atnedi bok di belengatngas tia. Di tong asu lavapaase aksaksa la levelinga kapmek mumu nama. ");
INSERT INTO mmx_vpl VALUES ("PS44_17","020_44_17","PSA","44","17","17","Na lempanga axap ga vot saparap nama ketla ma goxo domampe u kopla nema gita los polo lekabus taram uga lox i rinema. ");
INSERT INTO mmx_vpl VALUES ("PS44_18","020_44_18","PSA","44","18","18","Ma goxo raba sinta u, la kopmen ma goxo ronga xepe bok at levempapaase ali ram. ");
INSERT INTO mmx_vpl VALUES ("PS44_19","020_44_19","PSA","44","19","19","Ketla uga ke aie xepe nema kantubu at na limixin di lok ngan laxampanga sio. Uga raba rulu nema keneng at lamain bonot. ");
INSERT INTO mmx_vpl VALUES ("PS44_20","020_44_20","PSA","44","20","20","Mo dola nema gita xap ti lotu saparav u, ne Moroa atnema, la do nema gita sing saparap lomoroa vetpes, ");
INSERT INTO mmx_vpl VALUES ("PS44_21","020_44_21","PSA","44","21","21","nenu gitabaklen i, atla nenu ukleklen levendoxoma nemnem atnema. ");
INSERT INTO mmx_vpl VALUES ("PS44_22","020_44_22","PSA","44","22","22","Nema limixin taram, kuren la amisik dip sev amet nema. Amisik dip sev amet etaba nema ngan ta lubung sipsip, mo kopmen tara ri tupe di. ");
INSERT INTO mmx_vpl VALUES ("PS44_23","020_44_23","PSA","44","23","23","Leeme Silok, una aus! Una beleku kaxat! Una xatu upana! Nemen uta raba rulu rino axap ta nema! ");
INSERT INTO mmx_vpl VALUES ("PS44_24","020_44_24","PSA","44","24","24","Tila u lipe avolo nema? Nemen uta domampe levesongsongot mi levenmumuat atnema. ");
INSERT INTO mmx_vpl VALUES ("PS44_25","020_44_25","PSA","44","25","25","Diga vas amdamda nama, la maga subu midi xopok at laxangka. Mak midi ngan ta luvuttadi met! ");
INSERT INTO mmx_vpl VALUES ("PS44_26","020_44_26","PSA","44","26","26","Ude, una lok tooro nema! U ruuna labalamu lexen tinama, kuren la una lox asepsu nema! ");
INSERT INTO mmx_vpl VALUES ("PS45_1","020_45_1","PSA","45","1","1","Levelinga nunuan i umsu at lodoxoma rak, la nia ara rivit na loxompixan ti loorong at leme Israel. Nenia a gagas ti tong asu i ngan laradi akleklen ti malagan avukat mo i gagas lavanga mamalagan teren. ");
INSERT INTO mmx_vpl VALUES ("PS45_2","020_45_2","PSA","45","2","2","Loorong, nenu lampeneves, kopmen tara na lok ngan u. Levelinga ram ik sixit nunuan amisik. Moroa ik lox anarong amisix u. ");
INSERT INTO mmx_vpl VALUES ("PS45_3","020_45_3","PSA","45","3","3","Loorong lolos, una lox agagas lavarise esep taram. Lisisinang taram i umsu la laasen bok taram i silok aleng. ");
INSERT INTO mmx_vpl VALUES ("PS45_4","020_45_4","PSA","45","4","4","Nenu loorong mi laasen silok, ut kis pana at la os ti esep. La uk sak tup mi limixin munepen minu ti lox alolos loklok manmanton la levelinga ruturun. ");
INSERT INTO mmx_vpl VALUES ("PS45_5","020_45_5","PSA","45","5","5","Levesoso ram i kasum, di soso beles at larapeve at limixin munepen minu. Limixin at levenabung mixin petpes di subu mi loklok ngangao ro saparap luxangkedek taram. ");
INSERT INTO mmx_vpl VALUES ("PS45_6","020_45_6","PSA","45","6","6","Mo lixitkis amgomgo ne Moroa ga raba u min, naba nemen amisik la kopmen noxo xap. Nu um gomgonga limixin taram mi levelinga manmanton. ");
INSERT INTO mmx_vpl VALUES ("PS45_7","020_45_7","PSA","45","7","7","Uk lok momo mun mi leveloklok in manton la u belengatngas ti leveloklok ik lok kapmek. Ni lavasuun teren la ne Moroa, ni ne Moroa ram, ga soxolik ka u ngan loorong la ga raba u mi langsangan lomomo i volo lomomo atnedi lentaba lavaorong. ");
INSERT INTO mmx_vpl VALUES ("PS45_8","020_45_8","PSA","45","8","8","Levempanga singsiga ram i so mavak ngan la mea (myrrh) la alos (aloes). Limixin diga sinang laraogu at loorong mi levempanga nunuan (ivory), la di lox amomo u go mi leveng kompixan nunuan. ");
INSERT INTO mmx_vpl VALUES ("PS45_9","020_45_9","PSA","45","9","9","Kantubu at lavakin di ruuna levenasen silok, laxaalik at lavaorong mo di tu. La at lenep tino at loxonin orong taram, loorong tixin mo i tu, diga sinang i mi levempanga diga lox i mi logol i nunuan aleng. ");
INSERT INTO mmx_vpl VALUES ("PS45_10","020_45_10","PSA","45","10","10","Nenu loono ri loorong, una ronga na levelinga ana tong i ru. La uguta doma solo limixin taram mi libibinat taram. ");
INSERT INTO mmx_vpl VALUES ("PS45_11","020_45_11","PSA","45","11","11","Loorong naba veneves at levereven nunuan taram. Neni laradi silok taram, la una mumu asu levelinga ren. ");
INSERT INTO mmx_vpl VALUES ("PS45_12","020_45_12","PSA","45","12","12","Limixin boro Taia dinaba raba u mi leventamtaba. Limixin nopnovos bok dinaba lok tong i xusu dina sat lodoxoma ram, kusu una lok tooro di. ");
INSERT INTO mmx_vpl VALUES ("PS45_13","020_45_13","PSA","45","13","13","Loono ri loorong no i nemen keneng at loogu at loorong, neni loono maraanu rino! Ni i sigaara mi lisingsiga diga sokgatga i mi leteret gol. ");
INSERT INTO mmx_vpl VALUES ("PS45_14","020_45_14","PSA","45","14","14","Ni i sigaara mi lisingsiga gigiliton teren, la di lam kaka i uto at loorong. Ni i emu eburu mi lavakin pentangas teren, la di lam kaka bok di uto at loorong. ");
INSERT INTO mmx_vpl VALUES ("PS45_15","020_45_15","PSA","45","15","15","Di vubeles at loogu at loorong mi lomomo la lososoro. ");
INSERT INTO mmx_vpl VALUES ("PS45_16","020_45_16","PSA","45","16","16","Nenu loorong tarak, unaba ruuna laxanmadak temes solo, dinaba tu kun u eburu mi lavalabat taram ngan lavaorong. La unaba lok katling di kusu dina gomgonga mavana at limixin axap at na lavatbung menemen. ");
INSERT INTO mmx_vpl VALUES ("PS45_17","020_45_17","PSA","45","17","17","Na loxompixan tarak naba tong asu laasen silok taram kusu nedi lavaola melemu dinaba tere avolo laasen taram, la limixin axap dinaba emi asu amisik minu la kopmen tekavaxap teren. ");
INSERT INTO mmx_vpl VALUES ("PS46_1","020_46_1","PSA","46","1","1","Moroa ni Loxot Loklox Alipe atnedik la lolos atnedik. I gagas amisik tik lok tooro dik at levenaleng nedik ta ekip tangarang mi levenmumuat. ");
INSERT INTO mmx_vpl VALUES ("PS46_2","020_46_2","PSA","46","2","2","Kuren la dik ta noxo marat, keke i do lavatkangka axap nangne, la lempattaavut na subu tup utou xopok at lebelen laras. ");
INSERT INTO mmx_vpl VALUES ("PS46_3","020_46_3","PSA","46","3","3","Keke i do laras na luulung aleng mi leretepit la lempattaavut nangne mumu leretepit at lara paxanao. ");
INSERT INTO mmx_vpl VALUES ("PS46_4","020_46_4","PSA","46","4","4","Lara ladan mo i nemen, im taba lomomo ri limixin at lemenemen silok at ne Moroa, ti loogu xaala at Leeme Avolo. ");
INSERT INTO mmx_vpl VALUES ("PS46_5","020_46_5","PSA","46","5","5","Moroa mo i nemen ap mo lemenemen silok la kopmen tempanga noxo sele utut kepe i. Atla ni naba rupot ti lok tooro mo limixin at larangubo, maxantamak suubu. ");
INSERT INTO mmx_vpl VALUES ("PS46_6","020_46_6","PSA","46","6","6","Limixin boro at levenabung mixin petpes dinaba rakdu mi lanmarat, levengkot silok nabangne. Moroa naba vaase butbutki, la lavatbung menemen naba sonao. ");
INSERT INTO mmx_vpl VALUES ("PS46_7","020_46_7","PSA","46","7","7","Leeme Silok, ni Lanaraavuk la i nemen eburu midik. Moroa at ne Jakop ni Loxot Loklox Alipe atnedik. ");
INSERT INTO mmx_vpl VALUES ("PS46_8","020_46_8","PSA","46","8","8","Nemi limixin axap. Ude nimi la mina ven leveloklok Leeme Silok irak lok pam i. Mina ven levempanga sangsangu ira lok pam i nade xopok at lavatbung menemen. ");
INSERT INTO mmx_vpl VALUES ("PS46_9","020_46_9","PSA","46","9","9","I lox axap levenesep to at levengkot axap at lavatbung menemen. Im bapit levenbanara eburu mi levesoso, la i xotos asonao axap larapenban at laxao. ");
INSERT INTO mmx_vpl VALUES ("PS46_10","020_46_10","PSA","46","10","10","Moroa i lok keretna, “Lumulum! Na xap ta leesep, la mina xasep do nia ne Moroa. Nia Loorong Avolo mavana at larabung mixin axap, nia Loorong Avolo mavana at lavatbung menemen axap.” ");
INSERT INTO mmx_vpl VALUES ("PS46_11","020_46_11","PSA","46","11","11","Leeme Silok ni Lanaraavuk la i nemen eburu midik. Moroa at ne Jakop ni loogu matmatkun atdik. ");
INSERT INTO mmx_vpl VALUES ("PS47_1","020_47_1","PSA","47","1","1","Nemi limixin axap at na lavatbung menemen, mina pasa tingen mi lomomo! Mina emi asu mi ne Moroa mi livikpixan lolos! ");
INSERT INTO mmx_vpl VALUES ("PS47_2","020_47_2","PSA","47","2","2","Leeme Silok, ni Leeme Avolo. Dik atana lok ngangao aleng teren. Neni Loorong Silok, im gomgonga na lavatbung menemen axap. ");
INSERT INTO mmx_vpl VALUES ("PS47_3","020_47_3","PSA","47","3","3","Ni ga raba dik mi lolos ti sak tup mi limixin munepen minedik. Ga lox asilok nedik kusu atam gomgonga levenabung mixin petpes. ");
INSERT INTO mmx_vpl VALUES ("PS47_4","020_47_4","PSA","47","4","4","Neni ga lok katling ka na lenep kangka atnedik livipisik li at ne Jakop ua tana nemen teren. Ni i balamu limixin teren mo di lok momo mi lenep kangka atnedi. ");
INSERT INTO mmx_vpl VALUES ("PS47_5","020_47_5","PSA","47","5","5","Moroa i urut utoxun pana at loxonin orong teren. Limixin di ven i la dip kup silok aleng mi lomomo la lerengteng silok at laratu. ");
INSERT INTO mmx_vpl VALUES ("PS47_6","020_47_6","PSA","47","6","6","Mina vixan emi asu ri ne Moroa, mina vixan emi asu ri Loorong Silok atnedik! ");
INSERT INTO mmx_vpl VALUES ("PS47_7","020_47_7","PSA","47","7","7","Moroa ni Loorong Silok ti limixin axap at na lavatbung menemen. Mina emi asu min mi livikpixan! ");
INSERT INTO mmx_vpl VALUES ("PS47_8","020_47_8","PSA","47","8","8","Moroa it kis to at loxonin orong teren i melemelengan, la im gomgonga larabung mixin axap. ");
INSERT INTO mmx_vpl VALUES ("PS47_9","020_47_9","PSA","47","9","9","Luvuttadi amgomgo atdi di vot eburu mi limixin at lo Moroa at ne Abaram. Lolos teren i volo lolos atnedi axap limixin esep at na lavatbung menemen. Ni Loorong i silok aleng ti lavaorong axap. ");
INSERT INTO mmx_vpl VALUES ("PS48_1","020_48_1","PSA","48","1","1","Leeme Silok i silok aleng. Ni ne Moroa atdik la i lox avukat aleng do ata emi asu amisik min to xeneng at lemenemen silok la at loxongkaana kaala ren. ");
INSERT INTO mmx_vpl VALUES ("PS48_2","020_48_2","PSA","48","2","2","Saion neni mo lakaana at ne Moroa, no xa it kis kasep pana la i maraanu aleng. Ni lemenemen silok at Loorong Silok, ik lox amomo limixin axap at na lavatbung menemen. ");
INSERT INTO mmx_vpl VALUES ("PS48_3","020_48_3","PSA","48","3","3","Moroa gara lox ase limixin do dinaba nemen avukat mene ro xeneng at laraogu matmatkun at na lemenemen silok. ");
INSERT INTO mmx_vpl VALUES ("PS48_4","020_48_4","PSA","48","4","4","Lavaorong silok eburu mi limixin esep atdi diga vot buru la diga lok do dina esep polo limixin boro at lakaana Saion. ");
INSERT INTO mmx_vpl VALUES ("PS48_5","020_48_5","PSA","48","5","5","Ketla diga ven mo lakaana la diga sangu aleng, diga marat la diga sixiro. ");
INSERT INTO mmx_vpl VALUES ("PS48_6","020_48_6","PSA","48","6","6","Diga dede xapmek tino mi lanmarat, la diga lingun, ngan ta latkin i gagas kusu na visik. ");
INSERT INTO mmx_vpl VALUES ("PS48_7","020_48_7","PSA","48","7","7","Lodoxoma atdi gak sixit saasaa ngan lempatmon dik sixit ekarakat to at laras keneng at langsangan lamanman. ");
INSERT INTO mmx_vpl VALUES ("PS48_8","020_48_8","PSA","48","8","8","Nema magara ronga vam levelinga at levempanga sangsangu ne Moroa gak lox i, la mara ven pam i ro at lemenemen silok at ne Moroa atnema. Ni Leeme Silok la Lanaraavuk, naba lok tatao amisik mo lemenemen silok at levenaleng axap i tu melamgo. ");
INSERT INTO mmx_vpl VALUES ("PS48_9","020_48_9","PSA","48","9","9","O Moroa, to xeneng at loogu laplavang taram ma doma asu at langsangan labalamu lexen taram. ");
INSERT INTO mmx_vpl VALUES ("PS48_10","020_48_10","PSA","48","10","10","Limixin at levengkot axap di emi asu aleng minu, la limixin at levengkot axap at na lavatbung menemen dira ronga levelinga mumu u. Nenu um gomgonga limixin mi levelinga manmanton. ");
INSERT INTO mmx_vpl VALUES ("PS48_11","020_48_11","PSA","48","11","11","Kuren la limixin axap di nemen to at lakaana Saion dina momo! Nu ung tonga linga mi lodoxoma mokmokso. Kuren la limixin axap boro at levengkot silok Juda dina momo. ");
INSERT INTO mmx_vpl VALUES ("PS48_12","020_48_12","PSA","48","12","12","Nemi limixin at ne Moroa, mina vas kangkan lemenemen Saion, la mina exes laraogu likling i baalom upana. ");
INSERT INTO mmx_vpl VALUES ("PS48_13","020_48_13","PSA","48","13","13","Mina ven katling axap larangas uat la mina reven anga bok laraogu matmatkun, kusu minaba tong avolo i rinedi lavaola melemu. ");
INSERT INTO mmx_vpl VALUES ("PS48_14","020_48_14","PSA","48","14","14","Mina tong i ridi do na ne Moroa, neni ne Moroa atnedik at levenaleng axap i tu melamgo. Ni nabam gomgonga dik at levenaleng axap naba vot melemu. ");
INSERT INTO mmx_vpl VALUES ("PS49_1","020_49_1","PSA","49","1","1","Nemi axap, mina ronga ka i na! Limixin at levengkot axap, mina ronga xaka i na. ");
INSERT INTO mmx_vpl VALUES ("PS49_2","020_49_2","PSA","49","2","2","Nemi limixin amgomgo mi limixin gamasa, limixin apnovos eburu mi limixin banbalo, mina ronga xaka i na. ");
INSERT INTO mmx_vpl VALUES ("PS49_3","020_49_3","PSA","49","3","3","Lodoxoma rak naba xasep tinimi, la nia anaba vaase asu levelinga ri raba nimi mi lodoxoma avukat. ");
INSERT INTO mmx_vpl VALUES ("PS49_4","020_49_4","PSA","49","4","4","Nia anaba vaase asu levelinga voovo, la anaba soxomus bok lavasuun teren do anak pixan eburu mi loxontaaleng. Lavapaase rak i lok keretna. ");
INSERT INTO mmx_vpl VALUES ("PS49_5","020_49_5","PSA","49","5","5","Nia xopmen anak marat ti ekip tangarang mi levenmumuat, at loxonaleng limixin munepen minia di ru kangkan ia. ");
INSERT INTO mmx_vpl VALUES ("PS49_6","020_49_6","PSA","49","6","6","Mo limixin kakapmek di nunua i do dinaba ruuna ka lorooro nunuan mumu laxampanga solo atdi la dim simi xaka di at leven apnovos atdi la dik lox aru ka bok di. ");
INSERT INTO mmx_vpl VALUES ("PS49_7","020_49_7","PSA","49","7","7","Ketla laradi ixo epovo ri ru korop ti lorooro axa ren, ixo epovo ri ru korop tin mi tuunun ti ne Moroa. ");
INSERT INTO mmx_vpl VALUES ("PS49_8","020_49_8","PSA","49","8","8","Atla luunun ti lorooro at laradi i silok aleng. Lavanga salai i vara na unun i min noxo epovo rinotno, ");
INSERT INTO mmx_vpl VALUES ("PS49_9","020_49_9","PSA","49","9","9","ri lox aase i basinge lamaaut, la ni naba roo avolo. ");
INSERT INTO mmx_vpl VALUES ("PS49_10","020_49_10","PSA","49","10","10","Limixin axap di reven i do luvuttadi akleklen bok di remet, ngan bok luvuttadi rangtangku mi luvuttadi baulang. Nedi axap dinaba met basinge levenapnovos atdi la levempipisik li atdi dinaba ruuna xaka i. ");
INSERT INTO mmx_vpl VALUES ("PS49_11","020_49_11","PSA","49","11","11","Levenmaaut atdi naba lok ngan levenmenemen avolo atnedi. At levenaleng axap i tu melamgo dinaba nemen di e, keke i do diga ruuna lengkongkangka. ");
INSERT INTO mmx_vpl VALUES ("PS49_12","020_49_12","PSA","49","12","12","Lixitkis silok at laradi noxo lox asepsu i basinge lanmet. Ni naba met bok ngan levempanga mi lavanuet kangkedek. ");
INSERT INTO mmx_vpl VALUES ("PS49_13","020_49_13","PSA","49","13","13","Limixin di nunu saga atnedi xa, diba ekip tangarang mi lavanga salai mo? Lanmet ni laxavaxap atnedi. Di momo gamasa mene mi leven apnovos atdi. ");
INSERT INTO mmx_vpl VALUES ("PS49_14","020_49_14","PSA","49","14","14","Lanmet naba mumu asu di, la dinaba met ngan lubung sipsip. Limixin manmanton dinabat kis silok polo di, atla nedi limixin kapmek dinaba nemen to at lemenemen at labarongan. La levenbaaxin tadi atnedi nabap sopso soso ro vaxalom basinge lara menemen aulis atnedi. ");
INSERT INTO mmx_vpl VALUES ("PS49_15","020_49_15","PSA","49","15","15","Ketla ne Moroa naba lox asepsu ia, ni naba lox asepsu ia basinge lolos at lanmet. ");
INSERT INTO mmx_vpl VALUES ("PS49_16","020_49_16","PSA","49","16","16","Nemen gat uta doxoma mu solo i do tara napnovos, la dola lapnovos teren na sisilok. ");
INSERT INTO mmx_vpl VALUES ("PS49_17","020_49_17","PSA","49","17","17","Neni noxo xip kaka mo lapnovos eburu min dola ni na met. Lapnovos teren noxo emu min ti lorooro melemu. ");
INSERT INTO mmx_vpl VALUES ("PS49_18","020_49_18","PSA","49","18","18","Keke i do tara i ruuna lomomo at na lorooro. La keke i do limixin di emi asu min dola ni laradi nopnovos. ");
INSERT INTO mmx_vpl VALUES ("PS49_19","020_49_19","PSA","49","19","19","Ni naba vot pasa lavalabat teren at lanmet, ap mo loxot lamain bonot kopmen noxo xap, ketla naba nemen amisik. ");
INSERT INTO mmx_vpl VALUES ("PS49_20","020_49_20","PSA","49","20","20","Lixitkis silok at taradi noxo lox asepsu i basinge lanmet. Neni naba met bok ngan levempanga mi lavanuet kangkedek. ");
INSERT INTO mmx_vpl VALUES ("PS50_1","020_50_1","PSA","50","1","1","Lanaraavuk, neni Leeme Silok ne Moroa i paase. Ni i toro ri limixin axap at na lavatbung menemen i ruka i at loxot laxangking it losu e la i se ro at loxot laxangking it los tuv e. ");
INSERT INTO mmx_vpl VALUES ("PS50_2","020_50_2","PSA","50","2","2","Lisisixam at ne Moroa i soosoo su boro Saion, lemenemen silok i nunuan axap la i milik maraanu rino. ");
INSERT INTO mmx_vpl VALUES ("PS50_3","020_50_3","PSA","50","3","3","Moroa atnedik nom boro naba vot, ketla ni noxo vot atnaasan. Laxao bokbolot nabam gomgo rin, eburu mi langsangan lamanman bet nabak lok kangkan i. ");
INSERT INTO mmx_vpl VALUES ("PS50_4","020_50_4","PSA","50","4","4","Ni naba ro ka laxalibet mi lavatbung menemen kusu dunaba ru rin la duna reven i na ila mumu loklok at limixin teren. ");
INSERT INTO mmx_vpl VALUES ("PS50_5","020_50_5","PSA","50","5","5","Moroa i lok, “Muna lok bubua raba ia mi limixin tuturun tarak. Nedi nom diga lok lekabus eburu minia at loxonaleng digaplavang tia.” ");
INSERT INTO mmx_vpl VALUES ("PS50_6","020_50_6","PSA","50","6","6","Laxalibet i tong asuusu i do ne Moroa neni Laradi Manmanton, la neni xa laradi rongtonga linga. ");
INSERT INTO mmx_vpl VALUES ("PS50_7","020_50_7","PSA","50","7","7","Moroa i lok keretna, “Limixin tarak, mina ronga ia ana vaase. Nia anaba ruuna tevelinga rinemi, limixin tarak me Israel. Nia ne Moroa, la Moroa atnemi. ");
INSERT INTO mmx_vpl VALUES ("PS50_8","020_50_8","PSA","50","8","8","Nia anoxo vaase sok nimi mumu levelaplavang atnemi la leventamtaba bok mi kotos asonao amisix i ria. ");
INSERT INTO mmx_vpl VALUES ("PS50_9","020_50_9","PSA","50","9","9","Axok pakes bok ti mo leven bulumaxao temes boro at laraogu bulumaxao atnemi kopla mo levenme boro at levenmenemen atnemi. ");
INSERT INTO mmx_vpl VALUES ("PS50_10","020_50_10","PSA","50","10","10","Atla levempanga axap di ruuna lavanuet kangkedek di nemen at laxairing, atarak axap, eburu mi laxan bulumaxao at lasangaun larabin sangsangaun kobot (1000) kaana. ");
INSERT INTO mmx_vpl VALUES ("PS50_11","020_50_11","PSA","50","11","11","Lavapixa eburu mi levempanga axap di rooro ro xolonu, ni atarak kusuk. ");
INSERT INTO mmx_vpl VALUES ("PS50_12","020_50_12","PSA","50","12","12","Dola nia gita roxo, nia gitoxo sing nimi ri toxompanga anan, atla lavatbung menemen mi levempanga axap keneng teren, ni atarak kusuk. ");
INSERT INTO mmx_vpl VALUES ("PS50_13","020_50_13","PSA","50","13","13","Nia xopmen ana anan levenuut bulumaxao temes kopla ana inin levenda meme. ");
INSERT INTO mmx_vpl VALUES ("PS50_14","020_50_14","PSA","50","14","14","Loklok ti tong avukat, ni lagale laramtaba atnemi ria, ne Moroa. La mina raba nenia Lanaraavuk mi levempanga migara xaape vam i. ");
INSERT INTO mmx_vpl VALUES ("PS50_15","020_50_15","PSA","50","15","15","Naba lox avukat do mina ro ke rak mo do mina ekip tangarang mi levenmumuat, la anaba lox asepsu nemi, la minaba raba asinorong ia.” ");
INSERT INTO mmx_vpl VALUES ("PS50_16","020_50_16","PSA","50","16","16","Ketla ne Moroa i tong i ri limixin kakapmek keretna, “Kopmen tavasuun teren la nemi mi utus empampana axap Laulis Linga rak. La kopmen tavasuun teren la nemi mi vepaase mumu lekabus tarak, ");
INSERT INTO mmx_vpl VALUES ("PS50_17","020_50_17","PSA","50","17","17","atla mi ven abulubun kepe lavapaase sok tarak la mik sok sisixe bok leventaangas tarak. ");
INSERT INTO mmx_vpl VALUES ("PS50_18","020_50_18","PSA","50","18","18","Mi etangas mi luvuttadi xipkip pilo, la mi vemu eburu mi limixin longlongka. ");
INSERT INTO mmx_vpl VALUES ("PS50_19","020_50_19","PSA","50","19","19","Amisik mi vavara na paase xapmek, la soso mun mi tong asu levelinga xaxarang. ");
INSERT INTO mmx_vpl VALUES ("PS50_20","020_50_20","PSA","50","20","20","Amisik mi gagas tik lok li luvutneton nimi at lavapapaase, la mira lele asu bok atdi. ");
INSERT INTO mmx_vpl VALUES ("PS50_21","020_50_21","PSA","50","21","21","Miga lok na levempanga axap, ketla nia a goxo tong toxolinga, la miga doma i do nia a lok ngan nimi. Ketla nanga ana paase sok nimi la ana lox asuvos nemi at lavapaase. ");
INSERT INTO mmx_vpl VALUES ("PS50_22","020_50_22","PSA","50","22","22","Nemi mim taba sinta ia, mina ronga i na. Naba lok kapmek do nia ana vaxat lalais nemi, la kopmen bok ba tara go naba lox asepsu nemi. ");
INSERT INTO mmx_vpl VALUES ("PS50_23","020_50_23","PSA","50","23","23","Loklok ti tong avukat, ni lagale laramtaba ip kip aurut laasen tarak, la nia anaba lox asepsu rinotno nedi di ronga res tarak.” ");
INSERT INTO mmx_vpl VALUES ("PS51_1","020_51_1","PSA","51","1","1","O Moroa, una lox asuusu lebelen tuntun taram tia, mumu nom labalamu lexen taram. Una ves kepe leveloklok kakapmek tarak atla nenu u umsu mi langsangan lebelemulus. ");
INSERT INTO mmx_vpl VALUES ("PS51_2","020_51_2","PSA","51","2","2","Una gos kepe axap libilinga rak la una lox amaxar ia basinge leveloklok kakapmek tarak! ");
INSERT INTO mmx_vpl VALUES ("PS51_3","020_51_3","PSA","51","3","3","Nia ara ven kisip pam i do lavasuun teren atarak. La aklen amisix i do nenia lavanga bilinga. ");
INSERT INTO mmx_vpl VALUES ("PS51_4","020_51_4","PSA","51","4","4","Nia agara lok pam libilinga ru, tu xusuk mun la aga lok lempanga ua nenu u tong i mi laxakapmek. Kuren la ik mokso do una ila mumu lorooro rak, la ik mokso bok do una tong i do nenia laradi xapmek. ");
INSERT INTO mmx_vpl VALUES ("PS51_5","020_51_5","PSA","51","5","5","Nia aga xapmek, tuka xa i at laaleng diga visix ia ren. Kovisi ne naga ga visix ia nia agara xapmek pam. ");
INSERT INTO mmx_vpl VALUES ("PS51_6","020_51_6","PSA","51","6","6","Nenu u vavara limixin kusu dina umsu mi lununuan mi levelinga ruturun taram. Una suxa aumsu lodoxoma rak mi lodoxoma avukat taram. ");
INSERT INTO mmx_vpl VALUES ("PS51_7","020_51_7","PSA","51","7","7","Una ves kepe libilinga rak, kusu nia ana dadat. Una gos amaxar ia, kusu nia anaba dadat ngan labantamon bunbun tino. ");
INSERT INTO mmx_vpl VALUES ("PS51_8","020_51_8","PSA","51","8","8","Nia a vara i xusu ana ronga limixin dina lok momo mi leklek. Keke i do ugara lox asi aleng pam ia, uga lox amenemen pam lodoxoma rak, nia anaba momo manga. ");
INSERT INTO mmx_vpl VALUES ("PS51_9","020_51_9","PSA","51","9","9","Una vampe luxatli ram kusu unoxo ven libilinga rak, la una ves kepe axap laxakapmek tarak. ");
INSERT INTO mmx_vpl VALUES ("PS51_10","020_51_10","PSA","51","10","10","O Moroa, una lox amaxat labalak, la una lox aumsu lorooro rak mi lodoxoma maxat mo ik mokso la i ruturun tu. ");
INSERT INTO mmx_vpl VALUES ("PS51_11","020_51_11","PSA","51","11","11","Nemen gat uta sok gingin kepe ia, lavanga ana nemen paxalom basinge u. Nemen bok uta lok kepe Loroonan Kaala ram basinge ia. ");
INSERT INTO mmx_vpl VALUES ("PS51_12","020_51_12","PSA","51","12","12","Una raba amlong manga ia mi nom lomomo at loklok tooro ram, la una lok lodoxoma rak kusu ana vavara ri ronga res taram. ");
INSERT INTO mmx_vpl VALUES ("PS51_13","020_51_13","PSA","51","13","13","Melemu nia anaba lox ase limixin kapmek mi leventaangas taram, la dinaba rem gili bilong mu u. ");
INSERT INTO mmx_vpl VALUES ("PS51_14","020_51_14","PSA","51","14","14","O Moroa, una lok tooro ia xusu nia anoxo met atla nenu Laradi Loklox Asepsu rak. La nia anaba tong asu ba loklok manmanton taram mi lomomo. ");
INSERT INTO mmx_vpl VALUES ("PS51_15","020_51_15","PSA","51","15","15","Una siam do ana vaase asu lavapaase emi asu ru, la nia anaba emi asu minu. ");
INSERT INTO mmx_vpl VALUES ("PS51_16","020_51_16","PSA","51","16","16","Nenu xopmen una vavara ri leventaba lempanga mabap lavang min. La kopmen bok una lok momo mi levempanga ma kotos asonao i ru. Kuren la anoxo raba u mi levelaplavang. ");
INSERT INTO mmx_vpl VALUES ("PS51_17","020_51_17","PSA","51","17","17","O Moroa, a lox akalix ia la a nemen maxopok taram. Nom i ni laramtaba rak tu. Nia aklen i do, nenu uxo epovo una sok sisixe laradi i lox akalix i maxopok taram la i ven kibis libilinga ren. ");
INSERT INTO mmx_vpl VALUES ("PS51_18","020_51_18","PSA","51","18","18","O Moroa, una balamu limixin me Saion la una lok tooro di. Una ii aurut amu levenngas uat to Jerusalem. ");
INSERT INTO mmx_vpl VALUES ("PS51_19","020_51_19","PSA","51","19","19","Kuren la unaba lok momo mi levelaplavang atnema manaba xotos axav i ru kerekngan uga tong i. La leven bulumaxao temes manabap lavang min tu rovana at loxonin laplavang taram. ");
INSERT INTO mmx_vpl VALUES ("PS52_1","020_52_1","PSA","52","1","1","Nu laradi silok, ixo lox avukat do um simi u at laxapmek taram, la mumu bok mo lempanga xapmek uk lox i ri limixin at ne Moroa. ");
INSERT INTO mmx_vpl VALUES ("PS52_2","020_52_2","PSA","52","2","2","U gagas li leventaangas ti lok kapmek leventaba vetpes. Levelinga ram ing sengsen ngan loxonise. Nenu u puse ngas amisik ti xaxarang. ");
INSERT INTO mmx_vpl VALUES ("PS52_3","020_52_3","PSA","52","3","3","Nenu u vavara aleng ti laxakapmek la u ke xepe luvukat. U vavara aleng ti levelinga xaxarang la u ke xepe levelinga ruturun. ");
INSERT INTO mmx_vpl VALUES ("PS52_4","020_52_4","PSA","52","4","4","Nenu laradi xaxarang, u vavara aleng do unak lox asongot mene limixin mi laxalinga xaxarang taram! ");
INSERT INTO mmx_vpl VALUES ("PS52_5","020_52_5","PSA","52","5","5","Kuren la ne Moroa noxo xap ti lok kapmek amisik tino u. Ni ba ranga alis ka u la ni naba saksu minu basinge loogu ram. La ni naba lox axap tino lorooro ram la unoxo nemen bok ba at lemenemen at limixin di rooro. ");
INSERT INTO mmx_vpl VALUES ("PS52_6","020_52_6","PSA","52","6","6","Limixin manmanton dinaba ven i na la dinaba lingun. La dinabang longon arup u la diba lok do, ");
INSERT INTO mmx_vpl VALUES ("PS52_7","020_52_7","PSA","52","7","7","“Mina ven ba na laradi goxo vara i do ne Moroa na lok see ren. Ketla ni ga nunu saga at lapnovos silok teren, la ga nunua i do loklok kakapmek naba lox aulis i.” ");
INSERT INTO mmx_vpl VALUES ("PS52_8","020_52_8","PSA","52","8","8","Ketla nenia a lok ngan luuna Olip i suusu avukat to xeneng at loogu at ne Moroa. Nia a nunu saga at labalamu lexen teren naba nemen amisik la noxo xap. ");
INSERT INTO mmx_vpl VALUES ("PS52_9","020_52_9","PSA","52","9","9","Nia anaba tong loklox avukat amisik tu, ne Moroa, ti lempanga axap ugara lok pam i. Nia anaba tong asu i do nenu u lox avukat to melamgo at limixin taram. ");
INSERT INTO mmx_vpl VALUES ("PS53_1","020_53_1","PSA","53","1","1","Mo limixin di doma i do, “Kopmen tomoroa go i rooro.” Nedi limixin tangtangku. Lodoxoma atnedi i bilingot axap tino mi laxakapmek. La dira lok pam levempanga ik lok kapmek aleng tinotno, kopmen tara atdi na lok levempanga i nunuan. ");
INSERT INTO mmx_vpl VALUES ("PS53_2","020_53_2","PSA","53","2","2","Leeme Silok ik milik si boro vana at lebelen laxalibet, la i reven limixin axap, do ni naba epovo ri ven kaka taradi leklen la tara bok i lotu saparav i. ");
INSERT INTO mmx_vpl VALUES ("PS53_3","020_53_3","PSA","53","3","3","Ketla nedi axap digara oon soogong pam, lorooro atnedi axap ira mau axap pam. Kopmen tinotno tara atdi ik lok lempanga i lox avukat, kopmen tinotno tegesara. ");
INSERT INTO mmx_vpl VALUES ("PS53_4","020_53_4","PSA","53","4","4","Moroa i sue xeretna, “Kereva, kopmen dinaklen leventaangas nunuan? Kereva, nedi axap na dik lok laxakapmek, kopmen takleklen atdi? Dip kip pilo amisik limixin tarak, la kopmen tinotno dina ngising tia.” ");
INSERT INTO mmx_vpl VALUES ("PS53_5","020_53_5","PSA","53","5","5","Ketla melemu dinaba lingun aleng tino, at nom lanmarat kovisi di goxo suma i gano, atla ne Moroa naba sax epeseves levesi at limixin di munepen mi limixin teren. Moroa ira sok sisixe kepe vam di. Kuren la limixin me Israel dinaba sak tup tino midi. ");
INSERT INTO mmx_vpl VALUES ("PS53_6","020_53_6","PSA","53","6","6","Nia a vara aleng tinotno i do ne Moroa naba sak tiki tara boro Saion, kusu na lox asepsu limixin me Israel basinge limixin munepen midi. Melemu limixin me Israel dinaba lok momo do ne Moroa naba lox asang kobot amu manga di! ");
INSERT INTO mmx_vpl VALUES ("PS54_1","020_54_1","PSA","54","1","1","O Moroa, una lox asepsu ia mi lolos taram, una lox asepmus ia basinge limixin munepen minia. ");
INSERT INTO mmx_vpl VALUES ("PS54_2","020_54_2","PSA","54","2","2","O Moroa, una ronga lising tarak, una ronga ka levelinga rak. ");
INSERT INTO mmx_vpl VALUES ("PS54_3","020_54_3","PSA","54","3","3","Limixin loklox aaso di lok do dina esep minia. La limixin sepsep di lok tong pen i do dina sev amer ia. Nedi mo limixin, kopmen dina doma solo ne Moroa. ");
INSERT INTO mmx_vpl VALUES ("PS54_4","020_54_4","PSA","54","4","4","Ketla i ruturun tinotno do ne Moroa ni Laradi Loklok Tooro rak. Leeme silok, ni Lentupe ria. ");
INSERT INTO mmx_vpl VALUES ("PS54_5","020_54_5","PSA","54","5","5","Nia a vara aleng i do ne Moroa na vorang taba amlong di mi laxakapmek diga lox i ria. La ni naba sele utut kepe axap di. Atla neni laradi ik lox asoorun leveng kakaape ren. ");
INSERT INTO mmx_vpl VALUES ("PS54_6","020_54_6","PSA","54","6","6","O Leeme Silok, nia anaba lok letaba ru mi lomomo. Nia anaba tong loklox avukat tu atla nenu u lox avukat tinotno. ");
INSERT INTO mmx_vpl VALUES ("PS54_7","020_54_7","PSA","54","7","7","Uga lox asepsu ia basinge laxanmumuat axap tarak. La nia aga reven u, ugak sak tup tino mi limixin munepen minia. ");
INSERT INTO mmx_vpl VALUES ("PS55_1","020_55_1","PSA","55","1","1","O Moroa, una ronga na levelinga rak. Nemen uta ronga aie xepe lisingising tarak. ");
INSERT INTO mmx_vpl VALUES ("PS55_2","020_55_2","PSA","55","2","2","Una ronga lising tarak la una vaase porang ia. Levenmumuat i lok kapmek tino lorooro rak. ");
INSERT INTO mmx_vpl VALUES ("PS55_3","020_55_3","PSA","55","3","3","Labantuxu rak i marat aleng atla limixin munepen minia di kiilu ia. Na limixin kapmek di lok do dina sev amdamda ia mi levenmumuat. Di musax ia la di belengatngas bok tia. ");
INSERT INTO mmx_vpl VALUES ("PS55_4","020_55_4","PSA","55","4","4","Kuren la nia a marat kapmek tinotno, la lanmarat at lanmet i suxuna ia la lavarampen abulubun ta ia na. ");
INSERT INTO mmx_vpl VALUES ("PS55_5","020_55_5","PSA","55","5","5","Nia a suma rino langsangan lanmarat la a dede. Lanmarat i suxa aumsu lorooro rak. ");
INSERT INTO mmx_vpl VALUES ("PS55_6","020_55_6","PSA","55","6","6","A vara rino i do nia di ruuna tuvapa ngan at lamno. Nia giba rava kaxat uto at loxot petpes, la lodoxoma rak dira lok mamana. ");
INSERT INTO mmx_vpl VALUES ("PS55_7","020_55_7","PSA","55","7","7","Nia diba rava uto vaxalom kusu ana nemen mimila ro at lamatbin. ");
INSERT INTO mmx_vpl VALUES ("PS55_8","020_55_8","PSA","55","8","8","Nia diba lok soso ri vuse ka toxot ti lipe, at langsangan lasaii mi lamanman bet. ");
INSERT INTO mmx_vpl VALUES ("PS55_9","020_55_9","PSA","55","9","9","O Leeme Silok, una lox ekarakat levelinga axa atnedi limixin munepen minia. Nia a reven limixin di esep keneng at lemenemen silok, la di lok kapmek tino limixin. ");
INSERT INTO mmx_vpl VALUES ("PS55_10","020_55_10","PSA","55","10","10","At levenaleng kangking la kanimin nia a reven di, dit pas saasaa ro at lengkot axap la dik lok leveloklok mamangan la dik paxaru kaxat buaang laxan ekarakat. ");
INSERT INTO mmx_vpl VALUES ("PS55_11","020_55_11","PSA","55","11","11","Leeteke ik lok at levengkot axap. Larangas axap i umsu mi loklok papavas mi laxaxarang ka levempanga at leventaba vetpes. ");
INSERT INTO mmx_vpl VALUES ("PS55_12","020_55_12","PSA","55","12","12","Dola tara at limixin munepen minia na lok kalise kapmex ia, i epovo do nia noxo doxoma solo i. Dola ni natlas i mavana rak, nia giba tu asepsu basinge i. ");
INSERT INTO mmx_vpl VALUES ("PS55_13","020_55_13","PSA","55","13","13","Ketla nenu mun, lentangas tarak, nenu xa uga lok na leveloklok kakapmek tia. Gano neda tagat kis esogo amisik la taga emu eburu, ketla uga lok na lavanga ria. ");
INSERT INTO mmx_vpl VALUES ("PS55_14","020_55_14","PSA","55","14","14","Amisik neda taga etangas mi lavapaase la taga lotu buru vam to at loogu laplavang. ");
INSERT INTO mmx_vpl VALUES ("PS55_15","020_55_15","PSA","55","15","15","Nia a vara aleng i do limixin munepen minia dinaba mer avot ti loxonaleng meremet, no ne Moroa ga vit li i ridi. Nia a vara i do dinat pas uto at lemenemen at labarongan ngan limixin move di rooro, atla laxakapmek i umsu rino xeneng at lebelen di la keneng bok at laraogu atnedi. ");
INSERT INTO mmx_vpl VALUES ("PS55_16","020_55_16","PSA","55","16","16","Ketla nenia a ro ke at Leeme Silok ne Moroa ri loklok tooro, la ni naba lox asepsu ia. ");
INSERT INTO mmx_vpl VALUES ("PS55_17","020_55_17","PSA","55","17","17","At lenmaxantamak suubu, at levenaleng kangking la at levenaleng kanimin, nia a velevanga mi levesingising lolos tarak mo i turut saparav i, la ni naba ronga ia. ");
INSERT INTO mmx_vpl VALUES ("PS55_18","020_55_18","PSA","55","18","18","Ni naba lox amlong avukar ia ap mo levenesep nia a vesep teren, la kopmen tepanga naba sep kapmex ia, kantubu atnedi buaang limixin munepen minia. ");
INSERT INTO mmx_vpl VALUES ("PS55_19","020_55_19","PSA","55","19","19","Moroa im gomgonga na lavatbung menemen, ga ruka axa i ganoxa at lereot, la ni naba ronga ia la ni naba sak tup midi. Atla di xopara na repukus, la kopmen dina marat teren. ");
INSERT INTO mmx_vpl VALUES ("PS55_20","020_55_20","PSA","55","20","20","Mo laradi nia aga vemu min, ga esep eburu mi larapentangas teren, ga los polo leveng kakaape ren. ");
INSERT INTO mmx_vpl VALUES ("PS55_21","020_55_21","PSA","55","21","21","Levelinga ren ga nunuan aleng, ketla lebelengatngas ga umsu at lebelen. Levelinga ren gang sengsen ngan lavarise esep, keke levelinga ren ga reng nunuan mun. ");
INSERT INTO mmx_vpl VALUES ("PS55_22","020_55_22","PSA","55","22","22","Una ke raba Leeme Silok mi laxanmumuat taram, ni naba tupe u. Ni xopmen na ke xepe limixin manmanton kusu limixin petpes dina sak tup midi. ");
INSERT INTO mmx_vpl VALUES ("PS55_23","020_55_23","PSA","55","23","23","Ketla nenu, O Moroa, unaba lam bubua ka limixin sepsev amet mi limixin kaxarang uto xopok at levenmaaut atnedi at loxonaleng move di aau, la kovisi na epovo rinedi ri met. Ketla nenia, ana nunu saga ram. ");
INSERT INTO mmx_vpl VALUES ("PS56_1","020_56_1","PSA","56","1","1","O Moroa, una lox asuusu lebelen tuntun tia, atla nia na a nemen at leesep. Limixin munepen minia dik lox asongot amisix ia. ");
INSERT INTO mmx_vpl VALUES ("PS56_2","020_56_2","PSA","56","2","2","At levenaleng kudun axap limixin munepen minia di esep tangarang minia. Buaang nedi di vesep eburu minia. ");
INSERT INTO mmx_vpl VALUES ("PS56_3","020_56_3","PSA","56","3","3","Nu Leeme Silok, nu Lanaraavuk. Dola nia ana marat, ana nunu saga mun taram. ");
INSERT INTO mmx_vpl VALUES ("PS56_4","020_56_4","PSA","56","4","4","Nia a nunu saga at ne Moroa la axo marat. Nia a emi asu min atla ni naba lox epovo mo levempanga ni ga xaape min. Ixo epovo rinotno xusu limixin mun diba lok tavanga xapmek tia. ");
INSERT INTO mmx_vpl VALUES ("PS56_5","020_56_5","PSA","56","5","5","Limixin munepen minia dip sev ia mi levenmumuat at levenaleng kudun axap. Dim doma agagas li amisik leventaangas kusu dina lox asongor ia. ");
INSERT INTO mmx_vpl VALUES ("PS56_6","020_56_6","PSA","56","6","6","Dit pot buru ri kuxut tangais ia at levengkot lipe, la di reven levempanga axap nia ak lox i, la dit kis tangais ia do dina sev amer ia. ");
INSERT INTO mmx_vpl VALUES ("PS56_7","020_56_7","PSA","56","7","7","O Moroa, una lox asongot di, mumu loklok kakapmek atnedi. Una lox asuusu lebelemamao ram la una sak tup midi mi lolos taram. ");
INSERT INTO mmx_vpl VALUES ("PS56_8","020_56_8","PSA","56","8","8","Ukleklen i do nia a xip tutu mi levenmumuat. Nenu ugak lok katling leveng kamkabili dan ga sesen su at luxatli rak. A doma i do uga malagan li i at lubuk taram. ");
INSERT INTO mmx_vpl VALUES ("PS56_9","020_56_9","PSA","56","9","9","At laaleng nia ana xup tu, limixin munepen minia dinaba oo bilong. Legesa vanga mun nia akleklen i, Moroa i tu tooro ia. ");
INSERT INTO mmx_vpl VALUES ("PS56_10","020_56_10","PSA","56","10","10","Nia a emi asu mi Leeme Silok mumu leveng kakaape ren. ");
INSERT INTO mmx_vpl VALUES ("PS56_11","020_56_11","PSA","56","11","11","Nia a nunu saga mun teren, la nia anoxo marat at tempanga. Ixo epovo rinotno xusu limixin mun at na lavatbung menemen diba lok tavanga xapmek tia. ");
INSERT INTO mmx_vpl VALUES ("PS56_12","020_56_12","PSA","56","12","12","O Moroa, nia anabam taba u mi levempanga aga xaape min tu. Nia anaba raba u mi laramtaba ti lox asuusu lorotong avukat tu. ");
INSERT INTO mmx_vpl VALUES ("PS56_13","020_56_13","PSA","56","13","13","Atla uga lox asepsu ia basinge lanmet, la uga lok tooro ia la limixin munepen minia di goxo sak tup minia. Kuren la nia anabat pas maxopok at loklok tatao at ne Moroa. Neni ik lox axasep lodoxoma at limixin kusu dina rooro. ");
INSERT INTO mmx_vpl VALUES ("PS57_1","020_57_1","PSA","57","1","1","O Moroa, una lox asuusu lebelen tuntun tia. Una lox asuusu lebelen tuntun tia, atla nia a vot pasa u xusu unak lok see rak basinge limixin munepen minia. Una kok avukar ia maxopok at lamamau at luvapa ram. Una lok ngan Lenban tia, se at nom laaleng na levenmumuat axap na on basinge ia. ");
INSERT INTO mmx_vpl VALUES ("PS57_2","020_57_2","PSA","57","2","2","Nia a toro ri ne Moroa, ni Leeme Avolo, mo im taba ia mi lempanga axap nia ak pakes tin. ");
INSERT INTO mmx_vpl VALUES ("PS57_3","020_57_3","PSA","57","3","3","Ni naba vaase porang ia boro vana at laxalibet la naba lox asepsu ia. Ni naba sev asi axap limixin loklok papavas. Moroa naba lox asuusu mo labalamu lexen la loklok tuturun teren tia. ");
INSERT INTO mmx_vpl VALUES ("PS57_4","020_57_4","PSA","57","4","4","Nia ak lok kantubu at limixin munepen minia di lok ngan lubunglaion. Di lok gagas kusu dina sev amet limixin la dina anan di. Leven gisangsa atnedi i anan ngan ta lempatsoso, la leven gam atnedi i anan ngan ta lemparise esep. ");
INSERT INTO mmx_vpl VALUES ("PS57_5","020_57_5","PSA","57","5","5","O Moroa, una lox asuusu lolos silok taram to vana at lamavangkap, la una lox asuusu lisisixam taram at levengkot axap at na lavatbung menemen. ");
INSERT INTO mmx_vpl VALUES ("PS57_6","020_57_6","PSA","57","6","6","Limixin munepen minia dira sat pam laxatkat kusu dina rebeng alis kaka ia. Lorooro rak i umsu mi levenmumuat i sak pavaa ia. Diga sep pe langas patpas tarak mi lavatmet i si aleng, ketla nedi xa diga subu tup teren. ");
INSERT INTO mmx_vpl VALUES ("PS57_7","020_57_7","PSA","57","7","7","O Moroa, nia a nunu saga rinotno ram, nia anabak pixan emi asu minu. ");
INSERT INTO mmx_vpl VALUES ("PS57_8","020_57_8","PSA","57","8","8","Lodoxoma rak, una xapsik. Nia ana gagas li loxontaaleng tarak mi ligita. Nia anaba sak aus laxangking at labara kooxot mi loxompixan. ");
INSERT INTO mmx_vpl VALUES ("PS57_9","020_57_9","PSA","57","9","9","O Leeme Silok, nia anaba tong loklox avukat tu ro melamgo at larabung mixin axap. Nia anabak pixan emi asu minu ro melamgo at limixin axap. ");
INSERT INTO mmx_vpl VALUES ("PS57_10","020_57_10","PSA","57","10","10","Labalamu lexen taram i umsu aleng upana i se axa ro at laxalibet. Loklok tuturun taram tinama i se tu at lamavangkap. ");
INSERT INTO mmx_vpl VALUES ("PS57_11","020_57_11","PSA","57","11","11","O Moroa, una lox asuusu lolos silok taram to vana at lamavangkap, la una lox asuusu lisisixam taram at levengkot axap at na lavatbung menemen. ");
INSERT INTO mmx_vpl VALUES ("PS58_1","020_58_1","PSA","58","1","1","Nemi luvuttadi amgomgo. Kereva, mi lox akmokso levelinga at limixin mi loklok i nunuan? Kereva, mi ronga avukat levelinga atnedi la mi tu xantubu? ");
INSERT INTO mmx_vpl VALUES ("PS58_2","020_58_2","PSA","58","2","2","Kopmen tino. Mi doxoma mene ri leveloklok kakapmek mi lok do mina lox i, la mik lox asongot aleng limixin mede Israel. ");
INSERT INTO mmx_vpl VALUES ("PS58_3","020_58_3","PSA","58","3","3","Limixin kakapmek dik lok laxakapmek at levenaleng axap at lorooro atdi. Di paase asu amisik levelinga xaxarang, ga ruka axa i at levenaleng diga visik di ren. ");
INSERT INTO mmx_vpl VALUES ("PS58_4","020_58_4","PSA","58","4","4","Di lok ngan laxasii angkang atla mo levelinga xaxarang atnedi i umsu mi losomamao. La di lok ngan bok lisii xapmek di so asen i mi la Kobra, ua kopmen na ronga levelinga ");
INSERT INTO mmx_vpl VALUES ("PS58_5","020_58_5","PSA","58","5","5","la ing tonga xepe laxaka at laradi leklen at laxasii ik pixan kusu lisii naba tii, kopla at laradi ikleklen aleng levesangsanga. ");
INSERT INTO mmx_vpl VALUES ("PS58_6","020_58_6","PSA","58","6","6","O Moroa, una sak pirivit kepe leven gisangsa atnedi di lok ngan lubunglaion. ");
INSERT INTO mmx_vpl VALUES ("PS58_7","020_58_7","PSA","58","7","7","Naba lox avukat do dina sonao ngan laxadan i sesen su axap, la dina lok ngan levempivilis dit pas amling i ro at langas. ");
INSERT INTO mmx_vpl VALUES ("PS58_8","020_58_8","PSA","58","8","8","Naba lox avukat dina lok ngan levendemdem i remet la i rap sopso. La di lok ngan bok lamdak mumulum nenen i visix amer i la kopmen bok ba na ven laxasep at laxangking. ");
INSERT INTO mmx_vpl VALUES ("PS58_9","020_58_9","PSA","58","9","9","Kovisi dinaklen i, la una lok kepe di ngan lempivilis di vixis asi i. Moroa, una mas kepe di mi lolos at lebelemamao ram do nedi move dina rooro. ");
INSERT INTO mmx_vpl VALUES ("PS58_10","020_58_10","PSA","58","10","10","Limixin manmanton dinaba momo dola dina ven ne Moroa na lox asongot limixin kakapmek. La dinabat pas beles mi leveng kangkedek atdi ro xeneng at lada at limixin kakapmek, mo ne Moroa naba sev amet di. ");
INSERT INTO mmx_vpl VALUES ("PS58_11","020_58_11","PSA","58","11","11","La melemu limixin dinaba tong i do, “I ruturun do limixin manmanton dik lok kaka leveloklox anarong boro at ne Moroa. La i ruturun tinotno do ne Moroa mo i nemen la i viila mumu loklok at limixin at na lavatbung menemen.” ");
INSERT INTO mmx_vpl VALUES ("PS59_1","020_59_1","PSA","59","1","1","O Moroa, nenu ne Moroa rak. Una lox asepsu ia basinge limixin di esep tangarang minia. Una lok see rak ap mo limixin di lok do na sev amer ia. ");
INSERT INTO mmx_vpl VALUES ("PS59_2","020_59_2","PSA","59","2","2","Una lox asepsu ia basinge di nom limixin kakapmek, la una lok kaka amlong ia at leven tikngen di nom limixin sepsev amet. ");
INSERT INTO mmx_vpl VALUES ("PS59_3","020_59_3","PSA","59","3","3","Pen ba i, di kuxut ngais ia kusu dina sev amer ia. Na limixin sepsep di vot buru kusu dina esep eburu minia. Kopmen dola nia aga lok taxakapmek kopla aga lok tavanga goxo nunuan, ");
INSERT INTO mmx_vpl VALUES ("PS59_4","020_59_4","PSA","59","4","4","la kopmen bok do at tosoogong tarak. O Leeme Silok, di gagas kusu dina sev amer ia. ");
INSERT INTO mmx_vpl VALUES ("PS59_5","020_59_5","PSA","59","5","5","Leeme Silok, nu Lanaraavuk. Una ronga ia. Ude u la una lok tooro ia. Moroa at limixin me Israel, nenu xa una ven ba loklok at lavamolon. Una beleku kaxat la una lox asongot di. Nemen gat uta lox asuusu lebelen tuntun tinedi di raba rulu limixin axa atdi. ");
INSERT INTO mmx_vpl VALUES ("PS59_6","020_59_6","PSA","59","6","6","Dimlomlong at levengkantinao bungbung main uto at lemenemen silok, la dip kup saasaa ngan lubung man, do dit pas saasaa go. ");
INSERT INTO mmx_vpl VALUES ("PS59_7","020_59_7","PSA","59","7","7","Una ronga ba lavapaase aksaksa la levelinga xikiilu atdi. Leven gam atnedi i lok ngan lemparise esep keneng at levenngusno atnedi. Ketla dim doma i do kopmen tara nang tonga di. ");
INSERT INTO mmx_vpl VALUES ("PS59_8","020_59_8","PSA","59","8","8","Ketla Leeme Silok, nenu ung longon atnedi, u lok kalise mun di lavamolon. ");
INSERT INTO mmx_vpl VALUES ("PS59_9","020_59_9","PSA","59","9","9","O Moroa, nu Lanaraavuk tarak. Nia a nunu saga at lolos taram. Nenu mun Loxot Loklox Alipe rak. ");
INSERT INTO mmx_vpl VALUES ("PS59_10","020_59_10","PSA","59","10","10","Moroa rak i balamu ia, la naba lox asepsu ia basinge limixin munepen minia. La ni naba keke ia kusu anaba ven i na sak tup midi. ");
INSERT INTO mmx_vpl VALUES ("PS59_11","020_59_11","PSA","59","11","11","O Moroa, nemen gat uta sev amet soso limixin munepen minia, kusu limixin tarak dina ven mo levesongsongot dinap kiv i. Kuren la limixin tarak di noxo domampe nom lolos taram. Una sak epeseves limixin munepen mi lolos taram la una sak tup midi. O Leeme Silok, nenu Lurutu See Pe atnema. ");
INSERT INTO mmx_vpl VALUES ("PS59_12","020_59_12","PSA","59","12","12","Laxakapmek i nemen mene at levenngusno di. Levelinga axap atnedi i lok kapmek. I lox avukat do dina onon at larapelixo mumu latlas atnedi, la levelinga atdi i umsu mi lasaxaek la di xaxarang. ");
INSERT INTO mmx_vpl VALUES ("PS59_13","020_59_13","PSA","59","13","13","Kuren la una sele utut kepe di mi lebelemamao ram. Una sele utut kepe axap di, kusu limixin axap dinabaklen i do ne Moroa ni Lamgomgo at leme Israel. La im gomgonga limixin axap at na lavatbung menemen. ");
INSERT INTO mmx_vpl VALUES ("PS59_14","020_59_14","PSA","59","14","14","Limixin munepen minia dimlomlong at levengkantinao bungbung main la dip kup saasaa ngan lubung man. La dit pas saasaa ro at lemenemen silok. ");
INSERT INTO mmx_vpl VALUES ("PS59_15","020_59_15","PSA","59","15","15","Di lok ngan lubung man dik sixit pupuse panga anan, la di booro do kopmen dina anan mais. ");
INSERT INTO mmx_vpl VALUES ("PS59_16","020_59_16","PSA","59","16","16","Ketla nia anaba vixan loxompixan i tong asu lolos taram. Amisik at leven maxantamak suubu anabak pixan asu labalamu lexen taram. Nenu Loxot Loklox Alipe rak, la u kua pe ia at levenaleng mo do nia a ekip tangarang mi levenmumuat. ");
INSERT INTO mmx_vpl VALUES ("PS59_17","020_59_17","PSA","59","17","17","Nia anaba emi asu minu, nenu Lentupe ria. Ne Moroa, nenu Loxot Loklox Alipe rak, nu ne Moroa u balamu ia. ");
INSERT INTO mmx_vpl VALUES ("PS60_1","020_60_1","PSA","60","1","1","Moroa, ugara sox sisixe xepe vam nama, la uga sev asubu vam nama. Ugara musak kepe vam nama, ketla na manga una repukus bilong mu nama. ");
INSERT INTO mmx_vpl VALUES ("PS60_2","020_60_2","PSA","60","2","2","Kuren la nanga ura lox angnengne vam na lenep kangka atnema la ugara lox arem bang pam i. Una i axatu na levenmenemen atnema atla i lok do na subu epeseves. ");
INSERT INTO mmx_vpl VALUES ("PS60_3","020_60_3","PSA","60","3","3","Ura lok pam nema limixin taram kusu mana ekip tangarang mi laxanmumuat solo la laxaloklox asongot silok. Ma saaban ngan ta do ma inin laxangkadan lolos. ");
INSERT INTO mmx_vpl VALUES ("PS60_4","020_60_4","PSA","60","4","4","Nu ugara vaase aronga vam nedi nom di lok ngangao ram, kusu dinaba sepsu basinge leeteke. ");
INSERT INTO mmx_vpl VALUES ("PS60_5","020_60_5","PSA","60","5","5","Una lox asepsu nama mi lolos taram. Una siam at levesingising atnema, kusu una lox asepsu su nema limixin atla u balamu nema. ");
INSERT INTO mmx_vpl VALUES ("PS60_6","020_60_6","PSA","60","6","6","To at loogu xaala ren Moroa ga tong i xeretna, “Nia anaba sak tup mi limixin munepen minia la ana sak epeseves di basinge lenep kangka rak. Nia anabapdo epes nom lemenemen Sekem ti limixin tarak, la anapdo episa mo lasa ro Sukot. ");
INSERT INTO mmx_vpl VALUES ("PS60_7","020_60_7","PSA","60","7","7","Nia a ruuna mo lunep Gileat, la Manase. La lenep Epraem bok ni lavatkiam tarak i tupe ia at leesep. La lenep Juda ik lox asuusu lubung amgomgo ri limixin tarak. ");
INSERT INTO mmx_vpl VALUES ("PS60_8","020_60_8","PSA","60","8","8","Ketla lenep Moap naba lok ngan lavattingtigon gosogos panga. Nia anaba lu mi luxompanga vatpas tarak uto at leme Edom, ngan loklok katling do nenia Lamgomgo atdi. Limixin me Pilistia diga lok do dinaba sak tup minia, ketla digoxo epovo.” ");
INSERT INTO mmx_vpl VALUES ("PS60_9","020_60_9","PSA","60","9","9","O Moroa, nege bamgo ria ti lok tooro ia keneng at leesep eburu mi leme Edom? Nege ba lok tooro ia xusu ana sak tup midi ro at lemenemen silok atdi, mo diga bos kangkan i mi larangas uat i baalom upana. ");
INSERT INTO mmx_vpl VALUES ("PS60_10","020_60_10","PSA","60","10","10","Kereva, ura sok sisixe xepe rino vam nema? Kereva, ixo epovo bok ba xusu una vas su eburu bok ba mi limixin esep atnema? ");
INSERT INTO mmx_vpl VALUES ("PS60_11","020_60_11","PSA","60","11","11","Una lok tooro nama kusu mana sep limixin munepen, atla lolos at limixin noxo lox epovo tavanga. ");
INSERT INTO mmx_vpl VALUES ("PS60_12","020_60_12","PSA","60","12","12","Do ne Moroa na ru eburu minedik, tanaba sak tup mi limixin munepen, neni naba sev asubu di. ");
INSERT INTO mmx_vpl VALUES ("PS61_1","020_61_1","PSA","61","1","1","O Moroa, una ronga ri lanteng tarak, una ronga lising tarak. ");
INSERT INTO mmx_vpl VALUES ("PS61_2","020_61_2","PSA","61","2","2","Lodoxoma abulubun i suxuna ia la ak lok to vaxalom basinge lemenemen tarak, la a ngising tu. Una lok kaka ia uto at Loxot Loklox Alipe, ");
INSERT INTO mmx_vpl VALUES ("PS61_3","020_61_3","PSA","61","3","3","atla nenu Lurutu See Pe rak. Nenu u tu lolos pe ia at limixin munepen minia. ");
INSERT INTO mmx_vpl VALUES ("PS61_4","020_61_4","PSA","61","4","4","Una ke avolo ia kusu ana nemen amisik to at loogu kaala ram at lorooro axap tarak. Una kubak pe ia maxopok at luvapa ram, kusu ana nemen matmatkun. ");
INSERT INTO mmx_vpl VALUES ("PS61_5","020_61_5","PSA","61","5","5","O Moroa, uga ronga vam leveng kakaape rak, la uga raba ia mi mo leveloklox anarong mo u gagas min tinedi dim taba asinorong u. ");
INSERT INTO mmx_vpl VALUES ("PS61_6","020_61_6","PSA","61","6","6","Nia a sing u do una lox epasum levenmaares at loorong. Una ke avolo i xusu ni na rooro bok be at taxanmaares solo. ");
INSERT INTO mmx_vpl VALUES ("PS61_7","020_61_7","PSA","61","7","7","O Moroa, lixitkis amgomgo ren na nemen maxopok at loklok tatao ram at levenaleng axap i tu melamgo. Una suxuna i mi labalamu lexen la luruturun taram. ");
INSERT INTO mmx_vpl VALUES ("PS61_8","020_61_8","PSA","61","8","8","Kuren la anabak pixan emi asu amisik tu, do at levenaleng getgesara anam taba u mi leventamtaba nia aga xaape min. ");
INSERT INTO mmx_vpl VALUES ("PS62_1","020_62_1","PSA","62","1","1","Nia a tu atnaasan to melamgo at ne Moroa, la a ngangais i xusu na lox asepsu ia, atla nenia a nunu saga ren, la kopmen tara bok. ");
INSERT INTO mmx_vpl VALUES ("PS62_2","020_62_2","PSA","62","2","2","Neni xusuk ik lok see rak la ik lox asepsu ia. Neni Lentupe ria, la kopmen tara naba sev asubu ia. ");
INSERT INTO mmx_vpl VALUES ("PS62_3","020_62_3","PSA","62","3","3","Lavanisa aleng nemi limixin munepen mi vara i do mina esep eburu minia, atla nenia laradi kopmen tololos tarak ngan loroboro i rem tereve si? ");
INSERT INTO mmx_vpl VALUES ("PS62_4","020_62_4","PSA","62","4","4","Mi vara mene i do mina lox asi ia basinge nom loxot kitkis silok tarak. Mi lok momo rik lox asuusu levelinga xaxarang. Mi paase asu levelinga loklox anarong, ketla keneng at lebelen nimi mim doma ali nemnem lasaxaek tia. ");
INSERT INTO mmx_vpl VALUES ("PS62_5","020_62_5","PSA","62","5","5","Nia ak lok sogo xusuk mun at ne Moroa la nia amdoma ngangais tin. ");
INSERT INTO mmx_vpl VALUES ("PS62_6","020_62_6","PSA","62","6","6","Neni xusuk ik lok see rak la ik lox asepsu ia. Neni Lentupe ria la kopmen tinotno tara noxo sev asubu ia. ");
INSERT INTO mmx_vpl VALUES ("PS62_7","020_62_7","PSA","62","7","7","Nia a nunu saga mun at ne Moroa, atla ik lox asepsu ia la i lox asilox ia. Neni i ruuna lolos ngan Lurutu See Pe rak. Neni i lok ngan loogu matmatkun i kubak pe ia. ");
INSERT INTO mmx_vpl VALUES ("PS62_8","020_62_8","PSA","62","8","8","Nemi limixin tarak. At levenaleng axap mina nunu saga at ne Moroa. Mina tong asu levenmumuat atnemi rin, atla neni Loxot Loklox Alipe atnedik. ");
INSERT INTO mmx_vpl VALUES ("PS62_9","020_62_9","PSA","62","9","9","Ketla nemen gat mita nunu saga at limixin atla di lok ngan mene legesa mamas silok laradi i mas abeles ka i. Limixin silok la lixilik di lok ngan levempanga gamasa mun. Do mina lok li di at lisikel, kopmen tumumuat atnedi. Di balalak ngan mene lamamas gamasa. ");
INSERT INTO mmx_vpl VALUES ("PS62_10","020_62_10","PSA","62","10","10","Nemen gat mita doma i do mina sak paxat ka tempanga, la nemen gat mita doma i do mina ruuna ka tavanga at loklok tip kip pilo. Keke i dola lapnovos atnemi na sisilok. Nemen mita doma saga solo ren. ");
INSERT INTO mmx_vpl VALUES ("PS62_11","020_62_11","PSA","62","11","11","Buaang levenaleng nia agara ronga vam ne Moroa ga tong i do, lolos axap, ateren mene, ");
INSERT INTO mmx_vpl VALUES ("PS62_12","020_62_12","PSA","62","12","12","la labalamu ren i tu amisik. O Leeme Silok, nenu naba raba unun ti legetgesara mumu xa levempanga ni ga lox i. ");
INSERT INTO mmx_vpl VALUES ("PS63_1","020_63_1","PSA","63","1","1","O Moroa, nenu ne Moroa rak. Labalak i ngaongao ru. Lorooro axap tarak i vavara ru, atla i ngan laxangka i vat dexes, la i soso vavagam ngan lasa mes. Labalak ik minu ru. ");
INSERT INTO mmx_vpl VALUES ("PS63_2","020_63_2","PSA","63","2","2","A vara i do anaba ven u ro at loogu xaala, a vara i do ana ven lolos la lisisixam taram. ");
INSERT INTO mmx_vpl VALUES ("PS63_3","020_63_3","PSA","63","3","3","Labalamu lexen taram i lox avukat ti lorooro rak, kuren la anaba emi asu minu. ");
INSERT INTO mmx_vpl VALUES ("PS63_4","020_63_4","PSA","63","4","4","Nia anaba tong loklox avukat tu at levenmaares axap nia ana rooro ren, la anaba xip aurut lukngak do ana sing u. ");
INSERT INTO mmx_vpl VALUES ("PS63_5","020_63_5","PSA","63","5","5","Nia anaba lok momo, i ngan nia a lok leluxa la a an mais. La anaba vixan leveng kompixan momo ri leemi asu ru. ");
INSERT INTO mmx_vpl VALUES ("PS63_6","020_63_6","PSA","63","6","6","Dola nia ak midi ro at loora rak, am doma su ram. At laxanimin axap nia am doma u, ");
INSERT INTO mmx_vpl VALUES ("PS63_7","020_63_7","PSA","63","7","7","atla nenu uga lok tooro amisix ia, kuren la nia ak pixan mi lomomo ro maxopok at luvapa ram. ");
INSERT INTO mmx_vpl VALUES ("PS63_8","020_63_8","PSA","63","8","8","Nia at kis pepeve ram la lakngam tino i kubak pe ia basinge limixin munepen minia. ");
INSERT INTO mmx_vpl VALUES ("PS63_9","020_63_9","PSA","63","9","9","Nedi mo dik lok tong pen i do dina sev amer ia, dinaba rava si axap uto xopok at lemenemen at labarongan. ");
INSERT INTO mmx_vpl VALUES ("PS63_10","020_63_10","PSA","63","10","10","Dinaba met keneng at leesep, la lubung man sio dinaba anan levenbaaxin tadi atnedi. ");
INSERT INTO mmx_vpl VALUES ("PS63_11","020_63_11","PSA","63","11","11","Loorong naba momo mi ne Moroa atla ne Moroa naba raba i mi lolos kusu na sak tup mi limixin munepen min. Nedi nom dik lok leveng kakaape mi laasen at ne Moroa, dinaba emi asu min, ketla ne Moroa naba vamngus luvuttadi xaxarang. ");
INSERT INTO mmx_vpl VALUES ("PS64_1","020_64_1","PSA","64","1","1","Nia na a nemen keneng at lumumuat. Moroa una ronga lising tarak! Nia a marat at limixin munepen minia, una lox asepsu lorooro rak basinge di. ");
INSERT INTO mmx_vpl VALUES ("PS64_2","020_64_2","PSA","64","2","2","Una rupe ia at lenngitngit at limixin kakapmek, basinge bok nedi buaang limixin bilinga. ");
INSERT INTO mmx_vpl VALUES ("PS64_3","020_64_3","PSA","64","3","3","Levelinga atnedi ip sep ngan ta lemparise esep ing sengsen, la levelinga xakapmek atnedi ik sixit mokmokso ngan levesoso. ");
INSERT INTO mmx_vpl VALUES ("PS64_4","020_64_4","PSA","64","4","4","Kopmen di marat kusu dina paase palas asu soso laxalinga xaxarang atnedi. Kuren la dik lok kapmek tinotno lorooro at limixin avukat mi levelinga xaxarang la di paase asi levenasen at limixin. ");
INSERT INTO mmx_vpl VALUES ("PS64_5","020_64_5","PSA","64","5","5","Nedi xa di epang aru kusu dina lok laxakapmek. Di epaase do dinaba li lara pelixo atnedi ua. La di tong i do, “Kopmen tara naba ven dik.” ");
INSERT INTO mmx_vpl VALUES ("PS64_6","020_64_6","PSA","64","6","6","Di seput li leventaangas kakapmek la di tong i do, “Dik tara gagas li vam langas i nunuan aleng.” Lebelen mi lodoxoma at limixin kerepmo ing tangku axap. ");
INSERT INTO mmx_vpl VALUES ("PS64_7","020_64_7","PSA","64","7","7","Ketla ne Moroa naba soso di mi levesoso ren, la soso mun dinaba ruuna ka levennin kooxing. ");
INSERT INTO mmx_vpl VALUES ("PS64_8","020_64_8","PSA","64","8","8","Ni naba sele utut kepe di mumu mo levelinga xapmek atdi. La limixin petpes diba ven di, diba piripat lempatlak atnedi kusu ti lok kalise di. ");
INSERT INTO mmx_vpl VALUES ("PS64_9","020_64_9","PSA","64","9","9","La nedi axap dinaba marat, atla dinaba domasu at levempanga ne Moroa gara lok pam i, la dinaba tong asu mo leveloklok silok teren. ");
INSERT INTO mmx_vpl VALUES ("PS64_10","020_64_10","PSA","64","10","10","Nedi axap limixin manmanton dinaba momo ap mo levempanga Leeme Silok gara lok pam i. Dinaba nemen matmatkun maxopok at loklok tatao ren. Limixin axap di nunuan, dinaba emi asu min. ");
INSERT INTO mmx_vpl VALUES ("PS65_1","020_65_1","PSA","65","1","1","O Moroa, ik mokso xusu mana emi asu minu ro Saion, la mana doma xatling leveng kakaape atnema ru, ");
INSERT INTO mmx_vpl VALUES ("PS65_2","020_65_2","PSA","65","2","2","atla up sep siam at levesing atnema. Limixin at levengkot axap dinaba vot pasa u. ");
INSERT INTO mmx_vpl VALUES ("PS65_3","020_65_3","PSA","65","3","3","Loklok kakapmek atnema i sev asubu nema, ketla nenu u doxoma xepe i. ");
INSERT INTO mmx_vpl VALUES ("PS65_4","020_65_4","PSA","65","4","4","Nedi nom una soxolik ka di, dina momo. U lok kaka nedi xusu dina nemen to at loogu xaala ram. Manabat kis mimila at levempanga nunuan keneng at loogu ram eburu mi leveloklox anarong at loogu laplavang taram i xaala. Mo naba lox epovo lavavara atnema. ");
INSERT INTO mmx_vpl VALUES ("PS65_5","020_65_5","PSA","65","5","5","Up sep siam at levesingising atnama mo do um taba nema mi lolos ti sak tup mi limixin munepen minema. La uk lok bok levempanga nunuan ti lox asepsu nema. Limixin at levengkot axap at na lavatbung menemen la at levennep tas paxalom bok di nunu saga ram. ");
INSERT INTO mmx_vpl VALUES ("PS65_6","020_65_6","PSA","65","6","6","Uga vaxaxis lempattaavut mi lolos taram, la kerepmo uga lox asuusu lolos silok taram. ");
INSERT INTO mmx_vpl VALUES ("PS65_7","020_65_7","PSA","65","7","7","Uk lox amila leretepit at laras mi lulung at levempo paxanao, la uk lox axap bok levenekarakat at limixin. ");
INSERT INTO mmx_vpl VALUES ("PS65_8","020_65_8","PSA","65","8","8","Limixin at lavatbung menemen axap ding sangu aleng mumu levempanga ugak lox i. Leven gugu ram i lox asu luxupkup momo boro at lara lenep kavaxap at lavatbung menemen uto at lara lenep. ");
INSERT INTO mmx_vpl VALUES ("PS65_9","020_65_9","PSA","65","9","9","Nenu uk lox asuusu loklok tatao ram ti laxangka, uk lox asi larabet tik lox ababaum laxangka kusu larauna na pisik avukat. Nenu uk suxa aumsu laradan sen mi levengkadan la um taba lavatbung menemen mi levempanga anan. Uk lox i xeretna. ");
INSERT INTO mmx_vpl VALUES ("PS65_10","020_65_10","PSA","65","10","10","Up sep bet avukat ti leventaamang, la uk lox amlu laxangka mi levendan bet. U lox amumulum laxangka mi limisimisi bet la i lox asuusu larauna maxat. ");
INSERT INTO mmx_vpl VALUES ("PS65_11","020_65_11","PSA","65","11","11","Loklok taram i nunuan kuren la um taba aleng levempanga anan mukun avukat. At levengkot axap ut pas teren, i umsu mi laxampanga anan. ");
INSERT INTO mmx_vpl VALUES ("PS65_12","020_65_12","PSA","65","12","12","Ap mo levengkot laxampanga mi lavanuet kangkedek, di umsu ro at levengkot anan atdi, la limixin di nemen at laxasigege kaana di umsu mi lososoro. ");
INSERT INTO mmx_vpl VALUES ("PS65_13","020_65_13","PSA","65","13","13","Levengkot loklok tatao levempanga mi lavanuet kangkedek i umsu mi laxasipsip. To at larasa i umsu mi laxam piao. Levempanga axap i nunuan aleng la limixin dip kup la dik pixan momo. ");
INSERT INTO mmx_vpl VALUES ("PS66_1","020_66_1","PSA","66","1","1","Nemi axap limixin, mina emi asu mi ne Moroa mi luxupkup momo! ");
INSERT INTO mmx_vpl VALUES ("PS66_2","020_66_2","PSA","66","2","2","Minak pixan ti lox aurut laasen teren la mina tong asu leemi asu i nunuan aleng tin! ");
INSERT INTO mmx_vpl VALUES ("PS66_3","020_66_3","PSA","66","3","3","Mina tong i ri ne Moroa xeretna, “Levempanga uk lox i, i nunuan aleng! Lolos taram i silok aleng, kuren la limixin munepen minu di xis tintiding to melamgo ram mi lanmarat. ");
INSERT INTO mmx_vpl VALUES ("PS66_4","020_66_4","PSA","66","4","4","Limixin axap at lavatbung menemen di lotu saparav u. Dik pixan emi asu saparav u, dik pixan emi asu ri laasen taram.” ");
INSERT INTO mmx_vpl VALUES ("PS66_5","020_66_5","PSA","66","5","5","Nemi limixin, ude nimi, la mina ven levempanga ne Moroa gak lox i. Ni gak lok leveloklok sangsangu ren kantubu at limixin. ");
INSERT INTO mmx_vpl VALUES ("PS66_6","020_66_6","PSA","66","6","6","Ni ga lox arepukus Loxontas Memele ga ngan ta laxangka mesemes. Melemu lavalabat atnedik diga vas korop lavatdan sen silok mi lengkangkedek mene. Ap mo loxot diga lok momo mi mo lavanga ni ga lox i. ");
INSERT INTO mmx_vpl VALUES ("PS66_7","020_66_7","PSA","66","7","7","Lixitkis amgomgo ren naba nemen amisik mi lolos teren, la ni i reven tatao larabung mixin axap. La neni noxo ke xepe limixin tongtonga xepe dina lox asilok di mavana ren. ");
INSERT INTO mmx_vpl VALUES ("PS66_8","020_66_8","PSA","66","8","8","Nemi limixin at larabung mixin axap, mina emi asu mi ne Moroa atnedik, mina emi asu silok min. ");
INSERT INTO mmx_vpl VALUES ("PS66_9","020_66_9","PSA","66","9","9","Neni ga lok tatao lorooro atdik basinge laniu, la ni xopmen goxo ke limixin munepen midik gita sak tup midik. ");
INSERT INTO mmx_vpl VALUES ("PS66_10","020_66_10","PSA","66","10","10","Moroa, uga lok li nema at loklok tong pen, i ngan lisiliva laxao i aan adatdar i. Kerepmo ura lok tong pen pam nema. ");
INSERT INTO mmx_vpl VALUES ("PS66_11","020_66_11","PSA","66","11","11","Uga ke nema la maga subu tup at lemet diga sep li rangais nama min la uga lok li levenaknixip mumuat pana at levenantuno nama. ");
INSERT INTO mmx_vpl VALUES ("PS66_12","020_66_12","PSA","66","12","12","Uga ke xepe limixin munepen minema diga vas asi nama. Magat pas keneng at laxao silok mi ladanut. Ketla nanga ura lok kaka nema uto at loxot ua manaba nemen matmatkun maxopok at loklok tatao ram. ");
INSERT INTO mmx_vpl VALUES ("PS66_13","020_66_13","PSA","66","13","13","Nia anaba lok kaka levelaplavang ti kotos uto at loogu ram. Anabam taba u mi leven tamtaba nia aga xaape min tu. ");
INSERT INTO mmx_vpl VALUES ("PS66_14","020_66_14","PSA","66","14","14","Nia anaba raba u mi levempanga nia aga tong i do anaba raba u min, at levenaleng nia aga nemen keneng at lumumuat. ");
INSERT INTO mmx_vpl VALUES ("PS66_15","020_66_15","PSA","66","15","15","Anabam taba u mi levesipsip, kusu ti xotos i ro at loxonin laplavang. Anabaplavang mi levenbulumaxao remes la levenme, la losobu ren naba urut uto vana at lamavangkap. ");
INSERT INTO mmx_vpl VALUES ("PS66_16","020_66_16","PSA","66","16","16","Nemi mim taba asinorong ne Moroa, ude nimi, la mina ronga i na. Nia ana tong asu axap nom levempanga ni gak lox i ria. ");
INSERT INTO mmx_vpl VALUES ("PS66_17","020_66_17","PSA","66","17","17","Agang teng tin ti loklok tooro, nia agak pixan emi asu min. ");
INSERT INTO mmx_vpl VALUES ("PS66_18","020_66_18","PSA","66","18","18","Dola lorooro rak gi umsu mi laxakapmek, Leeme Silok gixo ronga rak. ");
INSERT INTO mmx_vpl VALUES ("PS66_19","020_66_19","PSA","66","19","19","Ketla i ruturun tinotno do ne Moroa ira ronga vam ia, ira ronga res pam at lisingising tarak. ");
INSERT INTO mmx_vpl VALUES ("PS66_20","020_66_20","PSA","66","20","20","Nia a emi asu mi ne Moroa, atla ni xopmen nak sox sisixe lisingising tarak, kopla ni na rebeng alis labalamu lexen teren tia. ");
INSERT INTO mmx_vpl VALUES ("PS67_1","020_67_1","PSA","67","1","1","Moroa, una lox asuusu lebelen tuntun tinema la una lox anarong bok nema. Una lox asuusu lebelemulus taram tinema, ");
INSERT INTO mmx_vpl VALUES ("PS67_2","020_67_2","PSA","67","2","2","kusu limixin at lavatbung menemen axap dinabaklen lodoxoma ram, la kusu limixin at larabung mixin axap dinabaklen i do u lox avukat la uk lox asepsu limixin taram. ");
INSERT INTO mmx_vpl VALUES ("PS67_3","020_67_3","PSA","67","3","3","O Moroa, naba lox avukat do limixin at levengkot axap dina emi asu minu. La naba lox avukat tinotno do larabung mixin axap dina emi asu minu! ");
INSERT INTO mmx_vpl VALUES ("PS67_4","020_67_4","PSA","67","4","4","Naba lox avukat do limixin axap boro at levenabung mixin petpes dina sosoro la dinak pixan mi lomomo, atla nu u viila mumu loklok at limixin mi lodoxoma mokmokso la levelinga ruturun, la um gomgonga limixin at larabung mixin axap at lavatbung menemen. ");
INSERT INTO mmx_vpl VALUES ("PS67_5","020_67_5","PSA","67","5","5","O Moroa, naba lox avukat bok do limixin dina emi asu minu. I epovo rinotno do limixin axap dina emi asu minu! ");
INSERT INTO mmx_vpl VALUES ("PS67_6","020_67_6","PSA","67","6","6","Laxangka ira lox asu vam leventaamang mukun teren. Moroa, ni ne Moroa atnedik ira lox anarong pam dik. ");
INSERT INTO mmx_vpl VALUES ("PS67_7","020_67_7","PSA","67","7","7","Moroa ira lox anarong pam dik, la naba lox avukat do limixin at levengkot axap dinam taba asinorong i. ");
INSERT INTO mmx_vpl VALUES ("PS68_1","020_68_1","PSA","68","1","1","Moroa i beleku kaxat la ik sak epeseves limixin munepen min. Nedi di belengatngas tin, dik sixiro atla ik sak tup midi. ");
INSERT INTO mmx_vpl VALUES ("PS68_2","020_68_2","PSA","68","2","2","I lok ngan lamanman it mas kepe lusuxa, la i xala xepe di. I lok ngan levelumlut misiu i sonao at liplivi kao. Kerepmo la limixin kapmek di seeve ro melamgo at ne Moroa. ");
INSERT INTO mmx_vpl VALUES ("PS68_3","020_68_3","PSA","68","3","3","Ketla limixin manmanton dik lek la di momo at lemeren ne Moroa. Dik lok momo la dip kup mi lososoro. ");
INSERT INTO mmx_vpl VALUES ("PS68_4","020_68_4","PSA","68","4","4","Minak pixan ti ne Moroa, minak pixan emi asu mi laasen teren. Mina gagas li langas tin mo it kis pana at loxontakabu. Laasen teren ne Leeme Silok. Mina lok momo ro melamgo ren! ");
INSERT INTO mmx_vpl VALUES ("PS68_5","020_68_5","PSA","68","5","5","Moroa i nemen to xeneng at loogu laplavang teren i xaala. Ni i kok lubungkarun la ik lok tatao lubung naa rixin, lavatlok atdi diga met pam. ");
INSERT INTO mmx_vpl VALUES ("PS68_6","020_68_6","PSA","68","6","6","Ni im taba lavanat mamangan mi limixin kusu dina nemen eburu midi, la i sasar asepmus asu nedi limixin di nemen at loxokoxo xusu dina momo. Ketla nedi dixo etu ebelen min, dinaba nemen at lenep kangka i vat dexes. ");
INSERT INTO mmx_vpl VALUES ("PS68_7","020_68_7","PSA","68","7","7","O Moroa, at levenaleng ugam gomgo ri limixin taram, la ugat pas korop lamatbin midi, ");
INSERT INTO mmx_vpl VALUES ("PS68_8","020_68_8","PSA","68","8","8","lavatbung menemen axap gangnengne, la lamavangkap ga soobang asu lebet, mumu lovotpot at ne Moroa boro at lakaana Sinai, lovotpot at ne Moroa me Israel. ");
INSERT INTO mmx_vpl VALUES ("PS68_9","020_68_9","PSA","68","9","9","Nenu uga lox asu larabet nunuan ti lox amonok amu laxangka i vat dexes. ");
INSERT INTO mmx_vpl VALUES ("PS68_10","020_68_10","PSA","68","10","10","Limixin taram diga vaxaru li levenmenemen atnedi go, la keneng at luvukat taram uga lox epovo lavakpakes at limixin banbalo. ");
INSERT INTO mmx_vpl VALUES ("PS68_11","020_68_11","PSA","68","11","11","Leeme Silok ga raba asu levelinga, la buaang lavakin diga etong aonon na levelinga ren keretna, ");
INSERT INTO mmx_vpl VALUES ("PS68_12","020_68_12","PSA","68","12","12","“Lavaorong mi limixin esep atnedi dira sixiro!” Lavakin to xolonu diga episa levempanga, limixin esep diga esep kaka i. ");
INSERT INTO mmx_vpl VALUES ("PS68_13","020_68_13","PSA","68","13","13","Mo levempanga ga ngan ta levempoovo amno, diga vop di mi lisiliva, lempapa atdi gam games aleng mi leven gol avukat. (Tila leventaba atnemi diga lipe ro xeneng at loroboro at lubungsipsip at laaleng esep?) ");
INSERT INTO mmx_vpl VALUES ("PS68_14","020_68_14","PSA","68","14","14","Ap mo laaleng, Lanaraavuk ne Moroa ga sak epeseves lavaorong to at lavattaavut Salmon, ni ga lox asi lusugao mumudut (snow) ri subu ap mo loxot. ");
INSERT INTO mmx_vpl VALUES ("PS68_15","020_68_15","PSA","68","15","15","Nu lavattaavut Basan u silok aleng tino, nu lavattaavut mi laxampatlak solo ram! ");
INSERT INTO mmx_vpl VALUES ("PS68_16","020_68_16","PSA","68","16","16","Nu lavattaavut mi laxampatlak solo, tila uk milik angtungun lavattaavut ne Moroa ga lok katling i do rin ti nemen, la u doma i do ni lavanga gamasa? Leeme Silok naba nemen amisik ap mo lavattaavut. ");
INSERT INTO mmx_vpl VALUES ("PS68_17","020_68_17","PSA","68","17","17","Leeme Silok ga rupot boro Sinai eburu mi laxanabin sangsangaun kobot laxang karis esep lolos teren, la ni ga vubeles at loxot kaala ren. ");
INSERT INTO mmx_vpl VALUES ("PS68_18","020_68_18","PSA","68","18","18","Ap mo laaleng ni gat pas uto vana, ni ga emu ka buaang limixin kokoxo eburu min. Ni ga ruuna ka leventamtaba atdi mo limixin tongtonga xepe. Leeme Silok ne Moroa naba nemen go. ");
INSERT INTO mmx_vpl VALUES ("PS68_19","020_68_19","PSA","68","19","19","Leemi asu ri Leeme Silok, neni ip kip levenmumuat atnedik at levenaleng getgesara. Neni ne Moroa ik lox asepsu dik. ");
INSERT INTO mmx_vpl VALUES ("PS68_20","020_68_20","PSA","68","20","20","Moroa atnedik ni ne Moroa ik lox asepsu limixin. Ni Loorong Avolo la ik lox asepsu dik basinge lanmet. ");
INSERT INTO mmx_vpl VALUES ("PS68_21","020_68_21","PSA","68","21","21","Moroa naba rit povorok tuturun tinotno levempatlak at limixin munepen min. Lempatlak atnedi di xopara na xap at leveloklok i bilinga. ");
INSERT INTO mmx_vpl VALUES ("PS68_22","020_68_22","PSA","68","22","22","Leeme Silok ga tong i xeretna, “Nia anaba lok kaka amlong limixin munepen minemi boro at lengkot axap. Keke i do di nemen to at lempat kaana Basan kopla to xa maxopok at lisimaramain, nia anaba lok kaka amlong nedi, ");
INSERT INTO mmx_vpl VALUES ("PS68_23","020_68_23","PSA","68","23","23","kusu minabat pas keneng at lada atnedi la lubung man atnemi dinaba dem ka solo laxanda ri lox axap lavavara atdi.” ");
INSERT INTO mmx_vpl VALUES ("PS68_24","020_68_24","PSA","68","24","24","O Moroa, limixin axap di reven u, ut pas to melamgo at limixin taram melemu at loxonaleng u sak tup mi limixin munepen minu ap mo leesep. O Moroa, nenu Loorong Silok tarak ut pas beles uto xeneng at loogu xaala ram. ");
INSERT INTO mmx_vpl VALUES ("PS68_25","020_68_25","PSA","68","25","25","Nedi dik pixan, dit pas to melamgo. Nedi dik sak gita, dit pas to melemu. La laxaalik dit pas to xantubu, dik sak leven tambarin. ");
INSERT INTO mmx_vpl VALUES ("PS68_26","020_68_26","PSA","68","26","26","La digak pixan, “Ata emi asu mi ne Moroa ro xeneng at lovotpot buru at limixin teren. Nemi axap livipisik li at ne Jakop, mina emi asu mi Leeme Silok!” ");
INSERT INTO mmx_vpl VALUES ("PS68_27","020_68_27","PSA","68","27","27","Loxonabung mixin at ne Beniamin dimgomgo, nedi di xakalik ti levenabung mixin axap. Melemu ren lubung amgomgo at leme Juda eburu mi loxon binam tadi atnedi, la lubung amgomgo me Sebulon la Napitali di mumupit to melemu. ");
INSERT INTO mmx_vpl VALUES ("PS68_28","020_68_28","PSA","68","28","28","O Moroa, una lox asuusu lolos taram, nom lolos uga ru min tinema. ");
INSERT INTO mmx_vpl VALUES ("PS68_29","020_68_29","PSA","68","29","29","Una lox asuusu lolos taram boro xa at loogu laplavang taram to Jerusalem, ap mo loxot lavaorong silok dim taba u mi leventamtaba ve. ");
INSERT INTO mmx_vpl VALUES ("PS68_30","020_68_30","PSA","68","30","30","Una vaase sok leme Isip. Nedi di lok ngan lavatpanga sio mi lavanuet kangkedek i nemen to at lisigege dan. Una vaase sok limixin at levenabung mixin petpes. Nedi limixin tongtonga xepe, di lok ngan laxanbulumaxao remes mi laxannat bulumaxao. Una paase lolos tidi se dinaba xis tiktikbu ro melamgo ram la dina lok letaba ru mi levesiliva. Una sak epeseves mo limixin di vavara esep amisik! ");
INSERT INTO mmx_vpl VALUES ("PS68_31","020_68_31","PSA","68","31","31","Luvuttadi rutu katling dinaba vot boro Isip. Leme Itiopia dinaba xip aurut tikngen mi levesingising atnedi ri ne Moroa. ");
INSERT INTO mmx_vpl VALUES ("PS68_32","020_68_32","PSA","68","32","32","Nemi larabung mixin at lavatbung menemen, mina vixan mi leemi asu saparap ne Moroa. Mina vixan emi asu saparap Leeme Silok, ");
INSERT INTO mmx_vpl VALUES ("PS68_33","020_68_33","PSA","68","33","33","mo it pas tangtagap de vana at lamavangkap, mo lamavangkap me ganoxa at lereot. Mina ronga levelinga ren i lulung silok boro vana at laxalibet. ");
INSERT INTO mmx_vpl VALUES ("PS68_34","020_68_34","PSA","68","34","34","Tong asu lolos at ne Moroa i silok aleng, la im gomgonga mavana leme Israel. I lox asuusu lolos teren tovana at lamavangkap. ");
INSERT INTO mmx_vpl VALUES ("PS68_35","020_68_35","PSA","68","35","35","Moroa me Israel i vas su boro xeneng at loogu xaala ren, la limixin dinaba lingun teren! Neni im taba lolos ti limixin teren. Leemi asu ri ne Moroa! ");
INSERT INTO mmx_vpl VALUES ("PS69_1","020_69_1","PSA","69","1","1","O Moroa, una lox asepsu ia! Ladan na ira urut pam ti laxaka rak. ");
INSERT INTO mmx_vpl VALUES ("PS69_2","020_69_2","PSA","69","2","2","Nia na ara dong tup silatla nga at lapke, la kopmen toxongkangka lolos ti tu ren. Nia nga na xeneng at ladan i si aleng, la lara paxanao i lok do nak mir axong ia. ");
INSERT INTO mmx_vpl VALUES ("PS69_3","020_69_3","PSA","69","3","3","Laxaka rak ira xo axap mi luxupkup ti loklok tooro, luxukung tarak ira songot. Luxatli rak ira ung mi lerengteng, nia a ngangais ti loklok tooro ram. ");
INSERT INTO mmx_vpl VALUES ("PS69_4","020_69_4","PSA","69","4","4","Nedi limixin munepen minia, kopmen tavasuun at lebelengatngas atdi saparav ia, la di umsu aleng tino polo leexes at levengkabinim at lavatlak tarak. Di xaxarang taba ia. Di lolos aleng la di lok do dina sev amer ia. Di xaxarang taba ia do aga xip pilo xaka lempanga nia agoxo xip pilo xaka i. La di tong i ria do ana raba amlong i. ");
INSERT INTO mmx_vpl VALUES ("PS69_5","020_69_5","PSA","69","5","5","O Moroa, libilinga rak kopmen na nemen alipe ram, nu uklen larangtangku rak. ");
INSERT INTO mmx_vpl VALUES ("PS69_6","020_69_6","PSA","69","6","6","O Leeme Silok, nenu Loorong Avolo la Lanaraavuk. Nemen gat uta ke xepe limixin nunu ram dina mangan mu loklok tarak. Moroa me Israel, nemen gat uta ke mo loklok tarak na sox asu lainmangan tinedi di lotu ruturun saparav u. ");
INSERT INTO mmx_vpl VALUES ("PS69_7","020_69_7","PSA","69","7","7","Limixin munepen minia di paase aksaksa ria mumu mun u la ara umsu mi lainmangan. ");
INSERT INTO mmx_vpl VALUES ("PS69_8","020_69_8","PSA","69","8","8","Luvutnetak di reven ia ngan laradi votpot mun, la a lok ngan laradi me xadiong keneng at lixitkis koetemen atnema. ");
INSERT INTO mmx_vpl VALUES ("PS69_9","020_69_9","PSA","69","9","9","Lodoxoma rak i tu at loogu laplavang taram. I anan tos keneng tarak ngan ta laxao. Levempapaase aksaksa dik lox i ru, im subu mavana rak. ");
INSERT INTO mmx_vpl VALUES ("PS69_10","020_69_10","PSA","69","10","10","Ak lox asi mun ia mi loklok ti mun anan, la limixin dirak lox aksaksa ria. ");
INSERT INTO mmx_vpl VALUES ("PS69_11","020_69_11","PSA","69","11","11","Ang sigaara mi levesingsiga ri duudu, la ding longon tarak. ");
INSERT INTO mmx_vpl VALUES ("PS69_12","020_69_12","PSA","69","12","12","Di paase mumu ia ro xeneng at larangas silok, la limixin inin tangtangku di voovo lengkompixan mumu ia. ");
INSERT INTO mmx_vpl VALUES ("PS69_13","020_69_13","PSA","69","13","13","Leeme Silok, nenia anaba ngising parav u. Moroa, unaba sep siam mu ia at loxonaleng axa nenu una lok katling i. Una vaase porang ia atla labalamu lexen taram i silok aleng la unaba lox epovo laxakaape ram tik lox asepsu limixin taram. ");
INSERT INTO mmx_vpl VALUES ("PS69_14","020_69_14","PSA","69","14","14","Una lox asepsu ia kusu anoxo dong si rino ukopok at lapke. Una kubak pe ia basinge limixin munepen minia, la una lox asepsu ia basinge lisimaramain. ");
INSERT INTO mmx_vpl VALUES ("PS69_15","020_69_15","PSA","69","15","15","Uguta ke xepe gat ladanut na vaxat ka ia. Uguta ke xepe ia la ana xong to xeneng at lisimaramain, kopla ana dong tup to xeneng at lamaaut. ");
INSERT INTO mmx_vpl VALUES ("PS69_16","020_69_16","PSA","69","16","16","Leeme Silok, una ronga res tarak mumu luvukat at labalamu lexen taram. Una repukus mu ia mi lebelemulus silok taram! ");
INSERT INTO mmx_vpl VALUES ("PS69_17","020_69_17","PSA","69","17","17","Uguta lipe axa u basinge ia lasaxaruki ram. Nia na ak lok at langsangan lumumuat, la una ronga res tarak! ");
INSERT INTO mmx_vpl VALUES ("PS69_18","020_69_18","PSA","69","18","18","Una vot parav ia la una lox asepsu ia. Una lox asepmus ia basinge limixin munepen minia. ");
INSERT INTO mmx_vpl VALUES ("PS69_19","020_69_19","PSA","69","19","19","Uklen i do di paase aksaksa ria, la dixo lok ngangao rak la dirak lox abaava ia. U ven axap di na limixin munepen minia. ");
INSERT INTO mmx_vpl VALUES ("PS69_20","020_69_20","PSA","69","20","20","Levempapaase aksaksa atnedi ira ba koxorop pam leveve rak. Lavarampen abulubun ta ia na. Aga vara tara xusu ti lox amenemen ia, ketla goxopmen tara go ga lox amenemen ia. ");
INSERT INTO mmx_vpl VALUES ("PS69_21","020_69_21","PSA","69","21","21","At loxonaleng aga roxo, diga raba ia mi laxanbasa. At loxonaleng aga minu, diga raba ia mi laxadan mamao. ");
INSERT INTO mmx_vpl VALUES ("PS69_22","020_69_22","PSA","69","22","22","Keke levenanan atdi nabak paxaru kaxat lasaxaek. La keke levempeluxa kaala atnedi naba lox ekarakat di kusu dina subu tup at leeteke. ");
INSERT INTO mmx_vpl VALUES ("PS69_23","020_69_23","PSA","69","23","23","Una sep di mi lemeramain! Unak lox amolos amisik lempat sintun atdi! ");
INSERT INTO mmx_vpl VALUES ("PS69_24","020_69_24","PSA","69","24","24","Una soobang asu lebelemamao ram mavana atnedi. Keke lebelemamao mokmokso ram na sak pavaa di. ");
INSERT INTO mmx_vpl VALUES ("PS69_25","020_69_25","PSA","69","25","25","Keke lara menemen atnedi nak midi kixinak tino, la teta noxo roo su go xeneng at laraogu kadis atdi. ");
INSERT INTO mmx_vpl VALUES ("PS69_26","020_69_26","PSA","69","26","26","Dik lox asongot nedi no nenu uga lox aleeng nedi. La di paase mumu nedi no nenu uga sev abi nedi. ");
INSERT INTO mmx_vpl VALUES ("PS69_27","020_69_27","PSA","69","27","27","Una malagan li xatling leveloklok kakapmek axap atnedi la uguta ke avolo di xusu dina ruuna xaka toxot at loklok tooro ram. ");
INSERT INTO mmx_vpl VALUES ("PS69_28","020_69_28","PSA","69","28","28","Una lok pes levenasen atnedi ro at lubuk at lorooro. Uguta malagan li gat levenasen atdi eburu mi levenasen at limixin taram. ");
INSERT INTO mmx_vpl VALUES ("PS69_29","020_69_29","PSA","69","29","29","Ketla nia lampen abulubun, ak lok keneng at losongsongot. O Moroa, una lox aurur ia la una lox asepsu ia basinge na levenmumuat! ");
INSERT INTO mmx_vpl VALUES ("PS69_30","020_69_30","PSA","69","30","30","Anaba emi asu mi ne Moroa mi loxompixan. Anaba paase asu laasen silok teren at loxonaleng ana tong avukat tin. ");
INSERT INTO mmx_vpl VALUES ("PS69_31","020_69_31","PSA","69","31","31","Neni na, naba lox amomo rinotno Leeme Silok la naba volo mo loklok tim taba mi levenbulumaxao, la naba volo bok laplavang tin mi lavat bulumaxao temes. ");
INSERT INTO mmx_vpl VALUES ("PS69_32","020_69_32","PSA","69","32","32","At loxonaleng limixin baava dina ven i na, dinabak lek aleng. La nedi di ngising parap ne Moroa, dinaba lok momo aleng. ");
INSERT INTO mmx_vpl VALUES ("PS69_33","020_69_33","PSA","69","33","33","Leeme Silok ing tonga res atnedi dik pakes la ixom domampe limixin teren dik lok at loogu xokoxo. ");
INSERT INTO mmx_vpl VALUES ("PS69_34","020_69_34","PSA","69","34","34","O laxalibet mi lavatkangka, muna emi asu mi ne Moroa. Laras bok mi lempanga xeneng teren, mina emi asu min. ");
INSERT INTO mmx_vpl VALUES ("PS69_35","020_69_35","PSA","69","35","35","Neni naba lox asepsu leme Jerusalem basinge limixin munepen midi la na vaxaru amlong levenmenemen silok at lenep Juda. Limixin teren dinaba ruuna ka mo lenep kangka la dinaba nemen amisik go. ");
INSERT INTO mmx_vpl VALUES ("PS69_36","020_69_36","PSA","69","36","36","Livipisik li at limixin axa ren dinaba ruuna ka i. La nedi ua di vavara aleng i, dinaba nemen amisik go. ");
INSERT INTO mmx_vpl VALUES ("PS70_1","020_70_1","PSA","70","1","1","O Moroa, lox asepsu ia! Leeme Silok, lok tooro soso nga ia! ");
INSERT INTO mmx_vpl VALUES ("PS70_2","020_70_2","PSA","70","2","2","Keke lodoxoma ekarakat na suxuna nedi di lok do dina sev amer ia. La una sak tup midi. Keke leklek atnedi dik lek mumu levenmumuat tarak, na repukus ti lainmangan. ");
INSERT INTO mmx_vpl VALUES ("PS70_3","020_70_3","PSA","70","3","3","Una xala xepe nedi di lok kalise xapmex ia, kusu dinaba mangan. ");
INSERT INTO mmx_vpl VALUES ("PS70_4","020_70_4","PSA","70","4","4","Naba lox avukat do nedi di vot parav u, dina momo la dinak lek. Naba lox avukat do nedi di tong avukat ti loklok tooro ram, dina paase amisik keretna, “Moroa i silok aleng!” ");
INSERT INTO mmx_vpl VALUES ("PS70_5","020_70_5","PSA","70","5","5","O Moroa, nenia na ara molos ta la arat kis banbalo de. Soso mun, una vot pasa ia. Nenu Laradi Loklox Asepsu la Leeme Silok tarak. Lox asepsu soso ia! ");
INSERT INTO mmx_vpl VALUES ("PS71_1","020_71_1","PSA","71","1","1","Leeme Silok, a vot parav u mi lisingising kusu una lok see rak basinge limixin munepen minia. Uguta ke xepe di, dina sak tup minia! ");
INSERT INTO mmx_vpl VALUES ("PS71_2","020_71_2","PSA","71","2","2","Nenu Laradi Manmanton, kuren la una lok tooro ia la una lox asu ia at na lumumuat. Una ronga ia la una lox asepsu ia basinge di! ");
INSERT INTO mmx_vpl VALUES ("PS71_3","020_71_3","PSA","71","3","3","Una lok ngan lomoo vungpung tia, la loogu lolos la matmatkun ti lok see rak. Nenu Lentupe ria la Loroboro rak. La nenia ak lok alipe ro xeneng taram. ");
INSERT INTO mmx_vpl VALUES ("PS71_4","020_71_4","PSA","71","4","4","Lomoroa rak, una lox asepsu ia basinge limixin kapmek, la basinge lolos at limixin kapmek ding long kuxurung. ");
INSERT INTO mmx_vpl VALUES ("PS71_5","020_71_5","PSA","71","5","5","Leeme Silok, nenu Loorong Avolo. Una ronga res tarak atla a doma sogo nga na ram. Ga ruka i at laau rak, agara nunu saga vam taram. ");
INSERT INTO mmx_vpl VALUES ("PS71_6","020_71_6","PSA","71","6","6","Agara sep sogo vam taram ap mo axap laxanmaares nia aga rooro ren. La tuka i at laaleng ne naga ga visix ia, uga lok see rak. Anaba emi asu amisik minu. ");
INSERT INTO mmx_vpl VALUES ("PS71_7","020_71_7","PSA","71","7","7","Lorooro rak ga lok ngan lampoovo avukat ti buaang nedi limixin diga mu asu i, atla nenu uga lok ngan loroboro lolos ga tu xangkan ia. ");
INSERT INTO mmx_vpl VALUES ("PS71_8","020_71_8","PSA","71","8","8","Kuren la a emi asu amisik minu at levenaleng axap, la a paase asu lununuan taram. ");
INSERT INTO mmx_vpl VALUES ("PS71_9","020_71_9","PSA","71","9","9","Uguta raba rulu ia at na loxonaleng nenia a sioxo nga. La uguta doxoma xepe ia mumu i do ara ventaae nga. ");
INSERT INTO mmx_vpl VALUES ("PS71_10","020_71_10","PSA","71","10","10","Lavamunepen minia di vara i do dina sev amer ia. Di vepaase nemnem levendoxoma ri levempanga diba lox i ria. ");
INSERT INTO mmx_vpl VALUES ("PS71_11","020_71_11","PSA","71","11","11","Di paase xeretna do, “Moroa ira raba rulu vam i. Ata mu arup ta i la ata lox epovo lodoxoma atnedik. Kopmen bok ba teta go xusu naba lok tooro i.” ");
INSERT INTO mmx_vpl VALUES ("PS71_12","020_71_12","PSA","71","12","12","O Moroa. Uguta nemen paxalom basinge ia. Lomoroa rak, una lok kepe soso na lumumuat tarak! ");
INSERT INTO mmx_vpl VALUES ("PS71_13","020_71_13","PSA","71","13","13","Una lox asi nedi di sox ia mi levelinga xaxarang, una sev asubu di. La keke nedi di lok do dina lox asongor ia, dina mangan la dina baava. ");
INSERT INTO mmx_vpl VALUES ("PS71_14","020_71_14","PSA","71","14","14","Anabam doma saga amisik taram. Anaba emi asu amisik minu la leemi asu rak tu naba nemen epasum. ");
INSERT INTO mmx_vpl VALUES ("PS71_15","020_71_15","PSA","71","15","15","Anaba tong asu luvukat taram. La at levenaleng axap, anaba paase mumu loklok tooro ram, la keke i do axoklen ausuv i. ");
INSERT INTO mmx_vpl VALUES ("PS71_16","020_71_16","PSA","71","16","16","Anabat pas keneng at lolos at Loorong Avolo. Anaba paase asu kusuk mun mo luvukat taram to at lemeren limixin axap. ");
INSERT INTO mmx_vpl VALUES ("PS71_17","020_71_17","PSA","71","17","17","Ugarak lox ase vam ia, tuka axa i at levenmaares nia aga aau ren, la nia move a paase mumu leveloklok maraanu ram. ");
INSERT INTO mmx_vpl VALUES ("PS71_18","020_71_18","PSA","71","18","18","Ananga ara sioxo la levengkabinim at lavatlak tarak irak sokso. O Moroa, uguta raba rulu ia. Una su auru ia at levenaleng ana paase asu lolos silok taram tinedi lavaola axap mo dibap tavasu. ");
INSERT INTO mmx_vpl VALUES ("PS71_19","020_71_19","PSA","71","19","19","Moroa, lempanga axap at na lavatbung menemen kopok la lempanga axap toxun pana at laxalibet, ik lox asuusu loklok taram in manton tino. Ugara lok pam levempanga silok. Kuren la kopmen teta go na lok ngan u. ");
INSERT INTO mmx_vpl VALUES ("PS71_20","020_71_20","PSA","71","20","20","Ugara li vam levenmumuat mi levesongsongot mavana rak. Ketla unaba suxa kun ia mi lorooro nunuan la unaba lox asepsu ia basinge lamaaut. ");
INSERT INTO mmx_vpl VALUES ("PS71_21","020_71_21","PSA","71","21","21","Unaba lox asilox ia polo mo levenmaares avot tarak la unaba lox amamana bok ba lodoxoma rak. ");
INSERT INTO mmx_vpl VALUES ("PS71_22","020_71_22","PSA","71","22","22","Nia anaba emi asu ruturun minu mi loxontaaleng. Moroa rak, anaba emi asu mi loklok tuturun tia. Anabap sep levengkom pixan tu ro at ligita rak. Nenu Laradi Melemelengan at limixin me Israel. ");
INSERT INTO mmx_vpl VALUES ("PS71_23","020_71_23","PSA","71","23","23","Anabap kup mi lososoro ru at loxonaleng anak sak loxontaaleng. Anabak pixan mi lorooro axap tarak, atla ugara lox asepsu vam ia. ");
INSERT INTO mmx_vpl VALUES ("PS71_24","020_71_24","PSA","71","24","24","At levenaleng kudun axap anaba paase asu loklok manmanton taram, atla ugara sev asi vam nedi ua diga vara i do dina lok kapmex ia. Uga sak tup midi la nanga dira baava. ");
INSERT INTO mmx_vpl VALUES ("PS72_1","020_72_1","PSA","72","1","1","O Moroa, una anasa loorong kusu ni naba viila mumu loklok at limixin mi lodoxoma mokmokso i ngan mun taram. Una lox ase i mi levelinga loklox akmokso ram, ");
INSERT INTO mmx_vpl VALUES ("PS72_2","020_72_2","PSA","72","2","2","kusu neni naba viila mumu avukat limixin taram at levenaleng neni naba nemen ngan lamgomgo atnedi. La neni nabam gomgonga nedi luvuttadi ua di baava. Neni naba lox i na mi levelinga manmanton. ");
INSERT INTO mmx_vpl VALUES ("PS72_3","020_72_3","PSA","72","3","3","Nia a sing bok do limixin at na lenep kangka ren dina ngasang kobot, la na lenep na umsu mi loklok manmanton. ");
INSERT INTO mmx_vpl VALUES ("PS72_4","020_72_4","PSA","72","4","4","La loorong na ila leveloklok at luvuttadi banbalo mi lodoxoma ruturun. La neni na lok tooro luvuttadi vakpakes la nat pas asi luvuttadi loklok papavas. ");
INSERT INTO mmx_vpl VALUES ("PS72_5","020_72_5","PSA","72","5","5","La a sing bok do limixin taram dina lotu saparap amisix u at levenaleng laxangking i soosoo, la at levenmaares lagaaling im taba asu losoosoo ren ti na loola la ti mo bok lavaola dibap tavasu. ");
INSERT INTO mmx_vpl VALUES ("PS72_6","020_72_6","PSA","72","6","6","La loorong na lok ngan larakabu ri leventaamang la naba ngan bok levengkaramis dan im subu ro vana at laxangka. ");
INSERT INTO mmx_vpl VALUES ("PS72_7","020_72_7","PSA","72","7","7","La loklok manmanton na sisilok lolos kantubu at limixin at ne Moroa keneng at levenaleng axap at lorooro ren. La dina ngasang kobot amisik kerekngan lagaaling im taba amisik laxasep. ");
INSERT INTO mmx_vpl VALUES ("PS72_8","020_72_8","PSA","72","8","8","La a sing bok do lixitkis orong teren na vung kimit mo levennep kangka ik lok saparap laras, la na sisilok, ruka i ro at ladan sen Iupretis la na se at latnese at lavatbung menemen. ");
INSERT INTO mmx_vpl VALUES ("PS72_9","020_72_9","PSA","72","9","9","La limixin boro at lamatbin dina tu tiktikbu mi lempatgulom atdi ro melamgo ren. La limixin munepen min dina subu midi gamasa mi lenbantuxu atnedi uto xopok at laxangka ri lok ngangao ren. ");
INSERT INTO mmx_vpl VALUES ("PS72_10","020_72_10","PSA","72","10","10","La lavaorong me Spein la boro at levesoxan bok, dinak lok leventamtaba rin. Lavaorong me Sheba la Seba dinabam taba i mi leventamtaba. ");
INSERT INTO mmx_vpl VALUES ("PS72_11","020_72_11","PSA","72","11","11","La lavaorong axap dinat kis tiktikbu ro melamgo ren. Limixin at larabung mixin axap dina gugu taba i. ");
INSERT INTO mmx_vpl VALUES ("PS72_12","020_72_12","PSA","72","12","12","La a sing bok do loorong na lox asepsu luvuttadi banbalo ua di toro rin basinge lorooro etaba, la nedi bok ua dik pakes la lavapen abulubun. ");
INSERT INTO mmx_vpl VALUES ("PS72_13","020_72_13","PSA","72","13","13","Neni na lox asuusu lebelen tuntun tinedi dixo ruuna lolos la di banbalo. Neni na lox asepsu limixin pakpakes basinge lanmet. ");
INSERT INTO mmx_vpl VALUES ("PS72_14","020_72_14","PSA","72","14","14","Neni na lox asepsu di basinge limixin loklok papavas, limixin mukmusak, la limixin sepsep tadi, atla lorooro atnedi i lok ngan lavanga matmatkun tin. ");
INSERT INTO mmx_vpl VALUES ("PS72_15","020_72_15","PSA","72","15","15","Naba lox avukat do loorong na rooro amisik! La limixin dinam taba i mi levengol boro Sheba. La keneng at levesingising at limixin, dina tong ke amisik teren at levenaleng axap. La loklox anarong at ne Moroa na nemen amisik pana ren! ");
INSERT INTO mmx_vpl VALUES ("PS72_16","020_72_16","PSA","72","16","16","La na lenep kangka na umsu mi laxam piao. La lengkong kaana nam tebonot pe mi levempeeve anan, la dina pisik solo ngan leventauna ro Lebanon. Keke mo laramenemen silok teren na umsu mi limixin, la na lok ngan laxangka i umsu mi levempivilis. ");
INSERT INTO mmx_vpl VALUES ("PS72_17","020_72_17","PSA","72","17","17","Naba lox avukat do limixin di noxo domampe laasen at loorong at levenaleng axap i tu melamgo. La keke mo lakleklen at limixin mumu i, na nemen amisik ngan laxangking. La limixin at larabung mixin petpes bok dina ngising ne Moroa ri lox anarong nedi ngan ni gara lox anarong pam loorong. ");
INSERT INTO mmx_vpl VALUES ("PS72_18","020_72_18","PSA","72","18","18","Leemi asu ri Leeme Silok ne Moroa me Israel! Neni xusuk mun ik lok mo levempanga maraanu. ");
INSERT INTO mmx_vpl VALUES ("PS72_19","020_72_19","PSA","72","19","19","Leemi asu amisik la kopmen tekavaxap teren ti laasen melemelengan teren! Keke lisisinang teren na suxuna axap lavatbung menemen. Tuturun! Tuturun! ");
INSERT INTO mmx_vpl VALUES ("PS72_20","020_72_20","PSA","72","20","20","Neni na laxavaxap at levesingising at ne Devit, lamdak at ne Jesi. ");
INSERT INTO mmx_vpl VALUES ("PS73_1","020_73_1","PSA","73","1","1","Moroa ga vukat tuturun tinotno ri leme Israel, la tinedi ua levempeve atnedi i kasep. ");
INSERT INTO mmx_vpl VALUES ("PS73_2","020_73_2","PSA","73","2","2","Ketla nenia, aga auret tinotno xusu lesepsep sogo rak at ne Moroa gita xap. La lununu rak gita subu, ");
INSERT INTO mmx_vpl VALUES ("PS73_3","020_73_3","PSA","73","3","3","atla nenia ga bele mumuat tinedi digak lox aaso, la at levenaleng aga reven levempanga gak sixit avukat tinedi limixin kapmek. ");
INSERT INTO mmx_vpl VALUES ("PS73_4","020_73_4","PSA","73","4","4","Dixo ekip tangarang mi levesongsongot, la di lolos la dixok meres. ");
INSERT INTO mmx_vpl VALUES ("PS73_5","020_73_5","PSA","73","5","5","Dixong songot ngan lentaba luvuttadi ding songot kuren. Dixon tuuna bok tevenekarakat ngan leventaba vetpes din tuuna i. ");
INSERT INTO mmx_vpl VALUES ("PS73_6","020_73_6","PSA","73","6","6","Kuren la ding sigaara mi loklox aaso i ngan levenonga di vonga i at lengkaka atdi, la ding siga bok lemusak mi leesep i ngan lengkontamon babaalom di vitis korop di min. ");
INSERT INTO mmx_vpl VALUES ("PS73_7","020_73_7","PSA","73","7","7","Lempatpeve atnedi ip kip soobang asu laxapmek, la levendoxoma atnedi ik lox angtang tinotno mi levendoxoma alipe xapmek. ");
INSERT INTO mmx_vpl VALUES ("PS73_8","020_73_8","PSA","73","8","8","Ding longon aksaksa ri limixin la di paase mumu levempanga xapmek. Dik lox aaso la dik lox agagas li leventaangas kusu tik lox abaava lentaba vetpes. ");
INSERT INTO mmx_vpl VALUES ("PS73_9","020_73_9","PSA","73","9","9","Di paase vupu ri ne Moroa mo ik lok toxun pana at laxalibet, la di paase asu avut lemet ti limixin at lavatbung menemen. ");
INSERT INTO mmx_vpl VALUES ("PS73_10","020_73_10","PSA","73","10","10","Kuren la mo limixin at ne Moroa di repukus ti mu asu di la di nunu lolos tinotno at lempanga di paase i. ");
INSERT INTO mmx_vpl VALUES ("PS73_11","020_73_11","PSA","73","11","11","Mo limixin kapmek di tong i do, “Ne Moroa noxoklen i. Leeme Avolo noxo long terek nedik.” ");
INSERT INTO mmx_vpl VALUES ("PS73_12","020_73_12","PSA","73","12","12","Limixin kapmek di paase kerepmo. Di ruuna laxampanga solo la move dirak lok ka panga bok. ");
INSERT INTO mmx_vpl VALUES ("PS73_13","020_73_13","PSA","73","13","13","Kereva ba nenia, aga kok avukat gamasa mene lorooro rak, la agoxo lok laxapmek? ");
INSERT INTO mmx_vpl VALUES ("PS73_14","020_73_14","PSA","73","14","14","O Moroa, uga lox asongot solo ia at laxanaleng axap. At leven maxantamak amisik ugap sev asongor ia. ");
INSERT INTO mmx_vpl VALUES ("PS73_15","020_73_15","PSA","73","15","15","Do nia agita paase asu tevelinga vetpes kerekngan mo limixin kapmek, agitaba lox asuusu i do nenia xopmen lara atnedi limixin taram. ");
INSERT INTO mmx_vpl VALUES ("PS73_16","020_73_16","PSA","73","16","16","Aga lok tong pen i do ana doxoma mumu na lumumuat, ketla ga lolos tinotno ria ri lox akmokso i, ");
INSERT INTO mmx_vpl VALUES ("PS73_17","020_73_17","PSA","73","17","17","ga se at loxonaleng aga beles uto at loogu laplavang taram. Go ba i, aga long lenget ka ba i do lavanga salai mo naba vot atnedi limixin kapmek. ");
INSERT INTO mmx_vpl VALUES ("PS73_18","020_73_18","PSA","73","18","18","Unaba lok li di ro at lenep i gagai, la unaba lok nedi diba subu tup at leeteke! ");
INSERT INTO mmx_vpl VALUES ("PS73_19","020_73_19","PSA","73","19","19","Di naba pubeles soso mun at lesoxoreles. La laxavaxap atnedi, dinabap tava si rinotno uto xopok at loxot pis. ");
INSERT INTO mmx_vpl VALUES ("PS73_20","020_73_20","PSA","73","20","20","Dinabak lok ngan lapnobo i xap basinge lodoxoma at laradi at len maxantamak. La kerepmo bok at loxonaleng nenu, Leeme Silok, una beleku kaxat, dinaba sonao. ");
INSERT INTO mmx_vpl VALUES ("PS73_21","020_73_21","PSA","73","21","21","At levenaleng levendoxoma rak ga soogong tu la labalak ga mamao ru. ");
INSERT INTO mmx_vpl VALUES ("PS73_22","020_73_22","PSA","73","22","22","Agang tangku ngan lavanga mi lavanuet kangkedek. A goxo xasep at lodoxoma ram. ");
INSERT INTO mmx_vpl VALUES ("PS73_23","020_73_23","PSA","73","23","23","Ketla nanga a nemen saparap amisix u, la um tebeng lakngak tino. ");
INSERT INTO mmx_vpl VALUES ("PS73_24","020_73_24","PSA","73","24","24","Um lam ase ia mi levenanasa ram la at laxavaxap teren, unaba siam ka ia mi leemi asu ram tia. ");
INSERT INTO mmx_vpl VALUES ("PS73_25","020_73_25","PSA","73","25","25","Nege bok ba nia a ruuna ka i ro at laxalibet? Nenu xusuk mun. At na levenaleng nenia a ruuna u, a vara bok ba tavanga sala i de at lavatbung menemen? ");
INSERT INTO mmx_vpl VALUES ("PS73_26","020_73_26","PSA","73","26","26","Do lodoxoma rak la labantuxu rak na molos, nu ne Moroa, nenu lolos tarak. Nenu xusuk mun nia ak pakes tu. ");
INSERT INTO mmx_vpl VALUES ("PS73_27","020_73_27","PSA","73","27","27","Nedi di raba rulu u, ne Moroa, dinaba seeve. Unaba sele utut nedi di babala vukpux u mi lorooro atnedi. ");
INSERT INTO mmx_vpl VALUES ("PS73_28","020_73_28","PSA","73","28","28","Ketla i lox avukat tinotno do nenia a nemen saparap ne Moroa, nu Lurutu See Pe rak. Nenu Leme Silok, Loorong Avolo. La i lox avukat tinotno bok mo do a paase asu lempanga axap nenu gara lok pam i! ");
INSERT INTO mmx_vpl VALUES ("PS74_1","020_74_1","PSA","74","1","1","O Moroa. Ua lavasuun teren la u raba rulu nema xeretna? Kereva, lebelemamao ram ti limixin akmokso ram naba nemen amisik ta, la noxo xap? ");
INSERT INTO mmx_vpl VALUES ("PS74_2","020_74_2","PSA","74","2","2","Una doma limixin taram mo nenu uga soxolik ka axa di gano xusu nedi ataram. La nedi ua uga lam asu ka di at loxokoxo kusu diba ravasu ngan lubung mixin akmokso ram. Una doxoma lakaana Saion, no nenu uga nemen bok be ve kantubu atnema. ");
INSERT INTO mmx_vpl VALUES ("PS74_3","020_74_3","PSA","74","3","3","Una vas mavana at loogu laplavang taram ga rem utut. Lavamunepen minema digara sele utut axap pam lempanga ro xeneng teren. ");
INSERT INTO mmx_vpl VALUES ("PS74_4","020_74_4","PSA","74","4","4","Lavamunepen minu digap kup silok tinotno mi lomomo ro xeneng at loogu laplavang taram. Diga lox aurut leventamon i ru katling lenep silok atnedi, i ngan lampoovo do, nedi diga sak tup minema la diga ruuna ka loogu laplavang. ");
INSERT INTO mmx_vpl VALUES ("PS74_5","020_74_5","PSA","74","5","5","Diga esep ngan luvuttadi ratara una diga tara asi laxanuna mi levenmatao atdi. ");
INSERT INTO mmx_vpl VALUES ("PS74_6","020_74_6","PSA","74","6","6","Diga tit povorok levengkon una diga xovox i at levengkot kitkis, levenora anan, la at laramusmaragu mi levenasop la lempatmatao silok atdi. ");
INSERT INTO mmx_vpl VALUES ("PS74_7","020_74_7","PSA","74","7","7","Diga ut tereve xepe loogu laplavang taram la diga song arup laxao ren. Diga lox amexexe rinotno Loxot Kaala ua limixin diga lotu saparav u. ");
INSERT INTO mmx_vpl VALUES ("PS74_8","020_74_8","PSA","74","8","8","Diga vara i do dina vas amdamda axap nema. La diga kotos asi laraogu axap i xaala at na lenep kangka. ");
INSERT INTO mmx_vpl VALUES ("PS74_9","020_74_9","PSA","74","9","9","Ma xopmen na ven bok ba tempanga abis. Kopmen ta teputadi vapaase ali go dik lok, la kopmen teta naklen i do na lumumuat naba nemen at lavanisa maares axap. ");
INSERT INTO mmx_vpl VALUES ("PS74_10","020_74_10","PSA","74","10","10","O Moroa, naba vanisa maares mo na limixin munepen minema dibang longon sese u? Kereva, diba paase vupu amisik ta ri laasen taram la kopmen tekavaxap teren? ");
INSERT INTO mmx_vpl VALUES ("PS74_11","020_74_11","PSA","74","11","11","Ua lavasuun teren la u ronga xepe ri lok tooro nema? Tila ba uk lok li lukngam to melemu ram? ");
INSERT INTO mmx_vpl VALUES ("PS74_12","020_74_12","PSA","74","12","12","O Moroa, ugarat kis orong silok pam tinema, tuka axa i at lurutu kaxat at lubung mixin me Israel, la buaang laxanaleng ugak lox asepsu vam nema at levenmumuat. ");
INSERT INTO mmx_vpl VALUES ("PS74_13","020_74_13","PSA","74","13","13","Uga lok langas to at laras mi lolos silok taram, la uga tit povorok lempatlak at laxampanga silok boro xeneng at laras. ");
INSERT INTO mmx_vpl VALUES ("PS74_14","020_74_14","PSA","74","14","14","Uga rit povorok lempatlak at lavatpanga silok ne Levietan, la uga raba lempanga mi lavanuet kangkedek no at lamatbin mi labantuxu ren, tidi ri anan. ");
INSERT INTO mmx_vpl VALUES ("PS74_15","020_74_15","PSA","74","15","15","Uga lok levempuuvut dan mi levendan lixilik digara sen bok ba. La uga lox ames lempatdan sen silok. ");
INSERT INTO mmx_vpl VALUES ("PS74_16","020_74_16","PSA","74","16","16","Uga rudum li laaleng kangking, la laxanimin. Uga vaxaxis li laxangking mi lagaaling at luxot atdu. ");
INSERT INTO mmx_vpl VALUES ("PS74_17","020_74_17","PSA","74","17","17","Uga lok li latnese at na lavatbung menemen. Uga lok lamaares mi laavat. ");
INSERT INTO mmx_vpl VALUES ("PS74_18","020_74_18","PSA","74","18","18","Ketla, Leeme Silok tarak, unaklen i do limixin munepen minu ding longon sese u, atla diplavang ti levenmoroa xaxarang, kuren la dik sok tixirixes u. ");
INSERT INTO mmx_vpl VALUES ("PS74_19","020_74_19","PSA","74","19","19","Uguta raba rulu limixin axap taram. Di lok ngan mun limixin pentaae. La uguta ke xepe di kusu dina vubeles at longlong kuxurung at limixin munepen midi. Uguta domampe limixin taram mo dim suma leveloklox asongot. ");
INSERT INTO mmx_vpl VALUES ("PS74_20","020_74_20","PSA","74","20","20","Una doma laxakaape uga lox i eburu minema kusu una lok tatao nama. Levenekarakat mo ik lok at lengkon mesuluk main axap at na lenep kangka. ");
INSERT INTO mmx_vpl VALUES ("PS74_21","020_74_21","PSA","74","21","21","Uguta ke xepe luvuttadi baava kusu dina mangan. Una lok tooro mo luvuttadi banbalo mi lavamun panga xusu diba emi asu minu. ");
INSERT INTO mmx_vpl VALUES ("PS74_22","020_74_22","PSA","74","22","22","O Moroa, una beleku kaxat, la una tu xa at lenep taram mumu na levenmumuat atnema. Una doxoma box i do limixin tongtonga xepe ding longon sese amisix u at laxanaleng axap. ");
INSERT INTO mmx_vpl VALUES ("PS74_23","020_74_23","PSA","74","23","23","La uguta domampe leven aknuxup belemamao at limixin munepen minu, mo di gagang linga amisik taram. ");
INSERT INTO mmx_vpl VALUES ("PS75_1","020_75_1","PSA","75","1","1","O Moroa, ma tong avukat tu, ma tong avukat tu! Ma tong aonon lisisilok taram atla u silok aleng, la ma tong aonon bok levempanga maraanu ugara lok pam i. ");
INSERT INTO mmx_vpl VALUES ("PS75_2","020_75_2","PSA","75","2","2","Moroa ga vaase xeretna, “Nia ara vit li vam laaleng ti leete, kusu anaba ila loklok at limixin la anoxo tong asu levelinga xaxarang. ");
INSERT INTO mmx_vpl VALUES ("PS75_3","020_75_3","PSA","75","3","3","Keke i do levempanga axap di ruuna lorooro, dina dede mi lanmarat, la lavatbung menemen nang nengne, ketla nenia anabak lox aru lolos laamkumkun at na lavatkangka. ");
INSERT INTO mmx_vpl VALUES ("PS75_4","020_75_4","PSA","75","4","4","A paase ri limixin tongtonga xepe xusu dinak lok ngangao la di noxo simi aurut di. ");
INSERT INTO mmx_vpl VALUES ("PS75_5","020_75_5","PSA","75","5","5","La dina xap ta di rik lox aru axa di la na xap bok tit las di.” ");
INSERT INTO mmx_vpl VALUES ("PS75_6","020_75_6","PSA","75","6","6","Mo laradi rim gonga leete, noxo ravasu do boronak kopla borois, la noxo ravasu do borou xopla boroxun. ");
INSERT INTO mmx_vpl VALUES ("PS75_7","020_75_7","PSA","75","7","7","Neni axa ne Moroa naba ila loklok at limixin la ni naba riki xepe lentaba la na vuxaxis avukat lentaba. ");
INSERT INTO mmx_vpl VALUES ("PS75_8","020_75_8","PSA","75","8","8","Leeme Silok im tebeng lavanga runtu dan to at lekngen, la i umsu mi laxadan vaen lolos mo i ru katling lebelemamao ren. Neni i soobang asu i, la limixin kapmek di inin i. Di inin asi rinotno i se at lengkootu avit. ");
INSERT INTO mmx_vpl VALUES ("PS75_9","020_75_9","PSA","75","9","9","Ketla nenia noxo xap at lavapaase asu levelinga mumu Lomoroa at ne Jakop kopla anak pixan emi asu rin. ");
INSERT INTO mmx_vpl VALUES ("PS75_10","020_75_10","PSA","75","10","10","Neni naba ba koxorop lolos at limixin kapmek, ketla lolos atnedi di ruuna loklok manmanton naba sisilok. ");
INSERT INTO mmx_vpl VALUES ("PS76_1","020_76_1","PSA","76","1","1","Limixin to Juda dikleklen ne Moroa, la dim taba asinorong laasen teren to Israel. ");
INSERT INTO mmx_vpl VALUES ("PS76_2","020_76_2","PSA","76","2","2","I ruuna langkolonu ro Jerusalem. Loogu ren i nemen to at loxongkaana Saion. ");
INSERT INTO mmx_vpl VALUES ("PS76_3","020_76_3","PSA","76","3","3","Ap mo loxot neni ga sak pirivit levesoso at laradi munepen min, la ga sak pirivit bok larapenban mi lemparise esep atdi, la lempanga esep axap bok atdi. Na levelinga i ruturun tinotno. ");
INSERT INTO mmx_vpl VALUES ("PS76_4","020_76_4","PSA","76","4","4","O Moroa, u silok aleng. Laasen silok, neni ataram kusuk mun, at loxonaleng ugamlong boro vana at levengkaana, ap mo loxot ua uga sev asi limixin munepen minu. ");
INSERT INTO mmx_vpl VALUES ("PS76_5","020_76_5","PSA","76","5","5","Limixin taram diga sak paxat ka axap lempanga atnedi mo limixin esep lolos, la monga dira vunga ngan luvuttadi met. Levelolos atnedi mi lakleklen atdi ri vesep ga ravasu ngan lempanga gamasa. ");
INSERT INTO mmx_vpl VALUES ("PS76_6","020_76_6","PSA","76","6","6","O Moroa at ne Jakop, at loxonaleng uga paase lolos tinedi, lempaaros eburu mi luvuttadi ro vana ren digam subu ri lanmet. ");
INSERT INTO mmx_vpl VALUES ("PS76_7","020_76_7","PSA","76","7","7","Ketla nenu Leeme Silok, limixin axap dik marat taram. Teta ixo epovo xusu na ru tangarang u at loxonaleng u belemamao. ");
INSERT INTO mmx_vpl VALUES ("PS76_8","020_76_8","PSA","76","8","8","To vana at laxalibet uga tong axasep limixin axap mi levelinga loklox akmokso ram. La limixin at lavatbung menemen diga marat, kuren la mo digat kis sixim mun. ");
INSERT INTO mmx_vpl VALUES ("PS76_9","020_76_9","PSA","76","9","9","Atla uga ru kaxat kusu ti vaase asu lempapaase ramtaba ina ram, la kusu ti lox asepsu limixin baava de at lavatbung menemen. ");
INSERT INTO mmx_vpl VALUES ("PS76_10","020_76_10","PSA","76","10","10","Lebelemamao at limixin at lavatbung menemen ik lox asuusu mun leemi asu silok tu. Nedi di roo su at levenesep silok, dinabak lok katling amisik levenaleng silok taram. ");
INSERT INTO mmx_vpl VALUES ("PS76_11","020_76_11","PSA","76","11","11","Nemi levenabung mixin petpes, mina raba Leeme Silok, neni ne Moroa atnemi mi levempanga no migapliplis i min. Mik lok auret leme Israel, minabam taba i mi leventamtaba atnemi. Moroa ik lok limixin axap kusu dinak marat teren. ");
INSERT INTO mmx_vpl VALUES ("PS76_12","020_76_12","PSA","76","12","12","Neni ik lox asi laxamdak at lavaorong silok dit las di, la lavaorong dik marat aleng tinotno teren. ");
INSERT INTO mmx_vpl VALUES ("PS77_1","020_77_1","PSA","77","1","1","Nia ang teng silok ti ne Moroa, ang teng silok la ing tonga ia. ");
INSERT INTO mmx_vpl VALUES ("PS77_2","020_77_2","PSA","77","2","2","Angising ti Leeme Silok keneng at levenaleng at levenmumuat. La at levenaleng kanimin axap, angosong aurut mi lukngak keneng at levesingising tarak, ketla lodoxoma rak kopmen nat kis bus. ");
INSERT INTO mmx_vpl VALUES ("PS77_3","020_77_3","PSA","77","3","3","At lengkonaleng amdoma mumu ne Moroa, lamamas tarak ixot lottu saga la arat mas gaaga. La mo do anam doma mumu levelinga ren, arak lox abulubun bok tarak. ");
INSERT INTO mmx_vpl VALUES ("PS77_4","020_77_4","PSA","77","4","4","Neni ik lox ia ara tuang aan at lengkanimin. Lodoxoma saasaa i suxuna lorooro rak, kuren la axo epovo ri vaase tekolinga. ");
INSERT INTO mmx_vpl VALUES ("PS77_5","020_77_5","PSA","77","5","5","Am doma levenaleng ira vovolo vam la aram doma su bok at levenmaares me gano axa. ");
INSERT INTO mmx_vpl VALUES ("PS77_6","020_77_6","PSA","77","6","6","At laaleng kanimin axap, a pubeles at levendoxoma lolos aleng. Am doma mumu u ne Moroa, la ara susue bok axa ia xeretna. ");
INSERT INTO mmx_vpl VALUES ("PS77_7","020_77_7","PSA","77","7","7","“Kereva, Leeme Silok naba lox abulubun kepe amisik nedik limixin me Israel? Kopla neni noxo momo bok ba minedik? ");
INSERT INTO mmx_vpl VALUES ("PS77_8","020_77_8","PSA","77","8","8","Kereva, labalamu ren tinedik ira xap ta kopla ira los polo vam laxakaape ren ti kok avukat dik? ");
INSERT INTO mmx_vpl VALUES ("PS77_9","020_77_9","PSA","77","9","9","Kereva, Moroa ira domampe vam i xusu neni na lox asuusu lebelen tuntun ti limixin teren? Kopla lebelemamao ren na ira soxun asu vam lebelen tuntun teren?” ");
INSERT INTO mmx_vpl VALUES ("PS77_10","020_77_10","PSA","77","10","10","Melemu aga vaase xeretna, “Lara lavanga i lox abulu ia xeretna, neni na ne Moroa ixo lok tatao bok ba nedik.” ");
INSERT INTO mmx_vpl VALUES ("PS77_11","020_77_11","PSA","77","11","11","Ketla nenia anabam doma amisik leven gugu silok taram ugak lox i, Leeme Silok. Anabam doma su la ana paase asu lempanga sangsangu no nenu ugarak lok pam i ga migomgo. ");
INSERT INTO mmx_vpl VALUES ("PS77_12","020_77_12","PSA","77","12","12","Anabam doma mumu mo levempanga axap nenu ugarak lok pam i. Anaba paase eburu minu mumu na levempanga lolos nenu uga lox i. ");
INSERT INTO mmx_vpl VALUES ("PS77_13","020_77_13","PSA","77","13","13","O Moroa, leven gugu axap nenu uk lox i, ik mokso aleng tinotno. Kopmen bok ba temoroa go i silok ngan u. ");
INSERT INTO mmx_vpl VALUES ("PS77_14","020_77_14","PSA","77","14","14","Nenu vam nom ne Moroa uk lok lempanga sangsangu. La ugak lox asuusu lolos silok taram kusu levenabung mixin petpes dina ven i. ");
INSERT INTO mmx_vpl VALUES ("PS77_15","020_77_15","PSA","77","15","15","La mumu mun mo lolos taram, uga lox epovo i xusu una lox asepmus limixin taram, nedi livipisik li at ne Jakop la at ne Josep. ");
INSERT INTO mmx_vpl VALUES ("PS77_16","020_77_16","PSA","77","16","16","O Moroa. At loxonaleng laradan mi laras diga reven u, digak marat. La lisimaramain at laras ga dede. ");
INSERT INTO mmx_vpl VALUES ("PS77_17","020_77_17","PSA","77","17","17","Lempat main bet ga soobang asu larakabu. La leretepaavat boro vana at laxalibet, la lavanga ga mam su boro at laramera manman axap. ");
INSERT INTO mmx_vpl VALUES ("PS77_18","020_77_18","PSA","77","18","18","Leretepaavat at lengkon takabu ram ga teposok su, la losoosoo at lavanga ga mam ga soosoo axasep lavatbung menemen. La lavatbung menemen ga dede la gangne. ");
INSERT INTO mmx_vpl VALUES ("PS77_19","020_77_19","PSA","77","19","19","Ugat pas kantubu at loxontas, la uga xoxorop loxontas main. Ketla maxo epovo ri ven kaka lenain at luxangkedek taram. ");
INSERT INTO mmx_vpl VALUES ("PS77_20","020_77_20","PSA","77","20","20","Ugam lam limixin taram ga ngan laradi loklok tatao sipsip, la uga lok li ne Moses mi ne Aron kusu dunam gomgonga di. ");
INSERT INTO mmx_vpl VALUES ("PS78_1","020_78_1","PSA","78","1","1","Limixin tarak, minang tonga ka i na levenanasa rak, la minam doma mumu lempanga nia ana paase i. ");
INSERT INTO mmx_vpl VALUES ("PS78_2","020_78_2","PSA","78","2","2","Nia anaba tong asu levempapaase poovo ridi la ana re musumus levempanga megano ua gak lox alipe. ");
INSERT INTO mmx_vpl VALUES ("PS78_3","020_78_3","PSA","78","3","3","Mo levelinga ua tagara ronga vam i la tagaklen ka i, mo levelinga ua lavalabat atdik diga tere avolo i ridik. ");
INSERT INTO mmx_vpl VALUES ("PS78_4","020_78_4","PSA","78","4","4","Ata xo lok pepe i na at laxamdak mi laxaalik atnedik. Ataba tere i ri mo lavaola dibap tavasu melemu mumu mo lolos at Leeme Silok, la leven gugu silok teren la levempanga maraanu ua neni gara lok pam i. ");
INSERT INTO mmx_vpl VALUES ("PS78_5","020_78_5","PSA","78","5","5","Neni ga raba leventaangas manmanton mi Laulis Linga ren ti limixin me Israel, nedi livipisik li at ne Jakop. Neni ga paase alolos i ri lavalabat atnedik kusu dinaba anasa laxamdak mi laxaalik atnedi mi Laulis Linga, ");
INSERT INTO mmx_vpl VALUES ("PS78_6","020_78_6","PSA","78","6","6","kusu mo lavaola melemu dinabakleklen i la dinaba tere avolo box i ri luvutnitna di. ");
INSERT INTO mmx_vpl VALUES ("PS78_7","020_78_7","PSA","78","7","7","La mumu mun na langas, dinaba nunu saga rinotno at ne Moroa la dinoxom domampe lempanga neni garak lok pam i, ketla diba mumu asu amisik Laulis Linga ren. ");
INSERT INTO mmx_vpl VALUES ("PS78_8","020_78_8","PSA","78","8","8","Di noxok lok ngan lavalabat atnedi ua diga gagang linga, la digang tonga xepe amisik levelinga at ne Moroa. La lesepsep sogo atnedi rin goxo lolos la di goxo ruturun amisik tin. ");
INSERT INTO mmx_vpl VALUES ("PS78_9","020_78_9","PSA","78","9","9","Leme Epraem, diga ruuna laxanbanara eburu mi levesoso, diga sixiro at laaleng at leesep. ");
INSERT INTO mmx_vpl VALUES ("PS78_10","020_78_10","PSA","78","10","10","Diga los polo lekabus atnedi mi ne Moroa. La di goxopara na ronga res at Laulis Linga ren. ");
INSERT INTO mmx_vpl VALUES ("PS78_11","020_78_11","PSA","78","11","11","Diga domampe lempanga neni ga lok pam i, i ngan mo lempanga sangsangu ni ga lox i ro melamgo atdi. ");
INSERT INTO mmx_vpl VALUES ("PS78_12","020_78_12","PSA","78","12","12","Ap mo levenaleng lavalabat atnedi diga reven tinotno ne Moroa gak lok lempanga sangsangu ro at lemelubu ro Soan ua ik lok keneng at lenep silok Isip. ");
INSERT INTO mmx_vpl VALUES ("PS78_13","020_78_13","PSA","78","13","13","Neni ga lox epeseves loxontas la ga lam avolo di ren. La ni ga lok mo lunep tas ga tu ngan luvat kapkapla. ");
INSERT INTO mmx_vpl VALUES ("PS78_14","020_78_14","PSA","78","14","14","At levenaleng kangking, neni gam lam di mi lovotakabu la at lengkanimin ni gam lam di mi langangao at laxao. ");
INSERT INTO mmx_vpl VALUES ("PS78_15","020_78_15","PSA","78","15","15","Neni gak lok pagam lemparuat to at lamatbin la gam taba di mi levendan boro xa xopok at lebelen laxangka. ");
INSERT INTO mmx_vpl VALUES ("PS78_16","020_78_16","PSA","78","16","16","Neni ga lok ladan kusu na sen su boro xeneng at lavaruat la ga lok mo ladan ga sesen ngan lavatdan silok. ");
INSERT INTO mmx_vpl VALUES ("PS78_17","020_78_17","PSA","78","17","17","Ketla nedi leme Israel di goxo xap tik lok leveloklok kakapmek ti ne Moroa, la digang tonga viribang at Leeme Avolo ro at lamatbin. ");
INSERT INTO mmx_vpl VALUES ("PS78_18","020_78_18","PSA","78","18","18","Diga lox asuusu rinotno i xusu dina lok tong ne Moroa keneng at levempapaase lolos atnedi ri leveluxa salai diga vavara rin. ");
INSERT INTO mmx_vpl VALUES ("PS78_19","020_78_19","PSA","78","19","19","Diga tere asu at ne Moroa xeretna, “Kereva, i epovo ne Moroa naba raba dik mi teveluxa de at na lamatbin? ");
INSERT INTO mmx_vpl VALUES ("PS78_20","020_78_20","PSA","78","20","20","I ruturun do neni ga viksa lavaruat, la ladan ga rem soobang su ngan ladanut. Ketla kereva, i epovo bok do neni na raba bok nema mi lengkongkide eburu mi tempanga lomlomon?” ");
INSERT INTO mmx_vpl VALUES ("PS78_21","020_78_21","PSA","78","21","21","Kuren la Leeme Silok ga ronga di la ga belemamao aleng di. La neni ga lox asongot di mi laxao, la lebelemamao ren tinedi ga sisilok. ");
INSERT INTO mmx_vpl VALUES ("PS78_22","020_78_22","PSA","78","22","22","Atla di goxo nunu saga ren la di goxo nunu bok do neni naba lok tatao di ro at lamatbin. ");
INSERT INTO mmx_vpl VALUES ("PS78_23","020_78_23","PSA","78","23","23","Ketla neni ga vaase ri laxalibet no vana la ga tong i ri laramusmaragu ren kusu na rem suang. ");
INSERT INTO mmx_vpl VALUES ("PS78_24","020_78_24","PSA","78","24","24","Ap mo levenaleng neni ga raba di mi lamaana boro vana at laxalibet. At na mun langas ni ga lox asu lempanga anan tinedi ri anan. ");
INSERT INTO mmx_vpl VALUES ("PS78_25","020_78_25","PSA","78","25","25","Kuren la diga anan leveluxa at lubung angelo, la ne Moroa ga lox epovo axap lavavara atnedi. ");
INSERT INTO mmx_vpl VALUES ("PS78_26","020_78_26","PSA","78","26","26","Mi lolos teren neni ga lok bok lemere manman boronak kusu nat mas. Ni ga lox araut lamatmas at lemere manman boroxun, ");
INSERT INTO mmx_vpl VALUES ("PS78_27","020_78_27","PSA","78","27","27","la ga raba asu laxampixa ukopok ti limixin la diga buaang aleng ngan laxanit kapulang nou loxon. ");
INSERT INTO mmx_vpl VALUES ("PS78_28","020_78_28","PSA","78","28","28","La digam subu ro xantubu ap mo lemenemen la kangkan laraogu kadis. ");
INSERT INTO mmx_vpl VALUES ("PS78_29","020_78_29","PSA","78","29","29","Kuren la limixin diga vanan la diga anan mais. Ne Moroa ga raba nedi mi leveluxa ua nedi diga vavara i. ");
INSERT INTO mmx_vpl VALUES ("PS78_30","020_78_30","PSA","78","30","30","Ketla di goxok lox axap ba langaongao anan atnedi, keke i do move digara vanan. ");
INSERT INTO mmx_vpl VALUES ("PS78_31","020_78_31","PSA","78","31","31","Kuren la ne Moroa ga belemamao di la ga sev amet nedi luvuraau lolos avukat at leme Israel. ");
INSERT INTO mmx_vpl VALUES ("PS78_32","020_78_32","PSA","78","32","32","Ketla limixin di goxo doma mu i na levempanga la move digak lok leveloklok kakapmek. Lempanga sangsangu bok di goxo doxoma mu i la diga ke xepe lununu saga ren. ");
INSERT INTO mmx_vpl VALUES ("PS78_33","020_78_33","PSA","78","33","33","Kuren la ne Moroa ga lox axap soso mun leventooro atnedi mi langsangan lumumuat la levenaleng at lorooro atdi ga xap kot. ");
INSERT INTO mmx_vpl VALUES ("PS78_34","020_78_34","PSA","78","34","34","At lengkonaleng neni gap sev amet lentaba atnedi, nedi mo lentaba diga ba tepukus taba i. Diga ngaleeng la diga ngising tin mi lorooro axap atnedi. ");
INSERT INTO mmx_vpl VALUES ("PS78_35","020_78_35","PSA","78","35","35","Diga doma ka i do ne Moroa neni Lurutu See Pe at lorooro atnedi, la do mo Lanaraavuk ga vot ngan Laradi Loklok Tooro atdi. ");
INSERT INTO mmx_vpl VALUES ("PS78_36","020_78_36","PSA","78","36","36","Ketla levelinga atnedi ga umsu mi laxaxarang la goxopmen teruturun at levelinga atdi. ");
INSERT INTO mmx_vpl VALUES ("PS78_37","020_78_37","PSA","78","37","37","Di goxo ruturun tin, la di goxo mumu asu lekabus diga lox i eburu min. ");
INSERT INTO mmx_vpl VALUES ("PS78_38","020_78_38","PSA","78","38","38","Ketla ne Moroa ga lox asuusu lebelen tuntun tidi atla nedi limixin teren. Neni ga doxoma xepe leveng kakapmek atnedi la ni goxo sev amet nedi. Buaang laxanaleng neni gam tebeng amlong lumukmusak teren la gak lox asi mo lolos ap mo lebelemamao silok teren. ");
INSERT INTO mmx_vpl VALUES ("PS78_39","020_78_39","PSA","78","39","39","Neni gakleklen i do nedi limixin mun ua neni ga rudum nedi mi laxangka, la lorooro atnedi goxo babaalom. Diga lok ngan mun lamanman it mas polo la ira onon tino nga. ");
INSERT INTO mmx_vpl VALUES ("PS78_40","020_78_40","PSA","78","40","40","Digang tonga viribang solo ren to at lamatbin. La buaang mene nga laxanaleng digak lox antun i. ");
INSERT INTO mmx_vpl VALUES ("PS78_41","020_78_41","PSA","78","41","41","La digak lok tong pen amu amgo ne Moroa la digak lox abulu i, keke i do neni ne Moroa la Laradi Melemelengan me Israel. ");
INSERT INTO mmx_vpl VALUES ("PS78_42","020_78_42","PSA","78","42","42","Diga doma aie i do lolos teren i silok aleng, la mo bok laaleng ua neni ga lox asepsu di basinge limixin munepen minedi, ");
INSERT INTO mmx_vpl VALUES ("PS78_43","020_78_43","PSA","78","43","43","la ga lok bok levempanga sangsangu silok to at lemelubu ro Soan keneng at lenep silok Isip. ");
INSERT INTO mmx_vpl VALUES ("PS78_44","020_78_44","PSA","78","44","44","Neni ga vuk gili laradan ti lok ngan lada, la leme Isip di goxo ruuna tevendan ti inin. ");
INSERT INTO mmx_vpl VALUES ("PS78_45","020_78_45","PSA","78","45","45","Neni ga riki abeles laxanulang ukeneng tidi ua ga raba nedi mi losongsongot silok, la laxangkoak ua ga lok kapmek levenmenemen atdi. ");
INSERT INTO mmx_vpl VALUES ("PS78_46","020_78_46","PSA","78","46","46","Neni ga riki asu laxasixu ri anan levempeeve atnedi la ga lok kapmek axap leventaamang atnedi. ");
INSERT INTO mmx_vpl VALUES ("PS78_47","020_78_47","PSA","78","47","47","Neni ga sev amet larauna vaen mi lavatbet uat, la ga sev amet bok larauna angnu mi langsangan lumudut. ");
INSERT INTO mmx_vpl VALUES ("PS78_48","020_78_48","PSA","78","48","48","Neni ga sev amet laxanbulumaxao atnedi, mi lavatbet uat, la ga sev amet laxasipsip atnedi mi lavanga ga mam. ");
INSERT INTO mmx_vpl VALUES ("PS78_49","020_78_49","PSA","78","49","49","Ni ga lox abaava rinotno di at loxonaleng ni ga soobang asu lebelemamao sepsep teren, mo gat pot ngan ta laradi sepsev amet tadi. ");
INSERT INTO mmx_vpl VALUES ("PS78_50","020_78_50","PSA","78","50","50","Neni goxo ranga alis lebelemamao ren kopla gita lox asepsu nedi leme Isip, ketla ga sev amet di mi levenanmeres sepsev amet. ");
INSERT INTO mmx_vpl VALUES ("PS78_51","020_78_51","PSA","78","51","51","Neni ga sev amet laxamdak avot at lara koenasun axap me Isip. ");
INSERT INTO mmx_vpl VALUES ("PS78_52","020_78_52","PSA","78","52","52","Melemu neni ga lam asu limixin teren me Israel ngan laradi loklok tatao sipsip la ga lam avolo di ro lamatbin. ");
INSERT INTO mmx_vpl VALUES ("PS78_53","020_78_53","PSA","78","53","53","Neni gam lam aratao avukat di la di goxok marat. Ketla laras ga repit pavaa limixin munepen minedi la diga met axap pam. ");
INSERT INTO mmx_vpl VALUES ("PS78_54","020_78_54","PSA","78","54","54","Neni ga lam li di ro at lenep kangka xaala ren la uto at levengkaana no neni ga los kaka i. ");
INSERT INTO mmx_vpl VALUES ("PS78_55","020_78_55","PSA","78","55","55","Neni ga saksu mi limixin mego at levenaleng limixin teren diga pubeles. La ga vesinga laxangka atnedi xantubu at levenabung mixin me Israel, la gam taba limixin teren mi laramenemen atnedi limixin mego. ");
INSERT INTO mmx_vpl VALUES ("PS78_56","020_78_56","PSA","78","56","56","Ketla leme Israel diga ronga viribang at Lanaraavuk ne Moroa, la diga lok tong pen i mi leveloklok atnedi. Digoxo ronga res at Laulis Linga ren, ");
INSERT INTO mmx_vpl VALUES ("PS78_57","020_78_57","PSA","78","57","57","ketla diga ronga viribang la di goxo ruturun tin ngan lavalabat atdi di goxo ruturun tin. Digak lok ngan lososo xakauk ixo sixit akmokso. ");
INSERT INTO mmx_vpl VALUES ("PS78_58","020_78_58","PSA","78","58","58","Digak lox abelemamao i atla diga lotu saparap levenmoroa xaxarang. Digak lox abelengatngas tinotno i mi laxampoovo moroa atnedi. ");
INSERT INTO mmx_vpl VALUES ("PS78_59","020_78_59","PSA","78","59","59","Moroa ga belemamao at loxonaleng ni ga ven mo lempanga. Kuren la ni ga sok sisixe axap tino limixin teren. ");
INSERT INTO mmx_vpl VALUES ("PS78_60","020_78_60","PSA","78","60","60","Neni ga on basinge rino loogu kadis teren to Silo, ni lanemen ua neni gak lok kantubu at limixin teren. ");
INSERT INTO mmx_vpl VALUES ("PS78_61","020_78_61","PSA","78","61","61","Neni ga siam avolo limixin munepen minedi xusu dina sak paxat ka lobokis at lekabus, neni mo loklok poovo at lolos la lisisixam teren. ");
INSERT INTO mmx_vpl VALUES ("PS78_62","020_78_62","PSA","78","62","62","Neni ga belemamao limixin akmokso ren la ga ke xepe di xusu limixin munepen midi nabap sev amet di. ");
INSERT INTO mmx_vpl VALUES ("PS78_63","020_78_63","PSA","78","63","63","Luvuraau atlok diga remet at levenesep, la luvuraau rixin di goxo ruuna bok ba tavatlok kusu tidi ri vepot atdi. ");
INSERT INTO mmx_vpl VALUES ("PS78_64","020_78_64","PSA","78","64","64","Lavamaasa diga remet keneng at levenesep, la limixin munepen digap sep pepe lavakin atnedi lavamaasa xusu dinoxok saxaanu. ");
INSERT INTO mmx_vpl VALUES ("PS78_65","020_78_65","PSA","78","65","65","La soso mun, Leeme Silok ga beleku kaxat, ga lok ngan ta do ni ga rakdu tuang ngan boro at lanunga. Neni ga lox agagas lodoxoma ren ngan leeme lolos i inin laxadan vaen kusu ti gagas ti esep. ");
INSERT INTO mmx_vpl VALUES ("PS78_66","020_78_66","PSA","78","66","66","La neni ga sak tup tinotno mi limixin munepen min la digak lok mamangan aleng amisik. ");
INSERT INTO mmx_vpl VALUES ("PS78_67","020_78_67","PSA","78","67","67","Ketla neni ga lox abulubun kepe livipisik li at ne Josep, nedi lubung mixin me Epraem. Ni goxo soxolik ka di. ");
INSERT INTO mmx_vpl VALUES ("PS78_68","020_78_68","PSA","78","68","68","Ketla ni ga soxolik ka manga lubung mixin me Juda mi lakaana Saion, mo loxot ua lebelen ga tu rinotno i. ");
INSERT INTO mmx_vpl VALUES ("PS78_69","020_78_69","PSA","78","69","69","La neni ga vaxaru loogu laplavang tin go, i lok ngan lemenemen aulis teren noxun pana at laxalibet. Neni ga lox atmatkun tinotno i ngan at na xa lavatkangka axap, la gak lox alolos i kusu naba nemen avukat amisik kuren. ");
INSERT INTO mmx_vpl VALUES ("PS78_70","020_78_70","PSA","78","70","70","Neni ga soxolik ka lasaxaruki ren ne Devit ngan loorong. Ni ga lam asu xaka i ro at loxot anan at laxasipsip, ");
INSERT INTO mmx_vpl VALUES ("PS78_71","020_78_71","PSA","78","71","71","ap mo loxot ua neni ne Devit gak lok tatao laxasipsip teren. La ne Moroa ga vaxaxis li i ngan loorong me Israel, ga neni laradi loklox aratao at limixin at ne Moroa. ");
INSERT INTO mmx_vpl VALUES ("PS78_72","020_78_72","PSA","78","72","72","Devit gak lok tatao nedi la goxo reven kepe tepentaba la neni gam gomgonga nedi mi lodoxoma avukat teren. ");
INSERT INTO mmx_vpl VALUES ("PS79_1","020_79_1","PSA","79","1","1","O Moroa, lavamolon digara buxup beles pam at lenep kangka ram. Digara lox amexexe vam loogu laplavang taram i xaala la ira lok kapmek axap. La diga sele utut kepe lemenemen silok Jerusalem. ");
INSERT INTO mmx_vpl VALUES ("PS79_2","020_79_2","PSA","79","2","2","Diga ke xepe lenbantuxu at limixin taram kusu ti lempatpixa silok. Diga ke xepe lenbantuxu at limixin akmokso ram kusu ti laxampanga sio mi lavanuet kangkedek atdi ri anan. ");
INSERT INTO mmx_vpl VALUES ("PS79_3","020_79_3","PSA","79","3","3","Digap sev asu ladaada at limixin taram ngan ta ladan, la ladaada ga sesen ngan ladan to at lengkot axap keneng Jerusalem. Goxopmen tara ga roo su xusu tik mikmit avukat limixin diga remet. ");
INSERT INTO mmx_vpl VALUES ("PS79_4","020_79_4","PSA","79","4","4","Limixin at lubung mixin petpes ua dik lok saparap nema, di paase mumu parang nama. Ding longon sese nama la di paase aksaksa rinama. ");
INSERT INTO mmx_vpl VALUES ("PS79_5","020_79_5","PSA","79","5","5","Leeme Silok. Kereva, lebelemamao ram tinema noxo xap ta? Kereva, mo lebelemamao ram nabak lox amisik ta la naba lox asongot nama ngan laxao? ");
INSERT INTO mmx_vpl VALUES ("PS79_6","020_79_6","PSA","79","6","6","Una lok pukus mo lebelemamao ram kusu na subu mavana ap mo limixin petpes no dixo lotu saparav u, la pana atnedi no dixo ngising saparav u. ");
INSERT INTO mmx_vpl VALUES ("PS79_7","020_79_7","PSA","79","7","7","Atla diga sev amet pam limixin taram. Digara lok kapmek lengkot axap at lenep Israel, ni lenep kangka ram. ");
INSERT INTO mmx_vpl VALUES ("PS79_8","020_79_8","PSA","79","8","8","Uguta lox asongot nema mumu laxakapmek at lavalabat atnema. Una lox asuusu nga lebelen tuntun tinema mo, atla lodoxoma abulubun na i suxuna rinotno nga nama. ");
INSERT INTO mmx_vpl VALUES ("PS79_9","020_79_9","PSA","79","9","9","O Moroa, una lok tooro nema la una lox aroo nema. Una lox asepsu nema basinge na lumumuat la una doma xepe laxapmek atnema xusu levenabung mixin petpes diba raba asinorong u. ");
INSERT INTO mmx_vpl VALUES ("PS79_10","020_79_10","PSA","79","10","10","I lok kapmek do limixin at levenabung mixin petpes diba lok tinema dola, “Ne Moroa nga ua atnemi?” Ma vara i do una lox asongot levenabung mixin petpes atla digap sev amet buaang atnema limixin axa ram. ");
INSERT INTO mmx_vpl VALUES ("PS79_11","020_79_11","PSA","79","11","11","Una ronga lerengteng at limixin dik lok at loogu xokoxo, la mi mo lolos taram una lox asepmus nedi mo limixin munepen di gagas kusu dina sev amet di. ");
INSERT INTO mmx_vpl VALUES ("PS79_12","020_79_12","PSA","79","12","12","Leeme Silok, una vorang i ridi levenabung mixin petpes, mi tavanuti teveloklox asongot axap, mumu mo laxaloklox aksaksa digak lox i ru. ");
INSERT INTO mmx_vpl VALUES ("PS79_13","020_79_13","PSA","79","13","13","Kuren la nema limixin taram, ma ngan laxasipsip taram, manaba tong avukat amisik tu la manaba emi asu amisik minu at levenaleng axap i tu melamgo. ");
INSERT INTO mmx_vpl VALUES ("PS80_1","020_80_1","PSA","80","1","1","O laradi loklok tatao sipsip me Israel. Nenu Lamgomgo at limixin taram, una ronga atnema. Ut kis at loxonin orong taram ik lok mavana at lempanga raptava (cherubim). ");
INSERT INTO mmx_vpl VALUES ("PS80_2","020_80_2","PSA","80","2","2","Una ru asuvos ti levenabung mixin taram me Epraem, Beniamin, la Manase. Una lox ase nema mi lolos taram. Ude u la una lox asepsu nema! ");
INSERT INTO mmx_vpl VALUES ("PS80_3","020_80_3","PSA","80","3","3","O Moroa, una siam ka amlong nema! Una lox asuusu lebelen tuntun taram tinema, kusu manaba roo su. ");
INSERT INTO mmx_vpl VALUES ("PS80_4","020_80_4","PSA","80","4","4","Leeme Silok, nu Lanaraavuk ne Moroa. Naba se ba ua mo lebelemamao ram ti levesingising at limixin taram? ");
INSERT INTO mmx_vpl VALUES ("PS80_5","020_80_5","PSA","80","5","5","Ugara raba vam nema mi levenanbulu ua ga lok an mais nema ngan lempanga anan, la i lok ngan ta do magara inin pam lempatbuxom kamkabili dan at lengkatli atnema. ");
INSERT INTO mmx_vpl VALUES ("PS80_6","020_80_6","PSA","80","6","6","Uga lox avolo limixin at levenabung mixin petpes dik lok saparap nema xusu dina vesep eburu ti lok kaka mo lenep kangka atnama. La monga limixin munepen minema di paase aksaksa rinema. ");
INSERT INTO mmx_vpl VALUES ("PS80_7","020_80_7","PSA","80","7","7","Lanaraavuk ne Moroa, una lok ka amlong nema basinge na lumumuat. Una lox asuusu lebelen tuntun taram tinama, kusu manaba roo su. ");
INSERT INTO mmx_vpl VALUES ("PS80_8","020_80_8","PSA","80","8","8","Uga xip ka nema limixin taram boro Isip ngan labanoos vaen. La uga saksu mi limixin at levenabung mixin petpes la ugatlo mo labanoos vaen to at lenep kangka atnedi. ");
INSERT INTO mmx_vpl VALUES ("PS80_9","020_80_9","PSA","80","9","9","Uga lox axasep lenep kusu tin ti suusu. La levenixe ren ga si rinotno uto xopok tubu, la levenoos teren gat las to mavana ap mo lenep kangka axap. ");
INSERT INTO mmx_vpl VALUES ("PS80_10","020_80_10","PSA","80","10","10","Ni gang pung kimit lengkong kaana mi lamamau ren la levengkakan teren ga engeng urut at lemparuna Seda (Cedar) la ga kua abuxumin axav i. ");
INSERT INTO mmx_vpl VALUES ("PS80_11","020_80_11","PSA","80","11","11","Ni ga lox asu levengkakan teren utois axa saparap loxontas Mediterenian la utonak axa bok at ladan sen Iupretis. ");
INSERT INTO mmx_vpl VALUES ("PS80_12","020_80_12","PSA","80","12","12","Tila ba la uga ut asi loroboro no gak lok kangkan i? La monga limixin munepen dit pas polo go, i epovo mene dinam nem kaka lempeven teren. ");
INSERT INTO mmx_vpl VALUES ("PS80_13","020_80_13","PSA","80","13","13","La laxanbo sio dirat pas axangka i, la laxampanga vetpes bok mi lavanuet kangkedek atdi boro laxairing, dira vanan levempeven teren. ");
INSERT INTO mmx_vpl VALUES ("PS80_14","020_80_14","PSA","80","14","14","Lanaraavuk ne Moroa, una repukus tinema! Una ven asi boroxun pana at laxalibet tinema. Ude u la una lox asepsu limixin taram! ");
INSERT INTO mmx_vpl VALUES ("PS80_15","020_80_15","PSA","80","15","15","Ude u la una lox asepsu na labanoos vaen no nenu ugatlo li i. Na labanoos vaen tamaxat ba mo, nu uga lox asuusu dangdangun la alolos box i. ");
INSERT INTO mmx_vpl VALUES ("PS80_16","020_80_16","PSA","80","16","16","Lavamunepen minema digara ra koxorop asi vam i la digara song arup laxao ren. Una sep di mi lebelemamao ram la una sev amet asonao rino di! ");
INSERT INTO mmx_vpl VALUES ("PS80_17","020_80_17","PSA","80","17","17","Una lok see atnema limixin no nenu uga soxolik ka vam nama. Nema lubung mixin ua nenu uga lox alolos nema. ");
INSERT INTO mmx_vpl VALUES ("PS80_18","020_80_18","PSA","80","18","18","Ma noxo repukus basinge bok ba u. Una kox arooro nema, kusu manaba vemi asu minu. ");
INSERT INTO mmx_vpl VALUES ("PS80_19","020_80_19","PSA","80","19","19","Leeme Silok, Lanaraavuk ne Moroa. Una siam ka amlong nema, una lox asuusu lebelen tuntun taram tinema, kusu manaba roo su. ");
INSERT INTO mmx_vpl VALUES ("PS81_1","020_81_1","PSA","81","1","1","Nemi minap kup mi leklek ti ne Moroa, neni Lentupe rinedik. Minak pixan emi asu ri ne Moroa at ne Jakop! ");
INSERT INTO mmx_vpl VALUES ("PS81_2","020_81_2","PSA","81","2","2","Mina vaxaru kaxat laxaka at livixan la minak sak leven tambarin. Minak sak lengkaka pixan avukat to at lempat taaleng mi lempat gita. ");
INSERT INTO mmx_vpl VALUES ("PS81_3","020_81_3","PSA","81","3","3","Minat mas lempat tu ap mo levenaleng silok, at laaleng at lagaaling maxat la at laaleng at lagaaling i re kobot. ");
INSERT INTO mmx_vpl VALUES ("PS81_4","020_81_4","PSA","81","4","4","Neni na Laulis Linga at leme Israel, la neni langas ne Moroa at ne Jakop ga tong taba di min. ");
INSERT INTO mmx_vpl VALUES ("PS81_5","020_81_5","PSA","81","5","5","Neni ga raba i ri limixin me Israel melemu at loxonaleng neni ga lox asongot limixin at lenep kangka me Isip. Nenia aga ronga laxaka at laradi ua nia a goxo ronga xibis i, ga lok keretna, ");
INSERT INTO mmx_vpl VALUES ("PS81_6","020_81_6","PSA","81","6","6","“Nia aga lok kepe levenmumuat boro at levenantuno atnemi. Aga lok nemi xusu miba soxope asi lempat aknixip uat (birikis). ");
INSERT INTO mmx_vpl VALUES ("PS81_7","020_81_7","PSA","81","7","7","At levenaleng migak lok keneng at levenmumuat to Isip, miga toro ria, la nia aga lox asepsu nemi. Aga lox epovo leventotoro atnemi at loxonaleng agak lok to xeneng at loxot alipe rak no xeneng at lamanman takabu. Aga lok tong pen nemi ro at levem puuvut dan to Meriba. ");
INSERT INTO mmx_vpl VALUES ("PS81_8","020_81_8","PSA","81","8","8","Limixin tarak, mina ronga i na levempapaase aronga rak. Leme Israel, a vara rinotno i xusu minang tonga res tarak! ");
INSERT INTO mmx_vpl VALUES ("PS81_9","020_81_9","PSA","81","9","9","Nemen tinotno nemi guta lotu saparap teven moroa vetpes. ");
INSERT INTO mmx_vpl VALUES ("PS81_10","020_81_10","PSA","81","10","10","Nenia mun Leeme Silok ne Moroa atnemi, la nenia mun aga lam asu nemi boro Isip. Mina vangangba, la anaba raba luxa nemi. ");
INSERT INTO mmx_vpl VALUES ("PS81_11","020_81_11","PSA","81","11","11","Ketla nemi limixin tarak me Israel mi goxo ronga ia, migita goxo ronga res tarak. ");
INSERT INTO mmx_vpl VALUES ("PS81_12","020_81_12","PSA","81","12","12","Kuren la aga ke aie nimi mila lodoxoma atnimi ga vatken mi lorongtonga rubu linga. La miga mumu asu lavavara atnemi keneng at leveloklok miga vavara i. ");
INSERT INTO mmx_vpl VALUES ("PS81_13","020_81_13","PSA","81","13","13","Nia a vavara rinotno i xusu nemi limixin tarak minang tonga ia. La a vara rinotno i xusu minang tonga res tarak! ");
INSERT INTO mmx_vpl VALUES ("PS81_14","020_81_14","PSA","81","14","14","Mo do kuren, nia gitaba sak tup soso mun mi limixin munepen minemi la gira vas asi nedi diga tu tangarang nimi. ");
INSERT INTO mmx_vpl VALUES ("PS81_15","020_81_15","PSA","81","15","15","Nedi ua di belengatngas tia, dinabak milik tiding mi lanmarat to melamgo rak. La mo loklox asongot tinedi naba nemen amisik noxo xap. ");
INSERT INTO mmx_vpl VALUES ("PS81_16","020_81_16","PSA","81","16","16","Ketla anabak lox anan nemi mi levempiao i so misigisigis la anabak lox axap lavavara atnimi mi levendan misiu boro xanubuan.” ");
INSERT INTO mmx_vpl VALUES ("PS82_1","020_82_1","PSA","82","1","1","Moroa it kis silok keneng at lixitkis buru roxun at laxalibet. Neni i sevut li levendoxoma avit keneng at lixitkis buru at leven moroa. Mo levelinga ren i lok keretna, ");
INSERT INTO mmx_vpl VALUES ("PS82_2","020_82_2","PSA","82","2","2","“Mina xap tinotno nga at liila gesenep at levenaleng mik lok levenete. Mi gutak tu taba limixin kapmek! ");
INSERT INTO mmx_vpl VALUES ("PS82_3","020_82_3","PSA","82","3","3","Mina viila mumu avukat loklok atnedi limixin banbalo la lubungkarun mi lodoxoma mokmokso. Mina paase mi luruturun tinedi dik pakes la dixo ruuna tevenasen silok. ");
INSERT INTO mmx_vpl VALUES ("PS82_4","020_82_4","PSA","82","4","4","Minak lox asepmus di boro at lolos at limixin kapmek. ");
INSERT INTO mmx_vpl VALUES ("PS82_5","020_82_5","PSA","82","5","5","Laxampanga vereven aie nimi! Langas panga rangtangku! Loklok atnimi ipsopso aleng tinotno! La kopmen tara atnimi at na lavatbung menemen i tong asu levelinga manmanton ting tong ina.” ");
INSERT INTO mmx_vpl VALUES ("PS82_6","020_82_6","PSA","82","6","6","La nenia aga lok bok tidi, “Nemi lavaanat moroa. Nemi axap luvutnitna Leeme Avolo. ");
INSERT INTO mmx_vpl VALUES ("PS82_7","020_82_7","PSA","82","7","7","Ketla minaba remet ngan luvuttadi at na laxangka. Lorooro atnemi naba vaxap ngan bok lorooro at luvutnitna lavaorong.” ");
INSERT INTO mmx_vpl VALUES ("PS82_8","020_82_8","PSA","82","8","8","O Moroa, ude u la unam gomgonga lavatbung menemen. Larabung mixin axap, ni ataram. ");
INSERT INTO mmx_vpl VALUES ("PS83_1","020_83_1","PSA","83","1","1","O Moroa, ugutak lok sixim, ugatang longivilo, la ugatam pamngus! ");
INSERT INTO mmx_vpl VALUES ("PS83_2","020_83_2","PSA","83","2","2","Una ven ba limixin munepen minu di lolos kusu diba remkaa su, la nedi no di belengatngas tu dirang tonga viribang. ");
INSERT INTO mmx_vpl VALUES ("PS83_3","020_83_3","PSA","83","3","3","Di vetong li leven taangas alipe xusu dibak lok mo laxakapmek ti limixin taram. Dik lok leven taangas kusu ti sosolo arup nedi ua uk lok see atdi. ");
INSERT INTO mmx_vpl VALUES ("PS83_4","020_83_4","PSA","83","4","4","Di paase xeretna, “Ude nimi, ata sele utut lenep silok Israel eburu mi limixin di nemen go, kusu limixin axap diba domampe axap tino di.” ");
INSERT INTO mmx_vpl VALUES ("PS83_5","020_83_5","PSA","83","5","5","Di sisiam mu mo levempapaase li atdi la dik lok momo ri tu buru xusu ti vekini minu, ne Moroa. ");
INSERT INTO mmx_vpl VALUES ("PS83_6","020_83_6","PSA","83","6","6","Nedi limixin me Edom la me Ismael, leme Moap mi leme Agirit; ");
INSERT INTO mmx_vpl VALUES ("PS83_7","020_83_7","PSA","83","7","7","limixin me Gebal mi leme Amon; limixin me Amalek, leme Pilistia la leme Taia. ");
INSERT INTO mmx_vpl VALUES ("PS83_8","020_83_8","PSA","83","8","8","Leme Asiria di ru buru bok midi atla di vara i xusu dina lok tooro leme Amon la Moap, nedi livipisik li at ne Lot. ");
INSERT INTO mmx_vpl VALUES ("PS83_9","020_83_9","PSA","83","9","9","Unap sep kapmek bok di ngan ugap sep kapmek leme Midien, Sisera, la Jabin to at ladan Kison. ");
INSERT INTO mmx_vpl VALUES ("PS83_10","020_83_10","PSA","83","10","10","Uga sak tup midi ro Endo, la lenbantuxu atnedi garap sopso ro at laxangka. ");
INSERT INTO mmx_vpl VALUES ("PS83_11","020_83_11","PSA","83","11","11","Una sev asi bok lubung amgomgo atnedi ngan uga lox i ri ne Orep mi ne Seep, la una sak tup mi lavaeme silok atnedi ngan i mo uga lox i ri ne Zeba mi ne Salmona xuren. ");
INSERT INTO mmx_vpl VALUES ("PS83_12","020_83_12","PSA","83","12","12","Atla nedi diga vaase xeretna, “Ataba lok kaka amlong mo lenep kangka at ne Moroa ridik.” ");
INSERT INTO mmx_vpl VALUES ("PS83_13","020_83_13","PSA","83","13","13","O Moroa, una sak epeseves di ngan laxakup, la ngan leventuxu piao no lamanman it mas kepe i. ");
INSERT INTO mmx_vpl VALUES ("PS83_14","020_83_14","PSA","83","14","14","Naba lok ngan laxao i kavat lavatbuan, la ngan langangao at laxao i kavat lengkong kaana. ");
INSERT INTO mmx_vpl VALUES ("PS83_15","020_83_15","PSA","83","15","15","Una xala xepe di mi lamanman takabu ram la una lox amarat aleng di mi lavatmanman silok taram. ");
INSERT INTO mmx_vpl VALUES ("PS83_16","020_83_16","PSA","83","16","16","O Leeme Silok, una suxuna di mi lainmangan, la una lok nedi xusu dinaba ven kibis lolos taram. ");
INSERT INTO mmx_vpl VALUES ("PS83_17","020_83_17","PSA","83","17","17","Naba lox avukat do una sak tup midi la lainmarat atnedi nabak lox amisik la noxo xap. Keke di dina remet eburu mi lainmangan i silok aleng. ");
INSERT INTO mmx_vpl VALUES ("PS83_18","020_83_18","PSA","83","18","18","Naba lox avukat do dina xasep do nenu xusuk mun Leeme Silok, la Lamgomgo silok tinotno. Nenu u lolos aleng pana axap at lavatbung menemen. ");
INSERT INTO mmx_vpl VALUES ("PS84_1","020_84_1","PSA","84","1","1","Leeme Silok, nu Lanaraavuk. Nia angkongkat mu loogu laplavang taram! ");
INSERT INTO mmx_vpl VALUES ("PS84_2","020_84_2","PSA","84","2","2","A vavara aleng i xusu ana lotu saparav u go! Am doma onon amisik uto at loogu laplavang taram. La anabak pixan momo mi lorooro axap tarak tu, Luntoo Avolo. ");
INSERT INTO mmx_vpl VALUES ("PS84_3","020_84_3","PSA","84","3","3","Leveng kamkabilin bok dip kip levempotpos atdi ro xeneng at loogu laplavang, la larapixa lixilik (sparrow) bok din tuuna laraogu axa atdi go. La dik lok tatao luvutnitna di ro saparap loxonin laplavang taram. Nenia bok a vara i xusu nak lok saparav u, nu Leeme Silok la Lanaraavuk. Nu Loorong Silok la ne Moroa rak. ");
INSERT INTO mmx_vpl VALUES ("PS84_4","020_84_4","PSA","84","4","4","Lomomo silok atnedi dik lox amisik to at loogu laplavang taram dim suma i, la dik pixan emi asu amisik tu. ");
INSERT INTO mmx_vpl VALUES ("PS84_5","020_84_5","PSA","84","5","5","Lomomo silok atnedi ua nenu um taba di mi lolos dim suma i, la nedi di vavara rinotno i xusu dinat pas ngan lavaose uto lakaana Saion at loogu laplavang. ");
INSERT INTO mmx_vpl VALUES ("PS84_6","020_84_6","PSA","84","6","6","Kuren la at loxonaleng dit pas polo lemelubu vatmang no at lasa Baka, di reven mo lenep na ravasu ngan lenep at levempuuvut dan, la leventakabu avot ik suxa i mi levempat tibung dan. ");
INSERT INTO mmx_vpl VALUES ("PS84_7","020_84_7","PSA","84","7","7","Ap mo lavatpas di ruuna ka lolos maxat. La dinaba rupot to vana at loxongkaana Saion la nedi getgesara dinaba tu ro melamgo at ne Moroa, mo i silok ti levenmoroa axap. ");
INSERT INTO mmx_vpl VALUES ("PS84_8","020_84_8","PSA","84","8","8","O Leeme Silok nu Lanaraavuk ne Moroa, una ronga res at lisingising tarak. O Moroa at ne Jakop, tonga ia! ");
INSERT INTO mmx_vpl VALUES ("PS84_9","020_84_9","PSA","84","9","9","O Moroa, una lox anarong loorong atnema, mo loorong ua nenu ugara soxolik ka vam i. ");
INSERT INTO mmx_vpl VALUES ("PS84_10","020_84_10","PSA","84","10","10","Mo legesa aleng mak lok teren to xeneng at loogu laplavang taram, i silok aleng ti mo legesa abin sangaun kobot aleng mak lok teren to vetpes. Naba lox avukat do ana tu mun amisik to maxamang saparap lumusmaragu at loogu at ne Moroa rak la nemen gat ana nemen avukat amisik to at laraogu at luvuttadi dik lok laxapmek. ");
INSERT INTO mmx_vpl VALUES ("PS84_11","020_84_11","PSA","84","11","11","Leeme Silok, nenu Lurutu See Pe atnema la nu Loorong Silok i ruuna lisisinang, la uk lox asuusu lebelemulus tinama la uk lox asilok nama kusu limixin dina raba asinorong nama. Nenu uxom tebeng alis lempanga avukat basinge nedi dik lok luvukat. ");
INSERT INTO mmx_vpl VALUES ("PS84_12","020_84_12","PSA","84","12","12","Leeme Silok nu Lanaraavuk. Nedi di nunu saga ram din tuuna xaka i lomomo silok! ");
INSERT INTO mmx_vpl VALUES ("PS85_1","020_85_1","PSA","85","1","1","Leeme Silok, ugara lox asuusu vam lebelen tuntun tinema limixin taram me Israel. Ugara lok pam nema la uga lox asang kobot amu manga nama. ");
INSERT INTO mmx_vpl VALUES ("PS85_2","020_85_2","PSA","85","2","2","Ugara doxoma xepe vam lengkakapmek atnema limixin taram la ugara gos kepe vam levesoogong atnama. ");
INSERT INTO mmx_vpl VALUES ("PS85_3","020_85_3","PSA","85","3","3","Lebelemamao ram tinama ga xap tino la uga rebeng alis amlong mo lebelemamao sesele utut taram. ");
INSERT INTO mmx_vpl VALUES ("PS85_4","020_85_4","PSA","85","4","4","O Moroa, nenu Laradi Loklox Asepsu atnema, monga una rebeng ka amlong manga nema basinge levenmumuat, la na xap ta u ri belengatngas amisik tinema! ");
INSERT INTO mmx_vpl VALUES ("PS85_5","020_85_5","PSA","85","5","5","Kereva, unabak belemamao amisik ta nema la noxo xap? Kereva, mo lebelemamao ram noxo xap ta? ");
INSERT INTO mmx_vpl VALUES ("PS85_6","020_85_6","PSA","85","6","6","Una lox alolos amu manga nema, kusu nema limixin taram manaba emi asu minu. ");
INSERT INTO mmx_vpl VALUES ("PS85_7","020_85_7","PSA","85","7","7","O Leeme Silok, una lox asuusu mo labalamu lexen taram, la una lok tooro nema xusu manaba sepmus. ");
INSERT INTO mmx_vpl VALUES ("PS85_8","020_85_8","PSA","85","8","8","Nenia ang tonga lempanga Leeme Silok ne Moroa i paase i. Neni i xaape mi lenmila ridik limixin akmokso ren, mo do ata xomlong ti loklok tangtangku atnedik. ");
INSERT INTO mmx_vpl VALUES ("PS85_9","020_85_9","PSA","85","9","9","Tuturun tinotno do neni i gagas kusu tik lox asepsu nedi dim taba asen silok tin, la mo loklok tooro ren naba nemen amisik eburu minedik at na lenep kangka atnedik. ");
INSERT INTO mmx_vpl VALUES ("PS85_10","020_85_10","PSA","85","10","10","Labalamu eburu mi luruturun at ne Moroa dunaba vot eburu kantubu atnedik. La loklok manmanton eburu mi lenmila ren dunabak lok bok. ");
INSERT INTO mmx_vpl VALUES ("PS85_11","020_85_11","PSA","85","11","11","Limixin mede xopok dinaba ruturun ti ne Moroa, la ne Moroa naba lox asuusu loklok manmanton teren boro vana at laxalibet ti limixin mede xopok. ");
INSERT INTO mmx_vpl VALUES ("PS85_12","020_85_12","PSA","85","12","12","Leeme Silok naba lox asang kobot amu manga dik, la lenep kangka atnedik naba lox asuusu leveluxa dangdangun avukat. ");
INSERT INTO mmx_vpl VALUES ("PS85_13","020_85_13","PSA","85","13","13","At lengkot axap Leeme Silok it pas teren, loklok manmanton naba umsu la kerepmo langas i gagas tin. ");
INSERT INTO mmx_vpl VALUES ("PS86_1","020_86_1","PSA","86","1","1","Leeme Silok, una ronga ia. Una sep siam mu ia, atla ara molos axap la axo epovo ri lok tooro axa ia. ");
INSERT INTO mmx_vpl VALUES ("PS86_2","020_86_2","PSA","86","2","2","Una lox asepsu ia basinge lanmet, atla nia a ruturun amisik tu. Una lox aroo ia, atla nia lasaxaruki ram la a nunu saga ram. ");
INSERT INTO mmx_vpl VALUES ("PS86_3","020_86_3","PSA","86","3","3","Nenu ne Moroa rak, kuren la una lox asuusu lebelen tuntun tia. At levenaleng axap, a ngising tu. ");
INSERT INTO mmx_vpl VALUES ("PS86_4","020_86_4","PSA","86","4","4","O Leeme Silok, una lox aklek ia, lasaxaruki ram, mila levesingising tarak i ruturun amisik tu. ");
INSERT INTO mmx_vpl VALUES ("PS86_5","020_86_5","PSA","86","5","5","Uk lok luvukat tinema limixin taram la um doxoma xepe laxakapmek atnema, la u umsu mi labalamu lexen tinedi axap no di ngising parav u. ");
INSERT INTO mmx_vpl VALUES ("PS86_6","020_86_6","PSA","86","6","6","Leeme Silok, una ronga i na levesingising tarak. Una ronga na lerengteng tarak ti loklok tooro. ");
INSERT INTO mmx_vpl VALUES ("PS86_7","020_86_7","PSA","86","7","7","A toro ru xeneng at levenaleng at levenmumuat, atla up sep siam at levesingising tarak. ");
INSERT INTO mmx_vpl VALUES ("PS86_8","020_86_8","PSA","86","8","8","O Leeme Silok, kopmen bok ba temoroa go i lok ngan u, la xopmen tino teta go ga lok tavanga silok ngan mo lempanga nenu ga lox i. ");
INSERT INTO mmx_vpl VALUES ("PS86_9","020_86_9","PSA","86","9","9","Mo levenabung mixin petpes ua nenu uga rudum li di, dinaba vot pasa u la dina xis tintiding to melamgo ram. La dinaba emi asu minu atla nenu u silok aleng. ");
INSERT INTO mmx_vpl VALUES ("PS86_10","020_86_10","PSA","86","10","10","Nenu Lanaraavuk la uk lok lempanga maraanu. Nenu xusuk mun ne Moroa. ");
INSERT INTO mmx_vpl VALUES ("PS86_11","020_86_11","PSA","86","11","11","Leeme Silok, una anasa ia mi lempanga u vara i xusu ana lox i, la anaba ronga res amisik taram. Una anasa ia xusu anaba gugu taba u mi lorooro axap tarak. ");
INSERT INTO mmx_vpl VALUES ("PS86_12","020_86_12","PSA","86","12","12","O Leeme Silok ne Moroa rak, anaba emi asu minu mi labalak axap. Anaba vavang asu lisisilok taram at levenaleng amisik la noxo xap. ");
INSERT INTO mmx_vpl VALUES ("PS86_13","020_86_13","PSA","86","13","13","Labalamu lexen taram tia i silok aleng! Ugara lox asepsu vam ia basinge lamaaut. ");
INSERT INTO mmx_vpl VALUES ("PS86_14","020_86_14","PSA","86","14","14","O Moroa, limixin loklox aaso nga mo dit pas tangarang ia. La libinam tadi longlong kuxurung mo di lok do dina sev amer ia. Nedi limixin ua dik lox abulubun kepe levelinga ram. ");
INSERT INTO mmx_vpl VALUES ("PS86_15","020_86_15","PSA","86","15","15","Ketla nenu ne Moroa la Leeme Silok tarak, u ruuna lebelen tuntun la labalamu lexen. Uk lox atnaasan, uk belen tuntun, la u ruturun amisik ti limixin taram. ");
INSERT INTO mmx_vpl VALUES ("PS86_16","020_86_16","PSA","86","16","16","Una repukus mu ia la una lox asuusu lebelen tuntun tia. Lox alolos ia la una lox asepsu ia, atla nia a gugu taba u ngan lasaxaruki rinotno ram. ");
INSERT INTO mmx_vpl VALUES ("PS86_17","020_86_17","PSA","86","17","17","Leeme Silok, una lox asuusu mo luvukat taram tia, kusu nedi ua di belengatngas tia, dinaba mangan at loxonaleng dina ven i do ura kok avukar ia la ura lok tooro ia. ");
INSERT INTO mmx_vpl VALUES ("PS87_1","020_87_1","PSA","87","1","1","Leeme Silok ga vaxaru lemenemen silok teren to vana at loxongkaana Saion, mo loxongkaana i xaala. ");
INSERT INTO mmx_vpl VALUES ("PS87_2","020_87_2","PSA","87","2","2","La lavavara ren ti mo lemenemen silok Jerusalem i volo axap mo levenmenemen petpes bok keneng at lenep silok Israel. ");
INSERT INTO mmx_vpl VALUES ("PS87_3","020_87_3","PSA","87","3","3","Nemi limixin boro at lemenemen silok at ne Moroa, mina ronga i mo levempanga maraanu neni i tong asu nom lemenemen mumu u xeretna, ");
INSERT INTO mmx_vpl VALUES ("PS87_4","020_87_4","PSA","87","4","4","“At loxonaleng ana siam ka nedi limixin at levenabung mixin no ding tonga res tarak, anaba lox abeles bok leme Isip mi leme Babilon. Anaba siam abeles ka bok nedi leme Pilistia, Taia, la Itiopia ukeneng la dinaba nemen go ngan limixin bus tinotno me Jerusalem.” ");
INSERT INTO mmx_vpl VALUES ("PS87_5","020_87_5","PSA","87","5","5","Melemu limixin petpes dinaba epaase mumu mo loxot Saion, la diba tong i do larabung mixin axap, nedi mego di. La mo Lanaraavuk naba vaxaxis atmatkun mo loxot. ");
INSERT INTO mmx_vpl VALUES ("PS87_6","020_87_6","PSA","87","6","6","Leeme Silok naba malagan levenasen ap mo limixin me xadiong la naba lox abeles axap di kusu dina ravasu ngan leme Jerusalem tino nga. ");
INSERT INTO mmx_vpl VALUES ("PS87_7","020_87_7","PSA","87","7","7","Dinabak pixan la dinaba tii. Mo loxompixan atdi naba lok keretna, “Lemenemen Saion neni xusuk mun laamkumkun at leveloklox anarong atnedik.” ");
INSERT INTO mmx_vpl VALUES ("PS88_1","020_88_1","PSA","88","1","1","Leeme Silok ne Moroa, nu Laradi Loklox Asepsu rak, ang teng tu at levenaleng kangking la at lengkanimin at pas parav u mi lisingising. ");
INSERT INTO mmx_vpl VALUES ("PS88_2","020_88_2","PSA","88","2","2","Lox epovo lisingising tarak. Tonga ia na ang teng kusu una lok tooro ia! ");
INSERT INTO mmx_vpl VALUES ("PS88_3","020_88_3","PSA","88","3","3","Laxanmumuat solo na ira subu vam mavana rak la i auret kusu ana met. ");
INSERT INTO mmx_vpl VALUES ("PS88_4","020_88_4","PSA","88","4","4","A lok ngan mun nedi ua di auret kusu dina met. Levelolos axap tarak ira xap pam. ");
INSERT INTO mmx_vpl VALUES ("PS88_5","020_88_5","PSA","88","5","5","Ak lok ngan laradi diga ke xepe i ro at lanmet eburu mi labarongan. A lok ngan lau ik midi ro xeneng at lamaaut at labarongan. La nenu ugara domampe axap pam nedi, la ixo epovo bok ba xusu una lok tooro nedi. ");
INSERT INTO mmx_vpl VALUES ("PS88_6","020_88_6","PSA","88","6","6","Ugara lu arup pam minia uto xopok tubu at lamaaut, uto rinotno at lemeroon ua i si aleng. ");
INSERT INTO mmx_vpl VALUES ("PS88_7","020_88_7","PSA","88","7","7","Lebelemamao ram ik midi mavana rak la i lolos aleng. I lok ngan ta do ara dong si axap pam uto at larapo paxanao. ");
INSERT INTO mmx_vpl VALUES ("PS88_8","020_88_8","PSA","88","8","8","Uga lok larapentangas tarak la digara raba rulu ia. Uga lox ia la limixin di milingot tarak. Ak lok keneng at loxokoxo at lanmeres, la axo epovo na sepsu. ");
INSERT INTO mmx_vpl VALUES ("PS88_9","020_88_9","PSA","88","9","9","Luxatli rak na ira molos ta mumu laxasongsongot. Leeme Silok, a toro amisik tu at levenaleng axap, la ara ngosong aurut mi lukngak keneng at levesingising tarak. ");
INSERT INTO mmx_vpl VALUES ("PS88_10","020_88_10","PSA","88","10","10","Kereva, uk lok lempanga sangsangu ri labarongan? Kopla di rooro xat la dira vemi asu minu? ");
INSERT INTO mmx_vpl VALUES ("PS88_11","020_88_11","PSA","88","11","11","Kereva, di paase asu labalamu lexen taram to xeneng at lamaaut kopla di paase asu luruturun taram to at lenep i umsu mi leeteke? ");
INSERT INTO mmx_vpl VALUES ("PS88_12","020_88_12","PSA","88","12","12","Kereva, di ven levempanga sangsangu ram to xeneng at lenep i main bonot kopla di ven luvukat taram to lemenemen at labarongan, ua limixin diga domampe di? Kopmen tinotno. ");
INSERT INTO mmx_vpl VALUES ("PS88_13","020_88_13","PSA","88","13","13","Leeme Silok, a toro ru xusu una lok tooro ia. A ngising amisik tu at levenmaxantamak, kusu una lox asepsu ia basinge lanmet. ");
INSERT INTO mmx_vpl VALUES ("PS88_14","020_88_14","PSA","88","14","14","Leeme Silok, tila la u sok tixirixes kepe ia? Ua lavasuun teren la u raba rulu ia? ");
INSERT INTO mmx_vpl VALUES ("PS88_15","020_88_15","PSA","88","15","15","Ga ruka axa i at levenmaares nia aga aau, agam suma levesongsongot la aga auret kusu ana met. Nia na ara soklu axap at laxanmumuat at leveloklox asongot taram. ");
INSERT INTO mmx_vpl VALUES ("PS88_16","020_88_16","PSA","88","16","16","Laxan belemamao silok taram ik lox amdamda ia. La lesepsep taram ik lox abaava rino ia. ");
INSERT INTO mmx_vpl VALUES ("PS88_17","020_88_17","PSA","88","17","17","At levenaleng amisik duk lok kangkan ia ngan ladanut. La dura si etang amisik tarak to at lengkot axap. ");
INSERT INTO mmx_vpl VALUES ("PS88_18","020_88_18","PSA","88","18","18","Ugara lok pam larapentangas tinotno rak la digara raba rulu vam ia, la lubuxumin ta mo i lok ngan laradi i vemu minia la kopmen tara bok. ");
INSERT INTO mmx_vpl VALUES ("PS89_1","020_89_1","PSA","89","1","1","O Leeme Silok, anabak pixan amisik mumu mo labalamu lexen taram. Anaba vavang amisik do nenu u ruturun tinema limixin taram at levenaleng axap i tu melamgo. ");
INSERT INTO mmx_vpl VALUES ("PS89_2","020_89_2","PSA","89","2","2","Aklen i do labalamu la loklok tatao ram tidi naba tu tuxuruxun amisik, la na nemen tino ngan laxalibet. ");
INSERT INTO mmx_vpl VALUES ("PS89_3","020_89_3","PSA","89","3","3","Uga vaase xeretna, “Nia agara lok pam lekabus mi mo laradi nia aga soxolik kaka i. Neni lasaxaruki rak ne Devit la a agara xaape vam tin, keretna, ");
INSERT INTO mmx_vpl VALUES ("PS89_4","020_89_4","PSA","89","4","4","‘Lavaorong nabap tavasu amisik keneng at livipisik li ram la mo lugugu ti lavaorong nabak lok at livipisik li ram amisik la noxo xap basinge nedi.’” ");
INSERT INTO mmx_vpl VALUES ("PS89_5","020_89_5","PSA","89","5","5","Leeme Silok. Lempixan ip tavasu boro vana laxalibet mumu mo lempanga maraanu uk lox i. Luvuttadi melemelengan dik pixan do u ruturun amisik ti limixin taram. ");
INSERT INTO mmx_vpl VALUES ("PS89_6","020_89_6","PSA","89","6","6","Leeme Silok, kopmen teta roxun pana at laxalibet i lok ngan u. Kopmen teta at lempanga rooro no vana at laxalibet i epovo eburu minu. ");
INSERT INTO mmx_vpl VALUES ("PS89_7","020_89_7","PSA","89","7","7","Keneng at lixitkis buru at limixin kaala, dik marat aleng taram. La nedi axap ding sangu aleng taram. ");
INSERT INTO mmx_vpl VALUES ("PS89_8","020_89_8","PSA","89","8","8","Leeme Silok ne Moroa nu Lanaraavuk, kopmen teta go, lolos teren i volo aleng ngan u. O Leeme Silok, nenu u ruturun at lempanga axap. ");
INSERT INTO mmx_vpl VALUES ("PS89_9","020_89_9","PSA","89","9","9","Um gomgonga mavana ap mo laras lolos, la uk lox amila lolos lempat popaxanao. ");
INSERT INTO mmx_vpl VALUES ("PS89_10","020_89_10","PSA","89","10","10","Uga rit amdamda mo lavatpanga sio ne Raap la uga sev amer i. Uga sak tup mi limixin munepen mi mo lolos silok taram. ");
INSERT INTO mmx_vpl VALUES ("PS89_11","020_89_11","PSA","89","11","11","Laxalibet neni ataram, la lavatbung menemen bok. Uga rudum lavatbung menemen la lempanga axap bok di nemen keneng teren. ");
INSERT INTO mmx_vpl VALUES ("PS89_12","020_89_12","PSA","89","12","12","Uga rudum li lunep borou la boroxun. Lakaana Tabor mi lakaana Eremon dik pixan mi lomomo ru. ");
INSERT INTO mmx_vpl VALUES ("PS89_13","020_89_13","PSA","89","13","13","U lolos pologat! Lolos taram i silok la i volo aleng! ");
INSERT INTO mmx_vpl VALUES ("PS89_14","020_89_14","PSA","89","14","14","Lixitkis amgomgo ram it kis mavana at levelinga manmanton mi lodoxoma avukat. Labalamu eburu mi luruturun dip tavasu asaxaven keneng at lempanga nenu uk lox i. ");
INSERT INTO mmx_vpl VALUES ("PS89_15","020_89_15","PSA","89","15","15","Nedi di lotu saparav u mi levempixan la dik lok maxopok at lebelemulus taram, dinabak lok momo aleng! ");
INSERT INTO mmx_vpl VALUES ("PS89_16","020_89_16","PSA","89","16","16","La di momo amisik at levenaleng axap mumu mun u, la di vemi asu minu mumu luvukat taram. ");
INSERT INTO mmx_vpl VALUES ("PS89_17","020_89_17","PSA","89","17","17","Uk lok nema la mak sak tup mi limixin munepen minema. Uk lok nema xusu mana sak tup midi atla, mumu mun labalamu ram tinama. ");
INSERT INTO mmx_vpl VALUES ("PS89_18","020_89_18","PSA","89","18","18","O Leeme Silok, nenu xa uga soxolik ka lurutu see pe rinema. Nenu xa ne Moroa Melemelengan me Israel. Uga raba nema mi loorong ti lok see atnema. ");
INSERT INTO mmx_vpl VALUES ("PS89_19","020_89_19","PSA","89","19","19","Keneng at lara lisilimet gano, uga paase ri lavaeme vapaase ali ram ua diga ruturun amisik tu. Uga lok keretna, “Nia ara raba vam loklok tooro ri mo laasesep doxodok. Ara raba vam lugugu at loorong tin, neni mo lara nia a soxolik kaka i ro xeneng at limixin. ");
INSERT INTO mmx_vpl VALUES ("PS89_20","020_89_20","PSA","89","20","20","Neni lasaxaruki rak ne Devit ara vaxaxis pam i ngan loorong at loxonaleng aga lox anarong i mi ladan momonok i xaala. ");
INSERT INTO mmx_vpl VALUES ("PS89_21","020_89_21","PSA","89","21","21","Lolos tarak nabak lox amisik eburu min, lolos tarak naba lox alolos i. ");
INSERT INTO mmx_vpl VALUES ("PS89_22","020_89_22","PSA","89","22","22","Lavamunepen min di noxo epovo ri vas asi i. Limixin kapmek di noxo epovo ri sak tup min. ");
INSERT INTO mmx_vpl VALUES ("PS89_23","020_89_23","PSA","89","23","23","Anaba sax amdamda nedi di esep tangarang min, la anaba sev amet nedi axap ua di belengatngas tin. ");
INSERT INTO mmx_vpl VALUES ("PS89_24","020_89_24","PSA","89","24","24","Anaba balamu i la ana lok tatao amisix i. Anaba lox i xusu limixin munepen min di noxo sak tup min. ");
INSERT INTO mmx_vpl VALUES ("PS89_25","020_89_25","PSA","89","25","25","Anaba lox epasum lixitkis orong teren, tuka i ro at laras Mediterenian la uto epopolo at ladan Iupretis. ");
INSERT INTO mmx_vpl VALUES ("PS89_26","020_89_26","PSA","89","26","26","La neni naba vaase ria xeretna, ‘Nenu ne Tamak la ne Moroa rak. Nenu Lurutu See Pe rak la Laradi Loklox Asepsu rak.’ ");
INSERT INTO mmx_vpl VALUES ("PS89_27","020_89_27","PSA","89","27","27","Anaba lox asilox i ngan lamdak avot tarak, la neni naba silok axap ti lavaorong axap at na lavatbung menemen. ");
INSERT INTO mmx_vpl VALUES ("PS89_28","020_89_28","PSA","89","28","28","Anaba lox epovo amisik laxakaape rak tin, la lekabus tarak eburu min naba nemen amisik la noxo xap. ");
INSERT INTO mmx_vpl VALUES ("PS89_29","020_89_29","PSA","89","29","29","La mo leesooxun ngan lubung amgomgo keneng at livipisik li ren, naba nemen amisik ngan laxalibet. Tavaorong nabap tavasu amisik boro at livipisik li ren. ");
INSERT INTO mmx_vpl VALUES ("PS89_30","020_89_30","PSA","89","30","30","Ketla do livipisik li ren dina ronga xepe at Laulis Linga rak la di noxo rooro mu asu leventaangas tarak, ");
INSERT INTO mmx_vpl VALUES ("PS89_31","020_89_31","PSA","89","31","31","la do di noxo doxoma mu levempapaase axasep tarak, la dixo mu asu levempapaase ali rak, ");
INSERT INTO mmx_vpl VALUES ("PS89_32","020_89_32","PSA","89","32","32","anaba lox asongot di mumu laxakapmek atnedi. Anaba lok nedi dina baava mu mo laxapmek atdi. ");
INSERT INTO mmx_vpl VALUES ("PS89_33","020_89_33","PSA","89","33","33","Ketla labalamu rak ti ne Devit noxo xap kopla ana subu kot ap mo laxakaape rak tin. ");
INSERT INTO mmx_vpl VALUES ("PS89_34","020_89_34","PSA","89","34","34","Anoxo los polo lekabus tarak eburu min kopla ana ke xepe tara taxakaape go agara lox pam i eburu min. ");
INSERT INTO mmx_vpl VALUES ("PS89_35","020_89_35","PSA","89","35","35","Aga xaape gesara mene nga keneng at laasen kaala rak la noxo lox ekun bok ba i. La mo laxakaape naba nemen amisik. Anoxo xarang tinotno ne Devit. ");
INSERT INTO mmx_vpl VALUES ("PS89_36","020_89_36","PSA","89","36","36","Neni naban tuuna amisik taxampipisik li, la anaba reven aratao lixitkis orong teren at levenaleng axap laxangking mo ik lok. ");
INSERT INTO mmx_vpl VALUES ("PS89_37","020_89_37","PSA","89","37","37","Na loklok tatao rak naba nemen amisik ngan lagaaling, ua neni i soosoo axasep amisik to vana at lamavangkap.” ");
INSERT INTO mmx_vpl VALUES ("PS89_38","020_89_38","PSA","89","38","38","Ketla nenu ne Moroa, u belemamao mo loorong nenu uga soxolik ka i. Ugara raba rulu vam i la uga sok sisixe i. ");
INSERT INTO mmx_vpl VALUES ("PS89_39","020_89_39","PSA","89","39","39","Ugara los polo vam lekabus taram eburu mi ne Devit, lasaxaruki ram, la ura lox asi aleng i basinge lixitkis teren ngan loorong. ");
INSERT INTO mmx_vpl VALUES ("PS89_40","020_89_40","PSA","89","40","40","Ura ut tereve asi vam larangas uat ik lok kangkan lemenemen silok teren, la ura lok kapmek pam laraogu esep matmatkun teren. ");
INSERT INTO mmx_vpl VALUES ("PS89_41","020_89_41","PSA","89","41","41","La nedi limixin ua dit pas polo go, dim nem kaka lempanga ren. La nedi dik lok saparav i, ding longon sese i. ");
INSERT INTO mmx_vpl VALUES ("PS89_42","020_89_42","PSA","89","42","42","Ura lok tooro vam limixin munepen min kusu dina sak tup mi limixin taram. Ura lok pam limixin munepen la dira momo aleng. ");
INSERT INTO mmx_vpl VALUES ("PS89_43","020_89_43","PSA","89","43","43","U lok lempanga esep teren i lok ngan lempanga gamasa nga la limixin munepen minu dirak sak tup etaba nga midi keneng at levenesep. ");
INSERT INTO mmx_vpl VALUES ("PS89_44","020_89_44","PSA","89","44","44","Ura lok kepe vam laasen silok teren la ura lok pes pam i basinge lixitkis orong teren. ");
INSERT INTO mmx_vpl VALUES ("PS89_45","020_89_45","PSA","89","45","45","Ura lox asioxo vemput ta i la ura vung kimir i mi lainmangan. ");
INSERT INTO mmx_vpl VALUES ("PS89_46","020_89_46","PSA","89","46","46","Leeme Silok, kereva, unak lox alipe rino nga basinge nema? Mo lebelemamao ram na babao ngan laxao la naba se ba ua? ");
INSERT INTO mmx_vpl VALUES ("PS89_47","020_89_47","PSA","89","47","47","Una doma mumu be na lorooro rak it mut tinotno. La unaklen box i do nenu uga rudum li nema mi lenbantuxu gamasa mun! ");
INSERT INTO mmx_vpl VALUES ("PS89_48","020_89_48","PSA","89","48","48","Nege ba naba rooro amisik la noxo met? Taradi naba lok ba xereva xusu ni noxo beles at lamaaut? ");
INSERT INTO mmx_vpl VALUES ("PS89_49","020_89_49","PSA","89","49","49","Leeme Silok, ua nga no lempanga nenu uga lox asuusu i ri lox asaxaven mo labalamu ram? Ua nga no leveng kakaape nenu uga lox i ri ne Devit? ");
INSERT INTO mmx_vpl VALUES ("PS89_50","020_89_50","PSA","89","50","50","Uguta domampe i do ram, la aga vekip mi mo lempapaase vupu at lavamolon. ");
INSERT INTO mmx_vpl VALUES ("PS89_51","020_89_51","PSA","89","51","51","O Leeme Silok. Limixin munepen minu diga paase xapmek ti loorong soksoxolik taram. Di paase aksaksa rin ap mo axap lengkot neni it pas teren. ");
INSERT INTO mmx_vpl VALUES ("PS89_52","020_89_52","PSA","89","52","52","Leemi asu amisik ti Leeme Silok la kopmen tekavaxap teren! Tuturun! Tuturun tinotno! ");
INSERT INTO mmx_vpl VALUES ("PS90_1","020_90_1","PSA","90","1","1","O Leeme Silok, nenu ugak lok ngan amisik loogu aulis atnema lavaola axap. ");
INSERT INTO mmx_vpl VALUES ("PS90_2","020_90_2","PSA","90","2","2","Avot ti laaleng uga rudum li levengkaana la lempanga di rooro xeneng at lavatbung menemen, nenu ugak lox axa ngan ne Moroa i rooro lexen, la unabat kis Moroa amisik la kopmen tekavaxap taram. ");
INSERT INTO mmx_vpl VALUES ("PS90_3","020_90_3","PSA","90","3","3","U tong i ri luvuttadi axap kusu dinaba vee kangka ngan diga ravasu ren. U baba gili amlong di xusu dina repukus ti laxakup. ");
INSERT INTO mmx_vpl VALUES ("PS90_4","020_90_4","PSA","90","4","4","Nenu u ven legesa abin sangaun kobot maares di lok ngan mun legesa aleng. Di lok ngan mun laaleng itinongo, ira onon pam, i lok ngan mun legesa xonatat aleng at laxanimin. ");
INSERT INTO mmx_vpl VALUES ("PS90_5","020_90_5","PSA","90","5","5","Up kip pes kaka nema ngan ladanut. Maxo rooro abao bok, ma ngan lapnobo i sonao. Ma lok ngan levenang i suu valas maxantamak suubu, ");
INSERT INTO mmx_vpl VALUES ("PS90_6","020_90_6","PSA","90","6","6","di suu la di repalas asu lamaraanu, la melemu dira molos la dira met manga ukantinao. ");
INSERT INTO mmx_vpl VALUES ("PS90_7","020_90_7","PSA","90","7","7","U sesele utut nema mi mo lebelemamao ram. Ma emilik sak mumu lebelemamao ram. ");
INSERT INTO mmx_vpl VALUES ("PS90_8","020_90_8","PSA","90","8","8","U saali leveloklok kakapmek atnema ro melamgo ram, mo leveloklox alipe atnema ik lok go ap mo loxot nenu u epovo ri reven kaka di. ");
INSERT INTO mmx_vpl VALUES ("PS90_9","020_90_9","PSA","90","9","9","La lorooro atnema, nenu u tara korop atmur i mi mo lebelemamao ram. La i sonao ngan lavapaase siksikma. ");
INSERT INTO mmx_vpl VALUES ("PS90_10","020_90_10","PSA","90","10","10","Lorooro atnema it pot mun at lavanuti sangaun maares la do ma lolos, maba se ka lavanuan sangaun maares. Ketla ana levenmaares move im taba nema mi leven ekarakat la lainbulu. La soso mun lorooro atnema i vaxap kot, la mara onon tino nga. ");
INSERT INTO mmx_vpl VALUES ("PS90_11","020_90_11","PSA","90","11","11","Kopmen tara go gata suma vam lolos silok at lebelemamao ram. Kopmen bok teta iklen ka ba lanmarat silok, mo lebelemamao silok taram i epovo ri lox asuusu i xeneng atnema. ");
INSERT INTO mmx_vpl VALUES ("PS90_12","020_90_12","PSA","90","12","12","Una anasa nema do lorooro atnema it mut mun kusu manaba ruuna ka lodoxoma avukat. ");
INSERT INTO mmx_vpl VALUES ("PS90_13","020_90_13","PSA","90","13","13","O Leeme Silok, lebelemamao ram naba xap ba lingisa? Una belen tuntun mu nema, limixin me Israel, atla nema limixin tinotno ram! ");
INSERT INTO mmx_vpl VALUES ("PS90_14","020_90_14","PSA","90","14","14","Una suxa amisik nema at leven maxantamak mi labalamu lexen taram, kusu manabak pixan la mana sosoro keneng at lorooro axap atnema at na lavatbung menemen. ");
INSERT INTO mmx_vpl VALUES ("PS90_15","020_90_15","PSA","90","15","15","Una raba nema mi lomomo silok ngan bok pam mo lanbulu silok uga raba nema min ap mo levenmaares magak lok keneng at laxanmumuat solo. ");
INSERT INTO mmx_vpl VALUES ("PS90_16","020_90_16","PSA","90","16","16","Una lox avolo nema lavasaxaruki ram kusu mana ven leven gugu lolos taram. Una lok bok livipisik li atnema xusu dina ven mo lolos silok taram. ");
INSERT INTO mmx_vpl VALUES ("PS90_17","020_90_17","PSA","90","17","17","Leeme Silok ne Moroa atnema, una ke mo loklox anarong taram nak lok keneng atnema. Una lox epovo levendoxoma atnema keneng at leven gugu axap nema ma lox i! ");
INSERT INTO mmx_vpl VALUES ("PS91_1","020_91_1","PSA","91","1","1","Nege it kis esogo eburu mi Leeme Silok, la ik lok maxopok at loklox aratao at Lanaraavuk, ");
INSERT INTO mmx_vpl VALUES ("PS91_2","020_91_2","PSA","91","2","2","i epovo xusu dina tong i rin keretna, “Nenu Lentupe ria la Lurutu See Pe rak. Nenu ne Moroa rak, la nia a nunu saga ram.” ");
INSERT INTO mmx_vpl VALUES ("PS91_3","020_91_3","PSA","91","3","3","Neni naba lox asepsu u basinge levempanga sepsep mo ik lox alipe la basinge bok levenanmeres sepsev amet. ");
INSERT INTO mmx_vpl VALUES ("PS91_4","020_91_4","PSA","91","4","4","Neni naba kok u mi luvapa ren, la unabak lox avukat keneng at loklok tatao ren. Neni i ruturun ti limixin teren, kuren la ni naba lok tatao la na tu banpe u. ");
INSERT INTO mmx_vpl VALUES ("PS91_5","020_91_5","PSA","91","5","5","Unoxo marat at tepanga sepsep at laxanimin kopla limixin sepsep diba vot soso mun at laxangking, ");
INSERT INTO mmx_vpl VALUES ("PS91_6","020_91_6","PSA","91","6","6","kopla tevenanmeres kapmek na lutpot at laxanimin kopla mo lubung gas kapmek dip sep at lengkangking. ");
INSERT INTO mmx_vpl VALUES ("PS91_7","020_91_7","PSA","91","7","7","Tegesa abin sangaun kobot giba met mun go saparav u, la legesa sangaun larabin sangaun kobot go xangkan u, ketla dixo epovo ba ri lok kapmek tekot taram. ");
INSERT INTO mmx_vpl VALUES ("PS91_8","020_91_8","PSA","91","8","8","Unabak milik kaxat la una reven ba i mo limixin kapmek dik lok ka levesongsongot kuren. ");
INSERT INTO mmx_vpl VALUES ("PS91_9","020_91_9","PSA","91","9","9","Ura siam ka vam Leeme Silok i ngan Lentupe ru. Ni Leeme Avolo i ngan Lurutu See Pe ru. ");
INSERT INTO mmx_vpl VALUES ("PS91_10","020_91_10","PSA","91","10","10","Kuren la ba xopmen bok ba tumumuat naba sak pavaa u, la tempanga loklox asongot nat pot saparap laraogu aulis taram. ");
INSERT INTO mmx_vpl VALUES ("PS91_11","020_91_11","PSA","91","11","11","Moroa naba lok li lubung angelo ren kusu dinabak lok tatao u, la kusu dinabak lok see ram at levengkot axap unat pas teren. ");
INSERT INTO mmx_vpl VALUES ("PS91_12","020_91_12","PSA","91","12","12","Dinaba rebeng aurur u mi lengkikngen di xusu tuuat noxo lox asongot tekot at luxangkedek taram. ");
INSERT INTO mmx_vpl VALUES ("PS91_13","020_91_13","PSA","91","13","13","Unabat pas povorok asi lempatlaion mi lempat sii, mo lempatlaion atat la lempat sii mamao. ");
INSERT INTO mmx_vpl VALUES ("PS91_14","020_91_14","PSA","91","14","14","Moroa i vaase xeretna, “Nia anaba lox asepsu mo lara i vavara aleng ia la anaba lok see ap mo lara ua i ven kibis ia do nenia Leeme Silok. ");
INSERT INTO mmx_vpl VALUES ("PS91_15","020_91_15","PSA","91","15","15","At loxonaleng ni na ro ke rak, anaba sep siam at levesingising teren. Do ni na ekip tangarang mi levenmumuat, anabak lok eburu min kusu ti lok tooro i. Anaba lox asepmus i basinge mo levenmumuat la ana xip aurut laasen atdi. ");
INSERT INTO mmx_vpl VALUES ("PS91_16","020_91_16","PSA","91","16","16","Anaba lox anarong i mi lorooro abao, la anabak lox asepmus i at levenmumuat.” ");
INSERT INTO mmx_vpl VALUES ("PS92_1","020_92_1","PSA","92","1","1","O Leeme Silok, loklox avukat tinotno mo do mana tong avukat tu, la manak pixan tim taba asinorong u, O Moroa Avolo. ");
INSERT INTO mmx_vpl VALUES ("PS92_2","020_92_2","PSA","92","2","2","La i lox avukat bok do at lenmaxantamak axap, mana vavang asu mo labalamu lexen taram. La mana vavang asu loklok tuturun tinama at lengkanimin axap. ");
INSERT INTO mmx_vpl VALUES ("PS92_3","020_92_3","PSA","92","3","3","Mana lox i na mi lerengteng at leven gita la lenaon at lengkon taaleng. ");
INSERT INTO mmx_vpl VALUES ("PS92_4","020_92_4","PSA","92","4","4","O Leeme Silok, leven gugu lolos taram ik lox aklek ia. La ak pixan momo mumu mun mo lempanga ugara lok pam i. ");
INSERT INTO mmx_vpl VALUES ("PS92_5","020_92_5","PSA","92","5","5","Leeme Silok, mo leven gugu uga lox asuusu i, i silok aleng! La levendoxoma ram i si aleng! ");
INSERT INTO mmx_vpl VALUES ("PS92_6","020_92_6","PSA","92","6","6","La ixo epovo xusu taradi baulang naklen mo lempanga. Taradi rangtangku bok ixo epovo ri xasep teren. ");
INSERT INTO mmx_vpl VALUES ("PS92_7","020_92_7","PSA","92","7","7","Keke i do limixin kapmek dina posok aleng ngan levempivilis, la nedi dik lok leveloklok bilinga diba ngasang kobot. Ketla ne Moroa naba sele utut axap tino bok di, ");
INSERT INTO mmx_vpl VALUES ("PS92_8","020_92_8","PSA","92","8","8","atla nenu Leeme Silok u silok aleng mavana at lempanga axap la unaba nemen amisik kuren la kopmen tekavaxap teren. ");
INSERT INTO mmx_vpl VALUES ("PS92_9","020_92_9","PSA","92","9","9","Makleklen i do limixin munepen minu dinaba remet kot, la unaba sak tup minedi axap limixin dik lok laxapmek. ");
INSERT INTO mmx_vpl VALUES ("PS92_10","020_92_10","PSA","92","10","10","Ugara lox alolos pam ia ngan lavatbulumaxao aaxa. Ugara lox anarong pam ia mi lomomo. ");
INSERT INTO mmx_vpl VALUES ("PS92_11","020_92_11","PSA","92","11","11","Agara ven pam u, uga sak tup mi limixin munepen minia la aga ronga lerengteng at limixin dik lok laxapmek. ");
INSERT INTO mmx_vpl VALUES ("PS92_12","020_92_12","PSA","92","12","12","Limixin manmanton dinaba ngasang kobot ngan lempar iivin ua i pisik aleng. Dinaba lolos ngan levenuna Seda (Cedar) boro Lebanon. ");
INSERT INTO mmx_vpl VALUES ("PS92_13","020_92_13","PSA","92","13","13","Dinaba lok ngan larauna i suusu ro xeneng at loogu at Leeme Silok, i suusu dangdangun to xeneng at loogu laplavang at ne Moroa atnedik. ");
INSERT INTO mmx_vpl VALUES ("PS92_14","020_92_14","PSA","92","14","14","Mo larauna me gaxatdo nga la ira mukun ta, ketla move ira pisik peeve la lempavaxan move ren i mamaxa la i lolos. ");
INSERT INTO mmx_vpl VALUES ("PS92_15","020_92_15","PSA","92","15","15","Anai, i lox asuusu i do levelinga at Leeme Silok in manton tino amisik, la kopmen tesoogong keneng at Lurutu See Pe rak. ");
INSERT INTO mmx_vpl VALUES ("PS93_1","020_93_1","PSA","93","1","1","Leeme Silok ni Loorong Silok. Laasen teren i volo aleng la neni Lanaraavuk. Kuren la lavatbung menemen mo it kis atmatkun at loxot teren la ixo epovo ri repes meeve. ");
INSERT INTO mmx_vpl VALUES ("PS93_2","020_93_2","PSA","93","2","2","O Leeme Silok, lixitkis taram ngan Loorong Silok ga tu tuxuruxun ka axa at lurutu kaxat, la nenu uga rooro avot ti levenaleng ga ru kaxat. ");
INSERT INTO mmx_vpl VALUES ("PS93_3","020_93_3","PSA","93","3","3","O Leeme Silok, laaknuxup silok ip tava su boro xopok tubu at laras main. Dik lox areng silok lengkaka atnedi mi laaknuxup silok. ");
INSERT INTO mmx_vpl VALUES ("PS93_4","020_93_4","PSA","93","4","4","Leeme Silok it kis amgomgo toxun pana at laxalibet, la lolos teren i volo aleng. I silok ti mo laaknuxup silok boro at laras main, la i lolos polo larapo paxanao at laras. ");
INSERT INTO mmx_vpl VALUES ("PS93_5","020_93_5","PSA","93","5","5","Leeme Silok, Laulis Linga ram i nemen amisik, la loogu laplavang taram i xaala rinotno amisik la kopmen tekavaxap teren. ");
INSERT INTO mmx_vpl VALUES ("PS94_1","020_94_1","PSA","94","1","1","Leeme Silok, nenu ne Moroa uk lox asongot limixin kapmek. Una lox asuusu lebelemamao ram tidi! ");
INSERT INTO mmx_vpl VALUES ("PS94_2","020_94_2","PSA","94","2","2","Nenu laradi ila mumu lorooro at limixin axap. Una beleku kaxat la una raba nedi luvuttadi loklox aaso mi luunun ti laxakapmek atdi! ");
INSERT INTO mmx_vpl VALUES ("PS94_3","020_94_3","PSA","94","3","3","Mo leklek ap mo limixin dik lok laxapmek naba se ba ua? Naba se ba ua, Leeme Silok? ");
INSERT INTO mmx_vpl VALUES ("PS94_4","020_94_4","PSA","94","4","4","Mo loklox aaso at luvuttadi dit los polo Laulis Linga la dirak lox aru di mumu leveloklok kakapmek atnedi. Mo loklok atdi naba xap ba lingisa? ");
INSERT INTO mmx_vpl VALUES ("PS94_5","020_94_5","PSA","94","5","5","Leeme Silok, di rubut puuvus limixin taram, la dik lox abaava nedi no nenu u ruuna di. ");
INSERT INTO mmx_vpl VALUES ("PS94_6","020_94_6","PSA","94","6","6","Dip sev amet lempatnaa mi lubungkarun, la dip sev amet bok lavaose mo dik lok at na lenep kangka atnema. ");
INSERT INTO mmx_vpl VALUES ("PS94_7","020_94_7","PSA","94","7","7","La di paase xeretna do, “Leeme Silok ni kopmen na reven nedik. Moroa me Israel ixo ven lenget ka na loklok tak lox i.” ");
INSERT INTO mmx_vpl VALUES ("PS94_8","020_94_8","PSA","94","8","8","Limixin tarak, kereva rinotno la mik lok sorova baulang gamasa? Minabaklen ba lingisa? ");
INSERT INTO mmx_vpl VALUES ("PS94_9","020_94_9","PSA","94","9","9","Moroa ga lok levenbaalung atnedik. Kereva, neni ixo epovo na ronga nimi? Neni ga lok lengkatli atdik, kopla ni noxo reven nimi? ");
INSERT INTO mmx_vpl VALUES ("PS94_10","020_94_10","PSA","94","10","10","Neni i metlaat ti levenabung mixin petpes, kereva ni noxo lox asongot bok nemi? Neni Laradi Anasa at limixin axap, kereva, kopmen takleklen teren? ");
INSERT INTO mmx_vpl VALUES ("PS94_11","020_94_11","PSA","94","11","11","Leeme Silok iklen axap levendoxoma at limixin. La iklen latnese at levendoxoma etaba atdi. ");
INSERT INTO mmx_vpl VALUES ("PS94_12","020_94_12","PSA","94","12","12","Leeme Silok, lomomo silok mene i mo ik lok ap mo laradi ua nenu u paase aru amisix i, mo laradi ua nenu u anasa amisix i mi Laulis Linga ram! ");
INSERT INTO mmx_vpl VALUES ("PS94_13","020_94_13","PSA","94","13","13","Uk lox amamana i basinge levenaleng at levenmumuat, ise at laaleng di xe lavatmet tik lixo ka luvuttadi dik lok laxapmek. ");
INSERT INTO mmx_vpl VALUES ("PS94_14","020_94_14","PSA","94","14","14","Leeme Silok noxo raba rulu limixin teren. Neni noxo lox abulubun nedi ua neni i ruuna di. ");
INSERT INTO mmx_vpl VALUES ("PS94_15","020_94_15","PSA","94","15","15","Levendoxoma mokmokso nabamlong keneng at levenaleng dina tu at lavapaase. La nedi axap limixin manmanton dinaba su auru rino mo levendoxoma. ");
INSERT INTO mmx_vpl VALUES ("PS94_16","020_94_16","PSA","94","16","16","Nege ga ru katling ia ri ru tangarang mo limixin kapmek? Nege ga lok ka loxot tarak kusu ti ru tangarang mo limixin bilinga? ");
INSERT INTO mmx_vpl VALUES ("PS94_17","020_94_17","PSA","94","17","17","Mo do Leeme Silok gitoxo lok tooro ia, nia ro agita onon soso vam uto at lemenemen at labarongan, ni lemenemen at lavaanat pamngus. ");
INSERT INTO mmx_vpl VALUES ("PS94_18","020_94_18","PSA","94","18","18","Aga vaase xeretna, “Am subu si na ukopok.” Ketla, labalamu lexen taram, Leeme Silok, gam tebeng ama aurur ia. ");
INSERT INTO mmx_vpl VALUES ("PS94_19","020_94_19","PSA","94","19","19","At levenaleng nia a suma levenmumuat la lodoxoma saasaa i suxuna lorooro rak, nenu uk lox amenemen ia la urak lox aklek ia. ");
INSERT INTO mmx_vpl VALUES ("PS94_20","020_94_20","PSA","94","20","20","Nenu kopmen nak lok momo mi luvuttadi rongtonga linga gesenep ua di xaxarang pepe lolos tinotno luvukat at levenaleng ete, la di sisiam ka laxakapmek. ");
INSERT INTO mmx_vpl VALUES ("PS94_21","020_94_21","PSA","94","21","21","Dik lok li levenmumuat mavana at luvuttadi avukat, la di tong aurut liina ti luvuttadi sepsen la kerepmo di sev amet nedi. ");
INSERT INTO mmx_vpl VALUES ("PS94_22","020_94_22","PSA","94","22","22","Ketla Leeme Silok ik lok ngan Lentupe ria. Ne Moroa rak ni Lurutu See Pe. ");
INSERT INTO mmx_vpl VALUES ("PS94_23","020_94_23","PSA","94","23","23","Neni naba lox asongot di mumu mo leveloklok kakapmek atnedi. La ni naba sele utut di mumu mo libilinga atnedi. Leeme Silok ne Moroa atnedik naba lok pes axap tino di. ");
INSERT INTO mmx_vpl VALUES ("PS95_1","020_95_1","PSA","95","1","1","Ude nimi, ata emi asu mi Leeme Silok! Atak pixan mi leklek ti ne Moroa, neni ua ik lok see atnedik! ");
INSERT INTO mmx_vpl VALUES ("PS95_2","020_95_2","PSA","95","2","2","Ata vot saparav i mi levelinga rotong avukat la atak pixan lengkompixan leklek la emi asu rin. ");
INSERT INTO mmx_vpl VALUES ("PS95_3","020_95_3","PSA","95","3","3","Atla Leeme Silok neni Lanaraavuk ne Moroa. Neni Loorong Silok i lolos kimit axap levenmoroa xaxarang. ");
INSERT INTO mmx_vpl VALUES ("PS95_4","020_95_4","PSA","95","4","4","Neni im gomgonga mavana axap at lavatbung menemen, tuka i ro xeneng tubu at lempatbuang i si aleng, la uto xa vana at lempatkaana babaalom. ");
INSERT INTO mmx_vpl VALUES ("PS95_5","020_95_5","PSA","95","5","5","Neni im gomgonga mavana at laras no neni ga lox i. La laxangka bok no neni axa ga rudum i. ");
INSERT INTO mmx_vpl VALUES ("PS95_6","020_95_6","PSA","95","6","6","Ude nimi, la ata xis tintiding la ata ngising tin. Ata xis mi lempatgulom atdik at lemeren Leeme Silok, neni Laradi Runtudum Li atdik! ");
INSERT INTO mmx_vpl VALUES ("PS95_7","020_95_7","PSA","95","7","7","Neni ne Moroa atnedik. La neni ik lok tatao nedik limixin, ta ngan levesipsip no neni im taba luxa di. Mo do mina ronga laxaka at ne Moroa lingina, ");
INSERT INTO mmx_vpl VALUES ("PS95_8","020_95_8","PSA","95","8","8","“Mi gutak lox ametarauat lebelen nimi, ngan lavalabat atnemi digak lox i ro Meriba, la kerekngan bok mo laaleng digak lok to at lamatbin Masa. ");
INSERT INTO mmx_vpl VALUES ("PS95_9","020_95_9","PSA","95","9","9","Diga edak minia go, la diga lok tong ia, keke i do digara ven pam lempanga silok agak lox i ridi. ");
INSERT INTO mmx_vpl VALUES ("PS95_10","020_95_10","PSA","95","10","10","At lavanuet sangaun maares axap, aga bele songsongot tinotno mi limixin ap mo loola. Aga lok keretna, ‘Lebelendi i onon petpes amisik basinge ia la diga ronga xepe levempapaase ali rak.’ ");
INSERT INTO mmx_vpl VALUES ("PS95_11","020_95_11","PSA","95","11","11","Kuren la aga belemamao nedi la aga lok laxakaape matmatkun tinotno xeretna, ‘Dixo epovo rinotno xusu dina beles ap mo loxot loklox amas tarak.’” ");
INSERT INTO mmx_vpl VALUES ("PS96_1","020_96_1","PSA","96","1","1","Mina vixan toxompixan maxat ti Leeme Silok! Limixin at na lavatbung menemen axap, minak pixan ti Leeme Silok! ");
INSERT INTO mmx_vpl VALUES ("PS96_2","020_96_2","PSA","96","2","2","Minak pixan ti Leeme Silok, la mina emi asu min! At levenaleng axap mina vavang mi lagale lavavang do neni ga lox asepmus nedik. ");
INSERT INTO mmx_vpl VALUES ("PS96_3","020_96_3","PSA","96","3","3","Mina vavang asu lisisixam teren uto at larabung mixin petpes, la mina tere limixin axap mi mo lempanga lolos neni gak lox i. ");
INSERT INTO mmx_vpl VALUES ("PS96_4","020_96_4","PSA","96","4","4","Leeme Silok, neni i silok aleng. Kuren la i epovo rinotno do leemi asu atdik tin na silok aleng. Loklox asinorong atnedik tin naba volo axap levenmoroa xaxarang at na lavatbung menemen. ");
INSERT INTO mmx_vpl VALUES ("PS96_5","020_96_5","PSA","96","5","5","Leven moroa ap mo levenabung mixin petpes, nedi levempoovo vanga mun. Ketla mo Leeme Silok, neni ga rudum li lempanga axap tovana at lamavangkap. ");
INSERT INTO mmx_vpl VALUES ("PS96_6","020_96_6","PSA","96","6","6","Lisisixam mi lisisinang duk lok kangkan i. Lolos eburu mi lempanga maraanu du umsu xeneng at loogu laplavang teren. ");
INSERT INTO mmx_vpl VALUES ("PS96_7","020_96_7","PSA","96","7","7","Nemi limixin axap at lavatbung menemen, mina emi asu mi Leeme Silok. Mina emi asu mi lisisinang la lolos teren. ");
INSERT INTO mmx_vpl VALUES ("PS96_8","020_96_8","PSA","96","8","8","Leemi asu ri laasen melemelengan at Leeme Silok. Mina emu eburu mi leventamtaba atnimi la mina beles de at loogu laplavang teren. ");
INSERT INTO mmx_vpl VALUES ("PS96_9","020_96_9","PSA","96","9","9","At loxonaleng mo Laradi Melemelengan na vor asuvos, mina xis tintiding to melamgo ren. Lavatbung menemen axap, mina lok ngangao aleng mi lanmarat to melamgo ren. ");
INSERT INTO mmx_vpl VALUES ("PS96_10","020_96_10","PSA","96","10","10","Mina paase i ri larabung mixin axap do, “Leeme Silok, neni Loorong Silok!” Ni lavasuun teren la lavatbung menemen it kis tuxuruxun to at loxot teren la teta noxo vuk gili i. Neni naba ila mumu limixin mi lodoxoma mokmokso. ");
INSERT INTO mmx_vpl VALUES ("PS96_11","020_96_11","PSA","96","11","11","Limixin at lavatkangka eburu mi laxalibet, minak lek! Laras, una luulung mi lomomo! Lempanga dik lok keneng taram, dinap kup momo. ");
INSERT INTO mmx_vpl VALUES ("PS96_12","020_96_12","PSA","96","12","12","Levennep kangka eburu mi levempanga dik lok keneng atnimi, minak lek! La larauna ro xeneng at laxairing, dinabap kup mi leklek, ");
INSERT INTO mmx_vpl VALUES ("PS96_13","020_96_13","PSA","96","13","13","at loxonaleng Leeme Silok na vot kusu tim gomgonga lavatbung menemen. Neni nabam gomgonga limixin at lavatbung menemen mi lodoxoma mokmokso la levelinga ruturun. ");
INSERT INTO mmx_vpl VALUES ("PS97_1","020_97_1","PSA","97","1","1","Leeme Silok neni Loorong Silok! Lavatkangka, unak lek! Nemi levesoxan kantubu at laras, mina sosoro! ");
INSERT INTO mmx_vpl VALUES ("PS97_2","020_97_2","PSA","97","2","2","Lengkon takabu mi lubuxumin dung kan i. Neni im gomgonga limixin mi levelinga manmanton la lodoxoma avukat. ");
INSERT INTO mmx_vpl VALUES ("PS97_3","020_97_3","PSA","97","3","3","Laxao im gomgonga i la i kotos kepe limixin munepen min mo dik lok kangkan i. ");
INSERT INTO mmx_vpl VALUES ("PS97_4","020_97_4","PSA","97","4","4","Neni ik lox asu lavanga i mam la i soosoo axasep lavatbung menemen. La lavatkangka i reven i la ira dede. ");
INSERT INTO mmx_vpl VALUES ("PS97_5","020_97_5","PSA","97","5","5","Lengkong kaana di xadan ngan levelumlut misiu ro melamgo at Leeme Silok, go melamgo at Leeme Silok at lavatbung menemen axap. ");
INSERT INTO mmx_vpl VALUES ("PS97_6","020_97_6","PSA","97","6","6","La laxalibet i lox asuusu i do Leeme Silok ni laradi manmanton la larabung mixin axap di reven lisisinang teren. ");
INSERT INTO mmx_vpl VALUES ("PS97_7","020_97_7","PSA","97","7","7","Ik lox amangan nedi axap no di lotu saparap laxampoovo vanga. Laxanmoroa xaxarang axap dit kis tintiding to melamgo at Leeme Silok. ");
INSERT INTO mmx_vpl VALUES ("PS97_8","020_97_8","PSA","97","8","8","O Leeme Silok, limixin me Saion dik lek, la laramenemen silok at leme Juda di sosoro atla u tong asu lavapaase ramtaba ina ram mi lodoxoma mokmokso. ");
INSERT INTO mmx_vpl VALUES ("PS97_9","020_97_9","PSA","97","9","9","Leeme Silok Lanaraavuk, nenu lamgomgo at lavatbung menemen axap. Nenu u silok tinotno rinedi axap levenmoroa xaxarang. ");
INSERT INTO mmx_vpl VALUES ("PS97_10","020_97_10","PSA","97","10","10","Leeme Silok i balamu nedi di belengatngas ti laxapmek. Neni ik lok tatao lorooro at limixin teren. Neni ik lox asepmus di basinge lolos at limixin dik lok lengkakapmek. ");
INSERT INTO mmx_vpl VALUES ("PS97_11","020_97_11","PSA","97","11","11","Leveloklox anarong i ngan laxasep i soosoo mavana atnedi limixin manmanton. La leklek ik lok atnedi luvuttadi avukat. ");
INSERT INTO mmx_vpl VALUES ("PS97_12","020_97_12","PSA","97","12","12","Nemi limixin manmanton minak lek ap mo lempanga Leeme Silok gara lok pam i! Mina doxoma aklen ti mo lempanga ne Moroa Melemelengan gara lok pam i rinimi, la mina tong avukat tin. ");
INSERT INTO mmx_vpl VALUES ("PS98_1","020_98_1","PSA","98","1","1","Mina vixan toxompixan maxat ti Leeme Silok. Neni gara lok pam lempanga maraanu! Neni gara sak tup mi limixin munepen mi lolos kaala axa ren. ");
INSERT INTO mmx_vpl VALUES ("PS98_2","020_98_2","PSA","98","2","2","Leeme Silok ga vaase asu i do ni ga sak tup mi limixin munepen min. La neni ga vaase aronga larabung mixin axap mi mo lolos teren ti lox asepmus limixin. ");
INSERT INTO mmx_vpl VALUES ("PS98_3","020_98_3","PSA","98","3","3","Neni ga lox epovo laxakaape ren ti limixin me Israel la i ruturun amisik tidi la ik lox asuusu labalamu lexen tidi. Limixin at lengkot axap digara ven pam ne Moroa atnedi ga sak tup mi limixin munepen min. ");
INSERT INTO mmx_vpl VALUES ("PS98_4","020_98_4","PSA","98","4","4","Nemi axap limixin at na lavatbung menemen, minak pixan sosoro ri Leeme Silok. Mina emi asu rin mi lempixan la luxupkup sosoro! ");
INSERT INTO mmx_vpl VALUES ("PS98_5","020_98_5","PSA","98","5","5","Minak pixan mi lengkompixan emi asu ri Leeme Silok! Minak sak lerengteng maraanu ro at lempat taaleng! ");
INSERT INTO mmx_vpl VALUES ("PS98_6","020_98_6","PSA","98","6","6","Minat mas lempat tu mi lengkongkidi, la minap kup mi lososoro ri Leeme Silok, ni Loorong Silok atdik. ");
INSERT INTO mmx_vpl VALUES ("PS98_7","020_98_7","PSA","98","7","7","Laras eburu mi lempanga dik lok keneng taram, mina vaas mi luxupkup. Lavatbung menemen mi lempanga axap dik lok mavana ram, minak pixan! ");
INSERT INTO mmx_vpl VALUES ("PS98_8","020_98_8","PSA","98","8","8","Laradan sen, mina pasa leventingen nimi. Lengkong kaana, minak pixan eburu mi lososoro at lemeren Leeme Silok, ");
INSERT INTO mmx_vpl VALUES ("PS98_9","020_98_9","PSA","98","9","9","atla i vot kusu nam gomgonga lavatbung menemen. Neni nabam gomgonga limixin at lavatbung menemen mi lodoxoma mokmokso la levelinga ruturun. ");
INSERT INTO mmx_vpl VALUES ("PS99_1","020_99_1","PSA","99","1","1","Leeme Silok, neni Loorong Silok. Larabung mixin dina dede mi lanmarat. Neni it kis at loxonin orong teren mavana at lempanga raptava (cherubim) la lavatbung menemen ing nengne. ");
INSERT INTO mmx_vpl VALUES ("PS99_2","020_99_2","PSA","99","2","2","Leeme Silok neni Lanaraavuk to xeneng Saion, neni ik lok mavana xasep tinotno ri larabung mixin axap. ");
INSERT INTO mmx_vpl VALUES ("PS99_3","020_99_3","PSA","99","3","3","Limixin axap dinaba emi asu mi mo laasen silok doxodok teren la dinaba tong i do, neni i melemelengan! ");
INSERT INTO mmx_vpl VALUES ("PS99_4","020_99_4","PSA","99","4","4","Loorong Silok nenu Lanaraavuk, u vavara aleng leveloklok in manton. Ugara vaxaru vam leventaangas manmanton kusu limixin diba mumu asu i ro xeneng Israel. Ugara xip pot pam mi loklok manmanton la levelinga ruturun. ");
INSERT INTO mmx_vpl VALUES ("PS99_5","020_99_5","PSA","99","5","5","Leemi asu ri Leeme Silok ne Moroa atnedik. Mina lotu saparav i ro melamgo at loxonin orong teren! Neni i melemelengan! ");
INSERT INTO mmx_vpl VALUES ("PS99_6","020_99_6","PSA","99","6","6","Moses mi ne Aron duga gugu ngan lumaasa ren, la ne Samuel neni ga ngising tin. Diga ngising ti Leeme Silok la neni ga lox epovo levesingising atnedi. ");
INSERT INTO mmx_vpl VALUES ("PS99_7","020_99_7","PSA","99","7","7","Neni ga paase ridi boro xeneng at lovotakabu ga baalom upana. Digang tonga res at leventaangas la levelinga neni gam taba nedi min. ");
INSERT INTO mmx_vpl VALUES ("PS99_8","020_99_8","PSA","99","8","8","O Leeme Silok, nenu ne Moroa atnema, uga lox epovo lodoxoma at limixin taram. Uga lox asuusu i ridi do nenu ne Moroa umdoma xepe lengkakapmek, la uga lox asongot nedi mumu levengkakapmek atdi. Ketla melemu uga doxoma xepe laxakapmek atnedi. ");
INSERT INTO mmx_vpl VALUES ("PS99_9","020_99_9","PSA","99","9","9","Leemi asu ri Leeme Silok ne Moroa atnedik, la ata ngising tin to at loxongkaana xaala Saion! Leeme Silok ne Moroa atnedik i melemelengan. ");
INSERT INTO mmx_vpl VALUES ("PS100_1","020_100_1","PSA","100","1","1","Nemi limixin at lavatbung menemen axap, minak pixan ti Leeme Silok! ");
INSERT INTO mmx_vpl VALUES ("PS100_2","020_100_2","PSA","100","2","2","Mina lotu saparap Leeme Silok mi lososoro. Minat pot parav i mi lempixan loklok momo! ");
INSERT INTO mmx_vpl VALUES ("PS100_3","020_100_3","PSA","100","3","3","La mina ven kibis i do Leeme Silok neni ne Moroa. Neni ga rudum dik, la nedik ateren akmokso. Nedik limixin teren, nedik laxasipsip teren. ");
INSERT INTO mmx_vpl VALUES ("PS100_4","020_100_4","PSA","100","4","4","Minak beles at langas povolo ukeneng at loogu laplavang mi leventamtaba ri tong avukat tin. Minak beles eburu mi leemi asu rin uto xeneng at lenep tongtonga linga ren. Mina tong avukat tin la mina vemi asu min. ");
INSERT INTO mmx_vpl VALUES ("PS100_5","020_100_5","PSA","100","5","5","Leeme Silok, neni i lox avukat. Labalamu ren ik lox amisik la luruturun teren ti limixin naba nemen amisik la noxo xap. ");
INSERT INTO mmx_vpl VALUES ("PS101_1","020_101_1","PSA","101","1","1","O Leeme Silok. Loxompixan tarak i paase mumu labalamu ram la um gomgonga limixin at langas in manton. La nia anak pixan emi asu minu. ");
INSERT INTO mmx_vpl VALUES ("PS101_2","020_101_2","PSA","101","2","2","Loklok tarak nabap sepse. Ningisa ba unaba vot pasa ia? Lorooro rak naba dadat to xeneng at loogu rak, ");
INSERT INTO mmx_vpl VALUES ("PS101_3","020_101_3","PSA","101","3","3","la anoxo esuuxun mi laxapmek. Nia ak lox angtungun ti leveloklok atnedi limixin tongtonga xepe. Nia a noxot kis esogo rinotno bok ba eburu minedi. ");
INSERT INTO mmx_vpl VALUES ("PS101_4","020_101_4","PSA","101","4","4","Anoxo babala vukpuk, la anoxo emu mi limixin kapmek. ");
INSERT INTO mmx_vpl VALUES ("PS101_5","020_101_5","PSA","101","5","5","Anaba riki xepe nege di, di vepaase siksikma xapmek mumu lentaba vetpes. A belengatngas ti taradi loklox aaso la im simi aurur i. ");
INSERT INTO mmx_vpl VALUES ("PS101_6","020_101_6","PSA","101","6","6","Anaba siam kaka nedi di ruturun tu la anaba siam abeles nedi xusu dinabak lok eburu minia ro xeneng at loogu rak. La nedi ua dixo babala vukpuk, anaba siam ka di xusu dina gugu ria. ");
INSERT INTO mmx_vpl VALUES ("PS101_7","020_101_7","PSA","101","7","7","Naba xopmen tetadi xaxarang naba nemen eburu minia ro xeneng at loogu rak. La xopmen tinotno tetadi sosolom naba nemen saparav ia. ");
INSERT INTO mmx_vpl VALUES ("PS101_8","020_101_8","PSA","101","8","8","At levenaleng amisik anaba sesele utut limixin ua dik lok leveloklok kapmek keneng at lenep kangka atnema. Anaba saksu minedi lorooro atdi i bilinga rino uto xamang basinge lemenemen silok taram. ");
INSERT INTO mmx_vpl VALUES ("PS102_1","020_102_1","PSA","102","1","1","O Leeme Silok, una ronga lerengteng tarak la una lox epovo lisingising tarak ti loklok tooro ram tia. ");
INSERT INTO mmx_vpl VALUES ("PS102_2","020_102_2","PSA","102","2","2","Uguta raba rulu ia at loxonaleng ak lok at lumumuat. At loxonaleng ana ro ke ram, una ronga res tarak la una lox epovo soso levesingising tarak! ");
INSERT INTO mmx_vpl VALUES ("PS102_3","020_102_3","PSA","102","3","3","Lorooro rak na i sonao ngan lusuxa. La lanmet tarak i anan labantuxu rak ngan laxao. ");
INSERT INTO mmx_vpl VALUES ("PS102_4","020_102_4","PSA","102","4","4","Limixin munepen minia dip sev asi ia ngan levempivilis mang, la lavavara anan tarak ira xap pam. ");
INSERT INTO mmx_vpl VALUES ("PS102_5","020_102_5","PSA","102","5","5","Nia at mes silok tinotno. Labaaxin tarak ira gelegen axap la labantuxu rak na ira vaa nga at laxasi. ");
INSERT INTO mmx_vpl VALUES ("PS102_6","020_102_6","PSA","102","6","6","A lok ngan lavatpixa aaxa no xeneng at lamatbin, a lok ngan bok lavatdudu i nemen kusuk to at lemenemen ira bin pam. ");
INSERT INTO mmx_vpl VALUES ("PS102_7","020_102_7","PSA","102","7","7","Axo vunga at lengkanimin. Ak lok ngan tinotno lapka ik lok tutulu kap to vana at loogu. ");
INSERT INTO mmx_vpl VALUES ("PS102_8","020_102_8","PSA","102","8","8","At laxanaleng axap limixin munepen minia di paase vupu ria. La nedi ua di paase aksaksa ria, di tong laasen tarak at loxonaleng di paase asi lentaba vetpes. ");
INSERT INTO mmx_vpl VALUES ("PS102_9","020_102_9","PSA","102","9","10","La mumu i mo lebelemamao silok taram, laxakup i lok ngan ta leveluxa rak, la a inin elong levendan inin mi levengkabili dan at luxatli rak. Uga rebeng kaka ia la uga lu xepe minia. ");
INSERT INTO mmx_vpl VALUES ("PS102_11","020_102_11","PSA","102","11","11","Lorooro rak i lok ngan ta lamamau ukantinao noxo nemen abao. A lok ngan tinotno levempivilis mang. ");
INSERT INTO mmx_vpl VALUES ("PS102_12","020_102_12","PSA","102","12","12","Ketla nenu Leeme Silok, unaba nemen amisik ngan Loorong Avolo. Lavaola axap dinabam domasu ram. ");
INSERT INTO mmx_vpl VALUES ("PS102_13","020_102_13","PSA","102","13","13","Unaba ravasu la una lox aru amu lemenemen Saion. Loxonaleng ira vot pam kusu tu ri lox asuusu lebelen tuntun tin, loxonaleng mokmokso nga na ren. ");
INSERT INTO mmx_vpl VALUES ("PS102_14","020_102_14","PSA","102","14","14","Lavasaxaruki ram di vavara aleng i, keke i do limixin petpes diga sele utur i la ira bin ta. La keke i do mo lemenemen ira lok kapmek axap pam, ketla move lebelendi i tu aleng i. ");
INSERT INTO mmx_vpl VALUES ("PS102_15","020_102_15","PSA","102","15","15","Larabung mixin axap dinaba marat taram, Leeme Silok. La lavaorong axap at lavatbung menemen dinaba marat at lolos taram. ");
INSERT INTO mmx_vpl VALUES ("PS102_16","020_102_16","PSA","102","16","16","Nenu Leeme Silok, unaba vaxaru amlong lemenemen Saion, kerepmo nenu unaba lox asaxaven lolos taram. ");
INSERT INTO mmx_vpl VALUES ("PS102_17","020_102_17","PSA","102","17","17","Nenu unaba ronga res atnedi limixin taram di baava, la unaba lox epovo levesingising atnedi. ");
INSERT INTO mmx_vpl VALUES ("PS102_18","020_102_18","PSA","102","18","18","I epovo do tara na malagan li mo lempanga nenu, Leeme Silok, uga lox i xusu mo lavaola melemu diba utus i, la dinaba emi asu minu. ");
INSERT INTO mmx_vpl VALUES ("PS102_19","020_102_19","PSA","102","19","19","Nenu, Leeme Silok, uga reven su boro vana at lenep kaala ram. Uga reven su boro vana at lemenemen taram ude xopok at lavatbung menemen. ");
INSERT INTO mmx_vpl VALUES ("PS102_20","020_102_20","PSA","102","20","20","Uga ronga lanteng atdi digak lok at loogu xokoxo la uga lox asepmus nedi ua limixin petpes diga lok do dina sev amet nedi. ");
INSERT INTO mmx_vpl VALUES ("PS102_21","020_102_21","PSA","102","21","21","Kuren la limixin dinabap kip aurut laasen taram to Saion, la dinaba emi asu minu ro xeneng Jerusalem. ");
INSERT INTO mmx_vpl VALUES ("PS102_22","020_102_22","PSA","102","22","22","Ap mo loxonaleng levenabung mixin axap eburu mi limixin at levengkitkis orong dinaba etu buru la dina lotu saparav u, Leeme Silok. ");
INSERT INTO mmx_vpl VALUES ("PS102_23","020_102_23","PSA","102","23","23","Kovisi nia ana sioxo la ura lox amolos pam ia. Ura lox atmut pam lorooro rak. ");
INSERT INTO mmx_vpl VALUES ("PS102_24","020_102_24","PSA","102","24","24","O Moroa, kovisi nia ana sioxo la uguta lok kepe soso ia. O Leeme Silok, nenu u rooro amisik. ");
INSERT INTO mmx_vpl VALUES ("PS102_25","020_102_25","PSA","102","25","25","Uga rudum li lavatbung menemen ganoxa, la uga lok laxalibet mi lukngam akmokso. ");
INSERT INTO mmx_vpl VALUES ("PS102_26","020_102_26","PSA","102","26","26","Mo lempanga naba sonao, ketla nenu unaba nemen amisik. Dinaba maut ngan lenbantamon. Unaba lu asu midi ngan lenbantamon, la dina sonao. ");
INSERT INTO mmx_vpl VALUES ("PS102_27","020_102_27","PSA","102","27","27","Ketla levelinga ram kopmen nak lox ekun, la lorooro ram noxo xap. ");
INSERT INTO mmx_vpl VALUES ("PS102_28","020_102_28","PSA","102","28","28","Laxamdak mi laxaalik atnema dinaba nemen avukat atla unabak lok see atdi. Levempipisik li atnedi dinaba rooro avukat mun. ");
INSERT INTO mmx_vpl VALUES ("PS103_1","020_103_1","PSA","103","1","1","Labalak, una emi asu mi Leeme Silok! Lorooro axap tarak, una emi asu mi laasen kaala ren! ");
INSERT INTO mmx_vpl VALUES ("PS103_2","020_103_2","PSA","103","2","2","Labalak, una emi asu mi Leeme Silok, la uguta domampe na leveloklox anarong ik lox asuusu i. ");
INSERT INTO mmx_vpl VALUES ("PS103_3","020_103_3","PSA","103","3","3","Neni i doxoma xepe lengkakapmek axap tarak la ni i lok kepe levenanmeres axap tarak. ");
INSERT INTO mmx_vpl VALUES ("PS103_4","020_103_4","PSA","103","4","4","Ik lox asepsu ia basinge lamaaut la ik lox anarong ia mi labalamu la lebelen tuntun. ");
INSERT INTO mmx_vpl VALUES ("PS103_5","020_103_5","PSA","103","5","5","Ik suxa lorooro rak mi lempanga avukat, kusu anaba nemen ngan laau la ana lolos ngan lamaalom. ");
INSERT INTO mmx_vpl VALUES ("PS103_6","020_103_6","PSA","103","6","6","Leeme Silok i tu at lenep at limixin baava la ik lox asepmus nedi ua limixin di lox asi di. ");
INSERT INTO mmx_vpl VALUES ("PS103_7","020_103_7","PSA","103","7","7","Neni ga lox asuusu leven doxoma ali ren ti ne Moses la ni ga lok leme Israel kusu dina ven leven gugu lolos teren. ");
INSERT INTO mmx_vpl VALUES ("PS103_8","020_103_8","PSA","103","8","8","Leeme Silok neni laradi at lebelen tuntun la labalamu, la ixok belemamao soso ketla i umsu mi labalamu lexen. ");
INSERT INTO mmx_vpl VALUES ("PS103_9","020_103_9","PSA","103","9","9","Ni noxo paase lolos amisik, la lebelemamao ren noxo nemen amisik. ");
INSERT INTO mmx_vpl VALUES ("PS103_10","020_103_10","PSA","103","10","10","I epovo xusu atap kip ka leveloklox asongot teren, ketla neni xopmen nak lox asongot nedik na epovo mi levengkakapmek atnedik. La ixo porang leveng kakapmek la leveloklok bilinga atdik. ");
INSERT INTO mmx_vpl VALUES ("PS103_11","020_103_11","PSA","103","11","11","La labalamu ren i urut aleng upana at lamavangkap mavana at lavatbung menemen la kerepmo labalamu ren i silok aleng tinedi ua dit kis esogo min. ");
INSERT INTO mmx_vpl VALUES ("PS103_12","020_103_12","PSA","103","12","12","La ik lok kepe leveloklok bilinga atdik uto vaxalom tino, i ngan utonak at lemeren laxangking la utois kopok tino. ");
INSERT INTO mmx_vpl VALUES ("PS103_13","020_103_13","PSA","103","13","13","I ngan ne temen laxamdak mi laxaalik i lox asuusu lebelen tuntun tidi. I lok ngan bok Leeme Silok i lox asuusu lebelen tuntun tinedi ua dit kis esogo min. ");
INSERT INTO mmx_vpl VALUES ("PS103_14","020_103_14","PSA","103","14","14","Neni iklen i do ga rudum dik mi lavanga salai. Iklen i do nedik laxakup mene nga. ");
INSERT INTO mmx_vpl VALUES ("PS103_15","020_103_15","PSA","103","15","15","Kuren la nedik, lorooro atnedik i lok ngan mun lempivilis. Nedik ta suusu la ta tepoposok ngan levempusuvus aaxa. ");
INSERT INTO mmx_vpl VALUES ("PS103_16","020_103_16","PSA","103","16","16","La lamanman it mas i la ira vaxap manga, la ata noxo ven ka bok ba i. ");
INSERT INTO mmx_vpl VALUES ("PS103_17","020_103_17","PSA","103","17","17","Ketla nedi di mumu asu Leeme Silok, labalamu ren ik lox amisik mavana atnedi. La luvukat teren ik lox amisik tinedi lavaola axap, ");
INSERT INTO mmx_vpl VALUES ("PS103_18","020_103_18","PSA","103","18","18","la tinedi bok di ruturun ti lekabus teren la ding tonga res tuturun amisik at levempapaase ali ren. ");
INSERT INTO mmx_vpl VALUES ("PS103_19","020_103_19","PSA","103","19","19","Leeme Silok ga vuxaxis li loxot kitkis teren to vana at laxalibet. La neni i ngan Loorong Silok mavana at lempanga axap. ");
INSERT INTO mmx_vpl VALUES ("PS103_20","020_103_20","PSA","103","20","20","Nemi lubung angelo lolos, mina emi asu mi Leeme Silok. La nemi bok ua ming tonga res at levempapaase ali ren, la ming tonga lempanga neni i tong i. ");
INSERT INTO mmx_vpl VALUES ("PS103_21","020_103_21","PSA","103","21","21","Nemi limixin lolos axap to vana at laxalibet, mina emi asu mi Leeme Silok. La nemi bok lavasaxaruki ren no mik lok leven gugu mu asu lavavara ren. ");
INSERT INTO mmx_vpl VALUES ("PS103_22","020_103_22","PSA","103","22","22","Nemi lempanga vipis axap teren at lengkot axap neni ik lok gomgo ren, mina emi asu mi Leeme Silok. Labalak, una emi asu mi Leeme Silok! ");
INSERT INTO mmx_vpl VALUES ("PS104_1","020_104_1","PSA","104","1","1","Labalak, una emi asu mi Leeme Silok! O Leeme Silok, Moroa rak, u nunuan aleng pologat! Ung sigaara mi lisixam la lisisinang. ");
INSERT INTO mmx_vpl VALUES ("PS104_2","020_104_2","PSA","104","2","2","U bom u mi laxasep. Uga rep asala laxalibet ngan ta loogu kadis ");
INSERT INTO mmx_vpl VALUES ("PS104_3","020_104_3","PSA","104","3","3","la uga vaxaru loogu silok tu ro mavana at ladan ik lok tovana. La ut kis to mavana at lengkon takabu ngan lagengen taram la lamanman it mas aonon u. ");
INSERT INTO mmx_vpl VALUES ("PS104_4","020_104_4","PSA","104","4","4","Uk lok luvuttadi loklok ka linga ram di lok ngan laramera manman la lavasaxaruki ram di lok ngan laxao at lavanga i mam. ");
INSERT INTO mmx_vpl VALUES ("PS104_5","020_104_5","PSA","104","5","5","Ugara vaxaxis li atmatkun pam lavatkangka to vana at laamkumkun teren, la ixo epovo do tara na ut asi bok ba i. ");
INSERT INTO mmx_vpl VALUES ("PS104_6","020_104_6","PSA","104","6","6","Uga lok li laras to mavana ren ngan labantamon, la ladan gak mit lempat kaana. ");
INSERT INTO mmx_vpl VALUES ("PS104_7","020_104_7","PSA","104","7","7","At loxonaleng uga vaase sok laradan, diga sixiro. Diga ekakala oo at loxonaleng diga ronga levelinga lolos taram. ");
INSERT INTO mmx_vpl VALUES ("PS104_8","020_104_8","PSA","104","8","8","Digam tem soobang su boro vana at lempat kaana la uto xopok at larasa, ugo ap mo loxot nenu uga lok li i xusu tidi. ");
INSERT INTO mmx_vpl VALUES ("PS104_9","020_104_9","PSA","104","9","9","Uga lok li lapdopdo mo nedi di noxo los polo i, tik lok pe di xusu di noxo sak pavaa bok ba lavatkangka. ");
INSERT INTO mmx_vpl VALUES ("PS104_10","020_104_10","PSA","104","10","10","Uga lok levempuuvut dan i sesen to at larasa, la lempat dan silok i sesen kantubu at levengkaana. ");
INSERT INTO mmx_vpl VALUES ("PS104_11","020_104_11","PSA","104","11","11","Dik lox asuusu levendan ti levempanga sio mi lavanuet kangkedek atdi. Laxan dongki sio dik lox axap lanminu atdi go. ");
INSERT INTO mmx_vpl VALUES ("PS104_12","020_104_12","PSA","104","12","12","La lavapixa dip kip levempotpos atdi, go at larauna at larasigege dan la dirak pixan. ");
INSERT INTO mmx_vpl VALUES ("PS104_13","020_104_13","PSA","104","13","13","La uk lox asu larakabu boro vana at laxalibet uto vana at lengkong kaana, la lavatkangka i unumsu mi leveloklox anarong taram. ");
INSERT INTO mmx_vpl VALUES ("PS104_14","020_104_14","PSA","104","14","14","Uk lox asuusu levempivilis ti laxan bulumaxao la levempanga suusu ri limixin, la kusu dibat lotlo bok leveluxa ridi, ");
INSERT INTO mmx_vpl VALUES ("PS104_15","020_104_15","PSA","104","15","15","la dinak lox asuusu leven vaen tik lox amomo di, la levenmonok dan olip nabak lox aklek di, la leng kongkide nabam taba di mi lolos. ");
INSERT INTO mmx_vpl VALUES ("PS104_16","020_104_16","PSA","104","16","16","Laxanbet it pot solo at lempar una Seda (Cedar) ro Lebanon, mo laxanuna at Leeme Silok axa gatlo li di. ");
INSERT INTO mmx_vpl VALUES ("PS104_17","020_104_17","PSA","104","17","17","La lavapixa dik lok laraogu atnedi go. La lempatboxon dip kip levempotpos atdi ro at larauna kaao (fir tree). ");
INSERT INTO mmx_vpl VALUES ("PS104_18","020_104_18","PSA","104","18","18","Laxanme sio dik lok to vana rubu at lempatkaana, la lempat pusi sio di lipe ro xeneng at lempat buang. ");
INSERT INTO mmx_vpl VALUES ("PS104_19","020_104_19","PSA","104","19","19","Uga rudum li lagaaling kusu tik lok katling leven gaaling. La laxangking ikleklen loxonaleng teren ti lotup. ");
INSERT INTO mmx_vpl VALUES ("PS104_20","020_104_20","PSA","104","20","20","Uga lok laxanimin, la keneng ap mo lamain, laxampanga sio axap dip tavasu. ");
INSERT INTO mmx_vpl VALUES ("PS104_21","020_104_21","PSA","104","21","21","Levelaion maxat di booro lolos at loxonaleng di puse luxa. Di puse ri mo levempanga anan no ne Moroa im taba i. ");
INSERT INTO mmx_vpl VALUES ("PS104_22","020_104_22","PSA","104","22","22","La do laxangking na rip su, dimlomlong la dirak midi ro at lempatmamara atdi. ");
INSERT INTO mmx_vpl VALUES ("PS104_23","020_104_23","PSA","104","23","23","Melemu limixin dip tavasu xusu tik lok leven gugu atdi la dira gugu abung tino. ");
INSERT INTO mmx_vpl VALUES ("PS104_24","020_104_24","PSA","104","24","24","O Leeme Silok. Ugara rudum li vam laxampanga solo. Mi lakleklen silok taram uga lok di. Lavatbung menemen i umsu mi laxampanga vipis axap taram. ");
INSERT INTO mmx_vpl VALUES ("PS104_25","020_104_25","PSA","104","25","25","Pen ba mo laras, i silok tinotno la ip teplas, la i umsu mi mo lara met panga vipis silok la lixilik ua ata xo epovo ri exes i, di nemen teren. ");
INSERT INTO mmx_vpl VALUES ("PS104_26","020_104_26","PSA","104","26","26","La lempatmon di sesen to vana ren, la mo lavatpanga sio boro at laras, ne Levietan no nenu uga lox i, i gosogos go xeneng ap mo laras. ");
INSERT INTO mmx_vpl VALUES ("PS104_27","020_104_27","PSA","104","27","27","Nedi axap na di nunu li ram kusu unabam taba luxa di mo do dinak toxo. ");
INSERT INTO mmx_vpl VALUES ("PS104_28","020_104_28","PSA","104","28","28","Nu um taba luxa di la di vanan i. Nenu um taba leveluxa xusu tik lox axap lavavara atdi. ");
INSERT INTO mmx_vpl VALUES ("PS104_29","020_104_29","PSA","104","29","29","Mo do u raba rulu di, dik marat. Mo do una lok pes lamamas taram atdi, di remet la diramlomlong ti laxakup no nedi diga ravasu ren. ");
INSERT INTO mmx_vpl VALUES ("PS104_30","020_104_30","PSA","104","30","30","At loxonaleng u rudum di, u raba di mi lamamas taram, la di ruuna ka lorooro. La lempanga axap di ravasu at na lavatbung menemen, um taba di mi lorooro maxat. ");
INSERT INTO mmx_vpl VALUES ("PS104_31","020_104_31","PSA","104","31","31","Naba lox avukat do lisisixam at Leeme Silok naba nemen amisik la kopmen tekavaxap teren! Naba lox avukat do Leeme Silok na momo mi lempanga neni ga rudum pam i! ");
INSERT INTO mmx_vpl VALUES ("PS104_32","020_104_32","PSA","104","32","32","Neni i reven tooro lavatbung menemen la lavatbung menemen ing nengne. Neni inglong tu at lempat kaana, la dirap kip soobang asu lusuxa. ");
INSERT INTO mmx_vpl VALUES ("PS104_33","020_104_33","PSA","104","33","33","Anabak pixan ti Leeme Silok keneng at lorooro axap tarak. At levenaleng nia ana rooro ren, anabak pixan emi asu ri ne Moroa rak. ");
INSERT INTO mmx_vpl VALUES ("PS104_34","020_104_34","PSA","104","34","34","A vara i do ni naba momo at lengkom pixan tarak, atla leklek tarak i laala boro ren. ");
INSERT INTO mmx_vpl VALUES ("PS104_35","020_104_35","PSA","104","35","35","A vara i xusu limixin kapmek dina sonao basinge na lavatbung menemen, la noxopmen bok ba timixin kapmek. Labalak, una emi asu mi Leeme Silok! Leemi asu ri Leeme Silok! ");
INSERT INTO mmx_vpl VALUES ("PS105_1","020_105_1","PSA","105","1","1","Nedik ata tong avukat ti Leeme Silok, ata tong asu laasen silok teren. Ata tong axasev i ri levenabung mixin buaang, mumu lempanga sangsangu neni ira lok pam i. ");
INSERT INTO mmx_vpl VALUES ("PS105_2","020_105_2","PSA","105","2","2","Atak pixan emi asu ri Leeme Silok. Ata tong asu lempanga nunuan neni ira lok pam i. ");
INSERT INTO mmx_vpl VALUES ("PS105_3","020_105_3","PSA","105","3","3","Ata momo mila nedik ateren. La nedi di lotu parav i mi lebelendi axap dina sosoro. ");
INSERT INTO mmx_vpl VALUES ("PS105_4","020_105_4","PSA","105","4","4","Atat pas parap Leeme Silok atdik kusu ti lok ka leveloklok tooro, la ata lotu parap amisix i. ");
INSERT INTO mmx_vpl VALUES ("PS105_5","020_105_5","PSA","105","5","6","Nemi livipisik li at ne Abaram, laradi gugu at ne Moroa, la nemi livipisik li at ne Jakop, mo laradi ne Moroa ga soxolik ka i. Minam doma aklen ti lempanga sangsangu ne Moroa ga lox i, la mo levenmumuat neni ga raba limixin munepen min. ");
INSERT INTO mmx_vpl VALUES ("PS105_7","020_105_7","PSA","105","7","7","Leeme Silok neni ne Moroa atdik. La mo levempapaase ali ren ti limixin axap at na lavatbung menemen. ");
INSERT INTO mmx_vpl VALUES ("PS105_8","020_105_8","PSA","105","8","8","At levenaleng axap i tu melamgo neni naba tu at lekabus teren, la naba lox epovo mo leveng kakaape ren tinedi larabin sangaun kobot laraola, mo naba vot melemu. ");
INSERT INTO mmx_vpl VALUES ("PS105_9","020_105_9","PSA","105","9","9","Neni naba doma amisik livirivit li ni ga lox i mi ne Abaram la mo laxakaape ren ti ne Isak. ");
INSERT INTO mmx_vpl VALUES ("PS105_10","020_105_10","PSA","105","10","10","Leeme Silok ga lok lekabus mi ne Jakop, mo lekabus ua naba nemen amisik la noxo xap. ");
INSERT INTO mmx_vpl VALUES ("PS105_11","020_105_11","PSA","105","11","11","Ni ga lok ti ne Jakop keretna, “Nia anaba raba u mi na lenep silok Kanan, la na lenep kangka naba nemen ngan ataram axa.” ");
INSERT INTO mmx_vpl VALUES ("PS105_12","020_105_12","PSA","105","12","12","Limixin at ne Moroa di goxo buaang, la diga nemen kadiong ngan lavaose to at lenep silok Kanan. ");
INSERT INTO mmx_vpl VALUES ("PS105_13","020_105_13","PSA","105","13","13","Diga vovo saasaa onon mun at levennep silok uto at levennep silok petpes, la at lara kitkis orong silok uto at lara kitkis orong silok petpes. ");
INSERT INTO mmx_vpl VALUES ("PS105_14","020_105_14","PSA","105","14","14","Ketla ne Moroa goxo ke xepe ba tara gita lox abaava nedi. Neni ga lok see atnedi, la ga sak pinak lavaorong silok mi levelinga i lok keretna, ");
INSERT INTO mmx_vpl VALUES ("PS105_15","020_105_15","PSA","105","15","15","“Nemen gat mita lox asongot limixin soksoxolik tarak. La nemen gat bok mita lox asongot lavaeme vapaase ali rak.” ");
INSERT INTO mmx_vpl VALUES ("PS105_16","020_105_16","PSA","105","16","16","Leeme Silok ga riki asi lean kangking ti mo lenep kangka at limixin teren, la leveluxa atdi gara xap pam. ");
INSERT INTO mmx_vpl VALUES ("PS105_17","020_105_17","PSA","105","17","17","Ketla neni ga riki amgo lara laradi uto Isip, laasen teren ne Josep, mo diga sesep min kusu naba ravasu ngan lasaxaruki go. ");
INSERT INTO mmx_vpl VALUES ("PS105_18","020_105_18","PSA","105","18","18","Diga xoxo alis luxangkedek teren mi lemparoos sen, la diga vaxa onga i mi loxon aen. ");
INSERT INTO mmx_vpl VALUES ("PS105_19","020_105_19","PSA","105","19","19","Josep ga nemen ngan laradi xokoxo, ga se ap mo laaleng lavapaase ali ren ga soorun. Levelinga at Leeme Silok ti ne Josep ga lox asuusu i do neni goxo raba rulu i. ");
INSERT INTO mmx_vpl VALUES ("PS105_20","020_105_20","PSA","105","20","20","Loorong me Isip ga soxomus asu i, ni lamgomgo at levenabung mixin buaang la ga lox asepmus i. ");
INSERT INTO mmx_vpl VALUES ("PS105_21","020_105_21","PSA","105","21","21","Neni ga lok li ne Josep kusu nam gomgonga lagavaman teren. La ga lok li box i ri lok tatao mavana ap mo lenep silok Isip. ");
INSERT INTO mmx_vpl VALUES ("PS105_22","020_105_22","PSA","105","22","22","Ni ga ruuna lolos mavana atdi lentaba luvuttadi amgomgo at loorong la gak lok ka bok levelinga ren kusu ti anasa luvuttadi vapaase at loorong. ");
INSERT INTO mmx_vpl VALUES ("PS105_23","020_105_23","PSA","105","23","23","Melemu ne Jakop eburu mi limixin teren diga beles ukeneng Isip, la digara nemen ta go ap mo lenep silok. ");
INSERT INTO mmx_vpl VALUES ("PS105_24","020_105_24","PSA","105","24","24","La Leeme Silok ga lox avosok aleng nedi go, la ga lok nedi diga lolos aleng tinotno ri limixin munepen midi. ");
INSERT INTO mmx_vpl VALUES ("PS105_25","020_105_25","PSA","105","25","25","Neni ga lok limixin me Isip diga bele mumuat ti limixin teren, nedi lavasaxaruki ren. La leme Isip diga xarang arup amisik di. ");
INSERT INTO mmx_vpl VALUES ("PS105_26","020_105_26","PSA","105","26","26","Melemu Leeme Silok ga riki ne Moses, lasaxaruki ren uto ri limixin teren, la ga riki bok ne Aron, mo neni ga soxolik ka i. ");
INSERT INTO mmx_vpl VALUES ("PS105_27","020_105_27","PSA","105","27","27","Duga lok leveloklok katling at ne Moroa kantubu atdi, la lempanga sangsangu bok teren keneng at lenep silok Isip. ");
INSERT INTO mmx_vpl VALUES ("PS105_28","020_105_28","PSA","105","28","28","Neni ga riki lamain bonot la ga lox amain axap mo lenep kangka. Ketla leme Isip move diga ronga xepe levelinga ren. ");
INSERT INTO mmx_vpl VALUES ("PS105_29","020_105_29","PSA","105","29","29","Neni ga vuk gili laradan atdi ri lada, la laxanmat axap digara met. ");
INSERT INTO mmx_vpl VALUES ("PS105_30","020_105_30","PSA","105","30","30","La lenep kangka atdi ga umsu mi laxangkoak, mo digat los beles bok uto xeneng at lengkot mikmidi at lubung amgomgo. ");
INSERT INTO mmx_vpl VALUES ("PS105_31","020_105_31","PSA","105","31","31","La ne Moroa ga tong i, la laxanulang mi laxan ngirobo diga umsu aleng ap mo lenep silok axap. ");
INSERT INTO mmx_vpl VALUES ("PS105_32","020_105_32","PSA","105","32","32","La ni ga lok pe larakabu ketla ga riki lavatbet uat eburu mi lavanga ga mam, ukeneng ap mo lenep silok atdi. ");
INSERT INTO mmx_vpl VALUES ("PS105_33","020_105_33","PSA","105","33","33","La ni gak paksa asi larauna vaen atdi, eburu mi larauna pik (fig) bok la ga lox asubu bok larauna axap. ");
INSERT INTO mmx_vpl VALUES ("PS105_34","020_105_34","PSA","105","34","34","Neni ga tong mun i la, laxasixu diga vot, ga buaang aleng la di goxo epovo rinotno kusu ti exes di, ");
INSERT INTO mmx_vpl VALUES ("PS105_35","020_105_35","PSA","105","35","35","diga van axap lempanga ga suusu at laxangka. La diga van axap bok lempanga digat lotlo i. ");
INSERT INTO mmx_vpl VALUES ("PS105_36","020_105_36","PSA","105","36","36","Neni ga sev amet axap laxamdak temes avot keneng at lara kitkis koetemen to Isip. ");
INSERT INTO mmx_vpl VALUES ("PS105_37","020_105_37","PSA","105","37","37","Melemu neni ga lam asu limixin me Israel, digap kip ka laxa siliva la gol at leme Isip, la nedi axap diga rooro nunuan la diga lolos. ");
INSERT INTO mmx_vpl VALUES ("PS105_38","020_105_38","PSA","105","38","38","Limixin me Isip diga momo aleng at limixin me Israel diga vas kaxat basinge di, mila diga marat aleng atdi. ");
INSERT INTO mmx_vpl VALUES ("PS105_39","020_105_39","PSA","105","39","39","Moroa ga vung pavaa nedi mi loxontakabu kusu ti lok tatao di, la lababao at laxao ti raba nedi mi laxasep at lengkanimin. ");
INSERT INTO mmx_vpl VALUES ("PS105_40","020_105_40","PSA","105","40","40","Diga sing ne Moroa, la neni ga raba nedi mi levempixa (quail) kusu tidi ri anan, la ga raba avan mais nedi mi lengkide boro vana at laxalibet. ");
INSERT INTO mmx_vpl VALUES ("PS105_41","020_105_41","PSA","105","41","41","Neni ga lox arem suang lara lavaruat, la ladan ga rem soobang su ukamang. Ga ngan lavatdan sen la ga sesen go xeneng at lamatbin. ");
INSERT INTO mmx_vpl VALUES ("PS105_42","020_105_42","PSA","105","42","42","Mila neni gam doma mo laxakaape xaala ren, ga raba i ri ne Abaram, laradi gugu ren. ");
INSERT INTO mmx_vpl VALUES ("PS105_43","020_105_43","PSA","105","43","43","Kerepmo neni ga lam asu limixin soksoxolik teren basinge lenep silok Isip, mi langsangan lososoro, la digak pixan la digap kup momo. ");
INSERT INTO mmx_vpl VALUES ("PS105_44","020_105_44","PSA","105","44","44","Neni ga raba nedi mi lenep kangka at lentaba levenabung mixin petpes, la digara ruuna ka nga leventaamang atdi, ");
INSERT INTO mmx_vpl VALUES ("PS105_45","020_105_45","PSA","105","45","45","kusu limixin teren diba ronga res at levempapaase ali ren, la dina mumu asu Laulis Linga la leventaangas axap teren. Leemi asu ri Leeme Silok. ");
INSERT INTO mmx_vpl VALUES ("PS106_1","020_106_1","PSA","106","1","1","Leemi asu ri Leeme Silok. Ata tong avukat ti Leeme Silok, mila neni mun i lox avukat, la labalamu ren naba nemen amisik. ");
INSERT INTO mmx_vpl VALUES ("PS106_2","020_106_2","PSA","106","2","2","Kopmen tara i epovo na tong axap leven angsangan lempanga silok neni gara lok pam i. Kopmen tara i epovo xusu naba lox epovo lodoxoma ren mi leemi asu rin. ");
INSERT INTO mmx_vpl VALUES ("PS106_3","020_106_3","PSA","106","3","3","Nedi dinang tonga res at levempapaase ali at ne Moroa la dinak lox amisik lempanga ik mokso, Moroa naba lox anarong di. ");
INSERT INTO mmx_vpl VALUES ("PS106_4","020_106_4","PSA","106","4","4","O Leeme Silok. Uguta domampe ia, mo do una lok tooro limixin taram. Una us abeles box ia ukeneng at limixin taram, mo do una lox asepsu di. ");
INSERT INTO mmx_vpl VALUES ("PS106_5","020_106_5","PSA","106","5","5","Una ke ia aba ven limixin taram dinaba ngasang kobot, la ana ruuna bok tomomo eburu minedi la anak lok eburu bok midi xusu ti emi asu minu. ");
INSERT INTO mmx_vpl VALUES ("PS106_6","020_106_6","PSA","106","6","6","Nema marak lok pam laxakapmek kerekngan lavalabat atnama diga lox i. Mara soogong pam la mara bixurun. ");
INSERT INTO mmx_vpl VALUES ("PS106_7","020_106_7","PSA","106","7","7","Lavalabat atnama di goxo xasep nunuan at lempanga sangsangu neni ga lox i ro Isip. Diga domampe mo levenaleng buaang neni ga lox asuusu labalamu ren tidi. La digang tonga viribang tin, Lanaraavuk to at Loxontas Memele. ");
INSERT INTO mmx_vpl VALUES ("PS106_8","020_106_8","PSA","106","8","8","Ketla Leeme Silok ga lox asepsu di go kusu ti lox asilok laasen teren, la ni ga lox asuusu mo langsangan lolos teren. ");
INSERT INTO mmx_vpl VALUES ("PS106_9","020_106_9","PSA","106","9","9","Neni ga tong mun i ri Loxontas Memele, la laras gara mes ta, la neni ga lam avolo limixin teren at laxangka mesemes. ");
INSERT INTO mmx_vpl VALUES ("PS106_10","020_106_10","PSA","106","10","10","Neni ga lok tooro di basinge limixin munepen midi, la ga lox asepsu di basinge limixin esep boro Isip. ");
INSERT INTO mmx_vpl VALUES ("PS106_11","020_106_11","PSA","106","11","11","Laras ga vula pe axap di, la kopmen tinotno tara ga roo su basinge laniu. ");
INSERT INTO mmx_vpl VALUES ("PS106_12","020_106_12","PSA","106","12","12","Kuren la limixin teren diga nunu at leveng kakaape ren, la digak pixan emi asu min. ");
INSERT INTO mmx_vpl VALUES ("PS106_13","020_106_13","PSA","106","13","13","Ketla diga domampe soso mun lempanga silok ne Moroa ga lox i, la di goxo ngangais ba ri tevelinga axasep teren. ");
INSERT INTO mmx_vpl VALUES ("PS106_14","020_106_14","PSA","106","14","14","To at lamatbin diga umsu aleng mi langaongao anan, la diga lok tong pen ne Moroa. ");
INSERT INTO mmx_vpl VALUES ("PS106_15","020_106_15","PSA","106","15","15","Kuren la neni ga raba nedi mi levempanga nedi diga sing tin, ketla neni ga sep bok nedi mi lanmeres kapmek. ");
INSERT INTO mmx_vpl VALUES ("PS106_16","020_106_16","PSA","106","16","16","La to bok at lamatbin diga tere mumu aleng ne Moses, la ne Aron, ni lamaasa kaala at Leeme Silok. ");
INSERT INTO mmx_vpl VALUES ("PS106_17","020_106_17","PSA","106","17","17","Melemu lavatkangka ga rem suang la ga xonom ne Datan, la garak mit bok ne Abiram midi loxoetemen. ");
INSERT INTO mmx_vpl VALUES ("PS106_18","020_106_18","PSA","106","18","18","La laxao ga si boro vana la ukopok tinedi diga mumu asu du, la ga rin asonao axap mo luvuttadi. ");
INSERT INTO mmx_vpl VALUES ("PS106_19","020_106_19","PSA","106","19","19","Melemu leme Israel diga lok lovovo at lubulumaxao maxat to Sinai, la digara lotu parav i ngan mo lomoroa xaxarang. ");
INSERT INTO mmx_vpl VALUES ("PS106_20","020_106_20","PSA","106","20","20","Diga sok sisixe ne Moroa mo i silok aleng la diga xap ti lotu saparav i, la diga lotu parap mo lovovo at lubulumaxao, mo i anan pivilis. ");
INSERT INTO mmx_vpl VALUES ("PS106_21","020_106_21","PSA","106","21","21","Diga domampe rinotno ne Moroa mo ga lox asu di, mi levempanga silok teren to Isip. ");
INSERT INTO mmx_vpl VALUES ("PS106_22","020_106_22","PSA","106","22","22","Diga domampe mo lempanga nunuan, neni ga lox i go, la lempanga sangsangu neni ga lox i ro at Loxontas Memele. ");
INSERT INTO mmx_vpl VALUES ("PS106_23","020_106_23","PSA","106","23","23","Melemu ne Moroa ga lok do naba sele utut kepe limixin teren. Ketla laradi gugu ren ne Moses, mo ni ga soxolik ka i, ga vaase pe ne Moroa xusu noxo lox asuusu lebelemamao ren tidi. ");
INSERT INTO mmx_vpl VALUES ("PS106_24","020_106_24","PSA","106","24","24","Melemu diga sok tixirixes kepe mo lenep kangka avukat, mila di goxo nunu at laxakaape at ne Moroa. ");
INSERT INTO mmx_vpl VALUES ("PS106_25","020_106_25","PSA","106","25","25","Digak lok to xeneng at laraogu kadis atdi la digara gagalinga amisik la di goxo ronga ba levelinga at Leeme Silok. ");
INSERT INTO mmx_vpl VALUES ("PS106_26","020_106_26","PSA","106","26","26","Kuren la neni ga xaape rinedi mi luruturun do ni naba lok nedi dina remet to at lamatbin. ");
INSERT INTO mmx_vpl VALUES ("PS106_27","020_106_27","PSA","106","27","27","La na lok livipisik li atdi, dina epeseves ti levenabung mixin petpes la na ke xepe nedi, dina remet etaba onon to at levennep silok petpes. ");
INSERT INTO mmx_vpl VALUES ("PS106_28","020_106_28","PSA","106","28","28","Melemu nedi limixin at ne Moroa digak lok to Pior, diga lotu saparap lomoroa xaxarang ne Baal la digara anan leventamtaba digap lavang min ti lenmoroa kopmen torooro atdi. ");
INSERT INTO mmx_vpl VALUES ("PS106_29","020_106_29","PSA","106","29","29","Kuren la diga lox axatu lebelemamao at Leeme Silok mi leventuptuvuk kapmek atdi, la langsangan lanmeres kapmek ga vot kantubu atdi. ");
INSERT INTO mmx_vpl VALUES ("PS106_30","020_106_30","PSA","106","30","30","Ketla ne Penias ga ru upana la ga sev amet mo luradi xapmek la mo lanmeres ga xap ta. ");
INSERT INTO mmx_vpl VALUES ("PS106_31","020_106_31","PSA","106","31","31","Na lavanga avukat, ne Penias ga lox i, move limixin at ne Moroa dim doma i. La dinabam doma su bok teren at na levenaleng i tu umelamgo. ");
INSERT INTO mmx_vpl VALUES ("PS106_32","020_106_32","PSA","106","32","32","Melemu diga lox amusak Leeme Silok to Meriba at levempuuvut dan. La ne Moses ga xip tutu mi mo lumumuat mumu laxakapmek atdi. ");
INSERT INTO mmx_vpl VALUES ("PS106_33","020_106_33","PSA","106","33","33","Diga lox abelemamao aleng i, kuren la ni ga paase solo la ga paase tupgat ta. ");
INSERT INTO mmx_vpl VALUES ("PS106_34","020_106_34","PSA","106","34","34","Leme Israel di goxo sev amet lavamolon ap lenep kangka ramtaba kerekngan Leeme Silok ga tong taba di min ti lox i. ");
INSERT INTO mmx_vpl VALUES ("PS106_35","020_106_35","PSA","106","35","35","Ketla diga epot ka di, la diga reven seo ka loklok benben atdi. ");
INSERT INTO mmx_vpl VALUES ("PS106_36","020_106_36","PSA","106","36","36","Limixin at ne Moroa diga lotu parap laxampoovo vanga, kuren la diga oon at levesin mumu mo loklok atdi. ");
INSERT INTO mmx_vpl VALUES ("PS106_37","020_106_37","PSA","106","37","37","Digam taba mi laxamdak mi laxaalik atdi, ngan laplavang atdi ri levenmoroa xaxarang me Kanan. ");
INSERT INTO mmx_vpl VALUES ("PS106_38","020_106_38","PSA","106","38","38","Diga sev amet mo laxamdak mi laxaalik ua kopmen taxakapmek atdi, la mumu mun mo langas diga lox abilinga mo lenep kangka ramtaba. ");
INSERT INTO mmx_vpl VALUES ("PS106_39","020_106_39","PSA","106","39","39","La kerepmo bok diga lox abilinga nedi xa. Digoxo ruturun ti ne Moroa. ");
INSERT INTO mmx_vpl VALUES ("PS106_40","020_106_40","PSA","106","40","40","Kuren la Leeme Silok ga belemamao aleng limixin teren, neni ga bulunga xepe rino di. ");
INSERT INTO mmx_vpl VALUES ("PS106_41","020_106_41","PSA","106","41","41","La neni ga raba rulu kepe di kusu lavamolon, limixin munepen minedi limixin me Israel dinabam gomgonga di. ");
INSERT INTO mmx_vpl VALUES ("PS106_42","020_106_42","PSA","106","42","42","Diga baava aleng mi levenaknixip, mo limixin munepen midi diga raba nedi min. La diga nemen aleng maxopok at lolos at levendoxoma atnedi limixin munepen. ");
INSERT INTO mmx_vpl VALUES ("PS106_43","020_106_43","PSA","106","43","43","Buaang levenaleng Leeme Silok ga rebeng asu ka limixin teren basinge di. Ketla move digang tonga xepe levelinga ren, la digam subu tup tino ukeneng at laxakapmek silok. ");
INSERT INTO mmx_vpl VALUES ("PS106_44","020_106_44","PSA","106","44","44","Ketla Leeme Silok ga ronga nedi, at loxonaleng digang teng tin, la neni ga ronga xibis lumumuat atdi. ");
INSERT INTO mmx_vpl VALUES ("PS106_45","020_106_45","PSA","106","45","45","Mumu mo lumumuat atdi, neni ga doma mo lekabus teren. La mumu langsangan labalamu ren, neni ga lox ekun lodoxoma ren. ");
INSERT INTO mmx_vpl VALUES ("PS106_46","020_106_46","PSA","106","46","46","La neni ga lok limixin munepen midi, diga suma xapmek mumu loklok diga lox i ridi. ");
INSERT INTO mmx_vpl VALUES ("PS106_47","020_106_47","PSA","106","47","47","O Leeme Silok ne Moroa atnama. Lox asepsu nama, la una lam asu nama boro xantubu at na larabung mixin, kusu maba tong avukat tu la mana emi asu mi laasen kaala ram. ");
INSERT INTO mmx_vpl VALUES ("PS106_48","020_106_48","PSA","106","48","48","Leemi asu ri Leeme Silok, Moroa me Israel. Leemi asu rin monga la at levenaleng axap. La limixin axap dina vaase xeretna, “Tuturun!” Leemi asu ri Leeme Silok! ");
INSERT INTO mmx_vpl VALUES ("PS107_1","020_107_1","PSA","107","1","1","Nedik ata tong avukat ti Leeme Silok mila neni axa i lok nunuan. Labalamu ren naba tu lexen! ");
INSERT INTO mmx_vpl VALUES ("PS107_2","020_107_2","PSA","107","2","2","Nemi axap ua neni ga lox asepsu nimi, mina tong amisik na levelinga ti emi asu mi Leeme Silok i lok keretna, “Labalamu ren naba tu lexen!” Neni ga lox asu ka nimi basinge limixin munepen minimi, ");
INSERT INTO mmx_vpl VALUES ("PS107_3","020_107_3","PSA","107","3","3","la gara lam amlong nimi ude boro at levenabung mixin petpes, at lenep meso la mesi la boro bok at lenep mero la mexun. ");
INSERT INTO mmx_vpl VALUES ("PS107_4","020_107_4","PSA","107","4","4","Lentaba diga soronga ro at lamatbin aaxa la di goxo epovo xusu dina vuse ka tangas tidi uto at temenemen silok kusu diba nemen e. ");
INSERT INTO mmx_vpl VALUES ("PS107_5","020_107_5","PSA","107","5","5","Nedi digak toxo la digak minu, la diga doma i do, di mo dina seeve nga. ");
INSERT INTO mmx_vpl VALUES ("PS107_6","020_107_6","PSA","107","6","6","Melemu diga ro ke at Leeme Silok mumu lumumuat atdi, la neni ga lox asu di basinge lixitkis etaba. ");
INSERT INTO mmx_vpl VALUES ("PS107_7","020_107_7","PSA","107","7","7","La neni ga lam nedi at langas manmanton uto at lemenemen silok, la diga nemen e. ");
INSERT INTO mmx_vpl VALUES ("PS107_8","020_107_8","PSA","107","8","8","Kuren la ik mokso do dina tong avukat ti Leeme Silok mumu mo labalamu lexen teren, la ri lempanga nunuan neni gara lok pam i ridi. ");
INSERT INTO mmx_vpl VALUES ("PS107_9","020_107_9","PSA","107","9","9","Atla Leeme Silok im taba dan limixin dik minu, la im taba nedi dik toxo mi lempanga anan avukat. ");
INSERT INTO mmx_vpl VALUES ("PS107_10","020_107_10","PSA","107","10","10","Lentaba vetpes digang songot keneng at lamain bonot ngan luvuttadi xokoxo, mo diga xoxo nedi mi levenoos sen. ");
INSERT INTO mmx_vpl VALUES ("PS107_11","020_107_11","PSA","107","11","11","Digak lok go mila diga ronga viribang at levempapaase ali at ne Moroa, ni Lanaraavuk. La diga sok tixirixes xepe levenanasa ren. ");
INSERT INTO mmx_vpl VALUES ("PS107_12","020_107_12","PSA","107","12","12","Kuren la ni ga lox abaava rinotno di mi laxan gugu solo, la digak sak saaban, la goxopmen tara go ri lok tooro di. ");
INSERT INTO mmx_vpl VALUES ("PS107_13","020_107_13","PSA","107","13","13","La melemu diga ro ke at Leeme Silok at levenaleng at levenmumuat la neni ga lox asepmus di basinge mo labaava. ");
INSERT INTO mmx_vpl VALUES ("PS107_14","020_107_14","PSA","107","14","14","Neni ga lam asu nedi basinge lamain la loxokoxo, la ga ba koxorop pes levenoos sen basinge di. ");
INSERT INTO mmx_vpl VALUES ("PS107_15","020_107_15","PSA","107","15","15","Kuren la ik mokso do dina tong avukat ti Leeme Silok mumu mo labalamu lexen teren, la lempanga nunuan neni gara lok pam i ridi. ");
INSERT INTO mmx_vpl VALUES ("PS107_16","020_107_16","PSA","107","16","16","Neni i tit dadas asi lempatban silok limixin dik lox i mi loborons (bronze), la i tit amdamda lengkompanga soksoxoba matmatkun dik lox i mi la aen. ");
INSERT INTO mmx_vpl VALUES ("PS107_17","020_107_17","PSA","107","17","17","Lentaba vetpes diga lok ngan ta luvuttadi baulang, la diga xip levesongsongot mumu leveloklok kakapmek la leventaangas kapmek atdi. ");
INSERT INTO mmx_vpl VALUES ("PS107_18","020_107_18","PSA","107","18","18","Digak bulunga levempanga anan, la ma lixilik diga lok do dina met. ");
INSERT INTO mmx_vpl VALUES ("PS107_19","020_107_19","PSA","107","19","19","Melemu diga ro ke at Leeme Silok mumu levenmumuat digap kiv i, la neni ga lox asepmus di basinge mo levenaknixip. ");
INSERT INTO mmx_vpl VALUES ("PS107_20","020_107_20","PSA","107","20","20","Neni ga tong asu levelinga ren ti lok pes leven anmeres atdi, la neni ga lox asepsu di basinge lanmet. ");
INSERT INTO mmx_vpl VALUES ("PS107_21","020_107_21","PSA","107","21","21","Ik mokso do nedi dina tong avukat ti Leeme Silok, mumu mo labalamu lexen teren, la mo lempanga nunuan neni gara lox pam i ridi. ");
INSERT INTO mmx_vpl VALUES ("PS107_22","020_107_22","PSA","107","22","22","Ik mokso do dina tong avukat ti Leeme Silok la dina raba i mi leventamtaba eburu mi livikpixan momo, mo naba tong asu mo lempanga neni ga lok pam i. ");
INSERT INTO mmx_vpl VALUES ("PS107_23","020_107_23","PSA","107","23","23","Lentaba vetpes diga sen tangtagap mi lempatmon to at laras aaxa, kusu dina ruuna kaka lempilas ap mo lugugu atdi rovana at lempatmon. ");
INSERT INTO mmx_vpl VALUES ("PS107_24","020_107_24","PSA","107","24","24","Diga ven lempanga sangsangu Leeme Silok ga lox i mi mo lolos teren to at laras. Mo lempanga ga nunuan aleng. ");
INSERT INTO mmx_vpl VALUES ("PS107_25","020_107_25","PSA","107","25","25","Neni ga vaase, la ga lok kaxat mo langsangan lamanman silok, mo ga lox axatu kaxat lempo paxanao. ");
INSERT INTO mmx_vpl VALUES ("PS107_26","020_107_26","PSA","107","26","26","Lempopaxanao ga xip kaxat mo lempatmon upana xasep la ukopok tino. La mumu mo laniu di goxo doma abelemes bok ba do diba roo. ");
INSERT INTO mmx_vpl VALUES ("PS107_27","020_107_27","PSA","107","27","27","Diga saaban onon la digat pas tangtangku ngan diga inin lengkadan lolos. Di goxo epovo na lok tavanga, keke i do lakleklen solo mo atdi. ");
INSERT INTO mmx_vpl VALUES ("PS107_28","020_107_28","PSA","107","28","28","Melemu diga ro ke at Leeme Silok mumu mo levenmumuat atdi, la neni ga lox asu nedi basinge mo laniu. ");
INSERT INTO mmx_vpl VALUES ("PS107_29","020_107_29","PSA","107","29","29","Neni ga lox amila lamanman bet la garak lox atnaasan ta, la lempotas at laras bok digak midi mila. ");
INSERT INTO mmx_vpl VALUES ("PS107_30","020_107_30","PSA","107","30","30","Diga momo aleng at lavanga ga mila, la neni ga mu asu lavavara atdi diga oso avukat to at losoolom. ");
INSERT INTO mmx_vpl VALUES ("PS107_31","020_107_31","PSA","107","31","31","Ik mokso do dina emi asu mi Leeme Silok, mumu labalamu lexen teren la lempanga nunuan neni ga lok pam i ridi. ");
INSERT INTO mmx_vpl VALUES ("PS107_32","020_107_32","PSA","107","32","32","Ik mokso do dina tong asu laasen silok teren keneng at lovotpot buru at limixin, la dina emi asu min kantubu at lovotpot buru at luvuttadi amgomgo. ");
INSERT INTO mmx_vpl VALUES ("PS107_33","020_107_33","PSA","107","33","33","Leeme Silok ga vuk gili leven menemen dan ga ngan ta lamatbin patmang. La lengkondan i puuvut su, neni ga lox amesemes i, ");
INSERT INTO mmx_vpl VALUES ("PS107_34","020_107_34","PSA","107","34","34","la laxangka liliun neni ga lox i ga ngan ta lomontep. Neni ga lok na lempanga mumu laxapmek atnedi diga nemen go ap mo leven menemen dan. ");
INSERT INTO mmx_vpl VALUES ("PS107_35","020_107_35","PSA","107","35","35","Melemu neni ga ba gili lamatbin patmang, ga ngan manga lengkodan i puuvut su, la neni ga lox asen amu laradan sen go ap mo lenep. ");
INSERT INTO mmx_vpl VALUES ("PS107_36","020_107_36","PSA","107","36","36","Neni ga siam avolo limixin digak pakes ti lempanga anan kusu dina nemen go, la diga xip lemenemen silok tidi ri nemen e. ");
INSERT INTO mmx_vpl VALUES ("PS107_37","020_107_37","PSA","107","37","37","Digat lotlo leventaamang la laxanoos vaen, la digap sepkin aleng. ");
INSERT INTO mmx_vpl VALUES ("PS107_38","020_107_38","PSA","107","38","38","Neni ga lox anarong nedi limixin teren, la diga vosok aleng. Neni goxo ke xepe ba levesipsip mi levenbulumaxao atdi gita mun pipisik. ");
INSERT INTO mmx_vpl VALUES ("PS107_39","020_107_39","PSA","107","39","39","Melemu limixin munepen diga sak tup mi mo limixin at ne Moroa la diga lox amangan nedi, la diga lox abaava aleng nedi mi leven aknixip la levesongsongot silok. ");
INSERT INTO mmx_vpl VALUES ("PS107_40","020_107_40","PSA","107","40","40","Ketla ne Moroa ga lox asongot nedi limixin munepen. Ni ga riki di uto at lamatbin aaxa kusu dina soronga go. ");
INSERT INTO mmx_vpl VALUES ("PS107_41","020_107_41","PSA","107","41","41","Ketla neni ga lam aase mo limixin pakpakes teren, basinge levenmumuat atdi. La ga lox anarong di kusu dina vosok aleng ngan laxasipsip. ");
INSERT INTO mmx_vpl VALUES ("PS107_42","020_107_42","PSA","107","42","42","Do limixin manmanton dina ven i na, dina momo, ketla nedi limixin kapmek dinaba vamus levenngusno atdi. ");
INSERT INTO mmx_vpl VALUES ("PS107_43","020_107_43","PSA","107","43","43","Do nege lodoxoma ren i xasep nunuan, ni na doma mumu i na lempanga, la na doma mumu avukat bok labalamu lexen at Leeme Silok. ");
INSERT INTO mmx_vpl VALUES ("PS108_1","020_108_1","PSA","108","1","1","O Moroa, labalak it kis saga ram. Anak pixan tu, la ana emi asu minu. Labalak, una aus! ");
INSERT INTO mmx_vpl VALUES ("PS108_2","020_108_2","PSA","108","2","2","Loxontaaleng tarak mi ligita, muna gagas. Nia anaba sak aus laxangking at labara kooxot mi loxompixan. ");
INSERT INTO mmx_vpl VALUES ("PS108_3","020_108_3","PSA","108","3","3","O Leeme Silok. Ana tong avukat tu kantubu at larabung mixin axap, la anabak pixan emi asu minu kantubu at limixin axap. ");
INSERT INTO mmx_vpl VALUES ("PS108_4","020_108_4","PSA","108","4","4","Mila labalamu lexen taram i silok aleng tinotno, la i umsu bok to mavana at laxalibet. La luruturun taram i suxuna axap lamavangkap. ");
INSERT INTO mmx_vpl VALUES ("PS108_5","020_108_5","PSA","108","5","5","O Moroa, una lox asuusu lolos taram tovana at lamavangkap, la una lox asuusu bok lisisixam taram to at lengkot axap at na lavatbung menemen. ");
INSERT INTO mmx_vpl VALUES ("PS108_6","020_108_6","PSA","108","6","6","Una rebeng nama mi lolos taram la una lox asepsu nama basinge limixin munepen minama. La una sep siam at lisingising tarak, kusu una lox asu ka nema limixin taram, mo u balamu nama, basinge limixin munepen minama. ");
INSERT INTO mmx_vpl VALUES ("PS108_7","020_108_7","PSA","108","7","7","To at loogu xaala ren Moroa ga tong i xeretna, “Nia anaba sak tup mi limixin munepen minia la ana sak epeseves di basinge lenep kangka rak. Nia anabapdo epes nom lemenemen Sekem ti limixin tarak, la anapdo episa mo lasa ro Sukot tidi. ");
INSERT INTO mmx_vpl VALUES ("PS108_8","020_108_8","PSA","108","8","8","Nia a ruuna mo lunep Gileat la Manase, la lenep Epraem bok ni lavatkiam tarak i tu katling ia at leesep. La lenep Juda ik lox asuusu lubung amgomgo ri limixin tarak. ");
INSERT INTO mmx_vpl VALUES ("PS108_9","020_108_9","PSA","108","9","9","Ketla lenep Moap naba lok ngan lavattingtigon gosogos panga. Nia anaba lu mi luxompanga vatpas tarak uto at lenep Edom, ngan loklok katling do nia a ruuna i. At laaleng nia anaba sak tup mi limixin me Pilistia, anabap kup mi lomomo.” ");
INSERT INTO mmx_vpl VALUES ("PS108_10","020_108_10","PSA","108","10","10","O Moroa, nege bamgo ria uto at lenep silok Edom? Nege ba lok tooro ia xusu ana sak tup midi ro at lemenemen silok atdi, mo diga bos kangkan i mi larangas uat? ");
INSERT INTO mmx_vpl VALUES ("PS108_11","020_108_11","PSA","108","11","11","Kereva, ura sok sisixe xepe rino vam nema, limixin taram? Kereva, ixo epovo bok ba xusu una vas su eburu bok ba mi limixin esep atnema? ");
INSERT INTO mmx_vpl VALUES ("PS108_12","020_108_12","PSA","108","12","12","Una lok tooro nema kusu mana sep limixin munepen, atla lolos at limixin noxo lox epovo tavanga. ");
INSERT INTO mmx_vpl VALUES ("PS108_13","020_108_13","PSA","108","13","13","Do ne Moroa na ru eburu minedik, tanaba sak tup mi limixin munepen, neni naba sev asubu di. ");
INSERT INTO mmx_vpl VALUES ("PS109_1","020_109_1","PSA","109","1","1","Moroa, nenu xusuk mun, nia a emi asu minu. Nemen gat utam pamngus, ");
INSERT INTO mmx_vpl VALUES ("PS109_2","020_109_2","PSA","109","2","2","mila limixin kapmek la limixin sosolo arup, monga di paase sox ia, la dira li laxaxarang mavana rak. ");
INSERT INTO mmx_vpl VALUES ("PS109_3","020_109_3","PSA","109","3","3","Di xarang taba ia, mi laxalinga belengatngas atdi. Dik sok taba parang mun ia mi levelinga la kopmen tavasuun teren. ");
INSERT INTO mmx_vpl VALUES ("PS109_4","020_109_4","PSA","109","4","4","Nia agat kis etangas eburu midi la aga ngising tidi, ketla dixo tu tooro ba ia. ");
INSERT INTO mmx_vpl VALUES ("PS109_5","020_109_5","PSA","109","5","5","Di vorang amlong lununuan tarak tidi mi laxakapmek, la lixitkis etangas tarak tidi di vorang i mi lebele ngatngas atdi. ");
INSERT INTO mmx_vpl VALUES ("PS109_6","020_109_6","PSA","109","6","6","O Moroa, una lok katling ka taradi sosolo arup, kusu ti lok li laradi munepen minia at lavapaase, la mo laradi sosolo arup na sok taba i mi levelinga. ");
INSERT INTO mmx_vpl VALUES ("PS109_7","020_109_7","PSA","109","7","7","La do dina ronga linga ren, a vara i xusu diba vuse ka laxapmek teren. La i epovo do limixin dina ronga levesingising teren la dinaba ronga xibis i do ni laradi xapmek. ");
INSERT INTO mmx_vpl VALUES ("PS109_8","020_109_8","PSA","109","8","8","A vara i xusu levenaleng at lorooro ren na xap kot. A vara i do tara vetpes na lok ka lixitkis amgomgo ren. ");
INSERT INTO mmx_vpl VALUES ("PS109_9","020_109_9","PSA","109","9","9","A vara i do laxamdak mi laxaalik teren dina ravasu ngan lubungkarun, la latkin teren nak lok naa. ");
INSERT INTO mmx_vpl VALUES ("PS109_10","020_109_10","PSA","109","10","10","A vara i do laxamdak mi laxaalik teren dina lok ngan luvuttadi singising panga. A vara i xusu dina sakala su midi boro at loogu tem dadas atdi. ");
INSERT INTO mmx_vpl VALUES ("PS109_11","020_109_11","PSA","109","11","11","A vara i do na laradi xapmek, do tevendinau go ren, mo luvuttadi na laradi xapmek ga dinau atdi, dina vot la dina lok ka axap lempanga ren. A vara i do limixin petpes bok dina lok ka mo lempanga ni ga gugu ka i. ");
INSERT INTO mmx_vpl VALUES ("PS109_12","020_109_12","PSA","109","12","12","A xopara tara na lox asu loklox anare rin, kopla na balamu mo laxamdak mi laxaalik teren melemu at lanmet at ne temen di. ");
INSERT INTO mmx_vpl VALUES ("PS109_13","020_109_13","PSA","109","13","13","A vara mo livipisik li ren dina met ut, la laasen teren dina sakpun kepe i ap mo laraola melemu. ");
INSERT INTO mmx_vpl VALUES ("PS109_14","020_109_14","PSA","109","14","14","A vara i do laxakapmek at lavalabat teren nak lox amisik at lodoxoma at Leeme Silok, la mo laxapmek at nenen, na nemen amisik la nemen gat di guta lok pes kepe i. ");
INSERT INTO mmx_vpl VALUES ("PS109_15","020_109_15","PSA","109","15","15","A vara mo laxapmek atdi nak lox amisik to melamgo at Leeme Silok la neni naba ra korop asu xepe levenasen atnedi basinge lodoxoma at limixin. ");
INSERT INTO mmx_vpl VALUES ("PS109_16","020_109_16","PSA","109","16","16","Mo laradi xapmek goxom doma i do nak lok toloklox anare, ketla gak lox asongot limixin banbalo la gap sev amet di eburu mi limixin pakpakes la baava. ");
INSERT INTO mmx_vpl VALUES ("PS109_17","020_109_17","PSA","109","17","17","Neni ga vavara solo i xusu na lili lasaxaek, a vara i do mo laxasaxaek namlong mu i. Neni goxopara i xusu nak lox anarong limixin, a vara i do teta noxo lox anarong i. ");
INSERT INTO mmx_vpl VALUES ("PS109_18","020_109_18","PSA","109","18","18","Neni gak lok momo rik lox asaxaek limixin, ngan lasakula ren. La a vara i do mo loklox asaxaek teren na suxuna amlong i ngan ladan la ngan bok ladan momonok i beles ukeneng at levesi ren. ");
INSERT INTO mmx_vpl VALUES ("PS109_19","020_109_19","PSA","109","19","19","A vara i do lasaxaek na nemen amisik eburu min ngan lavanga singsiga ren, la na ngan labanbaane diga sevut li i ren. ");
INSERT INTO mmx_vpl VALUES ("PS109_20","020_109_20","PSA","109","20","20","O Leeme Silok. A vara i do una mu asu mo langas la una lox asongot nedi limixin munepen minia, atla di xaxarang taba ia do nia laradi xapmek. ");
INSERT INTO mmx_vpl VALUES ("PS109_21","020_109_21","PSA","109","21","21","Ketla nenu Leeme Silok la Loorong Avolo. Una lok tooro ia kerekngan uga xaape min, la una lox asu ka ia basinge di mumu labalamu nunuan taram. ");
INSERT INTO mmx_vpl VALUES ("PS109_22","020_109_22","PSA","109","22","22","Nenia mun laradi banbalo la pakpakes, la no xeneng at lavatpeve rak ing songot aleng tinotno. ");
INSERT INTO mmx_vpl VALUES ("PS109_23","020_109_23","PSA","109","23","23","La i auret do ana sonao mun ngan lovovo at laradi laxangking i soosoo rin ukantinao, la a lok ngan mun lasku lamanman i mas kepe i. ");
INSERT INTO mmx_vpl VALUES ("PS109_24","020_109_24","PSA","109","24","24","Luvatgulom tarak i meramun axap mila anmun anan. La labantuxu rak ira gelegen ta la ira molobe nga. ");
INSERT INTO mmx_vpl VALUES ("PS109_25","020_109_25","PSA","109","25","25","Do limixin di ven ia, dik lok kalise ia. La do di ven kora ia, dira piripat patlak ta. ");
INSERT INTO mmx_vpl VALUES ("PS109_26","020_109_26","PSA","109","26","26","Leeme Silok ne Moroa rak. U ruuna labalamu lexen, kuren la una lok tooro ia la una lox asepsu ia basinge limixin munepen minia. ");
INSERT INTO mmx_vpl VALUES ("PS109_27","020_109_27","PSA","109","27","27","Una lok di dinaklen i do nenu Leeme Silok, uga lox asepsu ia basinge di. ");
INSERT INTO mmx_vpl VALUES ("PS109_28","020_109_28","PSA","109","28","28","Diba li lasaxaek tarak, ketla nenu unaba lox anarong ia. A vara i do una lox amangan nedi limixin loklox asongot kusu nenia, lasaxaruki ram anaba lok momo. ");
INSERT INTO mmx_vpl VALUES ("PS109_29","020_109_29","PSA","109","29","29","A vara i do limixin munepen minia dinaba ruuna ka lainmangan silok, la mo lainmangan naba suxuna di ngan lavanga singsiga atdi. ");
INSERT INTO mmx_vpl VALUES ("PS109_30","020_109_30","PSA","109","30","30","Nia anaba tong avukat aleng ti Leeme Silok la ana emi asu min kantubu at lovotpot buru at limixin. ");
INSERT INTO mmx_vpl VALUES ("PS109_31","020_109_31","PSA","109","31","31","Mila Leeme Silok i tu at lenep at limixin banbalo, la ik lox asepsu nedi basinge limixin sepsev amet. ");
INSERT INTO mmx_vpl VALUES ("PS110_1","020_110_1","PSA","110","1","1","Leeme Silok ga vaase ri leeme silok tarak keretna, “Unat kis de saparap lakngak tino, se nenia ana lok li limixin munepen minu na ngan loxot burubut ti luxangkedek taram.” ");
INSERT INTO mmx_vpl VALUES ("PS110_2","020_110_2","PSA","110","2","2","Leeme Silok naba lox asilok mo lixitkis amgomgo ram naba ruka i ro Saion. La unabam gomgonga nedi limixin munepen minu. ");
INSERT INTO mmx_vpl VALUES ("PS110_3","020_110_3","PSA","110","3","3","At levenaleng at leesep limixin esep taram diba xulubi aleng kusu ti esep. La no mun at lenmaxantamak suubu, luvuraau radi ram dibat pot pasa u ro vana at lempatkaana i xaala. ");
INSERT INTO mmx_vpl VALUES ("PS110_4","020_110_4","PSA","110","4","4","La Leeme Silok gara xaape vam la kopmen noxo lox ekun bok ba lodoxoma ren. Neni ga lok keretna, “At levenaleng axap i tu melamgo nenu unaba nemen amisik ngan lamaasa kerekngan ne Melkisedek.” ");
INSERT INTO mmx_vpl VALUES ("PS110_5","020_110_5","PSA","110","5","5","Leeme Silok mo i tu at lenep taram ti lok see ram, la neni naba vas adamda lavaorong silok ap mo laaleng neni naba lox asuusu lebelemamao ren. ");
INSERT INTO mmx_vpl VALUES ("PS110_6","020_110_6","PSA","110","6","6","Neni naba viila mumu loklok at larabung mixin axap, la naba lili bubua lenbantuxu at limixin ni ga sev amet pam di, la na sak tup mi limixin amgomgo at lavatbung menemen axap. ");
INSERT INTO mmx_vpl VALUES ("PS110_7","020_110_7","PSA","110","7","7","Loorong naba in dan to at ladan sen saparap langas ti lox alolos amu i. Kuren la neni naba sak tup mi limixin munepen axap teren. ");
INSERT INTO mmx_vpl VALUES ("PS111_1","020_111_1","PSA","111","1","1","Leeme asu ri Leeme Silok. Anaba tong avukat ti Leeme Silok mi labalak axap kantubu at lovotpot buru at limixin manmanton teren. ");
INSERT INTO mmx_vpl VALUES ("PS111_2","020_111_2","PSA","111","2","2","Leven gugu at Leeme Silok i nunuan aleng, la limixin axap di lok momo min, dim doma solo i. ");
INSERT INTO mmx_vpl VALUES ("PS111_3","020_111_3","PSA","111","3","3","La lempanga neni i lox i, i lox aurut laasen kaala ren la i lox asuusu lolos silok teren. La loklok manmanton teren naba nemen lexen. ");
INSERT INTO mmx_vpl VALUES ("PS111_4","020_111_4","PSA","111","4","4","Neni ira lok pam nedik kusu atabam doma amisik mo lempanga nunuan neni ik lox i. Leeme Silok neni ik lox anare ka limixin la i umsu mi lebelen tuntun tidi. ");
INSERT INTO mmx_vpl VALUES ("PS111_5","020_111_5","PSA","111","5","5","Neni mun im taba leveluxa, tinedi dim taba asinorong i. La neni im doma amisik lekabus neni ga lok pam i eburu mi limixin teren. ");
INSERT INTO mmx_vpl VALUES ("PS111_6","020_111_6","PSA","111","6","6","Neni ira vaxase vam limixin teren mi lolos at leven gugu ren keretna. Ni ga raba nedi limixin teren mi levennep kangka at levenabung mixin petpes. ");
INSERT INTO mmx_vpl VALUES ("PS111_7","020_111_7","PSA","111","7","7","Leven gugu axap at lukngen i nunuan la ik mokso. La kopmen taxaxarang keneng at Laulis Linga ren. ");
INSERT INTO mmx_vpl VALUES ("PS111_8","020_111_8","PSA","111","8","8","Laulis Linga naba nemen lexen, mila mo levelinga ga laa boro at Leeme Silok la i ruturun la in manton tino. ");
INSERT INTO mmx_vpl VALUES ("PS111_9","020_111_9","PSA","111","9","9","Neni xusuk mun Laradi Loklox Asepmus ti limixin teren, la ga vaxaxis aulis mo lekabus teren kusu naba nemen amisik. La laasen mun teren i melemelengan la i silok aleng. ");
INSERT INTO mmx_vpl VALUES ("PS111_10","020_111_10","PSA","111","10","10","Loklox asinorong ti Leeme Silok, neni lurutu kaxat ti levendomdoma nunuan. La im taba lodoxoma mokmokso rinedi ding tonga res at levempapaase ali ren. Leemi asu rin naba nemen amisik la kopmen tekavaxap teren. ");
INSERT INTO mmx_vpl VALUES ("PS112_1","020_112_1","PSA","112","1","1","Leemi asu ri Leeme Silok. Luvukat ti mo laradi im taba asinorong Leeme Silok, la i lok momo aleng ting tonga res at levempapaase ali at ne Moroa. ");
INSERT INTO mmx_vpl VALUES ("PS112_2","020_112_2","PSA","112","2","2","Laxamdak mi laxaalik teren dinaba ruuna levenasen silok go at lenep kangka ramtaba la Leeme Silok naba lox anarong livipisik li ren. ");
INSERT INTO mmx_vpl VALUES ("PS112_3","020_112_3","PSA","112","3","3","Nedi loxoetemen dinaba ngasang kobot at laxampanga solo la dinap novos aleng. La at levenaleng axap i tu melamgo di noxok pakes bok ba ti tempanga. ");
INSERT INTO mmx_vpl VALUES ("PS112_4","020_112_4","PSA","112","4","4","Do lamain na vot, laxasep mo ik lok ti laradi manmanton. La ik lox asuusu lebelen tuntun, loklox anare, la loklok ik mokso rin. ");
INSERT INTO mmx_vpl VALUES ("PS112_5","020_112_5","PSA","112","5","5","Luvukat nabat pot ti mo lara im taba gamasa, la ik lok mo lugugu pilas teren mi lomokmokso. ");
INSERT INTO mmx_vpl VALUES ("PS112_6","020_112_6","PSA","112","6","6","Lugugu ap mo laradi avukat noxo subu, la limixin bok di noxo domampe i. ");
INSERT INTO mmx_vpl VALUES ("PS112_7","020_112_7","PSA","112","7","7","Neni noxo marat ba at tevelinga mumu tumumuat boro vetpes neni i ronga i, mila lununu ren i lolos la i nunu saga at Leeme Silok. ");
INSERT INTO mmx_vpl VALUES ("PS112_8","020_112_8","PSA","112","8","8","Leveve ren ira xus pam, la neni kopmen na marat at tempanga. I nunu do ne Moroa naba sak tup mi limixin munepen min. ");
INSERT INTO mmx_vpl VALUES ("PS112_9","020_112_9","PSA","112","9","9","Neni im taba leventamtaba solo mi lebelemulus ti limixin banbalo. La amisik ik lox asuusu labalamu ren ti limixin. La naba ruuna laasen silok la limixin dina lok ngangao aleng teren. ");
INSERT INTO mmx_vpl VALUES ("PS112_10","020_112_10","PSA","112","10","10","La limixin kapmek dinaba ven i la dina musak, la dinabak milik angtungun tin. Ketla levenasen silok atdi ba si aleng tino la mo levendoxoma agagas atdi kopmen noxo soorun tinotno. ");
INSERT INTO mmx_vpl VALUES ("PS113_1","020_113_1","PSA","113","1","1","Leemi asu ri Leeme Silok. Nemi luvuttadi gugu at Leeme Silok, mina emi asu mi laasen teren. ");
INSERT INTO mmx_vpl VALUES ("PS113_2","020_113_2","PSA","113","2","2","I lox avukat do limixin dina emi asu mi laasen teren mo, la at levenaleng axap i tu melamgo. ");
INSERT INTO mmx_vpl VALUES ("PS113_3","020_113_3","PSA","113","3","3","Limixin axap boro at lavanuet mera manman at na lavatbung menemen, mina emi asu mi Leeme Silok. ");
INSERT INTO mmx_vpl VALUES ("PS113_4","020_113_4","PSA","113","4","4","Leeme Silok mun im gomgonga larabung mixin axap, la lisisixam teren i lox avukat aleng ti lempanga rovana at lamavangkap. ");
INSERT INTO mmx_vpl VALUES ("PS113_5","020_113_5","PSA","113","5","5","Kopmen tara i lok ngan Leeme Silok ne Moroa atdik, neni mo it kis tovana at loxonin orong teren pana. ");
INSERT INTO mmx_vpl VALUES ("PS113_6","020_113_6","PSA","113","6","6","La mo ik milik si ukopok ti reven lamavangkap mi lavatkangka. ");
INSERT INTO mmx_vpl VALUES ("PS113_7","020_113_7","PSA","113","7","7","Neni ik lox axatu nedi luvuttadi banbalo basinge laxakup la iram tebeng luvuttadi pakpakes basinge laxakup at lempat balangkao. ");
INSERT INTO mmx_vpl VALUES ("PS113_8","020_113_8","PSA","113","8","8","La irak lox asilok nedi kusu dina etangas eburu mi lavanarong at loorong, nedi di silok kantubu at limixin teren. ");
INSERT INTO mmx_vpl VALUES ("PS113_9","020_113_9","PSA","113","9","9","Neni ik lox amenemen lodoxoma at lavakin kopmen dina pisik, la im taba nedi mi laxamdak mi laxaalik. Leemi asu ri Leeme Silok. ");
INSERT INTO mmx_vpl VALUES ("PS114_1","020_114_1","PSA","114","1","1","At laaleng limixin me Israel, nedi livipisik li at ne Jakop, diga vas kaxat boro Isip. Diga on basinge lara lubung mixin at lavapaase vetpes. ");
INSERT INTO mmx_vpl VALUES ("PS114_2","020_114_2","PSA","114","2","2","Nedi leme Juda diga ravasu ngan limixin kaala at ne Moroa, la nedi leme Israel diga ravasu bok ngan limixin tinotno ren. ");
INSERT INTO mmx_vpl VALUES ("PS114_3","020_114_3","PSA","114","3","3","At lavatpas atdi boro Isip, Loxontas Memele ga ven tangarang di la ga sonao, la ladan sen Joridan ga mes korop, ");
INSERT INTO mmx_vpl VALUES ("PS114_4","020_114_4","PSA","114","4","4","la lempattaavut digat los ngan lempatme, la lengkong kaana digat los ngan lempatnat sipsip. ");
INSERT INTO mmx_vpl VALUES ("PS114_5","020_114_5","PSA","114","5","5","Tila ba la nenu loxontas uga sonao, la tila ba la nenu ladan sen Joridan uga mes korop? ");
INSERT INTO mmx_vpl VALUES ("PS114_6","020_114_6","PSA","114","6","6","La tila nemi bok lempattaavut migat los ngan laxanme, la nemi lengkong kaana migat los ngan lempatnat sipsip? ");
INSERT INTO mmx_vpl VALUES ("PS114_7","020_114_7","PSA","114","7","7","Lavatkangka axap, una dede at lovotpot at Leeme Silok, atla ne Moroa at ne Jakop naba ru asaxaven. ");
INSERT INTO mmx_vpl VALUES ("PS114_8","020_114_8","PSA","114","8","8","Ni ga lok das asu ladan sen boro xeneng at lavaruat, la lengkodan ga puuvut das su at lempat buang uat. ");
INSERT INTO mmx_vpl VALUES ("PS115_1","020_115_1","PSA","115","1","1","O Leeme Silok, ik mokso do limixin dina xip aurut laasen taram, la ixok mokso do dina xip aurut levenasen atnama. Ketla nenu xusuk mun u epovo ri lok ka leemi asu, mumu labalamu lexen taram la uk lox epovo amisik levelinga ram. ");
INSERT INTO mmx_vpl VALUES ("PS115_2","020_115_2","PSA","115","2","2","Tila ba la larabung mixin di sue nedik do, “Ua nga no ne Moroa atnimi?” ");
INSERT INTO mmx_vpl VALUES ("PS115_3","020_115_3","PSA","115","3","3","Moroa atdik ik lok toxun pana at laxalibet, la neni ik lok lempanga salai neni i momo min. ");
INSERT INTO mmx_vpl VALUES ("PS115_4","020_115_4","PSA","115","4","4","Levenmoroa atdi di lox i mi lisiliva la gol, la di lok mun i mi levengkikngen di. ");
INSERT INTO mmx_vpl VALUES ("PS115_5","020_115_5","PSA","115","5","5","Levenngusno mo atdi, ketla dixo epovo na paase. Lengkatli mo atdi, ketla dixo epovo ti reven. ");
INSERT INTO mmx_vpl VALUES ("PS115_6","020_115_6","PSA","115","6","6","Levenbaalung mo atdi, ketla dixo epovo nang tonga. Levenisna mo atdi, ketla dixo epovo nam sumak. ");
INSERT INTO mmx_vpl VALUES ("PS115_7","020_115_7","PSA","115","7","7","Levengkikngen mo atdi, ketla dixo epovo na suma xisip. Lengkangkedek mo atdi, ketla dixo epovo nat pas. La dixo epovo na tong toxolinga. ");
INSERT INTO mmx_vpl VALUES ("PS115_8","020_115_8","PSA","115","8","8","Naba lox avukat do nedi di vop na lempat poovo moroa eburu bok minedi di nunu saga atdi, dinaba vee voovo vanga bok. ");
INSERT INTO mmx_vpl VALUES ("PS115_9","020_115_9","PSA","115","9","9","Nemi limixin me Israel, mina nunu saga mun at Leeme Silok. Neni mun Laradi Loklok Tooro la Lenban bok atnimi. ");
INSERT INTO mmx_vpl VALUES ("PS115_10","020_115_10","PSA","115","10","10","Nemi bok lavamaasa at ne Moroa, mina nunu saga at Leeme Silok. Neni mun Laradi Loklok Tooro la Lenban bok atnimi. ");
INSERT INTO mmx_vpl VALUES ("PS115_11","020_115_11","PSA","115","11","11","La nemi axap mi lotu saparap Leeme Silok, mina nunu saga ren. Neni mun Laradi Loklok Tooro la Lenban bok atnimi. ");
INSERT INTO mmx_vpl VALUES ("PS115_12","020_115_12","PSA","115","12","12","Leeme Silok im doma dik, la neni xa naba lox anarong dik. Neni naba lox anarong nedik limixin me Israel, la naba lox anarong bok nedi lavamaasa at ne Moroa. ");
INSERT INTO mmx_vpl VALUES ("PS115_13","020_115_13","PSA","115","13","13","Neni naba lox anarong bok nedi dik lok ngangao ren, nedi limixin amgomgo la nedi bok limixin gamasa. ");
INSERT INTO mmx_vpl VALUES ("PS115_14","020_115_14","PSA","115","14","14","A sing Leeme Silok do na raba nemi mi taxamdak mi taxaalik, tinemi eburu bok mi livipisik li atnimi. ");
INSERT INTO mmx_vpl VALUES ("PS115_15","020_115_15","PSA","115","15","15","A sing Leeme Silok kusu na lox anarong nemi. Neni Laradi Runtudum Li at laxalibet mi lavatkangka. ");
INSERT INTO mmx_vpl VALUES ("PS115_16","020_115_16","PSA","115","16","16","Laxalibet, neni at Leeme Silok kusuk mun, ketla neni ga raba lavatkangka ri limixin. ");
INSERT INTO mmx_vpl VALUES ("PS115_17","020_115_17","PSA","115","17","17","Luvuttadi dira met pam, dixo epovo kusu dina emi asu mi Leeme Silok, kopla nedi dirat pas pam uto at lemenemen at labarongan. ");
INSERT INTO mmx_vpl VALUES ("PS115_18","020_115_18","PSA","115","18","18","Ketla nedik limixin, move ata rooro, ata tong aorong ti Leeme Silok, monga la amisik, kopmen taxavaxap teren. Leemi asu ri Leeme Silok. ");
INSERT INTO mmx_vpl VALUES ("PS116_1","020_116_1","PSA","116","1","1","Labalak i tu aleng Leeme Silok, mila neni ing tonga ia, neni i ronga res at lisingising tarak. ");
INSERT INTO mmx_vpl VALUES ("PS116_2","020_116_2","PSA","116","2","2","Neni ing tonga ia at lorooro axap tarak. ");
INSERT INTO mmx_vpl VALUES ("PS116_3","020_116_3","PSA","116","3","3","Loxoxo uu ga suxuna ia, la lainmarat at lamaaut ga suxa aumsu ia, la lodoxoma saasaa ga suxuna axap lorooro rak. ");
INSERT INTO mmx_vpl VALUES ("PS116_4","020_116_4","PSA","116","4","4","Melemu aga ro ke at Leeme Silok, “O Leeme Silok, lox asepsu ia.” ");
INSERT INTO mmx_vpl VALUES ("PS116_5","020_116_5","PSA","116","5","5","Leeme Silok i umsu mi lebelen tuntun la luvukat. Moroa atdik neni Laradi Balamu. ");
INSERT INTO mmx_vpl VALUES ("PS116_6","020_116_6","PSA","116","6","6","Leeme Silok ik lok see at limixin banbalo. At laaleng nenia aga ekip tangarang mi laniu, neni ga lox asepsu ia. ");
INSERT INTO mmx_vpl VALUES ("PS116_7","020_116_7","PSA","116","7","7","Labalak, una nunu saga at Leeme Silok, mila Leeme Silok irak lok pam lempanga nunuan tia. ");
INSERT INTO mmx_vpl VALUES ("PS116_8","020_116_8","PSA","116","8","8","La neni ga lox asepsu ia basinge lanmet, la ga lok kepe lainbulu rak, la ga lok tooro ia xusu nia anoxo sak saaban. ");
INSERT INTO mmx_vpl VALUES ("PS116_9","020_116_9","PSA","116","9","9","Kuren la nia at pas eburu mi Leeme Silok at na lorooro nade xopok. ");
INSERT INTO mmx_vpl VALUES ("PS116_10","020_116_10","PSA","116","10","10","Nia aga nunu saga at Leeme Silok kuren la aga vaase, keke i do aga lox abulubun mumu levenmumuat ga lok do na sev amer ia. ");
INSERT INTO mmx_vpl VALUES ("PS116_11","020_116_11","PSA","116","11","11","La keke i do aga marat aleng, la aga lok keretna, “Nia axo epovo kusu ana nunu saga at teta atla limixin axap di luvuttadi xaxarang.” ");
INSERT INTO mmx_vpl VALUES ("PS116_12","020_116_12","PSA","116","12","12","Anaba vorang amlong lununuan at Leeme Silok ik lox i ria xereva? ");
INSERT INTO mmx_vpl VALUES ("PS116_13","020_116_13","PSA","116","13","13","Anaba raba Leeme Silok mi lisinta dan vaen ngan laramtaba, kusu ti tong avukat tin mumu neni ga lox asepsu ia. ");
INSERT INTO mmx_vpl VALUES ("PS116_14","020_116_14","PSA","116","14","14","Anaba lox epovo mo laxakaape rak ti Leeme Silok, to melamgo at lovotpot buru at limixin teren. ");
INSERT INTO mmx_vpl VALUES ("PS116_15","020_116_15","PSA","116","15","15","Leeme Silok ik bulu aleng mo do tara at limixin axa ren i met. ");
INSERT INTO mmx_vpl VALUES ("PS116_16","020_116_16","PSA","116","16","16","O Leeme Silok, nenia laradi gugu ram. Nenia anaba lok lugugu ram kerekngan ne naga ga lok lugugu ram. Ugara lox asepsu vam ia basinge lanmet. ");
INSERT INTO mmx_vpl VALUES ("PS116_17","020_116_17","PSA","116","17","17","Anaba lok tetaba ti tong avukat tu la ana ro ke at laasen taram. ");
INSERT INTO mmx_vpl VALUES ("PS116_18","020_116_18","PSA","116","18","18","Anaba lox epovo laxakaape rak tu ro melamgo at lovotpot buru at limixin axap taram. ");
INSERT INTO mmx_vpl VALUES ("PS116_19","020_116_19","PSA","116","19","19","Anaba lox i na ro at lemelua saparap loogu xaala ram, keneng tinotno at lemenemen Jerusalem. Leemi asu ri Leeme Silok. ");
INSERT INTO mmx_vpl VALUES ("PS117_1","020_117_1","PSA","117","1","1","Nemi axap limixin kopmen nemi me Juda, mina emi asu mi Leeme Silok. Limixin at lengkot axap, mina xip aurut laasen teren. ");
INSERT INTO mmx_vpl VALUES ("PS117_2","020_117_2","PSA","117","2","2","Mila mo labalamu ren tidik i silok aleng, la luruturun teren tidik naba tu amisik la kopmen taxavaxap teren. Leemi asu ri Leeme Silok. ");
INSERT INTO mmx_vpl VALUES ("PS118_1","020_118_1","PSA","118","1","1","Ata tong avukat ti Leeme Silok, mila neni mun i lox avukat la labalamu ren i tu lexen. ");
INSERT INTO mmx_vpl VALUES ("PS118_2","020_118_2","PSA","118","2","2","Limixin me Israel, mina tong i do, labalamu ren i tu lexen. ");
INSERT INTO mmx_vpl VALUES ("PS118_3","020_118_3","PSA","118","3","3","Nemi lavamaasa, livipisik li at ne Aron, mina tong box i do, labalamu ren i tu lexen. ");
INSERT INTO mmx_vpl VALUES ("PS118_4","020_118_4","PSA","118","4","4","Nedi bok limixin di lotu saparap Leeme Silok, dina tong i do, labalamu ren i tu lexen. ");
INSERT INTO mmx_vpl VALUES ("PS118_5","020_118_5","PSA","118","5","5","Keneng at levenaleng at levenmumuat, aga toro ke at Leeme Silok la ni ga ronga ia la ga lox asepsu ia basinge mo levenmumuat. ");
INSERT INTO mmx_vpl VALUES ("PS118_6","020_118_6","PSA","118","6","6","Leeme Silok ik lok eburu minia, la nia xopmen anoxo marat at lempanga limixin kapmek diba lox i ria. ");
INSERT INTO mmx_vpl VALUES ("PS118_7","020_118_7","PSA","118","7","7","Leeme Silok ik lok eburu minia. Neni mun Laradi Loklok Tooro rak. La nenia anaba ven Leeme Silok na sak tup mi limixin munepen minia. ");
INSERT INTO mmx_vpl VALUES ("PS118_8","020_118_8","PSA","118","8","8","Naba lox avukat do nedik ata nunu saga at Leeme Silok, la nemen gat dik guta nunu saga at limixin. ");
INSERT INTO mmx_vpl VALUES ("PS118_9","020_118_9","PSA","118","9","9","Naba lox avukat do ata doxoma saga at Leeme Silok, la nemen gat dik guta doxoma saga at lubung amgomgo at limixin. ");
INSERT INTO mmx_vpl VALUES ("PS118_10","020_118_10","PSA","118","10","10","Lavamunepen buaang diga tu kangkan ia, ketla aga sele utut kepe axap di mi lolos at Leeme Silok. ");
INSERT INTO mmx_vpl VALUES ("PS118_11","020_118_11","PSA","118","11","11","Diga tu kangkan ia at lengkot axap, ketla aga sele utut kepe axap di mi lolos at Leeme Silok. ");
INSERT INTO mmx_vpl VALUES ("PS118_12","020_118_12","PSA","118","12","12","Diga tu kangkan mu ia ngan laxampo masum, ketla soso mun diga met axap ngan ta laxao i anan levempivilis mang. Ara sele utut kepe axap di mi lolos at Leeme Silok. ");
INSERT INTO mmx_vpl VALUES ("PS118_13","020_118_13","PSA","118","13","13","Diga esep tangarang minia la ga auret do dina sev amer ia, ketla Leeme Silok ga lok tooro ia. ");
INSERT INTO mmx_vpl VALUES ("PS118_14","020_118_14","PSA","118","14","14","Leeme Silok ik lox alolos ia la neni ga lox asepsu ia basinge di. ");
INSERT INTO mmx_vpl VALUES ("PS118_15","020_118_15","PSA","118","15","15","Limixin mo dip kup mi lomomo keneng at laraogu kadis at limixin manmanton, mila dira sak tup pam mi limixin munepen midi. La lolos mun at Leeme Silok ga lox i na lempanga. ");
INSERT INTO mmx_vpl VALUES ("PS118_16","020_118_16","PSA","118","16","16","Lolos at Leeme Silok ga lok tooro dik kusu ti sak tup mi limixin munepen midik. Lolos teren ga lok tooro dik keneng at leesep. ");
INSERT INTO mmx_vpl VALUES ("PS118_17","020_118_17","PSA","118","17","17","Nenia anoxo met, ketla anaba rooro, la anaba paase asu lempanga Leeme Silok ga lok pam i. ");
INSERT INTO mmx_vpl VALUES ("PS118_18","020_118_18","PSA","118","18","18","Leeme Silok ira sep aleeng kapmek tinotno vam ia, ketla neni ixo ke xepe ba ia xusu ana met. ");
INSERT INTO mmx_vpl VALUES ("PS118_19","020_118_19","PSA","118","19","19","Mina suang lempatban at loogu laplavang, kusu aba beles la ana tong avukat ti Leeme Silok. ");
INSERT INTO mmx_vpl VALUES ("PS118_20","020_118_20","PSA","118","20","20","Anai ni lumusmaragu at Leeme Silok. Limixin manmanton kusuk mun di epovo kusu dina beles teren. ");
INSERT INTO mmx_vpl VALUES ("PS118_21","020_118_21","PSA","118","21","21","Leeme Silok, nia a emi asu minu, mila uga ronga lisingising tarak. La uga lok tooro ia xusu ana sak tup mi limixin munepen minia. ");
INSERT INTO mmx_vpl VALUES ("PS118_22","020_118_22","PSA","118","22","22","Mo luuat limixin kipkip gu diga sok tixirixes kepe i, ga ravasu ngan Luuat Kis la lugugu ren i silok aleng. ");
INSERT INTO mmx_vpl VALUES ("PS118_23","020_118_23","PSA","118","23","23","Leeme Silok axa ga lox i na, la i lox avukat aleng at levereven atdik. ");
INSERT INTO mmx_vpl VALUES ("PS118_24","020_118_24","PSA","118","24","24","Na xa laaleng ni laaleng ti lok katling loklok tooro at Leeme Silok. Ata sosoro la ata momo aleng min. ");
INSERT INTO mmx_vpl VALUES ("PS118_25","020_118_25","PSA","118","25","25","Leeme Silok, una lox asepsu nama basinge limixin munepen minama. O Leeme Silok, una lok tooro nama xusu mana ngasang kobot at lempanga nunuan mak pakes tin. ");
INSERT INTO mmx_vpl VALUES ("PS118_26","020_118_26","PSA","118","26","26","Luvukat ti na laradi it pas mi laasen at Leeme Silok. Manaba lox anarong nemi axap mira vubeles pam to xeneng at loogu laplavang at Leeme Silok. ");
INSERT INTO mmx_vpl VALUES ("PS118_27","020_118_27","PSA","118","27","27","Leeme Silok, neni ne Moroa, la neni ira lox anarong pam dik. Ataba tu eburu mi lengkakan bisi at lentingen dik at na laaleng momo la atap tii ben kangkan mo loxonin laplavang. ");
INSERT INTO mmx_vpl VALUES ("PS118_28","020_118_28","PSA","118","28","28","Nenu mun ne Moroa rak, la a tong aorong tu. La a xip aurut laasen taram mumu lolos silok taram. ");
INSERT INTO mmx_vpl VALUES ("PS118_29","020_118_29","PSA","118","29","29","Ata tong avukat ti ne Moroa, mila neni mun i lok nunuan. Mo labalamu ren naba nemen lexen. ");
INSERT INTO mmx_vpl VALUES ("PS119_1","020_119_1","PSA","119","1","1","Leveloklox anarong mo ik lok tinedi lorooro atdi kopmen tosoogong teren, la di rooro mumu asu Laulis Linga at Leeme Silok. ");
INSERT INTO mmx_vpl VALUES ("PS119_2","020_119_2","PSA","119","2","2","Lomomo mo ik lok tinedi di mumu asu lempapaase matmatkun at Leeme Silok la ding tonga res teren mi lebelendi axap. ");
INSERT INTO mmx_vpl VALUES ("PS119_3","020_119_3","PSA","119","3","3","Dixo lok tempanga i bilinga, ketla dit pas mu asu leveloklok at Leeme Silok. ");
INSERT INTO mmx_vpl VALUES ("PS119_4","020_119_4","PSA","119","4","4","Leeme Silok, nenu ura li vam levempapaase auru ram, kusu nema manang tonga res mu nunuan tino i. ");
INSERT INTO mmx_vpl VALUES ("PS119_5","020_119_5","PSA","119","5","5","Naba lox avukat aleng mo do nenia a ruturun tim tebeng atmatkun leventetere avolo ram. ");
INSERT INTO mmx_vpl VALUES ("PS119_6","020_119_6","PSA","119","6","6","Do nia anam doma aklen amisik ti mo levempapaase ali ram, nia noxo ruuna ka lainmangan. ");
INSERT INTO mmx_vpl VALUES ("PS119_7","020_119_7","PSA","119","7","7","Aba emi asu minu mi labalak i xasep, dola nenia anaklen avukat ka leventaangas mokmokso ram. ");
INSERT INTO mmx_vpl VALUES ("PS119_8","020_119_8","PSA","119","8","8","Aba ronga res mu axap leventetere avolo ram, kuren la nemen uta rexes kepe ia. ");
INSERT INTO mmx_vpl VALUES ("PS119_9","020_119_9","PSA","119","9","9","Tamdak aau naba lok lorooro ren kereva xusu na nemen manmanton? Neni na rooro mu mun levelinga ram. ");
INSERT INTO mmx_vpl VALUES ("PS119_10","020_119_10","PSA","119","10","10","Nia a lolos kusu ana gugu taba u mi labalak axap, la una lok tooro ia xusu nia anoxo ronga xepe mo levempapaase ali ram. ");
INSERT INTO mmx_vpl VALUES ("PS119_11","020_119_11","PSA","119","11","11","Ara xonom ka axap pam levelinga ram mi labalak, kusu nenia anoxo lok taxakapmek tu. ");
INSERT INTO mmx_vpl VALUES ("PS119_12","020_119_12","PSA","119","12","12","O Leeme Silok, leemi asu mun tu. Una anasa ia mi leventetere avolo ram. ");
INSERT INTO mmx_vpl VALUES ("PS119_13","020_119_13","PSA","119","13","13","Nenia anaba paase asu amisik mo leventaangas nenu uga raba nema min. ");
INSERT INTO mmx_vpl VALUES ("PS119_14","020_119_14","PSA","119","14","14","A momo ri mumu asu levempapaase matmatkun taram. Mo lomomo i volo lomomo at laradi i lok momo mumu langsangan lapnovos teren. ");
INSERT INTO mmx_vpl VALUES ("PS119_15","020_119_15","PSA","119","15","15","A viila mumu levempapaase auru ram la aram doma mumu avukat levenanasa ram. ");
INSERT INTO mmx_vpl VALUES ("PS119_16","020_119_16","PSA","119","16","16","A momo aleng at leventetere avolo ram, kuren la anoxo doma aie xepe ba levelinga ram. ");
INSERT INTO mmx_vpl VALUES ("PS119_17","020_119_17","PSA","119","17","17","Una lok lununuan tia, laradi gugu ram, kusu nia aba rooro, la abang tonga res at levelinga ram. ");
INSERT INTO mmx_vpl VALUES ("PS119_18","020_119_18","PSA","119","18","18","Una valas luxatli rak kusu aba ven kibis levenanasa nunuan keneng at Laulis Linga ram. ");
INSERT INTO mmx_vpl VALUES ("PS119_19","020_119_19","PSA","119","19","19","A nemen ngan loose at na lavatkangka, la nemen gat uta lipe levempapaase ali ram basinge ia. ");
INSERT INTO mmx_vpl VALUES ("PS119_20","020_119_20","PSA","119","20","20","Lorooro axap tarak, mo i ngaongao mu leventaangas taram. A vara i xusu ana xasep avukat teren at levenaleng amisik. ");
INSERT INTO mmx_vpl VALUES ("PS119_21","020_119_21","PSA","119","21","21","U paase sok luvuttadi loklox aru, la lasaxaek ik lok mavana atnedi dit pas taba rulu mo levempapaase ali ram. ");
INSERT INTO mmx_vpl VALUES ("PS119_22","020_119_22","PSA","119","22","22","Una sep pinak di kusu di noxo paase aksaksa ria la dinoxo paase kapmek bok tia, mila nenia a mumu asu lempapaase matmatkun taram. ");
INSERT INTO mmx_vpl VALUES ("PS119_23","020_119_23","PSA","119","23","23","Keke i do luvuttadi amgomgo dina xis buru, la dina puse ngas ti sev amer ia. Ketla nenia abam doma mumu amisik leventetere avolo ram. ");
INSERT INTO mmx_vpl VALUES ("PS119_24","020_119_24","PSA","119","24","24","Lempapaase matmatkun taram i so misigisigis, ni mun ik lok tooro ia xusu ana ruuna ka lodoxoma avukat. ");
INSERT INTO mmx_vpl VALUES ("PS119_25","020_119_25","PSA","119","25","25","Nia mo ak midi rinotno ro xeneng at laxakup la i auret kusu ana met. Una lox aroo ia kerekngan levelinga ram. ");
INSERT INTO mmx_vpl VALUES ("PS119_26","020_119_26","PSA","119","26","26","Aga tong asu axap lorooro rak, la uga ronga ia. Una anasa ia mi leventetere avolo ram. ");
INSERT INTO mmx_vpl VALUES ("PS119_27","020_119_27","PSA","119","27","27","Una lok tooro ia xusu ana xasep at levenanasa at levempapaase auru ram, kusu abam doma mumu mo leven gugu nunuan taram. ");
INSERT INTO mmx_vpl VALUES ("PS119_28","020_119_28","PSA","119","28","28","Lorooro rak mo i umsu mi lainbulu, kuren la una lox alolos ia kerekngan levelinga ram. ");
INSERT INTO mmx_vpl VALUES ("PS119_29","020_119_29","PSA","119","29","29","Una tupe ia xusu anoxo beles at leveloklok i lok kapmek. La una lox ase ia mi Laulis Linga ram atla u balamu ia. ");
INSERT INTO mmx_vpl VALUES ("PS119_30","020_119_30","PSA","119","30","30","Ara soxolik ka vam langas ti mumu asu levelinga ruturun taram. Ara ronga avukat pam leventaangas linga ram. ");
INSERT INTO mmx_vpl VALUES ("PS119_31","020_119_31","PSA","119","31","31","O Leeme Silok, am tebeng lolos lempapaase matmatkun taram. Nemen uta ke xepe ia la limixin dina lox amangan ia. ");
INSERT INTO mmx_vpl VALUES ("PS119_32","020_119_32","PSA","119","32","32","A lolos aleng kusu ana mumu asu mo levempapaase ali ram, mila uba suxa amu manga ia mi lodoxoma avukat. ");
INSERT INTO mmx_vpl VALUES ("PS119_33","020_119_33","PSA","119","33","33","O Leeme Silok, una lox ase ia kusu ana xasep at leventetere avolo ram, la anabang tonga res teren at levenaleng axap. ");
INSERT INTO mmx_vpl VALUES ("PS119_34","020_119_34","PSA","119","34","34","Una soxomus asu Laulis Linga ram tia la abam tebeng atmatkun teren. La anang tonga res teren mi labalak axap. ");
INSERT INTO mmx_vpl VALUES ("PS119_35","020_119_35","PSA","119","35","35","Una lam ia xusu ana mumu asu mo levempapaase ali ram, mila ik lox asuusu lomomo ria. ");
INSERT INTO mmx_vpl VALUES ("PS119_36","020_119_36","PSA","119","36","36","Una lok labalak kusu ana mumu asu lempapaase matmatkun taram, la kopmen nia anoxo vara solo lapnovos silok mede xopok. ");
INSERT INTO mmx_vpl VALUES ("PS119_37","020_119_37","PSA","119","37","37","Una lok luxatli rak kusu anoxo veneves at laxampanga gamasa la una lox anunuan lorooro rak kerekngan levelinga ram. ");
INSERT INTO mmx_vpl VALUES ("PS119_38","020_119_38","PSA","119","38","38","Una lox epovo laxakaape ram tia, laradi gugu ram, i ngan uk lox epovo i rinedi ding tonga res taram. ");
INSERT INTO mmx_vpl VALUES ("PS119_39","020_119_39","PSA","119","39","39","Una ru pepe mo lempapaase aksaksa, ua ik lox amarar ia. Leventaangas taram i lox avukat. ");
INSERT INTO mmx_vpl VALUES ("PS119_40","020_119_40","PSA","119","40","40","A vara rinotno i xusu ana mumu asu levempapaase auru ram. Una lox amaxat lorooro rak mila loklok taram in manton tino. ");
INSERT INTO mmx_vpl VALUES ("PS119_41","020_119_41","PSA","119","41","41","Leeme Silok, una lox asuusu labalamu ram tia, la una lox asepsu ia kerekngan laxakaape ram tia, ");
INSERT INTO mmx_vpl VALUES ("PS119_42","020_119_42","PSA","119","42","42","kuren la aba epovo na vaase porang levelinga ap mo luvuttadi di paase aksaksa ria, mila nia a nunu saga at levelinga ram. ");
INSERT INTO mmx_vpl VALUES ("PS119_43","020_119_43","PSA","119","43","43","Nemen uta lok pes mo levelinga ruturun taram basinge ia, mila nia aga lok li lodomdoma voovo rak at leventaangas taram. ");
INSERT INTO mmx_vpl VALUES ("PS119_44","020_119_44","PSA","119","44","44","Anabang tonga res amisik at Laulis Linga ram at levenaleng axap i tu melamgo. ");
INSERT INTO mmx_vpl VALUES ("PS119_45","020_119_45","PSA","119","45","45","Anaba nemen asepmus basinge levenmumuat, mila nia a mumu asu levempapaase auru ram. ");
INSERT INTO mmx_vpl VALUES ("PS119_46","020_119_46","PSA","119","46","46","Anaba paase asu levempapaase matmatkun taram ti lavaorong silok, la nia anoxo mangan. ");
INSERT INTO mmx_vpl VALUES ("PS119_47","020_119_47","PSA","119","47","47","Levempapaase ali ram ik lox asuusu lomomo ria, la labalak i tu i. ");
INSERT INTO mmx_vpl VALUES ("PS119_48","020_119_48","PSA","119","48","48","A lok ngangao aleng ap mo levempapaase ali ram la labalak i tu mun i, la abam doma mumu amisik mo leventetere avolo ram. ");
INSERT INTO mmx_vpl VALUES ("PS119_49","020_119_49","PSA","119","49","49","Leeme Silok, una doxoma mo laxakaape ram tia, laradi gugu ram, mila i lox alolos ia xusu ana nunu saga ram. ");
INSERT INTO mmx_vpl VALUES ("PS119_50","020_119_50","PSA","119","50","50","Uga lox amenemen ia at laaleng aga nemen keneng at losongsongot, mila uga lox epovo laxakaape ram tia la uga lox asepsu ia. ");
INSERT INTO mmx_vpl VALUES ("PS119_51","020_119_51","PSA","119","51","51","Limixin loklok keexee dik lok kalise amisix ia, ketla nia axo vas basinge ba Laulis Linga ram. ");
INSERT INTO mmx_vpl VALUES ("PS119_52","020_119_52","PSA","119","52","52","O Leeme Silok, a doma mo leventaangas taram me gaxatnak, la im taba ia mi loklox amenemen. ");
INSERT INTO mmx_vpl VALUES ("PS119_53","020_119_53","PSA","119","53","53","Dola nia a ven limixin kapmek di los polo Laulis Linga ram, lebelemamao i suxuna lorooro rak. ");
INSERT INTO mmx_vpl VALUES ("PS119_54","020_119_54","PSA","119","54","54","At lorooro rak at na lavatkangka, a vo lengkompixan mi leventetere avolo ram. ");
INSERT INTO mmx_vpl VALUES ("PS119_55","020_119_55","PSA","119","55","55","Leeme Silok, am doma u at lengkanimin, la am doma mumu bok Laulis Linga ram. ");
INSERT INTO mmx_vpl VALUES ("PS119_56","020_119_56","PSA","119","56","56","Lomomo it pot tarak mumu mun levempapaase auru ram, la nia ang tonga res mu i. ");
INSERT INTO mmx_vpl VALUES ("PS119_57","020_119_57","PSA","119","57","57","O Leeme Silok, labalak i tu xusuk mun u. Nia a xaape do anabang tonga res mu amisik levelinga ram. ");
INSERT INTO mmx_vpl VALUES ("PS119_58","020_119_58","PSA","119","58","58","A sing u mi labalak axap do una lox asuusu lebelen tuntun taram tia, ngan ugara xaape vam min. ");
INSERT INTO mmx_vpl VALUES ("PS119_59","020_119_59","PSA","119","59","59","Ara ila mumu vam lorooro rak, la ara ba gili lorooro rak kusu ana mumu asu levempapaase matmatkun taram. ");
INSERT INTO mmx_vpl VALUES ("PS119_60","020_119_60","PSA","119","60","60","Aba lok soso mun la anoxok lok sila kusu ti mumu asu mo levempapaase ali ram. ");
INSERT INTO mmx_vpl VALUES ("PS119_61","020_119_61","PSA","119","61","61","Keke i do limixin kapmek dinam kobot ia mi laxalinga xaxarang, anoxo ke xepe ba Laulis Linga ram. ");
INSERT INTO mmx_vpl VALUES ("PS119_62","020_119_62","PSA","119","62","62","At lengkanimin tubu a katu kaxat kusu ana tong avukat tu ri nom leventaangas mokmokso ram. ");
INSERT INTO mmx_vpl VALUES ("PS119_63","020_119_63","PSA","119","63","63","Nenia lentangas atnedi axap limixin dik lok ngangao ram la atnedi axap bok di mumu asu levempapaase auru ram. ");
INSERT INTO mmx_vpl VALUES ("PS119_64","020_119_64","PSA","119","64","64","O Leeme Silok, lavatbung menemen i umsu aleng mi labalamu lexen taram. Una anasa ia mi leventetere avolo ram. ");
INSERT INTO mmx_vpl VALUES ("PS119_65","020_119_65","PSA","119","65","65","O Leeme Silok, urak lox anarong pam ia, laradi gugu ram, kerekngan levelinga ram. ");
INSERT INTO mmx_vpl VALUES ("PS119_66","020_119_66","PSA","119","66","66","Una anasa ia mi levendoxoma nunuan la lakleklen, mila nia a nunu saga at levempapaase ali ram. ");
INSERT INTO mmx_vpl VALUES ("PS119_67","020_119_67","PSA","119","67","67","Nia aga vas soogong, la uga sev asongor ia. Ketla ananga nia ang tonga res at levelinga ram. ");
INSERT INTO mmx_vpl VALUES ("PS119_68","020_119_68","PSA","119","68","68","Nenu u umsu mi lununuan, la uk lox asuusu loklox anare ri limixin. Una anasa ia mi leventetere avolo ram. ");
INSERT INTO mmx_vpl VALUES ("PS119_69","020_119_69","PSA","119","69","69","Limixin loklox aaru di paase xaxarang mumu ia, ketla mi labalak axap ang tonga res at levempapaase auru ram. ");
INSERT INTO mmx_vpl VALUES ("PS119_70","020_119_70","PSA","119","70","70","Mo luvuttadi kopmen tevendoxoma nunuan atdi ti levelinga ram, ketla nia an tuuna ka lomomo boro at Laulis Linga ram. ");
INSERT INTO mmx_vpl VALUES ("PS119_71","020_119_71","PSA","119","71","71","Mo levesongsongot uga raba ia min ga lok tooro ia, kuren la agaklen ka avukat leventetere avolo ram. ");
INSERT INTO mmx_vpl VALUES ("PS119_72","020_119_72","PSA","119","72","72","Mo Laulis Linga nenu uga raba ia min, ni i lok nunuan aleng ti lempilas axap at na lavatbung menemen. ");
INSERT INTO mmx_vpl VALUES ("PS119_73","020_119_73","PSA","119","73","73","Uga rudum ia mi lukngam la uk lox alipe ia basinge laniu. Una raba ia mi levendoxoma nunuan kusu ti lox ase at levempapaase ali ram. ");
INSERT INTO mmx_vpl VALUES ("PS119_74","020_119_74","PSA","119","74","74","Nedi dim taba asinorong u, dik lok momo do dina reven tarak. Mila nia a nunu saga at levelinga ram. ");
INSERT INTO mmx_vpl VALUES ("PS119_75","020_119_75","PSA","119","75","75","O Leeme Silok, aklen i do leventaangas taram ik mokso aleng, la ugak lox aleeng ia mila nenu u ruturun at laxakaape ram. ");
INSERT INTO mmx_vpl VALUES ("PS119_76","020_119_76","PSA","119","76","76","Una lox asuusu mo labalamu lexen taram kusu na lox amenemen ia, kerekngan uga xaape vam min tia, laradi gugu ram. ");
INSERT INTO mmx_vpl VALUES ("PS119_77","020_119_77","PSA","119","77","77","Una lox asuusu lebelen tuntun taram tia xusu lorooro rak naba nemen avukat mila an tuuna ka lomomo boro at Laulis Linga ram. ");
INSERT INTO mmx_vpl VALUES ("PS119_78","020_119_78","PSA","119","78","78","Naba lox avukat do una lox amangan nedi limixin loklox aaru, mila di lili laxalinga xaxarang mumu ia. Ketla nenia, anabam doma mumu levempapaase auru ram. ");
INSERT INTO mmx_vpl VALUES ("PS119_79","020_119_79","PSA","119","79","79","Naba lox avukat do nedi dim taba asinorong u, dina vot pasa ia kusu dina etaba belen minia. Nedi bok di xasep at lempapaase matmatkun taram. ");
INSERT INTO mmx_vpl VALUES ("PS119_80","020_119_80","PSA","119","80","80","Naba lox avukat do labalak nang tonga res mu avukat leventetere avolo ram, kusu naba lox asepsu ia basinge lainmangan atdi mo dik lox asi ia. ");
INSERT INTO mmx_vpl VALUES ("PS119_81","020_119_81","PSA","119","81","81","O Leeme Silok, lengkot axap tarak ira meleexot axap la a ngangais tu xusu una lox asepsu ia. Nia a nunu saga at levelinga ram. ");
INSERT INTO mmx_vpl VALUES ("PS119_82","020_119_82","PSA","119","82","82","Luxatli rak ira molo nga ri reven pupuke ri leveng kakaape ram. La ara lok, “Lingisa ba uba lok tooro ia?” ");
INSERT INTO mmx_vpl VALUES ("PS119_83","020_119_83","PSA","119","83","83","Nenia a lok ngan mun labantamon tem dadas. Ketla axo ke xepe ba leventetere avolo ram. ");
INSERT INTO mmx_vpl VALUES ("PS119_84","020_119_84","PSA","119","84","84","Nenia laradi gugu ram, anaba ngais alika ba? Lingisa ba uba sev asongot nedi dik lox asongor ia? ");
INSERT INTO mmx_vpl VALUES ("PS119_85","020_119_85","PSA","119","85","85","Limixin loklox aaru di ke xepe Laulis Linga ram, dira lok pam lenngitngit tia. ");
INSERT INTO mmx_vpl VALUES ("PS119_86","020_119_86","PSA","119","86","86","Levempapaase ali ram i epovo rinotno xusu limixin dina nunu saga ren. Una lok tooro ia, mila limixin dik lox asongot gamasa mun ia la kopmen tavasuun teren. ");
INSERT INTO mmx_vpl VALUES ("PS119_87","020_119_87","PSA","119","87","87","Ga auret kusu dina sev amer ia. Ketla nia axo raba rulu ba levempapaase auru ram. ");
INSERT INTO mmx_vpl VALUES ("PS119_88","020_119_88","PSA","119","88","88","Mumu labalamu lexen taram, una lok lempanga nunuan tia, kusu abang tonga res at levempapaase matmatkun taram. ");
INSERT INTO mmx_vpl VALUES ("PS119_89","020_119_89","PSA","119","89","89","O Leeme silok, levelinga ram nabak lok at levenaleng axap i tu melamgo, la mo levelinga i tu tuxuruxun kerekngan laxalibet. ");
INSERT INTO mmx_vpl VALUES ("PS119_90","020_119_90","PSA","119","90","90","Nenu unaba ruturun amisik ti limixin la kantubu bok at lavaola axap mo dibap tavasu melemu. Uga vaxaxis aulis na lavatkangka la mo it kis tuxuruxun kuren. ");
INSERT INTO mmx_vpl VALUES ("PS119_91","020_119_91","PSA","119","91","91","Laulis Linga ram mo i nemen tuxuruxun se at na levenaleng, mila lempanga axap i lok ngan lavasaxaruki ram. ");
INSERT INTO mmx_vpl VALUES ("PS119_92","020_119_92","PSA","119","92","92","Mo do Laulis Linga gixo lox amomo ia, nia ro gira met pam mumu laxasongsongot tarak. ");
INSERT INTO mmx_vpl VALUES ("PS119_93","020_119_93","PSA","119","93","93","Anoxo ronga xepe levempapaase auru ram, mila mumu mun i na levelinga loklok tooro ram, nenu urak lok tatao lorooro rak basinge lanmet. ");
INSERT INTO mmx_vpl VALUES ("PS119_94","020_119_94","PSA","119","94","94","Una lox asepsu ia mila nenia ataram. La nia ara lolos amisik kusu ana mumu asu levempapaase auru ram. ");
INSERT INTO mmx_vpl VALUES ("PS119_95","020_119_95","PSA","119","95","95","Limixin kapmek mo di kuxut tangais ia xusu dina sev amer ia. Ketla nenia abam doma mumu levempapaase matmatkun taram. ");
INSERT INTO mmx_vpl VALUES ("PS119_96","020_119_96","PSA","119","96","96","Araklen ba i do lempanga axap noxo nemen abao, ketla mo levempapaase ali ram kopmen taxavaxap teren. ");
INSERT INTO mmx_vpl VALUES ("PS119_97","020_119_97","PSA","119","97","97","Labalak i tu mun Laulis Linga ram, la am doma mumu amisix i at levenaleng kangking la kanimin. ");
INSERT INTO mmx_vpl VALUES ("PS119_98","020_119_98","PSA","119","98","98","Mo levempapaase ali ram, ik lox amisik keneng at lodoxoma rak, la i lox ia, a xasep nunuan aleng polo nedi limixin munepen minia. ");
INSERT INTO mmx_vpl VALUES ("PS119_99","020_119_99","PSA","119","99","99","Aklen aleng polo nedi axap luvuttadi loklox ase rak, mila am doma mumu amisik levempapaase matmatkun taram. ");
INSERT INTO mmx_vpl VALUES ("PS119_100","020_119_100","PSA","119","100","100","Aklen aleng polo nedi loxongkulao mukun, mila ang tonga res at levempapaase auru ram. ");
INSERT INTO mmx_vpl VALUES ("PS119_101","020_119_101","PSA","119","101","101","Aga lok tatao alabat lavatpas tarak basinge lempatpas ua ga xapmek, kusu aba ronga res mu levelinga ram. ");
INSERT INTO mmx_vpl VALUES ("PS119_102","020_119_102","PSA","119","102","102","Axo ke xepe leventaangas taram, mila nenu axa uga anasa ia min. ");
INSERT INTO mmx_vpl VALUES ("PS119_103","020_119_103","PSA","119","103","103","Levelinga ram i so misigisigis aleng, la i volo loso at ladan misiu. ");
INSERT INTO mmx_vpl VALUES ("PS119_104","020_119_104","PSA","119","104","104","Lempapaase auru mun taram im taba ia mi levendoxoma nunuan. Kuren la nia a xopara aleng mo langas kapmek limixin dit pas teren. ");
INSERT INTO mmx_vpl VALUES ("PS119_105","020_119_105","PSA","119","105","105","Levelinga ram i lok ngan lababao rim lam ia, la i lok ngan bok laxasep ti langas tarak. ");
INSERT INTO mmx_vpl VALUES ("PS119_106","020_119_106","PSA","119","106","106","Anaba lox epovo laxakaape lolos tarak do, anaba mumu asu amisik mo leventaangas mokmokso ram. ");
INSERT INTO mmx_vpl VALUES ("PS119_107","020_119_107","PSA","119","107","107","Leeme Silok, levesongsongot tarak i silok aleng tinotno. Una lok tatao nunuan lorooro rak, kerekngan levelinga ram. ");
INSERT INTO mmx_vpl VALUES ("PS119_108","020_119_108","PSA","119","108","108","O Leeme Silok, una mulus ka lisingising emi asu rak, la una anasa ia mi leventaangas taram. ");
INSERT INTO mmx_vpl VALUES ("PS119_109","020_119_109","PSA","119","109","109","Laniu i tu saparap amisix ia xusu na lok korop kepe lorooro rak, ketla nia axo ke xepe gamasa ba Laulis Linga ram. ");
INSERT INTO mmx_vpl VALUES ("PS119_110","020_119_110","PSA","119","110","110","Limixin kapmek di lili larapelixo ria, ketla nia axo ronga xepe lempapaase auru ram. ");
INSERT INTO mmx_vpl VALUES ("PS119_111","020_119_111","PSA","119","111","111","Lempapaase matmatkun taram i lok ngan loxom pulus nunuan naba nemen amisik eburu minia, la i lox aumsu labalak mi lomomo. ");
INSERT INTO mmx_vpl VALUES ("PS119_112","020_119_112","PSA","119","112","112","Nia a doma vam i do anabang tonga res at leventetere avolo ram, naba se at laaleng lorooro rak naba xap. ");
INSERT INTO mmx_vpl VALUES ("PS119_113","020_119_113","PSA","119","113","113","A belengatngas tinedi dixo ruturun tinotno ru. Ketla labalak i tu mun Laulis Linga ram. ");
INSERT INTO mmx_vpl VALUES ("PS119_114","020_119_114","PSA","119","114","114","Nenu Lentupe la Lurutu See Pe rak, a nunu saga at levelinga ram. ");
INSERT INTO mmx_vpl VALUES ("PS119_115","020_119_115","PSA","119","115","115","Nemi luvuttadi loklok kakapmek, uto nimi basinge ia, nenia anaba mumu asu levempapaase ali at ne Moroa rak. ");
INSERT INTO mmx_vpl VALUES ("PS119_116","020_119_116","PSA","119","116","116","Nenu una lox alolos ia kerekngan laxakaape ram, kusu nenia aba rooro. La nemen uta ke xepe ia ketla una lox asepsu ia kerekngan lavavara rak. ");
INSERT INTO mmx_vpl VALUES ("PS119_117","020_119_117","PSA","119","117","117","Unam tebeng ia mi lukngam, kusu nia anoxo ekip tangarang mi lumumuat. La abam doma mumu amisik leventetere avolo ram. ");
INSERT INTO mmx_vpl VALUES ("PS119_118","020_119_118","PSA","119","118","118","Uk sok tixirixes nedi luvuttadi di ronga xepe leventetere avolo ram. Mo levendoxoma xaxarang atdi naba xet polo. ");
INSERT INTO mmx_vpl VALUES ("PS119_119","020_119_119","PSA","119","119","119","Nenu u ven limixin kapmek ngan laxanboobong, ketla labalak i tu lempapaase matmatkun taram. ");
INSERT INTO mmx_vpl VALUES ("PS119_120","020_119_120","PSA","119","120","120","Nenia a dede aleng atla a marat taram, la a lingun aleng mumu leventaangas taram. ");
INSERT INTO mmx_vpl VALUES ("PS119_121","020_119_121","PSA","119","121","121","Ara lok pam lempanga in manton la i nunuan, kuren la nemen uta ke avolo ia ri limixin munepen minia. ");
INSERT INTO mmx_vpl VALUES ("PS119_122","020_119_122","PSA","119","122","122","Una xaape ria, laradi gugu ram do, unaba lok tooro ia, la nemen uta ke xepe luvuttadi loklox aaru dina lox abaava ia. ");
INSERT INTO mmx_vpl VALUES ("PS119_123","020_119_123","PSA","119","123","123","Luxatli rak ira molo nga ri reven tangarang ti nom loklok tooro la kusu ti lox asepsu ia basinge di kerekngan ugara xaape vam min. ");
INSERT INTO mmx_vpl VALUES ("PS119_124","020_119_124","PSA","119","124","124","Una reven tatao ia, laradi gugu ram, kusu naba epovo rinotno mi labalamu lexen taram, la una anasa ia mi leventetere avolo ram. ");
INSERT INTO mmx_vpl VALUES ("PS119_125","020_119_125","PSA","119","125","125","Nenia laradi gugu ram. Una lox axasep lodoxoma rak, kusu aba xasep at lempapaase matmatkun taram. ");
INSERT INTO mmx_vpl VALUES ("PS119_126","020_119_126","PSA","119","126","126","Leeme Silok, limixin dirat los polo amisik pam Laulis Linga ram. Kuren la levenaleng ira vot pam, kusu una lox asongot di. ");
INSERT INTO mmx_vpl VALUES ("PS119_127","020_119_127","PSA","119","127","127","Labalak i tu aleng levempapaase ali ram i volo lavavara ri leven gol, la mo leven gol i nunuan aleng. ");
INSERT INTO mmx_vpl VALUES ("PS119_128","020_119_128","PSA","119","128","128","Kuren la ara mumu asu lempapaase auru ram. La ak sok sisixe leveloklox axap i lok kapmek. ");
INSERT INTO mmx_vpl VALUES ("PS119_129","020_119_129","PSA","119","129","129","Lempapaase matmatkun taram i lok nunuan aleng, kuren la nia arang tonga res mu i mi labalak axap. ");
INSERT INTO mmx_vpl VALUES ("PS119_130","020_119_130","PSA","119","130","130","Losoksoxomus at levelinga ram im taba ia mi laxasep, la im taba bok lakleklen avukat tinedi kopmen takleklen atdi. ");
INSERT INTO mmx_vpl VALUES ("PS119_131","020_119_131","PSA","119","131","131","La nia a belengaongao rinotno ri levempapaase ali ram. ");
INSERT INTO mmx_vpl VALUES ("PS119_132","020_119_132","PSA","119","132","132","Una repukus mu ia la una lox asuusu lebelen tuntun tia, kerekngan pam uk lox i rinedi axap di vavara aleng u. ");
INSERT INTO mmx_vpl VALUES ("PS119_133","020_119_133","PSA","119","133","133","Unam lam aratao ia at lavatpas tarak, kerekngan levelinga ram. Nemen uta ke xepe laxakapmek nak sak tup minia. ");
INSERT INTO mmx_vpl VALUES ("PS119_134","020_119_134","PSA","119","134","134","Una rebeng asu ia basinge levenmumuat at luvuttadi xapmek dim taba ia min, kusu nenia anabang tonga res at levempapaase auru ram. ");
INSERT INTO mmx_vpl VALUES ("PS119_135","020_119_135","PSA","119","135","135","Unak lox amisik eburu minia ngan loklox anarong tia, la una anasa ia mi leventetere avolo ram. ");
INSERT INTO mmx_vpl VALUES ("PS119_136","020_119_136","PSA","119","136","136","Lengkabili dan ing pengkos su aleng at lamarak, mila limixin dixong tonga res at Laulis Linga ram. ");
INSERT INTO mmx_vpl VALUES ("PS119_137","020_119_137","PSA","119","137","137","Leeme Silok, loklok taram in manton tino, la leventaangas bok taram ik mokso. ");
INSERT INTO mmx_vpl VALUES ("PS119_138","020_119_138","PSA","119","138","138","La mo lempapaase matmatkun uga li i, ik mokso la i epovo rinotno do nema manat mas saga ren. ");
INSERT INTO mmx_vpl VALUES ("PS119_139","020_119_139","PSA","119","139","139","Mo lebelemamao keneng tarak i lok ngan laxao, mila limixin munepen minia dik lox abulubun levelinga ram. ");
INSERT INTO mmx_vpl VALUES ("PS119_140","020_119_140","PSA","119","140","140","Mo leveng kakaape ram agara lok tong pen pam i, kuren la nenia a vara aleng i. ");
INSERT INTO mmx_vpl VALUES ("PS119_141","020_119_141","PSA","119","141","141","Nenia mun laradi gamasa la limixin di lele abulubun ia, ketla axo ke xepe ba levempapaase auru ram. ");
INSERT INTO mmx_vpl VALUES ("PS119_142","020_119_142","PSA","119","142","142","At levenaleng axap i tu melamgo loklok taram naba nemen manmanton tino, la Laulis Linga ram i ruturun amisik. ");
INSERT INTO mmx_vpl VALUES ("PS119_143","020_119_143","PSA","119","143","143","Levenmumuat mi lodoxoma saasaa mo ira ebosa mavana rak, ketla levempapaase ali ram ik lox amomo ia. ");
INSERT INTO mmx_vpl VALUES ("PS119_144","020_119_144","PSA","119","144","144","Mo lempapaase matmatkun taram ik mokso aleng tino. Una raba ia mi lodoxoma avukat kusu nia aba rooro. ");
INSERT INTO mmx_vpl VALUES ("PS119_145","020_119_145","PSA","119","145","145","O Leeme Silok, nia a ro ke ram mi labalak axap. Una ronga res tarak la anabang tonga res at leventetere avolo ram. ");
INSERT INTO mmx_vpl VALUES ("PS119_146","020_119_146","PSA","119","146","146","A ro ke ram kusu una lox asepsu ia basinge laniu. La nia anabam tebeng avarang at lempapaase matmatkun taram. ");
INSERT INTO mmx_vpl VALUES ("PS119_147","020_119_147","PSA","119","147","147","A aus kaxat no mene maxantamak suubu la ang teng tu xusu una lok tooro ia. Atla a nunu saga at levelinga ram. ");
INSERT INTO mmx_vpl VALUES ("PS119_148","020_119_148","PSA","119","148","148","A tuuang aan amisik at lengkanimin, kusu ana i doxoma mu leveng kakaape ram. ");
INSERT INTO mmx_vpl VALUES ("PS119_149","020_119_149","PSA","119","149","149","O Leeme Silok, labalamu ram i nemen lexen. Kuren la una ronga ia. Una lox asuusu lebelen tuntun taram la una lok tatao lorooro rak kerekngan levelinga ram. ");
INSERT INTO mmx_vpl VALUES ("PS119_150","020_119_150","PSA","119","150","150","Nedi mo dik lox asongot kapmex ia monga dit pas aurer ia, la dik lok paxalom tinotno basinge Laulis Linga ram. ");
INSERT INTO mmx_vpl VALUES ("PS119_151","020_119_151","PSA","119","151","151","Ketla nenu Leeme Silok uk lok auret mun ia, la nom axap levempapaase ali ram i ruturun amisik. ");
INSERT INTO mmx_vpl VALUES ("PS119_152","020_119_152","PSA","119","152","152","Ga ruka xa i gano, aga lox ase boro at lempapaase matmatkun taram, ua nenu uga vaxaxis i la naba nemen lexen. ");
INSERT INTO mmx_vpl VALUES ("PS119_153","020_119_153","PSA","119","153","153","Una ven mumu laxasongsongot tarak la una lox asepsu ia basinge i, mila xovisi toxonaleng go nia ara ke xepe vam Laulis Linga ram. ");
INSERT INTO mmx_vpl VALUES ("PS119_154","020_119_154","PSA","119","154","154","Una ru at lenep tarak la una lox asepmus ia. Una lok tatao lorooro rak kerekngan leveng kakaape ram. ");
INSERT INTO mmx_vpl VALUES ("PS119_155","020_119_155","PSA","119","155","155","Nenu u noxo lox asepsu limixin kapmek, mila dixo mumu asu leventetere avolo ram. ");
INSERT INTO mmx_vpl VALUES ("PS119_156","020_119_156","PSA","119","156","156","Leeme Silok, labalamu ram i silok aleng. Una lok tatao lorooro rak kerekngan leventaangas taram. ");
INSERT INTO mmx_vpl VALUES ("PS119_157","020_119_157","PSA","119","157","157","Buaang nedi limixin munepen dik lox asongor ia, ketla nia axo raba rulu ba lempapaase matmatkun taram. ");
INSERT INTO mmx_vpl VALUES ("PS119_158","020_119_158","PSA","119","158","158","A ven tinedi limixin tongtonga viribang, la a bele mumuat mila dixo mumu asu levelinga ram. ");
INSERT INTO mmx_vpl VALUES ("PS119_159","020_119_159","PSA","119","159","159","Leeme Silok. Pen ba ia, a vara aleng levempapaase auru ram. Una lok tatao lorooro rak mila nenu Laradi Balamu. ");
INSERT INTO mmx_vpl VALUES ("PS119_160","020_119_160","PSA","119","160","160","Levelinga axap taram i ruturun la nom axap leventaangas taram ik mokso la naba nemen amisik la kopmen tekavaxap teren. ");
INSERT INTO mmx_vpl VALUES ("PS119_161","020_119_161","PSA","119","161","161","Limixin silok dik lox asongot parang ia, la kopmen tavasuun teren. Ketla leveve rak it kat tava mu levelinga ram. ");
INSERT INTO mmx_vpl VALUES ("PS119_162","020_119_162","PSA","119","162","162","Levengkakaape ram ik lox amomo ia, kerekngan laradi i ruuna laplus i silok aleng. ");
INSERT INTO mmx_vpl VALUES ("PS119_163","020_119_163","PSA","119","163","163","A xopara rino laxaxarang axap la labalak i xapmek tin, ketla labalak i tu aleng Laulis Linga ram. ");
INSERT INTO mmx_vpl VALUES ("PS119_164","020_119_164","PSA","119","164","164","Keneng at leges aleng, a tong avukat tu i vanuti mumu leventaangas taram ik mokso. ");
INSERT INTO mmx_vpl VALUES ("PS119_165","020_119_165","PSA","119","165","165","Nedi di vavara aleng Laulis Linga ram, dinaba ruuna ka limila silok keneng at lorooro atdi la kopmen ba tavanga naba lox angtang nedi kusu dinak sak saaban. ");
INSERT INTO mmx_vpl VALUES ("PS119_166","020_119_166","PSA","119","166","166","Leeme Silok, a ngangais ti loklok tooro ram, la a mumu asu levempapaase ali ram. ");
INSERT INTO mmx_vpl VALUES ("PS119_167","020_119_167","PSA","119","167","167","Ang tonga res at lempapaase matmatkun taram, mila a vara aleng tinotno i. ");
INSERT INTO mmx_vpl VALUES ("PS119_168","020_119_168","PSA","119","168","168","Ang tonga res at levempapaase auru ram la nom lempapaase matmatkun bok taram, atla ukleklen axap leveloklok tarak. ");
INSERT INTO mmx_vpl VALUES ("PS119_169","020_119_169","PSA","119","169","169","Leeme Silok, una ronga lanteng tarak saparav u ri loklok tooro. Una lox asuusu lodoxoma aklen taram tia kerekngan laxakaape ram. ");
INSERT INTO mmx_vpl VALUES ("PS119_170","020_119_170","PSA","119","170","170","Una ronga res at lisingising tarak, la una lox asepsu ia kerekngan laxakaape ram. ");
INSERT INTO mmx_vpl VALUES ("PS119_171","020_119_171","PSA","119","171","171","Ana emi asu amisik minu, mila nenu u anasa ia mi leventetere avolo ram. ");
INSERT INTO mmx_vpl VALUES ("PS119_172","020_119_172","PSA","119","172","172","Anabak pixan mumu levelinga ram, mila levempapaase ali ram ik mokso. ");
INSERT INTO mmx_vpl VALUES ("PS119_173","020_119_173","PSA","119","173","173","Una gagas amisik ti lok tooro ia, mila nia a mumu asu levempapaase auru ram. ");
INSERT INTO mmx_vpl VALUES ("PS119_174","020_119_174","PSA","119","174","174","O Leeme Silok, labalak ing teng aleng ti loklok tooro ram. La Laulis Linga ram ik lox amomo ia. ");
INSERT INTO mmx_vpl VALUES ("PS119_175","020_119_175","PSA","119","175","175","Una lok tatao lorooro rak kusu aba emi asu minu. La una ke mo leventaangas taram na su auru ia. ");
INSERT INTO mmx_vpl VALUES ("PS119_176","020_119_176","PSA","119","176","176","Ara vas soronga nga ngan lisipsip i soronga. Una puse ria, laradi gugu ram, mila nia axok lox aie xepe levempapaase ali ram. ");
INSERT INTO mmx_vpl VALUES ("PS120_1","020_120_1","PSA","120","1","1","Nia aga ngising ti Leeme Silok keneng at levenmumuat tarak, la neni ga sep siam at lisingising tarak. ");
INSERT INTO mmx_vpl VALUES ("PS120_2","020_120_2","PSA","120","2","2","Leeme Silok, una lox asepsu ia basinge luvuttadi xaxarang la sosolo arup. ");
INSERT INTO mmx_vpl VALUES ("PS120_3","020_120_3","PSA","120","3","3","Nemi limixin kaxarang, lavanga salai mo ne Moroa naba lox i rinimi? La neni naba lox asongot nimi xereva? ");
INSERT INTO mmx_vpl VALUES ("PS120_4","020_120_4","PSA","120","4","4","Neni naba lox asongot nimi mi levesoso ing sengsen at luvuttadi esep la mi laxangkali kao iplivi aleng. ");
INSERT INTO mmx_vpl VALUES ("PS120_5","020_120_5","PSA","120","5","5","Axot kis avukat kantubu atnemi limixin kapmek. Nemi mi lok ngan limixin tongtonga viribang di nemen to Mesek la to Kedar. ");
INSERT INTO mmx_vpl VALUES ("PS120_6","020_120_6","PSA","120","6","6","A molo tik lok eburu minedi limixin ua dixo sisiam ka limila. ");
INSERT INTO mmx_vpl VALUES ("PS120_7","020_120_7","PSA","120","7","7","La do a paase rinedi mi limila, di vavara na vesep mun. ");
INSERT INTO mmx_vpl VALUES ("PS121_1","020_121_1","PSA","121","1","1","A milik aurut at lengkong kaana, la a lok keretna, “Loklok tooro ria naba laa meava?” ");
INSERT INTO mmx_vpl VALUES ("PS121_2","020_121_2","PSA","121","2","2","Loklok tooro naba suusu xusuk boro at Leeme Silok, neni ga rudum li laxalibet mi lavatkangka. ");
INSERT INTO mmx_vpl VALUES ("PS121_3","020_121_3","PSA","121","3","3","Neni noxo ke xepe ba u la una subu. Atla neni mo Lurutu See Pe ram kopmen na vunga. ");
INSERT INTO mmx_vpl VALUES ("PS121_4","020_121_4","PSA","121","4","4","Mo Lurutu See Pe at leme Israel neni xopmen na vunga xis kopla na vunga met. ");
INSERT INTO mmx_vpl VALUES ("PS121_5","020_121_5","PSA","121","5","5","Leeme Silok naba reven tatao u. Neni naba nemen saparav u kusu nak lok see ram. ");
INSERT INTO mmx_vpl VALUES ("PS121_6","020_121_6","PSA","121","6","6","Laxangking noxo sev asongot ba u at levenaleng kangking la lagaaling noxo sev asongor u at lengkanimin. ");
INSERT INTO mmx_vpl VALUES ("PS121_7","020_121_7","PSA","121","7","7","Leeme Silok axa nabak lox asepsu amisix u basinge levenaniu, la ni naba kubak pe u. ");
INSERT INTO mmx_vpl VALUES ("PS121_8","020_121_8","PSA","121","8","8","Ni nabak lok see ram at levempatpas taram at nai levenaleng la ap mo bok levenaleng axap i tu melamgo. ");
INSERT INTO mmx_vpl VALUES ("PS122_1","020_122_1","PSA","122","1","1","Aga momo aleng atla diga lok tia, “Uto dik at loogu at Leeme Silok.” ");
INSERT INTO mmx_vpl VALUES ("PS122_2","020_122_2","PSA","122","2","2","La ananga nedik tara vubeles pam at langas povolo la tara tu nga ro xeneng at lemenemen silok Jerusalem. ");
INSERT INTO mmx_vpl VALUES ("PS122_3","020_122_3","PSA","122","3","3","Diga vaxaru li amu na lemenemen ngan lemenemen silok la diga penbixa avukat tinotno i. ");
INSERT INTO mmx_vpl VALUES ("PS122_4","020_122_4","PSA","122","4","4","La nedi larabibinat me Israel dit pas pot de. Nedi dit pas kusu dina tong avukat ti Leeme Silok, kerekngan mo levempapaase ali Leeme Silok ga raba di min. ");
INSERT INTO mmx_vpl VALUES ("PS122_5","020_122_5","PSA","122","5","5","Nade lavaorong boro Israel digat kis at lengkonin orong atdi xusu dinang tonga linga at limixin. ");
INSERT INTO mmx_vpl VALUES ("PS122_6","020_122_6","PSA","122","6","6","Nemi mina sing kusu limila nak lok to lemenemen Jerusalem keretna, “Nedi di vavara aleng na lemenemen, dina ngasang kobot. ");
INSERT INTO mmx_vpl VALUES ("PS122_7","020_122_7","PSA","122","7","7","I epovo bok do limila nak lok keneng at na lemenemen la Leeme Silok na lok tatao avukat limixin keneng at laraogu silok atdi.” ");
INSERT INTO mmx_vpl VALUES ("PS122_8","020_122_8","PSA","122","8","8","Nia a lok lisingising mumu lemenemen Jerusalem keretna, “Limila nak lok keneng teren.” Ak lox i xerepmo kusu lentaba rak la larapentangas tarak dinaban tuuna lorooro nunuan. ");
INSERT INTO mmx_vpl VALUES ("PS122_9","020_122_9","PSA","122","9","9","Nia a sing bok Leeme Silok kusu nemi limixin mego mina sang kobot avukat atla loogu at Leeme Silok ne Moroa atdik ik lok go. ");
INSERT INTO mmx_vpl VALUES ("PS123_1","020_123_1","PSA","123","1","1","O Leeme Silok, a milik aurut tu, toxun pana at laxalibet at loxot nenu ut kis teren la um gomgonga limixin nade xopok. ");
INSERT INTO mmx_vpl VALUES ("PS123_2","020_123_2","PSA","123","2","2","O Leeme Silok, nenu ne Moroa atnama. Lavasaxaruki di nunu saga at lubung amgomgo atdi, la lavasaxaruki rixin di nunu saga at lavakin amgomgo atdi. La kerepmo bok nema manaba nunu saga amisik taram, se at loxonaleng una lox asuusu lebelen tuntun taram tinama. ");
INSERT INTO mmx_vpl VALUES ("PS123_3","020_123_3","PSA","123","3","3","O Leeme Silok, una lox asuusu lebelen tuntun tinema. Una lox asuusu lebelen tuntun tinema, mila mara baava nga na mi laxanmumuat dik lok li i mavana atnama. ");
INSERT INTO mmx_vpl VALUES ("PS123_4","020_123_4","PSA","123","4","4","Mara baava nga na mumu laxalinga sese limixin loklox aaru dik lox i rinama. La limixin apnovos bok di lele abulubun nama. ");
INSERT INTO mmx_vpl VALUES ("PS124_1","020_124_1","PSA","124","1","1","Mo do Leeme Silok gixo tu at lenep atdik, nedik limixin axap me Israel giba ekip tangarang mi lempanga salai? ");
INSERT INTO mmx_vpl VALUES ("PS124_2","020_124_2","PSA","124","2","2","Mo do Leeme Silok gixo tu at lenep atdik, limixin munepen midik giba esep tangarang midik. ");
INSERT INTO mmx_vpl VALUES ("PS124_3","020_124_3","PSA","124","3","3","La lebelemamao atdi giba lok kapmek aleng tidik, la nedi giba linge bintoo nedik ");
INSERT INTO mmx_vpl VALUES ("PS124_4","020_124_4","PSA","124","4","4","la di lok ngan ladanut giba vula pe nedik, la na vaxat ka nedik uto vetpes, ");
INSERT INTO mmx_vpl VALUES ("PS124_5","020_124_5","PSA","124","5","5","la nedi di lok bok ngan laraan silok gibak mir axong nedik. ");
INSERT INTO mmx_vpl VALUES ("PS124_6","020_124_6","PSA","124","6","6","Ata tong avukat ti Leeme Silok atla goxo ke kepe limixin munepen midik kusu dina sele utut dik. ");
INSERT INTO mmx_vpl VALUES ("PS124_7","020_124_7","PSA","124","7","7","Nedik tara sixiro vam kerekngan lapka i sixiro basinge lelixo, nai lelixo ira rexorop pam, la nedik na tara sepmus ta. ");
INSERT INTO mmx_vpl VALUES ("PS124_8","020_124_8","PSA","124","8","8","Loklok tooro atdik ip tavasu boro at Leeme Silok, neni ga rudum li laxalibet mi lavatbung menemen. ");
INSERT INTO mmx_vpl VALUES ("PS125_1","020_125_1","PSA","125","1","1","Nedi di nunu saga at Leeme Silok, di lok ngan Lakaana Saion ua ixo epovo do tara nakma asubu i, ketla naba tu atmatkun lexen tino. ");
INSERT INTO mmx_vpl VALUES ("PS125_2","020_125_2","PSA","125","2","2","Larakaana dit kis kangkan lemenemen Jerusalem, la kerepmo bok Leeme Silok nabang kan pe axap limixin teren monga la at levenaleng axap i tu melamgo. ");
INSERT INTO mmx_vpl VALUES ("PS125_3","020_125_3","PSA","125","3","3","Limixin kapmek di noxom gomgonga amisik lenep kangka atnedik limixin manmanton teren. Mo do dina lox i xuren, limixin manmanton bok giba vubeles at laxakapmek. ");
INSERT INTO mmx_vpl VALUES ("PS125_4","020_125_4","PSA","125","4","4","Leeme Silok, una lok lununuan tinedi dik lok nunuan, la tinedi bok ding tonga res at levempapaase ali ram. ");
INSERT INTO mmx_vpl VALUES ("PS125_5","020_125_5","PSA","125","5","5","Ketla una lox asongot nedi dit pas at leventaangas i xakauk, la una lox asongot nedi bok di sok tixirixes kepe leventaangas taram. Limila nak lok to Israel. ");
INSERT INTO mmx_vpl VALUES ("PS126_1","020_126_1","PSA","126","1","1","Gase Leeme Silok ga lam asu amlong nema limixin kokoxo uto Saion, maga nunua i do magam tobo mun. ");
INSERT INTO mmx_vpl VALUES ("PS126_2","020_126_2","PSA","126","2","2","Kuren la magang longon aleng mi leklek, la magak pixan momo aleng. La levenabung mixin petpes diga lok keretna, “Leeme Silok ga lox anarong solo vam nedi.” ");
INSERT INTO mmx_vpl VALUES ("PS126_3","020_126_3","PSA","126","3","3","I ruturun do Leeme Silok ga lok lempanga silok tinama, kuren la maga umsu mi lomomo. ");
INSERT INTO mmx_vpl VALUES ("PS126_4","020_126_4","PSA","126","4","4","Leeme Silok, una lox asang kobot amu manga nama kerekngan larakabu ik lox aumsu amu laradan to at lamatbin Negev. ");
INSERT INTO mmx_vpl VALUES ("PS126_5","020_126_5","PSA","126","5","5","Ma vara i xusu mana lok ngan mun nedi digat pas titlotlo la digang teng. Ketla uga lok tooro di kusu dinak lok momo at levenaleng dina sepkin. ");
INSERT INTO mmx_vpl VALUES ("PS126_6","020_126_6","PSA","126","6","6","Nedi digat pas la digap kip levennit piao titlotlo i la digang teng. Melemu diga laa boro at leventaamang la digak pixan momo mi lempanga anan atnedi. ");
INSERT INTO mmx_vpl VALUES ("PS127_1","020_127_1","PSA","127","1","1","Mo do Leeme Silok noxo vaxaru loogu, limixin kipkip gu di noxo lox adak toxot. La do Leeme Silok noxo lok see bok at temenemen silok, luvuttadi pereven tatao di noxo lox adak toxot. ");
INSERT INTO mmx_vpl VALUES ("PS127_2","020_127_2","PSA","127","2","2","Kopmen tavasuun teren kusu limixin dina gugu lolos to at leventaamang atdi at laxanaleng axap, tuka i at lenmaxantamak suubu la naba se ukantinao bungbung main, mila Leeme Silok nabam taba nedi mo neni i balamu di. La i gagas li i at lengkanimin, keke i do nedi mo di unga. ");
INSERT INTO mmx_vpl VALUES ("PS127_3","020_127_3","PSA","127","3","3","Laxamdak temes di lok ngan leventamtaba boro at Leeme Silok. Laxamdak mi laxaalik di lok ngan loklox anarong ti limixin. ");
INSERT INTO mmx_vpl VALUES ("PS127_4","020_127_4","PSA","127","4","4","Laxamdak temes at latlok maxat, di lok ngan levesoso ro at lekngen laasesep. ");
INSERT INTO mmx_vpl VALUES ("PS127_5","020_127_5","PSA","127","5","5","Luvukat ti mo laradi i visik buaang atdi. Limixin munepen min di noxo vas asi ba mo laradi mo do neni na ekip tangarang midi ro at loxot tongtonga linga. ");
INSERT INTO mmx_vpl VALUES ("PS128_1","020_128_1","PSA","128","1","1","Lomomo mo ik lok tinedi ding tonga res at Leeme Silok, la lavatpas atdi i mumu asu leventaangas teren. ");
INSERT INTO mmx_vpl VALUES ("PS128_2","020_128_2","PSA","128","2","2","Do nemi bok mina ronga res teren, mo lugugu atnimi naba lox asuusu lempanga ri lox epovo lavakpakes atnimi, la minabak lok momo la minaba ngasang kobot at lempanga axap. ");
INSERT INTO mmx_vpl VALUES ("PS128_3","020_128_3","PSA","128","3","3","La lavakin atnimi dinaba lok ngan loos vaen to xolonu ua i pisik aleng. Laxamdak mi laxaalik atnimi dinaba rooro avukat ngan larauna olip maxat to xeneng at levenang kolonu atnimi. ");
INSERT INTO mmx_vpl VALUES ("PS128_4","020_128_4","PSA","128","4","4","Do laradi nang tonga res at Leeme Silok, neni naba lok kaka ruturun leveloklox anarong kerepmo. ");
INSERT INTO mmx_vpl VALUES ("PS128_5","020_128_5","PSA","128","5","5","Naba lox avukat do Leeme Silok boro Saion, naba lox anarong nimi. Naba lox avukat bok do at levenaleng axap at lorooro atnimi minaba ven lemenemen Jerusalem na vosok. ");
INSERT INTO mmx_vpl VALUES ("PS128_6","020_128_6","PSA","128","6","6","La naba lox avukat bok do mi noxo met se minaba ven luvuttubuno nimi. Limila nak lok to Israel. ");
INSERT INTO mmx_vpl VALUES ("PS129_1","020_129_1","PSA","129","1","1","Limixin me Israel, mina tong asu mo levenngas ua limixin munepen minemi diga lox asongot nemi min, ga ruka i at lurutu kaxat at lubung mixin atnedik. ");
INSERT INTO mmx_vpl VALUES ("PS129_2","020_129_2","PSA","129","2","2","Ap mo levenmaares limixin munepen minema digak lox asongot kapmek tinotno nema, ketla di goxo epovo ri vas asi nema. ");
INSERT INTO mmx_vpl VALUES ("PS129_3","020_129_3","PSA","129","3","3","Ga lok ngan ta do diga tara lempat nin kooxing at leven antuno atnema, la gak milik ngan ta laxangka ding kin li i ritlotlo vanga anan. ");
INSERT INTO mmx_vpl VALUES ("PS129_4","020_129_4","PSA","129","4","4","Ketla Leeme Silok, ni Laradi Manmanton, gara lox asepmus pam nema basinge lasaksaxango at limixin munepen. ");
INSERT INTO mmx_vpl VALUES ("PS129_5","020_129_5","PSA","129","5","5","A vara Leeme Silok do, neni naba sep aoo nedi limixin ua di belengatngas ti limixin me Saion. ");
INSERT INTO mmx_vpl VALUES ("PS129_6","020_129_6","PSA","129","6","6","A vara i do dinaba lok ngan levempivilis i suu xat ro vana at lavatlak gu, ua naba mang soso mun. ");
INSERT INTO mmx_vpl VALUES ("PS129_7","020_129_7","PSA","129","7","7","La teta noxo dik kaka tempanga ren kopla nap kos eburu i la na xip kaka i uto at loogu ren. ");
INSERT INTO mmx_vpl VALUES ("PS129_8","020_129_8","PSA","129","8","8","La do tentaba na ekip tangarang midi ro at langa nedi noxo tong i ridi do, “Ma sing Leeme Silok kusu na lox anarong nimi. Ma lox anarong nimi mi laasen at Leeme Silok.” ");
INSERT INTO mmx_vpl VALUES ("PS130_1","020_130_1","PSA","130","1","1","I lok ngan ta do nenia at kis keneng tubu at lamain bonot, atla lodoxoma abulubun i suxuna ia, la a ro ke ram, Leeme Silok. ");
INSERT INTO mmx_vpl VALUES ("PS130_2","020_130_2","PSA","130","2","2","O Leeme Silok, una ronga lanteng tarak. Una ronga res at lorotoro rak la una lox asuusu lebelen tuntun taram tia. ");
INSERT INTO mmx_vpl VALUES ("PS130_3","020_130_3","PSA","130","3","3","Nege giba sixiro at loklox asongot taram mo do nenu gitak lok katling leveloklok kakapmek atnema? Kopmen tinotno tara giba sixiro. ");
INSERT INTO mmx_vpl VALUES ("PS130_4","020_130_4","PSA","130","4","4","Ketla u doxoma xepe laxapmek atnema limixin taram, kuren la ma pavanga u mi loklok ngangao. ");
INSERT INTO mmx_vpl VALUES ("PS130_5","020_130_5","PSA","130","5","5","Nia a xulubi aleng ti loklok tooro at Leeme Silok, la a nunu saga at levelinga ren. ");
INSERT INTO mmx_vpl VALUES ("PS130_6","020_130_6","PSA","130","6","6","A xulubi aleng ti loklok tooro at Leeme Silok, la axo lok ngan luvuttadi xukuxut di xulubi ri labara kooxot. Lavavara rak ti xulubi ri Leeme Silok i volo mo lavavara at luvuttadi xukuxut di ngangais ti labara kooxot. ");
INSERT INTO mmx_vpl VALUES ("PS130_7","020_130_7","PSA","130","7","7","Leme Israel, mina nunu saga at Leeme Silok atla, labalamu ren naba nemen lexen, la neni i vavara amisix i xusu nak lox asepsu limixin basinge leveloklok kakapmek. ");
INSERT INTO mmx_vpl VALUES ("PS130_8","020_130_8","PSA","130","8","8","Neni naba lox asepsu limixin teren me Israel basinge leveloklok kakapmek atnedi. ");
INSERT INTO mmx_vpl VALUES ("PS131_1","020_131_1","PSA","131","1","1","Leeme Silok, nenia xopmen laradi loklox aaso, la nia xopmen na vavanga xa ia. Axo doma mumu bok ba mo leveloklok ua i silok aleng tia. La nia xopmen na xasep avukat teren. ");
INSERT INTO mmx_vpl VALUES ("PS131_2","020_131_2","PSA","131","2","2","Ketla at kis atnaasan mi limila xeneng tarak. Ak lok ngan laxadede ik midi pilo ro at lukngen nenen, la no xeneng at labalak i xis saga. ");
INSERT INTO mmx_vpl VALUES ("PS131_3","020_131_3","PSA","131","3","3","Leme Israel, mina nunu saga at Leeme Silok, monga la amisik, kopmen tekavaxap teren! ");
INSERT INTO mmx_vpl VALUES ("PS132_1","020_132_1","PSA","132","1","1","Leeme Silok, nemen uta domampe ne Devit mumu mo levenmumuat neni ga vekini min. ");
INSERT INTO mmx_vpl VALUES ("PS132_2","020_132_2","PSA","132","2","2","Leeme Silok, una doxoma aklen ti mo laxakaape ren gara lok pam i ru. Nenu Lanaraavuk ne Moroa at ne Jakop. Devit ga lok keretna, ");
INSERT INTO mmx_vpl VALUES ("PS132_3","020_132_3","PSA","132","3","3","“Nia anoxo onon uto xolonu xopla ana midi ro at loora rak. ");
INSERT INTO mmx_vpl VALUES ("PS132_4","020_132_4","PSA","132","4","4","Anoxo lok mamana xopla ana unga, ");
INSERT INTO mmx_vpl VALUES ("PS132_5","020_132_5","PSA","132","5","5","naba se rinotno at loxonaleng anaba lok katling tenep kangka ri Leeme Silok ngan ta lang kolonu ri lok loogu ri Lanaraavuk ne Moroa at ne Jakop.” ");
INSERT INTO mmx_vpl VALUES ("PS132_6","020_132_6","PSA","132","6","6","Nema maga ronga levelinga ro Betilem mumu lobokis at lekabus la maga long lenget kaka i ro at laraamang gak lok saparap lemenemen Jaar. ");
INSERT INTO mmx_vpl VALUES ("PS132_7","020_132_7","PSA","132","7","7","La maga lok keretna, “Atat pas uto loogu at Leeme Silok, la ata lotu saparav i ro melamgo at loxonin orong teren.” ");
INSERT INTO mmx_vpl VALUES ("PS132_8","020_132_8","PSA","132","8","8","Leeme Silok, una beles eburu mi lobokis at lekabus uto xeneng at loogu laplavang, neni lampoovo at lolos taram. ");
INSERT INTO mmx_vpl VALUES ("PS132_9","020_132_9","PSA","132","9","9","A vara i do lavamaasa ram dina siga loklok in manton. La a vara i do limixin taram dinap kup mi lomomo! ");
INSERT INTO mmx_vpl VALUES ("PS132_10","020_132_10","PSA","132","10","10","Uga lok laxakaape ri lasaxaruki ram ne Devit. Kuren la Leeme Silok, uguta sok sisixe loorong soksoxolik taram. ");
INSERT INTO mmx_vpl VALUES ("PS132_11","020_132_11","PSA","132","11","11","Uga lok laxakaape lolos ti ne Devit la ni laxakaape ua u noxo lok ka amlong i, la i lok keretna, “Nenia anaba soxolik tara tamdak taram kusu naba ravasu ngan loorong, la naba rukun u rim gomgonga limixin tarak. ");
INSERT INTO mmx_vpl VALUES ("PS132_12","020_132_12","PSA","132","12","12","La mo do luvutnurum dina ruturun ti lekabus tarak, la ti levelinga nia anam taba di min, luvutnitna di bok dinaba tu kun u ngan lavaorong ap mo bok leven maares melemu.” ");
INSERT INTO mmx_vpl VALUES ("PS132_13","020_132_13","PSA","132","13","13","Leeme Silok ira soxolik ka vam lemenemen Saion. La i vara i xusu na lox i ngan langkolonu aulis teren, i lok keretna, ");
INSERT INTO mmx_vpl VALUES ("PS132_14","020_132_14","PSA","132","14","14","“Nia anaba nemen amisik ba ia de. La nia a vara i xusu anabat kis ngan Loorong Silok de at na loxot. ");
INSERT INTO mmx_vpl VALUES ("PS132_15","020_132_15","PSA","132","15","15","Anaba lox apnovos lemenemen Saion mi mo lempanga neni ik pakes tin. La anaba lox epovo lavakpakes at luvuttadi banbalo mego mi lempanga anan tidi. ");
INSERT INTO mmx_vpl VALUES ("PS132_16","020_132_16","PSA","132","16","16","Anaba lox anarong lavamaasa mego keneng at leven gugu axap nedi dinak lox i. La limixin dik lok keneng teren, dinabak pixan la dinabap kup mi lomomo. ");
INSERT INTO mmx_vpl VALUES ("PS132_17","020_132_17","PSA","132","17","17","Nade anaba soxolik kaka tara at livisik li at ne Devit go xeneng kusu nabat kis ngan loorong mi laasen silok teren. La anaba lok tatao avukat lixitkis orong at loorong soxolik tarak. ");
INSERT INTO mmx_vpl VALUES ("PS132_18","020_132_18","PSA","132","18","18","Anaba sak tup mi limixin munepen min kusu dina suma ka lainmangan. Ketla limixin at lixitkis orong teren dinaba ngasang kobot la dinap novos.” ");
INSERT INTO mmx_vpl VALUES ("PS133_1","020_133_1","PSA","133","1","1","I milik maraanu la i nunuan aleng at loxonaleng limixin at ne Moroa di nemen buru xeneng at lenmila oon. ");
INSERT INTO mmx_vpl VALUES ("PS133_2","020_133_2","PSA","133","2","2","I nunuan ngan ta loxodan momonok maraanu gano diga lox anarong lamaasa ne Aron min. Diga soli asu mo loxodan to mavana at lavatlak teren la mo loxodan ga sesen su boro at laraes teren, la ga sesen si uto at laxaka at lavanga singsiga ren. ");
INSERT INTO mmx_vpl VALUES ("PS133_3","020_133_3","PSA","133","3","3","I lox avukat ngan bok ledemi boro at lakaana Eremon it pot at lengkong kaana lixilik to Saion. La ap mo loxot ne Moroa ga xaape kusu naba lox anarong limixin mi lorooro lexen. ");
INSERT INTO mmx_vpl VALUES ("PS134_1","020_134_1","PSA","134","1","1","Nemi axap lavaanat saxaruki at Leeme Silok, ude nimi la mina emi asu min. Nemi ua mi gugu ro xeneng at loogu laplavang at lengkanimin, mina emi asu min. ");
INSERT INTO mmx_vpl VALUES ("PS134_2","020_134_2","PSA","134","2","2","Mina xip aurut kikngen keneng at lisingising to xeneng at loogu laplavang, la mina emi asu mi Leeme Silok. ");
INSERT INTO mmx_vpl VALUES ("PS134_3","020_134_3","PSA","134","3","3","A sing Leeme Silok i nemen de Saion la ga rudum li laxalibet mi lavatbung menemen naba lox anarong nemi! ");
INSERT INTO mmx_vpl VALUES ("PS135_1","020_135_1","PSA","135","1","1","Leemi asu ri Leeme Silok. Nemi lavasaxaruki at Leeme Silok, mina emi asu mi laasen teren. ");
INSERT INTO mmx_vpl VALUES ("PS135_2","020_135_2","PSA","135","2","2","La nemi bok mo mi gugu ro at loogu laplavang at Leeme Silok, ni loogu at ne Moroa atnedik, mina emi asu mi laasen teren. ");
INSERT INTO mmx_vpl VALUES ("PS135_3","020_135_3","PSA","135","3","3","Mina emi asu mi Leeme Silok atla neni i vukat. Minak pixan emi asu ri laasen teren, atla mo loklok i nunuan aleng. ");
INSERT INTO mmx_vpl VALUES ("PS135_4","020_135_4","PSA","135","4","4","Neni ga soxolik kaka limixin at ne Jakop kusu tin. Neni ga soxolik ka limixin me Israel kusu ateren akmokso. ");
INSERT INTO mmx_vpl VALUES ("PS135_5","020_135_5","PSA","135","5","5","Aklen i do Leeme Silok atnedik i nunuan aleng pologat, la i silok polo mo leven moroa vetpes. ");
INSERT INTO mmx_vpl VALUES ("PS135_6","020_135_6","PSA","135","6","6","Neni i epovo na lok lempanga salai neni i vara i to vana at laxalibet, la de at lavatbung menemen, to xeneng at laras la to xopok tubu at lisimaramain. ");
INSERT INTO mmx_vpl VALUES ("PS135_7","020_135_7","PSA","135","7","7","Neni ik lox asuusu lamanman takabu boro axa at latnese at lavatbung menemen. La ik lok lavanga i mam su boro at lamanman takabu, la i susuang asu lamanman boro at loogu lili ren. ");
INSERT INTO mmx_vpl VALUES ("PS135_8","020_135_8","PSA","135","8","8","Neni ga sev amet laxamdak temes avot at limixin me Isip, la lempanga bok mi lavanuet kangkedek atdi. ");
INSERT INTO mmx_vpl VALUES ("PS135_9","020_135_9","PSA","135","9","9","Neni ga lox asuusu bok lempanga lolos la sangsangu xusu ti lox asongot loorong eburu mi luvuttadi silok ua diga gugu maxopok teren. ");
INSERT INTO mmx_vpl VALUES ("PS135_10","020_135_10","PSA","135","10","10","Neni ga sele utut buaang levenabung mixin, la ga sev amet lavaorong lolos. ");
INSERT INTO mmx_vpl VALUES ("PS135_11","020_135_11","PSA","135","11","11","Nedi ne Sion loorong at leme Amor, Ok loorong at leme Basan, la nedi lavaorong axap me Kanan. ");
INSERT INTO mmx_vpl VALUES ("PS135_12","020_135_12","PSA","135","12","12","Neni ga lok ka levennep kangka atnedi na lavaorong la ga raba limixin teren min. Neni ga raba leme Israel min. ");
INSERT INTO mmx_vpl VALUES ("PS135_13","020_135_13","PSA","135","13","13","Leeme Silok, limixin dinaba tong asuusu amisix i do nenu ne Moroa. La lavaola axap melemu dinabam domasu ram. ");
INSERT INTO mmx_vpl VALUES ("PS135_14","020_135_14","PSA","135","14","14","Leeme Silok naba tupe limixin teren. Neni naba lox asuusu lebelen tuntun ti lavaanat soxolik teren. ");
INSERT INTO mmx_vpl VALUES ("PS135_15","020_135_15","PSA","135","15","15","Limixin boro at levenabung mixin petpes dik lok levenmoroa atdi mi la siliva la gol. Luvuttadi mun mede xopok di vop di mi leventingen di. ");
INSERT INTO mmx_vpl VALUES ("PS135_16","020_135_16","PSA","135","16","16","Di ruuna leven ngusno ketla dixo epovo ri paase. La levengkatli bok mo, ketla dixo epovo ri reven. ");
INSERT INTO mmx_vpl VALUES ("PS135_17","020_135_17","PSA","135","17","17","Levenbaalung mo atdi, ketla dixo epovo ring tonga. La dixo epovo rinotno bok tik lok ka lamamas. ");
INSERT INTO mmx_vpl VALUES ("PS135_18","020_135_18","PSA","135","18","18","A vara i do mo luvuttadi diga vop mo lempoovo vanga la dira nunu saga atdi, dinaba vee voovo vanga ngan mo lentaba diga vop di! ");
INSERT INTO mmx_vpl VALUES ("PS135_19","020_135_19","PSA","135","19","19","Limixin me Israel, mina emi asu mi Leeme Silok. Nemi lavamaasa at ne Moroa, mina emi asu min. ");
INSERT INTO mmx_vpl VALUES ("PS135_20","020_135_20","PSA","135","20","20","Nemi lubung mixin me Levi, mina emi asu mi Leeme Silok, la nemi axap mo mi lotu saparav i, mina emi asu min. ");
INSERT INTO mmx_vpl VALUES ("PS135_21","020_135_21","PSA","135","21","21","Mina emi asu mi Leeme Silok to xeneng Saion, neni ik lok to xeneng at langkolonu aulis teren Jerusalem. Leemi asu ri Leeme Silok! ");
INSERT INTO mmx_vpl VALUES ("PS136_1","020_136_1","PSA","136","1","1","Ata tong avukat ti Leeme Silok, atla neni i lox avukat; kopmen tekavaxap at labalamu ren. ");
INSERT INTO mmx_vpl VALUES ("PS136_2","020_136_2","PSA","136","2","2","Ata tong avukat ti ne Moroa mo i silok ti leven moroa axap; kopmen tekavaxap at labalamu ren. ");
INSERT INTO mmx_vpl VALUES ("PS136_3","020_136_3","PSA","136","3","3","Ata tong avukat ti Lanaraavuk i lolos silok polo nedi lavaeme silok axap; kopmen tekavaxap at labalamu ren. ");
INSERT INTO mmx_vpl VALUES ("PS136_4","020_136_4","PSA","136","4","4","Neni xusuk mun ik lok lempanga sangsangu i silok aleng; kopmen tekavaxap at labalamu ren. ");
INSERT INTO mmx_vpl VALUES ("PS136_5","020_136_5","PSA","136","5","5","Neni ga rudum li laxalibet mi mo lakleklen teren; kopmen tekavaxap at labalamu ren. ");
INSERT INTO mmx_vpl VALUES ("PS136_6","020_136_6","PSA","136","6","6","Neni ga vaxaxis li laxangka to mavana at laras; kopmen tekavaxap at labalamu ren. ");
INSERT INTO mmx_vpl VALUES ("PS136_7","020_136_7","PSA","136","7","7","Neni ga rudum laxangking mi lagaaling; kopmen tekavaxap at labalamu ren. ");
INSERT INTO mmx_vpl VALUES ("PS136_8","020_136_8","PSA","136","8","8","La mo laxangking ti lok tatao levenaleng kangking; kopmen tekavaxap at labalamu ren. ");
INSERT INTO mmx_vpl VALUES ("PS136_9","020_136_9","PSA","136","9","9","La lagaaling mi laxam penti rik lok tatao levenaleng kanimin; kopmen tekavaxap at labalamu ren. ");
INSERT INTO mmx_vpl VALUES ("PS136_10","020_136_10","PSA","136","10","10","Neni ga sev amet laxamdak temes avot at leme Isip; kopmen tekavaxap at labalamu ren. ");
INSERT INTO mmx_vpl VALUES ("PS136_11","020_136_11","PSA","136","11","11","Neni ga lam asu limixin me Israel basinge lenep silok Isip; kopmen tekavaxap at labalamu ren. ");
INSERT INTO mmx_vpl VALUES ("PS136_12","020_136_12","PSA","136","12","12","Neni ga lox i mo mi lolos silok teren atla lekngen i lolos aleng; kopmen tekavaxap at labalamu ren. ");
INSERT INTO mmx_vpl VALUES ("PS136_13","020_136_13","PSA","136","13","13","Neni ga lok langas to xantubu at loxontas memele; kopmen tekavaxap at labalamu ren. ");
INSERT INTO mmx_vpl VALUES ("PS136_14","020_136_14","PSA","136","14","14","Neni ga lam avolo limixin teren go xantubu at laras; kopmen tekavaxap at labalamu ren. ");
INSERT INTO mmx_vpl VALUES ("PS136_15","020_136_15","PSA","136","15","15","Ketla ni gak mit axong loorong mi luvuttadi esep me Isip; kopmen tekavaxap at labalamu ren. ");
INSERT INTO mmx_vpl VALUES ("PS136_16","020_136_16","PSA","136","16","16","Neni ga lam avolo limixin teren to at lamatbin; kopmen tekavaxap at labalamu ren. ");
INSERT INTO mmx_vpl VALUES ("PS136_17","020_136_17","PSA","136","17","17","Neni ga sev amet lavaorong mi levenasen silok atdi; kopmen tekavaxap at labalamu ren. ");
INSERT INTO mmx_vpl VALUES ("PS136_18","020_136_18","PSA","136","18","18","Neni ga sev amet bok mo lavaorong mi levenasen silok; kopmen tekavaxap at labalamu ren. ");
INSERT INTO mmx_vpl VALUES ("PS136_19","020_136_19","PSA","136","19","19","Sion loorong at leme Amor ga met at lekngen Leeme Silok; kopmen tekavaxap at labalamu ren. ");
INSERT INTO mmx_vpl VALUES ("PS136_20","020_136_20","PSA","136","20","20","Ok loorong me Basan ga met at lekngen Leeme Silok; kopmen tekavaxap at labalamu ren. ");
INSERT INTO mmx_vpl VALUES ("PS136_21","020_136_21","PSA","136","21","21","Neni ga raba limixin akmokso ren mi levennep kangka atnedi na lavaorong; kopmen tekavaxap at labalamu ren. ");
INSERT INTO mmx_vpl VALUES ("PS136_22","020_136_22","PSA","136","22","22","Neni ga raba levennep kangka ri limixin me Israel, nedi lavaanat saxaruki ren; kopmen tekavaxap at labalamu ren. ");
INSERT INTO mmx_vpl VALUES ("PS136_23","020_136_23","PSA","136","23","23","Neni goxo domampe nedik at levenaleng limixin munepen diga sak tup midik; kopmen tekavaxap at labalamu ren. ");
INSERT INTO mmx_vpl VALUES ("PS136_24","020_136_24","PSA","136","24","24","Neni ga lox asepmus dik basinge limixin munepen minama; kopmen tekavaxap at labalamu ren. ");
INSERT INTO mmx_vpl VALUES ("PS136_25","020_136_25","PSA","136","25","25","Im taba luxa lempanga axap di rooro; kopmen tekavaxap at labalamu ren. ");
INSERT INTO mmx_vpl VALUES ("PS136_26","020_136_26","PSA","136","26","26","Ata tong avukat amisik ti ne Moroa boro vana at laxalibet; kopmen tekavaxap at labalamu ren. ");
INSERT INTO mmx_vpl VALUES ("PS137_1","020_137_1","PSA","137","1","1","Nema magat kis saparap levendan sen to Babilon. La maga duudu go at loxonaleng magam doma lemenemen Saion. ");
INSERT INTO mmx_vpl VALUES ("PS137_2","020_137_2","PSA","137","2","2","La magak paxa suke lempat taaleng atnema ro at levenuna vilou (willow) mo ga tu auret laradan sen. ");
INSERT INTO mmx_vpl VALUES ("PS137_3","020_137_3","PSA","137","3","3","Nedi mo diga vaxat kaka nema, diga tong i rinema do manak pixan. Diga tong i rinema do manak pixan kusu tik lox amomo nedi. Digak lok keretna, “Minak pixan tinema mi toxompixan mumu lemenemen Saion.” ");
INSERT INTO mmx_vpl VALUES ("PS137_4","020_137_4","PSA","137","4","4","Ga lolos aleng tinama xusu mana vixan toxompixan ti Leeme Silok nade at na lenep at limixin petpes. ");
INSERT INTO mmx_vpl VALUES ("PS137_5","020_137_5","PSA","137","5","5","Do ana domampe lemenemen aulis tarak Jerusalem, ba lox avukat anoxo epovo xusu ana sak bok ba ligita rak mo! ");
INSERT INTO mmx_vpl VALUES ("PS137_6","020_137_6","PSA","137","6","6","Do ana domampe lemenemen Jerusalem la anoxo doma bok ba i ngan neni lavanga loklox amomo rinotno rak, ba lox avukat do anoxo epovo xusu ana vixan bok ba. ");
INSERT INTO mmx_vpl VALUES ("PS137_7","020_137_7","PSA","137","7","7","Leeme Silok, una vorang mo levelinga xapmek leme Edom diga lox i gano. Ap mo laaleng leme Babilon diga sele utut lemenemen Jerusalem la digara vaxat kaka nema. Una vorang mo levelinga atnedi leme Edom diga tong amisik i do, “Mina sele utut asi Jerusalem ukopok at laxangka!” ");
INSERT INTO mmx_vpl VALUES ("PS137_8","020_137_8","PSA","137","8","8","Nemi leme Babilon. Melemu limixin esep dinaba sele utut lemenemen silok Babilon mumu mo loklok kakapmek miga lox i rinema. La mo limixin ua dinaba vorang mo loklok ti leme Babilon, lomomo ridi. ");
INSERT INTO mmx_vpl VALUES ("PS137_9","020_137_9","PSA","137","9","9","La dinaba lok kaka levengkadede atnemi leme Babilon la na saava amdamda di ro at lavaruat. ");
INSERT INTO mmx_vpl VALUES ("PS138_1","020_138_1","PSA","138","1","1","Nenia a tong avukat tu Leeme Silok mi labalak axap tarak. A vixan emi asu ru ro melamgo at leven moroa axap. ");
INSERT INTO mmx_vpl VALUES ("PS138_2","020_138_2","PSA","138","2","2","A ru gili ri loogu laplavang taram i xaala. La a rikbu emi asu mi laasen taram mumu labalamu lexen la loklok tuturun taram tia. La a emi asu minu atla uga lox asuusu i do laasen taram i silok pologat la levelinga ram i silok aleng la duk lok mavana at lempanga axap at na lavatbung menemen. ");
INSERT INTO mmx_vpl VALUES ("PS138_3","020_138_3","PSA","138","3","3","Uga ronga res tarak at loxonaleng aga ro ke ram, la uga lox alolos ia mi lolos taram. ");
INSERT INTO mmx_vpl VALUES ("PS138_4","020_138_4","PSA","138","4","4","Leeme Silok, lavaorong axap at lavatbung menemen dinaba emi asu minu, atla digara ronga vam leveng kakaape ram. ");
INSERT INTO mmx_vpl VALUES ("PS138_5","020_138_5","PSA","138","5","5","Dinabak pixan mumu lempanga ugara lok pam i la mumu laasen silok taram. ");
INSERT INTO mmx_vpl VALUES ("PS138_6","020_138_6","PSA","138","6","6","Keke i do nenu u silok polo lempanga axap, ketla uk lok tatao luvuttadi gamasa de xopok. Ketla limixin loklox aaso nenu u nemen paxalom basinge di. ");
INSERT INTO mmx_vpl VALUES ("PS138_7","020_138_7","PSA","138","7","7","At levenaleng levenmumuat i tu kangkan ia, nenu uk lok tatao lorooro rak. Nenu up sep tangarang limixin munepen minia, di belemamao ia, la uk lox asepsu ia mi lolos taram. ");
INSERT INTO mmx_vpl VALUES ("PS138_8","020_138_8","PSA","138","8","8","Nenu naba lox epovo lempanga uga xaape min tia. Leeme Silok, labalamu ram naba nemen lexen. Una lox epovo axap ta mo lugugu ua ugara vaxaru kaxat pam i. ");
INSERT INTO mmx_vpl VALUES ("PS139_1","020_139_1","PSA","139","1","1","Leeme Silok, ugara ila mumu avukat pam ia, kuren la uklen avukat tinotno ia. ");
INSERT INTO mmx_vpl VALUES ("PS139_2","020_139_2","PSA","139","2","2","Ukleklen axap mo lempanga nia ak lox i. Uk lok paxalom tino, ketla ukleklen axap levendoxoma rak. ");
INSERT INTO mmx_vpl VALUES ("PS139_3","020_139_3","PSA","139","3","3","U reven ia at levenaleng nia a gugu xopla ak lok mamana. Nenu uklen axap leveloklok tarak. ");
INSERT INTO mmx_vpl VALUES ("PS139_4","020_139_4","PSA","139","4","4","Keke i do a xovisi ana vaase, uraklen pam levelinga salai anaba vaase i. ");
INSERT INTO mmx_vpl VALUES ("PS139_5","020_139_5","PSA","139","5","5","U turu too rak at lengkot axap. La u reven aratao ia mi lolos silok taram. ");
INSERT INTO mmx_vpl VALUES ("PS139_6","020_139_6","PSA","139","6","6","Lakleklen taram tia i si aleng. La mo lakleklen taram mumu ia, a sangu aleng teren. ");
INSERT INTO mmx_vpl VALUES ("PS139_7","020_139_7","PSA","139","7","7","Anaba sixiro ua basinge u? Anaba vas taba ia ua basinge levereven taram? ");
INSERT INTO mmx_vpl VALUES ("PS139_8","020_139_8","PSA","139","8","8","Mo do anat pas uto vana at laxalibet, nenu uk lok go. La do ana midi ro at lemenemen at labarongan, nenu uk lok go. ");
INSERT INTO mmx_vpl VALUES ("PS139_9","020_139_9","PSA","139","9","9","La mo do ana rava kaxat uto at lenep, laxangking i losu ve xopla anak lok to vaxalom at lenep laxangking i lotup e, ");
INSERT INTO mmx_vpl VALUES ("PS139_10","020_139_10","PSA","139","10","10","nenu mo unabak lok go xusu tim gomgonga ia la unaba nemen go rik lok tooro ia. ");
INSERT INTO mmx_vpl VALUES ("PS139_11","020_139_11","PSA","139","11","11","Mo do nia giba epovo ri tong i ri lamain kusu na lipe ia, kopla laxasep mo ik lok kangkan ia na repukus ngan laxanimin, nenu naba epovo na ven ia. ");
INSERT INTO mmx_vpl VALUES ("PS139_12","020_139_12","PSA","139","12","12","Ketla lamain bok kopmen na lok ngan lamain at levereven taram, la laxanimin i kasep ngan ta laaleng kangking. Lamain eburu mi laxasep, nedu du epovo mun at levereven taram. ");
INSERT INTO mmx_vpl VALUES ("PS139_13","020_139_13","PSA","139","13","13","Uga rudum lengkot axap at labantuxu rak. Uga vop etang ia ro xeneng at latnenat at ne naga. ");
INSERT INTO mmx_vpl VALUES ("PS139_14","020_139_14","PSA","139","14","14","A emi asu minu atla nenu uk lok lempanga sangsangu. Leven gugu ram i lok petpes la i nunuan aleng. Akleklen tino i mi lodoxoma axap tarak. ");
INSERT INTO mmx_vpl VALUES ("PS139_15","020_139_15","PSA","139","15","15","At levenaleng levesi rak ga taut etang avukat tinotno ro xeneng at latnenat at ne naga. La ap mo levenaleng nia aga sisilok nemnem go xeneng, nenu ugaraklen pam i do nenia mo agak lok, ");
INSERT INTO mmx_vpl VALUES ("PS139_16","020_139_16","PSA","139","16","16","la uga reven ia avot ti laaleng ne naga ga visix ia. Leexes at levenaleng at lorooro rak uga rivit li i ria, ugara malagan li xatling pam i at lubuk taram, avot ti mo levenaleng nat pot saparav ia. ");
INSERT INTO mmx_vpl VALUES ("PS139_17","020_139_17","PSA","139","17","17","O Moroa, i lolos aleng tia xusu ana xasep at leven doxoma ram. La lavanisa axap mo levendoxoma ram ik lok! ");
INSERT INTO mmx_vpl VALUES ("PS139_18","020_139_18","PSA","139","18","18","La amo do ana us mo levendoxoma ram, diba buaang polo laxanit kangkaneng. At loxonaleng nia a rakdu tuang, nenu move uk lok buru minia. ");
INSERT INTO mmx_vpl VALUES ("PS139_19","020_139_19","PSA","139","19","19","O Moroa, a vara i do una sev amet luvuttadi sepsev amet tadi! A vara i do luvuttadi sepsev amet dinaba ke xepe mulus ia! ");
INSERT INTO mmx_vpl VALUES ("PS139_20","020_139_20","PSA","139","20","20","Di paase leveloklok kakapmek mumu u. La di paase asu loklok bilinga rik lok kapmek laasen taram. ");
INSERT INTO mmx_vpl VALUES ("PS139_21","020_139_21","PSA","139","21","21","O Leeme Silok, a belengatngas tino rinedi mo di belengatngas tu! A rexes tinotno nedi ua ding tonga viribang u! ");
INSERT INTO mmx_vpl VALUES ("PS139_22","020_139_22","PSA","139","22","22","A belengatngas tinedi mi langsangan lebelemamao. A tong di do limixin munepen minia. ");
INSERT INTO mmx_vpl VALUES ("PS139_23","020_139_23","PSA","139","23","23","O Moroa, una ila mumu ia la unaklen labalak. Una lok tong pen ia, la unaba long terek ka leven doxoma rak. ");
INSERT INTO mmx_vpl VALUES ("PS139_24","020_139_24","PSA","139","24","24","Una ila mumu ia do teveloklok kakapmek tarak, la unam gomgonga amisix ia at langas at lorooro avolo. ");
INSERT INTO mmx_vpl VALUES ("PS140_1","020_140_1","PSA","140","1","1","Leeme Silok, una lox asepsu ia basinge limixin kapmek. Una lok tatao avukar ia basinge limixin sepsep. ");
INSERT INTO mmx_vpl VALUES ("PS140_2","020_140_2","PSA","140","2","2","Nedi di rivit li nemnem amisik leveloklok kakapmek, la dik paxaru kaxat amisik leegang. ");
INSERT INTO mmx_vpl VALUES ("PS140_3","020_140_3","PSA","140","3","3","Lorooro atdi i umsu mi laxakapmek ngan lempatmaaut. Leven gam atdi ik lok ngan lempat sii angkang la levelinga atdi ik lok ngan lasak at lavatmoora. ");
INSERT INTO mmx_vpl VALUES ("PS140_4","020_140_4","PSA","140","4","4","Leeme Silok, una lok see rak basinge lolos at limixin kapmek. Una lok tatao ia basinge limixin sepsep ua digam nem mu ia xusu dina sev asubu ia. ");
INSERT INTO mmx_vpl VALUES ("PS140_5","020_140_5","PSA","140","5","5","Limixin loklox aaso dira li vam lelixo ria, dira saga vam lengkutkut atdi, la dira li laxam pelixo ro at langas kusu ti lixo xaka ia. ");
INSERT INTO mmx_vpl VALUES ("PS140_6","020_140_6","PSA","140","6","6","Na a vaase ru Leeme Silok keretna, “Nenu ne Moroa rak.” Leeme Silok, una ronga lerengteng tarak kusu ti loklok tooro ram! ");
INSERT INTO mmx_vpl VALUES ("PS140_7","020_140_7","PSA","140","7","7","Leeme Silok, nenu Loorong Avolo, la nenu Lentupe lolos tia. Ugarak lok see rak keneng at leven esep. ");
INSERT INTO mmx_vpl VALUES ("PS140_8","020_140_8","PSA","140","8","8","Leeme Silok, nemen gat utam taba nedi limixin kapmek mi mo lempanga ua nedi di vavara rin. La nemen uta ke avolo mo leven doxoma nemnem atnedi xusu na soorun. ");
INSERT INTO mmx_vpl VALUES ("PS140_9","020_140_9","PSA","140","9","9","Uguta ke mo limixin munepen minia dinak sak tup minia. Ketla una see antan mo loklok dik lox i ria, nabamlong mu di. ");
INSERT INTO mmx_vpl VALUES ("PS140_10","020_140_10","PSA","140","10","10","A vara i do una lox asu laxali kao bokbolot na subu mavana atdi. La una lu arup midi ro xeneng at lemeroon kusu dinoxo eng su bok ba. ");
INSERT INTO mmx_vpl VALUES ("PS140_11","020_140_11","PSA","140","11","11","A vara i do nedi mo dik sok taba lentaba vetpes mi levelinga xaxarang, di noxo lox epovo tekot. La a vara i do laxapmek na suxuna limixin sepsep, la na lok kapmek tino di. ");
INSERT INTO mmx_vpl VALUES ("PS140_12","020_140_12","PSA","140","12","12","Leeme Silok, aklen i do nenu u tu see at limixin banbalo, la u tu at lenep atnedi dik pakes. ");
INSERT INTO mmx_vpl VALUES ("PS140_13","020_140_13","PSA","140","13","13","I ruturun tinotno do limixin manmanton dinaba emi asu minu, la dinaba nemen maxopok at loklok tatao ram. ");
INSERT INTO mmx_vpl VALUES ("PS141_1","020_141_1","PSA","141","1","1","Leeme Silok, a ro ke ram at na loxonaleng. Soso mun una lok tooro nga ia! Una ronga ia at loxonaleng a ro ke ram. ");
INSERT INTO mmx_vpl VALUES ("PS141_2","020_141_2","PSA","141","2","2","Una siam ka lisingising tarak ngan ta lusuxa i so mavak, la una siam ka lukngak angosong aurut min naba lok ngan ta laramtaba ru ukantinao. ");
INSERT INTO mmx_vpl VALUES ("PS141_3","020_141_3","PSA","141","3","3","Leeme Silok, una lok li taradi rutu mu ram nade at lungusno rak, la naba reven tatao bok levelinga rak. ");
INSERT INTO mmx_vpl VALUES ("PS141_4","020_141_4","PSA","141","4","4","Una beng ia basinge lavavara rik lok laxapmek, la basinge lixitkis etangas eburu mi luvuttadi loklok kakapmek. Axopara i do ana anan eburu midi at lara peluxa atdi atla mo leveluxa atdi naba lox abilinga ia. ");
INSERT INTO mmx_vpl VALUES ("PS141_5","020_141_5","PSA","141","5","5","I lox avukat do laradi nunuan na vaase sox ia mumu laxakapmek kopla na sep aleeng ia. Ketla anoxo siam kaka lasinorong at luvuttadi xapmek. A ngising amisik kusu di noxo lok bok ba leveloklok kakapmek. ");
INSERT INTO mmx_vpl VALUES ("PS141_6","020_141_6","PSA","141","6","6","La amo do dina so gingin suu mi lubung amgomgo atnedi boro vana at labarabaras buang uat, limixin diba tong asu ba i dola lavapaase aronga rak ga ruturun. ");
INSERT INTO mmx_vpl VALUES ("PS141_7","020_141_7","PSA","141","7","7","Naba ngan loxonuna di vagam i, la dira ra koxorop axakalix i. Kerepmo laxan si atdi bak midi ekarakat go at lisigege at lamaaut. ");
INSERT INTO mmx_vpl VALUES ("PS141_8","020_141_8","PSA","141","8","8","Ketla nia move a nunu saga ram, Leeme Silok, Loorong Avolo rak. A vara i do unak lok see rak, la uguta ke xepe ia ana met! ");
INSERT INTO mmx_vpl VALUES ("PS141_9","020_141_9","PSA","141","9","9","Una lox asepsu ia basinge laxampelixo mo di lili pe ia min, la basinge mo lempanga kutkut at luvuttadi xapmek. ");
INSERT INTO mmx_vpl VALUES ("PS141_10","020_141_10","PSA","141","10","10","A vara i do limixin kapmek dinaba oon tubun axa at lara pelixo atdi kusu nia nabat pas sepsu la anoxo ruuna ka taniu. ");
INSERT INTO mmx_vpl VALUES ("PS142_1","020_142_1","PSA","142","1","1","Nenia a ro ke at Leeme Silok ti loklok tooro ren, la a sing lolos tinotno i. ");
INSERT INTO mmx_vpl VALUES ("PS142_2","020_142_2","PSA","142","2","2","A tong taba i mi levenmumuat tarak. La a tong axasep axav i mi lempanga lolos keneng at lorooro rak. ");
INSERT INTO mmx_vpl VALUES ("PS142_3","020_142_3","PSA","142","3","3","At loxonaleng a lok do ana doma abulubun, neni iraklen pam lodomdoma salai ana mumu asu i, kusu ana sepsu basinge mo lara pelixo, limixin munepen minia dira li pe vam ia min ap mo langas nia at pas teren. ");
INSERT INTO mmx_vpl VALUES ("PS142_4","020_142_4","PSA","142","4","4","Amo do a reven tangtagap kangkan ia, axo ven tara go xusu naba lok tooro ia. Kopmen teta go nak lok see rak. ");
INSERT INTO mmx_vpl VALUES ("PS142_5","020_142_5","PSA","142","5","5","Leeme Silok, a reng taba u xusu una lok tooro ia. Leeme Silok, nenu Lurutu See Pe rak, la a vavara xusuk mun u keneng at na lorooro. ");
INSERT INTO mmx_vpl VALUES ("PS142_6","020_142_6","PSA","142","6","6","Una ronga ia, ang teng ti loklok tooro ram atla lodoxoma abulubun i suxuna axav ia. Una lox asepsu ia basinge limixin munepen minia atla di lolos aleng polo lolos tarak. ");
INSERT INTO mmx_vpl VALUES ("PS142_7","020_142_7","PSA","142","7","7","Una lox asepmus ia basinge levenmumuat tarak, kusu anaba emi asu minu ro at lovotpot buru at limixin taram, atla uga lok luvukat tia. ");
INSERT INTO mmx_vpl VALUES ("PS143_1","020_143_1","PSA","143","1","1","Leeme Silok, una ronga lisingising tarak! Una ronga i na lisingising lolos tinotno rak atla loklok taram in manton aleng. Uk lox epovo leveng kakaape ram, kuren la una ronga ia! ");
INSERT INTO mmx_vpl VALUES ("PS143_2","020_143_2","PSA","143","2","2","Nenia lasaxaruki ram, kuren la uguta lok li ia at loklok tong pen, atla kopmen teta ip sepsen at lamaram. ");
INSERT INTO mmx_vpl VALUES ("PS143_3","020_143_3","PSA","143","3","3","Lavamunepen minia digara vuse ka vam ia la dira sep kapmek tinotno ia. Dira lok li vam ia at loogu xokoxo i main bonot, la a lok ngan tino nga nedi ua diga met axa gano at lereot. ");
INSERT INTO mmx_vpl VALUES ("PS143_4","020_143_4","PSA","143","4","4","Kuren la a gagas kusu ana raba xepe nga lorooro rak, atla lodoxoma abulubun na i suxuna rinotno nga ia. ");
INSERT INTO mmx_vpl VALUES ("PS143_5","020_143_5","PSA","143","5","5","A doxoma su ap mo levenaleng gara oon pam. La a doma mo lempanga nenu ugara lok pam i, la mo leven gugu ram i vot manga at lodoxoma rak. ");
INSERT INTO mmx_vpl VALUES ("PS143_6","020_143_6","PSA","143","6","6","A song aurut mi lukngak tu keneng at lisingising tarak. La labalak ik minu ru ngan ta loxongkangka vatmang. ");
INSERT INTO mmx_vpl VALUES ("PS143_7","020_143_7","PSA","143","7","7","Leeme Silok, soso mun una ronga res tarak! Nia ara doma abulubun tino. Uguta lok alipe u basinge ia, lavanga ana emu buru minedi ua di si uto xopok at lemenemen at labarongan. ");
INSERT INTO mmx_vpl VALUES ("PS143_8","020_143_8","PSA","143","8","8","Unak lox adoxoma ia at leven maxantamak axap mi mo labalamu lexen taram, atla lununu rak i tu saga ram. Leve singising tarak i uturut upana ru, kusu una lox ase ia mi langas nia anaba mumu asu i. ");
INSERT INTO mmx_vpl VALUES ("PS143_9","020_143_9","PSA","143","9","9","Leeme Silok, a vot saparav u xusu unak lok see rak. La una vaxat asu ia basinge limixin munepen minia. ");
INSERT INTO mmx_vpl VALUES ("PS143_10","020_143_10","PSA","143","10","10","Nenu ne Moroa rak. Una lox ase ia mi langas ti mumu asu lavavara ram. Una ke Loroonan Avukat taram na lam ia at langas nunuan. ");
INSERT INTO mmx_vpl VALUES ("PS143_11","020_143_11","PSA","143","11","11","Leeme Silok, una sat asu ia basinge limixin munepen minia ngan uga xaape vam min. Nenu uk lox avukat, kuren la una lox asepmus ia basinge na leven mumuat tarak! ");
INSERT INTO mmx_vpl VALUES ("PS143_12","020_143_12","PSA","143","12","12","Una sev amet limixin munepen minia, atla nenu u balamu ia. La una lox abaava tino di mo dik lox asongor ia, atla nenia lasaxaruki ram. ");
INSERT INTO mmx_vpl VALUES ("PS144_1","020_144_1","PSA","144","1","1","Nia a emi asu mi Leeme Silok, ni Lurutu See Pe rak! Neni i arala ia mi loklok ti esep, la ik lox agagas ia ri leesep silok. ");
INSERT INTO mmx_vpl VALUES ("PS144_2","020_144_2","PSA","144","2","2","Neni Lurutu See Pe la Lentupe ria, la Loogu Matmatkun la Laradi Loklox Asepsu rak. Neni laradi ua a nunu saga ren kusu naba kubak pe ia. La neni ik sak tup mi levenabung mixin petpes la ik lok li di maxopok at loklok tatao rak. ");
INSERT INTO mmx_vpl VALUES ("PS144_3","020_144_3","PSA","144","3","3","Leeme Silok, limixin nedi lempanga salai, la uram doma mu solo di. Nedi lempanga gamasa mun ketla ung tonga levelinga atdi? ");
INSERT INTO mmx_vpl VALUES ("PS144_4","020_144_4","PSA","144","4","4","Nedi di lok ngan mun lamanman i rava polo. La levenaleng atdi i lok ngan mun lamamau i sonao. ");
INSERT INTO mmx_vpl VALUES ("PS144_5","020_144_5","PSA","144","5","5","O Leeme Silok, una vaxat das laxalibet la una vas si ude xopok. Una long tu at lempatkaana la dinaba soobang asu lusuxa. ");
INSERT INTO mmx_vpl VALUES ("PS144_6","020_144_6","PSA","144","6","6","Una riki asu lamam (lavanga i mam) la una sak epeseves limixin munepen minia. Una so asu mi levesoso ram kusu naba lox amarat di la dina sixiro. ");
INSERT INTO mmx_vpl VALUES ("PS144_7","020_144_7","PSA","144","7","7","Una song asi boro vana, la una sat asu ka ia boro xeneng tubu at lamaxat dan, la una lok li asepsu ia basinge mo limixin munepen. Una lox asepsu ia basinge lolos at limixin me xadiong, ");
INSERT INTO mmx_vpl VALUES ("PS144_8","020_144_8","PSA","144","8","8","ua kopmen tinotno dina tong asu rinotno luruturun. Ketla di xaxarang mun, keke i do diga xaape do diba tong asu levelinga ruturun. ");
INSERT INTO mmx_vpl VALUES ("PS144_9","020_144_9","PSA","144","9","9","O Moroa, anaba vixan loxompixan maxat tu. Anabak sak ligita rak la anak pixan tu. ");
INSERT INTO mmx_vpl VALUES ("PS144_10","020_144_10","PSA","144","10","10","Uk lox alolos lavaorong kusu dinak sak tup mi limixin munepen midi, la uk lox asepsu ia, lasaxaruki ram ne Devit. ");
INSERT INTO mmx_vpl VALUES ("PS144_11","020_144_11","PSA","144","11","11","Una lox asepmus ia basinge lebelemamao at limixin munepen minia. La una lox asepsu ia basinge lolos at limixin boro vetpes ua dixo tong asu luruturun. Ketla di xaxarang mun, keke i do diga xaape do diba tong asu levelinga ruturun. ");
INSERT INTO mmx_vpl VALUES ("PS144_12","020_144_12","PSA","144","12","12","Nema ma sing u do laxamdak puraau atnema dinaba lok ngan larauna i suusu urut, la i lolos. La ma sing bok do laxamposono maxat atnema dinaba milik maraanu ngan levempos diga xovox i, mo i nganang levenmesuluk axap at loogu at loorong. ");
INSERT INTO mmx_vpl VALUES ("PS144_13","020_144_13","PSA","144","13","13","La ma sing bok do laraogu lili atnema naba unumsu mi lara met luxa axap. La ma sing bok do leve sipsip to at levenang kolonu atnema, dina pisik aleng ngan lasangaun larabin sangsangaun kobot. ");
INSERT INTO mmx_vpl VALUES ("PS144_14","020_144_14","PSA","144","14","14","Ma sing bok do laxan bulumaxao atnema, dina pisik aleng la di noxo pisik amet kopla dina seeve. Ma sing bok do xopmen tanbulu xopla tanteng kopla toxokoxo mumu levenesep eburu mi limixin munepen nak lok to at levenang kolonu atnema. ");
INSERT INTO mmx_vpl VALUES ("PS144_15","020_144_15","PSA","144","15","15","La lomomo naba vot parap mo lubung mixin mo do na lempanga na ravasu ruturun tidi. La lomomo naba vot parap nedi ua Leeme Silok, neni ne Moroa atnedi! ");
INSERT INTO mmx_vpl VALUES ("PS145_1","020_145_1","PSA","145","1","1","Moroa, nenu Loorong Silok tarak. Anaba tong asuusu laasen silok taram. Anaba tong avukat amisik tu la anoxo xap tinotno ri tong avukat. ");
INSERT INTO mmx_vpl VALUES ("PS145_2","020_145_2","PSA","145","2","2","Anaba tong avukat tu at levenaleng axap. Anaba emi asu amisik minu la anoxo xap ti emi asu minu. ");
INSERT INTO mmx_vpl VALUES ("PS145_3","020_145_3","PSA","145","3","3","Leeme Silok neni i nunuan aleng pologat, la i epovo rinotno do limixin dina emi asu min. Atla ixo epovo xusu anaba re sa at lununuan teren ua i volo lakleklen tarak. ");
INSERT INTO mmx_vpl VALUES ("PS145_4","020_145_4","PSA","145","4","4","Limixin dinaba emi asu minu ri levempanga ugara lok pam i, tuka i at lara loola vetpes la ti lara loola melemu. Dinaba tong asuusu levempanga lolos ugarak lok pam i. ");
INSERT INTO mmx_vpl VALUES ("PS145_5","020_145_5","PSA","145","5","5","Dinaba paase asu lixitkis orong taram i silok aleng tinotno la i volo lempanga axap. La nia anabam doma mumu leven gugu maraanu nenu ugak lox i. ");
INSERT INTO mmx_vpl VALUES ("PS145_6","020_145_6","PSA","145","6","6","Limixin dinaba paase mumu leven gugu lolos nenu ugak lox i, la nia anaba paase asu laasen silok taram. ");
INSERT INTO mmx_vpl VALUES ("PS145_7","020_145_7","PSA","145","7","7","Dinaba tere mo luvukat silok taram la dinak pixan mumu labalamu ram. ");
INSERT INTO mmx_vpl VALUES ("PS145_8","020_145_8","PSA","145","8","8","Leeme Silok i ruuna labalamu mi lebelen tuntun, la kopmen nak belemamao soso ketla i umsu mi labalamu lexen. ");
INSERT INTO mmx_vpl VALUES ("PS145_9","020_145_9","PSA","145","9","9","Neni i vukat ti limixin axap la i ruuna labalamu tinedi limixin axap ni ga rudum di. ");
INSERT INTO mmx_vpl VALUES ("PS145_10","020_145_10","PSA","145","10","10","Leeme Silok, lempanga rooro axap nenu uga rudum li di, dinaba emi asu minu, la limixin axap taram dinaba tong avukat tu. ");
INSERT INTO mmx_vpl VALUES ("PS145_11","020_145_11","PSA","145","11","11","Dinaba paase mumu lisisixam la lolos at lixitkis orong taram, la dina tong axasep limixin mi lolos taram, ");
INSERT INTO mmx_vpl VALUES ("PS145_12","020_145_12","PSA","145","12","12","kusu limixin axap dinabak leklen leven gugu lolos taram la lisisixam maraanu at lixitkis orong taram. ");
INSERT INTO mmx_vpl VALUES ("PS145_13","020_145_13","PSA","145","13","13","Lixitkis orong taram naba nemen lexen, la nenu Loorong Avolo, kopmen tekavaxap taram. Leeme Silok ik lox asoorun amisik leveng kakaape ren. La ik lox asuusu labalamu ren keneng at leven gugu axap teren. ");
INSERT INTO mmx_vpl VALUES ("PS145_14","020_145_14","PSA","145","14","14","Ik lok tooro nedi di vekip tangarang mi levenmumuat, la im tebeng aonon nedi ua diga subu. ");
INSERT INTO mmx_vpl VALUES ("PS145_15","020_145_15","PSA","145","15","15","Leeme Silok, levempanga rooro axap di reven tu mi leven doxoma voovo atdi, la um taba nedi mi leveluxa ua dik pakes tin. ");
INSERT INTO mmx_vpl VALUES ("PS145_16","020_145_16","PSA","145","16","16","Um taba epovo rinotno nedi, la uk lox epovo rinotno levem pakpakes atnedi axap. ");
INSERT INTO mmx_vpl VALUES ("PS145_17","020_145_17","PSA","145","17","17","Loklok at Leeme Silok in manton tinotno keneng at levempanga axap neni ik lox i, leven gugu ren ik lox i, ik lox i eburu mi lebelen tuntun teren. ");
INSERT INTO mmx_vpl VALUES ("PS145_18","020_145_18","PSA","145","18","18","Neni ik lok saparap nedi mo di ngising tin, nedi mo di ngising tin mi luruturun. ");
INSERT INTO mmx_vpl VALUES ("PS145_19","020_145_19","PSA","145","19","19","Neni im taba epovo ri levem pakpakes atnedi ua dim taba asinorong i. Ing tonga leven anteng atnedi la irak lox asepsu nedi. ");
INSERT INTO mmx_vpl VALUES ("PS145_20","020_145_20","PSA","145","20","20","Neni ik lok see atnedi ua di vavara aleng tin, ketla neni naba sev amet nedi limixin dixo mumu asu i. ");
INSERT INTO mmx_vpl VALUES ("PS145_21","020_145_21","PSA","145","21","21","Anaba emi asu amisik mi Leeme Silok. La mo lempanga axap ua neni ga rudum i, dina emi asu amisik mi laasen kaala ren la kopmen tekavaxap at leemi asu rin. ");
INSERT INTO mmx_vpl VALUES ("PS146_1","020_146_1","PSA","146","1","1","Leemi asu ri Leeme Silok! Labalak, una emi asu mi Leeme Silok! ");
INSERT INTO mmx_vpl VALUES ("PS146_2","020_146_2","PSA","146","2","2","Anaba emi asu min at levenaleng axap, nenia ana rooro ren. La anabak pixan ti ne Moroa rak keneng at lorooro axap tarak. ");
INSERT INTO mmx_vpl VALUES ("PS146_3","020_146_3","PSA","146","3","3","Mi guta nunu saga at lubung amgomgo mede at lavatbung menemen ti loklok tooro, atla kopmen teta mede xopok i epovo na lox asepsu nemi. ");
INSERT INTO mmx_vpl VALUES ("PS146_4","020_146_4","PSA","146","4","4","Mo do dina met, dinabam long ti laxangka. La ap mo laaleng, leven doxoma ali atdi naba xap. ");
INSERT INTO mmx_vpl VALUES ("PS146_5","020_146_5","PSA","146","5","5","Laradi naba ruuna xaka lomomo mo do neni na siam kaka ne Moroa at ne Jakop kusu tik lok tooro i, la neni i nunu saga at Leeme Silok ne Moroa ren, ");
INSERT INTO mmx_vpl VALUES ("PS146_6","020_146_6","PSA","146","6","6","atla neni Laradi Runtudum Li at laxalibet mi lavatkangka la laras, la mo lempanga axap bok di nemen keneng at na lengkot axap. Neni ik lox epovo amisik leveng kakaape ren. ");
INSERT INTO mmx_vpl VALUES ("PS146_7","020_146_7","PSA","146","7","7","Ing tonga linga avukat at lava baava, la im taba luxa nedi dik toxo. Leeme Silok ik lox asepmus luvuttadi xokoxo, ");
INSERT INTO mmx_vpl VALUES ("PS146_8","020_146_8","PSA","146","8","8","la irak lox arepalas lengkatli atnedi ua dixo reven. Neni im tebeng aonon nedi ua diga subu mi levenmumuat. Neni i balamu aleng tinotno nedi limixin manmanton teren. ");
INSERT INTO mmx_vpl VALUES ("PS146_9","020_146_9","PSA","146","9","9","Neni ik lok see atnedi limixin me xadiong ua di nemen keneng at lenep kangka atnedik. Ik lok tooro lempat naa rixin eburu mi lubung karun, ketla ik lox asaxaek tino nedi luvuttadi loklok kakapmek. ");
INSERT INTO mmx_vpl VALUES ("PS146_10","020_146_10","PSA","146","10","10","Leeme Silok neni Loorong Avolo la kopmen tekavaxap teren. O leme Saion, ne Moroa atnimi nabat kis amgomgo lexen tinotno. Leemi asu ri Leeme Silok! ");
INSERT INTO mmx_vpl VALUES ("PS147_1","020_147_1","PSA","147","1","1","Leemi asu ri Leeme Silok! I lox avukat kusu atak pixan emi asu ri ne Moroa atnedik. Ik mokso rinotno la ik lox asuusu lomomo tinedi dina emi asu mi Leeme Silok. ");
INSERT INTO mmx_vpl VALUES ("PS147_2","020_147_2","PSA","147","2","2","Leeme Silok ira vaxaru li amu lemenemen Jerusalem. Neni ira lam kaka amlong limixin kokoxo. ");
INSERT INTO mmx_vpl VALUES ("PS147_3","020_147_3","PSA","147","3","3","Neni ik lox aroo nedi ua lempeve atnedi ga tepovorok la ga koxo pe levennin kooxing atdi. ");
INSERT INTO mmx_vpl VALUES ("PS147_4","020_147_4","PSA","147","4","4","Neni gara doma vam i do naba rudum lavanisa laxampenti, la ikleklen leven asen atnedi getgesara. ");
INSERT INTO mmx_vpl VALUES ("PS147_5","020_147_5","PSA","147","5","5","Leeme Silok atnedik i silok la i lolos aleng. La ixo epovo xusu ataba us sa mo lakleklen teren mi tepanga. ");
INSERT INTO mmx_vpl VALUES ("PS147_6","020_147_6","PSA","147","6","6","Neni ip kip aurut nedi ua dik lox asi di, ketla it pas puuvus nedi luvuttadi loklok kakapmek uto xopok at laxangka. ");
INSERT INTO mmx_vpl VALUES ("PS147_7","020_147_7","PSA","147","7","7","Atak pixan lengkom pixan emi asu ri Leeme Silok. Atak sak lerengteng avukat mi lempat taaleng ti ne Moroa atdik. ");
INSERT INTO mmx_vpl VALUES ("PS147_8","020_147_8","PSA","147","8","8","Neni ik lok li lengkon takabu ro vana at laxalibet. Neni ik lox asuusu larakabu ude ri laxangka, la irak lox asuusu levem pivilis to vana at lengkong kaana. ");
INSERT INTO mmx_vpl VALUES ("PS147_9","020_147_9","PSA","147","9","9","Neni im taba luxa lempanga mi lavanuet kangkedek atdi, la im taba bok leven natnat kooxo mo do dina sing panga ri anan. ");
INSERT INTO mmx_vpl VALUES ("PS147_10","020_147_10","PSA","147","10","10","Lomomo ren kopmen na tu at lempat paaros lolos, la ixo momo solo mi luvuttadi esep lolos. ");
INSERT INTO mmx_vpl VALUES ("PS147_11","020_147_11","PSA","147","11","11","Ketla in tuuna xaka lomomo boro atnedi limixin dim taba asinorong i la di nunu saga at labalamu lexen teren. ");
INSERT INTO mmx_vpl VALUES ("PS147_12","020_147_12","PSA","147","12","12","O leme Jerusalem, mina emi asu mi Leeme Silok! O leme Saion, mina emi asu mi ne Moroa atnimi! ");
INSERT INTO mmx_vpl VALUES ("PS147_13","020_147_13","PSA","147","13","13","Neni ik lox aru lolos lempatban at larangas uat atnimi la ik lox anarong limixin go. ");
INSERT INTO mmx_vpl VALUES ("PS147_14","020_147_14","PSA","147","14","14","Neni ik lok tatao leven apdopdo atnimi basinge limixin munepen minimi, la irak lox aan mais nimi mi leven uit maraanu. ");
INSERT INTO mmx_vpl VALUES ("PS147_15","020_147_15","PSA","147","15","15","Neni i paase levelinga ri lempanga at na lavatkangka, la ik lox epovo soso mun mo levelinga neni i tong i. ");
INSERT INTO mmx_vpl VALUES ("PS147_16","020_147_16","PSA","147","16","16","Neni i vavaxat palas asu lusugao mumudut (snow) ngan ta lavat tamon bukburu, la ira tereve ledemi mumudut (frost) ngan ta laxakup. ");
INSERT INTO mmx_vpl VALUES ("PS147_17","020_147_17","PSA","147","17","17","Neni ik lox asu lempat betlom ngan ta laxariri uat. La ixo epovo xusu tara na ekini mi mo lumudut silok ua neni ik lox asuusu i! ");
INSERT INTO mmx_vpl VALUES ("PS147_18","020_147_18","PSA","147","18","18","Melemu neni i paase asu levelinga ren, la mo ladan uat (ice) ira kadan amu. Neni im taba asu lamanman la mo ladan ira sesen ta. ");
INSERT INTO mmx_vpl VALUES ("PS147_19","020_147_19","PSA","147","19","19","Neni ga raba limixin teren me Israel mi mo levelinga ren, ni leventaangas la Laulis Linga ren. ");
INSERT INTO mmx_vpl VALUES ("PS147_20","020_147_20","PSA","147","20","20","Neni goxovisi na raba i ri lubung mixin petpes. Kuren la dixok leklen levelinga ren. Leemi asu ri Leeme Silok! ");
INSERT INTO mmx_vpl VALUES ("PS148_1","020_148_1","PSA","148","1","1","Leemi asu ri Leeme Silok. Nemi mi nemen to vana rubu rino, mina emi asu mi Leeme Silok ik lok to vana at laxalibet. ");
INSERT INTO mmx_vpl VALUES ("PS148_2","020_148_2","PSA","148","2","2","Nemi lubung angelo eburu mi limixin esep teren, mina emi asu min. ");
INSERT INTO mmx_vpl VALUES ("PS148_3","020_148_3","PSA","148","3","3","Laxangking mi lagaaling, muna emi asu min, la laxampenti soosoo, mina emi asu min. ");
INSERT INTO mmx_vpl VALUES ("PS148_4","020_148_4","PSA","148","4","4","Laxalibet pana xasep la ladan ik lok ma vana at laxalibet, mina emi asu min. ");
INSERT INTO mmx_vpl VALUES ("PS148_5","020_148_5","PSA","148","5","5","Nedi axap mina emi asu mi laasen at Leeme Silok! Neni ga tong mun i la nedi na lempanga ga raut. ");
INSERT INTO mmx_vpl VALUES ("PS148_6","020_148_6","PSA","148","6","6","Neni ga tong mun i la mo lempanga ga xis bus ap mo lengkot atdi la dinaba nemen lexen go la di noxo ronga xepe levelinga ren. ");
INSERT INTO mmx_vpl VALUES ("PS148_7","020_148_7","PSA","148","7","7","At na lavatbung menemen, laras main tubu, la lempat konomus, mina emi asu min. ");
INSERT INTO mmx_vpl VALUES ("PS148_8","020_148_8","PSA","148","8","8","La lamam mi lebetlom uat, lusugao mumudut (snow) mi lengkon takabu, la lara manman lolos ua ding tonga res at levelinga ren, mina emi asu min. ");
INSERT INTO mmx_vpl VALUES ("PS148_9","020_148_9","PSA","148","9","9","Nemi lengkong kaana mi lempattaavut, la larauna vipisik peeve eburu mi lempatbuan, mina emi asu min. ");
INSERT INTO mmx_vpl VALUES ("PS148_10","020_148_10","PSA","148","10","10","Nemi bok lempanga mi lavanuet kangkedek, lentaba sio la lentaba roonu, la laxa siisi mi lavapixa, mina emi asu min. ");
INSERT INTO mmx_vpl VALUES ("PS148_11","020_148_11","PSA","148","11","11","Nemi axap lavaorong mi limixin axap, lavanarong eburu mi lubung amgomgo vetpes bok, mina emi asu min. ");
INSERT INTO mmx_vpl VALUES ("PS148_12","020_148_12","PSA","148","12","12","Nemi bok laxamposono mi luvuraau atlok, la limixin asioxo mi laxaalik kakalik bok, mina emi asu min. ");
INSERT INTO mmx_vpl VALUES ("PS148_13","020_148_13","PSA","148","13","13","Naba lox avukat do nedi axap dina emi asu mi laasen at Leeme Silok! Laasen teren i silok ti limixin axap. La lolos teren i volo lolos at lempanga axap at lavatbung menemen eburu mi laxalibet. ");
INSERT INTO mmx_vpl VALUES ("PS148_14","020_148_14","PSA","148","14","14","Neni ga lox alolos lubung mixin teren, kusu limixin axap teren dinaba emi asu min. Limixin me Israel di silok tinotno at lodoxoma ren. Leemi asu ri Leeme Silok! ");
INSERT INTO mmx_vpl VALUES ("PS149_1","020_149_1","PSA","149","1","1","Leemi asu ri Leeme Silok! Mina vixan loxom pixan maxat ti emi asu mi Leeme Silok. Mina emi asu min to at lovotpot buru atnedi limixin ua di ruturun tin! ");
INSERT INTO mmx_vpl VALUES ("PS149_2","020_149_2","PSA","149","2","2","Nemi leme Israel, minak lek mumu Laradi Runtudum Li atnemi. Nemi limixin me Saion mina momo mumu mo Loorong Silok atnemi! ");
INSERT INTO mmx_vpl VALUES ("PS149_3","020_149_3","PSA","149","3","3","Mina tii momo ri emi asu mi laasen teren. Mina pasa levengkuvu eburu mi lempat taaleng ti emi asu min. ");
INSERT INTO mmx_vpl VALUES ("PS149_4","020_149_4","PSA","149","4","4","Leeme Silok in tuuna ka lomomo mumu limixin teren. Im taba asinorong nedi ua dik lok atnaasan la im taba di mi lolos ti sak tup mi limixin munepen midi. ");
INSERT INTO mmx_vpl VALUES ("PS149_5","020_149_5","PSA","149","5","5","Naba lox avukat do limixin at ne Moroa dina momo mi leepang silok atla diga sev asi nedi, la dinak pixan momo maraanu rinotno at lengkanimin axap. ");
INSERT INTO mmx_vpl VALUES ("PS149_6","020_149_6","PSA","149","6","6","Naba lox avukat do dinap kup silok at loxonaleng dina emi asu mi ne Moroa, la dinam tebeng levenise esep sengsen atnedi, ");
INSERT INTO mmx_vpl VALUES ("PS149_7","020_149_7","PSA","149","7","7","kusu tik sak tup mi levenabung mixin petpes, la rik lox asongot di, ");
INSERT INTO mmx_vpl VALUES ("PS149_8","020_149_8","PSA","149","8","8","la kusu ti koxo lavaorong atnedi mi lempat sen, la mo lubung amgomgo atnedi bok mi lempat sen aen. ");
INSERT INTO mmx_vpl VALUES ("PS149_9","020_149_9","PSA","149","9","9","Na lempanga naba ravasu kusu ti lok li liina mavana at levenabung mixin petpes ngan ne Moroa gara vit li vam i. Nai i ngan lasinorong at limixin at ne Moroa. Kuren la dinaba lok kaka laasen silok teren. Leemi asu ri Leeme Silok! ");
INSERT INTO mmx_vpl VALUES ("PS150_1","020_150_1","PSA","150","1","1","Leemi asu ri Leeme Silok! Mina emi asu mi Leeme Silok to xeneng at loogu laplavang teren! Mina emi asu mi lolos teren toxun pana at laxalibet! ");
INSERT INTO mmx_vpl VALUES ("PS150_2","020_150_2","PSA","150","2","2","Mina emi asu min mumu levempanga lolos neni gara lok pam i. Mina emi asu min atla neni i silok solo mavana at lempanga axap. ");
INSERT INTO mmx_vpl VALUES ("PS150_3","020_150_3","PSA","150","3","3","Mina emi asu min mi lara tu. Mina emi asu min mi lempat taaleng la leven gita. ");
INSERT INTO mmx_vpl VALUES ("PS150_4","020_150_4","PSA","150","4","4","Mina tii momo la minak sak gaamit ti emi asu min. Mina emi asu min mi lempat gita la leveng kaatu. ");
INSERT INTO mmx_vpl VALUES ("PS150_5","020_150_5","PSA","150","5","5","Mina emi asu min mi lasaksak lempat tingtigon aen (simbol). Minak sak silok lempat tingtigon aen (simbol) ti emi asu min. ");
INSERT INTO mmx_vpl VALUES ("PS150_6","020_150_6","PSA","150","6","6","Levempanga rooro axap, mina emi asu min. Leemi asu ri Leeme Silok! ");
INSERT INTO mmx_vpl VALUES ("MT1_1","070_1_1","MAT","1","1","1","Anai ni leretere ri levenasen at lavalabat at ne Iesu Karisito, neni livisik li at ne Devit, la ne Devit neni livisik li at ne Abaram. ");
INSERT INTO mmx_vpl VALUES ("MT1_2","070_1_2","MAT","1","2","2","Abaram neni temen ne Aisak; Aisak neni temen ne Jakop; Jakop neni temen ne Juda eburu mi luvutneton; ");
INSERT INTO mmx_vpl VALUES ("MT1_3","070_1_3","MAT","1","3","3","Juda neni temen ne Peres mi ne Sara. (Nenen du laasen teren ne Tema); Peres neni temen ne Esron; Esron neni temen ne Ram; ");
INSERT INTO mmx_vpl VALUES ("MT1_4","070_1_4","MAT","1","4","4","Ram neni temen ne Aminadap; Aminadap neni temen ne Nason; Nason neni temen ne Salmon; ");
INSERT INTO mmx_vpl VALUES ("MT1_5","070_1_5","MAT","1","5","5","Salmon neni temen ne Boas (Raap neni nenen); Boas neni temen ne Obet (Rut neni nenen); Obet neni temen ne Jesi. ");
INSERT INTO mmx_vpl VALUES ("MT1_6","070_1_6","MAT","1","6","6","Jesi neni temen ne Devit, loorong. Devit neni temen ne Solomon (nenen ni latkin at ne Uraia); ");
INSERT INTO mmx_vpl VALUES ("MT1_7","070_1_7","MAT","1","7","7","Solomon neni temen ne Roboam; Roboam neni temen ne Abaisa; Abaisa neni temen ne Asa; ");
INSERT INTO mmx_vpl VALUES ("MT1_8","070_1_8","MAT","1","8","8","Asa neni temen ne Josepat; Josepat neni temen ne Joram; Joram neni temen ne Usaia; ");
INSERT INTO mmx_vpl VALUES ("MT1_9","070_1_9","MAT","1","9","9","Usaia neni temen ne Jotam; Jotam neni temen ne Eas; Eas neni temen ne Esekia; ");
INSERT INTO mmx_vpl VALUES ("MT1_10","070_1_10","MAT","1","10","10","Esekia neni temen ne Manase; Manase neni temen ne Amon; Amon neni temen ne Josaia; ");
INSERT INTO mmx_vpl VALUES ("MT1_11","070_1_11","MAT","1","11","11","Josaia neni temen ne Jekonia eburu mi luvutneton. Ap mo levenaleng limixin esep boro Babilon diga lok ka limixin me Israel uto Babilon ti loxokoxo. ");
INSERT INTO mmx_vpl VALUES ("MT1_12","070_1_12","MAT","1","12","12","Melemu at nai, ne Jekonia neni temen ne Salatiel; Salatiel neni temen ne Serababel; ");
INSERT INTO mmx_vpl VALUES ("MT1_13","070_1_13","MAT","1","13","13","Serababel neni temen ne Abiut; Abiut neni temen ne Eliakim; Eliakim neni temen ne Aso; ");
INSERT INTO mmx_vpl VALUES ("MT1_14","070_1_14","MAT","1","14","14","Aso neni temen ne Sadok; Sadok neni temen ne Akim; Akim neni temen ne Eliuda. ");
INSERT INTO mmx_vpl VALUES ("MT1_15","070_1_15","MAT","1","15","15","Eliuda neni temen ne Eliasa; Eliasa neni temen ne Matan; Matan neni temen ne Jakop; ");
INSERT INTO mmx_vpl VALUES ("MT1_16","070_1_16","MAT","1","16","16","Jakop neni temen ne Josep, latlok at ne Maria, nenen ne Iesu, ga ruuna ka laasen do Lanarong. ");
INSERT INTO mmx_vpl VALUES ("MT1_17","070_1_17","MAT","1","17","17","Kuren la ga ruka i at ne Abaram la uto at ne Devit ga epovo at lasangaun mi lavanuet lavaola. La ga ruka i at ne Devit ga se leme Babilon diga lok ka limixin me Israel uto Babilon ga epovo at lasangaun mi lavanuet lavaola. La ga ruka i melemu at loxokoxo at limixin me Israel uto Babilon la ga se at livipisik at Lanarong ga epovo at lasangaun mi lavanuet lavaola. ");
INSERT INTO mmx_vpl VALUES ("MT1_18","070_1_18","MAT","1","18","18","Anai ni leretere ri livipisik at ne Iesu Karisito. Maria, nenen ne Iesu diga ora ka i xusu latkin ti ne Josep, ketla kovisi du goxo epot, Maria ga long lenget ka i do neni mo ga balan madak mi lolos at Loroonan Kaala. ");
INSERT INTO mmx_vpl VALUES ("MT1_19","070_1_19","MAT","1","19","19","Ne Josep, latlok teren, neni lagale laradi la ga mumu asu avukat Laulis Linga at ne Moses. Ga lok lodoxoma ren kusu na ke xepe ne Maria. Ketla neni goxo vara i xusu na lox amangan i ro at lemeren limixin axap. Neni ga lok do na lok kepe nemnem mene i. ");
INSERT INTO mmx_vpl VALUES ("MT1_20","070_1_20","MAT","1","20","20","Josep gam doma mumu i na la at lara laxanimin laangelo at ne Moroa ga vot saparav i at loromtobo la ga lok, “Josep. Livisik li at ne Devit. Nemen gat uta marat kusu una lok ka ne Maria ngan latkin tu, mila mo labalan madak neni i ruuna i, neni at Loroonan Kaala. ");
INSERT INTO mmx_vpl VALUES ("MT1_21","070_1_21","MAT","1","21","21","Neni naba visik lamdak temes la una so asen i mi ne Iesu, (Lavasuun teren do laradi loklox arooro) mila neni naba lox arooro limixin teren basinge laxakapmek atdi.” ");
INSERT INTO mmx_vpl VALUES ("MT1_22","070_1_22","MAT","1","22","22","Ana lempanga axap ga vot kusu ti lox asoorun levelinga at ne Moroa ga ravasu at lungusno at leeme vapaase ali ren, ga lok keretna, ");
INSERT INTO mmx_vpl VALUES ("MT1_23","070_1_23","MAT","1","23","23","“Tatkin maxat naba balan madak la naba visik tamdak temes la dinaba so asen i mi ne Emanuel.” Lavasuun teren do, “Moroa eburu midik.” ");
INSERT INTO mmx_vpl VALUES ("MT1_24","070_1_24","MAT","1","24","24","La ne Josep ga xatu kaxat ap mo laaleng petpes la ga mu asu levelinga at laangelo at Leeme Silok ne Moroa, la ni ga epot ka ne Maria. ");
INSERT INTO mmx_vpl VALUES ("MT1_25","070_1_25","MAT","1","25","25","Ketla neni goxo midi eburu mi ne Maria, se neni ga visik lamdak teren. La ne Josep ga so asen i mi ne Iesu. ");
INSERT INTO mmx_vpl VALUES ("MT2_1","070_2_1","MAT","2","1","1","Maria ga visik ne Iesu ro Betilem, at lenep silok Judaia. Ap mo levenaleng ne Erodes ga nemen ngan loorong. Melemu lentaba luvuttadi leklen at larapenti digat pas boro at lenep laxangking it losu e uto Jerusalem ");
INSERT INTO mmx_vpl VALUES ("MT2_2","070_2_2","MAT","2","2","2","la diga sue limixin me go, “Lumumulum ua diga visix i kusu neni Loorong Silok ti limixin me Judaia? Maga ven lenti ren to at lenep laxangking it losu e, la marat pas ude xusu mana lotu saparav i.” ");
INSERT INTO mmx_vpl VALUES ("MT2_3","070_2_3","MAT","2","3","3","Erodes ga ronga i na, la lebelen ga xatu, la limixin axap go Jerusalem lebelendi ga xatu bok. ");
INSERT INTO mmx_vpl VALUES ("MT2_4","070_2_4","MAT","2","4","4","Erodes ga ro bubua ka nedi axap luvuttadi amgomgo at lubungmaasa la luvuttadi loklox ase at Laulis Linga la ga sue di xeretna, “Lanarong diba visix i ua?” ");
INSERT INTO mmx_vpl VALUES ("MT2_5","070_2_5","MAT","2","5","5","La diga vorang i rin keretna, “To at lemenemen Betilem at lenep Judaia, mila leeme vapaase ali ga malagan i xeretna, ");
INSERT INTO mmx_vpl VALUES ("MT2_6","070_2_6","MAT","2","6","6","‘Lemenemen Betilem at lenep Juda, neni i silok aleng ti levenmenemen petpes to Juda. Tara me dom naba vot ngan laradi gomgo la naba lok tatao limixin tarak mede Israel kerekngan laradi loklok tatao sipsip.’” ");
INSERT INTO mmx_vpl VALUES ("MT2_7","070_2_7","MAT","2","7","7","La ne Erodes ga ro nemnem ka mo luvuttadi leklen la ga sue di mi laaleng salai mo lenti ga so su ren. ");
INSERT INTO mmx_vpl VALUES ("MT2_8","070_2_8","MAT","2","8","8","Melemu neni ga riki di uto Betilem mi levelinga xeretna, “Minat pas la mina puse avukat ti mo lamdak. La do mina vuse sa ren, minaba tong axasep box ia min, kusu nenia bok anaba vot pasa i la ana lotu saparav i.” ");
INSERT INTO mmx_vpl VALUES ("MT2_9","070_2_9","MAT","2","9","10","Melemu at na levelinga at loorong ne Erodes, diga vas kaxat, la at lavatpas atdi ro at langas diga ven manga mo lenti, no diga ven avot pam i ro at lenep laxangking it losu e. At loxonaleng diga ven i, lomomo atdi ga silok aleng. Mo lenti gam gomgo ridi se ga ru ro mavana ap mo loogu ne Iesu gak midi ren. ");
INSERT INTO mmx_vpl VALUES ("MT2_11","070_2_11","MAT","2","11","11","Diga beles ukeneng la diga ven lamdak eburu mi ne Maria, nenen. Diga xis tiktikbu mi lempatgulom atdi la diga milik tiding si ukopok la diga lotu saparav i. La diga suang lengkontonom ka atdi la diga lok letaba rin mi logol (gold), perengkinsen (frankincense), la mea (myrrh). ");
INSERT INTO mmx_vpl VALUES ("MT2_12","070_2_12","MAT","2","12","12","Melemu at nai Moroa ga vaase di xeneng at loromtobo do nemen gat ditamlong uto saparap ne Erodes. Kuren la diga vas bilong uto at lenep kangka atdi at lara langas petpes. ");
INSERT INTO mmx_vpl VALUES ("MT2_13","070_2_13","MAT","2","13","13","Se mo luvuttadi leklen diga vas kaxat pam, laangelo at Leeme Silok ne Moroa ga vot parap ne Josep keneng at loromtobo. La ga lok, “Una xatu kaxat la una lok kaka lamdak eburu mi nenen la mina sixiro uto Isip. Mina nemen go se nenia anaba tong i rinimi do mina on basinge mo lenep, mila ne Erodes mo naba reven pupuke ri lamdak kusu na sev amer i.” ");
INSERT INTO mmx_vpl VALUES ("MT2_14","070_2_14","MAT","2","14","14","Kuren la ne Josep ga xatu kaxat, la ga lok kaka lamdak eburu mi nenen, la ap mo mene laxanimin diga vas kaxat basinge mo lemenemen Betilem la uto Isip. ");
INSERT INTO mmx_vpl VALUES ("MT2_15","070_2_15","MAT","2","15","15","La diga nemen go se ne Erodes ga met. Nai lempanga ga vot kusu ti lox asoorun levelinga at ne Moroa ga vaase asu i at lungusno leeme vapaase ali ren keretna, “Aga xup kaka lamdak tarak boro Isip.” ");
INSERT INTO mmx_vpl VALUES ("MT2_16","070_2_16","MAT","2","16","16","Se ne Erodes gaklen ka i do luvuttadi leklen diga bala vukpux i, neni ga musak aleng. Neni ga raba linga limixin esep teren kusu dina sev amet laxamdak temes, levenmaares atdi ga epovo at legepura la maxopok, to Betilem la at levenmenemen bok gak lox auret, mumu levelinga neni gara ronga vam i boro at luvuttadi leklen, mumu laaleng lenti ga soo su. ");
INSERT INTO mmx_vpl VALUES ("MT2_17","070_2_17","MAT","2","17","17","La mo levelinga, ne Moroa ga vaase i at lungusno at leeme vapaase ali ren ne Jeremaia ga soorun, la ga lok keretna, ");
INSERT INTO mmx_vpl VALUES ("MT2_18","070_2_18","MAT","2","18","18","“Lerengteng at lara mo diga ronga i ro Rama, ni lanteng silok. Rakel mo i duudu mumu laxamdak teren. La kopmen tara ga epovo do na lox amenemen i mila laxamdak axap teren mo dira met pam.” ");
INSERT INTO mmx_vpl VALUES ("MT2_19","070_2_19","MAT","2","19","19","Melemu at lanmet at ne Erodes, laangelo at Leeme Silok ne Moroa ga vot saparap ne Josep keneng at loromtobo to Isip. ");
INSERT INTO mmx_vpl VALUES ("MT2_20","070_2_20","MAT","2","20","20","La ga lok, “Una xatu kaxat, la una lok ka lamdak eburu mi nenen, la minamlong uto at lenep silok Israel. Mila mo luvuttadi diga lok do dina sev amet nom lamdak, dira met pam.” ");
INSERT INTO mmx_vpl VALUES ("MT2_21","070_2_21","MAT","2","21","21","Kuren la ne Josep ga xatu kaxat, la ga lok ka lamdak eburu mi nenen la digamlong uto Israel. ");
INSERT INTO mmx_vpl VALUES ("MT2_22","070_2_22","MAT","2","22","22","Se ne Josep ga ronga i do ne Akeleas mo ga lok ka lixitkis at ne temen, ne Erodes, ngan loorong boro Judaia, neni ga marat kusu ti nemen go. La laangelo ga raba linga manga i xeneng at loromtobo, kuren la digat pas uto at lenep silok Galili. ");
INSERT INTO mmx_vpl VALUES ("MT2_23","070_2_23","MAT","2","23","23","La diga nemen to Nasaret. La levelinga at lavaeme vapaase ali ga soorun. Mo levelinga ga lok keretna, “Dinaba so asen i do neni lanat me Nasaret.” ");
INSERT INTO mmx_vpl VALUES ("MT3_1","070_3_1","MAT","3","1","1","Buaang levenmaares gara volo, la ne Jon, laradi sep susu ga ru asuvos to at lamatbin at lenep silok Judaia la ga ruka lugugu ren. ");
INSERT INTO mmx_vpl VALUES ("MT3_2","070_3_2","MAT","3","2","2","Neni ga vavang keretna, “Mina leeng basinge leveloklok kakapmek atnimi, mila langas ti Linintoo no vana at laxalibet monga ira auret!” ");
INSERT INTO mmx_vpl VALUES ("MT3_3","070_3_3","MAT","3","3","3","Leeme vapaase ali ne Aisaia ga paase mumu ne Jon mi levelinga i lok keretna, “Lara mo ip kup to at lamatbin keretna, mina lox agagas li langas ti Leeme Silok. Mina lox akmokso langas tin!” ");
INSERT INTO mmx_vpl VALUES ("MT3_4","070_3_4","MAT","3","4","4","Jon ga siga labantamon diga lox i mi lengkabinim at lakamel. Neni ga dodos i mi labanbaane diga lox i mi labantuxu at lavanga mi lavanuet kangkedek teren. La neni ga anan levenasku mi laxanmisiu boro at laxairing. ");
INSERT INTO mmx_vpl VALUES ("MT3_5","070_3_5","MAT","3","5","5","Limixin digat pot saparav i boro Jerusalem, boro at levennep axap Judaia, la boro bok at levennep saparap ladan sen Joridan kusu dinang tonga levelinga ren. ");
INSERT INTO mmx_vpl VALUES ("MT3_6","070_3_6","MAT","3","6","6","Diga tong asu leveloklok kakapmek atdi la ne Jon ga sep susu nedi ro at ladan sen Joridan. ");
INSERT INTO mmx_vpl VALUES ("MT3_7","070_3_7","MAT","3","7","7","At loxonaleng ne Jon ga ven buaang nedi lubung Parisi mi lubung Sadiusi diga vot pasa i kusu neni na sep susu nedi, neni ga lok tidi xeretna, “Nemi laxamdak at lempasii. Kereva, mi lok do mina sixiro at lebelemamao at ne Moroa mo naba vot saparap limixin kakapmek? ");
INSERT INTO mmx_vpl VALUES ("MT3_8","070_3_8","MAT","3","8","8","Minak lok lempanga i nunuan kusu naba lox asuusu i do mira leeng basinge vam leveloklok kakapmek atnimi. ");
INSERT INTO mmx_vpl VALUES ("MT3_9","070_3_9","MAT","3","9","9","Ketla mi guta nua i do miba sixiro at lebelemamao at ne Moroa mumu nga i do ne Abaram, neni lurubuno avolo atnimi. A tong i rinimi do Moroa i epovo na ba gili na laxanuat la dina vee ngan livipisik li avolo ri ne Abaram. ");
INSERT INTO mmx_vpl VALUES ("MT3_10","070_3_10","MAT","3","10","10","Moroa mo i gagas kusu ti tara asi larauna ro xa at laraixe atdi. Larauna do kopmen dina pisik asu lempeven una nunuan, neni naba ra asi di la na lu arup midi ro at laxao.” ");
INSERT INTO mmx_vpl VALUES ("MT3_11","070_3_11","MAT","3","11","11","La ne Jon ga lok bok, “A sep susu nemi mi ladan kusu na lox asuusu i do mira leeng pam basinge leveloklok kakapmek atnimi. Ketla lara mo naba mumu bok ba rak. Neni naba sep susu nimi mi Loroonan Kaala la laxao ri limixin tongtonga xepe. Lolos teren i volo lolos tarak. Axo epovo kusu anap kip luvanga vatpas teren mila i silok aleng tia. ");
INSERT INTO mmx_vpl VALUES ("MT3_12","070_3_12","MAT","3","12","12","Neni naba ronga linga at limixin axap, la naba lok pes mun limixin avukat basinge limixin kakapmek, kerekngan laradi loklok tatao laraamang i epes lenbolo avukat basinge lenbolo i gu. Limixin avukat, neni naba lox arooro di uto vana at laxalibet. La limixin kakapmek, neni naba lok li di at lemenemen songsongot, i ngan lenbolo gu di tara kutkut di.” ");
INSERT INTO mmx_vpl VALUES ("MT3_13","070_3_13","MAT","3","13","13","Goxo lox abao la ne Iesu ga vas kaxat boro Galili la uto Joridan, la ga vot pasa ne Jon kusu neni na sep susu i. ");
INSERT INTO mmx_vpl VALUES ("MT3_14","070_3_14","MAT","3","14","14","Ketla ne Jon ga lok tin, “Ixo epovo xusu una mu asu i na. I epovo do nenu una sep susu ia. La tila xa la ura sing ia do ana sep susu u?” ");
INSERT INTO mmx_vpl VALUES ("MT3_15","070_3_15","MAT","3","15","15","Ketla ne Iesu ga vorang i rin keretna, “Una lok lavanga salai nia ara tong pam i, mila at na mun i langas la neda ata naba lox asoorun lempanga salai ik mokso kerekngan ne Moroa i vara i.” Kuren la ne Jon ga mu asu lodoxoma at ne Iesu. ");
INSERT INTO mmx_vpl VALUES ("MT3_16","070_3_16","MAT","3","16","16","Melemu at ne Jon ga sep susu ne Iesu, neni ga vas urut basinge ladan la uto at lisigege dan. La ne Moroa ga suang laxalibet ti ne Iesu, la neni ga ven Loroonan at ne Moroa ga si boro vana la ukopok. Ga ven ngan ta lamno la ga nemen at ne Iesu. ");
INSERT INTO mmx_vpl VALUES ("MT3_17","070_3_17","MAT","3","17","17","La laxaka at ne Moroa boro vana at laxalibet ga lok, “Neni na ne Nuruk. Nia a balamu i la a momo aleng min.” ");
INSERT INTO mmx_vpl VALUES ("MT4_1","070_4_1","MAT","4","1","1","Melemu Loroonan Kaala ga lam ka ne Iesu uto at lamatbin kusu ne Satan na lok tong i. ");
INSERT INTO mmx_vpl VALUES ("MT4_2","070_4_2","MAT","4","2","2","Melemu at lumun anan teren at lavanuet sangaun aleng kangking la kanimin, neni ga roxo ba. ");
INSERT INTO mmx_vpl VALUES ("MT4_3","070_4_3","MAT","4","3","3","Satan ga vot pasa i la ga lok tin, “Mo do nenu ne Nitna ne Moroa, una tong i ri na laxanuat la dina vee xongkide.” ");
INSERT INTO mmx_vpl VALUES ("MT4_4","070_4_4","MAT","4","4","4","La ne Iesu ga vorang i rin keretna, “Lovoang Kaala i tong i do, ‘Laradi kopmen na rooro xusuk mun at loxongkide, ketla neni i rooro at levelinga axap at ne Moroa ik lok keneng at Lovoang Kaala.’” ");
INSERT INTO mmx_vpl VALUES ("MT4_5","070_4_5","MAT","4","5","5","Melemu ne Satan ga lok ka ne Iesu uto at lemenemen kaala, Jerusalem la ga vaxaru li i ro vana at langkut at loogu laplavang. ");
INSERT INTO mmx_vpl VALUES ("MT4_6","070_4_6","MAT","4","6","6","La ga lok tin, “Mo do nenu ne Nitna ne Moroa, una los si ukopok, mila Lovoang Kaala i tong i do, ‘Moroa naba lok li lubung angelo ren, la dinaba rebeng aurur u mi lengkikngen di, kusu tuuat noxo sev asongot tekot at luxangkedek taram.’” ");
INSERT INTO mmx_vpl VALUES ("MT4_7","070_4_7","MAT","4","7","7","Iesu ga lok tin keretna, “Lovoang Kaala i tong box i do, ‘Nemen uta lok li ne Moroa, Leeme Silok taram at loklok tong.’” ");
INSERT INTO mmx_vpl VALUES ("MT4_8","070_4_8","MAT","4","8","8","Melemu ne Satan ga lok ka ne Iesu uto vana at lakaana ga nemen kasep pana la ga lox ase i mi laramenemen axap at na lavatbung menemen la lisisinang atdi. ");
INSERT INTO mmx_vpl VALUES ("MT4_9","070_4_9","MAT","4","9","9","La ne Satan ga lok tin, “Anaa axap lempanga anaba raba u min mo do una xis tiktikbu mi luvatgulom taram de melamgo rak la una lotu saparav ia.” ");
INSERT INTO mmx_vpl VALUES ("MT4_10","070_4_10","MAT","4","10","10","La ne Iesu ga lok tin, “Satan! Pas kaxat basinge ia. Lovoang Kaala i tong i do, ‘Una lotu saparap ne Moroa, Leeme Silok taram la neni xusuk mun una mumu asu i.’” ");
INSERT INTO mmx_vpl VALUES ("MT4_11","070_4_11","MAT","4","11","11","La ne Satan ga on basinge i, la lubung angelo diga vot la diga lox alolos ne Iesu. ");
INSERT INTO mmx_vpl VALUES ("MT4_12","070_4_12","MAT","4","12","12","Se ne Iesu ga ronga i do ne Jon mo diga lok li i at loogu xokoxo, neni ga vas kaxat bilong uto Galili. ");
INSERT INTO mmx_vpl VALUES ("MT4_13","070_4_13","MAT","4","13","13","Neni goxo nemen to Nasaret, ketla gat pas la ga nemen to Kaprenaum. Na lemenemen gak lok saparap lavatdan kis Galili at lapdopdo at lunep kangka Sebulon la Napitali. ");
INSERT INTO mmx_vpl VALUES ("MT4_14","070_4_14","MAT","4","14","14","Neni ga nemen to Kaprenaum kusu ti lox asoorun levelinga ne Moroa ga vaase asu i at leeme vapaase ali ne Aisaia ga tong i do, ");
INSERT INTO mmx_vpl VALUES ("MT4_15","070_4_15","MAT","4","15","15","“At lenep kangka Sebulon, la lenep kangka Napitali, langas uto at laras mo ik lok, la neni bok lenep kangka saparap Joridan, la lenep silok Galili, na ik lok la limixin kopmen di me Judaia di nemen go. ");
INSERT INTO mmx_vpl VALUES ("MT4_16","070_4_16","MAT","4","16","16","La limixin at na levennep mo dik lok at lamain, dinaba ven langsangan laxasep at ne Moroa. La tinedi limixin labaroonan atdi gara met pam laxasep naba soosoo ridi.” ");
INSERT INTO mmx_vpl VALUES ("MT4_17","070_4_17","MAT","4","17","17","Ga ruka i ap mo levenaleng ne Iesu ga vavang ti limixin keretna, “Mina leeng basinge leveloklok kakapmek atnimi, mila langas ti Linintoo no vana at laxalibet monga ira auret!” ");
INSERT INTO mmx_vpl VALUES ("MT4_18","070_4_18","MAT","4","18","18","At lara laaleng Iesu gat pas saparap lavatdan kis Galili, neni ga ven lueton. Nedu luradi sepsep mat, Saimon (laasen bok teren ne Pita) la neton laasen teren ne Endru. Duga loloa mi laxatkat to at lavatdan kis. ");
INSERT INTO mmx_vpl VALUES ("MT4_19","070_4_19","MAT","4","19","19","La ne Iesu ga lok tidu, “Ude numu, muna emu minia la nia anaba lox ase numu mi langas ti sat kaka limixin i ngan tai mo, nemu mu loloa ka lenmat.” ");
INSERT INTO mmx_vpl VALUES ("MT4_20","070_4_20","MAT","4","20","20","La soso mun duga on basinge laxatkat la duga emu mi ne Iesu. ");
INSERT INTO mmx_vpl VALUES ("MT4_21","070_4_21","MAT","4","21","21","Neni ga vas mu manga loloxon la ga ven manga lara lueton petpes, Jems mi ne Jon, lunitna ne Sebedi. Dugak lok go at lesepang eburu mi ne temen du ne Sebedi. Digak lox agagas li levengkatkat atdi. La ne Iesu ga ro xaka du. ");
INSERT INTO mmx_vpl VALUES ("MT4_22","070_4_22","MAT","4","22","22","La soso mun duga on basinge lesepang eburu mi ne temen du, la duga emu mi ne Iesu. ");
INSERT INTO mmx_vpl VALUES ("MT4_23","070_4_23","MAT","4","23","23","Iesu gat pas at lengkot axap Galili, ga anasa limixin mi levenanasa at ne Moroa ro xeneng at laraogu singising atdi. La ga vavang mi Lagale Lavavang mumu Linintoo, la gak lox aroo limixin basinge laxanasen anmeres axap. ");
INSERT INTO mmx_vpl VALUES ("MT4_24","070_4_24","MAT","4","24","24","Levelinga mumu ne Iesu ga epeseves keneng at lenep silok axap Siria. Kuren la limixin diga lok kaka nedi luvuttadi digak meres mi levenasen anmeres axap, la nedi bok diga suma levesongsongot silok, la nedi luvuttadi mi lubunggas ga suxuna di, la nedi diga ruuna lanmeres diga so asen i do lobomet, la nedi labantuxu atdi ga molo axap. La ne Iesu ga lox aroo nedi axap. ");
INSERT INTO mmx_vpl VALUES ("MT4_25","070_4_25","MAT","4","25","25","Buaang nedi limixin diga mumu asu i, nedi boro Galili la boro bok Dekapolis, la boro Jerusalem, la Judaia, la boro bok at lenep silok Perea. ");
INSERT INTO mmx_vpl VALUES ("MT5_1","070_5_1","MAT","5","1","1","Iesu ga ven nedi buaang limixin la ni ga urut upana at lakaana, ni ga xis kopok, la diga xis to melamgo ren, ");
INSERT INTO mmx_vpl VALUES ("MT5_2","070_5_2","MAT","5","2","2","la neni ga ruka i do na anasa di. ");
INSERT INTO mmx_vpl VALUES ("MT5_3","070_5_3","MAT","5","3","3","Iesu ga lok keretna, “Nedi dikleklen i do labaroonan atdi ik pakes ti ne Moroa, dina momo, mila limixin kerepmo dinaba vubeles at Linintoo no vana at laxalibet. ");
INSERT INTO mmx_vpl VALUES ("MT5_4","070_5_4","MAT","5","4","4","Nedi mo dik lok bukbulu, mila laxakapmek i umsu at na lavatbung menemen, dina momo, mila ne Moroa naba lox amenemen nedi! ");
INSERT INTO mmx_vpl VALUES ("MT5_5","070_5_5","MAT","5","5","5","Nedi dik lox asi di, dina momo, mila ne Moroa naba raba di mi lixitkis to xeneng at Linintoo ren. ");
INSERT INTO mmx_vpl VALUES ("MT5_6","070_5_6","MAT","5","6","6","Nedi di ngaongao ri loklok manmanton, dina momo, mila ne Moroa naba lox epovo mo lavavara atdi. ");
INSERT INTO mmx_vpl VALUES ("MT5_7","070_5_7","MAT","5","7","7","Nedi di lox asuusu lebelen tuntun ti limixin, dina momo, mila ne Moroa naba lox asuusu lebelen tuntun tinedi. ");
INSERT INTO mmx_vpl VALUES ("MT5_8","070_5_8","MAT","5","8","8","Nedi lebelen nedi i dadat aleng, dina momo, mila dinaba ven ne Moroa. ");
INSERT INTO mmx_vpl VALUES ("MT5_9","070_5_9","MAT","5","9","9","Nedi, di lok lumulum kantubu atnedi dit kis munepen, dina momo, mila ne Moroa naba so asen nedi do luvutnitna. ");
INSERT INTO mmx_vpl VALUES ("MT5_10","070_5_10","MAT","5","10","10","Nedi dip kip levesongsongot mumu loklok manmanton at ne Moroa, dina momo, mila dinaba ruuna ka lixitkis to xeneng at Linintoo no vana at laxalibet. ");
INSERT INTO mmx_vpl VALUES ("MT5_11","070_5_11","MAT","5","11","11","Do limixin diba vaase aksaksa rinimi la diba sev asongot nimi la diba paase mumu nimi mi levelinga xaxarang, mina momo, mila nemi limixin tarak. ");
INSERT INTO mmx_vpl VALUES ("MT5_12","070_5_12","MAT","5","12","12","Do dina lox i xuren, mina momo la mina sosoro, mila langsangan luunun minaba ruuna ka i ro vana at laxalibet. Limixin kakapmek megano diga lox asongot lavaeme vapaase ali no diga rooro gano. La kerepmo limixin kakapmek dinaba lox asongot bok nimi.” ");
INSERT INTO mmx_vpl VALUES ("MT5_13","070_5_13","MAT","5","13","13","La ne Iesu ga lok bok tidi, “Nemi mi ngan laxakures ti limixin axap. Ket do lolos at laxakures na xap, kopmen bok ba tangas kusu naba so kakures manga. Kopmen bok ba na epovo xusu dina lok li i at teveluxa, kuren la diba lu xepe mun min la limixin dibat pas abilinga i. ");
INSERT INTO mmx_vpl VALUES ("MT5_14","070_5_14","MAT","5","14","14","Nemi mi ngan laxasep ti limixin at na lavatbung menemen. Lemenemen silok do it kis to mavana at lakaana kopmen na epovo do na lipe. ");
INSERT INTO mmx_vpl VALUES ("MT5_15","070_5_15","MAT","5","15","15","Kopmen teta na sox aros lababao xusu na lok li i ro maxopok at lavatbaaket. Ketla neni i lok li i ro at lenep kasep, kusu laxasep teren naba so epeseves tinedi axap go xeneng at loogu. ");
INSERT INTO mmx_vpl VALUES ("MT5_16","070_5_16","MAT","5","16","16","La kerepmo bok laxasep atnemi na soosoo ro melamgo at limixin, kusu diba reven leveloklok nunuan mik lox i, la diba emi asu mi ne Moroa ne Temen nimi boro vana at laxalibet.” ");
INSERT INTO mmx_vpl VALUES ("MT5_17","070_5_17","MAT","5","17","17","La ne Iesu ga lok bok tidi, “Nemen gat mita nua i do aga vot kusu ana lok pes Laulis Linga at ne Moses la levenanasa at lavaeme vapaase ali. A goxo vot kusu ana lok pes i, ketla aga vot ti lox epovo levelinga ren. ");
INSERT INTO mmx_vpl VALUES ("MT5_18","070_5_18","MAT","5","18","18","A tong tuturun i rinimi. Laxalibet mi lavatbung menemen naba nemen at laxanaleng solo, la ap mo levenaleng kopmen tamangkot lixilik at levelinga keneng at Laulis Linga naba xap asonao, ba se ap mo laaleng levelinga ren naba soorun. ");
INSERT INTO mmx_vpl VALUES ("MT5_19","070_5_19","MAT","5","19","19","Kuren la, do tara i los polo tamangkot lixilik at Laulis Linga, la ia lox ase lentaba vetpes do dina los polo box i, neni naba lixilik tinotno at Linintoo no vana at laxalibet. Do tara i ronga res at Laulis Linga, la ira lox ase bok lentaba vetpes kusu dina ronga res teren, neni naba silok to at Linintoo no vana at laxalibet. ");
INSERT INTO mmx_vpl VALUES ("MT5_20","070_5_20","MAT","5","20","20","A tong i rinimi. Mo do luruptuvuk atnimi noxo lox avukat ti luruptuvuk at luvuttadi loklox ase at Laulis Linga la lubung Parisi, kopmen mi noxo vubeles at Linintoo, no vana at laxalibet.” ");
INSERT INTO mmx_vpl VALUES ("MT5_21","070_5_21","MAT","5","21","21","La ne Iesu ga lok bok, “Miga ronga i do lavalabat atdik gano migomgo diga tong i do, ‘Nemen gat mitap sev amet tadi. La do nege i sev amet taradi, neni naba tu at lavapaase ro melamgo at laradi rongtonga linga.’ ");
INSERT INTO mmx_vpl VALUES ("MT5_22","070_5_22","MAT","5","22","22","Ketla monga ana tong i rinimi do, nege i musak mi neton, neni naba tu at lavapaase ro melamgo at laradi rongtonga linga. La do nege i tong i ri neton do ‘Nenu laradi pis,’ neni naba tu at lavapaase ro melamgo at lixitkis buru at lavanuti sangaun nedi loxongkulao silok at limixin me Israel. La do nege i lok ti neton do ‘Nenu lavanga baulang’, i auret do ne Moroa naba riki i uto xeneng at laxao at lemenemen songsongot. ");
INSERT INTO mmx_vpl VALUES ("MT5_23","070_5_23","MAT","5","23","23","Kuren la, do unat pas kusu una raba letaba ram ti ne Moroa ro at loxonin laplavang, la go ura doma su at netam i emusak minu, ");
INSERT INTO mmx_vpl VALUES ("MT5_24","070_5_24","MAT","5","24","24","una ke xepe be letaba ram go melamgo at loxonin laplavang, la unat pas avot be xusu una lok lumulum eburu mi netam. La melemu ba unamlong la una raba letaba ram ti ne Moroa. ");
INSERT INTO mmx_vpl VALUES ("MT5_25","070_5_25","MAT","5","25","25","Mo do tara na lok ka u ri lavapaase kusu na lok li lumumuat taram, una etangas nunuan min at langa kusu una lok lumulum eburu min. Do kopmen, neni naba lok ka u uto at laradi rongtonga linga, la laradi rongtonga linga naba lok li u at laradi rutu mu, la ni naba lok li u at loogu xokoxo. ");
INSERT INTO mmx_vpl VALUES ("MT5_26","070_5_26","MAT","5","26","26","Nia a tong tuturun i do unabak lok go, naba se rinotno do una un axap lempilas at nom lavapaase.” ");
INSERT INTO mmx_vpl VALUES ("MT5_27","070_5_27","MAT","5","27","27","La ne Iesu ga lok bok tidi, “Miga ronga vam lavapaase diga tong i do, ‘Nemen gat mita elongka mi lavakin at lentaba vetpes.’ ");
INSERT INTO mmx_vpl VALUES ("MT5_28","070_5_28","MAT","5","28","28","Ketla monga ana tong i rinimi, do tara na ven peves at tatkin petpes, i lok ngan neni ia longka vam mi nom latkin to xeneng at lebelen. ");
INSERT INTO mmx_vpl VALUES ("MT5_29","070_5_29","MAT","5","29","29","Do laxatli tino ram na lox u la una subu, una lik gogo su min. I lox avukat tu do una lok pes tenep at labantuxu ram. Lavanga labantuxu axap taram nat pas ti lemenemen songsongot. ");
INSERT INTO mmx_vpl VALUES ("MT5_30","070_5_30","MAT","5","30","30","Mo do lakngam tino na lox u la una lok laxakapmek, una ra korop pes i la una lu min! I lox avukat tu do una lok pes lara lakngam. Lavanga labantuxu axap taram nat pas ti lemenemen songsongot.” ");
INSERT INTO mmx_vpl VALUES ("MT5_31","070_5_31","MAT","5","31","31","La ne Iesu ga lok bok tidi, “Gano diga lox ase bok limixin keretna. Taradi do na soxope latkin teren, ni na malagan taba i mi tevelinga axasep do neni mo na ba korop ta leepot atdu. ");
INSERT INTO mmx_vpl VALUES ("MT5_32","070_5_32","MAT","5","32","32","Ketla monga ana tong i rinimi. Mo do taradi na soxope latkin teren, ketla mo latkin goxo longka, mo laradi i lok latkin teren ira longka, mo do neni ira epot manga at taradi vetpes. La mo laradi bok i epot ka mo latkin, i longka vam mila ik midi eburu mi latkin at laradi vetpes.” ");
INSERT INTO mmx_vpl VALUES ("MT5_33","070_5_33","MAT","5","33","33","La ne Iesu ga lok bok tidi, “Miga ronga bok pam i do diga tong i ri limixin gano do, ‘Nemen mita los polo lavangpangpe atnemi saparap ne Moroa, ketla mina lox epovo lempanga salai mira xaape vam min.’ ");
INSERT INTO mmx_vpl VALUES ("MT5_34","070_5_34","MAT","5","34","34","Ketla monga ana tong i rinimi xeretna. Nemen gat mita lok lavangpangpe mi laasen at ne Moroa. Nemen mita lox amuat tevelinga mi lavangpangpe atnimi la mina tong laxalibet, mila neni loxonin orong at ne Moroa. ");
INSERT INTO mmx_vpl VALUES ("MT5_35","070_5_35","MAT","5","35","35","La nemen mita lox amuat tevelinga atnimi mi lavangpangpe mi lavatbung menemen, mila neni loxot burubut ti luxangkedek teren. La nemen mita lox amuat tevelinga mi lavangpangpe mi ne Jerusalem, mila neni lemenemen silok at ne Moroa. ");
INSERT INTO mmx_vpl VALUES ("MT5_36","070_5_36","MAT","5","36","36","Nemen mita lox amuat tevelinga vangpangpe mi lengkabinim at lempatlak atnimi mila nemi xa mixo epovo xusu miba lok tamang kabinim at lempatlak atnimi nan bun kopla na bibi. ");
INSERT INTO mmx_vpl VALUES ("MT5_37","070_5_37","MAT","5","37","37","Mina tong mene i do, ‘I ruturun!’ kopla ‘Kopmen!’ Toxolinga bok tara na tong i mavana at nai, i laa boro at ne Satan.” ");
INSERT INTO mmx_vpl VALUES ("MT5_38","070_5_38","MAT","5","38","38","La ne Iesu ga lok bok tidi, “Miga ronga bok pam i diga tong i do, ‘Mo do una lik su mi laxatli at tara, laxatli bok taram dina lik su min. La do una sep pit tasangsa at tara, lasangsa bok taram dina rit pir i.’ ");
INSERT INTO mmx_vpl VALUES ("MT5_39","070_5_39","MAT","5","39","39","Ketla monga ana tong i rinimi xeretna. Nemen mita vorang amlong laxakapmek at tara do i lox i ru. Mo do tara na vasa lavapaales tino ram, una ke box i na vasa lavapaales piang taram. ");
INSERT INTO mmx_vpl VALUES ("MT5_40","070_5_40","MAT","5","40","40","La do tara na lok ka u ri lavapaase kusu na li levelinga mumuat mavana ram mumu lavanga singsiga ram, una ke raba box i mi lavanga singsiga silok taram. ");
INSERT INTO mmx_vpl VALUES ("MT5_41","070_5_41","MAT","5","41","41","La do tara at limixin esep na pu soso u do una xip laknixip teren uto vaxalom, unap kiv i uto vaxalom axa. ");
INSERT INTO mmx_vpl VALUES ("MT5_42","070_5_42","MAT","5","42","42","Mo do tara na sing u mi tavanga, una raba i min. La mo do tara i vara i do na lok ka be tavanga ram kusu na gugu min, una siam taba i min.” ");
INSERT INTO mmx_vpl VALUES ("MT5_43","070_5_43","MAT","5","43","43","La ne Iesu ga lok bok tidi, “Miga ronga bok pam i, diga tong i do, ‘Mina balamu larapen tangas atnimi, la mina belengatngas tinedi di munepen minimi.’ ");
INSERT INTO mmx_vpl VALUES ("MT5_44","070_5_44","MAT","5","44","44","Ketla monga ana tong i rinimi xeretna. Mina balamu nedi di munepen minimi, la mina ngising tinedi dik lox asongot nimi, ");
INSERT INTO mmx_vpl VALUES ("MT5_45","070_5_45","MAT","5","45","45","kusu minaba ravasu ngan luvutnitna rinotno at ne Temen nemi ne Moroa no vana at laxalibet, mila neni ga lok laxangking kusu na soosoo mavana at limixin kakapmek i ngan mun tinedi bok limixin nunuan. La im taba bok larakabu ridi dik lok lununuan la tidi bok dik lok laxakapmek. ");
INSERT INTO mmx_vpl VALUES ("MT5_46","070_5_46","MAT","5","46","46","Mo do nemi xa mi balamu xusuk mun nedi di balamu nimi, ne Moroa xopmen noxo raba nimi mi luunun. Limixin kapmek kerekngan luvuttadi loklok ka pilas bok dik lox i na. ");
INSERT INTO mmx_vpl VALUES ("MT5_47","070_5_47","MAT","5","47","47","La mo do mi paase momo mun ti luvutneton nimi, na loklok kopmen lavanga silok, mila limixin dixo nunu at ne Moroa di mumu asu box i na. ");
INSERT INTO mmx_vpl VALUES ("MT5_48","070_5_48","MAT","5","48","48","Kuren la mina nemen manmanton tino kerekngan mun ne Temen nemi no vana at laxalibet in manton tino.” ");
INSERT INTO mmx_vpl VALUES ("MT6_1","070_6_1","MAT","6","1","1","La ne Iesu ga lok bok tidi, “Mina lok tatao alabat nemi, la nemen mita lok leveloklok nunuan to melamgo at limixin kusu dina ven i la diba emi asu minimi. Mo do mina mu asu na loklok, mi noxo lok ka luunun tinimi boro at ne Temen nimi no vana at laxalibet. ");
INSERT INTO mmx_vpl VALUES ("MT6_2","070_6_2","MAT","6","2","2","Kuren la, do mina raba tavanga ri taradi banbalo, nemen mita tong asu i na ro melamgo at limixin axap kerekngan luvuttadi loklok sosolom, dik lox i ro xeneng at laraogu singising la to at larangas. Dik lox i xusu limixin diba emi asu midi. A tong tuturun i rinimi do luunun atdi dira lok ka axap pam i. ");
INSERT INTO mmx_vpl VALUES ("MT6_3","070_6_3","MAT","6","3","3","Ket do mina lok tooro taradi banbalo, mina lox i at langas, nemi xusuk mun miklen i, la nedi dik lox auret nimi di noxoklen i. ");
INSERT INTO mmx_vpl VALUES ("MT6_4","070_6_4","MAT","6","4","4","La kerepmo kopmen tara noxoklen i, ketla ne Temen nimi mene, mo i reven mo leveloklok ik lox alipe, naba raba nimi mi luunun. ");
INSERT INTO mmx_vpl VALUES ("MT6_5","070_6_5","MAT","6","5","5","Do mina ngising, nemen mitak lok ngan luvuttadi loklok sosolom. Di vavara aleng i do dina tu la dina ngising to xeneng at laraogu lotu la to bok at larangas etang kusu limixin diba reven di. A tong tuturun i rinimi do dira lok ka axap pam luunun atdi. ");
INSERT INTO mmx_vpl VALUES ("MT6_6","070_6_6","MAT","6","6","6","Ket do mina vara sing, mina beles uto at leventaogu atnimi la mina sat pe lempatban la mina sing ti ne Temen nimi, mixo epovo mina ven i. La ne Temen nimi i reven lempanga salai i nemen alipe at lemeren limixin, naba raba nimi mi luunun. ");
INSERT INTO mmx_vpl VALUES ("MT6_7","070_6_7","MAT","6","7","7","Keneng at levesingising atnimi, nemen mita tong lengkolinga xopmen tempasuun teren, kerekngan lavamolon di mumu asu i. Di doxoma i do ne Moroa mo naba ronga di mumu levesingising babaalom atdi. ");
INSERT INTO mmx_vpl VALUES ("MT6_8","070_6_8","MAT","6","8","8","Nemen mita mu asu na loklok atdi mila ne Temen nimi ne Moroa iraklen avot pam levenai mik pakes tin, avot ti levesingising atnimi. ");
INSERT INTO mmx_vpl VALUES ("MT6_9","070_6_9","MAT","6","9","9","Do mina sing, mina mu asu i xeretna, ‘Temen nama no vana at laxalibet, mana lok ngangao at laasen taram. ");
INSERT INTO mmx_vpl VALUES ("MT6_10","070_6_10","MAT","6","10","10","Linintoo ram na vot, lavavara ram limixin dina mu asu i nade xopok at na lavatbung menemen, i ngan mun di mu asu i ro vana at laxalibet. ");
INSERT INTO mmx_vpl VALUES ("MT6_11","070_6_11","MAT","6","11","11","Una raba nema mi leveluxa lingina. ");
INSERT INTO mmx_vpl VALUES ("MT6_12","070_6_12","MAT","6","12","12","Doxoma xepe laxakapmek atnema, kerekngan nema ma doxoma xepe laxakapmek atnedi di lox i rinema. ");
INSERT INTO mmx_vpl VALUES ("MT6_13","070_6_13","MAT","6","13","13","Nemen uta lok li nema ri leveloklok tong pen i lolos, ketla unang tanga amlong ka nema basinge ne Satan.’ ");
INSERT INTO mmx_vpl VALUES ("MT6_14","070_6_14","MAT","6","14","14","Mo do mina doxoma xepe laxakapmek limixin di lox i rinimi, ne Temen nimi no vana at laxalibet naba doxoma xepe bok laxakapmek atnimi. ");
INSERT INTO mmx_vpl VALUES ("MT6_15","070_6_15","MAT","6","15","15","Ket do mixo doxoma xepe laxakapmek at limixin petpes, ne Temen nimi ro vana at laxalibet noxo doxoma xepe laxakapmek atnimi.” ");
INSERT INTO mmx_vpl VALUES ("MT6_16","070_6_16","MAT","6","16","16","La ne Iesu ga lok bok tidi, “La do mina mun anan, nemen gat mita ven bukbulu, i ngan luvuttadi loklok sosolom di mumu asu i. Dit pas saasaa ro xantubu at limixin kusu limixin diba reven lemeren di do nedi mo di mun anan. A tong tuturun i rinimi do luunun atdi, dira lok ka axap pam i. ");
INSERT INTO mmx_vpl VALUES ("MT6_17","070_6_17","MAT","6","17","17","Do mina mun anan, mina saba nunuan lempatlak atnimi mi ladan momonok at la olip la mina gos avukat lenmeren nimi, ");
INSERT INTO mmx_vpl VALUES ("MT6_18","070_6_18","MAT","6","18","18","kusu nedi vetpes di noxoklen i do nemi mo mi mun anan. Ketla ne Temen nimi, kopmen mina epovo na ven i, neni xusuk mun nabaklen i. La ne Temen nimi, mo i reven lempanga salai i nemen alipe at lemeren limixin, naba raba nimi mi luunun.” ");
INSERT INTO mmx_vpl VALUES ("MT6_19","070_6_19","MAT","6","19","19","La ne Iesu ga lok bok tidi, “Nemen mita lili gat lapnovos tinemi nade xopok at na lavatkangka, mila i epovo do laxanuvis naba an asonao mun i, la lamamao tas na long i la ba lok kapmek, la luvuttadi xipkip pilo dinaba das beles ukeneng at leventaogu atnimi la dina xip pilo ka i. ");
INSERT INTO mmx_vpl VALUES ("MT6_20","070_6_20","MAT","6","20","20","Ketla mina lok leveloklok nunuan naba lok ngan lapnovos tinimi ro vana at laxalibet, mo go laxanuvis mi lamamao tas noxo lok kapmex i, la luvuttadi xipkip pilo di noxo das beles ukeneng la dina xip pilo xaka i. ");
INSERT INTO mmx_vpl VALUES ("MT6_21","070_6_21","MAT","6","21","21","Mina lox i xuren mila lebelen nimi nabaplivi mu mo lapnovos atnimi.” ");
INSERT INTO mmx_vpl VALUES ("MT6_22","070_6_22","MAT","6","22","22","La ne Iesu ga lok bok keretna, “Lengkatli atnimi i ngan laxasep ti lorooro atnimi. Dola lengkatli atnimi na reven pupuse ri lempanga avukat, lorooro atnimi naba umsu mi laxasep. ");
INSERT INTO mmx_vpl VALUES ("MT6_23","070_6_23","MAT","6","23","23","Ket do lengkatli atnimi na reven pupuse ri lempanga xapmek, lorooro atnimi naba umsu mi lamain. Kuren la, mo do laxasep kopmen nak lok keneng at lorooro atnimi, lamain i silok aleng nabak lok keneng teren. ");
INSERT INTO mmx_vpl VALUES ("MT6_24","070_6_24","MAT","6","24","24","Kopmen tara i epovo na nemen ngan lasaxaruki at legepu radi. Neni naba belengatngas ti lara la na vavara mo lara. Neni naba ruturun ti lara, la ni na sok tixirixes mo lara. Kopmen na epovo do tara na nemen ngan lasaxaruki at ne Moroa la lebelen na ngaongao mu lempilas. ");
INSERT INTO mmx_vpl VALUES ("MT6_25","070_6_25","MAT","6","25","25","Kuren la a tong i rinimi do nemen gat mita doma solo mu lempanga anan mi lengkadan mik pakes tin, kopla lempanga singsiga kusu ti labantuxu atnimi. Kereva, lempanga anan i silok ti lorooro la lempanga singsiga i silok ti labantuxu? ");
INSERT INTO mmx_vpl VALUES ("MT6_26","070_6_26","MAT","6","26","26","Mina ven lavapixa dip tava saasaa, dixotlotlo tevenit panga, la dixo lili buru levempeven una do ik mukun, la dixo lili i ro at levempovos pixa atdi. Ketla ne Temen nemi no vana at laxalibet i reven tatao nedi. La nemi mi silok aleng ti lavapixa. ");
INSERT INTO mmx_vpl VALUES ("MT6_27","070_6_27","MAT","6","27","27","Kopmen tara na epovo do na lox epasum toxot ti lorooro ren mo do neni na bulu mu i. ");
INSERT INTO mmx_vpl VALUES ("MT6_28","070_6_28","MAT","6","28","28","La tila mik bulu mu amisik lempanga singsiga? Mina ven be lempusuvus aaxa di suusu. Kopmen dina gugu la dinak sok etang lempanga singsiga ridi. ");
INSERT INTO mmx_vpl VALUES ("MT6_29","070_6_29","MAT","6","29","29","Ketla a tong i do loorong ne Solomon mi langsangan lapnovos teren ga ruuna lempanga singsiga kopmen goxo nunuan aleng ti nom lempusuvus. ");
INSERT INTO mmx_vpl VALUES ("MT6_30","070_6_30","MAT","6","30","30","Ne Moroa xa ik paxasiga lempivilis aaxa, mo lempivilis i rooro mun lingina la kantamak manga ira mada si, la dira kotos i ro at laxao. Ketla neni naba lox angtang mu aleng nimi kusu na vaxasiga nimi. Lununu atnemi saparap ne Moroa i lixilik mun. ");
INSERT INTO mmx_vpl VALUES ("MT6_31","070_6_31","MAT","6","31","31","Kuren la nemen mita bulu la mina lok do, ‘Leveluxa ridik naba laa meva?’ kopla ‘Lengkadan tidik naba laa meva?’ kopla ‘Lempanga singsiga ridik naba laa meva?’ ");
INSERT INTO mmx_vpl VALUES ("MT6_32","070_6_32","MAT","6","32","32","Nedi xopmen dina nunu at ne Moroa dik bulu mu lempanga xeretna. Ne Temen nemi no vana at laxalibet ikleklen i do mik pakes ti na lempanga. ");
INSERT INTO mmx_vpl VALUES ("MT6_33","070_6_33","MAT","6","33","33","Ketla mavana at lempanga axap, mina lolos avot be ri puse ka Linintoo at ne Moroa la leveloklok manmanton teren, la neni naba raba bok nemi mi nom lempanga mik pakes tin. ");
INSERT INTO mmx_vpl VALUES ("MT6_34","070_6_34","MAT","6","34","34","Kuren la nemen mita bulu mu mo lempanga ba ravasu ap mo laaleng kantamak, mila levenainbulu mo bak lok ti laaleng kantamak. La levenainbulu at leges aleng i epovo ri mo laaleng.” ");
INSERT INTO mmx_vpl VALUES ("MT7_1","070_7_1","MAT","7","1","1","La ne Iesu ga lok bok keretna, “Nemen mita ila mumu loklok at tentaba vetpes, kusu ne Moroa noxo ila mumu loklok atnimi. ");
INSERT INTO mmx_vpl VALUES ("MT7_2","070_7_2","MAT","7","2","2","Mo do mina ila mumu loklok at tentaba vetpes, ne Moroa naba ila mumu nimi ap mo mun langas. La lumumuat mi lok li mavana atnedi lentaba vetpes, neni mun i nom ne Moroa naba raba nimi min.” ");
INSERT INTO mmx_vpl VALUES ("MT7_3","070_7_3","MAT","7","3","3","La ne Iesu ga paase poovo bok keretna, “Nemen mita reven ti nom levendon i nemen at laxatli at neton nimi, la nemi xa kopmen mina doma mu levengkonuna ik lok pe lengkatli atnimi. ");
INSERT INTO mmx_vpl VALUES ("MT7_4","070_7_4","MAT","7","4","4","Mi tong i ri neton nimi keretna, ‘Netak, una mulus tia kusu ana lok pes nom levendon at laxatli ram,’ ketla nemi xa xopmen mina ven kibis levengkonuna ik lok pe lengkatli atnemi getgesara. ");
INSERT INTO mmx_vpl VALUES ("MT7_5","070_7_5","MAT","7","5","5","Nemi luvuttadi loklok sosolom. Mina lok pes avot nom levengkonuna ik lok pe lengkatli atnimi, la melemu ba minaba ven avukat ba i xusu mina lok pes ba levendon no at laxatli at neton nimi. ");
INSERT INTO mmx_vpl VALUES ("MT7_6","070_7_6","MAT","7","6","6","Nemen gat mita raba lubungman mi lempanga i xaala. Mo do mina lox i xuren, dinaba rem gili mu nimi la diba at koxorop nimi. La nemen mita lu raba lababo mi leven peal (pearl) atnimi. Mo do mina lox i xuren, dinaba but axangka i mi lengkangkedek atdi.” ");
INSERT INTO mmx_vpl VALUES ("MT7_7","070_7_7","MAT","7","7","7","La ne Iesu ga lok bok keretna, “Mina ngising, la minaba ruuna xaka i. Mina puse, la minaba vuse xaka i. Minap dipdi, la lumusmaragu naba rem suang tinimi. ");
INSERT INTO mmx_vpl VALUES ("MT7_8","070_7_8","MAT","7","8","8","Mila do mina ngising ne Moroa, minaba lok kaka i. La do nemi mina puse, minaba vuse ka i, la lumusmaragu naba rem suang tinemi mi dipdi. ");
INSERT INTO mmx_vpl VALUES ("MT7_9","070_7_9","MAT","7","9","9","Kereva, i epovo do ne temen tamdak na raba ne nitna mi toxonuat, modo neni na sing ti toxongkide? ");
INSERT INTO mmx_vpl VALUES ("MT7_10","070_7_10","MAT","7","10","10","Kopla i epovo kusu neni na raba i mi tisii mo do neni na sing ti temat? ");
INSERT INTO mmx_vpl VALUES ("MT7_11","070_7_11","MAT","7","11","11","Keke i do nemi limixin bilinga, ketla mikleklen i do mim taba laxamdak mi laxaalik atnimi mi lempanga nunuan. La kerepmo i epovo rinotno do ne Temen nimi ro vana at laxalibet naba lok momo aleng ti raba bok lempanga nunuan tinedi di ngising tin. ");
INSERT INTO mmx_vpl VALUES ("MT7_12","070_7_12","MAT","7","12","12","Leveloklox axap mina lox i ri lentaba vetpes, na lok ngan mun leveloklok mi vara i do dina lox i rinimi. Anai ni lavasuun tinotno at Laulis Linga at ne Moses la levelinga at lavaeme vapaase ali.” ");
INSERT INTO mmx_vpl VALUES ("MT7_13","070_7_13","MAT","7","13","13","La ne Iesu ga lok bok, “Mina beles keneng at lumusmaragu i veleot kusu ti lok ka lorooro, mila lumusmaragu uto at lemenemen songsongot i repalas la langas ugo at lemenemen songsongot kopmen na lolos ti mumu asu i, la buaang nedi limixin di pubeles teren. ");
INSERT INTO mmx_vpl VALUES ("MT7_14","070_7_14","MAT","7","14","14","Lumusmaragu uto at lorooro ni i veleot mun la langas tin i lolos aleng tino la ixo buaang nedi limixin di pubeles teren.” ");
INSERT INTO mmx_vpl VALUES ("MT7_15","070_7_15","MAT","7","15","15","La ne Iesu ga lok bok, “Mina lok tatao nemi mumu loklok atnedi lavaeme vapaase ali xaxarang. Diba vot pasa nimi mi levelinga xaxarang la diba tong i do nedi luvuttadi at ne Moroa. Ketla di lok ngan lempatman atat, di siga lempanga singsiga diga lox i mi lengkabinim at levesipsip kusu dina xarang limixin. ");
INSERT INTO mmx_vpl VALUES ("MT7_16","070_7_16","MAT","7","16","16","Miba ven kibis nedi mi levempipisik at lorooro atnedi. Ixo epovo do mina dik ka tempeven una nunuan boro at taban gagas, la ixo epovo do miba dik ka tempeven una at loxoon boro at tabaniles. ");
INSERT INTO mmx_vpl VALUES ("MT7_17","070_7_17","MAT","7","17","17","La kerepmo luuna nunuan i pisik lempeven una nunuan, ketla luuna mamao i pisik lempeven una mamao. ");
INSERT INTO mmx_vpl VALUES ("MT7_18","070_7_18","MAT","7","18","18","Luuna nunuan ixo epovo do na visik tempeven una mamao, la luuna mamao ixo epovo do na visik tempeven una nunuan. ");
INSERT INTO mmx_vpl VALUES ("MT7_19","070_7_19","MAT","7","19","19","Larauna axap do dixo pisik nunuan, di tara korop asi nedi la di lulu arup midi ro at laxao. ");
INSERT INTO mmx_vpl VALUES ("MT7_20","070_7_20","MAT","7","20","20","Kuren la miba ven kisip lavaeme vapaase ali xaxarang mi levempipisik at lorooro atdi.” ");
INSERT INTO mmx_vpl VALUES ("MT7_21","070_7_21","MAT","7","21","21","La ne Iesu ga lok bok tidi, “Limixin dinaba tong ia do Leeme Silok, Leeme Silok. Ketla kopmen nedi axap diba beles at Linintoo no vana at laxalibet. Nedi xusuk mun di mumu asu lavavara at ne Tamak, dinaba vubeles teren. ");
INSERT INTO mmx_vpl VALUES ("MT7_22","070_7_22","MAT","7","22","22","At laaleng ete buaang nedi limixin dinaba lok tia, ‘Leeme Silok, Leeme Silok, maga paase ali ri limixin mi laasen taram, la maga riki asu lubunggas basinge limixin mi laasen taram, la maga lok buaang laxampanga sangsangu mi laasen taram.’ ");
INSERT INTO mmx_vpl VALUES ("MT7_23","070_7_23","MAT","7","23","23","Melemu anaba vaase ridi xeretna, ‘Nia xopmen tinotno anaklen nimi. Uto nimi basinge ia, nemi limixin kakapmek.’” ");
INSERT INTO mmx_vpl VALUES ("MT7_24","070_7_24","MAT","7","24","24","La ne Iesu ga lok bok tidi, “Kuren la, do tara i ronga na lempapaase rak la i ronga res mu i, neni i lok ngan laradi leklen ga xip loogu ren la ga sev asi lemet ukopok tinotno la ga lok nom loogu ren pana at laxanuat. ");
INSERT INTO mmx_vpl VALUES ("MT7_25","070_7_25","MAT","7","25","25","Larakabu ga vot, la ladanut ga sen, la lamanman gat mas lolos mo loogu, ketla loogu goxo rem sup, mila ni gasbo i mi laxanuat. ");
INSERT INTO mmx_vpl VALUES ("MT7_26","070_7_26","MAT","7","26","26","Ket do lara i ronga na levelinga rak la kopmen ni na mu asu i, neni i lok ngan laradi tangtangku, ga xip loogu ren la gasbo pe i mi laxapulang. ");
INSERT INTO mmx_vpl VALUES ("MT7_27","070_7_27","MAT","7","27","27","Larakabu ga vot, la ladanut ga sen at laradan, la lamanman ga vot lolos at nom loogu, la loogu ga rem sup la ga rem utut axap.” ");
INSERT INTO mmx_vpl VALUES ("MT7_28","070_7_28","MAT","7","28","28","Se ne Iesu ga vaase axap na lempapaase, buaang nedi limixin diga sangu aleng at levenanasa ren, ");
INSERT INTO mmx_vpl VALUES ("MT7_29","070_7_29","MAT","7","29","29","mila neni ga anasa di, la levelinga ren ga mumuat, neni xopmen goxo anasa ngan luvuttadi loklox ase at Laulis Linga. ");
INSERT INTO mmx_vpl VALUES ("MT8_1","070_8_1","MAT","8","1","1","Iesu ga si boro vana at lakaana la buaang limixin diga emu min. ");
INSERT INTO mmx_vpl VALUES ("MT8_2","070_8_2","MAT","8","2","2","La lara laradi ga meres mi lanmeres gu (leprosy) ga vot pasa ne Iesu la ga xis tiktikbu mi luvatgulom teren la ga sing i, “Leeme Silok. Mo do u vara i, una lox aroo ia.” ");
INSERT INTO mmx_vpl VALUES ("MT8_3","070_8_3","MAT","8","3","3","Iesu ga song asu mi lekngen la ga long tu ren, la ga lok tin, “A vara i. Lanmeres taram na xap ta.” La soso mun mo lanmeres ga xap basinge mo laradi. ");
INSERT INTO mmx_vpl VALUES ("MT8_4","070_8_4","MAT","8","4","4","La ne Iesu ga lok tin, “Nemen uta tong box i na ri tara, ketla unat pas uto at lamaasa, la neni na ven mumu u. Melemu una lok laramtaba ram ti ne Moroa ngan ne Moses ga tong i, kusu ti lox asuusu i ri limixin axap do nenu mo ura lox avukat ta.” ");
INSERT INTO mmx_vpl VALUES ("MT8_5","070_8_5","MAT","8","5","5","Iesu ga vubeles at lemenemen Kaprenaum, la lara laasesep at limixin esep boro Rom ga vot pasa i la ga sing i ri loklok tooro xeretna, ");
INSERT INTO mmx_vpl VALUES ("MT8_6","070_8_6","MAT","8","6","6","“Leeme Silok. Lasaxaruki rak no ik midi ro at loogu rak. Lengkot axap teren i molo la ing songot aleng.” ");
INSERT INTO mmx_vpl VALUES ("MT8_7","070_8_7","MAT","8","7","7","La ne Iesu ga lok tin, “Nia anat pas ti lox aroo i.” ");
INSERT INTO mmx_vpl VALUES ("MT8_8","070_8_8","MAT","8","8","8","La mo laasesep ga lok tin keretna, “Leeme Silok, nenu Leeme Silok la ixo lox avukat do una beles at loogu rak. Ketla una tong mun i la lasaxaruki rak naba lox avukat. ");
INSERT INTO mmx_vpl VALUES ("MT8_9","070_8_9","MAT","8","9","9","Nenia aklen i do nenu u epovo ri lox i na mila nenia bok a nemen maxopok at lentaba amgomgo rak la lentaba bok di nemen maxopok tarak. La mo do a lok ti tara, ‘Unat pas,’ neni nabat pas. Do a lok ti tara, ‘Ude u,’ neni nabat pas saparav ia. La do a lok ti lasaxaruki rak, ‘Una lox i na,’ la neni naba lox i.” ");
INSERT INTO mmx_vpl VALUES ("MT8_10","070_8_10","MAT","8","10","10","Se ne Iesu ga ronga i na, ni ga sangu aleng la ga lok tinedi diga emu min, “Nia a tong tuturun i. Keneng at lengkot axap Israel, a goxo ven tara, lununu ren i silok ngan i na. ");
INSERT INTO mmx_vpl VALUES ("MT8_11","070_8_11","MAT","8","11","11","Nia a tong i rinimi do buaang limixin dinaba laa boro at lengkot axap at na lavatbung menemen la dinaba xis kopok eburu mi ne Abaram, Aisak la ne Jakop at laanan tarak to xeneng at Linintoo no vana at laxalibet. ");
INSERT INTO mmx_vpl VALUES ("MT8_12","070_8_12","MAT","8","12","12","Ketla limixin me Judaia, avot be diga nemen ngan lavaanat at Linintoo, ketla ne Moroa naba lu asu midi uto at lamain bonot la mo go dinabang teng aleng la dinaba rungur igisa.” ");
INSERT INTO mmx_vpl VALUES ("MT8_13","070_8_13","MAT","8","13","13","La ne Iesu ga lok ti mo laasesep, “Unamlong uto xolonu ram. Lasaxaruki ram naba lox avukat kerekngan lununu ram.” La lasaxaruki ren ga lox avukat ap mo mun loxonaleng. ");
INSERT INTO mmx_vpl VALUES ("MT8_14","070_8_14","MAT","8","14","14","Iesu ga rupot to at loogu at ne Pita, la ni ga ven luvutulom at ne Pita gak midi at loora, ga meres mi liplivi. ");
INSERT INTO mmx_vpl VALUES ("MT8_15","070_8_15","MAT","8","15","15","Neni ga long tu at lekngen la liplivi ga on basinge i, la ni ga xatu kaxat upana la ga lox agagas leveluxa rin. ");
INSERT INTO mmx_vpl VALUES ("MT8_16","070_8_16","MAT","8","16","16","Ga ukantinao, limixin diga lam ka larapen tangas atdi uto at ne Iesu, nedi lubunggas ga suxuna di. La ne Iesu ga paase lengkolinga, la ni ga riki asu lubunggas basinge di. La neni ga lox aroo limixin axap digak meres. ");
INSERT INTO mmx_vpl VALUES ("MT8_17","070_8_17","MAT","8","17","17","Kerepmo ne Iesu ga lox asoorun levelinga at leeme vapaase ali ne Aisaia, i lok keretna; “Neni ga lox alolos nama basinge levenainmolo la ga lox aroo nama basinge levenanmeres.” ");
INSERT INTO mmx_vpl VALUES ("MT8_18","070_8_18","MAT","8","18","18","Se ne Iesu ga ven buaang limixin digak lok saparav i, ni ga tong i ri lavaun pinivu ren do dina sen polo lavatdan kis uto at lenep meo. ");
INSERT INTO mmx_vpl VALUES ("MT8_19","070_8_19","MAT","8","19","19","La lara laradi loklox ase at Laulis Linga ga vot pasa i la ga lok tin, “Leeme loklox ase, nia ana emu minu uto at lengkot axap ut pas uve.” ");
INSERT INTO mmx_vpl VALUES ("MT8_20","070_8_20","MAT","8","20","20","La ne Iesu ga lok tin, “Lubungman sio di ruuna lengkot mikmidi atdi, la lavapixa di ruuna levempotpos atdi, ketla nenia, Laradi Mevana, axo ruuna temenemen kusu tia rik midi la na lok mamana ren.” ");
INSERT INTO mmx_vpl VALUES ("MT8_21","070_8_21","MAT","8","21","21","La lara laradi vetpes, lara at lavaun pinivu ren ga lok tin, “Leeme Silok. Una ke xepe be ia, kusu anat pas la anak mit ne tamak.” ");
INSERT INTO mmx_vpl VALUES ("MT8_22","070_8_22","MAT","8","22","22","Ketla ne Iesu ga lok tin, “Una mumu asu ia, la una ke laxampanga met dinak mikmit luvuttadi met.” ");
INSERT INTO mmx_vpl VALUES ("MT8_23","070_8_23","MAT","8","23","23","La ne Iesu ga los kas at lesepang eburu mi lavaun pinivu ren la diga sen kaxat. ");
INSERT INTO mmx_vpl VALUES ("MT8_24","070_8_24","MAT","8","24","24","La soso mun langsangan lamanman ga mas lolos mo lavatdan kis, la ga auret do lesepang gita dong si. Ketla ne Iesu mo ga unga. ");
INSERT INTO mmx_vpl VALUES ("MT8_25","070_8_25","MAT","8","25","25","La lavaun pinivu diga vot pasa ne Iesu la diga lox aus i la diga lok, “Leeme Silok, una lox aroo dik, ata seeve nga na.” ");
INSERT INTO mmx_vpl VALUES ("MT8_26","070_8_26","MAT","8","26","26","La ni ga lok tidi, “Kereva, kopmen tununu atnimi? Mi marat tila?” La ni ga xatu kaxat la ga vaase lolos pe lamanman mi lavatdan kis la duga lox atnaasan la langsangan lenmila ga nemen ta. ");
INSERT INTO mmx_vpl VALUES ("MT8_27","070_8_27","MAT","8","27","27","La diga sangu aleng la diga lok, “Laradi salai na? I vaase sok lamanman mi lavatdan kis la dura ronga res teren.” ");
INSERT INTO mmx_vpl VALUES ("MT8_28","070_8_28","MAT","8","28","28","Se ne Iesu eburu mi lavaun pinivu ren diga vot to at lenep meo, diga oso ro at lenep silok Gadarin, la legepu radi duga laa boro at larabuang, limixin me go digak mikmit labarongan e, lubunggas ga nemen atdu. La duga ekip tangarang mi ne Iesu. Nedu luradi sepsep la limixin ap mo lenep silok di goxot pas ti mo lenep. ");
INSERT INTO mmx_vpl VALUES ("MT8_29","070_8_29","MAT","8","29","29","La duga xup ti ne Iesu xeretna, “Nitna ne Moroa. Lavanga salai u vara na lox i rinama? Kereva, u vot de xusu una lox asongot nama avot ti laaleng ete?” ");
INSERT INTO mmx_vpl VALUES ("MT8_30","070_8_30","MAT","8","30","30","Buaang laxanbo mo diga nemen to vaxalom lixilik, diga anan. ");
INSERT INTO mmx_vpl VALUES ("MT8_31","070_8_31","MAT","8","31","31","La lubunggas diga sing ne Iesu, “Do una riki asu nama basinge na luradi, una riki abeles nama ri nom laxanbo.” ");
INSERT INTO mmx_vpl VALUES ("MT8_32","070_8_32","MAT","8","32","32","La ni ga lok tidi, “Mina vas su uto.” La diga sixisu ap mo luradi la diga vubeles ap mo laxanbo la nedi axap nom laxanbo diga sixisi at lakaana la diga los tup ukopok at lavatdan kis la diga xong axap. ");
INSERT INTO mmx_vpl VALUES ("MT8_33","070_8_33","MAT","8","33","33","La nedi mo luvuttadi digak lok tatao laxanbo, diga ven i na. La diga sixit kaxat uto ap mo lemenemen. La diga tong na lavanga ri mo limixin, la diga tong bok mo lavanga ne Iesu ga lox i ri mo luradi. ");
INSERT INTO mmx_vpl VALUES ("MT8_34","070_8_34","MAT","8","34","34","La limixin axap ap mo lemenemen diga vas su la diga vot pasa ne Iesu. Se diga ven i, diga sing i do ni na on basinge mo lenep silok atdi. ");
INSERT INTO mmx_vpl VALUES ("MT9_1","070_9_1","MAT","9","1","1","La ne Iesu mi lavaun pinivu ren diga los kas at lesepang la diga sen kaxat la diga rupot to at lemenemen at ne Iesu. ");
INSERT INTO mmx_vpl VALUES ("MT9_2","070_9_2","MAT","9","2","2","Lentaba luvuttadi digap kip lara laradi mi loora, labantuxu ren ga molo axap la diga vot pasa ne Iesu. Se ne Iesu ga ven kibis lununu atdi, ni ga lok ti mo laradi mekmeres keretna, “Nuruk, una lolos. Leveloklok kakapmek axap taram, a doxoma xepe i.” ");
INSERT INTO mmx_vpl VALUES ("MT9_3","070_9_3","MAT","9","3","3","Lentaba luvuttadi loklox ase at Laulis Linga diga ronga i na la diga epaase xantubu atdi xeretna, “Na laradi i paase vupu ri ne Moroa.” ");
INSERT INTO mmx_vpl VALUES ("MT9_4","070_9_4","MAT","9","4","4","Iesu gaklen levendoxoma atdi la ga lok tidi xeretna, “Tila levendoxoma atnimi i umsu mi laxapmek mumu na lavanga? ");
INSERT INTO mmx_vpl VALUES ("MT9_5","070_9_5","MAT","9","5","5","Ua levelinga kopmen na lolos ti tong i? Leveloklok kakapmek taram ara doxoma xepe vam i, kopla ana tong i do, katu kaxat la unat pas? ");
INSERT INTO mmx_vpl VALUES ("MT9_6","070_9_6","MAT","9","6","6","Ketla a vara minaklen i do nenia, Laradi Mevana, a ruuna lolos at na lavatbung menemen kusu ti doxoma xepe leveloklok kakapmek.” La ne Iesu ga vaase bok ti mo laradi xeretna, “A tong i ru, una xatu upana la una xip kaka loora ram la una vas kaxat uto xolonu.” ");
INSERT INTO mmx_vpl VALUES ("MT9_7","070_9_7","MAT","9","7","7","La mo laradi ga xatu kaxat la gat pas uto xolonu. ");
INSERT INTO mmx_vpl VALUES ("MT9_8","070_9_8","MAT","9","8","8","Se mo limixin axap diga ven i na, diga lingun, la diga emi asu mi ne Moroa, mo ga raba lolos kerepmo ti limixin. ");
INSERT INTO mmx_vpl VALUES ("MT9_9","070_9_9","MAT","9","9","9","Iesu ga vas kaxat basinge mo lenep la ni ga ven lara laradi, laasen teren ne Metiu, mo gat kis at loogu xekepe pilas. La ne Iesu ga lok tin, “Una mumu asu ia.” La ne Metiu ga xatu upana la ga mumu asu i. ");
INSERT INTO mmx_vpl VALUES ("MT9_10","070_9_10","MAT","9","10","10","La ne Iesu gat kis at laanan to xeneng at loogu at ne Metiu la buaang atnedi luvuttadi loklok ka pilas, la lentaba limixin kakapmek bok diga rupot. La diga anan eburu mi ne Iesu la lavaun pinivu ren. ");
INSERT INTO mmx_vpl VALUES ("MT9_11","070_9_11","MAT","9","11","11","Se lubung Parisi diga ven i na, diga sue lavaun pinivu ren keretna, “Tila leeme loklox ase atnimi i anan eburu mi limixin loklok ka pilas la limixin kakapmek?” ");
INSERT INTO mmx_vpl VALUES ("MT9_12","070_9_12","MAT","9","12","12","Iesu ga ronga i nom la ga lok tidi xeretna, “Limixin di lox avukat, kopmen dinak pakes ti loklok tooro, ketla nedi xusuk mun dik meres. ");
INSERT INTO mmx_vpl VALUES ("MT9_13","070_9_13","MAT","9","13","13","La minat pas la minaklen ka lavasuun at na levelinga keneng at Lovoang Kaala i lok keretna, ‘Nia axopara levelaplavang, a vara i xusu mina lox asuusu lebelen tuntun.’ Nia aga rupot kusu ti ro xaka limixin bilinga kusu dina leeng, la kopmen nia a goxo rupot kusu tinedi limixin manmanton.” ");
INSERT INTO mmx_vpl VALUES ("MT9_14","070_9_14","MAT","9","14","14","Lavaun pinivu at ne Jon, laradi sep susu, diga vot pasa ne Iesu la diga sue i, “Nema mi lubung Parisi ma mun anan amisik, ketla lavaun pinivu ram kopmen dina mun anan. Ua lavasuun teren?” ");
INSERT INTO mmx_vpl VALUES ("MT9_15","070_9_15","MAT","9","15","15","Iesu ga vorang i ridi mi lavapaase poovo xeretna, “At loklox anarong at leepot, lentaba at laradi epot di noxo bulu mila laradi epot move ik lok eburu midi. Ketla laaleng mo naba rupot la limixin petpes dinaba lam ka laradi epot basinge lentaba ren, la dina mun anan ba ap mo levenaleng.” ");
INSERT INTO mmx_vpl VALUES ("MT9_16","070_9_16","MAT","9","16","16","La ne Iesu ga vaase bok tidi mi lavapaase poovo xeretna, “Kopmen teta na balais ka loxontamon maxat kusu na sok gatgat pe lamamara at labantamon maut min. Mo do neni na lox i xuren, labantamon maxat ira lok kapmek pam la kopmen na epovo bok ba kusu na lok tavanga min. La nom loxontamon maxat noxo epovo xusu na lok pe avukat lamamara at loxontamon maut.” ");
INSERT INTO mmx_vpl VALUES ("MT9_17","070_9_17","MAT","9","17","17","La ne Iesu ga vaase bok tidi mi lavapaase poovo. Ni ga lok keretna, “Kopmen tara na soli li laxadan vaen maxat uto xeneng ti labantuxu at lavatme i maut pam. Mo do neni na lox i xuren, mo labantuxu ba remdas la laxadan vaen naba soli su axap, la labantuxu maut naba lok kapmek. Laxadan vaen maxat mina soli li i at labantuxu maxat, la kopmen tempanga ba lok kapmek.” ");
INSERT INTO mmx_vpl VALUES ("MT9_18","070_9_18","MAT","9","18","18","Ap mo mun loxonaleng ne Iesu ga tong i na, lara laradi ga vot, neni lara atnedi luvuttadi amgomgo at loogu singising ap mo lemenemen. Ni ga xis tiktikbu mi luvatgulom teren saparap luxangkedek at ne Iesu la ga lok tin, “Anaa vam, loolik tarak i met. Ketla una ven be i la una long tu ren la ni naba roo.” ");
INSERT INTO mmx_vpl VALUES ("MT9_19","070_9_19","MAT","9","19","19","La ne Iesu ga xatu kaxat la ga emu min, la lavaun pinivu bok teren. ");
INSERT INTO mmx_vpl VALUES ("MT9_20","070_9_20","MAT","9","20","20","La lara latkin mo ga nemen. Lanmeres gaaling gak lok teren at levenaleng amisik. Ni ga ruuna nom lanmeres at lasangaun mi legepu maares. Ni ga vas mu ne Iesu ro melemu la ga long tu at lungusungus at lavanga singsiga ren. ");
INSERT INTO mmx_vpl VALUES ("MT9_21","070_9_21","MAT","9","21","21","Ni ga doma i do neni na long tu at lavanga singsiga ren, neni ba lox avukat. ");
INSERT INTO mmx_vpl VALUES ("MT9_22","070_9_22","MAT","9","22","22","La ne Iesu ga rem gili la ga ven kora ka i. La ga lok tin, “Latkin. Una lolos. Lununu ram ira lox avukat pam u.” La ap mo mun loxonaleng mo latkin ga lox avukat ta. ");
INSERT INTO mmx_vpl VALUES ("MT9_23","070_9_23","MAT","9","23","23","Se ne Iesu ga vubeles at loogu ap mo laradi gomgo, ni ga ven buaang limixin, lentaba diga mas lengkaatu atdi, la lentaba digang teng la diga saxaanu ap mo loolik. ");
INSERT INTO mmx_vpl VALUES ("MT9_24","070_9_24","MAT","9","24","24","Ni ga lok tidi, “Uto nimi. Loolik kopmen na met, neni i unga mun.” Ketla diga lok sese i. ");
INSERT INTO mmx_vpl VALUES ("MT9_25","070_9_25","MAT","9","25","25","La diga vas su ukamang, la ne Iesu ga vubeles la ga ranga at lekngen loolik la ga lox axatu kaxar i. ");
INSERT INTO mmx_vpl VALUES ("MT9_26","070_9_26","MAT","9","26","26","La levelinga mumu i na ga epeseves at lengkot axap ap mo lenep silok. ");
INSERT INTO mmx_vpl VALUES ("MT9_27","070_9_27","MAT","9","27","27","La ne Iesu ga vas kaxat la at lavatpas teren, legepu radi levengkatli atdu ga main, duga mumu i la duga toro keretna, “Livisik li at ne Devit. Una lox asuusu lebelen tuntun tinama.” ");
INSERT INTO mmx_vpl VALUES ("MT9_28","070_9_28","MAT","9","28","28","La ne Iesu ga vubeles at lara loogu la mo luradi ga vot pasa i, la ni ga lok tidu xeretna, “Kereva, mu nunu do nenia a epovo na lox avukat levengkatli atnumu?” Duga vorang i rin keretna, “Laaba, Leeme Silok.” ");
INSERT INTO mmx_vpl VALUES ("MT9_29","070_9_29","MAT","9","29","29","La ne Iesu ga long tu at levengkatli atdu la ga lok tidu, “Nemu mu nunu rak la kerepmo levengkatli atnumu na lox avukat.” ");
INSERT INTO mmx_vpl VALUES ("MT9_30","070_9_30","MAT","9","30","30","La levengkatli atdu ga lox avukat ta. La ne Iesu ga paase lolos tidu xeretna, “Nemen muta tong i na ri teta.” ");
INSERT INTO mmx_vpl VALUES ("MT9_31","070_9_31","MAT","9","31","31","Ketla duga vas kaxat basinge mo loogu la duga tong i ri limixin at lengkot axap ap mo lenep silok. ");
INSERT INTO mmx_vpl VALUES ("MT9_32","070_9_32","MAT","9","32","32","Melemu atnedu duga on basinge ne Iesu, limixin diga lam ka lara laradi uto saparap ne Iesu. Lagas kapmek ga nemen ap mo laradi la goxo epovo na paase. ");
INSERT INTO mmx_vpl VALUES ("MT9_33","070_9_33","MAT","9","33","33","Se ne Iesu ga riki asu mo lagas, mo laradi ga epovo ba xusu na paase. Mo limixin diga sangu la diga lok, “Kopmen tempanga kerepmo maga ven i nade Israel.” ");
INSERT INTO mmx_vpl VALUES ("MT9_34","070_9_34","MAT","9","34","34","Ketla lubung Parisi diga lok keretna, “Neni i riki asu lubunggas mi lolos at laradi gomgo at lubunggas.” ");
INSERT INTO mmx_vpl VALUES ("MT9_35","070_9_35","MAT","9","35","35","Iesu gat pas kantubu at levenmenemen silok axap, eburu mi lengkon menemen kakalik, ga anasa limixin to at laraogu singising atdi la ga vavang mi Lagale Lavavang mumu Linintoo at ne Moroa. La ne Iesu ga lox avukat limixin basinge levenasen anmeres axap. ");
INSERT INTO mmx_vpl VALUES ("MT9_36","070_9_36","MAT","9","36","36","Kuren la ne Iesu ga ven nedi buaang limixin la ga balamu di mila diga baava mi levenaknixip la digak pakes aleng, kerekngan levesipsip kopmen taradi loklok tatao atdi. ");
INSERT INTO mmx_vpl VALUES ("MT9_37","070_9_37","MAT","9","37","37","La ne Iesu ga lok ti lavaun pinivu ren, “Laraamang mo ira mukun pam, ketla ixo buaang nedi limixin kusu ti lox abeles leveluxa ukeneng at laraogu. ");
INSERT INTO mmx_vpl VALUES ("MT9_38","070_9_38","MAT","9","38","38","Kuren la mina sing ti laradi loklok tatao at laraamang kusu neni naba riki asu tuvuttadi kusu ti lox abeles leveluxa.” ");
INSERT INTO mmx_vpl VALUES ("MT10_1","070_10_1","MAT","10","1","1","Iesu ga xup buru ka nedi lasangaun legepura lavaun pinivu ren saparav i la ni ga raba di mi lolos kusu dina riki asu lubunggas basinge limixin la dina lox aroo luvuttadi mi levenanmeres ga lox abinis labantuxu atdi, la levenasen anmeres bok basinge limixin. ");
INSERT INTO mmx_vpl VALUES ("MT10_2","070_10_2","MAT","10","2","2","Ni levenasen atnedi na lasangaun legepura luvuttadi vavang. Avot tinotno ne Simon (laasen bok teren ne Pita), la ne Endru neni neton; la ne Jems eburu mi neton laasen teren ne Jon, nedu lumdak at ne Sebedi. ");
INSERT INTO mmx_vpl VALUES ("MT10_3","070_10_3","MAT","10","3","3","Pilip la ne Batolomiu; Tomas la ne Metiu, neni laradi loklok ka pilas; Jems, nitna ne Alpias, la ne Tadias. ");
INSERT INTO mmx_vpl VALUES ("MT10_4","070_10_4","MAT","10","4","4","Simon, neni at libinam tadi me Selot, la ne Judas Iskariot, neni mo laradi ga song araba ne Iesu ri limixin kakapmek. ");
INSERT INTO mmx_vpl VALUES ("MT10_5","070_10_5","MAT","10","5","5","Iesu ga riki asu na lasangaun legepura luvuttadi mi levelinga xeretna, “Nemen gat nimi gutat pas uto at tenep at limixin kopmen di me Judaia kopla uto at temenemen at leme Samaria. ");
INSERT INTO mmx_vpl VALUES ("MT10_6","070_10_6","MAT","10","6","6","Mina vot pasa mene limixin boro Israel, di lok ngan laxasipsip di soogong. ");
INSERT INTO mmx_vpl VALUES ("MT10_7","070_10_7","MAT","10","7","7","At lavatpas atnimi, mina vavang ti limixin do Linintoo boro vana at laxalibet monga ira auret! ");
INSERT INTO mmx_vpl VALUES ("MT10_8","070_10_8","MAT","10","8","8","Mina lox avukat levenanmeres, la mina lox arooro amlong luvuttadi met, la mina lox avukat nedi lanmeres gu (leprosy) ik lok atdi, la mina riki asu lubunggas basinge limixin. Nia ara raba gamasa vam nimi mi lolos ti lok na leven gugu. Kuren la mina gugu min la nemen gat mita ro unun tin. ");
INSERT INTO mmx_vpl VALUES ("MT10_9","070_10_9","MAT","10","9","9","Nemen gat mita xip ka tempilas eburu minimi. ");
INSERT INTO mmx_vpl VALUES ("MT10_10","070_10_10","MAT","10","10","10","Nemen mita xip kaka teventat eburu minimi at lavatpas atnimi, kopla tavanga singsiga ri vetara xun, kopla tuvanga vatpas, kopla takdak tit pas, mila laradi gugu at ne Moroa i epovo na lok ka lempanga anan tin boro at limixin neni i vavang tidi.” ");
INSERT INTO mmx_vpl VALUES ("MT10_11","070_10_11","MAT","10","11","11","La ne Iesu ga lok bok tidi xeretna, “La do mina vas pot at temenemen silok kopla temenemen lixilik, mina puse ri taradi avukat la mina nemen eburu min se mina vas kaxat basinge mo lemenemen. ");
INSERT INTO mmx_vpl VALUES ("MT10_12","070_10_12","MAT","10","12","12","Do mina vubeles ukeneng at tara toogu, mina lok tidi xeretna, ‘Limila nak lok eburu minimi.’ ");
INSERT INTO mmx_vpl VALUES ("MT10_13","070_10_13","MAT","10","13","13","Do limixin ap mo loogu di siam ka nimi, mina ke limila atnimi nak lok eburu midi. Ket do dixo siam ka nimi, mina ke limila namlong mu nimi. ");
INSERT INTO mmx_vpl VALUES ("MT10_14","070_10_14","MAT","10","14","14","La do tara ixo siam ka nimi kusu na ronga ka levelinga atnimi, mina semla xepe laxakup basinge lengkangkedek atnimi at loxonaleng mina vas kaxat basinge mo loogu kopla mo lemenemen silok. ");
INSERT INTO mmx_vpl VALUES ("MT10_15","070_10_15","MAT","10","15","15","A tong tuturun i rinimi do at laaleng ete, ne Moroa naba lox asuusu lumumuat ti limixin boro Sodom la Gomora, ketla neni naba lox asuusu lumumuat silok tinotno ri limixin ap mo lemenemen tongtonga xepe!” ");
INSERT INTO mmx_vpl VALUES ("MT10_16","070_10_16","MAT","10","16","16","La ne Iesu ga lok tidi, “Mina ronga i na! Ana riki aonon nimi ngan laxasipsip kantubu at laxanman sio. Mina lok tatao avukat nimi i ngan lisii neni ikleklen solo la minak lox atnaasan ngan levenamno. ");
INSERT INTO mmx_vpl VALUES ("MT10_17","070_10_17","MAT","10","17","17","Mina reven avukat, mila lentaba luvuttadi mo dinaba ranga alis nimi la dina lok ka nimi ri lavapaase. La dinabak pixis nimi ro xeneng at laraogu singising atdi. ");
INSERT INTO mmx_vpl VALUES ("MT10_18","070_10_18","MAT","10","18","18","Dinaba vaxaru nimi ro melamgo at luvuttadi amgomgo la to bok melamgo at lavaorong, mila mi mumu asu ia, la minaba tong asu Lagale Lavavang tidi la ti limixin kopmen di me Judaia. ");
INSERT INTO mmx_vpl VALUES ("MT10_19","070_10_19","MAT","10","19","19","Do dina lok li nimi at lavapaase, nemen gat mita bulu do miba tong lavanga salai la mina vaase xereva. Se at loxonaleng na vot tinimi do ri vaase, ne Moroa axa naba raba nimi mi levelinga kusu mina vaase asu i, ");
INSERT INTO mmx_vpl VALUES ("MT10_20","070_10_20","MAT","10","20","20","mila levelinga mina vaase i, kopmen atnimi xa. Ketla Loroonan Kaala at ne Moroa, ne Temen nimi naba paase asuusu i at levenngusno atnimi. ");
INSERT INTO mmx_vpl VALUES ("MT10_21","070_10_21","MAT","10","21","21","Lara koeton axa dinaba etaba tuntuna mi luvutneton di ri lanmet. La luvuttemen laxamdak dinaba etaba tuntuna mi laxamdak la laxaalik atdi. La laxamdak mi laxaalik dinabang tonga xepe levelinga at luvuttemen di mi luvutnen di la dinaba lok li di at lanmet. ");
INSERT INTO mmx_vpl VALUES ("MT10_22","070_10_22","MAT","10","22","22","Limixin axap dinaba belengatngas tinimi mila mi mumu asu ia. Ketla lara do i tu atmatkun keneng at levesongsongot ise at laxavaxap ap mo levenaleng, ne Moroa naba lox arooro i. ");
INSERT INTO mmx_vpl VALUES ("MT10_23","070_10_23","MAT","10","23","23","Do dina lox asongot nimi at tara temenemen, mina sixiro uto at tara temenemen petpes. A tong tuturun i rinimi do nenia, Laradi Mevana, anaba vot la kovisi mi noxo lok axap lugugu atnimi ap mo laramenemen at lenep silok Israel. ");
INSERT INTO mmx_vpl VALUES ("MT10_24","070_10_24","MAT","10","24","24","Kopmen tamdak loklox ase na silok ti leeme loklox ase ren, kopla tasaxaruki na silok ti laradi gomgo ren. ");
INSERT INTO mmx_vpl VALUES ("MT10_25","070_10_25","MAT","10","25","25","I epovo do lamdak loklox ase na ngan mun leeme loklox ase ren. La lasaxaruki na ngan mun laradi gomgo ren. Mo do limixin dina so asen lamgomgo at lixitkis koetemen mi ne Belsebul, diba so asen gilipu levenasen atdi axap di nemen keneng ap mo loogu mi levenasen kapmek!” ");
INSERT INTO mmx_vpl VALUES ("MT10_26","070_10_26","MAT","10","26","26","La ne Iesu ga lok bok keretna, “Nemen gat mita marat at limixin di munepen minimi. Mila levenai monga di se bopbop li i, naba nemen at lasaxaven, la lempanga sai mo dik lox alipe, naba ravasu at lasaxaven la limixin axap dinabaklen i at laaleng ete. ");
INSERT INTO mmx_vpl VALUES ("MT10_27","070_10_27","MAT","10","27","27","Levenai nia a paase xusuk nimi min at lamain, mina vaase i at lemeren limixin axap. La levenai miga ronga i, aga vaase nemnem i rinimi, mina tu ro vana at lempatlak gu la mina tong asu i ri limixin axap. ");
INSERT INTO mmx_vpl VALUES ("MT10_28","070_10_28","MAT","10","28","28","Nemen mita marat atnedi dip sev amet labantuxu, ketla kopmen dina epovo ri sev amet loroonan. Kusuk mun minak marat at ne Moroa, neni i ruuna lolos kusu ti sev amet labantuxu la na riki loroonan at laradi uto at lemenemen songsongot. ");
INSERT INTO mmx_vpl VALUES ("MT10_29","070_10_29","MAT","10","29","29","I epovo do mina un kaka tegepu natdik mi tegesu xuven pilas mene. Ketla kopmen tara atdu noxo met gamasa la ne Moroa xopmen naklen i. ");
INSERT INTO mmx_vpl VALUES ("MT10_30","070_10_30","MAT","10","30","30","La tinimi, lengkabinim at lempatlak atnimi ne Moroa iraklen axap pam i. ");
INSERT INTO mmx_vpl VALUES ("MT10_31","070_10_31","MAT","10","31","31","Kuren la nemen gat nemi mita marat. Nemi mi nunuan aleng at lemeren ne Moroa!” ");
INSERT INTO mmx_vpl VALUES ("MT10_32","070_10_32","MAT","10","32","32","La ne Iesu ga lok bok tidi, “Nege do i tong asu i do neni laradi mumu asu ia, ro melamgo at limixin axap. At laaleng ete, anaba tong asu bok neni ro melamgo at lemeren ne Moroa to vana at laxalibet do neni laradi rak. ");
INSERT INTO mmx_vpl VALUES ("MT10_33","070_10_33","MAT","10","33","33","Ket do tara na sok tixirixes ia ro melamgo at limixin axap, anaba sok tixirixes kepe box i ro melamgo at ne Tamak to vana at laxalibet.” ");
INSERT INTO mmx_vpl VALUES ("MT10_34","070_10_34","MAT","10","34","34","La ne Iesu ga lok bok tidi, “Nemen mita nua i do nia aga vot kusu ana raba limila ri na lavatbung menemen. Kopmen, a goxo vot kusu ana raba limila, ketla aga vot kusu ti lox aepeseves limixin. ");
INSERT INTO mmx_vpl VALUES ("MT10_35","070_10_35","MAT","10","35","35","Aga vot kusu ana lok, ‘Laxamdak temes di noxo epen mi luvuttemen di, la laxaalik di noxo epen mi luvutnen di. La loxoenen di noxo epen eburu. ");
INSERT INTO mmx_vpl VALUES ("MT10_36","070_10_36","MAT","10","36","36","La laradi noxo epen tinotno minedi di nemen at loogu ren.’ ");
INSERT INTO mmx_vpl VALUES ("MT10_37","070_10_37","MAT","10","37","37","Do nege i balamu aleng ne temen kopla nenen la ixo vavara aleng ia, neni xopmen na epovo do na ravasu ngan laradi rak. Do nege i balamu aleng ne nitna xopla ne nitnono, la ixo vavara aleng ia, neni xopmen na epovo do na lok ngan laradi rak. ");
INSERT INTO mmx_vpl VALUES ("MT10_38","070_10_38","MAT","10","38","38","Do nege i xopara na xip ka levenmumuat, i lok ngan laradi na solok ka laxaba ren la ira mumu asu ia, neni xopmen na epovo do na nemen ngan laradi rak. ");
INSERT INTO mmx_vpl VALUES ("MT10_39","070_10_39","MAT","10","39","39","Do nege i vara i do na ranga alis lorooro ren, neni naba sang apkav i. Ket do nege i soxope lorooro ren ti lok luvukat tarak, neni naba lok kaka lorooro avolo.” ");
INSERT INTO mmx_vpl VALUES ("MT10_40","070_10_40","MAT","10","40","40","La ne Iesu ga lok bok tidi, “Do nege i seega rangarang nemi, neni i seega rangarang ia. La do nege i seega rangarang ia, neni i seega rangarang ne Moroa mo ga riki ia ude at na lavatbung menemen. ");
INSERT INTO mmx_vpl VALUES ("MT10_41","070_10_41","MAT","10","41","41","Do nege i seega rangarang leeme vapaase ali mila neni leeme vapaase at ne Moroa, neni naba lok ka luunun ngan at leeme vapaase ali. La do nege i seega rangarang ka laradi nunuan, neni naba lok ka luunun ngan at laradi nunuan. ");
INSERT INTO mmx_vpl VALUES ("MT10_42","070_10_42","MAT","10","42","42","A tong tuturun i rinimi. Do nege i raba loxodan mumudut ti tara atdi na limixin tarak, mila neni lun pinivu rak, neni naba lok kaka kobot luunun teren.” ");
INSERT INTO mmx_vpl VALUES ("MT11_1","070_11_1","MAT","11","1","1","Se ne Iesu ga raba linga axap ti lasangaun mi legepura lavaun pinivu ren, neni ga vas basinge mo loxot la gat pas uto Galili kusu na lox ase limixin la na vavang to at laramenemen atdi. ");
INSERT INTO mmx_vpl VALUES ("MT11_2","070_11_2","MAT","11","2","2","Ap mo levenaleng ne Jon laradi sep susu ga nemen at loogu xokoxo, neni ga ronga lempanga ne Karisito ga lox i, la neni ga riki lentaba lavaun pinivu ren uto saparap ne Iesu mi levelinga xeretna, ");
INSERT INTO mmx_vpl VALUES ("MT11_3","070_11_3","MAT","11","3","3","“Tong axasev i rinama do xereva, nenu vam Lanarong, kopla tara gove manaba ngangais i?” ");
INSERT INTO mmx_vpl VALUES ("MT11_4","070_11_4","MAT","11","4","4","La ne Iesu ga vorang i ridi, “Minamlong la mina tong i ri ne Jon mumu lempanga mi ronga i la mi ven i. ");
INSERT INTO mmx_vpl VALUES ("MT11_5","070_11_5","MAT","11","5","5","Nedi limixin mi lengkatli main, mo di reven manga. Nedi lengkangkedek atdi ga lok kapmek, mo dit pas avukat. La nedi dik meres mi lanmeres gu (leprosy), di lox avukat pam. La nedi levenbaalung atdi i repe, ding tonga manga. La nedi diga met pam mo di roo xat amlong pam. La limixin banbalo, mo ding tonga Lagale Lavavang. ");
INSERT INTO mmx_vpl VALUES ("MT11_6","070_11_6","MAT","11","6","6","Luvukat ti neni laradi kopmen noxo subu basinge ia la lebelen ixo lok kapmek ti na lugugu rak.” ");
INSERT INTO mmx_vpl VALUES ("MT11_7","070_11_7","MAT","11","7","7","Se lavaun pinivu at ne Jon diga vas kaxat pam, Iesu ga tong levelinga mumu ne Jon tinedi limixin keretna, “At levenaleng migat pas do mina ronga linga at ne Jon to at lamatbin, laradi salai nemi miga lok do miba ven i? Kereva, miga nua i do miba ven taradi naba lok ngan lovobeo, lamanman it mas amdi i? ");
INSERT INTO mmx_vpl VALUES ("MT11_8","070_11_8","MAT","11","8","8","Lavanga salai migat pas do mina ven i? Kereva, miga ven laradi ga siga lavanga singsiga avukat? Kopmen. Limixin di siga lempanga singsiga avukat la di ruuna lapnovos silok, nedi dina nemen keneng at laraogu ngan loogu nunuan at loorong. ");
INSERT INTO mmx_vpl VALUES ("MT11_9","070_11_9","MAT","11","9","9","Mina tong i ria, laradi salai migat pas do mina ven i? Taradi vapaase ali? I ruturun tinotno. A tong i rinimi, do nemi miga ven laradi ga silok aleng ti lavaeme vapaase ali. ");
INSERT INTO mmx_vpl VALUES ("MT11_10","070_11_10","MAT","11","10","10","Jon neni laradi mo Lovoang Kaala ga paase mumu i. Moroa ga lok keretna, ‘Laradi vapaase rak, anaba riki amgo i ru kusu na lox agagas li langas tu.’” ");
INSERT INTO mmx_vpl VALUES ("MT11_11","070_11_11","MAT","11","11","11","La ne Iesu ga lok bok, “Nia a tong tuturun i rinimi, Jon laradi sep susu, neni i silok aleng tinedi limixin axap at na lavatbung menemen. Ketla do tara i lok ngan laradi gamasa la neni lanat at Linintoo no vana at laxalibet, ni i silok ti ne Jon. ");
INSERT INTO mmx_vpl VALUES ("MT11_12","070_11_12","MAT","11","12","12","Ga ruka i at laaleng ne Jon ga vavang kaxat, la i se at na laaleng lingina, Linintoo no vana at laxalibet gat pot mi lolos, ketla i ekip tangarang mi limixin kakapmek di lolos kusu dina rupe i. ");
INSERT INTO mmx_vpl VALUES ("MT11_13","070_11_13","MAT","11","13","13","Levelinga at lavaeme vapaase ali, la Laulis Linga, limixin diga mumu asu i, se at lovotpot at ne Jon. ");
INSERT INTO mmx_vpl VALUES ("MT11_14","070_11_14","MAT","11","14","14","La mo do mi epovo do mina siam ka lempapaase atdi, mina nunu do neni ne Elaisa, mo diga tong i do neni nabamlong. ");
INSERT INTO mmx_vpl VALUES ("MT11_15","070_11_15","MAT","11","15","15","Do mi ruuna levenbaalung, mina ronga avukat na levelinga.” ");
INSERT INTO mmx_vpl VALUES ("MT11_16","070_11_16","MAT","11","16","16","La ne Iesu ga lok bok keretna, “Limixin at na levenaleng, ana vaase poovo midi mi levelinga salai? Nedi di lok ngan laxamdak mi laxaalik kakalik dit kis to at lengkot etang. Lara libinam atdi dip kup ti mo lara libinam atdi, ");
INSERT INTO mmx_vpl VALUES ("MT11_17","070_11_17","MAT","11","17","17","‘Magak pixan lengkompixan epot tinimi, ketla mi goxopara na tii momo. Magak pixan lengkompixan bukbulu, ketla mi goxopara nang teng.’ ");
INSERT INTO mmx_vpl VALUES ("MT11_18","070_11_18","MAT","11","18","18","Jon ga vot, la ni ga mun anan la goxo inin vaen, la limixin diga lok do, ‘Lagas i nemen teren!’ ");
INSERT INTO mmx_vpl VALUES ("MT11_19","070_11_19","MAT","11","19","19","Ketla nenia, Laradi Mevana, aga vot, la nia axo mun anan la a inin vaen, la limixin di lok, ‘Mina ven ba i na laradi! Neni laradi xoxo anan la laradi inin vaen, la i etangas mi luvuttadi loklok ka pilas eburu mi limixin kakapmek!’ Ketla lugugu at ne Moroa i pisik avukat la kerepmo i lox asuusu i do lodomdoma ali at ne Moroa i lox avukat.” ");
INSERT INTO mmx_vpl VALUES ("MT11_20","070_11_20","MAT","11","20","20","Melemu Iesu ga ruka i xusu na vaase mukmusak ti limixin ap mo laramenemen ua neni ga lok buaang lempanga sangsangu e, mila limixin ap mo laramenemen kopmen di goxo leeng basinge laxakapmek atdi. ");
INSERT INTO mmx_vpl VALUES ("MT11_21","070_11_21","MAT","11","21","21","Iesu ga lok keretna, “Naba lok kapmek aleng tinemi limixin me Korasin. La naba lok kapmek aleng bok tinemi limixin me Betsaida. Mo levempanga sangsangu nia aga lox i ro xantubu atnimi, mo do nia gita lox i ro Taia la Sidon, soso mun limixin me go, nedi gita leeng pam la gita etara mun lengkontamon kapmek, la gita reeve vam laxakup at lengkot atdi. ");
INSERT INTO mmx_vpl VALUES ("MT11_22","070_11_22","MAT","11","22","22","Ketla ana tong i rinimi do at laaleng ete, ne Moroa naba lox asuusu lumumuat uto ri limixin at lumenemen Taia la Sidon, ketla langsangan lumumuat naba nemen mavana atnimi. ");
INSERT INTO mmx_vpl VALUES ("MT11_23","070_11_23","MAT","11","23","23","La nemi limixin me Kaprenaum. Mi vavara i do mina silok ti limixin axap, ketla ne Moroa naba sok gingin asi minimi uto at lemenemen songsongot. Mo lempanga sangsangu, aga lox i dom kantubu atnimi, mo do nia gita lox i ro Sodom, nedi gitaba leeng basinge laxakapmek atdi la ne Moroa gitoxo sele utut kepe mo lemenemen. ");
INSERT INTO mmx_vpl VALUES ("MT11_24","070_11_24","MAT","11","24","24","A tong i rinimi do at laaleng ete, Moroa naba lox asu lumumuat ti limixin kakapmek to Sodom, ketla tinemi limixin, lumumuat naba silok aleng tinimi.” ");
INSERT INTO mmx_vpl VALUES ("MT11_25","070_11_25","MAT","11","25","25","Ap mo laaleng ne Iesu ga lok ti ne Moroa, “Nia a emi asu minu, Tamak. Nenu Leeme Silok at laxalibet mi lavatkangka. Nia a emi asu minu mila ugara lox ase vam nedi limixin kopmen tevenasen silok atdi mi levelinga mumu Linintoo. La uga lipe i basinge limixin leklen la limixin loklox ase. ");
INSERT INTO mmx_vpl VALUES ("MT11_26","070_11_26","MAT","11","26","26","I ruturun, Tamak. Anai uga lox i mi lodoxoma la lomomo ram.” ");
INSERT INTO mmx_vpl VALUES ("MT11_27","070_11_27","MAT","11","27","27","La ne Iesu ga lok ti mo limixin, “Tamak ira raba vam ia mi lempanga axap. Kopmen teta naklen ia, ketla ne Tamak kusuk mun. La kopmen teta naklen ne Tamak, ketla nenia ne Nitna xusuk mun, la tinedi mun nenia a vara i kusu ana lox ase di min. ");
INSERT INTO mmx_vpl VALUES ("MT11_28","070_11_28","MAT","11","28","28","Nemi axap mik sak saaban mi laxanaknixip keneng at lorooro atnimi, mina vot pasa ia, la ana raba nimi mi loklox amas. ");
INSERT INTO mmx_vpl VALUES ("MT11_29","070_11_29","MAT","11","29","29","Mina siam ka loklok tarak la mina ronga ka levenanasa rak. Mila lorooro rak i umsu mi loklok mulus mene, kuren la minaba lok ka loklox amas ti labaroonan atnimi. ");
INSERT INTO mmx_vpl VALUES ("MT11_30","070_11_30","MAT","11","30","30","Mina siam ka ia mila levenanasa rak kopmen na lolos la loklok tarak noxo lok ngan lavanga mumuat tinimi.” ");
INSERT INTO mmx_vpl VALUES ("MT12_1","070_12_1","MAT","12","1","1","Ap mo levenaleng, ne Iesu gat pas kantubu at leventaamang at laaleng kaala. La lavaun pinivu ren diga roxo la diga xidik kaka lempeven at lempiao, la diga anan i. ");
INSERT INTO mmx_vpl VALUES ("MT12_2","070_12_2","MAT","12","2","2","Lubung Parisi diga ven di, la diga lok ti ne Iesu, “Pen ba i. Lavaun pinivu ram dira los polo vam Laulis Linga, i tong i do nemen mitak lok lempanga xeretnom at laaleng kaala.” ");
INSERT INTO mmx_vpl VALUES ("MT12_3","070_12_3","MAT","12","3","3","La ne Iesu ga sue di xeretna, “Mi doma bok levelinga at Lovoang Kaala mumu ne Devit? At lara laaleng neni eburu mi limixin teren diga roxo. ");
INSERT INTO mmx_vpl VALUES ("MT12_4","070_12_4","MAT","12","4","4","Neni ga vubeles at loogu at ne Moroa la ga lok ka lengkongkide digam taba min ti ne Moroa, la neni eburu mi limixin teren diga anan i. La kerepmo diga los polo vam Laulis Linga mila lavamaasa xusuk mun diga anan mo lengkongkide. ");
INSERT INTO mmx_vpl VALUES ("MT12_5","070_12_5","MAT","12","5","5","Mina domangke at levelinga at Laulis Linga i tong i do at laaleng kaala lavamaasa di los polo Laulis Linga mila di gugu ro xeneng at loogu laplavang ap mo laaleng. Ketla kopmen taxapmek atdi mumu i nom. ");
INSERT INTO mmx_vpl VALUES ("MT12_6","070_12_6","MAT","12","6","6","Nia a tong i rinimi do lara i silok ti loogu laplavang ira vot pam. ");
INSERT INTO mmx_vpl VALUES ("MT12_7","070_12_7","MAT","12","7","7","Nemi xopmen mina xasep at levelinga at Lovoang Kaala mo i lok keretna, ‘A vara i do lebelen tuntun na umsu atnimi, a xopara loklok tiplavang.’ Do nemi gitaklen lavasuun at nai, nemi gitoxo lok li lumumuat atnedi kopmen taxakapmek atdi.” ");
INSERT INTO mmx_vpl VALUES ("MT12_8","070_12_8","MAT","12","8","8","La ne Iesu ga lok bok, “Nenia Laradi Mevana. La nenia Lamgomgo at laaleng kaala la ak lok tatao mo laaleng.” ");
INSERT INTO mmx_vpl VALUES ("MT12_9","070_12_9","MAT","12","9","9","Iesu ga vas kaxat basinge mo loxot la ga vubeles uto at loogu singising atdi. ");
INSERT INTO mmx_vpl VALUES ("MT12_10","070_12_10","MAT","12","10","10","Lara laradi mo ga nemen lekngen ga molo. La lubung Parisi diga doma i do dina bala raba ne Iesu, kuren la diga sue i, “Ik mokso do tara na lox aroo taradi at laaleng kaala?” ");
INSERT INTO mmx_vpl VALUES ("MT12_11","070_12_11","MAT","12","11","11","Iesu ga lok tidi, “Do tara atnimi i ruuna lisipsip, la mo lisipsip na subu uto at tamamara silok at laaleng kaala, neni ba rebeng ka i la ba xiv asu ka i. ");
INSERT INTO mmx_vpl VALUES ("MT12_12","070_12_12","MAT","12","12","12","La laradi i silok aleng ti lisipsip. Kuren la ik mokso do ata lok lempanga avukat at laaleng kaala.” ");
INSERT INTO mmx_vpl VALUES ("MT12_13","070_12_13","MAT","12","13","13","La ni ga lok ti mo laradi, “Una song asu mi lakngam.” La mo laradi ga song asu mi lekngen, la lekngen ga lox avukat axap ta kerekngan mo lara lekngen. ");
INSERT INTO mmx_vpl VALUES ("MT12_14","070_12_14","MAT","12","14","14","Ketla lubung Parisi diga sixisu la diga puse ngas kusu dina sev amet ne Iesu. ");
INSERT INTO mmx_vpl VALUES ("MT12_15","070_12_15","MAT","12","15","15","Iesu gaklen mo levendoxoma atdi la ga vas kaxat basinge mo lemenemen. Buaang limixin diga mumu asu i la neni ga lox aroo nedi digak meres. ");
INSERT INTO mmx_vpl VALUES ("MT12_16","070_12_16","MAT","12","16","16","Neni ga tong alolos i ridi do di noxo tong asu i do neni nege. ");
INSERT INTO mmx_vpl VALUES ("MT12_17","070_12_17","MAT","12","17","17","Iesu ga lox i na kusu na lox asoorun levelinga at leeme vapaase ali ne Aisaia keneng at Lovoang Kaala, i lok keretna, ");
INSERT INTO mmx_vpl VALUES ("MT12_18","070_12_18","MAT","12","18","18","“Neni na lasaxaruki rak, mo nia aga soxolik ka i. Nenia a balamu i la a lok momo aleng min. Nenia anaba suxa aumsu i mi Loroonan tarak. La neni naba paase axasep loklok manmanton ti limixin axap. ");
INSERT INTO mmx_vpl VALUES ("MT12_19","070_12_19","MAT","12","19","19","Neni noxo etep mi levelinga kopla nap kup mukmusak. Neni noxo ru asuvos i ro melamgo at limixin axap. ");
INSERT INTO mmx_vpl VALUES ("MT12_20","070_12_20","MAT","12","20","20","Neni noxo ru mi loboat tinedi limixin molobe kopla na lok kapmek nedi limixin pakpakes. Neni naba gugu se limixin diba siam kaka leveloklok in manton. ");
INSERT INTO mmx_vpl VALUES ("MT12_21","070_12_21","MAT","12","21","21","La levenabung mixin axap dinaba nunu at laasen teren.” ");
INSERT INTO mmx_vpl VALUES ("MT12_22","070_12_22","MAT","12","22","22","La limixin diga lam ka lara laradi uto at ne Iesu. Lagas kapmek ga suxuna i la goxo epovo na paase la luxatli ren ga main. La ne Iesu ga riki asu lagas basinge mo laradi la ni ga lox epovo i xusu na paase la na reven. ");
INSERT INTO mmx_vpl VALUES ("MT12_23","070_12_23","MAT","12","23","23","La limixin axap diga sangu la diga esue, “Kereva, na laradi neni Lanarong, la livisik li at ne Devit?” ");
INSERT INTO mmx_vpl VALUES ("MT12_24","070_12_24","MAT","12","24","24","La lubung Parisi diga ronga i na la diga lok ti mo limixin, “Neni i riki asu lubunggas mi lolos at ne Belsebul, laradi gomgo at lubunggas.” ");
INSERT INTO mmx_vpl VALUES ("MT12_25","070_12_25","MAT","12","25","25","Ketla ne Iesu gaklen levendoxoma atdi la ni ga tong lavapaase poovo ridi xeretna, “Dola tubung mixin di epes di ri lengkon binam tadi, la dia esep eburu minedi xa, letuna atdi kopmen noxo lok nunuan. La limixin at legese menemen kopla loxoetemen do di epes di kusu ti esep, dinabat kis epeseves. ");
INSERT INTO mmx_vpl VALUES ("MT12_26","070_12_26","MAT","12","26","26","Kuren la mo do ne Satan eburu mi limixin teren dina epeseves ti legepu binam tadi la dina esep, lolos teren naba nemen atmatkun kereva? ");
INSERT INTO mmx_vpl VALUES ("MT12_27","070_12_27","MAT","12","27","27","Mo do nia a lox asu di mi lolos at ne Belsebul, limixin atnimi di lox asu di xereva? Nedi di lox asuusu i do levelinga atnimi kopmen nak mokso. ");
INSERT INTO mmx_vpl VALUES ("MT12_28","070_12_28","MAT","12","28","28","Ket do a lox asu di mi lolos at Loroonan Kaala at ne Moroa, Linintoo at ne Moroa monga ira vot pam saparap nimi. ");
INSERT INTO mmx_vpl VALUES ("MT12_29","070_12_29","MAT","12","29","29","Do tara i vara na xip pilo xaka lempanga at loogu at taradi lolos, neni na xoxo alis be mo laradi la melemu na xip kaka ba mo lempanga ren. ");
INSERT INTO mmx_vpl VALUES ("MT12_30","070_12_30","MAT","12","30","30","Do taradi kopmen na xis esogo eburu minia, neni i munepen minia. La do tara kopmen nak lok tooro ia tip kup bubua ka laxasipsip, neni mo laradi ik sak teteles laxasipsip. ");
INSERT INTO mmx_vpl VALUES ("MT12_31","070_12_31","MAT","12","31","31","La a tong i rinimi xeretna. Moroa naba doxoma xepe laxakapmek axap la lavapaase vupu. Ket do tara na vaase vupu ri Loroonan Kaala, ne Moroa noxo doxoma xepe mo laxakapmek. ");
INSERT INTO mmx_vpl VALUES ("MT12_32","070_12_32","MAT","12","32","32","La ne Moroa naba doxoma xepe tara i paase kapmek mumu ia, Laradi Mevana. Ketla neni noxo doxoma xepe tara i paase kapmek mumu Loroonan Kaala, at na levenaleng la at lorooro melemu bok. ");
INSERT INTO mmx_vpl VALUES ("MT12_33","070_12_33","MAT","12","33","33","Luuna avukat, ni i pisik larapeven una avukat. Luuna xapmek, ni i pisik mun larapeven una kapmek. Limixin di ven kibis luuna at larapeven teren i pisik asu i. ");
INSERT INTO mmx_vpl VALUES ("MT12_34","070_12_34","MAT","12","34","34","Nemi laxamdak at lempasii. Nemi xopmen mina epovo na tong asu levelinga avukat mila nemi mi umsu mi laxakapmek. Levenngusno nimi i paase asuusu lempanga lebelen nimi i umsu min. ");
INSERT INTO mmx_vpl VALUES ("MT12_35","070_12_35","MAT","12","35","35","Laradi avukat ik lox asuusu lempanga nunuan ik lok at lorooro ren, ketla laradi xapmek ik lox asuusu mun lempanga xapmek ik lok at lorooro ren. ");
INSERT INTO mmx_vpl VALUES ("MT12_36","070_12_36","MAT","12","36","36","Nia a tong i rinimi. Limixin dinaba tu at lavapaase ro melamgo at ne Moroa at laaleng ete mumu levelinga xapmek axap diga tong pam i. ");
INSERT INTO mmx_vpl VALUES ("MT12_37","070_12_37","MAT","12","37","37","Mo do levelinga at tara ga lox avukat, Moroa naba lox asepmus i. Mo do levelinga at tara ga lok kapmek, Moroa naba lok li lumumuat silok teren.” ");
INSERT INTO mmx_vpl VALUES ("MT12_38","070_12_38","MAT","12","38","38","Melemu lentaba at lubung Parisi la luvuttadi loklox ase at Laulis Linga diga lok ti ne Iesu, “Leeme loklox ase. Ma vara i do una lok tavanga sangsangu.” ");
INSERT INTO mmx_vpl VALUES ("MT12_39","070_12_39","MAT","12","39","39","La ne Iesu ga lok tidi xeretna, “Limixin at na levenaleng nedi limixin kakapmek tinotno. Di sue ri tavanga sangsangu, ketla kopmen a noxo lok tara ridi. Ketla i epovo do dina doma mumu mun leretere at leeme vapaase ali, ne Jona. ");
INSERT INTO mmx_vpl VALUES ("MT12_40","070_12_40","MAT","12","40","40","Jona ga nemen to xeneng at lebelen lavatmat silok at lavantun aleng kangking la lavantun aleng kanimin. La kerepmo nenia, Laradi Mevana, anaba nemen to xeneng tubu at lavatkangka at lavantun aleng kangking la lavantun aleng kanimin. ");
INSERT INTO mmx_vpl VALUES ("MT12_41","070_12_41","MAT","12","41","41","At laaleng ete limixin boro Nineve dinaba xatu kaxat upana la dina tong asu laxakapmek atnimi, mila diga leeng basinge laxakapmek atdi at nom laaleng diga ronga ne Jona ga vavang tidi. La lara laradi ik lok kantubu atnimi, neni i silok ti ne Jona. ");
INSERT INTO mmx_vpl VALUES ("MT12_42","070_12_42","MAT","12","42","42","At laaleng ete latkin gomgo boro Sheba naba xatu kaxat la na tong asu laxakapmek atnimi limixin at na levenaleng, mila neni gat pas at lavatpas babaalom aleng kusu na ronga lakleklen at ne Solomon. La lara laradi ik lok pam kantubu atnimi, neni i silok ti ne Solomon.” ");
INSERT INTO mmx_vpl VALUES ("MT12_43","070_12_43","MAT","12","43","43","La ne Iesu ga lok bok, “Do lagas kapmek na oo su basinge laradi, bat pas saasaa at lengkot kopmen tadan teren, la ba reven ti toxot kusu tin ti lok mamana. Mo do noxo vuse ka toxot, ");
INSERT INTO mmx_vpl VALUES ("MT12_44","070_12_44","MAT","12","44","44","naba doma i xeretna, ‘Anamlong uto at no laradi, nenia aga on basinge i.’ La neni bamlong la na long lenget ka i do mo loxot imgames la ira lox avukat pam la kopmen tara ro xeneng teren. ");
INSERT INTO mmx_vpl VALUES ("MT12_45","070_12_45","MAT","12","45","45","La neni bat pas la na lok ka bok lavanuti lubunggas, laxakapmek atdi i volo aleng i, la dibat pas la diba vubeles ap mo laradi. Kuren la mo laradi ba nemen kakapmek tino. Limixin kakapmek at na levenaleng dinabak lok kuren.” ");
INSERT INTO mmx_vpl VALUES ("MT12_46","070_12_46","MAT","12","46","46","Iesu move ga paase ri limixin la nenen mi luvutneton diga tu ro xamang, diga vara i do dina epaase min. ");
INSERT INTO mmx_vpl VALUES ("MT12_47","070_12_47","MAT","12","47","47","Lara laradi ga lok ti ne Iesu, “Nenam eburu mi luvutnetam no di tu xamang la di vara i do dina ven u.” ");
INSERT INTO mmx_vpl VALUES ("MT12_48","070_12_48","MAT","12","48","48","La ne Iesu ga lok, “Nege ne naga, la nege di luvutnetak?” ");
INSERT INTO mmx_vpl VALUES ("MT12_49","070_12_49","MAT","12","49","49","La ne Iesu ga song ti lavaun pinivu ren la ga lok, “Na luvuttadi nedi di lok ngan ne naga mi luvutnetak. ");
INSERT INTO mmx_vpl VALUES ("MT12_50","070_12_50","MAT","12","50","50","Neni mun i mu asu lavavara at ne Tamak no vana at laxalibet, neni netak, kopla neinuk, kopla ne naga.” ");
INSERT INTO mmx_vpl VALUES ("MT13_1","070_13_1","MAT","13","1","1","Ap mo mun laaleng Iesu ga vas kaxat basinge mo loogu la gat pas uto at lisigege at lavatdan kis, la ni ga xis kopok la ga anasa limixin. ");
INSERT INTO mmx_vpl VALUES ("MT13_2","070_13_2","MAT","13","2","2","Ketla limixin diga umsu xangkan i, diga buaang aleng. Kuren la ni ga los kas at lesepang la ni ga xis teren, la limixin diga tu ro loxon. ");
INSERT INTO mmx_vpl VALUES ("MT13_3","070_13_3","MAT","13","3","3","Neni ga paase poovo ridi mi lempanga buaang. Ni ga lok keretna, “Lara laradi lotlo ga vas su kusu natlotlo piao. ");
INSERT INTO mmx_vpl VALUES ("MT13_4","070_13_4","MAT","13","4","4","Se neni gatlotlo levenit piao ro at laraamang, lentaba levenit ga subu ro at langas la lavapixa diga vot la diga rok axav i. ");
INSERT INTO mmx_vpl VALUES ("MT13_5","070_13_5","MAT","13","5","5","Lentaba atdi ga subu ro at laxanuat la lengkongkangka lixilik mene gak lok teren. Levenit piao ga suu xat soso mun mila goxopmen taxangka solo. ");
INSERT INTO mmx_vpl VALUES ("MT13_6","070_13_6","MAT","13","6","6","Ga se laxangking ga losu upana, ga sev amolos axap nom lempiao, mila levenixe atdi goxo si aleng ukopok la nom lempiao suusu diga met axap. ");
INSERT INTO mmx_vpl VALUES ("MT13_7","070_13_7","MAT","13","7","7","Lentaba at nom levenit piao ga subu ro at livin gagas la livin gagas ga suu xat la ga is nom lempiao la di goxo epovo bok ba ri suu. ");
INSERT INTO mmx_vpl VALUES ("MT13_8","070_13_8","MAT","13","8","8","Ketla lentaba levenit piao ga subu ro at loxongkangka nunuan, la ga visik. Lentaba ga visik legesa sangaun kobot (100), lentaba lavanna sangaun, la lentaba lavantun sangaun.” ");
INSERT INTO mmx_vpl VALUES ("MT13_9","070_13_9","MAT","13","9","9","La ne Iesu ga lok, “Mo do levenbaalung go atnimi, mina ronga avukat na levelinga.” ");
INSERT INTO mmx_vpl VALUES ("MT13_10","070_13_10","MAT","13","10","10","Melemu lavaun pinivu ren diga vot pasa ne Iesu la diga sue i xeretna, “Tila u tong asu lempapaase poovo ri limixin mo do u paase ridi?” ");
INSERT INTO mmx_vpl VALUES ("MT13_11","070_13_11","MAT","13","11","11","La ne Iesu ga vorang i ridi xeretna, “Moroa ira raba vam nimi mi lakleklen at Linintoo no vana at laxalibet, gano ga nemen alipe. Ketla tinedi limixin petpes kopmen. ");
INSERT INTO mmx_vpl VALUES ("MT13_12","070_13_12","MAT","13","12","12","La mo do taradi i ruuna lakleklen kerepmo, Moroa naba raba box i kusu neni naba ruuna lakleklen solo. Ketla ti laradi, kopmen takleklen solo ren, Moroa naba lox asu axap mo lakleklen basinge i, keke i do neni i ruuna laman akleklen lixilik mun. ");
INSERT INTO mmx_vpl VALUES ("MT13_13","070_13_13","MAT","13","13","13","Lavasuun teren do nenia a paase ridi mi lempapaase poovo i lok keretna, ‘Nedi di reven lugugu, ketla di noxo ven kibis i. Ding tonga mo levelinga, ketla di noxo xasep teren.’ ");
INSERT INTO mmx_vpl VALUES ("MT13_14","070_13_14","MAT","13","14","14","Kuren la na lavapaase ali at ne Aisaia ira soorun pam. Moroa ga lok keretna, ‘Minabang tonga amisik, ketla mi noxo xasep. Minaba reven amisik, ketla mi noxo ven kibis. ");
INSERT INTO mmx_vpl VALUES ("MT13_15","070_13_15","MAT","13","15","15","Lavasuun teren do levendoxoma at na limixin ira rebonot pam, la dira bong pe vam lenbaalung atdi la dira vam pe bok pam lengkatli atdi. Do kopmen, lengkatli atdi naba reven la lenbaalung atdi nang tonga la levendoxoma atdi na xasep la dina leeng la ana lox avukat nedi.’ ");
INSERT INTO mmx_vpl VALUES ("MT13_16","070_13_16","MAT","13","16","16","Ketla Moroa ik lox anarong nemi lavaun pinivu mila lengkatli atnimi i reven la lenbaalung atnimi ing tonga. ");
INSERT INTO mmx_vpl VALUES ("MT13_17","070_13_17","MAT","13","17","17","A tong tuturun i rinimi! Buaang nedi lavaeme vapaase ali la buaang bok nedi limixin at ne Moroa diga vavara aleng i do dina reven na lugugu rak mi reven i, ketla di goxo epovo. La diga vavara box i do dina ronga levelinga rak ming tonga i, ketla di goxo epovo.” ");
INSERT INTO mmx_vpl VALUES ("MT13_18","070_13_18","MAT","13","18","18","La ne Iesu ga lok bok keretna, “Mina ronga avukar i na, la mina xasep avukat at lavasuun at na lavapaase poovo at laradi gatlotlo levenit piao. ");
INSERT INTO mmx_vpl VALUES ("MT13_19","070_13_19","MAT","13","19","19","Tinedi di ronga lempapaase mumu Linintoo, ketla dixo xasep teren, nedi di lok ngan levenit piao ga subu ro mun at langas. Satan i vot la i lok pes nom levelinga basinge lorooro atdi. ");
INSERT INTO mmx_vpl VALUES ("MT13_20","070_13_20","MAT","13","20","20","Ti levenit piao ga subu ro at laxanuat, lengkongkangka lixilik gak lok teren, ni i ru katling nedi limixin di ronga levelinga la soso mun di siam ka i mi lomomo. ");
INSERT INTO mmx_vpl VALUES ("MT13_21","070_13_21","MAT","13","21","21","Ketla ixo vubeles ukeneng at lorooro atdi, la lununu atdi ixo nemen abao solo. Kuren la ise do levenmumuat i vot eburu mi levesongsongot mumu levelinga at ne Moroa, lununu atnedi i subu soso mun. ");
INSERT INTO mmx_vpl VALUES ("MT13_22","070_13_22","MAT","13","22","22","Ti levenit piao ga subu ro at livin gagas, ni i ru katling nedi limixin di ronga levelinga, ketla dik bulu mu solo laxampanga at na lorooro, la nom lavavara atnedi ri lapnovos i itis nom levelinga la dixo pisik tempeven una. ");
INSERT INTO mmx_vpl VALUES ("MT13_23","070_13_23","MAT","13","23","23","La ti levenit piao ga subu at laxangka nunuan, ni i ru katling nedi limixin di ronga levelinga at ne Moroa la di xasep teren, la di pisik lempeven una. Lentaba di visik lempeven una i epovo at legesa sangaun kobot (100) la lentaba lavanna sangaun la lentaba lavantun sangaun.” ");
INSERT INTO mmx_vpl VALUES ("MT13_24","070_13_24","MAT","13","24","24","Iesu ga tong bok lara lavapaase poovo ridi, ni ga lok, “Linintoo no vana at laxalibet i lok ngan laradi gatlotlo levenit piao avukat to at laraamang teren. ");
INSERT INTO mmx_vpl VALUES ("MT13_25","070_13_25","MAT","13","25","25","At laxanimin limixin axap diga unga, la lara lumunepen ga vot la gatlo lempivilis kapmek to xeneng at nom laraamang piao, la no nga i gara onon. ");
INSERT INTO mmx_vpl VALUES ("MT13_26","070_13_26","MAT","13","26","26","Ise levenit ga suu xat la ga lok do na visik, lempivilis kapmek bok ga suu xat. ");
INSERT INTO mmx_vpl VALUES ("MT13_27","070_13_27","MAT","13","27","27","Lavasaxaruki ap mo laradi at laraamang diga vot pasa i la diga lok, ‘Leeme silok. Levenit piao avukat ugatlotlo i. I lok kereva la lempivilis kapmek ta mo ira suu kantubu at lempiao?’ ");
INSERT INTO mmx_vpl VALUES ("MT13_28","070_13_28","MAT","13","28","28","La ni ga vorang i ridi, ‘Taradi i munepen minia ga lox i nom.’ La diga lok tin, ‘Kereva, u vara i do manat pas la mana xat kepe i?’ ");
INSERT INTO mmx_vpl VALUES ("MT13_29","070_13_29","MAT","13","29","29","La ni ga lok, ‘Kopmen, mila lavanga mina xat kepe lempiao eburu mi lempivilis kapmek. ");
INSERT INTO mmx_vpl VALUES ("MT13_30","070_13_30","MAT","13","30","30","Keke lempiao eburu mi levempivilis kapmek dina suusu eburu se at laaleng ti sep kin. Ap mo laaleng anaba tong i ri limixin gugu rak keretna. Mina rep asu ka avot levempivilis kapmek la minap kos ka di la mina lu arup midi ro at laxao. La mina lok bubua ka lempiao la mina lok li di ro at loogu lili rak.’” ");
INSERT INTO mmx_vpl VALUES ("MT13_31","070_13_31","MAT","13","31","31","Iesu ga vaase bok tidi mi lara lavapaase poovo xeretna, “Linintoo no vana at laxalibet i lok ngan lara laradi ga lok ka levenit mastet la gatlotlo i ro xataamang teren. ");
INSERT INTO mmx_vpl VALUES ("MT13_32","070_13_32","MAT","13","32","32","Nom levenit i lixilik aleng ti levenit axap, ketla do ira suu xat, neni i silok aleng ti lempanga axap i suusu ro xataamang. La ira lok ngan ta luuna, la lavapixa dit pot, la dirap kip gu go at lengkakan una ren.” ");
INSERT INTO mmx_vpl VALUES ("MT13_33","070_13_33","MAT","13","33","33","Melemu ne Iesu ga vaase bok di mi lara lavapaase poovo xeretna, “Linintoo no vana at laxalibet i ngan liis (yeast). Latkin i lok ka i la i lok eburu i mi loxompalava solo kusu na lok lengkongkide min. Liis (yeast) i vubeles axap uto xeneng at loxompalava xusu na so xat.” ");
INSERT INTO mmx_vpl VALUES ("MT13_34","070_13_34","MAT","13","34","34","Iesu gak lok lempapaase poovo ri tong i na lempanga ri limixin. Ni goxo tong tavanga ridi la kopmen tavapaase poovo. ");
INSERT INTO mmx_vpl VALUES ("MT13_35","070_13_35","MAT","13","35","35","La kerepmo ne Iesu ga lox asoorun levelinga at leeme vapaase ali ga vaase i xeretna, “Nia anaba tong asu lempapaase poovo ridi. La ana re musumus levempanga megano ua gak lox alipe, ga ruka i at luruntudum li at na lavatbung menemen.” ");
INSERT INTO mmx_vpl VALUES ("MT13_36","070_13_36","MAT","13","36","36","Iesu ga on basinge limixin la ga beles ukeneng at lara loogu, la lavaun pinivu ren diga vot pasa i la diga lok tin, “Una tong asu lavasuun at lavapaase poovo mumu lempivilis kapmek ga su ro xataamang.” ");
INSERT INTO mmx_vpl VALUES ("MT13_37","070_13_37","MAT","13","37","37","La ne Iesu ga lok tidi xeretna, “Nom laradi itlotlo levenit piao avukat, nenia vam, Laradi Mevana. ");
INSERT INTO mmx_vpl VALUES ("MT13_38","070_13_38","MAT","13","38","38","Nom laraamang i ru katling na lavatbung menemen. Levenit piao avukat, ni limixin dinaba vubeles ti Linintoo. La lempivilis kapmek, ni limixin di mumu asu ne Satan. ");
INSERT INTO mmx_vpl VALUES ("MT13_39","070_13_39","MAT","13","39","39","La laradi munepen itlotlo lempivilis kapmek, neni ne Satan. Laaleng ti lok bubua limixin, i ru katling laaleng kavaxap at na lavatbung menemen. La limixin gugu, nedi lubungangelo. ");
INSERT INTO mmx_vpl VALUES ("MT13_40","070_13_40","MAT","13","40","40","Lempivilis kapmek di lok bubua di la dira xotos di ro at laxao, naba lok mun kuren tinedi limixin kakapmek at laaleng kavaxap at na lavatbung menemen. ");
INSERT INTO mmx_vpl VALUES ("MT13_41","070_13_41","MAT","13","41","41","Nenia, Laradi Mevana, anaba riki asu lubungangelo rak ti lok ka nedi di lox asubu limixin eburu mi limixin kakapmek uto basinge limixin nunu. ");
INSERT INTO mmx_vpl VALUES ("MT13_42","070_13_42","MAT","13","42","42","La lubungangelo dinaba lu arup midi ro at lemenemen songsongot. Ap mo loxot dibang teng la dina rungur igisa. ");
INSERT INTO mmx_vpl VALUES ("MT13_43","070_13_43","MAT","13","43","43","La limixin manmanton dinaba soosoo ngan laxangking to at Linintoo at ne Temen di. Do lenbaalung mo atnimi, minang tonga avukat!” ");
INSERT INTO mmx_vpl VALUES ("MT13_44","070_13_44","MAT","13","44","44","La ne Iesu ga lok bok tidi, “Linintoo no vana at laxalibet i lok ngan lapnovos di lipe i ro at laxangka. La lara laradi i ven terek ka i la ni ia lipe manga i, la ni i lok momo aleng la ni ia sesep mi lempanga axap teren la neni imlong la ia un kaka mo lenep kangka axap la ia ruuna ka mo lapnovos.” ");
INSERT INTO mmx_vpl VALUES ("MT13_45","070_13_45","MAT","13","45","45","La ne Iesu ga lok bok tidi, “Linintoo no vana at laxalibet i lok ngan laradi sesep i puse ri laxanuat gamgames. ");
INSERT INTO mmx_vpl VALUES ("MT13_46","070_13_46","MAT","13","46","46","La do ira vuse ka lara, langsangan luunun teren, neni it pas la ira sesep mi lempanga axap teren, la ni iramlong ba la ira un ka ba mo luuat.” ");
INSERT INTO mmx_vpl VALUES ("MT13_47","070_13_47","MAT","13","47","47","La ne Iesu ga lok bok tidi, “Linintoo no vana at laxalibet i lok ngan laxatkat. Limixin sepsep mat di loloa min to at laras la dira sao ka laxanasen mat solo min. ");
INSERT INTO mmx_vpl VALUES ("MT13_48","070_13_48","MAT","13","48","48","Se mo laxatkat i umsu mi laxanmat, di rep ka i uto loxon la dira xis be xusu dina episa lenmat. Lentaba nunuan di lok li di ro at lengkaxi atdi la lentaba xapmek di lu xepe midi. ");
INSERT INTO mmx_vpl VALUES ("MT13_49","070_13_49","MAT","13","49","49","Naba lok mun kuren at laaleng kavaxap at na lavatbung menemen. Lubungangelo dinaba vot la dina lok ka limixin kakapmek basinge limixin avukat, ");
INSERT INTO mmx_vpl VALUES ("MT13_50","070_13_50","MAT","13","50","50","la dinaba lu arup midi ro at lemenemen songsongot. Mo go dinabang teng la dina rungur igisa.” ");
INSERT INTO mmx_vpl VALUES ("MT13_51","070_13_51","MAT","13","51","51","Iesu ga sue di xeretna, “Mi xasep at na lempapaase poovo?” La diga vorang i rin keretna, “Laaba.” ");
INSERT INTO mmx_vpl VALUES ("MT13_52","070_13_52","MAT","13","52","52","La ni ga lok, “Kuren la nedi axap luvuttadi loklox ase at Laulis Linga do dina mumu asu levelinga at Linintoo no vana at laxalibet, nedi di lok ngan laradi at loogu i xip asu lempanga maxat mi lempanga maut boro xeneng at loogu lili ren kusu na raba limixin min.” ");
INSERT INTO mmx_vpl VALUES ("MT13_53","070_13_53","MAT","13","53","53","Ise ne Iesu ga vaase axap na lempapaase poovo, neni ga on basinge mo lenep, ");
INSERT INTO mmx_vpl VALUES ("MT13_54","070_13_54","MAT","13","54","54","la gamlong uto at lemenemen aulis teren. Ni ga anasa ro at loogu singising atdi. La limixin diga ronga i la diga sangu. Diga esue xeretna, “Ni ga lok ka na lakleklen solo meva? La ga lok ka lolos meva xusu ti lok na lempanga sangsangu? ");
INSERT INTO mmx_vpl VALUES ("MT13_55","070_13_55","MAT","13","55","55","Neni mun lamdak at ne Josep laradi xipkip gu! La ne Maria neni nenen, la ne Jems, la ne Josep, la ne Simon, la ne Judas di mun luvutneton, ");
INSERT INTO mmx_vpl VALUES ("MT13_56","070_13_56","MAT","13","56","56","la luvurinen dik lok bok de. Ni ga lok ka na lakleklen meva?” ");
INSERT INTO mmx_vpl VALUES ("MT13_57","070_13_57","MAT","13","57","57","Kuren la diga sok tixirixes kepe i. La ne Iesu ga lok tidi, “Leeme vapaase ali, limixin di lok ngangao ren at lengkot axap, ketla to at lemenemen teren, limixin eburu mi libibinat teren, kopmen dina lok ngangao ren.” ");
INSERT INTO mmx_vpl VALUES ("MT13_58","070_13_58","MAT","13","58","58","Iesu goxo lok solo tempanga sangsangu go mila di goxo ruuna epovo lununu. ");
INSERT INTO mmx_vpl VALUES ("MT14_1","070_14_1","MAT","14","1","1","Ap mo levenaleng Erodes laradi gomgo boro Galili ga ronga lempanga ne Iesu ga lox i. ");
INSERT INTO mmx_vpl VALUES ("MT14_2","070_14_2","MAT","14","2","2","La ni ga lok ti luvuttadi gugu ren, “Agut neni ne Jon to ga roo xat amlong, kuren la neni ira lok nom lempanga sangsangu mi mo lolos teren.” ");
INSERT INTO mmx_vpl VALUES ("MT14_3","070_14_3","MAT","14","3","4","Avot at na ne Erodes ga sak paxat ka latkin at neton, laasen teren ne Pilip. Laasen ap mo latkin ne Erodias. La ne Jon laradi sep susu ga vaase sok ne Erodes mumu na loklok. La neni ga lok ti ne Erodes, “Ixok mokso do uga epot ka ne Erodias.” Kuren la ne Erodes ga riki luvuttadi gugu ren kusu dina ranga alis ne Jon la diga xoxo i la diga lok li i at loogu xokoxo. ");
INSERT INTO mmx_vpl VALUES ("MT14_5","070_14_5","MAT","14","5","5","Erodes ga lok do na sev amer i, ketla neni ga marat bok at limixin me Judaia. Mila diga lok do ne Jon leeme vapaase ali. ");
INSERT INTO mmx_vpl VALUES ("MT14_6","070_14_6","MAT","14","6","6","At laaleng loklok katling at livipisik at ne Erodes, ne nitnono ne Erodias ga tii ro melamgo at limixin. La ne Erodes ga lok momo aleng min, ");
INSERT INTO mmx_vpl VALUES ("MT14_7","070_14_7","MAT","14","7","7","la ga lok laxakaape do neni naba raba mo loono mi tavanga neni na sing tin. ");
INSERT INTO mmx_vpl VALUES ("MT14_8","070_14_8","MAT","14","8","8","Neni ga mu asu lodoxoma xa at nenen la ga lok, “Una raba nga ia mo mi lavatlak at ne Jon, laradi sep susu, to at tavattingtigon silok.” ");
INSERT INTO mmx_vpl VALUES ("MT14_9","070_14_9","MAT","14","9","9","Loorong ga ronga i la ga bulu aleng. Ketla neni goxo epovo na los polo mo laxakaape neni ga lok pam i ro melamgo at limixin. Kuren la neni ga raba linga luvuttadi gugu ren kusu dina sev amet ne Jon kerekngan mo loono ga sing tin. ");
INSERT INTO mmx_vpl VALUES ("MT14_10","070_14_10","MAT","14","10","10","Kuren la diga ra korop ka lavatlak at ne Jon to at loogu xokoxo. ");
INSERT INTO mmx_vpl VALUES ("MT14_11","070_14_11","MAT","14","11","11","La diga lok li mo lavatlak to at lavattingtigon silok la diga raba loono min, la ga raba nenen min. ");
INSERT INTO mmx_vpl VALUES ("MT14_12","070_14_12","MAT","14","12","12","La lavaun pinivu at ne Jon digat pas la diga lok ka labantuxu ren la digak mir i. Melemu digat pas la diga tong i na ri ne Iesu. ");
INSERT INTO mmx_vpl VALUES ("MT14_13","070_14_13","MAT","14","13","13","Iesu ga ronga lanmet at ne Jon la neni xusuk mun ga mu lesepang uto at loxot mimila. La buaang limixin diga ronga levelinga mumu i na la diga mumu asu i uto loxon boro at levenmenemen atdi. ");
INSERT INTO mmx_vpl VALUES ("MT14_14","070_14_14","MAT","14","14","14","Se ne Iesu ga oso la ga ven nedi buaang limixin, ni ga balamu aleng di la ga lox aroo nedi, diga meres. ");
INSERT INTO mmx_vpl VALUES ("MT14_15","070_14_15","MAT","14","15","15","Ga ukantinao nga, lavaun pinivu ren diga vot pasa i la diga lok tin, “Ukantinao nga na la na loxot, ni loxot mimila rino, la loxonaleng ti anan ira volo vam. Una riki aonon limixin kusu dibat pas uto at levenmenemen la dina un ka tempanga anan tidi.” ");
INSERT INTO mmx_vpl VALUES ("MT14_16","070_14_16","MAT","14","16","16","La ne Iesu ga lok tidi, “Ixo epovo do dina on basinge na loxot. Nemi xa mina raba di mi teveluxa kusu dina anan.” ");
INSERT INTO mmx_vpl VALUES ("MT14_17","070_14_17","MAT","14","17","17","La diga lok tin keretna, “Ma ruuna mun lavalimo lengkongkide la legepu venmat.” ");
INSERT INTO mmx_vpl VALUES ("MT14_18","070_14_18","MAT","14","18","18","La ne Iesu ga lok tidi, “Mina raba ia mi nom leveluxa.” ");
INSERT INTO mmx_vpl VALUES ("MT14_19","070_14_19","MAT","14","19","19","La neni ga tong i ri mo limixin kusu dina xis kopok ap mo levempivilis avukat. La ni ga lok ka mo levengkongkide la legepu venmat, la ga milik aurut uto vana at laxalibet, la ga tong avukat ti ne Moroa. La neni ga sebek mo lengkongkide la ga raba i ri lavaun pinivu ren, la diga raba limixin min. ");
INSERT INTO mmx_vpl VALUES ("MT14_20","070_14_20","MAT","14","20","20","La limixin axap diga anan la diga an mais. La lavaun pinivu diga luxa lasangaun mi legepura leventat silok mi leveluxa mo limixin diga an ake ren. ");
INSERT INTO mmx_vpl VALUES ("MT14_21","070_14_21","MAT","14","21","21","La nedi luvuttadi remes diga anan, diga epovo at lavalimo larabin sangsangaun kobot. (5000) La lentaba lavakin la laxamdak mi laxaalik kakalik bok diga anan. ");
INSERT INTO mmx_vpl VALUES ("MT14_22","070_14_22","MAT","14","22","22","La soso mun ne Iesu ga tong i ri lavaun pinivu ren kusu dina los kas at lesepang, la dinamgo rin uto at lenep meo. La neni ga riki aonon limixin. ");
INSERT INTO mmx_vpl VALUES ("MT14_23","070_14_23","MAT","14","23","23","Se neni ga riki aonon kepe vam di, neni xusuk ga vas urut uto vana at loxongkaana kusu na ngising. Neni gak lok go se at laxanimin. ");
INSERT INTO mmx_vpl VALUES ("MT14_24","070_14_24","MAT","14","24","24","La ap mo loxonaleng lesepang no garak lox atbutbu nga. La lempopaxanao gak paksa ekakat lesepang mila lamanman gat mas lolos tangarang i. ");
INSERT INTO mmx_vpl VALUES ("MT14_25","070_14_25","MAT","14","25","25","Kantubu at lavantun mi lavanna konaleng at laxanimin, Iesu ga vot pasa lavaun pinivu ren to kantubu at lavatdan kis, neni gat pas mun to mavana at lavatdan kis. ");
INSERT INTO mmx_vpl VALUES ("MT14_26","070_14_26","MAT","14","26","26","Se diga ven i gat pas to mavana at ladan, diga marat aleng tinotno la diga lok, “Loroonan panga nom!” La digap kup aleng mi lainmarat. ");
INSERT INTO mmx_vpl VALUES ("MT14_27","070_14_27","MAT","14","27","27","La soso mun ne Iesu ga lok tidi, “Nemen gat mita marat, mina lolos. Nenia mun na.” ");
INSERT INTO mmx_vpl VALUES ("MT14_28","070_14_28","MAT","14","28","28","La ne Pita ga lok, “Leeme Silok. Do nenu ruturun pam nom, una tong box i ria kusu anat pas mavana at ladan la u dom saparav u.” ");
INSERT INTO mmx_vpl VALUES ("MT14_29","070_14_29","MAT","14","29","29","La ne Iesu ga vorang i rin keretna, “Ude u.” Kuren la ne Pita ga xatu kaxat boro at lesepang la gat pas to mavana at lavatdan kis uto at ne Iesu. ");
INSERT INTO mmx_vpl VALUES ("MT14_30","070_14_30","MAT","14","30","30","Ketla se neni ga ven lamanman, neni ga marat la gara dong si silatla nga ukopok at ladan. La neni ga xup keretna, “Leeme Silok, una lox aroo ia!” ");
INSERT INTO mmx_vpl VALUES ("MT14_31","070_14_31","MAT","14","31","31","Soso mun Iesu ga song asu mi lekngen la ga ranga ka i la ga lok, “Nenu u ruuna lununu i xakalik mun. Tila uxo nunu do nenia a epovo ana lox u xusu unat pas to mavana at ladan ude saparav ia?” ");
INSERT INTO mmx_vpl VALUES ("MT14_32","070_14_32","MAT","14","32","32","La nedu eburu duga los kas at lesepang, la lamanman gara xap matmas nga. ");
INSERT INTO mmx_vpl VALUES ("MT14_33","070_14_33","MAT","14","33","33","La lavaun pinivu ro xeneng at lesepang diga lok, “I ruturun aleng do nenu ne Nitna ne Moroa.” La diga lotu saparav i la diga emi asu min. ");
INSERT INTO mmx_vpl VALUES ("MT14_34","070_14_34","MAT","14","34","34","Diga xan polo lavatdan kis la diga oso ro Genesaret. ");
INSERT INTO mmx_vpl VALUES ("MT14_35","070_14_35","MAT","14","35","35","Limixin go diga ven kisip ne Iesu, la diga lox aonon levelinga ri limixin diga ruuna levenanmeres ap mo lengkot axap do ne Iesu mo ga vot. La limixin diga lok ka di uto saparap ne Iesu. ");
INSERT INTO mmx_vpl VALUES ("MT14_36","070_14_36","MAT","14","36","36","La diga sing i xusu na ke limixin mekmeres dina long tu at lungusungus at lavanga singsiga ren. La nedi axap diga long tu ren, diga lox avukat ta. ");
INSERT INTO mmx_vpl VALUES ("MT15_1","070_15_1","MAT","15","1","1","Lentaba lubung Parisi mi luvuttadi loklox ase at Laulis Linga diga vas kaxat boro Jerusalem la diga vot pasa ne Iesu la diga sue i, ");
INSERT INTO mmx_vpl VALUES ("MT15_2","070_15_2","MAT","15","2","2","“Tila ba lavaun pinivu ram di ronga xepe leveloklox ase at lavalabat atdik? Dixo sogos avot be levengkikngen di la melemu dina anan.” ");
INSERT INTO mmx_vpl VALUES ("MT15_3","070_15_3","MAT","15","3","3","La ne Iesu ga vorang i ridi xeretna, “La tila ba ming tonga xepe levelinga at ne Moroa xusu mi epovo do mina mumu asu xa levenanasa atnimi? ");
INSERT INTO mmx_vpl VALUES ("MT15_4","070_15_4","MAT","15","4","4","Levelinga at ne Moroa i lok keretna, ‘Mina lok ngangao at luvuttemen nimi mi luvutnen nimi, la do tara i paase kapmek ti ne temen mi nenen, limixin dina sev amer i.’ ");
INSERT INTO mmx_vpl VALUES ("MT15_5","070_15_5","MAT","15","5","6","Ketla nemi mi lok keretna. Mo do tara na ruuna tempanga do ri lox epovo lavakpakes at ne temen kopla nenen, nemi mi tong i rin do neni na mumu asu leveloklok at lavalabat la na raba ne Moroa min la neni na ke loklok ti lok tooro du. At na mun langas nemi ming tonga xepe levenanasa at ne Moroa la mira mumu asu nga leveloklok atnimi. ");
INSERT INTO mmx_vpl VALUES ("MT15_7","070_15_7","MAT","15","7","7","Nemi luvuttadi loklok sosolom. Aisaia ga paase ali nunuan mumu nimi. Ni ga tong asu levelinga at ne Moroa keretna, ");
INSERT INTO mmx_vpl VALUES ("MT15_8","070_15_8","MAT","15","8","8","‘Na limixin di lok ngangao rak mi levelinga mun atdi, ketla lebelen di i vaxalom tino basinge ia. ");
INSERT INTO mmx_vpl VALUES ("MT15_9","070_15_9","MAT","15","9","9","Dixo lotu saparav ia mi luruturun, la dik lox ase mi levelinga at limixin mun!’” ");
INSERT INTO mmx_vpl VALUES ("MT15_10","070_15_10","MAT","15","10","10","Melemu Iesu ga ro xaka limixin saparav i la ga lok tidi, “Mina ronga ka nunuan lempapaase rak la mina xasep teren. ");
INSERT INTO mmx_vpl VALUES ("MT15_11","070_15_11","MAT","15","11","11","Lempanga i vubeles keneng at lungusno laradi, anai xopmen na lox abilinga i. Ketla levelinga laradi i vaase asu i at lungusno, anaa i lox abilinga i.” ");
INSERT INTO mmx_vpl VALUES ("MT15_12","070_15_12","MAT","15","12","12","Melemu lavaun pinivu diga vot pasa i la diga lok, “Uklen pam i do lubung Parisi di suma xapmek ti levelinga ram?” ");
INSERT INTO mmx_vpl VALUES ("MT15_13","070_15_13","MAT","15","13","13","La ni ga lok tidi, “Larauna axap ne Tamak goxotlo li di, neni naba xat pes di. ");
INSERT INTO mmx_vpl VALUES ("MT15_14","070_15_14","MAT","15","14","14","Mina ke xepe di mi levenanasa atdi. Nedi di lok ngan lengkatli main la di lok do nedi luvuttadi loklok tooro at limixin. Do laxatli main im lam lara laxatli main, nedu buru dunaba subu tup at lemet.” ");
INSERT INTO mmx_vpl VALUES ("MT15_15","070_15_15","MAT","15","15","15","Pita ga lok ti ne Iesu, “Una soxomus be lavasuun at nom lavapaase poovo rinama.” ");
INSERT INTO mmx_vpl VALUES ("MT15_16","070_15_16","MAT","15","16","16","La ne Iesu ga sue di, “Kereva mo? Nemi bok kovisi mina xasep? ");
INSERT INTO mmx_vpl VALUES ("MT15_17","070_15_17","MAT","15","17","17","Mina xasep do lempanga anan laradi i anan i la i beles keneng at lebelen, nom i neni i lox asu box i. ");
INSERT INTO mmx_vpl VALUES ("MT15_18","070_15_18","MAT","15","18","18","Ketla lempapaase laradi i vaase asu i at lungusno ren, nom i, i ravasu boro xeneng at lorooro ren. La na mun levelinga, ni i epovo na lox abilinga i. ");
INSERT INTO mmx_vpl VALUES ("MT15_19","070_15_19","MAT","15","19","19","Na levempanga xapmek i ravasu boro at lorooro at laradi i lok keretna. Levendoxoma xapmek, la loklok tip sev amet tadi, loklok ting longka, la leveloklok kakapmek maxamang at lixitkis epot, loklok tip kip pilo, la lavapaase xaxarang mu tara, la loklok ti lox asi tara. ");
INSERT INTO mmx_vpl VALUES ("MT15_20","070_15_20","MAT","15","20","20","La nai lempanga i lox abilinga laradi. Ketla do tara na anan la kopmen na gos avot be lukngen, nom kopmen na lox abilinga i.” ");
INSERT INTO mmx_vpl VALUES ("MT15_21","070_15_21","MAT","15","21","21","Iesu ga on basinge mo lemenemen la gat pas uto at lengkot saparap Taia la Sidon. ");
INSERT INTO mmx_vpl VALUES ("MT15_22","070_15_22","MAT","15","22","22","Lara latkin me Kanan mo ga nemen ap mo lenep ga vot pasa ne Iesu, la ga xup silok tin keretna, “Leeme Silok! Livisik li at ne Devit. Una lox asuusu lebelen tuntun tia la una lok mumu be loolik tarak. Lagas i suxuna i la i lox atpospa rino i.” ");
INSERT INTO mmx_vpl VALUES ("MT15_23","070_15_23","MAT","15","23","23","Ketla Iesu goxo tong tekolinga rin. La lavaun pinivu ren diga vot pasa ne Iesu la diga lok tin, “Una riki aonon mo latkin! Ia mumu asu dik la irak lox avurupit amisik dik.” ");
INSERT INTO mmx_vpl VALUES ("MT15_24","070_15_24","MAT","15","24","24","La ne Iesu ga lok ti mo latkin keretna, “Moroa ga riki ia xusu tinedi mene limixin me Israel diga on soogong.” ");
INSERT INTO mmx_vpl VALUES ("MT15_25","070_15_25","MAT","15","25","25","Nom latkin ga ronga i na la ga xis tiktikbu mi luvatgulom teren la ga lok, “Leeme Silok. Una lok tooro ia.” ");
INSERT INTO mmx_vpl VALUES ("MT15_26","070_15_26","MAT","15","26","26","La ne Iesu ga lok tin keretna, “Ixok mokso do ana lok ka lempanga anan at laxamdak la ana lu raba lubungman min.” ");
INSERT INTO mmx_vpl VALUES ("MT15_27","070_15_27","MAT","15","27","27","Ketla nom latkin ga lok, “Leeme Silok. I ruturun, ketla lubungman di anan bok lengkon mumus luxa im subu su boro vana at loxonin anan at luvuttadi atdi.” ");
INSERT INTO mmx_vpl VALUES ("MT15_28","070_15_28","MAT","15","28","28","La ne Iesu ga lok tin, “Latkin. Lununu ram i silok aleng. Ana lox epovo lisingising taram.” La ap mo mun loxonaleng loolik teren ga lox avukat ta. ");
INSERT INTO mmx_vpl VALUES ("MT15_29","070_15_29","MAT","15","29","29","La ne Iesu ga vas kaxat me go la gat pas to loxon at lavatdan kis Galili. La ni ga vas urut at lakaana la gat kis go. ");
INSERT INTO mmx_vpl VALUES ("MT15_30","070_15_30","MAT","15","30","30","La buaang nedi limixin, diga vot pasa i la diga lam ka limixin, lengkot atdi ga molo, la lengkatli main, la lentaba levengkikngen di la lengkangkedek atdi ga lok kapmek. La lenbaalung baa la buaang bok nedi luvuttadi mi levenanmeres kerepmo, la diga lok ka di uto saparap ne Iesu la ni ga lox aroo di. ");
INSERT INTO mmx_vpl VALUES ("MT15_31","070_15_31","MAT","15","31","31","Limixin diga sangu aleng atla diga ven lenbaalung baa diga paase, la luvuttadi mi levengkikngen di mi lengkangkedek ga lok kapmek, diga lox avukat. La nedi di goxot pas gano, digat pas ta. La lengkatli main, diga reven. La diga emi asu aleng mi ne Moroa me Israel. ");
INSERT INTO mmx_vpl VALUES ("MT15_32","070_15_32","MAT","15","32","32","Iesu ga ro xaka lavaun pinivu ren saparav i la ga lok, “A balamu aleng na limixin, mila ira vantun ta levenaleng nedi dik lok eburu minia, la kopmen ta tempanga anan kusu tidi ri anan. Axo para i do ana riki aonon gamasa nedi mi lantoxo atdi. Lavanga dina meroxon mu langas uto at laramenemen atnedi.” ");
INSERT INTO mmx_vpl VALUES ("MT15_33","070_15_33","MAT","15","33","33","La lavaun pinivu diga sue i, “Ata ba lok ka tempanga anan ua at na lenep gamasa kusu naba epovo at na limixin solo?” ");
INSERT INTO mmx_vpl VALUES ("MT15_34","070_15_34","MAT","15","34","34","La ne Iesu ga sue di xeretna, “Lavanisa lengkongkide nemi mi ruuna i?” La diga vorang i, “Lavanuti lengkongkide la lutpen mat lixilik bok.” ");
INSERT INTO mmx_vpl VALUES ("MT15_35","070_15_35","MAT","15","35","35","La ne Iesu ga tong i ri limixin kusu dina xis kopok at laxangka. ");
INSERT INTO mmx_vpl VALUES ("MT15_36","070_15_36","MAT","15","36","36","La ni ga lok ka lavanuti lengkongkide la lutpen mat la ni ga tong aorong ti ne Moroa, la ga sebex i, la ga raba lavaun pinivu ren min, la diga raba limixin min. ");
INSERT INTO mmx_vpl VALUES ("MT15_37","070_15_37","MAT","15","37","37","La limixin axap diga anan la diga an mais. La melemu lavaun pinivu diga lok ka lavanuti leventat silok la diga suxa aumsu di mi lempanga anan limixin diga an ake ren. ");
INSERT INTO mmx_vpl VALUES ("MT15_38","070_15_38","MAT","15","38","38","Luutus atdi na lavatlok ga epovo at lavanuet larabin sangsangaun kobot (4000). Lavakin mi laxamdak la laxaalik lixilik kopmen di goxo nemen at na luutus. ");
INSERT INTO mmx_vpl VALUES ("MT15_39","070_15_39","MAT","15","39","39","Melemu Iesu ga riki aonon limixin uto at laramenemen atdi la ga los kas at lesepang la ga sen uto at lenep Magadan. ");
INSERT INTO mmx_vpl VALUES ("MT16_1","070_16_1","MAT","16","1","1","Lubung Parisi mi lubung Sadiusi diga vot pasa ne Iesu la diga vara i do neni na lok tavanga sangsangu xusu dina lok tong pen i. ");
INSERT INTO mmx_vpl VALUES ("MT16_2","070_16_2","MAT","16","2","2","La ne Iesu ga lok tidi xeretna, “Do mi ven laxalibet i memele ukantinao, la mi lok, ‘Laaleng naba lox avukat kantamak.’ ");
INSERT INTO mmx_vpl VALUES ("MT16_3","070_16_3","MAT","16","3","3","La do maxantamak, mira lok, ‘Larakabu mo naba vot mila laxalibet i memele la lengkontakabu bok mo.’ Mi reven lavatbung menemen la laxalibet, la mi epovo ri tong asu lavasuun at na lempanga. Ketla xopmen mina xasep at leveloklok katling ne Moroa im taba nimi min at na levenaleng. ");
INSERT INTO mmx_vpl VALUES ("MT16_4","070_16_4","MAT","16","4","4","Limixin kapmek mo dira on basinge vam ne Moroa, di vara tavanga sangsangu, ketla nia noxo lox ase di mi tara. Ketla mina doma mumu loklok katling at ne Jona, no ga nemen at lavantun aleng kangking la lavantun aleng kanimin to xeneng at lebelen leemat.” La ne Iesu ga vas kaxat basinge di. ");
INSERT INTO mmx_vpl VALUES ("MT16_5","070_16_5","MAT","16","5","5","Iesu mi lavaun pinivu ren, diga los kas at lesepang la diga sen kaxat uto at lenep meo ap mo lavatdan kis. La lavaun pinivu diga domampe i xusu dina lok ka tengkongkide eburu midi. ");
INSERT INTO mmx_vpl VALUES ("MT16_6","070_16_6","MAT","16","6","6","La ne Iesu ga lok tidi, “Mina lok tatao avukat nimi mumu liis (Yeast) at lubung Parisi mi lubung Sadiusi.” ");
INSERT INTO mmx_vpl VALUES ("MT16_7","070_16_7","MAT","16","7","7","La lavaun pinivu ren diga epaase kantubu atdi xeretna, “I vaase mo levelinga mila nedik kopmen ta lok ka tengkongkide.” ");
INSERT INTO mmx_vpl VALUES ("MT16_8","070_16_8","MAT","16","8","8","Iesu ga xasep pam at levelinga atdi, kuren la ni ga sue di, “Tila mi emaangun pilo min kantubu atnimi, mumu lengkongkide xopmen mina lok ka i? Lununu atnimi i lixilik. ");
INSERT INTO mmx_vpl VALUES ("MT16_9","070_16_9","MAT","16","9","9","Kovisi mina xasep. Kereva, mira domampe vam lavalimo lengkongkide aga sebex i ri lavalimo larabin sangsangaun kobot (5000) limixin? La lavanisa leventat nemi miga suxa i? ");
INSERT INTO mmx_vpl VALUES ("MT16_10","070_16_10","MAT","16","10","10","Kereva, mira domampe vam lavanuet larabin sangsangaun kobot (4000) limixin aga raba di mi lavanuti lengkongkide? La lavanisa leventat miga suxa i? ");
INSERT INTO mmx_vpl VALUES ("MT16_11","070_16_11","MAT","16","11","11","Tila la mixo xasep do nenia xopmen ana paase rinimi mumu lengkongkide? Mina lok tatao avukat nimi mumu liis (yeast) at lubung Parisi mi lubung Sadiusi.” ");
INSERT INTO mmx_vpl VALUES ("MT16_12","070_16_12","MAT","16","12","12","Melemu levendoxoma atdi ga xasep ba do, Iesu xopmen goxo paase ridi mumu liis (yeast) dik lok eburu i mi lengkongkide. Ketla mumu levenanasa at lubung Parisi la lubung Sadiusi. ");
INSERT INTO mmx_vpl VALUES ("MT16_13","070_16_13","MAT","16","13","13","Ap mo laaleng ne Iesu ga vot to at lenep kangka saparap lemenemen, Sisaria Pilipai, la ni ga sue lavaun pinivu ren, “Limixin di lok do nenia, Laradi Mevana, nege?” ");
INSERT INTO mmx_vpl VALUES ("MT16_14","070_16_14","MAT","16","14","14","La diga vorang i rin keretna, “Lentaba di lok do nenu ne Jon laradi sep susu. Lentaba di tong i do nenu ne Elaisa, la lentaba di tong i do nenu ne Jeremaia kopla lara leeme vapaase ali megano.” ");
INSERT INTO mmx_vpl VALUES ("MT16_15","070_16_15","MAT","16","15","15","La ne Iesu ga sue di, “Kereva ba nimi? Nemi mi lok do nenia nege?” ");
INSERT INTO mmx_vpl VALUES ("MT16_16","070_16_16","MAT","16","16","16","Simon Pita ga vorang i xeretna, “Nenu Lanarong, Nitna ne Moroa, Luntoo Avolo.” ");
INSERT INTO mmx_vpl VALUES ("MT16_17","070_16_17","MAT","16","17","17","Iesu ga lok tin, “Loklok anarong tu, ne Simon lamdak at ne Jona, mila kopmen taradi ga tong asu i na ru, ketla ne Tamak no vana at laxalibet. ");
INSERT INTO mmx_vpl VALUES ("MT16_18","070_16_18","MAT","16","18","18","Nia a tong i ru do, nenu ne Pita la nenu luuat kis la nia aba vaxaru ka lotu rak to mavana ram, la limixin lolos at ne Satan diba lok tong i kusu dina sele utut kepe i, ketla di noxo epovo. ");
INSERT INTO mmx_vpl VALUES ("MT16_19","070_16_19","MAT","16","19","19","Nia anaba raba u mi lengki ri suang lumusmaragu at Linintoo no vana at laxalibet. La mo leveloklok nenu u siam min kopla u sep pepe i nade xopok at na lavatbung menemen, ne Moroa naba siam min to vana at laxalibet.” ");
INSERT INTO mmx_vpl VALUES ("MT16_20","070_16_20","MAT","16","20","20","La neni ga vaase lolos ti lavaun pinivu ren do di noxo tong asu i na ri teta. ");
INSERT INTO mmx_vpl VALUES ("MT16_21","070_16_21","MAT","16","21","21","Ga se ap mo laaleng ne Iesu ga ruka i xusu na tong i ri lavaun pinivu ren do neni na onon uto Jerusalem. La mo go loxongkulao silok, lavamaasa silok la luvuttadi loklox ase at Laulis Linga dinaba lox asongot aleng i la dina sev amer i. La at laaleng sepsev avantun neni naba roo xat amlong. ");
INSERT INTO mmx_vpl VALUES ("MT16_22","070_16_22","MAT","16","22","22","Pita ga lam ka ne Iesu basinge lavaun pinivu la ga vaase sox i xeretna, “Leeme Silok. Nemen uta paase xeretnom. Na lempanga xapmek kopmen noxo vot saparav u.” ");
INSERT INTO mmx_vpl VALUES ("MT16_23","070_16_23","MAT","16","23","23","Iesu ga rem gili ri ne Pita la ga lok tin, “Uto u basinge ia. Nenu u lok ngan ne Satan. U vara i do una lok pe ia. U xopara na mu asu lavavara at ne Moroa, ketla u vara mun levendoxoma at limixin.” ");
INSERT INTO mmx_vpl VALUES ("MT16_24","070_16_24","MAT","16","24","24","La ne Iesu ga lok ti lavaun pinivu ren, “Mo do tara i vara i do na emu eburu minia, neni na domampe lorooro axap teren, la na gagas li i xusu nap kip losongsongot solo, la neni na mumu asu ba ia. ");
INSERT INTO mmx_vpl VALUES ("MT16_25","070_16_25","MAT","16","25","25","Do nege i vara i do na ranga alis lorooro ren, neni naba sang apkav i. Ket do nege i soxope lorooro ren ti mumu asu ia, neni naba lok kaka lorooro avolo. ");
INSERT INTO mmx_vpl VALUES ("MT16_26","070_16_26","MAT","16","26","26","I lok kapmek do taradi na ruuna ka lempanga axap at na lavatbung menemen, ketla neni ira subu vam basinge lorooro at ne Moroa. Laradi ixo epovo na un ka lorooro avolo. ");
INSERT INTO mmx_vpl VALUES ("MT16_27","070_16_27","MAT","16","27","27","Nenia, Laradi Mevana, mo anaba vot mi lisisixam silok at ne Tamak la eburu mi lubungangelo. La ap mo laaleng limixin axap dinaba lok kaka luunun i epovo mi leveloklok diga lox i. ");
INSERT INTO mmx_vpl VALUES ("MT16_28","070_16_28","MAT","16","28","28","La a tong tuturun i rinimi do lentaba atdi di tu de, di noxo met avot ti lovotpot tarak at laaleng nenia, Laradi Mevana, anaba vot ngan Loorong Silok.” ");
INSERT INTO mmx_vpl VALUES ("MT17_1","070_17_1","MAT","17","1","1","Melemu at lavanna levenaleng Iesu ga sat kaka ne Pita, Jems du lueton mi ne Jon, la diga urut uto vana xasep at lakaana. Nedi lavanuet kusuk mun digak lok. ");
INSERT INTO mmx_vpl VALUES ("MT17_2","070_17_2","MAT","17","2","2","Ap mo loxot Moroa ga lox arepukus ne Iesu to melamgo at lavantun lavaun pinivu ren. Lemeren ga soosoo ngan laxangking la lempanga singsiga ren gan bun kerekngan lovotas i sovosok. ");
INSERT INTO mmx_vpl VALUES ("MT17_3","070_17_3","MAT","17","3","3","La soso mun ne Moses la ne Elaisa duga rupot to melamgo atdi la duga epaase eburu mi ne Iesu. ");
INSERT INTO mmx_vpl VALUES ("MT17_4","070_17_4","MAT","17","4","4","La ne Pita ga lok ti ne Iesu, “Leeme Silok. I lox avukat tinotno do nema mak lok de. Do u vara i, nia anaba xip tavantun taraogu kukuxut, tara ru, tara ri ne Moses la tara ri ne Elaisa.” ");
INSERT INTO mmx_vpl VALUES ("MT17_5","070_17_5","MAT","17","5","5","Pita move ga paase la lusugao gamgames ga ravasi la ga vaa di. La diga ronga laxaka at lara boro at lusugao ga lok, “Anaa ne Nuruk, mo a balamu i la a lok momo aleng min. Mina mumu asu levelinga ren.” ");
INSERT INTO mmx_vpl VALUES ("MT17_6","070_17_6","MAT","17","6","6","Ga se lavaun pinivu diga ronga i na, diga subu rintiding ti laxangka, la diga marat aleng. ");
INSERT INTO mmx_vpl VALUES ("MT17_7","070_17_7","MAT","17","7","7","Ketla ne Iesu ga vot pasa di la ga long tu atdi la ga lok tidi, “Mina xatu upana. Nemen mita marat.” ");
INSERT INTO mmx_vpl VALUES ("MT17_8","070_17_8","MAT","17","8","8","La diga milik aurut upana la di goxo ven tara, Iesu xusuk mun mo gak lok. ");
INSERT INTO mmx_vpl VALUES ("MT17_9","070_17_9","MAT","17","9","9","Diga si at lakaana la ne Iesu ga tong lolos i ridi do, “Nemen mita tong i na ri teta, naba se nenia, Laradi Mevana, anaba roo xat amlong basinge lanmet.” ");
INSERT INTO mmx_vpl VALUES ("MT17_10","070_17_10","MAT","17","10","10","La lavaun pinivu ren diga sue i, “Ua lavasuun teren la luvuttadi loklox ase at Laulis Linga di tong i do ne Elaisa naba rupot avot ti Lanarong?” ");
INSERT INTO mmx_vpl VALUES ("MT17_11","070_17_11","MAT","17","11","11","La ne Iesu ga vorang i ridi, “I ruturun tinotno. Elaisa naba rupot avot la na lox amokso lempanga axap. ");
INSERT INTO mmx_vpl VALUES ("MT17_12","070_17_12","MAT","17","12","12","Ketla a tong i rinimi do ne Elaisa ga vot pam la limixin di goxo ven kibis i, la diga lok lempanga xapmek tin kerekngan diga vara i. La kuren mun dinaba lox asongor ia, Laradi Mevana.” ");
INSERT INTO mmx_vpl VALUES ("MT17_13","070_17_13","MAT","17","13","13","La lavaun pinivu diga xasep ba do ne Iesu ga paase mumu ne Jon, laradi sep susu. ");
INSERT INTO mmx_vpl VALUES ("MT17_14","070_17_14","MAT","17","14","14","Iesu mi lavaun pinivu ren digat pas la diga ekip tangarang mi buaang limixin, la lara laradi ga vot pasa ne Iesu la ga xis tiktikbu mi luvatgulom teren. ");
INSERT INTO mmx_vpl VALUES ("MT17_15","070_17_15","MAT","17","15","15","La ni ga lok, “Leeme Silok. Una balamu lamdak tarak. Ing kanovot amisik mi lobomet la i ekip tangarang aleng mi laxasongsongot. La im subu tup amisik at laxao la at ladan. ");
INSERT INTO mmx_vpl VALUES ("MT17_16","070_17_16","MAT","17","16","16","Nia a lam ka i saparap lavaun pinivu ram kusu dina lox aroo i, ketla dixo epovo.” ");
INSERT INTO mmx_vpl VALUES ("MT17_17","070_17_17","MAT","17","17","17","La ne Iesu ga lok, “Limixin at na levenaleng kopmen tununu atnimi la levendoxoma atnimi i onon soogong. Lavanisa aleng tinotno nenia aba xip tutu mi levenmumuat atnimi? Nemi mi lox amolo ia. Una lam ka lamdak ude.” ");
INSERT INTO mmx_vpl VALUES ("MT17_18","070_17_18","MAT","17","18","18","La ne Iesu ga vaase lolos ti mo lagas, la lagas ga sixisu basinge nom lamdak. La ap mo mun loxonaleng lamdak ga lox avukat ta. ");
INSERT INTO mmx_vpl VALUES ("MT17_19","070_17_19","MAT","17","19","19","Melemu lavaun pinivu xusuk mun diga vot pasa ne Iesu la diga sue i, “Ua lavasuun teren la nema ma xo epovo xusu mana riki kepe nom lagas?” ");
INSERT INTO mmx_vpl VALUES ("MT17_20","070_17_20","MAT","17","20","20","La ne Iesu ga vorang i ridi xeretna, “Lununu atnimi i lixilik aleng. Do mi ruuna lununu i xakalik kerekngan liit mastet, nemi minaba epovo na lok ti na lakaana, ‘Una vas kaxat mede la uto at toxot petpes,’ la ni naba ronga res. La minaba epovo na lok lempanga axap bok. ");
INSERT INTO mmx_vpl VALUES ("MT17_21","070_17_21","MAT","17","21","21","Lisingising kusuk mene i epovo ri riki xepe lagas kapmek keretnom.” ");
INSERT INTO mmx_vpl VALUES ("MT17_22","070_17_22","MAT","17","22","22","Gase ne Iesu eburu mi lavaun pinivu diga vot eburu ro Galili, Iesu ga lok tidi, “I auret kusu limixin dinaba ranga alis ia, Laradi Mevana la dinaba song araba ia ri limixin esep. ");
INSERT INTO mmx_vpl VALUES ("MT17_23","070_17_23","MAT","17","23","23","La dinaba sev amer ia, ketla melemu nenia anaba roo xat amlong bok at laaleng sepsev avantun.” La lavaun pinivu diga bulu aleng. ");
INSERT INTO mmx_vpl VALUES ("MT17_24","070_17_24","MAT","17","24","24","Iesu eburu mi lavaun pinivu ren diga rupot to Kaprenaum, la luvuttadi loklok ka pilas diga vot pasa ne Pita la diga sue i, “Kereva, laradi loklox ase ram i kepe pilas bok ti loogu laplavang?” ");
INSERT INTO mmx_vpl VALUES ("MT17_25","070_17_25","MAT","17","25","25","La ne Pita ga vorang i, “Laaba.” Pita ga vot to at loogu ne Iesu gak lok teren, la ne Iesu ga vaase avot tin, la ga lok, “Simon. Kereva lodoxoma ram? Lavaorong at na lavatbung menemen di lok ka pilas meva? At limixin at lenep silok atdi kopla at limixin boro vetpes?” ");
INSERT INTO mmx_vpl VALUES ("MT17_26","070_17_26","MAT","17","26","26","Pita ga lok, “At limixin boro vetpes.” La ne Iesu ga lok, “I ven ngan ta do limixin mede kopmen di noxo kepe pilas. Kuren la ixo epovo do neda ta kepe pilas. ");
INSERT INTO mmx_vpl VALUES ("MT17_27","070_17_27","MAT","17","27","27","Ketla ta noxo lox amusak nedi na limixin. Kuren la unat pas uto at lavatdan kis la una axanom. La leemat avot una rep ka i, unaba long lenget ka legesa derakma silok to xeneng at lungusno la mo legesa derakma silok naba epovo rida kusu ti kepe pilas ti loogu laplavang.” ");
INSERT INTO mmx_vpl VALUES ("MT18_1","070_18_1","MAT","18","1","1","Ap mo mene loxonaleng lavaun pinivu at ne Iesu diga vot pasa i la diga sue i, “Nege i silok at Linintoo boro vana at laxalibet?” ");
INSERT INTO mmx_vpl VALUES ("MT18_2","070_18_2","MAT","18","2","2","La ne Iesu ga ro ka lara lamdak, la ga vaxaru i ro melamgo atdi, ");
INSERT INTO mmx_vpl VALUES ("MT18_3","070_18_3","MAT","18","3","3","la ga lok, “A tong tuturun i rinimi, tara do ixo leeng basinge laxakapmek teren la ixo lok ka luruptuvuk at laxamdak kakalik, neni xopmen na epovo do na vubeles at Linintoo no vana at laxalibet. ");
INSERT INTO mmx_vpl VALUES ("MT18_4","070_18_4","MAT","18","4","4","Laradi do i lox asi luruptuvuk teren i lok ngan luruptuvuk at lamdak lixilik, mo laradi naba ruuna ka laasen i silok aleng at Linintoo no vana at laxalibet. ");
INSERT INTO mmx_vpl VALUES ("MT18_5","070_18_5","MAT","18","5","5","La do nege i seega rangarang tamdak keretna at laasen tarak, i lok ngan ta do neni i seega rangarang ia.” ");
INSERT INTO mmx_vpl VALUES ("MT18_6","070_18_6","MAT","18","6","6","La ne Iesu ga lok bok, “Naba lok kapmek aleng ti tara do na lox asubu tara atdi na laxamdak kakalik di nunu rak. Naba lox avukat tin do dina xoxo li tangsangan tuuat to at laxaka ren la dina dong asi i min uto xopok at lisimaramain. ");
INSERT INTO mmx_vpl VALUES ("MT18_7","070_18_7","MAT","18","7","7","I lok kapmek aleng ti limixin do lentaba lempanga mo i lox asubu lununu atdi basinge ia. Lempanga xerepmo naba vot, ketla naba lok kapmek ti lara i lok kaxar i! ");
INSERT INTO mmx_vpl VALUES ("MT18_8","070_18_8","MAT","18","8","8","Mo do lakngam mi laxangkedek taram na lox asubu lununu ram, una ra korop pes i la una lu xepe min. I lox avukat do una beles at lorooro avolo mi tenep mene at luxangkedek mi lukngam. Lavanga ne Moroa na lu arup minu at laxao at lemenemen songsongot i nemen amisik. ");
INSERT INTO mmx_vpl VALUES ("MT18_9","070_18_9","MAT","18","9","9","La do laxatli ram na lox u la lununu ram na subu, una lik gogo asu min la una lu xepe min. I lox avukat do una beles at Linintoo mi tegesa xatli mun. Lavanga ne Moroa na lu arup minu ro at laxao mo do u ruuna legepu xatli.” ");
INSERT INTO mmx_vpl VALUES ("MT18_10","070_18_10","MAT","18","10","10","La ne Iesu ga lok bok tidi, “Nemen mita sok tixirixes kepe tara at na laxamdak kakalik mila lubung angelo atdi dit pot pasa amisik ne Tamak to vana at laxalibet. Nia a tong tuturun i. ");
INSERT INTO mmx_vpl VALUES ("MT18_11","070_18_11","MAT","18","11","11","La nenia, Laradi Mevana, aga vot kusu ana puse rinedi diga soogong la ana lox arooro di.” ");
INSERT INTO mmx_vpl VALUES ("MT18_12","070_18_12","MAT","18","12","12","La ne Iesu ga tong lavapaase poovo ridi, “Dola tara atnimi i ruuna legesa sangaun kobot (100) laxasipsip la legesara atdi na soogong, neni ba lok lavanga salai? Neni ba on basinge lavasik sangaun mi lavasik laxasipsip to at lenep avukat, la ni nabat pas kusu na ven ti mo legesara no ga on soogong, i se ni naba long lenget ka i. ");
INSERT INTO mmx_vpl VALUES ("MT18_13","070_18_13","MAT","18","13","13","Nia a tong tuturun i do, mo neni na vuse ka i, neni naba lok momo aleng. Lomomo ren naba volo lomomo ri mo lavasik sangaun mi lavasik di goxo soogong. ");
INSERT INTO mmx_vpl VALUES ("MT18_14","070_18_14","MAT","18","14","14","La kuren mun ne Temen nimi no vana at laxalibet i xopara i do legesara atdi na laxamdak lixilik na soogong basinge i.” ");
INSERT INTO mmx_vpl VALUES ("MT18_15","070_18_15","MAT","18","15","15","La ne Iesu ga lok bok tidi, “Mo do netam i lok tavanga i lok kapmek tu, una vot pasa i la una vaxase i mi mo losoogong teren, ketla mo lavanga nak lok kantubu xusuk mene atnumu. Mo do ni ba ronga res at levelinga ram, ura lok kaka amlong pam i ri langas in manton. ");
INSERT INTO mmx_vpl VALUES ("MT18_16","070_18_16","MAT","18","16","16","Ket do ixo ronga res at levelinga ram, una lok ka bok tegesara xopla tegepu radi eburu minu xusu miba epen mi levelinga atnimi lavantun, kerekngan lovoang kaala i tong i do, ‘Levenekarakat nabak mokso mo do tegepura xopla tavantun dina epen mi levelinga.’ ");
INSERT INTO mmx_vpl VALUES ("MT18_17","070_18_17","MAT","18","17","17","Ket do ixo ronga di, una tong i ri limixin axap di nunu. La do ixo ronga res at limixin nunu, mina sok tixirixes kepe i ngan lavamolon kopla laradi loklok ka pilas.” ");
INSERT INTO mmx_vpl VALUES ("MT18_18","070_18_18","MAT","18","18","18","La ne Iesu ga lok bok tidi, “Nia tong i rinimi xeretna. Mo levelinga u siam min kopla u sep pepe i nade xopok at na lavatbung menemen, Moroa naba siam min to vana at laxalibet. ");
INSERT INTO mmx_vpl VALUES ("MT18_19","070_18_19","MAT","18","19","19","Ana tong box i rinimi do tegepura du mulus do duna sing ti tavanga du vara rin, ne Tamak no vana at laxalibet naba raba du min. ");
INSERT INTO mmx_vpl VALUES ("MT18_20","070_18_20","MAT","18","20","20","Mila do legepura xopla lavantun di vot buru xusu dina sing ia xeneng at laasen tarak, nenia mo ak lok eburu midi.” ");
INSERT INTO mmx_vpl VALUES ("MT18_21","070_18_21","MAT","18","21","21","Melemu Pita ga vot pasa ne Iesu la ga sue i, “Leeme Silok. Nenia aba doxoma xepe laxakapmek at netak i lox i ria naba vanisa? Ba vanuti?” ");
INSERT INTO mmx_vpl VALUES ("MT18_22","070_18_22","MAT","18","22","22","La ne Iesu ga vorang i xeretna, “Nia a tong i ru. Kopmen do una doxoma xepe laxakapmek teren na vanuti mene, ketla lavanuti sangaun mi lavanuti. ");
INSERT INTO mmx_vpl VALUES ("MT18_23","070_18_23","MAT","18","23","23","Ana vaase u mi na, mila Linintoo no vana at laxalibet i lok keretna. Lara loorong mo ga doxoma i do nakling lugugu pilas ap mo luvuttadi gugu ren. ");
INSERT INTO mmx_vpl VALUES ("MT18_24","070_18_24","MAT","18","24","24","Se neni ga vaxaru kaxat ka lugugu ren, lara ap mo luvuttadi gugu ren diga lox abeles i, ga lok ka legesa sangaun larabin sangsangaun kobot talen. ");
INSERT INTO mmx_vpl VALUES ("MT18_25","070_18_25","MAT","18","25","25","Ketla neni goxo epovo na vorang mo lempilas. Kuren la loorong ga tong lolos i ri mo laradi gugu kusu neni mo diba sesep min eburu mi latkin teren la laxamdak kakalik atdu, la lempanga axap neni ga ruuna i kusu ti vorang mo lempilas. ");
INSERT INTO mmx_vpl VALUES ("MT18_26","070_18_26","MAT","18","26","26","Laradi gugu ga xis tiktikbu mi luvatgulom teren la ga lok ngangao ro melamgo at loorong la ga sing aleng i, ‘Una balamu ia, la anaba sepo axap ba lempilas taram melemu.’ ");
INSERT INTO mmx_vpl VALUES ("MT18_27","070_18_27","MAT","18","27","27","Loorong ga balamu i, kuren la neni ga doma xepe axap mo langsangan lempilas na laradi gugu ga lok ka i la loorong ga soxomus asu i. ");
INSERT INTO mmx_vpl VALUES ("MT18_28","070_18_28","MAT","18","28","28","Melemu mo laradi gugu ga vas su la ga ekip tangarang mi lara laradi gugu bok mo neni ga raba vam i mi legesa sangaun kobot denarias. Neni ga ranga alis i la ga long kukung kaka i la ga lok, ‘Una sepo lempilas tarak.’ ");
INSERT INTO mmx_vpl VALUES ("MT18_29","070_18_29","MAT","18","29","29","La mo laradi ga xis tiktikbu mi luvatgulom teren la ga sing i xeretna, ‘Una balamu ia la melemu aba vorang i!’ ");
INSERT INTO mmx_vpl VALUES ("MT18_30","070_18_30","MAT","18","30","30","Ketla neni goxopara, la ga lok ka mo laradi la ga lox abeles i ro at loogu xokoxo kusu na nemen go se at laaleng neni naba vorang amlong mo lempilas teren. ");
INSERT INTO mmx_vpl VALUES ("MT18_31","070_18_31","MAT","18","31","31","Se lentaba luvuttadi gugu diga ven na lavanga, diga bulu aleng. La digat pas uto at loorong la diga tong asu mo lempanga axap tin. ");
INSERT INTO mmx_vpl VALUES ("MT18_32","070_18_32","MAT","18","32","32","La neni ga ro xaka mo laradi gugu ukeneng la ga lok tin, ‘Nenu laradi xapmek. Aga doma xepe axap lempilas nenu uga lok ka i rak, mila uga sing ia. ");
INSERT INTO mmx_vpl VALUES ("MT18_33","070_18_33","MAT","18","33","33","Kereva, uxo epovo na balamu mo laradi xerekngan nia aga balamu u?’ ");
INSERT INTO mmx_vpl VALUES ("MT18_34","070_18_34","MAT","18","34","34","Loorong ga musak, la ga lox abeles mo laradi gugu uto at loogu xokoxo, kusu na nemen at losongsongot naba se at laaleng neni naba vorang axap mo lempilas.” ");
INSERT INTO mmx_vpl VALUES ("MT18_35","070_18_35","MAT","18","35","35","La ne Iesu ga lok, “Ne Tamak no vana at laxalibet naba lok mun nimi xuren do nemi mi noxo doxoma xepe laxakapmek tara i lox i rinimi.” ");
INSERT INTO mmx_vpl VALUES ("MT19_1","070_19_1","MAT","19","1","1","Iesu ga vaase axap mo levelinga, la ni ga vas kaxat me go Galili la gat pas uto at lenep Judaia at lenep dan meso at ladan sen Joridan. ");
INSERT INTO mmx_vpl VALUES ("MT19_2","070_19_2","MAT","19","2","2","La buaang nedi limixin diga mumu asu i la neni ga lok aroo nedi go. ");
INSERT INTO mmx_vpl VALUES ("MT19_3","070_19_3","MAT","19","3","3","Lentaba lubung Parisi diga vot pasa ne Iesu la diga lok tong i mi lara lususue xeretna, “Kereva, Laulis Linga atdik i mulus bok kusu tara na soxope latkin teren mumu mene tepanga gamasa mun?” ");
INSERT INTO mmx_vpl VALUES ("MT19_4","070_19_4","MAT","19","4","4","La ne Iesu ga vorang di xeretna, “Nemi mina xasep do Lovoang Kaala i tong i do ganoxa at lurutu kaxat Moroa ga rudum li lavatlok la lavakin. ");
INSERT INTO mmx_vpl VALUES ("MT19_5","070_19_5","MAT","19","5","5","La ni mun lavasuun at nai la ne Moroa ga lok do laradi remes naba on basinge ne temen mi nenen la nak lok eburu mi latkin teren la nedu dunak lok eburu ngan mun legesara keneng at labantuxu atdu. ");
INSERT INTO mmx_vpl VALUES ("MT19_6","070_19_6","MAT","19","6","6","La nedu du noxo lok ngan bok ba legepura, ketla legesara mun. Kuren la kopmen tara noxo ra korop leepot at leremes mi latkin teren, mila ne Moroa axa ga ven etang du.” ");
INSERT INTO mmx_vpl VALUES ("MT19_7","070_19_7","MAT","19","7","7","La lubung Parisi diga sue i, “Tila ba ne Moses ga raba nama mi levelinga xeretna, do tara na malagan tevelinga axasep ti latkin teren do neni mo i xopara na epot ta ren la na riki xepe i?” ");
INSERT INTO mmx_vpl VALUES ("MT19_8","070_19_8","MAT","19","8","8","La ne Iesu ga lok, “Moses ga raba nemi mi nom mila lebelen at lavalabat atnimi ga vatken, ketla at lurutu kaxat kopmen goxo lok kuren. ");
INSERT INTO mmx_vpl VALUES ("MT19_9","070_19_9","MAT","19","9","9","A tong tuturun i rinimi. Do laradi i soxope latkin teren la kopmen goxo lok loklok ti longka, mo laradi ira longka vam mo do i epot at lara latkin petpes manga.” ");
INSERT INTO mmx_vpl VALUES ("MT19_10","070_19_10","MAT","19","10","10","La lavaun pinivu ren diga lok tin, “Mo do i lok kuren kantubu at leremes mi latkin, i lox avukat do keke leepot.” ");
INSERT INTO mmx_vpl VALUES ("MT19_11","070_19_11","MAT","19","11","11","La ne Iesu ga lok, “Na laanasa rik lok naa kopmen na vung pavaa limixin axap, ketla tinedi xusuk mun ne Moroa i raba nedi min. ");
INSERT INTO mmx_vpl VALUES ("MT19_12","070_19_12","MAT","19","12","12","Buaang levempasuun mo ik lok, tila la lavatlok kopmen dina epot. Lentaba mumu i do diga visik axa di xuren. Lentaba mumu nga i do limixin diga lok di xuren kusu di noxo epot. La lentaba dixo epot mila, di raba lorooro atdi kusu dina gugu ngan nedi lavaanat at ne Moroa. Nege do i epovo na siam ka na laanasa ti ke leepot, i vukat do neni na mumu asu i.” ");
INSERT INTO mmx_vpl VALUES ("MT19_13","070_19_13","MAT","19","13","13","Lentaba limixin diga lok kaka laxamdak mi laxaalik kakalik atdi uto at ne Iesu kusu neni na lok li lukngen mavana atdi la na lox anarong di. Ketla lavaun pinivu ren diga ven di la diga sep pepe di. ");
INSERT INTO mmx_vpl VALUES ("MT19_14","070_19_14","MAT","19","14","14","La ne Iesu ga lok, “Mina ke laxamdak mi laxaalik kakalik dina vot pasa ia. La nemen mita sep pepe di, mila Linintoo no vana at laxalibet i epovo ridi na.” ");
INSERT INTO mmx_vpl VALUES ("MT19_15","070_19_15","MAT","19","15","15","Iesu ga lok li vam lukngen mavana atdi, la ni ga vas kaxat ta. ");
INSERT INTO mmx_vpl VALUES ("MT19_16","070_19_16","MAT","19","16","16","Lara laradi ga vot pasa ne Iesu la ga sue i, “Laradi loklox ase. Anaba lok lavanga avukat salai kusu anaba lok ka lorooro avolo?” ");
INSERT INTO mmx_vpl VALUES ("MT19_17","070_19_17","MAT","19","17","17","La ne Iesu ga vorang i rin keretna, “Ua lavasuun teren la u sue ia mi lavanga salai i lox avukat? Legesara mun i lok avukat la neni ne Moroa. Do u vara na vubeles ti lorooro, una ronga res at Lasangaun Levenaulis Linga.” ");
INSERT INTO mmx_vpl VALUES ("MT19_18","070_19_18","MAT","19","18","18","La nom laradi ga sue, “Ua lentaba?” La ne Iesu ga lok, “Nemen uta sev amet tara, nemen utang longka tixin, nemen uta xip pilo, nemen uta xarang taba mumu tara mi levelinga xaxarang, ");
INSERT INTO mmx_vpl VALUES ("MT19_19","070_19_19","MAT","19","19","19","una lok ngangao at ne tamam mi nenam, la una balamu nedi di nemen saparav u xerekngan u balamu xa u.” ");
INSERT INTO mmx_vpl VALUES ("MT19_20","070_19_20","MAT","19","20","20","La nom laradi ga lok, “Nia aga mumu asu na levelinga axap. Lavanga salai bok move nia ak pakes tin?” ");
INSERT INTO mmx_vpl VALUES ("MT19_21","070_19_21","MAT","19","21","21","Iesu ga vorang i rin keretna, “Do u vara loklok taram nan manton tino, una sesep mi lempanga axap taram, la una raba lempilas at nom lempanga ri limixin banbalo la unaba ruuna ka lapnovos silok to vana at laxalibet. La una mumu asu ba ia.” ");
INSERT INTO mmx_vpl VALUES ("MT19_22","070_19_22","MAT","19","22","22","Nom laradi ga ronga i na, la ni ga vas kaxat mi lainbulu silok mila neni gapnovos aleng. ");
INSERT INTO mmx_vpl VALUES ("MT19_23","070_19_23","MAT","19","23","23","La ne Iesu ga lok ti lavaun pinivu ren, “A tong tuturun i rinimi. I lolos aleng do laradi nopnovos na vubeles at Linintoo no vana at laxalibet. ");
INSERT INTO mmx_vpl VALUES ("MT19_24","070_19_24","MAT","19","24","24","Ana tong box i xeretna. I lolos aleng do lavatkamel na vubeles at lamamara at linil, la kerepmo i lolos aleng bok ti laradi nopnovos kusu ti beles at Linintoo at ne Moroa.” ");
INSERT INTO mmx_vpl VALUES ("MT19_25","070_19_25","MAT","19","25","25","Lavaun pinivu diga ronga i na, la diga sangu aleng la diga sue ne Iesu, “Nege ba naba lok kaka lorooro avolo?” ");
INSERT INTO mmx_vpl VALUES ("MT19_26","070_19_26","MAT","19","26","26","La ne Iesu ga ven tooro di la ga lok, “Kopmen na epovo do taradi na lox i na, ketla i epovo do ne Moroa na lok lempanga axap.” ");
INSERT INTO mmx_vpl VALUES ("MT19_27","070_19_27","MAT","19","27","27","La ne Pita ga lok tin, “Kereva ba nama, maga on basinge vam lempanga axap atnama kusu mana mumu asu u. Lempanga salai mo ne Moroa ba raba nama min?” ");
INSERT INTO mmx_vpl VALUES ("MT19_28","070_19_28","MAT","19","28","28","La ne Iesu ga vorang i ridi, “Nia a tong tuturun i rinimi. At laaleng ne Moroa na lox amaxat lempanga axap, ap mo laaleng nenia, Laradi Mevana, anabat kis at loxonin orong tarak mi lisisixam silok tarak, la nemi mi mumu asu ia, minabat kis bok at lasangaun mi legepura lengkot kitkis orong la minabang tonga linga at lasangaun mi legepura levenbibinat at limixin me Israel. ");
INSERT INTO mmx_vpl VALUES ("MT19_29","070_19_29","MAT","19","29","29","La nedi axap diga on basinge laraogu atdi, luvutneton di, luvurinen di, luvuttemen di, luvutnen di, laxamdak mi laxaalik kakalik atdi, la leventaamang atdi kusu dina lok lugugu rak, nedi dinaba ruuna ka laxampanga solo la dinaba rooro amisik at lorooro melemu. ");
INSERT INTO mmx_vpl VALUES ("MT19_30","070_19_30","MAT","19","30","30","Ketla buaang limixin di ruuna levenasen silok at na lorooro, di noxo silok at lorooro melemu. La nedi kopmen dina silok at na lorooro, dinaba silok at lorooro melemu.” ");
INSERT INTO mmx_vpl VALUES ("MT20_1","070_20_1","MAT","20","1","1","La ne Iesu ga lok bok ti lavaun pinivu ren, “Linintoo no vana at laxalibet i lok keretna. Lara laradi mo ga suubu suu maxantamak, kusu na lok ka tuvuttadi kusu dina gugu ro at laraamang vaen teren. ");
INSERT INTO mmx_vpl VALUES ("MT20_2","070_20_2","MAT","20","2","2","Mo laradi ga mulus kusu na un nedi mi legesa denarias at leges aleng, la neni ga riki aonon ta di uto at laraamang vaen. ");
INSERT INTO mmx_vpl VALUES ("MT20_3","070_20_3","MAT","20","3","3","At lavasik konaleng neni gat pas manga uto at loxot etang, la ga ven manga lentaba luvuttadi mo diga tu gamasa mun go. ");
INSERT INTO mmx_vpl VALUES ("MT20_4","070_20_4","MAT","20","4","4","La neni ga lok tidi, ‘Nemi bok minat pas la mina gugu ro at laraamang vaen tarak, la nia aba un nimi mi luunun i epovo at lugugu.’ ");
INSERT INTO mmx_vpl VALUES ("MT20_5","070_20_5","MAT","20","5","5","La diga vas kaxat. At lasangaun mi legepu xonaleng la at lavantun konaleng neni ga lok ka lentaba bok ti gugu. ");
INSERT INTO mmx_vpl VALUES ("MT20_6","070_20_6","MAT","20","6","6","Ga auret kusu na valimo xonaleng la ni gat pas manga uto at loxot etang la neni ga ven manga lentaba luvuttadi mo diga tu go, la ni ga sue di, ‘Kereva, mia tu gamasa mun nade at na laaleng axap la kopmen mina lok tepanga?’ ");
INSERT INTO mmx_vpl VALUES ("MT20_7","070_20_7","MAT","20","7","7","La diga lok tin, ‘Kopmen tara na lok kaka nama ri gugu.’ La ni ga lok, ‘Minat pas la mina gugu bok to at laraamang vaen tarak.’ ");
INSERT INTO mmx_vpl VALUES ("MT20_8","070_20_8","MAT","20","8","8","Ukantinao at lavanna konaleng temen laraamang vaen ga lok ti laradi loklok tatao at luvuttadi gugu, ‘Una xup kaka luvuttadi gugu la una un nedi mi luunun atnedi. Una ruka i atnedi nia a lok ka nedi ri lugugu na ukantinao at lavalimo konaleng la naba xap atnedi, nia a xup ka avot di maxantamak suubu.’ ");
INSERT INTO mmx_vpl VALUES ("MT20_9","070_20_9","MAT","20","9","9","Luvuttadi diga gugu kaxat at lavalimo konaleng diga lok ka legesa denarias ti legetgesa radi. ");
INSERT INTO mmx_vpl VALUES ("MT20_10","070_20_10","MAT","20","10","10","La nedi mo laradi gomgo ga xup kaka avot nedi, diga vot la diga nua i do dinaba xip ka mavana lixilik ap mo luunun, ketla nedi getgesara diga lok ka bok legesa denarias. ");
INSERT INTO mmx_vpl VALUES ("MT20_11","070_20_11","MAT","20","11","11","Diga lok ka mo lempilas la diga ruka i xusu dina paase mukmusak ti ne temen mo laraamang. ");
INSERT INTO mmx_vpl VALUES ("MT20_12","070_20_12","MAT","20","12","12","Diga lok, ‘Na luvuttadi nenu ua xup kaka amupit di, la di gugu at loxonaleng lixilik mun. La nema ma gugu at na laaleng axap maxopok at na liplivi at laxangking, ketla luunun atdi i lok ngan bok atnama.’ ");
INSERT INTO mmx_vpl VALUES ("MT20_13","070_20_13","MAT","20","13","13","Ketla temen laraamang ga lok ti legesara atdi, ‘Lentangas tarak, axo bala vukpux u. Nenu xa u siam do aba un u mi legesa denarias at leges aleng. ");
INSERT INTO mmx_vpl VALUES ("MT20_14","070_20_14","MAT","20","14","14","Una lok ka lempilas taram la una onon uto xolonu. A vara i do ana un na luvuttadi di mupit mi lempilas buaang kerekngan mun a un u min. ");
INSERT INTO mmx_vpl VALUES ("MT20_15","070_20_15","MAT","20","15","15","Ik mokso ria do ana lok lavanga salai mi lempilas tarak. La nenu u paase mumu parang ia mila nenia laradi ramtaba.’” ");
INSERT INTO mmx_vpl VALUES ("MT20_16","070_20_16","MAT","20","16","16","La ne Iesu ga lok, “La kerepmo bok nedi di mumupit at na lorooro, dinabam gomgo at lorooro melemu la nedi dim gomgo, dinaba mumupit.” ");
INSERT INTO mmx_vpl VALUES ("MT20_17","070_20_17","MAT","20","17","17","At lavatpas at ne Iesu uto Jerusalem, ni ga lam ka lasangaun mi legepura lavaun pinivu ren to basinge limixin la ga lok tidi, ");
INSERT INTO mmx_vpl VALUES ("MT20_18","070_20_18","MAT","20","18","18","“Nedik atanaba onon uto Jerusalem la lara laradi naba song araba ia, Laradi Mevana, ri lavamaasa silok eburu mi luvuttadi loklox ase at Laulis Linga. Nedi dinaba lok li ia at lavapaase la dinaba lok li lumumuat tarak do nenia ana met. ");
INSERT INTO mmx_vpl VALUES ("MT20_19","070_20_19","MAT","20","19","19","La dinaba song araba ia ri limixin esep boro Rom kusu dina paase aksaksa ria la dinabak pixis ia la dinaba vaxarem ia at laxaba. Melemu at laaleng sepsev avantun nenia anaba roo xat amlong.” ");
INSERT INTO mmx_vpl VALUES ("MT20_20","070_20_20","MAT","20","20","20","Melemu latkin at ne Sebedi ga vot parap ne Iesu mi lumdak teren. Ni ga xis tiktikbu mi luvatgulom teren to melamgo at ne Iesu, la ga vara sing i mi tara tavanga. ");
INSERT INTO mmx_vpl VALUES ("MT20_21","070_20_21","MAT","20","21","21","La ne Iesu ga sue i, “U vara lavanga salai?” La ni ga lok, “Una siam do na lumdak tarak dubat kis saparav u at Linintoo ram, lara ro at latno la lara at liviang taram.” ");
INSERT INTO mmx_vpl VALUES ("MT20_22","070_20_22","MAT","20","22","22","Ketla ne Iesu ga lok, “Mixoklen laai nemi mi sing tin.” La ni ga lok ti mo luun pinivu ren, “Kereva, mu epovo do muna suma losongsongot silok eburu minia mo a gagas kusu anaba xip tutu min?” La duga vorang i rin keretna, “Ma epovo.” ");
INSERT INTO mmx_vpl VALUES ("MT20_23","070_20_23","MAT","20","23","23","La ne Iesu ga lok, “I ruturun do nemu munaba suma levesongsongot silok. Ketla kopmen lugugu rak do nia aba tong i do nege nabat kis saparap lakngak tino la saparap lakngak kia. Mo luxot ik lok mun tinedi ne Tamak gara soxolik ka vam di.” ");
INSERT INTO mmx_vpl VALUES ("MT20_24","070_20_24","MAT","20","24","24","Se lasangaun lavaun pinivu diga ronga i na, diga edak du. ");
INSERT INTO mmx_vpl VALUES ("MT20_25","070_20_25","MAT","20","25","25","La ne Iesu ga ro bubua ka di la ga lok, “Miklen i do luvuttadi amgomgo at limixin kopmen di me Judaia, di ruuna lolos mavana at limixin atdi. ");
INSERT INTO mmx_vpl VALUES ("MT20_26","070_20_26","MAT","20","26","26","Ketla nemen gat na loklok nak lok kantubu atnimi. Mo do tara atnimi i vara i do na silok, neni na lok ngan lasaxaruki atnemi axap. ");
INSERT INTO mmx_vpl VALUES ("MT20_27","070_20_27","MAT","20","27","27","La do tara atnimi i vara i do nam gomgo, neni na lok ngan lasaxaruki gamasa atnimi. ");
INSERT INTO mmx_vpl VALUES ("MT20_28","070_20_28","MAT","20","28","28","Nenia Laradi Mevana, la loklok tarak ik lok bok kuren. Nia xopmen a goxo vot kusu limixin dinaba lok ngan lavasaxaruki rak. Ketla nia aga vot kusu ana lok ngan lasaxaruki ridi, la kusu ana raba lorooro rak ngan laxaavuk tidi buaang limixin.” ");
INSERT INTO mmx_vpl VALUES ("MT20_29","070_20_29","MAT","20","29","29","Iesu eburu mi lavaun pinivu ren, diga vas kaxat basinge lemenemen Jeriko, la buaang limixin diga emu eburu midi. ");
INSERT INTO mmx_vpl VALUES ("MT20_30","070_20_30","MAT","20","30","30","La legepu radi, lengkatli atdu ga main, mo dugat kis at lisigege ngas. Se duga ronga i do ne Iesu ga vas polo du, duga xup keretna, “Leeme Silok. Livisik li at ne Devit. Una balamu nama.” ");
INSERT INTO mmx_vpl VALUES ("MT20_31","070_20_31","MAT","20","31","31","La mo limixin diga tong i ridu do duna lok pilo, ketla dugap kup aleng, “Leeme Silok. Livisik li at ne Devit. Una balamu nama.” ");
INSERT INTO mmx_vpl VALUES ("MT20_32","070_20_32","MAT","20","32","32","La ne Iesu ga ru la ga ro xaka du la ga sue du, “Lavanga salai mu vara i do ana lox i rinumu?” ");
INSERT INTO mmx_vpl VALUES ("MT20_33","070_20_33","MAT","20","33","33","Duga vorang i xeretna, “Leeme Silok. Ma vara i do lengkatli atnama na xasep.” ");
INSERT INTO mmx_vpl VALUES ("MT20_34","070_20_34","MAT","20","34","34","Iesu ga balamu du la ga long tu at lengkatli atdu. La soso mun lengkatli atdu ga xasep la duga emu mi ne Iesu. ");
INSERT INTO mmx_vpl VALUES ("MT21_1","070_21_1","MAT","21","1","1","Iesu mi mo limixin buaang diga vas auret lemenemen silok Jerusalem, la diga rupot to at lemenemen Betpage gak lok at Lakaana Olip. La ne Iesu ga riki amgo legepu radi pinivu ren. ");
INSERT INTO mmx_vpl VALUES ("MT21_2","070_21_2","MAT","21","2","2","Avot be ni ga lok tidu xeretna, “Munat pas uto at nom lemenemen ik lok to melamgo atnumu. La soso mun munaba long lenget ka lodongki eburu mi lodongki maxat teren, mo diga xoxo li du go. Muna soxomus ka du la muna lok ka du ude. ");
INSERT INTO mmx_vpl VALUES ("MT21_3","070_21_3","MAT","21","3","3","Mo do tara na sue numu do, ‘Tila nemu mu soxomus ka i nom ludongki,’ muba lok tin do Leeme Silok i vara du la soso mun neni ba raba numu midu.” ");
INSERT INTO mmx_vpl VALUES ("MT21_4","070_21_4","MAT","21","4","4","Anai ga ravasu xusu na lox asoorun levelinga at ne Moroa lara leeme vapaase ali ga tong asu i, ");
INSERT INTO mmx_vpl VALUES ("MT21_5","070_21_5","MAT","21","5","5","“Una tong i ri limixin to Jerusalem do, ‘Pen ba i. Loorong Silok atnimi it pas saparap nimi, neni laradi loklok mulus mene la it kis at lodongki, ni lodongki maxat.’” ");
INSERT INTO mmx_vpl VALUES ("MT21_6","070_21_6","MAT","21","6","6","La mo luun pinivu duga mumu asu levelinga at ne Iesu. ");
INSERT INTO mmx_vpl VALUES ("MT21_7","070_21_7","MAT","21","7","7","Dugat pas la duga lok ka nom lodongki eburu mi lodongki maxat teren. Duga lok li levempanga singsiga atdu teren la ne Iesu ga xis teren. ");
INSERT INTO mmx_vpl VALUES ("MT21_8","070_21_8","MAT","21","8","8","La buaang limixin diga sa li levempanga singsiga atdi ro at langas. La lentaba vetpes diga ra ka lengkakan bisi la diga lok li mu langas min. ");
INSERT INTO mmx_vpl VALUES ("MT21_9","070_21_9","MAT","21","9","9","La nedi buaang limixin digat pas to melamgo la nedi axap digat pas melemu digap kup momo xeretna, “Leemi asu ri livisik li at ne Devit. Luvukat ti na laradi it pas mi laasen at Leeme Silok. Leemi asu silok tin.” ");
INSERT INTO mmx_vpl VALUES ("MT21_10","070_21_10","MAT","21","10","10","Se ne Iesu ga beles at lemenemen silok Jerusalem, limixin axap diga sangu la diga esue xeretna, “Nege mo?” ");
INSERT INTO mmx_vpl VALUES ("MT21_11","070_21_11","MAT","21","11","11","La mo limixin diga emu mi ne Iesu la diga vorang i ridi xeretna, “Na ne Iesu, leeme vapaase ali boro Galili at lemenemen Nasaret.” ");
INSERT INTO mmx_vpl VALUES ("MT21_12","070_21_12","MAT","21","12","12","La ne Iesu ga beles ukeneng at loogu laplavang la ga xala su mi limixin diga unun panga la limixin diga sesep mi lempanga atdi. La ni ga ba gili levenora lili atnedi digak lox ekun lempilas la ga ba gili levengkonin kitkis atnedi diga sesep mi levenamno. ");
INSERT INTO mmx_vpl VALUES ("MT21_13","070_21_13","MAT","21","13","13","La ni ga lok tidi, “Levelinga at ne Moroa ik lok keneng at Lovoang Kaala i lok keretna, ‘Loogu rak dinaba so asen i mi loogu singising.’ Ketla nemi mira lok kapmek pam i, i ngan loogu loklox alipe at luvuttadi dip sep paxat ka panga.” ");
INSERT INTO mmx_vpl VALUES ("MT21_14","070_21_14","MAT","21","14","14","Limixin mi lengkatli atdi ga main digat pot pasa i la nedi bok lengkangkedek atdi ga lok kapmek digat pot pasa i la ni ga lox aroo di. ");
INSERT INTO mmx_vpl VALUES ("MT21_15","070_21_15","MAT","21","15","15","Ket lavamaasa silok la luvuttadi loklox ase at Laulis Linga diga ven mo lagale lempanga sangsangu ren, la diga ronga levelinga at laxamdak mi laxaalik kakalik digap kup keretna, “Ata emi asu mi livisik li at ne Devit.” La nedi diga musak. ");
INSERT INTO mmx_vpl VALUES ("MT21_16","070_21_16","MAT","21","16","16","La diga lok tin, “Kopmen nak mokso na levelinga at na laxamdak mi laxaalik.” La ne Iesu ga lok tidi, “Mina domangke at na levelinga ik lok at Lovoang Kaala i lok keretna, ‘Nenu ne Moroa ura lox ase vam laxamdak mi laxaalik kakalik eburu mi lengkadede kusu dina emi asu minu.’” ");
INSERT INTO mmx_vpl VALUES ("MT21_17","070_21_17","MAT","21","17","17","La ne Iesu ga vas kaxat basinge di la ga vas su at lemenemen silok Jerusalem la uto Beteni, la ga midi go at laxanimin. ");
INSERT INTO mmx_vpl VALUES ("MT21_18","070_21_18","MAT","21","18","18","Ga maxantamak suubu at lomlong teren uto at lemenemen silok, Iesu ga roxo. ");
INSERT INTO mmx_vpl VALUES ("MT21_19","070_21_19","MAT","21","19","19","La ni ga ven luuna pik go at lisigege ap mo langas la ni ga vas li ren kusu na dik ka teveven una. Ketla ni goxo ven lenget ka tempeven teren, ga vavaxan gamasa mene. La ni ga lok ti mo luuna pik, “U noxo visik bok ba tempeven una!” La soso mun luuna pik ga mang ta. ");
INSERT INTO mmx_vpl VALUES ("MT21_20","070_21_20","MAT","21","20","20","Lavaun pinivu diga ven i na la diga rakdu aleng, la diga sue i, “I lok kereva na la ira mang soso?” ");
INSERT INTO mmx_vpl VALUES ("MT21_21","070_21_21","MAT","21","21","21","La ne Iesu ga lok tidi, “A tong tuturun i rinimi. Mo do mina nunu ruturun at ne Moroa la kopmen lodoxoma atnimi na sixit ekarakat at levelinga ren, minaba epovo do mina lok mun lempanga xerekngan nia a lox i ri na luuna pik. La kopmen na xusuk mun i, ketla minaba epovo bok do minaba vaase lolos ti na lakaana, la ni na xatu kaxat la na subu tup ti laras. ");
INSERT INTO mmx_vpl VALUES ("MT21_22","070_21_22","MAT","21","22","22","Do mi ruuna lununu ruturun, ne Moroa naba raba lovoporang ti mo lempanga mi sing tin.” ");
INSERT INTO mmx_vpl VALUES ("MT21_23","070_21_23","MAT","21","23","23","Iesu ga vubeles uto at loogu laplavang, la neni ga anasa limixin, la lavamaasa silok mi loxongkulao silok at lubung mixin me Judaia diga vot pasa i la diga lok, “Lavapaase axasep salai nenu u ruuna i xusu ti lox i na lempanga? La nege ga raba u mi nom lavapaase axasep?” ");
INSERT INTO mmx_vpl VALUES ("MT21_24","070_21_24","MAT","21","24","24","La ne Iesu ga vorang i ridi xeretna, “Ana sue bok nimi mi lara lususue, la do mina vorang avukat taba ia min, aba vaase axasep ba nimi, do nenia a lok na lempanga mi lavapaase axasep salai nom. ");
INSERT INTO mmx_vpl VALUES ("MT21_25","070_21_25","MAT","21","25","25","Lesep susu at ne Jon ga laa meva, boro at ne Moroa kopla boro mun at limixin?” La diga epaase xantubu atdi, la diga lok, “Mo do ata lok ‘Boro at ne Moroa,’ neni naba lok tidik keretna, ‘Tila ba mi goxo nunu at levelinga at ne Jon?’ ");
INSERT INTO mmx_vpl VALUES ("MT21_26","070_21_26","MAT","21","26","26","La mo do ata lok, ‘Boro at limixin,’ ata marat bok at limixin, mila nedi axap di nunu do ne Jon neni leeme vapaase ali.” ");
INSERT INTO mmx_vpl VALUES ("MT21_27","070_21_27","MAT","21","27","27","Kuren la diga lok ti ne Iesu, “Maxoklen i.” La ne Iesu ga lok tidi, “Nia bok a noxo tong i rinimi do, nenia a lox i na lempanga mi lavapaase axasep atnege.” ");
INSERT INTO mmx_vpl VALUES ("MT21_28","070_21_28","MAT","21","28","28","La ne Iesu ga lok bok tidi, “Mina doxoma avukat i na. Lara laradi ga ruuna lumdak, la ni ga vot pasa mo lamdak avot la ga lok, ‘Nuruk, a vara i do unat pas uto at laraamang vaen mo lingina la una gugu.’ ");
INSERT INTO mmx_vpl VALUES ("MT21_29","070_21_29","MAT","21","29","29","La ne nitna ga lok, ‘Nia a noxot pas.’ Ketla melemu neni ga lox ekun lodoxoma ren la gat pas. ");
INSERT INTO mmx_vpl VALUES ("MT21_30","070_21_30","MAT","21","30","30","La ne temendu ga vot pasa manga lamdak sepsev agepura la ga vaase manga rin mi lempapaase kerekngan neni ga vaase avot pam min ti lamdak avot. La mo lamdak ga lok, ‘Tamak, nia anaba lox i.’ Ketla neni goxot pas. ");
INSERT INTO mmx_vpl VALUES ("MT21_31","070_21_31","MAT","21","31","31","Ua lara atdu na ga lok lugugu ne temendu ga tong i?” La diga lok, “Mo lara avot.” Kuren la ne Iesu ga lok tidi, “A tong tuturun i rinimi xeretna. Luvuttadi loklok ka pilas la lavakin ngarangat mo dinabam gomgo avot tinimi uto at Linintoo at ne Moroa. ");
INSERT INTO mmx_vpl VALUES ("MT21_32","070_21_32","MAT","21","32","32","Lavasuun teren keretna. Jon, laradi sep susu, ga vot pasa nimi la ga vavang tinimi mi langas ti loklok manmanton, ketla mi goxo nunu ren. Ketla luvuttadi loklok ka pilas mi lavakin ngarangat diga nunu ren. Miga ven nedi diga leeng, ketla nemi mi goxo leeng la mi gita nunu ren.” ");
INSERT INTO mmx_vpl VALUES ("MT21_33","070_21_33","MAT","21","33","33","La ne Iesu ga lok bok tidi, “Mina ronga bok na lara lavapaase poovo. Lara laradi ga ruuna loxongkangka la gatlo laraamang vaen teren. La ni ga bos kangkan i la ga xe lamamara kusu ti loplok li levendan vaen teren. La melemu ga lok loogu xukuxut. La ni ga raba lentaba luvuttadi min kusu dina lok tatao i la neni ga vas kaxat uto at lenep petpes. ");
INSERT INTO mmx_vpl VALUES ("MT21_34","070_21_34","MAT","21","34","34","Laaleng ga vot kusu dina dik ka lempeven una at nom laraamang, laradi at laraamang ga riki lentaba lavasaxaruki ren kusu dina lok ka mo levempeven una. ");
INSERT INTO mmx_vpl VALUES ("MT21_35","070_21_35","MAT","21","35","35","Ketla nom luvuttadi loklok tatao at laraamang diga ranga alis di la diga tit pupu lara, diga sev amet lara la diga lu amet lara sepsev avantun. ");
INSERT INTO mmx_vpl VALUES ("MT21_36","070_21_36","MAT","21","36","36","La neni ga riki lavasaxaruki vetpes bok uto saparap di, buaang atdi digat pas ugo. Ketla luvuttadi loklok tatao diga lok kapmek di kerekngan nedi no avot. ");
INSERT INTO mmx_vpl VALUES ("MT21_37","070_21_37","MAT","21","37","37","La at laxavaxap neni ga riki ne nitna. Neni ga lok, ‘Nedi diba lok ngangao at lamdak tarak.’ ");
INSERT INTO mmx_vpl VALUES ("MT21_38","070_21_38","MAT","21","38","38","Ketla luvuttadi loklok tatao diga ven ne nitna gat pas go boro, la diga lok, ‘Lamdak akmokso at laradi at na laraamang nom it pas boro. Ata sev amer i, la ataba ruuna ka na laraamang.’ ");
INSERT INTO mmx_vpl VALUES ("MT21_39","070_21_39","MAT","21","39","39","La diga ranga alis i la diga lu asu min ukamang ap mo laraamang la diga sev amer i.” ");
INSERT INTO mmx_vpl VALUES ("MT21_40","070_21_40","MAT","21","40","40","La ne Iesu ga sue di, “At laaleng laradi at nom laraamang naba vot pasa nom luvuttadi loklok tatao, neni naba lok lavanga salai ridi?” ");
INSERT INTO mmx_vpl VALUES ("MT21_41","070_21_41","MAT","21","41","41","Diga vorang i rin keretna, “Neni naba sev amet di la naba raba nom laraamang ti luvuttadi vetpes kusu dina lok tatao i la at laaleng ti sep kin dinaba raba i mi loxot teren at lempeven una at nom laraamang.” ");
INSERT INTO mmx_vpl VALUES ("MT21_42","070_21_42","MAT","21","42","42","La ne Iesu ga lok tidi, “Mina domangke at levelinga at Lovoang Kaala i lok keretna, ‘Mo luuat luvuttadi xipkip gu diga sok tixirixes kepe i, ga ravasu ngan Luuat Kis la lugugu ren i silok aleng. Leeme Silok axa ga lox i na la i lox avukat aleng at levereven atdik.’ ");
INSERT INTO mmx_vpl VALUES ("MT21_43","070_21_43","MAT","21","43","43","Kuren la a tong i rinimi. Moroa naba lok kepe Linintoo basinge nemi limixin me Judaia la naba raba i ri limixin mo diba lox asuusu levempeven una nunuan. ");
INSERT INTO mmx_vpl VALUES ("MT21_44","070_21_44","MAT","21","44","44","Do tara na subu at nom luuat, neni naba rekoxorop axakalik. La do, mo luuat na subu ro mavana at tara, neni naba remumus axap.” ");
INSERT INTO mmx_vpl VALUES ("MT21_45","070_21_45","MAT","21","45","45","Lavamaasa silok la lubung Parisi diga ronga na lempapaase poovo at ne Iesu la digaklen i do neni ga paase poovo mumu di. ");
INSERT INTO mmx_vpl VALUES ("MT21_46","070_21_46","MAT","21","46","46","La diga puse ngas kusu dina ranga alis i, ketla di goxo epovo mila diga marat at limixin mo diga lok do ne Iesu neni leeme vapaase ali at ne Moroa. ");
INSERT INTO mmx_vpl VALUES ("MT22_1","070_22_1","MAT","22","1","1","Iesu ga paase manga ridi mi lavapaase poovo, ni ga lok, ");
INSERT INTO mmx_vpl VALUES ("MT22_2","070_22_2","MAT","22","2","2","“Linintoo no vana at laxalibet i lok ngan loorong ga gagas li leluxa ri loklox epot at lamdak teren. ");
INSERT INTO mmx_vpl VALUES ("MT22_3","070_22_3","MAT","22","3","3","Neni ga riki lavasaxaruki ren ti mo limixin ni gara tong li vam atdi ri mo leluxa kusu dina tong i ridi do laaleng ti leluxa ga vot pam, ketla diga ronga xepe mo levelinga. ");
INSERT INTO mmx_vpl VALUES ("MT22_4","070_22_4","MAT","22","4","4","La ni ga riki manga lentaba lavasaxaruki mi levelinga xeretna, ‘Mina tong i rinedi no nenia aga tong li vam atdi do ara gagas li vam leluxa. Nia ara sep pam laxanbulumaxao, la lempanga axap ara gagas li vam i. Mina tong i ridi do dina vas kaxat ta ri leluxa at loklox epot.’ ");
INSERT INTO mmx_vpl VALUES ("MT22_5","070_22_5","MAT","22","5","5","Ketla nedi diga ronga xepe mo levelinga la digak lox angtang mene at leven gugu atdi xa. Lara avot ga vas kaxat uto at laraamang teren. Lara bok ga lok lugugu ti sesep mi lempanga. ");
INSERT INTO mmx_vpl VALUES ("MT22_6","070_22_6","MAT","22","6","6","La nedi lentaba vetpes diga ranga alis lavasaxaruki la diga lox asongot di la diga sev amet di. ");
INSERT INTO mmx_vpl VALUES ("MT22_7","070_22_7","MAT","22","7","7","La mo loorong ga musak teng. Ni ga riki limixin esep teren la diga sev amet di la diga xotos axap lemenemen silok atdi. ");
INSERT INTO mmx_vpl VALUES ("MT22_8","070_22_8","MAT","22","8","8","La neni ga lok ti lavasaxaruki ren, ‘Leluxa i gagas pam, ketla mo luvuttadi nia aga ro ka di ti na leluxa nedi limixin kakapmek mun la ixo epovo do limixin kakapmek dinat kis at na laanan. ");
INSERT INTO mmx_vpl VALUES ("MT22_9","070_22_9","MAT","22","9","9","Minat pas uto at larangas la mina ro xaka limixin, mi ekip etangarang midi go kusu dina rupot ti leluxa rak.’ ");
INSERT INTO mmx_vpl VALUES ("MT22_10","070_22_10","MAT","22","10","10","La lavasaxaruki ren diga epeseves uto at larangas la diga ro xaka limixin axap diga ekip tangarang midi, nedi limixin avukat eburu mi limixin kakapmek. La loogu ri loklok epot ga umsu mi mo limixin. ");
INSERT INTO mmx_vpl VALUES ("MT22_11","070_22_11","MAT","22","11","11","Ketla loorong ga vubeles ti ven mo limixin, la ni ga ven lara laradi goxopmen tevempanga singsiga ren ti loklox epot. ");
INSERT INTO mmx_vpl VALUES ("MT22_12","070_22_12","MAT","22","12","12","La ni ga sue nom laradi, ‘Lentangas tarak. Nenu u beles ude xereva la kopmen tevempanga singsiga ram ti loklox epot?’ Ketla mo laradi goxo tong toxolinga. ");
INSERT INTO mmx_vpl VALUES ("MT22_13","070_22_13","MAT","22","13","13","La loorong ga tong i ri luvuttadi gugu ren keretna, ‘Mina xoxo lukngen mi luxangkedek teren la mina lu asu min uto xamang kusu neni na vubeles at lamain bonot no limixin dinabang teng boron la dinaba rungur ivivilis.’” ");
INSERT INTO mmx_vpl VALUES ("MT22_14","070_22_14","MAT","22","14","14","La ne Iesu ga lok bok, “Limixin dinaba lok kuren mila ne Moroa i toro rinedi buaang limixin, ketla lentaba mene atdi ne Moroa ba soxolik ka di.” ");
INSERT INTO mmx_vpl VALUES ("MT22_15","070_22_15","MAT","22","15","15","La lubung Parisi diga vas kaxat basinge mo lenep la diga gagas kusu dina bala arup ne Iesu mi levelinga. ");
INSERT INTO mmx_vpl VALUES ("MT22_16","070_22_16","MAT","22","16","16","La diga riki lavaun pinivu atdi eburu mi limixin diga mumu asu ne Erodes uto saparap ne Iesu. Diga lok tin keretna, “Leeme loklox ase. Maklen i do nenu laradi ruturun la u anasa limixin mi leveloklok at ne Moroa la mo levelinga ram ik mokso. Uxo lok tooro legesa binam tadi xusuk mun mila uxo doxoma solo i do tara i ruuna levenasen silok kopla kopmen. ");
INSERT INTO mmx_vpl VALUES ("MT22_17","070_22_17","MAT","22","17","17","Una tong i rinama do ua lusumsuma ram. Kereva, ik mokso do mana xepe pilas ti ne Kaisar kopla kopmen?” ");
INSERT INTO mmx_vpl VALUES ("MT22_18","070_22_18","MAT","22","18","18","Iesu ga ven kibis laxaxarang atdi la ga lok tidi, “Nemi luvuttadi loklok sosolom. Tila mi lok do mina lixo ia? ");
INSERT INTO mmx_vpl VALUES ("MT22_19","070_22_19","MAT","22","19","19","Mina lox ase ia mi tuxuven denarias mo mi kepe min.” La diga raba i mi legesa denarias. ");
INSERT INTO mmx_vpl VALUES ("MT22_20","070_22_20","MAT","22","20","20","La ni ga sue di, “Lamang la laasen atnege i nemen teren?” ");
INSERT INTO mmx_vpl VALUES ("MT22_21","070_22_21","MAT","22","21","21","La diga vorang i, “At ne Kaisar.” La ni ga lok tidi, “Mina raba ne Kaisar mi lempanga i epovo at ne Kaisar, la mina raba ne Moroa mi lempanga i epovo at ne Moroa.” ");
INSERT INTO mmx_vpl VALUES ("MT22_22","070_22_22","MAT","22","22","22","Diga ronga lovoporang teren, la diga sangu, la diga on basinge i. ");
INSERT INTO mmx_vpl VALUES ("MT22_23","070_22_23","MAT","22","23","23","Ap mo mun laaleng lentaba at lubung Sadiusi diga vot pasa ne Iesu, diga lok do limixin diga met pam, di noxo roo xat amlong. Diga lok tong pen ne Iesu xeretna, ");
INSERT INTO mmx_vpl VALUES ("MT22_24","070_22_24","MAT","22","24","24","“Leeme loklox ase. Moses ga tong i rinama do taradi na met la kopmen tamdak teren, neton nom laradi naba epot ap mo lanaa rixin, kusu duba visik tamdak ti ruuna ka lempanga ap mo laradi ga met. ");
INSERT INTO mmx_vpl VALUES ("MT22_25","070_22_25","MAT","22","25","25","Ga lavanuti loxoeton diga nemen kantubu atnama. Lara gomgo ga epot la ga met, kopmen ni goxo visik taxamdak, kuren la lara sepsev agepura ga epot manga at nom latkin. ");
INSERT INTO mmx_vpl VALUES ("MT22_26","070_22_26","MAT","22","26","26","La lara sepsev agepura ga met bok la lara sepsev avantun bok ga met. La nedi loxoeton axap diga epot at nom latkin diga met. ");
INSERT INTO mmx_vpl VALUES ("MT22_27","070_22_27","MAT","22","27","27","La melemu nom latkin ga met. ");
INSERT INTO mmx_vpl VALUES ("MT22_28","070_22_28","MAT","22","28","28","At laaleng dola limixin dina xatu kaxat amlong, ti nege rinotno nom latkin, mila nedi axap diga epot teren?” ");
INSERT INTO mmx_vpl VALUES ("MT22_29","070_22_29","MAT","22","29","29","La ne Iesu ga vorang i ridi xeretna, “Nemi mi soogong at na lavanga mila nemi xopmen mina xasep at levelinga at Lovoang Kaala la lolos at ne Moroa. ");
INSERT INTO mmx_vpl VALUES ("MT22_30","070_22_30","MAT","22","30","30","Ap mo laaleng limixin dinaba xatu kaxat amlong, di noxo epot. Dinaba nemen naa ngan lubungangelo ro vana at laxalibet. ");
INSERT INTO mmx_vpl VALUES ("MT22_31","070_22_31","MAT","22","31","31","Ketla a vara i do ana lox axasep nimi mumu laxakatu kaxat amlong at limixin basinge lanmet. Nemi mixo xasep at levelinga at ne Moroa ga raba nimi min. ");
INSERT INTO mmx_vpl VALUES ("MT22_32","070_22_32","MAT","22","32","32","Mo levelinga i lok keretna, ‘Nia ne Moroa at ne Abaram, Moroa at ne Aisak, la Moroa at ne Jakop.’ Ap mo laaleng ne Moroa ga tong i na, nedi lavantun diga met pam. La neni ne Moroa atnedi limixin di rooro, la kopmen atnedi luvuttadi met.” ");
INSERT INTO mmx_vpl VALUES ("MT22_33","070_22_33","MAT","22","33","33","Limixin diga ronga i na, la diga sangu aleng at levenanasa at ne Iesu. ");
INSERT INTO mmx_vpl VALUES ("MT22_34","070_22_34","MAT","22","34","34","Lubung Parisi diga ronga i do ne Iesu ga vaase pe lubung Sadiusi, la nedi diga vot eburu la diga vot pasa ne Iesu. ");
INSERT INTO mmx_vpl VALUES ("MT22_35","070_22_35","MAT","22","35","35","Legesara atdi, neni gaklen avukat Laulis Linga, ga lok tong pen ne Iesu. Ni ga sue i, ");
INSERT INTO mmx_vpl VALUES ("MT22_36","070_22_36","MAT","22","36","36","“Leeme loklox ase. Ua levelinga at Laulis Linga i silok ti levelinga axap teren?” ");
INSERT INTO mmx_vpl VALUES ("MT22_37","070_22_37","MAT","22","37","37","La ne Iesu ga vorang i rin, “‘Mina vavara aleng Leeme Silok, ne Moroa atnimi mi lebelen nimi axap, la mi loroonan axap atnimi, la mi levendoxoma axap atnimi.’ ");
INSERT INTO mmx_vpl VALUES ("MT22_38","070_22_38","MAT","22","38","38","Na loxot neni imgomgo la i silok ti levelinga axap teren. ");
INSERT INTO mmx_vpl VALUES ("MT22_39","070_22_39","MAT","22","39","39","La lara bok sepsev agepura i lok ngan lara gomgo, i lok keretna. ‘Mina balamu mo limixin di nemen saparap nimi kerekngan pam mi balamu nimi.’ ");
INSERT INTO mmx_vpl VALUES ("MT22_40","070_22_40","MAT","22","40","40","Laulis Linga eburu mi levenmamalagan at lavaeme vapaase ali i nemen maxopok at na levelinga.” ");
INSERT INTO mmx_vpl VALUES ("MT22_41","070_22_41","MAT","22","41","41","Lubung Parisi digak lok eburu la ne Iesu ga sue di, ");
INSERT INTO mmx_vpl VALUES ("MT22_42","070_22_42","MAT","22","42","42","“Lanarong, neni lurubuno avolo atnege mo?” La diga vorang i xeretna, “Neni lurubuno avolo at ne Devit.” ");
INSERT INTO mmx_vpl VALUES ("MT22_43","070_22_43","MAT","22","43","43","La ni ga lok tidi, “Do kuren, tila ba ne Devit mi lodoxoma at Loroonan Kaala ga soxor i do Leeme Silok teren? Mila levelinga ren at Lovoang Kaala i lok keretna, ");
INSERT INTO mmx_vpl VALUES ("MT22_44","070_22_44","MAT","22","44","44","‘Leeme Silok ne Moroa ga lok ti Leeme Silok tarak. Una xis de saparap lakngak tino se nenia ana lok li limixin munepen minu na ngan loxot burubut ti luxangkedek taram.’ ");
INSERT INTO mmx_vpl VALUES ("MT22_45","070_22_45","MAT","22","45","45","Mo do ne Devit ga so asen i do Leeme Silok, i lok kereva la Lanarong neni lurubuno avolo at ne Devit?” ");
INSERT INTO mmx_vpl VALUES ("MT22_46","070_22_46","MAT","22","46","46","Kopmen teta atdi gita epovo na vorang levelinga ren, la ga ruka i ap mo laaleng, kopmen tara gita sue i mi tususue. ");
INSERT INTO mmx_vpl VALUES ("MT23_1","070_23_1","MAT","23","1","1","Melemu ne Iesu ga vaase ri limixin eburu mi lavaun pinivu ren. Ni ga lok keretna, ");
INSERT INTO mmx_vpl VALUES ("MT23_2","070_23_2","MAT","23","2","2","“Luvuttadi loklox ase at Laulis Linga la lubung Parisi di ruuna lixitkis silok ngan ne Moses, mo gam gomgonga ri leme Israel. ");
INSERT INTO mmx_vpl VALUES ("MT23_3","070_23_3","MAT","23","3","3","Kuren la mina ronga res axap at lempanga di tong i rinimi la mina mumu asu rinotno i. Ketla nemen gat mita mu asu luruptuvuk atdi, mila dixok lok lempanga nedi di vavang min. ");
INSERT INTO mmx_vpl VALUES ("MT23_4","070_23_4","MAT","23","4","4","Dim taba limixin mi laxantaangas solo, i lok ngan di koxo li lara aknixip doxodok at limixin, la i mumuat aleng kusu dinap kiv i. Ketla nedi xa kopmen dinak lok tooro limixin kusu tip kip mo levenaknixip. ");
INSERT INTO mmx_vpl VALUES ("MT23_5","070_23_5","MAT","23","5","5","Lempanga axap dik lox i xusu limixin diba reven di la dina emi asu midi. Ni lavasuun teren la dik lok lengkonbokis lixilik tik lok li levelinga at ne Moroa ro xeneng teren. La mo lengkonbokis i silok ti mo lengkonbokis at limixin. La ding siga levempanga singsiga ri loxonaleng singising la dik lox asuusu i do di baalom aleng kusu limixin dina nunua i do nedi limixin tuturun. ");
INSERT INTO mmx_vpl VALUES ("MT23_6","070_23_6","MAT","23","6","6","Di vavara aleng lengkot kitkis nunuan to at lara peluxa, la dik lok ka lengkot avukat tit kis to xeneng at laraogu singising. ");
INSERT INTO mmx_vpl VALUES ("MT23_7","070_23_7","MAT","23","7","7","La di vavara aleng box i do limixin dinak lok ngangao atdi ro at lengkot etang, la dinap kup tidi do ‘Rabai’.” ");
INSERT INTO mmx_vpl VALUES ("MT23_8","070_23_8","MAT","23","8","8","La ne Iesu ga lok bok tidi, “Ixo lox avukat do tara na soxot nimi do Rabai, mila mi ruuna leges ‘Eme Silok’ la nemi mina epovo ngan mun loxoeton. ");
INSERT INTO mmx_vpl VALUES ("MT23_9","070_23_9","MAT","23","9","9","La nemen gat nimi guta tong tara at na lavatbung menemen do ne temen nimi, mila legesara mun neni ne Temen nimi mo ik lok to vana at laxalibet. ");
INSERT INTO mmx_vpl VALUES ("MT23_10","070_23_10","MAT","23","10","10","La nemen gat limixin dina so asen nimi do ‘luvuttadi amgomgo’ mila legesa radi gomgo atnimi la neni Lanarong. ");
INSERT INTO mmx_vpl VALUES ("MT23_11","070_23_11","MAT","23","11","11","Neni do i silok kantubu atnimi neni na ngan mun lasaxaruki atnimi. ");
INSERT INTO mmx_vpl VALUES ("MT23_12","070_23_12","MAT","23","12","12","La do nege i lox asilox i, ne Moroa naba lox alixilix i. La nege do i lox alixilix i, ne Moroa naba lox asilox i.” ");
INSERT INTO mmx_vpl VALUES ("MT23_13","070_23_13","MAT","23","13","13","La ne Iesu ga lok bok, “Naba lok kapmek aleng tinimi, luvuttadi loklox ase at Laulis Linga eburu minemi lubung Parisi. Nemi luvuttadi loklok sosolom. Mik soxoba pe lumusmaragu ri Linintoo no vana at laxalibet kusu limixin kopmen dina epovo dina beles teren. Ketla nemi xa xopmen mi noxo beles teren la mi tupe mo lumusmaragu ri limixin dik lok tong i xusu dina beles. ");
INSERT INTO mmx_vpl VALUES ("MT23_14","070_23_14","MAT","23","14","14","Naba lok kapmek aleng tinimi, luvuttadi loklox ase at Laulis Linga eburu minemi lubung Parisi. Nemi luvuttadi loklok sosolom. Mip kip pilo lempanga at lempatnaa rixin, la melemu at na mik lok levesingising to melamgo at limixin kusu tik lox ase di do loklok atnimi i nunuan axap. Kuren la ne Moroa naba lok li lumumuat silok atnimi. ");
INSERT INTO mmx_vpl VALUES ("MT23_15","070_23_15","MAT","23","15","15","Naba lok kapmek aleng tinemi luvuttadi loklox ase at Laulis Linga eburu minemi lubung Parisi. Nemi luvuttadi loklok sosolom. Mit pas tangtagap at laxangka la miang kan bok at laras kusu minak lok ka tara xusu ni na ruuna ka lununu kerekngan lununu atnimi. La do tara ira ruuna ka vam mo lununu, mi gagas li i xusu neni naba epovo rinotno kusu nat pas epopolo uto at lemenemen songsongot. ");
INSERT INTO mmx_vpl VALUES ("MT23_16","070_23_16","MAT","23","16","16","Naba lok kapmek aleng mun tinimi, mila nemi limixin lengkatli atnimi i main la nemi xa xopmen mina epovo kusu mina lok tooro limixin. Mi tong i do lavangpangpe at tara i ngan lavanga gamasa, mo do i vangpe mi loogu laplavang. Ket do ni i vangpe mi logol i nemen keneng at loogu laplavang, nemi miba doxoma atmatkun mo laxakaape ren. ");
INSERT INTO mmx_vpl VALUES ("MT23_17","070_23_17","MAT","23","17","17","Nemi luvuttadi rangtangku la lengkatli at labaroonan atnimi i main. Loogu laplavang neni i lox axaala mo logol. La loogu laplavang i silok ti logol la i xaala aleng, kopmen logol. ");
INSERT INTO mmx_vpl VALUES ("MT23_18","070_23_18","MAT","23","18","18","Mi tong box i do lavangpangpe at tara ni lavanga gamasa mun, mo do i vangpe mi loxonin laplavang to at loogu laplavang. Ket do ni na vangpe mavana at leventamtaba mo ik lok pana at nom loxonin laplavang, nemi mi lox amuat mo lavangpangpe ren. ");
INSERT INTO mmx_vpl VALUES ("MT23_19","070_23_19","MAT","23","19","19","Nemi laxangkatli main. Loxonin laplavang i silok ti mo leventamtaba la i lox axaala mo leventamtaba. ");
INSERT INTO mmx_vpl VALUES ("MT23_20","070_23_20","MAT","23","20","20","Kuren la do tara na vangpe mi loxonin laplavang, neni i lok lavangpangpe min eburu mi leventamtaba mo ik lok teren. ");
INSERT INTO mmx_vpl VALUES ("MT23_21","070_23_21","MAT","23","21","21","La do i vangpe mi loogu laplavang, neni i vangpe min eburu mi ne Moroa mo ik lok keneng teren. ");
INSERT INTO mmx_vpl VALUES ("MT23_22","070_23_22","MAT","23","22","22","La do i vangpe mi laxalibet, neni i vangpe mi loxonin orong at ne Moroa eburu mi ne Moroa mo it kis teren. ");
INSERT INTO mmx_vpl VALUES ("MT23_23","070_23_23","MAT","23","23","23","Naba lok kapmek aleng tinimi luvuttadi loklox ase at Laulis Linga eburu minemi lubung Parisi. Nemi luvuttadi loklok sosolom! Mim taba ne Moroa mi loxot i sev asangaun ap mo levempanga ik lok at laraamang, ketla mixo mumu asu leveloklok silok at Laulis Linga, i ngan loklok manmanton, lebelen tuntun, loklok nunuan ti lentaba vetpes, la loklok tuturun ti lentaba vetpes. Na leveloklok i epovo do mina lox asuusu i eburu mi mo loklok ti raba ne Moroa mi loxot i sev asangaun. ");
INSERT INTO mmx_vpl VALUES ("MT23_24","070_23_24","MAT","23","24","24","Nemi laxangkatli main. Mi mumu asu lengkot at Laulis Linga kopmen na mumuat, ketla mixo mumu asu solo mo leveloklok i mumuat. I ngan ta do mi lox asu levenulang kakalik basinge lengkadan vaen atnimi la mi ke lavatkamel nak lok teren. ");
INSERT INTO mmx_vpl VALUES ("MT23_25","070_23_25","MAT","23","25","25","Naba lok kapmek aleng tinimi luvuttadi loklox ase at Laulis Linga eburu minemi lubung Parisi! Nemi luvuttadi loklok sosolom. Mi sogos anunuan i no maxamang at leveng kap la leventingtigon, ketla no ma xeneng i umsu aleng mi loklok ti sak paxat ka panga la loklok ti belegaao. ");
INSERT INTO mmx_vpl VALUES ("MT23_26","070_23_26","MAT","23","26","26","Nemi lubung Parisi. Nemi lengkatli main. Mina gos anunuan avot be i no ma xeneng at lakap, la melemu no maxamang ba lok nunuan ba. ");
INSERT INTO mmx_vpl VALUES ("MT23_27","070_23_27","MAT","23","27","27","Naba lok kapmek aleng tinimi luvuttadi loklox ase at Laulis Linga eburu minemi lubung Parisi. Nemi luvuttadi loklok sosolom. Mi ven ngan tinotno lempat maaut diga mo anbun i, i ven avukat to maxamang, ketla no ma xeneng i umsu mi laxasi tongan la laxanorang. ");
INSERT INTO mmx_vpl VALUES ("MT23_28","070_23_28","MAT","23","28","28","Nemi bok mi lok ngan i nom, maxamang atnimi, limixin di ven nimi ngan luvuttadi manmanton la mi mumu asu Laulis Linga, ketla ma xeneng at lebelen nimi mi umsu mi loklok sosolom la loklok kakapmek aleng tino bok. ");
INSERT INTO mmx_vpl VALUES ("MT23_29","070_23_29","MAT","23","29","29","Naba lok kapmek aleng tinimi luvuttadi loklox ase at Laulis Linga eburu minemi lubung Parisi. Nemi luvuttadi loklok sosolom. Mira vaxaru ka vam levenmaaut avukat ti lavaeme vapaase ali, la mi sisinang avukat levenmaaut at limixin manmanton. ");
INSERT INTO mmx_vpl VALUES ("MT23_30","070_23_30","MAT","23","30","30","La mi lok keretna, ‘Mo do nedik gita nemen ap mo levenaleng lavalabat atdik diga rooro ren, nedik gitoxo sev amet lavaeme vapaase ali.’ ");
INSERT INTO mmx_vpl VALUES ("MT23_31","070_23_31","MAT","23","31","31","La kerepmo mi tong asu i do nemi livipisik li ap mo limixin sepsep tadi, diga sev amet lavaeme vapaase ali. ");
INSERT INTO mmx_vpl VALUES ("MT23_32","070_23_32","MAT","23","32","32","Nemi bok limixin sepsep tadi, mi epovo do mina lox epasum na laxakapmek ti laxakapmek atnedi. ");
INSERT INTO mmx_vpl VALUES ("MT23_33","070_23_33","MAT","23","33","33","Nemi laxasii xapmek. Nemi laxamdak at lempasii. Ixo epovo do mina sixiro basinge lebelemamao at ne Moroa mo naba riki nimi uto at lemenemen songsongot. ");
INSERT INTO mmx_vpl VALUES ("MT23_34","070_23_34","MAT","23","34","34","Kuren la anaba riki lavaeme vapaase ali eburu mi luvuttadi leklen la luvuttadi loklox ase saparap nimi. Lentaba atdi minaba vaxarem di at larakaba la minabap sev amet di. La lentaba atdi minabak pixis di ro xeneng at laraogu singising la minaba xala su mi lentaba atdi basinge levenmenemen atdi la uto at levenmenemen petpes. ");
INSERT INTO mmx_vpl VALUES ("MT23_35","070_23_35","MAT","23","35","35","Kuren la minaba xip tutu mi lanmet at limixin manmanton at na lavatbung menemen. Ga ruka i mi lanmet at ne Abel ga se at lanmet at ne Sakaria, nitna ne Berakaia, mo lavalabat atnimi diga sev amer i ro xantubu at loogu laplavang la loxonin laplavang. ");
INSERT INTO mmx_vpl VALUES ("MT23_36","070_23_36","MAT","23","36","36","Nia a tong tuturun i dola na loola di rooro lingina dinaba xip tutu mi na laxakapmek axap atnedi luvuttadi sepsep tadi.” ");
INSERT INTO mmx_vpl VALUES ("MT23_37","070_23_37","MAT","23","37","37","La ne Iesu ga bulu aleng la ga lok, “Nemi limixin me Jerusalem. Lavalabat atnimi digap sev amet lavaeme vapaase ali at ne Moroa la diga lu amet nedi ne Moroa ga riki di. Buaang levenaleng a lok do ana kok nimi mi lukngak, i ngan lavatpalak kaxak i kok laxan natnat kaxak teren, ketla mixo siam ka ia. ");
INSERT INTO mmx_vpl VALUES ("MT23_38","070_23_38","MAT","23","38","38","I ruturun. Monga Moroa i lox axap loklok tatao ren tinimi. ");
INSERT INTO mmx_vpl VALUES ("MT23_39","070_23_39","MAT","23","39","39","A tong tuturun i rinimi do mi noxo ven bok ba ia, se at nom laaleng naba vot la minaba lok keretna, ‘Luvukat ti mo laradi it pas mi laasen at Leeme Silok.’” ");
INSERT INTO mmx_vpl VALUES ("MT24_1","070_24_1","MAT","24","1","1","Iesu ga vas kaxat basinge loogu laplavang la at lavatpas teren, lavaun pinivu ren diga vot pasa i la diga paase mumu loogu laplavang la laraogu at ne Moroa ga tu saparav i. ");
INSERT INTO mmx_vpl VALUES ("MT24_2","070_24_2","MAT","24","2","2","La ni ga lok tidi, “Mina ven avukat nom laraogu. A tong tuturun i rinimi. Taaleng naba vot la kopmen toxonuat at nom laraogu naba nemen at loxot teren. Limixin esep dinaba vot la dinaba ut tereve axav i ukopok.” ");
INSERT INTO mmx_vpl VALUES ("MT24_3","070_24_3","MAT","24","3","3","Melemu ne Iesu gat kis to at Lakaana Olip la lavaun pinivu xusuk teren diga vot pasa i la diga sue i xeretna, “Una tong i rinama. Lingisa nom lempanga naba vot la loklok katling salai naba lok katling lovotpot taram eburu mi laxavaxap at na levenaleng?” ");
INSERT INTO mmx_vpl VALUES ("MT24_4","070_24_4","MAT","24","4","4","La ne Iesu ga vorang i ridi xeretna, “Mina lok tatao avukat nimi kusu tara noxo xarang arup nimi mumu i na lempanga. ");
INSERT INTO mmx_vpl VALUES ("MT24_5","070_24_5","MAT","24","5","5","Mila buaang luvuttadi dinaba rupot mi laasen tarak la dina lok, ‘Nenia Lanarong!’ La dinaba sar asoogong buaang limixin mi laxalinga xaxarang atdi. ");
INSERT INTO mmx_vpl VALUES ("MT24_6","070_24_6","MAT","24","6","6","Minaba ronga i do lara esep mo ik lok la lara esep bok naba vot, ketla nemen mita marat teren. Lempanga xerepmo naba vot ketla laxavaxap at na lavatbung menemen noxo vot ap mo levenaleng. ");
INSERT INTO mmx_vpl VALUES ("MT24_7","070_24_7","MAT","24","7","7","Limixin at lentaba levenabung mixin dinaba esep eburu mi limixin at levenabung mixin petpes. Lavaorong at lentaba levengkitkis orong dinaba esep mi lavaorong at levengkitkis orong petpes. Lean kangking la levenangne naba vot at tengkot. ");
INSERT INTO mmx_vpl VALUES ("MT24_8","070_24_8","MAT","24","8","8","Anaa axav i naba ru katling lavakpaxaru kaxat ap mo levenmaares at levenmumuat. ");
INSERT INTO mmx_vpl VALUES ("MT24_9","070_24_9","MAT","24","9","9","Melemu limixin dinaba ranga alis nimi la dina lox asongot nimi la lentaba atnimi dinaba sev amet di la limixin at lengkot axap dinaba belengatngas tinimi mila nemi limixin tarak. ");
INSERT INTO mmx_vpl VALUES ("MT24_10","070_24_10","MAT","24","10","10","Ap mo laaleng buaang limixin dinaba ke xepe lununu atdi la di noxo ebalamu ela la dinaba song araba di ri limixin kakapmek. ");
INSERT INTO mmx_vpl VALUES ("MT24_11","070_24_11","MAT","24","11","11","La buaang lavaeme vapaase ali xaxarang dinaba vot la dinaba sar asoogong buaang limixin. ");
INSERT INTO mmx_vpl VALUES ("MT24_12","070_24_12","MAT","24","12","12","Laxakapmek naba umsu, kuren la labalamu noxo nemen kantubu at limixin. ");
INSERT INTO mmx_vpl VALUES ("MT24_13","070_24_13","MAT","24","13","13","Ketla do tara na tu tuxuruxun at lununu ren se at laxavaxap ap mo levenmaares, Moroa naba lox arooro i. ");
INSERT INTO mmx_vpl VALUES ("MT24_14","070_24_14","MAT","24","14","14","La dinaba tong asu Lagale Lavavang mumu Linintoo ngan lavapaase asu ri limixin at lengkot axap, la melemu ba ren laxavaxap at na lavatbung menemen naba vot.” ");
INSERT INTO mmx_vpl VALUES ("MT24_15","070_24_15","MAT","24","15","15","La ne Iesu ga lok bok tidi, “Minaba ven lavanga naba lok kapmek aleng, kerekngan leeme vapaase ali ne Daniel ga paase mumu i. Na lavanga xapmek naba tu ro xeneng at Loxot Kaala aleng at loogu laplavang la kerepmo naba lox amulao mo loxot.” Nege do na us i na, neni na xasep avukat at lavasuun at na levelinga. ");
INSERT INTO mmx_vpl VALUES ("MT24_16","070_24_16","MAT","24","16","16","La ne Iesu ga lok bok, “Ap mo laaleng nedi limixin do dina nemen to Judaia, dinaba sixiro uto at lempatkaana. ");
INSERT INTO mmx_vpl VALUES ("MT24_17","070_24_17","MAT","24","17","17","Laradi do nak lok to mavana at loogu ren, ni noxo si kusu na lok ka lempanga ren boro xeneng ap mo loogu ren. ");
INSERT INTO mmx_vpl VALUES ("MT24_18","070_24_18","MAT","24","18","18","La laradi do nak lok to xataamang, ni noxomlong bok ba uto at loogu ren kusu na lok ka lavanga singsiga ren. ");
INSERT INTO mmx_vpl VALUES ("MT24_19","070_24_19","MAT","24","19","19","Mo laaleng naba lok kapmek aleng ti lavakin teenan eburu mi lavakin mi levengkadede atdi! ");
INSERT INTO mmx_vpl VALUES ("MT24_20","070_24_20","MAT","24","20","20","Mina ngising ne Moroa do mo laaleng noxo vot saparap nimi edompo mi taaleng kabu kopla taaleng kaala. ");
INSERT INTO mmx_vpl VALUES ("MT24_21","070_24_21","MAT","24","21","21","Levenmumuat ap mo levenaleng naba lok kapmek aleng tinotno. Ga ruka i at lurutu kaxat at na lavatbung menemen ise nga na lingina, kovisi taaleng kerepmo ga vot, la kopmen bok tara tumumuat kerepmo naba vot melemu. ");
INSERT INTO mmx_vpl VALUES ("MT24_22","070_24_22","MAT","24","22","22","La mo levenaleng ti mo levenmumuat do ne Moroa noxo lox atmur i, kopmen teta naba roo su. Ketla ne Moroa naba lox asuusu labalamu ren ti mo limixin neni gara soxolik ka vam di, la ni naba lox atmut mo levenaleng. ");
INSERT INTO mmx_vpl VALUES ("MT24_23","070_24_23","MAT","24","23","23","Ap mo levenaleng nemen gat mita nunu at levelinga at tara na lok tinimi xeretna, ‘Mina ven ba i, neni nga na Lanarong!’ Kopla na lok, ‘Neni nga no!’ Nemen mita nunu at nom levelinga atdi. ");
INSERT INTO mmx_vpl VALUES ("MT24_24","070_24_24","MAT","24","24","24","Mila buaang nedi limixin babala dinaba lok do nedi mo lavanarong at ne Moroa la lavaeme vapaase ali ren. Dinaba lok tempanga sangsangu kusu dinaba sar asoogong lavaanat soxolik at ne Moroa, mo do di epovo. ");
INSERT INTO mmx_vpl VALUES ("MT24_25","070_24_25","MAT","24","25","25","Mina ronga avukar i na. A tong ali avot ta i rinimi. ");
INSERT INTO mmx_vpl VALUES ("MT24_26","070_24_26","MAT","24","26","26","La mo do tentaba dina lok tinimi, ‘Mina ven ba Lanarong, no nga i at lamatbin!’ Nemen gat nimi guta vas kaxat ugo. La do dina lok tinimi, ‘Mina ven ba i, nanga i lipe de at na loogu!’ Nemen gat nimi guta nunu atdi, ");
INSERT INTO mmx_vpl VALUES ("MT24_27","070_24_27","MAT","24","27","27","mila nenia, Laradi Mevana, anaba vot soso ngan lavanga i mam to at levengkot axap, i tara koxorop lara takabu de vana at lamavangkap. ");
INSERT INTO mmx_vpl VALUES ("MT24_28","070_24_28","MAT","24","28","28","Ap mo loxot limixin dinaba met teren, lempatmaalom dinaba vot buru ve kusu ti anan levenbaaxin tadi.” ");
INSERT INTO mmx_vpl VALUES ("MT24_29","070_24_29","MAT","24","29","29","La ne Iesu ga lok bok, “La soso mun melemu at levenmumuat ap mo levenmaares, leveloklok katling naba vot, ‘Losoosoo at laxangking naba xap, la lagaaling noxo soosoo. Larapenti naba subu si boro vana at lamavangkap eburu mi lempanga axap meve dinaba sixit ekarakat la kopmen di noxo sixit mu larangas atdi.’ ");
INSERT INTO mmx_vpl VALUES ("MT24_30","070_24_30","MAT","24","30","30","Ap mo laaleng loklok katling tarak, Laradi Mevana naba vor asuvos to vana at lamavangkap, la limixin at larabung mixin axap dinabang teng. Dinaba ven ia, Laradi Mevana, anaba vot at loxontakabu mi langsangan lolos la lisisixam silok. ");
INSERT INTO mmx_vpl VALUES ("MT24_31","070_24_31","MAT","24","31","31","La lubung angelo dinaba ronga lerengteng at luru la nia anaba riki di uto at lengkot axap kusu dina lam kaka lavaanat soxolik at ne Moroa boro at lavanuet laramesuluk at lavanuet laramera manman at na lavatbung menemen.” ");
INSERT INTO mmx_vpl VALUES ("MT24_32","070_24_32","MAT","24","32","32","La ne Iesu ga tong lara lavapaase poovo ridi xeretna, “Mina ronga na laanasa mumu luuna pik. Dola levesisilik at larauna pik di mumulum la levenang i suu xat, nemi miklen i do lamaares i auret ta. ");
INSERT INTO mmx_vpl VALUES ("MT24_33","070_24_33","MAT","24","33","33","La kerepmo do mina ven na lempanga loklok katling na vot, mina xasep do lovotpot tarak, Laradi Mevana i auret. I ngan laradi i tu at lumusmaragu at loogu la i gagas kusu na beles teren. ");
INSERT INTO mmx_vpl VALUES ("MT24_34","070_24_34","MAT","24","34","34","Nia a tong tuturun i rinimi. Limixin at na loola di rooro lingina di noxo met se na lempanga na ravasu. ");
INSERT INTO mmx_vpl VALUES ("MT24_35","070_24_35","MAT","24","35","35","Laxalibet mi lavatbung menemen naba sonao, ketla levelinga rak noxo xap.” ");
INSERT INTO mmx_vpl VALUES ("MT24_36","070_24_36","MAT","24","36","36","La ne Iesu ga lok bok, “Kopmen tara naklen laaleng at lovotpot tarak. Lubung angelo bok kopmen dinaklen i la nenia, ne Nitna bok kopmen anaklen i. Tamak kusuk mun iklen i. ");
INSERT INTO mmx_vpl VALUES ("MT24_37","070_24_37","MAT","24","37","37","At lovotpot at Laradi Mevana, loklok at limixin naba lok ngan loklok at limixin ap mo levenaleng at ne Noa. ");
INSERT INTO mmx_vpl VALUES ("MT24_38","070_24_38","MAT","24","38","38","Ap mo levenaleng avot ti mo laraan limixin diga anan la diga inin, lavatlok la lavakin diga vepot ga se at nom laaleng ne Noa ga beles ti lavatmon. ");
INSERT INTO mmx_vpl VALUES ("MT24_39","070_24_39","MAT","24","39","39","Mo limixin kopmen di goxoklen i do laraan mo naba vot, ketla ga rupot la ga sev amet axap nedi. Laaleng at lovotpot tarak, Laradi Mevana naba lok kuren. ");
INSERT INTO mmx_vpl VALUES ("MT24_40","070_24_40","MAT","24","40","40","Ap mo laaleng tegepu radi dunaba gugu ro xataamang. Lubung angelo dinaba lok ka legesara la lara naba nemen alu. ");
INSERT INTO mmx_vpl VALUES ("MT24_41","070_24_41","MAT","24","41","41","Tegeputkin dunaba sep povorok levempiao. Lubung angelo dinaba lok ka legesara la lara naba nemen alu. ");
INSERT INTO mmx_vpl VALUES ("MT24_42","070_24_42","MAT","24","42","42","Kuren la mina lok tatao avukat nimi mila kopmen minaklen i do at ua laaleng nenia, Leeme Silok atnimi, anabamlong teren. ");
INSERT INTO mmx_vpl VALUES ("MT24_43","070_24_43","MAT","24","43","43","Ketla mina xasep at na lavapaase poovo. Mo do laradi at loogu iklen i do at ua loxonaleng laradi xipkip pilo ba vot teren, neni ba kuxut avukat la laradi xipkip pilo noxo das beles at loogu ren. ");
INSERT INTO mmx_vpl VALUES ("MT24_44","070_24_44","MAT","24","44","44","Kuren la mina gagas avukat mila nenia, Laradi Mevana, anaba vot ap mo laaleng limixin di doxoma i do nenia a noxo vot teren. ");
INSERT INTO mmx_vpl VALUES ("MT24_45","070_24_45","MAT","24","45","45","Mo laradi ruturun la lasaxaruki avukat, neni mo, leeme silok teren ba lok katling i xusu na lok tatao lavasaxaruki ren la nam taba di mi levempanga anan at levengkonaleng mokmokso. ");
INSERT INTO mmx_vpl VALUES ("MT24_46","070_24_46","MAT","24","46","46","Naba lox avukat ti mo laradi mo do leeme silok teren nabamlong la na long lenget ka i do i lox epovo lugugu ren. ");
INSERT INTO mmx_vpl VALUES ("MT24_47","070_24_47","MAT","24","47","47","Nia a tong tuturun i do mo leeme silok naba lok li mo laradi kusu na lok tatao levempanga axap teren. ");
INSERT INTO mmx_vpl VALUES ("MT24_48","070_24_48","MAT","24","48","48","Ket do nom laradi neni laradi xapmek la i lok, ‘Leeme silok tarak noxomlong soso.’ ");
INSERT INTO mmx_vpl VALUES ("MT24_49","070_24_49","MAT","24","49","49","La ip sev asongot lentaba lavasaxaruki la i anan la ira inin tangtangku eburu mi limixin di inin tangtangku amisik. ");
INSERT INTO mmx_vpl VALUES ("MT24_50","070_24_50","MAT","24","50","50","Leeme silok teren nabamlong at tara taaleng lasaxaruki ren ixo doxoma i do ni naba vot teren la at loxonaleng neni kopmen naklen i. ");
INSERT INTO mmx_vpl VALUES ("MT24_51","070_24_51","MAT","24","51","51","Nom leeme silok naba sev asongot aleng nom lasaxaruki ren la ni naba riki i uto at lemenemen songsongot kusu na nemen eburu minedi luvuttadi loklok sosolom. Mo go dinabang teng la dina rungur ivivilis.” ");
INSERT INTO mmx_vpl VALUES ("MT25_1","070_25_1","MAT","25","1","1","La ne Iesu ga tong bok lavapaase poovo. Ni ga lok keretna, “At laaleng at lovotpot tarak, Linintoo no vana at laxalibet ba lok ngan lasangaun lovosono maxat diga lok ka levenbabao atdi la digat pas kusu dina ekip tangarang mi laradi ga gagas kusu na epot. ");
INSERT INTO mmx_vpl VALUES ("MT25_2","070_25_2","MAT","25","2","2","Lavalimo atdi diga baulang, la lavalimo atdi digakleklen. ");
INSERT INTO mmx_vpl VALUES ("MT25_3","070_25_3","MAT","25","3","3","Lovosono rangtangku diga lok ka levenbabao atdi, ketla di goxo lok ka tengkondan loklox antos ti mo levenbabao atdi. ");
INSERT INTO mmx_vpl VALUES ("MT25_4","070_25_4","MAT","25","4","4","Ketla lavalimo lovosono leklen diga lok ka levengkondan loklox antos babao eburu mi levenbabao atdi. ");
INSERT INTO mmx_vpl VALUES ("MT25_5","070_25_5","MAT","25","5","5","Nedi axap lovosono maxat diga ngangais abao rino, ketla mo laradi ga gagas ti epot kopmen goxo vot soso. Kuren la lemerendi ga unga la nedi axap diga unga nga. ");
INSERT INTO mmx_vpl VALUES ("MT25_6","070_25_6","MAT","25","6","6","At laxanimin tubu limixin diga xup aoon min keretna, ‘Laradi i gagas ti epot nom ta i boro! Minat pas la mina ekip tangarang min!’ ");
INSERT INTO mmx_vpl VALUES ("MT25_7","070_25_7","MAT","25","7","7","La nedi lasangaun lovosono maxat diga aus kaxat la diga lox agagas levenbabao atdi. ");
INSERT INTO mmx_vpl VALUES ("MT25_8","070_25_8","MAT","25","8","8","La lavalimo lovosono rangtangku diga lok ti mo lovosono leklen, ‘Mina raba nama mi tengkondan soksox antos babao, mila levenbabao atnama i xapkap tino.’ ");
INSERT INTO mmx_vpl VALUES ("MT25_9","070_25_9","MAT","25","9","9","Ketla lavalimo lovosono leklen diga vorang i ridi xeretna, ‘Kopmen. Agut lengkondan soksok antos babao xopmen na epovo do ridik axap. Minat pas uto at luvuttadi sesep la mina un kaka tengkot tinimi.’ ");
INSERT INTO mmx_vpl VALUES ("MT25_10","070_25_10","MAT","25","10","10","La lovosono rangtangku digat pas kusu ti un kaka tengkondan soksox antos babao. Ise diga onon, laradi ga gagas ti epot ga vot, la nedi lavalimo lovosono leklen diga vubeles eburu min ukeneng at leluxa at loklox epot, la lumusmaragu ga repe nga. ");
INSERT INTO mmx_vpl VALUES ("MT25_11","070_25_11","MAT","25","11","11","Melemu lavalimo lovosono rangtangku diga vot la diga lok, ‘Leeme silok. Leeme silok. Una suang abeles nama.’ ");
INSERT INTO mmx_vpl VALUES ("MT25_12","070_25_12","MAT","25","12","12","Ketla ni ga vorang i ridi xeretna, ‘Nia a tong tuturun i. Axoklen nimi!’” ");
INSERT INTO mmx_vpl VALUES ("MT25_13","070_25_13","MAT","25","13","13","La ne Iesu ga lok tidi, “Mina gagas avukat, mila mi xoklen laaleng kopla loxonatat aleng at lovotpot tarak, Leeme Silok atnimi.” ");
INSERT INTO mmx_vpl VALUES ("MT25_14","070_25_14","MAT","25","14","14","La ne Iesu ga tong bok lavapaase poovo. Ni ga lok, “Ap mo laaleng Linintoo no vana at laxalibet naba lok keretna. Lara leeme silok gat pas uto vaxalom. Avot ti lavatpas kaxat teren, neni ga xup kaka lavasaxaruki ren la ga lok taba di mi levempanga ren kusu dinak lok tatao i. ");
INSERT INTO mmx_vpl VALUES ("MT25_15","070_25_15","MAT","25","15","15","Ti lasaxaruki avot teren neni ga raba i mi lavalimo talen. Ti lara sepsev agepura neni ga raba i mi legepu talen. La ti lara sepsev avantun neni ga raba i mi legesa talen. Neni ga raba di min kuren, ga epovo mi lakleklen atdi. La ni ga vas kaxat basinge di. ");
INSERT INTO mmx_vpl VALUES ("MT25_16","070_25_16","MAT","25","16","16","Mo lara ga lok ka lavalimo talen, soso mun neni gat pas la ga gugu mi mo leventalen la ga ruuna ka bok lavalimo talen. ");
INSERT INTO mmx_vpl VALUES ("MT25_17","070_25_17","MAT","25","17","17","La mo bok lara ga lok ka legepu talen, neni bok ga gugu min la ga ruuna ka bok legepu talen. ");
INSERT INTO mmx_vpl VALUES ("MT25_18","070_25_18","MAT","25","18","18","Ketla mo lara ga lok ka legesa talen, neni gat pas, ga xe lamamara la ga lox alipe mo legesa talen at leeme silok teren. ");
INSERT INTO mmx_vpl VALUES ("MT25_19","070_25_19","MAT","25","19","19","Melemu at lentaba leven gaaling ga volo, leeme silok ap mo lavasaxaruki gamlong la ga xup kaka di kusu dina paase mumu lempilas digara lok ka vam i. ");
INSERT INTO mmx_vpl VALUES ("MT25_20","070_25_20","MAT","25","20","20","Mo lasaxaruki avot ga lok ka vam lavalimo talen, ga vot pasa mo leeme silok la ga lok tin, ‘Leeme silok. Nenu ga raba ia mi lavalimo talen la nia agara gu asu vam lara lavalimo talen bok.’ ");
INSERT INTO mmx_vpl VALUES ("MT25_21","070_25_21","MAT","25","21","21","La mo leeme silok ga lok tin, ‘I lox avukat aleng. Nenu lagale lasaxaruki rak. Nenu ga lok tatao avukat levempanga lixilik. Kuren la nia anaba raba u mi laxampanga solo kusu una lok tatao i. Ude u ri leluxa rak. Ata lok momo eburu.’ ");
INSERT INTO mmx_vpl VALUES ("MT25_22","070_25_22","MAT","25","22","22","La mo lasaxaruki ga lok ka legepu talen, ga vot pasa nom leeme silok la ga lok tin, ‘Leeme silok. Nenu ga raba ia mi legepu talen la nia agara gu asu vam legepu talen bok.’ ");
INSERT INTO mmx_vpl VALUES ("MT25_23","070_25_23","MAT","25","23","23","Leeme silok ga lok tin, ‘I lox avukat aleng. Nenu lagale lasaxaruki rak. Nenu ga lok tatao avukat levempanga lixilik. Kuren la nia anaba raba u mi laxampanga solo kusu una lok tatao i. Ude u ri leluxa rak. Ata lok momo eburu.’ ");
INSERT INTO mmx_vpl VALUES ("MT25_24","070_25_24","MAT","25","24","24","La mo lasaxaruki ga lok ka legesa talen, ga vot pasa nom leeme silok la ga lok tin, ‘Leeme silok. Nia agaklen i do nenu laradi lolos. Uk lok kaka levempanga kopmen ataram, la u kaxat ka levempanga anan at leventaamang, nenu goxotlotlo i. ");
INSERT INTO mmx_vpl VALUES ("MT25_25","070_25_25","MAT","25","25","25","Kuren la nia ga marat taram la agat pas la aga lox alipe na legesa talen taram to xopok at laxangka. Legesa talen taram na.’ ");
INSERT INTO mmx_vpl VALUES ("MT25_26","070_25_26","MAT","25","26","26","La leeme silok ga lok tin, ‘Nenu lasaxaruki kapmek la laradi molo. Nenu ugaklen i do ak lok kaka levempanga kopmen atarak, la a kaxat ka levempanga anan, nenia goxotlotlo i. ");
INSERT INTO mmx_vpl VALUES ("MT25_27","070_25_27","MAT","25","27","27","Tila ba nenu u goxo lok li latalen tarak to at loogu loklok li pilas kusu dina gugu min ti lox asilox i.’ ");
INSERT INTO mmx_vpl VALUES ("MT25_28","070_25_28","MAT","25","28","28","La leeme silok ga lok ti lasaxaruki vetpes teren, ‘Una lok ka latalen teren la una raba i ri mo lasaxaruki ira ruuna ka vam lasangaun talen. ");
INSERT INTO mmx_vpl VALUES ("MT25_29","070_25_29","MAT","25","29","29","A tong i rinimi do nedi di ruuna levempanga la di lok lugugu at ne Moroa min, anaba raba bok di mi laxampanga solo. Ket do tara na ruuna levempanga lixilik la kopmen na lok lugugu min, nia anaba lok kaka amlong mo levempanga ren. ");
INSERT INTO mmx_vpl VALUES ("MT25_30","070_25_30","MAT","25","30","30","La nia anaba lu asu mi mo lasaxaruki molos uto at lamain bonot. Limixin go dinabang teng boron la dinaba rungur ivivilis.’” ");
INSERT INTO mmx_vpl VALUES ("MT25_31","070_25_31","MAT","25","31","31","La ne Iesu ga lok bok, “Do nenia, Laradi Mevana, ana vot mi lisisixam, eburu mi lubung angelo, nenia anabat kis at loxonin orong tarak mi lisisixam silok boro vana at laxalibet. ");
INSERT INTO mmx_vpl VALUES ("MT25_32","070_25_32","MAT","25","32","32","La limixin axap at na lavatbung menemen dinaba tu ro melamgo rak. La nenia anaba epes di ri legepu binam tadi, kerekngan laradi loklok tatao sipsip ik lox epeseves laxasipsip basinge laxanme. ");
INSERT INTO mmx_vpl VALUES ("MT25_33","070_25_33","MAT","25","33","33","Nenia anaba lok li laxasipsip uto saparap lakngak tino la laxanme uto saparap lakngak kia. ");
INSERT INTO mmx_vpl VALUES ("MT25_34","070_25_34","MAT","25","34","34","La nenia, Loorong Silok, anaba lok ti limixin to saparap lakngak tino xeretna, ‘Ude nimi, limixin ne Tamak ira lox anarong pam nimi. Minat pas ude la mina ruuna ka leveloklox anarong at Linintoo, ne Moroa ga gagas pam min tinimi at lurutu kaxat at lavatbung menemen, ");
INSERT INTO mmx_vpl VALUES ("MT25_35","070_25_35","MAT","25","35","35","mila agak toxo la migam taba luxa ia. Agak minu la migam taba dan ia. Aga nemen ngan laradi xadiong la migak lok maraose minia. ");
INSERT INTO mmx_vpl VALUES ("MT25_36","070_25_36","MAT","25","36","36","Agak pakes ti levempanga singsiga la migam taba ia mi levempanga singsiga. Agak meres la migak lok tatao avukar ia. Agak lok at loogu xokoxo la migat pot pasa ia xusu minak lok tooro ia.’ ");
INSERT INTO mmx_vpl VALUES ("MT25_37","070_25_37","MAT","25","37","37","La melemu mo limixin manmanton dinaba sue ia, ‘Leeme Silok. Lingisa nema maga ven u, ugak toxo la magam taba luxa u, la ugak minu la maga vaxain u? ");
INSERT INTO mmx_vpl VALUES ("MT25_38","070_25_38","MAT","25","38","38","Lingisa nema maga ven u ngan laradi xadiong la magak lok maraose minu, kopla uga nemen goxopmen tempanga singsiga ram, la magam taba u mi levempanga singsiga? ");
INSERT INTO mmx_vpl VALUES ("MT25_39","070_25_39","MAT","25","39","39","Lingisa nema maga ven u, ugak meres, kopla uga nemen at loogu xokoxo la magat pot pasa u xusu manak lok tooro u?’ ");
INSERT INTO mmx_vpl VALUES ("MT25_40","070_25_40","MAT","25","40","40","La nenia, Loorong Silok, anaba vorang i ridi xeretna, ‘A tong tuturun i rinimi. Do miga lox i na ri tara atdi limixin banbalo rak, i lok ngan mun miga lox i ria!’ ");
INSERT INTO mmx_vpl VALUES ("MT25_41","070_25_41","MAT","25","41","41","Melemu nenia anaba lok tidi limixin to saparap lakngak kia, ‘Uto nimi basinge ia, nemi limixin, lasaxaek naba suxuna nimi. Uto nimi at laxao i anan tos amisik, ne Moroa ga gagas min ti ne Satan la lubung angelo ren! ");
INSERT INTO mmx_vpl VALUES ("MT25_42","070_25_42","MAT","25","42","42","Agak toxo ketla mi goxo raba luxa ia. Agak minu ketla mi goxo vaxain ia. ");
INSERT INTO mmx_vpl VALUES ("MT25_43","070_25_43","MAT","25","43","43","Aga nemen ngan laradi xadiong, ketla mi goxo lok maraose minia. Agak lok goxopmen tempanga singsiga rak, ketla mi goxo raba ia mi tempanga singsiga. Agak meres la agak lok bok at loogu xokoxo ketla mi goxo vot pasa ia xusu migita lok tooro ia.’ ");
INSERT INTO mmx_vpl VALUES ("MT25_44","070_25_44","MAT","25","44","44","La dinaba lok bok tia xeretna, ‘Leeme Silok. Lingisa maga ven u, uga roxo, la uga minu, la uga nemen ngan laradi xadiong la ugak lok goxopmen tempanga singsiga ram la ugak meres la ugak lok at loogu xokoxo, la ma goxo lok tooro u?’ ");
INSERT INTO mmx_vpl VALUES ("MT25_45","070_25_45","MAT","25","45","45","La nenia anaba vorang i ridi xeretna, ‘A tong tuturun i rinimi. Do mi goxo lox i na ri tara atdi limixin banbalo, mi goxo lox i ria.’” ");
INSERT INTO mmx_vpl VALUES ("MT25_46","070_25_46","MAT","25","46","46","La ne Iesu ga lok bok, “Na limixin Moroa naba riki aonon di ri losongsongot i nemen amisik, ketla limixin manmanton dinaba lok ka lorooro avolo.” ");
INSERT INTO mmx_vpl VALUES ("MT26_1","070_26_1","MAT","26","1","1","Se ne Iesu ga vaase axap na levempapaase, neni ga lok ti lavaun pinivu ren keretna, ");
INSERT INTO mmx_vpl VALUES ("MT26_2","070_26_2","MAT","26","2","2","“Miklen i do legepu aleng move ik lok ti leluxa at Lovovolo Pe. Laaleng i auret do limixin dinaba song araba ia, Laradi Mevana, ri limixin esep kusu dina vaxarem ia at laxaba.” ");
INSERT INTO mmx_vpl VALUES ("MT26_3","070_26_3","MAT","26","3","3","Ap mo mun laaleng lavamaasa silok, la loxongkulao silok at limixin me Israel diga vot eburu to at loogu nunuan at lamaasa gomgo, laasen teren ne Kaiapas. ");
INSERT INTO mmx_vpl VALUES ("MT26_4","070_26_4","MAT","26","4","4","La diga sevut li levelinga xusu ti ranga alis ka nemnem ne Iesu la dina sev amer i. ");
INSERT INTO mmx_vpl VALUES ("MT26_5","070_26_5","MAT","26","5","5","Diga lok, “Ata noxo lox i na at laaleng at leluxa. Lavanga limixin dina lok kaxat turube.” ");
INSERT INTO mmx_vpl VALUES ("MT26_6","070_26_6","MAT","26","6","6","Iesu gak lok to Beteni at loogu at ne Simon. Gano lanmeres gu (leprosy) gak lok teren. ");
INSERT INTO mmx_vpl VALUES ("MT26_7","070_26_7","MAT","26","7","7","La ne Iesu gat kis la gagas ti anan, la lara latkin ga vot pasa i, gap kip lubuxom avukat ga umsu mi laxadan mavak, luunun teren ga urut aleng, la ni ga soli i ro at lavatlak at ne Iesu. ");
INSERT INTO mmx_vpl VALUES ("MT26_8","070_26_8","MAT","26","8","8","La lavaun pinivu ren diga ven i na, la diga musak, diga lok, “Tila i soli xepe gamasa i na? ");
INSERT INTO mmx_vpl VALUES ("MT26_9","070_26_9","MAT","26","9","9","Ni i epovo ri sesep mi na laxadan mavak kusu ni naba lok ka tuunun silok teren, la na lok tooro limixin banbalo min.” ");
INSERT INTO mmx_vpl VALUES ("MT26_10","070_26_10","MAT","26","10","10","Iesu gaklen pam levendoxoma atdi, kuren la ni ga lok tidi, “Nemen mita lox angtang na latkin, mila neni i lok lavanga nunuan tia. ");
INSERT INTO mmx_vpl VALUES ("MT26_11","070_26_11","MAT","26","11","11","Limixin banbalo mo dinabat pot pasa amisik nimi xusu minak lok tooro di, ketla nenia noxo nemen eburu amisik minimi. ");
INSERT INTO mmx_vpl VALUES ("MT26_12","070_26_12","MAT","26","12","12","Ni i soli na laxadan mavak at labantuxu rak kusu ti lox agagas li labantuxu rak ti lamaaut. ");
INSERT INTO mmx_vpl VALUES ("MT26_13","070_26_13","MAT","26","13","13","Nia a tong tuturun i rinimi do, at ua loxot at na lavatbung menemen axap limixin dinaba tong asu Lagale Lavavang, na lavanga neni i lox i, dinaba tong box i xusu limixin dinaklen i.” ");
INSERT INTO mmx_vpl VALUES ("MT26_14","070_26_14","MAT","26","14","14","Lara atnedi lasangaun mi legepura lavaun pinivu, laasen teren ne Judas Iskariot ga vot pasa lavamaasa silok. ");
INSERT INTO mmx_vpl VALUES ("MT26_15","070_26_15","MAT","26","15","15","La ni ga sue di, “Do nenia ana song araba ne Iesu rinimi, miba raba ia mi tavanga salai?” La diga siam do dina raba i mi lavantun sangaun siliva. ");
INSERT INTO mmx_vpl VALUES ("MT26_16","070_26_16","MAT","26","16","16","Ga ruka i ap mo laaleng ne Judas ga reven ti taaleng kusu na song araba ne Iesu ridi. ");
INSERT INTO mmx_vpl VALUES ("MT26_17","070_26_17","MAT","26","17","17","At laaleng avot at leluxa ua diga ove vetpes lengkongkide, lavaun pinivu at ne Iesu diga vot pasa i la diga sue i, “U vara i do mana lox agagas li laanan tidik ua?” ");
INSERT INTO mmx_vpl VALUES ("MT26_18","070_26_18","MAT","26","18","18","La ni ga vorang i ridi xeretna, “Mina vubeles at lemenemen silok la mina vot pasa lara laradi, la mina lok tin keretna, ‘Leeme loklox ase atnama i tong i do laaleng meremet teren i auret la neni eburu mi lavaun pinivu ren diba lok katling Lovovolo Pe ro at loogu ram.’” ");
INSERT INTO mmx_vpl VALUES ("MT26_19","070_26_19","MAT","26","19","19","La lavaun pinivu ren diga mumu asu levelinga at ne Iesu la diga lox agagas li leveluxa ri Lovovolo Pe. ");
INSERT INTO mmx_vpl VALUES ("MT26_20","070_26_20","MAT","26","20","20","Ga ukantinao Iesu gat kis kusu ti anan eburu mi lasangaun mi legepura lavaun pinivu ren. ");
INSERT INTO mmx_vpl VALUES ("MT26_21","070_26_21","MAT","26","21","21","Nedi diga anan la ni ga lok tidi, “Nia a tong tuturun i na rinimi. Legesara mo atnimi naba song araba ia ri limixin kakapmek.” ");
INSERT INTO mmx_vpl VALUES ("MT26_22","070_26_22","MAT","26","22","22","La diga bulu aleng la nedi getgesara diga sue i, “Leeme Silok. Kopmen nenia, do?” ");
INSERT INTO mmx_vpl VALUES ("MT26_23","070_26_23","MAT","26","23","23","La ne Iesu ga vorang i ridi, “Mo lara na song asu mi lekngen eburu minia ri levempanga anan, neni naba song araba ia ri limixin kakapmek. ");
INSERT INTO mmx_vpl VALUES ("MT26_24","070_26_24","MAT","26","24","24","Nenia, Laradi Mevana, anaba met kerekngan Lovoang Kaala i tong i, ketla naba lok kapmek aleng ti mo laradi naba song araba ia ri limixin kakapmek. Giba lox avukat do nenen gitoxo visik ka i.” ");
INSERT INTO mmx_vpl VALUES ("MT26_25","070_26_25","MAT","26","25","25","La ne Judas, mo ga gagas kusu na song araba i, ga lok, “Rabai. Kopmen nenia, do?” La ne Iesu ga vorang i, “Nenu vam.” ");
INSERT INTO mmx_vpl VALUES ("MT26_26","070_26_26","MAT","26","26","26","Move diga anan la ne Iesu ga lok kaka loxongkide, ga tong avukat ti ne Moroa, ga sebex i la ga raba lavaun pinivu ren min la ga lok, “Mina lok kaka i na la mina anan i. Labantuxu rak na.” ");
INSERT INTO mmx_vpl VALUES ("MT26_27","070_26_27","MAT","26","27","27","La neni ga lok kaka lakap inin, ga tong aorong ti ne Moroa, la ga raba di min la ga lok, “Nemi axap mina in at na. ");
INSERT INTO mmx_vpl VALUES ("MT26_28","070_26_28","MAT","26","28","28","Lada rak na. I lok katling lekabus maxat. Lada rak naba sen su xusu ti limixin buaang, ne Moroa naba doxoma xepe leveloklok kakapmek atdi. ");
INSERT INTO mmx_vpl VALUES ("MT26_29","070_26_29","MAT","26","29","29","Nia a tong i rinimi do nia noxo in at lavaen i ruka i lingina se ap mo laaleng nia anaba in lavaen maxat eburu minimi ro xeneng at Linintoo at ne Tamak.” ");
INSERT INTO mmx_vpl VALUES ("MT26_30","070_26_30","MAT","26","30","30","Digak pixan mi loxompixan, la diga vas su la diga vas kaxat uto at Lakaana Olip. ");
INSERT INTO mmx_vpl VALUES ("MT26_31","070_26_31","MAT","26","31","31","Melemu ne Iesu ga lok tidi, “Lingina at laxanimin, nemi axap minaba subu basinge ia. I lok ngan Lovoang Kaala i tong i xeretna, ‘Nia ne Moroa, anaba sep laradi loklok tatao at levesipsip la levesipsip dinaba epeseves.’ ");
INSERT INTO mmx_vpl VALUES ("MT26_32","070_26_32","MAT","26","32","32","Ketla melemu at laxakatu kaxat amlong tarak, nia anabamgo rinimi uto Galili.” ");
INSERT INTO mmx_vpl VALUES ("MT26_33","070_26_33","MAT","26","33","33","La ne Pita ga lok tin, “Keke i do nedi axap dina subu basinge u, nenia xopmen tinotno noxo subu.” ");
INSERT INTO mmx_vpl VALUES ("MT26_34","070_26_34","MAT","26","34","34","La ne Iesu ga lok tin, “Nia a tong tuturun i ru. Lingina at laxanimin laxaxak noxovisi na reng, la nenu unaba sev apkap naba vantun do uxoklen ia.” ");
INSERT INTO mmx_vpl VALUES ("MT26_35","070_26_35","MAT","26","35","35","La ne Pita ga vaase lolos tin keretna, “Do dina lok do dina sev amer ia, nenia noxo sok tixirixes kepe u.” La lavaun pinivu axap diga tong box i xuren. ");
INSERT INTO mmx_vpl VALUES ("MT26_36","070_26_36","MAT","26","36","36","Melemu ne Iesu gat pas uto at lara loxot, laasen teren Getesemane. Lavaun pinivu ren diga emu min, diga rupot la ni ga lok tidi, “Mina xis de. Anat pas lixilik uto xusu ana lok lising.” ");
INSERT INTO mmx_vpl VALUES ("MT26_37","070_26_37","MAT","26","37","37","La ni ga lam ka ne Pita mi lumdak at ne Sebedi, la lainbulu silok ga suxuna lorooro ren. ");
INSERT INTO mmx_vpl VALUES ("MT26_38","070_26_38","MAT","26","38","38","La ni ga lok tidi, “Lorooro rak i umsu mi lainbulu silok mo na lox amer ia. Minak lok de la mina kuxut tooro ia.” ");
INSERT INTO mmx_vpl VALUES ("MT26_39","070_26_39","MAT","26","39","39","La ne Iesu ga vas uto vaxalom lixilik, la ni ga subu midi mi lemeren uto xopok at laxangka la ga sing ne Moroa xeretna, “Tamak. Kereva, i epovo do una lok pes na lumumuat basinge ia? Ketla nemen gat uta mumu asu lavavara rak, una mu asu lavavara ram.” ");
INSERT INTO mmx_vpl VALUES ("MT26_40","070_26_40","MAT","26","40","40","La ne Iesu gamlong saparap lavaun pinivu ren la ga long lenget ka di, diga unga. La ni ga lok ti ne Pita, “Kereva, mixo epovo minap kip na lumumuat eburu minia at loxonaleng lixilik mun? ");
INSERT INTO mmx_vpl VALUES ("MT26_41","070_26_41","MAT","26","41","41","Mina reven tatao la mina ngising kusu mi noxo subu at loklok tong pen. Loroonan at laradi i epovo ri ronga res, ketla labantuxu ren i molos.” ");
INSERT INTO mmx_vpl VALUES ("MT26_42","070_26_42","MAT","26","42","42","La ne Iesu ga vas uto lixilik ga sev agepura la ga sing, “Tamak. Do ixo epovo una lok pes na lumumuat basinge ia se nia ana lox epovo i, i lox avukat. Ana mu asu mun lavavara ram.” ");
INSERT INTO mmx_vpl VALUES ("MT26_43","070_26_43","MAT","26","43","43","Iesu gamlong uto at lavaun pinivu ren la ga long lenget ka di, diga unga manga, mila lemerendi ga unga. ");
INSERT INTO mmx_vpl VALUES ("MT26_44","070_26_44","MAT","26","44","44","La ni ga ke di la ga vas kaxat basinge di ga sev avantun kusu na sing. La ga sing amu mi nom levelinga ni ga ngising pam min. ");
INSERT INTO mmx_vpl VALUES ("MT26_45","070_26_45","MAT","26","45","45","Melemu ni gamlong uto at lavaun pinivu ren la ga lok tidi, “Kereva, move mi unga? Pen ba i nom. Loxonaleng i auret do lara laradi na song araba ia, Laradi Mevana, ri limixin bilinga. ");
INSERT INTO mmx_vpl VALUES ("MT26_46","070_26_46","MAT","26","46","46","Mina xatu. Ata vas tangarang nom laradi boro it pas kusu nam taba minia ri limixin kakapmek.” ");
INSERT INTO mmx_vpl VALUES ("MT26_47","070_26_47","MAT","26","47","47","Iesu move ga paase la ne Judas ga rupot. Neni lara at lasangaun mi legepura lavaun pinivu at ne Iesu. Buaang limixin diga emu min, digap kip levemparise sepsep la levempukup sepsep. Lavamaasa silok la loxongkulao silok at limixin me Israel diga riki di. ");
INSERT INTO mmx_vpl VALUES ("MT26_48","070_26_48","MAT","26","48","48","Avot ti na, ne Judas ga tong li loklok katling kusu diba ven kibis ne Iesu. Judas ga lok tidi, “Mo lara, nia aba nes i, neni vam ne Iesu. Mina ranga alis i.” ");
INSERT INTO mmx_vpl VALUES ("MT26_49","070_26_49","MAT","26","49","49","La soso mun ne Judas ga vas saparap ne Iesu la ga lok, “Laxanimin avukat, Rabai.” La ni ga nes i. ");
INSERT INTO mmx_vpl VALUES ("MT26_50","070_26_50","MAT","26","50","50","La ne Iesu ga lok tin, “Lentangas tarak. Una lok soso nom lavanga u vara i do una lox i.” La mo limixin diga vot pasa ne Iesu la diga ranga alis i. ");
INSERT INTO mmx_vpl VALUES ("MT26_51","070_26_51","MAT","26","51","51","Lara at lavaun pinivu ren ga ven i na la ga rev asu lavarise sepsep teren la ga sep korop kepe labaalung at lasaxaruki at lamaasa gomgo. ");
INSERT INTO mmx_vpl VALUES ("MT26_52","070_26_52","MAT","26","52","52","La ne Iesu ga lok tin, “Lok li amlong lavarise sepsep taram mila nedi di sep limixin mi lemparise, diba met kuren. ");
INSERT INTO mmx_vpl VALUES ("MT26_53","070_26_53","MAT","26","53","53","Nenia a epovo ana ro ri ne Tamak la neni naba raba ia mi lubung angelo, luutus atdi ba volo lavanuti sangaun mi legepura larabin sangsangaun kobot (72,000) lubung angelo. ");
INSERT INTO mmx_vpl VALUES ("MT26_54","070_26_54","MAT","26","54","54","Ketla keke nga di mila nia anaba lox asoorun mo levengkot at Lovoang Kaala i tong asu i do na lavanga naba vot.” ");
INSERT INTO mmx_vpl VALUES ("MT26_55","070_26_55","MAT","26","55","55","Ap mo loxonaleng ne Iesu ga lok ti mo limixin, “Tila mi vot de mi levemparise sepsep la levempukup sepsep kusu mina ranga alis ia? Nenia xopmen ana vaxaru kaxat ka teesep. Buaang levenaleng nia agat kis to xeneng at loogu laplavang kusu ana anasa limixin, ketla nemi xopmen mi goxo ranga alis ka be ia go. ");
INSERT INTO mmx_vpl VALUES ("MT26_56","070_26_56","MAT","26","56","56","Na levempanga i ravasu keretna xusu na lox asoorun levenmamalagan at lavaeme vapaase ali.” La lavaun pinivu ren diga sixiro axap. ");
INSERT INTO mmx_vpl VALUES ("MT26_57","070_26_57","MAT","26","57","57","Nedi diga ranga alis ne Iesu, diga lam ka i uto at ne Kaiapas, lamaasa gomgo. Go luvuttadi loklox ase at Laulis Linga la loxongkulao silok diga rupot pam. ");
INSERT INTO mmx_vpl VALUES ("MT26_58","070_26_58","MAT","26","58","58","Pita ga mumu asu ne Iesu ro xa vaxalom la ga rupot saparap loogu at lamaasa gomgo la ga vubeles at lemelua. Ni ga xis kopok eburu mi luvuttadi rutu mu xusu na ven lavanga salai naba vot saparap ne Iesu. ");
INSERT INTO mmx_vpl VALUES ("MT26_59","070_26_59","MAT","26","59","59","Nedi axap luvuttadi amgomgo eburu mi lavamaasa silok ap mo lixitkis buru diga puse ri tevelinga xaxarang kusu dina so raba ne Iesu min la diba epovo na sev amer i. ");
INSERT INTO mmx_vpl VALUES ("MT26_60","070_26_60","MAT","26","60","60","Ketla di goxo epovo, keke do buaang luvuttadi diga vot kusu dina tong asu tevelinga xaxarang. At laxavaxap, legepu radi duga vot, ");
INSERT INTO mmx_vpl VALUES ("MT26_61","070_26_61","MAT","26","61","61","la duga lok, “Na laradi ga lok keretna, ‘Nenia a epovo na sele utut kepe na loogu laplavang at ne Moroa la anaba vaxaru amu box i xeneng at lavantun aleng.’” ");
INSERT INTO mmx_vpl VALUES ("MT26_62","070_26_62","MAT","26","62","62","La lamaasa gomgo ga xatu la ga lok ti ne Iesu, “Ua lavasuun teren la uxo vaase? Kereva, u xopara na vorang na levelinga di sok taba u min.” ");
INSERT INTO mmx_vpl VALUES ("MT26_63","070_26_63","MAT","26","63","63","Ketla ne Iesu kopmen goxo tong toxolinga. La lamaasa gomgo ga lok tin, “At laasen at ne Moroa, Luntoo Avolo, una tong i rinama. Kereva, nenu Lanarong, Nitna ne Moroa?” ");
INSERT INTO mmx_vpl VALUES ("MT26_64","070_26_64","MAT","26","64","64","La ne Iesu ga lok, “I ruturun, nenia vam. Ketla nia a tong i rinimi. Melemu minaba ven ia, Laradi Mevana, anabat kis saparap lekngen tino ne Moroa ni Lanaraavuk, la anaba vot at loxontakabu boro vana at laxalibet.” ");
INSERT INTO mmx_vpl VALUES ("MT26_65","070_26_65","MAT","26","65","65","La lamaasa gomgo ga lais korop lavanga singsiga ren la ga lok, “I paase vupu ri ne Moroa. I xap ta lavapaase. Mira ronga vam levelinga ren. ");
INSERT INTO mmx_vpl VALUES ("MT26_66","070_26_66","MAT","26","66","66","Kereva levendoxoma atnimi?” La diga vorang i xeretna, “I epovo do neni na met.” ");
INSERT INTO mmx_vpl VALUES ("MT26_67","070_26_67","MAT","26","67","67","La diga vubis abuxumin lemeren la diga tit pupu i, la lentaba diga pasa i mi levengkikngen di. ");
INSERT INTO mmx_vpl VALUES ("MT26_68","070_26_68","MAT","26","68","68","Digak lok, “Do nenu Lanarong, una tong kisip ka i do nege i sev u.” ");
INSERT INTO mmx_vpl VALUES ("MT26_69","070_26_69","MAT","26","69","69","Pita gat kis to xamang at lemelua la lara loolik, neni lasaxaruki ga vot pasa ne Pita la ga lok, “Nenu bok gak lok eburu mi ne Iesu boro Galili.” ");
INSERT INTO mmx_vpl VALUES ("MT26_70","070_26_70","MAT","26","70","70","Ketla neni ga sev apkap to melamgo atnedi axap, ni ga lok, “Nia xopmen naklen lavanga salai u paase min.” ");
INSERT INTO mmx_vpl VALUES ("MT26_71","070_26_71","MAT","26","71","71","La ni gat pas uto at langas povolo la lara loolik bok ga ven i la ga vaase ri limixin diga tu go. Neni ga lok keretna, “Na laradi gak lok eburu mi ne Iesu boro Nasaret.” ");
INSERT INTO mmx_vpl VALUES ("MT26_72","070_26_72","MAT","26","72","72","La ne Pita ga sev apkap manga la ga vangpe, ni ga lok, “Nia xopmen anaklen nom laradi.” ");
INSERT INTO mmx_vpl VALUES ("MT26_73","070_26_73","MAT","26","73","73","Melemu lixilik mo limixin diga tu go, diga vot pasa ne Pita la diga lok, “I ruturun do nenu lara atdi mila lavapaase ram i lok ngan laradi boro Galili.” ");
INSERT INTO mmx_vpl VALUES ("MT26_74","070_26_74","MAT","26","74","74","La ni ga vangpe mi levelinga vangpangpe xeretna, “Levelinga rak i ruturun. Do xopmen, ne Moroa naba lox asongor ia. Nia axoklen mo laradi.” La soso mun laxaxak ga reng. ");
INSERT INTO mmx_vpl VALUES ("MT26_75","070_26_75","MAT","26","75","75","La ne Pita ga doma su at levelinga at ne Iesu ga lok keretna, “Laxaxak kovisi noxo reng, la nenu unaba sev apkap naba vantun do uxoklen ia.” La neni ga vas su ukamang la gang teng silok aleng. ");
INSERT INTO mmx_vpl VALUES ("MT27_1","070_27_1","MAT","27","1","1","Ga maxantamak suubu nedi axap lavamaasa silok eburu mi loxongkulao silok at lubung mixin me Judaia diga li levendoxoma atdi mumu ne Iesu do dina sev amer i. ");
INSERT INTO mmx_vpl VALUES ("MT27_2","070_27_2","MAT","27","2","2","Diga xoxo alis lukngen la diga sat ka i uto at ne Paelat, ni laradi gomgo boro Rom. ");
INSERT INTO mmx_vpl VALUES ("MT27_3","070_27_3","MAT","27","3","3","La ne Judas, laradi ga song araba ne Iesu, ga ven i do diga gagas kusu dina sev amet ne Iesu, la neni ga umsu mi lainbulu silok la ga lox ekun lodoxoma ren la ga raba amlong lavantun sangaun siliva ti lavamaasa eburu mi loxongkulao silok. ");
INSERT INTO mmx_vpl VALUES ("MT27_4","070_27_4","MAT","27","4","4","Ni ga lok, “Nia ara lok pam laxakapmek silok, la ara raba vam limixin esep mi laradi xopmen taxakapmek teren, la i auret ta loxonaleng kusu dina sev amer i.” La diga lok tin, “Kopmen tekot at nom atnama. Lavanga nga nom taram!” ");
INSERT INTO mmx_vpl VALUES ("MT27_5","070_27_5","MAT","27","5","5","Kuren la ne Judas ga lu abeles mi mo levempilas gamgames to at loogu laplavang la ga onon. Melemu neni gat pas la ga xut amer i. ");
INSERT INTO mmx_vpl VALUES ("MT27_6","070_27_6","MAT","27","6","6","Lavamaasa silok diga lok ka mo levempilas gamgames la diga lok, “Anai levempilas i ru katling luunun ti lorooro at laradi. La Laulis Linga i tong i do ixo epovo bok ba xusu ataba lok li i ro at loxot lili pilas.” ");
INSERT INTO mmx_vpl VALUES ("MT27_7","070_27_7","MAT","27","7","7","La diga epaase mumu i la diga un kaka loxongkangka, laasen teren Laraamang Pota, kusu tik mikmit limixin kadiong. ");
INSERT INTO mmx_vpl VALUES ("MT27_8","070_27_8","MAT","27","8","8","Kuren la diga so asen mo loxot do “Loxongkangka at Lada,” ise at na levenaleng mo laasen ik lok. ");
INSERT INTO mmx_vpl VALUES ("MT27_9","070_27_9","MAT","27","9","9","At na mun levempanga la levelinga at leeme vapaase ali ne Jeremaia ga soorun, ni ga lok, “Diga lok ka lavantun sangaun levempilas gamgames, ni luutus limixin me Israel diga siam min do ri un i, ");
INSERT INTO mmx_vpl VALUES ("MT27_10","070_27_10","MAT","27","10","10","la diga lok ka mo levempilas kusu ti un Laraamang Pota kerekngan ne Moroa ga tong i ria.” ");
INSERT INTO mmx_vpl VALUES ("MT27_11","070_27_11","MAT","27","11","11","Ap mo mun loxonaleng ne Iesu ga tu ro melamgo at laradi gomgo ne Paelat la ne Paelat ga sue i, “Kereva, nenu loorong at limixin me Judaia?” La ne Iesu ga vorang i, “I ruturun. Nenu xa ura tong pam i.” ");
INSERT INTO mmx_vpl VALUES ("MT27_12","070_27_12","MAT","27","12","12","Lavamaasa silok eburu mi loxongkulao silok diga sok taba i mi levelinga, ketla neni xopmen goxo vaase porang di. ");
INSERT INTO mmx_vpl VALUES ("MT27_13","070_27_13","MAT","27","13","13","La ne Paelat ga sue i, “Kereva, u xopara na vorang levelinga atdi?” ");
INSERT INTO mmx_vpl VALUES ("MT27_14","070_27_14","MAT","27","14","14","Ketla ne Iesu xopmen goxo vorang mo levelinga. Ni goxo vaase asu tekolinga kusu ti vorang mo levelinga atdi. Laradi gomgo ga sangu aleng. ");
INSERT INTO mmx_vpl VALUES ("MT27_15","070_27_15","MAT","27","15","15","At levenmaares axap laradi gomgo boro Rom ga mu asu lara loklok keneng at leluxa silok, laasen teren Lovovolo Pe. Neni gak soxomus asu lara laradi xokoxo do limixin diga lok katling i. ");
INSERT INTO mmx_vpl VALUES ("MT27_16","070_27_16","MAT","27","16","16","Ap mo laaleng lara laradi, laasen teren ne Barabas gak lok at loogu xokoxo, neni laradi xapmek tinotno. ");
INSERT INTO mmx_vpl VALUES ("MT27_17","070_27_17","MAT","27","17","17","Buaang limixin diga vot eburu xusu ti lok katling laradi xokoxo la ne Paelat ga sue di, “Ua lara mi vara i do nia ana soxomus asu raba nimi min, Barabas kopla ne Iesu di tong i do neni Lanarong?” ");
INSERT INTO mmx_vpl VALUES ("MT27_18","070_27_18","MAT","27","18","18","Paelat gaklen i do lavamaasa silok la loxongkulao silok diga reven peves at ne Iesu la ni lavasuun teren la diga vara i do dina sev amer i. ");
INSERT INTO mmx_vpl VALUES ("MT27_19","070_27_19","MAT","27","19","19","Ap mo loxonaleng Paelat gat kis at loxot kitkis at laradi rongtonga linga. La latkin teren ga lox aonon na levelinga rin, ga lok keretna, “Nemen gat uta lok tavanga ri na laradi kopmen taxakapmek teren, mila itinongo at laxanimin nia ata robo i la labalak ixo xis aulis tino.” ");
INSERT INTO mmx_vpl VALUES ("MT27_20","070_27_20","MAT","27","20","20","Ketla lavamaasa silok eburu mi loxongkulao silok diga vaase lolos ti limixin do dina lok katling ne Barabas la dina sev amet ne Iesu. ");
INSERT INTO mmx_vpl VALUES ("MT27_21","070_27_21","MAT","27","21","21","Paelat ga sue di, “Ua lara atdu nia ana soxomus asu raba nimi min?” La diga vorang i rin, “Barabas.” ");
INSERT INTO mmx_vpl VALUES ("MT27_22","070_27_22","MAT","27","22","22","La ne Paelat ga sue di, “La nenia aba lok lavanga sala ri ne Iesu, di tong i do Lanarong?” La nedi axap diga vorang i xeretna, “Una vaxarem i at laxaba!” ");
INSERT INTO mmx_vpl VALUES ("MT27_23","070_27_23","MAT","27","23","23","La ne Paelat ga sue di, “Tila mo? Neni ixo lok tavanga xapmek.” Ketla digap kup silok keretna, “Paxarem i at laxaba.” ");
INSERT INTO mmx_vpl VALUES ("MT27_24","070_27_24","MAT","27","24","24","Paelat ga ven kibis i do limixin di goxopara na ronga levelinga ren, la diga lok do dina ru kaxat ka leesep. Kuren la neni ga lok ka loxodan la ga gos lukngen to melamgo at limixin la ga lok tidi, “Kopmen tekot tarak at na. Lavanga mun atnimi.” ");
INSERT INTO mmx_vpl VALUES ("MT27_25","070_27_25","MAT","27","25","25","La mo limixin diga lok, “Keke lumumuat at lanmet teren naba nemen pana atnema eburu mi laxamdak mi laxaalik atnama.” ");
INSERT INTO mmx_vpl VALUES ("MT27_26","070_27_26","MAT","27","26","26","La ne Paelat ga soxomus asu ne Barabas tidi. Ketla neni ga raba ne Iesu ri luvuttadi esep kusu dinak pixis i la dina vaxarem i at laxaba. ");
INSERT INTO mmx_vpl VALUES ("MT27_27","070_27_27","MAT","27","27","27","Melemu limixin esep at ne Paelat diga lok ka ne Iesu uto at loogu silok at laradi gomgo, la limixin esep axap go diga ru xangkan i. ");
INSERT INTO mmx_vpl VALUES ("MT27_28","070_27_28","MAT","27","28","28","Diga lok kepe levesingsiga ren la diga vaxasiga i mi lavanga singsigaara at loorong. ");
INSERT INTO mmx_vpl VALUES ("MT27_29","070_27_29","MAT","27","29","29","La diga lok lixiam tin mi livin gagas la diga vaxaxua lavatlak teren min, la diga vaxarebeng i mi lakdak at loorong to at lekngen tino. Melemu diga xis tiktikbu ro melamgo ren la diga paase xapmek tin. Diga lok, “Ma lok ngangao aleng taram, loorong at limixin me Judaia.” ");
INSERT INTO mmx_vpl VALUES ("MT27_30","070_27_30","MAT","27","30","30","La diga kalaubis sax i, la diga lok ka mo lakdak la digak pixis patlax i min. ");
INSERT INTO mmx_vpl VALUES ("MT27_31","070_27_31","MAT","27","31","31","Diga saba xangka axav i, la diga lok pes manga nom lavanga singsigaara basinge i la diga vaxasiga manga i mi lavanga singsiga ren. La diga sat ka nga i basinge loogu silok kusu dina vaxarem i at laxaba. ");
INSERT INTO mmx_vpl VALUES ("MT27_32","070_27_32","MAT","27","32","32","Luvuttadi esep mi ne Iesu diga sixisu ap mo loogu la diga ekip tangarang mi lara laradi boro Sairini, laasen teren ne Simon, la luvuttadi esep diga sox aruru parang i xusu na xip ka laxaba at ne Iesu. ");
INSERT INTO mmx_vpl VALUES ("MT27_33","070_27_33","MAT","27","33","33","Diga rupot to at loxot, loxonasen kot go do Golgata. Lavasuun at na loxolinga do “Lavatlak Tongan.” ");
INSERT INTO mmx_vpl VALUES ("MT27_34","070_27_34","MAT","27","34","34","Diga raba ne Iesu mi ladan vaen kusu neni na inin i. Diga lok li vam lara lamarasin teren kusu na lok kepe losongsongot teren. Iesu ga in tong pen i, ketla goxopara i. ");
INSERT INTO mmx_vpl VALUES ("MT27_35","070_27_35","MAT","27","35","35","Diga vaxarem i at laxaba la melemu diga lu buru mi lengkonuat kusu ti lok kisip ka nege ba lok ka levempanga singsiga ren. ");
INSERT INTO mmx_vpl VALUES ("MT27_36","070_27_36","MAT","27","36","36","Melemu at nom, digat kis la diga reven ne Iesu. ");
INSERT INTO mmx_vpl VALUES ("MT27_37","070_27_37","MAT","27","37","37","To mavana at lavatlak teren diga lok li levelinga, mo ga tong asu lavasuun at lumumuat teren. Nom levelinga ga lok keretna, Neni ne Iesu, loorong at limixin me Judaia. ");
INSERT INTO mmx_vpl VALUES ("MT27_38","070_27_38","MAT","27","38","38","La limixin esep diga vaxarem bok legepu radi xapmek saparap ne Iesu, lara saparap lekngen tino la lara saparap lekngen kia. ");
INSERT INTO mmx_vpl VALUES ("MT27_39","070_27_39","MAT","27","39","39","Limixin digat pas polo go la diga piripat lempatlak atdi la diga paase aksaksa ri ne Iesu. ");
INSERT INTO mmx_vpl VALUES ("MT27_40","070_27_40","MAT","27","40","40","La diga lok keretna, “Nenu uga lok do unaba sele utut kepe loogu laplavang la unaba vaxaru amu box i at lavantun aleng. Una lox aroo nga u, mo do nenu ne nitna ne Moroa la una eng si basinge nom laxaba.” ");
INSERT INTO mmx_vpl VALUES ("MT27_41","070_27_41","MAT","27","41","41","La kerepmo bok lavamaasa silok eburu mi luvuttadi loklox ase at Laulis Linga la loxongkulao silok diga paase aksaksa rin mi levelinga lolos. Diga lok, ");
INSERT INTO mmx_vpl VALUES ("MT27_42","070_27_42","MAT","27","42","42","“Neni ga lox aroo lentaba vetpes, ketla neni ixo epovo do na lox aroo axa i. Kereva, neni loorong tuturun pam me Israel? Do neni na eng si basinge laxaba, dik ataba nunu ba ren. ");
INSERT INTO mmx_vpl VALUES ("MT27_43","070_27_43","MAT","27","43","43","Ni i nunu at ne Moroa la i lok do neni ne nitna ne Moroa. Teren, ata ven be i do ne Moroa go naba lox aroo su ba i.” ");
INSERT INTO mmx_vpl VALUES ("MT27_44","070_27_44","MAT","27","44","44","La kerepmo bok luradi xapmek duga merem saparav i, nedu bok duga lok kalise xapmex i. ");
INSERT INTO mmx_vpl VALUES ("MT27_45","070_27_45","MAT","27","45","45","At lasangaun mi legepu xonaleng, lamain ga vung pavaa mo lenep silok axap, la gak lok se at lavantun konaleng. ");
INSERT INTO mmx_vpl VALUES ("MT27_46","070_27_46","MAT","27","46","46","At lavantun konaleng ne Iesu ga xup silok keretna, “Eloi, Eloi lama sabaktani?” Lavasuun at na levelinga xeretna, “Moroa rak, Moroa rak, tila u raba rulu ia?” ");
INSERT INTO mmx_vpl VALUES ("MT27_47","070_27_47","MAT","27","47","47","Lentaba luvuttadi diga tu go, diga ronga i la diga lok, “I toro ri ne Elaisa.” ");
INSERT INTO mmx_vpl VALUES ("MT27_48","070_27_48","MAT","27","48","48","La lara laradi ga sixit la ga lok ka loxontamon la ga lox amlu xaka i ro xeneng at lavaen mamao la ga xoxo li i ro at loxonuna la ga lok do na vaxain ne Iesu min. ");
INSERT INTO mmx_vpl VALUES ("MT27_49","070_27_49","MAT","27","49","49","Ketla lentaba luvuttadi diga lok, “Una tu be, ata ven be i do ne Elaisa go naba rupot ti lok tooro i.” ");
INSERT INTO mmx_vpl VALUES ("MT27_50","070_27_50","MAT","27","50","50","La ne Iesu ga xup kaxat silok manga la lamamas teren ga rekorop, la ni ga met ta. ");
INSERT INTO mmx_vpl VALUES ("MT27_51","070_27_51","MAT","27","51","51","Ap mo loxonaleng lavattamon silok ga merem to xeneng at loogu laplavang ga rem lais ka ro vana, ga su ro xopok la ga ra ngan ta legepu ban, la laxangka gangne la lemparuat ga tepavagam. ");
INSERT INTO mmx_vpl VALUES ("MT27_52","070_27_52","MAT","27","52","52","Laramaaut ga rem bang la buaang limixin at ne Moroa, no diga met ganoxa, diga roo xat amlong. ");
INSERT INTO mmx_vpl VALUES ("MT27_53","070_27_53","MAT","27","53","53","Diga onon basinge laramaaut atdi la melemu at laaleng ne Iesu ga roo xat amlong, nedi diga vubeles to xeneng at lemenemen kaala la buaang limixin diga ven di. ");
INSERT INTO mmx_vpl VALUES ("MT27_54","070_27_54","MAT","27","54","54","Ap mo loxonaleng laasesep eburu mi limixin esep teren diga tu la diga suma langne la levempanga axap ga vot ap mo loxonaleng, diga marat aleng la diga lok, “Neni lamdak tuturun pam at ne Moroa.” ");
INSERT INTO mmx_vpl VALUES ("MT27_55","070_27_55","MAT","27","55","55","Buaang lavakin bok mo diga tu vaxalom lixilik la diga reven mo levempanga ga vot. Nedi nom lavakin diga mumu asu ne Iesu boro Galili la digak lok tooro box i. ");
INSERT INTO mmx_vpl VALUES ("MT27_56","070_27_56","MAT","27","56","56","Ne Maria Magdalene eburu mi ne Maria, nenen ne Jems mi ne Josep. La nenen bok at lumdak at ne Sebedi. ");
INSERT INTO mmx_vpl VALUES ("MT27_57","070_27_57","MAT","27","57","57","Taba nga ukantinao lara laradi nopnovos boro Arimatia, laasen teren ne Josep, ga vot la neni bok lara atnedi lavaun pinivu at ne Iesu. ");
INSERT INTO mmx_vpl VALUES ("MT27_58","070_27_58","MAT","27","58","58","Neni ga vot parap ne Paelat la ga sing i do neni na raba i mi labantuxu at ne Iesu. La ne Paelat ga siam dola na raba ne Josep min. ");
INSERT INTO mmx_vpl VALUES ("MT27_59","070_27_59","MAT","27","59","59","La ne Josep ga lok ka i la ga bom i mi labantamon maxat, ");
INSERT INTO mmx_vpl VALUES ("MT27_60","070_27_60","MAT","27","60","60","la ga lok li i ro xeneng at lamaaut maxat teren, limixin diga ke i ro xeneng at lavaruat. La melemu neni ga xavun pe lumusmaragu at lamaaut mi lavaruat la ga onon. ");
INSERT INTO mmx_vpl VALUES ("MT27_61","070_27_61","MAT","27","61","61","Maria Magdalene eburu mi lara ne Maria vetpes bok mo dugat kis to melamgo at lamaaut. ");
INSERT INTO mmx_vpl VALUES ("MT27_62","070_27_62","MAT","27","62","62","Ap mo laaleng melemu, ni laaleng kaala, lavamaasa eburu mi lubung Parisi diga vot pasa ne Paelat. ");
INSERT INTO mmx_vpl VALUES ("MT27_63","070_27_63","MAT","27","63","63","La diga lok tin keretna, “Leeme Silok, nema ma doma mumu levelinga ap mo laradi xaxarang at laaleng neni move ga rooro la ga lok keretna, ‘Anaba roo xat amlong basinge lanmet melemu at lavantun aleng.’ ");
INSERT INTO mmx_vpl VALUES ("MT27_64","070_27_64","MAT","27","64","64","Kuren la, nema ma vara i do una tong i ri luvuttadi rutu mu la dinaba kuxut mi lamaaut teren naba se at laaleng sev avantun kusu lavaun pinivu ren di noxo epovo rit pas ti nem kaka labantuxu ren. La melemu dina tong i ri limixin dola neni ira roo xat amlong pam basinge lanmet. La na laxaxarang melemu, ni naba lok kapmek tinotno ri mo lara avot.” ");
INSERT INTO mmx_vpl VALUES ("MT27_65","070_27_65","MAT","27","65","65","La ne Paelat ga tong i ridi xeretna, “Mina lam kaka tuvuttadi rutu mu la minat pas la mina soxoba avukat lamaaut kerekngan miklen i.” ");
INSERT INTO mmx_vpl VALUES ("MT27_66","070_27_66","MAT","27","66","66","Kuren la diga vas kaxat la diga soxoba avukat lamaaut mi levempanga soksoxoba ren, la diga on basinge luvuttadi rutu mu e ri reven tatao lamaaut. ");
INSERT INTO mmx_vpl VALUES ("MT28_1","070_28_1","MAT","28","1","1","Melemu at laaleng kaala, taba umaxantamak at laaleng avot ap mo luik, ne Maria Magdalene nedu mi lara ne Maria vetpes bok dugat pas ti ven lamaaut. ");
INSERT INTO mmx_vpl VALUES ("MT28_2","070_28_2","MAT","28","2","2","La soso mene nga langne lolos ga vot, la laangelo at Leeme Silok ga vas si boro vana at laxalibet, gat pas ti lamaaut, la ga xavun kepe lavaruat at lamaaut la garat kis to mavana ren. ");
INSERT INTO mmx_vpl VALUES ("MT28_3","070_28_3","MAT","28","3","3","Levereven teren ga lok ngan lavanga i mam, la levesingsigaara ren gan bun aleng ngan lusugao. ");
INSERT INTO mmx_vpl VALUES ("MT28_4","070_28_4","MAT","28","4","4","Luvuttadi rutu mu diga marat aleng la diga dede la diga met aroo. ");
INSERT INTO mmx_vpl VALUES ("MT28_5","070_28_5","MAT","28","5","5","La laangelo ga vaase ri lutkin keretna, “Nemen gat muta marat, aklen i dola nemu mu reven pupuse ri ne Iesu, no diga vaxarem i ro at laxaba. ");
INSERT INTO mmx_vpl VALUES ("MT28_6","070_28_6","MAT","28","6","6","Ketla kopmen ta i de, no ira roo xat pam kerekngan levelinga ni ga tong i. Ude numu la muna ven loxot diga vaxamdi i ren. ");
INSERT INTO mmx_vpl VALUES ("MT28_7","070_28_7","MAT","28","7","7","Muna vas kaxat soso la muna tong i ri lavaun pinivu ren dola neni ira roo xat amlong pam basinge lanmet la no nga iramgo vam tidi uto Galili la dinaba ven ba i ve. La monga nia a tong pam i rinumu.” ");
INSERT INTO mmx_vpl VALUES ("MT28_8","070_28_8","MAT","28","8","8","Kuren la duga vas kaxat soso basinge lamaaut la duga umsu mi lanmarat, ketla duga umsu bok mi lomomo. Duga sixit soso ri tong i ri lavaun pinivu at ne Iesu. ");
INSERT INTO mmx_vpl VALUES ("MT28_9","070_28_9","MAT","28","9","9","La soso mun ne Iesu ga ru tangarang du la ga lok tidu, “Lenmila nak lok buru minumu.” La nedu duga vas li ren la duga rebeng tu at luxangkedek teren la duga lotu saparav i. ");
INSERT INTO mmx_vpl VALUES ("MT28_10","070_28_10","MAT","28","10","10","La ne Iesu ga lok tidu xeretna, “Nemen gat muta marat. Munat pas la muna tong i ri lavaun pinivu rak dola dinat pas uto Galili la dinaba ven ia ve.” ");
INSERT INTO mmx_vpl VALUES ("MT28_11","070_28_11","MAT","28","11","11","At loxonaleng lutkin duga vas kaxat basinge lamaaut, mo luvuttadi rutu mu diga reven tatao lamaaut, digamlong uto at lemenemen silok Jerusalem la diga tong asu levempanga axap diga ven i ri lavamaasa silok. ");
INSERT INTO mmx_vpl VALUES ("MT28_12","070_28_12","MAT","28","12","12","Lavamaasa silok diga vot buru mi loxongkulao silok la diga vit li lodoxoma la diga raba laxampilas solo ri nom luvuttadi rutu mu. ");
INSERT INTO mmx_vpl VALUES ("MT28_13","070_28_13","MAT","28","13","13","La diga lok tidi, “Minaba tong i dola lavaun pinivu ren diga vot at laxanimin la diga nem kaka labantuxu ren at loxonaleng nemi miga unga. ");
INSERT INTO mmx_vpl VALUES ("MT28_14","070_28_14","MAT","28","14","14","Dola laradi gomgo, ne Paelat na ronga i na, nema maba vaase arepukus lodoxoma ren dola nemi mixo lok taxapmek at nai, la nemi guta doxoma mu solo i nom.” ");
INSERT INTO mmx_vpl VALUES ("MT28_15","070_28_15","MAT","28","15","15","Kuren la luvuttadi rutu mu diga lok ka nom levempilas la diga lox epovo levelinga diga tong taba di min. Kuren la anaa lavapaase asu ira epeseves keneng at leme Judaia i se at na levenaleng. ");
INSERT INTO mmx_vpl VALUES ("MT28_16","070_28_16","MAT","28","16","16","Melemu lasangaun mi legesara lavaun pinivu ren digat pas uto at loxongkaana ro Galili no ne Iesu ga tong li i ridi. ");
INSERT INTO mmx_vpl VALUES ("MT28_17","070_28_17","MAT","28","17","17","La at loxonaleng diga ven i, diga lotu saparav i, ketla lentaba atdi levendoxoma atdi ga sixit ekarakat. ");
INSERT INTO mmx_vpl VALUES ("MT28_18","070_28_18","MAT","28","18","18","La ne Iesu ga vas saparap nedi la ga lok tidi xeretna, “Moroa gara raba vam ia mi lolos axap to vana laxalibet la de xopok at lavatbung menemen. ");
INSERT INTO mmx_vpl VALUES ("MT28_19","070_28_19","MAT","28","19","19","Kuren la mina onon la mina lox ase limixin at lengkot axap kusu dina ravasu ngan lavaun pinivu rak. La mina sep susu di mi laasen at ne Temen dik la ne Nitna eburu bok mi Loroonan Kaala. ");
INSERT INTO mmx_vpl VALUES ("MT28_20","070_28_20","MAT","28","20","20","La mina lox ase di xusu dinang tonga res at levelinga axap nenia agara tong pam i rinimi. La nenia anabak lok eburu amisik minemi naba se at laxavaxap at na lavatbung menemen.” ");
INSERT INTO mmx_vpl VALUES ("MK1_1","071_1_1","MRK","1","1","1","Na Lagale Lavavang mumu ne Iesu Karisito, Nitna ne Moroa. ");
INSERT INTO mmx_vpl VALUES ("MK1_2","071_1_2","MRK","1","2","2","Ga ruka i kerekngan ne Aisaia leeme vapaase ali at ne Moroa ga malagan ali i at Lovoang Kaala xeretna, “Nenia naba riki laradi vapaase rak nabamgo ru la na gagas li langas tu. ");
INSERT INTO mmx_vpl VALUES ("MK1_3","071_1_3","MRK","1","3","3","Lara mo ip kup to at lamatbin keretna, mina gagas li langas ti Leeme Silok kusu tin tit pas. Mina lox akmokso larangas tin.” ");
INSERT INTO mmx_vpl VALUES ("MK1_4","071_1_4","MRK","1","4","4","La ne Jon, laradi sep susu ga rupot to at lamatbin la ga sep susu limixin la ga vavang keretna, “Mina leeng basinge laxakapmek atnimi la mina lok ka lesep susu, kusu ne Moroa naba doxoma xepe leveloklok kakapmek atnimi.” ");
INSERT INTO mmx_vpl VALUES ("MK1_5","071_1_5","MRK","1","5","5","La buaang limixin digat pot pasa amisik ne Jon to at lamatbin. Digat pas boro at lemenemen silok Jerusalem la levengkot axap at lenep silok Judaia. La diga tong asu leveloklok kakapmek atdi la ne Jon ga sep susu ba di ro at ladan sen Joridan. ");
INSERT INTO mmx_vpl VALUES ("MK1_6","071_1_6","MRK","1","6","6","Jon ga siga lavanga singsiga diga lox i mi laxabinim at lakamel. Neni ga etara avarang lavanga singsiga ren mi labanbaane diga lox i mi labantuxu at lavanga mi lavanuet kangkedek teren. La neni ga anan levenasku mi laxanmisiu boro at laxairing. ");
INSERT INTO mmx_vpl VALUES ("MK1_7","071_1_7","MRK","1","7","7","La neni ga vavang bok keretna, “Melemu rak lara naba rupot. Lolos teren i volo lolos tarak. Axo epovo xusu ana soxomus luvanga vatpas teren mila neni i silok aleng tia. ");
INSERT INTO mmx_vpl VALUES ("MK1_8","071_1_8","MRK","1","8","8","Nenia a sep susu nimi mi ladan mene nga, ketla neni naba sep susu nimi mi Loroonan Kaala.” ");
INSERT INTO mmx_vpl VALUES ("MK1_9","071_1_9","MRK","1","9","9","Ap mo levenaleng, ne Iesu ga laa boro at lenep Galili at lemenemen teren Nasaret la ga vot pasa ne Jon. La ne Jon ga sep susu i ro ladan sen Joridan. ");
INSERT INTO mmx_vpl VALUES ("MK1_10","071_1_10","MRK","1","10","10","La ne Iesu ga vas basinge ladan la soso mun neni ga ven laxalibet ga rem suang, ga ven bok Loroonan Kaala ga lok ngan lamno ga rava si, la ga nemen teren. ");
INSERT INTO mmx_vpl VALUES ("MK1_11","071_1_11","MRK","1","11","11","La laxaka at lara ga laa boro vana at laxalibet ga lok keretna, “Nena ne nuruk. A balamu i la a lok momo min.” ");
INSERT INTO mmx_vpl VALUES ("MK1_12","071_1_12","MRK","1","12","12","La soso mun Loroonan Kaala ga riki ne Iesu uto at lamatbin. ");
INSERT INTO mmx_vpl VALUES ("MK1_13","071_1_13","MRK","1","13","13","La neni ga nemen e at lavanuet sangaun aleng. La ne Satan gak lok tong pen i. La ap mo lenep lempanga sio mi lavanuet kangkedek atdi diga nemen box e la lubungangelo digak lok tatao ne Iesu. ");
INSERT INTO mmx_vpl VALUES ("MK1_14","071_1_14","MRK","1","14","14","At lara laaleng diga ranga alis ne Jon la diga lok li i ro at loogu xokoxo, la melemu ren ne Iesu gamlong uto at lenep Galili la ga tong asu Lagale Lavavang at ne Moroa. ");
INSERT INTO mmx_vpl VALUES ("MK1_15","071_1_15","MRK","1","15","15","Neni ga vavang keretna, “Levenaleng ngangais ira xap ta. Langas ti Linintoo at ne Moroa monga i auret. Mina leeng basinge leveloklok kakapmek atnimi la mina nunu at Lagale Lavavang.” ");
INSERT INTO mmx_vpl VALUES ("MK1_16","071_1_16","MRK","1","16","16","La ne Iesu gat pas saparap lavatdan kis Galili la ni ga ven legepu radi sepsep mat, ne Simon mi ne Endru. Nedu leeton duga loloa mi laxatkat to at lavatdan kis. ");
INSERT INTO mmx_vpl VALUES ("MK1_17","071_1_17","MRK","1","17","17","La ne Iesu ga lok tidu xeretna, “Ude numu, muna mumu asu ia. Nenia anaba lox ase numu mi langas ti sat kaka limixin i ngan tai mo, nemu mu loloa ka lenmat.” ");
INSERT INTO mmx_vpl VALUES ("MK1_18","071_1_18","MRK","1","18","18","La soso mun nedu duga on basinge laxatkat atdu la duga emu min. ");
INSERT INTO mmx_vpl VALUES ("MK1_19","071_1_19","MRK","1","19","19","La ne Iesu gat pas uto lixilik la ga ven ne Jems, nitna ne Sebedi la ga ven bok neton, ne Jon. Nedi digat kis at lesepang la diga lox agagas li lengkatkat. ");
INSERT INTO mmx_vpl VALUES ("MK1_20","071_1_20","MRK","1","20","20","La soso mun ni ga ro xaka du la duga vas kaxat, duga on basinge ne temen du mi luvuttadi gugu ro at lesepang la duga emu min. ");
INSERT INTO mmx_vpl VALUES ("MK1_21","071_1_21","MRK","1","21","21","La ne Iesu eburu mi lavaun pinivu ren diga onon uto at lemenemen Kaprenaum la at laaleng kaala diga vubeles at loogu singising la ne Iesu ga anasa limixin. ");
INSERT INTO mmx_vpl VALUES ("MK1_22","071_1_22","MRK","1","22","22","La nom limixin diga sangu mila levelinga ren ga mumuat, neni xopmen goxo anasa ngan luvuttadi loklox ase at Laulis Linga. ");
INSERT INTO mmx_vpl VALUES ("MK1_23","071_1_23","MRK","1","23","23","La soso mun lara laradi ga xatu upana ro xeneng at loogu singising, lagas ga suxuna i la ni gap kup keretna, ");
INSERT INTO mmx_vpl VALUES ("MK1_24","071_1_24","MRK","1","24","24","“Iesu me Nasaret, unaba lok lavanga salai rinama? Uga rupot kusu unaba sep kepe axap nema, do? Aklen u. Nenu ne Nitna ne Moroa.” ");
INSERT INTO mmx_vpl VALUES ("MK1_25","071_1_25","MRK","1","25","25","La ne Iesu ga vaase lolos tin, “Una lok pilo. Una sixisu basinge na laradi.” ");
INSERT INTO mmx_vpl VALUES ("MK1_26","071_1_26","MRK","1","26","26","La nom lagas ga lox adede lolos nom laradi, la gap kup silok, la ga sixisu basinge ba i. ");
INSERT INTO mmx_vpl VALUES ("MK1_27","071_1_27","MRK","1","27","27","La limixin axap diga sangu aleng la diga epaase xeretna, “Loklok salai mo? Laanasa maxat mo, do? Lolos teren i silok. I tong asu levelinga ti lubunggas la di mu asu i.” ");
INSERT INTO mmx_vpl VALUES ("MK1_28","071_1_28","MRK","1","28","28","La nom limixin diga onon la diga tong nom lavanga ne Iesu ga lox i la limixin axap to at lenep Galili diga ronga i. ");
INSERT INTO mmx_vpl VALUES ("MK1_29","071_1_29","MRK","1","29","29","La ne Iesu ga vas su at loogu singising la soso mun nedi mi ne Jems la ne Jon diga vubeles at loogu at ne Simon la ne Endru. ");
INSERT INTO mmx_vpl VALUES ("MK1_30","071_1_30","MRK","1","30","30","La luvutulom at ne Simon ga meres mi liplivi la gak midi ro at loora ren. Diga tong i nom ti ne Iesu, ");
INSERT INTO mmx_vpl VALUES ("MK1_31","071_1_31","MRK","1","31","31","la soso mun ne Iesu ga vot pasa i, ga rebeng axatu i la liplivi ga xap basinge i. La ni ga lox agagas lempanga anan tinedi. ");
INSERT INTO mmx_vpl VALUES ("MK1_32","071_1_32","MRK","1","32","32","Ga ukantinao laxangking ga lotup, limixin me go diga vot pasa ne Iesu, diga lam kaka limixin mi laxanasen anmeres la limixin lubunggas ga suxuna di. ");
INSERT INTO mmx_vpl VALUES ("MK1_33","071_1_33","MRK","1","33","33","Buaang limixin ap mo lemenemen diga vot saparap ne Iesu ap mo loogu. ");
INSERT INTO mmx_vpl VALUES ("MK1_34","071_1_34","MRK","1","34","34","La ne Iesu ga lox aroo limixin mekmeres la ga riki xepe lubunggas basinge limixin. Lubunggas digaklen i do ne Iesu nitna ne Moroa, ketla ne Iesu goxo siam do dina tong asu i ri limixin. ");
INSERT INTO mmx_vpl VALUES ("MK1_35","071_1_35","MRK","1","35","35","Taba umaxantamak suubu gak lok main kakalik move, Iesu ga aus la ga vas su la gat pas uto at lenep mimila la neni ga lok lising. ");
INSERT INTO mmx_vpl VALUES ("MK1_36","071_1_36","MRK","1","36","36","La ne Simon eburu mi larapen tangas teren diga puse rin ");
INSERT INTO mmx_vpl VALUES ("MK1_37","071_1_37","MRK","1","37","37","se diga vuse ka i, la diga lok tin keretna, “Limixin axap di puse ru.” ");
INSERT INTO mmx_vpl VALUES ("MK1_38","071_1_38","MRK","1","38","38","La ne Iesu ga lok tidi xeretna, “Ata onon uto at levenmenemen petpes kusu ana vavang bok go. Ni lavasuun teren la nenia aga si ude xopok at lavatbung menemen.” ");
INSERT INTO mmx_vpl VALUES ("MK1_39","071_1_39","MRK","1","39","39","La ne Iesu gat pas tangtagap at levengkot axap at lenep Galili. La ni ga vavang to at laraogu singising atdi la ni ga riki xepe lubunggas basinge limixin. ");
INSERT INTO mmx_vpl VALUES ("MK1_40","071_1_40","MRK","1","40","40","At lara laaleng lara laradi ga vot pasa ne Iesu. Lanmeres gak lok teren, diga tong i mila lanmeres gu (leprosy). La neni ga sing ne Iesu kusu ne Iesu na lox aroo i. La neni ga xis tiktikbu mi luvatgulom teren ti lok ngangao at ne Iesu la ga lok tin, “Do u vara i, una lox aroo ia.” ");
INSERT INTO mmx_vpl VALUES ("MK1_41","071_1_41","MRK","1","41","41","La ne Iesu ga balamu i la ga song asu mi lekngen la ga long tu ren la ga lok tin keretna, “A vara i, lanmeres taram na xap ta.” ");
INSERT INTO mmx_vpl VALUES ("MK1_42","071_1_42","MRK","1","42","42","La soso mun nom lanmeres ga xap la nom laradi ga lox avukat. ");
INSERT INTO mmx_vpl VALUES ("MK1_43","071_1_43","MRK","1","43","43","La ne Iesu ga paase lolos tin la ga riki aonon i, ");
INSERT INTO mmx_vpl VALUES ("MK1_44","071_1_44","MRK","1","44","44","ni ga vaase rin keretna, “Nemen uta tong asu i na ri teta, ketla unat pas uto at lamaasa la neni na ven mumu u. Melemu una lok laramtaba ram ti ne Moroa ngan ne Moses ga tong i xusu ti lox asuusu i ri limixin axap do nenu mo ura lox avukat ta.” ");
INSERT INTO mmx_vpl VALUES ("MK1_45","071_1_45","MRK","1","45","45","Ketla nom laradi ga vas kaxat la ga tong asu i ri limixin axap. Kuren la ne Iesu gat pas lipe mene ro at levenmenemen, mila buaang limixin diga lox angtang amisix i. La ni ga nemen to at lamatbin, ketla buaang limixin move diga tupot pasa i, diga laala boro at levengkot axap. ");
INSERT INTO mmx_vpl VALUES ("MK2_1","071_2_1","MRK","2","1","1","Lentaba levenaleng ga xap la ne Iesu gamlong uto Kaprenaum la limixin diga ronga levelinga do ne Iesu ga rupot to at loogu ren. ");
INSERT INTO mmx_vpl VALUES ("MK2_2","071_2_2","MRK","2","2","2","La buaang limixin diga vot eburu go la nom loogu ga umsu la no maxamang bok saparap lumusmaragu ga umsu bok. La ne Iesu ga vavang tidi. ");
INSERT INTO mmx_vpl VALUES ("MK2_3","071_2_3","MRK","2","3","3","La lentaba limixin diga rupot to at nom loogu la lavanuet atdi digap kip lara laradi mi loora ren. Nom laradi ga meres, labantuxu ren ga molo axap. ");
INSERT INTO mmx_vpl VALUES ("MK2_4","071_2_4","MRK","2","4","4","La nedi di goxo epovo dina vot saparap ne Iesu min mila buaang limixin diga rupe lumusmaragu. Kuren la nedi diga eng urut at nom loogu la diga ut avolo loxot to mavana saparap ne Iesu la diga lox asi nom laradi mekmeres mi loora ren. ");
INSERT INTO mmx_vpl VALUES ("MK2_5","071_2_5","MRK","2","5","5","La ne Iesu ga ven kibis lununu atdi la ga lok ti laradi mekmeres keretna, “Lentangas tarak. Leveloklok kakapmek axap taram, a doxoma xepe i.” ");
INSERT INTO mmx_vpl VALUES ("MK2_6","071_2_6","MRK","2","6","6","La lentaba luvuttadi loklox ase at Laulis Linga digat kis go, diga ronga nom levelinga at ne Iesu la diga esue at levendoxoma atdi xeretna, ");
INSERT INTO mmx_vpl VALUES ("MK2_7","071_2_7","MRK","2","7","7","“Na laradi i paase kereva? I paase vupu ri ne Moroa. Nege i epovo ti doxoma xepe leveloklok kakapmek? Moroa xusuk i epovo.” ");
INSERT INTO mmx_vpl VALUES ("MK2_8","071_2_8","MRK","2","8","8","La soso mun ne Iesu ga doxoma xisip nom levendoxoma atdi la ga lok tidi xeretna, “Tila nemi mi doxoma ekarakat mumu i na levelinga rak? ");
INSERT INTO mmx_vpl VALUES ("MK2_9","071_2_9","MRK","2","9","9","Ua levelinga xopmen na lolos ti tong i? Leveloklok taram ara doxoma xepe vam i, kopla ana tong i do, katu kaxat la unat pas? ");
INSERT INTO mmx_vpl VALUES ("MK2_10","071_2_10","MRK","2","10","10","Ketla a vara i do minaklen i do, nenia, Laradi Mevana, a ruuna lolos at na lavatbung menemen ti doxoma xepe leveloklok kakapmek.” La ni ga lok ti mo laradi mekmeres keretna, ");
INSERT INTO mmx_vpl VALUES ("MK2_11","071_2_11","MRK","2","11","11","“A tong i ru, una xatu upana, la una xip kaka loora ram, la una vas kaxat ukolonu.” ");
INSERT INTO mmx_vpl VALUES ("MK2_12","071_2_12","MRK","2","12","12","La nom laradi ga xatu kaxat, la ga xip kaka loora ren la ga vas kaxat. La nedi axap diga ven i, diga sangu aleng la diga emi asu mi ne Moroa la diga epaase xeretna, “Nedik goxovisi na ven tempanga xeretnom.” ");
INSERT INTO mmx_vpl VALUES ("MK2_13","071_2_13","MRK","2","13","13","La melemu ne Iesu ga on basinge manga lemenemen Kaprenaum la gat pas saparap lavatdan kis Galili. La buaang limixin diga vot pasa i la neni ga anasa di. ");
INSERT INTO mmx_vpl VALUES ("MK2_14","071_2_14","MRK","2","14","14","La melemu ni gat pas uto lixilik la ga ven ne Levi nitna ne Alpias, gat kis to at loogu xekepe pilas. La ne Iesu ga lok tin keretna, “Una mumu asu ia.” La ne Levi ga xatu la ga mumu asu i. ");
INSERT INTO mmx_vpl VALUES ("MK2_15","071_2_15","MRK","2","15","15","Melemu ne Iesu gat kis la ga anan to at loogu at ne Levi. Luvuttadi xekepe pilas la limixin kakapmek diga anan eburu mi ne Iesu. Buaang limixin kakapmek diga mumu asu ne Iesu. ");
INSERT INTO mmx_vpl VALUES ("MK2_16","071_2_16","MRK","2","16","16","La luvuttadi loklox ase at Laulis Linga mi lubung Parisi diga ven i do ne Iesu ga anan eburu mi nom limixin kakapmek la diga lok ti lavaun pinivu at ne Iesu xeretna, “Tila ne Iesu i anan eburu mi nom luvuttadi loklok ka pilas la limixin kakapmek?” ");
INSERT INTO mmx_vpl VALUES ("MK2_17","071_2_17","MRK","2","17","17","La ne Iesu ga ronga i nom la ga lok tidi xeretna, “Limixin di lox avukat, kopmen dinak pakes ti loklok tooro, ketla nedi xusuk mun dik meres. Aga rupot kusu ti ro xaka limixin kakapmek dikpakes kusu dina leeng, la nia goxo rupot kusu tinedi limixin manmanton.” ");
INSERT INTO mmx_vpl VALUES ("MK2_18","071_2_18","MRK","2","18","18","At lara laaleng lavaun pinivu at ne Jon, laradi sep susu limixin, diga mun anan la lubung Parisi bok diga mun anan. La lentaba limixin diga vot pasa ne Iesu la diga sue i xeretna, “Lavaun pinivu at ne Jon di mun anan la lubung Parisi bok di mun anan. Tila ba lavaun pinivu ram kopmen dina mun anan?” ");
INSERT INTO mmx_vpl VALUES ("MK2_19","071_2_19","MRK","2","19","19","La ne Iesu ga vorang i ridi mi lavapaase poovo xeretna, “At loklox anarong ti leepot, lentaba at laradi epot di noxo mun anan mila laradi epot ik lok eburu midi. ");
INSERT INTO mmx_vpl VALUES ("MK2_20","071_2_20","MRK","2","20","20","Ketla laaleng move naba rupot la limixin petpes dinaba lam ka laradi epot basinge lentaba ren la dina mun anan ba ap mo laaleng.” ");
INSERT INTO mmx_vpl VALUES ("MK2_21","071_2_21","MRK","2","21","21","La ne Iesu ga tong asu lavapaase poovo ridi xeretna, “Kopmen teta na balais ka loxontamon maxat kusu na sok gatgat pe lamamara at labantamon maut. Mo do neni na lox i xuren, loxontamon maxat ira lok kapmek pam la kopmen na epovo bok ba kusu ata ba lok tavanga min. La nom loxontamon maxat noxo epovo kusu na lok pe avukat lamamara at loxontamon maut.” ");
INSERT INTO mmx_vpl VALUES ("MK2_22","071_2_22","MRK","2","22","22","La ne Iesu ga vaase bok tidi mi lavapaase poovo. Ni ga lok keretna, “Kopmen tara na soli li laxadan vaen maxat uto xeneng ti labantuxu at lavatme i maut pam. Mo do neni na lox i xuren, mo labantuxu maut ba repagam la laxadan vaen naba soli su ukamang, la labantuxu maut naba lok kapmek. Laxadan vaen maxat mina soli li i at labantuxu maxat.” ");
INSERT INTO mmx_vpl VALUES ("MK2_23","071_2_23","MRK","2","23","23","At lara laaleng kaala Iesu mi lavaun pinivu ren diga vas polo lentaamang piao la lavaun pinivu ren diga dik ka levempeven piao la diga anan i. ");
INSERT INTO mmx_vpl VALUES ("MK2_24","071_2_24","MRK","2","24","24","La lubung Parisi diga ven i nom la diga lok ti ne Iesu xeretna, “Pen ba i nom. Dira los polo vam Laulis Linga, i tong i do nemen mitak lok lempanga keretnom at laaleng kaala.” ");
INSERT INTO mmx_vpl VALUES ("MK2_25","071_2_25","MRK","2","25","25","La ne Iesu ga lok tidi xeretna, “Mina doma su ap mo lempanga ne Devit, ga lox i at laaleng neni eburu mi limixin teren digak pakes la diga roxo. ");
INSERT INTO mmx_vpl VALUES ("MK2_26","071_2_26","MRK","2","26","26","Neni ga vubeles at loogu at ne Moroa ap mo lamaares ne Abaita neni laradi gomgo at lavamaasa. La ne Devit ga lok ka mo lengkongkide digam taba min ti ne Moroa, la ni ga anan teren la ga raba bok lengkot teren ti limixin teren. La kerepmo diga los polo Laulis Linga, mila lavamaasa kusuk mun diga anan mo lengkongkide.” ");
INSERT INTO mmx_vpl VALUES ("MK2_27","071_2_27","MRK","2","27","27","La ne Iesu ga lok bok tidi xeretna, “Moroa ga lok li laaleng kaala ri lok tooro limixin. Neni goxo rudum li limixin kusu ti lok tooro laaleng kaala. ");
INSERT INTO mmx_vpl VALUES ("MK2_28","071_2_28","MRK","2","28","28","Nenia Laradi Mevana. La nenia Lamgomgo at laaleng kaala la ak lok tatao mo laaleng.” ");
INSERT INTO mmx_vpl VALUES ("MK3_1","071_3_1","MRK","3","1","1","La melemu ne Iesu ga vubeles manga to at loogu singising. Lara laradi mi lekngen ga molo gat kis go. ");
INSERT INTO mmx_vpl VALUES ("MK3_2","071_3_2","MRK","3","2","2","Lubung Parisi diga reven pilo ne Iesu do neni naba lox aroo nom laradi at laaleng kaala. Diga vara i do nedi dina sok taba ne Iesu mi tevelinga. ");
INSERT INTO mmx_vpl VALUES ("MK3_3","071_3_3","MRK","3","3","3","La ne Iesu ga tong i ri nom laradi mi lekngen ga molo keretna, “Una xatu kaxat ude melamgo at limixin axap.” ");
INSERT INTO mmx_vpl VALUES ("MK3_4","071_3_4","MRK","3","4","4","La ne Iesu ga sue lubung Parisi xeretna, “Lavanga salai Laulis Linga i siam min kusu ata lox i at laaleng kaala? Ti lok tooro laradi kopla ti lox asongor i? Ti lox arooro laradi kopla ti sev amer i?” Ketla di goxo vorang i. ");
INSERT INTO mmx_vpl VALUES ("MK3_5","071_3_5","MRK","3","5","5","La ni ga ven tangtagap tinedi la ga musak di la ga lok bukbulu aleng bok atla lebelendi ga lolos aleng. La ni ga lok ti nom laradi xeretna, “Una song asu mi lakngam.” La nom laradi ga song asu mi lekngen la lekngen ga lox avukat. ");
INSERT INTO mmx_vpl VALUES ("MK3_6","071_3_6","MRK","3","6","6","La lubung Parisi diga on basinge loogu singising la soso mun diga vot pasa luvuttadi diga etangas mi ne Erodes. La nedi diga puse ngas kusu dina sev amet ne Iesu. ");
INSERT INTO mmx_vpl VALUES ("MK3_7","071_3_7","MRK","3","7","7","La ne Iesu mi lavaun pinivu ren diga on basinge loogu singising la diga vas si uto at lavatdan kis Galili. La buaang limixin diga mumu asu i. Nedi limixin diga laa boro at lengkot axap, lentaba boro at lenep silok Galili, ");
INSERT INTO mmx_vpl VALUES ("MK3_8","071_3_8","MRK","3","8","8","lentaba boro at lenep silok Judaia, lentaba boro at lemenemen silok Jerusalem, lentaba boro at lenep silok Idumia, lentaba boro Joridan at lenep dan meso, lentaba boro at lenep silok at lumenemen Taia la Sidon. Nedi axap diga vot pasa ne Iesu mila diga ronga nom lempanga neni ga lox i. ");
INSERT INTO mmx_vpl VALUES ("MK3_9","071_3_9","MRK","3","9","9","La ne Iesu ga tong i ri lavaun pinivu ren dola dina lok ka lesepang lixilik tin ti ru ren. La neni ga vavang ti limixin to at nom lesepang mila buaang limixin diga vot saparav i la diga umsu aleng. ");
INSERT INTO mmx_vpl VALUES ("MK3_10","071_3_10","MRK","3","10","10","Diga vot saparav i mila neni ga lox aroo buaang limixin. La limixin mi levenasen anmeres diga esi xakape ti long tu ren kusu levenanmeres atdi na xap. ");
INSERT INTO mmx_vpl VALUES ("MK3_11","071_3_11","MRK","3","11","11","La lentaba limixin lubunggas ga suxuna di, diga rupot saparap ne Iesu la diga xis tiktikbu mi lempatgulom atdi. Ga se diga ven i, digap kup silok keretna, “Nenu Nitna ne Moroa.” ");
INSERT INTO mmx_vpl VALUES ("MK3_12","071_3_12","MRK","3","12","12","La ne Iesu ga vaase pe lubunggas dola di noxo tong asu i ri limixin dola neni Nitna ne Moroa. ");
INSERT INTO mmx_vpl VALUES ("MK3_13","071_3_13","MRK","3","13","13","La melemu ne Iesu ga urut at lavatkaana la ga ro xaka mo luvuttadi neni ga vara i do dina gugu eburu min. La nedi diga vot pasa i. ");
INSERT INTO mmx_vpl VALUES ("MK3_14","071_3_14","MRK","3","14","14","La ni ga lok katling lasangaun mi legepu radi la ga so asen di mi luvuttadi vavang. Ni ga soxolik kaka di xusu dina nemen eburu min la kusu neni naba riki di ti vavang ");
INSERT INTO mmx_vpl VALUES ("MK3_15","071_3_15","MRK","3","15","15","la ti riki xepe lubunggas basinge limixin. ");
INSERT INTO mmx_vpl VALUES ("MK3_16","071_3_16","MRK","3","16","16","Levenasen at nom luvuttadi, ne Simon, Iesu ga raba box i mi lara laasen, ne Pita. ");
INSERT INTO mmx_vpl VALUES ("MK3_17","071_3_17","MRK","3","17","17","La ne Jems du lueton mi ne Jon, lumdak at ne Sebedi. Iesu ga raba bok du mi lara laasen, ne Boaneges, lavasuun at nom loxolinga xeretna, di paase mukmusak ngan lavanga i mam. ");
INSERT INTO mmx_vpl VALUES ("MK3_18","071_3_18","MRK","3","18","18","La bok ne Endru la ne Pilip, la ne Batolomiu, la ne Metiu, la ne Tomas, la ne Jems nitna ne Alpias, la ne Tadias, la ne Simon, neni lara at libinam tadi me Selot, ");
INSERT INTO mmx_vpl VALUES ("MK3_19","071_3_19","MRK","3","19","19","la ne Judas Iskariot, neni nom laradi ga song araba ne Iesu ri limixin kakapmek. ");
INSERT INTO mmx_vpl VALUES ("MK3_20","071_3_20","MRK","3","20","20","Melemu ne Iesu midi diga vubeles uto at loogu la buaang limixin diga vot pasa manga di. La ne Iesu mi lavaun pinivu ren di goxo epovo na anan mila buaang limixin digak lox angtang di. ");
INSERT INTO mmx_vpl VALUES ("MK3_21","071_3_21","MRK","3","21","21","Se lentaba at ne Iesu diga ronga i nom, diga lok do dina rupot ti lam kaka i mila diga lok do ne Iesu gang tangku. ");
INSERT INTO mmx_vpl VALUES ("MK3_22","071_3_22","MRK","3","22","22","La luvuttadi loklox ase at Laulis Linga diga laa boro Jerusalem la diga lok keretna, “Belsebul i suxuna i mi lolos teren la neni leeme gomgo at lubunggas la neni ira riki xepe lubunggas.” ");
INSERT INTO mmx_vpl VALUES ("MK3_23","071_3_23","MRK","3","23","23","La ne Iesu ga ro xaka luvuttadi loklox ase at Laulis Linga la ga lok tidi xeretna, “Lavapaase atnimi xopmen nak mokso mila ne Satan noxo riki xepe lubunggas teren.” ");
INSERT INTO mmx_vpl VALUES ("MK3_24","071_3_24","MRK","3","24","24","La ne Iesu ga paase poovo ridi xeretna, “Dola tubung mixin di epes di ri lengkon binam tadi, la dia esep eburu minedi xa, kopmen noxo lok nunuan letuna atdi. ");
INSERT INTO mmx_vpl VALUES ("MK3_25","071_3_25","MRK","3","25","25","Loxoetemen do di epes ti esep, dinaba xis epeseves. ");
INSERT INTO mmx_vpl VALUES ("MK3_26","071_3_26","MRK","3","26","26","La kerepmo bok do ne Satan mi lubunggas dina esep, dinaba epeseves la lolos at ne Satan naba xap. ");
INSERT INTO mmx_vpl VALUES ("MK3_27","071_3_27","MRK","3","27","27","Do tara i vara na xip pilo xaka lempanga at loogu at taradi lolos, neni na xoxo alis be mo laradi la melemu na xip kaka ba lempanga ren. ");
INSERT INTO mmx_vpl VALUES ("MK3_28","071_3_28","MRK","3","28","28","Nia a tong tuturun i rinimi. Moroa naba doxoma xepe leveloklok kakapmek at limixin axap la neni naba doxoma xepe levelinga kapmek limixin dina paase mumu i min. ");
INSERT INTO mmx_vpl VALUES ("MK3_29","071_3_29","MRK","3","29","29","Ket do tara na vaase vupu ri Loroonan Kaala, ne Moroa noxo doxoma xepe rinotno i. Neni i bixurun mi laxakapmek ua ixo epovo do ne Moroa na doxoma xepe i.” ");
INSERT INTO mmx_vpl VALUES ("MK3_30","071_3_30","MRK","3","30","30","Iesu ga tong i na atla luvuttadi loklox ase at Laulis Linga diga lok do lagas ga suxuna ne Iesu. ");
INSERT INTO mmx_vpl VALUES ("MK3_31","071_3_31","MRK","3","31","31","La nenen mi luvutneton ne Iesu diga rupot. Diga tu ro xamang la diga riki lara ri ro xaka i. ");
INSERT INTO mmx_vpl VALUES ("MK3_32","071_3_32","MRK","3","32","32","Buaang limixin digat kis kangkan i la diga tong i rin dola nenen mi luvutneton di puse i. ");
INSERT INTO mmx_vpl VALUES ("MK3_33","071_3_33","MRK","3","33","33","La ne Iesu ga lok, “Nege mo ne naga la nege di luvutnetak?” ");
INSERT INTO mmx_vpl VALUES ("MK3_34","071_3_34","MRK","3","34","34","La ne Iesu ga ven tinedi digat kis kangkan i la neni ga lok ti limixin axap keretna, “Na luvuttadi nedi di lok ngan ne naga mi luvutnetak. ");
INSERT INTO mmx_vpl VALUES ("MK3_35","071_3_35","MRK","3","35","35","Neni mun i mu asu lavavara at ne Moroa, neni netak kopla neinuk kopla ne naga.” ");
INSERT INTO mmx_vpl VALUES ("MK4_1","071_4_1","MRK","4","1","1","La melemu ne Iesu ga anasa manga limixin saparap lavatdan kis Galili. Buaang limixin diga umsu la diga esi aleng. Kuren la ne Iesu ga vubeles to xeneng at lesepang la gat kis teren to at lavatdan kis la limixin axap digat kis to loxon la digang tonga i ga paase. ");
INSERT INTO mmx_vpl VALUES ("MK4_2","071_4_2","MRK","4","2","2","La ne Iesu ga tong asu laxampanga solo mi lempapaase poovo, la neni ga tong lavapaase poovo xeretna, ");
INSERT INTO mmx_vpl VALUES ("MK4_3","071_4_3","MRK","4","3","3","“Mina ronga avukar i na. Lara laradi gat pas uto xataamang, la gatlotlo levennit piao, ga lulu reve min. ");
INSERT INTO mmx_vpl VALUES ("MK4_4","071_4_4","MRK","4","4","4","La lentaba levennit piao ga subu at langa. Lavapixa diga vot la diga rok axav i. ");
INSERT INTO mmx_vpl VALUES ("MK4_5","071_4_5","MRK","4","5","5","La lentaba levennit piao ga subu ro at laxanuat la lengkongkangka lixilik mene gak lok teren. Levenit piao ga suu xat soso mun, mila goxopmen taxangka solo. ");
INSERT INTO mmx_vpl VALUES ("MK4_6","071_4_6","MRK","4","6","6","Ise laxangking ga losu upana, ga sev amolos axap nom lempiao, mila levenixe atdi goxo si aleng ukopok la nom lempiao suusu diga met axap. ");
INSERT INTO mmx_vpl VALUES ("MK4_7","071_4_7","MRK","4","7","7","La lentaba ga subu ro at livin gagas. La nom livin gagas ga suu xat la ga is nom lempiao la levempiao goxo visik. ");
INSERT INTO mmx_vpl VALUES ("MK4_8","071_4_8","MRK","4","8","8","La lentaba ga subu ro at loxongkangka avukat la ga suu xat, la ga suusu avukat, la melemu ga visik laxampeven teren. Lentaba ga visik lavantun sangaun, lentaba ga visik lavanna sangaun, lentaba ga visik legesa sangaun kobot (100).” ");
INSERT INTO mmx_vpl VALUES ("MK4_9","071_4_9","MRK","4","9","9","La ne Iesu ga lok bok tidi xeretna, “Mina doxoma avukat nom levelinga rak kusu mina xasep teren.” ");
INSERT INTO mmx_vpl VALUES ("MK4_10","071_4_10","MRK","4","10","10","Melemu ne Iesu gak lok mi lavaun pinivu ren la lentaba petpes bok la nedi xusuk digak lok eburu min la diga sue i mi lempapaase poovo. ");
INSERT INTO mmx_vpl VALUES ("MK4_11","071_4_11","MRK","4","11","11","La ne Iesu ga vorang i ridi xeretna, “Moroa ira raba vam nimi mi lakleklen at Linintoo at ne Moroa, gano ga nemen alipe. Ketla tinedi maxamang, di ronga mene lempapaase poovo. ");
INSERT INTO mmx_vpl VALUES ("MK4_12","071_4_12","MRK","4","12","12","Ni ik lox i xuren kusu, ‘Nedi di reven lugugu, ketla di noxo ven kibis i. Ding tonga mo levelinga, ketla di noxo xasep teren. Do dina xasep, diba leeng la ne Moroa na doxoma xepe leveloklok kakapmek atdi.’” ");
INSERT INTO mmx_vpl VALUES ("MK4_13","071_4_13","MRK","4","13","13","La ne Iesu ga lok bok tidi xeretna, “Kereva, kopmen mina xasep at na lavapaase poovo? Do mixo xasep at na lavapaase poovo, i lolos do mina xasep at lempapaase poovo vetpes bok, ketla ana tong axasev i nom tinimi. ");
INSERT INTO mmx_vpl VALUES ("MK4_14","071_4_14","MRK","4","14","14","At na lavapaase poovo mo laradi lotlo i ru katling laradi i tong asu levelinga at ne Moroa. ");
INSERT INTO mmx_vpl VALUES ("MK4_15","071_4_15","MRK","4","15","15","Lentaba levennit piao ga subu ro at langa i ru katling limixin di ronga levelinga at ne Moroa, ketla ne Satan i tupot soso la ik lok pes i. ");
INSERT INTO mmx_vpl VALUES ("MK4_16","071_4_16","MRK","4","16","16","Ti levenit piao ga subu ro at laxanuat, lengkongkangka lixilik gak lok teren, ni i ru katling nedi limixin di ronga levelinga la soso mun di siam ka i mi lomomo. ");
INSERT INTO mmx_vpl VALUES ("MK4_17","071_4_17","MRK","4","17","17","Ketla ixo vubeles ukeneng at lorooro atdi, la lununu atdi ixo nemen abao solo. Kuren la ise do levenmumuat i vot eburu mi levesongsongot mumu levelinga at ne Moroa, lununu atnedi i subu soso mun. ");
INSERT INTO mmx_vpl VALUES ("MK4_18","071_4_18","MRK","4","18","18","Ti levenit piao ga subu ro at livin gagas, ni i ru katling nedi limixin di ronga levelinga, ");
INSERT INTO mmx_vpl VALUES ("MK4_19","071_4_19","MRK","4","19","19","ketla di bulu mu solo laxampanga at na lorooro la nom lavavara atnedi ri lapnovos, la levereven peves ti lempanga at na lavatkangka i vubeles at lorooro atdi la di itis nom levelinga la dixo visik tempeven una. ");
INSERT INTO mmx_vpl VALUES ("MK4_20","071_4_20","MRK","4","20","20","La ti levennit piao ga subu at laxangka nunuan, ni i ru katling limixin di ronga levelinga at ne Moroa la di siam kaka i la lempanga avukat i ravasu at lorooro atdi. Lentaba di visik lempeven una i epovo at lavantun sangaun la lentaba lavanna sangaun la lentaba legesa sangaun kobot (100).” ");
INSERT INTO mmx_vpl VALUES ("MK4_21","071_4_21","MRK","4","21","21","La ne Iesu ga tong bok lavapaase poovo ridi xeretna, “Kereva, mi sox aros lababao la mi vung pavaa i mi lavatbaaket kopla mina lok li maxopok at loora? Kopmen. Mi lok li i ro at loxot kasep. ");
INSERT INTO mmx_vpl VALUES ("MK4_22","071_4_22","MRK","4","22","22","Lempanga no ga nemen alipe rinotno, naba ravasu ri lasaxaven. La levelinga, lavasuun teren no i nemen alipe, melemu naba xasep. ");
INSERT INTO mmx_vpl VALUES ("MK4_23","071_4_23","MRK","4","23","23","Do tara i ruuna lubaalung ting tonga, neni na ronga avukat na levelinga.” ");
INSERT INTO mmx_vpl VALUES ("MK4_24","071_4_24","MRK","4","24","24","La ne Iesu ga lok bok tidi xeretna, “Minang tonga avukat na levelinga. La lempanga mi lox i rinedi vetpes, neni mun i nom ne Moroa naba raba nimi min, la loxot bok mavana ren. ");
INSERT INTO mmx_vpl VALUES ("MK4_25","071_4_25","MRK","4","25","25","Do tara na siam ka mo levelinga ne Moroa i raba i min, Moroa naba raba box i mi laxasep avukat at levelinga ren. Dola tara noxo siam ka levelinga at ne Moroa, Moroa naba lok pes bok laxasep kakalik teren, keke i do neni i doxoma i do im tebeng i.” ");
INSERT INTO mmx_vpl VALUES ("MK4_26","071_4_26","MRK","4","26","26","La ne Iesu ga tong asu bok lavapaase poovo ridi xeretna, “Linintoo at ne Moroa i lok keretna. Lara laradi gatlotlo levennit piao ro xataamang, ");
INSERT INTO mmx_vpl VALUES ("MK4_27","071_4_27","MRK","4","27","27","la ni gak midi la ga aus at levenaleng axap. Mo levennit piao ga raut la ga suusu la nom laradi goxoklen i do mo levempiao ga suu kereva. ");
INSERT INTO mmx_vpl VALUES ("MK4_28","071_4_28","MRK","4","28","28","La laxangka axa ga lox asuusu mo levempiao. Levempiao ga raut avot, melemu ren levempavaxan teren ga suu xat la melemu nom levennit piao ga visik. ");
INSERT INTO mmx_vpl VALUES ("MK4_29","071_4_29","MRK","4","29","29","Se mo lempeven teren ga mukun, mo laradi ga riki luvuttadi gugu ren mi lemparise atdi ti sep kin ap mo lempeven piao.” ");
INSERT INTO mmx_vpl VALUES ("MK4_30","071_4_30","MRK","4","30","30","La ne Iesu ga tong asu bok lavapaase poovo ridi xeretna, “Nenia ana tong asu lavapaase poovo rinimi xusu mina xasep at Linintoo at ne Moroa i lok kereva. ");
INSERT INTO mmx_vpl VALUES ("MK4_31","071_4_31","MRK","4","31","31","Linintoo at ne Moroa i lok ngan lara laradi ga lok ka levennit mastet la gatlotlo i ro xataamang teren. Nom levennit i xakalik tinotno ti levenit axap at na lavatbung menemen. ");
INSERT INTO mmx_vpl VALUES ("MK4_32","071_4_32","MRK","4","32","32","Do tara natlotlo i, nom levennit ba suu xat silok, la ba silok polo levenuna axap to xataamang. Lengkakan teren ba silok kusu lavapixa bat kis to xeneng at lamamau ren.” ");
INSERT INTO mmx_vpl VALUES ("MK4_33","071_4_33","MRK","4","33","33","Laxampapaase poovo keretnom ni ga vaase asu i ri limixin axap at nom laaleng. Se diga epovo kusu dinaklen ka levelinga ren, ni ga vaase asu i ridi. ");
INSERT INTO mmx_vpl VALUES ("MK4_34","071_4_34","MRK","4","34","34","Neni ga vavang mi lempapaase poovo xusuk la ni ga tong asu lavasuun at nai ri lavaun pinivu xusuk mene ren. ");
INSERT INTO mmx_vpl VALUES ("MK4_35","071_4_35","MRK","4","35","35","Ap mo laaleng ga ukantinao ne Iesu ga lok ti lavaun pinivu ren keretna, “Ata sen polo lavatdan kis uto at lenep meo.” ");
INSERT INTO mmx_vpl VALUES ("MK4_36","071_4_36","MRK","4","36","36","La lavaun pinivu diga on basinge buaang limixin la diga los kas at lesepang Iesu gat kis teren la diga sen kaxat. Lentaba bok diga sen kaxat mi levesepang atdi. ");
INSERT INTO mmx_vpl VALUES ("MK4_37","071_4_37","MRK","4","37","37","La mo langsangan lamanman ga mas lolos la lavatdan kis ga repit aleng la ladan ga vubeles uto xeneng at lesepang, la ma lixilik lesepang ga lok do na dong si. ");
INSERT INTO mmx_vpl VALUES ("MK4_38","071_4_38","MRK","4","38","38","La ne Iesu gak midi ro melemu at lesepang la ga liingun at lavatliingun. La diga ro aus i la diga lok tin keretna, “Leeme loklox ase. Tila u unga? I auret kusu ata seeve.” ");
INSERT INTO mmx_vpl VALUES ("MK4_39","071_4_39","MRK","4","39","39","La ne Iesu ga xatu kaxat la ga vaase lolos pe lamanman la ga lok ti lavatdan kis keretna, “Unak lok pilo. Una mila.” La lamanman ga xap la lavatdan kis ga mila. ");
INSERT INTO mmx_vpl VALUES ("MK4_40","071_4_40","MRK","4","40","40","La ni ga lok tidi xeretna, “Tila nemi mi marat? Kereva, kopmen tununu atnimi?” ");
INSERT INTO mmx_vpl VALUES ("MK4_41","071_4_41","MRK","4","41","41","La nedi diga sangu aleng la diga epaase xeretna, “Laradi salai na? Lamanman la lavatdan kis dura ronga res at levelinga ren.” ");
INSERT INTO mmx_vpl VALUES ("MK5_1","071_5_1","MRK","5","1","1","La ne Iesu mi lavaun pinivu ren diga rupot to loxon ap mo lavatdan kis to at lenep Gerasa. ");
INSERT INTO mmx_vpl VALUES ("MK5_2","071_5_2","MRK","5","2","2","La ne Iesu ga vas su at lesepang la soso mun lara laradi ga vot pasa i. Neni ga laa boro at lenep at larabuang digak mikmit labarongan to xeneng teren. Lagas ga suxuna nom laradi. ");
INSERT INTO mmx_vpl VALUES ("MK5_3","071_5_3","MRK","5","3","3","Neni ga nemen to ap mo larabuang la limixin at nom lenep di goxo epovo ri xoxo alis i mi lavaroos sen. ");
INSERT INTO mmx_vpl VALUES ("MK5_4","071_5_4","MRK","5","4","4","Gano digak lok tong pen i do dina xoxo alis i mi lavaroos sen. Ketla neni ga ba korop nom lavaroos sen diga lok li i at lukngen la luxangkedek teren. La tara goxo epovo lolos kusu na ranga alis i. ");
INSERT INTO mmx_vpl VALUES ("MK5_5","071_5_5","MRK","5","5","5","At levenaleng axap at levenaleng kangking la at lengkanimin neni gat pas tangtagap to xeneng at larabuang la to at lengkong kaana la ni gap kup silok la ga rivit koxorop labantuxu ren mi lengkonuat. ");
INSERT INTO mmx_vpl VALUES ("MK5_6","071_5_6","MRK","5","6","6","Se ni ga ven ne Iesu ro vaxalom, ni ga sixit pasa i la ga xis tiktikbu mi luvatgulom teren saparap luxangkedek at ne Iesu. ");
INSERT INTO mmx_vpl VALUES ("MK5_7","071_5_7","MRK","5","7","8","La ne Iesu ga lok tin keretna, “Una on basinge na laradi, nenu lagas kapmek.” La nom laradi gap kup silok ti ne Iesu xeretna, “Iesu, Nitna ne Moroa, Leeme Avolo. U rupot de ri lok lavanga sala ria? Una xaape ri ne Moroa dola u noxo sev asongor ia.” ");
INSERT INTO mmx_vpl VALUES ("MK5_9","071_5_9","MRK","5","9","9","La ne Iesu ga sue i, “Nege laasen taram?” Lagas ga vorang i xeretna, “Laasen tarak ne Limixin Buaang, mila nema buaang lubunggas ma suxuna na laradi.” ");
INSERT INTO mmx_vpl VALUES ("MK5_10","071_5_10","MRK","5","10","10","La ni ga sing lolos ne Iesu xusu neni noxo riki xepe di uto at lenep kangka vetpes. ");
INSERT INTO mmx_vpl VALUES ("MK5_11","071_5_11","MRK","5","11","11","Buaang laxanbo mo diga nemen auret, diga anan to at lakaana. ");
INSERT INTO mmx_vpl VALUES ("MK5_12","071_5_12","MRK","5","12","12","La lubunggas diga sing ne Iesu xeretna, “Una riki nama uto ap mo laxanbo la una siam do mana vubeles atdi.” ");
INSERT INTO mmx_vpl VALUES ("MK5_13","071_5_13","MRK","5","13","13","La ne Iesu ga ke aonon di la lubunggas diga sixisu basinge mo laradi la diga vubeles at laxanbo. La mo laxanbo diga sixit kaxat la diga sixisi ukopok at lakaana la diga los tup to at lavatdan kis la laxanbo diga xong axap. Nom laxanbo ga epovo at legepu abin sangsangaun kobot (2000). ");
INSERT INTO mmx_vpl VALUES ("MK5_14","071_5_14","MRK","5","14","14","La nedi diga lok tatao laxanbo diga sixit kaxat uto at lemenemen atdi la diga tong i na lavanga ri limixin me go la to bok at lengkot petpes. La nom limixin diga laa boro at levenmenemen atdi xusu dina ven mo lavanga ne Iesu ga lok pam i. ");
INSERT INTO mmx_vpl VALUES ("MK5_15","071_5_15","MRK","5","15","15","Diga vot pasa ne Iesu la diga ven laradi, laxan gas ga suxuna i gano, mo gat kis, la ga siga lempanga singsiga la lodoxoma ren ga lox avukat axap la nedi limixin diga marat. ");
INSERT INTO mmx_vpl VALUES ("MK5_16","071_5_16","MRK","5","16","16","La mo limixin diga vaase asu nom lavanga ne Iesu ga lox i ri nom laradi mi laxanbo. ");
INSERT INTO mmx_vpl VALUES ("MK5_17","071_5_17","MRK","5","17","17","La nom limixin diga sing lolos ne Iesu dola neni na on basinge mo lenep kangka. ");
INSERT INTO mmx_vpl VALUES ("MK5_18","071_5_18","MRK","5","18","18","La ne Iesu ga los kas at lesepang la mo laradi ga sing ne Iesu xeretna, “I epovo do ana emu minu?” ");
INSERT INTO mmx_vpl VALUES ("MK5_19","071_5_19","MRK","5","19","19","Ketla ne Iesu goxo siam la ga lok tin keretna, “Una onon uto xolonu ram la una tong lavanga salai Leeme Silok i lox i ru, la i lox asuusu lebelen tuntun tu.” ");
INSERT INTO mmx_vpl VALUES ("MK5_20","071_5_20","MRK","5","20","20","La nom laradi ga on basinge ne Iesu la gat pas tangtagap to at lenep silok Sangaun Menemen la ga tong nom lavanga ri limixin axap. La nedi limixin diga sangu aleng ap mo lavanga ne Iesu ga lox i ri nom laradi. ");
INSERT INTO mmx_vpl VALUES ("MK5_21","071_5_21","MRK","5","21","21","La ne Iesu gamlong bok polo ro at lavatdan kis mi lesepang. La buaang limixin diga vot pasa ne Iesu to loxon. ");
INSERT INTO mmx_vpl VALUES ("MK5_22","071_5_22","MRK","5","22","22","Lara laradi ga rupot, neni laradi gomgo at loogu singising, laasen at nom laradi ne Jairas. Ni ga ven ne Iesu la ga xis tiktikbu mi luvatgulom teren saparap luxangkedek at ne Iesu. ");
INSERT INTO mmx_vpl VALUES ("MK5_23","071_5_23","MRK","5","23","23","La ni ga sing lolos ne Iesu xeretna, “Loolik tarak i auret do na met. A vara i dola una vot pasa i la una lok li lukngam teren kusu una lox aroo i la neni noxo met.” ");
INSERT INTO mmx_vpl VALUES ("MK5_24","071_5_24","MRK","5","24","24","La ne Iesu ga emu min. La buaang limixin bok diga emu min la digat pas esi xakape. ");
INSERT INTO mmx_vpl VALUES ("MK5_25","071_5_25","MRK","5","25","25","La lara latkin mo ga nemen. Lanmeres gaaling gak lox amisik teren at levenaleng axap, ga epovo at lasangaun mi legepu maares. ");
INSERT INTO mmx_vpl VALUES ("MK5_26","071_5_26","MRK","5","26","26","Ni gat pot pasa amisik luvuttadi sangsanga ketla diga raba mene i mi levesongsongot la di goxo lok tooro i. Lempilas teren ga xap la mo lanmeres ga sisilok. ");
INSERT INTO mmx_vpl VALUES ("MK5_27","071_5_27","MRK","5","27","27","La ni ga ronga i dola ne Iesu ga lox aroo limixin la neni ga vas mu ne Iesu ro melemu eburu mi limixin la ga rebeng tu at lavanga singsiga ren. ");
INSERT INTO mmx_vpl VALUES ("MK5_28","071_5_28","MRK","5","28","28","Mila ni ga lok do na long tu at lavanga singsiga ren, la ni ba lox avukat ba. ");
INSERT INTO mmx_vpl VALUES ("MK5_29","071_5_29","MRK","5","29","29","La soso mun lanmeres teren ga xap la ni ga suma i do ga lox avukat ta. ");
INSERT INTO mmx_vpl VALUES ("MK5_30","071_5_30","MRK","5","30","30","La soso mun Iesu ga suma i do lolos ga ravasu. La neni ga rem gili la ga sue, “Nege i long tu at lavanga singsiga rak?” ");
INSERT INTO mmx_vpl VALUES ("MK5_31","071_5_31","MRK","5","31","31","La lara at lavaun pinivu ren ga vorang i xeretna, “Buaang limixin dit pas eburu minu. Tila u sue do, ‘Nege i long tu at lavanga singsiga rak’, mila a lok do buaang limixin di long tu at lavanga singsiga ram.” ");
INSERT INTO mmx_vpl VALUES ("MK5_32","071_5_32","MRK","5","32","32","La ne Iesu ga milik tangtagap la ga ven pupuse ti nom lara ga long tu at lavanga singsiga ren. ");
INSERT INTO mmx_vpl VALUES ("MK5_33","071_5_33","MRK","5","33","33","La nom latkin ga umsu mi lanmarat silok, ni ga xasep do lanmeres teren ga xap la ni ga xis tiktikbu mi luvatgulom teren saparap luxangkedek at ne Iesu la ga tong asu lorooro ren tin. ");
INSERT INTO mmx_vpl VALUES ("MK5_34","071_5_34","MRK","5","34","34","Ketla ne Iesu ga lok tin, “Latkin, lununu ram i lox avukar u. Unat pas at lenmila la lanmeres ira xap tinotno nga.” ");
INSERT INTO mmx_vpl VALUES ("MK5_35","071_5_35","MRK","5","35","35","La ne Iesu move ga paase mi nom latkin la lentaba luvuttadi diga rupot pasa ne Jairas, laradi gomgo at loogu singising. La diga lok ti ne Jairas keretna, “Loolik taram ira met pam, la nemen uta lox angtang bok ba laradi loklox ase.” ");
INSERT INTO mmx_vpl VALUES ("MK5_36","071_5_36","MRK","5","36","36","Ketla ne Iesu goxo ronga res at levelinga atdi la ga lok ti laradi gomgo at loogu singising keretna, “Nemen uta marat. Una nunu mun tarak.” ");
INSERT INTO mmx_vpl VALUES ("MK5_37","071_5_37","MRK","5","37","37","La ni goxo ke tara xusu na emu min, kusuk mun ne Pita, ne Jems, du leeton mi ne Jon diga emu min uto at loogu at ne Jairas. ");
INSERT INTO mmx_vpl VALUES ("MK5_38","071_5_38","MRK","5","38","38","La diga rupot to at loogu ren la ne Iesu ga ronga limixin diga velas solo, lentaba digang teng silok, lentaba diga saxaanu aleng. ");
INSERT INTO mmx_vpl VALUES ("MK5_39","071_5_39","MRK","5","39","39","La ne Iesu ga vubeles at nom loogu la ga lok tidi, “Nemen mitang teng. Loolik kopmen na met, neni i unga mene nga.” ");
INSERT INTO mmx_vpl VALUES ("MK5_40","071_5_40","MRK","5","40","40","La diga lok kalise i. La ne Iesu ga riki asu di basinge loogu la ni ga lam ka ne temen mi nenen nom loolik eburu mi lavantun lavaun pinivu ren la diga vubeles uto at loxot loolik gak midi ren. ");
INSERT INTO mmx_vpl VALUES ("MK5_41","071_5_41","MRK","5","41","41","La ni ga ranga axatu i mi lekngen la ga lok tin keretna, “Talita kumi.” Lavasuun teren keretna. Loolik, a tong i ru, una xatu upana. ");
INSERT INTO mmx_vpl VALUES ("MK5_42","071_5_42","MRK","5","42","42","La soso mun mo loolik ga xatu upana la gat pas tangtagap ap mo lenep. Levenmaares teren ga epovo at lasangaun mi legepura. La nedi digak lok go, diga sangu aleng tinotno. ");
INSERT INTO mmx_vpl VALUES ("MK5_43","071_5_43","MRK","5","43","43","La ne Iesu ga tong lolos i ridi dola di noxo tong asu nom lavanga ri teta, la ni ga tong i ri ne temen mi ne nenen loolik dola duna raba i mi lempanga anan. La ne Iesu gat pas tangtagap ti levenmenemen kusu na anasa limixin. ");
INSERT INTO mmx_vpl VALUES ("MK6_1","071_6_1","MRK","6","1","1","La ne Iesu eburu mi lavaun pinivu ren diga vas kaxat basinge mo lemenemen la diga rupot to at lemenemen aulis teren, Nasaret. ");
INSERT INTO mmx_vpl VALUES ("MK6_2","071_6_2","MRK","6","2","2","At laaleng kaala Iesu ga anasa ro at loogu singising la buaang limixin diga ronga i la diga sangu. La diga esue xeretna, “Na laradi ga lok ka na lakleklen solo meva? La neni ga lok ka lodoxoma nunuan meva xusu neni i epovo na lok lempanga sangsangu? ");
INSERT INTO mmx_vpl VALUES ("MK6_3","071_6_3","MRK","6","3","3","Neni laradi gugu gu mene la neni ne nitna ne Maria la neni neton ne Jems, ne Joses, ne Judas, la ne Simon, nedi di nemen de la luvurinen bok di nemen de at na lemenemen.” La kerepmo limixin diga raba rulu ne Iesu. ");
INSERT INTO mmx_vpl VALUES ("MK6_4","071_6_4","MRK","6","4","4","La ne Iesu ga lok tidi xeretna, “Leeme vapaase ali, limixin di lok ngangao ren at lengkot axap, ket to at lemenemen teren, la kantubu at limixin teren la libibinat teren, kopmen dina lok ngangao ren.” ");
INSERT INTO mmx_vpl VALUES ("MK6_5","071_6_5","MRK","6","5","5","La ne Iesu goxo epovo na lok lempanga sangsangu go, ketla neni ga lok li lukngen mavana at lentaba mun kusu na lox aroo di. ");
INSERT INTO mmx_vpl VALUES ("MK6_6","071_6_6","MRK","6","6","6","La neni ga sangu aleng mila di goxo nunu. ");
INSERT INTO mmx_vpl VALUES ("MK6_7","071_6_7","MRK","6","7","7","La ne Iesu ga ro xaka lasangaun mi legepura lavaun pinivu ren la neni ga riki gepgepura di uto at levenmenemen petpes. La neni ga raba di mi lolos kusu dina riki xepe lubunggas basinge limixin. ");
INSERT INTO mmx_vpl VALUES ("MK6_8","071_6_8","MRK","6","8","8","La neni ga vaase pe di xeretna, “Mina lok kaka levengkidak atnimi, ketla nemen mita xip kaka tempanga vetpes bok. Nemen teveluxa, nemen teventat, nemen tevempilas at lempanga lukluxa. ");
INSERT INTO mmx_vpl VALUES ("MK6_9","071_6_9","MRK","6","9","9","Mina siga luvanga vatpas, ketla nemen mita xip kaka tempanga singsiga ri etara xun.” ");
INSERT INTO mmx_vpl VALUES ("MK6_10","071_6_10","MRK","6","10","10","La neni ga lok bok tidi, “Do mina vubeles at tara temenemen miba nemen at legesa gu, se miba on basinge mo lemenemen. ");
INSERT INTO mmx_vpl VALUES ("MK6_11","071_6_11","MRK","6","11","11","Do limixin di noxo siam ka nemi la di noxo ronga levelinga atnimi, mina on basinge mo lemenemen la mina semla xepe lengkakup at lengkangkedek atnimi, i ngan loklok katling tidi xusu ti lox asuusu levenmukmusak at ne Moroa.” ");
INSERT INTO mmx_vpl VALUES ("MK6_12","071_6_12","MRK","6","12","12","La lavaun pinivu ren diga vas kaxat uto at levenmenemen la diga vavang do limixin dina leeng. ");
INSERT INTO mmx_vpl VALUES ("MK6_13","071_6_13","MRK","6","13","13","La diga riki xepe lubunggas basinge limixin la diga so li ladan avukat at limixin mekmeres ngan loklok at lubung mixin me Judaia la diga lox aroo di. ");
INSERT INTO mmx_vpl VALUES ("MK6_14","071_6_14","MRK","6","14","14","La ne Erodes, loorong at lenep silok Galili ga ronga levelinga at lugugu at ne Iesu, mila laasen at ne Iesu ga onon at levengkot axap. Lentaba diga lok do ne Iesu neni ne Jon, laradi sep susu limixin. Diga lok bok dola ne Jon ga roo xat amlong at lanmet, kuren la neni i epovo na lok lempanga sangsangu. ");
INSERT INTO mmx_vpl VALUES ("MK6_15","071_6_15","MRK","6","15","15","Lentaba vetpes diga lok keretna, “Neni ne Elaisa leeme vapaase ali.” Lentaba diga lok keretna, “Neni laradi vapaase ali kerekngan lavaeme vapaase ali megano.” ");
INSERT INTO mmx_vpl VALUES ("MK6_16","071_6_16","MRK","6","16","16","Ketla ne Erodes ga lok keretna, “Neni ne Jon. Nia agara ra korop pam laxaka ren la ni ga roo xat manga.” ");
INSERT INTO mmx_vpl VALUES ("MK6_17","071_6_17","MRK","6","17","17","Leretere at lanmet at ne Jon keretna. Erodes ga tong i ri luvuttadi esep teren ti ranga alis ne Jon la diga xoxo i la diga lok li i ro at loogu xokoxo. Erodes ga lox i na mila latkin teren ne Erodias ga musak ne Jon. ");
INSERT INTO mmx_vpl VALUES ("MK6_18","071_6_18","MRK","6","18","18","Lavasuun at lumukmusak at nom latkin keretna. Ganoxa ne Jon ga vaase sok ne Erodes mila neni ga sak paxat ka ne Erodias, latkin at neton ne Pilip la ga epot teren. ");
INSERT INTO mmx_vpl VALUES ("MK6_19","071_6_19","MRK","6","19","19","Kuren la ne Erodias ga musak ne Jon la ga vara na sev amer i ketla neni goxo epovo, ");
INSERT INTO mmx_vpl VALUES ("MK6_20","071_6_20","MRK","6","20","20","mila ne Erodes ga marat at ne Jon la ga lok tatao i. Erodes gaklen i do ne Jon lagale laradi manmanton la gang tonga levelinga ren. Neni ga rangku mumu i nom levelinga at ne Jon, ketla ni ga lok momo ring tonga i. ");
INSERT INTO mmx_vpl VALUES ("MK6_21","071_6_21","MRK","6","21","21","Ketla ne Erodias ga vuse ka langas ti sev amet ne Jon keretna. At lara laaleng ne Erodes ga lok laanan ti lok katling mo laaleng nenen ga visix i ren. Lavaeme silok at lugugu at ne Erodes mi luvuttadi esep amgomgo ren mi loxongkulao amgomgo bok at lenep Galili digak lok at nom laanan. ");
INSERT INTO mmx_vpl VALUES ("MK6_22","071_6_22","MRK","6","22","22","La lara loono maxat, neni loolik at ne Erodias ga tii, la ne Erodes eburu minedi diga anan diga lok momo ren la ne Erodes ga lok ti nom loono keretna, “Una tong asu lavavara ram ti tavanga la nia aba raba u min.” ");
INSERT INTO mmx_vpl VALUES ("MK6_23","071_6_23","MRK","6","23","23","La neni ga lok lavangpangpe rin keretna, “A paase ruturun at lemeren ne Moroa. Nia aba raba u mi tevempanga u vara i, i epovo at loxonatat at lempanga axap tarak.” ");
INSERT INTO mmx_vpl VALUES ("MK6_24","071_6_24","MRK","6","24","24","La mo loono ga sixisu la ga sue nenen keretna, “Lavanga sala nia ba sing ka i ren?” La ne Erodias ga vorang i xeretna, “Una sing ti lavatlak at ne Jon.” ");
INSERT INTO mmx_vpl VALUES ("MK6_25","071_6_25","MRK","6","25","25","La soso mun nom loono gamlong parap ne Erodes la ga lok, “Una raba ia mi lavatlak at ne Jon laradi sep susu limixin. Una lok li i at tavattingtigon silok.” ");
INSERT INTO mmx_vpl VALUES ("MK6_26","071_6_26","MRK","6","26","26","La ne Erodes ga lok bukbulu aleng mila neni goxopara i do ne Jon na met. Ketla neni goxo epovo xusu ti lox ekun levelinga ren mila nom luvuttadi silok diga ronga vam nom lavangpangpe. ");
INSERT INTO mmx_vpl VALUES ("MK6_27","071_6_27","MRK","6","27","27","La soso mun Erodes ga lox aonon lavapaase ri laradi esep teren do neni na sep korop laxaka at ne Jon la na xip kaka lavatlak teren uto saparav i. La nom laradi ga vas kaxat la ga sep korop laxaka at ne Jon to at loogu xokoxo. ");
INSERT INTO mmx_vpl VALUES ("MK6_28","071_6_28","MRK","6","28","28","La neni ga lok li nom lavatlak to at lavattingtigon silok la ga rupot min la ga raba mo loono min la loono ga raba nenen min. ");
INSERT INTO mmx_vpl VALUES ("MK6_29","071_6_29","MRK","6","29","29","La lavaun pinivu at ne Jon diga ronga i dola ne Jon ga uu la diga rupot la diga lok ka labantuxu ren la digak mir i ro at lubuang mikmit tongan. ");
INSERT INTO mmx_vpl VALUES ("MK6_30","071_6_30","MRK","6","30","30","La luvuttadi vavang at ne Iesu digamlong ta la diga tong asu lempanga axap diga lox i la levelinga diga anasa limixin min. ");
INSERT INTO mmx_vpl VALUES ("MK6_31","071_6_31","MRK","6","31","31","La ne Iesu ga lok tidi xeretna, “Ude nimi, nedik kusuk ata onon uto at lamatbin kusu mina lok mamana lixilik be.” Mila buaang limixin diga rupot pasa amisik ne Iesu mi lavaun pinivu ren la di goxo epovo kusu dina anan. ");
INSERT INTO mmx_vpl VALUES ("MK6_32","071_6_32","MRK","6","32","32","La diga sen kaxat mi lesepang uto at loxot petpes, ua limixin di goxo nemen teren. ");
INSERT INTO mmx_vpl VALUES ("MK6_33","071_6_33","MRK","6","33","33","Ketla buaang limixin diga ven nedi diga sen mi lesepang la diga ven kibis di. Digat pas basinge levenmenemen atdi la diga mumu loxon la diga rupot avot to ap mo loxot ti ne Iesu mi lavaun pinivu ren. ");
INSERT INTO mmx_vpl VALUES ("MK6_34","071_6_34","MRK","6","34","34","La ne Iesu eburu mi lavaun pinivu ren diga oso mi lesepang la ni ga ven buaang limixin solo. Neni ga balamu di mila diga lok ngan laxasipsip kopmen taradi loklok tatao atnedi. Kuren la ni ga anasa di mi laxampapaase solo. ");
INSERT INTO mmx_vpl VALUES ("MK6_35","071_6_35","MRK","6","35","35","Ga ukantinao lavaun pinivu at ne Iesu diga rupot pasa ne Iesu la diga lok tin keretna, “Ukantinao nga na la na loxot, ni loxot mimila rino. ");
INSERT INTO mmx_vpl VALUES ("MK6_36","071_6_36","MRK","6","36","36","Una riki aonon limixin kusu dibat pas uto at levenmenemen la dina un ka tempanga anan tidi.” ");
INSERT INTO mmx_vpl VALUES ("MK6_37","071_6_37","MRK","6","37","37","Ketla ne Iesu ga lok tidi xeretna, “Nemi xa mina raba nedi mi teveluxa xusu dina anan i.” La diga lok tin keretna, “Kereva, u vara i dola manat pas ti un kaka tevengkongkide mi legepu sangaun kobot (200) denarias atdik la mana un panga anan min tidi?” Mo lempilas ga epovo dola tara na gugu at lavanuti gaaling ti lok kaka i nom. ");
INSERT INTO mmx_vpl VALUES ("MK6_38","071_6_38","MRK","6","38","38","La ne Iesu ga lok tidi xeretna, “Minat pas la mina ven lavanisa lengkongkide mo ik lok.” La digaklen ka i la diga lok tin keretna, “Lavalimo lengkongkide la legepu venmat kakalik na.” ");
INSERT INTO mmx_vpl VALUES ("MK6_39","071_6_39","MRK","6","39","39","La ne Iesu ga lok tidi xeretna, “Mina lox axis limixin axap at levenbinam tadi at levennep mi lempivilis avukat teren.” ");
INSERT INTO mmx_vpl VALUES ("MK6_40","071_6_40","MRK","6","40","40","La nedi diga xis kopok ap mo lenep, lepentaba legesa sangaun kobot (100) diga xis eburu, lentaba lavalimo sangaun limixin diga xis eburu, nedi axap digat kis kerepmo. ");
INSERT INTO mmx_vpl VALUES ("MK6_41","071_6_41","MRK","6","41","41","La ne Iesu ga lok kaka levengkongkide mi luemat, la ga milik aurut uto at laxalibet la ga tong avukat ti ne Moroa. Ga sebek nom levengkongkide la ga raba lavaun pinivu ren min la diga raba limixin min. La ni ga raba bok luemat tidi. ");
INSERT INTO mmx_vpl VALUES ("MK6_42","071_6_42","MRK","6","42","42","La limixin axap diga anan la diga an mais. ");
INSERT INTO mmx_vpl VALUES ("MK6_43","071_6_43","MRK","6","43","43","La lavaun pinivu diga luxa lasangaun mi legepura leventat mi leveluxa mo diga an ake i ren. ");
INSERT INTO mmx_vpl VALUES ("MK6_44","071_6_44","MRK","6","44","44","La nedi luvuttadi remes diga anan, diga epovo at lavalimo larabin sangsangaun kobot (5000). ");
INSERT INTO mmx_vpl VALUES ("MK6_45","071_6_45","MRK","6","45","45","La soso mun ne Iesu ga tong i ri lavaun pinivu ren do dina los kas at lesepang la dinamgo rin uto at lemenemen Betsaida. La ne Iesu ga riki aonon limixin. ");
INSERT INTO mmx_vpl VALUES ("MK6_46","071_6_46","MRK","6","46","46","La neni ga vas kaxat basinge di la ga urut uto vana at lakaana xusu na ngising. ");
INSERT INTO mmx_vpl VALUES ("MK6_47","071_6_47","MRK","6","47","47","At laxanimin lesepang at lavaun pinivu gak sixit kantubu at lavatdan kis la ne Iesu xusuk gak lok to loxon. ");
INSERT INTO mmx_vpl VALUES ("MK6_48","071_6_48","MRK","6","48","48","La ne Iesu ga ven di, digatlatla lolos mila lamanman gat mas lolos tangarang di. Kantubu at lavantun konaleng la lavanna konaleng at laxanimin ne Iesu ga vas kaxat to mavana mun at lavatdan kis. La ni ga rupot saparap di la ga doma i do na vas polo di. ");
INSERT INTO mmx_vpl VALUES ("MK6_49","071_6_49","MRK","6","49","49","Ketla at loxonaleng diga ven ne Iesu gat pas to mavana at lavatdan kis, diga lok do neni loroonan panga la digap kup silok, ");
INSERT INTO mmx_vpl VALUES ("MK6_50","071_6_50","MRK","6","50","50","mila diga ven i la diga marat aleng. La soso mun ne Iesu ga lok tidi xeretna, “Nemen gat mita marat. Mina lolos. Nenia mun na.” ");
INSERT INTO mmx_vpl VALUES ("MK6_51","071_6_51","MRK","6","51","51","La neni ga los kas at lesepang la lamanman gara xap matmas ta. La lavaun pinivu ren diga sangu aleng. ");
INSERT INTO mmx_vpl VALUES ("MK6_52","071_6_52","MRK","6","52","52","Levendoxoma atdi ga repe. Di goxoklen lavasuun at lempanga sangsangu ne Iesu ga lox i mi mo lempanga anan. ");
INSERT INTO mmx_vpl VALUES ("MK6_53","071_6_53","MRK","6","53","53","La diga xan polo lavatdan kis la diga oso to at lenep kangka Genesaret. ");
INSERT INTO mmx_vpl VALUES ("MK6_54","071_6_54","MRK","6","54","54","La diga vas su at lesepang, la limixin ap mo loxot diga ven kibis ne Iesu. ");
INSERT INTO mmx_vpl VALUES ("MK6_55","071_6_55","MRK","6","55","55","La digak sixit uto at lengkot axap ap mo lenep la digamlong mi luvuttadi mekmeres, lentaba atdi diga xip di mi levenora uto at lengkot no ne Iesu gat pas ue. ");
INSERT INTO mmx_vpl VALUES ("MK6_56","071_6_56","MRK","6","56","56","La ne Iesu gat pas tangtagap at lengkot axap, levenmenemen kakalik, levenmenemen silok, laxairing bok la diga lok li limixin mekmeres to at lengkot etang. La diga sing ne Iesu do dina long tu at lavanga singsiga ren. La nedi axap diga long tu ren, diga lox avukat axap. ");
INSERT INTO mmx_vpl VALUES ("MK7_1","071_7_1","MRK","7","1","1","Lentaba lubung Parisi mi luvuttadi loklox ase at Laulis Linga diga vot eburu boro Jerusalem la diga vot pasa ne Iesu. ");
INSERT INTO mmx_vpl VALUES ("MK7_2","071_7_2","MRK","7","2","2","La diga ven lentaba at lavaun pinivu at ne Iesu diga anan mi levengkikngen di, ua di goxo gos avot mun be lengkikngen di. La kerepmo lubung Parisi diga lok do lavaun pinivu diga lox abilinga lorooro atdi. ");
INSERT INTO mmx_vpl VALUES ("MK7_3","071_7_3","MRK","7","3","3","Lubung Parisi mi limixin axap me Judaia diga sogos avot be levengkikngen di la melemu diga anan ba, la kerepmo diga mumu asu loklok at lavalabat atdi. ");
INSERT INTO mmx_vpl VALUES ("MK7_4","071_7_4","MRK","7","4","4","Loklok bok at lavalabat atdi xeretna. Se digamlong boro at leetang, kopmen di goxo anan se digak lox adadat avot be di. Leveloklok petpes bok diga mumu asu i xeretna. Diga sogos amisik levengkap inin atdi, leventingtigon, la levesosopen. ");
INSERT INTO mmx_vpl VALUES ("MK7_5","071_7_5","MRK","7","5","5","La lubung Parisi mi luvuttadi loklox ase at Laulis Linga diga sue ne Iesu xeretna, “Ua lavasuun teren la lavaun pinivu ram kopmen dina mumu asu leveloklok at lavalabat atdik, di anan lempanga anan mi levengkikngen di xopmen na dadat?” ");
INSERT INTO mmx_vpl VALUES ("MK7_6","071_7_6","MRK","7","6","6","La ne Iesu ga vorang i ridi xeretna, “Leeme vapaase ali at ne Moroa, ne Aisaia ga paase ali mi nom. Neni ga paase ruturun dola nemi luvuttadi loklok sosolom. Ni ga tong li levelinga xeretna, ‘Na limixin di lok ngangao rak mi levelinga mun atdi, ketla lebelen di i vaxalom tino basinge ia. ");
INSERT INTO mmx_vpl VALUES ("MK7_7","071_7_7","MRK","7","7","7","Dixo lotu saparav ia mi luruturun la di lox ase mi levelinga at limixin mun.’” ");
INSERT INTO mmx_vpl VALUES ("MK7_8","071_7_8","MRK","7","8","8","La ne Iesu ga vaase sok di xeretna, “Mi onon basinge levelinga mumuat at ne Moroa, ketla mim tebeng lolos leveloklok at limixin. ");
INSERT INTO mmx_vpl VALUES ("MK7_9","071_7_9","MRK","7","9","9","Mi gugu lolos ti vuse ka tangas ting tonga xepe levelinga at ne Moroa xusu mina mumu asu leveloklok at lavalabat atnimi. ");
INSERT INTO mmx_vpl VALUES ("MK7_10","071_7_10","MRK","7","10","10","Gano ne Moses ga lok bok keretna, ‘Mina lok ngangao at luvuttemen nimi mi luvutnen nimi. Do tara na paase xapmek ti ne temen kopla nenen, limixin dinaba sev amer i.’ ");
INSERT INTO mmx_vpl VALUES ("MK7_11","071_7_11","MRK","7","11","11","Ketla nemi xopmen mina mumu asu mo levelinga at ne Moses, mi mumu asu na levelinga. Mo do tara i ruuna lempanga do ri lok tooro ne temen kopla nenen, nemi mi tong i rin kusu neni na mumu asu leveloklok at lavalabat la na raba ne Moroa min la na ke loklok tooro ridu. ");
INSERT INTO mmx_vpl VALUES ("MK7_12","071_7_12","MRK","7","12","12","Kuren la mi lok pe i xusu neni ixo epovo na lok tooro lavakpakes at ne temen mi nenen. ");
INSERT INTO mmx_vpl VALUES ("MK7_13","071_7_13","MRK","7","13","13","La kerepmo mi mumu asu loklok miga lok ka i at lavalabat atnimi la mi lox abulubun kepe levelinga at ne Moroa. La nemi mik lox amisik laxampanga xapmek keretnom.” ");
INSERT INTO mmx_vpl VALUES ("MK7_14","071_7_14","MRK","7","14","14","La ne Iesu ga ro xaka limixin uto saparav i la ga lok lavapaase poovo ridi xeretna, “Nemi axap mina ronga na levelinga rak la mina xasep teren. ");
INSERT INTO mmx_vpl VALUES ("MK7_15","071_7_15","MRK","7","15","15","Kopmen tavanga ik lok to maxamang at laradi na lox abilinga i. Ketla levempanga, lorooro ren i lox asuusu i, naba lox abilinga i. ");
INSERT INTO mmx_vpl VALUES ("MK7_16","071_7_16","MRK","7","16","16","Do mi ruuna levenbaalung, mina ronga avukat na levelinga.” ");
INSERT INTO mmx_vpl VALUES ("MK7_17","071_7_17","MRK","7","17","17","La melemu ne Iesu ga on basinge nom limixin la ga vubeles at lara loogu la lavaun pinivu ren diga sue mu i mi mo lavapaase poovo. ");
INSERT INTO mmx_vpl VALUES ("MK7_18","071_7_18","MRK","7","18","18","La ni ga sue di xeretna, “Kereva, kopmen mina xasep avukat teren? Mina ronga avukar i na. Lempanga anan laradi i anan i, noxo lox abilinga i. ");
INSERT INTO mmx_vpl VALUES ("MK7_19","071_7_19","MRK","7","19","19","Nom lempanga noxo vubeles at lorooro ren, ketla i vubeles at leventine ren la melemu neni ba lok kepe ba i ukamang at labantuxu ren.” La kerepmo ne Iesu ga tong i do leveluxa axap i lox avukat kusu laradi na anan i. ");
INSERT INTO mmx_vpl VALUES ("MK7_20","071_7_20","MRK","7","20","20","La ni ga lok bok keretna, “Lentaba lempanga, laradi i lox asuusu i boro xeneng at lorooro ren, nom i epovo na lox abilinga lorooro ren. ");
INSERT INTO mmx_vpl VALUES ("MK7_21","071_7_21","MRK","7","21","21","Mo lempanga xeretna. Levendoxoma kapmek, leveloklok kakapmek maxamang at lixitkis epot, loklok tip kip pilo, loklok tip sev amet tara, loklok ti longka, ");
INSERT INTO mmx_vpl VALUES ("MK7_22","071_7_22","MRK","7","22","22","loklok ti belegaao, leveloklok kakapmek petpes bok, loklok kaxarang, loklok mun mamangan, loklok ngaongao at lempanga at tara vetpes, loklok ti lox asi tara mi levelinga, loklox asilok, la loklok tangtangku. ");
INSERT INTO mmx_vpl VALUES ("MK7_23","071_7_23","MRK","7","23","23","Anaa axap lempanga xapmek i ravasu boro xeneng at lebelen laradi la i lox abilinga i.” ");
INSERT INTO mmx_vpl VALUES ("MK7_24","071_7_24","MRK","7","24","24","La ne Iesu ga vas kaxat basinge mo lemenemen la ga onon uto at lenep kangka saparap lemenemen Taia. La ni ga vubeles at loogu la ga xopara i do tara naklen i dola neni ira rupot pam. Ketla neni goxo epovo xusu ti nemen lipe. ");
INSERT INTO mmx_vpl VALUES ("MK7_25","071_7_25","MRK","7","25","25","La lara latkin ga ronga levelinga dola ne Iesu ga rupot la soso mun neni ga vot pasa i la ga xis tiktikbu mi luvatgulom teren saparap luxangkedek at ne Iesu. Lagas ga suxuna loolik at nom latkin. ");
INSERT INTO mmx_vpl VALUES ("MK7_26","071_7_26","MRK","7","26","26","Mo latkin, neni me Grik ketla diga visix i ro at lenep Siroponisia. La neni ga sing ne Iesu dola neni na riki kepe lagas basinge loolik teren. ");
INSERT INTO mmx_vpl VALUES ("MK7_27","071_7_27","MRK","7","27","27","La ne Iesu ga tong lavapaase poovo rin keretna, “Nia ana raba panga anan avot mun be ri laxamdak mi laxaalik mila kopmen nak mokso ri lu raba lubungman mi lempanga anan at laxamdak.” ");
INSERT INTO mmx_vpl VALUES ("MK7_28","071_7_28","MRK","7","28","28","La nom latkin ga lok ti ne Iesu xeretna, “I ruturun pam, Leeme Silok. Ketla lubungman di anan levenmumus panga anan im subu uto maxopok at loxot anan at laxamdak mi laxaalik.” ");
INSERT INTO mmx_vpl VALUES ("MK7_29","071_7_29","MRK","7","29","29","La ne Iesu ga lok tin, “Lavapaase ram i nunuan, kuren la nenia ara lok kepe vam lagas basinge loolik taram. Unamlong ta uto at loogu ram.” ");
INSERT INTO mmx_vpl VALUES ("MK7_30","071_7_30","MRK","7","30","30","La nom latkin gamlong uto xolonu ren la ga vot pasa loolik teren gak midi at loora ren la lagas ga on basinge vam i. ");
INSERT INTO mmx_vpl VALUES ("MK7_31","071_7_31","MRK","7","31","31","La melemu ne Iesu ga vas kaxat basinge lenep kangka Taia, la ga vas polo lenep kangka Sidon uto at lavatdan kis Galili, la ga vubeles at lenep kangka Sangaun Menemen. ");
INSERT INTO mmx_vpl VALUES ("MK7_32","071_7_32","MRK","7","32","32","La lentaba luvuttadi diga lam kaka laradi lubaalung teren ga ba uto saparap ne Iesu. Neni xopmen goxo paase avukat, la diga sing ne Iesu xusu na lok li lekngen teren la na lox avukar i. ");
INSERT INTO mmx_vpl VALUES ("MK7_33","071_7_33","MRK","7","33","33","La ne Iesu ga lam ka i la nedu xusuk duga vas basinge nom limixin la ne Iesu ga lok li lusivisip teren at lubaalung at nom laradi la ga xalaubis, la ga long tu at lagam teren, ");
INSERT INTO mmx_vpl VALUES ("MK7_34","071_7_34","MRK","7","34","34","la ga mas asu lamamas teren la ga lok tin keretna, “Epata.” Lavasuun teren keretna, una rem suang. ");
INSERT INTO mmx_vpl VALUES ("MK7_35","071_7_35","MRK","7","35","35","La lubaalung ap mo laradi ga xasep ba. La mo lavanga ga lok pe lagam teren ga repes la neni ga vaase alabat ba. ");
INSERT INTO mmx_vpl VALUES ("MK7_36","071_7_36","MRK","7","36","36","La ne Iesu ga tong alolos i ridi dola di noxo tong asu nom lavanga ri teta ketla di goxo ronga res teren, diga vaase asu i ri limixin axap. Amisik ne Iesu gap sep pepe limixin kerepmo, ketla amisik limixin diga tong asu lempanga sangsangu ne Iesu ga lox i. ");
INSERT INTO mmx_vpl VALUES ("MK7_37","071_7_37","MRK","7","37","37","La nom limixin diga sangu aleng la diga lok keretna, “Lempanga axap ne Iesu ik lox i, i nunuan aleng. Ni i lox axasep levenbaalung at luvuttadi ba la i lox aroo luvuttadi kopmen dina paase.” ");
INSERT INTO mmx_vpl VALUES ("MK8_1","071_8_1","MRK","8","1","1","Ap mo levenaleng, buaang limixin diga vot eburu saparap ne Iesu la goxopmen tempanga anan atdi. La ne Iesu ga ro kaka lavaun pinivu ren la ga lok tidi xeretna, ");
INSERT INTO mmx_vpl VALUES ("MK8_2","071_8_2","MRK","8","2","2","“Nenia a balamu na limixin atla digak lok saparav ia at lavantun aleng ta la kopmen tempanga anan atdi. ");
INSERT INTO mmx_vpl VALUES ("MK8_3","071_8_3","MRK","8","3","3","Do ana riki aonon di uto at laramenemen atdi, tentaba diba meroxon to at langa e mi lantoxo atla lentaba diga rupot boro vaxalom.” ");
INSERT INTO mmx_vpl VALUES ("MK8_4","071_8_4","MRK","8","4","4","La lavaun pinivu diga lok tin keretna, “Kopmen tempanga anan nade at na lenep gamasa, ataba lok ka tempanga anan ua ridi?” ");
INSERT INTO mmx_vpl VALUES ("MK8_5","071_8_5","MRK","8","5","5","La ne Iesu ga sue di, “Lavanisa lengkongkide mi ruuna i?” Diga vorang i, “Lavanuti na lengkongkide.” ");
INSERT INTO mmx_vpl VALUES ("MK8_6","071_8_6","MRK","8","6","6","La ne Iesu ga tong i ri mo limixin do dina xis kopok at laxangka la neni ga lok ka mo lengkongkide, ga tong avukat ti ne Moroa la ga sebex i. Ni ga raba lavaun pinivu min kusu dina raba mo limixin min, la diga lox i xuren. ");
INSERT INTO mmx_vpl VALUES ("MK8_7","071_8_7","MRK","8","7","7","Lavaun pinivu diga ruuna bok lutpen mat lixilik. Iesu ga lok ka i la ga tong avukat ti ne Moroa la ga tong i ri lavaun pinivu do dina raba limixin min. ");
INSERT INTO mmx_vpl VALUES ("MK8_8","071_8_8","MRK","8","8","8","La limixin diga anan la nedi axap diga an mais. La lavaun pinivu diga lok ka lavanuti leventat silok la diga suxa aumsu di mi lempanga anan limixin diga an ake ren. ");
INSERT INTO mmx_vpl VALUES ("MK8_9","071_8_9","MRK","8","9","9","La mo luvuttadi remes ga epovo at lavanuet larabin sangsangaun kobot (4000), la ne Iesu ga riki aonon di. ");
INSERT INTO mmx_vpl VALUES ("MK8_10","071_8_10","MRK","8","10","10","La soso mun ne Iesu mi lavaun pinivu ren diga los kas at lesepang la diga sen kaxat uto at lenep kangka Dalmanuta. ");
INSERT INTO mmx_vpl VALUES ("MK8_11","071_8_11","MRK","8","11","11","La lubung Parisi diga vot pasa ne Iesu la diga etep mi levelinga. Diga vara i dola ne Iesu na lok tempanga sangsangu ngan loklok katling boro vana at laxalibet ti lox asu ba i dola ne Moroa ga riki i. ");
INSERT INTO mmx_vpl VALUES ("MK8_12","071_8_12","MRK","8","12","12","La ne Iesu ga lok bukbulu la ga lok tidi xeretna, “Ua lavasuun teren la limixin at na loola di vara lavanga sangsangu? Nenia a noxo lox ase nimi mi tempanga sangsangu.” ");
INSERT INTO mmx_vpl VALUES ("MK8_13","071_8_13","MRK","8","13","13","La ne Iesu mi lavaun pinivu ren diga on basinge di la diga los kas manga at lesepang la diga sen polo lavatdan kis. ");
INSERT INTO mmx_vpl VALUES ("MK8_14","071_8_14","MRK","8","14","14","La lavaun pinivu diga domampe lempanga anan atdi, ketla legeso xongkide mene mo gak lok tidi xeneng at lesepang. ");
INSERT INTO mmx_vpl VALUES ("MK8_15","071_8_15","MRK","8","15","15","La ne Iesu ga lok tidi xeretna, “Mina lok tatao avukat nimi basinge liis (yeast) at lubung Parisi mi ne Erodes.” ");
INSERT INTO mmx_vpl VALUES ("MK8_16","071_8_16","MRK","8","16","16","La lavaun pinivu diga epaase kantubu atdi xeretna, “I vaase mo levelinga mila nedik kopmen ata lok ka tengkongkide.” ");
INSERT INTO mmx_vpl VALUES ("MK8_17","071_8_17","MRK","8","17","17","La ne Iesu ga xasep at levelinga atdi la ga lok tidi xeretna, “Move mi paase mumu lengkongkide, mixoklen lavasuun at levelinga rak. Levendoxoma atnimi ira rebonot pam. ");
INSERT INTO mmx_vpl VALUES ("MK8_18","071_8_18","MRK","8","18","18","Miga ven pam lugugu rak la miga ronga vam levelinga rak, ketla mixoklen lavasuun teren. Mina domangke at levempanga sangsangu rak. ");
INSERT INTO mmx_vpl VALUES ("MK8_19","071_8_19","MRK","8","19","19","Nenia aga raba buaang limixin ga epovo at lavalimo larabin sangsangaun kobot (5000) mi lavalimo lengkongkide. Melemu lavanisa leventat miga suxa i mi levengkonatat panga anan?” La diga vorang i, “Sangaun mi legepura axap.” ");
INSERT INTO mmx_vpl VALUES ("MK8_20","071_8_20","MRK","8","20","20","La neni ga sue bok di, “Nenia aga raba buaang limixin ga epovo at lavanuet larabin sangsangaun kobot (4000) mi lavanuti xongkide la melemu lavanisa leventat silok miga suxa i mi levenmumus panga anan?” La diga lok, “Lavanuti axap.” ");
INSERT INTO mmx_vpl VALUES ("MK8_21","071_8_21","MRK","8","21","21","La neni ga lok tidi, “Kereva, nemi move mixo xasep at levelinga rak?” ");
INSERT INTO mmx_vpl VALUES ("MK8_22","071_8_22","MRK","8","22","22","La ne Iesu mi lavaun pinivu ren diga rupot to at lemenemen Betsaida. La limixin meve diga lam ka lara laradi luxatli ren ga main uto saparap ne Iesu, la diga sing i xusu neni na long tu ren kusu na lox avukar i. ");
INSERT INTO mmx_vpl VALUES ("MK8_23","071_8_23","MRK","8","23","23","La ne Iesu ga rebeng tu at lekngen la ga lam ka i ukamang basinge nom lemenemen. La ni ga xalaubis luxatli ren, la ga lok li lukngen teren la ga sue i xeretna, “U ven tempanga?” ");
INSERT INTO mmx_vpl VALUES ("MK8_24","071_8_24","MRK","8","24","24","La nom laradi ga milik urut la ga lok keretna, “A ven luvuttadi, ketla a ven di ngan larauna dit pas.” ");
INSERT INTO mmx_vpl VALUES ("MK8_25","071_8_25","MRK","8","25","25","La ne Iesu ga lok li amu lukngen at luxatli ap mo laradi. La ni ga milik lolos la luxatli ren ga lox avukat la ga ven axasep ba. ");
INSERT INTO mmx_vpl VALUES ("MK8_26","071_8_26","MRK","8","26","26","La ne Iesu ga riki aonon i uto at loogu ren la ga lok tin, “Nemen uta vubeles at na lemenemen.” ");
INSERT INTO mmx_vpl VALUES ("MK8_27","071_8_27","MRK","8","27","27","La ne Iesu eburu mi lavaun pinivu ren diga vas kaxat uto at levenmenemen at lenep kangka Sisaria Pilipai. To at langa neni ga sue di xeretna, “Limixin di lok do nenia nege?” ");
INSERT INTO mmx_vpl VALUES ("MK8_28","071_8_28","MRK","8","28","28","La diga vorang i xeretna, “Lentaba di lok do nenu ne Jon laradi sep susu. Lentaba di lok do nenu ne Elaisa. Lentaba di lok do nenu lara leeme vapaase ali megano.” ");
INSERT INTO mmx_vpl VALUES ("MK8_29","071_8_29","MRK","8","29","29","La ni ga lok tidi, “Kereva ba nimi? Nemi mi lok do nenia nege?” La ne Pita ga vorang i xeretna, “Nenu Lanarong at ne Moroa.” ");
INSERT INTO mmx_vpl VALUES ("MK8_30","071_8_30","MRK","8","30","30","La ne Iesu ga vaase lolos tidi dola di noxo tong asu i na ri teta. ");
INSERT INTO mmx_vpl VALUES ("MK8_31","071_8_31","MRK","8","31","31","Melemu ne Iesu ga ru xaka levelinga ren keretna, “Nenia, Laradi Mevana, anaba xip levesongsongot silok. La loxongkulao silok at limixin me Judaia, lavamaasa silok, luvuttadi loklox ase at Laulis Linga dinaba sok tixirixes kepe ia la dinaba sep amer ia la melemu at lavantun aleng nenia anaba roo xat amlong.” ");
INSERT INTO mmx_vpl VALUES ("MK8_32","071_8_32","MRK","8","32","32","La ne Iesu ga vaase axasep nom lavanga ridi la ne Pita ga lam kaka ne Iesu basinge lavaun pinivu la ga vaase sok ne Iesu. ");
INSERT INTO mmx_vpl VALUES ("MK8_33","071_8_33","MRK","8","33","33","La ne Iesu ga ru pukus la ga ven ti lavaun pinivu ren la ga vaase sok ne Pita. Neni ga lok keretna, “Satan, uto basinge ia. U xopara na mu asu lodoxoma at ne Moroa, ketla u vara mun levendoxoma at limixin.” ");
INSERT INTO mmx_vpl VALUES ("MK8_34","071_8_34","MRK","8","34","34","La ni ga ro xaka limixin mi lavaun pinivu ren la ga lok tidi, “Mo do tara i vara na emu eburu minia, neni na domampe lorooro axap teren la na gagas li i xusu nap kip losongsongot at levenaleng axap la na mumu asu ba ia. ");
INSERT INTO mmx_vpl VALUES ("MK8_35","071_8_35","MRK","8","35","35","Do nege i vara na ranga alis lorooro ren, neni naba sang apkav i. Ket do nege i soxope lorooro ren ti mumu asu ia la ti tong asu Lagale Lavavang, neni naba lok kaka lorooro avolo. ");
INSERT INTO mmx_vpl VALUES ("MK8_36","071_8_36","MRK","8","36","36","I lok kapmek do taradi na ruuna ka lempanga axap at na lavatbung menemen, la neni i subu basinge lorooro at ne Moroa. ");
INSERT INTO mmx_vpl VALUES ("MK8_37","071_8_37","MRK","8","37","37","Laradi xopmen na epovo na un ka lorooro avolo. ");
INSERT INTO mmx_vpl VALUES ("MK8_38","071_8_38","MRK","8","38","38","Mo do taradi na lok mamangan kepe ia eburu mi levelinga rak kantubu at limixin at na loola, nenia, Laradi Mevana, anaba sok tixirixes i ap mo laaleng nenia ana si ukopok mi lisisixam silok at ne Tamak la at lubungangelo ren.” ");
INSERT INTO mmx_vpl VALUES ("MK9_1","071_9_1","MRK","9","1","1","La ne Iesu ga lok tidi xeretna, “Nenia a tong tuturun i rinemi, lentaba di tu de, di noxo met avot ti lovotpot at laaleng Linintoo at ne Moroa na vot mi lolos teren.” ");
INSERT INTO mmx_vpl VALUES ("MK9_2","071_9_2","MRK","9","2","2","La melemu at lavanna levenaleng ne Iesu ga lam kaka ne Pita, ne Jems, la ne Jon la diga urut uto vana at lavatkaana silok, nedi lavanuet mun digat pas. Ap mo loxot ne Moroa ga lox arepukus ne Iesu to melamgo at lavaun pinivu ren, ");
INSERT INTO mmx_vpl VALUES ("MK9_3","071_9_3","MRK","9","3","3","la lempanga singsiga ren gan bun tinotno. Limixin mede at lavatbung menemen kopmen na epovo ri lox abunbun tempanga singsiga xerepmo. ");
INSERT INTO mmx_vpl VALUES ("MK9_4","071_9_4","MRK","9","4","4","La soso mun ne Elaisa mi ne Moses duga rupot to melamgo atdi la duga epaase eburu mi ne Iesu. ");
INSERT INTO mmx_vpl VALUES ("MK9_5","071_9_5","MRK","9","5","5","La ne Pita ga lok ti ne Iesu xeretna, “Rabai, i lox avukat tinotno do mak lok de. Mana lok tavantun taraogu xukuxut, tara ru, tara ri ne Moses la tara ri ne Elaisa.” ");
INSERT INTO mmx_vpl VALUES ("MK9_6","071_9_6","MRK","9","6","6","Mo levelinga at ne Pita goxo sixit avukat mila neni la ne Jems la ne Jon diga marat aleng. ");
INSERT INTO mmx_vpl VALUES ("MK9_7","071_9_7","MRK","9","7","7","La lusugao ga ravasi la ga vung pavaa di la diga ronga laxaka boro at lusugao ga lok keretna, “Neni na ne nuruk, nenia a balamu i. Mina mumu asu levelinga ren.” ");
INSERT INTO mmx_vpl VALUES ("MK9_8","071_9_8","MRK","9","8","8","La soso mun diga ven ekula midi la di goxo ven ta ne Moses mi ne Elaisa, nedi mene nga lavantun diga nemen mi ne Iesu. ");
INSERT INTO mmx_vpl VALUES ("MK9_9","071_9_9","MRK","9","9","9","La diga si ukopok at lavatkaana la ne Iesu ga sep pepe di do di noxo tong asu na lavanga ri teta se at laaleng Laradi Mevana naba roo xat amlong. ");
INSERT INTO mmx_vpl VALUES ("MK9_10","071_9_10","MRK","9","10","10","La di goxo tong asu i nom, ketla diga esue amisik mi ua lavasuun at levelinga at lorooro amlong. ");
INSERT INTO mmx_vpl VALUES ("MK9_11","071_9_11","MRK","9","11","11","La diga sue ne Iesu xeretna, “Ua lavasuun teren la luvuttadi loklox ase at Laulis Linga di tong i dola ne Elaisa naba rupot avot ti Lanarong?” ");
INSERT INTO mmx_vpl VALUES ("MK9_12","071_9_12","MRK","9","12","12","La ne Iesu ga vorang i ridi xeretna, “I ruturun, levelinga at ne Moroa i tong i do ne Elaisa naba rupot avot tin la na lox amokso amlong lempanga axap. Ketla mina doma na levelinga ik lok at Lovoang Kaala, i lok dola Laradi Mevana naba xip laxasongsongot la limixin dinaba sok tixirixes i. ");
INSERT INTO mmx_vpl VALUES ("MK9_13","071_9_13","MRK","9","13","13","Ketla a tong i rinemi, Elaisa ga rupot pam. Ketla limixin diga lok lempanga xapmek tin, kerekngan diga vara i, la Lovoang Kaala i tong asu i na.” ");
INSERT INTO mmx_vpl VALUES ("MK9_14","071_9_14","MRK","9","14","14","La ne Iesu eburu minedi lavantun diga si la diga vot pasa lavaun pinivu la diga ven buaang limixin diga tu kangkan di mi luvuttadi loklox ase at Laulis Linga diga vetep mi levelinga eburu minedi. ");
INSERT INTO mmx_vpl VALUES ("MK9_15","071_9_15","MRK","9","15","15","La soso mun nom limixin axap diga ven ne Iesu la diga sangu aleng la digak sixit la diga seega rangarang i. ");
INSERT INTO mmx_vpl VALUES ("MK9_16","071_9_16","MRK","9","16","16","La ne Iesu ga sue di, “Mi epaase mu lavanga salai?” ");
INSERT INTO mmx_vpl VALUES ("MK9_17","071_9_17","MRK","9","17","17","La lara laradi xantubu at nom limixin ga vorang i rin keretna, “Leeme loklox ase, ma paase mumu ne nuruk. Nia a lok do ana lam kaka i saparav u atla lagas i suxuna i la nuruk kopmen na paase. ");
INSERT INTO mmx_vpl VALUES ("MK9_18","071_9_18","MRK","9","18","18","I se mo lagas ip sev i, neni i sasava gamasa labantuxu ren at laxangka la lemeseng ip tavasu at lungusno, i rungur igisa, la labantuxu ren i tu todoslo. La a sing lavaun pinivu ram dola dina riki xepe lagas basinge i, ketla dixo epovo.” ");
INSERT INTO mmx_vpl VALUES ("MK9_19","071_9_19","MRK","9","19","19","La ne Iesu ga ronga nom levelinga la ni ga tong i ridi xeretna, “Nemi limixin at na levenaleng, kopmen tununu atnemi. Lavanisa aleng tinotno nenia aba xip tutu minemi? Nemi mi lox amolo ia. Mina lam ka lamdak ude.” ");
INSERT INTO mmx_vpl VALUES ("MK9_20","071_9_20","MRK","9","20","20","La diga lam ka nom lamdak saparap ne Iesu. At loxonaleng lagas ga ven ne Iesu, soso mun lagas ga lox adede nom lamdak la nom lamdak ga subu ukopok at laxangka la gap kuvun la lemeseng ga ravasu at lungusno ren. ");
INSERT INTO mmx_vpl VALUES ("MK9_21","071_9_21","MRK","9","21","21","La ne Iesu ga sue ne temen keretna, “Lavanisa maares ni gak lok keretna?” La ne temen ga vorang i, “Ga lamdak lixilik axa i min. ");
INSERT INTO mmx_vpl VALUES ("MK9_22","071_9_22","MRK","9","22","22","Amisik axa lagas i soso aruv i at laxao la at laradan la ik lok dola nap sev amer i. Dola u epovo, una balamu nama la una lok tooro nama.” ");
INSERT INTO mmx_vpl VALUES ("MK9_23","071_9_23","MRK","9","23","23","La ne Iesu ga lok tin, “Nemen uta vaase mi na levelinga dola u epovo xeretnom. Moroa naba lok lempanga axap tu, mo do u nunu ren.” ");
INSERT INTO mmx_vpl VALUES ("MK9_24","071_9_24","MRK","9","24","24","La soso mun temen mo lamdak ga xup keretna, “A nunu ram, ketla lununu rak ixo epovo, una lok tooro lununu rak.” ");
INSERT INTO mmx_vpl VALUES ("MK9_25","071_9_25","MRK","9","25","25","La ne Iesu ga ven i dola buaang limixin digak sixit pot, la ni ga vaase lolos ti nom lagas keretna, “Nenu lagas, ugak lox angtangku na lamdak la uga lox aba i. Nia a tong i ru, una ravasu basinge na lamdak la nemen bok ba utamlong mu i.” ");
INSERT INTO mmx_vpl VALUES ("MK9_26","071_9_26","MRK","9","26","26","La mo lagas ga xup silok la ga lox adede lamdak la ga sixisu basinge i. La lamdak ga lok ngan ta do ga met la buaang limixin diga lok do ira met pam. ");
INSERT INTO mmx_vpl VALUES ("MK9_27","071_9_27","MRK","9","27","27","Ketla ne Iesu ga ranga ka lekngen la ga rebeng axatu i, la lamdak ga xatu upana. ");
INSERT INTO mmx_vpl VALUES ("MK9_28","071_9_28","MRK","9","28","28","La melemu Iesu mi lavaun pinivu diga vubeles at loogu la nedi xusuk digak lok to xeneng. La nedi diga sue i xeretna, “Ua lavasuun teren la nema maxo epovo xusu mana riki kepe mo lagas?” ");
INSERT INTO mmx_vpl VALUES ("MK9_29","071_9_29","MRK","9","29","29","La ni ga lok tidi, “Lisingising kusuk mene impana ri riki xepe lagas kapmek keretnom.” ");
INSERT INTO mmx_vpl VALUES ("MK9_30","071_9_30","MRK","9","30","30","Iesu eburu mi lavaun pinivu ren diga vas kaxat basinge mo lenep la digat pas polo lenep silok Galili. La neni goxopara i xusu tara naklen i do neni ua, ");
INSERT INTO mmx_vpl VALUES ("MK9_31","071_9_31","MRK","9","31","31","mila neni ga anasa lavaun pinivu ren. La neni ga lok tidi xeretna, “Nenia Laradi Mevana la lara laradi naba song araba ia ri limixin kakapmek kusu dinaba sev amer ia. La melemu at lavantun aleng anaba roo xat amlong.” ");
INSERT INTO mmx_vpl VALUES ("MK9_32","071_9_32","MRK","9","32","32","Ketla lavaun pinivu ren di goxo xasep at levelinga ren la diga mangan kusu dina sue i mi lavasuun teren. ");
INSERT INTO mmx_vpl VALUES ("MK9_33","071_9_33","MRK","9","33","33","La ne Iesu eburu mi lavaun pinivu ren diga rupot to Kaprenaum la diga vubeles at loogu la ne Iesu ga sue di, “To at langa mi epaase mi la?” ");
INSERT INTO mmx_vpl VALUES ("MK9_34","071_9_34","MRK","9","34","34","Ketla digoxo vorang i mila diga epaase xantubu atdi do, nege lara i silok atdi. ");
INSERT INTO mmx_vpl VALUES ("MK9_35","071_9_35","MRK","9","35","35","La ni ga xis kopok, la ga ro ka di lasangaun mi legepura lavaun pinivu ren la ga lok tidi xeretna, “Dola tara i vara i xusu neni na silok, neni ba mumu pit la na lok ngan lasaxaruki at limixin axap.” ");
INSERT INTO mmx_vpl VALUES ("MK9_36","071_9_36","MRK","9","36","36","La neni ga lam ka lara lamdak kakalik, la ga vaxaru i kantubu atdi, la ga ot kongkodan ka i la ga lok tidi xeretna, ");
INSERT INTO mmx_vpl VALUES ("MK9_37","071_9_37","MRK","9","37","37","“Do nege i seega rangarang tamdak keretna at laasen tarak, i lok ngan ta do neni i seega rangarang ia. La do nege i seega rangarang ia, i lok ngan ta do i seega rangarang mo lara ga riki ia ude.” ");
INSERT INTO mmx_vpl VALUES ("MK9_38","071_9_38","MRK","9","38","38","La ne Jon ga lok tin, “Leeme loklox ase, nema maga ven laradi ga riki xepe lubunggas basinge limixin mi laasen taram. La neni kopmen na mumu asu nedik, la kerepmo nema maga sep pepe i.” ");
INSERT INTO mmx_vpl VALUES ("MK9_39","071_9_39","MRK","9","39","39","La ne Iesu ga lok tin, “Nemen mi guta sep pepe i. Do tara taradi i lok tavanga sangsangu mi laasen tarak, neni noxompana ti paase xapmek soso mumu ia. ");
INSERT INTO mmx_vpl VALUES ("MK9_40","071_9_40","MRK","9","40","40","Do taradi i ru ebelen minedik, neni lentangas atdik. ");
INSERT INTO mmx_vpl VALUES ("MK9_41","071_9_41","MRK","9","41","41","Nia a tong tuturun i rinimi. Do tara na raba nimi mi toxodan ti inin mila nemi at ne Karisito, neni noxo sang apkap luunun teren.” ");
INSERT INTO mmx_vpl VALUES ("MK9_42","071_9_42","MRK","9","42","42","La ne Iesu ga lok ti lavaun pinivu ren keretna, “Naba lok kapmek ti tara do na lox asubu tara atdi na laxamdak kakalik di nunu rak. Naba lox avukat tin do dina xoxo li tangsangan tuuat to at laxaka ren la dina dong asi i min uto xopok at lisimaramain. ");
INSERT INTO mmx_vpl VALUES ("MK9_43","071_9_43","MRK","9","43","43","Mo do lakngam na lox asubu lununu ram, una ra korop pes i. I lox avukat do una beles at lorooro avolo mi legesakngam mene nga. Lavanga ne Moroa na lu arup minu eburu mi lukngam uto at laxao at lemenemen songsongot, mo laxao i nemen amisik. ");
INSERT INTO mmx_vpl VALUES ("MK9_44","071_9_44","MRK","9","44","44","Ap mo lenep leven got naba nemen amisik at labantuxu la noxo remet la laxao bok noxo xap. ");
INSERT INTO mmx_vpl VALUES ("MK9_45","071_9_45","MRK","9","45","45","Mo do laxangkedek taram na lox asubu lununu ram, una ra korop pes i. I lox avukat do una beles at lorooro avolo mi legesa xangkedek mene nga. Lavanga ne Moroa na lu arup minu eburu mi luxangkedek taram uto xeneng at lemenemen songsongot. ");
INSERT INTO mmx_vpl VALUES ("MK9_46","071_9_46","MRK","9","46","46","Ap mo lenep leven got naba nemen amisik at labantuxu la noxo remet la laxao bok noxo xap. ");
INSERT INTO mmx_vpl VALUES ("MK9_47","071_9_47","MRK","9","47","47","Mo do legesa xatli ram na lox asubu lununu ram, una lik gogo su min la una lu xepe min. I lox avukat una vubeles to at Linintoo at ne Moroa mi legesa xatli mene nga. Lavanga ne Moroa na lu arup minu eburu mi luxatli ram uto xeneng at lemenemen songsongot. ");
INSERT INTO mmx_vpl VALUES ("MK9_48","071_9_48","MRK","9","48","48","‘Ap mo lenep leven got naba nemen amisik at labantuxu la noxo remet la laxao bok noxo xap.’” ");
INSERT INTO mmx_vpl VALUES ("MK9_49","071_9_49","MRK","9","49","49","La ne Iesu ga lok lavapaase poovo ridi xeretna, “Limixin axap dinaba suma losongsongot ti lox alolos lununu atdi. I lok ngan laxakures di lok li i xusu leveluxa na so avukat. ");
INSERT INTO mmx_vpl VALUES ("MK9_50","071_9_50","MRK","9","50","50","Laxakures neni lavanga avukat. Ket do lolos teren na xap, kopmen bok ba tangas kusu diba lox i la na so xakures manga. Kuren la lorooro atnimi na umsu mi leven gugu nunuan kusu minaba tu buru at limila.” ");
INSERT INTO mmx_vpl VALUES ("MK10_1","071_10_1","MRK","10","1","1","La ne Iesu mi lavaun pinivu ren diga on basinge nom lemenemen la digat pas uto at lenep silok Judaia la diga vas korop ladan sen Joridan. La buaang limixin diga vot pasa manga i la ni ga anasa di ngan loklok teren. ");
INSERT INTO mmx_vpl VALUES ("MK10_2","071_10_2","MRK","10","2","2","La lentaba lubung Parisi diga rupot la diga lok tong pen i mi lususue xeretna, “Kereva, Laulis Linga atdik i mulus bok kusu tara na soxope latkin teren?” ");
INSERT INTO mmx_vpl VALUES ("MK10_3","071_10_3","MRK","10","3","3","La ne Iesu ga vorang i ridi mi lususue xeretna, “Mo lavapaase at ne Moses ga paase xereva at lababa korop epot?” ");
INSERT INTO mmx_vpl VALUES ("MK10_4","071_10_4","MRK","10","4","4","La diga vorang i xeretna, “Moses ga raba nama mi levelinga do tara na malagan tevelinga axasep ti latkin teren do neni mo i xopara na epot ta ren la na riki xepe i.” ");
INSERT INTO mmx_vpl VALUES ("MK10_5","071_10_5","MRK","10","5","5","La ne Iesu ga lok tidi xeretna, “Moses ga raba nimi mi nom, mila lebelen at lavalabat atnimi ga metarauat. ");
INSERT INTO mmx_vpl VALUES ("MK10_6","071_10_6","MRK","10","6","6","Ketla ganoxa at lurutu kaxat Moroa ga rudum lavatlok la lavakin, ");
INSERT INTO mmx_vpl VALUES ("MK10_7","071_10_7","MRK","10","7","7","la ne Moroa ga lok keretna, ‘Lavasuun mun at nai la laradi remes naba on basinge ne temen mi nenen la nak lok eburu mi latkin teren. ");
INSERT INTO mmx_vpl VALUES ("MK10_8","071_10_8","MRK","10","8","8","La nedu dunak lok eburu ngan mun legesara keneng at labantuxu atdu, la du noxo lok ngan bok ba legepura, ketla legesara mun.’ ");
INSERT INTO mmx_vpl VALUES ("MK10_9","071_10_9","MRK","10","9","9","Kuren la tara noxo ba korop leepot at leremes mi latkin teren, mila ne Moroa axa ga ven etang du.” ");
INSERT INTO mmx_vpl VALUES ("MK10_10","071_10_10","MRK","10","10","10","Melemu ne Iesu mi lavaun pinivu ren digak lok to at loogu, la diga sue i mi mo levelinga ren at loklok at leepot. ");
INSERT INTO mmx_vpl VALUES ("MK10_11","071_10_11","MRK","10","11","11","La ni ga lok tidi xeretna, “Do laradi i soxope latkin teren, la i epot manga at lara latkin petpes, neni ira longka vam la i lok laxapmek ti latkin avot teren. ");
INSERT INTO mmx_vpl VALUES ("MK10_12","071_10_12","MRK","10","12","12","Do tatkin na soxope latlok teren la na epot ka taradi vetpes, neni ira longka vam mi nom laradi.” ");
INSERT INTO mmx_vpl VALUES ("MK10_13","071_10_13","MRK","10","13","13","At lara laaleng lentaba limixin diga lam kaka laxamdak mi laxaalik kakalik atdi uto saparap ne Iesu xusu ni na lok li lukngen mavana atdi la na lox anarong di. Ketla lavaun pinivu ren diga sep pepe di. ");
INSERT INTO mmx_vpl VALUES ("MK10_14","071_10_14","MRK","10","14","14","La ne Iesu ga ven i nom la ga vaase sok lavaun pinivu ren, ga lok tidi xeretna, “Mina ke laxamdak mi laxaalik kakalik dina vot pasa ia, la nemen mita sep pepe di, mila Linintoo at ne Moroa i epovo ridi na. ");
INSERT INTO mmx_vpl VALUES ("MK10_15","071_10_15","MRK","10","15","15","A tong tuturun i rinimi. Do nege xopmen na siam kaka Linintoo at ne Moroa xerekngan lamdak kakalik, neni noxo beles teren.” ");
INSERT INTO mmx_vpl VALUES ("MK10_16","071_10_16","MRK","10","16","16","La ne Iesu ga rebeng kaka nom laxamdak mi laxaalik getgesara la ga lok li lukngen mavana atdi la ga lox anarong di. ");
INSERT INTO mmx_vpl VALUES ("MK10_17","071_10_17","MRK","10","17","17","La ne Iesu ga vas kaxat uto at lenep petpes la lara laradi ga sixit pot, la ga xis tiktikbu mi luvatgulom teren to melamgo at ne Iesu la ga lok tin keretna, “Leeme loklox ase avukat. Nenia ba lok lavanga sala, kusu anaba lok kaka lorooro avolo?” ");
INSERT INTO mmx_vpl VALUES ("MK10_18","071_10_18","MRK","10","18","18","La ne Iesu ga lok tin keretna, “Tila u tong ia do a lox avukat? Kopmen tara na lox avukat ketla ne Moroa xusuk mun. ");
INSERT INTO mmx_vpl VALUES ("MK10_19","071_10_19","MRK","10","19","19","Uklen pam lasangaun Levenaulis Linga i lok keretna. ‘Nemen uta sev amet tara, nemen utang longka tixin, nemen uta xip pilo, nemen uta vaase xaxarang mumu tara, nemen uta xarang kaka tempanga at tara vetpes, una lok ngangao at ne tamam mi ne nenam.’” ");
INSERT INTO mmx_vpl VALUES ("MK10_20","071_10_20","MRK","10","20","20","La mo laradi ga lok ti ne Iesu xeretna, “Leeme loklox ase, ga ruka i, laau ia, aga mumu asu vam na levelinga.” ");
INSERT INTO mmx_vpl VALUES ("MK10_21","071_10_21","MRK","10","21","21","La ne Iesu ga ven tooro i la ga balamu i la ga lok tin keretna, “Nenu move uk pakes ti tegesa vanga. Una sesep mi lempanga axap taram la una raba lempilas at nai ri limixin banbalo la unaba ruuna ka lapnovos silok to vana at laxalibet. La melemu una mumu asu ba ia.” ");
INSERT INTO mmx_vpl VALUES ("MK10_22","071_10_22","MRK","10","22","22","La nom laradi ga milik angtungun la ni ga vas kaxat mi lainbulu silok mila neni gap novos aleng. ");
INSERT INTO mmx_vpl VALUES ("MK10_23","071_10_23","MRK","10","23","23","La ne Iesu ga ven tangtagap la ga lok ti lavaun pinivu ren keretna, “Naba lolos aleng ti luvuttadi dip novos kusu dina vubeles at Linintoo at ne Moroa.” ");
INSERT INTO mmx_vpl VALUES ("MK10_24","071_10_24","MRK","10","24","24","La lavaun pinivu ren diga sangu at na levelinga ren. La ne Iesu ga lok bok tidi, “Loxongkulao, i lolos aleng do tara na vubeles at Linintoo at ne Moroa. ");
INSERT INTO mmx_vpl VALUES ("MK10_25","071_10_25","MRK","10","25","25","I lolos aleng ti lakamel kusu na beles at lamamara at linil, la kerepmo i lolos aleng bok ti laradi nopnovos kusu ti beles at Linintoo at ne Moroa.” ");
INSERT INTO mmx_vpl VALUES ("MK10_26","071_10_26","MRK","10","26","26","La lavaun pinivu ren diga sangu aleng at nom levelinga la diga epaase xeretna, “Nege i epovo ba do na lok ka lorooro avolo?” ");
INSERT INTO mmx_vpl VALUES ("MK10_27","071_10_27","MRK","10","27","27","La ne Iesu ga ven tooro di la ga lok tidi xeretna, “Kopmen na epovo do laradi na lox i na, ketla i epovo do ne Moroa na lok lempanga axap.” ");
INSERT INTO mmx_vpl VALUES ("MK10_28","071_10_28","MRK","10","28","28","La ne Pita ga lok tin, “Kereva ba nema, maga on basinge vam lempanga axap atnama kusu mana mumu asu u.” ");
INSERT INTO mmx_vpl VALUES ("MK10_29","071_10_29","MRK","10","29","29","La ne Iesu ga lok tidi xeretna, “A tong tuturun i rinimi. Do tara na on basinge lemenemen teren kopla luvutneton kopla luvurinen kopla nenen kopla temen kopla laxamdak mi laxaalik teren kopla leventaamang teren ti lok tooro ia la ri tong asu Lagale Lavavang at ne Moroa. ");
INSERT INTO mmx_vpl VALUES ("MK10_30","071_10_30","MRK","10","30","30","Neni naba ruuna xaka luunun silok at na lorooro, i ngan buaang laraogu, buaang luvutneton, buaang luvurinen, buaang luvutnen, buaang laxamdak mi laxaalik, laxantaamang solo. La neni naba lok kaka bok levesongsongot mumu Lagale Lavavang la neni naba rooro amisik at lorooro melemu. ");
INSERT INTO mmx_vpl VALUES ("MK10_31","071_10_31","MRK","10","31","31","Ketla buaang limixin di ruuna levenasen silok at na lorooro, di noxo silok at lorooro melemu. La nedi kopmen dina silok at na lorooro, dinaba silok at lorooro melemu.” ");
INSERT INTO mmx_vpl VALUES ("MK10_32","071_10_32","MRK","10","32","32","La melemu ne Iesu mi lavaun pinivu ren diga vas kaxat uto Jerusalem. Iesu gam gomgo ridi la diga sangu aleng mumu lavatpas teren. Limixin petpes bok diga mumu asu i, la nedi axap diga marat. La ne Iesu ga lam kaka lasangaun mi legepura lavaun pinivu ren uto vetpes la ga tong i ridi xeretna, ");
INSERT INTO mmx_vpl VALUES ("MK10_33","071_10_33","MRK","10","33","33","“Nedik ta onon uto Jerusalem la lara laradi naba song araba ia, Laradi Mevana, ri lavamaasa silok eburu mi luvuttadi loklox ase at Laulis Linga. La nedi dinaba lok li ia at lavapaase la dinaba lok li lumumuat tarak kusu nenia ana met. La dinaba song araba ia ri limixin esep boro Rom. ");
INSERT INTO mmx_vpl VALUES ("MK10_34","071_10_34","MRK","10","34","34","La dinaba paase aksaksa ria la dinaba vubis sanga ia la dinabak pixis ia la dinaba sev amer ia. Ketla melemu at lavantun aleng anaba roo xat amlong.” ");
INSERT INTO mmx_vpl VALUES ("MK10_35","071_10_35","MRK","10","35","35","La ne Jems mi ne Jon, lumdak at ne Sebedi, duga vot pasa ne Iesu la duga lok tin keretna, “Leeme loklox ase, lara lavanga mo ma lok do mana sue u min, la ma vara i do una vorang i rinama.” ");
INSERT INTO mmx_vpl VALUES ("MK10_36","071_10_36","MRK","10","36","36","La ne Iesu ga sue du xeretna, “Lavanga salai muna sing ia min?” ");
INSERT INTO mmx_vpl VALUES ("MK10_37","071_10_37","MRK","10","37","37","La duga vorang i xeretna, “Una siam do nema manat kis at luxot silok, lara saparap lakngam tino la lara saparap lakngam kia ap mo levenaleng unabat kis kantubu at lisisixam taram.” ");
INSERT INTO mmx_vpl VALUES ("MK10_38","071_10_38","MRK","10","38","38","La ne Iesu ga lok tidu, “Nemu muxoklen lavanga nemu mu sing tin. Kereva, mu epovo munap kip levenmumuat ngan nenia anabap kiv i? La mu epovo xusu muna vubeles at langsangan losongsongot nenia anaba vubeles teren?” ");
INSERT INTO mmx_vpl VALUES ("MK10_39","071_10_39","MRK","10","39","39","La duga vorang i xeretna, “Ma epovo.” La ne Iesu ga lok tidu xeretna, “Munabap kip levenmumuat tarak la munaba vubeles at losongsongot tarak, ");
INSERT INTO mmx_vpl VALUES ("MK10_40","071_10_40","MRK","10","40","40","ketla kopmen lugugu rak do nia aba tong i do nege bat kis saparap lakngak tino la saparap lakngak kia. Mo luxot ik lok mun tinedi no ne Tamak gara soxolik ka vam di.” ");
INSERT INTO mmx_vpl VALUES ("MK10_41","071_10_41","MRK","10","41","41","La lasangaun lavaun pinivu ren diga ronga nom levelinga la diga musak ne Jems mi ne Jon. ");
INSERT INTO mmx_vpl VALUES ("MK10_42","071_10_42","MRK","10","42","42","La ne Iesu ga ro bubua ka nedi axap la ga lok tidi xeretna, “Miklen pam i dola luvuttadi amgomgo at limixin kopmen di me Judaia di ruuna lolos mavana at limixin atdi. ");
INSERT INTO mmx_vpl VALUES ("MK10_43","071_10_43","MRK","10","43","43","Ketla nemen gat na loklok nak lok kantubu atnimi. Mo do tara atnimi i vara i do na silok, neni na lok ngan lasaxaruki atnemi axap. ");
INSERT INTO mmx_vpl VALUES ("MK10_44","071_10_44","MRK","10","44","44","La do tara atnimi i vara i do nam gomgo, neni na lok ngan lasaxaruki gamasa atnimi. ");
INSERT INTO mmx_vpl VALUES ("MK10_45","071_10_45","MRK","10","45","45","Nenia Laradi Mevana la loklok tarak ik lok bok kuren. Nia xopmen a goxo vot kusu limixin dinaba lok ngan lavasaxaruki rak. Ketla nia aga vot kusu ana lok ngan lasaxaruki ridi, la kusu ana raba lorooro rak ngan laxaavuk ti buaang limixin.” ");
INSERT INTO mmx_vpl VALUES ("MK10_46","071_10_46","MRK","10","46","46","La ne Iesu eburu mi lavaun pinivu ren diga rupot to at lemenemen Jeriko. La diga vas kaxat basinge nom lemenemen la buaang limixin diga emu midi. La lara laradi laasen teren ne Batimias, nitna ne Timias, gat kis to at lisigege ngas la ga ngising panga mila luxatli ren ga main axap. ");
INSERT INTO mmx_vpl VALUES ("MK10_47","071_10_47","MRK","10","47","47","La neni ga ronga i dola ne Iesu me Nasaret gat pas at nom langa, neni gap kup keretna, “Livisik li at ne Devit. Una balamu ia.” ");
INSERT INTO mmx_vpl VALUES ("MK10_48","071_10_48","MRK","10","48","48","La buaang limixin diga tong i rin do na lok pilo, ketla neni gap kup silok keretna, “Livisik li at ne Devit. Una balamu ia.” ");
INSERT INTO mmx_vpl VALUES ("MK10_49","071_10_49","MRK","10","49","49","La ne Iesu ga ru la ga lok, “Mina ro xaka i ude.” La diga ro ka mo laradi la diga lok tin keretna, “Una lok momo la una xatu upana. Iesu no i toro ru.” ");
INSERT INTO mmx_vpl VALUES ("MK10_50","071_10_50","MRK","10","50","50","La neni ga lok kepe lavanga singsiga me maxamang teren la ga xatu soso la ga vot pasa ne Iesu. ");
INSERT INTO mmx_vpl VALUES ("MK10_51","071_10_51","MRK","10","51","51","La ne Iesu ga sue i xeretna, “U vara i do nenia na lok lavanga salai ru?” La nom laradi ga vorang i xeretna, “Rabai. A vara i do luxatli rak na xasep.” ");
INSERT INTO mmx_vpl VALUES ("MK10_52","071_10_52","MRK","10","52","52","La ne Iesu ga lok tin keretna, “Una vas kaxat. Lununu ram ira lox avukat pam u.” La soso mun luxatli ren ga xasep la neni ga emu mi ne Iesu ro at langa. ");
INSERT INTO mmx_vpl VALUES ("MK11_1","071_11_1","MRK","11","1","1","La ne Iesu mi mo limixin solo digat pas uto auret ta lemenemen Jerusalem, diga rupot to at lumenemen Betpage la Beteni at Lakaana Olip. Iesu ga riki amgo legepura at lavaun pinivu ren. ");
INSERT INTO mmx_vpl VALUES ("MK11_2","071_11_2","MRK","11","2","2","Avot be ni ga lok tidu xeretna, “Munat pas uto at nom lemenemen ik lok to melamgo atnumu. La soso mun munaba long lenget ka lodongki maxat, kovisi tara goxo xis teren. La muna soxomus ka i ude. ");
INSERT INTO mmx_vpl VALUES ("MK11_3","071_11_3","MRK","11","3","3","Dola tara na sue numu do, ‘Tila nemu mu soxomus ka nom lodongki?’ muba lok tin keretna, ‘Leeme Silok i vara i la manaba lok li amlong soso bok ba i.’” ");
INSERT INTO mmx_vpl VALUES ("MK11_4","071_11_4","MRK","11","4","4","La nedu duga vas kaxat la duga ven lenget ka lodongki at loogu gak lok saparap langa, diga xoxo li i go la duga soxomus ka i. ");
INSERT INTO mmx_vpl VALUES ("MK11_5","071_11_5","MRK","11","5","5","Lentaba diga tu go diga sue du xeretna, “Mu lok lavanga salai, tila mu soxomus ka nom lodongki?” ");
INSERT INTO mmx_vpl VALUES ("MK11_6","071_11_6","MRK","11","6","6","La duga vorang i ngan ne Iesu ga tong pam i ridu la nom limixin diga mulus taba du mi lodongki. ");
INSERT INTO mmx_vpl VALUES ("MK11_7","071_11_7","MRK","11","7","7","La duga lok kaka lodongki uto saparap ne Iesu la duga lok li levempanga singsiga to vana ren la ne Iesu ga xis teren. ");
INSERT INTO mmx_vpl VALUES ("MK11_8","071_11_8","MRK","11","8","8","La nedi axap diga vas kaxat uto Jerusalem. Buaang limixin diga lok li levempanga singsiga atdi ro at langa la lentaba diga ra ka lengkakan bisi boro at leventaamang atdi la diga lok li i at langa. ");
INSERT INTO mmx_vpl VALUES ("MK11_9","071_11_9","MRK","11","9","9","Lentaba digat pas to melamgo at ne Iesu la lentaba digat pas to melemu ren. Nedi axap digap kup momo xeretna, “Leemi asu ri ne Moroa. Luvukat ti mo laradi it pas mi laasen at Leeme Silok. ");
INSERT INTO mmx_vpl VALUES ("MK11_10","071_11_10","MRK","11","10","10","I lox avukat ti lovotpot at Linintoo at lurubuno avolo atdik ne Devit. Leemi asu aleng ti ne Moroa.” ");
INSERT INTO mmx_vpl VALUES ("MK11_11","071_11_11","MRK","11","11","11","La ne Iesu ga vubeles to Jerusalem la gat pas uto at loogu laplavang. Ni ga ven tangtagap at lempanga axap. Ketla ukantinao ren neni eburu mi lasangaun mi legepura lavaun pinivu ren diga sixisu la digat pas uto Beteni. ");
INSERT INTO mmx_vpl VALUES ("MK11_12","071_11_12","MRK","11","12","12","Ap mo lara laaleng melemu ne Iesu eburu mi lavaun pinivu ren diga vas kaxat basinge lemenemen Beteni, la ne Iesu ga roxo. ");
INSERT INTO mmx_vpl VALUES ("MK11_13","071_11_13","MRK","11","13","13","La ni ga ven lara luuna pik to vaxalom la mo luuna ga xo vavaxan mene nga. La ne Iesu gat pas kusu na dik ka tevempeven una ren. Ketla goxopmen tevempeven una ren, ga xo vavaxan mene nga, mila goxovisi lagaaling tin ti visik. ");
INSERT INTO mmx_vpl VALUES ("MK11_14","071_11_14","MRK","11","14","14","La ne Iesu ga vaase lolos ti nom luuna xeretna, “Nenu u noxo visik bok ba tevempeven una.” La lavaun pinivu ren diga ronga nom levelinga ren. ");
INSERT INTO mmx_vpl VALUES ("MK11_15","071_11_15","MRK","11","15","15","La diga rupot to Jerusalem la ne Iesu ga vubeles to at loogu laplavang la ni ga xala su mi limixin diga sesep mi lempanga ro xeneng la nedi bok diga unun panga. La ni ga ba gili levenora lili atnedi no digak lox ekun lempilas la ga ba gili levengkonin kitkis atnedi diga sesep mi levenamno. ");
INSERT INTO mmx_vpl VALUES ("MK11_16","071_11_16","MRK","11","16","16","La neni ga sep pepe bok lentaba vetpes kusu nedi di noxo vas polo ro xeneng at loogu laplavang mi lempanga atdi. ");
INSERT INTO mmx_vpl VALUES ("MK11_17","071_11_17","MRK","11","17","17","La ne Iesu ga anasa di xeretna, “Levelinga at ne Moroa ik lok at Lovoang Kaala i lok keretna, ‘Loogu rak dinaba so asen i mi loogu singising ti limixin at levengkot axap.’ Ketla nemi mira lok kapmek pam i, i ngan loogu loklox alipe at luvuttadi dip sep paxat ka panga.” ");
INSERT INTO mmx_vpl VALUES ("MK11_18","071_11_18","MRK","11","18","18","La lavamaasa silok mi luvuttadi loklox ase at Laulis Linga diga ronga nom levelinga ne Iesu ga tong i. Kuren la diga puse ngas ti sev amer i. Diga marat teren mila limixin axap diga sangu at levenanasa ren. ");
INSERT INTO mmx_vpl VALUES ("MK11_19","071_11_19","MRK","11","19","19","Ga ukantinao nga la ne Iesu mi lavaun pinivu ren diga on basinge lemenemen silok Jerusalem. ");
INSERT INTO mmx_vpl VALUES ("MK11_20","071_11_20","MRK","11","20","20","Ga maxantamak manga diga vas kaxat la diga ven nom luuna ga mang axap, levenixe bok teren ga mang axap. ");
INSERT INTO mmx_vpl VALUES ("MK11_21","071_11_21","MRK","11","21","21","La ne Pita ga doma su at levelinga at ne Iesu la ga lok tin keretna, “Leeme Silok, una ven be nom luuna. Uta paase lolos tin itinongo la na i mang axap pam.” ");
INSERT INTO mmx_vpl VALUES ("MK11_22","071_11_22","MRK","11","22","22","La ne Iesu ga lok tidi xeretna, “Mina nunu at ne Moroa. ");
INSERT INTO mmx_vpl VALUES ("MK11_23","071_11_23","MRK","11","23","23","A tong tuturun i rinimi. Do tara na tong i ri na lavatkaana xeretna, ‘Una onon la una subu tup tou at laras,’ la do neni i nunu ruturun keneng at lebelen la lodoxoma ren kopmen na sixit ekarakat, Moroa naba lox i xerepmo. ");
INSERT INTO mmx_vpl VALUES ("MK11_24","071_11_24","MRK","11","24","24","Kuren la a tong i rinimi. Dola una sing ne Moroa ri tempanga u vara rin, una nunu do ne Moroa na raba u min la neni naba lox i xuren. ");
INSERT INTO mmx_vpl VALUES ("MK11_25","071_11_25","MRK","11","25","25","At loxonaleng una sing, una doxoma xepe leveloklok kakapmek limixin diga lox i ru, kusu ne Moroa naba doxoma xepe leveloklok kakapmek taram. ");
INSERT INTO mmx_vpl VALUES ("MK11_26","071_11_26","MRK","11","26","26","Do u noxo domampe leveloklok kakapmek at tara, Moroa noxo doxoma xepe leveloklok kakapmek taram.” ");
INSERT INTO mmx_vpl VALUES ("MK11_27","071_11_27","MRK","11","27","27","La ne Iesu eburu mi lavaun pinivu ren diga rupot to Jerusalem. La ne Iesu ga vubeles to xeneng at loogu laplavang la lavamaasa silok mi luvuttadi loklox ase at Laulis Linga mi loxongkulao silok at lubung mixin me Judaia diga vot pasa i. ");
INSERT INTO mmx_vpl VALUES ("MK11_28","071_11_28","MRK","11","28","28","La diga sue i xeretna, “Lavapaase axasep atnege nenu u ruuna i xusu ti lox i na lempanga? La nege ga raba u mi nom lolos?” ");
INSERT INTO mmx_vpl VALUES ("MK11_29","071_11_29","MRK","11","29","29","La ne Iesu ga vorang i ridi xeretna, “Ana sue bok nimi mi lara lususue la do mina vorang avukat taba ia min, aba vaase axasep ba nimi, do nenia a lok na lempanga mi lavapaase axasep salai. ");
INSERT INTO mmx_vpl VALUES ("MK11_30","071_11_30","MRK","11","30","30","Leesep susu at ne Jon ga laa meva, boro at ne Moroa xopla boro mun at limixin?” ");
INSERT INTO mmx_vpl VALUES ("MK11_31","071_11_31","MRK","11","31","31","La diga epaase xantubu atdi xeretna, “Mo do ata lok do, ‘Boro at ne Moroa,’ neni naba lok tidik keretna, ‘Tila ba mi goxo nunu at levelinga at ne Jon?’ ");
INSERT INTO mmx_vpl VALUES ("MK11_32","071_11_32","MRK","11","32","32","La mo do ata lok, ‘Boro at limixin,’ ata marat bok at limixin, mila di nunu do ne Jon neni leeme vapaase ali.” ");
INSERT INTO mmx_vpl VALUES ("MK11_33","071_11_33","MRK","11","33","33","Kuren la diga vorang i ri ne Iesu xeretna, “Maxoklen i.” La ne Iesu ga lok tidi xeretna, “Nia bok a noxo tong i rinimi do, nenia a lox i na lempanga mi lavapaase axasep salai.” ");
INSERT INTO mmx_vpl VALUES ("MK12_1","071_12_1","MRK","12","1","1","La melemu ne Iesu ga tong lavapaase poovo ridi xeretna, “Lara laradi gatlotlo laraamang vaen, la neni ga bos kangkan i la ga xe lamamara xusu ti loplok li levendan vaen teren, la melemu ga lok loogu xukuxut. La neni ga raba lentaba luvuttadi min kusu dina lok tatao i la neni gat pas uto at lenep petpes. ");
INSERT INTO mmx_vpl VALUES ("MK12_2","071_12_2","MRK","12","2","2","Laaleng ga vot kusu dina dik ka lempeven una at nom laraamang la laradi at laraamang ga riki lasaxaruki ren uto at nom laraamang ti lok kaka lenep at levempeven una. ");
INSERT INTO mmx_vpl VALUES ("MK12_3","071_12_3","MRK","12","3","3","Ketla nom luvuttadi loklok tatao at laraamang diga ranga alis nom lasaxaruki la diga rit pupu i la diga riki amlong kixinax i. ");
INSERT INTO mmx_vpl VALUES ("MK12_4","071_12_4","MRK","12","4","4","La nom laradi ga riki manga lara lasaxaruki, ketla diga sep patlak ka i la diga lox amamangan tinotno i. ");
INSERT INTO mmx_vpl VALUES ("MK12_5","071_12_5","MRK","12","5","5","La ni ga riki manga lara lasaxaruki la diga sev amer i. La ni ga riki buaang lavasaxaruki vetpes teren. Ketla diga tit pupu lentaba la diga sev amet lentaba. ");
INSERT INTO mmx_vpl VALUES ("MK12_6","071_12_6","MRK","12","6","6","La kopmen bok ba tavasaxaruki ren, ketla nitna xusuk ta mo gak lok, ni ga vavara aleng i. La ni ga nua i dola nom luvuttadi dinaba lok ngangao at ne nitna la ni ga riki ba i. ");
INSERT INTO mmx_vpl VALUES ("MK12_7","071_12_7","MRK","12","7","7","Ketla nom luvuttadi loklok tatao diga ven i la diga etong i xeretna, ‘Lamdak akmokso at laradi at na laraamang nom it pas boro. Ata sev amer i, la ataba ruuna ka na laraamang.’ ");
INSERT INTO mmx_vpl VALUES ("MK12_8","071_12_8","MRK","12","8","8","La diga ranga alis i la diga sev amer i la diga lu asu min uto maxamang at nom laraamang.” ");
INSERT INTO mmx_vpl VALUES ("MK12_9","071_12_9","MRK","12","9","9","La ne Iesu ga lok bok tidi xeretna, “La nom laradi i ruuna nom laraamang, neni ba lok lavanga salai ridi? Neni naba rupot la na sev amet nom luvuttadi, la na raba nom laraamang vaen ti tentaba tuvuttadi vetpes. ");
INSERT INTO mmx_vpl VALUES ("MK12_10","071_12_10","MRK","12","10","10","Nemi mi xasep at Lovoang Kaala i lok keretna, ‘Nom luuat luvuttadi xipkip gu diga sok tixirixes kepe i, ga ravasu ngan Luuat Kis la lugugu ren i silok aleng. ");
INSERT INTO mmx_vpl VALUES ("MK12_11","071_12_11","MRK","12","11","11","Leeme Silok axa ga lox i na la i lox avukat aleng at lemeren dik.’” ");
INSERT INTO mmx_vpl VALUES ("MK12_12","071_12_12","MRK","12","12","12","Lavamaasa silok mi luvuttadi loklox ase at Laulis Linga diga puse ngas ti ranga alis i mila digaklen i dola ne Iesu ga paase poovo mumu di. Ketla diga marat at limixin la diga ke ne Iesu la diga vas kaxat basinge i. ");
INSERT INTO mmx_vpl VALUES ("MK12_13","071_12_13","MRK","12","13","13","Melemu nedi lubung amgomgo diga riki lubung Parisi mi larapen tangas at ne Erodes kusu dina lok tong pen ne Iesu mi levelinga. ");
INSERT INTO mmx_vpl VALUES ("MK12_14","071_12_14","MRK","12","14","14","La diga rupot la diga lok tin keretna, “Leeme loklox ase, maklen i do nenu laradi ruturun la u anasa limixin mi leventaangas at ne Moroa la mo levelinga ram ik mokso. Uxo lok tooro legesa binam tadi xusuk mun mila uxo doxoma solo do tara i ruuna laasen silok kopla kopmen. Una tong i rinama do ua lusumsuma ram. Kereva, ik mokso do mana xepe pilas ti ne Kaisar kopla kopmen? ");
INSERT INTO mmx_vpl VALUES ("MK12_15","071_12_15","MRK","12","15","15","Maba un i xopla xopmen?” Ketla ne Iesu gaklen levendoxoma xapmek atnedi la ga lok tidi xeretna, “Nemi mi lok tong ia mi levelinga, do? Kaka tuxuven denarias ude. Ana ven be i.” ");
INSERT INTO mmx_vpl VALUES ("MK12_16","071_12_16","MRK","12","16","16","La diga raba i mi luxuven denarias la ne Iesu ga sue di xeretna, “Lamang la laasen atnege i nemen teren?” La diga vorang i xeretna, “At ne Kaisar.” ");
INSERT INTO mmx_vpl VALUES ("MK12_17","071_12_17","MRK","12","17","17","La ne Iesu ga lok tidi xeretna, “Mina raba ne Kaisar mi levempanga i epovo at ne Kaisar la mina raba ne Moroa mi levempanga i epovo at ne Moroa.” La diga sangu aleng at levelinga ren. ");
INSERT INTO mmx_vpl VALUES ("MK12_18","071_12_18","MRK","12","18","18","La lubung Sadiusi diga vot pasa ne Iesu. Diga lok do limixin diga met pam, di noxo roo xat amlong. Di ga lok tong pen ne Iesu xeretna, ");
INSERT INTO mmx_vpl VALUES ("MK12_19","071_12_19","MRK","12","19","19","“Leeme loklox ase, Moses ga malagan na langas linga rinama. Mo do taradi na met la latkin teren mo i rooro, ketla kopmen taxamdak atdu, neton nom laradi naba epot ap mo lanaa rixin kusu duba visik tamdak ti ruuna ka lempanga ap mo laradi ga met. ");
INSERT INTO mmx_vpl VALUES ("MK12_20","071_12_20","MRK","12","20","20","Ga lavanuti loxoeton. Lara gomgo ga epot, la ga met gamasa kopmen ni goxo visik taxamdak. ");
INSERT INTO mmx_vpl VALUES ("MK12_21","071_12_21","MRK","12","21","21","Lara sepsep agepura ga epot manga at nom latkin la neni ga met bok la goxo visik tamdak. La neton sepsep avantun ga lok box i xuren. ");
INSERT INTO mmx_vpl VALUES ("MK12_22","071_12_22","MRK","12","22","22","La nedi loxoeton axap diga epot at nom latkin la nedi axap diga met la di goxo visik tamdak la melemu mo latkin bok ga met.” ");
INSERT INTO mmx_vpl VALUES ("MK12_23","071_12_23","MRK","12","23","23","La diga sue ne Iesu xeretna, “At laaleng dola limixin dina xatu kaxat amlong, ti nege rinotno nom latkin, mila nedi axap diga epot teren?” ");
INSERT INTO mmx_vpl VALUES ("MK12_24","071_12_24","MRK","12","24","24","La ne Iesu ga vorang i ridi xeretna, “Nemi mi soogong at na lavanga mila mixo xasep at levelinga xeneng at Lovoang Kaala la mixo xasep at lolos at ne Moroa. ");
INSERT INTO mmx_vpl VALUES ("MK12_25","071_12_25","MRK","12","25","25","Ap mo laaleng limixin dinaba xatu kaxat amlong, di noxo epot. Dinaba nemen naa ngan lubung angelo boro vana at laxalibet. ");
INSERT INTO mmx_vpl VALUES ("MK12_26","071_12_26","MRK","12","26","26","Mumu laxakatu kaxat amlong ne Moses ga vaase axasep tuturun i do luvuttadi met dinaba rooro xat amlong. Ni ga lox asuusu i at levelinga mumu luuna laxao gak lok teren. Moroa ga lok tin keretna, ‘Nenia ne Moroa at ne Abaram, Moroa at ne Aisak, la Moroa at ne Jakop.’ ");
INSERT INTO mmx_vpl VALUES ("MK12_27","071_12_27","MRK","12","27","27","Ap mo laaleng ne Moroa ga tong i na, nedi lavantun diga met pam. La neni ne Moroa atnedi limixin di rooro, la kopmen atnedi luvuttadi met. Levendoxoma atnimi xopmen nak mokso.” ");
INSERT INTO mmx_vpl VALUES ("MK12_28","071_12_28","MRK","12","28","28","Lara at luvuttadi loklox ase at Laulis Linga ga rupot la ga ronga lavapaase atdi. Neni gaklen i do ne Iesu ga vorang avukat lususue atdi la neni bok ga sue ne Iesu xeretna, “Ua levelinga at Laulis Linga i silok ti levelinga axap teren?” ");
INSERT INTO mmx_vpl VALUES ("MK12_29","071_12_29","MRK","12","29","29","La ne Iesu ga vorang i rin keretna, “Levelinga i silok i lok keretna. ‘Lubung mixin me Israel, mina ronga i na. Moroa neni Leeme Silok atnimi la legesa Moroa mene nga. ");
INSERT INTO mmx_vpl VALUES ("MK12_30","071_12_30","MRK","12","30","30","Mina vavara aleng Leeme Silok, ne Moroa atnimi mi lebelen nimi axap, mi loroonan axap atnimi, mi levendoxoma axap atnimi, la levelolos axap atnimi.’ ");
INSERT INTO mmx_vpl VALUES ("MK12_31","071_12_31","MRK","12","31","31","La lara bok sepsev agepura i lok ngan lara gomgo, i lok keretna, ‘Mina balamu mo limixin di nemen saparap nimi xerekngan pam mi balamu nimi.’ Kopmen tevelinga ro xeneng at Lovoang Kaala i silok ti na luxot.” ");
INSERT INTO mmx_vpl VALUES ("MK12_32","071_12_32","MRK","12","32","32","La nom laradi ga lok ti ne Iesu, “Leeme loklox ase, lavapaase ram ik mokso. U paase ruturun do legesa Moroa mene nga la kopmen tomoroa bok. ");
INSERT INTO mmx_vpl VALUES ("MK12_33","071_12_33","MRK","12","33","33","La i ruturun bok do na levelinga i silok. Mina vavara aleng ne Moroa mi lebelen nimi axap, mi levendoxoma atnimi axap, mi levelolos atnimi axap la mina balamu limixin di nemen saparap nimi ngan mi balamu nemi. Na loklok i silok ti mo loklok tim taba ne Moroa mi leventamtaba la levempanga laplavang.” ");
INSERT INTO mmx_vpl VALUES ("MK12_34","071_12_34","MRK","12","34","34","La ne Iesu ga ronga xisiv i do mo laradi ga paase mi lakleklen la ga lok tin keretna, “I auret kusu una vubeles at Linintoo at ne Moroa.” La melemu at na lubung amgomgo diga xopara i xusu dina sue ne Iesu mi tevesusue. ");
INSERT INTO mmx_vpl VALUES ("MK12_35","071_12_35","MRK","12","35","35","La ne Iesu ga anasa ro at loogu laplavang. Ni ga sue xeretna, “Luvuttadi loklox ase at Laulis Linga dik lox ase limixin do Lanarong neni lurubuno ne Devit. I lok kereva na? ");
INSERT INTO mmx_vpl VALUES ("MK12_36","071_12_36","MRK","12","36","36","Mila ne Devit ga tong asu levelinga mi lodoxoma at Loroonan Kaala la nom levelinga ik lok to xeneng at Lovoang Kaala xeretna, ‘Leeme Silok ne Moroa ga lok ti Leeme Silok tarak keretna, una xis de saparap lakngak tino se nenia ana lok li limixin munepen minu na ngan loxot burubut ti luxangkedek taram.’ ");
INSERT INTO mmx_vpl VALUES ("MK12_37","071_12_37","MRK","12","37","37","Mo do ne Devit ga so asen i do Leeme Silok, i lok kereva la Lanarong neni lurubuno at ne Devit?” La buaang limixin diga lok momo ri ronga levelinga at ne Iesu. ");
INSERT INTO mmx_vpl VALUES ("MK12_38","071_12_38","MRK","12","38","38","La ne Iesu ga anasa bok keretna, “Mina lok tatao avukat nemi basinge loklok at luvuttadi loklox ase at Laulis Linga, mo di vavara i xusu dinat pas tangtagap mi levesingsigaara babaalom atdi la di vavara i xusu limixin dina seega rangarang di mi loklok ngangao ro at lengkot etang. ");
INSERT INTO mmx_vpl VALUES ("MK12_39","071_12_39","MRK","12","39","39","La di vavara aleng i do dinat kis at lengkot kitkis avukat to at laraogu singising la lengkot avukat to at lara peluxa. ");
INSERT INTO mmx_vpl VALUES ("MK12_40","071_12_40","MRK","12","40","40","La dik lok kaka gamasa lempanga at lubungnaa rixin, la di ngising babaalom kusu limixin dibak lok ngangao atdi. Losongsongot tidi naba lok kapmek aleng tinotno!” ");
INSERT INTO mmx_vpl VALUES ("MK12_41","071_12_41","MRK","12","41","41","La ne Iesu gat kis to xeneng at loogu laplavang la ga reven limixin diga kepe lempilas atdi ro at loxot lili pilas. Buaang luvuttadi nopnovos diga kepe laxampilas solo. ");
INSERT INTO mmx_vpl VALUES ("MK12_42","071_12_42","MRK","12","42","42","Ketla ni ga ven lara labannaa rixin banbalo ga xepe legepu xonatat pilas lixilik. Ni lempilas lixilik tinotno. ");
INSERT INTO mmx_vpl VALUES ("MK12_43","071_12_43","MRK","12","43","43","La ne Iesu ga ro xaka lavaun pinivu ren la ga lok tidi xeretna, “A tong tuturun i rinimi do at lemeren ne Moroa, na labannaa rixin banbalo i lok li lempilas i silok ti lempilas atnedi axap di xepe lempilas atdi. ");
INSERT INTO mmx_vpl VALUES ("MK12_44","071_12_44","MRK","12","44","44","Mila nedi di raba ne Moroa mi loxot lixilik mun at lapnovos silok atdi, ketla neni i raba ne Moroa mi lempilas axap teren.” ");
INSERT INTO mmx_vpl VALUES ("MK13_1","071_13_1","MRK","13","1","1","La melemu ne Iesu ga on basinge loogu laplavang, lara at lavaun pinivu ren ga lok tin keretna, “Leeme loklox ase, pen ba lemparuat silok at loogu laplavang la laraogu avukat bok i tu saparav i.” ");
INSERT INTO mmx_vpl VALUES ("MK13_2","071_13_2","MRK","13","2","2","La ne Iesu ga vorang i xeretna, “Una ven avukat na laraogu nunuan. Taaleng naba vot la kopmen toxonuat at nom laraogu naba nemen at loxot teren. Limixin munepen dinaba vot la dina ut tereve axav i ukopok.” ");
INSERT INTO mmx_vpl VALUES ("MK13_3","071_13_3","MRK","13","3","3","La melemu ni gat kis eburu mi lavaun pinivu ren to at Lakaana Olip. Diga reven loogu laplavang ga tu ro at lakaana vetpes. Pita la ne Jems la ne Jon la ne Endru, nedi xusuk digak lok mi ne Iesu la diga sue ne Iesu xeretna, ");
INSERT INTO mmx_vpl VALUES ("MK13_4","071_13_4","MRK","13","4","4","“Una tong i rinama. Lingisa nom lempanga naba vot la loklok katling salai naba lok katling lovotpot ap mo levenaleng do mo lempanga na ravasu?” ");
INSERT INTO mmx_vpl VALUES ("MK13_5","071_13_5","MRK","13","5","5","La ne Iesu ga vorang i ridi xeretna, “Mina lok tatao avukat nimi xusu tara noxo xarang arup nimi mumu i na lempanga, ");
INSERT INTO mmx_vpl VALUES ("MK13_6","071_13_6","MRK","13","6","6","mila buaang luvuttadi dinaba rupot mi laasen tarak la dinaba lok, ‘Nenia Lanarong!’ La dinaba sar asoogong buaang limixin mi laxalinga xaxarang atdi. ");
INSERT INTO mmx_vpl VALUES ("MK13_7","071_13_7","MRK","13","7","7","La minaba ronga i do laraesep mo ik lok la laraesep bok naba vot, ketla laxavaxap at na lavatbung menemen noxo vot ap mo levenaleng. ");
INSERT INTO mmx_vpl VALUES ("MK13_8","071_13_8","MRK","13","8","8","Limixin at lentaba levenabung mixin dinaba esep eburu mi limixin at levenabung mixin petpes. Lavaorong at lentaba levengkitkis orong dinaba esep mi lavaorong at levengkitkis orong petpes. Levenangne naba rupot to at tevengkot axap eburu mi leean kangking. Nom levempanga naba ru katling lavakpaxaru kaxat ap mo levenaleng, naba lok ngan losongsongot i rupot at latkin mo i auret kusu na visik. ");
INSERT INTO mmx_vpl VALUES ("MK13_9","071_13_9","MRK","13","9","9","Ketla mina lok tatao avukat nimi. Tentaba dinaba ranga alis nimi la minaba tu at lavapaase ro melamgo at lavaeme silok la dinabak pixis nimi ro at laraogu singising. La minaba tu at lavapaase ro melamgo at lavaeme amgomgo mi lavaorong mila nemi mi nunu rak, ketla minaba tong asu Lagale Lavavang tidi. ");
INSERT INTO mmx_vpl VALUES ("MK13_10","071_13_10","MRK","13","10","10","La limixin boro at levennep axap dinaba ronga be Lagale Lavavang tarak la melemu ren laaleng silok naba rupot. ");
INSERT INTO mmx_vpl VALUES ("MK13_11","071_13_11","MRK","13","11","11","Do dina ranga alis nimi la dina lam kaka nimi uto at lavapaase, nemen mita marat at levelinga salai miba tong asu i ridi. Mina tong asu mene mo levelinga nak lok at levendoxoma atnimi ap mo loxonaleng mila Loroonan Kaala naba raba nimi mi levelinga. ");
INSERT INTO mmx_vpl VALUES ("MK13_12","071_13_12","MRK","13","12","12","Lara koeton axa dinaba etaba tuntuna mi luvutneton di ri lanmet. La luvuttemen laxamdak dinaba etaba tuntuna mi laxamdak la laxaalik atdi. La laxamdak mi laxaalik dinabang tonga xepe levelinga at luvuttemen di mi luvutnen di la dinaba lok li di ri lanmet. ");
INSERT INTO mmx_vpl VALUES ("MK13_13","071_13_13","MRK","13","13","13","La limixin axap dinaba belengatngas tinimi mila mi mumu asu ia. Ketla lara do i tu atmatkun keneng at levesongsongot ise at laxavaxap ap mo levenaleng, ne Moroa naba lox arooro i.” ");
INSERT INTO mmx_vpl VALUES ("MK13_14","071_13_14","MRK","13","14","14","La ne Iesu ga lok bok tidi xeretna, “Do mina ven lavanga i lok kapmek aleng na tu ro at loxot i xaala aleng to xeneng at loogu laplavang, nemi minaba nemen to at lenep Judaia, mina sixiro uto at lempatkaana. Mina xasep avukat at na. ");
INSERT INTO mmx_vpl VALUES ("MK13_15","071_13_15","MRK","13","15","15","Laradi do ik lok to mavana at loogu ren, ni noxo si kusu na lok ka lempanga ren boro xeneng ap mo loogu ren. ");
INSERT INTO mmx_vpl VALUES ("MK13_16","071_13_16","MRK","13","16","16","La laradi do nak lok to xataamang, noxomlong bok ba uto at loogu ren kusu na lok ka lavanga singsiga ren. ");
INSERT INTO mmx_vpl VALUES ("MK13_17","071_13_17","MRK","13","17","17","Mo laaleng naba lok kapmek aleng ti lavakin teenan eburu mi lavakin mi levengkadede atdi! ");
INSERT INTO mmx_vpl VALUES ("MK13_18","071_13_18","MRK","13","18","18","Mina ngising ne Moroa do mo laaleng noxo vot saparap nimi edompo mi taaleng kabu. ");
INSERT INTO mmx_vpl VALUES ("MK13_19","071_13_19","MRK","13","19","19","Mila levenmumuat ap mo levenaleng naba lok kapmek tinotno. Ga ruka i at lurutu kaxat at na lavatbung menemen mo ne Moroa ga rudum li i, ise nga na lingina. La kopmen bok tara tumumuat kerepmo naba vot melemu. ");
INSERT INTO mmx_vpl VALUES ("MK13_20","071_13_20","MRK","13","20","20","La mo levenaleng ti mo levenmumuat do ne Moroa noxo lox atmur i, kopmen teta naba roo su. Ketla ne Moroa naba lox asuusu lebelen tuntun teren ti mo limixin neni gara soxolik ka vam di, la ni naba lox atmut mo levenaleng. ");
INSERT INTO mmx_vpl VALUES ("MK13_21","071_13_21","MRK","13","21","21","Ap mo levenaleng nemen gat mita nunu at levelinga at tara na lok tinimi xeretna, ‘Mina ven ba i, neni nga na Lanarong!’ Kopla na lok, ‘Neni nga no!’ Nemen mita nunu at nom levelinga atdi. ");
INSERT INTO mmx_vpl VALUES ("MK13_22","071_13_22","MRK","13","22","22","Mila buaang nedi limixin babala dinaba lok do nedi mo lavanarong at ne Moroa la lavaeme vapaase ali ren. Dinaba lok tempanga sangsangu xusu dina sar asoogong lavaanat soksoxolik at ne Moroa, mo do di epovo. ");
INSERT INTO mmx_vpl VALUES ("MK13_23","071_13_23","MRK","13","23","23","Kuren la mina doma mumu avukat na levelinga rak. A tong ali avot ta i rinimi.” ");
INSERT INTO mmx_vpl VALUES ("MK13_24","071_13_24","MRK","13","24","24","La ne Iesu ga lok bok tidi xeretna, “Ketla ap mo levenaleng melemu at na levenmumuat leveloklok katling naba vot, ‘Losoosoo at laxangking naba xap, la lagaaling noxo soosoo. ");
INSERT INTO mmx_vpl VALUES ("MK13_25","071_13_25","MRK","13","25","25","La larapenti naba subu si boro vana at lamavangkap la lempanga mevana dinaba sixit ekarakat la kopmen di noxo sixit mu larangas atdi.’ ");
INSERT INTO mmx_vpl VALUES ("MK13_26","071_13_26","MRK","13","26","26","La ap mo levenaleng limixin dinaba ven ia, Laradi Mevana, to vana at loxontakabu. Nenia anaba rupot mi langsangan lolos la lisisixam silok. ");
INSERT INTO mmx_vpl VALUES ("MK13_27","071_13_27","MRK","13","27","27","La nenia anaba riki lubung angelo uto at levengkot axap la dinaba lam kaka lavaanat soksoxolik tarak boro at lavanuet laramesuluk at lavanuet laramera manman at na lavatbung menemen.” ");
INSERT INTO mmx_vpl VALUES ("MK13_28","071_13_28","MRK","13","28","28","La ne Iesu ga tong lara lavapaase poovo ridi xeretna, “Mina ronga na laanasa mumu luuna pik. Dola levesisilik at larauna pik di mumulum la levenang i suu xat, nemi miklen i do lamaares i auret ta. ");
INSERT INTO mmx_vpl VALUES ("MK13_29","071_13_29","MRK","13","29","29","La kerepmo do mina ven i na lempanga loklok katling na vot, mina xasep do lovotpot tarak, Laradi Mevana i auret, i ngan laradi i tu at lumusmaragu at loogu la i gagas kusu na beles teren. ");
INSERT INTO mmx_vpl VALUES ("MK13_30","071_13_30","MRK","13","30","30","Nia a tong tuturun i rinimi. Limixin at na loola di rooro lingina di noxo met se na lempanga na ravasu. ");
INSERT INTO mmx_vpl VALUES ("MK13_31","071_13_31","MRK","13","31","31","Laxalibet mi lavatbung menemen naba sonao, ketla levelinga rak noxo xap.” ");
INSERT INTO mmx_vpl VALUES ("MK13_32","071_13_32","MRK","13","32","32","La ne Iesu ga lok bok, “Kopmen tara naklen laaleng at lovotpot tarak. Lubung angelo bok kopmen dinaklen i la nenia, ne Nitna bok kopmen anaklen i. Tamak kusuk mun iklen i. ");
INSERT INTO mmx_vpl VALUES ("MK13_33","071_13_33","MRK","13","33","33","Kuren la nemi mina reven avukat mila mixoklen i do lingisa mo laaleng naba rupot. ");
INSERT INTO mmx_vpl VALUES ("MK13_34","071_13_34","MRK","13","34","34","I lok ngan lara leeme silok gat pas uto vaxalom la lavasaxaruki ren diga lok tatao loogu ren. Neni ga tong li leven gugu ridi getgesara la neni ga tong i ri legesara atdi dola neni na lok tatao lumusmaragu la na reven ti lomlong teren. ");
INSERT INTO mmx_vpl VALUES ("MK13_35","071_13_35","MRK","13","35","35","La nemi mi lok ngan nom lasaxaruki ga lok tatao lumusmaragu. Mina reven avukat amisik mila mixoklen mo laaleng Leeme Silok nabamlong teren. I epovo na rupot ukantinao kopla at laxanimin tubu kopla at nom loxonaleng lengkaxak ing teng kaxat teren, kopla at loxonaleng laxangking it losu ren. ");
INSERT INTO mmx_vpl VALUES ("MK13_36","071_13_36","MRK","13","36","36","Mina reven avukat, naba lok kapmek do mina unga ap mo loxonaleng neni na rupot teren. ");
INSERT INTO mmx_vpl VALUES ("MK13_37","071_13_37","MRK","13","37","37","Nom levelinga ara tong pam i rinimi, la anaba tong box i ri limixin axap, mina reven avukat.” ");
INSERT INTO mmx_vpl VALUES ("MK14_1","071_14_1","MRK","14","1","1","At legepu aleng avot ti mo laaleng leluxa silok at Lovovolo Pe ga auret. La ap mo leluxa diga anan lengkongkide diga ove vetpes i. La lavamaasa silok la luvuttadi loklox ase at Laulis Linga diga puse ngas kusu dina ranga alis nemnem ne Iesu la dina lok li i at lavapaase xusu dina sev amer i. ");
INSERT INTO mmx_vpl VALUES ("MK14_2","071_14_2","MRK","14","2","2","Ketla diga epaase xeretna, “Ata noxo lox i na at laaleng at leluxa. Lavanga limixin dina lok kaxat turube.” ");
INSERT INTO mmx_vpl VALUES ("MK14_3","071_14_3","MRK","14","3","3","Iesu gak lok to Beteni at loogu at ne Simon, gano lanmeres gu (leprosy) gak lok teren. La ne Iesu gat kis ti anan, la lara latkin ga vot pasa i, gap kip lubuxom avukat ga umsu mi laxadan mavak. Mo loxodan laasen teren naat, i nunuan aleng la luunun teren ga urut aleng. La neni ga ba pit kepe laxatli ap mo lubuxom dan mavak la ga soli i ro at lavatlak at ne Iesu. ");
INSERT INTO mmx_vpl VALUES ("MK14_4","071_14_4","MRK","14","4","4","La lentaba digak lok go diga ven i, la diga musak aleng la diga epaase xeretna, “Tila i soli xepe gamasa i na? ");
INSERT INTO mmx_vpl VALUES ("MK14_5","071_14_5","MRK","14","5","5","Ni i epovo ri sesep mi na laxadan mavak kusu na lok ka lavantun sangaun kobot (300) denarias teren ti lok tooro limixin banbalo.” La diga paase mukmusak ti mo latkin. ");
INSERT INTO mmx_vpl VALUES ("MK14_6","071_14_6","MRK","14","6","6","Ketla ne Iesu ga lok tidi, “Keke i. Nemen mita lox angtang na latkin, mila neni i lok lavanga nunuan tia. ");
INSERT INTO mmx_vpl VALUES ("MK14_7","071_14_7","MRK","14","7","7","Limixin banbalo mo dinabat pot pasa amisik nimi xusu minak lok tooro di, ketla nenia noxo nemen eburu amisik minimi. ");
INSERT INTO mmx_vpl VALUES ("MK14_8","071_14_8","MRK","14","8","8","La na latkin i lok lavanga avukat tia. Ni i soli na laxadan mavak at labantuxu rak kusu ti lox agagas li labantuxu rak ti lamaaut. ");
INSERT INTO mmx_vpl VALUES ("MK14_9","071_14_9","MRK","14","9","9","A tong tuturun i rinimi. At ua lengkot axap at na lavatbung menemen, limixin dinaba tong asu Lagale Lavavang, la na lavanga neni i lox i, dinaba tong box i xusu limixin dinaklen i.” ");
INSERT INTO mmx_vpl VALUES ("MK14_10","071_14_10","MRK","14","10","10","La ne Judas Iskariot, lara at lasangaun mi legepura lavaun pinivu at ne Iesu ga vot pasa lavamaasa silok kusu neni na song araba ne Iesu ridi. ");
INSERT INTO mmx_vpl VALUES ("MK14_11","071_14_11","MRK","14","11","11","La nedi diga lok momo aleng la diga tong i ri ne Judas do nedi diba raba i mi lempilas. La ne Judas ga ngangais ti toxonaleng kusu naba epovo rin ti song araba ne Iesu ridi. ");
INSERT INTO mmx_vpl VALUES ("MK14_12","071_14_12","MRK","14","12","12","At laaleng avot ap mo leluxa limixin me Judaia diga gagas li lengkongkide. Ap mo laaleng diga sep laxanat sipsip la diga ove i la diga anan i. Lavaun pinivu at ne Iesu diga sue i xeretna, “U vara i do mana lox agagas li laanan tidik ua?” ");
INSERT INTO mmx_vpl VALUES ("MK14_13","071_14_13","MRK","14","13","13","La ne Iesu ga lok katling legepura atdi la ga lok tidu xeretna, “Mo do muna beles ukeneng at lemenemen silok, lara laradi nabap kip lubuxom dan naba xip tangarang ka numu. ");
INSERT INTO mmx_vpl VALUES ("MK14_14","071_14_14","MRK","14","14","14","Muna mumu asu i uto at loogu ni na beles teren. La muna lok ti laradi at loogu xeretna, ‘Leeme loklox ase i sue u do, loxot ua at na loogu ram, neni eburu mi lavaun pinivu ren diba lok katling leluxa at Lovovolo Pe ve?’ ");
INSERT INTO mmx_vpl VALUES ("MK14_15","071_14_15","MRK","14","15","15","La neni naba lox ase numu mi loxot silok, diga gagas li vam i no i nemen to vana ap mo loogu. Muna gagas li lempanga anan tidik go.” ");
INSERT INTO mmx_vpl VALUES ("MK14_16","071_14_16","MRK","14","16","16","La nedu duga vas kaxat la dugat pas uto at nom lemenemen, la duga long lenget ka lempanga xerekngan ne Iesu gara tong pam i ridu, la duga lox agagas li leveluxa ri Lovovolo Pe. ");
INSERT INTO mmx_vpl VALUES ("MK14_17","071_14_17","MRK","14","17","17","Ga ukantinao ne Iesu mi lavaun pinivu ren diga rupot. ");
INSERT INTO mmx_vpl VALUES ("MK14_18","071_14_18","MRK","14","18","18","La diga xis la digara anan, la ne Iesu ga lok tidi xeretna, “A tong tuturun i rinimi, lara atnimi naba song araba ia ri lavamaasa silok. Mo it kis de la i anan eburu minia.” ");
INSERT INTO mmx_vpl VALUES ("MK14_19","071_14_19","MRK","14","19","19","La diga lok bukbulu la nedi getgesara diga sue i xeretna, “Kopmen nenia, do?” ");
INSERT INTO mmx_vpl VALUES ("MK14_20","071_14_20","MRK","14","20","20","La neni ga vorang i ridi xeretna, “Neni lara atnemi lasangaun mi legepura. Mo lara i lok kaka lengkompanga anan eburu minia at loxot lili panga anan. ");
INSERT INTO mmx_vpl VALUES ("MK14_21","071_14_21","MRK","14","21","21","Nenia, Laradi Mevana, anaba met kerekngan Lovoang Kaala i tong i, ketla naba lok kapmek aleng ti mo laradi naba song araba ia ri lavamaasa silok. Gitaba lox avukat do nenen gitoxo visik ka i.” ");
INSERT INTO mmx_vpl VALUES ("MK14_22","071_14_22","MRK","14","22","22","Move diga anan, la ne Iesu ga lok kaka loxongkide, ga tong avukat ti ne Moroa la ga sebex i la ga raba lavaun pinivu ren min la ga lok, “Mina lok kaka i na. Labantuxu rak na.” ");
INSERT INTO mmx_vpl VALUES ("MK14_23","071_14_23","MRK","14","23","23","La neni ga lok kaka lakap inin, la ga tong avukat ti ne Moroa, la ga raba di min la nedi axap diga inin teren. ");
INSERT INTO mmx_vpl VALUES ("MK14_24","071_14_24","MRK","14","24","24","La ni ga lok, “Lada rak na. I lok katling lekabus maxat. Lada rak naba sen su kusu ti limixin buaang, ne Moroa naba doxoma xepe leveloklok kakapmek atnedi. ");
INSERT INTO mmx_vpl VALUES ("MK14_25","071_14_25","MRK","14","25","25","A tong tuturun i rinimi, nenia noxo in at lavaen i ru xaka i lingina se ap mo laaleng nia anaba in lavaen maxat to xeneng at Linintoo at ne Moroa.” ");
INSERT INTO mmx_vpl VALUES ("MK14_26","071_14_26","MRK","14","26","26","La digak pixan mi loxompixan la diga vas kaxat uto at Lakaana Olip. ");
INSERT INTO mmx_vpl VALUES ("MK14_27","071_14_27","MRK","14","27","27","La ne Iesu ga lok tidi xeretna, “Nemi axap minaba subu basinge ia. I lok ngan Lovoang Kaala i lok keretna, ‘Nenia ne Moroa, anaba sep laradi loklok tatao at laxasipsip, la lubung sipsip dinaba epeseves.’” ");
INSERT INTO mmx_vpl VALUES ("MK14_28","071_14_28","MRK","14","28","28","La ne Iesu ga lok bok tidi, “Ketla melemu at laxakatu kaxat amlong tarak anabamgo rinimi uto Galili.” ");
INSERT INTO mmx_vpl VALUES ("MK14_29","071_14_29","MRK","14","29","29","La ne Pita ga lok tin, “Keke i do nedi axap dina subu basinge u, nenia xopmen tinotno a noxo subu.” ");
INSERT INTO mmx_vpl VALUES ("MK14_30","071_14_30","MRK","14","30","30","La ne Iesu ga lok tin keretna, “Nia a tong tuturun i ru. Lingina at laxanimin laxaxak kovisi noxo reng gepura la nenu unaba sev apkap naba vantun do uxoklen ia.” ");
INSERT INTO mmx_vpl VALUES ("MK14_31","071_14_31","MRK","14","31","31","Ketla ne Pita ga paase lolos tin, “Do di lok do dina sev amer ia, nenia noxo sok tixirixes u.” La lavaun pinivu axap diga tong box i xuren. ");
INSERT INTO mmx_vpl VALUES ("MK14_32","071_14_32","MRK","14","32","32","La diga rupot to at lara laraamang laasen teren Getesemane, la ne Iesu ga lok ti lavaun pinivu ren keretna, “Mina xis de la ana lok be lising.” ");
INSERT INTO mmx_vpl VALUES ("MK14_33","071_14_33","MRK","14","33","33","La ni ga lam ka ne Pita, ne Jems la ne Jon, la lainbulu silok ga suxuna lorooro ren. ");
INSERT INTO mmx_vpl VALUES ("MK14_34","071_14_34","MRK","14","34","34","La ni ga lok tidi, “Lorooro rak i umsu mi lainbulu silok la i auret kusu na lox amer ia. Minak lok de la mina kuxut tangais ia.” ");
INSERT INTO mmx_vpl VALUES ("MK14_35","071_14_35","MRK","14","35","35","La ni ga vas uto vaxalom lixilik la ni ga subu midi mi lemeren uto xopok at laxangka la ga sing ne Moroa do i epovo na lok kepe mo lumumuat naba rupot saparav i ap mo laaleng. ");
INSERT INTO mmx_vpl VALUES ("MK14_36","071_14_36","MRK","14","36","36","Ni ga lok keretna, “Tamak, u epovo una lok lempanga axap. Kereva, i epovo do una lok pes na lumumuat basinge ia. Ketla nemen gat uta mumu asu lavavara rak, una mu asu mun lavavara ram.” ");
INSERT INTO mmx_vpl VALUES ("MK14_37","071_14_37","MRK","14","37","37","La ni gamlong saparap lavaun pinivu ren la ga ven lenget ka di, diga unga la ni ga lok ti ne Pita, “Simon, tila u unga? Kereva, uxo epovo unap kip na lumumuat eburu minia at loxonaleng lixilik mun? ");
INSERT INTO mmx_vpl VALUES ("MK14_38","071_14_38","MRK","14","38","38","Mina reven tatao la mina ngising kusu mi noxo subu at loklok tong pen. Loroonan at laradi i epovo na ronga res, ketla labantuxu ixo lolos.” ");
INSERT INTO mmx_vpl VALUES ("MK14_39","071_14_39","MRK","14","39","39","La ne Iesu ga vas xakalik manga la ga sing ngan no avot. ");
INSERT INTO mmx_vpl VALUES ("MK14_40","071_14_40","MRK","14","40","40","La ne Iesu gamlong saparap di, la ga ven lenget ka di, diga unga manga, mila lemerendi ga muat. La di goxoklen i do dina tong toxolinga salai rin. ");
INSERT INTO mmx_vpl VALUES ("MK14_41","071_14_41","MRK","14","41","41","La ne Iesu gat pas, la ga lok lising la gamlong sepsev avantun la ga lok tidi, “Kereva, move mi unga? I epovo vam. Loxonaleng ira rupot pam do dina song araba ia, Laradi Mevana, ti limixin kakapmek. ");
INSERT INTO mmx_vpl VALUES ("MK14_42","071_14_42","MRK","14","42","42","Mina xatu. Ata vas tangarang mo laradi na song araba ia, nom boro it pas.” ");
INSERT INTO mmx_vpl VALUES ("MK14_43","071_14_43","MRK","14","43","43","La ne Iesu move ga paase la soso mun ne Judas, lara at lavaun pinivu at ne Iesu ga rupot la buaang nedi luvuttadi diga emu min. Digap kip lemparise sepsep la levempukup sepsep. Lavamaasa silok la luvuttadi loklox ase at Laulis Linga, la loxongkulao silok diga riki di. ");
INSERT INTO mmx_vpl VALUES ("MK14_44","071_14_44","MRK","14","44","44","Avot ti na, ne Judas ga tong li loklok katling kusu diba ven kibis ne Iesu. Judas ga lok tidi, “Mo lara, nia aba nes i, neni vam ne Iesu. Mina ranga alis i.” ");
INSERT INTO mmx_vpl VALUES ("MK14_45","071_14_45","MRK","14","45","45","La soso mun ne Judas ga vot pasa ne Iesu la ga lok tin, “Rabai.” La neni ga nes ne Iesu. ");
INSERT INTO mmx_vpl VALUES ("MK14_46","071_14_46","MRK","14","46","46","La diga vas kaxat la diga ranga alis ka ne Iesu. ");
INSERT INTO mmx_vpl VALUES ("MK14_47","071_14_47","MRK","14","47","47","La lara at lavaun pinivu ga tu auret la ga rev asu lavarise sepsep teren la ga sep korop kepe labaalung at lasaxaruki at lamaasa gomgo. ");
INSERT INTO mmx_vpl VALUES ("MK14_48","071_14_48","MRK","14","48","48","La ne Iesu ga lok tidi xeretna, “Tila nimi mi vot de mi levemparise sepsep la levengkonbom sepsep kusu mina ranga alis ia? Nenia xopmen ana vaxaru kaxat ka leesep. ");
INSERT INTO mmx_vpl VALUES ("MK14_49","071_14_49","MRK","14","49","49","Buaang levenaleng nia agat kis to xeneng at loogu laplavang kusu ana anasa limixin, ketla nemi mi goxo ranga alis ka be ia go. Ketla mi ranga alis ia xerekngan lavapaase at Lovoang Kaala i tong i.” ");
INSERT INTO mmx_vpl VALUES ("MK14_50","071_14_50","MRK","14","50","50","La lavaun pinivu ren diga sixiro axap. ");
INSERT INTO mmx_vpl VALUES ("MK14_51","071_14_51","MRK","14","51","51","La lara laau maxat ga mumu asu ne Iesu, neni ga siga mene lavanga singsiga nunuan. Diga ranga alis i, ");
INSERT INTO mmx_vpl VALUES ("MK14_52","071_14_52","MRK","14","52","52","ketla neni ga sixiro beleben, ga ke lavanga singsiga ren mila diga rebeng alis ka i. ");
INSERT INTO mmx_vpl VALUES ("MK14_53","071_14_53","MRK","14","53","53","La diga lam ka ne Iesu uto at lamaasa gomgo. La lavamaasa silok mi loxongkulao silok mi luvuttadi loklox ase at Laulis Linga diga rupot bok. ");
INSERT INTO mmx_vpl VALUES ("MK14_54","071_14_54","MRK","14","54","54","La ne Pita ga mumu asu ne Iesu ro xa vaxalom lixilik la ga vubeles at lemelua saparap loogu at lamaasa gomgo. La neni gat kis mamain eburu mi luvuttadi rutu mu. ");
INSERT INTO mmx_vpl VALUES ("MK14_55","071_14_55","MRK","14","55","55","La lavamaasa silok la luvuttadi amgomgo axap diga puse ri tevelinga xaxarang kusu dina xarang taba ne Iesu min la dinaba epovo xusu dina sev amer i, ketla digoxo epovo. ");
INSERT INTO mmx_vpl VALUES ("MK14_56","071_14_56","MRK","14","56","56","La buaang limixin diga bala raba i, ketla lavapaase atdi goxo sixit eburu. ");
INSERT INTO mmx_vpl VALUES ("MK14_57","071_14_57","MRK","14","57","57","La melemu lentaba diga xatu kaxat la diga bala raba i xeretna, ");
INSERT INTO mmx_vpl VALUES ("MK14_58","071_14_58","MRK","14","58","58","“Maga ronga levelinga ren keretna, ‘Nenia anaba sele utut kepe na loogu laplavang, no luvuttadi diga vaxaru i. La keneng at lavantun aleng nenia anaba vaxaru kaxat bok tara, luvuttadi di noxo gugu i.’” ");
INSERT INTO mmx_vpl VALUES ("MK14_59","071_14_59","MRK","14","59","59","La levempapaase atdi move goxo sixit emu. ");
INSERT INTO mmx_vpl VALUES ("MK14_60","071_14_60","MRK","14","60","60","La lamaasa gomgo ga lok li ne Iesu to kantubu atdi la ga sue i, “Ua lavasuun teren la uxo vaase? U xopara na vorang na levelinga di sok taba u min?” ");
INSERT INTO mmx_vpl VALUES ("MK14_61","071_14_61","MRK","14","61","61","Ketla ne Iesu goxo vaase la goxo vorang i rin la lamaasa gomgo ga sue i, “Kereva, nenu Lanarong, Nitna ne Moroa, Leeme Avolo?” ");
INSERT INTO mmx_vpl VALUES ("MK14_62","071_14_62","MRK","14","62","62","La ne Iesu ga vorang i rin keretna, “Nenia vam. La nemi minaba ven ia, Laradi Mevana, anabat kis saparap lekngen tino at Lanaraavuk la anaba vot eburu mi lenbantakabu boro vana at laxalibet.” ");
INSERT INTO mmx_vpl VALUES ("MK14_63","071_14_63","MRK","14","63","63","La lamaasa gomgo ga lais korop lavanga singsiga ren, la ga lok, “I paase vupu ri ne Moroa. Keke tevelinga bok ba. ");
INSERT INTO mmx_vpl VALUES ("MK14_64","071_14_64","MRK","14","64","64","Mira ronga vam levelinga ren. Nemi mi doma xereva?” La diga vorang i do i epovo ne Iesu na met. ");
INSERT INTO mmx_vpl VALUES ("MK14_65","071_14_65","MRK","14","65","65","La diga xalaubis lemeren la diga lok pe luxatli ren la diga tir i, la diga lok tin keretna, “Una tong kibis i do nege ip sev u?” La luvuttadi esep diga lam kaka i la diga pasa box i. ");
INSERT INTO mmx_vpl VALUES ("MK14_66","071_14_66","MRK","14","66","66","La ne Pita gak lok to xamang at lemelua la lara loono maxat ga rupot, neni lasaxaruki at lamaasa gomgo. ");
INSERT INTO mmx_vpl VALUES ("MK14_67","071_14_67","MRK","14","67","67","Neni ga ven ne Pita gat kis mamain la ga ven tooro i la ga lok, “Nenu bok ugak lok eburu mi ne Iesu me Nasaret.” ");
INSERT INTO mmx_vpl VALUES ("MK14_68","071_14_68","MRK","14","68","68","Ketla ne Pita ga lok, “Nia axoklen lavanga salai u paase min.” La ni gat pas uto at loxot povolo at lemelua. ");
INSERT INTO mmx_vpl VALUES ("MK14_69","071_14_69","MRK","14","69","69","La melemu nom loono ga ven manga ne Pita la ga lok ti luvuttadi diga tu go, “Neni nom, lara at lavaun pinivu at ne Iesu.” ");
INSERT INTO mmx_vpl VALUES ("MK14_70","071_14_70","MRK","14","70","70","La ne Pita ga sev apkap manga. La melemu lentaba diga tu saparap ne Pita, diga lok tin keretna, “I ruturun, nenu lara atdi mila nenu bok boro Galili.” ");
INSERT INTO mmx_vpl VALUES ("MK14_71","071_14_71","MRK","14","71","71","La ne Pita ga vangpe mi levelinga vangpangpe xeretna, “Levelinga rak i ruturun. Do xopmen, ne Moroa na lox asongor ia. Nia axoklen mo laradi.” ");
INSERT INTO mmx_vpl VALUES ("MK14_72","071_14_72","MRK","14","72","72","La soso mun laxaxak ga reng sepsev agepura. La ne Pita ga doma asu at lavapaase at ne Iesu ga lok keretna, “Laxaxak kovisi noxo reng gepura, la nenu unaba sev apkap naba sev avantun do uxoklen ia.” La ne Pita gang teng. ");
INSERT INTO mmx_vpl VALUES ("MK15_1","071_15_1","MRK","15","1","1","Ga maxantamak suubu lavamaasa silok mi loxongkulao silok la luvuttadi loklox ase at Laulis Linga, nedi lavaeme silok axap diga rupot eburu la diga epaase mumu ne Iesu. La diga xoxo alis lukngen la diga lam taba ne Paelat min. ");
INSERT INTO mmx_vpl VALUES ("MK15_2","071_15_2","MRK","15","2","2","La ne Paelat ga sue ne Iesu xeretna, “Nenu loorong at limixin me Judaia?” La ne Iesu ga vorang i rin keretna, “I ruturun. Nenu xa ura tong pam i.” ");
INSERT INTO mmx_vpl VALUES ("MK15_3","071_15_3","MRK","15","3","3","La lavamaasa silok diga sok taba i mi laxalinga buaang. ");
INSERT INTO mmx_vpl VALUES ("MK15_4","071_15_4","MRK","15","4","4","La ne Paelat ga sue box i xeretna, “Kereva, u xopara na vorang levelinga atdi? Una ronga ba di, di sok taba u mi laxalinga solo.” ");
INSERT INTO mmx_vpl VALUES ("MK15_5","071_15_5","MRK","15","5","5","Ketla ne Iesu xopmen goxo vorang levelinga atdi la ne Paelat ga sangu aleng. ");
INSERT INTO mmx_vpl VALUES ("MK15_6","071_15_6","MRK","15","6","6","At levenmaares axap laradi gomgo boro Rom ga mu asu lara loklok. At leluxa silok at Lovovolo Pe, neni gak soxomus asu lara laradi xokoxo do limixin diga lok katling i. ");
INSERT INTO mmx_vpl VALUES ("MK15_7","071_15_7","MRK","15","7","7","La lara laradi, laasen teren ne Barabas gak lok to at loogu xokoxo. Ganoxa neni mi luvuttadi vetpes diga esep eburu mi luvuttadi esep kusu dina lok kepe lagavaman, la neni ga sev amet lentaba. ");
INSERT INTO mmx_vpl VALUES ("MK15_8","071_15_8","MRK","15","8","8","La limixin ap mo leluxa diga rupot pasa ne Paelat kusu neni na lox asu tara taradi gak lok to at loogu xokoxo. ");
INSERT INTO mmx_vpl VALUES ("MK15_9","071_15_9","MRK","15","9","9","La ne Paelat ga sue di, “Mi vara i do nenia na lox asu loorong atnemi limixin me Judaia?” ");
INSERT INTO mmx_vpl VALUES ("MK15_10","071_15_10","MRK","15","10","10","Paelat gaklen i do lavamaasa silok diga reven peves at ne Iesu la ni lavasuun teren la diga vara i do dina sev amer i. ");
INSERT INTO mmx_vpl VALUES ("MK15_11","071_15_11","MRK","15","11","11","Ketla lavamaasa silok diga lox axatu levendoxoma at limixin kusu dina sing ne Paelat do neni na lox asu ne Barabas. ");
INSERT INTO mmx_vpl VALUES ("MK15_12","071_15_12","MRK","15","12","12","La ne Paelat ga sue di, “La nia ana lok lavanga salai mi na laradi mi so asen i mi loorong at limixin me Judaia?” ");
INSERT INTO mmx_vpl VALUES ("MK15_13","071_15_13","MRK","15","13","13","La digap kup silok tin xeretna, “Paxarem i at laxaba.” ");
INSERT INTO mmx_vpl VALUES ("MK15_14","071_15_14","MRK","15","14","14","La ne Paelat ga sue bok, “Tila? Neni ga lok laxakapmek salai?” Ketla digap kup silok aleng keretna, “Paxarem i at laxaba.” ");
INSERT INTO mmx_vpl VALUES ("MK15_15","071_15_15","MRK","15","15","15","Kuren la ne Paelat ga mu asu lavavara atdi la ga lox asu raba di mi ne Barabas. Ketla neni ga raba ne Iesu ti luvuttadi esep kusu dinak pixis i la dina vaxarem i at laxaba. ");
INSERT INTO mmx_vpl VALUES ("MK15_16","071_15_16","MRK","15","16","16","La luvuttadi esep diga lam ka ne Iesu uto at loogu nunuan at laradi gomgo la diga ro bubua ka nedi axap luvuttadi esep. ");
INSERT INTO mmx_vpl VALUES ("MK15_17","071_15_17","MRK","15","17","17","La diga vaxasiga i mi lavanga singsigaara at loorong la diga lok lixiam tin mi laban gagas la diga vaxaxua lavatlak teren min. Diga lok mo lempanga xusu ti saba xangka i. ");
INSERT INTO mmx_vpl VALUES ("MK15_18","071_15_18","MRK","15","18","18","La diga lok keretna, “Ma lok ngangao ram loorong at limixin me Judaia.” ");
INSERT INTO mmx_vpl VALUES ("MK15_19","071_15_19","MRK","15","19","19","La digak pixis patlak aleng i mi lakdak la diga vubis sanga i. La diga xis tiktikbu mi lempatgulom atdi la diga emi asu sese min. ");
INSERT INTO mmx_vpl VALUES ("MK15_20","071_15_20","MRK","15","20","20","Diga lok kalise axav i la diga lok pes lavanga singsigaara basinge i la diga vaxasiga manga i mi lavanga singsiga xa ren. La diga sat ka i basinge mo loogu silok kusu dina vaxarem i at laxaba. ");
INSERT INTO mmx_vpl VALUES ("MK15_21","071_15_21","MRK","15","21","21","La lara laradi, laasen teren ne Simon me Sairini, neni temen ne Aleksanda mi ne Rupas, la neni gat pas boro at lemenemen petpes la luvuttadi esep diga sox aruru parang i xusu na xip ka laxaba at ne Iesu. ");
INSERT INTO mmx_vpl VALUES ("MK15_22","071_15_22","MRK","15","22","22","La diga lam ka ne Iesu uto at lenep, loxonasen kot go do Golgata. Lavasuun at na loxolinga do, “Lavatlak Tongan.” ");
INSERT INTO mmx_vpl VALUES ("MK15_23","071_15_23","MRK","15","23","23","La diga lok do dina raba i mi lavaen diga lok eburu mi lara laxadan mamao di tong i do mur, ketla ne Iesu goxopara i. ");
INSERT INTO mmx_vpl VALUES ("MK15_24","071_15_24","MRK","15","24","24","La diga vaxarem i ro vana at laxaba la melemu diga lu buru mi lengkonuat kusu ti lok kisip ka nege ba lok ka lempanga singsiga ren. ");
INSERT INTO mmx_vpl VALUES ("MK15_25","071_15_25","MRK","15","25","25","Diga vaxarem ne Iesu ga maxantamak at lavasik konaleng. ");
INSERT INTO mmx_vpl VALUES ("MK15_26","071_15_26","MRK","15","26","26","To mavana at lavatlak teren diga lok li levelinga, mo ga tong asu lavasuun at lumumuat teren. Nom levelinga ga lok keretna, Loorong At Limixin Me Judaia. ");
INSERT INTO mmx_vpl VALUES ("MK15_27","071_15_27","MRK","15","27","27","La diga vaxarem bok legepu radi xipkip pilo saparap ne Iesu, lara saparap lekngen tino la lara saparap lekngen kia. ");
INSERT INTO mmx_vpl VALUES ("MK15_28","071_15_28","MRK","15","28","28","Levelinga at ne Aisaia, leeme vapaase ali at ne Moroa ga ravasu ruturun keretna, “Limixin diga doma i do neni bok laradi xapmek.” ");
INSERT INTO mmx_vpl VALUES ("MK15_29","071_15_29","MRK","15","29","29","La limixin digat pas polo go la diga piripat lempatlak atdi la diga paase aksaksa ri ne Iesu xeretna, “Nenu ga lok do unaba sele utut kepe loogu laplavang la unaba vaxaru amu box i at lavantun aleng, ");
INSERT INTO mmx_vpl VALUES ("MK15_30","071_15_30","MRK","15","30","30","una eng si ukopok la una lox aroo axa u.” ");
INSERT INTO mmx_vpl VALUES ("MK15_31","071_15_31","MRK","15","31","31","La kerepmo bok lavamaasa silok mi luvuttadi loklox ase at Laulis Linga diga paase aksaksa. Diga lok keretna, “Neni ga lox aroo lentaba vetpes, ketla neni ixo epovo do na lox aroo axa i. ");
INSERT INTO mmx_vpl VALUES ("MK15_32","071_15_32","MRK","15","32","32","Mo do neni Lanarong at ne Moroa la loorong at limixin me Israel, neni na eng si ukopok la nedik ataba nunu ba ren.” Luradi duga merem saparav i, nedu bok duga paase rin mi laxalinga xapmek. ");
INSERT INTO mmx_vpl VALUES ("MK15_33","071_15_33","MRK","15","33","33","At lasangaun mi legepu xonaleng, laxangking ga xis tubu la lamain ga vung pavaa mo lenep silok axap la gak lok se at lavantun konaleng. ");
INSERT INTO mmx_vpl VALUES ("MK15_34","071_15_34","MRK","15","34","34","La at lavantun konaleng ne Iesu ga xup silok keretna, “Eloi, Eloi, lama sabaktani!” Lavasuun at na levelinga xeretna, “Moroa rak, Moroa rak, tila u raba rulu ia?” ");
INSERT INTO mmx_vpl VALUES ("MK15_35","071_15_35","MRK","15","35","35","Lentaba luvuttadi diga tu go, diga ronga i la diga lok, “Ata ronga i, neni i toro ri ne Elaisa.” ");
INSERT INTO mmx_vpl VALUES ("MK15_36","071_15_36","MRK","15","36","36","La lara laradi ga sixit, la ga lok ka loxontamon la ga lox amlu xaka i ro xeneng at lavaen mamao la ga xoxo li i ro at loxonuna la ga lok do na vaxain ne Iesu min, la ga lok keretna, “Ata ven be i do ne Elaisa go naba rupot ti lok tooro i.” ");
INSERT INTO mmx_vpl VALUES ("MK15_37","071_15_37","MRK","15","37","37","La ne Iesu ga xup silok la ga met. ");
INSERT INTO mmx_vpl VALUES ("MK15_38","071_15_38","MRK","15","38","38","La ap mo loxonaleng lavattamon silok ga merem to xeneng at loogu laplavang ga rem lais ka ro vana, ga su ro xopok la ga ra ngan ta legepu ban. ");
INSERT INTO mmx_vpl VALUES ("MK15_39","071_15_39","MRK","15","39","39","La laasesep ga tu go xopok to melamgo at ne Iesu ga ronga luxupkup teren la ga ven lanmet teren. Kuren la neni ga lok, “Neni lamdak tuturun pam at ne Moroa.” ");
INSERT INTO mmx_vpl VALUES ("MK15_40","071_15_40","MRK","15","40","40","Lentaba lavakin mo diga tu ro vaxalom diga reven lanmet at ne Iesu. Levenasen atdi, Maria Magdalene, Maria nenen ne Jems kakalik mi ne Joses la ne Salomi. ");
INSERT INTO mmx_vpl VALUES ("MK15_41","071_15_41","MRK","15","41","41","Ganoxa nedi diga mumu asu ne Iesu ap mo levenaleng neni ga nemen to Galili la diga lok tooro i. Lavakin petpes bok mo diga mumu asu ne Iesu uto Jerusalem. ");
INSERT INTO mmx_vpl VALUES ("MK15_42","071_15_42","MRK","15","42","42","Mo laaleng Iesu ga met teren, ni laaleng gagas, la laaleng avot ti laaleng kaala. ");
INSERT INTO mmx_vpl VALUES ("MK15_43","071_15_43","MRK","15","43","43","Ga ukantinao Josep me Arimatia neni lara at lavaeme silok at limixin me Judaia la neni ga ngangais ti Linintoo at ne Moroa. Neni goxo marat la ga vot pasa ne Paelat la ga sing i do neni na raba i mi labantuxu at ne Iesu. ");
INSERT INTO mmx_vpl VALUES ("MK15_44","071_15_44","MRK","15","44","44","La ne Paelat ga sangu do ne Iesu gara met pam. La neni ga ro ka laasesep teren la ga sue i dola ne Iesu ira met pam kopla kopmen. ");
INSERT INTO mmx_vpl VALUES ("MK15_45","071_15_45","MRK","15","45","45","La mo laasesep ga tong i rin do mo levelinga i ruturun. La ne Paelat ga siam ta do ne Josep na lok ka labantuxu at ne Iesu. ");
INSERT INTO mmx_vpl VALUES ("MK15_46","071_15_46","MRK","15","46","46","La ne Josep ga lok ka labantamon maxat la ga lox asi labantuxu at ne Iesu ukopok, la ga bom i mi nom labantamon. La diga lok li i ro xeneng at lamaaut, no diga xe i ro xeneng at lavaruat silok. La ne Josep ga xavun pe lumusmaragu at lamaaut mi lavaruat. ");
INSERT INTO mmx_vpl VALUES ("MK15_47","071_15_47","MRK","15","47","47","La ne Maria Magdalene mi ne Maria nenen ne Joses duga ven katling mo loxot, lamaaut at ne Iesu gak lok teren. ");
INSERT INTO mmx_vpl VALUES ("MK16_1","071_16_1","MRK","16","1","1","Se laaleng kaala ga xap, Maria Magdalene, Maria nenen ne Jems la ne Salomi diga un kaka laxadan somavak kusu dina lok li i at labantuxu at ne Iesu. ");
INSERT INTO mmx_vpl VALUES ("MK16_2","071_16_2","MRK","16","2","2","Ga maxantamak suubu at laaleng avot ap mo luik, laxangking ga losu la nedi lavakin digat pas uto at lamaaut at ne Iesu. ");
INSERT INTO mmx_vpl VALUES ("MK16_3","071_16_3","MRK","16","3","3","Diga esue xeretna, “Nege naba xavun kepe lavaruat mo ik lok pe lungusungus ap mo lamaaut?” ");
INSERT INTO mmx_vpl VALUES ("MK16_4","071_16_4","MRK","16","4","4","Se diga rupot go, diga milik upana la diga ven i do lara ga xavun kepe vam mo lavaruat silok basinge lamaaut. ");
INSERT INTO mmx_vpl VALUES ("MK16_5","071_16_5","MRK","16","5","5","Diga vubeles at lamaaut, la diga ven lara laradi maxat, levesingsigaara ren ganbun aleng la neni gat kis at lenep tino la diga lingun teren. ");
INSERT INTO mmx_vpl VALUES ("MK16_6","071_16_6","MRK","16","6","6","La neni ga lok tidi xeretna, “Nemen gat mita marat. Mi puse ri ne Iesu me Nasaret no ga rem at laxaba. Ketla neni ira roo xat pam. Mina ven loxot diga vaxamdi i ren, neni xopmen nak lok bok ba de. ");
INSERT INTO mmx_vpl VALUES ("MK16_7","071_16_7","MRK","16","7","7","Mina onon la mina vot pasa ne Pita mi lavaun pinivu at ne Iesu la mina tong i ridi do ne Iesu iramgo vam tidi uto Galili. La dina mumu asu i la dinaba ven i ngan neni ga tong pam i ridi.” ");
INSERT INTO mmx_vpl VALUES ("MK16_8","071_16_8","MRK","16","8","8","La nom lavakin diga dede la diga rangku mi lanmarat la diga sixisu boro xeneng at lamaaut la diga sixiro. La di goxo tong na lavanga ti tara mila diga marat. ");
INSERT INTO mmx_vpl VALUES ("MK16_9","071_16_9","MRK","16","9","9","La ne Iesu ga roo xat amlong at laaleng avot ap mo luik. La ne Maria Magdalene ga ven avor i, ganoxa ne Iesu ga riki xepe lavanuti lubunggas basinge i. ");
INSERT INTO mmx_vpl VALUES ("MK16_10","071_16_10","MRK","16","10","10","La ne Maria gamlong la ga vot pasa nedi diga mumu asu ne Iesu. Diga duudu la digang teng mumu ne Iesu la ne Maria ga tong i ridi do neni ga ven pam ne Iesu. ");
INSERT INTO mmx_vpl VALUES ("MK16_11","071_16_11","MRK","16","11","11","At loxonaleng diga ronga i nom, di goxo nunu do ne Iesu mo ga roo xat pam la ne Maria ga ven i. ");
INSERT INTO mmx_vpl VALUES ("MK16_12","071_16_12","MRK","16","12","12","La melemu legepura at lavaun pinivu at ne Iesu dugat pas uto at lara lemenemen la duga ven ne Iesu ga ruuna levereven petpes. ");
INSERT INTO mmx_vpl VALUES ("MK16_13","071_16_13","MRK","16","13","13","La melemu dugamlong la duga tong i ri lavaun pinivu ren, ketla di goxo nunu atdu. ");
INSERT INTO mmx_vpl VALUES ("MK16_14","071_16_14","MRK","16","14","14","La melemu ne Iesu ga vot pasa lasangaun mi legesara lavaun pinivu ren at loxonaleng diga anan. La neni ga vaase sok di mila lununu atdi goxo lolos la di goxo nunu atnedi diga ven pam i. ");
INSERT INTO mmx_vpl VALUES ("MK16_15","071_16_15","MRK","16","15","15","La neni ga lok tidi xeretna, “Mina onon uto at levengkot axap at na lavatbung menemen la mina tong asu Lagale Lavavang tarak ti limixin axap. ");
INSERT INTO mmx_vpl VALUES ("MK16_16","071_16_16","MRK","16","16","16","Dola tara na nunu at Lagale Lavavang tarak la na lok ka lesep susu, neni naba roo su. Dola tara noxo nunu at Lagale Lavavang tarak, neni naba seeve. ");
INSERT INTO mmx_vpl VALUES ("MK16_17","071_16_17","MRK","16","17","17","Nedi di nunu at Lagale Lavavang tarak, Moroa naba raba di mi leveloklok katling keretna. At laasen tarak dinaba riki xepe lubunggas basinge limixin. La dinaba paase mi levempapaase vetpes. ");
INSERT INTO mmx_vpl VALUES ("MK16_18","071_16_18","MRK","16","18","18","La dinaba rebeng kaka levesii xapmek la limixin dinaba sep sak di, ketla di noxo meres la di noxo met, la dinaba lok li levengkikngen di at limixin mekmeres la nom limixin dinaba lox avukat.” ");
INSERT INTO mmx_vpl VALUES ("MK16_19","071_16_19","MRK","16","19","19","Se Leeme Silok ne Iesu ga vaase axap, Moroa ga lam ka i uto vana at laxalibet la neni ga xis saparap lekngen tino at ne Moroa. ");
INSERT INTO mmx_vpl VALUES ("MK16_20","071_16_20","MRK","16","20","20","La lavaun pinivu ren diga vas kaxat la diga tong asu Lagale Lavavang to at levengkot axap la Leeme Silok ga gugu eburu midi la ga lox aruturun lavapaase atdi mi lempanga sangsangu. ");
INSERT INTO mmx_vpl VALUES ("LK1_1","072_1_1","LUK","1","1","1","Saparap leeme silok, ne Tiopilas. Buaang nedi limixin diga lok tong i do dina malagan levelinga at lempanga ne Moroa ga lox i xantubu atnama at lukngen ne Iesu. ");
INSERT INTO mmx_vpl VALUES ("LK1_2","072_1_2","LUK","1","2","2","Diga malagan ali lugugu at ne Iesu, mo maga ronga i boro atnedi diga ven na lempanga at lavakpaxaru kaxat teren, la diga tong asu na Lagale Lavavang. ");
INSERT INTO mmx_vpl VALUES ("LK1_3","072_1_3","LUK","1","3","3","La nenia bok agara sue avukat ka vam levelinga mumu lorooro axap at ne Iesu. Kuren la a doma i do i lox avukat kusu ana malagan akmokso lempanga ne Iesu ga lox i. ");
INSERT INTO mmx_vpl VALUES ("LK1_4","072_1_4","LUK","1","4","4","Ak lox i na kusu unaba xasep avukat ap mo levelinga uga ronga vam i mumu ne Iesu. ");
INSERT INTO mmx_vpl VALUES ("LK1_5","072_1_5","LUK","1","5","5","Ap mo levenaleng loorong ne Erodes gam gomgonga ro at lenep silok Judaia. Lara lamaasa, laasen teren ne Sakaria, neni lara atnedi lavamaasa diga nemen keneng at lara loxonbinam tadi, laasen ap mo loxonbinam tadi ne Abaisa. Latkin teren, laasen teren ne Elisabet. Neni eburu mi ne Sakaria boro at livisik li at lamaasa megano ne Aron. ");
INSERT INTO mmx_vpl VALUES ("LK1_6","072_1_6","LUK","1","6","6","Nedu buru duga nemen manmanton at lemeren ne Moroa, la duga mumu asu amisik levelinga at ne Moroa, la leventaangas bok teren. ");
INSERT INTO mmx_vpl VALUES ("LK1_7","072_1_7","LUK","1","7","7","Ketla du goxo ruuna taxamdak, mila ne Elisabet goxo pisik, la nedu lenasun dugak sokso nga. ");
INSERT INTO mmx_vpl VALUES ("LK1_8","072_1_8","LUK","1","8","8","At lara laaleng libinam tadi at ne Sakaria digak lok to at loogu laplavang kusu dina lok lugugu atdi at lemeren ne Moroa, la ne Sakaria bok ga gugu. ");
INSERT INTO mmx_vpl VALUES ("LK1_9","072_1_9","LUK","1","9","9","La diga soxolik ka i xusu na xotos levempavaxan una i so mavak to xeneng at Loxot Kaala at loogu laplavang. Diga soxolik ka i mi lara loklok at leme Judaia. Lavamaasa diga lu buru mi levenuat, la luuat at ne Sakaria ga subu avot at laxangka. ");
INSERT INTO mmx_vpl VALUES ("LK1_10","072_1_10","LUK","1","10","10","At loxonaleng ti xotos levempavaxan una i so mavak, neni ga beles uto xeneng at Loxot Kaala at loogu laplavang at ne Moroa ti lok mo lavanga to at loxonin laplavang. Limixin lotu diga nemen to maxamang, diga ngising. ");
INSERT INTO mmx_vpl VALUES ("LK1_11","072_1_11","LUK","1","11","11","La lara laangelo at ne Moroa ga rupot saparav i, ga tu ro at lenep tino ap mo loxonin laplavang, Sakaria ga xotos levempavaxan una mavak e. ");
INSERT INTO mmx_vpl VALUES ("LK1_12","072_1_12","LUK","1","12","12","Ni ga ven laangelo la ni ga lingun la ga umsu mi lanmarat. ");
INSERT INTO mmx_vpl VALUES ("LK1_13","072_1_13","LUK","1","13","13","Ketla laangelo ga lok tin, “Sakaria, nemen uta marat, Moroa ira ronga vam levesingising taram, la latkin taram ne Elisabet naba visik tamdak tu. Unaba so asen i mi ne Jon. ");
INSERT INTO mmx_vpl VALUES ("LK1_14","072_1_14","LUK","1","14","14","Nenu unaba momo la una sosoro aleng, la buaang bok nedi dinaba momo aleng mo do latkin taram na visik tamdak, ");
INSERT INTO mmx_vpl VALUES ("LK1_15","072_1_15","LUK","1","15","15","mila neni naba silok tinotno at lemeren ne Moroa. Nemen mo lamdak guta inin taxadan vaen la taxadan lolos. Ap mo laaleng nenen na visix i, neni naba umsu mi Loroonan Kaala. ");
INSERT INTO mmx_vpl VALUES ("LK1_16","072_1_16","LUK","1","16","16","Neni naba sat ka amlong buaang nedi limixin me Israel saparap ne Moroa, Leeme Silok atdi. ");
INSERT INTO mmx_vpl VALUES ("LK1_17","072_1_17","LUK","1","17","17","Neni nabamgo ri Leeme Silok, mi Loroonan Kaala la lolos, i ngan leeme vapaase ali ne Elaisa. Neni naba vaxaxis etangas avukat lavatlok eburu mi laxamdak atdi kusu lavatlok dinaba balamu laxamdak atdi. Neni naba ba gili levendoxoma at limixin tongtonga xepe kusu dina rebeng kaka lodoxoma manmanton. Neni naba lox agagas limixin at ne Moroa kusu dinaba gagas tangais Leeme Silok.” ");
INSERT INTO mmx_vpl VALUES ("LK1_18","072_1_18","LUK","1","18","18","Sakaria ga lok ti laangelo, “Abaklen i xereva do levelinga ram i ruturun? Mila nia laradi asioxo la latkin bok tarak neni iak sokso vam.” ");
INSERT INTO mmx_vpl VALUES ("LK1_19","072_1_19","LUK","1","19","19","Laangelo ga lok tin, “Nenia ne Gabriel. A tu amisik to saparap ne Moroa, mo i sak tiki ia xusu ana vaase tu, la ana tong asu i na levelinga nunuan tu. ");
INSERT INTO mmx_vpl VALUES ("LK1_20","072_1_20","LUK","1","20","20","Ketla uxo nunu at levelinga rak, mo naba soorun at loxonaleng ne Moroa ga vaase ali vam i ren. Kuren la na u noxo epovo una paase, se ap mo laaleng na lavapaase ali rak naba soorun.” ");
INSERT INTO mmx_vpl VALUES ("LK1_21","072_1_21","LUK","1","21","21","Ap mo mene loxonaleng mo limixin diga ngangais ti ne Sakaria, digam doma mumu i do laai mo ni ga lox angtang min to xeneng at Loxot Kaala at loogu laplavang. ");
INSERT INTO mmx_vpl VALUES ("LK1_22","072_1_22","LUK","1","22","22","Se neni ga vas su ukamang, ni goxo epovo na vaase rinedi. Kuren la digaklen i do, ni mo ga ven pam lisilimet to xeneng at Loxot Kaala. Ni ga lok mun leveloklok poovo rinedi mi lukngen. Move ni goxo epovo kusu na vaase. ");
INSERT INTO mmx_vpl VALUES ("LK1_23","072_1_23","LUK","1","23","23","Se neni ga lox axap mo lugugu ren to at loogu laplavang, neni gamlong uto xolonu. ");
INSERT INTO mmx_vpl VALUES ("LK1_24","072_1_24","LUK","1","24","24","Melemu latkin teren ne Elisabet ga renan, la ni ga nemen tino go at loogu ren at lavalimo gaaling. ");
INSERT INTO mmx_vpl VALUES ("LK1_25","072_1_25","LUK","1","25","25","Ni ga lok, “At na bai la ne Moroa ira balamu ba ia at na langas. Nia aga lok mamangan mila a goxo pisik, ketla a renan ta la lainmangan tarak ira xap pam.” ");
INSERT INTO mmx_vpl VALUES ("LK1_26","072_1_26","LUK","1","26","26","At lagaaling sepsev avanna at lereterenan at ne Elisabet, Moroa ga sak tiki laangelo ren, ne Gabriel uto Nasaret, lara lemenemen to at lenep silok Galili. ");
INSERT INTO mmx_vpl VALUES ("LK1_27","072_1_27","LUK","1","27","27","Ni gat pas mi levelinga ti lara loono maxat laasen teren ne Maria, mo diga lok katling i xusu naba epot at lara laradi laasen teren ne Josep, at livisik li at ne Devit, loorong megano. ");
INSERT INTO mmx_vpl VALUES ("LK1_28","072_1_28","LUK","1","28","28","Laangelo ga rupot saparap ne Maria la ga lok tin, “Lenmila na nemen eburu minu! Moroa i nemen eburu minu, la i vara aleng u la ni naba lox anarong u.” ");
INSERT INTO mmx_vpl VALUES ("LK1_29","072_1_29","LUK","1","29","29","Maria ga lingun ap mo levelinga at laangelo, la gam doma mumu lavasuun ap mo levelinga. ");
INSERT INTO mmx_vpl VALUES ("LK1_30","072_1_30","LUK","1","30","30","Ketla laangelo ga lok tin, “Maria, nemen uta marat, mila ne Moroa ira lok momo vam minu. ");
INSERT INTO mmx_vpl VALUES ("LK1_31","072_1_31","LUK","1","31","31","Unaba renan la unaba visik tamdak, la unaba so asen i mi ne Iesu. ");
INSERT INTO mmx_vpl VALUES ("LK1_32","072_1_32","LUK","1","32","32","Neni naba silok aleng la neni naba ruuna na laasen do lamdak at Leeme Avolo ne Moroa. Moroa naba vaxaxis i ngan loorong, i ngan lara ren ne Devit, neni loorong megano. ");
INSERT INTO mmx_vpl VALUES ("LK1_33","072_1_33","LUK","1","33","33","Neni naba nemen amisik ngan loorong at livipisik li at ne Jakop la lixitkis orong teren noxo xap!” ");
INSERT INTO mmx_vpl VALUES ("LK1_34","072_1_34","LUK","1","34","34","Maria ga lok ti laangelo, “Nenia kopmen ana epot! Naba lok kereva na?” ");
INSERT INTO mmx_vpl VALUES ("LK1_35","072_1_35","LUK","1","35","35","Laangelo ga lok tin, “Loroonan Kaala naba vot saparav u, la lolos at Leeme Avolo ne Moroa naba los kis taram. Kuren la nom Lamdak Melemelengan dinaba so asen i do Nitna ne Moroa. ");
INSERT INTO mmx_vpl VALUES ("LK1_36","072_1_36","LUK","1","36","36","Una doxoma lara ram ne Elisabet. Diga tong i do ni noxo visik, ketla neni xa i vanna nga leven gaaling teren, keke i do neni ira sioxo vam. ");
INSERT INTO mmx_vpl VALUES ("LK1_37","072_1_37","LUK","1","37","37","Kopmen tempanga na lolos saparap ne Moroa kusu ni na lox i.” ");
INSERT INTO mmx_vpl VALUES ("LK1_38","072_1_38","LUK","1","38","38","Maria ga lok, “Nia mun lasaxaruki at Leeme Silok ne Moroa, i epovo do na lavanga na rupot saparav ia, i ngan ura tong pam i.” La laangelo ga on basinge i. ");
INSERT INTO mmx_vpl VALUES ("LK1_39","072_1_39","LUK","1","39","39","Melemu at lentaba levenaleng Maria ga lox agagas, la ni gat pas soso uto at lengkong kaana at lara lemenemen gak lok to at lenep kangka Judaia. ");
INSERT INTO mmx_vpl VALUES ("LK1_40","072_1_40","LUK","1","40","40","Ni ga vubeles uto xeneng at loogu at ne Sakaria la ga vaase momo ri ne Elisabet. ");
INSERT INTO mmx_vpl VALUES ("LK1_41","072_1_41","LUK","1","41","41","Ga se ne Elisabet ga ronga mo levelinga at ne Maria, lamdak ga xuluxut to xeneng at lebelen. La ne Elisabet ga umsu mi Loroonan Kaala, ");
INSERT INTO mmx_vpl VALUES ("LK1_42","072_1_42","LUK","1","42","42","la ni ga vaase silok keretna, “Nenu loono u umsu mi loklox anarong tinedi lavakin axap, la nom lamdak nenu uba visix i, Moroa naba lox anarong i! ");
INSERT INTO mmx_vpl VALUES ("LK1_43","072_1_43","LUK","1","43","43","Tila ba la nenen Leeme Silok tarak ira vot pasa ia, nenia latkin gamasa mene? ");
INSERT INTO mmx_vpl VALUES ("LK1_44","072_1_44","LUK","1","44","44","Ap mo loxonaleng u paase ria, la lamdak na xeneng at labalak i xuluxut mi lososoro. ");
INSERT INTO mmx_vpl VALUES ("LK1_45","072_1_45","LUK","1","45","45","Moroa naba lox anarong u mila uga nunu do levelinga at ne Moroa naba soorun!” ");
INSERT INTO mmx_vpl VALUES ("LK1_46","072_1_46","LUK","1","46","46","Maria ga lok, “Nenia a emi asu mi Leeme Silok ne Moroa. ");
INSERT INTO mmx_vpl VALUES ("LK1_47","072_1_47","LUK","1","47","47","Lorooro axap tarak i umsu mi lomomo mila ne Moroa neni Laradi Loklox Arooro rak, ");
INSERT INTO mmx_vpl VALUES ("LK1_48","072_1_48","LUK","1","48","48","la neni ira doxoma su vam tarak, latkin gamasa mun. La nenia lasaxaruki ren. Limixin axap dinaba rupot melemu dinaba tong i do ne Moroa ga lox anarong ia, ");
INSERT INTO mmx_vpl VALUES ("LK1_49","072_1_49","LUK","1","49","49","mila Lanaraavuk ne Moroa ira lok pam na lavanga silok tia. Laasen teren i melemelengan. ");
INSERT INTO mmx_vpl VALUES ("LK1_50","072_1_50","LUK","1","50","50","I lox asuusu labalamu ren tinedi di lok ngangao ren at laraola axap. ");
INSERT INTO mmx_vpl VALUES ("LK1_51","072_1_51","LUK","1","51","51","Neni ik lok lempanga silok, la i utut tereve levendoxoma at limixin di lox asilok nedi. ");
INSERT INTO mmx_vpl VALUES ("LK1_52","072_1_52","LUK","1","52","52","Ni ik lox asi lavaorong basinge lixitkis orong atdi, la ik lox asilok limixin etaba. ");
INSERT INTO mmx_vpl VALUES ("LK1_53","072_1_53","LUK","1","53","53","I suxa umsu limixin dik pakes mi lempanga nunuan, la ik tiki limixin dip novos la dit pas la kopmen bok ba tempanga dina ruuna i. ");
INSERT INTO mmx_vpl VALUES ("LK1_54","072_1_54","LUK","1","54","54","Ni ga doxoma lavapaase ali ren ga lox i rinedi lavalabat atdik, la ira lok tooro lubung mixin teren me Israel, nedi lavasaxaruki ren. ");
INSERT INTO mmx_vpl VALUES ("LK1_55","072_1_55","LUK","1","55","55","La i lox asuusu amisik labalamu ren kerekngan ni ga lok lavapaase ali ren ti lavalabat atdik la ti ne Abaram, la ti livipisik li bok teren.” ");
INSERT INTO mmx_vpl VALUES ("LK1_56","072_1_56","LUK","1","56","56","Maria ga nemen eburu mi ne Elisabet at lavantun gaaling axap la melemu neni gamlong bok ba uto xolonu ren. ");
INSERT INTO mmx_vpl VALUES ("LK1_57","072_1_57","LUK","1","57","57","Laaleng ga vot nga kusu ti ne Elisabet na ranga madak, la ni ga visik lamdak temes. ");
INSERT INTO mmx_vpl VALUES ("LK1_58","072_1_58","LUK","1","58","58","Lentaba no diga nemen saparav i la libibinat teren diga ronga i do ne Moroa ga lok loklox avukat aleng tin. Kuren la diga lok momo aleng eburu mi ne Elisabet. ");
INSERT INTO mmx_vpl VALUES ("LK1_59","072_1_59","LUK","1","59","59","Ga at laaleng sepsev avanuan digat pas kusu dina ven ne Sakaria na vit kepe loxontuxu at lamdak teren. Diga lok do dina so asen i mi ne Sakaria, laasen at ne temen. ");
INSERT INTO mmx_vpl VALUES ("LK1_60","072_1_60","LUK","1","60","60","Ketla nenen ga lok, “Kopmen! Laasen tin ne Jon.” ");
INSERT INTO mmx_vpl VALUES ("LK1_61","072_1_61","LUK","1","61","61","La diga lok tin, “Ketla kopmen tara at libibinat atnumu i ruuna nom laasen!” ");
INSERT INTO mmx_vpl VALUES ("LK1_62","072_1_62","LUK","1","62","62","Kuren la diga lok loklok poovo ti ne Sakaria, kusu dina sue i do ua laasen mo lamdak naba ruuna i. ");
INSERT INTO mmx_vpl VALUES ("LK1_63","072_1_63","LUK","1","63","63","Sakaria ga sing ti tovoang mamalagan la ni ga malagan keretna, “Laasen teren ne Jon.” La nedi axap diga sangu. ");
INSERT INTO mmx_vpl VALUES ("LK1_64","072_1_64","LUK","1","64","64","Ap mo mene loxonaleng Sakaria ga lox epovo manga i kusu na paase, la ni ga emi asu mi ne Moroa. ");
INSERT INTO mmx_vpl VALUES ("LK1_65","072_1_65","LUK","1","65","65","La mo limixin diga nemen saparav i diga sangu aleng, la lavapaase mumu i na lavanga ga epeseves keneng at lengkot axap at lengkong kaana at lenep silok Judaia. ");
INSERT INTO mmx_vpl VALUES ("LK1_66","072_1_66","LUK","1","66","66","Nedi axap getgesara diga ronga i na, la digam doma mumu i la diga esue xeretna, “Anaa lamdak naba lok kereva?” Diga paase xerepmo mila digaklen i do lolos at ne Moroa ga nemen eburu min. ");
INSERT INTO mmx_vpl VALUES ("LK1_67","072_1_67","LUK","1","67","67","Temen ne Jon ga umsu mi Loroonan Kaala, la ni ga vaase mi levelinga at ne Moroa, ");
INSERT INTO mmx_vpl VALUES ("LK1_68","072_1_68","LUK","1","68","68","“Ata emi asu mi ne Moroa, Leeme Silok me Israel! Ga vot ti soxomus asu limixin me Israel at loxokoxo at ne Satan. ");
INSERT INTO mmx_vpl VALUES ("LK1_69","072_1_69","LUK","1","69","69","Ni ga gagas li laradi lolos i ngan Laradi Loklox Arooro ridik, neni livisik li at ne Devit, laradi gugu ren. ");
INSERT INTO mmx_vpl VALUES ("LK1_70","072_1_70","LUK","1","70","70","Gano migomgo at lavaeme vapaase ali ren, neni ga tong i na. ");
INSERT INTO mmx_vpl VALUES ("LK1_71","072_1_71","LUK","1","71","71","Ga paase ali xusu na lox arooro dik basinge nedi dik lok munepen midik la basinge di, di belengatngas tidik. ");
INSERT INTO mmx_vpl VALUES ("LK1_72","072_1_72","LUK","1","72","72","Ni ga lox empana lavapaase ali ren ni ga lox i ri lavalabat atdik la kerepmo ga lox asuusu labalamu ren tidi. ");
INSERT INTO mmx_vpl VALUES ("LK1_73","072_1_73","LUK","1","73","73","Ni ga lok lavapaase ali ruturun ti ne Abaram, lamgomgo at lavalabat atdik, ");
INSERT INTO mmx_vpl VALUES ("LK1_74","072_1_74","LUK","1","74","74","la ga xaape do ni naba lox asepsu dik basinge limixin dik lok munepen midik, la na lok tooro dik kusu ataba epovo, la tanap kip mo lugugu ren la kopmen dik taxo marat. ");
INSERT INTO mmx_vpl VALUES ("LK1_75","072_1_75","LUK","1","75","75","At levenaleng axap at lorooro atdik, atap kip lugugu ren mi loklok i nunuan aleng la in manton tino. ");
INSERT INTO mmx_vpl VALUES ("LK1_76","072_1_76","LUK","1","76","76","La nenu lamdak tarak, unaba ruuna na laasen, laradi vapaase ali at Leeme Avolo. Mila unabam gomgo ri Leeme Silok kusu unaba gagas li langas tin. ");
INSERT INTO mmx_vpl VALUES ("LK1_77","072_1_77","LUK","1","77","77","La unaba tong i ri limixin teren do neni naba lox arooro di la neni naba doxoma xepe laxakapmek atdi. ");
INSERT INTO mmx_vpl VALUES ("LK1_78","072_1_78","LUK","1","78","78","Neni naba lox i na mila ne Moroa atdik i umsu mi lebelen tuntun la loklox anare. Kuren la ni naba riki asi Lanarong teren kusu na ravasu ude ri na lavatbung menemen ti lox arooro limixin. ");
INSERT INTO mmx_vpl VALUES ("LK1_79","072_1_79","LUK","1","79","79","La ni naba lok ngan laxasep tinedi limixin di nemen keneng at lamain la tinedi bok dik lok maxopok at lamamau at lanmet. Neni naba sat lavatpas atdik ti langas at lumulum.” ");
INSERT INTO mmx_vpl VALUES ("LK1_80","072_1_80","LUK","1","80","80","Jon ga sisilok la luruptuvuk teren ga nunuan aleng. Ni ga nemen to at lamatbin se at laaleng neni ga vor asuvos tinedi limixin me Israel. ");
INSERT INTO mmx_vpl VALUES ("LK2_1","072_2_1","LUK","2","1","1","Ap mo levenaleng ne Kaisar Ogastas ga lox aonon lavapaase axasep tinedi limixin digak lok maxopok at lagavaman boro Rom kusu dina malagan amaxat ka levenasen atdi. ");
INSERT INTO mmx_vpl VALUES ("LK2_2","072_2_2","LUK","2","2","2","Kuirinias ga neni laradi gomgo ri lenep silok Siria, ap mo laaleng na lugugu ti lok ka asen ga vot. ");
INSERT INTO mmx_vpl VALUES ("LK2_3","072_2_3","LUK","2","3","3","Nedi limixin getgesara digat pas ti levenmenemen axa atdi kusu dina lok li levenasen atdi. ");
INSERT INTO mmx_vpl VALUES ("LK2_4","072_2_4","LUK","2","4","4","La ne Josep ga nemen at lemenemen Nasaret at lenep silok Galili. Ni ga ronga na levelinga la at lara laaleng ni ga vas kaxat uto at lemenemen, laasen teren, Betilem, mo gak lok at lenep silok Judaia; mo lemenemen at loorong ne Devit. Josep gat pas ugo, mila neni livisik li at ne Devit, ");
INSERT INTO mmx_vpl VALUES ("LK2_5","072_2_5","LUK","2","5","5","la kusu ni na lok li laasen teren eburu mi ne Maria, mo diga lok katling i xusu naba epot at ne Josep. Neni ga balan madak. ");
INSERT INTO mmx_vpl VALUES ("LK2_6","072_2_6","LUK","2","6","6","La nedu duga rupot to Betilem, la laaleng ga vot nga kusu ne Maria na visik lamdak teren. ");
INSERT INTO mmx_vpl VALUES ("LK2_7","072_2_7","LUK","2","7","7","La ni ga visik lamdak temes avot teren, la ga bom i mi leventamon la ga vaxamdi i ro at loxot anan at laxanbulumaxao, mila goxopmen toxot tidu ri nemen to at loogu mikmidi. ");
INSERT INTO mmx_vpl VALUES ("LK2_8","072_2_8","LUK","2","8","8","Ap mo laxanimin lentaba luvuttadi loklok tatao sipsip diga nemen ap mo lenep, digak lok tatao levesipsip atdi. ");
INSERT INTO mmx_vpl VALUES ("LK2_9","072_2_9","LUK","2","9","9","La laangelo at Leeme Silok ne Moroa ga vot saparap di, la lisisixam at ne Moroa ga so axasep nedi la ga vung kamit mo loxot axap. La diga marat aleng tinotno. ");
INSERT INTO mmx_vpl VALUES ("LK2_10","072_2_10","LUK","2","10","10","Ketla laangelo ga lok tidi, “Nemen mita marat! Nenia ana tong lagale lavavang tinimi, mo naba lox amomo limixin axap. ");
INSERT INTO mmx_vpl VALUES ("LK2_11","072_2_11","LUK","2","11","11","Lingina at na laaleng to at lemenemen at ne Devit, Laradi Loklox Arooro atnimi dira visik pam i. Neni Lanarong la Leeme Silok! ");
INSERT INTO mmx_vpl VALUES ("LK2_12","072_2_12","LUK","2","12","12","Loklok katling at na lavanga i lok keretna. Minaba long lenget ka lumumulum di bom i mi leventamon la ik midi ro at loxot anan at laxanbulumaxao.” ");
INSERT INTO mmx_vpl VALUES ("LK2_13","072_2_13","LUK","2","13","13","La soso mun, buaang nedi lubung angelo boro vana at laxalibet diga vot eburu mi mo laangelo, diga emi asu saparap ne Moroa. Diga lok keretna, ");
INSERT INTO mmx_vpl VALUES ("LK2_14","072_2_14","LUK","2","14","14","“Leemi asu ri ne Moroa ik lok to vana at laxalibet, la lumulum at ne Moroa nak lok at na lavatbung menemen tinedi ne Moroa i momo midi.” ");
INSERT INTO mmx_vpl VALUES ("LK2_15","072_2_15","LUK","2","15","15","La lubung angelo diga on basinge di, la digamlong manga uto vana at laxalibet, la luvuttadi loklok tatao sipsip diga epaase minedi getgesara xeretna, “Atat pas uto Betilem la ata ven lumumulum, mo ne Moroa ira tong pam i ridik.” ");
INSERT INTO mmx_vpl VALUES ("LK2_16","072_2_16","LUK","2","16","16","La diga vas kaxat soso mun, diga vot pasa ne Maria la ne Josep, la diga long lenget ka lumumulum gak midi ro at loxot anan at laxanbulumaxao. ");
INSERT INTO mmx_vpl VALUES ("LK2_17","072_2_17","LUK","2","17","17","Ga se mo luvuttadi loklok tatao sipsip diga ven lumumulum, diga on basinge i, la diga paase asu levelinga at laangelo ri limixin axap. ");
INSERT INTO mmx_vpl VALUES ("LK2_18","072_2_18","LUK","2","18","18","La nedi mo diga ronga mo levelinga, diga sangu ren. ");
INSERT INTO mmx_vpl VALUES ("LK2_19","072_2_19","LUK","2","19","19","Ketla ne Maria ga doxoma na levelinga, la gam doma mumu amisix i. ");
INSERT INTO mmx_vpl VALUES ("LK2_20","072_2_20","LUK","2","20","20","Luvuttadi loklok tatao sipsip digamlong, diga emi asu mi ne Moroa ti nom lempanga diga ronga i la diga ven pam i, kerekngan laangelo ga vaase di min. ");
INSERT INTO mmx_vpl VALUES ("LK2_21","072_2_21","LUK","2","21","21","At laaleng sepsev avanuan melemu at livipisik at ne Iesu, nedu lenasun duga lok ka ne Iesu xusu dina vit kepe loxontuxu ren. La diga so asen i mi ne Iesu, no laasen laangelo gara so asen avot pam i min ap mo loxonaleng nenen goxovisi na renan min. ");
INSERT INTO mmx_vpl VALUES ("LK2_22","072_2_22","LUK","2","22","22","Laaleng ga vot nga kusu ne Josep mi ne Maria duna lok axap mo loklok ti lox adadat du kerekngan Laulis Linga at ne Moses ga tong i. La duga lok ka lamdak uto Jerusalem kusu duna raba ne Moroa min, ");
INSERT INTO mmx_vpl VALUES ("LK2_23","072_2_23","LUK","2","23","23","kerekngan levelinga gak lok to xeneng at Laulis Linga at ne Moroa i lok keretna, “Laxamdak temes avot, mina song araba di ri ne Moroa.” ");
INSERT INTO mmx_vpl VALUES ("LK2_24","072_2_24","LUK","2","24","24","Dugat pas bok kusu duna raba leventamtaba atdu. Laulis Linga at ne Moroa ga tong i do limixin dinaba raba i mi legepu bino, kopla legepu bilis. ");
INSERT INTO mmx_vpl VALUES ("LK2_25","072_2_25","LUK","2","25","25","Lara laradi ga nemen to Jerusalem laasen teren ne Simion. Neni lagale laradi, la ga lok ngangao bok at ne Moroa la ni ga lotu ruturun saparav i. Ni ga ngangais ti taradi kusu naba lox arooro limixin me Israel. Loroonan Kaala ga nemen teren. ");
INSERT INTO mmx_vpl VALUES ("LK2_26","072_2_26","LUK","2","26","26","La Loroonan Kaala ga tong pam i rin do ni noxo met se ni naba ven Lanarong at ne Moroa. ");
INSERT INTO mmx_vpl VALUES ("LK2_27","072_2_27","LUK","2","27","27","Ap mo laaleng Loroonan Kaala ga lam ka ne Simion uto at loogu laplavang. Ne temen mi nenen ne Iesu duga lox abeles lamdak ukeneng kusu dina lox epovo loklok at leme Judaia i ngan Laulis Linga ga tong i. ");
INSERT INTO mmx_vpl VALUES ("LK2_28","072_2_28","LUK","2","28","28","La ne Simion ga lok kaka lamdak mi lukngen, la ga emi asu mi ne Moroa xeretna. ");
INSERT INTO mmx_vpl VALUES ("LK2_29","072_2_29","LUK","2","29","29","“O, Leeme Silok! Lavapaase ali ram ira soorun pam, la nanga una ke ia, lasaxaruki ram kusu ana met basinge lugugu ram la ana nemen at lenmila. ");
INSERT INTO mmx_vpl VALUES ("LK2_30","072_2_30","LUK","2","30","30","Ara ven pam langas ti lorooro mi luxatli axa rak, ");
INSERT INTO mmx_vpl VALUES ("LK2_31","072_2_31","LUK","2","31","31","mo uga gagas min kusu limixin axap dinaba ven i. ");
INSERT INTO mmx_vpl VALUES ("LK2_32","072_2_32","LUK","2","32","32","I ngan laxasep kusu naba lox axasep langas taram ti limixin kopmen di me Judaia, la na raba lasinorong ti limixin taram boro Israel.” ");
INSERT INTO mmx_vpl VALUES ("LK2_33","072_2_33","LUK","2","33","33","Temen mi nenen lamdak duga sangu aleng ap mo levelinga at ne Simion. ");
INSERT INTO mmx_vpl VALUES ("LK2_34","072_2_34","LUK","2","34","34","Simion ga lox anarong di la ga lok ti ne Maria xeretna, “Anaa lamdak ne Moroa ga soxolik ka i xusu naba lok nedi limixin buaang me Israel dinaba subu la buaang bok nedi dinaba xatu at levelinga ren. Neni naba lok ngan loklok katling boro vana at ne Moroa la buaang nedi dinaba sok tixirixes i. ");
INSERT INTO mmx_vpl VALUES ("LK2_35","072_2_35","LUK","2","35","35","La ni naba lox asuvos levendoxoma nemnem at limixin. La lorooro ram naba umsu mi lainbulu.” ");
INSERT INTO mmx_vpl VALUES ("LK2_36","072_2_36","LUK","2","36","36","Lara latkin papaase ali laasen teren ne Ana loolik at ne Panuel, at libibinat at ne Asa. Neni lasioxo rixin, la ni ga epot mun at lavanuti maares. ");
INSERT INTO mmx_vpl VALUES ("LK2_37","072_2_37","LUK","2","37","37","La latlok teren ga met la melemu neni ga nemen naa. La levenmaares teren ga epovo at lavanuan sangaun mi lavanuet. Neni xopmen goxo onon basinge loogu laplavang. At lengkangking la lengkanimin, ni ga lotu saparap ne Moroa la ni gan mun anan la ga ngising. ");
INSERT INTO mmx_vpl VALUES ("LK2_38","072_2_38","LUK","2","38","38","Ap mo mun loxonaleng neni ga vot pasa di la ga tong loklox avukat saparap ne Moroa, la ga vaase ali mumu ne Iesu tinedi mo limixin diga ngangais ne Moroa kusu naba lox arooro limixin me Israel. ");
INSERT INTO mmx_vpl VALUES ("LK2_39","072_2_39","LUK","2","39","39","Se ne Josep mi ne Maria duga lox axav i mo lempanga kerekngan Laulis Linga at ne Moroa ga tong i, digamlong uto Nasaret lemenemen atdi gak lok at lenep silok Galili. ");
INSERT INTO mmx_vpl VALUES ("LK2_40","072_2_40","LUK","2","40","40","Lamdak ga sisilok la ga lolos. Ga umsu mi lakleklen, la letaba nabalamu at ne Moroa ga umsu at lorooro ren. ");
INSERT INTO mmx_vpl VALUES ("LK2_41","072_2_41","LUK","2","41","41","At levenmaares axap ne Josep eburu mi nenen ne Iesu dugat pas uto Jerusalem ti leluxa, laasen ap mo leluxa, Lovovolo Pe. ");
INSERT INTO mmx_vpl VALUES ("LK2_42","072_2_42","LUK","2","42","42","Se ne Iesu ga lasangaun legepura laramaares teren, nedi loxoetemen digat pas uto ap mo leluxa kerekngan loklok at limixin me Israel. ");
INSERT INTO mmx_vpl VALUES ("LK2_43","072_2_43","LUK","2","43","43","La levenaleng ap mo leluxa ga xap ta, la nedu lenasun duga vas kaxat uto xolonu, la ne Iesu ga nemen go Jerusalem, ketla du goxoklen i. ");
INSERT INTO mmx_vpl VALUES ("LK2_44","072_2_44","LUK","2","44","44","Duga nua i do neni mo gat pas eburu mi lentaba ren boro Nasaret. Kuren la dugat pas ap mo laaleng se ukantinao, la melemu duga long lenget ka i do neni goxo emu mi limixin la duga vuse kaxat ba rin kantubu at lempat atdi la larapen tangas bok atdi. ");
INSERT INTO mmx_vpl VALUES ("LK2_45","072_2_45","LUK","2","45","45","Du goxo vuse ka i, la dugamlong uto Jerusalem kusu duna ven tin. ");
INSERT INTO mmx_vpl VALUES ("LK2_46","072_2_46","LUK","2","46","46","Melemu at laaleng sepsev avantun duga vuse ka i ro xeneng at loogu laplavang, gat kis eburu mi luvuttadi loklox ase at leme Judaia. Ni gang tonga di la ga susue bok di mi levesusue. ");
INSERT INTO mmx_vpl VALUES ("LK2_47","072_2_47","LUK","2","47","47","Nedi mo digang tonga i, diga sangu aleng at lakleklen teren la levempoporang teren. ");
INSERT INTO mmx_vpl VALUES ("LK2_48","072_2_48","LUK","2","48","48","Nedu lenasun duga vuse ka i, duga sangu aleng la nenen ga lok tin, “Nuruk, tila u lok nom loklok tinama? Nema lenasun mara bulu aleng mu u.” ");
INSERT INTO mmx_vpl VALUES ("LK2_49","072_2_49","LUK","2","49","49","Ni ga vorang i ridu keretna, “Tila mu lok do muna puse ria? Kereva, muxoklen i do nia aba nemen to at loogu at ne Tamak?” ");
INSERT INTO mmx_vpl VALUES ("LK2_50","072_2_50","LUK","2","50","50","Ketla du goxo xasep at na levelinga ne Iesu ga tong i ridu. ");
INSERT INTO mmx_vpl VALUES ("LK2_51","072_2_51","LUK","2","51","51","La ne Iesu gamlong eburu midu uto Nasaret, la neni gang tonga res amisik atdu. La nenen gam doma amisik na levelinga at ne Iesu la goxo domampe i. ");
INSERT INTO mmx_vpl VALUES ("LK2_52","072_2_52","LUK","2","52","52","La ne Iesu ga sisilok at labantuxu la at lakleklen bok. La loklok teren ga nunuan axap at lemeren ne Moroa la limixin. ");
INSERT INTO mmx_vpl VALUES ("LK3_1","072_3_1","LUK","3","1","1","At lamaares lasangaun mi lavalimo at lixitkis migomgo at ne Kaisar Taibirias. Pontias Paelat ga nemen ngan laradi gomgo to Judaia, la ne Erodes gam gomgonga limixin to lenep silok Galili, la neton, laasen teren ne Pilip gam gomgonga limixin to lunep silok Ituria la Tarakanitis. Lasinias gam gomgonga limixin to lenep silok Abilini. ");
INSERT INTO mmx_vpl VALUES ("LK3_2","072_3_2","LUK","3","2","2","La ne Anas mi ne Kaiapas duga nemen ngan lumaasa gomgo. Ap mo levenaleng levelinga at ne Moroa ga rupot saparap ne Jon lamdak at ne Sakaria to at lamatbin. ");
INSERT INTO mmx_vpl VALUES ("LK3_3","072_3_3","LUK","3","3","3","La ni gat pas at lengkot axap saparap ladan sen Joridan la ga vavang tinedi diga vot pasa i. Ni ga lok keretna, “Mina leeng basinge laxakapmek atnimi la mina lok ka lesep susu, la ne Moroa naba doxoma xepe laxakapmek atnemi.” ");
INSERT INTO mmx_vpl VALUES ("LK3_4","072_3_4","LUK","3","4","4","Ga lok ngan laradi vapaase ali ne Aisaia ga malagan i at lubuk teren keretna. “Lara mo ip kup to at lamatbin keretna, ‘Mina lox agagas li langas ti Leeme Silok kusu tin tit pas. Mina lox akmokso larangas tin! ");
INSERT INTO mmx_vpl VALUES ("LK3_5","072_3_5","LUK","3","5","5","Minas bosbo pe larasa upana, lempatkaana mi lengkong kaana xakalik mina lox amamana i. Larangas kakauk mina lox akmokso i la larangas i garasan mina lox amamasa i. ");
INSERT INTO mmx_vpl VALUES ("LK3_6","072_3_6","LUK","3","6","6","La limixin axap dinaba ven ba lugugu loklox arooro at ne Moroa.’” ");
INSERT INTO mmx_vpl VALUES ("LK3_7","072_3_7","LUK","3","7","7","Buaang nedi limixin diga vot pasa ne Jon kusu na sep susu di. La ni ga paase lolos tidi xeretna, “Nemi mi lok ngan laxamdak at laxasii, mila loklok atnimi i lok kapmek aleng. Mi lok do mina lok kaka lesep susu kusu mina sepsu at lebelemamao at ne Moroa mo naba vot melemu, ketla xopmen mi noxo epovo. ");
INSERT INTO mmx_vpl VALUES ("LK3_8","072_3_8","LUK","3","8","8","Ketla mina lok leveloklok nunuan kusu naba lox asuusu i do mira leeng basinge vam laxakapmek atnimi. La nemen nemi mita etong i kantubu atnimi do, ‘Taba nemen avukat mila nedik luvuttubuno avolo at ne Abaram.’ A tong i rinimi do Moroa i epovo xusu na lok ka na laxanuat la na lok di laxamdak ti ne Abaram! ");
INSERT INTO mmx_vpl VALUES ("LK3_9","072_3_9","LUK","3","9","9","Lamatao mo i nemen gagas kusu na tara asubu larauna. Do larauna axap dixo pisik larapeven una avukat, Moroa naba ra asi di ukopok la na lu midi uto at laxao.” ");
INSERT INTO mmx_vpl VALUES ("LK3_10","072_3_10","LUK","3","10","10","Limixin diga sue i, “Maba lok lavanga salai?” ");
INSERT INTO mmx_vpl VALUES ("LK3_11","072_3_11","LUK","3","11","11","La ne Jon ga vorang i ridi xeretna, “Do nege i ruuna tegepu vanga singsiga, neni na raba tara ti mo laradi kopmen tara ren. La do nege i ruuna leveluxa, neni na raba box i ri mo laradi kopmen teveluxa ren.” ");
INSERT INTO mmx_vpl VALUES ("LK3_12","072_3_12","LUK","3","12","12","Lentaba luvuttadi loklok ka pilas diga vot kusu ne Jon na sep susu di, la diga sue i, “Laradi loklox ase, manaba lok lavanga salai?” ");
INSERT INTO mmx_vpl VALUES ("LK3_13","072_3_13","LUK","3","13","13","Ni ga lok tidi, “Nemen mita lok ka gamasa tempilas at limixin i volo lampoovo, luvuttadi amgomgo diga tong taba nedi min.” ");
INSERT INTO mmx_vpl VALUES ("LK3_14","072_3_14","LUK","3","14","14","La lentaba luvuttadi esep bok diga sue i, “Kereva ba nama? Lavanga salai manaba lox i?” La ni ga lok tidi, “Nemen mita pu soso ka tempilas at taradi la mina lox amarar i xopla mina bala raba tara. Levendoxoma atnimi na lox avukat ti luunun mik lok ka i.” ");
INSERT INTO mmx_vpl VALUES ("LK3_15","072_3_15","LUK","3","15","15","Levendoxoma at limixin ga xatu kaxat la diga doxoma mumu ne Jon, diga nua i do neni mo Lanarong. ");
INSERT INTO mmx_vpl VALUES ("LK3_16","072_3_16","LUK","3","16","16","Kuren la ne Jon ga lok tinedi axap, “Nenia a sep susu nimi mi ladan, ketla lara laradi naba vot. Lolos teren i volo lolos tarak. Axo epovo xusu ana soxomus luvanga vatpas teren mila neni i silok aleng tia. Neni naba sep susu nimi mi Loroonan Kaala la naba lok kepe laxakapmek atnimi kerekngan laxao i rin kepe levenboobong. ");
INSERT INTO mmx_vpl VALUES ("LK3_17","072_3_17","LUK","3","17","17","Neni i gagas pam kusu ti lok pes larapeven piao basinge labantuxu ren la na lok li bubua larapeven piao uto xeneng at loogu ren. Ketla neni naba xotos leventuxu at levempiao ro at laxao kopmen noxo remet.” ");
INSERT INTO mmx_vpl VALUES ("LK3_18","072_3_18","LUK","3","18","18","Buaang leventaangas axap Jon ga vavang min ti limixin kusu na tong asu Lagale Lavavang tinedi. ");
INSERT INTO mmx_vpl VALUES ("LK3_19","072_3_19","LUK","3","19","19","Ketla ne Jon ga sok katli ka laradi gomgo ne Erodes mila neni ga vaxat ka ne Erodias latkin at neton, la ga lok bok buaang lempanga xapmek. ");
INSERT INTO mmx_vpl VALUES ("LK3_20","072_3_20","LUK","3","20","20","Kuren la ne Erodes ga lok bok lara lavanga ga lok kapmek aleng. Ni ga ranga alis ne Jon la ga lok li i at loogu xokoxo. ");
INSERT INTO mmx_vpl VALUES ("LK3_21","072_3_21","LUK","3","21","21","Avot ti loxokoxo at ne Jon, ni ga sep susu limixin. At lara laaleng ni ga sep susu bok ne Iesu. Laxalibet ga rem suang ap mo loxonaleng ne Iesu ga lok lising. ");
INSERT INTO mmx_vpl VALUES ("LK3_22","072_3_22","LUK","3","22","22","La Loroonan Kaala ga rava si ukopok, diga ven lovoovo ren ga ngan lamno la ga nemen at ne Iesu. La laxaka at lara ga laa boro vana at laxalibet ga lok keretna, “Nenu ne nuruk. La nia a balamu u la a momo minu.” ");
INSERT INTO mmx_vpl VALUES ("LK3_23","072_3_23","LUK","3","23","23","Se ne Iesu ga vaxaru kaxat leven gugu ren, lenmaares teren ga epovo at lavantun sangaun. Limixin diga doma i do neni nitna ne Josep. La ne Josep neni nitna ne Eli, ");
INSERT INTO mmx_vpl VALUES ("LK3_24","072_3_24","LUK","3","24","24","Eli neni nitna ne Matat, Matat neni nitna ne Levi. Levi neni nitna ne Melkai, Melkai neni nitna ne Janai, Janai neni nitna ne Josep; ");
INSERT INTO mmx_vpl VALUES ("LK3_25","072_3_25","LUK","3","25","25","Josep neni nitna ne Matatias, Matatias neni nitna ne Amos, Amos neni nitna ne Naum, Naum neni nitna ne Esli, Esli neni nitna ne Nagae; ");
INSERT INTO mmx_vpl VALUES ("LK3_26","072_3_26","LUK","3","26","26","Nagae neni nitna ne Maat, Maat neni nitna ne Matatias, Matatias neni nitna ne Semen, Semen neni nitna ne Josek, Josek neni nitna ne Joda; ");
INSERT INTO mmx_vpl VALUES ("LK3_27","072_3_27","LUK","3","27","27","Joda neni nitna ne Jonan, Jonan neni nitna ne Resa, Resa neni nitna ne Serababel, Serababel neni nitna ne Salatiel, Salatiel neni nitna ne Neri; ");
INSERT INTO mmx_vpl VALUES ("LK3_28","072_3_28","LUK","3","28","28","Neri neni nitna ne Melkai, Melkai neni nitna ne Adai, Adai neni nitna ne Kosam, Kosam neni nitna ne Elmadam, Elmadam neni nitna ne Era; ");
INSERT INTO mmx_vpl VALUES ("LK3_29","072_3_29","LUK","3","29","29","Era neni nitna ne Josua, Josua neni nitna ne Eliser, Eliser neni nitna ne Jorim, Jorim neni nitna ne Matat, Matat neni nitna ne Levi; ");
INSERT INTO mmx_vpl VALUES ("LK3_30","072_3_30","LUK","3","30","30","Levi neni nitna ne Simion, Simion neni nitna ne Juda, Juda neni nitna ne Josep, Josep neni nitna ne Jonam, Jonam neni nitna ne Eliakim; ");
INSERT INTO mmx_vpl VALUES ("LK3_31","072_3_31","LUK","3","31","31","Eliakim neni nitna ne Melia, Melia neni nitna ne Mena, Mena neni nitna ne Matata, Matata neni nitna ne Natan, Natan neni nitna ne Devit; ");
INSERT INTO mmx_vpl VALUES ("LK3_32","072_3_32","LUK","3","32","32","Devit neni nitna ne Jesi, Jesi neni nitna ne Obet, Obet neni nitna ne Boas, Boas neni nitna ne Salmon, Salmon neni nitna ne Nason; ");
INSERT INTO mmx_vpl VALUES ("LK3_33","072_3_33","LUK","3","33","33","Nason neni nitna ne Aminadap, Aminadap neni nitna ne Amin, Amin neni nitna ne Aanai, Aanai neni nitna ne Esron, Esron neni nitna ne Peres, Peres neni nitna ne Juda; ");
INSERT INTO mmx_vpl VALUES ("LK3_34","072_3_34","LUK","3","34","34","Juda neni nitna ne Jakop, Jakop neni nitna ne Aisak, Aisak neni nitna ne Abaram, Abaram neni nitna ne Tera, Tera neni nitna ne Nao; ");
INSERT INTO mmx_vpl VALUES ("LK3_35","072_3_35","LUK","3","35","35","Nao neni nitna ne Serak, Serak neni nitna ne Reu, Reu neni nitna ne Pelek, Pelek neni nitna ne Iba, Iba neni nitna ne Sila; ");
INSERT INTO mmx_vpl VALUES ("LK3_36","072_3_36","LUK","3","36","36","Sila neni nitna ne Kenan, Kenan neni nitna ne Apaksat, Apaksat neni nitna ne Sem, Sem neni nitna ne Noa, Noa neni nitna ne Lamek; ");
INSERT INTO mmx_vpl VALUES ("LK3_37","072_3_37","LUK","3","37","37","Lamek neni nitna ne Matusala, Matusala neni nitna ne Enok, Enok neni nitna ne Jare, Jare neni nitna ne Malalil, Malalil neni nitna ne Kenan; ");
INSERT INTO mmx_vpl VALUES ("LK3_38","072_3_38","LUK","3","38","38","Kenan neni nitna ne Enos, Enos neni nitna ne Set, Set neni nitna ne Adam, la Adam neni nitna ne Moroa. ");
INSERT INTO mmx_vpl VALUES ("LK4_1","072_4_1","LUK","4","1","1","Iesu gamlong boro at ladan sen Joridan, neni ga umsu mi Loroonan Kaala. La Loroonan Kaala ga lam ka i uto at lamatbin. ");
INSERT INTO mmx_vpl VALUES ("LK4_2","072_4_2","LUK","4","2","2","Ap mo levenaleng ne Iesu gan mun anan, la melemu ni ga roxo. La ne Satan ga vot pasa i la ni gak lok tong pen i at lavanuet sangaun aleng. ");
INSERT INTO mmx_vpl VALUES ("LK4_3","072_4_3","LUK","4","3","3","Satan ga lok tin, “Do nenu nitna ne Moroa, una tong i ri na luuat kusu na vee xongkide.” ");
INSERT INTO mmx_vpl VALUES ("LK4_4","072_4_4","LUK","4","4","4","Iesu ga vorang i rin keretna, “Kopmen. Lovoang Kaala i tong i do, ‘Laradi ixo rooro xusuk mun at lakde.’” ");
INSERT INTO mmx_vpl VALUES ("LK4_5","072_4_5","LUK","4","5","5","La ne Satan ga lok ka i upana at lavatkaana la soso mene nga ga lox ase i mi levengkot axap at na lavatbung menemen. ");
INSERT INTO mmx_vpl VALUES ("LK4_6","072_4_6","LUK","4","6","6","La ne Satan ga lok, “Anaba raba u mi na levengkot axap la lapnovos teren kusu unam gomgo ren. La na lempanga axap nia aga lok kaka i, la nia xa anaba raba nege tara, do nia ana soxolik ka i. ");
INSERT INTO mmx_vpl VALUES ("LK4_7","072_4_7","LUK","4","7","7","Anaa axav i, anaba raba u min, mo do una xis tiktikbu mi luvatgulom taram de melamgo rak la una lotu saparav ia.” ");
INSERT INTO mmx_vpl VALUES ("LK4_8","072_4_8","LUK","4","8","8","Iesu ga vorang i rin keretna, “Kopmen. Lovoang Kaala i tong i do, ‘Una lotu saparap ne Moroa, Leeme Silok taram, la una gugu taba xusux i.’” ");
INSERT INTO mmx_vpl VALUES ("LK4_9","072_4_9","LUK","4","9","9","La ne Satan ga lok ka i uto Jerusalem la ga vaxaru i ro vana at lavatlak gu at loogu laplavang, la ga lok tin, “Mo do nenu ne nitna ne Moroa, una los si basinge na loxot. ");
INSERT INTO mmx_vpl VALUES ("LK4_10","072_4_10","LUK","4","10","10","Mila Lovoang Kaala i tong i do, ‘Moroa naba tong i ri lubung angelo ren kusu dinaba lok tatao avukar u.’ ");
INSERT INTO mmx_vpl VALUES ("LK4_11","072_4_11","LUK","4","11","11","La i tong box i do, ‘Dinaba rebeng aurur u mi lengkikngen di, kusu tuuat noxo sev asongot tekot at luxangkedek taram.’” ");
INSERT INTO mmx_vpl VALUES ("LK4_12","072_4_12","LUK","4","12","12","Iesu ga vorang i rin keretna, “Kopmen. Lovoang Kaala i tong i do, ‘Nemen uta lok li gat ne Moroa, Leeme Silok taram ti loklok tong pen.’” ");
INSERT INTO mmx_vpl VALUES ("LK4_13","072_4_13","LUK","4","13","13","At leventaangas axap ne Satan ga lok tong pen ne Iesu ren, la melemu ne Satan ga on basinge i la ga ngangais manga i kusu ti tara taaleng melemu. ");
INSERT INTO mmx_vpl VALUES ("LK4_14","072_4_14","LUK","4","14","14","Melemu, Iesu gamlong uto Galili, la lolos at Loroonan Kaala ga nemen teren la ga lok tooro i mi lugugu ren. Levelinga mumu ne Iesu, ga rem teles ap mo lengkot ga nemen saparap Galili. ");
INSERT INTO mmx_vpl VALUES ("LK4_15","072_4_15","LUK","4","15","15","Neni ga anasa limixin to xeneng at laraogu singising la limixin axap diga emi asu aleng min. ");
INSERT INTO mmx_vpl VALUES ("LK4_16","072_4_16","LUK","4","16","16","At lara laaleng Iesu gat pas uto Nasaret, mo lemenemen ni ga silok e. La at laaleng kaala neni gat pas uto at loogu singising i ngan neni gak lok amisix i. Ni ga xatu upana kusu na us Lovoang Kaala. ");
INSERT INTO mmx_vpl VALUES ("LK4_17","072_4_17","LUK","4","17","17","La laradi gomgo ap mo loogu singising ga song araba i mi lugun linga at leeme vapaase ali, ne Aisaia. Ni ga valas i la ni ga long lenget ka loxot ga lok keretna. ");
INSERT INTO mmx_vpl VALUES ("LK4_18","072_4_18","LUK","4","18","18","“Loroonan Kaala at ne Moroa i nemen tarak, mila ira soxolik ka vam ia xusu ana vavang mi Lagale Lavavang tinedi limixin banbalo. Ira sak tiki vam ia xusu ana tong asu langas ti soxomus asu limixin di nemen at loogu xokoxo, la ana lox arepalas lengkatli atnedi luvuttadi mi lengkatli atdi i main. La ana soxomus asu limixin di baava mi laxanmumuat at na lavatkangka, ");
INSERT INTO mmx_vpl VALUES ("LK4_19","072_4_19","LUK","4","19","19","la ana tong asu levenaleng ne Moroa na vaxaru kaxat lugugu ti lox arooro limixin teren.” ");
INSERT INTO mmx_vpl VALUES ("LK4_20","072_4_20","LUK","4","20","20","La ne Iesu ga vegun ka lugun linga, la ga raba i ri laradi gak lok tatao loogu, la ni ga xis kopok. Limixin axap go xeneng at loogu singising diga ven tooro ne Iesu. ");
INSERT INTO mmx_vpl VALUES ("LK4_21","072_4_21","LUK","4","21","21","La ni ga lok tidi xeretna, “Anaa levelinga at Lovoang Kaala ira soorun ta ningina, kerekngan tai mo mi ronga i.” ");
INSERT INTO mmx_vpl VALUES ("LK4_22","072_4_22","LUK","4","22","22","Diga ronga ka levelinga ren la diga sangu mila levelinga ren ga sixit nunuan mun. Diga lok, “Neni nitna ne Josep mun, la kereva neni i epovo na tong i na levelinga?” ");
INSERT INTO mmx_vpl VALUES ("LK4_23","072_4_23","LUK","4","23","23","Ni ga lok tidi, “A lok do minaba tong asu i na lavapaase poovo ria, ‘Laradi sangsanga, una lox aroo xa u.’ La minaba lok bok tia, ‘Una lok mo lempanga sangsangu nade at lemenemen taram i ngan ta ugak lox i ro Kaprenaum.’” ");
INSERT INTO mmx_vpl VALUES ("LK4_24","072_4_24","LUK","4","24","24","La ne Iesu ga lok bok tidi, “A tong tuturun i na rinimi. Leeme vapaase ali, limixin di noxo siam ka i ro at lemenemen axa ren. ");
INSERT INTO mmx_vpl VALUES ("LK4_25","072_4_25","LUK","4","25","25","Mina ronga i na levelinga. At levenaleng at ne Elaisa, la goxopmen tara takabu at lavantun mi loxonatat maares la langsangan loroxo ga rupot ap mo lenep axap. I ruturun do buaang lempatnaa to Israel, ");
INSERT INTO mmx_vpl VALUES ("LK4_26","072_4_26","LUK","4","26","26","ketla ne Moroa goxo riki ne Elaisa uto at teta atdi, ketla uto xusuk at lavatnaa boro Sarepat, at lenep silok Sidon. ");
INSERT INTO mmx_vpl VALUES ("LK4_27","072_4_27","LUK","4","27","27","La buaang nedi luvuttadi mi lanmeres gu (leprosy) diga nemen go Israel at levenaleng at leeme vapaase ali ne Elaisa. Ketla ne Moroa goxo lox aroo tara atdi, ni ga lox aroo ne Naiman kusuk mun boro at lenep silok Siria.” ");
INSERT INTO mmx_vpl VALUES ("LK4_28","072_4_28","LUK","4","28","28","Se limixin to xeneng at loogu singising diga ronga i na, diga musak aleng. ");
INSERT INTO mmx_vpl VALUES ("LK4_29","072_4_29","LUK","4","29","29","Diga xatu upana, la diga sar asu ne Iesu ukamang basinge mo lemenemen, la diga lok ka i uto lisigege at lakaana mo lemenemen atdi gat kis e, kusu dina lu asi min ukopok. ");
INSERT INTO mmx_vpl VALUES ("LK4_30","072_4_30","LUK","4","30","30","Ketla neni ga vas polo mene ro xantubu at limixin la ga onon ta. ");
INSERT INTO mmx_vpl VALUES ("LK4_31","072_4_31","LUK","4","31","31","Iesu gat pas uto Kaprenaum, lara lemenemen to Galili, la ga anasa limixin at laaleng kaala. ");
INSERT INTO mmx_vpl VALUES ("LK4_32","072_4_32","LUK","4","32","32","Diga sangu aleng at levenanasa ren mila levelinga ren ga mumuat. ");
INSERT INTO mmx_vpl VALUES ("LK4_33","072_4_33","LUK","4","33","33","Lara laradi go xeneng at loogu singising, lagas ga suxuna i, ga xup silok aleng la ga lok, ");
INSERT INTO mmx_vpl VALUES ("LK4_34","072_4_34","LUK","4","34","34","“Aa! Iesu boro Nasaret, lavanga salai u vara i atnama? Kereva, u vot de xusu una lok kapmek nama? Aklen i do nenu nege. Nenu Laradi Melemelengan at ne Moroa!” ");
INSERT INTO mmx_vpl VALUES ("LK4_35","072_4_35","LUK","4","35","35","La ne Iesu ga vaase lolos ti mo lagas keretna, “Una lok pilo, la una vas su basinge na laradi!” La mo lagas ga lu asi mi nom laradi ro melamgo atdi, la ga sixisu basinge i la kopmen goxo lok kapmek toxot at labantuxu ren. ");
INSERT INTO mmx_vpl VALUES ("LK4_36","072_4_36","LUK","4","36","36","La limixin diga sangu, la diga lok tinedi getgesara, “Kereva nom levelinga? Na laradi i vaase ri lagas, la lagas i ronga res teren. Levelinga ren i lolos la i mumuat aleng.” ");
INSERT INTO mmx_vpl VALUES ("LK4_37","072_4_37","LUK","4","37","37","La levelinga mumu ne Iesu ga onon at lengkot axap ap mo lenep. ");
INSERT INTO mmx_vpl VALUES ("LK4_38","072_4_38","LUK","4","38","38","Iesu ga on basinge loogu singising la gat pas uto at loogu at ne Simon la ga vubeles teren. Luvutulom at ne Simon ga meres aleng mi liplivi, la diga tong i na ri ne Iesu. ");
INSERT INTO mmx_vpl VALUES ("LK4_39","072_4_39","LUK","4","39","39","Ni gat pas la ga ru puvung i, la ga vaase lolos ti nom liplivi, la liplivi ga on basinge mo latkin. La soso mun ni ga xatu kaxat upana la ga lox agagas leveluxa ridi. ");
INSERT INTO mmx_vpl VALUES ("LK4_40","072_4_40","LUK","4","40","40","Ga ukantinao laxangking ga lok do na lotup, mo limixin diga vas kaxat eburu mi larapen tangas atdi, digak meres mi levenasen anmeres axap, diga lam ka di uto at ne Iesu. La ni ga lok li lukngen to mavana atnedi getgesara, la ga lox aroo nedi axap. ");
INSERT INTO mmx_vpl VALUES ("LK4_41","072_4_41","LUK","4","41","41","Iesu ga paase ri lubunggas la mo lubunggas bok diga vas su basinge buaang nedi limixin. La lubunggas digap kup keretna, “Nenu nitna ne Moroa!” La ne Iesu ga vaase lolos tidi la ni xopmen goxo ke xepe tara atdi gita vaase, mila digaklen i do neni Lanarong. ");
INSERT INTO mmx_vpl VALUES ("LK4_42","072_4_42","LUK","4","42","42","Ga maxantamak suubu, Iesu ga on basinge mo lemenemen la gat pas uto at lenep mimila. Limixin diga puse rin, la se diga vuse ka i, diga lolos do nemen ni guta vas kaxat basinge di. ");
INSERT INTO mmx_vpl VALUES ("LK4_43","072_4_43","LUK","4","43","43","Ketla neni ga lok tidi, “Anaba vavang bok mi Lagale Lavavang at Linintoo at ne Moroa to bok at levenmenemen petpes, mila ne Moroa ga riki ia xusu ana lox i.” ");
INSERT INTO mmx_vpl VALUES ("LK4_44","072_4_44","LUK","4","44","44","La neni ga vavang to at laraogu singising at lengkot axap at leme Judaia. ");
INSERT INTO mmx_vpl VALUES ("LK5_1","072_5_1","LUK","5","1","1","At lara laaleng Iesu ga tu ro loxon at lavatdan kis Genesaret. Limixin diga esi kakape kusu uto saparav i, kusu dina ronga levelinga at ne Moroa. ");
INSERT INTO mmx_vpl VALUES ("LK5_2","072_5_2","LUK","5","2","2","Ni ga ven legepu sepang to loxon, la luvuttadi sepsep mat no diga lok li vam du la digat gos laxatkat atdi. ");
INSERT INTO mmx_vpl VALUES ("LK5_3","072_5_3","LUK","5","3","3","Iesu ga los kas at lara lesepang (neni lesepang at ne Simon) la ga tong i ri ne Simon kusu na so asu lesepang uto vaxalom lixilik basinge loloxon. Simon ga lox i kuren, la ne Iesu ga xis ap mo lesepang la ga anasa limixin. ");
INSERT INTO mmx_vpl VALUES ("LK5_4","072_5_4","LUK","5","4","4","Se neni ga vaase axap, ni ga lok ti ne Simon, “So asu lesepang taram uto vaxalom lixilik at lisimaramain, la nenu eburu mi larapen tangas taram mina lox asi laxatkat atnimi ukopok kusu mina loloa.” ");
INSERT INTO mmx_vpl VALUES ("LK5_5","072_5_5","LUK","5","5","5","Simon ga lok tin, “Leeme silok, ma gugu lolos at na laaleng kanimin axap la maxo sep ka tenmat. Ketla, mo do u tong pam i, nema maba lox asi laxatkat.” ");
INSERT INTO mmx_vpl VALUES ("LK5_6","072_5_6","LUK","5","6","6","Diga lox asi laxatkat, la laxatkat ga umsu mi laxanmat solo, la laxatkat ga lok do na rekoxorop ta. ");
INSERT INTO mmx_vpl VALUES ("LK5_7","072_5_7","LUK","5","7","7","La diga xalim ka larapen tangas atdi to at lara lesepang petpes kusu dina vot pasa di la dina lok tooro di. Diga vot la diga suxa buru nom legepu sepang mi laxanmat la ma lixilik diga lok do dina dong si. ");
INSERT INTO mmx_vpl VALUES ("LK5_8","072_5_8","LUK","5","8","10","Simon Pita eburu mi larapen tangas teren, diga sangu aleng at laxanmat diga loloa xaka i. Lumdak bok at ne Sebedi, Jems mi ne Jon duga sangu aleng. Se ne Simon Pita ga ven na lavanga ga vot, neni ga xis tiktikbu mi luvatgulom teren to melamgo at ne Iesu la ga lok, “Leeme Silok, uto u basinge ia! Nia laradi xapmek!” Iesu ga lok ti ne Simon, “Nemen uta marat. I ruka i lingina una loloa ka limixin!” ");
INSERT INTO mmx_vpl VALUES ("LK5_11","072_5_11","LUK","5","11","11","Digatla oso mi levesepang uto loxon, la diga on basinge lempanga axap, la diga mumu asu ne Iesu. ");
INSERT INTO mmx_vpl VALUES ("LK5_12","072_5_12","LUK","5","12","12","At lara laaleng Iesu ga nemen to at lara lemenemen. La ni ga ekip tangarang mi laradi ga meres mi lanmeres gu (leprosy), mo ga umsu at labantuxu ren. Se neni ga ven ne Iesu, ni ga xis tiktikbu mi luvatgulom teren la ga sing ne Iesu, “Leeme Silok. Mo do u vara i, una lox aroo ia!” ");
INSERT INTO mmx_vpl VALUES ("LK5_13","072_5_13","LUK","5","13","13","Iesu ga song asu mi lekngen la ga long tu ren, la ga lok tin, “A vara i. Lanmeres taram na xap ta.” La soso mun mo lanmeres ga xap basinge mo laradi. ");
INSERT INTO mmx_vpl VALUES ("LK5_14","072_5_14","LUK","5","14","14","Iesu ga vaase lolos tin, “Nemen uta tong box i na ri tara, ketla unat pas uto at lamaasa, la neni na ven mumu u. Melemu una lok laramtaba ram ti ne Moroa ngan ne Moses ga tong i, kusu ti lox asuusu i ri limixin axap do nenu mo ura lox avukat ta.” ");
INSERT INTO mmx_vpl VALUES ("LK5_15","072_5_15","LUK","5","15","15","Ketla levelinga mumu ne Iesu ga epeseves ampana uto at lengkot axap, la buaang limixin diga vot kusu dina ronga i la kusu neni na lox aroo nedi basinge levenanmeres atdi. ");
INSERT INTO mmx_vpl VALUES ("LK5_16","072_5_16","LUK","5","16","16","Ketla amisik neni gat pas uto at lengkot mimila, kusu na ngising. ");
INSERT INTO mmx_vpl VALUES ("LK5_17","072_5_17","LUK","5","17","17","At lara laaleng ne Iesu ga anasa. Lentaba lubung Parisi la luvuttadi loklox ase at Laulis Linga mo digat kis, diga laa boro at laramenemen axap to Galili la boro bok Judaia, la boro bok Jerusalem. Lolos at ne Moroa ga umsu ren kusu na lox aroo levenanmeres. ");
INSERT INTO mmx_vpl VALUES ("LK5_18","072_5_18","LUK","5","18","18","Lentaba luvuttadi digap kip lara laradi mi loora, labantuxu ren ga molo axap la diga lok tong i do, dina xip ka i uto xeneng at loogu la dina vaxamdi i ro melamgo at ne Iesu. ");
INSERT INTO mmx_vpl VALUES ("LK5_19","072_5_19","LUK","5","19","19","Ketla buaang nedi limixin diga umsu, la di goxo epovo kusu dina lox abeles lanmeres ukeneng. Kuren la diga xip kaka i upana at lavatlak gu, la diga lok das lenep teren, la diga lox asi lanmeres mi loora ren ukopok la diga lok li i ro melamgo at ne Iesu, kantubu at limixin. ");
INSERT INTO mmx_vpl VALUES ("LK5_20","072_5_20","LUK","5","20","20","Se ne Iesu ga ven kisip lununu atdi, neni ga lok ti nom laradi, “Lentangas tarak, leveloklok kakapmek axap taram, a doxoma xepe i.” ");
INSERT INTO mmx_vpl VALUES ("LK5_21","072_5_21","LUK","5","21","21","Luvuttadi loklox ase at Laulis Linga eburu mi lubung Parisi diga epaase kantubu atdi xeretna, “Nege i na laradi i paase vupu ri ne Moroa xeretna? Kopmen teta i epovo kusu na doxoma xepe laxapmek at tara. Moroa xusuk mun i epovo!” ");
INSERT INTO mmx_vpl VALUES ("LK5_22","072_5_22","LUK","5","22","22","Iesu gaklen levendoxoma atdi la ga lok tidi, “Tila lodoxoma atnimi i ekarakat mumu na lavanga? ");
INSERT INTO mmx_vpl VALUES ("LK5_23","072_5_23","LUK","5","23","23","Ua levelinga kopmen na lolos ti tong i. Leveloklok kakapmek taram ara doxoma xepe vam i, kopla ana tong i do, katu kaxat la unat pas? ");
INSERT INTO mmx_vpl VALUES ("LK5_24","072_5_24","LUK","5","24","24","Ketla a vara i do minaklen i do, nenia, Laradi Mevana, a ruuna lolos at na lavatbung menemen kusu ti doxoma xepe leveloklok kakapmek!” La ne Iesu ga lok bok ti mo laradi xeretna, “A tong i ru, una xatu upana la una xip kaka loora ram la una vas kaxat ukolonu.” ");
INSERT INTO mmx_vpl VALUES ("LK5_25","072_5_25","LUK","5","25","25","La soso mun mo laradi ga xatu kaxat to melamgo atdi axap, la ga xip ka loora mikmidi ren, la gat pas ukolonu, ga emi asu mi ne Moroa. ");
INSERT INTO mmx_vpl VALUES ("LK5_26","072_5_26","LUK","5","26","26","Nedi axap diga sangu. La diga emi asu mi ne Moroa, la diga lok, “Lavanga vetpes dik dira ven i lingina!” ");
INSERT INTO mmx_vpl VALUES ("LK5_27","072_5_27","LUK","5","27","27","Melemu at nai, Iesu ga vas kaxat basinge mo lenep la neni ga ven laradi loklok ka pilas laasen teren ne Levi, gat kis to at loogu xekepe pilas. La ne Iesu ga lok tin, “Una mumu asu ia.” ");
INSERT INTO mmx_vpl VALUES ("LK5_28","072_5_28","LUK","5","28","28","La ne Levi ga xatu kaxat, ga ke xepe lempanga axap teren, la ga mumu asu ne Iesu. ");
INSERT INTO mmx_vpl VALUES ("LK5_29","072_5_29","LUK","5","29","29","La ne Levi ga lok leluxa silok to at loogu ren do ri ne Iesu, la buaang nedi luvuttadi loklok ka pilas eburu mi lentaba luvuttadi bok, mo digat kis eburu min kusu ti anan. ");
INSERT INTO mmx_vpl VALUES ("LK5_30","072_5_30","LUK","5","30","30","Lentaba atnedi lubung Parisi la lentaba bok atdi luvuttadi loklox ase at Laulis Linga, diga vaase kuxurung ti lavaun pinivu at ne Iesu. Diga sue xeretna, “Tila mi anan la mi inin eburu mi luvuttadi loklok ka pilas la limixin kakapmek bok?” ");
INSERT INTO mmx_vpl VALUES ("LK5_31","072_5_31","LUK","5","31","31","Iesu ga ronga i nom la ga lok tidi xeretna, “Limixin di lox avukat, kopmen dinak pakes ti loklok tooro, ketla nedi xusuk mun dik meres. ");
INSERT INTO mmx_vpl VALUES ("LK5_32","072_5_32","LUK","5","32","32","Aga rupot kusu ti ro xaka limixin bilinga kusu dina leeng, la kopmen nia a goxo rupot kusu tinedi limixin manmanton.” ");
INSERT INTO mmx_vpl VALUES ("LK5_33","072_5_33","LUK","5","33","33","Lentaba luvuttadi diga lok ti ne Iesu xeretna, “Lavaun pinivu at ne Jon din mun anan amisik, la di ngising amisik, la lavaun pinivu bok at lubung Parisi din mun anan. Ketla lavaun pinivu ram kopmen dina mun anan.” ");
INSERT INTO mmx_vpl VALUES ("LK5_34","072_5_34","LUK","5","34","34","La ne Iesu ga vorang i ridi mi lavapaase poovo xeretna, “At loklox anarong ti leepot, lentaba at laradi epot di noxo mun anan mila laradi epot move ik lok eburu midi. ");
INSERT INTO mmx_vpl VALUES ("LK5_35","072_5_35","LUK","5","35","35","Ketla laaleng move naba rupot la limixin petpes dinaba lam ka laradi epot basinge lentaba ren la dinan mun anan ba ap mo levenaleng.” ");
INSERT INTO mmx_vpl VALUES ("LK5_36","072_5_36","LUK","5","36","36","La ne Iesu ga vaase bok tidi mi lavapaase poovo xeretna, “Kopmen teta na balais ka loxontamon maxat kusu na sok gatgat pe lamamara at labantamon maut. Mo do neni na lox i xuren, labantamon maxat ira lok kapmek pam la kopmen na epovo bok ba xusu ata ba lok tavanga min. La nom loxontamon maxat noxo epovo xusu na lok pe avukat lamamara at loxontamon maut.” ");
INSERT INTO mmx_vpl VALUES ("LK5_37","072_5_37","LUK","5","37","37","La ne Iesu ga vaase bok tidi mi lavapaase poovo. Ni ga lok keretna, “Kopmen tara na soli li laxadan vaen maxat uto xeneng ti labantuxu at lavatme i maut pam. Mo do neni na lox i xuren, mo labantuxu maut naba repagam la laxadan vaen naba soli su ukamang, la labantuxu maut naba lok kapmek. ");
INSERT INTO mmx_vpl VALUES ("LK5_38","072_5_38","LUK","5","38","38","Laxadan vaen maxat mina soli li i at labantuxu maxat! ");
INSERT INTO mmx_vpl VALUES ("LK5_39","072_5_39","LUK","5","39","39","Kopmen tara i vara laxadan vaen maxat melemu do ni ira in pam laxadan vaen maut, neni ba lok, laxadan vaen maut i lox avukat tin.” ");
INSERT INTO mmx_vpl VALUES ("LK6_1","072_6_1","LUK","6","1","1","At lara laaleng kaala Iesu gat pas kantubu at leventaamang piao. La lavaun pinivu ren diga xidik kaka lempeven piao, la diga sigis i mi levengkikngen di ti lok pes labantuxu at lempiao la diga anan ba i. ");
INSERT INTO mmx_vpl VALUES ("LK6_2","072_6_2","LUK","6","2","2","La lentaba lubung Parisi diga lok, “Laai nom mik lox i, la mira los polo Laulis Linga, i tong i do nemen mitak lok panga keretnom at laaleng kaala?” ");
INSERT INTO mmx_vpl VALUES ("LK6_3","072_6_3","LUK","6","3","3","La ne Iesu ga vorang i ridi xeretna, “Mina doma su at lempanga ne Devit ga lox i at laaleng neni eburu mi limixin teren diga roxo. ");
INSERT INTO mmx_vpl VALUES ("LK6_4","072_6_4","LUK","6","4","4","Neni ga vubeles uto at loogu at ne Moroa, la ga lok ka lengkongkide digam taba min ti ne Moroa, la ni ga anan i la ga raba bok lengkot ti limixin teren. La kerepmo diga los polo Laulis Linga, mila lavamaasa xusuk mun diga anan nom lengkongkide.” ");
INSERT INTO mmx_vpl VALUES ("LK6_5","072_6_5","LUK","6","5","5","La ne Iesu ga lok bok, “Nenia Laradi Mevana. La nenia Lamgomgo at laaleng kaala la ak lok tatao mo laaleng.” ");
INSERT INTO mmx_vpl VALUES ("LK6_6","072_6_6","LUK","6","6","6","At lara laaleng kaala manga, Iesu ga beles to xeneng at loogu singising la ga anasa. Lara laradi mo ga nemen lekngen tino ga molo. ");
INSERT INTO mmx_vpl VALUES ("LK6_7","072_6_7","LUK","6","7","7","Lentaba luvuttadi loklox ase at Laulis Linga la lubung Parisi digam doma i do dina lok li ne Iesu at lavapaase, la diga reven mumu i do neni naba lox aroo mo laradi at laaleng kaala. ");
INSERT INTO mmx_vpl VALUES ("LK6_8","072_6_8","LUK","6","8","8","Ketla ne Iesu gaklen levendoxoma atdi, la ni ga lok ti mo laradi lekngen ga molo, “Katu kaxat la unat pas ude melamgo.” Nom laradi ga xatu kaxat la ga ru ro melamgo. ");
INSERT INTO mmx_vpl VALUES ("LK6_9","072_6_9","LUK","6","9","9","La ne Iesu ga lok tidi, “Ana sue nimi. Lavanga salai Laulis Linga i siam min kusu ata lox i at laaleng kaala? Ti lok tooro laradi kopla ti lox asongor i? Ti lox arooro laradi kopla ti lok kapmex i?” ");
INSERT INTO mmx_vpl VALUES ("LK6_10","072_6_10","LUK","6","10","10","Ni ga ven tangtagap tinedi axap, la ga lok ti mo laradi, “Song asu mi lakngam.” Ni ga lox i xuren, la lekngen ga lox avukat ta. ");
INSERT INTO mmx_vpl VALUES ("LK6_11","072_6_11","LUK","6","11","11","Ketla diga umsu mi lumukmusak la diga epaase mumu lavanga salai diba lox i ri ne Iesu. ");
INSERT INTO mmx_vpl VALUES ("LK6_12","072_6_12","LUK","6","12","12","At lara laaleng Iesu gat pas uto vana at lakaana kusu na lok lising, la ap mo laxanimin axap, neni gak lok lising teren ti ne Moroa go. ");
INSERT INTO mmx_vpl VALUES ("LK6_13","072_6_13","LUK","6","13","13","Se at laxangking ga losu ga maxantamak suubu, neni ga ro bubua ka lavaun pinivu ren saparav i la ga soxolik ka lasangaun legepura atnedi, mo ni ga so asen di do luvuttadi vavang. ");
INSERT INTO mmx_vpl VALUES ("LK6_14","072_6_14","LUK","6","14","14","Simon (ni ga so asen i do ne Pita) la neton laasen teren ne Endru; Jems, la ne Jon, Pilip la ne Batolomiu, ");
INSERT INTO mmx_vpl VALUES ("LK6_15","072_6_15","LUK","6","15","15","Metiu la ne Tomas, lara ne Jems bok nitna ne Alpias, la ne Simon (neni lara at libinam tadi Selot), ");
INSERT INTO mmx_vpl VALUES ("LK6_16","072_6_16","LUK","6","16","16","Judas, nitna ne Jems mi ne piken ne Judas Iskariot. Neni mo laradi ga song araba ne Iesu ri limixin munepen kusu dina sev amer i. ");
INSERT INTO mmx_vpl VALUES ("LK6_17","072_6_17","LUK","6","17","17","La ne Iesu eburu mi lavaun pinivu ren diga si boro vana at lakaana, la ne Iesu ga ru ro at loxot mamana eburu minedi buaang limixin diga mumu asu i. Buaang nedi limixin bok mo digak lok go, boro at lengkot axap Judaia, la boro bok Jerusalem, la boro loxon bok saparap lumenemen Taia la Sidon. ");
INSERT INTO mmx_vpl VALUES ("LK6_18","072_6_18","LUK","6","18","18","Diga vot kusu dina ronga i la ni na lox aroo nedi basinge levenanmeres atdi. Nedi bok limixin, lubunggas ga lox asongot nedi, diga vot la ni ga riki asu lubunggas basinge di. ");
INSERT INTO mmx_vpl VALUES ("LK6_19","072_6_19","LUK","6","19","19","La limixin diga lok tong pen i do dina long tu ren, mila lolos ga ravasu basinge i la ga lox avukat nedi axap. ");
INSERT INTO mmx_vpl VALUES ("LK6_20","072_6_20","LUK","6","20","20","Iesu ga ven ti lavaun pinivu ren la ga lok, “Nemi limixin banbalo, mina momo, mila minaba vubeles at Linintoo no vana at laxalibet. ");
INSERT INTO mmx_vpl VALUES ("LK6_21","072_6_21","LUK","6","21","21","Nemi limixin mo mik toxo, mina momo mila minaba ruuna epovo leveluxa. Nemi limixin monga ming teng, mina lok momo mila melemu minabang longon mi lomomo. ");
INSERT INTO mmx_vpl VALUES ("LK6_22","072_6_22","LUK","6","22","22","Mo do limixin kakapmek dina ven nimi mina mumu asu ia, Laradi Mevana, la dina belengatngas tinimi, la dina sok tixirixes nimi, la dina vaase kapmek tinimi, la dina lok tinimi do nemi limixin kakapmek, mina lok momo. ");
INSERT INTO mmx_vpl VALUES ("LK6_23","072_6_23","LUK","6","23","23","Mina momo aleng do na lempanga na vot, la minat los mi lososoro, mila langsangan luunun tinimi mo i nemen tangais nimi no vana at laxalibet. Do na lempanga na vot, nemen mita lok bukbulu. Lavalabat atnedi mo limixin kakapmek diga lok bok lempanga xapmek kerepmo tinedi lavaeme vapaase ali at ne Moroa. ");
INSERT INTO mmx_vpl VALUES ("LK6_24","072_6_24","LUK","6","24","24","Ketla naba lok kapmek tinemi, mo mip novos. Mila mirap novos avukat pam at na lorooro. ");
INSERT INTO mmx_vpl VALUES ("LK6_25","072_6_25","LUK","6","25","25","Naba lok kapmek tinimi monga mi umsu mi laxampanga solo, atla minabak toxo! Naba lok kapmek tinimi monga mik lok momo, mila minabak lok tuntun la minang teng! ");
INSERT INTO mmx_vpl VALUES ("LK6_26","072_6_26","LUK","6","26","26","Naba lok kapmek tinimi, do limixin axap dina paase avukat mumu nimi, mila lavalabat atnedi mo limixin kakapmek diga paase avukat mumu nedi lavaeme vapaase ali xaxarang.” ");
INSERT INTO mmx_vpl VALUES ("LK6_27","072_6_27","LUK","6","27","27","La ne Iesu ga lok bok tidi xeretna, “A tong i rinimi mo ming tonga ia. Mina balamu nedi dit kis munepen minimi, la mina lok luvukat tinedi di belengatngas tinimi. ");
INSERT INTO mmx_vpl VALUES ("LK6_28","072_6_28","LUK","6","28","28","Mina lox anarong nedi di vaase kapmek tinimi la mina sing tinedi di metlaat minimi. ");
INSERT INTO mmx_vpl VALUES ("LK6_29","072_6_29","LUK","6","29","29","Mo do tara na vasa lavapaales at tara atnimi, ni na ke box i do neni na vasa bok mo lenep meo. Mo do tara na lok kaka tavanga singsiga at tara atnimi, ni na ke box i do neni na lok ka tavanga singsiga silok bok. ");
INSERT INTO mmx_vpl VALUES ("LK6_30","072_6_30","LUK","6","30","30","Mina raba nedi di ngising nimi ri tempanga. La do tara na lok ka tavanga do atnimi, nemen mita sing amlong tin. ");
INSERT INTO mmx_vpl VALUES ("LK6_31","072_6_31","LUK","6","31","31","Loklok mina lox i rinedi, i ngan mun loklok mi vara i do dina lox i rinimi. ");
INSERT INTO mmx_vpl VALUES ("LK6_32","072_6_32","LUK","6","32","32","Mo do mi balamu xusuk mun nedi di balamu nimi, mi noxo ruuna ka loklox anarong at nom. Mila limixin kakapmek bok dik lox i xuren. ");
INSERT INTO mmx_vpl VALUES ("LK6_33","072_6_33","LUK","6","33","33","La mo do mina lok luvukat kusuk mun tinedi di lok luvukat tinimi, mi noxo ruuna ka loklox anarong at nom. Mila limixin bilinga bok dik lox i xuren. ");
INSERT INTO mmx_vpl VALUES ("LK6_34","072_6_34","LUK","6","34","34","La mo do mina raba xusuk nedi mo mi doxoma i do diba vorang i rinimi, mi noxo ruuna ka loklox anarong at nom. Mila limixin kakapmek bok pam, dim taba nedi limixin kakapmek kusu diba lok ka amlong bok lempanga ba epovo mi mo lempanga diga raba i. ");
INSERT INTO mmx_vpl VALUES ("LK6_35","072_6_35","LUK","6","35","35","Mina balamu limixin dit kis munepen minimi, la mina lok luvukat tidi. Mina raba di mi lempanga la nemen gat mita sing amlong tin. Do mina lok na lempanga avukat, minaba ruuna ka langsangan luunun, la nemi minaba ngan laxamdak at Leeme Avolo. Mila Moroa ik lox avukat tinedi limixin kopmen dinak lox avukat tin la tinedi bok dik lok laxakapmek. ");
INSERT INTO mmx_vpl VALUES ("LK6_36","072_6_36","LUK","6","36","36","Mina balamu limixin axap, kerekngan mun ne Temen nimi ne Moroa i balamu limixin axap.” ");
INSERT INTO mmx_vpl VALUES ("LK6_37","072_6_37","LUK","6","37","37","La ne Iesu ga lok bok tidi xeretna, “Nemen mita ila mumu loklok at tara kusu ne Moroa noxo ila mumu loklok atnimi. Nemen mita lok li tavapaase mavana at tara, kusu ne Moroa noxo lok li tavapaase mavana atnimi. Mina doxoma xepe laxakapmek atnedi di lox i rinimi, la kerepmo ne Moroa naba doxoma xepe laxakapmek atnimi. ");
INSERT INTO mmx_vpl VALUES ("LK6_38","072_6_38","LUK","6","38","38","Mina raba limixin petpes mi lempanga, kusu ne Moroa naba raba nimi mi lempanga. Minaba ruuna ka langsangan luunun i umsu aleng, i ngan lempanga avukat di soli li i at levengkikngen nimi la mo axap lempanga mina sang kobot teren. Lempanga mi lox i rinedi vetpes, neni mun i nom ne Moroa naba raba i rinimi.” ");
INSERT INTO mmx_vpl VALUES ("LK6_39","072_6_39","LUK","6","39","39","La ne Iesu ga tong asu lara lavapaase poovo tidi xeretna, “Taradi mi luxatli main teren ixo epovo kusu na sat kaka taradi bok mi luxatli main teren. Mo do neni na lox i xuren, nedu buru duba subu tup ti lamamara. ");
INSERT INTO mmx_vpl VALUES ("LK6_40","072_6_40","LUK","6","40","40","Laxamdak loklox ase kopmen dina silok ti laradi loklox ase atdi. Ketla ise do nedi axap laxamdak loklox ase dira lox axap loklox ase atdi, nedi diba epovo ba mi laradi loklox ase atdi.” ");
INSERT INTO mmx_vpl VALUES ("LK6_41","072_6_41","LUK","6","41","41","La ne Iesu ga paase poovo bok keretna, “Nemen mita reven ti nom levendon i nemen at laxatli at neton nimi, la nemi xa kopmen mina long lenget ka loxonuna ik lok pe lengkatli atnimi. ");
INSERT INTO mmx_vpl VALUES ("LK6_42","072_6_42","LUK","6","42","42","Miba tong i ri neton nimi xeretna, ‘Neton nama, una mulus tinama xusu mana lok pes nom levendon at laxatli ram.’ Ketla nemi xa kopmen mina ven kibis lengkonuna ik lok pe lengkatli atnimi. Nemi luvuttadi loklok sosolom. Mina lok pes avot nom lengkonuna ik lok pe lengkatli atnimi la melemu ba, miba lok epovo ba i xusu mina lok pes ba levendon no at laxatli at neton nimi.” ");
INSERT INTO mmx_vpl VALUES ("LK6_43","072_6_43","LUK","6","43","43","La ne Iesu ga paase poovo bok keretna, “Luuna nunuan kopmen na pisik larapeven una xapmek. La luuna xapmek kopmen na pisik tarapeven una avukat. ");
INSERT INTO mmx_vpl VALUES ("LK6_44","072_6_44","LUK","6","44","44","Larauna axap, limixin di ven kibis di mi larapeven una atdi di pisix i. Kopmen mina lok ka larapeven at laban arakap to at laban gagas, kopla larapeven una at luuna vaen to at tuuna gamasa mun. ");
INSERT INTO mmx_vpl VALUES ("LK6_45","072_6_45","LUK","6","45","45","Laradi avukat ik lox asu lununuan boro at lempanga avukat i nemen keneng at lebelen. Laradi xapmek ik lox asu laxakapmek boro at lempanga xapmek i nemen keneng at lebelen. La kerepmo lungusno at laradi i vaase asu lempanga salai i umsu at lebelen.” ");
INSERT INTO mmx_vpl VALUES ("LK6_46","072_6_46","LUK","6","46","46","La ne Iesu ga tong bok lavapaase poovo ridi xeretna, “Tila mi tong ia do, ‘Leeme Silok, Leeme Silok,’ ketla kopmen mina mumu asu levelinga rak? ");
INSERT INTO mmx_vpl VALUES ("LK6_47","072_6_47","LUK","6","47","47","Ana lox ase nimi mi tara neni ing tonga levelinga rak la ira mumu asu i. ");
INSERT INTO mmx_vpl VALUES ("LK6_48","072_6_48","LUK","6","48","48","Neni i ngan laradi ga vaxaru loogu. Ga sev asi lemet ukopok tinotno la gara lok li ba laraexem at nom loogu uto at laxanuat. Ladanut ga xip pot la gak ma nom loogu, ketla loogu kopmen goxo subu. Mila ni ga xip avukat tinotno i. ");
INSERT INTO mmx_vpl VALUES ("LK6_49","072_6_49","LUK","6","49","49","Ketla mo laradi i ronga levelinga rak la kopmen na mu asu i, neni i ngan laradi ga vaxaru loogu to at laxangka, la kopmen ni goxo vaxaru i at laxanuat. Ise ladanut gak ma nom loogu, la soso mun ga subu, la ga rem utut axap.” ");
INSERT INTO mmx_vpl VALUES ("LK7_1","072_7_1","LUK","7","1","1","Iesu ga vaase axap mo levelinga rinedi limixin, la neni gat pas uto Kaprenaum. ");
INSERT INTO mmx_vpl VALUES ("LK7_2","072_7_2","LUK","7","2","2","Lara laasesep at limixin esep boro Rom mo gak lok, neni ga ruuna lasaxaruki, la neni ga vavara aleng tinotno i. Mo lasaxaruki gak meres la ma lixilik neni ga lok do na met. ");
INSERT INTO mmx_vpl VALUES ("LK7_3","072_7_3","LUK","7","3","3","Se nom laasesep ga ronga levelinga mumu ne Iesu, neni ga riki lentaba luvuttadi silok at leme Judaia saparap ne Iesu, kusu dina sing i do ni nat pas la na lox aroo mo lasaxaruki ren. ");
INSERT INTO mmx_vpl VALUES ("LK7_4","072_7_4","LUK","7","4","4","Diga vot parap ne Iesu la diga sing aleng i xeretna, “I lox avukat tinotno do una lok tooro mo laasesep, ");
INSERT INTO mmx_vpl VALUES ("LK7_5","072_7_5","LUK","7","5","5","mila neni i balamu aleng limixin me Judaia la neni ga raba pilas kusu na xip loogu singising atnama.” ");
INSERT INTO mmx_vpl VALUES ("LK7_6","072_7_6","LUK","7","6","6","Kuren la ne Iesu ga emu eburu minedi. Goxo vaxalom boro ap mo loogu, la mo laasesep ga riki lentaba larapen tangas teren kusu dina vot pasa ne Iesu. Diga tong asu levelinga at laasesep ga lok keretna, “Leeme Silok, nemen uta rupot saparav ia. Nenu u silok solo la ixo lox avukat do una beles at loogu rak, ");
INSERT INTO mmx_vpl VALUES ("LK7_7","072_7_7","LUK","7","7","7","la nenia axo lox avukat kusu ana vot parav u. Ketla una tong mun i la lasaxaruki rak naba lox avukat. ");
INSERT INTO mmx_vpl VALUES ("LK7_8","072_7_8","LUK","7","8","8","Nenia aklen i do nenu u epovo ri lox i na mila nenia a nemen maxopok at lentaba gomgo rak la lentaba bok di nemen maxopok tarak. A lok ti lara, ‘Unat pas!’ la ni it pas. A lok ti lara, ‘Ude u!’ la ni it pas saparav ia. La a lok ti lasaxaruki rak, ‘Una lox i na!’ la ni i lox i.” ");
INSERT INTO mmx_vpl VALUES ("LK7_9","072_7_9","LUK","7","9","9","Iesu ga ronga i na levelinga, la ga sangu aleng. Neni ga ru gili la ga lok ti limixin diga mumu asu i, “A tong i rinimi do, keneng at lengkot axap Israel, a goxo long lenget tara lununu ren i silok ngan na laradi!” ");
INSERT INTO mmx_vpl VALUES ("LK7_10","072_7_10","LUK","7","10","10","Mo luvuttadi, laasesep ga riki nedi, digamlong uto at loogu ap mo laasesep la diga long lenget ka lasaxaruki ren mo ga lox avukat ta. ");
INSERT INTO mmx_vpl VALUES ("LK7_11","072_7_11","LUK","7","11","11","Melemu lixilik Iesu ga vas kaxat uto at lara lemenemen laasen teren Nain, la lavaun pinivu ren eburu minedi buaang limixin diga emu min. ");
INSERT INTO mmx_vpl VALUES ("LK7_12","072_7_12","LUK","7","12","12","Diga rupot go at langas povolo ap mo lemenemen. La limixin mo digap kip lara lorongan, neni leges amdak mun at labannaa, la buaang nedi limixin ap mo lemenemen digat pas eburu min. ");
INSERT INTO mmx_vpl VALUES ("LK7_13","072_7_13","LUK","7","13","13","Se Leeme Silok ga ven i, lebelen ga lok bukbulu aleng tin la ni ga lok ti mo labannaa, “Nemen utang teng.” ");
INSERT INTO mmx_vpl VALUES ("LK7_14","072_7_14","LUK","7","14","14","La neni ga vas saparap mo lorongan la ga long tu at loora ren la mo luvuttadi digap kiv i, diga ru. Iesu ga lok, “Laau radi! A tong i ru do, una xatu kaxat!” ");
INSERT INTO mmx_vpl VALUES ("LK7_15","072_7_15","LUK","7","15","15","Laradi no ga met ga xis upana la ni ga vaase la ne Iesu ga lok ka i la ga raba amlong nenen min. ");
INSERT INTO mmx_vpl VALUES ("LK7_16","072_7_16","LUK","7","16","16","Limixin axap diga lingun la diga emi asu mi ne Moroa, la diga lok, “Langsangan leeme vapaase ali ira vot pam kantubu atdik! La ne Moroa ira vot pam kusu na lox arooro limixin teren!” ");
INSERT INTO mmx_vpl VALUES ("LK7_17","072_7_17","LUK","7","17","17","La na levelinga mumu ne Iesu ga epeseves ap mo lenep silok axap la at levennep petpes bok saparap Judaia. ");
INSERT INTO mmx_vpl VALUES ("LK7_18","072_7_18","LUK","7","18","18","Lavaun pinivu at ne Jon diga tong mo levelinga mumu ne Iesu ri ne Jon. Neni ga ro xaka lura atdi saparav i, ");
INSERT INTO mmx_vpl VALUES ("LK7_19","072_7_19","LUK","7","19","19","la ga riki du saparap Leeme Silok kusu duna sue i mi levelinga xeretna, “Kereva, nenu vam Lanarong, kopla tara gove manaba ngangais i?” ");
INSERT INTO mmx_vpl VALUES ("LK7_20","072_7_20","LUK","7","20","20","Duga rupot saparap ne Iesu la duga lok, “Jon laradi sep susu, i sak tiki nema kusu mana sue u, ‘Kereva, nenu vam Lanarong, kopla tara gove manaba ngangais i?’” ");
INSERT INTO mmx_vpl VALUES ("LK7_21","072_7_21","LUK","7","21","21","Ap mo laaleng Iesu ga lox aroo buaang nedi limixin basinge levenanmeres la ga riki asu lubunggas basinge limixin la ni ga lox arepalas bok levengkatli atnedi buaang limixin, levengkatli atdi ga main. ");
INSERT INTO mmx_vpl VALUES ("LK7_22","072_7_22","LUK","7","22","22","Neni ga vorang luradi vapaase at ne Jon mi levelinga keretna, “Munamlong la muna tong i ri ne Jon mumu lempanga mu ven i la mu ronga i. Nedi limixin mi lengkatli main, mo di reven manga. Nedi lengkangkedek atdi ga lok kapmek, mo dit pas avukat. La nedi dik meres mi lanmeres gu (leprosy), mo di lox avukat. Nedi levenbaalung i repe, ding tonga manga. La nedi diga met pam, mo di roo xat amlong. La Lagale Lavavang mo a vavang min ti limixin banbalo. ");
INSERT INTO mmx_vpl VALUES ("LK7_23","072_7_23","LUK","7","23","23","Naba lox avukat ti neni laradi noxo subu basinge ia, la lebelen ixo lok kapmek ti na lugugu rak.” ");
INSERT INTO mmx_vpl VALUES ("LK7_24","072_7_24","LUK","7","24","24","La luradi ne Jon ga riki du, dugamlong, la ne Iesu ga paase ri limixin mumu ne Jon. Ni ga lok, “Nemi migat pas uto saparap ne Jon to at lamatbin, laradi salai miga doxoma i xusu miba ven i? Kereva, miga lok do miba ven laradi i lok ngan lovobeo, lamanman it mas aonen i? ");
INSERT INTO mmx_vpl VALUES ("LK7_25","072_7_25","LUK","7","25","25","Laradi salai migat pas la miga ven i? Kereva, miga ven laradi ga siga lavanga singsiga avukat? Kopmen. Limixin ding siga lempanga singsiga avukat la di ruuna lapnovos silok, nedi kopmen di nemen at lamatbin kerekngan ne Jon. Di nemen to at laraogu nunuan. ");
INSERT INTO mmx_vpl VALUES ("LK7_26","072_7_26","LUK","7","26","26","Mina tong i ria, lavanga salai migat pas kusu mina ven i? Taradi vapaase ali? I ruturun. A tong i rinimi do nemi miga ven laradi i silok ti lavaeme vapaase ali at ne Moroa. ");
INSERT INTO mmx_vpl VALUES ("LK7_27","072_7_27","LUK","7","27","27","Ne Jon neni laradi, Lovoang Kaala ga vaase min keretna, ‘Laradi vapaase rak, anaba riki amgo i ru xusu na lox agagas li langas tu.’” ");
INSERT INTO mmx_vpl VALUES ("LK7_28","072_7_28","LUK","7","28","28","La ne Iesu ga lok bok, “A tong i rinimi do ne Jon neni i silok aleng tinedi limixin axap at na lavatbung menemen. Ketla do tara i lok ngan laradi gamasa la neni lanat at Linintoo at ne Moroa, neni i silok aleng ti ne Jon.” ");
INSERT INTO mmx_vpl VALUES ("LK7_29","072_7_29","LUK","7","29","29","Limixin axap eburu mi luvuttadi loklok ka pilas diga ronga levelinga at ne Iesu. Nedi mun na limixin diga lok kaka lesep susu at ne Jon la kerepmo diga siam ka leventaangas at ne Moroa. ");
INSERT INTO mmx_vpl VALUES ("LK7_30","072_7_30","LUK","7","30","30","Ketla lubung Parisi eburu mi luvuttadi loklox ase at Laulis Linga diga ronga xepe lesep susu at ne Jon, la kerepmo diga sok tixirixes losoxovo at ne Moroa ridi. ");
INSERT INTO mmx_vpl VALUES ("LK7_31","072_7_31","LUK","7","31","31","La ne Iesu ga lok bok, “Limixin at na levenaleng ana vaase poovo midi mi lavanga salai? ");
INSERT INTO mmx_vpl VALUES ("LK7_32","072_7_32","LUK","7","32","32","Di lok ngan laxamdak mi laxaalik kakalik dit kis to at loxot etang. Lara libinam atdi dip kup ti mo libinam, ‘Magak pixan lengkompixan epot tinimi, ketla nemi mi goxopara na tii momo. Magak pixan lengkompixan bukbulu, ketla mi goxopara i do minang teng!’ ");
INSERT INTO mmx_vpl VALUES ("LK7_33","072_7_33","LUK","7","33","33","La ne Jon laradi sep susu ga vot, la ni ga mun anan la kopmen goxo inin laxadan vaen, la nemi miga lok do, ‘Lagas mo i nemen teren!’ ");
INSERT INTO mmx_vpl VALUES ("LK7_34","072_7_34","LUK","7","34","34","Ketla nenia, Laradi Mevana, aga vot, la nia aga anan la aga inin la miga lok, ‘Mina ven ba na laradi! Neni lavatpanga xoxo anan, la laradi inin, la i etangas mi luvuttadi loklok ka pilas eburu mi limixin kakapmek!’ ");
INSERT INTO mmx_vpl VALUES ("LK7_35","072_7_35","LUK","7","35","35","Ketla lugugu at ne Moroa i pisik avukat la kerepmo i lox asuusu i do losoxovo at ne Moroa i lox avukat.” ");
INSERT INTO mmx_vpl VALUES ("LK7_36","072_7_36","LUK","7","36","36","Lara atnedi lubung Parisi ga lam kaka ne Iesu kusu na anan eburu min. Iesu ga beles to xeneng at loogu ren la ga xis kusu ti anan. ");
INSERT INTO mmx_vpl VALUES ("LK7_37","072_7_37","LUK","7","37","37","Lara latkin mo ga nemen ap mo lemenemen, lorooro ren gat pospa aleng. Neni ga ronga i do ne Iesu mo ga anan to at loogu ap mo laradi. Kuren la ni ga lok ka lubuxom tuntu dan teren ga umsu mi laxadan mavak. ");
INSERT INTO mmx_vpl VALUES ("LK7_38","072_7_38","LUK","7","38","38","La ni ga vot pasa ne Iesu la ga ru to melemu saparap luxangkedek teren, gang teng la gak lox amlu luxangkedek at ne Iesu mi levengkabilidan at luxatli ren. La ni ga ves amesemes luxangkedek at ne Iesu mi lavatkabinim at lavatlak teren, la ga nes luxangkedek teren la ga soli laxadan mavak to at nom luxangkedek teren. ");
INSERT INTO mmx_vpl VALUES ("LK7_39","072_7_39","LUK","7","39","39","Nom laradi no ga sat kaka ne Iesu ga ven i na, la neni ga doma i xeretna, “Mo do na laradi neni leeme vapaase ali ruturun, neni gi baklen i do latkin salai mo i long tu ren la lorooro bilinga mo i nemen teren!” ");
INSERT INTO mmx_vpl VALUES ("LK7_40","072_7_40","LUK","7","40","40","La ne Iesu ga lok tin keretna, “Simon, a ruuna lara lavanga kusu ana tong i ru.” Simon ga lok tin, “Laradi loklox ase, una tong i ria.” ");
INSERT INTO mmx_vpl VALUES ("LK7_41","072_7_41","LUK","7","41","41","La ne Iesu ga tong lavapaase poovo mumu labalamu ap mo latkin. Ni ga lok keretna, “Lura luradi duga lok ka lempilas boro at laradi nopnovos. Lara ga lok ka lavalimo sangaun kobot (500) denarias, la mo lara lavalimo sangaun denarias. ");
INSERT INTO mmx_vpl VALUES ("LK7_42","072_7_42","LUK","7","42","42","Nedu eburu du goxo epovo kusu duna vorang amlong mo lempilas teren. Kuren la ni ga lok tidu do nemen duta vorang i. Ua lara atdu na, ba balamu aleng mo laradi?” ");
INSERT INTO mmx_vpl VALUES ("LK7_43","072_7_43","LUK","7","43","43","Simon ga vorang i rin keretna, “Nia a lok do mo lara, laradi nopnovos ga doxomampe lavalimo sangaun kobot (500) denarias teren.” Iesu ga lok, “Lovoporang taram ik mokso.” ");
INSERT INTO mmx_vpl VALUES ("LK7_44","072_7_44","LUK","7","44","44","Melemu Iesu ga rem gili uto at latkin la ga lok ti ne Simon, “Una ven i na latkin. At pas ude at loogu ram, la uxo raba ia mi taxadan kusu ti gos luxangkedek tarak. Ketla neni i gos luxangkedek tarak mi lengkabilidan at luxatli teren la neni i ves mesemes i mi lavatkabinim at lavatlak teren. ");
INSERT INTO mmx_vpl VALUES ("LK7_45","072_7_45","LUK","7","45","45","Nenu xopmen una nes ia, ketla se nenia a beles de xeneng, neni xopmen na molo ti nes luxangkedek tarak. ");
INSERT INTO mmx_vpl VALUES ("LK7_46","072_7_46","LUK","7","46","46","Uxo lok li laxadan mavak at lavatlak tarak, ketla neni i soli laxadan mavak at luxangkedek tarak. ");
INSERT INTO mmx_vpl VALUES ("LK7_47","072_7_47","LUK","7","47","47","Kuren la monga a tong i ru, do langsangan labalamu ren mo ira lox asuusu vam i do a doxoma xepe buaang leveloklok kakapmek teren. Mo do nege, i ruuna lamanbalamu lixilik mun i lox asuusu i do laxakapmek lixilik mun, ara doxoma xepe vam i.” ");
INSERT INTO mmx_vpl VALUES ("LK7_48","072_7_48","LUK","7","48","48","La ne Iesu ga lok ti mo latkin, “Leveloklok kakapmek taram, a doxoma xepe i.” ");
INSERT INTO mmx_vpl VALUES ("LK7_49","072_7_49","LUK","7","49","49","Lentaba luvuttadi digat kis go, diga epaase kantubu atdi xeretna, “Nege i na laradi, la neni xa i doxoma xepe laxakapmek?” ");
INSERT INTO mmx_vpl VALUES ("LK7_50","072_7_50","LUK","7","50","50","Ketla Iesu ga lok ti mo latkin, “Lununu ram ira lok arooro vam u. Unat pas mi limila.” ");
INSERT INTO mmx_vpl VALUES ("LK8_1","072_8_1","LUK","8","1","1","Melemu at lentaba levenaleng manga, Iesu gat pas kantubu at levenmenemen silok la lengkon menemen kakalik, ga vavang mi Lagale Lavavang at Linintoo at ne Moroa. Lasangaun legepura lavaun pinivu diga emu min, ");
INSERT INTO mmx_vpl VALUES ("LK8_2","072_8_2","LUK","8","2","2","la lentaba lavakin bok, gano ne Iesu ga lox avukat nedi basinge levenanmeres atdi la ga riki asu lubunggas basinge di. Ne Maria (laasen bok teren ne Magdalene) gano lavanuti lubunggas ga ravasu basinge i. ");
INSERT INTO mmx_vpl VALUES ("LK8_3","072_8_3","LUK","8","3","3","Joana, latkin at ne Kusa, laradi gomgo gak lok tatao at loogu at ne Erodes. La ne Susana, la nedi buaang bok lavakin diga lok tooro ne Iesu eburu mi lavaun pinivu ren mi levempilas nedi digak pakes tin. ");
INSERT INTO mmx_vpl VALUES ("LK8_4","072_8_4","LUK","8","4","4","Buaang limixin digat pot saparap ne Iesu boro at levenmenemen axap. Se diga vot eburu, Iesu ga tong lavapaase poovo ridi xeretna. ");
INSERT INTO mmx_vpl VALUES ("LK8_5","072_8_5","LUK","8","5","5","“Lara laradi lotlo gat pas uto xataamang kusu natlotlo piao. Lentaba levenit piao ga subu ro at langa, la limixin digat pas teren, la lavapixa diga rava pot la diga rok axav i. ");
INSERT INTO mmx_vpl VALUES ("LK8_6","072_8_6","LUK","8","6","6","Lentaba levenit piao ga subu ro at loxongkangka laxanuat ga nemen teren. La se diga suu kaxat, diga met ta mila mo loxongkangka goxopmen tadan teren. ");
INSERT INTO mmx_vpl VALUES ("LK8_7","072_8_7","LUK","8","7","7","Lentaba levenit piao ga subu ro at livin gagas, la diga suu xat eburu mi nom livin gagas. Ketla livin gagas ga itis di. ");
INSERT INTO mmx_vpl VALUES ("LK8_8","072_8_8","LUK","8","8","8","La lentaba levenit piao ga subu ro at loxongkangka avukat. La na levenit piao ga suu xat la ga visik laxampeven piao solo.” La ne Iesu ga lox axap mo lavapaase poovo la ga lok tidi xeretna, “Do mi ruuna levenbaalung, mina ronga avukat na levelinga.” ");
INSERT INTO mmx_vpl VALUES ("LK8_9","072_8_9","LUK","8","9","9","Lavaun pinivu diga sue ne Iesu do ua lavasuun ap mo lavapaase poovo. ");
INSERT INTO mmx_vpl VALUES ("LK8_10","072_8_10","LUK","8","10","10","La ne Iesu ga lok tidi, “Moroa ira raba vam nimi mi lakleklen at Linintoo ren, gano ga nemen alipe. Ketla tinedi limixin petpes levelinga mumu Linintoo i lok ngan mun lavapaase poovo xusu limixin di noxo xasep teren. I ngan levelinga at Lovoang Kaala i lok keretna, ‘Nedi di reven lugugu, ketla di noxo ven kibis i. Ding tonga mo levelinga, ketla di noxo xasep teren.’” ");
INSERT INTO mmx_vpl VALUES ("LK8_11","072_8_11","LUK","8","11","11","La ne Iesu ga lok tidi xeretna, “Lavasuun at na lavapaase poovo i lok keretna. Levenit neni levelinga at ne Moroa. ");
INSERT INTO mmx_vpl VALUES ("LK8_12","072_8_12","LUK","8","12","12","Ti levenit ga subu ro at langas, i ru katling nedi ding tonga mo levelinga. Ketla ne Satan i tupot la ik lok kepe nom levelinga basinge lebelen di, kusu ti lok pes lununu atdi la di noxo lok kaka lorooro. ");
INSERT INTO mmx_vpl VALUES ("LK8_13","072_8_13","LUK","8","13","13","Ti levenit no ga subu ro at loxot uat, i ru katling nedi di ronga levelinga la di momo xaka i, ketla kopmen na si aleng ukeneng at lorooro atdi. Di nunu mun at loxonatat aleng la do loklok tong pen i vot, dira subu manga. ");
INSERT INTO mmx_vpl VALUES ("LK8_14","072_8_14","LUK","8","14","14","Ti levenit ga subu to at loxongkangka mi laxan gagas, i ru katling nedi di ronga mo levelinga. Ketla levenainbulu la lapnovos la lomomo at na lorooro i umsu xeneng atdi la ira itis lorooro atdi. La kerepmo kopmen dina visik levempanga nunuan at lorooro atdi. ");
INSERT INTO mmx_vpl VALUES ("LK8_15","072_8_15","LUK","8","15","15","Ti levenit no ga subu ro at loxongkangka avukat, i ru katling nedi di ronga mo levelinga la di lok li avukar i xeneng at lebelen di, mo i nunuan axap. La nedi di nemen lolos se di visik levempeven avukat.” ");
INSERT INTO mmx_vpl VALUES ("LK8_16","072_8_16","LUK","8","16","16","La ne Iesu ga tong lavapaase poovo ridi keretna, “Kopmen teta na sox aros lababao la na vung pavaa i mi lavatbaaket kopla na lok li i maxopok at loora. Ketla neni ik lok li i ro at lenep kasep, kusu limixin diba ven losoosoo ren mo do dina beles to xeneng ap mo loogu. ");
INSERT INTO mmx_vpl VALUES ("LK8_17","072_8_17","LUK","8","17","17","Lempanga mumu Linintoo no ga nemen alipe rinotno, naba ravasu ti lasaxaven. La levelinga, lavasuun teren no i nemen alipe, melemu naba xasep. ");
INSERT INTO mmx_vpl VALUES ("LK8_18","072_8_18","LUK","8","18","18","Kuren la mina lok tatao avukat nimi, kusu ting tonga avukat levelinga at ne Moroa. Do tara na siam ka mo levelinga Moroa i raba i min, Moroa naba raba box i mi laxasep avukat at levelinga ren. Dola tara noxo siam ka levelinga at ne Moroa, Moroa naba lok pes bok laxasep kakalik teren, keke i do neni i doxoma i do im tebeng i.” ");
INSERT INTO mmx_vpl VALUES ("LK8_19","072_8_19","LUK","8","19","19","Nenen ne Iesu mi luvutneton diga vot pasa i, ketla di goxo epovo kusu dinat pas saparav i mila limixin diga umsu. ");
INSERT INTO mmx_vpl VALUES ("LK8_20","072_8_20","LUK","8","20","20","Lara laradi ga lok ti ne Iesu, “Nenam eburu mi luvutnetam no di tu kamang la di vara i do dina epaase eburu minu.” ");
INSERT INTO mmx_vpl VALUES ("LK8_21","072_8_21","LUK","8","21","21","Ketla ne Iesu ga lok tidi axap keretna, “Nedi mun ding tonga levelinga at ne Moroa la di mumu asu i, nedi mun luvutnaga mi luvutnetak.” ");
INSERT INTO mmx_vpl VALUES ("LK8_22","072_8_22","LUK","8","22","22","At lara laaleng Iesu ga emu eburu mi lavaun pinivu ren la ni ga lok tidi, “Ata sen polo na lavatdan kis uto at lenep meo.” La diga los kas at lesepang la diga sen kaxat. ");
INSERT INTO mmx_vpl VALUES ("LK8_23","072_8_23","LUK","8","23","23","Se diga sen, Iesu ga unga. La mo langsangan lamanman ga mas lolos mo lavatdan kis, la larapotas ga luxa lesepang la ga auret do lesepang na rem gili la nedi axap dina seeve. ");
INSERT INTO mmx_vpl VALUES ("LK8_24","072_8_24","LUK","8","24","24","Lavaun pinivu diga vot pasa ne Iesu la diga sox aus i la diga lok, “Leeme Silok, Leeme Silok! Ata seeve nga na!” Iesu ga xatu kaxat la ga vaase lolos pe lamanman mi laras ga ekapus. La duga lox atnaasan la langsangan lenmila nga ga nemen. ");
INSERT INTO mmx_vpl VALUES ("LK8_25","072_8_25","LUK","8","25","25","La neni ga sue lavaun pinivu ren, “Kereva, kopmen tununu atnimi?” Ketla diga sangu aleng la diga lingun la diga sue nedi getgesara, “Laradi salai na? I vaase sok lamanman la lavatdan kis la dura ronga res teren!” ");
INSERT INTO mmx_vpl VALUES ("LK8_26","072_8_26","LUK","8","26","26","La ne Iesu mi lavaun pinivu ren diga rupot to loxon ap mo lavatdan kis to at lenep Gerasa, na lemenemen ga nemen saparap lavatdan kis Galili. ");
INSERT INTO mmx_vpl VALUES ("LK8_27","072_8_27","LUK","8","27","27","La ne Iesu ga vas su uloxon la ni ga ekip tangarang mi lara laradi me go ap mo lemenemen, lubunggas ga nemen teren. Buaang levenmaares neni gak lok beleben mene, la ni goxo nemen to xolonu. Ketla neni ga nemen amisik to at levenbuang digak mikmit labarongan e. ");
INSERT INTO mmx_vpl VALUES ("LK8_28","072_8_28","LUK","8","28","28","Se neni ga ven ne Iesu, ni ga xup silok la ga xis tiktikbu mi luvatgulom teren to melamgo ren, la gap kup silok ti ne Iesu, “Iesu, Nitna Leeme Avolo, ne Moroa! Lavanga salai u vara i do una lox i ria? A sing u do nemen uta lox asongot aleng ia!” ");
INSERT INTO mmx_vpl VALUES ("LK8_29","072_8_29","LUK","8","29","29","Ni ga tong i na mila ne Iesu ga tong pam i ri lagas kusu na vas su basinge i. Buaang laxanaleng na lagas ga sep kapmex i la ap mo levenaleng neni ga nemen maxopok at loklok tatao at limixin, diga xoxo lukngen la luxangkedek teren mi lemparoos sen. Ketla neni ga baba koxorop nom lemparoos sen la lagas ga sasat ka i uto at lenep goxopmen tempanga ren. ");
INSERT INTO mmx_vpl VALUES ("LK8_30","072_8_30","LUK","8","30","30","Iesu ga sue i, “Nege laasen taram?” La ni ga lok, “Laasen tarak ne Buaang.” Mila buaang lubunggas diga beles pam teren. ");
INSERT INTO mmx_vpl VALUES ("LK8_31","072_8_31","LUK","8","31","31","La mo lubunggas diga ngising ne Iesu do nemen neni guta sak tiki di uto at lemeroon. ");
INSERT INTO mmx_vpl VALUES ("LK8_32","072_8_32","LUK","8","32","32","Buaang laxanbo mo diga nemen auret, diga anan to at lakaana. Lubunggas diga sing ne Iesu kusu na riki asu di uto at nom laxanbo. La ni ga ke aonon di. ");
INSERT INTO mmx_vpl VALUES ("LK8_33","072_8_33","LUK","8","33","33","La lubunggas diga sixisu basinge nom laradi la diga vubeles uto xeneng at nom lababo. La nedi axap nom laxanbo diga sixisi at lakaana la diga los tup ukopok at lavatdan kis la diga xong axap. ");
INSERT INTO mmx_vpl VALUES ("LK8_34","072_8_34","LUK","8","34","34","Luvuttadi digak lok tatao mo laxanbo diga ven i na, la diga sixit kaxat la diga tong aonon na levelinga ri mo limixin to at lemenemen atdi la ri limixin to at lentaba lengkot petpes bok. ");
INSERT INTO mmx_vpl VALUES ("LK8_35","072_8_35","LUK","8","35","35","La limixin digat pas kusu dina ven mo lavanga ga vot. Diga vot pasa ne Iesu la diga long lenget mo laradi, lubunggas ga vas su basinge vam i, mo gat kis saparap luxangkedek at ne Iesu, ga siga lempanga singsiga la lodoxoma ren ga xasep ta, la diga marat. ");
INSERT INTO mmx_vpl VALUES ("LK8_36","072_8_36","LUK","8","36","36","Nedi diga ven i na diga tong ri limixin do mo laradi ga lox avukat kereva. ");
INSERT INTO mmx_vpl VALUES ("LK8_37","072_8_37","LUK","8","37","37","La nom limixin ap mo lenep Gerasa diga sing ne Iesu kusu na onon ta, mila diga marat aleng. La ne Iesu ga los kas at lesepang la ga sen kaxat nga. ");
INSERT INTO mmx_vpl VALUES ("LK8_38","072_8_38","LUK","8","38","38","La mo laradi lubunggas ga vas su basinge i, ga sing ne Iesu, “A vara i do ana emu eburu minu.” Ketla ne Iesu ga riki aonon i, ga lok, ");
INSERT INTO mmx_vpl VALUES ("LK8_39","072_8_39","LUK","8","39","39","“Unamlong uto xolonu la una tong na lavanga ne Moroa i lok pam i ru.” La mo laradi gat pas maxeneng at nom lemenemen axap ga tong mo lavanga ne Iesu ga lok pam i rin. ");
INSERT INTO mmx_vpl VALUES ("LK8_40","072_8_40","LUK","8","40","40","Se ne Iesu gamlong uto at lavatdan kis at lenep menak, buaang limixin diga paase momo min, mila nedi axap diga ngangais i. ");
INSERT INTO mmx_vpl VALUES ("LK8_41","072_8_41","LUK","8","41","41","Ap mo mun loxonaleng lara laradi, laasen teren ne Jairas ga vot. Neni laradi gomgo at loogu singising me go. Ni ga xis tiktikbu mi luvatgulom teren saparap luxangkedek at ne Iesu la ga sing i xusu nat pas uto at loogu ren. ");
INSERT INTO mmx_vpl VALUES ("LK8_42","072_8_42","LUK","8","42","42","Mila legesolik mun teren ga lasangaun mi legepu maares teren mo ga auret kusu na met. Se ne Iesu gat pas uto at loogu at ne Jairas, buaang nedi limixin diga umsu saparav i at lengkot axap. ");
INSERT INTO mmx_vpl VALUES ("LK8_43","072_8_43","LUK","8","43","43","La lara latkin mo ga nemen. Lanmeres gaaling gak lox amisik teren at levenaleng axap, ga epovo at lasangaun mi legepu maares. La buaang laxampilas teren ga xap gamasa mun ti luvuttadi sangsanga, ketla kopmen teta goxo epovo kusu na lox avukar i. ");
INSERT INTO mmx_vpl VALUES ("LK8_44","072_8_44","LUK","8","44","44","Neni gat pas eburu mi limixin to melemu at ne Iesu la ga long tu at lungusungus at lavanga singsiga at ne Iesu la soso mun nom lanmeres ga xap ta. ");
INSERT INTO mmx_vpl VALUES ("LK8_45","072_8_45","LUK","8","45","45","La ne Iesu ga sue di xeretna, “Nege i long tu rak?” La nedi axap diga sev apkap la ne Pita ga lok, “Leeme Silok, buaang limixin mo dit pas saparav u la mo di mumu u.” ");
INSERT INTO mmx_vpl VALUES ("LK8_46","072_8_46","LUK","8","46","46","Ketla ne Iesu ga lok, “Lara mo i long tu rak, a suma i do lolos i sixisu basinge ia.” ");
INSERT INTO mmx_vpl VALUES ("LK8_47","072_8_47","LUK","8","47","47","La mo latkin ga ven i do diga long lenget ka i. Kuren la ni ga vot pasa ne Iesu, ga dede la ga xis tiktikbu mi luvatgulom teren saparav i. Mo go melamgo at limixin axap, neni ga tong asu ua lavasuun teren la ni ga long tu at ne Iesu la kereva neni ga lox avukat soso mun. ");
INSERT INTO mmx_vpl VALUES ("LK8_48","072_8_48","LUK","8","48","48","La ne Iesu ga lok tin, “Latkin, lununu ram i lox avukar u. Unat pas at lenmila.” ");
INSERT INTO mmx_vpl VALUES ("LK8_49","072_8_49","LUK","8","49","49","Iesu move ga paase na levelinga la lara laradi gat pas boro at loogu at laradi gomgo, ne Jairas. La ni ga lok ti ne Jairas, “Loolik taram ira met pam, la nemen uta lox angtang bok ba laradi loklox ase.” ");
INSERT INTO mmx_vpl VALUES ("LK8_50","072_8_50","LUK","8","50","50","Ketla ne Iesu ga ronga i la ga lok ti ne Jairas, “Nemen uta marat, una nunu mun la neni naba rooro.” ");
INSERT INTO mmx_vpl VALUES ("LK8_51","072_8_51","LUK","8","51","51","Se neni ga vot to at loogu, neni goxo siam abeles tara ukeneng at loogu xusu dita vubeles eburu min, ketla ne Pita, Jon la ne Jems la ne temen mi nenen nom loolik kusuk mun. ");
INSERT INTO mmx_vpl VALUES ("LK8_52","072_8_52","LUK","8","52","52","Limixin axap go digang teng la digak saxaanu ap mo loolik. La ne Iesu ga lok, “Nemen mitang teng. Loolik kopmen na met, neni mo i unga mun!” ");
INSERT INTO mmx_vpl VALUES ("LK8_53","072_8_53","LUK","8","53","53","Diga lok kalise i mila digaklen i do loolik mo gara met pam. ");
INSERT INTO mmx_vpl VALUES ("LK8_54","072_8_54","LUK","8","54","54","Ketla ne Iesu ga ranga axatu i mi lekngen la ga vaase lolos keretna, “Loolik, una xatu kaxat!” ");
INSERT INTO mmx_vpl VALUES ("LK8_55","072_8_55","LUK","8","55","55","Loroonan teren gamlong la ni ga xatu kaxat soso mun upana. La ne Iesu ga tong i ridi xusu dina raba i mi toxompanga anan. ");
INSERT INTO mmx_vpl VALUES ("LK8_56","072_8_56","LUK","8","56","56","Temen mi nenen duga sangu aleng, ketla ne Iesu ga vaase lolos di do nemen di guta tong i na lavanga ri teta. ");
INSERT INTO mmx_vpl VALUES ("LK9_1","072_9_1","LUK","9","1","1","At lara laaleng Iesu ga ro bubua ka lasangaun legepura lavaun pinivu saparav i la ga raba nedi mi lolos kusu ti lox asu lubunggas la dina lox aroo limixin mekmeres. ");
INSERT INTO mmx_vpl VALUES ("LK9_2","072_9_2","LUK","9","2","2","La neni ga lok do na riki asu di xusu dina vavang mi Linintoo at ne Moroa la dina lox aroo limixin mekmeres. ");
INSERT INTO mmx_vpl VALUES ("LK9_3","072_9_3","LUK","9","3","3","La neni ga lok tidi, “Nemen mita xip kaka tempanga eburu minimi ri mo lavatpas. Nemen takdak, la nemen mita lok kaka teventat, la nemen teveluxa, la nemen tevempilas, la nemen bok tevempanga singsiga etara xun. ");
INSERT INTO mmx_vpl VALUES ("LK9_4","072_9_4","LUK","9","4","4","Mo do mina beles at tara toogu la limixin dina siam ka nimi, mina nemen eburu midi se minaba vas kaxat basinge mo lemenemen. ");
INSERT INTO mmx_vpl VALUES ("LK9_5","072_9_5","LUK","9","5","5","Mo do limixin di noxo siam ka nimi, mina on basinge nom lemenemen la mina semla xepe laxakup basinge levengkangkedek atnimi, i ngan loklok katling tidi kusu ti lox asuusu lebelemamao at ne Moroa.” ");
INSERT INTO mmx_vpl VALUES ("LK9_6","072_9_6","LUK","9","6","6","La lavaun pinivu diga vas kaxat, la digat pas kantubu at lara menemen, diga vavang mi Lagale Lavavang, la diga lox aroo limixin at lengkot axap. ");
INSERT INTO mmx_vpl VALUES ("LK9_7","072_9_7","LUK","9","7","7","Erodes, laradi gomgo boro Galili, ga ronga mo lempanga ga vot. La ni ga rangku aleng, mila lentaba luvuttadi mo digak lok do, “Jon, laradi sep susu mo ga roo xat amlong bok!” ");
INSERT INTO mmx_vpl VALUES ("LK9_8","072_9_8","LUK","9","8","8","Lentaba diga lok do ne Elaisa mo ga vot, la lentaba diga lok do lara leeme vapaase ali megano mo ga roo xat amlong ti lorooro. ");
INSERT INTO mmx_vpl VALUES ("LK9_9","072_9_9","LUK","9","9","9","Erodes ga lok, “Agara ra korop pam laxaka at ne Jon. Ketla nege i na laradi, mo nia a ronga i do na lok na lempanga?” La ni gak lok tong pen i do na ven ti ne Iesu. ");
INSERT INTO mmx_vpl VALUES ("LK9_10","072_9_10","LUK","9","10","10","Luvuttadi vavang digamlong la diga tong i ri ne Iesu do leven gugu axap diga lox i. Neni ga sat kaka di eburu min la nedi xusuk mun diga vas kaxat uto at lara lemenemen, laasen teren Betsaida. ");
INSERT INTO mmx_vpl VALUES ("LK9_11","072_9_11","LUK","9","11","11","Se limixin diga ronga i na, diga mumu asu i. La neni ga siam ka di mi lomomo, la ga paase ridi mumu Linintoo at ne Moroa, la neni ga lox aroo nedi, diga meres. ");
INSERT INTO mmx_vpl VALUES ("LK9_12","072_9_12","LUK","9","12","12","Ga ukantinao lavaun pinivu diga vot pasa i la diga lok, “Una riki aonon limixin uto xusu dibat pas uto at levenmenemen la at lengkot petpes bok la dina puse ka tempanga anan la tengkot mikmidi bok tidi, mila na loxot i mimila rino.” ");
INSERT INTO mmx_vpl VALUES ("LK9_13","072_9_13","LUK","9","13","13","Ketla ne Iesu ga lok tidi, “Nemi xa mina raba nedi mi teveluxa kusu ti anan.” La diga vorang i xeretna, “Ma ruuna mun lavalimo lengkongkide la legepu venmat. Kereva, u vara i do manat pas la mana un kaka teveluxa rinedi na buaang limixin?” ");
INSERT INTO mmx_vpl VALUES ("LK9_14","072_9_14","LUK","9","14","14","Luvuttadi remes go diga epovo at lavalimo larabin sangsangaun kobot. (5000) Iesu ga lok ti lavaun pinivu ren, “Mina tong i ri limixin kusu dina xis kopok at lengkonbinam tadi i epovo at lavalimo sangaun.” ");
INSERT INTO mmx_vpl VALUES ("LK9_15","072_9_15","LUK","9","15","15","Lavaun pinivu diga lox i xuren, la diga tong i ridi do dina xis kopok. ");
INSERT INTO mmx_vpl VALUES ("LK9_16","072_9_16","LUK","9","16","16","Iesu ga lok kaka mo lavalimo lengkongkide la legepu venmat, la ga milik aurut uto vana at laxalibet, la ga tong avukat ti ne Moroa la ga sebex i, la ga raba lavaun pinivu min kusu dina epes i xantubu at limixin. ");
INSERT INTO mmx_vpl VALUES ("LK9_17","072_9_17","LUK","9","17","17","La nedi axap diga anan la diga an mais. La lavaun pinivu diga luxa lasangaun legepura leventat mi leveluxa mo diga an ake ren. ");
INSERT INTO mmx_vpl VALUES ("LK9_18","072_9_18","LUK","9","18","18","At lara laaleng ne Iesu xusuk mun gat pas kusu nang sing, la lavaun pinivu diga vot pasa i. La neni ga sue di, “Limixin di lok do nenia nege?” ");
INSERT INTO mmx_vpl VALUES ("LK9_19","072_9_19","LUK","9","19","19","Diga vorang i rin keretna, “Lentaba di lok do nenu ne Jon laradi sep susu. Lentaba di tong i do nenu ne Elaisa. La lentaba di tong i do nenu lara leeme vapaase ali megano mo i roo xat amlong.” ");
INSERT INTO mmx_vpl VALUES ("LK9_20","072_9_20","LUK","9","20","20","La ne Iesu ga sue di, “Kereva ba nimi? Nemi mi lok do nenia nege?” Pita ga lok, “Nenu Lanarong at ne Moroa.” ");
INSERT INTO mmx_vpl VALUES ("LK9_21","072_9_21","LUK","9","21","21","La ne Iesu ga vaase pe lolos di, do nemen di guta tong i ri tara do neni Lanarong. ");
INSERT INTO mmx_vpl VALUES ("LK9_22","072_9_22","LUK","9","22","22","La ne Iesu ga lok tidi, “Nenia Laradi Mevana, anaba xip losongsongot solo, la loxongkulao silok at limixin me Judaia, la lavamaasa silok la luvuttadi loklox ase at Laulis Linga dinaba sok tixirixes kepe ia. Dinaba sev amer ia, la nenia anaba roo xat amlong at laaleng sepsev avantun.” ");
INSERT INTO mmx_vpl VALUES ("LK9_23","072_9_23","LUK","9","23","23","La neni ga lok ti mo limixin axap, “Mo do tara i vara i do na emu minia, neni na domampe lorooro axap teren, la na gagas li i xusu nap kip losongsongot at levenaleng axap, la na mumu asu ba ia. ");
INSERT INTO mmx_vpl VALUES ("LK9_24","072_9_24","LUK","9","24","24","Do nege i vara i do na ranga alis lorooro ren, neni naba sang apkav i. Ket do nege i soxope lorooro ren ti lok luvukat tarak, neni naba lok kaka lorooro avolo. ");
INSERT INTO mmx_vpl VALUES ("LK9_25","072_9_25","LUK","9","25","25","I lok kapmek do taradi na ruuna ka lempanga axap at na lavatbung menemen, la neni i subu basinge lorooro at ne Moroa. ");
INSERT INTO mmx_vpl VALUES ("LK9_26","072_9_26","LUK","9","26","26","Mo do taradi na lok mamangan kepe ia eburu mi levelinga rak, nenia, Laradi Mevana, anaba sok tixirixes xepe i ap mo laaleng nenia ana si ukopok mi lisisixam silok tarak la lisisixam silok at ne Tamak la lubung angelo melemelengan teren. ");
INSERT INTO mmx_vpl VALUES ("LK9_27","072_9_27","LUK","9","27","27","Mina doxoma i na! I ruturun tinotno, a tong i rinimi do lentaba atnimi na, di noxo met se at nom laaleng dinaba ven livipisik at levelinga mumu Linintoo at ne Moroa.” ");
INSERT INTO mmx_vpl VALUES ("LK9_28","072_9_28","LUK","9","28","28","Iesu ga vaase axap na levelinga, la melemu at lavanuan levenaleng gara volo, Iesu ga lam kaka ne Pita, ne Jon, la ne Jems eburu min. La diga urut uto vana at lakaana kusu dina ngising. ");
INSERT INTO mmx_vpl VALUES ("LK9_29","072_9_29","LUK","9","29","29","Ga se neni ga lok lising, lemeren axap teren ga milik gamgames, la lavanga singsiga bok teren gam games aleng! ");
INSERT INTO mmx_vpl VALUES ("LK9_30","072_9_30","LUK","9","30","30","La ne Moses mi ne Elaisa duga rupot boro vana at laxalibet eburu mi lisisixam silok ga vung pavaa du. ");
INSERT INTO mmx_vpl VALUES ("LK9_31","072_9_31","LUK","9","31","31","La duga vot pasa ne Iesu la duga epaase eburu min do neni naba lox asoorun lavapaase ali at ne Moroa do neni naba met to Jerusalem. ");
INSERT INTO mmx_vpl VALUES ("LK9_32","072_9_32","LUK","9","32","32","La ne Pita eburu mi larapen tangas teren diga unga met. Ketla diga aus kaxat la diga ven lisisixam silok at ne Iesu la luradi mo duga tu eburu min. ");
INSERT INTO mmx_vpl VALUES ("LK9_33","072_9_33","LUK","9","33","33","Se luradi duga lok do duna on basinge ne Iesu, Pita ga lok ti ne Iesu, “Leeme Silok, i lox avukat tinotno at loklok atnama nade. Mana lok tavantun taraogu xukuxut, tara ru, tara ri ne Moses, la tara ri ne Elaisa.” Ni goxoklen tinotno i do laai mo ni ga paase min. ");
INSERT INTO mmx_vpl VALUES ("LK9_34","072_9_34","LUK","9","34","34","Pita move ga paase, la lusugao ga ravasi la ga vung pavaa di. La lavaun pinivu diga marat aleng. ");