﻿USE sofia;
DROP TABLE IF EXISTS sofia.mmo_vpl;
CREATE TABLE mmo_vpl (
  verseID VARCHAR(16) NOT NULL PRIMARY KEY,
  canon_order VARCHAR(12) NOT NULL,
  book VARCHAR(3) NOT NULL,
  chapter VARCHAR(3) NOT NULL,
  startVerse VARCHAR(3) NOT NULL,
  endVerse VARCHAR(3) NOT NULL,
  verseText TEXT CHARACTER SET UTF8 NOT NULL) ENGINE=MyISAM;
LOCK TABLES mmo_vpl WRITE;
INSERT INTO mmo_vpl VALUES ("MT1_1","070_1_1","MAT","1","1","1"," + o 1:1 1Kro 17:11; Jen 22:18*Hil sen Yesu Kalisi pumak sil-ato ond haalend-anjo. Yesuu-ju ond Devit-ate hil vu taamusin ti, de Devit ond Abalaam-ate hil vu taamusin ti. ");
INSERT INTO mmo_vpl VALUES ("MT1_2","070_1_2","MAT","1","2","2","Abalaam hako noow Isak, tonde Isak hako Yaakop, tonde Yaakop hako Yuda-so halindin, ");
INSERT INTO mmo_vpl VALUES ("MT1_3","070_1_3","MAT","1","3","3","+ o 1:3 Jen 38:29-30; Rut 4:18-22*tonde Yuda hako Peles ayuuh Sila, yuuhate tangganaan Tema, tonde Peles hako noow Heslon, tonde Heslon hako noow Lam, ");
INSERT INTO mmo_vpl VALUES ("MT1_4","070_1_4","MAT","1","4","4","de Lam hako noow Aminadap, tonde Aminadap hako noow Naason, tonde Naason hako Salmon, ");
INSERT INTO mmo_vpl VALUES ("MT1_5","070_1_5","MAT","1","5","5","+ o 1:5 Rut 4:13-17*de Salmon hako Boas sen tangganaan Lehap-ato, tonde Boas hako Obet sen tangganaan Lut-ato, tonde Obet hako noow Jesi, ");
INSERT INTO mmo_vpl VALUES ("MT1_6","070_1_6","MAT","1","6","6","+ o 1:6 2Sml 12:24*tonde Jesi hako noow Devit sen tu omaaho lulemak-ato. Tonde Devit hako noow Solomon, tonde Solomon tangganaan-anju ond Ulia vane bôôy. ");
INSERT INTO mmo_vpl VALUES ("MT1_7","070_1_7","MAT","1","7","7","+ o 1:7-10 1Kro 3:10-16*Tonde Solomon hako noow Liaboam, Liaboam hako Abaisa, Abaisa hako Esa, ");
INSERT INTO mmo_vpl VALUES ("MT1_8","070_1_8","MAT","1","8","8","tonde Esa hako noow Yosapat, de Yosapat hako Jolam, Jolam hako Usia, ");
INSERT INTO mmo_vpl VALUES ("MT1_9","070_1_9","MAT","1","9","9","Usia hako Jotam, Jotam hako Ehas, Ehas hako Hesekia, ");
INSERT INTO mmo_vpl VALUES ("MT1_10","070_1_10","MAT","1","10","10","tonde Hesekia hako Manase, de Manase hako Amos, Amos hako Yosia, ");
INSERT INTO mmo_vpl VALUES ("MT1_11","070_1_11","MAT","1","11","11","+ o 1:11 2King 24:12-16; 2Kro 36:10; Jer 27:20*tonde Yosia hako Jekonaia-so halindin, tonde hôôk busin-anju hil Babilon landuuh hil Islel-ambe lako sil-ambe lala dando Babilon. ");
INSERT INTO mmo_vpl VALUES ("MT1_12","070_1_12","MAT","1","12","12","+ o 1:12 Esra 3:2*Lala dando taaku Babilon lung la, tonde Jekonaia hako Sialtiel, de Sialtiel hako Selababel, ");
INSERT INTO mmo_vpl VALUES ("MT1_13","070_1_13","MAT","1","13","13","Selababel hako Abaiat, Abaiat hako Elaiakim, Elaiakim hako Eso, ");
INSERT INTO mmo_vpl VALUES ("MT1_14","070_1_14","MAT","1","14","14","tonde Eso hako Sedok, de Sedok hako Ekim, Ekim hako Elaiat, ");
INSERT INTO mmo_vpl VALUES ("MT1_15","070_1_15","MAT","1","15","15","tonde Elaiat hako Eleasa, de Eleasa hako Matan, tonde Matan hako Yaakop, ");
INSERT INTO mmo_vpl VALUES ("MT1_16","070_1_16","MAT","1","16","16","tonde Yaakop hako Yusep sen Malia layaa-to, ond Maliaa-ju sen hako noow Yesu sen danêêl nambe Kalisii-to. ");
INSERT INTO mmo_vpl VALUES ("MT1_17","070_1_17","MAT","1","17","17","Omaahonôôn pin-anju sen lapumak Abalaam-ambe laam lôôt-ambe tok laam Devit-anju, ond silate danggakook nomaayuuh-ambe laam yumbeyuuh. Tonde vu Devit-ambe tok laam busin sen lala dando taaku Babilon-ato, ond yik silate danggakook nomaayuuh-ambe laam yumbeyuuh. Tonde vu busin sen lala dando Babilon-ato be tok laam Kalisi-te busin, ond yik danggakook nomaayuuh-ambe laam yumbeyuuh nambêênju having. ");
INSERT INTO mmo_vpl VALUES ("MT1_18","070_1_18","MAT","1","18","18","+ o 1:18 Luk 1:27,35*Yesu Kalisi tangganaan hako yii-to yite danggakook-anjo. Laholin tangganaan Malia vu Yusep, le yuuh-ame dando lavuh ti le, naahen, tonde layi de Malia noow hôôk lak Vavi Vaambuung. ");
INSERT INTO mmo_vpl VALUES ("MT1_19","070_1_19","MAT","1","19","19","De laya Yusep ond omaaho nivalok, ondeey me-wiingin nambe naanêêl vakasin langaah-ambe Malia ninaamum e, nganjo yoo wiingin nambe gavuuh Malia kaatokin amu. ");
INSERT INTO mmo_vpl VALUES ("MT1_20","070_1_20","MAT","1","20","20","Yusep ka monavu vakasin-anju tombe yi mavin-ande Omaaho Bop-ate angela ti laam nêêl vu nambe, “Yusep, hong sen gate danggakook neep vu Devit-ato, game ganjêênin e. Onggako gate vêêh Malia be naas mando gaving hong, in unoopasiv sen lukaale lopayôô-ju ond Vavi Vaambuung vu vu yi. ");
INSERT INTO mmo_vpl VALUES ("MT1_21","070_1_21","MAT","1","21","21","+ o 1:21 Luk 1:31; 2:21; Sin 4:12*Tombe le gako noow moow ti, tombe gale naateey haale naambe Yesu, in dangga nambe le nôôh yite hil vêêl in silate va nipaya.” ");
INSERT INTO mmo_vpl VALUES ("MT1_22","070_1_22","MAT","1","22","22","Va pin-anju wiing-ambe Omaaho Bop-ate vakasin sen yite omaaho ti nêêl langaah-ato nôôn ak nambe, ");
INSERT INTO mmo_vpl VALUES ("MT1_23","070_1_23","MAT","1","23","23","+ o 1:23 Ais 7:14*“Angge, vehaavu ti le noow dôôk-ambe gako noow moow ti, tombe le daateey haale naambe Emaanuel.” Yaanggilin haale naambe Anutu nando having yiiy. ");
INSERT INTO mmo_vpl VALUES ("MT1_24","070_1_24","MAT","1","24","24","Yusep neep lung la de kandi, tombe wii-having nambe sen Omaaho Bop-ate angela nêêl vuu-to, om hako vane be yuuh dando, ");
INSERT INTO mmo_vpl VALUES ("MT1_25","070_1_25","MAT","1","25","25","+ o 1:25 Luk 2:21*lemu Yusep oo lakin yi nivasa lôôt-ambe vêêh hako noow e mem teey haale nambe Yesu. ");
INSERT INTO mmo_vpl VALUES ("MT2_1","070_2_1","MAT","2","1","1","Malia hako Yesu neep Betlehem Yudia hôôk busin sen omaaho lulemak Helot nandôô-to, tombe hil akand bop heey vu taaku me lak valup-ato be lalaam Yelusalem, tombe lalingin nambe, ");
INSERT INTO mmo_vpl VALUES ("MT2_2","070_2_2","MAT","2","2","2","+ o 2:2 Nam 24:17*“Unoopasiv moos sen tok laam-ambe navu naatu Yuda-te omaaho lulemak-ato nando tana? Hey aahe yite matam lak valup naale taaku sen taaku me nalak nalup-ato, ondeey hey alaam in nambe gako haale jak.” ");
INSERT INTO mmo_vpl VALUES ("MT2_3","070_2_3","MAT","2","3","3","Omaaho lulemak Helot hango vakasin-anju tombe vindis-ambe ka yu-yuuh lôôt, tombe yik hil Yelusalem pin nambêênju having. ");
INSERT INTO mmo_vpl VALUES ("MT2_4","070_2_4","MAT","2","4","4","Om Helot supin kul vaha sen datung salivangin-ato silate yêêv-aso osin tanasin danggakook-aso pin-ambe lingin sil nambe, “Anutu biing yite omaaho sen yoo holin yi vulôôt in nambe dôôvu yiiy-ato naam ond tangganaan e gako yi nanjip tana?” ");
INSERT INTO mmo_vpl VALUES ("MT2_5","070_2_5","MAT","2","5","5","Tombe lanêêl vu nambe, “Le gako nanjip Betlehem Yudia, in omaaho ti kaavu Anutu-te vakasin neep bôôy nambe, ");
INSERT INTO mmo_vpl VALUES ("MT2_6","070_2_6","MAT","2","6","6","+ o 2:6 Mai 5:2; Jon 7:42*‘Ham Betlehem vu taaku Yuda, ham-ame haalem pasiv-ande Yuda-te taaku vaalu kaluuh ham e, malis, ham oo kaluuh, in yêêv bop ti le balup vu ham tombe le ganggin sate hil Islel.’” ");
INSERT INTO mmo_vpl VALUES ("MT2_7","070_2_7","MAT","2","7","7","Helot hango lung la, tombe sim wiing vakasin la kaatokin vu hil akand bop-aso sen lalaam vu taaku me nalak nalup-ato be lalaam vu, be sim lingin sil nambe layi matam-anju nyendoos ond naangelis. ");
INSERT INTO mmo_vpl VALUES ("MT2_8","070_2_8","MAT","2","8","8","Tombe sil lanêêl vu, le mem wiing sil lala Betlehem, de nêêl vu sil nambe, “Ham ana anjingin unoopasiv-anju nivasa lôôt, be ham naatovu ond ham anom naanêêl banye vu sa in soo anaas gako haale jak gaving.” ");
INSERT INTO mmo_vpl VALUES ("MT2_9","070_2_9","MAT","2","9","9","Lango omaaho lulemak lava lung la tonde mem lala lak, de matam sen layi vu taaku me lak valup-ato ond munggin-ambe la naale nivalok vu taaku sen unoopasiv neep-ato. ");
INSERT INTO mmo_vpl VALUES ("MT2_10","070_2_10","MAT","2","10","10","Layi matam-ambe londpayo nivasa, de lapêêlis lôôt, ");
INSERT INTO mmo_vpl VALUES ("MT2_11","070_2_11","MAT","2","11","11","+ o 2:11 Saam 72:10-15; Ais 60:6*om lalukala bayêên alo be layi unoopasiv ayuuh tangganaan Malia, tombe lato pataav baambund neep voon-ambe lako yi lak, tonde lahôôl kupak hôôk silate vaahes ti ti, gool osin haah anikanggi galovasa yuuh, be lavu vu yi. ");
INSERT INTO mmo_vpl VALUES ("MT2_12","070_2_12","MAT","2","12","12","Tonde hôôk busin atombe layi mavin-ande Anutu vu kôôvu sil nambe me-lanaah balup vu Helot e, om laloh mopaatôôv ango be lalaah sil ambaand. ");
INSERT INTO mmo_vpl VALUES ("MT2_13","070_2_13","MAT","2","13","13","Lalaah lung la tonde Yusep yi mavin-ande Omaaho Bop-ate angela hato nêêl vu nambe, “Okandi gako unoopasiv ayuuh tangganaan-ambe maal napak-ambe maal ana Ijip, tombe maal ana mandôô-ju vêêl e, de soo naanêêl vu hong e mem, in Helot navu salo unoopasiv in nambe nyiis-ambe jimb.” ");
INSERT INTO mmo_vpl VALUES ("MT2_14","070_2_14","MAT","2","14","14","Om Yusep kandi hako unoopasiv ayuuh tangganaan hôôk busin-ambe yaal lala Ijip. ");
INSERT INTO mmo_vpl VALUES ("MT2_15","070_2_15","MAT","2","15","15","+ o 2:15 Hos 11:1*Yaal lala dandôô-ju de Helot yimb e mem. Ke, om Omaaho Bop-ate vakasin sen omaaho ti nêêl langaah bôôy-ato nôôn ak nambe, “Saateey noongg vu Ijip-ambe lom.” ");
INSERT INTO mmo_vpl VALUES ("MT2_16","070_2_16","MAT","2","16","16","Ke, Helot yi nambe hil akand bop-anju me-lalom lalu-vu yi le, om lak ni nambe sil tatuhin yi, om ahekalin bopaata lôôt-ambe wiing hil lala Betlehem osin taaku pin sen neep ngaahôô-to, be layiis unoopasiv-ambe layimb. Ond layiis unoopasiv moow sen me-savok ta yuuh-ato pin, in Helot aka vu busin sen hil akand bop-aso lanêêl nambe layi matam hôôk nyendoos-ato. ");
INSERT INTO mmo_vpl VALUES ("MT2_17","070_2_17","MAT","2","17","17","Om Anutu-te vakasin sen Yelemia nêêl langaah bôôy-ato nôôn ak nambe, ");
INSERT INTO mmo_vpl VALUES ("MT2_18","070_2_18","MAT","2","18","18","+ o 2:18 Jer 31:15; Jen 35:19*“Lango daandun bopaata ti vu taaku Lama. Dasu bopaata lôôt-ambe dateey osin kand pasiv, in Lakel nasu in noondin, tombe nimbaya nambe hil-ame bakaas vu be lopayo nivasa jak e, in noondin lala mend ma lôôt.” ");
INSERT INTO mmo_vpl VALUES ("MT2_19","070_2_19","MAT","2","19","19","Helot yimb lung la, le mem Yusep yi mavin vu Ijip-ande Omaaho Bop-ate angela hato vu ");
INSERT INTO mmo_vpl VALUES ("MT2_20","070_2_20","MAT","2","20","20","+ o 2:20 Eks 4:19*be nêêl nambe, “Okandi jak-ambe onggako unoopasiv ayuuh tangganaan-ambe maal anaah Islel-ate taaku, in hil sen dawiingin nambe lanyiis unoopasiv-ato layimb lung la.” ");
INSERT INTO mmo_vpl VALUES ("MT2_21","070_2_21","MAT","2","21","21","Tombe Yusep kandi hako unoopasiv ayuuh tangganaan-ambe yaal lalaah Islel-ate taaku, ");
INSERT INTO mmo_vpl VALUES ("MT2_22","070_2_22","MAT","2","22","22","lemu hango nambe Akeleas tu omaaho lulemak vu Yudia lukalaah mangganaan Helot ahembaan yesin, om yêênin nambe me-naah-anju le, tombe yi mavin ango yesin-ande Anutu taato mop vu, om yaal lala taaku Galili. ");
INSERT INTO mmo_vpl VALUES ("MT2_23","070_2_23","MAT","2","23","23","+ o 2:23 Luk 2:39; Ais 11:1; 53:2; Jon 1:45-46*Tombe yaal lala lalup taaku ti haale nambe Nasaalet-ambe yaal dandôô-ju, om Anutu-te vakasin sen hil lanêêl langaah bôôy-ato nôôn ak nambe, “Le daanêêl yi naambe hil Nasaalet ti.” ");
INSERT INTO mmo_vpl VALUES ("MT3_1","070_3_1","MAT","3","1","1","Tombe busin ti Jon sen nalipis hil-ato nando taaku lumbalaamb Yudia, ");
INSERT INTO mmo_vpl VALUES ("MT3_2","070_3_2","MAT","3","2","2","+ o 3:2 Mat 4:17; Mak 1:15*tombe nanêêl tanasin nambe, “Ham anggilin ham alompayo in busin sen Anutu navu ganggin yite hil-ato laam ngaaho lak lung la.” ");
INSERT INTO mmo_vpl VALUES ("MT3_3","070_3_3","MAT","3","3","3","+ o 3:3 Ais 40:3*Jon-anju ond yik Yesaia nêêl Anutu-te vakasin ti lak yi bôôy nambe, “Omaaho ti nateey vu taaku lumbalaamb nambe, ‘Ham samu Omaaho Bop-ate mop, ham galo yite mop nanjip nivalok.’” ");
INSERT INTO mmo_vpl VALUES ("MT3_4","070_3_4","MAT","3","4","4","+ o 3:4 2King 1:8*Jon-anju lop lolop sen davu samu lak bik kamel anivalus-ato, tonde havêêh let bik naavi, tonde naya sapeek osin bayiiluk natu yite vanôôn. ");
INSERT INTO mmo_vpl VALUES ("MT3_5","070_3_5","MAT","3","5","5","Nandôô-ju de hil Yelusalem osin Yudia pin-ambe hil sen dando ngaaho vu bel bop Yoladan-ato pin lala vu yi. ");
INSERT INTO mmo_vpl VALUES ("MT3_6","070_3_6","MAT","3","6","6","Lanêêl silate va nipaya langaah, tombe lipis sil hôôk bel bop Yoladan. ");
INSERT INTO mmo_vpl VALUES ("MT3_7","070_3_7","MAT","3","7","7","+ o 3:7 Mat 12:34; Mat 23:33; Lom 2:5; Taato 6:16-17*Le Jon yi de hil Palisai osin hil Sadusi ngeeyaata lalaam vu yi in nambe jipis sil gaving, tombe nêêl vu sil nambe, “Nyêêy anipaya noondin ham. Lati nêêl vu ham? Ham-ame alohvu nambe ham napak in Anutu-te ahekalin sen le naatok naam vu taamusin-ato le. ");
INSERT INTO mmo_vpl VALUES ("MT3_8","070_3_8","MAT","3","8","8","Om ham anggilin ham alompayo be ham ambiing va nivasa in yanjak ni naambe ham ahilin ham vasa ond mem. ");
INSERT INTO mmo_vpl VALUES ("MT3_9","070_3_9","MAT","3","9","9","+ o 3:9 Jon 8:33,39; Lom 2:28-29; 4:12*Hamambe hamate danggakook neep vu Abalaam om Anutu le ji ham nivasa? Malis. Sa naanêêl vu ham naambe Anutu lohvu nambe jêêvu tatuuh-anjo be daatu Abalaam-ate hil. ");
INSERT INTO mmo_vpl VALUES ("MT3_10","070_3_10","MAT","3","10","10","+ o 3:10 Mat 7:19; Luk 13:6-9; Jon 15:6*Kôôv navu neep nandeng haah dangga lung la, om haah pin sen me-nayiis nôôn anivasaa-to ond le buv-ambe gaate jakana kin. ");
INSERT INTO mmo_vpl VALUES ("MT3_11","070_3_11","MAT","3","11","11","+ o 3:11 Jon 1:26-27,33; Sin 1:5; Sin 13:24-25*“Sa naalipis ham ak bel amu in naanêêl taato naambe ham ahilin ham alompayo, nganjo omaaho sen navu taamuyin sa ond yite niwêêk savok sa. Sak sa omaaho nipaya, same sa ningg vasa in nambe sa kavaayin yite suul osin saambiing kul vaalu naambe hil kul-aso dawiing vu silate yêêv e. Omaahôô-ju ond le biing-ambe ham anim vasa jak Vavi Vaambuung-ate niwêêk, osin kin sen ja hamate nipayaa-to. ");
INSERT INTO mmo_vpl VALUES ("MT3_12","070_3_12","MAT","3","12","12","+ o 3:12 Mat 13:30*Puvu yite haah navu salak hôôk nama lung la in nambe japêêh kaalekaale na, le mem naasupin vanôôn nôôn dukana bayêên vanôôn-ate, tonde vanôôn naavi osin ahesa ond le basi jakana kin ti yoo monatum danggata.” ");
INSERT INTO mmo_vpl VALUES ("MT3_13","070_3_13","MAT","3","13","13","Tonde busin ti Yesu vu Galili be la vu Jon vu bel bop Yoladan in nambe Jon jipis yi, ");
INSERT INTO mmo_vpl VALUES ("MT3_14","070_3_14","MAT","3","14","14","le Jon vu teenin yi de nêêl nambe, “Ganjipis sa ond mem nivasa, ma nambe vaati sen galaam vu saa-jo?” ");
INSERT INTO mmo_vpl VALUES ("MT3_15","070_3_15","MAT","3","15","15","Le Yesu nêêl laah vu nambe, “Lung, hoow samu Anutu-te vakasin pin ond mem nivasa, om yik ganjipis sa.” Tombe mem liinggis in Yesu lava. ");
INSERT INTO mmo_vpl VALUES ("MT3_16","070_3_16","MAT","3","16","16","+ o 3:16 Jon 1:32*Yesu lipis lung la de vu bel alu be lakalom, tonde pavis atombe baandoni kahe, de yi Anutu-te Vavi Vaambuung hato nambe manak tumbaliiy-ambe lakando yi. ");
INSERT INTO mmo_vpl VALUES ("MT3_17","070_3_17","MAT","3","17","17","+ o 3:17 Saam 2:7; Ais 42:1; Mat 12:18; 17:5; Luk 9:35*Tonde lava ti vu baandoni ond nêêl nambe, “Manyinja sa noongg-anja be sahengg having yi lôôt osin sahengg anivasa vu yi.” ");
INSERT INTO mmo_vpl VALUES ("MT4_1","070_4_1","MAT","4","1","1","+ o 4:1 Hiblu 2:18; 4:15*Lung atonde Vavi Vaambuung giiy Yesu la taaku lumbalaamb in nambe Saalang sahi yi. ");
INSERT INTO mmo_vpl VALUES ("MT4_2","070_4_2","MAT","4","2","2","+ o 4:2 Eks 34:28*Tombe Yesu me-ya vanôôn daka le, de yoo nando meep lohvu busin doo-yuuh-ande langaah doo-yuuh, tombe yimb ahe lôôt, ");
INSERT INTO mmo_vpl VALUES ("MT4_3","070_4_3","MAT","4","3","3","+ o 4:3 Jen 3:1-7*tombe sim palapin vaha la nêêl vu nambe, “Naambe Anutu Noow hong ond onaanêêl-ambe tatuuh-anjo naatu vanôôn.” ");
INSERT INTO mmo_vpl VALUES ("MT4_4","070_4_4","MAT","4","4","4","+ o 4:4 Diu 8:3*Le Yesu nêêl laah vu nambe, “Malis, in Anutu-te vakasin neep hôôk kaapiya nambe, ‘Vanôôn timu me-napuvu omaahonôôn e, nganjo vakasin pin sen Anutu nanêêl-ato ond mem napuvu omaahonôôn.’” ");
INSERT INTO mmo_vpl VALUES ("MT4_5","070_4_5","MAT","4","5","5","Tombe sim Saalang hako be yuuh lala lalup taaku vaambuung bop Yelusalem, tombe la valaah Yesu lakala naale lak Anutu-te dumb bop alu baandoni, ");
INSERT INTO mmo_vpl VALUES ("MT4_6","070_4_6","MAT","4","6","6","+ o 4:6 Saam 91:11-12*de nêêl vu nambe, “Naambe Anutu Noow hong ond opasong gana kambii-ju, in Anutu-te vakasin neep hôôk kaapiya nambe, ‘Yoo le naanêêl vu yite angela-so be lanôôh hong ak sil namand de game le kaatuuh ovaham jak tatuuh e.’” ");
INSERT INTO mmo_vpl VALUES ("MT4_7","070_4_7","MAT","4","7","7","+ o 4:7 Diu 6:16*Le ma de Yesu nêêl vu nambe, “Lemu Anutu-te vakasin ango neep hôôk kaapiya nambe, ‘Game sahi gate Omaaho Bop Anutu le.’” ");
INSERT INTO mmo_vpl VALUES ("MT4_8","070_4_8","MAT","4","8","8","Tombe yik Saalang hako yi be yuuh lalak kandu dinaandiin ti be lala daale, le mem Saalang motaato hil pin-ate taaku vu voon osin silate va nivasa vasa vu Yesu, ");
INSERT INTO mmo_vpl VALUES ("MT4_9","070_4_9","MAT","4","9","9","tonde nêêl vu nambe, “Naambe onggatung kaatu vu sa osin onggako sa haalengg jak ond mem sale aambu va haale haale pin-anju vu hong.” ");
INSERT INTO mmo_vpl VALUES ("MT4_10","070_4_10","MAT","4","10","10","+ o 4:10 Diu 6:13*Le ma de Yesu nêêl vu nambe, “Saalang, gana vêêl, in Anutu-te vakasin neep hôôk kaapiya nambe, ‘Goo gatung kaatu vu gate Omaaho Bop Anutu be ganohak vu yi timu.’” ");
INSERT INTO mmo_vpl VALUES ("MT4_11","070_4_11","MAT","4","11","11","+ o 4:11 Hiblu 1:6,14*Tombe Saalang havuuh yi de la, tonde mem angela-so lato lahôôvu Yesu. ");
INSERT INTO mmo_vpl VALUES ("MT4_12","070_4_12","MAT","4","12","12","+ o 4:12 Mat 14:3; Mak 6:17; Luk 3:19-20*Yesu hango nambe hil lalôôh Jon-ambe latung lukala kalaambus, tonde laah Galili, ");
INSERT INTO mmo_vpl VALUES ("MT4_13","070_4_13","MAT","4","13","13","+ o 4:13 Jon 2:12*tombe havuuh Nasaalet-ande la nando Kapenaum. Kapenaum-anju neep betum bop Galili nanyendangga vu taaku bop Sebulon ayuuh Naptaali, ");
INSERT INTO mmo_vpl VALUES ("MT4_14","070_4_14","MAT","4","14","14","om Anutu-te vakasin sen Yesaia nêêl langaah bôôy-ato nôôn ak nambe, ");
INSERT INTO mmo_vpl VALUES ("MT4_15","070_4_15","MAT","4","15","15","+ o 4:15 Ais 9:1-2*“Taaku Sebulon ayuuh taaku Naptaali, tonde taaku sen neep betum nanyendangga osin taaku sen neep Yoladan vaalu, de Galili-te taaku sen hil vaalu lalaam dando hôôk-ato, ");
INSERT INTO mmo_vpl VALUES ("MT4_16","070_4_16","MAT","4","16","16","ond hil sen dando hôôk mekanuu-to layi melangaah bopaata. Yik hil sen dando hôôk taaku mekanu in nambe lanjimb-ambe lana mend namaa-to ond melangaah tok laam vu sil.” ");
INSERT INTO mmo_vpl VALUES ("MT4_17","070_4_17","MAT","4","17","17","+ o 4:17 Mat 3:2*Hôôk busin-anju Yesu hako yite kul lak-ambe nêêl vakasin langaah nambe, “Ham anggilin ham alompayo in busin sen Anutu navu ganggin yite hil-ato laam ngaaho lak lung la.” ");
INSERT INTO mmo_vpl VALUES ("MT4_18","070_4_18","MAT","4","18","18","Yesu monaloh betum Galili nanyendangga, tombe yi maayuuh hali sen omaaho paahuung dangga yuuh-ato, Simon sen danêêl haale nambe Pitaa-to ond yuuh hali Endru mondaate govak lukala betum, ");
INSERT INTO mmo_vpl VALUES ("MT4_19","070_4_19","MAT","4","19","19","+ o 4:19 Mat 13:47*tombe nêêl vu yuuh nambe, “Manaam taamuyin sa, in saambiing-ambe muuh gako omaahonôôn naambe sen muuh nako paahuung-ato.” ");
INSERT INTO mmo_vpl VALUES ("MT4_20","070_4_20","MAT","4","20","20","+ o 4:20 Mat 19:27*Om yik pavis atombe yuuh lavuuh yuuhate govak-ande yuuh sapa yi be yaal lala. ");
INSERT INTO mmo_vpl VALUES ("MT4_21","070_4_21","MAT","4","21","21","Vuu-ju be la daka having, tombe yik yi omaaho ti yuuh hali, Sebedi noow ayuuh Jems ayuuh hali Jon, ond yuuh dando lak kaanu having mangganaan Sebedi be sil oo mosamu silate govak, tombe Yesu teey yuuh, ");
INSERT INTO mmo_vpl VALUES ("MT4_22","070_4_22","MAT","4","22","22","tombe yik pavis atombe yuuh lavuuh mangganaan osin kaanu de yuuh taamuyin Yesu yaal-ambe sil lala. ");
INSERT INTO mmo_vpl VALUES ("MT4_23","070_4_23","MAT","4","23","23","+ o 4:23 Mak 1:39; Mat 9:35; Sin 10:38*Yesu la hatup hôôk taaku Galili pin-ambe monawiing tanasin hôôk silate dumb alo ti ti, tombe nanêêl banye nivasa sen Anutu nanggin yite hil-ato langaah, de wiing hil anind lakin vaha vaha pin anind vasa lak. ");
INSERT INTO mmo_vpl VALUES ("MT4_24","070_4_24","MAT","4","24","24","+ o 4:24 Mak 6:55*Tombe yite banye la lohvu taaku Silia pin, om hil anipaya pin, sil vaalu silate nilakin vaha vaha, de vaalu sen dango nivaane bopaata, tonde hil vaalu sen mamu dahôôvu sil-ato, osin hil vaalu sen baando nasi sil, de hil vaalu vahand ayuuh namand anipaya, ond lako hil-anjo pin lala vu Yesu be wiing sil anind vasa lak. ");
INSERT INTO mmo_vpl VALUES ("MT4_25","070_4_25","MAT","4","25","25","+ o 4:25 Mak 3:7-8*Tombe hil vu Galili osin taaku nomaayuuh danêêl nambe Dekapolis-ato, be vu Yelusalem osin Yudia de Yoladan vaalu alo, ond sil ngeeyaata davu taamuyin Yesu. ");
INSERT INTO mmo_vpl VALUES ("MT5_1","070_5_1","MAT","5","1","1","Yesu yi de hil ngeeyaata taamuyin yi om lakala taaku kandu lu ti be la nando de yite maanggêêm-aso lala vu yi, ");
INSERT INTO mmo_vpl VALUES ("MT5_2","070_5_2","MAT","5","2","2","tombe Yesu wiing tanasin vu sil. ");
INSERT INTO mmo_vpl VALUES ("MT5_3","070_5_3","MAT","5","3","3","+ o 5:3 Ais 57:15*Nêêl nambe, “Hil sen dalak ni nambe sil-ame hil anind vasa le, ond sil akand vasa in sil lalohvu nambe daatu Anutu-te hil. ");
INSERT INTO mmo_vpl VALUES ("MT5_4","070_5_4","MAT","5","4","4","+ o 5:4 Ais 61:2-3; Taato 7:17*“Hil sen londpayo nimeen-ato, ond kand vasa in Anutu le biing-ambe londpayo nivasa jak. ");
INSERT INTO mmo_vpl VALUES ("MT5_5","070_5_5","MAT","5","5","5","+ o 5:5 Saam 37:11*“Hil sen yoo daanggôôl sil haalend ond sil akand vasa in sil e daatu ngaanggis dangga. ");
INSERT INTO mmo_vpl VALUES ("MT5_6","070_5_6","MAT","5","6","6","+ o 5:6 Ais 55:1-2*“Hil sen dawiingin lôôt nambe yoo lambiing va nivasa mu naambe sen hil dayimb ahend in vanôôn-ato, ond sil akand vasa in Anutu le biing-ambe sil daatu sil anind vasa jak. ");
INSERT INTO mmo_vpl VALUES ("MT5_7","070_5_7","MAT","5","7","7","+ o 5:7 Jem 2:13*“Hil sen kand pasiv in hil vaaluu-to, ond sil akand vasa in Anutu le ka pasiv in sil dukanaah. ");
INSERT INTO mmo_vpl VALUES ("MT5_8","070_5_8","MAT","5","8","8","+ o 5:8 Saam 24:3-4; 51:10; 73:11; Jon 3:2-3*“Hil sen londpayo la vu Anutu timuu-to, ond kand vasa in le lanji Anutu. ");
INSERT INTO mmo_vpl VALUES ("MT5_9","070_5_9","MAT","5","9","9","+ o 5:9 Hiblu 12:14; Jem 3:18*“Hil sen davu mamaal vu omaahonôôn in nambe ngaamong jip-ato ond sil akand vasa in Anutu le naanêêl naambe yite noondin sil. ");
INSERT INTO mmo_vpl VALUES ("MT5_10","070_5_10","MAT","5","10","10","+ o 5:10 1Pi 3:14*“Hil sen daaku nimeen in davu sapa Anutu-te tanasin-ato, ond kand vasa in sil latu Anutu-te hil. ");
INSERT INTO mmo_vpl VALUES ("MT5_11","070_5_11","MAT","5","11","11","+ o 5:11 1Pi 4:14; Jem 1:2*“Tonde hil lanji naambe ham navu taamuyin sa, tombe daanêêl vakasin navu dees jak ham, de lambiing nindanjeen vu ham osin sil tatuhin vakasin anipaya vaha vaha jak ham, ond ham akam vasa, ");
INSERT INTO mmo_vpl VALUES ("MT5_12","070_5_12","MAT","5","12","12","+ o 5:12 2Kro 36:16; Sin 7:52; Hiblu 11:32-38; Jem 5:10*de ham alompayo nivasa be ham naapêêlis, in ham e gako nyevahaan nivasa bopaata vu baandoni. Hil oo dawiing nindanjeen vu hil sen danêêl Anutu-te vakasin langaah-ato nambêênja bôôy.” ");
INSERT INTO mmo_vpl VALUES ("MT5_13","070_5_13","MAT","5","13","13","“Ham alohvu gaas in nambe ham andôôvu hil voon, lemu naambe gaas anikuuh ak ond yale aambiing vaati vu be naatu nanyêên jesin naah? Malis. Nipaya lak lung-ato, om yiiy gaate na be hil baake tatêêl. ");
INSERT INTO mmo_vpl VALUES ("MT5_14","070_5_14","MAT","5","14","14","+ o 5:14 Jon 8:12; 9:5; Pil 2:15*De ham alohvu hil voon-ate kin tumin, in bayêên bop ti nambe nanjip ak kandu lu, ond me-lohvu nambe nanjip vunin e. ");
INSERT INTO mmo_vpl VALUES ("MT5_15","070_5_15","MAT","5","15","15","+ o 5:15 Mak 4:21; Luk 8:16; 11:33*Tonde hil davu taalungg hôôk lam, ond me-datung hôôk dêêngg alo le, nganjo datung nando lak pêêt in nambe naatum ak hil pin sen dando bayêên alôô-to. ");
INSERT INTO mmo_vpl VALUES ("MT5_16","070_5_16","MAT","5","16","16","+ o 5:16 Ep 5:8-9; 1Pi 2:12*Om hamate kin tumin naatum ak hil pin naambêênja in nambe sil lanji va nivasa sen ham nawiing-anjaato be sil gako hamate Mom sen nando baandonii-to haale jak.” ");
INSERT INTO mmo_vpl VALUES ("MT5_17","070_5_17","MAT","5","17","17","+ o 5:17 Mat 3:15; Lom 3:31; 10:4*“Hamambe mak sa laam in nambe kawiiy Mose-te tanasin osin Anutu-te vakasin sen hil lanêêl langaah bôôy-ato na mava? Malis, same alaam in nambe kawiiy na le, nganjo sa laam in nambe saambiing-ambe nôôn jak. ");
INSERT INTO mmo_vpl VALUES ("MT5_18","070_5_18","MAT","5","18","18","+ o 5:18 Luk 16:17; 21:33*Sa naanêêl keen vu ham naambe Anutu me-le kawiiy vakasin sen neep hôôk melaalôô-juuto boow daka me nyengale daka be na menama le, nganjo yoo le nanjip naambêênjo lôôt-ambe na balup busin sen yendak osin ngaanggis na menamaa-to, de vakasin pin nôôn jak e mem. ");
INSERT INTO mmo_vpl VALUES ("MT5_19","070_5_19","MAT","5","19","19","+ o 5:19 Jem 2:10*Om omaaho ti nambe kalêêh tanasin-anju boow daka, be taahu hil hôôk yite kalêêsin-anju be lambiing gaving, ond omaahôô-ju haale le naatu nipasiv lôôt vu hil sen Anutu nanggin sil-ato. De omaaho ti nambe samu tanasin nivasa be taahu hil hôôk in nambe sil lambiing gaving, ond omaahôô-ju haale le naatu bop vu hil sen Anutu nanggin sil-ato. ");
INSERT INTO mmo_vpl VALUES ("MT5_20","070_5_20","MAT","5","20","20","Ke, sa naanêêl vu ham naambe ham-ame samu Anutu-te tanasin nivasa savok hil tanasin dangga osin hil Palisai-so le, ond ham-ame le andukana gaving Anutu-te hil e.” ");
INSERT INTO mmo_vpl VALUES ("MT5_21","070_5_21","MAT","5","21","21","+ o 5:21 Eks 20:13; 21:12; Diu 5:17; Lev 24:17*“Ham hango himbop bôôy-ate tanasin neep nambe, ‘Game ganyiis omaahonôôn jimb e. Naambe ti nyiis omaaho ango jimb ond lohvu biing vakasin-ambe lambu nyevahaan vu.’ ");
INSERT INTO mmo_vpl VALUES ("MT5_22","070_5_22","MAT","5","22","22","+ o 5:22 1; Jon 3:15*Lemu sa naanêêl vu ham naambe omaaho ti ahekalin vu hali ond lohvu biing vakasin-ambe lambu nyevahaan vu. De naambe omaaho ti naanêêl vu hali naambe, ‘Galumkook ma,’ ond lohvu biing vakasin vu yêêv bop-aso be lambu nyevahaan vu. Tonde ti naanêêl naambe, ‘Hong baayamb ambu, gahimb lung la,’ ond lohvu jêê-na kin vu taaku nipaya be gako nyevahaan. ");
INSERT INTO mmo_vpl VALUES ("MT5_23","070_5_23","MAT","5","23","23","+ o 5:23 Mak 11:25*Om naambe onggako gate salivangin-ambe gana baale alata in naambe onggatung, lemu gakam bu naambe halim-ate vakasin ti neep vu hong, ");
INSERT INTO mmo_vpl VALUES ("MT5_24","070_5_24","MAT","5","24","24","ond onggavuuh gate va mando hôôk alata dangga de ganaah-ambe muuh halim samu vakasin jung na, le mem ganom gatung salivangin vu Anutu. ");
INSERT INTO mmo_vpl VALUES ("MT5_25","070_5_25","MAT","5","25","25","+ o 5:25 Mat 6:14-15; 18:34-35*“Omaaho ti naambe gako hong na in gambiing vakasin, ond muuh samu vakasin pavis vu mopaatôôv. Le naambe nama ond le bu hong dukana yêêv sen nangoyin vakasin-ato nama, be yêêv-anju bu hong dukana ahevaavu-so namand, tombe ahevaavu-so gatung hong dukana kalaambus. ");
INSERT INTO mmo_vpl VALUES ("MT5_26","070_5_26","MAT","5","26","26","Sa naanêêl keen vu hong naambe game le ganom pavis e, de omandôô-ju be gambu dôôk omaahôô-jute nyevahaan lôôt-ambe jung na le mem.” ");
INSERT INTO mmo_vpl VALUES ("MT5_27","070_5_27","MAT","5","27","27","+ o 5:27 Eks 20:14; Diu 5:18*“Ham hango tanasin neep nambe, ‘Game gambiing baayamb e,’ ");
INSERT INTO mmo_vpl VALUES ("MT5_28","070_5_28","MAT","5","28","28","+ o 5:28 2Pi 2:14*lemu sa naanêêl vu ham naambe omaaho ti yi vêêh ti be lopayo yiis yi, ond wiing baayamb vu vêêh-anju hôôk lopayo lung la. ");
INSERT INTO mmo_vpl VALUES ("MT5_29","070_5_29","MAT","5","29","29","+ o 5:29-30 Mat 18:8-9; Mak 9:43-47; Kol 3:5*Naambe gamem vasa taato va nipaya vu hong-ambe gandupake, ond opasuuh-ambe onggaate na vêêl, mem ganim naavi vuuti la mema om nivasa in sil-ame gaate ganim naavi doos dokana taaku nipaya le. ");
INSERT INTO mmo_vpl VALUES ("MT5_30","070_5_30","MAT","5","30","30","De naambe onamam vaalu vasa nôôh va nipaya ond okatôôv-ambe onggaate na vêêl, mem ganim naavi vuuti la mema om nivasa in ganim naavi doos-ame dukana taaku nipaya le.” ");
INSERT INTO mmo_vpl VALUES ("MT5_31","070_5_31","MAT","5","31","31","+ o 5:31 Diu 24:1-4; Mat 19:7; Mak 10:4*“Tonde tanasin ango neep nambe, ‘Omaaho ti gavuuh vane ond kaavu kaapiya sen havuuh vanêê-to be bu vu yi.’ ");
INSERT INTO mmo_vpl VALUES ("MT5_32","070_5_32","MAT","5","32","32","+ o 5:32 1Ko 7:10-11*Nganjo sa naanêêl vu ham naambe omaaho ti gavuuh vane na de vane me-nawiing baayamb e, ond omaahôô-ju yoo wiing-ambe vane wiing baayamb, in dangga nambe yoo havuuh-ato. De omaaho ti nambe gako vêêh sen laya havuuh-anjuuto ond omaahôô-ju wiing baayamb having.” ");
INSERT INTO mmo_vpl VALUES ("MT5_33","070_5_33","MAT","5","33","33","+ o 5:33 Eks 20:7; Lev 19:12; Nam 30:2; Diu 23:21*“Tonde yik ham hangoyin himbop bôôy-ate tanasin ti neep nambe, ‘Onaanêêl vakasin ti be onaanêêl naambe keen baandoni gaving, ond game tatuhin e. Nganjo vakasin sen ganêêl lak Anutu me, ond gambiing nôôn jak.’ ");
INSERT INTO mmo_vpl VALUES ("MT5_34","070_5_34","MAT","5","34","34","+ o 5:34-35 Jem 5:12; Mat 23:22; Ais 66:1; Sin 7:49*Nganjo sa naanêêl vu ham naambe ham-ame naanêêl naambe keen baandoni le, malis lôôt. Ham-ame naanêêl baandoni haale in kaandu hamate vakasin e, in baandonii-ju ond Anutu nando. ");
INSERT INTO mmo_vpl VALUES ("MT5_35","070_5_35","MAT","5","35","35","+ o 5:35 Saam 48:2*De ham-ame naanêêl ngaanggis haale in kaandu hamate vakasin e, in ngaanggis ond Anutu nalaah vaha nalakaale. De ham-ame naanêêl Yelusalem haale in kaandu hamate vakasin e, in omaaho lulemak bop-ate taakuu-ju. ");
INSERT INTO mmo_vpl VALUES ("MT5_36","070_5_36","MAT","5","36","36","De game naanêêl lak galum in kaandu gate vakasin e, in game galohvu nambe gambiing galumvalus ti naatu nivalôôy me naatu nivaliis e. ");
INSERT INTO mmo_vpl VALUES ("MT5_37","070_5_37","MAT","5","37","37","+ o 5:37 Jem 5:12*Nganjo ham anjiinggis naambe ‘Êê-e,’ me ham naanêêl naambe ‘Malis,’ be lung. Naambe ham oo naanêêl vakasin daka savok na ond hamate vakasin-anja laam vu Omaaho Nipaya.” ");
INSERT INTO mmo_vpl VALUES ("MT5_38","070_5_38","MAT","5","38","38","+ o 5:38 Eks 21:24; Lev 24:20; Diu 19:21*“Ham hango tanasin neep nambe, ‘Omaaho ango kaatuuh gamem-ambe gamem kanu dôôk, ond okaatuuh yinêên-ambe mekanu dôôk dukanaah. De naambe kaatuuh onavum-ambe kalêêh ond okaatuuh navu be kalêêh dukanaah.’ ");
INSERT INTO mmo_vpl VALUES ("MT5_39","070_5_39","MAT","5","39","39","+ o 5:39 Lev 19:18; Jon 18:22-23*Nganjo sa naanêêl vu ham naambe omaahonôôn lambiing nipaya vu ham ond ham-ame ambiing nipaya dukanaah e. Om omaaho ti patap onggaambôôk vaalu vasa, ond ganggilin vaalu kêênj in patap gaving. ");
INSERT INTO mmo_vpl VALUES ("MT5_40","070_5_40","MAT","5","40","40","+ o 5:40 1Ko 6:7*De omaaho ti gako hong na in gambiing vakasin in nambe ombaanggo yi jak gate lolop, ond gambu vu tonde gambu tôômb vu gaving. ");
INSERT INTO mmo_vpl VALUES ("MT5_41","070_5_41","MAT","5","41","41","De naambe omaaho ti osin haale naanêêl vu hong naambe onggako yite kupak-ambe gana mop boow ti gaving yi, ond yik onggako be mana, tonde goo balu-gana boow ango gaving yi. ");
INSERT INTO mmo_vpl VALUES ("MT5_42","070_5_42","MAT","5","42","42","De naambe omaaho ti kataangg hong in vati ond yik gambu vu, de omaaho ti wiingin nambe gako gate vati be na vêêl e mem gako nom, ond yik game gambu teenin in yi le.” ");
INSERT INTO mmo_vpl VALUES ("MT5_43","070_5_43","MAT","5","43","43","+ o 5:43 Lev 19:18*“Ham hangoyin tanasin neep nambe, ‘Gahem gaving gate hil, de ganimbaya hil sen dawiing hong payaa-to.’ ");
INSERT INTO mmo_vpl VALUES ("MT5_44","070_5_44","MAT","5","44","44","+ o 5:44 Eks 23:4-5; Luk 23:34; Sin 7:60; Lom 12:14,20; 1Ko 4:12*Nganjo sale naanêêl vu ham naambe ham ahem gaving hil sen dawiing ham payaa-to, osin ham anohak na vu Anutu in bu yite samu samu vu hil sen dawiing nindanjeen vu ham-ato, ");
INSERT INTO mmo_vpl VALUES ("MT5_45","070_5_45","MAT","5","45","45","+ o 5:45 Ep 5:1*in taato naambe hamate Mom sen nando baandonii-to noondin ham, in yik Anutu nawiing yite taaku natum ak vu hil anipaya osin hil anivasa, tonde nawiing yite luk nato vu hil anivalok osin hil anipaya. ");
INSERT INTO mmo_vpl VALUES ("MT5_46","070_5_46","MAT","5","46","46","Naambe ham ahem oo gaving hil sen ahend naving ham-ato mu, de ham ahem-ame naving hil vaalu le, ond yik hil anipaya pin ond sil oo ahend naving silate hil va timu nambêênja, le hamambe Anutu le bu nivasa nyevahaan vu ham a? Malis lôôt. ");
INSERT INTO mmo_vpl VALUES ("MT5_47","070_5_47","MAT","5","47","47","De naambe ham oo bakaas vu halim-aso mu, ond yik hil vaalu sen sil doosin Anutuu-to ond sil oo mondakaas having halindin va timu nambêênja, om ham awiing vaati be savok sil? Malis, ");
INSERT INTO mmo_vpl VALUES ("MT5_48","070_5_48","MAT","5","48","48","+ o 5:48 Lev 19:2; Diu 18:13*om ham oo mando nivalok lôôt naambe sen hamate Mom nando baandoni be yoo nando nivalok lôôt-ato.” ");
INSERT INTO mmo_vpl VALUES ("MT6_1","070_6_1","MAT","6","1","1","+ o 6:1 Mat 23:5*Yesu nêêl nambe, “Ham ganggin ham, ham-ame ambiing hamate kul anivasa jak hil amend in nambe sil lanji le. Naambe ham ambiing naambêênja ond hamate Mom sen nando baandonii-to me-le bu nyevahaan nivasa vu ham e. ");
INSERT INTO mmo_vpl VALUES ("MT6_2","070_6_2","MAT","6","2","2","Om gambu va in dôôvu hil sen dativak in va yuuh amêê-to ond game gako hong jak e, in hateesin ambu-so dave vuuk munggin e mem davu va vu hil hôôk dumb alo osin talind in nambe hil lanji sil-ambe gako sil haalend jak, nganjo sa naanêêl keen vu ham naambe omaahonôôn lako sil lak nivasa lung laa-ju, om me-le daatovu nyevahaan nivasa ango vu taamusin e. ");
INSERT INTO mmo_vpl VALUES ("MT6_3","070_6_3","MAT","6","3","3","+ o 6:3 Mat 25:37-40*Gandôôvu hil sen dativak-ato, ond gate omaaho ti me-gango banye be gako ohaalem jak e, ");
INSERT INTO mmo_vpl VALUES ("MT6_4","070_6_4","MAT","6","4","4","in va sen onavu de hil doosin-ato ond gate Mom nayi, om yoo le bu nyevahaan vu hong.” ");
INSERT INTO mmo_vpl VALUES ("MT6_5","070_6_5","MAT","6","5","5","+ o 6:5 Mat 23:5; Luk 18:10-14*“De ham anohak ond ham-ame anohak naambe hateesin ambu-so le. Sil-anju daale dalohak hôôk dumb alo osin mop lavuun in nambe hil lanji sil. Sa naanêêl keen vu ham naambe omaahonôôn lako sil lak nivasa lung laa-ju, om me-le daatovu nyevahaan nivasa ango vu taamusin e. ");
INSERT INTO mmo_vpl VALUES ("MT6_6","070_6_6","MAT","6","6","6","+ o 6:6 2King 4:33*Om ganohak ond gandukana gate bayêên alopayo be ombaayiiy vinavi, le mem ganohak vu gate Mom sen nando vunin-ato, in Mom nayi onalohak hôôk bayêên alôô-to tombe le bu nyevahaan vu hong. ");
INSERT INTO mmo_vpl VALUES ("MT6_7","070_6_7","MAT","6","7","7","+ o 6:7 Ais 1:15; 1King 18:26-29*Ham anohak ond ham-ame anohak vakasin mali-malis naambe hil alundoos e. Sil-anju kand navu nambe daanêêl silate lohakin dinaandiin ond mem sil e gako nôôn. ");
INSERT INTO mmo_vpl VALUES ("MT6_8","070_6_8","MAT","6","8","8","+ o 6:8 Mat 6:32*Ham-ame anohak dinaandiin naambe sil e, in ham naahen navu kataangg hamate Mom, de yoo lak va pin sen ham nativak in-ato ni lung la. ");
INSERT INTO mmo_vpl VALUES ("MT6_9","070_6_9","MAT","6","9","9","+ o 6:9 Jon 17:6*Om ham anohak naambêênjo naambe, ‘Aamangg, hong sen onando baandoni, hil lambu vaambuung in ohaalem. ");
INSERT INTO mmo_vpl VALUES ("MT6_10","070_6_10","MAT","6","10","10","+ o 6:10 Mat 7:21; 26:39; Luk 22:42*Ganaam naatu heyate Omaaho Bop-ambe ganohvu taaku pin, de hil pin lambiing nohvu gakam nanjip voon naambe sen angela dawiing vu baandonii-to. ");
INSERT INTO mmo_vpl VALUES ("MT6_11","070_6_11","MAT","6","11","11","Gambu vanôôn in dôôvu hey peey-anjo, ");
INSERT INTO mmo_vpl VALUES ("MT6_12","070_6_12","MAT","6","12","12","+ o 6:12 Mat 18:21-35*de okawiiy heyate va nipaya na nohvu hey oo navu kawiiy hil-ate nyevahaan sen dawiing vu hey-ato nala. ");
INSERT INTO mmo_vpl VALUES ("MT6_13","070_6_13","MAT","6","13","13","+ o 6:13 Mat 26:41; Luk 22:40; Jem 1:13; Jon 17:15; 2Tes 3:3; 2Ti 4:18; 1Kro 29:11-13*Game naanggiiy hey ana ngaaho vu palapin e, nganjo ganôôh hey vêêl in omaaho nipaya. In goo timu nanggin va pin, tonde niwêêk osin nikaapulis pin neep vu hong-ambe le nanjip danggata. Keen.’ ");
INSERT INTO mmo_vpl VALUES ("MT6_14","070_6_14","MAT","6","14","14","+ o 6:14-15 Mak 11:25-26*“Ke, naambe ham kawiiy omaahonôôn-ate va nipaya sen dawiing vu ham-ato na, ond hamate Mom vu baandoni le kawiiy hamate va nipaya na gaving. ");
INSERT INTO mmo_vpl VALUES ("MT6_15","070_6_15","MAT","6","15","15","Le naambe ham-ame kawiiy omaahonôôn-ate va nipaya na le, ond hamate Mom-ame le kawiiy hamate va nipaya na le.” ");
INSERT INTO mmo_vpl VALUES ("MT6_16","070_6_16","MAT","6","16","16","+ o 6:16 Ais 58:5-9*“Ham anjakin ham in vanôôn-ande ham-ame angga le, ham oo mando mu in nambe ham anohak vu Anutu, ond ham-ame mando osin ningook naambe hateesin ambu-so le. Sil dando osin nind ngook in nambe hil lanjak sil anind naambe dalakin sil in vanôôn, om sa naanêêl keen vu ham naambe omaahonôôn lako sil lak nivasa lung laa-ju, om me-le daatovu nyevahaan nivasa ango vu taamusin e. ");
INSERT INTO mmo_vpl VALUES ("MT6_17","070_6_17","MAT","6","17","17","Le naambe ganjakin hong in vanôôn in nambe ganohak vu Anutu ond gambu dôôk galum osin ganjipis gamem, ");
INSERT INTO mmo_vpl VALUES ("MT6_18","070_6_18","MAT","6","18","18","in nambe hil-ame lanjak ganim naambe galakin hong in vanôôn e, de Mom sen nando vunin-ato yoo le jak ganim, ond yoo le bu nyevahaan nivasa vu hong.” ");
INSERT INTO mmo_vpl VALUES ("MT6_19","070_6_19","MAT","6","19","19","+ o 6:19 Jem 5:1-3*“Ham-ame anggôôlis hamate kupak anivasa vasa vu voon-anjo le. Vu voon-anjo vivak naya va osin guvin nalak, de hil hôôndak dalukala bayêên-ambe dahôôndak-ato. ");
INSERT INTO mmo_vpl VALUES ("MT6_20","070_6_20","MAT","6","20","20","+ o 6:20 Mat 19:21; Luk 18:22; Kol 3:1-2*Nganjo ham ambiing va nivasa mu in nambe Anutu gatung nôôn anivasa mando ganggin ham vu baandoni. Vu baandoni ond vivak osin guvin-ame le biliyak va le, de hil hôôndak-ame le landukana be langgôôndak e. ");
INSERT INTO mmo_vpl VALUES ("MT6_21","070_6_21","MAT","6","21","21","In taaku sen gate nôôn anivasa vasa nandôô-to ond galompayo le na vu taakuu-ju.” ");
INSERT INTO mmo_vpl VALUES ("MT6_22","070_6_22","MAT","6","22","22","“Gamem kaalus ond ganim naavi-te kin tumin. Om naambe gamem kaalus anivasa ond le naatum nohvu ganim naavi pin. ");
INSERT INTO mmo_vpl VALUES ("MT6_23","070_6_23","MAT","6","23","23","Le naambe gamem kaalus anipaya ond ganim naavi pin e mekanu. Om naambe gate melangaah-anja mekanu dôôk, ond mekanuu-to le naatu bopaata lôôt.” ");
INSERT INTO mmo_vpl VALUES ("MT6_24","070_6_24","MAT","6","24","24","“Omaaho ti me-lohvu nambe biing kul aniwêêk vu yêêv yuuh e, in le nimbaya in ango de ahe gaving ango, om le naapuvu ango de galuuh dami vu ango. Om ham-ame alohvu nambe ham ambiing Anutu-te kul aniwêêk-ande ham ambiing kul mone niwêêk gaving e.” ");
INSERT INTO mmo_vpl VALUES ("MT6_25","070_6_25","MAT","6","25","25","+ o 6:25 Pil 4:6; 1Ti 6:6-8; Hiblu 13:5; 1Pi 5:7*“Sa naanêêl vu ham naambe ham-ame naham jak in vanôôn sen ham anggaa-to le, de bel sen ham naanum, osin tôômb sen ham anjop in nambe dôôvu ham anim naavii-to le, in yiiy nando metumin ond savok vanôôn, de yaningg naavi ond savok tôômb. ");
INSERT INTO mmo_vpl VALUES ("MT6_26","070_6_26","MAT","6","26","26","+ o 6:26 Mat 10:29-31; Luk 12:6-7*Ham akam bu manak e, in manak-ame daalôôh vanôôn e, de me-dasupin vanôôn nôôn-ambe datung lakala pêêt e, ma de hamate Mom sen nando baandonii-to yoo navaat sil. De ham ond ham haalem bop savok manak-anju om Anutu le baat ham. ");
INSERT INTO mmo_vpl VALUES ("MT6_27","070_6_27","MAT","6","27","27","Ham ti tana lohvu nambe ka monambu be gakoseey yite busin sen mando voon-anjôôto balu-na daka gaving? Malis. ");
INSERT INTO mmo_vpl VALUES ("MT6_28","070_6_28","MAT","6","28","28","De nambe vaati sen ham naham nalak in tôômb ayuuh amêê-to? Ham akam bu ngaaola nalup hôôk paahup alo, ond me-dawiing kul bop osin me-davu samu silate tôômb e, ");
INSERT INTO mmo_vpl VALUES ("MT6_29","070_6_29","MAT","6","29","29","+ o 6:29 1King 10; 2Kro 9*lemu sa naanêêl vu ham naambe bôôy Solomon vunak yi lak vunakin amengali-ngali pin, le yite vunakin-ame nivasa nambe sen ngaaolaa-ju le. ");
INSERT INTO mmo_vpl VALUES ("MT6_30","070_6_30","MAT","6","30","30","Paahup sen gêên nando de jeey e hil basii-to ond Anutu yoo navunak, om yoo le ganggin ham savok paahup-anju na, le ham-ame nawii-having niwêêk e. ");
INSERT INTO mmo_vpl VALUES ("MT6_31","070_6_31","MAT","6","31","31","Om ham-ame naham jak-ambe ham naanêêl naambe, ‘Yale angga vaati?’ me, ‘Yale naanum vaati?’ de, ‘Yale aanjop vaati?’ ");
INSERT INTO mmo_vpl VALUES ("MT6_32","070_6_32","MAT","6","32","32","+ o 6:32 Mat 6:8*Va pin-anja hil vaalu sen sil doosin Anutuu-to ond sil oo mondawiing mend in, lemu hamate Mom vu baandoni yoo lak ham anim lung la nambe ham nativak in va nambêênja. ");
INSERT INTO mmo_vpl VALUES ("MT6_33","070_6_33","MAT","6","33","33","+ o 6:33 1King 3:10-14; Saam 37:4,25; Lom 14:17*Om yik ham akam oo bu sen Anutu nanggin ham-ato naamunggin, osin ham ambiing va nivalok nohvu ka ond mem va pin-anja Anutu le bu vu ham. ");
INSERT INTO mmo_vpl VALUES ("MT6_34","070_6_34","MAT","6","34","34","+ o 6:34 Eks 16:4,19; Mat 6:11*Om ham-ame naham jak naambe mak nimeen vaati le naatovu ham jeey. Nganjo va sen jeey-ato ond jeey e mem ham akam bu, de busin ti ti-te nimeen ond ham oo kam bu hôôk yite busin nivalok, tombe yik lung.” ");
INSERT INTO mmo_vpl VALUES ("MT7_1","070_7_1","MAT","7","1","1","+ o 7:1 Lom 2:1; 1Ko 4:5; Jem 4:11-12*Yesu nêêl nambe, “Ham-ame sahi omaaho ango-te vakasin-ambe ham naanêêl ak sil alund e, in nambe mem Anutu me-le sahi hamate vakasin-ambe naanêêl ak ham alum e. ");
INSERT INTO mmo_vpl VALUES ("MT7_2","070_7_2","MAT","7","2","2","+ o 7:2 Mak 4:24*Le naambe ham navu sahi hil-ate vakasin ond yik Anutu le sahi hamate vakasin va timu. Yik Anutu le biing dukanaah vu ham naambe sen ham nawiing vu omaaho angôô-to. ");
INSERT INTO mmo_vpl VALUES ("MT7_3","070_7_3","MAT","7","3","3","Nambe vaati onahe kaalekaale daka hôôk halim ame, de game nahe haah boow sen neep hôôk gamem e? ");
INSERT INTO mmo_vpl VALUES ("MT7_4","070_7_4","MAT","7","4","4","Haah boow yoo neep hôôk gamem, le nambe vaati sen ganêêl vu halim nambe ‘Ombaale de sa japêêh va daka na vêêl in gamem e.’ ");
INSERT INTO mmo_vpl VALUES ("MT7_5","070_7_5","MAT","7","5","5","Goo natee hong ak, ganôôh haah boow sen neep hôôk gamem-anjaato na vêêl e, mem gale gangge nivasa be onjapêêh kaalekaale na in halim ame. ");
INSERT INTO mmo_vpl VALUES ("MT7_6","070_7_6","MAT","7","6","6","+ o 7:6 Mat 10:11*Ham-ame ambu Anutu-te va vaambuung vu hil sen sil lalohvu voow-ato le, de ham-ame gaate hamate vunakin anivasa sen ham naanggo lak mone bop-ato vu bik e, in sil e baake jak vahand vêêl e mem le langgilin-ambe lanja ham.” ");
INSERT INTO mmo_vpl VALUES ("MT7_7","070_7_7","MAT","7","7","7","+ o 7:7 Jer 29:13-14; Mak 11:24; Jon 14:13-14; 15:7; 16:23-24*“Ham kataangg va vu Anutu ond le bu vu ham, de ham salo ond ham e naatokak, tonde ham anyiis ak vinavi ond Anutu le gataahin in ham. ");
INSERT INTO mmo_vpl VALUES ("MT7_8","070_7_8","MAT","7","8","8","+ o 7:8 Jem 1:5; 1Jon 3:22; 5:14-15*In hil pin sen davu kataangg Anutuu-to ond sil e gako, de hil sen davu salôô-to ond le daatovu, de hil sen dayiis ak vinavii-to ond Anutu le gataahin vinavi in sil. ");
INSERT INTO mmo_vpl VALUES ("MT7_9","070_7_9","MAT","7","9","9","De naambe ham ti noow kataangg vanôôn vu mangganaan, ond mak mangganaan e bu tatuuh vu? Malis. ");
INSERT INTO mmo_vpl VALUES ("MT7_10","070_7_10","MAT","7","10","10","De naambe kataangg paahuung vu mangganaan, ond mak mangganaan e bu nyêêy anipaya ti vu? Malis lôôt. ");
INSERT INTO mmo_vpl VALUES ("MT7_11","070_7_11","MAT","7","11","11","+ o 7:11 Jem 1:17*Ham hil anipaya voon-ate, lemu ham akam navu noom-aso be ham navu va nivasa vasa vu sil, om ham anjak ni bulôôt naambe hamate Mom sen nando baandonii-to le biing va nivasa vasa vu hil sen davu kataangg vu yii-to. ");
INSERT INTO mmo_vpl VALUES ("MT7_12","070_7_12","MAT","7","12","12","+ o 7:12 Mat 22:39-40; Luk 6:31; Lom 13:8-10*Va pin sen ham nawiingin nambe hil lambiing vu ham-ato, ond yik ham oo ambiing naambêênja vu hil, in Mose-te tanasin-ande Anutu-te vakasin sen hil danêêl langaah bôôy-ato danggakook nambêênja.” ");
INSERT INTO mmo_vpl VALUES ("MT7_13","070_7_13","MAT","7","13","13","“Ham andukana mop avi ango pasiv in nala metumin-ate. Nganjo mopaatôôv ango sen nala taaku nipayaa-to, ond tatekin-ambe neep bopaata tombe hil ngeeyaata dalukala mop-anju lôôt. ");
INSERT INTO mmo_vpl VALUES ("MT7_14","070_7_14","MAT","7","14","14","+ o 7:14 Jon 10:7,9; Sin 14:22*Nganjo mop sen nala metumin-atêêto ond avi nipasiv-ande mop anipasiv having, om hil daka yuu-mu datovu be dalukala.” ");
INSERT INTO mmo_vpl VALUES ("MT7_15","070_7_15","MAT","7","15","15","+ o 7:15 Mat 24:4,24; Sin 20:29; 2Pi 2:1*“Ham ganggin ham nivasa in hil sen danêêl tanasin tatuhin-ato, in hil-anja dalaas vu ham nambe sen sipsip amelaas-ato, tombe ham e kam bu naambe hil anivasa, lemu sil alondpayo nipaya nambe voow bamaan sen dawiingin nambe lanja ham-ato. ");
INSERT INTO mmo_vpl VALUES ("MT7_16","070_7_16","MAT","7","16","16","+ o 7:16 Gal 5:19-22; Jem 3:12*Ham oo angge va sen sil dawiing-ato ond mem ham e anjak sil anind, in ganggwak-ame nayiis nôôn kopi le, de dandayin-ame nayiis nôôn bangguk e, malis. ");
INSERT INTO mmo_vpl VALUES ("MT7_17","070_7_17","MAT","7","17","17","Haah anivasa nayiis nôôn anivasa, le haah ti nipaya lak ond nayiis nôôn anipaya. ");
INSERT INTO mmo_vpl VALUES ("MT7_18","070_7_18","MAT","7","18","18","Haah anivasa ond me-le nyiis nôôn anipaya le, de haah anipaya ond me-le nyiis nôôn anivasa le. ");
INSERT INTO mmo_vpl VALUES ("MT7_19","070_7_19","MAT","7","19","19","+ o 7:19 Mat 3:10; Luk 3:9; Jon 15:6*Haah pin sen me-nayiis nôôn anivasaa-to ond dasap-ambe dasi lak kin. ");
INSERT INTO mmo_vpl VALUES ("MT7_20","070_7_20","MAT","7","20","20","+ o 7:20 Mat 12:33*Om nambêênja ham angge hil sen danêêl tanasin tatuhin-ato silate mopaatôôv ond mem ham e anjak silate dangga ni.” ");
INSERT INTO mmo_vpl VALUES ("MT7_21","070_7_21","MAT","7","21","21","+ o 7:21 Luk 6:46; Mat 21:31; Lom 2:13; Jem 1:22,25*“Hil sen danêêl sa nambe Omaaho Bop, ond sil pin-ame le landukana gaving Anutu-te hil osin doos e, malis. Nganjo hil sen dawiing va lohvu Aamangg sen nando baandonii-to ka ond mem le landukana. ");
INSERT INTO mmo_vpl VALUES ("MT7_22","070_7_22","MAT","7","22","22","+ o 7:22 Jer 14:14*Vu busin taamusin-anju ond hil ngeeyaata le daanêêl vu sa naambe, ‘Omaaho Bop, bôôy hey navu tatekin vakasin lak ohaalem, de hey natiiy mamu nipaya nala in omaahonôôn lak ohaalem, de hey naawiing taahu taahu osin niwêêk ngeeyaata lak ohaalem.’ ");
INSERT INTO mmo_vpl VALUES ("MT7_23","070_7_23","MAT","7","23","23","+ o 7:23 Saam 6:8; Mat 10:33; 13:41-42; 25:41; 2Ti 2:19*Tombe sale naanêêl langaah vu sil naambe, ‘Sa doosin ham. Ham hil anipaya, ham ana vêêl in sa.’”. ");
INSERT INTO mmo_vpl VALUES ("MT7_24","070_7_24","MAT","7","24","24","+ o 7:24 Jem 1:22*“Omaaho ti gango sate vakasin-anjo be biing nôôn jak ond lohvu omaaho ti osin ka haav yite ngaandiin bayêên lukala naale lak tatuuh, ");
INSERT INTO mmo_vpl VALUES ("MT7_25","070_7_25","MAT","7","25","25","tombe luk hatolak, de bel vaal bopaata de vavi have bayêên-anju lôôt, le bayêên-ame kape le, in tatuuh puvu ngaandiin tatin. ");
INSERT INTO mmo_vpl VALUES ("MT7_26","070_7_26","MAT","7","26","26","Nganjo omaaho ti gango sate vakasin-anjo le me-taamuyin e, ond lohvu omaaho ka ma be haav yite bayêên ngaandiin lukala naale laahel, tombe luk hatolak-ande bel vaal bopaata osin vavi have bayêên-anju lôôt, ");
INSERT INTO mmo_vpl VALUES ("MT7_27","070_7_27","MAT","7","27","27","tomem bayêên kape be matelak lôôt.” ");
INSERT INTO mmo_vpl VALUES ("MT7_28","070_7_28","MAT","7","28","28","+ o 7:28-29 Mak 1:22; Luk 4:32; Jon 7:46*Yesu nêêl vakasin-anju be lung la, tombe hil alu bopaata sen dandôô-juuto ond sil lavindis lôôt in yite tanasin, ");
INSERT INTO mmo_vpl VALUES ("MT7_29","070_7_29","MAT","7","29","29","in me-nawiing tanasin vu sil nambe sen hil tanasin dangga-so le, malis, nganjo yoo nanêêl lohvu yêêv bop ti. ");
INSERT INTO mmo_vpl VALUES ("MT8_1","070_8_1","MAT","8","1","1","Yesu luus vu kanduu-ju be la, tombe hil ngeeyaata lôôt taamuyin yi. ");
INSERT INTO mmo_vpl VALUES ("MT8_2","070_8_2","MAT","8","2","2","Tombe omaaho ti nipayêês anipaya lôôt-ato la vu Yesu be hatung kaatu vu yi, de nêêl nambe, “Omaaho Bop, lohvu ond gandôôvu sa be sa ningg naavi nivasa jak.” ");
INSERT INTO mmo_vpl VALUES ("MT8_3","070_8_3","MAT","8","3","3","Tombe Yesu hambe nama lak yi de nêêl nambe, “Êê-e, lohvu saandôôvu hong, om ganim naavi nivasa jak.” Tombe yik payêês-anju lung la pavis-ande nivasa lak. ");
INSERT INTO mmo_vpl VALUES ("MT8_4","070_8_4","MAT","8","4","4","+ o 8:4 Mat 9:30; Mak 7:36; Lev 14:1-32; Luk 17:14*Tonde Yesu vu kôôvu nambe, “Ongganggin hong, game naanêêl vaa-jo vu omaaho ti le, nganjo gana taato ganim naavi vu kul vaha sen datung salivangin-ato ti, de onggatung salivangin nohvu Mose-te tanasin nêêl-ato in nambe mem hil lanjak ni naambe ganim vasa lak lung la.” ");
INSERT INTO mmo_vpl VALUES ("MT8_5","070_8_5","MAT","8","5","5","+ o 8:5 Jon 4:46-47*Yesu tok la Kapenaum, tombe hil Lom-ate yêêv ngaamong vaha ti la vu Yesu be kataangg nambe, ");
INSERT INTO mmo_vpl VALUES ("MT8_6","070_8_6","MAT","8","6","6","“Omaaho Bop, sate kul vaha daka nilak-ambe neep hôôk bayêên alo, ond nama osin vaha nipaya be nango nivaane bopaata lôôt.” ");
INSERT INTO mmo_vpl VALUES ("MT8_7","070_8_7","MAT","8","7","7","Tombe Yesu nêêl vu nambe, “Om sa nalaas in saambiing-ambe nivasa jak.” ");
INSERT INTO mmo_vpl VALUES ("MT8_8","070_8_8","MAT","8","8","8","Le yêêv-anju nêêl laah vu nambe, “Omaaho Bop, sa omaaho nipaya, om me-lohvu nambe gandukanaam sate bayêên alo le, om yik onaanêêl amu de sate unoopasiv-anju nivasa jak. ");
INSERT INTO mmo_vpl VALUES ("MT8_9","070_8_9","MAT","8","9","9","Nambe sen sa, ond yik sa naahulis sate yêêv bop sen nanggin saa-to baambu, de sate hil ngaamong vaha-so dahulis sa baambungg. Om sa naanêêl vu ti naambe ‘Gana’ ond yik la, de sa naanêêl vu ango naambe ‘Ganaam’ ond yik laam, de sa naanêêl vu sate kul vaha naambe ‘Gambiing kul tii-ja’ ond yik wiing.” ");
INSERT INTO mmo_vpl VALUES ("MT8_10","070_8_10","MAT","8","10","10","+ o 8:10 Mat 15:28*Yesu hango vakasin-anju tombe vindis lôôt, de nêêl vu hil sen davu taamuyin yii-to nambe, “Sa naanêêl keen vu ham naambe same aatovu ham Islel ti wii-having niwêêk lôôt nambêênjo le. ");
INSERT INTO mmo_vpl VALUES ("MT8_11","070_8_11","MAT","8","11","11","+ o 8:11 Saam 107:3; Luk 13:28-29*Om sa naanêêl vu ham naambe hil ngeeyaata lohvu taaku nanyendangga pin, ond le lana lanja vanôôn gaving Abalaam ayuuh Isak-ambe Yaakop mando taaku sen Anutu nanggin yite hil-ato. ");
INSERT INTO mmo_vpl VALUES ("MT8_12","070_8_12","MAT","8","12","12","+ o 8:12 Mat 22:13; 25:30; Luk 13:28*De Anutu le gatiiy Yuda vaalu lana taaku mekanu sen neep dami lôôt-ato, be sil lana mondaasu osin navund monaangitak vuu-ju.” ");
INSERT INTO mmo_vpl VALUES ("MT8_13","070_8_13","MAT","8","13","13","Tombe Yesu nêêl vu yêêv-anju nambe, “Om ganaah, gate vakasin navu nôôn jak nohvu gawii-having-anja.” Tombe yik yêêv-anjute kul vaha nivasa lak hôôk taaku me tii-ju vulotin. ");
INSERT INTO mmo_vpl VALUES ("MT8_14","070_8_14","MAT","8","14","14","+ o 8:14 1Ko 9:5*Tonde Yesu lukala Pita-te bayêên alo, tombe yi de Pita yenaavêêh anivaane be neep. ");
INSERT INTO mmo_vpl VALUES ("MT8_15","070_8_15","MAT","8","15","15","Om Yesu puvu hôôk nama, tonde mem nivaanêê-to lung la, de kandi be la hayêêh vanôôn-ambe vu vu Yesu. ");
INSERT INTO mmo_vpl VALUES ("MT8_16","070_8_16","MAT","8","16","16","Tonde soosin atombe lako hil sen mamu nipaya dahôôvu sil-ato ngeeyaata be lala vu Yesu, tombe yik nêêl-ande mamu nipaya lato dala in omaahonôôn, de wiing-ambe hil anilakin pin nind vasa lak laah. ");
INSERT INTO mmo_vpl VALUES ("MT8_17","070_8_17","MAT","8","17","17","+ o 8:17 Ais 53:4*Om nambêênju wiing Anutu-te vakasin ti sen Yesaia nêêl bôôy-ato nôôn ak nambe, “Yoo hako yate nilakin vêêl-ambe vu vêêl yate nivaane.” ");
INSERT INTO mmo_vpl VALUES ("MT8_18","070_8_18","MAT","8","18","18","Yesu yi hil ngeeyaata lambuuh yi tatup, tombe nêêl vu yite maanggêêm-aso nambe, “Yana betum vaalu.” ");
INSERT INTO mmo_vpl VALUES ("MT8_19","070_8_19","MAT","8","19","19","Tombe tanasin dangga ti la nêêl vu nambe, “Kaputung, taaku pin sen ganaa-to ond sale taamuyin hong-ambe sana gaving.” ");
INSERT INTO mmo_vpl VALUES ("MT8_20","070_8_20","MAT","8","20","20","+ o 8:20 2Ko 8:9*Le Yesu nêêl vu nambe, “Manggalôôn ond deep hôôk haah vuun, de manak ond dahaav vunis, nganjo Omaahonôôn Noow ond baan sen nanjip hôôk-ato ma.” ");
INSERT INTO mmo_vpl VALUES ("MT8_21","070_8_21","MAT","8","21","21","+ o 8:21 1King 19:20*Tonde yik maanggêêm-aso ti nêêl vu nambe, “Omaaho Bop, ganjiinggis-ande sana ganggin mangg-ambe jimb-ambe sa daav vêêl e.” ");
INSERT INTO mmo_vpl VALUES ("MT8_22","070_8_22","MAT","8","22","22","+ o 8:22 Jon 5:25*Le Yesu nêêl vu nambe, “Otaamuyin sa, de hil sen nanyendoos in Anutu-te vakasin-ambe sil lalohvu hil yimbin-ato ond sil oo landaav silate halanjang.” ");
INSERT INTO mmo_vpl VALUES ("MT8_23","070_8_23","MAT","8","23","23","Yesu lakala kaanu tombe yite maanggêêm-aso lalakala having-ambe sil lala. ");
INSERT INTO mmo_vpl VALUES ("MT8_24","070_8_24","MAT","8","24","24","+ o 8:24 Saam 4:8*Lala lalup betum lavuun atombe vavi bopaata wiing-ambe bel anipaya lak lôôt-ambe wiingin nambe savun kaanu na, le Yesu yoo neep ka lingin. ");
INSERT INTO mmo_vpl VALUES ("MT8_25","070_8_25","MAT","8","25","25","Tombe lala layêêvu de lanêêl vu nambe, “Omaaho Bop, gandôôvu yiiy in yiiy navu ana mengg nama.” ");
INSERT INTO mmo_vpl VALUES ("MT8_26","070_8_26","MAT","8","26","26","+ o 8:26 Mat 14:31; 16:8; Saam 89:9*Tombe nêêl vu sil nambe, “Ham naham nalak in? Ham-ame awii-having niwêêk e.” Nêêl atonde kandi lak-ambe nêêl vavi yuuh bel, tombe vavi ma la de bel neep tatimasin. ");
INSERT INTO mmo_vpl VALUES ("MT8_27","070_8_27","MAT","8","27","27","Tombe kanund la lôôt-ande lanêêl nambe, “Omaahôô-jo yi vaati ondeey vavi yuuh bel nanyend vuun in lava?” ");
INSERT INTO mmo_vpl VALUES ("MT8_28","070_8_28","MAT","8","28","28","Yesu-so mondala be latok lala hil Gadala-te taaku neep betum vaalu, tombe omaaho yuuh yik mamu nipaya lahôôvu yuuh-ato ond yuuh vu lavandangga sen omaahonôôn bandumb-ato be lato vu yi. Omaaho yuuh-anju yuuh lalohvu mamu bamaan anipaya om hil dayêênin-ambe me-daloh mop-anju le. ");
INSERT INTO mmo_vpl VALUES ("MT8_29","070_8_29","MAT","8","29","29","+ o 8:29 Mak 1:24; Luk 4:34,41*Tombe yuuh lateey nambe, “Anutu Noow, gayêêvu hey in? Busin naahen-ande galaam in nambe gambu nivaane vu hey pavis a?” ");
INSERT INTO mmo_vpl VALUES ("MT8_30","070_8_30","MAT","8","30","30","Taakuu-ju ond bik ngeeyaata daale mondaya va daale diin, ");
INSERT INTO mmo_vpl VALUES ("MT8_31","070_8_31","MAT","8","31","31","tombe mamu nipaya kataangg Yesu nambe, “Naambe onggatiiy hey, ond gambiing-ambe hey aandukana bik ngeeyaataa-ju londpayo.” ");
INSERT INTO mmo_vpl VALUES ("MT8_32","070_8_32","MAT","8","32","32","Tombe nêêl vu mamu nambe, “Ham ana.” Tombe sil lato lala in omaaho yuuh-anjuuto be lalukala bik alo, tombe bik pin-anju latup lôôt-ambe laluus taaku pake be lalukala betum, tombe lanum bel-ambe layimb valok-ate. ");
INSERT INTO mmo_vpl VALUES ("MT8_33","070_8_33","MAT","8","33","33","De hil sen danggin bik-ato lapak-ambe lala bayêên bop, tombe latulin vakasin pin osin omaaho yuuh sen mamu nipaya lahôôvu yuuh-ato ond yuuhate vakasin, ");
INSERT INTO mmo_vpl VALUES ("MT8_34","070_8_34","MAT","8","34","34","tombe hil pin vu taakuu-ju lala in nambe lana vu Yesu, tombe latovu yi be sil kataangg nambe gavuuh silate taaku de na taaku ango. ");
INSERT INTO mmo_vpl VALUES ("MT9_1","070_9_1","MAT","9","1","1","+ o 9:1 Mat 4:13*Yesu lakala kaanu be laah betum vaalu, tombe tok la baan, ");
INSERT INTO mmo_vpl VALUES ("MT9_2","070_9_2","MAT","9","2","2","tonde laaku omaaho nipaling ti vaha yuuh nama nipayaa-to neep ak yêênin-ambe lala vu. Tombe Yesu lak ni nambe sil alondpayo la timu vu yi, om nêêl vu omaaho nipaling-anjo nambe, “Noongg-e, gakam vasa jak. Gate nipaya ond sa kawiiy la.” ");
INSERT INTO mmo_vpl VALUES ("MT9_3","070_9_3","MAT","9","3","3","Tombe tanasin dangga-so vaalu yoo kand navu hôôk lond nambe, “Omaahôô-ju wiingin nambe savok Anutu.” ");
INSERT INTO mmo_vpl VALUES ("MT9_4","070_9_4","MAT","9","4","4","+ o 9:4 Mat 12:25; Luk 9:47; Jon 2:25*Tombe Yesu lak silate vakasin sen kand navuu-to ni, om nêêl nambe, “Nambe vaati sen ham akam navu paya hôôk ham alompayo? ");
INSERT INTO mmo_vpl VALUES ("MT9_5","070_9_5","MAT","9","5","5","De sa naanêêl vakasin ango tana in ham angge be ham anjak ni naambe nôôn keen? Sa naanêêl naambe ‘Gate nipaya ond sa kawiiy la,’ ond ham-ame le anjak ni le. Nganjo sa naanêêl naambe ‘Okandi baale be gana,’ ond mem ham e anjak ni naambe nôôn keen. ");
INSERT INTO mmo_vpl VALUES ("MT9_6","070_9_6","MAT","9","6","6","+ o 9:6 Jon 17:2; 5:8*Om peey-anjo ham anjak ni naambe Omaahonôôn Noow laam vu baandoni ond yoo tu danggakook vu voon in nambe kawiiy hil-ate va nipaya na.” Tonde nêêl vu omaaho nipaling-anjôôto nambe, “Okandi gako gate kaanye jak-ambe ganaah gambaam.” ");
INSERT INTO mmo_vpl VALUES ("MT9_7","070_9_7","MAT","9","7","7","Tombe omaahôô-ju kandi lak-ambe laah baan. ");
INSERT INTO mmo_vpl VALUES ("MT9_8","070_9_8","MAT","9","8","8","Hil ngeeyaata layi be layêênin lôôt, tombe lako Anutu haale lak in vu niwêêk nambêênjo vu omaahonôôn in nambe landôôvu omaaho ango. ");
INSERT INTO mmo_vpl VALUES ("MT9_9","070_9_9","MAT","9","9","9","Tonde Yesu vuu-ju be la, tombe yi de omaaho ti nando hôôk bayêên sen dako taakis hôôk-ato, haale nambe Matai. Tombe Yesu nêêl vu nambe, “Ganaam taamuyin sa.” Tombe kandi be la sapa yi. ");
INSERT INTO mmo_vpl VALUES ("MT9_10","070_9_10","MAT","9","10","10","Tombe Yesu having yite maanggêêm-aso be lala dando be mondaya vanôôn hôôk Matai-te bayêên alo, tonde hil sen dako taakis osin hil sen davu kalêêh tanasin-ato ngeeyaata lalaam-ambe dando daya vanôôn having sil. ");
INSERT INTO mmo_vpl VALUES ("MT9_11","070_9_11","MAT","9","11","11","+ o 9:11 Luk 15:2; 19:7*Tombe hil Palisai heey layi be lanêêl vu yite maanggêêm-aso nambe, “Nambe vaati sen hamate kaputung naya vanôôn having hil sen dako taakis osin hil anipaya vaaluu-ju?” ");
INSERT INTO mmo_vpl VALUES ("MT9_12","070_9_12","MAT","9","12","12","Le Yesu hangoyin atombe nêêl nambe, “Hil anind vasa ond me-dala vu dokta le, hil sen nind nalak ond mem dala vu. ");
INSERT INTO mmo_vpl VALUES ("MT9_13","070_9_13","MAT","9","13","13","+ o 9:13 Mat 12:7; Hos 6:6*Ham ana de ham akam bu vakasin munggin-anjo dangga le, sen Anutu nêêl nambe, ‘Same aawiingin salivangin e, nganjo sahengg having nambe ham akam pasiv in omaahonôôn-ambe ham andôôvu sil.’ De sak, same alaam in nambe naateey hil sen datee sil lak nambe sil anivasaa-to le, ma, nganjo sa laam in naateey hil anipaya.” ");
INSERT INTO mmo_vpl VALUES ("MT9_14","070_9_14","MAT","9","14","14","+ o 9:14 Luk 18:12*Lung laa tonde Jon-ate maanggêêm-aso lala vu Yesu be lanêêl vu nambe, “Hey-ande Palisai-so ond hey nalakin hey in vanôôn-ande hey nando meep in nambe hey monaanohak na vu Anutu, le nambe vaati sen gate maanggêêm-ame dalakin sil in vanôôn e?” ");
INSERT INTO mmo_vpl VALUES ("MT9_15","070_9_15","MAT","9","15","15","+ o 9:15 Jon 3:29*Le Yesu nêêl vu sil nambe, “Hil lasupin lala in daapêêlis gaving omaaho ti in hako vêêh moos ond sil-ame lalohvu nambe lanjakin sil in vanôôn-ande sil mando meep e, le nama. Nganjo busin ti le naatok naam atombe hil e lanôôh omaahôô-juuto na vêêl in yite hil, ond mem le lanjakin sil in vanôôn. ");
INSERT INTO mmo_vpl VALUES ("MT9_16","070_9_16","MAT","9","16","16","“De tôômb ti nimbôôy-ambe ahembalap ak tombe kweek, ond omaaho ti me-naanduuh moos kamu ti jakanaah e. Le naambe naanduuh moos kamu ti jakanaah ond le naakweek nimbôôy-ato be naatu bopaata jak. ");
INSERT INTO mmo_vpl VALUES ("MT9_17","070_9_17","MAT","9","17","17","De hil-ame datooy wain moos nalokala bik naavi nimbôôy-ande bambôôv e. Naambe daatooy dukana ond wain e buuk-ambe bapuuh bik naavi nimbôôy-anju biliyak-ande kaasêêh na. Nganjo daatooy wain moos dukana bik naavi moos ond mem wain osin bik naavi le mando nivasa.” ");
INSERT INTO mmo_vpl VALUES ("MT9_18","070_9_18","MAT","9","18","18","Yesu naahen nanêêl vakasin-anju vu sil, tonde yêêv ti la hatung kaatu vu de nêêl nambe, “Sa nonggaavêêh naahen nayimb gesaange, om ganaam gambe namam jak yi tombe mem le kandi vasa dôôk.” ");
INSERT INTO mmo_vpl VALUES ("MT9_19","070_9_19","MAT","9","19","19","Tombe Yesu kandi taamuyin yi be yuuh lala, de yite maanggêêm-aso lala having. ");
INSERT INTO mmo_vpl VALUES ("MT9_20","070_9_20","MAT","9","20","20","+ o 9:20 Mat 14:36*Tonde sim vêêh ti ond vêêh-ate nilakin tovu tombe yoo nando bayêên pasiv nalak busin pin lohvu ta nomaayuuh-ambe laam yuuh, ond valu-naale Yesu dami, tombe hambe nama lak Yesu-te lolop anyendaambu. ");
INSERT INTO mmo_vpl VALUES ("MT9_21","070_9_21","MAT","9","21","21","Vêêh-anju yoo ka vu nambe, “Sa gambe namangg jak yite lolop amu ond sale sa ningg vasa dôôk.” ");
INSERT INTO mmo_vpl VALUES ("MT9_22","070_9_22","MAT","9","22","22","+ o 9:22 Mak 10:52; Luk 17:19*Tombe Yesu hilin-ambe yi vêêh-anju be nêêl vu nambe, “Nonggaavêêh, galompayo ahelavis jak. Gawii-having om ganim vasa lak.” Tombe yik pavis atombe vêêh-anju nivasa lak. ");
INSERT INTO mmo_vpl VALUES ("MT9_23","070_9_23","MAT","9","23","23","Tonde mem Yesu la valup yêêv-anju baan, tombe yi de hil dave gavêêngg osin dawiing nindaandun bopaata, ");
INSERT INTO mmo_vpl VALUES ("MT9_24","070_9_24","MAT","9","24","24","+ o 9:24 Jon 11:11*tombe Yesu nêêl nambe, “Ham ana vêêl. Unaavepasiv-ame yimb e, nganjo yoo neep anêên.” Le sil lanop ak yi. ");
INSERT INTO mmo_vpl VALUES ("MT9_25","070_9_25","MAT","9","25","25","Latiiy hil lato lala vêêl e, tonde mem Yesu lukala bayêên alo be lôôh hôôk unaavepasiv-anju nama be kandi lak. ");
INSERT INTO mmo_vpl VALUES ("MT9_26","070_9_26","MAT","9","26","26","Tombe vaa-ju banye la lohvu taakuu-ju pin. ");
INSERT INTO mmo_vpl VALUES ("MT9_27","070_9_27","MAT","9","27","27","+ o 9:27 Mat 20:29-34*Yesu kandi vuu-ju be la, tombe omaaho mekanôônd yuuh oo mosapa yi, be mondateey nambe, “Hong sen gate danggakook neep vu Devit-ato, gakam pasiv in haay.” ");
INSERT INTO mmo_vpl VALUES ("MT9_28","070_9_28","MAT","9","28","28","Tombe Yesu lukala bayêên alo de omaaho mekanôônd ayuuh-ato lala vu, tombe Yesu lingin yuuh nambe, “Mak mawii-having sa nambe saalohvu aandôôvu muuh a?” Tombe yuuh laliinggis vu nambe, “Êê-e Omaaho Bop, galohvu.” ");
INSERT INTO mmo_vpl VALUES ("MT9_29","070_9_29","MAT","9","29","29","+ o 9:29 Mat 8:13*Tombe hambe nama lak yuuh amend-ande nêêl nambe, “Om mamem anivasa jak nohvu mawii-having-ato.” ");
INSERT INTO mmo_vpl VALUES ("MT9_30","070_9_30","MAT","9","30","30","+ o 9:30 Mat 8:4*Om yuuh amend tum, tombe Yesu vu kôôvu yuuh niwêêk nambe, “Maayuuh, mame naanêêl vaa-jo vu omaaho ti le.” ");
INSERT INTO mmo_vpl VALUES ("MT9_31","070_9_31","MAT","9","31","31","Le ma de yuuh lala lanêêl vaa-ju banye be lohvu taakuu-ju pin. ");
INSERT INTO mmo_vpl VALUES ("MT9_32","070_9_32","MAT","9","32","32","+ o 9:32-33 Mat 12:22*Yuuh lala lak tonde hil lako omaaho ti mamu nipaya hôôvu tombe ka ma be lalaam vu Yesu. ");
INSERT INTO mmo_vpl VALUES ("MT9_33","070_9_33","MAT","9","33","33","+ o 9:33 Mak 2:12*Tombe Yesu hatiiy mamu nipayaa-ju hato la in omaaho sen ka maa-juuto tonde vakaas, tombe hil ngeeyaata lavindis lôôt, de lanêêl nambe, “Yame aahe vati nambêênjo vu Islel bôôy e.” ");
INSERT INTO mmo_vpl VALUES ("MT9_34","070_9_34","MAT","9","34","34","+ o 9:34 Mat 12:24; Mak 3:22; Luk 11:15*Lemu Palisai-so lanêêl nambe, “Mamu nipaya-te yêêv bop vu niwêêk vu yi ondeey natiiy mamu nipaya dala in omaahonôôn.” ");
INSERT INTO mmo_vpl VALUES ("MT9_35","070_9_35","MAT","9","35","35","+ o 9:35 Mat 4:23; Mak 1:39*Yesu la hatup hôôk taaku bop osin pasiv pin-ambe monawiing tanasin hôôk silate dumb ti ti. Nanêêl banye nivasa sen Anutu nanggin yite hil-ato langaah, de nawiing hil anilakin vaha vaha osin nipaling pin nind vasa nalak. ");
INSERT INTO mmo_vpl VALUES ("MT9_36","070_9_36","MAT","9","36","36","+ o 9:36 Mat 14:14; Nam 27:17; 1King 22:17; Esi 34:5; Sek 10:2; Mak 6:34*Yesu nayi hil ngeeyaataa-ju tombe ka pasiv in sil in nambe kand nala nge-ngeey, de dando paya lôôt nambe bik sipsip sen heendin lavuuh sil-ato, ");
INSERT INTO mmo_vpl VALUES ("MT9_37","070_9_37","MAT","9","37","37","+ o 9:37 Luk 10:2*tombe nêêl vu yite maanggêêm-aso nambe, “Vanôôn ngeeyaata nôôn ak hôôk kulaanôôn lung la, lemu kul vaha-so daka yuu-mu, ");
INSERT INTO mmo_vpl VALUES ("MT9_38","070_9_38","MAT","9","38","38","om ham kataangg kul mangganaan in biing kul vaha-so heey lana daasupin yite vanôôn gaving.” ");
INSERT INTO mmo_vpl VALUES ("MT10_1","070_10_1","MAT","10","1","1","+ o 10:1 Mak 6:7; Luk 9:1*Yesu teey yite maanggêêm nomaayuuh-ambe laam yuuh-ato lalaam-ambe vu niwêêk vu sil in nambe sil gatiiy mamu nipaya na in omaahonôôn, de lambiing hil anind lakin osin hil anind paling pin-ambe nind vasa jak. ");
INSERT INTO mmo_vpl VALUES ("MT10_2","070_10_2","MAT","10","2","2","De sinaale-so nomaayuuh-ambe laam yuuh haalend-anjo, omaaho sen munggin ond Simon, haale ango nambe Pita, de hali Endru, tonde Sebedi noow Jems ayuuh hali Jon, ");
INSERT INTO mmo_vpl VALUES ("MT10_3","070_10_3","MAT","10","3","3","tonde Pilip ayuuh Batolomai, de Tomas ayuuh Matai sen nako taakis-ato, tonde Alpias noow Jems, de Tadias, ");
INSERT INTO mmo_vpl VALUES ("MT10_4","070_10_4","MAT","10","4","4","tonde Simon ango sen naanjiihin hil Yuda in nambe gatiiy hil Lom lanaa-to, de Yudas Iskaliot sen taato Yesu langaah-ambe hil lalôôh-ato. ");
INSERT INTO mmo_vpl VALUES ("MT10_5","070_10_5","MAT","10","5","5","+ o 10:5 Sin 13:46*Yesu wiing hil nomaayuuh-ambe laam yuuh-anju lala kul, om nêêl tanasin vu sil nambe, “Ham-ame anoh hil vaalu sen sil-ame Yudaa-to silate mop e, de ham-ame andukana Samaalia-te taaku ti le, ");
INSERT INTO mmo_vpl VALUES ("MT10_6","070_10_6","MAT","10","6","6","+ o 10:6 Jer 50:6; Mat 15:24*ham oo ana vu hil Islel in sil lalohvu sipsip-ambe dala mend nama. ");
INSERT INTO mmo_vpl VALUES ("MT10_7","070_10_7","MAT","10","7","7","+ o 10:7 Mat 3:2; 4:17; Luk 10:9,11*Ham ana naanêêl langaah naambe, ‘Ngaaho lak in Anutu ganggin yite hil.’ ");
INSERT INTO mmo_vpl VALUES ("MT10_8","070_10_8","MAT","10","8","8","+ o 10:8 Sin 20:33*Ham ambiing hil anilakin nind vasa jak, de ham anjêêvu hil yimbin-ambe kandi jak, de ham ambiing hil anind payêês anipaya lôôt-ato nind vasa jak, osin ham gatiiy mamu nipaya lana in omaahonôôn. In saavu niwêêk vu ham-ato ond ham hako malis-ande vaanggosin ma, om yik ham ambiing kul jak malis amu vu hil, de ham-ame gako mone jak e. ");
INSERT INTO mmo_vpl VALUES ("MT10_9","070_10_9","MAT","10","9","9","+ o 10:9 Luk 10:4*De ham-ame gako mone gool osin siliva having mone noow dombaale hamate gis e, ");
INSERT INTO mmo_vpl VALUES ("MT10_10","070_10_10","MAT","10","10","10","+ o 10:10 Nam 18:31; Luk 10:7; 1Ko 9:14; 1Ti 5:18*de ham-ame ganja vaahes-ambe ham ana mop e, de ham-ame gako lolop yu-yuuh e, de ham-ame gako suul osin paatôôn e, jip, in kul sen ham ambiing vu hil-ato ond yoo neep vu sil in nambe landôôvu ham in vanôôn ayuuh ame. ");
INSERT INTO mmo_vpl VALUES ("MT10_11","070_10_11","MAT","10","11","11","“Ham andukana taaku bop ti, me bayêên pasiv ti, ond ham anjingin hil-anju naambe ti nivasa lohvu ganggin ham ond ham mando gaving yi nivalok-ambe na balup busin sen ham ana jak-ato. ");
INSERT INTO mmo_vpl VALUES ("MT10_12","070_10_12","MAT","10","12","12","+ o 10:12 Luk 10:5-6*Tonde ham andukana bayêên alo ond ham naanêêl vakasin anivasa vu hil-anju. ");
INSERT INTO mmo_vpl VALUES ("MT10_13","070_10_13","MAT","10","13","13","Naambe hil sen ham alakala vu sil-anju nind vasa, ond mem hamate vakasin melaas e na vu sil, le naambe sil-ame nind vasa le, ond hamate vakasin melaas e gilin-ambe nom vu ham. ");
INSERT INTO mmo_vpl VALUES ("MT10_14","070_10_14","MAT","10","14","14","+ o 10:14 Luk 10:10-12; Sin 13:51; 18:6*Naambe vaheey-ame gako ham jak e, de me-gango hamate vakasin e, ond ham gavuuh bayêên-anju me taakuu-ju, de ham tatehin kambus sen nando lak ham vaham-ato naah-ande ham ana. ");
INSERT INTO mmo_vpl VALUES ("MT10_15","070_10_15","MAT","10","15","15","+ o 10:15 Mat 11:24; Jen 18:20–19:28; 2Pi 2:6; Jut 7*Sa naanêêl keen vu ham naambe vu busin taamusin sen Anutu gangoyin omaahonôôn-ate vakasin-ato, ond hil vu taakuu-ju le daatovu nimeen bopaata kaluuh Sodom osin Gomola.” ");
INSERT INTO mmo_vpl VALUES ("MT10_16","070_10_16","MAT","10","16","16","+ o 10:16 Luk 10:3; Jon 10:12; Sin 20:29; Lom 16:19*“Ham gango, saambiing-ambe ham ana naambe sen bik sipsip-ato melaas in nambe ham andukana voow bamaan lavuun, om ham oo angge hamate mop nivasa naambe nyêêy, de ham ambiing va melaas naambe manak sen nawiing melaas-ato. ");
INSERT INTO mmo_vpl VALUES ("MT10_17","070_10_17","MAT","10","17","17","+ o 10:17 Mat 24:9*Om ham ganggin ham nivasa in hil, in sil e gako ham ana vu kaansol-aso be ham ambiing vakasin, de sil e gaveek ham dôôk silate dumb alo. ");
INSERT INTO mmo_vpl VALUES ("MT10_18","070_10_18","MAT","10","18","18","+ o 10:18 Sin 25:23; 27:24*De sil e gako ham ana baale hôôk yêêv bop osin omaaho lulemak-aso mend in sate hil ham, tombe ham e naanêêl sa banyengg langaah vu yêêv-asôônju, de vu hil vaalu sen sil-ame Yudaa-to gaving. ");
INSERT INTO mmo_vpl VALUES ("MT10_19","070_10_19","MAT","10","19","19","+ o 10:19-20 Luk 12:11-12*Om hil gako ham ana in ham ambiing vakasin, ond ham-ame naham jak naambe ham e ambiing vakasin naambe tana me ham e naanêêl vaati, malis, yik Anutu yoo le taato va sen ham naanêêl-ato hôôk busin tii-ju vu ham bulôôt. ");
INSERT INTO mmo_vpl VALUES ("MT10_20","070_10_20","MAT","10","20","20","+ o 10:20 Jon 14:26; 1Ko 2:4*Ham-ame yoo le naanêêl vakasin e, malis, nganjo Mom-ate Vavi Vaambuung e dôôvu ham in vakasin. ");
INSERT INTO mmo_vpl VALUES ("MT10_21","070_10_21","MAT","10","21","21","+ o 10:21 Mai 7:6; Mat 10:35*“Omaahonôôn e daanêêl halindin langaah, tombe lanyiis sil-ambe lanjimb, de yik maandin e lambiing naambêênju vu noondin. Tonde yik unoopasiv e lanji maandin ayuuh taandin paya be daanêêl sil langaah, tombe hil lanyiis sil-ambe lanjimb. ");
INSERT INTO mmo_vpl VALUES ("MT10_22","070_10_22","MAT","10","22","22","+ o 10:22 Mat 24:9,13; Jon 15:18-21*De omaahonôôn pin e nind baya lôôt in ham in sate hil ham, om ham baale niwêêk lôôt-ambe ham baaku nimeen pin, ond ham e ana mando metumin gaving Anutu. ");
INSERT INTO mmo_vpl VALUES ("MT10_23","070_10_23","MAT","10","23","23","+ o 10:23 Mat 16:28*De hil lambiing nindanjeen vu ham dôôk taaku ti, ond ham napakambe ham ana taaku ango. Sa naanêêl keen vu ham naambe ham-ame le anohvu Islel-ate taaku pin e, tonde Omaahonôôn Noow e nom. ");
INSERT INTO mmo_vpl VALUES ("MT10_24","070_10_24","MAT","10","24","24","+ o 10:24 Luk 6:40; Jon 13:16; 15:20*“Unoopasiv-ame savok yite kaputung e, de kul vaha me-savok yite yêêv e. ");
INSERT INTO mmo_vpl VALUES ("MT10_25","070_10_25","MAT","10","25","25","+ o 10:25 Mat 9:34; 12:24; Mak 3:22; Luk 11:15*Naambe unoopasiv mando naambe yite kaputung ond lung, de kul vaha mando naambe yite yêêv ond lohvu. Lanêêl mamu nipaya-te yêêv Belsebul lak bayêên danggakook sa, om yik le daanêêl yêêv anipaya heey jak sate hil gaving.” ");
INSERT INTO mmo_vpl VALUES ("MT10_26","070_10_26","MAT","10","26","26","+ o 10:26 Mak 4:22; Luk 8:17*“Om ham-ame anjêênin hil e, in vakasin p sen neep vunin-ato ond le naatok naam langaah, yik vakasin pin sen hil akand navu be neep hôôk londpayôô-to ond taamusin hil e lanjak ni pin. ");
INSERT INTO mmo_vpl VALUES ("MT10_27","070_10_27","MAT","10","27","27","Tanasin sen yiiy oo nando de sa naanêêl vu ham-ato ond ham naanêêl na langaah, yik vakasin sen ham oo nangoyin-ande sa naanêêl-ato ond ham ana baale talind-ambe ham naanêêl vu hil pin. ");
INSERT INTO mmo_vpl VALUES ("MT10_28","070_10_28","MAT","10","28","28","+ o 10:28 Jem 4:12*Ham-ame anjêênin omaahonôôn in nambe le lanyiis ham anim naavi jimb, in sil-ame lalohvu nambe lanyiis ham kanum e. Nganjo ham oo anjêênin Anutu in yoo lohvu nambe nyiis ham anim naavi osin ham kanum hôôk taaku nipaya. ");
INSERT INTO mmo_vpl VALUES ("MT10_29","070_10_29","MAT","10","29","29","Hil daanggo manak taapêêv daka yuuh lak mone noow timu, lemu manak pasiv pasiv-anjuuto ti me-le dupake malis e, nganjo hamate Mom sen nando baandonii-to jiinggis ond mem. ");
INSERT INTO mmo_vpl VALUES ("MT10_30","070_10_30","MAT","10","30","30","De ham ond sevin ham alumvalus pin lôôt lung la, ");
INSERT INTO mmo_vpl VALUES ("MT10_31","070_10_31","MAT","10","31","31","+ o 10:31 Mat 6:26; 12:12*om ham-ame anjêênin e, in ham atu Anutu-te va-so savok manak pasiv pasiv-anju pin.” ");
INSERT INTO mmo_vpl VALUES ("MT10_32","070_10_32","MAT","10","32","32","+ o 10:32 Taato 3:5*“Omaaho ti naanêêl sa haalengg langaah vu hil ond sale naanêêl omaaho tii-ju haale langaah vu Aamangg sen nando baandonii-to, ");
INSERT INTO mmo_vpl VALUES ("MT10_33","070_10_33","MAT","10","33","33","+ o 10:33 Mak 8:38; Luk 9:26; 2Ti 2:12*le naambe omaaho ti jak alu in sa vu hil ond sale anjak alungg in yi vu Aamangg sen nando baandonii-to.” ");
INSERT INTO mmo_vpl VALUES ("MT10_34","070_10_34","MAT","10","34","34","“Ham akam-ame bu naambe sa laam in aambu mamaal vu voon e. Same alaam in aambu mamaal e, malis, sa laam in ngaamong. ");
INSERT INTO mmo_vpl VALUES ("MT10_35","070_10_35","MAT","10","35","35","+ o 10:35 Mai 7:6*Sa laam atombe hil daasuh sil in sa, om noondin alondpayo le na ango, de maandin alondpayo le na ango, tonde nondinaavêêh alondpayo le na ango, de taandin alondpayo le na ango, tonde vêêh-aso londpayo le na ango, de yendinaavêêh alondpayo le na ango, ");
INSERT INTO mmo_vpl VALUES ("MT10_36","070_10_36","MAT","10","36","36","de hil sen dando lak bayêên timuu-to ond yoo le lanji sil paya lôôt. ");
INSERT INTO mmo_vpl VALUES ("MT10_37","070_10_37","MAT","10","37","37","+ o 10:37 Diu 33:9*“Omaaho ti ahe having mangganaan me tangganaan savok sa, ond me-lohvu nambe naatu sate hil e, de omaaho ti ahe having noow me nowaavêêh savok sa, ond me-lohvu nambe naatu sate hil e. ");
INSERT INTO mmo_vpl VALUES ("MT10_38","070_10_38","MAT","10","38","38","+ o 10:38-39 Mat 16:24-25; Mak 8:34-35; Luk 9:23-24; 17:33; Jon 12:25*De omaaho ti me-baaku yite haah pako be taamuyin sa le, ond me-lohvu nambe naatu sate omaaho le. ");
INSERT INTO mmo_vpl VALUES ("MT10_39","070_10_39","MAT","10","39","39","Omaaho ti yoo ganggin ninaavi nivasa in nambe mando metumin ond le jimb-ambe na menama, le naambe omaaho ti baaku nimeen ak sa haalengg-ambe jimb, ond mem le mando metumin danggata.” ");
INSERT INTO mmo_vpl VALUES ("MT10_40","070_10_40","MAT","10","40","40","+ o 10:40 Mak 9:37; Luk 10:16; Jon 13:20; Gal 4:14*“Omaaho ti gako ham jak ond lohvu hako sa lak, de hako sa lak ond lohvu hako omaaho sen wiing sa laam-ato lak. ");
INSERT INTO mmo_vpl VALUES ("MT10_41","070_10_41","MAT","10","41","41","Omaaho ti gako Anutu-te omaaho nanêêl yite vakasin-ato jak in dangga nambe nanêêl Anutu-te vakasin langaah, ond yuuh ahondoos e gako nyevahaan nivasa nanjip ti. Tonde naambe omaaho ti gako omaaho nivalok ti jak in dangga nambe yi omaaho nivalok-ato, ond yik yuuh ahondoos e gako nyevahaan nivasa nanjip ti. ");
INSERT INTO mmo_vpl VALUES ("MT10_42","070_10_42","MAT","10","42","42","+ o 10:42 Mat 25:40*De naambe omaaho ti bu bel kuuh vu sate hil malis ti be naanum in dangga nambe sate hil yi ti, ond sa naanêêl keenaanôôn vu ham naambe omaahôô-ju le gako yite samu samu nivasa nyevahaan dukanaah.” ");
INSERT INTO mmo_vpl VALUES ("MT11_1","070_11_1","MAT","11","1","1","Yesu wiing tanasin vu yite maanggêêm nomaayuuh-ambe laam yuuh-ato lung la, le mem kandi lak vuu-ju be la hatup hôôk bayêên bu ti ti vu taakuu-ju be nanêêl yite vakasin langaah, de navu tatekin tanasin vu sil. ");
INSERT INTO mmo_vpl VALUES ("MT11_2","070_11_2","MAT","11","2","2","+ o 11:2 Mat 14:3*Latung Jon sen nalipis hil-ato lukala kalaambus-ambe nando, tonde hangoyin kul sen Kalisi nawiing-ato banye, tombe wiing yite maanggêêm lala vu Yesu, ");
INSERT INTO mmo_vpl VALUES ("MT11_3","070_11_3","MAT","11","3","3","+ o 11:3 Mal 3:1; Mat 3:11; Jon 1:15*tombe lalingin yi nambe, “Mak hong omaaho sen Jon nêêl banye nambe le naam-ato, me hey mongganggin omaaho ango le?” ");
INSERT INTO mmo_vpl VALUES ("MT11_4","070_11_4","MAT","11","4","4","Le Yesu nêêl laah vu sil nambe, “Ham anaah gatulin va pin sen ham nago osin ham nahêê-to vu Jon, ");
INSERT INTO mmo_vpl VALUES ("MT11_5","070_11_5","MAT","11","5","5","+ o 11:5 Ais 35:5-6; 61:1*naambe hil amend kanu dayi taaku yesin laah, de vahand anipaya dala mop, de payêês anipaya lôôt anind vasa nalak, de hil nanyend katôônd dango taaku, tonde hil yimbin davu kandi lak, de hil anipaya paya dango banye nivasa. ");
INSERT INTO mmo_vpl VALUES ("MT11_6","070_11_6","MAT","11","6","6","+ o 11:6 Mat 13:57; 26:31*Tonde omaaho ti me-ka yu-yuuh in sa le ond le ka vasa.” ");
INSERT INTO mmo_vpl VALUES ("MT11_7","070_11_7","MAT","11","7","7","+ o 11:7 Mat 3:5*Jon-ate maanggêêm-aso dala lak tonde mem Yesu nêêl Jon langaah vu hil alu bopaataa-ju nambe, “Bôôy ham ala vu Jon vu taaku lumbalaamb in nambe ham angge vaati? Mak ham ala in angge omaaho sen lohvu vavi nayêêyak ngasing a? ");
INSERT INTO mmo_vpl VALUES ("MT11_8","070_11_8","MAT","11","8","8","Me ham ala in angge vaati? Mak ham ala in angge omaaho ti lop lolop anivasa vasa? Malis, hil sen dalop lolop anivasa vasa ond yoo dando lak lulemak-asote bayêên, ");
INSERT INTO mmo_vpl VALUES ("MT11_9","070_11_9","MAT","11","9","9","+ o 11:9 Luk 1:76*om ham ala in angge vaati? Ham ala in angge omaaho ti nanêêl Anutu-te vakasin langaah a? Êê-e, de sa naanêêl vu ham naambe omaahôô-ju savok hil sen danêêl Anutu-te vakasin langaah-ato la. ");
INSERT INTO mmo_vpl VALUES ("MT11_10","070_11_10","MAT","11","10","10","+ o 11:10 Mal 3:1; Mak 1:2; Jon 3:28*Jon-anju ond Anutu nêêl yite vakasin munggin-ambe neep hôôk kaapiya nambe, ‘Onggango le, sa navu aambiing sate omaaho ti na naamunggin vu hong in samu gate mop.’ ");
INSERT INTO mmo_vpl VALUES ("MT11_11","070_11_11","MAT","11","11","11","Sa naanêêl keen vu ham naambe Jon sen nalipis hil-ato ond savok hil pin sen taandin dako sil vu voon-anjôôto, lemu hil sen Anutu nanggin sil-ato vaalu haalend nipasiv lôôt, ond le savok Jon na. ");
INSERT INTO mmo_vpl VALUES ("MT11_12","070_11_12","MAT","11","12","12","+ o 11:12 Luk 16:16*“Vu bôôy sen Jon nalipis hil-ato be tok laam gêên-anjo ond Anutu nawiing va vaha vaha osin niwêêk in taato naambe navu ganggin yite hil-ato, tonde hil sen londpayo naanjiihin sil lôôt ond sil anindwêêk in nambe landukana gaving Anutu-te hil. ");
INSERT INTO mmo_vpl VALUES ("MT11_13","070_11_13","MAT","11","13","13","Mose-te tanasin osin hil sen danêêl Anutu-te vakasin langaah-ato pin-ambe la valup Jon ond lanêêl vakasin langaah lak sen Anutu le ganggin yite hil-ato, ");
INSERT INTO mmo_vpl VALUES ("MT11_14","070_11_14","MAT","11","14","14","+ o 11:14 Mal 4:5; Mat 17:10-13; Mak 9:11-13*om naambe ham awiingin nambe gangoyin ond ham gango naambe Jon-anju ond Eliya sen vakasin neep nambe le naam-ato. ");
INSERT INTO mmo_vpl VALUES ("MT11_15","070_11_15","MAT","11","15","15","Omaaho ti nanye neep ond gangoyin. ");
INSERT INTO mmo_vpl VALUES ("MT11_16","070_11_16","MAT","11","16","16","“Sale naanêêl ham hil sen gêên-anjo naambe va? Ham nambe unoopasiv sen dando talind-ambe davu teey la vu ango-so nambe, ");
INSERT INTO mmo_vpl VALUES ("MT11_17","070_11_17","MAT","11","17","17","‘Hey aawiing kombin in ham, lemu ham-ame nakôômb e, de hey aasu kangg paya paya le ma de ham-ame navu kaatuuh ham e.’ ");
INSERT INTO mmo_vpl VALUES ("MT11_18","070_11_18","MAT","11","18","18","+ o 11:18 Mat 3:4*In Jon laam atombe me-ya vanôôn anivasa de me-num wain e, tombe ham anêêl nambe, ‘Mamu nipaya nahôôvu yi.’ ");
INSERT INTO mmo_vpl VALUES ("MT11_19","070_11_19","MAT","11","19","19","+ o 11:19 Mat 9:14; Luk 15:1-2*De Omaahonôôn Noow laam-ambe ya osin num, tombe ham anêêl nambe, ‘Ham angge, omaaho aheta om yoo naya osin nanum wain ngeeyaata, om hil sen dako taakis-ato osin hil sen dawiing va nipayaa-to vaalu silate omaaho tii-ju.’ Lemu yaangge kul nôôn sen omaaho ti nawiing-ato ond mem yale anjak ni naambe omaaho osin ka.” ");
INSERT INTO mmo_vpl VALUES ("MT11_20","070_11_20","MAT","11","20","20","Vu taaku bop vaalu ond Yesu wiing taahu taahu osin niwêêk ngeeyaata, le hil-ame lahilin londpayo le, om Yesu nêêl sil nambe, ");
INSERT INTO mmo_vpl VALUES ("MT11_21","070_11_21","MAT","11","21","21","+ o 11:21 Jona 3:6*“Ham Kolasin, de ham Betsaida, ham e naatovu nimeen, in nambe saambiing taahu taahu osin niwêêk ngeeyaata vu Taia osin Saidon naambe sen saawiing vu hamate taakuu-to, ond bôôy hil Taia osin Saidon e gayêêh vaahes-ambe sil mando osin nind ngook in taato naambe londpayo nimeen om lahilin sil laah vu Anutu. ");
INSERT INTO mmo_vpl VALUES ("MT11_22","070_11_22","MAT","11","22","22","+ o 11:22 Ais 23; Esi 26:1–28:26; Joel 3:4-8; Emo 1:9-10; Sek 9:2-4*Om sa naanêêl vu ham naambe vu busin taamusin sen Anutu gangoyin omaahonôôn pin-ate vakasin-ato, ond ham e naatovu nimeen bopaata kaluuh Taia osin Saidon. ");
INSERT INTO mmo_vpl VALUES ("MT11_23","070_11_23","MAT","11","23","23","+ o 11:23 Ais 14:13-15; Jen 19:24-28; Jut 7*De ham Kapenaum-anja, hamambe ham e gako ham jakana baandoni? Malis, ham e andukana taaku nipaya, in nambe saambiing taahu taahu osin niwêêk ngeeyaata vu Sodom naambe sen saawiing vu hamate taakuu-to, ond Sodom yoo le mando be gêên-anjo. ");
INSERT INTO mmo_vpl VALUES ("MT11_24","070_11_24","MAT","11","24","24","+ o 11:24 Mat 10:15; Luk 10:12*Om sa naanêêl vu ham naambe vu busin taamusin sen Anutu gangoyin omaahonôôn pin-ate vakasin-ato ond ham e naatovu nimeen bopaata kaluuh Sodom.” ");
INSERT INTO mmo_vpl VALUES ("MT11_25","070_11_25","MAT","11","25","25","+ o 11:25 1Ko 1:26-29*Hôôk busin-anju Yesu lohak nambe, “O Aamangg, hong Omaaho Bop vu baandoni osin voon, sa naapêêlis vu hong, in gavun va pin-anjo in hil sen omaahonôôn dayi sil nambe hil osin kand bop de hil alukook bop, tonde otaato langaah vu hil mali-malis. ");
INSERT INTO mmo_vpl VALUES ("MT11_26","070_11_26","MAT","11","26","26","Keen Aamangg, in goo gahe nivasa ondeey gawiing nambêênja.” ");
INSERT INTO mmo_vpl VALUES ("MT11_27","070_11_27","MAT","11","27","27","+ o 11:27 Mat 28:18; Jon 3:35; 17:2; 1:18; 10:15; Pil 2:9*Yesu lohak lung atonde nêêl vu sil nambe, “Aamangg vu va pin lukala sa namangg lung la, de omaaho ti me-lak Noow ani le, Mangganaan timu yoo lak ni. De omaaho ti me-lak Mangganaan ani le, Noow oo lak ni, de hil sen Noow navu tatekin Mangganaan vu sil-ato, ond mem lalak Mangganaan ani having. ");
INSERT INTO mmo_vpl VALUES ("MT11_28","070_11_28","MAT","11","28","28","+ o 11:28 Jer 31:25*“Ham pin sen ham sakem ma laa-to, osin ham sen va nimeen nanjingin ham-ato, ond ham pin anaam vu sa tombe mem saambu sawaasin vu ham. ");
INSERT INTO mmo_vpl VALUES ("MT11_29","070_11_29","MAT","11","29","29","+ o 11:29 Jer 6:16*Ham naatu sate hil kul vaha-so be ham gako kakook vu sa, in sa omaaho melaas, de sa longgpayo me-natee yi lak e, ond mem hamate nôôn e naatovu yite sawaasin, ");
INSERT INTO mmo_vpl VALUES ("MT11_30","070_11_30","MAT","11","30","30","+ o 11:30 1; Jon 5:3*in tanasin sen saambu vu ham-ato ond nivasa, de kul sen saambu vu ham in ham baakuu-to ond ahelavis.” ");
INSERT INTO mmo_vpl VALUES ("MT12_1","070_12_1","MAT","12","1","1","+ o 12:1 Diu 23:25*Hôôk busin-anju ond busin sawaasin ti, tombe Yesu having yite maanggêêm-aso be laloh mop sen neep hôôk kul lavuun-ato be lala, tombe yite maanggêêm-aso layimb ahend om sil kalêêh wit nôôn-ambe landaah Diuteronomi 23:25* nambe omaaho ti-te kul neep vu mop nanyendangga, tombe hil daloh mop-ambe dayimb ahend, ond sil kalêêh omaahôô-ju yite wit nôôn daka nanjip mop nanyendangga be sil gandaah-ande vakasin ma. Nganjo yêêv-aso danêêl nambe dôôk busin sawaasin ond hil-ame kalêêh wit nôôn daka be gandaah e, in danêêlin va pin nambe hil-ame lambiing kul pasivdaka dôôk busin sawaasin e, malis lôôt. Le Yesu nêêl Devit-ate vakasin laah vu Palisai-so in nambe bêêl sil alund jak, in sil sahi nambe Devit yimb ahe be ya vanôôn om lung, tonde Yesu-te maanggêêm-aso ond me-kand pasiv in sil e. . ");
INSERT INTO mmo_vpl VALUES ("MT12_2","070_12_2","MAT","12","2","2","+ o 12:2 Eks 20:10*Tombe Palisai layi be lanêêl vu nambe, “Gangge, gate maanggêêm-aso davu kalêêh wit nôôn, le me-lohvu nambe yaambiing kul hôôk busin sawaasin e.” ");
INSERT INTO mmo_vpl VALUES ("MT12_3","070_12_3","MAT","12","3","3","+ o 12:3 1Sml 21:1-6*Tombe Yesu nêêl vu sil nambe, “Vu bôôy Devit having yite hil sen laving yii-to ond layimb ahend tombe wiing vaati? Mak ham-ame asevin mava? ");
INSERT INTO mmo_vpl VALUES ("MT12_4","070_12_4","MAT","12","4","4","+ o 12:4 Lev 24:5-9*Nambe Devit lukala Anutu-te dumb alo tombe sil o yite maanggêêm-aso laya vanôôn sen hil latung vu Anutuu-to, ond vanôôn-anju me-lohvu nambe Devit-aso yite hil lanja le, nganjo kul vaha sen datung salivangin-ato yoo lanja. ");
INSERT INTO mmo_vpl VALUES ("MT12_5","070_12_5","MAT","12","5","5","+ o 12:5 Nam 28:9-10*De vakasin sen neep hôôk Mose-te tanasin nambe kul vaha sen datung salivangin-ato silate kul neep hôôk Anutu-te dumb bop alo, ond mak ham-ame asevin vakasin-anju mava? Tombe dawiing kul dumb-anju hôôk busin sawaasin, ond davu kalêêh tanasin sen nêêl nambe yame aambiing kul hôôk busin sawaasin e, lemu nipaya me-neep vu sil e, ");
INSERT INTO mmo_vpl VALUES ("MT12_6","070_12_6","MAT","12","6","6","+ o 12:6 Mat 12:41-42; Luk 11:31-32*om sa naanêêl vu ham naambe saa-jo sa savok Anutu-te dumb bop. ");
INSERT INTO mmo_vpl VALUES ("MT12_7","070_12_7","MAT","12","7","7","+ o 12:7 Hos 6:6; Mat 9:13*De naambe ham anjak Anutu-te vakasin-anjo danggakook ani naambe, ‘Same aawiingin salivangin e, nganjo sahengg having nambe ham akam pasiv in omaahonôôn-ambe ham andôôvu sil.’ Ke, ham akam bu vakasin-anjo nivasa ond mem ham-ame le naanêêl hil sen silanêênd nipaya maa-to naambe sil lawiing nipaya le, malis. ");
INSERT INTO mmo_vpl VALUES ("MT12_8","070_12_8","MAT","12","8","8","In Omaahonôôn Noow tu busin sawaasin-ate danggakook.” ");
INSERT INTO mmo_vpl VALUES ("MT12_9","070_12_9","MAT","12","9","9","Tonde Yesu vuu-ju be la lukala silate dumb alo, ");
INSERT INTO mmo_vpl VALUES ("MT12_10","070_12_10","MAT","12","10","10","+ o 12:10 Luk 14:3*tombe omaaho ti nama vaalu nipaya nandôô-ju, ond omaaheey lawiingin nambe lambiing vakasin vu Yesu om lalingin yi nambe, “Mak lohvu nambe yaambiing hil anilakin nind vasa jak dôôk busin sawaasin me malis?” ");
INSERT INTO mmo_vpl VALUES ("MT12_11","070_12_11","MAT","12","11","11","+ o 12:11 Luk 14:5*Le Yesu nêêl vu sil nambe, “De ham ti-te bik sipsip ti duus sov dôôk busin sawaasin, ond le biing naambe va? Yik le na daandiiy jakanom. ");
INSERT INTO mmo_vpl VALUES ("MT12_12","070_12_12","MAT","12","12","12","+ o 12:12 Mat 10:31*De omaahonôôn savok sipsip, om lohvu nambe yaambiing va nivasa dôôk busin sawaasin.” ");
INSERT INTO mmo_vpl VALUES ("MT12_13","070_12_13","MAT","12","13","13","Tombe nêêl vu omaaho nama nipayaa-to nambe, “Otalo namam.” Om talo nama, tombe nama nivasa lak nambe sen nama vaaluu-to. ");
INSERT INTO mmo_vpl VALUES ("MT12_14","070_12_14","MAT","12","14","14","+ o 12:14 Jon 5:16*Le ma de hil Palisai lala lasupin-ambe sil salo mopaatôôv in nambe lanyiis Yesu be jimb. ");
INSERT INTO mmo_vpl VALUES ("MT12_15","070_12_15","MAT","12","15","15","+ o 12:15 Mak 3:7-10*Yesu lak ni nambe davu salo mopaatôôv in nambe lanyiis yi om havuuh taakuu-ju de la, tombe hil ngeeyaata taamuyin yi, tombe wiing hil anilakin pin nind vasa lak. ");
INSERT INTO mmo_vpl VALUES ("MT12_16","070_12_16","MAT","12","16","16","+ o 12:16 Mat 8:4; Mak 3:12*Tonde Yesu vu kôôvu sil nambe me-daanêêl yi langaah e, ");
INSERT INTO mmo_vpl VALUES ("MT12_17","070_12_17","MAT","12","17","17","om Anutu-te vakasin sen Yesaia nêêl langaah bôôy-ato nôôn ak nambe, ");
INSERT INTO mmo_vpl VALUES ("MT12_18","070_12_18","MAT","12","18","18","+ o 12:18 Mat 3:17* + o 12:18-21 Ais 42:1-4*“Ham angge sate kul vaha, saaholin yi lung la tombe sahengg having yi lôôt, be sa longg anivasa vu yi. Sale gatung sate Vavi Vaambuung jakana yi, tombe le naanêêl sate vakasin keen vu hil vaalu sen sil-ame Yudaa-to le. ");
INSERT INTO mmo_vpl VALUES ("MT12_19","070_12_19","MAT","12","19","19","Tonde me-le mahôôh omaahonôôn in vakasin e, de me-le napaak e, tonde hil-ame le gango lava vu talind e. ");
INSERT INTO mmo_vpl VALUES ("MT12_20","070_12_20","MAT","12","20","20","Omaahonôôn vaalu lalohvu ganggwak sen daka kalêêh-ambe neep hôôk-ato, de sate kul vahaa-ju me-le kalêêh na lôôt e. Tonde vaalu lalohvu lam sen naahen natum paya payaa-to de me-le naapuv e, yoo le mando monambiing kul lôôt-ambe vakasin anivalok nôôn jak-ambe kaluuh va nipaya pin jung na le, ");
INSERT INTO mmo_vpl VALUES ("MT12_21","070_12_21","MAT","12","21","21","de hil vaalu sen sil-ame Yudaa-to ond le lambiing gaving haale be mongganggin yi.” ");
INSERT INTO mmo_vpl VALUES ("MT12_22","070_12_22","MAT","12","22","22","+ o 12:22 Mat 9:32-33*Tombe lako omaaho ti la vu Yesu ond omaahôô-ju mamu nipaya hôôvu tombe mekanu osin ka ma. Tombe Yesu wiing-ambe nivasa lak, tombe ka ma vakaas-ande me tum having. ");
INSERT INTO mmo_vpl VALUES ("MT12_23","070_12_23","MAT","12","23","23","Tombe hil ngeeyaataa-ju pin lavindis lôôt de lanêêl nambe, “Mak omaaho sen le naam vu danggakook Devit-ato ond yii-ju?” ");
INSERT INTO mmo_vpl VALUES ("MT12_24","070_12_24","MAT","12","24","24","+ o 12:24 Mat 9:34; 10:25*Le Palisai-so lango tombe lanêêl nambe, “Mamu nipaya-te yêêv Belsebul vu niwêêk vu yi, ondeey natiiy mamu dala in omaahonôôn.” ");
INSERT INTO mmo_vpl VALUES ("MT12_25","070_12_25","MAT","12","25","25","Lemu vakasin sen sil akand navuu-ju ond Yesu lak ni pin-ambe nêêl vu sil nambe, “Om naambe hil taaku bop ti yoo lanyiis sil-ambe baasuh sil na lu yuuh, ond sil-ame lalohvu nambe mando nivasa le. De naambe hil bayêên bop ti me hil dangga ti sen dando hôôk bayêên timu yoo lanyiis sil-ambe baasuh sil na lu yuuh, ond sil-ame le mando nivasa le. ");
INSERT INTO mmo_vpl VALUES ("MT12_26","070_12_26","MAT","12","26","26","De naambe Saalang gatiiy yite kul vaha mamu nipaya-so ond sil o Saalang-aso yoo laasuh sil la lu yuuh, tombe sil e mando javuh ti naambe tana? Malis. ");
INSERT INTO mmo_vpl VALUES ("MT12_27","070_12_27","MAT","12","27","27","Ham nanêêl nambe Belsebul navu niwêêk vu sa be sa natiiy mamu nipaya dala in omaahonôôn, ond lati navu niwêêk vu hamate hil vaalu be datiiy mamu nipaya dala in omaahonôôn? Yik Anutu timu, om hamate hil-anju le daanêêl vu ham naambe ham oo nakaas paya. ");
INSERT INTO mmo_vpl VALUES ("MT12_28","070_12_28","MAT","12","28","28","+ o 12:28 Sin 10:38; 1Jon 3:8*Om sen Anutu-te Vavi Vaambuung hôôvu sa be sa natiiy mamu nipaya dala in omaahonôôn, om ham anjak ni naambe Anutu laam nanggin yite hil hôôk ham lavuun gêên-anjo. ");
INSERT INTO mmo_vpl VALUES ("MT12_29","070_12_29","MAT","12","29","29","+ o 12:29 Ais 49:24; 1Jon 4:4*“Omaaho ti me-lohvu nambe jakana omaaho nipaya niwêêk ambaan-ambe bu vêêl yite va le. Biing naambêênjo ond naanduuh yi tatin e mem gako yinêên va pin sen lukando bayêên alôô-to be na. ");
INSERT INTO mmo_vpl VALUES ("MT12_30","070_12_30","MAT","12","30","30","+ o 12:30 Mak 9:40; Luk 9:50*“Omaaho ti nambe same sate omaaho yi le ond nayiis ngaamong vu sa, yik omaaho ti me-nasupin omaahonôôn having sa le, ond natiiy sil-ambe davuuh taale. ");
INSERT INTO mmo_vpl VALUES ("MT12_31","070_12_31","MAT","12","31","31","+ o 12:31 1Ti 1:13; Hiblu 6:4-6; 10:26*Om sa naanêêl vu ham naambe va nipaya osin vakasin palesin pin sen omaahonôôn danêêl-ato ond Anutu lohvu nambe kawiiy na pin, nganjo vakasin palesin sen danêêl lak Vavi Vaambuung-ato, ond Anutu me-le kawiiy na le. ");
INSERT INTO mmo_vpl VALUES ("MT12_32","070_12_32","MAT","12","32","32","Ti naanêêl vakasin anipaya jak Omaahonôôn Noow, ond Anutu le kawiiy yite nipayaa-ju na, le naambe ti naanêêl vakasin anipaya jak Vavi Vaambuung, ond Anutu me-le kawiiy yite nipayaa-ju na le, le nama vu gêên-anjo be vu busin taamusin gaving.” ");
INSERT INTO mmo_vpl VALUES ("MT12_33","070_12_33","MAT","12","33","33","+ o 12:33 Mat 7:16-20*“Haah ti nivasa ond le nyiis nôôn anivasa, le haah anipaya lak ond le nyiis nôôn anipaya, in yiiy naahe hahaanôôn-ambe yalak ni nambe haah anivasa me nipaya. ");
INSERT INTO mmo_vpl VALUES ("MT12_34","070_12_34","MAT","12","34","34","+ o 12:34 Mat 3:7; 15:18; 23:33; Luk 3:7*Nyêêy noondin-aso ham, ham anipaya om ham alohvu nambe naanêêl vakasin anivasa naambe vaati? Malis. Va sen pup hôôk ham alompayo ond sen ham nanêêl laam langaah. ");
INSERT INTO mmo_vpl VALUES ("MT12_35","070_12_35","MAT","12","35","35","Omaaho nivasa ond ka navu va nivasa ngeeyaata naale hôôk lopayo ondeey nanêêl vakasin anivasa, de omaaho nipaya ond ka navu va nipaya ngeeyaata naale hôôk lopayo ondeey nanêêl vakasin anipaya. ");
INSERT INTO mmo_vpl VALUES ("MT12_36","070_12_36","MAT","12","36","36","Lemu sa naanêêl vu ham naambe vakasin anindanjeen pin sen hil danêêl-ato, ond Anutu le jingin sil dôôk busin taamusin sen gangoyin omaahonôôn-ate vakasin-ato. ");
INSERT INTO mmo_vpl VALUES ("MT12_37","070_12_37","MAT","12","37","37","Olavam anivasa ond le taato naambe hong omaaho nivalok, le naambe olavam anipaya ond gale naatokak nipaya nyevahaan.” ");
INSERT INTO mmo_vpl VALUES ("MT12_38","070_12_38","MAT","12","38","38","+ o 12:38 Mat 16:1; Luk 11:16; Jon 6:30; 1Ko 1:22*Yesu nêêl lung la tonde tanasin dangga heey osin Palisai-so lanêêl vu nambe, “Kaputung, gambiing taahu taahu niwêêk-ate be hey aangge mengg ak.” ");
INSERT INTO mmo_vpl VALUES ("MT12_39","070_12_39","MAT","12","39","39","+ o 12:39 Mat 16:4*Le nêêl laah vu sil nambe, “Ham hil anipaya sen gêên-anjo, ond ham-ame awii-having e, ondeey ham awiingin nambe ham angge taahu taahu ti, lemu same le aambiing taahu taahu vu ham e, nganjo ham akam bu Yona-te taahu taahu mu. ");
INSERT INTO mmo_vpl VALUES ("MT12_40","070_12_40","MAT","12","40","40","+ o 12:40 Jona 1:17*In bôôy Yona nando hôôk paahuung bopaata lopayo lohvu langaah yaal-ande busin yaal, tonde yik Omaahonôôn Noow e nanjip hôôk ngaanggis alopayo nohvu langaah yaal-ande busin yaal. ");
INSERT INTO mmo_vpl VALUES ("MT12_41","070_12_41","MAT","12","41","41","+ o 12:41 Jona 3:5*Om vu busin taamusin sen Anutu gangoyin omaahonôôn-ate vakasin-ato ond moow Ninive le baale be daanêêl vakasin jak ham sen gêên-anjo naambe hamate nipaya neep, in hil Ninive lango vakasin sen Yona nêêl-ato be lahilin londpayo. Nganjo sa sen sa nando naanêêl vakasin vu ham-anjo ond sa savok Yona la, le ham-ame nahilin ham alompayo le. ");
INSERT INTO mmo_vpl VALUES ("MT12_42","070_12_42","MAT","12","42","42","+ o 12:42 Mat 12:6; 1King 10:1-10*Vu busin taamusin sen Anutu gangoyin omaahonôôn-ate vakasin-ato ond vêêh lulemak Seba le kandi baale be naanêêl vakasin jak ham sen gêên-anjo naambe hamate nipaya neep. In vêêh lulemak-anju vu taaku danggakook-ambe laam in nambe gango Solomon-ate vakasin nivasa osin ka, lemu sa sen gêên sa nandôô-jo ond sa savok Solomon la, le ma de ham-ame nangoyin sa lavangg e.” ");
INSERT INTO mmo_vpl VALUES ("MT12_43","070_12_43","MAT","12","43","43","“Mamu nipaya nambe gato na in omaaho ti de yoo monana taaku lumbalaamb in naatovu taaku vuuti in nambe sawaah yi dôôk, le me-naatovu le, ");
INSERT INTO mmo_vpl VALUES ("MT12_44","070_12_44","MAT","12","44","44","ond le naanêêl naambe, ‘Mam sa naah sa baangg sen sa nando hôôk bôôy-ambe sa laam-ato.’ Tombe laah valup e yi de lasêêh bayêên-anju be lavunak lung la, le nando malis. ");
INSERT INTO mmo_vpl VALUES ("MT12_45","070_12_45","MAT","12","45","45","+ o 12:45 2Pi 2:20*Yi lung la tonde laah hako mamu namaavaalu be vindak yuuh sen silate nipaya savok yii-to, le mem lalom-ambe lalukala dando hôôk bayêên-anjuuto. Bôôy ond omaaho sen mamu nahôôvuu-ju nando paya, lemu gêên le mando nipaya valok-ate lôôt. Tonde yik va nipaya ngeeyaata le naatovu ham hil anipaya sen gêên-anjo naambêênja.” ");
INSERT INTO mmo_vpl VALUES ("MT12_46","070_12_46","MAT","12","46","46","+ o 12:46 Mat 13:55*Yesu naahen nanêêl vakasin vu hil ngeeyaataa-ju tonde tangganaan osin halindin lato daale voon in nambe bakaas gaving yi, ");
INSERT INTO mmo_vpl VALUES ("MT12_47","070_12_47","MAT","12","47","47","tombe omaaho ti nêêl vu nambe, “Angge, tam having halim-aso be lato daale voon in nambe bakaas vu hong.” ");
INSERT INTO mmo_vpl VALUES ("MT12_48","070_12_48","MAT","12","48","48","Le Yesu nêêl laah vu omaaho tii-ju nambe, “Ataak lati? De halingg-aso laheey?” ");
INSERT INTO mmo_vpl VALUES ("MT12_49","070_12_49","MAT","12","49","49","Tonde taato yite maanggêêm-aso lak nama de nêêl nambe, “Ham angge, ataak-aso halingg-aso sen manyinjo. ");
INSERT INTO mmo_vpl VALUES ("MT12_50","070_12_50","MAT","12","50","50","+ o 12:50 Jon 15:14; Lom 8:29*In hil dawiing va lohvu Mangg sen nando baandonii-to ka, ond mem sa halingg osin sa vangaangg-ambe sa ataak-aso sil.” ");
INSERT INTO mmo_vpl VALUES ("MT13_1","070_13_1","MAT","13","1","1","Hôôk busin-anju Yesu vu bayêên alo be hato la voon, tombe la nando betum nanyendangga, ");
INSERT INTO mmo_vpl VALUES ("MT13_2","070_13_2","MAT","13","2","2","+ o 13:2 Luk 5:1-3*le mem hil ngeeyaata lasupin lala vu yi om lakala nando kaanu ti, de hil pin daale lonak, ");
INSERT INTO mmo_vpl VALUES ("MT13_3","070_13_3","MAT","13","3","3","tonde mem nêêl vakasin pakwesin ngeeyaata vu sil. Nêêl ti nambe, “Ham gango, omaaho ti la in nambe baalil yite vave dukana kul moos. ");
INSERT INTO mmo_vpl VALUES ("MT13_4","070_13_4","MAT","13","4","4","Monaalil atombe vaalu tok nando mop, tombe manak lalaam-ambe laya lôôt. ");
INSERT INTO mmo_vpl VALUES ("MT13_5","070_13_5","MAT","13","5","5","De vaalu tok lakando ngaanggis pasivdaka sen lakando tatuuh baandonii-to, tombe sen ngaanggis pasivdaka muu-to om me valup pavis, ");
INSERT INTO mmo_vpl VALUES ("MT13_6","070_13_6","MAT","13","6","6","lemu taaku vavak ak-ambe malan pavis, tombe bambôôv valok-ate, in kangga me-lukala le. ");
INSERT INTO mmo_vpl VALUES ("MT13_7","070_13_7","MAT","13","7","7","De vaalu lokala ganggwak dangga tombe ganggwak valup having be yêês, om me-yiis nôôn e. ");
INSERT INTO mmo_vpl VALUES ("MT13_8","070_13_8","MAT","13","8","8","Tonde vaalu lokala ngaanggis anivasa ond valup-ambe yiis nôôn. Heey yiis nôôn doo-namaavaalu, de heey yiis nôôn doo-yaal, de heey yiis doo-ti be nomaayuuh. ");
INSERT INTO mmo_vpl VALUES ("MT13_9","070_13_9","MAT","13","9","9","Ke, omaaho ti nambe nanye neep ond gangoyin.” ");
INSERT INTO mmo_vpl VALUES ("MT13_10","070_13_10","MAT","13","10","10","Tombe maanggêêm-aso lala lalingin Yesu nambe, “Nambe vaati sen onanêêl vakasin pakwesin vu sil?” ");
INSERT INTO mmo_vpl VALUES ("MT13_11","070_13_11","MAT","13","11","11","+ o 13:11 1Ko 4:1*Le nêêl laah vu sil nambe, “Ham ond mem Anutu nanêêl vakasin sen vun yii-to langaah vu ham lak sen Anutu nanggin yiiy-ato, le me-nanêêl langaah vu hil-anju le. ");
INSERT INTO mmo_vpl VALUES ("MT13_12","070_13_12","MAT","13","12","12","+ o 13:12 Mat 25:29; Mak 4:25; Luk 8:18; 19:26*Naambe omaaho ti ka navu vakasin nivasa, ond Anutu le bu ka vaalu gaving-ambe jak ni lôôt. Le naambe omaaho ti doosin vakasin, de me-ka navu vakasin ti le, ond kakook daka sen neep vu yii-to ond Anutu le nôôh vêêl. ");
INSERT INTO mmo_vpl VALUES ("MT13_13","070_13_13","MAT","13","13","13","+ o 13:13 Diu 29:4*Sa naanêêl vakasin pakwesin vu sil-anju in dangga nambe sil dayi va lemu me-dalak ni le, de nanyend nango taaku lemu me-dango be datokak dangga le. ");
INSERT INTO mmo_vpl VALUES ("MT13_14","070_13_14","MAT","13","14","14","+ o 13:14-15 Ais 6:9-10; Jon 12:40; Sin 28:26-27*Om Anutu-te vakasin sen Yesaia nêêl langaah bôôy-ato nôôn ak lak sil nambe, ‘Ham e gango lôôt, lemu ham-ame le naatokak dangga le. Ham e angge lôôt, le ham-ame le anjak ni le. ");
INSERT INTO mmo_vpl VALUES ("MT13_15","070_13_15","MAT","13","15","15","In hil-anju londpayo niwêêk ak osin nanyend doos ak, de sil amend yip in nind baya nambe me-lanji va jak mend e, de me-gango vakasin e, de kand-ame bu vakasin danggakook e, de sil-ame langgilin londpayo nom vu sa in nambe saambiing-ambe nind vasa jak e.’ ");
INSERT INTO mmo_vpl VALUES ("MT13_16","070_13_16","MAT","13","16","16","+ o 13:16 Luk 10:23-24*“Nganjo ham ond ham akam vasa in ham amem nayi va, de ham nanyem nango vakasin. ");
INSERT INTO mmo_vpl VALUES ("MT13_17","070_13_17","MAT","13","17","17","Sa naanêêl keen vu ham naambe bôôy hil sen danêêl Anutu-te vakasin langaah osin hil anivalok ngeeyaata datung mend in nambe lanji va sen ham nahêê-jo, le ma de me-layi le, de dambe nanyend in nambe gango vakasin sen ham nangôô-jo, le ma de me-lango le.” ");
INSERT INTO mmo_vpl VALUES ("MT13_18","070_13_18","MAT","13","18","18","“Om ham gango vakasin pakwesin danggakook jak omaaho sen vaalil vavêê-to le. ");
INSERT INTO mmo_vpl VALUES ("MT13_19","070_13_19","MAT","13","19","19","Hil pin sen dango vakasin nambe Anutu nanggin yite hil-ato le me-datokak dangga le, ond sil lalohvu vave sen tok nando mop-ato, tonde Omaaho Nipaya la navu sapos vakasin sen Anutu vaalôôh lokala sil alondpayôô-to. ");
INSERT INTO mmo_vpl VALUES ("MT13_20","070_13_20","MAT","13","20","20","Tonde vave vaalu sen tok lakando ngaanggis daka lakando tatuuh baandonii-to ond lohvu hil sen dangoyin vakasin-ambe dako lak pavis-ambe dapêêlis, ");
INSERT INTO mmo_vpl VALUES ("MT13_21","070_13_21","MAT","13","21","21","lemu lalohvu va sen kangga me-lukala le, om dando daka vêêl e mem va nimeen natokak sil, me omaaheey dawiing nindanjeen vu sil in davu sapa Anutu-te vakasin, tombe sim nind baya be davuuh Anutu la pavis. ");
INSERT INTO mmo_vpl VALUES ("MT13_22","070_13_22","MAT","13","22","22","+ o 13:22 Mat 6:19-34; Luk 12:16-21; 1Ti 6:9-10,17*De vave vaalu tok lokala ganggwak danggaa-to ond lohvu hil sen dango Anutu-te vakasin, lemu sil alondpayo nimeen in kand navu va voon-ate osin mend nôôn in kupak ayuuh mone bop, tombe sil akand oo navu va nambêênjo natu bopaata nahilin Anutu-te vakasin, om me-le nôôn jak vu sil e. ");
INSERT INTO mmo_vpl VALUES ("MT13_23","070_13_23","MAT","13","23","23","Tonde vave vaalu sentok lukala ngaanggis anivasaa-to ond lohvu hil vaalu sen dango vakasin-ambe dawii-having tombe dayiis nôôn lohvu vave nayiis nôôn-ato. Vaalu dayiis nôôn ngeeyaata lôôt lohvu vave vaalu nayiis nôôn 100, de vaalu dayiis nôôn ngeey daka lohvu vave vaalu nayiis nôôn 60, de vaalu dayiis pasivdaka lohvu vave vaalu nayiis nôôn 30.” ");
INSERT INTO mmo_vpl VALUES ("MT13_24","070_13_24","MAT","13","24","24","Yesu nêêl vakasin pakwesin ango having vu sil nambe, “Anutu nanggin yite hil ond lohvu omaaho ti vaalil vave nivasa hôôk yite kul, ");
INSERT INTO mmo_vpl VALUES ("MT13_25","070_13_25","MAT","13","25","25","tombe hil deep busin-ande omaaho sen nayi yi payaa-to valup-ambe vaalil taavêêt anipaya nôôn yêês vave nivasa baandoni de lom-ambe la. ");
INSERT INTO mmo_vpl VALUES ("MT13_26","070_13_26","MAT","13","26","26","Tombe vanôôn nôôn ak lôôt-ambe wiingin nambe nyiis nôôn, le sim layi taavêêt anipaya valup having, ");
INSERT INTO mmo_vpl VALUES ("MT13_27","070_13_27","MAT","13","27","27","tombe yite kul vaha-so lala vu kul mangganaan-ambe lanêêl vu nambe, ‘Himbop, ovaalil vave nivasa hôôk gate kul, tonde taavêêt sen valup hôôk-anju vu tana?’ ");
INSERT INTO mmo_vpl VALUES ("MT13_28","070_13_28","MAT","13","28","28","Tombe nêêl vu sil nambe, ‘Omaaho sen nayi sa payaa-to wiing vaa-ja.’ Tombe kul vaha-so lalingin yi nambe, ‘Om hey ana bapuuh taavêêt-anju na?’ ");
INSERT INTO mmo_vpl VALUES ("MT13_29","070_13_29","MAT","13","29","29","Le nêêl vu sil nambe, ‘Ôôye, ham e bapuuh atombe ham bapuuh vanôôn gaving, ");
INSERT INTO mmo_vpl VALUES ("MT13_30","070_13_30","MAT","13","30","30","+ o 13:30 Mat 3:12*om ham baale de yuuh ahosin balup-ambe lanjak hôôk ti, de busin sen hil daasupin vanôôn e mem. Sale naanêêl vu hil sen daasupin vanôôn-ato naambe sil bapuuh taavêêt anipaya naamunggin-ambe lambaav, le mem daasupin vanôôn nôôn jakana sate bayêên vanôôn-ate.’” ");
INSERT INTO mmo_vpl VALUES ("MT13_31","070_13_31","MAT","13","31","31","Tonde Yesu nêêl vakasin pakwesin ango vu sil nambe, “Anutu nanggin yite hil-ato ond lohvu môônd nôôvoow sen tok-ambe valup, tombe omaaho ti hako be la vaalôôh-ato. ");
INSERT INTO mmo_vpl VALUES ("MT13_32","070_13_32","MAT","13","32","32","Môônd nôôvoow-anju nipasiv lôôt, de me-bop nambe haah vaalu nôôn e, lemu taamusin valup-ambe kaluuh haah pasi-pasiv pin la de tu haah bopaata lak, tombe manak dahaav vunis-ambe dando lak nama.” ");
INSERT INTO mmo_vpl VALUES ("MT13_33","070_13_33","MAT","13","33","33","Tonde yik nêêl vakasin pakwesin ango vu sil nambe, “Anutu nanggin yite hil-ato ond lohvu va sen datung lukala balet-ambe nalinj-ato, danêêl nambe yis. Ond vêêh ti hako yis-anju be monanggingg having balet hôôk kaambum bopaata, tombe yis la hanggwang balet alopayo lôôt atombe linj.” ");
INSERT INTO mmo_vpl VALUES ("MT13_34","070_13_34","MAT","13","34","34","Yesu nêêl vakasin pakwesin pin-anju ond me-nêêl ti langaah e, yik yoo nêêl tu vakasin pakwesin amu vu hil alu bopaataa-ju, ");
INSERT INTO mmo_vpl VALUES ("MT13_35","070_13_35","MAT","13","35","35","+ o 13:35 Saam 78:2*om Anutu-te vakasin sen omaaho ti nêêl langaah bôôy-ato nôôn ak nambe, “Sale naanêêl vakasin naatu vakasin pakwesin vu sil, de vakasin heey neep vunin vu bôôy sen Anutu hatung ngaanggis osin yendak-ato be tok laam gêên-anjo ond sale naanêêl langaah.” ");
INSERT INTO mmo_vpl VALUES ("MT13_36","070_13_36","MAT","13","36","36","Yesu nêêl lung la tonde havuuh hil ngeeyaataa-ju de lukala bayêên alo, tombe yite maanggêêm-aso lala vu yi be lanêêl nambe, “Otatekin vakasin pakwesin lak taavêêt anipaya sen valup hôôk kul-ato dangga vu hey e.” ");
INSERT INTO mmo_vpl VALUES ("MT13_37","070_13_37","MAT","13","37","37","Tombe Yesu nêêl laah vu sil nambe, “Omaaho ti vaalil vave nivasa ond Omaahonôôn Noow, ");
INSERT INTO mmo_vpl VALUES ("MT13_38","070_13_38","MAT","13","38","38","+ o 13:38 1Ko 3:9; 1Jon 3:10*de kul ond taaku voon-anjo pin, de vave nivasa ond hil sen latu Anutu-te hil-ato, de taavêêt anipaya ond Omaaho Nipaya Saalang-ate hil. ");
INSERT INTO mmo_vpl VALUES ("MT13_39","070_13_39","MAT","13","39","39","De omaaho sen vaalil taavêêt anipayaa-to ond Saalang, de busin sen daasupin nôôn ond lohvu busin taamusin lôôt. De hil sen daasupin vanôôn-ato ond angela-so, ");
INSERT INTO mmo_vpl VALUES ("MT13_40","070_13_40","MAT","13","40","40","+ o 13:40 Mat 7:19; Jon 15:6*tonde sil bapuuh taavêêt anipaya be lambaav jak kin ond le lambiing naambêênju vu busin taamusin. ");
INSERT INTO mmo_vpl VALUES ("MT13_41","070_13_41","MAT","13","41","41","+ o 13:41 Mat 24:31; 25:31-46; Mak 13:27*Omaahonôôn Noow e biing yite angela-so lana bapuuh hil anipaya pin sen davu palapin hil-ato, osin bapuuh hil kalêêsin ambu-so pin vu Anutu-te hil lavuun, ");
INSERT INTO mmo_vpl VALUES ("MT13_42","070_13_42","MAT","13","42","42","+ o 13:42 Mat 8:12*tombe gaate sil jakana kin bopaata. Hôôk kin-anju ond le daasu bopaata, de navund monaangitak. ");
INSERT INTO mmo_vpl VALUES ("MT13_43","070_13_43","MAT","13","43","43","+ o 13:43 Dan 12:3*Tombe hôôk busin-anju ond hil anivalok e daatêêlang naambe taaku mêê-to dôôk Maandin Anutu-te taaku. Omaaho ti nambe nanye neep ond gango.” ");
INSERT INTO mmo_vpl VALUES ("MT13_44","070_13_44","MAT","13","44","44","+ o 13:44 Mat 19:29; Luk 14:33; Pil 3:7*“Anutu nanggin yite hil-ato ond lohvu kupak anivasa sen omaaho ti vun lukala ngaanggis-ambe nando de yimb, tombe taamusin atombe omaaho ango tokak-ambe wiingin, om kambu yesin laah, de la osin ka vasa lôôt, tomem la vu yinêên va pin-ambe hil laanggo, tombe hako monêê-ju be la vaanggo ngaanggis boow tii-ju sen kupak lukando hôôk-ato lak.” ");
INSERT INTO mmo_vpl VALUES ("MT13_45","070_13_45","MAT","13","45","45","“Ti having nambe Anutu nanggin yite hil-ato ond lohvu omaaho ti navu taahuun va, ond navu salo vaali nivasa vasa, ");
INSERT INTO mmo_vpl VALUES ("MT13_46","070_13_46","MAT","13","46","46","tombe yi vaali ti nivasa lôôt om vu yinêên va pin-ambe hil laanggo, de hako monêê-ju be la vaanggo vaali nivasaa-ju lak.” ");
INSERT INTO mmo_vpl VALUES ("MT13_47","070_13_47","MAT","13","47","47","+ o 13:47 Mat 22:9-10*“Tonde yik ti having nambe Anutu nanggin yite hil-ato ond lohvu govak sen daate lokala bel-ambe paahuung vaha vaha nalokalaa-to, ");
INSERT INTO mmo_vpl VALUES ("MT13_48","070_13_48","MAT","13","48","48","be pup govak la le mem sil laandiiy lakalaam lonak, tombe sil dando be laholin paahuung anivasa vasa lokala kaambum, de nipaya ond laate la. ");
INSERT INTO mmo_vpl VALUES ("MT13_49","070_13_49","MAT","13","49","49","Vu busin taamusin lôôt ond le naambêênja. Angela-so le lanaam-ambe langgolin hil anipaya dôôk hil anivasa lavuun, ");
INSERT INTO mmo_vpl VALUES ("MT13_50","070_13_50","MAT","13","50","50","+ o 13:50 Mat 13:42; Luk 13:28*tombe gaate sil jêê-na kin bopaata, tombe le daasu be le janga navund.” ");
INSERT INTO mmo_vpl VALUES ("MT13_51","070_13_51","MAT","13","51","51","Tonde Yesu lingin sil nambe, “Vakasin pin-anjo ond ham alak ni?” Tombe laliinggis nambe, “Êê-e.” ");
INSERT INTO mmo_vpl VALUES ("MT13_52","070_13_52","MAT","13","52","52","Tombe nêêl vu sil nambe, “Hil tanasin dangga-so pin sen kand navu Anutu-te tanasin bôôy osin sil lango sate vakasin lak Anutu nanggin yite hil-ato having-ambe lako lak, ond sil lalohvu bayêên mangganaan lokala yite bayêên alo kupak-atêêto be hako yite va moos osin va nimbôôy hôôk ti be lukalom.” ");
INSERT INTO mmo_vpl VALUES ("MT13_53","070_13_53","MAT","13","53","53","+ o 13:53 Mat 7:28*Yesu nêêl vakasin pakwesin-anju lung la tonde kandi vuu-ju be la. ");
INSERT INTO mmo_vpl VALUES ("MT13_54","070_13_54","MAT","13","54","54","+ o 13:54 Jon 7:15*Tok la baan atombe huli-la dumb alo be wiing tanasin vu hil, tombe lavindis lôôt-ande lanêêl nambe, “Omaahôô-ju hako lukook bopaataa-ju osin nawiing taahu taahu osin niwêêk-anju vu tana? ");
INSERT INTO mmo_vpl VALUES ("MT13_55","070_13_55","MAT","13","55","55","+ o 13:55 Luk 3:23; Jon 6:42*Omaahôô-ju mak kaamunda noow, tangganaan Malia, de halindin Yaakop ayuuh Yusep de Simon ayuuh Yudas, ");
INSERT INTO mmo_vpl VALUES ("MT13_56","070_13_56","MAT","13","56","56","de vangaandin pin sen dando having yiiy-anjo, om hako va pin-anju vu tana?” ");
INSERT INTO mmo_vpl VALUES ("MT13_57","070_13_57","MAT","13","57","57","+ o 13:57 Jon 4:44*Tombe sil ahend kalin vu yi. Tombe Yesu nêêl vu sil nambe, “Omaaho ti nanêêl Anutu-te vakasin langaah ond hil dako omaahôô-ju haale lak lohvu taaku pin, lemu hil vu yite baan dangga dosin osin hil sen sil dangga timuu-to ond sil-ame dako yi lak e.” ");
INSERT INTO mmo_vpl VALUES ("MT13_58","070_13_58","MAT","13","58","58","Tombe Yesu me-wiing taahu taahu osin niwêêk ngeeyaata vu taakuu-ju le, in hil-ame lawii-having yi le. ");
INSERT INTO mmo_vpl VALUES ("MT14_1","070_14_1","MAT","14","1","1","Hôôk busin-anju tombe omaaho lulemak Helot hangoyin Yesu banye, ");
INSERT INTO mmo_vpl VALUES ("MT14_2","070_14_2","MAT","14","2","2","tombe nêêl vu yite hil kul vaha-so nambe, “Omaahôô-ju mak Jon sen nalipis hil-ato, kandi lak vu hil yimbin-ate ondeey nawiing taahu taahu osin niwêêk.” ");
INSERT INTO mmo_vpl VALUES ("MT14_3","070_14_3","MAT","14","3","3","+ o 14:3 Mat 11:2*In Helot-anju bôôy lôôh Jon-ambe duuh, de hatung hôôk kalaambus, in dangga nambe Helot hali Pilip ond Helot lakin vane Helodias, ");
INSERT INTO mmo_vpl VALUES ("MT14_4","070_14_4","MAT","14","4","4","+ o 14:4 Lev 18:16; 20:21*le Jon nêêl Helot nambe, “Ohako vêêh-anja me-lohvu le.” ");
INSERT INTO mmo_vpl VALUES ("MT14_5","070_14_5","MAT","14","5","5","+ o 14:5 Mat 21:26*Tombe Helot wiingin nambe nyiis Jon-ambe jimb, lemu yêênin hil ngeeyaata in layi Jon nambe omaaho sen nanêêl Anutu-te vakasin langaah-ato. ");
INSERT INTO mmo_vpl VALUES ("MT14_6","070_14_6","MAT","14","6","6","Tonde busin ti Helot aka vu yite busin sen tangganaan hako yii-to om wiing vanôôn bop-ambe teey yite omaaheey lalaam, tombe Helodias nowaavêêh monakôômb hôôk sil lavuun, tombe Helot yi be ahe nivasa lôôt, ");
INSERT INTO mmo_vpl VALUES ("MT14_7","070_14_7","MAT","14","7","7","om nêêl vu vêêh-anju nambe, “Onaanêêl naambe saambu vati vu hong, ond sale aambu vu hong keen baandoni.” ");
INSERT INTO mmo_vpl VALUES ("MT14_8","070_14_8","MAT","14","8","8","Tombe vêêh-anju tangganaan nêêl hôôk nowaavêêh ahe, om nowaavêêh nêêl vu Helot nambe, “Okatôôv Jon sen nalipis hil-ato lukook-ambe onggatung hôôk kaambum ti be gambu naam vu sa.” ");
INSERT INTO mmo_vpl VALUES ("MT14_9","070_14_9","MAT","14","9","9","Nêêl nambêênju tombe omaaho lulemak lopayo nimeen, le ma de ka vu sen nêêl lak baandonii-to osin hil ngeeyaata dando having yii-to, om nêêl nambe lambu vu yi. ");
INSERT INTO mmo_vpl VALUES ("MT14_10","070_14_10","MAT","14","10","10","+ o 14:10 Mat 17:12*Tombe wiing omaaho ti la lukala kalaambus alopayo be katôôv Jon aka, ");
INSERT INTO mmo_vpl VALUES ("MT14_11","070_14_11","MAT","14","11","11","tombe hatung lukook hôôk kaambum ti be hako be laah vu vu vehaavuu-ju, le mem hako la vu tangganaan. ");
INSERT INTO mmo_vpl VALUES ("MT14_12","070_14_12","MAT","14","12","12","Tonde Jon-ate maanggêêm-aso lala lako Jon aninaavi be lala lahaav, de lalaah lanêêl banye vu Yesu. ");
INSERT INTO mmo_vpl VALUES ("MT14_13","070_14_13","MAT","14","13","13","Yesu hangoyin Jon yimb-ato banye, tombe havuuh taaku de lakala kaanu be la in nambe yoo na mando taaku lundoos ti, le ma de hil ngeeyaata vu taaku bo-bop lango nambe Yesu la, om latup voon-ambe lala taamuyin yi. ");
INSERT INTO mmo_vpl VALUES ("MT14_14","070_14_14","MAT","14","14","14","+ o 14:14 Mat 9:36*Yesu lakala lonak, le yi de hil ngeeyaata dando, tombe ka pasiv in sil-ambe wiing silate hil anilakin nind vasa lak. ");
INSERT INTO mmo_vpl VALUES ("MT14_15","070_14_15","MAT","14","15","15","Tonde soosin hôôk atombe yite maanggêêm-aso lala lanêêl vu nambe, “Taaku lung la de taakuu-jo lumbalaamb, om gambiing-ambe hil-anju lana bayêên ti ti in sil baanggo silate vanôôn in sil lanja.” ");
INSERT INTO mmo_vpl VALUES ("MT14_16","070_14_16","MAT","14","16","16","Le ma de Yesu nêêl vu maanggêêm-aso nambe, “Me-lana le, yik ham oo ambu vanôôn vu sil.” ");
INSERT INTO mmo_vpl VALUES ("MT14_17","070_14_17","MAT","14","17","17","Tombe sil lanêêl vu nambe, “Heyanêêngg vanôôn ma, yik balet namaavaalu having paahuung yuuh amu neep.” ");
INSERT INTO mmo_vpl VALUES ("MT14_18","070_14_18","MAT","14","18","18","Om nêêl vu sil nambe, “Om ham gako naam vu sa le.” ");
INSERT INTO mmo_vpl VALUES ("MT14_19","070_14_19","MAT","14","19","19","+ o 14:19 Mat 15:35-39; Mak 8:6-10*Tonde nêêl-ambe hil ngeeyaataa-ju lato dando voon, tombe hako balet namaavaalu de paahuung yuuh-anju, tonde mem valaah me lak baandoni de lohak, le mem hapok balet be vu vu yite maanggêêm-aso be sil latiiy lohvu hil, ");
INSERT INTO mmo_vpl VALUES ("MT14_20","070_14_20","MAT","14","20","20","+ o 14:20 2King 4:44*tombe sil pin laya lôôt-ambe lohvu sil. Laya lung atonde sil lasupin nyengale hôôk jaambang nomaayuuh-ambe laam yuuh-ambe pup la. ");
INSERT INTO mmo_vpl VALUES ("MT14_21","070_14_21","MAT","14","21","21","Hil sen laya vanôôn-ato ond moow ngeeyaata lôôt lohvu 5 taosen, de vêêh ayuuh unoopasiv ond me-lasevin e. ");
INSERT INTO mmo_vpl VALUES ("MT14_22","070_14_22","MAT","14","22","22","Lung atonde Yesu haanjiihin yite maanggêêm-aso nambe lanjak kaanu be daamunggin-ambe lana betum vaalu, de yoo mando be biing hil lana le. ");
INSERT INTO mmo_vpl VALUES ("MT14_23","070_14_23","MAT","14","23","23","+ o 14:23 Luk 6:12; 9:28*Tombe wiing hil lala de yoo ti lak kandu be la nando monalohak nandôô-ju, tombe yoo timu nando be taaku bus la. ");
INSERT INTO mmo_vpl VALUES ("MT14_24","070_14_24","MAT","14","24","24","Tonde kaanu la lavuun lôôt-ande vavi laam niwêêk neep kaanu nalu be bel yiis ak kaanu lôôt. ");
INSERT INTO mmo_vpl VALUES ("MT14_25","070_14_25","MAT","14","25","25","Tonde hôôk heendiisin atombe Yesu naale nala lak bel baandoni be la vu sil. ");
INSERT INTO mmo_vpl VALUES ("MT14_26","070_14_26","MAT","14","26","26","+ o 14:26 Luk 24:37*Tombe yite maanggêêm-aso layi de naale lak bel baandoni be nalaam vu sil, tombe kanund la lôôt, om lanêêl nambe, “Ham hil, peey mamu ti.” Tombe layêênin-ambe langeeyak lôôt. ");
INSERT INTO mmo_vpl VALUES ("MT14_27","070_14_27","MAT","14","27","27","Tombe Yesu nêêl la vu sil pavis nambe, “Ham naham aniwêêk, yik saa-jo, om ham-ame anjêênin e.” ");
INSERT INTO mmo_vpl VALUES ("MT14_28","070_14_28","MAT","14","28","28","Tombe Pita nêêl laah vu nambe, “Omaaho Bop, hong-anja ond onaanêêl-ambe sa jambaale bel baandoni be sa naas vu hong.” ");
INSERT INTO mmo_vpl VALUES ("MT14_29","070_14_29","MAT","14","29","29","+ o 14:29 Jon 21:7*Tombe Yesu nêêl nambe, “Hong-o.” Tombe Pita luus vu kaanu be naale lak betum alis baandoni be la vu Yesu, ");
INSERT INTO mmo_vpl VALUES ("MT14_30","070_14_30","MAT","14","30","30","le sim yi bel yiis bopaata, tombe yêênin-ande wiingin nambe davin na betum, om teey nambe, “Omaaho Bop, ganôôh sa jak.” ");
INSERT INTO mmo_vpl VALUES ("MT14_31","070_14_31","MAT","14","31","31","+ o 14:31 Mat 8:26*Tonde Yesu nama la pavis-ambe lôôh Pita de nêêl vu nambe, “Game gawii-having niwêêk e. Nambe vaati sen gakam yu-yuuh?” ");
INSERT INTO mmo_vpl VALUES ("MT14_32","070_14_32","MAT","14","32","32","+ o 14:32 Mak 4:39*Tombe yuuh lalakalaah kaanu tonde vavi tôômin. ");
INSERT INTO mmo_vpl VALUES ("MT14_33","070_14_33","MAT","14","33","33","+ o 14:33 Mat 27:54; Jon 1:49*Tombe sil sen lalakando kaanuu-to lako Yesu haale lak nambe, “Hong Anutu Noow keen.” ");
INSERT INTO mmo_vpl VALUES ("MT14_34","070_14_34","MAT","14","34","34","Sil latok lala betum vaalu vu taaku Genesaalet, ");
INSERT INTO mmo_vpl VALUES ("MT14_35","070_14_35","MAT","14","35","35","tombe hil vu taakuu-ju lalak Yesu ni, om sil lanêêl vakasin la lohvu taakuu-ju pin, om lako hil anilakin pin lalaam vu yi. ");
INSERT INTO mmo_vpl VALUES ("MT14_36","070_14_36","MAT","14","36","36","+ o 14:36 Mat 9:20-21; Mak 5:27-28; Luk 8:44*Tombe sil kataangg yi nambe hil anilakin gambe namand jak yite lolop anyendaambu mu, tombe mem hil sen lambe namand ak-ato ond nind vasa lak pin. ");
INSERT INTO mmo_vpl VALUES ("MT15_1","070_15_1","MAT","15","1","1","Tombe Palisai osin tanasin dangga heey vu Yelusalem-ambe lala vu Yesu be lalingin nambe, ");
INSERT INTO mmo_vpl VALUES ("MT15_2","070_15_2","MAT","15","2","2","+ o 15:2 Luk 11:38*“Nambe vaati sen gate maanggêêm-aso davu kalêêh himbop bôôy-ate tanasin om daya vanôôn danjeen-ande me-dalipis namand e.” ");
INSERT INTO mmo_vpl VALUES ("MT15_3","070_15_3","MAT","15","3","3","Le Yesu nêêl laah vu sil nambe, “De nambe vaati sen ham navu kalêêh Anutute tanasin, de ham oo navu taamuyin himbop bôôy-ate tanasin? ");
INSERT INTO mmo_vpl VALUES ("MT15_4","070_15_4","MAT","15","4","4","+ o 15:4 Eks 20:12; 21:17; Diu 5:16*In Anutu nêêl nambe, ‘Onggako mom ayuuh tam jak.’ De nêêl vakasin ango having nambe, ‘Omaaho ti naanêêl vakasin anipaya jak mangganaan me tangganaan ond hil lanyiis-ambe jimb.’ ");
INSERT INTO mmo_vpl VALUES ("MT15_5","070_15_5","MAT","15","5","5","Nganjo ham ond ham nanêêl nambe omaaho ti naanêêl vu mangganaan me tangganaan naambe bu va na in dôôvu yuuh, le nêêl Anutu haale lak lung la, ");
INSERT INTO mmo_vpl VALUES ("MT15_6","070_15_6","MAT","15","6","6","ond ham nanêêl nambe lung-ande omaahôô-ju me-dôôvu mangganaan ayuuh tangganaan e. Om nambêênja ham oo kawiiy Anutu-te vakasin lak himbop bôôy-ate tanasin-ambe natu va malis amu. ");
INSERT INTO mmo_vpl VALUES ("MT15_7","070_15_7","MAT","15","7","7","Ham hil tatuhin ambu-so, Yesaia nêêl Anutu-te vakasin lak ham bôôy-ato ond yoo nêêl lohvu. In nêêl nambe, ");
INSERT INTO mmo_vpl VALUES ("MT15_8","070_15_8","MAT","15","8","8","+ o 15:8-9 Ais 29:13*‘Hil-anjo dako sa haalengg ak avind malis amu, de londpayo nando diin in sa. ");
INSERT INTO mmo_vpl VALUES ("MT15_9","070_15_9","MAT","15","9","9","Dalohak malis amu vu sa, tonde davu taahu hil hôôk omaahonôôn oote tanasin nambe sate tanasin keen.’” ");
INSERT INTO mmo_vpl VALUES ("MT15_10","070_15_10","MAT","15","10","10","Tonde Yesu teey hil ngeeyaataa-ju lala vu yi be nêêl vu sil nambe, “Ham gango vakasin-anjo be ham anjak ni vanuh. ");
INSERT INTO mmo_vpl VALUES ("MT15_11","070_15_11","MAT","15","11","11","+ o 15:11 Mat 12:34*Vanôôn pin sen nalukala omaahonôôn avind ond me-nawiing-ambe Anutu nayi omaahonôôn nambe nipaya le. Nganjo va pin sen kand navu be danêêl langaah-ato ond mem nawiing-ambe Anutu nayi omaahonôôn nambe nipaya.” ");
INSERT INTO mmo_vpl VALUES ("MT15_12","070_15_12","MAT","15","12","12","Tombe yite maanggêêm-aso lala lanêêl vu nambe, “Palisai-so lango vakasin-anja be ahend kalin, mak galak ni?” ");
INSERT INTO mmo_vpl VALUES ("MT15_13","070_15_13","MAT","15","13","13","+ o 15:13 Jon 15:2*Le Yesu nêêl laah vu sil nambe, “Va pin sen Aamangg vu baandoni me-vaalôôh e, ond le bapuuh na osin kangga. ");
INSERT INTO mmo_vpl VALUES ("MT15_14","070_15_14","MAT","15","14","14","+ o 15:14 Mat 23:16,24; Luk 6:39; Lom 2:19*Ham baale de sil oote va, sil amend kanu, le lawiingin nambe taato mopaatôôv vu hil amekanu vaalu, de mekanu ti nambe daandiiy mekanu ango be yuuh lana mopaatôôv ond yuuh ahondoos e landupake.” ");
INSERT INTO mmo_vpl VALUES ("MT15_15","070_15_15","MAT","15","15","15","Tombe Pita nêêl vu Yesu nambe, “Otatekin vakasin pakwesin-anjo dangga vu hey e.” ");
INSERT INTO mmo_vpl VALUES ("MT15_16","070_15_16","MAT","15","16","16","Om Yesu nêêl vu sil nambe, “De ham-anjo, ham-ame alak ni le? ");
INSERT INTO mmo_vpl VALUES ("MT15_17","070_15_17","MAT","15","17","17","Mak ham-ame alak ni le, nambe vanôôn pin sen nalukala omaahonôôn avind ond nalukala sil ahend-ambe hato nala be nalukala lôôvin, ");
INSERT INTO mmo_vpl VALUES ("MT15_18","070_15_18","MAT","15","18","18","+ o 15:18 Mat 12:34*lemu va pin sen naale hôôk hil alondpayo be danêêl langaah-ato ond mem nawiing-ambe Anutu nayi omaahonôôn nambe nipaya. ");
INSERT INTO mmo_vpl VALUES ("MT15_19","070_15_19","MAT","15","19","19","+ o 15:19 Jen 8:21; Gal 5:19-21*In va sen vu omaahonôôn alondpayo be nalaam-ato ond kand navu va nipaya osin dayiis omaahonôôn dayimb, de omaaho ango hôôndak ango vane, de vêêh ango hôôndak ango laya, osin vehaavu yuuh maanggêêm dawiing baayamb, de dahôôndak va, osin davu tatuhin vakasin malis vu omaaho ango, de danêêl vakasin palesin. ");
INSERT INTO mmo_vpl VALUES ("MT15_20","070_15_20","MAT","15","20","20","Va pin-anja nawiing-ambe Anutu nayi omaahonôôn nambe nipaya, nganjo daya vanôôn-ande me-dalipis namand e, ond vaa-ju me-nawiing-ambe Anutu nayi omaahonôôn nambe nipaya le.” ");
INSERT INTO mmo_vpl VALUES ("MT15_21","070_15_21","MAT","15","21","21","Yesu-so lavuuh taakuu-ju de lala taaku sen Taia yuuh Saidon neep-ato, ");
INSERT INTO mmo_vpl VALUES ("MT15_22","070_15_22","MAT","15","22","22","tombe vêêh Kanaan ti vu taakuu-ju laam-ambe teey nambe, “Omaaho Bop, hong sen gate danggakook neep vu Devit-ato, gakam pasiv in sa le. Mamu nipaya nahôôvu sa nonggaavêêh lôôt.” ");
INSERT INTO mmo_vpl VALUES ("MT15_23","070_15_23","MAT","15","23","23","Le Yesu me-nêêl vakasin ti laah vu le, tombe yite maanggêêm-aso lala kataangg Yesu nambe, “Vêêh-anju monateey-ambe navu sapa yiiy lôôt, om onaanêêl-ambe naah e.” ");
INSERT INTO mmo_vpl VALUES ("MT15_24","070_15_24","MAT","15","24","24","+ o 15:24 Mat 10:6*Tombe Yesu nêêl laah nambe, “Aamangg wiing-ambe sa laam in saandôôvu hil Islel amu sen sil lalohvu sipsip-ambe dala mend namaa-to.” ");
INSERT INTO mmo_vpl VALUES ("MT15_25","070_15_25","MAT","15","25","25","Le vêêh-anju laam-ambe hatung kaatu vu Yesu de nêêl nambe, “Omaaho Bop, gandôôvu sa.” ");
INSERT INTO mmo_vpl VALUES ("MT15_26","070_15_26","MAT","15","26","26","Tombe Yesu nêêl laah vu nambe, “Me-lohvu nambe omaaho ti gako unoopasiv-ate vanôôn-ambe gaate na vu voow e.” ");
INSERT INTO mmo_vpl VALUES ("MT15_27","070_15_27","MAT","15","27","27","Le vêêh-anju nêêl nambe, “Êê-e Omaaho Bop, manyinja ganêêl keen, lemu vanôôn paapu sen natok hôôk heendin-ate pêêt ahendanggaa-to ond voow daya.” ");
INSERT INTO mmo_vpl VALUES ("MT15_28","070_15_28","MAT","15","28","28","+ o 15:28 Mat 8:10,13*Tombe Yesu nêêl laah vu nambe, “Gawii-having niwêêk om gate vakasin navu nôôn jak nohvu gawii-having-anja.” Tombe yik vêêh-anju nowaavêêh anivasa lak pavis hôôk taaku me tii-ju vulotin. ");
INSERT INTO mmo_vpl VALUES ("MT15_29","070_15_29","MAT","15","29","29","+ o 15:29 Mak 7:31*Tonde Yesu havuuh taakuu-ju de loh betum Galili nanyendangga be la, tombe lak kandu ti be la nando. ");
INSERT INTO mmo_vpl VALUES ("MT15_30","070_15_30","MAT","15","30","30","Tombe hil ngeeyaata lala vu yi be lako hil vahand anipaya osin hil amend kanu, de hil sen kook nawiing payaa-to, osin hil akand ma, tonde hil anilakin ngeeyaata having be lala vu yi, tombe lambe sil deep hôôk Yesu vaha be wiing-ambe sil anind vasa lak. ");
INSERT INTO mmo_vpl VALUES ("MT15_31","070_15_31","MAT","15","31","31","+ o 15:31 Mak 7:37*Tombe hil layi kama-so lakaas osin hil sen kook wiing payaa-to nind vasa lak, de vahand paaya lala mop, osin mekanu-so layi taaku, om lavindis lôôt-ande lako Islel-ate Anutu haale lak. ");
INSERT INTO mmo_vpl VALUES ("MT15_32","070_15_32","MAT","15","32","32","+ o 15:32-33 Mat 14:14-15*Yesu teey yite maanggêêm-aso lala vu yi be nêêl vu sil nambe, “Sa kangg pasiv in hil ngeeyaataa-jo in dando busin yaal having sa, de silanêênd vanôôn sen lanjaa-to ma, de sa nimbaya nambe same aambiing-ambe lana meep e, in le lana sakend nama jak vu mop lavuun.” ");
INSERT INTO mmo_vpl VALUES ("MT15_33","070_15_33","MAT","15","33","33","Tombe maanggêêm-aso lanêêl vu nambe, “Yiiy nando taaku lumbalaamb-anjo om yale gako vanôôn vu tana be yambaat hil ngeeyaataa-jo?” ");
INSERT INTO mmo_vpl VALUES ("MT15_34","070_15_34","MAT","15","34","34","Tombe Yesu lingin sil nambe, “Hamate vanôôn nôôn vaaheey naahen nando?” Le lanêêl vu nambe, “Balet namaavaalu be vindak yuuh, de paahuung daka yuuh.” ");
INSERT INTO mmo_vpl VALUES ("MT15_35","070_15_35","MAT","15","35","35","Tombe mem nêêl-ambe hil lato dando voon, ");
INSERT INTO mmo_vpl VALUES ("MT15_36","070_15_36","MAT","15","36","36","de hako balet namaavaalu be vindak yuuh having paahuung-anju be lohak osin pêêlis la vu Anutu, de hapok-ambe vu vu yite maanggêêm-aso, le mem maanggêêm-aso latiiy lohvu hil. ");
INSERT INTO mmo_vpl VALUES ("MT15_37","070_15_37","MAT","15","37","37","Tombe sil pin laya be lohvu sil, de lasupin nyengale hôôk jaambang namaavaalu be vindak yuuh-ambe pup la. ");
INSERT INTO mmo_vpl VALUES ("MT15_38","070_15_38","MAT","15","38","38","Hil sen laya vanôôn-anju ond moow ngeeyaata lôôt lohvu 4 taosen, tonde vêêh ayuuh unoopasiv ond me-lasevin e. ");
INSERT INTO mmo_vpl VALUES ("MT15_39","070_15_39","MAT","15","39","39","Lung laa tonde wiing-ambe sil lala, le mem lakala kaanu be la taaku Magadan. ");
INSERT INTO mmo_vpl VALUES ("MT16_1","070_16_1","MAT","16","1","1","+ o 16:1 Mat 12:38; Luk 11:16; Jon 6:30*Tombe Palisai osin Sadusi-so lala vu Yesu in nambe sahi yi, om lanêêl nambe biing taahu taahu jak va niwêêk baandoni-te be lanji. ");
INSERT INTO mmo_vpl VALUES ("MT16_2","070_16_2","MAT","16","2","2","Le nêêl laah vu sil nambe, “Ham nahe hôôk soosin nambe taaku suuh ahemasangin ond ham nanêêl nambe, ‘Taaku navu galevang.’ ");
INSERT INTO mmo_vpl VALUES ("MT16_3","070_16_3","MAT","16","3","3","Tonde samiinaanôôn ham nahe nambe taaku tumak le kakuup hilin, ond ham nanêêl nambe, ‘Om peey e luk osin vavi.’ Ke, ham navu sahi lak va baandoni nambêênja be lohvu, lemu va sen Anutu nawiing taahu taahu osin niwêêk hôôk ham amem ond ham-ame alohvu nambe anjak ni le, ham doosin. ");
INSERT INTO mmo_vpl VALUES ("MT16_4","070_16_4","MAT","16","4","4","+ o 16:4 Mat 12:39; Luk 11:29*Ham hil anipaya sen gêên-anjo, ham-ame awii-having Anutu le, ondeey ham awiingin nambe ham angge taahu taahu ti, lemu same le aambiing taahu taahu ti vu ham e, nganjo ham akam bu Yona sen nanêêl Anutu-te vakasin langaah bôôy-ato yite taahu taahu mu.” Lung laa tonde Yesu havuuh sil-ande la. ");
INSERT INTO mmo_vpl VALUES ("MT16_5","070_16_5","MAT","16","5","5","Yesu having yite maanggêêm-aso be lalakala kaanu be lala betum vaalu, lemu sil akand lingin vanôôn-ande me-lako having e, ");
INSERT INTO mmo_vpl VALUES ("MT16_6","070_16_6","MAT","16","6","6","+ o 16:6 Luk 12:1*tombe Yesu nêêl vu sil nambe, “Ham gango, ham ganggin ham nivasa in Palisai osin Sadusi-te yis balet-ate.” ");
INSERT INTO mmo_vpl VALUES ("MT16_7","070_16_7","MAT","16","7","7","Tombe sil oo mondanêêl vu sil nambe, “Yame hako balet e, ondeey nêêl nambêênju.” ");
INSERT INTO mmo_vpl VALUES ("MT16_8","070_16_8","MAT","16","8","8","Le Yesu lak ni om nêêl nambe, “Ham-ame awii-having niwêêk e. Nambe vaati sen ham oo vakaas danjeen vu ham nambe, ‘Yame hako balet e.’ ");
INSERT INTO mmo_vpl VALUES ("MT16_9","070_16_9","MAT","16","9","9","+ o 16:9 Mat 14:17-21*Ham akam-ame neep e? Ham akam-ame navu balet namaavaalu sen saavu vu hil ngeeyaata lôôt lohvu 5 taosen-ambe layaa-to, ond ham asupin nyengale hôôk jaambang vilis? ");
INSERT INTO mmo_vpl VALUES ("MT16_10","070_16_10","MAT","16","10","10","+ o 16:10 Mat 15:34-38*De ham akam-ame navu balet namaavaalu be vindak yuuh sen hil ngeeyaata lôôt lohvu 4 taosen layaa-to, ond ham asupin nyengale hôôk jaambang vilis? ");
INSERT INTO mmo_vpl VALUES ("MT16_11","070_16_11","MAT","16","11","11","Nambe vaati sen ham-ame alak ni le nambe same naanêêl vanôôn vu ham e? Nganjo ham ganggin ham in Palisai osin Sadusi-te yis.” ");
INSERT INTO mmo_vpl VALUES ("MT16_12","070_16_12","MAT","16","12","12","Tombe mem sil lalak ni nambe me-nêêl in nambe sil ganggin sil in yis balet-ate le, nganjo nêêl in nambe sil ganggin sil in hil Palisai osin Sadusi-te tanasin. ");
INSERT INTO mmo_vpl VALUES ("MT16_13","070_16_13","MAT","16","13","13","Yesu-so lala taaku Sisalia Pilipai le mem Yesu lingin yite maanggêêm-aso nambe, “Hil danêêl Omaahonôôn Noow nambe yi lati?” ");
INSERT INTO mmo_vpl VALUES ("MT16_14","070_16_14","MAT","16","14","14","+ o 16:14 Mat 14:1-2; Mak 6:14-15; Luk 9:7-8*Tombe lanêêl nambe, “Hil vaalu danêêl nambe hong Jon sen nalipis hil-ato, de vaalu danêêl nambe Eliya, de vaalu danêêl nambe Yelemia me hil sen danêêl Anutu-te vakasin langaah-ato ti.” ");
INSERT INTO mmo_vpl VALUES ("MT16_15","070_16_15","MAT","16","15","15","Tonde Yesu lingin sil nambe, “De ham-ok? Ham nanêêl sa nambe lati?” ");
INSERT INTO mmo_vpl VALUES ("MT16_16","070_16_16","MAT","16","16","16","+ o 16:16 Jon 6:69*Tombe Simon Pita nêêl laah vu nambe, “Hong omaaho sen Anutu yoo holin hong vulôôt in nambe gandôôvu hey-ato, ond Anutu metumin Noow hong.” ");
INSERT INTO mmo_vpl VALUES ("MT16_17","070_16_17","MAT","16","17","17","+ o 16:17 Mat 17:5; Gal 1:15-16*Tombe Yesu nêêl laah vu nambe, “Yona noow Simon, gakam vasa, in hil vu voon-anjo ti me-nêêl vakasin-anjo vu hong e, nganjo Aamangg sen nando baandonii-to yoo taato vu hong. ");
INSERT INTO mmo_vpl VALUES ("MT16_18","070_16_18","MAT","16","18","18","+ o 16:18 Jon 1:42; Ep 2:20*De sa naanêêl hong naambe Pita, haale Pita dangga nambe tatuuh. Sale balaah sate hil landukana baale tatuuh-anjo, de taaku nipaya yite niwêêk-ame lohvu nambe kape sil e. ");
INSERT INTO mmo_vpl VALUES ("MT16_19","070_16_19","MAT","16","19","19","+ o 16:19 Mat 18:18; Jon 20:23*De taaku sen hil dalukala be Anutu nanggin sil-ato, ond sale aambu yite kiiy vu hong, tombe va sen onaapuvu hôôn vu voon ond Anutu le naapuvu hôôn vu baandoni gaving, de va sen okavaayin vu voon ond Anutu le kavaayin vu baandoni gaving.” ");
INSERT INTO mmo_vpl VALUES ("MT16_20","070_16_20","MAT","16","20","20","+ o 16:20 Mat 17:9; Mak 9:9*Tonde Yesu vu kôôvu yite maanggêêm-aso niwêêk nambe me-daanêêl vu vaheey naambe yi omaaho sen Anutu yoo holin yi vulôôt-ato le. ");
INSERT INTO mmo_vpl VALUES ("MT16_21","070_16_21","MAT","16","21","21","Tombe hôôk busin-anju Yesu monanêêl vakasin langaah vu yite maanggêêm-aso nambe le na Yelusalem, tombe himbop-aso osin kul vaha sen datung salivangin-ato silate yêêv-aso de tanasin dangga-so le lambu nivaane ngeeyaata vu yi, tonde lanyiis-ambe jimb, de busin yaal vêêl e mem le kandi jak metumin jesin naah. ");
INSERT INTO mmo_vpl VALUES ("MT16_22","070_16_22","MAT","16","22","22","Tombe Pita hako Yesu be yuuh lala daale lundoos, le mem nêêl yi nambe, “Omaaho Bop, game naanêêl e. Va naambêênja me-le naatovu hong e.” ");
INSERT INTO mmo_vpl VALUES ("MT16_23","070_16_23","MAT","16","23","23","Le Yesu hilin-ambe nêêl vu Pita nambe, “Saalang, gana vêêl, gawiingin ganggilin mop in sa. Gakam-ame navu va lohvu Anutu ka le, nganjo gakam oo navu va lohvu omaahonôôn akand amu.” ");
INSERT INTO mmo_vpl VALUES ("MT16_24","070_16_24","MAT","16","24","24","+ o 16:24 Mat 10:38; Luk 14:27*Tonde yik Yesu nêêl vu yite maanggêêm-aso nambe, “Omaaho ti wiingin nambe sapa sa ond yoo daanggôôl yi, le mem baaku yite haah pako be sapa sa. ");
INSERT INTO mmo_vpl VALUES ("MT16_25","070_16_25","MAT","16","25","25","+ o 16:25 Mat 10:39; Luk 17:33; Jon 12:25*De omaaho ti yoo wiingin nambe ganggin ninaavi nivasa in mando metumin, ond le jimb-ambe na menama osin nôôn metumin-ate. Le naambe omaaho ti baaku nimeen jak sa haalengg-ambe jimb, ond mem le mando metumin danggata. ");
INSERT INTO mmo_vpl VALUES ("MT16_26","070_16_26","MAT","16","26","26","+ o 16:26 Mat 4:8-9*Le omaaho ti gôôlis va voon-ate pin, de jimb-ambe na menama osin nôôn metumin-ate, ond va voon-ate me-le dôôvu yi le, le nama. De va voon-ate ti me-neep in nambe omaaho ti me-baanggo kanu jak-ambe mando metumin danggata le, malis. ");
INSERT INTO mmo_vpl VALUES ("MT16_27","070_16_27","MAT","16","27","27","+ o 16:27 Mat 25:31; Saam 62:12; Pro 24:12; Lom 2:6; Taato 22:12*Omaahonôôn Noow e nom osin Mangganaan-ate nikaapulis gaving yite angela-so, tombe mem le bu nyevahaan dokanaah vu omaahonôôn pin, nohvu va sen dawiing-ato. ");
INSERT INTO mmo_vpl VALUES ("MT16_28","070_16_28","MAT","16","28","28","Sa naanêêl vu ham keen naambe ham sen ham naalêê-jo ond vaalu me-le lanjimb e, de lanji Omaahonôôn Noow e nom naambe omaaho lulemak vu yite hil e mem.” ");
INSERT INTO mmo_vpl VALUES ("MT17_1","070_17_1","MAT","17","1","1","Busin namaavaalu vindak ti la vêêl e, mem Yesu hako Pita yuuh Jems having hali Jon-ambe sil oo lalak kandu bopaata ti be lala. ");
INSERT INTO mmo_vpl VALUES ("MT17_2","070_17_2","MAT","17","2","2","+ o 17:2 2Pi 1:16-18*Tombe sil pin-ambe daale, tonde sim Yesu ninaavi ango yoow ak hôôk yaal amend, de mekaalus tum bop nambe taaku me, tombe yite lolop ayuuh ame yoo nivalôôy lôôt nambe bayiimb ahevalôôy. ");
INSERT INTO mmo_vpl VALUES ("MT17_3","070_17_3","MAT","17","3","3","Tombe sim yaal layi de Mose yuuh Eliya daale dakaas having Yesu, ");
INSERT INTO mmo_vpl VALUES ("MT17_4","070_17_4","MAT","17","4","4","tombe Pita nêêl vu Yesu nambe, “Omaaho Bop, yiiy nandôô-jo nivasa lôôt, om naambe gawiingin ond sa daav numang daka yaal mandôô-jo, gate ti, Mose-te ti, de Eliya-te ti.” ");
INSERT INTO mmo_vpl VALUES ("MT17_5","070_17_5","MAT","17","5","5","+ o 17:5 Saam 2:7; Ais 42:1; Mat 3:17; Mak 1:11; Luk 3:22; Diu 18:15*Naahen nanêêl atonde layi de bayiimb ti têêlang lôôt-ambe vayum sil, tombe lava ti laam hôôk bayiimb-anju lopayo nambe, “Sa Noongg-anja. Sahengg having yi lôôt osin sahengg anivasa vu yi, om ham gango lava.” ");
INSERT INTO mmo_vpl VALUES ("MT17_6","070_17_6","MAT","17","6","6","Maanggêêm-aso langoyin vakasin-anju, tombe yaal lato pataav baambund neep voon de layêênin lôôt, ");
INSERT INTO mmo_vpl VALUES ("MT17_7","070_17_7","MAT","17","7","7","tombe Yesu la hambe nama lak yaal, de nêêl nambe, “Maal kandi. Maal-ame anjêênin e.” ");
INSERT INTO mmo_vpl VALUES ("MT17_8","070_17_8","MAT","17","8","8","Tombe yaal amend velak, le me-layi omaaho ti le, malis, yik Yesu yoo timu naale. ");
INSERT INTO mmo_vpl VALUES ("MT17_9","070_17_9","MAT","17","9","9","+ o 17:9 Mat 16:20*Tombe sil vu kanduu-ju be daahen mondaluus, tombe Yesu vu kôôvu yaal nambe, “Taahu taahu sen maal ahêê-to ond maal-ame naanêêl vu omaaho ti le, de Omaahonôôn Noow kandi jak naah vu hil yimbin-ate vêêl e mem.” ");
INSERT INTO mmo_vpl VALUES ("MT17_10","070_17_10","MAT","17","10","10","+ o 17:10 Mal 4:5*Tombe maanggêêm-aso lalingin yi nambe, “Nambe vaati sen tanasin dangga-so danêêl nambe Eliya le naamunggin, le mem omaaho sen Anutu yoo holin yi vulôôt-ato naam?” ");
INSERT INTO mmo_vpl VALUES ("MT17_11","070_17_11","MAT","17","11","11","Le nêêl laah nambe, “De. Eliya le naamunggin in samu va pin dukanaah. ");
INSERT INTO mmo_vpl VALUES ("MT17_12","070_17_12","MAT","17","12","12","+ o 17:12 Mat 11:14; 14:10*Le sa naanêêl vu ham naambe Eliya laam lung la, le hil-ame lalak ni le, malis. Hil oo dawiing va nindanjeen vu yi lohvu sil oo kand, om yik le lambu nivaane vu Omaahonôôn Noow naambêênju gaving.” ");
INSERT INTO mmo_vpl VALUES ("MT17_13","070_17_13","MAT","17","13","13","+ o 17:13 Luk 1:17*Yesu nêêl nambêênju tombe mem yite maanggêêm-aso lalak ni nambe nêêl vakasin-anju lak Jon sen nalipis hil-ato. ");
INSERT INTO mmo_vpl VALUES ("MT17_14","070_17_14","MAT","17","14","14","Latok lala vu hil ngeeyaata tombe omaaho ti la hatung kaatu vu Yesu ");
INSERT INTO mmo_vpl VALUES ("MT17_15","070_17_15","MAT","17","15","15","de nêêl nambe, “Omaaho Bop, gakam pasiv in sa noongg in baando nasi be nango nivaane bopaata. Nalupake be nayêês kin osin nalukala bel balon ngeeyaata, ");
INSERT INTO mmo_vpl VALUES ("MT17_16","070_17_16","MAT","17","16","16","tombe sa hako laam vu gate maanggêêm-aso le me-lalohvu nambe lambiing-ambe nivasa jak e.” ");
INSERT INTO mmo_vpl VALUES ("MT17_17","070_17_17","MAT","17","17","17","+ o 17:17 Diu 32:5,20; Jon 14:9*Tombe Yesu nêêl laah nambe, “Ham hil anipaya, ham-ame awii-having e. Sa mando gaving ham-ambe naangelis e mem ham anjak sate kul ani? De sa gako nimeen in ham na nohvu busin vilis e? Ham gako naam vu sa.” ");
INSERT INTO mmo_vpl VALUES ("MT17_18","070_17_18","MAT","17","18","18","Tombe Yesu nêêl mamu nipaya be hato la in unoopasiv tii-ju de baando nasii-to lung la pavis-ande nivasa lak. ");
INSERT INTO mmo_vpl VALUES ("MT17_19","070_17_19","MAT","17","19","19","+ o 17:19 Mat 10:1*Tonde mem Yesu having yite maanggêêm-aso be sil oo dando, tombe maanggêêm-aso lalingin nambe, “Nambe vaati sen hey-ame aalohvu nambe gatiiy mamu nipayaa-ju na le?” ");
INSERT INTO mmo_vpl VALUES ("MT17_20","070_17_20","MAT","17","20","20","+ o 17:20 Mat 21:21; Mak 11:23; Luk 17:6; 1Ko 13:2*Le Yesu nêêl vu sil nambe, “Ham-ame awii-having niwêêk e, ondeey ham-ame alohvu le. Sa naanêêl keen vu ham naambe ham ambiing gaving pasivdaka nohvu môônd nôôvoow, ond mem ham naanêêl vu kandu tii-ju naambe, ‘Okandi jak-ambe gana baale nganju,’ ond le na. Om naambe ham ambiing gaving ond mem ham alohvu nambe ham e ambiing va pin. ");
INSERT INTO mmo_vpl VALUES ("MT17_21","070_17_21","MAT","17","21","21","Lohakin osin yanjakin yiiy in vanôôn in nambe yame angga le de yaanohak amu, ond vaa-jo mu ond mem lohvu nambe gatiiy mamu na, de vaheey ond me-lohvu le.” ");
INSERT INTO mmo_vpl VALUES ("MT17_22","070_17_22","MAT","17","22","22","Yesu having yite maanggêêm-aso be sil ahondoos oo motatuuvu mop Galili, tombe nêêl vu sil nambe, “Le lambu Omaahonôôn Noow dukana hil namand, ");
INSERT INTO mmo_vpl VALUES ("MT17_23","070_17_23","MAT","17","23","23","+ o 17:23 Mat 16:21*tombe le lanyiis-ambe jimb, tonde busin yaal vêêl e mem kandi jak jesin naah.” Tombe maanggêêm-aso londpayo nimeen lôôt. ");
INSERT INTO mmo_vpl VALUES ("MT17_24","070_17_24","MAT","17","24","24","+ o 17:24 Eks 30:13; 38:26*Latok lala Kapenaum, tombe hil sen dako taakis Anutu-te dumb bop-atêêto ond lala lalingin Pita nambe, “Mak hamate kaputung naate taakis dumb-ate having a?” ");
INSERT INTO mmo_vpl VALUES ("MT17_25","070_17_25","MAT","17","25","25","Tombe Pita liinggis nambe, “Êê-e, naate.” Tonde Pita lukala bayêên alo, tombe Yesu nêêl Pita-te vakasin sen la in nambe naanêêl-ato langaah laah lak yi nambe, “Simon, gakam vu nambe vaati? Hil alulemak vu voon-anja dako taakis kupak osin omaahonôôn-atêêto vu laheey? Mak yoo dako vu silate hil a? Me, dako vu hil vaalu?” ");
INSERT INTO mmo_vpl VALUES ("MT17_26","070_17_26","MAT","17","26","26","Tombe Pita nêêl laah nambe, “Dako vu hil vaalu.” Tombe Yesu nêêl nambe, “Êê-e, om silate hil dando mu. Tombe yik dumb-anju ond Aamangg oote dumb, ");
INSERT INTO mmo_vpl VALUES ("MT17_27","070_17_27","MAT","17","27","27","lemu wame aambiing-ambe sil ahend kalin jak e, om gana gaate pang dokana betum, tombe paahuung ti dôôk nyendoos ond onggapok avi, tombe gale naatovu mone ti neep hôôk, mem onggako monêê-ja be gana gaate naatu wanêêngg taakis.” ");
INSERT INTO mmo_vpl VALUES ("MT18_1","070_18_1","MAT","18","1","1","+ o 18:1 Luk 22:24*Tombe maanggêêm-aso lala vu Yesu be lalingin nambe, “Om lati tu lukook bop savok ango-so vu taaku sen Anutu nanggin-ato?” ");
INSERT INTO mmo_vpl VALUES ("MT18_2","070_18_2","MAT","18","2","2","Om Yesu teey unoopasiv ti laam-ambe valaah naale hôôk sil lavuun, ");
INSERT INTO mmo_vpl VALUES ("MT18_3","070_18_3","MAT","18","3","3","+ o 18:3 Mat 19:14; Mak 10:15; Luk 18:17*de nêêl nambe, “Sa naanêêl keen vu ham naambe ham-ame anggilin ham-ambe ham daanggôôl ham naambe sen unoopasiv-anjo le, ond ham-ame le andukana Anutu nama in ganggin ham e, ma lôôt. ");
INSERT INTO mmo_vpl VALUES ("MT18_4","070_18_4","MAT","18","4","4","+ o 18:4 Mak 10:43-44*Omaaho ti nambe daanggôôl yi naambe sen unoopasiv-anjo, ond mem tu haale bop-ambe savok ango-so vu taaku sen Anutu nanggin-ato. ");
INSERT INTO mmo_vpl VALUES ("MT18_5","070_18_5","MAT","18","5","5","+ o 18:5 Mat 10:40; Luk 10:16; Jon 13:20*Tonde naambe omaaho ti ka bu sa haalengg-ambe gako unoopasiv naambêênjo ti jak, ond lohvu hako sa lak.” ");
INSERT INTO mmo_vpl VALUES ("MT18_6","070_18_6","MAT","18","6","6","“De naambe omaaho ti taahu va nipaya vu sate unoopasiv-aso sen londpayo nalaam timu vu saa-to ti be biing va nipaya ond le naatokak nyevahaan bopaata vu taamusin, ond hil talu tatuuh bopaata dôôk omaahôô-ja ka naamunggin-ambe gaate dukana lôôy-ambe davin na, ond mem nivasa, in me-taahu omaahonôôn dôôk va nipaya le. ");
INSERT INTO mmo_vpl VALUES ("MT18_7","070_18_7","MAT","18","7","7","Hil vu voon-anjo le daatovu nimeen, in va nipaya neep in nambe biing-ambe sil landupake. Keen, va nipaya nambêênja le balup, lemu hil sen dawiing va nipaya be davu kape hil vaaluu-to ond sil e daatovu nimeen. ");
INSERT INTO mmo_vpl VALUES ("MT18_8","070_18_8","MAT","18","8","8","+ o 18:8 Mat 5:29-30*“De naambe onamam vaalu me ovaham vaalu biing-ambe va nipaya kape hong, ond okatôôv-ambe onggaate na vêêl, de onamam vaalu bati me ovaham vaalu bati, ond mem nivasa in gale mando metumin danggata. In onamam yuuh ahondoos-ande ovaham yuuh ahondoos, ond le gaate hong jêê-na kin sen natum danggataa-to. ");
INSERT INTO mmo_vpl VALUES ("MT18_9","070_18_9","MAT","18","9","9","De naambe gamem kaalus vaalu taato va nipaya vu hong-ambe gandupake in va nipaya, ond opasuuh-ambe onggaate na vêêl, de gamem vaalu bati mu ond mem nivasa, in gale mando metumin danggata. In gamem kaalus yuuh ahondoos e nanjip atombe le gaate hong jêê-na kin sen neep hôôk taaku nipayaa-to.” ");
INSERT INTO mmo_vpl VALUES ("MT18_10","070_18_10","MAT","18","10","10","+ o 18:10 Hiblu 1:14*“Ham ganggin ham. Ham-ame angge unoopasiv ayuuh unaavepasiv-anjo naambe va malis e, ma. Sa naanêêl vu ham naambe silate angela-so vu baandoni danggin sil ond angela-so dayi Aamangg sen nando baandonii-to lak busin pin. ");
INSERT INTO mmo_vpl VALUES ("MT18_11","070_18_11","MAT","18","11","11","+ o 18:11 Luk 19:10*In Omaahonôôn Noow lukalaam in nambe dôôvu hil sen mend maa-to. ");
INSERT INTO mmo_vpl VALUES ("MT18_12","070_18_12","MAT","18","12","12","Ham akam bu le, naambe omaaho ti-te bik sipsip 100 naale tombe ti na menama, ond le na salo me le nama? Le na salo. Le balaah sipsip 99 yoo baale kandu, tonde na salo sipsip ti sen memaa-to. ");
INSERT INTO mmo_vpl VALUES ("MT18_13","070_18_13","MAT","18","13","13","Sa naanêêl keen vu ham naambe naatovu sipsip tii-ju, ond le ka vasa in lôôt kaluuh sipsip 99 sen daalêê-to. ");
INSERT INTO mmo_vpl VALUES ("MT18_14","070_18_14","MAT","18","14","14","Om yik ham Mom sen nando baandonii-to me-nawiingin nambe unoopasiv-anjo ti na menama le.” ");
INSERT INTO mmo_vpl VALUES ("MT18_15","070_18_15","MAT","18","15","15","+ o 18:15 Lev 19:17; Luk 17:3; Gal 6:1*“Naambe halim biing va nipaya vu hong, ond gana vu be muuh mando javuh ti le mem onaanêêl yite nipaya kaatokin vu yi. Naambe gangoyin olavam ond gavu vêêl halim in va nipaya. ");
INSERT INTO mmo_vpl VALUES ("MT18_16","070_18_16","MAT","18","16","16","+ o 18:16 Diu 19:15; Jon 8:17*Le naambe me-gango olavam e, ond onggako omaaho ti me omaaho yuuh gaving hong-ambe maal anaah dôôk ti, in ‘muuh me maal naanêêl vakasin langaah e mem ham samu.’ ");
INSERT INTO mmo_vpl VALUES ("MT18_17","070_18_17","MAT","18","17","17","+ o 18:17 1Ko 5:13*Le naambe me-gango maal lavam e, ond onaanêêl vu hil bel-ate pin, le naambe me-gango hil bel lavand gaving e, ond ham angge yi naambe hil bamaan osin yi nipaya lohvu omaaho nako taakis. ");
INSERT INTO mmo_vpl VALUES ("MT18_18","070_18_18","MAT","18","18","18","+ o 18:18 Mat 16:19; Jon 20:23*Sa naanêêl keen vu ham naambe va pin sen ham naapuvu hôôn vu voon-ato ond Anutu le naapuvu hôôn vu baandoni, de va pin sen ham kavaayin vu voon-ato ond Anutu le kavaayin vu baandoni. ");
INSERT INTO mmo_vpl VALUES ("MT18_19","070_18_19","MAT","18","19","19","+ o 18:19 Mak 11:24; Jon 15:7; Jem 1:5*Tonde sa naanêêl ango vu ham naambe ham vu voon-anjo ond omaaho yuuh alondpayo javuh ti in vati be yuuh kataangg, ond Aamangg sen nando baandonii-to le biing nôôn jak vu yuuh. ");
INSERT INTO mmo_vpl VALUES ("MT18_20","070_18_20","MAT","18","20","20","+ o 18:20 Mat 28:20; Jon 14:23*Ke, tonde naambe omaaho yuuh me omaaho yaal daasupin ak sa haalengg-ambe yaal mando javuh ti, ond yik sale mando hôôk yaal lavuun.” ");
INSERT INTO mmo_vpl VALUES ("MT18_21","070_18_21","MAT","18","21","21","Tonde Pita la vu Yesu be nêêl nambe, “Omaaho Bop, halingg biing va nipaya vu sa be sa kawiiy na balon vilis? Mak balon namaavaalu be vindak yuuh mava?” ");
INSERT INTO mmo_vpl VALUES ("MT18_22","070_18_22","MAT","18","22","22","+ o 18:22 Luk 17:4*Tombe Yesu nêêl laah vu nambe, “Same naanêêl vu hong naambe okawiiy halim-ate nipaya na balon namaavaalu be vindak yuuh amu le, malis, sa naanêêl vu hong naambe okawiiy yite va nipaya na nohvu balon 70 naatu balon namaavaalu be vindak yuuh. ");
INSERT INTO mmo_vpl VALUES ("MT18_23","070_18_23","MAT","18","23","23","“Ham gango le. Anutu nanggin yite hil-ato ond lohvu omaaho lulemak ti wiingin nambe gako nyevahaan vu yite hil kul vaha-so. ");
INSERT INTO mmo_vpl VALUES ("MT18_24","070_18_24","MAT","18","24","24","Naahen nawiing kul lakala in nambe gako va nyevahaan, tonde lako omaaho ti la vu yi, in bôôy hako mone ngeeyaata lôôt lohvu 10 milion kina, ");
INSERT INTO mmo_vpl VALUES ("MT18_25","070_18_25","MAT","18","25","25","lemu yinêên mone me-lohvu in nambe bu dôôk-anju le. Tombe omaaho lulemak nêêl nambe vaheey baanggo omaahôô-ju gaving vane osin noondin-ambe yinêên va pin be daatu silate va kul-ate, de gako mone sen laanggo yi lak-anju be bu dokanaah yite nyevahaan. ");
INSERT INTO mmo_vpl VALUES ("MT18_26","070_18_26","MAT","18","26","26","Le ma de hil kul vahaa-ju hato pataav baambu neep voon hôôk omaaho lulemak vaha de kataangg nambe, ‘Gakam pasiv in sa de ombaale vêêl e, in sale aambu dôôk gate nyevahaan pin vu hong.’ ");
INSERT INTO mmo_vpl VALUES ("MT18_27","070_18_27","MAT","18","27","27","Tombe yite himbop aka wiingin yi, om kawiiy yite nyevahaan la, de nêêl-ambe laah. ");
INSERT INTO mmo_vpl VALUES ("MT18_28","070_18_28","MAT","18","28","28","Om hil kul vaha tii-ju hato la voon atombe tovu omaaho ango sen yuuh dawiing kul hôôk tii-to, in yite nyevahaan lohvu 100 kina neep vu, tombe lôôh omaaho ango sen yuuh kul timuu-to be gimbak nama hôôk ka lôôt, de nêêl vu nambe, ‘Gambu dôôk sate nyevahaan vu sa.’ ");
INSERT INTO mmo_vpl VALUES ("MT18_29","070_18_29","MAT","18","29","29","Tombe omaaho angôô-ju yik hato pataav baambu neep voon hôôk vaha de kataangg yi nambe, ‘Gakam pasiv in sa de ombaale vêêl e, in sale aambu dôôk gate nyevahaan vu hong.’ ");
INSERT INTO mmo_vpl VALUES ("MT18_30","070_18_30","MAT","18","30","30","Le ma de nimbaya, om hatung lukala kalaambus in nambe mandôô-ju be bu dôôk yite nyevahaan e mem. ");
INSERT INTO mmo_vpl VALUES ("MT18_31","070_18_31","MAT","18","31","31","Hil kul vaha-so vaalu layi vaa-ju tombe londpayo nimeen lôôt, om lala lanêêl vakasin-anju pin langaah vu silate yêêv, ");
INSERT INTO mmo_vpl VALUES ("MT18_32","070_18_32","MAT","18","32","32","tombe yêêv teey yite hil kul vaha tii-to laam-ambe nêêl vu nambe, ‘Hong omaaho nipaya. Munggin okataangg sa om sa kawiiy gate nyevahaan pin la. ");
INSERT INTO mmo_vpl VALUES ("MT18_33","070_18_33","MAT","18","33","33","Sa kangg pasiv in hong, le nambe vaati om game gakam pasiv in omaaho sen muuh nawiing kul tii-to nambêênja le?’ ");
INSERT INTO mmo_vpl VALUES ("MT18_34","070_18_34","MAT","18","34","34","+ o 18:34 Mat 5:25-26*Tombe yite yêêv ahekalin-ambe hatung lokala kalaambus in lambu nivaane vu be mando, de yoo monambu dôôk yêêv-ate nyevahaan pin-ambe jung na le mem. ");
INSERT INTO mmo_vpl VALUES ("MT18_35","070_18_35","MAT","18","35","35","+ o 18:35 Mat 6:15; Mak 11:25; Ep 4:32; Kol 3:13*Om sa naanêêl vu ham naambe ham ti ti pin, ham-ame kawiiy halim-asote va nipaya na valok-ate lôôt e, ond Aamangg sen nando baandonii-to le biing vu ham naambe sen yêêv tii-ju wiing vu yite kul vahaa-to.” ");
INSERT INTO mmo_vpl VALUES ("MT19_1","070_19_1","MAT","19","1","1","Yesu nêêl vakasin-anjo lung la tonde havuuh Galili de la taaku Yudia vahaan sen neep bel bop Yoladan vaaluu-to, ");
INSERT INTO mmo_vpl VALUES ("MT19_2","070_19_2","MAT","19","2","2","tombe hil ngeeyaata taamuyin yi be lalaa-ju, tombe wiing-ambe silate hil anilakin nind vasa lak. ");
INSERT INTO mmo_vpl VALUES ("MT19_3","070_19_3","MAT","19","3","3","+ o 19:3 Mat 16:1*Tombe hil Palisai heey lala vu in nambe sahi yi, om lalingin nambe, “Omaaho ti bapuuh vane jak vakasin ti jeen ond lohvu tanasin me malis?” ");
INSERT INTO mmo_vpl VALUES ("MT19_4","070_19_4","MAT","19","4","4","+ o 19:4 Jen 1:27; 5:2*Le Yesu lingin sil nambe, “Mak vakasin sen neep hôôk Anutu-te kaapiyaa-to ond ham-ame asevin mava? Nambe Anutu hatung va pin vu nyendoos, be hatung omaahonôôn moow ayuuh vêêh, ");
INSERT INTO mmo_vpl VALUES ("MT19_5","070_19_5","MAT","19","5","5","+ o 19:5 Jen 2:24; Ep 5:31*tonde Anutu nêêl nambe, ‘Nambêênja om moow e gavuuh mangganaan ayuuh tangganaan de gako vêêh-ambe yuuh mando javuh ti be yuuh daatu nôôn timu, ");
INSERT INTO mmo_vpl VALUES ("MT19_6","070_19_6","MAT","19","6","6","de yuuh-ame yuuh e, nganjo yuuh latu nôôn timu.’ Om va sen Anutu wiing-ambe tu nôôn timuu-to ond ango me-kahe le.” ");
INSERT INTO mmo_vpl VALUES ("MT19_7","070_19_7","MAT","19","7","7","+ o 19:7 Diu 24:1-4; Mat 5:31*Tombe hil Palisai lanêêl vu nambe, “Om nambe vaati sen Mose nêêl tanasin nambe omaaho ti kaavu kaapiya sen bapuuh vanêê-to be bu vu le mem bapuuh?” ");
INSERT INTO mmo_vpl VALUES ("MT19_8","070_19_8","MAT","19","8","8","Tombe Yesu nêêl laah vu sil nambe, “Mose lak ham anim nambe ham alompayo niwêêk ak, ondeey liinggis nambe ham bapuuh vanem-aso, nganjo vu bôôy nyendoos ond me-nambêênjo le. ");
INSERT INTO mmo_vpl VALUES ("MT19_9","070_19_9","MAT","19","9","9","+ o 19:9 Mat 5:32; 1Ko 7:10-11*Sa naanêêl vu ham naambe omaaho ti vane me-wiing baayamb e, le laya havuuh-ande hako vêêh ango, ond omaahôô-ja wiing baayamb.” ");
INSERT INTO mmo_vpl VALUES ("MT19_10","070_19_10","MAT","19","10","10","+ o 19:10 1Ko 7:1-2,7-9*Tombe yite maanggêêm-aso lanêêl vu nambe, “Naambe moow osin vêêh-ate vakasin neep nambêênja, ond mam moow-ame gako vêêh e, jip.” ");
INSERT INTO mmo_vpl VALUES ("MT19_11","070_19_11","MAT","19","11","11","Le nêêl vu sil nambe, “Hil pin-ame lalohvu nambe lambiing nohvu vakasin-anjo le, malis, hil sen Anutu vu niwêêk vu sil-ato ond mem sil lalohvu nambe lambiing nohvu. ");
INSERT INTO mmo_vpl VALUES ("MT19_12","070_19_12","MAT","19","12","12","Hil vaalu dando ond taandin lako sil lohvu nambe me-le gako vêêh e, de vaalu ond omaahonôôn lawiing sil anind paya lak, om me-dako vêêh e, tonde hil vaalu kand navu nambe Anutu nanggin sil-ato be yoo dalakin sil nivasa de me-dako vêêh e. Omaaho ti lohvu nambe biing nohvu vakasin-anjo ond biing.” ");
INSERT INTO mmo_vpl VALUES ("MT19_13","070_19_13","MAT","19","13","13","Tonde hil lako unoopasiv laam vu Yesu in nambe gambe nama jak sil osin nohak ak sil, le yite maanggêêm-aso lanêêl hil-anju, ");
INSERT INTO mmo_vpl VALUES ("MT19_14","070_19_14","MAT","19","14","14","+ o 19:14 Mat 18:2-3*le Yesu nêêl nambe, “Ham baale de unoopasiv-anju lanaam vu sa le. Ham-ame anggilin sil e, in Anutu nanggin hil nambêênja having.” ");
INSERT INTO mmo_vpl VALUES ("MT19_15","070_19_15","MAT","19","15","15","Tonde hambe nama lak sil vêêl e mem la taaku ango. ");
INSERT INTO mmo_vpl VALUES ("MT19_16","070_19_16","MAT","19","16","16","Tombe omaaho ti la valup vu Yesu be lingin nambe, “Kaputung, saambiing va nivasa vaati le mem sa mando metumin danggata?” ");
INSERT INTO mmo_vpl VALUES ("MT19_17","070_19_17","MAT","19","17","17","+ o 19:17 Lev 18:5; Luk 10:28*Tombe Yesu nêêl vu nambe, “Galingin sa in va nivasa in? Yik Anutu timu nivasa, om gawiingin nambe omando metumin ond osamu tanasin pin.” ");
INSERT INTO mmo_vpl VALUES ("MT19_18","070_19_18","MAT","19","18","18","Le omaahôô-ju lingin nambe, “Tanasin vaati?” Tombe Yesu nêêl vu nambe, “Tanasin nambe game ganyiis omaahonôôn jimb e, game gambiing baayamb e, de game gambiing hôôndak e, game tatuhin vakasin jak omaaho ango le, ");
INSERT INTO mmo_vpl VALUES ("MT19_19","070_19_19","MAT","19","19","19","+ o 19:19 Eks 20:12-16; Diu 5:16-20; Lev 19:18; Lom 13:9*onggako mom ayuuh tam jak, de gahem gaving hil sen dando ngaaho vu hong naambe sen goo gahem naving hong-ato.” ");
INSERT INTO mmo_vpl VALUES ("MT19_20","070_19_20","MAT","19","20","20","Tombe maanggêêm-anjuuto nêêl vu nambe, “Va pin-anja sa samu lung la, de vaati naahen?” ");
INSERT INTO mmo_vpl VALUES ("MT19_21","070_19_21","MAT","19","21","21","+ o 19:21 Mat 6:20; Luk 12:33; Sin 2:45; 4:34-37*Tombe Yesu nêêl vu nambe, “Gahem having nambe onaatu omaaho nivasa nôôn ond ganaah-ambe gambu gate va pin na be hil baanggo, de gambu mone na vu hil sen dativak in va yuuh amêê-to, in mem gale gako nôôn nivasa vu baandoni, tonde ganaam taamuyin sa.” ");
INSERT INTO mmo_vpl VALUES ("MT19_22","070_19_22","MAT","19","22","22","Maanggêêm tii-to hango vakasin-anju tombe laah osin lopayo nimeen lôôt, in yite kupak ngeeyaata lôôt nando. ");
INSERT INTO mmo_vpl VALUES ("MT19_23","070_19_23","MAT","19","23","23","Tombe Yesu nêêl vu yite maanggêêm-aso nambe, “Sa naanêêl keen vu ham naambe hil sen silate va ngeeyaataa-to, ond le lanôôhin in nambe landukana gaving Anutu-te hil. ");
INSERT INTO mmo_vpl VALUES ("MT19_24","070_19_24","MAT","19","24","24","Tonde yik sa naanêêl vu ham naambe bik kamel ti me-lohvu nambe dokana lulak vuun e, le nôôhin, de hil sen silate va ngeeyaataa-to ond yik me-lalohvu nambe landukana gaving Anutu-te hil e, le lanôôhin lôôt.” ");
INSERT INTO mmo_vpl VALUES ("MT19_25","070_19_25","MAT","19","25","25","Tombe yite maanggêêm-aso lango vakasin-anjo be lavindis bopaata lôôt, be lalingin nambe, “Om lati lohvu nambe mando metumin danggata?” ");
INSERT INTO mmo_vpl VALUES ("MT19_26","070_19_26","MAT","19","26","26","+ o 19:26 Jen 18:14; Iyop 42:2*Tombe Yesu me la vu sil-ande nêêl vu sil nambe, “Omaahonôôn-ame lalohvu va nambêênjo le, lemu Anutu timu yoo lohvu biing va pin.” ");
INSERT INTO mmo_vpl VALUES ("MT19_27","070_19_27","MAT","19","27","27","Tombe Pita nêêl laah vu nambe, “Gangge, hey-anjo ond hey havuuh va pin la de hey navu taamuyin hong, tombe le naambe vaati vu hey?” ");
INSERT INTO mmo_vpl VALUES ("MT19_28","070_19_28","MAT","19","28","28","+ o 19:28 Mat 25:31; Luk 22:30; Taato 3:21; Dan 7:9-10*Tombe Yesu nêêl vu sil nambe, “Sa naanêêl keen vu ham naambe vu busin taamusin sen va pin naatu moos jak, tonde Omaahonôôn Noow mando jak omaaho lulemak-ate sia osin yite nikaapulis, ond mem hôôk busin-anju ham nomaayuuh-ambe laam yuuh sen ham navu taamuyin saa-to, ham e mando jak sia nomaayuuh-ambe laam yuuh-ato gaving sa, tombe ham e gangoyin hil Islel dangga nomaayuuh-ambe laam yuuh-ato silate vakasin. ");
INSERT INTO mmo_vpl VALUES ("MT19_29","070_19_29","MAT","19","29","29","+ o 19:29 Hiblu 10:34*De hil pin sen kand navu sa haalengg-ambe lavuuh silate bayêên me halindin, me vangaandin, me maandin, me taandin, me noondin osin silate ngaanggis, ond sil e gako nivasa nyevahaan ngeeyaata lôôt savok sen-anjo na, tonde sil e mando metumin danggata osin danggata. ");
INSERT INTO mmo_vpl VALUES ("MT19_30","070_19_30","MAT","19","30","30","+ o 19:30 Mat 20:16; Luk 13:30*Lemu hil sen lamunggin-ato ond ngeeyaata le lanaah taamu, de hil sen davu taamuu-to ond ngeeyaata le lana daamunggin.” ");
INSERT INTO mmo_vpl VALUES ("MT20_1","070_20_1","MAT","20","1","1","+ o 20:1 Mat 21:33*“Ke, Anutu nanggin yite hil-ato ond lohvu kul wain mangganaan ti kandi hôôk samiinaanôôn-ambe la in gako hil-ambe lana lambiing kul in yite wain. ");
INSERT INTO mmo_vpl VALUES ("MT20_2","070_20_2","MAT","20","2","2","Om la vakaas having hil kul vaalu be laliinggis nambe lambiing kul hôôk busin tii-ju de baanggo sil jak mone doo-ti ti tonde mem wiing sil lala yite kul wain. ");
INSERT INTO mmo_vpl VALUES ("MT20_3","070_20_3","MAT","20","3","3","Tonde 9 kilok samiinaanôôn atombe laah hato, le yi de omaaheey daale malis lak talind, ");
INSERT INTO mmo_vpl VALUES ("MT20_4","070_20_4","MAT","20","4","4","tombe nêêl vu sil nambe, ‘Ham ana ambiing sate kul wain gaving, de sale baanggo ham nivasa.’ ");
INSERT INTO mmo_vpl VALUES ("MT20_5","070_20_5","MAT","20","5","5","Tombe sil lala kul, tonde 12 kilok vandiisin osin 3 kilok soosin ond yik laah hato be wiing nambêênju vu hil vaalu having. ");
INSERT INTO mmo_vpl VALUES ("MT20_6","070_20_6","MAT","20","6","6","Tonde hôôk 5 kilok soosin atombe laah hato le yi de omaaheey daale, tombe nêêl vu sil nambe, ‘Nambe vaati sen ham naalêê-jo vandiisin-aandiin-ande kul ma?’ ");
INSERT INTO mmo_vpl VALUES ("MT20_7","070_20_7","MAT","20","7","7","Tombe lanêêl vu nambe, ‘Mu omaaho ti me-vu kul vu hey e.’ Tombe nêêl vu sil nambe, ‘Om ham ana ambiing sate kul wain gaving.’ ");
INSERT INTO mmo_vpl VALUES ("MT20_8","070_20_8","MAT","20","8","8","+ o 20:8 Lev 19:13; Diu 24:15*“Tonde busin hôôk atombe kul wain mangganaan nêêl vu yite omaaho sen nanggin hil kul-ato nambe, ‘Oteey hil kul lanaam-ambe ombaanggo sil, ond ombaanggo nanjip hil sen lalaam kul hôôk soosin-ambe na naatok na hil sen lalaam kul hôôk samiin-ato.’ ");
INSERT INTO mmo_vpl VALUES ("MT20_9","070_20_9","MAT","20","9","9","Om vaanggo sil atombe hil sen lawiing kul hôôk 5 kilok soosin-ato lako mone doo-ti ti, ");
INSERT INTO mmo_vpl VALUES ("MT20_10","070_20_10","MAT","20","10","10","tonde hil sen lawiing kul munggin hôôk samiinaanôôn-ato lala vu, tombe kand vu nambe mak sil e gako mone ngeeyaata lôôt savok hil vaalu, le ma, yik sil lako mone doo-ti ti having. ");
INSERT INTO mmo_vpl VALUES ("MT20_11","070_20_11","MAT","20","11","11","Lako lemu lanyuung hôôk vu kul wain mangganaan ");
INSERT INTO mmo_vpl VALUES ("MT20_12","070_20_12","MAT","20","12","12","nambe, ‘Hil-anju lalaam hôôk soosin-ambe lawiing kul lohvu taaku me timu, nganjo hey amu aawiing kul bopaata vandiisinaandiin-ambe taaku ya hey lôôt, le yik ovaanggo hey va timu nambe sil-ato.’ ");
INSERT INTO mmo_vpl VALUES ("MT20_13","070_20_13","MAT","20","13","13","Tombe kul mangganaan nêêl laah vu sil ti nambe, ‘Hali, same aawiing nipaya vu hong e. Galiinggis in sate vakasin gêên nambe sale baanggo hong jak mone doo-tiito, ");
INSERT INTO mmo_vpl VALUES ("MT20_14","070_20_14","MAT","20","14","14","om onggako gate mone be gana. Soo aawiingin ondeey saavu mone vu hil sen lalup-ambe lawiing kul taamu, yik lohvu sen saavu vu hong-ato. ");
INSERT INTO mmo_vpl VALUES ("MT20_15","070_20_15","MAT","20","15","15","Naambe saambiing vati jak soo sate monêê-jo ond yik yoo neep vu sa. Saawiing va nivasa, le nambe vaati sen gahem anipaya in?’ ");
INSERT INTO mmo_vpl VALUES ("MT20_16","070_20_16","MAT","20","16","16","+ o 20:16 Mat 19:30; Mak 10:31; Luk 13:30*“Ke, om hil sen davu taamuu-to le daamunggin, de hil sen lamunggin-ato le lanaah taamu.” ");
INSERT INTO mmo_vpl VALUES ("MT20_17","070_20_17","MAT","20","17","17","Yesu lak-ambe la in na Yelusalem, tombe hako yite maanggêêm nomaayuuh-ambe laam yuuh-ato, be sil oo lala, tombe mem nêêl vu sil nambe, ");
INSERT INTO mmo_vpl VALUES ("MT20_18","070_20_18","MAT","20","18","18","+ o 20:18 Mat 16:21; 17:22-23*“Ham gango le, yiiy navu ana balup Yelusalem, tombe hil davu lambu Omaahonôôn Noow dukana kul vaha sen datung salivangin-ato silate yêêv-aso osin tanasin dangga-so namand, tombe le daanêêl naambe lanyiis-ambe jimb. ");
INSERT INTO mmo_vpl VALUES ("MT20_19","070_20_19","MAT","20","19","19","+ o 20:19 1Ko 15:4*Tonde le lambu dukana hil vaalu sen sil-ame Yudaa-to namand, be sil pale yi, osin gaveek yi, de lanyiis ak haah pako, tonde busin naatu yaal e mem kandi jak jesin naah.” ");
INSERT INTO mmo_vpl VALUES ("MT20_20","070_20_20","MAT","20","20","20","Tombe Sebedi vane hako noow ayuuh, be yaal lala vu Yesu, tombe hatung kaatu vu in nambe kataangg vati vu yi, ");
INSERT INTO mmo_vpl VALUES ("MT20_21","070_20_21","MAT","20","21","21","+ o 20:21 Mat 19:28; Luk 22:30*tombe Yesu lingin nambe, “Galaam in vaati?” Tombe nêêl vu Yesu nambe, “Onaanêêl-ande vu taamusin sen onaatu omaaho lulemak-ambe ongganggin gate hil-ato, ond sa noongg ayuuh-anjo daatu yêêv yuuh, tombe ango le mando onamam vasa de ango mando onamam kêênj gaving hong.” ");
INSERT INTO mmo_vpl VALUES ("MT20_22","070_20_22","MAT","20","22","22","+ o 20:22 Mat 26:39; Jon 18:11*Le Yesu nêêl laah vu nambe, “Va sen maal navu kataangg-anja ond maal doosin danggakook. Kap nimeen-ate sen sa navu naanum hôôk-ato ond malohvu nambe naanum hôôk a?” Le yuuh lanêêl vu nambe, “De, haay aalohvu.” ");
INSERT INTO mmo_vpl VALUES ("MT20_23","070_20_23","MAT","20","23","23","Tombe Yesu nêêl vu yuuh nambe, “Nimeen sen sa navu baaku ond male baaku, lemu vakasin sen manêêl nambe muuh naatu yêêv-ambe muuh mando sa namangg vasa osin sa namangg kêênj gaving saa-to ond same sate va in nambe sa naanêêl e, nganjo hil sen Aamangg samu taaku vu sil-ato ond sil e mando jak.” ");
INSERT INTO mmo_vpl VALUES ("MT20_24","070_20_24","MAT","20","24","24","Maanggêêm nomaayuuh-ato langoyin vakasin-anju tombe sil alondpayo nipaya vu yuuh hali, ");
INSERT INTO mmo_vpl VALUES ("MT20_25","070_20_25","MAT","20","25","25","+ o 20:25 Luk 22:25-26*le Yesu teey sil lalaam-ambe nêêl nambe, “Ham alak ni nambe hil vaalu-te yêêv sen danggin sil-ato ond danêêl vakasin osin niwêêk lôôt-ambe daanggôôl silate hil, de silate himbop oo danggin sil niwêêk lôôt, ");
INSERT INTO mmo_vpl VALUES ("MT20_26","070_20_26","MAT","20","26","26","+ o 20:26 Mat 23:11; Mak 9:35; Luk 9:48*lemu ham ond ham-ame ambiing naambêênja le. Nganjo ham ti wiingin nambe naatu bop, ond yoo biing va naambe sen yi omaaho malis ti in dôôvu ham pin. ");
INSERT INTO mmo_vpl VALUES ("MT20_27","070_20_27","MAT","20","27","27","De omaaho ti wiingin nambe naatu hamate lukook-ambe naamunggin, ond yoo naatu ham pin-ate hil kul malis amu. ");
INSERT INTO mmo_vpl VALUES ("MT20_28","070_20_28","MAT","20","28","28","+ o 20:28 Luk 22:27; Pil 2:7; 1Ti 2:6*Yik nambe sen Omaahonôôn Noow, ond me-laam in nambe hil lambiing kul vu yi le, nganjo laam in nambe biing kul vu omaahonôôn osin jimb in baanggo omaahonôôn ngeeyaata naah.” ");
INSERT INTO mmo_vpl VALUES ("MT20_29","070_20_29","MAT","20","29","29","Yesu having yite maanggêêm-aso be sil lalup Yeliko be lala, tombe hil ngeeyaata taamuyin. ");
INSERT INTO mmo_vpl VALUES ("MT20_30","070_20_30","MAT","20","30","30","+ o 20:30 Mat 9:27; 15:22*Tombe omaaho mekanu yuuh dando hôôk mop nanyendangga, ond yuuh lango nambe Yesu valup, tombe yuuh lateey nambe, “Omaaho Bop, hong sen gate danggakook neep vu Devit-ato, gakam pasiv in haay e.” ");
INSERT INTO mmo_vpl VALUES ("MT20_31","070_20_31","MAT","20","31","31","Tombe hil ngeeyaataa-ju lanêêl yuuh nambe yuuh lavand nama, le ma de yuuh lateey bopaata nambe, “Omaaho Bop, hong sen gate danggakook neep vu Devit-ato, gakam pasiv in haay e.” ");
INSERT INTO mmo_vpl VALUES ("MT20_32","070_20_32","MAT","20","32","32","Tombe Yesu naale be teey yuuh lalaam-ambe nêêl nambe, “De mawiingin nambe saambiing vaati vu muuh?” ");
INSERT INTO mmo_vpl VALUES ("MT20_33","070_20_33","MAT","20","33","33","Le yuuh lanêêl vu nambe, “Omaaho Bop, gambiing-ambe haay amengg naatum.” ");
INSERT INTO mmo_vpl VALUES ("MT20_34","070_20_34","MAT","20","34","34","Tombe Yesu ka pasiv in yuuh om hambe nama lak yuuh amend, tombe yik yuuh amend tum pavis-ambe yuuh taamuyin Yesu be lala. ");
INSERT INTO mmo_vpl VALUES ("MT21_1","070_21_1","MAT","21","1","1","Sil lalup ngaaho vu bayêên Betpaasi vu kandu Oliv in nambe daatok na Yelusalem, le mem Yesu wiing yite maanggêêm yuuh lamunggin-ambe lala. ");
INSERT INTO mmo_vpl VALUES ("MT21_2","070_21_2","MAT","21","2","2","Tombe nêêl vu yuuh nambe, “Mana be mandukana bayêên Betpaasii-ju ond male angge donggi ti pavis, sil talu be naale having noow, ond muuh kavaayin-ambe gako naam vu sa. ");
INSERT INTO mmo_vpl VALUES ("MT21_3","070_21_3","MAT","21","3","3","+ o 21:3 Mat 26:18*De omaaho ti naanêêl vakasin ti vu muuh, ond muuh naanêêl naambe, ‘Omaaho Bop wiingin nambe biing kul ti jak pavis e mem gako nom.’” ");
INSERT INTO mmo_vpl VALUES ("MT21_4","070_21_4","MAT","21","4","4","Ke, lawiing nambêênjo om Anutu-te vakasin sen omaaho ti nêêl langaah bôôy-ato nôôn ak nambe, ");
INSERT INTO mmo_vpl VALUES ("MT21_5","070_21_5","MAT","21","5","5","+ o 21:5 Ais 62:11; Sek 9:9*“Ham naanêêl vu hil Saion naambe, ‘Ham angge hamate omaaho lulemak nalaas vu ham. Yi omaaho osin melaas, tombe lakando donggi be nalaas vu ham, yik lakando donggi noow ti be nalaas.’” ");
INSERT INTO mmo_vpl VALUES ("MT21_6","070_21_6","MAT","21","6","6","Ke, tonde maanggêêm ayuuh lala lawiing lohvu vakasin sen Yesu nêêl vu yuuh-ato. ");
INSERT INTO mmo_vpl VALUES ("MT21_7","070_21_7","MAT","21","7","7","Yuuh lako donggi tangganaan having noow, tombe yuuh lakaah yuuhate lolop-ambe lavaah lakala donggi yuuh damind, le mem Yesu lakando be la. ");
INSERT INTO mmo_vpl VALUES ("MT21_8","070_21_8","MAT","21","8","8","+ o 21:8 2King 9:13*Tonde hil ngeeyaata lakaah silate lolop-ambe lavaah neep mopaatôôv, de hil vaalu lasap haah nama osin lis-ambe lambe neep mop in nambe Yesu gato jêês-ambe na. ");
INSERT INTO mmo_vpl VALUES ("MT21_9","070_21_9","MAT","21","9","9","+ o 21:9 Saam 118:25-26*Tombe hil vaalu damunggin, de vaalu davu taamu be sil pin daakôôhin nambe, “Ham-o, yiiy lavangg dôôk omaaho sen laam vu danggakook Devit-anja. Anutu biing samu samu vu omaahôô-ja in laam ak Omaaho Bop haale. De yiiy gako Anutu haale jak nanjip baandoni.” ");
INSERT INTO mmo_vpl VALUES ("MT21_10","070_21_10","MAT","21","10","10","Yesu tok la Yelusalem, tombe hil pin lavindis de lawiing nindaandun bopaata de lateey nambe, “Omaaho latii-ja?” ");
INSERT INTO mmo_vpl VALUES ("MT21_11","070_21_11","MAT","21","11","11","+ o 21:11 Mat 21:46*Tombe hil ngeeyaata sen laving yii-to ond lanêêl nambe, “Omaaho sen nanêêl Anutu-te vakasin langaah-ato Yesu vu Nasaalet Galili.” ");
INSERT INTO mmo_vpl VALUES ("MT21_12","070_21_12","MAT","21","12","12","Tombe Yesu lokala Anutu-te dumb bop alpayo, be hatiiy hil pin sen daanggo va salivangin-ate hôôk dumb alopayôô-to be lala voon, tonde hil sen davu Yuda osin Lom-ate mone nyevaha-vahaan hôôk yii-to, ond kayovakin silate tavol, de hil sen daanggo manak tumbaliiy in hil gatung naatu salivangin-ato, ond kaasêêh silate sia la, ");
INSERT INTO mmo_vpl VALUES ("MT21_13","070_21_13","MAT","21","13","13","+ o 21:13 Ais 56:7; Jer 7:11*tonde nêêl vu sil nambe, “Anutu-te vakasin neep hôôk kaapiya nambe, ‘Sate bayêên ond le daanêêl naambe bayêên lohakin,’ lemu ham awiing-ambe tu hil hôôndak-ate bayêên sen dahôôpis hôôk-ato.” ");
INSERT INTO mmo_vpl VALUES ("MT21_14","070_21_14","MAT","21","14","14","Lung laa tonde hil vaalu mend kanu osin vahand anipaya lala vu Yesu hôôk dumb alo be wiing sil anind vasa lak. ");
INSERT INTO mmo_vpl VALUES ("MT21_15","070_21_15","MAT","21","15","15","Lemu kul vaha sen datung salivangin-ato silate yêêv-aso osin tanasin dangga-so layi de nawiing va nivasa nambêênju, tonde lango unoopasiv daakôôhin hôôk dumb alo nambe, “Ham-o, yiiy lavangg dôôk omaaho sen laam vu danggakook Devit-anja.” Tombe sil ahend kalin, ");
INSERT INTO mmo_vpl VALUES ("MT21_16","070_21_16","MAT","21","16","16","+ o 21:16 Saam 8:2*om lalingin Yesu nambe, “Game hango vakasin sen danêêl-anjo le?” Tombe Yesu nêêl laah vu sil nambe, “Êê-e, sa hango. De ham-ame asevin vakasin sen neep hôôk Anutu-te kaapiyaa-to le? Nambe, ‘Otaahu unoopasiv sen daahen dakaas paya, osin sen taandin davu sum vu sil-ato, de lavand nahôôk hong nivasa lôôt.’” ");
INSERT INTO mmo_vpl VALUES ("MT21_17","070_21_17","MAT","21","17","17","Tombe havuuh sil osin taaku bop-anju de having yite maanggêêm-aso be lalaah deep Betaani. ");
INSERT INTO mmo_vpl VALUES ("MT21_18","070_21_18","MAT","21","18","18","Tombe Yesu kandi hôôk samiinaanôôn-ambe laah in na taaku bop, tombe yimb ahe. ");
INSERT INTO mmo_vpl VALUES ("MT21_19","070_21_19","MAT","21","19","19","+ o 21:19 Luk 13:6*Tonde yi haah bangguk ti naale mop nanyendangga tombe la ngaaho vu be yi le nôôn ma, de lis malis amu, tombe nêêl vu haah-anju nambe, “Game le ganyiis nôôn jesin naah e, nama lôôt.” Tombe haah bangguk-anjuuto bambôôv la pavis. ");
INSERT INTO mmo_vpl VALUES ("MT21_20","070_21_20","MAT","21","20","20","Yesu-te maanggêêm-aso layi tombe lavindis lôôt, de lanêêl nambe, “Nambe vaati sen haah bangguk-anju bambôôv la pavis?” ");
INSERT INTO mmo_vpl VALUES ("MT21_21","070_21_21","MAT","21","21","21","+ o 21:21 Mat 17:20; Luk 17:6; 1Ko 13:2; Jon 14:12*Tombe Yesu nêêl laah vu sil nambe, “Sa naanêêl keen vu ham naambe ham ambiing gaving niwêêk-ande ham-ame kam yu-yuuh e, ond mem ham e ambiing naambe sen saawiing vu haah bangguk-anjo. Tombe ham-ame le ambiing vaa-jo mu le, malis, yik ham naanêêl vu kanduu-ju naambe, ‘Okandi jak-ambe gandukana lôôy,’ ond le na. ");
INSERT INTO mmo_vpl VALUES ("MT21_22","070_21_22","MAT","21","22","22","+ o 21:22 Mat 7:7-11; 18:19; Jon 14:13-14*Naambe ham ambiing gaving Anutu naambe va sen ham navu kataangg hôôk lohakin-ato ond le biing nôôn jak, ond ham e gako nôôn.” ");
INSERT INTO mmo_vpl VALUES ("MT21_23","070_21_23","MAT","21","23","23","+ o 21:23 Jon 2:18*Tombe Yesu lokalaah Anutu-te dumb bop alo be monanêêl tanasin vu hil, tombe kul vaha sen datung salivangin-ato silate yêêv-aso osin Islel-ate himbop-aso lala vu be lalingin nambe, “Lati nêêl-ambe galaam nawiing va pin-anjo? Onawiing kul-anjo lak lati haale?” ");
INSERT INTO mmo_vpl VALUES ("MT21_24","070_21_24","MAT","21","24","24","Tombe Yesu nêêl laah vu sil nambe, “Om yik sa having, saanjingin ham in vakasin ti be ham naanêêl nom vu sa, le mem sale naanêêl omaaho sen sa naawiing kul lak haalêê-to nos vu ham. ");
INSERT INTO mmo_vpl VALUES ("MT21_25","070_21_25","MAT","21","25","25","De Jon nalipis hil-ato ond lati nêêl? Anutu nêêl me omaahonôôn yoo lanêêl?” Tombe sil oo lakaas in nambe, “Yiiy naanêêl naambe Anutu nêêl ond le naanêêl vu yiiy naambe, ‘Le nambe tana ham-ame awii-having yi le?’ ");
INSERT INTO mmo_vpl VALUES ("MT21_26","070_21_26","MAT","21","26","26","+ o 21:26 Mat 14:5; 21:46*Me yiiy naanêêl naambe omaahonôôn lanêêl-ambe Jon nalipis hil, lemu yiiy naayêênin hil ngeeyaataa-ju in sil pin lako Jon ak nambe nanêêl Anutu-te vakasin langaah.” ");
INSERT INTO mmo_vpl VALUES ("MT21_27","070_21_27","MAT","21","27","27","Om lanêêl laah vu Yesu nambe, “Hey doosin.” Tombe Yesu nêêl vu sil nambe, “Om same le naanêêl omaaho sen sa naawiing kul lak haalêê-to vu ham e.” ");
INSERT INTO mmo_vpl VALUES ("MT21_28","070_21_28","MAT","21","28","28","+ o 21:28 Luk 15:11*“Ham akam bu le. Omaaho ti noow yuuh dando, tombe la vu nowaatuk-ambe nêêl vu nambe, ‘Tuk-e, peey-anjo gana gambiing sate kul wain.’ ");
INSERT INTO mmo_vpl VALUES ("MT21_29","070_21_29","MAT","21","29","29","Tombe nowaatuk nêêl laah nambe, ‘Sa nimbaya,’ le sim hilin lopayo de la wiing kul wain. ");
INSERT INTO mmo_vpl VALUES ("MT21_30","070_21_30","MAT","21","30","30","Tonde yik mangganaan la nêêl vu nowaamiin having, tombe liinggis nambe, ‘Êê-e aamangg, sale ana,’ le ma de me-la le. ");
INSERT INTO mmo_vpl VALUES ("MT21_31","070_21_31","MAT","21","31","31","Om noow ango tana wiing lohvu mangganaan lava?” Tombe lanêêl laah nambe, “Nowaatuk.” Tombe Yesu nêêl vu sil nambe, “Sa naanêêl keen vu ham naambe hil sen dako taakis osin vêêh baayamb-aso dawii-having-ambe dalokala having Anutu-te hil damunggin ham. ");
INSERT INTO mmo_vpl VALUES ("MT21_32","070_21_32","MAT","21","32","32","+ o 21:32 Luk 3:12; 7:29-30*In Jon valup-ambe taato mopaatôôv anivalok vu ham, le ham-ame awii-having yi le, malis. Lemu hil sen dako taakis osin vêêh baayamb-aso lawii-having yi, tonde ham ahe, le sim ham-ame ahilin ham alompayo be ham-ame awii-having yi le.” ");
INSERT INTO mmo_vpl VALUES ("MT21_33","070_21_33","MAT","21","33","33","+ o 21:33 Ais 5:1-2; Mat 25:14*“Ham gango vakasin pakwesin ango. Himbop ti vaalôôh kul wain ti be vaaku ayak hilin, de haav taaku sen davu samu wain-aanôôn aniluk hôôk-ato, tonde haav bayêên vaha salak ti in nambe hil baale hôôk-ambe mend in kul wain-anju having. Tonde vu kul-anju lokala hil vaalu namand-ambe sil danggin, tonde yik la taaku dinaandiin lôôt. ");
INSERT INTO mmo_vpl VALUES ("MT21_34","070_21_34","MAT","21","34","34","Busin ngaaho lak in wain naasuuh, tombe kul mangganaan wiing yite hil kul lala vu hil sen danggin kul wain-ato in nambe sil gako nôôn vaalu vu yi, ");
INSERT INTO mmo_vpl VALUES ("MT21_35","070_21_35","MAT","21","35","35","+ o 21:35 Mat 22:6*le ma de hil sen danggin kul-ato lalôôh yite hil kul-aso de laveek ti, de layiis ango be yimb, de sil tanga ti lak tatuuh. ");
INSERT INTO mmo_vpl VALUES ("MT21_36","070_21_36","MAT","21","36","36","Tombe kul mangganaan wiing yite hil kul vaalu ngeeyaata savok vaalu munggin-ato tombe sil lalaah yesin, le hil sen danggin yite kul-ato, ond yik lawiing nambêênju vu sil yesin laah. ");
INSERT INTO mmo_vpl VALUES ("MT21_37","070_21_37","MAT","21","37","37","Tonde sim wiing noow la vu sil lakaneep ahus, in ka vu nambe, ‘Manyinjo sa noongg om sil e lanjêênin yi.’ ");
INSERT INTO mmo_vpl VALUES ("MT21_38","070_21_38","MAT","21","38","38","+ o 21:38 Mat 27:18*Lemu hil sen danggin kul wain-ato layi noow, tombe yoo lanêêl vu sil nambe, ‘Omaaho sen-anju le gako mangganaan-ate va pin om ham-o, yaanyiis-ambe jimb-ande kul-anjo naatu yate va.’ ");
INSERT INTO mmo_vpl VALUES ("MT21_39","070_21_39","MAT","21","39","39","+ o 21:39 Hiblu 13:12*Om lalôôh-ambe lakôôh la voon, de layiis-ambe yimb. ");
INSERT INTO mmo_vpl VALUES ("MT21_40","070_21_40","MAT","21","40","40","“Om kul wain mangganaan nom gato ond le biing naambe vaati vu hil sen danggin yite kul-anjuuto?” ");
INSERT INTO mmo_vpl VALUES ("MT21_41","070_21_41","MAT","21","41","41","Tombe lanêêl vu nambe, “Le nyiis hil anipayaa-ju be lana mend nama lôôt, de bu kul wain-anju be hil vaalu ganggin, le mem busin sen lanjul nôôn-ato ond mem lambu vaalu vu yi.” ");
INSERT INTO mmo_vpl VALUES ("MT21_42","070_21_42","MAT","21","42","42","+ o 21:42 Saam 118:22-23; Sin 4:11; Lom 9:33; 1Pi 2:6-8*Tombe Yesu nêêl vu sil nambe, “Mak ham-ame asevin Anutu-te vakasin sen neep hôôk kaapiyaa-to mava? Nambe, ‘Tatuuh ti sen hil kul-aso nind baya nambe me-landaav bayêên ak e, ond gêên tu bayêên ahelasu-te kook aniwêêk. Omaaho Bop wiing vaa-jo be yaahe nambe yoo nivasa nôôn.’ ");
INSERT INTO mmo_vpl VALUES ("MT21_43","070_21_43","MAT","21","43","43","Om sa naanêêl vu ham naambe Anutu le juus ham naambe ham-ame mando gaving yite hil e, tombe le jiinggis vu hil vaalu sen sil lambiing-ambe yite vakasin nôôn jak-ato naambe sil landukana gaving yite hil. ");
INSERT INTO mmo_vpl VALUES ("MT21_44","070_21_44","MAT","21","44","44","+ o 21:44 Dan 2:44-45*De naambe omaaho ti dupake be nyiis yi jak tatuuh-anju ond le naamuvin daka daka, le naambe tatuuh-anju gato tanga omaaho ti, ond le matelak lôôt.” ");
INSERT INTO mmo_vpl VALUES ("MT21_45","070_21_45","MAT","21","45","45","Kul vaha sen datung salivangin-ato silate yêêv-aso osin hil Palisai lango vakasin pakwesin sen Yesu nêêl-anjo, tombe lalak ni nambe nanêêl lak sil, ");
INSERT INTO mmo_vpl VALUES ("MT21_46","070_21_46","MAT","21","46","46","+ o 21:46 Mat 21:26*om lawiingin nambe lanôôh yi, le ma de layêênin hil ngeeyaataa-ju, in kand navu nambe Yesu nanêêl Anutu-te vakasin langaah. ");
INSERT INTO mmo_vpl VALUES ("MT22_1","070_22_1","MAT","22","1","1","Yesu nêêl vakasin pakwesin ti vu hil nambe, ");
INSERT INTO mmo_vpl VALUES ("MT22_2","070_22_2","MAT","22","2","2","“Anutu nanggin yite hil-ato ond lohvu omaaho lulemak ti wiing vanôôn bopaata in noow navu gako vêêh-ato. ");
INSERT INTO mmo_vpl VALUES ("MT22_3","070_22_3","MAT","22","3","3","Om wiing yite kul vaha-so be lala lanêêl vu hil sen teey sil lung laa-to nambe lanaam lanja vanôôn, le ma de nind baya be dando nêênd. ");
INSERT INTO mmo_vpl VALUES ("MT22_4","070_22_4","MAT","22","4","4","+ o 22:4 Mat 21:36*Tombe wiing kul vaha vaalu lalaah yesin-ambe nêêl vu sil having nambe, ‘Ham ana naanêêl vu hil sen saateey sil bôôy-ato naambe sa samu sate vanôôn lung la be nando. Saanêêl-ambe layiis kao bo-bop osin noow anituvakin vaalu sen danji bopaataa-to lung la, de sa samu va pin lung la gêên-ambe nando, om ham anaam in angga vanôôn-anjo.’ ");
INSERT INTO mmo_vpl VALUES ("MT22_5","070_22_5","MAT","22","5","5","Om yite kul vaha-so lala lanêêl vakasin-anjo vu sil, le nind baya be me-lango le, de lala danjeen. Ti la yite kulaanôôn, de ango la in ganggin yite tatuva, ");
INSERT INTO mmo_vpl VALUES ("MT22_6","070_22_6","MAT","22","6","6","+ o 22:6 Mat 21:35*de sil vaalu lalôôh omaaho lulemak-ate kul vaha-so de layiis sil-ambe layimb. ");
INSERT INTO mmo_vpl VALUES ("MT22_7","070_22_7","MAT","22","7","7","Tombe omaaho lulemak-anju ahekalin lôôt, be wiing yite hil ngaamong vaha-so lala layiis hil sen layiis yite kul vaha-sôôto be layimb pin lôôt, de lasi kin hôôk silate taaku. ");
INSERT INTO mmo_vpl VALUES ("MT22_8","070_22_8","MAT","22","8","8","Tonde mem omaaho lulemak nêêl vu yite kul vaha-so vaalu nambe, ‘Vanôôn nok lung-ambe nando, le hil sen saateey sil bôôy-ato ond sil anipaya om me-lalaam e, ");
INSERT INTO mmo_vpl VALUES ("MT22_9","070_22_9","MAT","22","9","9","om ham ana baale mop bo-bop, de hil pin sen ham naatovu sil vuu-ju ond ham naanêêl vu sil naambe lanaam lanja vanôôn bop-anjo.’ ");
INSERT INTO mmo_vpl VALUES ("MT22_10","070_22_10","MAT","22","10","10","“Nêêl nambêênjo tombe yite kul vaha-so lala daale mop bop pin-ambe lasupin hil pin sen latovu sil vu mop-anjuuto, hil anivasa osin hil anipaya having, be lalaam dando hôôk bayêên alo be pup. ");
INSERT INTO mmo_vpl VALUES ("MT22_11","070_22_11","MAT","22","11","11","Tonde omaaho lulemak lokala in nambe ji sil, tombe yi de omaaho ti me-lop lolop anivasa lohvu mando be ja vanôôn bop-anju le, ");
INSERT INTO mmo_vpl VALUES ("MT22_12","070_22_12","MAT","22","12","12","tombe omaaho lulemak nêêl vu nambe, ‘Hali, nambe vaati om game galop lolop vanôôn bop-ate le? Galokalaam danjeen in?’ Le omaahôô-ju lava ma, ");
INSERT INTO mmo_vpl VALUES ("MT22_13","070_22_13","MAT","22","13","13","+ o 22:13 Mat 8:12; 25:30; Luk 13:28*tombe omaaho lulemak nêêl vu yite kul vaha-so nambe, ‘Ham naanduuh nama yuuh vaha de ham gaate na, be na mando dôôk taaku mekanu lôôt. Vu taakuu-ju le monaasu osin janga navu be monaangitak.’” ");
INSERT INTO mmo_vpl VALUES ("MT22_14","070_22_14","MAT","22","14","14","Tombe Yesu nêêl nambe, “Ke, Anutu nateey hil ngeeyaata, lemu naholin ti ti lak in landukana gaving yite hil.” ");
INSERT INTO mmo_vpl VALUES ("MT22_15","070_22_15","MAT","22","15","15","+ o 22:15 Mak 3:6*Tombe hil Palisai yoo lala landuuh vakasin nambe sil tatuhin Yesu in nambe naanêêl vakasin na paya, ");
INSERT INTO mmo_vpl VALUES ("MT22_16","070_22_16","MAT","22","16","16","om lawiing silate hil vaalu laving Helot-ate hil vaalu be lala vu Yesu be lanêêl nambe, “Kaputung, hey alak ganim nambe hong omaaho sen onanêêl vakasin keen. Yik goo navu tatekin Anutu-te mop keen vu hil, de game nayêênin omaaho ti nambe haale bop me haale pasiv e, ");
INSERT INTO mmo_vpl VALUES ("MT22_17","070_22_17","MAT","22","17","17","om onaanêêl vu hey e. Lohvu nambe yiiy Islel gaate taakis na vu Lom-ate yêêv bop Sisa me malis?” ");
INSERT INTO mmo_vpl VALUES ("MT22_18","070_22_18","MAT","22","18","18","Le Yesu lak sil alondpayo nipayaa-ju ni lung la, om nêêl nambe, “Ham oo natee ham ak. Nambe vaati sen ham nawiingin nambe sahi saa-jo? ");
INSERT INTO mmo_vpl VALUES ("MT22_19","070_22_19","MAT","22","19","19","Ham taato mone taakis ti be saangge le.” Om lavu mone ti la vu be yi, ");
INSERT INTO mmo_vpl VALUES ("MT22_20","070_22_20","MAT","22","20","20","le mem lingin sil nambe, “Lati kanu osin haale lakaneep-anjo?” ");
INSERT INTO mmo_vpl VALUES ("MT22_21","070_22_21","MAT","22","21","21","+ o 22:21 Lom 13:7*Le lanêêl laah nambe, “Sisa.” Tombe Yesu nêêl vu sil nambe, “Om ham ambu Sisa-te va na vu Sisa, de Anutu-te va na vu Anutu.” ");
INSERT INTO mmo_vpl VALUES ("MT22_22","070_22_22","MAT","22","22","22","Lango vakasin-anjo tombe lavindis lôôt, tombe lavuuh yi de lala. ");
INSERT INTO mmo_vpl VALUES ("MT22_23","070_22_23","MAT","22","23","23","+ o 22:23 Sin 23:8*Tonde hôôk busin tii-ju hil Sadusi sen danêêl nambe omaahonôôn yimbin-ame le kandi jak naah-ato, ond lala lalingin Yesu nambe, ");
INSERT INTO mmo_vpl VALUES ("MT22_24","070_22_24","MAT","22","24","24","+ o 22:24 Diu 25:5*“Kaputung, Mose nêêl nambe omaaho ti noow ma de yimb, ond omaahôô-ju hali le gako vehaahôôv in yuuh gako unoopasiv dukanaah mangganaan sen yimb-ato ahembaan. ");
INSERT INTO mmo_vpl VALUES ("MT22_25","070_22_25","MAT","22","25","25","Tombe bôôy omaaho ti sil o halindin namaavaalu be vindak yuuh dando having hey, tombe sil halindin tuk hako vêêh ti be yimb de noow ma, om sil halindin miin hako hali vane vehaahôôv-ambe yimb, ");
INSERT INTO mmo_vpl VALUES ("MT22_26","070_22_26","MAT","22","26","26","de gwey wiing nambêênju va timu. Tombe yik sil pin lôôt-ambe la hato sil halindin meey, ");
INSERT INTO mmo_vpl VALUES ("MT22_27","070_22_27","MAT","22","27","27","sil pin layimb de sil noondin ma, tombe vehaahôôv yimb lakaneep ahus. ");
INSERT INTO mmo_vpl VALUES ("MT22_28","070_22_28","MAT","22","28","28","Om vu busin sen omaahonôôn yimbin kandi jak naah-ato, ond vehaahôôv-anju le naatu hil namaavaalu be vindak yuuh-anjuuto sil ti tana vane, in sil pin lako vêêh timuu-ju lung laa-to.” ");
INSERT INTO mmo_vpl VALUES ("MT22_29","070_22_29","MAT","22","29","29","Le sim Yesu nêêl laah vu sil nambe, “Ôôye, ham doosin Anutu-te niwêêk osin yite vakasin sen lukaneep hôôk kaapiyaa-to, ondeey ham nakaas paya nambêênja. ");
INSERT INTO mmo_vpl VALUES ("MT22_30","070_22_30","MAT","22","30","30","Vu busin sen omaahonôôn yimbin kandi jak naah-ato ond vêêh ayuuh moow-ame le gako sil naah e, le nama. Sil e mando nohvu angela-so sen dando baandonii-to. ");
INSERT INTO mmo_vpl VALUES ("MT22_31","070_22_31","MAT","22","31","31","Vakasin lak omaahonôôn yimbin kandi jak-ato ond mak ham-ame nasevin vakasin sen Anutu nêêl vu ham-ambe neep hôôk yite kaapiyaa-to mava? Nambe, ");
INSERT INTO mmo_vpl VALUES ("MT22_32","070_22_32","MAT","22","32","32","+ o 22:32 Eks 3:6; Mat 8:11*‘Abalaam ayuuh Isak-ande Yaakop, yaalate Anutu sa.’ Le hamambe yaal layimb om yaal lala valok-ate? Malis, in Anutu ond hil metumin vu voon osin hil pin sen layimb-ambe lala dando metumin-ato silate Anutu yi.” ");
INSERT INTO mmo_vpl VALUES ("MT22_33","070_22_33","MAT","22","33","33","Hil lango Yesu-te tanasin-anjo tombe lavindis lôôt. ");
INSERT INTO mmo_vpl VALUES ("MT22_34","070_22_34","MAT","22","34","34","Hil Palisai lango nambe Yesu-te vakasin-anju wiing-ambe hil Sadusi lavand ma, tombe lasupin lavuh ti, ");
INSERT INTO mmo_vpl VALUES ("MT22_35","070_22_35","MAT","22","35","35","tombe sil ti omaaho tanasin dangga wiingin nambe sahi Yesu om lingin nambe, ");
INSERT INTO mmo_vpl VALUES ("MT22_36","070_22_36","MAT","22","36","36","“Kaputung, Mose-te tanasin ti tana savok tanasin vaalu la?” ");
INSERT INTO mmo_vpl VALUES ("MT22_37","070_22_37","MAT","22","37","37","+ o 22:37 Diu 6:5*Tombe Yesu nêêl vu nambe, “Tanasin ti nambe, ‘Gahem gaving gate Omaaho Bop Anutu osin galompayo doos, be okanum doos, de gakam na doos vu yi timu.’ ");
INSERT INTO mmo_vpl VALUES ("MT22_38","070_22_38","MAT","22","38","38","Tanasin danggakook ti nyendoos-anjo ond mem bopaata lôôt-ambe kaluuh vaalu la. ");
INSERT INTO mmo_vpl VALUES ("MT22_39","070_22_39","MAT","22","39","39","+ o 22:39-40 Lev 19:18; Gal 5:14; Mat 7:12; Lom 13:9-10*Tonde tanasin ango tu yuuh having nambêênjo nambe, ‘Gahem gaving hil sen dando ngaaho vu hong naambe sen gahem oo naving hong-ato.’ ");
INSERT INTO mmo_vpl VALUES ("MT22_40","070_22_40","MAT","22","40","40","In Mose-te tanasin osin Anutu-te vakasin sen yite hil danêêl langaah-ato pin ond danggakook neep hôôk tanasin yuuh-anjo.” ");
INSERT INTO mmo_vpl VALUES ("MT22_41","070_22_41","MAT","22","41","41","Hil Palisai lasupin sil-ambe yoo daahen dando, tonde Yesu lingin sil nambe, ");
INSERT INTO mmo_vpl VALUES ("MT22_42","070_22_42","MAT","22","42","42","+ o 22:42 Jon 7:42*“Ham akam vu nambe vaati lak omaaho sen Anutu yoo holin yi vulôôt in nambe dôôvu yiiy-ato? Yite danggakook neep vu lati? Tombe lanêêl nambe, “Danggakook neep vu Devit.” ");
INSERT INTO mmo_vpl VALUES ("MT22_43","070_22_43","MAT","22","43","43","Tombe nêêl vu sil nambe, “Le nambe vaati sen Vavi Vaambuung vêêl Devit alu lak-ambe nêêl omaahôô-juuto nambe Omaaho Bop? Sen nêêl nambe, ");
INSERT INTO mmo_vpl VALUES ("MT22_44","070_22_44","MAT","22","44","44","+ o 22:44 Saam 110:1; Mat 26:64; Sin 2:34-35*‘Omaaho Bop nêêl vu sate Omaaho Bop nambe, “Omando sa namangg vasa, de sale aambiing-ambe hil sen dayi hong payaa-to le langgulis hong vaalu kambi.” ’ ");
INSERT INTO mmo_vpl VALUES ("MT22_45","070_22_45","MAT","22","45","45","Om sen Devit nêêl omaahôô-juuto nambe, ‘Omaaho Bop’ le nambe vaati sen Omaaho Bop-anju tu Devit-ate hil vu taamusin-ato ti?” ");
INSERT INTO mmo_vpl VALUES ("MT22_46","070_22_46","MAT","22","46","46","Tombe omaaho ti me-lohvu nambe naanêêl vakasin ti naah vu Yesu le, tombe hôôk busin-anju layêênin Yesu lakala, de me-dalingin yi yesin laah e. ");
INSERT INTO mmo_vpl VALUES ("MT23_1","070_23_1","MAT","23","1","1","Tombe Yesu nêêl vu hil alu bopaataa-ju having yite maanggêêm-aso nambe, ");
INSERT INTO mmo_vpl VALUES ("MT23_2","070_23_2","MAT","23","2","2","“Hil tanasin dangga osin hil Palisai danêêl Anutu-te tanasin vu ham lalokalaah Mose ahembaan. ");
INSERT INTO mmo_vpl VALUES ("MT23_3","070_23_3","MAT","23","3","3","+ o 23:3 Mal 2:7-8*Om vakasin sen danêêl vu ham-ato ond ham samu be naapuvu niwêêk, lemu va sen dawiing-anju ond ham-ame sapa dôôk e, in sil danêêl vakasin, lemu me-dawiing va lohvu silate vakasin e. ");
INSERT INTO mmo_vpl VALUES ("MT23_4","070_23_4","MAT","23","4","4","In sil dasupin silate tanasin vaalu ngeeyaata nambe sen danduuh va nimeen-ambe datung lakando omaahonôôn baanggesak-ambe dalôôhin lôôt, lemu sil ond nind baya de me-dalôôh daka lak namand in nambe landôôvu hil-anju le. ");
INSERT INTO mmo_vpl VALUES ("MT23_5","070_23_5","MAT","23","5","5","+ o 23:5 Mat 6:1; Eks 13:9; Diu 6:8; Nam 15:38-39*Va pin sen dawiing-anju ond dawiingin nambe hil lanji, ondeey sil kaavu Anutu-te tanasin-ambe landuuh ak bik naavi vatinin sil damband ond landuuh bik naavi bopaata savok hil vaalu-te, de davu samu vunakin dinaandiin lak silate lolop anye. ");
INSERT INTO mmo_vpl VALUES ("MT23_6","070_23_6","MAT","23","6","6","+ o 23:6 Mat 6:5; Luk 14:7*De dawiingin nambe sil oo mando naamunggin in lanja vanôôn bop, de sil mando hôôk hil pin amend vu dumb alo. ");
INSERT INTO mmo_vpl VALUES ("MT23_7","070_23_7","MAT","23","7","7","Dawiingin nambe hil gako sil ak vu talind, osin hil daanêêl sil naambe Kaputung. ");
INSERT INTO mmo_vpl VALUES ("MT23_8","070_23_8","MAT","23","8","8","Lemu ham ond hil-ame daanêêl ham naambe Kaputung e, malis. Yik omaaho timu tu hamate kaputung, nganjo ham pin ham o halim-aso. ");
INSERT INTO mmo_vpl VALUES ("MT23_9","070_23_9","MAT","23","9","9","“Tonde vu voon-anjo ond ham-ame naanêêl hamate omaaho ti naambe ham mom e, malis, yik ham Mom timu nando baandoni. ");
INSERT INTO mmo_vpl VALUES ("MT23_10","070_23_10","MAT","23","10","10","De me-daanêêl naambe silate yêêvaso ham e, malis, yik hamate yêêv timu Kalisi. ");
INSERT INTO mmo_vpl VALUES ("MT23_11","070_23_11","MAT","23","11","11","+ o 23:11 Mat 20:26; Mak 9:35; Luk 22:26*Lemu hamate omaaho sen tu bop-ato ond yoo daanggôôl yi be naatu hamate hil kul ti. ");
INSERT INTO mmo_vpl VALUES ("MT23_12","070_23_12","MAT","23","12","12","+ o 23:12 Iyop 22:29; Pro 29:23; Esi 21:26; Luk 14:11; 18:14*Omaaho ti yoo gako yi jak ond Anutu le daanggôôl yi, de omaaho ti yoo daanggôôl yi, ond Anutu le gako yi jak.” ");
INSERT INTO mmo_vpl VALUES ("MT23_13","070_23_13","MAT","23","13","13","“Ham tanasin dangga osin Palisai, ham e naatovu nimeen. Ham oo natee ham ak. Ham nahilin mop in nambe omaahonôôn-ame landukana gaving Anutu-te hil e. Ham-ame yoo nalokala le, de ham nahilin hil sen dawiingin nambe landokanaa-to having. ");
INSERT INTO mmo_vpl VALUES ("MT23_14","070_23_14","MAT","23","14","14","“Ham tanasin dangga osin Palisai, ham e naatovu nimeen. Ham oo natee ham ak. Ham nalakin vehaahôôv-asote bayêên ayuuh ame, tonde ham navun ham alompayo lak lohakin diin, om ham e naatovu nipaya nyevahaan bopaata lôôt. ");
INSERT INTO mmo_vpl VALUES ("MT23_15","070_23_15","MAT","23","15","15","“Ham tanasin dangga osin Palisai, ham e naatovu nimeen. Ham oo natee ham ak. Ham natup hôôk lôôy osin taaku pin in nambe ham naatovu omaaho ti in gilin yi be gako hamate gambum. Omaahôô-ja tu hamate omaaho lung la, tombe sim ham awiing-ambe tu omaaho nipaya kaluuh ham, be le na taaku nipaya gaving ham. ");
INSERT INTO mmo_vpl VALUES ("MT23_16","070_23_16","MAT","23","16","16","+ o 23:16 Mat 15:14*“Ham hil amekanu, ham navu taato mop vu hil, om ham e naatovu nimeen. Ham nanêêl nambe omaaho ti naanêêl dumb vaambuung haale in kaandu yite vakasin, le ma de tatuhin, ond ham nanêêl nambe va malis, nganjo naambe naanêêl lak gool sen nando hôôk dumb vaambuung alôô-to in kaandu yite vakasin, ond ham nanêêl nambe me-lohvu nambe tatuhin e, nganjo biing-ambe yite vakasin nôôn jak. ");
INSERT INTO mmo_vpl VALUES ("MT23_17","070_23_17","MAT","23","17","17","Ham alumkook ma osin ham amem kanu. Va ango tana nôôn savok? Mak gool savok a? Ma, dumb vaambuung sen wiing gool-ambe tu vaambuung-ato ond mem savok. ");
INSERT INTO mmo_vpl VALUES ("MT23_18","070_23_18","MAT","23","18","18","Tonde ham nanêêl nambe omaaho ti naanêêl alata haale in kaandu yite vakasin le ma de tatuhin, ond ham nanêêl nambe va malis, nganjo naanêêl lak salivangin sen nando lak alata ond ham nanêêl nambe me-lohvu nambe tatuhin e, nganjo biing-ambe yite vakasin nôôn jak. ");
INSERT INTO mmo_vpl VALUES ("MT23_19","070_23_19","MAT","23","19","19","Ham hil amekanu-so, va ango tana nôôn savok? Mak salivangin savok a? Ma, alata sen nawiing-ambe salivangin natu vaambuung-ato ond mem savok. ");
INSERT INTO mmo_vpl VALUES ("MT23_20","070_23_20","MAT","23","20","20","Om omaaho ti naanêêl alata haale in kaandu yite vakasin, ond me-nanêêl lak alata mu le, nganjo nanêêl lak alata osin va pin sen nando lak-ato having. ");
INSERT INTO mmo_vpl VALUES ("MT23_21","070_23_21","MAT","23","21","21","Tonde omaaho ti naanêêl dumb vaambuung haale in kaandu yite vakasin, ond manyinja navu kaandu yite vakasin lak dumb vaambuung osin lak Anutu sen nando hôôk-ato having. ");
INSERT INTO mmo_vpl VALUES ("MT23_22","070_23_22","MAT","23","22","22","+ o 23:22 Ais 66:1; Mat 5:34; Sin 7:49*Tonde omaaho ti naanêêl keen baandoni, ond manyinju navu kaandu yite vakasin lak Anutu-te sia osin lak Anutu having, in nando lak-ato. ");
INSERT INTO mmo_vpl VALUES ("MT23_23","070_23_23","MAT","23","23","23","+ o 23:23 Lev 27:30; Mai 6:8*“Ham tanasin dangga-so osin Palisai-so, ham e naatovu nimeen. Ham oo natee ham ak. Keen, tanasin nambe sen vanôôn pasi-pasiv, jaamenjang osin lêêsak-ande maanjêênj, ond ham natung having vanôôn ayuuh ame pin lak lu nomaayuuh, tombe ham navu lu ti natu salivangin vu Anutu, ond Mose-te tanasin tii-jo ond ham napuvu niwêêk. Lemu tanasin bo-bop vaalu nambe sen yaambiing va na nivalok amu, de yakangg pasiv in hil vaalu be yaandôôvu sil, tonde yalonggpayo na timu vu Anutu, ond yik ham oo navuuh tanasin-anjo nala. Om ham samu tanasin-anjo, de tanasin vaalu nambe sen ham navu va lu ti natu salivangin vu Anutu ond ham oo mosamu gaving-ande ham-ame gavuuh na le. ");
INSERT INTO mmo_vpl VALUES ("MT23_24","070_23_24","MAT","23","24","24","“Ham navu taato mop vu hil, lemu ham amem kanu. Ham navu samu tanasin pasi-pasiv lemu ham navuuh tanasin bo-bop la, yik nambe sen ham napêêh paaniip vêêl in bel kuuh, lemu ham anum bik bopaata ti osin doos having bel-ambe lukala ham alompayôô-to. ");
INSERT INTO mmo_vpl VALUES ("MT23_25","070_23_25","MAT","23","25","25","+ o 23:25 Mak 7:4*“Ham tanasin dangga-so osin Palisai-so, ham e naatovu nimeen. Ham oo naatee ham ak. Ham nalipis kap osin pale dami mu, de lopayo ond va hôôndak osin va nindanje-danjeen pup hôôk. ");
INSERT INTO mmo_vpl VALUES ("MT23_26","070_23_26","MAT","23","26","26","Hong Palisai, gamem kanu. Ganjipis kap alopayo vêêl e, mem dami le nivasa jak gaving. ");
INSERT INTO mmo_vpl VALUES ("MT23_27","070_23_27","MAT","23","27","27","+ o 23:27 Sin 23:3*“Ham tanasin dangga-so osin Palisai-so, ham e naatovu nimeen. Ham oo natee ham ak. Ham nambe bandumb avi sen latung pen valôôy ak-ato, tombe hil dayi baandoni nambe mengali, lemu lopayo ond omaahonôôn kook osin va matelakin pin pup hôôk. ");
INSERT INTO mmo_vpl VALUES ("MT23_28","070_23_28","MAT","23","28","28","+ o 23:28 Luk 16:15*Yik nambe sen ham-anja, omaahonôôn dayi ham anim naavi be kand navu nambe ham hil anivasa, lemu vakasin tatuhin osin va nipaya paya pup hôôk ham alompayo.” ");
INSERT INTO mmo_vpl VALUES ("MT23_29","070_23_29","MAT","23","29","29","“Ham tanasin dangga osin Palisai-so, ham e naatovu nimeen. Ham oo natee ham ak. Ham nahaav bayêên anivasa vasa nalakando hil sen danêêl Anutu-te vakasin langaah-ambe layimb bôôy-ato silate bandumb baandoni, de ham navunak hil anivalok-ate bandumb, ");
INSERT INTO mmo_vpl VALUES ("MT23_30","070_23_30","MAT","23","30","30","de ham nanêêl nambe ham mando gaving himbop-aso bôôy, ond ham-ame le andôôvu sil-ambe ham ahondoos anyiis hil sen danêêl Anutu-te vakasin langaah-ato be lanjimb e. ");
INSERT INTO mmo_vpl VALUES ("MT23_31","070_23_31","MAT","23","31","31","+ o 23:31 Sin 7:52*Om nambêênja ham oo nanêêl hamate dangga langaah nambe hil sen layiis sil-ambe layimb-ato ond silate hil moos ham-anja. ");
INSERT INTO mmo_vpl VALUES ("MT23_32","070_23_32","MAT","23","32","32","Om ham-o, ham oo sapa dôôk hamate himbop-aso bôôy vahand. ");
INSERT INTO mmo_vpl VALUES ("MT23_33","070_23_33","MAT","23","33","33","+ o 23:33 Mat 3:7; 12:34; Luk 3:7*“Ham nyêêy, nyêêy noondin-aso. Hamambe ham e napak-ambe ham ana, de Anutu me-le naanêêl-ambe ham-ame le ana mando taaku nipaya le? Malis, ham-ame alohvu nambe napak e. ");
INSERT INTO mmo_vpl VALUES ("MT23_34","070_23_34","MAT","23","34","34","+ o 23:34 Sin 7:52; 1Tes 2:15; Mat 10:23*Om sale aambiing-ambe hil sen danêêl Anutu-te vakasin langaah-ato osin hil alukook bop-ande hil tanasin dangga lanaas vu ham, le ma de ham navu anyiis vaalu be lanjimb, de ham e anyiis vaalu jakana haah pako, tonde ham e gaveek vaalu hôôk hamate dumb alo, osin ham ambiing nindanjeen vu vaalu de ham gatiiy sil vu taaku ti be lana taaku ango. ");
INSERT INTO mmo_vpl VALUES ("MT23_35","070_23_35","MAT","23","35","35","+ o 23:35 Jen 4:8; Hiblu 11:4; 2Kro 24:20-21*Om hil anivalok pin sen hil kaasêêh sil anind hees-ambe layimb vu voon-anjôôto, ond vu nyendoos sen omaaho nivalok Abel yimb-ambe tok valup Belekaia noow Sakaalia sen hamate himbop-aso layiis-ambe yimb neep dumb alo vaambuung-ande alata lavuun-ato, ond lak sil pin-anju sen ham e gako nipaya nyevahaan dukanaah. ");
INSERT INTO mmo_vpl VALUES ("MT23_36","070_23_36","MAT","23","36","36","Sa naanêêl keen vu ham naambe va pin-anju nyevahaan anipaya le naatovu ham sen gêên-anjo.” ");
INSERT INTO mmo_vpl VALUES ("MT23_37","070_23_37","MAT","23","37","37","+ o 23:37 Sin 7:59; 1Tes 2:15*“O Yelusalem, ham nayiis hil sen danêêl Anutu-te vakasin langaah-ato be dayimb, de hil sen Anutu nawiing sil dalaas vu ham-ato ond ham navu tanga sil lak tatuuh. Balon ngeeyaata ond soo monaawiingin nambe sa naasupin ham anggulis sa baambungg naambe sen kokalêêh nasupin noow-aso dahulis baambuu-to, le ma de ham animbaya. ");
INSERT INTO mmo_vpl VALUES ("MT23_38","070_23_38","MAT","23","38","38","+ o 23:38 1King 9:7-8; Jer 12:7; 22:5*Om ham gango, gêên-anjo ham oo nando malis amu de Anutu havuuh ham. ");
INSERT INTO mmo_vpl VALUES ("MT23_39","070_23_39","MAT","23","39","39","+ o 23:39 Saam 118:26; Mat 21:9*Om sa naanêêl vu ham naambe ham-ame le angge sa jesin naah e, de na lôôt-ambe busin sen ham oo le naanêêl naambe, ‘Yiiy gako omaahôô-ju jak in laam ak Omaaho Bop haale.’” ");
INSERT INTO mmo_vpl VALUES ("MT24_1","070_24_1","MAT","24","1","1","Yesu vu Anutu-te dumb bop alo be hato la in na, tombe yite maanggêêm-aso lala vu be sil taato dumb-ate bayêên pin vu yi, ");
INSERT INTO mmo_vpl VALUES ("MT24_2","070_24_2","MAT","24","2","2","+ o 24:2 Luk 19:44*tombe Yesu nêêl vu sil nambe, “Ham angge va pin-anju, ond sa naanêêl keen vu ham naambe tatuuh sen lahaav dumb ak-ato, ond ango me-le mando jak ango baandoni le, le kawiiy pin-ambe na mando danjeen.” ");
INSERT INTO mmo_vpl VALUES ("MT24_3","070_24_3","MAT","24","3","3","Yesu la nando lak kandu Oliv, tombe yite maanggêêm-aso yoo lala vu be lalingin yi kaatokin nambe, “Onaanêêl vu hey e, naangelis e vaa-jo naatok? Hey e anjak ni jak vaati naambe onavu ganom atombe va pin jung na?” ");
INSERT INTO mmo_vpl VALUES ("MT24_4","070_24_4","MAT","24","4","4","Tombe Yesu nêêl laah vu sil nambe, “Ham ganggin ham in omaaho ango le tatuhin ham, ");
INSERT INTO mmo_vpl VALUES ("MT24_5","070_24_5","MAT","24","5","5","+ o 24:5 Mat 24:23-24; Sin 5:36-37; Jon 5:43; 1Jon 2:18*in hil ngeeyaata le lanaam-ambe daanêêl sa haalengg ak sil naambe, ‘Sa Kalisii-jo,’ de sil e tatuhin omaahonôôn ngeeyaata. ");
INSERT INTO mmo_vpl VALUES ("MT24_6","070_24_6","MAT","24","6","6","De ham e gango ngaamong laam ngaaho daandun, osin ham e gango ngaamong banye vu taaku dinaandiin heey. Om ham gango le, ham-ame naham jak e, in vaa-ju le naam, lemu va pin-ame le jung na pavis e, in busin sen-ato naahen. ");
INSERT INTO mmo_vpl VALUES ("MT24_7","070_24_7","MAT","24","7","7","+ o 24:7 2Kro 15:6; Ais 19:2*Bayêên bu ngo le kandi be lambiing ngaamong vu bayêên bu ngo, de gaaman ango le kandi be biing ngaamong vu gaaman ango, de jemaapi le jêêy osin meep e biing omaahonôôn vu taaku vaalu. ");
INSERT INTO mmo_vpl VALUES ("MT24_8","070_24_8","MAT","24","8","8","Va nime-meen pin sen navu naatokak omaahonôôn-ato ond yite nalu munggin-anja. ");
INSERT INTO mmo_vpl VALUES ("MT24_9","070_24_9","MAT","24","9","9","+ o 24:9 Mat 10:22; Jon 15:18; 16:2*Tonde mem hil e lambu ham dukana hil namand in nambe lambu nimeen vu ham, de lanyiis ham-ambe ham anggimb, tombe hil pin e nind baya lôôt in ham in sate hil ham. ");
INSERT INTO mmo_vpl VALUES ("MT24_10","070_24_10","MAT","24","10","10","Tombe hil ngeeyaata le nind baya in sa, de langgilin sil naah, tonde sil oo le nind baya lôôt in silate hil-ambe lambu sil landukana hil namand in nambe lanyiis sil. ");
INSERT INTO mmo_vpl VALUES ("MT24_11","070_24_11","MAT","24","11","11","+ o 24:11 Mat 24:5,24; 1Jon 4:1*Tombe hil ngeeyaata le balup-ambe daanêêl tanasin tatuhin naambe Anutu-te vakasin, le ma, tombe sil e palapin omaahonôôn ngeeyaata. ");
INSERT INTO mmo_vpl VALUES ("MT24_12","070_24_12","MAT","24","12","12","Va nipaya le naatu bopaata jak atombe hil ngeeyaata ahend-ame le gaving sil nivasa naambe bôôy e. ");
INSERT INTO mmo_vpl VALUES ("MT24_13","070_24_13","MAT","24","13","13","+ o 24:13 Mat 10:22*De hil sen sil baale niwêêk lôôt-ambe baaku nimeen pin-ato, ond sil e lana mando metumin gaving Anutu. ");
INSERT INTO mmo_vpl VALUES ("MT24_14","070_24_14","MAT","24","14","14","+ o 24:14 Mat 10:18; 28:19*Tombe sate hil e daanêêl banye nivasa sen Anutu nanggin yite hil-ato langaah-ambe na nohvu taaku pin in hil pin gango, le mem baandoni osin voon-ate busin-ato le jung na.” ");
INSERT INTO mmo_vpl VALUES ("MT24_15","070_24_15","MAT","24","15","15","+ o 24:15 Dan 9:27; 11:31; 12:11*Omaaho ti nambe naasevin vakasin-anjo ond yoo ka bu nivasa be jak dangga ni naambe, “Ham navu angge nipaya dangga sen navu kawiiy vaa-to, ond le dukana baale dôôk taaku vaambuung nohvu sen Daniel nêêl Anutu-te vakasin langaah bôôy-ato, ");
INSERT INTO mmo_vpl VALUES ("MT24_16","070_24_16","MAT","24","16","16","tombe mem hil sen dando Yudiaa-to ond dapak-ambe lana mando kandu lu. ");
INSERT INTO mmo_vpl VALUES ("MT24_17","070_24_17","MAT","24","17","17","+ o 24:17 Luk 17:31*De omaaho ti nambe mando lak bayêên alu baandoni, ond me-duus-ambe guli-naah bayêên alo be gako yite vati le, nganjo napak pavis. ");
INSERT INTO mmo_vpl VALUES ("MT24_18","070_24_18","MAT","24","18","18","De ti monambiing yite kul, ond me-gilin-ambe naah gako yite lolop e. ");
INSERT INTO mmo_vpl VALUES ("MT24_19","070_24_19","MAT","24","19","19","Om hôôk busin-anju ond nimeen e naatovu vêêh-aso sen noondin lukaalêê-to, osin vêêh vaalu sen daahen davu sum vu noondin-ato. ");
INSERT INTO mmo_vpl VALUES ("MT24_20","070_24_20","MAT","24","20","20","Om ham anohak naambe vaa-ju me-naatovu ham dôôk busin sen lukaahôômb osin vavi jambaa-to le, de me-dôôk busin sawaasin ti le. ");
INSERT INTO mmo_vpl VALUES ("MT24_21","070_24_21","MAT","24","21","21","+ o 24:21 Dan 12:1; Joel 2:2; Taato 7:14*Vu bôôy sen Anutu hatung va pin nyendoos-ambe tok laam gêên-anjo ond omaahonôôn-ame laaku nimeen bopaata lôôt e. De vu gêên-anjo ond nimeen bopaata navu naatovu omaahonôôn, tonde vu taamusin ond omaahonôôn-ame le daatovu nimeen ti naambêênjo jesin naah e. ");
INSERT INTO mmo_vpl VALUES ("MT24_22","070_24_22","MAT","24","22","22","Busin sen nimeen bopaataa-ju naatovu omaahonôôn-ato ond Anutu le katôôv vahaan na, le naambe nama ond omaaho lati lohvu nambe mando metumin? Lemu ka navu yite hil sen yoo holin sil ak-ato, om le katôôv busin sen nimeen-anju vahaan na. ");
INSERT INTO mmo_vpl VALUES ("MT24_23","070_24_23","MAT","24","23","23","+ o 24:23 Mat 24:5,11*“Tombe mem omaaho ango le daanêêl vu ham dôôk busin-anju naambe, ‘Ham angge Kalisi nando nganjo,’ de daanêêl naambe, ‘Kalisi nando nganju,’ ond ham-ame ambiing gaving e. ");
INSERT INTO mmo_vpl VALUES ("MT24_24","070_24_24","MAT","24","24","24","+ o 24:24 Diu 13:1-3; 2Tes 2:9; Taato 13:13-14*In hil vaalu le lanaam-ambe tatuhin naambe sil omaaho sen Anutu yoo holin yi vulôôt-ato, tonde vaalu le tatuhin naambe sil Anutu-te hil sen danêêl yite vakasin langaah-ato, de lambiing taahu taahu vaha vaha osin niwêêk, in naambe lohvu ond sil langgilin hil sen Anutu yoo holin sil-ato be lambiing gaving sil. ");
INSERT INTO mmo_vpl VALUES ("MT24_25","070_24_25","MAT","24","25","25","“Ke, va pin sen saanêêl banye vu ham gêên-anjo ond taamusin sen nôôn jak-ato, ond ham-ame ambindis e. ");
INSERT INTO mmo_vpl VALUES ("MT24_26","070_24_26","MAT","24","26","26","+ o 24:26 Luk 17:23-24*Om naambe daanêêl vu ham naambe, ‘Kalisi la nando taaku lumbalaamb-anju,’ ond ham-ame ana le. De daanêêl naambe, ‘Kalisi nando hôôk bayêên alo,’ ond ham-ame ambiing gaving e. ");
INSERT INTO mmo_vpl VALUES ("MT24_27","070_24_27","MAT","24","27","27","+ o 24:27 Mat 24:37-39*In Omaahonôôn Noow nom-ato ond le lanji nohvu demak navêêl pavis vu vaavung be diihin lôôt-ambe lukala hoong. ");
INSERT INTO mmo_vpl VALUES ("MT24_28","070_24_28","MAT","24","28","28","+ o 24:28 Luk 17:37*Hahaanôôn ti yiis nivasa ond manak pin dasupin dala in nambe lanja.” ");
INSERT INTO mmo_vpl VALUES ("MT24_29","070_24_29","MAT","24","29","29","+ o 24:29 Ais 13:10; 34:4; Esi 32:7; Joel 2:10,31; 2Pi 3:10; Taato 6:12-13*“Busin-anjute nimeen pin jung na le mem taaku mekaalus e mekanu dôôk, de kwaav-ame le naatum e, de matam baandoni naatok osin va niwêêk vu baandoni pin e baale ye-yêêy. ");
INSERT INTO mmo_vpl VALUES ("MT24_30","070_24_30","MAT","24","30","30","+ o 24:30 Sek 12:10; Taato 1:7; Dan 7:13; Mat 26:64*Tombe va sen le taato naambe Omaahonôôn Noow navu naam-ato le naatok baale langaah vu baandoni, tonde hil pin vu voon daasu bopaata, de le lanji Omaahonôôn Noow mando jak bayiimb baandoni be naam osin niwêêk gaving nikaapulis bopaata. ");
INSERT INTO mmo_vpl VALUES ("MT24_31","070_24_31","MAT","24","31","31","+ o 24:31 Ais 27:13; 1Ko 15:52; 1Tes 4:16*Tombe vuuk e naasu bopaata, de Omaahonôôn Noow e biing-ambe yite angela-so le lana daasupin hil sen yoo holin sil lak-ambe latu yite hil-ato, vu taaku lavuun osin vu taaku nanyendangga vaalu vaalu pin.” ");
INSERT INTO mmo_vpl VALUES ("MT24_32","070_24_32","MAT","24","32","32","“Ham akam bu mêêl suusin. Ham angge naambe manak pulapul valu-la, ond ham e anjak ni naambe ngaaho lak in yiiy kape mêêl jakana jok. ");
INSERT INTO mmo_vpl VALUES ("MT24_33","070_24_33","MAT","24","33","33","De yik naambêênja om ham angge naambe vakasin pin-ato nôôn ak, ond ham e anjak ni naambe omaahôô-to laam ngaaho lak in navu naatovu ham. ");
INSERT INTO mmo_vpl VALUES ("MT24_34","070_24_34","MAT","24","34","34","+ o 24:34 Mat 16:28*De sa naanêêl keen vu ham naambe hil sen dando gêên-anjôôto ond me-le lanjimb e, de va pin-anjo le nôôn jak e mem. ");
INSERT INTO mmo_vpl VALUES ("MT24_35","070_24_35","MAT","24","35","35","+ o 24:35 Mat 5:18*Yendak osin ngaanggis e na menama, de sate vakasin ond ti me-le na menama le, yoo le nanjip danggata.” ");
INSERT INTO mmo_vpl VALUES ("MT24_36","070_24_36","MAT","24","36","36","+ o 24:36 Sin 1:7; 1Tes 5:1-2*“Lemu busin-anju osin taaku me ond omaaho ti me-lak ni le. Angela baandoni doosin, de Anutu Noow doosin, Aamangg timu yoo lak ni lung la. ");
INSERT INTO mmo_vpl VALUES ("MT24_37","070_24_37","MAT","24","37","37","+ o 24:37 Jen 6:5-8*Omaahonôôn Noow nom-ato ond le naambe Noa-te busin bôôy sen hil doosin-ande vati tovu sil pavis-ato. ");
INSERT INTO mmo_vpl VALUES ("MT24_38","070_24_38","MAT","24","38","38","In vu bôôy sen bel-ame vaal-ambe savun taaku pin e de naahen, ond hil dando mondaya vanôôn osin mondanum, de moow ayuuh vêêh mondako sil-ambe tok valup busin sen Noa-so lalukala sip alôô-to. ");
INSERT INTO mmo_vpl VALUES ("MT24_39","070_24_39","MAT","24","39","39","+ o 24:39 Jen 6:13–7:24; 2Pi 3:6*De hil oo doosin nambe vati navu naatokak sil, tombe bel vaal bopaata be hako sil la lôôt, ond yik le naambêênju vu sen Omaahonôôn Noow nom-ato. ");
INSERT INTO mmo_vpl VALUES ("MT24_40","070_24_40","MAT","24","40","40","Omaaho yuuhapim e mondambiing kul, tombe Anutu le gako ango na, de gavuuh ango mando. ");
INSERT INTO mmo_vpl VALUES ("MT24_41","070_24_41","MAT","24","41","41","Tonde vêêh yuuh e mando monggayêêh vanôôn hôôk bayêên alo, ond Anutu le gako ango na, de gavuuh ango mando. ");
INSERT INTO mmo_vpl VALUES ("MT24_42","070_24_42","MAT","24","42","42","+ o 24:42 Mat 25:13*Om ham oo mando mem naatum in ham doosin busin sen hamate Omaaho Bop e nom-ato. ");
INSERT INTO mmo_vpl VALUES ("MT24_43","070_24_43","MAT","24","43","43","+ o 24:43 Luk 12:39-40; Taato 3:3; 16:15*“Ham oo alak ni nambe bayêên mangganaan ti gango banye naambe omaaho hôôndak navu balup hôôk busin taaku me tii-ju, ond le ganggin nivasa in naambe omaaho hôôndak-ame dukana yite bayêên alo le. ");
INSERT INTO mmo_vpl VALUES ("MT24_44","070_24_44","MAT","24","44","44","Om yik nambêênja ham oo ganggin ham nivasa, in busin ti ham-ame le kam bu naambe Omaahonôôn Noow navu naam-ato ond le naam pavis.” ");
INSERT INTO mmo_vpl VALUES ("MT24_45","070_24_45","MAT","24","45","45","“De kul vaha nivasa osin ka bop ond nawiing kul nambe tana? Yik yite yêêv holin yi be nanggin kul vaha-so vaalu in nambe bu vanôôn vu sil jak busin pin, ");
INSERT INTO mmo_vpl VALUES ("MT24_46","070_24_46","MAT","24","46","46","tombe yite yêêv monana ti be nom gato vu be ji naambe nawiing yite kul lohvu, ond kul vahaa-jo le ka vasa. ");
INSERT INTO mmo_vpl VALUES ("MT24_47","070_24_47","MAT","24","47","47","+ o 24:47 Mat 25:21,23*Sa naanêêl keen vu ham naambe yite yêêv e naanêêl-ambe naatu yêêv in ganggin yite va pin. ");
INSERT INTO mmo_vpl VALUES ("MT24_48","070_24_48","MAT","24","48","48","Le naambe kul vaha nipayaa-ju yoo le ka bu dôôk lopayo naambe yite yêêv naahen lôôt, ");
INSERT INTO mmo_vpl VALUES ("MT24_49","070_24_49","MAT","24","49","49","tombe gaveek kul vaha-so vaalu, de ja osin naanum gaving hil aheta-so. ");
INSERT INTO mmo_vpl VALUES ("MT24_50","070_24_50","MAT","24","50","50","Tombe busin ti kul vahaa-ju me-ganggin yite yêêv e, le doosin, ond yite yêêv e nom gato, ");
INSERT INTO mmo_vpl VALUES ("MT24_51","070_24_51","MAT","24","51","51","+ o 24:51 Mat 8:12*tombe le nyiis kul vaha nipayaa-ju be gako nipaya valok-ate, tombe gaate na taaku nipaya be gako nivaane gaving hil sen datee sil ak-ato, tombe vu taakuu-ju hil e daasu bopaata osin navund monaangitak.” ");
INSERT INTO mmo_vpl VALUES ("MT25_1","070_25_1","MAT","25","1","1","+ o 25:1 Taato 19:7; Luk 12:35*“Tonde Anutu nanggin yite hil-ato, ond lohvu vehaavu nomaayuuh taalungg hôôk silate lam pasiv ti ti be lala mondanggin omaaho sen navu balup in gako yite vêêh-ato. ");
INSERT INTO mmo_vpl VALUES ("MT25_2","070_25_2","MAT","25","2","2","Ond sil namaavaalu lundkook ma, de namaavaalu ond mem sil alundkook neep. ");
INSERT INTO mmo_vpl VALUES ("MT25_3","070_25_3","MAT","25","3","3","In vaalu sen sil alundkook maa-to ond lako silate lam lemu me-lako kalaasin heey in nambe sil kaasêêh dukanaah e. ");
INSERT INTO mmo_vpl VALUES ("MT25_4","070_25_4","MAT","25","4","4","Nganjo vehaavu-so sen sil alundkook neep-ato, ond mem sil lako lam-ambe lako kalaasin heey having in nambe sil kaasêêh dukanaah. ");
INSERT INTO mmo_vpl VALUES ("MT25_5","070_25_5","MAT","25","5","5","Tombe omaaho sen navu gako yite vêêh-ato me-valup pavis e, om vehaavu-so mend yip pin-ambe deep-ambe kand lingin. ");
INSERT INTO mmo_vpl VALUES ("MT25_6","070_25_6","MAT","25","6","6","Tonde busin lavuun atombe kôôk ti laam nambe, ‘Omaahôô-to valup-o. Omaahôô-to valup-o. Ham nambiing gatongin ham in ham ana naanggiiy naas.’ ");
INSERT INTO mmo_vpl VALUES ("MT25_7","070_25_7","MAT","25","7","7","Om vehaavu pin-anju kandi be taalungg hôôk silate lam-ambe tum bop, ");
INSERT INTO mmo_vpl VALUES ("MT25_8","070_25_8","MAT","25","8","8","tonde vehaavu-so vaalu sen lundkook maa-to lanêêl vu vaalu sen sil alundkook neep-ato nambe, ‘Ham ambu hamate kalaasin daka vu hey e, in heyanêêngg lam navu jimb.’ ");
INSERT INTO mmo_vpl VALUES ("MT25_9","070_25_9","MAT","25","9","9","Le vaalu sen sil alundkook neep-ato lanêêl laah nambe, ‘Mu mak me-lohvu yiiy pin e, om ham oo ana baanggo hamanêêm vu tatuva.’ ");
INSERT INTO mmo_vpl VALUES ("MT25_10","070_25_10","MAT","25","10","10","Tombe lala in nambe lana baanggo, tonde omaahôô-juuto valup pavis, om vehaavu-so vaalu sen sil samu sil lung laa-to, ond lalukala bayêên alo having omaahôô-juuto in nambe lanja vanôôn bop, tonde laayiiy vinavi. ");
INSERT INTO mmo_vpl VALUES ("MT25_11","070_25_11","MAT","25","11","11","+ o 25:11 Luk 13:25,27*“Lung laa tonde sim vehaavu-so vaalu lalo-lato be lateey nambe, ‘Himbop, onggataahin vinavi in hey e.’ ");
INSERT INTO mmo_vpl VALUES ("MT25_12","070_25_12","MAT","25","12","12","+ o 25:12 Mat 7:23*Le nêêl laah vu sil nambe, ‘Ham ana, sa doosin ham.’ ");
INSERT INTO mmo_vpl VALUES ("MT25_13","070_25_13","MAT","25","13","13","+ o 25:13 Mat 24:42; Luk 12:40*“Ke yik vakasin-anjo, om ham oo mando mem naatum in ham doosin busin osin taaku me.” ");
INSERT INTO mmo_vpl VALUES ("MT25_14","070_25_14","MAT","25","14","14","+ o 25:14 Mak 13:34*“Anutu nanggin yite hil-ato ond yik nambe sen omaaho ti wiingin nambe na taaku dinaandiin, om teey yite hil kul vaha yaal lalaam, tombe vu yite va yuuh ame lukala yaal namand in nambe yaal ganggin. ");
INSERT INTO mmo_vpl VALUES ("MT25_15","070_25_15","MAT","25","15","15","+ o 25:15 Lom 12:6*Ond vu va lohvu yaalate niwêêk neep-ato, in nambe yaal lambiing kul ak, om vu mone bopaata lôôt lohvu 5 taosen kina vu ti, tonde vu 2 taosen kina vu ango, de vu 1 taosen kina vu ti. Lung laa tonde la. ");
INSERT INTO mmo_vpl VALUES ("MT25_16","070_25_16","MAT","25","16","16","“Tombe ti sen hako 5 taosen kinaa-to ond la wiing kul lak-ambe hako mone nyesavokin vaalu lohvu 5 taosen kina lukala having. ");
INSERT INTO mmo_vpl VALUES ("MT25_17","070_25_17","MAT","25","17","17","Tonde ango sen hako 2 taosen kina ond yik wiing nambêênju be hako mone nyesavokin vaalu lohvu 2 taosen kina lukala having, ");
INSERT INTO mmo_vpl VALUES ("MT25_18","070_25_18","MAT","25","18","18","lemu ti sen hako 1 taosen kina ond la haav ngaanggis-ambe vun yêêv-ate mone hôôk. ");
INSERT INTO mmo_vpl VALUES ("MT25_19","070_25_19","MAT","25","19","19","“Tonde sim naalum atombe kul vaha yaal-anjuuto yaalate yêêv lo-valup-ambe wiingin nambe gango mone sen vu vu yaal-ato. ");
INSERT INTO mmo_vpl VALUES ("MT25_20","070_25_20","MAT","25","20","20","Om ti sen hako 5 taosen kinaa-to ond hako mone nyesavokin-anju la vu be nêêl nambe, ‘Himbop, gavu 5 taosen kina lukala sa namangg-ato ond gangge, saawiing kul lak-ambe sa hako mone nyesavokin vaalu lohvu 5 taosen kina lukala having-anjo.’ ");
INSERT INTO mmo_vpl VALUES ("MT25_21","070_25_21","MAT","25","21","21","+ o 25:21 Mat 24:45-47; Luk 16:10*Tombe yite yêêv nêêl vu nambe, ‘Ke, mem hong kul vaha nivasa lôôt-ambe omaaho nanyem laas. Ohanggin va pasivdakaa-to nivasa lôôt, om sa navu aambiing-ambe ongganggin va ngeeyaata. Ganaam-ambe hoow mando osin wakangg vasa.’ ");
INSERT INTO mmo_vpl VALUES ("MT25_22","070_25_22","MAT","25","22","22","“Tonde ti sen hako 2 taosen kinaa-to la vu be nêêl nambe, ‘Himbop, gavu 2 taosen kina vu sa, tombe gangge, saawiing kul lak-ambe sa hako mone nyesavokin vaalu lohvu 2 taosen kina lukala having.’ ");
INSERT INTO mmo_vpl VALUES ("MT25_23","070_25_23","MAT","25","23","23","Tombe yite yêêv nêêl vu nambe, ‘Been, hong kul vaha nivasa be omaaho nanyem laas, ohanggin va pasivdakaa-to nivasa lôôt, om sa navu aambiing-ambe ongganggin va ngeeyaata. Ganaam-ambe hoow mando osin wakangg vasa.’ ");
INSERT INTO mmo_vpl VALUES ("MT25_24","070_25_24","MAT","25","24","24","“Tonde sim ti sen hako 1 taosen kinaa-to lukalom-ambe nêêl vu nambe, ‘Himbop, sa lak ganim lung la nambe hong omaaho osin niwêêk bopaata. Hil vaalu daalôôh vave le goo nako nôôn, tonde hil ango dawiing kul le goo nako va nyesavokin vu sil, ");
INSERT INTO mmo_vpl VALUES ("MT25_25","070_25_25","MAT","25","25","25","tombe saayêênin-ambe sala aavun gate mone hôôk ngaanggis, om gate va nganjo.’ ");
INSERT INTO mmo_vpl VALUES ("MT25_26","070_25_26","MAT","25","26","26","Le yite yêêv nêêl laah vu nambe, ‘Hong kul vaha nipaya, de onamam valôôy. Galak sa ningg lung la nambe hil vaalu daalôôh vave le sa nako nôôn, tonde hil ango dawiing kul le sa nako va nyesavokin vu sil. ");
INSERT INTO mmo_vpl VALUES ("MT25_27","070_25_27","MAT","25","27","27","Om naambe goo gatung sate mone dôôk beng in saanom ond sa gako sate va nom, de sil lambu mone nyesavokin vaalu gaving, le ma. ");
INSERT INTO mmo_vpl VALUES ("MT25_28","070_25_28","MAT","25","28","28","Om ham ambu vêêl mone in omaahôô-ja be ham ambu na vu omaaho sen hako 10 taosen kinaa-to, ");
INSERT INTO mmo_vpl VALUES ("MT25_29","070_25_29","MAT","25","29","29","+ o 25:29 Mat 13:12; Mak 4:25; Luk 8:18*in hil pin sen silate va neep-ato, ond sil e gako va vaalu gaving-ambe silate va naatu ngeeyaata lôôt. Nganjo omaaho paya paya sen yite va maa-to, ond va pasivdaka sen neep vu yii-to le nama na valok-ate lôôt, ");
INSERT INTO mmo_vpl VALUES ("MT25_30","070_25_30","MAT","25","30","30","+ o 25:30 Mat 8:12*tonde kul vaha nipayaa-ju ham gaate na taaku mekanu sen neep nanyendangga lôôt-ato, tombe vu taakuu-ju hil e daasu bopaata osin navund monaangitak.’” ");
INSERT INTO mmo_vpl VALUES ("MT25_31","070_25_31","MAT","25","31","31","+ o 25:31 Mat 16:27; 19:28; Taato 20:11-13*“Omaahonôôn Noow e nom osin yite nikaapulis gaving yite angela-so pin, tombe mem le mando jak yite sia mengali. ");
INSERT INTO mmo_vpl VALUES ("MT25_32","070_25_32","MAT","25","32","32","+ o 25:32 Lom 14:10; Esi 34:17*Tombe hil vu voon-anjo pin e daasupin sil baale Omaahonôôn Noow ame, tombe le bayaalin sil jak lu yuuh naambe sen bik heendin dayaalin sipsip nalak lu ngo, de memek nalak lu ngo. ");
INSERT INTO mmo_vpl VALUES ("MT25_33","070_25_33","MAT","25","33","33","+ o 25:33-34 Luk 12:32*Ond le balaah sipsip-aso lana baale nama vasa, de memek-aso lana baale nama kêênj, ");
INSERT INTO mmo_vpl VALUES ("MT25_34","070_25_34","MAT","25","34","34","tombe omaaho lulemak-anju le naanêêl vu hil sen daale nama vasaa-to naambe, ‘Mangg samu ham nivasa, om ham anaam mando taaku sen Anutu yoo nêêl ham haalem ak vu bôôy sen hatung ngaanggis ayuuh va pin-ato. ");
INSERT INTO mmo_vpl VALUES ("MT25_35","070_25_35","MAT","25","35","35","+ o 25:35 Ais 58:7*In saahimb ahengg le ham avaat sa, tonde sa longg bambôôv in bel le ham avu be saanum, tonde sa laas vaatêêvak vu ham atombe ham hako sa lak. ");
INSERT INTO mmo_vpl VALUES ("MT25_36","070_25_36","MAT","25","36","36","De lolop ma in sa, le ham avu be saalop, tonde sa ningg lak atombe ham alaam monanggin sa, de sa nando hôôk kalaambus ond ham alaam vakaas having sa.’ ");
INSERT INTO mmo_vpl VALUES ("MT25_37","070_25_37","MAT","25","37","37","“Tombe hil anivalok-anju le daanêêl naah vu naambe, ‘Omaaho Bop, busin tana hey aahe de gahimb ahem atombe hey avaat hong? De galom bambôôv in bel atombe hey aavu be ganum? Hey akangg-ame vu le. ");
INSERT INTO mmo_vpl VALUES ("MT25_38","070_25_38","MAT","25","38","38","De busin tana hey aahe de galaam vaatêêvak-ambe hey hako hong ak, de lolop ma in hong atombe hey aavu be galop? ");
INSERT INTO mmo_vpl VALUES ("MT25_39","070_25_39","MAT","25","39","39","Tonde ganim lak osin onando hôôk kalaambus-ato ond naangelis hey alaas aahe hong?’ ");
INSERT INTO mmo_vpl VALUES ("MT25_40","070_25_40","MAT","25","40","40","+ o 25:40 Pro 19:17; Mat 10:42; 18:5; Mak 9:41*“Le sim omaaho lulemak-anju le naanêêl naah vu sil naambe, ‘Sa naanêêl keen vu ham naambe ham ahôôvu sa halingg-aso nipaya payaa-ju, ond yik lohvu ham ahôôvu sa.’ ");
INSERT INTO mmo_vpl VALUES ("MT25_41","070_25_41","MAT","25","41","41","+ o 25:41 Mat 7:23; Jut 7; Taato 20:10*Tombe mem le naanêêl vu hil sen daale nama kêênj-ato naambe, ‘Ham navu ana mem nama, om ham ana vêêl in sa be ham anjêê-ana kin sen le monaatum danggataa-to. Kin-anju ond Anutu vaav vu Saalang osin yite angela nipaya-so in nambe gaate sil lanjêê-lana. ");
INSERT INTO mmo_vpl VALUES ("MT25_42","070_25_42","MAT","25","42","42","In saahimb ahengg le ham-ame avaat sa le, de sa longg bambôôv in bel, le ham-ame avu be saanum e. ");
INSERT INTO mmo_vpl VALUES ("MT25_43","070_25_43","MAT","25","43","43","Tonde sa laas vaatêêvak le ham-ame hako sa lak e, de lolop ma in sa, le ham-ame avu be saalop e. Tonde sa ningg lak osin sa nando hôôk kalaambus, le ham-ame alaam vu sa le.’ ");
INSERT INTO mmo_vpl VALUES ("MT25_44","070_25_44","MAT","25","44","44","“Tombe hil-anju le daanêêl naah vu naambe, ‘Omaaho Bop, busin tana hey aahe de gahimb ahem osin galom bambôôv in bel, de galaam vaatêêvak, osin lolop ma in hong, tonde ganim lak osin onando hôôk kalaambus le hey-ame aahôôvu hong e?’ ");
INSERT INTO mmo_vpl VALUES ("MT25_45","070_25_45","MAT","25","45","45","Tombe omaaho lulemak e naanêêl vu sil naambe, ‘Sa naanêêl keen vu ham naambe ham-ame ahôôvu sa halingg-aso nipaya payaa-to lak va nambêênja, ond yik lohvu ham-ame ahôôvu sa le.’ ");
INSERT INTO mmo_vpl VALUES ("MT25_46","070_25_46","MAT","25","46","46","+ o 25:46 Dan 12:2; Jon 5:29*Tombe hil-anju le lana monggako nipaya nyevahaan danggata, de hil anivalok ond sil e mando metumin danggata osin danggata.” ");
INSERT INTO mmo_vpl VALUES ("MT26_1","070_26_1","MAT","26","1","1","Tombe Yesu nêêl vakasin pin-anju lung la, le mem nêêl vu yite maanggêêm-aso nambe, ");
INSERT INTO mmo_vpl VALUES ("MT26_2","070_26_2","MAT","26","2","2","+ o 26:2 Eks 12:1-27; Mat 20:18; Luk 24:7*“Ham alak ni nambe busin yuuh na vêêl e mem yale aangge busin bop busin haluusin, sen Anutu haluuh hil Islel hôôk vu Ijip bôôy-ato, tombe davu lambu Omaahonôôn Noow dukana hil namand in nambe lanyiis jak haah pako.” ");
INSERT INTO mmo_vpl VALUES ("MT26_3","070_26_3","MAT","26","3","3","Hôôk busin-anju Yuda-te himbop-aso osin kul vaha sen datung salivangin-ato silate yêêv-aso lasupin sil hôôk silate yêêv bop Kaiapas-ato yite bayêên alo, ");
INSERT INTO mmo_vpl VALUES ("MT26_4","070_26_4","MAT","26","4","4","tombe sil davu salo mop in nambe lanôôh Yesu kaatokin be lanyiis-ambe jimb. ");
INSERT INTO mmo_vpl VALUES ("MT26_5","070_26_5","MAT","26","5","5","Tonde lanêêl nambe, “Lemu yame aanôôh dôôk busin bop e, in mak hil ngeeyaata londpayo le naakund.” ");
INSERT INTO mmo_vpl VALUES ("MT26_6","070_26_6","MAT","26","6","6","Yesu nando hôôk omaaho ti baan vu Betaani, omaahôô-ju haale nambe Simon ond payêês anipaya lak yi. ");
INSERT INTO mmo_vpl VALUES ("MT26_7","070_26_7","MAT","26","7","7","+ o 26:7 Luk 7:37-38*Dando mondaya vanôôn, tonde vêêh ti hako bel galovasa hôôk buayo tatuuh ti, ond daanggo lak mone bopaata lôôt, be la hato be kaasêêh bel galovasaa-ju lak Yesu lukook. ");
INSERT INTO mmo_vpl VALUES ("MT26_8","070_26_8","MAT","26","8","8","Tombe maanggêêm-aso layi be sil ahend kalin vu be lanêêl nambe, “Vêêh-anju nawiiyak bel-anjo in? ");
INSERT INTO mmo_vpl VALUES ("MT26_9","070_26_9","MAT","26","9","9","Bel galovasaa-jo yaambu be omaaho ango baanggo jak mone bopaata, de yaambu monêê-ju vu hil sen dativak in va yuuh amêê-to ond mem nivasa.” ");
INSERT INTO mmo_vpl VALUES ("MT26_10","070_26_10","MAT","26","10","10","Le Yesu lak silate vakasin-anjo ni, om nêêl vu sil nambe, “Ham anêêl vêêh-anjo in? Manyinjo yoo samu sa nivasa lôôt. ");
INSERT INTO mmo_vpl VALUES ("MT26_11","070_26_11","MAT","26","11","11","+ o 26:11 Diu 15:11*Hil sen dativak in va yuuh amêê-to, ond sil e mando gaving ham nohvu busin pin, nganjo sak, same le mando gaving ham nohvu busin pin e. ");
INSERT INTO mmo_vpl VALUES ("MT26_12","070_26_12","MAT","26","12","12","Va sen vêêh wiing-anjo ond kaasêêh bel galovasa lak sa be samu sa ningg naavi munggin in sa navu aanggimb-ambe landaav saa-to. ");
INSERT INTO mmo_vpl VALUES ("MT26_13","070_26_13","MAT","26","13","13","Sa naanêêl keen vu ham naambe vu taaku pin sen hil daanêêl banye nivasa langaah-ato, ond va sen vêêh wiing-anjo le daanêêl gaving in hil akand bu yi.” ");
INSERT INTO mmo_vpl VALUES ("MT26_14","070_26_14","MAT","26","14","14","+ o 26:14 Jon 11:57*Tombe maanggêêm-aso nomaayuuh-ambe laam yuuh-ato ti Yudas Iskaliot, ond la vu kul vaha sen datung salivangin-ato silate yêêv-aso, ");
INSERT INTO mmo_vpl VALUES ("MT26_15","070_26_15","MAT","26","15","15","+ o 26:15 Sek 11:12*tombe nêêl vu sil nambe, “Naambe saambu Yesu dukana ham namam, ond ham e ambu vaati vu sa?” Tombe lavu mone siliva doo-ti be nomaayuuh vu yi, ");
INSERT INTO mmo_vpl VALUES ("MT26_16","070_26_16","MAT","26","16","16","le mem yoo salo mop in nambe bu Yesu dukana sil namand. ");
INSERT INTO mmo_vpl VALUES ("MT26_17","070_26_17","MAT","26","17","17","+ o 26:17 Eks 12:14-20*Busin bop busin haluusin sen Anutu haluuh hil Islel hôôk vu Ijip bôôy-ato, ond hil datongin balet lemu me-datung yis nalukala le, nganjo daya balet amu, tonde hôôk yite busin nyendoos ond Yesu-te maanggêêm-aso lala vu be lalingin nambe, “Gawiingin hey ana samu taaku sen yangga vanôôn busin haluusin mandôô-to vu tana?” ");
INSERT INTO mmo_vpl VALUES ("MT26_18","070_26_18","MAT","26","18","18","+ o 26:18 Mat 21:3*Tombe nêêl nambe, “Ham andukana taaku bop-ambe ham ana vu omaaho tii-juuto, be ham naanêêl sa naambe sa kaputung vu yi, ond ham naanêêl naambe sate busin ngaaho lak om sana angga vanôôn busin haluusin-ate gaving sate maanggêêm-aso ham mando hôôk yite bayêên-anju.” ");
INSERT INTO mmo_vpl VALUES ("MT26_19","070_26_19","MAT","26","19","19","Tombe maanggêêm-aso lawiing lohvu Yesu nêêl vu sil-ato be sil samu vanôôn busin haluusin-ate hôôk bayêên-anju. ");
INSERT INTO mmo_vpl VALUES ("MT26_20","070_26_20","MAT","26","20","20","Tonde busin hôôk atombe Yesu having sil nomaayuuh-ambe laam yuuh-ato be lala dando in nambe lanja vanôôn-anjuuto. ");
INSERT INTO mmo_vpl VALUES ("MT26_21","070_26_21","MAT","26","21","21","Daahen daya tonde Yesu nêêl vu sil nambe, “Sa naanêêl keen vu ham naambe ham ti navu bu sa dukana hil sen lanyiis saa-to namand.” ");
INSERT INTO mmo_vpl VALUES ("MT26_22","070_26_22","MAT","26","22","22","Tombe maanggêêm-aso londpayo nimeen lôôt-ambe sil ti ti lanêêl vu nambe, “Omaaho Bop, mak sa, me?” ");
INSERT INTO mmo_vpl VALUES ("MT26_23","070_26_23","MAT","26","23","23","+ o 26:23 Saam 41:9*Tombe nêêl laah nambe, “Omaaho sen haay namangg la in vanôôn hôôk tii-to, ond le bu sa dukana hil sen lanyiis saa-to namand. ");
INSERT INTO mmo_vpl VALUES ("MT26_24","070_26_24","MAT","26","24","24","Tombe Omaahonôôn Noow e jimb nohvu vakasin neep hôôk Anutu-te kaapiyaa-to, lemu omaaho sen bu Omaahonôôn Noow dukana hil namand-ato, ond le naatovu nimeen, de naambe tangganaan-ame gako omaahôô-ju le, ond mem nivasa.” ");
INSERT INTO mmo_vpl VALUES ("MT26_25","070_26_25","MAT","26","25","25","Tombe Yudas sen taato Yesu langaah-ambe hil lanôôh-ato ond nêêl vu having nambe, “Kaputung, mak sa, me?” Tombe Yesu nêêl vu nambe, “Yik hong-anja.” ");
INSERT INTO mmo_vpl VALUES ("MT26_26","070_26_26","MAT","26","26","26","+ o 26:26 Mat 14:19*Daahen mondaya vanôôn, tonde Yesu lôôh balet ak-ambe lohak vu Anutu, le mem hapok-ambe vu vu yite maanggêêm-aso, de nêêl nambe, “Ham gako naas-ambe ham angga, manyinjo sa ningg naavi.” ");
INSERT INTO mmo_vpl VALUES ("MT26_27","070_26_27","MAT","26","27","27","Tonde lôôh kap wain ti lak-ambe lohak osin pêêlis la vu Anutu, le mem vu vu sil-ande nêêl nambe, “Ham pin naanum dôôk-anjo, ");
INSERT INTO mmo_vpl VALUES ("MT26_28","070_26_28","MAT","26","28","28","+ o 26:28 Eks 24:8; Jer 31:31-34; Sek 9:11; 1Ko 10:16; Hiblu 9:20*manyinjo sa nihees sen sa kaasêêh in nambe Anutu kawiiy hil ngeeyaata-te va nipaya na, de biing-ambe Anutu-te vakasin sen jôôy lung la be neep-ato nanjip niwêêk. ");
INSERT INTO mmo_vpl VALUES ("MT26_29","070_26_29","MAT","26","29","29","Sa naanêêl vu ham naambe same le naanum wain nôôn aniluk jesin naah e, de na nohvu busin taamusin e mem sale naanum moos naah gaving ham dôôk taaku sen Aamangg oo nanggin-ato.” ");
INSERT INTO mmo_vpl VALUES ("MT26_30","070_26_30","MAT","26","30","30","+ o 26:30 Luk 22:39; Jon 18:1*Tonde lawiing laalo ti lung la, le mem laluus-ambe lala kandu Oliv. ");
INSERT INTO mmo_vpl VALUES ("MT26_31","070_26_31","MAT","26","31","31","+ o 26:31 Jon 16:32; Sek 13:7*Tombe Yesu nêêl vu sil nambe, “Peey-anjo ham pin e lompayo nimeen-ambe ham gavuuh sa, nohvu Anutu-te vakasin neep hôôk kaapiyaa-to nambe, ‘Sa navu aanyiis bik sipsip-asote heendin, de sipsip-aso gavuuh taale.’ ");
INSERT INTO mmo_vpl VALUES ("MT26_32","070_26_32","MAT","26","32","32","+ o 26:32 Mat 28:7,16*Lemu sale kandi jak naah vêêl-ambe sana Galili naamunggin ham.” ");
INSERT INTO mmo_vpl VALUES ("MT26_33","070_26_33","MAT","26","33","33","Tombe Pita nêêl vu Yesu nambe, “Sil pin e londpayo nimeen-ambe gavuuh hong, de sak same le gavuuh hong e.” ");
INSERT INTO mmo_vpl VALUES ("MT26_34","070_26_34","MAT","26","34","34","+ o 26:34 Mat 26:69-75*Le Yesu nêêl vu nambe, “Sa naanêêl keen vu hong naambe peey busin-anjo kokalêêh-ame le naasu le, de gale ganjak alum in sa balon yaal vêêl e.” ");
INSERT INTO mmo_vpl VALUES ("MT26_35","070_26_35","MAT","26","35","35","+ o 26:35 Mat 26:56; Jon 11:16*Lemu Pita nêêl vu nambe, “Same le anjak alungg in hong e, yik lanyiis sa be saanggimb gaving hong ond lung.” Tombe yik maanggêêm-aso pin lanêêl nambêênjo having. ");
INSERT INTO mmo_vpl VALUES ("MT26_36","070_26_36","MAT","26","36","36","+ o 26:36 Jon 18:1*Tombe Yesu having maanggêêm-aso be lala lato taaku Getesmaane, tombe nêêl vu sil nambe, “Ham mandôô-jo de sana nganju be saanohak vêêl e.” ");
INSERT INTO mmo_vpl VALUES ("MT26_37","070_26_37","MAT","26","37","37","Tombe hako Pita having Sebedi noow ayuuh Jems ayuuh Jon-ambe sil lala, tombe lopayo nimeen-ambe nahees lôôt, ");
INSERT INTO mmo_vpl VALUES ("MT26_38","070_26_38","MAT","26","38","38","+ o 26:38 Jon 12:27*om nêêl vu yaal nambe, “Sa longgpayo nimeen lôôt lohvu saanggimb, om maal mandôô-jo be maal oo mem naatum gaving sa.” ");
INSERT INTO mmo_vpl VALUES ("MT26_39","070_26_39","MAT","26","39","39","+ o 26:39 Hiblu 5:7-8; Mat 6:10*De hataah la diin daka, be la hato pataav baambu be neep voon, de lohak nambe, “O Aamangg, naambe lohvu ond ganôôh kap nimeen-atêênjo vêêl in sa, lemu same naanêêl e, goo gate va.” ");
INSERT INTO mmo_vpl VALUES ("MT26_40","070_26_40","MAT","26","40","40","Tonde laah hato vu maanggêêm ayaal, le yi de yaal deep, tombe nêêl vu Pita nambe, “Nambe va? Ham-ame alohvu nambe ham mando mem naatum daka gaving sa le? ");
INSERT INTO mmo_vpl VALUES ("MT26_41","070_26_41","MAT","26","41","41","+ o 26:41 Mat 6:13; Hiblu 2:14; 4:15*Ham mando mem naatum-ambe ham anohak in palapin vaha me-kape ham e. Ham alom nawiingin lemu ham anim naavi nitambo.” ");
INSERT INTO mmo_vpl VALUES ("MT26_42","070_26_42","MAT","26","42","42","Tonde yik laah tu balon yuuh-ambe lohak nambe, “O Aamangg, sa baaku nimeen-anjo pin de me-lohvu nambe gambu vêêl in sa le ond lung, yik soo le aambiing nohvu gakam.” ");
INSERT INTO mmo_vpl VALUES ("MT26_43","070_26_43","MAT","26","43","43","Tonde lo-hato be yi le yaal deep in mend animeen lôôt, ");
INSERT INTO mmo_vpl VALUES ("MT26_44","070_26_44","MAT","26","44","44","+ o 26:44 2Ko 12:8*tonde yoo laah-ambe la lohak vakasin timuu-jo yesin laah tu balon yaal. ");
INSERT INTO mmo_vpl VALUES ("MT26_45","070_26_45","MAT","26","45","45","Tombe lo-hato vu maanggêêm-aso be nêêl vu sil nambe, “Ham sawaah-ambe naahen nahop a? Ham angge, ngaaho lak in davu lambu Omaahonôôn Noow dukana hil anipaya namand. ");
INSERT INTO mmo_vpl VALUES ("MT26_46","070_26_46","MAT","26","46","46","+ o 26:46 Jon 14:31*Ham kandi jak in yana. Ham angge, omaaho sen navu taato sa langaah-ato hato ni.” ");
INSERT INTO mmo_vpl VALUES ("MT26_47","070_26_47","MAT","26","47","47","Yesu naahen monanêêl vakasin-anjo, tonde sil nomaayuuh-ambe laam yuuh-anjôôto ti Yudas hato pavis, ond hako hil alu bopaata ti be lalaam having yi. Lako yipak ayuuh tapum having-ambe lalaam, ond Yuda-te himbop-aso osin kul vaha sen datung salivangin-ato silate yêêv-aso yoo lawiing ondeey sil lalaam. ");
INSERT INTO mmo_vpl VALUES ("MT26_48","070_26_48","MAT","26","48","48","De omaaho sen navu taato Yesu langaah-ato ond samu vakasin lung la vu sil nambe, “Ham angge naambe sa naamuuh omaahôô-ju gaambôôk ond yik yii-ju, tombe ham anôôh.” ");
INSERT INTO mmo_vpl VALUES ("MT26_49","070_26_49","MAT","26","49","49","Om la vu Yesu pavis-ambe nêêl nambe, “Busin Kaputung.” Tonde muuh Yesu gaambôôk, ");
INSERT INTO mmo_vpl VALUES ("MT26_50","070_26_50","MAT","26","50","50","tombe Yesu nêêl vu nambe, “Hali, va sen galaam in nambe gambiing-ato ond gambiing pavis.” Nambêênju tonde hil lala ngaaho be llôôh namand ak Yesu be lapuvu tatin. ");
INSERT INTO mmo_vpl VALUES ("MT26_51","070_26_51","MAT","26","51","51","+ o 26:51 Jon 18:26*Tombe hil sen daale having Yesuu-to ond ti lôôh yipak ak-ambe sap yêêv bop salivangin-ate yite hil kul ti nanye vaalu be yêêhin. ");
INSERT INTO mmo_vpl VALUES ("MT26_52","070_26_52","MAT","26","52","52","+ o 26:52 Jen 9:6; Taato 13:10*Le Yesu nêêl vu nambe, “Ganjop gate yipak dukanaah naavi, in hil sen dalôôh ngaamong ak-ambe dayiis omaahonôôn-ato, ond ngaamong e nyiis sil-ambe lanjimb. ");
INSERT INTO mmo_vpl VALUES ("MT26_53","070_26_53","MAT","26","53","53","Mak gakam vu nambe same aalohvu nambe sa kataangg Mangg e? Sa kataangg ond le biing angela-so ngeeyaata lôôt lanaam pavis in landôôvu sa. ");
INSERT INTO mmo_vpl VALUES ("MT26_54","070_26_54","MAT","26","54","54","Le naambe saambiing naambêênju ond Anutu-te vakasin sen neep hôôk kaapiyaa-to le nôôn jak naambe va? In vakasin-anju nêêl taato va sen navu naatovu saa-to.” ");
INSERT INTO mmo_vpl VALUES ("MT26_55","070_26_55","MAT","26","55","55","+ o 26:55 Luk 19:47; 21:37*Tombe Yesu nêêl vu hil sen lalaam in lanôôh yii-to nambe, “Ham alaam in ham anôôh sa, lemu nambe vaati sen ham hako yipak ayuuh tapum having ham-ambe ham alaam nambe sen ham alaam vu omaaho hôôndak ti? Lohvu busin pin sa nando monaawiing tanasin hôôk Anutu-te dumb bop alo, le ham-ame nalôôh sa le. ");
INSERT INTO mmo_vpl VALUES ("MT26_56","070_26_56","MAT","26","56","56","+ o 26:56 Mat 26:31; Jon 16:32*Lemu va pin-anjo nawiing in nambe Anutu-te vakasin sen hil danêêl langaah-ambe neep hôôk kaapiyaa-to nôôn jak.” Nêêl vakasin-anjo tonde maanggêêm-aso pin lavuuh yi de lapak-ambe lala. ");
INSERT INTO mmo_vpl VALUES ("MT26_57","070_26_57","MAT","26","57","57","Hil sen lalôôh Yesuu-to ond lako la vu kul vaha sen datung salivangin-ato silate yêêv bop Kaiapas, tombe hil tanasin dangga-so osin himbop-aso lasupin sil lalaam timuu-ju. ");
INSERT INTO mmo_vpl VALUES ("MT26_58","070_26_58","MAT","26","58","58","Tonde Pita motaamuyin, le ma de yoo naale aheseseey daka, tombe monala be tok la yêêv bop salivangin-ate baan talind, tombe lukala be la hato nando having ahevaavu-so in ji naambe le naambe vaati vu Yesu. ");
INSERT INTO mmo_vpl VALUES ("MT26_59","070_26_59","MAT","26","59","59","Tombe kul vaha sen datung salivangin-ato silate yêêv-aso osin kaansol-aso pin davu salo omaahonôôn in nambe sil tatuhin vakasin jak Yesu in lanyiis-ambe jimb. ");
INSERT INTO mmo_vpl VALUES ("MT26_60","070_26_60","MAT","26","60","60","Tombe hil ngeeyaata lanêêl vakasin tatuhin lak yi, le ma de yêêv-aso me-latovu vakasin dangga ti in nambe lanyiis-ambe jimb e, tonde sim omaaho yuuh lalu-daale ");
INSERT INTO mmo_vpl VALUES ("MT26_61","070_26_61","MAT","26","61","61","+ o 26:61 Jon 2:19-21*be yuuh lanêêl nambe, “Hey hangoyin-ande omaahôô-ja nêêl nambe, ‘Saalohvu nambe sa kawiiy Anutu-te dumb vaambuung de nohvu busin yaal ond sa daav jesin naah.’” ");
INSERT INTO mmo_vpl VALUES ("MT26_62","070_26_62","MAT","26","62","62","Tombe yêêv bop salivangin-ate kandi naale be nêêl vu Yesu nambe, “Game nanêêl vakasin ti laah e? Omaaho yuuh-anjo danêêl vaaheey lak hong?” ");
INSERT INTO mmo_vpl VALUES ("MT26_63","070_26_63","MAT","26","63","63","+ o 26:63 Ais 53:7; Mat 27:12*Le Yesu yoo naale lava masin lôôt, tombe yêêv bop salivangin-ate nêêl vu nambe, “Saanjingin hong jak Anutu metumin haale be onaanêêl vu hey e, naambe hong Anutu Noow sen yoo holin hong vulôôt in nambe gandôôvu hey-ato, me malis?” ");
INSERT INTO mmo_vpl VALUES ("MT26_64","070_26_64","MAT","26","64","64","+ o 26:64 Saam 110:1; Dan 7:13; Mat 24:30*Le Yesu nêêl vu nambe, “Yik ganêêl-anja. Om sa naanêêl vu ham naambe ham e angge Omaahonôôn Noow e mando Niwêêk Danggakook nama vasa, de mando jak bayiimb baandoni be naam.” ");
INSERT INTO mmo_vpl VALUES ("MT26_65","070_26_65","MAT","26","65","65","+ o 26:65 Sin 14:14; Mat 9:3; Jon 10:33*Tombe yêêv bop salivangin-ate hango Yesu-te vakasin-anjo, om kweek yite lolop nambe Anutu le ahekalin vu Yesu, de nêêl vu yêêv-aso nambe, “Ham hil, laanggôôl Anutu, om yiiy navu salo omaahonôôn in nambe le daanêêl vaati gaving? In ham hango nambe nêêl Anutu palêê-jo, ");
INSERT INTO mmo_vpl VALUES ("MT26_66","070_26_66","MAT","26","66","66","+ o 26:66 Lev 24:16; Jon 19:7*om ham akam vu nambe vaati?” Tombe sil lanêêl laah vu nambe, “Nêêl vakasin anipaya om yaanyiis-ambe jimb.” ");
INSERT INTO mmo_vpl VALUES ("MT26_67","070_26_67","MAT","26","67","67","+ o 26:67 Ais 50:6; 53:5*Tombe sil kasuv ak Yesu me, de sil layiis osin sil patap, ");
INSERT INTO mmo_vpl VALUES ("MT26_68","070_26_68","MAT","26","68","68","tonde lanêêl pale nambe, “Hong omaaho sen Anutu yoo holin hong vulôôt-anja keen a? Om onaanêêl omaaho ti sen yiis hong-ato langaah vu hey e.” ");
INSERT INTO mmo_vpl VALUES ("MT26_69","070_26_69","MAT","26","69","69","Pita naahen nando talind voon, tonde vêêh kul ti hato vu be nêêl nambe, “Hong-anja navu taamuyin Yesu vu Galili having-ato.” ");
INSERT INTO mmo_vpl VALUES ("MT26_70","070_26_70","MAT","26","70","70","Le ma de Pita lak alu vu hil pin sen dando talind-anjuuto mend nambe, “Sa doosin va sen ganêêl-anja.” ");
INSERT INTO mmo_vpl VALUES ("MT26_71","070_26_71","MAT","26","71","71","Tombe seelin hato laah naale hôôk vinavi voon, tonde vêêh ango yi, tombe nêêl vu hil sen daalêê-juuto nambe, “Omaahôô-ja having Yesu Nasaalet.” ");
INSERT INTO mmo_vpl VALUES ("MT26_72","070_26_72","MAT","26","72","72","Le Pita lak alu yesin laah nambe, “Sa doosin omaahôô-ju, keen baandoni.” ");
INSERT INTO mmo_vpl VALUES ("MT26_73","070_26_73","MAT","26","73","73","Daahen daale daka tonde hil sen daalêê-ju lala vu Pita be lanêêl nambe, “Keen, hil-anjuuto silate ti hong-anja, in hey hango olavam kaangesin.” ");
INSERT INTO mmo_vpl VALUES ("MT26_74","070_26_74","MAT","26","74","74","Le Pita nêêl Anutu haale osin nêêl nambe, “Sa doosin omaahôô-ju, keen baandoni.” Tonde pavis atombe kokalêêh su, ");
INSERT INTO mmo_vpl VALUES ("MT26_75","070_26_75","MAT","26","75","75","+ o 26:75 Mat 26:34*tombe mem Pita ka vu vakasin sen Yesu nêêl vuu-to nambe, “Kokalêêh-ame naasu le, de gale ganjak alum in sa balon yaal vêêl e.” Ka vu vakasin-anju, om hato la voon-ambe ka pasiv-ambe su lôôt. ");
INSERT INTO mmo_vpl VALUES ("MT27_1","070_27_1","MAT","27","1","1","Samiinaanôôn atombe Yuda-te himbop-aso osin kul vaha sen datung salivangin-ato silate yêêv-aso pin lanjôôy vakasin nambe lanyiis Yesu be jimb, ");
INSERT INTO mmo_vpl VALUES ("MT27_2","070_27_2","MAT","27","2","2","om sil talu de laandiiy-ambe lala vu yêêv bop Lom ti, haale nambe Pilata. ");
INSERT INTO mmo_vpl VALUES ("MT27_3","070_27_3","MAT","27","3","3","+ o 27:3 Mat 26:14-15*Tombe omaaho sen taato Yesu langaah-ato Yudas, ond yi de yêêv-aso lango Yesu-te vakasin-ambe lanêêl nambe jimb, tombe lopayo nimeen ak in nambe yoo wiing Yesu paya, om hako mone siliva doo-ti be nomaayuuh-anju laah vu yêêv-aso salivangin-ate osin himbop-aso, ");
INSERT INTO mmo_vpl VALUES ("MT27_4","070_27_4","MAT","27","4","4","tombe nêêl nambe, “Soo aawiing omaaho sen nipaya me-neep vu yii-juuto paya, be saavu lukala ham namam in nambe ham anyiis-ambe jimb.” Le sil lanêêl nambe, “Hey-ame heyate va le, goo gate va.” ");
INSERT INTO mmo_vpl VALUES ("MT27_5","070_27_5","MAT","27","5","5","Tombe Yudas haate monêê-ju lukala dumb vaambuung alo, tonde hato laah voon-ambe la vaaku ka be yimb. ");
INSERT INTO mmo_vpl VALUES ("MT27_6","070_27_6","MAT","27","6","6","Tombe yêêv-aso salivangin-ate paatuk monêê-ju be lanêêl nambe, “Monêê-jo yiiy vaanggo omaaho ti nihees ak, om me-lohvu nambe yiiy gatung dukana gaving mone salivangin-ate le.” ");
INSERT INTO mmo_vpl VALUES ("MT27_7","070_27_7","MAT","27","7","7","Om sil lakaas in lung la tonde mem lako monêê-ju be lala laanggo ngaanggis boow ti vu hil sen dawiing kul in davu samu dêêngg-ato, in nambe landaav hil bamaan vu taaku ango danjip hôôk ngaanggis-anju, ");
INSERT INTO mmo_vpl VALUES ("MT27_8","070_27_8","MAT","27","8","8","ondeey danêêl taakuu-ju haale nambe Ngaanggis Ngaamong Nihees-ate be neep-ambe gêên-anju. ");
INSERT INTO mmo_vpl VALUES ("MT27_9","070_27_9","MAT","27","9","9","+ o 27:9 Sek 11:12-13; Jer 32:6-9*Ond vaa-ju wiing-ambe Anutu-te vakasin sen Yelemia nêêl bôôy-ato nôôn ak nambe, “Lako mone siliva doo-ti be nomaayuuh sen hil Islel laliinggis nambe sil e baanggo yi jak-ato, ");
INSERT INTO mmo_vpl VALUES ("MT27_10","070_27_10","MAT","27","10","10","tombe laanggo ngaanggis boow ti vu omaaho sen navu samu dêêngg-ato, lohvu Omaaho Bop nêêl vu saa-to.” ");
INSERT INTO mmo_vpl VALUES ("MT27_11","070_27_11","MAT","27","11","11","Tombe Yesu la naale yêêv bop Pilata me, tombe yêêv lingin nambe, “Yuda-te omaaho lulemak hong a?” Tombe Yesu liinggis nambe, “Yik ganêêl-anja.” ");
INSERT INTO mmo_vpl VALUES ("MT27_12","070_27_12","MAT","27","12","12","+ o 27:12 Ais 53:7; Mat 26:63*Tonde kul vaha sen datung salivangin-ato silate yêêv-aso osin himbop-aso lanêêl vakasin lak yi, lemu Yesu me-nêêl vakasin ti laah e. ");
INSERT INTO mmo_vpl VALUES ("MT27_13","070_27_13","MAT","27","13","13","Tombe Pilata nêêl vu Yesu nambe, “Game nango vakasin ngeeyaata sen danêêl lak hong-anja le?” ");
INSERT INTO mmo_vpl VALUES ("MT27_14","070_27_14","MAT","27","14","14","+ o 27:14 Jon 19:9*Le ma de Yesu me-nêêl vakasin ti laah vu le, om yêêv-anju ka la ngeey. ");
INSERT INTO mmo_vpl VALUES ("MT27_15","070_27_15","MAT","27","15","15","Lohvu ta pin hôôk hil Yuda-te busin bop busin haluusin sen Anutu haluuh hil Islel hôôk vu Ijip bôôy-ato, ond silate gambum ti neep nambe sil davu kataangg kalaambus-aso ti de Pilata navu kavaayin kalaambus tii-ju be navu la malis vu sil. ");
INSERT INTO mmo_vpl VALUES ("MT27_16","070_27_16","MAT","27","16","16","Tombe hôôk busin-anju ond kalaambus ti haale nambe Balabas nando, ond hil pin lango haale, ");
INSERT INTO mmo_vpl VALUES ("MT27_17","070_27_17","MAT","27","17","17","om sen hil Yuda lasupin sil lala vu Pilataa-to ond lingin sil nambe, “Om ham awiingin nambe sa kavaayin omaaho ango tana vu ham? Sa kavaayin Balabas me sa kavaayin Yesu sen danêêl nambe Kalisii-to?” ");
INSERT INTO mmo_vpl VALUES ("MT27_18","070_27_18","MAT","27","18","18","+ o 27:18 Jon 11:47-48; 12:19*Pilata lingin sil nambêênjo in lak ni nambe sil ahend anipaya vu Yesu, ondeey sil laandiiy la vu yi. ");
INSERT INTO mmo_vpl VALUES ("MT27_19","070_27_19","MAT","27","19","19","Tombe Pilata naahen nando nangoyin vakasin, tonde vane wiing vakasin la hato vu nambe, “Game namam jak omaaho nivalok-anju le, in saahe mavin ti lak yi gêên, tombe wiing-ambe sa nahangg lak lôôt.” ");
INSERT INTO mmo_vpl VALUES ("MT27_20","070_27_20","MAT","27","20","20","Le ma de kul vaha sen datung salivangin-ato silate yêêv-aso osin himbop-aso laanjiihin hil ngeeyaataa-ju nambe sil daanêêl vu Pilata naambe kavaayin Balabas vu sil, de nyiis Yesu be jimb. ");
INSERT INTO mmo_vpl VALUES ("MT27_21","070_27_21","MAT","27","21","21","+ o 27:21 Sin 3:14*Tombe yêêv-anju lingin sil yesin laah nambe, “Om ham awiingin nambe sa kavaayin omaaho yuuh-anju ango tana vu ham?” Tombe lanêêl nambe, “Okavaayin Balabas.” ");
INSERT INTO mmo_vpl VALUES ("MT27_22","070_27_22","MAT","27","22","22","Tombe Pilata nêêl vu sil nambe, “De Yesu sen danêêl nambe Kalisii-to ond saambiing vaati vu?” Le sil pin lanêêl nambe, “Ganyiis jakana haah pako.” ");
INSERT INTO mmo_vpl VALUES ("MT27_23","070_27_23","MAT","27","23","23","Tombe lingin sil nambe, “In? Wiing vaati paya deey?” Le ma de sil oo lateey niwêêk lôôt nambe, “Ganyiis jakana haah pako.” ");
INSERT INTO mmo_vpl VALUES ("MT27_24","070_27_24","MAT","27","24","24","+ o 27:24 Diu 21:6-9; Mat 27:4*Tombe Pilata yi nambe sil-ame le gango lava le, ma, ngaaho lak in lambiing ngaamong, om hako bel-ambe lipis nama nambe sen valoohin yi hôôk hil ngeeyaataa-ju mend de nêêl nambe, “Sa kaasêêh omaahôô-ju nihees ond nyevahaan-ame le nanjip vu sa le, ham oote va.” ");
INSERT INTO mmo_vpl VALUES ("MT27_25","070_27_25","MAT","27","25","25","+ o 27:25 Mat 23:35; Sin 5:28*Tombe hil pin lanêêl laah vu nambe, “Sen nihees kaasêêh-ato ond nyevahaan yoo le nanjip vu hey o noongg-aso.” ");
INSERT INTO mmo_vpl VALUES ("MT27_26","070_27_26","MAT","27","26","26","Tombe Pilata kavaayin Balabas-ambe vu la vu sil, de Yesu ond nêêl-ambe ahevaavu-so laveek lôôt, le mem vu lukala hil Lom ngaamong vaha-so namand in nambe lanyiis jakana haah pako. ");
INSERT INTO mmo_vpl VALUES ("MT27_27","070_27_27","MAT","27","27","27","Yêêv bop-ate hil ngaamong vaha-so lako Yesu be lalukala yêêv-ate taaku lopayo, tombe ngaamong vaha-so pin lasupin sil lalaam vu. ");
INSERT INTO mmo_vpl VALUES ("MT27_28","070_27_28","MAT","27","28","28","+ o 27:28 Luk 23:11*Tombe sil lakaah Yesu-te lolop-ande lalop lolop anihees ti lukala yi, be davu taahu omaaho lulemak lak yi. ");
INSERT INTO mmo_vpl VALUES ("MT27_29","070_27_29","MAT","27","29","29","Tonde lasêêy hees aniyin-ambe lambuuhin tombe latung lakala Yesu lu, tonde lavu paatôôn ngasing lukala nama vasa osin latung kaatu vu, de sil pale yi nambe, “Yuda-te omaaho lulemak, omando.” ");
INSERT INTO mmo_vpl VALUES ("MT27_30","070_27_30","MAT","27","30","30","+ o 27:30 Ais 50:6*Tombe sil kasuv ak me, de lalôôh paatôôn ngasing-ambe laveek Yesu lukook ak. ");
INSERT INTO mmo_vpl VALUES ("MT27_31","070_27_31","MAT","27","31","31","Sil pale Yesu lung la, le mem sil lakaah lolop anihees-anju vêêl in Yesu, de yoo lalop yite lolop lukalaah yi, tonde mem lako be lala in lanyiis jakana haah pako. ");
INSERT INTO mmo_vpl VALUES ("MT27_32","070_27_32","MAT","27","32","32","Lala lak atonde latovu hil Sailini ti haale nambe Simon, tombe hil ngaamong vaha-so lanêêl niwêêk lôôt vu yi om kava Yesu-te haah pako. ");
INSERT INTO mmo_vpl VALUES ("MT27_33","070_27_33","MAT","27","33","33","Lala lato taaku ti haale nambe Golagaata, dangga nambe taaku lukook, ");
INSERT INTO mmo_vpl VALUES ("MT27_34","070_27_34","MAT","27","34","34","+ o 27:34 Saam 69:21*tombe sil kaasêêh malaasin anikalin ti lukala wain-ande lavu vu Yesu in nambe naanum, tombe tep, le ma de nimbaya. ");
INSERT INTO mmo_vpl VALUES ("MT27_35","070_27_35","MAT","27","35","35","+ o 27:35 Saam 22:18*Tombe hil ngaamong vaha-so layiis Yesu lakala haah pako lung la, tonde sil laate tatuuh-ambe tambe lak Yesu-te lolop-ande latiiy lohvu sil. ");
INSERT INTO mmo_vpl VALUES ("MT27_36","070_27_36","MAT","27","36","36","Lung laa tonde mondanggin yi be dandôô-ju, ");
INSERT INTO mmo_vpl VALUES ("MT27_37","070_27_37","MAT","27","37","37","tonde sil kaavu vakasin sen lanêêl ak yii-to lakala neep haah pako lu baandoni nambe, “Yesu sen Yuda-te Omaaho Lulemak-anjo.” ");
INSERT INTO mmo_vpl VALUES ("MT27_38","070_27_38","MAT","27","38","38","+ o 27:38 Ais 53:12*Tombe layiis hil hôôndak yuuhapim daale having Yesu, ango naale nama vasa, de ango naale nama kêênj. ");
INSERT INTO mmo_vpl VALUES ("MT27_39","070_27_39","MAT","27","39","39","+ o 27:39 Saam 22:7; 109:25*Tombe hil sen daale danjung-anjuuto layi be lalaah namand vu, de laanggôôl Yesu ");
INSERT INTO mmo_vpl VALUES ("MT27_40","070_27_40","MAT","27","40","40","+ o 27:40 Mat 26:61; Jon 2:19*nambe, “Wopo, hong sen ganêêl nambe gale kawiiy Anutu-te dumb vaambuung, de nohvu busin yaal gale gandaav naah-ato, om goo gandôôvu hong. Naambe hong Anutu Noow ond goo gavuuh haah pakôô-ja de ganduus-ambe ganaam voon-o.” ");
INSERT INTO mmo_vpl VALUES ("MT27_41","070_27_41","MAT","27","41","41","Tonde yik kul vaha sen datung salivangin-ato silate yêêv-aso osin tanasin dangga-so de himbop-aso lawiing kangasin vu Yesu nambêênju having nambe, ");
INSERT INTO mmo_vpl VALUES ("MT27_42","070_27_42","MAT","27","42","42","+ o 27:42 Jon 11:50*“Hôôvu hil vaalu de me-lohvu nambe yoo dôôvu yi le. Om naambe Islel-ate omaaho lulemak yii-ju ond duus-ambe naam voon, tomem yaambiing gaving yi. ");
INSERT INTO mmo_vpl VALUES ("MT27_43","070_27_43","MAT","27","43","43","+ o 27:43 Saam 22:8; Jon 5:18*Yoo wii-having Anutu be nêêl nambe Anutu Noow yi, om peey naambe Anutu wiingin ond dôôvu yi.” ");
INSERT INTO mmo_vpl VALUES ("MT27_44","070_27_44","MAT","27","44","44","Tombe hil hôôndak yuuh sen layiis yuuh daale having Yesuu-to ond yuuh lanêêl Yesu pale nambêênju having. ");
INSERT INTO mmo_vpl VALUES ("MT27_45","070_27_45","MAT","27","45","45","+ o 27:45 Emo 8:9*Tonde taaku mekaalus laam naale lavuun atombe taaku mekanu hôôk lohvu taaku pin-ambe laam soosin hôôk lohvu taaku me yaal. ");
INSERT INTO mmo_vpl VALUES ("MT27_46","070_27_46","MAT","27","46","46","+ o 27:46 Saam 22:1*Tombe taaku me yaal-anjo Yesu teey bopaata lôôt nambe, “Eli, Eli, lama sabatani?” Dangga nambe, “Sate Anutu, sate Anutu, nambe vaati om ohavuuh sa la?” ");
INSERT INTO mmo_vpl VALUES ("MT27_47","070_27_47","MAT","27","47","47","Tombe hil sen daalêê-juuto vaalu langoyin-ambe lanêêl nambe, “Nateey Eliya.” ");
INSERT INTO mmo_vpl VALUES ("MT27_48","070_27_48","MAT","27","48","48","+ o 27:48 Saam 69:21*Tonde sil ti saloongg pavis-ambe la hako malumak-ambe laanggôôl hôôk bel anikalin, tombe havingin malumak-anju hôôk ngasing vaha de hako be la vu lukala Yesu avi in nambe dasuvin. ");
INSERT INTO mmo_vpl VALUES ("MT27_49","070_27_49","MAT","27","49","49","Le hil vaalu lanêêl nambe, “Ham baale de yaangge naambe Eliya le naam dôôvu yi me le nama.” ");
INSERT INTO mmo_vpl VALUES ("MT27_50","070_27_50","MAT","27","50","50","Tombe Yesu teey bopaata lôôt yesin laah-ande yimb la. ");
INSERT INTO mmo_vpl VALUES ("MT27_51","070_27_51","MAT","27","51","51","+ o 27:51 Eks 26:31-33; Hiblu 10:19-20*Tombe tôômb bopaata dinaandiin lôôt, yik tôômb-anju yakaluuh Anutu-te dumb vaambuung alopayôô-to, ond kweek la yuuh vu vaavu be la hoow, tonde taaku yêêy osin tatuuh bo-bop hapok. ");
INSERT INTO mmo_vpl VALUES ("MT27_52","070_27_52","MAT","27","52","52","Tonde bandumb avi hataahin-ande Anutu-te hil ngeeyaata sen sil layimb lung laa-to ond sil kandi vasa hôôk osin nind naavi doos, ");
INSERT INTO mmo_vpl VALUES ("MT27_53","070_27_53","MAT","27","53","53","tombe sil lavuuh bandumb, tonde Yesu kandi lak vêêl e mem lalukala taaku vaambuung Yelusalem atombe hil ngeeyaata layi mend ak sil. ");
INSERT INTO mmo_vpl VALUES ("MT27_54","070_27_54","MAT","27","54","54","Tombe hil Lom ngaamong vaha-sote yêêv osin yite hil ngaamong vaha-so sen sil mondanggin Yesu-te haah pakôô-to having ond sil langoyin jemaapi yuuh va pin, tombe layêênin lôôt de lanêêl nambe, “Omaahôô-jo Anutu Noow keen.” ");
INSERT INTO mmo_vpl VALUES ("MT27_55","070_27_55","MAT","27","55","55","+ o 27:55 Luk 8:2-3*Tonde vêêh ngeeyaata daale diin daka be mondayi, ond sil sen sil mondahôôvu Yesu lak busin pin-ato ond sil taamuyin Yesu vu Galili be lalaam. ");
INSERT INTO mmo_vpl VALUES ("MT27_56","070_27_56","MAT","27","56","56","+ o 27:56 Mat 20:20*Tombe sil-anju yaal ond ti Malia vu Magadala, de ango Malia sen Jems ayuuh Yusep taandin-ato, tonde tik Sebedi noow Jems ayuuh Jon taandin. ");
INSERT INTO mmo_vpl VALUES ("MT27_57","070_27_57","MAT","27","57","57","Soosin hôôk atombe omaaho kupak dangga ti haale nambe Yusep vu Alimatia valup, ond Yesu-te hil ti yi, ");
INSERT INTO mmo_vpl VALUES ("MT27_58","070_27_58","MAT","27","58","58","+ o 27:58 Diu 21:22-23*ond la vu Pilata be kataangg Yesu naavi nambe gako be na gambe na, om Pilata nêêl-ambe lavu Yesu naavi vu yi. ");
INSERT INTO mmo_vpl VALUES ("MT27_59","070_27_59","MAT","27","59","59","Tombe Yusep hako Yesu naavi be vayum hôôk tôômb valôôy moos ti, ");
INSERT INTO mmo_vpl VALUES ("MT27_60","070_27_60","MAT","27","60","60","+ o 27:60 Ais 53:9*tombe yoo la hambe lukala neep hôôk yite lavandangga sen naahen sap hôôk tatuuh danggaa-to. Lung laa tonde tatolin tatuuh bopaata ti laah hilin bandumb avi jeen-ande la, ");
INSERT INTO mmo_vpl VALUES ("MT27_61","070_27_61","MAT","27","61","61","tonde Malia Magadala yuuh Malia ango dando mondayi lavandanggaa-ju nando vaalu. ");
INSERT INTO mmo_vpl VALUES ("MT27_62","070_27_62","MAT","27","62","62","Busin sen hil Yuda samu sil in nambe lanja vanôôn busin haluusin-atêêto lung la, tonde kul vaha sen datung salivangin-ato silate yêêv-aso osin Palisai-so, sil lavuh ti be lala vu Pilata ");
INSERT INTO mmo_vpl VALUES ("MT27_63","070_27_63","MAT","27","63","63","+ o 27:63 Mat 12:40; 16:21; Jon 2:19-21*be lanêêl nambe, “Yêêv bop-e, mem gêên hey akangg vu vakasin ti sen omaaho tatuhin vahaa-ju naahen nando metumin-ande nêêl nambe, ‘Busin yaal jung na le mem sale kandi jak naah.’ ");
INSERT INTO mmo_vpl VALUES ("MT27_64","070_27_64","MAT","27","64","64","Om onaanêêl-ambe ahevaavu-so lana ganggin bandumb-anju tatin-ambe busin yaal jung na le, in yite maanggêêm-aso le lana langgôôndak ninaavi de daanêêl vu hil naambe kandi lak vu hil yimbin-ate, tombe sil e tatuhin hil lôôt savok sen yoo tatuhin hil lung laa-to.” ");
INSERT INTO mmo_vpl VALUES ("MT27_65","070_27_65","MAT","27","65","65","Tombe Pilata nêêl vu sil nambe, “Hamate ahevaavu-so dando, om ham ana gatung sil mando in sil oo mongganggin bandumb avi nivasa lôôt.” ");
INSERT INTO mmo_vpl VALUES ("MT27_66","070_27_66","MAT","27","66","66","+ o 27:66 Dan 6:17*Tombe sil lala langgi va nikanggi lak tatuuh nanyendangga la vatinin bandumb avi, de latung ahevaavu-so dando mondanggin. ");
INSERT INTO mmo_vpl VALUES ("MT28_1","070_28_1","MAT","28","1","1","Busin sawaasin lung la tonde Sonda samiinaanôôn atombe Malia Magadala yuuh Malia ango, yuuh lala in lanji bandumb. ");
INSERT INTO mmo_vpl VALUES ("MT28_2","070_28_2","MAT","28","2","2","Tonde pavis atombe jemaapi yêêy ak taaku lôôt-ande Omaaho Bop-ate angela ti vu baandoni be lukalaam, tombe la tatolin tatuuh-anju la vêêl in bandumb avi, de nando lak tatuuh baandoni, ");
INSERT INTO mmo_vpl VALUES ("MT28_3","070_28_3","MAT","28","3","3","+ o 28:3 Mat 17:2; Sin 1:10*tombe ninaavi natêêlang nambe demak navêêl-ato, de yite tôômb ayuuh ame valôôy malis nambe bayiimb ahevalôôy. ");
INSERT INTO mmo_vpl VALUES ("MT28_4","070_28_4","MAT","28","4","4","Tonde ahevaavu-so layi tombe layêênin lôôt-ambe lahees, tombe lalupake be lala deep nambe sen hil yimbinato. ");
INSERT INTO mmo_vpl VALUES ("MT28_5","070_28_5","MAT","28","5","5","Tombe angela nêêl vu vêêh ayuuh nambe, “Mame anjêênin e. Sa lak ni nambe muuh navu salo Yesu sen layiis ak haah pakôô-to, ");
INSERT INTO mmo_vpl VALUES ("MT28_6","070_28_6","MAT","28","6","6","+ o 28:6 Mat 12:40; 16:21*le me-neep-anjo le, in kandi lak lung la lohvu yoo nêêl-ato. Manaam angge ahembaan sen neep-ato, ");
INSERT INTO mmo_vpl VALUES ("MT28_7","070_28_7","MAT","28","7","7","+ o 28:7 Mat 26:32*le mem mana naanêêl vu yite maanggêêm-aso pavis naambe kandi lak vu hil yimbin-ate, tombe le naamunggin-ambe na Galili, le mem ham e angge yi vuu-ju. Yik saanêêl vu muuh lung laa-ja.” ");
INSERT INTO mmo_vpl VALUES ("MT28_8","070_28_8","MAT","28","8","8","Tombe yuuh lavuuh bandumb pavis-ande yuuh lalaah, tombe yuuh layêênin osin lapêêlis lôôt, de yuuh latup in nambe lana daanêêl banye vu Yesu-te maanggêêm-aso. ");
INSERT INTO mmo_vpl VALUES ("MT28_9","070_28_9","MAT","28","9","9","Tonde pavis atombe Yesu tovu yuuh vu mop be nêêl vakasin osin melaas vu yuuh, tombe yuuh lala lato latung kaatu be lambe namand ak vaha, de yuuh lako haale lak, ");
INSERT INTO mmo_vpl VALUES ("MT28_10","070_28_10","MAT","28","10","10","+ o 28:10 Hiblu 2:11*tombe Yesu nêêl vu yuuh nambe, “Mame anjêênin e, mana naanêêl vu halingg-aso naambe sil lana Galili tombe sil e lanji sa vuu-ju.” ");
INSERT INTO mmo_vpl VALUES ("MT28_11","070_28_11","MAT","28","11","11","Vêêh ayuuh daahen dalaah atonde ahevaavu-so vaalu lalaah taaku bop-ambe lanêêl va pin sen tovu sil vu bandumb-ato vu kul vaha sen datung salivangin-ato silate yêêv-aso. ");
INSERT INTO mmo_vpl VALUES ("MT28_12","070_28_12","MAT","28","12","12","Tombe yêêv-aso lasupin having himbop-aso be landuuh vakasin lung la le mem lavu mone bop vu ahevaavu-so, ");
INSERT INTO mmo_vpl VALUES ("MT28_13","070_28_13","MAT","28","13","13","+ o 28:13 Mat 27:64*de lanêêl vu sil nambe, “Ham naanêêl vu hil naambe ham nahop busin-ande Yesu-te maanggêêm-aso lalup lahôôndak ninaavi. ");
INSERT INTO mmo_vpl VALUES ("MT28_14","070_28_14","MAT","28","14","14","De naambe yêêv bop gango vakasin-anja ond hey e samu vakasin vu yi de ham-ame le naatovu nimeen e.” ");
INSERT INTO mmo_vpl VALUES ("MT28_15","070_28_15","MAT","28","15","15","Tombe ahevaavu-so lako mone be lala lanêêl vakasin vu hil lohvu sen yêêv-aso lanêêl vu sil-ato, tombe vakasin-anjo la lohvu hil Yuda be neep-ambe gêên. ");
INSERT INTO mmo_vpl VALUES ("MT28_16","070_28_16","MAT","28","16","16","+ o 28:16 Mat 26:32; 28:7,10*Yesu-te maanggêêm nomaayuuh-ambe laam tii-to lala Galili, tombe lala lalup kandu ti sen Yesu nêêl taato vu sil nambe lanaa-to, ");
INSERT INTO mmo_vpl VALUES ("MT28_17","070_28_17","MAT","28","17","17","tombe sil layi Yesu om latung kaatu vu be lako haale lak, le vaalu kand yu-yuuh. ");
INSERT INTO mmo_vpl VALUES ("MT28_18","070_28_18","MAT","28","18","18","+ o 28:18 Dan 7:14; Mat 11:27; Jon 13:3; Ep 1:20-22*Tombe Yesu laam ngaaho vu sil-ambe nêêl nambe, “Anutu vu niwêêk pin vu sa in nambe sa ganggin baandoni osin voon, ");
INSERT INTO mmo_vpl VALUES ("MT28_19","070_28_19","MAT","28","19","19","+ o 28:19 Sin 1:8*om ham ana ambiing-ambe hil pin daatu sate hil, tombe ham anjipis sil jak Mangganaan ayuuh Noow-ande Vavi Vaambuung haalend, ");
INSERT INTO mmo_vpl VALUES ("MT28_20","070_28_20","MAT","28","20","20","+ o 28:20 Sin 18:10; Jon 14:23*tonde ham tatekin sate tanasin vu sil in nambe sil samu tanasin pin sen saanêêl vu ham-ato. De ham gango le, sale mando gaving ham nohvu busin pin lôôt-ambe baandoni osin voon-ate busin jung na.” ");
INSERT INTO mmo_vpl VALUES ("MK1_1","071_1_1","MRK","1","1","1","Anutu Noow Yesu Kalisi-te banye nivasa dangga nyendoos-anjo, ");
INSERT INTO mmo_vpl VALUES ("MK1_2","071_1_2","MRK","1","2","2","+ o 1:2 Mal 3:1; Mat 11:10*ond Anutu-te omaaho Yesaia kaavu munggin nambe, “Anutu nêêl nambe, ‘Onggango le, sa navu aambiing sate omaaho ti na naamunggin vu hong in samu gate mop.’ ");
INSERT INTO mmo_vpl VALUES ("MK1_3","071_1_3","MRK","1","3","3","+ o 1:3 Ais 40:3*Omaaho ti nando taaku lumbalaamb-ambe navu teey lava nambe, ‘Ham samu Omaaho Bop-ate mop, ham galo yite mop nanjip nivalok.’” ");
INSERT INTO mmo_vpl VALUES ("MK1_4","071_1_4","MRK","1","4","4","+ o 1:4 Sin 13:24; 19:4*Tombe yik Jon sen nalipis hil-ato ond la nando taaku lumbalaamb-ambe nanêêl tanasin nambe hil langgilin londpayo de lanjipis bel in nambe Anutu kawiiy silate nipaya na. ");
INSERT INTO mmo_vpl VALUES ("MK1_5","071_1_5","MRK","1","5","5","Tombe hil vu taaku Yudia pin osin hil Yelusalem pin lôôt lala vu Jon-ambe lanêêl silate va nipaya langaah, tonde lipis sil hôôk bel bop Yoladan. ");
INSERT INTO mmo_vpl VALUES ("MK1_6","071_1_6","MRK","1","6","6","+ o 1:6 2King 1:8; Mat 11:8*Jon lop lolop sen hil davu samu lak bik kamel anivalus-ato de havêêh let bik naavi, tonde naya sapeek osin bayiiluk natu yite vanôôn, ");
INSERT INTO mmo_vpl VALUES ("MK1_7","071_1_7","MRK","1","7","7","+ o 1:7 Sin 13:25*de nanêêl tanasin nambe, “Omaaho ti navu taamuyin sa, ond yite niwêêk savok sa. Sak sa omaaho nipaya, same sa ningg vasa in nambe sa kavaayin yite suul osin saambiing kul vaalu naambe hil kul-aso dawiing vu silate yêêv e. ");
INSERT INTO mmo_vpl VALUES ("MK1_8","071_1_8","MRK","1","8","8","Sak saalipis ham lak bel amu, de yik le biing-ambe ham anim vasa jak Vavi Vaambuung-ate niwêêk.” ");
INSERT INTO mmo_vpl VALUES ("MK1_9","071_1_9","MRK","1","9","9","Tonde sim Yesu vu bayêên Nasaalet Galili be la vu Jon, tombe lipis yi hôôk bel Yoladan. ");
INSERT INTO mmo_vpl VALUES ("MK1_10","071_1_10","MRK","1","10","10","Yesu naahen nahôôk bel-ambe nalakala, tombe yi baandoni kahe, de Vavi Vaambuung hato nambe manak tumbaliiy-ambe lakando yi. ");
INSERT INTO mmo_vpl VALUES ("MK1_11","071_1_11","MRK","1","11","11","+ o 1:11 Saam 2:7; Ais 42:1; Mat 12:18; Mak 9:7*Tombe lava ti laam vu baandoni nambe, “Sa noongg hong. Sahengg having hong lôôt osin sahengg anivasa vu hong.” ");
INSERT INTO mmo_vpl VALUES ("MK1_12","071_1_12","MRK","1","12","12","Tombe sim Vavi Vaambuung wiing-ambe la taaku lumbalaamb. ");
INSERT INTO mmo_vpl VALUES ("MK1_13","071_1_13","MRK","1","13","13","+ o 1:13 Saam 91:11-13*La taaku lumbalaamb sen bik bamaan-ate taakuu-to ond la nando busin doo-yuuh-ambe Saalang sahi yi, de angela dahôôvu yi. ");
INSERT INTO mmo_vpl VALUES ("MK1_14","071_1_14","MRK","1","14","14","+ o 1:14 Mak 6:17*Latung Jon hôôk kalaambus lung la, tonde Yesu la Galili be nêêl Anutu-te banye nivasa langaah nambe, ");
INSERT INTO mmo_vpl VALUES ("MK1_15","071_1_15","MRK","1","15","15","+ o 1:15 Mat 3:2; Gal 4:4*“Busin sen Anutu navu ganggin yite hil-ato laam ngaaho lak lung la, om ham anggilin ham alompayo be ham ambiing gaving banye nivasa.” ");
INSERT INTO mmo_vpl VALUES ("MK1_16","071_1_16","MRK","1","16","16","Yesu monaloh betum Galili nanyendangga tombe sim yi omaaho paahuung dangga yuuh, Simon ayuuh hali Endru, ond yuuh mondaate govak lukala betum, ");
INSERT INTO mmo_vpl VALUES ("MK1_17","071_1_17","MRK","1","17","17","+ o 1:17 Mat 13:47*tombe Yesu nêêl vu yuuh nambe, “Manaam taamuyin sa in saambiing-ambe muuh gako omaahonôôn naambe sen muuh nako paahuung-ato.” ");
INSERT INTO mmo_vpl VALUES ("MK1_18","071_1_18","MRK","1","18","18","Om yik pavis atombe yuuh lavuuh yuuhate govak-ande yuuh sapa yi be yaal lala. ");
INSERT INTO mmo_vpl VALUES ("MK1_19","071_1_19","MRK","1","19","19","Tonde sim la daka having atombe yi Sebedi noow ayuuh Jems ayuuh hali Jon, yuuh dando lak kaanu be yuuh mosamu yuuhate govak, ");
INSERT INTO mmo_vpl VALUES ("MK1_20","071_1_20","MRK","1","20","20","le pavis atombe teey yuuh lala vu yi. De yuuh lavuuh mangganaan Sebedi osin yite hil kul vaha dando lak kaanu, de yuuh taamuyin yi be lala. ");
INSERT INTO mmo_vpl VALUES ("MK1_21","071_1_21","MRK","1","21","21","+ o 1:21 Mat 4:13*Latok lala bayêên Kapenaum le mem Yuda-te busin sawaasin, tombe Yesu lukala dumb alo be wiing tanasin vu hil. ");
INSERT INTO mmo_vpl VALUES ("MK1_22","071_1_22","MRK","1","22","22","+ o 1:22 Mat 7:28-29*Tombe sil lavindis lôôt in yite tanasin, in me-nawiing tanasin nambe tanasin dangga-so le, yoo nawiing tanasin lohvu yêêv bop ti. ");
INSERT INTO mmo_vpl VALUES ("MK1_23","071_1_23","MRK","1","23","23","De omaaho ti nando hôôk dumb alo ond mamu nipaya hôôvu yi, tombe teey nambe, ");
INSERT INTO mmo_vpl VALUES ("MK1_24","071_1_24","MRK","1","24","24","+ o 1:24 Mak 5:7*“Yesu Nasaalet, gayêêvu hey in? Galaam in nambe kawiiy hey na? Sa lak ganim nambe Anutu-te omaaho vaambuung hong.” ");
INSERT INTO mmo_vpl VALUES ("MK1_25","071_1_25","MRK","1","25","25","Le Yesu nêêl mamuu-ju nambe, “Olavam nama, onggavuuh omaahonôôn-anja de gana.” ");
INSERT INTO mmo_vpl VALUES ("MK1_26","071_1_26","MRK","1","26","26","+ o 1:26 Mak 9:26*Tombe mamu hangeeyak bopaata be handu omaahonôôn-ande hato be la. ");
INSERT INTO mmo_vpl VALUES ("MK1_27","071_1_27","MRK","1","27","27","Tombe hil pin lavindis lôôt-ambe lanêêl vu sil nambe, “Vaatii-ju? Tanasin moos tii-ju mava? Nanêêl va osin niwêêk om mamu nipaya nanyend vuun in lava.” ");
INSERT INTO mmo_vpl VALUES ("MK1_28","071_1_28","MRK","1","28","28","+ o 1:28 Mat 4:24*Tombe Yesu banye la lohvu taaku Galili pin. ");
INSERT INTO mmo_vpl VALUES ("MK1_29","071_1_29","MRK","1","29","29","Sil vu dumb alo be lala voon, tombe Yesu having Jems ayuuh Jon-ambe yaal lalukala Simon ayuuh Endru-te bayêên alo. ");
INSERT INTO mmo_vpl VALUES ("MK1_30","071_1_30","MRK","1","30","30","Tombe Simon yenaavêêh anivaane be neep, tombe lanêêl vu Yesu pavis, ");
INSERT INTO mmo_vpl VALUES ("MK1_31","071_1_31","MRK","1","31","31","om la laandiiy hôôk nama be kandi lak, tombe nivaanêê-to lung la de kandi be la hayêêh vanôôn-ambe vu vu sil. ");
INSERT INTO mmo_vpl VALUES ("MK1_32","071_1_32","MRK","1","32","32","+ o 1:32 Mat 4:24*Tonde soosin hôôk-ambe taaku me lukala, tombe lako hil anind lakin osin hil sen mamu nipaya dahôôvu sil-ato pin lala vu yi. ");
INSERT INTO mmo_vpl VALUES ("MK1_33","071_1_33","MRK","1","33","33","Hil vu bayêên-anju pin lala lapup hôôk vinavi, ");
INSERT INTO mmo_vpl VALUES ("MK1_34","071_1_34","MRK","1","34","34","+ o 1:34 Mak 3:11-12*tombe wiing hil anind lakin vaha vaha ngeeyaata nind vasa nalak laah, tonde hatiiy mamu ngeeyaata be lato dala in omaahonôôn, de hilin mamu pin lavand jeen in nambe lalak ni nambe Anutu Noow yi om me-daanêêl yi langaah e. ");
INSERT INTO mmo_vpl VALUES ("MK1_35","071_1_35","MRK","1","35","35","+ o 1:35 Mat 14:23; Mak 6:46*Yesu kandi hôôk heendiisin-ambe la taaku lu malis ti tombe lohak. ");
INSERT INTO mmo_vpl VALUES ("MK1_36","071_1_36","MRK","1","36","36","Tonde Simon-aso hil sen dando having yii-to lala davu salo yi, ");
INSERT INTO mmo_vpl VALUES ("MK1_37","071_1_37","MRK","1","37","37","tombe latovu be lanêêl vu yi nambe, “Hil pin davu salo hong.” ");
INSERT INTO mmo_vpl VALUES ("MK1_38","071_1_38","MRK","1","38","38","Tombe Yesu nêêl vu sil nambe, “Yana bayêên bu ti ti sen nando ngaahôô-to in saambiing tanasin vu sil gaving. Kul-anjo sen soo alaam in-ato.” ");
INSERT INTO mmo_vpl VALUES ("MK1_39","071_1_39","MRK","1","39","39","+ o 1:39 Mat 4:23; 9:35*Om yik la hatup hôôk taaku Galili pin, be nawiing tanasin hôôk silate dumb alo ti ti, de natiiy mamu dala in omaahonôôn. ");
INSERT INTO mmo_vpl VALUES ("MK1_40","071_1_40","MRK","1","40","40","Omaaho ti nipayêês anipaya lôôt-ato la vu Yesu be hatung kaatu vu de kataangg nambe, “Lohvu gandôôvu sa be sa ningg naavi nivasa jak?” ");
INSERT INTO mmo_vpl VALUES ("MK1_41","071_1_41","MRK","1","41","41","Tombe Yesu ka pasiv in yi om hambe nama lak-ande nêêl vu nambe, “Êê-e, lohvu saandôôvu hong, om ganim naavi nivasa jak.” ");
INSERT INTO mmo_vpl VALUES ("MK1_42","071_1_42","MRK","1","42","42","Tombe yik payêês lung la pavis-ande ninaavi nivasa lak. ");
INSERT INTO mmo_vpl VALUES ("MK1_43","071_1_43","MRK","1","43","43","Lung atonde Yesu wiing-ambe la, de vu kôôvu yi nambe, ");
INSERT INTO mmo_vpl VALUES ("MK1_44","071_1_44","MRK","1","44","44","+ o 1:44 Mak 3:12; 7:36; Lev 14:1-32*“Ongganggin hong, game naanêêl vaa-jo vu omaaho ti le, nganjo gana taato ganim naavi vu kul vaha sen datung salivangin-ato ti de onggatung salivangin nohvu Mose-te tanasin nêêl-ato in nambe mem hil lanjak ni naambe ganim naavi nivasa lak lung la.” ");
INSERT INTO mmo_vpl VALUES ("MK1_45","071_1_45","MRK","1","45","45","Le ma de la monanêêl vaa-jo banye hatup hôôk, om Yesu me-lohvu nambe dukana taaku ti be taato yi langaah e, om la nando taaku lu malis ti tombe hil vu taaku pin lala vu yi. ");
INSERT INTO mmo_vpl VALUES ("MK2_1","071_2_1","MRK","2","1","1","Busin heey lung la le mem Yesu laah Kapenaum yesin, tombe hil langoyin nambe nando baan. ");
INSERT INTO mmo_vpl VALUES ("MK2_2","071_2_2","MRK","2","2","2","Om hil ngeeyaata lasupin lala vu be lapup lôôt, be lahilin vinavi having, de taaku vuuti me-neep e, tonde monanêêl Anutu-te banye nivasa vu sil. ");
INSERT INTO mmo_vpl VALUES ("MK2_3","071_2_3","MRK","2","3","3","Tombe hil lalaam-ambe omaaho yumbeyuuh laaku omaaho nipaling ti vaha yuuh nama nipayaa-to be lala in lana vu Yesu. ");
INSERT INTO mmo_vpl VALUES ("MK2_4","071_2_4","MRK","2","4","4","Le ma de hil ngeeyaata lahilin taaku de me-lukalaah nambe lana vu Yesu le, om sil kawiiy bayêên vuuti neep baandoni nivalok vu sen Yesu naalêê-to, tonde mem taaluuhin nilakin tii-jôôto osin kaanye lukala. ");
INSERT INTO mmo_vpl VALUES ("MK2_5","071_2_5","MRK","2","5","5","+ o 2:5 Luk 7:48*Yesu lak ni nambe sil alondpayo la timu vu yi om nêêl vu omaaho nipaling-anjo nambe, “Noongg-e, gate nipaya ond sa kawiiy la.” ");
INSERT INTO mmo_vpl VALUES ("MK2_6","071_2_6","MRK","2","6","6","Tombe hil tanasin dangga heey dandôô-ju kand vu nambe, ");
INSERT INTO mmo_vpl VALUES ("MK2_7","071_2_7","MRK","2","7","7","+ o 2:7 Ais 43:25; 1Jon 1:9*“Nêêl vaati nambêênju? Wiingin nambe savok Anutu. Lati lohvu nambe kawiiy nipaya na? Anutu timu yoo lohvu.” ");
INSERT INTO mmo_vpl VALUES ("MK2_8","071_2_8","MRK","2","8","8","Yesu yoo lak ni nambe sil oo kand vu nambêênju, om nêêl laah vu sil nambe, “Nambe vaati sen ham akam navu nambêênja hôôk ham alompayo? ");
INSERT INTO mmo_vpl VALUES ("MK2_9","071_2_9","MRK","2","9","9","De sa naanêêl vakasin ango tana in ham angge be ham anjak ni naambe nôôn keen? Sa naanêêl vu omaaho nipalinganjo naambe, ‘Gate nipaya ond sa kawiiy la,’ ond ham-ame le anjak ni le. Nganjo sa naanêêl naambe, ‘Okandi baale be ombaahinin gate kaanye de gana,’ ond mem ham e anjak ni naambe nôôn keen. ");
INSERT INTO mmo_vpl VALUES ("MK2_10","071_2_10","MRK","2","10","10","Om peey-anjo ham anjak ni naambe Omaahonôôn Noow laam vu baandoni ond yoo tu danggakook vu voon in nambe kawiiy hil-ate va nipaya na.” Tonde nêêl vu omaaho nipaling-anjôôto nambe, ");
INSERT INTO mmo_vpl VALUES ("MK2_11","071_2_11","MRK","2","11","11","“Sa naanêêl vu hong naambe okandi gako gate kaanye jak-ambe ganaah gambaam.” ");
INSERT INTO mmo_vpl VALUES ("MK2_12","071_2_12","MRK","2","12","12","+ o 2:12 Mat 9:33*Tombe yik kandi pavis-ambe hako yite kaanye hôôk sil amend-ambe la. Tombe lavindis lôôt be mem lako Anutu haale lak-ambe lanêêl nambe, “Yame aahe vati nambêênjo bôôy e.” ");
INSERT INTO mmo_vpl VALUES ("MK2_13","071_2_13","MRK","2","13","13","Yesu laah betum nanyendangga yesin, tombe hil pin lasupin lala vu yi be nawiing tanasin vu sil. ");
INSERT INTO mmo_vpl VALUES ("MK2_14","071_2_14","MRK","2","14","14","+ o 2:14 Jon 1:43*Lung la de monala tombe yi Alpias noow Liwi nando hôôk bayêên sen dako taakis hôôk-ato, tombe nêêl vu nambe, “Ganaam taamuyin sa.” Om kandi be la taamuyin yi. ");
INSERT INTO mmo_vpl VALUES ("MK2_15","071_2_15","MRK","2","15","15","Tombe Yesu having yite maanggêêm-aso be lala dando be mondaya vanôôn vu Liwi baan, de hil sen dako taakis osin hil sen davu kalêêh tanasin-ato ngeeyaata lalaam-ambe dando daya vanôôn having sil. Yik hil ngeeyaata nambêênju yoo davu taamuyin yi. ");
INSERT INTO mmo_vpl VALUES ("MK2_16","071_2_16","MRK","2","16","16","+ o 2:16 Mat 11:19; Luk 15:1-2*Tonde yêêv Yuda heey yoo davu sapa silate gambum ond danêêl sil nambe Palisai, ond silate tanasin dangga-so vaalu layi de Yesu naya vanôôn having hil anipaya osin hil sen dako taakis-ato, tombe lanêêl vu yite maanggêêm-aso nambe, “Nambe vaati sen naya vanôôn having hil sen dako taakis osin hil anipaya vaaluu-ju?” ");
INSERT INTO mmo_vpl VALUES ("MK2_17","071_2_17","MRK","2","17","17","Le Yesu hangoyin atombe nêêl vu sil nambe, “Hil anind vasa ond me-dala vu dokta le, nganjo hil sen nind lakin-ato ond mem dala vu. De sak same alaam in nambe naateey hil sen datee sil ak nambe sil anivasaa-to le, ma, nganjo sa laam in naateey hil anipaya.” ");
INSERT INTO mmo_vpl VALUES ("MK2_18","071_2_18","MRK","2","18","18","Busin ti Jon-ate maanggêêm sen davu sapa yii-to osin hil Palisai dalakin sil in vanôôn-ande dando meep in nambe mondanohak na vu Anutu. Tonde omaaheey lalaam-ambe lalingin Yesu nambe, “Jon-ate maanggêêm-aso osin Palisai-te hil dalakin sil in vanôôn-ande dando meep, de nambe vaati sen gate maanggêêm-aso me-dalakin sil in vanôôn e?” ");
INSERT INTO mmo_vpl VALUES ("MK2_19","071_2_19","MRK","2","19","19","Tombe Yesu nêêl vakasin pakwesin-anjo vu sil nambe, “Hil lasupin lala in daapêêlis gaving omaaho ti in hako vêêh moos ond sil-ame lalohvu nambe lanjakin sil in vanôôn-ande sil mando meep e, le nama. In silate omaahôô-ju naahen nando having sil, om sil-ame lalohvu nambe me-lanjakin sil in vanôôn-ande mando meep e. ");
INSERT INTO mmo_vpl VALUES ("MK2_20","071_2_20","MRK","2","20","20","Nganjo busin ti le naatok naam atombe hil e lanôôh omaahôô-juuto na vêêl in yite hil, ond mem le lanjakin sil in vanôôn. ");
INSERT INTO mmo_vpl VALUES ("MK2_21","071_2_21","MRK","2","21","21","“De tôômb ti nimbôôy-ambe ahembalap ak tombe kweek ond omaaho ti me-naanduuh moos kamu ti jakanaah e. Le naambe naanduuh moos kamu ti jakanaah ond le naakweek nimbôôy-ato be naatu bopaata jak. ");
INSERT INTO mmo_vpl VALUES ("MK2_22","071_2_22","MRK","2","22","22","Omaaho ti me-le naatooy wain moos dukana bik naavi nimbôôy e. Naambe kaasêêh dukana ond wain e buuk-ambe bapuuh bik naavi biliyak-ande kaasêêh na. Wain moos ond kaasêêh dukana bik naavi moos ond mem.” ");
INSERT INTO mmo_vpl VALUES ("MK2_23","071_2_23","MRK","2","23","23","+ o 2:23 Diu 23:25*Busin sawaasin ti tombe Yesu having yite maanggêêm-aso be laloh mop ti sen neep hôôk kul lavuun-ato be lala, tombe yite maanggêêm-aso kalêêh wit nôôn-ambe, landaah. ");
INSERT INTO mmo_vpl VALUES ("MK2_24","071_2_24","MRK","2","24","24","Tombe Palisai lanêêl vu yi nambe, “Gangge, nambe vaati sen davu kalêêh wit nôôn? In me-lohvu nambe yaambiing kul hôôk busin sawaasin e.” ");
INSERT INTO mmo_vpl VALUES ("MK2_25","071_2_25","MRK","2","25","25","+ o 2:25 1Sml 21:1-6*Tombe nêêl vu sil nambe, “Vu bôôy sen vanôôn ma in Devit having yite hil sen laving yii-to, ond layimb ahend tombe wiing vaati? Mak ham-ame asevin mava? ");
INSERT INTO mmo_vpl VALUES ("MK2_26","071_2_26","MRK","2","26","26","+ o 2:26 Lev 24:5-9*Nambe bôôy sen Abaiata tu yêêv bop vu kul vaha sen datung salivangin-ato, ond Devit lukala Anutu-te dumb alo tombe ya vanôôn sen hil latung vu Anutuu-to. Vanôôn-anju ond tanasin neep nambe omaahonôôn-ame lanja le, yik kul vaha salivangin-ate yoo lanja, le ma de Devit ya de vu vu yite hil having.” ");
INSERT INTO mmo_vpl VALUES ("MK2_27","071_2_27","MRK","2","27","27","+ o 2:27 Diu 5:14*Tonde Yesu nêêl vu sil nambe, “Anutu wiing busin sawaasin lundoos in dôôvu omaahonôôn, de me-hatung omaahonôôn in nambe kand bu busin sawaasin naatu bopaata lôôt savok sil e. ");
INSERT INTO mmo_vpl VALUES ("MK2_28","071_2_28","MRK","2","28","28","Om yik Omaahonôôn Noow tu busin sawaasin-ate danggakook having.” ");
INSERT INTO mmo_vpl VALUES ("MK3_1","071_3_1","MRK","3","1","1","Yesu lukala dumb alo yesin laah, tombe omaaho ti nama vaalu nipaya nandôô-ju. ");
INSERT INTO mmo_vpl VALUES ("MK3_2","071_3_2","MRK","3","2","2","+ o 3:2 Luk 13:14*Tombe hil-anju langget Yesu lôôt in nambe lanji naambe biing omaahôô-ju nama nivasa jak dôôk busin sawaasin, ond daanêêl vakasin ti jak yi. ");
INSERT INTO mmo_vpl VALUES ("MK3_3","071_3_3","MRK","3","3","3","Tombe nêêl vu omaaho ti sen nama nipayaa-to nambe, “Okandi be ganaam nganjo.” ");
INSERT INTO mmo_vpl VALUES ("MK3_4","071_3_4","MRK","3","4","4","+ o 3:4 Luk 14:3*Tonde lingin sil nambe, “Va ango tana lohvu tanasin nêêl, nambe yaambiing va nivasa dôôk busin sawaasin, me yaambiing va nipaya? Nambe yaandôôvu omaahonôôn-ambe mando nivasa me yaanyiis-ambe jimb?” Lemu sil oo dando lavand masin, ");
INSERT INTO mmo_vpl VALUES ("MK3_5","071_3_5","MRK","3","5","5","+ o 3:5 Jon 11:33; 12:40*tombe me hako hôôk sil-ande ahekalin-ambe lopayo nimeen in sil alondpayo niwêêk ak, tonde mem nêêl vu omaahôô-juuto nambe, “Otalo namam.” Om talo nama tombe nivasa lak. ");
INSERT INTO mmo_vpl VALUES ("MK3_6","071_3_6","MRK","3","6","6","+ o 3:6 Mat 22:15-16*Om pavis atombe Palisai-so laluus-ambe lala lasupin having Helot-ate hil be mem sil davu salo mopaatôôv in nambe lanyiis Yesu be jimb. ");
INSERT INTO mmo_vpl VALUES ("MK3_7","071_3_7","MRK","3","7","7","Yesu having yite maanggêêm-aso be lala betum, tombe hil Galili ngeeyaata lôôt davu taamuyin sil, de hil vu taaku Yudia, ");
INSERT INTO mmo_vpl VALUES ("MK3_8","071_3_8","MRK","3","8","8","+ o 3:8 Mat 4:25*de vu Yelusalem osin taaku Idumia, de vu bel Yoladan vaalu alo, de vu Taia yuuh Saidon. Hil ngeeyaata lôôt langoyin va pin sen nawiing-ato tombe lala vu yi, ");
INSERT INTO mmo_vpl VALUES ("MK3_9","071_3_9","MRK","3","9","9","+ o 3:9 Mak 4:1; Luk 5:1-3*om nêêl vu yite maanggêêm-aso nambe sil gako kaanu ti naam ganggin yi in nambe hil ngeeyaata om le langgilin yi. ");
INSERT INTO mmo_vpl VALUES ("MK3_10","071_3_10","MRK","3","10","10","+ o 3:10 Mat 14:36*In Yesu wiing hil ngeeyaata nind vasa lak lung la, ondeey hil anilakin pin dandu sil in nambe namand na palaah yi de nind vasa jak. ");
INSERT INTO mmo_vpl VALUES ("MK3_11","071_3_11","MRK","3","11","11","+ o 3:11 Luk 4:41*Tonde mamu nipaya sen lalukando omaahonôôn-ato layi Yesu tombe lala lato pataav baambund neep voon hôôk vaha, de langeeyak-ambe lateey nambe, “Anutu Noow hong.” ");
INSERT INTO mmo_vpl VALUES ("MK3_12","071_3_12","MRK","3","12","12","+ o 3:12 Mak 1:34*Tombe vu kôôvu sil niwêêk nambe sil-ame daanêêl yi langaah e. ");
INSERT INTO mmo_vpl VALUES ("MK3_13","071_3_13","MRK","3","13","13","Yesu lakala taaku lu kandu ti be teey hil sen wiingin sil-ato be lala vu yi. ");
INSERT INTO mmo_vpl VALUES ("MK3_14","071_3_14","MRK","3","14","14","Tombe holin sil nomaayuuh-ambe laam yuuh in nambe sil mando gaving yi, de le biing sil lana daanêêl tanasin gaving, ");
INSERT INTO mmo_vpl VALUES ("MK3_15","071_3_15","MRK","3","15","15","tonde bu niwêêk vu sil in nambe sil gatiiy mamu gato na in omaahonôôn. ");
INSERT INTO mmo_vpl VALUES ("MK3_16","071_3_16","MRK","3","16","16","+ o 3:16 Jon 1:42*Holin sil nomaayuuh-ambe laam yuuh-ato, de nêêl Simon haale ngo nambe Pita. ");
INSERT INTO mmo_vpl VALUES ("MK3_17","071_3_17","MRK","3","17","17","+ o 3:17 Luk 9:54*Tonde Sebedi noow ayuuh, Jems ayuuh Jon ond nêêl yuuh haalend ango nambe Boanesis, dangga nambe yuuh lalohvu kalang natuuh. ");
INSERT INTO mmo_vpl VALUES ("MK3_18","071_3_18","MRK","3","18","18","Tonde Endru, Pilip, Batolomai, Matai, Tomas, Alpias noow Jems, Tadias, Simon ango sen naanjiihin hil Yuda in nambe gatiiy hil Lom lanaa-to, ");
INSERT INTO mmo_vpl VALUES ("MK3_19","071_3_19","MRK","3","19","19","de Yudas Iskaliot sen taato Yesu langaah-ambe hil lalôôh-ato. ");
INSERT INTO mmo_vpl VALUES ("MK3_20","071_3_20","MRK","3","20","20","+ o 3:20 Mak 6:31*Yesu laah baan lemu hil ngeeyaata lasupin sil laah-ambe dando, tombe lahilin Yesu having yite maanggêêm-aso, de me-lalohvu nambe lanja vanôôn e. ");
INSERT INTO mmo_vpl VALUES ("MK3_21","071_3_21","MRK","3","21","21","+ o 3:21 Jon 10:20*Tombe Yesu-te hil lango be lala in nambe gako yi be lanaah, in lanêêl nambe, “Lukook wiing paya.” ");
INSERT INTO mmo_vpl VALUES ("MK3_22","071_3_22","MRK","3","22","22","+ o 3:22 Mat 9:34; 10:25*De tanasin dangga-so sen lalaam vu Yelusalem-ato lanêêl nambe, “Belsebul nando having yi.” De vaalu lanêêl nambe, “Mamu-te yêêv bop Belsebul hôôvu yi ondeey natiiy mamu la in omaahonôôn.” ");
INSERT INTO mmo_vpl VALUES ("MK3_23","071_3_23","MRK","3","23","23","Tombe Yesu teey-ambe hil lala vu yi, be nêêl vakasin pakwesin ti vu sil nambe, “Saalang e gatiiy Saalang na naambe tana? ");
INSERT INTO mmo_vpl VALUES ("MK3_24","071_3_24","MRK","3","24","24","Naambe hil taaku bop ti yoo lanyiis sil-ambe baasuh sil na lu yuuh, ond sil-ame lalohvu nambe mando nivasa le. ");
INSERT INTO mmo_vpl VALUES ("MK3_25","071_3_25","MRK","3","25","25","De naambe hil dangga ti sen dando hôôk bayêên timuu-to yoo lanyiis sil-ambe baasuh sil na lu yuuh, ond sil-ame le mando javuh ti le. ");
INSERT INTO mmo_vpl VALUES ("MK3_26","071_3_26","MRK","3","26","26","De naambe Saalang gatiiy yite kul vaha mamu nipaya-so ond sil o Saalang-aso yoo laasuh sil la lu yuuh, ond sil-ame le mando javuh ti le, le nama. ");
INSERT INTO mmo_vpl VALUES ("MK3_27","071_3_27","MRK","3","27","27","Omaaho ti me-lohvu nambe jakana omaaho nipaya niwêêk ambaan-ambe bu vêêl yite va le. Biing naambêênjo ond naanduuh yi tatin, le mem gako yinêên va pin sen lukando bayêên alôô-to be na. ");
INSERT INTO mmo_vpl VALUES ("MK3_28","071_3_28","MRK","3","28","28","“Sa naanêêl keen vu ham naambe va nipaya osin vakasin palesin pin sen omaahonôôn danêêl-ato, ond Anutu lohvu nambe kawiiy na pin, ");
INSERT INTO mmo_vpl VALUES ("MK3_29","071_3_29","MRK","3","29","29","nganjo omaaho ti naanêêl Vavi Vaambuung pale, ond Anutu me-le kawiiy na le, yoo le nanjip danggata osin danggata.” ");
INSERT INTO mmo_vpl VALUES ("MK3_30","071_3_30","MRK","3","30","30","+ o 3:30 Jon 10:20*Yesu nêêl vakasin nambêênjo in danêêl nambe mamu nipaya ti nando having yi deey. ");
INSERT INTO mmo_vpl VALUES ("MK3_31","071_3_31","MRK","3","31","31","+ o 3:31 Mak 6:3; Jon 2:12; Sin 1:14*Yesu tangganaan osin halindin lato daale voon-ambe lanêêl vakasin la vu yi. ");
INSERT INTO mmo_vpl VALUES ("MK3_32","071_3_32","MRK","3","32","32","Tonde hil ngeeyaata dando be lambuuh yi tatup tombe lanêêl vu nambe, “Ohangoyin a? Tam having halim-aso lato daale voon-ambe dalingin hong.” ");
INSERT INTO mmo_vpl VALUES ("MK3_33","071_3_33","MRK","3","33","33","Le nêêl laah vu sil nambe, “Ataak having halingg-aso laheey?” ");
INSERT INTO mmo_vpl VALUES ("MK3_34","071_3_34","MRK","3","34","34","Tonde me hako hôôk-ambe yi hil sen lambuuh yi tatup-ato be nêêl vu sil nambe, “Ham angge, ataak-aso halingg-aso sen manyinjo, ");
INSERT INTO mmo_vpl VALUES ("MK3_35","071_3_35","MRK","3","35","35","in hil sen dawiing va lohvu Anutu ka ond mem sa halingg osin sa vangaangg-ambe sa ataak-aso sil.” ");
INSERT INTO mmo_vpl VALUES ("MK4_1","071_4_1","MRK","4","1","1","+ o 4:1 Mak 3:7-9; Luk 5:1-3*Yesu laah betum nanyendangga be wiing tanasin yesin. Tombe hil ngeeyaata lasupin lala vu yi om lakala nando kaanu ti, de hil pin dando betum nanyendangga. ");
INSERT INTO mmo_vpl VALUES ("MK4_2","071_4_2","MRK","4","2","2","+ o 4:2 Mat 13:34; Mak 4:33-34*Tombe wiing tanasin lak vakasin pakwesin ngeeyaata ond nêêl ti vu sil nambe, ");
INSERT INTO mmo_vpl VALUES ("MK4_3","071_4_3","MRK","4","3","3","“Ham gango le. Omaaho ti la in nambe baalil vave dukana kul moos. ");
INSERT INTO mmo_vpl VALUES ("MK4_4","071_4_4","MRK","4","4","4","Monaalil atombe vaalu tok nando mop, tombe manak lalaam-ambe laya lôôt. ");
INSERT INTO mmo_vpl VALUES ("MK4_5","071_4_5","MRK","4","5","5","De vaalu tok lakando ngaanggis pasivdaka sen lakando tatuuh baandonii-to, tombe mem me valup pavis, ");
INSERT INTO mmo_vpl VALUES ("MK4_6","071_4_6","MRK","4","6","6","le ma de taaku vavak ak-ambe malan pavis, tombe bambôôv valok-ate in kangga me-lukala le. ");
INSERT INTO mmo_vpl VALUES ("MK4_7","071_4_7","MRK","4","7","7","De vaalu lukala ganggwak dangga, tombe ganggwak valup having-ambe yêês, om me-yiis nôôn e. ");
INSERT INTO mmo_vpl VALUES ("MK4_8","071_4_8","MRK","4","8","8","Tonde vaalu lukala ngaanggis anivasa ond valup-ambe yiis nôôn. Heey yiis nôôn doo-ti be nomaayuuh, de heey yiis nôôn doo-yaal, de heey yiis nôôn doo-namaavaalu.” ");
INSERT INTO mmo_vpl VALUES ("MK4_9","071_4_9","MRK","4","9","9","Lung atonde nêêl nambe, “Omaaho ti nambe nanye neep ond gangoyin.” ");
INSERT INTO mmo_vpl VALUES ("MK4_10","071_4_10","MRK","4","10","10","Yesu nando lundoos e mem yite maanggêêm nomaayuuh-ambe laam yuuh-ato be hil vaalu lala dando having in gango vakasin, ond lalingin vakasin pakwesin dangga vu yi. ");
INSERT INTO mmo_vpl VALUES ("MK4_11","071_4_11","MRK","4","11","11","Tombe nêêl vu sil nambe, “Ham ond mem Anutu nanêêl vakasin sen vun yii-to langaah vu ham lak sen Anutu nanggin yiiy-ato, lemu hil vaalu sen dando nanyendanggaa-to ond dango vakasin pakwesin amu, ");
INSERT INTO mmo_vpl VALUES ("MK4_12","071_4_12","MRK","4","12","12","+ o 4:12 Ais 6:9-10; Jon 12:40; Sin 28:26-27*in nambe ‘Lanji lôôt lemu me-lanjak ni le, de gangoyin lôôt lemu me-daatokak dangga le. Nambêênja sil-ame langgilin sil alondpayo naah vu Anutu, de Anutu me-kawiiy silate nipaya na le.’” ");
INSERT INTO mmo_vpl VALUES ("MK4_13","071_4_13","MRK","4","13","13","Tombe Yesu nêêl vu sil nambe, “Ham-ame alak vakasin pakwesin tii-ju ni le, om ham e anjak vakasin pakwesin pin ani naambe tana? ");
INSERT INTO mmo_vpl VALUES ("MK4_14","071_4_14","MRK","4","14","14","“Omaaho sen naalil vavêê-to ond lohvu omaaho nanêêl Anutu-te tanasin. ");
INSERT INTO mmo_vpl VALUES ("MK4_15","071_4_15","MRK","4","15","15","Vave vaalu tok nando mop ond lohvu hil vaalu dango vakasin, le ma de Saalang navu sapos vakasin sen dangôô-to nala pavis. ");
INSERT INTO mmo_vpl VALUES ("MK4_16","071_4_16","MRK","4","16","16","Tonde vave vaalu tok lakando ngaanggis pasivdaka sen lakando tatuuh baandonii-to, ond lohvu hil vaalu sen dango vakasin-ambe dako lak pavis-ambe dapêêlis, ");
INSERT INTO mmo_vpl VALUES ("MK4_17","071_4_17","MRK","4","17","17","+ o 4:17 Mat 26:31*lemu lalohvu va sen kangga me-lukala le, om dando daka vêêl e mem va nimeen natokak sil, me hil danêêl sil in davu sapa Anutu-te vakasin, tombe sim nind baya be davuuh Anutu la pavis. ");
INSERT INTO mmo_vpl VALUES ("MK4_18","071_4_18","MRK","4","18","18","Tonde vave vaalu sen tok lukala ganggwak danggaa-to, ond lohvu hil vaalu sen dango Anutu-te vakasin, ");
INSERT INTO mmo_vpl VALUES ("MK4_19","071_4_19","MRK","4","19","19","+ o 4:19 Mat 19:23-24*lemu sil alondpayo nimeen in kand navu va voon-ate osin menôôn in kupak ayuuh mone bop, de sil oo dawiingin va vaha vaha pin, tombe sil akand oo navu va nambêênjo natu bopaata nahilin Anutu-te vakasin, om me-le nôôn jak vu sil e. ");
INSERT INTO mmo_vpl VALUES ("MK4_20","071_4_20","MRK","4","20","20","De vave vaalu tok lukala ngaanggis anivasaa-to, ond lohvu hil vaalu sen dango vakasin-ambe daasu lukala londpayo be dawii-having, ond sil dayiis nôôn lohvu vave yiis nôôn anivasaa-to, ond vaalu dayiis nôôn pasivdaka lohvu vave vaalu yiis nôôn 30, de vaalu dayiis nôôn ngeey daka lohvu vave vaalu yiis nôôn 60, de vaalu dayiis ngeeyaata lôôt lohvu vave vaalu yiis nôôn 100.” ");
INSERT INTO mmo_vpl VALUES ("MK4_21","071_4_21","MRK","4","21","21","+ o 4:21 Mat 5:15*Yesu nêêl vu sil nambe, “Omaaho ti taalungg hôôk lam in nambe gatung dukana dêêngg alo me gatung dukana pêêt kambini mava? Malis, taalungg hôôk in nambe gatung jamando pêêt baandoni. ");
INSERT INTO mmo_vpl VALUES ("MK4_22","071_4_22","MRK","4","22","22","+ o 4:22 Mat 10:26; Luk 12:2*De vakasin pin sen neep vunin-ato ond le nanjip langaah, de vakasin sen vayum yii-to, ond le kavaayin naam langaah pin. ");
INSERT INTO mmo_vpl VALUES ("MK4_23","071_4_23","MRK","4","23","23","Omaaho ti nanye neep ond gangoyin.” ");
INSERT INTO mmo_vpl VALUES ("MK4_24","071_4_24","MRK","4","24","24","+ o 4:24 Mat 7:2*Tombe nêêl vu sil nambe, “Va sen ham nango ond ham akam bu nivasa mem ham e naatokak vakasin dangga, de Anutu le biing-ambe ham anjak ni lôôt. ");
INSERT INTO mmo_vpl VALUES ("MK4_25","071_4_25","MRK","4","25","25","+ o 4:25 Mat 13:12*Omaaho ti ka navu vakasin nivasa ond Anutu le bu ka vaalu gaving-ambe jak ni lôôt. Le naambe omaaho ti doosin vakasin, de me-ka navu vakasin ti le, ond kakook daka sen neep vu yii-to ond Anutu le nôôh vêêl.” ");
INSERT INTO mmo_vpl VALUES ("MK4_26","071_4_26","MRK","4","26","26","Yesu nêêl nambe, “Anutu nanggin yite hil lohvu omaaho ti naalôôh vave hôôk kul moos, ");
INSERT INTO mmo_vpl VALUES ("MK4_27","071_4_27","MRK","4","27","27","+ o 4:27 Jem 5:7*tombe omaahôô-ju neep busin-ande kandi lak hôôk samiinaanôôn lohvu busin pin, tonde vave valup lemu doosin nambe vave valup-ambe bop ak nambe tana. ");
INSERT INTO mmo_vpl VALUES ("MK4_28","071_4_28","MRK","4","28","28","Ngaanggis yoo wiing-ambe vanôôn amekaalus valup-ambe lis ak, tombe nalu vuuk, tonde mem yiis nôôn anivasa. ");
INSERT INTO mmo_vpl VALUES ("MK4_29","071_4_29","MRK","4","29","29","+ o 4:29 Joel 3:13; Taato 14:15*Vanôôn nôôn ak lung la, le mem lasap ak yipak in vanôôn-ate busin lung la.” ");
INSERT INTO mmo_vpl VALUES ("MK4_30","071_4_30","MRK","4","30","30","Yesu nêêl nambe, “Yiiy taahu sen Anutu nanggin yite hil-ato jak vaati? Yiiy naanêêl vakasin pakwesin jak vaati? ");
INSERT INTO mmo_vpl VALUES ("MK4_31","071_4_31","MRK","4","31","31","Yik lohvu môônd nôôvoow, in môônd nôôvoow-anju nipasiv lôôt, de me-bop lohvu haah vaalu nôôn e, ");
INSERT INTO mmo_vpl VALUES ("MK4_32","071_4_32","MRK","4","32","32","lemu môônd nôôvoow naatok-ambe balup, tombe omaaho ti gako be na baalôôh, ond valup-ambe kaluuh haah pasi-pasiv pin la, de bopaata lak-ambe vaasuh nama salak bop bop tombe manak dahaav vunis hôôk lis-ambe dando hôôk kôôh.” ");
INSERT INTO mmo_vpl VALUES ("MK4_33","071_4_33","MRK","4","33","33","Nêêl tanasin lak vakasin pakwesin ngeeyaata nambêênju vu hil lohvu sil akand in nambe yoo le lanjak ni. ");
INSERT INTO mmo_vpl VALUES ("MK4_34","071_4_34","MRK","4","34","34","Vakasin vaalu ond me-nêêl langaah e, yik yoo nêêl tu vakasin pakwesin amu vu hil, tonde having yite maanggêêm-aso be lala dando lundoos, le mem tatekin vakasin pakwesin-anjuuto pin dangga langaah vu sil. ");
INSERT INTO mmo_vpl VALUES ("MK4_35","071_4_35","MRK","4","35","35","Hôôk busin-anju, ond soosin hôôk atombe Yesu nêêl vu yite maanggêêm-aso nambe, “Yana betum vaalu.” ");
INSERT INTO mmo_vpl VALUES ("MK4_36","071_4_36","MRK","4","36","36","Om lavuuh hil alu bopaataa-ju be dando, de lalakala kaanu ti sen Yesu lakandôô-to be lala. Lako Yesu be lala tonde kaanu heey taamuyin. ");
INSERT INTO mmo_vpl VALUES ("MK4_37","071_4_37","MRK","4","37","37","Tombe vavi jamba laam bopaata be bel têêy lukala kaanu lopayo lôôt-ambe wiingin nambe naapup, ");
INSERT INTO mmo_vpl VALUES ("MK4_38","071_4_38","MRK","4","38","38","le Yesu hambe lu lakaneep pilo be neep ka lingin ak kaanu ahus. Tombe maanggêêm-aso layêêvu be lanêêl vu nambe, “Kaputung-e, yiiy navu aanggimb-anjo. Game gakam navu yiiy e?” ");
INSERT INTO mmo_vpl VALUES ("MK4_39","071_4_39","MRK","4","39","39","Tombe Yesu kandi be nêêl vavi yuuh bel nambe, “Lung. Olavam nama de onanggop tatimasin.” Tombe vavi ma la de bel neep tatimasin. ");
INSERT INTO mmo_vpl VALUES ("MK4_40","071_4_40","MRK","4","40","40","Tonde nêêl vu sil nambe, “Ham naham nalak in? Nambe vaati om ham-ame awii-having e?” ");
INSERT INTO mmo_vpl VALUES ("MK4_41","071_4_41","MRK","4","41","41","Tombe kanund la lôôt-ambe lanêêl vu sil nambe, “Omaaho tii-jo mak lati ondeey vavi yuuh bel nanyend vuun in lava?” ");
INSERT INTO mmo_vpl VALUES ("MK5_1","071_5_1","MRK","5","1","1","Sil latok lala Gelasa-te taaku neep betum vaalu, ");
INSERT INTO mmo_vpl VALUES ("MK5_2","071_5_2","MRK","5","2","2","+ o 5:2 Mak 1:23*tombe Yesu luus-ambe la, tonde omaaho ti mamu nipaya dahôôvu yi ond vu lavandangga sen omaahonôôn bandumb-ato be hato vu Yesu. ");
INSERT INTO mmo_vpl VALUES ("MK5_3","071_5_3","MRK","5","3","3","Omaahôô-ju yoo nando hôôk lavandangga sen omaahonôôn bandumb-ato, de hil-ame lalohvu nambe talu yi le, tonde hees aniwêêk lôôt ond me-lohvu having e. ");
INSERT INTO mmo_vpl VALUES ("MK5_4","071_5_4","MRK","5","4","4","In davu talu yi lak hees aniwêêk osin lasi lok hôôk-ambe napuvu vaha yuuh boyambôôy, le ma de navu taso lôôt atombe hees aniwêêk napuuh, de navu paanyêêh lok-ambe navu kalêêh. Omaaho ti me-lohvu nambe naapuvu be melaas jak e. ");
INSERT INTO mmo_vpl VALUES ("MK5_5","071_5_5","MRK","5","5","5","Nangeeyak-ambe natup hôôk lohvu lavandangga osin kandu nalu ti ti businaandiin osin vandiisinaandiin, de nalaah ninaavi lak tatuuh lohvu busin pin. ");
INSERT INTO mmo_vpl VALUES ("MK5_6","071_5_6","MRK","5","6","6","Tombe naale diin le yi de Yesu la hato, tombe hatup-ambe la hatung kaatu vu, ");
INSERT INTO mmo_vpl VALUES ("MK5_7","071_5_7","MRK","5","7","8","+ o 5:7 Mak 1:24*de Yesu nêêl vu mamu nambe, “Mamu nipaya-e, onggavuuh omaahôô-jo de gana.” Tonde mamu nêêl laah osin lava bopaata nambe, “Anutu baandoni noow Yesu, gayêêvu sa in? Sa naanêêl lak Anutu naambe game gambu nivaane vu sa le.” ");
INSERT INTO mmo_vpl VALUES ("MK5_9","071_5_9","MRK","5","9","9","Tonde Yesu lingin nambe, “Ohaalem nambe?” Le nêêl nambe, “Sa haalengg nambe Omaaho-maaho, nambe hey ngeeyaata lôôt.” ");
INSERT INTO mmo_vpl VALUES ("MK5_10","071_5_10","MRK","5","10","10","Tonde kataangg osin niwêêk vu Yesu nambe me-gatiiy sil lana taaku ngo le. ");
INSERT INTO mmo_vpl VALUES ("MK5_11","071_5_11","MRK","5","11","11","Tonde bik ngeeyaata mondaya va daale vahandangga ti ngaaho vu taakuu-ju, ");
INSERT INTO mmo_vpl VALUES ("MK5_12","071_5_12","MRK","5","12","12","tombe mamu kataangg Yesu nambe, “Gambiing-ambe hey aandukana bik-anju londpayo.” ");
INSERT INTO mmo_vpl VALUES ("MK5_13","071_5_13","MRK","5","13","13","Om Yesu liinggis-ande mamu nipaya lavuuh omaaho sen-anjuuto de lalukala bik alondpayo, tombe bik pin-anju latup-ambe laluus taaku pake be lalukala betum, tombe lanum bel-ambe layimb valok-ate. Bik-anju ngeeyaata lôôt lohvu 2 taosen. ");
INSERT INTO mmo_vpl VALUES ("MK5_14","071_5_14","MRK","5","14","14","Tonde hil sen danggin bik-ato lapak-ambe lala lanêêl banye vu hil bayêên bop osin bayêên pasi-pasiv pin, be lalaam in nambe lanji vaa-ju. ");
INSERT INTO mmo_vpl VALUES ("MK5_15","071_5_15","MRK","5","15","15","Om lalaam vu Yesu be layi omaaho sen mamu Omaaho-maaho lahôôvu boyambôôy-ato, ond lukook anivasa lak-ambe havêêh yite tôômb laah-ande nando, tombe layêênin lôôt. ");
INSERT INTO mmo_vpl VALUES ("MK5_16","071_5_16","MRK","5","16","16","Tombe hil sen layi mend ak vaa-ju ond lala lanêêl va sen Yesu wiing vu omaaho tii-ju osin lanêêl va sen lak bik-ato having. ");
INSERT INTO mmo_vpl VALUES ("MK5_17","071_5_17","MRK","5","17","17","Tombe sil kataangg Yesu nambe gavuuh silate taakuu-ju de na. ");
INSERT INTO mmo_vpl VALUES ("MK5_18","071_5_18","MRK","5","18","18","Yesu naahen nalakala kaanu, tonde omaaho sen mamu hôôvu bôôy-ato, ond kataangg nambe, “Sana gaving hong-o.” ");
INSERT INTO mmo_vpl VALUES ("MK5_19","071_5_19","MRK","5","19","19","Le ma de Yesu lonin-ande nêêl vu nambe, “Ganaah gambaam-ambe onaanêêl vu gate hil naambe Omaaho Bop ka pasiv in hong-ambe samu hong lôôt.” ");
INSERT INTO mmo_vpl VALUES ("MK5_20","071_5_20","MRK","5","20","20","+ o 5:20 Mat 4:25; Mak 7:31*Om omaahôô-ju laah-ambe nêêl vakasin sen Yesu samu yi be nivasa lak-ato langaah vu hil lohvu taaku nomaayuuh sen danêêl nambe Dekapolis-ato, tombe hil pin lavindis lôôt. ");
INSERT INTO mmo_vpl VALUES ("MK5_21","071_5_21","MRK","5","21","21","Lako Yesu lak kaanu be laah betum vaalu yesin, tombe nando hôôk bel nanyendangga, de hil ngeeyaata lasupin lala vu yi. ");
INSERT INTO mmo_vpl VALUES ("MK5_22","071_5_22","MRK","5","22","22","Tombe yêêv dumb-ate ti, haale nambe Yailus, yi Yesu tombe la hato pataav baambu neep voon hôôk vaha, ");
INSERT INTO mmo_vpl VALUES ("MK5_23","071_5_23","MRK","5","23","23","+ o 5:23 Mat 8:3; Mak 7:32*de kataangg niwêêk vu yi nambe, “Sa nonggaavêêh nilak bopaata be navu jimb, om ganaam gambe namam jak yi in nambe nivasa dôôk-ambe mando.” ");
INSERT INTO mmo_vpl VALUES ("MK5_24","071_5_24","MRK","5","24","24","Tombe Yesu la having-ambe yuuh lala, de hil ngeeyaata lambuuh yi vaalu vaalu be lala. ");
INSERT INTO mmo_vpl VALUES ("MK5_25","071_5_25","MRK","5","25","25","Tonde sim vêêh ti ond vêêh-ate nilakin tovu tombe yoo nando bayêên pasiv nalak busin pin lohvu ta nomaayuuh-ambe laam yuuh, ");
INSERT INTO mmo_vpl VALUES ("MK5_26","071_5_26","MRK","5","26","26","tombe nala vu dokta ngeeyaata in davu samu yi, de navu mone la vu dokta-so boyambôôy-ambe yinêên mone lung la, le ma de me-nivasa nalak e, de yite nilakin tu bopaata. ");
INSERT INTO mmo_vpl VALUES ("MK5_27","071_5_27","MRK","5","27","28","+ o 5:27-28 Mak 6:56; Mat 14:36*Tombe hangoyin Yesu banye be ka vu nambe, “Sa gambe namangg jak yite lolop amu ond sale sa ningg vasa dôôk.” Om lukala hil lavuun-ambe naale Yesu dami de hambe nama lak yite lolop, ");
INSERT INTO mmo_vpl VALUES ("MK5_29","071_5_29","MRK","5","29","29","tombe nilakin lung la pavis, de mem hangoyin nambe nivasa lak lung la. ");
INSERT INTO mmo_vpl VALUES ("MK5_30","071_5_30","MRK","5","30","30","+ o 5:30 Luk 6:19*Tombe Yesu lak ni nambe yite niwêêk wiing omaaho ti nivasa lak, om hilin pavis-ambe lingin nambe, “Lati hambe nama lak sate lolop?” ");
INSERT INTO mmo_vpl VALUES ("MK5_31","071_5_31","MRK","5","31","31","Le yite maanggêêm lanêêl vu nambe, “Gahe hil ngeeyaata lambuuh hong tatup-anjo, le sim galingin nambe lati hambe nama lak hong?” ");
INSERT INTO mmo_vpl VALUES ("MK5_32","071_5_32","MRK","5","32","32","Tombe me hako hôôk in nambe ji omaaho ti sen hambe nama lak yii-to, ");
INSERT INTO mmo_vpl VALUES ("MK5_33","071_5_33","MRK","5","33","33","tonde vêêh-anju lak ni nambe Yesu-te niwêêk wiing-ambe nivasa lak om yêênin-ambe hees, tombe hato pataav baambu neep voon hôôk Yesu vaha de nêêl vakasin pin langaah vu yi. ");
INSERT INTO mmo_vpl VALUES ("MK5_34","071_5_34","MRK","5","34","34","+ o 5:34 Mak 10:52; Luk 7:50; 17:19*Tonde Yesu nêêl vu nambe, “Nonggaavêêh, gawii-having ondeey ganim vasa lak, om gana osin galompayo ahelavis in gate nilakin lung la valok-ate.” ");
INSERT INTO mmo_vpl VALUES ("MK5_35","071_5_35","MRK","5","35","35","Naahen monanêêl atonde omaaheey vu Yailus ambaan-ambe lato lanêêl vu Yailus nambe, “Nomaavêêh ame yip, om onaanêêl vu yêêv naambe mando de menaam e, jip.” ");
INSERT INTO mmo_vpl VALUES ("MK5_36","071_5_36","MRK","5","36","36","Tombe Yesu hango sil lavand atombe nêêl vu yêêv dumb-ate nambe, “Game naham jak e, yik gambiing gaving amu.” ");
INSERT INTO mmo_vpl VALUES ("MK5_37","071_5_37","MRK","5","37","37","Tombe lonin hil pin dando de hako Pita having Jems ayuuh hali Jon-ambe sil lala. ");
INSERT INTO mmo_vpl VALUES ("MK5_38","071_5_38","MRK","5","38","38","Sil latok lala yêêv dumb-anjôôto baan, le yi de hil dawiing nindaandun bopaata osin dasu lôôt. ");
INSERT INTO mmo_vpl VALUES ("MK5_39","071_5_39","MRK","5","39","39","+ o 5:39 Jon 11:11*Tombe Yesu lukala bayêên alo be nêêl vu sil nambe, “Ham nawiing nindaandun bopaata de ham nasu bopaata lôôt in? Unaavepasiv-ame yimb e, nganjo yoo neep anêên.” ");
INSERT INTO mmo_vpl VALUES ("MK5_40","071_5_40","MRK","5","40","40","Le sil lanop ak yi, om hatiiy sil lala voon-ande hako unaavepasiv mangganaan ayuuh tangganaan osin yite maanggêêm yaal sen laving yii-to be lalukala bayêên alopayo sen unaavepasiv neep hôôk-ato. ");
INSERT INTO mmo_vpl VALUES ("MK5_41","071_5_41","MRK","5","41","41","+ o 5:41 Luk 7:14*Tombe lôôh hôôk unaavepasiv nama de nêêl vu hôôk sil lavand nambe, “Talita kumi,” dangga nambe “Unaavepasiv, sa naanêêl naambe okandi jak.” ");
INSERT INTO mmo_vpl VALUES ("MK5_42","071_5_42","MRK","5","42","42","Tombe yik unaavepasiv kandi lak pavis-ambe naale nala. Layi tombe kanund la lôôt. Unaavepasiv-anju yite ta nomaayuuh-ambe laam yuuh. ");
INSERT INTO mmo_vpl VALUES ("MK5_43","071_5_43","MRK","5","43","43","+ o 5:43 Mak 1:44; 7:36*De Yesu vu kôôvu sil niwêêk nambe me-daanêêl-ambe omaaho ti me-gango vaa-ju banye le, de nêêl vu sil nambe lambu vanôôn-ambe unaavepasiv-anju ja. ");
INSERT INTO mmo_vpl VALUES ("MK6_1","071_6_1","MRK","6","1","1","Yesu kandi vuu-ju be laah baan, tombe yite maanggêêm-aso taamuyin yi be lala. ");
INSERT INTO mmo_vpl VALUES ("MK6_2","071_6_2","MRK","6","2","2","+ o 6:2 Jon 7:15*Huli-la dumb alo hôôk busin sawaasin, tombe wiing tanasin-ambe hil ngeeyaata langoyin-ambe lavindis nambe, “Omaahôô-jo hako tanasin danggakook osin lukook bopaataa-jo vu tana, om sen nawiing taahu taahu osin niwêêk-anjo. ");
INSERT INTO mmo_vpl VALUES ("MK6_3","071_6_3","MRK","6","3","3","+ o 6:3 Jon 6:42*Omaahôô-jo mak yi kaamunda yik Malia noow-anjo, de halindin ond Jems ayuuh Joses de Yudas ayuuh Simon, de vangaandin sen dando having yiiy-anjo.” Tombe sil ahend kalin vu yi. ");
INSERT INTO mmo_vpl VALUES ("MK6_4","071_6_4","MRK","6","4","4","+ o 6:4 Jon 4:44*Le Yesu nêêl vu sil nambe, “Omaaho ti nanêêl Anutu-te vakasin langaah ond hil dako omaahôô-ju haale lak lohvu taaku pin, lemu hil vu yite baan dangga dosin osin hil sen sil dangga ti be sil ambaand ti, ond sil-ame dako yi lak e.” ");
INSERT INTO mmo_vpl VALUES ("MK6_5","071_6_5","MRK","6","5","5","+ o 6:5 Luk 4:40*Tombe Yesu me-lohvu nambe biing taahu taahu ti vu manyinju le, in hil-ame lawii-having yi le, yik hambe nama lak hil anind lakin lavuuti be nind vasa lak. ");
INSERT INTO mmo_vpl VALUES ("MK6_6","071_6_6","MRK","6","6","6","Yesu vindis in hil-ame lawii-having yi le, tonde la hanjung hôôk bayêên bu ti ti be wiing tanasin vu hil. ");
INSERT INTO mmo_vpl VALUES ("MK6_7","071_6_7","MRK","6","7","7","+ o 6:7 Luk 10:1*Yesu teey yite maanggêêm nomaayuuh-ambe laam yuuh-ato lalaam vu in nambe biing sil yuyuuh-ambe lana, de vu niwêêk vu sil in nambe sil gatiiy mamu nipaya lana in omaahonôôn. ");
INSERT INTO mmo_vpl VALUES ("MK6_8","071_6_8","MRK","6","8","8","+ o 6:8-11 Luk 10:4-11*Tonde nêêl vu sil nambe sil-ame namand dôôk vati be lana mop e, yik sil namand dôôk paatôôn timu, de sil-ame gako vanôôn osin vaahes e, de mone me-dumbaale silate gis e, ");
INSERT INTO mmo_vpl VALUES ("MK6_9","071_6_9","MRK","6","9","9","lanjop suul amu de me-lanjop lolop yuuh e. ");
INSERT INTO mmo_vpl VALUES ("MK6_10","071_6_10","MRK","6","10","10","Tonde nêêl vu sil nambe, “Ham anjakana bayêên ti, ond yik ham oo mando lak bayêên tii-ju nivalok-ambe na balup busin sen ham gavuuh sil-ato, le mem ham ana taaku ngo. ");
INSERT INTO mmo_vpl VALUES ("MK6_11","071_6_11","MRK","6","11","11","+ o 6:11 Sin 13:51*Naambe hil vu taaku ti me-gako ham jak e, de me-gango ham lavam e, ond ham gavuuh taakuu-ju na, de ham tatehin kambus sen nando lak ham vaham-ato naah in taato silate nipaya langaah.” ");
INSERT INTO mmo_vpl VALUES ("MK6_12","071_6_12","MRK","6","12","12","Tonde mem sil lala lawiing tanasin nambe hil langgilin sil alondpayo, ");
INSERT INTO mmo_vpl VALUES ("MK6_13","071_6_13","MRK","6","13","13","+ o 6:13 Jem 5:14*de latiiy mamu ngeeyaata lala in omaahonôôn, de sil kaasêêh hahaanôôn aniluk lak hil anilakin ngeeyaata be sil anind vasa nalak. ");
INSERT INTO mmo_vpl VALUES ("MK6_14","071_6_14","MRK","6","14","14","+ o 6:14 Mat 16:14; Mak 8:28*Yesu banye lohvu taaku pin, tombe omaaho lulemak haale nambe Helot, ond hango banye de hil vaalu lanêêl nambe, “Jon sen nalipis hil-ato ond kandi lak laah-ambe nando moos om nawiing taahu taahu osin niwêêk.” ");
INSERT INTO mmo_vpl VALUES ("MK6_15","071_6_15","MRK","6","15","15","De hil vaalu lanêêl nambe, “Manyinju Eliya sen nanêêl Anutu-te vakasin bôôy-ato,” de vaalu lanêêl nambe, “Anutu-te omaaho ti lohvu hil sen danêêl Anutu-te vakasin langaah bôôy-ato.” ");
INSERT INTO mmo_vpl VALUES ("MK6_16","071_6_16","MRK","6","16","16","Tombe Helot hango de lanêêl nambêênju om nêêl nambe, “Jon sen saawiing-ambe omaaho ti katôôv ka laa-to ond yik kandi lak laah-anju.” ");
INSERT INTO mmo_vpl VALUES ("MK6_17","071_6_17","MRK","6","17","17","In bôôy Helot wiing-ambe lala lalôôh Jon-ambe landuuh-ande latung lukala kalaambus. Wiing nambêênju in dangga nambe Helot hali Pilip ond Helot lakin vane Helodias, ");
INSERT INTO mmo_vpl VALUES ("MK6_18","071_6_18","MRK","6","18","18","+ o 6:18 Lev 18:16*le sim Jon nêêl Helot nambe, “Ohako halim vane om me-lohvu le.” ");
INSERT INTO mmo_vpl VALUES ("MK6_19","071_6_19","MRK","6","19","19","Tombe Helodias ahekalin vu Jon om wiingin nambe nyiis-ambe jimb, le ma de Helot hilin Jon-ambe hako be la hatung hôôk kalaambus. ");
INSERT INTO mmo_vpl VALUES ("MK6_20","071_6_20","MRK","6","20","20","Helot nayêênin Jon in lak ni nambe omaaho nivalok osin vaambuung ti ondeey hilin. Tombe Helot nango Jon-ate vakasin-ambe ka vasa, lemu ka vaalu vaalu lohvu busin pin. ");
INSERT INTO mmo_vpl VALUES ("MK6_21","071_6_21","MRK","6","21","21","Tombe busin ti Helodias tovu mopaatôôv ti nambe Helot aka vu yite busin sen tangganaan hako yii-to, tombe wiing vanôôn bopaata vu yêêv gaaman-aso pin de yite yêêv ngaamong-ate, osin himbop bop vu Galili pin. ");
INSERT INTO mmo_vpl VALUES ("MK6_22","071_6_22","MRK","6","22","22","Tombe Helodias nowaavêêh lukala vu sil-ambe nakôômb, tombe Helot-aso hil pin sen daya vanôôn-ato layi be ahend anivasa lôôt vu, om omaaho lulemak Helot nêêl vu vehaavu nambe, “Gawiingin gako vati ond onaanêêl-ambe saambu vu hong. ");
INSERT INTO mmo_vpl VALUES ("MK6_23","071_6_23","MRK","6","23","23","+ o 6:23 Esta 5:3,6; 7:2*Sa naanêêl keen baandoni naambe okataangg vati vu sa ond sale aambu vu hong, de naambe gawiingin nambe saambu sate taaku vaalu be ongganggin, ond yik sale aambu vu hong.” ");
INSERT INTO mmo_vpl VALUES ("MK6_24","071_6_24","MRK","6","24","24","Tombe vehaavu laah-ambe lingin tangganaan nambe, “Sale naanêêl vaati?” Le nêêl nambe, “Okataangg Jon sen nalipis hil-ato lukook.” ");
INSERT INTO mmo_vpl VALUES ("MK6_25","071_6_25","MRK","6","25","25","Om hatup-ambe lukalaah pavis vu omaaho lulemak-ambe nêêl vu nambe, “Saawiingin nambe gambu Jon sen nalipis hil-ato lukook vu sa. Onggatung hôôk kaambum ti, be gambu vu sa pavis.” ");
INSERT INTO mmo_vpl VALUES ("MK6_26","071_6_26","MRK","6","26","26","Tombe sim omaaho lulemak Helot lopayo nimeen lôôt, le ma de ka vu nambe me-tatuhin vehaavu le, in taato nama lak baandoni hôôk yêêv-aso pin sen dando having yii-to mend, ");
INSERT INTO mmo_vpl VALUES ("MK6_27","071_6_27","MRK","6","27","27","om pavis atombe omaaho lulemak nêêl vu hil ngaamong vaha ti nambe na gako Jon alukook naam, om la katôôv ka hôôk bayêên kalaambus alo. ");
INSERT INTO mmo_vpl VALUES ("MK6_28","071_6_28","MRK","6","28","28","Tombe hatung Jon alukook hôôk kaambum ti le mem hako be laah vu vu vehaavuu-ju, tombe vehaavuu-ju hako be la vu vu tangganaan. ");
INSERT INTO mmo_vpl VALUES ("MK6_29","071_6_29","MRK","6","29","29","Tonde sim Jon-ate maanggêêm-aso sen davu sapa yii-to lango banye, tombe lala lako ninaavi be lala lambe neep hôôk lavandangga. ");
INSERT INTO mmo_vpl VALUES ("MK6_30","071_6_30","MRK","6","30","30","+ o 6:30 Luk 10:17*Sinaale-so sen Yesu wiing sil lalaa-to, ond lasupin lalom vu Yesu be latulin va pin sen lawiing osin tanasin sen lanêêl-ato vu yi. ");
INSERT INTO mmo_vpl VALUES ("MK6_31","071_6_31","MRK","6","31","31","+ o 6:31 Mak 3:20*Tombe nêêl vu sil nambe, “Ham oo anaam-ambe yana mando taaku lundoos ti be ham sawaah daka le.” Nêêl nambêênjo in hil ngeeyaata lalaam-ambe lahilin sil, de me-lalohvu nambe lanja vanôôn e. ");
INSERT INTO mmo_vpl VALUES ("MK6_32","071_6_32","MRK","6","32","32","Tombe sil lalakala kaanu be sil oo lala taaku lu malis ti, ");
INSERT INTO mmo_vpl VALUES ("MK6_33","071_6_33","MRK","6","33","33","lemu hil ngeeyaata lalak sil anind lung la be layi nambe dala taaku tii-ju, om hil vu taaku pin latup voon-ambe latok lala taakuu-ju munggin. ");
INSERT INTO mmo_vpl VALUES ("MK6_34","071_6_34","MRK","6","34","34","+ o 6:34 Mat 9:36*Tombe Yesu lakala lonak, le yi de hil ngeeyaata lôôt dando, tombe ka pasiv in sil in nambe sil lalohvu bik sipsip sen heendin lavuuh sil-ato, om nêêl tanasin ngeeyaata vu sil lôôt. ");
INSERT INTO mmo_vpl VALUES ("MK6_35","071_6_35","MRK","6","35","35","+ o 6:35-44 Mak 8:1-9*Soosin hôôk atombe yite maanggêêm-aso lala lanêêl vu nambe, “Taaku me lung la, de taakuu-jo lumbalaamb ");
INSERT INTO mmo_vpl VALUES ("MK6_36","071_6_36","MRK","6","36","36","om gambiing-ambe sil lana bayêên ti ti sen nando ngaahôô-to, be sil baanggo vanôôn in lanja.” ");
INSERT INTO mmo_vpl VALUES ("MK6_37","071_6_37","MRK","6","37","37","Le ma de nêêl vu maanggêêm-aso nambe, “Yik ham oo ambu vanôôn vu sil.” Le lanêêl vu nambe, “Om gawiingin nambe hey ana baanggo vanôôn jak mone 200 kina in sil lanja?” ");
INSERT INTO mmo_vpl VALUES ("MK6_38","071_6_38","MRK","6","38","38","Le sim nêêl vu sil nambe, “Hamate vanôôn nôôn vaaheey naahen nando? Ham ana angge le.” Layi lung la le mem lanêêl vu nambe, “Yik balet namaavaalu having paahuung yuuh neep.” ");
INSERT INTO mmo_vpl VALUES ("MK6_39","071_6_39","MRK","6","39","39","Om nêêl vu hil pin nambe sil gato mando lu ti ti jak taavêêt alis, ");
INSERT INTO mmo_vpl VALUES ("MK6_40","071_6_40","MRK","6","40","40","om sil doo-namaavaalu-vaalu dando lak lu ti ti, tonde lu heey lohvu doo-yuyuuh-ambe nomaayuuh. ");
INSERT INTO mmo_vpl VALUES ("MK6_41","071_6_41","MRK","6","41","41","Tombe mem hako balet namaavaalu de paahuung yuuh-ato be valaah me lak baandoni de lohak, le mem hapok balet-ambe vu vu yite maanggêêm-aso be sil latiiy lohvu hil. Tonde yik kalêêh paahuung yuuh-ato be hatiiy lohvu omaahonôôn pin, ");
INSERT INTO mmo_vpl VALUES ("MK6_42","071_6_42","MRK","6","42","42","tombe omaahonôôn pin laya be lohvu sil. ");
INSERT INTO mmo_vpl VALUES ("MK6_43","071_6_43","MRK","6","43","43","Laya lung atonde sil lasupin nyengale hôôk jaambang nomaayuuh-ambe laam yuuh-ambe pup. ");
INSERT INTO mmo_vpl VALUES ("MK6_44","071_6_44","MRK","6","44","44","Hil sen laya vanôôn-ato ond moow ngeeyaata lôôt lohvu 5 taosen. ");
INSERT INTO mmo_vpl VALUES ("MK6_45","071_6_45","MRK","6","45","45","Lung atonde Yesu haanjiihin yite maanggêêm-aso nambe lanjak kaanu be daamunggin-ambe lana taaku Betsaida sen nando betum nanyendangga vaaluu-to, de yoo mando be biing hil lana le. ");
INSERT INTO mmo_vpl VALUES ("MK6_46","071_6_46","MRK","6","46","46","+ o 6:46 Mak 1:35; Luk 5:16; 6:12; 9:28*Wiing sil lala lung la, tonde mem lak kandu ti be la nando monalohak nandôô-ju. ");
INSERT INTO mmo_vpl VALUES ("MK6_47","071_6_47","MRK","6","47","47","Tombe taaku bus la de kaanu naahen bel lavuun, de Yesu yoo timu nando lonak, ");
INSERT INTO mmo_vpl VALUES ("MK6_48","071_6_48","MRK","6","48","48","le sim yi nambe sil dataal osin nimeen in vavi nave sil lôôt. Tonde hôôk heendiisin atombe naale nala lak bel baandoni be la vu sil, tombe wiingin nambe kaluuh sil, ");
INSERT INTO mmo_vpl VALUES ("MK6_49","071_6_49","MRK","6","49","49","+ o 6:49 Luk 24:37*lemu layi nambe naale nala lak bel baandoni tombe kand vu nambe mamu ti om langeeyak. ");
INSERT INTO mmo_vpl VALUES ("MK6_50","071_6_50","MRK","6","50","50","Sil pin oo layi be layêênin lôôt, om nêêl vu sil pavis nambe, “Ham naham aniwêêk, yik saa-jo, om ham-ame anjêênin e.” ");
INSERT INTO mmo_vpl VALUES ("MK6_51","071_6_51","MRK","6","51","51","+ o 6:51 Mak 4:39*Tombe lakala kaanu vu sil atonde vavi tôômin om lavindis lôôt, ");
INSERT INTO mmo_vpl VALUES ("MK6_52","071_6_52","MRK","6","52","52","+ o 6:52 Mak 8:17*in sil-ame kand vu be lalak va sen Yesu wiing ak balet osin niwêêk-ato danggakook ani le, lundkook ma. ");
INSERT INTO mmo_vpl VALUES ("MK6_53","071_6_53","MRK","6","53","53","Sil latok lala betum vaalu vu taaku Genesaalet, tombe sil talu kaanu be nando ");
INSERT INTO mmo_vpl VALUES ("MK6_54","071_6_54","MRK","6","54","54","de laluus-ambe lala. Tombe hil-anju lalak Yesu ni pavis, ");
INSERT INTO mmo_vpl VALUES ("MK6_55","071_6_55","MRK","6","55","55","om lala latup hôôk taaku pin-ambe laaku silate hil anilakin lakaneep ak yêênin-ambe lala taaku ti ti sen lango Yesu nandôô-to. ");
INSERT INTO mmo_vpl VALUES ("MK6_56","071_6_56","MRK","6","56","56","Vu taaku bop-ambe pasiv de bayêên ti ti sen laa-to ond sil latung hil anilakin dando talind, tombe davu kataangg yi nambe gambe namand jak yite lolop anyendaambu mu, tombe mem hil sen lambe namand ak lolop-ato nind vasa lak pin. ");
INSERT INTO mmo_vpl VALUES ("MK7_1","071_7_1","MRK","7","1","1","Palisai osin tanasin dangga heey vu Yelusalem lasupin lala vu Yesu, ");
INSERT INTO mmo_vpl VALUES ("MK7_2","071_7_2","MRK","7","2","2","+ o 7:2 Luk 11:38*tombe layi de yite maanggêêm vaalu laya vanôôn danjeen, de me-lalipis namand e. ");
INSERT INTO mmo_vpl VALUES ("MK7_3","071_7_3","MRK","7","3","3","In Palisai osin Yuda pin davu sapa himbop bôôy-ate tanasin nambe sil-ame lanja vanôôn e, lanjipis namand e mem. ");
INSERT INTO mmo_vpl VALUES ("MK7_4","071_7_4","MRK","7","4","4","+ o 7:4 Mat 23:25*Tonde lana maaket-ambe lanaah balup bayêên alo ond lanjipis sil e mem lanja vanôôn. De sil oo davu sapa gambum ngeeyaata having lak va sen dalipis kap ayuuh dêêngg-ambe palêê-to. ");
INSERT INTO mmo_vpl VALUES ("MK7_5","071_7_5","MRK","7","5","5","Tombe Palisai osin tanasin dangga-so lalingin Yesu nambe, “Nambe vaati sen gate maanggêêm-aso davu kalêêh himbop bôôy-ate tanasin om daya vanôôn osin namand anipaya?” ");
INSERT INTO mmo_vpl VALUES ("MK7_6","071_7_6","MRK","7","6","6","+ o 7:6-7 Ais 29:13*Tombe nêêl vu sil nambe, “Yesaia nêêl Anutu-te vakasin lak ham tatuhin ambu-so bôôy-ato ond yoo nêêl lohvu, yik kaavu neep nambe, ‘Hil-anjo dako sa haalengg ak avind malis amu, de londpayo nando diin in sa. ");
INSERT INTO mmo_vpl VALUES ("MK7_7","071_7_7","MRK","7","7","7","Dalohak malis amu vu sa, tonde davu taahu hil hôôk omaahonôôn oote tanasin nambe sate tanasin keen.’ ");
INSERT INTO mmo_vpl VALUES ("MK7_8","071_7_8","MRK","7","8","8","Om manyinjo ham havuuh Anutu-te tanasin la, de ham oo napuvu omaahonôôn-ate tanasin tatin.” ");
INSERT INTO mmo_vpl VALUES ("MK7_9","071_7_9","MRK","7","9","9","De nêêl vu sil having nambe, “Hamambe ham nawiing va nivasaa-jo? Sen ham naluuh damim vu Anutu-te tanasin de mem ham oo napuvu himbop bôôy-ate tanasin tatin. ");
INSERT INTO mmo_vpl VALUES ("MK7_10","071_7_10","MRK","7","10","10","+ o 7:10 Eks 20:12; 21:17; Diu 5:16*Keen, Mose nêêl bôôy nambe, ‘Onggako mom ayuuh tam jak.’ De nêêl ango neep having nambe, ‘Omaaho ti naanêêl vakasin anipaya jak mangganaan me tangganaan, ond hil lanyiis-ambe jimb.’ ");
INSERT INTO mmo_vpl VALUES ("MK7_11","071_7_11","MRK","7","11","11","Nganjo ham ond ham nanêêl nambe omaaho ti naanêêl vu mangganaan me tangganaan naambe bu va na in dôôvu yuuh, le ma de nêêl Anutu haale lak lung la, ");
INSERT INTO mmo_vpl VALUES ("MK7_12","071_7_12","MRK","7","12","12","ond ham nanêêl nambe lung, omaahôô-ju me-dôôvu mangganaan ayuuh tangganaan e. ");
INSERT INTO mmo_vpl VALUES ("MK7_13","071_7_13","MRK","7","13","13","Om nambêênja ham oo kawiiy Anutu-te vakasin lak himbop-ate tanasin bôôy sen ham nanêêl tave tavêê-to be natu va malis amu, de ham oo nawiing va ngeeyaata lohvu ham akam.” ");
INSERT INTO mmo_vpl VALUES ("MK7_14","071_7_14","MRK","7","14","14","Yesu teey hil lala vu yesin-ambe nêêl vu sil nambe, “Ham pin gango sa lavangg-ambe ham anjak ni vanuh. ");
INSERT INTO mmo_vpl VALUES ("MK7_15","071_7_15","MRK","7","15","15","+ o 7:15 Sin 10:14-15*Vanôôn sen lukala omaahonôôn alopayo ond me-lukalaah nambe biing-ambe Anutu ji omaahonôôn naambe nipaya le, malis. Nganjo va sen naale hôôk omaahonôôn alopayo be nalaam-ato ond mem nawiing-ambe Anutu nayi omaahonôôn nambe nipaya. ");
INSERT INTO mmo_vpl VALUES ("MK7_16","071_7_16","MRK","7","16","16","Omaaho ti nambe nanye neep ond gangoyin.” ");
INSERT INTO mmo_vpl VALUES ("MK7_17","071_7_17","MRK","7","17","17","Yesu havuuh sil la de lukala bayêên alo, le mem yite maanggêêm-aso lalingin vakasin pakwesin-anju danggakook vu yi, ");
INSERT INTO mmo_vpl VALUES ("MK7_18","071_7_18","MRK","7","18","18","tombe nêêl vu sil nambe, “De ham-anjo, ham-ame alak ni having e? Mak ham doosin vanôôn sen nalukala omaahonôôn alopayôô-to ond me-le biingambe Anutu ji omaahonôôn naambe nipaya lak e, ");
INSERT INTO mmo_vpl VALUES ("MK7_19","071_7_19","MRK","7","19","19","in vanôôn-ame nalukala lopayo keen e, nalukala ahe mu be hato nalukala sov.” Nêêl taato nambêênju in nambe vanôôn vaha vaha pin nivasa vu yiiy. ");
INSERT INTO mmo_vpl VALUES ("MK7_20","071_7_20","MRK","7","20","20","Nganjo nêêl nambe, “Va sen naale hôôk hil alondpayo be nalaam-ato ond mem nawiing-ambe Anutu nayi omaahonôôn nambe nipaya. ");
INSERT INTO mmo_vpl VALUES ("MK7_21","071_7_21","MRK","7","21","21","+ o 7:21-22 Gal 5:19-21*In va sen vu omaahonôôn alondpayo be nalaam-ato, ond kand navu va nipaya, be dawiing danjeen vu vehaavu, dahôôndak va, dayiis omaahonôôn dayimb, ");
INSERT INTO mmo_vpl VALUES ("MK7_22","071_7_22","MRK","7","22","22","dawiing baayamb, dawiing mend nôôn, dawiing va nipaya vaha vaha, davu tatuhin omaahonôôn, dawiing va nindanjeen lôôt, ahend anipaya vu omaaho ango, danêêl vakasin anipaya lak omaahonôôn, dako sil ak, osin dawiing va danje-danjeen. ");
INSERT INTO mmo_vpl VALUES ("MK7_23","071_7_23","MRK","7","23","23","Va nipaya pin nambêênja naale hôôk omaahonôôn alondpayo be nalaam langaah, ond mem nawiing-ambe Anutu nayi omaahonôôn nambe nipaya.” ");
INSERT INTO mmo_vpl VALUES ("MK7_24","071_7_24","MRK","7","24","24","Yesu vu manyinju be la taaku sen bayêên Taia yuuh Saidon neep-ato, tombe huli-la nando hôôk bayêên ti be wiingin nambe mando kaatokin de hil-ame lanjak ni le. ");
INSERT INTO mmo_vpl VALUES ("MK7_25","071_7_25","MRK","7","25","25","Le ma de vêêh ti hangoyin nambe nando, tombe la vu pavis. ");
INSERT INTO mmo_vpl VALUES ("MK7_26","071_7_26","MRK","7","26","26","Vêêh-anju yi Glik ti, tangganaan hako neep Pinisia vu Silia-te taaku, ond mamu nipaya ti hôôvu vêêh-anju nowaavêêh, om la hato pataav baambu neep voon hôôk Yesu vaha be kataangg nambe gatiiy mamu na in nowaavêêh. ");
INSERT INTO mmo_vpl VALUES ("MK7_27","071_7_27","MRK","7","27","27","Tombe Yesu nêêl vu nambe, “Yaambu vanôôn vu unoopasiv-ambe lanja vêêl e, de me-lohvu nambe omaaho ti gako unoopasiv-ate vanôôn-ambe gaate na vu voow e.” ");
INSERT INTO mmo_vpl VALUES ("MK7_28","071_7_28","MRK","7","28","28","Tombe nêêl laah vu nambe, “Êê-e, Omaaho Bop, manyinja ganêêl keen, lemu voow sen daale hôôk pêêt ahendanggaa-to ond daya unoopasiv-ate vanôôn paapu.” ");
INSERT INTO mmo_vpl VALUES ("MK7_29","071_7_29","MRK","7","29","29","Tombe Yesu nêêl vu nambe, “Ganêêl nambêênjo om lung, de ganaah in mamu nipaya hato la in nomaavêêh.” ");
INSERT INTO mmo_vpl VALUES ("MK7_30","071_7_30","MRK","7","30","30","Om laah valup baan e yi nambe mamu nipaya hato la de unaavepasiv neep nivasa lak pêêt. ");
INSERT INTO mmo_vpl VALUES ("MK7_31","071_7_31","MRK","7","31","31","+ o 7:31 Mat 15:29-31*Yesu vu Taia be la valup Saidon, de la be tok la Dekapolis, tonde monala be tok laah betum Galili. ");
INSERT INTO mmo_vpl VALUES ("MK7_32","071_7_32","MRK","7","32","32","+ o 7:32 Mak 5:23; Luk 4:40; 13:13*Tonde sim lako omaaho ti nanye katôônd osin ka ngangolangin la vu Yesu be sil kataangg yi nambe gambe nama jak. ");
INSERT INTO mmo_vpl VALUES ("MK7_33","071_7_33","MRK","7","33","33","+ o 7:33 Mak 8:33*Hil ngeeyaata dando om Yesu hako be yuuh lala lundoos, le mem lop nama kapis lukala omaahôô-ju nanye vuun vaalu vaalu, tonde wiing avi luk ak nama kapis-ambe hatung lakando omaahôô-ju dalaan, ");
INSERT INTO mmo_vpl VALUES ("MK7_34","071_7_34","MRK","7","34","34","+ o 7:34 Mak 6:41; Jon 11:41*tonde me lak baandoni be sawaah sêên, tombe nêêl vu nambe, “Epata,” dangga nambe “Nanyem naatok.” ");
INSERT INTO mmo_vpl VALUES ("MK7_35","071_7_35","MRK","7","35","35","Om nanye tok-ande dalaan ahelavis ak-ambe vakaas nivasa. ");
INSERT INTO mmo_vpl VALUES ("MK7_36","071_7_36","MRK","7","36","36","+ o 7:36 Mak 1:43-45*Tombe Yesu vu kôôvu sil lôôt nambe me-daanêêl vaa-ju langaah vu omaaho ti le, le ma de sil lanêêl langaah lôôt vu omaahonôôn pin. ");
INSERT INTO mmo_vpl VALUES ("MK7_37","071_7_37","MRK","7","37","37","+ o 7:37 Ais 35:5*Tombe lavindis lôôt-ambe lanêêl nambe, “Wiing va pin nivasa lôôt. Wiing-ambe hil nanyend katôônd dangoyin taaku de kama-so dakaas.” ");
INSERT INTO mmo_vpl VALUES ("MK8_1","071_8_1","MRK","8","1","1","Hil ngeeyaata lasupin yesin laah atombe vanôôn ma, om Yesu teey yite maanggêêm-aso lalaam vu be nêêl vu sil nambe, ");
INSERT INTO mmo_vpl VALUES ("MK8_2","071_8_2","MRK","8","2","2","+ o 8:2 Mak 6:34-44*“Sa kangg pasiv in hil ngeeyaataa-jo, in dando having sa lohvu busin yaal de silanêênd vanôôn sen lanjaa-to ma. ");
INSERT INTO mmo_vpl VALUES ("MK8_3","071_8_3","MRK","8","3","3","Naambe saambiing sil lana meep-ambe lanaah baand, ond le sakend nama jak vu mop lavuun, in sil vaalu lalaam vu taaku diin.” ");
INSERT INTO mmo_vpl VALUES ("MK8_4","071_8_4","MRK","8","4","4","Tombe yite maanggêêm-aso lanêêl laah vu yi nambe, “Yale gako vanôôn vu tana be yambaat hil-anjo? Manyinjo taaku lumbalaamb-anjo.” ");
INSERT INTO mmo_vpl VALUES ("MK8_5","071_8_5","MRK","8","5","5","Tombe lingin sil nambe, “Hamate vanôôn nôôn vaaheey naahen nando?” Le lanêêl nambe, “Balet namaavaalu be vindak yuuh nando.” ");
INSERT INTO mmo_vpl VALUES ("MK8_6","071_8_6","MRK","8","6","6","Om nêêl vu hil pin nambe sil gato mando voon, tonde mem hako balet namaavaalu be vindak yuuh-anjuuto be lohak osin pêêlis la vu Anutu, le mem hapok-ambe vu vu yite maanggêêm-aso in nambe sil gatiiy, tombe latiiy lohvu hil pin. ");
INSERT INTO mmo_vpl VALUES ("MK8_7","071_8_7","MRK","8","7","7","Tonde yite maanggêêm-aso lako paahuung anipasiv heey, tombe yik lohak-ande nêêl-ambe sil latiiy lohvu hil pin having. ");
INSERT INTO mmo_vpl VALUES ("MK8_8","071_8_8","MRK","8","8","8","Tombe yik laya be lohvu sil. Laya lung atonde lasupin nyengale hôôk jaambang namaavaalu be vindak yuuh-ambe pup. ");
INSERT INTO mmo_vpl VALUES ("MK8_9","071_8_9","MRK","8","9","9","Omaahonôôn-anju ngeeyaata lôôt lohvu 4 taosen. Yesu wiing hil lala, ");
INSERT INTO mmo_vpl VALUES ("MK8_10","071_8_10","MRK","8","10","10","de pavis atomb having yite maanggêêm-aso be sil lalakala kaanu ti be lala taaku Dalmanuta. ");
INSERT INTO mmo_vpl VALUES ("MK8_11","071_8_11","MRK","8","11","11","+ o 8:11 Mat 12:38*Palisai lala vu Yesu be lakaas atombe sil davu mahôôh yi, tonde lawiingin nambe sahi Yesu om sil tambe nambe biing taahu taahu jak va niwêêk baandoni ti. ");
INSERT INTO mmo_vpl VALUES ("MK8_12","071_8_12","MRK","8","12","12","+ o 8:12 Luk 11:29*Le Yesu sawaah sêên osin lopayo nimeen-ande nêêl nambe, “Hil pin sen dando gêên-anjo lawiingin nambe lanji taahu taahu in vaati? Sa naanêêl vu ham keenaanôôn naambe same le aambiing taahu taahu be sil lanji le, malis.” ");
INSERT INTO mmo_vpl VALUES ("MK8_13","071_8_13","MRK","8","13","13","Tonde havuuh sil-ande lak kaanu yesin-ambe la betum vaalu. ");
INSERT INTO mmo_vpl VALUES ("MK8_14","071_8_14","MRK","8","14","14","Yesu-te maanggêêm-aso kand lingin-ande me-lako vanôôn e, yik balet nôôn timu nando hôôk kaanu lopayo. ");
INSERT INTO mmo_vpl VALUES ("MK8_15","071_8_15","MRK","8","15","15","+ o 8:15 Luk 12:1*Tombe Yesu vu kôôvu sil in nambe Palisai osin Helot-ate va nipaya me-na ganggwang sil alondpayo le. Nêêl nambe, “Ond ham gango, ham ganggin ham nivasa in Palisai osin Helot-ate yis balet-ate.” ");
INSERT INTO mmo_vpl VALUES ("MK8_16","071_8_16","MRK","8","16","16","Tombe sil oo mondanêêl vu sil nambe, “Ke, yame hako balet e, ondeey nêêl nambêênju.” ");
INSERT INTO mmo_vpl VALUES ("MK8_17","071_8_17","MRK","8","17","17","+ o 8:17 Mak 6:52*Le Yesu lak ni om nêêl vu sil nambe, “Nambe vaati sen ham vakaas danjeen nambe ‘Yame hako balet e?’ Ham-ame alak ni le? Mak ham naahen doosin a? Mak ham alompayo niwêêk ak a? ");
INSERT INTO mmo_vpl VALUES ("MK8_18","071_8_18","MRK","8","18","18","+ o 8:18 Jer 5:21; Esi 12:2; Mak 4:12; Sin 28:26*Ham amem neep, le ma de ham-ame ahe le, de ham nanyem neep, le ma de ham-ame hangoyin e. Mak ham akam-ame navu le? ");
INSERT INTO mmo_vpl VALUES ("MK8_19","071_8_19","MRK","8","19","19","+ o 8:19 Mak 6:41-44*Sa hapok balet namaavaalu be saavu lohvu moow 5 taosen-ato, ond ham asupin nyengale hôôk jaambang vilis-ambe pup?” Le lanêêl vu nambe, “Hey aasupin hôôk nomaayuuh-ambe laam yuuh.” ");
INSERT INTO mmo_vpl VALUES ("MK8_20","071_8_20","MRK","8","20","20","+ o 8:20 Mak 8:6-9*Tonde yik lingin nambe, “De sa hapok balet namaavaalu be vindak yuuh-ambe saavu lohvu hil 4 taosen-ato ond ham asupin nyengale hôôk jaambang vilis-ambe pup?” Le lanêêl vu nambe, “Hey aasupin hôôk namaavaalu be vindak yuuh.” ");
INSERT INTO mmo_vpl VALUES ("MK8_21","071_8_21","MRK","8","21","21","Tonde nêêl vu sil nambe, “Le sim ham naahen doosin a?” ");
INSERT INTO mmo_vpl VALUES ("MK8_22","071_8_22","MRK","8","22","22","Sil lala taaku Betsaida tombe vaheey lako omaaho mekanu ti be lala vu Yesu, be sil kataangg nambe gambe nama jak omaahôô-ju. ");
INSERT INTO mmo_vpl VALUES ("MK8_23","071_8_23","MRK","8","23","23","+ o 8:23 Jon 9:6*Tombe Yesu laandiiy hôôk omaaho mekanuu-to nama be yuuh lala taaku nanyendangga, le mem kasuv lukala mekaalus-ande hambe nama lak, tonde lingin nambe, “Gahe vaheey a?” ");
INSERT INTO mmo_vpl VALUES ("MK8_24","071_8_24","MRK","8","24","24","Tombe vêêl mekaalus lak-ambe nêêl nambe, “Sa naahe omaahonôôn nambe haah, lemu daale dala.” ");
INSERT INTO mmo_vpl VALUES ("MK8_25","071_8_25","MRK","8","25","25","Tombe Yesu hambe nama lak mekaalus yesin tonde mem yi taaku lôôt, de me tum-ambe yi va pin neep langaah. ");
INSERT INTO mmo_vpl VALUES ("MK8_26","071_8_26","MRK","8","26","26","+ o 8:26 Mak 7:36*Tombe Yesu nambe, “Ganaah gambaam de game gandukanaah taaku Betsaidaa-ju le.” ");
INSERT INTO mmo_vpl VALUES ("MK8_27","071_8_27","MRK","8","27","27","Yesu having yite maanggêêm-aso be lala in lana taaku Sisalia Pilipai. Daahen dala tonde Yesu lingin yite maanggêêm-aso nambe, “Hil danêêl nambe sa lati?” ");
INSERT INTO mmo_vpl VALUES ("MK8_28","071_8_28","MRK","8","28","28","+ o 8:28 Mak 6:15*Tombe sil lanêêl vu nambe, “Hil vaalu danêêl hong nambe Jon sen nalipis hil-ato, de vaalu danêêl hong nambe Eliya, de vaalu danêê lhong nambe Anutu-te hil sen danêêl yite vakasin langaah-ato ti.” ");
INSERT INTO mmo_vpl VALUES ("MK8_29","071_8_29","MRK","8","29","29","+ o 8:29 Jon 6:68-69*Tombe lingin sil nambe, “De ham-ok? Ham nanêêl sa nambe lati?” Le Pita nêêl vu nambe, “Hong omaaho sen Anutu yoo holin hong vulôôt in nambe gandôôvu hey-ato.” ");
INSERT INTO mmo_vpl VALUES ("MK8_30","071_8_30","MRK","8","30","30","+ o 8:30 Mak 9:9*Tombe Yesu vu kôôvu sil nambe me-daanêêl yi langaah vu omaaho ti le. ");
INSERT INTO mmo_vpl VALUES ("MK8_31","071_8_31","MRK","8","31","31","Yesu nêêl taato vu sil nambe, “Omaahonôôn Noow e gako nivaane ngeeyaata. Himbop-aso osin kul vaha sen datung salivangin-ato silate yêêv-aso de tanasin dangga-so, ond sil e nind baya in-ande lanyiis-ambe jimb, tonde busin yaal jung na le mem le kandi jak jesin naah.” ");
INSERT INTO mmo_vpl VALUES ("MK8_32","071_8_32","MRK","8","32","32","Nêêl langaah nambêênjo om Pita hako yi be yuuh lala daale lundoos, le mem nêêl Yesu. ");
INSERT INTO mmo_vpl VALUES ("MK8_33","071_8_33","MRK","8","33","33","Le Yesu hilin-ambe yi yite maanggêêm-aso de nêêl Pita nambe, “Saalang, gana vêêl in sa, in gakam-ame navu va lohvu Anutu ka le, nganjo gakam oo navu va lohvu omaahonôôn akand amu.” ");
INSERT INTO mmo_vpl VALUES ("MK8_34","071_8_34","MRK","8","34","34","+ o 8:34 Mat 10:38-39*Yesu teey hil pin-anju osin yite maanggêêm-aso lalaam vu be nêêl vu sil nambe, “Omaaho ti wiingin nambe sapa sa, ond yoo daanggôôl yi le mem kava yite haah pako be sapa sa. ");
INSERT INTO mmo_vpl VALUES ("MK8_35","071_8_35","MRK","8","35","35","+ o 8:35 Luk 17:33; Jon 12:25*De omaaho ti yoo wiingin nambe ganggin ninaavi nivasa in mando metumin, ond le jimb-ambe na menama osin nôôn metumin-ate. Le naambe omaaho ti baaku nimeen ak sa haalengg osin Anutu-te banye nivasa be jimb, ond mem le mando metumin danggata. ");
INSERT INTO mmo_vpl VALUES ("MK8_36","071_8_36","MRK","8","36","36","Le omaaho ti gôôlis va voon-ate pin, de jimb-ambe na menama osin nôôn metumin-ate, ond va voon-ate me-le dôôvu yi le, le nama. ");
INSERT INTO mmo_vpl VALUES ("MK8_37","071_8_37","MRK","8","37","37","De va voon-ate ti me-neep in nambe omaaho ti me-baanggo kanu jak-ambe mando metumin danggata le, malis. ");
INSERT INTO mmo_vpl VALUES ("MK8_38","071_8_38","MRK","8","38","38","+ o 8:38 Mat 10:33*Hil sen dawiing va nipaya be dando gêên-anjo, ond ti jêênin omaahonôôn-ande nimbaya in sa osin sate vakasin, de me-naanêêl sa haalengg langaah vu hil e, ond busin sen Omaahonôôn Noow nom osin Mangganaan-ate nikaapulis gaving angela vaambuung-asôôto, ond le nimbaya in omaahôô-ju dukanaah.” ");
INSERT INTO mmo_vpl VALUES ("MK9_1","071_9_1","MRK","9","1","1","+ o 9:1 Mak 13:30*Yesu nêêl vu sil nambe, “Sa naanêêl keen vu ham naambe ham sen ham naalêê-jo, ond vaalu me-le lanjimb e, de lanji busin sen Anutu ganggin yite hil-ato naatok naam osin niwêêk e mem.” ");
INSERT INTO mmo_vpl VALUES ("MK9_2","071_9_2","MRK","9","2","2","Busin namaavaalu be vindak ti la vêêl e mem Yesu hako Pita yuuh Jems-ande Jon-ambe sil oo lalak kandu bopaata ti be lala, tombe sil pin-ambe daale, tonde sim Yesu ninaavi ango yoow ak hôôk yaal amend, ");
INSERT INTO mmo_vpl VALUES ("MK9_3","071_9_3","MRK","9","3","3","tombe yite lolop têêlang nivalôôy lôôt. Omaaho ti me-lohvu nambe jipis lolop-ambe nivalôôy jak naambêênju le. ");
INSERT INTO mmo_vpl VALUES ("MK9_4","071_9_4","MRK","9","4","4","Tombe sim yaal layi de Eliya yuuh Mose daale having Yesu be yaal dakaas. ");
INSERT INTO mmo_vpl VALUES ("MK9_5","071_9_5","MRK","9","5","5","Tombe Pita nêêl vu Yesu nambe, “Omaaho Bop, yiiy nandôô-jo nivasa lôôt, om waay andaav numang daka yaal, gate ti, Mose-te ti, de Eliya-te ti.” ");
INSERT INTO mmo_vpl VALUES ("MK9_6","071_9_6","MRK","9","6","6","Yaal layêênin lôôt om Pita doosin va sen naanêêl-ato ondeey nêêl vakasin-anju. ");
INSERT INTO mmo_vpl VALUES ("MK9_7","071_9_7","MRK","9","7","7","+ o 9:7 Mat 3:17; 2Pi 1:17-18; Diu 18:15; Sin 3:22*Tombe sim bayiimb ti vayum sil, tonde lava ti laam hôôk bayiimb-anju lopayo nambe, “Sa noongg-anja. Sahengg having yi lôôt om ham gango lava.” ");
INSERT INTO mmo_vpl VALUES ("MK9_8","071_9_8","MRK","9","8","8","Tonde yaal amend hako hôôk taaku pavis, le me-layi omaaho ti le, malis, yik Yesu yoo timu naale. ");
INSERT INTO mmo_vpl VALUES ("MK9_9","071_9_9","MRK","9","9","9","+ o 9:9 Mat 12:16; Mak 8:30*Sil vu kanduu-ju be daahen mondaluus atonde Yesu vu kôôvu yaal nambe me-daanêêl va sen layii-to vu omaaho ti le, de Omaahonôôn Noow kandi jak naah vu hil yimbin-ate vêêl e mem daanêêl. ");
INSERT INTO mmo_vpl VALUES ("MK9_10","071_9_10","MRK","9","10","10","Tombe yaal lawii-having lava, lemu yaal lalingin vu yaal nambe, “Peey e vakasin-anjo danggakook nambe vaati sen nambe kandi jak naah vu hil yimbin-ate?” ");
INSERT INTO mmo_vpl VALUES ("MK9_11","071_9_11","MRK","9","11","11","Om yaal lalingin yi nambe, “Nambe vaati sen tanasin dangga-so danêêl nambe Eliya le naamunggin e mem Omaaho Bop naam?” ");
INSERT INTO mmo_vpl VALUES ("MK9_12","071_9_12","MRK","9","12","12","+ o 9:12 Mal 4:5; Saam 22:1-18; Ais 53:3*Tombe nêêl vu yaal nambe, “De. Eliya le naamunggin in samu va pin dukanaah, lemu nambe vaati sen vakasin neep hôôk kaapiya nambe Omaahonôôn Noow e gako nivaane bopaata osin hil daanêêl yi pale? ");
INSERT INTO mmo_vpl VALUES ("MK9_13","071_9_13","MRK","9","13","13","+ o 9:13 Mat 11:14*Le sa naanêêl vu ham naambe Eliya laam lung la, le hil vaalu lawiing va nindanjeen vu yi lohvu sil oo kand, nambe sen neep hôôk Anutu-te kaapiyaa-to.” ");
INSERT INTO mmo_vpl VALUES ("MK9_14","071_9_14","MRK","9","14","14","Latok lalaah vu maanggêêm-aso vaalu tombe layi hil ngeeyaata lambuuh sil tatup, de hil tanasin dangga-so dakaas-ambe dayêês sil lôôt. ");
INSERT INTO mmo_vpl VALUES ("MK9_15","071_9_15","MRK","9","15","15","Le sim hil pin layi de Yesu hato, tombe lavindis lôôt-ambe laakôôhin-ande latup-ambe lala vu yi pavis. ");
INSERT INTO mmo_vpl VALUES ("MK9_16","071_9_16","MRK","9","16","16","Tombe lingin sil nambe, “Ham nakaas in vakasin vaati?” ");
INSERT INTO mmo_vpl VALUES ("MK9_17","071_9_17","MRK","9","17","17","Tombe sim omaaho ti nêêl vu nambe, “Kaputung, saanggiiy sa noongg laam vu hong in mamu ti wiing-ambe ka ma, ");
INSERT INTO mmo_vpl VALUES ("MK9_18","071_9_18","MRK","9","18","18","de naambe busin sen mamu dôôvuu-to ond nôôh-ambe gaate na nanjip voon-ande nyekaakôôs naam, de navu naangitak osin ninaavi ahevaha jak. Tombe sa kataangg gate maanggêêm-aso nambe sil gatiiy mamu na, le me-lalohvu le.” ");
INSERT INTO mmo_vpl VALUES ("MK9_19","071_9_19","MRK","9","19","19","Le Yesu nêêl vu sil nambe, “Ham pin-ame awii-having e. Sa mando gaving ham-ambe naangelis e mem ham anjak sate kul ani? De sa gako nimeen in ham na nohvu busin vilis e? Ham gako unoopasiv naam vu sa.” ");
INSERT INTO mmo_vpl VALUES ("MK9_20","071_9_20","MRK","9","20","20","Om lako laam vu yi. Mamu yi Yesu tombe handu unoopasiv pavis-ambe lupake be la neep nahaahin neep voon-ambe nyekaakôôs laam. ");
INSERT INTO mmo_vpl VALUES ("MK9_21","071_9_21","MRK","9","21","21","Tonde Yesu lingin unoopasiv mangganaan nambe, “Nando nambêênjo lohvu ta vilis?” Le nêêl nambe, “Naahen nipasiv-ato de vaa-jo wiing. ");
INSERT INTO mmo_vpl VALUES ("MK9_22","071_9_22","MRK","9","22","22","Balon ngeeyaata mamu nahôôvu tombe naate nayêê-nala kin osin nalupake lukala bel in nambe nyiis-ambe jimb, om galohvu nambe gambiing ond gakam pasiv in haay-ambe gandôôvu haay.” ");
INSERT INTO mmo_vpl VALUES ("MK9_23","071_9_23","MRK","9","23","23","+ o 9:23 Mat 21:21; Mak 11:23*Tombe Yesu nêêl laah vu nambe, “Êê-e, naambe galohvu ond mem, in omaaho ti sen wii-having Anutuu-to, ond lohvu nambe biing va pin nohvu.” ");
INSERT INTO mmo_vpl VALUES ("MK9_24","071_9_24","MRK","9","24","24","+ o 9:24 Luk 17:5*Le unoopasiv mangganaan nêêl niwêêk pavis nambe, “Saawii-having, lemu gandôôvu sa in saambiing gaving niwêêk lôôt.” ");
INSERT INTO mmo_vpl VALUES ("MK9_25","071_9_25","MRK","9","25","25","Yesu yi nambe hil ngeeyaata lasupin lalaam lôôt, tombe nêêl mamu nipaya nambe, “Mamu-e, gawiing-ambe unoopasiv-anjo nanye katôônd osin ka maa-to, om sa naanêêl vu hong naambe onggavuuh yi de gana, de game gandukanaah jesin naah e.” ");
INSERT INTO mmo_vpl VALUES ("MK9_26","071_9_26","MRK","9","26","26","+ o 9:26 Mak 1:26*Tonde mamu hangeeyak-ande handu unoopasiv lôôt, tonde hato be la, de unoopasiv neep nambe sen omaahonôôn yimbin-ato, om hil vaalu lanêêl nambe, “Yimb la.” ");
INSERT INTO mmo_vpl VALUES ("MK9_27","071_9_27","MRK","9","27","27","Le Yesu laandiiy hôôk nama be kandi naale. ");
INSERT INTO mmo_vpl VALUES ("MK9_28","071_9_28","MRK","9","28","28","Tonde Yesu having yite maanggêêm-aso be lalukala bayêên alo, tombe sil lalingin nambe, “Nambe vaati sen hey-ame aalohvu nambe gatiiy mamu na le?” ");
INSERT INTO mmo_vpl VALUES ("MK9_29","071_9_29","MRK","9","29","29","Le Yesu nêêl vu sil nambe, “Lohakin timu ond mem lohvu nambe gatiiy mamu nambêênju na, de vaheey ond me-lohvu le.” ");
INSERT INTO mmo_vpl VALUES ("MK9_30","071_9_30","MRK","9","30","30","+ o 9:30 Jon 7:1*Sil vu manyinju be lala osin Galili be lala, tombe Yesu nimbaya nambe hil-ame lanjak ni le, ");
INSERT INTO mmo_vpl VALUES ("MK9_31","071_9_31","MRK","9","31","31","+ o 9:31 Mak 8:31; 10:32-34*in nanêêl taato vu yite maanggêêm-aso nambe omaaho ti navu bu Omaahonôôn Noow dukana hil namand in lanyiis-ambe jimb. Lanyiis-ambe jimb jung na, tonde busin yaal e mem kandi jak jesin naah. ");
INSERT INTO mmo_vpl VALUES ("MK9_32","071_9_32","MRK","9","32","32","+ o 9:32 Luk 18:34*Le maanggêêm-aso doosin vakasin dangga om layêênin nambe me-lanjingin yi le. ");
INSERT INTO mmo_vpl VALUES ("MK9_33","071_9_33","MRK","9","33","33","Sil latok lala taaku Kapenaum tombe lalukala bayêên alo le mem Yesu lingin maanggêêm-aso nambe, “Ham nanêêl vaati lôôt vu mopaatôôv lavuun-ambe ham nalaam?” ");
INSERT INTO mmo_vpl VALUES ("MK9_34","071_9_34","MRK","9","34","34","+ o 9:34 Luk 22:24*Le sil lavand ma, in daahen davu tatuuvu mopaatôôv-ato ond sil dayêês sil nambe sil ti tana tu lukook bop vu ango-so. ");
INSERT INTO mmo_vpl VALUES ("MK9_35","071_9_35","MRK","9","35","35","+ o 9:35 Mat 20:25-27; Mak 10:43-44*Tombe hato nando le mem supin sil nomaayuuh-ambe laam yuuh-ato be nêêl vu sil nambe, “Omaaho ti wiingin nambe naatu bop naamunggin ango-so, ond yoo naah taamu be biing va naambe sen yi omaaho malis ti in dôôvu sil pin.” ");
INSERT INTO mmo_vpl VALUES ("MK9_36","071_9_36","MRK","9","36","36","Tombe laandiiy unoopasiv ti laam naale hôôk sil lavuun, be lôôh ak-ambe kava, le mem nêêl vu sil nambe, ");
INSERT INTO mmo_vpl VALUES ("MK9_37","071_9_37","MRK","9","37","37","+ o 9:37 Mat 10:40*“Omaaho ti ka bu sa haalengg-ambe gako unoopasiv naambêênjo ti jak ond lohvu hako sa lak. Tombe omaaho ti sen hako sa lak-ato ond me-hako sa lak e, nganjo hako omaaho sen wiing sa laam-ato lak.” ");
INSERT INTO mmo_vpl VALUES ("MK9_38","071_9_38","MRK","9","38","38","+ o 9:38 Nam 11:27-29*Tonde Jon nêêl vu nambe, “Kaputung-e, hey aahe omaaho ti natiiy mamu lak ohaalem, le ma de hey aanêêlin yi in nambe yame yate hil ti le.” ");
INSERT INTO mmo_vpl VALUES ("MK9_39","071_9_39","MRK","9","39","39","+ o 9:39 1Ko 12:3*Le Yesu nêêl nambe, “Ham-ame naanêêlin yi le, in nambe omaaho ti nawiing taahu taahu osin niwêêk jak sa haalengg, ond me-lohvu nambe naanêêl vakasin anipaya jak sa pavis e, malis. ");
INSERT INTO mmo_vpl VALUES ("MK9_40","071_9_40","MRK","9","40","40","+ o 9:40 Mat 12:30; Luk 11:23*In hil sen me-dayi yiiy payaa-to ond manyinjo yate hil. ");
INSERT INTO mmo_vpl VALUES ("MK9_41","071_9_41","MRK","9","41","41","+ o 9:41 Mat 10:42*Naambe omaaho ti bu bel kuuh vu ham in ham naanum in dangga nambe Kalisi-te hil ham, ond sa naanêêl keenaanôôn vu ham naambe omaahôô-ju le gako yite samu samu nivasa nyevahaan dukanaah.” ");
INSERT INTO mmo_vpl VALUES ("MK9_42","071_9_42","MRK","9","42","42","“Naambe omaaho ti taahu va nipaya vu sate unoopasiv-aso sen londpayo nalaam timu vu saa-to ti be biing va nipaya, ond le naatokak nyevahaan bopaata vu taamusin, ond hil talu tatuuh bopaata dôôk omaahôô-ja ka naamunggin-ambe gaate dukana lôôy-ambe davin na, ond mem nivasa in me-taahu omaahonôôn dôôk va nipaya le. ");
INSERT INTO mmo_vpl VALUES ("MK9_43","071_9_43","MRK","9","43","43","+ o 9:43 Mat 5:30*De naambe onamam vaalu biing-ambe va nipaya kape hong, ond okatôôv na de onamam vaalu bati mu, ond mem nivasa in gale gana mando metumin danggata. Le naambe omando osin onamam yuuh ahondoos, ond gale gana taaku nipaya sen kin neep natum danggataa-to. ");
INSERT INTO mmo_vpl VALUES ("MK9_44","071_9_44","MRK","9","44","44","Taaku nipaya sen-anju ond male monaya sil lohvu busin pin-ande me-le jimb e, de kin ond vaheey-ame le daapuv jimb e, yoo le nanjip naatum danggata. ");
INSERT INTO mmo_vpl VALUES ("MK9_45","071_9_45","MRK","9","45","45","De naambe ovaham gako hong-ambe gandukana va nipaya, ond okatôôv na de ovaham vaalu bati mu, ond mem nivasa in gale gana mando metumin danggata. Le naambe omando osin ovaham yuuh ahondoos, ond le gaate hong dukana taaku nipaya. ");
INSERT INTO mmo_vpl VALUES ("MK9_46","071_9_46","MRK","9","46","46","Taaku nipaya sen-anju ond male monaya sil lohvu busin pin-ande me-le jimb e, de kin ond vaheey-ame le daapuv jimb e, yoo le nanjip naatum danggata. ");
INSERT INTO mmo_vpl VALUES ("MK9_47","071_9_47","MRK","9","47","47","+ o 9:47 Mat 5:29*De naambe gamem kaalus vaalu taato va nipaya vu hong-ambe gandupake hôôk va nipaya, ond okayovakin-ambe onggaate na de gamem vaalu bati mu, ond mem nivasa in gale gandukana gaving Anutu-te hil. Le naambe gamem kaalus yuuh ahondoos nanjip, ond le gaate hong dukana taaku nipaya. ");
INSERT INTO mmo_vpl VALUES ("MK9_48","071_9_48","MRK","9","48","48","+ o 9:48 Ais 66:24*Taaku nipaya sen-anju ond male monaya sil lohvu busin pin-ande me-le jimb e, de kin ond vaheey-ame le daapuv jimb e, yoo le nanjip naatum danggata. ");
INSERT INTO mmo_vpl VALUES ("MK9_49","071_9_49","MRK","9","49","49","Kin e na jaliv hil pin naambe sen gaas naliv vanôôn-ato. ");
INSERT INTO mmo_vpl VALUES ("MK9_50","071_9_50","MRK","9","50","50","+ o 9:50 Mat 5:13; Luk 14:34; Kol 4:6; Lom 12:18; 1Tes 5:13*Gaas ond va nivasa, lemu naambe gaas anikuuh ak ond yale aambiing vaati vu be naatu nanyêên jesin naah? Gaas jaliv ham ond mem ham mando javuh ti nivasa.” ");
INSERT INTO mmo_vpl VALUES ("MK10_1","071_10_1","MRK","10","1","1","Yesu havuuh taakuu-ju de la taaku Yudia be la bel Yoladan vaalu, tombe hil ngeeyaata lasupin lala vu yi yesin, be nawiing tanasin vu sil nambe sen yoo nawiing-ato. ");
INSERT INTO mmo_vpl VALUES ("MK10_2","071_10_2","MRK","10","2","2","Tombe sim hil Palisai heey lala vu yi in nambe sahi lopayo, om lalingin nambe, “Naambe omaaho ti bapuuh vane na, ond lohvu tanasin me ma?” ");
INSERT INTO mmo_vpl VALUES ("MK10_3","071_10_3","MRK","10","3","3","Le lingin laah vu sil nambe, “Om Mose vu tanasin nambe vaati vu ham?” ");
INSERT INTO mmo_vpl VALUES ("MK10_4","071_10_4","MRK","10","4","4","+ o 10:4 Diu 24:1-4; Mat 5:31*Tombe lanêêl nambe, “Mose liinggis nambe omaaho ti kaavu kaapiya ti naambe bapuuh vane na, ond bapuuh.” ");
INSERT INTO mmo_vpl VALUES ("MK10_5","071_10_5","MRK","10","5","5","+ o 10:5 Jen 1:27; 5:2*Le Yesu nêêl vu sil nambe, “Mose lak ni nambe ham alompayo niwêêk ak ondeey kaavu vakasin-anju lohvu ham oo kam, ");
INSERT INTO mmo_vpl VALUES ("MK10_6","071_10_6","MRK","10","6","6","lemu vu munggin sen Anutu hatung va pin nyendoos-ato, ond hatung omaahonôôn, samu moow ayuuh vêêh. ");
INSERT INTO mmo_vpl VALUES ("MK10_7","071_10_7","MRK","10","7","7","+ o 10:7 Jen 2:24; Ep 5:31*Om moow gavuuh mangganaan ayuuh tangganaan de gako vêêh-ambe yuuh mando javuh ti, ");
INSERT INTO mmo_vpl VALUES ("MK10_8","071_10_8","MRK","10","8","8","be mem yuuh daatu nôôn timu, de yuuh-ame yuuh e, nganjo yuuh latu nôôn timu. ");
INSERT INTO mmo_vpl VALUES ("MK10_9","071_10_9","MRK","10","9","9","Om va sen Anutu wiing-ambe tu nôôn timuu-to, ond omaahonôôn-ame kahe le.” ");
INSERT INTO mmo_vpl VALUES ("MK10_10","071_10_10","MRK","10","10","10","Lung laa tonde sil lalaah bayêên alo, le mem Yesu-te maanggêêm-aso lalingin yi in vakasin-anjo, ");
INSERT INTO mmo_vpl VALUES ("MK10_11","071_10_11","MRK","10","11","11","+ o 10:11 Mat 5:32; 1Ko 7:10-11*le nêêl vu sil nambe, “Naambe moow ti gavuuh vane na de gako vêêh ango, ond wiing baayamb. ");
INSERT INTO mmo_vpl VALUES ("MK10_12","071_10_12","MRK","10","12","12","De naambe vêêh ti gavuuh laya na de jak vu moow ango, ond yik wiing baayamb.” ");
INSERT INTO mmo_vpl VALUES ("MK10_13","071_10_13","MRK","10","13","13","Hil lako unoopasiv laam vu Yesu in nambe gambe nama jak sil, le yite maanggêêm-aso lanêêl sil. ");
INSERT INTO mmo_vpl VALUES ("MK10_14","071_10_14","MRK","10","14","14","Le Yesu yi tombe ahekalin vu yite maanggêêm-aso be nêêl vu sil nambe, “Ham baale de unoopasiv-anju lanaam vu sa le. Ham-ame anggilin sil e, in Anutu nanggin hil nambêênja having. ");
INSERT INTO mmo_vpl VALUES ("MK10_15","071_10_15","MRK","10","15","15","+ o 10:15 Mat 18:3*Sa naanêêl keen vu ham naambe omaaho ti me-gulis Anutu baambu naambe unoopasiv-anju le, ond me-le dukana gaving Anutu-te hil e.” ");
INSERT INTO mmo_vpl VALUES ("MK10_16","071_10_16","MRK","10","16","16","Tonde kava unoopasiv ti ti lak-ambe hambe nama lak sil de lohak ak sil. ");
INSERT INTO mmo_vpl VALUES ("MK10_17","071_10_17","MRK","10","17","17","Yesu la in nambe na taaku ti, tonde omaaho ti hatup-ambe la hatung kaatu vu de lingin nambe, “Kaputung anivasa, saambiing vaati le mem sa mando metumin danggata?” ");
INSERT INTO mmo_vpl VALUES ("MK10_18","071_10_18","MRK","10","18","18","Tombe Yesu nêêl vu nambe, “Ganêêl sa nambe nivasa in? Omaaho ti me-nivasa le, Anutu timu nivasa. ");
INSERT INTO mmo_vpl VALUES ("MK10_19","071_10_19","MRK","10","19","19","+ o 10:19 Eks 20:12-17; Diu 5:16-20; 24:14; Jem 5:4*Galak tanasin ani nambe, ‘Game ganyiis omaahonôôn jimb e, game gambiing baayamb e, game gambiing hôôndak e, game tatuhin vakasin jak omaaho ango le, game tatuhin omaaho ango de onggako yite va le, onggako mom ayuuh tam jak.” ");
INSERT INTO mmo_vpl VALUES ("MK10_20","071_10_20","MRK","10","20","20","Le nêêl vu Yesu nambe, “Kaputung, sa naahen unoopasiv-ande sa samu va pin-anja lôôt-ambe gêên-anjo.” ");
INSERT INTO mmo_vpl VALUES ("MK10_21","071_10_21","MRK","10","21","21","+ o 10:21 Mat 10:38; 6:20; Mak 8:34*Tombe Yesu yi be ahe having, de nêêl vu nambe, “Le va timu naahen, ganaah-ambe gambu gate va pin na be hil baanggo, de gambu mone na vu hil sen dativak in va yuuh amêê-to in mem gale gako nôôn nivasa vu baandoni, tonde ganaam taamuyin sa.” ");
INSERT INTO mmo_vpl VALUES ("MK10_22","071_10_22","MRK","10","22","22","Hango vakasin-anju tombe me luus voon de laah osin lopayo nimeen, in yite kupak ngeeyaata nando. ");
INSERT INTO mmo_vpl VALUES ("MK10_23","071_10_23","MRK","10","23","23","+ o 10:23 Mak 4:19; 1Ti 6:17*Tombe Yesu me hako hôôk yite maanggêêm-aso, le mem nêêl vu sil nambe, “Hil sen silate va ngeeyaataa-to ond le lanôôhin in nambe landukana gaving Anutu-te hil.” ");
INSERT INTO mmo_vpl VALUES ("MK10_24","071_10_24","MRK","10","24","24","Tombe yite maanggêêm-aso lavindis in vakasin-anju, le Yesu nêêl vu sil yesin laah nambe, “Noongg-aso-e, omaahonôôn le lanôôhin in landukana gaving Anutu-te hil. ");
INSERT INTO mmo_vpl VALUES ("MK10_25","071_10_25","MRK","10","25","25","“Bik kamel ti me-lohvu nambe dukana lulak vuun e, le nôôhin, de hil sen silate va ngeeyaataa-to, ond yik me-lalohvu nambe landukana gaving Anutu-te hil e, le lanôôhin lôôt.” ");
INSERT INTO mmo_vpl VALUES ("MK10_26","071_10_26","MRK","10","26","26","Tombe lavindis bopaata lôôt-ande lanêêl nambe, “Om omaaho lati lohvu nambe mando metumin danggata?” ");
INSERT INTO mmo_vpl VALUES ("MK10_27","071_10_27","MRK","10","27","27","+ o 10:27 Iyop 42:2; Mak 14:36*Tombe Yesu me la vu sil-ande nêêl nambe, “Omaahonôôn-ame lalohvu va nambêênjo le, lemu Anutu lohvu. Anutu timu yoo lohvu biing va pin.” ");
INSERT INTO mmo_vpl VALUES ("MK10_28","071_10_28","MRK","10","28","28","Tombe Pita nêêl vu nambe, “Gangge, hey-anjo ond hey havuuh heyate va pin la de hey navu taamuyin hong.” ");
INSERT INTO mmo_vpl VALUES ("MK10_29","071_10_29","MRK","10","29","29","Tombe Yesu nêêl nambe, “Sa naanêêl keen vu ham naambe omaaho ti sen havuuh yite bayêên, me halindin, me vangaandin, me tangganaan ayuuh mangganaan, me noondin, me ngaanggis in sa haalengg osin sa banyengg anivasaa-to, ");
INSERT INTO mmo_vpl VALUES ("MK10_30","071_10_30","MRK","10","30","30","ond le gako bayêên-ambe halindin osin vangaandin, de taandin-ambe noondin osin ngaanggis ngeeyaata dukanaah vu voon-anjo, lemu hil e lambiing nindanjeen vu yi gaving, tonde vu busin taamusin ond le mando metumin danggata osin danggata. ");
INSERT INTO mmo_vpl VALUES ("MK10_31","071_10_31","MRK","10","31","31","+ o 10:31 Mat 20:16; Luk 13:30*De hil sen lamunggin-ato ond ngeeyaata le lanaah taamu, de hil sen davu taamuu-to ond ngeeyaata le lana daamunggin.” ");
INSERT INTO mmo_vpl VALUES ("MK10_32","071_10_32","MRK","10","32","32","Yesu having yite maanggêêm-aso be lalu-lala in lana Yelusalem. Yesu munggin nalu tombe maanggêêm-aso davu taamuyin yi osin nahand nalak, de hil sen davu taamuyin sil-ato layêênin. Tonde Yesu supin maanggêêm nomaayuuh-ambe laam yuuh-ato yesin, be nêêl va sen navu naatovu yii-to vu sil nambe, ");
INSERT INTO mmo_vpl VALUES ("MK10_33","071_10_33","MRK","10","33","33","+ o 10:33-34 Mak 8:31; 9:31*“Ham gango le, yiiy navu ana balup Yelusalem atombe hil davu lambu Omaahonôôn Noow dukana kul vaha sen datung salivangin-ato silate yêêv-aso osin tanasin dangga-so namand, be daanêêl naambe lanyiis-ambe jimb, de lambu yi dukana hil vaalu sen sil-ame Yudaa-to namand ");
INSERT INTO mmo_vpl VALUES ("MK10_34","071_10_34","MRK","10","34","34","be sil pale yi de kasuv jak, de gaveek yi, de lanyiis-ambe jimb, tonde busin naatu yaal e mem kandi jak jesin naah.” ");
INSERT INTO mmo_vpl VALUES ("MK10_35","071_10_35","MRK","10","35","35","Sebedi noow Jems ayuuh Jon lala vu Yesu be yuuh lanêêl vu nambe, “Kaputung-e, haay aawiingin nambe kataangg hong in vakasin ti.” ");
INSERT INTO mmo_vpl VALUES ("MK10_36","071_10_36","MRK","10","36","36","Tombe lingin yuuh nambe, “Mawiingin nambe kataangg sa in vakasin vaati?” ");
INSERT INTO mmo_vpl VALUES ("MK10_37","071_10_37","MRK","10","37","37","Tombe yuuh lanêêl vu nambe, “Ond haay kataangg hong in taamusin omando nivasa osin ohaalem bopaataa-to, ond lohvu nambe gambiing-ambe haay naatu gate yêêv bop yuuh in haay ango mando onamam vasa, de ango mando onamam kêênj gaving hong a?” ");
INSERT INTO mmo_vpl VALUES ("MK10_38","071_10_38","MRK","10","38","38","+ o 10:38 Mak 14:36; Luk 12:50*Le Yesu nêêl vu yuuh nambe, “Va sen muuh navu kataangg-anja ond muuh doosin dangga. Kap nimeen-ate sen sa navu naanum hôôk-anjo, ond malohvu nambe naanum hôôk a? Me malohvu manjipis bel naambe sen sa navu aanjipis a?” ");
INSERT INTO mmo_vpl VALUES ("MK10_39","071_10_39","MRK","10","39","39","+ o 10:39 Sin 12:2; Taato 1:9*Le yuuh lanêêl vu nambe, “De. Haay aalohvu.” Tombe Yesu nêêl vu yuuh nambe, “Nimeen sen sa navu baakuu-to ond male baaku, de nivaane sen sa navu gakôô-to ond male gako, ");
INSERT INTO mmo_vpl VALUES ("MK10_40","071_10_40","MRK","10","40","40","lemu vakasin sen manêêl nambe muuh naatu yêêv-ambe muuh mando sa namangg vasa osin sa namangg kêênj gaving saa-to, ond same sate va in nambe sa naanêêl e, nganjo hil sen Anutu samu taaku vu sil-ato, ond sil e mando jak.” ");
INSERT INTO mmo_vpl VALUES ("MK10_41","071_10_41","MRK","10","41","41","Maanggêêm nomaayuuh-ato langoyin vakasin-anju tombe sil alondpayo nipaya vu Jems ayuuh Jon, ");
INSERT INTO mmo_vpl VALUES ("MK10_42","071_10_42","MRK","10","42","42","+ o 10:42 Luk 22:25-26*tombe Yesu teey sil lala vu yi be nêêl vu sil nambe, “Ham alak ni nambe hil vaalu-te yêêv sen danggin sil-ato, ond danêêl vakasin osin niwêêk-ambe daanggôôl silate hil, de silate himbop oo danggin sil niwêêk lôôt, ");
INSERT INTO mmo_vpl VALUES ("MK10_43","071_10_43","MRK","10","43","43","+ o 10:43 Mat 23:11; Mak 9:35*lemu ham ond ham-ame ambiing naambêênju le. Nganjo ham ti wiingin nambe naatu bop, ond yoo biing va naambe sen yi omaaho malis ti in dôôvu ham pin. ");
INSERT INTO mmo_vpl VALUES ("MK10_44","071_10_44","MRK","10","44","44","De omaaho ti wiingin nambe naatu hamate lukook-ambe naamunggin, ond yoo naatu ham pin-ate hil kul malis amu. ");
INSERT INTO mmo_vpl VALUES ("MK10_45","071_10_45","MRK","10","45","45","+ o 10:45 1Ti 2:5-6*In Omaahonôôn Noow-ame laam in nambe omaahonôôn lambiing kul vu yi le, nganjo laam in nambe biing kul vu omaahonôôn osin jimb in baanggo omaahonôôn ngeeyaata naah.” ");
INSERT INTO mmo_vpl VALUES ("MK10_46","071_10_46","MRK","10","46","46","Lung atonde Yesu having yite maanggêêm-aso be lala lato bayêên Yeliko be lala, tombe hil ngeeyaata lala taamuyin sil. Tombe Timai noow Batimai mekanu be nando hôôk mop nanyendangga in mokataangg hil in va. ");
INSERT INTO mmo_vpl VALUES ("MK10_47","071_10_47","MRK","10","47","47","+ o 10:47 Mat 9:27; 15:22*Le sim hango banye nambe Yesu Nasaalet hato, tombe teey la vu nambe, “Yesu, hong sen gate danggakook neep vu Devit-ato, gakam pasiv in sa.” ");
INSERT INTO mmo_vpl VALUES ("MK10_48","071_10_48","MRK","10","48","48","Tombe hil ngeeyaata lanêêl yi nambe, “Olavam nama.” Le ma de teey bopaata lôôt nambe, “Hong sen gate danggakook neep vu Devit-ato, gakam pasiv in sa.” ");
INSERT INTO mmo_vpl VALUES ("MK10_49","071_10_49","MRK","10","49","49","Tombe Yesu naale be nêêl vu sil nambe, “Ham naateey naam.” Om lateey la vu omaaho mekanuu-to be lanêêl vu nambe, “Galompayo niwêêk jak, okandi in Yesu teey hong.” ");
INSERT INTO mmo_vpl VALUES ("MK10_50","071_10_50","MRK","10","50","50","Tombe omaahôô-to haate yite tôômb la de kandi pavis-ambe la vu Yesu, ");
INSERT INTO mmo_vpl VALUES ("MK10_51","071_10_51","MRK","10","51","51","tombe Yesu lingin yi nambe, “De gawiingin nambe saambiing vaati vu hong?” Le mekanu nêêl vu nambe, “Omaaho Bop, gambiing-ambe sa mengg naatum.” ");
INSERT INTO mmo_vpl VALUES ("MK10_52","071_10_52","MRK","10","52","52","+ o 10:52 Mak 5:34*Tombe Yesu nêêl vu yi nambe, “Ganaah, in gawii-having keen om gamem anivasa lak.” Tombe yik me tum pavis-ambe mosapa Yesu loh mopaatôôv. ");
INSERT INTO mmo_vpl VALUES ("MK11_1","071_11_1","MRK","11","1","1","Sil lalup ngaaho vu bayêên Betpaasi yuuh Betaani vu kandu Oliv, in nambe daatok na Yelusalem, le mem Yesu wiing yite maanggêêm yuuh nambe yuuh daamunggin-ambe lana. ");
INSERT INTO mmo_vpl VALUES ("MK11_2","071_11_2","MRK","11","2","2","Tombe nêêl vu yuuh nambe, “Mana be mandukana bayêên-anju ond male angge pavis naambe sil talu donggi noow ti naale, omaahonôôn-ame dalak bôôy e, ond muuh kavaayin-ambe muuh gako be manom. ");
INSERT INTO mmo_vpl VALUES ("MK11_3","071_11_3","MRK","11","3","3","De omaaho ti jingin muuh naambe, ‘Muuh nawiing vaatii-ja?’ ond muuh naanêêl vu naambe, ‘Omaaho Bop wiingin nambe biing kul ti jak pavis e mem gako nom.’” ");
INSERT INTO mmo_vpl VALUES ("MK11_4","071_11_4","MRK","11","4","4","Tombe yuuh lala lalup-ambe yuuh layi donggi noow ti naale voon, sil talu vatinin vinavi, tombe yuuh kavaayin. ");
INSERT INTO mmo_vpl VALUES ("MK11_5","071_11_5","MRK","11","5","5","Tombe hil sen daalêê-juuto lanêêl vu yuuh nambe, “Muuh navu kavaayin donggi noow-anja in mambiing vaati vu?” ");
INSERT INTO mmo_vpl VALUES ("MK11_6","071_11_6","MRK","11","6","6","Le yuuh lanêêl vu sil nambe sen Yesu nêêl-ato, tombe laliinggis nambe yuuh gako donggi be lana. ");
INSERT INTO mmo_vpl VALUES ("MK11_7","071_11_7","MRK","11","7","7","Om yuuh lako donggi noow laah hato vu Yesu, tombe yuuh lakaah lolop-ambe lavaah lakala donggi dami, le mem Yesu lakando be la. ");
INSERT INTO mmo_vpl VALUES ("MK11_8","071_11_8","MRK","11","8","8","Tonde hil ngeeyaata lakaah silate lolop-ambe lavaah neep mopaatôôv, de vaalu lasap haah nama osin lis-ambe lambe neep mop, ");
INSERT INTO mmo_vpl VALUES ("MK11_9","071_11_9","MRK","11","9","9","+ o 11:9 Saam 118:25-26*tombe hil vaalu lamunggin, de vaalu taamu be sil pin daakôôhin nambe, “Ham-o, yiiy gako Anutu haale jak. Anutu biing samu samu vu omaahôô-ju in laam ak Omaaho Bop haale. ");
INSERT INTO mmo_vpl VALUES ("MK11_10","071_11_10","MRK","11","10","10","Anutu biing samu samu vu yi in laam in ganggin yiiy naambe sen yate himbop Devit nanggin yate hil bôôy-ato. Yiiy gako Anutu haale jak nanjip baandoni.” ");
INSERT INTO mmo_vpl VALUES ("MK11_11","071_11_11","MRK","11","11","11","Tonde Yesu tok la Yelusalem-ambe lukala Anutu-te dumb bop alo be yi va pin lung la, le mem soosin hôôk om giiy yite maanggêêm nomaayuuh-ambe laam yuuh-ato be sil lala Betaani. ");
INSERT INTO mmo_vpl VALUES ("MK11_12","071_11_12","MRK","11","12","12","Sil kandi vu Betaani hôôk samiinaanôôn-ambe daahen dalaam, tonde Yesu yimb ahe. ");
INSERT INTO mmo_vpl VALUES ("MK11_13","071_11_13","MRK","11","13","13","+ o 11:13 Luk 13:6*Tombe me la yi haah bangguk ti, ond lis bambu bopaata lôôt naale dinaandiin, om la ngaaho be yi nambe nôôn heey naale ond ja, le ma de lis malis amu, in yite busin sen nyiis nôôn-ato naahen. ");
INSERT INTO mmo_vpl VALUES ("MK11_14","071_11_14","MRK","11","14","14","+ o 11:14 Mak 11:20*Tombe nêêl vu haah nambe, “Game ganyiis nôôn jesin naah-ambe hil lanja le, nama lôôt.” De yite maanggêêm-aso daale dango. ");
INSERT INTO mmo_vpl VALUES ("MK11_15","071_11_15","MRK","11","15","15","Sil lala lalup Yelusalem atombe Yesu lukala Anutu-te dumb bop alo be hatiiy hil sen daanggo va salivangin-ate hôôk dumb alopayôô-to be lala voon, tonde hil sen davu Yuda osin Lom-ate mone nyevaha-vahaan hôôk yii-to, having hil sen daanggo manak tumbaliiy in hil gatung naatu salivangin-ato, ond kayovakin silate tavol ayuuh sia, ");
INSERT INTO mmo_vpl VALUES ("MK11_16","071_11_16","MRK","11","16","16","de nêêlin nambe omaaho ti me-gako va be noh dumb alo jesin naah e. ");
INSERT INTO mmo_vpl VALUES ("MK11_17","071_11_17","MRK","11","17","17","+ o 11:17 Ais 56:7; Jer 7:11*Tombe nêêl-ambe tatekin vu sil nambe, “Anutu-te vakasin sen sil kaavu neep hôôk kaapiyaa-to ond nêêl nambe, ‘Sate bayêên ond le daanêêl naambe hil pin-ate bayêên lohakin,’ le ma de ham awiing-ambe tu hil hôôndak-ate bayêên sen dahôôpis hôôk-ato.” ");
INSERT INTO mmo_vpl VALUES ("MK11_18","071_11_18","MRK","11","18","18","+ o 11:18 Mak 14:1; Luk 22:2*Tombe kul vaha sen datung salivangin-ato silate yêêv-aso osin tanasin dangga-so langoyin-ambe davu salo mop in nambe lanyiis Yesu be jimb, lemu layêênin yi, in hil pin lavindis in yite tanasin. ");
INSERT INTO mmo_vpl VALUES ("MK11_19","071_11_19","MRK","11","19","19","De soosin hôôk atombe Yesu having yite maanggêêm-aso lavuuh bayêên bop-ande lalaah. ");
INSERT INTO mmo_vpl VALUES ("MK11_20","071_11_20","MRK","11","20","20","+ o 11:20 Mak 11:14*Samiinaanôôn atombe laloh vahand yesin laah, tombe sim layi haah bangguk-ato bambôôv valok-ate. ");
INSERT INTO mmo_vpl VALUES ("MK11_21","071_11_21","MRK","11","21","21","Om Pita ka vu vakasin vasêên-ato be nêêl nambe, “Kaputung-e, gangge ni. Bangguk sen otalôôt-ato ond bambôôv la valok-ate.” ");
INSERT INTO mmo_vpl VALUES ("MK11_22","071_11_22","MRK","11","22","22","Tombe Yesu nêêl vu sil nambe, “Yik ham ambiing gaving Anutu. ");
INSERT INTO mmo_vpl VALUES ("MK11_23","071_11_23","MRK","11","23","23","+ o 11:23 Mat 17:20; Luk 17:6*Sa naanêêl keen vu ham naambe omaaho ti nambe naanêêl vu kanduu-jo naambe ‘Okandi jak-ambe gandukana lôôy,’ le me-naanêêl osin ka yu-yuuh e, yoo biing gaving keen naambe yite vakasin e nôôn jak, ond mem le nôôn jak. ");
INSERT INTO mmo_vpl VALUES ("MK11_24","071_11_24","MRK","11","24","24","+ o 11:24 Mat 7:7*Om sa naanêêl vu ham naambe va pin sen ham navu kataangg vu Anutu hôôk lohakin-ato, ond ham ambiing gaving naambe ham hako nôôn lung la ond ham e gako nôôn. ");
INSERT INTO mmo_vpl VALUES ("MK11_25","071_11_25","MRK","11","25","25","+ o 11:25 Mat 5:23; 6:14-15*Ham awiingin nambe anohak, lemu hamate vakasin ti neep vu omaaho ti, ond ham kawiiy na le, in Mom sen nando baandonii-to ond le kawiiy hamate nipaya na naambêênja. ");
INSERT INTO mmo_vpl VALUES ("MK11_26","071_11_26","MRK","11","26","26","Le naambe ham-ame kawiiy omaaho ango-te nipaya na le, ond Mom sen nando baandonii-to me-le kawiiy hamate nipaya na le, malis.” ");
INSERT INTO mmo_vpl VALUES ("MK11_27","071_11_27","MRK","11","27","27","Lala lalup Yelusalem yesin laah tombe Yesu la hatup hôôk Anutu-te dumb bop alopayo. Tombe kul vaha sen datung salivangin-ato silate yêêv-aso osin tanasin dangga-so be himbop-aso lala vu yi, ");
INSERT INTO mmo_vpl VALUES ("MK11_28","071_11_28","MRK","11","28","28","tombe lalingin yi nambe, “Lati nêêl-ambe galaam nawiing va pin-anjo? Onawiing kul-anjo lak lati haale?” ");
INSERT INTO mmo_vpl VALUES ("MK11_29","071_11_29","MRK","11","29","29","Tombe Yesu nêêl laah vu sil nambe, “Om saanjingin ham in vakasin ti be ham naanêêl nom vu sa le, mem sale naanêêl omaaho sen sa naawiing kul lak haalêê-to nos vu ham. ");
INSERT INTO mmo_vpl VALUES ("MK11_30","071_11_30","MRK","11","30","30","De Jon nalipis hil-ato ond lati nêêl? Anutu nêêl, me omaahonôôn yoo lanêêl? Ham naanêêl vu sa le.” ");
INSERT INTO mmo_vpl VALUES ("MK11_31","071_11_31","MRK","11","31","31","Tombe sil oo lakaas in nambe, “Yiiy naanêêl naambe Anutu nêêl, ond le naanêêl vu yiiy naambe, ‘Le nambe tana ham-ame awii-having yi le?’” ");
INSERT INTO mmo_vpl VALUES ("MK11_32","071_11_32","MRK","11","32","32","Tombe lawiingin daanêêl naambe omaahonôôn lanêêl-ambe Jon nalipis hil, lemu dayêênin hil, in omaahonôôn pin lako Jon ak nambe yi omaaho sen nanêêl Anutu-te vakasin langaah-ato keen. ");
INSERT INTO mmo_vpl VALUES ("MK11_33","071_11_33","MRK","11","33","33","Om lanêêl laah vu Yesu nambe, “Bey, hey doosin.” Tombe Yesu nêêl vu sil nambe, “Om same le naanêêl omaaho sen sa naawiing kul lak haalêê-to vu ham e.” ");
INSERT INTO mmo_vpl VALUES ("MK12_1","071_12_1","MRK","12","1","1","+ o 12:1 Ais 5:1-2*Yesu nêêl vakasin pakwesin-anjo vu sil nambe, “Omaaho ti vaalôôh kul wain ti be vaaku ayak hilin de haav taaku sen davu samu wain-aanôôn aniluk hôôk-ato, tonde haav bayêên vaha salak ti in nambe hil baale hôôk-ambe mend in kul wain-anju, tombe mem vu kul-anju lukala hil vaalu namand-ambe sil danggin, tonde yik la taaku dinaandiin lôôt. ");
INSERT INTO mmo_vpl VALUES ("MK12_2","071_12_2","MRK","12","2","2","De wain linj-ambe yiis nôôn-ambe suuh, tombe kul mangganaan wiing yite hil kul ti la vu hil sen danggin kul wain-ato in nambe gako yite nôôn vaalu. ");
INSERT INTO mmo_vpl VALUES ("MK12_3","071_12_3","MRK","12","3","3","Le ma de hil sen danggin kul-ato lalôôh-ambe laveek, tonde latiiy laah-ambe la nama malis. ");
INSERT INTO mmo_vpl VALUES ("MK12_4","071_12_4","MRK","12","4","4","Tonde kul mangganaan wiing omaaho ango laah, le ma de layiis lukala lukook de lawiing nindanjeen vu. ");
INSERT INTO mmo_vpl VALUES ("MK12_5","071_12_5","MRK","12","5","5","Tombe yik wiing omaaho ti laah yesin, le ma de layiis-ambe yimb, de lawiing nambêênju vu yite hil ngeeyaata having, laveek vaalu, de layiis vaalu be layimb. ");
INSERT INTO mmo_vpl VALUES ("MK12_6","071_12_6","MRK","12","6","6","+ o 12:6 Mat 3:17*De kul mangganaan ayuuh noow timu sen ahe having yii-to yuuh oo dando, om wiing-ambe la vu sil in ka vu nambe, ‘Manyinjo sa noongg, om sil e lanjêênin yi.’ ");
INSERT INTO mmo_vpl VALUES ("MK12_7","071_12_7","MRK","12","7","7","Lemu hil sen danggin kul wain-ato lanêêl vu sil nambe, ‘Omaaho sen-anju le gako mangganaan-ate va pin, om ham-o, yaanyiis-ambe jimb-ande kul-anjo naatu yate va.’ ");
INSERT INTO mmo_vpl VALUES ("MK12_8","071_12_8","MRK","12","8","8","+ o 12:8 Hiblu 13:12*Om lalôôh-ambe layiis-ambe yimb, le mem laate la voon. ");
INSERT INTO mmo_vpl VALUES ("MK12_9","071_12_9","MRK","12","9","9","Om kul wain mangganaan e biing vaati? Le balup-ambe nyiis hil sen danggin kul wain-anjuuto de bu kul-anju be hil vaalu ganggin. ");
INSERT INTO mmo_vpl VALUES ("MK12_10","071_12_10","MRK","12","10","10","+ o 12:10-11 Saam 118:22-23; Sin 4:11*Mak ham-ame asevin Anutu-te vakasin-anjo mava? Nambe, ‘Tatuuh ti sen hil kul-aso nind baya nambe me-landaav bayêên ak e, ond gêên tu bayêên ahelasu-te kook aniwêêk. ");
INSERT INTO mmo_vpl VALUES ("MK12_11","071_12_11","MRK","12","11","11","Omaaho Bop wiing vaa-jo be yaahe nambe yoo nivasa nôôn.’” ");
INSERT INTO mmo_vpl VALUES ("MK12_12","071_12_12","MRK","12","12","12","Yesu nêêl lung atonde yêêv-aso lalak ni nambe nêêl vakasin pakwesin-anjo lak sil, om lawiingin nambe lanôôh yi, le ma de layêênin hil ngeeyaataa-ju, om lavuuh yi de lala. ");
INSERT INTO mmo_vpl VALUES ("MK12_13","071_12_13","MRK","12","13","13","+ o 12:13 Mak 3:6*Lawiing Palisai vaalu laving Helot-ate hil heey lala vu Yesu, be sil sahi yi in nambe naanêêl vakasin ti na paya ond daanêêl lak me bulôôt. ");
INSERT INTO mmo_vpl VALUES ("MK12_14","071_12_14","MRK","12","14","14","Om lalaam-ambe lanêêl vu yi nambe, “Kaputung, hey alak ganim nambe hong omaaho sen onanêêl vakasin keen. Game nayêênin omaaho ti nambe haale bop me haale pasiv e, malis. Yik goo navu tatekin Anutu-te mop keen-ato langaah, om onaanêêl vu hey e. Lohvu nambe yiiy gaate taakis na vu Lom-ate yêêv bop Sisa me malis? ");
INSERT INTO mmo_vpl VALUES ("MK12_15","071_12_15","MRK","12","15","15","Yale gaate, me jip?” Le Yesu lak silate vakasin tatuhin-anju ni, om nêêl vu sil nambe, “Nambe vaati sen ham nawiingin nambe sahi saa-jo? Ham ambu mone ti naam saangge le.” ");
INSERT INTO mmo_vpl VALUES ("MK12_16","071_12_16","MRK","12","16","16","Om lavu mone ti la vu be yi, le mem nêêl vu sil nambe, “Lati kanu osin haale lakaneep-anjo?” Le lanêêl vu nambe, “Sisa.” ");
INSERT INTO mmo_vpl VALUES ("MK12_17","071_12_17","MRK","12","17","17","+ o 12:17 Lom 13:7*Tombe Yesu nêêl vu sil nambe, “Om ham ambu Sisa-te va vu Sisa, de Anutu-te va vu Anutu.” Tombe lavindis in yite vakasin. ");
INSERT INTO mmo_vpl VALUES ("MK12_18","071_12_18","MRK","12","18","18","+ o 12:18 Sin 23:8*Hil heey danêêl nambe omaahonôôn yimbin-ame le kandi jak naah e, ond danêêl hil-anju nambe hil Sadusi, ond Sadusii-ju lala vu Yesu be lanêêl nambe, ");
INSERT INTO mmo_vpl VALUES ("MK12_19","071_12_19","MRK","12","19","19","+ o 12:19 Diu 25:5*“Kaputung, Mose kaavu tanasin in nambe yiiy sapa dôôk, ond kaavu ti nambe omaaho ti yimb-ande havuuh vane nando de noow ma, ond omaahôô-ju hali le gako vane vehaahôôv-anju in yuuh gako unoopasiv dukanaah mangganaan sen yimb-ato ahembaan. ");
INSERT INTO mmo_vpl VALUES ("MK12_20","071_12_20","MRK","12","20","20","Om hil o halindin namaavaalu be vindak yuuh dando, tombe sil halindin tuk hako vêêh ti be yimb de noow ma, ");
INSERT INTO mmo_vpl VALUES ("MK12_21","071_12_21","MRK","12","21","21","om sil halindin miin hako vehaahôôv-anju tombe yimb de noow ma, tombe yik gwey wiing nambêênju va timu. ");
INSERT INTO mmo_vpl VALUES ("MK12_22","071_12_22","MRK","12","22","22","Sil o halindin namaavaalu be vindak yuuh sen lako vêêh timuu-juuto layimb pin, de sil noondin ma, tonde vehaahôôv yimb lakaneep ahus. ");
INSERT INTO mmo_vpl VALUES ("MK12_23","071_12_23","MRK","12","23","23","Om vu busin sen omaahonôôn yimbin kandi jak naah-ato, ond vehaahôôv-anju le naatu sil ti tana vane, in sil namaavaalu be vindak yuuh lako vêêh timuu-ju lung laa-to.” ");
INSERT INTO mmo_vpl VALUES ("MK12_24","071_12_24","MRK","12","24","24","Le sim Yesu nêêl vu sil nambe, “Ôôye, ham doosin Anutu-te niwêêk osin yite vakasin sen lukaneep kaapiyaa-to ondeey ham nakaas paya. ");
INSERT INTO mmo_vpl VALUES ("MK12_25","071_12_25","MRK","12","25","25","Vu busin sen omaahonôôn yimbin kandi jak naah-ato, ond moow ayuuh vêêh-ame le gako sil naah e, le nama, sil e mando nohvu angela-so sen dando baandonii-to. ");
INSERT INTO mmo_vpl VALUES ("MK12_26","071_12_26","MRK","12","26","26","+ o 12:26 Eks 3:2,6*Vakasin lak omaahonôôn yimbin kandi jak naah-ato ond ham-ame asevin sen Mose kaavuu-to mava? Vakasin daka lak haah aniyin sen kin natum hôôk-ato, ond Anutu nêêl vu Mose nambe, ‘Abalaam ayuuh Isak-ande Yaakop, yaalate Anutu sa.’ ");
INSERT INTO mmo_vpl VALUES ("MK12_27","071_12_27","MRK","12","27","27","Le hamambe yaal layimb om yaal lala valok-ate? Malis, in Anutu ond hil metumin vu voon osin hil pin sen layimb-ambe lala dando metumin-ato silate Anutu yi. Ham nakaas paya lôôt.” ");
INSERT INTO mmo_vpl VALUES ("MK12_28","071_12_28","MRK","12","28","28","Tanasin dangga-so ti laam-ambe hangoyin-ande dakaas lôôt, tombe hangoyin vakasin sen Yesu nêêl laah vu sil-ato be nivasa lôôt, om lingin Yesu nambe, “Tanasin ti tana savok tanasin pin?” ");
INSERT INTO mmo_vpl VALUES ("MK12_29","071_12_29","MRK","12","29","29","+ o 12:29 Diu 6:4-5*Le Yesu nêêl laah vu yi nambe, “Tanasin danggakook ti nyendoos-ato ond savok tanasin pin, nambe ‘Ham Islel, ham gango. Omaaho Bop sen yate Anutuu-to ond yi Omaaho Bop timuu-ju, ");
INSERT INTO mmo_vpl VALUES ("MK12_30","071_12_30","MRK","12","30","30","om ham ahem gaving Omaaho Bop hamate Anutu osin ham alompayo doos, be ham kanum doos, be ham akam na doos osin ham animwêêk na doos vu yi timu.’ ");
INSERT INTO mmo_vpl VALUES ("MK12_31","071_12_31","MRK","12","31","31","+ o 12:31 Lev 19:18; Gal 5:14; Lom 13:9; Jem 2:8*De tanasin ango neep nambe, ‘Ham ahem gaving hil sen dando ngaaho vu ham naambe sen ham ahem oo naving ham-ato.’ Tonde tanasin pin ond ti me-kaluuh yuuh-anjo la le.” ");
INSERT INTO mmo_vpl VALUES ("MK12_32","071_12_32","MRK","12","32","32","+ o 12:32 Diu 4:35; Ais 45:21*Tombe tanasin dangga tii-ju nêêl vu nambe, “Kaputung, ganêêl keen nambe Anutu ond yoo timu, de Anutu ango me-nando le. ");
INSERT INTO mmo_vpl VALUES ("MK12_33","071_12_33","MRK","12","33","33","+ o 12:33 Diu 6:5; 1Sml 15:22; Hos 6:6*Om yahengg gaving yi osin yalonggpayo doos, de yakangg sapa yi osin yaninggwêêk doos na vu yi, be yahengg gaving hil sen dando ngaaho vu yiiy naambe sen yahengg oo naving yiiy-ato. Yiiy sapa tanasin yuuh-anjo ond mem kaluuh salivangin sen dasi lak kin nala vu Anutu osin salivangin sen yiiy natung vu Anutuu-to pin.” ");
INSERT INTO mmo_vpl VALUES ("MK12_34","071_12_34","MRK","12","34","34","Yesu hango de nêêl vakasin osin ka nivasa om nêêl vu nambe, “Ngaaho lak in Anutu ganggin hong gaving yite hil.” Tombe sim hil pin layêênin om me-lalingin yi in vakasin heey yesin laah e. ");
INSERT INTO mmo_vpl VALUES ("MK12_35","071_12_35","MRK","12","35","35","Yesu wiing tanasin hôôk Anutu-te dumb bop alo nambe, “Nambe vaati sen hil tanasin dangga-so danêêl omaaho sen Anutu yoo holin yi vulôôt in nambe dôôvu yiiy-ato nambe yite danggakook neep vu Devit? ");
INSERT INTO mmo_vpl VALUES ("MK12_36","071_12_36","MRK","12","36","36","+ o 12:36 Saam 110:1*Le Vavi Vaambuung vêêl Devit alu lak-ambe nêêl nambe, ‘Omaaho Bop nêêl vu sate Omaaho Bop nambe, “Omando sa namangg vasa, de sale aambiing-ambe hil sen dayi hong payaa-to le langgulis hong vaalu kambi.” ’ ");
INSERT INTO mmo_vpl VALUES ("MK12_37","071_12_37","MRK","12","37","37","+ o 12:37 Luk 19:48*Om sen Devit nêêl omaahôô-ju nambe Omaaho Bop, le nambe vaati sen Omaaho Bop-anju tu Devit-ate hil moos ti?” Tombe hil pin langoyin-ambe londpayo nivasa. ");
INSERT INTO mmo_vpl VALUES ("MK12_38","071_12_38","MRK","12","38","38","Yesu wiing tanasin vu hil nambe, “Ham ganggin ham in tanasin dangga-so, in sil oo lawiingin nambe lanjop lolop dinaandiin-ambe ganjung noh talind in nambe omaahonôôn gako sil jak, ");
INSERT INTO mmo_vpl VALUES ("MK12_39","071_12_39","MRK","12","39","39","osin sil lana mando hil pin amend vu dumb alo, de vanôôn bop ond sil oo mando nalu munggin. ");
INSERT INTO mmo_vpl VALUES ("MK12_40","071_12_40","MRK","12","40","40","Dalakin vehaahôôv-ate bayêên de davun londpayo lak lohakin diin, om nipaya nyevahaan e naatovu sil bopaata lôôt.” ");
INSERT INTO mmo_vpl VALUES ("MK12_41","071_12_41","MRK","12","41","41","+ o 12:41 2King 12:9*Yesu nando ngaaho vu taaku sen datung salivangin-ato be monayi hil dalup-ambe datung salivangin, ond yi de kupak dangga-so ngeeyaata daate mone bop. ");
INSERT INTO mmo_vpl VALUES ("MK12_42","071_12_42","MRK","12","42","42","Tombe yi vehaahôôv ti, yinêên va ma, ond valup-ambe haate yite mone noow daka yuuh, ");
INSERT INTO mmo_vpl VALUES ("MK12_43","071_12_43","MRK","12","43","43","+ o 12:43 2Ko 8:12*om teey yite maanggêêm-aso lalaam-ambe nêêl vu sil nambe, “Sa naanêêl keen vu ham naambe vehaahôôv-anju ond yinêên va ma, lemu hatung salivangin-anju kaluuh omaahonôôn pin, ");
INSERT INTO mmo_vpl VALUES ("MK12_44","071_12_44","MRK","12","44","44","in sil pin-anju va ngeeyaata nando, le lako pasivdaka-daka be latung salivangin ak, de vehaahôôv-anju yinêên va ma, lemu haate yite mone pin lukala tu salivangin, de ti me-nando vu yi in baanggo vanôôn jak-ambe ja le.” ");
INSERT INTO mmo_vpl VALUES ("MK13_1","071_13_1","MRK","13","1","1","Yesu vu Anutu-te dumb bop alo be lukalaam voon in na, tombe yite maanggêêm ti nêêl vu yi nambe, “Kaputung, gangge ni, lahaav dumb bop-anjo lak tatuuh amengali be nivasa lôôt.” ");
INSERT INTO mmo_vpl VALUES ("MK13_2","071_13_2","MRK","13","2","2","+ o 13:2 Luk 19:44*Le Yesu nêêl laah vu nambe, “Gahe dumb bop-anja, ond tatuuh ango me-le mando jak ango baandoni le, le kawiiy pin-ambe na mando danjeen.” ");
INSERT INTO mmo_vpl VALUES ("MK13_3","071_13_3","MRK","13","3","3","Yesu nando lak kandu lu Oliv de Anutu-te dumb bop neep vaalu, tombe Pita yuuh Jems-ande Jon ayuuh Endru, sil yumbeyuuh-anju yoo lalaam-ambe lalingin yi nambe, ");
INSERT INTO mmo_vpl VALUES ("MK13_4","071_13_4","MRK","13","4","4","“Onaanêêl vu hey e, naangelis e vaa-jo naatok? Yale anjak ni lak vaati naambe vakasin pin navu nôôn jak?” ");
INSERT INTO mmo_vpl VALUES ("MK13_5","071_13_5","MRK","13","5","5","Tombe Yesu nêêl vu sil nambe, “Ham ganggin ham in omaaho ango le tatuhin ham. ");
INSERT INTO mmo_vpl VALUES ("MK13_6","071_13_6","MRK","13","6","6","+ o 13:6 Jon 5:43*Hil ngeeyaata le lanaam-ambe daanêêl sa haalengg ak sil naambe ‘Sa Kalisii-jo,’ de sil e tatuhin omaahonôôn ngeeyaata. ");
INSERT INTO mmo_vpl VALUES ("MK13_7","071_13_7","MRK","13","7","7","De ham e gango ngaamong laam ngaaho daandun, osin ham e gango ngaamong banye vu taaku dinaandiin heey, ond ham-ame naham jak e, in vaa-ju le naam, lemu va pin-ame le jung na pavis e, in busin sen-ato naahen. ");
INSERT INTO mmo_vpl VALUES ("MK13_8","071_13_8","MRK","13","8","8","+ o 13:8 Ais 19:2; 2Kro 15:6*Bayêên bu ango le kandi be lambiing ngaamong vu bayêên bu ngo, de gaaman ango le kandi be biing ngaamong vu gaaman ango, de jemaapi le jêêy osin meep biing omaahonôôn nohvu taaku ti ti, ond va nime-meen pin sen navu naatokak omaahonôôn-ato yite nalu munggin-anja. ");
INSERT INTO mmo_vpl VALUES ("MK13_9","071_13_9","MRK","13","9","9","+ o 13:9 Mat 10:17-20*Lemu ham ganggin ham in sil e lambu ham dukana kaansol-aso namand, be sil e gaveek ham baale dumb alo, de sil balaah ham baale yêêv bop osin lulemak-aso mend in sate hil ham, om ham e naanêêl sa banyengg langaah vu sil. ");
INSERT INTO mmo_vpl VALUES ("MK13_10","071_13_10","MRK","13","10","10","Tombe hil daanêêl banye nivasa be na nohvu taaku pin e. ");
INSERT INTO mmo_vpl VALUES ("MK13_11","071_13_11","MRK","13","11","11","+ o 13:11 Luk 12:11-12* + o 13:11-13 Mat 10:19-22*Tonde lanôôh ham-ambe gako be lana in ham ambiing vakasin, ond ham-ame naham jak pavis e, de ham akam-ame bu naambe, ‘Sale naanêêl vaati?’ Vu busin-anju ond Anutu yoo le bêêl ham alum jak in vakasin-ambe mem ham naanêêl vu sil, in nambe mem ham-ame yoo naanêêl hamate vakasin ti le, ham e naanêêl Vavi Vaambuung lava. ");
INSERT INTO mmo_vpl VALUES ("MK13_12","071_13_12","MRK","13","12","12","Tonde omaahonôôn e lambu halindin dukana hil namand-ambe lanyiis sil-ambe lanjimb, de yik maandin lambiing naambêênju vu noondin. Tonde yik unoopasiv e lanji maandin ayuuh taandin paya be lambu sil dukana hil namand-ambe lanyiis sil-ambe lanjimb. ");
INSERT INTO mmo_vpl VALUES ("MK13_13","071_13_13","MRK","13","13","13","+ o 13:13 Jon 15:18-21*Tonde hil pin e nind baya lôôt in ham in sate hil ham, tombe hil sen sil baale niwêêk lôôt-ambe baaku nimeen pin-ato, ond sil e lana mando metumin gaving Anutu.” ");
INSERT INTO mmo_vpl VALUES ("MK13_14","071_13_14","MRK","13","14","14","+ o 13:14 Dan 9:27; 11:31; 12:11*Omaaho ti nambe naasevin vakasin-anjo ond yoo ka bu nivasa be jak vakasin-anjo dangga ni, naambe “Ham navu angge nipaya dangga sen navu kawiiy vaa-to baale langaah hôôk taaku sen va nipaya me-baan-ato le, om hil sen dando Yudiaa-to dapak-ambe lana mando kandu lu. ");
INSERT INTO mmo_vpl VALUES ("MK13_15","071_13_15","MRK","13","15","15","+ o 13:15 Luk 17:31*De omaaho ti nambe mando lak bayêên alu baandoni, ond me-duus-ambe guli-naah bayêên alo be gako yite vati le. ");
INSERT INTO mmo_vpl VALUES ("MK13_16","071_13_16","MRK","13","16","16","De ti monambiing yite kul ond me-gilin-ambe naah gako yite lolop e. ");
INSERT INTO mmo_vpl VALUES ("MK13_17","071_13_17","MRK","13","17","17","+ o 13:17 Luk 23:29*Dôôk busin-anju ond nimeen e naatovu vêêh-aso sen noondin lukaalêê-to osin vêêh vaalu sen daahen davu sum vu noondin-ato. ");
INSERT INTO mmo_vpl VALUES ("MK13_18","071_13_18","MRK","13","18","18","Om ham anohak naambe vaa-ju me-naatovu ham dôôk busin sen lukaahôômb osin vavi jambaa-to le. ");
INSERT INTO mmo_vpl VALUES ("MK13_19","071_13_19","MRK","13","19","19","+ o 13:19 Dan 12:1; Joel 2:2; Taato 7:14*Vu bôôy sen Anutu hatung va pin nyendoos-ambe tok laam gêên-anjo, ond omaahonôôn-ame laaku nimeen bopaata lôôt e. De vu gêên-anjo ond nimeen bopaata navu naatovu omaahonôôn, tonde vu taamusin ond omaahonôôn-ame le daatovu nimeen ti naambêênjo jesin naah e. ");
INSERT INTO mmo_vpl VALUES ("MK13_20","071_13_20","MRK","13","20","20","Busin sen nimeen naatovu omaahonôôn-ato, ond Omaaho Bop e katôôv vahaan na, le naambe nama, ond omaaho lati lohvu nambe mando metumin? Nganjo ka navu yite hil sen yoo holin sil-ato, om le katôôv busin sen nimeen-anju vahaan na. ");
INSERT INTO mmo_vpl VALUES ("MK13_21","071_13_21","MRK","13","21","21","“Tonde omaaho ango daanêêl vu ham dôôk busin-anju naambe, ‘Ham angge, Kalisi nando nganjo,’ de daanêêl naambe, ‘Ham angge, nando nganju,’ ond ham-ame ambiing gaving e. ");
INSERT INTO mmo_vpl VALUES ("MK13_22","071_13_22","MRK","13","22","22","+ o 13:22 Diu 13:1-3; Taato 13:13*De hil vaalu le lanaam-ambe tatuhin naambe sil Kalisi, tonde vaalu le tatuhin naambe sil Anutu-te hil sen danêêl yite vakasin-ato, de lambiing taahu taahu vaha vaha osin niwêêk, in naambe lohvu ond sil langgilin hil sen Anutu yoo holin sil-ato be lambiing gaving sil. ");
INSERT INTO mmo_vpl VALUES ("MK13_23","071_13_23","MRK","13","23","23","Om ham ganggin ham in vakasin pin sen saanêêl banye vu ham-anjo.” ");
INSERT INTO mmo_vpl VALUES ("MK13_24","071_13_24","MRK","13","24","24","+ o 13:24-25 Ais 13:10; 34:4; Taato 6:12-14; 8:12*“Va nimeen pin-anju jung na le mem taaku mekaalus e mekanu dôôk, de kwaav-ame le naatum e, ");
INSERT INTO mmo_vpl VALUES ("MK13_25","071_13_25","MRK","13","25","25","de matam baandoni naatok osin va niwêêk vu baandoni pin e baale ye-yêêy. ");
INSERT INTO mmo_vpl VALUES ("MK13_26","071_13_26","MRK","13","26","26","+ o 13:26 Taato 1:7*Va sen-anju pin jung na le mem hil e lanji Omaahonôôn Noow naam hôôk bayiimb alo, ond le naam osin niwêêk bopaata gaving nikaapulis. ");
INSERT INTO mmo_vpl VALUES ("MK13_27","071_13_27","MRK","13","27","27","+ o 13:27 Mat 13:41*Tombe le biing yite angela-so lana daasupin hil sen yoo holin sil lak-ambe latu yite hil-ato vu taaku lavuun osin vu taaku nanyendangga vaalu vaalu de vu baandoni pin.” ");
INSERT INTO mmo_vpl VALUES ("MK13_28","071_13_28","MRK","13","28","28","“Ham akam bu mêêl suusin. Ham angge naambe manak pulapul valu-la ond ham anjak ni naambe ngaaho lak in yiiy kape mêêl jakana jok. ");
INSERT INTO mmo_vpl VALUES ("MK13_29","071_13_29","MRK","13","29","29","Nambêênja om ham angge naambe vakasin pin-ato nôôn ak ond ham anjak ni naambe omaahôô-to laam ngaaho lak in navu naatovu ham. ");
INSERT INTO mmo_vpl VALUES ("MK13_30","071_13_30","MRK","13","30","30","De sa naanêêl keenaanôôn vu ham naambe hil sen dando gêên-anjôôto ond me-le lanjimb e, de va pin-anjo le nôôn jak e mem. ");
INSERT INTO mmo_vpl VALUES ("MK13_31","071_13_31","MRK","13","31","31","Yendak osin ngaanggis e na menama, de sate vakasin ond ti me-le na menama le, yoo le nanjip danggata.” ");
INSERT INTO mmo_vpl VALUES ("MK13_32","071_13_32","MRK","13","32","32","+ o 13:32 Sin 1:7*“Lemu busin-anju osin taaku me ond omaaho ti me-lak ni le, angela baandoni doosin, Anutu Noow doosin, Aamangg timu yoo lak ni lung la. ");
INSERT INTO mmo_vpl VALUES ("MK13_33","071_13_33","MRK","13","33","33","+ o 13:33-34 Mat 25:13-14*Om ham ganggin ham-ambe ham oo mando mem naatum, in ham doosin nambe vaa-ju le nôôn jak dôôk busin ti tana. ");
INSERT INTO mmo_vpl VALUES ("MK13_34","071_13_34","MRK","13","34","34","Nambe sen omaaho ti navu gavuuh baan mando de kandi be na taaku dinaandiin ti, tombe nêêl vu yite hil kul vaha-so nambe sil ganggin yite va pin, om hatiiy kul ti ti lohvu sil, tonde nêêl vu ti sen ganggin vinavii-to nambe, ‘Goo baale mem naatum.’ ");
INSERT INTO mmo_vpl VALUES ("MK13_35","071_13_35","MRK","13","35","35","+ o 13:35 Luk 12:36-38*Om yik nambêênja ham oo mando mem naatum in ham doosin nambe bayêên mangganaan e nom gato hôôk soosin me busin lavuun me heendiisin me langaah jak e mem nom gato. ");
INSERT INTO mmo_vpl VALUES ("MK13_36","071_13_36","MRK","13","36","36","Om ham mando mem naatum in le nom gato pavis, ond ji naambe ham-ame nahop la le. ");
INSERT INTO mmo_vpl VALUES ("MK13_37","071_13_37","MRK","13","37","37","Vakasin sen saanêêl laas vu ham-anjaato ond saanêêl vu omaahonôôn pin nambe ham oo mando mem naatum.” ");
INSERT INTO mmo_vpl VALUES ("MK14_1","071_14_1","MRK","14","1","1","+ o 14:1 Mak 11:18; Hiblu 11:28*Busin laam ngaaho lak in nambe busin yuuh gaving le mem hil daasupin lanaam-ambe lanji busin bop busin haluusin sen Anutu haluuh hil Islel hôôk vu Ijip bôôy-ato. Busin-anju ond hil datongin balet lemu me-datung yis nalukala le, nganjo daya balet amu. De kul vaha sen datung salivangin-ato silate yêêv-aso osin tanasin dangga-so davu salo mop in nambe lanôôh Yesu kaatokin be lanyiis-ambe jimb, ");
INSERT INTO mmo_vpl VALUES ("MK14_2","071_14_2","MRK","14","2","2","lemu lanêêl nambe, “Yame aanôôh dôôk busin bop e, in mak hil ngeeyaata londpayo le naakund.” ");
INSERT INTO mmo_vpl VALUES ("MK14_3","071_14_3","MRK","14","3","3","+ o 14:3 Luk 7:37-38*Yesu lakala omaaho ti baan vu Betaani, omaahôô-ju haale nambe Simon, ond payêês anipaya lak yi. Dando mondaya vanôôn, tonde vêêh ti hako bel galovasa hôôk buayo tatuuh ti, daanggo lak mone bopaata lôôt, ond la hato be kaatuuh buayo avi de kaasêêh bel galovasaa-ju lak Yesu lukook. ");
INSERT INTO mmo_vpl VALUES ("MK14_4","071_14_4","MRK","14","4","4","Tombe hil sen dando having-ato ond vaalu londpayo nipaya vu, om yoo lanêêl vu sil nambe, “Vêêh-anju nawiliyak bel-anjo in?” ");
INSERT INTO mmo_vpl VALUES ("MK14_5","071_14_5","MRK","14","5","5","Tombe lanêêl vêêh-anjo nambe, “Bel galovasaa-jo yaambu be omaaho ngo baanggo jak mone bopaata nohvu 300 kina, de monêê-jo yaambu vu hil sen silanêênd va maa-to ond mem nivasa.” ");
INSERT INTO mmo_vpl VALUES ("MK14_6","071_14_6","MRK","14","6","6","Le Yesu nêêl nambe, “Jipin vêêh-anju, ham-ame naanêêl yi le, manyinjo samu sa nivasa lôôt. ");
INSERT INTO mmo_vpl VALUES ("MK14_7","071_14_7","MRK","14","7","7","+ o 14:7 Diu 15:11*Hil sen dativak in va yuuh amêê-to ond sil e mando gaving ham nohvu busin pin, om ham akam bu naambe ham andôôvu sil ond ham oote va, nganjo sak same le mando gaving ham nohvu busin pin e. ");
INSERT INTO mmo_vpl VALUES ("MK14_8","071_14_8","MRK","14","8","8","+ o 14:8 Jon 19:40*Vêêh-anjo wiing lohvu lopayo be kaasêêh bel galovasa lak sa ningg naavii-jo, ond taahu sanêêngg busin kanu sen saanggimb-ambe landaav saa-to. ");
INSERT INTO mmo_vpl VALUES ("MK14_9","071_14_9","MRK","14","9","9","Sa naanêêl keen vu ham naambe vu taaku pin sen hil danêêl banye nivasa langaah-ato, ond va sen vêêh wiing-anjo le daanêêl gaving, in hil akand bu yi.” ");
INSERT INTO mmo_vpl VALUES ("MK14_10","071_14_10","MRK","14","10","10","Sil nomaayuuh-ambe laam yuuh-ato ti Yudas Iskaliot la vu kul vaha sen datung salivangin-ato silate yêêv-aso in nambe bu Yesu dukana sil namand. ");
INSERT INTO mmo_vpl VALUES ("MK14_11","071_14_11","MRK","14","11","11","Sil langoyin vakasin sen Yudas nêêl-ato be ahend anivasa lôôt, tombe lanêêl nambe le lambu mone vu yi, om Yudas salo mop in nambe bu Yesu dukana sil namand. ");
INSERT INTO mmo_vpl VALUES ("MK14_12","071_14_12","MRK","14","12","12","+ o 14:12 Eks 12:6,14-20*Busin bop busin haluusin sen Anutu haluuh hil Islel hôôk vu Ijip bôôy-ato, ond hil datongin balet lemu medatung yis nalukala le, nganjo daya balet amu, tonde hôôk yite busin nyendoos ond dayiis bik sipsip noow-ambe dasi. Tombe Yesu-te maanggêêm-aso lalingin yi nambe, “Gawiingin hey ana samu taaku sen gangga vanôôn busin haluusin mandôô-to vu tana?” ");
INSERT INTO mmo_vpl VALUES ("MK14_13","071_14_13","MRK","14","13","13","Tombe Yesu wiing yite maanggêêm yuuhapim lala de nêêl vu yuuh nambe, “Mana bayêên bop-anju ond male naatovu moow ti kava bel hôôk dêêngg, ond muuh taamuyin yi be mana. ");
INSERT INTO mmo_vpl VALUES ("MK14_14","071_14_14","MRK","14","14","14","Tombe bayêên ti sen dukanaa-to ond mandukana gaving-ambe muuh naanêêl sa naambe sa kaputung vu bayêên-anju mangganaan-ambe manjingin naambe sanêêngg bayêên alo sen sangga vanôôn busin haluusin gaving sate maanggêêm-aso ham-anja neep ond taato vu muuh. ");
INSERT INTO mmo_vpl VALUES ("MK14_15","071_14_15","MRK","14","15","15","Tombe le taato bayêên alo bopaata ti neep baandoni ond latongin lung la be neep, ond muuh samu yate vanôôn hôôk bayêên alo tii-ju.” ");
INSERT INTO mmo_vpl VALUES ("MK14_16","071_14_16","MRK","14","16","16","Tombe maanggêêm ayuuh lala. Yuuh lala lato bayêên-anju be yuuh layi lohvu sen Yesu nêêl vu yuuh-ato, tombe mem yuuh samu silate vanôôn busin haluusin. ");
INSERT INTO mmo_vpl VALUES ("MK14_17","071_14_17","MRK","14","17","17","De busin hôôk atombe Yesu having sil nomaayuuh-ambe laam yuuh-ato be mem lala bayêên-anjuuto. ");
INSERT INTO mmo_vpl VALUES ("MK14_18","071_14_18","MRK","14","18","18","+ o 14:18 Saam 41:9*Sil dando mondaya vanôôn atombe Yesu nêêl nambe, “Sa naanêêl keen vu ham naambe ham sen yiiy naha vanôôn hôôk tii-jo, ond ham ti navu bu sa dukana hil sen lanyiis saa-to namand.” ");
INSERT INTO mmo_vpl VALUES ("MK14_19","071_14_19","MRK","14","19","19","Maanggêêm-aso langoyin vakasin-anju, tombe londpayo nimeen, om sil ti ti lanêêl vu yi nambe, “Om sa, me?” ");
INSERT INTO mmo_vpl VALUES ("MK14_20","071_14_20","MRK","14","20","20","Tombe Yesu nêêl laah vu sil nambe, “Ham nomaayuuh-ambe laam yuuh-ato ti sen haay ahondoos naha vanôôn hôôk kaambum timuu-jo. ");
INSERT INTO mmo_vpl VALUES ("MK14_21","071_14_21","MRK","14","21","21","Omaahonôôn Noow e jimb nohvu vakasin neep hôôk Anutu-te kaapiyaa-to, lemu omaaho sen bu Omaahonôôn Noow dukana hil namand-ato ond le gako nimeen, de naambe tangganaan-ame gako omaahôô-ja le, ond mem nivasa.” ");
INSERT INTO mmo_vpl VALUES ("MK14_22","071_14_22","MRK","14","22","22","Daahen mondaya vanôôn, tonde Yesu lôôh balet ak-ambe lohak vu Anutu, le mem hapok-ambe vu vu sil, de nêêl nambe, “Ham gako naas, manyinja sa ningg naavi.” ");
INSERT INTO mmo_vpl VALUES ("MK14_23","071_14_23","MRK","14","23","23","Tonde lôôh kap wain ak-ambe lohak osin pêêlis la vu Anutu, de vu be sil pin lanum hatup hôôk. ");
INSERT INTO mmo_vpl VALUES ("MK14_24","071_14_24","MRK","14","24","24","+ o 14:24 Eks 24:8; Sek 9:11; Jer 31:31-34; 1Ko 10:16; Hiblu 9:20*Le mem nêêl vu sil nambe, “Manyinja sa ningg hees-anja, sa kaasêêh in nambe dôôvu hil ngeeyaata, de biing-ambe Anutu-te vakasin sen jôôy lung la be neep-ato nanjip niwêêk. ");
INSERT INTO mmo_vpl VALUES ("MK14_25","071_14_25","MRK","14","25","25","Om sa naanêêl keen vu ham naambe same le naanum wain nôôn aniluk ti jesin naah e, de na nohvu busin taamusin e mem sale naanum moos naah gaving Anutu-te hil.” ");
INSERT INTO mmo_vpl VALUES ("MK14_26","071_14_26","MRK","14","26","26","Tonde lawiing laalo ti lung la, le mem laluus-ambe lala kandu Oliv. ");
INSERT INTO mmo_vpl VALUES ("MK14_27","071_14_27","MRK","14","27","27","+ o 14:27 Mak 14:50; Sek 13:7*Yesu nêêl vu sil nambe, “Ham pin e lompayo nimeen-ambe ham gavuuh sa, nohvu Anutu-te vakasin neep hôôk kaapiyaa-to nambe, ‘Sa navu aanyiis bik sipsip-asote heendin de sipsip-aso gavuuh taale.’ ");
INSERT INTO mmo_vpl VALUES ("MK14_28","071_14_28","MRK","14","28","28","+ o 14:28 Mat 28:16; Mak 16:7*Lemu sale kandi jak naah-ambe sana Galili naamunggin ham.” ");
INSERT INTO mmo_vpl VALUES ("MK14_29","071_14_29","MRK","14","29","29","Tombe Pita nêêl vu nambe, “Sil pin e londpayo nimeen-ambe gavuuh hong, de sak le nama.” ");
INSERT INTO mmo_vpl VALUES ("MK14_30","071_14_30","MRK","14","30","30","Le Yesu nêêl vu nambe, “Sa naanêêl keen vu hong naambe peey busin-anjo kokalêêh-ame le naasu balon yuuh e, de gale ganjak alum in sa balon yaal vêêl e.” ");
INSERT INTO mmo_vpl VALUES ("MK14_31","071_14_31","MRK","14","31","31","+ o 14:31 Jon 11:16*Lemu Pita nêêl niwêêk lôôt nambe, “Same le anjak alungg in hong e, yik lanyiis sa be saanggimb gaving hong ond lung.” Tombe yik sil pin lanêêl nambêênjo having. ");
INSERT INTO mmo_vpl VALUES ("MK14_32","071_14_32","MRK","14","32","32","+ o 14:32 Jon 18:1*Lala lato taaku ti haale nambe Getesmaane, tombe Yesu nêêl vu yite maanggêêm-aso nambe, “Ham mandôô-jo de sana aanohak vêêl e.” ");
INSERT INTO mmo_vpl VALUES ("MK14_33","071_14_33","MRK","14","33","33","Tombe hako Pita yuuh Jems-ande Jon-ambe sil lala. Yesu lopayo nimeen-ambe nahees lôôt, ");
INSERT INTO mmo_vpl VALUES ("MK14_34","071_14_34","MRK","14","34","34","+ o 14:34 Jon 12:27*om nêêl vu yaal nambe, “Sa longgpayo nimeen lôôt lohvu saanggimb, om maal mandôô-jo ond maal oo mem naatum.” ");
INSERT INTO mmo_vpl VALUES ("MK14_35","071_14_35","MRK","14","35","35","De hataah la diin daka, be la hato pataav baambu neep voon-ande lohak nambe Anutu yoo le ji naambe lohvu ond yoo le nôôh va nimeen sen navu naatovu yii-jôôto na. ");
INSERT INTO mmo_vpl VALUES ("MK14_36","071_14_36","MRK","14","36","36","+ o 14:36 Lom 8:15; Gal 4:6; Mak 10:38; Jon 6:38*Nêêl nambe, “O Aamangg, galohvu nambe gambiing va pin om ganôôh kap nimeen-atêênjo vêêl in sa, lemu same naanêêl e, goo gate va.” ");
INSERT INTO mmo_vpl VALUES ("MK14_37","071_14_37","MRK","14","37","37","Tombe laah hato vu yaal, le yi de yaal deep, tombe nêêl vu Pita nambe, “Simon, onahop a? Game galohvu nambe omando mem naatum daka le? ");
INSERT INTO mmo_vpl VALUES ("MK14_38","071_14_38","MRK","14","38","38","+ o 14:38 Luk 11:4; Mat 6:13*Yik ham mando mem naatum-ambe ham anohak in palapin vaha me-kape ham e. Ham alompayo nawiingin, lemu ham anim naavi nitambo.” ");
INSERT INTO mmo_vpl VALUES ("MK14_39","071_14_39","MRK","14","39","39","Tonde yik laah-ambe lohak vakasin-anjuuto yesin laah. ");
INSERT INTO mmo_vpl VALUES ("MK14_40","071_14_40","MRK","14","40","40","Lo-hato be yi le yaal deep in mend animeen lôôt, de vakasin sen yaal daanêêl naah vu yii-to ma. ");
INSERT INTO mmo_vpl VALUES ("MK14_41","071_14_41","MRK","14","41","41","Tombe lo-hato vu yaal tu balon yaal yesin-ambe nêêl vu yaal nambe, “Maal naahen nahop a? Lung-anja, de busin sen lambu Omaahonôôn Noow dukana hil anipaya namand-ato ond ngaaho lak, ");
INSERT INTO mmo_vpl VALUES ("MK14_42","071_14_42","MRK","14","42","42","om ham kandi jak in yana. Ham angge, omaaho sen navu taato sa langaah-ato hato ni.” ");
INSERT INTO mmo_vpl VALUES ("MK14_43","071_14_43","MRK","14","43","43","Yesu naahen monanêêl vakasin-anjo tonde sil nomaayuuh-ambe laam yuuh-anjôôto ti Yudas hato pavis, ond hako hil ngeeyaata be lako yipak ayuuh tapum sapa sil-ambe lalaam, ond kul vaha sen datung salivangin-ato silate yêêv-aso de tanasin dangga-so himbop-aso yoo lanêêl ondeey sil lalaam. ");
INSERT INTO mmo_vpl VALUES ("MK14_44","071_14_44","MRK","14","44","44","De omaaho sen navu taato Yesu langaah-ato ond samu vakasin lung la vu sil nambe, “Ham angge naambe sa naamuuh omaahôô-ju gaambôôk ond yik yii-ju, tombe ham anôôh-ambe ham naapuvu niwêêk-ande ham gako be ana.” ");
INSERT INTO mmo_vpl VALUES ("MK14_45","071_14_45","MRK","14","45","45","Om Yudas valup-ambe la vu Yesu pavis, be nêêl nambe, “Kaputung,” tonde muuh Yesu gaambôôk. ");
INSERT INTO mmo_vpl VALUES ("MK14_46","071_14_46","MRK","14","46","46","Tombe yik lalôôh namand ak Yesu be lapuvu tatin, ");
INSERT INTO mmo_vpl VALUES ("MK14_47","071_14_47","MRK","14","47","47","lemu hil sen daale having Yesuu-to ond ti lôôh yipak ak-ambe sap yêêv bop salivangin-ate hil kul ti nanye vaalu be yêêhin. ");
INSERT INTO mmo_vpl VALUES ("MK14_48","071_14_48","MRK","14","48","48","Tombe Yesu nêêl vu sil nambe, “Ham alaam in ham anôôh sa, lemu nambe vaati sen ham hako yipak ayuuh tapum sapa ham-ambe ham alaam nambe sen ham alaam vu omaaho hôôndak ti? ");
INSERT INTO mmo_vpl VALUES ("MK14_49","071_14_49","MRK","14","49","49","+ o 14:49 Luk 19:47; 21:37; Jon 18:20*Lohvu busin pin sa nando monaawiing tanasin hôôk Anutu-te dumb bop alo vu ham, le ham-ame nalôôh sa le. Mam lung-ande Anutu-te vakasin bôôy-ato nôôn jak.” ");
INSERT INTO mmo_vpl VALUES ("MK14_50","071_14_50","MRK","14","50","50","+ o 14:50 Mat 26:31*Tombe sim yite maanggêêm-aso pin lavuuh yi de lapak-ambe lala. ");
INSERT INTO mmo_vpl VALUES ("MK14_51","071_14_51","MRK","14","51","51","Tombe maanggêêm ti taamuyin Yesu ond havêêh tôômb malis, tombe lalôôh yi, ");
INSERT INTO mmo_vpl VALUES ("MK14_52","071_14_52","MRK","14","52","52","le tôômb kaah-ambe nando, de pak-ambe la ninôôn. ");
INSERT INTO mmo_vpl VALUES ("MK14_53","071_14_53","MRK","14","53","53","Lako Yesu be lala vu kul vaha sen datung salivangin-ato silate yêêv bop, tombe tanasin dangga-so osin yêêv-aso salivangin-ate be himbop-aso pin lasupin sil lalaam timu. ");
INSERT INTO mmo_vpl VALUES ("MK14_54","071_14_54","MRK","14","54","54","Tonde Pita motaamuyin, le ma de yoo naale aheseseey daka, tombe monala be lukala yêêv bop salivangin-ate baan talind, be hato nando monanyuuh kin having ahevaavu-so. ");
INSERT INTO mmo_vpl VALUES ("MK14_55","071_14_55","MRK","14","55","55","Tombe yêêv-aso salivangin-ate osin kaansol-aso pin davu salo vakasin dangga in nambe lanyiis Yesu be jimb, le ma. ");
INSERT INTO mmo_vpl VALUES ("MK14_56","071_14_56","MRK","14","56","56","Tonde hil ngeeyaata lanêêl vakasin tatuhin lak yi, lemu sil pin anêênd vakasin-anju me-loh ti le. ");
INSERT INTO mmo_vpl VALUES ("MK14_57","071_14_57","MRK","14","57","57","De hil vaalu kandi daale be lanêêl vakasin tatuhin lak Yesu nambe, ");
INSERT INTO mmo_vpl VALUES ("MK14_58","071_14_58","MRK","14","58","58","+ o 14:58 Jon 2:19-21*“Hey hangoyin-ande nêêl nambe, ‘Sale kawiiy dumb vaambuung sen omaahonôôn lahaav-ato, de busin yaal vêêl e mem sale andaav ango sen omaahonôôn-ame lalohvu nambe landaav e.’” ");
INSERT INTO mmo_vpl VALUES ("MK14_59","071_14_59","MRK","14","59","59","Tombe sil lanêêl lôôt, le ma de silate vakasin-ame loh ti le. ");
INSERT INTO mmo_vpl VALUES ("MK14_60","071_14_60","MRK","14","60","60","Om yêêv bop salivangin-ate kandi naale hôôk sil lavuun-ambe lingin Yesu nambe, “Game nanêêl vakasin ti laah e? Hil-anjo danêêl vaaheey lak hong?” ");
INSERT INTO mmo_vpl VALUES ("MK14_61","071_14_61","MRK","14","61","61","+ o 14:61 Mak 15:5; Luk 23:9*Le yoo naale lava masin lôôt, de me-nêêl vakasin ti laah e, tombe yêêv bop salivangin-ate lingin yi yesin laah nambe, “Anutu sen hey lavangg nahôôk yii-to ond noow sen yoo holin yi vulôôt in nambe dôôvu hey-ato ond yik hong-anja?” ");
INSERT INTO mmo_vpl VALUES ("MK14_62","071_14_62","MRK","14","62","62","+ o 14:62 Saam 110:1; Taato 1:7*Tombe Yesu liinggis nambe, “Êê-e saa-jo, de ham e angge Omaahonôôn Noow e mando Niwêêk Danggakook nama vasa be naam hôôk bayiimb alo vu baandoni.” ");
INSERT INTO mmo_vpl VALUES ("MK14_63","071_14_63","MRK","14","63","63","Tombe yêêv bop salivangin-ate yoo kweek yite lolop nambe Anutu le ahekalin vu Yesu, de nêêl nambe, “Yiiy navu salo omaahonôôn in nambe le daanêêl vaati gaving? ");
INSERT INTO mmo_vpl VALUES ("MK14_64","071_14_64","MRK","14","64","64","+ o 14:64 Jon 19:7*Ham hango nambe nêêl Anutu palêê-jo, om ham akam vu nambe vaati?” Le sil pin lanêêl nambe, “Nêêl vakasin anipaya om yaanyiis-ambe jimb.” ");
INSERT INTO mmo_vpl VALUES ("MK14_65","071_14_65","MRK","14","65","65","Tombe hil vaalu kasuv ak yi, osin layum mekaalus-ande layiis yi de lanêêl vu nambe, “Onaanêêl omaaho ti sen yiis hong-ato langaah.” Tonde ahevaavu-so lapuvu yi de patap lôôt. ");
INSERT INTO mmo_vpl VALUES ("MK14_66","071_14_66","MRK","14","66","66","Pita naahen nando talind atonde kul vaha sen datung salivangin-ato silate yêêv bop, yite vêêh kul ti hato ");
INSERT INTO mmo_vpl VALUES ("MK14_67","071_14_67","MRK","14","67","67","le yi de Pita monanyuuh kin, tombe get lôôt de nêêl vu nambe, “Hong-anja navu taamuyin Yesu Nasaalet having-ato.” ");
INSERT INTO mmo_vpl VALUES ("MK14_68","071_14_68","MRK","14","68","68","Le ma de Pita lak alu nambe, “Same alak ni le, sa doosin va sen ganêêl-anja.” Tombe seelin hato laah ngaaho vu vinavi tonde kokalêêh su. ");
INSERT INTO mmo_vpl VALUES ("MK14_69","071_14_69","MRK","14","69","69","Tombe vêêh-anjuuto yi me lak Pita yesin, om nêêl vu hil sen daalêê-juuto nambe, “Hil-anjuuto ond tii-ja.” ");
INSERT INTO mmo_vpl VALUES ("MK14_70","071_14_70","MRK","14","70","70","Le yik Pita lak alu yesin nambe, “Malis.” Daahen daale daka tonde hil sen daalêê-juuto lanêêl vu Pita yesin laah nambe, “Keen, hil-anjuuto silate ti hong-anjo, in hong Galili having-ato.” ");
INSERT INTO mmo_vpl VALUES ("MK14_71","071_14_71","MRK","14","71","71","Lemu Pita nêêl Anutu haale osin nêêl nambe, “Sa doosin omaaho sen ham nanêêl-anja keen baandoni.” ");
INSERT INTO mmo_vpl VALUES ("MK14_72","071_14_72","MRK","14","72","72","+ o 14:72 Mak 14:30*Tonde pavis atombe kokalêêh su tu balon ango yesin, tombe mem Pita ka vu vakasin sen Yesu nêêl vu yii-to nambe, “Kokalêêh-ame naasu balon yuuh e de gale ganjak alum in sa balon yaal vêêl e.” Ka vu vakasin-anju om lopayo nimeen-ande su lôôt. ");
INSERT INTO mmo_vpl VALUES ("MK15_1","071_15_1","MRK","15","1","1","+ o 15:1 Luk 22:66*Samiinaanôôn atombe kul vaha sen datung salivangin-ato silate yêêv-aso osin himbop-aso be tanasin dangga-so de kaansol-aso pin lasupin pavis-ambe lakaas lung la, tonde landuuh Yesu de laandiiy-ambe lala vu yêêv bop Lom ti haale nambe Pilata. ");
INSERT INTO mmo_vpl VALUES ("MK15_2","071_15_2","MRK","15","2","2","Tombe Pilata lingin Yesu nambe, “Yuda-te omaaho lulemak hong a?” Le nêêl nambe, “Yik ganêêl-anja.” ");
INSERT INTO mmo_vpl VALUES ("MK15_3","071_15_3","MRK","15","3","3","Tombe yêêv-aso salivangin-ate lanêêl vakasin ngeeyaata lak Yesu, ");
INSERT INTO mmo_vpl VALUES ("MK15_4","071_15_4","MRK","15","4","4","om Pilata lingin Yesu laah nambe, “Game nanêêl vakasin ti nalaah vu sil e? Gangge sil lanêêl vakasin ngeeyaata lak hong-anja.” ");
INSERT INTO mmo_vpl VALUES ("MK15_5","071_15_5","MRK","15","5","5","+ o 15:5 Ais 53:7; Mak 14:61*Lemu Yesu me-nêêl vakasin ti laah vu yi le, om Pilata ka la nge-ngeey. ");
INSERT INTO mmo_vpl VALUES ("MK15_6","071_15_6","MRK","15","6","6","Lohvu ta pin hôôk hil Yuda-te busin bop busin haluusin sen Anutu haluuh hil Islel hôôk vu Ijip bôôy-ato, ond silate gambum ti neep nambe sil davu kataangg kalaambus-aso ti, de Pilata navu kavaayin kalaambus tii-ju be navu la malis vu sil. ");
INSERT INTO mmo_vpl VALUES ("MK15_7","071_15_7","MRK","15","7","7","Tombe omaahonôôn heey dando hôôk kalaambus in dawiing ngaamong vu gaaman osin layiis hil vaalu be layimb, ond sil ti haale nambe Balabas, ");
INSERT INTO mmo_vpl VALUES ("MK15_8","071_15_8","MRK","15","8","8","om hil pin lala vu Pilata be sil kataangg nambe, “Goo gambiing naambe sen onawiing lohvu ta pin-ato.” ");
INSERT INTO mmo_vpl VALUES ("MK15_9","071_15_9","MRK","15","9","9","Tombe Pilata lingin laah vu sil nambe, “Ham awiingin nambe sa kavaayin Yuda-te omaaho lulemak vu ham a?” ");
INSERT INTO mmo_vpl VALUES ("MK15_10","071_15_10","MRK","15","10","10","Lingin nambêênju in lak ni nambe kul vaha sen datung salivangin-ato silate yêêv-aso ahend anipaya vu Yesu, ondeey sil laandiiy la vu yi. ");
INSERT INTO mmo_vpl VALUES ("MK15_11","071_15_11","MRK","15","11","11","+ o 15:11-14 Sin 3:13-14; 13:28*Lemu yêêv-aso salivangin-ate laanjiihin hil pin nambe, “Ham naateey niwêêk na vu Pilata naambe kavaayin Balabas naam vu ham.” ");
INSERT INTO mmo_vpl VALUES ("MK15_12","071_15_12","MRK","15","12","12","Tombe Pilata nêêl laah vu sil nambe, “De omaaho sen ham nanêêl nambe Yuda-te omaaho lulemak-ato ond saambiing vaati vu?” ");
INSERT INTO mmo_vpl VALUES ("MK15_13","071_15_13","MRK","15","13","13","Tombe lateey bopaata lôôt nambe, “Ganyiis jakana haah pako.” ");
INSERT INTO mmo_vpl VALUES ("MK15_14","071_15_14","MRK","15","14","14","Lemu Pilata nêêl vu sil nambe, “In? Wiing vaati paya deey?” Le ma de sil oo lateey niwêêk lôôt nambe, “Ganyiis jakana haah pako.” ");
INSERT INTO mmo_vpl VALUES ("MK15_15","071_15_15","MRK","15","15","15","Tombe Pilata wiingin nambe hil ahend anivasa jak, om kavaayin Balabas-ambe vu la vu sil, de Yesu ond nêêl-ambe ahevaavu-so laveek lôôt, le mem vu lukala hil Lom ngaamong vaha-so namand in nambe lanyiis jakana haah pako. ");
INSERT INTO mmo_vpl VALUES ("MK15_16","071_15_16","MRK","15","16","16","Hil Lom ngaamong vaha-so lako Yesu be lalukala yêêv bop-ate taaku lopayo, tombe lateey silate hil ngaamong vaha-so pin lalaam having. ");
INSERT INTO mmo_vpl VALUES ("MK15_17","071_15_17","MRK","15","17","17","+ o 15:17-19 Luk 23:11*Le mem sil lalop lolop amembu ti lukala Yesu de davu taahu omaaho lulemak ak yi, de sil lasêêy hees aniyin-ambe lambuuhin, tombe latung lakala Yesu lu, ");
INSERT INTO mmo_vpl VALUES ("MK15_18","071_15_18","MRK","15","18","18","tonde laakôôhin nambe, “Yuda-te omaaho lulemak omando-o.” ");
INSERT INTO mmo_vpl VALUES ("MK15_19","071_15_19","MRK","15","19","19","Tonde laveek lukook ak paatôôn ngasing ti, de sil kasuv ak, tonde latung kaatu vu yi be lako haale lak. ");
INSERT INTO mmo_vpl VALUES ("MK15_20","071_15_20","MRK","15","20","20","Sil pale Yesu lung la le mem lakaah lolop amembuu-ju vêêl in, de yoo lalop yite lukalaah yi, tonde mem lako be lala in lanyiis jakana haah pako. ");
INSERT INTO mmo_vpl VALUES ("MK15_21","071_15_21","MRK","15","21","21","+ o 15:21 Lom 16:13*Lala lato mop atombe latovu hil Sailini ti haale nambe Simon, sen noow Aleksanda yuuh Lupus-ato, ond vu kul-ambe hato, tombe hil ngaamong vaha-so lanêêl niwêêk lôôt vu yi om kava Yesu-te haah pako. ");
INSERT INTO mmo_vpl VALUES ("MK15_22","071_15_22","MRK","15","22","22","Sil lako Yesu be lala lato taaku ti danêêl nambe Golagaata, dangga nambe taaku lukook. ");
INSERT INTO mmo_vpl VALUES ("MK15_23","071_15_23","MRK","15","23","23","Tombe sil kaasêêh malaasin anikalin ti lukala wain-ambe lavu vu Yesu in nambe naanum, le ma de nimbaya. ");
INSERT INTO mmo_vpl VALUES ("MK15_24","071_15_24","MRK","15","24","24","+ o 15:24 Saam 22:18*Tombe hil ngaamong vaha-so layiis Yesu lakala haah pako lung la, tonde sil laate tatuuh-ambe tambe lak Yesu-te lolop-ande latiiy lohvu sil, tombe yik hil ngaamong vaha-so yoo lako lolop ti ti lohvu sil. ");
INSERT INTO mmo_vpl VALUES ("MK15_25","071_15_25","MRK","15","25","25","Taaku me sen layiis Yesu lakala haah pakôô-to ond 9 kilok samiinaanôôn. ");
INSERT INTO mmo_vpl VALUES ("MK15_26","071_15_26","MRK","15","26","26","Tombe sil kaavu vakasin sen lanêêl ak yii-to neep ak nambe, “Yuda-te Omaaho Lulemak.” ");
INSERT INTO mmo_vpl VALUES ("MK15_27","071_15_27","MRK","15","27","27","Tonde layiis hil hôôndak yuuhapim having Yesu, ango naale nama kêênj de ango naale nama vasa. ");
INSERT INTO mmo_vpl VALUES ("MK15_28","071_15_28","MRK","15","28","28","+ o 15:28 Ais 53:12*Om yik vakasin bôôy sen lukaneep kaapiyaa-to nôôn ak nambe, “Lasevin yi having hil anipaya.” ");
INSERT INTO mmo_vpl VALUES ("MK15_29","071_15_29","MRK","15","29","29","+ o 15:29 Saam 22:7; 109:25; Mak 14:58; Jon 2:19*Tombe hil ngeeyaata sen daale danjung-ato layi be lalaah namand vu, de lawiing kangasin vu Yesu lôôt nambe, “Wopo, hong sen ganêêl nambe gale kawiiy Anutu-te dumb vaambuung-ande nohvu busin yaal gale gandaav naah-atôônjo, ");
INSERT INTO mmo_vpl VALUES ("MK15_30","071_15_30","MRK","15","30","30","om goo gandôôvu hong-ambe onggavuuh haah pakôô-ja de ganduus-ambe ganaam voon-o.” ");
INSERT INTO mmo_vpl VALUES ("MK15_31","071_15_31","MRK","15","31","31","Tombe kul vaha sen datung salivangin-ato silate yêêv-aso osin tanasin dangga-so yoo lakaas vu sil-ambe sil pale Yesu having nambe, “Hôôvu hil vaalu de me-lohvu nambe yoo dôôvu yi le. ");
INSERT INTO mmo_vpl VALUES ("MK15_32","071_15_32","MRK","15","32","32","Om naambe Anutu yoo holin yi vulôôt-ambe tu hil Islel-ate omaaho lulemak keen ond duus-ambe naam voon, ond mem yaangge be yaambiing gaving yi.” De omaaho yuuh sen layiis yuuh having Yesuu-to ond yuuh lanêêl Yesu pale having. ");
INSERT INTO mmo_vpl VALUES ("MK15_33","071_15_33","MRK","15","33","33","+ o 15:33 Emo 8:9*Taaku mekaalus laam naale lavuun atombe taaku mekanu hôôk lohvu taaku pin-ambe laam soosin hôôk lohvu taaku me yaal. ");
INSERT INTO mmo_vpl VALUES ("MK15_34","071_15_34","MRK","15","34","34","+ o 15:34 Saam 22:1*Tombe taaku me yaal-anjo Yesu teey bopaata lôôt nambe, “Eloi, Eloi, lama sabatani?” Dangga nambe, “Sate Anutu, sate Anutu, nambe vaati om ohavuuh sa la?” ");
INSERT INTO mmo_vpl VALUES ("MK15_35","071_15_35","MRK","15","35","35","Tombe sim hil vaalu sen daale ngaahôô-to langoyin-ambe lanêêl nambe, “Ke, ham gango, nateey Eliya.” ");
INSERT INTO mmo_vpl VALUES ("MK15_36","071_15_36","MRK","15","36","36","+ o 15:36 Saam 69:21*Tonde omaaho ti saloongg-ambe la hako malumak-ambe laanggôôl hôôk bel anikalin, tombe havingin malumak-anju hôôk ngasing vaha de hako be la vu lukala Yesu avi in nambe dasuvin, de nêêl nambe, “Ham baale de yaangge naambe Eliya le gato nôôh yi duus me malis.” ");
INSERT INTO mmo_vpl VALUES ("MK15_37","071_15_37","MRK","15","37","37","Tonde Yesu teey lava bopaata de yimb la. ");
INSERT INTO mmo_vpl VALUES ("MK15_38","071_15_38","MRK","15","38","38","+ o 15:38 Hiblu 10:19-20*Tombe tôômb bopaata dinaandiin lôôt sen yakaluuh Anutu-te dumb vaambuung alopayôô-to kweek la yuuh vu vaavu be la hoow. ");
INSERT INTO mmo_vpl VALUES ("MK15_39","071_15_39","MRK","15","39","39","Tombe hil Lom-ate yêêv ngaamong vaha ti naale ngaaho vu Yesu me ond yi de Yesu yimb la, om nêêl nambe, “Ham hil-e, omaahôô-jo Anutu Noow keen.” ");
INSERT INTO mmo_vpl VALUES ("MK15_40","071_15_40","MRK","15","40","40","+ o 15:40 Luk 8:2-3*Tonde vêêh heey daale diin daka be mondayi ond ti Malia vu Magadala, de Malia ango sen Jems pasiv ayuuh Joses taandin-ato, de tik Saalome. ");
INSERT INTO mmo_vpl VALUES ("MK15_41","071_15_41","MRK","15","41","41","Bôôy sen Yesu naahen nando Galilii-to ond vêêh yaal-anju davu taamuyin yi de dahôôvu yi, de vêêh ngeeyaata daale having yaal ond sil ahondoos laving Yesu be lala Yelusalem. ");
INSERT INTO mmo_vpl VALUES ("MK15_42","071_15_42","MRK","15","42","42","De soosin hôôk atombe hil pin davu samu sil in samiinaanôôn ond busin sawaasin, om kaansol ti, ");
INSERT INTO mmo_vpl VALUES ("MK15_43","071_15_43","MRK","15","43","43","haale nambe Yusep vu Alimatia, ond omaaho osin haale bop, de ka navu busin sen Anutu naam in ganggin yite hil-ato, ond lo nôôn timu de la vu Pilata be kataangg Yesu naavi nambe gako be na gambe na. ");
INSERT INTO mmo_vpl VALUES ("MK15_44","071_15_44","MRK","15","44","44","Om Pilata hango tombe vindis in vakasin sen Yesu yimb lung laa-to, om teey ngaamong vaha-sote yêêv laam-ambe lingin nambe, “Yesu yimb la gêên a?” ");
INSERT INTO mmo_vpl VALUES ("MK15_45","071_15_45","MRK","15","45","45","Pilata hangoyin vu ngaamong vaha-sote yêêv lung la le mem liinggis vu Yusep nambe na nôôh omaahonôôn vêêl. ");
INSERT INTO mmo_vpl VALUES ("MK15_46","071_15_46","MRK","15","46","46","Tombe Yusep vaanggo tôômb valôôy ti be hako be la lôôh omaahonôôn luus-ambe vayum hôôk, tombe mem la hambe lukala neep hôôk lavandangga ti sen lasap hôôk tatuuh danggaa-to, tonde paliiy tatuuh bopaata ti laah hilin lavandangga avi jeen. ");
INSERT INTO mmo_vpl VALUES ("MK15_47","071_15_47","MRK","15","47","47","Tombe Malia Magadala de Malia ango sen Joses tangganaan-ato, ond yuuh lala layi taaku sen lambe Yesu naavi neep hôôk-ato. ");
INSERT INTO mmo_vpl VALUES ("MK16_1","071_16_1","MRK","16","1","1","Busin sawaasin lung la le mem Malia Magadala de Malia ango sen Jems tangganaan-ato de Saalome, ond yaal lala laanggo bel galovasa be yaal lako in nambe lana kaasêêh ak Yesu naavi. ");
INSERT INTO mmo_vpl VALUES ("MK16_2","071_16_2","MRK","16","2","2","Om Sonda samiinaanôôn atombe yaal kandi be lala lavandangga sen lambe Yesu hôôk-ato. ");
INSERT INTO mmo_vpl VALUES ("MK16_3","071_16_3","MRK","16","3","3","Tombe vu mopaatôôv ond yaal mondanêêl vu yaal nambe, “Peey e lati le paliiy tatuuh sen hilin lavandangga avii-to na vêêl in waay?” ");
INSERT INTO mmo_vpl VALUES ("MK16_4","071_16_4","MRK","16","4","4","Tonde lavêêl mend ak e layi de tatuuh seelin vêêl, tatuuh-anju bopaata lôôt. ");
INSERT INTO mmo_vpl VALUES ("MK16_5","071_16_5","MRK","16","5","5","Tombe yaal lalukala lavandangga lopayo be yaal layi de maanggêêm ti lop lolop valôôy diin ti be nando laah osin yaal namand vasa, tombe yaal lavindis lôôt. ");
INSERT INTO mmo_vpl VALUES ("MK16_6","071_16_6","MRK","16","6","6","Tombe nêêl vu yaal nambe, “Maal-ame ambindis e. Maal navu salo Yesu Nasaalet sen layiis ak haah pakôô-to, ond me-neep-anjo le, kandi lak lung la, maal angge ahembaan nganjo. ");
INSERT INTO mmo_vpl VALUES ("MK16_7","071_16_7","MRK","16","7","7","+ o 16:7 Mat 26:32; Mak 14:28*Om maal anaah naanêêl banye vu yite maanggêêm-aso be Pita gaving, naambe le naamunggin-ambe na Galili, le mem ham e angge yi vuu-ju nohvu vakasin sen nêêl vu ham-ato.” ");
INSERT INTO mmo_vpl VALUES ("MK16_8","071_16_8","MRK","16","8","8","Tombe yaal kanund la be lahees lôôt, om yaal lalom voon e mem yaal lapak-ambe lala, lemu yaal-ame lanêêl banye vu omaaho ti le, in yaal layêênin lôôt. ");
INSERT INTO mmo_vpl VALUES ("MK16_9","071_16_9","MRK","16","9","9","+ o 16:9 Luk 8:2*Yesu kandi lak hôôk Sonda samiinaanôôn atombe taato yi munggin vu Malia Magadala sen Yesu hatiiy mamu nipaya namaavaalu be vindak yuuh la in bôôy-ato, ");
INSERT INTO mmo_vpl VALUES ("MK16_10","071_16_10","MRK","16","10","10","tombe vêêh-anjo laah vu hil sen davu taamuyin Yesuu-to in londpayo nimeen-ambe mondasu, tombe nêêl banye vu sil. ");
INSERT INTO mmo_vpl VALUES ("MK16_11","071_16_11","MRK","16","11","11","Tombe sil lango banye nambe Yesu nando metumin-ambe vêêh-anju yi me lak, lemu sil-ame lawii-having lava le. ");
INSERT INTO mmo_vpl VALUES ("MK16_12","071_16_12","MRK","16","12","12","Tonde sim silate omaaho yuuh vu bayêên bop-ambe lala in lana, tombe Yesu taato yi vu yuuh vu mop lavuun, lemu ninaavi ngo yoow. ");
INSERT INTO mmo_vpl VALUES ("MK16_13","071_16_13","MRK","16","13","13","Tombe yuuh lalaah-ambe yuuh lanêêl vu yuuhate hil vaalu, le sil-ame lawii-having e. ");
INSERT INTO mmo_vpl VALUES ("MK16_14","071_16_14","MRK","16","14","14","+ o 16:14 1Ko 15:5*Tonde sim maanggêêm nomaayuuh-ambe laam ti dando mondaya vanôôn atombe Yesu la hato be taato yi langaah vu sil, de nêêl sil in me-lawii-having yi le, in londpayo niwêêk, de me-lawii-having hil sen layi mend ak-ande kandi lak-ato lavand e. ");
INSERT INTO mmo_vpl VALUES ("MK16_15","071_16_15","MRK","16","15","15","+ o 16:15 Sin 1:8*Tonde mem nêêl vu sil nambe, “Ham anohvu taaku pin-ambe ham ana naanêêl sate banye nivasa langaah vu omaahonôôn pin. ");
INSERT INTO mmo_vpl VALUES ("MK16_16","071_16_16","MRK","16","16","16","+ o 16:16 Sin 2:38; 16:31,33*Hil sen londpayo naam timu vu sa be lanjipis bel, ond sil e mando metumin danggata, de hil sen londpayo me-wii-having e ond le daatovu nipaya nyevahaan-ambe lana mend nama. ");
INSERT INTO mmo_vpl VALUES ("MK16_17","071_16_17","MRK","16","17","17","+ o 16:17 Sin 2:4; 10:46; 8:7*Hil sen londpayo laam timu vu saa-to ond sil e lambiing taahu taahu osin niwêêk, sil e gatiiy mamu nipaya jak sa haalengg osin sil e bakaas bayêên bu ti ti lavand. ");
INSERT INTO mmo_vpl VALUES ("MK16_18","071_16_18","MRK","16","18","18","+ o 16:18 Luk 10:19; Sin 28:3-6; 4:30; 5:16*Tonde sil namand e nanôôh nyêêy jak, de naambe daanum va yimbin-ate yuuh ame ond vati me-le biing sil e, de sil e gambe namand jak hil anilakin-ambe nind vasa jak.” ");
INSERT INTO mmo_vpl VALUES ("MK16_19","071_16_19","MRK","16","19","19","+ o 16:19 Sin 2:33-34; 7:55-56; Ep 1:20; 1Pi 3:22*Omaaho Bop Yesu vakaas having sil lung la, tonde Anutu hako yi be la nando nama vasa having yi vu baandoni in taato naambe tu yêêv bop. ");
INSERT INTO mmo_vpl VALUES ("MK16_20","071_16_20","MRK","16","20","20","+ o 16:20 Sin 14:3; Hiblu 2:3-4*Tonde maanggêêm-aso lala lanêêl banye nivasa lohvu taaku pin, de Omaaho Bop yoo nando having sil-ambe navu kaandu silate vakasin lak taahu taahu vaha vaha nambe vakasin nôôn keen. ");
INSERT INTO mmo_vpl VALUES ("LK1_1","072_1_1","LUK","1","1","1","+ o 1:1 Sin 1:1*O himbop Tiopilas, hil ngeeyaata kaavu vakasin lak va pin sen Anutu wiing hôôk hey lavuun-ato, ");
INSERT INTO mmo_vpl VALUES ("LK1_2","072_1_2","LUK","1","2","2","+ o 1:2 Jon 15:27*ond sil oo kaavu lohvu hil sen layi vaa-ju lak mend vu munggin-ande yoo mondanêêl vakasin langaah-ato, ond hil-anju lanêêl vakasin-anja vu hey. ");
INSERT INTO mmo_vpl VALUES ("LK1_3","072_1_3","LUK","1","3","3","Tombe saalingin va yuuh amêê-ju danggakook pin nivasa lôôt, tombe mem sa kangg vu nambe soo kaavu nanjip nivalok nohvu va sen bôôy-anjuuto be saambiing naas vu hong, ");
INSERT INTO mmo_vpl VALUES ("LK1_4","072_1_4","LUK","1","4","4","in ganjak ni naambe va sen hil tatekin vu hong-ato ond keen lôôt. Om sa naanêêl vu hong. ");
INSERT INTO mmo_vpl VALUES ("LK1_5","072_1_5","LUK","1","5","5","+ o 1:5 1Kro 24:10*Hôôk busin sen Helot tu hil Yudia-te omaaho lulemak-ato, ond hil sen datung salivangin-ato ti nando, haale nambe Sakaalia, ond yi vu kul vaha salivangin-aso vaalu sen Abaisa-te hil vu taamusin-ato, tonde Sakaalia vane Elisabet ond yik yite danggakook neep vu Aalon-ate noondin having. ");
INSERT INTO mmo_vpl VALUES ("LK1_6","072_1_6","LUK","1","6","6","Anutu yi Sakaalia yuuh Elisabet anivasa, in yuuh oo samu Omaaho Bop-ate vakasin osin tanasin pin de vakasin ma. ");
INSERT INTO mmo_vpl VALUES ("LK1_7","072_1_7","LUK","1","7","7","Lemu yuuhanêênd unoopasiv ma, in Elisabet oo naale muuh-ambe yuuh ahondoos tata lak. ");
INSERT INTO mmo_vpl VALUES ("LK1_8","072_1_8","LUK","1","8","8","Tonde Sakaalia having kul vaha salivangin-aso vaalu sen sil dangga timuu-to, ond sil lalup-ambe lalukala Anutu-te dumb bop alo. ");
INSERT INTO mmo_vpl VALUES ("LK1_9","072_1_9","LUK","1","9","9","+ o 1:9 Eks 30:7*Tonde hil sen datung salivangin-anju silate gambum ti neep, om sil laate tatuuh atombe tok la hato hôôk Sakaalia me, in taato naambe dukana Omaaho Bop-ate dumb alo vaambuung-ambe basi va galovasa na vu Anutu. ");
INSERT INTO mmo_vpl VALUES ("LK1_10","072_1_10","LUK","1","10","10","Om lukala monasi va galovasa la vu Anutu, tonde hil ngeeyaata lalu-daale voon-ambe mondalohak. ");
INSERT INTO mmo_vpl VALUES ("LK1_11","072_1_11","LUK","1","11","11","Tonde sim Sakaalia yi de angela ti hato vu be naale alata vaalu la osin nama vasa sen kin galovasaa-to. ");
INSERT INTO mmo_vpl VALUES ("LK1_12","072_1_12","LUK","1","12","12","Sakaalia yi angelaa-ju tombe vindis-ande naha lak lôôt, ");
INSERT INTO mmo_vpl VALUES ("LK1_13","072_1_13","LUK","1","13","13","le angela nêêl vu nambe, “Sakaalia, game ganjêênin e, in Anutu hango gate lohakin lung la. Vanem Elisabet e gako gate nomaatuk, tombe onaateey haale naambe Jon. ");
INSERT INTO mmo_vpl VALUES ("LK1_14","072_1_14","LUK","1","14","14","Om galompayo navu nivasa jak-ambe onaapêêlis, tombe tangganaan gako le mem hil ngeeyaata le daapêêlis gaving. ");
INSERT INTO mmo_vpl VALUES ("LK1_15","072_1_15","LUK","1","15","15","+ o 1:15 Nam 6:3*Tombe Omaaho Bop e ji onoom-anju naambe omaaho osin haale bop, de me-le naanum wain osin bel aniwêêk e, de sen naahen baale dôôk tangganaan baambuu-to ond Vavi Vaambuung e dôôvu yi. ");
INSERT INTO mmo_vpl VALUES ("LK1_16","072_1_16","LUK","1","16","16","Tombe sim le biing-ambe hil Islel ngeeyaata le langgilin sil lanaah vu silate Omaaho Bop Anutu. ");
INSERT INTO mmo_vpl VALUES ("LK1_17","072_1_17","LUK","1","17","17","+ o 1:17 Mat 17:11-13; Mal 3:1; 4:5-6*Onoom-anju ond le niwêêk osin Vavi Vaambuung dôôvu nohvu sen Eliya bôôy-ato, tombe le naamunggin vu Omaaho Bop, de le biing-ambe himbop-aso langgilin londpayo naah vu noondin, tonde le biing-ambe hil kalêêsin ambu-so langgilin sil in nambe sil sapa nohvu sen hil anivalok-ato, tonde samu sil in sil oo mongganggin Omaaho Bop navu naam.” ");
INSERT INTO mmo_vpl VALUES ("LK1_18","072_1_18","LUK","1","18","18","+ o 1:18 Jen 18:11*Tombe Sakaalia nêêl vu angela nambe, “Sale anjak ni jak vaati naambe vakasin-anja le nôôn jak? In haay ahondoos vêêh tata lak lung laa-to.” ");
INSERT INTO mmo_vpl VALUES ("LK1_19","072_1_19","LUK","1","19","19","+ o 1:19 Dan 8:16; 9:21; Hiblu 1:14*Le angela nêêl laah nambe, “Sa Gabiel sen soo naale hôôk Anutu mêê-to, ond wiing sa laam in nambe sa gako banye nivasaa-jo naam-ambe sa naanêêl vu hong. ");
INSERT INTO mmo_vpl VALUES ("LK1_20","072_1_20","LUK","1","20","20","+ o 1:20 Luk 1:45*Om onggango le, sate vakasin-anjo yoo le nôôn jak hôôk yite busin nivalok. Le game gawii-having e, om game le bakaas e, olavam e nama na de na nohvu busin sen va pin-anjo nôôn jak e mem.” ");
INSERT INTO mmo_vpl VALUES ("LK1_21","072_1_21","LUK","1","21","21","Nêêl lung atonde hil oo mondanggin Sakaalia lôôt, tombe kand vu nambe mak vaati wiing om nando ahusaandiin lôôt hôôk dumb alo vaambuung-anjuuto. ");
INSERT INTO mmo_vpl VALUES ("LK1_22","072_1_22","LUK","1","22","22","Tombe hato, lemu me-lohvu nambe bakaas vu sil e, yik navu taato va lak nama mu in ka ma, om lalak ni nambe peey e yi vati yoow vu dumb alo vaambuung-ato. ");
INSERT INTO mmo_vpl VALUES ("LK1_23","072_1_23","LUK","1","23","23","Sakaalia yoo nando monawiing kul hôôk dumb alo lôôt-ambe yite busin lung la, le mem hato be laah baan. ");
INSERT INTO mmo_vpl VALUES ("LK1_24","072_1_24","LUK","1","24","24","Lung atonde vane Elisabet noow hôôk, om yoo nando tatimasin hôôk bayêên alo lohvu kwaav namaavaalu, de nêêl nambe, ");
INSERT INTO mmo_vpl VALUES ("LK1_25","072_1_25","LUK","1","25","25","+ o 1:25 Jen 30:23*“Gêên Omaaho Bop yoo samu sa nivasa nambêênjo, in bôôy sa ningg namum hôôk omaahonôôn amend in sanêêngg unoopasiv ma, le sim gêên ond Omaaho Bop wiing-ambe sa ningg mumin-ato ma la.” ");
INSERT INTO mmo_vpl VALUES ("LK1_26","072_1_26","LUK","1","26","26","Kwaav namaavaalu vindak ti lung la, le mem Anutu wiing angela Gabiel la bayêên bop ti neep Galili, bayêên haale nambe Nasaalet. ");
INSERT INTO mmo_vpl VALUES ("LK1_27","072_1_27","LUK","1","27","27","+ o 1:27 Mat 1:16,18; Luk 2:5*Ond angelaa-ju la vu vehaavu ti sen lanêêl lak moow ti haale nambe Yusep. Yusep-anju ond danggakook neep vu Devit-ato, ond vehaavuu-ju haale nambe Malia. ");
INSERT INTO mmo_vpl VALUES ("LK1_28","072_1_28","LUK","1","28","28","Tombe angela Gabiel la valup-ambe nêêl vu nambe, “O Malia, Omaaho Bop Anutu ka pasiv in hong-ambe nando having hong.” ");
INSERT INTO mmo_vpl VALUES ("LK1_29","072_1_29","LUK","1","29","29","Malia hango lavaa-ju tombe yêênin lôôt, de ka vu nambe, “Mak vakasin-anju dangga nambe va?” ");
INSERT INTO mmo_vpl VALUES ("LK1_30","072_1_30","LUK","1","30","30","Tombe angela nêêl vu nambe, “Malia, game ganjêênin e, in Anutu nayi hong nivasa. ");
INSERT INTO mmo_vpl VALUES ("LK1_31","072_1_31","LUK","1","31","31","+ o 1:31 Ais 7:14; Mat 1:21-23*De onggango le, unoopasiv moow ti navu dumbaale galompayo, tombe onggako ond onaateey haale naambe Yesu. ");
INSERT INTO mmo_vpl VALUES ("LK1_32","072_1_32","LUK","1","32","32","+ o 1:32-33 Ais 9:7; 2Sml 7:12,13,16; Dan 7:14; Mai 4:7*Unoopasiv-anja le gako haale bop, de Anutu baandoni le naanêêl naambe yite Noow keen. Omaaho Bop Anutu le biing-ambe naatu omaaho lulemak, yik naambe sen yite himbop Devit-ato, ");
INSERT INTO mmo_vpl VALUES ("LK1_33","072_1_33","LUK","1","33","33","in ganggin Yaakop-ate hil vu taamusin, tombe yite kul-anjo me-le jung na le, yoo le mando danggata osin danggata.” ");
INSERT INTO mmo_vpl VALUES ("LK1_34","072_1_34","LUK","1","34","34","Tombe sim Malia lingin angela nambe, “Vaa-ja le nôôn jak naambe va? In same alak vu moow ti le.” ");
INSERT INTO mmo_vpl VALUES ("LK1_35","072_1_35","LUK","1","35","35","+ o 1:35 Mat 1:20*Le angela nêêl vu nambe, “Vavi Vaambuung e jakanaas hong, tonde Anutu-te niwêêk e naas naambiiy kôôh vu hong, om unoopasiv vaambuung sen onavu gako vu taamusin-ato ond le daanêêl naambe Anutu Noow. ");
INSERT INTO mmo_vpl VALUES ("LK1_36","072_1_36","LUK","1","36","36","Angge, gaandemaavêêh Elisabet ond tata lak lung la, de danêêl nambe naale muuh, le ma de gêên ond unoopasiv moow lukaale lopayo be kwaav namaavaalu vindak ti lung la ni. ");
INSERT INTO mmo_vpl VALUES ("LK1_37","072_1_37","LUK","1","37","37","+ o 1:37 Jen 18:14*Vati me-nimeen vu Anutu le, yoo lohvu nambe biing va pin.” ");
INSERT INTO mmo_vpl VALUES ("LK1_38","072_1_38","LUK","1","38","38","Tombe Malia nêêl nambe, “Ke, Omaaho Bop-ate unaavepasiv sa, om lung-ande vakasin sen ganêêl lak saa-ja nôôn jak.” Lung atonde angela havuuh Malia de la. ");
INSERT INTO mmo_vpl VALUES ("LK1_39","072_1_39","LUK","1","39","39","Tombe yik Malia kandi pavis-ambe la taaku kandu be la valup hil Yuda-te bayêên bop ti, ");
INSERT INTO mmo_vpl VALUES ("LK1_40","072_1_40","LUK","1","40","40","tombe huli-la Sakaalia baan-ambe vakaas vu Elisabet. ");
INSERT INTO mmo_vpl VALUES ("LK1_41","072_1_41","LUK","1","41","41","+ o 1:41 Luk 1:15*Elisabet hango Malia lava tombe unoopasiv sen naale hôôk Elisabet alopayôô-to vaake yi, tonde Vavi Vaambuung hôôvu Elisabet ");
INSERT INTO mmo_vpl VALUES ("LK1_42","072_1_42","LUK","1","42","42","+ o 1:42 Diu 28:4*om nêêl lava bopaata nambe, “Anutu wiing samu samu vu hong savok vêêh-aso pin, tonde unoopasiv sen naale hôôk galompayôô-ja ond yik Anutu le samu yi gaving. ");
INSERT INTO mmo_vpl VALUES ("LK1_43","072_1_43","LUK","1","43","43","De sa vaati ondeey sate Omaaho Bop tangganaan laam vu saa-jo? ");
INSERT INTO mmo_vpl VALUES ("LK1_44","072_1_44","LUK","1","44","44","Angge, sa hango olavam atombe unoopasiv sen naale hôôk sa baambungg-ato pêêlis-ambe vaake sa. ");
INSERT INTO mmo_vpl VALUES ("LK1_45","072_1_45","LUK","1","45","45","+ o 1:45 Luk 1:20*Gakam vasa in gawii-having vakasin pin sen Omaaho Bop nêêl vu hong lung la nambe le nôôn jak-ato.” ");
INSERT INTO mmo_vpl VALUES ("LK1_46","072_1_46","LUK","1","46","46","+ o 1:46 1Sml 2:1-10*Tombe Malia nêêl nambe, “Sa longgpayo nako Omaaho Bop ak, ");
INSERT INTO mmo_vpl VALUES ("LK1_47","072_1_47","LUK","1","47","47","tonde sa kanungg napêêlis vu sate Anutu sen nahôôvu saa-to ");
INSERT INTO mmo_vpl VALUES ("LK1_48","072_1_48","LUK","1","48","48","+ o 1:48 Luk 1:25; 11:27*in yite vêêh kul malis ti sa, lemu yoo ka vu sa. Om gêên-anjo de vu taamusin, hil vu taaku pin e daanêêl naambe Anutu wiing samu samu vu sa. ");
INSERT INTO mmo_vpl VALUES ("LK1_49","072_1_49","LUK","1","49","49","In Anutu sen niwêêk lôôt-ato ond yoo wiing va bopaata vu sa, ond yoo haale vaambuung, ");
INSERT INTO mmo_vpl VALUES ("LK1_50","072_1_50","LUK","1","50","50","+ o 1:50 Saam 103:13,17*de yoo ka pasiv in hil pin sen dayêênin yii-to, vu bôôy-ambe vu taamusin, de nalak busin pin. ");
INSERT INTO mmo_vpl VALUES ("LK1_51","072_1_51","LUK","1","51","51","+ o 1:51 2Sml 22:28*Tonde nama yoo nawiing kul aniwêêk, de hil sen yoo datee sil ak-ato ond hatiiy sil-ambe lavuuh taale osin kand hateesin, ");
INSERT INTO mmo_vpl VALUES ("LK1_52","072_1_52","LUK","1","52","52","+ o 1:52 Iyop 12:19; 5:11; Saam 147:6*de laanggôôl hil alulemak-aso tonde hako hil malis ak. ");
INSERT INTO mmo_vpl VALUES ("LK1_53","072_1_53","LUK","1","53","53","+ o 1:53 1Sml 2:5; Saam 34:10; 107:9*De hil sen dayimb ahend-ato ond vu va nivasa vasa be lohvu sil lôôt, de luus kupak dangga-so be lala namand malis amu. ");
INSERT INTO mmo_vpl VALUES ("LK1_54","072_1_54","LUK","1","54","54","+ o 1:54 Ais 41:8; Saam 98:3*De hôôvu yite noondin Islel-aso, in yoo ka vu yite vakasin ka pasiv-ate ");
INSERT INTO mmo_vpl VALUES ("LK1_55","072_1_55","LUK","1","55","55","+ o 1:55 Mai 7:20; Jen 17:7; 18:18; 22:17*sen nêêl vu yate himbop-aso bôôy nambe le ka pasiv in sil-ato, yik nêêl vu Abalaam osin yite hil sen lanaam vu taamusin-ato be le nanjip danggata.” ");
INSERT INTO mmo_vpl VALUES ("LK1_56","072_1_56","LUK","1","56","56","Malia nêêl lung atonde nando having Elisabet lohvu kwaav yaal, le mem laah baan. ");
INSERT INTO mmo_vpl VALUES ("LK1_57","072_1_57","LUK","1","57","57","Busin sen Elisabet navu gako noow-ato lung la om hako nowaatuk. ");
INSERT INTO mmo_vpl VALUES ("LK1_58","072_1_58","LUK","1","58","58","Tombe Elisabet-ate hil sen sil dangga timu, osin hil sen sil ambaand timuu-to, ond lango banye nambe Omaaho Bop aka pasiv lôôt in Elisabet, om sil lapêêlis having yi. ");
INSERT INTO mmo_vpl VALUES ("LK1_59","072_1_59","LUK","1","59","59","+ o 1:59 Jen 17:12; Lev 12:3; Luk 2:21*Tonde busin namaavaalu be vindak yuuh lung la le mem ti sen tu yaal-ato ond sil lasupin lalaam in galaah unoopasiv aninaavi, tonde lawiingin nambe daateey mangganaan Sakaalia haale jak yi, ");
INSERT INTO mmo_vpl VALUES ("LK1_60","072_1_60","LUK","1","60","60","+ o 1:60 Luk 1:13*le ma de tangganaan nêêl nambe, “Malis, yiiy naateey haale naambe Jon.” ");
INSERT INTO mmo_vpl VALUES ("LK1_61","072_1_61","LUK","1","61","61","Tombe lanêêl vu nambe, “Gate vaheey-ame haalend nambêênja dando le.” ");
INSERT INTO mmo_vpl VALUES ("LK1_62","072_1_62","LUK","1","62","62","Om sil oo motaato lak namand-ambe dalingin mangganaan nambe wiingin nambe daateey yêêv lati jak noow, ");
INSERT INTO mmo_vpl VALUES ("LK1_63","072_1_63","LUK","1","63","63","om taato be lako tapale pasiv ti laam, tombe kaavu nambe, “Haale Jon,” tombe sil pin lavindis lôôt. ");
INSERT INTO mmo_vpl VALUES ("LK1_64","072_1_64","LUK","1","64","64","Tonde pavis atombe Sakaalia avi osin dalaan ahelavis ak laah, de vakaas osin hako Anutu haale lak. ");
INSERT INTO mmo_vpl VALUES ("LK1_65","072_1_65","LUK","1","65","65","Tombe Sakaalia-te hil pin se sil ambaand timuu-to layêênin lôôt, tonde hil oo lakaas in va pin-anjo, de lanêêl banye be la lohvu hil Yuda-te taaku kandu pin. ");
INSERT INTO mmo_vpl VALUES ("LK1_66","072_1_66","LUK","1","66","66","Tombe hil pin sen lango vaa-ju banyêê-to ond kand navu lôôt-ambe lanêêl nambe, “Taamusin e unoopasiv-anjo le naambe vaati?” Lanêêl nambêênju in lalak ni nambe Omaaho Bop-ate niwêêk nando having yi. ");
INSERT INTO mmo_vpl VALUES ("LK1_67","072_1_67","LUK","1","67","67","Tonde Vavi Vaambuung hôôvu mangganaan Sakaalia om nêêl vakasin nôôn langaah nambe, ");
INSERT INTO mmo_vpl VALUES ("LK1_68","072_1_68","LUK","1","68","68","+ o 1:68 Saam 41:13; 72:18; 106:48; Luk 7:16*“Yiiy gako Islel-ate Omaaho Bop Anutu haale jak, in laam in dôôvu yiiy-ambe nôôh yiiy vêêl. ");
INSERT INTO mmo_vpl VALUES ("LK1_69","072_1_69","LUK","1","69","69","+ o 1:69 Saam 18:2*Om holin yite omaaho niwêêk ti kandi vu yite kul vaha Devit-ate hil vu taamusin in nambe dôôvu yiiy-ato, ");
INSERT INTO mmo_vpl VALUES ("LK1_70","072_1_70","LUK","1","70","70","lohvu vakasin sen Anutu yoo wiing-ambe yite hil vaambuung lanêêl langaah bôôy-ato nambe ");
INSERT INTO mmo_vpl VALUES ("LK1_71","072_1_71","LUK","1","71","71","+ o 1:71 Saam 106:10*le nôôh yiiy vêêl in yate vaavis-aso namand, osin nôôh yiiy vêêl in hil sen ahend kalin lôôt vu yiiy-ato. ");
INSERT INTO mmo_vpl VALUES ("LK1_72","072_1_72","LUK","1","72","72","+ o 1:72 Jen 17:7; Lev 26:42; Saam 105:8-9; 106:45*In ka pasiv in yate himbop-aso bôôy, osin yoo ka navu yite vakasin vaambuung sen jôôy bôôy-ato, ");
INSERT INTO mmo_vpl VALUES ("LK1_73","072_1_73","LUK","1","73","73","+ o 1:73 Jen 22:16-17; Mai 7:20*in nêêl osin vakasin keen vu yate himbop Abalaam, om navu biing nohvu sen nêêl bôôy-ato nambe ");
INSERT INTO mmo_vpl VALUES ("LK1_74","072_1_74","LUK","1","74","74","le nôôh yiiy vêêl in yate vaavis-aso namand, in nambe yaanohak vu yi, de yame le aanjêênin e, ");
INSERT INTO mmo_vpl VALUES ("LK1_75","072_1_75","LUK","1","75","75","+ o 1:75 Tit 2:12-14*tombe yiiy naatu yite hil vaambuung osin hil anivalok jak busin pin. ");
INSERT INTO mmo_vpl VALUES ("LK1_76","072_1_76","LUK","1","76","76","+ o 1:76 Ais 40:3; Mal 3:1; Mat 3:3*Tonde hong unoopasiv-anjo, ond hil e daanêêl hong naambe Anutu Baandoni-te omaaho sen nanêêl yite vakasin langaah-ato, in gale naamunggin in samu Omaaho Bop-ate mopaatôôv, ");
INSERT INTO mmo_vpl VALUES ("LK1_77","072_1_77","LUK","1","77","77","+ o 1:77 Jer 31:34*de gale naanêêl vu yite hil in lanjak ni naambe kawiiy silate nipaya na, ond mem le gako sil nom. ");
INSERT INTO mmo_vpl VALUES ("LK1_78","072_1_78","LUK","1","78","78","+ o 1:78 Ais 60:1-2*Yate Anutu sen yoo ka pasiv bopaata lôôt-ato ond yoo le biing melangaah baandoni dukanaam vu yiiy, ");
INSERT INTO mmo_vpl VALUES ("LK1_79","072_1_79","LUK","1","79","79","+ o 1:79 Ais 9:2; 58:8; Mat 4:16*in naatum melangaah vu hil sen dando hôôk mekanuu-to, tonde naatum vu hil sen dayêênin nambe davu lanjimb-ambe lana mend namaa-to, tonde taato mop sen yalonggpayo melaas-atêêto vu yiiy in nambe yiiy sapa.” ");
INSERT INTO mmo_vpl VALUES ("LK1_80","072_1_80","LUK","1","80","80","+ o 1:80 Luk 2:40; Mat 3:1*Lung atonde dando be unoopasiv-anjo bop ak-ambe lopayo la vu Anutu niwêêk, le mem la nando taaku lumbalaamb lôôt-ambe la valup busin sen-ato, le mem tok lom-ambe taato yi vu hil Islel. ");
INSERT INTO mmo_vpl VALUES ("LK2_1","072_2_1","LUK","2","1","1","Hôôk busin-anju hil Lom-ate yêêv bop Sisa Ogastas nêêl nambe sil kaavu omaahonôôn pin haalend. ");
INSERT INTO mmo_vpl VALUES ("LK2_2","072_2_2","LUK","2","2","2","Kul-anjo lako lak nyendoos hôôk busin sen Sailinias tu yêêv bop-ambe nanggin Siliaa-to, ");
INSERT INTO mmo_vpl VALUES ("LK2_3","072_2_3","LUK","2","3","3","om hil pin lalaah sil ambaand dangga dosin ti ti in nambe kaavu sil haalend. ");
INSERT INTO mmo_vpl VALUES ("LK2_4","072_2_4","LUK","2","4","4","Tombe Yusep kandi vu bayêên Nasaalet vu Galili be la valup Yudia-te bayêên bop sen Devit ambaan bôôy-ato, danêêl nambe Betlehem, in Yusep-ate danggakook neep vu Devit. ");
INSERT INTO mmo_vpl VALUES ("LK2_5","072_2_5","LUK","2","5","5","+ o 2:5 Luk 1:27*Om yuuh vane Malia lala in kaavu yuuh haalend, tonde Malia noow hôôk. ");
INSERT INTO mmo_vpl VALUES ("LK2_6","072_2_6","LUK","2","6","6","Yuuh lala dandôô-ju be ngaaho lak in Malia gako noow, ");
INSERT INTO mmo_vpl VALUES ("LK2_7","072_2_7","LUK","2","7","7","tombe Malia hako nowaatuk-ambe vayum hôôk tôômb-ambe hambe neep hôôk bik-asote kaambum, in omaahonôôn lahilin bayêên vaatêêvak-ate de taaku vuun ti me-neep e. ");
INSERT INTO mmo_vpl VALUES ("LK2_8","072_2_8","LUK","2","8","8","Vu taakuu-ju vaheey mondanggin bik sipsip vu paahup alo hôôk busin, ");
INSERT INTO mmo_vpl VALUES ("LK2_9","072_2_9","LUK","2","9","9","tonde Omaaho Bop-ate angela la hato vu sil, de Omaaho Bop-ate nikaapulis têêlang-ambe lohvu sil pin, tombe sil layêênin lôôt, ");
INSERT INTO mmo_vpl VALUES ("LK2_10","072_2_10","LUK","2","10","10","lemu angela nêêl vu sil nambe, “Ham-ame anjêênin e. Ham gango, sa laam in naanêêl banye nivasa ti naas vu ham, tombe hil pin davu daapêêlis lôôt. ");
INSERT INTO mmo_vpl VALUES ("LK2_11","072_2_11","LUK","2","11","11","In gêên-anjo vêêh ti hako noow neep Devit-ate taaku Betlehem, ond hamate omaaho sen ham natung mem in nambe dôôvu ham-ato, in yi omaaho sen Anutu yoo holin yi vulôôt-ato osin yi Omaaho Bop. ");
INSERT INTO mmo_vpl VALUES ("LK2_12","072_2_12","LUK","2","12","12","Om ham ana gato be ham anjak ni naambe vakasin-anjo keen, in ham e angge naambe sil layum unoopasiv ti hôôk tôômb-ambe lambe neep hôôk bik-asote kaambum.” ");
INSERT INTO mmo_vpl VALUES ("LK2_13","072_2_13","LUK","2","13","13","Angela nêêl nambêênju, tonde pavis atombe hil baandoni ngeeyaata lôôt lato daale having angela tii-jôôto, be lavand hôôk Anutu nambe, ");
INSERT INTO mmo_vpl VALUES ("LK2_14","072_2_14","LUK","2","14","14","+ o 2:14 Luk 19:38*“Yiiy gako Anutu haale jak vu baandoni, tonde vakasin melaas nanjip vu hil sen Anutu nayi sil anivasaa-to.” ");
INSERT INTO mmo_vpl VALUES ("LK2_15","072_2_15","LUK","2","15","15","Angela lavuuh sil-ande lalaah baandoni lung la, le mem bik sipsip-ate heendin-aso lanêêl nambe, “Ham-o, yana Betlehem-ambe yaangge va sen gêên Omaaho Bop nêêl banye vu yiiy-anjôôto le.” ");
INSERT INTO mmo_vpl VALUES ("LK2_16","072_2_16","LUK","2","16","16","Om sil kandi pavis-ambe lala lalup atombe latovu Malia yuuh Yusep dando, tonde unoopasiv neep hôôk bik-asote kaambum. ");
INSERT INTO mmo_vpl VALUES ("LK2_17","072_2_17","LUK","2","17","17","+ o 2:17 Luk 2:10-12*Layi lung la tonde latulin vakasin sen lango lak unoopasiv-ato vu yuuh. ");
INSERT INTO mmo_vpl VALUES ("LK2_18","072_2_18","LUK","2","18","18","Tombe hil pin sen lango vakasin-anjuuto, ond lavindis lôôt in vakasin sen bik sipsip-ate heendin-aso lanêêl-ato, ");
INSERT INTO mmo_vpl VALUES ("LK2_19","072_2_19","LUK","2","19","19","+ o 2:19 Luk 2:51*lemu Malia samu vakasin pin-anjo hôôk lopayo be ka yoo monavu nando. ");
INSERT INTO mmo_vpl VALUES ("LK2_20","072_2_20","LUK","2","20","20","Lung atonde sipsip-ate heendin-aso lalaah, tombe lako Omaaho Bop haale lak, de lavand hôôk Anutu in va pin sen lango osin layi ond nôôn ak lohvu angela nêêl vu sil-ato. ");
INSERT INTO mmo_vpl VALUES ("LK2_21","072_2_21","LUK","2","21","21","+ o 2:21 Luk 1:31,59*Busin namaavaalu be vindak yaal lung la le mem lalaah unoopasiv aninaavi, de lateey haale Yesu sen bôôy me-naale hôôk tangganaan alopayo le de naahen, tonde angela nêêl nambe Yesuu-to. ");
INSERT INTO mmo_vpl VALUES ("LK2_22","072_2_22","LUK","2","22","22","+ o 2:22 Lev 12:1-8*Busin sen Malia yuuh Yusep samu yuuh anind naavi nohvu Mose-te tanasin-ato lung la, om yuuh lako Yesu be lala Yelusalem in lambu dukana Omaaho Bop nama. ");
INSERT INTO mmo_vpl VALUES ("LK2_23","072_2_23","LUK","2","23","23","+ o 2:23 Eks 13:2,12,15*Lawiing lohvu Omaaho Bop-ate tanasin sen sil kaavu bôôy-ambe neep-ato nambe, “Unoopasiv tuk pin sen taandin dako sil namunggin-ato ond ham angge sil naambe Omaaho Bop-ate va vaambuung.” ");
INSERT INTO mmo_vpl VALUES ("LK2_24","072_2_24","LUK","2","24","24","+ o 2:24 Lev 12:8*Om yik Malia yuuh Yusep lala in nambe gatung salivangin gaving, nohvu Omaaho Bop-ate tanasin nêêl nambe, “Ham gatung manak tumbaliiy yuuh, me manak bavi noow yuuh naatu salivangin vu Anutu.” ");
INSERT INTO mmo_vpl VALUES ("LK2_25","072_2_25","LUK","2","25","25","+ o 2:25 Ais 40:1; Ais 49:13*Tonde sim omaaho ti nando Yelusalem, haale nambe Simeon, ond omaaho nivalok de omaaho sen yoo nalohak vu Anutu, ond monanggin busin sen Anutu nôôh nimeen vêêl in Islel-ato, ond Vavi Vaambuung hôôvu yi, ");
INSERT INTO mmo_vpl VALUES ("LK2_26","072_2_26","LUK","2","26","26","tonde Vavi Vaambuung yoo nêêl vu bôôy nambe me-le jimb pavis e, yoo ji me lak Omaaho Bop-ate omaaho sen yoo holin yi vulôôt in nambe dôôvu yiiy-ato le mem. ");
INSERT INTO mmo_vpl VALUES ("LK2_27","072_2_27","LUK","2","27","27","Om Vavi Vaambuung giiy yi be la Anutu-te dumb bop alo, tonde sim Yusep ayuuh Malia lako unoopasiv Yesu be lala lalup-ambe lahuli-lala dumb alo, in lambiing va vu yi nohvu tanasin neep-ato, ");
INSERT INTO mmo_vpl VALUES ("LK2_28","072_2_28","LUK","2","28","28","tomem Simeon kava Yesu lak-ande pêêlis la vu Anutu nambe, ");
INSERT INTO mmo_vpl VALUES ("LK2_29","072_2_29","LUK","2","29","29","“O Omaaho Bop, gêên onaateey gate hil kul vaha malis sa be sa naas osin sa longgpayo melaas nohvu goo ganêêl bôôy-ato. ");
INSERT INTO mmo_vpl VALUES ("LK2_30","072_2_30","LUK","2","30","30","+ o 2:30 Ais 52:10; Luk 3:6; Tit 2:11*In saahe mengg ak va sen gawiing in nambe dôôvu hey-ato lung la. ");
INSERT INTO mmo_vpl VALUES ("LK2_31","072_2_31","LUK","2","31","31","Goo samu vaa-ja neep langaah hôôk omaahonôôn pin amend. ");
INSERT INTO mmo_vpl VALUES ("LK2_32","072_2_32","LUK","2","32","32","+ o 2:32 Ais 42:6; 49:6*Tombe yii-ju tu kin tumin in nambe le bu melangaah vu hil vaalu sen sil-ame Yudaa-to, osin biing-ambe gate hil Islel haalend naatu bopaata.” ");
INSERT INTO mmo_vpl VALUES ("LK2_33","072_2_33","LUK","2","33","33","Simeon nêêl nambêênju lak Yesu, tomem Yesu mangganaan ayuuh tangganaan lavindis lôôt. ");
INSERT INTO mmo_vpl VALUES ("LK2_34","072_2_34","LUK","2","34","34","+ o 2:34 Ais 8:14; Mat 21:42-44; 1Ko 1:23; 1Pi 2:8*Tonde Simeon lohak yaal-ande nêêl vu Yesu tangganaan Malia nambe, “Angge, unoopasiv-anjo ond Anutu holin in nambe biing-ambe Islel ngeeyaata landupake, de biing-ambe hil ngeeyaata kandi jak. Tonde le taato Anutu-te va vu hil, le hil ngeeyaata le daanêêl vakasin anipaya jak yi, ");
INSERT INTO mmo_vpl VALUES ("LK2_35","072_2_35","LUK","2","35","35","in nambe omaahôô-ja biing-ambe hil ngeeyaata-te vakasin sen kand navu hôôk londpayôô-to naatok naam langaah, tonde galompayo le nimeen gaving.” ");
INSERT INTO mmo_vpl VALUES ("LK2_36","072_2_36","LUK","2","36","36","Lung atonde vêêh ti nando, haale nambe Ana, ond hil sen danêêl Anutu-te vakasin langaah-ato ti yi, de mangganaan haale nambe Panuel, de yuuhate danggakook neep vu Asel. Anaa-ju tata lak lôôt, in bôôy ond lak moow-ambe nando having laya lohvu ta namaavaalu be vindak yuuh, ");
INSERT INTO mmo_vpl VALUES ("LK2_37","072_2_37","LUK","2","37","37","+ o 2:37 1Ti 5:5*tombe laya yimb-ande yoo tu vehaahôôv-ambe nando be tata lak. Tombe yite ta ngeeyaata lôôt lohvu 84, lemu me-havuuh Anutu-te dumb bop e, de nimbaya in vanôôn in nambe nohak vu Anutu, om yoo nalohak vu Anutu hôôk busin-ande langaah nalak busin pin. ");
INSERT INTO mmo_vpl VALUES ("LK2_38","072_2_38","LUK","2","38","38","+ o 2:38 Ais 52:9*Ond hôôk busin sen Yusep ayuuh Malia lako Yesu la dumb bop alôô-to, ond Ana valup pavis-ambe pêêlis la vu Anutu, de tatekin unoopasiv-anju yite vakasin vu hil pin sen mondanggin in nambe Anutu nôôh nimeen vêêl in Yelusalem-ato. ");
INSERT INTO mmo_vpl VALUES ("LK2_39","072_2_39","LUK","2","39","39","+ o 2:39 Mat 2:23*Malia yuuh Yusep samu va pin lohvu Omaaho Bop-ate tanasin nêêl-ato lung la, le mem yaal lalaah lalup Galili-te taaku, be yaal lala dando yaal ambaand Nasaalet. ");
INSERT INTO mmo_vpl VALUES ("LK2_40","072_2_40","LUK","2","40","40","+ o 2:40 Luk 1:80; 2:52*Tonde unoopasiv linj-ambe bop ak atombe yoo lak va pin ani nivasa lôôt, tombe nando hôôk Anutu-te samu samu lopayo. ");
INSERT INTO mmo_vpl VALUES ("LK2_41","072_2_41","LUK","2","41","41","+ o 2:41 Eks 12:24-27; 23:14-17; Diu 16:1-8*Lohvu ta pin Yesu mangganaan ayuuh tangganaan dala Yelusalem, in dayi busin bop busin haluusin sen Anutu haluuh hil Islel hôôk vu Ijip bôôy-ato. ");
INSERT INTO mmo_vpl VALUES ("LK2_42","072_2_42","LUK","2","42","42","Tonde Yesu-te ta nomaayuuh-ambe laam yuuh lung la, om yaal lala lalup Yelusalem in lanji busin bop-anju, yik nambe sen yoo dala lak ta pin-ato. ");
INSERT INTO mmo_vpl VALUES ("LK2_43","072_2_43","LUK","2","43","43","+ o 2:43 Eks 12:18*Layi busin bop-anju lung la de sil lalaah, lemu Yesu yoo naahen nando Yelusalem, le mangganaan ayuuh tangganaan doosin yi, ");
INSERT INTO mmo_vpl VALUES ("LK2_44","072_2_44","LUK","2","44","44","in yuuh akand vu nambe la having silate hil vaalu. Om hôôk busin tii-ju yuuh mosalo yi tatuuvu mopaatôôv vu yuuhate hil osin nipaapu-so, ");
INSERT INTO mmo_vpl VALUES ("LK2_45","072_2_45","LUK","2","45","45","le ma de yuuh-ame latovu le, om yuuh oo mosalo be lalaah lalup Yelusalem. ");
INSERT INTO mmo_vpl VALUES ("LK2_46","072_2_46","LUK","2","46","46","Tombe yuuh oo mosalo yi lôôt lohvu busin yaal, le mem yuuh latovu yi lukando tanasin dangga-so lavuun vu Anutu-te dumb bop alo. Yoo monangoyin silate vakasin-ambe nalingin danggakook vu sil having, ");
INSERT INTO mmo_vpl VALUES ("LK2_47","072_2_47","LUK","2","47","47","tombe hil pin sen dango yite vakasin-anjuuto ond lavindis lôôt in ka osin vakasin sen nanêêl laah vu sil-ato. ");
INSERT INTO mmo_vpl VALUES ("LK2_48","072_2_48","LUK","2","48","48","Malia yuuh Yusep latokak yi tombe yuuh lavindis lôôt, tombe tangganaan nêêl vu nambe, “Tuk-e, nambe vaati sen gawiing nambêênjo vu haay mom-anjo? Haay alonggpayo nimeen-ande haay oo mosalo hong lôôt.” ");
INSERT INTO mmo_vpl VALUES ("LK2_49","072_2_49","LUK","2","49","49","+ o 2:49 Jon 2:16*Le nêêl laah vu yuuh nambe, “Nambe vaati sen muuh navu salo saa-jo? Mak mame alak ni nambe soo le mando hôôk Mangg-ate bayêên-anjo le?” ");
INSERT INTO mmo_vpl VALUES ("LK2_50","072_2_50","LUK","2","50","50","Lemu yuuh doosin vakasin sen nêêl vu yuuh-anjuuto danggakook, ");
INSERT INTO mmo_vpl VALUES ("LK2_51","072_2_51","LUK","2","51","51","+ o 2:51 Luk 2:19*tombe la having yuuh-ambe yaal lalaah lato Nasaalet. Tonde yik lak busin pin ond yoo nanye vuun in yuuh lavand, tombe tangganaan samu va pin-anjo neep hôôk lopayo be ka monavu nando. ");
INSERT INTO mmo_vpl VALUES ("LK2_52","072_2_52","LUK","2","52","52","+ o 2:52 1Sml 2:26; Pro 3:4; Luk 1:80*Yesu bop ak atombe tu omaaho lukook bop, tombe Anutu osin omaahonôôn layi yi nivasa. ");
INSERT INTO mmo_vpl VALUES ("LK3_1","072_3_1","LUK","3","1","1","Busin sen Taibilias tu Lom-ate yêêv bop Sisa be nanggin sil-ambe la valup ta nomaayuuh-ambe laam namaavaalu, tombe nêêl-ambe Pontias Pilata tu yêêv bop-ambe nanggin hil Yuda, tonde Helot tu yêêv bop-ambe nanggin hil Galili, de hali Pilip tu yêêv bop-ambe nanggin hil Itulia osin hil Talakonaitis. Tonde Laisenias tu yêêv-ambe nanggin hil Abilini, ");
INSERT INTO mmo_vpl VALUES ("LK3_2","072_3_2","LUK","3","2","2","+ o 3:2 Luk 1:80*tonde Anas ayuuh Kaiapas latu yêêv bop vu kul vaha sen datung salivangin-ato, ond hôôk busin-anju Sakaalia-te noow Jon nando taaku lumbalaamb tombe Anutu-te vakasin laam vu, ");
INSERT INTO mmo_vpl VALUES ("LK3_3","072_3_3","LUK","3","3","3","+ o 3:3 Sin 13:24; 19:4*om la hatup hôôk lohvu taaku pin sen neep ngaaho vu bel bop Yoladan-ato be nanêêl tanasin nambe hil langgilin londpayo be lanjipis bel in nambe Anutu kawiiy silate nipaya na. ");
INSERT INTO mmo_vpl VALUES ("LK3_4","072_3_4","LUK","3","4","4","+ o 3:4-6 Ais 40:3-5*Lohvu Yesaia nêêl vakasin lak Jon munggin-ambe neep hôôk kaapiyaa-to nambe, “Omaaho ti nateey vu taaku lumbalaamb nambe, ‘Ham samu Omaaho Bop-ate mop, ham galo yite mop nanjip nivalok.’ ");
INSERT INTO mmo_vpl VALUES ("LK3_5","072_3_5","LUK","3","5","5","Le baahu taaku metokin pin-ambe naatu doos jak, de le daav kandu bop osin pasiv pin gaving-ambe naatu taambut jak, tonde mopaatôôv pin sen nivanjusin-ato ond le nivalok jak. De mopaatôôv pin sen tatuuh nandôô-to ond le nanjip nivasa, ");
INSERT INTO mmo_vpl VALUES ("LK3_6","072_3_6","LUK","3","6","6","+ o 3:6 Luk 2:30-31; Tit 2:11*tombe hil pin davu lanji mend ak kul sen Anutu nawiing in nambe dôôvu yiiy-ato.” ");
INSERT INTO mmo_vpl VALUES ("LK3_7","072_3_7","LUK","3","7","7","+ o 3:7 Mat 12:34; 23:33*Tombe hil ngeeyaata lalaam lôôt in nambe Jon jipis sil, tombe Jon nêêl vu sil nambe, “Nyêêy anipaya noondin ham. Lati nêêl vu ham? Ham-ame alohvu nambe ham napak in Anutu-te ahekalin sen le naatok naam vu taamusin-ato le. ");
INSERT INTO mmo_vpl VALUES ("LK3_8","072_3_8","LUK","3","8","8","+ o 3:8 Jon 8:33,39*Om ham anggilin ham alompayo be ham ambiing va nivasa in yanjak ni naambe ham ahilin ham vasa ond mem. Hamambe hamate danggakook neep vu Abalaam om Anutu le ji ham nivasa? Malis. Sa naanêêl vu ham naambe Anutu lohvu nambe jêêvu tatuuh-anjo be daatu Abalaam-ate hil. ");
INSERT INTO mmo_vpl VALUES ("LK3_9","072_3_9","LUK","3","9","9","+ o 3:9 Mat 7:19; Jon 15:6*Kôôv navu neep nandeng haah dangga lung la, om haah pin sen me-nayiis nôôn anivasaa-to ond le buv-ambe gaate jakana kin.” ");
INSERT INTO mmo_vpl VALUES ("LK3_10","072_3_10","LUK","3","10","10","Jon nêêl nambêênju tombe hil ngeeyaataa-ju lalingin nambe, “Om hey e aambiing vaati?” ");
INSERT INTO mmo_vpl VALUES ("LK3_11","072_3_11","LUK","3","11","11","Tombe nêêl laah vu sil nambe, “Omaaho ti-te lolop yuuh nando ond bu ango vu omaaho sen lolop maa-to, tonde omaaho ti-te vanôôn nando ond yik bu vaalu vu omaaho sen nativak in vanôôn-ato.” ");
INSERT INTO mmo_vpl VALUES ("LK3_12","072_3_12","LUK","3","12","12","+ o 3:12 Luk 7:29*Tonde hil sen dako taakis-ato heey lalup in nambe Jon jipis sil gaving, tombe lalingin Jon nambe, “Kaputung, hey e aambiing vaati?” ");
INSERT INTO mmo_vpl VALUES ("LK3_13","072_3_13","LUK","3","13","13","Le nêêl vu sil nambe, “Ham oo gako mone nohvu gaaman danêêl-ato de ham-ame gako heey savok na le.” ");
INSERT INTO mmo_vpl VALUES ("LK3_14","072_3_14","LUK","3","14","14","Tonde yik hil ngaamong vaha-so heey lalingin nambe, “De hey ond hey e aambiing vaati?” Tombe nêêl vu sil nambe, “Ham-ame anyiis hil osin ham-ame tatuhin vakasin ak sil in nambe lambu mone vu ham e. Yik mone sen ham nako lak hamate kul-ato ond ham gako mu be lung, de vakasin nama.” ");
INSERT INTO mmo_vpl VALUES ("LK3_15","072_3_15","LUK","3","15","15","Tombe hil pin nahand nalak-ambe kand navu vakasin ak Jon hôôk sil alondpayo lôôt nambe, “Mak peey e Jon-anju yi omaaho sen Anutu yoo holin yi vulôôt in nambe dôôvu yiiy-ato.” ");
INSERT INTO mmo_vpl VALUES ("LK3_16","072_3_16","LUK","3","16","16","+ o 3:16 Sin 13:25*Om Jon nêêl laah vu sil nambe, “Sa naalipis ham ak bel amu, nganjo omaaho ti navu taamuyin sa ond yite niwêêk savok sa. Sak sa omaaho nipaya, same sa ningg vasa in nambe sa kavaayin yite suul osin saambiing kul vaalu naambe hil kul-aso dawiing vu silate yêêv e. Omaahôô-ju ond le biing-ambe ham anim vasa jak Vavi Vaambuung-ate niwêêk osin kin sen ja hamate nipayaa-to. ");
INSERT INTO mmo_vpl VALUES ("LK3_17","072_3_17","LUK","3","17","17","Puvu yite haah navu salak hôôk nama lung la in nambe japêêh kaalekaale na, le mem naasupin vanôôn nôôn dukana bayêên vanôôn-ate, tonde vanôôn naavi osin ahesa ond le basi jakana kin ti yoo monatum danggata.” ");
INSERT INTO mmo_vpl VALUES ("LK3_18","072_3_18","LUK","3","18","18","Jon nêêl tanasin vaalu ngeeyaata having in nambe bêêl sil akand jak, osin monanêêl banye nivasa vu hil. ");
INSERT INTO mmo_vpl VALUES ("LK3_19","072_3_19","LUK","3","19","19","+ o 3:19 Mat 14:3-4; Mak 6:17-18*Tonde busin ti tombe Jon nêêl yêêv bop Helot in dangga nambe Helot hali Pilip ond Helot lakin vane Helodias, tonde va nipaya vaalu sen Helot wiing-ato neep having. ");
INSERT INTO mmo_vpl VALUES ("LK3_20","072_3_20","LUK","3","20","20","Tombe Helot-ate nipaya pin-anju neep, tonde taamusin atombe wiing nipaya ti lukala having nambe hatung Jon hôôk kalaambus malis amu. ");
INSERT INTO mmo_vpl VALUES ("LK3_21","072_3_21","LUK","3","21","21","Hil pin mondalipis bel tombe yik Yesu lipis bel having. Lipis bel lung la tonde monalohak atombe baandoni kahe, ");
INSERT INTO mmo_vpl VALUES ("LK3_22","072_3_22","LUK","3","22","22","+ o 3:22 Mat 17:5; Luk 9:35; Jon 1:32; 2Pi 1:17*tonde Vavi Vaambuung ani nambe manak tumbaliiy-ambe hato lakando yi, tonde lava ti laam vu baandoni nambe, “Sa Noongg hong. Sahengg having hong osin sahengg anivasa vu hong.” ");
INSERT INTO mmo_vpl VALUES ("LK3_23","072_3_23","LUK","3","23","23","+ o 3:23 Luk 4:22; Jon 6:42*Busin sen Yesu hako kul ak-ato ond yite ta lohvu doo-ti be nomaayuuh, tombe hil lanêêl yi nambe Yusep noow. Tonde Yusep ond Hilai noow, ");
INSERT INTO mmo_vpl VALUES ("LK3_24","072_3_24","LUK","3","24","24","de Hilai ond Matat noow, de Matat ond Liwi noow, de Liwi ond Melkai noow, de Melkai ond Janai noow, de Janai ond Yusep noow. ");
INSERT INTO mmo_vpl VALUES ("LK3_25","072_3_25","LUK","3","25","25","Tonde Yusep-anju Matataias noow, de Matataias ond Amos noow, de Amos ond Neam noow, de Neam ond Eslai noow, de Eslai ond Nagai noow. ");
INSERT INTO mmo_vpl VALUES ("LK3_26","072_3_26","LUK","3","26","26","Tonde Nagaii-ju Maat noow, de Maat ond Matataias noow, de Matataias-anju ond Semen noow, de Semen ond Josek noow, de Josek ond Joda noow. ");
INSERT INTO mmo_vpl VALUES ("LK3_27","072_3_27","LUK","3","27","27","+ o 3:27 1Kro 3:17,19; Esra 3:2*Tonde Jodaa-ju ond Joanan noow, de Joanan ond Lesa noow, de Lesa ond Selababel noow, de Selababel ond Sialtiel noow, de Sialtiel-anju Nelai noow. ");
INSERT INTO mmo_vpl VALUES ("LK3_28","072_3_28","LUK","3","28","28","Tonde Nelai ond Melkai noow, de Melkai ond Edai noow, de Edai ond Kosam noow, de Kosam ond Elmadam noow, de Elmadam ond El noow. ");
INSERT INTO mmo_vpl VALUES ("LK3_29","072_3_29","LUK","3","29","29","Tonde El-anju Yosua noow, de Yosua ond Eliesa noow, de Eliesa ond Jolim noow, de Jolim ond Matat noow, de Matat ond Liwi noow. ");
INSERT INTO mmo_vpl VALUES ("LK3_30","072_3_30","LUK","3","30","30","Tonde Liwii-ju Simeon noow, de Simeon ond Yuda noow, de Yuda ond Yusep noow, de Yusep-anju ond Jonam noow, de Jonam ond Elaiakim noow. ");
INSERT INTO mmo_vpl VALUES ("LK3_31","072_3_31","LUK","3","31","31","+ o 3:31 2Sml 5:14*Tonde Elaiakim-anju Melia noow, de Melia ond Mena noow, de Mena ond Matata noow, de Matata ond Naatan noow, de Naatan ond Devit noow. ");
INSERT INTO mmo_vpl VALUES ("LK3_32","072_3_32","LUK","3","32","32","+ o 3:32 1Sml 16:1,13; Rut 4:17-22*Tonde Devit-anju Jesi noow, de Jesi ond Obet noow, de Obet ond Boas noow, de Boas ond Salmon noow, de Salmon ond Naason noow. ");
INSERT INTO mmo_vpl VALUES ("LK3_33","072_3_33","LUK","3","33","33","+ o 3:33 Jen 29:35*Tonde Naason-anju Aminadap noow, de Aminadap ond Atmin noow, de Atmin ond Anai noow, de Anai ond Heslon noow, de Heslon ond Peles noow, de Peles ond Yuda noow. ");
INSERT INTO mmo_vpl VALUES ("LK3_34","072_3_34","LUK","3","34","34","+ o 3:34 Jen 21:3; 25:26*Tonde Yudaa-ju Yaakop noow, de Yaakop ond Isak noow, de Isak ond Abalaam noow, de Abalaam ond Tela noow, de Tela ond Neho noow. ");
INSERT INTO mmo_vpl VALUES ("LK3_35","072_3_35","LUK","3","35","35","Tonde Nehôô-ju Seluk noow, de Seluk ond Leyu noow, de Leyu ond Pelek noow, de Pelek ond Ebe noow, de Ebe ond Sela noow. ");
INSERT INTO mmo_vpl VALUES ("LK3_36","072_3_36","LUK","3","36","36","+ o 3:36 Jen 11:10-26*Tonde Selaa-ju Kainan noow, de Kainan ond Apaksat noow, de Apaksat ond Sem noow, de Sem ond Noa noow, de Noa ond Lamek noow. ");
INSERT INTO mmo_vpl VALUES ("LK3_37","072_3_37","LUK","3","37","37","Tonde Lamek-anju Metusala noow, de Metusala ond Enok noow, de Enok ond Jalet noow, de Jalet ond Mahalalel noow, de Mahalalel ond Kainan noow. ");
INSERT INTO mmo_vpl VALUES ("LK3_38","072_3_38","LUK","3","38","38","+ o 3:38 Jen 4:25–5:32*Tonde Kainan-anju Inos noow, de Inos ond Set noow, de Set ond Adam noow, tonde Adam ond Anutu noow. ");
INSERT INTO mmo_vpl VALUES ("LK4_1","072_4_1","LUK","4","1","1","Vavi Vaambuung hôôvu Yesu tonde Yesu vu bel Yoladan-ambe laah, tombe Vavi Vaambuung giiy-ambe la taaku lumbalaamb. ");
INSERT INTO mmo_vpl VALUES ("LK4_2","072_4_2","LUK","4","2","2","+ o 4:2 Hiblu 4:15*Tombe Yesu la nando taaku lumbalaamb-anju lohvu busin doo-yuuh-ambe Saalang mosahi yi, de me-ya vanôôn daka le. Lung laa tonde yimb ahe lôôt, ");
INSERT INTO mmo_vpl VALUES ("LK4_3","072_4_3","LUK","4","3","3","om Saalang nêêl vu nambe, “Naambe Anutu Noow hong ond onaanêêl-ambe tatuuh-anjo naatu vanôôn.” ");
INSERT INTO mmo_vpl VALUES ("LK4_4","072_4_4","LUK","4","4","4","+ o 4:4 Diu 8:3*Le Yesu nêêl laah vu nambe, “Malis, in Anutu-te vakasin neep hôôk kaapiya nambe, ‘Vanôôn timu me-napuvu omaahonôôn e.’” ");
INSERT INTO mmo_vpl VALUES ("LK4_5","072_4_5","LUK","4","5","5","Tonde Saalang hako Yesu be yuuh lalakala taaku ti, tonde pavis atombe motaato hil pin-ate taaku vu voon vu Yesu, ");
INSERT INTO mmo_vpl VALUES ("LK4_6","072_4_6","LUK","4","6","6","+ o 4:6 Mat 28:18*tonde nêêl vu nambe, “Sa navu aambu hil pin-ate taakuu-ju osin silate va nivasa vasa pin vu hong in nambe onaatu danggakook-ambe ongganggin va pin-anju, ond lukala sa namangg lung la, om sa kangg bu naambe saambu vu omaaho ti ond sale aambu. ");
INSERT INTO mmo_vpl VALUES ("LK4_7","072_4_7","LUK","4","7","7","Om naambe onggatung kaatu vu sa osin onggako sa haalengg jak ond va pin-anju le naatu gate va.” ");
INSERT INTO mmo_vpl VALUES ("LK4_8","072_4_8","LUK","4","8","8","+ o 4:8 Diu 6:13-14*Le ma de Yesu nêêl vu nambe, “Anutu-te vakasin neep hôôk kaapiya nambe, ‘Goo gatung kaatu vu gate Omaaho Bop Anutu, de ganohak vu yi timu.’” ");
INSERT INTO mmo_vpl VALUES ("LK4_9","072_4_9","LUK","4","9","9","Tonde yik Saalang hako Yesu be yuuh lala lalup Yelusalem, tombe la valaah Yesu lakala naale lak Anutu-te dumb bop alu baandoni, de nêêl vu nambe, “Naambe Anutu Noow hong ond opasong vuu-jo be gana kambii-ju, ");
INSERT INTO mmo_vpl VALUES ("LK4_10","072_4_10","LUK","4","10","10","+ o 4:10 Saam 91:11-12*in Anutu-te vakasin neep hôôk kaapiya nambe, ‘Yoo le naanêêl vu yite angela-so in sil ganggin hong nivasa, ");
INSERT INTO mmo_vpl VALUES ("LK4_11","072_4_11","LUK","4","11","11","be lanôôh hong ak sil namand de game le kaatuuh ovaham jak tatuuh e.’” ");
INSERT INTO mmo_vpl VALUES ("LK4_12","072_4_12","LUK","4","12","12","+ o 4:12 Diu 6:16; 1Ko 10:9*Le ma de Yesu nêêl vu nambe, “Anutu-te vakasin neep nambe, ‘Game sahi gate Omaaho Bop Anutu le.’” ");
INSERT INTO mmo_vpl VALUES ("LK4_13","072_4_13","LUK","4","13","13","+ o 4:13 Hiblu 2:18; 4:15*Saalang sahi Yesu lak va pin-anju lung la, tonde havuuh Yesu nambe mando be busango le. ");
INSERT INTO mmo_vpl VALUES ("LK4_14","072_4_14","LUK","4","14","14","Lung laa tonde Yesu laah valup Galili osin Vavi Vaambuung-ate niwêêk lohvu yi, tombe banye la lohvu taakuu-ju pin. ");
INSERT INTO mmo_vpl VALUES ("LK4_15","072_4_15","LUK","4","15","15","Tombe lohvu busin pin yoo monawiing tanasin vu hil hôôk silate dumb alo ti ti, tombe hil pin lako haale lak. ");
INSERT INTO mmo_vpl VALUES ("LK4_16","072_4_16","LUK","4","16","16","Yesu laah valup baan Nasaalet, sen bôôy naahen nipasiv-ande nando taakuu-ju be bop ak-ato, tonde busin sawaasin atombe huli-la dumb alo ti, nambe sen yik yoo nawiing lohvu busin sawaasin pin-ato, tombe kandi naale in nambe naasevin Anutu-te tanasin. ");
INSERT INTO mmo_vpl VALUES ("LK4_17","072_4_17","LUK","4","17","17","Tombe lavu Yesaia-te kaapiya vu be katekin atombe tokak vakasin sen kaavu neep nambe, ");
INSERT INTO mmo_vpl VALUES ("LK4_18","072_4_18","LUK","4","18","18","+ o 4:18-19 Ais 61:1-2; 58:6*“Omaaho Bop-ate Vavi Vaambuung lakando sa be yoo holin sa in nambe sa naanêêl banye nivasa vu hil anipaya. De wiing-ambe sa laam in nambe sa naanêêl langaah vu hil sen landuuh sil-ambe dandôô-to naambe sale kavaayin sil-ambe lana, de hil sen mend kanuu-to le lanji taaku naah. De wiing sa laam in nambe saandôôvu hil sen daanggôôl sil lôôt-ato in gavuuh sil-ambe lana mando naavind kuusin. ");
INSERT INTO mmo_vpl VALUES ("LK4_19","072_4_19","LUK","4","19","19","Tonde sa naanêêl langaah naambe busin sen Omaaho Bop navu samu hil-ato ond ngaaho lak-anjo.” ");
INSERT INTO mmo_vpl VALUES ("LK4_20","072_4_20","LUK","4","20","20","Yesu sevin lung la tonde lun kaapiya be vu laah vu hil kul ti de hato nando, tombe hil pin sen dando hôôk dumb alôô-to ond mend la vu yi timu, ");
INSERT INTO mmo_vpl VALUES ("LK4_21","072_4_21","LUK","4","21","21","tombe nêêl vu sil nambe, “Vakasin sen ham hangôô-ja ond nôôn ak gêên-anjo.” ");
INSERT INTO mmo_vpl VALUES ("LK4_22","072_4_22","LUK","4","22","22","+ o 4:22 Luk 3:23; Jon 6:42*Tombe hil pin lako haale lak, de sil lavindis lôôt in yite vakasin anivasa sen nanêêl-ato, lemu sil lanêêl nambe, “Nambe vaatii-jo? Omaahôô-jo Yusep noow.” ");
INSERT INTO mmo_vpl VALUES ("LK4_23","072_4_23","LUK","4","23","23","+ o 4:23 Mat 4:13; Jon 2:12*Tombe nêêl vu sil nambe, “Keen, ham navu naanêêl vakasin navu dangga ti bôôy vu sa naambe, ‘Dokta goo gambiing-ambe ganim vasa jak.’ Tonde ham e naanêêl gaving naambe, ‘Va sen hey hango gawiing vu Kapenaum-ato ond yik goo gambiing naambêênja vu gambaam dangga dosin-anjo gaving.’” ");
INSERT INTO mmo_vpl VALUES ("LK4_24","072_4_24","LUK","4","24","24","+ o 4:24 Jon 4:44*Tonde yik nêêl vu sil nambe, “Sa naanêêl keen vu ham naambe omaaho ti nanêêl Anutu-te vakasin langaah ond hil-ame dako omaahôô-ju haale lak vu baan dangga dosin e. ");
INSERT INTO mmo_vpl VALUES ("LK4_25","072_4_25","LUK","4","25","25","+ o 4:25 1King 17:1,7; 18:1; Jem 5:17*“Om sa naanêêl keen lôôt vu ham naambe hôôk busin sen Eliya nandôô-to ond taaku halevang lôôt, de lohvu ta yaal-ande kwaav namaavaalu vindak ti ond luk-ame hatolak daka le, tombe meep bopaata lohvu taaku pin. Tombe hôôk busin-anju ond vehaahôôv ngeeyaata dando Islel, ");
INSERT INTO mmo_vpl VALUES ("LK4_26","072_4_26","LUK","4","26","26","+ o 4:26 1King 17:8-16*lemu Anutu me-wiing Eliya la vu vehaahôôv Islel-asôônju in dôôvu sil ti le, malis, yik wiing-ambe la vu hil alundoos-ate vehaahôôv ti nando taaku Salepat vu Saidon. ");
INSERT INTO mmo_vpl VALUES ("LK4_27","072_4_27","LUK","4","27","27","+ o 4:27 2King 5:1-14*Tonde yik Elisa-te busin-ato ond hil anipayêês anipaya lôôt-ato ngeeyaata dando Islel, lemu Elisa me-nêêl-ambe sil ti nivasa lak e, malis, yik hil Silia ti Naeman ond Elisa nêêl-ambe yoo timu nivasa lak.” ");
INSERT INTO mmo_vpl VALUES ("LK4_28","072_4_28","LUK","4","28","28","Tombe hil pin sen dando hôôk dumb alo be lango Yesu-te vakasin-anjôôto ond londpayo nivaane lôôt, ");
INSERT INTO mmo_vpl VALUES ("LK4_29","072_4_29","LUK","4","29","29","om sil kandi be lakôôh Yesu la taaku nanyendangga. De silate taakuu-ju nando lak kandu, om sil lako Yesu be lala kasita in nambe sil bakôôh duus pake navu, ");
INSERT INTO mmo_vpl VALUES ("LK4_30","072_4_30","LUK","4","30","30","le ma de hanggwang sil-ande hato sil lavuunaatôôv-ambe la. ");
INSERT INTO mmo_vpl VALUES ("LK4_31","072_4_31","LUK","4","31","31","+ o 4:31 Mat 4:13; Luk 4:23*Yesu la hato bayêên Kapenaum sen neep Galilii-to, tombe yoo monanêêl tanasin vu hil lohvu busin sawaasin pin. ");
INSERT INTO mmo_vpl VALUES ("LK4_32","072_4_32","LUK","4","32","32","+ o 4:32 Mat 7:28-29; Jon 7:46*Sil lango yite tanasin atombe lavindis lôôt in yoo nawiing tanasin lohvu yêêv bop ti. ");
INSERT INTO mmo_vpl VALUES ("LK4_33","072_4_33","LUK","4","33","33","+ o 4:33-34 Mat 8:29; Mak 5:7; Luk 8:28*Tonde omaaho ti nando hôôk dumb alo ond mamu nipaya nahôôvu yi tombe teey bopaata lôôt nambe, ");
INSERT INTO mmo_vpl VALUES ("LK4_34","072_4_34","LUK","4","34","34","+ o 4:34 Jon 6:69*“Yesu Nasaalet, gayêêvu hey in? Galaam in nambe kawiiy hey na? Sa lak ganim nambe Anutu-te Omaaho Vaambuung hong.” ");
INSERT INTO mmo_vpl VALUES ("LK4_35","072_4_35","LUK","4","35","35","Le Yesu nêêl mamuu-ju nambe, “Olavam nama. Onggavuuh omaahonôôn-anja de gana.” Tombe mamu handu omaahonôôn-ambe lupake be la neep hôôk sil lavuun de hato be la, lemu me-vu nivaane vu omaahôô-ju le. ");
INSERT INTO mmo_vpl VALUES ("LK4_36","072_4_36","LUK","4","36","36","Tombe hil pin lavindis lôôt-ambe yoo lanêêl vu sil nambe, “Vakasin vaatii-ju, om sen nanêêl va osin niwêêk atombe mamu nipaya davuuh omaahonôôn-ande lato dala.” ");
INSERT INTO mmo_vpl VALUES ("LK4_37","072_4_37","LUK","4","37","37","Tombe Yesu banye la lohvu taaku Kapenaum-anju pin. ");
INSERT INTO mmo_vpl VALUES ("LK4_38","072_4_38","LUK","4","38","38","Yesu vu dumb alo be hato la voon, tombe lukala Simon-ate bayêên alo, de Simon yenaavêêh anivaane bopaata be neep, om sil kataangg Yesu in nambe dôôvu yi. ");
INSERT INTO mmo_vpl VALUES ("LK4_39","072_4_39","LUK","4","39","39","Om la naale ngaaho de nêêl niwêêk atombe nivaanêê-to lung la, de vêêh-anjôôto kandi pavis-ambe la hayêêh vanôôn-ambe vu vu sil. ");
INSERT INTO mmo_vpl VALUES ("LK4_40","072_4_40","LUK","4","40","40","De taaku me lukala tombe hil lako silate hil anilakin vaha vaha pin lala vu Yesu, tombe hambe nama lak hil anilakin-anju ti ti pin, tombe sil anind vasa nalak laah. ");
INSERT INTO mmo_vpl VALUES ("LK4_41","072_4_41","LUK","4","41","41","+ o 4:41 Mat 8:29; Mak 3:11-12*Tombe mamu nipaya davuuh omaahonôôn ngeeyaata be lato dala, de dateey nambe, “Anutu Noow hong.” Tombe Yesu nêêl mamu pin-ande hilin sil lavand jeen, in lalak Yesu ni nambe yi omaaho sen Anutu yoo holin yi vulôôt-ato. ");
INSERT INTO mmo_vpl VALUES ("LK4_42","072_4_42","LUK","4","42","42","Tonde samiinaanôôn atombe Yesu kandi pavis-ambe la taaku lu malis ti, tombe hil ngeeyaata lala davu salo yi be latovu. Tombe lala vu be lawiingin nambe langgilin yi in nambe me-gavuuh sil-ande na le, ");
INSERT INTO mmo_vpl VALUES ("LK4_43","072_4_43","LUK","4","43","43","+ o 4:43 Luk 8:1*le nêêl vu sil nambe, “Soo le naanêêl banye nivasa sen Anutu nanggin yite hil-ato vu taaku vaalu gaving e, in Anutu wiing sa be sa laam in nambe saambiing kul-anjo.” ");
INSERT INTO mmo_vpl VALUES ("LK4_44","072_4_44","LUK","4","44","44","+ o 4:44 Mat 4:23*Tonde la hatup hôôk taaku Yudia be monanêêl tanasin hôôk silate dumb alo ti ti. ");
INSERT INTO mmo_vpl VALUES ("LK5_1","072_5_1","LUK","5","1","1","+ o 5:1-3 Mat 13:1-2; Mak 3:9-10; 4:1*Busin ti Yesu la hato naale betum Genesaalet nanyendangga, tombe hil ngeeyaata lambuuh yi tatup in nambe sil gango Anutu-te tanasin. ");
INSERT INTO mmo_vpl VALUES ("LK5_2","072_5_2","LUK","5","2","2","Tonde yi de kaanu yuuhapim nando betum nanyendangga, lemu hil sen dako paahuung-ato ond latung kaanu nando de lala dalipis govak. ");
INSERT INTO mmo_vpl VALUES ("LK5_3","072_5_3","LUK","5","3","3","Tombe lakala kaanu ango sen Simon-atêêto be nêêl vu Simon nambe seelin kaanu gato na lavuun daka, tonde mem nando lak kaanu de monanêêl tanasin vu hil. ");
INSERT INTO mmo_vpl VALUES ("LK5_4","072_5_4","LUK","5","4","4","+ o 5:4-9 Jon 21:3-8*Nêêl tanasin lung la tonde nêêl vu Simon nambe, “Ham gako kaanu gato na betum lavuun, de ham gaate govak dukana ond ham e gako paahuung.” ");
INSERT INTO mmo_vpl VALUES ("LK5_5","072_5_5","LUK","5","5","5","Tombe Simon nêêl vu nambe, “Omaaho Bop, hey aawiing kul bopaata businaandiin, le hey-ame hako paahuung ti le, lemu ganêêl om sale gaate govak dukanaah.” ");
INSERT INTO mmo_vpl VALUES ("LK5_6","072_5_6","LUK","5","6","6","Om sil laate lukalaah tombe paahuung ngeeyaata lôôt lalukala be govak wiingin nambe bapuuh, ");
INSERT INTO mmo_vpl VALUES ("LK5_7","072_5_7","LUK","5","7","7","om sil laate namand in silate hil vaalu sen dando lak kaanu angôô-to in nambe lanaam in landôôvu sil, tombe sil lalaam-ambe laanjêêng paahuung lukala kaanu yuuh ahondoos, tombe kaanu yuuh ahondoos wiingin nambe davin na. ");
INSERT INTO mmo_vpl VALUES ("LK5_8","072_5_8","LUK","5","8","8","Simon Pita yi vaa-ju tombe hatung kaatu hôôk Yesu vaha de nêêl nambe, “O Omaaho Bop, ombaale diin in sak sa omaaho nipaya.” ");
INSERT INTO mmo_vpl VALUES ("LK5_9","072_5_9","LUK","5","9","9","In Pita yi paahuung pin sen lakôô-ju tombe vindis lôôt, tonde hil sen dando having yii-to lavindis having. ");
INSERT INTO mmo_vpl VALUES ("LK5_10","072_5_10","LUK","5","10","10","+ o 5:10 Mat 13:47*Tombe yik Sebedi noow ayuuh Jems ayuuh Jon sen yaal o Simon-aso dawiing kul hôôk tii-to, ond yuuh lavindis lôôt having, tombe Yesu nêêl vu Simon nambe, “Game ganjêênin e, onavu gako omaahonôôn naambe onako paahuung-ato.” ");
INSERT INTO mmo_vpl VALUES ("LK5_11","072_5_11","LUK","5","11","11","+ o 5:11 Mat 19:27*Lung laa tonde lako kaanu be lalaah lonak, tombe lavuuh va pin-ande lala taamuyin Yesu be lala. ");
INSERT INTO mmo_vpl VALUES ("LK5_12","072_5_12","LUK","5","12","12","Yesu la bayêên ti tonde omaaho ti nipayêês anipaya lôôt vu tapumin ninaavi pin, ond yi Yesu tombe hato pataav baambu neep voon hôôk vaha de kataangg nambe, “Omaaho Bop, lohvu gandôôvu sa be sa ningg naavi nivasa jak a?” ");
INSERT INTO mmo_vpl VALUES ("LK5_13","072_5_13","LUK","5","13","13","Tombe Yesu hambe nama lak yi de nêêl vu nambe, “Êê-e, lohvu saandôôvu hong, om ganim naavi nivasa jak.” Tombe yik payêês lung la pavis-ande nivasa lak. ");
INSERT INTO mmo_vpl VALUES ("LK5_14","072_5_14","LUK","5","14","14","+ o 5:14 Mak 7:36; Luk 8:56; Lev 14:1-32*Lung atonde Yesu vu kôôvu yi nambe, “Game naanêêl vaa-jo vu omaaho ti le, nganjo gana taato ganim naavi vu kul vaha sen datung salivangin-ato ti, de onggatung salivangin nohvu Mose-te tanasin nêêl-ato, in nambe mem hil lanjak ni naambe ganim naavi nivasa lak lung la.” ");
INSERT INTO mmo_vpl VALUES ("LK5_15","072_5_15","LUK","5","15","15","Le ma de Yesu banye la lohvu taaku pin, om hil baye-bayêên lasupin sil lalaam in nambe gango yite vakasin, de biing-ambe silate hil anilakin nind vasa jak, ");
INSERT INTO mmo_vpl VALUES ("LK5_16","072_5_16","LUK","5","16","16","+ o 5:16 Mak 1:35*lemu busin vaalu ond yoo nala nando taaku lumbalaamb-ambe nalohak vu Anutu. ");
INSERT INTO mmo_vpl VALUES ("LK5_17","072_5_17","LUK","5","17","17","Busin ti Yesu motaahu hil, tonde Palisai heey osin tanasin dangga-so heey sil vu taaku Galili osin Yudia de vu Yelusalem ond lalaam dandôô-ju, tombe Omaaho Bop-ate niwêêk hôôvu Yesu in nambe biing hil anilakin nind vasa dôôk. ");
INSERT INTO mmo_vpl VALUES ("LK5_18","072_5_18","LUK","5","18","18","Om vaheey laaku omaaho nipaling ti nama yuuh vaha nipayaa-to lak kaanye be lala in nambe lana gambe nanjip hôôk Yesu me vu bayêên alo. ");
INSERT INTO mmo_vpl VALUES ("LK5_19","072_5_19","LUK","5","19","19","Le ma de hil ngeeyaata lahilin vinavi, de mop sen sil baaku nilakin balup-ambe landukana vu Yesuu-to ma, om sil lalakala bayêên alu baandoni be sil kawiiy bayêên alu vuuti, tonde mem sil taaluuhin nilakin tii-jôôto osin kaanye la hato lukala hil lavuunaatôôv hôôk bayêên alo, tombe mem lambe la hato neep hôôk Yesu me. ");
INSERT INTO mmo_vpl VALUES ("LK5_20","072_5_20","LUK","5","20","20","+ o 5:20 Luk 7:48*Yesu lak ni nambe sil alondpayo la timu vu yi, om nêêl vu omaaho nipaling-anjo nambe, “Hali, gate nipaya ond sa kawiiy la.” ");
INSERT INTO mmo_vpl VALUES ("LK5_21","072_5_21","LUK","5","21","21","+ o 5:21 Luk 7:49; Ais 43:25*Tombe hil tanasin dangga-so laving hil Palisai-so yoo lakaas vu sil nambe, “Omaahôô-ju yi vaati ondeey wiingin nambe daanggôôl Anutu? Lati lohvu nambe kawiiy nipaya na? Yik Anutu timu yoo lohvu.” ");
INSERT INTO mmo_vpl VALUES ("LK5_22","072_5_22","LUK","5","22","22","Tombe Yesu yoo lak ni nambe sil oo kand navu nambêênju, om nêêl laah vu sil nambe, “Nambe vaati sen ham akam navu vakasin nambêênja hôôk ham alompayo? ");
INSERT INTO mmo_vpl VALUES ("LK5_23","072_5_23","LUK","5","23","23","De sa naanêêl vakasin ango tana in ham angge be ham anjak ni naambe nôôn keen? Sa naanêêl vu omaaho nipalinganjo naambe, ‘Gate nipaya ond sa kawiiy la’ ond ham-ame le anjak ni le. Nganjo sa naanêêl naambe, ‘Okandi baale be gana’ ond mem ham e anjak ni naambe nôôn keen. ");
INSERT INTO mmo_vpl VALUES ("LK5_24","072_5_24","LUK","5","24","24","+ o 5:24 Jon 5:8*Om peey-anjo ham anjak ni naambe Omaahonôôn Noow laam vu baandoni ond yoo tu danggakook vu voon in nambe kawiiy hil-ate va nipaya na.” Tonde nêêl vu omaaho nipaling-anjôôto nambe, “Sa naanêêl vu hong naambe okandi gako gate kaanye jak-ambe ganaah gambaam.” ");
INSERT INTO mmo_vpl VALUES ("LK5_25","072_5_25","LUK","5","25","25","Om kandi pavis hôôk sil amend, tombe vaahinin yite kaanye sen neep ak atombe hako be laah baan, tonde hako Anutu haale lak. ");
INSERT INTO mmo_vpl VALUES ("LK5_26","072_5_26","LUK","5","26","26","Tombe hil pin lavindis lôôt-ambe lako Anutu haale lak, tonde layêênin lôôt-ambe lanêêl nambe, “Gêên yaahe va nindoos ti yoow-o.” ");
INSERT INTO mmo_vpl VALUES ("LK5_27","072_5_27","LUK","5","27","27","Lung laa tonde monala tombe yi hil sen dako taakis-ato ti Liwi, nando hôôk bayêên sen dako taakis hôôk-ato, tombe nêêl vu nambe, “Ganaam taamuyin sa.” ");
INSERT INTO mmo_vpl VALUES ("LK5_28","072_5_28","LUK","5","28","28","Tombe havuuh yite va pin nando de kandi pavis-ambe la taamuyin Yesu. ");
INSERT INTO mmo_vpl VALUES ("LK5_29","072_5_29","LUK","5","29","29","Liwi wiing vanôôn bopaata ti vu Yesu vu baan, tombe hil sen dako taakis-ato osin hil vaalu ngeeyaata lala dando having-ambe mondaya vanôôn-anju having yuuh Yesu. ");
INSERT INTO mmo_vpl VALUES ("LK5_30","072_5_30","LUK","5","30","30","+ o 5:30 Luk 15:1-2*Tombe hil Palisai vaalu osin silate tanasin dangga-so ond layi tombe lanyuung lôôt vu Yesu-te maanggêêm-aso nambe, “Nambe vaati sen ham naha vanôôn osin ham nanum having hil sen dako taakis osin hil sen dawiing va nipayaa-to vaaluu-ju?” ");
INSERT INTO mmo_vpl VALUES ("LK5_31","072_5_31","LUK","5","31","31","Tombe Yesu nêêl laah vu sil nambe, “Hil anind vasa ond me-dala vu dokta le, nganjo hil sen nind lakin-ato ond mem dala vu. ");
INSERT INTO mmo_vpl VALUES ("LK5_32","072_5_32","LUK","5","32","32","De sak same alaam in nambe naateey hil sen datee sil ak nambe sil anivasaa-to le, ma, sa laam in naateey hil anipaya in nambe sil langgilin londpayo.” ");
INSERT INTO mmo_vpl VALUES ("LK5_33","072_5_33","LUK","5","33","33","Tonde lanêêl vu Yesu nambe, “Jon-ate maanggêêm-aso dalakin sil in vanôôn-ande dando meep balon ngeeyaata de sil mondalohak la vu Anutu, de yik Palisai-te hil dawiing va timu, le nambe vaati sen gate maanggêêm-aso yoo mondaya vanôôn osin mondanum-ande me-dalakin sil in vanôôn e?” ");
INSERT INTO mmo_vpl VALUES ("LK5_34","072_5_34","LUK","5","34","34","+ o 5:34 Jon 3:29*Tombe Yesu nêêl vu sil nambe, “Hil lasupin lala in daapêêlis gaving omaaho ti in hako vêêh moos, ond ham-ame alohvu nambe naanêêl-ambe sil lanjakin sil in vanôôn e, le nama. ");
INSERT INTO mmo_vpl VALUES ("LK5_35","072_5_35","LUK","5","35","35","Nganjo busin ti le naatok naam atombe hil e lanôôh omaahôô-juuto na vêêl in yite hil, ond mem le lanjakin sil in vanôôn.” ");
INSERT INTO mmo_vpl VALUES ("LK5_36","072_5_36","LUK","5","36","36","Tonde Yesu nêêl vakasin pakwesin ango vu sil nambe, “Tôômb ti nimbôôy-ambe ahembalap ak tombe kweek, ond omaaho ti me-le naakweek tôômb moos kamu ti in nambe naanduuh jakanaah nimbôôy e. Biing naambêênju ond le naakweek-ambe biliyak tôômb moos, tombe tôômb moos ayuuh nimbôôy-ame le nanjip ti le. ");
INSERT INTO mmo_vpl VALUES ("LK5_37","072_5_37","LUK","5","37","37","Tonde omaaho ti me-le naatooy wain moos dukana bik naavi nimbôôy e. Naambe kaasêêh dukana ond wain moos e buuk-ambe bapuuh bik naavi nimbôôy-anju biliyak-ande kaasêêh na. ");
INSERT INTO mmo_vpl VALUES ("LK5_38","072_5_38","LUK","5","38","38","Wain moos ond kaasêêh dukana bik naavi moos ond mem. ");
INSERT INTO mmo_vpl VALUES ("LK5_39","072_5_39","LUK","5","39","39","Tombe hil sen lanum wain bôôy lung laa-to ond me-dawiingin wain moos e, lanêêl nambe wain bôôy ond mem nivasa.” ");
INSERT INTO mmo_vpl VALUES ("LK6_1","072_6_1","LUK","6","1","1","+ o 6:1 Diu 23:25*Busin sawaasin ti tombe Yesu having yite maanggêêm-aso be laloh mop neep hôôk kul lavuun-ambe lala, tombe yite maanggêêm-aso kalêêh wit nôôn, tombe laliihin-ambe landaah. ");
INSERT INTO mmo_vpl VALUES ("LK6_2","072_6_2","LUK","6","2","2","+ o 6:2 Jon 5:10*Tombe Palisai heey lanêêl nambe, “Nambe vaati sen ham navu kalêêh wit nôôn? In me-lohvu nambe yaambiing kul hôôk busin sawaasin e.” ");
INSERT INTO mmo_vpl VALUES ("LK6_3","072_6_3","LUK","6","3","3","+ o 6:3 1Sml 21:1-6*Tombe Yesu nêêl laah vu sil nambe, “Vu bôôy Devit having yite hil sen laving yii-to ond layimb ahend, tombe wiing vaati? Mak ham-ame asevin mava? ");
INSERT INTO mmo_vpl VALUES ("LK6_4","072_6_4","LUK","6","4","4","+ o 6:4 Lev 24:5-9*Nambe Devit lukala Anutu-te dumb alo tombe hako vanôôn sen latung vu Anutuu-to be ya, de vu vu yite hil having. Vanôôn-anju ond tanasin neep nambe omaahonôôn-ame lanja le, yik kul vaha sen datung salivangin-ato yoo lanja.” ");
INSERT INTO mmo_vpl VALUES ("LK6_5","072_6_5","LUK","6","5","5","Tonde yik nêêl nambe, “De Omaahonôôn Noow ond tu busin sawaasin-ate danggakook.” ");
INSERT INTO mmo_vpl VALUES ("LK6_6","072_6_6","LUK","6","6","6","De busin sawaasin ango tombe Yesu lukalaah dumb alo be monawiing tanasin, tonde omaaho ti nama vaalu vasa nipaya nando. ");
INSERT INTO mmo_vpl VALUES ("LK6_7","072_6_7","LUK","6","7","7","+ o 6:7 Luk 13:14; 14:1*Tombe tanasin dangga-so de hil Palisai davu salo vakasin in nambe daanêêl jak Yesu, om langget lôôt in nambe lanji naambe biing omaahôô-ju nama nivasa jak dôôk busin sawaasin ond daanêêl yi. ");
INSERT INTO mmo_vpl VALUES ("LK6_8","072_6_8","LUK","6","8","8","+ o 6:8 Luk 5:22; 9:47*Lemu Yesu yoo lak sil alondpayo ni, om nêêl vu omaaho sen nama nipayaa-to nambe, “Okandi be ganaam baale hey amengg.” Tombe kandi be la naalêê-ju, ");
INSERT INTO mmo_vpl VALUES ("LK6_9","072_6_9","LUK","6","9","9","tonde Yesu nêêl vu sil nambe, “Saanjingin ham naambe va ango tana lohvu tanasin nêêl, nambe yaambiing va nivasa dôôk busin sawaasin, me yaambiing va nipaya? Nambe yaandôôvu omaahonôôn-ambe mando nivasa me yaanyiis-ambe jimb?” ");
INSERT INTO mmo_vpl VALUES ("LK6_10","072_6_10","LUK","6","10","10","Tombe me hako hôôk-ambe yi sil pin e mem nêêl vu omaahôô-juuto nambe, “Otalo namam.” Om talo nama tombe nivasa lak, ");
INSERT INTO mmo_vpl VALUES ("LK6_11","072_6_11","LUK","6","11","11","tombe sil amend anihees hanggwang, de yoo lakaas in nambe lambiing naambe vaati vu Yesu. ");
INSERT INTO mmo_vpl VALUES ("LK6_12","072_6_12","LUK","6","12","12","Tombe hôôk busin-anju Yesu la nando lak kandu ti in nambe nohak, om yoo monalohak vu Anutu businaandiin-ambe langaah ak. ");
INSERT INTO mmo_vpl VALUES ("LK6_13","072_6_13","LUK","6","13","13","+ o 6:13 Jon 6:70*Tonde taaku mekaalus lak valup atombe teey yite hil sen davu sapa yii-to lala vu be holin sil nomaayuuh-ambe laam yuuh, tombe teey haale sinaale lakala sil. ");
INSERT INTO mmo_vpl VALUES ("LK6_14","072_6_14","LUK","6","14","14","Sil-anjo ond ti Simon de Yesu nêêl haale ango nambe Pita, de Endru sen Simon halii-to, tonde Jems ayuuh Jon, de Pilip ayuuh Batolomai, ");
INSERT INTO mmo_vpl VALUES ("LK6_15","072_6_15","LUK","6","15","15","tonde Matai, de Tomas, de Alpias noow Jems, tonde Simon ango sen naanjiihin hil Yuda in nambe gatiiy hil Lom lanaa-to, ");
INSERT INTO mmo_vpl VALUES ("LK6_16","072_6_16","LUK","6","16","16","de Yudas sen Jems noow-ato, tonde Yudas Iskaliot sen taato Yesu langaah-ambe hil lalôôh-ato. ");
INSERT INTO mmo_vpl VALUES ("LK6_17","072_6_17","LUK","6","17","17","Tonde Yesu la having sil, tombe la hato naale taaku taambut ti having yite hil ngeeyaata, de omaahonôôn ngeeyaata vu Yudia de vu Yelusalem, tonde vu taaku lôôy nanyendangga sen Taia yuuh Saidon neep-ato, ond lalu-dandôô-ju. ");
INSERT INTO mmo_vpl VALUES ("LK6_18","072_6_18","LUK","6","18","18","Ond sil lalaam in nambe gango Yesu-te vakasin, de biing-ambe silate hil anilakin nind vasa dôôk. Tonde hil sen mamu nipaya nahôôvu sil-ato ond yik lalaam having, tombe Yesu natiiy mamu lato dala de nind vasa nahôôk. ");
INSERT INTO mmo_vpl VALUES ("LK6_19","072_6_19","LUK","6","19","19","Tombe hil pin lawiingin nambe sil gambe namand jak yi, in layi de yite niwêêk nawiing-ambe hil ngeeyaata nind vasa nahôôk. ");
INSERT INTO mmo_vpl VALUES ("LK6_20","072_6_20","LUK","6","20","20","Tonde Yesu me la vu yite maanggêêm-aso de nêêl nambe, “Ham sen ham alak ni nambe ham-ame nivasa le, ond ham akam vasa in ham alohvu nambe naatu Anutu-te hil. ");
INSERT INTO mmo_vpl VALUES ("LK6_21","072_6_21","LUK","6","21","21","+ o 6:21 Taato 7:16-17; Saam 126:5-6; Ais 61:3*De ham sen ham nahimb ahem-anja ond ham akam vasa in ham e gako vanôôn-ambe nohvu ham. De ham sen ham nasuu-to, ond ham akam vasa in ham e naanop. ");
INSERT INTO mmo_vpl VALUES ("LK6_22","072_6_22","LUK","6","22","22","+ o 6:22 Jon 15:19; 16:2; 1Pi 4:14*De hil e lanji naambe ham navu taamuyin Omaahonôôn Noow, tombe sil e nind baya lôôt in ham, de sil gatiiy ham ana nanyendangga, tonde daanêêl vakasin anipaya jak ham osin daanêêl ham haalem naambe hil anipaya, ond manyinja ham akam vasa. ");
INSERT INTO mmo_vpl VALUES ("LK6_23","072_6_23","LUK","6","23","23","Om lambiing naambêênja vu ham, ond ham akam vasa be ham naapêêlis lôôt. Ham gango le, ham e gako nyevahaan nivasa bopaata vu baandoni. Silate himbop-aso yoo lawiing nambêênjo vu hil sen danêêl Anutu-te vakasin langaah bôôy-ato. ");
INSERT INTO mmo_vpl VALUES ("LK6_24","072_6_24","LUK","6","24","24","+ o 6:24 Jem 5:1*Lemu ham sen kupak danggaa-to ond ham e gako nimeen, in ham hako va nivasa lung la. ");
INSERT INTO mmo_vpl VALUES ("LK6_25","072_6_25","LUK","6","25","25","De ham sen gêên ham aha be ham ahem pup la, ond ham e gako nimeen, in ham e anggimb ahem. De ham sen gêên ham nanop-ato, ond ham e gako nimeen, in taamusin ham alompayo le nimeen-ambe ham naasu. ");
INSERT INTO mmo_vpl VALUES ("LK6_26","072_6_26","LUK","6","26","26","Om naambe hil pin gako ham haalem jak ond ham e gako nimeen, in silate himbop-aso yoo lako tatuhin vaha-so haalend ak bôôy nambêênja.” ");
INSERT INTO mmo_vpl VALUES ("LK6_27","072_6_27","LUK","6","27","27","+ o 6:27 Pro 25:21; Lom 12:20*Tonde yik Yesu nêêl nambe, “Sa naanêêl vu ham sen ham nango sate vakasin-anjo naambe ham ahem gaving hil sen dawiing ham payaa-to nivasa lôôt, de ham samu hil sen nind baya lôôt in ham-ato. ");
INSERT INTO mmo_vpl VALUES ("LK6_28","072_6_28","LUK","6","28","28","+ o 6:28 Lom 12:14*De ham naanêêl vakasin anivasa jak hil sen davu talôôt ham-ato, osin ham anohak na vu Anutu in bu yite samu samu vu hil sen danêêl ham palêê-to. ");
INSERT INTO mmo_vpl VALUES ("LK6_29","072_6_29","LUK","6","29","29","De naambe omaaho ti patap onggaambôôk ond ganggilin vaalu na vu gaving, de naambe omaaho ti hako gate lolop ond gambu tôômb na vu gaving. ");
INSERT INTO mmo_vpl VALUES ("LK6_30","072_6_30","LUK","6","30","30","Tonde omaaho ti kataangg hong in vati ond gambu vu, de naambe omaaho ti gako gate vati ond game naanêêl vu naambe bu nom e. ");
INSERT INTO mmo_vpl VALUES ("LK6_31","072_6_31","LUK","6","31","31","+ o 6:31 Mat 7:12*Va sen ham nawiingin nambe hil lambiing vu ham-ato, ond yik ham oo ambiing naambêênja vu hil. ");
INSERT INTO mmo_vpl VALUES ("LK6_32","072_6_32","LUK","6","32","32","“Tonde naambe ham ahem oo gaving hil sen ahend naving ham-ato mu, de ham ahem-ame naving hil vaalu le, ond yik hil sen dawiing va nipayaa-to ond sil ahend oo naving hil sen ahend naving sil-ato va timu nambêênja, le hamambe Anutu le bu nivasa nyevahaan vu ham a? Malis lôôt. ");
INSERT INTO mmo_vpl VALUES ("LK6_33","072_6_33","LUK","6","33","33","De naambe ham samu hil sen davu samu ham-ato ond yik hil sen dawiing va nipayaa-to ond sil oo davu samu hil sen davu samu sil-ato va timu nambêênja, le hamambe Anutu le bu nivasa nyevahaan vu ham a? Malis. ");
INSERT INTO mmo_vpl VALUES ("LK6_34","072_6_34","LUK","6","34","34","Tonde va sen ham navu vu hil-ande ham akam navu nambe lambu nyevahaan nom-ato, ond yik hil sen dawiing nipayaa-to ond davu va vu hil anipaya vaalu tonde sil akand navu nambe lambu dôôk nyevahaan nom vu sil va timu nambêênja, om Anutu me-le bu nivasa nyevahaan vu ham e. ");
INSERT INTO mmo_vpl VALUES ("LK6_35","072_6_35","LUK","6","35","35","+ o 6:35 Lev 25:35-36*Nganjo ham ahem oo gaving hil sen dawiing ham payaa-to be ham samu sil, de ham ambu va vu sil, tombe ham akam-ame bu naambe lambu nyevahaan nom vu ham e. Ham ambiing naambêênja ond taamusin e ham e naatovu nivasa nyevahaan bopaata lôôt, tonde ham e naatu Anutu baandoni-te noondin. In yoo nawiing ngaatum vu hil sen me-kand navu yite samu samu osin hil anipayaa-to, ");
INSERT INTO mmo_vpl VALUES ("LK6_36","072_6_36","LUK","6","36","36","om ham oo kam pasiv-ambe ham andôôvu omaahonôôn naambe sen yiiy Aamangg aka pasiv-ato.” ");
INSERT INTO mmo_vpl VALUES ("LK6_37","072_6_37","LUK","6","37","37","+ o 6:37 Mat 6:14*Tonde yik Yesu nêêl nambe, “Ham-ame sahi omaaho ango-te vakasin-ambe ham naanêêl ak sil alund e, in nambe mem Anutu me-le sahi hamate vakasin-ambe naanêêl jak ham alum e. De ham-ame naanêêl naambe sil gako nimeen e, ond Anutu me-le naanêêl naambe onggako nimeen e. Tonde ham kawiiy hil-ate vakasin na, ond Anutu le kawiiy hamate vakasin na. ");
INSERT INTO mmo_vpl VALUES ("LK6_38","072_6_38","LUK","6","38","38","+ o 6:38 Mak 4:24*De ham ambu va vu hil, ond Anutu le bu va vu ham lôôt-ambe vaahes naapup na, tombe naatong-ande baanjêêng jêê-na gaving-ambe kaasêêh na le mem bu vu ham. In va ngeeyaata osin va pasivdaka sen ham navu vu hil-ato, ond yik Anutu le bu dukanaah vu ham.” ");
INSERT INTO mmo_vpl VALUES ("LK6_39","072_6_39","LUK","6","39","39","+ o 6:39 Mat 15:14*Tonde sim Yesu nêêl vakasin pakwesin ti vu sil nambe, “Omaaho ti mekanu ond lohvu nambe naanggiiy mekanu ango be yuuh lana mop a? Me-lohvu le, in yuuh ahondoos e landupake. ");
INSERT INTO mmo_vpl VALUES ("LK6_40","072_6_40","LUK","6","40","40","+ o 6:40 Mat 10:24-25*Unoopasiv-ame savok yite kaputung e, nganjo kaputung taahu hôôk va pin-ambe jung na le, mem le nohvu yite kaputung. ");
INSERT INTO mmo_vpl VALUES ("LK6_41","072_6_41","LUK","6","41","41","“Nambe vaati sen onahe kaalekaale daka hôôk halim ame, de game nahe haah boow sen neep hôôk gamem e? ");
INSERT INTO mmo_vpl VALUES ("LK6_42","072_6_42","LUK","6","42","42","Haah boow yoo neep hôôk gamem le game gahe le, om nambe vaati sen ganêêl vu halim nambe, ‘Ombaale de sa japêêh va daka na vêêl in gamem e.’ Goo natee hong ak. Ganôôh haah boow sen neep hôôk gamem-anja na vêêl e, mem gale gangge nivasa be onjapêêh kaalekaale na in halim ame.” ");
INSERT INTO mmo_vpl VALUES ("LK6_43","072_6_43","LUK","6","43","43","“Haah anivasa ond me-nayiis nôôn anipaya le, de haah anipaya ond me-nayiis nôôn anivasa le. ");
INSERT INTO mmo_vpl VALUES ("LK6_44","072_6_44","LUK","6","44","44","Yiiy naahe hahaanôôn-ambe yalak ni nambe haah anivasa me nipaya, in ganggwak-ame nayiis nôôn bangguk e, de dandayin-ame nayiis nôôn kopi le, malis. ");
INSERT INTO mmo_vpl VALUES ("LK6_45","072_6_45","LUK","6","45","45","Omaaho nivasa ond ka navu va nivasa ngeeyaata naale hôôk lopayo ondeey nawiing va nivasa, tonde omaaho nipaya ond ka navu va nipaya ngeeyaata naale hôôk lopayo ondeey yoo nawiing va nipaya, om va sen pup hôôk omaahonôôn alopayôô-to ond le naanêêl naam langaah.” ");
INSERT INTO mmo_vpl VALUES ("LK6_46","072_6_46","LUK","6","46","46","+ o 6:46 Mal 1:6; Mat 7:21*“Nambe vaati sen ham nanêêl sa haalengg nambe Omaaho Bop, le ham-ame navu taamuyin sa lavangg e? ");
INSERT INTO mmo_vpl VALUES ("LK6_47","072_6_47","LUK","6","47","47","Hil sen lalaam dango sate vakasin-anjo be davu taamuyin-ato, ond sale tatekin sil vu ham. ");
INSERT INTO mmo_vpl VALUES ("LK6_48","072_6_48","LUK","6","48","48","Ond sil lalohvu omaaho ti haav yite bayêên, ond haav lôôvin lukala kambini lôôt, tombe valaah ngaandiin lukala naale lak tatuuh de laahun-ambe tong, tonde mem haav bayêên lakala. Tonde luk hatolak-ambe bel vaal bopaata be la hato vuv yêês, le me-lohvu nambe kape daka le, in dangga nambe omaahôô-ju haav yite bayêên naale niwêêk lôôt. ");
INSERT INTO mmo_vpl VALUES ("LK6_49","072_6_49","LUK","6","49","49","Nganjo hil sen dango sate vakasin-anjo le me-davu taamuyin e, ond sil lalohvu omaaho ti haav yite bayêên nando voon, le ngaandiin-ame lukala kambini le, tombe luk hatolak-ambe bel vaal bopaata be yêês hato, tomem kape pavis-ambe matelak valok-ate.” ");
INSERT INTO mmo_vpl VALUES ("LK7_1","072_7_1","LUK","7","1","1","Yesu nêêl vakasin pin-anju vu hil-ambe lung la, tonde la hato Kapenaum. ");
INSERT INTO mmo_vpl VALUES ("LK7_2","072_7_2","LUK","7","2","2","Tombe hil Lom-ate yêêv ngaamong vaha ti ond yite hil kul ti sen ahe naving yii-to nilak lôôt-ambe neep, be ngaaho lak in navu jimb na. ");
INSERT INTO mmo_vpl VALUES ("LK7_3","072_7_3","LUK","7","3","3","Tombe yêêv hango banye nambe Yesu hato, om wiing hil Yuda-te himbop heey lala vu Yesu in nambe sil kataangg naambe naam-ambe biing yite hil kul ti nivasa jak. ");
INSERT INTO mmo_vpl VALUES ("LK7_4","072_7_4","LUK","7","4","4","Om sil lala lato vu Yesu tombe sil kataangg lôôt nambe, “Omaaho Bop, omaahôô-ju omaaho nivasa om gambiing gaving lava, ");
INSERT INTO mmo_vpl VALUES ("LK7_5","072_7_5","LUK","7","5","5","in ahe naving yiiy Yuda tombe yoo haav yate dumb.” ");
INSERT INTO mmo_vpl VALUES ("LK7_6","072_7_6","LUK","7","6","6","Tombe Yesu having sil-ambe lala. Sil mondala be lala lalup ngaaho vu bayêên, tombe hil ngaamong vaha-te yêêv-anjuuto wiing yite vaheey lako lava be lato lanêêl vu Yesu nambe, “Omaaho Bop, sa omaaho nipaya, om me-lohvu nambe gandukanaam sate bayêên alo le. ");
INSERT INTO mmo_vpl VALUES ("LK7_7","072_7_7","LUK","7","7","7","De sa lak ni nambe sa omaaho nipaya ondeey same alaas vu hong e, om yik onaanêêl amu de sate unoopasiv-anju nivasa jak. ");
INSERT INTO mmo_vpl VALUES ("LK7_8","072_7_8","LUK","7","8","8","Nambe sen sa, ond yik sa naahulis sate yêêv bop sen nanggin saa-to baambu, de sate hil ngaamong vaha-so dahulis sa baambungg. Om sa naanêêl vu ti naambe ‘Gana’ ond yik la, tonde sa naanêêl vu ango naambe ‘Ganaam’ ond yik laam, tonde sa naanêêl vu sate hil kul ti naambe ‘Gambiing kul tii-ja’ ond yik wiing.” ");
INSERT INTO mmo_vpl VALUES ("LK7_9","072_7_9","LUK","7","9","9","Yesu hango vakasin-anju tombe vindis lôôt, om hilin-ambe nêêl vu hil ngeeyaata sen davu taamuyin yii-to nambe, “Sa naanêêl vu ham naambe same aatovu ham Islel ti wii-having niwêêk lôôt nambêênju le.” ");
INSERT INTO mmo_vpl VALUES ("LK7_10","072_7_10","LUK","7","10","10","Tonde hil sen yêêv wiing sil lalaam-ato ond lalaah lalup bayêên e layi de hil kul tii-to nivasa lak lung la. ");
INSERT INTO mmo_vpl VALUES ("LK7_11","072_7_11","LUK","7","11","11","Lung laa tonde sim Yesu la taaku ti haale nambe Nain, tombe yite maanggêêm-aso laving hil ngeeyaata be lala having yi. ");
INSERT INTO mmo_vpl VALUES ("LK7_12","072_7_12","LUK","7","12","12","Lala lato ngaaho vu taaku Nain-anjuuto yite vinavi bop, tonde hil laaku omaahonôôn ti be lalaam in nambe lana landaav. Ond vehaahôôv ti noow timuu-ju, tombe hil vu taakuu-ju ngeeyaata laving vehaahôôv-anju be lato. ");
INSERT INTO mmo_vpl VALUES ("LK7_13","072_7_13","LUK","7","13","13","+ o 7:13 Luk 8:52*Yesu yi vêêh-anju tombe ka pasiv in lôôt, om nêêl vu nambe, “Game naasu le.” ");
INSERT INTO mmo_vpl VALUES ("LK7_14","072_7_14","LUK","7","14","14","+ o 7:14 Luk 8:54*Tonde la ngaaho be hambe nama lak yêênin sen omaahonôôn neep ak-ato, om hil sen laakuu-to daale tonde Yesu nêêl nambe, “Unoopasiv, sa naanêêl vu hong naambe okandi jak.” ");
INSERT INTO mmo_vpl VALUES ("LK7_15","072_7_15","LUK","7","15","15","+ o 7:15 1King 17:23; 2King 4:36*Tombe omaahonôôn sen meyimbin-ato kandi nando be mem vakaas, tombe mem Yesu nêêl vu tangganaan nambe, “Noom nganjo.” ");
INSERT INTO mmo_vpl VALUES ("LK7_16","072_7_16","LUK","7","16","16","+ o 7:16 Luk 1:68; 19:44*Hil pin layi be kanund la lôôt, tombe lako Anutu haale lak-ambe lanêêl nambe, “Hil sen danêêl Anutu-te vakasin langaah-ato ti osin haale bop kandi lak hôôk yiiy lavuun.” Tonde yik lanêêl nambe, “Anutu laam lung la in dôôvu yite hil.” ");
INSERT INTO mmo_vpl VALUES ("LK7_17","072_7_17","LUK","7","17","17","Tombe Yesu-te banyêê-ju la lohvu taaku Yudia osin taaku sen neep ngaahôô-to pin lôôt. ");
INSERT INTO mmo_vpl VALUES ("LK7_18","072_7_18","LUK","7","18","18","Jon sen nalipis hil-ato ond yite maanggêêm-aso latulin Yesu-te vakasin pin-anju vu yi. ");
INSERT INTO mmo_vpl VALUES ("LK7_19","072_7_19","LUK","7","19","19","+ o 7:19-20 Saam 40:7; Mal 3:1; Taato 1:8*Om teey yite maanggêêm yuuh lalaam tombe wiing yuuh lala vu Omaaho Bop in nambe lanjingin yi naambe, “Hil sen danêêl Anutu-te vakasin langaah-ato danêêl nambe omaaho ti le naam ond yik hong-anjo, me hey ganggin omaaho ango le?” ");
INSERT INTO mmo_vpl VALUES ("LK7_20","072_7_20","LUK","7","20","20","Tombe omaaho yuuh-anjuuto mondala be lala lato vu Yesu, le mem yuuh lanêêl nambe, “Jon sen nalipis hil-ato wiing haay alaam in aanjingin naambe mak hong omaaho sen Anutu-te hil danêêl hong banyem bôôy nambe gale ganaam-ato ond yik hong-anjo, me hey ganggin omaaho ango le?” ");
INSERT INTO mmo_vpl VALUES ("LK7_21","072_7_21","LUK","7","21","21","Tombe hôôk busin-anju Yesu wiing hil anilakin vaha vaha ngeeyaata nind vasa lak, de hatiiy mamu nipaya ngeeyaata la in omaahonôôn osin wiing mekanôônd ngeeyaata mend tum. ");
INSERT INTO mmo_vpl VALUES ("LK7_22","072_7_22","LUK","7","22","22","+ o 7:22 Ais 35:5-6; 61:1; Luk 4:18*Tonde Yesu nêêl vu Jon-ate maanggêêm yuuh-ato nambe, “Manaah-ambe muuh gatulin va pin sen gêên mahe osin muuh hangôô-to banye vu Jon naambe hil amend kanôônd dayi taaku laah, tonde hil vahand paaya dala mop, de hil sen nind payêês anipaya lôôt-ato nind naavi nivasa nalak, de hil sen nanyend doos-ato dango taaku de hil yimbin davu kandi lak laah, tonde hil anipaya paya pin dango banye nivasa. ");
INSERT INTO mmo_vpl VALUES ("LK7_23","072_7_23","LUK","7","23","23","Tonde naambe omaaho ti me-lopayo yu-yuuh in sa le ond le ka vasa.” ");
INSERT INTO mmo_vpl VALUES ("LK7_24","072_7_24","LUK","7","24","24","Jon-ate maanggêêm ayuuh lalaah lung la, le mem Yesu nêêl Jon-ate dangga tatekin vu hil alu bopaataa-jôôto nambe, “Bôôy ham ala vu Jon vu taaku lumbalaamb ond ham awiingin nambe angge vaati? Mak ham awiingin nambe angge omaaho ti lohvu vavi nayêêyak ganggwak laah-ande lom a? ");
INSERT INTO mmo_vpl VALUES ("LK7_25","072_7_25","LUK","7","25","25","Me ham ala in nambe angge vaati? Ham ala in nambe ham angge omaaho ti nalop lolop anivasa vasa? Malis. Hil sen dalop lolop amengali be dando osin va nivasa vasa nambêênja ond sil oo dando hôôk hil alulemak ambaand. ");
INSERT INTO mmo_vpl VALUES ("LK7_26","072_7_26","LUK","7","26","26","+ o 7:26 Luk 1:76*Om ham ala in nambe angge vaati? Ham ala nahe omaaho ti nanêêl Anutu-te vakasin langaah a? Keen, sa naanêêl vu ham naambe Jon-anju savok hil sen danêêl Anutu-te vakasin langaah-ato la. ");
INSERT INTO mmo_vpl VALUES ("LK7_27","072_7_27","LUK","7","27","27","+ o 7:27 Mal 3:1*Tonde Jon-anju ond yik Anutu nêêl yite vakasin munggin-ambe neep hôôk kaapiya nambe, ‘Onggango le, sa navu aambiing sate omaaho ti na naamunggin vu hong in samu gate mop.’ ");
INSERT INTO mmo_vpl VALUES ("LK7_28","072_7_28","LUK","7","28","28","Om sa naanêêl vu ham naambe Jon savok hil pin sen taandin dako sil vu voon-anjôôto, lemu hil sen Anutu nanggin sil-ato vaalu haalend nipasiv lôôt ond le savok Jon na.” ");
INSERT INTO mmo_vpl VALUES ("LK7_29","072_7_29","LUK","7","29","29","+ o 7:29 Luk 3:12*Tombe hil pin osin hil sen dako taakis-ato lango vakasin-anju tombe lanêêl nambe, “Keen, Anutu yi omaaho nivalok.” Ond hil-anju Jon lipis sil lung la, ");
INSERT INTO mmo_vpl VALUES ("LK7_30","072_7_30","LUK","7","30","30","+ o 7:30 Mat 21:32*nganjo hil Palisai osin tanasin dangga-so laluuh damind vu mopaatôôv anivasa sen Anutu taato vu sil-ato, om me-lalipis bel e. ");
INSERT INTO mmo_vpl VALUES ("LK7_31","072_7_31","LUK","7","31","31","Tombe Yesu nêêl nambe, “Sale tatekin omaahonôôn sen gêên-anjo jak vaati? Sil lalohvu laheey? ");
INSERT INTO mmo_vpl VALUES ("LK7_32","072_7_32","LUK","7","32","32","Sil akand yu-yuuh lohvu unoopasiv sen dando talind-ambe dateey la vu ango-so nambe, ‘Hey aawiing kombin vu ham, lemu ham-ame nakôômb e, de hey aasu kangg paya paya, le ma de ham-ame navu kaatuuh ham e.’ ");
INSERT INTO mmo_vpl VALUES ("LK7_33","072_7_33","LUK","7","33","33","In Jon sen nalipis hil-ato laam atombe me-ya vanôôn anivasa de me-num wain e, tombe ham anêêl nambe, ‘Mamu nipaya nahôôvu yi.’ ");
INSERT INTO mmo_vpl VALUES ("LK7_34","072_7_34","LUK","7","34","34","+ o 7:34 Luk 15:2*De Omaahonôôn Noow laam-ambe ya osin num, tombe ham anêêl nambe, ‘Ham angge, omaaho aheta om yoo naya osin nanum wain bopaata, om hil sen dako taakis-ato osin hil sen dawiing va nipayaa-to vaalu ond silate omaaho tii-ju.’ ");
INSERT INTO mmo_vpl VALUES ("LK7_35","072_7_35","LUK","7","35","35","Lemu hil pin sen dawiing kul anivasa vasaa-to ond navu taato nambe sil hil osin kand.” ");
INSERT INTO mmo_vpl VALUES ("LK7_36","072_7_36","LUK","7","36","36","+ o 7:36 Luk 11:37*Palisai ti kataangg Yesu nambe na ja vanôôn gaving yi, om Yesu lukala vu sil-ambe sil oo dando mondaya vanôôn. ");
INSERT INTO mmo_vpl VALUES ("LK7_37","072_7_37","LUK","7","37","37","+ o 7:37 Mat 26:7; Mak 14:3; Jon 12:3*Tombe vêêh baayamb ti nando taakuu-ju hango nambe Yesu nando monaya vanôôn hôôk Palisai tii-ju baan, om vêêh-anju hako bel galovasa hôôk buayo tatuuh ti be la vu Yesu. ");
INSERT INTO mmo_vpl VALUES ("LK7_38","072_7_38","LUK","7","38","38","Tombe la valu-naale Yesu dami ngaaho vu Yesu vaha, tombe hato nando be monasu, tombe meluk tokak Yesu vaha, om laavu lak luvalus-ande muuh Yesu vaha lôôt, tonde kaasêêh bel galovasa lak vaha. ");
INSERT INTO mmo_vpl VALUES ("LK7_39","072_7_39","LUK","7","39","39","Tombe Palisai sen teey Yesu laam-ato, haale nambe Simon, ond yik yi de vêêh-anju laam, tombe yoo ka vu nambe, “Naambe omaahôô-jo yi hil sen danêêl Anutu-te vakasin langaah-ato ti keen ond le jak vêêh sen nambe nama lak yii-ju ni naambe vêêh anipaya.” ");
INSERT INTO mmo_vpl VALUES ("LK7_40","072_7_40","LUK","7","40","40","Tombe Yesu nêêl omaahôô-ju lopayo langaah vu nambe, “Simon, sa naanêêl vakasin ti vu hong e.” Tombe Simon nêêl nambe, “Kaputung, onaanêêl-o.” ");
INSERT INTO mmo_vpl VALUES ("LK7_41","072_7_41","LUK","7","41","41","Tombe Yesu nêêl nambe, “Omaaho ti vu mone vu omaaho yuuh. Ango hako mone kaapiya nomaayuuh de ango hako mone kaapiya timu, ");
INSERT INTO mmo_vpl VALUES ("LK7_42","072_7_42","LUK","7","42","42","lemu yuuh-ame lalohvu nambe lambu dôôk nyevahaan e, om omaahôô-ju yoo kawiiy yuuhate nyevahaan la lôôt. Ke, om omaaho yuuh-anju ango tana le ahe gaving omaaho sen kawiiy yuuhate nyevahaan-ato lôôt?” ");
INSERT INTO mmo_vpl VALUES ("LK7_43","072_7_43","LUK","7","43","43","Tombe Simon nêêl laah nambe, “Mak ango sen omaahôô-ju kawiiy yite nyevahaan bopaata lôôt laa-to.” Tombe Yesu nêêl vu nambe, “Goo ganêêl lohvu.” ");
INSERT INTO mmo_vpl VALUES ("LK7_44","072_7_44","LUK","7","44","44","+ o 7:44 Jen 18:4*Tombe mem Yesu hilin laah vu vêêh-anju de nêêl vu Simon nambe, “Gahe vêêh-anjo? Saalukalaam gate bayêên le game gavu bel-ambe saalipis sa vahangg ak e, lemu vêêh-anjo ond lipis sa vahangg ak meluk-ande laavu lak luvalus. ");
INSERT INTO mmo_vpl VALUES ("LK7_45","072_7_45","LUK","7","45","45","Tonde saalukalaam-ato ond game gamuuh sa gaambôôk in nambe onggako sa jak e, lemu vêêh-anjo yoo monamuuh sa vahangg lôôt. ");
INSERT INTO mmo_vpl VALUES ("LK7_46","072_7_46","LUK","7","46","46","+ o 7:46 Saam 23:5*Tonde game galipis sa lungg ak bel galovasa le, lemu vêêh-anjo kaasêêh bel galovasa lak sa vahangg. ");
INSERT INTO mmo_vpl VALUES ("LK7_47","072_7_47","LUK","7","47","47","Om sa naanêêl vu hong naambe yite nipaya ngeeyaata lôôt, lemu gêên Anutu kawiiy lung la, ondeey yoo ahe having sa lôôt. Naambe Anutu kawiiy omaaho ti-te nipaya daka na, ond me-le ahe gaving lôôt naambêênju le.” ");
INSERT INTO mmo_vpl VALUES ("LK7_48","072_7_48","LUK","7","48","48","+ o 7:48 Luk 5:20-21*Tonde Yesu nêêl vu vêêh-anjôôto nambe, “Gate nipaya sa kawiiy lung la.” ");
INSERT INTO mmo_vpl VALUES ("LK7_49","072_7_49","LUK","7","49","49","Tombe hil sen dando mondaya vanôôn having yii-jôôto yoo lanêêl vu sil nambe, “Omaahôô-jo yi vaati om kawiiy nipaya la?” ");
INSERT INTO mmo_vpl VALUES ("LK7_50","072_7_50","LUK","7","50","50","+ o 7:50 Luk 8:48; 17:19; 18:42*Tonde Yesu nêêl vu vêêh-anjôôto nambe, “Gawii-having sa om hôôvu hong, om gana osin galompayo ahelavis.” ");
INSERT INTO mmo_vpl VALUES ("LK8_1","072_8_1","LUK","8","1","1","+ o 8:1 Luk 4:43*Lung laa tonde sim Yesu la natup hôôk lohvu taaku bop osin bayêên pasiv vaalu, be nawiing tanasin osin nanêêl banye nivasa sen Anutu nanggin yite hil-ato vu sil, tombe yite maanggêêm nomaayuuh-ambe laam yuuh-ato lala having yi. ");
INSERT INTO mmo_vpl VALUES ("LK8_2","072_8_2","LUK","8","2","2","+ o 8:2 Mat 27:55-56; Mak 15:40-41; Luk 23:49*Tonde vêêh heey ond bôôy Yesu hatiiy mamu nipaya la in sil osin wiing sil vaalu nind lakin nind vasa lak ond vêêh-asôônju lala having. Ond ti Malia sen danêêl yi nambe Malia vu Magadala sen Yesu hatiiy mamu nipaya namaavaalu be vindak yuuh in yi bôôy-ato, ");
INSERT INTO mmo_vpl VALUES ("LK8_3","072_8_3","LUK","8","3","3","de Helot-ate yêêv ti nanggin yite bayêên, haale nambe Kusa ond vane Joana, de ti Susana, tonde vêêh vaalu ngeeyaata lala having yi. Ond vêêh-asôônju dahôôvu Yesu having yite maanggêêm-aso in va yuuh ame. ");
INSERT INTO mmo_vpl VALUES ("LK8_4","072_8_4","LUK","8","4","4","Tonde hil vu bayêên bu ti ti pin lasupin lalaam vu Yesu lôôt, tombe nêêl vakasin pakwesin ti vu sil nambe, ");
INSERT INTO mmo_vpl VALUES ("LK8_5","072_8_5","LUK","8","5","5","“Omaaho ti la in nambe baalil yite vave dukana kul moos. Monaalil atombe vaalu tok nando mop, tombe hil laake tatêêl tonde manak lalaam-ambe laya lôôt. ");
INSERT INTO mmo_vpl VALUES ("LK8_6","072_8_6","LUK","8","6","6","De vaalu tok lakando ngaanggis pasivdaka sen lakando tatuuh baandonii-to, tombe mem me valup, le ngaanggis aniluk ma om bambôôv valok-ate. ");
INSERT INTO mmo_vpl VALUES ("LK8_7","072_8_7","LUK","8","7","7","De vaalu lukala ganggwak dangga, tombe ganggwak valup having-ambe yêês om me-yiis nôôn e. ");
INSERT INTO mmo_vpl VALUES ("LK8_8","072_8_8","LUK","8","8","8","Tonde vaalu lukala ngaanggis anivasa ond valup-ambe yiis nôôn ngeeyaata lôôt lohvu doo-namaavaalu-vaalu.” Yesu nêêl nambêênju tonde nêêl having nambe, “Omaaho ti nambe nanye neep ond gangoyin.” ");
INSERT INTO mmo_vpl VALUES ("LK8_9","072_8_9","LUK","8","9","9","Tombe Yesu-te maanggêêm-aso lalingin yi in vakasin pakwesin-anjuuto danggakook, ");
INSERT INTO mmo_vpl VALUES ("LK8_10","072_8_10","LUK","8","10","10","+ o 8:10 Ais 6:9-10*tombe nêêl vu sil nambe, “Ham ond mem Anutu nanêêl vakasin sen vun yii-to langaah vu ham lak sen Anutu nanggin yiiy-ato, lemu hil vaalu ond dango vakasin pakwesin amu in nambe lanji lôôt lemu me-lanjak ni le, de sil gangoyin lôôt lemu me-daatokak dangga le.” ");
INSERT INTO mmo_vpl VALUES ("LK8_11","072_8_11","LUK","8","11","11","+ o 8:11 1Pi 1:23*“Vakasin pakwesin lak vavêê-to dangga nambe vavêê-jo lohvu Anutu-te tanasin, ");
INSERT INTO mmo_vpl VALUES ("LK8_12","072_8_12","LUK","8","12","12","de vave vaalu tok nando mop ond lohvu hil vaalu dango vakasin, le ma de Saalang navu sapos vakasin sen lokala sil alondpayôô-to nala pavis, in Saalang aka vu nambe me-lambiing gaving-ambe Anutu dôôvu sil e. ");
INSERT INTO mmo_vpl VALUES ("LK8_13","072_8_13","LUK","8","13","13","Tonde vave vaalu tok lakando ngaanggis pasivdaka sen lakando tatuuh baandonii-to, ond lohvu hil vaalu sen dango vakasin-ambe dako lak pavis-ambe dapêêlis, lemu sil lalohvu va sen kangga me-lukala le, om dando daka vêêl e mem Saalang valup-ambe navu sahi sil, tombe nind baya be davuuh Anutu la pavis. ");
INSERT INTO mmo_vpl VALUES ("LK8_14","072_8_14","LUK","8","14","14","Tonde vave vaalu tok lukala ganggwak danggaa-to ond lohvu hil vaalu sen dango Anutu-te vakasin, lemu sil alondpayo nimeen in kand navu va voon-ate osin mend nôôn in kupak ayuuh mone bop, de sil oo dawiingin va vaha vaha pin, tombe sil akand oo navu va nambêênjo natu bopaata nahilin Anutu-te vakasin, om silate nôôn-ame natu bop e, malis, nayimb. ");
INSERT INTO mmo_vpl VALUES ("LK8_15","072_8_15","LUK","8","15","15","Tonde vave vaalu tok lukala ngaanggis anivasaa-to ond lohvu hil vaalu sen dango vakasin-ambe davu samu osin londpayo nivasa lôôt, de yoo mondapuvu niwêêk lôôt, tombe nôôn nalak.” ");
INSERT INTO mmo_vpl VALUES ("LK8_16","072_8_16","LUK","8","16","16","+ o 8:16 Mat 5:15; Luk 11:33*“Hil davu taalungg hôôk lam ond me-datung hôôk dêêngg alo le, de me-datung lukala pêêt kambini le, malis. Sil davu taalungg hôôk in nambe gatung jamando pêêt baandoni, in landukanaam bayêên alo ond lanji melangaah-anju. ");
INSERT INTO mmo_vpl VALUES ("LK8_17","072_8_17","LUK","8","17","17","+ o 8:17 Mat 10:26; Luk 12:2*De vakasin pin sen neep vunin-ato ond le nanjip langaah, tonde vakasin sen vayum yii-to ond le kavaayin naam langaah pin in hil lanjak ni. ");
INSERT INTO mmo_vpl VALUES ("LK8_18","072_8_18","LUK","8","18","18","+ o 8:18 Mat 25:29; Luk 19:26*Va sen ham nango ond ham akam bu nivasa, in omaaho ti ka navu vakasin nivasa ond Anutu le bu ka vaalu gaving-ambe jak ni lôôt, lemu omaaho ti doosin vakasin, de me-ka navu vakasin ti le, ond kakook daka sen neep vu yii-to Anutu le nôôh vêêl.” ");
INSERT INTO mmo_vpl VALUES ("LK8_19","072_8_19","LUK","8","19","19","Yesu tangganaan osin halindin lato in nambe lanji yi, le ma de hil ngeeyaata lambuuh Yesu tatup, ");
INSERT INTO mmo_vpl VALUES ("LK8_20","072_8_20","LUK","8","20","20","om lanêêl vu nambe, “Tam having halim-aso lato daale voon-ambe dalingin hong.” ");
INSERT INTO mmo_vpl VALUES ("LK8_21","072_8_21","LUK","8","21","21","Le nêêl laah vu sil nambe, “Hil sen dango Anutu-te vakasin-ambe davu samuu-to ond mem sa ataak osin halingg-aso sil.” ");
INSERT INTO mmo_vpl VALUES ("LK8_22","072_8_22","LUK","8","22","22","Busin ti Yesu having yite maanggêêm-aso be lalakala kaanu ti, tombe nêêl vu sil nambe, “Yana betum vaalu.” Om sil lala. ");
INSERT INTO mmo_vpl VALUES ("LK8_23","072_8_23","LUK","8","23","23","Sil mondala tombe Yesu neep ka lingin la, tonde vavi jamba ti laam bopaata tombe bel natêêy lukala kaanu be wiingin nambe naapup, tombe ngaaho lak in davu lana mend nama. ");
INSERT INTO mmo_vpl VALUES ("LK8_24","072_8_24","LUK","8","24","24","Tombe maanggêêm-aso lala layêêvu Yesu be lanêêl vu nambe, “Kaputung, Kaputung-e. Yiiy navu aanggimb-anjo.” Tombe Yesu kandi be nêêl vavi yuuh bel sen nayiis bopaata be nalukala kaanuu-to, tombe vavi ma la de bel neep tatimasin. ");
INSERT INTO mmo_vpl VALUES ("LK8_25","072_8_25","LUK","8","25","25","Tonde nêêl vu sil nambe, “De ham-ame awii-having e?” Tombe kanund la lôôt-ambe yoo lanêêl vu sil nambe, “Omaaho tii-jo mak yi vaati ondeey nêêl vavi yuuh bel tombe yuuh nanyend vuun in lava?” ");
INSERT INTO mmo_vpl VALUES ("LK8_26","072_8_26","LUK","8","26","26","Yesu-so latok lala Gelasa-te taaku ond neep betum vaalu de Galili neep vaalu, ");
INSERT INTO mmo_vpl VALUES ("LK8_27","072_8_27","LUK","8","27","27","tombe Yesu luus vu kaanu be la lonak. Tonde omaaho ti mamu nipaya dahôôvu yi, ond vu taaku bop-anju be hato vu Yesu. Omaahôô-ju yoo nando ninôôn nalak busin pin, lemu me-nando hôôk bayêên ti le, yoo nando hôôk lavandangga sen omaahonôôn bandumb-ato boyambôôy. ");
INSERT INTO mmo_vpl VALUES ("LK8_28","072_8_28","LUK","8","28","28","Tombe omaahôô-ju yi me lak Yesu, tombe la hato pataav baambu neep voon hôôk vaha de nêêl lava bopaata nambe, “Anutu baandoni Noow Yesu, gayêêvu sa in? Sa kataangg hong naambe game gambu nivaane vu sa le.” ");
INSERT INTO mmo_vpl VALUES ("LK8_29","072_8_29","LUK","8","29","29","Mamu nipaya kataangg nambêênju in Yesu nêêl vu lung la nambe gavuuh omaahôô-ju de na. De mamu nipaya nahôôvu omaahôô-ju balon ngeeyaata, tonde hil davu talu yi lak hees aniwêêk osin lasi lok hôôk-ambe napuvu vaha yuuh-ambe daale danggin, le ma de napuuh hees aniwêêk ayuuh ame de mamu nipayaa-ju nawiing-ambe omaahôô-ju nala taaku lumbalaamb. ");
INSERT INTO mmo_vpl VALUES ("LK8_30","072_8_30","LUK","8","30","30","Tombe Yesu lingin nambe, “Ohaalem nambe?” Tombe nêêl nambe “Omaaho-maaho,” in mamu ngeeyaata lalukala omaahôô-ju. ");
INSERT INTO mmo_vpl VALUES ("LK8_31","072_8_31","LUK","8","31","31","Tonde mamu nipayaa-ju kataangg Yesu lôôt nambe me-gatiiy sil lana Saalang-ate taaku lôôt e. ");
INSERT INTO mmo_vpl VALUES ("LK8_32","072_8_32","LUK","8","32","32","De bik ngeeyaata mondaya va daale vahandangga ti ngaaho vu taakuu-ju, om mamu nipayaa-ju kataangg Yesu nambe, “Gambiing-ambe hey aandukana bik-anju londpayo.” Tombe Yesu liinggis, ");
INSERT INTO mmo_vpl VALUES ("LK8_33","072_8_33","LUK","8","33","33","om mamu nipaya lavuuh omaaho sen-anjuuto de lalukala bik alondpayo. Tombe bik pin-anju latup-ambe laluus taaku pake be lalukala betum, tombe lanum bel-ambe layimb valok-ate. ");
INSERT INTO mmo_vpl VALUES ("LK8_34","072_8_34","LUK","8","34","34","Tombe hil sen danggin bik-ato layi tombe lapak-ambe lala lanêêl banye vu hil bayêên bop osin bayêên pasi-pasiv pin. ");
INSERT INTO mmo_vpl VALUES ("LK8_35","072_8_35","LUK","8","35","35","Tombe hil lalaam vu Yesu in nambe lanji vaa-ju, tombe layi omaaho sen mamu nipaya lato lala in-ato, ond lukook anivasa lak-ambe havêêh yite tôômb laah-ande la nando ngaaho vu Yesu vaha, tombe layêênin lôôt. ");
INSERT INTO mmo_vpl VALUES ("LK8_36","072_8_36","LUK","8","36","36","Tonde hil sen layi mend ak va sen Yesu wiing omaaho ti mamu nipaya hôôvu yi bôôy-ambe nivasa lak laah-ato ond latulin vu hil sen lalaam in nambe lanjii-to. ");
INSERT INTO mmo_vpl VALUES ("LK8_37","072_8_37","LUK","8","37","37","Tombe hil vu taaku Gelasaa-ju pin lôôt ond sil kataangg Yesu nambe gavuuh silate taakuu-ju de na. Sil layêênin lôôt ondeey lanêêl nambêênju, om Yesu lakala kaanu in nambe naah. ");
INSERT INTO mmo_vpl VALUES ("LK8_38","072_8_38","LUK","8","38","38","Naahen nalakala tonde omaaho sen mamu lato lala in-ato ond kataangg Yesu nambe, “Sana gaving hong-o.” Le ma de Yesu lonin-ande nêêl vu nambe, ");
INSERT INTO mmo_vpl VALUES ("LK8_39","072_8_39","LUK","8","39","39","“Ganaah gambaam-ambe onaanêêl vu gate hil naambe Anutu ka pasiv in hong-ambe samu hong lôôt.” Om omaahôô-ju laah-ambe nêêl vakasin sen Yesu samu yi be nivasa lak-ato langaah vu yite hil vu taaku bop-anju pin lôôt. ");
INSERT INTO mmo_vpl VALUES ("LK8_40","072_8_40","LUK","8","40","40","Yesu laah valup atombe hil ngeeyaata lapêêlis lôôt, in sil pin oo mondanggin yi. ");
INSERT INTO mmo_vpl VALUES ("LK8_41","072_8_41","LUK","8","41","41","Tonde yêêv dumb-ate ti haale nambe Yailus, ond la vu Yesu be hato pataav baambu neep voon hôôk vaha de kataangg nambe, “Omaaho Bop, ganaam sa baangg, ");
INSERT INTO mmo_vpl VALUES ("LK8_42","072_8_42","LUK","8","42","42","in sa nonggaavêêh timu, yite ta nomaayuuh-ambe laam yuuh, lemu nilak lôôt-ambe neep tombe ngaaho lak in navu jimb.” Om Yesu having-ambe yuuh lala, tombe hil ngeeyaata lambuuh yi vaalu vaalu be lala. ");
INSERT INTO mmo_vpl VALUES ("LK8_43","072_8_43","LUK","8","43","43","Tonde sim vêêh ti nandôô-ju ond vêêh-ate nilakin tovu, tombe yoo nando bayêên pasiv nalak busin pin lohvu ta nomaayuuh-ambe laam yuuh, tombe navu mone vu dokta-so in nambe sil samu yi, tombe yinêên mone lung la, le ma de omaaho ti me-lohvu nambe biing-ambe nivasa jak e. ");
INSERT INTO mmo_vpl VALUES ("LK8_44","072_8_44","LUK","8","44","44","Tombe vêêh-anju valu-naale Yesu dami de hambe nama lak Yesu-te lolop anyendaambu, tombe yite nilakin lung la pavis. ");
INSERT INTO mmo_vpl VALUES ("LK8_45","072_8_45","LUK","8","45","45","Tombe Yesu lingin nambe, “Lati hambe nama lak sa?” Le hil pin lanêêl laah nambe, “Hey o malis-o.” De Pita nêêl nambe, “Kaputung, gahe nambe hil ngeeyaata lambuuh hong tatup om landu hong-anja.” ");
INSERT INTO mmo_vpl VALUES ("LK8_46","072_8_46","LUK","8","46","46","Le ma de Yesu nêêl nambe, “Omaaho ti hambe nama lak sa. Sa lak ni nambe sate niwêêk hato la be wiing omaaho ti nivasa lak.” ");
INSERT INTO mmo_vpl VALUES ("LK8_47","072_8_47","LUK","8","47","47","Tonde vêêh-anju lak ni nambe yite vakasin tok langaah om hees lôôt, tombe la hato pataav baambu neep voon hôôk Yesu vaha, de nêêl vakasin sen hambe nama lak Yesuu-to dangga langaah hôôk hil pin amend osin vakasin sen nivasa lak pavi-vasaato. ");
INSERT INTO mmo_vpl VALUES ("LK8_48","072_8_48","LUK","8","48","48","+ o 8:48 Luk 7:50*Tombe Yesu nêêl vu nambe, “Nonggaavêêh, gawii-having ondeey ganim vasa lak, om gana osin galompayo ahelavis.” ");
INSERT INTO mmo_vpl VALUES ("LK8_49","072_8_49","LUK","8","49","49","Yesu naahen monanêêl atonde omaaho ti vu Yailus ambaan-ambe hato nêêl vu Yailus nambe, “Nomaavêêh ame yip, om onaanêêl vu yêêv naambe mando de me-naam e, jip.” ");
INSERT INTO mmo_vpl VALUES ("LK8_50","072_8_50","LUK","8","50","50","Yesu hango vakasin-anju tombe nêêl vu Yailus nambe, “Game naham jak e, gambiing gaving amu le mem nomaavêêh e nivasa jak naah.” ");
INSERT INTO mmo_vpl VALUES ("LK8_51","072_8_51","LUK","8","51","51","Tombe Yesu la yêêv-anjuuto baan. La hato tombe lonin hil pin, de hako Pita having Jon ayuuh Jems tonde unaavepasiv mangganaan ayuuh tangganaan, be yik sil-anjo yoo lalukala bayêên alo having Yesu. ");
INSERT INTO mmo_vpl VALUES ("LK8_52","072_8_52","LUK","8","52","52","+ o 8:52 Luk 7:13*Tombe hil pin mondasu be davu kaatuuh sil in unaavepasiv-anju, le Yesu nêêl nambe, “Ham-ame naasu le, me-yimb e, nganjo yoo neep anêên.” ");
INSERT INTO mmo_vpl VALUES ("LK8_53","072_8_53","LUK","8","53","53","Le sil lanop ak yi, in sil lalak ni nambe unaavepasiv-anjo yimb, ");
INSERT INTO mmo_vpl VALUES ("LK8_54","072_8_54","LUK","8","54","54","+ o 8:54 Luk 7:14*le Yesu lôôh hôôk unaavepasiv nama de nêêl vu nambe, “Unaavepasiv, okandi jak.” ");
INSERT INTO mmo_vpl VALUES ("LK8_55","072_8_55","LUK","8","55","55","Tombe kanu hato lukalaah-ambe kandi lak pavis, tonde Yesu nêêl vu sil nambe, “Ham ambu vanôôn vu be ja.” ");
INSERT INTO mmo_vpl VALUES ("LK8_56","072_8_56","LUK","8","56","56","+ o 8:56 Mak 7:36; Luk 5:14*Tombe unaavepasiv-anju mangganaan ayuuh tangganaan kanund la lôôt, tombe Yesu vu kôôvu yuuh nambe yuuh-ame daanêêl vaa-jo banye vu omaaho ti le. ");
INSERT INTO mmo_vpl VALUES ("LK9_1","072_9_1","LUK","9","1","1","Yesu teey yite maanggêêm nomaayuuh-ambe laam yuuh-ato lalaam vu yi be vu niwêêk bopaata lukala sil, in nambe sil gatiiy mamu nipaya lana in omaahonôôn, de lambiing-ambe hil anind lakin anind vasa jak. ");
INSERT INTO mmo_vpl VALUES ("LK9_2","072_9_2","LUK","9","2","2","Tonde mem wiing sil lala in daanêêl vakasin sen Anutu nanggin yite hil-ato, de lambiing-ambe hil anind lakin anind vasa jak. ");
INSERT INTO mmo_vpl VALUES ("LK9_3","072_9_3","LUK","9","3","3","Tombe nêêl vu sil nambe, “Ham-ame gako vati be ham ana mop e. Ham-ame namam dôôk paatôôn e, de ham-ame gako vaahes osin vanôôn-ambe mone le, tonde ham-ame gako lolop yu-yuuh e. ");
INSERT INTO mmo_vpl VALUES ("LK9_4","072_9_4","LUK","9","4","4","+ o 9:4 Luk 10:4-11*Tonde ham anjakana bayêên ti, ond yik ham oo mando lak bayêên tii-ju nivalok-ambe na balup busin sen ham gavuuh sil-ato, ond mem ham ana taaku ango. ");
INSERT INTO mmo_vpl VALUES ("LK9_5","072_9_5","LUK","9","5","5","+ o 9:5 Luk 10:11; Sin 13:51*De naambe hil vu taaku ti me-lako ham ak e, ond ham gavuuh taakuu-ju na, de ham tatehin kambus sen nando lak ham vaham-ato naah in taato silate nipaya langaah.” ");
INSERT INTO mmo_vpl VALUES ("LK9_6","072_9_6","LUK","9","6","6","Nêêl lung la tonde mem sil lala latup hôôk-ambe lanêêl banye nivasa osin lawiing hil anilakin ngeeyaata nind vasa lak lohvu taaku pin. ");
INSERT INTO mmo_vpl VALUES ("LK9_7","072_9_7","LUK","9","7","7","+ o 9:7 Mat 16:14; Mak 8:28; Luk 9:19*Yêêv bop Helot hango Yesu-te vakasin pin-anju banye, tombe ka la ngeey lôôt, in hil vaalu danêêl nambe, “Jon sen nalipis hil-ato kandi lak laah vu hil yimbin-ate.” ");
INSERT INTO mmo_vpl VALUES ("LK9_8","072_9_8","LUK","9","8","8","Tonde hil vaalu danêêl nambe, “Eliya sen nanêêl Anutu-te vakasin langaah bôôy-ato lo-valup-anju.” De vaalu danêêl nambe, “Hil sen danêêl Anutu-te vakasin langaah bôôy-ato ond ti kandi lak vu hil yimbin-ate.” ");
INSERT INTO mmo_vpl VALUES ("LK9_9","072_9_9","LUK","9","9","9","+ o 9:9 Luk 23:8*Tombe Helot nêêl nambe, “Sa katôôv Jon aka lung laa-to, de sim omaahôô-ju yi lati sen sa nango vakasin ak yii-ju?” Om yoo wiingin nambe ji Yesu. ");
INSERT INTO mmo_vpl VALUES ("LK9_10","072_9_10","LUK","9","10","10","Tonde sinaale-so sen Yesu wiing sil lalaa-to ond lasupin lalom vu be latulin va pin sen lawiing-ato vu Yesu. Tombe havuuh hil vaalu de hako sinaale-so mu be sil oo lala taaku ti haale nambe Betsaida, ");
INSERT INTO mmo_vpl VALUES ("LK9_11","072_9_11","LUK","9","11","11","lemu hil ngeeyaata lango nambe lala taaku tii-ju om sil taamuyin-ambe lala. Sil lalup atombe mem pêêlis in sil, de nêêl tanasin ak Anutu nanggin yite hil-ato vu sil, tonde wiing-ambe hil anilakin anind vasa lak. ");
INSERT INTO mmo_vpl VALUES ("LK9_12","072_9_12","LUK","9","12","12","Tonde soosin hôôk atombe yite maanggêêm nomaayuuh-ambe laam yuuh-ato lala lanêêl vu nambe, “Taaku me lung la de yiiy nandôô-jo taaku lumbalaamb, om onaanêêl-ambe hil-anju lana bayêên ti ti sen nando ngaahôô-to be sil baanggo silate vanôôn-ambe danjip-anju.” ");
INSERT INTO mmo_vpl VALUES ("LK9_13","072_9_13","LUK","9","13","13","Le ma de nêêl vu sil nambe, “Yik ham oo ambu vanôôn vu sil.” Le lanêêl vu nambe, “Heyanêêngg vanôôn-ame ngeey e, yik balet namaavaalu having paahuung yuuh amu neep. Mak gawiingin nambe hey ana baanggo vanôôn vu hil pin-anju?” Hil-anju moow ngeeyaata lôôt lohvu 5 taosen. ");
INSERT INTO mmo_vpl VALUES ("LK9_14","072_9_14","LUK","9","14","14","Tombe Yesu nêêl vu yite maanggêêm-aso nambe, “Ham naanêêl-ambe sil gato mando lu ti ti nohvu doo-yuuh-ambe nomaayuuh-maayuuh.” ");
INSERT INTO mmo_vpl VALUES ("LK9_15","072_9_15","LUK","9","15","15","Om yik yite maanggêêm-aso lanêêl-ambe hil lato dando lu ti ti. ");
INSERT INTO mmo_vpl VALUES ("LK9_16","072_9_16","LUK","9","16","16","Tonde mem Yesu hako balet namaavaalu de paahuung yuuh-ato be valaah me lak baandoni de lohak, le mem hapok-ambe vu vu yite maanggêêm-aso be sil latiiy lohvu hil. ");
INSERT INTO mmo_vpl VALUES ("LK9_17","072_9_17","LUK","9","17","17","Tombe omaahonôôn pin yoo laya be lohvu sil. Laya lung atonde sil lasupin nyengale hôôk jaambang nomaayuuh-ambe laam yuuh-ambe pup. ");
INSERT INTO mmo_vpl VALUES ("LK9_18","072_9_18","LUK","9","18","18","Busin ti Yesu timu yoo monalohak nando, tombe yite maanggêêm-aso dando having yi om lingin sil nambe, “Hil danêêl nambe sa lati?” ");
INSERT INTO mmo_vpl VALUES ("LK9_19","072_9_19","LUK","9","19","19","+ o 9:19 Luk 9:7-8*Tombe sil lanêêl laah nambe, “Hil vaalu danêêl hong nambe Jon sen nalipis hil-ato, de vaalu danêêl hong nambe Eliya, de vaalu danêêl hong nambe hil sen danêêl Anutu-te vakasin langaah bôôy-ato ti kandi lak laah.” ");
INSERT INTO mmo_vpl VALUES ("LK9_20","072_9_20","LUK","9","20","20","+ o 9:20 Jon 6:68-69*Tonde lingin sil nambe, “De ham-ok? Ham nanêêl sa nambe lati?” Tombe Pita nêêl vu nambe, “Hong Anutu-te omaaho sen yoo holin hong vulôôt in nambe gandôôvu hey-ato.” ");
INSERT INTO mmo_vpl VALUES ("LK9_21","072_9_21","LUK","9","21","21","Pita nêêl nambêênju tombe Yesu vu kôôvu sil niwêêk lôôt nambe sil-ame daanêêl yi langaah vu omaaho ti le, ");
INSERT INTO mmo_vpl VALUES ("LK9_22","072_9_22","LUK","9","22","22","+ o 9:22 Luk 9:44; 18:32-33*tonde mem nêêl nambe, “Omaahonôôn Noow e gako nivaane ngeeyaata. In himbop-aso osin kul vaha sen datung salivangin-ato silate yêêv-aso de tanasin dangga-so ond sil e nind baya in-ande lanyiis-ambe jimb, tonde busin naatu yaal e mem le kandi jak naah.” ");
INSERT INTO mmo_vpl VALUES ("LK9_23","072_9_23","LUK","9","23","23","+ o 9:23 Mat 10:38; Luk 14:27*Tonde yik nêêl vu hil pin-anju nambe, “Omaaho ti wiingin nambe sapa sa ond yoo daanggôôl yi, le mem kava yite haah pako nohvu busin pin-ambe sapa sa. ");
INSERT INTO mmo_vpl VALUES ("LK9_24","072_9_24","LUK","9","24","24","+ o 9:24 Mat 10:39; Luk 17:33; Jon 12:25*De omaaho ti yoo wiingin nambe ganggin ninaavi nivasa in mando metumin, ond le jimb-ambe na menama osin nôôn metumin-ate. Le omaaho ti baaku nimeen ak sa haalengg-ambe jimb, ond mem le mando metumin danggata. ");
INSERT INTO mmo_vpl VALUES ("LK9_25","072_9_25","LUK","9","25","25","Le omaaho ti gôôlis va voon-ate pin, de yoo biliyak yi be gako nivaane be mando danggata, ond va voon-ate me-le dôôvu yi le, le nama. ");
INSERT INTO mmo_vpl VALUES ("LK9_26","072_9_26","LUK","9","26","26","+ o 9:26 Mat 10:33; Luk 12:9; 2Ti 2:12*De naambe omaaho ti jêênin omaahonôôn-ande nimbaya in sa osin sate vakasin, de me-naanêêl sa haalengg langaah vu hil e, ond busin sen Omaahonôôn Noow nom osin yite nikaapulis-ande Mangganaan-ate nikaapulis tonde angela vaambuung-ate nikaapulis-ato ond le nimbaya in omaahôô-ju dukanaah. ");
INSERT INTO mmo_vpl VALUES ("LK9_27","072_9_27","LUK","9","27","27","Om sa naanêêl keen lôôt vu ham naambe ham sen ham naalêê-jo, ond vaalu me-le lanjimb e, de lanji naambe Anutu ganggin yite hil-ato le mem.” ");
INSERT INTO mmo_vpl VALUES ("LK9_28","072_9_28","LUK","9","28","28","Tonde busin namaavaalu be vindak yaal la vêêl e, mem Yesu hako Pita yuuh Jon-ande Jems-ambe sil oo lalakala kandu ti in nambe Yesu nohak. ");
INSERT INTO mmo_vpl VALUES ("LK9_29","072_9_29","LUK","9","29","29","Tombe monalohak le sim mekaalus ango yoow ak osin yite lolop têêlang-ambe nivalôôy lôôt. ");
INSERT INTO mmo_vpl VALUES ("LK9_30","072_9_30","LUK","9","30","30","Tombe sim omaaho yuuh daale mondakaas having Yesu, ond yik Mose yuuh Eliya, ");
INSERT INTO mmo_vpl VALUES ("LK9_31","072_9_31","LUK","9","31","31","+ o 9:31 Luk 9:22; 13:33*ond yuuh lalaam daale osin nikaapulis-ambe yuuh danêêl va sen Yesu le biing vu Yelusalem-ande gavuuh voon-anjo de naa-to. ");
INSERT INTO mmo_vpl VALUES ("LK9_32","072_9_32","LUK","9","32","32","+ o 9:32 Jon 1:14; 2Pi 1:16-18*Tombe Pita yaal amend animeen om yaal lawiingin nambe danjip, le ma de yaal amend tum lôôt-ambe yaal layi Yesu-te nikaapulis osin omaaho yuuh sen daale having yii-to. ");
INSERT INTO mmo_vpl VALUES ("LK9_33","072_9_33","LUK","9","33","33","Tombe omaaho yuuh-anjuuto lawiing in nambe gavuuh Yesu de yuuh lanaah, tonde Pita nêêl vu Yesu nambe, “Omaaho Bop, yiiy nandôô-jo nivasa lôôt, om waay andaav numang daka yaal, gate ti, Mose-te ti, de Eliya-te ti.” Pita doosin va sen naanêêl-ato ondeey nêêl vakasin-anju. ");
INSERT INTO mmo_vpl VALUES ("LK9_34","072_9_34","LUK","9","34","34","Naahen nanêêl atonde bayiimb ti hato be vayum sil, tombe yaal layêênin lôôt, ");
INSERT INTO mmo_vpl VALUES ("LK9_35","072_9_35","LUK","9","35","35","+ o 9:35 Luk 3:22*tonde lava ti laam hôôk bayiimb-anju lopayo nambe, “Sa Noongg-anja. Soo aaholin yi om ham gango lava.” ");
INSERT INTO mmo_vpl VALUES ("LK9_36","072_9_36","LUK","9","36","36","Lavaa-ju lung la tonde yaal layi Yesu yoo timu naale. Ond va sen yaal layii-ju ond yaal lavun vakasin, de yaal-ame lanêêl vu omaaho ti le, de la taamusin lôôt e mem. ");
INSERT INTO mmo_vpl VALUES ("LK9_37","072_9_37","LUK","9","37","37","Tonde heendiiy atombe sil vu kandu be lato, tombe hil ngeeyaata lôôt lalup latovu Yesu vu mop. ");
INSERT INTO mmo_vpl VALUES ("LK9_38","072_9_38","LUK","9","38","38","Tombe hil-anju ti teey nambe, “Kaputung, sa kataangg hong naambe gangge sa noongg moow timuu-jo, ");
INSERT INTO mmo_vpl VALUES ("LK9_39","072_9_39","LUK","9","39","39","ond mamu nipaya nahôôvu tombe napuvu niwêêk, tonde pavis atombe nangeeyak bopaata, tonde mamu nipayaa-ju nandu yi lôôt, tombe nyekaakôôs nalaam osin nawiing nindanjeen vu lôôt, tombe me-nalung nala pavis e. ");
INSERT INTO mmo_vpl VALUES ("LK9_40","072_9_40","LUK","9","40","40","Tombe sa kataangg gate maanggêêm-aso nambe sil gatiiy mamu nipayaa-ju na, le me-lalohvu le.” ");
INSERT INTO mmo_vpl VALUES ("LK9_41","072_9_41","LUK","9","41","41","Tombe Yesu nêêl nambe, “Ham pin-anjo ham-ame awii-having e, om ham alompayo me-nivalok e. De sa mando gaving ham-ambe naangelis e ham anjak sate kul ani? De sa gako nimeen in ham nohvu busin vilis e? Onggako noom naam e.” ");
INSERT INTO mmo_vpl VALUES ("LK9_42","072_9_42","LUK","9","42","42","Tombe lako unoopasiv-ambe daahen dalaam, tonde mamu handu unoopasiv pavis-ande lupake be la neep nahaahin neep voon. Tombe Yesu nêêl mamu nipayaa-ju, de wiing-ambe unoopasiv anivasa lak, de mamu me-hôôvu yi laah e, tombe Yesu nêêl vu mangganaan nambe, “Noom nganjo.” ");
INSERT INTO mmo_vpl VALUES ("LK9_43","072_9_43","LUK","9","43","43","Tombe hil pin kanund la lôôt in Anutu-te niwêêk bopaataa-ju. Tombe sil oo daahen kand yu-yuuh lôôt in va pin sen Yesu wiing-anjuuto, tonde Yesu nêêl vu yite maanggêêm-aso nambe, ");
INSERT INTO mmo_vpl VALUES ("LK9_44","072_9_44","LUK","9","44","44","+ o 9:44 Luk 9:22*“Ham oo gambe nanyem in vakasin-anjo nivasa, in davu lambu Omaahonôôn Noow dukana hil namand.” ");
INSERT INTO mmo_vpl VALUES ("LK9_45","072_9_45","LUK","9","45","45","+ o 9:45 Luk 18:34*Le vakasin-anjo dangga vun yi in maanggêêm-aso om sil doosin, tombe sil layêênin nambe me-lanjingin yi le. ");
INSERT INTO mmo_vpl VALUES ("LK9_46","072_9_46","LUK","9","46","46","+ o 9:46 Luk 22:24*Yesu-te maanggêêm-aso mondakaas in nambe sil ti tana tu lukook bop vu ango-so. ");
INSERT INTO mmo_vpl VALUES ("LK9_47","072_9_47","LUK","9","47","47","Tombe Yesu lak ni nambe sil akand navu va nambêênju naale hôôk sil alondpayo om laandiiy unoopasiv ti laam naale having yi, ");
INSERT INTO mmo_vpl VALUES ("LK9_48","072_9_48","LUK","9","48","48","+ o 9:48 Mat 10:40; Luk 10:16; Jon 13:20*le mem nêêl vu sil nambe, “Omaaho ti ka bu sa haalengg-ambe gako unoopasiv-anjo jak, ond lohvu hako sa lak. Tombe hako sa lak ond lohvu hako omaaho sen wiing sa laam-ato lak. Om ham ti sen haale pasiv lôôt hôôk ham lavuun-ato ond yii-ju haale bop.” ");
INSERT INTO mmo_vpl VALUES ("LK9_49","072_9_49","LUK","9","49","49","Tonde Jon nêêl vu nambe, “Kaputung-e, hey aahe omaaho ti natiiy mamu nipaya lak ohaalem, le ma de hey aanêêlin yi in nambe me-navu taamuyin hong having hey e.” ");
INSERT INTO mmo_vpl VALUES ("LK9_50","072_9_50","LUK","9","50","50","+ o 9:50 Mat 12:30; Luk 11:23*Le Yesu nêêl vu nambe, “Ham-ame naanêêlin yi le. Hil sen me-dayi ham payaa-to ond manyinja hamate hil.” ");
INSERT INTO mmo_vpl VALUES ("LK9_51","072_9_51","LUK","9","51","51","+ o 9:51 Mak 10:32*Busin sen Anutu navu gako Yesu naah baandonii-to laam ngaaho lak, tombe Yesu ka vu lung la nambe na Yelusalem, ");
INSERT INTO mmo_vpl VALUES ("LK9_52","072_9_52","LUK","9","52","52","om wiing hil vaalu lako vakasin-ambe lamunggin. Sil mondala be lalukala hil Samaalia baand ti, tombe sil lawiingin nambe samu taaku ti vu Yesu, ");
INSERT INTO mmo_vpl VALUES ("LK9_53","072_9_53","LUK","9","53","53","+ o 9:53 Jon 4:9*lemu hil bayêên-anju lalak ni nambe Yesu yoo navu balup-ambe na Yelusalem, om lavu teenin silate bayêên nambe hil-ame gako Yesu jakana le. ");
INSERT INTO mmo_vpl VALUES ("LK9_54","072_9_54","LUK","9","54","54","+ o 9:54 2King 1:9-16*Tombe Yesu-te maanggêêm yuuh Jems ayuuh Jon layi vaa-ju, tombe yuuh lanêêl vu Yesu nambe, “Omaaho Bop, gawiingin nambe hey naateey kin vu baandoni naam-ambe ja hil-anju?” ");
INSERT INTO mmo_vpl VALUES ("LK9_55","072_9_55","LUK","9","55","55","Le Yesu hilin laah-ambe nêêl yuuh, ");
INSERT INTO mmo_vpl VALUES ("LK9_56","072_9_56","LUK","9","56","56","tonde sil lala bayêên ango lak. ");
INSERT INTO mmo_vpl VALUES ("LK9_57","072_9_57","LUK","9","57","57","Sil daahen dalaas mop atonde omaaho ti nêêl vu Yesu nambe, “Taaku pin sen ganaa-to ond sale taamuyin hong-ambe sana gaving.” ");
INSERT INTO mmo_vpl VALUES ("LK9_58","072_9_58","LUK","9","58","58","Le Yesu nêêl vu nambe, “Manggalôôn ond deep hôôk haah vuun, de manak ond dahaav vunis, nganjo Omaahonôôn Noow ond baan sen nanjip hôôk-ato ma.” ");
INSERT INTO mmo_vpl VALUES ("LK9_59","072_9_59","LUK","9","59","59","Tonde Yesu nêêl vu omaaho ango nambe, “Ganaam taamuyin sa.” Le nêêl nambe, “Omaaho Bop, ganjiinggis-ande sana ganggin mangg-ambe jimb-ambe sa daav vêêl e.” ");
INSERT INTO mmo_vpl VALUES ("LK9_60","072_9_60","LUK","9","60","60","Le Yesu nêêl vu nambe, “Hil sen nanyend doos in Anutu-te vakasin ond sil oo lana landaav silate halanjang, de hong ond gana naanêêl banye nivasa sen Anutu nanggin yite hil-ato langaah.” ");
INSERT INTO mmo_vpl VALUES ("LK9_61","072_9_61","LUK","9","61","61","+ o 9:61 1King 19:20*Tonde omaaho ti nêêl vu nambe, “Omaaho Bop, sale taamuyin hong, lemu ganjiinggis-ande sa naah naanêêl vu sate hil vu sa baangg vêêl e.” ");
INSERT INTO mmo_vpl VALUES ("LK9_62","072_9_62","LUK","9","62","62","Le Yesu nêêl vu nambe, “Omaaho ti nawiing kul ti lemu naate me nala vaalu vaalu, ond hil naambêênju me-lohvu nambe landukana be mando gaving Anutu-te hil e.” ");
INSERT INTO mmo_vpl VALUES ("LK10_1","072_10_1","LUK","10","1","1","+ o 10:1 Mak 6:7*Omaaho Bop holin hil sen davu taamuyin yii-to doo-yaal-ambe nomaayuuh, tombe mem wiing sil yuyuuh-ambe sil lamunggin-ambe lala taaku pin sen taamusin e Yesu le naa-to. ");
INSERT INTO mmo_vpl VALUES ("LK10_2","072_10_2","LUK","10","2","2","+ o 10:2 Mat 9:37-38; Jon 4:35*Tombe nêêl vu sil nambe, “Vanôôn ngeeyaata nôôn ak hôôk kulaanôôn lung la be nando, lemu hil kul vaha-so daka yuuh amu, om ham kataangg kul mangganaan in biing hil kul vaha-so vaalu lana daasupin yite vanôôn gaving. ");
INSERT INTO mmo_vpl VALUES ("LK10_3","072_10_3","LUK","10","3","3","+ o 10:3 Mat 10:16*Om ham ana de ham gango le, saambiing-ambe ham ana naambe sen bik sipsip-ato melaas in nambe ham andukana voow bamaan lavuun. ");
INSERT INTO mmo_vpl VALUES ("LK10_4","072_10_4","LUK","10","4","4","+ o 10:4-11 Mat 10:7-14; Mak 6:8-11; Luk 9:3-5*De ham-ame gako mone osin vaahes ayuuh suul e, de ham-ame baale bakaas gaving hil vu mopaatôôv e. ");
INSERT INTO mmo_vpl VALUES ("LK10_5","072_10_5","LUK","10","5","5","De ham anjakana bayêên ti ond ham naanêêl naambêênjo naamunggin naambe, ‘Vakasin melaas mando gaving ham bayêên tii-ja.’ ");
INSERT INTO mmo_vpl VALUES ("LK10_6","072_10_6","LUK","10","6","6","Naambe hil vakasin amelaas dando hôôk bayêên-anju, ond vakasin melaas sen ham avu vu sil-ato le na mando gaving sil. Le naambe hil vakasin amelaas ti me-nandôô-ju le, ond hamate vakasin melaas sen ham avu vu sil-ato yoo le gilin-ambe nom vu ham. ");
INSERT INTO mmo_vpl VALUES ("LK10_7","072_10_7","LUK","10","7","7","+ o 10:7 1Ko 9:6-14; 1Ti 5:18*De bayêên ti sen ham nando lak-ato ond yik ham oo mandôô-ju nivalok, tombe ham angga osin ham naanum va sen lambu vu ham-ato, in omaaho sen nawiing kul-ato ond lohvu nambe hil baanggo yi, tonde ham-ame gatup hôôk bayêên pin e. ");
INSERT INTO mmo_vpl VALUES ("LK10_8","072_10_8","LUK","10","8","8","+ o 10:8 1Ko 10:27*De ham ana gato taaku ti be sil gako ham jakana silate bayêên, ond ham angga vanôôn sen sil lambu vu ham-ato, ");
INSERT INTO mmo_vpl VALUES ("LK10_9","072_10_9","LUK","10","9","9","tonde ham ambiing hil anilakin vu taakuu-ju be nind vasa jak, de ham naanêêl vu sil naambe, ‘Anutu nanggin yite hil-ato laam nando hôôk ham lavuun lung la.’ ");
INSERT INTO mmo_vpl VALUES ("LK10_10","072_10_10","LUK","10","10","10","De ham ana gato taaku ti le me-lako ham alukala silate bayêên e, ond ham anaah baale mop-ande ham naanêêl naambe, ");
INSERT INTO mmo_vpl VALUES ("LK10_11","072_10_11","LUK","10","11","11","+ o 10:11 Sin 13:51; 18:6*‘Hamate kambus sen yalak ak hey vahangg vu taakuu-jaato ond hey tatehin los vu ham, lemu ham gango le, Anutu laam nanggin yite hil lung la.’ Ke, om ham naanêêl naambêênjo vu sil. ");
INSERT INTO mmo_vpl VALUES ("LK10_12","072_10_12","LUK","10","12","12","+ o 10:12 Mat 10:15; 11:24; Jen 19:24-25*De sa naanêêl vu ham naambe vu busin taamusin sen Anutu gangoyin omaahonôôn pin-ate vakasin-ato ond hil vu taakuu-ju le daatovu nimeen bopaata kaluuh hil Sodom.” ");
INSERT INTO mmo_vpl VALUES ("LK10_13","072_10_13","LUK","10","13","13","+ o 10:13 Mat 11:21-23*“Ham Kolasin, de ham Betsaida, ham e naatovu nimeen, in nambe saambiing taahu taahu osin niwêêk ngeeyaata vu Taia osin Saidon naambe sen saawiing vu hamate taakuu-to, ond bôôy hil Taia osin Saidon e gayêêh vaahes-ambe sil mando osin nind ngook, in taato naambe londpayo nimeen in silate va nipaya om lahilin sil laah vu Anutu. ");
INSERT INTO mmo_vpl VALUES ("LK10_14","072_10_14","LUK","10","14","14","Om vu busin taamusin sen Anutu gangoyin omaahonôôn pin-ate vakasin-ato ond ham e naatovu nimeen bopaata kaluuh Taia osin Saidon. ");
INSERT INTO mmo_vpl VALUES ("LK10_15","072_10_15","LUK","10","15","15","“De ham Kapenaum-anja, hamambe Anutu le gako ham jakana baandoni? Malis, ham e andukana taaku nipaya.” ");
INSERT INTO mmo_vpl VALUES ("LK10_16","072_10_16","LUK","10","16","16","+ o 10:16 Mat 10:40; Luk 9:48; Jon 5:23*Tonde nêêl vu yite maanggêêm-aso nambe, “Hil sen dango ham lavam-ato ond manyinja dango sa lavangg. De hil sen daluuh damind vu ham-ato ond yik daluuh damind vu sa having. Tombe hil sen daluuh damind vu saa-to ond lohvu daluuh damind vu omaaho sen wiing sa be sa laam-ato.” ");
INSERT INTO mmo_vpl VALUES ("LK10_17","072_10_17","LUK","10","17","17","Yesu wiing hil doo-yaal-ambe nomaayuuh-ato lala kul lung la de lalo-lato, tombe kand vasa lôôt de lanêêl nambe, “Omaaho Bop, hey naanêêl ohaalem atombe mamu nipaya nanyend vuun in hey lavangg having.” ");
INSERT INTO mmo_vpl VALUES ("LK10_18","072_10_18","LUK","10","18","18","+ o 10:18 Jon 12:31; Taato 12:8-9*Tombe Yesu nêêl vu sil nambe, “Saahe de Saalang lupake vu baandoni nambe sen demak vêêl-ato. ");
INSERT INTO mmo_vpl VALUES ("LK10_19","072_10_19","LUK","10","19","19","+ o 10:19 Jen 3:15; Saam 91:13; Mak 16:18*Ham angge, saavu niwêêk lung vu ham om ham alohvu nambe ham baake nyêêy ayuuh gaalivang, osin ham alohvu nambe ham daanggôôl Saalang-ate niwêêk pin, de vati me-le biing ham e. ");
INSERT INTO mmo_vpl VALUES ("LK10_20","072_10_20","LUK","10","20","20","+ o 10:20 Mat 7:22; Eks 32:32; Pil 4:3; Taato 3:5*Om ham-ame kam vasa naambe mamu nipaya-so nanyend vuun in ham lavam e, nganjo ham akam vasa in Anutu kaavu ham haalem neep vu baandoni lung la.” ");
INSERT INTO mmo_vpl VALUES ("LK10_21","072_10_21","LUK","10","21","21","+ o 10:21 1Ko 1:26-28*Hôôk busin-anju Vavi Vaambuung hôôvu Yesu be ahe nivasa lôôt, om lohak nambe, “O Aamangg, hong Omaaho Bop vu baandoni osin voon. Sa naapêêlis vu hong, in gavun va pin-anjo in hil sen omaahonôôn dayi sil nambe hil osin kand bop-ande hil alukook bop, tonde otaato langaah vu hil mali-malis. Keen Aamangg, in goo gahe nivasa ondeey gawiing nambêênja.” ");
INSERT INTO mmo_vpl VALUES ("LK10_22","072_10_22","LUK","10","22","22","+ o 10:22 Jon 3:35; 10:15*Yesu lohak lung atonde nêêl vu sil nambe, “Aamangg vu va pin lukala sa namangg lung la, de omaaho ti me-lak Noow ani le, Mangganaan timu yoo lak ni. De omaaho ti me-lak Mangganaan ani le, Noow oo lak ni, de hil sen Noow navu tatekin Mangganaan vu sil-ato ond mem lalak Mangganaan ani having.” ");
INSERT INTO mmo_vpl VALUES ("LK10_23","072_10_23","LUK","10","23","23","+ o 10:23 Mat 13:16-17*Maanggêêm-aso yoo dando having Yesu tombe mem hilin laah vu sil-ambe nêêl nambe, “Ham ond ham akam vasa in ham amem nayi va nambêênjo. ");
INSERT INTO mmo_vpl VALUES ("LK10_24","072_10_24","LUK","10","24","24","+ o 10:24 1Pi 1:10*De sa naanêêl vu ham naambe bôôy hil sen danêêl Anutu-te vakasin langaah-ato osin hil alulemak ngeeyaata datung mend in nambe lanji va sen ham nahêê-jo, le ma de me-layi le, de dambe nanyend in nambe gango vakasin sen ham nangôô-jo, le ma de me-lango le.” ");
INSERT INTO mmo_vpl VALUES ("LK10_25","072_10_25","LUK","10","25","25","+ o 10:25 Mat 22:35-40; Mak 10:17; Luk 18:18*Tombe tanasin dangga ti laam in nambe sahi Yesu, om lingin nambe, “Kaputung, saambiing vaati le mem sa mando metumin danggata?” ");
INSERT INTO mmo_vpl VALUES ("LK10_26","072_10_26","LUK","10","26","26","Tombe Yesu nêêl vu nambe, “Mose kaavu Anutu-te tanasin vaaheey neep hôôk kaapiyaa-to? Gasevin nambe vaati?” ");
INSERT INTO mmo_vpl VALUES ("LK10_27","072_10_27","LUK","10","27","27","+ o 10:27 Diu 6:5; Lev 19:18*Tombe nêêl laah nambe, “Tanasin nêêl nambe, ‘Gahem gaving gate Omaaho Bop Anutu osin galompayo doos de okanum doos, de gakam na doos, osin ganimwêêk na doos vu yi timu, de gahem gaving hil sen dando ngaaho vu hong naambe sen gahem oo naving hong-ato.’” ");
INSERT INTO mmo_vpl VALUES ("LK10_28","072_10_28","LUK","10","28","28","+ o 10:28 Lev 18:5; Lom 10:5; Gal 3:12*Tombe Yesu nêêl vu nambe, “Ganêêl lohvu. Gambiing naambêênja ond mem gale mando metumin danggata.” ");
INSERT INTO mmo_vpl VALUES ("LK10_29","072_10_29","LUK","10","29","29","Lemu tanasin dangga tii-ju yoo wiingin nambe haale nanjip nivasa om lingin Yesu nambe, “De hil sen dando ngaaho vu sa ond laheey?” ");
INSERT INTO mmo_vpl VALUES ("LK10_30","072_10_30","LUK","10","30","30","Tombe Yesu nêêl laah vu nambe, “Om onggango le, omaaho ti vu Yelusalem-ambe luus-ambe la in na Yeliko, tombe hil hôôndak-aso latovu neep mop, tombe lahôôndak yinêên lolop ayuuh ame, de layiis lôôt, tombe yoo neep mop lavuun-ande lalom-ambe lala, tonde ngaaho lak in nambe jimb. ");
INSERT INTO mmo_vpl VALUES ("LK10_31","072_10_31","LUK","10","31","31","Tombe hôôk busin-anju kul vaha sen datung salivangin-ato ti loh mop-anju be la hato, le yi de omaahôô-ju neep tombe hato loh nanye in-ambe la. ");
INSERT INTO mmo_vpl VALUES ("LK10_32","072_10_32","LUK","10","32","32","Tonde yik Liwi-te hil vu taamusin-ato ti hato tovu omaahôô-ju neep mop, le ma de hato loh nanye in-ambe la. ");
INSERT INTO mmo_vpl VALUES ("LK10_33","072_10_33","LUK","10","33","33","Lemu Samaalia ti monalaam-ambe hato tovu omaaho sen neep mop-anju, om yi tombe ka pasiv lôôt in yi. ");
INSERT INTO mmo_vpl VALUES ("LK10_34","072_10_34","LUK","10","34","34","Tombe la hato nando ngaaho vu be kaasêêh hahaanôôn aniluk osin wain hôôk nipayêês de vavil, tonde lôôh omaahôô-ju lak-ambe hatung lakala yite bik donggi, de hako be yuuh lala be lalakala bayêên vaatêêvak-ate ti, tombe yoo hanggin nivasa lôôt. ");
INSERT INTO mmo_vpl VALUES ("LK10_35","072_10_35","LUK","10","35","35","Tonde samiinaanôôn atombe hôôl mone doo-ti be vu vu bayêên vaatêêvak-anjuuto mangganaan, de nêêl vu nambe, ‘Ongganggin omaahôô-jo nivasa. Naambe gambu va ngeeyaata savok mone doo-tiinjo, ond busin sen saanom balup-ato ond sale aambu dôôk gate.’” ");
INSERT INTO mmo_vpl VALUES ("LK10_36","072_10_36","LUK","10","36","36","Tonde Yesu lingin nambe, “Om gakam vu nambe omaaho yaal-anju ond ti tana tu omaaho nipayaa-juuto yite omaaho sen nando ngaaho vu yii-to?” ");
INSERT INTO mmo_vpl VALUES ("LK10_37","072_10_37","LUK","10","37","37","Tombe tanasin dangga nêêl nambe, “Omaaho sen ka pasiv in yi be hôôvu yii-to.” Tombe Yesu nêêl vu nambe, “Om gana, be gambiing naambêênju.” ");
INSERT INTO mmo_vpl VALUES ("LK10_38","072_10_38","LUK","10","38","38","Yesu-so mondala tombe lato lalukala bayêên ti, tonde vêêh ti haale nambe Maata hako Yesu lukala yite bayêên. ");
INSERT INTO mmo_vpl VALUES ("LK10_39","072_10_39","LUK","10","39","39","+ o 10:39 Jon 11:1; 12:2-3*Maata halivêêh ti haale nambe Malia, ond Maliaa-ju laam-ambe nando ngaaho vu Omaaho Bop vaha be yoo monango yite vakasin. ");
INSERT INTO mmo_vpl VALUES ("LK10_40","072_10_40","LUK","10","40","40","Lemu Maata ond nawiing kul bopaata lôôt in nayêêh vanôôn ayuuh ame de ka navu yite kul ngeeyaata lôôt, om laam vu Yesu be nêêl nambe, “Omaaho Bop, haliviiy-ame nahôôvu sa le, de soo timu monayêêh vanôôn, de gakam-ame navu le? Om onaanêêl vu be naam in dôôvu sa.” ");
INSERT INTO mmo_vpl VALUES ("LK10_41","072_10_41","LUK","10","41","41","Le Omaaho Bop nêêl laah nambe, “Maata dakaa-e, gakam navu kul ngeeyaata be onawiing naham in, ");
INSERT INTO mmo_vpl VALUES ("LK10_42","072_10_42","LUK","10","42","42","+ o 10:42 Mat 6:33*lemu va timu ma in hong, de Malia yoo nawiingin nambe gako va nivasaa-ju, ond me-lohvu nambe yaambu vêêl in yi le.” ");
INSERT INTO mmo_vpl VALUES ("LK11_1","072_11_1","LUK","11","1","1","+ o 11:1 Luk 5:33*Busin ti tombe Yesu monalohak vu taaku ti. Lohak lung la le mem yite maanggêêm ti nêêl vu nambe, “Omaaho Bop, otaahu hey hôôk lohakin naambe hey e aanohak naambe vaati, yik naambe sen bôôy Jon taahu yite maanggêêm-asôôto.” ");
INSERT INTO mmo_vpl VALUES ("LK11_2","072_11_2","LUK","11","2","2","Tombe nêêl vu sil nambe, “Ham anohak naambêênjo naambe, ‘O Aamangg, hil lambu vaambuung in ohaalem. Ganaam naatu heyate Omaaho Bop-ambe ganohvu taaku pin. ");
INSERT INTO mmo_vpl VALUES ("LK11_3","072_11_3","LUK","11","3","3","Gambu vanôôn vu hey nohvu busin pin, ");
INSERT INTO mmo_vpl VALUES ("LK11_4","072_11_4","LUK","11","4","4","de okawiiy heyate va nipaya na, in hey oo navu kawiiy hil-ate nyevahaan pin sen dawiing vu hey-ato nala. Game naanggiiy hey ana ngaaho vu palapin e.’” ");
INSERT INTO mmo_vpl VALUES ("LK11_5","072_11_5","LUK","11","5","5","Tonde Yesu nêêl vu sil nambe, “Ham-anjo ti na vu yite omaaho ti hôôk busin lavuun-ambe naanêêl naambe, ‘Hali, gambu vanôôn kamu yaal vu sa, ");
INSERT INTO mmo_vpl VALUES ("LK11_6","072_11_6","LUK","11","6","6","in sanêêngg vaatêêvak ti monalaam taaku diin-ambe valu-vu sa, le sanêêngg vanôôn sen saambu vuu-to ma.’ ");
INSERT INTO mmo_vpl VALUES ("LK11_7","072_11_7","LUK","11","7","7","Tombe omaaho sen neep hôôk bayêên alôô-to le naanêêl nom vu naambe, ‘Game ganjêêvu sa le, in vinavi vaayiiy lung la de hey o unoopasiv-aso naahop la, om same aalohvu nambe sa kandi be saambu va vu hong e.’ ");
INSERT INTO mmo_vpl VALUES ("LK11_8","072_11_8","LUK","11","8","8","+ o 11:8 Luk 18:5*Ke, om sa naanêêl vu ham naambe me-le ka bu naambe yite omaaho om kandi be naam bu vanôôn vu le, nganjo ka navu va sen naale mokataangg lôôt-anju, om le kandi be naam bu va sen nativak in-anju vu yi. ");
INSERT INTO mmo_vpl VALUES ("LK11_9","072_11_9","LUK","11","9","9","“Om sa naanêêl vu ham naambe ham kataangg va vu Anutu ond le bu vu ham, de ham salo ond ham e naatokak, tonde ham anyiis ak vinavi ond Anutu le gataahin in ham. ");
INSERT INTO mmo_vpl VALUES ("LK11_10","072_11_10","LUK","11","10","10","In hil pin sen davu kataangg Anutuu-to ond sil e gako, de hil sen davu salôô-to ond le daatovu, de hil sen dayiis ak vinavii-to ond Anutu le gataahin vinavi in sil. ");
INSERT INTO mmo_vpl VALUES ("LK11_11","072_11_11","LUK","11","11","11","De naambe ham ti noow kataangg paahuung vu mangganaan, ond mak mangganaan e bu nyêêy anipaya ti vu? Malis. ");
INSERT INTO mmo_vpl VALUES ("LK11_12","072_11_12","LUK","11","12","12","De naambe unoopasiv ti kataangg kokalêêh kaalus vu mangganaan, ond mak le bu gaalivang vu? Malis lôôt. ");
INSERT INTO mmo_vpl VALUES ("LK11_13","072_11_13","LUK","11","13","13","Ham hil anipaya voon-ate, lemu ham akam navu noom-aso be ham navu va nivasa vasa vu sil, om ham anjak ni bulôôt naambe hamate Mom sen nando baandonii-to le biing Vavi Vaambuung naam vu hil sen davu kataangg vu yii-to.” ");
INSERT INTO mmo_vpl VALUES ("LK11_14","072_11_14","LUK","11","14","14","Yesu hatiiy mamu nipaya ti ka ma hato la in omaaho ti lung la, tonde mem omaaho sen ka maa-to vakaas, tombe hil pin lavindis lôôt, ");
INSERT INTO mmo_vpl VALUES ("LK11_15","072_11_15","LUK","11","15","15","+ o 11:15 Mat 9:34; 10:25*lemu hil vaalu lanêêl nambe, “Mamu nipaya-te yêêv Belsebul vu niwêêk vu yi ondeey natiiy mamu dala in omaahonôôn.” ");
INSERT INTO mmo_vpl VALUES ("LK11_16","072_11_16","LUK","11","16","16","+ o 11:16 Mat 12:38*Tonde hil vaalu yoo lawiingin nambe sahi Yesu om sil tambe yi nambe biing taahu taahu jak va niwêêk baandoni ti be sil lanji. ");
INSERT INTO mmo_vpl VALUES ("LK11_17","072_11_17","LUK","11","17","17","Lemu lak sil alondpayo ni om nêêl vu sil nambe, “De naambe hil taaku bop ti yoo lanyiis sil-ambe baasuh sil na lu yuuh, ond sil-ame lalohvu nambe mando nivasa le. Tonde hil bayêên ti baasuh sil na lu yuuh ond sil-ame le mando nivasa le. ");
INSERT INTO mmo_vpl VALUES ("LK11_18","072_11_18","LUK","11","18","18","De naambe Saalang gatiiy yite kul vaha mamu nipaya-so, ond sil o Saalang-aso yoo laasuh sil la lu yuuh, tombe sil e mando javuh ti naambe tana? Malis. De ham nanêêl nambe sa natiiy mamu nipaya lak Belsebul-ate niwêêk, ");
INSERT INTO mmo_vpl VALUES ("LK11_19","072_11_19","LUK","11","19","19","om saanjingin ham e. Hamambe Belsebul navu niwêêk vu sa, tonde lati navu niwêêk vu hamate hil vaalu be datiiy mamu nipaya dala in omaahonôôn? Yik Anutu timu, om hamate hil-anju le daanêêl vu ham naambe ham oo nakaas paya. ");
INSERT INTO mmo_vpl VALUES ("LK11_20","072_11_20","LUK","11","20","20","+ o 11:20 Eks 8:19*Om sen Anutu navu niwêêk vu sa be sa natiiy mamu nipaya dala in omaahonôôn, om ham anjak ni naambe Anutu laam nanggin yite hil hôôk ham lavuun gêên-anjo. ");
INSERT INTO mmo_vpl VALUES ("LK11_21","072_11_21","LUK","11","21","21","“De naambe omaaho niwêêk ti nama nôôh yite va ngaamong-ate be yoo ganggin yite bayêên niwêêk lôôt, ond yite va pin oo le mando nivasa. ");
INSERT INTO mmo_vpl VALUES ("LK11_22","072_11_22","LUK","11","22","22","+ o 11:22 Kol 2:15*Le sim naambe omaaho ango niwêêk lôôt balup-ambe nyiis ngaamong vu be savok omaaho angôô-ju, ond le bu vêêl yinêên va ngaamong-ate sen omaahôô-ju yoo wii-having nambe le dôôvu yii-to, tonde gatiiy yinêên va pin na vu hil vaalu. ");
INSERT INTO mmo_vpl VALUES ("LK11_23","072_11_23","LUK","11","23","23","+ o 11:23 Luk 9:50*“Omaaho ti nambe same sate omaaho yi le, ond nayiis ngaamong vu sa. Yik omaaho ti me-nasupin omaahonôôn having sa le, ond natiiy sil-ambe davuuh taale.” ");
INSERT INTO mmo_vpl VALUES ("LK11_24","072_11_24","LUK","11","24","24","“Mamu nipaya nambe gato na in omaaho ti, ond yoo monana taaku lumbalaamb in nambe naatovu taaku vuuti be sawaah yi dôôk, le me-naatovu le, ond le naanêêl naambe, ‘Mam sa naah sa baangg sen sa nando hôôk bôôy-ambe sa laam-ato.’ ");
INSERT INTO mmo_vpl VALUES ("LK11_25","072_11_25","LUK","11","25","25","Tombe laah valup e yi de sil lasêêh bayêên-anju be latongin lung la, ");
INSERT INTO mmo_vpl VALUES ("LK11_26","072_11_26","LUK","11","26","26","+ o 11:26 Jon 5:14*tombe la hako mamu namaavaalu be vindak yuuh sen sil anipaya savok yii-to, le mem lalom-ambe lalukala dando hôôk bayêên-anjuuto. Tombe bôôy ond omaaho sen mamu nahôôvuu-ju nando paya, lemu gêên le mando nipaya valok-ate lôôt.” ");
INSERT INTO mmo_vpl VALUES ("LK11_27","072_11_27","LUK","11","27","27","+ o 11:27 Luk 1:28,42,48*Yesu nêêl vakasin-anjo de hil ngeeyaata lôôt daale, tombe vêêh ti teey la vu Yesu nambe, “Vêêh ti sen hako hong bôôy-ambe vu sum vu hong-ato ond yoo ka vasa.” ");
INSERT INTO mmo_vpl VALUES ("LK11_28","072_11_28","LUK","11","28","28","+ o 11:28 Luk 8:15,21*Le Yesu nêêl nambe, “Ôôye, hil sen dango Anutu-te vakasin-ambe davu taamuyin-ato ond mem sil akand vasa.” ");
INSERT INTO mmo_vpl VALUES ("LK11_29","072_11_29","LUK","11","29","29","+ o 11:29 Mat 16:4*Hil ngeeyaata lôôt daahen dasupin dalaam tonde Yesu nêêl vu sil nambe, “Ham hil anipaya sen gêên-anjo. Ham awiingin nambe ham angge taahu taahu ti, lemu same le aambiing taahu taahu ti vu ham e, yik ham akam bu Yona-te taahu taahu mu. ");
INSERT INTO mmo_vpl VALUES ("LK11_30","072_11_30","LUK","11","30","30","In bôôy hil Ninive layi Anutu wiing taahu taahu lak Yona, tonde yik nambêênja Anutu le biing taahu taahu vu ham hil sen gêên-anjo jak Omaahonôôn Noow. ");
INSERT INTO mmo_vpl VALUES ("LK11_31","072_11_31","LUK","11","31","31","+ o 11:31 1King 10:1-10*Om vu busin taamusin sen Anutu gangoyin omaahonôôn-ate vakasin-ato ond vêêh alulemak Seba le kandi baale be naanêêl vakasin jak ham sen gêên-anjo naambe hamate nipaya neep. In vêêh alulemak-anju vu taaku nanyendangga vaaluu-ju laam in nambe gango Solomon-ate vakasin nivasa osin ka, lemu sa sen gêên sa nandôô-jo ond sa savok Solomon la, le ma de ham-ame nangoyin sa lavangg e. ");
INSERT INTO mmo_vpl VALUES ("LK11_32","072_11_32","LUK","11","32","32","+ o 11:32 Jona 3:5-10*De vu busin taamusin sen Anutu gangoyin omaahonôôn-ate vakasin-ato, ond moow Ninive le baale be daanêêl vakasin jak ham sen gêên-anjo naambe hamate nipaya neep, in hil Ninive lango vakasin sen Yona nêêl-ato be lahilin londpayo, lemu sa sen gêên sa naanêêl vakasin vu ham-anjo ond sa savok Yona la.” ");
INSERT INTO mmo_vpl VALUES ("LK11_33","072_11_33","LUK","11","33","33","+ o 11:33 Mak 4:21; Luk 8:16*“Hil davu taalungg hôôk lam ond me-datung lukala pêêt ahendangga le, de me-datung lukala dêêngg alo le, malis, datung lakala pêêt baandoni in nambe hil pin sen dalukalaam bayêên alôô-to lanji melangaah. ");
INSERT INTO mmo_vpl VALUES ("LK11_34","072_11_34","LUK","11","34","34","De gamem kaalus ond ganim naavi-te kin tumin, om naambe gamem kaalus anivasa ond le naatum nohvu ganim naavi pin, le naambe gamem kaalus anipaya ond ganim naavi pin e mekanu. ");
INSERT INTO mmo_vpl VALUES ("LK11_35","072_11_35","LUK","11","35","35","Om goo ganggin kin tumin sen nando hôôk hong-anja nivasa de mekanu me-dôôk e. ");
INSERT INTO mmo_vpl VALUES ("LK11_36","072_11_36","LUK","11","36","36","De naambe kin naatum nohvu ganim naavi pin-ande vuuti me-mekanu le, ond ganim naavi doos naatum naambe kin tumin natum ak hong-ato.” ");
INSERT INTO mmo_vpl VALUES ("LK11_37","072_11_37","LUK","11","37","37","+ o 11:37 Luk 7:36; 14:1*Yesu nêêl vakasin-anju lung la tonde Palisai ti kataangg Yesu nambe na ja vanôôn gaving yi, om Yesu la valup-ambe huli-la nando bayêên alo. ");
INSERT INTO mmo_vpl VALUES ("LK11_38","072_11_38","LUK","11","38","38","+ o 11:38 Mat 15:2*Tombe Palisai tii-juuto yi de Yesu naya vanôôn danjeen, de me-lipis nama munggin e, tombe ka yu-yuuh lôôt. ");
INSERT INTO mmo_vpl VALUES ("LK11_39","072_11_39","LUK","11","39","39","Le Omaaho Bop nêêl vu nambe, “Ham Palisai ham nalipis kap osin pale dami mu, de ham alompayo ond va hôôndak osin va nipaya paya pup hôôk. ");
INSERT INTO mmo_vpl VALUES ("LK11_40","072_11_40","LUK","11","40","40","Ham Palisai ham akam ma. Anutu sen samu yaningg naavii-to ond yik samu yalonggpayo having. ");
INSERT INTO mmo_vpl VALUES ("LK11_41","072_11_41","LUK","11","41","41","De va sen nando hôôk pale yuuh ame lopayôô-to ond ham ambu vu hil sen dativak in va yuuh amêê-to, ond mem ham e angge va ninaavi osin lopayo nambe nivasa lak lung la. ");
INSERT INTO mmo_vpl VALUES ("LK11_42","072_11_42","LUK","11","42","42","+ o 11:42 Lev 27:30*Lemu ham Palisai-so, nimeen e naatovu ham keen. Tanasin nambe sen vanôôn pasi-pasiv, jaamenjang osin gwelambum ayuuh ame pin, ond ham natung having vanôôn lak lu nomaayuuh, tombe ham navu lu ti natu salivangin vu Anutu, ond Mose-te tanasin tii-jo ham napuvu niwêêk, lemu tanasin vaalu nambe sen yaambiing va na nivalok amu, de yahengg gaving Anutu, ond yik ham oo navuuh nala. Om ham samu tanasin-anjo, de tanasin vaalu nambe sen ham navu va lu ti natu salivangin vu Anutu ond ham oo mosamu gaving-ande ham-ame gavuuh na le. ");
INSERT INTO mmo_vpl VALUES ("LK11_43","072_11_43","LUK","11","43","43","“Lemu ham Palisai-so, nimeen e naatovu ham, in ham oo nawiingin nambe mando hil pin amend hôôk dumb alo, osin hil gako ham jak vu talind, ");
INSERT INTO mmo_vpl VALUES ("LK11_44","072_11_44","LUK","11","44","44","om nimeen e naatovu ham, in ham alohvu bandumb sen neep vunin hôôk ngaanggis kambini, de omaahonôôn doosin-ambe lato layêês baandoni be lala.” ");
INSERT INTO mmo_vpl VALUES ("LK11_45","072_11_45","LUK","11","45","45","Tombe tanasin dangga ti nêêl laah vu Yesu nambe, “Kaputung, ganêêl nambêênja ond ganêêl vakasin anipaya lak hey having.” ");
INSERT INTO mmo_vpl VALUES ("LK11_46","072_11_46","LUK","11","46","46","Le Yesu nêêl nambe, “De ham tanasin dangga-so, nimeen e naatovu ham gaving, in ham nanjingin tanasin vaalu ngeeyaata lak hil-ambe dalôôhin lôôt, lemu ham-ame nalôôh va sen dalôôhin-ato daka la vêêl in nambe ham andôôvu sil e. ");
INSERT INTO mmo_vpl VALUES ("LK11_47","072_11_47","LUK","11","47","47","Om nimeen e naatovu ham, in himbop-aso bôôy layiis hil sen danêêl Anutu-te vakasin langaah-ato be layimb, tombe ham oo nahaav bayêên vunakin-ate nalakando silate bandumb baandoni. ");
INSERT INTO mmo_vpl VALUES ("LK11_48","072_11_48","LUK","11","48","48","Om nambêênja ham oo nanêêl hamate himbop-asote dangga langaah nambe sil layiis hil sen danêêl Anutu-te vakasin langaah-ambe layimb-ato, tombe ham alompayo nivasa in va sen hamate himbop-aso lawiing-anju. In sil layiis Anutu-te hil-ambe layimb, tonde sim ham oo monavunak silate bandumb lak va mengali. ");
INSERT INTO mmo_vpl VALUES ("LK11_49","072_11_49","LUK","11","49","49","Ondeey Anutu sen lukook bopaataa-to nêêl lung la nambe, ‘Sale aambiing hil sen daanêêl sate vakasin langaah-ato osin sinaale-so lana vu sil, tombe hil e lambiing nindanjeen vu sil vaalu, tonde lanyiis vaalu be lanjimb.’ ");
INSERT INTO mmo_vpl VALUES ("LK11_50","072_11_50","LUK","11","50","50","Om nambêênja hil pin sen vu gêên-anjo, ond sil e gako nipaya nyevahaan dukanaah sen layiis hil sen danêêl Anutu-te vakasin langaah-ato, vu bôôy sen hatung va pin nyendoos-ambe tok laam gêên-anjôôto. ");
INSERT INTO mmo_vpl VALUES ("LK11_51","072_11_51","LUK","11","51","51","+ o 11:51 Jen 4:8; 2Kro 24:20-21*Ond yik vu bôôy sen Abel yimb-ambe tok valup Sakaalia sen hamate himbop-aso layiis-ambe yimb neep dumb alo vaambuung-ande alata lavuun-ato. Keen, sa naanêêl vu ham naambe silate nipaya pin-anju ond nipaya nyevahaan e naatovu hil sen dando gêên-anjo. ");
INSERT INTO mmo_vpl VALUES ("LK11_52","072_11_52","LUK","11","52","52","“De ham tanasin dangga-so, nimeen e naatovu ham, in ham nahilin mop sen hil lanjak Anutu-te tanasin dangga nii-to, de ham-ame yoo alak tanasin dangga ni le, le ham nahilin hil sen dawiingin nambe lanjak nii-to having.” ");
INSERT INTO mmo_vpl VALUES ("LK11_53","072_11_53","LUK","11","53","53","Yesu nêêl lung la tonde havuuh bayêên-anju de la in nambe na, tombe tanasin dangga-so osin hil Palisai-so ond sil oo laanjiihin Yesu niwêêk lôôt in nambe naanêêl vakasin vaha vaha, ");
INSERT INTO mmo_vpl VALUES ("LK11_54","072_11_54","LUK","11","54","54","+ o 11:54 Luk 20:20*de sil oo mondanggin in nambe naanêêl vakasin ti na paya ond lambiing vakasin vu yi. ");
INSERT INTO mmo_vpl VALUES ("LK12_1","072_12_1","LUK","12","1","1","+ o 12:1 Mat 16:6*Hil ngeeyaata lasupin lalaam-ambe sil lapup hôôk taaku, tonde dando lak sil baando baando. Tombe Yesu vu kôôvu yite maanggêêm-aso munggin nambe, “Ham oo ganggin ham nivasa in va sen Palisai-so davun sil alondpayo hôôk vakasin anivasa yuuh amêê-to, ond vaa-jo la nalohvu hil ngeeyaata nambe sen yis la nanggwang balet-ambe nalinj-ato. ");
INSERT INTO mmo_vpl VALUES ("LK12_2","072_12_2","LUK","12","2","2","+ o 12:2 Mat 10:26; Luk 8:17*Vakasin pin sen neep vunin-ato ond le naatok naam langaah, yik vakasin pin sen hil akand navu be neep hôôk londpayôô-to ond taamusin hil e lanjak ni pin. ");
INSERT INTO mmo_vpl VALUES ("LK12_3","072_12_3","LUK","12","3","3","Om vakasin pin sen ham oo nando be ham nakaas ak-ato ond hil e gango langaah. Yik vakasin sen ham oo nanêêl hôôk bayêên alôô-to ond hil e lana baale talind-ambe daanêêl na vu omaahonôôn pin.” ");
INSERT INTO mmo_vpl VALUES ("LK12_4","072_12_4","LUK","12","4","4","“Halingg-aso, sa naanêêl vu ham naambe ham-ame anjêênin omaahonôôn in nambe le lanyiis ham anim naavi jimb, in sil-ame lalohvu nambe lambiing vati gaving e. ");
INSERT INTO mmo_vpl VALUES ("LK12_5","072_12_5","LUK","12","5","5","Nganjo sale naanêêl omaaho sen ham oo anjêênin yii-to vu ham e, yik ham anjêênin Anutu, in yite niwêêk lohvu nambe nyiis ham-ambe gaate ham dukana taaku nipaya gaving-ato. Keen, sa naanêêl vu ham naambe ham oo anjêênin Anutuu-ju. ");
INSERT INTO mmo_vpl VALUES ("LK12_6","072_12_6","LUK","12","6","6","“De ham alak ni nambe hil daanggo manak taapêêv namaavaalu lak mone noow yuuh, le Anutu me-ka lingin manak pasiv pasiv-anjuuto ti le. ");
INSERT INTO mmo_vpl VALUES ("LK12_7","072_12_7","LUK","12","7","7","+ o 12:7 Luk 12:24; 21:18; Sin 27:34*De ham ond sevin ham alumvalus pin lôôt lung la, om ham-ame anjêênin e, in ham atu Anutu-te va-so savok manak pasiv pasiv-anju pin.” ");
INSERT INTO mmo_vpl VALUES ("LK12_8","072_12_8","LUK","12","8","8","“De sa naanêêl vu ham naambe omaaho ti nambe naanêêl sa haalengg langaah vu hil, ond Omaahonôôn Noow e naanêêl omaaho tii-to haale langaah vu Anutu-te angela-so. ");
INSERT INTO mmo_vpl VALUES ("LK12_9","072_12_9","LUK","12","9","9","+ o 12:9 Luk 9:26*Le naambe omaaho ti jak alu in sa vu hil, ond sale anjak alungg in yi vu Anutu-te angela-so. ");
INSERT INTO mmo_vpl VALUES ("LK12_10","072_12_10","LUK","12","10","10","+ o 12:10 Mak 3:28-29*De naambe omaaho ti naanêêl vakasin anipaya jak Omaahonôôn Noow, ond Anutu le kawiiy yite nipaya na. Le naambe naanêêl Vavi Vaambuung pale, ond Anutu me-le kawiiy yite nipayaa-ju na le, malis. ");
INSERT INTO mmo_vpl VALUES ("LK12_11","072_12_11","LUK","12","11","11","+ o 12:11 Mak 13:11; Luk 21:12-15*“De hil gako ham ana vu yêêv dumb-aso, de vu yêêv gaaman osin yêêv bop-aso vaalu in ham ambiing vakasin, ond ham-ame naham jak-ambe ham naanêêl naambe, ‘Hey e aambiing vakasin naambe tana? Hey e naanêêl vaati?’ ");
INSERT INTO mmo_vpl VALUES ("LK12_12","072_12_12","LUK","12","12","12","Yik Vavi Vaambuung yoo le taato va sen ham naanêêl-ato dôôk busin tii-ju vu ham bulôôt.” ");
INSERT INTO mmo_vpl VALUES ("LK12_13","072_12_13","LUK","12","13","13","Tombe hil alu bopaataa-ju ti nêêl vu Yesu nambe, “Kaputung, onaanêêl vu sa halingg naambe baasuh va yuuh ame sen aamangg-atêêto be bu vaalu vu sa.” ");
INSERT INTO mmo_vpl VALUES ("LK12_14","072_12_14","LUK","12","14","14","Le Yesu nêêl vu nambe, “In vaati? Lati holin sa in nambe sa gango hamate vakasin-ambe sa gatiiy hamate va yuuh ame? Malis.” ");
INSERT INTO mmo_vpl VALUES ("LK12_15","072_12_15","LUK","12","15","15","+ o 12:15 1Ti 6:9-10*Tonde Yesu nêêl vu sil nambe, “Ham ganggin ham nivasa, de ham-ame ambiing menôôn in va vaha vaha le, in omaaho sen yite kupak ngeeyaata nando ond kupak-anju me-navu metumin vu yi le.” ");
INSERT INTO mmo_vpl VALUES ("LK12_16","072_12_16","LUK","12","16","16","Tonde Yesu nêêl vakasin pakwesin ti vu sil nambe, “Omaaho kupak dangga ti-te vanôôn ngeeyaata nôôn ak hôôk kulaanôôn, ");
INSERT INTO mmo_vpl VALUES ("LK12_17","072_12_17","LUK","12","17","17","tombe yoo ka vu hôôk lopayo nambe, ‘Peey e saambiing naambe vaati? In sanêêngg bayêên sen sa naasupin sate vanôôn pin nôôn dôôk-ato me-lohvu le.’ ");
INSERT INTO mmo_vpl VALUES ("LK12_18","072_12_18","LUK","12","18","18","Om nêêl nambe, ‘Saambiing naambêênjo le. Sa kawiiy sate bayêên vanôôn-ate pin-ambe sa daav bopaata, tombe mem sa gatung sate vanôôn nôôn pin osin sate kupak ayuuh ame dôôk bayêên-anju. ");
INSERT INTO mmo_vpl VALUES ("LK12_19","072_12_19","LUK","12","19","19","Tonde mem soo le naanêêl vu sa naambe, “Ke, sate va nivasa ngeeyaata nando nohvu ta ngeeyaata lôôt, om peey-anjo sa sawaah-ambe soo mando monangga be monaanum osin sa longgpayo nivasa.” ’ ");
INSERT INTO mmo_vpl VALUES ("LK12_20","072_12_20","LUK","12","20","20","Lemu Anutu nêêl vu omaaho kupak danggaa-ju nambe, ‘Galumkook ma, peey busin-anjo onavu ganggimb, de va pin sen osamu lung la be nandôô-jaato ond lati le gako?” ’ ");
INSERT INTO mmo_vpl VALUES ("LK12_21","072_12_21","LUK","12","21","21","+ o 12:21 Mat 6:19-20*Tonde Yesu nêêl nambe, “Om yik nambêênja vu hil sen sil oo mondahôôlis silate va nivasa vasa ngeeyaata vu voon-anjôôto, le Anutu nayi sil osin silate va nivasaa-ju nambe me-nôôn keen e.” ");
INSERT INTO mmo_vpl VALUES ("LK12_22","072_12_22","LUK","12","22","22","Yesu nêêl vu yite maanggêêm-aso nambe, “Ham-ame naham jak in vanôôn sen ham angga osin tôômb sen ham anjop in nambe dôôvu ham anim naavii-to le, ");
INSERT INTO mmo_vpl VALUES ("LK12_23","072_12_23","LUK","12","23","23","in yiiy nando metumin ond savok vanôôn, de yaningg naavi ond savok tôômb. ");
INSERT INTO mmo_vpl VALUES ("LK12_24","072_12_24","LUK","12","24","24","+ o 12:24 Saam 147:9; Luk 12:7*“Ham akam bu manak e, in manak-ame daalôôh vanôôn e, de me-dasupin vanôôn nôôn e, de silate pêêt vanôôn-ate ma, lemu Anutu yoo navaat sil. De ham, ond ham haalem bop savok manak-anju, om Anutu le baat ham. ");
INSERT INTO mmo_vpl VALUES ("LK12_25","072_12_25","LUK","12","25","25","Ham ti tana lohvu nambe ka monambu be gakoseey yite busin sen mando voon-anjôôto balu-na daka gaving? Malis. ");
INSERT INTO mmo_vpl VALUES ("LK12_26","072_12_26","LUK","12","26","26","Om sen ham-ame alohvu nambe ham ambiing va daka naambêênja le, ond nambe vaati sen ham naham nalak in tôômb ayuuh amêê-to? ");
INSERT INTO mmo_vpl VALUES ("LK12_27","072_12_27","LUK","12","27","27","“De ham akam bu ngaaola nalup hôôk paahup alo, ond me-dawiing kul bop osin me-davu samu silate tôômb e, lemu sa naanêêl vu ham naambe bôôy Solomon vunak yi lak yite vunakin amengali-ngali pin, le yite vunakin-ame nivasa nambe sen ngaaolaa-ju le. ");
INSERT INTO mmo_vpl VALUES ("LK12_28","072_12_28","LUK","12","28","28","Tonde paahup sen gêên nando de jeey e hil basii-to, ond Anutu yoo navunak, om yoo le ganggin ham savok paahup-anju na, le ham-ame nawii-having niwêêk e. ");
INSERT INTO mmo_vpl VALUES ("LK12_29","072_12_29","LUK","12","29","29","Om ham-ame ambiing mem in va sen ham angga osin ham naanum-ato le, de ham-ame naham jak in e. ");
INSERT INTO mmo_vpl VALUES ("LK12_30","072_12_30","LUK","12","30","30","Va pin-anja hil vaalu sen sil doosin Anutuu-to ond sil oo mondawiing mend in, lemu hamate Mom Anutu yoo lak ham anim lung la nambe ham nativak in va nambêênja. ");
INSERT INTO mmo_vpl VALUES ("LK12_31","072_12_31","LUK","12","31","31","Om yik ham akam oo bu sen Anutu nanggin ham-ato naamunggin, ond mem va pin-anja Anutu le bu vu ham.” ");
INSERT INTO mmo_vpl VALUES ("LK12_32","072_12_32","LUK","12","32","32","+ o 12:32 Luk 22:29; Taato 1:6*“Om ham hil daka yuuh-anjo, ham-ame anjêênin e, in hamate Mom Anutu ka vasa lung la nambe ham e andukana mando gaving yii-to. ");
INSERT INTO mmo_vpl VALUES ("LK12_33","072_12_33","LUK","12","33","33","+ o 12:33 Luk 18:22*Om ham ambu hamate va pin-ambe hil baanggo, tombe ham ambu mone vu hil sen dativak in va yuuh amêê-to in dôôvu sil, tonde mem ham gako kalong sen me-le biing payaa-to osin nôôn anivasa vasa vu baandoni, in me-le na menama le. In baandonii-ju ond vivak-ame le biliyak va le, de hil hôôndak-ame le lanaam ngaaho in nambe langgôôndak e. ");
INSERT INTO mmo_vpl VALUES ("LK12_34","072_12_34","LUK","12","34","34","In taaku sen gate nôôn anivasa vasa nandôô-to ond galompayo le na vu taakuu-ju.” ");
INSERT INTO mmo_vpl VALUES ("LK12_35","072_12_35","LUK","12","35","35","+ o 12:35 Eks 12:11; Mat 25:1-13; 1Pi 1:13*“Ham gavêêh let, tonde ham taalungg kin ak, ");
INSERT INTO mmo_vpl VALUES ("LK12_36","072_12_36","LUK","12","36","36","+ o 12:36 Mak 13:33-36*de ham oo mando mem naatum naambe hil sen mondanggin silate yêêv-ato in la vanôôn bop sen vêêh ayuuh moow dalôôh namand-ato, om mondanggin in nambe nom balu-baale vinavi be naateey ond sil gataahin pavis. ");
INSERT INTO mmo_vpl VALUES ("LK12_37","072_12_37","LUK","12","37","37","+ o 12:37 Jon 13:4*Om yêêv balup-ambe ji naambe yite hil kul-aso dando mend natum, ond hil kul-asôônju sil e kand vasa. Om sa naanêêl keen vu ham naambe yêêv-anjo yoo le gavêêh tôômb ngaaho nohvu hil kul vaha-so davêêh-ato, tonde naanêêl-ambe yite hil kul-aso gato mando, tonde yoo le monambaat sil. ");
INSERT INTO mmo_vpl VALUES ("LK12_38","072_12_38","LUK","12","38","38","Om yik naambe balup hôôk busin lavuun me balup hôôk heendiisin-ambe ji naambe yite hil kul-aso dando mend natum, ond hil kul-asôônju yoo le kand vasa lôôt. ");
INSERT INTO mmo_vpl VALUES ("LK12_39","072_12_39","LUK","12","39","39","+ o 12:39 Mat 24:43-44; 1Tes 5:2*“Ham oo alak ni nambe bayêên mangganaan ti gango banye naambe omaaho hôôndak navu balup hôôk taaku me tii-ju, ond le ganggin nivasa in omaaho hôôndak-ame dukana yite bayêên alo le. ");
INSERT INTO mmo_vpl VALUES ("LK12_40","072_12_40","LUK","12","40","40","Om ham oo samu ham naambêênja, in busin sen ham-ame le kam bu naambe Omaahonôôn Noow navu naam-ato ond le naam pavis.” ");
INSERT INTO mmo_vpl VALUES ("LK12_41","072_12_41","LUK","12","41","41","Pita lingin vu Yesu nambe, “Omaaho Bop, ganêêl vakasin pakwesin-anjo vu hey-anjo yoow, me ganêêl vu hil pin-anju having a?” ");
INSERT INTO mmo_vpl VALUES ("LK12_42","072_12_42","LUK","12","42","42","Tombe Omaaho Bop nêêl nambe, “Kul vaha nivasa osin ka bop ond nawiing kul nambe tana? Yik yite yêêv holin yi be nanggin kul vaha-so vaalu in nambe bu vanôôn vu sil jak busin pin, ");
INSERT INTO mmo_vpl VALUES ("LK12_43","072_12_43","LUK","12","43","43","tonde yite yêêv monana ti be nom gato vu be ji naambe nawiing yite kul lohvu, ond kul vahaa-jo le ka vasa. ");
INSERT INTO mmo_vpl VALUES ("LK12_44","072_12_44","LUK","12","44","44","+ o 12:44 Mat 25:21,23*Sa naanêêl keen vu ham naambe yite yêêv e naanêêl-ambe naatu yêêv in ganggin yite va pin. ");
INSERT INTO mmo_vpl VALUES ("LK12_45","072_12_45","LUK","12","45","45","Le naambe kul vaha yoo ka bu dôôk lopayo naambe yite yêêv oo naahen lôôt, tombe gaveek kul vaha-so moow ayuuh vêêh, de ja osin naanum-ambe mokaatuuh hôôk, ");
INSERT INTO mmo_vpl VALUES ("LK12_46","072_12_46","LUK","12","46","46","tombe busin ti kul vahaa-ju me-ganggin yite yêêv e, le doosin, ond yite yêêv e nom gato, tombe le nyiis kul vahaa-ju be gako nipaya valok-ate, be gaate na taaku nipaya gaving kalêêsin ambu-so. ");
INSERT INTO mmo_vpl VALUES ("LK12_47","072_12_47","LUK","12","47","47","+ o 12:47 Jem 4:17*“Va sen yêêv aka vu nambe yite kul vaha biing-ato, ond nambe kul vaha lak ni le me-samu le, de me-biing va nohvu yêêv aka le, ond yite yêêv e gaveek yi lôôt. ");
INSERT INTO mmo_vpl VALUES ("LK12_48","072_12_48","LUK","12","48","48","De naambe kul vaha doosin va sen yite yêêv aka vuu-to, de biing vati paya nohvu yite yêêv gaveek, ond yêêv e gaveek pasivdaka mu. Hil sen Anutu vu kul ngeeyaata vu sil-ato, ond le naanêêl naambe sil ganggin nivasa, de hil lavu kul ngeeyaata vu omaaho ti in nambe ganggin, ond yik sil e daanêêl naambe yoo ganggin nivasa lôôt.” ");
INSERT INTO mmo_vpl VALUES ("LK12_49","072_12_49","LUK","12","49","49","Tonde Yesu nêêl nambe, “Sa laam in nambe gaate kin nanjip voon, tombe soo aawiingin lôôt nambe kin-anjo yoo naatum pavis. ");
INSERT INTO mmo_vpl VALUES ("LK12_50","072_12_50","LUK","12","50","50","+ o 12:50 Mak 10:38-39; Mat 26:38; Jon 12:27*De nivaane sen navu naatokak saa-to naahen neep, tombe sa longgpayo nimeen lôôt, om saawiingin nambe jung na le mem. ");
INSERT INTO mmo_vpl VALUES ("LK12_51","072_12_51","LUK","12","51","51","Hamambe sa laam in aambu mamaal vu voon a? Malis lôôt, sa naanêêl vu ham e, sa laam atombe hil daasuh sil in sa. ");
INSERT INTO mmo_vpl VALUES ("LK12_52","072_12_52","LUK","12","52","52","Om gêên-anjo de vu taamusin gaving, ond hil namaavaalu dando lak bayêên ti, ond sil e baasuh sil na yuuh, tombe yaal alondpayo le na ango, tonde yuuh alondpayo le na ango. ");
INSERT INTO mmo_vpl VALUES ("LK12_53","072_12_53","LUK","12","53","53","+ o 12:53 Mai 7:6*Tonde sil e baasuh sil-ambe mangganaan alopayo na ango, de noow alopayo na ango, tonde tangganaan alopayo na ango, de nowaavêêh alopayo na ango, tonde yenaavêêh moos alopayo na ango, de yenaavêêh bôôy alopayo na ango.” ");
INSERT INTO mmo_vpl VALUES ("LK12_54","072_12_54","LUK","12","54","54","Tonde sim Yesu nêêl vu hil alu bopaataa-ju nambe, “Ham nahe nambe bayiimb ahengook nando hoong-anju, tombe ham nanêêl nambe luk navu gatolak, tombe yik luk natolak keen. ");
INSERT INTO mmo_vpl VALUES ("LK12_55","072_12_55","LUK","12","55","55","Tonde ham nahe nambe vavi valup ond ham nanêêl nambe taaku navu galevang, tombe yik nalevang keen lohvuu-ja. ");
INSERT INTO mmo_vpl VALUES ("LK12_56","072_12_56","LUK","12","56","56","Ham oo natee ham ak. Ham navu sahi lak va voon osin bayiimb ayuuh ame baandoni be lohvu, lemu va sen gêên Anutu nawiing hôôk ham amem-anjo, le nambe tana sen ham-ame alohvu nambe anjak ni le?” ");
INSERT INTO mmo_vpl VALUES ("LK12_57","072_12_57","LUK","12","57","57","“Nambe vaati sen ham-ame navu sahi va sen nivalok-ato be nawiing e? ");
INSERT INTO mmo_vpl VALUES ("LK12_58","072_12_58","LUK","12","58","58","De omaaho ti gako hong-ambe mana in gambiing vakasin, ond osamu vakasin vu omaahôô-ju pavis vu mopaatôôv. Le naambe nama, ond le daandiiy hong na vu yêêv sen nango vakasin-ato, be yêêv-anju bu hong dukana ahevaavu nama, tombe ahevaavu gatung hong dukana kalaambus. ");
INSERT INTO mmo_vpl VALUES ("LK12_59","072_12_59","LUK","12","59","59","Om sa naanêêl keen vu hong naambe game le ganom pavis e, de omandôô-ju be gambu dôôk omaahôô-jute nyevahaan pin lôôt e mem.” ");
INSERT INTO mmo_vpl VALUES ("LK13_1","072_13_1","LUK","13","1","1","Tonde sim hôôk busin-anju hil vaalu dando, ond lanêêl vu Yesu in vaheey vu Galili, ond lala layiis silate kao yuuh ame in nambe sil gatung naatu salivangin vu Anutu, le ma de daahen dayiis atombe yêêv bop Pilata yiis sil-ambe layimb, tombe sil anind hees kaasêêh having kao nihees. ");
INSERT INTO mmo_vpl VALUES ("LK13_2","072_13_2","LUK","13","2","2","+ o 13:2 Jon 9:2*Tombe Yesu nêêl nambe, “De hil Galili heey-anju ond hamambe sil hil anipaya lôôt savok hil Galili vaalu pin ondeey latovu nimeen nambêênju? ");
INSERT INTO mmo_vpl VALUES ("LK13_3","072_13_3","LUK","13","3","3","+ o 13:3 Saam 7:12*Malis lôôt. Sa naanêêl vu ham naambe ham-ame anggilin ham alompayo le, ond ham pin e ana mem nama naambe sil-anju. ");
INSERT INTO mmo_vpl VALUES ("LK13_4","072_13_4","LUK","13","4","4","Tonde hil Yelusalem nomaayuuh-ambe laam namaavaalu be vindak yaal sen bayêên vaha dinaandiin vu Siloam kalêêh-ambe lanjingin sil-ambe layimb-ato, ond hamambe silate nipaya savok hil vaalu sen dando Yelusalem-ato? ");
INSERT INTO mmo_vpl VALUES ("LK13_5","072_13_5","LUK","13","5","5","Malis lôôt. Sa naanêêl vu ham naambe ham-ame anggilin ham vasa le, ond ham pin e ana mem nama naambêênju.” ");
INSERT INTO mmo_vpl VALUES ("LK13_6","072_13_6","LUK","13","6","6","+ o 13:6 Mat 21:19*Tonde sim Yesu nêêl vakasin pakwesin ti nambe, “Omaaho ti-te moli naale hôôk kulaanôôn, tombe la in nambe jul nôôn, le ma de nôôn ma. ");
INSERT INTO mmo_vpl VALUES ("LK13_7","072_13_7","LUK","13","7","7","+ o 13:7 Luk 3:9*Tombe nêêl vu omaaho sen nanggin kul-ato nambe, ‘Angge, lohvu ta yaal sa laam in nambe aanjul moli nôôn le ma, om jip-ande gambuv na in nawiiyak ngaanggis danji malis amu.’ ");
INSERT INTO mmo_vpl VALUES ("LK13_8","072_13_8","LUK","13","8","8","+ o 13:8 2Pi 3:9,15*Lemu omaaho sen nanggin kul-anjuuto nêêl laah vu nambe, ‘Om himbop, yoo baale ta tii-jo gaving de saambiing kul dôôk dangga vêêl e, ");
INSERT INTO mmo_vpl VALUES ("LK13_9","072_13_9","LUK","13","9","9","tonde waangge ta ngôô-ju naambe nyiis nôôn a? Le naambe nama ond mem onaanêêl-ambe saambuv na.’” ");
INSERT INTO mmo_vpl VALUES ("LK13_10","072_13_10","LUK","13","10","10","Yesu monanêêl tanasin vu hil hôôk busin sawaasin vu dumb alo ti, ");
INSERT INTO mmo_vpl VALUES ("LK13_11","072_13_11","LUK","13","11","11","tonde sim vêêh ti ond mamu nipaya ti wiing-ambe nilak lohvu ta nomaayuuh-ambe laam namaavaalu be vindak yaal, tombe vêêh-anju dami katu om me-lohvu nambe baale nivalok e. ");
INSERT INTO mmo_vpl VALUES ("LK13_12","072_13_12","LUK","13","12","12","Yesu yi vêêh-anju tombe teey laam-ambe nêêl vu nambe, “Vêêh daka-na, gate nilakin la vêêl in hong.” ");
INSERT INTO mmo_vpl VALUES ("LK13_13","072_13_13","LUK","13","13","13","Tonde Yesu hambe nama lak vêêh-anju tombe yik dami nivalok ak pavi-vasa, tombe vêêh-anju hako Anutu haale lak. ");
INSERT INTO mmo_vpl VALUES ("LK13_14","072_13_14","LUK","13","14","14","+ o 13:14 Luk 6:7; Jon 5:16; Eks 20:9-10; Diu 5:13-14*Lemu yêêv sen nanggin dumb-ato ahekalin in nambe Yesu wiing-ambe vêêh-anju nivasa lak hôôk busin sawaasin, om yêêv-anju nêêl vu hil nambe, “Busin namaavaalu be vindak ti neep in nambe yaambiing kul, om ham awiingin nambe lambiing ham anim vasa jak ond ham anaam hôôk busin sen kul-atêêto, de ham-ame anaam dôôk busin sawaasin e.” ");
INSERT INTO mmo_vpl VALUES ("LK13_15","072_13_15","LUK","13","15","15","+ o 13:15 Luk 14:5*Tombe Omaaho Bop nêêl laah vu nambe, “Ham oo natee ham ak. Ham pin oo nala bik ambaan hôôk busin sawaasin-ambe ham navu kavaayin kao yuuh donggi tonde ham nanggiiy sil-ambe lala danum bel. ");
INSERT INTO mmo_vpl VALUES ("LK13_16","072_13_16","LUK","13","16","16","+ o 13:16 Luk 19:9*Nganjo vêêh-anjo ond Abalaam-ate hil vu taamusin-ato ti yi, lemu Saalang duuh-ambe nando lohvu ta nomaayuuh-ambe laam namaavaalu be vindak yaal, om yik soo kavaayin hees sen duuh yii-ju hôôk busin sawaasin.” ");
INSERT INTO mmo_vpl VALUES ("LK13_17","072_13_17","LUK","13","17","17","Yesu nêêl nambêênju tombe yite hil pin sen layi yi payaa-to ond nind mum, tonde hil pin lapêêlis in va nivasa vasa pin sen nawiing-ato. ");
INSERT INTO mmo_vpl VALUES ("LK13_18","072_13_18","LUK","13","18","18","Tonde yik Yesu nêêl nambe, “Anutu nanggin yite hil nambe vaati? Sale taahu jak vaati? ");
INSERT INTO mmo_vpl VALUES ("LK13_19","072_13_19","LUK","13","19","19","Om lohvu môônd nôôvoow sen tok-ambe valup, tombe omaaho ti hako be la vaalôôh-ato, lemu taamusin valup-ambe tu haah bopaata, tombe manak dahaav vunis-ambe dando lak nama.” ");
INSERT INTO mmo_vpl VALUES ("LK13_20","072_13_20","LUK","13","20","20","Tonde yik nêêl ango nambe, “Sale taato Anutu nanggin yite hil-ato jak vaati? ");
INSERT INTO mmo_vpl VALUES ("LK13_21","072_13_21","LUK","13","21","21","Om Anutu nanggin yite hil-ato ond lohvu va sen datung lukala balet-ambe nalinj-ato danêêl nambe yis, ond vêêh ti hako yis-anju be monanggingg having balet hôôk kaambum bopaata, tombe yis la hanggwang balet alopayo lôôt atombe linj.” ");
INSERT INTO mmo_vpl VALUES ("LK13_22","072_13_22","LUK","13","22","22","Tonde sim Yesu la monatup hôôk lohvu taaku bop osin taaku pasiv vaalu be monanêêl tanasin vu hil-ambe nala in nambe na Yelusalem. ");
INSERT INTO mmo_vpl VALUES ("LK13_23","072_13_23","LUK","13","23","23","Tonde omaaho ti lingin nambe, “Omaaho Bop, mak Anutu le nôôh omaahonôôn daka yuu-mu vêêl-ambe lana vu yi?” Le Yesu nêêl vu sil nambe, ");
INSERT INTO mmo_vpl VALUES ("LK13_24","072_13_24","LUK","13","24","24","+ o 13:24 Pil 3:12*“Ham oo nimwêêk lôôt in ham andukana mop avi ango pasiv. Sa naanêêl vu ham naambe hil ngeeyaata le lambiingin naambe landukana, lemu me-lalohvu le. ");
INSERT INTO mmo_vpl VALUES ("LK13_25","072_13_25","LUK","13","25","25","+ o 13:25 Mat 25:10-12*In bayêên mangganaan e kandi be baayiiy vinavi, tombe mem ham e gato baale vinavi voon-ambe ham anyiis ak naambe, ‘Omaaho Bop, onggataahin vinavi in hey.’ Tombe le naanêêl nos vu ham naambe, ‘Ham vu tana? Sa doosin ham.’ ");
INSERT INTO mmo_vpl VALUES ("LK13_26","072_13_26","LUK","13","26","26","Le sim ham e naanêêl vu yi naambe, ‘Yiiy pin yaha vanôôn osin yaanum hôôk ti bôôy-ato, de ganêêl tanasin vu hey vu heyate talind.’ ");
INSERT INTO mmo_vpl VALUES ("LK13_27","072_13_27","LUK","13","27","27","+ o 13:27 Saam 6:8*Lemu le naanêêl vu ham naambe, ‘Ham alaam vu tana? Same alak ham anim e. Ham pin oo nawiing va nipaya, om ham ana vêêl in sa.’ ");
INSERT INTO mmo_vpl VALUES ("LK13_28","072_13_28","LUK","13","28","28","+ o 13:28 Mat 8:11-12*“Tombe ham e angge Abalaam ayuuh Isak-ande Yaakop, tonde hil sen danêêl Anutu-te vakasin langaah-ato pin ond sil e mando gaving Anutu-te hil, nganjo ham ond Anutu le gatiiy ham ana mando nanyendangga, le mem ham monaasu osin ham navum monaangitak vuu-ju. ");
INSERT INTO mmo_vpl VALUES ("LK13_29","072_13_29","LUK","13","29","29","+ o 13:29 Saam 107:3; Luk 14:15*Tonde hil e lanaam vu taaku me nalak nalup-ato de vu taaku me nalukalaa-to, osin hil vu taaku nanyendangga vaalu vaalu, ond le lana mando mondanja vanôôn vu taaku sen Anutu nanggin yite hil-ato. ");
INSERT INTO mmo_vpl VALUES ("LK13_30","072_13_30","LUK","13","30","30","+ o 13:30 Mat 19:30*“Keen, hil vaalu sen davu taamuyin gêên-ato ond le lana daamunggin, tonde hil vaalu sen gêên lamunggin-ato ond le lanom taamu.” ");
INSERT INTO mmo_vpl VALUES ("LK13_31","072_13_31","LUK","13","31","31","Tombe yik Palisai heey lalup pavis-ambe lanêêl vu Yesu nambe, “Onambiing gavuuh taakuu-jo de gana taaku ngo, in Helot wiingin nambe nyiis hong-ambe ganggimb.” ");
INSERT INTO mmo_vpl VALUES ("LK13_32","072_13_32","LUK","13","32","32","Le ma de Yesu nêêl vu sil nambe, “Ham anaah naanêêl vu tatuhin ambu Helot-anju naambe gangoyin, peey-ambe jeey ond sa natiiy mamu nipaya in omaahonôôn, de sa naawiing-ambe hil anilakin anind vasa nahôôk, tonde samiin sen busin naatu yaal-ato ond sate kul lung la. ");
INSERT INTO mmo_vpl VALUES ("LK13_33","072_13_33","LUK","13","33","33","Nganjo peey-anjo be jeey-ande samiin ond soo monana, in hil sen danêêl Anutu-te vakasin langaah-ato ond hil-ame dayiis sil-ambe dayimb vu taaku vaalu le, malis, yik hil oo dayiis sil vu Yelusalem timu.’ ");
INSERT INTO mmo_vpl VALUES ("LK13_34","072_13_34","LUK","13","34","34","“O Yelusalem, ham nayiis hil sen danêêl Anutu-te vakasin langaah-ato be dayimb, de hil sen Anutu nawiing sil dalaas vu ham-ato ond ham navu tanga sil lak tatuuh. Tonde balon ngeeyaata ond soo monaawiingin nambe sa naasupin ham anggulis sa baambungg, naambe sen kokalêêh nasupin noow-aso dahulis dala baambuu-to, le ma de ham anim baya. ");
INSERT INTO mmo_vpl VALUES ("LK13_35","072_13_35","LUK","13","35","35","Om ham gango, gêên-anjo ham oo nando malis amu de Anutu havuuh ham, om sa naanêêl vu ham naambe ham-ame le angge sa jesin naah e, de na lôôt-ambe busin sen ham oo le naanêêl naambe, ‘Yiiy gako omaahôô-ju jak in laam ak Omaaho Bop haale.’” ");
INSERT INTO mmo_vpl VALUES ("LK14_1","072_14_1","LUK","14","1","1","+ o 14:1 Luk 11:37*Busin sawaasin ti tombe Yesu la in nambe ja vanôôn dôôk yêêv Palisai ti-te bayêên, tombe hil oo mondapooyak. ");
INSERT INTO mmo_vpl VALUES ("LK14_2","072_14_2","LUK","14","2","2","Tombe Yesu yi de omaaho ti nivuukin-ato nando, ");
INSERT INTO mmo_vpl VALUES ("LK14_3","072_14_3","LUK","14","3","3","+ o 14:3 Luk 6:9*tombe lingin tanasin dangga-so osin Palisai-so nambe, “Yaambiing-ambe hil anilakin nind vasa jak dôôk busin sawaasin ond lohvu me malis?” ");
INSERT INTO mmo_vpl VALUES ("LK14_4","072_14_4","LUK","14","4","4","Le sil lavand ma, tombe Yesu puvu omaaho nivuukin-anju de wiing-ambe nivasa lak, tonde mem nêêl-ambe laah baan. ");
INSERT INTO mmo_vpl VALUES ("LK14_5","072_14_5","LUK","14","5","5","+ o 14:5 Mat 12:11; Luk 13:15*Tonde nêêl vu hil-anju nambe, “Ham ti noow me yite kao naambe duus sov bel-ate dôôk busin sawaasin, ond me-le daandiiy nom pavis e, me?” ");
INSERT INTO mmo_vpl VALUES ("LK14_6","072_14_6","LUK","14","6","6","+ o 14:6 Mat 22:46*Le silanêênd vakasin sen daanêêl naah-ato ma. ");
INSERT INTO mmo_vpl VALUES ("LK14_7","072_14_7","LUK","14","7","7","+ o 14:7 Mat 23:6*Yesu yi de hil vaalu sen yêêv tii-ju teey sil lalaam in nambe lanja vanôôn-anjuuto, ond yoo lawiing in nambe sil gato mando nalu munggin hôôk yêêv-aso mend, om Yesu nêêl vakasin pakwesin vu sil nambe, ");
INSERT INTO mmo_vpl VALUES ("LK14_8","072_14_8","LUK","14","8","8","+ o 14:8 Pro 25:6-7*“Omaaho ti nambe naateey hong-ambe gana vanôôn bop sen moow ayuuh vêêh dako sil-ato, ond game gato mando nalu munggin hôôk himbop-aso mend e. In mak vanôôn danggakook teey omaaho osin haale bop ti be laam, ");
INSERT INTO mmo_vpl VALUES ("LK14_9","072_14_9","LUK","14","9","9","tombe vanôôn danggakook sen teey muuh ahondoos-ato le naas naanêêl vu hong naambe, ‘Ovalok in omaahôô-ju,’ tombe gale ganim naamum-ambe gana mando sil damind. ");
INSERT INTO mmo_vpl VALUES ("LK14_10","072_14_10","LUK","14","10","10","Nganjo naateey hong ond ombalu-mando hil bop-aso damind, in nambe vanôôn danggakook naas naanêêl vu hong naambe, ‘Hali, ganaam mando nalu munggin,’ tonde mem hil pin sen omando be gangga vanôôn gaving sil-ato, ond sil e lanji hong naambe omaaho osin haalem bop. ");
INSERT INTO mmo_vpl VALUES ("LK14_11","072_14_11","LUK","14","11","11","+ o 14:11 Mat 23:12; Luk 18:14*In omaaho sen yoo nako yi lak-ato ond Anutu le daanggôôl yi, de omaaho sen yoo naanggôôl yii-to ond Anutu le gako yi jak.” ");
INSERT INTO mmo_vpl VALUES ("LK14_12","072_14_12","LUK","14","12","12","Tonde yik Yesu nêêl vu vanôôn danggakook sen teey yii-to nambe, “Gambiing vanôôn bop dôôk vandiisin me soosin, ond game naateey gate hil osin halim-aso de gate hil sen ham dangga tii-to, tonde kupak dangga-so sen ham bayêên tii-to, in mak le daateey hong dukanaah tombe ohako gate nivasa nyevahaan lung la. ");
INSERT INTO mmo_vpl VALUES ("LK14_13","072_14_13","LUK","14","13","13","+ o 14:13 Diu 14:29*Nganjo gambiing vanôôn bop ond onaateey hil sen dativak in va yuuh amêê-to, osin hil sen nind naavi vuuti wiing payaa-to, de hil vahand anipaya yuuh hil amend kanu, ");
INSERT INTO mmo_vpl VALUES ("LK14_14","072_14_14","LUK","14","14","14","+ o 14:14 Jon 5:29*ond mem gale gakam vasa, in sil-ame lalohvu nambe lambu dôôk nyevahaan vu hong e, tombe gale gako gate nivasa nyevahaan vu taamusin sen hil anivalok kandi jak naah-ato.” ");
INSERT INTO mmo_vpl VALUES ("LK14_15","072_14_15","LUK","14","15","15","+ o 14:15 Luk 13:29*Hil sen sil ahondoos Yesu-so dando daya vanôôn-anjuuto ond lango Yesu-te vakasin-anju, tombe ti nêêl vu Yesu nambe, “Hil sen landukana lanja vanôôn vu taaku sen Anutu nanggin yite hil-ato ond le kand vasa.” ");
INSERT INTO mmo_vpl VALUES ("LK14_16","072_14_16","LUK","14","16","16","Tombe Yesu nêêl vakasin pakwesin ti vu nambe, “Omaaho ti wiing yite vanôôn bopaata lôôt, tombe teey hil ngeeyaata nambe lanaam. ");
INSERT INTO mmo_vpl VALUES ("LK14_17","072_14_17","LUK","14","17","17","Tombe samu va pin lung la, le mem wiing yite kul vaha ti la vu hil sen teey sil lung laa-to be nêêl yite vakasin vu sil nambe, ‘Ham anaam in sa samu va pin-ambe nando.’ ");
INSERT INTO mmo_vpl VALUES ("LK14_18","072_14_18","LUK","14","18","18","Le ma de sil pin oo lawiing kavôôl. Tombe ti munggin nêêl vu nambe, ‘Sa vaanggo ngaanggis boow ti om sale ana aangge, om onaanêêl vu yêêv naambe me-lohvu nambe sa naas e.’ ");
INSERT INTO mmo_vpl VALUES ("LK14_19","072_14_19","LUK","14","19","19","Tonde yik ango nêêl nambe, ‘Sa naahen vaanggo kao nomaayuuh, tombe sa nala in ana aangge, om onaanêêl vu yêêv naambe me-lohvu nambe sa naas e.’ ");
INSERT INTO mmo_vpl VALUES ("LK14_20","072_14_20","LUK","14","20","20","+ o 14:20 1Ko 7:33*Tonde yik ti nêêl nambe, ‘Sa naahen nako vêêh moos om same aalohvu nambe anaas e.’ ");
INSERT INTO mmo_vpl VALUES ("LK14_21","072_14_21","LUK","14","21","21","Tombe kul vahaa-ju lo-valup-ambe nêêl silate vakasin-anju vu yite yêêv, le yêêv-anju ahekalin-ambe nêêl vu yite kul vaha nambe, ‘Om gana pavis-ambe onggatup hôôk mop bop osin pasiv sen neep bayêên-anjo, tombe onggako hil vuu-ju be lanaam, hil sen dativak in va yuuh amêê-to, osin hil sen nind naavi vuuti wiing payaa-to, de hil amend kanu yuuh hil vahand paaya. ");
INSERT INTO mmo_vpl VALUES ("LK14_22","072_14_22","LUK","14","22","22","Om la be lo-valup, tombe nêêl vu yite yêêv nambe, ‘Himbop, saawiing lohvu ganêêl-ato le taaku naahen neep, hil-ame lalohvu le.’ ");
INSERT INTO mmo_vpl VALUES ("LK14_23","072_14_23","LUK","14","23","23","Om yêêv-anju nêêl vu yite kul vaha nambe, ‘Om gana mop bop osin mop kul-ate pin, tombe onggaanjiihin hil in nambe lanaam daapup hôôk sate bayêên-anjo, ");
INSERT INTO mmo_vpl VALUES ("LK14_24","072_14_24","LUK","14","24","24","de sa naanêêl vu hong naambe hil sen saateey sil bôôy-anjuuto, ond ti me-le ja sate vanôôn bop-anjo daka le.’” ");
INSERT INTO mmo_vpl VALUES ("LK14_25","072_14_25","LUK","14","25","25","Hil ngeeyaata taamuyin Yesu be lala, tombe hilin laah vu sil-ambe nêêl nambe, ");
INSERT INTO mmo_vpl VALUES ("LK14_26","072_14_26","LUK","14","26","26","+ o 14:26 Luk 18:29*“Omaaho ti nambe naam vu sa, le me-galuuh dami vu yoo yite mangganaan ayuuh tangganaan, de vane osin noondin, tonde halindin osin vangaandin, tonde me-nimbaya in yi gaving e, ond me-lohvu nambe naatu sate omaaho le. ");
INSERT INTO mmo_vpl VALUES ("LK14_27","072_14_27","LUK","14","27","27","+ o 14:27 Luk 9:23*Omaaho ti me-baaku yite haah pako be taamuyin sa le, ond me-lohvu nambe naatu sate omaaho le. ");
INSERT INTO mmo_vpl VALUES ("LK14_28","072_14_28","LUK","14","28","28","“Ham ti wiingin nambe daav bayêên bop, ond le mando be ka bu vêêl e naambe yite va nando lohvu nambe daav-ambe jung na me malis. ");
INSERT INTO mmo_vpl VALUES ("LK14_29","072_14_29","LUK","14","29","29","Le naambe yoo daav ngaandiin baale, le me-lohvu nambe daav bayêên jakana be jung na le, ond hil e lanji be daanêêl omaahôô-ju pale naambe, ");
INSERT INTO mmo_vpl VALUES ("LK14_30","072_14_30","LUK","14","30","30","‘Omaahôô-ju haav bayêên lukala, le me-lohvu nambe daav-ambe jung na le.’ ");
INSERT INTO mmo_vpl VALUES ("LK14_31","072_14_31","LUK","14","31","31","“Tonde yik omaaho lulemak ti yite hil ngaamong vaha-so ngeeyaata lohvu 10 taosen, tombe dala in nambe lana lambiing ngaamong vu omaaho lulemak ango osin yite hil ngaamong vaha-so ngeeyaata lôôt lohvu 20 taosen, ond le mando ka bu nivasa vêêl e naambe yite niwêêk lohvu nambe nyiis ngaamong vu sil me malis. ");
INSERT INTO mmo_vpl VALUES ("LK14_32","072_14_32","LUK","14","32","32","Le naambe me-lohvu le, ond yoo naahen monalaas atonde le biing yite yêêv heey daamunggin-ambe lana in kataangg lulemak ango naambe bu mamaal vu sil. ");
INSERT INTO mmo_vpl VALUES ("LK14_33","072_14_33","LUK","14","33","33","“Om nambêênja ham ti me-gavuuh yite va pin na le, ond me-lohvu nambe naatu sate omaaho le.” ");
INSERT INTO mmo_vpl VALUES ("LK14_34","072_14_34","LUK","14","34","34","“Gaas ond va nivasa, lemu naambe gaas anikuuh ak ond yale aambiing vaati vu be naatu nanyêên jesin naah? Malis. ");
INSERT INTO mmo_vpl VALUES ("LK14_35","072_14_35","LUK","14","35","35","Gaas anikuuh ak ond me-nivasa daka in nambe yaambiing kul ti jak naah e, yiiy naate la malis amu. Omaaho ti nambe nanye neep ond gangoyin.” ");
INSERT INTO mmo_vpl VALUES ("LK15_1","072_15_1","LUK","15","1","1","Hil sen dako taakis osin hil anipaya vaalu ngeeyaata lala vu Yesu in nambe sil gango lava, ");
INSERT INTO mmo_vpl VALUES ("LK15_2","072_15_2","LUK","15","2","2","+ o 15:2 Luk 5:30*tonde Palisai-so osin tanasin dangga-so lanyuung nambe, “Omaahôô-ju yoo nako hil anipaya lak tonde naya vanôôn having sil.” ");
INSERT INTO mmo_vpl VALUES ("LK15_3","072_15_3","LUK","15","3","3","Tombe Yesu nêêl vakasin pakwesin ti vu sil nambe, ");
INSERT INTO mmo_vpl VALUES ("LK15_4","072_15_4","LUK","15","4","4","+ o 15:4 Esi 34:11,16; Luk 19:10*“Ham ti nambe yite bik sipsip 100 naale tombe ti na menama, ond le balaah sipsip 99 yoo baale monanja taavêêt alis tonde na mosalo ti sen la memaa-to be naatovu. ");
INSERT INTO mmo_vpl VALUES ("LK15_5","072_15_5","LUK","15","5","5","Naatovu le mem kava be naah osin ka vasa. ");
INSERT INTO mmo_vpl VALUES ("LK15_6","072_15_6","LUK","15","6","6","Naatok naah baan atombe le naateey yite hil osin hil sen sil bayêên tii-to be naanêêl vu sil naambe, ‘Ham anaam gaving sa be yiiy naapêêlis, in sate sipsip ti la mema, le ma de saatokak.’” ");
INSERT INTO mmo_vpl VALUES ("LK15_7","072_15_7","LUK","15","7","7","Tonde Yesu nêêl nambe, “Om sa naanêêl vu ham naambe omaaho nipaya ti gilin lopayo na vu Anutu, ond hil sen dando baandonii-to le daapêêlis in lôôt savok hil 99 sen kand navu nambe sil anivasa lung la, om me-langgilin londpayo le.” ");
INSERT INTO mmo_vpl VALUES ("LK15_8","072_15_8","LUK","15","8","8","“Tonde vêêh ti yite mone kaalus nomaayuuh nando, le ti na menama, ond le taalungg hôôk lam-ambe dasêêh bayêên alo, tombe yoo mosalo nivasa lôôt-ambe naatokak. ");
INSERT INTO mmo_vpl VALUES ("LK15_9","072_15_9","LUK","15","9","9","Naatokak e mem le naateey yite hil osin hil sen sil bayêên tii-to naambe, ‘Ham anaam gaving sa be yiiy naapêêlis, in sate mone ti la mema, le ma de saatokak.’” ");
INSERT INTO mmo_vpl VALUES ("LK15_10","072_15_10","LUK","15","10","10","Tonde Yesu nêêl nambe, “Om nambêênju sa naanêêl vu ham naambe omaaho nipaya ti gilin lopayo na vu Anutu, ond Anutu-te angela-so le daapêêlis in.” ");
INSERT INTO mmo_vpl VALUES ("LK15_11","072_15_11","LUK","15","11","11","Tonde Yesu nêêl vakasin pakwesin ti having nambe, “Omaaho ti noow yuuh dando, ");
INSERT INTO mmo_vpl VALUES ("LK15_12","072_15_12","LUK","15","12","12","tombe nowaamiin la nêêl vu mangganaan nambe, ‘Mangg-e, gate va sen ganêêl lak haay hali tuk aningg-ato, ond gambu sanêêngg vaalu naam pavis vu sa.’ Tombe mangganaan hatiiy va pin lohvu yuuh. ");
INSERT INTO mmo_vpl VALUES ("LK15_13","072_15_13","LUK","15","13","13","+ o 15:13 Pro 29:3*“Tombe yaal dando daka vêêl e mem nowaamiin supin yite va pin-ambe la taaku dinaandiin lôôt. Tombe yoo la nandôô-ju be monawiliyak yinêên va lôôt. ");
INSERT INTO mmo_vpl VALUES ("LK15_14","072_15_14","LUK","15","14","14","Tombe yinêên va pin lung la, de meep bopaata neep taakuu-ju, tombe yoo monativak in vanôôn ayuuh ame. ");
INSERT INTO mmo_vpl VALUES ("LK15_15","072_15_15","LUK","15","15","15","Om la nawiing kul vu hil taakuu-ju ti, tombe omaahôô-ju wiing la taavêêt alo in nambe ganggin yite bik. ");
INSERT INTO mmo_vpl VALUES ("LK15_16","072_15_16","LUK","15","16","16","+ o 15:16 Pro 23:21*Tombe yoo wiingin nambe ja vanôôn naavi sen bik-aso dayaa-to be naapuvu yi, le omaaho ti me-vu vu yi le. ");
INSERT INTO mmo_vpl VALUES ("LK15_17","072_15_17","LUK","15","17","17","Tombe ka vu nivasa laah-ambe yoo nêêl vu yi nambe, ‘Mangg-ate hil kul-ate pin ond silate vanôôn nalohvu sil-ambe navu savok, de sa nandôô-jo tombe meep nawiing sa be sa naahimb ahengg lôôt, ");
INSERT INTO mmo_vpl VALUES ("LK15_18","072_15_18","LUK","15","18","18","+ o 15:18 Saam 51:4; Jer 3:12-13*om sa kandi be sa naah vu mangg-ambe sa kataangg naambe, “Mangg-e, saawiing va nipaya vu Anutu de vu hong, ");
INSERT INTO mmo_vpl VALUES ("LK15_19","072_15_19","LUK","15","19","19","om same sa nivasa in nambe onaanêêl sa naambe onoom jesin naah e, malis. Gambiing-ambe sa naatu gate hil kul-ate ti.’” ");
INSERT INTO mmo_vpl VALUES ("LK15_20","072_15_20","LUK","15","20","20","Tombe mem kandi be laah vu mangganaan. “Yoo naahen monalaam dinaandiin atonde mangganaan yi be ka pasiv lôôt in, tombe hatup-ambe la kaambi be muuh, ");
INSERT INTO mmo_vpl VALUES ("LK15_21","072_15_21","LUK","15","21","21","tonde mem nowaamiin nêêl vu nambe, ‘Mangg, saawiing va nipaya vu Anutu de vu hong, de same sa nivasa in nambe onaanêêl sa naambe onoom jesin naah e.’ ");
INSERT INTO mmo_vpl VALUES ("LK15_22","072_15_22","LUK","15","22","22","Le ma de mangganaan nêêl vu yite hil kul-ate nambe, ‘Ham pavis-ambe ham ana gako lolop ti yoo nivasa lôôt-ambe ham anjop hôôk yi. Tonde ham gatung jambaanj hôôk nama osin ham gatung suul hôôk vaha. ");
INSERT INTO mmo_vpl VALUES ("LK15_23","072_15_23","LUK","15","23","23","Tonde ham ana gako kao nituvakin ti sen yavaat-ambe linj nivasaa-to, tombe ham anyiis-ambe yangga de yiiy naapêêlis. ");
INSERT INTO mmo_vpl VALUES ("LK15_24","072_15_24","LUK","15","24","24","+ o 15:24 Ep 2:1,5; 5:14*In sa noongg-anjo yakangg vu nambe mak yimb bôôy, le ma de yoo nando moos. La mema, le ma de tok lo-valup.’ Tombe mem sil lapêêlis lôôt. ");
INSERT INTO mmo_vpl VALUES ("LK15_25","072_15_25","LUK","15","25","25","“Tombe nowaatuk la kul-ambe lo-hato. Hato ngaaho vu bayêên atonde hango sil dakôômb, ");
INSERT INTO mmo_vpl VALUES ("LK15_26","072_15_26","LUK","15","26","26","om teey hil kul-ate ti laam-ambe lingin kombin-anju danggakook vu. ");
INSERT INTO mmo_vpl VALUES ("LK15_27","072_15_27","LUK","15","27","27","Tombe nêêl vu nambe, ‘Ohalim lo-valup atombe mom yi nambe me-yimb e, de nando nivasa, om yiis kao nituvakin ti sen yavaat-ambe linj nivasaa-to in nambe yangga.’ ");
INSERT INTO mmo_vpl VALUES ("LK15_28","072_15_28","LUK","15","28","28","+ o 15:28 Luk 15:2*Le ma de ahekalin-ambe nimbaya nambe me-dukana vu sil e. Tombe mangganaan hato laam voon vu be kataangg yi, ");
INSERT INTO mmo_vpl VALUES ("LK15_29","072_15_29","LUK","15","29","29","le ma de nowaatuk nêêl laah vu mangganaan nambe, ‘Angge, sa naawiing gate kul nalohvu ta ngeeyaata lôôt, de same navu kalêêh gate vakasin ti le, lemu game gavu kao ti vu sa in nambe saambiing vanôôn bop vu sate hil e. ");
INSERT INTO mmo_vpl VALUES ("LK15_30","072_15_30","LUK","15","30","30","Nganjo onoom-anja ond hako gate va pin-ambe la vu vêêh baayamb-aso be sil laya be lung la, le valup atombe gayiis kao nituvakin sen linj nivasaa-ju vu.’ ");
INSERT INTO mmo_vpl VALUES ("LK15_31","072_15_31","LUK","15","31","31","Tombe mangganaan nêêl vu nambe, ‘Tuk-o, onando having sa lohvu busin pin, tonde sate va pin ond gate va, ");
INSERT INTO mmo_vpl VALUES ("LK15_32","072_15_32","LUK","15","32","32","om yalonggpayo nivasa be yiiy naapêêlis ond mem, in halim-anju yakangg vu nambe mak yimb bôôy, le ma de yoo nando moos. La mema, le ma de tok lo-valup.’” ");
INSERT INTO mmo_vpl VALUES ("LK16_1","072_16_1","LUK","16","1","1","Tonde Yesu nêêl vu yite maanggêêm-aso nambe, “Omaaho kupak dangga ti yite kul vaha ti nando nanggin yite va pin, ond vaheey lanêêl vu yêêv-anjuuto nambe yite kul vaha tii-ju nawiiyak yite va lôôt-ande menanggin nivasa le. ");
INSERT INTO mmo_vpl VALUES ("LK16_2","072_16_2","LUK","16","2","2","Om yêêv teey yite kul vahaa-ju laam-ambe nêêl vu nambe, ‘Sa hango lanêêl vakasin vaati lak hong? Kul sen onawiing lak sate vaa-to ond okaavu pin-ambe gambu naam vu sa, in game le gambiing kul-anja jesin naah e.’ ");
INSERT INTO mmo_vpl VALUES ("LK16_3","072_16_3","LUK","16","3","3","Tombe kul vaha tii-ju yoo ka vu nambe, ‘Sate yêêv navu gatiiy sa in kul-anjo om sale aambiing naambe vaati? Sanêêngg nipaalis sen saambiing kul pin-ato lung la, om naambe sa gako kul jak-ambe sa daav luliiy ond same aalohvu le, de soo mando mokataangg va vu hil amu ond sale sa ningg naamum. ");
INSERT INTO mmo_vpl VALUES ("LK16_4","072_16_4","LUK","16","4","4","Ke, om mem sa kangg vu va sen saambiing-ato in nambe busin sen sate yêêv gatiiy sa in kul-anjôôto ond mem vaheey e gako sa jakana silate bayêên.’ ");
INSERT INTO mmo_vpl VALUES ("LK16_5","072_16_5","LUK","16","5","5","“Tombe kul vaha tii-ju teey hil sen yite yêêv vu va vu sil bôôy-ambe silate nyevahaan naahen neep-ato, tombe sil ti ti lalaam vu yi, tombe lingin ti munggin nambe, ‘Sate yêêv vu vaaheey vu hong atombe game gavu hôôk nyevahaan e?’ ");
INSERT INTO mmo_vpl VALUES ("LK16_6","072_16_6","LUK","16","6","6","Tombe nêêl vu nambe, ‘Vu dalam kalaasin doo-namaavaalu vu sa.’ Le kul vahaa-ju nêêl vu nambe, ‘Om gate kaapiya nganjo, onggato mando be okaavu pavis naambe dalam kalaasin doo-yuuh-ambe nomaayuuh amu.’ ");
INSERT INTO mmo_vpl VALUES ("LK16_7","072_16_7","LUK","16","7","7","Tonde lingin ango nambe, ‘Tonde vu vaaheey vu hong atombe game gavu hôôk nyevahaan e?’ Tombe nêêl nambe, ‘Vu bek paandi doo-namaavaalu vu sa.’ Le kul vahaa-ju nêêl vu nambe, ‘Om gate kaapiya nganjo, okaavu naambe doo-yumbeyuuh amu.’ ");
INSERT INTO mmo_vpl VALUES ("LK16_8","072_16_8","LUK","16","8","8","+ o 16:8 Ep 5:8; 1Tes 5:5*“Tombe yêêv yi va sen yite kul vaha nipayaa-ju wiing-ambe seelin hil vaalu-te nimeen hato laah in nambe sil gako yi jakana silate bayêên vu taamusin-ato, tombe yêêv nêêl nambe yite kul vahaa-ju wiing va osin ka, in hil sen kand navu va voon-atêêto dawiing va osin kand hôôk silate hil lavuun savok hil sen dando hôôk melangaah-ato. ");
INSERT INTO mmo_vpl VALUES ("LK16_9","072_16_9","LUK","16","9","9","+ o 16:9 Mat 6:20; Luk 14:14*“Tonde sa naanêêl vu ham naambe ham andôôvu hil lak mone voon-atêênjo in nambe sil lanji ham nivasa, be jung na ond mem sil e gako ham jakana taaku sen ham mando danggata osin danggataa-to. ");
INSERT INTO mmo_vpl VALUES ("LK16_10","072_16_10","LUK","16","10","10","+ o 16:10 Luk 19:17-26*Yaambu va pasivdaka dukana omaaho ti nama tombe yoo ganggin nivasa lôôt, ond yik le ganggin va ngeeyaata nivasa lôôt gaving. Le naambe omaaho ti nanggin va pasivdaka paya, ond le ganggin va ngeeyaata paya gaving. ");
INSERT INTO mmo_vpl VALUES ("LK16_11","072_16_11","LUK","16","11","11","Om naambe ham-ame nanggin mone voon-ate nivasa le, ond lati le bu va keenaanôôn vu ham in nambe ham ganggin? Le nama. ");
INSERT INTO mmo_vpl VALUES ("LK16_12","072_16_12","LUK","16","12","12","De naambe ham-ame ganggin omaaho ango-te va nivasa le, ond lati le bu va naatu hamanêêm? Malis. ");
INSERT INTO mmo_vpl VALUES ("LK16_13","072_16_13","LUK","16","13","13","+ o 16:13 Mat 6:24*“Omaaho ti me-lohvu nambe biing kul aniwêêk vu yêêv yuuh e, in le nimbaya in ango de ahe gaving ango, om le naapuvu ango, de galuuh dami vu ango. Om ham-ame alohvu nambe ham ambiing Anutu-te kul aniwêêk-ande ham ambiing kul mone niwêêk gaving e.” ");
INSERT INTO mmo_vpl VALUES ("LK16_14","072_16_14","LUK","16","14","14","+ o 16:14 Mat 23:14*Palisai-so ahend oo naving mone lôôt, om lango Yesu-te vakasin pin-anju tombe lanêêl vakasin palesin lak yi. ");
INSERT INTO mmo_vpl VALUES ("LK16_15","072_16_15","LUK","16","15","15","+ o 16:15 Mat 23:28; Luk 18:9-14; Pro 21:2*Le Yesu nêêl vu sil nambe, “Ham awiing in nambe omaahonôôn lanji ham naambe ham hil anivalok, lemu Anutu lak ham alompayo ni nambe nipaya, in va sen omaahonôôn dako lak nambe va nivasa lôôt ond Anutu nayi nambe va nipaya valok. ");
INSERT INTO mmo_vpl VALUES ("LK16_16","072_16_16","LUK","16","16","16","+ o 16:16 Mat 11:12-13*“Mose-te tanasin osin Anutu-te vakasin sen hil danêêl langaah-ato neep niwêêk-ambe tok valup sen Jon lipis hil-ato, tonde mem sa monaanêêl banye nivasa sen Anutu nanggin yite hil-ato, tombe hil pin aniwêêk in nambe landukana gaving Anutu-te hil. ");
INSERT INTO mmo_vpl VALUES ("LK16_17","072_16_17","LUK","16","17","17","+ o 16:17 Mat 5:18*Naambe yendak osin ngaanggis na menama, lemu Mose-te tanasin boow daka me-le na menama le, malis lôôt. ");
INSERT INTO mmo_vpl VALUES ("LK16_18","072_16_18","LUK","16","18","18","+ o 16:18 Mak 10:11-12; 1Ko 7:10-11*“Omaaho ti gavuuh vane na de gako vêêh ango ond wiing baayamb, tonde omaaho ti nambe gako vêêh sen laya havuuh-ato ond yik wiing baayamb having.” ");
INSERT INTO mmo_vpl VALUES ("LK16_19","072_16_19","LUK","16","19","19","Tonde Yesu nêêl nambe, “Omaaho kupak dangga ti nando, ond nalop lolop amengali-ngali osin navêêh tôômb amembu nivasa vasa, tonde yoo nando osin va nivasa vasa nalak busin pin. ");
INSERT INTO mmo_vpl VALUES ("LK16_20","072_16_20","LUK","16","20","20","Tonde omaaho ango haale nambe Lasalus, yinêên va ma de payêês lohvu ninaavi pin, ond hil lambe neep ngaaho vu omaaho sen kupak danggaa-jute bayêên avi voon, ");
INSERT INTO mmo_vpl VALUES ("LK16_21","072_16_21","LUK","16","21","21","+ o 16:21 Mat 15:27*tombe yoo wiingin nambe ja omaaho kupak danggaa-jute vanôôn anyengale sen natok la pêêt kambinii-to, le ma de voow lalaam-ambe mondatep nipayêês. ");
INSERT INTO mmo_vpl VALUES ("LK16_22","072_16_22","LUK","16","22","22","“Tombe omaaho nipayaa-ju yimb-ambe angela-so lako be la nando having Abalaam. Tonde omaaho kupak danggaa-ju yimb having-ambe hil lahaav, ");
INSERT INTO mmo_vpl VALUES ("LK16_23","072_16_23","LUK","16","23","23","tombe la nando taaku nipaya, be nando monango nivaane bopaata lôôt. Tombe vêêl me lak e yi de Abalaam nando dinaandiin lôôt tombe Lasalus nando having, ");
INSERT INTO mmo_vpl VALUES ("LK16_24","072_16_24","LUK","16","24","24","om teey la nambe, ‘Aamangg Abalaam-e, gakam pasiv in sa, de gambiing Lasalus na in daanggôôl nama kapis daka dôôk bel kuuh-ambe naam in gambe jak sa dalaangg in naakuuh vu, in sa nango nivaane bopaata lôôt hôôk kin mala lopayôô-jo.’ ");
INSERT INTO mmo_vpl VALUES ("LK16_25","072_16_25","LUK","16","25","25","Le Abalaam nêêl vu nambe, ‘Noongg-e, goo gakam bu le, in ohako nivasa bôôy sen onaahen nando voon-ato, tonde Lasalus ond hako nipaya, lemu gêên-anjo laam nando osin ninaavi nikuusin, tonde onango nivaane bopaataa-ja. ");
INSERT INTO mmo_vpl VALUES ("LK16_26","072_16_26","LUK","16","26","26","Tonde va ango having nambe metokin bopaata lôôt yakaluuh hey-ande ham in nambe hil sen vuu-jo be lanaas vu ham-ato ond me-lalohvu le, tonde yik nambêênja hil-ame le vuu-ja be lanaam nganjo le.’ ");
INSERT INTO mmo_vpl VALUES ("LK16_27","072_16_27","LUK","16","27","27","Tombe omaahôô-ju nêêl vu Abalaam nambe, ‘Om Aamangg, sa kataangg hong naambe gambiing-ambe naah mangg ambaan, ");
INSERT INTO mmo_vpl VALUES ("LK16_28","072_16_28","LUK","16","28","28","in sa halingg-aso namaavaalu dando om bu kôôvu sil, in sil e landukanaam taaku nivaane-têênjo gaving sa.’ ");
INSERT INTO mmo_vpl VALUES ("LK16_29","072_16_29","LUK","16","29","29","Le Abalaam nêêl nambe, ‘Kaapiya sen Mose osin Anutu-te tanasin sen hil danêêl langaah-ato neep, om halim-aso yoo gango tanasin-anju.’ ");
INSERT INTO mmo_vpl VALUES ("LK16_30","072_16_30","LUK","16","30","30","Tombe nêêl nambe, ‘Aamangg Abalaam-e, malis lôôt. Omaaho ti vu hil yimbin-ate be na naanêêl vu sil ond mem le langgilin sil vasa.’ ");
INSERT INTO mmo_vpl VALUES ("LK16_31","072_16_31","LUK","16","31","31","+ o 16:31 Jon 11:44-48*Le Abalaam nêêl nambe, ‘Naambe sil-ame lambiing gaving Mose osin Anutu-te tanasin sen hil danêêl langaah-ato le, ond yik omaaho ti nambe kandi jak vu hil yimbin-ate be na naanêêl vu sil e, lemu sil-ame le lambiing gaving yite vakasin e.” ’ ");
INSERT INTO mmo_vpl VALUES ("LK17_1","072_17_1","LUK","17","1","1","Yesu nêêl vu yite maanggêêm-aso nambe, “Va sen biing-ambe omaahonôôn dupake hôôk va nipayaa-to le balup, lemu hil sen dawiing va nipaya be davu kape hil vaaluu-to, ond sil e daatovu nimeen. ");
INSERT INTO mmo_vpl VALUES ("LK17_2","072_17_2","LUK","17","2","2","Hil naambêênju ond hil talu tatuuh bopaata dôôk ka naamunggin-ambe gaate dukana lôôy ond mem nivasa, de me-taahu va nipaya vu unoopasiv-asôônjo ti be me-biing va nipaya le. ");
INSERT INTO mmo_vpl VALUES ("LK17_3","072_17_3","LUK","17","3","3","+ o 17:3 Mat 18:15*“Ham ganggin ham. Halim biing va nipaya ond onaanêêl yi, tonde gilin lopayo ond okawiiy yite nipaya na. ");
INSERT INTO mmo_vpl VALUES ("LK17_4","072_17_4","LUK","17","4","4","Tonde ohalim biing hong paya balon namaavaalu be vindak yuuh dôôk busin timu, le yoo gilin nom vu hong balon namaavaalu be vindak yuuh-ambe naanêêl naambe, ‘Hali, saawiing hong paya,’ ond yik okawiiy yite nipayaa-ja na.” ");
INSERT INTO mmo_vpl VALUES ("LK17_5","072_17_5","LUK","17","5","5","+ o 17:5 Mak 9:24*Tombe sinaale-so lanêêl vu Omaaho Bop nambe, “Gandôôvu hey in nambe hey aambiing gaving hong niwêêk.” ");
INSERT INTO mmo_vpl VALUES ("LK17_6","072_17_6","LUK","17","6","6","+ o 17:6 Mat 17:20; 21:21*Tombe Omaaho Bop nêêl vu sil nambe, “Ham ambiing gaving pasivdaka nohvu môônd nôôvoow daka, ond ham e naanêêl vu haah mambaliiy tii-jo naambe, ‘Gambêêl-ambe gana baale dôôk lôôy,’ tombe le biing nohvu ham lavam.” ");
INSERT INTO mmo_vpl VALUES ("LK17_7","072_17_7","LUK","17","7","7","Tonde Yesu lingin nambe, “Naambe ham ti-te hil kul vaha nawiing kul sen nalaah ngaanggis me nanggin bik sipsip-ato, tombe nom balup bayêên soosin, ond le naanêêl vu hil kul vahaa-ju naambe, ‘Ganaam gangga vanôôn pavis e.’ Me? ");
INSERT INTO mmo_vpl VALUES ("LK17_8","072_17_8","LUK","17","8","8","Malis, le naanêêl vu naambe, ‘Onggayêêh sate vanôôn, tonde onggavêêh tôômb ngaaho de ganjuuh sate vanôôn-ambe onggako naam in sangga be sa naanum jung na vêêl e, mem goo gangga be onaanum taamu.’ ");
INSERT INTO mmo_vpl VALUES ("LK17_9","072_17_9","LUK","17","9","9","Tombe omaahôô-ju le gako yite hil kul vaha jak pavis in hango lava. Me? Malis. ");
INSERT INTO mmo_vpl VALUES ("LK17_10","072_17_10","LUK","17","10","10","Om yik ham nambêênja. Ham ambiing kul pin sen Anutu nanêêl vu ham-ato be jung na, le mem ham naanêêl naambe, ‘Hey hil kul anipaya-so, hey oo aawiing kul sen neep vu hey amengg amu.’” ");
INSERT INTO mmo_vpl VALUES ("LK17_11","072_17_11","LUK","17","11","11","+ o 17:11 Luk 9:51-52; 13:22*Yesu monala in nambe na Yelusalem atombe loh mop vu taaku ti sen neep Samaalia yuuh Galili lavuun-ato. ");
INSERT INTO mmo_vpl VALUES ("LK17_12","072_17_12","LUK","17","12","12","+ o 17:12 Lev 13:45-46*Tombe la hato bayêên bu ti, tonde hil nomaayuuh latok lalaam vu, ond sil anind payêês anipaya lôôt om sil oo daale diin, ");
INSERT INTO mmo_vpl VALUES ("LK17_13","072_17_13","LUK","17","13","13","tombe dateey la vu nambe, “Omaaho Bop Yesu-e, gakam pasiv in hey e.” ");
INSERT INTO mmo_vpl VALUES ("LK17_14","072_17_14","LUK","17","14","14","+ o 17:14 Lev 14:2-3; Luk 5:14*Tombe Yesu yi sil-ambe nêêl nambe, “Ham ana taato ham anim naavi vu kul vaha sen datung salivangin-ato.” Om sil lala in nambe lana, tombe yik sil anind naavi nivasa lak. ");
INSERT INTO mmo_vpl VALUES ("LK17_15","072_17_15","LUK","17","15","15","Tombe sil ti yi nambe ninaavi nivasa lak lung la, om hilin-ambe laah de hako Anutu haale lak osin lava bopaata, ");
INSERT INTO mmo_vpl VALUES ("LK17_16","072_17_16","LUK","17","16","16","tombe la hato pataav baambu neep voon hôôk Yesu vaha be pêêlis vu yi. Omaaho tii-ju ond Samaalia ti, ");
INSERT INTO mmo_vpl VALUES ("LK17_17","072_17_17","LUK","17","17","17","tombe Yesu nêêl nambe, “De saawiing-ambe hil nomaayuuh anind vasa lak-ato, le sil namaavaalu be vindak yumbeyuuh dando tana? ");
INSERT INTO mmo_vpl VALUES ("LK17_18","072_17_18","LUK","17","18","18","Sil ti me-lom-ambe hako Anutu haale lak e? Yik himbaya tii-jo mu?” ");
INSERT INTO mmo_vpl VALUES ("LK17_19","072_17_19","LUK","17","19","19","+ o 17:19 Luk 7:50*Tonde nêêl vu omaahôô-ju nambe, ‘Okandi be gana, gawii-having ondeey ganim vasa lak.” ");
INSERT INTO mmo_vpl VALUES ("LK17_20","072_17_20","LUK","17","20","20","+ o 17:20 Jon 3:3; 18:36*Tombe Palisai-so lalingin Yesu nambe, “Naangelis e Anutu naam in ganggin yite hil?” Tombe Yesu nêêl laah vu sil nambe, “Anutu me-le taato vati vu ham naambe navu naam in ganggin yite hil e. ");
INSERT INTO mmo_vpl VALUES ("LK17_21","072_17_21","LUK","17","21","21","+ o 17:21 Mak 13:21*Tonde me-le daanêêl naambe, ‘Ham angge, nando nganjo,’ osin ‘Ham angge, nando nganju.’ Malis. In Anutu laam nanggin yite hil hôôk ham lavuun lung laa-to.” ");
INSERT INTO mmo_vpl VALUES ("LK17_22","072_17_22","LUK","17","22","22","Tonde Yesu nêêl vu yite maanggêêm-aso nambe, “Busin ti ham oo le ambiingin lôôt naambe ham angge Omaahonôôn Noow-ate busin daka, lemu ham-ame le angge le. ");
INSERT INTO mmo_vpl VALUES ("LK17_23","072_17_23","LUK","17","23","23","+ o 17:23 Luk 21:8*Tombe le daanêêl vu ham naambe, ‘Ham angge, nando nganju,’ tonde daanêêl naambe, ‘Ham angge, nando nganjo,’ ond ham-ame ana taamuyin sil e. ");
INSERT INTO mmo_vpl VALUES ("LK17_24","072_17_24","LUK","17","24","24","In lohvu sen demak navêêl-ambe tum hôôk bayiimb baandoni vaalu be la vaalu pavis-ato, ond yik Omaahonôôn Noow e naambêênju dôôk yite busin sen nom-ato. ");
INSERT INTO mmo_vpl VALUES ("LK17_25","072_17_25","LUK","17","25","25","+ o 17:25 Luk 9:22*Lemu le gako nivaane ngeeyaata vêêl e, tombe hil sen dando gêên-anjo le nind baya in yi. ");
INSERT INTO mmo_vpl VALUES ("LK17_26","072_17_26","LUK","17","26","26","+ o 17:26 Jen 6:5-12*“De hôôk Noa-te busin bôôy-ato ond hil doosin-ande vati tovu sil pavis, ond yik le naambêênju dôôk Omaahonôôn Noow-ate busin. ");
INSERT INTO mmo_vpl VALUES ("LK17_27","072_17_27","LUK","17","27","27","+ o 17:27 Jen 7:6-23*In bôôy ond hil dando mondaya vanôôn osin mondanum, de moow ayuuh vêêh mondako sil-ambe tok valup busin sen Noa-so lalukala sip alôô-to, tombe bel vaal bopaata lôôt-ambe savun sil pin-ambe layimb. ");
INSERT INTO mmo_vpl VALUES ("LK17_28","072_17_28","LUK","17","28","28","+ o 17:28 Jen 18:20; 19:25*Tonde yik hôôk Lot-ate busin bôôy-ato ond hil oo mondaya vanôôn osin mondanum, tonde mondaanggo va osin mondaalôôh vave de mondahaav bayêên, ");
INSERT INTO mmo_vpl VALUES ("LK17_29","072_17_29","LUK","17","29","29","lemu busin sen Lot havuuh Sodom-ande laa-to, ond kin osin tatuuh anivaane tok vu baandoni nambe luk hatolak-ato be ya sil-ambe layimb pin. ");
INSERT INTO mmo_vpl VALUES ("LK17_30","072_17_30","LUK","17","30","30","Ond le naambêênju dôôk busin sen Omaahonôôn Noow taato yi langaah-ato. ");
INSERT INTO mmo_vpl VALUES ("LK17_31","072_17_31","LUK","17","31","31","+ o 17:31 Mat 24:17-18*“Tonde dôôk busin-anju ond omaaho ti nambe mando lak bayêên alu baandoni, ond me-duus-ambe guli-naah-ambe gako yite va yuuh ame vu bayêên alo le, jip. Tonde yik omaaho ti monambiing yite kul ond me-gilin-ambe naah e. ");
INSERT INTO mmo_vpl VALUES ("LK17_32","072_17_32","LUK","17","32","32","+ o 17:32 Jen 19:17,26*Ham akam oo bu Lot vanêê-to. ");
INSERT INTO mmo_vpl VALUES ("LK17_33","072_17_33","LUK","17","33","33","+ o 17:33 Luk 9:24*“Naambe omaaho ti yoo ganggin yi nivasa in mando metumin, ond le jimb-ambe na menama, le naambe omaaho ti baaku nimeen-ambe jimb ond le mando metumin. ");
INSERT INTO mmo_vpl VALUES ("LK17_34","072_17_34","LUK","17","34","34","Sa naanêêl vu ham naambe dôôk busin-anju ond omaaho yuuhapim e danjip hôôk ti, tombe Anutu le gako ango na de gavuuh ango mando. ");
INSERT INTO mmo_vpl VALUES ("LK17_35","072_17_35","LUK","17","35","35","Tonde vêêh yuuh mando monggayêêh vanôôn hôôk bayêên alo, ond Anutu le gako ango na de gavuuh ango mando. ");
INSERT INTO mmo_vpl VALUES ("LK17_36","072_17_36","LUK","17","36","36","Tonde omaaho yuuh e mondambiing kul tombe Anutu le gako ango na, de gavuuh ango mando.” ");
INSERT INTO mmo_vpl VALUES ("LK17_37","072_17_37","LUK","17","37","37","+ o 17:37 Iyop 39:30*Tombe maanggêêm-aso lanêêl vu Yesu nambe, “Omaaho Bop, vaa-jo le balup vu tana?” Tombe nêêl vu sil nambe, “Hahaanôôn ti yiis nivasa ond manak pin dasupin dala in nambe lanja.” ");
INSERT INTO mmo_vpl VALUES ("LK18_1","072_18_1","LUK","18","1","1","+ o 18:1 Lom 12:12; Kol 4:2; 1Tes 5:17*Tonde Yesu nêêl vakasin pakwesin ti vu sil, in bêêl sil alund jak naambe sil oo mondanohak jak busin pin de me-nindtambo jak e. ");
INSERT INTO mmo_vpl VALUES ("LK18_2","072_18_2","LUK","18","2","2","Nêêl nambe, “Vu taaku bop ti ond yêêv ti nando nangoyin hil-ate vakasin nandôô-ju, ond me-nayêênin Anutu le, de me-ka navu omaahonôôn having e. ");
INSERT INTO mmo_vpl VALUES ("LK18_3","072_18_3","LUK","18","3","3","Tonde vehaahôôv ti nando taakuu-ju ond yoo monala vu yêêv-anju be nanêêl vu nambe, ‘Onggango haay sate omaaho sen nawiing sa payaa-to haayate vakasin-ambe nivalok jak e.’ ");
INSERT INTO mmo_vpl VALUES ("LK18_4","072_18_4","LUK","18","4","4","Le ma de busin ngeeyaata ond yêêv-anju nimbaya nambe me-dôôvu vehaahôôv-anju le, le sim yoo ka vu nambe, ‘Same naayêênin Anutu le, de same sa kangg navu omaahonôôn having e, ");
INSERT INTO mmo_vpl VALUES ("LK18_5","072_18_5","LUK","18","5","5","+ o 18:5 Luk 11:7-8*lemu vehaahôôv-anju yoo monanjinj sa lôôt om sale aandôôvu, in le monanom atombe biing-ambe sa ningg dêêlak.’” ");
INSERT INTO mmo_vpl VALUES ("LK18_6","072_18_6","LUK","18","6","6","Tonde Omaaho Bop nêêl nambe, “Ham akam bu vakasin sen yêêv anipaya tii-ju nêêl-ato le, ");
INSERT INTO mmo_vpl VALUES ("LK18_7","072_18_7","LUK","18","7","7","in Anutu-te hil sen holin sil-ambe yoo mokataangg yi busin-ande langaah in nambe dôôvu sil in hil sen dawiing sil payaa-to, ond Anutu le gango silate vakasin-ambe nivalok jak me malis? Hamambe me-le dôôvu sil pavis e? ");
INSERT INTO mmo_vpl VALUES ("LK18_8","072_18_8","LUK","18","8","8","Ôôye, sa naanêêl vu ham naambe le dôôvu sil pavis. Lemu Omaahonôôn Noow nom-ato ond le naatovu omaahonôôn vaalu lawii-having yi me malis?” ");
INSERT INTO mmo_vpl VALUES ("LK18_9","072_18_9","LUK","18","9","9","Tonde Yesu nêêl vakasin pakwesin ti vu hil sen yoo dawii-having nambe sil hil anivasa, tonde yoo dayi hil ango nambe va malis amu, ");
INSERT INTO mmo_vpl VALUES ("LK18_10","072_18_10","LUK","18","10","10","ond nêêl nambe, “Omaaho yuuh lala lalup Anutu-te dumb bop in nambe yuuh lanohak-ato, ond yuuh-anju Palisai ango de hil sen dako taakis-ato ango. ");
INSERT INTO mmo_vpl VALUES ("LK18_11","072_18_11","LUK","18","11","11","+ o 18:11 Luk 16:15*Tombe Palisai tii-ju yoo la naale be lohak hôôk lopayo nambe, ‘O Anutu, sa naapêêlis vu hong in nambe same nambe hil ango le, in sil dalakin hil vaalu-te va, de sil hil anipaya osin dawiing baayamb. De sa ond same nambe sil e, de same nambe hil sen dako taakis ti sen naalêê-ju le, ma. ");
INSERT INTO mmo_vpl VALUES ("LK18_12","072_18_12","LUK","18","12","12","+ o 18:12 Jen 14:20; Mat 23:23*Sa nalakin sa in vanôôn-ande same naha le, de sa naalohak balon yu-yuuh nalak sonda pin, tonde va pin sen sa nakôô-to ond sa natung lak lu nomaayuuh tombe sa naavu lu ti natu salivangin vu hong.’ ");
INSERT INTO mmo_vpl VALUES ("LK18_13","072_18_13","LUK","18","13","13","+ o 18:13 Saam 51:1*“Ke, lohak nambêênju, lemu hil sen dako taakis tii-ju ond yoo naale diin daka, tombe me luus voon-ambe yoo kaatuuh yi de lohak nambe, ‘O Anutu, sa omaaho nipaya, gakam pasiv in sa.’ ");
INSERT INTO mmo_vpl VALUES ("LK18_14","072_18_14","LUK","18","14","14","+ o 18:14 Mat 23:12; Luk 14:11*“Om sa naanêêl vu ham naambe omaahôô-ju hato la voon-ambe laah baan atombe Anutu nêêl yi nambe omaaho nivalok. Nganjo Palisai tii-ju ond ma, in hil sen yoo dako sil lak-ato ond Anutu le daanggôôl sil, de hil sen yoo daanggôôl sil-ato ond Anutu le gako sil jak.” ");
INSERT INTO mmo_vpl VALUES ("LK18_15","072_18_15","LUK","18","15","15","Tombe hil lako unoopasiv laam vu Yesu in nambe gambe nama jak sil, tombe maanggêêm-aso layi be lanêêl hil-anju, ");
INSERT INTO mmo_vpl VALUES ("LK18_16","072_18_16","LUK","18","16","16","le ma de Yesu teey unoopasiv-aso lalaam, le mem nêêl vu maanggêêm-aso nambe, “Ham baale de unoopasiv-anju lanaam vu sa le. Ham-ame anggilin sil e, in Anutu nanggin hil nambêênjo having. ");
INSERT INTO mmo_vpl VALUES ("LK18_17","072_18_17","LUK","18","17","17","+ o 18:17 Mat 18:3*Sa naanêêl keen vu ham naambe omaaho ti me-gulis Anutu baambu naambe unoopasiv-anju le, ond me-le dukana gaving Anutu-te hil e.” ");
INSERT INTO mmo_vpl VALUES ("LK18_18","072_18_18","LUK","18","18","18","+ o 18:18 Luk 10:25*Tombe yêêv ti lingin Yesu nambe, “Kaputung anivasa, saambiing vaati le mem sa mando metumin danggata?” ");
INSERT INTO mmo_vpl VALUES ("LK18_19","072_18_19","LUK","18","19","19","Tombe Yesu nêêl nambe, “Ganêêl sa nambe nivasa in? Omaaho ti me-nivasa le, Anutu timu nivasa. ");
INSERT INTO mmo_vpl VALUES ("LK18_20","072_18_20","LUK","18","20","20","+ o 18:20 Eks 20:12-16; Diu 5:16-20*Galak tanasin ani, nambe ‘Game gambiing baayamb e, game ganyiis omaaho ti be jimb e, game gambiing hôôndak e, game tatuhin vakasin jak omaaho ango le, onggako mom ayuuh tam jak.’” ");
INSERT INTO mmo_vpl VALUES ("LK18_21","072_18_21","LUK","18","21","21","Tombe nêêl vu Yesu nambe, “Sa naahen unoopasiv-ande soo samu va pin-anja lôôt-ambe gêên-anjo.” ");
INSERT INTO mmo_vpl VALUES ("LK18_22","072_18_22","LUK","18","22","22","+ o 18:22 Mat 6:20*Yesu hango tombe nêêl vu nambe, “Le va timu naahen. Ganaah-ambe gambu gate va pin na be hil baanggo, tombe gambu mone na vu hil sen dativak in va yuuh amêê-to in mem gale gako nôôn nivasa vu baandoni, tonde ganaam taamuyin sa.” ");
INSERT INTO mmo_vpl VALUES ("LK18_23","072_18_23","LUK","18","23","23","Le ma de hango Yesu-te vakasin-anjo tombe lopayo nimeen ak in yite va ngeeyaata nando. ");
INSERT INTO mmo_vpl VALUES ("LK18_24","072_18_24","LUK","18","24","24","Yesu yi nambe lopayo nimeen atombe nêêl nambe, “Hil sen silate va ngeeyaataa-to, ond le lanôôhin in nambe landukana gaving Anutu-te hil. ");
INSERT INTO mmo_vpl VALUES ("LK18_25","072_18_25","LUK","18","25","25","Bik kamel ti me-lohvu nambe dukana lulak vuun e, le nôôhin, de hil sen silate va ngeeyaataa-to ond yik me-lalohvu nambe landukana gaving Anutu-te hil e, le lanôôhin lôôt.” ");
INSERT INTO mmo_vpl VALUES ("LK18_26","072_18_26","LUK","18","26","26","Tombe hil sen lango Yesu-te vakasin-anjo lanêêl vu nambe, “Om omaaho lati lohvu nambe mando metumin danggata?” ");
INSERT INTO mmo_vpl VALUES ("LK18_27","072_18_27","LUK","18","27","27","+ o 18:27 Mak 14:36*Tombe Yesu nêêl nambe, “Va sen omaahonôôn-ame lalohvu nambe lambiing e, ond Anutu yoo lohvu nambe biing.” ");
INSERT INTO mmo_vpl VALUES ("LK18_28","072_18_28","LUK","18","28","28","Tombe Pita nêêl nambe, “Angge, hey-anjo ond hey havuuh heyate bayêên ayuuh ame de hey navu taamuyin hong.” ");
INSERT INTO mmo_vpl VALUES ("LK18_29","072_18_29","LUK","18","29","29","Tombe Yesu nêêl vu sil nambe, “Sa naanêêl keen vu ham naambe hil pin sen lavuuh silate bayêên, me vanêêndin, me halindin, me maandin ayuuh taandin, me noondin-ande sil lala danêêl Anutu-te banye sen nanggin yite hil-ato, ");
INSERT INTO mmo_vpl VALUES ("LK18_30","072_18_30","LUK","18","30","30","ond gêên sil e gako nivasa nyevahaan ngeeyaata lôôt savok sen-anjo na, tonde vu busin taamusin sil e mando metumin danggata osin danggata.” ");
INSERT INTO mmo_vpl VALUES ("LK18_31","072_18_31","LUK","18","31","31","+ o 18:31 Luk 24:44*Yesu hako maanggêêm nomaayuuh-ambe laam yuuh-ato be lala lundoos daka, tombe nêêl vu sil nambe, “Ham gango le, yiiy navu ana balup Yelusalem atombe vakasin pin sen Anutu nêêl-ambe hil kaavu lak Omaahonôôn Noow-ato navu nôôn jak. ");
INSERT INTO mmo_vpl VALUES ("LK18_32","072_18_32","LUK","18","32","32","+ o 18:32 Luk 9:22,44*Yik le lambu dukana hil vaalu sen sil-ame Yudaa-to namand, tombe sil pale yi, de lambiing nindanjeen vu osin kasuv jak yi, ");
INSERT INTO mmo_vpl VALUES ("LK18_33","072_18_33","LUK","18","33","33","tonde sil e gaveek yi, de lanyiis-ambe jimb, tonde busin naatu yaal e mem kandi jak jesin naah.” ");
INSERT INTO mmo_vpl VALUES ("LK18_34","072_18_34","LUK","18","34","34","+ o 18:34 Mak 9:32*Le vakasin-anjo dangga vun yi, om maanggêêm-aso me-lalak ni daka le, sil doosin lôôt. ");
INSERT INTO mmo_vpl VALUES ("LK18_35","072_18_35","LUK","18","35","35","Yesu la valup ngaaho vu Yeliko, tombe omaaho mekanu ti nando hôôk mop nanyendangga, ond nando mokataangg va vu hil. ");
INSERT INTO mmo_vpl VALUES ("LK18_36","072_18_36","LUK","18","36","36","Tombe hango de hil ngeeyaata lalu-dala, om lingin nambe, “Nambe vaatii-ja?” ");
INSERT INTO mmo_vpl VALUES ("LK18_37","072_18_37","LUK","18","37","37","Tombe lanêêl vu nambe, “Yesu Nasaalet valu-nala.” ");
INSERT INTO mmo_vpl VALUES ("LK18_38","072_18_38","LUK","18","38","38","+ o 18:38 Mat 15:22*Tombe omaaho mekanu teey nambe, “Yesu-e, hong sen gate danggakook neep vu Devit-ato, gakam pasiv in sa.” ");
INSERT INTO mmo_vpl VALUES ("LK18_39","072_18_39","LUK","18","39","39","Tombe hil sen damunggin-ato ond lanêêl yi lôôt nambe, “Olavam nama.” Le ma de yoo monateey lôôt nambe, “Yesu, hong sen gate danggakook neep vu Devit-ato, gakam pasiv in sa.” ");
INSERT INTO mmo_vpl VALUES ("LK18_40","072_18_40","LUK","18","40","40","Tombe Yesu naale be nêêl nambe sil gako naam vu yi. Tombe lako laam atombe Yesu lingin nambe, ");
INSERT INTO mmo_vpl VALUES ("LK18_41","072_18_41","LUK","18","41","41","“De gawiingin nambe saambiing vaati vu hong?” Tombe nêêl nambe, “Omaaho Bop, gambiing-ambe sa mengg naatum-o.” ");
INSERT INTO mmo_vpl VALUES ("LK18_42","072_18_42","LUK","18","42","42","+ o 18:42 Luk 7:50*Tombe Yesu nêêl nambe, “Om gamem naatum. Gawii-having om gamem anivasa lak.” ");
INSERT INTO mmo_vpl VALUES ("LK18_43","072_18_43","LUK","18","43","43","Tombe yik me tum pavis atombe hako Anutu haale lak-ambe la taamuyin Yesu, tonde hil pin layi be sil lavand hôôk Anutu. ");
INSERT INTO mmo_vpl VALUES ("LK19_1","072_19_1","LUK","19","1","1","Yesu lukala Yeliko be la in nambe na, ");
INSERT INTO mmo_vpl VALUES ("LK19_2","072_19_2","LUK","19","2","2","tonde hil sen dako taakis-ato silate yêêv ti nandôô-ju, haale nambe Sakaias, ond yite va ngeeyaata nando. ");
INSERT INTO mmo_vpl VALUES ("LK19_3","072_19_3","LUK","19","3","3","Tombe yoo wiingin nambe ji Yesu naambe yi lati, le ma de vaha ngaaho om hil ngeeyaata daale dahilin, ");
INSERT INTO mmo_vpl VALUES ("LK19_4","072_19_4","LUK","19","4","4","om yoo hatup-ambe munggin Yesu-so be la lak haah ti in nambe ji Yesu, in navu balup mop-anju be na. ");
INSERT INTO mmo_vpl VALUES ("LK19_5","072_19_5","LUK","19","5","5","Tombe Yesu valup taakuu-ju tombe vêêl me lak-ambe nêêl vu Sakaias nambe, “Sakaias, ganduus pavis, in peey sa navu ana mando gambaam.” ");
INSERT INTO mmo_vpl VALUES ("LK19_6","072_19_6","LUK","19","6","6","Om luus pavis-ambe hako Yesu lakala yite bayêên osin lopayo nivasa, ");
INSERT INTO mmo_vpl VALUES ("LK19_7","072_19_7","LUK","19","7","7","+ o 19:7 Luk 5:30; 15:2*tonde hil pin layi be lanyuung nambe, “Yesu lukala nando having omaaho nipaya tii-ju in?” ");
INSERT INTO mmo_vpl VALUES ("LK19_8","072_19_8","LUK","19","8","8","+ o 19:8 Eks 22:1; Nam 5:6-7*Tonde Sakaias naale be nêêl vu Omaaho Bop nambe, “Omaaho Bop angge, sa navu aambu sate va vaalu vu hil sen dativak in va yuuh amêê-to, de sa tatuhin omaaho ti be sa hako yite vati ond sale aambu va yumbeyuuh dukanaah nyevahaan.” ");
INSERT INTO mmo_vpl VALUES ("LK19_9","072_19_9","LUK","19","9","9","+ o 19:9 Sin 16:31-34; Luk 13:16*Tombe Yesu nêêl vu nambe, “Gêên Anutu hôôvu ham bayêên tii-jo, in hong-anjo gate danggakook neep vu Abalaam having. ");
INSERT INTO mmo_vpl VALUES ("LK19_10","072_19_10","LUK","19","10","10","+ o 19:10 Luk 15:4; Jon 3:17; 1Ti 1:15*In Omaahonôôn Noow ond laam in nambe salo hil sen lala mend maa-to be gako sil lanom.” ");
INSERT INTO mmo_vpl VALUES ("LK19_11","072_19_11","LUK","19","11","11","Hil lango vakasin-anju tombe kand vu nambe Yesu la valup ngaaho vu Yelusalem om omaahonôôn pin davu lanji naambe Anutu nanggin yite hil, om Yesu nêêl vakasin pakwesin ti vu sil nambe, ");
INSERT INTO mmo_vpl VALUES ("LK19_12","072_19_12","LUK","19","12","12","+ o 19:12 Mak 13:34*“Omaaho ti osin haale bop navu na taaku dinaandiin in nambe yêêv bop bu haale omaaho lulemak vu, le mem nom ganggin yite hil. ");
INSERT INTO mmo_vpl VALUES ("LK19_13","072_19_13","LUK","19","13","13","Om teey yite kul vaha nomaayuuh lalaam-ambe vu mone kaapiya yu-yuuh vu sil-ande nêêl vu sil nambe, ‘Ham ambiing kul jak monêê-ja be saanom gato le mem.’ ");
INSERT INTO mmo_vpl VALUES ("LK19_14","072_19_14","LUK","19","14","14","+ o 19:14 Jon 1:11*“Lung atonde la, lemu yite hil anind baya lôôt in yi, om lawiing hil heey-ambe sil taamuyin yi be lala lanêêl vu yêêv bop nambe, ‘Hey animbaya nambe omaahôô-ju me-naatu lulemak-ambe ganggin hey e.’ ");
INSERT INTO mmo_vpl VALUES ("LK19_15","072_19_15","LUK","19","15","15","Le ma de hako haale lulemak-ambe lom, tombe nêêl-ambe hil lateey kul vaha-so sen vu mone vu sil-ato lalaam in nambe yoo gango naambe sil lawiing kul lak yite mone be lako mone nyesavokin vaahe-vaaheey lukala having. ");
INSERT INTO mmo_vpl VALUES ("LK19_16","072_19_16","LUK","19","16","16","“Tombe ti la vu munggin-ambe nêêl vu nambe, ‘Himbop, saawiing kul lak gate mone kaapiya yuuh-ato be sa hako mone nyesavokin 200 kina lukalaam having.’ ");
INSERT INTO mmo_vpl VALUES ("LK19_17","072_19_17","LUK","19","17","17","+ o 19:17 Luk 16:10*Tombe omaaho lulemak nêêl vu nambe, ‘Ke mem, hong kul vaha nivasa. Ohanggin va pasivdaka mu nivasa lôôt, om onavu ganggin taaku bopaata nomaayuuh.’ ");
INSERT INTO mmo_vpl VALUES ("LK19_18","072_19_18","LUK","19","18","18","“Tonde yik ango la vu be nêêl vu nambe, ‘Himbop, gavu mone kaapiya yuuh vu sa tombe saawiing kul lak-ambe sa hako mone nyesavokin 100 kina lukalaam having.’ ");
INSERT INTO mmo_vpl VALUES ("LK19_19","072_19_19","LUK","19","19","19","Tombe omaaho lulemak nêêl vu nambe, ‘Ke, om onavu naatu yêêv-ambe ongganggin taaku bop namaavaalu.’ ");
INSERT INTO mmo_vpl VALUES ("LK19_20","072_19_20","LUK","19","20","20","“Tonde yik ti la vu be nêêl nambe, ‘Himbop, gate mone kaapiya yuuh nganjo, soo vayum hôôk tôômb-ambe sa hatung nando. ");
INSERT INTO mmo_vpl VALUES ("LK19_21","072_19_21","LUK","19","21","21","Saayêênin hong in hong omaaho osin niwêêk bopaata. Hil vaalu datung va nando le goo nalakin silate va, tonde hil ango daalôôh vave le goo nako nôôn.’ ");
INSERT INTO mmo_vpl VALUES ("LK19_22","072_19_22","LUK","19","22","22","Tombe omaaho lulemak nêêl nambe, ‘Goo gate vakasin-anja om sa naanêêl naambe onggako gate nipaya nyevahaan, in hong kul vaha nipaya. Galak sa ningg nambe sa omaaho osin niwêêk bopaata, hil vaalu datung va nando le soo nalakin silate va, tonde hil ango daalôôh vave le soo nako nôôn. ");
INSERT INTO mmo_vpl VALUES ("LK19_23","072_19_23","LUK","19","23","23","Le nambe vaati sen game hatung sate mone hôôk beng, in saanom ond sa gako sate va nom de sil lambu mone nyesavokin vaalu gaving?’ ");
INSERT INTO mmo_vpl VALUES ("LK19_24","072_19_24","LUK","19","24","24","Tonde nêêl vu hil sen daalêê-ju nambe, ‘Ham ambu vêêl mone in omaahôô-ja de ham ambu vu omaaho sen hako mone bek tii-to.’ ");
INSERT INTO mmo_vpl VALUES ("LK19_25","072_19_25","LUK","19","25","25","Tombe lanêêl vu nambe, ‘Mu himbop, hako mone bek ti lung laa-to.’ ");
INSERT INTO mmo_vpl VALUES ("LK19_26","072_19_26","LUK","19","26","26","+ o 19:26 Mat 13:12; Luk 8:18*Le nêêl nambe, ‘Sa naanêêl vu ham naambe hil pin sen silate va neep-ato ond sil e gako va vaalu gaving, nganjo omaaho paya paya sen silate va maa-to, ond va pasivdaka sen neep vu sil-ato le nama na valok-ate lôôt. ");
INSERT INTO mmo_vpl VALUES ("LK19_27","072_19_27","LUK","19","27","27","Lemu sate hil sen dayi sa payaa-to, de nind baya nambe same ganggin sil e, ond ham gako sil lanaam atombe ham anyiis sil-ambe lanjimb hôôk sa mengg-anjo.’” ");
INSERT INTO mmo_vpl VALUES ("LK19_28","072_19_28","LUK","19","28","28","Yesu nêêl vakasin-anju lung la tonde munggin-ambe valu-la in nambe na Yelusalem. ");
INSERT INTO mmo_vpl VALUES ("LK19_29","072_19_29","LUK","19","29","29","Tombe valu-la ngaaho vu Betpaasi yuuh Betaani vu kandu Oliv, le mem wiing yite maanggêêm yuuh lamunggin-ambe lala, ");
INSERT INTO mmo_vpl VALUES ("LK19_30","072_19_30","LUK","19","30","30","tombe nêêl vu yuuh nambe, “Mana be mandukana bayêên-anju ond male angge naambe sil talu donggi noow ti naale, omaahonôôn-ame dalak bôôy e, ond muuh kavaayin-ambe muuh gako be manom. ");
INSERT INTO mmo_vpl VALUES ("LK19_31","072_19_31","LUK","19","31","31","De omaaho ti jingin muuh naambe, ‘Muuh navu kavaayin donggi noow-anja in?’ ond muuh naanêêl vu naambe, ‘Omaaho Bop wiingin nambe biing kul ti jak pavis e.’” ");
INSERT INTO mmo_vpl VALUES ("LK19_32","072_19_32","LUK","19","32","32","+ o 19:32 Luk 22:13*Om yuuh lala lalup-ambe yuuh layi va lohvu sen Yesu nêêl vu yuuh-ato, ");
INSERT INTO mmo_vpl VALUES ("LK19_33","072_19_33","LUK","19","33","33","om yuuh kavaayin donggi, tombe heendin-aso lanêêl vu yuuh nambe, “Muuh navu kavaayin donggi noow-anja in?” ");
INSERT INTO mmo_vpl VALUES ("LK19_34","072_19_34","LUK","19","34","34","Tombe yuuh lanêêl vu sil nambe, “Omaaho Bop wiingin nambe biing kul ak pavis e.” ");
INSERT INTO mmo_vpl VALUES ("LK19_35","072_19_35","LUK","19","35","35","Tonde yuuh lako laah vu Yesu, tombe yuuh lakaah yuuhate lolop-ambe lavaah lakala donggi dami, be mem yuuh latung Yesu lakando be la. ");
INSERT INTO mmo_vpl VALUES ("LK19_36","072_19_36","LUK","19","36","36","+ o 19:36 2King 9:13*Monala tombe hil lakaah silate lolop-ambe lavaah neep mopaatôôv in nambe Yesu gato jêês-ambe na. ");
INSERT INTO mmo_vpl VALUES ("LK19_37","072_19_37","LUK","19","37","37","Tombe tok valup ngaaho vu mopaatôôv ti luus hato kandu Oliv ngaaho vu Yelusalem, tombe Yesu-te hil pin sen davu sapa yii-to daakôôhin-ambe lavand hôôk Anutu osin lapêêlis la vu yi in taahu taahu osin niwêêk pin sen Yesu wiing-ambe sil layi lung laa-to. ");
INSERT INTO mmo_vpl VALUES ("LK19_38","072_19_38","LUK","19","38","38","+ o 19:38 Saam 118:26; Luk 2:14*Lapêêlis nambe, “Anutu biing samu samu vu omaaho lulemak-anja in laam ak Omaaho Bop haale. Hil baandoni mando osin vakasin melaas, tonde yiiy gako Anutu haale jak nanjip baandoni.” ");
INSERT INTO mmo_vpl VALUES ("LK19_39","072_19_39","LUK","19","39","39","Tombe Palisai heey daale having hil ngeeyaataa-ju ond lanêêl vu Yesu nambe, “Kaputung-e, onaanêêlin gate hil-anja naambe lavand nama.” ");
INSERT INTO mmo_vpl VALUES ("LK19_40","072_19_40","LUK","19","40","40","Le Yesu nêêl vu Palisai-sôônju nambe, “Sa naanêêl vu ham naambe sil lavand nama ond tatuuh-anja yoo le baakôôhin.” ");
INSERT INTO mmo_vpl VALUES ("LK19_41","072_19_41","LUK","19","41","41","+ o 19:41 Jon 11:35*Tombe Yesu hato la ngaaho be yi me lak taaku bop Yelusalem atombe su. ");
INSERT INTO mmo_vpl VALUES ("LK19_42","072_19_42","LUK","19","42","42","+ o 19:42 Ais 6:9-10; Mat 13:14; Lom 11:8*Be nêêl nambe, “Gêên ham anjak mop sen ham mando osin vakasin melaas-ato ni ond mem, le ma de mop-anju navun yi in ham. ");
INSERT INTO mmo_vpl VALUES ("LK19_43","072_19_43","LUK","19","43","43","In nambe busin ti le naatok naam vu ham atombe hamate vaavis e gambe tôông gambuuhin ham tatup, in nambe ham-ame napak-ambe ana le, de lanyiis ham. ");
INSERT INTO mmo_vpl VALUES ("LK19_44","072_19_44","LUK","19","44","44","+ o 19:44 Luk 1:68; 21:6*Tonde sil e kawiiy ham osin hamate bayêên-ambe matelak lôôt, de tatuuh bayêên-ate ango me-le mando jak ango baandoni le, in dangga nambe Anutu laam in dôôvu ham, le ma de ham doosin.” ");
INSERT INTO mmo_vpl VALUES ("LK19_45","072_19_45","LUK","19","45","45","Lung laa tonde Yesu lukala Anutu-te dumb bop alo be hatiiy hil sen daanggo va hôôk dumb alopayôô-to be lala voon, ");
INSERT INTO mmo_vpl VALUES ("LK19_46","072_19_46","LUK","19","46","46","+ o 19:46 Ais 56:7; Jer 7:11*de nêêl vu sil nambe, “Anutu-te vakasin neep hôôk kaapiya nambe, ‘Sate bayêên ond le naatu bayêên lohakin,’ le ma de ham awiing-ambe tu hil hôôndak-ate bayêên sen dahôôpis hôôk-ato.” ");
INSERT INTO mmo_vpl VALUES ("LK19_47","072_19_47","LUK","19","47","47","+ o 19:47 Luk 21:37; 22:53; Jon 18:20*Yesu nalukala Anutu-te dumb bop alo be navu taahu hil lak busin pin, tombe kul vaha sen datung salivangin-ato silate yêêv-aso, osin tanasin dangga-so, de hil-ate yêêv bop-aso, sil oo mosalo mop in nambe lanyiis Yesu be jimb, ");
INSERT INTO mmo_vpl VALUES ("LK19_48","072_19_48","LUK","19","48","48","+ o 19:48 Mat 21:46; Mak 14:1-2; Luk 20:19*le ma de me-latovu mop ti le, in hil pin oo mondango yite vakasin nivasa lôôt. ");
INSERT INTO mmo_vpl VALUES ("LK20_1","072_20_1","LUK","20","1","1","Busin ti Yesu monanêêl tanasin atombe tatekin banye nivasa vu hil hôôk Anutu-te dumb bop alo, tombe kul vaha sen datung salivangin-ato silate yêêv-aso osin tanasin dangga-so de himbop-aso lalup, ");
INSERT INTO mmo_vpl VALUES ("LK20_2","072_20_2","LUK","20","2","2","tombe lanêêl vu Yesu nambe, “Onaanêêl vu hey e, lati nêêl-ambe galaam nawiing va pin-anjo? Onawiing kul-anjo lak lati haale?” ");
INSERT INTO mmo_vpl VALUES ("LK20_3","072_20_3","LUK","20","3","3","Tombe Yesu nêêl laah vu sil nambe, “Om yik sa having, saanjingin ham in vakasin ti be ham naanêêl nom vu sa le. ");
INSERT INTO mmo_vpl VALUES ("LK20_4","072_20_4","LUK","20","4","4","+ o 20:4 Mak 1:4-5*De Jon nalipis hil-ato ond lati nêêl? Anutu nêêl me omaahonôôn yoo lanêêl?” ");
INSERT INTO mmo_vpl VALUES ("LK20_5","072_20_5","LUK","20","5","5","+ o 20:5 Mat 21:32*Tombe sil oo lakaas in nambe, “Yiiy naanêêl naambe Anutu nêêl ond le naanêêl vu yiiy naambe, ‘Le nambe tana sen ham-ame awii-having yi le?’ ");
INSERT INTO mmo_vpl VALUES ("LK20_6","072_20_6","LUK","20","6","6","Me yiiy naanêêl naambe omaahonôôn lanêêl-ambe Jon nalipis hil, lemu yiiy naanêêl naambêênjo ond hil pin e tanga yiiy ak tatuuh-ambe yaanggimb, in sil lawii-having nambe Jon-anju yi omaaho sen nanêêl Anutu-te vakasin langaah-ato.” ");
INSERT INTO mmo_vpl VALUES ("LK20_7","072_20_7","LUK","20","7","7","Om lanêêl laah vu Yesu nambe, “Bey, hey doosin.” ");
INSERT INTO mmo_vpl VALUES ("LK20_8","072_20_8","LUK","20","8","8","Tombe Yesu nêêl vu sil nambe, “Om same le naanêêl omaaho sen sa naawiing kul lak haalêê-to vu ham e.” ");
INSERT INTO mmo_vpl VALUES ("LK20_9","072_20_9","LUK","20","9","9","+ o 20:9 Ais 5:1*Tombe Yesu nêêl vakasin pakwesin ti vu hil nambe, “Omaaho ti vaalôôh kul wain ti, tombe vu lukala hil vaalu namand-ambe sil danggin, tonde yoo la taaku dinaandiin-ambe la nando lôôt. ");
INSERT INTO mmo_vpl VALUES ("LK20_10","072_20_10","LUK","20","10","10","+ o 20:10 2Kro 36:15-16*Tonde busin sen wain nasuuh-ato tombe omaahôô-ju wiing yite hil kul ti la vu hil sen danggin yite kul wain-ato in nambe lambu wain nôôn vaalu vu, le ma de hil sen danggin kul wain-ato layiis-ambe latiiy laah-ambe la nama malis amu. ");
INSERT INTO mmo_vpl VALUES ("LK20_11","072_20_11","LUK","20","11","11","Tombe kul mangganaan wiing hil kul ango laah yesin, tombe layiis-ambe lawiing nindanjeen vu, tonde yik latiiy laah-ambe la nama malis amu having. ");
INSERT INTO mmo_vpl VALUES ("LK20_12","072_20_12","LUK","20","12","12","Tonde yik wiing omaaho ti laah yesin tu balon yaal, tombe layiis-ambe ninaavi vapuuh-ande lakôôh la voon. ");
INSERT INTO mmo_vpl VALUES ("LK20_13","072_20_13","LUK","20","13","13","Tombe kul mangganaan nêêl nambe, ‘Sale aambiing naambe vaati? Ke, om saambiing sa noongg sen sahengg having yi lôôt-ato be na, mak sil e lanjêênin yi.’ ");
INSERT INTO mmo_vpl VALUES ("LK20_14","072_20_14","LUK","20","14","14","Lemu hil sen danggin kul wain-ato layi noow atombe yoo lanêêl vu sil nambe, ‘Omaaho sen-anju le gako mangganaan-ate va pin, om ham-o, yaanyiis-ambe jimb-ande kul-anjo naatu yate va.’ ");
INSERT INTO mmo_vpl VALUES ("LK20_15","072_20_15","LUK","20","15","15","Om sil lakôôh la voon, de layiis-ambe yimb. Om ham akam bu naambe kul wain mangganaan e biing naambe vaati vu sil? ");
INSERT INTO mmo_vpl VALUES ("LK20_16","072_20_16","LUK","20","16","16","Le balup-ambe nyiis hil sen danggin kul wain-anjuuto be lana mend nama lôôt, de bu kul wain-anju be hil vaalu ganggin.” Hil lango Yesu-te vakasin-anjo tombe lanêêl nambe, “Malis, jip.” ");
INSERT INTO mmo_vpl VALUES ("LK20_17","072_20_17","LUK","20","17","17","+ o 20:17 Saam 118:22*Le Yesu get sil-ambe nêêl nambe, “De Anutu-te vakasin sen-anjo neep hôôk kaapiya nambe vaati? Sen nêêl nambe, ‘Tatuuh ti sen hil kul-aso nind baya nambe me-landaav bayêên ak e, ond gêên tu bayêên ahelasu-te kook aniwêêk.’ ");
INSERT INTO mmo_vpl VALUES ("LK20_18","072_20_18","LUK","20","18","18","+ o 20:18 Ais 8:14-15*Naambe omaaho ti dupake be nyiis yi jak tatuuh-anju ond le naamuvin daka daka, le naambe tatuuh-anju gato tanga omaaho ti ond le matelak lôôt.” ");
INSERT INTO mmo_vpl VALUES ("LK20_19","072_20_19","LUK","20","19","19","+ o 20:19 Luk 19:47-48*Tanasin dangga-so osin kul vaha sen datung salivangin-ato silate yêêv-aso lalak ni nambe Yesu nêêl vakasin pakwesin tii-jo lak sil, om sil salo mop in nambe lanôôh yi pavis, le ma de layêênin hil. ");
INSERT INTO mmo_vpl VALUES ("LK20_20","072_20_20","LUK","20","20","20","+ o 20:20 Luk 11:54*Om tanasin dangga-so osin kul vaha sen datung salivangin-ato silate yêêv-aso yoo mondanggin Yesu, tonde lawiing hil vaalu be lala vu yi. Hil-anju davu tatuhin nambe sil hil sen davu sapa Anutu-te tanasin keen-ato, le ma de mondapooyak Yesu in nambe naanêêl vakasin ti na paya, ond sil lanôôh-ambe lambu dukana yêêv bop nama in biing vakasin. ");
INSERT INTO mmo_vpl VALUES ("LK20_21","072_20_21","LUK","20","21","21","Tombe hil-anju sen mondapooyak Yesuu-to lanêêl vu nambe, “Kaputung, hey alak ganim nambe hong omaaho sen onanêêl vakasin keen, yik goo navu tatekin Anutu-te mop keen vu hil, de game nayêênin omaaho ti nambe haale bop me haale pasiv e, ");
INSERT INTO mmo_vpl VALUES ("LK20_22","072_20_22","LUK","20","22","22","+ o 20:22 Lom 13:6-7*om onaanêêl vu hey e. Lohvu nambe yiiy Islel gaate taakis na vu Lom-ate yêêv bop Sisa me malis?” ");
INSERT INTO mmo_vpl VALUES ("LK20_23","072_20_23","LUK","20","23","23","Le Yesu lak sil alondpayo ni lung la nambe lawiingin nambe tatuhin yi, om nêêl vu sil nambe, ");
INSERT INTO mmo_vpl VALUES ("LK20_24","072_20_24","LUK","20","24","24","“Ham taato mone taakis ti be saangge le. Lati kanu osin haale lakaneep-anjo?” ");
INSERT INTO mmo_vpl VALUES ("LK20_25","072_20_25","LUK","20","25","25","Tombe lanêêl laah nambe, “Sisa.” Tombe Yesu nêêl vu sil nambe, “Om ham ambu Sisa-te va vu Sisa, de Anutu-te va vu Anutu.” ");
INSERT INTO mmo_vpl VALUES ("LK20_26","072_20_26","LUK","20","26","26","Tombe sil-ame lalohvu nambe tatuhin Yesu be naanêêl vakasin ti na paya hôôk hil amend e, om sil lavand ma, de lavindis lôôt in yite vakasin sen nêêl laah vu sil-ato. ");
INSERT INTO mmo_vpl VALUES ("LK20_27","072_20_27","LUK","20","27","27","Tombe hil Sadusi sen danêêl nambe omaahonôôn yimbin-ame le kandi jak naah-ato, ond sil vaalu lalaam-ambe lalingin Yesu nambe, ");
INSERT INTO mmo_vpl VALUES ("LK20_28","072_20_28","LUK","20","28","28","+ o 20:28 Diu 25:5*“Kaputung, Mose kaavu tanasin in nambe yiiy sapa dôôk ond kaavu ti nambe, ‘Omaaho ti yimb-ande havuuh vane nando de noow ma, ond omaahôô-ju hali le gako vane vehaahôôv-anju in yuuh gako unoopasiv dukanaah mangganaan sen yimb-ato ahembaan.’ ");
INSERT INTO mmo_vpl VALUES ("LK20_29","072_20_29","LUK","20","29","29","Tombe omaaho ti sil o halindin namaavaalu be vindak yuuh dando, tombe sil halindin tuk hako vêêh ti be yimb de noow ma. ");
INSERT INTO mmo_vpl VALUES ("LK20_30","072_20_30","LUK","20","30","30","Om sil halindin miin hako hali vane vehaahôôv-ambe yimb, ");
INSERT INTO mmo_vpl VALUES ("LK20_31","072_20_31","LUK","20","31","31","de gwey hako vehaahôôv-anju be yimb. Tombe yik sil pin lôôt-ambe la hato sil halindin meey, sil pin layimb-ande sil noondin ma, ");
INSERT INTO mmo_vpl VALUES ("LK20_32","072_20_32","LUK","20","32","32","tombe vehaahôôv yimb lakaneep ahus. ");
INSERT INTO mmo_vpl VALUES ("LK20_33","072_20_33","LUK","20","33","33","Om vu busin sen omaahonôôn yimbin kandi jak naah-ato ond vehaahôôv-anju le naatu sil ti tana vane? In sil namaavaalu be vindak yuuh lako vêêh timuu-ju lung laa-to.” ");
INSERT INTO mmo_vpl VALUES ("LK20_34","072_20_34","LUK","20","34","34","Le sim Yesu nêêl vu sil nambe, “Moow ayuuh vêêh dako sil dando gêên-anjo, ");
INSERT INTO mmo_vpl VALUES ("LK20_35","072_20_35","LUK","20","35","35","nganjo hil sen Anutu liinggis nambe sil lalohvu kandi jak naah-ambe mando metumin vu taamusin-ato, ond moow ayuuh vêêh-ame le gako sil e. ");
INSERT INTO mmo_vpl VALUES ("LK20_36","072_20_36","LUK","20","36","36","+ o 20:36 1; Jon 3:1-2*De sil-ame lalohvu nambe lanjimb jesin naah e, in sil kandi lak lung la, om sil lalohvu angela-so, de sil latu Anutu-te noow-aso. ");
INSERT INTO mmo_vpl VALUES ("LK20_37","072_20_37","LUK","20","37","37","+ o 20:37 Eks 3:2-6*De sen hil yimbin kandi jak naah-ato ond Mose taato langaah hôôk vakasin lak haah aniyin sen kin natum hôôk-ato, in vakasin-anju ond nêêl Omaaho Bop nambe Abalaam ayuuh Isak-ande Yaakop-ate Anutu. ");
INSERT INTO mmo_vpl VALUES ("LK20_38","072_20_38","LUK","20","38","38","+ o 20:38 Lom 14:8-9*Le hamambe yaal layimb om yaal lala valok-ate? Malis, in Anutu ond hil metumin vu voon osin hil pin sen layimb-ambe lala dando metumin-ato silate Anutu yi, in yik hil amend moos osin hil yimbin-ato pin dando metumin hôôk Anutu me.” ");
INSERT INTO mmo_vpl VALUES ("LK20_39","072_20_39","LUK","20","39","39","Tombe tanasin dangga-so vaalu lanêêl nambe, “Kaputung, ganêêl vakasin anivasa.” ");
INSERT INTO mmo_vpl VALUES ("LK20_40","072_20_40","LUK","20","40","40","Tombe layêênin-ambe me-lalingin vakasin ti vu Yesu yesin laah e. ");
INSERT INTO mmo_vpl VALUES ("LK20_41","072_20_41","LUK","20","41","41","Tombe Yesu lingin sil nambe, “Nambe vaati sen danêêl omaaho sen Anutu yoo holin yi vulôôt in nambe dôôvu yiiy-ato nambe yite danggakook neep vu Devit? ");
INSERT INTO mmo_vpl VALUES ("LK20_42","072_20_42","LUK","20","42","42","+ o 20:42-43 Saam 110:1*In Devit kaavu vakasin ti hôôk kaapiya Saam nambe, ‘Omaaho Bop nêêl vu sate Omaaho Bop nambe, “Omando sa namangg vasa gaving sa, ");
INSERT INTO mmo_vpl VALUES ("LK20_43","072_20_43","LUK","20","43","43","de sale aambiing-ambe hil sen dayi hong payaa-to le langgulis hong vaalu kambi.” ’ ");
INSERT INTO mmo_vpl VALUES ("LK20_44","072_20_44","LUK","20","44","44","Om sen Devit nêêl omaahôô-ju nambe Omaaho Bop, le nambe vaati sen Omaaho Bop-anju tu Devit-ate hil moos ti?” ");
INSERT INTO mmo_vpl VALUES ("LK20_45","072_20_45","LUK","20","45","45","Hil pin mondangoyin Yesu lava, tonde nêêl vu yite maanggêêm-aso nambe, ");
INSERT INTO mmo_vpl VALUES ("LK20_46","072_20_46","LUK","20","46","46","“Ham ganggin ham in tanasin dangga-so, in sil oo lawiingin nambe lanjop lolop dinaandiin-ambe ganjung noh talind in nambe omaahonôôn gako sil jak, osin sil lana mando hil pin amend vu dumb alo, de vanôôn bop ond sil oo mando nalu munggin. ");
INSERT INTO mmo_vpl VALUES ("LK20_47","072_20_47","LUK","20","47","47","Tonde dalakin vehaahôôv-ate bayêên, de davun londpayo lak lohakin diin, om nipaya nyevahaan e naatovu sil bopaata lôôt.” ");
INSERT INTO mmo_vpl VALUES ("LK21_1","072_21_1","LUK","21","1","1","Yesu monayi de hil kupak dangga-so daate silate salivangin lukala kalong hôôk Anutu-te dumb bop alo. ");
INSERT INTO mmo_vpl VALUES ("LK21_2","072_21_2","LUK","21","2","2","Tombe yi de vehaahôôv ti yinêên va ma, yik valup-ambe haate yinêên mone noow daka yuuh, ");
INSERT INTO mmo_vpl VALUES ("LK21_3","072_21_3","LUK","21","3","3","+ o 21:3 2Ko 8:12*tombe Yesu nêêl nambe, “Sa naanêêl keen vu ham naambe vehaahôôv-anju, ond yinêên va ma, lemu hatung salivangin-anju kaluuh omaahonôôn pin. ");
INSERT INTO mmo_vpl VALUES ("LK21_4","072_21_4","LUK","21","4","4","In sil pin-anju va ngeeyaata nando le lako pasivdaka-daka be latung salivangin ak, de vehaahôôv-anju yinêên va ma, lemu haate yite mone sen baanggo vanôôn ayuuh ame jak-ato pin lukala tu salivangin.” ");
INSERT INTO mmo_vpl VALUES ("LK21_5","072_21_5","LUK","21","5","5","Tonde hil vaalu lakaas in Anutu-te dumb bop nambe hil lavunak ak tatuuh anivasa vasa osin va mengali sen vaheey lavu in nambe gako Anutu haale jak-ato, tombe Yesu nêêl nambe, ");
INSERT INTO mmo_vpl VALUES ("LK21_6","072_21_6","LUK","21","6","6","+ o 21:6 Luk 19:44*“Ham nahe vaa-ju, nganjo busin ti tombe tatuuh-anju ango me-le mando jak ango baandoni le, hil e kawiiy pin-ambe na mando danjeen.” ");
INSERT INTO mmo_vpl VALUES ("LK21_7","072_21_7","LUK","21","7","7","Tombe lalingin Yesu nambe, “Kaputung, naangelis e vaa-jo le naatok naam? Hey e anjak ni jak vaati naambe vaa-jo navu balup?’ ");
INSERT INTO mmo_vpl VALUES ("LK21_8","072_21_8","LUK","21","8","8","Tombe nêêl nambe, “Ham ganggin ham in omaaho ango le tatuhin ham, in hil ngeeyaata le lanaam-ambe daanêêl sa haalengg ak sil naambe, ‘Sa Kalisii-jo,’ de daanêêl naambe, ‘Busin ngaaho lak-anjo,’ ond ham-ame taamuyin sil e. ");
INSERT INTO mmo_vpl VALUES ("LK21_9","072_21_9","LUK","21","9","9","De ham e gango ngaamong osin hil ahend kalin vu silate yêêv-aso banye, le ham-ame naham jak e, in vaa-ju le naamunggin, lemu va pin-ame le jung na pavis e.” ");
INSERT INTO mmo_vpl VALUES ("LK21_10","072_21_10","LUK","21","10","10","Tonde yik nêêl vu sil nambe, “Bayêên bu ngo le kandi be lambiing ngaamong vu bayêên bu ngo, de gaaman ango le kandi be biing ngaamong vu gaaman ango. ");
INSERT INTO mmo_vpl VALUES ("LK21_11","072_21_11","LUK","21","11","11","Tonde jemaapi le jêêy bopaata, de meep biing omaahonôôn, osin nilakin naatovu hil tave tave nohvu taaku vaalu, tonde va bopaata osin niwêêk vu baandoni le biing-ambe hil lanjêênin lôôt. ");
INSERT INTO mmo_vpl VALUES ("LK21_12","072_21_12","LUK","21","12","12","+ o 21:12-15 Mat 10:18-20; Luk 12:11-12*Lemu va vaaluu-jo le naatovu ham naamunggin naambe hil e lanôôh ham-ambe lambiing nindanjeen vu ham. Tonde le lambu ham dukana yêêv dumb-aso namand osin gatung ham dukana kalaambus, tonde le gako ham ana vu hil lulemak-aso osin yêêv bop-aso in nambe ham ambiing vakasin in sate hil ham, ");
INSERT INTO mmo_vpl VALUES ("LK21_13","072_21_13","LUK","21","13","13","ond manyinja hamate busin ti sen ham naanêêl sa banyengg langaah vu sil-ato. ");
INSERT INTO mmo_vpl VALUES ("LK21_14","072_21_14","LUK","21","14","14","Om ham akam oo bu bulôôt naambe sil gako ham ana in ham ambiing vakasin, ond ham akam-ame bu vakasin sen ham naanêêl naah vu sil-ato le. ");
INSERT INTO mmo_vpl VALUES ("LK21_15","072_21_15","LUK","21","15","15","+ o 21:15 Sin 6:10*Yik soo le aambu kakook osin vakasin anivasa vu ham, tombe mem hil sen dayi ham payaa-to pin-ame le lanohvu naambe sil-ame kawiiy osin sil-ame daanggôôl hamate vakasin e. ");
INSERT INTO mmo_vpl VALUES ("LK21_16","072_21_16","LUK","21","16","16","+ o 21:16 Mat 10:21-22*Tonde ham mom-aso osin tam-aso, de halim-aso, tonde hamate hil osin hil sen ham dangga tii-to ond sil laving, sil e lambu ham dukana hil namand, tombe le lanyiis ham vaalu be ham anggimb. ");
INSERT INTO mmo_vpl VALUES ("LK21_17","072_21_17","LUK","21","17","17","Tombe hil pin e nind baya lôôt in ham in sate hil ham, ");
INSERT INTO mmo_vpl VALUES ("LK21_18","072_21_18","LUK","21","18","18","+ o 21:18 1Sml 14:45; Luk 12:7*lemu ham alumvalus ti me-le na menama le. ");
INSERT INTO mmo_vpl VALUES ("LK21_19","072_21_19","LUK","21","19","19","+ o 21:19 Hiblu 10:36*Ham oo baaku nimeen pin ond mem ham e mando metumin.” ");
INSERT INTO mmo_vpl VALUES ("LK21_20","072_21_20","LUK","21","20","20","“Ham angge naambe hil ngaamong vaha-so davu gambuuh Yelusalem tatup, ond mem ham anjak ni naambe ngaaho lak in davu lambiliyak Yelusalem na valok-ate. ");
INSERT INTO mmo_vpl VALUES ("LK21_21","072_21_21","LUK","21","21","21","Tombe mem hil sen dando Yudiaa-to ond dapak-ambe lana mando kandu lu. Tonde hil sen dando bayêên Yelusalem-ato ond gavuuh-ande lana, de hil sen lala dando taavêêt alôô-to ond me-landukanaah Yelusalem e. ");
INSERT INTO mmo_vpl VALUES ("LK21_22","072_21_22","LUK","21","22","22","+ o 21:22 Diu 32:35; Jer 5:29; 46:10; Hos 9:7*In busin-anju ond hil Yuda davu gako silate nipaya nyevahaan, in nambe Anutu-te vakasin pin sen yite hil kaavu bôôy-ato nôôn jak. ");
INSERT INTO mmo_vpl VALUES ("LK21_23","072_21_23","LUK","21","23","23","+ o 21:23 1Ko 7:26*Om hôôk busin-anju ond nimeen e naatovu vêêh-aso sen noondin lukaalêê-to osin vêêh vaalu sen daahen davu sum vu noondin-ato, in nimeen bopaata le naatovu hil-anjo pin osin nyevahaan nipaya naatovu sil. ");
INSERT INTO mmo_vpl VALUES ("LK21_24","072_21_24","LUK","21","24","24","+ o 21:24 Esra 9:7; Saam 79:1; Ais 63:18; Lom 11:25; Taato 11:2*Hil vaalu sen sil-ame Yudaa-to, sil e dasap Yuda vaalu jak yipak-ambe lanjimb, tonde le talu sil vaalu be gako sil lana mando hil ango-te taaku pin, tonde le mondambiliyak hil Yuda valok-ate be na nohvu busin sen hil vaaluu-jute niwêêk jung naa-to le mem.” ");
INSERT INTO mmo_vpl VALUES ("LK21_25","072_21_25","LUK","21","25","25","+ o 21:25 Saam 46:2-3; 65:7-8; Taato 6:12-13*“Hil e lanji va bopaata biing taaku me osin kwaav-ande matam, tonde lôôy e nyiis bopaata be biing nindaandun lôôt, de omaahonôôn vu voon e lanjêênin-ambe kand na nge-ngeey lôôt. ");
INSERT INTO mmo_vpl VALUES ("LK21_26","072_21_26","LUK","21","26","26","Tombe hil e kand bu lôôt naambe vati navu biing omaahonôôn nohvu taaku pin, om le lanjêênin lôôt-ambe landupake be lana danjip. De va niwêêk vu baandoni pin e baale ye-yêêy, ");
INSERT INTO mmo_vpl VALUES ("LK21_27","072_21_27","LUK","21","27","27","+ o 21:27 Dan 7:13; Mat 26:64; Taato 1:7*tombe mem le lanji Omaahonôôn Noow naam hôôk bayiimb alo, ond le naam osin niwêêk gaving nikaapulis bopaata. ");
INSERT INTO mmo_vpl VALUES ("LK21_28","072_21_28","LUK","21","28","28","+ o 21:28 Lom 13:11*Ham angge vaa-ju naatok naam ond mem ham kandi baale be ham amem jak, in ngaaho lak in Anutu nôôh ham vêêl.” ");
INSERT INTO mmo_vpl VALUES ("LK21_29","072_21_29","LUK","21","29","29","Tombe Yesu nêêl vakasin pakwesin ti vu sil nambe, “Ham akam bu mêêl suusin. ");
INSERT INTO mmo_vpl VALUES ("LK21_30","072_21_30","LUK","21","30","30","Ham angge naambe manak pulapul valu-la, ond ham anjak ni naambe ngaaho lak in yiiy kape mêêl jakana jok. ");
INSERT INTO mmo_vpl VALUES ("LK21_31","072_21_31","LUK","21","31","31","De yik nambêênja om ham angge naambe vakasin pin-ato nôôn ak ond ngaaho lak in Anutu navu ganggin yite hil. ");
INSERT INTO mmo_vpl VALUES ("LK21_32","072_21_32","LUK","21","32","32","“Sa naanêêl keen vu ham naambe hil sen dando gêên-anjôôto ond me-le lanjimb e, de va pin nôôn jak e mem. ");
INSERT INTO mmo_vpl VALUES ("LK21_33","072_21_33","LUK","21","33","33","+ o 21:33 Luk 16:17*Yendak osin ngaanggis e na menama, nganjo sate vakasin ond me-le na menama le, yoo le nanjip danggata.” ");
INSERT INTO mmo_vpl VALUES ("LK21_34","072_21_34","LUK","21","34","34","+ o 21:34 Mat 24:48-50; Mak 4:19; Luk 17:27; 1Tes 5:3*“Ham ganggin ham-ande va vaalu nambe sen ham oo angga vanôôn bo-bop, osin ham naanum bel-ambe ham mokaatuuh hôôk, tonde ham naham jak in nimeen voon-ate, ond ham-ame kam bu va vaaluu-ju lôôt e, in ham e kam bu va vaaluu-ju de ham akam jingin Omaahonôôn Noow na, tonde yite busin e naatok naam pavis. ");
INSERT INTO mmo_vpl VALUES ("LK21_35","072_21_35","LUK","21","35","35","Naambe sen jaang nayiis mun, ond busin sen-anju le naatok naam vu omaahonôôn pin dando lohvu taaku voon-anjo pin. ");
INSERT INTO mmo_vpl VALUES ("LK21_36","072_21_36","LUK","21","36","36","+ o 21:36 Mak 13:33; Taato 6:17*Om ham oo mando mem naatum osin ham anohak jak busin pin in nambe ham oo baale niwêêk lôôt tombe nimeen ayuuh ame me-kape ham e, ond mem ham e baale Omaahonôôn Noow ame.” ");
INSERT INTO mmo_vpl VALUES ("LK21_37","072_21_37","LUK","21","37","37","+ o 21:37 Luk 19:47*Tombe nalak busin pin ond Yesu la navu taahu hil hôôk Anutu-te dumb bop alo, tonde busin ond nalaah taaku sen danêêl nambe kandu Oliv-ato. ");
INSERT INTO mmo_vpl VALUES ("LK21_38","072_21_38","LUK","21","38","38","Tombe hil pin dala vu Yesu hôôk dumb alo hôôk samiinaanôôn nalak busin pin-ambe mondango yite vakasin. ");
INSERT INTO mmo_vpl VALUES ("LK22_1","072_22_1","LUK","22","1","1","+ o 22:1 Eks 12:1-27*Busin bop ti ngaaho lak, ond busin-anju hil datongin balet, lemu me-datung yis nalukala le, nganjo daya balet amu, ond danêêl busin bop-anju nambe busin haluusin, in kand navu sen Anutu haluuh hil Islel hôôk vu Ijip bôôy-ato. Om busin bop-anju ngaaho lak, ");
INSERT INTO mmo_vpl VALUES ("LK22_2","072_22_2","LUK","22","2","2","+ o 22:2 Luk 20:19*tombe kul vaha sen datung salivangin-ato silate yêêv-aso osin tanasin dangga-so lawiingin nambe lanyiis Yesu, lemu layêênin hil pin om davu salo mop lôôt in nambe lanyiis-ambe jimb. ");
INSERT INTO mmo_vpl VALUES ("LK22_3","072_22_3","LUK","22","3","3","+ o 22:3 Jon 13:2,27*Tombe Saalang lukala maanggêêm nomaayuuh-ambe laam yuuh-ato ti Yudas sen danêêl nambe Iskaliot-ato, ");
INSERT INTO mmo_vpl VALUES ("LK22_4","072_22_4","LUK","22","4","4","tombe Yudas-anju la vakaas having yêêv-aso salivangin-ate osin ahevaavu sen danggin Anutu-te dumb bop-ato silate yêêv-aso in nambe bu Yesu dukana sil namand. ");
INSERT INTO mmo_vpl VALUES ("LK22_5","072_22_5","LUK","22","5","5","Tombe sil akand vasa be laliinggis nambe lambu mone vu Yudas, ");
INSERT INTO mmo_vpl VALUES ("LK22_6","072_22_6","LUK","22","6","6","om Yudas liinggis vu sil, tombe yoo salo mop in nambe bu Yesu dukana sil namand kaatokin-ande hil pin-ame lanji le. ");
INSERT INTO mmo_vpl VALUES ("LK22_7","072_22_7","LUK","22","7","7","+ o 22:7 Eks 12:1-27*Tombe busin bop sen hil datongin balet, lemu me-datung yis nalukala le, nganjo daya balet amuu-to, ond yite busin tok laam, ond busin-anju Yuda pin dayiis bik sipsip noow-ambe dasi lohvu busin haluusin-ate. ");
INSERT INTO mmo_vpl VALUES ("LK22_8","072_22_8","LUK","22","8","8","Tombe Yesu wiing Pita yuuh Jon lala be nêêl vu yuuh nambe, “Mana samu vanôôn busin haluusin-ate vu yiiy in yangga.” ");
INSERT INTO mmo_vpl VALUES ("LK22_9","072_22_9","LUK","22","9","9","Tombe yuuh lalingin nambe, “Gawiingin nambe haay samu vanôôn mando tana?” ");
INSERT INTO mmo_vpl VALUES ("LK22_10","072_22_10","LUK","22","10","10","Tombe nêêl vu yuuh nambe, “Mandukana bayêên bop atombe omaaho ti navu kava bel hôôk dêêngg ond le naatovu muuh, ond muuh taamuyin-ambe mandukana bayêên sen lukalaa-to. ");
INSERT INTO mmo_vpl VALUES ("LK22_11","072_22_11","LUK","22","11","11","Tombe muuh naanêêl sa naambe sa kaputung vu bayêên mangganaan-anju be manjingin naambe bayêên alo ti sen sangga vanôôn busin haluusin-ate gaving sate maanggêêm-aso ham-anja neep ond taato vu muuh. ");
INSERT INTO mmo_vpl VALUES ("LK22_12","072_22_12","LUK","22","12","12","Tombe le taato bayêên alo bopaata ti neep baandoni ond latongin lung la be neep, ond muuh samu vanôôn mandôô-ju.” ");
INSERT INTO mmo_vpl VALUES ("LK22_13","072_22_13","LUK","22","13","13","+ o 22:13 Luk 19:32*Tombe yuuh lala be yuuh layi lohvu sen Yesu nêêl-ato tombe mem yuuh samu silate vanôôn busin haluusin-ate. ");
INSERT INTO mmo_vpl VALUES ("LK22_14","072_22_14","LUK","22","14","14","Ngaaho lak in lanja vanôôn busin haluusin-ate tombe Yesu hato nando having sinaale-so, ");
INSERT INTO mmo_vpl VALUES ("LK22_15","072_22_15","LUK","22","15","15","tombe nêêl vu sil nambe, “Soo aawiingin lôôt nambe sangga vanôôn busin haluusin-ate tii-jo gaving ham vêêl e, le mem sa gako nivaane. ");
INSERT INTO mmo_vpl VALUES ("LK22_16","072_22_16","LUK","22","16","16","+ o 22:16 Luk 13:29*De sa naanêêl vu ham naambe same le angga vanôôn-anjo ti jesin naah e, de vanôôn-anjo dangga nôôn jak vu busin sen Anutu ganggin yite hil-ato le mem.” ");
INSERT INTO mmo_vpl VALUES ("LK22_17","072_22_17","LUK","22","17","17","Tombe Yesu lôôh kap wain ti lak-ambe lohak osin pêêlis la vu Anutu, de nêêl nambe, “Ham gakôô-ja naas-ambe ham pin naanum, ");
INSERT INTO mmo_vpl VALUES ("LK22_18","072_22_18","LUK","22","18","18","de sa naanêêl vu ham naambe same le naanum wain nôôn aniluk ti jesin naah e, de na nohvu busin sen Anutu naam in ganggin yite hil-ato le mem.” ");
INSERT INTO mmo_vpl VALUES ("LK22_19","072_22_19","LUK","22","19","19","+ o 22:19 Luk 24:30*Tombe Yesu lôôh balet ak-ambe lohak osin pêêlis la vu Anutu, le mem hapok balet-anju be vu vu sil, de nêêl nambe, “Manyinjo sa ningg naavi sen sa naavu la doos in dôôvu ham-ato. Ham oo monambiing naambêênjo in nambe ham akam bu sa.” ");
INSERT INTO mmo_vpl VALUES ("LK22_20","072_22_20","LUK","22","20","20","Tombe laya vanôôn lung la, le mem yik lôôh kap wain ak-ambe nêêl nambe, “Kap wain-anjo ond manyinjo Anutu-te vakasin moos sen jôôy lung la be neep-ato, de saambiing-ambe nanjip niwêêk ak sa kaasêêh sa ningg hees na in dôôvu ham-ato. ");
INSERT INTO mmo_vpl VALUES ("LK22_21","072_22_21","LUK","22","21","21","+ o 22:21 Saam 41:9; Jon 13:21-22*Lemu ham gangoyin, omaaho sen navu bu sa dukana hil sen lanôôh saa-to namand ond yik ham ti sen yiiy nando monaha vanôôn-anjôôto. ");
INSERT INTO mmo_vpl VALUES ("LK22_22","072_22_22","LUK","22","22","22","In Omaahonôôn Noow e jimb nohvu sen Anutu yoo nêêl lung laa-to, lemu omaaho sen bu yi dukana hil namand-ato le gako nimeen.” ");
INSERT INTO mmo_vpl VALUES ("LK22_23","072_22_23","LUK","22","23","23","Tombe maanggêêm-aso yoo dalingin vu sil nambe “Mak lati le biing naambêênju?” ");
INSERT INTO mmo_vpl VALUES ("LK22_24","072_22_24","LUK","22","24","24","+ o 22:24 Luk 9:46*Tombe maanggêêm-aso yoo dayêês sil in nambe sil ti tana le naatu silate lukook. ");
INSERT INTO mmo_vpl VALUES ("LK22_25","072_22_25","LUK","22","25","25","+ o 22:25 Mat 20:25-27; Mak 10:42-45*Tombe Yesu nêêl vu sil nambe, “Hil vu voon-anjo ond silate lulemak-aso danêêl vakasin osin niwêêk lôôt-ambe daanggôôl silate hil. De silate yêêv bop-aso yoo lawiingin nambe hil daanêêl sil naambe hil ngaatum. ");
INSERT INTO mmo_vpl VALUES ("LK22_26","072_22_26","LUK","22","26","26","+ o 22:26 Mat 23:11; Mak 9:35*Lemu ham ond ham-ame ambiing naambêênju le. Nganjo ham ti haale bop savok ham pin ond yoo daanggôôl yi be naatu omaaho haale pasiv lôôt e mem, de ti sen tu hamate yêêv-ato ond biing va naambe sen yi omaaho malis ti in dôôvu ham. ");
INSERT INTO mmo_vpl VALUES ("LK22_27","072_22_27","LUK","22","27","27","+ o 22:27 Jon 13:12-15*In hamambe omaaho ango tana savok? Omaaho osin haale bop ango sen hato nando in nambe ja vanôôn-ato, me hil kul ango sen naluuh vanôôn-ambe navu vuu-to? Mak ham akam navu nambe omaaho osin haale bop sen hato nandôô-to savok. Le sak, sa nando having ham nambe sen hil malis-ambe sa naahôôvu ham. ");
INSERT INTO mmo_vpl VALUES ("LK22_28","072_22_28","LUK","22","28","28","“Ham ond ham oo naale having sa hôôk nimeen pin sen sa vaakuu-to. ");
INSERT INTO mmo_vpl VALUES ("LK22_29","072_22_29","LUK","22","29","29","+ o 22:29 Luk 12:32*Tombe Aamangg vu kul vu sa lung la in nambe sa ganggin hil, tonde yik saavu kul vu ham lung la, ");
INSERT INTO mmo_vpl VALUES ("LK22_30","072_22_30","LUK","22","30","30","+ o 22:30 Mat 19:28*om ham e mando monangga vanôôn osin ham naanum gaving sa vu taaku sen sa ganggin hil-ato, tonde ham e mando jak lulemak-ate sia be ham gangoyin hil Islel dangga nomaayuuh-ambe laam yuuh-ato silate vakasin.” ");
INSERT INTO mmo_vpl VALUES ("LK22_31","072_22_31","LUK","22","31","31","+ o 22:31 2Ko 2:11*Tonde Yesu nêêl nambe, “Simon-e angge, Anutu liinggis in Saalang nambe sahi ham naambe sen hil daliihin wit nôôvoow-ato. ");
INSERT INTO mmo_vpl VALUES ("LK22_32","072_22_32","LUK","22","32","32","+ o 22:32 Jon 17:11,15,20; Saam 51:13*Le saalohak in hong lung la nambe game gavuuh galompayo sen gawii-having saa-to na le, tonde ganggilin hong nom vu saa-to ond mem okaandu halim-aso.” ");
INSERT INTO mmo_vpl VALUES ("LK22_33","072_22_33","LUK","22","33","33","+ o 22:33 Luk 22:54*Le Pita nêêl vu nambe, “Omaaho Bop, sa longgpayo la having nambe hil gatung hong dukana kalaambus osin lanyiis hong-ambe ganggimb, ond yik lanyiis sa gaving hong.” ");
INSERT INTO mmo_vpl VALUES ("LK22_34","072_22_34","LUK","22","34","34","Le Yesu nêêl nambe, “Pita, sa naanêêl vu hong e, peey busin kokalêêh-ame le naasu le de gale ganjak alum in sa balon yaal vêêl e.” ");
INSERT INTO mmo_vpl VALUES ("LK22_35","072_22_35","LUK","22","35","35","+ o 22:35 Luk 9:3; 10:4*Tonde Yesu nêêl vu sil nambe, “Bôôy saanêêl-ambe ham ala anêêl sate banye nivasaa-to, ond ham-ame hako laayul mone-te osin vaahes-ande suul e, ond ham ativak in va, me malis?” Tombe lanêêl nambe, “Malis.” ");
INSERT INTO mmo_vpl VALUES ("LK22_36","072_22_36","LUK","22","36","36","+ o 22:36 Luk 22:49*Tombe nêêl vu sil nambe, “Om gêên-anjo naambe omaaho ti-te laayul mone-te nando ond gako osin vaahes, tonde omaaho ti-te yipak ngaamong-ate ma, ond bu yite lolop na be baanggo yipak jak. ");
INSERT INTO mmo_vpl VALUES ("LK22_37","072_22_37","LUK","22","37","37","+ o 22:37 Ais 53:12; Luk 22:52*De sa naanêêl vu ham naambe Anutu-te vakasin sen sil kaavu be neep nambe, ‘Lasevin yi having hil sen dawiing va nipayaa-to,’ ond le nôôn jak vu sa, in Anutu-te vakasin pin sen sil kaavu lak sa be neep-ato nôôn nalak.” ");
INSERT INTO mmo_vpl VALUES ("LK22_38","072_22_38","LUK","22","38","38","Tombe sil lanêêl vu Yesu nambe, “Omaaho Bop gangge, yipak yuuh nganjo.” Tombe Yesu nêêl nambe, “Lung.” ");
INSERT INTO mmo_vpl VALUES ("LK22_39","072_22_39","LUK","22","39","39","+ o 22:39 Luk 21:37; Jon 18:1*Lung atonde Yesu hato la be la kandu Oliv nambe sen yoo nala boyambôôy-ato, tombe maanggêêm-aso taamuyin yi. ");
INSERT INTO mmo_vpl VALUES ("LK22_40","072_22_40","LUK","22","40","40","Tombe tok la taaku sen la in nambe naa-to, tombe nêêl vu sil nambe, “Ham anohak in nambe palapin-ame naatovu ham e.” ");
INSERT INTO mmo_vpl VALUES ("LK22_41","072_22_41","LUK","22","41","41","Tombe hataah la diin lohvu hil gaate tatuuh na gato, tonde hatung kaatu be lohak vu Anutu nambe, ");
INSERT INTO mmo_vpl VALUES ("LK22_42","072_22_42","LUK","22","42","42","+ o 22:42 Mat 6:10*“O Aamangg, naambe gawiingin ond ganôôh kap nimeen-atêênjo vêêl in sa, lemu same naanêêl e, goo gate va.” ");
INSERT INTO mmo_vpl VALUES ("LK22_43","072_22_43","LUK","22","43","43","Tombe angela ti vu baandoni hato vu Yesu be kaandu yi. ");
INSERT INTO mmo_vpl VALUES ("LK22_44","072_22_44","LUK","22","44","44","Tombe lopayo nimeen lôôt-ambe monalohak niwêêk lôôt osin laasêêp laam-ambe tok la voon nambe sen nihees naviiy daang-ambe navu tatooy laa-to. ");
INSERT INTO mmo_vpl VALUES ("LK22_45","072_22_45","LUK","22","45","45","Lohak lung la de kandi be laah vu maanggêêm-aso, le yi de sil deep in londpayo nimeen, ");
INSERT INTO mmo_vpl VALUES ("LK22_46","072_22_46","LUK","22","46","46","om nêêl nambe, “Nambe vaati sen ham nahop? Ham kandi be ham anohak in nambe palapin-ame naatovu ham e.” ");
INSERT INTO mmo_vpl VALUES ("LK22_47","072_22_47","LUK","22","47","47","Yesu naahen monanêêl vakasin-anjo tonde maanggêêm nomaayuuh-ambe laam yuuh-anjôôto ti Yudas hako hil ngeeyaata be lato pavis. Tombe Yudas la ngaaho in nambe naamuuh Yesu gaambôôk, ");
INSERT INTO mmo_vpl VALUES ("LK22_48","072_22_48","LUK","22","48","48","tombe Yesu nêêl vu nambe, “Yudas, onamuuh Omaahonôôn Noow in nambe otaato yi langaah-ambe hil lanôôh a?” ");
INSERT INTO mmo_vpl VALUES ("LK22_49","072_22_49","LUK","22","49","49","+ o 22:49 Luk 22:36*Tombe hil sen daale having Yesuu-to layi nambe hil davu lanôôh yi, om lalingin nambe, “Omaaho Bop, hey nasap sil ak yipak a?” ");
INSERT INTO mmo_vpl VALUES ("LK22_50","072_22_50","LUK","22","50","50","Tombe maanggêêm-aso ti sap kul vaha sen datung salivangin-ato silate yêêv bop yite hil kul ti nanye vasa be yêêhin, ");
INSERT INTO mmo_vpl VALUES ("LK22_51","072_22_51","LUK","22","51","51","le Yesu nêêl nambe, “Ngaamong jip.” Tonde hambe nama lak nanye be nivasa lak laah. ");
INSERT INTO mmo_vpl VALUES ("LK22_52","072_22_52","LUK","22","52","52","+ o 22:52 Luk 22:37*Tonde yêêv-aso salivangin-ate osin ahevaavu sen danggin Anutu-te dumb bop-ato silate yêêv-aso, de hil bop-aso sen sil lalaam in lanôôh Yesuu-to, ond Yesu nêêl vu sil nambe, “Ham alaam in ham anôôh sa, lemu nambe vaati sen ham hako yipak ayuuh tapum sapa ham-ambe ham alaam nambe sen ham alaam vu omaaho hôôndak ti? ");
INSERT INTO mmo_vpl VALUES ("LK22_53","072_22_53","LUK","22","53","53","+ o 22:53 Jon 7:30; 8:20; Kol 1:13*Sa nando having ham hôôk Anutu-te dumb bop alo lak busin pin, le ma de ham-ame namam nalak sa le, lemu hamate busin sen ham anôôh saa-to osin busin sen mekanu-te niwêêk neep-ato ond gêên-anjo.” ");
INSERT INTO mmo_vpl VALUES ("LK22_54","072_22_54","LUK","22","54","54","+ o 22:54 Saam 31:11; Luk 22:33*Lalôôh Yesu be lako la be lalukala bayêên, yik kul vaha sen datung salivangin-ato silate yêêv bop-ate bayêên-anju, tonde Pita motaamuyin, le ma de yoo naale aheseseey daka. ");
INSERT INTO mmo_vpl VALUES ("LK22_55","072_22_55","LUK","22","55","55","Tombe hil vaalu lavaav kin hôôk bayêên talind lavuun tombe lato dandôô-ju, tombe Pita la hato nando having sil. ");
INSERT INTO mmo_vpl VALUES ("LK22_56","072_22_56","LUK","22","56","56","+ o 22:56 Sin 4:13*Tombe vêêh kul ti yi de Pita nando be kin natum ak mekaalus, tombe get lôôt-ambe nêêl nambe, “Omaahôô-ja navu sapa Yesuu-ju having.” ");
INSERT INTO mmo_vpl VALUES ("LK22_57","072_22_57","LUK","22","57","57","Le ma de Pita lak alu nambe, “Ma, sa doosin yi.” ");
INSERT INTO mmo_vpl VALUES ("LK22_58","072_22_58","LUK","22","58","58","Daka having atombe omaaho ango yi be nêêl nambe, “Hil sen davu taamuyin Yesuu-to ti hong-anja.” Le Pita nêêl nambe, “Hali, sak ma-o.” ");
INSERT INTO mmo_vpl VALUES ("LK22_59","072_22_59","LUK","22","59","59","Tombe taaku me ti la lung la, tombe omaaho ti nêêl niwêêk nambe, “Keen, hil-anjuuto ond silate omaaho tii-ja, in yi vu Galili having-ato.” ");
INSERT INTO mmo_vpl VALUES ("LK22_60","072_22_60","LUK","22","60","60","Le ma de Pita nêêl nambe, “Hali, sa doosin va sen onanêêl-anja.” Naahen monanêêl atonde kokalêêh su, ");
INSERT INTO mmo_vpl VALUES ("LK22_61","072_22_61","LUK","22","61","61","+ o 22:61 Luk 22:34*tombe Omaaho Bop hilin-ambe get Pita, tombe mem Pita ka vu Omaaho Bop-ate vakasin sen nêêl vu nambe, “Kokalêêh-ame naasu le de gale ganjak alum in sa balon yaal vêêl e.” ");
INSERT INTO mmo_vpl VALUES ("LK22_62","072_22_62","LUK","22","62","62","Tombe Pita hato la voon-ambe ka pasiv-ambe su lôôt. ");
INSERT INTO mmo_vpl VALUES ("LK22_63","072_22_63","LUK","22","63","63","Hil sen lalôôh Yesuu-to lanêêl yi pale be laveek yi, ");
INSERT INTO mmo_vpl VALUES ("LK22_64","072_22_64","LUK","22","64","64","tombe layum mekaalus-ande lanêêl vu nambe, “Onaanêêl omaaho ti sen yiis hong-ato langaah.” ");
INSERT INTO mmo_vpl VALUES ("LK22_65","072_22_65","LUK","22","65","65","Tonde lanêêl vakasin palesin ngeeyaata lak yi. ");
INSERT INTO mmo_vpl VALUES ("LK22_66","072_22_66","LUK","22","66","66","Langaah ak atombe Yuda-te kaansol-aso osin kul vaha sen datung salivangin-ato silate yêêv-aso de tanasin dangga-so lasupin e mem lako Yesu la vu sil, ");
INSERT INTO mmo_vpl VALUES ("LK22_67","072_22_67","LUK","22","67","67","+ o 22:67 Jon 10:24; 3:12; 8:45*be lanêêl nambe, “Naambe hong omaaho sen Anutu yoo holin hong vulôôt in nambe gandôôvu hey-ato ond onaanêêl vu hey.” Le Yesu nêêl vu sil nambe, “Sa naanêêl vu ham ond ham-ame le ambiing gaving e, ");
INSERT INTO mmo_vpl VALUES ("LK22_68","072_22_68","LUK","22","68","68","de naambe saanjingin vakasin vu ham ond ham-ame le naanêêl nom vu sa le. ");
INSERT INTO mmo_vpl VALUES ("LK22_69","072_22_69","LUK","22","69","69","+ o 22:69 Sin 7:56*Le gêên-anjo Omaahonôôn Noow navu mando Anutu niwêêk nama vasa.” ");
INSERT INTO mmo_vpl VALUES ("LK22_70","072_22_70","LUK","22","70","70","+ o 22:70 Luk 4:3,9*Tombe sil pin lalingin nambe, “Om Anutu Noow hong a?” Tombe nêêl vu sil nambe, “Ham anêêl-anja, yik saa-jo.” ");
INSERT INTO mmo_vpl VALUES ("LK22_71","072_22_71","LUK","22","71","71","Tombe lanêêl nambe, “Yiiy navu salo omaahonôôn in nambe daanêêl vaati gaving? Yiiy hango nambe nêêl Anutu palêê-jo.” ");
INSERT INTO mmo_vpl VALUES ("LK23_1","072_23_1","LUK","23","1","1","Tombe sil pin kandi lak-ambe lako Yesu la naale yêêv bop Lom ti me, yêêv-anju haale nambe Pilata. ");
INSERT INTO mmo_vpl VALUES ("LK23_2","072_23_2","LUK","23","2","2","+ o 23:2 Luk 20:25*Tombe lanêêl vakasin ak Yesu nambe, “Hey aatovu omaahôô-ja de naanjiihin heyate hil in nambe sil gavuuh heyate yêêv-aso na osin nanêêlin hey nambe hey-ame gaate taakis na vu yêêv bop Sisa le, tonde nanêêl nambe yi omaaho lulemak ti sen Anutu yoo holin yi vulôôt-ato.” ");
INSERT INTO mmo_vpl VALUES ("LK23_3","072_23_3","LUK","23","3","3","+ o 23:3 1Ti 6:13*Tombe Pilata lingin Yesu nambe, “Yuda-te omaaho lulemak hong a?” Tombe Yesu nêêl vu nambe, “Ganêêl-anja, yik saa-jo.” ");
INSERT INTO mmo_vpl VALUES ("LK23_4","072_23_4","LUK","23","4","4","Tombe Pilata nêêl vu kul vaha sen datung salivangin-ato silate yêêv-aso osin hil pin nambe, “Same aatovu omaahôô-jôôto yite vakasin ti le.” ");
INSERT INTO mmo_vpl VALUES ("LK23_5","072_23_5","LUK","23","5","5","Le sil lanêêl niwêêk nambe, “Yoo naanjiihin hil de navu taahu hil lohvu taaku Yudia pin, vu Galili be laam-anjo.” ");
INSERT INTO mmo_vpl VALUES ("LK23_6","072_23_6","LUK","23","6","6","Pilata hango silate vakasin atombe lingin nambe, “Om omaahôô-jo yi Galili ti mava?” ");
INSERT INTO mmo_vpl VALUES ("LK23_7","072_23_7","LUK","23","7","7","+ o 23:7 Luk 3:1*Tombe sil laliinggis, tombe mem Pilata lak ni nambe Yesu vu taaku Galili sen Lom-ate yêêv bop Helot nanggin-ato, om wiing Yesu la vu Helot, in yik Helot laam nando Yelusalem hôôk busin tii-ju. ");
INSERT INTO mmo_vpl VALUES ("LK23_8","072_23_8","LUK","23","8","8","+ o 23:8 Luk 9:9*Tombe Helot yi Yesu be pêêlis lôôt, in hango Yesu banye, om lak busin pin yoo wiingin nambe ji yi, in ka vu nambe mak le biing taahu taahu osin niwêêk ti be ji. ");
INSERT INTO mmo_vpl VALUES ("LK23_9","072_23_9","LUK","23","9","9","Om Helot lingin vakasin ngeeyaata vu Yesu, le ma de Yesu me-nêêl vakasin ti laah e. ");
INSERT INTO mmo_vpl VALUES ("LK23_10","072_23_10","LUK","23","10","10","Tombe kul vaha sen datung salivangin-ato silate yêêv-aso osin tanasin dangga-so daale daate vakasin lak Yesu niwêêk lôôt. ");
INSERT INTO mmo_vpl VALUES ("LK23_11","072_23_11","LUK","23","11","11","Tombe Helot osin yite hil ngaamong vaha-so lawiing nindanjeen vu Yesu osin lanêêl yi pale, tombe lalop tôômb amengali hôôk yi, le mem Helot wiing laah vu Pilata. ");
INSERT INTO mmo_vpl VALUES ("LK23_12","072_23_12","LUK","23","12","12","Tombe Helot ayuuh Pilata lawiing nipaapu vu yuuh hôôk busin tii-ju nivalok, nganjo munggin ond yuuh oo layi yuuh paya. ");
INSERT INTO mmo_vpl VALUES ("LK23_13","072_23_13","LUK","23","13","13","Tombe Pilata teey kul vaha sen datung salivangin-ato silate yêêv-aso osin yêêv bop-aso de hil pin-ambe lalaam, ");
INSERT INTO mmo_vpl VALUES ("LK23_14","072_23_14","LUK","23","14","14","tombe nêêl vu sil nambe, “Ham hako omaahôô-jo laam vu sa be ham anêêl nambe naanjiihin hil in nambe sil gavuuh silate yêêv-aso na. Tombe sa hango yite vakasin hôôk ham amem-anjo, le same aatovu yite nipaya ti lohvu ham anêêl vakasin ak yii-to le. ");
INSERT INTO mmo_vpl VALUES ("LK23_15","072_23_15","LUK","23","15","15","Tonde yik Helot having, me-tovu yite nipaya ti le, om wiing lom vu yiiy. Ham gangoyin, me-wiing va nipaya lohvu nambe jimb e, ");
INSERT INTO mmo_vpl VALUES ("LK23_16","072_23_16","LUK","23","16","16","om sa gaveek e mem sa naanêêl-ambe yoo na malis amu.” ");
INSERT INTO mmo_vpl VALUES ("LK23_17","072_23_17","LUK","23","17","17","Lohvu ta pin hôôk hil Yuda-te busin bop busin haluusin-ato, ond Pilata navu kavaayin kalaambus-aso ti be navu la malis vu sil. ");
INSERT INTO mmo_vpl VALUES ("LK23_18","072_23_18","LUK","23","18","18","Le sil pin lateey nambe, “Ganyiis omaahôô-ja be jimb, de okavaayin Balabas vu hey.” ");
INSERT INTO mmo_vpl VALUES ("LK23_19","072_23_19","LUK","23","19","19","Balabas-anju ond haanjiihin hil Yelusalem-ambe lawiing ngaamong vu gaaman osin yiis omaaho ti be yimb, ondeey latung lukala kalaambus. ");
INSERT INTO mmo_vpl VALUES ("LK23_20","072_23_20","LUK","23","20","20","Tombe Pilata wiingin nambe kavaayin Yesu, om teey la vu hil pin-anju yesin laah, ");
INSERT INTO mmo_vpl VALUES ("LK23_21","072_23_21","LUK","23","21","21","le ma de lateey laah nambe, “Ganyiis jak ana haah pako. Ganyiis jakana haah pako.” ");
INSERT INTO mmo_vpl VALUES ("LK23_22","072_23_22","LUK","23","22","22","Tombe Pilata nêêl tu balon yaal nambe, “In? Wiing vaati paya deey? Same aatovu yite nipaya ti lohvu nambe jimb e, om sa gaveek e mem sa naanêêl-ambe yoo na malis amu.” ");
INSERT INTO mmo_vpl VALUES ("LK23_23","072_23_23","LUK","23","23","23","Le ma de sil oo niwêêk-ambe lateey lavand bopaata nambe nyiis Yesu be jimb, tombe sil lavand savok Pilata ");
INSERT INTO mmo_vpl VALUES ("LK23_24","072_23_24","LUK","23","24","24","om liinggis nambe le biing nohvu sil lanêêl-ato. ");
INSERT INTO mmo_vpl VALUES ("LK23_25","072_23_25","LUK","23","25","25","Tombe omaaho sen latung lukala kalaambus in dangga nambe haanjiihin hil-ambe lawiing ngaamong vu gaaman osin yiis omaaho ti be yimb-ato, ond Pilata kavaayin-ambe la malis lohvu hil oo mondanêêl, de Yesu ond vu la in nambe jimb nohvu sil oo lawiingin-ato. ");
INSERT INTO mmo_vpl VALUES ("LK23_26","072_23_26","LUK","23","26","26","Hil Lom ngaamong vaha-so lako Yesu la, tombe hil Sailini ti haale nambe Simon vu kul-ambe hato, tombe lalôôh-ambe lavu haah pako vu be kava, tombe taamuyin Yesu be la. ");
INSERT INTO mmo_vpl VALUES ("LK23_27","072_23_27","LUK","23","27","27","Tombe hil ngeeyaata lôôt taamuyin Yesu be lala, osin vêêh ngeeyaata davu kaatuuh sil-ambe dasu in Yesu be dala. ");
INSERT INTO mmo_vpl VALUES ("LK23_28","072_23_28","LUK","23","28","28","Le Yesu hilin laah vu vêêh-aso be nêêl nambe, “Vêêh Yelusalem, ham-ame naasu in sa le, ham oo naasu in ham osin noom-aso. ");
INSERT INTO mmo_vpl VALUES ("LK23_29","072_23_29","LUK","23","29","29","+ o 23:29 Luk 21:23*In ham gangoyin, busin ti navu naatok naam atombe hil e daanêêl naambe, ‘Vêêh-aso sen daale muuh de me-lako noondin e, de me-lavu sum vu noondin e, ond sil akand vasa.’ ");
INSERT INTO mmo_vpl VALUES ("LK23_30","072_23_30","LUK","23","30","30","+ o 23:30 Hos 10:8; Taato 6:16*Tombe hil e daanêêl vu kandu naambe, ‘Ham anjumbin jakana hey baandoni be ham savun hey.’ ");
INSERT INTO mmo_vpl VALUES ("LK23_31","072_23_31","LUK","23","31","31","+ o 23:31 1Pi 4:17*In dawiing nambêênjo vu haah moos sa, om le lambiing naambe vaati vu ham haah bambusin-ato?” ");
INSERT INTO mmo_vpl VALUES ("LK23_32","072_23_32","LUK","23","32","32","Tonde omaaho yuuh, yik yuuh lawiing va nipayaa-to, ond lako yuuh-ambe lala in nambe lanyiis yuuh-ambe yuuh lanjimb gaving Yesu. ");
INSERT INTO mmo_vpl VALUES ("LK23_33","072_23_33","LUK","23","33","33","Latok lala taaku sen danêêl nambe Taaku Lukook atombe layiis Yesu lakala haah pako vu taakuu-ju. Tombe layiis omaaho yuuh-anju daale having Yesu, ango naale nama vasa, de ango naale nama kêênj. ");
INSERT INTO mmo_vpl VALUES ("LK23_34","072_23_34","LUK","23","34","34","+ o 23:34 Ais 53:12; Mat 5:44; Sin 7:60; Saam 22:18*Tombe Yesu lohak nambe, “O Aamangg, okawiiy hil-anjote nipayaa-jo na, in va sen dawiing-anjo ond sil doosin dangga.” Tombe hil ngaamong vaha-so laate tatuuh-ambe tambe lak Yesu-te lolop-ande latiiy lohvu sil. ");
INSERT INTO mmo_vpl VALUES ("LK23_35","072_23_35","LUK","23","35","35","+ o 23:35 Saam 22:7-8*Tombe hil daale mondangget, de yêêv bop-aso lanêêl Yesu pale nambe, “Hôôvu hil vaalu, om naambe Anutu yoo holin yi vulôôt-ato keen ond yoo dôôvu yi.” ");
INSERT INTO mmo_vpl VALUES ("LK23_36","072_23_36","LUK","23","36","36","+ o 23:36 Saam 69:21*Tonde yik hil ngaamong vaha-so pale Yesu having, de lako bel anikalin la vu ");
INSERT INTO mmo_vpl VALUES ("LK23_37","072_23_37","LUK","23","37","37","be lanêêl vu nambe, “Naambe Yuda-te omaaho lulemak hong ond goo gandôôvu hong.” ");
INSERT INTO mmo_vpl VALUES ("LK23_38","072_23_38","LUK","23","38","38","Tombe vakasin ti sil kaavu be neep ak haah pako lu baandoni nambe, “Yuda-te Omaaho Lulemak-anjo.” ");
INSERT INTO mmo_vpl VALUES ("LK23_39","072_23_39","LUK","23","39","39","Tombe omaaho nipaya yuuh-anju sen layiis yuuh having Yesuu-to, ango nêêl Yesu pale nambe, “Hong omaaho sen Anutu yoo holin hong vulôôt-ato keen a? Om goo gandôôvu hong-ande gandôôvu haay gaving.” ");
INSERT INTO mmo_vpl VALUES ("LK23_40","072_23_40","LUK","23","40","40","Le ango nêêl yi nambe, “Game nayêênin Anutu le? Hoow hako nivaane timu nambe sen Yesu hakôô-jo, ");
INSERT INTO mmo_vpl VALUES ("LK23_41","072_23_41","LUK","23","41","41","tonde hoow ond lohvu in hoow hako lukalaah hoow oote nipaya, nganjo omaahôô-jo ond me-wiing vati paya le.” ");
INSERT INTO mmo_vpl VALUES ("LK23_42","072_23_42","LUK","23","42","42","+ o 23:42 Mat 16:28*Tonde nêêl vu Yesu nambe, “Yesu, sen ganom naambe omaaho lulemak in ganggin gate hil-ato ond gakam bu sa.” ");
INSERT INTO mmo_vpl VALUES ("LK23_43","072_23_43","LUK","23","43","43","Tombe Yesu nêêl vu nambe, “Sa naanêêl keen vu hong naambe peey-anjo onavu mando Paladis gaving sa.” ");
INSERT INTO mmo_vpl VALUES ("LK23_44","072_23_44","LUK","23","44","44","+ o 23:44 Emo 8:9*Tombe taaku mekaalus laam naale lavuun atombe taaku mekanu hôôk lohvu taaku pin-ambe laam soosin hôôk lohvu taaku me yaal. ");
INSERT INTO mmo_vpl VALUES ("LK23_45","072_23_45","LUK","23","45","45","+ o 23:45 Eks 26:31-33; 36:35*De taaku mekanu hôôk-anju tombe tôômb bopaata dinaandiin lôôt, yik tôômb-anju yakaluuh Anutu-te dumb vaambuung alopayôô-to, ond kweek la yuuh. ");
INSERT INTO mmo_vpl VALUES ("LK23_46","072_23_46","LUK","23","46","46","+ o 23:46 Saam 31:5; Sin 7:59*Tombe Yesu teey lava bopaata nambe, “Aamangg, saavu sa kanungg lukalaas onamam.” Nêêl lung la tonde mem yimb la. ");
INSERT INTO mmo_vpl VALUES ("LK23_47","072_23_47","LUK","23","47","47","Tombe hil Lom-ate yêêv ngaamong vaha ti yi va pin-anjo tombe hako Anutu haale lak nambe, “Keen, omaahôô-jo omaaho nivalok.” ");
INSERT INTO mmo_vpl VALUES ("LK23_48","072_23_48","LUK","23","48","48","+ o 23:48 Luk 18:13*Tombe hil pin sen sil lasupin lalaam in lanji vaa-jo ond layi tombe sil kaatuuh sil-ande lalaah baand. ");
INSERT INTO mmo_vpl VALUES ("LK23_49","072_23_49","LUK","23","49","49","+ o 23:49 Saam 38:11; 88:8; Luk 8:2-3*Tonde hil sen lalak Yesu ni osin vêêh sen sil davu sapa Yesu vu Galili be lalaam-ato, ond daale diin daka be mondayi va pin-anjo. ");
INSERT INTO mmo_vpl VALUES ("LK23_50","072_23_50","LUK","23","50","50","Tombe kaansol ti haale nambe Yusep, ond yi omaaho nivalok osin nivasa. ");
INSERT INTO mmo_vpl VALUES ("LK23_51","072_23_51","LUK","23","51","51","+ o 23:51 Luk 2:25,38*Yusep-anju vu Yuda-te bayêên bop ti Alimatia, de yoo ka navu busin sen Anutu naam in ganggin yite hil-ato, ond me-liinggis in vakasin sen kaansol-aso vaalu lanjôôy osin va sen lawiing ak Yesuu-to le, malis. ");
INSERT INTO mmo_vpl VALUES ("LK23_52","072_23_52","LUK","23","52","52","Om Yusep-anju la vu yêêv bop Pilata be kataangg Yesu naavi vu, ");
INSERT INTO mmo_vpl VALUES ("LK23_53","072_23_53","LUK","23","53","53","le mem la lôôh Yesu naavi hato be vayum hôôk tôômb valôôy, tombe la hambe lukaneep hôôk lavandangga ti sen lasap bôôy, le me-lambe omaahonôôn ti lukaneep hôôk-ato le. ");
INSERT INTO mmo_vpl VALUES ("LK23_54","072_23_54","LUK","23","54","54","Busin tii-ju ond busin sen Yuda-so davu samu sil in davu lanji busin sawaasin. ");
INSERT INTO mmo_vpl VALUES ("LK23_55","072_23_55","LUK","23","55","55","+ o 23:55 Luk 23:49*Om vêêh-aso sen davu sapa Yesu vu Galili be lalaam-ato ond sil taamuyin Yusep-ambe lala layi lavandangga. Tonde layi taaku vuuti sen Yusep hambe Yesu naavi lukala neep hôôk-ato, ");
INSERT INTO mmo_vpl VALUES ("LK23_56","072_23_56","LUK","23","56","56","+ o 23:56 Eks 12:16; 20:10; Diu 5:14*le mem lalaah baand-ambe sil samu bel galovasa vasa yuuh ame. Tomem busin sawaasin atombe sil sawaah lohvu tanasin nêêl-ato. ");
INSERT INTO mmo_vpl VALUES ("LK24_1","072_24_1","LUK","24","1","1","Sonda samiinaanôôn atombe vêêh-aso kandi pavis-ambe lako va galovasa sen sil samuu-to be lala lavandangga. ");
INSERT INTO mmo_vpl VALUES ("LK24_2","072_24_2","LUK","24","2","2","Lala lalup atombe layi de tatuuh bop tatolin la in lavandangga avi lung la, ");
INSERT INTO mmo_vpl VALUES ("LK24_3","072_24_3","LUK","24","3","3","om sil lalukala lavandangga le layi de Omaaho Bop Yesu naavi me-neep e. ");
INSERT INTO mmo_vpl VALUES ("LK24_4","072_24_4","LUK","24","4","4","+ o 24:4 Sin 1:10*Tombe sil oo daahen kand monavu vaa-jo lôôt atonde omaaho yuuh lato daale having vêêh-aso pavis ond yuuhate tôômb têêlang, ");
INSERT INTO mmo_vpl VALUES ("LK24_5","072_24_5","LUK","24","5","5","+ o 24:5 Luk 2:9*tombe vêêh-aso layêênin lôôt-ambe lavun mend kaalus la kambini. Tombe yuuh lanêêl vu sil nambe, “Nambe vaati sen ham navu salo omaaho metumin hôôk hil yimbin-ate taakuu-jo? ");
INSERT INTO mmo_vpl VALUES ("LK24_6","072_24_6","LUK","24","6","6","Me-neep-anjo le, kandi lak-ambe la gêên. Ham akam bu vakasin sen naahen nando Galili de nêêl vu ham-ato le. ");
INSERT INTO mmo_vpl VALUES ("LK24_7","072_24_7","LUK","24","7","7","+ o 24:7 Luk 9:22; 17:25*Nambe le lambu Omaahonôôn Noow dukana hil anipaya namand, tombe lanyiis ak haah pako be jimb, le mem busin naatu yaal atombe kandi jak naah.” ");
INSERT INTO mmo_vpl VALUES ("LK24_8","072_24_8","LUK","24","8","8","Tombe mem vêêh-aso kand vu Yesu-te vakasin-anju, ");
INSERT INTO mmo_vpl VALUES ("LK24_9","072_24_9","LUK","24","9","9","tombe sil vu lavandangga be lalaah-ambe latulin vakasin pin-anjo vu maanggêêm nomaayuuh-ambe laam tii-to, de vu Yesu-te hil vaalu pin. ");
INSERT INTO mmo_vpl VALUES ("LK24_10","072_24_10","LUK","24","10","10","+ o 24:10 Luk 8:2-3*Vêêh-asôônju ond Malia Magadala yuuh Joana, de Malia sen Jems tangganaan-ato, tonde vêêh vaalu laving yaal, ond sil-anjo sen sil lanêêl vaa-ju vu sinaale-so, ");
INSERT INTO mmo_vpl VALUES ("LK24_11","072_24_11","LUK","24","11","11","lemu sinaale-so kand vu nambe lanêêl vakasin malis amu, om me-lawii-having sil lavand e. ");
INSERT INTO mmo_vpl VALUES ("LK24_12","072_24_12","LUK","24","12","12","Le ma de Pita kandi be hatup-ambe la kakôôhin lavandangga lopayo, le yi de tôômb malis amu nando, tombe laah baan-ambe ka vu lôôt nambe mak vaati wiing. ");
INSERT INTO mmo_vpl VALUES ("LK24_13","072_24_13","LUK","24","13","13","Tombe hôôk busin tii-ju Yesu-te omaaho yuuh vu Yelusalem-ambe lala in lana bayêên ti haale nambe Emaus, nando diin lohvu 11 kilomita, ");
INSERT INTO mmo_vpl VALUES ("LK24_14","072_24_14","LUK","24","14","14","de yuuh oo mondakaas ak Yesu-te vakasin pin-ato. ");
INSERT INTO mmo_vpl VALUES ("LK24_15","072_24_15","LUK","24","15","15","+ o 24:15 Mat 18:20*Yuuh mondakaas atombe Yesu hato vu yuuh-ambe yaal mondala, ");
INSERT INTO mmo_vpl VALUES ("LK24_16","072_24_16","LUK","24","16","16","tombe yuuh layi le yuuh-ame lalohvu nambe lanjak Yesu ni le. ");
INSERT INTO mmo_vpl VALUES ("LK24_17","072_24_17","LUK","24","17","17","Tombe Yesu nêêl vu yuuh nambe, “Muuh oo monakaas in vakasin vaati de muuh nala?” Tombe yuuh daale osin yuuh akand pasiv, ");
INSERT INTO mmo_vpl VALUES ("LK24_18","072_24_18","LUK","24","18","18","om ango haale nambe Kleopas nêêl laah vu nambe, “Ham vaatêêvak sen ham alaam nando Yelusalem-ato ond hong timu ondoosin va sen lawiing vu Yelusalem vasêên daka be tok lam gêên-anjôôto?” ");
INSERT INTO mmo_vpl VALUES ("LK24_19","072_24_19","LUK","24","19","19","+ o 24:19 Mat 21:11*Tombe Yesu lingin yuuh nambe, “Om lawiing vaaheey?” Tombe yuuh lanêêl vu nambe, “Va sen lak Yesu Nasaalet-ato, in yi omaaho ti sen nanêêl Anutu-te vakasin langaah-ato, tonde Anutu osin omaahonôôn pin layi nambe yoo nawiing va osin niwêêk de nanêêl vakasin aniwêêk, ");
INSERT INTO mmo_vpl VALUES ("LK24_20","072_24_20","LUK","24","20","20","le heyate kul vaha sen datung salivangin-ato silate yêêv-aso osin yêêv bop-aso lavu lukala Pilata nama in nambe naanêêl naambe jimb, om nêêl-ambe layiis ak haah pako be yimb. ");
INSERT INTO mmo_vpl VALUES ("LK24_21","072_24_21","LUK","24","21","21","+ o 24:21 Luk 1:68; 2:38; 19:11; Sin 1:6*Lemu hey hatung mengg in nambe yi omaaho sen navu nôôh Islel vêêl in va nimeen ayuuh amêê-to. Ke, tonde va ango having nambe busin tu yaal gêên ");
INSERT INTO mmo_vpl VALUES ("LK24_22","072_24_22","LUK","24","22","22","+ o 24:22 Luk 24:1-11*tonde heyate vêêh vaalu lanêêl vakasin ti, tombe hey akangg nala ngeey lôôt. In sil lala lavandangga gêên samiinaanôôn, ");
INSERT INTO mmo_vpl VALUES ("LK24_23","072_24_23","LUK","24","23","23","le layi de ninaavi me-neep e, tombe yik lalom-ambe lanêêl vu hey nambe layi angela-so dando langaah vu sil, be lanêêl nambe Yesu nando metumin. ");
INSERT INTO mmo_vpl VALUES ("LK24_24","072_24_24","LUK","24","24","24","+ o 24:24 Jon 20:3-10*Tombe yik heyate hil vaalu lala lavandangga be layi lohvu vêêh-aso lanêêl, le me-layi Yesu le.” ");
INSERT INTO mmo_vpl VALUES ("LK24_25","072_24_25","LUK","24","25","25","+ o 24:25 Luk 24:44*Tombe Yesu nêêl vu yuuh nambe, “De malumkook-ame nawiing kul e? Mame awii-having vakasin pin sen Anutu-te hil lanêêl langaah bôôy-ato le. ");
INSERT INTO mmo_vpl VALUES ("LK24_26","072_24_26","LUK","24","26","26","+ o 24:26 Luk 9:22; Sin 3:13; 17:3; Jon 13:31*Omaaho sen Anutu yoo holin yi vulôôt-ato ond yite mop neep nambe gako nivaane vêêl-ambe jimb e mem Anutu gako yi jak.” ");
INSERT INTO mmo_vpl VALUES ("LK24_27","072_24_27","LUK","24","27","27","+ o 24:27 Diu 18:15; Saam 22:1-21; Ais 53*Tonde Yesu hako vakasin lak hôôk Mose-te vakasin osin hil sen danêêl Anutu-te vakasin langaah-ato silate vakasin, le mem tatekin vakasin pin sen nalak yi be neep hôôk Anutu-te kaapiyaa-to dangga langaah vu yuuh. ");
INSERT INTO mmo_vpl VALUES ("LK24_28","072_24_28","LUK","24","28","28","Yaal lala lato ngaaho vu bayêên sen yuuh lala in nambe lanaa-to, tombe Yesu wiing in nambe na, ");
INSERT INTO mmo_vpl VALUES ("LK24_29","072_24_29","LUK","24","29","29","le ma de yuuh lanêêl lôôt nambe, “Ganaam mando gaving haay e, in soosin hôôk-ambe taaku navu naambus na.” Om Yesu lukala bayêên in nambe mando gaving yuuh. ");
INSERT INTO mmo_vpl VALUES ("LK24_30","072_24_30","LUK","24","30","30","+ o 24:30 Luk 22:19*Yaal dando in nambe lanja vanôôn atombe Yesu lôôh vanôôn ak-ambe lohak, tombe hapok-ambe vu vu yuuh, ");
INSERT INTO mmo_vpl VALUES ("LK24_31","072_24_31","LUK","24","31","31","tombe mem yuuh layi Yesu be lalak ni, de pavis atombe la mema in yuuh. ");
INSERT INTO mmo_vpl VALUES ("LK24_32","072_24_32","LUK","24","32","32","Tombe yuuh oo lanêêl vu yuuh nambe, “Keen, vakaas having hoow vu mop-ande tatekin Anutu-te vakasin langaah atombe walonggpayo nivasa lak lôôt.” ");
INSERT INTO mmo_vpl VALUES ("LK24_33","072_24_33","LUK","24","33","33","Tombe yuuh kandi pavis-ambe yuuh lalaah Yelusalem, tombe yuuh latovu maanggêêm nomaayuuh-ambe laam ti lasupin sil having hil vaalu, ");
INSERT INTO mmo_vpl VALUES ("LK24_34","072_24_34","LUK","24","34","34","+ o 24:34 1Ko 15:4-5*tombe sil lanêêl vu yuuh nambe, “Omaaho Bop kandi keen-ambe taato yi vu Simon.” ");
INSERT INTO mmo_vpl VALUES ("LK24_35","072_24_35","LUK","24","35","35","Tonde mem yuuh latulin va sen Yesu hato vakaas vu yuuh vu mop osin vu vanôôn vu yuuh-ambe yuuh lalak nii-to. ");
INSERT INTO mmo_vpl VALUES ("LK24_36","072_24_36","LUK","24","36","36","+ o 24:36 1Ko 15:5*Daahen danêêl vakasin-anjo tonde Yesu yoo hato naale hôôk sil lavuun, tombe nêêl vu sil nambe, “Ham alompayo nanjip melaas.” ");
INSERT INTO mmo_vpl VALUES ("LK24_37","072_24_37","LUK","24","37","37","+ o 24:37 Mat 14:26*Le ma de sil lavindis lôôt de layêênin, tombe kand vu nambe mak layi mamu ti. ");
INSERT INTO mmo_vpl VALUES ("LK24_38","072_24_38","LUK","24","38","38","Tombe Yesu nêêl vu sil nambe, “Ham naham nalak in? De nambe vaati sen ham akam yu-yuuh? ");
INSERT INTO mmo_vpl VALUES ("LK24_39","072_24_39","LUK","24","39","39","Sa keen-anjo. Ham angge sa namangg ayuuh sa vahangg nganjo. Ham palaah sa be ham angge le, in mamu ond laaliip osin kook ma, nganjo sak ham nahe nambe sa laaliip osin sa kook nando.” ");
INSERT INTO mmo_vpl VALUES ("LK24_40","072_24_40","LUK","24","40","40","Nêêl vakasin-anjo le mem taato nama osin vaha vu sil. ");
INSERT INTO mmo_vpl VALUES ("LK24_41","072_24_41","LUK","24","41","41","+ o 24:41 Jon 21:5*Tombe sil lapêêlis lôôt, le melawii-having pavis e, kand yu-yuuh lôôt, om Yesu lingin sil nambe, “Vanôôn daka nando?” ");
INSERT INTO mmo_vpl VALUES ("LK24_42","072_24_42","LUK","24","42","42","Tombe lavu paahuung vasisin ti vu, ");
INSERT INTO mmo_vpl VALUES ("LK24_43","072_24_43","LUK","24","43","43","tombe hako be ya hôôk sil amend, ");
INSERT INTO mmo_vpl VALUES ("LK24_44","072_24_44","LUK","24","44","44","+ o 24:44 Luk 18:31; 24:27*le mem nêêl vu sil nambe, “Bôôy sen sa naahen nando having ham-ato, ond saanêêl vu ham nambe vakasin pin sen sil kaavu lak sa be neep hôôk Mose-te tanasin, de neep hôôk Anutu-te vakasin sen hil danêêl langaah bôôy-ato, de neep hôôk kaapiya Saam having-ato, ond le nôôn jak, om nôôn ak-anjo.” ");
INSERT INTO mmo_vpl VALUES ("LK24_45","072_24_45","LUK","24","45","45","Tombe mem Yesu wiing-ambe sil lalak Anutu-te vakasin dangga ni. ");
INSERT INTO mmo_vpl VALUES ("LK24_46","072_24_46","LUK","24","46","46","+ o 24:46 Ais 53; Hos 6:2*Tonde nêêl vu sil nambe, “Anutu-te vakasin neep hôôk kaapiya nambe omaaho sen Anutu yoo holin yi vulôôt-ato ond le gako nivaane be jimb, tombe busin naatu yaal e mem kandi jak vu hil yimbin-ate, ");
INSERT INTO mmo_vpl VALUES ("LK24_47","072_24_47","LUK","24","47","47","+ o 24:47 1Ti 3:16*tombe mem hil e daanêêl na nohvu hil taaku pin, ond le daanêêl jak Kalisi haale naambe sil langgilin londpayo be Anutu kawiiy silate nipaya na, ond le daanêêl vu Yelusalem vêêl e. ");
INSERT INTO mmo_vpl VALUES ("LK24_48","072_24_48","LUK","24","48","48","+ o 24:48 Jon 15:27; Sin 1:8*“Ham ahe va pin-anjo om ham naanêêl langaah. ");
INSERT INTO mmo_vpl VALUES ("LK24_49","072_24_49","LUK","24","49","49","+ o 24:49 Jon 14:16; 15:26; 16:7; Sin 1:4*De ham gango le, va sen Aamangg jôôy vakasin lung la nambe le bu vu ham-ato, ond sa navu aambiing-ambe jakanaas ham, om ham oo mando bayêên bop-anjo vêêl-ambe niwêêk vu baandoni jakanaas ham e mem.” ");
INSERT INTO mmo_vpl VALUES ("LK24_50","072_24_50","LUK","24","50","50","Tombe Yesu hako sil lala Betaani, tombe valaah nama lak-ambe lohak sil. ");
INSERT INTO mmo_vpl VALUES ("LK24_51","072_24_51","LUK","24","51","51","Naahen monalohak sil atonde havuuh sil-ande lakala baandoni. ");
INSERT INTO mmo_vpl VALUES ("LK24_52","072_24_52","LUK","24","52","52","+ o 24:52 Jon 14:28; 16:22*Tombe sil latung kaatu vu Yesu le mem lalaah Yelusalem osin londpayo nivasa lôôt. ");
INSERT INTO mmo_vpl VALUES ("LK24_53","072_24_53","LUK","24","53","53","Tombe sil oo dando hôôk Anutu-te dumb bop alo be mondapêêlis vu Anutu nalak busin pin. ");
INSERT INTO mmo_vpl VALUES ("JN1_1","073_1_1","JHN","1","1","1","+ o 1:1 Jon 17:5; 1Jon 1:1-2; Taato 19:13*Vu nyendoos ond Vakasin oo nando. Vakasin oo nando having Anutu, de Vakasin-anju ond yi Anutu. ");
INSERT INTO mmo_vpl VALUES ("JN1_2","073_1_2","JHN","1","2","2","Vu nyendoos Vakasin-anju yoo nando having Anutu, ");
INSERT INTO mmo_vpl VALUES ("JN1_3","073_1_3","JHN","1","3","3","+ o 1:3 1Ko 8:6; Kol 1:16-17; Hiblu 1:2*tombe Vakasin-anju yoo hatung va pin de ti me-yoo laam vu mopaatôôv ango le, malis, va pin sen nandôô-jo ond Vakasin timu yoo hatung. ");
INSERT INTO mmo_vpl VALUES ("JN1_4","073_1_4","JHN","1","4","4","+ o 1:4 Jon 5:26*Vakasin-anju metumin danggakook neep vu yi, de metumin-anju ond tu kin tumin in nambe taato mop vu omaahonôôn. ");
INSERT INTO mmo_vpl VALUES ("JN1_5","073_1_5","JHN","1","5","5","+ o 1:5 Jon 3:19*Tombe kin tumin-anju natum hôôk mekanu lopayo, le mekanu me-vayum yi le. ");
INSERT INTO mmo_vpl VALUES ("JN1_6","073_1_6","JHN","1","6","6","+ o 1:6 Mat 3:1; Luk 1:13-17,76; 3:2*Tonde Anutu wiing omaaho ti laam, haale nambe Jon, ");
INSERT INTO mmo_vpl VALUES ("JN1_7","073_1_7","JHN","1","7","7","ond laam in naanêêl vakasin langaah jak kin tumin-anju, in hil pin gango be lambiing gaving. ");
INSERT INTO mmo_vpl VALUES ("JN1_8","073_1_8","JHN","1","8","8","+ o 1:8 Jon 1:20*Jon-anju yime kin tumin e, malis, yik yoo laam in nambe naanêêl vakasin langaah jak kin tumin-anjuuto. ");
INSERT INTO mmo_vpl VALUES ("JN1_9","073_1_9","JHN","1","9","9","+ o 1:9 Jon 8:12; 1Jon 2:8*De kin tumin keen sen lukalaam voon-anjôôto ond navu melangaah vu omaahonôôn pin. ");
INSERT INTO mmo_vpl VALUES ("JN1_10","073_1_10","JHN","1","10","10","+ o 1:10 Jon 1:3; 17:25; Kol 1:16*Yoo hatung ngaanggis tonde lukalaam nando voon-anjo, le hil vu voon-anjo me-lalak ni le. ");
INSERT INTO mmo_vpl VALUES ("JN1_11","073_1_11","JHN","1","11","11","Tonde laam vu yite va-so, lemu yite hil-ame lako yi lak e, ");
INSERT INTO mmo_vpl VALUES ("JN1_12","073_1_12","JHN","1","12","12","+ o 1:12 Gal 3:26*de hil sen lako yi lak-ambe londpayo la timu vu yii-to ond liinggis in sil nambe lalohvu daatu Anutu noondin. ");
INSERT INTO mmo_vpl VALUES ("JN1_13","073_1_13","JHN","1","13","13","+ o 1:13 Jon 3:3-6; Jem 1:18; 1Pi 1:23*Lemu sil latu Anutu noondin ond dangga me-neep vu maandin ayuuh taandin nind hees e, de dangga me-neep vu omaahonôôn oo kand navu le, osin dangga me-neep vu va sen omaahonôôn oo dawiingin-ato le, malis, yik Anutu yoo wiing-ambe latu yite noondin. ");
INSERT INTO mmo_vpl VALUES ("JN1_14","073_1_14","JHN","1","14","14","+ o 1:14 Gal 4:4; Pil 2:7; Hiblu 2:14; Ais 60:1-2; Luk 9:32; Jon 2:11*Tonde Vakasin-anju ond tu omaahonôôn-ambe laam nando hôôk yiiy lavuun, tombe hey aahe yite nikaapulis lôôt in Mangganaan-ate Noow nôôn timuu-ju, tonde samu samu osin vakasin keen pup hôôk lopayo. ");
INSERT INTO mmo_vpl VALUES ("JN1_15","073_1_15","JHN","1","15","15","+ o 1:15 Jon 1:27,30; Mat 3:11*Tombe Jon nêêl vakasin ak yi be teey nambe, “Omaahôô-ja sen saanêêl bôôy nambe ‘Omaaho sen taamuyin saa-to ond savok sa, in yoo nando munggin-ande sak taaku malis.’” ");
INSERT INTO mmo_vpl VALUES ("JN1_16","073_1_16","JHN","1","16","16","+ o 1:16 Kol 2:10*Tombe yoo tu samu samu danggakook, om yoo navu samu yiiy pin balon balon lak va nivasa vasa. ");
INSERT INTO mmo_vpl VALUES ("JN1_17","073_1_17","JHN","1","17","17","+ o 1:17 Eks 34:28; Lom 6:14; 10:4*De Mose vu Anutu-te tanasin vu yiiy, lemu samu samu osin vakasin keen ond Yesu Kalisi hako laam. ");
INSERT INTO mmo_vpl VALUES ("JN1_18","073_1_18","JHN","1","18","18","+ o 1:18 Eks 33:20; Jon 6:46; 1Ti 6:16; 1Jon 4:12; Mat 11:27*Tonde Anutu ond omaaho ti me-yi me lak yi le, malis lôôt, yik Noow timuu-ju yoo nando hôôk Mangganaan baambu, ondeey navu tatekin Mangganaan danggakook vu yiiy. ");
INSERT INTO mmo_vpl VALUES ("JN1_19","073_1_19","JHN","1","19","19","De hil Yuda lawiing kul vaha sen datung salivangin-ato vaalu de Liwi-te hil moos vaalu vu Yelusalem-ambe lato, be lalingin Jon nambe, “Hong omaaho lati?” ");
INSERT INTO mmo_vpl VALUES ("JN1_20","073_1_20","JHN","1","20","20","+ o 1:20 Jon 3:28*Tombe Jon nêêl yite dangga langaah vu sil, ond me-vun vakasin e, nganjo nêêl nambe, “Same omaaho sen Anutu yoo holin yi vulôôt in nambe dôôvu yiiy-ato le.” ");
INSERT INTO mmo_vpl VALUES ("JN1_21","073_1_21","JHN","1","21","21","+ o 1:21 Mat 11:14; Diu 18:15,18; Jon 6:14; 7:40; Sin 3:22*Tonde lalingin yi laah nambe, “Om hong omaaho lati? Hong Eliya, me?” Le nêêl nambe, “Malis.” Tombe lanêêl nambe, “Om mak hong Anutu-te omaaho ti sen hey nanggin yii-to?” Le nêêl laah nambe, “Ma.” ");
INSERT INTO mmo_vpl VALUES ("JN1_22","073_1_22","JHN","1","22","22","Tombe lalingin laah nambe, “Om hong lati? Hey e naanêêl vaati vu hil sen lawiing hey alaam-ato, om goo tatekin gate dangga vu hey e.” ");
INSERT INTO mmo_vpl VALUES ("JN1_23","073_1_23","JHN","1","23","23","+ o 1:23 Ais 40:3*Tombe Jon nêêl nambe, “De Yesaia nêêl bôôy-ato nambe, ‘Omaaho ti nateey vu taaku lumbalaamb nambe, “Ham samu Omaaho Bop-ate mop nanjip nivalok,” ’ ond yik saa-jo.” ");
INSERT INTO mmo_vpl VALUES ("JN1_24","073_1_24","JHN","1","24","24","Hil-anju ond Palisai lawiing sil lalaam, ");
INSERT INTO mmo_vpl VALUES ("JN1_25","073_1_25","JHN","1","25","25","+ o 1:25 Mat 21:25; Jon 1:33*ond lalingin yi nambe, “Game omaaho sen Anutu yoo holin yi vulôôt-ato le, de game Eliya le, de game Anutu-te omaaho sen hey nanggin yii-to le, le nambe tana sen onalipis hil-anja?” ");
INSERT INTO mmo_vpl VALUES ("JN1_26","073_1_26","JHN","1","26","26","Tombe Jon nêêl laah vu sil nambe, “Sa naalipis hil lak bel amu, de omaaho ti naale hôôk ham lavuun-anja le ham doosin yi. ");
INSERT INTO mmo_vpl VALUES ("JN1_27","073_1_27","JHN","1","27","27","+ o 1:27 Jon 1:15; Sin 13:25*Omaahôô-ja navu taamuyin sa, de sak sa omaaho nipaya, same sa ningg vasa in nambe sa kavaayin yite suul osin saambiing kul vaalu naambe hil kul-aso dawiing vu silate yêêv-ato le.” ");
INSERT INTO mmo_vpl VALUES ("JN1_28","073_1_28","JHN","1","28","28","+ o 1:28 Mat 3:6; Jon 10:40*Vakasin-anjo sil mondakaas ak vu taaku Betaani, taakuu-ju neep bel Yoladan vaalu sen Jon nalipis hil neep-ato. ");
INSERT INTO mmo_vpl VALUES ("JN1_29","073_1_29","JHN","1","29","29","+ o 1:29 Jon 1:36; Ais 53:6-7; 1Pi 1:18-19*Tonde heendiiy atombe Jon yi de Yesu hato in naam vu yi, tombe Jon nêêl nambe, “Ke angge, Anutu-te bik sipsip noow sen navu kawiiy hil pin-ate nipayaa-to ond yik yii-ju. ");
INSERT INTO mmo_vpl VALUES ("JN1_30","073_1_30","JHN","1","30","30","+ o 1:30 Jon 1:15*Omaahôô-ju sen saanêêl bôôy nambe le taamuyin saa-to ond savok sa, in yoo nando munggin-ande sak taaku malis. ");
INSERT INTO mmo_vpl VALUES ("JN1_31","073_1_31","JHN","1","31","31","De yi ond same alak ni bôôy e, lemu sa laam naalipis hil lak bel in nambe yii-ju balup ond sa taato yi vu hil Islel.” ");
INSERT INTO mmo_vpl VALUES ("JN1_32","073_1_32","JHN","1","32","32","+ o 1:32 Mat 3:16*Tonde Jon nêêl langaah nambe, “Saahe Vavi Vaambuung vu baandoni be laam voon lohvu manak tumbaliiy, tombe lakala nando lak yi. ");
INSERT INTO mmo_vpl VALUES ("JN1_33","073_1_33","JHN","1","33","33","+ o 1:33 Luk 3:2-3*De same alak ni bôôy e, lemu yi sen wiing-ambe sa laam in saanjipis hil-ato ond nêêl vu sa nambe, ‘Gangge naambe Vavi Vaambuung dukanaam-ambe jakana mando jak omaaho ti, ond omaahôô-ja le biing-ambe hil anind vasa jak Vavi Vaambuung-ate niwêêk.’ ");
INSERT INTO mmo_vpl VALUES ("JN1_34","073_1_34","JHN","1","34","34","+ o 1:34 Mat 3:17; 17:5; 27:54*Tombe saahe yi ondeey soo aanêêl yi langaah lung la nambe omaahôô-ju Anutu Noow.” ");
INSERT INTO mmo_vpl VALUES ("JN1_35","073_1_35","JHN","1","35","35","Tombe yik heendiiy atombe Jon naale having yite maanggêêm yuuh, ");
INSERT INTO mmo_vpl VALUES ("JN1_36","073_1_36","JHN","1","36","36","+ o 1:36 Jon 1:29*tombe yi de Yesu valu-la, om nêêl nambe, “Ke angge, Anutu-te bik sipsip noow-anju.” ");
INSERT INTO mmo_vpl VALUES ("JN1_37","073_1_37","JHN","1","37","37","Maanggêêm ayuuh lango nêêl nambêênju tombe yuuh lala taamuyin Yesu. ");
INSERT INTO mmo_vpl VALUES ("JN1_38","073_1_38","JHN","1","38","38","Tombe Yesu hilin e yi de yuuh davu taamuyin yi, om lingin yuuh nambe, “Muuh navu salo va?” Tombe yuuh lanêêl vu nambe, “Labai, onahop hôôk bayêên ti tana?” Haale Labaii-jo yaanggilin naambe Kaputung. ");
INSERT INTO mmo_vpl VALUES ("JN1_39","073_1_39","JHN","1","39","39","Tombe nêêl vu yuuh nambe, “Manaam angge.” Tombe yuuh lala layi bayêên sen neep hôôk-ato, tombe yik yuuh dando having yi hôôk soosin lohvu taaku me yumbeyuuh-ambe bus la osin. ");
INSERT INTO mmo_vpl VALUES ("JN1_40","073_1_40","JHN","1","40","40","+ o 1:40 Mat 4:18-20*Tombe omaaho yuuh-anju sen yuuh lango Jon lava be yuuh lala taamuyin Yesuu-to, ond angok Endru sen Simon Pita halii-to, ");
INSERT INTO mmo_vpl VALUES ("JN1_41","073_1_41","JHN","1","41","41","+ o 1:41 1Sml 2:10; Saam 2:2; Jon 4:25*tombe la tovu hali Simon pavis-ambe nêêl vu nambe, “Haay aatovu Mesia lung la.” Yaanggilin haale Mesiaa-jo naambe omaaho sen Anutu yoo holin yi vulôôt in nambe dôôvu yiiy-ato. ");
INSERT INTO mmo_vpl VALUES ("JN1_42","073_1_42","JHN","1","42","42","+ o 1:42 Mat 16:18; Mak 3:16*Tonde Endru giiy Simon-ambe yuuh lala vu Yesu, tombe Yesu me la vu Simon atombe nêêl vu nambe, “Jon noow Simon, yale naanêêl ohaalem naambe Kepaas.” Haalêê-jo yaanggilin naambe Pita, danggakook nambe tatuuh. ");
INSERT INTO mmo_vpl VALUES ("JN1_43","073_1_43","JHN","1","43","43","+ o 1:43 Mat 8:22; Mak 2:14*Tonde heendiiy atombe Yesu la in nambe na Galili, tombe tovu Pilip be nêêl vu nambe, “Ganaam taamuyin sa.” ");
INSERT INTO mmo_vpl VALUES ("JN1_44","073_1_44","JHN","1","44","44","Pilip-anju having Endru yuuh Pita, ond yik yaal ambaand dangga dosin vu Betsaida. ");
INSERT INTO mmo_vpl VALUES ("JN1_45","073_1_45","JHN","1","45","45","+ o 1:45 Diu 18:18; Ais 7:14; 9:6; Jer 23:5; Esi 34:23*Tombe Pilip la tovu Naatanael-ambe nêêl vu nambe, “Omaaho sen bôôy Mose kaavu vakasin ak yi neep hôôk tanasin-ato, tonde yik hil sen danêêl Anutu-te vakasin langaah bôôy-ato ond sil kaavu vakasin ak yi having-ato, ond hey aatovu yi lung la. Yik Yusep noow Yesu vu Nasaalet.” ");
INSERT INTO mmo_vpl VALUES ("JN1_46","073_1_46","JHN","1","46","46","+ o 1:46 Jon 7:41,52*De Naatanael nêêl vu Pilip nambe, “Mak va nivasa vaati le balup vu Nasaalet?” Tombe Pilip nêêl nambe, “Ganaam e mem gangge.” ");
INSERT INTO mmo_vpl VALUES ("JN1_47","073_1_47","JHN","1","47","47","+ o 1:47 Saam 32:2*Tonde Yesu yi de Naatanael hato nalaam vu yi, tombe nêêl vakasin ak yi nambe, “Angge, Islel ti keen-anju, tatuhin ti me-neep hôôk lopayo le.” ");
INSERT INTO mmo_vpl VALUES ("JN1_48","073_1_48","JHN","1","48","48","Tombe Naatanael lingin nambe, “Galak sa ningg in gahe sa vu tana deey?” Le Yesu nêêl laah vu nambe, “Onaale hôôk haah bangguk dangga ond Pilip-ame teey hong e, tonde saahe hong vuu-ju.” ");
INSERT INTO mmo_vpl VALUES ("JN1_49","073_1_49","JHN","1","49","49","+ o 1:49 Mat 14:33; 16:16; 27:42; Mak 3:11; Jon 12:13*Tombe Naatanael nêêl laah vu nambe, “Kaputung, hong Anutu Noow. Islel-ate omaaho lulemak hong.” ");
INSERT INTO mmo_vpl VALUES ("JN1_50","073_1_50","JHN","1","50","50","Tombe Yesu nêêl laah vu nambe, “Saanêêl langaah vu hong nambe saahe de onaale hôôk haah bangguk danggaa-to ondeey galompayo wii-having a? Gale gangge va bopaata savok vaa-jo na.” ");
INSERT INTO mmo_vpl VALUES ("JN1_51","073_1_51","JHN","1","51","51","+ o 1:51 Jen 28:12*De Yesu nêêl vu having nambe, “Sa naanêêl keen lôôt vu ham naambe vu taamusin ham e angge baandoni gataahin-ambe Anutu-te angela lanjak-ambe lana baandoni, de landuus-ambe lanom vu Omaahonôôn Noow.” ");
INSERT INTO mmo_vpl VALUES ("JN2_1","073_2_1","JHN","2","1","1","+ o 2:1 Jon 1:43*Lung atonde busin tu yaal e mem omaaho ti hako vêêh vu Kena Galili, tombe Yesu tangganaan la nando having sil. ");
INSERT INTO mmo_vpl VALUES ("JN2_2","073_2_2","JHN","2","2","2","Tombe yik lateey Yesu osin yite maanggêêm-aso be lala dando having. ");
INSERT INTO mmo_vpl VALUES ("JN2_3","073_2_3","JHN","2","3","3","+ o 2:3 Jon 19:26*Tombe silate wain lung la, om Yesu tangganaan nêêl vu nambe, “Wain ma la.” ");
INSERT INTO mmo_vpl VALUES ("JN2_4","073_2_4","JHN","2","4","4","+ o 2:4 Jon 7:30; 8:20*Le Yesu nêêl vu nambe, “Ataak, game naanêêl vu sa le, soo sate va in sate busin yoo naahen.” ");
INSERT INTO mmo_vpl VALUES ("JN2_5","073_2_5","JHN","2","5","5","Tombe tangganaan nêêl vu hil kul vaha-so nambe, “Naanêêl vakasin ti vu ham ond ham oo taamuyin.” ");
INSERT INTO mmo_vpl VALUES ("JN2_6","073_2_6","JHN","2","6","6","+ o 2:6 Mak 7:3-4*Tombe silate denggambiing tatuuh bel-ate namaavaalu vindak ti nando in nambe hil lanjipis namand ayuuh ame nohvu Yuda-te gambum, ond denggambiing-anju bopaata lôôt lohvu sil kaasêêh bel baaket nomaayuuh-maayuuh dukana. ");
INSERT INTO mmo_vpl VALUES ("JN2_7","073_2_7","JHN","2","7","7","Om Yesu nêêl vu hil kul-asôônju nambe, “Ham ana kava bel-ambe ham kaasêêh dukana denggambiing-anja be naapup.” Tombe sil kava bel-ambe kaasêêh lukala denggambiing-ambe pup lôôt. ");
INSERT INTO mmo_vpl VALUES ("JN2_8","073_2_8","JHN","2","8","8","Tonde nêêl vu sil nambe, “Mem ham bayêên bel-anja be ham gako na vu omaaho sen tu vanôôn danggakook-ato.” Tombe sil layêên-ambe lako be lala. ");
INSERT INTO mmo_vpl VALUES ("JN2_9","073_2_9","JHN","2","9","9","Tombe vanôôn danggakook num-ambe hango le bel tu wain ak, lemu doosin nambe lako wain-anjo vu tana, le hil kul vaha-so sen sil layêên bel-anjo lalak ni. Om vanôôn danggakook-anju teey omaaho sen hako vêêh-ato laam, ");
INSERT INTO mmo_vpl VALUES ("JN2_10","073_2_10","JHN","2","10","10","tombe nêêl vu nambe, “Hil pin oo davu wain anivasa vu hil namunggin-ambe danum lôôt, le mem davu wain anipaya heey taamu, nganjo hong ond gavu teenin wain anivasa be gesaange dakaa-jo le mem gavu laam.” ");
INSERT INTO mmo_vpl VALUES ("JN2_11","073_2_11","JHN","2","11","11","+ o 2:11 Jon 1:14; 4:54; 11:40; Luk 9:32*Yesu wiing taahu taahu osin niwêêk-anjo nyendoos vu Kena Galili be taato yite nikaapulis vu sil, tombe yite maanggêêm-aso lawii-having yi. ");
INSERT INTO mmo_vpl VALUES ("JN2_12","073_2_12","JHN","2","12","12","+ o 2:12 Mat 4:13*Lung laa tonde Yesu yuuh tangganaan de halindin osin yite maanggêêm-aso be lala lato dando taaku Kapenaum busin heey. ");
INSERT INTO mmo_vpl VALUES ("JN2_13","073_2_13","JHN","2","13","13","+ o 2:13 Eks 12:1-27; Jon 6:4; 11:55*Ngaaho lak in hil Yuda lanji silate busin bop busin haluusin sen Anutu haluuh hil Islel hôôk vu Ijip bôôy-ato, om Yesu la valup Yelusalem. ");
INSERT INTO mmo_vpl VALUES ("JN2_14","073_2_14","JHN","2","14","14","Tombe lukala Anutu-te dumb bop alo le yi de hil daanggo bik sipsip osin kao yuuh manak tumbaliiy in nambe hil gatung naatu salivangin, tonde yi de hil davu Yuda osin Lom-ate mone nyevaha-vahaan hôôk yii-to dando having. ");
INSERT INTO mmo_vpl VALUES ("JN2_15","073_2_15","JHN","2","15","15","Om hako hees-ambe sêêy in nambe gaveek sil jak, tonde hatiiy hil-anju osin silate bik sipsip ayuuh kaôô-to pin ond hatiiy sil vu Anutu-te dumb bop alo be lala voon, tonde kaasêêh hil sen mondavu mone nyevaha-vahaan hôôk yii-to silate mone la, de pakepin tavol having. ");
INSERT INTO mmo_vpl VALUES ("JN2_16","073_2_16","JHN","2","16","16","+ o 2:16 Luk 2:49*Tonde nêêl vu hil sen daanggo tumbaliiy-ato nambe, “Ham gako vaa-ja na vêêl, de ham-ame ambiing Aamangg-ate bayêên-anjo naatu bayêên maaket e.” ");
INSERT INTO mmo_vpl VALUES ("JN2_17","073_2_17","JHN","2","17","17","+ o 2:17 Saam 69:9*Tombe yite maanggêêm-aso kand vu Anutu-te vakasin ti hil kaavu neep hôôk kaapiya bôôy-ato nambe, “Sa naawiing niwêêk lôôt in nambe gate bayêên mando nivasa.” ");
INSERT INTO mmo_vpl VALUES ("JN2_18","073_2_18","JHN","2","18","18","+ o 2:18 Mat 21:23*Lemu hil Yuda layi vaa-ju tombe lanêêl vu Yesu nambe, “Gambiing taahu taahu vaati in hey aangge be hey anjak ni naambe ohaalem neep ak kul nambêênja?” ");
INSERT INTO mmo_vpl VALUES ("JN2_19","073_2_19","JHN","2","19","19","+ o 2:19 Mat 26:61; 27:40; Sin 6:14*Tombe Yesu nêêl laah vu sil nambe, “Ham kawiiy dumb vaambuung-anjo na de sale andaav nohvu busin yaal jesin naah.” ");
INSERT INTO mmo_vpl VALUES ("JN2_20","073_2_20","JHN","2","20","20","Tombe hil Yuda lanêêl nambe, “Dumb vaambuung-anjo lahaav lohvu ta doo-yuuh-ambe namaavaalu vindak ti, de hong ond gale gandaav nohvu busin yaal amu?” ");
INSERT INTO mmo_vpl VALUES ("JN2_21","073_2_21","JHN","2","21","21","+ o 2:21 1Ko 6:19*Lemu Yesu nêêl vakasin ak dumb vaambuung-anju ond manyinju yoo nêêl ak ninaavi, ");
INSERT INTO mmo_vpl VALUES ("JN2_22","073_2_22","JHN","2","22","22","+ o 2:22 Luk 24:6-8; Jon 12:16; 14:26*om vu taamusin sen Anutu wiing-ambe Yesu kandi lak vu hil yimbin-atêêto ond Yesu-te maanggêêm-aso kand vu vakasin sen Yesu nêêl ak dumb-anjuuto laah, om lawii-having Anutu-te vakasin sen kaavu neep hôôk kaapiyaa-to osin vakasin sen Yesu yoo nêêl-ato nambe vakasin nôôn keen. ");
INSERT INTO mmo_vpl VALUES ("JN2_23","073_2_23","JHN","2","23","23","+ o 2:23 Jon 7:31*Yesu nando Yelusalem hôôk Yuda-te busin bop busin haluusin sen Anutu haluuh hil Islel hôôk vu Ijip bôôy-ato, tombe hil ngeeyaata layi de Yesu nawiing taahu taahu osin niwêêk-anju, tombe londpayo la timu vu yi. ");
INSERT INTO mmo_vpl VALUES ("JN2_24","073_2_24","JHN","2","24","24","Lemu Yesu me-nilaas vu sil e, in lak sil pin anind lung laa-to, ");
INSERT INTO mmo_vpl VALUES ("JN2_25","073_2_25","JHN","2","25","25","+ o 2:25 Mak 2:8*de me-doosin vati in nambe omaaho ti tatekin omaahonôôn danggakook vu yi daka le, malis, yoo lak omaahonôôn alondpayo ni lung la. ");
INSERT INTO mmo_vpl VALUES ("JN3_1","073_3_1","JHN","3","1","1","+ o 3:1 Jon 7:50; 19:39*De hil Yuda-te yêêv ti nando, haale nambe Nikotemus, yi Palisai ti, ");
INSERT INTO mmo_vpl VALUES ("JN3_2","073_3_2","JHN","3","2","2","+ o 3:2 Mat 22:16; Jon 9:16*ond omaahôô-ju la vu Yesu hôôk busin-ambe nêêl vu nambe, “Kaputung, hey alak ganim nambe hong kaputung sen Anutu wiing hong laam-ato. In nambe Anutu me-mando gaving omaaho ti le, ond me-lohvu nambe biing taahu taahu osin niwêêk naambe sen onawiing-anja le.” ");
INSERT INTO mmo_vpl VALUES ("JN3_3","073_3_3","JHN","3","3","3","+ o 3:3 Mat 18:3; 1Pi 1:23*Tombe Yesu nêêl laah vu yi nambe, “Sa naanêêl keen lôôt vu hong naambe omaaho ti me-naatu omaaho moos ti jesin naah e ond me-le mando gaving Anutu-te hil e.” ");
INSERT INTO mmo_vpl VALUES ("JN3_4","073_3_4","JHN","3","4","4","Le Nikotemus nêêl nambe, “Le omaaho ti tata lak le naatu omaaho moos ti naah naambe tana? Mak lohvu nambe dukanaah tangganaan baambu be tangganaan gako yi jesin naah mava?” ");
INSERT INTO mmo_vpl VALUES ("JN3_5","073_3_5","JHN","3","5","5","+ o 3:5 Esi 36:25-27; Tit 3:5*Tombe Yesu vu vêêl lava laah nambe, “Sa naanêêl keen lôôt vu hong naambe bel osin Vavi Vaambuung-ame gako omaahonôôn-ambe daatu moos e, ond sil-ame le mando gaving Anutu-te hil e. ");
INSERT INTO mmo_vpl VALUES ("JN3_6","073_3_6","JHN","3","6","6","+ o 3:6 Saam 51:5; Jon 1:13*Va sen naavi hako ond yoo naavi, tonde va sen Vavi Vaambuung hako ond manyinju Vavi Vaambuung nando having, ");
INSERT INTO mmo_vpl VALUES ("JN3_7","073_3_7","JHN","3","7","7","om game gambindis in saanêêl vu hong nambe ham naatu moos-ato le. ");
INSERT INTO mmo_vpl VALUES ("JN3_8","073_3_8","JHN","3","8","8","+ o 3:8 Ekl 11:5*De vavi yoo valu-have va be la osin ka, tombe ohangoyin daandun, lemu danggakook sen laam-ato de valup-ambe la tana ond ondoosin. De hil pin sen latu moos lak Vavi Vaambuung-ato ond yik nambêênja.” ");
INSERT INTO mmo_vpl VALUES ("JN3_9","073_3_9","JHN","3","9","9","Tombe Nikotemus nêêl laah vu nambe, “Vakasin-anja le nôôn jak naambe vaati?” ");
INSERT INTO mmo_vpl VALUES ("JN3_10","073_3_10","JHN","3","10","10","Tombe Yesu nêêl nambe, “Islel-ate kaputung ti hong, le ondoosin vaa-jo? ");
INSERT INTO mmo_vpl VALUES ("JN3_11","073_3_11","JHN","3","11","11","+ o 3:11 Jon 3:32; 8:26*Sa naanêêl keen lôôt vu hong naambe hey naanêêl va sen hey alak nii-to, de va sen hey aahe lung laa-to ond hey naanêêl langaah, lemu ham-ame awii-having heyate vakasin e. ");
INSERT INTO mmo_vpl VALUES ("JN3_12","073_3_12","JHN","3","12","12","+ o 3:12 Luk 22:67*De saanêêl vakasin ak va vu voon-anjo le ham-ame awii-having e, om naambe sa naanêêl vakasin ak va baandoni ond ham e ambiing gaving naambe vaati? ");
INSERT INTO mmo_vpl VALUES ("JN3_13","073_3_13","JHN","3","13","13","+ o 3:13 Pro 30:4; Lom 10:6*De omaaho ti me-lak-ambe la baandoni de lom e, yik Omaahonôôn Noow oo timu vu baandoni be lukalaam voon. ");
INSERT INTO mmo_vpl VALUES ("JN3_14","073_3_14","JHN","3","14","14","+ o 3:14 Nam 21:9; Jon 8:28; 12:32*Tonde vu bôôy ond Mose hasi nyêêy kanu ti lakala haah vu taaku lumbalaamb, tombe yik hil e gasi Omaahonôôn Noow jakana naambêênju, ");
INSERT INTO mmo_vpl VALUES ("JN3_15","073_3_15","JHN","3","15","15","+ o 3:15 Jon 20:31*in nambe hil pin sen londpayo na timu vu yii-to ond sil mando metumin danggata. ");
INSERT INTO mmo_vpl VALUES ("JN3_16","073_3_16","JHN","3","16","16","+ o 3:16 Lom 5:8; 8:32; 1Jon 4:9-10; Jon 3:36; 10:28*“In Anutu yoo ka pasiv lôôt in hil pin vu voon, om wiing Noow yoo nôôn timu laam in nambe hil pin sen londpayo na timu vu yii-to me-lana mend nama le, malis, sil oo mando metumin danggata. ");
INSERT INTO mmo_vpl VALUES ("JN3_17","073_3_17","JHN","3","17","17","+ o 3:17 Luk 19:10; Jon 5:22; 12:47; Sin 17:31*In Anutu me-wiing Noow laam voon in nambe bu nyevahaan dôôk omaahonôôn-ate nipaya le, malis, wiing yi laam in nambe dôôvu sil. ");
INSERT INTO mmo_vpl VALUES ("JN3_18","073_3_18","JHN","3","18","18","+ o 3:18 Jon 3:36; 5:24*Om hil sen londpayo la timu vu yii-to ond silanêênd vakasin ma, de hil sen londpayo me-la timu vu yii-to ond me-lalohvu nambe lambiing vakasin e, le daatovu nyevahaan-ambe lana mend nama, in londpayo me-la timu vu Anutu Noow nôôn timuu-ju le. ");
INSERT INTO mmo_vpl VALUES ("JN3_19","073_3_19","JHN","3","19","19","+ o 3:19 Jon 1:5,9; 8:12*De lana mend namaa-ju dangga nambe melangaah laam voon lung la, lemu hil lawiingin mekanu, de me-lawiingin melangaah e, in silate kul anipaya. ");
INSERT INTO mmo_vpl VALUES ("JN3_20","073_3_20","JHN","3","20","20","+ o 3:20 Ep 5:11-13*Tonde hil pin sen dawiing va nipayaa-to ond nind baya lôôt in melangaah, de me-dala vu le, in nambe le taato va sen dawiing-ato langaah. ");
INSERT INTO mmo_vpl VALUES ("JN3_21","073_3_21","JHN","3","21","21","Lemu hil sen yoo dawiing va nivalok-ato ond dalaam vu melangaah in nambe taato langaah naambe dawiing kul lak Anutu-te niwêêk.” ");
INSERT INTO mmo_vpl VALUES ("JN3_22","073_3_22","JHN","3","22","22","+ o 3:22 Jon 4:1-2*Lung laa tonde Yesu having yite maanggêêm-aso be lala taaku Yudia, tombe sil dandôô-ju le mem mondalipis hil nandôô-ju. ");
INSERT INTO mmo_vpl VALUES ("JN3_23","073_3_23","JHN","3","23","23","Tonde Jon oo monalipis hil vu Inon ngaaho vu Selim, in taakuu-ju bel ngeeyaata neep, om hil dala vu be nalipis sil, ");
INSERT INTO mmo_vpl VALUES ("JN3_24","073_3_24","JHN","3","24","24","+ o 3:24 Mat 4:12*in Helot-ame hatung Jon hôôk kalaambus e de yoo naahen. ");
INSERT INTO mmo_vpl VALUES ("JN3_25","073_3_25","JHN","3","25","25","Tonde Jon-ate maanggêêm-aso de Yuda ti be sil dakaas ak va sen hil dalipis in nambe Anutu ji sil anivasaa-to. ");
INSERT INTO mmo_vpl VALUES ("JN3_26","073_3_26","JHN","3","26","26","+ o 3:26 Jon 1:26-34*Om Jon-ate maanggêêm-aso lalaah lato vu Jon-ambe lanêêl vu nambe, “Kaputung, omaaho sen bôôy nando having hong vu bel Yoladan vaalung-anjuuto de ganêêl vakasin langaah ak yii-to, ond omaahôô-ju nalipis hil tombe hil pin dala vu yi.” ");
INSERT INTO mmo_vpl VALUES ("JN3_27","073_3_27","JHN","3","27","27","+ o 3:27 Jon 19:11; 1Ko 4:7; Hiblu 5:4*Tombe Jon nêêl laah vu sil nambe, “Naambe Anutu baandoni me-bu vati vu omaaho ti le, ond me-lohvu nambe gako le. ");
INSERT INTO mmo_vpl VALUES ("JN3_28","073_3_28","JHN","3","28","28","+ o 3:28 Jon 1:20,23; Mat 11:10*De ham oo hango vakasin sen saanêêl lung la bôôy-ato nambe, ‘Same omaaho sen Anutu yoo holin yi vulôôt in nambe dôôvu yiiy-ato le, nganjo Anutu yoo wiing sa laam munggin vu yi.’ ");
INSERT INTO mmo_vpl VALUES ("JN3_29","073_3_29","JHN","3","29","29","+ o 3:29 Mat 9:15*Omaaho ti nambe gako vêêh moos ond vêêh-anju tu moow-anju yoo timu vane, de yite omaaho ango sen nando having yi be nango lavaa-to ond yoo le naapêêlis lôôt, om nambêênja gêên sa longgpayo yoo nivasa lôôt in hil ngeeyaata dala vu Yesu, ");
INSERT INTO mmo_vpl VALUES ("JN3_30","073_3_30","JHN","3","30","30","tombe haale le naatu bopaata jak, de sa haalengg e naatu pasiv.” ");
INSERT INTO mmo_vpl VALUES ("JN3_31","073_3_31","JHN","3","31","31","+ o 3:31 Jon 8:23; 1Jon 4:5*Omaaho sen laam vu baandonii-to ond savok va pin, de omaaho sen yite danggakook neep vu voon ond yi vu voon, om nanêêl vakasin ak va voon-ate. Keen, omaaho sen laam vu baandonii-to ond savok va pin la, ");
INSERT INTO mmo_vpl VALUES ("JN3_32","073_3_32","JHN","3","32","32","+ o 3:32 Jon 3:11*de va sen yi me lak osin va sen hango lung laa-to ond yoo nanêêl langaah, lemu omaahonôôn-ame lawii-having yite vakasin e. ");
INSERT INTO mmo_vpl VALUES ("JN3_33","073_3_33","JHN","3","33","33","Tonde hil sen lawii-having yite vakasin-ato ond laliinggis nambe Anutu yi omaaho vakasin keen. ");
INSERT INTO mmo_vpl VALUES ("JN3_34","073_3_34","JHN","3","34","34","+ o 3:34 Jon 1:32; Sin 10:38*In omaaho sen Anutu wiing laam-ato ond nanêêl Anutu-te vakasin, in Anutu vu Vavi Vaambuung osin doos-ambe hôôvu yi. ");
INSERT INTO mmo_vpl VALUES ("JN3_35","073_3_35","JHN","3","35","35","+ o 3:35 Mat 11:27; Jon 5:20; 10:17*De Mangganaan oo ahe having Noow, tombe vu va pin lukala Noow nama. ");
INSERT INTO mmo_vpl VALUES ("JN3_36","073_3_36","JHN","3","36","36","+ o 3:36 Jon 3:16-18; 1Jon 5:12; Luk 3:7*Om hil sen londpayo na timu vu Anutu Noow-ato ond sil e mando metumin danggata, de hil sen me-lambiing gaving Anutu Noow lava le ond sil-ame le mando metumin e, malis, Anutu ahekalin vu sil-ambe neep. ");
INSERT INTO mmo_vpl VALUES ("JN4_1","073_4_1","JHN","4","1","1","+ o 4:1 Jon 3:22,26*Hil Palisai lango vakasin nambe Yesu nalipis hil atombe hil ngeeyaata davu sapa yi lôôt savok Jon, ");
INSERT INTO mmo_vpl VALUES ("JN4_2","073_4_2","JHN","4","2","2","lemu Yesu me-nalipis hil e, yite maanggêêm-aso ond mem yoo dalipis hil. ");
INSERT INTO mmo_vpl VALUES ("JN4_3","073_4_3","JHN","4","3","3","Tombe Yesu lak ni nambe banye tok la vu hil Palisai, om having yite maanggêêm-aso be lavuuh taaku Yudia de lalaah in nambe lana Galili, ");
INSERT INTO mmo_vpl VALUES ("JN4_4","073_4_4","JHN","4","4","4","+ o 4:4 Luk 9:52*ond sil sapa mop ti neep vu Samaalia lavuun-ambe lala. ");
INSERT INTO mmo_vpl VALUES ("JN4_5","073_4_5","JHN","4","5","5","+ o 4:5 Jen 33:19; Jos 24:32*Sil mondala be taaku me la naale lavuun atombe mem lala lato taaku bop ti neep Samaalia, danêêl nambe Saika, taakuu-ju neep ngaaho vu ngaanggis sen Yaakop vu vu noow Yusep bôôy-ato. ");
INSERT INTO mmo_vpl VALUES ("JN4_6","073_4_6","JHN","4","6","6","De sov dinaandiin sen Yaakop haav bôôy-ambe davu kava bel hôôk-ato neep taakuu-ju, tombe Yesu vaha ma lak, om la hato nando ngaaho vu sov bel-atêênjuuto. ");
INSERT INTO mmo_vpl VALUES ("JN4_7","073_4_7","JHN","4","7","7","Tonde vêêh Samaalia ti hato in nambe bayêên bel, tombe Yesu nêêl vu nambe, “Gambu bel naam sa naanum.” ");
INSERT INTO mmo_vpl VALUES ("JN4_8","073_4_8","JHN","4","8","8","In yite maanggêêm-aso ond sil lamunggin-ambe lala bayêên in baanggo vanôôn. ");
INSERT INTO mmo_vpl VALUES ("JN4_9","073_4_9","JHN","4","9","9","+ o 4:9 Esra 4:1-5; 9:1–10:44; Luk 9:52-53*Tonde vêêh Samaaliaa-jôôto nêêl vu nambe, “Hong Yuda de sa vêêh Samaalia, le nambe tana sen okataangg bel vu sa?” Nêêl nambêênju in hil Yuda me-dakaas having hil Samaalia le. ");
INSERT INTO mmo_vpl VALUES ("JN4_10","073_4_10","JHN","4","10","10","+ o 4:10 Jon 4:26; 7:37-38; Taato 21:6*Tombe Yesu nêêl laah vu yi nambe, “Naambe galak va sen Anutu vu vu ham-ato ni, osin omaaho sen nêêl vu hong nambe, ‘Gambu bel naam sa naanum,’ ond gale kataangg vu tombe le bu bel metumin-ate vu hong.” ");
INSERT INTO mmo_vpl VALUES ("JN4_11","073_4_11","JHN","4","11","11","Tombe vêêh-anjuuto nêêl nambe, “Omaaho Bop, ganêêm dêêngg sen ombayêên bel hôôk-ato ma, de bel sen neep hôôk sov-anju ond neep kambini lôôt, om gale gako bel metumin-ate vu tana? ");
INSERT INTO mmo_vpl VALUES ("JN4_12","073_4_12","JHN","4","12","12","+ o 4:12 Jon 8:53*De yiiyate himbop bôôy Yaakop vu sov bel-atêênjo vu hey, tonde yoo num bel-anjo de yite noondin osin kao yuuh bik sipsip ayuuh ame lanum having, ond mak osavok Yaakop la?” ");
INSERT INTO mmo_vpl VALUES ("JN4_13","073_4_13","JHN","4","13","13","Tombe Yesu nêêl laah vu nambe, “Hil pin sen danum bel-anjôôto ond sil alond e bambôôv naah, ");
INSERT INTO mmo_vpl VALUES ("JN4_14","073_4_14","JHN","4","14","14","+ o 4:14 Jon 6:35*nganjo omaaho ti naanum bel sen saambu vu yii-to, ond nohvu busin pin vu taamusin-ato omaahôô-ju me-le lo bambôôv jesin naah e, malis lôôt. In bel sen saambu vu yii-to ond le buuk hôôk lopayo naambe sen bel navuuk hôôk sov-ato, be naatu yite bel dangga dosin in biing-ambe mando metumin danggata-te.” ");
INSERT INTO mmo_vpl VALUES ("JN4_15","073_4_15","JHN","4","15","15","Tombe vêêh-anjôôto nêêl nambe, “Omaaho Bop, gambu bel-anja vu sa in taamusin sa longg-ame bambôôv naah in bel e, de same aanom bayêên bel vuu-jo jesin naah e.” ");
INSERT INTO mmo_vpl VALUES ("JN4_16","073_4_16","JHN","4","16","16","Le Yesu nêêl vu nambe, “Gana naateey layam e mem ganom-anjo.” ");
INSERT INTO mmo_vpl VALUES ("JN4_17","073_4_17","JHN","4","17","17","Le vêêh-anjuuto nêêl laah nambe, “Sak moow ma.” Tombe Yesu nêêl vu nambe, “Ganêêl nambe hong o moow ma ond ganêêl lohvu, ");
INSERT INTO mmo_vpl VALUES ("JN4_18","073_4_18","JHN","4","18","18","in bôôy ond galak vu moow namaavaalu, de moow ti sen onando having gêên-anja ond manyinja game layam yi le, om ganêêl keen-anja.” ");
INSERT INTO mmo_vpl VALUES ("JN4_19","073_4_19","JHN","4","19","19","+ o 4:19 Jon 7:40; 9:17; 1Ko 14:24-25*Tombe vêêh-anjuuto nêêl nambe, “Omaaho Bop, gêên sa lak ni nambe hil sen danêêl Anutu-te vakasin langaah-ato ti hong-anja. ");
INSERT INTO mmo_vpl VALUES ("JN4_20","073_4_20","JHN","4","20","20","+ o 4:20 Diu 12:5-14; Saam 122:1-5*De hey Samaalia ond heyate himbop-aso bôôy lala dalohak neep kandu Gelisim-anjo, tonde ham Yuda ond ham nanêêl nambe taaku sen lohakin ambaan-ato yoo neep Yelusalem timu.” ");
INSERT INTO mmo_vpl VALUES ("JN4_21","073_4_21","JHN","4","21","21","Tombe Yesu nêêl vu nambe, “Onggango sate vakasin e, in busin ti le naatok ond ham-ame le anohak vu Aamangg vu kanduu-jo le, de me-vu Yelusalem gaving e. ");
INSERT INTO mmo_vpl VALUES ("JN4_22","073_4_22","JHN","4","22","22","+ o 4:22 2King 17:29-41; Ais 2:3; Lom 9:4-5*Le ham-anja, ham oo monalohak vu omaaho sen ham doosin yii-to, de hey ond hey naalohak vu omaaho sen hey alak nii-to, in omaaho sen le dôôvu omaahonôôn pin-ato ond laam vu hil Yuda. ");
INSERT INTO mmo_vpl VALUES ("JN4_23","073_4_23","JHN","4","23","23","Lemu busin ti le naatok, ond tok laam lung la gêên-anjo, tombe hil pin sen dalohak keen-ato ond le lanohak vu Aamangg osin sil kanund doos, tombe lanohak osin keenaanôôn, in Aamangg oo navu salo hil nambêênju in nambe lanohak vu yi. ");
INSERT INTO mmo_vpl VALUES ("JN4_24","073_4_24","JHN","4","24","24","+ o 4:24 2Ko 3:17; Lom 12:1; Pil 3:3*De Anutu ond yi Vavi Vaambuung, om hil sen lanohak vu yii-to ond lanohak vu osin sil kanund doos osin keen.” ");
INSERT INTO mmo_vpl VALUES ("JN4_25","073_4_25","JHN","4","25","25","+ o 4:25 Jon 1:41*Tombe vêêh-anjuuto nêêl vu yi nambe, “Sa hango nambe omaaho sen Anutu yoo holin yi vulôôt-ato le naam, danêêl yi nambe Kalisi, tombe naam ond mem le tatekin va pin danggakook vu yiiy.” ");
INSERT INTO mmo_vpl VALUES ("JN4_26","073_4_26","JHN","4","26","26","+ o 4:26 Mak 14:61-62; Jon 9:37*Le Yesu nêêl vu nambe, “Yik sa sen sa monakaas vu hong-anjo.” ");
INSERT INTO mmo_vpl VALUES ("JN4_27","073_4_27","JHN","4","27","27","Tombe Yesu-te maanggêêm-aso lalo-lato pavis e lavindis in nambe nakaas having vêêh ti. Lemu sil ti me-lingin Yesu nambe, “Gawiingin gako vaati? Onakaas having vêêh-anja in?” Malis. ");
INSERT INTO mmo_vpl VALUES ("JN4_28","073_4_28","JHN","4","28","28","Tonde vêêh-anjuuto havuuh yite dêêngg nando de laah bayêên, tombe nêêl vu hil nambe, ");
INSERT INTO mmo_vpl VALUES ("JN4_29","073_4_29","JHN","4","29","29","“Ham anaam angge omaaho ti yoo nêêl sate va pin sen sa naawiing bôôy-ato langaah vu sa. Mak Kalisii-ju?” ");
INSERT INTO mmo_vpl VALUES ("JN4_30","073_4_30","JHN","4","30","30","Tombe sil vu bayêên-ambe lala vu Yesu. ");
INSERT INTO mmo_vpl VALUES ("JN4_31","073_4_31","JHN","4","31","31","Daahen dalaam atonde Yesu-te maanggêêm-aso lanêêl vu nambe, “Kaputung, gangga vanôôn daka le.” ");
INSERT INTO mmo_vpl VALUES ("JN4_32","073_4_32","JHN","4","32","32","Le nêêl vu sil nambe, “Sate vanôôn nando le ham doosin.” ");
INSERT INTO mmo_vpl VALUES ("JN4_33","073_4_33","JHN","4","33","33","Tombe yite maanggêêm-aso yoo lanêêl vu sil nambe, “Mak omaaho ti hako vanôôn laam vu yi mava?” ");
INSERT INTO mmo_vpl VALUES ("JN4_34","073_4_34","JHN","4","34","34","+ o 4:34 Jon 6:38; 17:4*Le Yesu nêêl vu sil nambe, “Sate vanôôn-anjo nambe saambiing va nohvu omaaho sen wiing sa laam-ato ka, osin saambiing yite kul jung na le. ");
INSERT INTO mmo_vpl VALUES ("JN4_35","073_4_35","JHN","4","35","35","+ o 4:35 Luk 10:2*De ham ond ham oo nanêêl nambe, ‘Kwaav yumbeyuuh amu neep in yangga vanôôn kul moos anye,’ le sa naanêêl vu ham naambe ham amem jak-ambe ham angge naambe vanôôn nôôn ak lung la lohvu yiiy gako. ");
INSERT INTO mmo_vpl VALUES ("JN4_36","073_4_36","JHN","4","36","36","De omaaho sen nako nôôn-ato ond daanggo yi, de yoo monasupin nôôn in nambe mando metumin danggata, tombe omaaho sen naalôôh vavêê-to de omaaho ango sen nako nôôn-ato ond yuuh ahondoosin e daapêêlis hôôk ti. ");
INSERT INTO mmo_vpl VALUES ("JN4_37","073_4_37","JHN","4","37","37","Om sen danêêl nambe, ‘Omaaho ango naalôôh vave de ango nasupin nôôn,’ ond vakasin-anjo keen. ");
INSERT INTO mmo_vpl VALUES ("JN4_38","073_4_38","JHN","4","38","38","Saawiing-ambe ham ala in nambe gako nôôn hôôk kul sen ham-ame yoo namam kul-ato le, ma, in hil vaalu lawiing kul bop, lemu ham nako nôôn ak silate niwêêk malis amu.” ");
INSERT INTO mmo_vpl VALUES ("JN4_39","073_4_39","JHN","4","39","39","Tombe hil Samaalia ngeeyaata vu bayêên tii-ju lawii-having Yesu in vakasin sen vêêh nêêl vu sil nambe, “Yoo nêêl sate va pin sen sa naawiing bôôy-ato langaah vu sa.” ");
INSERT INTO mmo_vpl VALUES ("JN4_40","073_4_40","JHN","4","40","40","Tonde hil Samaalia lalaam-ambe kataangg Yesu nambe mando gaving sil, tombe nandôô-ju busin yuuh, ");
INSERT INTO mmo_vpl VALUES ("JN4_41","073_4_41","JHN","4","41","41","om hil ngeeyaata lôôt lango yite vakasin having atombe lawii-having. ");
INSERT INTO mmo_vpl VALUES ("JN4_42","073_4_42","JHN","4","42","42","+ o 4:42 1; Jon 4:14*Tonde lanêêl vu vêêh-anjuuto nambe, “Gêên-anjo hey-ame hango gate vakasin-anja be hey aawii-having yi le, malis. Yik hey oo hango yite vakasin atombe hey alak ni nambe omaahôô-ja ond yi sen le dôôvu omaahonôôn pin vu voon keen.” ");
INSERT INTO mmo_vpl VALUES ("JN4_43","073_4_43","JHN","4","43","43","+ o 4:43 Jon 4:40*Tombe busin yuuh-anju lung la tonde Yesu havuuh taakuu-ju de la Galili, ");
INSERT INTO mmo_vpl VALUES ("JN4_44","073_4_44","JHN","4","44","44","+ o 4:44 Mat 13:57*in Yesu yoo nêêl langaah nambe, “Omaaho ti nanêêl Anutu-te vakasin langaah ond hil-ame dako haale lak vu baan dangga dosin e.” ");
INSERT INTO mmo_vpl VALUES ("JN4_45","073_4_45","JHN","4","45","45","+ o 4:45 Jon 2:23*De la valup Galili tombe hil Galili lako yi lak, in sil lala layi busin bop busin haluusin vu Yelusalem having, om yoo layi va pin sen Yesu wiing hôôk busin bop-anjuuto. ");
INSERT INTO mmo_vpl VALUES ("JN4_46","073_4_46","JHN","4","46","46","+ o 4:46 Jon 2:1-11*Tombe laah valup Kena Galili sen bôôy wiing bel-ambe tu wain-ato, tonde yêêv ti nandôô-ju noow anilak vu Kapenaum-ambe neep. ");
INSERT INTO mmo_vpl VALUES ("JN4_47","073_4_47","JHN","4","47","47","+ o 4:47 Mat 8:5-6*Tombe yêêv tii-ju hango nambe Yesu vu Yudia be valup Galili, om la kataangg Yesu nambe na biing-ambe noow anivasa jak, in ngaaho lak in unoopasiv-anju navu jimb. ");
INSERT INTO mmo_vpl VALUES ("JN4_48","073_4_48","JHN","4","48","48","+ o 4:48 Jon 2:18; 1Ko 1:22*Le Yesu nêêl vu nambe, “Same aambiing taahu taahu osin niwêêk-ande ham angge le, ond ham-ame le ambiing gaving e.” ");
INSERT INTO mmo_vpl VALUES ("JN4_49","073_4_49","JHN","4","49","49","Tombe yêêv-anju nêêl nambe, “Omaaho Bop, ganaam pavis in sate unoopasiv navu jimb.” ");
INSERT INTO mmo_vpl VALUES ("JN4_50","073_4_50","JHN","4","50","50","+ o 4:50 Mat 8:13; Mak 7:29*Le Yesu nêêl laah vu yi nambe, “Ganaah, noom nando.” Tombe omaahôô-juuto wii-having vakasin sen Yesu nêêl vuu-to be laah. ");
INSERT INTO mmo_vpl VALUES ("JN4_51","073_4_51","JHN","4","51","51","Naahen monalaas atonde yite hil kul vaha-so lato latovu yi vu mop-ambe lanêêl nambe, “Noom nando.” ");
INSERT INTO mmo_vpl VALUES ("JN4_52","073_4_52","JHN","4","52","52","Tombe lingin sil nambe, “Hôôk taaku me vaati ninaavi kuuh?” Tombe lanêêl nambe, “Ninaavi kuuh vasêên hôôk vandiisin lohvu taaku me ti.” ");
INSERT INTO mmo_vpl VALUES ("JN4_53","073_4_53","JHN","4","53","53","+ o 4:53 Sin 16:14-15,31*Tombe mem mangganaan lak ni nambe yik nivalok lohvu taaku me sen Yesu nêêl vu nambe, “Noom nando.” Om yi be yite hil pin lawii-having Yesu. ");
INSERT INTO mmo_vpl VALUES ("JN4_54","073_4_54","JHN","4","54","54","+ o 4:54 Jon 2:11,23*Om sen Yesu vu Yudia be la valup Galili lung laa-to, ond yik wiing taahu taahu osin niwêêk tu balon yuuh-anjo. ");
INSERT INTO mmo_vpl VALUES ("JN5_1","073_5_1","JHN","5","1","1","Lung laa tonde hil Yuda-te busin bop ti ngaaho lak om Yesu la valup Yelusalem. ");
INSERT INTO mmo_vpl VALUES ("JN5_2","073_5_2","JHN","5","2","2","Tombe vu Yelusalem-anju betum ti neep ngaaho vu vinavi sen danêêl nambe bik sipsip-atêêto. Betum-anju danêêl hôôk Yuda lavand Hiblu nambe Betesda, tonde betum nanyendanggaa-ju ond bayêên dako vavi hôôk-ate namaavaalu nando. ");
INSERT INTO mmo_vpl VALUES ("JN5_3","073_5_3","JHN","5","3","3","Tombe bayêên vavi-têênju hil anilakin ngeeyaata deep hôôk, having hil vaalu sen sil amend kanu de vahand anipaya, osin hil sen kook navu tasiis-ato ond mondanggin bel-anju in nambe jêêy. ");
INSERT INTO mmo_vpl VALUES ("JN5_4","073_5_4","JHN","5","4","4","In busin ti ti Omaaho Bop-ate angela ti hato nalukala betum-anju ond nawiing-ambe bel nayêêy lôôt, tombe yik nilakin ti jeen dukana bel sen nayêêy-anju naamunggin ond le nivasa jak pavis. ");
INSERT INTO mmo_vpl VALUES ("JN5_5","073_5_5","JHN","5","5","5","Ke, tombe omaaho ti nilak-ambe neep hôôk bayêên vavi-têênjuuto ond yoo ninalak boyambôôy lohvu ta 38. ");
INSERT INTO mmo_vpl VALUES ("JN5_6","073_5_6","JHN","5","6","6","Tombe Yesu yi de omaahôô-ju neep, tombe yoo lak ni nambe nilak lohvu ta ngeeyaata. Om Yesu lingin yi nambe, “Gawiingin nambe ganim vasa dôôk a?” ");
INSERT INTO mmo_vpl VALUES ("JN5_7","073_5_7","JHN","5","7","7","Tombe nipaling nêêl laah vu yi nambe, “Omaaho Bop, busin sen bel-anju nayêêy-ato ond sanêêngg omaaho sen gako sa be gatung sa dukana bel-anjuuto ma, de soo naawiingin nambe ana le ma de hil vaalu dalukala namunggin in sa.” ");
INSERT INTO mmo_vpl VALUES ("JN5_8","073_5_8","JHN","5","8","8","+ o 5:8 Mat 9:6*Tombe Yesu nêêl vu yi nambe, “Okandi gako gate kaanye jak-ambe gana.” ");
INSERT INTO mmo_vpl VALUES ("JN5_9","073_5_9","JHN","5","9","9","+ o 5:9 Jon 9:14*Tombe omaahôô-jôôto nivasa hôôk pavis, tonde hako yite kaanye be la. Vaa-ju hôôk busin sawaasin, ");
INSERT INTO mmo_vpl VALUES ("JN5_10","073_5_10","JHN","5","10","10","+ o 5:10 Nie 13:19; Jer 17:21; Luk 13:14*om hil Yuda lanêêl vu omaaho sen nivasa hôôk laah-anju nambe, “Gêên busin sawaasin om me-lohvu nambe onggako kaanye le.” ");
INSERT INTO mmo_vpl VALUES ("JN5_11","073_5_11","JHN","5","11","11","Le omaahôô-ju nêêl laah vu sil nambe, “Omaaho sen wiing-ambe sa ningg vasa hôôk-ato ond yik nêêl vu sa nambe onggako gate kaanye jak-ambe gana.” ");
INSERT INTO mmo_vpl VALUES ("JN5_12","073_5_12","JHN","5","12","12","Tombe sil lalingin yi nambe, “Omaaho lati nêêl vu hong nambe onggako kaanye jak-ambe gana?” ");
INSERT INTO mmo_vpl VALUES ("JN5_13","073_5_13","JHN","5","13","13","Lemu omaaho sen nivasa hôôk laah-anjuuto doosin, in taakuu-ju hil ngeeyaata om Yesu lukala sil lavuun-ambe la gêên. ");
INSERT INTO mmo_vpl VALUES ("JN5_14","073_5_14","JHN","5","14","14","+ o 5:14 Jon 8:11*Lung laa tonde sim Yesu tovu yi hôôk Anutu-te dumb bop alo, tombe nêêl vu nambe, “Angge, ganim vasa lak lung la, om game gambiing nipaya naah e, in nimeen bopaata ti le naatovu hong savok munggin-anjo na.” ");
INSERT INTO mmo_vpl VALUES ("JN5_15","073_5_15","JHN","5","15","15","Tombe omaahôô-jôôto laah-ambe nêêl vu hil Yuda nambe, “Omaaho sen wiing-ambe sa nivasa lak-ato ond Yesu.” ");
INSERT INTO mmo_vpl VALUES ("JN5_16","073_5_16","JHN","5","16","16","+ o 5:16 Mat 12:14*Om hil Yuda mondawiing nindanjeen vu Yesu in nawiing va nambêênju hôôk busin sawaasin. ");
INSERT INTO mmo_vpl VALUES ("JN5_17","073_5_17","JHN","5","17","17","+ o 5:17 Jon 9:4*Le Yesu nêêl vu sil nambe, “Aamangg oo monawiing kul-ambe tok laam gêên-anjo, de yik sa naawiing sapa hôôk vaha.” ");
INSERT INTO mmo_vpl VALUES ("JN5_18","073_5_18","JHN","5","18","18","+ o 5:18 Mat 26:4; Jon 7:1,30; 10:30,33*Tombe hil Yuda yoo lawiingin lôôt nambe lanyiis Yesu be jimb, lemu me-lanyiis ak va sen wiing hôôk busin sawaasin amu le, nganjo nêêl Anutu nambe yite mangganaan, ond nambe sen yuuh Anutu laloh ti. ");
INSERT INTO mmo_vpl VALUES ("JN5_19","073_5_19","JHN","5","19","19","+ o 5:19 Jon 5:30; 8:28*Tombe Yesu nêêl vu sil nambe, “Sa naanêêl keen lôôt vu ham naambe Noow-ame yoo lohvu nambe biing vati nohvu ka le, malis, yoo nawiing va sen nayi de Mangganaan nawiing-ato. Va pin sen Mangganaan nawiing-ato ond yik Noow oo nawiing vaa-ju having. ");
INSERT INTO mmo_vpl VALUES ("JN5_20","073_5_20","JHN","5","20","20","+ o 5:20 Jon 3:35*In nambe Mangganaan ahe naving Noow-ambe navu taato va pin sen yoo nawiing-ato vu, tonde le taato kul bopaata heey savok sen-anjo na, tombe ham oo le ambindis lôôt. ");
INSERT INTO mmo_vpl VALUES ("JN5_21","073_5_21","JHN","5","21","21","+ o 5:21 Lom 4:17; Ep 2:5; Jon 11:25*Nambe sen Mangganaan nawiing-ambe hil yimbin davu kandi lak laah-ambe dando mend natum, ond yik nambêênju Noow navu metumin vu hil sen ka navu nambe bu vu sil-ato. ");
INSERT INTO mmo_vpl VALUES ("JN5_22","073_5_22","JHN","5","22","22","+ o 5:22 Jon 3:17; 5:27; 9:39; Sin 10:42*Tonde Mangganaan-ame nangoyin omaaho ti-te vakasin e, in kul sen gango vakasin-anjo ond vu pin lukalaam Noow nama lung la, ");
INSERT INTO mmo_vpl VALUES ("JN5_23","073_5_23","JHN","5","23","23","+ o 5:23 Pil 2:10-11; 1Jon 2:23*in nambe hil pin gako Noow haale jak naambe sen dako Mangganaan haale lak-ato. De hil sen me-gako Noow haale jak-ato ond sil-ame dako Mangganaan sen wiing Noow laam-ato haale lak having e. ");
INSERT INTO mmo_vpl VALUES ("JN5_24","073_5_24","JHN","5","24","24","+ o 5:24 Jon 3:15-18; 8:51; 1Jon 3:14*“Om sa naanêêl keen lôôt vu ham naambe hil sen dango sate vakasin-ambe londpayo nala timu vu omaaho sen wiing sa laam-ato, ond sil e mando metumin danggata, de sil-ame le lambiing vakasin-ambe daatovu nyevahaan e, malis, sil lavuuh mop meyimbin-ate de davu sapa mop metumin-ate lung la. ");
INSERT INTO mmo_vpl VALUES ("JN5_25","073_5_25","JHN","5","25","25","+ o 5:25 Mat 8:22; Ep 2:5-6*“Om sa naanêêl keen lôôt vu ham naambe busin ti le naatok om tok laam lung laa-jo, tombe hil sen davu sapa mop meyimbin-atêêto ond davu gango Anutu Noow lava, tombe hil sen gangôô-to ond sil e mando metumin. ");
INSERT INTO mmo_vpl VALUES ("JN5_26","073_5_26","JHN","5","26","26","+ o 5:26 Jon 1:4*In metumin danggakook neep vu Mangganaan, ond yik wiing-ambe metumin danggakook neep vu Noow having. ");
INSERT INTO mmo_vpl VALUES ("JN5_27","073_5_27","JHN","5","27","27","+ o 5:27 Jon 5:22*Tonde Mangganaan holin Noow lung la in nambe Noow gangoyin omaahonôôn-ate vakasin, in Omaahonôôn Noow yii-to. ");
INSERT INTO mmo_vpl VALUES ("JN5_28","073_5_28","JHN","5","28","28","Om ham-ame ambindis in vaa-ja le, in busin ti navu naatok atonde hil pin sen deep bandumb-ato le gango lava, ");
INSERT INTO mmo_vpl VALUES ("JN5_29","073_5_29","JHN","5","29","29","+ o 5:29 Dan 12:2; Mat 16:27; Jon 6:40; Sin 24:15*tombe sil e gavuuh bandumb-ande lanaam voon, tombe vaalu sen lawiing va nivalok-ato ond sil e kandi jak naah in nambe sil mando metumin, tonde vaalu sen lawiing nipayaa-to ond sil e kandi jak in daatovu nyevahaan.” ");
INSERT INTO mmo_vpl VALUES ("JN5_30","073_5_30","JHN","5","30","30","+ o 5:30 Jon 5:19; 6:38*“Same yoo aalohvu nambe saambiing vati nohvu sa kangg e, sa navu sapa hôôk vakasin sen Aamangg nanêêl vu saa-to be sa nangoyin omaahonôôn-ate vakasin ak. Tombe soo nangoyin omaahonôôn-ate vakasin-ambe sa naanêêl nivalok, in same yoo naawiingin nambe aambiing va nohvu sa kangg e, yik sa naawiingin nambe aambiing va nohvu omaaho sen wiing sa laam-ato ka. ");
INSERT INTO mmo_vpl VALUES ("JN5_31","073_5_31","JHN","5","31","31","+ o 5:31 Jon 8:13-14*Naambe soo naanêêl sate dangga langaah ond vakasin sen saanêêl-anjôôto me-lohvu le, ");
INSERT INTO mmo_vpl VALUES ("JN5_32","073_5_32","JHN","5","32","32","+ o 5:32 Jon 5:36-37; 1Jon 5:9*lemu omaaho ango nando ond nêêl sate vakasin langaah, tombe sa lak ni nambe vakasin sen nêêl lak saa-to ond vakasin-anju keen. ");
INSERT INTO mmo_vpl VALUES ("JN5_33","073_5_33","JHN","5","33","33","“De bôôy ham awiing hil lala vu Jon, tombe nêêl vakasin keen-ato langaah lung la. ");
INSERT INTO mmo_vpl VALUES ("JN5_34","073_5_34","JHN","5","34","34","+ o 5:34 Jon 1:19-34; 3:27-30*Tonde same aawiingin nambe omaaho ti naanêêl sate danggakook langaah e, malis, lemu soo aawiingin nambe Anutu dôôvu ham, ondeey saanêêl Jon-ate vakasin-anja. ");
INSERT INTO mmo_vpl VALUES ("JN5_35","073_5_35","JHN","5","35","35","De Jon ond kin tumin sen natum-ambe navu melangaah vu taakuu-to, tombe ham alompayo nivasa be ham napêêlis daka in yite melangaah. ");
INSERT INTO mmo_vpl VALUES ("JN5_36","073_5_36","JHN","5","36","36","+ o 5:36 Jon 3:2; 10:25,38; 14:11*“Lemu va sen taato sate dangga langaah-ato de savok vakasin sen Jon nêêl lak saa-to la, ond kul pin sen Aamangg vu vu sa in nambe sa samu kul-anjôôto, ond kul sen sa naawiing-anjo yoo taato sa langaah nambe Aamangg oo wiing sa be sa laam. ");
INSERT INTO mmo_vpl VALUES ("JN5_37","073_5_37","JHN","5","37","37","+ o 5:37 Mat 3:17; Jon 5:32; 8:18*Tonde Aamangg wiing sa laam-ato, ond yoo nêêl sate dangga langaah lung la, lemu ham-ame hango lava daka le, malis lôôt. De ham-ame ahe mem ak yi le, ");
INSERT INTO mmo_vpl VALUES ("JN5_38","073_5_38","JHN","5","38","38","+ o 5:38 Jon 6:29*de yite vakasin-ame neep hôôk ham alompayo le, in dangga nambe ham-ame awii-having omaaho sen Aamangg wiing laam-anjôôto le. ");
INSERT INTO mmo_vpl VALUES ("JN5_39","073_5_39","JHN","5","39","39","+ o 5:39 Luk 24:27,44; Sin 13:27; 2Ti 3:15-17; 1Pi 1:10-11*Ham oo monasevin Anutu-te kaapiya lôôt in ham akam vu nambe metumin dangga lukaneep om ham e naatokak, ond yik kaapiyaa-ja nanêêl sate dangga langaah, ");
INSERT INTO mmo_vpl VALUES ("JN5_40","073_5_40","JHN","5","40","40","lemu ham anim baya nambe ham-ame anaam vu sa in ham mando metumin e. ");
INSERT INTO mmo_vpl VALUES ("JN5_41","073_5_41","JHN","5","41","41","“Same aawiingin nambe hil gako sa jak e, ");
INSERT INTO mmo_vpl VALUES ("JN5_42","073_5_42","JHN","5","42","42","lemu sa lak ham anim nambe ham alompayo me-having Anutu le. ");
INSERT INTO mmo_vpl VALUES ("JN5_43","073_5_43","JHN","5","43","43","+ o 5:43 Mat 24:5*Tonde sa laam ak Aamangg haale le ham-ame hako sa lak e. Le naambe omaaho ti yoo naam ak haale ond ham e gako yi jak. ");
INSERT INTO mmo_vpl VALUES ("JN5_44","073_5_44","JHN","5","44","44","+ o 5:44 Jon 12:43*De ham oo awiingin nambe halim-aso yoo gako ham haalem jak, de ham-ame awiingin nambe Anutu timu gako ham haalem jak e, om ham e ambiing gaving naambe va? ");
INSERT INTO mmo_vpl VALUES ("JN5_45","073_5_45","JHN","5","45","45","+ o 5:45 Diu 31:26-27*Lemu ham-ame kam bu naambe sa navu aambiing vakasin vu ham vu Mangg e, malis, omaaho sen nawiing vakasin vu ham-ato ond Mose sen ham akam vu nambe le dôôvu ham-ato. ");
INSERT INTO mmo_vpl VALUES ("JN5_46","073_5_46","JHN","5","46","46","+ o 5:46 Diu 18:15; Sin 3:22*Le naambe ham awii-having Mose-te vakasin ond ham e ambiing gaving sa, in Mosêê-ju kaavu vakasin ak sa. ");
INSERT INTO mmo_vpl VALUES ("JN5_47","073_5_47","JHN","5","47","47","+ o 5:47 Luk 16:31*Le naambe ham-ame awii-having vakasin sen Mose kaavuu-ju le, ond ham e ambiing gaving sate vakasin naambe vaati?” ");
INSERT INTO mmo_vpl VALUES ("JN6_1","073_6_1","JHN","6","1","1","Lung laa tonde Yesu la betum Galili vaalu, betum-anju danêêl haale ango nambe Taibilias, ");
INSERT INTO mmo_vpl VALUES ("JN6_2","073_6_2","JHN","6","2","2","tombe hil ngeeyaata layi taahu taahu osin niwêêk sen wiing ak hil anilakin-ato om sil taamuyin lôôt. ");
INSERT INTO mmo_vpl VALUES ("JN6_3","073_6_3","JHN","6","3","3","Tonde Yesu having yite maanggêêm-aso be lalakala dando kandu ti. ");
INSERT INTO mmo_vpl VALUES ("JN6_4","073_6_4","JHN","6","4","4","+ o 6:4 Jon 2:13*De hil Yuda-te busin bop busin haluusin sen Anutu haluuh hil Islel hôôk vu Ijip bôôy-ato ngaaho lak, ");
INSERT INTO mmo_vpl VALUES ("JN6_5","073_6_5","JHN","6","5","5","tombe Yesu vêêl me lak, le yi de hil ngeeyaata dalaam vu yi, tombe nêêl vu Pilip nambe, “Yale baanggo vanôôn vu tana in yaambu be hil-anjo lanja?” ");
INSERT INTO mmo_vpl VALUES ("JN6_6","073_6_6","JHN","6","6","6","Vakasin-anjo yoo nêêl in nambe sahi Pilip, de va sen navu biing-ato ond yoo lak ni lung la. ");
INSERT INTO mmo_vpl VALUES ("JN6_7","073_6_7","JHN","6","7","7","Le Pilip nêêl laah vu yi nambe, “Naambe yiiy baanggo vanôôn ak 200 kina be yaambu daka daka vu sil ond me-le nohvu sil e.” ");
INSERT INTO mmo_vpl VALUES ("JN6_8","073_6_8","JHN","6","8","8","Tombe yite maanggêêm ango Simon Pita hali Endru nêêl vu Yesu nambe, ");
INSERT INTO mmo_vpl VALUES ("JN6_9","073_6_9","JHN","6","9","9","“Unoopasiv ti monako balet namaavaalu having paahuung yuuh nandôô-jo, lemu vanôôn dakaa-jo le dôôvu hil alu ngeeyaataa-jo naambe tana?” ");
INSERT INTO mmo_vpl VALUES ("JN6_10","073_6_10","JHN","6","10","10","Tombe Yesu nêêl nambe, “Ham naanêêl vu hil naambe sil gato mando.” Taakuu-ju taavêêt alis anivasa om sil lato dando lak, ond moow ngeeyaata lôôt lohvu 5 taosen. ");
INSERT INTO mmo_vpl VALUES ("JN6_11","073_6_11","JHN","6","11","11","Lato dando lung la tonde Yesu lôôh balet-anju lak, tombe lohak osin pêêlis la vu Anutu de hatiiy vu sil, tonde yik paahuung yuuh-anjuuto wiing va timu, tombe sil oo laya lohvu kand. ");
INSERT INTO mmo_vpl VALUES ("JN6_12","073_6_12","JHN","6","12","12","Sil laya be lohvu sil atonde Yesu nêêl vu yite maanggêêm-aso nambe, “Ham naasupin vanôôn anyengale pin, in yame aambiliyak e.” ");
INSERT INTO mmo_vpl VALUES ("JN6_13","073_6_13","JHN","6","13","13","In sil laya balet namaavaalu nganjôô-to de nyengale-ngale nando, om sil lasupin nyengale lukala jaambang nomaayuuh-ambe laam yuuh-ambe pup. ");
INSERT INTO mmo_vpl VALUES ("JN6_14","073_6_14","JHN","6","14","14","+ o 6:14 Diu 18:15; Jon 5:46*Om hil layi de Yesu wiing taahu taahu osin niwêêk-anjo, tombe lanêêl nambe, “Keen, Anutu-te omaaho ti sen lanêêl nambe naam voon-ato ond yik yii-jo.” ");
INSERT INTO mmo_vpl VALUES ("JN6_15","073_6_15","JHN","6","15","15","+ o 6:15 Jon 18:36; Mat 14:23*Tombe Yesu lak ni nambe davu lanaam gako yi in nambe lambiing niwêêk in naatu silate omaaho lulemak, om yoo ti be laah kandu lu yesin. ");
INSERT INTO mmo_vpl VALUES ("JN6_16","073_6_16","JHN","6","16","16","Tonde soosin hôôk atombe Yesu-te maanggêêm-aso lala lato betum nanyendangga, ");
INSERT INTO mmo_vpl VALUES ("JN6_17","073_6_17","JHN","6","17","17","tombe sil lalakala kaanu ti be lala in lana betum vaalu Kapenaum ani, tonde taaku bus la de Yesu me-la hato vu sil e. ");
INSERT INTO mmo_vpl VALUES ("JN6_18","073_6_18","JHN","6","18","18","Tonde vavi bopaata ti laam osin niwêêk, tombe wiing-ambe betum anindanjeen ak, ");
INSERT INTO mmo_vpl VALUES ("JN6_19","073_6_19","JHN","6","19","19","de sil lateel kaanu be lala diin ak lôôt lohvu 5 kilomita me 6 kilomita. Tonde layi de Yesu naale lak bel baandoni be la valup ngaaho vu kaanu, tombe sil layêênin lôôt, ");
INSERT INTO mmo_vpl VALUES ("JN6_20","073_6_20","JHN","6","20","20","le nêêl vu sil nambe, “Yik saa-jo, om ham-ame anjêênin e.” ");
INSERT INTO mmo_vpl VALUES ("JN6_21","073_6_21","JHN","6","21","21","Tombe mem lawiingin-ambe lako Yesu lakala kaanu, tonde pavis atombe kaanu tok la taaku sen lala in nambe lanaa-to. ");
INSERT INTO mmo_vpl VALUES ("JN6_22","073_6_22","JHN","6","22","22","Tonde samiinaanôôn atombe hil sen dando betum vaalung-anjuuto lalak ni nambe kaanu heey-ame naalêê-ju le, yik timu sen Yesu-te maanggêêm-aso lalak-ambe lalaa-juuto, de Yesu me-lak kaanuu-ju be la having sil e. ");
INSERT INTO mmo_vpl VALUES ("JN6_23","073_6_23","JHN","6","23","23","+ o 6:23 Jon 6:11*Tonde hil Taibilias-ate kaanu heey valu-nando ngaaho vu taaku sen Omaaho Bop lohak vanôôn-ambe sil layaa-to, ");
INSERT INTO mmo_vpl VALUES ("JN6_24","073_6_24","JHN","6","24","24","tombe sil layi le Yesu having yite maanggêêm-aso me-dandôô-ju le, om lalakala kaanuu-ju heey-ambe lala in salo Yesu vu Kapenaum. ");
INSERT INTO mmo_vpl VALUES ("JN6_25","073_6_25","JHN","6","25","25","Tombe sil latovu Yesu vu betum vaalu be lanêêl vu nambe, “Kaputung, galaam-anjo naangelis?” ");
INSERT INTO mmo_vpl VALUES ("JN6_26","073_6_26","JHN","6","26","26","+ o 6:26 Jon 6:11-12*Tombe Yesu nêêl laah nambe, “Sa naanêêl keen lôôt vu ham naambe ham-ame kam navu nambe saawiing taahu taahu osin niwêêk ondeey ham navu salo sa le, malis, ham navu salo sa in balet sen ham aha be ham ahem pup-ato. ");
INSERT INTO mmo_vpl VALUES ("JN6_27","073_6_27","JHN","6","27","27","+ o 6:27 Jon 4:14; 6:48-58*Ham-ame ambiing kul in gako vanôôn sen le na menamaa-jo le, malis, ham ambiing kul in gako vanôôn nôôn keen sen le mando danggataa-to. Vanôôn-anjo Omaahonôôn Noow e bu vu ham, in Mangganaan Anutu yoo taato yi langaah lung la in nambe biing kul-anjo.” ");
INSERT INTO mmo_vpl VALUES ("JN6_28","073_6_28","JHN","6","28","28","Tombe lalingin yi nambe, “Hey e aambiing Anutu-te kul naambe vaati?” ");
INSERT INTO mmo_vpl VALUES ("JN6_29","073_6_29","JHN","6","29","29","+ o 6:29 1; Jon 3:23*Le Yesu nêêl laah vu sil nambe, “Anutu-te kul-anjo nambe ham ambiing gaving omaaho sen Anutu wiing laam-ato.” ");
INSERT INTO mmo_vpl VALUES ("JN6_30","073_6_30","JHN","6","30","30","+ o 6:30 Mat 16:1; Jon 2:18*Tombe lanêêl vu nambe, “Gale gambiing taahu taahu jak va bop vaati in hey aangge be hey aambiing gaving hong? Gale gambiing kul vaati? ");
INSERT INTO mmo_vpl VALUES ("JN6_31","073_6_31","JHN","6","31","31","+ o 6:31 Eks 16:14-15; Nam 11:7-9; Saam 78:24*Heyate himbop-aso bôôy ond laya vanôôn maana vu taaku lumbalaamb, lohvu vakasin sen kaavu neep hôôk kaapiyaa-to nambe, ‘Vu vanôôn baandoni vu sil-ambe laya.’” ");
INSERT INTO mmo_vpl VALUES ("JN6_32","073_6_32","JHN","6","32","32","Le Yesu nêêl vu sil nambe, “Sa naanêêl keen lôôt vu ham naambe Mose me-vu vanôôn baandoni vu ham e, malis, sate Aamangg oo navu vanôôn baandoni keen vu ham. ");
INSERT INTO mmo_vpl VALUES ("JN6_33","073_6_33","JHN","6","33","33","Ond vanôôn sen Anutu vuu-jo ond vu baandoni be lukalaam voon, tombe navu metumin vu omaahonôôn.” ");
INSERT INTO mmo_vpl VALUES ("JN6_34","073_6_34","JHN","6","34","34","+ o 6:34 Jon 4:15*Tombe lanêêl vu nambe, “Omaaho Bop, goo monambu vanôôn-anja vu hey nohvu busin pin.” ");
INSERT INTO mmo_vpl VALUES ("JN6_35","073_6_35","JHN","6","35","35","+ o 6:35 Jon 4:14; 6:48-58*Tombe Yesu nêêl vu sil nambe, “Yik saa-jo, soo aatu vanôôn metumin-ate. Omaaho ti nambe naam vu sa ond me-le jimb ahe naah e, de omaaho ti lopayo naam timu vu sa, ond me-le lo bambôôv jesin naah e. ");
INSERT INTO mmo_vpl VALUES ("JN6_36","073_6_36","JHN","6","36","36","+ o 6:36 Jon 20:29*Lemu saanêêl vu ham lung laa-to nambe ham ahe sa lung la, le ham-ame awii-having sa le. ");
INSERT INTO mmo_vpl VALUES ("JN6_37","073_6_37","JHN","6","37","37","+ o 6:37 Jon 17:6-8; Mat 11:28*De omaahonôôn pin sen Aamangg vu vu saa-to ond le lanaam vu sa, tonde omaaho ti naam vu sa ond same le gatiiy yi na le, malis. ");
INSERT INTO mmo_vpl VALUES ("JN6_38","073_6_38","JHN","6","38","38","+ o 6:38 Mat 26:39; Jon 4:34*De sa vu baandoni be saalukalaam voon in nambe same yoo le aambiing va nohvu sa kangg e, malis, saalukalaam voon in nambe saambiing nohvu omaaho sen wiing sa laam-ato ka. ");
INSERT INTO mmo_vpl VALUES ("JN6_39","073_6_39","JHN","6","39","39","+ o 6:39 Jon 10:28-29; 17:12*De omaaho sen wiing sa laam-anjo yite ka nambêênjo nambe omaahonôôn sen vu vu sa lung laa-to, ond same gavuuh ti be na menama le, malis, soo aambiing-ambe sil pin kandi jak vu busin taamusin. ");
INSERT INTO mmo_vpl VALUES ("JN6_40","073_6_40","JHN","6","40","40","+ o 6:40 Jon 11:24*In Mangg yoo ahe having nambe hil pin sen lanji Noow-ambe londpayo na timu vu yii-to ond sil e mando metumin danggata, tombe sale aambiing-ambe sil kandi jak vu busin taamusin.” ");
INSERT INTO mmo_vpl VALUES ("JN6_41","073_6_41","JHN","6","41","41","Tombe hil Yuda layi Yesu paya be lakaas ngeeyaata lôôt, in nêêl nambe, “Saa-jo sa vanôôn sen sa vu baandoni le saalukalaam voon.” ");
INSERT INTO mmo_vpl VALUES ("JN6_42","073_6_42","JHN","6","42","42","+ o 6:42 Mat 13:55*Tombe lanêêl nambe, “Omaahôô-ju yi Yesu sen Yusep noow-ato, de tangganaan ayuuh mangganaan ond yalak ni, le nambe tana sen nêêl gêên nambe laam vu baandoni?” ");
INSERT INTO mmo_vpl VALUES ("JN6_43","073_6_43","JHN","6","43","43","Tombe Yesu nêêl laah vu sil nambe, “Ham-ame bakaas ngeeyaata lôôt vu ham e. ");
INSERT INTO mmo_vpl VALUES ("JN6_44","073_6_44","JHN","6","44","44","+ o 6:44 Jon 6:65*Omaaho ti me-yoo lohvu nambe naam vu sa malis e. Aamangg sen yoo wiing sa be sa laam-ato nambe daandiiy omaaho ti ond mem le naam vu sa, tombe sale aambiing-ambe kandi jak vu busin taamusin. ");
INSERT INTO mmo_vpl VALUES ("JN6_45","073_6_45","JHN","6","45","45","+ o 6:45 Ais 54:13*In hil sen danêêl Anutu-te vakasin langaah-ato kaavu neep hôôk kaapiya nambe, ‘Anutu yoo le taahu omaahonôôn pin hôôk yite tanasin.’ De hil pin sen dango Aamangg-ate vakasin-ambe dalak nii-to ond dalaam vu sa. ");
INSERT INTO mmo_vpl VALUES ("JN6_46","073_6_46","JHN","6","46","46","+ o 6:46 Jon 1:18*Lemu omaaho ti me-yi me lak Mangg e, yik omaaho timu sen nando having Anutu be laam-ato, ond mem yi me lak Mangg. ");
INSERT INTO mmo_vpl VALUES ("JN6_47","073_6_47","JHN","6","47","47","+ o 6:47 Jon 3:15-16*“Om sa naanêêl keen lôôt vu ham naambe hil sen sil alondpayo naam timu vu saa-to ond sil e mando metumin danggata. ");
INSERT INTO mmo_vpl VALUES ("JN6_48","073_6_48","JHN","6","48","48","+ o 6:48-49 Jon 6:35,58*De sa ond sa vanôôn metumin-ate. ");
INSERT INTO mmo_vpl VALUES ("JN6_49","073_6_49","JHN","6","49","49","In bôôy hamate himbop-aso laya vanôôn maana vu taaku lumbalaamb-ato tombe sil layimb lung la, ");
INSERT INTO mmo_vpl VALUES ("JN6_50","073_6_50","JHN","6","50","50","lemu vanôôn sen vu baandoni be laam voon-anjo ond naambe omaaho ti ja ond me-le jimb e. ");
INSERT INTO mmo_vpl VALUES ("JN6_51","073_6_51","JHN","6","51","51","De sa vanôôn metumin sen sa vu baandoni be sa laam voon-anjo. Omaaho ti nambe ja vanôôn-anjo ond le mando metumin danggata osin danggata. De vanôôn sen saambu vuu-to ond sa laaliip, in saambu vu omaahonôôn pin in nambe sil mando metumin.” ");
INSERT INTO mmo_vpl VALUES ("JN6_52","073_6_52","JHN","6","52","52","Tombe hil Yuda yoo lanêêl sil nambe, “Nambe vaati sen omaahôô-ju bu laaliip-ambe yanggaa-jo?” ");
INSERT INTO mmo_vpl VALUES ("JN6_53","073_6_53","JHN","6","53","53","Tombe Yesu nêêl vu sil nambe, “Sa naanêêl keen vu ham naambe ham-ame angga Omaahonôôn Noow laaliip e, osin ham-ame naanum yite nihees e, ond ham-ame le mando metumin e. ");
INSERT INTO mmo_vpl VALUES ("JN6_54","073_6_54","JHN","6","54","54","Hil sen lanja sa laaliip osin daanum sa nihees-ato ond sil e mando metumin danggata, de vu busin taamusin sale aambiing-ambe sil e kandi jak. ");
INSERT INTO mmo_vpl VALUES ("JN6_55","073_6_55","JHN","6","55","55","In sa laaliip-anjo tu vanôôn keen osin sa nihees tu bel numin keen. ");
INSERT INTO mmo_vpl VALUES ("JN6_56","073_6_56","JHN","6","56","56","+ o 6:56 Jon 15:4-5; 1Jon 3:24*Om omaaho ti ja sa laaliip osin naanum sa nihees ond le mando hôôk sa, de sale mando hôôk yi. ");
INSERT INTO mmo_vpl VALUES ("JN6_57","073_6_57","JHN","6","57","57","Aamangg sen metumin danggakook-ato wiing-ambe sa laam, tombe sa nando metumin lak Mangg-ate niwêêk, om yik hil sen lanja saa-to ond sil e mando metumin jak sate niwêêk. ");
INSERT INTO mmo_vpl VALUES ("JN6_58","073_6_58","JHN","6","58","58","Ond manyinjo vanôôn sen vu baandoni be laam voon-ato, de me-nambe vanôôn sen bôôy hamate himbop-aso laya vu taaku lumbalaamb-ambe layimb-ato le, malis. Vanôôn-anjo nambe omaaho ti ja ond le mando metumin danggata osin danggata.” ");
INSERT INTO mmo_vpl VALUES ("JN6_59","073_6_59","JHN","6","59","59","Vakasin-anjo Yesu nêêl hôôk sen monanêêl tanasin hôôk dumb alo vu Kapenaum-ato. ");
INSERT INTO mmo_vpl VALUES ("JN6_60","073_6_60","JHN","6","60","60","Yesu-te hil ngeeyaata sen davu sapa yii-to lango vakasin-anju tombe lanêêl nambe, “Vakasin-anju nimeen lôôt, om lati lohvu nambe gango?” ");
INSERT INTO mmo_vpl VALUES ("JN6_61","073_6_61","JHN","6","61","61","Lemu Yesu yoo lak ni nambe yite hil lakaas ngeeyaata lôôt in vakasin-anju, om nêêl vu sil nambe, “Vakasin-anjo wiing-ambe ham ahem kalin a? ");
INSERT INTO mmo_vpl VALUES ("JN6_62","073_6_62","JHN","6","62","62","+ o 6:62 Jon 3:13; Sin 1:9-11*De ham angge naambe Omaahonôôn Noow jak-ambe naah baan sen nando bôôy-ato ond ham e naanêêl naambe vaati? ");
INSERT INTO mmo_vpl VALUES ("JN6_63","073_6_63","JHN","6","63","63","+ o 6:63 2Ko 3:6*De Vavi Vaambuung yoo navu metumin vu omaahonôôn, de yaningg naavi ond me-nahôôvu yiiy daka le, om vakasin sen soo aanêêl vu ham-anja ond saanêêl in nambe dôôvu hamate nôôn, osin bu metumin vu ham, ");
INSERT INTO mmo_vpl VALUES ("JN6_64","073_6_64","JHN","6","64","64","+ o 6:64 Jon 13:11*lemu ham vaalu me-awii-having e.” Yesu nêêl nambêênju in hil sen me-le lambiing gaving yii-to le, ond yoo lak sil anind munggin, osin omaaho sen navu naanêêl yi langaah-ambe hil lanôôh-ato ond Yesu lak ni having. ");
INSERT INTO mmo_vpl VALUES ("JN6_65","073_6_65","JHN","6","65","65","+ o 6:65 Jon 6:44*Tonde Yesu nêêl having nambe, “Yik danggakook-anja sen saanêêl vu ham lung la nambe omaaho ti me-yoo lohvu nambe naam vu sa malis e, Aamangg bu niwêêk vu yi ond mem.” ");
INSERT INTO mmo_vpl VALUES ("JN6_66","073_6_66","JHN","6","66","66","Yesu nêêl vakasin-anju om hil ngeeyaata sen davu sapa yii-to ond lavuuh yi de lalaah, de sil-ame lala having Yesu yesin laah e. ");
INSERT INTO mmo_vpl VALUES ("JN6_67","073_6_67","JHN","6","67","67","Tombe Yesu nêêl vu yite maanggêêm nomaayuuh-ambe laam yuuh-ato nambe, “De ham-ok, ham navu gavuuh sa gaving-ande ham ana?” ");
INSERT INTO mmo_vpl VALUES ("JN6_68","073_6_68","JHN","6","68","68","Le Simon Pita nêêl laah vu Yesu nambe, “Omaaho Bop, hey e ana vu lati? Vakasin metumin danggata yoo neep vu hong, ");
INSERT INTO mmo_vpl VALUES ("JN6_69","073_6_69","JHN","6","69","69","+ o 6:69 Mat 14:33; 16:16; Mak 1:24; Jon 1:49*om hey aawii-having hong osin hey alak ni lung la nambe Anutu-te Omaaho Vaambuung hong.” ");
INSERT INTO mmo_vpl VALUES ("JN6_70","073_6_70","JHN","6","70","70","Tombe Yesu nêêl laah vu sil nambe, “Saaholin ham nomaayuuh-ambe laam yuuh, le ham ti lohvu mamu nipaya.” ");
INSERT INTO mmo_vpl VALUES ("JN6_71","073_6_71","JHN","6","71","71","Vakasin-anjo nêêl lak Yudas sen Simon Iskaliot noow-ato ond maanggêêm nomaayuuh-ambe laam yuuh-ato ti, in ngaaho lak in navu bu Yesu dukana hil namand in nambe lanyiis-ambe jimb. ");
INSERT INTO mmo_vpl VALUES ("JN7_1","073_7_1","JHN","7","1","1","+ o 7:1 Jon 5:18*Lung laa tonde hil Yuda lawiingin nambe lanyiis Yesu be jimb, om nimbaya nambe me-gatup hôôk Yudia le, tombe la monatup hôôk Galili. ");
INSERT INTO mmo_vpl VALUES ("JN7_2","073_7_2","JHN","7","2","2","+ o 7:2 Lev 23:34*Tonde hil Yuda-te busin bop sen danêêl nambe busin numang-atêêto ngaaho lak, ");
INSERT INTO mmo_vpl VALUES ("JN7_3","073_7_3","JHN","7","3","3","om Yesu-te halindin lanêêl vu yi nambe, “Onggavuuh taakuu-jo de gana Yudia in gate hil lanji kul sen onawiing-anjôôto le. ");
INSERT INTO mmo_vpl VALUES ("JN7_4","073_7_4","JHN","7","4","4","Omaaho ti wiingin nambe biing banye jak ond me-nawiing va hôôk vunin e, om onawiing vaa-ja ond gana taato hong langaah-ambe hil lanji.” ");
INSERT INTO mmo_vpl VALUES ("JN7_5","073_7_5","JHN","7","5","5","+ o 7:5 Mat 13:55; Sin 1:14*Yik Yesu halindin-ame lawii-having yi having e ondeey lanêêl nambêênju. ");
INSERT INTO mmo_vpl VALUES ("JN7_6","073_7_6","JHN","7","6","6","+ o 7:6 Jon 2:4; 7:30*Tombe Yesu nêêl vu sil nambe, “Sate busin naahen, nganjo busin pin-anjo ham oote, ");
INSERT INTO mmo_vpl VALUES ("JN7_7","073_7_7","JHN","7","7","7","+ o 7:7 Jon 15:18*in hil pin vu voon-ame lalohvu nambe nind baya in ham lôôt e. Nganjo sak sil anind baya in sa lôôt, in sa naanêêl sil langaah nambe dawiing va nipaya. ");
INSERT INTO mmo_vpl VALUES ("JN7_8","073_7_8","JHN","7","8","8","Om ham oo ana balu-angge busin bop-anju, nganjo sak same le ana aangge busin bop-anju gaving e, in sate busin naahen.” ");
INSERT INTO mmo_vpl VALUES ("JN7_9","073_7_9","JHN","7","9","9","Nêêl vakasin-anjo vu sil atonde nando Galili. ");
INSERT INTO mmo_vpl VALUES ("JN7_10","073_7_10","JHN","7","10","10","Tombe Yesu halindin lala lalup in lanji busin bop vu Yelusalem, tonde sim Yesu yoo motaamuyin sil-ambe la valup, le me-taato yi langaah e, nganjo yoo la kaatokin. ");
INSERT INTO mmo_vpl VALUES ("JN7_11","073_7_11","JHN","7","11","11","+ o 7:11 Jon 11:56*Tonde hil Yuda davu salo yi hôôk busin bop-anju be dalingin nambe, “Omaahôô-juuto nando tana?” ");
INSERT INTO mmo_vpl VALUES ("JN7_12","073_7_12","JHN","7","12","12","Tombe hil davu pataalang ak yi lôôt, om vaalu danêêl nambe, “Yi omaaho nivasa,” de vaalu danêêl nambe, “Malis, navu tatuhin hil.” ");
INSERT INTO mmo_vpl VALUES ("JN7_13","073_7_13","JHN","7","13","13","+ o 7:13 Jon 9:22; 12:42; 19:38; 20:19*Lemu ti me-nêêl vakasin-anju lak yi laam langaah e, in layêênin silate hil Yuda vaalu. ");
INSERT INTO mmo_vpl VALUES ("JN7_14","073_7_14","JHN","7","14","14","Layi busin bop-anju be la lavuun lôôt, tonde Yesu valup-ambe lukala Anutu-te dumb bop alo be nêêl tanasin vu hil. ");
INSERT INTO mmo_vpl VALUES ("JN7_15","073_7_15","JHN","7","15","15","+ o 7:15 Mat 13:54; Luk 2:47*Tombe hil Yuda lavindis nambe, “Omaahôô-ju lak tanasin ani vu tana? Omaaho ti me-taahu yi le.” ");
INSERT INTO mmo_vpl VALUES ("JN7_16","073_7_16","JHN","7","16","16","+ o 7:16 Jon 12:49; 14:10*Le Yesu nêêl laah vu sil nambe, “Tanasin sen saanêêl vu ham-anja ond same soo sate va le, malis, nganjo omaaho sen wiing sa laam-ato yite vakasin. ");
INSERT INTO mmo_vpl VALUES ("JN7_17","073_7_17","JHN","7","17","17","Om omaaho ti wiingin nambe biing va nohvu Anutu ka ond le jak tanasin sen saanêêl-anjo dangga ni naambe laam vu Anutu keen, me, soo aanêêl lohvu sa kangg ond yik le jak ni. ");
INSERT INTO mmo_vpl VALUES ("JN7_18","073_7_18","JHN","7","18","18","+ o 7:18 Jon 5:41; 8:50*De omaaho ti yoo nanêêl vakasin nalohvu ka ond yoo wiingin gako haale jak. Lemu omaaho ti wiingin nambe gako omaaho sen wiing yi laam-ato haale jak, ond mem omaahôô-ju yoo monanêêl vakasin osin keen, de tatuhin ti me-neep vu yi le. ");
INSERT INTO mmo_vpl VALUES ("JN7_19","073_7_19","JHN","7","19","19","+ o 7:19 Sin 7:53; Lom 2:21-24*Mose vu tanasin nomaayuuh vu ham bôôy-ato, lemu ham-anja ti me-navu samu tanasin-anju le. Nambe tana sen ham nawiingin nambe anyiis sa be saanggimb?” ");
INSERT INTO mmo_vpl VALUES ("JN7_20","073_7_20","JHN","7","20","20","+ o 7:20 Jon 8:48,52; 10:20*Tombe hil-anju lanêêl laah vu yi nambe, “Mamu ti hôôvu hong. Lati wiingin nambe nyiis hong-ambe ganggimb?” ");
INSERT INTO mmo_vpl VALUES ("JN7_21","073_7_21","JHN","7","21","21","+ o 7:21 Jon 5:16*Le Yesu nêêl laah vu sil nambe, “Saawiing kul bopaata timuu-jo be ham pin avindis in. ");
INSERT INTO mmo_vpl VALUES ("JN7_22","073_7_22","JHN","7","22","22","+ o 7:22 Lev 12:3; Jen 17:9-13*De Mose nêêl nambe, ‘Ham galaah ham anim naavi,’ le gambum-anja Mose me-nêêl e, manyinja yoo vu hamate himbop-aso bôôy, de ham nalaah unoopasiv anind naavi hôôk busin sawaasin. ");
INSERT INTO mmo_vpl VALUES ("JN7_23","073_7_23","JHN","7","23","23","+ o 7:23 Jon 5:8-10,16*Ond ham nalaah unoopasiv anind naavi hôôk busin sawaasin in nambe ham-ame kalêêh Mose-te tanasin e, tonde saawiing omaaho ti ninaavi nivasa lak hôôk busin sawaasin, le nambe vaati sen ham ahem kalin vu sa? ");
INSERT INTO mmo_vpl VALUES ("JN7_24","073_7_24","JHN","7","24","24","+ o 7:24 Lev 19:15; Ais 11:3-4; Jon 8:15*Ham-ame naanêêl hil danjeen e, nganjo ham oo anjak vakasin danggakook ani vêêl e mem ham naanêêl.” ");
INSERT INTO mmo_vpl VALUES ("JN7_25","073_7_25","JHN","7","25","25","+ o 7:25 Jon 5:18*Tombe hil Yelusalem vaalu dalingin sil nambe, “Omaaho sen lawiingin nambe lanyiis-ato ond yii-ju? ");
INSERT INTO mmo_vpl VALUES ("JN7_26","073_7_26","JHN","7","26","26","Om angge, nanêêl vakasin naale langaah, lemu me-lanêêl vakasin ti lak yi le, in mak yêêv-aso lalak ni lung la nambe yi omaaho sen Anutu yoo holin yi vulôôt in nambe dôôvu yiiy-ato mava? ");
INSERT INTO mmo_vpl VALUES ("JN7_27","073_7_27","JHN","7","27","27","+ o 7:27 Jon 7:41; 9:29*Lemu omaahôô-ju yalak yite danggakook ani nambe vu voon, nganjo omaaho sen Anutu yoo holin yi vulôôt-ato naam ond yiiy pin e doosin yite dangga.” ");
INSERT INTO mmo_vpl VALUES ("JN7_28","073_7_28","JHN","7","28","28","+ o 7:28-29 Mat 11:27; Jon 8:55*Om Yesu nêêl tanasin hôôk Anutu-te dumb bop alo be nêêl osin niwêêk nambe, “Ke, ham alak sa ningg-ambe ham alak sate danggakook ani keen a? Lemu same yoo alaam lohvu sa kangg e, omaaho sen wiing sa laam-ato yi omaaho vakasin keen, lemu ham doosin yi. ");
INSERT INTO mmo_vpl VALUES ("JN7_29","073_7_29","JHN","7","29","29","De sak, ond sa lak ni, in sa nando having yi be wiing sa be sa laam-anjo.” ");
INSERT INTO mmo_vpl VALUES ("JN7_30","073_7_30","JHN","7","30","30","+ o 7:30 Jon 7:44; 8:20; 13:1*Tombe hil lawiingin nambe lanôôh yi lemu yite busin naahen, om omaaho ti me-lôôh nama lak yi le, malis. ");
INSERT INTO mmo_vpl VALUES ("JN7_31","073_7_31","JHN","7","31","31","+ o 7:31 Jon 2:23; 8:30; 10:42; 11:45; 12:11,42*Tonde hil ngeeyaata lawii-having yi be lanêêl nambe, “De omaaho sen Anutu yoo holin yi vulôôt-ato naam ond mak le biing taahu taahu osin niwêêk-ambe savok omaahôô-jute kul aniwêêk-ato na, me? Om mak yii-ju.” ");
INSERT INTO mmo_vpl VALUES ("JN7_32","073_7_32","JHN","7","32","32","Tombe hil Palisai lango de hil davu pataalang vakasin-anju lak Yesu, om kul vaha sen datung salivangin-ato silate yêêv-aso osin hil Palisai lawiing silate ahevaavu-so heey lala in nambe lanôôh Yesu. ");
INSERT INTO mmo_vpl VALUES ("JN7_33","073_7_33","JHN","7","33","33","+ o 7:33 Jon 13:33*Tombe Yesu nêêl nambe, “Yik sale mando gaving ham pasivdaka vêêl e mem sa naah vu omaaho sen wiing sa laam-ato, ");
INSERT INTO mmo_vpl VALUES ("JN7_34","073_7_34","JHN","7","34","34","+ o 7:34 Jon 8:21; 13:36; 17:24*de ham e mosalo sa, le ham-ame le naatovu sa le. De taaku sen sana mandôô-to ond ham-ame alohvu nambe ham ana le.” ");
INSERT INTO mmo_vpl VALUES ("JN7_35","073_7_35","JHN","7","35","35","Tombe hil Yuda yoo lakaas-ambe lanêêl vu sil nambe, “In navu na tana de yame naatovu yi le? Mak navu na vu yate hil vaalu sen dando Glik-ate taakuu-to in motaahu hil Glik-anju? ");
INSERT INTO mmo_vpl VALUES ("JN7_36","073_7_36","JHN","7","36","36","De sen nêêl nambe, ‘Ham oo le mosalo sa, lemu ham-ame le naatovu sa le,’ de nêêl ango nambe, ‘Taaku sen sana mandôô-to ond ham-ame alohvu nambe ham ana le,’ ond vakasin-anjo danggakook nambe vaati?” ");
INSERT INTO mmo_vpl VALUES ("JN7_37","073_7_37","JHN","7","37","37","+ o 7:37 Lev 23:36; Ais 55:1; Jon 4:10,14*Busin bop numang-ate busin navu jung na, tonde busin ti lakaneep ak ahus ond silate busin bopaata lôôt, tombe hôôk busin-anju Yesu naale be nêêl bopaata nambe, “Omaaho ti nambe lo bambôôv in bel ond yoo naam vu sa be naanum, ");
INSERT INTO mmo_vpl VALUES ("JN7_38","073_7_38","JHN","7","38","38","+ o 7:38 Ais 58:11; Sek 14:8*lohvu Anutu-te vakasin neep hôôk kaapiya nambe, ‘Omaaho ti nambe lopayo naam timu vu sa, ond bel metumin-ate ngeeyaata le bêêl gato vu lopayo be na.’” ");
INSERT INTO mmo_vpl VALUES ("JN7_39","073_7_39","JHN","7","39","39","+ o 7:39 Jon 16:7; 20:22; Sin 2:4*Vakasin-anjo Yesu nêêl lak Vavi Vaambuung sen navu bu naam vu hil sen londpayo la timu vu yii-to, le busin naahen om Vavi Vaambuung-ame lukalaam e, in Yesu me-kandi lak-ambe haale tu bop ak e de naahen. ");
INSERT INTO mmo_vpl VALUES ("JN7_40","073_7_40","JHN","7","40","40","+ o 7:40 Diu 18:15; Jon 6:14; Sin 3:22*Hil ngeeyaata lango vakasin-anju, tombe vaalu lanêêl nambe, “Keen, omaahôô-ju yi Anutu-te omaaho sen yiiy nanggin yii-to.” ");
INSERT INTO mmo_vpl VALUES ("JN7_41","073_7_41","JHN","7","41","41","+ o 7:41 Jon 4:29; 1:46; 7:52*De hil vaalu lanêêl nambe, “Manyinju omaaho sen Anutu yoo holin yi vulôôt in nambe dôôvu yiiy-ato.” Tonde vaalu lanêêl nambe, “Ôôye, omaaho sen Anutu yoo holin yi vulôôt-ato me-le naam vu Galili le. ");
INSERT INTO mmo_vpl VALUES ("JN7_42","073_7_42","JHN","7","42","42","+ o 7:42 2Sml 7:12; Saam 89:3-4; Mai 5:2; Mat 2:5-6*Vakasin sen neep hôôk Anutu-te kaapiyaa-to nêêl lung la nambe, ‘Omaaho sen Anutu yoo holin yi vulôôt-ato yite danggakook neep vu Devit, tombe le naam vu bayêên Betlehem sen Devit nando bôôy-ato.’” ");
INSERT INTO mmo_vpl VALUES ("JN7_43","073_7_43","JHN","7","43","43","+ o 7:43 Jon 9:16*Om hil laasuh sil la yuuh in Yesu, ");
INSERT INTO mmo_vpl VALUES ("JN7_44","073_7_44","JHN","7","44","44","+ o 7:44 Jon 7:30*tombe sil vaalu lawiingin nambe lanôôh Yesu, lemu omaaho ti me-lôôh nama lak yi le. ");
INSERT INTO mmo_vpl VALUES ("JN7_45","073_7_45","JHN","7","45","45","+ o 7:45 Jon 7:32*Tonde ahevaavu-so lalaah lalu-vu kul vaha sen datung salivangin-ato silate yêêv-aso osin hil Palisai, tombe lanêêl vu ahevaavu-so nambe, “Nambe vaati sen ham-ame hako omaahôô-ju laam e?” ");
INSERT INTO mmo_vpl VALUES ("JN7_46","073_7_46","JHN","7","46","46","+ o 7:46 Mak 1:22*Le ahevaavu-so lanêêl laah nambe, “Omaaho ti me-nakaas nambe omaahôô-ju bôôy e.” ");
INSERT INTO mmo_vpl VALUES ("JN7_47","073_7_47","JHN","7","47","47","Tombe Palisai-so lanêêl laah vu sil nambe, “Om peey e tatuhin ham having a? ");
INSERT INTO mmo_vpl VALUES ("JN7_48","073_7_48","JHN","7","48","48","+ o 7:48 Jon 12:42*Tonde hey yêêv-aso osin Palisai ond ham ahe nambe hey ti tana wii-having yi? Malis. ");
INSERT INTO mmo_vpl VALUES ("JN7_49","073_7_49","JHN","7","49","49","Lemu hil mali-malis sen dango Yesu lavaa-ju ond sil doosin Mose-te tanasin, om Anutu le biing-ambe sil lana mend nama.” ");
INSERT INTO mmo_vpl VALUES ("JN7_50","073_7_50","JHN","7","50","50","+ o 7:50 Jon 3:1-2; 19:39*Tombe sil ti Nikotemus sen la vu Yesu bôôy-ato ond nêêl vu sil nambe, ");
INSERT INTO mmo_vpl VALUES ("JN7_51","073_7_51","JHN","7","51","51","+ o 7:51 Diu 1:16*“Yame gango omaaho ti-te vakasin osin yame anjak va sen wiing-ato dangga ni le, de yaambu nivaane vu yi malis amu, ond mak lohvu yate tanasin nêêl a?” ");
INSERT INTO mmo_vpl VALUES ("JN7_52","073_7_52","JHN","7","52","52","+ o 7:52 Jon 7:41-42*Tombe lanêêl laah vu Nikotemus nambe, “Mak hong-anja hong vu Galili having a? Onaasevin Anutu-te vakasin sen neep hôôk kaapiyaa-to nivasa le mem gale ganjak ni naambe hil sen danêêl Anutu-te vakasin langaah-ato ti me-le naam vu Galili le.” ");
INSERT INTO mmo_vpl VALUES ("JN7_53","073_7_53","JHN","7","53","53","Tonde sil pin lavuuh taale be lalaah sil ambaand ti ti. ");
INSERT INTO mmo_vpl VALUES ("JN8_1","073_8_1","JHN","8","1","1","+ o 8:1 Luk 21:37*Tonde Yesu lak-ambe la kandu Oliv, ");
INSERT INTO mmo_vpl VALUES ("JN8_2","073_8_2","JHN","8","2","2","de samiinaanôôn atombe laah hato Anutu-te dumb bop alo, tombe hil pin lala vu yi, om hato nando be motaahu sil hôôk tanasin. ");
INSERT INTO mmo_vpl VALUES ("JN8_3","073_8_3","JHN","8","3","3","Tombe tanasin dangga-so osin hil Palisai-so ond lako vêêh ti, yik vêêh-anju hil layi de wiing baayamb om sil lalaah naale lavuun, ");
INSERT INTO mmo_vpl VALUES ("JN8_4","073_8_4","JHN","8","4","4","tonde lanêêl vu Yesu nambe, “Kaputung, vêêh-anja wiing baayamb-ambe hil latovu yi. ");
INSERT INTO mmo_vpl VALUES ("JN8_5","073_8_5","JHN","8","5","5","+ o 8:5 Lev 20:10; Diu 22:22-24*Ond Mose nêêl vu yiiy hôôk tanasin nambe vêêh nambêênja yaanyiis ak tatuuh-ambe jimb. De hong-ok, gale naanêêl vaati?” ");
INSERT INTO mmo_vpl VALUES ("JN8_6","073_8_6","JHN","8","6","6","+ o 8:6 Mat 22:15*Sil lanêêl nambêênju in nambe sahi Yesu naambe naanêêl vakasin na paya ond lambiing vakasin vu yi, lemu Yesu dundak-ambe nando mosalêêh ngaanggis ak nama kapis, ");
INSERT INTO mmo_vpl VALUES ("JN8_7","073_8_7","JHN","8","7","7","+ o 8:7 Diu 17:7*de sil oo mondalingin lôôt, tombe vêêl lu lak-ambe nêêl vu sil nambe, “Om ham-anja ti me-nawiing va nipaya bôôy e, ond mem yoo gaate tatuuh jakana vêêh-anju naamunggin.” ");
INSERT INTO mmo_vpl VALUES ("JN8_8","073_8_8","JHN","8","8","8","Tonde dundak-ambe mosalêêh ngaanggis yesin laah. ");
INSERT INTO mmo_vpl VALUES ("JN8_9","073_8_9","JHN","8","9","9","+ o 8:9 Mat 22:22*Sil lango vakasin-anju tombe sil ti ti davu seelin-ambe lato dala voon, himbop bop-aso yoo lamunggin tonde hil vaalu taamuyin sil. Sil lavuuh Yesu de yoo ti nando, de vêêh-anju yoo naahen naale. ");
INSERT INTO mmo_vpl VALUES ("JN8_10","073_8_10","JHN","8","10","10","Tombe Yesu vêêl lu lak-ambe nêêl vu vêêh nambe, “Hil-anjôôto lala tana? De ti me-nêêl nambe lambu nyevahaan vu hong e?” ");
INSERT INTO mmo_vpl VALUES ("JN8_11","073_8_11","JHN","8","11","11","+ o 8:11 Jon 5:14*Le vêêh-anjuuto nêêl nambe, “Omaaho Bop, malis.” Tombe Yesu nêêl nambe, “Yik sa having, same le naanêêl naambe lambu nyevahaan vu hong e, om gana de game gambiing nipaya jesin naah e.” ");
INSERT INTO mmo_vpl VALUES ("JN8_12","073_8_12","JHN","8","12","12","+ o 8:12 Ais 49:6; Jon 1:4-9; 9:5; 12:46*Tonde Yesu nêêl vakasin ango vu hil nambe, “Sak sa kin tumin voon-ate. Omaaho ti taamuyin sa ond me-le na hôôk mekanu le, malis, le na osin melangaah metumin-ate.” ");
INSERT INTO mmo_vpl VALUES ("JN8_13","073_8_13","JHN","8","13","13","Tombe hil Palisai-so lanêêl vu nambe, “Goo navu tatekin gate danggakook om ganêêm vakasin-anja me-keen e.” ");
INSERT INTO mmo_vpl VALUES ("JN8_14","073_8_14","JHN","8","14","14","+ o 8:14 Jon 5:31-32; 7:28; 9:29*Le Yesu nêêl laah vu sil nambe, “Ôôye, soo navu tatekin sate danggakook, lemu sa naanêêl vakasin keen, in dangga nambe taaku sen sa nando be sa laam-ato ond sa lak ni. Tonde taaku sen sale anaah-ato ond yik sa lak ni having, lemu ham ond ham doosin taaku sen sa nando be sa laam-ato, de yik ham doosin taaku sen sale anaah-ato having. ");
INSERT INTO mmo_vpl VALUES ("JN8_15","073_8_15","JHN","8","15","15","+ o 8:15 Jon 7:24; 12:47*Tonde ham ond ham navu sahi hil lohvu ham voon oo kam, nganjo sak same navu sahi omaaho ti-te vakasin e. ");
INSERT INTO mmo_vpl VALUES ("JN8_16","073_8_16","JHN","8","16","16","+ o 8:16 Jon 5:30; 8:29*Lemu naambe sa sahi omaaho ti-te vakasin ond sale sahi nivalok, in me-soo timu le, nganjo Aamangg sen wiing sa be sa laam-ato ond nando having sa. ");
INSERT INTO mmo_vpl VALUES ("JN8_17","073_8_17","JHN","8","17","17","+ o 8:17 Diu 17:6; 19:15*Hamate tanasin ti neep nambe omaaho yuuh daanêêl vakasin noh ti ond yuuhate vakasin nôôn keen. ");
INSERT INTO mmo_vpl VALUES ("JN8_18","073_8_18","JHN","8","18","18","+ o 8:18 1; Jon 5:9*De sak sa naanêêl sate dangga langaah, de Aamangg sen wiing sa laam-ato ond yik nanêêl sate vakasin langaah having.” ");
INSERT INTO mmo_vpl VALUES ("JN8_19","073_8_19","JHN","8","19","19","+ o 8:19 Jon 14:7*Tombe lalingin Yesu nambe, “Mom nando tana?” Le Yesu nêêl laah nambe, “Ham doosin sa, de ham doosin sate Aamangg having. Nambe ham anjak sa ningg ond ham e anjak sate Mangg ani gaving.” ");
INSERT INTO mmo_vpl VALUES ("JN8_20","073_8_20","JHN","8","20","20","+ o 8:20 Jon 7:30*Yesu nêêl vakasin-anjo ond monanêêl tanasin hôôk Anutu-te dumb alo ti sen hil datung salivangin hôôk-ato, lemu vaheey-ame lalôôh yi le, in yite busin oo naahen. ");
INSERT INTO mmo_vpl VALUES ("JN8_21","073_8_21","JHN","8","21","21","+ o 8:21 Jon 7:34,36; 13:33*Tombe Yesu nêêl vu sil laah nambe, “Sana de ham e salo sa, tonde hamate nipaya le nanjip-ambe ham anggimb osin, de ham-ame alohvu nambe ana taaku sen sa nalaa-ju le.” ");
INSERT INTO mmo_vpl VALUES ("JN8_22","073_8_22","JHN","8","22","22","+ o 8:22 Jon 7:35*Tombe hil Yuda lanêêl nambe, “Mak yoo navu nyiis yi be jimb mava, ondeey nêêl nambe ‘Ham-ame alohvu nambe ana taaku sen sanaa-ju le.’” ");
INSERT INTO mmo_vpl VALUES ("JN8_23","073_8_23","JHN","8","23","23","+ o 8:23 Jon 3:31*Tonde Yesu nêêl vu sil nambe, “Ham vu voon, de sa vu baandoni. Ham omaahonôôn vu voon-anjo de sak, same vu voon-anjo le. ");
INSERT INTO mmo_vpl VALUES ("JN8_24","073_8_24","JHN","8","24","24","Om yik saanêêl vu ham lung laa-to nambe hamate nipaya le nanjip-ambe ham anggimb osin, in dangga nambe ham-ame ambiing gaving naambe saa-jo le, ond hamate nipaya yoo le nanjip vu ham lôôt-ambe ham anggimb osin.” ");
INSERT INTO mmo_vpl VALUES ("JN8_25","073_8_25","JHN","8","25","25","Tombe lalingin nambe, “Om hong lati?” Le Yesu nêêl vu sil nambe, “Yik sa omaaho sen soo monaanêêl langaah vu ham vu munggin-ambe tok laam gêên-anjo. ");
INSERT INTO mmo_vpl VALUES ("JN8_26","073_8_26","JHN","8","26","26","+ o 8:26 Jon 7:28*De sate vakasin sen sa naanêêl vu ham osin sa sahi ham jak-ato ond ngeeyaata neep, lemu omaaho sen wiing sa be sa laam-ato ond yi omaaho osin vakasin nôôn keen, om vakasin pin sen sa hango vu yii-to ond sa naanêêl langaah vu omaahonôôn vu voon-anjo.” ");
INSERT INTO mmo_vpl VALUES ("JN8_27","073_8_27","JHN","8","27","27","Vakasin sen Yesu nanêêl nambe omaaho sen wiing yi laam-ato ond nanêêl lak Mangganaan Anutu, le sil doosin. ");
INSERT INTO mmo_vpl VALUES ("JN8_28","073_8_28","JHN","8","28","28","+ o 8:28 Jon 3:14; 5:19*Om nêêl vu sil nambe, “Taamusin e ham e gasi Omaahonôôn Noow jakana, tombe mem hôôk busin-anju ham e anjak ni naambe yik saa-jo, in same yoo naawiing vati lohvu sa kangg e, malis, yik soo naanêêl va sen Aamangg taahu saa-to. ");
INSERT INTO mmo_vpl VALUES ("JN8_29","073_8_29","JHN","8","29","29","+ o 8:29 Jon 8:16; 16:32*De Aamangg sen wiing sa be sa laam-ato ond yik nando having sa, de me-havuuh sa be soo ti nando le, malis, in soo monaawiing va sen nayi nivasaa-to lak busin pin.” ");
INSERT INTO mmo_vpl VALUES ("JN8_30","073_8_30","JHN","8","30","30","+ o 8:30 Jon 7:31*Yesu nêêl nambêênju tombe hil ngeeyaata londpayo la timu vu yi. ");
INSERT INTO mmo_vpl VALUES ("JN8_31","073_8_31","JHN","8","31","31","Tombe Yesu nêêl vu hil Yuda sen lawii-having yi lung laa-to nambe, “Naambe ham naapuvu sate vakasin niwêêk ond ham atu sate hil keen, ");
INSERT INTO mmo_vpl VALUES ("JN8_32","073_8_32","JHN","8","32","32","de ham e anjak vakasin keen ani, tombe vakasin keen le nôôh ham vêêl in ham mando nivasa.” ");
INSERT INTO mmo_vpl VALUES ("JN8_33","073_8_33","JHN","8","33","33","+ o 8:33 Mat 3:9*Tombe sil lanêêl laah vu yi nambe, “Hey-anjo Abalaam-ate hil vu taamusin hey. Hey-ame aatu omaaho ti-te hil kul vaha malis amu busin ti le. Le nambe tana sen ganêêl nambe vakasin keen le nôôh hey vêêl-anjo?” ");
INSERT INTO mmo_vpl VALUES ("JN8_34","073_8_34","JHN","8","34","34","+ o 8:34 Lom 6:16,20; 2Pi 2:19*Le Yesu nêêl laah vu sil nambe, “Sa naanêêl keen lôôt vu ham naambe hil pin sen dawiing va nipayaa-to, ond sil latu va nipaya-te hil kul vaha malis amu. ");
INSERT INTO mmo_vpl VALUES ("JN8_35","073_8_35","JHN","8","35","35","De hil kul vaha ond me-le mando gaving yite yêêv lôôt e, malis, noow ond mem yoo le mando gaving lôôt. ");
INSERT INTO mmo_vpl VALUES ("JN8_36","073_8_36","JHN","8","36","36","Om Anutu Noow nambe nôôh ham vêêl in nambe ham mando nivasa ond ham oo le mando nivasa keen. ");
INSERT INTO mmo_vpl VALUES ("JN8_37","073_8_37","JHN","8","37","37","+ o 8:37 Jon 5:18*De sa lak ni nambe Abalaam-ate hil vu taamusin ham, le ma de ham awiingin nambe anyiis sa be saanggimb, in sate vakasin-ame lukala ham alompayo le. ");
INSERT INTO mmo_vpl VALUES ("JN8_38","073_8_38","JHN","8","38","38","Va sen saahe vu Aamangg lung laa-to ond sa naanêêl-anjo, de ham ond ham nawiing va sen ham hango de mom nêêl-ato.” ");
INSERT INTO mmo_vpl VALUES ("JN8_39","073_8_39","JHN","8","39","39","+ o 8:39 Mat 3:9*Tombe sil lanêêl laah vu Yesu nambe, “Heyate aamangg ond Abalaam.” Le Yesu nêêl vu sil nambe, “Abalaam-ate hil vu taamusin ham keen ond ham e ambiing va naambe sen Abalaam wiing-ato. ");
INSERT INTO mmo_vpl VALUES ("JN8_40","073_8_40","JHN","8","40","40","De sa tatekin vakasin keen pin sen sa hango vu Anutuu-to vu ham, le gêên ham awiingin nambe anyiis sa be saanggimb, lemu Abalaam-ame wiing nambêênja le, ");
INSERT INTO mmo_vpl VALUES ("JN8_41","073_8_41","JHN","8","41","41","+ o 8:41 Diu 32:6; Ais 63:16; 64:8*nganjo ham oo nawiing mom-ate kul.” Tombe lanêêl laah vu nambe, “Vêêh baayamb ti me-noondin hey e, yik hey Aamangg Anutu timu.” ");
INSERT INTO mmo_vpl VALUES ("JN8_42","073_8_42","JHN","8","42","42","+ o 8:42 1; Jon 5:1; Jon 16:28*Tombe Yesu nêêl vu sil nambe, “Hamate mom Anutu keen ond ham ahem e gaving sa, in sa vu Anutu be sa laam nandôô-jo, de same yoo alaam lohvu sa kangg e, malis, Anutu wiing sa be sa laam. ");
INSERT INTO mmo_vpl VALUES ("JN8_43","073_8_43","JHN","8","43","43","+ o 8:43 Lom 8:7*Le nambe vaati sen ham doosin sate vakasin? Om danggakook-anjo nambe ham alompayo nimbaya in sate vakasin. ");
INSERT INTO mmo_vpl VALUES ("JN8_44","073_8_44","JHN","8","44","44","+ o 8:44 1; Jon 3:8*Hamate mom Saalang, om va sen naale hôôk hamate mom alopayôô-to ond ham oo nawiingin nambe ambiing lôôt. De vu munggin ond yoo nayiis omaahonôôn-ambe dayimb, tonde me-navu taamuyin vakasin keen e, in vakasin keen ti me-neep vu yi le. Nganjo vakasin tatuhin ond mem yoo yite va nivalok, in yi omaaho yoo navu tatuhin vakasin, de yi tu vakasin tatuhin mangganaan nivalok, ");
INSERT INTO mmo_vpl VALUES ("JN8_45","073_8_45","JHN","8","45","45","lemu sak sa naanêêl vakasin keen ondeey ham-ame awii-having sa le. ");
INSERT INTO mmo_vpl VALUES ("JN8_46","073_8_46","JHN","8","46","46","+ o 8:46 2Ko 5:21; 1Pi 2:22; 1Jon 3:5*De ham ti tana tovu sanêêngg nipaya ti ond naanêêl langaah, lemu naambe sa naanêêl vakasin keen ond nambe vaati sen ham-ame awii-having sa le? ");
INSERT INTO mmo_vpl VALUES ("JN8_47","073_8_47","JHN","8","47","47","+ o 8:47 Jon 18:37; 1Jon 4:6*In Anutu-te noondin ond yoo dango Anutu-te vakasin, lemu ham ond Anutu me-yite noondin ham e, om ham-ame nango yite vakasin e.” ");
INSERT INTO mmo_vpl VALUES ("JN8_48","073_8_48","JHN","8","48","48","+ o 8:48 Mak 3:21-22; Jon 7:20*Tombe hil Yuda lanêêl laah vu Yesu nambe, “De. Hey naanêêl nambe hong Samaalia ti, de mamu nipaya ti hôôvu hong, ond yik hey aanêêl lohvu.” ");
INSERT INTO mmo_vpl VALUES ("JN8_49","073_8_49","JHN","8","49","49","Tombe Yesu nêêl laah vu sil nambe, “Sak mamu nipaya ti me-hôôvu sa le, malis, soo nako Mangg haale lak, le ham naanggôôl sa. ");
INSERT INTO mmo_vpl VALUES ("JN8_50","073_8_50","JHN","8","50","50","+ o 8:50 Jon 5:41*Sak same naawiingin nambe soo gako sa haalengg ak e, nganjo omaaho ti yoo navu sahi sate vakasin-ambe nako sa haalengg ak. ");
INSERT INTO mmo_vpl VALUES ("JN8_51","073_8_51","JHN","8","51","51","+ o 8:51 Jon 5:24; 6:40,47*Om sa naanêêl keen vu ham naambe omaaho ti nambe samu sate vakasin nivasa ond me-le jimb-ambe na valok-ate le.” ");
INSERT INTO mmo_vpl VALUES ("JN8_52","073_8_52","JHN","8","52","52","Tombe hil Yuda lanêêl vu nambe, “Gêên hey alak ni nambe mamu nipaya hôôvu hong, in Abalaam having hil vaalu sen danêêl Anutu-te vakasin langaah-ato ond layimb lung la, lemu ganêêl nambe omaaho ti samu gate vakasin nivasa ond me-le jimb-ambe na valok-ate le. ");
INSERT INTO mmo_vpl VALUES ("JN8_53","073_8_53","JHN","8","53","53","+ o 8:53 Jon 4:12*Nambe vaatii-jo? Mak osavok heyate himbop bôôy Abalaam a? De Abalaam yimb lung laa-to, tonde hil sen danêêl Anutu-te vakasin langaah layimb having-ato, lemu goo gawiingin nambe savok lati na?” ");
INSERT INTO mmo_vpl VALUES ("JN8_54","073_8_54","JHN","8","54","54","Le Yesu nêêl laah vu sil nambe, “Soo gako sa haalengg ak ond sa haalengg e naambe va malis, lemu sate Mangg sen ham nanêêl nambe hamate Anutuu-to ond yoo nako sa haalengg ak. ");
INSERT INTO mmo_vpl VALUES ("JN8_55","073_8_55","JHN","8","55","55","+ o 8:55 Mat 11:27; Jon 7:28-29*Lemu ham-ame alak Mangg ani le, nganjo sak sa lak ni lung la, om sa naanêêl naambe sa doosin yi, ond sale omaaho tatuhin naambe ham-anja, le ma de sa lak ni lung la be sa navu samu yite vakasin nivasa lôôt. ");
INSERT INTO mmo_vpl VALUES ("JN8_56","073_8_56","JHN","8","56","56","Tonde hamate himbop Abalaam ond lopayo nivasa lôôt in nambe ji sate busin, om yi tombe pêêlis lôôt.” ");
INSERT INTO mmo_vpl VALUES ("JN8_57","073_8_57","JHN","8","57","57","Tombe hil Yuda lanêêl vu nambe, “Gate ta doo-yuuh-ambe nomaayuuh-ame lung la le, de mak gahe mem ak Abalaam a? Otatuhin.” ");
INSERT INTO mmo_vpl VALUES ("JN8_58","073_8_58","JHN","8","58","58","+ o 8:58 Jon 1:1*Tombe Yesu nêêl vu sil nambe, “Sa naanêêl keen vu ham naambe Abalaam tangganaan-ame hako yi le, de sa nando munggin.” ");
INSERT INTO mmo_vpl VALUES ("JN8_59","073_8_59","JHN","8","59","59","+ o 8:59 Jon 10:31*Tombe sil lalôôh tatuuh ak in nambe lanyiis Yesu be jimb, le ma de Yesu hôôpis, tonde havuuh Anutu-te dumb bop-ambe hato la voon. ");
INSERT INTO mmo_vpl VALUES ("JN9_1","073_9_1","JHN","9","1","1","Yesu valu-la le yi omaaho ti tangganaan oo hako osin mekanu, ");
INSERT INTO mmo_vpl VALUES ("JN9_2","073_9_2","JHN","9","2","2","+ o 9:2 Eks 20:5; Esi 18:20; Luk 13:2,4*tombe Yesu-te maanggêêm-aso lalingin yi in omaaho mekanuu-to nambe, “Kaputung, lati wiing va nipaya? Omaahôô-ju wiing me mangganaan ayuuh tangganaan lawiing ondeey tangganaan hako osin mekanu?” ");
INSERT INTO mmo_vpl VALUES ("JN9_3","073_9_3","JHN","9","3","3","+ o 9:3 Jon 11:4*Tombe Yesu nêêl laah nambe, “Ôôye, omaahôô-ju me-wiing vati paya le, de tangganaan ayuuh mangganaan-ame lawiing vati paya ondeey tangganaan hako nambêênjo le. Nganjo vaa-ju wiingin nambe taato Anutu-te niwêêk nanjip langaah jak omaahôô-ju. ");
INSERT INTO mmo_vpl VALUES ("JN9_4","073_9_4","JHN","9","4","4","+ o 9:4 Jon 5:17,20; 11:9; Jon 12:35*Om yaambiing omaaho sen wiing sa laam-ato yite kul pavis hôôk langaah, in busin dôôk ond yame aalohvu nambe yaambiing kul e. ");
INSERT INTO mmo_vpl VALUES ("JN9_5","073_9_5","JHN","9","5","5","+ o 9:5 Jon 8:12*De lohvu busin sen sa nando voon-anjôôto ond voon-ate kin tumin sa.” ");
INSERT INTO mmo_vpl VALUES ("JN9_6","073_9_6","JHN","9","6","6","+ o 9:6 Mak 8:23*Yesu nêêl nambêênju tonde kasuv nyekaakôôs lukala ngaanggis-ambe hateel-ambe tu panyêês ak, tonde hako panyêês-anju be likin ak omaahôô-ju mekaalus, ");
INSERT INTO mmo_vpl VALUES ("JN9_7","073_9_7","JHN","9","7","7","+ o 9:7 2King 5:10*tonde nêêl vu nambe, “Gana ganjipis hôôk betum Siloam.” Yaanggilin haale Siloam-anju naambe wiing-ambe la. Om la lipis yi be me tum tombe mem yi taaku de lo-hato. ");
INSERT INTO mmo_vpl VALUES ("JN9_8","073_9_8","JHN","9","8","8","Tombe yite hil sen sil ambaand timuu-to osin hil sen layi de navu kataangg hil in va bôôy-ato lalingin nambe, “Nambe vaatii-jo? Mak omaaho sen yoo nando mokataangg hil in va ond yii-ju?” ");
INSERT INTO mmo_vpl VALUES ("JN9_9","073_9_9","JHN","9","9","9","Tonde hil vaalu lanêêl nambe, “Êê-e, yik yii-ju.” De vaalu lanêêl nambe, “Malis, manyinju omaaho ango yoow, lemu yuuh amend neep ti.” Le omaahôô-ju yoo nêêl nambe, “Yik saa-jo.” ");
INSERT INTO mmo_vpl VALUES ("JN9_10","073_9_10","JHN","9","10","10","Tombe lalingin nambe, “De vaati wiing gamem-ambe tum?” ");
INSERT INTO mmo_vpl VALUES ("JN9_11","073_9_11","JHN","9","11","11","Le nêêl laah vu sil nambe, “Omaaho sen danêêl nambe Yesuu-to ond hateel nyekasuvin having ngaanggis-ambe tu panyêês ak, tombe likin ak sa mengg, tonde nêêl vu sa nambe, ‘Gana ganjipis hong hôôk betum Siloam.’ Tombe sala be saalipis tomem sa mengg tum-ambe saahe taaku.” ");
INSERT INTO mmo_vpl VALUES ("JN9_12","073_9_12","JHN","9","12","12","Tombe lalingin yi nambe, “Omaahôô-ju nando tana?” Le nêêl nambe, “Bey, sa doosin.” ");
INSERT INTO mmo_vpl VALUES ("JN9_13","073_9_13","JHN","9","13","13","Tombe sil lako omaaho sen me nivasa lak-anjôôto be lala vu hil Palisai, ");
INSERT INTO mmo_vpl VALUES ("JN9_14","073_9_14","JHN","9","14","14","+ o 9:14 Luk 13:14*in Yesu hateel panyêês-ambe wiing omaahôô-ju me tum hôôk busin sawaasin. ");
INSERT INTO mmo_vpl VALUES ("JN9_15","073_9_15","JHN","9","15","15","Om Palisai-so lalingin omaahôô-ju laah nambe, “Vaati wiing-ambe gamem tum-ambe onahe taakuu-ja?” Le nêêl vu sil nambe, “Likin panyêês ak sa mengg-ande saalipis, tomem sa mengg tum-ambe saahe taaku.” ");
INSERT INTO mmo_vpl VALUES ("JN9_16","073_9_16","JHN","9","16","16","+ o 9:16 Jon 3:2; 9:31-33; 7:43*Tombe Palisai heey lanêêl nambe, “Omaahôô-ju nawiing busin sawaasin paya, om Anutu me-wiing yi laam e.” Lemu sil vaalu lanêêl nambe, “Omaaho nipaya ti ond me-lohvu nambe biing taahu taahu osin niwêêk naambêênju le.” Tombe sil laasuh sil la lu yuuh. ");
INSERT INTO mmo_vpl VALUES ("JN9_17","073_9_17","JHN","9","17","17","+ o 9:17 Jon 4:19*Tombe sil lalingin omaaho sen mekanu bôôy-ato yesin laah nambe, “Omaaho sen wiing-ambe gamem tum-ato ond gakam vu nambe yi lati? Onaanêêl e.” Le nêêl nambe, “Yi omaaho sen nanêêl Anutu-te vakasin langaah-ato.” ");
INSERT INTO mmo_vpl VALUES ("JN9_18","073_9_18","JHN","9","18","18","Omaahôô-ju mekanu bôôy de gêên ond me tum-ambe yi taaku, lemu hil Yuda me-lawii-having nambe mekanu le, om lateey omaahôô-ju mangganaan ayuuh tangganaan lalaam, ");
INSERT INTO mmo_vpl VALUES ("JN9_19","073_9_19","JHN","9","19","19","tombe lalingin yuuh nambe, “Muuh noom-anjo? De manêêl nambe tangganaan hako yi osin mekanu? Le nambe vaati sen me tum-ambe nayi taaku gêên-anjo?” ");
INSERT INTO mmo_vpl VALUES ("JN9_20","073_9_20","JHN","9","20","20","Le mangganaan ayuuh tangganaan lanêêl laah vu sil nambe, “Êê-e, haay alak ni nambe haay noongg sen tangganaan hako yi osin mekanuu-to ond yik yii-jo, ");
INSERT INTO mmo_vpl VALUES ("JN9_21","073_9_21","JHN","9","21","21","lemu vaati wiing-ambe nayi taaku gêên-anjo ond haay doosin, tonde omaaho sen wiing-ambe me tum-anjo ond haay doosin having, om ham oo anjingin vu yi, in bop ak lung la om yoo le naanêêl vu ham.” ");
INSERT INTO mmo_vpl VALUES ("JN9_22","073_9_22","JHN","9","22","22","+ o 9:22 Jon 7:13*Mangganaan ayuuh tangganaan layêênin hil Yuda ondeey yuuh lanêêl nambêênju, in hil Yuda lanjôôy vakasin lung la nambe omaaho ti naanêêl langaah naambe Yesu yi omaaho sen Anutu yoo holin yi vulôôt-ato ond sil gatiiy na mando nanyendangga. ");
INSERT INTO mmo_vpl VALUES ("JN9_23","073_9_23","JHN","9","23","23","Yik danggakook-anjo ondeey tangganaan ayuuh mangganaan lanêêl nambe, “Bop ak lung la om ham oo anjingin vu yi.” ");
INSERT INTO mmo_vpl VALUES ("JN9_24","073_9_24","JHN","9","24","24","+ o 9:24 Jos 7:19*Om lateey omaaho sen bôôy mekanuu-to balon ango yesin-ambe lanêêl vu nambe, “Onggako Anutu haale jak, in omaahôô-ju ond hey alak ni nambe omaaho nipaya.” ");
INSERT INTO mmo_vpl VALUES ("JN9_25","073_9_25","JHN","9","25","25","Tombe nêêl laah vu sil nambe, “Yi omaaho nipaya me malis, same alak ni le, nganjo timuu-jo sa lak ni nambe bôôy ond sa mekanu, lemu gêên ond sa naahe taaku.” ");
INSERT INTO mmo_vpl VALUES ("JN9_26","073_9_26","JHN","9","26","26","Tombe lalingin yi nambe, “Wiing vaati vu hong? Wiing nambe vaati tombe gamem tum?” ");
INSERT INTO mmo_vpl VALUES ("JN9_27","073_9_27","JHN","9","27","27","Le nêêl laah vu sil nambe, “Saanêêl vu ham lung laa-to, le ham-ame hangoyin e, om nambe vaati sen ham awiingin nambe gango naah? Mak ham awiingin nambe naatu yite hil gaving a?” ");
INSERT INTO mmo_vpl VALUES ("JN9_28","073_9_28","JHN","9","28","28","Tombe lanêêl yi pale nambe, “Hong amu mem yite hong, nganjo hey ond Mose-te hey, ");
INSERT INTO mmo_vpl VALUES ("JN9_29","073_9_29","JHN","9","29","29","+ o 9:29 Jon 8:14*in hey alak ni lung la nambe Mose ond Anutu vakaas having yi, lemu omaahôô-ju ond hey doosin yite danggakook.” ");
INSERT INTO mmo_vpl VALUES ("JN9_30","073_9_30","JHN","9","30","30","Le omaahôô-juuto nêêl laah vu sil nambe, “Nambe vaatii-jo, ham doosin yite danggakook, lemu wiing-ambe sa mengg tum. ");
INSERT INTO mmo_vpl VALUES ("JN9_31","073_9_31","JHN","9","31","31","+ o 9:31 Saam 34:15; 66:18; Ais 1:15; Pro 15:29*De yiiy oo alak ni nambe Anutu me-nango hil sen dawiing nipayaa-to lavand e, lemu naambe omaaho ti yoo nayêênin vu Anutu osin navu sapa yite vakasin lôôt, ond Anutu yoo nango lava. ");
INSERT INTO mmo_vpl VALUES ("JN9_32","073_9_32","JHN","9","32","32","Tonde vu bôôy ond vakasin ti me-neep nambe omaaho ti tangganaan hako osin mekanu de omaaho ango me-wiing-ambe me tum e. ");
INSERT INTO mmo_vpl VALUES ("JN9_33","073_9_33","JHN","9","33","33","+ o 9:33 Jon 9:16*Om naambe Anutu me-biing omaahôô-ju naam e, ond me-lohvu nambe me-le biing vati le.” ");
INSERT INTO mmo_vpl VALUES ("JN9_34","073_9_34","JHN","9","34","34","+ o 9:34 Saam 51:5; Jon 9:2*Tombe lanêêl laah vu nambe, “Tam hako hong osin va nipaya lôôt, le gawiingin nambe tatekin tanasin vu hey a?” Lanêêl nambêênju tonde latiiy la nanyendangga. ");
INSERT INTO mmo_vpl VALUES ("JN9_35","073_9_35","JHN","9","35","35","Tombe Yesu hangoyin nambe latiiy omaahôô-juuto la, om tovu yi tombe nêêl vu nambe, “Galompayo wii-having Omaahonôôn Noow a?” ");
INSERT INTO mmo_vpl VALUES ("JN9_36","073_9_36","JHN","9","36","36","Le nêêl laah nambe, “O Omaaho Bop, Omaahonôôn Noow-anju yi lati? Onaanêêl vu sa le mem sale aambiing gaving yi.” ");
INSERT INTO mmo_vpl VALUES ("JN9_37","073_9_37","JHN","9","37","37","+ o 9:37 Jon 4:26*Tombe Yesu nêêl vu nambe, “Gahe yi lung laa-to, yik sa sen sa nakaas having hong-anjo.” ");
INSERT INTO mmo_vpl VALUES ("JN9_38","073_9_38","JHN","9","38","38","Tombe omaahôô-ju nêêl nambe, “Omaaho Bop, saawii-having.” Tonde hatung kaatu vu Yesu in nambe gako haale jak. ");
INSERT INTO mmo_vpl VALUES ("JN9_39","073_9_39","JHN","9","39","39","+ o 9:39 Jon 3:17; 8:15-16; Mat 13:11-15*Tonde Yesu nêêl nambe, “Sa laam voon-anjo in nambe sa bayaalin omaahonôôn jak lu yuuh, in nambe hil sen mend kanuu-to le lanji taaku nivasa, tonde hil sen kand navu nambe dayi taakuu-to le mend kanu dôôk.” ");
INSERT INTO mmo_vpl VALUES ("JN9_40","073_9_40","JHN","9","40","40","+ o 9:40 Mat 15:14; 23:26*Tombe sim Palisai vaalu daale having yi ond lango vakasin-anju, tombe lalingin nambe, “Gambe hey amengg kanu having a?” ");
INSERT INTO mmo_vpl VALUES ("JN9_41","073_9_41","JHN","9","41","41","+ o 9:41 Jon 15:22*Le Yesu nêêl laah vu sil nambe, “Ham oo mem kanu vulôôt gêên ond hamate nipaya le nama, nganjo ham oo nanêêl nambe ham amem natum, om hamate nipaya naahen neep.” ");
INSERT INTO mmo_vpl VALUES ("JN10_1","073_10_1","JHN","10","1","1","Yesu nêêl vu sil nambe, “Sa naanêêl keen vu ham naambe omaaho sen me-nalukala bik sipsip-ate tata avi nivalok e, de nalak neep nindoos-ato, ond hil nambêênju hôôndak ambu osin omaaho ngaamong, ");
INSERT INTO mmo_vpl VALUES ("JN10_2","073_10_2","JHN","10","2","2","nganjo omaaho sen nalukala vinavi nivalok-ato ond mem bik sipsip-ate heendin yi. ");
INSERT INTO mmo_vpl VALUES ("JN10_3","073_10_3","JHN","10","3","3","Sipsip-ate heendin-anju ond yêêv sen nanggin vinavii-to le gataahin vinavi vu yi, tonde sipsip-aso le gango lava, tonde yik naateey sil haalend ti ti de naanggiiy sil-ambe gato lana voon. ");
INSERT INTO mmo_vpl VALUES ("JN10_4","073_10_4","JHN","10","4","4","+ o 10:4 Jon 10:27*Tombe naanggiiy yite sipsip-aso pin-ambe lana ond yoo le naamunggin-ande sipsip-aso yoo le motaamuyin yi in lango lava lung laa-to, ");
INSERT INTO mmo_vpl VALUES ("JN10_5","073_10_5","JHN","10","5","5","de sil-ame le taamuyin omaaho ango le, malis, sil e dapak in nambe me-lango omaaho ango lavand e.” ");
INSERT INTO mmo_vpl VALUES ("JN10_6","073_10_6","JHN","10","6","6","+ o 10:6 Jon 16:25*Yesu nêêl vakasin pakwesin-anju vu sil, le sil doosin vakasin sen Yesu nêêl vu sil-anjuuto danggakook. ");
INSERT INTO mmo_vpl VALUES ("JN10_7","073_10_7","JHN","10","7","7","Tombe Yesu nêêl yesin laah nambe, “Sa naanêêl keen lôôt vu ham naambe soo aatu bik sipsip-ate vinavi, ");
INSERT INTO mmo_vpl VALUES ("JN10_8","073_10_8","JHN","10","8","8","+ o 10:8 Jer 23:1-2; Esi 34:2-3*de hil pin sen lamunggin vu saa-to ond hôôndak ambu-so osin hil ngaamong ambu-so, le sipsip-aso me-lango sil lavand e. ");
INSERT INTO mmo_vpl VALUES ("JN10_9","073_10_9","JHN","10","9","9","+ o 10:9 Saam 118:20; Jon 14:6*Nganjo sa ond sa vinavi, ond omaaho ti naam vu sa be dukana tata lo ond Anutu le dôôvu yi, be dukanaah lopayo de gato naah voon, naah-ande nom in naatovu yite vanôôn. ");
INSERT INTO mmo_vpl VALUES ("JN10_10","073_10_10","JHN","10","10","10","De hôôndak ambu ond me-nalaam in vati le, yik nalaam in gôôndak sipsip osin nyiis sil-ambe lanjimb, tonde biing nindanjeen vu sil lôôt. Lemu sak sa laam in nambe sil mando metumin, de sil mando osin kand vasa lôôt. ");
INSERT INTO mmo_vpl VALUES ("JN10_11","073_10_11","JHN","10","11","11","+ o 10:11 Saam 23:1; Ais 40:11; Esi 34:11-23; Jon 15:13; Taato 7:17*“Sipsip-ate heendin anivasa sa, de sipsip-ate heendin anivasa ond yoo navu yi la doos in nambe jimb ak sipsip-aso. ");
INSERT INTO mmo_vpl VALUES ("JN10_12","073_10_12","JHN","10","12","12","+ o 10:12 Sin 20:29*Nganjo omaaho sen yoo nawiing kul in mone muu-to ond sipsip-aso me-te heendin yi le, osin sil-ame maandin yi keen e. De ji naambe voow bamaan valup, ond gavuuh sipsip de napak-ambe na, tonde voow bamaan janga sipsip-aso de gatiiy sil-ambe gavuuh taale, ");
INSERT INTO mmo_vpl VALUES ("JN10_13","073_10_13","JHN","10","13","13","in dangga nambe omaahôô-ju yoo nawiing kul in mone mu, de me-ka navu sipsip-aso le. ");
INSERT INTO mmo_vpl VALUES ("JN10_14","073_10_14","JHN","10","14","14","+ o 10:14 Jon 10:27; 2Ti 2:19*Sak sipsip-asote heendin anivasa sa, om sa lak sate va-so nind, de sate va-so lalak sa ningg, ");
INSERT INTO mmo_vpl VALUES ("JN10_15","073_10_15","JHN","10","15","15","+ o 10:15 Mat 11:27; Jon 15:13; 1Jon 3:16*nambe sen Mangg lak sa ningg, de sa lak Mangg ani. Om soo naavu sa la doos in nambe saanggimb ak sipsip-aso. ");
INSERT INTO mmo_vpl VALUES ("JN10_16","073_10_16","JHN","10","16","16","+ o 10:16 Ais 56:8; Jon 11:52; 1Pi 2:25; Esi 34:23; 37:24*Tonde sate sipsip-aso vaalu dando ond sil-ame dando hôôk tata lôô-jo having e, om sale naanggiiy sil lanaam gaving, de sil e gango sa lavangg-ambe sil mando javuh ti tonde silate heendin timu. ");
INSERT INTO mmo_vpl VALUES ("JN10_17","073_10_17","JHN","10","17","17","+ o 10:17 Pil 2:8-9*De Aamangg ahe having saa-jo dangga nambe saambu sa na doos-ambe saanggimb in nambe sa kandi vasa dôôk naah. ");
INSERT INTO mmo_vpl VALUES ("JN10_18","073_10_18","JHN","10","18","18","+ o 10:18 Jon 19:11; 5:26; 14:31*Omaaho ti me-le nôôh sa be bu sa na le, malis, yik sa kangg oo vu be sa navu aambu sa na in nambe saanggimb. Soo sate va in nambe saambu na, de soo sate va in nambe sa kandi vasa dôôk naah. Mangg nêêl vakasin-anjo vu sa nambe saambiing nôôn jak.” ");
INSERT INTO mmo_vpl VALUES ("JN10_19","073_10_19","JHN","10","19","19","+ o 10:19 Jon 7:43*Hil Yuda lango vakasin-anju tombe sil laasuh sil la lu yuuh yesin laah. ");
INSERT INTO mmo_vpl VALUES ("JN10_20","073_10_20","JHN","10","20","20","+ o 10:20 Jon 7:20; 8:48*In hil ngeeyaata lanêêl nambe, “Mamu nipaya hôôvu yi be lukook nawiing paya, le nambe vaati sen ham nango lavaa-ja?” ");
INSERT INTO mmo_vpl VALUES ("JN10_21","073_10_21","JHN","10","21","21","Tonde hil vaalu lanêêl nambe, “Hil sen mamu nipaya nahôôvu sil-ato ond me-le daanêêl vakasin naambêênju le. Mak mamu nipaya ond le biing-ambe hil sen mekanuu-to mend naatum a?” ");
INSERT INTO mmo_vpl VALUES ("JN10_22","073_10_22","JHN","10","22","22","Ngaaho lak in hil Yuda lanji silate busin bop ti vu Yelusalem. Busin bop-anju ond kand navu sen lalohak Anutu-te dumb bop bôôy-ato, tonde busin-anju vavi osin lukaahôômb. ");
INSERT INTO mmo_vpl VALUES ("JN10_23","073_10_23","JHN","10","23","23","+ o 10:23 Sin 3:11; 5:12*Tombe Yesu la monaloh Anutu-te dumb bop alo ti sen danêêl nambe Solomon-atêêto, ");
INSERT INTO mmo_vpl VALUES ("JN10_24","073_10_24","JHN","10","24","24","+ o 10:24 Luk 22:67*tombe hil Yuda lambuuh yi tatup de lanêêl vu nambe, “Naambe vaatii-jo? Onawiing nambêênja be hey alonggpayo yu-yuuh lôôt-ambe naangelis e? Hong omaaho sen Anutu yoo holin hong vulôôt in nambe gandôôvu hey-ato ond onaanêêl langaah vu hey bulôôt.” ");
INSERT INTO mmo_vpl VALUES ("JN10_25","073_10_25","JHN","10","25","25","+ o 10:25 Jon 4:26; 5:36; 10:38*Le Yesu nêêl laah vu sil nambe, “Saanêêl vu ham lung la, le ham-ame awii-having e. Kul pin sen sa naawiing ak Aamangg haalêê-jo ond yik navu taato sa langaah, ");
INSERT INTO mmo_vpl VALUES ("JN10_26","073_10_26","JHN","10","26","26","+ o 10:26 Jon 6:64; 8:45*lemu ham-ame awii-having e, in ham-ame vu sate bik sipsip-aso le. ");
INSERT INTO mmo_vpl VALUES ("JN10_27","073_10_27","JHN","10","27","27","+ o 10:27 Jon 8:47; 10:3*In sate sipsip-aso ond dango sa lavangg, de sa lak sil anind tombe yoo davu taamuyin sa. ");
INSERT INTO mmo_vpl VALUES ("JN10_28","073_10_28","JHN","10","28","28","+ o 10:28 Jon 3:16; 6:39; 18:9*Tonde sale aambiing-ambe sil mando metumin danggata, de sil-ame le lana mend nama le, malis lôôt, de omaaho ti me-le bu vêêl sil in sa namangg e. ");
INSERT INTO mmo_vpl VALUES ("JN10_29","073_10_29","JHN","10","29","29","In Mangg sen vu sil vu saa-to ond yoo niwêêk lôôt savok va pin, om omaaho ti me-lohvu nambe bu vêêl sil in Mangg nama le. ");
INSERT INTO mmo_vpl VALUES ("JN10_30","073_10_30","JHN","10","30","30","+ o 10:30 Jon 17:21*De haay Mangg ond yik haay nôôn timu.” ");
INSERT INTO mmo_vpl VALUES ("JN10_31","073_10_31","JHN","10","31","31","+ o 10:31 Jon 8:59*Tombe hil Yuda lalôôh tatuuh ak laah in nambe tanga yi be jimb, ");
INSERT INTO mmo_vpl VALUES ("JN10_32","073_10_32","JHN","10","32","32","le Yesu nêêl vu sil nambe, “Sa taato Mangg-ate kul anivasa ngeeyaata vu ham, le ham akam vu nambe kul-anjo ti tana nipaya ondeey ham awiingin nambe anyiis sa jak tatuuh?” ");
INSERT INTO mmo_vpl VALUES ("JN10_33","073_10_33","JHN","10","33","33","+ o 10:33 Lev 24:16; Mat 26:65; Jon 5:18*Tombe hil Yuda lanêêl laah vu yi nambe, “Hey anyiis hong ond me-lak kul anivasa le, nganjo ganêêl Anutu pale, de hong ond omaahonôôn amu, lemu goo ganêêl nambe hong Anutu, ondeey hey aawiingin nambe aanyiis hong.” ");
INSERT INTO mmo_vpl VALUES ("JN10_34","073_10_34","JHN","10","34","34","+ o 10:34 Saam 82:6*Tombe Yesu nêêl laah vu sil nambe, “De sil kaavu Anutu-te vakasin neep hôôk hamate tanasin nambe, ‘Saanêêl ham-anja nambe ham anutu-so,’ ");
INSERT INTO mmo_vpl VALUES ("JN10_35","073_10_35","JHN","10","35","35","+ o 10:35 Mat 5:18*ond manyinja nêêl lak hil sen bôôy Anutu-te vakasin la vu sil-ato nambe sil anutu-so, de omaaho ti me-lohvu nambe kawiiy Anutu-te vakasin na le. ");
INSERT INTO mmo_vpl VALUES ("JN10_36","073_10_36","JHN","10","36","36","+ o 10:36 Jon 5:17-20*De sak Mangg oo holin sa be wiing sa be sa laam voon, tombe saanêêl nambe Anutu Noow sa, le nambe tana sen ham anêêl nambe saanêêl Anutu pale? ");
INSERT INTO mmo_vpl VALUES ("JN10_37","073_10_37","JHN","10","37","37","Naambe same naawiing Mangg-ate kul e ond mem ham-ame ambiing gaving sa le, ");
INSERT INTO mmo_vpl VALUES ("JN10_38","073_10_38","JHN","10","38","38","+ o 10:38 Jon 14:10-11*lemu naambe sa naawiing yite kul le ham-ame awii-having sa le, ond ham ambiing gaving kul sen sa naawiing-anjo, in nambe ham anjak ni vanuh naambe Mangg nando hôôk sa, de sa nando hôôk Mangg.” ");
INSERT INTO mmo_vpl VALUES ("JN10_39","073_10_39","JHN","10","39","39","+ o 10:39 Luk 4:30; Jon 8:59*Tombe lawiingin nambe lanôôh yi, le ma de hato be la. ");
INSERT INTO mmo_vpl VALUES ("JN10_40","073_10_40","JHN","10","40","40","+ o 10:40-41 Jon 1:28-29*Tombe Yesu la bel Yoladan vaalu yesin laah tomem la nando taaku sen Jon nalipis hil neep bôôy-ato. ");
INSERT INTO mmo_vpl VALUES ("JN10_41","073_10_41","JHN","10","41","41","Tombe hil ngeeyaata lala vu le mem yoo lanêêl vu sil nambe, “Jon-ame wiing taahu taahu osin niwêêk heey e, lemu vakasin pin sen Jon nêêl lak omaahôô-jôôto ond manyinju keen lôôt.” ");
INSERT INTO mmo_vpl VALUES ("JN10_42","073_10_42","JHN","10","42","42","+ o 10:42 Jon 7:31*Tombe vu taakuu-ju hil ngeeyaata lawii-having Yesu. ");
INSERT INTO mmo_vpl VALUES ("JN11_1","073_11_1","JHN","11","1","1","+ o 11:1 Luk 10:38-39*Omaaho ti haale nambe Lasalus nilak-ambe neep vu bayêên Betaani sen Malia yuuh halivêêh Maata baand-ato, ");
INSERT INTO mmo_vpl VALUES ("JN11_2","073_11_2","JHN","11","2","2","+ o 11:2 Jon 12:3*ond Maliaa-ju sen kaasêêh va galovasa lak Omaaho Bop vaha de laavu lak luvalus-ato ond mangwa Lasalus nilak. ");
INSERT INTO mmo_vpl VALUES ("JN11_3","073_11_3","JHN","11","3","3","+ o 11:3 Jon 11:36*Om vanga yuuh lawiing vakasin la vu Yesu nambe, “Omaaho Bop, omaaho sen gahem naving yi lôôt-ato ond nilak-ambe neep.” ");
INSERT INTO mmo_vpl VALUES ("JN11_4","073_11_4","JHN","11","4","4","+ o 11:4 Jon 9:3; 11:40*Yesu hango vakasin-anju tombe nêêl nambe, “Nilakin-anju me-nambe omaahôô-ju jimb e, malis, nganjo wiingin nambe biing Anutu banye jak, in nambe le biing Anutu Noow banye jak.” ");
INSERT INTO mmo_vpl VALUES ("JN11_5","073_11_5","JHN","11","5","5","Yesu yoo ahe having Maata yuuh halivêêh-ande Lasalus. ");
INSERT INTO mmo_vpl VALUES ("JN11_6","073_11_6","JHN","11","6","6","Ke, tombe hango nambe Lasalus nilak, le ma de yoo nando taaku sen nandôô-juuto busin yuuh having, ");
INSERT INTO mmo_vpl VALUES ("JN11_7","073_11_7","JHN","11","7","7","le mem nêêl vu yite maanggêêm-aso nambe, “Yanaah Yudia.” ");
INSERT INTO mmo_vpl VALUES ("JN11_8","073_11_8","JHN","11","8","8","+ o 11:8 Jon 8:59; 10:31*Le yite maanggêêm-aso lanêêl vu nambe, “Kaputung, mu naahen vasêên dakaa-ju hil Yuda lawiingin nambe lanyiis hong ak tatuuh-ato, le sim onavu ganaah-anju jesin a?” ");
INSERT INTO mmo_vpl VALUES ("JN11_9","073_11_9","JHN","11","9","9","+ o 11:9 Jon 9:4-5; 12:35*Le Yesu nêêl laah vu sil nambe, “Busin ti ond yite taaku me nomaayuuh-ambe laam yuuh, nambe omaaho ti na langaah ond me-le tayak e, in nayi taaku langaah vu voon, ");
INSERT INTO mmo_vpl VALUES ("JN11_10","073_11_10","JHN","11","10","10","+ o 11:10 1; Jon 2:11*le naambe na dôôk busin ond le tayak in mekanu.” ");
INSERT INTO mmo_vpl VALUES ("JN11_11","073_11_11","JHN","11","11","11","+ o 11:11 Mat 9:24*Om nêêl nambêênju vu sil vêêl e, le sim nêêl vu sil nambe, “Yate omaaho Lasalus neep me, lemu sana aanjêêvu.” ");
INSERT INTO mmo_vpl VALUES ("JN11_12","073_11_12","JHN","11","12","12","Le yite maanggêêm-aso lanêêl vu nambe, “Omaaho Bop, neep me ond yoo le kandi.” ");
INSERT INTO mmo_vpl VALUES ("JN11_13","073_11_13","JHN","11","13","13","Vakasin-anjo Yesu nêêl nambe Lasalus yimb, le sil akand vu nambe mak Yesu nêêl nambe Lasalus yoo neep malis amu. ");
INSERT INTO mmo_vpl VALUES ("JN11_14","073_11_14","JHN","11","14","14","Om Yesu nêêl langaah vu sil nambe, “Lasalus yimb, ");
INSERT INTO mmo_vpl VALUES ("JN11_15","073_11_15","JHN","11","15","15","lemu sa kangg navu ham-ambe sa longgpayo nivasa in same ala nando having yi le, in saawiingin nambe ham alompayo naam timu vu sa, om yana aangge yi le.” ");
INSERT INTO mmo_vpl VALUES ("JN11_16","073_11_16","JHN","11","16","16","+ o 11:16 Mak 14:31*Tombe Tomas sen danêêl nambe Papinj-ato ond nêêl vu maanggêêm-aso vaalu nambe, “Ham-o, yana be yaanggimb gaving yi.” ");
INSERT INTO mmo_vpl VALUES ("JN11_17","073_11_17","JHN","11","17","17","Tombe Yesu-so mondala be lala lalup, de lango nambe lambe Lasalus la bandumb-ambe busin yumbeyuuh lung la. ");
INSERT INTO mmo_vpl VALUES ("JN11_18","073_11_18","JHN","11","18","18","+ o 11:18 Mat 21:17*Bayêên Betaanii-ju neep ngaaho vu Yelusalem lohvu 3 kilomita mu. ");
INSERT INTO mmo_vpl VALUES ("JN11_19","073_11_19","JHN","11","19","19","Tombe hil Yuda ngeeyaata lala vu Maata yuuh Malia in nambe lambiing-ambe yuuh alondpayo nivasa jak in yuuhate mangwaandin yimb. ");
INSERT INTO mmo_vpl VALUES ("JN11_20","073_11_20","JHN","11","20","20","Tombe Maata hango banye nambe Yesu valup, om la hato vu Yesu vu mopaatôôv de Malia yoo nando bayêên. ");
INSERT INTO mmo_vpl VALUES ("JN11_21","073_11_21","JHN","11","21","21","+ o 11:21 Jon 11:32*Tombe Maata nêêl vu Yesu nambe, “Omaaho Bop, nambe omandôô-jo ond sa mangwaangg-ame le jimb e. ");
INSERT INTO mmo_vpl VALUES ("JN11_22","073_11_22","JHN","11","22","22","De gêên-anjo sa lak ni having nambe okataangg Anutu in vati, ond Anutu le bu vu hong.” ");
INSERT INTO mmo_vpl VALUES ("JN11_23","073_11_23","JHN","11","23","23","Tombe Yesu nêêl vu nambe, “Mangwaam e kandi jak.” ");
INSERT INTO mmo_vpl VALUES ("JN11_24","073_11_24","JHN","11","24","24","+ o 11:24 Jon 5:29; 6:39-40*Le Maata nêêl nambe, “Êê-e, sa lak ni nambe vu busin taamusin sen omaahonôôn pin kandi jak-ato ond le kandi jak gaving.” ");
INSERT INTO mmo_vpl VALUES ("JN11_25","073_11_25","JHN","11","25","25","Tombe Yesu nêêl laah vu nambe, “Kandi jak naah osin metumin yoo danggakook sa. Hil sen lambiing gaving sa be lanjimb-ato ond sil e mando metumin, ");
INSERT INTO mmo_vpl VALUES ("JN11_26","073_11_26","JHN","11","26","26","+ o 11:26 Jon 8:51*de hil sen dando metumin-ambe dawii-having saa-to ond sil-ame le lanjimb e, malis lôôt. Gawii-having vakasin-anjo me malis?” ");
INSERT INTO mmo_vpl VALUES ("JN11_27","073_11_27","JHN","11","27","27","+ o 11:27 Jon 6:69*Le Maata nêêl vu Yesu nambe, “Êê-e Omaaho Bop, saawii-having hong lung la nambe hong omaaho sen Anutu yoo holin hong vulôôt-ato. Hong Anutu Noow, omaaho sen Anutu nêêl nambe le naam voon-ato ond yik hong-anja.” ");
INSERT INTO mmo_vpl VALUES ("JN11_28","073_11_28","JHN","11","28","28","Maata nêêl vakasin-anju lung la tonde la teey halivêêh Malia, tombe la pataalang vu nambe, “Kaputung valup-ambe nalingin hong.” ");
INSERT INTO mmo_vpl VALUES ("JN11_29","073_11_29","JHN","11","29","29","Malia hango nambêênju tombe kandi lak pavis-ambe la vu Yesu, ");
INSERT INTO mmo_vpl VALUES ("JN11_30","073_11_30","JHN","11","30","30","+ o 11:30 Jon 11:20*de Yesu me-tok laam bayêên e, nganjo yoo naahen taaku sen Maata la hato vuu-to. ");
INSERT INTO mmo_vpl VALUES ("JN11_31","073_11_31","JHN","11","31","31","Tombe hil Yuda sen dando mondakaas having Malia hôôk bayêên alo in nambe lopayo nivasa jak-ato, ond layi nambe Malia kandi lak pavis-ambe la voon, tombe sil taamuyin, in sil akand vu nambe mak navu na naasu jak bandumb. ");
INSERT INTO mmo_vpl VALUES ("JN11_32","073_11_32","JHN","11","32","32","+ o 11:32 Jon 11:21*Tombe Malia la hato taaku sen Yesu naalêê-to, om yi Yesu tombe hato pataav baambu neep voon hôôk Yesu vaha de nêêl vu nambe, “Omaaho Bop, nambe omandôô-jo ond sa mangwaangg-ame le jimb e.” ");
INSERT INTO mmo_vpl VALUES ("JN11_33","073_11_33","JHN","11","33","33","Tombe Yesu yi de Malia nasu, tonde hil Yuda sen laving Malia be lalaam-ato ond yik dasu having, tombe ka paya de lopayo nimeen lôôt. ");
INSERT INTO mmo_vpl VALUES ("JN11_34","073_11_34","JHN","11","34","34","Tonde lingin nambe, “Ham hambe neep tana?” Le lanêêl nambe, “Omaaho Bop, ganaam gangge le.” ");
INSERT INTO mmo_vpl VALUES ("JN11_35","073_11_35","JHN","11","35","35","+ o 11:35 Luk 19:41*Tombe Yesu su. ");
INSERT INTO mmo_vpl VALUES ("JN11_36","073_11_36","JHN","11","36","36","+ o 11:36 Jon 11:3*Om hil Yuda lanêêl nambe, “Ham angge, yoo ahe having omaahôô-ju lôôt.” ");
INSERT INTO mmo_vpl VALUES ("JN11_37","073_11_37","JHN","11","37","37","+ o 11:37 Jon 9:6*Lemu hil vaalu lanêêl nambe, “Omaahôô-ju wiing-ambe mekanôônd ame tum-ato, om me-lohvu nambe dôôvu yite omaahôô-ju in nambe me-jimb e?” ");
INSERT INTO mmo_vpl VALUES ("JN11_38","073_11_38","JHN","11","38","38","+ o 11:38 Mat 27:60*Tombe Yesu lopayo nimeen lôôt yesin laah tonde la valup bandumb, de bandumb-anju ond lavandangga ti tombe sil tatolin tatuuh ti hilin avi jeen. ");
INSERT INTO mmo_vpl VALUES ("JN11_39","073_11_39","JHN","11","39","39","Tombe Yesu nêêl nambe, “Ham baaku tatuuh-anja na vêêl.” Le Maata sen yimbin vangaa-to nêêl vu nambe, “Omaaho Bop, yimb-ambe neep busin yumbeyuuh lung la om ninggalôôn ak.” ");
INSERT INTO mmo_vpl VALUES ("JN11_40","073_11_40","JHN","11","40","40","+ o 11:40 Jon 11:4,23-26*Tombe Yesu nêêl vu nambe, “Le saanêêl vu hong gêên-ato nambe gambiing gaving ond onavu gangge Anutu-te niwêêk.” ");
INSERT INTO mmo_vpl VALUES ("JN11_41","073_11_41","JHN","11","41","41","Tombe laaku tatuuh la vêêl, de me lak baandoni de nêêl nambe, “Aamangg, sa naapêêlis vu hong in ohango sate lohakin lung laa-to. ");
INSERT INTO mmo_vpl VALUES ("JN11_42","073_11_42","JHN","11","42","42","+ o 11:42 Jon 12:30*De sa lak ni nambe lak busin pin ond goo nambe nanyem in sate lohakin, lemu sa kangg vu hil sen daalêê-jo ondeey saanêêl vakasin-anjo in nambe sil lambiing gaving naambe goo gawiing sa be sa laam.” ");
INSERT INTO mmo_vpl VALUES ("JN11_43","073_11_43","JHN","11","43","43","Nêêl nambêênju tonde teey bopaata nambe, “Lasalus, ganaam voon.” ");
INSERT INTO mmo_vpl VALUES ("JN11_44","073_11_44","JHN","11","44","44","Tombe yimbin kandi lak-ambe laam voon osin tôômb sen sil lavil nama yuuh vaha lak-ato, de tôômb daka sen hilin mêê-to ond yik yoo neep ak yi having. Tombe Yesu nêêl nambe, “Ham kavaayin tôômb na vêêl-ande yoo na.” ");
INSERT INTO mmo_vpl VALUES ("JN11_45","073_11_45","JHN","11","45","45","+ o 11:45 Jon 4:48; 7:31; Luk 16:31*Tombe hil Yuda vaalu sen lalaam vu Maliaa-to layi vaa-ju tombe sil ngeeyaata lawii-having Yesu, ");
INSERT INTO mmo_vpl VALUES ("JN11_46","073_11_46","JHN","11","46","46","lemu sil vaalu lala vu hil Palisai be lanêêl va sen Yesu wiing-anjôôto banye vu sil. ");
INSERT INTO mmo_vpl VALUES ("JN11_47","073_11_47","JHN","11","47","47","Tombe kul vaha sen datung salivangin-ato silate yêêv-aso laving hil Palisai be yoo lasupin sil having kaansol-aso be lanêêl nambe, “Yale aambiing naambe vaati? In omaahôô-ju wiing taahu taahu osin niwêêk ngeeyaata. ");
INSERT INTO mmo_vpl VALUES ("JN11_48","073_11_48","JHN","11","48","48","Yiiy oo monaangge mu de yoo monambiing va naambêênju, ond hil pin e lambiing gaving yi, de hil Lom e lanaam-ambe kawiiy Anutu-te dumb bop osin yiiy pin na.” ");
INSERT INTO mmo_vpl VALUES ("JN11_49","073_11_49","JHN","11","49","49","Tombe sil ti haale nambe Kaiapas tu kul vaha salivangin-ate yêêv bop hôôk ta tii-ju, ond nêêl vu sil nambe, “Ham-ame alak ni daka le, ");
INSERT INTO mmo_vpl VALUES ("JN11_50","073_11_50","JHN","11","50","50","+ o 11:50 Jon 18:14*de ham-ame kam vu va sen dôôvu ham-ato le? Nambe omaaho timu jimb in dôôvu hil pin ond mem, de yate hil pin-ame lanjimb e.” ");
INSERT INTO mmo_vpl VALUES ("JN11_51","073_11_51","JHN","11","51","51","+ o 11:51 Jen 50:20*Vakasin-anjo ond me-yoo nêêl lohvu ka le, malis, nganjo tu yêêv bop salivangin-ate hôôk ta tii-ju om nêêl vakasin langaah nambe Anutu-te omaaho ti, ond nêêl lak Yesu nambe le jimb in dôôvu hil Yuda. ");
INSERT INTO mmo_vpl VALUES ("JN11_52","073_11_52","JHN","11","52","52","+ o 11:52 Jon 10:16; 17:21; 1Jon 2:2*Lemu me-yoo jimb in hil Yuda yoow e, malis, jimb in naasupin Anutu-te noondin pin sen dando lohvu taaku pin-ato be sil daatu dangga timu. ");
INSERT INTO mmo_vpl VALUES ("JN11_53","073_11_53","JHN","11","53","53","+ o 11:53 Jon 5:18*Tombe yik hôôk busin-anju sil davu salo mop in nambe lanyiis Yesu be jimb, ");
INSERT INTO mmo_vpl VALUES ("JN11_54","073_11_54","JHN","11","54","54","+ o 11:54 Jon 7:1*om Yesu me-nando langaah hôôk hil Yuda mend yesin laah e, nganjo havuuh taakuu-ju de la taaku ti danêêl nambe Eplaim. Taakuu-ju neep ngaaho vu taaku lumbalaamb, tombe la nandôô-ju having yite maanggêêm-aso. ");
INSERT INTO mmo_vpl VALUES ("JN11_55","073_11_55","JHN","11","55","55","+ o 11:55 2Kro 30:17; Sin 21:26*Tonde hil Yuda-te busin bop busin haluusin sen Anutu haluuh hil Islel hôôk vu Ijip bôôy-ato ngaaho lak, tombe hil ngeeyaata vu taaku pin lala lalup Yelusalem in samu sil vêêl e. ");
INSERT INTO mmo_vpl VALUES ("JN11_56","073_11_56","JHN","11","56","56","+ o 11:56 Jon 7:11*Tombe sil davu salo Yesu, tonde lala daale Anutu-te dumb bop alo be mondanêêl vu sil nambe, “Ham akam vu nambe vaati, mak me-le naam-ambe ji busin bop-anjo gaving e?” ");
INSERT INTO mmo_vpl VALUES ("JN11_57","073_11_57","JHN","11","57","57","Tombe yêêv-aso salivangin-ate laving hil Palisai lanêêl nambe omaaho ti lak ni nambe Yesu nando tana, ond naanêêl banye langaah in lanôôh yi. ");
INSERT INTO mmo_vpl VALUES ("JN12_1","073_12_1","JHN","12","1","1","+ o 12:1 Jon 11:1,43*Busin namaavaalu naahen de ti sen naatu vindak tii-to ond naatu busin haluusin sen Anutu haluuh hil Islel hôôk vu Ijip bôôy-ato, tonde Yesu lo-valup Betaani sen yêêvu Lasalus be kandi lak vu yimbin-atêêto. ");
INSERT INTO mmo_vpl VALUES ("JN12_2","073_12_2","JHN","12","2","2","+ o 12:2 Luk 10:40*Tombe lawiing Yesu-te vanôôn vuu-ju, tombe Maata yoo monaluuh vanôôn, de Lasalus nando having vaatêêvak-aso be mondaya vanôôn having Yesu. ");
INSERT INTO mmo_vpl VALUES ("JN12_3","073_12_3","JHN","12","3","3","+ o 12:3 Luk 7:37-38*Tonde Malia hako bel galovasa hôôk buayo bop ti, bel galovasaa-ju ond daanggo lak mone bopaata lôôt, ond valup-ambe kaasêêh ak Yesu vaha de laavu lak luvalus, tombe bel galovasaa-jo galôôn vapuuh-ambe lohvu bayêên alo pin. ");
INSERT INTO mmo_vpl VALUES ("JN12_4","073_12_4","JHN","12","4","4","+ o 12:4 Jon 6:71; 18:3*Lemu Yesu-te maanggêêm ti, haale nambe Yudas Iskaliot, ond ngaaho lak in navu taato Yesu langaah-ambe hil lanôôh-ato, ond nêêl nambe, ");
INSERT INTO mmo_vpl VALUES ("JN12_5","073_12_5","JHN","12","5","5","+ o 12:5 Mat 19:21*“Nambe vaati sen yame aavu bel galovasaa-ju be hil baanggo jak mone 300 kina, de monêê-jo yaambu vu hil sen dativak in va yuuh amêê-to?” ");
INSERT INTO mmo_vpl VALUES ("JN12_6","073_12_6","JHN","12","6","6","Lemu Yudas-ame ka vu hil sen dativak in va yuuh amêê-to ondeey nêêl nambêênju le, malis, nganjo yi omaaho hôôndak ambu in yoo nanggin Yesu having maanggêêm-asote laayul mone-têêto, tombe mone sen daasu hôôk-ato ond yoo nahôôndak vaalu. ");
INSERT INTO mmo_vpl VALUES ("JN12_7","073_12_7","JHN","12","7","7","+ o 12:7 Jon 19:40*Le Yesu nêêl nambe, “Jipin vêêh-anju, ham-ame naanêêl yi le, in yoo hatung bel galovasaa-ju vu sa be gêên navu taahu sate busin kanu sen saanggimb-ambe landaav saa-to. ");
INSERT INTO mmo_vpl VALUES ("JN12_8","073_12_8","JHN","12","8","8","+ o 12:8 Diu 15:11*De hil sen dativak in va yuuh amêê-to sil e mando gaving ham nohvu busin pin, nganjo sak same le mando gaving ham nohvu busin pin e.” ");
INSERT INTO mmo_vpl VALUES ("JN12_9","073_12_9","JHN","12","9","9","+ o 12:9 Jon 11:43-44*Hil Yuda ngeeyaata lalak ni nambe Yesu nando Betaanii-jo om sil lala. Lemu sil-ame lala in lanji Yesu mu le, malis, nganjo lawiingin nambe lanji Lasalus sen bôôy Yesu yêêvu be kandi lak vu hil yimbin-atêêto. ");
INSERT INTO mmo_vpl VALUES ("JN12_10","073_12_10","JHN","12","10","10","Tombe kul vaha sen datung salivangin-ato silate yêêv-aso lanjôôy vakasin in nambe lanyiis Lasalus-ambe jimb gaving, ");
INSERT INTO mmo_vpl VALUES ("JN12_11","073_12_11","JHN","12","11","11","+ o 12:11 Jon 11:45*in hil Yuda ngeeyaata kand vu Lasalus tombe lavuuh silate yêêv-aso de lawii-having Yesu. ");
INSERT INTO mmo_vpl VALUES ("JN12_12","073_12_12","JHN","12","12","12","Heendiiy atombe hil ngeeyaata sen lalaam dando lung la in lanji busin bop busin haluusin-ato lango nambe Yesu valup in naam Yelusalem. ");
INSERT INTO mmo_vpl VALUES ("JN12_13","073_12_13","JHN","12","13","13","+ o 12:13 Saam 118:25-26; Mat 27:42; Jon 1:49*Om sil lako haah alis osin nama be lala latovu Yesu vu mopaatôôv, tombe daakôôhin nambe, “Ham-o, yiiy lavangg dôôk Anutu, de yiiy gako omaahôô-ja haale jak in laam ak Omaaho Bop haale. Yiiy Islel-ate omaaho lulemak yi.” ");
INSERT INTO mmo_vpl VALUES ("JN12_14","073_12_14","JHN","12","14","14","Tombe Yesu tovu donggi daka be lakando be la, lohvu Anutu-te vakasin neep hôôk kaapiya nambe, ");
INSERT INTO mmo_vpl VALUES ("JN12_15","073_12_15","JHN","12","15","15","+ o 12:15 Sek 9:9*“Ham Saion-e, ham-ame anjêênin e. Ham angge hamate omaaho lulemak nando lak donggi noow-ambe nalaas vu ham.” ");
INSERT INTO mmo_vpl VALUES ("JN12_16","073_12_16","JHN","12","16","16","+ o 12:16 Jon 2:22*Tombe yite maanggêêm-aso me-lalak vaa-jo dangga ni pavis e, le taamusin Yesu kandi lak-ambe haale tu bopaata lak lung la, le mem sil akand vu laah Anutu-te vakasin sen neep hôôk kaapiya munggin-ato, tombe mem lalak ni nambe lawiing vakasin-anjuuto nôôn ak lohvu. ");
INSERT INTO mmo_vpl VALUES ("JN12_17","073_12_17","JHN","12","17","17","+ o 12:17 Jon 11:43-44*Tonde hil ngeeyaata sen daale having Yesu de teey Lasalus vu bandumb-ambe kandi lak vu yimbin-ate be laam-ato, ond mondanêêl Yesu banye lôôt, ");
INSERT INTO mmo_vpl VALUES ("JN12_18","073_12_18","JHN","12","18","18","tombe hil pin lango banye nambe Yesu wiing taahu taahu osin niwêêk-anju ondeey lala latovu yi vu mopaatôôv. ");
INSERT INTO mmo_vpl VALUES ("JN12_19","073_12_19","JHN","12","19","19","+ o 12:19 Jon 11:48*Tonde Palisai-so yoo lanêêl vu sil nambe, “Ke, ham angge, yanêêngg vakasin nôôn ma in hil pin lala davu taamuyin yi.” ");
INSERT INTO mmo_vpl VALUES ("JN12_20","073_12_20","JHN","12","20","20","Tombe hil Glik heey lala lalup Yelusalem in lanohak vu Anutu dôôk busin bop-anju gaving. ");
INSERT INTO mmo_vpl VALUES ("JN12_21","073_12_21","JHN","12","21","21","+ o 12:21 Jon 1:44; Luk 19:3; 23:8*Tombe sil lala vu Pilip sen baan Betsaida vu Galilii-to, tombe sil kataangg yi nambe, “Himbop, hey aawiingin nambe aangge Yesu.” ");
INSERT INTO mmo_vpl VALUES ("JN12_22","073_12_22","JHN","12","22","22","Tombe Pilip la nêêl vu Endru, le mem Endru having Pilip-ambe yuuh lala lanêêl vu Yesu. ");
INSERT INTO mmo_vpl VALUES ("JN12_23","073_12_23","JHN","12","23","23","+ o 12:23 Jon 13:31-32; 17:1*Tombe Yesu nêêl laah vu yuuh nambe, “Busin tok laam lung laa-jo in nambe Omaahonôôn Noow navu gako haale bop. ");
INSERT INTO mmo_vpl VALUES ("JN12_24","073_12_24","JHN","12","24","24","+ o 12:24 1Ko 15:36*De sa naanêêl keen vu ham naambe saakom ve nôôn ti nambe yame gavuk dukana ngaanggis e, ond saakom ve nôôn timuu-jôôto yoo le mando. Le naambe yiiy gavuk dukana ngaanggis-ambe me balup-ande naavi panyek ond mem le nyiis nôôn ngeeyaata jambaale. ");
INSERT INTO mmo_vpl VALUES ("JN12_25","073_12_25","JHN","12","25","25","+ o 12:25 Mat 16:25*Omaaho ti yoo ahe having ninaavi vu voon-anjo ond le na menama, de omaaho ti nimbaya ninaavi vu voon-anjo ond le mando metumin danggata. ");
INSERT INTO mmo_vpl VALUES ("JN12_26","073_12_26","JHN","12","26","26","+ o 12:26 Jon 14:3; 17:24*De omaaho ti nambe nôôh sate kul ond le taamuyin sa, tombe taaku sen sa mandôô-to ond sate hil kul vaha-so le mando gaving sa. Tonde omaaho ti nambe gako sate kul ond Aamangg e gako yi jak.” ");
INSERT INTO mmo_vpl VALUES ("JN12_27","073_12_27","JHN","12","27","27","+ o 12:27 Saam 6:3; 42:5; Mat 26:38*“Gêên-anjo sa longgpayo nimeen lôôt, om sale naanêêl vaati? Mak sa naanêêl naambe, ‘Aamangg, ganôôh sa vêêl in va sen navu naatovu sa peey-anjo?’ Malis, me-lohvu sa naanêêl naambêênjo le, in sa nando be gêên-anjo in nambe sa baaku nimeen peey. ");
INSERT INTO mmo_vpl VALUES ("JN12_28","073_12_28","JHN","12","28","28","+ o 12:28 Mat 3:17*Om Aamangg, goo gambiing ohaalem naatu bopaata jak.” Tonde lava ti laam vu baandoni nambe, “Saawiing-ambe sa haalengg bop ak lung la, tonde sale aambiing-ambe bop jak jesin naah.” ");
INSERT INTO mmo_vpl VALUES ("JN12_29","073_12_29","JHN","12","29","29","+ o 12:29 Sin 23:9*Tombe hil sen daale dangôô-to lanêêl nambe, “Kalang tuuh.” Tonde hil vaalu lanêêl nambe, “Angela ti vakaas vu yi.” ");
INSERT INTO mmo_vpl VALUES ("JN12_30","073_12_30","JHN","12","30","30","+ o 12:30 Jon 11:42*Le Yesu nêêl laah vu sil nambe, “Vakasin-anju me-laam in nambe sa gango le, malis, nganjo laam in nambe ham gango. ");
INSERT INTO mmo_vpl VALUES ("JN12_31","073_12_31","JHN","12","31","31","+ o 12:31 Jon 9:39; 14:30; 16:11*Gêên Anutu navu sahi hil voon-ate vakasin jakana, de gêên-anjo navu gatiiy omaahonôôn-ate heendin anipaya Saalang vu voon-anjo na. ");
INSERT INTO mmo_vpl VALUES ("JN12_32","073_12_32","JHN","12","32","32","+ o 12:32 Jon 3:14*In gêên sa nando voon, le busin sen sil gasi sa jakanaa-to ond sale daandiiy omaahonôôn pin naam vu sa.” ");
INSERT INTO mmo_vpl VALUES ("JN12_33","073_12_33","JHN","12","33","33","+ o 12:33 Jon 18:32*Nêêl vakasin nambêênju in taato naambe le jimb ak haah pako. ");
INSERT INTO mmo_vpl VALUES ("JN12_34","073_12_34","JHN","12","34","34","+ o 12:34 Saam 89:4,36; 110:4; Ais 9:7; Dan 7:14*Tombe hil lanêêl laah vu nambe, “Hey hango tanasin neep hôôk Anutu-te kaapiya nambe omaaho sen Anutu yoo holin yi vulôôt in nambe dôôvu yiiy-ato ond le mando danggata, le nambe tana sen ganêêl nambe le gasi Omaahonôôn Noow jakana? Omaahonôôn Noow-anju lati?” ");
INSERT INTO mmo_vpl VALUES ("JN12_35","073_12_35","JHN","12","35","35","+ o 12:35 Jon 7:33; 8:12; 1Jon 2:10-11*Le Yesu nêêl laah nambe, “Kin tumin-ato le naatum vu ham daka gaving e, om ham oo ana hôôk melangaah in le mekanu dôôk in ham. In omaaho ti na hôôk mekanu ond le doosin mop sen naa-to, ");
INSERT INTO mmo_vpl VALUES ("JN12_36","073_12_36","JHN","12","36","36","+ o 12:36 Ep 5:8*om gêên ham ambiing gaving kin tumin sen naahen nando having ham-anjo, ond mem ham e naatu hil melangaah-ate.” Yesu nêêl nambêênju lung la, tonde la hôôpis in sil. ");
INSERT INTO mmo_vpl VALUES ("JN12_37","073_12_37","JHN","12","37","37","Yesu wiing taahu taahu osin niwêêk ngeeyaataa-ju hôôk hil amend, le me-lawii-having yi le, ");
INSERT INTO mmo_vpl VALUES ("JN12_38","073_12_38","JHN","12","38","38","+ o 12:38 Ais 53:1; Lom 10:16*in nambe Yesaia-te vakasin nôôn ak sen nêêl langaah nambe, “Omaaho Bop, laheey lawii-having heyate vakasin? De Omaaho Bop taato yite niwêêk vu lati?” ");
INSERT INTO mmo_vpl VALUES ("JN12_39","073_12_39","JHN","12","39","39","Ondeey sil-ame lalohvu nambe lambiing gaving Yesu le, in Yesaia nêêl vakasin ango be neep nambe, ");
INSERT INTO mmo_vpl VALUES ("JN12_40","073_12_40","JHN","12","40","40","+ o 12:40 Ais 6:10; Mat 13:15*“Anutu wiing-ambe sil amend kanu hôôk, de wiing-ambe sil alondpayo niwêêk ak, in nambe sil-ame lanji va jak mend e, osin kand-ame bu vakasin danggakook e, de me-langgilin londpayo nom vu sa in nambe saambiing-ambe nind vasa jak e, malis.” ");
INSERT INTO mmo_vpl VALUES ("JN12_41","073_12_41","JHN","12","41","41","+ o 12:41 Ais 6:1*Yesaia yi me lak Yesu-te nikaapulis ondeey nêêl vakasin nambêênjo lak Yesu. ");
INSERT INTO mmo_vpl VALUES ("JN12_42","073_12_42","JHN","12","42","42","+ o 12:42 Jon 7:48; 8:30; 9:22*Tonde yêêv ngeeyaata lawii-having Yesu, le dayêênin hil Palisai om me-danêêl langaah e, in nambe le gatiiy sil lana nanyendangga. ");
INSERT INTO mmo_vpl VALUES ("JN12_43","073_12_43","JHN","12","43","43","+ o 12:43 Jon 5:44*Keen, yêêv-asôônju me-lawiingin nambe Anutu gako sil haalend jak e, nganjo sil oo kand navu nambe omaahonôôn gako sil haalend jak ond mem nivasa. ");
INSERT INTO mmo_vpl VALUES ("JN12_44","073_12_44","JHN","12","44","44","+ o 12:44 Mat 10:40*Yesu teey la langaah nambe, “Omaaho ti nambe biing gaving sa ond me-yoo wii-having sa le, nganjo wii-having omaaho sen wiing sa be sa laam-ato having. ");
INSERT INTO mmo_vpl VALUES ("JN12_45","073_12_45","JHN","12","45","45","+ o 12:45 Jon 14:9*Tonde omaaho ti nambe ji me jak sa ond yik yi me lak omaaho sen wiing sa be sa laam-ato. ");
INSERT INTO mmo_vpl VALUES ("JN12_46","073_12_46","JHN","12","46","46","+ o 12:46 Jon 8:12; 12:35*Saalukalaam voon-anjo nambe kin tumin in nambe hil pin sen sil alondpayo naam timu vu saa-to ond sil-ame mando hôôk mekanu le. ");
INSERT INTO mmo_vpl VALUES ("JN12_47","073_12_47","JHN","12","47","47","+ o 12:47 Jon 3:17; 8:15*Tonde omaaho ti gango sate vakasin-ambe mesamu le, ond same le aambu nyevahaan vu yi le, in same alaam voon in nambe gangoyin omaahonôôn-ate vakasin e, malis, nganjo soo alaam in nambe aandôôvu omaahonôôn. ");
INSERT INTO mmo_vpl VALUES ("JN12_48","073_12_48","JHN","12","48","48","+ o 12:48 Hiblu 4:12*De omaaho ti nambe galuuh dami vu sa de me-gako sate vakasin jak e, ond yite va sen le bu nyevahaan vu yii-to nando, yik vakasin sen sa naanêêl-anjo ond yoo le naanêêl yite nipaya langaah naambe le gako nyevahaan dukanaah vu busin taamusin. ");
INSERT INTO mmo_vpl VALUES ("JN12_49","073_12_49","JHN","12","49","49","In same yoo naanêêl vakasin lohvu sa kangg e, malis, nganjo Aamangg sen wiing sa be sa laam-ato ond yoo nêêl vakasin pin vu sa nambe soo tatekin osin sa naanêêl. ");
INSERT INTO mmo_vpl VALUES ("JN12_50","073_12_50","JHN","12","50","50","+ o 12:50 Jon 8:26,28*De sa lak ni nambe Mangg-ate vakasin le biing-ambe ham mando metumin danggata, om va sen sa naanêêl ond sa naanêêl lohvu Mangg nêêl vu sa lung laa-to.” ");
INSERT INTO mmo_vpl VALUES ("JN13_1","073_13_1","JHN","13","1","1","+ o 13:1 Jon 7:30; 12:23; 15:13; 1Jon 3:16; Pil 2:8*Hil Yuda-te busin bop busin haluusin sen Anutu haluuh hil Islel hôôk vu Ijip bôôy-ato ond peey-anjo ngaaho lak, tonde Yesu lak ni nambe yite busin tok laam lung la in gavuuh ngaanggis voon-anjo de naah vu Mangganaan. Yoo ahe having yite va-so vu voon-anjo vu munggin-ambe tok valup busin sen yimb-ato. ");
INSERT INTO mmo_vpl VALUES ("JN13_2","073_13_2","JHN","13","2","2","+ o 13:2 Luk 22:3; Jon 13:27*Hôôk soosin atombe sil o maanggêêm-aso mondaya vanôôn, tonde Saalang lukala Yudas sen Simon Iskaliot noow-ato lopayo lung la in nambe naanêêl Yesu langaah vu hil in nambe sil lanyiis-ambe jimb. ");
INSERT INTO mmo_vpl VALUES ("JN13_3","073_13_3","JHN","13","3","3","+ o 13:3 Jon 3:35; 16:28*Tombe Yesu lak ni lung la nambe Mangganaan oo vu va pin lukala yi Yesu nama, tonde lak ni having nambe yoo vu Anutu be laam, de yik le naah vu Anutu. ");
INSERT INTO mmo_vpl VALUES ("JN13_4","073_13_4","JHN","13","4","4","Daahen daya vanôôn atonde Yesu kandi be kaah yite lolop de hako taahol-ambe havêêh, ");
INSERT INTO mmo_vpl VALUES ("JN13_5","073_13_5","JHN","13","5","5","tombe mem hako bel hôôk kaambum bop ti be monalipis yite maanggêêm-aso vahand-ande naavu lak taahol sen havêêh-ato. ");
INSERT INTO mmo_vpl VALUES ("JN13_6","073_13_6","JHN","13","6","6","Lipis sil vahand-ambe valup vu Simon Pita, tombe Pita nêêl vu nambe, “Omaaho Bop, ganjipis sa vahangg a?” ");
INSERT INTO mmo_vpl VALUES ("JN13_7","073_13_7","JHN","13","7","7","Tombe Yesu nêêl laah vu nambe, “Va sen sa naawiing gêên-anjo onaahen doosin, nganjo taamusin e mem gale ganjak ni.” ");
INSERT INTO mmo_vpl VALUES ("JN13_8","073_13_8","JHN","13","8","8","Le Pita nêêl laah nambe, “Game le ganjipis sa vahangg e, malis lôôt.” Le Yesu nêêl laah vu nambe, “Same aanjipis ovaham e, ond game le mando gaving sa le.” ");
INSERT INTO mmo_vpl VALUES ("JN13_9","073_13_9","JHN","13","9","9","Tombe Simon Pita nêêl laah vu nambe, “Om Omaaho Bop, game ganjipis sa vahangg amu le, nganjo ganjipis sa namangg-ambe sa lungg gaving.” ");
INSERT INTO mmo_vpl VALUES ("JN13_10","073_13_10","JHN","13","10","10","+ o 13:10 Jon 15:3*Le Yesu nêêl vu nambe, “Omaaho sen luus bel lung laa-to ond le jipis vaha mu jesin, nganjo ninaavi pin ond me-jipis naah e, in nivasa lak lung la. De ham ond ham anivasa lak lung la, lemu me-ham pin e.” ");
INSERT INTO mmo_vpl VALUES ("JN13_11","073_13_11","JHN","13","11","11","+ o 13:11 Jon 6:64,70-71*In omaaho sen navu naanêêl Yesu langaah vu hil in nambe lanyiis-ambe jimb-ato ond Yesu yoo lak ni lung la, ondeey nêêl nambe sil pin-ame nind vasa lak e. ");
INSERT INTO mmo_vpl VALUES ("JN13_12","073_13_12","JHN","13","12","12","Tombe Yesu lipis sil vahand lung la de lop yite lolop laah-ande hato nando, le mem lingin sil nambe, “Mak va sen saawiing vu ham-anjo ond ham alak ni? ");
INSERT INTO mmo_vpl VALUES ("JN13_13","073_13_13","JHN","13","13","13","+ o 13:13 Mat 23:8,10*Tonde ham nanêêl sa nambe Kaputung osin Omaaho Bop ond manyinja ham anêêl lohvu, in yik sa nambêênja. ");
INSERT INTO mmo_vpl VALUES ("JN13_14","073_13_14","JHN","13","14","14","+ o 13:14 Mat 20:28; Luk 22:27*De sa Omaaho Bop osin sa Kaputung, saalipis ham vaham, om yik nyevahaan neep vu ham in nambe ham oo daanggôôl ham-ande ham anjipis mango-so vahand naambêênja. ");
INSERT INTO mmo_vpl VALUES ("JN13_15","073_13_15","JHN","13","15","15","+ o 13:15 Pil 2:5; Kol 3:13; 1Pi 2:21*In gêên saawiing taahu taahu be sa taato vu ham in nambe ham ambiing nohvu sen saawiing vu ham-anjo. ");
INSERT INTO mmo_vpl VALUES ("JN13_16","073_13_16","JHN","13","16","16","+ o 13:16 Mat 10:24*Om sa naanêêl keen lôôt vu ham naambe kul vaha me-savok yite yêêv e, tonde omaaho ti nêêl-ambe ango la nawiing kul ti, ond me-savok ango sen nêêl-ambe laa-juuto le. ");
INSERT INTO mmo_vpl VALUES ("JN13_17","073_13_17","JHN","13","17","17","+ o 13:17 Mat 7:24; Jem 1:25*Om naambe ham alak vaa-ja ni be ham ambiing naambêênja ond ham e kam vasa. ");
INSERT INTO mmo_vpl VALUES ("JN13_18","073_13_18","JHN","13","18","18","+ o 13:18 Saam 41:9*Lemu same aanêêl lak ham pin e. Ham sen saaholin ham-ambe ham atu sate vaa-to ond sa lak ham anim lung la, lemu vakasin sen neep hôôk Anutu-te kaapiyaa-to yoo le nôôn jak, in vakasin-anju nêêl nambe, ‘Omaaho sen naya vanôôn having saa-to vêêl vaha lak in nambe baake sa.’ ");
INSERT INTO mmo_vpl VALUES ("JN13_19","073_13_19","JHN","13","19","19","+ o 13:19 Jon 14:29; 16:4*Vakasin-anjo ond me-nôôn ak e, lemu sa naanêêl vu ham namunggin-anjo in nambe nôôn jak atombe mem ham e ambiing gaving sa naambe saa-jo. ");
INSERT INTO mmo_vpl VALUES ("JN13_20","073_13_20","JHN","13","20","20","+ o 13:20 Mat 10:40*Om sa naanêêl keen lôôt vu ham naambe omaaho ti gako hil sen sa naawiing sil dalaa-to jak ond hako sa lak, tonde omaaho ti nambe gako sa jak ond manyinja hako omaaho sen wiing sa be sa laam-ato lak.” ");
INSERT INTO mmo_vpl VALUES ("JN13_21","073_13_21","JHN","13","21","21","+ o 13:21 Jon 12:27*Yesu nêêl nambêênju tonde lopayo nimeen lôôt, tombe nêêl langaah nambe, “Sa naanêêl keen lôôt vu ham naambe ham ti navu bu sa dukana hil sen lanyiis saa-to namand.” ");
INSERT INTO mmo_vpl VALUES ("JN13_22","073_13_22","JHN","13","22","22","Tombe yite maanggêêm-aso yoo langget sil lôôt, in sil doosin omaaho sen Yesu nêêl vakasin ak yii-to. ");
INSERT INTO mmo_vpl VALUES ("JN13_23","073_13_23","JHN","13","23","23","+ o 13:23 Jon 19:26; 20:2; 21:7,20*Tonde maanggêêm ti sen Yesu yoo ahe having yii-to nando ngaaho vu Yesu, ");
INSERT INTO mmo_vpl VALUES ("JN13_24","073_13_24","JHN","13","24","24","ond Simon Pita vêêl ka lak vu omaahôô-ju in nambe jingin Yesu naambe nanêêl lati. ");
INSERT INTO mmo_vpl VALUES ("JN13_25","073_13_25","JHN","13","25","25","Tombe valu-la ngaaho vu Yesu be lingin nambe, “Omaaho Bop, ganêêl latii-ja?” ");
INSERT INTO mmo_vpl VALUES ("JN13_26","073_13_26","JHN","13","26","26","Le Yesu nêêl laah vu nambe, “Yik sale daanggôôl balet dakaa-jo dôôk bel luk-ande saambu vu yi, ond yik yii-ju.” Tombe laanggôôl balet daka hôôk bel luk-ambe vu vu Simon Iskaliot noow Yudas. ");
INSERT INTO mmo_vpl VALUES ("JN13_27","073_13_27","JHN","13","27","27","+ o 13:27 Jon 13:2; Luk 22:3*Yudas vu vêêl balet la tonde Saalang lukala lopayo, tombe Yesu nêêl vu nambe, “Va sen onavu gambiing-ato ond gambiing pavis.” ");
INSERT INTO mmo_vpl VALUES ("JN13_28","073_13_28","JHN","13","28","28","Tombe sil pin sen dando mondaya vanôôn-ato ond sil doosin vakasin sen Yesu nêêl vu Yudas-anju danggakook, ");
INSERT INTO mmo_vpl VALUES ("JN13_29","073_13_29","JHN","13","29","29","+ o 13:29 Jon 12:6*in sil akand vu mu nambe Yudas-anju nanggin silate laayul mone-te, om Yesu mak nêêl vu nambe baanggo silate vanôôn busin sawaasin-ate bulôôt, tonde vaalu kand vu nambe mak nêêl vu nambe na bu va vu hil sen dativak in va yuuh amêê-to. ");
INSERT INTO mmo_vpl VALUES ("JN13_30","073_13_30","JHN","13","30","30","Lung laa tonde Yudas hato be la voon pavis, de taaku bus la. ");
INSERT INTO mmo_vpl VALUES ("JN13_31","073_13_31","JHN","13","31","31","+ o 13:31 Jon 12:23*Lung laa tonde Yesu nêêl nambe, “Gêên Omaahonôôn Noow haale bop ak lung la, tombe wiing Anutu haale bop ak having. ");
INSERT INTO mmo_vpl VALUES ("JN13_32","073_13_32","JHN","13","32","32","+ o 13:32 Jon 17:5*Om sen wiing-ambe Anutu haale bop ak, om Anutu le biing-ambe Omaahonôôn Noow haale bop jak gaving, ond yik le biing-ambe bop jak pavis. ");
INSERT INTO mmo_vpl VALUES ("JN13_33","073_13_33","JHN","13","33","33","+ o 13:33 Jon 7:33-34*“Noongg-aso, sa mando gaving ham daka vêêl e mem ham e salo sa, de lohvu saanêêl vu hil Yuda bôôy-ato ond sa naanêêl vu ham gêên-anjo naambe ham-ame alohvu nambe ham ana taaku sen sa navu anaa-ju le. ");
INSERT INTO mmo_vpl VALUES ("JN13_34","073_13_34","JHN","13","34","34","+ o 13:34 Jon 15:12,17; 1Jon 3:23; 2Jon 5*Om sa naanêêl tanasin moos ti vu ham naambe ham ahem gaving ham. Ham ahem gaving ham naambe sen sahengg naving ham-anjo. ");
INSERT INTO mmo_vpl VALUES ("JN13_35","073_13_35","JHN","13","35","35","+ o 13:35 1; Jon 3:14*Ham ahem gaving ham naambêênjo ond hil pin e lanjak ni naambe sate maanggêêm-aso ham.” ");
INSERT INTO mmo_vpl VALUES ("JN13_36","073_13_36","JHN","13","36","36","+ o 13:36 Jon 7:34; 21:18-19*Simon Pita lingin Yesu nambe, “Omaaho Bop, gale gana tana?” Tombe Yesu nêêl laah vu nambe, “Taaku sen sa nalaa-to ond game galohvu nambe osapa sa be gana pavis e, nganjo naalum e mem gale taamuyin sa.” ");
INSERT INTO mmo_vpl VALUES ("JN13_37","073_13_37","JHN","13","37","37","Le Pita nêêl nambe, “Omaaho Bop, nambe vaati sen same aalohvu nambe sa sapa hong pavis-anjo le? Naambe saanggimb in hong ond lung.” ");
INSERT INTO mmo_vpl VALUES ("JN13_38","073_13_38","JHN","13","38","38","Tombe Yesu nêêl laah vu nambe, “Gale ganggimb in sa, me? Sa naanêêl keen lôôt vu hong naambe kokalêêh-ame le naasu peey e, de gale ganjak alum in sa balon yaal vêêl e mem.” ");
INSERT INTO mmo_vpl VALUES ("JN14_1","073_14_1","JHN","14","1","1","+ o 14:1 Jon 14:27*Tombe Yesu nêêl having nambe, “Ham-ame naham jak e, ham alompayo na timu vu Anutu, tonde yik ham alompayo naam timu vu sa gaving. ");
INSERT INTO mmo_vpl VALUES ("JN14_2","073_14_2","JHN","14","2","2","In Aamangg-ate bayêên ond lopayo ngeeyaata neep. Nambe me-neep e, ond sale naanêêl vu ham naambe me-neep e. Lemu neep om sana samu taaku vu ham. ");
INSERT INTO mmo_vpl VALUES ("JN14_3","073_14_3","JHN","14","3","3","+ o 14:3 Jon 12:26; 17:24*Ke, sana galo taaku jung na vêêl e mem saanom gako ham jak-ambe yanaah mando, in taaku sen sa mandôô-to ond ham e mando gaving. ");
INSERT INTO mmo_vpl VALUES ("JN14_4","073_14_4","JHN","14","4","4","De taaku sen sa naavu anaa-to ond ham alak yite mopaatôôv ani lung la.” ");
INSERT INTO mmo_vpl VALUES ("JN14_5","073_14_5","JHN","14","5","5","Le Tomas nêêl vu nambe, “Omaaho Bop, gana tana? Hey doosin, om hey e anjak mopaatôôv-anja ni naambe va?” ");
INSERT INTO mmo_vpl VALUES ("JN14_6","073_14_6","JHN","14","6","6","+ o 14:6 Jon 11:25; Lom 5:1-2; Hiblu 10:20*Tombe Yesu nêêl vu nambe, “Mopaatôôv sa, de vakasin keen sa, osin metumin danggakook sa. Omaaho ti me-le noh mop ango be na vu Aamangg e, malis, yik mopaatôôv sa timu. ");
INSERT INTO mmo_vpl VALUES ("JN14_7","073_14_7","JHN","14","7","7","+ o 14:7 Jon 8:19*Nambe ham anjak sa ningg ond ham alak Mangg ani having, om gêên ham alak ni in ham ahe yi lung la.” ");
INSERT INTO mmo_vpl VALUES ("JN14_8","073_14_8","JHN","14","8","8","Le Pilip nêêl vu nambe, “Omaaho Bop, otaato Mom vu hey, ond mem.” ");
INSERT INTO mmo_vpl VALUES ("JN14_9","073_14_9","JHN","14","9","9","+ o 14:9 Jon 12:45; Kol 1:15; Hiblu 1:3*Tombe Yesu nêêl laah vu nambe, “Pilip, sa nando having ham lôôt, le onaahen doosin sa? Hil sen layi mend ak sa ond yik layi mend ak Mangg, le sim nambe tana sen ganêêl nambe sa taato Mangg vu ham? ");
INSERT INTO mmo_vpl VALUES ("JN14_10","073_14_10","JHN","14","10","10","+ o 14:10 Jon 12:49; 14:24*Mak game gawii-having nambe sa nando hôôk Mangg, de Mangg nando hôôk sa le? De vakasin sen sa naanêêl vu ham-ato ond same yoo naanêêl lohvu sa kangg e, nganjo Mangg sen nando hôôk saa-to yoo nawiing yite kul. ");
INSERT INTO mmo_vpl VALUES ("JN14_11","073_14_11","JHN","14","11","11","+ o 14:11 Jon 10:38; 14:20*Ham ambiing gaving vakasin-anjo naambe sa nando hôôk Mangg de Mangg nando hôôk sa, le naambe nama ond ham akam bu kul pin sen sa naawiing-ato be ham ambiing gaving sa jak vaa-ja. ");
INSERT INTO mmo_vpl VALUES ("JN14_12","073_14_12","JHN","14","12","12","+ o 14:12 Mak 16:19-20*De sa naanêêl keen lôôt vu ham naambe omaaho ti nambe lopayo naam timu vu sa, ond kul pin sen sa naawiing-ato ond le biing naambêênja gaving, tonde le biing kul bopaata lôôt savok sanêêngg kul-anjo na, in sa nala vu Mangg. ");
INSERT INTO mmo_vpl VALUES ("JN14_13","073_14_13","JHN","14","13","13","+ o 14:13 Mat 7:7; Jon 15:16*Tonde va pin sen ham kataangg ak sa haalengg-ato, ond sale aambiing nôôn jak in nambe saambiing Mangg-ate niwêêk osin nikaapulis naatok naam langaah. ");
INSERT INTO mmo_vpl VALUES ("JN14_14","073_14_14","JHN","14","14","14","Om naambe ham kataangg sa in va jak sa haalengg ond sale aambiing.” ");
INSERT INTO mmo_vpl VALUES ("JN14_15","073_14_15","JHN","14","15","15","+ o 14:15 Jon 15:10; 1Jon 5:3*“Nambe ham ahem naving sa ond ham e samu sate tanasin, ");
INSERT INTO mmo_vpl VALUES ("JN14_16","073_14_16","JHN","14","16","16","+ o 14:16 Jon 14:26; 15:26; 16:7*tombe sale kataangg na vu Mangg, tombe mem le biing Omaaho Samusamu ango naam vu ham in nambe mando gaving ham danggata osin danggata. ");
INSERT INTO mmo_vpl VALUES ("JN14_17","073_14_17","JHN","14","17","17","+ o 14:17 Mat 10:20; Jon 16:13; Lom 8:26*Ond yik Vavi Vaambuung sen nanêêl vakasin keen-ato, de hil voon-ame lalohvu nambe gako yi jak e, in me-layi le, de me-lalak ni le, lemu ham ond ham alak ni in nando having ham, de lukando ham alompayo. ");
INSERT INTO mmo_vpl VALUES ("JN14_18","073_14_18","JHN","14","18","18","+ o 14:18 Jon 14:3*De same le gavuuh ham-ambe ham oo mando naambe unoopasiv pambuun e, malis, nganjo sale aanom vu ham. ");
INSERT INTO mmo_vpl VALUES ("JN14_19","073_14_19","JHN","14","19","19","+ o 14:19 Jon 16:16*“Ngaaho lak in hil voon-ame le lanji sa jesin naah e, lemu ham ond ham e angge sa, in sa nando metumin om ham e mando metumin gaving. ");
INSERT INTO mmo_vpl VALUES ("JN14_20","073_14_20","JHN","14","20","20","+ o 14:20 Jon 17:21-23*Tombe hôôk busin-anju ham e anjak ni naambe sa nando hôôk Mangg de ham nando hôôk sa, tonde sa nando hôôk ham. ");
INSERT INTO mmo_vpl VALUES ("JN14_21","073_14_21","JHN","14","21","21","+ o 14:21 Jon 15:10; 16:27; 1Jon 5:3*Tonde omaaho ti vaasu sate tanasin hôôk lopayo be navu samu nivasa, ond omaahôô-ja ahe naving sa. Tombe omaaho ti ahe having sa ond Aamangg e ahe gaving yi, tonde yik sale sahengg gaving yi naambêênja, tombe sale taato sa langaah vu yi in nambe jak sa ningg.” ");
INSERT INTO mmo_vpl VALUES ("JN14_22","073_14_22","JHN","14","22","22","+ o 14:22 Sin 10:40-41*Le Yudas Iskaliot lengo Yudas ango nêêl vu Yesu nambe, “Omaaho Bop, gale taato hong langaah vu hey naambe tana, de game le taato hong langaah vu hil voon e?” ");
INSERT INTO mmo_vpl VALUES ("JN14_23","073_14_23","JHN","14","23","23","+ o 14:23 Mat 18:20; 2Ko 6:16; Ep 3:17*Tombe Yesu nêêl laah vu nambe, “Omaaho ti ahe naving sa ond le taamuyin sate vakasin nivasa, tombe Aamangg e ahe gaving yi, de haay ahondoos Mangg e anaam mando gaving yi. ");
INSERT INTO mmo_vpl VALUES ("JN14_24","073_14_24","JHN","14","24","24","+ o 14:24 Jon 7:16; 14:10*Tonde omaaho ti me-ahe naving sa le, ond me-navu taamuyin sate vakasin e. De vakasin sen ham nangôô-to same sate vakasin e, nganjo Mangg sen wiing sa be sa laam-ato yite vakasin. ");
INSERT INTO mmo_vpl VALUES ("JN14_25","073_14_25","JHN","14","25","25","“Soo naahen nando having ham-ande saanêêl vakasin-anjo vu ham, ");
INSERT INTO mmo_vpl VALUES ("JN14_26","073_14_26","JHN","14","26","26","+ o 14:26 Jon 15:26; 16:7*lemu omaaho sen dôôvu ham keen-ato ond Vavi Vaambuung sen Aamangg e biing nom ak sa haalengg-ato, ond le taahu ham hôôk va pin osin bêêl ham akam jak in va pin sen saanêêl vu ham-anjôôto. ");
INSERT INTO mmo_vpl VALUES ("JN14_27","073_14_27","JHN","14","27","27","+ o 14:27 Jon 14:1; 16:33; Pil 4:7*De sa navu gavuuh ham om saambiing-ambe ham alompayo nanjip melaas naambe sen sa longgpayo neep melaas-ato. De saawiing-ambe ham alompayo melaas ak-anja ond same naawiing nambe sen hil voon dawiing-ambe sil alondpayo melaas ak e, malis, om ham-ame naham jak-ambe ham anjêênin ham e. ");
INSERT INTO mmo_vpl VALUES ("JN14_28","073_14_28","JHN","14","28","28","+ o 14:28 Jon 14:3; Jon 16:28; 20:17; Luk 24:52*De ham hango vakasin sen saanêêl vu ham nambe sa navu gavuuh ham-ande sana, lemu sale aanom vu ham-ato, om naambe ham ahem naving sa ond ham e naapêêlis in sa nala vu Mangg in nambe Aamangg bopaata be savok sa. ");
INSERT INTO mmo_vpl VALUES ("JN14_29","073_14_29","JHN","14","29","29","+ o 14:29 Jon 13:19*Vaa-jo naahen, lemu soo aanêêl vu ham munggin-anja in nambe nôôn jak atombe mem ham e ambiing gaving. ");
INSERT INTO mmo_vpl VALUES ("JN14_30","073_14_30","JHN","14","30","30","+ o 14:30 Jon 12:31; 16:11; Ep 2:2*“Same le naanêêl vakasin ngeeyaata vu ham gaving e, in omaahonôôn voon-anjo silate heendin anipaya Saalang navu balup, lemu me-lohvu nambe kape sa le. ");
INSERT INTO mmo_vpl VALUES ("JN14_31","073_14_31","JHN","14","31","31","+ o 14:31 Jon 10:18; 12:49; Mat 26:46*Le saawiingin nambe hil voon lanjak ni naambe sahengg having Mangg ondeey soo naawiing va lohvu sen Mangg wiing sa be sa laam in-ato. Om ham kandi jak-ambe yana.” ");
INSERT INTO mmo_vpl VALUES ("JN15_1","073_15_1","JHN","15","1","1","“Sak sa hees wain keen, de Mangg ond yik kul wain dangga yi. ");
INSERT INTO mmo_vpl VALUES ("JN15_2","073_15_2","JHN","15","2","2","+ o 15:2 Mat 3:10*Om sa namangg sen me-nayiis nôôn-ato ond Mangg navu katôôv vêêl-ambe naate la, tonde sa namangg sen nayiis nôôn-ato ond Mangg navu katôôv ngaaho be natongin in nambe nyiis nôôn ngeeyaata lôôt. ");
INSERT INTO mmo_vpl VALUES ("JN15_3","073_15_3","JHN","15","3","3","+ o 15:3 Jon 13:10*De ham ond vakasin sen saanêêl vu ham-ato wiing-ambe ham anim vasa lak lung la. ");
INSERT INTO mmo_vpl VALUES ("JN15_4","073_15_4","JHN","15","4","4","+ o 15:4 Jon 6:56*Ham oo mando dôôk sa longgpayo ond mem sale mando dôôk ham alompayo. Le naambe ham-ame mando dôôk sa le, ond ham-ame alohvu nambe anyiis nôôn e, manyinja lohvu hees wain nama sen me-naale lak jêês-ato le, ond me-le nyiis nôôn e. ");
INSERT INTO mmo_vpl VALUES ("JN15_5","073_15_5","JHN","15","5","5","+ o 15:5 Jon 15:16; 1Ko 12:12,27; 2Ko 3:5*“Ke, hees wain sa, de nama ham. Omaaho ti sen nando hôôk sa de sa nando hôôk yii-to, ond le nyiis nôôn ngeeyaata lôôt. De naambe same mando dôôk ham e, ond ham-ame alohvu nambe ambiing vati le. ");
INSERT INTO mmo_vpl VALUES ("JN15_6","073_15_6","JHN","15","6","6","+ o 15:6 Mat 7:19; 13:42*Tonde omaaho ti me-mando dôôk sa le, ond le na menama naambe hees nama sen davu katôôv vêêl-ambe navu bambôôv-ato, tonde dasupin-ambe lala daate lakala kin-ambe kin naya. ");
INSERT INTO mmo_vpl VALUES ("JN15_7","073_15_7","JHN","15","7","7","+ o 15:7 Mat 7:7; Jon 14:13; 16:23*Nambe ham mando dôôk sa, de sate vakasin mando dôôk ham, tombe ham akam wiingin vati be ham kataangg, ond le nôôn jak vu ham. ");
INSERT INTO mmo_vpl VALUES ("JN15_8","073_15_8","JHN","15","8","8","+ o 15:8 Mat 5:16*Naambe ham anyiis nôôn ngeeyaata ond mem Mangg haale le naatu bop jak, tonde nôôn ngeeyaataa-ja taato nambe ham atu sate hil. ");
INSERT INTO mmo_vpl VALUES ("JN15_9","073_15_9","JHN","15","9","9","Sahengg having ham nambe sen Mangg ahe having saa-to, om ham mando dôôk sate ahe havingin-anja lopayo. ");
INSERT INTO mmo_vpl VALUES ("JN15_10","073_15_10","JHN","15","10","10","+ o 15:10 Jon 14:15; 1Jon 2:5*Tonde ham samu sate tanasin, ond ham e mando dôôk sate ahe havingin alopayo naambe sen sa navu taamuyin Mangg-ate tanasin tombe sa nando hôôk yite ahe havingin alopayo. ");
INSERT INTO mmo_vpl VALUES ("JN15_11","073_15_11","JHN","15","11","11","+ o 15:11 Jon 17:13*“Saanêêl vakasin pin-anja laas vu ham in nambe sa kangg vasaa-to ond dukanaas ham alompayo in ham oo naapêêlis lôôt. ");
INSERT INTO mmo_vpl VALUES ("JN15_12","073_15_12","JHN","15","12","12","+ o 15:12 Jon 13:34*De sate tanasin-anjo nambe ham ahem gaving mango-so naambe sen sahengg having ham-ato. ");
INSERT INTO mmo_vpl VALUES ("JN15_13","073_15_13","JHN","15","13","13","+ o 15:13 Jon 10:11; Lom 5:8; 1Jon 3:16*Tonde omaaho ti jimb in dôôvu yite hil ond yite ahe havingin savok hil pin-ate ahend havingin la. ");
INSERT INTO mmo_vpl VALUES ("JN15_14","073_15_14","JHN","15","14","14","+ o 15:14 Mat 12:50*De naambe ham ambiing nohvu saanêêl vu ham-ato, ond sate hil ham. ");
INSERT INTO mmo_vpl VALUES ("JN15_15","073_15_15","JHN","15","15","15","De same le naanêêl ham jesin naah naambe sate hil kul vaha-so ham e, in hil kul vaha-so ond sil doosin kul sen silate yêêv nawiing-ato. Nganjo saanêêl ham nambe ham atu sate hil keen, in va pin sen sa nango neep vu Mangg-ato ond manyinja saanêêl langaah vu ham lung la. ");
INSERT INTO mmo_vpl VALUES ("JN15_16","073_15_16","JHN","15","16","16","+ o 15:16 Jon 15:5; 16:23*Ham-ame aholin sa lak e, nganjo saaholin ham ak-ambe saawiing ham ala in nambe ham ana anyiis nôôn, tombe hamate nôôn-anja mando danggata. Tonde ham kataangg vati lak sa haalengg vu Mangg ond le bu naas vu ham. ");
INSERT INTO mmo_vpl VALUES ("JN15_17","073_15_17","JHN","15","17","17","+ o 15:17 Jon 13:34*Sate tanasin-anjo nambe ham ahem gaving ham.” ");
INSERT INTO mmo_vpl VALUES ("JN15_18","073_15_18","JHN","15","18","18","+ o 15:18 Mat 10:22; 1Jon 3:13*“Naambe hil voon anind baya lôôt in ham ond ham akam bu sen sil oo nind baya lôôt in sa munggin-ato. ");
INSERT INTO mmo_vpl VALUES ("JN15_19","073_15_19","JHN","15","19","19","+ o 15:19 1; Jon 4:5; Jon 17:14*Le naambe hil voon-ate ham ond sil ahend e gaving ham in ham dangga timu. Nganjo hil voon-ame silate ham e, malis, in saaholin ham vu sil lavuun lung la, ondeey hil voon anind baya lôôt in ham. ");
INSERT INTO mmo_vpl VALUES ("JN15_20","073_15_20","JHN","15","20","20","+ o 15:20 Jon 13:16*Tonde ham akam bu vakasin sen saanêêl vu ham nambe kul vaha me-savok yite yêêv-ato le, om sen hil voon dawiing nindanjeen vu sa ond le lambiing nindanjeen vu ham gaving. Nambe sil taamuyin sate vakasin ond sil e taamuyin hamate vakasin gaving. ");
INSERT INTO mmo_vpl VALUES ("JN15_21","073_15_21","JHN","15","21","21","+ o 15:21 Mat 5:11; Mak 13:13; Jon 16:3*Lemu omaahonôôn e lambiing nindanjeen vu ham in sate hil ham, in me-lalak omaaho sen wiing sa be sa laam-ato ni le. ");
INSERT INTO mmo_vpl VALUES ("JN15_22","073_15_22","JHN","15","22","22","De nambe same anaam naanêêl vakasin langaah vu sil e, ond sil-ame le galuuh damind vu sa de va nipaya me-nanjip vu sil e. Le ma de sa laam-ambe saanêêl vu sil-ande laluuh damind vu sa, om gêên sil-ame lalohvu nambe lanjak alund in silate nipaya le. ");
INSERT INTO mmo_vpl VALUES ("JN15_23","073_15_23","JHN","15","23","23","+ o 15:23 Luk 10:16*Tonde omaaho ti nambe nimbaya in sa ond manyinja nimbaya in Mangg having. ");
INSERT INTO mmo_vpl VALUES ("JN15_24","073_15_24","JHN","15","24","24","+ o 15:24 Jon 9:41; 14:11*De kul vaha vaha sen omaaho ti me-wiing bôôy-ato, nambe same anaam-ambe saambiing-ambe lanji le tombe sil galuuh damind vu sa, ond va nipaya me-le nanjip vu sil e. Nganjo gêên layi lung la, tombe nind baya lôôt in haay ahondoos Mangg. ");
INSERT INTO mmo_vpl VALUES ("JN15_25","073_15_25","JHN","15","25","25","+ o 15:25 Saam 35:19; 69:4*Nambêênja in vakasin sen Anutu-te hil kaavu be neep hôôk yate tanasin-ato nôôn jak naambe, ‘Nind baya lôôt in sa malis amu de dangga ma.’ ");
INSERT INTO mmo_vpl VALUES ("JN15_26","073_15_26","JHN","15","26","26","+ o 15:26 Jon 14:26*Ke, tonde Omaaho Samusamu nando having Mangg, tombe sale aambiing naam vu ham, yik Vavi Vaambuung sen nanêêl vakasin keen-ato ond yoo le vu Mangg-ambe naam naanêêl sate vakasin langaah vu ham. ");
INSERT INTO mmo_vpl VALUES ("JN15_27","073_15_27","JHN","15","27","27","+ o 15:27 Luk 1:2; Sin 1:8,21-22*Tonde ham e tatekin sate dangga langaah gaving, in ham oo nando having sa bôôy-ambe tok laam gêên-anjo. ");
INSERT INTO mmo_vpl VALUES ("JN16_1","073_16_1","JHN","16","1","1","“Saanêêl vakasin-anja vu ham in nambe ham baale niwêêk-ande va nimeen-ame kape ham e. ");
INSERT INTO mmo_vpl VALUES ("JN16_2","073_16_2","JHN","16","2","2","+ o 16:2 Mat 24:9; Luk 6:22; Jon 9:22*De hil e gatiiy ham ana mando nanyendangga, tonde busin ti le mem lanyiis ham-ambe ham anggimb, de sil akand e bu naambe yoo dawiing kul anivasa vu Anutu lak va nambêênja. ");
INSERT INTO mmo_vpl VALUES ("JN16_3","073_16_3","JHN","16","3","3","+ o 16:3 Jon 15:21*Sil e lambiing vaa-ja in dangga nambe sil doosin haay ahondoos Mangg, ");
INSERT INTO mmo_vpl VALUES ("JN16_4","073_16_4","JHN","16","4","4","+ o 16:4 Jon 13:19*om saanêêl vakasin-anja vu ham lung la in nambe taamusin vaa-jo naatok, ond ham akam bu vakasin sen saanêêl vu ham-ato jesin naah.” “Same aanêêl vakasin-anjo vu ham bôôy e, in sa nando having ham, ");
INSERT INTO mmo_vpl VALUES ("JN16_5","073_16_5","JHN","16","5","5","+ o 16:5 Jon 7:33; 13:36*le gêên ond sa nalaah vu omaaho sen wiing sa be sa laam-ato, lemu ham ti me-lingin sa nambe, ‘Onala tana?’ Malis. ");
INSERT INTO mmo_vpl VALUES ("JN16_6","073_16_6","JHN","16","6","6","Le gêên saanêêl vakasin-anja vu ham atombe ham alompayo nimeen lôôt, ");
INSERT INTO mmo_vpl VALUES ("JN16_7","073_16_7","JHN","16","7","7","+ o 16:7 Jon 14:16*lemu sa naanêêl keen vu ham naambe sana ond mem le nivasa vu ham. Le naambe same ana le, ond omaaho sen dôôvu ham-ato me-le naam vu ham e, om sana ond mem sale aambiing naam vu ham. ");
INSERT INTO mmo_vpl VALUES ("JN16_8","073_16_8","JHN","16","8","8","Omaahôô-ja naam ond mem le tatekin vu omaahonôôn naambe sil pin dawiing va nipaya, de le taato naambe omaaho lati nivalok, osin tatekin naambe Anutu le gangoyin hil pin-ate vakasin. ");
INSERT INTO mmo_vpl VALUES ("JN16_9","073_16_9","JHN","16","9","9","+ o 16:9 Jon 3:18*Le tatekin naambe va nipaya neep vu sil-anju in me-lawii-having sa le, ");
INSERT INTO mmo_vpl VALUES ("JN16_10","073_16_10","JHN","16","10","10","+ o 16:10 Sin 5:31; Lom 4:25*de le taato naambe omaaho lati nivalok, in sa nalaah vu Mangg-ande ham-ame le angge sa jesin naah e. ");
INSERT INTO mmo_vpl VALUES ("JN16_11","073_16_11","JHN","16","11","11","+ o 16:11 Jon 12:31*Tonde le tatekin naambe Anutu sahi hil voon-ate heendin anipaya yite vakasin lung la be navu bu nyevahaan vu, om le sahi omaahonôôn pin-ate vakasin naambêênjo. ");
INSERT INTO mmo_vpl VALUES ("JN16_12","073_16_12","JHN","16","12","12","+ o 16:12 1Ko 3:1-2*“Sate vakasin sen sa naanêêl vu ham-ato ngeeyaata naahen neep, le ham-ame alohvu nambe ham anjak ni pavis e, ");
INSERT INTO mmo_vpl VALUES ("JN16_13","073_16_13","JHN","16","13","13","+ o 16:13 Jon 14:26; 1Jon 2:27*lemu Vavi Vaambuung vakasin keen-ate le naam atombe le tatekin vakasin keen pin vu ham e mem ham anjak ni. De me-yoo le naanêêl yite vakasin ti le, nganjo vakasin sen nangôô-to ond mem le naanêêl, de va sen naatok vu taamusin-ato ond le naanêêl vu ham naamunggin. ");
INSERT INTO mmo_vpl VALUES ("JN16_14","073_16_14","JHN","16","14","14","Tonde le gako sa haalengg ak, in le gako vakasin vu sa be naam in naanêêl langaah vu ham. ");
INSERT INTO mmo_vpl VALUES ("JN16_15","073_16_15","JHN","16","15","15","De va pin sen Mangg-ate vaa-to ond yik sate va, ondeey saanêêl nambe le gako sate vakasin-ambe naanêêl langaah vu ham.” ");
INSERT INTO mmo_vpl VALUES ("JN16_16","073_16_16","JHN","16","16","16","+ o 16:16 Jon 14:19*“Daka gaving atombe ham-ame le angge sa le, tonde daka gaving e mem ham e angge sa jesin naah.” ");
INSERT INTO mmo_vpl VALUES ("JN16_17","073_16_17","JHN","16","17","17","Tombe yite maanggêêm-aso vaalu yoo lanêêl vu sil nambe, “Nêêl vakasin vaatii-jo? Nambe daka gaving atombe yame le aangge yi le, tonde daka gaving e mem yale aangge yi jesin naah. Tonde nêêl having nambe nala vu Mangganaan. ");
INSERT INTO mmo_vpl VALUES ("JN16_18","073_16_18","JHN","16","18","18","De nêêl nambe daka gaving ond dangga nambe va? Yiiy doosin yite vakasin-anju.” ");
INSERT INTO mmo_vpl VALUES ("JN16_19","073_16_19","JHN","16","19","19","Tombe Yesu lak ni nambe sil lawiingin nambe lanjingin yi, om nêêl vu sil nambe, “Ham oo monalingin ham in sate vakasin sen saanêêl nambe daka gaving atombe ham-ame le angge sa le, tonde daka gaving e mem ham e angge sa naah. ");
INSERT INTO mmo_vpl VALUES ("JN16_20","073_16_20","JHN","16","20","20","Om sa naanêêl keen lôôt vu ham naambe ham e naasu bopaata, de ham akam pasiv lôôt, tonde hil voon e kand vasa de ham alompayo le nimeen, lemu ham alompayo nimeen-anja le gilin-ambe naatu ham akam vasa jak. ");
INSERT INTO mmo_vpl VALUES ("JN16_21","073_16_21","JHN","16","21","21","+ o 16:21 Ais 26:17*Vêêh ti noow nayêêy ond lak ni nambe yinêên busin-ato tok laam in nambe gako nivaane om lopayo nimeen, de naambe hako lung la ond me-le ka bu nivaane jesin naah e, malis, le ka vasa in hako unoopasiv hato laam voon lung la. ");
INSERT INTO mmo_vpl VALUES ("JN16_22","073_16_22","JHN","16","22","22","+ o 16:22 Ais 66:14*Om yik gêên ham alompayo nimeen nambêênja, lemu sale aangge ham jesin, tombe mem ham e kam vasa jak lôôt, de omaaho ti me-le biing-ambe ham alompayo nimeen naah e. ");
INSERT INTO mmo_vpl VALUES ("JN16_23","073_16_23","JHN","16","23","23","+ o 16:23 Mat 7:7; Jon 15:16*De vu busin-anju ond ham-ame le anjingin vati vu sa naah e. Om sa naanêêl keen lôôt vu ham naambe ham kataangg vati vu Mangg jak sa haalengg, ond le bu vu ham. ");
INSERT INTO mmo_vpl VALUES ("JN16_24","073_16_24","JHN","16","24","24","+ o 16:24 Jon 15:11*In bôôy ond ham-ame kataangg vati lak sa haalengg e, om ham kataangg ond ham e gako in nambe ham akam vasa lôôt.” ");
INSERT INTO mmo_vpl VALUES ("JN16_25","073_16_25","JHN","16","25","25","+ o 16:25 Mak 4:33-34*“Saanêêl vakasin pin vu ham-anjo lak vakasin pakwesin amu, tonde busin ti navu naatok ond same le naanêêl vu ham jak vakasin pakwesin ti jesin naah e, nganjo sale naanêêl Mangg-ate danggakook tatekin nanjip langaah vu ham. ");
INSERT INTO mmo_vpl VALUES ("JN16_26","073_16_26","JHN","16","26","26","Tonde hôôk busin-anju ond ham e kataangg Mangg jak sa haalengg, de same le naanêêl vu ham naambe sale kataangg Mangg in dôôvu ham e, ");
INSERT INTO mmo_vpl VALUES ("JN16_27","073_16_27","JHN","16","27","27","+ o 16:27 Jon 14:21,23*in Mangg ahe yoo naving ham, in ham ahem naving sa be ham awii-having sa nambe sa nando having Anutu be sa laam. ");
INSERT INTO mmo_vpl VALUES ("JN16_28","073_16_28","JHN","16","28","28","+ o 16:28 Jon 13:3*Bôôy sa nando having Aamangg, tombe sa havuuh Aamangg-ande saalukalaam voon, tonde sim sa navu gavuuh voon-anjo de sa naah vu Mangg jesin.” ");
INSERT INTO mmo_vpl VALUES ("JN16_29","073_16_29","JHN","16","29","29","Le yite maanggêêm-aso lanêêl vu nambe, “Ke mem, gêên ganêêl neep langaah-ande game ganêêl ak vakasin pakwesin e. ");
INSERT INTO mmo_vpl VALUES ("JN16_30","073_16_30","JHN","16","30","30","+ o 16:30 Jon 2:25*Om gêên hey alak ni nambe goo galak va pin ani lung la, de game doosin vati in nambe omaaho ti naanêêl vu hong e, om sen hey aawii-having nambe galaam vu Anutu.” ");
INSERT INTO mmo_vpl VALUES ("JN16_31","073_16_31","JHN","16","31","31","Tombe Yesu nêêl laah vu sil nambe, “Gêên-anjo ham awii-having sa? ");
INSERT INTO mmo_vpl VALUES ("JN16_32","073_16_32","JHN","16","32","32","+ o 16:32 Mat 26:31,56; Jon 8:29*Om ham gango le, busin ti navu naatok ond tok laam lung laa-jo, tombe ham navu gavuuh taale be ham andukanaah ham ambaam ti ti, de sa timu soo le mando, lemu same soo timu mando le, in Mangg nando having sa. ");
INSERT INTO mmo_vpl VALUES ("JN16_33","073_16_33","JHN","16","33","33","+ o 16:33 Jon 14:27; Lom 5:1; 2Ti 3:12; 1Jon 5:4*Saanêêl vakasin-anjo vu ham in nambe ham akam bu sa be ham alompayo gato javuh, in vu voon-anjo va nimeen e danjingin ham, lemu ham-ame naham jak e, in sa laanggôôl va nipaya voon-ate lung la.” ");
INSERT INTO mmo_vpl VALUES ("JN17_1","073_17_1","JHN","17","1","1","+ o 17:1 Jon 11:41; 12:23*Yesu nêêl nambêênju lung la, tonde valaah me lak baandoni de nêêl nambe, “O Aamangg, busin-ato lung laa-jo om onggako Noom haale jak in nambe Noom gako ohaalem jak. ");
INSERT INTO mmo_vpl VALUES ("JN17_2","073_17_2","JHN","17","2","2","+ o 17:2 Mat 28:18*Gawiing-ambe saatu omaahonôôn pin-ate lukook in nambe saambiing-ambe hil pin sen gavu vu saa-to mando metumin danggata osin danggata. ");
INSERT INTO mmo_vpl VALUES ("JN17_3","073_17_3","JHN","17","3","3","+ o 17:3 1; Jon 5:20*Tombe mando metumin danggataa-to dangga nambe omaahonôôn lanjak ganim naambe hong Anutu nôôn keen timu, osin lanjak Yesu Kalisi sen gawiing laam-ato ni. ");
INSERT INTO mmo_vpl VALUES ("JN17_4","073_17_4","JHN","17","4","4","+ o 17:4 Jon 4:34; 14:13*Sa samu kul sen gavu vu sa in nambe saambiing-ato lung la, be sa hako ohaalem ak vu voon. ");
INSERT INTO mmo_vpl VALUES ("JN17_5","073_17_5","JHN","17","5","5","+ o 17:5 Jon 1:1; 17:24*O Aamangg, onggako sa haalengg ak naah naambe sen vu munggin ngaanggis ma de sa nando having hong-ato. ");
INSERT INTO mmo_vpl VALUES ("JN17_6","073_17_6","JHN","17","6","6","“Saanêêl gate dangga langaah lung la vu hil sen gavu sil vu sa vu voon-ato. Goo gate sil, lemu gavu sil vu sa lung la, tombe sil davu taamuyin gate vakasin, ");
INSERT INTO mmo_vpl VALUES ("JN17_7","073_17_7","JHN","17","7","7","tombe gêên sil lalak ni lung la nambe va pin sen gavu vu saa-to yoo laam vu hong. ");
INSERT INTO mmo_vpl VALUES ("JN17_8","073_17_8","JHN","17","8","8","+ o 17:8 Jon 16:30*In vakasin pin sen gavu vu saa-to ond saavu vu sil lung la, be lako lak-ambe lalak ni keen lôôt nambe bôôy sa nando having hong-ambe sa laam, de lawii-having nambe goo gawiing sa be sa laam. ");
INSERT INTO mmo_vpl VALUES ("JN17_9","073_17_9","JHN","17","9","9","+ o 17:9 Jon 6:37,44*Om sa naalohak in sil, de same naalohak in hil voon-ate le, nganjo sa naalohak in hil sen gavu sil vu saa-to in gate sil. ");
INSERT INTO mmo_vpl VALUES ("JN17_10","073_17_10","JHN","17","10","10","+ o 17:10 Jon 16:15*Sate va-so pin latu gate va, de gate va-so latu sate va, tombe sate va-so lako sa haalengg ak. ");
INSERT INTO mmo_vpl VALUES ("JN17_11","073_17_11","JHN","17","11","11","+ o 17:11 Jon 10:30; 17:21; Gal 3:28*De same le mando voon naah e, nganjo sil oo le mando de sa naalos vu hong. O Aamangg Vaambuung, goo ganggin sil jak gate niwêêk sen gavu vu saa-to, in sil mando javuh ti naambe hoow nando lavuh tii-to. ");
INSERT INTO mmo_vpl VALUES ("JN17_12","073_17_12","JHN","17","12","12","+ o 17:12 Jon 6:39; 18:9; 13:18*De sa nando having sil-ato ond sa nanggin sil lak gate niwêêk sen gavu vu saa-to. Soo nanggin sil nivasa de sil ti me-la mema le, yik omaaho timu sen navu gako nyevahaan-ambe na menamaa-to ond yoo timu le na menama valok-ate, in nambe vakasin sen neep hôôk gate kaapiyaa-to nôôn jak. ");
INSERT INTO mmo_vpl VALUES ("JN17_13","073_17_13","JHN","17","13","13","+ o 17:13 Jon 15:11*“Ngaaho lak in sa navu anaas vu hong, om sa naanêêl vakasin-anjo vu voon in nambe sa kangg vasaa-to ond naapup hôôk sil alondpayo gaving. ");
INSERT INTO mmo_vpl VALUES ("JN17_14","073_17_14","JHN","17","14","14","+ o 17:14 Jon 15:19*De saanêêl gate vakasin vu sil atombe hil voon anind baya lôôt in sil, in silate danggakook-ame vu voon-anjo le, nambe sen same vu voon-anjo le. ");
INSERT INTO mmo_vpl VALUES ("JN17_15","073_17_15","JHN","17","15","15","+ o 17:15 Mat 6:13; 2Tes 3:3; 1Jon 5:18*Same navu kataangg in nambe ganôôh sil vêêl vu voon-anjo le, malis, nganjo sa navu kataangg in nambe ongganggin sil in Omaaho Nipaya. ");
INSERT INTO mmo_vpl VALUES ("JN17_16","073_17_16","JHN","17","16","16","Silate danggakook-ame vu voon-anjo le, nambe sen same vu voon-anjo le. ");
INSERT INTO mmo_vpl VALUES ("JN17_17","073_17_17","JHN","17","17","17","Ond gambiing-ambe sil daatu gate hil vaambuung jak gate vakasin keen, in gate vakasin ond vakasin keenaanôôn. ");
INSERT INTO mmo_vpl VALUES ("JN17_18","073_17_18","JHN","17","18","18","+ o 17:18 Jon 20:21*Nambe sen gawiing sa be sa laam vu hil voon, tonde sim saawiing-ambe sil lala vu hil voon. ");
INSERT INTO mmo_vpl VALUES ("JN17_19","073_17_19","JHN","17","19","19","+ o 17:19 Hiblu 10:10*Saavu sa la doos vu hong in nambe saandôôvu sil in nambe sil daatu gate hil vaambuung keen gaving. ");
INSERT INTO mmo_vpl VALUES ("JN17_20","073_17_20","JHN","17","20","20","De same navu kataangg in hil-anjo mu le, nganjo sa navu kataangg in hil sen gango silate vakasin-ambe lambiing gaving saa-to having. ");
INSERT INTO mmo_vpl VALUES ("JN17_21","073_17_21","JHN","17","21","21","+ o 17:21 Jon 14:11; Gal 3:28*“O Aamangg, gambiing-ambe sil pin mando javuh ti naambe sen onando hôôk sa de sa nando hôôk hong-ato, tombe yik sil mando hôôk hoow, in hil voon lambiing gaving naambe gawiing sa be sa laam. ");
INSERT INTO mmo_vpl VALUES ("JN17_22","073_17_22","JHN","17","22","22","+ o 17:22 Sin 4:32*Tombe gate nikaapulis sen gavu vu saa-to ond saavu vu sil, in sil mando javuh ti naambe sen hoow nando lavuh tii-to. ");
INSERT INTO mmo_vpl VALUES ("JN17_23","073_17_23","JHN","17","23","23","Sa nando hôôk sil-ande onando hôôk sa in nambe sil mando javuh ti bulôôt, in nambe hil voon lanjak ni naambe gawiing sa be sa laam, osin sil lanjak ni naambe gahem naving gate hil nambe sen gahem naving saa-to. ");
INSERT INTO mmo_vpl VALUES ("JN17_24","073_17_24","JHN","17","24","24","+ o 17:24 Jon 12:26; 17:5*“O Aamangg, gavu sil vu sa om saawiingin nambe sil mando gaving sa vu taaku sen sana mandôô-to, in lanji sate nikaapulis sen gavu vu saa-to, in gahem oo naving sa vu munggin sen ngaanggis maa-to. ");
INSERT INTO mmo_vpl VALUES ("JN17_25","073_17_25","JHN","17","25","25","+ o 17:25 Jon 8:55*“O Aamangg, hong Omaaho Nivalok, hil voon-ame lalak ganim e, lemu sa lak ganim, de gate hil-anjo ond lalak ni nambe gawiing sa be sa laam. ");
INSERT INTO mmo_vpl VALUES ("JN17_26","073_17_26","JHN","17","26","26","Saanêêl hong langaah vu sil, de soo le monaanêêl, in gate ahe havingin sen gahem naving saa-to na nohvu sil gaving, tonde sa mando hôôk sil alondpayo.” ");
INSERT INTO mmo_vpl VALUES ("JN18_1","073_18_1","JHN","18","1","1","+ o 18:1 Mat 26:36*Yesu lohak lung la tonde having yite maanggêêm-aso be lala bel Kidlon vaalu, be lala lalup taaku ti sen hil daalôôh haah ayuuh amêê-to, tombe sil ahondoos lalukala. ");
INSERT INTO mmo_vpl VALUES ("JN18_2","073_18_2","JHN","18","2","2","+ o 18:2 Luk 21:37; 22:39*De Yudas sen navu bu Yesu dukana hil namand-ato ond yoo lak taakuu-ju ni lung la, in Yesu having yite maanggêêm-aso dasupin sil vuu-ju lak busin ngeeyaata. ");
INSERT INTO mmo_vpl VALUES ("JN18_3","073_18_3","JHN","18","3","3","+ o 18:3 Jon 7:32,45*Tonde Yudas hako hil Lom ngaamong vaha lu ti, osin ahevaavu-so ond yik hil kul vaha sen datung salivangin-ato silate yêêv-aso osin hil Palisai lawiing ahevaavu-sôônju lalaa-to, tombe sil taalungg kin osin lam tonde lako va ngaamong-ate having-ambe lala lalup taakuu-ju. ");
INSERT INTO mmo_vpl VALUES ("JN18_4","073_18_4","JHN","18","4","4","De Yesu yoo lak va pin sen navu naatovu yii-to vulôôt, om la lingin sil nambe, “Ham navu salo lati?” ");
INSERT INTO mmo_vpl VALUES ("JN18_5","073_18_5","JHN","18","5","5","Le lanêêl laah vu nambe, “Yesu Nasaalet.” Tombe Yesu nêêl vu sil nambe, “Yik saa-jo.” De Yudas sen giiy hil-anju lala in nambe lanôôh Yesuu-to ond naale having ngaamong vaha-so. ");
INSERT INTO mmo_vpl VALUES ("JN18_6","073_18_6","JHN","18","6","6","Om sen Yesu nêêl vu sil nambe “Yik saa-jo,” ond sil lalaah ak damind tombe lalupake be lala deep voon. ");
INSERT INTO mmo_vpl VALUES ("JN18_7","073_18_7","JHN","18","7","7","Tombe lingin sil laah nambe, “Ham navu salo lati?” Tombe lanêêl nambe, “Yesu Nasaalet-ato.” ");
INSERT INTO mmo_vpl VALUES ("JN18_8","073_18_8","JHN","18","8","8","Tombe Yesu nêêl laah nambe, “Saanêêl vu ham lung la nambe yik saa-jo, om naambe ham navu salo sa ond ham baale de sate hil-anjo lana vêêl e.” ");
INSERT INTO mmo_vpl VALUES ("JN18_9","073_18_9","JHN","18","9","9","+ o 18:9 Jon 17:12*Nêêl nambêênju in yite vakasin sen nêêl lung laa-to nôôn jak naambe, “Sil sen gavu sil vu saa-to ond sil ti me-la mema le.” ");
INSERT INTO mmo_vpl VALUES ("JN18_10","073_18_10","JHN","18","10","10","Tombe Simon Pita hako yipak diin ti sapa, om hatul vêêl-ambe sap yêêv bop salivangin-ate yite hil kul ti nanyelis vasa be yêêhin, hil kul tii-ju haale nambe Malkas. ");
INSERT INTO mmo_vpl VALUES ("JN18_11","073_18_11","JHN","18","11","11","+ o 18:11 Mat 26:39*Tombe Yesu nêêl vu Pita nambe, “Ganjop gate yipak dukanaah naavi. Gambe va nimeen sen Mangg vu vu saa-to ond sale aanoh nanye in a?” ");
INSERT INTO mmo_vpl VALUES ("JN18_12","073_18_12","JHN","18","12","12","Tonde hil Lom ngaamong vaha lu tii-ju laving silate yêêv osin hil Yuda-te ahevaavu-so be lalôôh Yesu be landuuh, ");
INSERT INTO mmo_vpl VALUES ("JN18_13","073_18_13","JHN","18","13","13","tombe lako be lala vu Kaiapas yêên Anas vêêl e. Kaiapas-anju ond tu kul vaha salivangin-ate silate yêêv bop hôôk ta tii-ju, ");
INSERT INTO mmo_vpl VALUES ("JN18_14","073_18_14","JHN","18","14","14","+ o 18:14 Jon 11:49-51*ond yik Kaiapas-anju sen nêêl vu hil Yuda bôôy nambe, “Omaaho timu jimb in dôôvu hil pin ond mem nivasa.” ");
INSERT INTO mmo_vpl VALUES ("JN18_15","073_18_15","JHN","18","15","15","+ o 18:15 Jon 20:3; 21:20; Mat 26:58*Tonde Simon Pita yuuh maanggêêm ango taamuyin Yesu be lala, tombe maanggêêm angôô-ju ond kul vaha sen datung salivangin-ato silate yêêv bop yoo lak ni, om lukala yêêv bop-anjute baan kaatum alopayo having Yesu, ");
INSERT INTO mmo_vpl VALUES ("JN18_16","073_18_16","JHN","18","16","16","tonde Pita yoo naale voon ngaaho vu vinavi. De maanggêêm ango sen yêêv bop salivangin-ate lak nii-to ond nêêl vu vêêh sen nanggin vinavii-to vêêl e mem giiy Pita lukala. ");
INSERT INTO mmo_vpl VALUES ("JN18_17","073_18_17","JHN","18","17","17","Tombe vêêh kul tii-ju lingin Pita nambe, “Mak omaahôô-ju yite maanggêêm ti hong-anja?” Le Pita nêêl nambe, “Sak ma.” ");
INSERT INTO mmo_vpl VALUES ("JN18_18","073_18_18","JHN","18","18","18","De taaku nikuuh om hil kul-ate osin ahevaavu-so lavaav kin-ambe daale mondanyuuh kin, tombe yik Pita la naale monanyuuh kin having sil. ");
INSERT INTO mmo_vpl VALUES ("JN18_19","073_18_19","JHN","18","19","19","Tombe kul vaha sen datung salivangin-ato silate yêêv bop lingin Yesu in yite maanggêêm-aso osin yite tanasin sen navu taahu omaahonôôn-ato. ");
INSERT INTO mmo_vpl VALUES ("JN18_20","073_18_20","JHN","18","20","20","+ o 18:20 Mat 26:55; Jon 7:26*Le Yesu nêêl laah nambe, “Sa naanêêl vu omaahonôôn pin neep langaah, de soo navu taahu hil hôôk dumb pasiv vaalu osin hôôk Anutu-te dumb bop alo sen hil Yuda pin dasupin sil hôôk-ato having, de same aanêêl vakasin ti hôôk vunin e, ");
INSERT INTO mmo_vpl VALUES ("JN18_21","073_18_21","JHN","18","21","21","om galingin sa in? Nganjo ganjingin hil sen dangôô-to naambe saanêêl vaati vu sil, in vakasin sen sa naanêêl-ato ond sil lalak ni.” ");
INSERT INTO mmo_vpl VALUES ("JN18_22","073_18_22","JHN","18","22","22","+ o 18:22 Sin 23:2; Jon 19:3*Yesu nêêl nambêênju tonde ahevaavu ti naalêê-ju ond yik patap Yesu de nêêl vu nambe, “Game naanêêl vakasin naambêênja vu yêêv bop salivangin-ate le.” ");
INSERT INTO mmo_vpl VALUES ("JN18_23","073_18_23","JHN","18","23","23","Le Yesu nêêl laah vu nambe, “Saanêêl vakasin ti paya ond onaanêêl naam langaah naambe saanêêl ti tana paya, le naambe saanêêl lohvu, le nambe vaati sen gayiis sa malis amu?” ");
INSERT INTO mmo_vpl VALUES ("JN18_24","073_18_24","JHN","18","24","24","Landuuh Yesu lung la be hees oo naahen lakando yi, tonde Anas wiing la vu yêêv bop salivangin-ate Kaiapas. ");
INSERT INTO mmo_vpl VALUES ("JN18_25","073_18_25","JHN","18","25","25","Simon Pita naale monanyuuh kin tombe lanêêl vu yi nambe, “Mak Yesu-te maanggêêm ti hong-anja?” Le Pita lak alu nambe, “Sak ma.” ");
INSERT INTO mmo_vpl VALUES ("JN18_26","073_18_26","JHN","18","26","26","+ o 18:26 Jon 18:1,10*Tombe yêêv bop salivangin-ate hil kul ti ond omaaho sen Pita sap nanyelis vaalu laa-to yite omaaho ti sen yik sil dangga timuu-to, ond nêêl vu Pita nambe, “Mak saahe hong-anja naale having Yesu hôôk taaku sen daalôôh haah ayuuh ame vu nganjuu-to?” ");
INSERT INTO mmo_vpl VALUES ("JN18_27","073_18_27","JHN","18","27","27","+ o 18:27 Jon 13:38*Le Pita lak alu yesin laah, tonde pavis atombe kokalêêh su. ");
INSERT INTO mmo_vpl VALUES ("JN18_28","073_18_28","JHN","18","28","28","Samiinaanôôn atombe lako Yesu vu Kaiapas ambaan-ambe lala yêêv bop Lom-ate taaku, lemu hil Yuda me-lalukala yêêv Lom-anju yite taaku le, in layêênin nambe sil e nind paya jak tombe me-lohvu nambe lanja vanôôn busin haluusin-ato le. ");
INSERT INTO mmo_vpl VALUES ("JN18_29","073_18_29","JHN","18","29","29","Om yêêv bop Pilata laam voon vu sil-ambe nêêl nambe, “Ham awiingin nambe naanêêl vakasin vaati jak omaahôô-ja?” ");
INSERT INTO mmo_vpl VALUES ("JN18_30","073_18_30","JHN","18","30","30","Tombe lanêêl laah nambe, “Omaahôô-jo nambe me-nawiing nipaya le ond hey-ame le gako naam vu hong e.” ");
INSERT INTO mmo_vpl VALUES ("JN18_31","073_18_31","JHN","18","31","31","+ o 18:31 Jon 19:6-7; Sin 18:15*Le Pilata nêêl laah nambe, “Mam, ham oo gako naas-ambe ham sahi yi nohvu hamate tanasin.” Le lanêêl vu nambe, “Ham Lom nanêêlin nambe hey-ame aanyiis omaaho ti jimb e.” ");
INSERT INTO mmo_vpl VALUES ("JN18_32","073_18_32","JHN","18","32","32","+ o 18:32 Mat 20:19; Jon 3:14; 12:33*Ond nambêênju in nambe Yesu-te vakasin sen nêêl langaah bôôy nambe le jimb ak haah pakôô-to navu nôôn jak. ");
INSERT INTO mmo_vpl VALUES ("JN18_33","073_18_33","JHN","18","33","33","Om Pilata lukalaah gaaman-ate taaku yesin tombe teey Yesu laam-ambe lingin nambe, “Hil Yuda-te omaaho lulemak hong a?” ");
INSERT INTO mmo_vpl VALUES ("JN18_34","073_18_34","JHN","18","34","34","Tombe Yesu nêêl laah nambe, “Goo gakam vu be ganêêl vakasin-anja, me vaheey lanêêl sa vu hong a?” ");
INSERT INTO mmo_vpl VALUES ("JN18_35","073_18_35","JHN","18","35","35","+ o 18:35 Jon 1:11*Le Pilata nêêl laah vu nambe, “Same Yuda ti le, goo gate hil laving yêêv-aso salivangin-ate lako hong laam vu sa, de gawiing vaati?” ");
INSERT INTO mmo_vpl VALUES ("JN18_36","073_18_36","JHN","18","36","36","Tombe Yesu nêêl nambe, “Hil sen sa nanggin-ato ond danggakook-ame vu voon-anjo le. Nambe danggakook vu voon-anjo ond sate hil e lambiing ngaamong in nambe omaaho ti me-bu sa dukana hil Yuda namand e, le ma de sa nanggin sate hil-ato ond danggakook-ame vu voon-anjo le.” ");
INSERT INTO mmo_vpl VALUES ("JN18_37","073_18_37","JHN","18","37","37","+ o 18:37 1Ti 6:13; Jon 3:32-33; 8:47*Tombe mem Pilata lingin laah vu nambe, “Om hong omaaho lulemak ti?” Tombe Yesu nêêl laah nambe, “Ganêêl lohvu. Sa omaaho lulemak ti ondeey ataak hako sa, tombe saalukalaam voon in nambe sa naanêêl vakasin keen langaah, tombe hil pin sen sil davu taamuyin vakasin keen-ato ond sil dango sa lavangg.” ");
INSERT INTO mmo_vpl VALUES ("JN18_38","073_18_38","JHN","18","38","38","Tombe Pilata lingin nambe, “Vakasin keen-anjo nambe vaati?” Pilata nêêl vakasin-anju lung la tonde hato laah voon-ambe nêêl vu hil Yuda nambe, “Same aatovu yite vakasin ti le, ");
INSERT INTO mmo_vpl VALUES ("JN18_39","073_18_39","JHN","18","39","39","lemu hamate gambum neep nambe sa navu kavaayin kalaambus ti hôôk busin bop busin haluusin-ambe sa naavu laas malis vu ham, om ham awiingin nambe sa kavaayin hil Yuda-te omaaho lulemak vu ham a?” ");
INSERT INTO mmo_vpl VALUES ("JN18_40","073_18_40","JHN","18","40","40","Le sil pin lateey la vu nambe, “Yii-jak ma, nganjo Balabas amu.” Balabas-anjo yi omaaho ngaamong osin hôôndak ambu ti. ");
INSERT INTO mmo_vpl VALUES ("JN19_1","073_19_1","JHN","19","1","1","Tombe Pilata nêêl-ambe hil Lom ngaamong vaha-so lako Yesu la be laveek ak hees. ");
INSERT INTO mmo_vpl VALUES ("JN19_2","073_19_2","JHN","19","2","2","+ o 19:2 Luk 23:11*Tonde lasêêy hees aniyin-ambe lambuuhin tombe latung lakala lu, be davu taahu omaaho lulemak ak yi, tonde lalop tôômb amembu ti lukala yi, ");
INSERT INTO mmo_vpl VALUES ("JN19_3","073_19_3","JHN","19","3","3","+ o 19:3 Jon 18:22*tombe lala daale mekaalus de lanêêl vu nambe, “Yuda-te omaaho lulemak omando-o.” Tonde sil patap yi. ");
INSERT INTO mmo_vpl VALUES ("JN19_4","073_19_4","JHN","19","4","4","+ o 19:4 Jon 18:38*Layiis lung atonde Pilata hato laah voon-ambe nêêl vu hil Yuda nambe, “Sa navu gako nom voon vu ham in nambe ham oo anjak ni naambe same aatovu yite vakasin ti le.” ");
INSERT INTO mmo_vpl VALUES ("JN19_5","073_19_5","JHN","19","5","5","Tombe mem Yesu hato la voon osin hees aniyin sen lambuuhin hôôk luu-to de tôômb amembu lakaneep yi, tombe Pilata nêêl vu sil nambe, “Ham angge omaahôô-ja.” ");
INSERT INTO mmo_vpl VALUES ("JN19_6","073_19_6","JHN","19","6","6","+ o 19:6 Jon 18:31*Tombe kul vaha sen datung salivangin-ato silate yêêv-aso osin ahevaavu-so layi tombe lateey nambe, “Ganyiis jakana haah pako. Ganyiis jakana haah pako.” Tombe Pilata nêêl laah vu sil nambe, “Om ham oo gako naas-ambe ham anyiis jakana haah pako, in sak same aatovu vakasin ti neep vu yi le.” ");
INSERT INTO mmo_vpl VALUES ("JN19_7","073_19_7","JHN","19","7","7","+ o 19:7 Lev 24:16; Jon 5:18; 18:31*Le hil Yuda lanêêl laah vu nambe, “Heyate tanasin ti neep tombe yik tanasin-anju nêêl nambe jimb in hatee yi lak nambe Anutu Noow yi.” ");
INSERT INTO mmo_vpl VALUES ("JN19_8","073_19_8","JHN","19","8","8","Pilata hango vakasin-anju tombe yêênin daka lôôt, ");
INSERT INTO mmo_vpl VALUES ("JN19_9","073_19_9","JHN","19","9","9","+ o 19:9 Mat 26:62-63; 27:12; Luk 23:9*tombe lukalaah gaaman-ate taaku be lingin Yesu laah nambe, “Hong vu tana?” Le Yesu lava ma. ");
INSERT INTO mmo_vpl VALUES ("JN19_10","073_19_10","JHN","19","10","10","Tombe Pilata nêêl vu nambe, “Nambe vaati sen game vakaas vu sa le? Galak ni nambe saatu danggakook a? Om sa naanêêl naambe sil kavaayin hong-ambe gana ond sil e kavaayin, me sa naanêêl naambe lanyiis hong jakana haah pako ond le lanyiis.” ");
INSERT INTO mmo_vpl VALUES ("JN19_11","073_19_11","JHN","19","11","11","+ o 19:11 Jon 10:18; Sin 2:23; Lom 13:1*Le Yesu nêêl laah nambe, “Anutu baandoni me-jiinggis e ond game galohvu nambe gambiing vati vu sa le, om omaaho sen vu sa lukala onamam-ato ond yite nipaya bopaata lôôt savok gate nipaya la.” ");
INSERT INTO mmo_vpl VALUES ("JN19_12","073_19_12","JHN","19","12","12","+ o 19:12 Luk 23:2; Sin 17:7*Pilata hango vakasin-anju tombe navu salo mop in nambe kavaayin Yesu be yoo na, le hil Yuda lateey nambe, “Okavaayin omaahôô-ja be yoo na ond omaaho lulemak Sisa me-yite omaaho hong e. In omaaho ti yoo naanêêl naambe yi omaaho lulemak ond hatee yi lak vu Sisa, le nambe vaati sen okavaayin yi?” ");
INSERT INTO mmo_vpl VALUES ("JN19_13","073_19_13","JHN","19","13","13","Pilata hango vakasin-anju tombe giiy Yesu la voon, tombe Pilata la hato nando taaku ti sen dawiing vakasin-ato, ond taakuu-ju danêêl nambe Pêêt Tatuuh, danêêl hôôk Yuda lavand Hiblu nambe Gabata. ");
INSERT INTO mmo_vpl VALUES ("JN19_14","073_19_14","JHN","19","14","14","Lawiing vakasin-anju hôôk busin sen davu samu sil in lanja vanôôn busin haluusin-ate. Ond taaku me laam naale lavuun atombe Pilata nêêl vu hil Yuda nambe, “Ham angge hamate omaaho lulemak nganjo.” ");
INSERT INTO mmo_vpl VALUES ("JN19_15","073_19_15","JHN","19","15","15","Le sil lateey laah nambe, “Ganyiis-ambe jimb. Ganyiis-ambe jimb. Ganyiis jakana haah pako.” Tombe Pilata lingin sil nambe, “Ham awiingin nambe saanyiis hamate omaaho lulemak jakana haah pako?” Tombe yêêv-aso salivangin-ate lateey laah nambe, “Heyate omaaho lulemak ti me-nando le, yik Sisa yoo timu.” ");
INSERT INTO mmo_vpl VALUES ("JN19_16","073_19_16","JHN","19","16","16","Lateey nambêênju tombe mem Pilata vu Yesu lukala sil namand in nambe lanyiis jakana haah pako. ");
INSERT INTO mmo_vpl VALUES ("JN19_17","073_19_17","JHN","19","17","17","Om lako Yesu tombe yoo kava yite haah pako be lala taaku ti haale nambe Taaku Lukook, de danêêl hôôk Yuda lavand Hiblu nambe Golagaata. ");
INSERT INTO mmo_vpl VALUES ("JN19_18","073_19_18","JHN","19","18","18","Tombe mem layiis yi lakala haah pako vu taakuu-ju, tombe layiis omaaho yuuh daale vaalu vaalu de Yesu naale lavuunaatôôv. ");
INSERT INTO mmo_vpl VALUES ("JN19_19","073_19_19","JHN","19","19","19","Tonde Pilata kaavu vakasin ti be hambe lakala neep ak haah pako ond kaavu nambe, “Yesu Nasaalet, Yuda-te Omaaho Lulemak.” ");
INSERT INTO mmo_vpl VALUES ("JN19_20","073_19_20","JHN","19","20","20","Tombe taaku sen lasi Yesu lakala haah pakôô-to ond neep ngaaho vu bayêên bop Yelusalem, om hil Yuda ngeeyaata layi vakasin-anju, in Pilata kaavu vakasin-anju hôôk Yuda lavand Hiblu, de hôôk hil Lom lavand, tonde hôôk Glik lavand having. ");
INSERT INTO mmo_vpl VALUES ("JN19_21","073_19_21","JHN","19","21","21","Tombe Yuda-te kul vaha sen datung salivangin-ato silate yêêv-aso lanêêl vu Pilata nambe, “Game kaavu naambe hil Yuda-te omaaho lulemak e, malis, nganjo okaavu naambe, ‘Omaahôô-jo yoo nêêl yi nambe hil Yuda-te omaaho lulemak yi.’” ");
INSERT INTO mmo_vpl VALUES ("JN19_22","073_19_22","JHN","19","22","22","Le Pilata nêêl laah nambe, “Vakasin sen sa kaavuu-juuto ond sa kaavu lung, nanjip.” ");
INSERT INTO mmo_vpl VALUES ("JN19_23","073_19_23","JHN","19","23","23","Hil Lom ngaamong vaha-so layiis Yesu lakala haah pako lung la, le mem lako yite tôômb ayuuh ame be latiiy ak lu yumbeyuuh, tombe lako lu ti ti lohvu sil. Tonde lako yite lolop diin sen me-landuuh e, laasu mu vu kakook-ambe tok la vahaa-to, ");
INSERT INTO mmo_vpl VALUES ("JN19_24","073_19_24","JHN","19","24","24","+ o 19:24 Saam 22:18*tombe yoo lanêêl vu sil nambe, “Yame naakweek e, yiiy gaate tatuuh-ambe yiiy tambe in nambe naatok gato yiiy ti tana me ond jop lolop tii-jo.” Lanêêl nambêênju in nambe Anutu-te vakasin sen yite hil kaavu lukaneep hôôk kaapiyaa-to navu nôôn jak naambe, “Sil latiiy sate lolop ayuuh ame be lohvu sil, de sil laate tatuuh-ambe sil tambe in nambe tatuuh naatok gato ti tana me ond jop sate lolop.” Tombe hil Lom ngaamong vaha-so lawiing nambêênju. ");
INSERT INTO mmo_vpl VALUES ("JN19_25","073_19_25","JHN","19","25","25","+ o 19:25 Mat 27:55-56*Tombe Yesu tangganaan Malia, de Malia halivêêh ango, de Klopas vane Malia, tonde Malia Magadala, ke, sil-anjo daale ngaaho vu Yesu-te haah pako. ");
INSERT INTO mmo_vpl VALUES ("JN19_26","073_19_26","JHN","19","26","26","+ o 19:26 Jon 13:23*Tombe Yesu yi nambe tangganaan ayuuh maanggêêm ti sen Yesu yoo ahe having yii-to daale, om nêêl vu tangganaan nambe, “Ataak, gangge noom-anja.” ");
INSERT INTO mmo_vpl VALUES ("JN19_27","073_19_27","JHN","19","27","27","Tonde yik nêêl vu maanggêêm-anjuuto nambe, “Gangge tam-anja.” Tombe hôôk busin-anju maanggêêm-anjôôto hako Yesu tangganaan ak-ambe la nando having yi vu baan. ");
INSERT INTO mmo_vpl VALUES ("JN19_28","073_19_28","JHN","19","28","28","+ o 19:28 Saam 22:15*Tombe mem Yesu lak ni nambe yite kul pin-ato lung la om nêêl nambe, “Sa longg bambôôv in bel.” Nêêl nambêênju in nambe vakasin sen neep hôôk Anutu-te kaapiyaa-to nôôn jak. ");
INSERT INTO mmo_vpl VALUES ("JN19_29","073_19_29","JHN","19","29","29","+ o 19:29 Saam 69:21*Tombe bel anikalin nando hôôk kaambum ti, om lako malumak-ambe sil laanggôôl lukala bel anikalin-ato, tonde lavingin hôôk haah daka be lavu la valup lukala Yesu avi. ");
INSERT INTO mmo_vpl VALUES ("JN19_30","073_19_30","JHN","19","30","30","Tombe Yesu lasuvin-ambe hangôôn, le mem nêêl nambe, “Sa samu sate kul lung la.” Tonde mem laanggôôl ka luus atonde seelin nôôn la de yimb. ");
INSERT INTO mmo_vpl VALUES ("JN19_31","073_19_31","JHN","19","31","31","+ o 19:31 Diu 21:22-23*Tonde hôôk busin-anju hil Yuda davu samu sil in nambe davu lanji silate busin sawaasin bop busin haluusin-ato. Busin-anjo bopaata lôôt, de nind baya nambe omaahonôôn naavind-ame baale jak haah pako hôôk busin sawaasin e, om lala kataangg Pilata nambe biing hil ngaamong vaha-so lana kalêêh yaal vahand in lanjimb pavis, de lanôôh yaal naavind vêêl. ");
INSERT INTO mmo_vpl VALUES ("JN19_32","073_19_32","JHN","19","32","32","Tombe mem hil Lom ngaamong vaha-so lala kaatuuh omaaho yuuh sen sil layiis yuuh having Yesuu-to ango vaha kalêêh, tombe yik lala kaatuuh ango vaha having, ");
INSERT INTO mmo_vpl VALUES ("JN19_33","073_19_33","JHN","19","33","33","tombe sim lala vu Yesu le layi de yimb lung la, om sil-ame kaatuuh vaha le. ");
INSERT INTO mmo_vpl VALUES ("JN19_34","073_19_34","JHN","19","34","34","Lemu hil ngaamong vaha-so ti tataav Yesu lak yiiy lukala kamben, tombe pavis atombe nihees osin bel kaasêêh laam. ");
INSERT INTO mmo_vpl VALUES ("JN19_35","073_19_35","JHN","19","35","35","+ o 19:35 Jon 21:24*Tombe omaaho sen yi vaa-jo ond nêêl langaah, tombe yite vakasin-anjo keen lôôt, de yoo lak ni nambe nêêl vakasin keen in nambe ham ambiing gaving. ");
INSERT INTO mmo_vpl VALUES ("JN19_36","073_19_36","JHN","19","36","36","+ o 19:36 Eks 12:46; Nam 9:12; Saam 34:20*Lawiing vaa-ju om vakasin sen neep hôôk Anutu-te kaapiyaa-to nôôn ak nambe, “Sil-ame le kaatuuh yite kook ti kalêêh e.” ");
INSERT INTO mmo_vpl VALUES ("JN19_37","073_19_37","JHN","19","37","37","+ o 19:37 Sek 12:10; Taato 1:7*Tonde vakasin ango neep nambe, “Hil e mend na vu omaaho sen sil tataav yii-to.” ");
INSERT INTO mmo_vpl VALUES ("JN19_38","073_19_38","JHN","19","38","38","+ o 19:38 Jon 7:13; 12:42*Lung laa tonde Yesu-te omaaho ti Yusep vu Alimatia, ond yoo wii-having Yesu kaatokin in nayêênin hil Yuda. Ond Yusep-anju la kataangg Pilata nambe nôôh Yesu naavi vêêl, tombe Pilata liinggis om Yusep la lôôh vêêl. ");
INSERT INTO mmo_vpl VALUES ("JN19_39","073_19_39","JHN","19","39","39","+ o 19:39 Jon 3:1-2*Tombe Nikotemus sen bôôy la vu Yesu hôôk busin-ato la having Yusep, ond hako haah anikanggi galovasa yuuh-ambe salomangin yuuh ahondoos lavuh ti, tombe nimeen lôôt lohvu 35 kilo. ");
INSERT INTO mmo_vpl VALUES ("JN19_40","073_19_40","JHN","19","40","40","Tombe yuuh lala lako Yesu naavi be yuuh lavil osin va galovasaa-jôôto hôôk tôômb valôôy lohvu hil Yuda-te gambum sen davu samu omaahonôôn-ambe dahaav-ato. ");
INSERT INTO mmo_vpl VALUES ("JN19_41","073_19_41","JHN","19","41","41","De taaku sen layiis Yesu lak haah pakôô-to ond taaku sen laalôôh haah ayuuh amêê-to ti neep, tombe taakuu-ju lavandangga sen daahen lasap moos in nambe gambe omaahonôôn dukanaa-to ti neep, ond me-lambe omaahonôôn ti neep hôôk bôôy e. ");
INSERT INTO mmo_vpl VALUES ("JN19_42","073_19_42","JHN","19","42","42","Tombe lavandanggaa-ju neep ngaaho, om yuuh lambe Yesu naavi lukala pavis, in hil Yuda davu samu sil in lanji silate busin sawaasin bop. ");
INSERT INTO mmo_vpl VALUES ("JN20_1","073_20_1","JHN","20","1","1","Busin sawaasin lung la de Sonda samiinaanôôn yoo naahen mekanu, tonde Malia Magadala la valup bandumb, le yi de tatuuh tatolin vêêl in bandumb avi. ");
INSERT INTO mmo_vpl VALUES ("JN20_2","073_20_2","JHN","20","2","2","+ o 20:2 Jon 13:23*Tombe hatup-ambe laah nêêl vu Simon Pita yuuh maanggêêm ango sen Yesu ahe having yii-to nambe, “Lako Omaaho Bop vêêl vu bandumb, tombe hey doosin nambe lala lambe neep tana.” ");
INSERT INTO mmo_vpl VALUES ("JN20_3","073_20_3","JHN","20","3","3","Tombe Pita yuuh maanggêêm angôô-juuto lala in lana bandumb, ");
INSERT INTO mmo_vpl VALUES ("JN20_4","073_20_4","JHN","20","4","4","tombe yuuh ahondoos latup-ambe lala hôôk ti, le maanggêêm angôô-juuto kaluuh Pita de tok la valup bandumb munggin. ");
INSERT INTO mmo_vpl VALUES ("JN20_5","073_20_5","JHN","20","5","5","Tombe navu kakôôhin lavandangga lopayo le yi tôômb valôôy sen lavil Yesu naavi hôôk-ato yoo nando, lemu me-lukala lavandangga lopayo le. ");
INSERT INTO mmo_vpl VALUES ("JN20_6","073_20_6","JHN","20","6","6","Tonde Simon Pita motaamu be valup atombe laholaho be lukala lavandangga lopayo be yi le tôômb valôôy amu nando, ");
INSERT INTO mmo_vpl VALUES ("JN20_7","073_20_7","JHN","20","7","7","+ o 20:7 Jon 11:44*de tôômb ango sen sil layum Yesu lukook-ato ond me-nando having tôômb vaalu le, nganjo paasu be nando lundoos. ");
INSERT INTO mmo_vpl VALUES ("JN20_8","073_20_8","JHN","20","8","8","Tombe mem maanggêêm ango sen la valup bandumb avi munggin-ato ond lukala lavandangga lopayo having, le yi nambêênju tombe wii-having nambe Yesu kandi lak. ");
INSERT INTO mmo_vpl VALUES ("JN20_9","073_20_9","JHN","20","9","9","+ o 20:9 Sin 2:24-32; 1Ko 15:4*Le vakasin sen neep hôôk Anutu-te kaapiya nambe le kandi jak vu hil yimbin-ate, ond yuuh-ame lalak vakasin-anju danggakook ani lung la le, naahen. ");
INSERT INTO mmo_vpl VALUES ("JN20_10","073_20_10","JHN","20","10","10","Lung atonde maanggêêm ayuuh lalaah baand. ");
INSERT INTO mmo_vpl VALUES ("JN20_11","073_20_11","JHN","20","11","11","Malia yoo monasu naale voon ngaaho vu bandumb avi, tombe kakôôhin lavandangga lopayo, le yi de ");
INSERT INTO mmo_vpl VALUES ("JN20_12","073_20_12","JHN","20","12","12","angela yuuh osin tôômb anivalôôy malis dando lak Yesu naavi ahembaan, ango nando lukook de ango nando vaha. ");
INSERT INTO mmo_vpl VALUES ("JN20_13","073_20_13","JHN","20","13","13","Tombe yuuh lanêêl vu Malia nambe, “Onasu in?” Tombe nêêl laah vu yuuh nambe, “Lako sate Omaaho Bop vêêl-ambe lambe la ti, de sa doosin.” ");
INSERT INTO mmo_vpl VALUES ("JN20_14","073_20_14","JHN","20","14","14","+ o 20:14 Luk 24:16; Jon 21:4*Nêêl nambêênju tonde hilin e yi de Yesu naale, lemu Malia me-lak ni nambe Yesuu-ju le. ");
INSERT INTO mmo_vpl VALUES ("JN20_15","073_20_15","JHN","20","15","15","Tombe Yesu nêêl vu nambe, “Onasu in vaati? Onavu salo lati?” Tombe Malia ka vu nambe omaaho sen nanggin taakuu-jôôto, om nêêl vu nambe, “Himbop, naambe ohako la ond onaanêêl taaku sen ohambe neep hôôk-ato vu sa be sana gako.” ");
INSERT INTO mmo_vpl VALUES ("JN20_16","073_20_16","JHN","20","16","16","Tombe Yesu nêêl vu nambe, “Malia.” Tombe Malia hilin-ambe nêêl vu yi hôôk Yuda lavand Hiblu nambe, “Labonai.” Haalêê-jo nambe Kaputung. ");
INSERT INTO mmo_vpl VALUES ("JN20_17","073_20_17","JHN","20","17","17","+ o 20:17 Lom 8:29; Hiblu 2:11-12*Le Yesu nêêl vu nambe, “Game naapuvu sa le, in same alak-ambe sala vu sate Aamangg e, naahen. Lemu ganaah-ambe onaanêêl vu sa halingg-aso naambe sa jak-ambe sa naah vu Aamangg sen sate Mangg-ande hamate Mom, yik sate Anutu de hamate Anutu.” ");
INSERT INTO mmo_vpl VALUES ("JN20_18","073_20_18","JHN","20","18","18","Tombe Malia Magadala laah-ambe nêêl vu maanggêêm-aso nambe, “Saahe Omaaho Bop gêên.” Tonde nêêl vakasin sen Yesu nêêl vuu-to langaah vu sil. ");
INSERT INTO mmo_vpl VALUES ("JN20_19","073_20_19","JHN","20","19","19","+ o 20:19 Jon 19:38*Tonde Sonda busin atombe Yesu-te maanggêêm-aso layêênin hil Yuda om laayiiy vinavi niwêêk-ande yoo dando hôôk bayêên alo. Tombe Yesu la hato naale hôôk sil lavuun, de nêêl vu sil nambe, “Ham alompayo nanjip melaas.” ");
INSERT INTO mmo_vpl VALUES ("JN20_20","073_20_20","JHN","20","20","20","+ o 20:20 Jon 19:34; 16:22; 1Jon 1:1*Nêêl vakasin-anju tonde taato nama osin kamben vu sil, tombe kand vasa lak nambe layi mend ak Omaaho Bop. ");
INSERT INTO mmo_vpl VALUES ("JN20_21","073_20_21","JHN","20","21","21","+ o 20:21 Jon 17:18*Tonde Yesu nêêl vu sil yesin laah nambe, “Ham alompayo nanjip melaas, de saambiing-ambe ham ana naambe sen Mangg wiing sa be sa laam-ato.” ");
INSERT INTO mmo_vpl VALUES ("JN20_22","073_20_22","JHN","20","22","22","Nêêl vakasin-anju tonde have aviloos lak sil, de nêêl nambe, “Ham gako Vavi Vaambuung naas. ");
INSERT INTO mmo_vpl VALUES ("JN20_23","073_20_23","JHN","20","23","23","+ o 20:23 Mat 18:18*De naambe ham kawiiy hil-ate va nipaya na ond le nama na, le naambe ham-ame kawiiy hil-ate va nipaya na le, ond silate nipaya yoo le nanjip vu sil lôôt.” ");
INSERT INTO mmo_vpl VALUES ("JN20_24","073_20_24","JHN","20","24","24","+ o 20:24 Jon 11:16; 14:5; 21:2*Yesu taato yi vu yite maanggêêm-aso, lemu sil nomaayuuh-ambe laam yuuh-ato ond ti Tomas sen danêêl yi nambe Papinj-ato me-nando having sil hôôk busin tii-ju le, ");
INSERT INTO mmo_vpl VALUES ("JN20_25","073_20_25","JHN","20","25","25","om maanggêêm-aso vaalu lanêêl vu Tomas nambe, “Hey aahe Omaaho Bop.” Le Tomas nêêl laah vu sil nambe, “Same aangge mengg ak balem ahembaan sen neep ak namaa-to, be saanjop sa namangg kapis dukana balem vuun-anjuuto le, tonde same aanjop namangg dukana yiiy vuun sen neep ak kamben-ato le, ond same le aambiing gaving e, malis.” ");
INSERT INTO mmo_vpl VALUES ("JN20_26","073_20_26","JHN","20","26","26","+ o 20:26-27 Jon 20:19-20*Tombe Sonda ango taamusin atombe Yesu-te maanggêêm-aso dando hôôk bayêên alo hôôk Sonda yesin laah, tombe Tomas nando having sil. Sil laayiiy vinavi lung la de dando, tonde Yesu la hato naale hôôk sil lavuun de nêêl nambe, “Ham alompayo nanjip melaas.” ");
INSERT INTO mmo_vpl VALUES ("JN20_27","073_20_27","JHN","20","27","27","Tonde mem nêêl vu Tomas nambe, “Onamam kapis naam nganjo, de gangge sa namangg, tonde ganjop namam dukana yiiy vuun sen neep hôôk sa kambengg-anjo, tombe game galumkook aniwêêk e, malis, yik gambiing gaving.” ");
INSERT INTO mmo_vpl VALUES ("JN20_28","073_20_28","JHN","20","28","28","Tombe Tomas nêêl laah vu nambe, “Sate Omaaho Bop osin sate Anutu hong.” ");
INSERT INTO mmo_vpl VALUES ("JN20_29","073_20_29","JHN","20","29","29","+ o 20:29 1Pi 1:8*Tombe Yesu nêêl vu nambe, “Gahe sa ondeey gawii-having a? Hil sen me-layi mend ak sa le, lemu lambiing gaving-ato, ond le kand vasa.” ");
INSERT INTO mmo_vpl VALUES ("JN20_30","073_20_30","JHN","20","30","30","+ o 20:30 Jon 21:25*Yesu wiing taahu taahu osin niwêêkvaalu ngeeyaata be yite maanggêêm-aso layi, lemu same kaavu lukaneep kaapiyaa-jo le. ");
INSERT INTO mmo_vpl VALUES ("JN20_31","073_20_31","JHN","20","31","31","+ o 20:31 Jon 3:15; Lom 1:17; 1Jon 5:13*Yik sa kaavu vaalu neep-anjo in nambe ham ambiing gaving naambe Yesu yi omaaho sen Anutu yoo holin yi vulôôt-ato, Anutu Noow yi. Om ham ambiing gaving, ond ham e mando metumin jak haale. ");
INSERT INTO mmo_vpl VALUES ("JN21_1","073_21_1","JHN","21","1","1","+ o 21:1 Jon 6:1*Lung laa tonde Yesu taato yi yesin laah vu yite maanggêêm vaalu vu betum Taibilias nanyendangga, ond yite vakasin-anjo. ");
INSERT INTO mmo_vpl VALUES ("JN21_2","073_21_2","JHN","21","2","2","+ o 21:2 Jon 1:45-51; 20:24*Simon Pita yuuh Tomas sen danêêl yi nambe Papinj-ato, de Naatanael vu Kena Galili, de Sebedi noow ayuuh, tonde Yesu-te maanggêêm yuuh having-ambe sil ahondoosin dando. ");
INSERT INTO mmo_vpl VALUES ("JN21_3","073_21_3","JHN","21","3","3","Tombe Simon Pita nêêl vu sil nambe, “Sana paahuung.” Tombe sil lanêêl vu nambe, “Hey anaas in yana.” Tombe sil lalakala kaanu ti be lala lambe govak busin-aandiin, le ma de me-lako paahuung ti le, malis lôôt. ");
INSERT INTO mmo_vpl VALUES ("JN21_4","073_21_4","JHN","21","4","4","+ o 21:4 Jon 20:14*De langaah naahen nalak atombe Yesu naale lonak, lemu yite maanggêêm-aso doosin yi. ");
INSERT INTO mmo_vpl VALUES ("JN21_5","073_21_5","JHN","21","5","5","+ o 21:5 Luk 24:41*Tombe nêêl vu sil nambe, “Noongg-aso-e, ham hako paahuung heey a?” Le lanêêl laah vu nambe, “Malis-o.” ");
INSERT INTO mmo_vpl VALUES ("JN21_6","073_21_6","JHN","21","6","6","+ o 21:6 Luk 5:4-7*Tombe nêêl vu sil nambe, “Om ham gaate govak dukanaah osin kaanu vaalu vasaa-to ond mem ham e naatovu.” Om laate govak lukalaah tombe paahuung ngeeyaata lôôt lukala, om sil-ame lalohvu nambe daandiiy govak jakanaam baandoni le. ");
INSERT INTO mmo_vpl VALUES ("JN21_7","073_21_7","JHN","21","7","7","+ o 21:7 Jon 13:23; Mat 14:29*Tombe maanggêêm sen Yesu ahe having-ato ond nêêl vu Pita nambe, “Yik Omaaho Bop-anju.” Tombe Simon Pita kaah lolop-ande monawiing kul le hango nambe Omaaho Bop, tombe lop yite lolop laah tonde pasong lukala bel-ambe la vu Yesu. ");
INSERT INTO mmo_vpl VALUES ("JN21_8","073_21_8","JHN","21","8","8","Tonde maanggêêm-aso vaalu yoo mondako kaanu be mondaandiiy govak osin paahuung-ambe lalaam, ond lalaam diin daka lohvu 90 mita le mem lala lalup ngaaho vu nanyendangga. ");
INSERT INTO mmo_vpl VALUES ("JN21_9","073_21_9","JHN","21","9","9","Tombe sil lalakala lonak lung la, le mem layi de kin neep natum, tonde paahuung neep ak kin osin vanôôn nando having. ");
INSERT INTO mmo_vpl VALUES ("JN21_10","073_21_10","JHN","21","10","10","Tombe Yesu nêêl vu sil nambe, “Paahuung sen ham hako gesaangêê-jaato ond ham gako heey naam.” ");
INSERT INTO mmo_vpl VALUES ("JN21_11","073_21_11","JHN","21","11","11","+ o 21:11 Luk 5:6*Tombe Simon Pita lakalaah kaanu be laandiiy govak osin paahuung lakalaam lonak, tombe paahuung bo-bop ngeeyaata lohvu 153 pup hôôk govak, le paahuung ngeeyaataa-ju me-vapuuh govak e. ");
INSERT INTO mmo_vpl VALUES ("JN21_12","073_21_12","JHN","21","12","12","Tonde Yesu nêêl vu sil nambe, “Ham anaam angga vanôôn.” Tombe maanggêêm-aso layêênin sil vu om ti me-lingin vu yi le, in lalak ni nambe Omaaho Bop. ");
INSERT INTO mmo_vpl VALUES ("JN21_13","073_21_13","JHN","21","13","13","+ o 21:13 Jon 6:11*Tombe la hako vanôôn-ambe vu vu sil, tonde yik wiing paahuung va timu. ");
INSERT INTO mmo_vpl VALUES ("JN21_14","073_21_14","JHN","21","14","14","+ o 21:14 Jon 20:19,26*Om sen Yesu kandi lak vu hil yimbin-atêêto ond taato yi vu maanggêêm-aso tu balon yaal-anjo. ");
INSERT INTO mmo_vpl VALUES ("JN21_15","073_21_15","JHN","21","15","15","+ o 21:15 Jon 1:42; Mat 26:33*Laya vanôôn lung la le mem Yesu lingin Simon Pita nambe, “Jon noow Simon, mak gahem having sa savok hil-anja?” Le Pita liinggis nambe, “Êê-e, Omaaho Bop, galak ni nambe sahengg having hong-ato.” Tombe Yesu nêêl nambe, “Gambaat sate bik sipsip noow-aso.” ");
INSERT INTO mmo_vpl VALUES ("JN21_16","073_21_16","JHN","21","16","16","+ o 21:16 Sin 20:28; 1Pi 5:2*Tonde Yesu lingin tu balon yuuh nambe, “Jon noow Simon, mak gahem having sa?” Le Pita nêêl nambe, “Êê-e, Omaaho Bop, galak ni nambe sahengg having hong-ato.” Tombe Yesu nêêl nambe, “Ongganggin sate sipsip-aso.” ");
INSERT INTO mmo_vpl VALUES ("JN21_17","073_21_17","JHN","21","17","17","+ o 21:17 Jon 13:38; Jon 16:30*Tonde Yesu lingin tu balon yaal nambe, “Jon noow Simon, mak gahem having sa?” Tombe Pita ka pasiv lôôt in yi, in Yesu lingin yi tu balon yaal nambe, “Mak gahem having sa?” Om nêêl vu Yesu nambe, “Omaaho Bop, goo galak va pin ani, om galak ni nambe sahengg having hong.” Tombe Yesu nêêl vu nambe, “Gambaat sate sipsip-aso. ");
INSERT INTO mmo_vpl VALUES ("JN21_18","073_21_18","JHN","21","18","18","+ o 21:18-19 2Pi 1:14; Mat 16:24-25; Mak 1:17; Jon 13:36*De sa naanêêl keen lôôt vu hong naambe bôôy sen onaahen maanggêêm-ato, ond goo navêêh gate let-ambe onala taaku sen gawiingin nambe ganaa-to, lemu taamusin sen otata jak-ato ond gale talo namam-ande omaaho ango le gavêêh gate let ak hong-ande gako hong-ambe gana taaku sen game gawiingin nambe ganaa-to le.” ");
INSERT INTO mmo_vpl VALUES ("JN21_19","073_21_19","JHN","21","19","19","Yesu nêêl vakasin-anju lak Pita ond nêêl taato nambe taamusin Pita le jimb naambêênju be gako Anutu haale jak. Nêêl vakasin-anju lung la tonde nêêl vu Pita nambe, “Otaamuyin sa.” ");
INSERT INTO mmo_vpl VALUES ("JN21_20","073_21_20","JHN","21","20","20","+ o 21:20 Jon 13:23-25*Tombe Pita hilin laah e yi maanggêêm sen Yesu ahe having-ato navu taamuyin yuuh. Maanggêêm-anju sen bôôy mondaya vanôôn atonde valu-la ngaaho vu Yesu be lingin nambe, “Omaaho Bop, lati le bu hong dukana hil namand?” ");
INSERT INTO mmo_vpl VALUES ("JN21_21","073_21_21","JHN","21","21","21","Ond Pita yi maanggêêm-anju tombe lingin Yesu nambe, “Omaaho Bop, de omaahôô-ju le naambe vaati?” ");
INSERT INTO mmo_vpl VALUES ("JN21_22","073_21_22","JHN","21","22","22","+ o 21:22 Mat 16:28*Le Yesu nêêl vu nambe, “Sa kangg bu naambe yoo mando lôôt-ambe saanom gato le, ond soo sate va, nganjo hong-anja otaamuyin sa.” ");
INSERT INTO mmo_vpl VALUES ("JN21_23","073_21_23","JHN","21","23","23","Tombe vakasin la lohvu Omaaho Bop-ate hil vaalu nambe maanggêêm-anju me-le jimb e, lemu Yesu me-nêêl vu nambe me-le jimb e, malis, nganjo nêêl nambe, “Sa kangg bu naambe yoo mando lôôt-ambe saanom gato le, ond soo sate va.” ");
INSERT INTO mmo_vpl VALUES ("JN21_24","073_21_24","JHN","21","24","24","+ o 21:24 Jon 19:35*Yik maanggêêm-anjo sen nanêêl vakasin-anjo langaah-ande kaavu neep-ato, tombe hey alak ni nambe vakasin sen kaavuu-jo yoo keen lôôt. ");
INSERT INTO mmo_vpl VALUES ("JN21_25","073_21_25","JHN","21","25","25","+ o 21:25 Jon 20:30*Yesu wiing va vaalu ngeeyaata lôôt, tombe sa kangg vu nambe yiiy kaavu ti ti hôôk kaapiya osin doos ond le naatu kaapiya ngeeyaata lôôt-ambe na nohvu taaku pin-ambe savok. ");
INSERT INTO mmo_vpl VALUES ("AC1_1","074_1_1","ACT","1","1","1","+ o 1:1 Luk 1:1-4*O Tiopilas, vakasin sen sa kaavu neep munggin-ato Luk 1:1-4* ond gale gangge naambe Luk kaavu banye nivasaa-ju la vu Tiopilas, om yik Luk-anju sen kaavu sinaale-sote kaapiyaa-jo having. ond sa kaavu lak va pin sen Yesu wiing osin tatekin tanasin vu hil-ato, ");
INSERT INTO mmo_vpl VALUES ("AC1_2","074_1_2","ACT","1","2","2","+ o 1:2 Mak 16:19; Luk 24:49-51*vu munggin-ambe hato busin sen Anutu hako yi laah baandonii-to. Ond naahen nando voon-ande vu kul vu yite sinaale-so sen bôôy holin sil-ato, ond vu kul lak Vavi Vaambuung-ate niwêêk. ");
INSERT INTO mmo_vpl VALUES ("AC1_3","074_1_3","ACT","1","3","3","+ o 1:3 Luk 24:36-49; Sin 10:41*Bôôy hako nivaane be yimb, de kandi lak atombe nando voon lohvu busin doo-yuuh, be navu taato yi vu yite sinaale-so in nambe lanjak ni naambe nando metumin, tombe nêêl vakasin sen Anutu nanggin yite hil-ato vu sil. ");
INSERT INTO mmo_vpl VALUES ("AC1_4","074_1_4","ACT","1","4","4","+ o 1:4 Luk 24:49; Jon 14:16-17; Sin 2:33*De yoo naahen nando having sil-ato ond nêêlin sil nambe, “Ham-ame gavuuh Yelusalem e, ham oo mando ganggin va sen saanêêl vu ham bôôy nambe Aamangg nêêl nambe le bu naam-ato. ");
INSERT INTO mmo_vpl VALUES ("AC1_5","074_1_5","ACT","1","5","5","+ o 1:5 Mat 3:11*De Jon lipis hil-ato ond lipis sil lak bel, de ngaaho lak in Anutu navu biing Vavi Vaambuung naas mando gaving ham.” ");
INSERT INTO mmo_vpl VALUES ("AC1_6","074_1_6","ACT","1","6","6","+ o 1:6 Luk 24:21*Tombe sinaale-so lasupin dando lavuh ti le mem lalingin yi nambe, “Omaaho Bop, mak peey e onavu gambiing-ambe yiiy Islel oo ganggin yiiy naah a?” ");
INSERT INTO mmo_vpl VALUES ("AC1_7","074_1_7","ACT","1","7","7","+ o 1:7 Mak 13:32*Le nêêl vu sil nambe, “Ham-ame hamate va in nambe ham anjak ta osin busin sen Mangg oo hatung-ato ni le, yik Mangg timu yoo nanggin vaa-jo. ");
INSERT INTO mmo_vpl VALUES ("AC1_8","074_1_8","ACT","1","8","8","+ o 1:8 Mat 28:19; Luk 24:48; Sin 2:32; 3:15; 5:32; Ep 3:16*Lemu Vavi Vaambuung e jakana ham-ambe bu niwêêk vu ham, tombe mem ham e naanêêl sa haalengg vu Yelusalem de vu Yudia pin osin vu Samaalia be na nohvu taaku nanyendangga pin.” ");
INSERT INTO mmo_vpl VALUES ("AC1_9","074_1_9","ACT","1","9","9","+ o 1:9 Jon 6:62*Yesu nêêl vakasin-anjo lung la, tonde layi de valu-nala baandoni, tombe bayiimb ti hako yi be la, tonde me-layi yi yesin laah e. ");
INSERT INTO mmo_vpl VALUES ("AC1_10","074_1_10","ACT","1","10","10","+ o 1:10 Luk 24:4*Naahen nalak-ande sil oo mondalaah mend ak in, tombe omaaho yuuh lato daale having sil pavis, ond yuuh lalop lolop anivalôôy, ");
INSERT INTO mmo_vpl VALUES ("AC1_11","074_1_11","ACT","1","11","11","+ o 1:11 Mat 26:64; Luk 21:27; Taato 1:7*tonde yuuh lanêêl nambe, “Ham Galili, nambe vaati sen ham naale mem nangget baandoni? Yesuu-ju sen Anutu vu vêêl in ham-ande hako be la baandoni, ond yik le nom naambe sen ham ahe la baandoni gêên-anju.” ");
INSERT INTO mmo_vpl VALUES ("AC1_12","074_1_12","ACT","1","12","12","+ o 1:12 Luk 24:50-53*Sil vu kandu Oliv-ambe lalaah Yelusalem. Kanduu-ju ngaaho daka vu Yelusalem lohvu 1 kilomita mu. ");
INSERT INTO mmo_vpl VALUES ("AC1_13","074_1_13","ACT","1","13","13","+ o 1:13 Mat 10:2-4*Lala lato Yelusalem-ambe lalakala bayêên alopayo baandoni ti sen sil oo dando hôôk-ato. Hil-anju ond Pita yuuh Jon, de Jems ayuuh Endru, de Pilip ayuuh Tomas, de Batolomai yuuh Matai, de Jems sen Alpias noow-ato yuuh Simon sen naanjiihin hil Yuda in nambe gatiiy hil Lom lanaa-to, de Yudas sen Jems noow-ato. ");
INSERT INTO mmo_vpl VALUES ("AC1_14","074_1_14","ACT","1","14","14","+ o 1:14 Jon 7:5*Hil-anju pin laving vêêh heey, de Malia sen Yesu tangganaan-ato osin Yesu halindin, ond sil alondpayo lavuh ti de mondalohak dando. ");
INSERT INTO mmo_vpl VALUES ("AC1_15","074_1_15","ACT","1","15","15","De busin ti tombe hil 120 dando lavuh ti, tombe Pita kandi naale hôôk sil amend-ambe nêêl nambe, ");
INSERT INTO mmo_vpl VALUES ("AC1_16","074_1_16","ACT","1","16","16","+ o 1:16 Saam 41:9*“Halingg-aso-e, bôôy ond Vavi Vaambuung wiing-ambe Devit nêêl vakasin munggin lak Yudas sen gêên taato mopaatôôv vu hil-ambe lalôôh Yesuu-to, ond vakasin-anjo nôôn ak lung la. ");
INSERT INTO mmo_vpl VALUES ("AC1_17","074_1_17","ACT","1","17","17","Yudas-anju ond hey ti sen hey ahondoos naawiing kul timuu-to, ");
INSERT INTO mmo_vpl VALUES ("AC1_18","074_1_18","ACT","1","18","18","+ o 1:18 Mat 27:3-10*tombe mone sen hako lak yite nipayaa-to lala laanggo ngaanggis ti lak, ond Yudas-anju lupake be ninaavi vapuuh-ande ahe kaasêêh. ");
INSERT INTO mmo_vpl VALUES ("AC1_19","074_1_19","ACT","1","19","19","Tombe hil pin vu Yelusalem langoyin-ambe lanêêl taaku tii-ju hôôk sil lavand nambe Akeldama, dangga nambe ngaanggis ngaamong nihees-ate. ");
INSERT INTO mmo_vpl VALUES ("AC1_20","074_1_20","ACT","1","20","20","+ o 1:20 Saam 69:25; 109:8*Vakasin-anjo neep hôôk kaapiya Saam nambe, ‘Yite bayêên e mando malis, de omaaho ti me-le mando jak e.’ De Saam ango nêêl nambe, ‘Omaaho ango le biing yite kul.’ ");
INSERT INTO mmo_vpl VALUES ("AC1_21","074_1_21","ACT","1","21","21","Om hil sen hey ahondoos having Omaaho Bop Yesu hey ala de aalom, de sil dando having hey lôôt, ");
INSERT INTO mmo_vpl VALUES ("AC1_22","074_1_22","ACT","1","22","22","+ o 1:22 Jon 15:27*vu busin sen Jon lipis hil-ambe tok laam busin sen Anutu hako Yesu laah in yiiy-ato, ond hil-anja ti kandi jak gaving hey in naanêêl Yesu-te vakasin sen kandi lak-ato langaah gaving e.” ");
INSERT INTO mmo_vpl VALUES ("AC1_23","074_1_23","ACT","1","23","23","Pita nêêl nambêênju tombe sil lanêêl omaaho yuuh haalend, ango Yusep sen danêêl nambe Basabas, de haale ango nambe Jastas, ond yuuh Matias. ");
INSERT INTO mmo_vpl VALUES ("AC1_24","074_1_24","ACT","1","24","24","+ o 1:24 Jon 2:25*Tonde lalohak nambe, “Omaaho Bop, goo galak hil pin alondpayo ni, om otaato naambe gaholin omaaho yuuh-anjo ango tana ");
INSERT INTO mmo_vpl VALUES ("AC1_25","074_1_25","ACT","1","25","25","in nambe gako kul sinaale sen Yudas havuuh neep-ande la valok-atêêto.” ");
INSERT INTO mmo_vpl VALUES ("AC1_26","074_1_26","ACT","1","26","26","Lalohak lung la tonde sil kaavu yuuh haalend ak tatuuh-ande sil kalo, tombe Matias-ate tatuuh kalov hato sil amend, om lawiing Matias la having sinaale-so nomaayuuh-ambe laam tii-to. ");
INSERT INTO mmo_vpl VALUES ("AC2_1","074_2_1","ACT","2","1","1","+ o 2:1 Lev 23:15-21; Diu 16:9-11*Hôôk busin Pentikos tombe sil pin lavuh ti be dando, ");
INSERT INTO mmo_vpl VALUES ("AC2_2","074_2_2","ACT","2","2","2","de pavis atombe daandun ti laam vu baandoni nambe sen vavi jambaa-to be lohvu bayêên alo sen dando hôôk-ato. ");
INSERT INTO mmo_vpl VALUES ("AC2_3","074_2_3","ACT","2","3","3","+ o 2:3 Mat 3:11*Tonde layi vati nambe kin dalaan-ato laam-ambe nando lak sil ti ti pin, ");
INSERT INTO mmo_vpl VALUES ("AC2_4","074_2_4","ACT","2","4","4","+ o 2:4 Sin 4:31; 10:44-46; Sin 19:6; Mak 16:17*tonde Vavi Vaambuung lukala sil alondpayo lôôt, be lakaas bayêên bu ti ti lavand lohvu Vavi Vaambuung oo wiing-ambe sil lakaas-ato. ");
INSERT INTO mmo_vpl VALUES ("AC2_5","074_2_5","ACT","2","5","5","De hil Yuda vu taaku pin sen kand navu sapa Anutu be lala dando Yelusalem-ato, ");
INSERT INTO mmo_vpl VALUES ("AC2_6","074_2_6","ACT","2","6","6","ond lango daandun-anju tombe sil pin lasupin lalaam-ambe daale dango de sinaale-so dakaas sil sen daalêê-jôôto lavand ti ti, om lavindis lôôt. ");
INSERT INTO mmo_vpl VALUES ("AC2_7","074_2_7","ACT","2","7","7","+ o 2:7 Sin 1:11*Sil pin lavindis-ande kand yu-yuuh lôôt-ambe lanêêl nambe, “Ham gango. Hil pin sen dakaas-anjo sil vu Galili me malis? ");
INSERT INTO mmo_vpl VALUES ("AC2_8","074_2_8","ACT","2","8","8","Nambe vaati om yiiy nango de dakaas yiiy lavangg sen ataak-aso lako yiiy-ambe yiiy nakaas-ato? ");
INSERT INTO mmo_vpl VALUES ("AC2_9","074_2_9","ACT","2","9","9","+ o 2:9 2Ti 1:15*Yiiy vu taaku Patia, de Midia de Ilam, osin yiiy vu Mesopotemia de vu Yudia, de vu Kapadosia yuuh Pontas de Esia, ");
INSERT INTO mmo_vpl VALUES ("AC2_10","074_2_10","ACT","2","10","10","de vu Plisia, Pampilia, osin Ijip, de vu Libia vahaan sen ngaaho vu Sailinii-to, de yiiy vu Lom sen yalaam nandôô-jo. ");
INSERT INTO mmo_vpl VALUES ("AC2_11","074_2_11","ACT","2","11","11","Yiiy Yuda de hil vaalu sen lako Yuda-te gambum-ato, de yiiy vu Klit osin Alebia, yiiy pin hango de danêêl va bopaata sen Anutu wiing-ato langaah hôôk yiiy lavangg ti ti.” ");
INSERT INTO mmo_vpl VALUES ("AC2_12","074_2_12","ACT","2","12","12","Om sil pin lavindis lôôt-ambe kand yu-yuuh, tombe yoo lanêêl vu sil nambe, “Vaa-jo dangga nambe vaati?” ");
INSERT INTO mmo_vpl VALUES ("AC2_13","074_2_13","ACT","2","13","13","Lemu vaalu danêêl sil pale nambe, “Ma-o, lanum wain moos ngeeyaata lôôt.” ");
INSERT INTO mmo_vpl VALUES ("AC2_14","074_2_14","ACT","2","14","14","De Pita naale having sil nomaayuuh-ambe laam tii-to tombe nêêl bopaata vu hil pin nambe, “Ham Yelusalem de ham Yuda pin, sa tatekin vaa-jo vu ham-ambe ham gango le. ");
INSERT INTO mmo_vpl VALUES ("AC2_15","074_2_15","ACT","2","15","15","Hamambe hil-anjo lanum wain ngeeyaata? Malis lôôt. Manyinjo naahen samiinaanôôn-anjo, ");
INSERT INTO mmo_vpl VALUES ("AC2_16","074_2_16","ACT","2","16","16","lemu Joel-ate vakasin bôôy-ato nôôn ak nambe, ");
INSERT INTO mmo_vpl VALUES ("AC2_17","074_2_17","ACT","2","17","17","+ o 2:17-21 Joel 2:28-32*‘Anutu nêêl nambe, “Vu busin taamusin e mem sale aambiing-ambe sate Vavi Vaambuung jakana hil pin, be noom-aso nomaavêêh-aso le daanêêl vakasin langaah, de hamate himbop-aso le lanji mavin, tonde hamate maanggêêm-aso le lanji taahu taahu. ");
INSERT INTO mmo_vpl VALUES ("AC2_18","074_2_18","ACT","2","18","18","Keen, hôôk busin-anju sale aambiing sate Vavi Vaambuung jakana sate hil moow osin vêêh in daanêêl vakasin langaah. ");
INSERT INTO mmo_vpl VALUES ("AC2_19","074_2_19","ACT","2","19","19","Tonde sale aambiing taahu taahu bopaata vu yendak osin saambiing taahu taahu niwêêk vu voon. Nihees de kin osin ahelu, ");
INSERT INTO mmo_vpl VALUES ("AC2_20","074_2_20","ACT","2","20","20","de taaku mekaalus e mekanu dôôk, tonde kwaav e nihees dôôk vêêl e mem Omaaho Bop-ate busin bopaataa-to naatok naam. ");
INSERT INTO mmo_vpl VALUES ("AC2_21","074_2_21","ACT","2","21","21","+ o 2:21 Lom 10:13*Tombe hil pin sen lavand nahôôk Omaaho Bop haalêê-to ond le dôôvu sil.’” ");
INSERT INTO mmo_vpl VALUES ("AC2_22","074_2_22","ACT","2","22","22","+ o 2:22 Jon 3:2*“Ham Islel, ham gango sate vakasin-anjo le, naambe Yesu Nasaalet ond ham alak ni nambe Anutu taato yi vu ham lak taahu taahu bopaata osin niwêêk vaha vaha, de kaandu yi be wiing vu ham ambaam-ato. ");
INSERT INTO mmo_vpl VALUES ("AC2_23","074_2_23","ACT","2","23","23","+ o 2:23 Sin 4:28; 1Pi 1:20*Vu bôôy ond Anutu yoo ka vu be samu vakasin lung la le mem vu Yesuu-jo lukala ham namam, tombe sim ham avu yi lukala hil sen me-lawii-having tanasin-ato namand-ambe layiis ak haah pako be yimb. ");
INSERT INTO mmo_vpl VALUES ("AC2_24","074_2_24","ACT","2","24","24","+ o 2:24 Sin 3:15*Le sim Anutu vu vêêl yi in nivaane yimbin-ate de wiing-ambe kandi lak laah, de yimbin-ame lohvu nambe naapuvu yi lôôt e, ");
INSERT INTO mmo_vpl VALUES ("AC2_25","074_2_25","ACT","2","25","25","+ o 2:25-28 Saam 16:8-11*in Devit nêêl vakasin lak yi nambe, ‘Saahe Omaaho Bop naale sa mengg osin sa namangg vasa lak busin pin in nambe vati me-le biing-ambe saandupake le. ");
INSERT INTO mmo_vpl VALUES ("AC2_26","074_2_26","ACT","2","26","26","Om nambêênja sa longgpayo nivasa de sa dalaangg naapêêlis vu Anutu, de sa ningg naavi mando mongganggin va nivasa, ");
INSERT INTO mmo_vpl VALUES ("AC2_27","074_2_27","ACT","2","27","27","+ o 2:27 Sin 13:35*in game le gavuuh sa kanungg na mando hil yimbin-ate taaku lôôt e, de game le gambiing-ambe gate Omaaho Vaambuung naavi panyek e. ");
INSERT INTO mmo_vpl VALUES ("AC2_28","074_2_28","ACT","2","28","28","Otaato mopaatôôv sen sa mando metumin-ate lung la vu sa, de gale mando gaving sa om sale naapêêlis lôôt.’ ");
INSERT INTO mmo_vpl VALUES ("AC2_29","074_2_29","ACT","2","29","29","+ o 2:29 1King 2:10; Sin 13:36*“Halingg-aso, sa naanêêl langaah vu ham naambe yate himbop Devit yimb bôôy-ambe lahaav, de yite bandumb neep hôôk yiiy lavuun-ambe gêên-anjo. ");
INSERT INTO mmo_vpl VALUES ("AC2_30","074_2_30","ACT","2","30","30","+ o 2:30 2Sml 7:12; Saam 89:3-4; 132:11*Devit-anjo yi omaaho sen nanêêl Anutu-te vakasin langaah-ato be yoo lak ni nambe Anutu nêêl vu keen baandoni nambe, ‘Sa navu aambiing-ambe gate hil vu taamusin-ato ti le gako haale lulemak dukanaah gahembaan.’ ");
INSERT INTO mmo_vpl VALUES ("AC2_31","074_2_31","ACT","2","31","31","+ o 2:31 Saam 16:10*Ond Devit oo lak ni munggin ondeey nêêl vakasin lak omaaho sen Anutu yoo holin yi vulôôt in nambe dôôvu yiiy-ato nambe le kandi jak naah, om nêêl nambe, ‘Anutu me-havuuh yi la nando hil yimbin-ate taaku lôôt osin ninaavi me-panyek e.’ ");
INSERT INTO mmo_vpl VALUES ("AC2_32","074_2_32","ACT","2","32","32","+ o 2:32 Sin 1:8*Ond Yesuu-ja, Anutu wiing-ambe kandi lak-ambe hey pin aahe yi lung la ondeey hey naanêêl langaah-anjo. ");
INSERT INTO mmo_vpl VALUES ("AC2_33","074_2_33","ACT","2","33","33","+ o 2:33 Mak 16:19; Sin 1:4; 7:55-56; 1Pi 3:22*Om gêên Anutu hako lakalaah baandoni be la nando nama vasa lung la, de wiing Vavi Vaambuung sen Mangganaan nêêl vu yii-to lom-ambe Vavi Vaambuung yoo wiing va sen ham nahe osin ham nangôô-to. ");
INSERT INTO mmo_vpl VALUES ("AC2_34","074_2_34","ACT","2","34","34","+ o 2:34-35 Saam 110:1*Devit-ame la baandoni le, lemu Devit nêêl nambe, ‘Omaaho Bop nêêl vu sate Omaaho Bop nambe, “Omando sa namangg vasa, ");
INSERT INTO mmo_vpl VALUES ("AC2_35","074_2_35","ACT","2","35","35","de sale aambiing-ambe hil sen dayi hong payaa-to le langgulis hong vaalu kambi.” ’ ");
INSERT INTO mmo_vpl VALUES ("AC2_36","074_2_36","ACT","2","36","36","+ o 2:36 Sin 5:30-31*“Om ham Islel pin ond yanjak ni vanuh naambe Yesuu-jo sen ham ayiis ak haah pakôô-to, ond Anutu wiing-ambe tu Omaaho Bop osin omaaho sen Anutu yoo holin yi vulôôt in nambe dôôvu yiiy-ato.” ");
INSERT INTO mmo_vpl VALUES ("AC2_37","074_2_37","ACT","2","37","37","+ o 2:37 Luk 3:10,12; Sin 16:30*Hil lango vakasin-anjo be la hanggwang sil alondpayo, tombe lanêêl vu Pita having sinaale-so nambe, “Halingg-aso, hey aambiing vaati peey?” ");
INSERT INTO mmo_vpl VALUES ("AC2_38","074_2_38","ACT","2","38","38","+ o 2:38 Luk 24:47; Sin 3:19*Le Pita nêêl vu sil nambe, “Ham anggilin ham alompayo de ham pin anjipis bel jak Yesu Kalisi haale in kawiiy hamate nipaya na, le mem Anutu le biing Vavi Vaambuung naas vu ham. ");
INSERT INTO mmo_vpl VALUES ("AC2_39","074_2_39","ACT","2","39","39","+ o 2:39 Ais 57:19*Yik Anutu yoo nêêl nambe bu vu ham o noom-aso osin omaahonôôn pin vu taaku diin. Keen, yate Omaaho Bop Anutu nêêl lung la nambe le bu vu hil pin sen teey sil-ato.” ");
INSERT INTO mmo_vpl VALUES ("AC2_40","074_2_40","ACT","2","40","40","+ o 2:40 Diu 32:5; Pil 2:15*De Pita nêêl tanasin ngeeyaata lôôt vu sil, osin vu kôôvu sil nambe, “Ham ganggin ham in hil anipayaa-ja.” ");
INSERT INTO mmo_vpl VALUES ("AC2_41","074_2_41","ACT","2","41","41","+ o 2:41 Sin 2:47; 4:4; 5:14*Tombe hil sen lawii-having Pita-te vakasin-ambe lalipis bel-ato ond sil ngeeyaata lôôt lohvu 3 taosen lalukalaam having Omaaho Bop-ate hil hôôk busin tii-ju. ");
INSERT INTO mmo_vpl VALUES ("AC2_42","074_2_42","ACT","2","42","42","+ o 2:42 Sin 20:7*Hil-anju yoo dangoyin sinaale-sote tanasin, de sil alondpayo lavuh ti be daya vanôôn hôôk ti osin dalohak navuh ti. ");
INSERT INTO mmo_vpl VALUES ("AC2_43","074_2_43","ACT","2","43","43","+ o 2:43 Sin 5:11-12; 6:8*Tombe yik hil pin layêênin lôôt in sinaale-so lawiing taahu taahu ngeeyaata lak Anutu-te niwêêk. ");
INSERT INTO mmo_vpl VALUES ("AC2_44","074_2_44","ACT","2","44","44","+ o 2:44-45 Sin 4:32-35*Tonde hil pin sen lawii-having Yesuu-to dando lavuh ti, de va sen silate vaa-to ond sil pin-ate va. ");
INSERT INTO mmo_vpl VALUES ("AC2_45","074_2_45","ACT","2","45","45","Tonde lavu silate ngaanggis ayuuh kupak-ambe hil laanggo de lako mone be lala latiiy vu hil sen dativak in va yuuh amêê-to. ");
INSERT INTO mmo_vpl VALUES ("AC2_46","074_2_46","ACT","2","46","46","+ o 2:46 Luk 24:53*De sil lavuh ti be dala Anutu-te dumb bop alo lak busin pin, tonde daya vanôôn hôôk sil ambaand ond daya osin ahend anivasa be dapêêlis, ");
INSERT INTO mmo_vpl VALUES ("AC2_47","074_2_47","ACT","2","47","47","+ o 2:47 Sin 2:41; 6:7; 11:21,24*de sil lavand nahôôk Anutu tombe hil pin dayi sil anivasa, de Omaaho Bop oo nahilin hil vaalu londpayo nalak busin pin-ambe dalukalaam having sil. ");
INSERT INTO mmo_vpl VALUES ("AC3_1","074_3_1","ACT","3","1","1","+ o 3:1 Sin 10:3,9,30*Busin ti Pita yuuh Jon lala Anutu-te dumb bop hôôk soosin lohvu taaku me yaal in nambe lanohak, nohvu sen hil pin oo dalohak-ato. ");
INSERT INTO mmo_vpl VALUES ("AC3_2","074_3_2","ACT","3","2","2","+ o 3:2 Jon 9:1; Sin 14:8*Tombe omaaho ti tangganaan hako yi vaha nipaya be nando, ond lohvu busin pin daaku be lala datung nando ngaaho vu dumb avi sen danêêl haale nambe Mengalii-to, in nambe kataangg va vu hil sen dalukala dumb alôô-to. ");
INSERT INTO mmo_vpl VALUES ("AC3_3","074_3_3","ACT","3","3","3","Ond omaahôô-ju yi de Pita yuuh Jon lalup in nambe landukana dumb alo, tombe kataangg yuuh in nambe yuuh lambu vati vu yi. ");
INSERT INTO mmo_vpl VALUES ("AC3_4","074_3_4","ACT","3","4","4","+ o 3:4 Sin 14:9*Le Pita yuuh Jon amend la vu yi, tombe Pita nêêl vu nambe, “Gangge haay e.” ");
INSERT INTO mmo_vpl VALUES ("AC3_5","074_3_5","ACT","3","5","5","Tombe omaahôô-ju ka vu nambe yuuh davu lambu vati vu yi om nayi yuuh, ");
INSERT INTO mmo_vpl VALUES ("AC3_6","074_3_6","ACT","3","6","6","+ o 3:6 Sin 3:16; 4:10; 16:18*le ma de Pita nêêl vu nambe, “Sak mone ma, lemu va sen nando vu saa-to ond sa navu aambu vu hog. Lak Yesu Kalisi Nasaalet haale sa naanêêl vu hong naambe okandi jak-ambe gana.” ");
INSERT INTO mmo_vpl VALUES ("AC3_7","074_3_7","ACT","3","7","7","Tombe Pita laandiiy hôôk nama vasa be kandi naale, tombe sim omaahôô-juuto vaha tambaat osin vaha dambi niwêêk ak pavis, ");
INSERT INTO mmo_vpl VALUES ("AC3_8","074_3_8","ACT","3","8","8","+ o 3:8 Sin 14:10; Jon 5:14*tonde mem pasong-ambe la naale be la, tombe lukala dumb alo having yuuh-ambe kalov baando baando osin hako Anutu haale lak-ambe la. ");
INSERT INTO mmo_vpl VALUES ("AC3_9","074_3_9","ACT","3","9","9","Hil pin layi nambe nako Anutu haale lak-ambe nala, ");
INSERT INTO mmo_vpl VALUES ("AC3_10","074_3_10","ACT","3","10","10","tombe lalak ni nambe omaaho sen nando mokataangg va hôôk dumb avi sen danêêl nambe Mengalii-to, ond yik yii-ju, om layi de nivasa hôôk atombe lavindis-ambe kanund la lôôt. ");
INSERT INTO mmo_vpl VALUES ("AC3_11","074_3_11","ACT","3","11","11","Omaahôô-ju puvu Pita yuuh Jon tatin, tombe hil pin latup-ambe lasupin lala vu yaal vu dumb alo ti sen danêêl haale nambe Solomon-atêêto, tombe sil lavindis in lôôt. ");
INSERT INTO mmo_vpl VALUES ("AC3_12","074_3_12","ACT","3","12","12","Pita yi hil-anju tombe nêêl vu sil nambe, “Ham Islel, ham avindis in? De ham amem laam vu haay lôôt in? Hamambe haay oote niwêêk osin nivasa wiing-ambe laa-jo? ");
INSERT INTO mmo_vpl VALUES ("AC3_13","074_3_13","ACT","3","13","13","+ o 3:13 Eks 3:6,15; Mat 22:32; Sin 2:23; 7:32; Luk 23:13-25*Anutu sen tu Abalaam ayuuh Isak-ande Yaakop osin yate himbop-aso bôôy pin silate Anutuu-to, ond hako yite kul vaha Yesu haale lak. Yesuu-ja sen ham avu lukala Pilata nama be wiingin nambe kavaayin vu ham, le ma de ham haluuh damim vu yi hôôk Pilata me, ");
INSERT INTO mmo_vpl VALUES ("AC3_14","074_3_14","ACT","3","14","14","+ o 3:14 Mak 15:6-15*lemu ham haluuh damim vu omaaho vaambuung osin nivalok, de ham kataangg Pilata nambe kavaayin omaaho sen nayiis hil-ato vu ham. ");
INSERT INTO mmo_vpl VALUES ("AC3_15","074_3_15","ACT","3","15","15","+ o 3:15 Sin 1:8; 2:32; 4:10; 5:30*De sim omaaho metumin danggakook ond ham ayiis-ambe yimb, lemu Anutu wiing-ambe kandi lak laah vu hil yimbin-ate, tombe haay aahe ondeey haay naanêêl tatekin-anjo. ");
INSERT INTO mmo_vpl VALUES ("AC3_16","074_3_16","ACT","3","16","16","De omaaho sen ham ahe osin ham alak nii-to, ond yik wii-having Yesu haale, ondeey haalêê-ju wiing-ambe vaha nivasa lak. Yik Yesu yoo kaandu yi be wii-having, ondeey wiing-ambe naale nala nivasa hôôk ham amem-anjo. ");
INSERT INTO mmo_vpl VALUES ("AC3_17","074_3_17","ACT","3","17","17","+ o 3:17 Luk 23:34; 1Ti 1:13*“Halingg-aso, sa lak ni nambe ham doosin ondeey ham ayiis Yesu be yimb, de hamate yêêv bop-aso doosin having nambêênja. ");
INSERT INTO mmo_vpl VALUES ("AC3_18","074_3_18","ACT","3","18","18","+ o 3:18 Luk 24:27,44,46*Lemu Anutu wiing-ambe hil sen danêêl yite vakasin langaah bôôy-ato ond sil pin lanêêl nambe yite omaaho sen yoo holin yi vulôôt in nambe dôôvu yiiy-ato ond le gako nivaane. Om gêên Anutu wiing-ambe silate vakasin-anju nôôn ak, lak va sen ham awiing vu Yesuu-to. ");
INSERT INTO mmo_vpl VALUES ("AC3_19","074_3_19","ACT","3","19","19","+ o 3:19 Sin 2:38*Om nambêênja ham anggilin ham alompayo naah vu Anutu in nambe kawiiy hamate nipaya na valok-ate, ");
INSERT INTO mmo_vpl VALUES ("AC3_20","074_3_20","ACT","3","20","20","de Omaaho Bop-ate samu samu naam naakuuh vu ham, de biing Kalisi sen yoo holin yi vu ham lung la bôôy-ato be naas vu ham, ond yik Yesuu-ju. ");
INSERT INTO mmo_vpl VALUES ("AC3_21","074_3_21","ACT","3","21","21","Lemu yoo le mando baandoni vêêl e in ganggin busin sen Anutu wiing-ambe yite hil vaambuung-aso lanêêl langaah bôôy-ato nambe Anutu le samu va pin naatu nivasa naah. ");
INSERT INTO mmo_vpl VALUES ("AC3_22","074_3_22","ACT","3","22","22","+ o 3:22 Diu 18:15,18-19; Sin 7:37*De Mose nêêl nambe, ‘Omaaho Bop Anutu yoo le golin ham o halim-aso ti naatu hamate omaaho ti in naanêêl Anutu-te vakasin langaah naambe sen holin saa-to, de vakasin pin sen naanêêl vu ham-ato ond ham gambe nanyem in. ");
INSERT INTO mmo_vpl VALUES ("AC3_23","074_3_23","ACT","3","23","23","Tombe hil pin sen me-gambe nanyend in omaahôô-ju yite vakasin-ato, ond Anutu le kawiiy sil, de sil-ame le mando gaving Islel naah e.’ ");
INSERT INTO mmo_vpl VALUES ("AC3_24","074_3_24","ACT","3","24","24","De hil pin sen danêêl Anutu-te vakasin langaah bôôy-ato, ond Samuel having hil vaalu vu taamusin-ato, ond sil pin lanêêl vakasin lak busin gêên-anjo. ");
INSERT INTO mmo_vpl VALUES ("AC3_25","074_3_25","ACT","3","25","25","+ o 3:25 Jen 22:18; Gal 3:8*Vakasin sen Anutu nêêl lung la lak yate himbop-aso bôôy, de lak hil sen danêêl Anutu-te vakasin langaah-ato ond silate hil vu taamusin ham-ato, ond vakasin-anja nêêl vu Abalaam nambe, ‘Saambiing gate hil vu taamusin ti yite samu samu na dôôvu omaahonôôn nohvu taaku pin.’ ");
INSERT INTO mmo_vpl VALUES ("AC3_26","074_3_26","ACT","3","26","26","+ o 3:26 Sin 13:46*Om Anutu holin yite kul vaha be wiing laam nyendoos vu ham in nambe samu ham-ande biing-ambe ham anggilin ham alompayo ti ti be ham gavuuh hamate nipaya vaha vaha na.” ");
INSERT INTO mmo_vpl VALUES ("AC4_1","074_4_1","ACT","4","1","1","+ o 4:1 Luk 22:4,52*Ngaaho lak in taaku naambus na tombe Pita yuuh Jon daahen mondanêêl vakasin vu hil, tonde kul vaha sen datung salivangin-ato laving yêêv sen nanggin Anutu-te dumb bop-ato osin hil Sadusi lala lalup vu yuuh. ");
INSERT INTO mmo_vpl VALUES ("AC4_2","074_4_2","ACT","4","2","2","+ o 4:2 Sin 23:8*Hil-anju ahend kalin vu yuuh in nambe yuuh davu taahu hil osin yuuh danêêl vakasin sen Yesu kandi lak laah om hil yimbin pin e kandi jak naah-ato, ");
INSERT INTO mmo_vpl VALUES ("AC4_3","074_4_3","ACT","4","3","3","+ o 4:3 Sin 5:18*tombe lalôôh yuuh-ambe lala laayiiy vinavi in yuuh in nambe yuuh mando be samiinaanôôn e mem. ");
INSERT INTO mmo_vpl VALUES ("AC4_4","074_4_4","ACT","4","4","4","+ o 4:4 Sin 2:41; 5:14*Lemu hil sen lango Pita-te vakasin-ambe lawii-having-ato, ond hil-anju moow ngeeyaata lôôt lohvu 5 taosen. ");
INSERT INTO mmo_vpl VALUES ("AC4_5","074_4_5","ACT","4","5","5","Samiinaanôôn atombe silate yêêv bop-aso laving himbop-aso de tanasin dangga-so be lasupin vu Yelusalem, ");
INSERT INTO mmo_vpl VALUES ("AC4_6","074_4_6","ACT","4","6","6","ond sil lasupin having kul vaha sen datung salivangin-ato silate yêêv bop Anas, de Kaiapas ayuuh Jon, de Aleksanda, tonde yêêv bop Anas-ate hil pin. ");
INSERT INTO mmo_vpl VALUES ("AC4_7","074_4_7","ACT","4","7","7","+ o 4:7 Mat 21:23*Tombe lalaah sinaale yuuh-anjuuto daale sil amend, le mem lalingin yuuh nambe, “Muuh nawiing vaa-jo lak lati-te niwêêk osin haale?” ");
INSERT INTO mmo_vpl VALUES ("AC4_8","074_4_8","ACT","4","8","8","+ o 4:8 Mat 10:19-20; Sin 7:55*Tombe Vavi Vaambuung hôôvu Pita, om nêêl vu sil nambe, “Ham sen ham atu hil-ate yêêv bop-ato osin himbop-aso pin, ");
INSERT INTO mmo_vpl VALUES ("AC4_9","074_4_9","ACT","4","9","9","gêên-anjo haay samu vakasin vu ham in samu samu sen haay aawiing vaha paaya ti nivasa hôôk-ato, de haay tatekin danggakook vu ham. ");
INSERT INTO mmo_vpl VALUES ("AC4_10","074_4_10","ACT","4","10","10","+ o 4:10 Sin 3:6,13-16*Om nambêênja ham pin-ande Islel pin, ond ham oo anjak ni naambe omaahôô-jo nivasa lak-ambe gêên naale hôôk ham amem lak Yesu Kalisi Nasaalet haale, sen ham ayiis ak haah pako, lemu Anutu wiing-ambe kandi lak laah vu hil yimbin-atêêto. ");
INSERT INTO mmo_vpl VALUES ("AC4_11","074_4_11","ACT","4","11","11","+ o 4:11 Saam 118:22; Mat 21:42; 1Pi 2:4,7*Ond Yesuu-ju ‘tatuuh sen ham hil kul-aso yoo nimbaya lôôt nambe ham-ame andaav bayêên ak-ato, lemu gêên tu bayêên ahelasu-te kook aniwêêk.’ ");
INSERT INTO mmo_vpl VALUES ("AC4_12","074_4_12","ACT","4","12","12","+ o 4:12 Mat 1:21; Sin 5:34-35*Omaaho ti me-lukalaah nambe dôôvu yiiy e, de vu taaku pin ond Anutu me-taato omaaho ti haale vu yiiy nambêênja in nambe dôôvu yiiy e, yik Yesu timu.” ");
INSERT INTO mmo_vpl VALUES ("AC4_13","074_4_13","ACT","4","13","13","Tombe kaansol-aso lavindis lôôt in Pita yuuh Jon danêêl tanasin osin niwêêk de yuuh-ame dayêênin e, tombe lalak ni nambe yuuh-ame vu hil tanasin-ate le, yuuh vu hil malis-ate, lemu lalak ni having nambe bôôy yuuh dando having Yesu. ");
INSERT INTO mmo_vpl VALUES ("AC4_14","074_4_14","ACT","4","14","14","Tombe layi de omaaho vaha paayaa-to nivasa lak lung la be naale having yuuh, om silanêênd vakasin sen daanêêl naah vu yuuh-ato ma. ");
INSERT INTO mmo_vpl VALUES ("AC4_15","074_4_15","ACT","4","15","15","Yik lanêêl vu yuuh amu nambe yuuh gavuuh kaansol-aso de lana voon, om yuuh lala de sil oo mondakaas in nambe, ");
INSERT INTO mmo_vpl VALUES ("AC4_16","074_4_16","ACT","4","16","16","+ o 4:16 Jon 11:47*“Yale aambiing naambe vaati vu omaaho yuuh-anju? In hil Yelusalem pin layi nambe yuuh lawiing taahu taahu bopaata osin niwêêk tii-ju, om yame aalohvu nambe yanjak alungg in e. ");
INSERT INTO mmo_vpl VALUES ("AC4_17","074_4_17","ACT","4","17","17","+ o 4:17-19 Sin 5:28-29,40*Lemu vakasin-anjo le na nohvu hil pin, om yaambu kôôvu yuuh naambe yuuh-ame daanêêl vakasin vu omaaho ti jak Yesu haale jesin naah e.” ");
INSERT INTO mmo_vpl VALUES ("AC4_18","074_4_18","ACT","4","18","18","Tombe lateey yuuh lalom-ambe lavu kôôvu yuuh nambe yuuh-ame daanêêl Yesu haale osin yuuh-ame taahu hil jak Yesu haale jesin naah e. ");
INSERT INTO mmo_vpl VALUES ("AC4_19","074_4_19","ACT","4","19","19","Le Pita yuuh Jon lanêêl laah vu sil nambe, “Ham akam oo bu vêêl e, naambe haay gangoyin ham lavam ond haay nanyengg doos vu Anutu, tombe naambêênjo Anutu me-le ji nivasa le. ");
INSERT INTO mmo_vpl VALUES ("AC4_20","074_4_20","ACT","4","20","20","Va sen haay aahe osin haay hango ond me-lohvu nambe haay anjak alungg in e, haay oo aawiingin nambe naanêêl vakasin-anjo lôôt.” ");
INSERT INTO mmo_vpl VALUES ("AC4_21","074_4_21","ACT","4","21","21","Tombe kaansol-aso salo mopaatôôv in nambe lambu nivaane vu yuuh, lemu layi de hil pin lako Anutu haale lak in va sen yuuh lawiing-ato, om lavu kôôvu yuuh yesin laah, de lanêêl-ambe yuuh lala. ");
INSERT INTO mmo_vpl VALUES ("AC4_22","074_4_22","ACT","4","22","22","De omaaho sen yuuh lawiing-ambe nivasa lak-ato ond yite ta doo-yuuh lung la. ");
INSERT INTO mmo_vpl VALUES ("AC4_23","074_4_23","ACT","4","23","23","Pita yuuh Jon lalaah lato vu yuuhate hil, tombe yuuh lanêêl vakasin pin sen kul vaha sen datung salivangin-ato silate yêêv-aso osin himbop-aso lanêêl vu yuuh-ato vu sil. ");
INSERT INTO mmo_vpl VALUES ("AC4_24","074_4_24","ACT","4","24","24","+ o 4:24 Eks 20:11; Nie 9:6; Saam 146:6*Tombe sil lango lung la, tonde sil pin alondpayo lavuh ti be lalohak vu Anutu nambe, “O Omaaho Bop, hong sen ohatung yendak osin ngaanggis, de lôôy osin va pin sen nando lohvu taaku pin-ato, ");
INSERT INTO mmo_vpl VALUES ("AC4_25","074_4_25","ACT","4","25","25","+ o 4:25-26 Saam 2:1-2*de gate Vavi Vaambuung wiing vakasin ti la vu heyate himbop bôôy Devit sen tu gate kul vahaa-to, ond Vavi Vaambuung nêêl nambe, ‘Nambe vaati om hil vaalu sen sil-ame Yudaa-to ond ahend kalin-ambe davu daandun bopaata, de yate hil Islel ond kand navu vakasin malis amu? ");
INSERT INTO mmo_vpl VALUES ("AC4_26","074_4_26","ACT","4","26","26","De hil lulemak-aso vu taaku pin osin yêêv bop-aso pin lasupin lalaam in nambe lanyiis ngaamong ak Omaaho Bop gaving yite omaaho sen yoo holin yi vulôôt in nambe dôôvu yiiy-ato.’ ");
INSERT INTO mmo_vpl VALUES ("AC4_27","074_4_27","ACT","4","27","27","+ o 4:27 Mat 27:1-2; Luk 23:7-11; Sin 3:13*“Keen lôôt, Helot ayuuh Pontias Pilata laving hil vaalu osin hil Islel ond hil-anjo lasupin lalaam taakuu-jo in nambe lanyiis ngaamong vu gate kul vaha omaaho vaambuung Yesu sen goo gaholin yii-to, ");
INSERT INTO mmo_vpl VALUES ("AC4_28","074_4_28","ACT","4","28","28","+ o 4:28 Sin 2:23*ond sil lasupin in nambe lanyiis Yesu nohvu goo gakam vu niwêêk-ambe osamu lung la nambe nôôn jak-ato. ");
INSERT INTO mmo_vpl VALUES ("AC4_29","074_4_29","ACT","4","29","29","+ o 4:29 Ep 6:19*“O Omaaho Bop, gêên-anjo gakam bu vakasin sen lavu kôôvu hey-ato, be gandôôvu gate hil hey in hey naanêêl gate vakasin niwêêk lôôt, de hey-ame aanjêênin e. ");
INSERT INTO mmo_vpl VALUES ("AC4_30","074_4_30","ACT","4","30","30","Otalo namam in biing-ambe hil anilakin nind vasa jak, de gandôôvu hey in hey aambiing taahu taahu osin niwêêk jak gate kul vaha omaaho vaambuung Yesu haale.” ");
INSERT INTO mmo_vpl VALUES ("AC4_31","074_4_31","ACT","4","31","31","+ o 4:31 Sin 2:4*Lalohak lung la tonde bayêên sen lasupin-ambe dando hôôk-ato yêêy, tombe Vavi Vaambuung hôôvu sil pin, om sil lanêêl Anutu-te tanasin niwêêk lôôt de me-layêênin e. ");
INSERT INTO mmo_vpl VALUES ("AC4_32","074_4_32","ACT","4","32","32","+ o 4:32 Sin 2:44*Hil ngeeyaata sen lawii-having osin ahend having sil-ato ond londpayo lavuh ti pin, de va sen sil ti ti yoote vaa-to ond ti me-nêêlin yite vati nambe yoo yite va nivalok e, malis, va sen silate vaa-to ond yik sil pin-ate va. ");
INSERT INTO mmo_vpl VALUES ("AC4_33","074_4_33","ACT","4","33","33","+ o 4:33 Sin 2:47*Anutu vu niwêêk bopaata vu sinaale-so be sil tatekin va sen Omaaho Bop Yesu kandi lak laah-ato langaah lôôt, tombe hil pin layi nambe Anutu-te samu samu bopaata nando having sil. ");
INSERT INTO mmo_vpl VALUES ("AC4_34","074_4_34","ACT","4","34","34","+ o 4:34 Sin 2:45*Tombe silate omaaho ti me-nativak in vati le, in dangga nambe lavu ngaanggis osin bayêên-ambe hil laanggo, de lako mone be ");
INSERT INTO mmo_vpl VALUES ("AC4_35","074_4_35","ACT","4","35","35","lala lavu vu sinaale-so, tombe latiiy monêê-jo vu omaahonôôn vaalu sen silanêênd va yuuh ame ma de dativak-ato. ");
INSERT INTO mmo_vpl VALUES ("AC4_36","074_4_36","ACT","4","36","36","+ o 4:36 Sin 11:22-26; 13:2-3*De Liwi-te hil vu taamusin-ato ti baan Saiplas, haale nambe Yusep, de sinaale-so lanêêl haale ango nambe Banabas, haalêê-jo dangga nambe omaaho sen navu niwêêk, ");
INSERT INTO mmo_vpl VALUES ("AC4_37","074_4_37","ACT","4","37","37","ond vu yite kul ti vu omaaho ti vaanggo de hako mone pin-ambe la vu vu sinaale-so. ");
INSERT INTO mmo_vpl VALUES ("AC5_1","074_5_1","ACT","5","1","1","De omaaho ti haale nambe Ananaias, de vane haale nambe Saapila, ond yuuh lavu yuuhate ngaanggis boow ti be hil laanggo, ");
INSERT INTO mmo_vpl VALUES ("AC5_2","074_5_2","ACT","5","2","2","+ o 5:2 Sin 4:34-35*tombe sim Ananaias vun mone sen yuuh lako lak ngaanggis-ato vaalu be vane yi, de hako vaalu be la vu vu sinaale-so. ");
INSERT INTO mmo_vpl VALUES ("AC5_3","074_5_3","ACT","5","3","3","+ o 5:3 Jon 13:2*Tombe Pita nêêl vu nambe, “Ananaias, nambe vaati sen Saalang lukala galompayo be gavun mone vaalu? Gawiingin nambe tatuhin Vavi Vaambuung a? ");
INSERT INTO mmo_vpl VALUES ("AC5_4","074_5_4","ACT","5","4","4","Om naambe bôôy-ato gate ngaanggis oo nanjip, le ma de gavu be hil laanggo lung la, om naambe gate mone yoo mando. Le sim nambe vaati sen gakam oo vu vakasin nambêênja hôôk galompayo? Gambe otatuhin omaahonôôn a? Malis, manyinja otatuhin Anutu.” ");
INSERT INTO mmo_vpl VALUES ("AC5_5","074_5_5","ACT","5","5","5","+ o 5:5 Sin 2:43*Ananaias hangoyin vakasin-anju tombe lupake be yimb meta, tombe sim hil pin sen lango banyêê-to layêênin lôôt, ");
INSERT INTO mmo_vpl VALUES ("AC5_6","074_5_6","ACT","5","6","6","tombe maanggêêm-aso kandi be layum hôôk tôômb, de laaku be lala lahaav. ");
INSERT INTO mmo_vpl VALUES ("AC5_7","074_5_7","ACT","5","7","7","De taaku mekaalus yaal lung la le mem Ananaias vane valup, le doosin va sen tovu layaa-jôôto, ");
INSERT INTO mmo_vpl VALUES ("AC5_8","074_5_8","ACT","5","8","8","tombe yik Pita lingin nambe, “Onaanêêl vu sa le, naambe mone sen muuh hako lak ngaanggis-ato ond yik lung laa-jo?” Tombe Saapila liinggis nambe, “Êê-e, yik lung laa-ja.” ");
INSERT INTO mmo_vpl VALUES ("AC5_9","074_5_9","ACT","5","9","9","+ o 5:9 1Ko 10:9*Om Pita nêêl vu nambe, “Nambe vaati sen malompayo lavuh tii-jo? Mawiingin nambe sahi Omaaho Bop-ate Vavi Vaambuung a? Om gangge le, hil sen lahaav layam-ato ond lalu-daale vinavii-ja in davu baaku hong-ambe lana.” ");
INSERT INTO mmo_vpl VALUES ("AC5_10","074_5_10","ACT","5","10","10","Om pavis atombe vêêh-anjôôto lupake be la yimb meta neep hôôk Pita vaha, tombe hil sen lahaav layaa-to layi nambe yimb, om lalukala laaku be lala lahaav having laya. ");
INSERT INTO mmo_vpl VALUES ("AC5_11","074_5_11","ACT","5","11","11","De hil bel-ate pin osin hil vaalu sen lango vakasin-anjo banyêê-to ond layêênin lôôt. ");
INSERT INTO mmo_vpl VALUES ("AC5_12","074_5_12","ACT","5","12","12","+ o 5:12 Sin 2:43; 14:3*Sinaale-so yoo mondawiing taahu taahu ngeeyaata osin niwêêk hôôk hil lavuun, de hil pin sen lawii-having-ato ond londpayo lavuh ti be dasupin dala Anutu-te dumb bop alo ti sen danêêl haale nambe Solomon-atêêto. ");
INSERT INTO mmo_vpl VALUES ("AC5_13","074_5_13","ACT","5","13","13","Tombe hil vaalu dayêênin-ande me-dasupin having sil e, lemu hil dako sil haalend ak, ");
INSERT INTO mmo_vpl VALUES ("AC5_14","074_5_14","ACT","5","14","14","+ o 5:14 Sin 2:41; 21:20*tombe moow ayuuh vêêh ngeeyaata lôôt dawii-having Omaaho Bop-ambe dalukala having yite hil. ");
INSERT INTO mmo_vpl VALUES ("AC5_15","074_5_15","ACT","5","15","15","Om hil daaku hil anilakin-ambe lala dambe sil deep ak kaanye yuuh ame hôôk mopaatôôv nanyendangga, in nambe Pita balu-na de taaku naambiiy jak yi be kanu mu jêês sil e mem nind vasa jak. ");
INSERT INTO mmo_vpl VALUES ("AC5_16","074_5_16","ACT","5","16","16","+ o 5:16 Mak 6:56; Sin 19:11-12*De hil ngeeyaata vu taaku bo-bop sen neep ngaaho vu Yelusalem-ato, ond lako hil anilakin osin hil sen mamu nipaya nahôôvu sil-ato be lasupin lalaam timu vu sinaale-so be dawiing-ambe sil anind vasa nahôôk pin. ");
INSERT INTO mmo_vpl VALUES ("AC5_17","074_5_17","ACT","5","17","17","+ o 5:17-18 Sin 4:1-3,6*Tombe sim kul vaha sen datung salivangin-ato silate yêêv bop osin hil pin sen dando having yii-to ond sil vu hil tanasin vaha ti sen danêêl sil nambe Sadusii-to, ond ahend anipaya vu sinaale-so lôôt, ");
INSERT INTO mmo_vpl VALUES ("AC5_18","074_5_18","ACT","5","18","18","om lalôôh sil-ambe latung sil lalukala kalaambus-ate bayêên bop. ");
INSERT INTO mmo_vpl VALUES ("AC5_19","074_5_19","ACT","5","19","19","+ o 5:19 Sin 12:7-10*Lemu busin atombe Omaaho Bop-ate angela ti hato hataahin vinavi de giiy sil-ambe lala voon, de nêêl nambe, ");
INSERT INTO mmo_vpl VALUES ("AC5_20","074_5_20","ACT","5","20","20","“Ham ana baale Anutu-te dumb bop alo be ham naanêêl tanasin sen ham mando metumin-atêêto langaah pin vu hil.” ");
INSERT INTO mmo_vpl VALUES ("AC5_21","074_5_21","ACT","5","21","21","Sinaale-so lango vakasin-anju tombe samiinaanôôn lalukala dumb alo pavis-ambe lanêêl tanasin vu hil. Tombe yêêv bop salivangin-ate having yite hil, ond lateey Islel-ate kaansol-aso osin himbop-aso be lasupin lavuh ti pin, le mem lanêêl-ambe hil lala in nambe gako sinaale-so vu bayêên kalaambus naam. ");
INSERT INTO mmo_vpl VALUES ("AC5_22","074_5_22","ACT","5","22","22","Om ahevaavu-so lala bayêên kalaambus-ambe layi sinaale-so, le ma de taaku malis. Tombe lalaah-ambe lanêêl nambe, ");
INSERT INTO mmo_vpl VALUES ("AC5_23","074_5_23","ACT","5","23","23","“Hey ala hato bayêên kalaambus e laayiiy vinavi be niwêêk lôôt, de ahevaavu-so yoo daale danggin vinavi ti ti, tombe hey hataahin vinavi le omaaho ti me-nando hôôk bayêên alo le.” ");
INSERT INTO mmo_vpl VALUES ("AC5_24","074_5_24","ACT","5","24","24","Tombe yêêv sen nanggin Anutu-te dumb bop-ato having yêêv salivangin-ate lango vakasin-anju be kand yu-yuuh lôôt nambe vaa-jo le naambe vaati. ");
INSERT INTO mmo_vpl VALUES ("AC5_25","074_5_25","ACT","5","25","25","Le omaaho ti valup-ambe nêêl vu sil nambe, “Ham angge, hil sen ham hatung sil hôôk kalaambus-ato ond lala daale danêêl tanasin vu hil hôôk dumb alo ni.” ");
INSERT INTO mmo_vpl VALUES ("AC5_26","074_5_26","ACT","5","26","26","+ o 5:26 Mat 14:5*Tombe yêêv sen nanggin Anutu-te dumb bop-ato osin ahevaavu-so lala lako sinaale-so, lemu me-layiis sil e, malis, in yêêv-aso layêênin hil nambe le lanyiis sil lak tatuuh. ");
INSERT INTO mmo_vpl VALUES ("AC5_27","074_5_27","ACT","5","27","27","Lako sinaale-so lalaam-ambe lalaah sil daale kaansol-aso mend, de yêêv bop salivangin-ate nêêl vu sil nambe, ");
INSERT INTO mmo_vpl VALUES ("AC5_28","074_5_28","ACT","5","28","28","+ o 5:28 Sin 4:18; Mat 27:25*“Hey aavu kôôvu ham bôôy nambe ham-ame taahu hil jak omaahôô-ju haale le, le ma de hamate tanasin lohvu taaku Yelusalem pin, de ham awiingin tatuhin vakasin jak hey naambe hey oo aayiis omaahôô-ju.” ");
INSERT INTO mmo_vpl VALUES ("AC5_29","074_5_29","ACT","5","29","29","+ o 5:29 Sin 4:19*Lemu Pita having sinaale-so lanêêl laah vu sil nambe, “Yik hey oo gango Anutu lava mu kaluuh omaahonôôn lavand. ");
INSERT INTO mmo_vpl VALUES ("AC5_30","074_5_30","ACT","5","30","30","+ o 5:30 Sin 3:15*Yesu sen ham ayiis ak haah-ambe yimb-ato, ond yate himbop-aso bôôy silate Anutu wiing-ambe kandi lak. ");
INSERT INTO mmo_vpl VALUES ("AC5_31","074_5_31","ACT","5","31","31","+ o 5:31 Sin 2:33-34; Ep 1:20; Hiblu 2:10; 12:2*Tombe Anutu hako yi lak-ambe la nando nama vasa, be tu yate yêêv bop in nambe dôôvu yiiy osin biing-ambe yiiy Islel yaanggilin yalonggpayo na vu yi be mem kawiiy yate va nipaya na. ");
INSERT INTO mmo_vpl VALUES ("AC5_32","074_5_32","ACT","5","32","32","+ o 5:32 Sin 1:8*Vakasin-anjo hey aahe osin hey hango, de Vavi Vaambuung sen Anutu navu vu hil sen nanyend vuun-ato hôôvu hey having, ondeey hey oo monaanêêl tatekin.” ");
INSERT INTO mmo_vpl VALUES ("AC5_33","074_5_33","ACT","5","33","33","+ o 5:33 Sin 7:54*Kaansol-aso lango vakasin sen Pita nêêl-anjo tombe kund sil alondpayo in nambe lanyiis sinaale-so be lanjimb pavis. ");
INSERT INTO mmo_vpl VALUES ("AC5_34","074_5_34","ACT","5","34","34","+ o 5:34 Sin 22:3*Lemu kaansol-asôônjôôto ti haale nambe Gamaaliel, yi Palisai ti ond tu kaputung tanasin dangga ti sen omaahonôôn pin dako yii-ju haale lak, ond kandi naale de nêêl-ambe hil lako sinaale-so be lato lala voon vêêl e ");
INSERT INTO mmo_vpl VALUES ("AC5_35","074_5_35","ACT","5","35","35","mem nêêl vu kaansol-aso nambe, “Ham Islel, ham awiingin nambe ambiing vati vu hil-anja, ond halingg-aso, ham akam bu nivasa le mem. ");
INSERT INTO mmo_vpl VALUES ("AC5_36","074_5_36","ACT","5","36","36","+ o 5:36 Sin 21:38*In bôôy ond Tiudas hatee yi lak in nambe naatu omaaho osin haale bop, tombe moow ngeeyaata lohvu 400 lawii-having yi, lemu gaaman layiis-ambe yimb, de hil pin sen lawii-having yii-to lavuuh taale, de silanêênd kul nôôn ma. ");
INSERT INTO mmo_vpl VALUES ("AC5_37","074_5_37","ACT","5","37","37","+ o 5:37 Luk 2:1-2*De vu taamusin hôôk busin sen yêêv-aso navu kaavu hil haalend-ato, ond Yudas vu Galili hatee yi lak, om hako hil vaalu be lala in nambe lambiing ngaamong vu gaaman, le ma de layiis-ambe yimb having, de yite hil pin sen lawii-having yii-to lavuuh taale. ");
INSERT INTO mmo_vpl VALUES ("AC5_38","074_5_38","ACT","5","38","38","Om gêên-anjo sa naanêêl vu ham naambe ham gavuuh hil-anja be lana, in naambe silate kul-anjo vu omaahonôôn akand ond le na paya, ");
INSERT INTO mmo_vpl VALUES ("AC5_39","074_5_39","ACT","5","39","39","le naambe kul-anjo danggakook vu Anutu ond ham-ame alohvu nambe kawiiy e, in ham e naambe hil sen dayiis ngaamong vu Anutuu-to.” ");
INSERT INTO mmo_vpl VALUES ("AC5_40","074_5_40","ACT","5","40","40","+ o 5:40 Sin 4:18*Tombe kaansol-asôônju lawii-having Gamaaliel-ate vakasin om lateey sinaale-so lalom-ambe laveek sil, de lavu kôôvu sil niwêêk lôôt nambe me-daanêêl tanasin jak Yesu haale jesin naah e, tonde lanêêl-ambe lato lala voon. ");
INSERT INTO mmo_vpl VALUES ("AC5_41","074_5_41","ACT","5","41","41","+ o 5:41 Mat 5:10-12; 1Pi 4:13*Tombe sinaale-so lavuuh kaansol-aso de lala osin kand vasa lôôt, in Anutu yi nambe sil lalohvu om liinggis-ambe hil lawiing nindanjeen vu sil lak Yesu haale. ");
INSERT INTO mmo_vpl VALUES ("AC5_42","074_5_42","ACT","5","42","42","+ o 5:42 Sin 9:22; 17:3*Tombe lak busin pin vu Anutu-te dumb bop alo de vu sil ambaand ond sil oo motaahu hil osin sil oo mondanêêl Yesu Kalisi-te banye nivasa langaah. ");
INSERT INTO mmo_vpl VALUES ("AC6_1","074_6_1","ACT","6","1","1","+ o 6:1 Sin 4:35*Yesu-te hil latu ngeeyaata lak, tombe vaalu sen dakaas lavand Glik-ato dayi vaalu sen dakaas lavand Hibluu-to paya lak busin pin sen datiiy va yuuh amêê-to nambe, “Ham akam nalingin heyanêêngg vehaahôôv-aso.” ");
INSERT INTO mmo_vpl VALUES ("AC6_2","074_6_2","ACT","6","2","2","Om sinaale-so nomaayuuh-ambe laam yuuh-ato lateey Yesu-te hil pin lalaam, le mem lanêêl vu sil nambe, “Me-lohvu nambe hey oo monggatiiy vanôôn-ande hey gavuuh Anutu-te vakasin e. ");
INSERT INTO mmo_vpl VALUES ("AC6_3","074_6_3","ACT","6","3","3","+ o 6:3 1Ti 3:7*Om halingg-aso, ham anggolin hamate hil sen hil pin dayi sil anivasaa-to namaavaalu be vindak yuuh, ond hil sen Vavi Vaambuung hôôvu sil osin sil alundkook anivasa, be yiiy gatung sil oo ganggin kul sil gatiiy va yuuh ame nivalok, ");
INSERT INTO mmo_vpl VALUES ("AC6_4","074_6_4","ACT","6","4","4","de hey-anjo yoo monaanohak osin hey monaanêêl Anutu-te vakasin.” ");
INSERT INTO mmo_vpl VALUES ("AC6_5","074_6_5","ACT","6","5","5","+ o 6:5 Sin 8:5*Tombe hil pin sen lasupin-anjôôto lango vakasin-anjo be nivasa, om laholin Stiven in yoo wii-having niwêêk-ambe Vavi Vaambuung hôôvu yi, de laholin Pilip ayuuh Plokolas, de Naikena yuuh Timon, de Pamenas ayuuh Nikolas. Nikolas-anjo yi vu Antiok ond bôôy hilin lopayo be lukalaam having Yuda-so. ");
INSERT INTO mmo_vpl VALUES ("AC6_6","074_6_6","ACT","6","6","6","+ o 6:6 Sin 13:3; 14:23*Tombe lalaah hil-anjo lala daale sinaale-so mend-ambe sinaale-so lalohak lung la, tonde lambe namand ak sil. ");
INSERT INTO mmo_vpl VALUES ("AC6_7","074_6_7","ACT","6","7","7","+ o 6:7 Sin 2:41; 16:5*Ke, om Anutu-te tanasin tu ahepataas ak, tombe hil Yelusalem ngeeyaata latu Yesu-te hil, tonde yik kul vaha sen datung salivangin-ato ngeeyaata lawii-having. ");
INSERT INTO mmo_vpl VALUES ("AC6_8","074_6_8","ACT","6","8","8","+ o 6:8 Sin 2:43*Stiven-anjo omaaho niwêêk bopaata osin samu samu danggakook, de nawiing taahu taahu bopaata osin niwêêk-ambe hil dayi, ");
INSERT INTO mmo_vpl VALUES ("AC6_9","074_6_9","ACT","6","9","9","tombe hil vaalu kandi be sil o Stiven-aso lanêêl sil in tanasin. Sil vaalu vu Sailini osin Aleksandlia, de sil danêêl silate dumb nambe hil sen lavu vêêl sil vêêl in omaaho ango namand lung laa-to silate dumb. De sil vaalu vu Silisia osin Esia having. ");
INSERT INTO mmo_vpl VALUES ("AC6_10","074_6_10","ACT","6","10","10","+ o 6:10 Luk 21:15*Om sil o Stiven-aso lanêêl sil, le ma de Vavi Vaambuung vu kakook anivasa vu Stiven om hil-ame lalohvu yite vakasin e. ");
INSERT INTO mmo_vpl VALUES ("AC6_11","074_6_11","ACT","6","11","11","+ o 6:11 Mat 26:59-61*Tombe lala lanêêl hôôk hil vaalu ahend nambe daanêêl vakasin tatuhin jak yi naambe, “Hey hango de nêêl Mose yuuh Anutu pale.” ");
INSERT INTO mmo_vpl VALUES ("AC6_12","074_6_12","ACT","6","12","12","Mondanêêl atombe vakasin-anju kund hil pin alondpayo, om himbop-aso tanasin dangga-so lala lalôôh Stiven, de sil laandiiy-ambe lala vu kaansol-aso, ");
INSERT INTO mmo_vpl VALUES ("AC6_13","074_6_13","ACT","6","13","13","+ o 6:13 Jer 26:11*tombe lanêêl vu tatuhin ambu-so vaalu om lalaam-ambe lanêêl nambe, “Omaahôô-jo yoo monanêêl vakasin anipaya lak taaku vaambuung-anjo osin Mose-te tanasin, ");
INSERT INTO mmo_vpl VALUES ("AC6_14","074_6_14","ACT","6","14","14","de hey hangoyin nêêl nambe Yesu Nasaalet e kawiiy dumb-anjo de gilin tanasin sen Mose vu vu yiiy-ato.” ");
INSERT INTO mmo_vpl VALUES ("AC6_15","074_6_15","ACT","6","15","15","Tombe kaansol-aso hil pin sen dandôô-juuto ond sil amend la vu Stiven niwêêk lôôt e layi de mekaalus lohvu angela me. ");
INSERT INTO mmo_vpl VALUES ("AC7_1","074_7_1","ACT","7","1","1","Kul vaha sen datung salivangin-ato silate yêêv bop lingin Stiven nambe, “Vakasin-anju keen a?” ");
INSERT INTO mmo_vpl VALUES ("AC7_2","074_7_2","ACT","7","2","2","+ o 7:2-5 Jen 11:31–12:7*Tombe Stiven nêêl vu sil nambe, “Halingg-aso mangg-aso, ham gango sate vakasin e. Vu bôôy yate himbop Abalaam naahen nando Mesopotemia de me-la nando Halan e, tombe melangaah danggakook Anutu taato yi vu, ");
INSERT INTO mmo_vpl VALUES ("AC7_3","074_7_3","ACT","7","3","3","be nêêl vu yi nambe, ‘Onggavuuh gate taaku nanjip osin gate hil mando, de gana taaku ti soo le taato vu hong.’ ");
INSERT INTO mmo_vpl VALUES ("AC7_4","074_7_4","ACT","7","4","4","Tombe Abalaam havuuh hil Kaldia-te taaku de la nando Halan, tonde mangganaan yimb lung la le mem Anutu hakoseey yi vuu-ju be lom nando taaku sen gêên ham nandôô-jo. ");
INSERT INTO mmo_vpl VALUES ("AC7_5","074_7_5","ACT","7","5","5","+ o 7:5 Jen 15:18; 17:8*De Anutu me-vu ngaanggis daka vu Abalaam in nambe yoo yinêên nivalok e, malis lôôt, lemu Anutu nêêl nambe taamusin e mem, le bu ngaanggis-anjo vu yi osin yite hil vu taamusin in naatu silate ngaanggis. Busin-anju Abalaam noow ma, de Anutu nêêl vakasin-anjo, ");
INSERT INTO mmo_vpl VALUES ("AC7_6","074_7_6","ACT","7","6","6","+ o 7:6 Jen 15:13-14; Eks 12:40*ond nêêl nambe, ‘Gate hil vu taamusin le lana mando hil bamaan-ate taaku, be daatu silate hil kul vaha malis amu, de lambiing nindanjeen vu sil lôôt nohvu ta 400.’ ");
INSERT INTO mmo_vpl VALUES ("AC7_7","074_7_7","ACT","7","7","7","+ o 7:7 Eks 3:12*De Anutu nêêl having nambe, ‘Hil sen lambiing nindanjeen vu sil-ato, ond sale aambu nyevahaan naatovu sil jung na le mem gate hil e lanom-anjo be lanohak vu sa vu taakuu-jo.’ ");
INSERT INTO mmo_vpl VALUES ("AC7_8","074_7_8","ACT","7","8","8","+ o 7:8 Jen 17:9-14; 21:4*Tonde Anutu nêêl vu Abalaam nambe galaah unoopasiv anind naavi in taato naambe latu Anutu-te hil, om vu taamusin sen Abalaam hako noow Isak, tombe busin namaavaalu be vindak yaal lung la le mem halaah ninaavi. Isak-anju noow Yaakop, de Yaakop noow-aso ond yate danggakook-aso nomaayuuh-ambe laam yuuh, ");
INSERT INTO mmo_vpl VALUES ("AC7_9","074_7_9","ACT","7","9","9","+ o 7:9 Jen 37:11,28; 39:1-3,21-23*tombe yate danggakook-asôônju londpayo nipaya vu Yusep om lala lavu be hil laanggo de lako be lala Ijip. Lemu Anutu nando having yi ");
INSERT INTO mmo_vpl VALUES ("AC7_10","074_7_10","ACT","7","10","10","+ o 7:10 Jen 41:37-44; Saam 105:21*om vu vêêl yi in va nimeen pin, de samu yi tombe Ijip-ate omaaho lulemak Pelo yi nambe omaaho osin lukook anivasa, om holin yi be tu Ijip-ate yêêv bop osin hanggin Pelo-te bayêên ayuuh va pin. ");
INSERT INTO mmo_vpl VALUES ("AC7_11","074_7_11","ACT","7","11","11","+ o 7:11 Jen 41:54*“Tonde meep bopaata tovu Ijip osin taaku Kanaan pin, tombe yate himbop-asôônju dando meep-ande vanôôn ma, om latovu nimeen bopaata. ");
INSERT INTO mmo_vpl VALUES ("AC7_12","074_7_12","ACT","7","12","12","+ o 7:12 Jen 42:1-5*Lemu Yaakop hango banye nambe vanôôn nando Ijip, om nêêl-ambe yate himbop-asôônju lala nyendoos. ");
INSERT INTO mmo_vpl VALUES ("AC7_13","074_7_13","ACT","7","13","13","+ o 7:13 Jen 45:1-4,16*Tonde lalaah balon ango yesin atombe Yusep nêêl yi langaah vu halindin, tombe mem Pelo lak Yusep-ate halindin anind. ");
INSERT INTO mmo_vpl VALUES ("AC7_14","074_7_14","ACT","7","14","14","+ o 7:14 Jen 45:9-11; 46:27*De Yusep nêêl vakasin la vu mangganaan Yaakop nambe gaving yite hil pin-ambe lanaam vu yi, ond hil-anju pin lohvu 75. ");
INSERT INTO mmo_vpl VALUES ("AC7_15","074_7_15","ACT","7","15","15","+ o 7:15 Jen 46:1-7; 49:33*Yaakop la hato nando Ijip vêêl e mem yimb, de yate himbop-asôônju layimb having, ");
INSERT INTO mmo_vpl VALUES ("AC7_16","074_7_16","ACT","7","16","16","+ o 7:16 Jen 23:2-20; 33:19; Jos 24:32*tombe laaku sil anind naavi be lalaah lambe neep hôôk lavandangga vu Sekem sen bôôy Abalaam vaanggo lak mone vu Hemo noondin-aso vu Sekem-ato. ");
INSERT INTO mmo_vpl VALUES ("AC7_17","074_7_17","ACT","7","17","17","+ o 7:17-18 Eks 1:7-8*“Tonde busin sen Anutu navu biing vakasin sen nêêl vu Abalaam bôôy-ato nôôn jak nambe, ‘Gate hil vu taamusin le lanom-anjo be lanohak vu sa vu taakuu-jo’ ond ngaaho lak, de hil Islel datu ngeeyaata nalak vu taaku Ijip-ambe ");
INSERT INTO mmo_vpl VALUES ("AC7_18","074_7_18","ACT","7","18","18","tok laam busin sen lulemak ti yoo nindoos lukalaah-ambe hanggin taaku Ijip-ato. Lulemak tii-ju doosin Yusep-ate dangga, ");
INSERT INTO mmo_vpl VALUES ("AC7_19","074_7_19","ACT","7","19","19","+ o 7:19 Eks 1:10-22*om tatuhin yate hil-ande nawiing nindanjeen vu sil nambe sil gaate noondin kaangêêndak na taavêêt alo be lanjimb. ");
INSERT INTO mmo_vpl VALUES ("AC7_20","074_7_20","ACT","7","20","20","+ o 7:20 Hiblu 11:23; Eks 2:2*De Mose tangganaan hako yi, tombe yi nambe yoo nivasa lôôt, om yoo mondanggin hôôk bayêên alo lohvu kwaav yaal, ");
INSERT INTO mmo_vpl VALUES ("AC7_21","074_7_21","ACT","7","21","21","+ o 7:21 Eks 2:3-10*tonde mem lala lambe neep hôôk bel nanyendangga, tombe sim Pelo nowaavêêh hako yi be la vaat tu noow-ambe bop ak. ");
INSERT INTO mmo_vpl VALUES ("AC7_22","074_7_22","ACT","7","22","22","Tombe sil taahu Mose hôôk hil Ijip-ate kakook anivasa pin, be tu omaaho nanêêl vakasin osin nawiing kul aniwêêk. ");
INSERT INTO mmo_vpl VALUES ("AC7_23","074_7_23","ACT","7","23","23","“Mose-te ta doo-yuuh lung la, tombe ka vu nambe na ji yite halindin-aso Islel. ");
INSERT INTO mmo_vpl VALUES ("AC7_24","074_7_24","ACT","7","24","24","+ o 7:24-29 Eks 2:11-15,21-22*Tombe sim yi de Ijip ti nawiing nindanjeen vu Islel ti, om hôôvu Islel-ambe vu nyevahaan vu Ijip tii-ju de yiis-ambe yimb. ");
INSERT INTO mmo_vpl VALUES ("AC7_25","074_7_25","ACT","7","25","25","Tombe ka vu nambe yite hil lalak ni nambe Anutu holin yi lung la in dôôvu sil, le ma de sil doosin. ");
INSERT INTO mmo_vpl VALUES ("AC7_26","074_7_26","ACT","7","26","26","Tonde samiinaanôôn atombe Mose laah valup e yi de omaaho yuuh mondayiis yuuh, tombe wiingin nambe bu mamaal vu yuuh om nêêl vu yuuh nambe, ‘Maayuuh, muuh halim dangga timu, le nambe tana mawiingin ambiing muuh paya?’ ");
INSERT INTO mmo_vpl VALUES ("AC7_27","074_7_27","ACT","7","27","27","Lemu omaaho sen yoo wiing ngaamong munggin vu halii-to, ond vakôôh Mose la de nêêl vu nambe, ‘Lati hatung hong in nambe onaatu yêêv-ambe ongganggin hey? ");
INSERT INTO mmo_vpl VALUES ("AC7_28","074_7_28","ACT","7","28","28","Mak gawiingin nambe ganyiis sa naambe vasêên gayiis Ijip tii-to?’ ");
INSERT INTO mmo_vpl VALUES ("AC7_29","074_7_29","ACT","7","29","29","+ o 7:29 Eks 18:3-4*Nêêl nambêênju tombe Mose pak-ambe la tu bamaan nando hil Midian-ate taaku, tombe hako vêêh-ambe hako noow moow yuuh vuu-ju. ");
INSERT INTO mmo_vpl VALUES ("AC7_30","074_7_30","ACT","7","30","30","+ o 7:30-35 Eks 3:1-10*“Nando ta doo-yuuh vu Midian lung la, tombe sim busin ti la taaku lumbalaamb ngaaho vu kandu Sinai, tombe angela ti la hato vu hôôk kin mala, ond kin-anju natum hôôk haah aniyin ti. ");
INSERT INTO mmo_vpl VALUES ("AC7_31","074_7_31","ACT","7","31","31","Mose yi kin-anju tombe vindis lôôt, om la ngaaho in nambe ji nivasa, le sim Omaaho Bop lava laam vu yi nambe, ");
INSERT INTO mmo_vpl VALUES ("AC7_32","074_7_32","ACT","7","32","32","‘Gate himbop-aso bôôy silate Anutu sa. Abalaam ayuuh Isak-ande Yaakop yaalate Anutu sa.’ Tombe Mose hees-ande yêênin lôôt nambe me-ji le, ");
INSERT INTO mmo_vpl VALUES ("AC7_33","074_7_33","ACT","7","33","33","le Omaaho Bop nêêl vu nambe, ‘Okavaayin suul na in taaku sen onaalêê-ja ond taaku vaambuung. ");
INSERT INTO mmo_vpl VALUES ("AC7_34","074_7_34","ACT","7","34","34","Saahe davu nivaane lôôt vu sate hil sen dando Ijip-ato, de sa hango silate susin lung la, om saalukalaam in saambu vêêl sil in nimeen-anju, om saambe gana Ijip.’ ");
INSERT INTO mmo_vpl VALUES ("AC7_35","074_7_35","ACT","7","35","35","“Mosêê-jo ond bôôy sil mahôôh yi nambe, ‘Lati hatung hong in nambe onaatu yêêv-ambe ongganggin hey?’ Ond omaahôô-ju Anutu wiing angela la hato vu yi hôôk haah aniyin alôô-to, tombe angela wiing-ambe la lohvu yêêv bop osin omaaho sen dôôvu hil-ato. ");
INSERT INTO mmo_vpl VALUES ("AC7_36","074_7_36","ACT","7","36","36","+ o 7:36 Eks 7:3; 14:21; Nam 14:33*Mose giiy sil-ambe lala de wiing taahu taahu bopaata osin niwêêk vaha vaha vu Ijip de vu Lôôy Hees, tonde vu taaku lumbalaamb lohvu ta doo-yuuh. ");
INSERT INTO mmo_vpl VALUES ("AC7_37","074_7_37","ACT","7","37","37","+ o 7:37 Sin 3:22*Mosêê-ju ond yik nêêl vu hil Islel nambe, ‘Anutu yoo le golin ham o halim-aso ti naatu hamate omaaho ti in naanêêl Anutu-te vakasin langaah naambe sen holin saa-to.’ ");
INSERT INTO mmo_vpl VALUES ("AC7_38","074_7_38","ACT","7","38","38","+ o 7:38 Eks 19:3; Diu 5:5; 9:10; Sin 7:53*Mosêê-ju ond yik nando having hil Islel vu taaku lumbalaamb. Nando having yate himbop-aso bôôy de angela sen nêêl vakasin vu yi vu kandu Sinaii-to, ond hako Anutu-te vakasin metumin-ate be vu vu yiiy. ");
INSERT INTO mmo_vpl VALUES ("AC7_39","074_7_39","ACT","7","39","39","+ o 7:39 Nam 14:3*Lemu yate himbop-aso bôôy nind baya nambe sil-ame gango lava le, malis. Sil kalêêh lava de lahilin londpayo laah vu Ijip, ");
INSERT INTO mmo_vpl VALUES ("AC7_40","074_7_40","ACT","7","40","40","+ o 7:40-41 Eks 32:1-6,23*de lanêêl vu Aalon nambe, ‘Osamu heyate anutu heey in daanggiiy hey, in Mose sen giiy hey vu Ijip-ambe hey alaam-anjôôto, ond hey doosin mak vaati wiing.’ ");
INSERT INTO mmo_vpl VALUES ("AC7_41","074_7_41","ACT","7","41","41","Om lanêêl atombe sil samu kao noow ti kanu, be latung salivangin osin lapêêlis vu silate anutu tatuhin vaha sen sil oo samu lak namand-anjuuto. ");
INSERT INTO mmo_vpl VALUES ("AC7_42","074_7_42","ACT","7","42","42","+ o 7:42 Jer 19:13; Emo 5:25-27*Tombe Anutu haluuh dami vu sil, de hilin sil alondpayo la vu taaku mekaalus ayuuh kwaav-ande matam-ambe mondalohak vu, lohvu Anutu-te vakasin sen hil lanêêl langaah bôôy-ambe neep hôôk kaapiya nambe, ‘Ham Islel, vu bôôy ham nando taaku lumbalaamb lohvu ta doo-yuuh, de ham ayiis kao osin bik sipsip-ambe ham hatung salivangin. Mak ham awiing vaa-ju vu sa? Malis. ");
INSERT INTO mmo_vpl VALUES ("AC7_43","074_7_43","ACT","7","43","43","De anutu tatuhin vaha sen haale nambe Molok-ato ond ham vaaku yite dumb sel having anutu tatuhin vaha Lepan-ate matam kanu be va kanuu-ju ham samu be ham alohak vu, om sale gakoseey ham ana mando dinaandiin na Babilon vaalu.’ ");
INSERT INTO mmo_vpl VALUES ("AC7_44","074_7_44","ACT","7","44","44","+ o 7:44 Eks 25:40*“De Anutu-te dumb sel sen nando hôôk yate himbop-aso lavuun bôôy vu taaku lumbalaamb-ato, ond taato nambe Anutu nando having sil. Dumb-anjo Anutu nêêl vu Mose, tombe yik sil samu lohvu sen Mose yi kanuu-to. ");
INSERT INTO mmo_vpl VALUES ("AC7_45","074_7_45","ACT","7","45","45","+ o 7:45 Jos 3:14-17; 18:1; 23:9*Dumb sel-anju yate himbop-aso vu taamusin lako lak-ambe lala having Yosua be lala lako hil bamaan-ate taaku, de Anutu hatiiy hil bamaan-anju lala vêêl in sil, de latung dumb sel-anju nando be tok laam Devit-ate busin having. ");
INSERT INTO mmo_vpl VALUES ("AC7_46","074_7_46","ACT","7","46","46","+ o 7:46 2Sml 7:1-16; Saam 132:1-5*Tombe Anutu yi Devit anivasa, om Devit kataangg Anutu in nambe jiinggis e mem le daav bayêên ti vu Yaakop-ate Anutuu-ju, ");
INSERT INTO mmo_vpl VALUES ("AC7_47","074_7_47","ACT","7","47","47","+ o 7:47 1King 6:1,14*le ma de Solomon haav. ");
INSERT INTO mmo_vpl VALUES ("AC7_48","074_7_48","ACT","7","48","48","“Lemu Anutu baandoni me-nando hôôk bayêên sen omaahonôôn dahaav ak namand-ato le, lohvu omaaho ti nêêl Anutu-te vakasin langaah nambe, ");
INSERT INTO mmo_vpl VALUES ("AC7_49","074_7_49","ACT","7","49","49","+ o 7:49-50 Ais 66:1-2*‘Omaaho Bop nêêl nambe, “Baandoni ond sate sia, de ngaanggis ond sa vahangg-ate in jambaale. Ham awiingin nambe andaav bayêên nambe vaati vu sa? De sa baangg sen sa sawaah-ato nando tana? ");
INSERT INTO mmo_vpl VALUES ("AC7_50","074_7_50","ACT","7","50","50","Mak sa namangg-ame yoo samu va pin-anja le?” ’ ");
INSERT INTO mmo_vpl VALUES ("AC7_51","074_7_51","ACT","7","51","51","+ o 7:51 Eks 32:9; Jer 9:26; Ais 63:10*“Ham alumkook aniwêêk, de ham alompayo mekanu osin ham nanyem doos. Ham oo monatiiy Vavi Vaambuung nalak busin pin, om ham alohvu hamate himbop-aso bôôy. ");
INSERT INTO mmo_vpl VALUES ("AC7_52","074_7_52","ACT","7","52","52","+ o 7:52 2Kro 36:16; Mat 23:31*Hil sen danêêl Anutu-te vakasin langaah-ato ond ti tana nando bôôy-ambe hamate himbop-aso me-lawiing nindanjeen vu le? Malis. Hil sen danêêl vakasin langaah nambe Omaaho Nivalok e naam-ato ond hamate himbop-aso bôôy layiis sil-ambe layimb, om gêên ham oo anêêl yi langaah vu hil-ambe layiis-ambe yimb. ");
INSERT INTO mmo_vpl VALUES ("AC7_53","074_7_53","ACT","7","53","53","+ o 7:53 Sin 7:38; Gal 3:19; Hiblu 2:2*De ham-anjo ham hako tanasin vu angela-so, le ma de ham-ame samu le.” ");
INSERT INTO mmo_vpl VALUES ("AC7_54","074_7_54","ACT","7","54","54","+ o 7:54 Sin 5:33*Lango vakasin-anju be kund sil alondpayo, tombe sil langa navund vu Stiven. ");
INSERT INTO mmo_vpl VALUES ("AC7_55","074_7_55","ACT","7","55","55","+ o 7:55 Mat 22:44; Sin 2:33-34; 5:31*Le Vavi Vaambuung hôôvu Stiven om valaah me lak baandoni, tombe yi Anutu-te nikaapulis osin yi Yesu naale Anutu nama vasa. ");
INSERT INTO mmo_vpl VALUES ("AC7_56","074_7_56","ACT","7","56","56","+ o 7:56 Kol 3:1*Tombe Stiven nêêl nambe, “Ham hil-e, saahe baandoni hataahin-ande Omaahonôôn Noow naale Anutu nama vasa.” ");
INSERT INTO mmo_vpl VALUES ("AC7_57","074_7_57","ACT","7","57","57","Tombe lawiing lavand bopaata lôôt osin sil lavu jeen sil nanyend, de sil pavis-ambe lambuuh Stiven tatup, ");
INSERT INTO mmo_vpl VALUES ("AC7_58","074_7_58","ACT","7","58","58","+ o 7:58 Sin 22:20*de lakôôh-ambe la taaku nanyendangga in nambe lanyiis ak tatuuh-ambe jimb. De hil sen tatuhin vakasin lak yii-to, ond lakaah silate lolop-ambe lala latung hôôk maanggêêm ti haale nambe Saul vaha. ");
INSERT INTO mmo_vpl VALUES ("AC7_59","074_7_59","ACT","7","59","59","+ o 7:59 Saam 31:5; Luk 23:46*Tonde sil tanga Stiven lak tatuuh lôôt, de Stiven kataangg nambe, “Omaaho Bop Yesu, onggako sa kanungg naas.” ");
INSERT INTO mmo_vpl VALUES ("AC7_60","074_7_60","ACT","7","60","60","+ o 7:60 Luk 23:34*Tonde hatung kaatu be nêêl bopaata lôôt nambe, “Omaaho Bop, game gambu hôôk silate nipaya nyevahaan e.” Nêêl nambêênju tonde yimb la. ");
INSERT INTO mmo_vpl VALUES ("AC8_1","074_8_1","ACT","8","1","1","+ o 8:1 Sin 7:58; 8:4; 11:19*Saul yi nivasa in layiis Stiven-ambe yimb. Tombe hôôk busin-anju hil mondawiing nindanjeen vu hil bel-ate sen dando Yelusalem-ato, om hil bel pin lapak-ambe lavuuh taale lohvu Yudia osin Samaalia-te taaku pin, de sinaale-so yoo daahen dando Yelusalem. ");
INSERT INTO mmo_vpl VALUES ("AC8_2","074_8_2","ACT","8","2","2","Hil anivasa vaalu sen kand navu sapa Anutuu-to ond lahaav Stiven-ande lasu bopaata lak yi, ");
INSERT INTO mmo_vpl VALUES ("AC8_3","074_8_3","ACT","8","3","3","+ o 8:3 Sin 9:1,13; 22:4; 26:9-11*tonde Saul monawiing nindanjeen vu hil bel-ate pin. Nalukala bayêên alo pin-ambe naandiiy moow ayuuh vêêh danjeen-ambe la natung sil hôôk kalaambus. ");
INSERT INTO mmo_vpl VALUES ("AC8_4","074_8_4","ACT","8","4","4","Hil pin sen lapak-ambe lavuuh taalêê-to ond latup hôôk-ambe lanêêl banye nivasa langaah. ");
INSERT INTO mmo_vpl VALUES ("AC8_5","074_8_5","ACT","8","5","5","+ o 8:5 Sin 6:5*Tombe Pilip la hato Samaalia-te taaku ti be nêêl Kalisi haale langaah vu sil. ");
INSERT INTO mmo_vpl VALUES ("AC8_6","074_8_6","ACT","8","6","6","Tombe hil ngeeyaata lôôt lango Pilip-ate vakasin, de layi taahu taahu niwêêk vaha vaha sen wiing-ato, be lawii-having yite vakasin osin londpayo timu. ");
INSERT INTO mmo_vpl VALUES ("AC8_7","074_8_7","ACT","8","7","7","+ o 8:7 Mat 10:1; Mak 16:17*Tonde hil ngeeyaata sen mamu nipaya nahôôvu sil-ato, ond mamuu-ju dawiing lavand bopaata be lato dala, de hil ngeeyaata sen kook navu tasiis osin vahand anipayaa-to sil anind vasa nahôôk laah, ");
INSERT INTO mmo_vpl VALUES ("AC8_8","074_8_8","ACT","8","8","8","tombe hil sen dando taakuu-juuto londpayo nivasa lôôt. ");
INSERT INTO mmo_vpl VALUES ("AC8_9","074_8_9","ACT","8","9","9","De omaaho lôômb ti nando taaku Samaalia haale nambe Simon, ond yoo nako yi lak nambe yi omaaho bopaata. Tombe hil pin lavindis in yite kul, ");
INSERT INTO mmo_vpl VALUES ("AC8_10","074_8_10","ACT","8","10","10","hil malis osin hil yêêv pin lawii-having Simon-ate vakasin-ambe lanêêl nambe, “Omaahôô-jo Anutu-te niwêêk, danêêl nambe niwêêk bopaata.” ");
INSERT INTO mmo_vpl VALUES ("AC8_11","074_8_11","ACT","8","11","11","Ond lavindis in yite kul mamu lôômb sen yoo nawiing boyambôôy-ato ondeey lawii-having lava. ");
INSERT INTO mmo_vpl VALUES ("AC8_12","074_8_12","ACT","8","12","12","Lemu Pilip nêêl va sen Anutu nanggin yite hil-ato osin Yesu Kalisi banye langaah vu sil, tombe moow ayuuh vêêh lawii-having-ambe lalipis bel. ");
INSERT INTO mmo_vpl VALUES ("AC8_13","074_8_13","ACT","8","13","13","Tonde yik Simon wii-having-ambe lipis bel lung la le mem taamuyin Pilip. Om Simon yi de Pilip wiing taahu taahu vaha vaha osin niwêêk bopaata, tombe vindis lôôt. ");
INSERT INTO mmo_vpl VALUES ("AC8_14","074_8_14","ACT","8","14","14","De sinaale-so vu Yelusalem ond lango banye nambe hil Samaalia lako Anutu-te tanasin ak, om lawiing Pita yuuh Jon lala vu sil. ");
INSERT INTO mmo_vpl VALUES ("AC8_15","074_8_15","ACT","8","15","15","Yuuh latok lala be yuuh lalohak in hil-anju nambe Vavi Vaambuung jakana sil, ");
INSERT INTO mmo_vpl VALUES ("AC8_16","074_8_16","ACT","8","16","16","in Vavi Vaambuung-ame lakala sil e, de lalipis bel lak Omaaho Bop Yesu haale mu. ");
INSERT INTO mmo_vpl VALUES ("AC8_17","074_8_17","ACT","8","17","17","+ o 8:17 Sin 19:6*Om sinaale yuuh lambe namand ak sil atombe mem Vavi Vaambuung lakala sil. ");
INSERT INTO mmo_vpl VALUES ("AC8_18","074_8_18","ACT","8","18","18","Tombe Simon yi de sinaale yuuh lambe namand ak sil-ambe Vavi Vaambuung lakala sil, om hako mone be la vu yuuh ");
INSERT INTO mmo_vpl VALUES ("AC8_19","074_8_19","ACT","8","19","19","be nêêl nambe, “Mambu va niwêêk-anja vu sa gaving in naambe sa gambe namangg jak hil ond Vavi Vaambuung jakana sil.” ");
INSERT INTO mmo_vpl VALUES ("AC8_20","074_8_20","ACT","8","20","20","Le Pita nêêl vu nambe, “Gambe ombaanggo Anutu-te samu samuu-jo jak mone, om gana menama osin gate mone. ");
INSERT INTO mmo_vpl VALUES ("AC8_21","074_8_21","ACT","8","21","21","+ o 8:21 Saam 78:37*Vaa-jo game gate va le, malis lôôt. Anutu yi nambe galompayo me-nivalok e, ");
INSERT INTO mmo_vpl VALUES ("AC8_22","074_8_22","ACT","8","22","22","om ganggilin galompayo de onggaluuh damim vu gate va nipaya, de okataangg vu Omaaho Bop in kawiiy va sen galompayo yoo wiingin-ato na. ");
INSERT INTO mmo_vpl VALUES ("AC8_23","074_8_23","ACT","8","23","23","+ o 8:23 Hiblu 12:15*Saahe de galompayo nikalin lôôt de gate va nipaya duuh hong tatin.” ");
INSERT INTO mmo_vpl VALUES ("AC8_24","074_8_24","ACT","8","24","24","Tombe Simon nêêl laah nambe, “Manohak na vu Omaaho Bop naambe va sen manêêl-anjaato me-naatovu sa le.” ");
INSERT INTO mmo_vpl VALUES ("AC8_25","074_8_25","ACT","8","25","25","Sinaale yuuh lanêêl Omaaho Bop-ate vakasin langaah lung la, tonde yuuh lala in nambe lanaah Yelusalem, tombe sim yuuh lanêêl banye nivasa langaah vu Samaalia-te taaku ngeeyaata vu mopaatôôv. ");
INSERT INTO mmo_vpl VALUES ("AC8_26","074_8_26","ACT","8","26","26","Omaaho Bop-ate angela ti nêêl vu Pilip nambe, “Okandi lak-ambe gana gato mop lavuun sen vu Yelusalem-ambe la hato Gasaa-to.” Mopaatôôv-anju ond taaku lumbalaamb. ");
INSERT INTO mmo_vpl VALUES ("AC8_27","074_8_27","ACT","8","27","27","+ o 8:27 Ais 56:3-7*Om Pilip kandi lak-ambe la, tombe yi de Itiopia ti hato, ond hil Itiopia-te kwin Kandesi yite yêêv bop sen nanggin yite kupak pin-ato, ond la lohak vu Yelusalem lung la, ");
INSERT INTO mmo_vpl VALUES ("AC8_28","074_8_28","ACT","8","28","28","tonde hato laah in na, tombe monasevin omaaho sen nanêêl Anutu-te vakasin langaah-ato Yesaia-te vakasin lakando pêêt sen hôôs naandiiy-ato. ");
INSERT INTO mmo_vpl VALUES ("AC8_29","074_8_29","ACT","8","29","29","Om Vavi Vaambuung nêêl vu Pilip nambe, “Gana ngaaho vu omaahôô-ju be mana.” ");
INSERT INTO mmo_vpl VALUES ("AC8_30","074_8_30","ACT","8","30","30","Tombe Pilip hatup-ambe la ngaaho vu, le hango de nasevin Yesaia-te vakasin, om lingin nambe, “Vakasin sen onasevin-anja, ond galak danggakook ani me malis?” ");
INSERT INTO mmo_vpl VALUES ("AC8_31","074_8_31","ACT","8","31","31","+ o 8:31 Jon 16:13*Le omaahôô-ju nêêl laah vu nambe, “Sa jak ni in lati naanêêl vu sa? Omaaho ti naanêêl tatekin vu sa ond mem.” Om nêêl nambe Pilip jakana mando gaving yi. ");
INSERT INTO mmo_vpl VALUES ("AC8_32","074_8_32","ACT","8","32","32","+ o 8:32 Ais 53:7-8*Ke, omaahôô-ju nasevin Anutu-te vakasin boow ti neep hôôk kaapiya nambe, “Langgiiy yi be lala lohvu bik sipsip sen davu lanyiis-ambe jimb-ato, de lohvu bik sipsip noow sen daving nivalus-ande me-nasuu-to, ond omaahôô-ju me-vakaas e. ");
INSERT INTO mmo_vpl VALUES ("AC8_33","074_8_33","ACT","8","33","33","Tombe laanggôôl yi lôôt de me-lanêêl vakasin anivasa ti lak yi le. De yite hil moos dando tana in nambe yiiy naanêêl sil langaah? Malis, in havuuh ngaanggis voon-anjo de la.” ");
INSERT INTO mmo_vpl VALUES ("AC8_34","074_8_34","ACT","8","34","34","Tombe yêêv tii-jôôto lingin Pilip nambe, “Otatekin vu sa le, naambe Yesaia nêêl vakasin-anjo ond yoo nêêl lak yi me nêêl lak omaaho ango?” ");
INSERT INTO mmo_vpl VALUES ("AC8_35","074_8_35","ACT","8","35","35","Om Pilip nêêl vakasin-anju be tatekin Yesu-te banye nivasa langaah vu yi, ");
INSERT INTO mmo_vpl VALUES ("AC8_36","074_8_36","ACT","8","36","36","+ o 8:36 Sin 10:47*de yuuh mondala be lala lato bel ti, tombe yêêv tii-jôôto nêêl nambe, “Angge, bel neep-anjo. Lohvu nambe ganjipis sa pavis me malis?” ");
INSERT INTO mmo_vpl VALUES ("AC8_37","074_8_37","ACT","8","37","37","Tombe Pilip nêêl vu nambe, “Galompayo wii-having keen lôôt ond hoow-o.” Le nêêl laah vu nambe, “Saawii-having nambe Yesu Kalisi yi Anutu Noow.” ");
INSERT INTO mmo_vpl VALUES ("AC8_38","074_8_38","ACT","8","38","38","Tonde nêêl vu yite omaaho sen nando having yii-to be puvu hees tatin-ande hôôs naale, tonde yuuh Pilip laluus-ambe lalukala daale hôôk bel, tombe mem Pilip lipis yi. ");
INSERT INTO mmo_vpl VALUES ("AC8_39","074_8_39","ACT","8","39","39","+ o 8:39 1King 18:12*Tonde yuuh vu belalu be lalakalaah atombe Omaaho Bop-ate Vavi Vaambuung vu vêêl Pilip la pavis, de yêêv-anjôôto me-yi Pilip yesin laah e, om la osin lopayo nivasa lôôt. ");
INSERT INTO mmo_vpl VALUES ("AC8_40","074_8_40","ACT","8","40","40","+ o 8:40 Sin 21:8*Tonde Pilip yi nambe la hato Asdot, tombe nêêl banye nivasa langaah lohvu taaku pin-ambe tok la Sisalia. ");
INSERT INTO mmo_vpl VALUES ("AC9_1","074_9_1","ACT","9","1","1","+ o 9:1 Sin 8:3*Saul nêêl niwêêk lôôt nambe biing nindanjeen vu Omaaho Bop-ate hil de nyiis sil-ambe lanjimb, om la vu kul vaha sen datung salivangin-ato silate yêêv bop, ");
INSERT INTO mmo_vpl VALUES ("AC9_2","074_9_2","ACT","9","2","2","be nêêl vu nambe kaavu kaapiya na nohvu hil Yuda-te dumb ti ti vu Damaskas naambe, “Saul naatovu moow ayuuh vêêh sen lawii-having Yesu-te tanasin-ato, ond talu sil-ambe gako na Yelusalem.” ");
INSERT INTO mmo_vpl VALUES ("AC9_3","074_9_3","ACT","9","3","3","Om Saul monala be la valup ngaaho vu Damaskas, tombe sim pavis atombe kin ti tum vu baandoni be têêlang ak yi, ");
INSERT INTO mmo_vpl VALUES ("AC9_4","074_9_4","ACT","9","4","4","tombe Saul lupake be la neep voon, tonde hango lava ti laam vu yi nambe, “Saul, nambe vaati sen goo monawiing nindanjeen vu saa-jo?” ");
INSERT INTO mmo_vpl VALUES ("AC9_5","074_9_5","ACT","9","5","5","+ o 9:5 Sin 5:39; 1Ko 15:8*Tombe Saul lingin nambe, “Omaaho Bop, olati?” Le nêêl nambe, “Sa Yesu sen goo monawiing nindanjeen vu saa-jo. ");
INSERT INTO mmo_vpl VALUES ("AC9_6","074_9_6","ACT","9","6","6","Om okandi be gana bayêên e mem le daanêêl va sen gambiing-ato langaah vu hong.” ");
INSERT INTO mmo_vpl VALUES ("AC9_7","074_9_7","ACT","9","7","7","Hil sen laving Saul-ato, ond lango lavaa-ju lemu me-layi omaaho ti le, om lavand ma de yoo daale. ");
INSERT INTO mmo_vpl VALUES ("AC9_8","074_9_8","ACT","9","8","8","Tombe Saul kandi naale le ma de mekanu hôôk lôôt, om sil laliv namand hôôk-ambe lala Damaskas, ");
INSERT INTO mmo_vpl VALUES ("AC9_9","074_9_9","ACT","9","9","9","tombe nandôô-ju lohvu busin yaal osin mekanu, de me-ya vanôôn ayuuh me-num bel e. ");
INSERT INTO mmo_vpl VALUES ("AC9_10","074_9_10","ACT","9","10","10","Tonde Yesu-te omaaho ti nando Damaskas haale nambe Ananaias, ond nando le yi taahu taahu ti, de Omaaho Bop nêêl vu nambe, “Ananaias.” Tombe liinggis nambe, “Omaaho Bop, saa-jo.” ");
INSERT INTO mmo_vpl VALUES ("AC9_11","074_9_11","ACT","9","11","11","+ o 9:11 Sin 21:39*Tombe Omaaho Bop nêêl vu nambe, “Okandi jak-ambe gana mopaatôôv sen danêêl nambe Nivalok-ato, tombe onaatovu hil Taasas ti haale nambe Saul, ond monalohak nando hôôk Yudas-ate bayêên, ");
INSERT INTO mmo_vpl VALUES ("AC9_12","074_9_12","ACT","9","12","12","de yi taahu taahu ti de omaaho ti haale nambe Ananaias lukalaam umakalo be hambe nama lak yi in nambe me naatum naah.” ");
INSERT INTO mmo_vpl VALUES ("AC9_13","074_9_13","ACT","9","13","13","+ o 9:13 Sin 8:3*Le Ananaias nêêl nambe, “Omaaho Bop, sa hango de hil ngeeyaata danêêl nambe omaahôô-ju nawiing nindanjeen lôôt vu gate hil vu Yelusalem, ");
INSERT INTO mmo_vpl VALUES ("AC9_14","074_9_14","ACT","9","14","14","+ o 9:14 Sin 9:1-2,21; 1Ko 1:2*tonde yêêv-aso salivangin-ate lanêêl lung la nambe yoo talu hil pin sen lavand nahôôk ohaalem vuu-jôôto.” ");
INSERT INTO mmo_vpl VALUES ("AC9_15","074_9_15","ACT","9","15","15","+ o 9:15 Sin 25:13,23; 27:24; Lom 1:5*Lemu Omaaho Bop nêêl vu nambe, “Gana. Saaholin yi be tu sate hil kul vaha lung la in gako sa haalengg na vu omaahonôôn pin, de vu lulemak-aso osin hil Islel gaving. ");
INSERT INTO mmo_vpl VALUES ("AC9_16","074_9_16","ACT","9","16","16","+ o 9:16 2Ko 11:23-28*De nimeen pin sen naatovu yi jak sa haalengg-ato ond soo le naanêêl taato vu yi.” ");
INSERT INTO mmo_vpl VALUES ("AC9_17","074_9_17","ACT","9","17","17","Om Ananaias kandi be la hato lukala bayêên alo, tombe hambe nama lak Saul de nêêl vu nambe, “Hali Saul-e, Omaaho Bop Yesu sen taato yi langaah vu hong vu mop lavuun-ato, ond nêêl-ambe sa laam in nambe gamem naatum naah, de Vavi Vaambuung e naam dôôvu hong.” ");
INSERT INTO mmo_vpl VALUES ("AC9_18","074_9_18","ACT","9","18","18","Om pavis atombe va sen nando hôôk Saul amêê-to lumbin nambe paahuung anikapis-ato, tonde Saul ame tum laah, tombe kandi lak-ambe lipis bel lak Yesu haale, ");
INSERT INTO mmo_vpl VALUES ("AC9_19","074_9_19","ACT","9","19","19","de ya vanôôn-ambe sake lukalaah. Saul nando having Yesu-te hil vu Damaskas-anju busin heey, ");
INSERT INTO mmo_vpl VALUES ("AC9_20","074_9_20","ACT","9","20","20","ond pavis-ambe nêêl Yesu-te banye nivasa langaah hatup hôôk hil Yuda-te dumb ti ti nambe, “Yesuu-ju ond Anutu Noow yi.” ");
INSERT INTO mmo_vpl VALUES ("AC9_21","074_9_21","ACT","9","21","21","+ o 9:21 Sin 8:3; 26:10*Tombe hil vaalu sen lango yite vakasin-anjuuto sil pin lavindis lôôt, de lanêêl nambe, “Ayêê, omaahôô-ja nayiis hil sen lavand nahôôk Yesu haale vu Yelusalem-ato, ond laam in naanduuh hil vuu-jo de gako sil lana vu yêêv-aso salivangin-ate, le mak nambe vaatii-jo?” ");
INSERT INTO mmo_vpl VALUES ("AC9_22","074_9_22","ACT","9","22","22","+ o 9:22 Sin 17:3; 18:5,28*Lemu Saul-ate niwêêk tu bopaata lak, om nêêl taato vu sil nambe Yesuu-ju yi omaaho sen Anutu yoo holin yi vulôôt-ato keen, tombe hil Yuda sen dando Damaskas-ato lango yite vakasin-anju, tombe silanêênd vakasin sen daanêêl naah vuu-to ma. ");
INSERT INTO mmo_vpl VALUES ("AC9_23","074_9_23","ACT","9","23","23","+ o 9:23 Sin 23:12*Tombe busin ngeeyaata la lung la, le mem hil Yuda lasupin-ambe lanjôôy vakasin nambe lanyiis Saul-ambe jimb. ");
INSERT INTO mmo_vpl VALUES ("AC9_24","074_9_24","ACT","9","24","24","Saul hango silate vakasin-anju banye nambe hil Yuda dambuuh mop avi lohvu taaku pin hôôk busin-ande langaah in nambe lanyiis-ambe jimb, ");
INSERT INTO mmo_vpl VALUES ("AC9_25","074_9_25","ACT","9","25","25","+ o 9:25 2Ko 11:32-33*om Saul-ate hil sen dando having yii-to lako yi hôôk busin-ambe lalakala kaatum alu baandoni, tombe latung lukala nando hôôk jaambang bopaata ti, le mem sil taaluuhin yi la voon-ambe la. ");
INSERT INTO mmo_vpl VALUES ("AC9_26","074_9_26","ACT","9","26","26","+ o 9:26 Gal 1:17-19*Saul la hato Yelusalem-ambe wiingin nambe na mando gaving Yesu-te hil, le sil pin layêênin Saul lôôt in me-lawii-having nambe Yesu-te omaaho yi le. ");
INSERT INTO mmo_vpl VALUES ("AC9_27","074_9_27","ACT","9","27","27","+ o 9:27 Sin 9:4,20; 1Ko 9:1; 15:8*Lemu Banabas giiy-ambe yuuh lala vu sinaale-so, de hatulin vakasin sen Saul yi Omaaho Bop vu mop lavuun-ambe Omaaho Bop vakaas vu yii-to, osin nêêl vakasin sen Saul nêêl Yesu haale langaah vu hil vu Damaskas-ande me-yêênin-ato le. ");
INSERT INTO mmo_vpl VALUES ("AC9_28","074_9_28","ACT","9","28","28","Saul nando having sil vu Yelusalem, ond yoo nêêl tanasin lak Omaaho Bop haale niwêêk lôôt de me-yêênin e. ");
INSERT INTO mmo_vpl VALUES ("AC9_29","074_9_29","ACT","9","29","29","Tonde having Yuda vaalu sen dakaas Glik lavand-ato, ond sil papenggin sil in tanasin, tombe sim hil-anju lawiingin nambe lanyiis Saul-ambe jimb. ");
INSERT INTO mmo_vpl VALUES ("AC9_30","074_9_30","ACT","9","30","30","+ o 9:30 Sin 11:25; Gal 1:21*Le sim Omaaho Bop-ate hil langoyin banye tombe langgiiy Saul-ambe lala Sisalia, le mem lawiing yi vuu-ju be la Taasas. ");
INSERT INTO mmo_vpl VALUES ("AC9_31","074_9_31","ACT","9","31","31","Tombe mem hil bel-ate vu Yudia yuuh Galili, de taaku Samaalia pin, dando nivasa de ngaamong ayuuh ame ma. Layêênin sil vu Omaaho Bop de Vavi Vaambuung vu niwêêk vu sil, tombe mem hil bel-ate latu ngeeyaata lak lôôt. ");
INSERT INTO mmo_vpl VALUES ("AC9_32","074_9_32","ACT","9","32","32","Pita monatup hôôk lohvu taaku pin-ambe la hato vu Omaaho Bop-ate hil sen dando Lidaa-to, ");
INSERT INTO mmo_vpl VALUES ("AC9_33","074_9_33","ACT","9","33","33","tombe sim tovu omaaho ti haale nambe Inias vuu-ju, ond kook tasiis-ande yoo neep hôôk bayêên alo lohvu ta namaavaalu be vindak yaal lung la. ");
INSERT INTO mmo_vpl VALUES ("AC9_34","074_9_34","ACT","9","34","34","Tombe Pita nêêl vu nambe, “Inias, gêên Yesu Kalisi wiing-ambe ganim vasa lak, om okandi jak-ambe goo gatongin gate kaanye.” Tombe kandi lak pavi-vasa. ");
INSERT INTO mmo_vpl VALUES ("AC9_35","074_9_35","ACT","9","35","35","Tombe hil Lida osin hil vu Salon pin layi be lahilin londpayo la vu Omaaho Bop. ");
INSERT INTO mmo_vpl VALUES ("AC9_36","074_9_36","ACT","9","36","36","Vêêh ti wii-having Yesu nando Jopa haale nambe Tabita, Glik lavand nambe Dokas, ond lak busin pin yoo navu samu hil, de nahôôvu hil sen dativak in va yuuh amêê-to. ");
INSERT INTO mmo_vpl VALUES ("AC9_37","074_9_37","ACT","9","37","37","Tombe sim busin ti tombe nilak-ambe yimb, om lalipis ninaavi de lambe lakala neep ak bayêên alo ango baandonii-to. ");
INSERT INTO mmo_vpl VALUES ("AC9_38","074_9_38","ACT","9","38","38","Tonde Yesu-te hil langoyin nambe Pita nando Lida sen neep ngaaho vu taaku Jopaa-to, om lawiing omaaho yuuh lala vu be yuuh kataangg yi nambe, “Ganaam pavis vu hey e.” ");
INSERT INTO mmo_vpl VALUES ("AC9_39","074_9_39","ACT","9","39","39","Om Pita kandi lak-ambe la having yuuh. La hato tombe lako yi be lalakala bayêên alo baandoni, tombe vehaahôôv-aso pin lako lolop ayuuh ame sen Dokas nando having sil bôôy-ambe duuh-ato, ond sil taato vu Pita de lasu lak yi. ");
INSERT INTO mmo_vpl VALUES ("AC9_40","074_9_40","ACT","9","40","40","+ o 9:40 Mak 5:40-41*Tombe Pita hatiiy hil pin lala voon, de hatung kaatu be lohak, tonde hilin laah vu omaahonôôn yimbin-ato be nêêl nambe, “Tabita, okandi.” Tombe vêêh-anjuuto me tum-ambe yi Pita de kandi nando, ");
INSERT INTO mmo_vpl VALUES ("AC9_41","074_9_41","ACT","9","41","41","tombe Pita laandiiy hôôk nama be kandi naale, de teey vehaahôôv-aso osin Omaaho Bop-ate hil pin lalaam-ambe taato vu sil nambe Dokas ame tum laah. ");
INSERT INTO mmo_vpl VALUES ("AC9_42","074_9_42","ACT","9","42","42","Tombe hil Jopa pin lango vakasin-anjôôto banye, om hil ngeeyaata lawii-having Omaaho Bop. ");
INSERT INTO mmo_vpl VALUES ("AC9_43","074_9_43","ACT","9","43","43","+ o 9:43 Sin 10:6*Tonde Pita nando Jopa busin ngeeyaata having omaaho ti haale nambe Simon sen nawiing kul bik naavii-to. ");
INSERT INTO mmo_vpl VALUES ("AC10_1","074_10_1","ACT","10","1","1","+ o 10:1 Mat 8:5; Sin 27:1,3*Hil Lom ti nando Sisalia haale nambe Konilias, ond tu hil ngaamong vaha doo-nomaayuuh-ate yêêv sen danêêl sil nambe Itaalii-to. ");
INSERT INTO mmo_vpl VALUES ("AC10_2","074_10_2","ACT","10","2","2","Ond omaahôô-ju having yite hil-ambe dayêênin Anutu, tonde yoo ka navu Anutu be nalohak lak busin pin, de nahôôvu hil Yuda sen dativak in va yuuh amêê-to. ");
INSERT INTO mmo_vpl VALUES ("AC10_3","074_10_3","ACT","10","3","3","+ o 10:3 Sin 3:1*Tombe busin ti hôôk taaku me yaal, ond omaahôô-ju nando le yi taahu taahu ti, de Anutu-te angela ti lukalaam-ambe taato yi langaah, be nêêl vu nambe, “Konilias.” ");
INSERT INTO mmo_vpl VALUES ("AC10_4","074_10_4","ACT","10","4","4","Tombe Konilias yi be yêênin lôôt tombe nêêl nambe, “Omaaho Bop, nambe vaati?” Tombe angela nêêl nambe, “Gate lohakin osin samu samu sen onahôôvu hil sen dativak in va yuuh amêê-to, ond vaa-ju banye tok laam-ambe Anutu ka navu nando. ");
INSERT INTO mmo_vpl VALUES ("AC10_5","074_10_5","ACT","10","5","5","Om peey gambiing-ambe hil lana gako omaaho ti haale nambe Simon, de haale ango nambe Pita, vu Jopa be naam. ");
INSERT INTO mmo_vpl VALUES ("AC10_6","074_10_6","ACT","10","6","6","+ o 10:6 Sin 9:43*Omaahôô-ju la nando having lengo Simon sen nawiing kul bik naavii-to, ond yite bayêên nando ngaaho vu lôôy nanyendangga.” ");
INSERT INTO mmo_vpl VALUES ("AC10_7","074_10_7","ACT","10","7","7","Angela nêêl vakasin vu Konilias lung la de la, le mem Konilias teey yite kul vaha yuuh laving hil ngaamong vaha ti sen yoo ka navu Anutu be nando having Konilias lak busin pin-ato, ");
INSERT INTO mmo_vpl VALUES ("AC10_8","074_10_8","ACT","10","8","8","tombe Konilias nêêl vakasin-anju tatekin vu yaal lung la le mem wiing yaal lala Jopa. ");
INSERT INTO mmo_vpl VALUES ("AC10_9","074_10_9","ACT","10","9","9","Tombe omaaho yaal-anjuuto mondala be lala deep mop lavuun, de langaah ak e mem yaal lala be latok lala bayêên Jopa. De taaku me laam naale lavuun, tombe Pita lakala bayêên alu baandoni in nohak. ");
INSERT INTO mmo_vpl VALUES ("AC10_10","074_10_10","ACT","10","10","10","Tombe yimb ahe be wiingin nambe ja vanôôn, le daahen dayêêh yite vanôôn, tonde sim Pita yi taahu taahu ti, ");
INSERT INTO mmo_vpl VALUES ("AC10_11","074_10_11","ACT","10","11","11","+ o 10:11 Sin 11:5-17*ond yi de baandoni hataahin-ande vati nambe sen tôômb bopaata ti luus-ambe nalaam, ond landuuh hôôk nanyendangga yumbeyuuh de sil taaluuhin-ambe nalaam voon, ");
INSERT INTO mmo_vpl VALUES ("AC10_12","074_10_12","ACT","10","12","12","tombe vahivak vaha vaha sen naale nala de nahaavak osin manak pin nando hôôk tôômb-anju lopayo. ");
INSERT INTO mmo_vpl VALUES ("AC10_13","074_10_13","ACT","10","13","13","Tombe lava ti laam nambe, “Pita, okandi be ganyiis vahivak-anja be gangga.” ");
INSERT INTO mmo_vpl VALUES ("AC10_14","074_10_14","ACT","10","14","14","+ o 10:14 Lev 11:1-47; Esi 4:14*Lemu Pita nêêl laah nambe, “Omaaho Bop, malis lôôt. Va nipaya osin va bamaan nambêênja ond same naha bôôy e.” ");
INSERT INTO mmo_vpl VALUES ("AC10_15","074_10_15","ACT","10","15","15","+ o 10:15 Mak 7:15,19*Tombe lava ango lo-hato balon ango having nambe, “Va sen Anutu samu be nivasa lak-ato, ond game ganjêênin naambe nipaya le.” ");
INSERT INTO mmo_vpl VALUES ("AC10_16","074_10_16","ACT","10","16","16","Omaaho Bop nêêl vakasin nambêênju balon yuuh having tu balon yaal, le mem tôômb-anjuuto lak-ambe laah baandoni pavis, ");
INSERT INTO mmo_vpl VALUES ("AC10_17","074_10_17","ACT","10","17","17","tombe Pita nando ka monavu va sen yii-to nambe, “Mak peey e vaa-ju danggakook nambe va?” Ka monavu nambêênju tonde Konilias-ate omaaho yaal sen wiing yaal lalaam-ato, ond lato be lalingin hil, de mondalaam-ambe lato daale Simon-ate bayêên vinavi, ");
INSERT INTO mmo_vpl VALUES ("AC10_18","074_10_18","ACT","10","18","18","tombe lateey-ambe lalingin nambe, “Simon sen haale ango nambe Pitaa-to ond laas nandôô-ja me malis?” ");
INSERT INTO mmo_vpl VALUES ("AC10_19","074_10_19","ACT","10","19","19","+ o 10:19 Sin 11:12; 13:2*Tombe Pita yoo nando ka monavu taahu taahuu-ju, le Vavi Vaambuung nêêl vu nambe, “Onggango omaaho yaal lato davu salo hong ani, ");
INSERT INTO mmo_vpl VALUES ("AC10_20","074_10_20","ACT","10","20","20","om okandi jak-ambe ganduus-ambe gana gaving yaal, de game gakam yu-yuuh e, in soo aawiing yaal lalaam.” ");
INSERT INTO mmo_vpl VALUES ("AC10_21","074_10_21","ACT","10","21","21","Om Pita luus-ambe laah hato vu yaal-ambe nêêl nambe, “Omaaho sen ham navu salo yii-to ond yik saa-jo. De ham alaam in vakasin va?” ");
INSERT INTO mmo_vpl VALUES ("AC10_22","074_10_22","ACT","10","22","22","+ o 10:22 Sin 10:1-2*Le yaal lanêêl laah vu nambe, “Konilias sen hil Lom ngaamong vaha doo-nomaayuuh-ate yêêv-ato, ond wiing waay alaam. Omaahôô-ju omaaho nivalok yoo nayêênin Anutu, de hil Yuda pin layi yi nivasa, ond angela vaambuung ti nêêl taato vu nambe biing hil lanaam in gako hong-ambe gana baan, in gango vakasin vu hong.” ");
INSERT INTO mmo_vpl VALUES ("AC10_23","074_10_23","ACT","10","23","23","+ o 10:23 Sin 10:45; 11:12*Om Pita nêêl-ambe yaal lalukala deep having yi, de samiinaanôôn atombe sil pin kandi be lalaah, tombe Omaaho Bop-ate hil vaalu vu Jopa lala having. ");
INSERT INTO mmo_vpl VALUES ("AC10_24","074_10_24","ACT","10","24","24","Sil mondala be lala deep busin ti vu mop lavuun, le mem sil latok lala Sisalia. Tonde Konilias teey yite hil sen sil dangga timuu-to osin yite nipaapu vaalu sen ahe naving sil-ato, be sil lasupin-ambe dando mondanggin Pita. ");
INSERT INTO mmo_vpl VALUES ("AC10_25","074_10_25","ACT","10","25","25","Tonde Pita lukala umakalo tombe Konilias laam-ambe hato pataav baambu neep voon hôôk Pita vaha in nambe gako haale jak, ");
INSERT INTO mmo_vpl VALUES ("AC10_26","074_10_26","ACT","10","26","26","+ o 10:26 Sin 14:13-15; Taato 19:10*le ma de Pita laandiiy hôôk nama de nêêl vu nambe, “Okandi jak, yik sa omaahonôôn nambe hong-anja.” ");
INSERT INTO mmo_vpl VALUES ("AC10_27","074_10_27","ACT","10","27","27","Pita monakaas vu be yuuh lalukala umakalo, tombe sim yi de hil ngeeyaata lasupin-ambe dando. ");
INSERT INTO mmo_vpl VALUES ("AC10_28","074_10_28","ACT","10","28","28","Tombe Pita nêêl vu sil nambe, “Ham oo alak ni nambe hil Yuda danêêlin nambe sil-ame mando gaving hil vaalu osin me-lana vu sil e, malis lôôt. Lemu sak Anutu nêêl taato vu sa nambe same naanêêl omaaho ti naambe nipaya me nindanjeen e, malis lôôt. ");
INSERT INTO mmo_vpl VALUES ("AC10_29","074_10_29","ACT","10","29","29","Om gêên ham ateey sa be sa laam-anjo ond same aayêênin e, om saanjingin ham naambe ham ateey sa laam in vakasin vaati?” ");
INSERT INTO mmo_vpl VALUES ("AC10_30","074_10_30","ACT","10","30","30","+ o 10:30 Sin 1:10; 3:1*Tombe Konilias nêêl nambe, “Gêên busin yumbeyuuh lung la, ond busin ti nyendoos-ato hôôk taaku me yaal nambe sen gêên-anjo, tombe sa monaalohak hôôk sate bayêên alo, le sim saahe omaaho ti osin yite tôômb ayuuh ame nivalôôy lôôt, ond hato naale hôôk sa mengg, ");
INSERT INTO mmo_vpl VALUES ("AC10_31","074_10_31","ACT","10","31","31","be nêêl nambe, ‘Konilias, Anutu hango gate lohakin, de ka navu gate samu samu sen onahôôvu hil in dativak in vaa-to, ");
INSERT INTO mmo_vpl VALUES ("AC10_32","074_10_32","ACT","10","32","32","om gambiing hil lana Jopa in gako Simon sen haale ango nambe Pitaa-to, ond la nando having lengo Simon sen nawiing kul bik naavii-to, ond yite bayêên nando ngaaho vu lôôy nanyendangga.’ ");
INSERT INTO mmo_vpl VALUES ("AC10_33","074_10_33","ACT","10","33","33","Om saanêêl pavis-ambe hil lalaas in hong, le gawiing nivasa be galaam, om gêên hey pin sen hey alaam nandôô-jo lak Anutu haale, hey aawiingin nambe gango vakasin pin sen Omaaho Bop nêêl vu hong nambe onaanêêl-ato.” ");
INSERT INTO mmo_vpl VALUES ("AC10_34","074_10_34","ACT","10","34","34","+ o 10:34 1Sml 16:7; Lom 2:11; Gal 2:6*Tombe Pita nêêl nambe, “Gêên-anjo sa lak ni keen lôôt nambe Anutu me-yoo ka navu hil dangga timu le, ma. ");
INSERT INTO mmo_vpl VALUES ("AC10_35","074_10_35","ACT","10","35","35","+ o 10:35 Jon 9:31*Yik omaahonôôn pin, ti nambe jêênin Anutu de biing va na nivalok, ond le ji yi nivasa. ");
INSERT INTO mmo_vpl VALUES ("AC10_36","074_10_36","ACT","10","36","36","+ o 10:36 Saam 107:20; Ais 52:7; Taato 17:14*De Anutu wiing-ambe Yesu Kalisi sen tu yiiy pin-ate Omaaho Bop-ato, ond nêêl banye nivasa osin vakasin melaas langaah vu hey Islel. ");
INSERT INTO mmo_vpl VALUES ("AC10_37","074_10_37","ACT","10","37","37","+ o 10:37 Mat 4:12-17*De ham oo alak ni nambe Jon nêêl tanasin lak belipisin vêêl e, mem Yesu Kalisi-te vakasin-anju hil lanêêl vu Galili be la lohvu taaku Yudia pin. ");
INSERT INTO mmo_vpl VALUES ("AC10_38","074_10_38","ACT","10","38","38","+ o 10:38 Mat 3:16; Luk 4:17-20*In Yesu Nasaalet ond Anutu yoo holin yi be vu Vavi Vaambuung osin niwêêk vu yi, tombe la lohvu taaku pin-ambe nahôôvu hil, de navu samu hil sen Saalang navu nimeen vu sil-ato be nind vasa nalak laah, in Anutu nando having yi. ");
INSERT INTO mmo_vpl VALUES ("AC10_39","074_10_39","ACT","10","39","39","De va pin sen wiing vu hey Yuda-te taaku de vu Yelusalem, osin layiis yi lakala haah-ambe yimb-ato, ond hey aahe, ondeey hey naanêêl tatekin-anjo. ");
INSERT INTO mmo_vpl VALUES ("AC10_40","074_10_40","ACT","10","40","40","+ o 10:40 1Ko 15:4-7*Lemu busin yaal lung la le mem Anutu wiing-ambe kandi lak laah-ambe taato yi langaah, ");
INSERT INTO mmo_vpl VALUES ("AC10_41","074_10_41","ACT","10","41","41","+ o 10:41 Jon 14:19,22-24; 15:27; Sin 1:8; Luk 24:42-43*ond me-taato yi vu hil Yuda pin e, malis, yoo taato yi vu hey sen bôôy Anutu holin hey nambe hey naanêêl yite vakasin-ato. De sen kandi lak laah vu hil yimbin-atêêto ond hey aha vanôôn osin hey aanum having yi. ");
INSERT INTO mmo_vpl VALUES ("AC10_42","074_10_42","ACT","10","42","42","+ o 10:42 Sin 17:31; 2Ti 4:1; 1Pi 4:5*De nêêl vu hey nambe hey naanêêl tatekin osin hey naanêêl langaah vu hil naambe Anutu holin yi lung la in gangoyin hil yimbin osin metumin-ate vakasin, be golin nivasa osin nipaya. ");
INSERT INTO mmo_vpl VALUES ("AC10_43","074_10_43","ACT","10","43","43","+ o 10:43 Ais 33:24; 53:5-6; Jer 31:34; Dan 9:24*Ond hil lanêêl Anutu-te vakasin langaah lak omaahôô-ju nambe hil pin sen londpayo la timu vu yii-to, ond haalêê-ju le kawiiy silate nipaya na.” ");
INSERT INTO mmo_vpl VALUES ("AC10_44","074_10_44","ACT","10","44","44","+ o 10:44 Sin 11:15; 15:8*Pita naahen monanêêl vakasin atonde Vavi Vaambuung lakala hil pin sen dando mondango vakasin-anjuuto. ");
INSERT INTO mmo_vpl VALUES ("AC10_45","074_10_45","ACT","10","45","45","Tombe hil Yuda sen lawii-having Yesu be sil ahondoos Pita-so lalaam-ato, ond lavindis lôôt in Anutu vu Vavi Vaambuung lakala hil vaalu sen sil-ame Yudaa-to having. ");
INSERT INTO mmo_vpl VALUES ("AC10_46","074_10_46","ACT","10","46","46","+ o 10:46 Sin 2:4; 19:6*Tombe lango de hil-anjuuto lakaas bayêên bu ti ti lavand-ambe dako Anutu haale lak, om Pita nêêl nambe, ");
INSERT INTO mmo_vpl VALUES ("AC10_47","074_10_47","ACT","10","47","47","+ o 10:47 Sin 8:36*“Lati le naanêêlin hil-anjo naambe me-lanjipis bel e, in lako Vavi Vaambuung lung la, yik nambe sen yiiy hakôô-to.” ");
INSERT INTO mmo_vpl VALUES ("AC10_48","074_10_48","ACT","10","48","48","+ o 10:48 Sin 2:38*Om nêêl-ambe lalipis bel lak Yesu Kalisi haale, tombe sil kataangg Pita be nando busin heey having sil vêêl e mem laah. ");
INSERT INTO mmo_vpl VALUES ("AC11_1","074_11_1","ACT","11","1","1","Sinaale-so osin Omaaho Bop-ate hil vaalu sen dando Yudiaa-to lango banye nambe hil vaalu sen sil-ame Yudaa-to lako Anutu-te tanasin lak, ");
INSERT INTO mmo_vpl VALUES ("AC11_2","074_11_2","ACT","11","2","2","om Pita laah valup Yelusalem atombe Yuda pin lanêêl yi. ");
INSERT INTO mmo_vpl VALUES ("AC11_3","074_11_3","ACT","11","3","3","+ o 11:3 Sin 10:28; Gal 2:12*Lanêêl nambe, “Gala vu hil sen sil-ame Yudaa-to be gaha vanôôn having sil.” ");
INSERT INTO mmo_vpl VALUES ("AC11_4","074_11_4","ACT","11","4","4","Lemu Pita hatulin va pin sen hango de yii-to vu sil nambe, ");
INSERT INTO mmo_vpl VALUES ("AC11_5","074_11_5","ACT","11","5","5","+ o 11:5-15 Sin 10:9-48*“Sa nando monaalohak vu taaku Jopa, tonde saahe taahu taahu ti, ond saahe de vati nambe tôômb bopaata ti luus-ambe laam, ond landuuh hôôk nanyendangga yumbeyuuh, de sil taaluuhin vu baandoni be laam voon vu sa. ");
INSERT INTO mmo_vpl VALUES ("AC11_6","074_11_6","ACT","11","6","6","Tombe saawiingin nambe anjak vaa-ju ni om saangget lôôt, le vahivak vaha vaha sen naale nala de nahaavak osin manak pin nando hôôk lopayo. ");
INSERT INTO mmo_vpl VALUES ("AC11_7","074_11_7","ACT","11","7","7","Tombe sa hango lava ti laam vu sa nambe, ‘Pita, okandi ganyiis vahivak-anja be gangga.’ ");
INSERT INTO mmo_vpl VALUES ("AC11_8","074_11_8","ACT","11","8","8","Lemu saanêêl nambe, ‘Omaaho Bop, malis lôôt. Va nipaya osin va bamaan nambêênja ond same naha bôôy e.’ ");
INSERT INTO mmo_vpl VALUES ("AC11_9","074_11_9","ACT","11","9","9","Tonde lava ango lom vu baandoni tu balon yuuh vu sa nambe, ‘Va sen Anutu samu be nivasa lak-ato, ond game ganjêênin naambe nipaya le.’ ");
INSERT INTO mmo_vpl VALUES ("AC11_10","074_11_10","ACT","11","10","10","Omaaho Bop nêêl vakasin nambêênju balon yuuh having tu balon yaal, le mem va pin-anju lak-ambe laah baandoni. ");
INSERT INTO mmo_vpl VALUES ("AC11_11","074_11_11","ACT","11","11","11","Tonde pavis atombe saahe omaaho yaal lato daale bayêên sen hey nando hôôk-ato vinavi, ond omaaho ti nando Sisalia nêêl-ambe yaal lalaam in sa. ");
INSERT INTO mmo_vpl VALUES ("AC11_12","074_11_12","ACT","11","12","12","Tombe Vavi Vaambuung nêêl vu sa nambe, ‘Gana gaving yaal de game gakam yu-yuuh e.’ Tombe halingg-aso namaavaalu vindak ti nganjo laving sa be hey ala hato omaaho sen wiing omaaho yaal lalaam in saa-to baan, ");
INSERT INTO mmo_vpl VALUES ("AC11_13","074_11_13","ACT","11","13","13","le mem hatulin vu hey nambe yi de angela ti hato naale yite bayêên alo be nêêl vu nambe, ‘Gambiing hil lana gako Simon sen haale ango nambe Pitaa-to vu Jopa be lanom ");
INSERT INTO mmo_vpl VALUES ("AC11_14","074_11_14","ACT","11","14","14","+ o 11:14 Sin 16:31*in naanêêl vakasin ti vu hong, ond vakasin e dôôvu hong gaving gate hil pin.’ ");
INSERT INTO mmo_vpl VALUES ("AC11_15","074_11_15","ACT","11","15","15","+ o 11:15 Sin 2:4*Tombe sa naahen naanêêl vakasin lakala, tonde Vavi Vaambuung lakala sil, yik nambe sen lakala yiiy bôôy-ato, ");
INSERT INTO mmo_vpl VALUES ("AC11_16","074_11_16","ACT","11","16","16","+ o 11:16 Sin 1:5*tombe sa kangg vu Omaaho Bop-ate vakasin sen nêêl-ato nambe, ‘Jon lipis hil-ato ond lipis sil lak bel, lemu Anutu navu biing Vavi Vaambuung naas mando gaving ham.’ ");
INSERT INTO mmo_vpl VALUES ("AC11_17","074_11_17","ACT","11","17","17","Om sen Anutu vu Vavi Vaambuung vu sil-anju, ond yik timu sen vu vu yiiy bôôy sen yaawii-having Omaaho Bop Yesu Kalisii-to, om sa vaati sen saanggilin Anutu-te mop jeen in sil?” ");
INSERT INTO mmo_vpl VALUES ("AC11_18","074_11_18","ACT","11","18","18","+ o 11:18 Sin 13:48; 14:27*Om hil pin sen dandôô-juuto lango Pita-te vakasin-anju be lavand ma, de lako Anutu haale lak nambe, “Om Anutu hilin hil sen sil-ame Yudaa-to londpayo in nambe sil mando metumin gaving.” ");
INSERT INTO mmo_vpl VALUES ("AC11_19","074_11_19","ACT","11","19","19","+ o 11:19 Sin 8:1-4*Hil sen lavuuh taale hôôk busin sen layiis Stiven-ande lawiing nindanjeen vu sil vaaluu-to, ond hil sen lavuuh taalêê-juuto vaalu lala taaku dinaandiin heey, taaku Pinisia yuuh Saiplas, de Antiok, tombe lanêêl tanasin vu hil Yuda malis, de me-lanêêl vu hil vaalu le. ");
INSERT INTO mmo_vpl VALUES ("AC11_20","074_11_20","ACT","11","20","20","Lemu hil vaalu vu Saiplas de vu Sailini ond sil latok lala Antiok, be lanêêl Omaaho Bop Yesu-te banye nivasa vu hil Glik having, ");
INSERT INTO mmo_vpl VALUES ("AC11_21","074_11_21","ACT","11","21","21","+ o 11:21 Sin 2:41*tombe Omaaho Bop-ate niwêêk nando having sil, om hil ngeeyaata lahilin londpayo be lawii-having Omaaho Bop. ");
INSERT INTO mmo_vpl VALUES ("AC11_22","074_11_22","ACT","11","22","22","+ o 11:22 Sin 4:36*Lawii-having atombe hil bel-ate vu Yelusalem lango banye, tombe lawiing Banabas la Antiok. ");
INSERT INTO mmo_vpl VALUES ("AC11_23","074_11_23","ACT","11","23","23","+ o 11:23 Sin 13:43; 14:22*La hato le yi nambe Anutu samu sil nivasa, tombe pêêlis de kaandu sil pin lak tanasin nambe yoo londpayo niwêêk, de sil oo mosapa Omaaho Bop timu jak busin pin. ");
INSERT INTO mmo_vpl VALUES ("AC11_24","074_11_24","ACT","11","24","24","+ o 11:24 Sin 2:41; 6:5*Banabas-anju omaaho nivasa, wii-having niwêêk lôôt, de Vavi Vaambuung hôôvu yi, tombe hil ngeeyaata latu Omaaho Bop-ate hil. ");
INSERT INTO mmo_vpl VALUES ("AC11_25","074_11_25","ACT","11","25","25","+ o 11:25 Sin 9:30*Tombe sim Banabas la Taasas in nambe salo Saul, ");
INSERT INTO mmo_vpl VALUES ("AC11_26","074_11_26","ACT","11","26","26","+ o 11:26 1Pi 4:16*tombe tovu yi om giiy-ambe yuuh lalaah Antiok, be yuuh dando having hil bel-ate vu Antiok ta ti lôôt, in yuuh davu taahu hil ngeeyaata hôôk Anutu-te tanasin. Tombe lanêêl Yesu-te hil vu Antiok nyendoos nambe hil Kalisten. ");
INSERT INTO mmo_vpl VALUES ("AC11_27","074_11_27","ACT","11","27","27","+ o 11:27 Sin 13:1; 15:32*Tombe hil sen danêêl Anutu-te vakasin langaah-ato heey vu Yelusalem-ambe lala lato Antiok, ");
INSERT INTO mmo_vpl VALUES ("AC11_28","074_11_28","ACT","11","28","28","+ o 11:28 Sin 21:10*ond sil ti haale nambe Agabas, ond Vavi Vaambuung vêêl lu lak om kandi be nêêl vakasin langaah nambe, “Meep bopaata navu naam nohvu taaku pin.” Tombe vakasin-anjo nôôn ak hôôk busin sen Klodias tu Lom-ate omaaho lulemak-ato. ");
INSERT INTO mmo_vpl VALUES ("AC11_29","074_11_29","ACT","11","29","29","Om Yesu-te hil lanjôôy vakasin munggin nambe sil pin daasupin mone yuuh ame sen nando vu sil-ato nohvu sil namand pin, be lambu na in dôôvu Omaaho Bop-ate hil vu Yudia hôôk busin sen meep naam-ato. ");
INSERT INTO mmo_vpl VALUES ("AC11_30","074_11_30","ACT","11","30","30","+ o 11:30 Sin 12:25*Tombe lasupin lung la, le mem lawiing Banabas ayuuh Saul lako be lala vu himbop-aso vu Yudia. ");
INSERT INTO mmo_vpl VALUES ("AC12_1","074_12_1","ACT","12","1","1","Busin-anju omaaho lulemak Helot nawiing nindanjeen vu hil bel-ate vaalu, ");
INSERT INTO mmo_vpl VALUES ("AC12_2","074_12_2","ACT","12","2","2","de nêêl-ambe layiis Jems sen Jon halii-to lak yipak-ambe yimb. ");
INSERT INTO mmo_vpl VALUES ("AC12_3","074_12_3","ACT","12","3","3","+ o 12:3 Sin 4:3*Tonde Helot yi de hil Yuda layi nivasa om nêêl-ambe hil lalôôh Pita having. Vaa-ju lawiing hôôk busin bop busin haluusin sen hil akand navu sen Anutu haluuh hil Islel hôôk vu Ijip bôôy-ato. ");
INSERT INTO mmo_vpl VALUES ("AC12_4","074_12_4","ACT","12","4","4","Lako Pita be lala latung lukala kalaambus, de lavu lukala hil ngaamong vaha-sote ahevaavu nomaayuuh-ambe laam namaavaalu vindak tii-to namand in sil ganggin, ond sil yumbeyu-beyuuh danggin-ambe davu taveyin. Helot aka vu nambe busin bop busin haluusin jung na le mem gako Pita naam baale hil Yuda mend in biing vakasin. ");
INSERT INTO mmo_vpl VALUES ("AC12_5","074_12_5","ACT","12","5","5","+ o 12:5 Jem 5:16*Om ahevaavu-so yoo mondanggin Pita hôôk kalaambus, lemu hil bel-ate lalohak niwêêk lôôt vu Anutu in yi. ");
INSERT INTO mmo_vpl VALUES ("AC12_6","074_12_6","ACT","12","6","6","+ o 12:6 Sin 5:23*Tombe busin ti sen Helot hatung in nambe samiinaanôôn Pita na baale hil amend-ato, ond landuuh Pita lak hees aniwêêk yuuh-ambe neep hôôk ahevaavu yuuh lavuun hôôk busin, de ahevaavu vaalu daale mondanggin vinavi. ");
INSERT INTO mmo_vpl VALUES ("AC12_7","074_12_7","ACT","12","7","7","Tonde sim Omaaho Bop-ate angela ti hato naale tombe bayêên alo melangaah lôôt. Angela patap Pita baanggesak-ande yêêvu nambe, “Okandi pavis.” Tombe hees yuuh-anjôôto yêêhin hôôk Pita nama be tok la, ");
INSERT INTO mmo_vpl VALUES ("AC12_8","074_12_8","ACT","12","8","8","tombe angela nêêl vu nambe, “Onggavêêh let osin onggatung gate suul naah.” Om Pita havêêh let-ande hatung suul laah, tonde angela nêêl vu laah nambe, “Ganjop gate lolop-ambe mem otaamuyin sa.” ");
INSERT INTO mmo_vpl VALUES ("AC12_9","074_12_9","ACT","12","9","9","Tombe Pita kandi lak-ambe taamuyin angela be yuuh lala, lemu me-lak va sen angela wiing-anjôôto ni le, de ka vu nambe yoo yi taahu taahu. ");
INSERT INTO mmo_vpl VALUES ("AC12_10","074_12_10","ACT","12","10","10","+ o 12:10 Sin 5:19*Yuuh lala lato kaluuh ahevaavu ti sen nanggin vinavi nyendoos-ato, de yuuh lala lato kaluuh vinavi ango having, tonde mem yuuh lala lato vinavi bop voon sen daayiiy ak aen-ato, tombe vinavi tii-ju yoo hataahin malis amu in yuuh, de yuuh lato voon-ambe yuuh laloh mop pasiv ti be latok lala bayêên bop, tonde angela la mema pavis. ");
INSERT INTO mmo_vpl VALUES ("AC12_11","074_12_11","ACT","12","11","11","Tombe Pita kanu lukalaah-ambe nêêl nambe, “Gêên salak ni keen nambe Omaaho Bop wiing yite angela hato vu vêêl sa vu Helot nama, osin vu va pin sen hil Yuda kand navu in nambe lambiing ak saa-to.” ");
INSERT INTO mmo_vpl VALUES ("AC12_12","074_12_12","ACT","12","12","12","+ o 12:12 Sin 12:25; 15:37*Lak ni lung la le mem la Jon sen haale ango nambe Maak-ato tangganaan Malia baan. Bayêên-anju hil ngeeyaata lasupin-ambe dando mondalohak. ");
INSERT INTO mmo_vpl VALUES ("AC12_13","074_12_13","ACT","12","13","13","Pita valup-ambe monayiis ak vinavi vu voon, tombe vêêh kul ti haale nambe Loda laam in nambe gataahin vinavi, ");
INSERT INTO mmo_vpl VALUES ("AC12_14","074_12_14","ACT","12","14","14","le hango Pita lava be lak ni tombe lopayo nivasa lôôt, om me-hataahin vinavi le, de hatup-ambe laah umakalo be nêêl vu sil nambe, “Pita valu-naale vinavi.” ");
INSERT INTO mmo_vpl VALUES ("AC12_15","074_12_15","ACT","12","15","15","+ o 12:15 Sin 26:24; Mat 18:10*Le lanêêl vu nambe, “Galumkook wiing paya.” Le ma de nêêl niwêêk lôôt nambe, “Malis, Pita keen lôôt.” Tombe lanêêl nambe, “Ôôye, manyinju yite angelaa-ju.” ");
INSERT INTO mmo_vpl VALUES ("AC12_16","074_12_16","ACT","12","16","16","Tonde Pita monayiis ak vinavi lôôt, om lataahin vinavi le layi Pita tombe sim sil lavindis lôôt. ");
INSERT INTO mmo_vpl VALUES ("AC12_17","074_12_17","ACT","12","17","17","+ o 12:17 Sin 13:16; 19:33; 21:40*Tombe Pita valaah nama vu sil in nambe lavand nama, tonde mem hatulin va sen Omaaho Bop giiy yi vu bayêên kalaambus alo be hato laam voon-ato, tonde nêêl having nambe, “Ham naanêêl vaa-jo banye vu Jems, de vu halingg-aso pin.” Tonde Pita hato la voon-ambe la taaku ango. ");
INSERT INTO mmo_vpl VALUES ("AC12_18","074_12_18","ACT","12","18","18","+ o 12:18 Sin 5:22-24*Tonde sim samiinaanôôn e ahevaavu-so kandi layi le ma, om sil nahand nalak lôôt-ambe danêêl nambe, “Peey e Pita la tana?” ");
INSERT INTO mmo_vpl VALUES ("AC12_19","074_12_19","ACT","12","19","19","Tombe Helot nêêl-ambe hil lala salo Pita le me-latovu le, om lingin ahevaavu-so sen danggin vinavii-to lôôt e ma, om nêêl atombe layiis sil-ambe layimb. Tonde Helot vu Yudia be la hato Sisalia be nando. ");
INSERT INTO mmo_vpl VALUES ("AC12_20","074_12_20","ACT","12","20","20","+ o 12:20 1King 5:11; Esi 27:17*Helot ahekalin bopaata vu hil Taia yuuh Saidon, om sil pin lavuh ti be lasupin lala vu, tombe sil samu vakasin vu Helot-ate yêêv bop Blastas sen nanggin yite bayêên-ato vêêl e, mem sil kataangg nambe omaaho lulemak Helot nyiis silanêênd vakasin jimb, in sil oo daanggo vanôôn vu omaaho lulemak-ate hil. ");
INSERT INTO mmo_vpl VALUES ("AC12_21","074_12_21","ACT","12","21","21","Om Helot hatung busin ti in nambe naanêêl vakasin vu hil, tombe busin-anju vunak ak lolop lulemak-ate be lakala nando lak sia lulemak-ate, tonde mem monanêêl vakasin vu sil pin, ");
INSERT INTO mmo_vpl VALUES ("AC12_22","074_12_22","ACT","12","22","22","tombe hil pin lateey bopaata nambe, “Ham hil-e, manyinju anutu ti nakaas, de omaahonôôn o ma.” ");
INSERT INTO mmo_vpl VALUES ("AC12_23","074_12_23","ACT","12","23","23","+ o 12:23 Dan 5:20*Lemu Helot-ame hako Anutu haale lak e, om Omaaho Bop-ate angela ti yiis pavis lukalaah nyevahaan, de wiing-ambe male ya omaaho lulemak Helot-ambe yimb. ");
INSERT INTO mmo_vpl VALUES ("AC12_24","074_12_24","ACT","12","24","24","+ o 12:24 Ais 55:11; Sin 6:7; Sin 19:20*Tonde Omaaho Bop-ate tanasin tu ahepataas-ambe la lohvu taaku pin. ");
INSERT INTO mmo_vpl VALUES ("AC12_25","074_12_25","ACT","12","25","25","+ o 12:25 Sin 11:29-30; 12:12; 15:37*Banabas ayuuh Saul lako mone yuuh ame la Yelusalem lung la, tonde yuuh lako Jon sen haale ango nambe Maak-ato having-ambe yaal lalaah. ");
INSERT INTO mmo_vpl VALUES ("AC13_1","074_13_1","ACT","13","1","1","+ o 13:1 Sin 11:27*Hil sen danêêl Anutu-te vakasin langaah-ato osin kaputung-aso dando having hil bel vu Antiok ond sil haalend-anjo, Banabas ayuuh Simon sen danêêl nambe Valiis-ato, de Lusias vu Sailini, de Manayen sen yuuh yêêv bop Helot unoopasiv-ande yuuh oo dando hôôk ti bôôy-ato, de Saul. ");
INSERT INTO mmo_vpl VALUES ("AC13_2","074_13_2","ACT","13","2","2","+ o 13:2 Sin 9:15; Gal 1:15-16*Ond busin ti me-laya vanôôn e de mondalohak vu Omaaho Bop, tombe Vavi Vaambuung nêêl nambe, “Ham anggolin Banabas ayuuh Saul lana kul sen saateey yuuh bôôy in nambe yuuh lambiing-ato.” ");
INSERT INTO mmo_vpl VALUES ("AC13_3","074_13_3","ACT","13","3","3","+ o 13:3 Sin 6:6*Om lalakin sil in vanôôn-ande me-laya le, de lalohak yesin laah, le mem lambe namand ak yuuh atonde lawiing yuuh lala. ");
INSERT INTO mmo_vpl VALUES ("AC13_4","074_13_4","ACT","13","4","4","+ o 13:4 Sin 15:39*Tombe Vavi Vaambuung nêêl-ambe yuuh lala. Yuuh lala lato Selusia le mem yuuh lalak sip vuu-ju be yuuh lala nalu lavuun Saiplas. ");
INSERT INTO mmo_vpl VALUES ("AC13_5","074_13_5","ACT","13","5","5","+ o 13:5 Sin 12:12; 13:13*Tombe mem yuuh latok lala Saiplas-ate bayêên ti haale nambe Salamis, tombe yuuh lanêêl Anutu-te tanasin-ambe yuuh latup hôôk hil Yuda-te dumb pin de Jon nahôôvu yuuh. ");
INSERT INTO mmo_vpl VALUES ("AC13_6","074_13_6","ACT","13","6","6","Yaal latup hôôk-ambe lalohvu nalu lavuun Saiplas-anju pin, be yaal latok lala bayêên Pepos. Tombe vu manyinju yaal latokak Yuda-te omaaho tatuhin vaha ti haale nambe Baayesu, ond omaahôô-ju lôômb osin yaavak dangga yi, ");
INSERT INTO mmo_vpl VALUES ("AC13_7","074_13_7","ACT","13","7","7","yoo nando having yêêv Lom ti Sesias Polas. Yêêv-anju lukook anivasa be wiingin nambe gango Anutu-te tanasin, om teey Banabas ayuuh Saul lala vu, ");
INSERT INTO mmo_vpl VALUES ("AC13_8","074_13_8","ACT","13","8","8","+ o 13:8 2Ti 3:8*le omaaho palaas Baayesuu-ju danêêl haale hôôk Glik lavand nambe Elimas, ond navu mahôôh Banabas ayuuh Saul in nawiingin nambe gilin yêêv alo be me-biing gaving tanasin e. ");
INSERT INTO mmo_vpl VALUES ("AC13_9","074_13_9","ACT","13","9","9","Lemu Saul sen danêêl haale ango nambe Pol-ato, ond Vavi Vaambuung hôôvu yi be me la vu Elimas lôôt, ");
INSERT INTO mmo_vpl VALUES ("AC13_10","074_13_10","ACT","13","10","10","tombe nêêl nambe, “Hong Saalang noow. Vakasin tatuhin osin va nindanje-danjeen pup hôôk galompayo, om onawiing nindanjeen vu va nivasa pin. Naangelis e onggavuuh gate vakasin sen onavu tatuhin ak Omaaho Bop-ato na? ");
INSERT INTO mmo_vpl VALUES ("AC13_11","074_13_11","ACT","13","11","11","+ o 13:11 Sin 9:8*Om onggango le, gêên-anjo Omaaho Bop nama navu nyiis hong-ambe gamem kanu dôôk, om peey-anjo game le gangge taaku le, de omando busin heey vêêl e mem.” Pol nêêl nambêênju tonde Elimas amekanu hôôk pavis-ambe navu kaatuuh hôôk, de navu salo hil in nambe sil daandiiy yi. ");
INSERT INTO mmo_vpl VALUES ("AC13_12","074_13_12","ACT","13","12","12","Yêêv yi vaa-ju tombe vindis lôôt in Omaaho Bop-ate tanasin be wii-having. ");
INSERT INTO mmo_vpl VALUES ("AC13_13","074_13_13","ACT","13","13","13","+ o 13:13 Sin 12:12; 13:5; 15:38*Pol ayaal lalak sip vu Pepos-ambe lalakala taaku Pega sen neep Pampilia-te taakuu-to, tombe Jon havuuh yuuh-ande laah Yelusalem. ");
INSERT INTO mmo_vpl VALUES ("AC13_14","074_13_14","ACT","13","14","14","De yuuh vu Pega be lala lalup Antiok sen neep Pisidia-te taakuu-to, tonde busin sawaasin atombe lahuli-lala dando hôôk dumb alo be dando. ");
INSERT INTO mmo_vpl VALUES ("AC13_15","074_13_15","ACT","13","15","15","+ o 13:15 Sin 15:21*Tombe lango de lasevin Mose-te tanasin osin Anutu-te vakasin sen yite hil vaalu kaavuu-to lung la, le mem yêêv-aso sen danggin dumb tii-ju lanêêl vakasin la vu Pol ayuuh nambe, “Halingg ayuuh, mawiingin nambe kaandu hil jak tanasin heey ond muuh-o.” ");
INSERT INTO mmo_vpl VALUES ("AC13_16","074_13_16","ACT","13","16","16","+ o 13:16 Sin 12:17*Tombe Pol kandi naale be valaah nama de nêêl nambe, “Ham Islel osin ham vaalu sen ham nayêênin Anutuu-to, ham gango le. ");
INSERT INTO mmo_vpl VALUES ("AC13_17","074_13_17","ACT","13","17","17","+ o 13:17 Eks 1:7; 6:6; 12:51*Yiiy Islel-anjo, yate Anutu holin yate himbop-aso bôôy, be sil lala dando bamaan vu Ijip-ato ond wiing-ambe sil latu ngeeyaata, lemu vu taamusin ond yite nama niwêêk giiy sil vuu-ju be lalaah. ");
INSERT INTO mmo_vpl VALUES ("AC13_18","074_13_18","ACT","13","18","18","+ o 13:18 Eks 16:35; Nam 14:34; Diu 1:31*Lala latup hôôk taaku lumbalaamb lohvu ta doo-yuuh atombe Anutu lopayo nimeen in davu kalêêh lava lak busin pin, le ma de me-haluuh dami vu sil e. ");
INSERT INTO mmo_vpl VALUES ("AC13_19","074_13_19","ACT","13","19","19","+ o 13:19 Diu 7:1; Jos 14:1*Nganjo yiis Kanaan-ate hil lulemak namaavaalu be vindak yuuh osin silate hil pin, de vu silate ngaanggis vu hil Islel-aso be tu silate va, tombe dando ta ngeeyaata lohvu 450 vêêl e mem. ");
INSERT INTO mmo_vpl VALUES ("AC13_20","074_13_20","ACT","13","20","20","+ o 13:20 Yêêv 2:16; 1Sml 3:20*Anutu holin Islel-ate yêêv atombe langgin sil-ambe tok laam Samuel-ate busin, ");
INSERT INTO mmo_vpl VALUES ("AC13_21","074_13_21","ACT","13","21","21","+ o 13:21 1Sml 8:5,19; 1Sml 10:20-24*tonde mem sil kataangg nambe Anutu golin silate omaaho lulemak ti, om Anutu holin Kis sen pumak Benyaamin-ato ond noow Saul, be tu omaaho lulemak-ambe hanggin hil lohvu ta doo-yuuh, ");
INSERT INTO mmo_vpl VALUES ("AC13_22","074_13_22","ACT","13","22","22","+ o 13:22 1Sml 13:14; 16:13; Saam 89:20*le sim Anutu lôôh yi vêêl-ande wiing-ambe Devit tu silate omaaho lulemak. Omaahôô-ja ond Anutu nêêl vakasin lak yi nambe, ‘Saahe de Jesi noow Devit lopayo having sa om le biing sate vakasin pin nôôn jak.’ ");
INSERT INTO mmo_vpl VALUES ("AC13_23","074_13_23","ACT","13","23","23","+ o 13:23 2Sml 7:12-16; Ais 11:1*Tombe Anutu yoo wiing lohvu sen nêêl bôôy-ato, om vu Devit-ate hil vu taamusin-ato ti Yesu laam in nambe dôôvu yiiy Islel pin. ");
INSERT INTO mmo_vpl VALUES ("AC13_24","074_13_24","ACT","13","24","24","+ o 13:24 Mat 3:1-2*De bôôy Yesu me-laam-ato, ond Jon nêêl vakasin vu hil Islel pin nambe langgilin londpayo be lanjipis bel. ");
INSERT INTO mmo_vpl VALUES ("AC13_25","074_13_25","ACT","13","25","25","+ o 13:25 Jon 1:20,27*Tonde ngaaho lak in Jon-ate kul jung na om nêêl nambe, ‘Ham akam navu nambe sa lati? Same omaaho sen ham nanggin yii-to le, ma. Omaaho sen navu taamuyin saa-to, ond mem. Same sa ningg vasa in nambe sa kavaayin suul na vêêl in omaahôô-ju vaha le, osin saambiing kul vaalu naambe hil kul-aso dawiing vu silate yêêv-asôôto le.’ ");
INSERT INTO mmo_vpl VALUES ("AC13_26","074_13_26","ACT","13","26","26","“Om halingg-aso sen Abalaam-ate hil vu taamusin ham-ato, de ham vaalu sen ham nayêênin Anutu having-ato, ham gango le. Vakasin sen Anutu nêêl nambe dôôvu yiiy-ato, ond wiing laam lung la vu yiiy, ");
INSERT INTO mmo_vpl VALUES ("AC13_27","074_13_27","ACT","13","27","27","+ o 13:27 Jon 16:3; Sin 3:17*lemu hil sen dando Yelusalem osin silate yêêv bop-aso me-lalak Yesuu-ju dangga ni vanuh e, de yoo dasevin Anutu-te vakasin sen hil lanêêl langaah bôôy-ato nalak busin sawaasin pin, le ma de me-kand vu le. De lawiing vakasin ak yii-to, ond lawiing Anutu-te vakasin sen hil lanêêl langaah bôôy-ato nôôn ak, ");
INSERT INTO mmo_vpl VALUES ("AC13_28","074_13_28","ACT","13","28","28","+ o 13:28 Mat 27:22-23*de me-latokak yite vakasin keen ti in nambe lanyiis-ambe jimb e, malis, lemu yoo lanêêl niwêêk lôôt atombe Pilata yiis-ambe yimb malis amu. ");
INSERT INTO mmo_vpl VALUES ("AC13_29","074_13_29","ACT","13","29","29","+ o 13:29 Mat 27:59-60*Om lawiing Anutu-te vakasin pin sen hil lanêêl langaah bôôy-ato nôôn ak lung la, le mem lalôôh ninaavi vêêl vu haah pako be lala lambe neep hôôk lavandangga, ");
INSERT INTO mmo_vpl VALUES ("AC13_30","074_13_30","ACT","13","30","30","+ o 13:30 Sin 2:24*lemu Anutu wiing-ambe kandi lak laah vu hil yimbin-ate. ");
INSERT INTO mmo_vpl VALUES ("AC13_31","074_13_31","ACT","13","31","31","+ o 13:31 Sin 1:3,8*Kandi lak lung la, le mem hil vaalu layi mend ak yi lohvu busin ngeeyaata, ond hil-anju sen sil laving yi vu Galili be sil ahondoosin lala lalup Yelusalem munggin-ato, ond hil-anju sen gêên danêêl yite banye nalohvu hil Yuda. ");
INSERT INTO mmo_vpl VALUES ("AC13_32","074_13_32","ACT","13","32","32","De hey naanêêl banye nivasa vu ham naambe vakasin sen Anutu nêêl vu yate himbop-aso bôôy-ato, ");
INSERT INTO mmo_vpl VALUES ("AC13_33","074_13_33","ACT","13","33","33","+ o 13:33 Saam 2:7*ond gêên wiing nôôn ak vu silate hil vu taamusin-ato yiiy, om wiing Yesu laam vu yiiy lohvu vakasin neep hôôk kaapiya Saam Lukook 2 nambe, ‘Sa noongg hong in gêên soo hako hong.’ ");
INSERT INTO mmo_vpl VALUES ("AC13_34","074_13_34","ACT","13","34","34","+ o 13:34 Ais 55:3*Tonde Anutu wiing-ambe kandi lak vu hil yimbin-ate lung la, de me-le ninaavi panyek naah e, ond Anutu nêêl langaah hôôk vakasin-anjo nambe, ‘Vakasin keen sen saanêêl vu Devit-ato ond sale aambiing nôôn jak vu ham.’ ");
INSERT INTO mmo_vpl VALUES ("AC13_35","074_13_35","ACT","13","35","35","+ o 13:35 Saam 16:10; Sin 2:27*Tonde vakasin boow ango neep hôôk Saam ango having nambe, ‘Game le gavuuh gate omaaho vaambuung-ambe ninaavi nanjip panyek hôôk lavandangga le.’ ");
INSERT INTO mmo_vpl VALUES ("AC13_36","074_13_36","ACT","13","36","36","+ o 13:36 Sin 2:29*De Devit ond wiing va lohvu Anutu nêêl vu yi hôôk yite busin sen yi osin yite hil dando memoos vu voon-ato, tonde yimb atombe lambe neep having maandin-ande bundin-ambe ninaavi panyek, ");
INSERT INTO mmo_vpl VALUES ("AC13_37","074_13_37","ACT","13","37","37","lemu omaaho sen Anutu wiing-ambe kandi lak-ato, ond ninaavi me-panyek e. ");
INSERT INTO mmo_vpl VALUES ("AC13_38","074_13_38","ACT","13","38","38","+ o 13:38 Sin 10:43*“Om halingg-aso, ham anjak ni naambe tanasin sen hey naanêêl langaah vu ham nambe Anutu le kawiiy hamate nipaya naa-to, ond tanasin-anjo danggakook Yesu. ");
INSERT INTO mmo_vpl VALUES ("AC13_39","074_13_39","ACT","13","39","39","+ o 13:39 Lom 10:4*Om hamate nipaya pin sen Mose-te tanasin-ame lohvu nambe kawiiy naa-to, ond ti nambe lopayo na timu vu Yesuu-ju, ond Anutu le kawiiy yite nipaya pin na de ji yi nivasa. ");
INSERT INTO mmo_vpl VALUES ("AC13_40","074_13_40","ACT","13","40","40","Om ham ganggin ham in Anutu-te vakasin sen hil lanêêl langaah bôôy-ato me-naatovu ham e. Nambe, ");
INSERT INTO mmo_vpl VALUES ("AC13_41","074_13_41","ACT","13","41","41","+ o 13:41 Hab 1:5*‘Ham kalêêsin ambu-so, ham angge be ham ambindis, lemu ham e ana mem nama. In kul ti sa naawiing hôôk busin sen ham nando voon-ato, naambe sil tatekin vu ham ond ham-ame le ambiing gaving e.’” ");
INSERT INTO mmo_vpl VALUES ("AC13_42","074_13_42","ACT","13","42","42","Pol nêêl vakasin lung la tonde yuuh Banabas lawiingin nambe gato lana voon, tombe hil lalaam-ambe kataangg yuuh nambe, “Yik muuh naanêêl vakasin-anjo jesin naah dôôk busin sawaasin ango taamusin vu hey.” ");
INSERT INTO mmo_vpl VALUES ("AC13_43","074_13_43","ACT","13","43","43","+ o 13:43 Sin 11:23; 14:22*Tonde hil pin lato lala voon, tombe hil Yuda osin hil vaalu sen dayêênin Anutu de lako Yuda-te gambum-ato, ond sil ngeeyaata sapa Pol ayuuh Banabas, tombe yuuh lanêêl tanasin osin yuuh kaandu sil niwêêk nambe yoo daapuvu Anutu-te samu samu lôôt. ");
INSERT INTO mmo_vpl VALUES ("AC13_44","074_13_44","ACT","13","44","44","Tonde busin sawaasin ango tombe hil taakuu-ju pin lasupin lalaam timu lôôt in gango Anutu-te tanasin. ");
INSERT INTO mmo_vpl VALUES ("AC13_45","074_13_45","ACT","13","45","45","+ o 13:45 Sin 14:2*Lemu hil Yuda layi hil ngeeyaata lasupin lôôt atombe ahend anipaya vu yuuh, de sil mahôôh Pol-ambe lanêêl yi pale. ");
INSERT INTO mmo_vpl VALUES ("AC13_46","074_13_46","ACT","13","46","46","+ o 13:46 Sin 3:26; 18:6; Luk 7:30*Le Pol ayuuh Banabas-ame layêênin e, de yuuh lanêêl nambe, “Haay aanêêl Anutu-te tanasin vu ham Yuda munggin, le ma de ham haluuh damim vu, om manyinja ham anêêl nambe ham-ame alohvu nambe mando metumin danggata le, om ham angge, gêên haay haluuh damingg vu ham-ande haay nala vu hil vaalu. ");
INSERT INTO mmo_vpl VALUES ("AC13_47","074_13_47","ACT","13","47","47","+ o 13:47 Ais 49:6*In Omaaho Bop nêêl vu haay nambe, ‘Saambiing-ambe gana naatu hil vaalu sen sil-ame Yudaa-to silate kin tumin in otaato mop metumin-ate vu hil-ambe na nohvu taaku pin.’ ");
INSERT INTO mmo_vpl VALUES ("AC13_48","074_13_48","ACT","13","48","48","+ o 13:48 Sin 11:18*Om hil vaalu sen sil-ame Yudaa-to lango vakasin-anju tombe londpayo nivasa lôôt, de lavand hôôk Anutu-te tanasin, tonde sil vaalu sen Anutu holin sil lung la in nambe sil mando metumin danggataa-to, ond lawii-having. ");
INSERT INTO mmo_vpl VALUES ("AC13_49","074_13_49","ACT","13","49","49","Tombe lanêêl Omaaho Bop-ate tanasin la lohvu taakuu-ju pin. ");
INSERT INTO mmo_vpl VALUES ("AC13_50","074_13_50","ACT","13","50","50","+ o 13:50 Sin 17:4,12*Lemu hil Yuda laanjiihin vêêh-aso sen haalend bop-ambe dayêênin Anutuu-to, osin yêêv bop-aso vu taakuu-jôôto, be lawiing nindanjeen vu Pol ayuuh Banabas, de latiiy yuuh in silate taaku be yuuh lala. ");
INSERT INTO mmo_vpl VALUES ("AC13_51","074_13_51","ACT","13","51","51","+ o 13:51 Mat 10:14; Sin 18:6*Tombe yuuh tatehin kambus sen nando lak yuuh vahand-ato in taato naambe nipaya neep vu sil, tonde mem yuuh lala Ikoniam, ");
INSERT INTO mmo_vpl VALUES ("AC13_52","074_13_52","ACT","13","52","52","de Yesu-te hil vu Antiok ond yoo dando osin londpayo nivasa lôôt de Vavi Vaambuung nando having sil. ");
INSERT INTO mmo_vpl VALUES ("AC14_1","074_14_1","ACT","14","1","1","Tombe yik vu Ikoniam ond Pol ayuuh Banabas lalukala Yuda-te dumb alo be yuuh lawiing tanasin osin niwêêk, tombe Yuda yuuh Glik ngeeyaata lôôt lawii-having. ");
INSERT INTO mmo_vpl VALUES ("AC14_2","074_14_2","ACT","14","2","2","+ o 14:2 Sin 13:45*Lemu Yuda vaalu sen me-lawiihaving-ato ond laanjiihin hil vaalu sen sil-ame Yudaa-to, be sil ahend kalin lôôt vu Omaaho Bop-ate hil, ");
INSERT INTO mmo_vpl VALUES ("AC14_3","074_14_3","ACT","14","3","3","+ o 14:3 Mak 16:20; Sin 19:11; Hiblu 2:4*lemu Pol ayuuh Banabas dandôô-ju lôôt, be yuuh oo mondanêêl Omaaho Bop-ate tanasin de yuuh-ame layêênin e. Tonde Omaaho Bop hôôvu yuuh-ambe yuuh lawiing taahu taahu vaha vaha osin niwêêk, in nambe hil lanjak ni naambe Omaaho Bop kaandu yuuhate vakasin sen yuuh tatekin yite samu samuu-to. ");
INSERT INTO mmo_vpl VALUES ("AC14_4","074_14_4","ACT","14","4","4","Tombe hil vu taakuu-ju me-londpayo lavuh ti le, om vaalu lawii-having Yuda de vaalu lawii-having sinaale yuuh. ");
INSERT INTO mmo_vpl VALUES ("AC14_5","074_14_5","ACT","14","5","5","+ o 14:5 Sin 14:19; 2Ti 3:11*Tombe hil vaalu sen sil-ame Yudaa-to osin hil Yuda laving silate yêêv-aso be lawiingin nambe lambiing nindanjeen vu Pol ayuuh Banabas, de lanyiis yuuh ak tatuuh-ambe yuuh lanjimb. ");
INSERT INTO mmo_vpl VALUES ("AC14_6","074_14_6","ACT","14","6","6","+ o 14:6 Mat 10:23*Le yuuh lango banye om yuuh lapak-ambe lala taaku Listla yuuh Debi sen neep hôôk Likonia-te taakuu-to, de taaku vaalu sen neep ngaahôô-to having, ");
INSERT INTO mmo_vpl VALUES ("AC14_7","074_14_7","ACT","14","7","7","tombe yuuh lala mondanêêl banye nivasa langaah vu taakuu-ju pin. ");
INSERT INTO mmo_vpl VALUES ("AC14_8","074_14_8","ACT","14","8","8","+ o 14:8 Jon 9:1; Sin 3:2*Omaaho ti nando Listla ond tangganaan hako osin vaha nipaya, tombe vaha me-niwêêk e, de me-nala mop daka le, ");
INSERT INTO mmo_vpl VALUES ("AC14_9","074_14_9","ACT","14","9","9","+ o 14:9 Sin 3:4; Mat 9:28*ond yoo monambe nanye in vakasin sen Pol nanêêl-ato. Tombe Pol nayi lôôt e mem lak ni nambe wii-having lohvu le nivasa dôôk, ");
INSERT INTO mmo_vpl VALUES ("AC14_10","074_14_10","ACT","14","10","10","om Pol nêêl la osin lava bopaata nambe, “Ombalaah ovaham-ande okandi baale nivasa.” Tombe sim kandi naale pavis-ambe la. ");
INSERT INTO mmo_vpl VALUES ("AC14_11","074_14_11","ACT","14","11","11","+ o 14:11 Sin 28:6*Hil ngeeyaata layi va sen Pol wiing-anjo tombe lateey hôôk hil Likonia lavand nambe, “Anutu heey latu omaahonôôn ak-ambe lalukalaam vu yiiy.” ");
INSERT INTO mmo_vpl VALUES ("AC14_12","074_14_12","ACT","14","12","12","Tombe lanêêl silate anutu voon-ate yuuh lak Banabas ayuuh Pol, ango haale nambe Sus lak Banabas, de ango haale nambe Hemis lak Pol in nambe yoo nakaas lôôt. ");
INSERT INTO mmo_vpl VALUES ("AC14_13","074_14_13","ACT","14","13","13","Tombe kul vaha sen natung salivangin vu Sus hôôk yite dumb sen naale taakuu-ju nanyendanggaa-to, ond hako kao moow heey osin ngaaola be hato vinavi in nambe na gaving hil-ambe lana gatung salivangin vu yuuh. ");
INSERT INTO mmo_vpl VALUES ("AC14_14","074_14_14","ACT","14","14","14","Sinaale Banabas ayuuh Pol langoyin atombe yuuh lakweek yuuhate lolop in yuuh alondpayo nimeen lôôt, de yuuh latup-ambe lala daale dateey bopaata hôôk hil lavuunaatôôv nambe, ");
INSERT INTO mmo_vpl VALUES ("AC14_15","074_14_15","ACT","14","15","15","+ o 14:15 Sin 10:26; Saam 146:6*“Ham hil-e, ham navu ambiing vaatii-ja? Yik haay omaahonôôn nambe ham-anja. Lemu haay naanêêl banye nivasa vu ham in nambe ham gavuuh va malis nambêênja na, de ham anggilin ham nom vu Anutu metumin-ate sen hatung baandoni osin ngaanggis de lôôy having va pin sen nando hôôk-ato. ");
INSERT INTO mmo_vpl VALUES ("AC14_16","074_14_16","ACT","14","16","16","+ o 14:16 Sin 17:30*Keen, vu bôôy ond hil pin oo mondawiing va lohvu sil akand de Anutu me-nêêlin e, ");
INSERT INTO mmo_vpl VALUES ("AC14_17","074_14_17","ACT","14","17","17","+ o 14:17 Saam 147:8; Jer 5:24*lemu Anutu-te samu samu taato yi nambe nando keen, in navu luk vu baandoni natolak-ambe vanô