﻿USE sofia;
DROP TABLE IF EXISTS sofia.mmn_vpl;
CREATE TABLE mmn_vpl (
  verseID VARCHAR(16) NOT NULL PRIMARY KEY,
  canon_order VARCHAR(12) NOT NULL,
  book VARCHAR(3) NOT NULL,
  chapter VARCHAR(3) NOT NULL,
  startVerse VARCHAR(3) NOT NULL,
  endVerse VARCHAR(3) NOT NULL,
  verseText TEXT CHARACTER SET UTF8 NOT NULL) ENGINE=MyISAM;
LOCK TABLES mmn_vpl WRITE;
INSERT INTO mmn_vpl VALUES ("MT1_1","070_1_1","MAT","1","1","1","Wani ya inkalista nga mga ngaran na mga karaang tao nga kaapoan ni Hiso Kristo. Na, si Hiso Kristo kaliwat iza ni Dabid nga karaang hari na mga Yodayo. Kaliwat isab iza ni Abraham nga karaang tao nga toboan na mga Yodayo. ");
INSERT INTO mmn_vpl VALUES ("MT1_2","070_1_2","MAT","1","2","2","Na, kawandini pen dogay di ya primiro si Abraham. Kamhan minliwat si Abraham kan Isak. Kamhan minliwat si Isak kan Hakob. Kamhan minliwat si Hakob kan Hoda daw ya mga lomon ni Hoda nga podo amaama. ");
INSERT INTO mmn_vpl VALUES ("MT1_3","070_1_3","MAT","1","3","3","Kamhan minliwat si Hoda kan Pares daw si Zara. Ya ina nirang dowa nga si Tamar. Kamhan minliwat si Pares kan Isrom. Kamhan minliwat si Isrom kan Aram. ");
INSERT INTO mmn_vpl VALUES ("MT1_4","070_1_4","MAT","1","4","4","Kamhan minliwat si Aram kan Aminadab. Kamhan minliwat si Aminadab kan Naasan. Kamhan minliwat si Naasan kan Salmon. ");
INSERT INTO mmn_vpl VALUES ("MT1_5","070_1_5","MAT","1","5","5","Kamhan minliwat si Salmon kan Boos. Kamhan ya ina ni Boos si Rahab. Kamhan minliwat si Boos kan Obid. Kamhan ya ina ni Obid si Rot. Kamhan si Obid minliwat kan Isay. ");
INSERT INTO mmn_vpl VALUES ("MT1_6","070_1_6","MAT","1","6","6","Kamhan minliwat si Isay kan Dabid nga karaang hari na mga Yodayo. Kamhan minliwat si Dabid kan Salomon. Kamhan ya ina ni Salomon ani primiro peng asawa ni Oriyas piro in-iregan ni Dabid kay ampangasawa iza. ");
INSERT INTO mmn_vpl VALUES ("MT1_7","070_1_7","MAT","1","7","7","Na, kamhan minliwat si Salomon kan Roboam. Kamhan minliwat si Roboam kan Abiyas. Kamhan minliwat si Abiyas kan Asa. ");
INSERT INTO mmn_vpl VALUES ("MT1_8","070_1_8","MAT","1","8","8","Kamhan minliwat si Asa kan Hosapat. Kamhan minliwat si Hosapat kan Horam. Kamhan minliwat si Horam kan Osiyas. ");
INSERT INTO mmn_vpl VALUES ("MT1_9","070_1_9","MAT","1","9","9","Kamhan minliwat si Osiyas kan Hotam. Kamhan minliwat si Hotam kan Ahas. Kamhan minliwat si Ahas kan Hizikiyas. ");
INSERT INTO mmn_vpl VALUES ("MT1_10","070_1_10","MAT","1","10","10","Kamhan minliwat si Hizikiyas kan Manasis. Kamhan minliwat si Manasis kan Amon. Kamhan minliwat si Amon kan Hosiyas. ");
INSERT INTO mmn_vpl VALUES ("MT1_11","070_1_11","MAT","1","11","11","Kamhan minliwat si Hosiyas kan Hikoniyas daw ya toong mga lomon nga podo amaama. Minliwat si Hosiyas kaniran kawandini pen ka pagpanbihag pen na mga taga Babilonya ka mga Yodayo doro ka dapit nga Babilonya. ");
INSERT INTO mmn_vpl VALUES ("MT1_12","070_1_12","MAT","1","12","12","Ka waro pen ya mga Yodayo ka Babilonya minliwat si Hikoniyas kan Salatiel. Kamhan minliwat si Salatiel kan Zorobabel. ");
INSERT INTO mmn_vpl VALUES ("MT1_13","070_1_13","MAT","1","13","13","Kamhan minliwat si Zorobabel kan Abiod. Kamhan minliwat si Abiod kan Iliyakim. Kamhan minliwat si Iliyakim kan Azor. ");
INSERT INTO mmn_vpl VALUES ("MT1_14","070_1_14","MAT","1","14","14","Kamhan minliwat si Azor kan Sadok. Kamhan minliwat si Sadok kan Akim. Kamhan minliwat si Akim kan Iliyod. ");
INSERT INTO mmn_vpl VALUES ("MT1_15","070_1_15","MAT","1","15","15","Kamhan minliwat si Iliyod kan Iliyazar. Kamhan minliwat si Iliyazar kan Matan. Kamhan minliwat si Matan kan Hakob. ");
INSERT INTO mmn_vpl VALUES ("MT1_16","070_1_16","MAT","1","16","16","Kamhan minliwat si Hakob kan Hosi nga bana ni Mariya. Kamhan min-anak si Mariya kan Hisos nga inngaranan kan Kristo. Na, ya kahologan na ngaran nga Kristo ani ya hari nga pinili na Diyos. ");
INSERT INTO mmn_vpl VALUES ("MT1_17","070_1_17","MAT","1","17","17","Na, ya mga kaliwatan sokad pen kan Abraham ngaro kan Dabid nga karaang hari napolo may opat ya pagsonodsonod ka mga kaliwatan. Kamhan sokad kan Dabid ngaro ka panahon ka pagpanbihag na mga taga Babilonya ka mga Yodayo ngaro ka dapit nga Babilonya napolo may opat gihapon ya pagsonodsonod ka mga kaliwatan. Kamhan sokad kaiton hangtod ka pagkatao ni Kristo napolo may opat gihapon ya pagsonodsonod ka mga kaliwatan. Ani ini ya lista na mga kaapoan ni Hiso Kristo. ");
INSERT INTO mmn_vpl VALUES ("MT1_18","070_1_18","MAT","1","18","18","Na, wani ya panan-og mahitenged ka pagkatao ni Hiso Kristo. Na, kawandini pen si Mariya asawhenen iza ni Hosi. Ka wara pen siran magminze nakabdesan si Mariya na Madazaw nga Ispirito nga garing ka Diyos. ");
INSERT INTO mmn_vpl VALUES ("MT1_19","070_1_19","MAT","1","19","19","Kamhan nakahena-hena si Hosi nga ansabot iza ka ginikanan ni Mariya kay ambelag iza kontana kan Mariya. Silaong ni Hosi nga nakasala si Mariya ambaza kay wara si Mariya makasala kay garing ka Diyos ya toong nakabdesan. Diri si Hosi ampanaba dizan ka howis nga nakabdesan di si Mariya kay basi anhatag kan Mariya ka kasipeg piro gosto iza ambelag kan Mariya kay antoman kontana iza ka balaed ni Moysis nga diri anminze ka nakabdesan nga babazi. ");
INSERT INTO mmn_vpl VALUES ("MT1_20","070_1_20","MAT","1","20","20","Kamhan pagkatorog ni Hosi impatag-inep iza na Ginoo. Dizan ka toong tag-inep watoy sinogo garing ka Diyos nga nagalaong nga Hosi nga kaliwat ni Dabid nga karaang hari, diri ko magkahaldek ka pagpangasawa kan Mariya kay nakabdesan di iza na Madazaw nga Ispirito nga garing ka Diyos. ");
INSERT INTO mmn_vpl VALUES ("MT1_21","070_1_21","MAT","1","21","21","An-anak iza ka maimpis nga amaama. Ngaranan mo iza kan Hisos. Na, ya kahologan na ngaran nga Hisos ani ya antabang ka toong mga sakop dazaw malibri siran ka silot ka kanirang mga sala. Ani ini ya inlaong na sinogo na Diyos dizan kan Hosi. ");
INSERT INTO mmn_vpl VALUES ("MT1_22","070_1_22","MAT","1","22","22","Na, ya pagkatao ni Hiso Kristo ani ya nakatoman ka mga panaba na propita na Ginoo kay kawandini pen nagalaong iza nga wani ya inlaong na Ginoo mahitenged ka pagkatao ni Hiso Kristo nga nagalaong nga ");
INSERT INTO mmn_vpl VALUES ("MT1_23","070_1_23","MAT","1","23","23","timan-an mazo gazed ini nga may makabdesan kay-an na Diyos nga daraga nga mahaldeken pen iza ka amaama. An-anak iza ka maimpis nga amaama. Kamhan pagangaranan iza kan Imanyowil. Na, ya kahologan na ngaran nga Imanyowil ani ya minkarimbaba ya Diyos dazaw an-iba iza kantang tanan tao. Ani ini ya daan inlaong na Ginoo mahitenged ka pagkatao ni Hiso Kristo. ");
INSERT INTO mmn_vpl VALUES ("MT1_24","070_1_24","MAT","1","24","24","Na, pagpakaimata ka ni Hosi mintoman iza ka sogo na sinogo nga garing ka Ginoo. Minminze iza kan Mariya ");
INSERT INTO mmn_vpl VALUES ("MT1_25","070_1_25","MAT","1","25","25","piro hangtod ka pag-anak ni Mariya wara iza mag-arani kan Mariya. Pagpakaanak ni Mariya ka maimpis inngaranan matood ni Hosi kan Hisos. ");
INSERT INTO mmn_vpl VALUES ("MT2_1","070_2_1","MAT","2","1","1","Na, pagkatao ni Hisos doro ka Bitlihim nga longsod doro ka lopa nga Yoda si Hirodis nga taga Roma ani ya hari ka hel-anan na mga Yodayo doro ka Yoda. Kamhan dini ka Hirosalem may mga mindateng garing ka sebazan. Hanas siran ka pagpaniid ka mga dalan na mga bitoon. ");
INSERT INTO mmn_vpl VALUES ("MT2_2","070_2_2","MAT","2","2","2","Kamhan nangotana siran daw hain makatenged ya natao nga maimpis nga anhari kay-an ka mga Yodayo? Mahagdam kami nga natao di iza kay nakakita kami ka pagsebang na makabegwas doro ka sebazan. Timaan nga natao di ya hari ka mga Yodayo. Agon minkarini kami kay antahod kami kanangiza. ");
INSERT INTO mmn_vpl VALUES ("MT2_3","070_2_3","MAT","2","3","3","Pagpakabati ka ni Hirodis nga hari kaiza nga panan-og nawied iza daw ya mga taga Hirosalem kay basi sopaken iza na bag-ong hari. ");
INSERT INTO mmn_vpl VALUES ("MT2_4","070_2_4","MAT","2","4","4","Kamhan impanipon ni Hirodis ya mga oloolo na mga pari nga Yodayo daw ya mga maistro ka tinoohan na mga Yodayo kay nangotana iza kaniran nga daw hain ya dapit nga nataohan na hari nga pinili na Diyos? ");
INSERT INTO mmn_vpl VALUES ("MT2_5","070_2_5","MAT","2","5","5","Minsambag siran nga natao di iza doro ka longsod nga Bitlihim doro ka Yoda. Kay kawandini pen minsoyat ya propita na Diyos nga wani ya inlaong na Diyos mahitenged ka pagkatao na hari ka mga Yodayo nga nagalaong nga ");
INSERT INTO mmn_vpl VALUES ("MT2_6","070_2_6","MAT","2","6","6","kamo nga mga taga Bitlihim nabantog di kamo ka mga iba nga longsod doro ka Yoda kay nataohan na hari ka kanaong mga sakop nga mga kaliwatan ni Israil. Ani ini ya daan sinoyat. ");
INSERT INTO mmn_vpl VALUES ("MT2_7","070_2_7","MAT","2","7","7","Pagpakabati ka ni Hirodis kaiza nga panan-og, dizan ka waray lain tao impatipon naiza ya mga hanas ka pagpaniid ka bitoon. Kamhan impangotana naiza kon pira ding ka kahabzen sokad ka pagsebang na makabegwas nga nakitan niran. ");
INSERT INTO mmn_vpl VALUES ("MT2_8","070_2_8","MAT","2","8","8","Kamhan minsogo iza kaniran nagalaong nga karohen mazo ka Bitlihim. Kamhan magsosi gazed kamo kon hain itong maimpis. Pagpakakita ka mazo bomalik kamo dazon ngarini kanao kay ankaro sab hao kay dazaw antahod isab hao kanangiza. Ambaza kay imbakakan siran ni Hirodis kay patazen naiza kontana si Hisos. ");
INSERT INTO mmn_vpl VALUES ("MT2_9","070_2_9","MAT","2","9","9","Kamhan minpanaw ya mga magpaniiday ka mga bitoon ngaro ka Bitlihim. Ka pagpasinged pen niran ngaro ka nataohan na maimpis minhon-a di kaniran ya makabegwas. Kamhan minhon-a iton kaniran hangtod ka pagpakatenged ka hel-anan na maimpis. Kamhan minheneng di iton. ");
INSERT INTO mmn_vpl VALUES ("MT2_10","070_2_10","MAT","2","10","10","Pagpakakita niran ka makabegwas nga minheneng di dakola gazed ya kanirang kasaza. ");
INSERT INTO mmn_vpl VALUES ("MT2_11","070_2_11","MAT","2","11","11","Pagpakaseled ka niran ka lagkaw nakitan matood niran ya maimpis daw ya toong ina nga si Mariya. Kamhan nanlohod siran ka pagtahod ka maimpis. Pag-okab niran ka len-anan nga indara niran inhatag niran ya bolawan daw ya dowang ka kalasi nga masarang kahamot nga mahal gazed. Ya isa inngaranan ka insinso ani ya sinonog para ka pagsingba ka Diyos. Ya isa inngaranan ka mira ani ya ihaplasay ka lawas. ");
INSERT INTO mmn_vpl VALUES ("MT2_12","070_2_12","MAT","2","12","12","Pagkakamhan niran paghatag inpasabot siran na sinogo nga garing ka Diyos pinaazi ka pagtag-inep nga nagalaong nga doro kamo mag-azi ka lain dalan kon mag-oli di kamo. Diri kamo magbalik kan Hirodis nga hari. ");
INSERT INTO mmn_vpl VALUES ("MT2_13","070_2_13","MAT","2","13","13","Pagpamanaw na mga magpaniiday ka mga bitoon inpatag-inep si Hosi na Ginoo. Dizan ka toong tag-inep watoy sinogo garing ka Diyos nga nagalaong nga Hosi, bomangon ko naa. Dadhen mo ya maimpis daw ya toong ina ngaro ka lopa nga Ihipto nga aro pagdazaw ka Yoda. Doro kamo magtagad ka kanaong sogo mag-oli naa kamo. Na, magdalagan gazed kamo kay sin Hirodis ampangita gazed ka maimpis dazaw patazen. ");
INSERT INTO mmn_vpl VALUES ("MT2_14","070_2_14","MAT","2","14","14","Pagkakamhan kaiza minbangon dazon si Hosi. Kamhan indara naiza ya maimpis daw ya toong ina ngaro ka lopa nga Ihipto. Madedeglemay pen ya pagdalagan niran ngaro ka Ihipto. ");
INSERT INTO mmn_vpl VALUES ("MT2_15","070_2_15","MAT","2","15","15","Doro siran magahela hangtod ka pagkamola ni Hirodis. Na, ya pagdalagan niran ani ya nakatoman ka mga panaba na propita na Ginoo kay kawandini pen nagalaong iza nga wani ya inlaong na Ginoo mahitenged ka toong Maanak nga impapanaw nao ya kanaong Maanak ka lopa nga Ihipto. Ani ini ya daan inlaong na Ginoo. ");
INSERT INTO mmn_vpl VALUES ("MT2_16","070_2_16","MAT","2","16","16","Na, ka wara pen si Hirodis mamola mahagdam iza nga imbakakan iza na mga magpaniiday ka mga bitoon agon nazehet gazed iza. Kamhan minsogo iza nga doro ka longsod nga Bitlihim daw ya mga dapit tenged ka Bitlihim pamatazen ya tanan mga bata nga amaama nga bag-ong natao ngaro ka dowang ka toig ya panoigen. Kay nadowahan ding ka toig sokad ka pagsebang na makabegwas. ");
INSERT INTO mmn_vpl VALUES ("MT2_17","070_2_17","MAT","2","17","17","Na, ya hinang ni Hirodis ani ya nakatoman ka inlaong ni Hirimiyas nga propita na Diyos kay kawandini pen nagalaong iza nga wani ya inlaong na Diyos mahitenged ka mga maimpis doro ka Bitlihim nga ");
INSERT INTO mmn_vpl VALUES ("MT2_18","070_2_18","MAT","2","18","18","nabatian nami ya kabezeng doro ka longsod nga Rama nga arani ka Bitlihim. Masara ya paghaza na mga ina doro kay nawara di ya kanirang mga maimpis. Ya kalised niran singed ka kalised ni Rakil nga karaang babazi kay kawandini pen nga diri magakalinaw ya toong hinawa kay natibe di ya toong mga maimpis pagpatay. Ani ini ya daan inlaong ni Hirimiyas nga propita na Diyos. ");
INSERT INTO mmn_vpl VALUES ("MT2_19","070_2_19","MAT","2","19","19","Na, pagkadogay kaiza namola di si Hirodis. Kamhan nagahela pen sin Hosi doro ka lopa nga Ihipto. Pagkatorog ni Hosi impatag-inep iza na Ginoo. Dizan ka toong tag-inep watoy sinogo garing ka Diyos nga nagalaong nga ");
INSERT INTO mmn_vpl VALUES ("MT2_20","070_2_20","MAT","2","20","20","Hosi, pomanaw ko naa. Dadhen mo ya maimpis daw ya toong ina pag-oli ka lopa nga Israil. Kay patay di siran doro nga mga magpatazay kontana ka maimpis. ");
INSERT INTO mmn_vpl VALUES ("MT2_21","070_2_21","MAT","2","21","21","Kamhan minpanaw di si Hosi daw ibahen isab ya maimpis daw toong ina ka pag-oli ngaro ka lopa nga Israil. ");
INSERT INTO mmn_vpl VALUES ("MT2_22","070_2_22","MAT","2","22","22","Pagkasazod ni Hosi nga ya maanak ni Hirodis nga si Arkilaw ani ya ilis ka toong ama ka paghari ka lopa ka Yoda nahaldek si Hosi ka pag-azi doro. Agon nangaro siran ka lopa nga Galiliya kay ani ya sogo na Diyos kan Hosi pinaazi gihapon ka pagtag-inep. ");
INSERT INTO mmn_vpl VALUES ("MT2_23","070_2_23","MAT","2","23","23","Kamhan nagahela di siran dizan ka longsod nga Nazarit. Kamhan natoman di ya panaba na propita mahitenged ka insoligan ni Hisos nagalaong nga taga Nazarit iza. Ani ini ya daan inlaong na Diyos. ");
INSERT INTO mmn_vpl VALUES ("MT3_1","070_3_1","MAT","3","1","1","Na, ka nagahela pen si Hisos doro ka Nazarit si Howan nga Magbenzagay nagawali iza doro ka kamingawan doro ka Yoda. Minwali iza nagalaong nga ");
INSERT INTO mmn_vpl VALUES ("MT3_2","070_3_2","MAT","3","2","2","bizaan di mazo ya maongang batasan kay domatengay di ya hari nga pinili na Diyos. Ani ini ya inwali ni Howan. ");
INSERT INTO mmn_vpl VALUES ("MT3_3","070_3_3","MAT","3","3","3","Na, ya inwali ni Howan ani ya nakatoman ka mga panaba ni Isayas nga karaang propita na Diyos nga nagalaong nga doro ka kamingawan may anhawag ka mga tao nga magalaong nga dazawen mazo ya kamazong batasan singed ka tao nga minhinglo ka dalan kay domatengay di ya Maanak na Diyos. Ani ini ya inlaong ni Isayas mahitenged kan Howan. ");
INSERT INTO mmn_vpl VALUES ("MT3_4","070_3_4","MAT","3","4","4","Na, ya bado ni Howan nahinang nga bohok na kamiliyo nga bohien na tao. Ya toong bakes anit. Ya toong magakanen mga doron daw seg-ed. ");
INSERT INTO mmn_vpl VALUES ("MT3_5","070_3_5","MAT","3","5","5","Na, pagwali ni Howan mataed gazed ya mga tao nga minkaro kanangiza. Garing siran ka siyodad nga Hirosalem daw bisan hain nga lopa doro ka Yoda daw ya mga dapit ka tenged na sapa nga Hordan. ");
INSERT INTO mmn_vpl VALUES ("MT3_6","070_3_6","MAT","3","6","6","Pagpanalinga niran ka inwali ni Howan nagalaong siran nga mga salaan matood kami nga mga tao. Kamhan dizan ka sapa nga Hordan impanbenzagan siran ni Howan. ");
INSERT INTO mmn_vpl VALUES ("MT3_7","070_3_7","MAT","3","7","7","Kamhan waton disab ya mga mataed nga maistro ka tinoohan na mga Yodayo. Nangaro siran kan Howan kay ampabenzag siran kontana. Parasiyo ya ngaran niran daw Sadosiyo. Kamhan minbaheg si Howan kaniran nagalaong nga kamo nga mga bakaken, nagapasingedsinged kamo ka mga halas pagpandalagan niran ka sonog ka pagharing na tao ka oma. Kay ono sa kamo nangarini kanao? Daw gosto baza kamo andalagan ka pagkazehet na Diyos kamazo? ");
INSERT INTO mmn_vpl VALUES ("MT3_8","070_3_8","MAT","3","8","8","Kon matood gazed ya paghinelsel mazo ipakita mazo ya madazaw nga batasan. ");
INSERT INTO mmn_vpl VALUES ("MT3_9","070_3_9","MAT","3","9","9","Azaw kamo maghambog ka kamazong pagkakaliwat ni Abraham. Timan-an mazo gazed ini nga bisan ya mga bato dizan ka lopa mahimo iton hinangen na Diyos nga mga kaliwatan ni Abraham. ");
INSERT INTO mmn_vpl VALUES ("MT3_10","070_3_10","MAT","3","10","10","Pamolinged ini nga andam daan ya Diyos ka pagbetang ka silot kamazo kay singed kamo ka liwaan nga diri mamonga ka madazaw nga bonga. Kon diri kon madazaw ya bonga na liwaan deegen iton kamhan sonogon. ");
INSERT INTO mmn_vpl VALUES ("MT3_11","070_3_11","MAT","3","11","11","Mindogang si Howan pagtoldo kaniran nagalaong nga hao ya nagabenzag kamazo ka sapa dazaw ipakita nga minhinelsel kamo ka kamazong mga sala piro may ansonod pen kanao nga magbenzag kamazo ka Madazaw nga Ispirito nga garing ka Diyos dazaw paharian kamo naiza nga Ispirito. Silotan sab naiza ya tao nga maongang batasan. Dizan kanangiza hao ya labing obos kay iza gazed ya labaw ka gahem. ");
INSERT INTO mmn_vpl VALUES ("MT3_12","070_3_12","MAT","3","12","12","Pagdateng naiza dini kamazo pabelagen naiza ya mga madazaw nga tao daw ya mga maongang tao. Kay singed iza ka tao nga nagasisig ka begas. Kamhan ibetang naiza ya magazong begas dizan ka dapoganan piro ya apa sonogon iton dizan ka laga nga diri mapareng. Ani ini ya inwali ni Howan. ");
INSERT INTO mmn_vpl VALUES ("MT3_13","070_3_13","MAT","3","13","13","Na, ka nagapanbenzag pen si Howan ka mga tao si Hisos minpanaw iza dizan ka lopa nga Galiliya. Kamhan mindateng di iza ka sapa nga Hordan kay ampabenzag iza kan Howan. ");
INSERT INTO mmn_vpl VALUES ("MT3_14","070_3_14","MAT","3","14","14","Piro diri kontana ansogot si Howan nga nagalaong nga iko kontana ya ambenzag kanao ambaza kay ampabenzag ko kanao. ");
INSERT INTO mmn_vpl VALUES ("MT3_15","070_3_15","MAT","3","15","15","Minsambag si Hisos kan Howan nga matood iton piro somogot ko lamang kay ya pagbenzag mo kanao ani ya timaan nga kay-an ka pagtoman na tirmino hao ya andawat ka silot ka mga sala na mga tao dazaw dizan ka pagseleng na Diyos matadeng di siran kon hao ya kanirang insakopan. Na, pagkakamhan ni Hisos pagpanaba minsogot si Howan. ");
INSERT INTO mmn_vpl VALUES ("MT3_16","070_3_16","MAT","3","16","16","Pagkakamhan naiza pagbenzag kan Hisos singed ka naabri di ya langit. Kamhan nakitan ni Hisos ya Madazaw nga Ispirito nga garing ka Diyos nga minkarimbaba kanangiza. Minpasingedsinged iton ka salapati. ");
INSERT INTO mmn_vpl VALUES ("MT3_17","070_3_17","MAT","3","17","17","Kamhan may nabatian niran nga saba na Diyos nga garing daked ka langit nagalaong nga wani ya kanaong Maanak nga kanaong naazakan. Nakasaza gazed iza kanao. Ani ini ya inlaong na Diyos. ");
INSERT INTO mmn_vpl VALUES ("MT4_1","070_4_1","MAT","4","1","1","Pagkakamhan ni Howan pagbenzag kan Hisos ya Madazaw nga Ispirito nga garing ka Diyos ani ya minpakaro kan Hisos ngaro ka kamingawan. ");
INSERT INTO mmn_vpl VALUES ("MT4_2","070_4_2","MAT","4","2","2","Keteb ka kap-atan nga ka aldaw daw kahabzen min-anget si Hisos ka pagkaen doro ka kamingawan. Kamhan magabengtasen di gazed iza. Kamhan intintal iza ni Satanas dazaw an-ato ka Diyos piro wara gazed si Hisos madaeg kay ingamit naiza pag-ato ya mga panaba na Diyos nga inpasoyat daan. ");
INSERT INTO mmn_vpl VALUES ("MT4_3","070_4_3","MAT","4","3","3","Pagkadizan ka ni Satanas kan Hisos nagalaong iza ka pagtintal nga kon iko ya matood nga Maanak na Diyos sogoon mo ya mga bato dizan ka lopa dazaw mahinang nga makaen kay magabengtasen di gazed iko. ");
INSERT INTO mmn_vpl VALUES ("MT4_4","070_4_4","MAT","4","4","4","Minsambag si Hisos nga diri hao ansogot kay may daan pinasoyat na Diyos nga nagalaong nga diri kon makaen ka lamang ya makabohi ka mga tao basta ya tanan mga panaba na Diyos ani gazed ya labaw nga makabohi ka mga tao. ");
INSERT INTO mmn_vpl VALUES ("MT4_5","070_4_5","MAT","4","5","5","Pagkakamhan kaiza impaiba ni Satanas si Hisos ngaro ka siyodad nga Hirosalem nga inngaranan ka Siyodad na Diyos. Kamhan in-ated ni Satanas si Hisos ngandaked ka taway na binobongan na dakolang lagkaw nga pangamozoanan ka Diyos. ");
INSERT INTO mmn_vpl VALUES ("MT4_6","070_4_6","MAT","4","6","6","Kamhan minlaong si Satanas kan Hisos nga kon matood pen nga ikoy Maanak na Diyos emempag iko ngambaba kamhan diri masakitan ya lawas mo kay may daan pinasoyat na Diyos nga nagalaong nga pabantazan iko ka toong mga sinogo. Bohaten iko niran. Kamhan bisan ya paa mo diri andasmag ka bato. ");
INSERT INTO mmn_vpl VALUES ("MT4_7","070_4_7","MAT","4","7","7","Minsambag si Hisos nga diri hao ansogot kay may daan pinasoyat na Diyos nga nagalaong nga azaw mazo pansorazi ya Ginoo nga kamazong Diyos. ");
INSERT INTO mmn_vpl VALUES ("MT4_8","070_4_8","MAT","4","8","8","Pagkakamhan kaiza impaiba ni Satanas pag-otro si Hisos ngandaked ka poro na bobong nga ataas pagdazaw kay paselengan ni Satanas ya tanang mga longsod dini ka haloag nga kalibotan nga madazaw selengan. ");
INSERT INTO mmn_vpl VALUES ("MT4_9","070_4_9","MAT","4","9","9","Kamhan minlaong si Satanas kan Hisos nga kon lomohod ko pagtahod kanao ihatag o kanmo ya katenged ka pagdomara ka tanan mga longsod kay hao ya nagadomara kaniran koman. ");
INSERT INTO mmn_vpl VALUES ("MT4_10","070_4_10","MAT","4","10","10","Minsambag si Hisos nga Satanas, pomanaw di ko dini kay may daan pinasoyat na Diyos nga nagalaong nga ya Ginoo nga kamazong Diyos iza gazed ya sazaen mazo. Iza sab ya kamazong alagaden waray lain. ");
INSERT INTO mmn_vpl VALUES ("MT4_11","070_4_11","MAT","4","11","11","Pagpakabati ka ni Satanas kaiza nga mga pinanaba minpanaw iza dazon. Kamhan ya mga tagalangit nga sogoonon na Diyos ani ya minkandizan kan Hisos dazaw magatabangan iza. ");
INSERT INTO mmn_vpl VALUES ("MT4_12","070_4_12","MAT","4","12","12","Pagkakamhan kaiza nabatian ni Hisos nga si Howan nga Magbenzagay napiriso di iza kay imbaheg naiza si Hirodis nga hari. Agon min-oli di si Hisos ka lopa nga Galiliya. ");
INSERT INTO mmn_vpl VALUES ("MT4_13","070_4_13","MAT","4","13","13","Piro diri iza ambalik ka longsod nga Nazarit nga toong insoligan kay minpormar di iza ka longsod nga Kapirnaom. Na, ya longsod nga Kapirnaom arani iton ka danaw daw minsakop isab ka mga longsod nga Sabolon daw Naptali. ");
INSERT INTO mmn_vpl VALUES ("MT4_14","070_4_14","MAT","4","14","14","Na, ya paghela ni Hisos dizan ka longsod nga Kapirnaom ani nakatoman ka panan-og ni Isayas nga propita na Diyos kay kawandini pen nagalaong iza nga wani ya inlaong na Diyos mahitenged ka paghela ni Hisos doro ka Kapirnaom nga ");
INSERT INTO mmn_vpl VALUES ("MT4_15","070_4_15","MAT","4","15","15","doro dapit ka Sabolon daw Naptali tenged ka danaw daw tenged isab ka sapa nga Hordan ani ini ya lopa na mga tao nga diri kon Yodayo. ");
INSERT INTO mmn_vpl VALUES ("MT4_16","070_4_16","MAT","4","16","16","Ka wara pen dateng si Hisos ka paghela dizan kaniran singed ka nagahela pen siran ka kadeglem kay wara pen siran magkilala ka Diyos. Magakahaldek sab siran ka pagkapatay niran. Piro pagdateng ni Hisos dizan kaniran singed ka minsirak nga sega ya kanirang bayho hasta nagahela disab siran ka kapawa kay si Hisos dizan iza kaniran maghela. Ani ini ya daan inlaong ni Isayas. ");
INSERT INTO mmn_vpl VALUES ("MT4_17","070_4_17","MAT","4","17","17","Na, sokad ka pagdateng ni Hisos ka longsod nga Kapirnaom minsogod iza pagwali nagalaong nga bizaan di gazed mazo ya mga maongang batasan kay mindateng di ya hari nga pinili na Diyos. ");
INSERT INTO mmn_vpl VALUES ("MT4_18","070_4_18","MAT","4","18","18","Na, may isang aldaw nga nagapasinged si Hisos ka baybazen na danaw nga Galiliya. Kamhan si Simon nga indagnazan kan Pidro daw si Andris nga dowa nga maglomon nga mangisdaay ani ya nakitan naiza. Nanimbag siran ka mga lazà pagpangisda. ");
INSERT INTO mmn_vpl VALUES ("MT4_19","070_4_19","MAT","4","19","19","Kamhan minlaong si Hisos kaniran nga somakop kamo kanao kay antoldo hao kamazo dazaw mahagdam kamo ka pagpasakop ka mga tao kanao singed ka pagpanlazà mazo ka mga isda. ");
INSERT INTO mmn_vpl VALUES ("MT4_20","070_4_20","MAT","4","20","20","Pagpakabati nin Simon ka sogo ni Hisos kaniran imbizaan dazon niran ya kanirang mga lazà kay an-iba gazed siran kan Hisos. ");
INSERT INTO mmn_vpl VALUES ("MT4_21","070_4_21","MAT","4","21","21","Pagkakamhan kaiza minlargo si Hisos pagpanaw ngaro ka isang baloto. Kamhan si Santiago daw si Howan nga dowa nga maglomon nga mga maanak ni Sibidiyo ani ya nakitan naiza. Dizan ka baloto nagatahi siran ka kanirang mga lazà iba ya kanirang ama. ");
INSERT INTO mmn_vpl VALUES ("MT4_22","070_4_22","MAT","4","22","22","Kamhan pagpasakop ni Hisos kanirang dowa imbilin niran ya kanirang ama dizan ka baloto kay an-iba sirang dowa kan Hisos. ");
INSERT INTO mmn_vpl VALUES ("MT4_23","070_4_23","MAT","4","23","23","Pagkakamhan kaiza minsoroy sin Hisos ka tibolos lopa nga Galiliya. Kay dalem ka mga singbahan na mga Yodayo nagatoldo iza ka mga tao daw nagawali ka sindo mahitenged ka pagpasakop na Diyos ka mga tao. Indazaw sab naiza ya bisan ono nga masakit daw kaloza na lawas na tao. ");
INSERT INTO mmn_vpl VALUES ("MT4_24","070_4_24","MAT","4","24","24","Kamhan minlekep di ya toong ngaran doro ka lopa nga Siriya. Kamhan in-ated na mga tao dizan kan Hisos ya bisan sin-o nga masakiten nga nagaanget ka nagakalainlain mga masakit. Nalakip ya mga tao nga inharian na mga maonga daw ya mga insawan daw ya mga tao nga diri mahingas ya lawas. Kamhan inbahaw ni Hisos sirang tanan. ");
INSERT INTO mmn_vpl VALUES ("MT4_25","070_4_25","MAT","4","25","25","Kamhan mataed gazed ya mga namagsonodsonod kan Hisos. Garing siran ka lopa nga Galiliya daw tenged ka longsod nga Dikapolis daw ya siyodad nga Hirosalem daw ya lopa nga Yoda daw ya mga dapit dipi ka sapa nga Hordan. ");
INSERT INTO mmn_vpl VALUES ("MT5_1","070_5_1","MAT","5","1","1","Pagkakamhan ni Hisos pagtabang ka kataeden na mga tao mintokad iza ngandaked ka pagkahiping na bobong. Paglo-to naiza dizan mindateng disab ya toong mga sakop. ");
INSERT INTO mmn_vpl VALUES ("MT5_2","070_5_2","MAT","5","2","2","Kamhan minsindo iza kaniran nga nagalaong nga ");
INSERT INTO mmn_vpl VALUES ("MT5_3","070_5_3","MAT","5","3","3","masazaen kamo kon makasabot kamo nga waray mahinang mazo kon wara ya pagtabang na Diyos. Kamhan tagan kamo na Diyos ka mga madazaw kay iza ya insakopan mazo. ");
INSERT INTO mmn_vpl VALUES ("MT5_4","070_5_4","MAT","5","4","4","Masazaen kamo kon mawied kamo pagkita mazo ka tao nga nagahinang ka maonga. Kamhan palinawen na Diyos ya kamazong hinawa. ");
INSERT INTO mmn_vpl VALUES ("MT5_5","070_5_5","MAT","5","5","5","Masazaen kamo kon diri kamo an-angken ka bisan ono. Kamhan dawaten matood mazo ya madazaw nga insaad na Diyos kamazo. ");
INSERT INTO mmn_vpl VALUES ("MT5_6","070_5_6","MAT","5","6","6","Masazaen kamo kon naazak kamo pagtoman ka mga sogo na Diyos. Kamhan tagan kamo naiza ka tanan mga madazaw, diri kamo makolangan. ");
INSERT INTO mmn_vpl VALUES ("MT5_7","070_5_7","MAT","5","7","7","Masazaen kamo kon malooy kamo ka kamazong kaibahan. Kamhan kaloy-an sab kamo na Diyos. ");
INSERT INTO mmn_vpl VALUES ("MT5_8","070_5_8","MAT","5","8","8","Masazaen kamo kon polos madazaw ya kamazong hena-hena. Kamhan kamo ya ankita ka Diyos. ");
INSERT INTO mmn_vpl VALUES ("MT5_9","070_5_9","MAT","5","9","9","Masazaen kamo kon kamo ya magadomara ka kahosay. Kamhan ngaranan kamo naiza nga toong mga maanak. ");
INSERT INTO mmn_vpl VALUES ("MT5_10","070_5_10","MAT","5","10","10","Masazaen kamo kon indaegdaeg kamo pagtoman mazo ka toong mga sogo. Kamhan tagan kamo na Diyos ka mga madazaw kay iza ya insakopan mazo. ");
INSERT INTO mmn_vpl VALUES ("MT5_11","070_5_11","MAT","5","11","11","Masazaen kamo kon intamay kamo na mga tao kay hao ya insakopan mazo. Kon magadaegdaegen kamo niran daw magabetangbetangan ");
INSERT INTO mmn_vpl VALUES ("MT5_12","070_5_12","MAT","5","12","12","magsaza kamo pagdakola kay daked ka hel-anan na Diyos dakola ya primyo mazo kay bisan ya mga karaang propita na Diyos siran gihapon ya indaegdaeg na mga tao. ");
INSERT INTO mmn_vpl VALUES ("MT5_13","070_5_13","MAT","5","13","13","Kamhan indogangan ni Hisos pagsindo ka toong mga sakop nagalaong nga pamolinged ini nga dizan ka kataohan singed kamo ka asin kay kamo ya antabang kaniran ka pagbineetan. Piro kon wara di ya kaparat na asin diri di gazed anbalik ya kaparat. Kamhan itimbag lamang kay wara di ya polos. Sagitnanan di lamang na mga tao. ");
INSERT INTO mmn_vpl VALUES ("MT5_14","070_5_14","MAT","5","14","14","Nagapasingedsinged isab kamo ka segà kay ipakita mazo ka mga tao ya magazong batasan. Ya pagkita niran ka kamazong magazong batasan singed iton ka pagkita ta ka longsod nga inhinang daked ka pongkay na bobong nga diri mahimo ka pagtago. ");
INSERT INTO mmn_vpl VALUES ("MT5_15","070_5_15","MAT","5","15","15","Na, kon seg-an na tao ya moron diri pagtakloban. Ibetang hinoa daked ka artal kay dazaw pawaan ya mga minseled ka lagkaw. ");
INSERT INTO mmn_vpl VALUES ("MT5_16","070_5_16","MAT","5","16","16","Kamhan ya kapawa na segà singed iton ka magazong batasan mazo nga nakita na mga tao. Kamhan sazaen niran ya kamazong Ama nga Diyos nga nagahela daked ka langit. Ani ini ya mga pamolinged ni Hisos ka toong mga sakop. ");
INSERT INTO mmn_vpl VALUES ("MT5_17","070_5_17","MAT","5","17","17","Kamhan indogangan ni Hisos pagsindo kaniran nagalaong nga azaw kamo maghena-hena nga mindateng di hao ka kalibotan dazaw waraen ya daan balaed na Diyos daw ya sindo na mga propita na Diyos. Wara hao magdateng ka pagpawara kaiza nga mga balaed. Basta kay mindateng di hao dazaw ipasabot nao kamazo ya matood nga kahologan na daan balaed na Diyos. ");
INSERT INTO mmn_vpl VALUES ("MT5_18","070_5_18","MAT","5","18","18","Timan-an mazo gazed ini nga keteb ka tirmino ka pagkawara na kalangitan daw kalibotan diri gazed makawa ya bisan isang ka toblok lamang na mga balaed na Diyos kay matoman gazed ya tanan. ");
INSERT INTO mmn_vpl VALUES ("MT5_19","070_5_19","MAT","5","19","19","Agon bisan sin-o ya diri antahod ka bisan isa lamang nga ka sogo na Diyos kamhan ampahaod isab iza ka toong angay diri gazed iza sazaen na Diyos kay-an ka pagkahari na Diyos. Bisan sin-o ya antoman ka tanan mga sogo na Diyos kamhan ampahaod isab iza ka iba nga tao sazaen gazed iza na Diyos kay-an ka pagkahari na Diyos. ");
INSERT INTO mmn_vpl VALUES ("MT5_20","070_5_20","MAT","5","20","20","Kon diri pen kon labaw ya katadeng na kamazong batasan ka katadeng na batasan na mga maistro ka tinoohan na mga Yodayo daw ya mga Parasiyo, diri hao ampaseled kamazo ka hel-anan na kanaong Ama daked ka langit kay hopaw ka lamang ya kamazong pagtoo. ");
INSERT INTO mmn_vpl VALUES ("MT5_21","070_5_21","MAT","5","21","21","Kamhan indogangan ni Hisos pagsindo ka toong mga sakop kay ipasabot naiza kaniran ya matood nga kahologan na mga daan balaed na Diyos. Minlaong iza nga mahagdam kamo ka naton-an na mga karaang tao nga azaw pagpatay ka tao. Ya makapatay ka tao dadhen ngaro ka hokmanan. Ani ini ya daan balaed ");
INSERT INTO mmn_vpl VALUES ("MT5_22","070_5_22","MAT","5","22","22","piro wani ya kanaong sindo kamazo nga bisan sin-o ya mazehet ka toong iba paatobangen iza doro ka hokmanan kay ya kazehet ani ya sinogdan ka pagbono ka tao. Kamhan bisan sin-o ya anlaong ka toong iba nga waray polos ya pagkatao mo dadhen iza doro ka labaw nga hokmanan. Kamhan bisan sin-o ya anlaong ka toong iba nga boang iko mamiligro iza ka laga na inpirno. ");
INSERT INTO mmn_vpl VALUES ("MT5_23","070_5_23","MAT","5","23","23","Na, kon andara iko ka kanmong halad ka Diyos dizan ka haladanan kamhan nakataremdem iko nga may nazehet kanmo ");
INSERT INTO mmn_vpl VALUES ("MT5_24","070_5_24","MAT","5","24","24","bizaan mo ya kanmong halad dizan ka haladanan. Karohen mo dazon ya kanmong iba dazaw maghosay naa kamo. Kamhan magbalik ko ka haladanan daw ihalad ya kanmong halad ka Diyos. ");
INSERT INTO mmn_vpl VALUES ("MT5_25","070_5_25","MAT","5","25","25","Kon may ansombong kanmo kamhan dadhen ko naiza ka hokmanan na, magpakighosay ko naa kanangiza ka wara pen kamo makadateng ka hokmanan. Kay kon makadateng kamo ka hokmanan itogyan ko naiza ka maghohokom. Kamhan ya maghohokom antogyan kanmo ka polis. Kamhan ipapiriso iko. ");
INSERT INTO mmn_vpl VALUES ("MT5_26","070_5_26","MAT","5","26","26","Kamhan dizan ko maghela hangtod ka pagkaimpas na kanmong molta. ");
INSERT INTO mmn_vpl VALUES ("MT5_27","070_5_27","MAT","5","27","27","Kamhan indogangan ni Hisos pagsindo ka toong mga sakop kay ipasabot pen naiza kaniran ya matood nga kahologan na mga daan balaed na Diyos. Minlaong iza nga mahagdam kamo ka naton-an na mga karaang tao nga nagalaong nga azaw maghenay. ");
INSERT INTO mmn_vpl VALUES ("MT5_28","070_5_28","MAT","5","28","28","Piro wani ya kanaong sindo kamazo nga bisan sin-oy anseleng ka babazi daw malaw-ay ya hena-hena salaan iza ka paghenay bisan hena-hena ka lamang. ");
INSERT INTO mmn_vpl VALUES ("MT5_29","070_5_29","MAT","5","29","29","Kamhan minpamolinged si Hisos kaniran nagalaong nga kon ya kanmong mata ani ya makaonga ka hena-hena mo ipaheneng gazed ya mata mo pagseleng. Singed ka kaw-en mo ya kanmong mata kamhan itimbag ngaro. Kay bisan isa kang bolos ya kanmong mata waray bali kay diri ikatimbag na Diyos ya tibolos lawas mo doro ka impirno. ");
INSERT INTO mmn_vpl VALUES ("MT5_30","070_5_30","MAT","5","30","30","Kon anhinang ya alima mo ka maonga ipaheneng gazed ya alima mo singed ka otdon mo iton. Kay bisan pikas ka lamang ya alima mo waray bali kay diri madara ya tibolos lawas mo doro ka impirno. ");
INSERT INTO mmn_vpl VALUES ("MT5_31","070_5_31","MAT","5","31","31","Indogangan ni Hisos pagsindo ka toong mga sakop nagalaong nga mahagdam kamo ka daan balaed nga imbilin ni Moysis kamazo nga bisan sin-o ya ambelag ka toong asawa kinahanglan hatagan ya toong asawa ka soyat para ka pagpamatood nga minbelag di ya toong bana. Ani ini ya daan balaed na Diyos. ");
INSERT INTO mmn_vpl VALUES ("MT5_32","070_5_32","MAT","5","32","32","Piro wani ya kanaong sindo kamazo nga bisan sin-o ya ampakigbelag ka toong asawa nga wara makasala ka paghenay nakasala gazed ya bana kay garing ka toong pagpakigbelag inhatag naiza ya sala nga paghenay ka toong asawa pagkaminze na asawa ka laing amaama. Bisan ya ikadowang bana nagahenay sab iza kay naminze iza ka babazi nga daan minze. ");
INSERT INTO mmn_vpl VALUES ("MT5_33","070_5_33","MAT","5","33","33","Kamhan indogangan ni Hisos pagsindo ka toong mga sakop kay ipasabot pen naiza kaniran ya matood nga kahologan na mga daan balaed na Diyos. Minlaong iza nga mahagdam isab kamo ka naton-an na mga karaang tao nga kinahanglan tomanen mazo ya kamazong saad ka Diyos, diri kamo magbakak ka pagsaad ka Diyos. Ani ini ya daan balaed ");
INSERT INTO mmn_vpl VALUES ("MT5_34","070_5_34","MAT","5","34","34","piro wani ya kanaong sindo kamazo nga kon ansaad kamo ka iba nga tao diri kamo magpaninhaga ka saad mazo nga nagalaong nga kon mabakak ini nga panaba magakaonga gazed ya kalangitan. Na, diri kamo maglaong singed kaiton kay ya langit ani ya lo-toanan na Diyos ka paghari. ");
INSERT INTO mmn_vpl VALUES ("MT5_35","070_5_35","MAT","5","35","35","Bisan ya kalibotan diri kamo magpaninhaga maglaong nga kon mabakak ini nga panaba magakaonga gazed ya kalibotan kay ya kalibotan ani ya pahimlazanan na paa na Diyos. Bisan ya siyodad nga Hirosalem diri kamo maglaong nga mageba iton nga siyodad kon mabakak ini nga panaba kay itong siyodad ani ya hel-anan na labaw nga hari kay-an. ");
INSERT INTO mmn_vpl VALUES ("MT5_36","070_5_36","MAT","5","36","36","Bisan ya kanmong olo kon ansaad ko ka iba nga tao diri kamo maglaong nga maobanen gazed ya kanaong olo kon mabakak ini nga kanaong saba. Kay diri kamo mahimo pagpapoti ka bisan isang ka legas nga bohok mazo daw pagpaitem. ");
INSERT INTO mmn_vpl VALUES ("MT5_37","070_5_37","MAT","5","37","37","Wani gazed ya kinahanglanen mazo pagsaad. Kon mahimo ya pagtoman mazo maghee kamo. Kon diri mahimo ya pagtoman maglaong kamo nga diri mahimo. Kay bisan ono ya paninhaga mazo ka pagrig-en ka saad garing iton ka maongang batasan mazo. ");
INSERT INTO mmn_vpl VALUES ("MT5_38","070_5_38","MAT","5","38","38","Kamhan indogangan ni Hisos pagsindo ka toong mga sakop kay ipasabot pen naiza kaniran ya matood nga kahologan na mga daan balaed na Diyos. Minlaong iza kaniran nga mahagdam kamo ka naton-an na mga karaang tao nga nagalaong nga ya nagapabota ka tao kinahanglan ibales ya pagpabota. Ya nagapatipo ka ngipen na tao pagsombag kinahanglan ibales ya pagpatipo pinaazi ka pagsombag. Ani ini ya daan balaed. ");
INSERT INTO mmn_vpl VALUES ("MT5_39","070_5_39","MAT","5","39","39","Piro wani ya kanaong sindo kamazo nga kon maghinang ya tao ka maonga dizan kanmo diri ko magbales ka maonga. Magbales ko hinoa ka magazon dazaw makadaeg ko ka maonga nga hinang. Bisan ansampalo iza ka pikas nga pisngi mo diri ko magbales ka maonga, ihatag mo hinoon ya isang pikas nga pisngi mo. ");
INSERT INTO mmn_vpl VALUES ("MT5_40","070_5_40","MAT","5","40","40","Bisan kawsahan ko kamhan ya ipabazad ani ya kanmong bado idogang pen ya paghatag ka habel mo. ");
INSERT INTO mmn_vpl VALUES ("MT5_41","070_5_41","MAT","5","41","41","Bisan ansogo iza kanmo ka pagpaated ka toong mabeg-at nga dara ngaro keteb ka isang ka kilomitro ibahan mo iza ngaro keteb ka dowang ka kilomitro. ");
INSERT INTO mmn_vpl VALUES ("MT5_42","070_5_42","MAT","5","42","42","Bisan an-azo iza tagi iza. Bisan ambeles iza pabelsen mo. Ani ini ya kanaong sindo kamazo. ");
INSERT INTO mmn_vpl VALUES ("MT5_43","070_5_43","MAT","5","43","43","Kamhan indogangan ni Hisos pagsindo ka toong mga sakop kay ipasabot pen naiza kaniran ya matood nga kahologan na mga daan balaed na Diyos. Minlaong iza nga mahagdam kamo ka naton-an na mga karaang tao nga nagalaong nga mag-angay kamo ka kamazong mga iba. Kamhan mag-away kamo ka kamazong mga kaaway. Ani ini ya daan balaed. ");
INSERT INTO mmn_vpl VALUES ("MT5_44","070_5_44","MAT","5","44","44","Piro wani ya kanaong sindo kamazo nga mag-angay kamo ka kamazong mga kaaway. Bisan ya mga andaegdaeg kamazo magbales kamo kaniran ka madazaw ");
INSERT INTO mmn_vpl VALUES ("MT5_45","070_5_45","MAT","5","45","45","dazaw ipakita mazo kaniran nga kamo ya matood nga mga maanak na Diyos nga kamazong Ama nga nagahela daked ka langit. Kay ya batasan naiza nagapasidlaw iza ka sega dimbaba ka mga maongang tao daw ya mga madazaw nga tao. Nagapadara sab iza ka oran dimbaba ka mga matadeng nga tao ilakip isab ya mga tao nga makasasala. ");
INSERT INTO mmn_vpl VALUES ("MT5_46","070_5_46","MAT","5","46","46","Kay kon anikay pagaazakan mazo ya mga nagakaangay kamazo diri gazed kamo mahatagan na Diyos ka primyo daked ka langit kay-an. Kay bisan ya mga maongang tao nga magsokotay ka mga bohis siran gihapon ya an-angay ka mga nagaangay kaniran. ");
INSERT INTO mmn_vpl VALUES ("MT5_47","070_5_47","MAT","5","47","47","Kon an-abiabi kamo ka kamazong mga higara ka lamang diri kamo sazaen na Diyos. Kay bisan ya mga tao nga diri pen ankilala ka Diyos siran gihapon ya an-abiabi ka mga min-abiabi kaniran. ");
INSERT INTO mmn_vpl VALUES ("MT5_48","070_5_48","MAT","5","48","48","Na, ya matadeng nga batasan kinahanglan magtoman gazed kamo dazaw mag-anika ya kamazong batasan daw ya batasan na kamazong Ama nga nagahela daked ka langit. ");
INSERT INTO mmn_vpl VALUES ("MT6_1","070_6_1","MAT","6","1","1","Indogangan pen ni Hisos pagsindo ka toong mga sakop nagalaong nga pagtoman mazo ka batasan nga matadeng azaw ipakahagdam ka mga tao dazaw sazaen kamo niran. Kay kon ani ya batasan mazo diri kamo mahatagan ka primyo na Diyos nga kamazong Ama nga nagahela daked ka langit. ");
INSERT INTO mmn_vpl VALUES ("MT6_2","070_6_2","MAT","6","2","2","Na, paghatag mazo ka hinabang dizan ka pobri nga tao diri ipakita ka mga tao singed ka batasan na mga garboso nga nagapatihinang nga matadeng dalem ka mga singbahan daw dizan ka kadalanan na longsod dazaw sazaen siran na mga tao. Timan-an mazo gazed ini nga indawat di gazed niran daan ya kanirang primyo nga pagsaza na mga tao kaniran. ");
INSERT INTO mmn_vpl VALUES ("MT6_3","070_6_3","MAT","6","3","3","Piro kamo nga kanaong mga sakop, paghatag mazo ka hinabang dizan ka pobri nga tao diri ipakita ka mga tao. ");
INSERT INTO mmn_vpl VALUES ("MT6_4","070_6_4","MAT","6","4","4","Hinoa dizan ka waray lain makakita ipanhatag mazo ya kamazong hinabang. Kamhan ya Diyos nga kamazong Ama nga makakita ka kanmong inhinang nga tinago iza gazed ya ambales kamazo ka madazaw. ");
INSERT INTO mmn_vpl VALUES ("MT6_5","070_6_5","MAT","6","5","5","Na, kon ampangamozo kamo ka Diyos diri kamo maghaod ka batasan na mga garboso nga nagapatihinang nga matadeng dazaw sazaen siran na mga tao. Kay dalem ka mga singbahan nagaazak siran ka pagtindeg ka pagpangamozo dazaw makitan siran na mga tao bisan dizan ka tenga na kadalanan na longsod. Timan-an mazo gazed ini nga indawat di gazed niran daan ya kanirang sohol nga pagsaza na mga tao kaniran. ");
INSERT INTO mmn_vpl VALUES ("MT6_6","070_6_6","MAT","6","6","6","Kamo nga kanaong mga sakop, kon ampangamozo kamo ka Diyos an-oli kamo ka kamazong lagkaw. Kamhan sirahan mazo ya kamazong lagkaw dazaw diri kamo makitan na mga tao. Kamhan ampangamozo kamo ka Diyos nga kantang Ama nga diri makita na bisan sin-o nga tao. Kamhan tagan kamo ka primyo na kamazong Ama nga nakakita ka kamazong inhinang dizan ka tago. ");
INSERT INTO mmn_vpl VALUES ("MT6_7","070_6_7","MAT","6","7","7","Pagpangamozo mazo diri mazo balikbaliken ya pagpanaba nga diri masabtan singed ka mga tao nga diri pen ankilala ka matood nga Diyos. Silaong niran nga nabatian na Diyos kay ataas ya pagpangamozo ambaza kay diri gazed ambati ya Diyos. ");
INSERT INTO mmn_vpl VALUES ("MT6_8","070_6_8","MAT","6","8","8","Diri kamo maghaod ka kanirang batasan kay bisan ka wara pen kamo mag-azo mahagdam daan ya kamazong Ama ka mga kinahanglanen mazo. ");
INSERT INTO mmn_vpl VALUES ("MT6_9","070_6_9","MAT","6","9","9","Agon pagpangamozo mazo maglaong kamo nga Ama nami nga nagahela daked ka langit, labaw gazed ya kanmong ngaran. ");
INSERT INTO mmn_vpl VALUES ("MT6_10","070_6_10","MAT","6","10","10","Harian mo kami dini ka kalibotan. Tomanen mo isab ya kanmong naazakan dini ka kalibotan singed ka pagtoman mo daked ka kanmong hel-anan. ");
INSERT INTO mmn_vpl VALUES ("MT6_11","070_6_11","MAT","6","11","11","Tagan mo kami komang aldaw ka kinahanglan nami nga pagkaen. ");
INSERT INTO mmn_vpl VALUES ("MT6_12","070_6_12","MAT","6","12","12","Pasaylohon mo ya kanaming mga sala singed ka pagpasaylo nami ka mga nakasala kanami. ");
INSERT INTO mmn_vpl VALUES ("MT6_13","070_6_13","MAT","6","13","13","Ipaaro mo kanami ya magtintalay daw ya mga maonga. Ani ini ya inhaodan mazo ka pagpangamozo ka Ama daked ka langit. ");
INSERT INTO mmn_vpl VALUES ("MT6_14","070_6_14","MAT","6","14","14","Kamhan indogangan pen ni Hisos pagsindo kaniran nagalaong nga kon pasaylohon mazo ya mga nakasala kamazo pasaylohon isab kamo na kamazong Ama nga nagahela daked ka langit. ");
INSERT INTO mmn_vpl VALUES ("MT6_15","070_6_15","MAT","6","15","15","Piro kon diri mazo mapasaylo ya mga nakasala kamazo, ya kamazong Ama nga nagahela daked ka langit diri isab iza anpasaylo ka kamazong mga sala. ");
INSERT INTO mmn_vpl VALUES ("MT6_16","070_6_16","MAT","6","16","16","Na, kon nagaanget kamo ka makaen dazaw may logar mazo ka pagpangamozo ka Diyos, diri kamo magpakita ka kamazong bayho nga waray kasaza singed ka mga tao nga nagapatihinang ka matadeng nga batasan dazaw long-on siran na mga tao nga madazaw ya kanirang batasan. Siran ya minlimas ka bayho niran ka alibo dazaw mahagdam ya mga iba niran nga nakaanget pen siran ka pagkaen ka pagpangamozo ambaza kay aro ka gazed ya hena-hena niran ka Diyos. Timan-an mazo gazed ini nga indawat di niran daan ya kanirang sohol ka pagsaza na mga tao kaniran. ");
INSERT INTO mmn_vpl VALUES ("MT6_17","070_6_17","MAT","6","17","17","Piro kamo nga kanaong mga sakop maghiram-os kamo pag-anget mazo ka pagkaen. Manodlay sab kamo ");
INSERT INTO mmn_vpl VALUES ("MT6_18","070_6_18","MAT","6","18","18","dazaw diri mahagdam ya iba mazo kay anikay mahagdam ya kamazong Ama nga diri makita. Kamhan tagan kamo ka primyo na kamazong Ama nga nakakita ka kamazong inhinang dizan ka tago. ");
INSERT INTO mmn_vpl VALUES ("MT6_19","070_6_19","MAT","6","19","19","Indogangan pen ni Hisos pagsindo ka toong mga sakop nagalaong nga diri kamo magdapogdapog ka mga mahalen dini ka kalibotan kay magakaonga ka kararing, maketket sab na mga ipos. Bisan ya kamazong lagkaw paniken na tolisan dazaw kawaten ya kamazong mga mahalen nga betang. ");
INSERT INTO mmn_vpl VALUES ("MT6_20","070_6_20","MAT","6","20","20","Hinoa mag-andam kamo daan ka mga mahalen daked ka hel-anan na Diyos kay diri iton madektan na kararing kon daked di ka hel-anan na Diyos. Diri isab maketket na mga ipos, diri sab paniken na mga tolisan pagkawat. ");
INSERT INTO mmn_vpl VALUES ("MT6_21","070_6_21","MAT","6","21","21","Kay kon hain ya kamazong mga mahalen waro disab ya hena-hena mazo ka pagtaremdem. ");
INSERT INTO mmn_vpl VALUES ("MT6_22","070_6_22","MAT","6","22","22","Indogangan pen ni Hisos pagsindo kaniran nagalaong nga mimpasingedsinged ya kantang mata ka segà dini ka kantang lawas. Kay kon mapawa ya kantang pagkita singed ka mapawa gihapon ya tibolos lawas. ");
INSERT INTO mmn_vpl VALUES ("MT6_23","070_6_23","MAT","6","23","23","Piro kon nabota kita singed ka nagahela kita ka kadeglem. Na, ya kahologan naini nga pamolinged ya kantang hena-hena singed iton ka mata dini ka kantang lawas. Kon sigi kita mag-andam ka mga mahalen nga betang daked ka hel-anan na Diyos singed ka madazaw ya pagkita na kantang mata. Piro kon sigi kita antaremdem ka mga mahalen dini ka kalibotan singed ka nabota di kita daw nagahela disab kita ka masarang kadeglem. ");
INSERT INTO mmn_vpl VALUES ("MT6_24","070_6_24","MAT","6","24","24","Kamhan bisan sin-o nga tao diri iza makaalagad pagdengan ka dowang ka agaron kay kon dowa ya toong agaron antahod iza ka isa piro magatamazen naiza ya isa. Kon magaazak kamo ka dakolang kowarta diri mahimo ya pag-alagad mazo ka Diyos. ");
INSERT INTO mmn_vpl VALUES ("MT6_25","070_6_25","MAT","6","25","25","Agon diri kamo magkawied pagpangita ka panginabohi mazo kon ono ya pagkaen daw pag-inem daw ya pagabadoon mazo. Ya kinabohi na tao mahal iton ka pagkamahal na makaen. Ya lawas na tao mahal iton ka pagkamahal na mga bado. Agon ya Diyos iza ya antabang kamazo dazaw may makaen mazo daw mga bado. ");
INSERT INTO mmn_vpl VALUES ("MT6_26","070_6_26","MAT","6","26","26","Paniidan mazo ya mga manokmanok nga nagalepadlepad. Waray mahimo niran pagtanem daw pag-ani daw pagdapog. Hinoa ya kamazong Ama nga nagahela daked ka langit ani ya nagapakaen kaniran. Na, mahal ya tao ka pagkamahal na mga manokmanok agon antabang gazed ya Ama kamazo ka pagpangita ka kamazong panginabohi. ");
INSERT INTO mmn_vpl VALUES ("MT6_27","070_6_27","MAT","6","27","27","Bisan ya kaataas na kamazong panoigen diri kamo magkawied kay garing ka pagkawied mazo diri kamo makaataas. ");
INSERT INTO mmn_vpl VALUES ("MT6_28","070_6_28","MAT","6","28","28","Diri kamo isab magkawied ka kinahanglan mazo ka bado. Paniidan mazo ya mga boyak nga tobo ka lamang kay waray mahimo niran pagtarabaho daw pagtahi ka kanirang bado. ");
INSERT INTO mmn_vpl VALUES ("MT6_29","070_6_29","MAT","6","29","29","Panabaen ta kamo bisan si Salomon nga karaang hari nga nagabado ka mga mahalen nga bado lopig gazed ka kagazen ya toong bado ka kagazen na mga boyak nga tobo ka lamang. ");
INSERT INTO mmn_vpl VALUES ("MT6_30","070_6_30","MAT","6","30","30","Na, mahal ya tao ka pagkamahal na mga boyak agon antabang gazed ya Diyos kamazo. Geramay gazed ya pagtoo mazo ka Diyos. Kay bisan ababa ya tirmino na mga boyak anhatag iza ka kagazon. Agon antabang isab iza kamazo. ");
INSERT INTO mmn_vpl VALUES ("MT6_31","070_6_31","MAT","6","31","31","Kamhan diri kamo magkawied maglaong nga waray makaen nami, waray mainem, waray bado. ");
INSERT INTO mmn_vpl VALUES ("MT6_32","070_6_32","MAT","6","32","32","Kay ani ya kawiedan na mga tao nga wara pen magsakop kanao. Piro ya kamazong Ama nga nagahela daked ka langit mahagdam iza ka tanan inkinahanglan mazo. ");
INSERT INTO mmn_vpl VALUES ("MT6_33","070_6_33","MAT","6","33","33","Na, kamo nga kanaong mga sakop wani ya kinahanglanen mazo, ya primiro paharien mazo ya Diyos ka kamazong beet dazaw antabang iza kamazo ka pagbineetan. Kamhan antabang iza kamazo ka mga kinahanglanen mazo. ");
INSERT INTO mmn_vpl VALUES ("MT6_34","070_6_34","MAT","6","34","34","Agon diri kamo magkawied ka kamazong kalised ka aldaw nga wara pen dateng. Kay kon domateng ya aldaw anipen kamo anhena-hena ka kalised dazaw diri madobli ya kamazong kalised komang aldaw. ");
INSERT INTO mmn_vpl VALUES ("MT7_1","070_7_1","MAT","7","1","1","Indogangan pen ni Hisos pagsindo ka toong mga sakop nagalaong nga azaw kamo maghokom ka mga iba nga tao dazaw diri kamo hokman na Diyos. ");
INSERT INTO mmn_vpl VALUES ("MT7_2","070_7_2","MAT","7","2","2","Kay hokman kamo na Diyos singed ka paghokom mazo ka iba. Kamhan kon ono ya paghokom mazo ka iba ani isab iton ya paghokom na Diyos kamazo. ");
INSERT INTO mmn_vpl VALUES ("MT7_3","070_7_3","MAT","7","3","3","Na, wani ya pamolinged mahitenged ka tao nga nagaazak ka pagpangita ka sazep dizan ka iba nga tao. Ya sala na tao nga anpangita ka sazep singed iton ka toroso dizan ka mata. Kamhan ya sazep na tao nga inpangitan singed iton ka geramay nga poling dizan ka mata. Kamhan singed ka nabota ya tao nga nagapangita ka sazep kay silaong naiza nga waray sala naiza. ");
INSERT INTO mmn_vpl VALUES ("MT7_4","070_7_4","MAT","7","4","4","Na, onhon sa naiza pagkawa ka poling dizan ka mata na iba nga tao kon may toroso dini ka toong mata? ");
INSERT INTO mmn_vpl VALUES ("MT7_5","070_7_5","MAT","7","5","5","Ka primiro pen magbiza iza ka pagpagarbo ka toong batasan anipen iza makatabang ka tao pagpabiza ka sala. ");
INSERT INTO mmn_vpl VALUES ("MT7_6","070_7_6","MAT","7","6","6","Indogangan pen ni Hisos pagsindo kaniran nagalaong nga ya pagkamahal na sindo mahitenged ka Diyos minpasingedsinged iton ka kamahal na mga motza. Agon dizan ka mga magasorasora kaini nga sindo diri kamo magwali pag-otro kay ya pagsorasora niran singed iton ka batasan na mga baboy daw ido nga magatamaktamakan lamang ya mga motza. Maghamarag isab kamo kay basi bangaen kamo niran. ");
INSERT INTO mmn_vpl VALUES ("MT7_7","070_7_7","MAT","7","7","7","Indogangan pen ni Hisos pagsindo kaniran nagalaong nga mangazo kamo ka Diyos ka inkinahanglan mazo. Kamhan tagan kamo naiza. Magpangita kamo. Kamhan ipakita naiza kamazo ya kamazong inkinahanglan. Maghawag kamo dazaw sambagen kamo na Diyos. Kamhan mabatian kamo naiza ka paghangzo mazo. ");
INSERT INTO mmn_vpl VALUES ("MT7_8","070_7_8","MAT","7","8","8","Kay bisan sin-o ya nagaazo ani tagan na Diyos ka toong inkinahanglan. Ya tao nga nagapangita ani tabangan na Diyos. Ya tao nga nagahawag mabatian na Diyos ya toong paghangzo. ");
INSERT INTO mmn_vpl VALUES ("MT7_9","070_7_9","MAT","7","9","9","Kamo nga may maanak, kon an-azo ya maanak ka makaen daw ihatag ya bato? Diri. ");
INSERT INTO mmn_vpl VALUES ("MT7_10","070_7_10","MAT","7","10","10","Kon an-azo iza ka isda daw ihatag ya halas? Diri. Kay ihatag mazo hinoa ya madazaw. ");
INSERT INTO mmn_vpl VALUES ("MT7_11","070_7_11","MAT","7","11","11","Na, kamo nga mga salaan nga tao mahagdam kamo ka paghatag ka madazaw ka kamazong mga maanak. Kamhan ya kagazon nga hatag na kamazong Ama nga nagahela daked ka langit labaw pen gazed ka impangazo mazo. ");
INSERT INTO mmn_vpl VALUES ("MT7_12","070_7_12","MAT","7","12","12","Agon magbatasan kamo ka mga iba nga tao singed ka batasan nga in-azakan mazo garing kaniran. Kay ani ya makatoman ka daan balaed na Diyos daw ya sindo na mga propita na Diyos. ");
INSERT INTO mmn_vpl VALUES ("MT7_13","070_7_13","MAT","7","13","13","Dizan ka masiet nga pirtahan magseled kamo. Kay malakbang ya pirtahan daw masazon ya dalan nga nagapasinged ngaro ka impirno. Kamhan dizan kaiton nga dalan mataed ya nagapanaw. ");
INSERT INTO mmn_vpl VALUES ("MT7_14","070_7_14","MAT","7","14","14","Masiet ya pirtahan daw malised ya dalan nga nagapasinged ngaro ka Diyos nga makahatag ka bag-ong kinabohi nga diri mawara. Kamhan dizan kaiton nga dalan talagsa ka ya makabagat. ");
INSERT INTO mmn_vpl VALUES ("MT7_15","070_7_15","MAT","7","15","15","Maghamarag kamo kay andateng kamazo ya mga nagalaong nga siran koni ya nagadara ka sindo mahitenged ka Diyos ambaza kay ya tood niran magapagasto siran kamazo. Magpatihinang nga propita na Diyos siran ambaza kay ani ya tozò niran ya pagdogang ka kowarta. ");
INSERT INTO mmn_vpl VALUES ("MT7_16","070_7_16","MAT","7","16","16","Paniidan mazo ya kanirang batasan dazaw makilalhan nga maglimbongay siran. Kay diri mamonga ya makahilo ka madazaw nga protas. ");
INSERT INTO mmn_vpl VALUES ("MT7_17","070_7_17","MAT","7","17","17","Ya liwaan nga waray kasakit mamonga iton ka madazaw nga bonga. Ya liwaan nga masakiten diri mamonga ka madazaw nga bonga. ");
INSERT INTO mmn_vpl VALUES ("MT7_18","070_7_18","MAT","7","18","18","Ya liwaan nga madazaw diri makabonga ka maonga. Ya liwaan nga maonga diri makabonga ka madazaw. ");
INSERT INTO mmn_vpl VALUES ("MT7_19","070_7_19","MAT","7","19","19","Kamhan ya mga liwaan nga diri mamonga ka madazaw pandeegen iton kamhan sonogon. ");
INSERT INTO mmn_vpl VALUES ("MT7_20","070_7_20","MAT","7","20","20","Agon makilalhan mazo ya mga maglimbongay nga mga tao kay malain ya batasan niran. ");
INSERT INTO mmn_vpl VALUES ("MT7_21","070_7_21","MAT","7","21","21","Na, diri hao ampaseled ka hel-anan na kanaong Ama ka mga tanan minsabi kanao nga Ginoo, Ginoo. Kay anikay makaseled ya mga antoman ka naazakan na kanaong Ama nga nagahela daked ka langit. ");
INSERT INTO mmn_vpl VALUES ("MT7_22","070_7_22","MAT","7","22","22","Agon kay-an ka paghokom na Diyos ka mga tao mataed ya anmahay kanao magalaong nga Ginoo, Ginoo izang dini kaini minsabi kami ka ngaran mo pagtekma nami ka mga kaazi nga domadateng. Minpadalagan sab kami ka mga maonga dizan ka mga tao nga inhabay pagsabi nami ka ngaran mo. Mataed pen isab ya dakolang inhinang nami pagsabi nami ka ngaran mo. ");
INSERT INTO mmn_vpl VALUES ("MT7_23","070_7_23","MAT","7","23","23","Kamhan ansambag hao kaniran nga pamanaw di kamong mga salaan nga tao dini kanao kay wara hao makakilala kamazo. ");
INSERT INTO mmn_vpl VALUES ("MT7_24","070_7_24","MAT","7","24","24","Pamolinged ini nga bisan sin-o ya nanalinga ka kanaong mga panaba kamhan tomanen naiza singed iza ka tao nga minlagkaw dizan ka lopa nga madazaw ogdokan. ");
INSERT INTO mmn_vpl VALUES ("MT7_25","070_7_25","MAT","7","25","25","Pagkakamhan naiza paglagkaw imbagzo ya lagkaw daw madateng isab na baha. Bisan indasmagan iton ka makeseg nga hangin diri madeeg kay marig-en gazed ya in-ogdokan. ");
INSERT INTO mmn_vpl VALUES ("MT7_26","070_7_26","MAT","7","26","26","Kamhan ya tao nga diri antoman ka kanaong mga panaba singed iza ka tao nga minlagkaw dizan ka dapit nga nag-as. ");
INSERT INTO mmn_vpl VALUES ("MT7_27","070_7_27","MAT","7","27","27","Pagkakamhan naiza paglagkaw imbagzo dazon. Kamhan madateng isab na baha. Indasmagan isab ka makeseg nga hangin. Kamhan nadeeg ya lagkaw kay inlenepan ya ogdok. Nageba dazon ya toong lagkaw. ");
INSERT INTO mmn_vpl VALUES ("MT7_28","070_7_28","MAT","7","28","28","Pagkakamhan ni Hisos pagsindo kaniran nangabereng gazed ya mga mataed nga tao ");
INSERT INTO mmn_vpl VALUES ("MT7_29","070_7_29","MAT","7","29","29","kay ya toong mga panaba labaw gazed ka gahem ka mga panaba na mga maistro ka tinoohan na mga Yodayo. ");
INSERT INTO mmn_vpl VALUES ("MT8_1","070_8_1","MAT","8","1","1","Kamhan si Hisos minlogsong garing ka pagkahiping na bobong. Kamhan mataed ya magasonod kanangiza nga mga tao. ");
INSERT INTO mmn_vpl VALUES ("MT8_2","070_8_2","MAT","8","2","2","Lomaza pomanaw siran insogat ni Hisos ya tao nga kagiden. Paglohod naiza ka paahan ni Hisos minhangzo iza nga nagalaong nga Sinyor, kon somogot ko ka pagpangamozo nao kanmo dazawen mo ya kanaong masakit. ");
INSERT INTO mmn_vpl VALUES ("MT8_3","070_8_3","MAT","8","3","3","Kamhan inhogam iza ni Hisos daw nagalaong nga Loy, ansogot hao. Nawara di ya masakit ka kanmong lawas. Kamhan nadazaw matood ya toong lawas. ");
INSERT INTO mmn_vpl VALUES ("MT8_4","070_8_4","MAT","8","4","4","Kamhan minsogo si Hisos nga nagalaong nga diri ko magpanan-og ka mga tao ka inhinang o kanmo. Pomanaw ko naa ngaro ka pari. Magpakita ko ka kanmong lawas diton. Kamhan magtoman ko ka balaed ni Moysis ka paghalad kay dazaw magmatood ya mga kataohan nga nawaraan di ko ka kanmong kagid. ");
INSERT INTO mmn_vpl VALUES ("MT8_5","070_8_5","MAT","8","5","5","Pagkakamhan kaiza minpasinged si Hisos ngaro ka longsod nga Kapirnaom. Pagdateng ka naiza doro may Romanhon nga kapitan na mga soldaw nga minsogat kanangiza. Kamhan minpakilooy iza nga ");
INSERT INTO mmn_vpl VALUES ("MT8_6","070_8_6","MAT","8","6","6","nagalaong nga Sinyor, kon somogot ko tabangan mo hao ka kanaong sogoonon nga inbilin doro ka kanaong lagkaw. Diri iza makahingas ka toong lawas. Nagael-el gazed ya toong kalawasan. ");
INSERT INTO mmn_vpl VALUES ("MT8_7","070_8_7","MAT","8","7","7","Minsambag si Hisos nga karohen ka nao iza dazaw ipatambal ya toong masakit. ");
INSERT INTO mmn_vpl VALUES ("MT8_8","070_8_8","MAT","8","8","8","Minsambag ya kapitan nga Sinyor, masipeg hao kon ampanik ko doro ka kanaong lagkaw kay diri kon Yodayo hao. Labaw gazed ka gahem ya kanmong panaba agon panabaen di mo lamang dini ka dalan dazaw mawara ya masakit na lawas na kanaong sogoonon doro ka lagkaw. ");
INSERT INTO mmn_vpl VALUES ("MT8_9","070_8_9","MAT","8","9","9","Kay bisan hao antoman gazed hao ka sogo na minbeet kanao. Kamhan ansogo isab hao ka mga soldaw. Kon ansogo hao ka isa ka pagpanaw, antoo dazon iza. Kon ansogo hao ka isa ka pagkarini, antoo dazon iza. Kon ansogo hao ka isang oripen ka pagtarabaho, antoo dazon iza. ");
INSERT INTO mmn_vpl VALUES ("MT8_10","070_8_10","MAT","8","10","10","Pagpakabati ka ni Hisos ka sambag na kapitan nabereng iza kay bisan diri kon Yodayo ya kapitan dakola ya pagsarig naiza. Kamhan nagalaong si Hisos ka mga magasonod ka toong panaw nga ya pagsarig na kapitan dakola iton ka pagsarig na bisan sin-o nga kaliwat ni Israil. ");
INSERT INTO mmn_vpl VALUES ("MT8_11","070_8_11","MAT","8","11","11","Timan-an mazo gazed ini nga mataed ya mga tao singed ka kapitan nga diri kon kaliwatan ni Israil. Kamhan ampakaen ya Diyos kaniran kay-an ka paghari naiza ka bag-ong kalibotan. Garing siran ka sebazan daw salpan kay ansaro siran ka makaen iba kan Abraham daw si Isak daw si Hakob nga mga karaang tao na mga Yodayo. ");
INSERT INTO mmn_vpl VALUES ("MT8_12","070_8_12","MAT","8","12","12","Kamhan ya mga kaliwatan ni Israil nga diri ankilala kanao, diri ampaseled ya Diyos kaniran ka toong hel-anan. Basta iitsa siran ngaro ka kadeglemanan. Kamhan magapangageet siran ka kanirang ngipen ka paghaza. ");
INSERT INTO mmn_vpl VALUES ("MT8_13","070_8_13","MAT","8","13","13","Kamhan nagalaong si Hisos ka kapitan nga om-oli di ko ngaro kay natoman di ya pangamozo mo kanao kay mintoo ko kanao. Kamhan doro ka lagkaw madazaw di matood ya masakit na lawas na toong sogoonon. ");
INSERT INTO mmn_vpl VALUES ("MT8_14","070_8_14","MAT","8","14","14","Pagkakamhan kaiza minkaro si Hisos ka lagkaw ni Pidro. Pagdateng naiza may bozag nga ogangan ni Pidro nga nagabentag kay imbangkag gazed iza. ");
INSERT INTO mmn_vpl VALUES ("MT8_15","070_8_15","MAT","8","15","15","Pagtagen ni Hisos ka alima na nabedlay inhowasan dazon iza ka toong hilanat. Kamhan minbangon iza kay ampakaen iza kan Hisos. ");
INSERT INTO mmn_vpl VALUES ("MT8_16","070_8_16","MAT","8","16","16","Pagkadelem kaiza impaarani kan Hisos ya mga mataed nga tao nga inboang na mga maonga. Pagsogo ni Hisos ka mga maonga mindalagan dazon siran. Imbahaw disab naiza ya bisan sin-o nga may mga masakit ka lawas. ");
INSERT INTO mmn_vpl VALUES ("MT8_17","070_8_17","MAT","8","17","17","Na, ya mga hinang ni Hisos ani ya nakatoman ka panan-og ni Isayas nga karaang propita na Diyos. Kay kawandini pen nagalaong si Isayas nga wani ya inlaong na Diyos mahitenged kan Kristo nga makapawara iza ka kaloza na kantang mga lawas. Kaw-en sab naiza ya mga masakit na kantang lawas. Ani ini ya inlaong ni Isayas nga propita. ");
INSERT INTO mmn_vpl VALUES ("MT8_18","070_8_18","MAT","8","18","18","Na, pagpakahimaan ka ni Hisos nga masara gazed nga kataed ya mga tao nga minlibot kanangiza insogo naiza ya toong mga sakop ka pagkandipi ka danaw. ");
INSERT INTO mmn_vpl VALUES ("MT8_19","070_8_19","MAT","8","19","19","Na, ka wara pen siran magleen ka baloto may isang maistro ka tinoohan na mga Yodayo nga nagasogat kan Hisos. Kamhan nagalaong iza kan Hisos nga Maistro, an-iba gazed hao kanmo bisan hain ko magpanaw. ");
INSERT INTO mmn_vpl VALUES ("MT8_20","070_8_20","MAT","8","20","20","Minsambag si Hisos nga bisan ya mga mire may mga pogad niran ka pagpahimlay. Bisan ya mga manokmanok may mga haponanan niran. Piro wara gazed ya kanaong lagkaw nga pahimlazanan. ");
INSERT INTO mmn_vpl VALUES ("MT8_21","070_8_21","MAT","8","21","21","Kamhan ya isang sakop ni Hisos minlaong nga Ginoo, tagadan mo hao naa kay ankaro pen hao ka kanaong ama nga mapatazay di iza. ");
INSERT INTO mmn_vpl VALUES ("MT8_22","070_8_22","MAT","8","22","22","Minsambag si Hisos nga ya mga lomon mo nga diri ansakop kanao ani komay magkaro ka kanmong ama kay singed siran ka mga napatay nga tao kay waray hena-hena niran mahitenged ka Diyos. Kamhan iko somakop ko kanao. ");
INSERT INTO mmn_vpl VALUES ("MT8_23","070_8_23","MAT","8","23","23","Pagkakamhan kaiza minleen si Hisos ka baloto iba ya toong mga sakop. ");
INSERT INTO mmn_vpl VALUES ("MT8_24","070_8_24","MAT","8","24","24","Ka dizan pen siran ka tenga na danaw imbagzo gazed siran. Insapwan dazon na baled ya boloto daw malened kontana piro natorog si Hisos. ");
INSERT INTO mmn_vpl VALUES ("MT8_25","070_8_25","MAT","8","25","25","Kamhan minsinggit ya toong mga sakop pagpokaw kanangiza nagalaong nga Maistro, tabangi kami kay mangalemes di kita! ");
INSERT INTO mmn_vpl VALUES ("MT8_26","070_8_26","MAT","8","26","26","Min-imata dazon si Hisos daw minlaong nga kay ono sa magakahaldek sa kamo? Geramay ka gazed ya kamazong pagsarig kanao. Kamhan minbangon iza daw minbaheg ka hangin daw mga baled. Kamhan nalinaw matood ya tanan. ");
INSERT INTO mmn_vpl VALUES ("MT8_27","070_8_27","MAT","8","27","27","Kamhan nabereng gazed siran daw namaglaong nga daw sin-o sa baza ini nga taohana? Kay bisan ya hangin daw ya mga baled antoo gazed ka toong pagbaheg! ");
INSERT INTO mmn_vpl VALUES ("MT8_28","070_8_28","MAT","8","28","28","Kamhan minsangpet di siran ka lopa nga Gadara dipi ka danaw. Kamhan may dowang ka tao nga inhoropan gazed ka mga maonga nga minsogat kan Hisos. Garing siran ka mga lebeng nga talangban kay ani ya kanirang hel-anan. Maiseg gazed siran agon nagakahaldek ya mga tao paglabay dizan ka dalan. ");
INSERT INTO mmn_vpl VALUES ("MT8_29","070_8_29","MAT","8","29","29","Pagpakakita niran kan Hisos minsinggit siran nga iko nga Maanak na Diyos, kay ono say inkarini mo? Kontana diri mo kami pagdaegdaegen kay wara pen ya tirmino ka pagsilot kanami. Ani ini ya inlaong na mga maonga. ");
INSERT INTO mmn_vpl VALUES ("MT8_30","070_8_30","MAT","8","30","30","Na, waton doro may nagapansongad nga kababozan. ");
INSERT INTO mmn_vpl VALUES ("MT8_31","070_8_31","MAT","8","31","31","Kamhan minpakilooy ya mga maonga nga Hisos, kon magpadalagan ko kanami pahel-en mo kami doro ka lawas na mga baboy. ");
INSERT INTO mmn_vpl VALUES ("MT8_32","070_8_32","MAT","8","32","32","Minsambag si Hisos nga pomanaw kamo ngaro kaniran. Kamhan minpanaw ya mga maonga dizan ka lawas na dowang ka tao. Kamhan minhari siran ka mga baboy. Kamhan minpahidalagan ya tanan mga baboy ngaro ka pangpang nga ataas. Minpatiholog siran ngambaba ka danaw kamhan natibe siran pagkalemes. ");
INSERT INTO mmn_vpl VALUES ("MT8_33","070_8_33","MAT","8","33","33","Kamhan nandalagan gazed ya mga magbantazay ka baboy ngaro ka kanirang longsod kay ampanan-og ka mga tao kon in-ono ni Hisos ya dowang ka tao nga inhoropan ka mga maonga. ");
INSERT INTO mmn_vpl VALUES ("MT8_34","070_8_34","MAT","8","34","34","Kamhan minkaro dazon kan Hisos ya mga mataed nga taga longsod kay ampakigkita siran kan Hisos. Pagdateng niran minhangzo siran kan Hisos dazaw ampanaw iza dizan ka kanirang lopa. ");
INSERT INTO mmn_vpl VALUES ("MT9_1","070_9_1","MAT","9","1","1","Pagkakamhan kaiza minleen si Hisos ka baloto kay an-oli iza ka Kapirnaom nga toong hel-anan dipi ka danaw. ");
INSERT INTO mmn_vpl VALUES ("MT9_2","070_9_2","MAT","9","2","2","Pagdateng ka naiza doro may mga minkadakoza nga namaglahong ka tao nga diri mahingas ya lawas. Pagpakakita ka ni Hisos nga minsarig gazed siran kanangiza ka pagbahaw kaiton nga tao minlaong iza ka nabedlay nga Loy, diri ko magkawied kay impasaylo di nao ya kanmong mga sala. ");
INSERT INTO mmn_vpl VALUES ("MT9_3","070_9_3","MAT","9","3","3","Na, dizan isab ya mga maistro ka tinoohan na mga Yodayo. Pagpakabati ka niran ka inlaong ni Hisos ka paralitiko minlaong siran ka kanirang hena-hena nga garboso gazed si Hisos pagbakak nga iza ya Diyos. ");
INSERT INTO mmn_vpl VALUES ("MT9_4","070_9_4","MAT","9","4","4","Mahagdam dazon si Hisos nga maonga ya kanirang hena-hena. Agon nangotana iza kaniran nga kay ono sa nga malain sa ya kamazong hena-hena kanao? ");
INSERT INTO mmn_vpl VALUES ("MT9_5","070_9_5","MAT","9","5","5","Dini ka paralitiko singed ka masazon ya pagpasaylo ka toong mga sala kay diri mazo makita kon dizan pen ya toong mga sala kon wara di. Piro malised ya pagdazaw ka toong lawas kay makita dazon kon madazaw di iton kon diri pen. ");
INSERT INTO mmn_vpl VALUES ("MT9_6","070_9_6","MAT","9","6","6","Koman ipakilala nao kamazo nga may gahem nao ka pagpasaylo ka mga sala na bisan sin-o nga tao kay hao gazed ya minhon-a ka bisan sin-o nga mahon-ang tao. Kamhan minsogo si Hisos ka paralitiko nga bomangon di ko. Lokoton di mo ya bentagan mo. Om-oli di ko ngaro ka lagkaw mo. ");
INSERT INTO mmn_vpl VALUES ("MT9_7","070_9_7","MAT","9","7","7","Kamhan minbangon matood ya paralitiko daw min-oli ngaro ka toong lagkaw. ");
INSERT INTO mmn_vpl VALUES ("MT9_8","070_9_8","MAT","9","8","8","Pagpakakita ka na mga kataohan ka inhinang ni Hisos nagakahaldek siran. Insaza disab niran ya Diyos kay iza ya minhatag ka gahem ka mga tao. ");
INSERT INTO mmn_vpl VALUES ("MT9_9","070_9_9","MAT","9","9","9","Pagkakamhan kaiza min-azi si Hisos dizan ka opisina nga bayranan ka mga bohis na mga karga. Kamhan ya magsokotay ka mga bohis nga inngaranan kan Matiyo ani ya nakitan ni Hisos kay nagalo-to iza dizan ka toong opisina. Kamhan minlaong si Hisos kan Matiyo nga somakop ko kanao. Kamhan mintindeg si Matiyo kay an-iba iza kan Hisos. ");
INSERT INTO mmn_vpl VALUES ("MT9_10","070_9_10","MAT","9","10","10","Kamhan ampakaen si Matiyo kan Hisos daw toong mga sinarigan. Min-intra disab dizan ya mga mataed nga magsokotay singed kan Matiyo daw ya mga iba pen nga salaan nga tao. ");
INSERT INTO mmn_vpl VALUES ("MT9_11","070_9_11","MAT","9","11","11","Ka nagakaen pen siran inpaniidan siran na mga maistro na mga Yodayo. Na, ya ngaran na mga maistro ka tinoohan na mga Yodayo ani ya Parasiyo nga hopaw ya kanirang pagtoo. Kamhan nangotana siran ka mga sakop ni Hisos nga kay ono sa ya kamazong maistro minpakigsaro ka mga magsokotay daw ya mga salaan nga tao? Ani ini ya pangotana niran kay ya batasan na mga magsokotay ka bohis onay oswagan ya bohis. ");
INSERT INTO mmn_vpl VALUES ("MT9_12","070_9_12","MAT","9","12","12","Pagpakabati ka ni Hisos ka pagmahay niran minsambag iza nagalaong nga pamolinged ini nga ya mga tao nga madazaw ya lawas wara siran magpatambal basta kay ya mga masakiten. ");
INSERT INTO mmn_vpl VALUES ("MT9_13","070_9_13","MAT","9","13","13","Magtoon kamo ka kahologan na daan pinasoyat na Diyos nga nagalaong nga ya batasan nga magakalooy ka tao madazaw iton ka kamazong batasan nga onay magahalad ka ihazep paghawag mazo kanao. Ani ini ya inlaong na Diyos. Kamhan hao nga si Hisos wara hao magkarini ka pagtabang ka mga matadeng nga tao basta kay ya mga makasasala dazaw anhinelsel siran ka kanirang mga sala. ");
INSERT INTO mmn_vpl VALUES ("MT9_14","070_9_14","MAT","9","14","14","Pagkakamhan kaiza minkarini kan Hisos ya mga sakop ni Howan nga Magbenzagay kay ampangotana siran kan Hisos nga kay ono sa wara magtoman ya kanmong mga sakop ka batasan ka pag-anget ka makaen singed kanami daw ya mga Parasiyo? ");
INSERT INTO mmn_vpl VALUES ("MT9_15","070_9_15","MAT","9","15","15","Minsambag si Hisos pagpamolinged nga ya kanaong mga sakop singed siran ka mga magkombitihay. Kamhan dizan kaniran hao ya singed ka banahen kay ka dini pen hao kaniran diri siran an-anget ka makaen. Piro may tirmino nga kaw-en hao garing ka kanaong mga sakop anipen omanget siran ka makaen kay mabeg-at ya kanirang hinawa. ");
INSERT INTO mmn_vpl VALUES ("MT9_16","070_9_16","MAT","9","16","16","Wani ya pamolinged dazaw mahagdam kamo nga ya kanaong sindo diri makaangay ka mga balaed nga tinoohan na mga Yodayo. Kay ya kanaong sindo singed iton ka bag-ong panapton. Kamhan ya mga balaed na mga Yodayo singed iton ka bado nga nadonot di. Na, pagtopak nita ka nadonot nga bado diri di gamiten ya bag-ong panapton kay basi kay-an ka paglaba ka bado ankezes ya itopakay nga bag-ong panapton. Kamhan magakagisi ya daan bado pagdobli. ");
INSERT INTO mmn_vpl VALUES ("MT9_17","070_9_17","MAT","9","17","17","Bisan ya bag-ong bino nga magabora pen diri ihalin ka daan len-anan nga kindal na kanding kay kon begketen ya ba-ba na len-anan magisi gazed iton. Kamhan an-awas ya bino daw kanogon sab ya len-anan nga magisi. Agon gamiten gazed ya bag-ong len-anan. Ani ini ya pamolinged ni Hisos ka mga tao dazaw mahagdam siran nga ya toong sindo diri makaangay ka mga balaed nga tinoohan na mga Yodayo. ");
INSERT INTO mmn_vpl VALUES ("MT9_18","070_9_18","MAT","9","18","18","Pagsindo pen naiza kaniran may isang oloolo ka singbahan na mga Yodayo nga minkarini kan Hisos. Paglohod naiza dizan kan Hisos minlaong iza nga Sinyor, bag-o pen nga napatay ya kanaong maanak nga daragahay. Kon mahimo ya beet mo ibahan mo hao ngaro ka kanaong lagkaw dazaw mabohi iza kon tagenan di mo ya toong lawas. ");
INSERT INTO mmn_vpl VALUES ("MT9_19","070_9_19","MAT","9","19","19","Kamhan min-iba si Hisos kanangiza. Nangiba disab ya toong mga sakop. ");
INSERT INTO mmn_vpl VALUES ("MT9_20","070_9_20","MAT","9","20","20","Na, ka nagapanaw pen siran ngaro may nagalopog kan Hisos nga babazi. Nagalised gazed iza kay sokad ka napolo may dowang ka toig wara magheneng ya toong pagdog-a. Na, pagsonod ka naiza ka panaw ni Hisos mintoldok iza ka pilos na toong bado. ");
INSERT INTO mmn_vpl VALUES ("MT9_21","070_9_21","MAT","9","21","21","Kay nagalaong iza ka toong hena-hena nga bisan anikay intoldokan nao ya toong bado maolian gazed ya kanaong lawas. ");
INSERT INTO mmn_vpl VALUES ("MT9_22","070_9_22","MAT","9","22","22","Na, pagtoldok naiza ka bado ni Hisos minlingi si Hisos daw minkita ka babazi. Kamhan minlaong iza nga Day, diri ko magkawied. Basta ya pagsarig mo kanao madazaw di ya lawas mo. Pagkakamhan paglaong ni Hisos madazaw di matood ya lawas na babazi. ");
INSERT INTO mmn_vpl VALUES ("MT9_23","070_9_23","MAT","9","23","23","Na, pagdateng ni Hisos ka lagkaw na oloolo nga napatazan nakitan naiza ya mga mataed nga masamok gazed ka paghaza. ");
INSERT INTO mmn_vpl VALUES ("MT9_24","070_9_24","MAT","9","24","24","Kamhan minlaong iza kaniran nga lomogwa kamong tanan kay diri kon patay ya bata. Igo ka lamang iza matorog. Kamhan inkatawhan niran si Hisos. ");
INSERT INTO mmn_vpl VALUES ("MT9_25","070_9_25","MAT","9","25","25","Pagpalogwa ka niran minseled si Hisos. Intagenan naiza ya alima na babazi. Kamhan minbangon iza. ");
INSERT INTO mmn_vpl VALUES ("MT9_26","070_9_26","MAT","9","26","26","Pagkakamhan kaiza ya panan-og mahitenged ka inhinang ni Hisos mindateng di iton dizan ka mga bariyo nga libot ka longsod nga Kapirnaom. ");
INSERT INTO mmn_vpl VALUES ("MT9_27","070_9_27","MAT","9","27","27","Na, pagpanaw ni Hisos dizan ka longsod may dowang ka tao nga minsonod kanangiza. Nabota sirang dowa. Kamhan inhawag niran si Hisos nagalaong nga iko nga kaliwat ni Dabid nga karaang hari, kaloy-i intawon kami! ");
INSERT INTO mmn_vpl VALUES ("MT9_28","070_9_28","MAT","9","28","28","Pagdateng ni Hisos ka lagkaw mindateng disab sirang dowa nga nabota. Kamhan nangotana iza kaniran nga daw antoo kamo nga makabahaw hao ka kamazong mata? Minsambag siran nga Ginoo, antoo gazed kami. ");
INSERT INTO mmn_vpl VALUES ("MT9_29","070_9_29","MAT","9","29","29","Kamhan intoldokan naiza ya kanirang mata daw nagalaong nga nadazaw di ya kamazong mata kay dakola gazed ya pagsarig mazo kanao. ");
INSERT INTO mmn_vpl VALUES ("MT9_30","070_9_30","MAT","9","30","30","Kamhan nabahaw matood ya kanirang mata. Minsogo si Hisos kaniran nga diri kamo magpanan-og ka mga tao mahitenged ka inhinang o kamazo. ");
INSERT INTO mmn_vpl VALUES ("MT9_31","070_9_31","MAT","9","31","31","Ambaza kay dizan ka mga bariyo minpanan-og gazed siran nga indazaw siran ni Hisos. Kamhan mindakola di ya ngaran ni Hisos dizan kaiton nga mga dapit. ");
INSERT INTO mmn_vpl VALUES ("MT9_32","070_9_32","MAT","9","32","32","Na, pagpanaw ka na dowang ka amaama garing kan Hisos may mga minkadakoza nga nagadara ka amaama nga diri makapanaba kay inharian iza na isang maonga. ");
INSERT INTO mmn_vpl VALUES ("MT9_33","070_9_33","MAT","9","33","33","Na, pagpaiwat ka ni Hisos ka maonga nakalitok dazon ya tao ka pagpanaba. Nangabereng ya tanang mga tao daw namaglaong nga kita nga mga kaliwatan ni Israil, sokad wara pen nita makita ya hinang nga singed kaini. ");
INSERT INTO mmn_vpl VALUES ("MT9_34","070_9_34","MAT","9","34","34","Basta kay ya mga Parasiyo min-arig siran kan Hisos. Kamhan minlaong siran nga inharian si Hisos na tag-iza ka mga maonga agon may gahem naiza ka pagbogaw ka mga maonga. ");
INSERT INTO mmn_vpl VALUES ("MT9_35","070_9_35","MAT","9","35","35","Pagkakamhan kaiza minbisita si Hisos ka bisan ono nga longsod daw bariyo kay dalem ka mga singbahan na mga Yodayo nagatoldo iza ka mga tao daw nagawali ka sindo mahitenged ka pagpasakop na Diyos ka mga tao. Indazaw sab naiza ya bisan ono nga masakit daw kaloza na lawas na tao. ");
INSERT INTO mmn_vpl VALUES ("MT9_36","070_9_36","MAT","9","36","36","Pagseleng pen ni Hisos ka mga mataed nga tao inkaloy-an naiza siran kay mataed ya kanirang kalisdanan. Kamhan waray antabang kaniran. Singed siran ka mga karniro nga nangalaag kay waray nagaaligara kaniran. ");
INSERT INTO mmn_vpl VALUES ("MT9_37","070_9_37","MAT","9","37","37","Kamhan minlaong iza ka toong mga sakop nga ya mga tao nga gosto ansakop kanao mataed siran piro talagsa ka ya mga ansindo kaniran mahitenged kanao. Kamhan singed siran ka mga homay nga hinog di. Haloag gazed ya homazan piro talagsa ka ya mga magaani. ");
INSERT INTO mmn_vpl VALUES ("MT9_38","070_9_38","MAT","9","38","38","Agon hangzoon mazo ya tag-iza ka anihen dazaw dogangan naiza pagpadara ka mga magaani ka pag-ani kaiton. ");
INSERT INTO mmn_vpl VALUES ("MT10_1","070_10_1","MAT","10","1","1","Na, pagkakamhan kaiza inpatipon ni Hisos ya toong mga sinarigan nga napolo may dowa siran. Kamhan intagan siran naiza ka gahem ka pagpadalagan ka mga maonga nga nagahari ka hinawa na mga tao. Intagan isab siran ka gahem ka pagpanbahaw ka bisan ono nga masakit daw kaloza na lawas na tao. ");
INSERT INTO mmn_vpl VALUES ("MT10_2","070_10_2","MAT","10","2","2","Na, ya ngaran na mga sinarigan ani ya apostolis. Ya primiro ani si Simon nga indagnazan kan Pidro. Sonod si Andris nga toong manghod. Kamhan ya maglomon nga si Santiago daw si Howan. Mga maanak siran ni Sibidiyo. ");
INSERT INTO mmn_vpl VALUES ("MT10_3","070_10_3","MAT","10","3","3","Kamhan si Pilipo daw si Bartolomi daw si Tomas daw si Matiyo nga magsokotay ka mga bohis. Kamhan si Tadiyo daw si Santiago nga maanak ni Alpiyo. ");
INSERT INTO mmn_vpl VALUES ("MT10_4","070_10_4","MAT","10","4","4","Kamhan si Simon nga masinopaken ka hari nga Romanhon daw si Hodas nga taga Kariyoti ani ya an-edlaw kan Hisos. Ani ini ya mga ngaran na mga sinarigan ni Hisos nga napolo may dowa siran. ");
INSERT INTO mmn_vpl VALUES ("MT10_5","070_10_5","MAT","10","5","5","Kamhan insogo siran ni Hisos nagalaong nga diri kamo mag-azi dizan ka mga dalan na mga tao nga diri kon Yodayo daw ya mga bariyo nga hel-anan na mga taga Samariya. ");
INSERT INTO mmn_vpl VALUES ("MT10_6","070_10_6","MAT","10","6","6","Magsinged di kamo hinoa ngaro ka kamazong angay nga mga kaliwatan ni Israil kay mga masinopaken siran ka Diyos. Nangalaag siran singed ka batasan na mga karniro nga bohien na tao. ");
INSERT INTO mmn_vpl VALUES ("MT10_7","070_10_7","MAT","10","7","7","Agon mangaro di kamo kaniran daw magwali nga magalaong nga mindateng di ya hari nga pinili na Diyos. ");
INSERT INTO mmn_vpl VALUES ("MT10_8","070_10_8","MAT","10","8","8","Kamhan panbahawen sab mazo ya kanirang mga masakit. Bohien mazo ya mga patay pagbalik garing ka lebeng. Dazawen mazo ya lawas na mga kagiden. Magpadalagan kamo ka mga maonga nga magahari ka hinawa na mga tao. Pagkakamhan ni Hisos pagsogo kaniran minlaong iza nga intagan kamo ka kanaong gahem nga waray bazad. Agon antabang disab kamo ka mga tao nga waray bazad. ");
INSERT INTO mmn_vpl VALUES ("MT10_9","070_10_9","MAT","10","9","9","Diri kamo maghabay ka kowarta bisan singko sintabos. ");
INSERT INTO mmn_vpl VALUES ("MT10_10","070_10_10","MAT","10","10","10","Pikit ka lawas ka lamang ya dara mazo, waray lain harominta kay ya tarabahanti kinahanglan soholan ka pagkaen. ");
INSERT INTO mmn_vpl VALUES ("MT10_11","070_10_11","MAT","10","11","11","Na, bisan ono ya datnganan mazo nga longsod kon bariyo mangita kamo ka tao nga an-abiabi kamazo. Kamhan maghela kamo dizan ka toong lagkaw hasta ka pagpanaw mazo doro ka mga laing bariyo. ");
INSERT INTO mmn_vpl VALUES ("MT10_12","070_10_12","MAT","10","12","12","Paghawag mazo ka tag-iza ka lagkaw maglaong kamo nga magmalinawen kamo ka paghela dini. ");
INSERT INTO mmn_vpl VALUES ("MT10_13","070_10_13","MAT","10","13","13","Kon ampapanik siran kamazo ibilin mazo kaniran ya magazon nga hena-hena. Piro kon diri siran anpapanik kamazo diri kamo maghatag ka hena-hena nga magazon. ");
INSERT INTO mmn_vpl VALUES ("MT10_14","070_10_14","MAT","10","14","14","Hinoa izabzab mazo ya abog dizan ka kamazong paa dazaw mahagdam siran nga silotan siran kay-an kay diri siran an-angay ka sindo na Diyos pagpanalinga. ");
INSERT INTO mmn_vpl VALUES ("MT10_15","070_10_15","MAT","10","15","15","Timan-an mazo gazed ini nga kay-an ka tirmino na Diyos ka pagbetang ka silot ka mga tao, ya silot naiza kaniran labaw pen iton ka silot ka mga taga Gomora daw taga Sodoma nga maongang longsod kawandini pen. ");
INSERT INTO mmn_vpl VALUES ("MT10_16","070_10_16","MAT","10","16","16","Manalinga kamo! Pakarohon kamo nao ka mga salaan nga tao. Singed siran ka mga maiseg nga ido. Kamhan dizan kaniran ya batasan mazo singed ka batasan na mga karniro nga waray kaiseg. Agon kinahanglan magpakalaki kamo paglikay ka batasan nga maonga dazaw diri kamo madaeg. Magbineetan kamo. ");
INSERT INTO mmn_vpl VALUES ("MT10_17","070_10_17","MAT","10","17","17","Maghamarag kamo kay dadhen kamo niran doro ka hokmanan bisan waray sala mazo. Kamhan dalem ka mga singbahan na mga Yodayo pamagbonalan isab kamo. ");
INSERT INTO mmn_vpl VALUES ("MT10_18","070_10_18","MAT","10","18","18","Pansangilan sab kamo niran dizan ka mga lain tao nga magahari ka lopa na mga Yodayo. Ani ini ya kanirang hinang kamazo kay hao ya insakopan mazo. Agon panan-ogan mazo siran daw ya mga diri kon Yodayo mahitenged kanao. ");
INSERT INTO mmn_vpl VALUES ("MT10_19","070_10_19","MAT","10","19","19","Kamhan diri kamo magkawied kon ono ya isambag mazo kaniran. Kay antandeg ya Diyos ka kamazong hena-hena kamhan panabaen mazo ya mga panaba nga garing ka Diyos. ");
INSERT INTO mmn_vpl VALUES ("MT10_20","070_10_20","MAT","10","20","20","Kay diri kon garing ka hena-hena mazo ya pagpanaba mazo kay garing gazed ka Ispirito na Diyos nga Ama mazo. ");
INSERT INTO mmn_vpl VALUES ("MT10_21","070_10_21","MAT","10","21","21","Na, wani pen ya panan-og mahitenged ka batasan na mga tao kay-an. Dadhen na isa ya toong lomon dizan ka mga laing tao dazaw patazen. Dadhen sab na ama ya toong maanak dazaw patazen. Masinopaken ya mga bata ka kanirang mga ginikanan. Kamhan garing ka sogo na bata patazen ya ginikanan. ");
INSERT INTO mmn_vpl VALUES ("MT10_22","070_10_22","MAT","10","22","22","Magakontarahan sab kamo na tanan mga tao kay hao ya insakopan mazo. Na, bisan sin-o ya makaanget ka mga pagdaegdaeg keteb ka pagkatapos naiton nga mga kalised, mahatagan iza ka bag-ong kinabohi nga diri mawara. ");
INSERT INTO mmn_vpl VALUES ("MT10_23","070_10_23","MAT","10","23","23","Kon magadaegdaegen kamo dizan ka isang bariyo domalagan kamo ngaro ka laing longsod. Panabaen ta kamo nga ka diri pen kamo makadateng ka tanan mga bariyo ka lopa nga Israil ambalik gazed hao kamazo. ");
INSERT INTO mmn_vpl VALUES ("MT10_24","070_10_24","MAT","10","24","24","Panan-ogan ta kamo nga ya tao nga nagatoon diri kon labaw iza ka toong maistro. Bisan ya oripen diri iza makapalabaw ka toong amo. ");
INSERT INTO mmn_vpl VALUES ("MT10_25","070_10_25","MAT","10","25","25","Agon ya kaazi na tao nga nagatoon singed iton ka kaazi na toong maistro. Bisan ya kaazi na oripen singed iton ka kaazi na toong amo. Hao nga kamazong maistro kon magngaran ya tao kanao kan Satanas nga tag-iza ka mga maonga labi pen sab ya pagngaran niran kamazo ka maonga. ");
INSERT INTO mmn_vpl VALUES ("MT10_26","070_10_26","MAT","10","26","26","Piro diri kamo magkahaldek kaniran kay bisan ono ya kanirang mga tinago mahagdaman gazed kay-an. ");
INSERT INTO mmn_vpl VALUES ("MT10_27","070_10_27","MAT","10","27","27","Na, ya pagsindo nao kamazo dizan ka waray laing makabati ipanan-og mazo doro ka mga tao. ");
INSERT INTO mmn_vpl VALUES ("MT10_28","070_10_28","MAT","10","28","28","Diri kamo magkahaldek ka mga tao nga ampatay ka lawas mazo kay bisan patazen niran ya lawas mazo, ya ispirito mazo diri gazed mapatay niran. Magkahaldek kamo hinoa ka Diyos kay iza ya makapatay ka kamazong ispirito daw lawas doro ka impirno. ");
INSERT INTO mmn_vpl VALUES ("MT10_29","070_10_29","MAT","10","29","29","Kamhan dakola isab ya kalooy na Diyos ka mga tao. Diri iza malipat ka bisan ono nga inhinang naiza. Bisan ya mga maza, ya pagpalit ka dowang bolos zis sintabos ka lamang. Kamhan waray isa kaniran nga maholog ka lopa kon waray pagtogot na Diyos nga kamazong Ama. ");
INSERT INTO mmn_vpl VALUES ("MT10_30","070_10_30","MAT","10","30","31","Mahal kamo ka pagkamahal na mga maza. Agon diri kamo magkahaldek ka hinang na mga tao kamazo kay aligarahen gazed kamo na Diyos. Bisan ya bohok dizan ka olo mazo, imbilang na Diyos daan kon pirang ka legas ya bohok mazo. ");
INSERT INTO mmn_vpl VALUES ("MT10_32","070_10_32","MAT","10","32","32","Na, dizan ka mga tao bisan sin-o ya ankilala kanao siran gihapon ya makilalhan nao dizan ka kanaong Ama nga nagahela daked ka langit. ");
INSERT INTO mmn_vpl VALUES ("MT10_33","070_10_33","MAT","10","33","33","Piro bisan sin-o ya anlimed kanao dizan ka mga tao, iza gihapon ya inlimed nao dizan ka kanaong Ama nga nagahela daked ka langit. ");
INSERT INTO mmn_vpl VALUES ("MT10_34","070_10_34","MAT","10","34","34","Diri kamo maghena-hena nga ya pagkarini nao dini ka kalibotan anhatag ka pagpakaangay dizan ka isa daw isa nga tao. Hinoa ya pagkarini nao ani ya sinogdan ka pagkaaway ka isa daw isa kay ya isa antoo kanao piro ya isa diri antoo kanao. ");
INSERT INTO mmn_vpl VALUES ("MT10_35","070_10_35","MAT","10","35","35","Kamhan dizan ka isang pamiliya ampakig-away ya maanak nga amaama ka toong ama. Ampakig-away sab ya maanak nga babazi ka toong ina. Ampakig-away sab ya ogangan nga babazi ka toong ogangan nga bozag. ");
INSERT INTO mmn_vpl VALUES ("MT10_36","070_10_36","MAT","10","36","36","Ya mga lomon na tao ani baza ya toong mga kaaway. Kay ya isa antoo kanao piro ya isa diri antoo kanao. ");
INSERT INTO mmn_vpl VALUES ("MT10_37","070_10_37","MAT","10","37","37","Kon anpalabaw ya tao ka toong pag-azak ka ama daw ina ka kaazak naiza kanao diri mahimo ya pagngaran naiza kanao nga Ginoo. Kon anpalabaw ya tao ka toong pag-azak ka maanak ka kaazak naiza kanao diri mahimo ya pagngaran naiza kanao nga Ginoo. ");
INSERT INTO mmn_vpl VALUES ("MT10_38","070_10_38","MAT","10","38","38","Kon diri ampadazon ya tao pagtoman ka kanaong mga sogo kay basi patazen iza diri mahimo ya pagngaran naiza kanao nga Ginoo. ");
INSERT INTO mmn_vpl VALUES ("MT10_39","070_10_39","MAT","10","39","39","Kay kon ambiza ya tao kanao dazaw diri iza patazen diri iza mahatagan ka bag-ong kinabohi. Piro kon ampadazon ya tao pagtoman ka kanaong mga sogo bisan kon patazen pen iza, mahatagan gazed iza ka bag-ong kinabohi nga diri mawara. ");
INSERT INTO mmn_vpl VALUES ("MT10_40","070_10_40","MAT","10","40","40","Ya tao nga andawat kamazo andawat sab iza kanao. Kamhan ya andawat kanao andawat isab kanangiza nga minpakarimbaba kanao. ");
INSERT INTO mmn_vpl VALUES ("MT10_41","070_10_41","MAT","10","41","41","Ya andawat ka propita kay nagapasabot iza ka matood nga garing ka Diyos mahatagan sab ya andawat ka primyo singed ka primyo nga indawat na propita. Ya andawat ka madazaw nga tao kay nagabatasan iza ka madazaw mahatagan sab ya andawat ka primyo singed ka primyo nga indawat na madazaw nga tao. ");
INSERT INTO mmn_vpl VALUES ("MT10_42","070_10_42","MAT","10","42","42","Bisan sin-o ya antigis ka kanaong sakop ka matignaw nga sapa bisan labing obos ya sakop nga intigisan, mahatagan isab ya antigis ka primyo. ");
INSERT INTO mmn_vpl VALUES ("MT11_1","070_11_1","MAT","11","1","1","Pagkakamhan ni Hisos pagsindo ka toong mga sinarigan nga napolo may dowang ka tao siran, minpasinged iza ngaro ka mga iba nga longsod na mga Yodayo kay ansindo pen iza kaniran daw ipasabot sab ya mga panaba na Diyos. ");
INSERT INTO mmn_vpl VALUES ("MT11_2","070_11_2","MAT","11","2","2","Na, si Howan nga Magbenzagay doro pen iza ka prisohan. Kamhan pagpakabati ka naiza ka mga inhinang ni Kristo impakaro naiza ya toong mga sakop kan Kristo kay ampapangotana ");
INSERT INTO mmn_vpl VALUES ("MT11_3","070_11_3","MAT","11","3","3","kon matood gazed nga iza ya pinili na Diyos kon antagad pen siran ka isa. ");
INSERT INTO mmn_vpl VALUES ("MT11_4","070_11_4","MAT","11","4","4","Minsambag si Hisos kaniran nga bomalik kamo ngaro kan Howan. Panan-ogan iza ka mga nabatian mazo dini kanao daw ya mga napaniidan. ");
INSERT INTO mmn_vpl VALUES ("MT11_5","070_11_5","MAT","11","5","5","Kay hao ya magahatag ka pagkita ka mga nabota. Indazaw sab nao ya lawas na mga napiang. Indazaw sab nao ya lawas na mga kagiden. Minhatag hao ka pagpakabati ka mga bengel. Imbohi sab nao ya mga napatay nga tao. Ipasabot sab nao ka mga pobri ya sindo mahitenged ka Diyos. ");
INSERT INTO mmn_vpl VALUES ("MT11_6","070_11_6","MAT","11","6","6","Kon diri andowadowa ya tao pagsarig kanao panaranginan gazed iza na Diyos ka madazaw. ");
INSERT INTO mmn_vpl VALUES ("MT11_7","070_11_7","MAT","11","7","7","Pagpakaoli ka na mga sakop ni Howan minpangotana si Hisos ka mga tao mahitenged kan Howan nga nagalaong nga izang mahon-a pen pagkaro mazo dizan kan Howan doro ka kamingawan daw ono ya tozo mazo? Daw anseleng kamo kontana ka tigbaw nga nagapapalidpalid ka hangin? Diri. ");
INSERT INTO mmn_vpl VALUES ("MT11_8","070_11_8","MAT","11","8","8","Daw anseleng kamo kontana ka tao nga minbado ka mga mahalen? Diri. Kay nagahela ya singed kaiton dalem ka lagkaw na hari. ");
INSERT INTO mmn_vpl VALUES ("MT11_9","070_11_9","MAT","11","9","9","Daw minkaro kamo dazaw anseleng kamo ka propita na Diyos? Matood iton. Kamhan si Howan labaw pen iza ka mga iba nga propita na Diyos. ");
INSERT INTO mmn_vpl VALUES ("MT11_10","070_11_10","MAT","11","10","10","Kay iza ya inpanan-og ni Isayas nga nagalaong nga kawandini pen minlaong ya Diyos nga may sinogo nao nga ipahon-a nao dazaw an-andam iza ka pagdateng na kanaong Maanak. Ani ini ya inlaong na Diyos mahitenged kan Howan. ");
INSERT INTO mmn_vpl VALUES ("MT11_11","070_11_11","MAT","11","11","11","Indogangan pen ni Hisos paglaong nga pasabten nao kamo nga bisan sin-o ya propita nga natao dini ka kalibotan waray nakalabaw kan Howan. Piro dini kanao koman bisan sin-o ya labing obos nga minsakop kanao labaw iza kan Howan kay ya kasabtan naiza ka kanaong mga inhinang dakola pen iton ka kasabtan ni Howan. ");
INSERT INTO mmn_vpl VALUES ("MT11_12","070_11_12","MAT","11","12","12","Na, sokad ka pagwali ni Howan hangtod koman mataed ya mga ansakop kontana kanao. Piro mataed sab ya mga ambalabag kaniran. ");
INSERT INTO mmn_vpl VALUES ("MT11_13","070_11_13","MAT","11","13","13","Kay ya daan balaed ni Moysis daw ya tanan mga propita na Diyos hangtod ka pagdateng ni Howan nagapasidaan siran pagpanan-og mahitenged ka pag-angay na Diyos ka mga tao. ");
INSERT INTO mmn_vpl VALUES ("MT11_14","070_11_14","MAT","11","14","14","Kon mintoo di kamo ka kanirang mga panan-og antoo disab kamo nga si Howan ani gazed ya singed kan Iliyas nga impanan-og niran daan nga ambalik ka. ");
INSERT INTO mmn_vpl VALUES ("MT11_15","070_11_15","MAT","11","15","15","Na, kamo nga mga manalingahay, kinahanglan nga masabtan mazo ini nga mga panaba na Diyos. ");
INSERT INTO mmn_vpl VALUES ("MT11_16","070_11_16","MAT","11","16","16","Kamhan indogangan pen ni Hisos pagsindo kaniran nagalaong nga ya mga kaliwatan na mga Yodayo singed siran ka kabataan nga nagadegza dizan ka pawa. ");
INSERT INTO mmn_vpl VALUES ("MT11_17","070_11_17","MAT","11","17","17","Kamhan ya isang tipon nagamahay ka isang tipon nga nagalaong nga nagahoyop kami ka bonabon piro wara kamo magsazaw. Nagabaya-baya isab kami paglingaw piro wara kamo maghaza. ");
INSERT INTO mmn_vpl VALUES ("MT11_18","070_11_18","MAT","11","18","18","Singed kaiton ya batasan na mga Yodayo kay izang pagkarini ni Howan nagaanget iza pagkaen, wara iza mag-inem ka makahebeg nga imnenen. Kamhan minlaong ya mga tao nga inboang si Howan na mga maonga. ");
INSERT INTO mmn_vpl VALUES ("MT11_19","070_11_19","MAT","11","19","19","Kamhan hao ya minsonod kan Howan. Nagakaen hinoa hao daw min-inem. Kamhan minbetangbetang ya mga tao kanao nga selengi, waton ya maasap daw palahebeg. Nagapan-iba sab iza ka mga magsokotay ka bohis daw ya mga iba nga tao nga makasasala. Piro nagalaong hao kamazo nga ya mga nakaangay ka sindo na Diyos siran kay mahagdam nga matadeng ya kanaming batasan ni Howan. ");
INSERT INTO mmn_vpl VALUES ("MT11_20","070_11_20","MAT","11","20","20","Kamhan minsogod si Hisos pagbaldeng ka mga taga longsod nga mga dapit nga inhinangan naiza ka mga madazaw nga kaberenganan kay wara siran magbiza ka mga maongang hinang niran bisan impakita naiza ya toong gahem paghinang naiza ka madazaw dizan kaniran. Minbaldeng iza kaniran ");
INSERT INTO mmn_vpl VALUES ("MT11_21","070_11_21","MAT","11","21","21","nagalaong nga kamo nga taga Korazin daw taga Bitsayda, magalised gazed kamo kay-an! Kay bisan minkita kamo ka kanaong inhinang nga madazaw nga kaberenganan wara kamo maghinelsel ka kamazong mga sala. Kon ipakita nao ini nga mga magazong hinang dizan ka mga taga Tiro daw taga Sidon nga mga maongang tao kawandini pen, magahinang gazed siran ka batasan niran ka paghinelsel nga ambado ka maongang bado. Kamhan ambo-bo sab siran ka alibo ka kanirang olo ka paghinelsel. ");
INSERT INTO mmn_vpl VALUES ("MT11_22","070_11_22","MAT","11","22","22","Agon kay-an ka tirmino na Diyos ka pagbetang ka silot ka mga tao ya silot naiza kamazo labaw pen iton ka silot naiza ka mga taga Tiro daw taga Sidon. ");
INSERT INTO mmn_vpl VALUES ("MT11_23","070_11_23","MAT","11","23","23","Minbaldeng sab si Hisos ka mga taga longsod nga Kapirnaom nagalaong nga kamo nga mga taga Kapirnaom, bisan nagahela hao dizan kamazo diri gazed kamo maghena-hena nga dakola ya kamazong ngaran dizan ka Diyos. Kay ipaababa gazed ya ngaran mazo kay wara kamo magbiza ka maongang hinang mazo. Madara gazed kamo baba ka inpirno. Kay kawandini pen kon inhinang nao ya mga madazaw nga kaberenganan doro ka maongang longsod nga Sodoma singed ka mga inhinang nao doro kamazo madazaw pen itong longsod, diri masonog. ");
INSERT INTO mmn_vpl VALUES ("MT11_24","070_11_24","MAT","11","24","24","Agon kay-an ka tirmino na Diyos ka pagbetang ka silot ka mga tao ya silot naiza kamazo labaw pen iton ka silot naiza ka mga taga Sodoma. ");
INSERT INTO mmn_vpl VALUES ("MT11_25","070_11_25","MAT","11","25","25","Pagkakamhan kaiza minlaong si Hisos ka toong Ama nga Diyos nga Ama nao nga tag-iza ka kalangitan daw kalibotan, palad pen kay ya mga tao nga hopaw ya kanirang pagtoo wara mo siran pasabota ka kanaong sindo bisan kon ataas ya kanirang grado. Piro ya mga ansarig kanao bisan geramay ya kanirang kahagdamanan siran ya impasabot mo ka kanaong sindo. ");
INSERT INTO mmn_vpl VALUES ("MT11_26","070_11_26","MAT","11","26","26","Madazaw kay iko ya minponto kaiton. Ani ini ya inlaong ni Hisos ka toong Ama. ");
INSERT INTO mmn_vpl VALUES ("MT11_27","070_11_27","MAT","11","27","27","Kamhan mindogang iza pagpanaba ka mga tao nagalaong nga hao ya insarigan na kanaong Ama ka tanan mga inhinang naiza. Hosto ya kasabtan naiza kanao. Hosto gihapon ya kasabtan nao kanangiza. Dizan ka bisan sin-o ya impili nao ipasabot nao ya batasan na kanaong Ama. ");
INSERT INTO mmn_vpl VALUES ("MT11_28","070_11_28","MAT","11","28","28","Kamo nga mga mabeg-at ya hena-hena ka pagkawied, somakop kamo kanao kay papahimlazen ta kamo. ");
INSERT INTO mmn_vpl VALUES ("MT11_29","070_11_29","MAT","11","29","29","Tomoo kamo ka kanaong mga sindo. Maghaod isab kamo ka kanaong batasan kay mahetek ya kanaong batasan, diri hao ampalabaw kamazo. Kamhan malinaw ya kamazong hinawa. ");
INSERT INTO mmn_vpl VALUES ("MT11_30","070_11_30","MAT","11","30","30","Kay masazon ka ya pagtoman ka kanaong mga sindo, diri kon malised ya paghaod ka kanaong batasan. Ani ini ya pagsindo ni Hisos ka mga tao. ");
INSERT INTO mmn_vpl VALUES ("MT12_1","070_12_1","MAT","12","1","1","Na, may isang ka Sabado dizan ka homazan nagaazi si Hisos. Na, ya Sabado ani ya tigpahimlay na mga Yodayo. Kamhan imbengtas ya toong mga sinarigan. Agon nagapangitlo siran ka mga homay kay kanen niran. ");
INSERT INTO mmn_vpl VALUES ("MT12_2","070_12_2","MAT","12","2","2","Pagpakapaniid ka na mga Parasiyo kanin Hisos minbaheg siran nagalaong nga paka selengi! Minlapas gazed ya kanmong mga sakop ka balaed na Diyos kay koman nga tigpahimlay min-ani baza siran ka homay. ");
INSERT INTO mmn_vpl VALUES ("MT12_3","070_12_3","MAT","12","3","3","Minsambag si Hisos nga mahagdam kamo daan ka inhinang ni Dabid nga karaang tao na mga Yodayo. Kawandini pen imbengtas iza daw ya toong kaibahan kay inlopog siran na kanirang mga kaaway. ");
INSERT INTO mmn_vpl VALUES ("MT12_4","070_12_4","MAT","12","4","4","Agon pagdateng niran ka lagkaw nga pangamozoanan ka Diyos nangazo siran ka makaen. Kamhan minkaen siran ka tinapay nga inhalad daan ka Diyos. Bisan ya mga pari anikay ankaen kaitong mga tinapay, wara si Dabid maglapas ka balaed na Diyos ka pagkaen naiza. Kay ya pagtabang ka kinahanglanen na tao ani say labaw ka kamazong mga balaed nga mabeg-at. ");
INSERT INTO mmn_vpl VALUES ("MT12_5","070_12_5","MAT","12","5","5","Daw wara kamo magbasa ka daan balaed na Diyos nagalaong nga dizan ka dakolang lagkaw nga pangamozoanan ka Diyos kada aldaw nga tigpahimlay nagatarabaho ya mga pari pagpan-ihaw ka mga ihaladay ka Diyos. Bisan nagatarabaho siran ka aldaw nga tigpahimlay wara siran maglapas ka balaed na Diyos. ");
INSERT INTO mmn_vpl VALUES ("MT12_6","070_12_6","MAT","12","6","6","Sabten mazo ini nga mindateng di hao dini kamazo. Labaw hao ka pagkalabaw na mga balaed mazo mahitenged ka dakolang lagkaw nga pangamozoanan ka Diyos. ");
INSERT INTO mmn_vpl VALUES ("MT12_7","070_12_7","MAT","12","7","7","Wani ya kanaong sindo nga ya batasan nga nagakalooy ka tao madazaw iton ka kamazong batasan onay nga magahalad ka ihazep paghawag mazo ka Diyos. Piro wara gazed kamo makasabot kaini nga sindo kay kazina mindaetdaet kamo ka kanaong mga sakop bisan waray sala ka pagpangitlo niran ka mga homay. ");
INSERT INTO mmn_vpl VALUES ("MT12_8","070_12_8","MAT","12","8","8","Na, hao ya anponto kon ono ya madazaw nga hinang na tao ka aldaw nga tigpahimlay kay hao ya minhon-a ka bisan sin-o nga mahon-ang tao. Ani ini ya sambag ni Hisos ka mga Parasiyo. ");
INSERT INTO mmn_vpl VALUES ("MT12_9","070_12_9","MAT","12","9","9","Pagkakamhan kaiza minlargo si Hisos ngaro ka singbahan na mga Yodayo. Kamhan minseled iza. ");
INSERT INTO mmn_vpl VALUES ("MT12_10","070_12_10","MAT","12","10","10","Na, dizan disab may tao nga diri mahingas ya pikas nga toong alima. Kamhan nagapaniid ya mga maistro ka tinoohan na mga Yodayo kan Hisos kay awazen iza niran kontana. Agon nangotana siran kan Hisos nga ya balaed na Diyos mahitenged ka aldaw nga tigpahimlay daw itogot ka pagbahaw ka lawas na tao kon diri? ");
INSERT INTO mmn_vpl VALUES ("MT12_11","070_12_11","MAT","12","11","11","Minsambag si Hisos nga simpan may kamazong bohien nga karniro. Kamhan naholog iton dalem ka gahong. Na, bisan aldaw nga tigpahimlay kaiza batonon mazo gazed ya bohien nga naholog dalem ka gahong. ");
INSERT INTO mmn_vpl VALUES ("MT12_12","070_12_12","MAT","12","12","12","Na, mahal gazed ya tao ka pagkamahal na bohien. Agon gosto ya Diyos nga antabang kita ka magakinahanglan ka aldaw nga tigpahimlay. ");
INSERT INTO mmn_vpl VALUES ("MT12_13","070_12_13","MAT","12","13","13","Kamhan minsogo iza ka tao nga diri mahingas ya alima nga Loy, henaten mo ya alima mo. Kamhan inhenat matood naiza ya toong alima kay minbalik dazon ya kabaskeg na toong alima singed ka karig-en na isang alima. ");
INSERT INTO mmn_vpl VALUES ("MT12_14","070_12_14","MAT","12","14","14","Pagkakamhan kaiza minpanaw dazon ya mga Parasiyo dazaw ansabot siran nga patazen niran si Hisos. ");
INSERT INTO mmn_vpl VALUES ("MT12_15","070_12_15","MAT","12","15","15","Mahagdam si Hisos ka kanirang sabot agon minpanaw iza iba gihapon ya mga mataed nga tao. Kamhan minbahaw iza kanirang tanan. ");
INSERT INTO mmn_vpl VALUES ("MT12_16","070_12_16","MAT","12","16","16","Minsogo sab iza kaniran nga diri kamo magpanan-og ka mga tao mahitenged kanao. ");
INSERT INTO mmn_vpl VALUES ("MT12_17","070_12_17","MAT","12","17","17","Na, ya batasan ni Hisos ani ya nakatoman ka panan-og ni Isayas nga karaang propita na Diyos. Kay kawandini pen nagalaong iza nga ");
INSERT INTO mmn_vpl VALUES ("MT12_18","070_12_18","MAT","12","18","18","wani ya inlaong na Diyos mahitenged ka batasan ni Hiso Kristo nagalaong nga selengi mazo ya kanaong sinogo nga impili nao daw naazakan. Nakasaza gazed iza kanao. Anhatag hao kanangiza ka kanaong Ispirito. Kamhan ipasabot naiza ka mga diri kon Yodayo nga diri siran masilotan ka kanirang mga sala kon antoo siran kanangiza. ");
INSERT INTO mmn_vpl VALUES ("MT12_19","070_12_19","MAT","12","19","19","Ya toong batasan pagpanaba ka mga tao diri magalalis, diri kon maiseg ya toong panaba. Dizan ka mga dalan na longsod diri iza andakola ka toong saba. ");
INSERT INTO mmn_vpl VALUES ("MT12_20","070_12_20","MAT","12","20","20","Antabang iza ka tao nga maloza di ya pagsarig kay diri naiza barien ya tigbaw nga baliko di. Diri naiza parengen ya segà nga hapit di mapareng. Magapadazon iza ka toong tarabaho keteb ka tirmino na Diyos ka pagsilot ka mga diri antoo kanangiza. ");
INSERT INTO mmn_vpl VALUES ("MT12_21","070_12_21","MAT","12","21","21","Kamhan iza ya magatagadan na tanan mga tao. Ani ini ya daan insoyat ni Isayas mahitenged ka batasan ni Kristo. ");
INSERT INTO mmn_vpl VALUES ("MT12_22","070_12_22","MAT","12","22","22","Pagkakamhan kaiza may mga minkadakoza nga nagaated kan Hisos ka tao nga nabota daw amang kay inharian iza na maonga. Imbahawan iza ni Hisos. Kamhan nakalitok matood ya tao hasta makakita dazon. ");
INSERT INTO mmn_vpl VALUES ("MT12_23","070_12_23","MAT","12","23","23","Kamhan nangabereng gazed ya mga tao daw nagalaong nga si Hisos daw iza matood ya kaliwat ni Dabid nga kantang karaan? ");
INSERT INTO mmn_vpl VALUES ("MT12_24","070_12_24","MAT","12","24","24","Na, pagpakabati ka na mga Parasiyo minsora siran paglaong nga si Hisos may gahem naiza ka pagbogaw ka mga maonga kay inharian iza ni Satanas inngaranan sab kan Bilsibol nga tag-iza ka mga maonga. ");
INSERT INTO mmn_vpl VALUES ("MT12_25","070_12_25","MAT","12","25","25","Mahagdam si Hisos ka kanirang hena-hena agon minsambag iza kaniran nga pamolinged ini nga kon awazen na hari ya toong mga sinogo mapildi gazed ya hari. Kon ampakig-away ya isa daw isa dizan ka isang longsod mapildi ya longsod. Kon ampakig-away ya isa daw isa nga lomon dizan ka isang pamiliya mapildi isab ya pamiliya. ");
INSERT INTO mmn_vpl VALUES ("MT12_26","070_12_26","MAT","12","26","26","Agon kon anbogaw si Satanas ka toong kaogaringen nga ispirito dizan ka tao mapildi si Satanas. ");
INSERT INTO mmn_vpl VALUES ("MT12_27","070_12_27","MAT","12","27","27","Minsazep kamo kay bisan ya mga sakop mazo nga mga Parasiyo pagpabogaw niran ka mga maonga mahagdam siran nga garing ka Diyos ya kanirang gahem, diri kon garing ka Bilsibol. Agon ansombong siran kamazo ka bakak. ");
INSERT INTO mmn_vpl VALUES ("MT12_28","070_12_28","MAT","12","28","28","Minsazep gazed kamo kay ya Madazaw nga Ispirito na Diyos ani ya mintabang kanao ka pagpabogaw ka mga maonga. Kamhan ipasabot di na Diyos kamazo nga dini kamazo mindateng di gazed ya hari nga pinili na Diyos. ");
INSERT INTO mmn_vpl VALUES ("MT12_29","070_12_29","MAT","12","29","29","Pamolinged ini nga dizan ka lagkaw na kesgan nga tao kinahanglan ektan ya kesgan nga tao anipen kawaten ya toong mga betang. Singed si Satanas ka kesgan nga tag-iza ka lagkaw. Hao kay nakadaeg kan Satanas. Agon papanawen disab nao ya toong mga sinogo dizan ka tao. ");
INSERT INTO mmn_vpl VALUES ("MT12_30","070_12_30","MAT","12","30","30","Indogangan pen ni Hisos paglaong ka mga Parasiyo nga kamo nga mga Parasiyo, magtaremdem kamo nga ya mga diri ansakop kanao ani ya ansopak kanao. Ya mga diri antabang ka mga tao ka pagsakop kanao ani ya nakalaag ka mga tao. ");
INSERT INTO mmn_vpl VALUES ("MT12_31","070_12_31","MAT","12","31","31","Bisan ono ya sala na mga tao daw ya pagpanaba niran ka maonga mahitenged ka Diyos, kon anhinelsel siran pasaylohon siran na Diyos. Piro ya pagpanaba niran ka maonga mahitenged ka Madazaw nga Ispirito na Diyos, diri gazed pasaylohon na Diyos ya kanirang mga sala. ");
INSERT INTO mmn_vpl VALUES ("MT12_32","070_12_32","MAT","12","32","32","Bisan sin-o ya ampanaba ka maonga mahitenged kanao, kon anhinelsel iza pasaylohon nao. Piro bisan sin-o ya ampanaba ka maonga mahitenged ka Madazaw nga Ispirito na Diyos, diri gazed iza pasaylohon na Diyos, bisan koman bisan kawanihen ka diri makapasaylo ya Diyos. Ani ini ya inpanaba ni Hisos kay minlaong ya mga Parasiyo nga inharian si Hisos na mga maonga. ");
INSERT INTO mmn_vpl VALUES ("MT12_33","070_12_33","MAT","12","33","33","Kamhan indogangan pen ni Hisos pagpamolinged ka mga Parasiyo nagalaong nga ya liwaan nga waray kasakit mamonga iton ka madazaw nga bonga. Piro ya liwaan nga masakiten diri mamonga ka madazaw nga bonga. Ya bonga na liwaan ani ya makilalhan ka kahimtang na liwaan. ");
INSERT INTO mmn_vpl VALUES ("MT12_34","070_12_34","MAT","12","34","34","Singed iton kamazo. Nagabatasan isab kamo singed ka mga halas nga polos maonga ya batasan. Diri kamo mahagdam pagpanaba ka madazaw kay maonga ya kamazong beet. Kay bisan ono ya panaba na tao garing iton ka toong hena-hena. ");
INSERT INTO mmn_vpl VALUES ("MT12_35","070_12_35","MAT","12","35","35","Kon madazaw ya toong hena-hena, madazaw isab ya toong mga panaba. Kon maonga ya toong hena-hena, maonga gihapon ya toong mga panaba. ");
INSERT INTO mmn_vpl VALUES ("MT12_36","070_12_36","MAT","12","36","36","Sabten mazo ini nga kay-an ka pagdateng na tirmino na Diyos ka pagsilot ka mga tao silotan matood naiza ya mga tao nga minpanaba ka mga panaba nga waray polos. ");
INSERT INTO mmn_vpl VALUES ("MT12_37","070_12_37","MAT","12","37","37","Kay kon madazaw ya mga panaba mazo diri kamo masilotan piro kon maonga ya mga panaba mazo silotan matood kamo. ");
INSERT INTO mmn_vpl VALUES ("MT12_38","070_12_38","MAT","12","38","38","Pagkakamhan kaiza may inlaong pen na mga maistro ka tinoohan na mga Yodayo daw ya mga Parasiyo. Minlaong siran kan Hisos nga Maistro, ipakita mo kanami ya timaan dazaw mahagdam kami nga garing iko matood ka Diyos. ");
INSERT INTO mmn_vpl VALUES ("MT12_39","070_12_39","MAT","12","39","39","Minsambag si Hisos nga ampangazo kamo kanao ka timaan kay mga salaan sa kamo nga tao. Imbizaan disab mazo ya pagtoo mazo ka matood nga Diyos. Anikay timaan kamazo ya singed kan Zona nga karaang propita na Diyos. ");
INSERT INTO mmn_vpl VALUES ("MT12_40","070_12_40","MAT","12","40","40","Kay kay-an ya pagkabohi nao pagbalik garing ka lebeng singed iton ka pagkabohi ni Zona garing dalem ka tinai na dakolang isda. Kay kawandini pen tolong ka aldaw ya toong paghela dalem ka tinai na dakolang isda. Na, kay-an ka pagkapatay nao tolong ka aldaw gihapon ya kanaong paghela dalem ka lebnganan. Kamhan mabohi hao pagbalik. ");
INSERT INTO mmn_vpl VALUES ("MT12_41","070_12_41","MAT","12","41","41","Pagwali ni Zona ka mga taga Ninibi nga daan longsod minhinelsel siran ka kanirang mga sala. Agon kay-an ka paghokom na Diyos ka mga tao ya mga taga Ninibi ani ya ansombong kamazo kay bisan mindateng di hao kamazo wara kamo magbiza ka kamazong mga sala bisan labaw ya kanaong pagwali ka pagwali na karaang propita nga si Zona. ");
INSERT INTO mmn_vpl VALUES ("MT12_42","070_12_42","MAT","12","42","42","May karaang rayna isab nga taga timogan iza. Kamhan aro ya toong pagpanaw ka pagpanalinga ka sindo na karaang hari nga si Salomon. Agon ansombong iza kamazo kay-an ka paghokom na Diyos ka mga tao kay bisan labaw ya kanaong pagsindo ka pagkalabaw na pagsindo ni Salomon wara kamo magpanalinga kanao. ");
INSERT INTO mmn_vpl VALUES ("MT12_43","070_12_43","MAT","12","43","43","Kamo nga mga Parasiyo, ya batasan mazo magadogang gazed ya kamazong pagpakasala. Singed kamo ka tao nga minpanaw di ya maongang ispirito garing kanangiza kay ankaro ka banwa. Kamhan magapanawpanaw ya maonga kay ampangita ka hel-anan. Kamhan waray datnganan naiza ");
INSERT INTO mmn_vpl VALUES ("MT12_44","070_12_44","MAT","12","44","44","agon anhena-hena iza nga an-oli di hao ka tao. Pagdateng naiza ka tao ya beet na tao singed iton ka lagkaw nga inhingloan di hasta wara di isab ya magahari ka tao. ");
INSERT INTO mmn_vpl VALUES ("MT12_45","070_12_45","MAT","12","45","45","Kamhan minpanaw ya maonga kay ankawa iza ka toong mga iba nga pito siran nga maonga gazed. Kamhan sirang tanan ya magahari ka tao. Agon nagadogang gazed ya tao ka pagpakasala. Kamo ya singed kaiton nga tao kay bisan minsindo kami ni Howan kamazo diri kamo ampahari ka Ginoo dalem ka beet mazo. ");
INSERT INTO mmn_vpl VALUES ("MT12_46","070_12_46","MAT","12","46","46","Pagpanaba ka ni Hisos kaniran dizan ka lagkaw impalogwa kontana iza na toong ina daw mga lomon kay bali lamang siran ka gawas. ");
INSERT INTO mmn_vpl VALUES ("MT12_47","070_12_47","MAT","12","47","47","Kamhan inpakahagdam iza na isang tao nga Nong, bali ka gawas ya kanmong ina daw mga lomon. Gosto siran anlaong kanmo. ");
INSERT INTO mmn_vpl VALUES ("MT12_48","070_12_48","MAT","12","48","48","Minsambag si Hisos nga daw sin-o sa ya kanaong ina daw ya mga lomon? ");
INSERT INTO mmn_vpl VALUES ("MT12_49","070_12_49","MAT","12","49","49","Minsingyas dazon si Hisos ka toong alima ngaro ka dapit na toong mga sinarigan. Kamhan minlaong iza nga siran ya kanaong ina daw kanaong mga lomon. ");
INSERT INTO mmn_vpl VALUES ("MT12_50","070_12_50","MAT","12","50","50","Kay bisan sin-o ya nagatoman ka mga sogo na kanaong Ama nga nagahela daked ka langit ani gazed ya kanaong ina daw lomon. ");
INSERT INTO mmn_vpl VALUES ("MT13_1","070_13_1","MAT","13","1","1","Na, pagkakay-an kaiza nga aldaw minlogwa si Hisos ka lagkaw kamhan minlo-to iza dizan ka baybazen na danaw. ");
INSERT INTO mmn_vpl VALUES ("MT13_2","070_13_2","MAT","13","2","2","Masara gazed nga kataed ya mga tao nga minlibot kanangiza agon minleen iza ka baloto kay dazaw anlo-to iza dalem kaiza. Kamhan dizan ka baybazen nanalinga ya tanan mga tao. ");
INSERT INTO mmn_vpl VALUES ("MT13_3","070_13_3","MAT","13","3","3","Kamhan mintoldo iza kaniran ka mga mataed nga pamolinged nagalaong nga wani ya pamolinged ka nagasabwag. Na, may isang aldaw nga minpanaw ya tao ngaro ka toong oma kay ampanabwag iza ka binhi nga homay. ");
INSERT INTO mmn_vpl VALUES ("MT13_4","070_13_4","MAT","13","4","4","Pagpanabwag naiza ka mga binhi may mga natanak dizan ka dalan. Kamhan inpanoktok na mga manokmanok. ");
INSERT INTO mmn_vpl VALUES ("MT13_5","070_13_5","MAT","13","5","5","Pagpanabwag pen na tao may mga natanak isab dizan ka kabatohan. Kamhan mintobo dazon iton kay diri kon ararem ya lopa. ");
INSERT INTO mmn_vpl VALUES ("MT13_6","070_13_6","MAT","13","6","6","Kamhan pagkaataas na sega nangalaza dazon sirang tanan. Kamhan nangapatay kay diri siran makagamot ka ararem. ");
INSERT INTO mmn_vpl VALUES ("MT13_7","070_13_7","MAT","13","7","7","May mga natanak disab dizan ka lopa nga nanhela pen ya mga liso na sagbet. Pagtobo na binhi mindengan isab ya sagbet nga dogihen. Kamhan inhal-ong gazed na sagbet ya mga tanem. ");
INSERT INTO mmn_vpl VALUES ("MT13_8","070_13_8","MAT","13","8","8","May natanak disab dizan ka lopa nga magazon. Kamhan mintobo iton daw mataed ya ohay. May mga nangaohay ka isang ka gatos. May mga nangaohay ka kan-eman. May mga nangaohay ka katloan. Ani ini ya pamolinged ka nagasabwag. ");
INSERT INTO mmn_vpl VALUES ("MT13_9","070_13_9","MAT","13","9","9","Kamhan minsogo si Hisos kaniran nga kamo nga mga manalingahay, sabten mazo ini nga pamolinged ka nagasabwag. ");
INSERT INTO mmn_vpl VALUES ("MT13_10","070_13_10","MAT","13","10","10","Pagkakamhan mingkarini kan Hisos ya toong mga sinarigan kay ampangotana siran nga kay ono sang nagapasagisagi sa ko ka kanmong mga panaba ka mga tao? ");
INSERT INTO mmn_vpl VALUES ("MT13_11","070_13_11","MAT","13","11","11","Minsambag si Hisos nga ipasabot na Diyos kamazo ya mga tinago mahitenged ka pagpadazon naiza ka toong tarabaho. Piro dizan ka mga mataed nga tao wara kaniran ipasabot na Diyos ya toong mga tinago ");
INSERT INTO mmn_vpl VALUES ("MT13_12","070_13_12","MAT","13","12","12","kay bisan sin-o ya antoon ka mga intoldo na Diyos padogangan pen na Diyos ya toong kasabtan. Kamhan ya tao nga diri antoon kaw-en na Diyos ya toong geramay nga kasabtan. ");
INSERT INTO mmn_vpl VALUES ("MT13_13","070_13_13","MAT","13","13","13","Na, pagtoldo nao kaniran nagapamolinged hao kamhan bisan magaseleng siran ka kanaong hinang diri siran makasabot. Bisan manalinga siran ka kanaong sindo diri siran makasabot kon ono ya kahologan. ");
INSERT INTO mmn_vpl VALUES ("MT13_14","070_13_14","MAT","13","14","14","Ya kanirang batasan ani ya nakatoman ka panan-ogon ni Isayas nga karaang propita nga nagalaong nga pagdateng ni Kristo anpanalinga ya mga Yodayo ka toong sindo piro diri siran makasabot. Anseleng isab siran ka toong mga inhinang piro diri isab siran makasabot. ");
INSERT INTO mmn_vpl VALUES ("MT13_15","070_13_15","MAT","13","15","15","Kay singed ka ingahi niran ya kanirang otok dazaw diri siran makasabot. Insampenan disab niran ya kanirang talinga dazaw diri siran makabati. Impizeng disab niran ya kanirang mga mata dazaw diri siran makakita. Kay diri siran maazak nga ambiza ka kanirang mga sala agon diri siran tagan na Diyos ka magazong hena-hena. Ani ini ya insoyat ni Isayas. ");
INSERT INTO mmn_vpl VALUES ("MT13_16","070_13_16","MAT","13","16","16","Kamhan minlaong si Hisos nga kamo nga kanaong mga sinarigan, madazaw ya pagpanarangin na Diyos kamazo kay kamo ya minkita ka kanaong mga inhinang. Nakapanalinga disab kamo ka kanaong sindo. ");
INSERT INTO mmn_vpl VALUES ("MT13_17","070_13_17","MAT","13","17","17","Timan-an mazo gazed ini nga mataed ya mga karaang propita na Diyos daw ya mga karaang tao nga matadeng nga gosto siran anseleng ka kanaong mga hinang singed ka inselengan mazo dini kanao koman piro wara itogot na Diyos kaniran. Gosto sab siran ampanalinga ka kanaong sindo singed ka nabatian mazo dini kanao koman piro wara itogot na Diyos kaniran. ");
INSERT INTO mmn_vpl VALUES ("MT13_18","070_13_18","MAT","13","18","18","Na, manalinga kamo naa kay wani ya paghilwas ka pamolinged ka nagasabwag. ");
INSERT INTO mmn_vpl VALUES ("MT13_19","070_13_19","MAT","13","19","19","Ya mga binhi nga natanak dizan ka dalan ani ya singed ka manalingahay ka sindo mahitenged ka pagpasakop na Diyos ka mga tao piro diri iza makasabot. Kamhan andateng dazon si Satanas kay kaw-en naiza ya sindo nga nabatian naiton nga tao. ");
INSERT INTO mmn_vpl VALUES ("MT13_20","070_13_20","MAT","13","20","20","Kamhan ya mga binhi nga natanak dizan ka kabatohan ani ya singed ka manalingahay nga nakaangay ka sindo mahitenged kanao kamhan mintoo dazon. ");
INSERT INTO mmn_vpl VALUES ("MT13_21","070_13_21","MAT","13","21","21","Ka wara pen madogay magaawazen gazed iza na mga tao kay minsakop di iza kanao agon bizaan dazon naiza ya toong pagtoo kanao kay ababa ka ya toong pag-anget ka kalised. ");
INSERT INTO mmn_vpl VALUES ("MT13_22","070_13_22","MAT","13","22","22","Kamhan ya mga binhi nga natanak dizan ka lopa nga nanhela pen ya mga liso na sagbet ani ya singed ka isa pen nga manalingahay. Kay nagapanalinga gazed iza ka sindo mahitenged kanao. Kamhan nawied iza daw ono ya toong panginabohi. Ganahan sab iza ka kowarta. Agon waray polos ya sindo kay singed ka nalipat dazon ya manalingahay. ");
INSERT INTO mmn_vpl VALUES ("MT13_23","070_13_23","MAT","13","23","23","Basta kay ya mga binhi nga napegas dizan ka lopa nga magazong tamnanan ani ya singed ka mga manalingahay ka sindo mahitenged kanao daw nakasabot gihapon. Kamhan singed ka nangaohay ya isa ka isang ka gatos. Nangaohay ya iba ka kan-eman. Nangaohay isab ya iba pen ka katloan. Ani ini ya paghilwas ka pamolinged ka tao nga nagasabwag ka binhi. ");
INSERT INTO mmn_vpl VALUES ("MT13_24","070_13_24","MAT","13","24","24","Mindogang si Hisos paglaong kaniran nga wani pen ya pamolinged mahitenged ka pagpadazon na Diyos ka toong tarabaho. Singed iton ka tao nga nagapegas ka magazong binhi dizan ka toong oma nga magazong tamnanan. ");
INSERT INTO mmn_vpl VALUES ("MT13_25","070_13_25","MAT","13","25","25","Na, pagpakatorog ka na mga tao mindateng di ya kaaway. Kamhan nagasabwag iza ka mga liso na sagbet dizan ka tamnanan na tao. Kamhan minpanaw dazon ya kaaway. ");
INSERT INTO mmn_vpl VALUES ("MT13_26","070_13_26","MAT","13","26","26","Pagpakatobo ka na mga tanem daw minsogod pagboswak ya mga ohay waton disab baza ya mga sagbet. ");
INSERT INTO mmn_vpl VALUES ("MT13_27","070_13_27","MAT","13","27","27","Kamhan ya mga sinogo na tag-iza mindateng di kanangiza daw nangotana nga Sinyor, polos madazaw ya impegas nami dizan ka oma. Agon hain sa garing ya nakasaket nga sagbet? ");
INSERT INTO mmn_vpl VALUES ("MT13_28","070_13_28","MAT","13","28","28","Minsambag iza nga ya kaaway kanao ani ya minhinang kaiton. Nangotana ya toong mga sinogo nga daw bognoton nami ya mga sagbet? ");
INSERT INTO mmn_vpl VALUES ("MT13_29","070_13_29","MAT","13","29","29","Minsambag ya tag-iza nga pabet-an lamang iton kay basi pamognoton ka gihapon ya mga homay iba ka mga sagbet. ");
INSERT INTO mmn_vpl VALUES ("MT13_30","070_13_30","MAT","13","30","30","Pasoligen pen lamang pagdengan kay kay-an ka tig-ani anipen sogoon nao ya mga tarabahanti nga ipabognot ya mga sagbet paghon-a daw pamegketen kamhan sonogon. Kamhan ya mga homay ipaani naa anipen ibetang dizan ka dapoganan. ");
INSERT INTO mmn_vpl VALUES ("MT13_31","070_13_31","MAT","13","31","31","Na, mindogang pen si Hisos paglaong kaniran nga wani pen ya pamolinged mahitenged ka pagpaoswag na Diyos ka toong paghari dini ka mga tao. Singed iton ka isang bolos nga liso inngaranan ka mostasa. Kamhan intanem na tao dizan ka toong oma. ");
INSERT INTO mmn_vpl VALUES ("MT13_32","070_13_32","MAT","13","32","32","Bisan geramay iton ka bisan ono nga liso, ka pagsolig di mahinang iton ka dakolang liwaan kay doro ka lopa nga Yoda ya mostasa liwaan iton nga opat nga ka mitros ya kaataas. Agon magapogad ya mga manokmanok dizan ka mga sap-ay naiton. ");
INSERT INTO mmn_vpl VALUES ("MT13_33","070_13_33","MAT","13","33","33","Na, mindogang si Hisos paglaong kaniran nga wani pen ya pamolinged mahitenged ka pagpasakop na Diyos ka mga tao. Singed iton ka ipasoligay ka tinapay. Insaktan na babazi ka ipasoligay ya tolong ka takes nga harina. Kamhan minsolig iton kadakola gazed ya pagsolig. ");
INSERT INTO mmn_vpl VALUES ("MT13_34","070_13_34","MAT","13","34","34","Ani ini ya mga pamolinged ni Hisos dizan ka mga mataed nga tao. Waray lain toldoan naiza kaniran. ");
INSERT INTO mmn_vpl VALUES ("MT13_35","070_13_35","MAT","13","35","35","Kamhan mintoman di ya inlaong na karaang propita na Diyos nga nagalaong nga pagpanaba ni Kristo ka mga tao gamiten naiza ya mga pamolinged pagsindo naiza kaniran ka mga tinago nga wara pen kahagdami sokad kawandini pen ka sinogdan pen na kalibotan hangtod koman. Ani ini ya inlaong na karaang propita. ");
INSERT INTO mmn_vpl VALUES ("MT13_36","070_13_36","MAT","13","36","36","Pagkakamhan ni Hisos pagsindo ka mga tao minbelag iza kaniran kay anseled iza ka lagkaw. Minsonod isab kanangiza ya toong mga sinarigan kay ampangotana siran nga Nong, pasabten mo kami kaiton nga pamolinged mahitenged ka mga sagbet dizan ka oma nga inlaong mo kazina. ");
INSERT INTO mmn_vpl VALUES ("MT13_37","070_13_37","MAT","13","37","37","Minsambag si Hisos nga wani ya paghilwas kaiton nga pamolinged nao kamazo nga hao ya singed ka tao nga nagapegas ka mga magazong binhi. ");
INSERT INTO mmn_vpl VALUES ("MT13_38","070_13_38","MAT","13","38","38","Kamhan ya tamnanan ani ya kalibotan. Ya mga sakop na Diyos singed siran ka magazong binhi. Ya mga sagbet ani ya mga tao nga sakop ni Satanas. ");
INSERT INTO mmn_vpl VALUES ("MT13_39","070_13_39","MAT","13","39","39","Kamhan ya kaaway nga minsabwag ka mga sagbet ani si Satanas. Ya pag-ani ani ya kataposan nga panahon dini ka kalibotan. Ya mga mag-aani ani ya mga sinogo na Diyos nga tagalangit. ");
INSERT INTO mmn_vpl VALUES ("MT13_40","070_13_40","MAT","13","40","40","Basta kay kay-an ka kataposan nga panahon ya mga sakop ni Satanas singed siran ka mga sagbet nga magabognoton daw sonogon. Ani ini ya pagkapatay na mga maongang tao kay-an ka kataposan na mga panahon. ");
INSERT INTO mmn_vpl VALUES ("MT13_41","070_13_41","MAT","13","41","41","Kay hao nga minhon-a ka bisan sin-o nga mahon-ang tao, pakarohon nao ya kanaong mga sinogo nga taga langit dazaw kaw-en niran ya tanan mga magtintalay daw ya tanan mga anhinang ka maonga. Kamhan pabelagen siran dizan ka mga sakop na Diyos. ");
INSERT INTO mmn_vpl VALUES ("MT13_42","070_13_42","MAT","13","42","42","Kamhan ipanimbag doro ka impirno. Kamhan magapangageet siran ka kanirang ngipen ka paghaza. ");
INSERT INTO mmn_vpl VALUES ("MT13_43","070_13_43","MAT","13","43","43","Kamhan ya mga matadeng nga tao may kasiraw niran singed ka kasiraw na sega daked ka hel-anan na kanirang Ama. Na, kamo nga mga manalingahay, magtaremdem kamo ka insindo nao kamazo. ");
INSERT INTO mmn_vpl VALUES ("MT13_44","070_13_44","MAT","13","44","44","Kamhan nagapamolinged pen si Hisos ka toong mga sinarigan nga ya pagkamahal na sindo mahitenged kanao singed iton ka pagkamahal na bolawan nga inlebeng dizan ka isang oma. Kamhan nakitan di na tao. Kamhan inlebeng naiza iton pagbalik. Kamhan dakola gazed ya toong kasaza. Kamhan min-oli di iza kay impamaligza ya tanan mga betang kay paliten naiza ini nga oma. ");
INSERT INTO mmn_vpl VALUES ("MT13_45","070_13_45","MAT","13","45","45","Na, nagapamolinged pen si Hisos kaniran nga ya pagkamahal na sindo mahitenged kanao singed iton ka magbaligzaay ka mga motza. ");
INSERT INTO mmn_vpl VALUES ("MT13_46","070_13_46","MAT","13","46","46","Pagpakakita ka naiza ka isang motza nga masarang ka mahal impamaligza naiza ya tanan mga betang dazaw paliten ini nga motza. ");
INSERT INTO mmn_vpl VALUES ("MT13_47","070_13_47","MAT","13","47","47","Na, nagapamolinged pen si Hisos kaniran nga ya pagpadazon na Diyos ka toong tarabaho singed iton ka baling nga inbeklad di doro ka dagat. Kamhan mataed ya mga klasi na isda nga nabalingan. ");
INSERT INTO mmn_vpl VALUES ("MT13_48","070_13_48","MAT","13","48","48","Pagkapono ka na baling imbohat na mangisdaay ngaro ka baybazen. Kamhan impili niran ya mga isda nga magazon kay impanleen dizan ka seldanan niran. Kamhan ya mga maonga nga isda impanimbag niran ngaro pagbalik ka dagat. ");
INSERT INTO mmn_vpl VALUES ("MT13_49","070_13_49","MAT","13","49","49","Ani ini ya kahimtang na mga tao kay-an ka kataposan nga panahon. Kay ya kanaong sinogo nga taga langit magabelagen niran ya mga tao nga maonga daw ya mga tao nga matadeng. ");
INSERT INTO mmn_vpl VALUES ("MT13_50","070_13_50","MAT","13","50","50","Kamhan ya mga maonga nga batasan iitsa doro ka impirno. Kamhan magapangageet siran ka kanirang ngipen ka paghaza. ");
INSERT INTO mmn_vpl VALUES ("MT13_51","070_13_51","MAT","13","51","51","Pagkakamhan ni Hisos pagpamolinged ka toong mga sinarigan nangotana iza kaniran daw nakasabot kamo kaiton nga tanan? Minsambag siran nga hee makasabot gazed kami. ");
INSERT INTO mmn_vpl VALUES ("MT13_52","070_13_52","MAT","13","52","52","Minlaong si Hisos nga agon makasabot kamo nga ya tao nga mahagdam pagtoldo ka mga balaed nga inbilin ni Moysis kon antoo iza ka kanaong sindo mahitenged ka pagpasakop na Diyos ka mga tao singed iza ka tag-iza ka lagkaw nga nagakawa ka mga bag-o daw daan mga betang garing ka toong dapoganan. ");
INSERT INTO mmn_vpl VALUES ("MT13_53","070_13_53","MAT","13","53","53","Na, pagkakamhan ka ni Hisos pagpamolinged kaniran minpanaw iza. ");
INSERT INTO mmn_vpl VALUES ("MT13_54","070_13_54","MAT","13","54","54","Kamhan min-oli di iza ka Nazarit nga toong insoligan. Kamhan minsindo iza kaniran dalem ka kanirang singbahan. Nangabereng siran ka pagpanalinga niran. Kamhan nagalaong siran nga wara kami mahagdam kon hain iza magtoon ka kahagdamanan daw onhon sa naiza paghinang ka mga madazaw nga kaberenganan. ");
INSERT INTO mmn_vpl VALUES ("MT13_55","070_13_55","MAT","13","55","55","Kay maanak ka lamang iza na panday. Ya ngaran na toong ina ani si Mariya. Maglomon iza daw si Santiago daw si Hosi daw si Simon daw si Hodas. ");
INSERT INTO mmn_vpl VALUES ("MT13_56","070_13_56","MAT","13","56","56","Taga dini disab kanta ya toong mga lomon nga babazi. Agon onhon sa naiza pagkahagdam ka paghinang kaiton nga tanan? ");
INSERT INTO mmn_vpl VALUES ("MT13_57","070_13_57","MAT","13","57","57","Ani ini ya kanirang inlaong kamhan diri gazed siran antoo ka toong sindo kaniran. Kamhan minlaong si Hisos nga doro ka mga lain dapit intahod hao na mga tao piro dini kamazo nga kanaong kaibahan waray pagtahod. Bisan ya mga karaang propita na Diyos, wara siran tahoda na kanirang kaibahan. ");
INSERT INTO mmn_vpl VALUES ("MT13_58","070_13_58","MAT","13","58","58","Kamhan talagsa kay mga madazaw nga kaberenganan nga inhinang ni Hisos dizan kaniran kay diri siran antoo kanangiza. ");
INSERT INTO mmn_vpl VALUES ("MT14_1","070_14_1","MAT","14","1","1","Na, ya maanak ni Hirodis ani ya ilis na toong ama ka paghari ka lopa nga Galiliya. Si Hirodis ya toong ngaran singed ka toong ama. Na, pagpakabati ka naiza mahitenged ka mga madazaw nga kaberenganan nga inhinang ni Hisos kay mindakola di ya ngaran ni Hisos ");
INSERT INTO mmn_vpl VALUES ("MT14_2","070_14_2","MAT","14","2","2","minlaong iza ka toong mga sinogo nga si Hisos ani gazed si Howan nga Magbenzagay. Nabohi di baza iza garing ka lebeng agon may gahem naiza ka paghinang ka mga madazaw. ");
INSERT INTO mmn_vpl VALUES ("MT14_3","070_14_3","MAT","14","3","3","Nawied si Hirodis kay izang dini kaini impadakep naiza si Howan. Kamhan impagapos ngandalem ka prisohan. Ani ini ya toong hinang kay imbahegan iza ni Howan kay minpanapaw si Hirodis kan Hirodiyas nga toong ipag nga asawa na toong lomon nga si Pilipo. ");
INSERT INTO mmn_vpl VALUES ("MT14_4","070_14_4","MAT","14","4","4","Kamhan imbahegan iza ni Howan nagalaong nga minlapas ko ka balaed kay naminze di ko ka kanmong ipag. ");
INSERT INTO mmn_vpl VALUES ("MT14_5","070_14_5","MAT","14","5","5","Kamhan patazen kontana ni Hirodis si Howan piro nahaldek iza ka mga Yodayo kay mintoo siran nga si Howan ani ya matood nga propita nga garing ka Diyos. ");
INSERT INTO mmn_vpl VALUES ("MT14_6","070_14_6","MAT","14","6","6","Na, pagdateng na aldaw ka pagkombiti nga impahinenged ka pagkatao ni Hirodis ya daraga nga maanak ni Hirodiyas minsazaw iza dizan ka tanan mga dinapit. Kamhan naazak si Hirodis ka pagsazaw na babazi. ");
INSERT INTO mmn_vpl VALUES ("MT14_7","070_14_7","MAT","14","7","7","Kamhan minsaad gazed iza ka babazi nagalaong nga bisan ono ya azoon mo kanao ihatag gazed nao kanmo. Mapatay gazed hao kon baribadan ta ko ka azoon mo kanao. ");
INSERT INTO mmn_vpl VALUES ("MT14_8","070_14_8","MAT","14","8","8","Na, garing ka pag-apora na toong ina minsambag ya babazi nga tagan mo hao ka olo ni Howan nga Magbenzagay. Ibetang mo iton dini ka palato. ");
INSERT INTO mmn_vpl VALUES ("MT14_9","070_14_9","MAT","14","9","9","Na, pagpakabati ka ni Hirodis ka inazo na babazi mabeg-at ya toong hinawa ka pagkawied. Piro masipeg iza ka pagbaribad kay kazina dizan ka mga bisita minsaad gazed iza ka babazi. Agon minsogo iza ka soldaw nagalaong nga dadhen mo ngarini kanao ya olo ni Howan. ");
INSERT INTO mmn_vpl VALUES ("MT14_10","070_14_10","MAT","14","10","10","Kamhan impaotdan matood ni Hirodis ya lieg ni Howan dizan ka prisohan. ");
INSERT INTO mmn_vpl VALUES ("MT14_11","070_14_11","MAT","14","11","11","Kamhan imbetang iton dizan ka palato. Kamhan indara ngaro ka babazi. Kamhan inhatag sab na babazi ka toong ina ya olo ni Howan. ");
INSERT INTO mmn_vpl VALUES ("MT14_12","070_14_12","MAT","14","12","12","Pagpakabati ka na mga sakop ni Howan minkaro siran ka prisohan kay kaw-en niran ya lawas ni Howan. Kamhan inlebeng iton. Pagkakamhan kaiza minpasinged siran ngaro kan Hisos kay panan-ogan niran si Hisos nga impatay di ni Hirodis si Howan. ");
INSERT INTO mmn_vpl VALUES ("MT14_13","070_14_13","MAT","14","13","13","Pagpakahagdam ka ni Hisos ka pagkapatay ni Howan minbogtong iza pagsakay ka baloto ngaro ka dapit nga mamingaw. Pagkahagdam ka na mga tao nanlopog siran pagbagtas kan Hisos dizan ka baybazen. ");
INSERT INTO mmn_vpl VALUES ("MT14_14","070_14_14","MAT","14","14","14","Agon pagkawas ka ni Hisos ka baloto ngandipi nakitan naiza ya masarang kataed nga tao. Kamhan nalooy gazed si Hisos kaniran. Kamhan inpanbahaw naiza ya mga masakiten nga impandara niran ngaro kanangiza. ");
INSERT INTO mmn_vpl VALUES ("MT14_15","070_14_15","MAT","14","15","15","Pagkadelem kaiza minkarini kan Hisos ya toong mga sakop kay anlaong siran nga delem di wani. Aro pen kita ka kantang panihaponanan. Papanawen di mo ya mga tao ngaro ka mga bariyobariyo dazaw makapamalit siran ka pagkaen niran. ");
INSERT INTO mmn_vpl VALUES ("MT14_16","070_14_16","MAT","14","16","16","Minsambag si Hisos kaniran nga diri di lamang papanawen siran ngaro. Magpakaen hinoa kamo kaniran. ");
INSERT INTO mmn_vpl VALUES ("MT14_17","070_14_17","MAT","14","17","17","Minsambag siran nga lima komang bolos ya pan kamhan dowa komang bolos ya isda. ");
INSERT INTO mmn_vpl VALUES ("MT14_18","070_14_18","MAT","14","18","18","Minsambag si Hisos nga iated lamang ngarini kanao ya pan daw isda. ");
INSERT INTO mmn_vpl VALUES ("MT14_19","070_14_19","MAT","14","19","19","Kamhan inpanpalo-to naiza ya mga mataed nga tao dizan ka lopa. Paghawid ni Hisos ka mga pan nga limang bolos daw ya isda nga dowang bolos minhangad iza ka langit. Kamhan minpasalamat iza ka Diyos. Kamhan intipaktipak naiza ya mga pan anipen naiza ipanhatag ka toong mga sakop. Kamhan impandohol niran ka mga tao. ");
INSERT INTO mmn_vpl VALUES ("MT14_20","070_14_20","MAT","14","20","20","Pagkakamhan niran pagkaen nangabosog sirang tanan. Pagpakahipid niran ka mga salin nga tinipak nga pan daw isda nangapono pen ya napolo may dowang ka alat. ");
INSERT INTO mmn_vpl VALUES ("MT14_21","070_14_21","MAT","14","21","21","Daw pirang bolos ya tao nga inpakaen ni Hisos? Ya amaama limang ka libo. Wara pen ya labet na mga babazi daw mga bata. ");
INSERT INTO mmn_vpl VALUES ("MT14_22","070_14_22","MAT","14","22","22","Pagkakamhan kaiza inpasakay ni Hisos ka baloto ya toong mga sakop dazaw anhon-a siran kanangiza dipi ka danaw kay paolien pen naiza ya mga mataed nga tao. ");
INSERT INTO mmn_vpl VALUES ("MT14_23","070_14_23","MAT","14","23","23","Kamhan waray iba naiza pagtokad naiza ngandaked ka pagkahiping na bobong kay ampangamozo iza ka Diyos. Pagkakahabzen di kaiza isa koman iza doro ka lopa. ");
INSERT INTO mmn_vpl VALUES ("MT14_24","070_14_24","MAT","14","24","24","Kamhan ya sakzanan na toong mga sakop doro pen iton ka tenga na danaw, wara pen makadateng ka lopa. Indasmagan sab iton ka dakola nga baled kay nasogatan niran ya makeseg nga hangin. ");
INSERT INTO mmn_vpl VALUES ("MT14_25","070_14_25","MAT","14","25","25","Na, pagkakamaaldawen kaiza minpanaw si Hisos dizan ka hopaw na sapa ngaro arani ka kanirang sakzanan. ");
INSERT INTO mmn_vpl VALUES ("MT14_26","070_14_26","MAT","14","26","26","Pagpakakita niran nga waton ya minpanaw dizan ka hopaw na sapa nangahaldek gazed siran daw minsinggit nga pooy sa wani! ");
INSERT INTO mmn_vpl VALUES ("MT14_27","070_14_27","MAT","14","27","27","Piro minlaong si Hisos kaniran nga diri kamo magkawied kay hao ini. Diri kamo magkahaldek. ");
INSERT INTO mmn_vpl VALUES ("MT14_28","070_14_28","MAT","14","28","28","Kamhan si Pidro ani minsambag nga Nong, kon matood nga iko ka iton pakatonon mo hao singed ka pagpanaw mo diton ka hopaw na sapa. ");
INSERT INTO mmn_vpl VALUES ("MT14_29","070_14_29","MAT","14","29","29","Minsambag si Hisos nga pomanaw di ko ngarini. Kamhan minkawas si Pidro ka baloto. Minpanaw disab baza iza dizan ka hopaw na sapa kay minkaro iza kan Hisos. ");
INSERT INTO mmn_vpl VALUES ("MT14_30","070_14_30","MAT","14","30","30","Piro pagpaniid ka naiza ka makeseg sa wani nga hangin nga minsakem ka toong lawas masara gazed ya toong kahaldek. Kamhan magapakatogalway ya toong paa ngandalem ka sapa. Kamhan minsinggit iza nga Ginoo, tabangi hao! ");
INSERT INTO mmn_vpl VALUES ("MT14_31","070_14_31","MAT","14","31","31","Intagenan iza dazon ni Hisos daw inlong-an nga geramay pen gazed ya pagsarig mo kanao. Kay ono sa nga nagadowadowa sa ko? ");
INSERT INTO mmn_vpl VALUES ("MT14_32","070_14_32","MAT","14","32","32","Pagpakaleen nirang dowa ka baloto minheneng dazon ya hangin. ");
INSERT INTO mmn_vpl VALUES ("MT14_33","070_14_33","MAT","14","33","33","Kamhan insaza gazed iza na toong mga sakop dizan ka baloto nagalaong nga iko matood ya Maanak na Diyos. ");
INSERT INTO mmn_vpl VALUES ("MT14_34","070_14_34","MAT","14","34","34","Pagkakamhan kaiza doro ka lopa nga Ganasarit mindonggo siran. ");
INSERT INTO mmn_vpl VALUES ("MT14_35","070_14_35","MAT","14","35","35","Pagpakakilala ka na mga taga dizan nga si Hisos iton impakahagdam niran dazon ya mga taga doro tenged kaiton nga dapit. Kamhan impandara niran ya mga masakiten dizan kan Hisos. ");
INSERT INTO mmn_vpl VALUES ("MT14_36","070_14_36","MAT","14","36","36","Kamhan minhangzo siran kan Hisos nga nagalaong nga Hisos, pahogamen mo lamang siran ka pilos na kanmong bado. Kamhan ya tanan nakahogam ka pilos na toong bado nangabahawan matood siran ka kanirang mga masakit. ");
INSERT INTO mmn_vpl VALUES ("MT15_1","070_15_1","MAT","15","1","1","Pagkakamhan kaiza minkarini kan Hisos ya mga Parasiyo daw ya mga maistro ka tinoohan na mga Yodayo. Garing siran ka siyodad nga Hirosalem. Kamhan nangotana siran kan Hisos nga ");
INSERT INTO mmn_vpl VALUES ("MT15_2","070_15_2","MAT","15","2","2","kay ono sa ya mga sakop mo minlapas gazed siran ka balaed nga garing ka kantang mga karaan nga nagalaong nga ka wara pen magkaen ya tao kinahanglan hogasan ya alima. ");
INSERT INTO mmn_vpl VALUES ("MT15_3","070_15_3","MAT","15","3","3","Minsambag si Hisos nga hopaw ka lamang ya kamazong paghogas kay wara kamo kahingloi ka kamazong mga sala. Kay onosa kamo magalapas ka mga sogo na Diyos dazaw anhawid kamo ka mga balaed nga garing ka mga karaan? ");
INSERT INTO mmn_vpl VALUES ("MT15_4","070_15_4","MAT","15","4","4","Kay minsogo ya Diyos nga tahodon mazo ya kamazong ginikanan. Bisan sin-o ya ampanaba ka maonga mahitenged ka toong kamalas-an magapatazen gazed iton nga tao. Ani ini ya sogo na Diyos. ");
INSERT INTO mmn_vpl VALUES ("MT15_5","070_15_5","MAT","15","5","5","Kamhan kamo nga mga Parasiyo nagalaong kamo ka ginikanan mazo nga ya itabang nao kamazo waro di nao lamang ihatag ka Diyos. Singed ka diri togotan mazo pagtabang ka ginikanan. ");
INSERT INTO mmn_vpl VALUES ("MT15_6","070_15_6","MAT","15","6","6","Agon nagapakawaray polos kamo ka sogo na Diyos dazaw makapadazon kamo ka mga balaed na kamazong karaan. ");
INSERT INTO mmn_vpl VALUES ("MT15_7","070_15_7","MAT","15","7","7","Mga bakaken kamo! Insakto gazed ya panan-og ni Isayas mahitenged kamazo nagalaong nga ");
INSERT INTO mmn_vpl VALUES ("MT15_8","070_15_8","MAT","15","8","8","dizan ka ba-ba ka lamang ya kamazong pagtoo kanao nga Diyos kay ya kamazong hena-hena aro ka gazed kanao. ");
INSERT INTO mmn_vpl VALUES ("MT15_9","070_15_9","MAT","15","9","9","Wara gazed ya polos ka pagsingba mazo kanao kay nagalaong kamo nga ya pagpanoldo mazo ani ya mga sogo na Diyos ambaza kay mga balaed na kamazong mga karaan ka lamang. Ani ini ya panan-og ni Isayas mahitenged kamazo. ");
INSERT INTO mmn_vpl VALUES ("MT15_10","070_15_10","MAT","15","10","10","Pagkakamhan ni Hisos pagbaheg ka mga Parasiyo impakarini naiza ya mga tao kay nagalaong iza nga kamong tanan, manalinga gazed kamo kay dazaw masabtan mazo nga ");
INSERT INTO mmn_vpl VALUES ("MT15_11","070_15_11","MAT","15","11","11","bisan ono ya inkaen na tao diri gazed iton kon maonga ka tao. Basta kay ya mga panaba nga anlogwa ka ba-ba na tao ani gazed ya maonga ka tao. ");
INSERT INTO mmn_vpl VALUES ("MT15_12","070_15_12","MAT","15","12","12","Pagkakamhan kaiza minkarini kan Hisos ya toong mga sakop. Kamhan nagalaong siran nga Nong, daw mahagdam ko nga ya impanaba mo kazina nakapazehet iton ka mga Parasiyo? ");
INSERT INTO mmn_vpl VALUES ("MT15_13","070_15_13","MAT","15","13","13","Minsambag si Hisos ka pagpamolinged kaniran nga ya mga diri kon intanem na kanaong Ama pamognoton gazed iton kay-an. ");
INSERT INTO mmn_vpl VALUES ("MT15_14","070_15_14","MAT","15","14","14","Agon pabet-an mazo lamang ya mga Parasiyo kay nabota ya kanirang hena-hena. Singed siran ka nabota nga tao nga anhabit ka iba nga tao nga nabota. Kamhan maholog gazed sirang dowa dalem ka teheb. ");
INSERT INTO mmn_vpl VALUES ("MT15_15","070_15_15","MAT","15","15","15","Kamhan si Pidro ani ya minsambag nga hilwasan mo naa kami ka pamolinged mo kazina mahitenged ka makaen. ");
INSERT INTO mmn_vpl VALUES ("MT15_16","070_15_16","MAT","15","16","16","Minsambag si Hisos nga daw wara pen kamo makasabot? ");
INSERT INTO mmn_vpl VALUES ("MT15_17","070_15_17","MAT","15","17","17","Daw wara pen kamo mahagdam nga ya inkaen na tao dizan ka lamang an-azi ka tinai na tao. Kamhan anlogwa ka lawas na tao. ");
INSERT INTO mmn_vpl VALUES ("MT15_18","070_15_18","MAT","15","18","18","Piro ya mga maonga nga mga panaba ani gazed ya makaonga ka tao kay garing iton ka toong hena-hena. ");
INSERT INTO mmn_vpl VALUES ("MT15_19","070_15_19","MAT","15","19","19","Kay ya hena-hena nga maonga ani ya sinogdan ka pagbono ka tao daw ya paghenay daw ya paghinang ka malaw-ay daw ya pangawat daw ya pagbakak daw ya pagbetangbetang ka tao. ");
INSERT INTO mmn_vpl VALUES ("MT15_20","070_15_20","MAT","15","20","20","Iton nga batasan ani gazed ya makaonga ka tao. Kamhan diri kon maonga ya tao kon angkaen iza ka wara pen iza maghogas ka toong alima singed ka batasan na mga Parasiyo. ");
INSERT INTO mmn_vpl VALUES ("MT15_21","070_15_21","MAT","15","21","21","Pagkakamhan ni Hisos pagsindo kaniran minpanaw iza ngaro tenged ka dowang ka longsod nga Tiro daw Sidon. ");
INSERT INTO mmn_vpl VALUES ("MT15_22","070_15_22","MAT","15","22","22","Kamhan minkarini kan Hisos ya isang babazi nga taga Kanaan nga nagahela dizan kaiton dapit. Kamhan minhangzo gazed iza kan Hisos nga Sinyor nga kaliwat ni Dabid, kaloy-i intawon hao! Kay ya kanaong maanak nga babazi inharian gazed iza na maonga. ");
INSERT INTO mmn_vpl VALUES ("MT15_23","070_15_23","MAT","15","23","23","Kamhan wara si Hisos magsambag. Kamhan minkarini kan Hisos ya toong mga sakop kay nagalaong siran nga papanawen di mo ya babazi kay magaasang lopog iza kanmo daw magapanhawag. ");
INSERT INTO mmn_vpl VALUES ("MT15_24","070_15_24","MAT","15","24","24","Minsambag si Hisos nga impakarini hao na Diyos kay dazaw antabang hao ka mga kaliwatan ni Israil kay nangalaag siran singed ka batasan na mga karniro nga bohien na tao. Mga masinopaken gazed siran ka Diyos. ");
INSERT INTO mmn_vpl VALUES ("MT15_25","070_15_25","MAT","15","25","25","Kamhan dizan ka paahan ni Hisos minlohod ya babazi kay ampakilooy pag-isab nagalaong nga Sinyor, tabangi intawon hao. ");
INSERT INTO mmn_vpl VALUES ("MT15_26","070_15_26","MAT","15","26","26","Kamhan minpamolinged si Hisos pagsambag ka babazi nga ya makaen para ka mga bata diri kon madazaw kon ibahog dizan ka mga ido. ");
INSERT INTO mmn_vpl VALUES ("MT15_27","070_15_27","MAT","15","27","27","Na, nakasabot dazon ya babazi nga ya kahologan diri kon madazaw kon antabang si Hisos ka mga taga Kanaan paghon-a ka pagtabang naiza ka mga taga Yoda. Kamhan minsambag ya babazi nga Sinyor, matood gazed ya saba mo. Piro bisan ngani ya mga ido diri bogawen pagkaen niran ka mga podpod nga naholog garing ka lamisa na kanirang tag-iza. ");
INSERT INTO mmn_vpl VALUES ("MT15_28","070_15_28","MAT","15","28","28","Kamhan minsambag si Hisos nga Day, dakola gazed ya kanmong pagsarig kanao. Natoman di ya kanmong inhangzo kanao. Kamhan naolian matood ya toong maanak ka magazong beet. ");
INSERT INTO mmn_vpl VALUES ("MT15_29","070_15_29","MAT","15","29","29","Pagkakamhan kaiza minpanaw si Hisos dizan kaiton nga dapit. Min-azi iza dizan ka baybazen na danaw nga Galiliya. Kamhan mintokad iza ngandaked ka pagkahiping na bobong. Kamhan minlo-to di iza dizan. ");
INSERT INTO mmn_vpl VALUES ("MT15_30","070_15_30","MAT","15","30","30","Kamhan nangarini kan Hisos ya masarang kataed nga tao kay indara niran ya mga piang daw ya mga nabarian daw ya mga nabota daw ya mga amang daw ya mga mataed pen nga mga masakiten. Impabentag siran dizan ka paahan ni Hisos. Kamhan impanbahaw naiza sirang tanan. ");
INSERT INTO mmn_vpl VALUES ("MT15_31","070_15_31","MAT","15","31","31","Pagseleng na mga tao nangabereng gazed siran kay ya mga amang nakalitok di gazed siran, nakapanaba di. Madazaw di isab ya lawas na mga nabarian. Nakapanaw di ya mga piang. Makakita di ya mga nabota. Pagseleng ka na mga tao insaza gazed niran ya Diyos nga tahodanan na kanirang karaang nga si Israil. ");
INSERT INTO mmn_vpl VALUES ("MT15_32","070_15_32","MAT","15","32","32","Pagkakamhan kaiza impakarini ni Hisos ya toong mga sakop kay inlong-an nga nalooy hao ka mga tao kay ikatlo ding aldaw koman ya pag-iba niran kanao. Kamhan nahodtan siran ka makaen. Kon papanawen nao siran nga waray makaen basi pangetasan siran dizan ka dalan. ");
INSERT INTO mmn_vpl VALUES ("MT15_33","070_15_33","MAT","15","33","33","Nangotana ya mga sakop nga daw hain kami koman mangita ka pagkaen dini ka kamingawan igo ka pagbosog kaiton nga masarang kataed nga tao? ");
INSERT INTO mmn_vpl VALUES ("MT15_34","070_15_34","MAT","15","34","34","Nangotana si Hisos kaniran nga daw pira peng bolos ya pan mazo diton? Minsambag siran nga pito komang bolos ini daw ya mga geramay nga isda. ");
INSERT INTO mmn_vpl VALUES ("MT15_35","070_15_35","MAT","15","35","35","Kamhan insogo ni Hisos ya mga tao ka pagpanlo-to dizan ka lopa. ");
INSERT INTO mmn_vpl VALUES ("MT15_36","070_15_36","MAT","15","36","36","Kamhan minkawa iza kaini nga pan nga pitong bolos daw ya mga isda. Pagkakamhan naiza pagpasalamat ka Diyos impanipak naiza ya tanan daw impanhatag ka toong mga sakop dazaw panhatagan sab niran ya mga tao dizan nga namaglo-to. ");
INSERT INTO mmn_vpl VALUES ("MT15_37","070_15_37","MAT","15","37","37","Pagkakamhan niran pagkaen nangabosog gazed sirang tanan. Pagkakamhan niran paghipid ka salin nangapono pen ya pitong ka alat. ");
INSERT INTO mmn_vpl VALUES ("MT15_38","070_15_38","MAT","15","38","38","Daw pirang bolos ya tao nga inpakaen ni Hisos? Ya amaama opat nga ka libo. Wara pen ya labet na mga babazi daw mga bata. ");
INSERT INTO mmn_vpl VALUES ("MT15_39","070_15_39","MAT","15","39","39","Pagkakamhan kaiza impaoli siran ni Hisos. Kamhan minleen iza ka baloto dazaw ampasinged iza ngaro ka lopa nga Magadan. ");
INSERT INTO mmn_vpl VALUES ("MT16_1","070_16_1","MAT","16","1","1","Ka dizan pen si Hisos ka lopa nga Magadan minkarini kanangiza ya mga Parasiyo daw ya mga Sadosiyo kay amporba siran kan Hisos nagalaong nga ipakita mo kanami ya timaan dazaw mahagdam kami nga garing matood iko ka Diyos. ");
INSERT INTO mmn_vpl VALUES ("MT16_2","070_16_2","MAT","16","2","2","Minsambag si Hisos nga pagpaniid mazo nga mararag ya langit ka pagsalep na sega nagalaong kamo nga masega ini konsilem. ");
INSERT INTO mmn_vpl VALUES ("MT16_3","070_16_3","MAT","16","3","3","Pagpaniid mazo nga mararag ya langit ka pagkaaldaw kamhan mindag-em nagalaong disab kamo nga an-oran kaan. Na, iton nga timaan ka timpo dizan ka kalangitan nakasabot kamo piro ya mga timaan nga garing ka Diyos mahitenged ka kataposan nga panahon wara baza kamo makasabot. ");
INSERT INTO mmn_vpl VALUES ("MT16_4","070_16_4","MAT","16","4","4","Ampangazo kamo kanao ka timaan kay makasasala sa kamo. Imbizaan disab mazo ya pagtoo ka matood nga Diyos. Anikay timaan kamazo ya singed kan Zona nga karaang propita na Diyos. Pagkakamhan ni Hisos pagsambag minpanaw iza dizan kaniran. ");
INSERT INTO mmn_vpl VALUES ("MT16_5","070_16_5","MAT","16","5","5","Pagdateng niran ngandipi ka danaw waray nadara na toong mga sakop nga pan kay nalipatan niran. ");
INSERT INTO mmn_vpl VALUES ("MT16_6","070_16_6","MAT","16","6","6","Kamhan minpamolinged si Hisos kaniran nga nagalaong nga maghamarag kamo ka sindo na mga Parasiyo daw ya mga Sadosiyo. Kay ya kanirang sindo minpasingedsinged iton ka ipasoligay ka pan. Kay bisan isaket ya geramay nga ipasoligay dizan ka harina anlekep iton ka tanan. ");
INSERT INTO mmn_vpl VALUES ("MT16_7","070_16_7","MAT","16","7","7","Kamhan namaglaonglaong ya toong mga sakop nga ani ini ya impanaba ni Hisos kay wara say daradara ta wani nga pan. ");
INSERT INTO mmn_vpl VALUES ("MT16_8","070_16_8","MAT","16","8","8","Kamhan mahagdam si Hisos nga minhena-hena siran mahitenged ka pan, diri kon sindo na mga Parasiyo. Agon minlaong iza kaniran nga geramay ka gazed ya pagsarig mazo kanao. Kay ono sa nawied kamo ka pan? ");
INSERT INTO mmn_vpl VALUES ("MT16_9","070_16_9","MAT","16","9","9","Daw wara pen kamo makasabot? Daw wara kamo makataremdem kaiza nga pan nga lima kang bolos nga impakaen nao ka mga limang ka libo nga tao ang dini kaini? Kamhan pirang bolos ya alat nga impono mazo ka salin kaiza? ");
INSERT INTO mmn_vpl VALUES ("MT16_10","070_16_10","MAT","16","10","10","Daw wara kamo makataremdem kaiza nga pan nga pitong bolos nga impakaen nao ka opat nga ka libo nga tao? Daw pirang bolos ya alat nga impono mazo ka salin kaiza? ");
INSERT INTO mmn_vpl VALUES ("MT16_11","070_16_11","MAT","16","11","11","Kay ono sa nga wara kamo makasabot nga diri kon pan ya inlaong nao kamazo kazina? Maghamarag kamo ka sindo na mga Parasiyo daw ya mga Sadosiyo kay singed iton ka ipasoligay ka pan kay bisan isaket ya geramay nga ipasoligay dizan ka harina anlekep gazed iton ka tanan. ");
INSERT INTO mmn_vpl VALUES ("MT16_12","070_16_12","MAT","16","12","12","Pagkakamhan ni Hisos paglaong kaiton anipen siran makasabot nga diri kon ipasoligay ka pan ya magahamaragan niran. Piro ya mga sindo na mga Parasiyo daw ya mga Sadosiyo ani gazed ya kanirang hamaragan. Kay bisan geramay ka lamang ya insindo na mga Parasiyo ka mga tao makadaeg gazed iton ka hena-hena na tao. ");
INSERT INTO mmn_vpl VALUES ("MT16_13","070_16_13","MAT","16","13","13","Pagkakamhan kaiza minpasinged sing Hisos ngaro ka lopa tenged ka siyodad nga Sisariya Pilipos. Pagbagtas pen niran ngaro nangotana si Hisos ka toong mga sakop nga daw ono ya pagngaran na mga tao kanao? ");
INSERT INTO mmn_vpl VALUES ("MT16_14","070_16_14","MAT","16","14","14","Minsambag siran nga may nagalaong nga matod sa koni niran iko koni si Howan nga Magbenzagay. May nagalaong nga iko sab koni iton si Iliyas nga karaang propita na Diyos. May iba pen nagalaong nga iko sab koni si Hirimiyas bisan kon ya isa pen nga karaang propita. ");
INSERT INTO mmn_vpl VALUES ("MT16_15","070_16_15","MAT","16","15","15","Kamhan nangotana si Hisos kaniran nga daw sin-o say pagngaran mazo kanao? ");
INSERT INTO mmn_vpl VALUES ("MT16_16","070_16_16","MAT","16","16","16","Minsambag si Simon Pidro nga iko ani matood si Kristo nga hari nga pinili na Diyos. Iko ya Maanak na Diyos nga bohi. ");
INSERT INTO mmn_vpl VALUES ("MT16_17","070_16_17","MAT","16","17","17","Minsambag si Hisos nga Simon nga maanak ni Barzona, panaranginan ko na Diyos ka madazaw. Kay ya sambagan mo kanao diri kon tao ya minpasabot kanmo basta kay ya kanaong Ama nga nagahela daked ka langit ani ya minpasabot kanmo kon sin-o sa hao. ");
INSERT INTO mmn_vpl VALUES ("MT16_18","070_16_18","MAT","16","18","18","Agon anngaran hao kanmo kan Pidro kay singed iko ka dakolang bato. Ya sambagan mo kanao kazina ani ya singed ka lopa nga marig-en nga madazaw ogdokan. Ya mga tao nga ansakop kanao singed siran ka lagkaw nga hel-anan na Diyos nga hinangen nao dizan ka in-ogdokan nga marig-en. Bisan pagaawazen gazed siran nin Satanas diri siran madaeg kay magahela siran dizan ka marig-en nga lagkaw. ");
INSERT INTO mmn_vpl VALUES ("MT16_19","070_16_19","MAT","16","19","19","Pidro, anhatag hao kanmo ka gahem ka pagpaseled ka mga tao ngandaked ka hel-anan na kanaong Ama. Pagdomara mo ka kanaong mga sakop nga nagatipon bisan ono ya diri mo itogot dizan kaniran ani isab iton ya mahinang daked ka hela na kanaong Ama. Kamhan bisan ono ya itogot mo dizan kaniran ani isab iton ya mahinang daked ka hela na kanaong Ama. Ani ini ya inpanaba ni Hisos kan Pidro. ");
INSERT INTO mmn_vpl VALUES ("MT16_20","070_16_20","MAT","16","20","20","Kamhan minsogo gazed iza ka toong mga sakop nagalaong nga diri kamo magpanan-og ka mga tao nga hao si Kristo nga hari nga pinili na Diyos. ");
INSERT INTO mmn_vpl VALUES ("MT16_21","070_16_21","MAT","16","21","21","Kamhan minsogod iza ka pagpasabot ka toong mga sakop nga an-azi iza ka mga kalised doro ka siyodad nga Hirosalem. Kamhan magasawazen iza na mga malaas daw ya mga oloolo na mga pari daw ya mga maistro ka tinoohan na mga Yodayo. Kamhan pamagpatazen iza doro kaniran. Pagdateng ka ikatolong aldaw magabohien iza na Diyos pagbalik garing ka lebeng. ");
INSERT INTO mmn_vpl VALUES ("MT16_22","070_16_22","MAT","16","22","22","Pagkakamhan ni Hisos pagpanan-og kaini in-ated iza ni Pidro dizan ka waray laing tao. Kamhan minbaheg si Pidro nagalaong nga Ginoo, diri ko gazed patazen na mga tao. Diri gazed itogot na Diyos ya inpanaba mo. ");
INSERT INTO mmn_vpl VALUES ("MT16_23","070_16_23","MAT","16","23","23","Kamhan minliso si Hisos kan Pidro daw minsambag nga iko ya singed kan Satanas. Pomanaw ko dini kanao kay ambalabag iko kanao kontana. Kay ya hena-hena mo nagasopak ka kabebet-en na Diyos. Nagaangay ya hena-hena mo ka kabebet-en na tao. ");
INSERT INTO mmn_vpl VALUES ("MT16_24","070_16_24","MAT","16","24","24","Kamhan minsindo si Hisos ka toong mga sakop nga nagalaong nga bisan sin-o ya ampasakop kanao kinahanglan bizaan naiza ya toong kaogaringen nga naazakan daw angeten ya pagkapatay singed kanao. Ka diri madogay dakpen hao na mga tao kamhan ipalansang ka kros keteb ka mapatay hao. ");
INSERT INTO mmn_vpl VALUES ("MT16_25","070_16_25","MAT","16","25","25","Kamhan bisan sin-o ya diri ansakop kanao kay nawied iza nga basi patazen iza mawara hinoa iza. Piro bisan sin-o ya napatay kay hao ya toong insakopan mahatagan iza ka bag-ong kinabohi nga diri mawara. ");
INSERT INTO mmn_vpl VALUES ("MT16_26","070_16_26","MAT","16","26","26","Bisan kon maangken na tao ya tanan mga betang dini ka kalibotan kamhan mawara ka ya toong kaogaringen nga kinabohi daw ono ya makawa naiza? Wara gazed. Kay waray ikahatag naiza dazaw mabawi ya toong kinabohi. ");
INSERT INTO mmn_vpl VALUES ("MT16_27","070_16_27","MAT","16","27","27","Mindogang pen si Hisos paglaong kaniran nga hao ya minhon-a ka bisan sin-o nga mahon-ang tao. May tirmino nao ka pagbalik ka kalibotan. Iba sab kanao ya kanaong mga sogoonon nga taga langit. Magabado sab hao ka kalatì na kanaong Ama nga Diyos. Kamhan balsan nao ya kada isa daw isa ka mga tao angay ka batasan. ");
INSERT INTO mmn_vpl VALUES ("MT16_28","070_16_28","MAT","16","28","28","Timan-an mazo gazed ini nga dini kamazo may mga diri mapatay nga tao hangtod ka pagpakakita niran kanao pagbalik nao dini ka kalibotan kay hao gazed ya hari nga pinili na Diyos. Ani ini ya insindo ni Hisos ka toong mga sakop. ");
INSERT INTO mmn_vpl VALUES ("MT17_1","070_17_1","MAT","17","1","1","Na, pagdateng ka ikaenem nga ka aldaw impaiba ni Hisos si Pidro daw si Santiago daw ya toong lomon nga si Howan ngandaked ka bobong nga ataas nga waray laing tao. ");
INSERT INTO mmn_vpl VALUES ("MT17_2","070_17_2","MAT","17","2","2","Kamhan dizan ka pagseleng nirang tolo singed ka nabag-o di ya lawas ni Hisos piro si Hisos gazed iton. Masiraw ya toong bayho singed ka kasiraw na sega. Masarang kapoti ya toong bado singed ka kalatì na sega. ");
INSERT INTO mmn_vpl VALUES ("MT17_3","070_17_3","MAT","17","3","3","Kamhan waton disab si Iliyas daw si Moysis nga mga karaang propita na Diyos. Namaglaonglaong sirang dowa daw si Hisos. ");
INSERT INTO mmn_vpl VALUES ("MT17_4","070_17_4","MAT","17","4","4","Kamhan minlaong si Pidro kan Hisos nga Ginoo, madazaw ya kantang pagtipon dini. Kon somogot ko anhinang hao ka mga tolong bolos nga tal-ob. Kanmo ya isa. Kan Moysis ya isa. Kan Iliyas ya isa. ");
INSERT INTO mmn_vpl VALUES ("MT17_5","070_17_5","MAT","17","5","5","Ka nagapanaba pen si Pidro intamdengan siran ka inarak nga masidlaw pagdazaw. Kamhan nabatian ya saba dizan ka inarak nga nagalaong nga wani ya kanaong Maanak nga kanaong naazakan. Nakasaza gazed iza kanao. Magtoo gazed kamo ka toong mga panaba kamazo. ");
INSERT INTO mmn_vpl VALUES ("MT17_6","070_17_6","MAT","17","6","6","Kamhan ya mga sakop ni Hisos minpatihapa siran ka lopa kay nangahaldek gazed siran. ");
INSERT INTO mmn_vpl VALUES ("MT17_7","070_17_7","MAT","17","7","7","Minkandizan dazon si Hisos kaniran. Pagtagen naiza kaniran nagalaong iza nga panindeg kamo. Abay kamo pagkahaldek. ");
INSERT INTO mmn_vpl VALUES ("MT17_8","070_17_8","MAT","17","8","8","Paghangad niran nawara dizan si Iliyas daw si Moysis. Si Hisos ka ya nakita niran dizan. ");
INSERT INTO mmn_vpl VALUES ("MT17_9","070_17_9","MAT","17","9","9","Na, paglogsong pen niran mintogon si Hisos kaniran nagalaong nga hao ya minhon-a ka bisan sin-o nga mahon-ang tao. Mabohi sab hao pagbalik garing ka lebeng kay-an anipen kon ipanan-og mazo ya kamazong nakitan kazina ka daked pen kita ka bobong. ");
INSERT INTO mmn_vpl VALUES ("MT17_10","070_17_10","MAT","17","10","10","Kamhan nangotana siran kan Hisos nga kay ono sa nagatoldo sa ya mga maistro nga Yodayo kanami nga si Iliyas ani ya anhon-a kan Kristo ka pagkarini? Daw matood iton kon diri? ");
INSERT INTO mmn_vpl VALUES ("MT17_11","070_17_11","MAT","17","11","11","Minsambag si Hisos nga minhon-a matood kanao ya tao nga singed kan Iliyas nga karaang propita na Diyos. Kay min-andam iza ka kanaong pagdateng. ");
INSERT INTO mmn_vpl VALUES ("MT17_12","070_17_12","MAT","17","12","12","Si Howan nga Magbenzagay ani itong tao. Piro wara siran mahagdam kon sin-o sa iza. Kamhan indaegdaeg iza na mga tao. Ani gihapon ya kanirang batasan kanao kay-an nga magasawazen hao niran. ");
INSERT INTO mmn_vpl VALUES ("MT17_13","070_17_13","MAT","17","13","13","Na, pagkakamhan ni Hisos pagpanan-og kaniran nakasabot siran nga si Howan nga Magbenzagay ani si Iliyas. ");
INSERT INTO mmn_vpl VALUES ("MT17_14","070_17_14","MAT","17","14","14","Pagkakamhan kaiza minbalik sin Hisos ka mga mataed nga tao. Kamhan may isang tao nga minkarini kan Hisos. Minlohod iza dizan ka paahan ni Hisos kay anhangzo nga nagalaong nga ");
INSERT INTO mmn_vpl VALUES ("MT17_15","070_17_15","MAT","17","15","15","Sinyor, kaloy-i intawon ya kanaong maanak nga amaama kay insawan iza. Grabi gazed ya toong kahimtang kay sigi di iza magapatiholog dizan ka laga daw dizan ka sapa. ");
INSERT INTO mmn_vpl VALUES ("MT17_16","070_17_16","MAT","17","16","16","Indara nao iza dizan ka kanmong mga sakop piro wara siran makatabang kanangiza. ");
INSERT INTO mmn_vpl VALUES ("MT17_17","070_17_17","MAT","17","17","17","Minsambag si Hisos nga waray pagtoo mazo ka Diyos. Mga salaan sab kamo. Daw dogay pen hao magaanget ka kamazong batasan nga waray pagtoo kanao? Daw dogay pen hao magahela dini kamazo anipen kamo makasabot ka gahem na Diyos? Dadha ngarini ya bata! ");
INSERT INTO mmn_vpl VALUES ("MT17_18","070_17_18","MAT","17","18","18","Pag-ated niran ka bata dizan kan Hisos imbaheg naiza ya maonga. Kamhan mindalagan dazon iton. Naolian matood ya bata ka madazaw nga beet. ");
INSERT INTO mmn_vpl VALUES ("MT17_19","070_17_19","MAT","17","19","19","Pagkakamhan kaiza minkarini kan Hisos ya toong mga sakop nga waray laing tao kay ampangotana siran nga Nong, kay ono sang wara sa kami makapabogaw ka maonga? ");
INSERT INTO mmn_vpl VALUES ("MT17_20","070_17_20","MAT","17","20","20","Minsambag si Hisos nga kinahanglan magtoo kamo kanao. Magtimaan kamo kaini nga bisan singed ka kontana ka liso na mostasa ka kageramay ya pagtoo mazo kanao makahimo di kamo ka bisan ono. Pamolinged ini nga ya bobong dizan kon sogoon mo iton ka pagsibeg ngaro ansibeg matood iton ngaro. ");
INSERT INTO mmn_vpl VALUES ("MT17_21","070_17_21","MAT","17","21","21","Kamhan ya maonga nga minhari ka bata kazina anikay makapabogaw ya paghangzo mazo ka Diyos daw ya pag-anget mazo ka pagkaen. ");
INSERT INTO mmn_vpl VALUES ("MT17_22","070_17_22","MAT","17","22","22","Pagkakamhan kaiza namagkatipon si Hisos daw ya toong mga sakop doro ka lopa nga Galiliya. Kamhan minlaong si Hisos kaniran nga hao nga minhon-a ka bisan sin-o nga mahon-ang tao itogyan hao dizan ka gahem na mga tao nga ");
INSERT INTO mmn_vpl VALUES ("MT17_23","070_17_23","MAT","17","23","23","anpatay kanao. Pagkaikatlong aldaw mabohi hao pagbalik garing ka lebeng. Na, pagpakabati ka na toong mga sakop nagalised gazed ya kanirang hena-hena. ");
INSERT INTO mmn_vpl VALUES ("MT17_24","070_17_24","MAT","17","24","24","Pagkakamhan kaiza mindateng di siran ka longsod nga Kapirnaom. Kamhan may minkarini kan Pidro nga mga magsokotay ka bohis ka dakolang lagkaw nga pangamozoanan ka Diyos. Minlaong siran kan Pidro nga matod ambazad koni ya kanmong maistro kaini nga bohis? ");
INSERT INTO mmn_vpl VALUES ("MT17_25","070_17_25","MAT","17","25","25","Minsambag si Pidro nga ambazad iza. Na, pag-oli ni Pidro ka wara pen iza maglaong kan Hisos nangotana si Hisos kanangiza nga Simon, daw ono ya hena-hena mo ka batasan na mga hari dini ka kalibotan? Daw azoon niran ya bohis dizan ka angay niran kon dizan ka mga lain tao? ");
INSERT INTO mmn_vpl VALUES ("MT17_26","070_17_26","MAT","17","26","26","Minsambag si Pidro nga dizan ka mga lain tao in-azo na mga hari ya bohis. Minsambag si Hisos nga kamhan ya mga tao nga angay na hari malibri siran ka pagbazad ka bohis. ");
INSERT INTO mmn_vpl VALUES ("MT17_27","070_17_27","MAT","17","27","27","Na, kita nga mga maanak na Diyos, kontana waray kinahanglan ta ka pagbazad ka bohis dizan ka dakolang lagkaw nga pangamozoanan ka Diyos. Piro bayran lamang dazaw diri magakazehet ya mga magsokotay ka mga bohis. Pidro, magpamingwit ko naa dizan ka dagat. Ya primirong makawa mo ka bingwit abrihan ya ba-ba na isda kay waton ya makitan mo nga palata nga kowarta nga ikabazad ka kantang bohis. Iated mo iton dizan ka mga magbohisay. ");
INSERT INTO mmn_vpl VALUES ("MT18_1","070_18_1","MAT","18","1","1","Pagkakamhan kaiza minkarini kan Hisos ya toong mga sakop kay ampangotana siran nga Nong, daw sin-o ya labaw nga tao dizan ka mga sakop mo? ");
INSERT INTO mmn_vpl VALUES ("MT18_2","070_18_2","MAT","18","2","2","Kamhan impakarini ni Hisos ya isang bata kay patindegen dizan ka tenged na toong mga sakop. ");
INSERT INTO mmn_vpl VALUES ("MT18_3","070_18_3","MAT","18","3","3","Kamhan minsambag si Hisos kaniran nga timan-an mazo gazed ini nga kon diri kamo anhaod ka batasan na mga bata diri gazed hao ampaseled kamazo ngandaked ka hel-anan na kanaong Ama. ");
INSERT INTO mmn_vpl VALUES ("MT18_4","070_18_4","MAT","18","4","4","Bisan sin-o ya ampaebes ka toong kaogaringen singed ka batasan na bata, iza gazed ya labaw dizan ka mga tao nga minsakop ka Diyos. ");
INSERT INTO mmn_vpl VALUES ("MT18_5","070_18_5","MAT","18","5","5","Garing ka pagtoo na tao kanao kon andawat iza ka bata andawat gihapon iza kanao. ");
INSERT INTO mmn_vpl VALUES ("MT18_6","070_18_6","MAT","18","6","6","Ya dakolang bato nga galingan ibitay ka lieg na bisan sin-o ya antintal ka bata ka pagbiza kanao. Kamhan lemsan iza doro ka lawod na dagat dazaw diri makapadazon ka pagtintal ka bata. ");
INSERT INTO mmn_vpl VALUES ("MT18_7","070_18_7","MAT","18","7","7","Kalooy intawon ya mga tao kay mataed gazed ya antintal kaniran dazaw ambiza siran kanao kay ani ya batasan na mga tao dini ka kalibotan. Kamhan ya tao nga magtintalay ka toong iba ka pagbiza kanao magalised gazed iza kay-an kay silotan gazed iza na Diyos pagdakola. ");
INSERT INTO mmn_vpl VALUES ("MT18_8","070_18_8","MAT","18","8","8","Pamolinged ini nga kon anhinang ya kanmong alima daw paa ka maonga ipaheneng gazed ya alima daw paa mo singed ka otdon mo iton kamhan itimbag ngaro. Kay bisan mapiang di ko ka dini pen iko ka kalibotan mahatagan ko ka bag-ong kinabohi nga diri mawara. Kay kon diri mo ipaheneng ya maonga ka kanmong alima daw paa ikatimbag na Diyos ya tibolos lawas mo doro ka impirno nga waray pagkapareng. ");
INSERT INTO mmn_vpl VALUES ("MT18_9","070_18_9","MAT","18","9","9","Bisan ya kanmong mata kon makaonga iton ka kanmong hena-hena ipaheneng gazed ya mata mo dazaw diri anseleng ka maonga. Singed ka kaw-en mo ya mata mo kamhan itimbag ngaro. Kay bisan pikas ka lamang ya mata mo ka dini pen iko ka kalibotan waray bali kay mahatagan ko ka bag-ong kinabohi nga diri mawara. Kay kon diri mo ipaheneng ya mata mo ka pagseleng ka maonga ikatimbag na Diyos ya tibolos lawas mo doro ka impirno. ");
INSERT INTO mmn_vpl VALUES ("MT18_10","070_18_10","MAT","18","10","10","Diri mazo pagtamazen ya bisan isa nga bata kay sabten mazo ini nga ya mga sogoonon nga taga langit nga mga magtabangay kaniran onay siran dizan ka kanaong Ama nga nagahela daked ka langit. Agon may logar niran ka pagsombong kamazo kon antamay kamo ka bata. ");
INSERT INTO mmn_vpl VALUES ("MT18_11","070_18_11","MAT","18","11","11","Hao nga minhon-a ka bisan sin-o ya mahon-ang tao minkarimbaba hao ka kalibotan kay antabang hao ka mga salaan nga tao dazaw malibri siran ka silot ka kanirang mga sala. ");
INSERT INTO mmn_vpl VALUES ("MT18_12","070_18_12","MAT","18","12","12","Wani pen ya pamolinged mahitenged ka tood nao ka pagkarimbaba ka kalibotan. Singed iton ka tao nga may isang ka gatos nga karniro. Kamhan nalaag ya isa. Kamhan inbilin naiza ya kasizaman may sizam nga ka karniro dizan ka samsamanan kay ampangita gazed iza ka isa nga nalaag. ");
INSERT INTO mmn_vpl VALUES ("MT18_13","070_18_13","MAT","18","13","13","Pagkakiti ka naiza labaw pen ya toong kasaza kaini nga isa ka toong kasaza ka mga kasizaman may sizam nga wara malaag. ");
INSERT INTO mmn_vpl VALUES ("MT18_14","070_18_14","MAT","18","14","14","Ani isab ya batasan na kanaong Ama nga nagahela daked ka langit kay diri iza ansogot kon madara doro ka impirno ya bisan isa kang bolos nga bata. ");
INSERT INTO mmn_vpl VALUES ("MT18_15","070_18_15","MAT","18","15","15","Nagasindo pen si Hisos ka toong mga sakop nga nagalaong nga dizan ka kamazong lomon kan Kristo kon magkasazep ya isa kanmo dadhen mo iza dizan ka waray lain makabati. Kamhan panan-ogan mo iza kon ono ya toong sazep kanmo. Kon manalinga iza kanmo mag-inoliay kamo ka beet nga magazon. ");
INSERT INTO mmn_vpl VALUES ("MT18_16","070_18_16","MAT","18","16","16","Piro kon diri iza gosto ampahosay kanmo magpaiba ko ka isa bisan kon dowa pen nga sakop nao dizan kaiton nga tao dazaw magmatood siran ka pagsaksi niran ka mga pagpanaba mazo. ");
INSERT INTO mmn_vpl VALUES ("MT18_17","070_18_17","MAT","18","17","17","Kamhan kon diri pen iza magpanalinga ipanan-og mo iton doro ka kanaong mga sakop nga nagatipon. Kon diri iza gosto ampahosay dizan kaniran maglikay iko lamang kaiton nga tao singed ka paglikay mo ka mga tao nga diri ankilala kanao daw ya mga magsokotay ka mga bohis kay maonga siran nga tao. ");
INSERT INTO mmn_vpl VALUES ("MT18_18","070_18_18","MAT","18","18","18","Timan-an mazo gazed ini nga bisan ono ya diri mazo itogot dizan ka kanaong mga sakop nga nagatipon ani isab iton ya mahinang daked ka hela na kanaong Ama. Kamhan bisan ono ya itogot mazo dizan kaniran ani isab iton ya mahinang daked ka hel-anan na kanaong Ama. ");
INSERT INTO mmn_vpl VALUES ("MT18_19","070_18_19","MAT","18","19","19","Dini ka kalibotan bisan kon dowa ka kamo nga nagakaozon ka kamazong pagpangamozo ka Diyos bisan ono ya kamazong inkinahanglan ihatag kamazo na kanaong Ama nga nagahela daked ka langit. ");
INSERT INTO mmn_vpl VALUES ("MT18_20","070_18_20","MAT","18","20","20","Kay bisan kon dowa kon tolo kang bolos ya tao nga mintipon kay hao ya insakopan niran na, dizan hao iba kaniran pagtipon. ");
INSERT INTO mmn_vpl VALUES ("MT18_21","070_18_21","MAT","18","21","21","Pagkakamhan ni Hisos pagsindo kaniran si Pidro minkarini iza kay ampangotana iza nga Ginoo, daw kapira makasala kanao ya bisan sin-o nga tao, kamhan pasaylohon nao gihapon iza? Keteb ka pito kon pira? ");
INSERT INTO mmn_vpl VALUES ("MT18_22","070_18_22","MAT","18","22","22","Minsambag si Hisos nga diri kon kapito ka lamang basta kay pito nga ka kapitoan ");
INSERT INTO mmn_vpl VALUES ("MT18_23","070_18_23","MAT","18","23","23","kay ya pagpasaylo na Diyos ka kamazong mga sala singed iton ka hari nga nagasosi kon pira ya otang na toong mga sogoonon. ");
INSERT INTO mmn_vpl VALUES ("MT18_24","070_18_24","MAT","18","24","24","Pagsogod ka naiza pagpanokot indara niran ya isang sogoonon ngarini kay napolo nga ka libo nga ka pisos ya toong otang. ");
INSERT INTO mmn_vpl VALUES ("MT18_25","070_18_25","MAT","18","25","25","Wara gazed ya toong ikabazad agon minsogo ya hari ka mga iba nga sogoonon nga ibaligza mazo ya otangan doro ka makapalit. Ibaligza sab ya toong asawa daw mga maanak daw bisan ono ya toong betang. Kay ya ikabazad kaniran ani makabazad ka otang. ");
INSERT INTO mmn_vpl VALUES ("MT18_26","070_18_26","MAT","18","26","26","Kamhan minpatilohod dazon ya sogoonon nga otangan kay nagapakilooy nga nagalaong nga Sinyor, omanget ko naa kanao kay bayran ta ko ka tanan! ");
INSERT INTO mmn_vpl VALUES ("MT18_27","070_18_27","MAT","18","27","27","Kamhan nalooy ya hari ka toong sogoonon. Impasaylo di naiza ya toong otang. Kamhan impaoli di ya sogoonon ngaro ka lagkaw. ");
INSERT INTO mmn_vpl VALUES ("MT18_28","070_18_28","MAT","18","28","28","Paglogwa na sogoonon ka lagkaw na hari insogat naiza ya iba nga sogoonon nga may daan otang ka bayinti pisos ka lamang dizan ka pinasaylo. Kamhan paglabay naiza ka otangan inpitlok dazon naiza ya lieg daw minlaong nga hala koni wani di ko koman bayri di hao koman dazon ka otang mo kanao. ");
INSERT INTO mmn_vpl VALUES ("MT18_29","070_18_29","MAT","18","29","29","Kamhan minpatilohod dazon ya otangan dizan ka nagasokot kay nagapakilooy iza nga nagalaong nga omanget ko naa kanao kay bayran ta ko kaan. ");
INSERT INTO mmn_vpl VALUES ("MT18_30","070_18_30","MAT","18","30","30","Ambaza kay waray kalooy ka nakaotang kanangiza. Hinoa impapriso naiza hangtod ka pagpakabazad ka otang. ");
INSERT INTO mmn_vpl VALUES ("MT18_31","070_18_31","MAT","18","31","31","Pagpakakita na mga iba nga sogoonon na hari ka hinang na pinasaylo nagalised ya kanirang hinawa ka kazehet. Kamhan minkaro siran ka hari kay pakahagdaman niran iton. ");
INSERT INTO mmn_vpl VALUES ("MT18_32","070_18_32","MAT","18","32","32","Kamhan impabalik kasab na hari ya sogoonon nga pinasaylo kay nagalaong nga maonga gazed iko! Kay izang dini kaini minpasaylo hao kanmo ka dakolang otang mo kanao kay minpahihangzo ko kanao. ");
INSERT INTO mmn_vpl VALUES ("MT18_33","070_18_33","MAT","18","33","33","Kontana malooy ko ka nakaotang kanmo singed ka pagkalooy nao kanmo. ");
INSERT INTO mmn_vpl VALUES ("MT18_34","070_18_34","MAT","18","34","34","Kamhan nazehet gazed ya hari agon impaated naiza ka toong sogoonon ngaro ka prisohan. Kamhan insilotan iza keteb ka pagpakabazad naiza ka dakolang otang. ");
INSERT INTO mmn_vpl VALUES ("MT18_35","070_18_35","MAT","18","35","35","Pagkakamhan ni Hisos pagpanan-og minlaong iza kaniran nga singed isab kaiza ya hinangen kamazo na kanaong Ama nga daked ka langit, kon diri kamo ampasaylo pagtigbeet ka kamazong iba. ");
INSERT INTO mmn_vpl VALUES ("MT19_1","070_19_1","MAT","19","1","1","Pagkakamhan ni Hisos pagsindo ka toong mga sakop minpanaw iza dizan ka lopa nga Galiliya. Kamhan minkandipi iza ka sapa nga Hordan kay pasinged pen iza doro ka lopa nga Yoda. ");
INSERT INTO mmn_vpl VALUES ("MT19_2","070_19_2","MAT","19","2","2","Masarang kataed ya tao nga minsonod kanangiza. Kamhan impanbahaw naiza ya mga masakiten dizan kaniran. ");
INSERT INTO mmn_vpl VALUES ("MT19_3","070_19_3","MAT","19","3","3","Na, minkarini disab kan Hisos ya mga Parasiyo kay amporba siran pagpangotana nga ya tao nga ampakigbelag ka toong asawa daw anlapas iza ka balaed na Diyos kon diri? ");
INSERT INTO mmn_vpl VALUES ("MT19_4","070_19_4","MAT","19","4","4","Minsambag si Hisos nga daw wara pen kamo magbasa ka kasoyatan na Diyos nga nagalaong nga kawandini pen ka sinogdan pen na kalibotan ya Diyos ani ya minhinang ka amaama daw ya babazi. ");
INSERT INTO mmn_vpl VALUES ("MT19_5","070_19_5","MAT","19","5","5","Sokad kaiton kon anminze ya amaama ambelag iza ka toong ginikanan dazaw antipon iza ka toong asawa. Kamhan sirang dowa nahinang nga isang bolos nga tao kay namag-isa di ya kanirang hinawa. ");
INSERT INTO mmn_vpl VALUES ("MT19_6","070_19_6","MAT","19","6","6","Kamhan diri di gazed pabelagen siran na bisan sin-o nga tao kay ya mag-asawa in-isa di siran na Diyos. ");
INSERT INTO mmn_vpl VALUES ("MT19_7","070_19_7","MAT","19","7","7","Kamhan minpangotana sab ya mga Parasiyo kan Hisos nga kon matood ya inlaong mo kanami kay ono sa imbilin ni Moysis ya kanaming karaan ka sogo nga nagalaong nga kon ampakigbelag ya tao ka toong asawa kinahanglan ihatag naiza ka toong asawa ya soyat para ka pagpamatood nga namagkabelag di sirang dowa. ");
INSERT INTO mmn_vpl VALUES ("MT19_8","070_19_8","MAT","19","8","8","Minsambag si Hisos nga intogotan kamo ni Moysis ka pagpakigbelag ka kamazong asawa kay mahagdam iza nga diri kamo gazed ampatoo ka sindo na Diyos. Piro kawandini pen ka sinogdan pen na kalibotan waray itogot na Diyos iton nga batasan. ");
INSERT INTO mmn_vpl VALUES ("MT19_9","070_19_9","MAT","19","9","9","Sabten mazo ini nga bisan sin-o ya ampakigbelag ka toong asawa nga waray sala na asawa ka paghenay, magahenay ya bana kon anminze iza ka lain babazi. ");
INSERT INTO mmn_vpl VALUES ("MT19_10","070_19_10","MAT","19","10","10","Kamhan minsambag ya mga sinarigan ni Hisos nga kon diri ko antogot ka tao ka pagpakigbelag ka toong asawa madazaw kon diri ampangasawa ya tao kay mataed ya kinabido. ");
INSERT INTO mmn_vpl VALUES ("MT19_11","070_19_11","MAT","19","11","11","Minsambag si Hisos nga may mga tao nga impili daan na Diyos kaniran nga diri siran anminze. Piro ya dalan nga impili na Diyos kaniran diri kon ani ya pinili na Diyos ka tanan mga tao. ");
INSERT INTO mmn_vpl VALUES ("MT19_12","070_19_12","MAT","19","12","12","Na, may tao nga diri makaminze kay inkatao nga nakolangan ya toong lawas. May tao nga diri makaminze kay imbot-an di iza. May tao nga diri anminze kay dazaw isahen naiza ya toong hena-hena ka pagtarabaho dizan ka Diyos. Kon angeten na tao nga diri iza anminze madazaw gazed iton. ");
INSERT INTO mmn_vpl VALUES ("MT19_13","070_19_13","MAT","19","13","13","Pagkakamhan kaiza may mga mindara ka mga bata dizan kan Hisos kay ipadampa siran kanangiza dazaw panaranginan ka madazaw daw paampoan. Kamhan inkasab-an siran na mga sakop ni Hisos ");
INSERT INTO mmn_vpl VALUES ("MT19_14","070_19_14","MAT","19","14","14","piro minlaong si Hisos nga pakarinhen mazo siran kanao kay ya singed kaniran ani ya mga in-angay na Diyos. ");
INSERT INTO mmn_vpl VALUES ("MT19_15","070_19_15","MAT","19","15","15","Kamhan impandampa matood ni Hisos ya olo na mga bata kay dazaw panaranginan ka madazaw. Kamhan minpanaw iza. ");
INSERT INTO mmn_vpl VALUES ("MT19_16","070_19_16","MAT","19","16","16","Kamhan may isang amaama minsogat kan Hisos kay ampangotana iza nga Maistro, daw ono kontana ya hinangen o nga madazaw dazaw tagan hao ka bag-ong kinabohi nga diri mawara? ");
INSERT INTO mmn_vpl VALUES ("MT19_17","070_19_17","MAT","19","17","17","Minsambag si Hisos nga kay ono sang pangotanhen sa mo hao mahitenged ka madazaw? Isa ka ya madazaw ani ya Diyos. Magtoman ko ka toong mga sogo anipen ko kon mahatagan ko ka bag-ong kinabohi nga diri mawara. ");
INSERT INTO mmn_vpl VALUES ("MT19_18","070_19_18","MAT","19","18","18","Minsambag ya amaama nga daw ono sang mga sogoa? Minsambag si Hisos nga azaw magpatay ka tao, azaw maghenay, azaw pangawat, azaw pamakak. ");
INSERT INTO mmn_vpl VALUES ("MT19_19","070_19_19","MAT","19","19","19","Magtahod ko ka kanmong ama daw ina. Mag-azak ko ka kanmong iba singed ka pag-azak mo ka kanmong kaogaringen. ");
INSERT INTO mmn_vpl VALUES ("MT19_20","070_19_20","MAT","19","20","20","Minsambag ya amaama nga mintoman hao kaiton nga tanan. Daw ono pen ya nakolang dini kanao? ");
INSERT INTO mmn_vpl VALUES ("MT19_21","070_19_21","MAT","19","21","21","Minsambag si Hisos nga kon mainsakto ya pagtoman mo ka mga sogo na Diyos pomanaw ko naa. Ipamaligza di mo ya kanmong mga betang. Kamhan ya bazad ipanhatag ka mga pobri anipen ko kon somakop kanao dazaw sobra pen ya mga mahalen mo daked ka hel-anan na Diyos. ");
INSERT INTO mmn_vpl VALUES ("MT19_22","070_19_22","MAT","19","22","22","Pagpakabati ka na batan-en nga amaama ka laong ni Hisos minpanaw iza. Nagalised ya toong hinawa kay diri kontana naiza ibaligza ya toong mga betang. ");
INSERT INTO mmn_vpl VALUES ("MT19_23","070_19_23","MAT","19","23","23","Kamhan minlaong si Hisos ka toong mga sakop nga timan-an mazo gazed ini nga ya tao nga kowartahan malised gazed ya pagsakop naiza ka Diyos. ");
INSERT INTO mmn_vpl VALUES ("MT19_24","070_19_24","MAT","19","24","24","Pamolinged ini nga ya karabaw kon an-azi ka teheb na dagem masazon iton ka pagsakop na kowartahan ka Diyos kay wili ya toong hena-hena ka toong kowarta. ");
INSERT INTO mmn_vpl VALUES ("MT19_25","070_19_25","MAT","19","25","25","Kamhan nabereng gazed ya mga sakop ni Hisos daw minsambag nga kon malised ya pagsakop na kowartahan ka Diyos diri baza makalangit ya bisan sin-o nga tao. ");
INSERT INTO mmn_vpl VALUES ("MT19_26","070_19_26","MAT","19","26","26","Kamhan minseleng si Hisos kaniran daw minsambag nga kon ya tao ka lamang diri makahimo piro ya Diyos makahimo iza ka tanan. ");
INSERT INTO mmn_vpl VALUES ("MT19_27","070_19_27","MAT","19","27","27","Kamhan minsambag si Pidro kan Hisos nga kami nga kanmong mga sinarigan izang dini kaini minbiza kami ka tanan dazaw makasakop kami kanmo. Agon daw ono pen ya ihatag mo kanami? ");
INSERT INTO mmn_vpl VALUES ("MT19_28","070_19_28","MAT","19","28","28","Minsambag si Hisos nga timan-an mazo gazed ini nga kay-an ka pagkabag-o na kalibotan hao nga minhon-a ka bisan sin-o nga mahon-ang tao, hao ya anlo-to dizan ka lo-toanan ka paghari nga madazaw selengan. Kamhan kamo nga napolo may dowa nga sinarigan manlo-to isab kamo dizan ka lo-toanan. Kay ampanhokom kamo ka mga kaliwatan na mga napolo may dowa nga maanak ni Israil. ");
INSERT INTO mmn_vpl VALUES ("MT19_29","070_19_29","MAT","19","29","29","Kamhan bisan sin-o ya minsakop kanao pasobrahan na Diyos ka pagbales ka madazaw. Tagan isab iza ka bag-ong kinabohi nga diri mawara. Kay minbiza iza ka toong hel-anan daw ya mga lomon daw ya toong ginikanan daw ya mga bata daw oma kay dazaw ansakop iza kanao daw anwali sab iza ka sindo mahitenged kanao. ");
INSERT INTO mmn_vpl VALUES ("MT19_30","070_19_30","MAT","19","30","30","Na, koman nga panahon ya mga mataed nga dato mga pobri siran kay-an. Kamhan ya mga pobri mga dato siran kay-an. Ani ini ya inlaong ni Hisos ka toong mga sinarigan. ");
INSERT INTO mmn_vpl VALUES ("MT20_1","070_20_1","MAT","20","1","1","Kamhan minlaong si Hisos ka toong mga sakop nga wani pen ya pamolinged ka pagsohol na Diyos ka toong mga sakop. Na, singed iton ka tag-iza ka oma nga intamnan ka obas. Na, pagkabokas minboas ya tag-iza pagpanaw kay dazaw ampangita iza ka mga tao nga makatarabaho doro ka toong oma. ");
INSERT INTO mmn_vpl VALUES ("MT20_2","070_20_2","MAT","20","2","2","Kamhan anpakigsabot iza kaniran kon pira ya sohol ka inaldaw. Kamhan patarabahoon naiza siran doro ka toong oma. ");
INSERT INTO mmn_vpl VALUES ("MT20_3","070_20_3","MAT","20","3","3","Na, pagkaalas noybi di minpasinged ya tag-iza doro ka mirkado. Kamhan dizan di ya mga tao nga nagahela-hela lamang kay waray tarabaho niran. ");
INSERT INTO mmn_vpl VALUES ("MT20_4","070_20_4","MAT","20","4","4","Agon minlaong iza kaniran nga magtarabaho disab kamo doro ka kanaong oma kay ansohol hao kamazo. Kamhan minsogot siran. ");
INSERT INTO mmn_vpl VALUES ("MT20_5","070_20_5","MAT","20","5","5","Pagkaedto di kaiza daw pagkaalas tris gihapon minbalik iza ka mirkado kay andogang pen iza ka makatarabaho kanangiza. ");
INSERT INTO mmn_vpl VALUES ("MT20_6","070_20_6","MAT","20","6","6","Bisan ka hapit mag-alas singko minbalik disab iza ka mirkado. Dizan pen gihapon ya mga tao nga nagahela-hela. Kamhan nangotana iza nga kay ono sa nga wara sa kamo magtarabaho komang aldaw? ");
INSERT INTO mmn_vpl VALUES ("MT20_7","070_20_7","MAT","20","7","7","Minsambag siran nga waray magatarabaho kanami. Minsambag ya tao nga magtarabaho kamo doro ka kanaong oma. ");
INSERT INTO mmn_vpl VALUES ("MT20_8","070_20_8","MAT","20","8","8","Na, pagsalep di na sega minlaong ya tag-iza ka toong sinarigan nga pakarinhen mo ya mga tarabahanti kay panoholan di nao siran. Hon-ahen nao pagsohol ya mga nahori nga minseled. Kamhan horihen di lamang pagsohol ya mga minhon-a ka pagtarabaho. Ani ini ya togon na tag-iza ka toong sinarigan. ");
INSERT INTO mmn_vpl VALUES ("MT20_9","070_20_9","MAT","20","9","9","Kamhan mindateng dizan ya mga minseled ka tarabaho ka pagkaalas singko. Kamhan intagan siran ka sohol ka inaldaw singed ka nasabotan ka daang tarabahanti. ");
INSERT INTO mmn_vpl VALUES ("MT20_10","070_20_10","MAT","20","10","10","Kamhan mindateng disab ya mga mahon-a ka pagtarabaho. Silaong niran nga dakola pen ya kanirang sohol kay minhon-a siran pagtarabaho ambaza kay anika gihapon ya kanirang sohol. ");
INSERT INTO mmn_vpl VALUES ("MT20_11","070_20_11","MAT","20","11","11","Agon minmahay gazed siran dizan ka tag-iza ka oma ");
INSERT INTO mmn_vpl VALUES ("MT20_12","070_20_12","MAT","20","12","12","nga nagalaong nga ya mga nahori kanami pagseled isang ka oras ka ya kanirang pagtarabaho. Kamhan in-angay mo siran ka kanaming sohol bisan isa lamang nga ka oras ya pagtarabaho niran. Kamhan kami min-anget kami ka isang ka aldaw nga tarabaho daw ya kapaso. ");
INSERT INTO mmn_vpl VALUES ("MT20_13","070_20_13","MAT","20","13","13","Minsambag ya tag-iza dizan ka isang tao nga amigo, wara hao maglimbong kanmo kay ya pagsabot nita ka sohol ka inaldaw minsogot iko. ");
INSERT INTO mmn_vpl VALUES ("MT20_14","070_20_14","MAT","20","14","14","Na, dawata ya kanmong sohol kamhan omoli ko naa kay naazak hao kon mag-anika ya sohol na mga nahori ka sohol na mga minhon-a ka pagtarabaho. ");
INSERT INTO mmn_vpl VALUES ("MT20_15","070_20_15","MAT","20","15","15","Hao ya magaponto ka kanaong kowarta. Kontana diri kamo mag-arig ka kanaong pagpanhatag. ");
INSERT INTO mmn_vpl VALUES ("MT20_16","070_20_16","MAT","20","16","16","Na, pagkakamhan ni Hisos pagpamolinged ka toong mga sinarigan minlaong iza nga ya mga mahori pagsakop kanao singed ka mahon-a siran ka pagsohol. Kamhan ya mga mahon-a pagsakop kanao singed ka mahorihan siran ka pagsohol. Mahatagan gazed sirang tanan ka bag-ong kinabohi nga diri mawara. ");
INSERT INTO mmn_vpl VALUES ("MT20_17","070_20_17","MAT","20","17","17","Pagkakamhan kaiza minpasinged si Hisos ngaro ka siyodad nga Hirosalem. Ka wara pen siran dateng doro impalain pagpatindeg ni Hisos ya toong mga sinarigan kay ampakahagdam iza kaniran ");
INSERT INTO mmn_vpl VALUES ("MT20_18","070_20_18","MAT","20","18","18","nagalaong nga mamanaw di kita ngaro ka siyodad nga Hirosalem. Kamhan doro kaiton nga dapit hao nga minhon-a ka bisan sin-o nga mahon-ang tao, iated hao doro ka mga oloolo na mga pari na mga Yodayo daw ya mga maistro ka tinoohan na mga Yodayo kay hokman hao niran ka kamatazen. ");
INSERT INTO mmn_vpl VALUES ("MT20_19","070_20_19","MAT","20","19","19","Kamhan iated sab hao niran doro ka mga diri kon Yodayo nga nagahari dini ka kantang lopa. Kamhan pagasorasorahen hao niran. Pagkakamhan niran paglatos kanao ilansang hao niran ka kros. Pagdateng ka ikatolong aldaw sokad ka kanaong pagkapatay mabohi hao pagbalik garing ka lebeng. Ani ini ya pakahagdam ni Hisos ka toong mga sinarigan. ");
INSERT INTO mmn_vpl VALUES ("MT20_20","070_20_20","MAT","20","20","20","Pagkakamhan kaiza ya ina na mga maanak ni Sibidiyo minkarini iza kan Hisos iba si Santiago daw si Howan. Kamhan dizan ka paahan ni Hisos minlohod ya ina kay may ihangzo kontana naiza kan Hisos. ");
INSERT INTO mmn_vpl VALUES ("MT20_21","070_20_21","MAT","20","21","21","Kamhan nangotana si Hisos nga daw ono ya maazakan mo? Minsambag iza nga kon somogot ko kay-an ka paghari mo palo-toon mo ya dowang maanak o dizan ka kanmong sain. Ya isa kontana palo-toon dizan ka too mo. Ya isa dimbali ka wala mo. ");
INSERT INTO mmn_vpl VALUES ("MT20_22","070_20_22","MAT","20","22","22","Minsambag si Hisos nga wara kamo makasabot kon ono ya inhangzo mazo kanao. Daw makaanget kamo ka kalised nga singed ka maazihan nao kay-an? Minsambag sirang dowa nga makahimo kami kaiton. ");
INSERT INTO mmn_vpl VALUES ("MT20_23","070_20_23","MAT","20","23","23","Minsambag si Hisos nga ya mga kalised nga andateng kanao andateng sab matood kamazo. Piro ya inhangzo mazo ka paglo-to dizan ka too nao daw dimbali ka wala nao diri kon hao ya ampili ka tao kay impili daan na Diyos kon sin-o ya makalo-to dizan ka kanaong sain. ");
INSERT INTO mmn_vpl VALUES ("MT20_24","070_20_24","MAT","20","24","24","Na, pagpakabati ka na mga napolo nga sinarigan nazehet siran kan Santiago daw si Howan. ");
INSERT INTO mmn_vpl VALUES ("MT20_25","070_20_25","MAT","20","25","25","Kamhan impatipon siran ni Hisos kay anlaong iza nga mahagdam kamo ka batasan na mga diri kon Yodayo nga nagahari dini ka kantang lopa. Magmandaray gazed siran ka mga tao. ");
INSERT INTO mmn_vpl VALUES ("MT20_26","070_20_26","MAT","20","26","26","Piro kamo nga kanaong mga sakop, diri kamo maghaod ka kanirang batasan kay dizan kamazo kon naazak ya isa nga iza ya labaw kinahanglan ampangalagad iza kamazo. ");
INSERT INTO mmn_vpl VALUES ("MT20_27","070_20_27","MAT","20","27","27","Kon naazak ya isa nga iza ya may katenged nga ataas kinahanglan ampangalagad iza kamazo singed ka pagpangalagad na oripen. ");
INSERT INTO mmn_vpl VALUES ("MT20_28","070_20_28","MAT","20","28","28","Kay hao nga minhon-a ka bisan sin-o nga mahon-ang tao minkarimbaba hao dini kamazo dazaw ampangalagad hao kamazo. Wara hao magpaalagad kamazo kanao. Ampahalad sab hao ka kanaong kinabohi doro ka kros kay hao ya ambazad ka mga sala na mga mataed nga tao. Ani ini ya sindo ni Hisos ka toong mga sinarigan. ");
INSERT INTO mmn_vpl VALUES ("MT20_29","070_20_29","MAT","20","29","29","Pagkakamhan kaiza minpanaw sin Hisos dizan ka longsod nga Hiriko. Masarang kataed ya tao nga minsonod kanangiza. ");
INSERT INTO mmn_vpl VALUES ("MT20_30","070_20_30","MAT","20","30","30","Na, dizan ka kilid na karsada may dowang ka tao nga nabota nga nagalo-to. Pagpakabati ka niran nga si Hisos ani ya minlabay dizan kaniran minhawag siran nga Ginoo nga kaliwat ni Dabid, kaloy-an mo kami! ");
INSERT INTO mmn_vpl VALUES ("MT20_31","070_20_31","MAT","20","31","31","Kamhan inbaheg siran na mga tao nga nagalaong nga pahenek kamo dizan. Kamhan mintoda hinoa sirang dowa paghawag nga Ginoo nga kaliwat ni Dabid, kaloy-i intawon kami! ");
INSERT INTO mmn_vpl VALUES ("MT20_32","070_20_32","MAT","20","32","32","Kamhan minheneng si Hisos. Inpakarini siran naiza kay pangotanhen nga daw ono ya gosto mazo kanao? ");
INSERT INTO mmn_vpl VALUES ("MT20_33","070_20_33","MAT","20","33","33","Minsambag sirang dowa nga Ginoo, ya gosto nami nga makakita ya kanaming mata. ");
INSERT INTO mmn_vpl VALUES ("MT20_34","070_20_34","MAT","20","34","34","Kamhan nalooy si Hisos kaniran. Paghogam naiza ka kanirang mata madazaw matood ya kanirang mata. Kamhan min-iba siran kan Hisos. ");
INSERT INTO mmn_vpl VALUES ("MT21_1","070_21_1","MAT","21","1","1","Na, pagpasinged nin Hisos ngaro arani ka siyodad nga Hirosalem mindateng di siran ka bariyo nga Bitpahi dizan tenged ka bobong nga inngaranan ka Olibo. Kamhan minsogo si Hisos ka toong sinarigan nga dowa siran ");
INSERT INTO mmn_vpl VALUES ("MT21_2","070_21_2","MAT","21","2","2","nga nagalaong nga komaro kamo naa ka bariyo dizan ka hon-ahan mazo. Pagdateng ka mazo doro makakita kamo dazon ka isang asno nga klasi na kabayo nga in-ektan dizan iba disab ya toong nati. Hobaden mazo siran daw tozokon ngarini kanao. ");
INSERT INTO mmn_vpl VALUES ("MT21_3","070_21_3","MAT","21","3","3","Kon may mangotana kamazo magsambag kamo nga inkinahanglanan ini na kanaming oloolo. Kamhan ankalit ya tao pagtogot kamazo. Ani ini ya sogo ni Hisos kaniran ");
INSERT INTO mmn_vpl VALUES ("MT21_4","070_21_4","MAT","21","4","4","kay nakatoman iza ka inlaong na propita na Diyos kay kawandini pen nagalaong iza nga wani ya inlaong na Diyos mahitenged ka pagdateng ni Hisos ka Hirosalem nga ");
INSERT INTO mmn_vpl VALUES ("MT21_5","070_21_5","MAT","21","5","5","long-an ya taga Siyon nga selengi mazo, waton di ngarini ya kamazong hari. Bisan hari iza nagasakay gihapon iza ka batan-en pen nga asno nga klasi na kabayo. Diri kon maiseg iza paghari naiza ka mga tao. Ani ini ya panan-og na karaang propita. ");
INSERT INTO mmn_vpl VALUES ("MT21_6","070_21_6","MAT","21","6","6","Kamhan ya mga sinarigan nga insogo ni Hisos namanaw sirang dowa kay kaw-en niran ya kabayo. ");
INSERT INTO mmn_vpl VALUES ("MT21_7","070_21_7","MAT","21","7","7","Kamhan intozok niran dizan kan Hisos. Inhanigan sab niran ka kanirang mga bado ya likod na kabayo daw ya toong nati kay sakzan koman ni Hisos. ");
INSERT INTO mmn_vpl VALUES ("MT21_8","070_21_8","MAT","21","8","8","Pagpakasakay ka naiza inhanigan dazon na mga mataed nga tao ya dalan ka kanirang mga bado. Kamhan ya mga iba isab nangotod ka mga paka kay ibetang isab ka dalan kay tahodon si Hisos. ");
INSERT INTO mmn_vpl VALUES ("MT21_9","070_21_9","MAT","21","9","9","Mataed ya mga tao nga minhon-a kan Hisos daw mataed isab ya mga mahori. Kamhan namagdengandengan siran pagsinggit nga sazaen ya kaliwat ni Dabid! Sazaen ya mindateng garing ka Ginoo. Intagan iza na Ginoo ka dakola nga gahem. Sazaen, sazaen ya Diyos! Ani ini ya pagsaza na mga tao kan Hisos. ");
INSERT INTO mmn_vpl VALUES ("MT21_10","070_21_10","MAT","21","10","10","Pagpakadateng ka ni Hisos ka siyodad nga Hirosalem mabibo gazed ya tanan mga taga Hirosalem daw nagalaong siran nga daw sin-o sa iton nga taohana? ");
INSERT INTO mmn_vpl VALUES ("MT21_11","070_21_11","MAT","21","11","11","Minsambag ya mga mataed nga tao nga si Hisos iton nga taga Nazarit nga longsod doro ka Galiliya. Propita iza na Diyos. Ani ini ya pagsaza na mga tao kan Hisos ka pagdateng naiza ka Hirosalem. ");
INSERT INTO mmn_vpl VALUES ("MT21_12","070_21_12","MAT","21","12","12","Pagkakamhan kaiza dizan ka Hirosalem minseled si Hisos ka dakolang lagkaw nga pangamozoanan ka Diyos. Kamhan inpamogaw gazed naiza ya mga mamaligzaay daw ya mga mamalitay. Inpandeeg sab naiza ya mga lamisa na mga Yodayo nga magsilihay ka mga kowarta nga indara na mga taga laing dapit. Impanowad disab naiza ya mga siya na mga magbaligzaay ka salapati nga mga ihaladay na mga tao ka Diyos. ");
INSERT INTO mmn_vpl VALUES ("MT21_13","070_21_13","MAT","21","13","13","Kamhan minbaheg iza kaniran nga nagalaong nga may daan pinasoyat na Diyos nga nagalaong nga ya kanaong lagkaw ani ya lagkaw ka pagpangamozo na mga tao kanao. Ambaza kay inhinang di mazo iton ka datnganan na mga tolisan nga nagapanlimbong ka mga tao. Ani ini ya inbaheg ni Hisos kaniran. ");
INSERT INTO mmn_vpl VALUES ("MT21_14","070_21_14","MAT","21","14","14","Kamhan dini ka dakolang lagkaw na Diyos minkarini kan Hisos ya mga nabota daw ya mga napiang. Kamhan inpanbahaw siran ni Hisos. ");
INSERT INTO mmn_vpl VALUES ("MT21_15","070_21_15","MAT","21","15","15","Piro ya mga oloolo na mga pari daw ya mga maistro ka tinoohan na mga Yodayo nangazehet siran pagpakakita niran ka mga magazong hinang ni Hisos daw ya mga bata nga naninggit nga sazaen ya kaliwat ni Dabid! ");
INSERT INTO mmn_vpl VALUES ("MT21_16","070_21_16","MAT","21","16","16","Agon nangotana ya mga oloolo kan Hisos nga daw wara ko makabati ka kanirang inlaong mahitenged kanmo? Minsambag si Hisos nga nakabati di gazed hao. Daw wara pen kamo makabasa ka daan pinasoyat na Diyos nga nagalaong nga ya mga bata daw ya mga nagasoso pen ani ya intoldoan na Diyos ka pagpanaba ka matood nga sinaza. ");
INSERT INTO mmn_vpl VALUES ("MT21_17","070_21_17","MAT","21","17","17","Pagkakamhan ni Hisos pagsambag kaniran minpanaw iza dizan kaniran. Kamhan minlogwa iza ka siyodad nga Hirosalem kay ankaro iza ka bariyo nga Bitani kay ankolang iza dizan. ");
INSERT INTO mmn_vpl VALUES ("MT21_18","070_21_18","MAT","21","18","18","Pagkamasiselem kaiza minbalik si Hisos ka siyodad nga Hirosalem. Kamhan imbengtas gazed iza. ");
INSERT INTO mmn_vpl VALUES ("MT21_19","070_21_19","MAT","21","19","19","Kamhan dizan ka kilid na dalan nakitan naiza ya isang tanem ani ngaran ya igira. Kamhan min-arani iza ka tanem piro wara iza makakita ka bonga, mga dahon ka lamang. Kamhan minlaong si Hisos ka tanem nga sokad koman diri ko makapamonga bisan kon-ong aldaw. Kamhan nangalaza matood ya tanem garing ka gamot ngaro ka mga oldot. ");
INSERT INTO mmn_vpl VALUES ("MT21_20","070_21_20","MAT","21","20","20","Pagpakakita ka na mga sinarigan kaiton nangabereng gazed siran daw nagalaong nga ono sa ya tanem nga nangalaza di sa ya dahon? ");
INSERT INTO mmn_vpl VALUES ("MT21_21","070_21_21","MAT","21","21","21","Minsambag si Hisos nga timan-an mazo gazed ini nga kon ansarig gazed kamo ka Diyos daw diri kamo andowadowa mahimo isab mazo paghinang ka singed ka paghinang nao ka tanem. Pamolinged ini nga ya bobong dizan kon sogoon mazo iton ka pagsibeg ngaro ka dagat, ansibeg matood iton ngaro. ");
INSERT INTO mmn_vpl VALUES ("MT21_22","070_21_22","MAT","21","22","22","Kon heget ya pagtoo mazo madawat mazo ya bisan ono nga kamazong pangazoon pagpangamozo mazo ka Diyos. ");
INSERT INTO mmn_vpl VALUES ("MT21_23","070_21_23","MAT","21","23","23","Pagkakamhan kaiza minseled si Hisos pag-isab ka dakolang lagkaw na Diyos. Na, ka nagatoldo pen iza ka mga tao may mga minkarini kanangiza nga mga oloolo na mga pari na mga Yodayo daw ya mga malaas. Kamhan nangotana siran kan Hisos nga daw hain garing ya katenged mo ka pagbogaw ka mga tao kahabi? Sin-oy minhatag kanmo ka katenged ka pagpadazon ka kanmong mga hinang dini kanami? ");
INSERT INTO mmn_vpl VALUES ("MT21_24","070_21_24","MAT","21","24","24","Minsambag si Hisos kaniran nga wani sab ya pangotana nao kamazo. Kon makasambag kamo anipen hao magpanan-og kamazo kon hain garing ya kanaong katenged ka paghinang kaiton. ");
INSERT INTO mmn_vpl VALUES ("MT21_25","070_21_25","MAT","21","25","25","Na, daw hain garing ya katenged ni Howan ka pagpamenzag ka mga tao? Daw garing iton ka Diyos kon garing iton ka tao? Kamhan namaglalislalis siran kon ono sa kontana ya kanirang isambag kan Hisos. Namaglaonglaong siran nga kon ansambag kita nga garing ka Diyos ya katenged ni Howan basi long-on kita ni Hisos nga kay ono sa nga diri sa kamo antoo kan Howan? ");
INSERT INTO mmn_vpl VALUES ("MT21_26","070_21_26","MAT","21","26","26","Piro kon somambag kita nga garing ka tao ya katenged ni Howan pamookon kita na mga tao kay mintoo gazed siran nga si Howan ani ya matood nga propita na Diyos. ");
INSERT INTO mmn_vpl VALUES ("MT21_27","070_21_27","MAT","21","27","27","Kamhan minsambag siran kan Hisos nga wara kami mahagdam. Kamhan minsambag isab si Hisos nga diri sab hao ampanan-og kamazo kon hain garing ya kanaong katenged ka pagpadazon ka kanaong mga inhinang. ");
INSERT INTO mmn_vpl VALUES ("MT21_28","070_21_28","MAT","21","28","28","Kamhan nagapadazon si Hisos paglaong ka mga oloolo na mga pari daw ya mga malaas nga panalinga kamo. Pamolinged ini nga may tao nga dowa ya toong maanak nga amaama. Na, may isang aldaw nga minsogo iza ka magorang nga Dong, magtarabaho ko komang aldaw doro ka oma. ");
INSERT INTO mmn_vpl VALUES ("MT21_29","070_21_29","MAT","21","29","29","Minsambag ya magorang nga diri hao antarabaho. Piro ka wara pen madogay minhinelsel iza. Kamhan minpanaw iza ngaro ka oma kay antarabaho iza. ");
INSERT INTO mmn_vpl VALUES ("MT21_30","070_21_30","MAT","21","30","30","Kamhan inkaro disab na ama ya manghod daw insogo disab nga Dong, magtarabaho ko komang aldaw doro ka oma. Minsambag iza nga hee, ampanaw di hao. Ambaza kay wara iza magkaro ka oma. ");
INSERT INTO mmn_vpl VALUES ("MT21_31","070_21_31","MAT","21","31","31","Na, dizan kanirang dowa daw sin-o ya mintoman ka sogo na toong ama? Minsambag siran nga ya magorang ani gazed ya minsogot ka sogo na toong ama. Minsambag si Hisos nga sabten mazo ini nga ya mga magsokotay ka mga bohis daw ya mga babazi nga minhinang ka maonga ampaseled hao kaniran ka hel-anan na kanaong Ama paghon-a ka pagpaseled nao kamazo. ");
INSERT INTO mmn_vpl VALUES ("MT21_32","070_21_32","MAT","21","32","32","Kay si Howan minkarini iza kamazo dazaw mahagdam kamo kon ono ya batasan nga matadeng. Kamhan wara kamo magtoo kanangiza. Piro ya mga magsokotay ka mga bohis daw ya mga maongang babazi mintoo siran kan Howan. Bisan minkita disab kamo kaniran ka pagtoo niran kan Howan, wara kamo magbiza ka kamazong mga sala singed ka pagbiza niran. Wara gazed kamo magtoo kan Howan. ");
INSERT INTO mmn_vpl VALUES ("MT21_33","070_21_33","MAT","21","33","33","Kamhan indogangan pen ni Hisos pagpamolinged kaniran nagalaong nga may tag-iza ka lopa. Kamhan mintanem iza ka oma nga tamnanan ka mga obas. Inlibotan ya oma ka alad. Kamhan impakabotan naiza ya lopa kay hinangen ya salodanan ka sapa para ka pagkepeg ka mga obas. Kamhan inhinang naiza ya ataas nga lagkaw nga bantazan ka mga tanem. Kamhan nandapit iza ka mga saop. Kamhan minpanaw iza ngaro ka laing dapit. ");
INSERT INTO mmn_vpl VALUES ("MT21_34","070_21_34","MAT","21","34","34","Pagkahapit di anihen ya toong mga obas impakaro naiza ya toong mga sogoonon kay pakaw-en di kontana naiza ka toong kabahinan. ");
INSERT INTO mmn_vpl VALUES ("MT21_35","070_21_35","MAT","21","35","35","Kamhan pagdateng doro indakep di hinoa ya mga sogoonon na mga saop. Kamhan imbonalan ya isang sogoonon. Impatay ya ikadowang sogoonon. Impook ya ikatolong sogoonon ka mga bato. ");
INSERT INTO mmn_vpl VALUES ("MT21_36","070_21_36","MAT","21","36","36","Ka wara pen madogay insogo disab pagpakaro ya mga laing sogoonon nga mataed pen ka hon-a nga inpakaro. Piro impamagbonalan daw impamagpatay isab siran. ");
INSERT INTO mmn_vpl VALUES ("MT21_37","070_21_37","MAT","21","37","37","Pagkakamhan kaiza impakaro disab na tag-iza ya toong maanak nga amaama. Kay nagahena-hena iza nga tahodon gazed niran ya toong maanak. ");
INSERT INTO mmn_vpl VALUES ("MT21_38","070_21_38","MAT","21","38","38","Kamhan pagpakakita ka na mga saop nga wani di kaan andateng di ya maanak na tag-iza namagsabotsabot dazon siran nga waton di ngarini kanta ya maanak na tag-iza nga magdawatay kay-an kaini nga lopa nga toong irinsiya. Hala, pamagpatazen ta iza gazed kay dazaw kita ka mazoy makapolos ka pagpanag-iza ka lopa. ");
INSERT INTO mmn_vpl VALUES ("MT21_39","070_21_39","MAT","21","39","39","Kamhan impamagtagenan matood niran ya maanak daw impamagtimbag niran doro ka gawas na alad na tanem. Kamhan impamagpatay di niran iza. ");
INSERT INTO mmn_vpl VALUES ("MT21_40","070_21_40","MAT","21","40","40","Na, pagdateng na tag-iza ka lopa daw magaono sa koman iza ka mga saop? ");
INSERT INTO mmn_vpl VALUES ("MT21_41","070_21_41","MAT","21","41","41","Minsambag ya mga manalingahay kan Hisos nga patazen siran gazed naiza. Kamhan pasaopan naiza ya tanem ka lain dazaw makahatag kanangiza ka toong kabahinan kada pag-ani. ");
INSERT INTO mmn_vpl VALUES ("MT21_42","070_21_42","MAT","21","42","42","Pagkakamhan indogangan ni Hisos paglaong kaniran nga daw wara pen kamo makabasa ka daan pinasoyat na Diyos nga nagalaong nga ya matimgas nga bato nga inbizaan na mga minhinang ka lagkaw ani ya nahinang nga sinarigan ka pagparig-en ka primirong ogdok na lagkaw. Inhinang iton na Ginoo kamhan madazaw gazed iton pagpakakita nami. ");
INSERT INTO mmn_vpl VALUES ("MT21_43","070_21_43","MAT","21","43","43","Agon pasabten ta kamo nga dini kamazo nga mga Yodayo diri magpadazon ya Diyos ka toong tarabaho. Hinoa karohen naiza ya mga tao nga antoman ka toong mga sogo. ");
INSERT INTO mmn_vpl VALUES ("MT21_44","070_21_44","MAT","21","44","44","Nagalaong pen si Hisos pagpamolinged kaniran nga bisan sin-o ya makadasmag kaiton nga matimgas nga bato mangabari ya toong bekeg. Kamhan bisan sin-o ya madateng naiton nga matimgas nga bato ka pagkaligid magemek gazed ya toong lawas. Kilalhen mazo nga ya dakolang matimgas nga bato nga inbizaan mazo ani hao. ");
INSERT INTO mmn_vpl VALUES ("MT21_45","070_21_45","MAT","21","45","45","Na, pagpakabati ka na mga oloolo na mga pari daw ya mga Parasiyo makasabot dazon siran nga naigo siran ka mga pamolinged ni Hisos. ");
INSERT INTO mmn_vpl VALUES ("MT21_46","070_21_46","MAT","21","46","46","Agon pamagdakpen niran kontana si Hisos piro mahaldek siran ka mga mataed nga tao nga mga mintoo nga si Hisos aniton ya matood nga propita na Diyos. ");
INSERT INTO mmn_vpl VALUES ("MT22_1","070_22_1","MAT","22","1","1","Kamhan indogangan ni Hisos pagpamolinged kaniran nga nagalaong nga ");
INSERT INTO mmn_vpl VALUES ("MT22_2","070_22_2","MAT","22","2","2","ya pagpasakop na Diyos ka mga tao singed iton ka hari nga nagaandam ka pagkombiti ka pagpangasawa na toong maanak nga amaama. ");
INSERT INTO mmn_vpl VALUES ("MT22_3","070_22_3","MAT","22","3","3","Pagkakamhan naiza pagpakaandam ka kombiti impakaro di naiza ya toong mga sogoonon dizan ka mga tao nga toong dinapit dazaw mangaen di naa siran. Ambaza kay minbaribad siran ka inpanaba na sogoonon. ");
INSERT INTO mmn_vpl VALUES ("MT22_4","070_22_4","MAT","22","4","4","Kamhan insogo disab pagpakaro ya mga iba nga sogoonon dazaw long-on niran pag-isab ya mga dinapit nga kamhan di ya paglamisa. In-ihaw di nao ya kanaong mga baka daw ya mga nati nga mahonlas. In-andam di nao ya tanan. Mangarini di naa kamo ka kanaong kombiti. ");
INSERT INTO mmn_vpl VALUES ("MT22_5","070_22_5","MAT","22","5","5","Piro nagapalingeglingeg lamang ya mga dinapit ka impanaba na mga sogoonon. Nagapadazon siran ka kanirang mga hinang. Ya isa minpanaw doro ka toong oma. Ya isa minpasinged ngaro ka toong tarabahoan. ");
INSERT INTO mmn_vpl VALUES ("MT22_6","070_22_6","MAT","22","6","6","Ya mga iba mindakep di hinoa ka mga sogoonon. Kamhan impamagbonalan daw inpamagpatay. ");
INSERT INTO mmn_vpl VALUES ("MT22_7","070_22_7","MAT","22","7","7","Pagpakahagdam ka na hari nazehet gazed iza. Impakaro dazon naiza ya toong mga soldaw dazaw patazen ya mga minpatay ka toong mga sogoonon. Inpanonog disab ya kanirang longsod. ");
INSERT INTO mmn_vpl VALUES ("MT22_8","070_22_8","MAT","22","8","8","Kamhan minlaong ya hari ka toong mga sogoonon nga naandam di nao ya kombiti piro ya daan dinapit nao diri di gazed siran makatilaw ka kanaong in-andam. ");
INSERT INTO mmn_vpl VALUES ("MT22_9","070_22_9","MAT","22","9","9","Agon pangarohen mazo ya mga kadalanan. Bisan sin-o nga makitan mazo dapita mazo siran. ");
INSERT INTO mmn_vpl VALUES ("MT22_10","070_22_10","MAT","22","10","10","Kamhan namanaw ya mga sogoonon ngaro kay dizan ka mga dalan patiponon niran ya bisan sin-o nga tao nga nakitan niran. Bisan maonga ya batasan niran bisan magazon impandapit sirang tanan. Kamhan napono gazed ya lagkaw nga kombitihanan. ");
INSERT INTO mmn_vpl VALUES ("MT22_11","070_22_11","MAT","22","11","11","Minseled ya hari kay anseleng iza ka mga tao nga bag-ong dinapit. Kamhan nakitan naiza ya amaama dizan nga wara baza iza magbado ka para ka mga dinapit ka kombiti. ");
INSERT INTO mmn_vpl VALUES ("MT22_12","070_22_12","MAT","22","12","12","Kamhan impangotana na hari nagalaong nga amigo, daw ono sa ya pagseled mo dini nga wara sa ko magbado ka para ka kombiti? Wara magsambag ya amaama. ");
INSERT INTO mmn_vpl VALUES ("MT22_13","070_22_13","MAT","22","13","13","Kamhan minsogo ya hari ka toong mga sogoonon nga pamegketen mazo ya toong alima daw paa. Kamhan iitsa iza doro ka kadeglemanan bali ka gawas. Doro kaiton magapangageet ya mga tao ka kanirang ngipen ka paghaza. ");
INSERT INTO mmn_vpl VALUES ("MT22_14","070_22_14","MAT","22","14","14","Kamhan minlaong si Hisos kaniran nga ini nga hari singed iza ka Diyos nga mindapit ka mga mataed nga tao piro talagsa ka ya toong impili. Ani ini ya pamolinged ni Hisos kaniran. ");
INSERT INTO mmn_vpl VALUES ("MT22_15","070_22_15","MAT","22","15","15","Pagkakamhan kaiza namanaw dazon ya mga Parasiyo kay namagsabotsabot siran nga magalit-agen kontana si Hisos pagpanaba. ");
INSERT INTO mmn_vpl VALUES ("MT22_16","070_22_16","MAT","22","16","16","Kamhan impakaro niran ya kanirang mga sakop dizan kan Hisos. Iba gihapon ya mga Yodayo nga minsakop di kan Hirodis nga hari. Pagdateng niran nagalaong siran nga Maistro, mahagdam kami nga matadeng ya batasan mo daw matood gihapon ya mga panaba mo. Pagtoldo mo ka sindo na Diyos waray pinalabi mo nga bisan sin-o nga taohana daw bisan ono ya kanirang katenged. ");
INSERT INTO mmn_vpl VALUES ("MT22_17","070_22_17","MAT","22","17","17","Agon long-an mo kami kon ono ya kanmong hena-hena nga daw makalapas kami ka balaed na mga Yodayo kon ambazad kami ka bohis kan Sisar nga hari nga nakadaeg di ka kantang lopa? Daw ambazad kami kon diri? ");
INSERT INTO mmn_vpl VALUES ("MT22_18","070_22_18","MAT","22","18","18","Na, mahagdam dazon si Hisos nga daeten iza kontana. Kamhan minbales iza pagpangotana kaniran nga kay ono sa kamo minporba kamo kanao? Mga bakaken gazed kamo! ");
INSERT INTO mmn_vpl VALUES ("MT22_19","070_22_19","MAT","22","19","19","Pakiten mo hao ka kowarta nga palata nga ibazad mazo ka bohis ni Sisar. Kamhan impakita matood niran si Hisos ka kowarta. ");
INSERT INTO mmn_vpl VALUES ("MT22_20","070_22_20","MAT","22","20","20","Kamhan minlaong si Hisos nga daw kanin-ong bayho dini ka palata? Daw kanin-ong ngaran ya insoyat dini? ");
INSERT INTO mmn_vpl VALUES ("MT22_21","070_22_21","MAT","22","21","21","Minsambag siran nga kan Sisar gazed iton. Minsambag si Hisos nga bayri mazo ya azoon ni Sisar kamazo. Bayri sab mazo ya azoon na Diyos kamazo. ");
INSERT INTO mmn_vpl VALUES ("MT22_22","070_22_22","MAT","22","22","22","Pagpakabati ka niran ka insambag ni Hisos nabereng siran kay diri siran makahimo ka paglalis kan Hisos. Kamhan minpanaw siran dini kanangiza. ");
INSERT INTO mmn_vpl VALUES ("MT22_23","070_22_23","MAT","22","23","23","Pagkakaan kaiza minkarini isab kan Hisos ya mga maistro na mga Yodayo ani ngaran ya Sadosiyo. Ya kanirang toldoan ya mga namola di nga tao diri gazed mabohi pagbalik garing ka lebeng. Na, nangotana siran kan Hisos nga ");
INSERT INTO mmn_vpl VALUES ("MT22_24","070_22_24","MAT","22","24","24","Maistro, ya kanaming karaan nga si Moysis mintogon iza kanami nga kon mapatay ya isang tao nga waray maanak kinahanglan ya lomon na napatay anikay makapangasawa ka toong ipag nga nabalo di dazaw anpanganak. Kamhan mabohi ka ya ngaran na toong magorang nga napatay. Ani ini ya togon ni Moysis kanami. ");
INSERT INTO mmn_vpl VALUES ("MT22_25","070_22_25","MAT","22","25","25","Na, izang mahon-a pen dini kanami may maglomon nga pitong ka amaama. Naminze di ya kamagorangan. Kamhan napatay di iza ka waray maanak. Kamhan ya toong asawa nga nabalo di impangasawa na primirong manghod. ");
INSERT INTO mmn_vpl VALUES ("MT22_26","070_22_26","MAT","22","26","26","Pagkakamhan kaiza napatay kasab ya primirong manghod nga waray maanak. Singed kaiton ya kahimtang na ikadowang manghod keteb ka gipos-an. ");
INSERT INTO mmn_vpl VALUES ("MT22_27","070_22_27","MAT","22","27","27","Pagkahorot niran pagkapatay anipen mapatay ya babazi nga nabalo ka pitong ka maglomon. ");
INSERT INTO mmn_vpl VALUES ("MT22_28","070_22_28","MAT","22","28","28","Na, Maistro, wani ya pangotana nami kanmo kay mintoldo iko nga may tirmino ka pagbohi ka mga tao nga nangapatay. Daw kanin-ong asawa itong babazi kon mabohi pag-isab ya mga namagsonodsonod nga pitong ka maglomon kay iza ya asawa nirang tanan? ");
INSERT INTO mmn_vpl VALUES ("MT22_29","070_22_29","MAT","22","29","29","Minsambag si Hisos nga sazep mazo iton kay wara pen kamo makasabot ka daan pinasoyat na Diyos daw toong gahem. ");
INSERT INTO mmn_vpl VALUES ("MT22_30","070_22_30","MAT","22","30","30","Kay ka pagpangabohi na mga tao kay-an diri di magkaminze ya mga amaama daw ya mga babazi kay nabag-o di ya kanirang mga batasan singed ka batasan na mga sogoonon nga taga langit. ");
INSERT INTO mmn_vpl VALUES ("MT22_31","070_22_31","MAT","22","31","31","Mahimo gazed ya pagpabohi na Diyos ka mga tao garing ka lebeng. Daw wara kamo magbasa kaiza nga inlaong na Diyos kamazo nga nagalaong nga ");
INSERT INTO mmn_vpl VALUES ("MT22_32","070_22_32","MAT","22","32","32","Hao nga Diyos ani ya hawagenen na kamazong mga karaan nga si Abraham daw si Isak daw si Hakob. Ani ini ya impasoyat na Diyos. Kamhan bisan patay di ya mga karaan magahawagen pen niran ya Diyos kay bohi ka siran daked. Kamhan iza ya Diyos na mga bohi nga tao, diri kon Diyos na mga patay. ");
INSERT INTO mmn_vpl VALUES ("MT22_33","070_22_33","MAT","22","33","33","Pagpakabati ka na mga mataed nga tao nangabereng siran ka intoldo ni Hisos. ");
INSERT INTO mmn_vpl VALUES ("MT22_34","070_22_34","MAT","22","34","34","Na, ya mga Parasiyo pagpakabati niran nga wara di ya ikasambag na mga Sadosiyo kan Hisos minkarini disab siran kan Hisos. ");
INSERT INTO mmn_vpl VALUES ("MT22_35","070_22_35","MAT","22","35","35","Kamhan ya isa hanas iza ka mga balaed na Yodayo. Iza ya anpangotana kan Hisos pagporba nagalaong nga ");
INSERT INTO mmn_vpl VALUES ("MT22_36","070_22_36","MAT","22","36","36","Maistro, dizan ka kasogoan na Diyos daw ono ya labaw nga sogo? ");
INSERT INTO mmn_vpl VALUES ("MT22_37","070_22_37","MAT","22","37","37","Minsambag si Hisos nga wani ya labaw nga sogo na Diyos nga kinahanglan nga pagaazaken mazo pagtineed ya Ginoo nga kamazong Diyos. Kamhan isahen mazo ya kamazong hena-hena ka pagtaremdem kanangiza. ");
INSERT INTO mmn_vpl VALUES ("MT22_38","070_22_38","MAT","22","38","38","Ani ini ya labaw nga sogo. ");
INSERT INTO mmn_vpl VALUES ("MT22_39","070_22_39","MAT","22","39","39","Mag-anika ya ikadowang sogo nga kinahanglan mag-azak kamo ka kamazong mga iba singed ka pag-azak mazo ka kamazong kaogaringen. ");
INSERT INTO mmn_vpl VALUES ("MT22_40","070_22_40","MAT","22","40","40","Kamhan iton nga dowang ka sogo ani ya singed ka toboan na bisan ono ya daan balaed na Diyos daw bisan ono ya sinoyat na mga karaang propita. Ani ini ya sambag ni Hisos mga ka Parasiyo. ");
INSERT INTO mmn_vpl VALUES ("MT22_41","070_22_41","MAT","22","41","41","Na, ka nagatipon pen ya mga Parasiyo nangotana si Hisos kaniran nga ");
INSERT INTO mmn_vpl VALUES ("MT22_42","070_22_42","MAT","22","42","42","daw ono ya kamazong hena-hena mahitenged kan Kristo nga hari nga pinili na Diyos? Daw kanin-ong kaliwat iza? Minsambag siran nga kaliwat iza na kanaming karaan nga si Dabid. ");
INSERT INTO mmn_vpl VALUES ("MT22_43","070_22_43","MAT","22","43","43","Kamhan minlaong si Hisos kaniran nga agon kay ono sa nga minngaran sa si Dabid kan Kristo nga toong Ginoo pagtandeg na Ispirito na Diyos ka toong hinawa? Kay minlaong iza nga ");
INSERT INTO mmn_vpl VALUES ("MT22_44","070_22_44","MAT","22","44","44","ya Diyos ani ya minpanaba ka kanaong Ginoo nga lomo-to ko naa dini ka kanaong too hangtod ka pagpakadaeg nao ka kanmong mga kaaway. Ani ini ya daan mga panaba ni Dabid mahitenged kan Kristo nga hari nga pinili na Diyos. ");
INSERT INTO mmn_vpl VALUES ("MT22_45","070_22_45","MAT","22","45","45","Kamhan kon minngaran si Dabid kan Kristo nga toong Ginoo daw ono say toong pagkakaliwat ka lamang ni Dabid? ");
INSERT INTO mmn_vpl VALUES ("MT22_46","070_22_46","MAT","22","46","46","Pagkakamhan ni Hisos pagpanaba waray isa nga makasambag. Sokad kaiton wara di siran makasigi pagbalik pagpangotana kan Hisos. ");
INSERT INTO mmn_vpl VALUES ("MT23_1","070_23_1","MAT","23","1","1","Pagkakamhan kaiza minlaong si Hisos ka mga mataed nga tao daw ya toong mga sinarigan nga nagalaong nga ");
INSERT INTO mmn_vpl VALUES ("MT23_2","070_23_2","MAT","23","2","2","ya mga maistro ka tinoohan na mga Yodayo daw ya mga Parasiyo may katenged niran ka paghilwas ka mga balaed ni Moysis. ");
INSERT INTO mmn_vpl VALUES ("MT23_3","070_23_3","MAT","23","3","3","Agon bisan ono ya isogo niran kamazo tomanen mazo piro diri mazo paghaodon ya kanirang batasan kay ya inwali niran kamazo wara siran magtoman. ");
INSERT INTO mmn_vpl VALUES ("MT23_4","070_23_4","MAT","23","4","4","Impalisdan niran ya mga tao ka sogo nga mabeg-at piro impalabzan lamang niran iton nga mga sogo. ");
INSERT INTO mmn_vpl VALUES ("MT23_5","070_23_5","MAT","23","5","5","Hinangen niran ya tanan mga magazon dazaw anpagarbo siran dizan ka mga tao. Dizan ka alimpatakan niran daw ya bekten impamegketen niran ya len-anan ka sinoyatan ka mga daan balaed ni Moysis dazaw tahodon siran na mga tao. Inlakbangan isab niran ya borda dizan ka sidsid na bado niran dazaw ankilala ya mga tao kaniran. ");
INSERT INTO mmn_vpl VALUES ("MT23_6","070_23_6","MAT","23","6","6","Kada pagpista daw kada pagsingba naazak siran kon palo-toon siran ka magazong dapit. ");
INSERT INTO mmn_vpl VALUES ("MT23_7","070_23_7","MAT","23","7","7","Pag-azi sab niran dizan ka mirkado naazak gazed siran nga madazaw ya pag-abiabi na mga tao kaniran. Ansaza siran isab ka pagngaran na mga tao kaniran ka maistro nga labaw. ");
INSERT INTO mmn_vpl VALUES ("MT23_8","070_23_8","MAT","23","8","8","Piro kamo nga kanaong mga sinarigan, diri kamo magsaza nga ngaranan kamo ka maistro nga labaw kay isa ka gazed ya kamazong maistro nga labaw. Kamhan dini kanao singed ka mga maglomon ka gazed kamong tanan. ");
INSERT INTO mmn_vpl VALUES ("MT23_9","070_23_9","MAT","23","9","9","Agon bisan sin-o ya antoldo kamazo ka sindo mahitenged ka Diyos diri kamo magtahod kanangiza singed ka pagtahod mazo ka Diyos. Kay ya Diyos nga nagahela daked ka langit iza gazed ya kamazong Ama nga tahodanan nga labaw gazed. ");
INSERT INTO mmn_vpl VALUES ("MT23_10","070_23_10","MAT","23","10","10","Diri kamo magsaza nga ngaranan kamo ka oloolo kay isa ka lamang ya oloolo mazo nga ani si Kristo. ");
INSERT INTO mmn_vpl VALUES ("MT23_11","070_23_11","MAT","23","11","11","Dizan kamazo ya labaw nga tao ani ya ampangalagad kamazo. ");
INSERT INTO mmn_vpl VALUES ("MT23_12","070_23_12","MAT","23","12","12","Bisan sin-o ya ampalabaw ka toong kaogaringen dizan ka mga iba ipaebes gazed iza na Diyos. Bisan sin-o ya ampaebes ka toong kaogaringen dizan ka mga iba ipalabaw iza na Diyos. ");
INSERT INTO mmn_vpl VALUES ("MT23_13","070_23_13","MAT","23","13","13","Kamo nga mga maistro ka mga Yodayo daw ya mga Parasiyo, magalised gazed kamo kay-an kay mga bakaken kamo kay imbalabagan gazed mazo ya mga tao kay dazaw diri siran antoo kanao. Diri kamo ansogot kanao kamhan diri togoton siran ka pagtoo. ");
INSERT INTO mmn_vpl VALUES ("MT23_14","070_23_14","MAT","23","14","14","Kamo nga mga maistro daw ya mga Parasiyo, magalised kamo kay-an kay mga bakaken kamo kay magapanlimbong kamo ka mga balo nga babazi dazaw makaangken kamo ka kanirang mga irinsiya. Kamhan magapaataasen sab mazo ya kamazong pagpangamozo ka Diyos dazaw komoton mazo ya kamazong mga sala. Agon pahamtangan kamo na Diyos ka silot pagdakola ka silot naiza ka iba nga mga tao nga makasala. ");
INSERT INTO mmn_vpl VALUES ("MT23_15","070_23_15","MAT","23","15","15","Kamo nga mga maistro daw ya mga Parasiyo, magalised kamo kay-an kay mga bakaken gazed kamo. Kamhan aro ya kamazong pagsakay dizan ka dagat daw ya kamazong pagbagtas dizan ka lopa dazaw ankawa kamo ka bisan isa kang bolos nga sakop. Pagpasakop mazo ka tao indap-an iza ka kamazong batasan nga nadobli gazed ya kaonga na kamazong batasan. Agon ya silot nga ipahamtang na Diyos kanangiza labaw iton ka silot naiza kamazo. ");
INSERT INTO mmn_vpl VALUES ("MT23_16","070_23_16","MAT","23","16","16","Nagalaong pen si Hisos kaniran nga nagalised kamo kay-an kay pagtoldo mazo ka mga tao singed ka nabota gazed kamo. Nasazep kamo ka pagtoldo nagalaong nga kon anpaninhaga ya tao ka dakolang lagkaw nga pangamozoanan ka Diyos diri di kinahanglan nga tomanen pen naiza ya toong saad. Piro kon ampaninhaga iza ka bolawan dalem ka dakolang lagkaw na Diyos kinahanglan gazed tomanen naiza ya toong saad. ");
INSERT INTO mmn_vpl VALUES ("MT23_17","070_23_17","MAT","23","17","17","Mga nabota kamo daw talatalahen! Kay ya mga bolawan diri kon mahal iton ka pagkamahal na dakolang lagkaw nga pangamozoanan ka Diyos. ");
INSERT INTO mmn_vpl VALUES ("MT23_18","070_23_18","MAT","23","18","18","Nasazep isab kamo ka pagtoldo nagalaong nga kon ampaninhaga ya tao ka haladanan diri di kinahanglan nga tomanen pen naiza ya toong saad. Piro kon ampaninhaga iza ka halad dizan ka haladanan kinahanglan tomanen naiza ya toong saad. ");
INSERT INTO mmn_vpl VALUES ("MT23_19","070_23_19","MAT","23","19","19","Nangabota di kamo daan! Kay ya halad diri kon mahal iton ka pagkamahal na haladanan. ");
INSERT INTO mmn_vpl VALUES ("MT23_20","070_23_20","MAT","23","20","20","Agon kon ampaninhaga ya tao ka haladanan malakip isab ya tanan mga halad dizan ka haladanan. ");
INSERT INTO mmn_vpl VALUES ("MT23_21","070_23_21","MAT","23","21","21","Kon ampaninhaga isab ya tao ka dakolang lagkaw na Diyos malakip isab ya Diyos nga nagahela dizan kaiton nga lagkaw. ");
INSERT INTO mmn_vpl VALUES ("MT23_22","070_23_22","MAT","23","22","22","Kon ampaninhaga ya tao ka langit malakip isab ya lo-toanan na Diyos ka paghari daw iza nga nagalo-to dizan. ");
INSERT INTO mmn_vpl VALUES ("MT23_23","070_23_23","MAT","23","23","23","Kamo nga mga maistro ka mga Yodayo daw ya mga Parasiyo, magalised gazed kamo kay-an kay diri kon matood ya pagkaazak mazo ka Diyos. Kay bisan nagahatag kamo ka Diyos ka ikanapolo nga ka bahin na bisan ya mga klasi na zaman wara kamo magtoman ka mga labaw nga sogo na Diyos nga nagalaong nga tadengen mazo ya pagdomara mazo ka mga isa daw isa. Magkinaloy-anay disab kamo kaniran. Magtoo isab kamo ka Diyos. Kinahanglan tomanen isab mazo ini singed ka paghatag mazo ka mga ikanapolo nga bahin dizan ka Diyos. ");
INSERT INTO mmn_vpl VALUES ("MT23_24","070_23_24","MAT","23","24","24","Pagtoldo mazo ka mga tao singed ka nabota gazed kamo kay nawied kamo paghinang ka mga geramay nga sala piro ya mga dakola nga sala waray kawied mazo. ");
INSERT INTO mmn_vpl VALUES ("MT23_25","070_23_25","MAT","23","25","25","Kamo nga mga maistro ka mga Yodayo daw ya mga Parasiyo, magalised kamo kay-an kay mga bakaken gazed kamo kay inhogasan gazed mazo ya gawas na kamazong mga baso daw palato. Piro ya seled napono gazed ka mga maripa kay naanad kamo paglimbong ka mga tao dazaw makakowarta. ");
INSERT INTO mmn_vpl VALUES ("MT23_26","070_23_26","MAT","23","26","26","Kamo nga mga Parasiyo nga nabota, kinahanglan hingloan mazo ya seled na baso daw palato paghon-a. Anipen sab kon mahinglo ya gawas naiton. ");
INSERT INTO mmn_vpl VALUES ("MT23_27","070_23_27","MAT","23","27","27","Kamo nga mga maistro daw ya mga Parasiyo, magalised gazed kamo kay-an kay mga bakaken gazed kamo kay minpasingedsinged kamo ka mga pantiyon nga inpintalan ka mapoti. Dizan ka gawas madazaw selengan piro dalem ka seled polos bekeg na mga namola nga tao nga nadonot di daw mabaho di. ");
INSERT INTO mmn_vpl VALUES ("MT23_28","070_23_28","MAT","23","28","28","Singed kamo kaiton kay pagseleng na mga tao ka kamazong batasan singed ka matadeng kamo ambaza kay ya mga paghena-hena mazo polos mga limbong. Naanad sab kamo paglapas ka mga balaed na Diyos. ");
INSERT INTO mmn_vpl VALUES ("MT23_29","070_23_29","MAT","23","29","29","Kamo nga mga maistro daw ya mga Parasiyo, magalised gazed kamo kay-an kay mga bakaken kamo kay minhinang kamo ka mga madazaw nga pantiyon para ka mga inpatay nga karaang propita na Diyos. Inpaartihan disab mazo ya mga pantiyon na mga karaang tao nga matadeng ");
INSERT INTO mmn_vpl VALUES ("MT23_30","070_23_30","MAT","23","30","30","nga inpatay na kamazong kaapoan. Bisan minlaong kamo nga kon bohi ka kamo kaiza nga aldaw wara kamo magpamatay kaniran, ");
INSERT INTO mmn_vpl VALUES ("MT23_31","070_23_31","MAT","23","31","31","kamo gazed ya mga kaliwatan na mga minpamatay. Singed kamo kaniran ");
INSERT INTO mmn_vpl VALUES ("MT23_32","070_23_32","MAT","23","32","32","agon magtiwas naa kamo ka hinang nga insogod na kamazong kaapoan. ");
INSERT INTO mmn_vpl VALUES ("MT23_33","070_23_33","MAT","23","33","33","Nagabatasan kamo singed ka mga halas nga polos maonga ya batasan agon diri gazed kamo makalayas ka pagsilot na Diyos kamazo doro ka impirno. ");
INSERT INTO mmn_vpl VALUES ("MT23_34","070_23_34","MAT","23","34","34","Agon pakarinihen nao kamazo ya mga propita na Diyos daw ya mga tao nga dakola ya kanirang kahagdamanan mahitenged ka Diyos daw ya mga maistro nga mahagdam pagsindo mahitenged kanao. Kamhan pamagpatazen pen mazo ya mga pirang ka tao kaniran. Ipanlansang sab mazo ka kros ya iba. Dalem ka kamazong singbahan pamagbonalen sab mazo ya mga iba. Kamhan dizan ka bisan hain ya kanirang dalaganan lopogon sab mazo siran. Ani ini ya batasan mazo kay-an ka pagdateng niran kamazo. ");
INSERT INTO mmn_vpl VALUES ("MT23_35","070_23_35","MAT","23","35","35","Agon madateng kamo ka silot para ka pagpatay ka tanan mga karaan nga matadeng sokad ka pagpatay kan Abil nga waray sala hangtod ka pagpatay kan Zakariyas nga maanak ni Barakiyas nga inpatay mazo dizan ka tenga-tenga na haladanan daw ya dakolang lagkaw na Diyos. ");
INSERT INTO mmn_vpl VALUES ("MT23_36","070_23_36","MAT","23","36","36","Timan-an mazo gazed ini nga madateng gazed kamo ka silot kay ani ini ya kamazong hinang. ");
INSERT INTO mmn_vpl VALUES ("MT23_37","070_23_37","MAT","23","37","37","Pagkakamhan ni Hisos pagbaheg kaniran minlaong iza nga kamo nga mga taga Hirosalem, nagalised di gazed ya kanaong hena-hena kay inpatay mazo ya mga karaang propita na Diyos daw impamook ya mga sogoonon nga impakarini na Diyos kamazo. Kapira hao an-aligara kamazo kontana singed ka manggianak nga nagatipon ka toong mga pise dalem ka toong ampak piro diri kamo ansogot. ");
INSERT INTO mmn_vpl VALUES ("MT23_38","070_23_38","MAT","23","38","38","Sabten mazo ini nga pamanawan gazed na mga tao dini ka hel-anan mazo. Bizaan disab ta kamo. ");
INSERT INTO mmn_vpl VALUES ("MT23_39","070_23_39","MAT","23","39","39","Sokad koman diri kamo makakita kanao pag-isab hangtod ka pagbalik nao. Kamhan ansaza kamo kanao magalaong nga sazaen ta iza nga impakarini na Diyos dini kanami. Ani ini ya pagpanan-og ni Hisos kaniran. ");
INSERT INTO mmn_vpl VALUES ("MT24_1","070_24_1","MAT","24","1","1","Minlogwa si Hisos ka dakolang lagkaw nga pangamozoanan ka Diyos. Pagpanaw naiza dizan minkarini kanangiza ya toong mga sinarigan kay paselengen niran si Hisos ka kalagkawenan nga natipon paghinang ka dakolang lagkaw na Diyos. ");
INSERT INTO mmn_vpl VALUES ("MT24_2","070_24_2","MAT","24","2","2","Minsambag si Hisos nga paka selengi gazed mazo itong mga lagkaw. Timan-an mazo gazed ini nga mageba gazed iton kaan. Basta ya mga bato nga insompazan podo mabogto pagpangadeeg. ");
INSERT INTO mmn_vpl VALUES ("MT24_3","070_24_3","MAT","24","3","3","Na, ka nagalo-to si Hisos dizan ka bobong nga Olibo minkadizan ya toong mga sinarigan nga waray lain tao iba kanangiza. Kamhan nangotana siran nga panan-ogan mo kami kon kon-o kon mageba iton nga mga lagkaw. Daw ono ya timaan ka pagbalik mo ngarini daw ya kataposan nga panahon dini ka kalibotan? ");
INSERT INTO mmn_vpl VALUES ("MT24_4","070_24_4","MAT","24","4","4","Kamhan minsogod si Hisos pagsindo kaniran nga maghamarag kamo kay basi magalimbongan kamo na mga tao. ");
INSERT INTO mmn_vpl VALUES ("MT24_5","070_24_5","MAT","24","5","5","Kay mataed ya mga andateng nga ampasingedsinged siran kanao magaangken nga si Kristo hao nga pinili na Diyos ka paghari ka mga tao. Kamhan malimbongan ya mga mataed nga tao. ");
INSERT INTO mmn_vpl VALUES ("MT24_6","070_24_6","MAT","24","6","6","Diri sab kamo magkahaldek kon makabati kamo nga may gobot na gira nga arani di koni kamazo, may gira disab koni doro ka aro. Matoman matood iton piro diri pen kon ani ya kataposan nga panahon dini ka kalibotan. ");
INSERT INTO mmn_vpl VALUES ("MT24_7","070_24_7","MAT","24","7","7","Kay ka wara pen matapos ya kalibotan ampakig-away ya isang longsod ka laing longsod. Ampakig-away isab ya isang hari ka laing hari. Madateng ya mga nagakalainlain dapit ka pihit. Mataed isab ya mga linog. ");
INSERT INTO mmn_vpl VALUES ("MT24_8","070_24_8","MAT","24","8","8","Iton nga tanan ani ya sinogdan ka lamang na mga kalised dini ka kalibotan. ");
INSERT INTO mmn_vpl VALUES ("MT24_9","070_24_9","MAT","24","9","9","Kamhan magapandadhan kamo dizan ka mga madaegdaegen kamazo. Kamhan patazen kamo. Magakontarahan kamo na tanan mga tao kay hao ya insakopan mazo. ");
INSERT INTO mmn_vpl VALUES ("MT24_10","070_24_10","MAT","24","10","10","Kamhan mataed ya ampamiza ka kanirang pagtoo kanao. Mamag-inedlaway siran daw mamagdinemetay. ");
INSERT INTO mmn_vpl VALUES ("MT24_11","070_24_11","MAT","24","11","11","Andateng pen ya mga mataed nga tao nga nagapasingedsinged ka mga propita na Diyos. Kamhan malimbongan gazed ya mga mataed nga tao. ");
INSERT INTO mmn_vpl VALUES ("MT24_12","070_24_12","MAT","24","12","12","Kamhan garing ka pag-oswag na maongang batasan dini ka kalibotan diri magkinaloy-anay ya isa daw isa. ");
INSERT INTO mmn_vpl VALUES ("MT24_13","070_24_13","MAT","24","13","13","Na, bisan sin-o ya antoo pen kanao keteb ka pagkatapos naiton nga mga kalised mahatagan iza ka bag-ong kinabohi nga diri mawara. ");
INSERT INTO mmn_vpl VALUES ("MT24_14","070_24_14","MAT","24","14","14","Ya sindo mahitenged ka pagpasakop na Diyos ka mga tao iwali pen iton doro ka tibolos kalibotan dazaw mahagdam ya tanan mga tao. Anipen matapos ya kalibotan. ");
INSERT INTO mmn_vpl VALUES ("MT24_15","070_24_15","MAT","24","15","16","Kawandini pen may inlaong ni Danyil nga karaang propita na Diyos. Kamhan minpanan-og iza daan mahitenged ka isang tao nga masarang kaonga nga makadaet ka mga tao. Na, sabten mazo ya inlaong ni Danyil. Kay minlaong iza nga pagpakakita mazo nga mintindeg di iton nga tao dalem ka dakolang lagkaw nga pangamozoanan ka Diyos, kamo nga mga taga Yoda mandalagan gazed kamo ngaro ka bobong. ");
INSERT INTO mmn_vpl VALUES ("MT24_17","070_24_17","MAT","24","17","17","Bisan magahayahay kamo dizan ka pawa, dalagan gazed kamo kay waray logar mazo ka pagpanhipid ka kamazong mga betang. ");
INSERT INTO mmn_vpl VALUES ("MT24_18","070_24_18","MAT","24","18","18","Bisan magatarabaho kamo daked ka kamazong oma dalagan gazed kamo kay waray logar mazo ka pagkawa ka kamazong bado dizan ka lagkaw. ");
INSERT INTO mmn_vpl VALUES ("MT24_19","070_24_19","MAT","24","19","19","Kalooy adaw na mga kabdes daw ya mga may pinasoso kay magalised siran ka pagdalagan. ");
INSERT INTO mmn_vpl VALUES ("MT24_20","070_24_20","MAT","24","20","20","Maghangzo kamo ka Diyos nga kontana diri kon panahon nga tig-oran kon aldaw nga tigpahimlay ya pagdalagan mazo. ");
INSERT INTO mmn_vpl VALUES ("MT24_21","070_24_21","MAT","24","21","21","Kay ya kasamok naiton nga panahona masara iton ka bisan ono ya kasamok sokad kawandini pen ka sinogdan pen na kalibotan hangtod koman daw kawanihen ka. ");
INSERT INTO mmn_vpl VALUES ("MT24_22","070_24_22","MAT","24","22","22","Kamhan kon diri padalien na Diyos iton nga mga aldaw wara gazed ya tao nga mabohi. Piro magakalooy ya Diyos ka toong mga pinili agon ampadali iza kaiton nga panahona kay-an. ");
INSERT INTO mmn_vpl VALUES ("MT24_23","070_24_23","MAT","24","23","23","Kay-an kaiton nga panahona kon may anlaong kamazo nga paka selengi, mindateng di si Kristo nga hari nga pinili na Diyos, diri kamo magtoo. Kon may anlaong sab kamazo nga paka selengi, waton di iza ngarini, diri kamo magtoo. ");
INSERT INTO mmn_vpl VALUES ("MT24_24","070_24_24","MAT","24","24","24","Kay andateng pen kamazo ya mga ampasingedsinged kan Kristo daw ya magapatihinang ka mga propita na Diyos. Anhinang sab siran ka mga kaberenganan kay kon mahimo malimbongan ya mga tao nga pinili na Diyos. ");
INSERT INTO mmn_vpl VALUES ("MT24_25","070_24_25","MAT","24","25","25","Maghamarag gazed kamo kay inpakahagdam di nao kamo daan. ");
INSERT INTO mmn_vpl VALUES ("MT24_26","070_24_26","MAT","24","26","26","Agon kon may anlaong kamazo nga waro di si Kristo ka kamingawan, abay gazed kamo pagkaro. Kon may anlaong kamazo nga nagatago si Kristo dalem kaiton nga lagkaw, abay gazed kamo pagtoo kaiton. ");
INSERT INTO mmn_vpl VALUES ("MT24_27","070_24_27","MAT","24","27","27","Kay ya pagdateng nao kay-an singed iton ka kilat nga magalapowasan dazon ya kalangitan garing ka sebazan ngaro ka salpan. ");
INSERT INTO mmn_vpl VALUES ("MT24_28","070_24_28","MAT","24","28","28","Kamhan bisan sin-o ya maongang batasan nga tao silotan gazed iza. Singed iton ka pamolinged nga bisan hain ya lawas nga patay magatiponon na mga agila ka pagtoktok ka mga onod. ");
INSERT INTO mmn_vpl VALUES ("MT24_29","070_24_29","MAT","24","29","29","Na, pagkatiwas na mga masiet nga kalised andeglem ya sega, anlipsilipsi ya bolan, mangaholog sab ya mga bitoon garing daked ka langit. Magakaonga gazed ya kalangitan kay ipahezenghezeng na Diyos. ");
INSERT INTO mmn_vpl VALUES ("MT24_30","070_24_30","MAT","24","30","30","Anipen makita ya timaan daked ka langit para ka pagdateng nao nga si Kristo. Kamhan anhaza ya tibe nga mga tao pagkita niran kanao iba ya mga gabon. Pagkarimbaba nao labaw gazed hao ka gahem daw madazaw gazed selengan. ");
INSERT INTO mmn_vpl VALUES ("MT24_31","070_24_31","MAT","24","31","31","Kamhan antanog ya tamboli daw sogoon nao ya kanaong mga sinogo nga taga langit dazaw patiponon niran ya tibe nga tao nga impili nao daan. Garing siran ka mga dapit doro ka sebazan daw doro ka salpan daw timogan daw kanawazan daw bisan hain dini ka kalibotan. ");
INSERT INTO mmn_vpl VALUES ("MT24_32","070_24_32","MAT","24","32","32","Na, paniidan mazo ya batasan na igira nga tanem. Kon namag-o ya toong dahon mahagdam di kamo nga ampanhoraw kaan. ");
INSERT INTO mmn_vpl VALUES ("MT24_33","070_24_33","MAT","24","33","33","Singed iton ka inlaong nao kamazo koman. Pagpakakita mazo kaiza nga mga inlaong nao kamazo mahagdam kamo nga arani gazed ya tirmino nao ka pagbalik ka kalibotan. ");
INSERT INTO mmn_vpl VALUES ("MT24_34","070_24_34","MAT","24","34","34","Matood nga ka wara pen mapatay ya kamazong kaliwatan matoman ya impanan-og o kamazo. ");
INSERT INTO mmn_vpl VALUES ("MT24_35","070_24_35","MAT","24","35","35","Mangawara ya kalangitan daw ya kalibotan piro ya kanaong mga panaba diri gazed mawara. ");
INSERT INTO mmn_vpl VALUES ("MT24_36","070_24_36","MAT","24","36","36","Na, waray mahagdam kon kon-o hao ambalik ka kalibotan. Bisan ya mga sogoonon nga taga langit, bisan kon hao, wara kami mahagdam kay ya kanaong Ama nga Diyos iza kay mahagdam. ");
INSERT INTO mmn_vpl VALUES ("MT24_37","070_24_37","MAT","24","37","37","Na, ya batasan na mga tao kay-an ka pagbalik nao ngarini daw ya batasan na mga karaang tao ka bohi pen si Niwi mag-anika siran. ");
INSERT INTO mmn_vpl VALUES ("MT24_38","070_24_38","MAT","24","38","38","Kay kawandini pen ka wara pen dateng ya lenep nagapadazon ya mga tao pagpangaen daw pagpanginem daw pagpanminze keteb ka aldawa nga minseled sing Niwi ka arka. ");
INSERT INTO mmn_vpl VALUES ("MT24_39","070_24_39","MAT","24","39","39","Kamhan ya mga tao diri antoo nga madateng siran ka lenep kaan piro pagdateng matood na lenep natibe siran pagpatay. Ani isab ya kahimtang na mga tao kay-an ka pagbalik nao dimbaba ka kalibotan. ");
INSERT INTO mmn_vpl VALUES ("MT24_40","070_24_40","MAT","24","40","40","Kay kay-an ka pagdateng naiton nga aldawa magatarabaho ya dowang ka tao doro ka oma. Kamhan ibahen nao ya isa piro ya isa ibilin. ");
INSERT INTO mmn_vpl VALUES ("MT24_41","070_24_41","MAT","24","41","41","Magagaling sab ya dowang ka babazi ka mais. Kamhan ibahen nao ya isa piro ya isa ibilin. ");
INSERT INTO mmn_vpl VALUES ("MT24_42","070_24_42","MAT","24","42","42","Agon maghamarag gazed kamo kay wara kamo mahagdam kon ono aldawa ya pagbalik nao nga kamazong Ginoo. ");
INSERT INTO mmn_vpl VALUES ("MT24_43","070_24_43","MAT","24","43","43","Sabten mazo ini nga kon mahagdam daan ya tag-iza ka lagkaw nga paniken di iza na tolisan, diri gazed iza an-endang pagbantay kay diri itogot ya kawatan ka pagpanik. ");
INSERT INTO mmn_vpl VALUES ("MT24_44","070_24_44","MAT","24","44","44","Agon mag-andam isab kamo daan kay andateng gazed hao kay-an ka oras nga wara kamo mahagdam. ");
INSERT INTO mmn_vpl VALUES ("MT24_45","070_24_45","MAT","24","45","45","Wani ya pamolinged mahitenged ka pagbalik nao ngarini nga may isang sogoonon nga masarigan nga pinili na toong amo ka pagdomara ka mga iba nga sogoonon daw tagan sab siran ka makaen ka hostong orasa. Kamhan in-andam naiza daan ka pagdateng na toong amo. ");
INSERT INTO mmn_vpl VALUES ("MT24_46","070_24_46","MAT","24","46","46","Kon antoman ya sinarigan ka mga sogo na toong amo dakola ya toong kasaza pagdateng na amo. ");
INSERT INTO mmn_vpl VALUES ("MT24_47","070_24_47","MAT","24","47","47","Kamhan insarigan iza na amo ka toong tanan mga betang. ");
INSERT INTO mmn_vpl VALUES ("MT24_48","070_24_48","MAT","24","48","48","Piro kon maonga ya hena-hena na sinarigan silaong naiza nga madogay pen ya pag-oli na kanaong amo. ");
INSERT INTO mmn_vpl VALUES ("MT24_49","070_24_49","MAT","24","49","49","Kamhan minsogod iza pagpanbonal ka toong iba nga sogoonon. Minkaen sab iza daw min-inem iba ka mga palahebeg. ");
INSERT INTO mmn_vpl VALUES ("MT24_50","070_24_50","MAT","24","50","50","Lomaza iza ominem daw komaen mindateng di ya toong amo ka waray tirmino nga aldaw. ");
INSERT INTO mmn_vpl VALUES ("MT24_51","070_24_51","MAT","24","51","51","Kamhan insilotan gazed ya sogoonon na amo. Ipalakip gihapon iza dizan ka mga bakaken. Kamhan doro ka impirno magapangageet iza ka toong ngipen ka paghaza. ");
INSERT INTO mmn_vpl VALUES ("MT25_1","070_25_1","MAT","25","1","1","Kamhan indogangan ni Kristo pagsindo kaniran nagalaong nga ya pagbalik nao ngarini ka kalibotan dazaw anhari hao ka mga tao singed iton ka pagsogat na mga daraga ka banahen ngaro ka pagkombiti. Napolo siran nga ka daraga daw nagadara siran ka tagsatagsa nga lamparahan. ");
INSERT INTO mmn_vpl VALUES ("MT25_2","070_25_2","MAT","25","2","4","Na, ya mga lima nga daraga boangboangen siran kay waray andam niran ka gas. Piro ya mga lima nga beetan nakaandam daan siran ka gas daw nagadara sab siran ka kanirang mga lamparahan. ");
INSERT INTO mmn_vpl VALUES ("MT25_5","070_25_5","MAT","25","5","5","Kamhan naaban pen iton banahen doro agon nakatorog ya mga daraga ka pagtagad. ");
INSERT INTO mmn_vpl VALUES ("MT25_6","070_25_6","MAT","25","6","6","Pagkatenga ka kaiza na kahabzen may minhawag nga pangimata di kamo diton kay mindateng di doro ya banahen! Dali kamo, magsogat kamo kanangiza! ");
INSERT INTO mmn_vpl VALUES ("MT25_7","070_25_7","MAT","25","7","7","Nangimata dazon ya mga daraga. Inseg-an sab dazon ya kanirang mga lamparahan. ");
INSERT INTO mmn_vpl VALUES ("MT25_8","070_25_8","MAT","25","8","8","Kamhan ya mga boangboangen nangazo pen ka gas dizan ka mga beetan nagalaong nga tagan mazo kami ka gas kay hapit di mangapareng ya kanaming mga segà. ");
INSERT INTO mmn_vpl VALUES ("MT25_9","070_25_9","MAT","25","9","9","Minsambag ya mga beetan nga ya in-andam nami diri maigo kantang tibe. Komaro kamo hinoa ka tindahan. Pomalit kamo ka gas doro. ");
INSERT INTO mmn_vpl VALUES ("MT25_10","070_25_10","MAT","25","10","10","Ka doro pen siran ka tindahan mindateng di doro ka lagkaw ya banahen. Kamhan minpaseled iza ka kombitihanan ka mga daraga nga nakaandam daan ka toong pagdateng. Kamhan insirahan ya pirtahan. ");
INSERT INTO mmn_vpl VALUES ("MT25_11","070_25_11","MAT","25","11","11","Lomaza kaiza mindateng di ya mga daraga garing ka tindahan. Minhawag siran nga Nong, Nong, paselden mo kami. ");
INSERT INTO mmn_vpl VALUES ("MT25_12","070_25_12","MAT","25","12","12","Minsambag iza nga wara hao makakilala kamazo kon sin-o sa kamo iton. Na, ani ini ya pamolinged mahitenged ka pagbalik nao ngarini. ");
INSERT INTO mmn_vpl VALUES ("MT25_13","070_25_13","MAT","25","13","13","Agon mag-andam kamo daan kay wara gazed kamo mahagdam daw ono aldawa bisan ono orasa ya kanaong pagbalik ngarimbaba ka kalibotan. ");
INSERT INTO mmn_vpl VALUES ("MT25_14","070_25_14","MAT","25","14","14","Kay kay-an ka pagbalik nao ngarini ka paghari ka mga tao singed hao ka amo nga minpanaw doro ka aro. Ka wara pen iza magpanaw impanipon naiza ya toong mga sogoonon dazaw isarig kaniran ya toong kowarta dazaw dogangan niran iton. ");
INSERT INTO mmn_vpl VALUES ("MT25_15","070_25_15","MAT","25","15","15","Ya isang sogoonon insarigan iza ka limang ka libo nga ka pisos. Ya ikadowang sogoonon insarigan iza ka dowang ka libo nga ka pisos. Ya ikatlong sogoonon insarigan iza ka isang ka libo nga ka pisos. Ani ini ya pagbahinbahin na amo kaniran kay anaden siran ka paggamit ka kowarta dazaw madogangan iton. Kamhan minpanaw ya amo doro ka aro. ");
INSERT INTO mmn_vpl VALUES ("MT25_16","070_25_16","MAT","25","16","16","Kamhan ya sogoonon nga insarigan ka limang ka libo nga pisos ingamit naiza iton ka pagginansiya ka limang ka libo nga ka pisos. ");
INSERT INTO mmn_vpl VALUES ("MT25_17","070_25_17","MAT","25","17","17","Ya sogoonon nga insarigan ka dowang ka libo nga ka pisos ingamit isab naiza iton ka pagginansiya ka dowang ka libo nga ka pisos. ");
INSERT INTO mmn_vpl VALUES ("MT25_18","070_25_18","MAT","25","18","18","Piro ya ikatlong sogoonon nga insarigan ka isang ka libo nga ka pisos minkabot iza ka lopa kay ilebeng ya kowarta na toong amo. ");
INSERT INTO mmn_vpl VALUES ("MT25_19","070_25_19","MAT","25","19","19","Pagkadogay kaiza minbalik ya amo dizan kaniran kay ansosi kon masarigan siran ka tarabaho kon diri. ");
INSERT INTO mmn_vpl VALUES ("MT25_20","070_25_20","MAT","25","20","20","Ya isang sogoonon nga insarigan ka limang ka libo nga ka pisos min-atobang iza ka toong amo daw indara ya anak nga limang ka libo. Kamhan minlaong iza nga Sinyor, insarigan mo hao ka limang ka libo. Kamhan wani pen sab ya anak na limang ka libo. ");
INSERT INTO mmn_vpl VALUES ("MT25_21","070_25_21","MAT","25","21","21","Minsambag ya toong amo nga madazaw iko. Masarigan iko ka geramay nga kowarta agon isarig pen nao kanmo ya dakola. Magseled ko ka kanaong hel-anan kay panaranginan ta ko ka mga magazon. ");
INSERT INTO mmn_vpl VALUES ("MT25_22","070_25_22","MAT","25","22","22","Kamhan ya ikadowang sogoonon nga insarigan ka dowang ka libo nga ka pisos min-atobang iza ka toong amo daw indara ya anak nga dowang ka libo nga ka pisos. Minlaong iza nga Sinyor, insarigan mo hao ka dowang ka libo nga ka pisos. Kamhan wani pen isab ya anak na dowa mong ka libo. ");
INSERT INTO mmn_vpl VALUES ("MT25_23","070_25_23","MAT","25","23","23","Minsambag ya toong amo nga madazaw iko. Masarigan iko ka geramay nga kowarta agon isarig pen nao kanmo ya dakola. Magseled ko ka kanaong hel-anan kay panaranginan ta ko ka mga magazon. ");
INSERT INTO mmn_vpl VALUES ("MT25_24","070_25_24","MAT","25","24","24","Kamhan min-atobang sab kanangiza ya ikatlong sogoonon nga insarigan ka isang ka libo nga ka pisos. Nagabaribad iza nga nagalaong nga Sinyor, nahagdam di hao nga waray kalooy mo. An-ani ko dizan ka wara mo itanem. Anhipes ko dizan ka wara mo ipegas. ");
INSERT INTO mmn_vpl VALUES ("MT25_25","070_25_25","MAT","25","25","25","Nahaldek hao agon ya insarig mo kanao inlebeng nao dalem ka lopa. Wani dakoza ya insarig mo kanao. ");
INSERT INTO mmn_vpl VALUES ("MT25_26","070_25_26","MAT","25","26","26","Minsambag ya amo nga maonga iko nga sogoonon daw poloho. Kon matood ya baribad nga an-ani hao ka wara nao itanem daw anhipes hao dizan ka wara nao ipegas, ");
INSERT INTO mmn_vpl VALUES ("MT25_27","070_25_27","MAT","25","27","27","kay ono sa nga wara ko magbetang ka kanaong kowarta dizan ka bangko dazaw may anak di koman pag-oli nao? ");
INSERT INTO mmn_vpl VALUES ("MT25_28","070_25_28","MAT","25","28","28","Na, dini kanmo koman kaw-en ya kowarta nga isang ka libo daw ihatag dizan ka sogoonon nga may napolo nga ka libo nga ka pisos. ");
INSERT INTO mmn_vpl VALUES ("MT25_29","070_25_29","MAT","25","29","29","Kay kon masarigan ya tao ka insarig nao dizan kanangiza magadogangan pen gazed nao ya insarig nao kanangiza dazaw mataed gazed. Piro kon diri masarigan ya tao magakaw-en gazed nao kanangiza ya tanan nga insarig nao. ");
INSERT INTO mmn_vpl VALUES ("MT25_30","070_25_30","MAT","25","30","30","Na, ya sogoonon nga maonga iitsa mazo iza ngaro ka masarang kadeglem. Kamhan magapangageet iza ka toong ngipen ka paghaza. ");
INSERT INTO mmn_vpl VALUES ("MT25_31","070_25_31","MAT","25","31","31","Na, hao nga minhon-a ka bisan sin-o nga mahon-ang tao, kay-an ka pagbalik nao ngarini ka paghari ka mga tao anlo-to hao dizan ka lo-toanan ka paghari nga madazaw selengan. Iba sab kanao ya tanan mga sogoonon nga taga langit. ");
INSERT INTO mmn_vpl VALUES ("MT25_32","070_25_32","MAT","25","32","32","Kamhan dizan ka pag-atobang kanao tiponon ya tanan mga tao. Kamhan magabelagbelagen o ya isa daw isa singed ka pagbelag na magbantazay ka toong mga karniro daw mga kanding. ");
INSERT INTO mmn_vpl VALUES ("MT25_33","070_25_33","MAT","25","33","33","Na, ya mga singed ka karniro pantiponon nao dizan ka kanaong too. Ya mga singed ka kanding pantiponon nao dizan ka kanaong wala. ");
INSERT INTO mmn_vpl VALUES ("MT25_34","070_25_34","MAT","25","34","34","Kamhan hao nga anhari anlaong hao ka mga tao dizan ka kanaong too nga intagan di kamo ka magazon na kanaong Ama. Magseled kamo ka magazong hel-anan nga naandam daan para kamazo sokad kawandini pen ka sinogdan pen na kalibotan. ");
INSERT INTO mmn_vpl VALUES ("MT25_35","070_25_35","MAT","25","35","35","Kay izang dini kaini ka pagbengtasa ka nao impakaen mazo hao. Pag-ohawa ka nao impainem mazo hao. Bisan istranyo hao impapanik mazo hao dizan ka kamazong lagkaw. ");
INSERT INTO mmn_vpl VALUES ("MT25_36","070_25_36","MAT","25","36","36","Bisan waray bado nao intagan mazo hao. Izang pagkabedlay nao mintabang kamo kanao. Izang impapriso hao minbisita kamo kanao. ");
INSERT INTO mmn_vpl VALUES ("MT25_37","070_25_37","MAT","25","37","37","Kamhan ansambag ya mga matadeng nga tao nga Ginoo, kagan-o sa kami makakita kanmo nga inbengtas kamhan inpakaen ko nami? Kon in-ohaw kamhan inpainem? ");
INSERT INTO mmn_vpl VALUES ("MT25_38","070_25_38","MAT","25","38","38","Ya pag-istranyo mo kagan-o sa kami magpapanik kanmo? Ya waray ilis mo kagan-o sa kami maghatag kanmo ka bado? ");
INSERT INTO mmn_vpl VALUES ("MT25_39","070_25_39","MAT","25","39","39","Ginoo, kagan-o ya pagtabang nami ka pagkabedlay mo? Kagan-o ya pagbisita nami ka pagkapriso mo? ");
INSERT INTO mmn_vpl VALUES ("MT25_40","070_25_40","MAT","25","40","40","Kamhan hao nga hari ansambag hao kaniran nga panan-ogan ta kamo nga ya pagtabang mazo ka isa na labing obos na kanaong mga sakop ani ya pagtabang mazo kanao. ");
INSERT INTO mmn_vpl VALUES ("MT25_41","070_25_41","MAT","25","41","41","Kamhan anlaong hao ka mga tao dizan ka kanaong wala nga silotan gazed kamo. Pomanaw kamo dini kanao ngaro ka laga nga diri gazed mapareng nga in-andam daan para kan Satanas daw ya toong mga sogoonon. ");
INSERT INTO mmn_vpl VALUES ("MT25_42","070_25_42","MAT","25","42","42","Kay izang dini kaini ka pagbengtasa kanao wara mazo hao pakana. Izang pag-ohawa nao wara mazo hao paimna. ");
INSERT INTO mmn_vpl VALUES ("MT25_43","070_25_43","MAT","25","43","43","Ka istranyo pen hao doro kamazo wara mazo hao papanika. Bisan waray ilis nao nga bado wara mazo hao hatagi. Izang pagkabedlay nao daw pagkapriso wara mazo hao aligarahi. ");
INSERT INTO mmn_vpl VALUES ("MT25_44","070_25_44","MAT","25","44","44","Kamhan ansambag isab siran kanao nga Ginoo, daw kagan-o sa kami makakita kanmo nga inbengtas kon in-ohaw? Daw kagan-o sa kami makakita kanmo nga istranyo daw waray ilis nga bado? Kagan-o sa kami makakita kanmo nga nabedlay kon napiriso? Kamhan ono sang wara kami makatabang kanmo? ");
INSERT INTO mmn_vpl VALUES ("MT25_45","070_25_45","MAT","25","45","45","Kamhan ansambag hao kaniran nga panan-ogan ta kamo nga ya wara kamo magtabang ka isa na labing obos nga tao ani ya wara kamo magtabang kanao. ");
INSERT INTO mmn_vpl VALUES ("MT25_46","070_25_46","MAT","25","46","46","Kamhan pakarohen nao siran ka silot nga waray pagheneng. Piro ya mga matadeng nga tao mahatagan siran ka bag-ong kinabohi nga diri mawara. ");
INSERT INTO mmn_vpl VALUES ("MT26_1","070_26_1","MAT","26","1","1","Pagkakamhan ni Hisos pagsindo ka tanan minlaong iza ka toong mga sinarigan nga ");
INSERT INTO mmn_vpl VALUES ("MT26_2","070_26_2","MAT","26","2","2","mahagdam kamo nga kon-isa pen pan-ihawen na mga Yodayo ya mga nati na karniro kay mamista siran. Kamhan hao nga minhon-a ka bisan sin-o nga mahon-ang tao, dakpen hao niran dazaw ipalansang ka kros. ");
INSERT INTO mmn_vpl VALUES ("MT26_3","070_26_3","MAT","26","3","3","Na, ka nagalaong pen si Hisos ka toong mga sinarigan nagatipon di isab ya mga oloolo na mga pari daw ya mga malaas doro ka dakolang lagkaw ni Kayapas nga labaw nga pari. ");
INSERT INTO mmn_vpl VALUES ("MT26_4","070_26_4","MAT","26","4","4","Kay namagsabot siran nga dakpen si Hisos dazaw patazen niran. Piro kanirang tinago iton ");
INSERT INTO mmn_vpl VALUES ("MT26_5","070_26_5","MAT","26","5","5","kay nagalaong siran nga kay-an ka pagkaliwas na pista dakpen si Hisos dazaw diri magobot ya mga mamistahay. Ani ini ya sabot niran. ");
INSERT INTO mmn_vpl VALUES ("MT26_6","070_26_6","MAT","26","6","6","Na, dizan di si Hisos ka lagkaw ni Simon nga taga Bitani nga nabahawan ka kagid. ");
INSERT INTO mmn_vpl VALUES ("MT26_7","070_26_7","MAT","26","7","7","Kamhan may minseled nga babazi nga nagadara ka garapahay nga hininang nga bato. Ya ngaran na bato nga garapa ani alabastar. Ya leen na grapa klasi na lana nga masarang kahamot. Mahal gazed iton kon paliten. Kamhan imbo-boan di naiza ya olo ni Hisos ka nagakaen pen iza. ");
INSERT INTO mmn_vpl VALUES ("MT26_8","070_26_8","MAT","26","8","8","Pagpakakita ka na mga sinarigan ni Hisos nangazehet siran ka babazi nagalaong nga kay ono sa inhanogon sa mo ya lana nga mahamot? ");
INSERT INTO mmn_vpl VALUES ("MT26_9","070_26_9","MAT","26","9","9","Kontana ipakowarta mo iton kay mahal gazed kon paliten. Kamhan ya halin ipanhatag ka mga pobri. ");
INSERT INTO mmn_vpl VALUES ("MT26_10","070_26_10","MAT","26","10","10","Mahagdam si Hisos ka kanirang pagpanaba agon minlaong iza kaniran nga diri kamo magakasamok ka babazi kay ya toong hinang kanao madazaw gazed. ");
INSERT INTO mmn_vpl VALUES ("MT26_11","070_26_11","MAT","26","11","11","Kay ya mga pobri onay siran magaibaiba kamazo piro hao arani di ya tirmino nao ka pagpanaw dini kamazo. ");
INSERT INTO mmn_vpl VALUES ("MT26_12","070_26_12","MAT","26","12","12","Ya pagbo-bo na babazi ka kanaong lawas ani ya naandaman ka paglebeng kanao kay-an. ");
INSERT INTO mmn_vpl VALUES ("MT26_13","070_26_13","MAT","26","13","13","Timan-an mazo gazed ini nga ya pagbo-bo na babazi diri malipatan iton kay dini ka tibolos kalibotan bisan hain dapit ya pagwali na mga tao ka sindo mahitenged kanao ipanan-og sab niran ya toong pagbo-bo kanao. ");
INSERT INTO mmn_vpl VALUES ("MT26_14","070_26_14","MAT","26","14","14","Na, pagkakamhan kaiza si Hodas nga taga Kariyoti nga isa dizan ka mga napolo may dowang ka sinarigan ni Hisos minkaro iza ka mga oloolo na mga pari nga Yodayo. ");
INSERT INTO mmn_vpl VALUES ("MT26_15","070_26_15","MAT","26","15","15","Kamhan nangotana iza kaniran nga daw ono ya isohol mazo kanao kon haoy omatod kan Hisos dini kamazo? Kamhan minbazad siran ka katloan nga ka palata. Singed iton ka ikabazad ka isang bolos nga oripen. ");
INSERT INTO mmn_vpl VALUES ("MT26_16","070_26_16","MAT","26","16","16","Sokad kaiton nga aldawa nagapangita si Hodas ka paazi kon onhon naiza ka pag-edlaw kan Hisos. ");
INSERT INTO mmn_vpl VALUES ("MT26_17","070_26_17","MAT","26","17","17","Na, pagdateng ka primirong aldaw ka pista ka pagpangaen na mga Yodayo ka pan nga waray pasoligay minkarini kan Hisos ya toong mga sinarigan kay pangotanhen nga Ginoo, daw hain ya lagkaw nga andaman nami ka pagkaen mo ka pista? ");
INSERT INTO mmn_vpl VALUES ("MT26_18","070_26_18","MAT","26","18","18","Minsambag si Hisos nga komaro naa kamo ka may nagahela ka siyodad nga Hirosalem. Kamhan long-on mazo iza nga Nong, ya kanaming maistro ani minlaong nga arani di ya toong tirmino ka pagpanaw agon iza daw ya toong mga sinarigan ankaen siran ka pista dizan ka kanmong lagkaw. Ani ini ya pagtogon ni Hisos kaniran. ");
INSERT INTO mmn_vpl VALUES ("MT26_19","070_26_19","MAT","26","19","19","Kamhan mintoman siran ka sogo ni Hisos kaniran. Min-andam sab siran ka pagkaen kaan ka pista. ");
INSERT INTO mmn_vpl VALUES ("MT26_20","070_26_20","MAT","26","20","20","Pagkakahabzen kaiza dizan ka kananan mintambong si Hisos daw ya toong mga sinarigan nga napolo may dowa siran. ");
INSERT INTO mmn_vpl VALUES ("MT26_21","070_26_21","MAT","26","21","21","Ka nagapangaen pen siran minlaong si Hisos nga timan-an mazo gazed ini nga wadini kanta may isa nga an-edlaw kanao. ");
INSERT INTO mmn_vpl VALUES ("MT26_22","070_26_22","MAT","26","22","22","Kamhan nagalised gazed ya hena-hena na mga sinarigan. Tagsa tagsa kaniran minsambag nga Ginoo, diri gazed kon hao iton! ");
INSERT INTO mmn_vpl VALUES ("MT26_23","070_26_23","MAT","26","23","23","Kamhan minsambag si Hisos nga ya tao nga minsaro kanao ka pagkaen iza ya an-edlaw kanao. ");
INSERT INTO mmn_vpl VALUES ("MT26_24","070_26_24","MAT","26","24","24","Kay matoman gazed kaan ya daan pinasoyat na Diyos mahitenged ka pagkapatay nao. Basta ya tao nga om-edlaway kanao intawon madazaw kon wara iza pakataoha. ");
INSERT INTO mmn_vpl VALUES ("MT26_25","070_26_25","MAT","26","25","25","Kamhan si Hodas nga om-edlaway kan Hisos nangotana iza nga Maistro, daw hao ya an-edlaw kanmo? Minsambag si Hisos nga inlaong di mo. ");
INSERT INTO mmn_vpl VALUES ("MT26_26","070_26_26","MAT","26","26","26","Na, ka nagakaen pen siran minporot si Hisos ka pan. Pagpasalamat naiza ka Diyos impanipaktipak naiza iton kay ipanhatag ka toong mga sinarigan. Kamhan minlaong iza nga dawata ini. Kanen mazo kay ini nga pan kilalhen mazo nga kanaong lawas. ");
INSERT INTO mmn_vpl VALUES ("MT26_27","070_26_27","MAT","26","27","27","Kamhan minporot iza ka baso nga may imnenen nga sapa na mga obas. Pagpasalamat naiza ka Diyos impandoholan naiza siran daw nagalaong nga imna ini mazong tanan. ");
INSERT INTO mmn_vpl VALUES ("MT26_28","070_26_28","MAT","26","28","28","Kay ini nga imnenen kilalhen mazo nga kanaong dogo nga ipaawas nao kay-an ka pagkapatay nao para ka sala na mga mataed nga tao dazaw pasaylohon siran na Diyos ka kanirang mga sala. Ya kanaong dogo ani ya pirmahan na Diyos ka bag-ong saad naiza ka tanan mga tao. ");
INSERT INTO mmn_vpl VALUES ("MT26_29","070_26_29","MAT","26","29","29","Timan-an mazo gazed ini nga diri gazed hao an-inem pag-isab ka sapa na mga obas hangtod ka paghari na kanaong Ama ka bag-ong kalibotan. Anipen an-inem hao ka bag-ong imnenen iba kamazo. ");
INSERT INTO mmn_vpl VALUES ("MT26_30","070_26_30","MAT","26","30","30","Na, pagkakamhan niran pagkanta ka kasaza niran ka Diyos namanaw siran ngaro ka bobong nga Olibo. ");
INSERT INTO mmn_vpl VALUES ("MT26_31","070_26_31","MAT","26","31","31","Kamhan minlaong si Hisos kaniran nga koman nga kahabzen kamong tanan mandalagan daw mamiza kanao. Kamhan matoman ya daan pinasoyat na Diyos nga nagalaong nga ipapatay nao ya mag-aligrahay ka mga karniro. Kamhan mangabelagbelag di ya mga karniro. Ani ini ya daan pinasoyat na Diyos. ");
INSERT INTO mmn_vpl VALUES ("MT26_32","070_26_32","MAT","26","32","32","Kamhan pagkabohi nao pagbalik garing ka lebeng anhon-a hao kamazo doro ka Galiliya. ");
INSERT INTO mmn_vpl VALUES ("MT26_33","070_26_33","MAT","26","33","33","Minsambag si Pidro nga bisan bizaan iko nirang tanan, diri gazed hao ambiza kanmo. ");
INSERT INTO mmn_vpl VALUES ("MT26_34","070_26_34","MAT","26","34","34","Minsambag si Hisos nga Pidro, timan-an mo gazed ini nga koman nga kahabzen ka wara pen tagaok ya manok ikatolo di mo hao kon ilimed paglaong nga diri kon iko ya kanaong sakop. ");
INSERT INTO mmn_vpl VALUES ("MT26_35","070_26_35","MAT","26","35","35","Minsambag si Pidro nga agad kon patazen pen hao iba kanmo diri ta ko gazed paglimed. Kamhan ya tanan mga sinarigan minpanaba isab siran kan Hisos singed ka pagpanaba ni Pidro. ");
INSERT INTO mmn_vpl VALUES ("MT26_36","070_26_36","MAT","26","36","36","Pagkakamhan kaiza minkaro sin Hisos ka Gitsimani nga tamnanan ka mga liwaan inngaranan ka Olibo. Pagdateng dizan minlaong si Hisos nga maglo-to naa kamo dini kay ankaro pen hao ka hon-ahan kay ampangamozo pen hao ka Diyos. ");
INSERT INTO mmn_vpl VALUES ("MT26_37","070_26_37","MAT","26","37","37","Kamhan impaiba naiza si Pidro daw ya mga maanak ni Sibidiyo nga dowa siran. Kamhan si Hisos nagalised di ya toong hena-hena. ");
INSERT INTO mmn_vpl VALUES ("MT26_38","070_26_38","MAT","26","38","38","Nagalaong disab iza kaniran nga mabeg-at gazed ya kanaong hinawa anika daw ikapatazay di nao ini koman. Magtagad naa kamo dini. Diri di kita mazo magkatorog. ");
INSERT INTO mmn_vpl VALUES ("MT26_39","070_26_39","MAT","26","39","39","Pagkaro naiza dizan ka hon-ahan minpatihapa iza ka lopa kay anhangzo iza ka Diyos nga nagalaong nga Ama nao, kon mahimo diri mo hao pag-ipapatay para ka mga sala na mga tao. Piro iko ka say magaponto kanao. ");
INSERT INTO mmn_vpl VALUES ("MT26_40","070_26_40","MAT","26","40","40","Pagkakamhan naiza paghangzo minbalik iza ka toong mga sinarigan. Nangatorog siran. Kamhan minlaong si Hisos kan Pidro pagpokaw nga daw wara kamo makaanget pagbantay iba kanao bisan isa ka lamang ka oras? ");
INSERT INTO mmn_vpl VALUES ("MT26_41","070_26_41","MAT","26","41","41","Diri kamo magpangatorog. Magpangamozo kamo ka Diyos dazaw diri kamo dag-en ka pagtintal na mga maonga. Ansogot gazed ya hinawa mazo nga diri matorog piro ya kamazong lawas maloza gazed. ");
INSERT INTO mmn_vpl VALUES ("MT26_42","070_26_42","MAT","26","42","42","Pagkakamhan kaiza minbalik si Hisos ka inkarohan naiza kazina. Kamhan ikadowa di koman naiza pagpangamozo nagalaong nga Ama nao, kon diri mahimo nga ipalikay mo hao ka masiet nga kalised kaan tomanen mo lamang ya inbet-an mo kanao. ");
INSERT INTO mmn_vpl VALUES ("MT26_43","070_26_43","MAT","26","43","43","Kamhan minbalik iza ka toong mga sinarigan. Torog ka sab gihapon siran kay mabeg-at gazed ya kanirang mata. ");
INSERT INTO mmn_vpl VALUES ("MT26_44","070_26_44","MAT","26","44","44","Kamhan minbalik si Hisos ka inkarohan naiza kay ikatlo di koman naiza pagpangamozo ka toong Ama singed ka pagpangamozo naiza kazina. ");
INSERT INTO mmn_vpl VALUES ("MT26_45","070_26_45","MAT","26","45","45","Kamhan minbalik disab iza ka toong mga sinarigan. Kamhan nagalaong iza pagpokaw kaniran nga onosang nagapahikatorog pen sa kamo gihapon? Mindateng di koman ya tirmino nao ka pagkapatay. Magaedlawan di hao koman doro ka mga makasasala nga tao. ");
INSERT INTO mmn_vpl VALUES ("MT26_46","070_26_46","MAT","26","46","46","Pamangon di kamo. Selengi waton di ngarini ya om-edlaway kanao. Mangaro di kita hinoa pagsogat kaniran. ");
INSERT INTO mmn_vpl VALUES ("MT26_47","070_26_47","MAT","26","47","47","Na, ka nagapanaba pen si Hisos mindateng di matood ya isang sinarigan nga si Hodas. Iba ya mga mataed nga magakagobot nga mga tao nga nagapandara ka mga lodzo daw ya mga ibonalay kay insogo siran na mga oloolo na mga pari daw ya mga malaas nga Yodayo. ");
INSERT INTO mmn_vpl VALUES ("MT26_48","070_26_48","MAT","26","48","48","Impakahagdam daan siran ni Hodas nga nagalaong nga ya tao nga pangamostahen nao pag-arek ani ya dakpen mazo. ");
INSERT INTO mmn_vpl VALUES ("MT26_49","070_26_49","MAT","26","49","49","Na, pagkarini ni Hodas kan Hisos minlaong iza nga tinahod ong Maistro! Kamhan min-arek iza kan Hisos ka pagpangamosta. ");
INSERT INTO mmn_vpl VALUES ("MT26_50","070_26_50","MAT","26","50","50","Minsambag si Hisos nga tomanen mo ya tozo mo dini kanao. Kamhan indakep dazon si Hisos na mga tao. ");
INSERT INTO mmn_vpl VALUES ("MT26_51","070_26_51","MAT","26","51","51","Na, waton ya isang sakop ni Hisos nga nagahogot ka toong lodzo daw mintigbas. Kamhan nakawa dazon ya talinga na oripen na labaw nga pari. ");
INSERT INTO mmn_vpl VALUES ("MT26_52","070_26_52","MAT","26","52","52","Kamhan minbaheg si Hisos ka toong sakop nga isog-ob ya lodzo mo kay ya tao nga ambono ani isab ya pagabon-on. ");
INSERT INTO mmn_vpl VALUES ("MT26_53","070_26_53","MAT","26","53","53","Daw wara kamo mahagdam nga kon ampakitabang hao ka kanaong Ama ipadara dazon naiza ngarini kanao ya pirang ka libo nga kasoldawan nga taga langit? ");
INSERT INTO mmn_vpl VALUES ("MT26_54","070_26_54","MAT","26","54","54","Piro ini nga kalised angeten lamang dazaw matoman ya daan pinasoyat na Diyos. ");
INSERT INTO mmn_vpl VALUES ("MT26_55","070_26_55","MAT","26","55","55","Minlaong sab si Hisos ka mga mataed nga tao dizan nga onosa wani baza kamo? Daw tolisan hao wani nga dakpen di sa mazo hao koman ka lodzo daw ibonalay? Izang dini kaini dizan ka dakolang lagkaw nga pangamozoanan ka Diyos aldaw-aldaw nagalo-to hao ka pagsindo ka mga tao. Kamhan wara sa mazo hao dakpa. ");
INSERT INTO mmn_vpl VALUES ("MT26_56","070_26_56","MAT","26","56","56","Piro ya kaazi nao koman ani di ya pagtoman ka kasoyatan na mga karaang propita na Diyos mahitenged kanao. Pagkakamhan ni Hisos paglaong kaiza namiza dazon kanangiza ya tanan mga sinarigan. Nandalagan siran pag-izaiza. ");
INSERT INTO mmn_vpl VALUES ("MT26_57","070_26_57","MAT","26","57","57","Kamhan ya nandakep kan Hisos in-ated niran iza ngaro kan Kayapas nga labaw nga pari. Namagkatipon di dizan ya mga maistro ka tinoohan na mga Yodayo daw ya mga malaas. ");
INSERT INTO mmn_vpl VALUES ("MT26_58","070_26_58","MAT","26","58","58","Na, si Pidro minpaantaw iza ka pagsonod kan Hisos keteb ka pawa na lagkaw na labaw nga pari. Pagdateng ka ni Pidro dizan minlo-to iza iba ka mga magbantazay kay ampaniid iza kon onhon sa na mga oloolo si Hisos. ");
INSERT INTO mmn_vpl VALUES ("MT26_59","070_26_59","MAT","26","59","59","Na, dalem ka lagkaw nagatipon di ya mga oloolo na mga pari daw ya tanan mga maistro daw ya tanan mga malaas kay anpangita siran ka ikabetangbetang nga salaan si Hisos dazaw pahamtangan iza ka kamatazen. ");
INSERT INTO mmn_vpl VALUES ("MT26_60","070_26_60","MAT","26","60","60","Piro bisan mataed ya minpamakak wara gazed ya sala ni Hisos. Kamhan mintindeg ya dowang ka tao. ");
INSERT INTO mmn_vpl VALUES ("MT26_61","070_26_61","MAT","26","61","61","Nagapanan-og siran nga minlaong itong tao nga makageba iza ka dakolang lagkaw nga pangamozoanan ka Diyos. Pagkakamhan hinangen naiza koni ya bag-ong lagkaw ka tolo kang ka aldaw. ");
INSERT INTO mmn_vpl VALUES ("MT26_62","070_26_62","MAT","26","62","62","Pagkakamhan nirang dowa pagpanan-og ya labaw nga pari mintindeg dizan ka tenged niran kay nangotana iza kan Hisos nga daw waray ikasambag mo ka kanirang sombong? ");
INSERT INTO mmn_vpl VALUES ("MT26_63","070_26_63","MAT","26","63","63","Nagapahenek lamang si Hisos. Kamhan minlaong ya labaw nga pari nga ya Diyos nga bohi ani ya magapanalinga koman. Magpanan-og naa iko. Daw iko si Kristo nga Maanak na Diyos nga hari nga pinili naiza? ");
INSERT INTO mmn_vpl VALUES ("MT26_64","070_26_64","MAT","26","64","64","Minsambag si Hisos nga ani gazed hao. Timan-an mazo gazed ini nga kay-an di gazed mazo hao kon makitan nga magalo-to hao dizan ka too na Diyos kay hao ya minhon-a ka bisan sin-o nga mahon-ang tao. Makitan isab mazo hao pagkarimbaba nao garing ka langit iba ya mga gabon. ");
INSERT INTO mmn_vpl VALUES ("MT26_65","070_26_65","MAT","26","65","65","Pagpakabati ka na labaw nga pari kaiton inggisi naiza ya toong kaogaringen nga bado kay nazehet gazed iza nagalaong nga igo di iton. Wara di kita magkinahanglan ka dogang pen nga saksi. Nakabati di kamo nga garboso gazed iza pagbakak nga iza ya Maanak na Diyos. ");
INSERT INTO mmn_vpl VALUES ("MT26_66","070_26_66","MAT","26","66","66","Agon daw ono ya kamazong hena-hena kanangiza? Minsambag siran nga salaan gazed iza. Patazen di lamang iton. ");
INSERT INTO mmn_vpl VALUES ("MT26_67","070_26_67","MAT","26","67","67","Kamhan impamag-elban iza niran. Impanombag iza. Inlaparo isab iza na mga iba nga tao. ");
INSERT INTO mmn_vpl VALUES ("MT26_68","070_26_68","MAT","26","68","68","Nagalaong siran pagsora nga iko nga hari koni nga pinili na Diyos, tekmaen mo kon sin-o ya minlaparo kanmo koman! ");
INSERT INTO mmn_vpl VALUES ("MT26_69","070_26_69","MAT","26","69","69","Na, si Pidro nagalo-to iza dizan ka pawa na lagkaw na labaw nga pari. Kamhan may babazi nga binolanan nga minkadizan kanangiza daw nagalaong nga iko isab ya nagaibaiba kan Hisos nga taga Galiliya. ");
INSERT INTO mmn_vpl VALUES ("MT26_70","070_26_70","MAT","26","70","70","Minsambag si Pidro nga wara hao mahagdam. Minlimed iza kan Hisos dizan kanirang tanan. ");
INSERT INTO mmn_vpl VALUES ("MT26_71","070_26_71","MAT","26","71","71","Pagsinged ni Pidro ngaro ka azihanan na pirtahan waton ya iba nga babazi nga binolanan. Pagpakakita ka naiza kan Pidro minpanaba iza ka mga tao nga mintindeg dizan nga iton nga tao ani gazed ya nagaibaiba kan Hisos nga taga Nazarit. ");
INSERT INTO mmn_vpl VALUES ("MT26_72","070_26_72","MAT","26","72","72","Piro minlimed si Pidro pag-isab. Naninhaga iza paglaong nga wara gazed hao makakilala kaiton nga tao nga si Hisos. ");
INSERT INTO mmn_vpl VALUES ("MT26_73","070_26_73","MAT","26","73","73","Pagkateedteed kaiza inkaro si Pidro na mga mintindeg dizan. Minlaong siran nga iko gazed ya sakop ni Hisos kay anika ya tonada mazo ka mga panaba nga mga taga Galiliya. ");
INSERT INTO mmn_vpl VALUES ("MT26_74","070_26_74","MAT","26","74","74","Basta kay minpaninhaga si Pidro paglaong nga mapatay pen hao kon bakaken hao. Inday kon sin-o itong taohana nga magalong-on mazo. Pagkakamhan ni Pidro pagsambag mintagaok dazon ya manok. ");
INSERT INTO mmn_vpl VALUES ("MT26_75","070_26_75","MAT","26","75","75","Kamhan nakataremdem di si Pidro ka inlaong ni Hisos nga ka wara pen tagaok ya manok katlo mo hao ilimed. Na, pagpakataremdem ka ni Pidro masara gazed ya toong paghaza kay inlimed sa naiza si Hisos. ");
INSERT INTO mmn_vpl VALUES ("MT27_1","070_27_1","MAT","27","1","1","Na, pagkamasiselem kaiza ya tanan mga oloolo na mga pari daw ya mga malaas na mga Yodayo namagsabot siran kon onhon niran pagpapatay kan Hisos. ");
INSERT INTO mmn_vpl VALUES ("MT27_2","070_27_2","MAT","27","2","2","Kamhan in-ektan niran si Hisos ka kadina dazaw iated niran ngaro kan Pilato nga gobirnador. ");
INSERT INTO mmn_vpl VALUES ("MT27_3","070_27_3","MAT","27","3","3","Na, si Hodas nga min-edlaw kan Hisos, pagkahagdam ka naiza nga inhokman di niran si Hisos ka pagpatay minbasol gazed iza ka toong kaogaringen. Kamhan minbalik iza ngaro ka mga oloolo na mga pari daw ya mga malaas kay ioli kontana naiza ya toong sohol nga katloan nga ka palata. ");
INSERT INTO mmn_vpl VALUES ("MT27_4","070_27_4","MAT","27","4","4","Nagalaong iza kaniran nga nakasala gazed hao kay itong tao nga inhokman di mazo ka kamatazen waray sala naiza. Min-edlaw hao kanangiza. Minsambag siran nga waray labet nami kaiton. Kanmo ka sa lamang iton nga pagpasarig. ");
INSERT INTO mmn_vpl VALUES ("MT27_5","070_27_5","MAT","27","5","5","Kamhan intimbag ni Hodas ya kowarta dizan ka pirtahan na dakolang lagkaw nga pangamozoanan ka Diyos. Kamhan minpanaw iza kay anhikeg iza ka toong lieg. ");
INSERT INTO mmn_vpl VALUES ("MT27_6","070_27_6","MAT","27","6","6","Na, ya kowarta nga intimbag ni Hodas inpamorot di na mga oloolo ka mga pari. Kamhan minlaong siran nga ini nga kowarta ani ya inkabazad ka pagpatay ka tao agon kon ibetang dini ka betanganan na mga ihalad anlapas kita ka balaed. ");
INSERT INTO mmn_vpl VALUES ("MT27_7","070_27_7","MAT","27","7","7","Pagkakamhan niran pagsabot kon onhon sa niran ya kowarta impalit niran ya oma na tao nga maghinangay ka tadzaw. Kamhan inhinang niran ya oma ka lebnganan para ka mga istranyo nga namola. ");
INSERT INTO mmn_vpl VALUES ("MT27_8","070_27_8","MAT","27","8","8","Hangtod koman inngaranan niran iton nga omaha nga Imbayran ka Dogo. ");
INSERT INTO mmn_vpl VALUES ("MT27_9","070_27_9","MAT","27","9","9","Kamhan ya hinang niran ani nakatoman ka inlaong ni Hirimiyas nga karaang propita na Diyos. Kay kawandini pen nagalaong iza nga minkawa siran ka katloan nga ka palata. Kay garing ka pagsabot na mga oloolo na mga Yodayo ya geramay nga kowarta ani ya inbazad kan Hisos kay nagahena-hena siran waray polos naiza. ");
INSERT INTO mmn_vpl VALUES ("MT27_10","070_27_10","MAT","27","10","10","Kamhan ingamit niran ya kowarta ka pagpalit ka oma na tao nga maghinangay ka tadzaw kay ani ya insogo na Ginoo kanao. Ani ini ya inlaong ni Hirimiyas kawandini pen. ");
INSERT INTO mmn_vpl VALUES ("MT27_11","070_27_11","MAT","27","11","11","Na, si Hisos mintindeg iza dizan ka pag-atobang kan Pilato nga gobirnador kay pangotanhen di iza nga matod, ey, iko ya hari na mga Yodayo? Minsambag si Hisos nga itong inlaong mo kanao hao iton. ");
INSERT INTO mmn_vpl VALUES ("MT27_12","070_27_12","MAT","27","12","12","Piro wara iza magsambag ka mga oloolo na mga pari daw ya mga malaas pagbetangbetang niran kanangiza. ");
INSERT INTO mmn_vpl VALUES ("MT27_13","070_27_13","MAT","27","13","13","Kamhan nangotana si Pilato kan Hisos nga daw wara ko makabati ka kanirang mga mataed nga sombong kanmo? ");
INSERT INTO mmn_vpl VALUES ("MT27_14","070_27_14","MAT","27","14","14","Piro wara gazed si Hisos magsambag ka bisan isa kang sombong. Agon nabereng gazed si Pilato. ");
INSERT INTO mmn_vpl VALUES ("MT27_15","070_27_15","MAT","27","15","15","Na, kada toig ka pagpista na mga Yodayo ya batasan ni Pilato magapalogwa iza ka isang tao nga piniriso. Kamhan ya mga kataohan anikay magaparagbeet pagpili. ");
INSERT INTO mmn_vpl VALUES ("MT27_16","070_27_16","MAT","27","16","16","Na, dizan ka pirisohan may nabantog nga piniriso nga si Barabas nga masarang kaonga nga tao. ");
INSERT INTO mmn_vpl VALUES ("MT27_17","070_27_17","MAT","27","17","17","Pagtipon na mga tao nangotana si Pilato nga daw sin-o ya pilien mazo ka pagpalogwa nao si Barabas kon si Hisos nga magangaranan kan Kristo? ");
INSERT INTO mmn_vpl VALUES ("MT27_18","070_27_18","MAT","27","18","18","Ani ini ya toong pangotana kay mahagdam iza nga nagaarig ya mga pari kan Hisos agon in-ated niran iza ngarini ka gobirnador dazaw pahamtangan iza ka kamatazen. ");
INSERT INTO mmn_vpl VALUES ("MT27_19","070_27_19","MAT","27","19","19","Na, ka nagalo-to pen si Pilato dizan ka hokmanan impadara na toong asawa ya soyat nga nagalaong nga kazinang kahabzen nagalised ya kanaong hena-hena kay may nabatian nao pagtag-inep. Diri gazed iko maghilabet kaiton nga taohana kay waray sala naiza. Ani ini ya soyat na asawa ni Pilato. ");
INSERT INTO mmn_vpl VALUES ("MT27_20","070_27_20","MAT","27","20","20","Na, ya mga oloolo na mga pari daw ya mga malaas nagaapora siran ka mga tao ka pagpabohi kan Barabas. Kamhan ipapatay si Hisos. ");
INSERT INTO mmn_vpl VALUES ("MT27_21","070_27_21","MAT","27","21","21","Kamhan nangotana si Pilato kaniran pag-otro nga ya dowang ka tao daw sin-o ya bohian nao kanirang dowa? Minsambag siran nga si Barabas! ");
INSERT INTO mmn_vpl VALUES ("MT27_22","070_27_22","MAT","27","22","22","Nangotana si Pilato pag-otro kaniran nga ono sa ya gosto mazo kan Hisos nga inngaranan kan Kristo? Kamhan namagdengan gazed ya tanan mga tao pagsambag nga ipalansang di iton ka kros! ");
INSERT INTO mmn_vpl VALUES ("MT27_23","070_27_23","MAT","27","23","23","Nangotana si Pilato kay ono say sala naiza? Kamhan mindogang hinoa siran pagpaninggit nga ipalansang di iton ka kros! ");
INSERT INTO mmn_vpl VALUES ("MT27_24","070_27_24","MAT","27","24","24","Na, mahagdam si Pilato nga waray polos lamang ya pagpadazon pagpanaba kay minsogod di siran pagkasamok. Agon minlaong iza kaniran nga waray labet nao ka pagpatay mazo kaitong tao nga waray sala. Kamazo ka lamang iton. Kamhan impakawa naiza ya palangana daw sapa kay anhogas iza ka toong alima dizan ka pagkita niran kay timaan iton nga waray labet naiza ka pagpatay niran kan Hisos. ");
INSERT INTO mmn_vpl VALUES ("MT27_25","070_27_25","MAT","27","25","25","Kamhan minsambag sirang tanan nga kami daw ya kanaming mga kaliwatan ani dat-ogi ka silot ka pagpatay kaitong tao. ");
INSERT INTO mmn_vpl VALUES ("MT27_26","070_27_26","MAT","27","26","26","Pagkakamhan kaiza imbohian ni Pilato si Barabas ka prisohan. Kamhan impalatos naiza si Hisos daw impaated iza ngaro ka mga soldaw dazaw ilansang di ka kros. ");
INSERT INTO mmn_vpl VALUES ("MT27_27","070_27_27","MAT","27","27","27","Kamhan in-ated na mga soldaw si Hisos dizan ka pawa na dakolang lagkaw na gobirnador kay paniponon niran ya tanan mga soldaw dizan kan Hisos. ");
INSERT INTO mmn_vpl VALUES ("MT27_28","070_27_28","MAT","27","28","28","Kamhan inhoboan niran si Hisos ka isang ka lapid nga toong bado. Kamhan impabadoan iza ka mararag nga bado singed ka bado na hari piro lain. ");
INSERT INTO mmn_vpl VALUES ("MT27_29","070_27_29","MAT","27","29","29","Pagkakamhan niran paglokong ka balala nga mga dogihen inhinang niran ka korona. Kamhan insokbot niran dizan ka olo ni Hisos. Impahawid sab niran ya toong alima ka sogkod kay nagapakahinang ka hari. Kamhan dizan ka toong paahan nanlohod siran pagpatitahod. Nagasorasora siran pagsaza nagalaong nga tinahod ong hari na mga Yodayo! ");
INSERT INTO mmn_vpl VALUES ("MT27_30","070_27_30","MAT","27","30","30","Kamhan impamag-elban iza daw impamonalan ya toong olo kaiton nga sogkod. ");
INSERT INTO mmn_vpl VALUES ("MT27_31","070_27_31","MAT","27","31","31","Pagkakamhan niran pagsora kan Hisos inhoboan dazon niran ka bado nga mararag kay ipabado niran pagbalik ya toong kaogaringeng bado. Kamhan in-ated iza ngaro ka gawas na longsod kay ilansang di ka kros. ");
INSERT INTO mmn_vpl VALUES ("MT27_32","070_27_32","MAT","27","32","32","Na, ka nagapanaw pen siran dizan ka dalan may insogat niran nga si Simon nga taga Sirini. Kamhan insogo iza na mga soldaw pagpasili pagbathay ka kros ni Hisos. ");
INSERT INTO mmn_vpl VALUES ("MT27_33","070_27_33","MAT","27","33","33","Kamhan in-ated niran si Hisos ka dapit nga inngaranan ka Golgota. Na, ya kahologan na ngaran nga Golgota ani Ya Dapit ka Kalabira kay ani ya dapit ka pagpatay niran ka tao nga impahamtang ka kamatazen. ");
INSERT INTO mmn_vpl VALUES ("MT27_34","070_27_34","MAT","27","34","34","Pagdateng ka niran dizan impainem kontana si Hisos na mga soldaw ka bino sinaktan ka masarang kapait nga tambal ka kasakit ka paglansang. Piro pagtilaw naiza wara di iza mag-inem. ");
INSERT INTO mmn_vpl VALUES ("MT27_35","070_27_35","MAT","27","35","35","Pagkakamhan kaiza inlansang si Hisos ka kros. Kamhan namagriparipa siran kon sin-oy makatag-iza ka mga bado ni Hisos. ");
INSERT INTO mmn_vpl VALUES ("MT27_36","070_27_36","MAT","27","36","36","Kamhan namagpanlo-to siran dizan kay imbantazan niran si Hisos. ");
INSERT INTO mmn_vpl VALUES ("MT27_37","070_27_37","MAT","27","37","37","Kamhan dapit daked ka poro ni Hisos intapilan sab niran ya sinoyat nga pasangil kan Hisos nagalaong nga si Hisos ini nga Hari na mga Yodayo. ");
INSERT INTO mmn_vpl VALUES ("MT27_38","070_27_38","MAT","27","38","38","Na, dizan ka toong sain inlansang disab niran ya mga tolisan nga dowa siran. Ya isa dapit ka too ni Hisos. Ya ikadowa dimbali ka toong wala. ");
INSERT INTO mmn_vpl VALUES ("MT27_39","070_27_39","MAT","27","39","39","Kamhan ya mga tao nga namagpanlabay dizan ka mga kros nagabiaybiay siran kan Hisos ");
INSERT INTO mmn_vpl VALUES ("MT27_40","070_27_40","MAT","27","40","40","nga nagalaong nga matod sa iton nga nagalaong ko nga makageba ko ka dakolang lagkaw nga pangamozoanan ka Diyos. Kamhan baza-baza hinangen mo pag-isab ka bag-o ka tolo kang ka aldaw. Kon matood pen ya panaba mo tabangan mo koman ya kanmong kaogaringen. Kon iko ya Maanak na Diyos magtena di ko dizan ka kros. ");
INSERT INTO mmn_vpl VALUES ("MT27_41","070_27_41","MAT","27","41","41","Inkatawhan sab iza na mga oloolo na mga pari daw ya mga maistro daw ya mga malaas nagalaong nga ");
INSERT INTO mmn_vpl VALUES ("MT27_42","070_27_42","MAT","27","42","42","nakalibri iza ka iba nga tao piro diri iza makalibri ka toong kaogaringen lawas. Daw hari baza iza na mga kaliwatan ni Israil? Kon makatena iza dizan ka kros antoo kami nga iza ya Maanak na Diyos. ");
INSERT INTO mmn_vpl VALUES ("MT27_43","070_27_43","MAT","27","43","43","Minsarig iza ka Diyos. Kon maazakan iza na Diyos kontana tabangan iza koman na Diyos kay minlaong ini nga iza ya Maanak na Diyos. ");
INSERT INTO mmn_vpl VALUES ("MT27_44","070_27_44","MAT","27","44","44","Bisan ya mga tolisan nga inlansang iba kan Hisos nagabiaybiay isab siran kanangiza. ");
INSERT INTO mmn_vpl VALUES ("MT27_45","070_27_45","MAT","27","45","45","Na, pagkaedto di mindeglem gazed ya aldaw hangtod ka pagkabalantang na aldaw ka alas tris. ");
INSERT INTO mmn_vpl VALUES ("MT27_46","070_27_46","MAT","27","46","46","Kamhan ka hapit di alas tris mabaskeg gazed ya saba ni Hisos ka paghawag ka toong Ama ka saba nga Hinibriyo nagalaong nga kanaong Diyos, kay ono sa wani imbizaan di mo hao? ");
INSERT INTO mmn_vpl VALUES ("MT27_47","070_27_47","MAT","27","47","47","Na, ya mga minseleng dizan pagpakabati ka niran ka saba ni Hisos minlaong siran nga inhawag naiza si Iliyas nga karaang propita na Diyos. ");
INSERT INTO mmn_vpl VALUES ("MT27_48","070_27_48","MAT","27","48","48","Kamhan ya isang ka tao mindalagan iza ka pagkawa ka sizepanan. Kamhan inheeman iton ka len-anan ka bino nga barato kamhan integseb dizan ka liwaan dazaw idohol ka ba-ba ni Hisos kay dazaw makasizep. ");
INSERT INTO mmn_vpl VALUES ("MT27_49","070_27_49","MAT","27","49","49","Piro ya mga iba nga tao dizan minlaong siran nga tagad naa kita. Anseleng kita lamang kon ankarini si Iliyas pagtabang kanangiza. ");
INSERT INTO mmn_vpl VALUES ("MT27_50","070_27_50","MAT","27","50","50","Pagkakamhan kaiza minpahihawag pag-isab si Hisos. Kamhan nabogtoan dazon iza ka toong hinawa. ");
INSERT INTO mmn_vpl VALUES ("MT27_51","070_27_51","MAT","27","51","51","Kamhan dizan ka dakolang lagkaw nga pangamozoanan ka Diyos nagisi ya kortina garing daked lapos ngarimbaba ka sidsid. Kamhan minlinog di ya lopa, nanggepak di ya mga bato. ");
INSERT INTO mmn_vpl VALUES ("MT27_52","070_27_52","MAT","27","52","52","Kamhan ya mga lebnganan nangaabri. Kamhan ya mga daan mola nga sakop na Diyos nangabohi di siran pagbalik garing ka lebeng. ");
INSERT INTO mmn_vpl VALUES ("MT27_53","070_27_53","MAT","27","53","53","Kamhan nanlogwa siran ka mga lebnganan. Pagkabanhaw ni Hisos minkaro siran ka siyodad nga Hirosalem. Nakitan siran na mga mataed nga tao. ");
INSERT INTO mmn_vpl VALUES ("MT27_54","070_27_54","MAT","27","54","54","Na, ya kapitan daw ya toong mga soldaw nga nagabantay kan Hisos pagpakabati ka niran nga linog di wani daw ya mga iba nga kaberenganan nangahaldek gazed siran. Kamhan minlaong siran nga itong napatay iza matood ya Maanak na Diyos! ");
INSERT INTO mmn_vpl VALUES ("MT27_55","070_27_55","MAT","27","55","55","Na, dizan ka aro-aro may mga mataed nga babazi nga naneleng isab ka pagkapatay ni Hisos. Taga Galiliya siran nga nagaiba kan Hisos ngarini ka Hirosalem kay mintabang siran kanangiza. ");
INSERT INTO mmn_vpl VALUES ("MT27_56","070_27_56","MAT","27","56","56","Ya isang babazi ani si Mariya nga taga Magdala. Ya isa pen si Mariya nga ina ni Santiago daw si Hosi. Waton sab ya ina na mga maanak ni Sibidiyo. ");
INSERT INTO mmn_vpl VALUES ("MT27_57","070_27_57","MAT","27","57","57","Na, pagkadelem kaiza nga aldaw may mindateng nga kowartahan nga taga Arimatiya. Si Hosi ya toong ngaran daw sakop isab iza ni Hisos. ");
INSERT INTO mmn_vpl VALUES ("MT27_58","070_27_58","MAT","27","58","58","Kamhan minkaro iza kan Pilato kay minbaid iza ka pagkawa ka lawas ni Hisos kay ilebeng. Kamhan insogo ni Pilato ya toong mga soldaw ka paghatag kan Hosi ka lawas ni Hisos. ");
INSERT INTO mmn_vpl VALUES ("MT27_59","070_27_59","MAT","27","59","59","Inkawa ni Hosi iton kamhan inkomotan ka mga bag-ong panapton nga mapoti. ");
INSERT INTO mmn_vpl VALUES ("MT27_60","070_27_60","MAT","27","60","60","Kamhan inlebeng naiza doro ka may toong bag-ong hininang nga talangban nga lebnganan. Pagpasira naiza kaiton ka dakolang bato minpanaw dazon iza. ");
INSERT INTO mmn_vpl VALUES ("MT27_61","070_27_61","MAT","27","61","61","Kamhan dizan ka atobang na lebnganan nagalo-to si Mariya nga taga Magdala daw ya iba nga babazi inngaranan kan Mariya. ");
INSERT INTO mmn_vpl VALUES ("MT27_62","070_27_62","MAT","27","62","62","Pagkaliwas ka na pista minkaro kan Pilato ya mga oloolo na mga pari daw ya mga Parasiyo. ");
INSERT INTO mmn_vpl VALUES ("MT27_63","070_27_63","MAT","27","63","63","Kay anlaong siran nga Sinyor, izang mahon-a pen ka bohi pen izang bakaken minlaong iza nga kay-an koni ka pagdateng ka ikatolong aldaw sokad ka toong pagkapatay mabohi iza pag-isab garing ka lebeng. ");
INSERT INTO mmn_vpl VALUES ("MT27_64","070_27_64","MAT","27","64","64","Agon pabantazan mo gazed ya lebnganan keteb ka ikatlong aldaw kay basi kawaten ya lawas na toong mga sinarigan. Basi panan-ogan sab niran ya mga tao nga nabohi di iza garing ka lebeng. Kamhan ya bakak dakola iton ka mahon-ang bakak niran ka mga tao. ");
INSERT INTO mmn_vpl VALUES ("MT27_65","070_27_65","MAT","27","65","65","Minsambag si Pilato nga pakarohen mazo ya mga magbantazay dazaw bantazan gazed ya lebnganan. ");
INSERT INTO mmn_vpl VALUES ("MT27_66","070_27_66","MAT","27","66","66","Kamhan minkaro siran ka lebnganan kay imborit niran ya kilid na sira nga bato dizan ka pirtahan na lebnganan dazaw waray makahilabet. Kamhan impabantazan matood niran ka mga magbantazay ya pirtahan. ");
INSERT INTO mmn_vpl VALUES ("MT28_1","070_28_1","MAT","28","1","1","Na, paglabay ka na aldaw nga tigpahimlay ka hapit mapawa ya aldaw nga Dominggo si Mariya nga taga Magdala daw ya iba nga babazi inngaranan kan Mariya minkaro siran ka lebnganan. ");
INSERT INTO mmn_vpl VALUES ("MT28_2","070_28_2","MAT","28","2","2","Ka wara pen siran dateng ka lebnganan minlinog di ya lopa kay mintena ngarimbaba ya sinogo na Diyos garing daked ka langit. Kamhan inlingan naiza ya insira nga bato dizan ka pirtahan na lebnganan. Kamhan minlo-to iza dizan kaiton nga bato nga toong liningan. ");
INSERT INTO mmn_vpl VALUES ("MT28_3","070_28_3","MAT","28","3","3","Masiraw gazed ya toong bayho singed ka kasiraw na kilat. Masarang kapoti ya toong bado. ");
INSERT INTO mmn_vpl VALUES ("MT28_4","070_28_4","MAT","28","4","4","Pagkita na mga magbantazay ka sinogo na Diyos nagapidpid ya kanirang lawas ka kahaldek. Diri siran makahingas kay singed ka patay di siran. ");
INSERT INTO mmn_vpl VALUES ("MT28_5","070_28_5","MAT","28","5","5","Kamhan minlaong ya taga langit ka mga babazi nga diri kamo magkahaldek kay mahagdam hao nga nangita kamo kan Hisos nga inlansang ka kros. ");
INSERT INTO mmn_vpl VALUES ("MT28_6","070_28_6","MAT","28","6","6","Wara iza dini kay nabohi di iza garing ka mga patay singed ka toong inlaong kamazo izang dini kaini. Selengi mazo. Wani ya dapit nga pinabentagan kanangiza. ");
INSERT INTO mmn_vpl VALUES ("MT28_7","070_28_7","MAT","28","7","7","Komaro naa kamo ka toong mga sinarigan. Long-on mazo siran nga nabohi di si Hisos pagbalik garing ka mga patay. Anhon-a iza kamazo doro ka Galiliya. Doro kaiton magakita kamo kanangiza. Ani ini ya mga panaba na sinogo na Diyos. ");
INSERT INTO mmn_vpl VALUES ("MT28_8","070_28_8","MAT","28","8","8","Kamhan minpanaw dazon ya mga babazi. Nangahaldek siran piro dakola isab ya kanirang kasaza. Mindalagan siran ngaro kay panan-ogan niran ya mga sinarigan ni Hisos. ");
INSERT INTO mmn_vpl VALUES ("MT28_9","070_28_9","MAT","28","9","9","Na, ka nagapasinged pen siran ngaro inkasogat di baza niran si Hisos. Kamhan minlaong iza nga palinawen ya kamazong hinawa. Kamhan mintagen ya mga babazi ka toong paa pagtahod. ");
INSERT INTO mmn_vpl VALUES ("MT28_10","070_28_10","MAT","28","10","10","Kamhan minlaong iza kaniran nga diri kamo magkahaldek. Karohen di mazo ya kanaong mga sakop. Long-on mazo siran nga waro di siran kon somogat kanao ka Galiliya. ");
INSERT INTO mmn_vpl VALUES ("MT28_11","070_28_11","MAT","28","11","11","Kamhan minpanaw ya mga babazi. Minpanaw isab ya mga magbantazay dizan ka lebnganan kay an-oli di siran ka siyodad dazaw panan-ogan ya mga oloolo na mga pari ka kahimtang dizan ka lebnganan. ");
INSERT INTO mmn_vpl VALUES ("MT28_12","070_28_12","MAT","28","12","12","Na, pagtipon niran daw ya mga oloolo na mga pari daw ya mga malaas nga Yodayo namagsabot siran kon ono ya kanirang hinangen. Kamhan insoholan niran ya mga magbantazay ka dakolang kowarta ");
INSERT INTO mmn_vpl VALUES ("MT28_13","070_28_13","MAT","28","13","13","dazaw dizan ka mga tao ipanan-og niran ya bakak magalaong nga kazina ka kahabzen ya mga sinarigan ni Hisos siran ya minkaro ka lebnganan kamhan inkawat niran ya toong lawas ka pagkatorog pen nami. ");
INSERT INTO mmn_vpl VALUES ("MT28_14","070_28_14","MAT","28","14","14","Kamhan kon nabatian iton na gobirnador kami ka lamang nga mga oloolo ya anlaong kanangiza dazaw diri kamo kasab-an ka sazep mazo. ");
INSERT INTO mmn_vpl VALUES ("MT28_15","070_28_15","MAT","28","15","15","Pagkakamhan kaiza indawat na mga magbantazay ya kowarta. Intoman sab niran ya sogo kaniran. Kamhan mintoo ya mga Yodayo ka kanirang bakak hangtod koman aldawa. ");
INSERT INTO mmn_vpl VALUES ("MT28_16","070_28_16","MAT","28","16","16","Na, ya mga sinarigan ni Hisos nga napolo may isa nangaro siran ka Galiliya doro ka bobong nga intoldo daan kaniran ni Hisos. ");
INSERT INTO mmn_vpl VALUES ("MT28_17","070_28_17","MAT","28","17","17","Pagkita niran kan Hisos minlohod siran ka pagtahod kanangiza. Piro dizan kaniran may mga nagadowadowa pen nga kon si Hisos iton kon diri. ");
INSERT INTO mmn_vpl VALUES ("MT28_18","070_28_18","MAT","28","18","18","Kamhan minlaong iza kaniran nga inkasarig di kanao ya tanang pagbeet daked ka langit daw dimbaba ka kalibotan. ");
INSERT INTO mmn_vpl VALUES ("MT28_19","070_28_19","MAT","28","19","19","Agon pamanaw di kamo ngaro ka tanan mga tao dini ka tibolos kalibotan. Sindoan mazo siran kon onhon sa niran pagsakop kanao. Kamhan pamenzagan mazo siran kay timaan ini nga inharian di siran na Ama nga Diyos daw ya toong Maanak daw ya toong Ispirito nga Madazaw. ");
INSERT INTO mmn_vpl VALUES ("MT28_20","070_28_20","MAT","28","20","20","Kamhan sindoan mazo ya mga tao nga imbenzagan di dazaw antoman siran ka tanang mga sogo nao kamazo. Magtaremdem kamo nga onay hao an-iba kamazo keteb ka kataposan nga panahon dini ka kalibotan. Ani ini ya inpanaba ni Hisos kaniran.");
INSERT INTO mmn_vpl VALUES ("MK1_1","071_1_1","MRK","1","1","1","Wani ya pagkasogod na madazaw nga balita mahitenged kan Hiso Kristo nga Maanak na Diyos. ");
INSERT INTO mmn_vpl VALUES ("MK1_2","071_1_2","MRK","1","2","2","Na, kawandini pen mintandeg ya Diyos ka hinawa ni Isayas nga karaang propita. Kamhan minsoyat si Isayas nga nagalaong nga kawandini pen minlaong ya Diyos nga may sinogo nao nga ipahon-a nao dazaw an-andam iza ka pagdateng na kanaong Maanak. ");
INSERT INTO mmn_vpl VALUES ("MK1_3","071_1_3","MRK","1","3","3","Kamhan ya batasan na nasogo nao anhela iza doro ka kamingawan. Anhawag sab iza ka mga tao nga magalaong nga dazawen mazo ya kamazong batasan singed ka tao nga minhinglo ka dalan kay domatengay di ya Maanak na Diyos. Ani ini ya daan insoyat ni Isayas nga karaang propita. ");
INSERT INTO mmn_vpl VALUES ("MK1_4","071_1_4","MRK","1","4","4","Na, si Howan nga Magbenzagay ani ya ngaran na tao nga minhon-a kan Hiso Kristo. Doro ka kamingawan minwali iza nga nagalaong nga bizaan di mazo ya maongang batasan mazo. Kamhan benzagan ta kamo kay timaan iton nga impasaylo di na Diyos ya kamazong mga sala. Ani ini ya inwali ni Howan. ");
INSERT INTO mmn_vpl VALUES ("MK1_5","071_1_5","MRK","1","5","5","Kamhan mataed gazed ya mga tao nga minkaro kan Howan. Garing siran ka bisan hain nga lopa doro ka Yoda daw ya siyodad nga Hirosalem. Pagpanalinga niran ka inwali ni Howan nagalaong siran nga matood gazed mga salaan kami nga tao. Kamhan dizan ka sapa nga Hordan inpanbenzagan siran ni Howan. ");
INSERT INTO mmn_vpl VALUES ("MK1_6","071_1_6","MRK","1","6","6","Na, ya bado ni Howan nahinang nga bohok na kamiliyo nga bohi na tao. Ya toong bakes anit. Ya toong magakanen mga doron daw seg-ed. ");
INSERT INTO mmn_vpl VALUES ("MK1_7","071_1_7","MRK","1","7","7","Pagwali naiza ka mga tao minlaong iza nga may ansonod pen kanao nga labaw pen kanao. Dizan kanangiza hao ya labing obos kay iza gazed ya labaw ka gahem. ");
INSERT INTO mmn_vpl VALUES ("MK1_8","071_1_8","MRK","1","8","8","Nagabenzag hao kamazo ka sapa piro magbenzag iza kamazo ka Madazaw nga Ispirito nga garing ka Diyos dazaw paharian kamo naiza nga Ispirito. ");
INSERT INTO mmn_vpl VALUES ("MK1_9","071_1_9","MRK","1","9","9","Na, ka nagapamenzag pen si Howan ka mga tao si Hisos minpanaw iza ka Nazarit nga toong insoligan doro ka lopa nga Galiliya. Kamhan mindateng di iza ka sapa nga Hordan kay ampabenzag iza kan Howan. ");
INSERT INTO mmn_vpl VALUES ("MK1_10","071_1_10","MRK","1","10","10","Pagkakamhan ni Howan pagbenzag kan Hisos nakitan dazon ni Hisos nga singed ka naabri di ya langit. Waza sab baza ya Madazaw nga Ispirito nga garing ka Diyos minkarimbaba kan Hisos. Minpasingedsinged iton ka salapati. ");
INSERT INTO mmn_vpl VALUES ("MK1_11","071_1_11","MRK","1","11","11","Kamhan nabatian ni Hisos ya saba na Diyos nagalaong nga iko ya kanaong Maanak nga kanaong naazakan. Nakasaza gazed iko kanao. Ani ini ya inlaong na Diyos. ");
INSERT INTO mmn_vpl VALUES ("MK1_12","071_1_12","MRK","1","12","12","Pagkakamhan kaiza ya Madazaw nga Ispirito nga garing ka Diyos ani ya minpakaro kan Hisos ngaro ka kamingawan. ");
INSERT INTO mmn_vpl VALUES ("MK1_13","071_1_13","MRK","1","13","13","Kamhan nagahela si Hisos doro keteb ka kap-atan nga ka aldaw. Intintal gazed iza ni Satanas dazaw an-ato ka Diyos piro wara gazed si Hisos madaeg. Kamhan magatabangan iza na mga taga langit nga sogoonon na Diyos ka dizan pen iza ka kamingawan. ");
INSERT INTO mmn_vpl VALUES ("MK1_14","071_1_14","MRK","1","14","14","Na, inpapiriso si Howan ni Hirodis nga hari. Kamhan min-oli si Hisos ka lopa nga Galiliya kay minwali iza ka sindo garing ka Diyos ");
INSERT INTO mmn_vpl VALUES ("MK1_15","071_1_15","MRK","1","15","15","nga nagalaong nga mindateng di ya tirmino ka pagdateng na hari nga pinili na Diyos. Agon bizaan di mazo ya maongang batasan. Magtoo gazed kamo ka sindo nga garing ka Diyos. Ani ini ya inwali ni Hiso Kristo. ");
INSERT INTO mmn_vpl VALUES ("MK1_16","071_1_16","MRK","1","16","16","May isang aldaw nga nagapasinged si Hisos ka baybazen na danaw nga Galiliya. Kamhan si Simon daw ya toong lomon nga si Andris nga mangisdaay ani ya nakitan naiza. Nanimbag siran ka kanirang mga lazà pagpangisda. ");
INSERT INTO mmn_vpl VALUES ("MK1_17","071_1_17","MRK","1","17","17","Minlaong si Hisos kaniran nga somakop kamo kanao kay antoldo hao kamazo dazaw mahagdam kamo ka pagpasakop ka mga tao kanao singed ka pagpanlazà mazo ka mga isda. ");
INSERT INTO mmn_vpl VALUES ("MK1_18","071_1_18","MRK","1","18","18","Pagpakabati nin Simon ka sogo ni Hisos kaniran imbizaan dazon niran ya kanirang mga lazà kay an-iba gazed siran kan Hisos. ");
INSERT INTO mmn_vpl VALUES ("MK1_19","071_1_19","MRK","1","19","19","Pagkakamhan kaiza minlargo si Hisos pagpanaw ngaro ka isang baloto. Kamhan si Santiago daw si Howan nga maglomon nga mga maanak ni Sibidiyo ani ya nakitan naiza. Dizan ka baloto nagatahi siran ka kanirang mga lazà. ");
INSERT INTO mmn_vpl VALUES ("MK1_20","071_1_20","MRK","1","20","20","Kamhan pagpasakop ni Hisos kanirang dowa imbilin niran ya kanirang ama dizan ka baloto iba ya mga sinoholan. Kamhan min-iba sirang dowa kan Hisos. ");
INSERT INTO mmn_vpl VALUES ("MK1_21","071_1_21","MRK","1","21","21","Pagkakay-an kaiza mindateng sin Hisos ka longsod nga Kapirnaom. PagkaSabado nga tigpahimlay na mga Yodayo minseled si Hisos ka singbahan na mga Yodayo kay ansindo iza kaniran. ");
INSERT INTO mmn_vpl VALUES ("MK1_22","071_1_22","MRK","1","22","22","Kamhan nabereng gazed siran kay ya toong mga panaba labaw gazed ka gahem na mga panaba na mga maistro ka tinoohan na mga Yodayo. ");
INSERT INTO mmn_vpl VALUES ("MK1_23","071_1_23","MRK","1","23","23","Na, ka dizan pen si Hisos ka singbahan may tao nga inboang na maonga ");
INSERT INTO mmn_vpl VALUES ("MK1_24","071_1_24","MRK","1","24","24","nga minsinggit kanangiza nga nagalaong nga Hisos nga taga Nazarit, kay ono sa nga hilabtan sa mo kami? Daw ani ya inkarini mo ya pagpatay mo kanami? Mahagdam gazed hao nga iko gazed ya Maanak na Diyos nga waray maonga. ");
INSERT INTO mmn_vpl VALUES ("MK1_25","071_1_25","MRK","1","25","25","Minsambag si Hisos pagbaheg nga magpahenek ko. Domalagan di ko ka tao. ");
INSERT INTO mmn_vpl VALUES ("MK1_26","071_1_26","MRK","1","26","26","Na, pagsinggit ka na maonga daw pagkabiribid ka lawas na tao mindalagan dazon. ");
INSERT INTO mmn_vpl VALUES ("MK1_27","071_1_27","MRK","1","27","27","Kamhan nabereng gazed ya mga naneleng. Namaglaong siran nga ono sa ini nga bag-ong sindo? Labaw gazed ka gahem ya pagpanaba ni Hisos kay bisan ya mga maonga antoo baza siran ka toong sogo. ");
INSERT INTO mmn_vpl VALUES ("MK1_28","071_1_28","MRK","1","28","28","Kamhan minlekep di gazed ya ngaran ni Hisos doro ka lopa nga Galiliya. ");
INSERT INTO mmn_vpl VALUES ("MK1_29","071_1_29","MRK","1","29","29","Na, kamhan di ya pagsingba nin Hisos agon minkaro siran ka lagkaw ni Simon daw si Andris. Iba gihapon si Santiago daw si Howan. ");
INSERT INTO mmn_vpl VALUES ("MK1_30","071_1_30","MRK","1","30","30","Pagdateng niran ka lagkaw may bozag nga ogangan ni Simon nga nagabentag kay imbangkag gazed iza. Pagpakahagdam niran kan Hisos ");
INSERT INTO mmn_vpl VALUES ("MK1_31","071_1_31","MRK","1","31","31","minbisita iza kaiton nga nabedlay. Kamhan intagenan naiza ya alima na nabedlay dazaw patindegen. Inhowasan dazon iza ka toong hilanat. Kamhan minpakaen iza kaniran. ");
INSERT INTO mmn_vpl VALUES ("MK1_32","071_1_32","MRK","1","32","32","Pagkadelem kaiza impaarani kan Hisos ya bisan sin-o nga may mga masakit ka lawas daw ya mga tao nga inboang na mga maonga. ");
INSERT INTO mmn_vpl VALUES ("MK1_33","071_1_33","MRK","1","33","33","Dizan ka pirtahan na lagkaw ni Simon mintipon ya tanan mga taga Kapirnaom. ");
INSERT INTO mmn_vpl VALUES ("MK1_34","071_1_34","MRK","1","34","34","Kamhan inbahaw ni Hisos ya mga mataed nga tao nga nagaaanget ka mga klasi nga mga masakit. Inpalogwa sab naiza ya mga maonga. Diri togotan ni Hisos ka pagpapanaba ya mga maonga kay mahagdam siran nga iza ya Maanak na Diyos. Ani ini ya pagtabang ni Hisos ka mga tao ka dizan pen iza ka lagkaw ni Simon. ");
INSERT INTO mmn_vpl VALUES ("MK1_35","071_1_35","MRK","1","35","35","Na, pagkakamaaldawen ka minbangon si Hisos kay ampanaw iza ngaro ka waray tao kay ampangamozo iza ka Diyos. ");
INSERT INTO mmn_vpl VALUES ("MK1_36","071_1_36","MRK","1","36","36","Kamhan impangitan gazed iza nin Pidro. ");
INSERT INTO mmn_vpl VALUES ("MK1_37","071_1_37","MRK","1","37","37","Pag-apas niran nagalaong siran nga Hisos, mataed gazed ya mga ampangita kanmo. ");
INSERT INTO mmn_vpl VALUES ("MK1_38","071_1_38","MRK","1","38","38","Minsambag si Hisos nga ampanaw di kita mazo ngaro ka mga laing dapit kay anwali pen hao doro kay ani ya tood nao dini ka kalibotan. ");
INSERT INTO mmn_vpl VALUES ("MK1_39","071_1_39","MRK","1","39","39","Kamhan minsoroy si Hisos ka tibolos lopa nga Galiliya. Kay dalem ka kanirang mga singbahan nagawali iza. Indazaw sab naiza ya mga tao nga inharian na mga maonga. ");
INSERT INTO mmn_vpl VALUES ("MK1_40","071_1_40","MRK","1","40","40","Lomaza pomanaw siran insogat ni Hisos ya tao nga kagiden. Paglohod naiza ka paahan ni Hisos minhangzo iza nga nagalaong nga Sinyor, kon somogot ko ka pagpangamozo nao kanmo dazawen mo ya kanaong masakit. ");
INSERT INTO mmn_vpl VALUES ("MK1_41","071_1_41","MRK","1","41","41","Nalooy si Hisos kaiton nga tao. Kamhan inhogam iza ni Hisos daw nagalaong nga Loy, ansogot hao. Nawara di ya masakit ka kanmong lawas. ");
INSERT INTO mmn_vpl VALUES ("MK1_42","071_1_42","MRK","1","42","42","Kamhan nadazaw matood ya toong lawas. ");
INSERT INTO mmn_vpl VALUES ("MK1_43","071_1_43","MRK","1","43","44","Kamhan minsogo si Hisos nga nagalaong nga diri ko magpanan-og ka mga tao ka inhinang o kanmo. Pomanaw ko naa ngaro ka pari. Magpakita ko ka kanmong lawas diton. Kamhan magtoman ko ka balaed ni Moysis ka paghalad kay dazaw magmatood ya mga kataohan nga nawaraan ko ka kanmong kagid. ");
INSERT INTO mmn_vpl VALUES ("MK1_45","071_1_45","MRK","1","45","45","Ambaza kay pagpanaw na tao minpanan-og iza hinoa ka tanan mga tao nga indazaw iza ni Hisos. Agon diri di si Hisos makaazi ka mga longsod kay mataed ya an-apas kanangiza. Bisan minkaro iza ka kamingawan in-apas gihapon iza na mga tao garing ka bisan hain nga longsod. ");
INSERT INTO mmn_vpl VALUES ("MK2_1","071_2_1","MRK","2","1","1","Paglabay ka mga talagsa ka nga aldaw minbalik si Hisos ka longsod nga Kapirnaom. Kamhan may minlaong nga dizan si Hisos ka lagkaw. ");
INSERT INTO mmn_vpl VALUES ("MK2_2","071_2_2","MRK","2","2","2","Kamhan mataed ya antipon dalem ka lagkaw. Bisan ya pirtahan masiet gazed iton ka mga tao. Kamhan inwali siran ni Hisos ka sindo nga garing ka Diyos. ");
INSERT INTO mmn_vpl VALUES ("MK2_3","071_2_3","MRK","2","3","3","Na, ka nagawali pen iza kaniran may opat nga ka tao nga mindateng nga namaglahong ka tao nga diri mahingas ya lawas. ");
INSERT INTO mmn_vpl VALUES ("MK2_4","071_2_4","MRK","2","4","4","Piro masiet gazed ya pirtahan ka tao agon minpanik siran ka hagdan ngandaked ka malakbang nga atep. Pagpakaboslot kaniran ka atep nga tenged ni Hisos intonton niran ya bowahan nga inbentagan na paralitiko. ");
INSERT INTO mmn_vpl VALUES ("MK2_5","071_2_5","MRK","2","5","5","Pagpakakita ka ni Hisos ka inhinang niran mahagdam iza nga minsarig gazed siran kanangiza ka pagbahaw kaiton nga tao. Kamhan minlaong iza ka nabedlay nga Loy, impasaylo di nao ya kanmong mga sala. ");
INSERT INTO mmn_vpl VALUES ("MK2_6","071_2_6","MRK","2","6","6","Na, dizan kaiza may minlo-to nga mga maistro ka tinoohan na mga Yodayo. Pagpakabati niran ka inlaong ni Hisos ka paralitiko minlaong siran ka kanirang hena-hena nga ");
INSERT INTO mmn_vpl VALUES ("MK2_7","071_2_7","MRK","2","7","7","garboso gazed si Hisos pagbakak nga iza ya Diyos kay ya Diyos ani ya may gahem ka pagpasaylo ka mga sala. ");
INSERT INTO mmn_vpl VALUES ("MK2_8","071_2_8","MRK","2","8","8","Mahagdam dazon si Hisos nga maonga ya kanirang hena-hena agon nangotana iza nga kay ono sa nga malain sa ya kamazong hena-hena kanao? ");
INSERT INTO mmn_vpl VALUES ("MK2_9","071_2_9","MRK","2","9","9","Dini ka paralitiko singed ka masazon ya pagpasaylo ka toong mga sala kay diri mazo makita kon dizan pen ya toong mga sala kon wara di. Piro malised ya pagdazaw ka toong lawas kay makita dazon kon madazaw di iton kon diri pen. ");
INSERT INTO mmn_vpl VALUES ("MK2_10","071_2_10","MRK","2","10","10","Koman ipakilala nao kamazo nga may gahem nao ka pagpasaylo ka mga sala na bisan sin-o nga tao kay hao gazed ya minhon-a ka bisan sin-o nga mahon-ang tao. ");
INSERT INTO mmn_vpl VALUES ("MK2_11","071_2_11","MRK","2","11","11","Kamhan minsogo si Hisos ka paralitiko nga bomangon di ko. Lokoton di mo ya bentagan mo. Om-oli di ko ngaro ka lagkaw mo. ");
INSERT INTO mmn_vpl VALUES ("MK2_12","071_2_12","MRK","2","12","12","Kamhan minbangon matood ya paralitiko daw minhipid dazon iza ka toong banig. Kamhan dizan ka pagseleng na mga tao minpanaw iza ngaro. Agon nabereng gazed siran daw insaza niran ya Diyos nga nagalaong nga wara sa sokad ya nakitan nami nga singed kaini. ");
INSERT INTO mmn_vpl VALUES ("MK2_13","071_2_13","MRK","2","13","13","Pagkakamhan kaiza minbalik si Hisos ka baybazen na danaw. Kamhan mintipon ya mataed nga mga tao dizan kanangiza. Kamhan minsindo iza kaniran. ");
INSERT INTO mmn_vpl VALUES ("MK2_14","071_2_14","MRK","2","14","14","Pagkakamhan kaiza min-azi si Hisos dizan ka opisina nga bayranan ka mga bohis na mga karga. Kamhan ya magsokotay ka mga bohis nga si Libi nga maanak ni Alpiyo ani ya nakitan ni Hisos kay nagalo-to iza dizan ka toong opisina. Kamhan minlaong si Hisos kan Libi nga somakop ko kanao. Kamhan mintindeg dazon si Libi kay an-iba iza kan Hisos. ");
INSERT INTO mmn_vpl VALUES ("MK2_15","071_2_15","MRK","2","15","15","Kamhan ampakaen si Libi kan Hisos daw ya toong mga sinarigan. Min-intra disab dizan ya mga mataed nga magsokotay singed kan Libi daw ya mga iba pen nga salaan nga tao kay siran isab ya nagaibaiba kan Hisos. ");
INSERT INTO mmn_vpl VALUES ("MK2_16","071_2_16","MRK","2","16","16","Ka nagakaen pen sirang tanan inpaniidan siran na mga maistro na mga Yodayo. Na, ya ngaran na mga maistro ka tinoohan na mga Yodayo ani ya Parasiyo nga hopaw ya kanirang pagtoo. Kamhan nangotana siran ka mga sakop ni Hisos pagmahay nga nagalaong nga kay ono sa ya kamazong maistro minpakigsaro ka mga salaan nga tao? Ani ini ya pangotana niran kay ya batasan na mga magsokotay ka bohis onay oswagan ya bohis. ");
INSERT INTO mmn_vpl VALUES ("MK2_17","071_2_17","MRK","2","17","17","Pagpakabati ka ni Hisos ka pagmahay niran minsambag iza nagalaong nga pamolinged ini nga ya mga tao nga madazaw ya lawas wara siran magpatambal basta kay ya mga masakiten. Kamhan wara hao magkarini ka pagtabang ka mga matadeng nga tao basta kay ya mga makasasala dazaw anhinelsel siran ka kanirang mga sala. Ani ini ya inlaong ni Hisos ka mga Parasiyo. ");
INSERT INTO mmn_vpl VALUES ("MK2_18","071_2_18","MRK","2","18","18","Na, nagaanget ka makaen ya mga sakop ni Howan nga Magbenzagay daw ya mga Parasiyo kay nagatoman siran ka balaed nga tinoohan na mga Yodayo. Kamhan minlaong ya mga tao kan Hisos nga kay ono sa wara magtoman ya kanmong kasakopan ka batasan ka pag-anget ka makaen singed ka mga sakop ni Howan daw ya mga Parasiyo? ");
INSERT INTO mmn_vpl VALUES ("MK2_19","071_2_19","MRK","2","19","19","Minsambag si Hisos pagpamolinged nga ya kanaong kasakopan singed siran ka mga magkombitihay. Kamhan dizan kaniran hao ya singed ka banahen agon ka dini pen hao kaniran diri siran an-anget ka makaen. ");
INSERT INTO mmn_vpl VALUES ("MK2_20","071_2_20","MRK","2","20","20","Piro may tirmino nga kaw-en hao garing ka kanaong mga sakop anipen omanget siran ka makaen kay mabeg-at ya kanirang hinawa. ");
INSERT INTO mmn_vpl VALUES ("MK2_21","071_2_21","MRK","2","21","21","Wani ya pamolinged dazaw mahagdam kamo nga ya kanaong sindo diri makaangay ka mga balaed nga tinoohan na mga Yodayo. Kay ya kanaong sindo singed iton ka bag-ong panapton. Kamhan ya mga balaed na mga Yodayo singed iton ka bado nga nadonot di. Na, pagtopak nita ka nadonot nga bado diri di gamiten ya bag-ong panapton kay basi kay-an ka paglaba ka bado ankezes ya topakay nga bag-ong panapton. Kamhan magakagisi ya daan bado pagdobli. ");
INSERT INTO mmn_vpl VALUES ("MK2_22","071_2_22","MRK","2","22","22","Bisan ya bag-ong bino nga magabora pen diri ihalin ka daan len-anan nga kindal na kanding kay kon begketen ya ba-ba na len-anan magisi gazed iton. Kamhan an-awas ya bino daw kanogon sab ya len-anan nga magisi. Agon gamiten gazed ya bag-ong len-anan. Ani ini ya pamolinged ni Hisos ka mga tao dazaw mahagdam siran nga ya toong sindo diri makaangay ka mga balaed nga tinoohan na mga Yodayo. ");
INSERT INTO mmn_vpl VALUES ("MK2_23","071_2_23","MRK","2","23","23","Na, may isang ka Sabado dizan ka homazan nagaazi si Hisos. Na, ya Sabado ani ya tigpahimlay na mga Yodayo. Na, pag-azi ka ni Hisos nagapangitlo ya toong mga sakop ka mga homay kay kanen niran. ");
INSERT INTO mmn_vpl VALUES ("MK2_24","071_2_24","MRK","2","24","24","Pagpakapaniid ka na mga Parasiyo kanin Hisos minbaheg siran nagalaong nga paka selengi! Minlapas gazed ya kanmong mga sakop ka balaed na Diyos kay koman nga tigpahimlay min-ani siran ka homay. ");
INSERT INTO mmn_vpl VALUES ("MK2_25","071_2_25","MRK","2","25","25","Minsambag si Hisos nga mahagdam kamo daan ka inhinang ni Dabid nga karaang tao na mga Yodayo. Kawandini pen imbengtas iza daw ya toong kaibahan kay inlopog siran na kanirang mga kaaway. ");
INSERT INTO mmn_vpl VALUES ("MK2_26","071_2_26","MRK","2","26","26","Agon pagdateng niran ka lagkaw nga pangamozoanan ka Diyos nangazo siran ka makaen dizan kan Abiyatar nga labaw nga pari. Kamhan wara iza magbaheg kaniran kay imbengtas siran. Kamhan minkaen si Dabid ka tinapay nga inhalad daan ka Diyos. Minpakaen isab iza ka toong kaibahan. Bisan ya mga pari anikay ankaen kitong mga tinapay wara si Dabid maglapas ka balaed na Diyos ka pagkaen naiza. ");
INSERT INTO mmn_vpl VALUES ("MK2_27","071_2_27","MRK","2","27","27","Kay ya pagtabang ka kinahanglanen na tao ani say labaw ka kamazong mga balaed nga mabeg-at. Kay minhinang ya Diyos ka tao paghon-a ka paghinang naiza ka aldaw nga tigpahimlay. ");
INSERT INTO mmn_vpl VALUES ("MK2_28","071_2_28","MRK","2","28","28","Kamhan hao ya ambeet kon ono ya madazaw nga hinang na tao ka aldaw nga tigpahimlay kay hao ya minhon-a ka bisan sin-o nga mahon-ang tao. Ani ini ya sambag ni Hisos ka mga Parasiyo. ");
INSERT INTO mmn_vpl VALUES ("MK3_1","071_3_1","MRK","3","1","1","May isa pen nga ka Sabado nga minseled gihapon si Hisos ka singbahan na mga Yodayo. Na, dizan disab may tao nga diri mahingas ya pikas nga toong alima. ");
INSERT INTO mmn_vpl VALUES ("MK3_2","071_3_2","MRK","3","2","2","Na, ya mga maistro ka tinoohan na mga Yodayo nagapaniid gazed siran kan Hisos kay kon dazawen naiza ya alima naiton nga tao awazen iza niran kay singed ka antarabaho iza koman nga aldaw nga tigpahimlay. ");
INSERT INTO mmn_vpl VALUES ("MK3_3","071_3_3","MRK","3","3","3","Kamhan minlaong si Hisos ka tao nga komarini ko naa. ");
INSERT INTO mmn_vpl VALUES ("MK3_4","071_3_4","MRK","3","4","4","Pagtindeg na tao dizan ka tenga nangotana si Hisos ka mga Parasiyo nagalaong nga ya balaed na Diyos mahitenged ka aldaw nga tigpahimlay daw itogot ka pagkalooy ka tao kon itogot ka pagdaet ka tao? Kamhan wara siran magsambag. ");
INSERT INTO mmn_vpl VALUES ("MK3_5","071_3_5","MRK","3","5","5","Pagseleng ni Hisos kaniran mabeg-at ya toong hinawa ka pagkazehet kay waray kalooy niran ka tao. Kamhan minsogo si Hisos ka tao nga Loy, henaten mo ya kanmong alima. Kamhan inhenat matood naiza ya toong alima. Kamhan minbalik dazon ya kabaskeg na toong alima singed ka karig-en na isang alima. ");
INSERT INTO mmn_vpl VALUES ("MK3_6","071_3_6","MRK","3","6","6","Kamhan minpanaw dazon ya mga Parasiyo kay dizan ka mga Yodayo nga minsakop di kan Hirodis nga hari ansabot siran nga patazen niran si Hisos. ");
INSERT INTO mmn_vpl VALUES ("MK3_7","071_3_7","MRK","3","7","7","Pagkakamhan kaiza minbalik si Hisos ka baybazen na danaw iba ya toong mga sinarigan. Kamhan nangarini kan Hisos ya mga mataed nga tao garing ka lopa nga Galiliya daw ya lopa nga Yoda ");
INSERT INTO mmn_vpl VALUES ("MK3_8","071_3_8","MRK","3","8","8","daw ya siyodad nga Hirosalem. Nangarini sab ya mga mataed nga tao garing ka lopa nga Idomaya daw dipi ka sapa nga Hordan daw garing ka mga dapit tenged ka dowang ka longsod nga Tiro daw Sidon. Nangarini sirang tanan kay nabatian niran ya panan-og mahitenged ka tanan mga inhinang ni Hisos. ");
INSERT INTO mmn_vpl VALUES ("MK3_9","071_3_9","MRK","3","9","9","Kamhan minsogo si Hisos ka toong mga sinarigan nagalaong nga ektan mazo ya baloto dazaw anleen hao kay basi maheet gazed hao ka mga tao. ");
INSERT INTO mmn_vpl VALUES ("MK3_10","071_3_10","MRK","3","10","10","Ani ini ya toong inlaong kay mataed ya tao nga indazaw naiza agon bisan sin-o ya may masakit an-arani gazed iza pagheet kan Hisos kay maazak siran antoldok kan Hisos. ");
INSERT INTO mmn_vpl VALUES ("MK3_11","071_3_11","MRK","3","11","11","Bisan ya mga maonga nga minhari ka hinawa na tao pagseleng niran kan Hisos minlohod siran dizan ka toong paahan kamhan minsinggit nagalaong nga iko gazed ya Maanak na Diyos. ");
INSERT INTO mmn_vpl VALUES ("MK3_12","071_3_12","MRK","3","12","12","Kamhan minbaheg gazed si Hisos kaniran dazaw diri siran ampanan-og kon sin-o sa iza. ");
INSERT INTO mmn_vpl VALUES ("MK3_13","071_3_13","MRK","3","13","13","Pagkakamhan kaiza minkandaked si Hisos ka kilid na bobong. Inpakandaked disab naiza ya mga tao nga naazakan naiza nga pilien. Pagdateng niran dizan kanangiza ");
INSERT INTO mmn_vpl VALUES ("MK3_14","071_3_14","MRK","3","14","14","impili naiza ya napolo may dowang ka tao nga toong mga sinarigan dazaw an-iba siran kanangiza daw pakarohan siran ka pagwali ka sindo nga garing ka Diyos. ");
INSERT INTO mmn_vpl VALUES ("MK3_15","071_3_15","MRK","3","15","15","Kamhan intagan siran naiza ka gahem ka pagpadalagan ka mga maonga nga minhari ka hinawa na tao. ");
INSERT INTO mmn_vpl VALUES ("MK3_16","071_3_16","MRK","3","16","16","Na, wani ya mga ngaran na mga tao nga inpili ni Hisos. Ya primiro ani si Simon nga indagnazan naiza kan Pidro. ");
INSERT INTO mmn_vpl VALUES ("MK3_17","071_3_17","MRK","3","17","17","Kamhan ya maglomon nga si Santiago daw si Howan. Mga maanak siran ni Sibidiyo. Indagnazan siran naiza kan Bowanirgis kay diri siran mahaldek ka bisan ono. ");
INSERT INTO mmn_vpl VALUES ("MK3_18","071_3_18","MRK","3","18","18","Kamhan impili naiza si Andris daw si Pilipo daw si Bartolomi daw si Matiyo daw si Tomas daw si Santiago nga maanak ni Alpiyo daw si Tadiyo daw si Simon nga masinopaken ka hari nga Romanhon ");
INSERT INTO mmn_vpl VALUES ("MK3_19","071_3_19","MRK","3","19","19","daw si Hodas nga taga Kariyoti ani ya an-edlaw kan Hisos. Ani ini ya mga ngaran na mga sinarigan ni Hisos nga napolo may dowa siran. Na, pagkakamhan ni Hisos pagpili kaniran nangoli di siran iba kan Hisos. ");
INSERT INTO mmn_vpl VALUES ("MK3_20","071_3_20","MRK","3","20","20","Pagdateng niran ka lagkaw mataed disab ya mga tao agon waray logar niran ka pagkaen. ");
INSERT INTO mmn_vpl VALUES ("MK3_21","071_3_21","MRK","3","21","21","Kamhan nawied ya mga kaibahan ni Hisos kay silaong niran maboangboang iza kay waray pagberebentagay naiza. Agon ibahen iza kontana ngaro ka waray tanto nga tao. ");
INSERT INTO mmn_vpl VALUES ("MK3_22","071_3_22","MRK","3","22","22","Kamhan ya mga maistro nga Yodayo nga garing ka Hirosalem minsora siran paglaong nga si Hisos inharian iza ni Satanas inngaranan sab kan Bilsibol nga tag-iza ka mga maonga. Agon may gahem gazed naiza ka pagbogaw ka mga maonga. ");
INSERT INTO mmn_vpl VALUES ("MK3_23","071_3_23","MRK","3","23","23","Kamhan inpakarini siran ni Hisos kay ansambag iza kaniran nga onhon sa baza ni Satanas ka pagbogaw ka toong kaogaringeng ispirito? Pamolinged ini nga ");
INSERT INTO mmn_vpl VALUES ("MK3_24","071_3_24","MRK","3","24","24","kon awazen na hari ya toong mga sinogo mapildi gazed ya hari. ");
INSERT INTO mmn_vpl VALUES ("MK3_25","071_3_25","MRK","3","25","25","Kon ampakig-away ya isa daw isa nga lomon dizan ka isang pamiliya mapildi isab ya pamiliya. ");
INSERT INTO mmn_vpl VALUES ("MK3_26","071_3_26","MRK","3","26","26","Kon bogawen ni Satanas ya toong kaogaringen nga ispirito dizan ka tao mapildi gazed si Satanas. ");
INSERT INTO mmn_vpl VALUES ("MK3_27","071_3_27","MRK","3","27","27","Dizan ka lagkaw na kesgan nga tao kinahanglan ektan ya kesgan nga tao anipen kawaten ya toong mga betang. Singed si Satanas ka kesgan nga tag-iza ka lagkaw. Hao kay nakadaeg kan Satanas agon papanawen nao ya toong mga sinogo dizan ka tao. ");
INSERT INTO mmn_vpl VALUES ("MK3_28","071_3_28","MRK","3","28","28","Timan-an mazo gazed ini nga bisan ono nga sala na mga tao pasaylohon na Diyos. Bisan ya pagpanaba niran ka maonga mahitenged ka Diyos pasaylohon siran na Diyos kon anhinelsel siran. ");
INSERT INTO mmn_vpl VALUES ("MK3_29","071_3_29","MRK","3","29","29","Basta kay bisan sin-o ya ampanaba ka maonga mahitenged ka Madazaw nga Ispirito nga garing ka Diyos diri gazed pasaylohon iza na Diyos. Bisan kawanihen ka waray pasaylo. ");
INSERT INTO mmn_vpl VALUES ("MK3_30","071_3_30","MRK","3","30","30","Ani ini ya inbaheg ni Hisos kay minlaong ya mga Parasiyo nga inharian si Hisos na maonga. ");
INSERT INTO mmn_vpl VALUES ("MK3_31","071_3_31","MRK","3","31","31","Pagkakamhan kaiza dizan ka lagkaw palogwaen kontana si Hisos na toong ina daw mga lomon kay bali lamang siran ka gawas. ");
INSERT INTO mmn_vpl VALUES ("MK3_32","071_3_32","MRK","3","32","32","Kamhan inpakahagdam iza na mga minlibot nga nagalaong nga Nong, bali ka gawas ya kanmong ina daw mga lomon. Gosto siran anlaong kanmo. ");
INSERT INTO mmn_vpl VALUES ("MK3_33","071_3_33","MRK","3","33","33","Minsambag si Hisos nga daw sin-o sa ya kanaong ina daw ya mga lomon? ");
INSERT INTO mmn_vpl VALUES ("MK3_34","071_3_34","MRK","3","34","34","Pagseleng naiza ka mga minlibot kanangiza minlaong iza nga kamo ya kanaong ina daw kanaong mga lomon. ");
INSERT INTO mmn_vpl VALUES ("MK3_35","071_3_35","MRK","3","35","35","Kay bisan sin-o ya nagatoman ka mga sogo na Diyos ani gazed ya kanaong ina daw lomon. ");
INSERT INTO mmn_vpl VALUES ("MK4_1","071_4_1","MRK","4","1","1","Na, may isa pen nga ka aldaw dizan si Hisos ka baybazen na danaw kay ansindo iza ka mga tao pag-isab. Masarang kataed siran nga minlibot kan Hisos. Agon minleen iza ka baloto arani ka baybazen. Kamhan minlo-to iza dalem kaiza. Kamhan dizan ka baybazen nanalinga ya mga tao. ");
INSERT INTO mmn_vpl VALUES ("MK4_2","071_4_2","MRK","4","2","2","Kamhan mintoldo iza kaniran ka mga mataed nga pamolinged nagalaong nga ");
INSERT INTO mmn_vpl VALUES ("MK4_3","071_4_3","MRK","4","3","3","manalinga kamo. Wani ya pamolinged ka nagasabwag. Na, may isang aldaw nga minpanaw ya tao ngaro ka toong oma kay anpanabwag iza ka binhi nga homay. ");
INSERT INTO mmn_vpl VALUES ("MK4_4","071_4_4","MRK","4","4","4","Pagpanabwag naiza ka mga binhi may mga natanak dizan ka dalan. Kamhan inpanoktok na mga manokmanok. ");
INSERT INTO mmn_vpl VALUES ("MK4_5","071_4_5","MRK","4","5","5","Pagpanabwag pen na tao may mga natanak isab dizan ka kabatohan. Kamhan mintobo dazon iton kay diri kon ararem ya lopa. ");
INSERT INTO mmn_vpl VALUES ("MK4_6","071_4_6","MRK","4","6","6","Kamhan pagkaataas na sega nangalaza dazon sirang tanan. Kamhan nangapatay kay diri siran makagamot ka ararem. ");
INSERT INTO mmn_vpl VALUES ("MK4_7","071_4_7","MRK","4","7","7","May mga natanak disab dizan ka lopa nga nanhela pen ya mga liso na sagbet. Pagtobo na binhi mindengan isab ya sagbet nga dogihen. Kamhan inhal-ong gazed na sagbet ya mga tanem. ");
INSERT INTO mmn_vpl VALUES ("MK4_8","071_4_8","MRK","4","8","8","May mga natanak isab dizan ka lopa nga madazaw. Kamhan mintobo iton daw mataed ya ohay. May mga nangaohay ka katloan. May mga nangaohay ka kan-eman. May mga nangaohay ka isang ka gatos. Ani ini ya pamolinged ka nagasabwag. ");
INSERT INTO mmn_vpl VALUES ("MK4_9","071_4_9","MRK","4","9","9","Kamhan minsogo si Hisos kaniran nga kamo nga mga manalingahay sabten mazo ini nga pamolinged. ");
INSERT INTO mmn_vpl VALUES ("MK4_10","071_4_10","MRK","4","10","10","Pagkakay-an kaiza isa ka si Hisos dizan agon nangotana ya toong mga sinarigan daw ya kanirang kaibahan nga Hisos, kay ono sang nagapasagisagi sa ko ka kanmong mga panaba ka mga tao? ");
INSERT INTO mmn_vpl VALUES ("MK4_11","071_4_11","MRK","4","11","11","Minsambag si Hisos kaniran nga ipasabot na Diyos kamazo ya mga tinago mahitenged ka pagpasakop naiza ka mga tao. Piro dizan ka mga iba nga tao ampamolinged hinoa hao pagtoldo kaniran. ");
INSERT INTO mmn_vpl VALUES ("MK4_12","071_4_12","MRK","4","12","12","Kay mintoman di ya daan pinasoyat na Diyos mahitenged kaniran nga nagalaong nga bisan magaseleng ya mga tao ka kanaong mga inhinang diri siran makasabot. Bisan manalinga siran ka kanaong sindo diri siran makasabot kon ono ya kahologan kay diri siran anbiza ka kanirang mga sala agon diri pasaylohon siran na Diyos. Ani ini ya daan pinasoyat na Diyos. ");
INSERT INTO mmn_vpl VALUES ("MK4_13","071_4_13","MRK","4","13","13","Mindogang si Hisos pagpanaba ka toong mga sakop nga nabereng hao kay wara kamo makasabot ka kanaong pamolinged ka nagasabwag. Agon onhon sa mazo nga makasabot kamo ka kahologan kon ampamolinged hao pag-otro? ");
INSERT INTO mmn_vpl VALUES ("MK4_14","071_4_14","MRK","4","14","14","Na, wani ya paghilwas ka pamolinged ka nagasabwag. Na, ya inpanabwag na tao ani ya mga panaba na Diyos. ");
INSERT INTO mmn_vpl VALUES ("MK4_15","071_4_15","MRK","4","15","15","Kamhan ya mga binhi nga natanak dizan ka dalan ani ya singed ka isang manalingahay. Kay pagpanalinga naiza ka sindo mahitenged kanao mindateng dazon si Satanas kay kaw-en naiza ya sindo nga nabatian naiton nga tao. ");
INSERT INTO mmn_vpl VALUES ("MK4_16","071_4_16","MRK","4","16","16","Kamhan ya mga binhi nga natanak dizan ka kabatohan ani ya singed ka manalingahay nga nakaangay ka sindo mahitenged kanao. Kamhan mintoo iza dazon ");
INSERT INTO mmn_vpl VALUES ("MK4_17","071_4_17","MRK","4","17","17","piro magaawazen gazed iza na mga tao kay minsakop di iza kanao agon bizaan dazon naiza ya toong pagtoo kanao kay ababa ka ya toong pag-anget ka kalised. ");
INSERT INTO mmn_vpl VALUES ("MK4_18","071_4_18","MRK","4","18","18","Kamhan ya mga binhi nga natanak dizan ka lopa nga nanhela pen ya mga liso na sagbet ani ya singed ka isa pen nga manalingahay. ");
INSERT INTO mmn_vpl VALUES ("MK4_19","071_4_19","MRK","4","19","19","Kay nagapanalinga gazed iza ka sindo mahitenged kanao kamhan nawied sab iza daw ono ya toong panginabohi. Ganahan sab iza ka kowarta. Agon waray polos ya sindo kay singed ka nalipat dazon ya manalingahay. ");
INSERT INTO mmn_vpl VALUES ("MK4_20","071_4_20","MRK","4","20","20","Basta kay ya mga binhi nga napegas dizan ka lopa nga magazong tamnanan ani ya singed ka mga manalingahay ka sindo mahitenged kanao kamhan mintoo gazed siran. Kamhan singed ka nangaohay ya isa ka katloan. Nangaohay ya iba ka kan-eman. Nangaohay isab ya iba pen ka isang ka gatos. Ani ini ya paghilwas ni Hisos ka pamolinged ka nagasabwag. ");
INSERT INTO mmn_vpl VALUES ("MK4_21","071_4_21","MRK","4","21","21","Kamhan minpamolinged pen iza kaniran nagalaong nga kon seg-an na tao ya moron diri pagtakloban. Ibetang hinoa daked ka artal kay dazaw pawaan ya mga minseled ka lagkaw. ");
INSERT INTO mmn_vpl VALUES ("MK4_22","071_4_22","MRK","4","22","22","Singed iton ka ipasabot nao kamazo ya mga pamolinged. Impakahagdam sab nao kamazo ya mga intago na Diyos. ");
INSERT INTO mmn_vpl VALUES ("MK4_23","071_4_23","MRK","4","23","23","Kamo nga mga manalingahay, magtaremdem kamo kaini nga sindo nao kamazo. ");
INSERT INTO mmn_vpl VALUES ("MK4_24","071_4_24","MRK","4","24","24","Manalinga gazed kamo dazaw ihatag pen kamazo na Diyos ya kasabtan daw pasobrahan pen ");
INSERT INTO mmn_vpl VALUES ("MK4_25","071_4_25","MRK","4","25","25","kay bisan sin-o ya antoon ka sindo na Diyos padogangan pen na Diyos ya toong kasabtan. Kamhan ya tao nga diri antoon kaw-en na Diyos ya geramay nga inton-an naiza. ");
INSERT INTO mmn_vpl VALUES ("MK4_26","071_4_26","MRK","4","26","26","Na, wani pen ya pamolinged mahitenged ka pagpadazon na Diyos ka toong tarabaho. Na, may isang aldaw nagapanabwag ya tao ka toong mga binhi. Pagkakamhan min-oli di ya tao. ");
INSERT INTO mmn_vpl VALUES ("MK4_27","071_4_27","MRK","4","27","27","Kada kahabzen natorog iza. Kada masiselem ambangon iza. Kamhan ankaro dazon iza ka toong oma kay ansosi iza kon mintobo di ya tanem. Wara mahagdam ya tao kon onhon sa ya pagpatobo ");
INSERT INTO mmn_vpl VALUES ("MK4_28","071_4_28","MRK","4","28","28","kay ya lopa ani ya ingaringan ka tanem. Ka primiro pen waton ya tobo. Sonod ya lawas. Sonod isab ya bagaybay. Mahori ya poso. ");
INSERT INTO mmn_vpl VALUES ("MK4_29","071_4_29","MRK","4","29","29","Pagkalahing di na poso sanggien na tao kay mindateng di ya tirmino na mais ka pagsanggi. ");
INSERT INTO mmn_vpl VALUES ("MK4_30","071_4_30","MRK","4","30","30","Mindogang si Hisos paglaong kaniran nga wani pen ya pamolinged mahitenged ka pagpaoswag na Diyos ka toong paghari dini ka mga tao. ");
INSERT INTO mmn_vpl VALUES ("MK4_31","071_4_31","MRK","4","31","31","Singed iton ka isang bolos nga liso inngaranan ka mostasa. ");
INSERT INTO mmn_vpl VALUES ("MK4_32","071_4_32","MRK","4","32","32","Kamhan intanem na tao dizan ka toong oma. Bisan geramay iton ka bisan ono nga liso, ka pagsolig di mahinang iton ka dakolang liwaan nga may dakolang sap-ay. Kay doro ka lopa nga Yoda ya mostasa liwaan iton nga opat nga ka mitros ya kaataas. Kamhan dizan ka katamdenganan na mga sap-ay magapogad ya mga manokmanok. ");
INSERT INTO mmn_vpl VALUES ("MK4_33","071_4_33","MRK","4","33","33","Pagsindo pen ni Hisos ka mga tao mataed pen ya mga pamolinged singed kaiton. ");
INSERT INTO mmn_vpl VALUES ("MK4_34","071_4_34","MRK","4","34","34","Waray lain toldoan naiza kaniran piro dizan ka toong mga sakop inpasabot naiza ya tanan mga pamolinged naiza. ");
INSERT INTO mmn_vpl VALUES ("MK4_35","071_4_35","MRK","4","35","35","Pagkadelem kaiza minlaong si Hisos ka toong mga sinarigan nga ansakay kita dipi ka danaw. ");
INSERT INTO mmn_vpl VALUES ("MK4_36","071_4_36","MRK","4","36","36","Kamhan inbilin niran ya mga tao dizan ka baybazen kay in-ated si Hisos pagsakay ka baloto. Iba gihapon ya iba nga mga baloto. ");
INSERT INTO mmn_vpl VALUES ("MK4_37","071_4_37","MRK","4","37","37","Ka dizan pen siran ka tenga na danaw inbagzo gazed siran. Insapwan dazon na baled ya baloto daw malened kontana ");
INSERT INTO mmn_vpl VALUES ("MK4_38","071_4_38","MRK","4","38","38","piro natorog si Hisos dizan ka olin na baloto. Kamhan minsinggit ya toong mga sakop pagpokaw kanangiza nagalaong mga Maistro, daw waray kawied mo nga mangalened kita? ");
INSERT INTO mmn_vpl VALUES ("MK4_39","071_4_39","MRK","4","39","39","Min-imata dazon si Hisos. Inbaheg naiza ya hangin daw ya mga baled nagalaong nga magpahenek! Minheneng dazon ya hangin daw nalinaw matood ya tanan. ");
INSERT INTO mmn_vpl VALUES ("MK4_40","071_4_40","MRK","4","40","40","Kamhan minlaong si Hisos ka toong mga sakop nga kay ono sa magakahaldek sa kamo? Daw waray pagsarig mazo kanao? ");
INSERT INTO mmn_vpl VALUES ("MK4_41","071_4_41","MRK","4","41","41","Kamhan nabereng gazed siran. Namaglaonglaong siran nga daw sin-o sa baza ini nga taohana? Kay bisan ya hangin daw ya mga baled antoo gazed ka toong pagbaheg! ");
INSERT INTO mmn_vpl VALUES ("MK5_1","071_5_1","MRK","5","1","1","Pagkakamhan ni Hisos pagpaheneng ka bagzo minsangpet di siran ka lopa nga Girgasa dipi ka danaw. ");
INSERT INTO mmn_vpl VALUES ("MK5_2","071_5_2","MRK","5","2","2","Pagkawas ka ni Hisos ka baloto may tao nga inhoropan gazed ka maonga nga minsogat kanangiza. Garing iza ka mga lebeng nga talangban ");
INSERT INTO mmn_vpl VALUES ("MK5_3","071_5_3","MRK","5","3","3","kay ani ya toong hel-anan. Diri di iza madaeg pagtagen. Bisan mga kadina pen diri di maektan. ");
INSERT INTO mmn_vpl VALUES ("MK5_4","071_5_4","MRK","5","4","4","Kapira iza maekti kontana piro nakabogto iza ka lepes daw kadina. Bisan kesgan nga tao diri di gazed makadaeg pagtagen. ");
INSERT INTO mmn_vpl VALUES ("MK5_5","071_5_5","MRK","5","5","5","Aldaw daw kahabzen dizan iza ka mga lebeng daw mga bobong magasininggit daw magapan-olatan naiza ka bato ya toong lawas. ");
INSERT INTO mmn_vpl VALUES ("MK5_6","071_5_6","MRK","5","6","6","Na, pagpakakita naiza kan Hisos nga aro pen mindalagan iza pagsogat. Kamhan minpatilohod dazon iza dizan ka paahan ni Hisos. ");
INSERT INTO mmn_vpl VALUES ("MK5_7","071_5_7","MRK","5","7","7","Kamhan minsinggit iza nga Hisos nga Maanak na Diyos, kay ono say inkarini mo? Anhangzo gazed hao nga diri mo gazed hao daegdaegen! ");
INSERT INTO mmn_vpl VALUES ("MK5_8","071_5_8","MRK","5","8","8","Ani ini ya inlaong na maonga nga minhari ka hinawa na tao kay si Hisos minsogo nga domalagan ko dizan ka tao. ");
INSERT INTO mmn_vpl VALUES ("MK5_9","071_5_9","MRK","5","9","9","Kamhan nangotana si Hisos ka maonga daw ono ya ngaran mo? Minsambag iza nga hao si Kataedan kay mataed kami. ");
INSERT INTO mmn_vpl VALUES ("MK5_10","071_5_10","MRK","5","10","10","Anhangzo hao kanmo, Hisos, kon malooy ko kanami diri mo kami pagbogawen ngaro ka aro nga dapit. ");
INSERT INTO mmn_vpl VALUES ("MK5_11","071_5_11","MRK","5","11","11","Na, dizan ka kilid na bobong nagapansongad ya mga kababozan. ");
INSERT INTO mmn_vpl VALUES ("MK5_12","071_5_12","MRK","5","12","12","Kamhan minhangzo ya mga maonga kan Hisos nga kon malooy ko kanami papanawen mo kami ngaro ka mga baboy. Pahel-en mo kami ka kanirang mga lawas. ");
INSERT INTO mmn_vpl VALUES ("MK5_13","071_5_13","MRK","5","13","13","Kamhan intogotan siran ni Hisos. Kamhan minpanaw ya mga maonga dizan ka lawas na tao. Minhari siran ka mga baboy. Daw pirang bolos ya baboy? Dowang ka libo sirang tanan. Kamhan minpahidalagan siran tanan ngaro ka may pangpang nga ataas. Minpatiholog siran ngambaba ka danaw kamhan natibe siran pagkalemes. ");
INSERT INTO mmn_vpl VALUES ("MK5_14","071_5_14","MRK","5","14","14","Kamhan nandalagan gazed ya mga magbantazay ka baboy ngaro ka kanirang longsod daw ya mga bariyo kay ampanan-og ka mga tao kon in-ono sa ni Hisos ya tao nga inhoropan ka mga maonga. Kamhan minkarini dazon kan Hisos ya mga tao kay gosto siran anseleng ka tao kon in-ono sa iza. ");
INSERT INTO mmn_vpl VALUES ("MK5_15","071_5_15","MRK","5","15","15","Pagdateng niran kan Hisos nakitan niran ya tao nga indazaw ni Hisos. Iza nga inhoropan na mga mataed nga maonga nagalo-to di dizan daw inbadoan kay naolian ka madazaw nga beet. Kamhan nahaldek ya mga mindateng. ");
INSERT INTO mmn_vpl VALUES ("MK5_16","071_5_16","MRK","5","16","16","Kamhan ya mga minkita ka inhinang ni Hisos kazina, siran ya minpanan-og ka mga bag-ong mindateng nga indazaw ni Hisos ya tao nga inhoropan na maonga. Kamhan inpadalagan disab ya mga baboy. ");
INSERT INTO mmn_vpl VALUES ("MK5_17","071_5_17","MRK","5","17","17","Kamhan minhangzo siran kan Hisos dazaw ampanaw iza dini ka kanirang lopa. ");
INSERT INTO mmn_vpl VALUES ("MK5_18","071_5_18","MRK","5","18","18","Pagleen ni Hisos ka baloto ya tao nga indazaw naiza minhangzo iza nga an-iba ");
INSERT INTO mmn_vpl VALUES ("MK5_19","071_5_19","MRK","5","19","19","piro diri iza paibahen ni Hisos. Mintogon iza ka tao nga om-oli ko ka mga lomon mo. Maglaong ko kaniran nga madazaw di ya lawas mo kay inkaloy-an ko na Ginoo. ");
INSERT INTO mmn_vpl VALUES ("MK5_20","071_5_20","MRK","5","20","20","Minpanaw dazon ya tao doro ka longsod nga Dikapolis. Minpanan-og iza kon in-ono sa iza ni Hisos. Kamhan nabereng gazed ya mga tao. ");
INSERT INTO mmn_vpl VALUES ("MK5_21","071_5_21","MRK","5","21","21","Pagkakamhan kaiza minsakay si Hisos ka baloto pag-oli ngandipi ka danaw. Pagdateng naiza ka baybazen inlibotan gazed iza na mataed nga mga tao dizan ka baybazen na danaw. ");
INSERT INTO mmn_vpl VALUES ("MK5_22","071_5_22","MRK","5","22","22","Kamhan may isang oloolo ka singbahan na mga Yodayo nga minkarini kan Hisos. Si Hariyo ya ngaran. Pagpakakita naiza kan Hisos minlohod dazon iza ");
INSERT INTO mmn_vpl VALUES ("MK5_23","071_5_23","MRK","5","23","23","daw minpakilooy gazed nga nagalaong nga nagapinal di ya kanaong maanak nga daragahay. Kon mahimo ya beet mo ibahan mo hao ngaro ka kanaong lagkaw dazaw mabohi iza kon tagenan di mo ya toong lawas. ");
INSERT INTO mmn_vpl VALUES ("MK5_24","071_5_24","MRK","5","24","24","Kamhan min-iba si Hisos kan Hariyo. Nangiba disab ya masarang kataed nga mga tao. Minlibot siran kan Hisos pag-iba ngaro ka lagkaw ni Hariyo. ");
INSERT INTO mmn_vpl VALUES ("MK5_25","071_5_25","MRK","5","25","25","Na, may nagalopog kan Hisos nga babazi nga sokad ka napolo may dowang ka toig wara magheneng ya toong pagdog-a. ");
INSERT INTO mmn_vpl VALUES ("MK5_26","071_5_26","MRK","5","26","26","Bisan nahorot ya toong kowarta dizan ka mga mataed nga doktor nadoblihan hinoa ya toong masakit. ");
INSERT INTO mmn_vpl VALUES ("MK5_27","071_5_27","MRK","5","27","27","Kamhan nakabati iza nga indazaw ni Hisos ya mga nabedlay. Agon min-iba iza ka mga tao pagsonod niran kan Hisos kay gosto iza antoldok ka bado ni Hisos. ");
INSERT INTO mmn_vpl VALUES ("MK5_28","071_5_28","MRK","5","28","28","Nagalaong iza ka toong hena-hena nga bisan anikay intoldokan nao ya toong bado maolian gazed ya kanaong lawas. ");
INSERT INTO mmn_vpl VALUES ("MK5_29","071_5_29","MRK","5","29","29","Na, pagtoldok naiza ka bado ni Hisos madazaw di matood ya toong lawas. ");
INSERT INTO mmn_vpl VALUES ("MK5_30","071_5_30","MRK","5","30","30","Kamhan si Hisos minheneng pagpanaw kay inbati naiza nga mintambal di iza ka tao. Kamhan minhinali si Hisos pagliso. Nangotana iza kaniran nga sin-o say mintoldok ka kanaong bado? ");
INSERT INTO mmn_vpl VALUES ("MK5_31","071_5_31","MRK","5","31","31","Minsambag ya toong mga sakop nga Hisos, mataed gazed ya minlibot pagheet kanmo. Kay ono pen nga anpangotana ko nga sin-o say mintoldok kanmo? ");
INSERT INTO mmn_vpl VALUES ("MK5_32","071_5_32","MRK","5","32","32","Kamhan minseleng si Hisos ka mga tao kay gosto ankilala kon sin-o ya mintoldok kanangiza kazina. ");
INSERT INTO mmn_vpl VALUES ("MK5_33","071_5_33","MRK","5","33","33","Kamhan minkarini ya babazi kay mahagdam nga iza gazed ya inbahaw ni Hisos. Paglohod naiza dizan ka paahan ni Hisos nagapidpid ya toong lawas ka kahaldek. Kamhan minlaong iza kan Hisos nga hao gazed ya mintoldok ka kanmong bado kazina. ");
INSERT INTO mmn_vpl VALUES ("MK5_34","071_5_34","MRK","5","34","34","Minsambag si Hisos nga Day, basta ya pagsarig mo kanao madazaw di ya lawas mo. Om-oli ko naa. Diri ko magkawied kay diri ambalik ya kasakit mo. ");
INSERT INTO mmn_vpl VALUES ("MK5_35","071_5_35","MRK","5","35","35","Pagkakamhan kaiza min-apas ya mga tao garing ka lagkaw ni Hariyo nga oloolo ka singbahan na mga Yodayo. Minlaong siran nga Hariyo, abay ko pagpaiba kan Hisos ngaro ka lagkaw mo kay wara di ya maanak mo. ");
INSERT INTO mmn_vpl VALUES ("MK5_36","071_5_36","MRK","5","36","36","Kamhan minlaong si Hisos nga Hariyo, diri ko magkawied. Magsarig ko naa kanao. ");
INSERT INTO mmn_vpl VALUES ("MK5_37","071_5_37","MRK","5","37","37","Kamhan diri ni Hisos itogot ya mga tao pag-iba ngaro ka lagkaw naini nga oloolo nga napatzan. In-iba di lamang naiza si Pidro daw si Santiago daw ya manghod ni Santiago nga si Howan. ");
INSERT INTO mmn_vpl VALUES ("MK5_38","071_5_38","MRK","5","38","38","Pagdateng niran nakita naiza ya mga tao nga masamok gazed ka paghaza. ");
INSERT INTO mmn_vpl VALUES ("MK5_39","071_5_39","MRK","5","39","39","Pagseled ni Hisos ka lagkaw nangotana iza kaniran kay ono say inhaza mazo? Diri kon patay ya bata. Igo ka lamang iza matorog. ");
INSERT INTO mmn_vpl VALUES ("MK5_40","071_5_40","MRK","5","40","40","Kamhan inkatawhan niran si Hisos. Pagpalogwa naiza kaniran in-ated naiza ya ginikanan dalem ka kowarto nga inbentagan na babazi. In-iba sab ya toong mga sakop nga tolo ka siran. ");
INSERT INTO mmn_vpl VALUES ("MK5_41","071_5_41","MRK","5","41","41","Kamhan intagenan ni Hisos ya alima na babazi daw minsogo nga Day, bomangon ko naa. ");
INSERT INTO mmn_vpl VALUES ("MK5_42","071_5_42","MRK","5","42","42","Minbangon dazon iza nga daragahay daw minpanawpanaw. Agon dakola gazed ya pagkabereng niran. ");
INSERT INTO mmn_vpl VALUES ("MK5_43","071_5_43","MRK","5","43","43","Kamhan minsogo si Hisos kaniran nga pakanen naa ya babazi. Kamhan diri kamo magpanan-og dizan ka mga tao nga indazaw di nao iza. Ani ini ya pagtabang ni Hisos ka maanak ni Hariyo. ");
INSERT INTO mmn_vpl VALUES ("MK6_1","071_6_1","MRK","6","1","1","Pagkakamhan kaiza minpanaw si Hisos kay an-oli di iza ka Nazarit nga toong insoligan. Iba gihapon ya toong mga sakop. ");
INSERT INTO mmn_vpl VALUES ("MK6_2","071_6_2","MRK","6","2","2","Na, pagkaSabado nga tigpahimlay na mga Yodayo minsogod si Hisos pagsindo ka mga taga Nazarit dalem ka kanirang singbahan. Kamhan nangabereng ya mga mataed nga manalingahay daw nagalaong siran nga wara kami mahagdam kon hain iza magtoon ka kahagdamanan daw onhon sa naiza paghinang ka mga madazaw nga kaberenganan ");
INSERT INTO mmn_vpl VALUES ("MK6_3","071_6_3","MRK","6","3","3","kay panday ka lamang iza. Maanak iza ni Mariya. Maglomon iza daw si Santiago daw si Hosi daw si Hodas daw si Simon. Taga dini disab kanta ya toong mga lomon nga babazi. Ani ini ya kanirang inlaong kamhan diri gazed siran antoo ka toong sindo kaniran. ");
INSERT INTO mmn_vpl VALUES ("MK6_4","071_6_4","MRK","6","4","4","Kamhan minlaong si Hisos kaniran nga doro ka mga lain dapit intahod hao na mga tao piro dini kamazo nga kanaong kaibahan waray pagtahod. Bisan ya mga karaang propita na Diyos wara siran tahoda na kanirang kaibahan. ");
INSERT INTO mmn_vpl VALUES ("MK6_5","071_6_5","MRK","6","5","5","Kamhan dizan ka toong kaibahan diri makahimo si Hisos paghinang ka bisan ono ya dakolang hinang. Ya mga talagsang nabedlay anikay indazaw naiza. ");
INSERT INTO mmn_vpl VALUES ("MK6_6","071_6_6","MRK","6","6","6","Nabereng gazed si Hisos kay diri siran antoo nga may gahem naiza ka paghinang ka dakolang kaberenganan. Kamhan doro ka mga bariyo libot ka Nazarit nagapasiyo si Hisos kay ansindo iza ka mga tao. ");
INSERT INTO mmn_vpl VALUES ("MK6_7","071_6_7","MRK","6","7","7","Pagkakamhan kaiza inpatipon naiza ya toong mga sinarigan nga napolo may dowang ka tao siran. Kamhan impakaro naiza ya tinagdowa ngaro ka mga lain dapit. Na, ka wara pen siran panaw intagan siran ka gahem dazaw palogwaen niran ya mga maonga nga magahari ka hinawa na mga tao. ");
INSERT INTO mmn_vpl VALUES ("MK6_8","071_6_8","MRK","6","8","8","Intogon sab siran nagalaong nga sogkod ka lamang ya kamazong dara, waray lain harominta. Diri kamo maghabay ka kowarta. ");
INSERT INTO mmn_vpl VALUES ("MK6_9","071_6_9","MRK","6","9","9","Diri sab kamo maglapid ka bado piro mahimo pagsinilas. ");
INSERT INTO mmn_vpl VALUES ("MK6_10","071_6_10","MRK","6","10","10","Dizan ka lagkaw nga inpanikan mazo maghela gazed kamo hastang ka pagpanaw mazo. ");
INSERT INTO mmn_vpl VALUES ("MK6_11","071_6_11","MRK","6","11","11","Dizan ka bariyo nga diri an-abiabi kamazo izabzab mazo ya abog dizan ka paa mazo dazaw mahagdam siran nga silotan siran kay-an kay diri siran an-angay ka sindo na Diyos ka pagpanalinga. ");
INSERT INTO mmn_vpl VALUES ("MK6_12","071_6_12","MRK","6","12","12","Pagkakamhan ni Hisos pagtogon kaniran minpanaw siran kay anwali siran ka mga tao nagalaong nga bizaan mazo ya mga sala mazo. ");
INSERT INTO mmn_vpl VALUES ("MK6_13","071_6_13","MRK","6","13","13","Kamhan impalogwa sab niran ya mga mataed nga maonga nga magahari ka hinawa na mga tao. Inbo-boan sab niran ya olo na mga nabedlay ka lana. Kamhan madazaw matood ya lawas na mga nabedlay. ");
INSERT INTO mmn_vpl VALUES ("MK6_14","071_6_14","MRK","6","14","14","Na, ka nagapasinged pen ya mga sakop ni Hisos doro ka mga lain dapit nabatian ni Hirodis nga hari kon ono ya hinang niran kay mindakola di ya ngaran ni Hisos. Kamhan nagatekma ya mga tao kon sin-o sa si Hisos. May nagalaong nga si Hisos ani si Howan nga Magbenzagay. Nabohi iza pagbalik garing ka lebeng agon may gahem naiza ka paghinang ka mga madazaw. ");
INSERT INTO mmn_vpl VALUES ("MK6_15","071_6_15","MRK","6","15","15","May mga iba nga tao nga nagalaong nga si Hisos ani si Iliyas nga karaang propita na Diyos. May mga iba pen nga tao nga nagalaong nga si Hisos propita iza singed ka isa pen nga karaang propita. ");
INSERT INTO mmn_vpl VALUES ("MK6_16","071_6_16","MRK","6","16","16","Piro si Hirodis pagpakabati naiza ka kanirang tekma nagalaong iza nga si Hisos ani gazed si Howan nga Magbenzagay nga inpaotdan nao ka lieg. Nabohi di iza baza garing ka lebeng. ");
INSERT INTO mmn_vpl VALUES ("MK6_17","071_6_17","MRK","6","17","17","Ani ini ya kawied ni Hirodis kay izang dini kaini impadakep naiza si Howan. Kamhan impagapos ngandalem ka prisohan. Ani ini ya toong hinang kay imbahegan iza ni Howan kay minpanapaw si Hirodis kan Hirodiyas nga toong ipag nga asawa na toong lomon nga si Pilipo. ");
INSERT INTO mmn_vpl VALUES ("MK6_18","071_6_18","MRK","6","18","18","Kamhan inbahegan iza ni Howan nagalaong nga silotan ko gazed na Diyos kay naminze di ko ka kanmong ipag. ");
INSERT INTO mmn_vpl VALUES ("MK6_19","071_6_19","MRK","6","19","19","Kamhan malain gazed ya hinawa ni Hirodiyas kan Howan daw patazen kontana. ");
INSERT INTO mmn_vpl VALUES ("MK6_20","071_6_20","MRK","6","20","20","Piro diri ansogot si Hirodis kay antahod iza kan Howan kay beetan si Howan, waray sala naiza. Agon tabangan kontana ni Hirodis si Howan daw anpanalinga ka toong inwali piro nagakalibeg gazed si Hirodis kada pagpanalinga. ");
INSERT INTO mmn_vpl VALUES ("MK6_21","071_6_21","MRK","6","21","21","Na, pagdateng na aldaw ka pagkombiti nga impahinenged ka pagkatao ni Hirodis may logar ni Hirodiyas ka pagpapatay kan Howan. Na, nagapakaen si Hirodis ka toong mga magtimbangay daw ya mga kapitan ka soldaw daw ya mga dakolang tao dizan ka lopa nga Galiliya. ");
INSERT INTO mmn_vpl VALUES ("MK6_22","071_6_22","MRK","6","22","22","Pagpangaen pen niran minsazaw ya daraga nga maanak ni Hirodiyas. Kamhan nagasaza si Hirodis daw ya toong mga bisita ka pagsazaw na babazi. Kamhan minlaong si Hirodis ka babazi nga bisan ono ya azoon mo kanao ihatag gazed nao kanmo. ");
INSERT INTO mmn_vpl VALUES ("MK6_23","071_6_23","MRK","6","23","23","Mapatay gazed hao kon baribadan ta ko ka azoon mo kanao. Bisan ya tenga na kanaong kowarta ihatag gazed. ");
INSERT INTO mmn_vpl VALUES ("MK6_24","071_6_24","MRK","6","24","24","Kamhan minlogwa dazon ya babazi kay ansabot ka toong ina nga daw ono ya azoon naiza kan Hirodis. Minsambag dazon ya ina nga ya olo ni Howan ani ya azoon mo! ");
INSERT INTO mmn_vpl VALUES ("MK6_25","071_6_25","MRK","6","25","25","Minbalik dazon ya babazi kan Hirodis daw minlaong nga tagan mo hao ka olo ni Howan nga Magbenzagay. Ibetang mo iton dini ka palato. ");
INSERT INTO mmn_vpl VALUES ("MK6_26","071_6_26","MRK","6","26","26","Pagpakabati ni Hirodis ka in-azo na babazi mabeg-at gazed ya toong hinawa ka pagkawied. Piro masipeg iza ka pagbaribad ka babazi kay kazina dizan ka mga bisita minsaad gazed iza ka babazi. ");
INSERT INTO mmn_vpl VALUES ("MK6_27","071_6_27","MRK","6","27","27","Agon minsogo dazon iza ka soldaw nagalaong nga dadhen mo ngarini kanao ya olo ni Howan. Minlogwa dazon ya soldaw. Kamhan dizan ka prisohan in-otod dazon ya lieg ni Howan. ");
INSERT INTO mmn_vpl VALUES ("MK6_28","071_6_28","MRK","6","28","28","Kamhan imbetang iton dizan ka palato. Kamhan indara ngaro ka babazi. Kamhan inhatag sab na babazi ka toong ina ya olo ni Howan. ");
INSERT INTO mmn_vpl VALUES ("MK6_29","071_6_29","MRK","6","29","29","Pagpakabati na mga sakop ni Howan minkaro siran ka prisohan kay kaw-en niran ya lawas ni Howan. Kamhan inlebeng iton. Ani ini ya pagkapatay ni Howan agon pagpakabati ni Hirodis ka mga hinang ni Hisos nawied gazed iza kay silaong naiza nga si Hisos ani si Howan nga Magbenzagay nga nabohi garing ka lebeng. ");
INSERT INTO mmn_vpl VALUES ("MK6_30","071_6_30","MRK","6","30","30","Na, ya mga sinarigan ni Hisos nga mga inpili naiza ka pagwali ngaro ka mga tao min-oli di siran. Kamhan inpanan-ogan niran si Hisos kon ono ya hinang niran. ");
INSERT INTO mmn_vpl VALUES ("MK6_31","071_6_31","MRK","6","31","31","Kamhan minlaong si Hisos nga ibahan mazo hao ngaro ka mamingaw kay magpaheway kamo kay mataed ya mga tao dini. Waray logar mazo ka pagkaen. ");
INSERT INTO mmn_vpl VALUES ("MK6_32","071_6_32","MRK","6","32","32","Kamhan minsakay siran ka baloto ngaro ka dapit nga mamingaw. ");
INSERT INTO mmn_vpl VALUES ("MK6_33","071_6_33","MRK","6","33","33","Kamhan dizan ka inpanawan niran mataed ya mga minkita kanin Hisos pagsakay niran ka baloto. Kamhan garing ka tanan mga bariyo nanlopog ya mga tao pagbagtas dizan ka baybazen dazaw andateng paghon-a kanin Hisos. ");
INSERT INTO mmn_vpl VALUES ("MK6_34","071_6_34","MRK","6","34","34","Pagkawas ka ni Hisos ka baloto ngandipi nakitan naiza ya masarang kataed nga tao. Kamhan nalooy gazed si Hisos kaniran kay singed siran ka mga karniro nga nangalaag kay waray nagaaligara kaniran. Kamhan minsogod iza pagtoldo kaniran ka mga mataed nga sindo. ");
INSERT INTO mmn_vpl VALUES ("MK6_35","071_6_35","MRK","6","35","35","Pagkadelem kaiza minkarini kan Hisos ya toong mga sinarigan kay anlaong siran nga delem di wani. Aro pen kita ka kantang panihaponanan. ");
INSERT INTO mmn_vpl VALUES ("MK6_36","071_6_36","MRK","6","36","36","Papanawen mo naa ya mga tao ngaro ka mga bariyobariyo dazaw makapamalit siran ka pagkaen niran. ");
INSERT INTO mmn_vpl VALUES ("MK6_37","071_6_37","MRK","6","37","37","Minsambag si Hisos nga magpakaen hinoa kamo kaniran. Minsambag siran nga daw ono ya ikapamalit nami kay mahal gazed ya pan singed ka sohol ka enem nga ka bolan kay mataed gazed ya mga tao. ");
INSERT INTO mmn_vpl VALUES ("MK6_38","071_6_38","MRK","6","38","38","Kamhan nangotana si Hisos nga daw pirang bolos ya pan mazo? Mangita kamo. Pagpakakita niran minlaong siran nga lima komang bolos ya pan kamhan dowa komang bolos ya isda. ");
INSERT INTO mmn_vpl VALUES ("MK6_39","071_6_39","MRK","6","39","40","Kamhan intipon ni Hisos ya mga tao pagpalo-to dizan ka lopa. Ya kada tipon may magtinaggatos, may magtinagkalim-an. ");
INSERT INTO mmn_vpl VALUES ("MK6_41","071_6_41","MRK","6","41","41","Paghawid ni Hisos ka mga pan nga limang bolos daw ya isda dowang bolos minhangad iza ka langit. Kamhan minpasalamat iza ka Diyos. Kamhan intipaktipak naiza ya mga pan anipen naiza ipanhatag ka toong mga sinarigan. Kamhan inpandohol niran ka mga tao. Kamhan dizan kanirang tanan inbahinbahin naiza ya dowang bolos nga isda. ");
INSERT INTO mmn_vpl VALUES ("MK6_42","071_6_42","MRK","6","42","42","Pagkakamhan niran pagkaen nangabosog sirang tanan. ");
INSERT INTO mmn_vpl VALUES ("MK6_43","071_6_43","MRK","6","43","43","Pagpakahipid niran ka salin nga tinipak nga pan daw isda nangapono pen ya napolo may dowang ka alat. ");
INSERT INTO mmn_vpl VALUES ("MK6_44","071_6_44","MRK","6","44","44","Daw pirang bolos ya tao nga impakaen ni Hisos? Ya amaama limang ka libo. Wara pen ya labet na mga babazi daw mga bata. ");
INSERT INTO mmn_vpl VALUES ("MK6_45","071_6_45","MRK","6","45","45","Pagkakamhan kaiza impasakay ni Hisos ka baloto ya toong mga kasakopan dazaw anhon-a siran kanangiza dipi ka bariyo nga Bitsayda kay paolien pen naiza ya mga mataed nga tao. ");
INSERT INTO mmn_vpl VALUES ("MK6_46","071_6_46","MRK","6","46","46","Kamhan waray iba naiza pagtokad naiza ngandaked ka pagkahiping na bobong kay ampangamozo iza ka Diyos. ");
INSERT INTO mmn_vpl VALUES ("MK6_47","071_6_47","MRK","6","47","47","Na, pagkakahabzen ka ya sakzanan na toong mga sakop waro pen iton ka tenga na danaw. Doro ka bobong isa koman si Hisos. ");
INSERT INTO mmn_vpl VALUES ("MK6_48","071_6_48","MRK","6","48","48","Kamhan nakakita iza kaniran nga magalised siran pagbogsay kay nasogatan niran ya makeseg nga hangin. Pagkakamaaldawen kaiza minpanaw si Hisos dizan ka hopaw na sapa ngaro arani ka kanirang sakzanan. Anlabay iza kaniran kontana ");
INSERT INTO mmn_vpl VALUES ("MK6_49","071_6_49","MRK","6","49","50","piro pagpakakita niran nga waton ya minpanaw dizan ka hopaw na sapa nangahaldek gazed siran daw minsinggit nga pooy sa wani! Piro minlaong si Hisos nga diri kamo magkawied kay hao ini. Diri kamo magkahaldek. ");
INSERT INTO mmn_vpl VALUES ("MK6_51","071_6_51","MRK","6","51","51","Pagleen ni Hisos ka baloto iba kaniran minheneng dazon ya hangin. Kamhan nabereng gazed ya toong mga sakop ");
INSERT INTO mmn_vpl VALUES ("MK6_52","071_6_52","MRK","6","52","52","kay bisan minkita siran kazina ka pagpakaen ni Hisos ka mga mataed nga tao diri pen siran makasabot nga iza gazed ya Maanak na Diyos. ");
INSERT INTO mmn_vpl VALUES ("MK6_53","071_6_53","MRK","6","53","53","Pagkakamhan kaiza doro ka lopa nga Ganasarit mindonggo siran daw in-ektan ya baloto. ");
INSERT INTO mmn_vpl VALUES ("MK6_54","071_6_54","MRK","6","54","54","Pagkawas niran ka baloto mataed ya minkilala nga si Hisos ini. ");
INSERT INTO mmn_vpl VALUES ("MK6_55","071_6_55","MRK","6","55","55","Agon mindalagan siran pag-oli ka kanirang bariyo kay ansogo siran ka paglahong ka mga nabedlay ngaro ka bisan hain azi si Hisos. ");
INSERT INTO mmn_vpl VALUES ("MK6_56","071_6_56","MRK","6","56","56","Kamhan dizan ka taboan na bisan ono ya bariyo daw longsod nga indatngan ni Hisos inpabentag niran ya mga nabedlay. Kamhan minhangzo siran kan Hisos nagalaong nga Hisos, pahogamen mo lamang siran ka pilos na kanmong bado. Kamhan ya tanan nakahogam ka pilos na toong bado nangabahaw dazon siran ka kanirang mga masakit. ");
INSERT INTO mmn_vpl VALUES ("MK7_1","071_7_1","MRK","7","1","1","May isang aldaw nga dizan kan Hisos mintipon ya mga Parasiyo. Dizan isab ya mga maistro nga Yodayo nga garing ka Hirosalem. ");
INSERT INTO mmn_vpl VALUES ("MK7_2","071_7_2","MRK","7","2","2","Kamhan minpaniid siran ka mga sakop ni Hisos kay minlapas siran ka balaed nga garing ka mga karaang Yodayo nga nagalaong nga ka wara pen magkaen ya tao kinahanglan hogasan ya alima. ");
INSERT INTO mmn_vpl VALUES ("MK7_3","071_7_3","MRK","7","3","3","Kamhan bisan sin-o nga Yodayo labi di gazed ya mga Parasiyo antoman gazed siran ka mga balaed na kanirang karaan. ");
INSERT INTO mmn_vpl VALUES ("MK7_4","071_7_4","MRK","7","4","4","Simpan pag-oli niran garing ka taboan kinahanglan bo-boan ka sapa ya kanirang lawas anipen siran makakaen ka pinalit niran. Diri sab siran angamit ka mga imnanan daw tadzaw daw mga bronsi nga betangan ka wara pen bo-boi ka sapa kay balaed iton na kanirang mga karaan. ");
INSERT INTO mmn_vpl VALUES ("MK7_5","071_7_5","MRK","7","5","5","Kamhan siran nga mga Parasiyo daw ya mga maistro nga Yodayo nangotana siran kan Hisos nga kay ono sa ya mga sakop mo minlapas gazed siran ka balaed nga garing ka kantang mga karaan nga nagalaong nga ka wara pen magkaen ya tao kinahanglan anhogas iza ka toong alima. ");
INSERT INTO mmn_vpl VALUES ("MK7_6","071_7_6","MRK","7","6","6","Minsambag si Hisos nga mga bakaken kamo kay hopaw ka lamang ya kamazong paghogas kay wara kamo kahingloi ka kamazong mga sala. Insakto gazed ya panan-og ni Isayas mahitenged kamazo nga nagalaong nga dizan ka ba-ba ka lamang ya kamazong pagtoo kanao nga Diyos kay ya kamazong hena-hena aro ka gazed kanao. ");
INSERT INTO mmn_vpl VALUES ("MK7_7","071_7_7","MRK","7","7","7","Wara gazed ya polos ka pagsingba mazo kanao kay nagalaong kamo nga ya pagpanoldo mazo ani ya mga sogo na Diyos ambaza kay mga pakahagdam iton garing ka mga tao ka lamang. Ani ini ya panan-og ni Isayas mahitenged kamazo. ");
INSERT INTO mmn_vpl VALUES ("MK7_8","071_7_8","MRK","7","8","8","Kamhan mindogang si Hisos pagbaheg kaniran nagalaong nga sazep mazo iton kay kamo hinoa ya magalapas ka mga sogo na Diyos dazaw anhawid kamo ka mga balaed nga garing ka mga karaan. ");
INSERT INTO mmn_vpl VALUES ("MK7_9","071_7_9","MRK","7","9","9","Hanas gazed kamo pagdomiri ka mga sogo na Diyos dazaw ampadazon kamo ka kamazong mga sogo. ");
INSERT INTO mmn_vpl VALUES ("MK7_10","071_7_10","MRK","7","10","10","Garing ka Diyos minsogo si Moysis nga karaang oloolo nga tahodon mazo gazed ya kamazong ginikanan. Bisan sin-o ya ampanaba ka maonga mahitenged ka toong kamalas-an magapatazen gazed itong tao. Ani ini ya sogo na Diyos. ");
INSERT INTO mmn_vpl VALUES ("MK7_11","071_7_11","MRK","7","11","11","Kamhan kamo nga mga Parasiyo nagalaong kamo ka ginikanan mazo nga ya itabang nao kamazo waro di nao lamang ihatag ka Diyos. ");
INSERT INTO mmn_vpl VALUES ("MK7_12","071_7_12","MRK","7","12","12","Singed ka diri togotan mazo pagtabang ka ginikanan. ");
INSERT INTO mmn_vpl VALUES ("MK7_13","071_7_13","MRK","7","13","13","Agon nagapakawaray polos gazed kamo ka sogo na Diyos dazaw makapadazon kamo ka kamazong sogo. Mataed pen ya kamazong inhinang singed kaiton. ");
INSERT INTO mmn_vpl VALUES ("MK7_14","071_7_14","MRK","7","14","14","Pagkakamhan ni Hisos pagbaheg ka mga Parasiyo inpakarini naiza ya mga tao kay nagalaong nga kamong tanan, manalinga gazed kamo kay dazaw masabtan mazo nga ");
INSERT INTO mmn_vpl VALUES ("MK7_15","071_7_15","MRK","7","15","15","bisan ono ya inkaen na tao diri gazed iton kon maonga ka tao. Basta kay ya mga panaba nga anlogwa ka ba-ba na tao ani gazed ya maonga ka tao. ");
INSERT INTO mmn_vpl VALUES ("MK7_16","071_7_16","MRK","7","16","16","Kamo nga mga manalingahay, magtimaan gazed kamo ka sindo nao kamazo. ");
INSERT INTO mmn_vpl VALUES ("MK7_17","071_7_17","MRK","7","17","17","Pagkakamhan kaiza minseled dazon si Hisos ka lagkaw. Kamhan wara dizan ya mga tao agon nangotana ya toong mga sakop mahitenged kaini nga pamolinged. ");
INSERT INTO mmn_vpl VALUES ("MK7_18","071_7_18","MRK","7","18","18","Minsambag si Hisos nga daw wara pen kamo makasabot? Daw wara pen kamo mahagdam nga ya inkaen na tao diri gazed kon maonga ka tao. ");
INSERT INTO mmn_vpl VALUES ("MK7_19","071_7_19","MRK","7","19","19","Kay ya makaen diri an-azi dizan ka hena-hena na tao basta dizan ka lamang an-azi ka tinai na tao. Kamhan anlogwa ka lawas na tao. Ani ini ya sindo ni Hisos kay magakawa iza ka tanan mga sogo mahitenged ka makaen nga garing ka mga karaang Yodayo. ");
INSERT INTO mmn_vpl VALUES ("MK7_20","071_7_20","MRK","7","20","20","Kamhan mindogang pen iza pagsindo kaniran nga ya maonga nga mga panaba ani gazed ya makaonga ka tao. ");
INSERT INTO mmn_vpl VALUES ("MK7_21","071_7_21","MRK","7","21","21","Kay ya hena-hena nga maonga ani ya sinogdan ka paghinang ka malaw-ay daw ya pangawat daw ya pagbono ka tao daw ya paghenay ");
INSERT INTO mmn_vpl VALUES ("MK7_22","071_7_22","MRK","7","22","22","daw ya magaarig daw ya mga maiseg daw ya mga malimbongon daw ya mga malaw-ay daw ya magasina daw ya mga pagbetangbetang ka tao daw ya paggarboso daw ya talatalahen. ");
INSERT INTO mmn_vpl VALUES ("MK7_23","071_7_23","MRK","7","23","23","Iton nga tanan mga maongang batasan garing gazed ka hena-hena na tao. Kamhan makaonga gazed ka tao. ");
INSERT INTO mmn_vpl VALUES ("MK7_24","071_7_24","MRK","7","24","24","Pagkakamhan ni Hisos pagsindo kaniran minpanaw iza ngaro tenged ka dowang ka longsod nga Tiro daw Sidon. Pagdateng naiza doro minseled iza ka isang lagkaw. Diri gosto nga mahagdam ya mga tao nga dizan di iza piro nahagdam dazon siran. ");
INSERT INTO mmn_vpl VALUES ("MK7_25","071_7_25","MRK","7","25","25","Kamhan minkarini dazon kan Hisos ya isang babazi kay nabatian naiza nga dizan di si Hisos. Nagalised gazed ya toong bata kay inharian na maonga. Kamhan minlohod ya babazi dizan ka paahan ni Hisos ");
INSERT INTO mmn_vpl VALUES ("MK7_26","071_7_26","MRK","7","26","26","daw nagalong paghangzo nga Sinyor, kaloy-i intawon hao! Papanawen mo ya maonga dizan ka kanaong bata. Na, diri kon Yodayo ya babazi kay taga Siroponisiya iza. Ya toong saba Ginirika. ");
INSERT INTO mmn_vpl VALUES ("MK7_27","071_7_27","MRK","7","27","27","Agon minpamolinged si Hisos pagsambag ka babazi nga ya mga bata siran ya mahon-a pagkaen. Diri kon madazaw kon kaw-en ta ya kanirang makaen dazaw ibahog ka ido. Na, nakasabot dazon ya babazi nga ya kahologan diri kon madazaw kon antabang si Hisos ka mga taga Siriya paghon-a ka pagtabang naiza ka mga taga Yoda. ");
INSERT INTO mmn_vpl VALUES ("MK7_28","071_7_28","MRK","7","28","28","Kamhan minsambag ya babazi nga Sinyor, matood gazed ya saba mo. Piro bisan ngani ya mga ido nga nagabentag dizan ka salad na lamisa pagkaen niran ka mga podpod nga inhologan na mga bata diri bogawen ya mga ido. Ani ini ya sambag na babazi kay bisan geramay ka lamang ya pagtabang ni Hisos ka toong bata ansogot iza. ");
INSERT INTO mmn_vpl VALUES ("MK7_29","071_7_29","MRK","7","29","29","Kamhan minsambag si Hisos ka babazi nga madazaw gazed ya sambag mo kanao. Om-oli ko kay minpanaw di ya maonga dizan ka bata mo. ");
INSERT INTO mmn_vpl VALUES ("MK7_30","071_7_30","MRK","7","30","30","Na, pagdateng na babazi ka toong lagkaw nagabentag di matood ya toong maanak kay naolian ka magazong beet. ");
INSERT INTO mmn_vpl VALUES ("MK7_31","071_7_31","MRK","7","31","31","Pagkakamhan kaiza minpanaw si Hisos dizan ka bariyo nga Tiro. Pag-azi naiza ka bariyo nga Sidon minlargo iza ka danaw nga Galiliya tenged ka longsod nga Dikapolis. ");
INSERT INTO mmn_vpl VALUES ("MK7_32","071_7_32","MRK","7","32","32","Kamhan dizan kan Hisos in-ated niran ya tao nga nabengel daw nagalised ka pagkalitok ka toong saba. Kamhan inhangzo niran si Hisos nga kon somogot ko dazawen mo ini nga tao. ");
INSERT INTO mmn_vpl VALUES ("MK7_33","071_7_33","MRK","7","33","33","Kamhan in-ated ni Hisos ya tao dizan ka aro-aro. Kamhan inbetang ni Hisos ya toong toldo dalem ka talinga na tao. Indampa sab naiza ya dila na tao ka toong in-eleb. ");
INSERT INTO mmn_vpl VALUES ("MK7_34","071_7_34","MRK","7","34","34","Pagkakamhan naiza pagseleng ka langit mindakola iza paghinawa tenged ka pagkalooy ka tao. Kamhan minsogo iza nga abrihi! ");
INSERT INTO mmn_vpl VALUES ("MK7_35","071_7_35","MRK","7","35","35","Kamhan naabri matood ya talinga na tao daw magapakalitok di iza. ");
INSERT INTO mmn_vpl VALUES ("MK7_36","071_7_36","MRK","7","36","36","Kamhan minsogo si Hisos ka mga tao nga abay kamo pagpanan-og. Ambaza kay dizan ka mga iba nga tao mintoda gazed siran pagpanan-og nga indazaw ni Hisos ya tao. ");
INSERT INTO mmn_vpl VALUES ("MK7_37","071_7_37","MRK","7","37","37","Nagaberengbereng gazed siran daw namaglaong nga bisan ono ya hinang ni Hisos madazaw gazed iton. Bisan ya nabengel nga tao daw ya diri makalitok ka panaba dazawen gazed ni Hisos. ");
INSERT INTO mmn_vpl VALUES ("MK8_1","071_8_1","MRK","8","1","1","May isang aldaw nga mintipon pag-isab ya mga masarang kataed nga tao dizan kan Hisos. Kamhan waray makaen niran. Agon inpakarini ni Hisos ya toong mga sakop kay inlong-an nga ");
INSERT INTO mmn_vpl VALUES ("MK8_2","071_8_2","MRK","8","2","2","nalooy hao ka mga tao kay ikatlo ding aldaw koman ya pag-iba niran kanao. Nahodtan disab siran ka makaen. ");
INSERT INTO mmn_vpl VALUES ("MK8_3","071_8_3","MRK","8","3","3","Kon papanawen nao siran nga waray makaen pangetasan siran dizan ka dalan kay may mga garing ka aro. ");
INSERT INTO mmn_vpl VALUES ("MK8_4","071_8_4","MRK","8","4","4","Minsambag ya mga sakop nga daw hain kami koman mangita ka pagkaen dini ka kamingawan igo ka pagbosog kitong masarang kataed nga tao? ");
INSERT INTO mmn_vpl VALUES ("MK8_5","071_8_5","MRK","8","5","5","Kamhan nangotana si Hisos kaniran nga daw pira peng bolos ya mga pan mazo diton? Minsambag siran nga pito komang bolos ini. ");
INSERT INTO mmn_vpl VALUES ("MK8_6","071_8_6","MRK","8","6","6","Kamhan insogo ni Hisos ya mga tao ka pagpanlo-to dizan ka lopa. Kamhan minkawa iza ka pan nga pitong bolos. Pagkakamhan naiza pagpasalamat ka Diyos inpanipak naiza ya tanan daw inpanhatag ka toong mga sakop dazaw panhatagan sab niran ya mga tao dizan nga namaglo-to. ");
INSERT INTO mmn_vpl VALUES ("MK8_7","071_8_7","MRK","8","7","7","May mga talagsa ka sab nga isda nga geramay. Pagkakamhan ni Hisos pagpasalamat ka Diyos insogo ya toong mga sakop ka pagbahinbahin ka isda ka mga tao. ");
INSERT INTO mmn_vpl VALUES ("MK8_8","071_8_8","MRK","8","8","8","Na, pagkakamhan niran pagkaen nangabosog gazed sirang tanan. Pagkakamhan niran paghipid ka salin nangapono pen ya pitong ka alat. ");
INSERT INTO mmn_vpl VALUES ("MK8_9","071_8_9","MRK","8","9","9","Daw pirang bolos ya tao nga inpakaen ni Hisos? Hapit mag-opat nga ka libo sirang tanan. ");
INSERT INTO mmn_vpl VALUES ("MK8_10","071_8_10","MRK","8","10","10","Pagkakamhan kaiza inpaoli siran ni Hisos. Kamhan minleen iza ka baloto iba ka toong mga sakop kay pasinged siran ngaro ka dapit nga Dalmanota. ");
INSERT INTO mmn_vpl VALUES ("MK8_11","071_8_11","MRK","8","11","11","Pagdateng niran ka Dalmanota minkarini kan Hisos ya mga Parasiyo kay anlalis siran kontana. Kamhan minlaong siran kan Hisos pagporba nga ipakita mo kanami ya timaan dazaw mahagdam kami nga garing matood iko ka Diyos. ");
INSERT INTO mmn_vpl VALUES ("MK8_12","071_8_12","MRK","8","12","12","Kamhan mindakola si Hisos paghinawa tenged ka pag-anget kaniran daw minlaong nga kamo nga kanaong kaibahan nga Yodayo, kay ono sa nga ampakigkita sa kamo ka timaan? Magtimaan gazed kamo kaini nga diri hao ampakita kamazo ka bisan ono ya timaan. ");
INSERT INTO mmn_vpl VALUES ("MK8_13","071_8_13","MRK","8","13","13","Kamhan minpanaw si Hisos. Pagleen naiza ka baloto minsakay iza pag-isab ngandipi ka danaw. ");
INSERT INTO mmn_vpl VALUES ("MK8_14","071_8_14","MRK","8","14","14","Na, waray nadara na toong mga sakop nga pan kay nalipatan niran. Isa kang bolos ya kanirang bahaw. ");
INSERT INTO mmn_vpl VALUES ("MK8_15","071_8_15","MRK","8","15","15","Kamhan minpamolinged si Hisos kaniran nga nagalaong nga maghamarag kamo ka sindo na mga Parasiyo kay ya kanirang sindo minpasingedsinged iton ka ipasoligay ka pan. Kay bisan isaket ya geramay nga ipasoligay dizan ka harina anlekep iton ka tanan. ");
INSERT INTO mmn_vpl VALUES ("MK8_16","071_8_16","MRK","8","16","16","Kamhan namaglaonglaong ya toong mga sakop nga ani ini ya inpanaba ni Hisos kay wara say daradara ta wani nga pan. ");
INSERT INTO mmn_vpl VALUES ("MK8_17","071_8_17","MRK","8","17","17","Kamhan mahagdam si Hisos nga minhena-hena siran mahitenged ka pan, diri kon sindo na mga Parasiyo. Agon nangotana iza kaniran nga kay ono sa nawied kamo ka pan? Daw wara pen kamo makasabot? Singed ka magahi ya kamazong otok. ");
INSERT INTO mmn_vpl VALUES ("MK8_18","071_8_18","MRK","8","18","18","Bisan may mata mazo wara kamo makakita. Bisan may talinga mazo wara kamo makabati. Daw wara baza kamo makataremdem ");
INSERT INTO mmn_vpl VALUES ("MK8_19","071_8_19","MRK","8","19","19","kaiza nga pan nga lima kang bolos nga inpanipak nao ka mga limang ka libo nga ka tao ang dini kaini? Kamhan pirang bolos ya alat nga inpono mazo ka salin kaiza? Minsambag siran nga napolo may dowang ka alat. ");
INSERT INTO mmn_vpl VALUES ("MK8_20","071_8_20","MRK","8","20","20","Kamhan nangotana si Hisos pag-isab nga bisan pen ya pitong bolos nga pan nga inpakaen nao ka mga opat nga ka libo nga mga tao daw pirang bolos ya alat nga inpono mazo ka salin kaiza? Minsambag siran nga pitong bolos ya alat. ");
INSERT INTO mmn_vpl VALUES ("MK8_21","071_8_21","MRK","8","21","21","Minlaong iza nga kay ono sa nga wara kamo makasabot nga diri kon pan ya inlaong nao kamazo? ");
INSERT INTO mmn_vpl VALUES ("MK8_22","071_8_22","MRK","8","22","22","Na, pagdateng nin Hisos ka bariyo nga Bitsayda in-ated na mga tao ya nabota dizan kanangiza. Kamhan minhangzo siran nga nagalaong nga Hisos, kon somogot ko dazawen mo ini nga tao. ");
INSERT INTO mmn_vpl VALUES ("MK8_23","071_8_23","MRK","8","23","23","Kamhan inhabitan ni Hisos ya nabota dizan ka logwa na bariyo. Kamhan min-eleb si Hisos ka mata na nabota daw indampa naiza. Nangotana sab daw may nakita mo? ");
INSERT INTO mmn_vpl VALUES ("MK8_24","071_8_24","MRK","8","24","24","Minhangad ya tao daw minlaong nga nakakita hao ka mga tao piro singed siran ka mga liwaan nga nagapanaw. ");
INSERT INTO mmn_vpl VALUES ("MK8_25","071_8_25","MRK","8","25","25","Kamhan mindampa si Hisos ka mata na tao pag-isab. Pagseleng na tao pag-isab naolian matood ya toong mata. Bisan ono ya nakita naiza makalaro gazed ya pagpakakita naiza. ");
INSERT INTO mmn_vpl VALUES ("MK8_26","071_8_26","MRK","8","26","26","Kamhan minsogo si Hisos nga om-oli ko paglargo. Kamhan diri ko mag-azi dizan ka bariyo nga Bitsayda. ");
INSERT INTO mmn_vpl VALUES ("MK8_27","071_8_27","MRK","8","27","27","Pagkakamhan kaiza si Hisos daw ya toong mga sakop minlargo siran pagpanaw ngaro ka mga bariyo tenged ka longsod nga Sisariya Pilipos. Pagbagtas pen niran ngaro nangotana si Hisos ka toong mga sakop nga daw ono ya pagngaran na mga tao kanao? ");
INSERT INTO mmn_vpl VALUES ("MK8_28","071_8_28","MRK","8","28","28","Kamhan minsambag siran nga may nagalaong nga matod sa koni niran iko koni si Howan nga Magbenzagay. May nagalaong nga iko sab koni iton si Iliyas nga karaang propita na Diyos. May iba pen nagalaong nga iko sab koni ya isa pen nga karaang propita. ");
INSERT INTO mmn_vpl VALUES ("MK8_29","071_8_29","MRK","8","29","29","Kamhan nangotana si Hisos kaniran nga daw sin-o say pagngaran mazo kanao? Minsambag si Pidro nga iko ani matood si Kristo nga hari nga pinili na Diyos. ");
INSERT INTO mmn_vpl VALUES ("MK8_30","071_8_30","MRK","8","30","30","Kamhan minsogo si Hisos kaniran nga dizan ka bisan sin-o nga tao diri kamo magpanan-og kon sin-o sa hao. ");
INSERT INTO mmn_vpl VALUES ("MK8_31","071_8_31","MRK","8","31","31","Pagkakamhan kaiza minsogod si Hisos ka pagpasabot ka toong mga sakop nga iza nga minhon-a ka bisan sin-o nga mahon-ang tao an-azi iza ka mga mataed nga kalised. Kamhan magasawazen iza na mga malaas daw ya mga oloolo na mga pari daw ya mga maistro ka tinoohan na mga Yodayo. Kamhan pamagpatazen iza doro kaniran. Pagdateng ka ikatolong aldaw magabohien iza na Diyos pagbalik garing ka lebeng. ");
INSERT INTO mmn_vpl VALUES ("MK8_32","071_8_32","MRK","8","32","32","Pagkakamhan ni Hisos pagpanan-og kaini in-ated iza ni Pidro dizan ka waray laing tao. Kamhan minbaheg si Pidro nagalaong nga Ginoo, diri ko magpanaba nga patazen iko na mga tao. ");
INSERT INTO mmn_vpl VALUES ("MK8_33","071_8_33","MRK","8","33","33","Kamhan minliso si Hisos. Pagkita naiza ka toong mga sakop minbaheg iza kan Pidro nagalaong nga iko ya singed kan Satanas. Pomanaw ko dini kanao kay ya hena-hena mo nagasopak ka kabebet-en na Diyos. Nagaangay ya hena-hena mo ka kabebet-en na tao. ");
INSERT INTO mmn_vpl VALUES ("MK8_34","071_8_34","MRK","8","34","34","Pagkakamhan kaiza inpatipon ni Hisos ya mga mataed nga tao daw ya toong mga sakop. Minsindo iza kaniran nagalaong nga bisan sin-o ya anpasakop kanao kinahanglan bizaan naiza ya toong kaogaringen nga naazakan daw angeten ya pagkapatay singed kanao. Ka diri madogay dakpen hao na mga tao kamhan ipalansang ka kros keteb ka mapatay hao. ");
INSERT INTO mmn_vpl VALUES ("MK8_35","071_8_35","MRK","8","35","35","Kamhan bisan sin-o ya diri ansakop kanao kay nawied iza nga basi patazen iza mawara hinoa iza. Piro bisan sin-o ya napatay kay mintoo iza kanao daw ya kanaong sindo mahatagan iza ka bag-ong kinabohi nga diri mawara. ");
INSERT INTO mmn_vpl VALUES ("MK8_36","071_8_36","MRK","8","36","36","Bisan kon maangken na tao ya tanan mga betang dini ka kalibotan kamhan mawara ka ya toong kaogaringen nga kinabohi daw ono ya makawa naiza? Wara gazed. ");
INSERT INTO mmn_vpl VALUES ("MK8_37","071_8_37","MRK","8","37","37","Kay waray ikahatag naiza dazaw mabawi ya toong kinabohi. ");
INSERT INTO mmn_vpl VALUES ("MK8_38","071_8_38","MRK","8","38","38","Mindogang pen si Hisos paglaong nga hao ya minhon-a ka bisan sin-o nga mahon-ang tao. May tirmino nao ka pagbalik ka kalibotan. Iba sab kanao ya mga sogoonon nga taga langit. Magabado sab hao ka kalatì na kanaong Ama nga Diyos. Na, koman nga panahona ka wara pen hao magbalik ka kalibotan bisan sin-o ya anlimed kanao daw ya kanaong mga panaba dizan ka mga salaan nga tao anlimed isab hao kaiton nga tao kay-an ka pagdateng nao. ");
INSERT INTO mmn_vpl VALUES ("MK9_1","071_9_1","MRK","9","1","1","Kamhan indogangan ni Hisos pagsindo kaniran nagalaong nga timan-an mazo gazed ini nga dini kamazo may mga diri mapatay nga tao hangtod ka pagpakakita niran kanao pagbalik nao ka paghari ka kalibotan ka labaw nga gahem. Ani ini ya sindo ni Hisos ka mga tao daw toong mga sakop. ");
INSERT INTO mmn_vpl VALUES ("MK9_2","071_9_2","MRK","9","2","2","Na, minlabay di ya enem nga ka aldaw. Kamhan inpaiba ni Hisos si Pidro daw si Santiago daw si Howan ngandaked ka bobong nga ataas nga waray laing tao. Kamhan dizan ka pagseleng nirang tolo singed ka nabag-o di ya lawas ni Hisos piro si Hisos gazed iton. ");
INSERT INTO mmn_vpl VALUES ("MK9_3","071_9_3","MRK","9","3","3","Masarang kapoti ya toong bado singed ka kalatì na sega. Bisan ono ya ikapoti ka bado dini ka kalibotan diri gazed ampoti ka singed kaiton. ");
INSERT INTO mmn_vpl VALUES ("MK9_4","071_9_4","MRK","9","4","4","Kamhan waton disab si Iliyas daw si Moysis nga mga karaang propita na Diyos. Namaglaonglaong sirang dowa daw si Hisos. ");
INSERT INTO mmn_vpl VALUES ("MK9_5","071_9_5","MRK","9","5","5","Kamhan minlaong si Pidro kan Hisos nga Ginoo, madazaw ya kantang pagtipon dini. Kon somogot ko hinangen nami ya mga tolong bolos nga tal-ob. Kanmo ya isa. Kan Moysis ya isa. Kan Iliyas ya isa. ");
INSERT INTO mmn_vpl VALUES ("MK9_6","071_9_6","MRK","9","6","6","Ani ini ya inlaong ni Pidro kay diri iza mahagdam kon ono kontana ya toong ilaong kay nangahaldek gazed siran. ");
INSERT INTO mmn_vpl VALUES ("MK9_7","071_9_7","MRK","9","7","7","Kamhan intamdengan siran ka inarak daw nabatian ya saba dizan ka inarak nga nagalaong nga wani ya kanaong Maanak nga naazakan. Magtoo gazed kamo ka toong mga panaba kamazo. ");
INSERT INTO mmn_vpl VALUES ("MK9_8","071_9_8","MRK","9","8","8","Pagkakamhan kaiza minlingi dazon siran piro nawara dizan si Iliyas daw si Moysis. Si Hisos ka ya nakita niran dizan. ");
INSERT INTO mmn_vpl VALUES ("MK9_9","071_9_9","MRK","9","9","9","Na, paglogsong pen niran ngambaba mintogon si Hisos kaniran nagalaong nga hao ya minhon-a ka bisan sin-o nga mahon-ang tao. Mabohi sab hao kay-an pagbalik garing ka lebeng anipen kon ipanan-og mazo ya kamazong nakitan kazina ka daked pen kita ka bobong. ");
INSERT INTO mmn_vpl VALUES ("MK9_10","071_9_10","MRK","9","10","10","Kamhan dizan ka mga iba nga tao wara siran magpanan-og kaiton piro dizan kanirang tolo nangotana gazed siran daw ono ya inpanaba ni Hisos nga mabohi iza pagbalik kay-an garing ka lebeng? ");
INSERT INTO mmn_vpl VALUES ("MK9_11","071_9_11","MRK","9","11","11","Kamhan nangotana siran kan Hisos nga kay ono sa nagatoldo sa ya mga maistro nga Yodayo nga si Iliyas ani ya anhon-a kan Kristo? Daw matood iton kon diri? ");
INSERT INTO mmn_vpl VALUES ("MK9_12","071_9_12","MRK","9","12","13","Minsambag si Hisos nga minhon-a matood kanao ya tao nga singed kan Iliyas nga karaang propita na Diyos. Kay min-andam iza ka kanaong pagdateng. Si Howan nga Magbenzagay ani itong tao. Kamhan insakto isab ya daan pinasoyat na Diyos mahitenged kanao nagalaong nga hao nga minhon-a ka bisan sin-o nga mahon-ang tao an-azi hao ka mga mataed nga kalised. Kamhan magasawazen hao na mga tao. Ani ini ya daan pinasoyat na Diyos mahitenged kanao. ");
INSERT INTO mmn_vpl VALUES ("MK9_14","071_9_14","MRK","9","14","14","Pagkakamhan kaiza mindateng di siran ngambaba ka mga iba nga sinarigan nga inlibotan nga mga mataed nga tao. Inlalis sab siran na mga maistro ka tinoohan na mga Yodayo. ");
INSERT INTO mmn_vpl VALUES ("MK9_15","071_9_15","MRK","9","15","15","Pagpakakita na mga mataed nga tao kan Hisos nangabereng siran kay mindateng di iza dizan kaniran. Kamhan min-apas dazon siran kay an-abiabi kanangiza. ");
INSERT INTO mmn_vpl VALUES ("MK9_16","071_9_16","MRK","9","16","16","Kamhan nangotana si Hisos ka toong mga sinarigan nga daw ono ya paglalis mazo dizan ka mga maistro? ");
INSERT INTO mmn_vpl VALUES ("MK9_17","071_9_17","MRK","9","17","17","Ka wara pen siran sambag dini ka mga mataed nga tao may isa nga minlaong nga Maistro, indara nao ngarini kanmo ya kanaong maanak nga amaama kay diri iza makapanaba kay inharian gazed iza na maonga. ");
INSERT INTO mmn_vpl VALUES ("MK9_18","071_9_18","MRK","9","18","18","Kada paghari na maonga kanangiza magapatiholog dazon iza ka lopa. Kamhan magabora ya toong ba-ba daw magakagetget iza ka toong ngipen. Kamhan angahi gazed ya toong lawas pagsawan. Kazina minhangzo hao ka mga sakop mo dazaw papanawen niran ya maonga piro wara siran makadaeg. ");
INSERT INTO mmn_vpl VALUES ("MK9_19","071_9_19","MRK","9","19","19","Minsambag si Hisos nga waray pagtoo mazo ka Diyos. Daw dogay pen hao magahela dini kamazo anipen kamo makasabot ka gahem na Diyos? Daw dogay pen hao magaanget ka kamazong batasan nga waray pagtoo mazo? Dadha ngarini ya bata! ");
INSERT INTO mmn_vpl VALUES ("MK9_20","071_9_20","MRK","9","20","20","Na, pag-ated niran ka bata minkita ya maonga kan Hisos kamhan nagakabiribid ya lawas na bata. Naholog iza daw nagalompatlompat dizan ka lopa. Nagabora sab ya toong ba-ba. ");
INSERT INTO mmn_vpl VALUES ("MK9_21","071_9_21","MRK","9","21","21","Kamhan nangotana si Hisos ka ama na bata nga daw dogay di ya toong pagkasakit? Minsambag ya ama nga sokad ka geramay pen iza. ");
INSERT INTO mmn_vpl VALUES ("MK9_22","071_9_22","MRK","9","22","22","Isahay paeseben iza dizan ka sapa. Isahay palaksohon iza dizan ka laga kay patazen iza kontana. Kon makahimo ko tabangan mo kami. ");
INSERT INTO mmn_vpl VALUES ("MK9_23","071_9_23","MRK","9","23","23","Minsambag si Hisos nga kay ono sa nga nagadowadowa ko nga makadaeg hao ka maonga? Kay bisan sin-o ya ansarig kanao hinangen o ya bisan ono. ");
INSERT INTO mmn_vpl VALUES ("MK9_24","071_9_24","MRK","9","24","24","Kamhan indakola na ama ya toong sambag nga Hisos, antoo hao. Hegtan mo ya kanaong pagtoo. ");
INSERT INTO mmn_vpl VALUES ("MK9_25","071_9_25","MRK","9","25","25","Pagpakakita ka ni Hisos nga mindogok di ngarini ya mga mataed nga tao minbaheg dazon iza ka maonga nagalaong nga iko nga minpaamang ka bata daw minpabengel, domalagan ko dizan ka bata. Diri ko magbalik bisan kon-o. ");
INSERT INTO mmn_vpl VALUES ("MK9_26","071_9_26","MRK","9","26","26","Na, pagsinggit ka na maonga daw pagkabiribid ka lawas na bata mindalagan dazon. Kamhan ya lawas na bata singed iton ka lawas na napatay nga tao. Agon minlaong ya mga tao nga patay di iza. ");
INSERT INTO mmn_vpl VALUES ("MK9_27","071_9_27","MRK","9","27","27","Kamhan intagenan ni Hisos ya alima na amaama dazaw patindegen. Kamhan mabaskeg ya toong pagtindeg. ");
INSERT INTO mmn_vpl VALUES ("MK9_28","071_9_28","MRK","9","28","28","Na, pag-oli nin Hisos ka lagkaw nangotana ya toong mga sakop nga kay ono sa wara kami makapabogaw kaiton nga maonga nga minpaamang ka bata daw minpabengel? ");
INSERT INTO mmn_vpl VALUES ("MK9_29","071_9_29","MRK","9","29","29","Minsambag si Hisos nga ya paghangzo mazo ka Diyos anikay makapabogaw kaiton nga maonga. ");
INSERT INTO mmn_vpl VALUES ("MK9_30","071_9_30","MRK","9","30","30","Pagkakamhan kaiza minpanaw sin Hisos daw nagapasinged ngaro ka lopa nga Galiliya. Si Hisos diri maazak nga mahagdam ya mga tao kon minkar-in iza ");
INSERT INTO mmn_vpl VALUES ("MK9_31","071_9_31","MRK","9","31","31","kay nagasindo pen iza ka toong mga sakop nagalaong nga hao nga minhon-a ka bisan sin-o nga mahon-ang tao itogyan hao dizan ka gahem na mga tao nga ampatay kanao. Pagdateng ka ikatolong aldaw mabohi hao pagbalik garing ka lebeng. ");
INSERT INTO mmn_vpl VALUES ("MK9_32","071_9_32","MRK","9","32","32","Na, pagpakabati ka na toong mga sakop wara siran makasabot. Kamhan wara siran mangotana kon ono ya kahologan naiton kay nawied gazed siran. ");
INSERT INTO mmn_vpl VALUES ("MK9_33","071_9_33","MRK","9","33","33","Kamhan nakadateng di siran ka longsod nga Kapirnaom. Ka dalem pen si Hisos ka lagkaw nangotana iza kaniran nga kazina ka pagpanaw pen nita daw ono ya inlalislalisan mazo? ");
INSERT INTO mmn_vpl VALUES ("MK9_34","071_9_34","MRK","9","34","34","Kamhan minpahenek lamang siran kay ya inlalis niran nga sin-o ya labaw dini kaniran. ");
INSERT INTO mmn_vpl VALUES ("MK9_35","071_9_35","MRK","9","35","35","Kamhan minlo-to iza daw inpatipon naiza ya toong mga sakop nga napolo may dowa siran. Kamhan minlaong iza kaniran nga dizan kamazo kon naazak ya isa nga iza ya labaw nga tao kinahanglan ampangalagad iza kamazong tanan singed ka pagpangalagad na oripen. ");
INSERT INTO mmn_vpl VALUES ("MK9_36","071_9_36","MRK","9","36","36","Kamhan inpakarini ni Hisos ya isang bata kay patindegen dizan ka tenged na toong mga sakop. Paghakep naiza ka bata minlaong iza nga ");
INSERT INTO mmn_vpl VALUES ("MK9_37","071_9_37","MRK","9","37","37","garing ka pagtoo na tao kanao kon andawat iza ka bata andawat gihapon iza kanao. Kon andawat iza kanao andawat isab iza ka Diyos nga minpakarimbaba kanao. ");
INSERT INTO mmn_vpl VALUES ("MK9_38","071_9_38","MRK","9","38","38","Kamhan si Howan nangotana kan Hisos nga Maistro, kazina napaniidan nami ya tao nga minpadalagan ka maonga dizan ka tao. Pagsogo naiza ka maonga ka pagpanaw inpanaba naiza ya ngaran mo. Kamhan minbaheg kami kaiton nga tao kay diri kon sakop nami iza. ");
INSERT INTO mmn_vpl VALUES ("MK9_39","071_9_39","MRK","9","39","39","Minsambag si Hisos nga diri kamo magbaheg kaiton nga tao. Kay bisan sin-o ya angamit ka kanaong ngaran dazaw hinangen naiza ya madazaw diri iza ampanaba ka maonga mahitenged kanao. ");
INSERT INTO mmn_vpl VALUES ("MK9_40","071_9_40","MRK","9","40","40","Kay nakaangay kanta ya bisan sin-o nga diri an-away kanta. ");
INSERT INTO mmn_vpl VALUES ("MK9_41","071_9_41","MRK","9","41","41","Timan-an mazo gazed ini nga bisan sin-o ya antigis kamazo kay kamo ya kanaong mga sakop mahatagan isab ya antigis ka primyo. ");
INSERT INTO mmn_vpl VALUES ("MK9_42","071_9_42","MRK","9","42","42","Indogangan pen ni Hisos pagsindo kaniran nga ya dakolang bato nga galingan ibitay ka lieg na bisan sin-o ya antintal ka bata ka pagbiza kanao. Kamhan itimbag iza ka dagat dazaw diri makapadazon ka pagtintal ka bata. ");
INSERT INTO mmn_vpl VALUES ("MK9_43","071_9_43","MRK","9","43","43","Kamhan minpamolinged si Hisos kaniran nga nagalaong nga kon anhinang ya alima mo ka maonga ipaheneng gazed ya alima mo singed ka otdon iton. Kay bisan mapiang di ko ka dini pen iko ka kalibotan waray bali kay mahatagan ko ka bag-ong kinabohi nga diri mawara. Kay kon diri mo ipaheneng ya alima mo makadara iton kanmo ngaro ka impirno ");
INSERT INTO mmn_vpl VALUES ("MK9_44","071_9_44","MRK","9","44","44","nga waray pagkapareng daw waray heneng ka pagpangaen na mga olod ka onod na mga tao. ");
INSERT INTO mmn_vpl VALUES ("MK9_45","071_9_45","MRK","9","45","45","Bisan ya paa mo kon andara iton kanmo ka paghinang ka maonga ipaheneng mo ya paa mo singed ka otdon mo iton. Kay bisan mapiang di ko ka dini pen iko ka kalibotan waray bali kay mahatagan ko ka bag-ong kinabohi nga diri mawara. Kay kon diri mo ipaheneng ya paa mo makadara iton kanmo ngaro ka impirno ");
INSERT INTO mmn_vpl VALUES ("MK9_46","071_9_46","MRK","9","46","46","nga waray pagkapareng daw waray heneng ka pagpangaen na mga olod ka onod na mga tao. ");
INSERT INTO mmn_vpl VALUES ("MK9_47","071_9_47","MRK","9","47","47","Bisan ya kanmong mata kon makaonga iton ka hena-hena mo ipaheneng gazed ya mata mo pagseleng ka maonga. Kamhan singed ka kaw-en mo ya kanmong mata. Kay bisan pikas ka lamang ya mata mo ka dini pen iko ka kalibotan waray bali kay ampaseled hao kanmo ka hel-anan na kanaong Ama daked ka langit. Kay kon diri mo ipaheneng ya mata mo pagseleng ka maonga ikatimbag na Diyos ya tibolos lawas mo doro ka impirno ");
INSERT INTO mmn_vpl VALUES ("MK9_48","071_9_48","MRK","9","48","48","nga waray pagkapareng daw waray heneng ka pagpangaen na mga olod ka onod na mga tao. ");
INSERT INTO mmn_vpl VALUES ("MK9_49","071_9_49","MRK","9","49","49","Kamhan indogangan ni Hisos pagsindo kaniran nagalaong nga bisan sin-o ya kalibotanon kinahanglan an-azi iza ka mga kalised dazaw antoon iza ka pagbineetan. ");
INSERT INTO mmn_vpl VALUES ("MK9_50","071_9_50","MRK","9","50","50","Pamolinged ini nga ya asin madazaw iton piro kon wara di ya kaparat na asin diri di gazed ambalik ya kaparat. Na, singed ka asin ya kamazong mga hinang kay kamo ya antabang ka isa daw isa ka pagbineetan. ");
INSERT INTO mmn_vpl VALUES ("MK10_1","071_10_1","MRK","10","1","1","Pagkakamhan ni Hisos pagsindo ka toong mga sakop minpanaw iza garing ka longsod nga Kapirnaom dizan ka lopa nga Galiliya kay ankaro iza ka lopa nga Yoda dipi ka sapa nga Hordan. Na, pagdateng naiza doro nagatipon disab ya mga mataed nga tao dizan kanangiza. Kamhan minsindo iza kaniran kay ani ya toong batasan. ");
INSERT INTO mmn_vpl VALUES ("MK10_2","071_10_2","MRK","10","2","2","Na, minkarini disab kan Hisos ya mga Parasiyo kay amporba siran pagpangotana nga ya tao nga ampakigbelag ka toong asawa daw anlapas iza ka balaed na Diyos kon diri? ");
INSERT INTO mmn_vpl VALUES ("MK10_3","071_10_3","MRK","10","3","3","Minsambag si Hisos nga daw ono sa ya sogo ni Moysis nga kamazong karaan? ");
INSERT INTO mmn_vpl VALUES ("MK10_4","071_10_4","MRK","10","4","4","Minsambag siran nga dizan ka soyat ni Moysis nga inbilin kanami intogotan ya tao ni Moysis nga ihatag ka toong asawa ya soyat para ka pagpamatood nga minpakigbelag di iza ka toong asawa. ");
INSERT INTO mmn_vpl VALUES ("MK10_5","071_10_5","MRK","10","5","5","Minsambag si Hisos nga intogotan kamo ni Moysis ka pagpakigbelag ka kamazong asawa kay mahagdam iza nga diri kamo gazed ampatoo ka sindo na Diyos. ");
INSERT INTO mmn_vpl VALUES ("MK10_6","071_10_6","MRK","10","6","6","Kay kawandini pen ka sinogdan pen na kalibotan ya Diyos ani ya minhinang ka amaama daw ya babazi. ");
INSERT INTO mmn_vpl VALUES ("MK10_7","071_10_7","MRK","10","7","7","Sokad kaiton kon anminze ya amaama anbelag iza ka toong ginikanan dazaw antipon iza ka toong asawa. ");
INSERT INTO mmn_vpl VALUES ("MK10_8","071_10_8","MRK","10","8","8","Kamhan sirang dowa nahinang nga isang bolos nga tao kay namag-isa di ya kanirang hinawa. ");
INSERT INTO mmn_vpl VALUES ("MK10_9","071_10_9","MRK","10","9","9","Kamhan ya mag-asawa in-isa di siran na Diyos. Kamhan diri di gazed pabelagen siran na bisan sin-o nga tao. Ani ini ya sambag ni Hisos ka mga Parasiyo. ");
INSERT INTO mmn_vpl VALUES ("MK10_10","071_10_10","MRK","10","10","10","Pagkakamhan kaiza nangoli sin Hisos. Kamhan nangotana ya toong mga sinarigan pag-isab mahitenged ka pagpakigbelag na bana ka toong asawa. ");
INSERT INTO mmn_vpl VALUES ("MK10_11","071_10_11","MRK","10","11","11","Minsambag si Hisos nga bisan sin-o ya tao nga anpakigbelag ka toong asawa dazaw anminze ka laing babazi minhenay iza ka toong primirong asawa. ");
INSERT INTO mmn_vpl VALUES ("MK10_12","071_10_12","MRK","10","12","12","Bisan sin-o ya babazi nga ambelag ka toong bana dazaw anminze iza ka laing amaama minhenay itong babazi ka toong primirong bana. Ani ini ya sambag ni Hisos ka toong mga sinarigan. ");
INSERT INTO mmn_vpl VALUES ("MK10_13","071_10_13","MRK","10","13","13","Pagkakamhan kaiza may mga mindara ka mga bata dizan kan Hisos kay ipadampa siran kanangiza dazaw panaranginan. Piro inkasab-an siran na mga sakop ni Hisos. ");
INSERT INTO mmn_vpl VALUES ("MK10_14","071_10_14","MRK","10","14","14","Pagkahagdam ni Hisos ka inhinang na toong mga sakop nagalised ya toong hinawa ka pagkazehet. Nagalaong iza nga diri kamo magbaheg kaniran. Pakarinihen lamang siran kanao kay ya singed kaniran ani ya in-angay na Diyos. ");
INSERT INTO mmn_vpl VALUES ("MK10_15","071_10_15","MRK","10","15","15","Timan-an mazo gazed ini nga bisan sin-o ya diri ansarig kanao singed ka pagsarig na bata ka toong ama diri iza iangay na Diyos. ");
INSERT INTO mmn_vpl VALUES ("MK10_16","071_10_16","MRK","10","16","16","Kamhan inpanhakep ni Hisos ya mga maimpis. Inpandampa ya kanirang olo kay dazaw panaranginan ka madazaw. ");
INSERT INTO mmn_vpl VALUES ("MK10_17","071_10_17","MRK","10","17","17","Na, pagkakamhan kaiza si Hisos minpanaw iza pag-isab. Kamhan may isang amaama nga mindalagan ka pagsogat kan Hisos daw minlohod dizan ka paahan ni Hisos. Kamhan nangotana iza nga Madazaw nga Maistro, daw ono ya hinangen o nga madazaw dazaw tagan hao ka kinabohi nga diri mawara? ");
INSERT INTO mmn_vpl VALUES ("MK10_18","071_10_18","MRK","10","18","18","Kamhan minsambag si Hisos nga kay ono sang anngaran sa ko kanao nga madazaw? Ya Diyos kay madazaw. ");
INSERT INTO mmn_vpl VALUES ("MK10_19","071_10_19","MRK","10","19","19","Mahagdam ko daan ka mga kasogoan na Diyos nga azaw magpatay ka tao, azaw maghenay, azaw pangawat, azaw pamakak, azaw maglimbong ka tao, magtahod ko ka kanmong ama daw ina. ");
INSERT INTO mmn_vpl VALUES ("MK10_20","071_10_20","MRK","10","20","20","Minsambag ya tao nga Maistro, sokad ka batan-en pen hao nagatoman hao kaiton nga tanan mga sogo. ");
INSERT INTO mmn_vpl VALUES ("MK10_21","071_10_21","MRK","10","21","21","Pagseleng pen ni Hisos kaiton nga tao nalooy iza daw nagalaong nga isa koman ya kolang mo. Omoli ko naa ngaro ka lagkaw mo. Kamhan ipamaligza ya mga betang mo. Kamhan ya bazad ipanhatag ka mga pobri. Anipen ko kon somakop kanao dazaw sobra pen ya mga mahalen mo daked ka hel-anan na Diyos. ");
INSERT INTO mmn_vpl VALUES ("MK10_22","071_10_22","MRK","10","22","22","Pagpakabati ka na tao ka laong ni Hisos minpanaw iza. Nagalised ya toong hinawa kay diri kontana naiza ibaligza ya toong mga betang. ");
INSERT INTO mmn_vpl VALUES ("MK10_23","071_10_23","MRK","10","23","23","Pagseleng ni Hisos ka mga tao minlaong iza ka toong mga sinarigan nga ya mga tao nga kowartahan malised gazed ya pagsakop niran ka Diyos. ");
INSERT INTO mmn_vpl VALUES ("MK10_24","071_10_24","MRK","10","24","24","Nabereng gazed ya mga sinarigan ka inlaong ni Hisos piro indogangan ni Hisos paglaong nga diri kon masazon ya pagsakop na tao ka Diyos. ");
INSERT INTO mmn_vpl VALUES ("MK10_25","071_10_25","MRK","10","25","25","Pamolinged ini nga ya karabaw kon an-azi ka teheb na dagem masazon iton ka pagsakop na kowartahan ka Diyos kay wili ya toong hena-hena ka toong kowarta. ");
INSERT INTO mmn_vpl VALUES ("MK10_26","071_10_26","MRK","10","26","26","Kamhan nabereng gazed ya mga sakop ni Hisos daw minsambag nga kon malised ya pagsakop na kowartahan ka Diyos diri baza makalangit ya bisan sin-o nga tao. ");
INSERT INTO mmn_vpl VALUES ("MK10_27","071_10_27","MRK","10","27","27","Kamhan minseleng si Hisos kaniran daw minsambag nga kon ya tao ka lamang diri makahimo piro ya Ginoo makahimo iza ka tanan. ");
INSERT INTO mmn_vpl VALUES ("MK10_28","071_10_28","MRK","10","28","28","Kamhan minsambag si Pidro kan Hisos nga kami nga kanmong mga sinarigan izang dini kaini minbiza kami ka tanan dazaw makasakop kami kanmo. ");
INSERT INTO mmn_vpl VALUES ("MK10_29","071_10_29","MRK","10","29","29","Minsambag si Hisos nga timan-an mazo gazed ini nga ya tao nga minsakop kanao pasobrahan na Diyos ka pagbales ka madazaw. Kay minbiza iza ka toong hel-anan daw ya mga lomon daw ginikanan daw mga bata daw oma kay dazaw ansakop iza kanao daw anwali sab iza ka sindo mahitenged kanao. ");
INSERT INTO mmn_vpl VALUES ("MK10_30","071_10_30","MRK","10","30","30","Kamhan bisan hain iza magsinged may toong datnganan. Kamhan ya mga antoo kanao garing ka pagwali naiza singed siran ka matood nga lomon daw ginikanan daw mga bata. May toong oma isab. Tagan sab iza ka bag-ong kinabohi nga diri mawara. Kamhan ka dini pen iza ka kalibotan magaawazen gihapon iza kay kanao iza nga sakop. ");
INSERT INTO mmn_vpl VALUES ("MK10_31","071_10_31","MRK","10","31","31","Na, koman nga panahona ya mga mataed nga dato mga pobri siran kay-an. Kamhan ya mga pobri mga dato siran kay-an. Ani ini ya inlaong ni Hisos ka toong mga sinarigan. ");
INSERT INTO mmn_vpl VALUES ("MK10_32","071_10_32","MRK","10","32","32","Na, pagkakamhan kaiza minpasinged di sin Hisos doro ka siyodad nga Hirosalem. Si Hisos minhon-a kaniran pagpanaw. Siran nga mga sinarigan nangabereng gazed siran kay Hirosalem hel-anan iton na mga kaaway ni Hisos. Kamhan nahaldek sab ya mga tao nga min-iba kaniran kay basi madatngan siran na maonga. Na, ka wara pen siran dateng ka Hirosalem inpalain pagpatindeg ni Hisos ya toong mga sinarigan. Kamhan minsogod iza pagpakahagdam kaniran pag-otro kon onhon sa iza kay-an na mga tao ");
INSERT INTO mmn_vpl VALUES ("MK10_33","071_10_33","MRK","10","33","33","nga nagalaong nga mamanaw di kita ngaro ka siyodad nga Hirosalem. Kamhan doro kaiton nga dapit hao nga minhon-a ka bisan sin-o nga mahon-ang tao, iated hao doro ka mga oloolo na mga pari na mga Yodayo daw ya mga maistro ka tinoohan na mga Yodayo kay hokman hao niran ka kamatazen. Kamhan iated sab hao niran dizan ka mga diri kon Yodayo nga nagahari dini ka kantang lopa. ");
INSERT INTO mmn_vpl VALUES ("MK10_34","071_10_34","MRK","10","34","34","Kamhan pagasorasorahen hao niran daw magapanelban. Pagkakamhan niran paglatos kanao patazen hao niran. Pagdateng ka ikatolong aldaw sokad ka kanaong pagkapatay mabohi hao pagbalik garing ka lebeng. Ani ini ya pakahagdam ni Hisos ka toong mga sinarigan. ");
INSERT INTO mmn_vpl VALUES ("MK10_35","071_10_35","MRK","10","35","35","Kamhan si Santiago daw si Howan nga dowang ka maanak ni Sibidiyo min-arani siran kan Hisos kay anlaong nga Maistro, kon mahimo ya hinawa mo anhangzo kami kontana kanmo. ");
INSERT INTO mmn_vpl VALUES ("MK10_36","071_10_36","MRK","10","36","36","Minsambag iza kaniran nga daw ono sa ya maazakan mazo? ");
INSERT INTO mmn_vpl VALUES ("MK10_37","071_10_37","MRK","10","37","37","Minsambag siran nga kon somogot ko kay-an ka pagdateng na kanmong pagkahari palo-toon mo kami dizan ka kanmong sain. Ya isa kontana palo-toon dizan ka too mo. Ya isa dimbali ka wala mo. ");
INSERT INTO mmn_vpl VALUES ("MK10_38","071_10_38","MRK","10","38","38","Kamhan minsambag si Hisos nga wara kamo makasabot kon ono ya inhangzo mazo kanao. Daw makaanget kamo ka mga kalised nga singed ka maazihan nao kay-an daw kanaong pagkapatay? ");
INSERT INTO mmn_vpl VALUES ("MK10_39","071_10_39","MRK","10","39","39","Minsambag sirang dowa nga Hisos, makahimo kami kaiton. Kamhan minlaong iza kaniran nga ya mga kalised nga andateng kanao andateng sab matood kamazo. Ya kanaong pagkapatay ani gihapon ya kamazong pagkapatay. ");
INSERT INTO mmn_vpl VALUES ("MK10_40","071_10_40","MRK","10","40","40","Piro ya inhangzo mazo kanao ka paglo-to dizan ka too nao daw dimbali ka wala nao diri kon hao ya ampili ka tao kay impili daan na Diyos kon sin-o ya makalo-to dizan ka kanaong sain. ");
INSERT INTO mmn_vpl VALUES ("MK10_41","071_10_41","MRK","10","41","41","Na, pagpakabati na mga napolo nga sinarigan nazehet siran kan Santiago daw si Howan. ");
INSERT INTO mmn_vpl VALUES ("MK10_42","071_10_42","MRK","10","42","42","Kamhan impatipon siran ni Hisos kay anlaong iza nga mahagdam kamo ka batasan na mga diri kon Yodayo nga nagahari dini ka kantang lopa. Magmandaray gazed siran ka mga tao. ");
INSERT INTO mmn_vpl VALUES ("MK10_43","071_10_43","MRK","10","43","43","Piro kamo nga kanaong mga sakop, diri kamo maghaod ka kanirang batasan kay dizan kamazo kon naazak ya isa nga iza ya labaw kinahanglan ampangalagad iza kamazo. ");
INSERT INTO mmn_vpl VALUES ("MK10_44","071_10_44","MRK","10","44","44","Kon naazak ya isa nga iza ya may katenged nga ataas kinahanglan anpangalagad iza kamazong tanan singed ka pagpangalagad na oripen. ");
INSERT INTO mmn_vpl VALUES ("MK10_45","071_10_45","MRK","10","45","45","Kay hao nga minhon-a ka bisan sin-o nga mahon-ang tao, minkarimbaba hao dini kamazo dazaw ampangalagad hao kamazo. Wara hao magpaalagad kamazo. Ampahalad sab hao ka kanaong kinabohi doro ka kros kay hao ya ambazad ka mga sala na mga mataed nga tao. Ani ini ya sindo ni Hisos ka toong mga sinarigan. ");
INSERT INTO mmn_vpl VALUES ("MK10_46","071_10_46","MRK","10","46","46","Na, pagkakamhan kaiza minpasinged si Hisos ngaro ka longsod nga Hiriko. Masarang kataed ya tao nga minsonod kanangiza. Na, paggaring niran ka longsod nga Hiriko dizan ka kilid na karsada may nagalo-to nga isang nabota nga mang-azoay. Si Bartimayas ya ngaran nga maanak ni Timayas. ");
INSERT INTO mmn_vpl VALUES ("MK10_47","071_10_47","MRK","10","47","47","Pagpakabati ka na nabota nga si Hisos nga taga Nazarit ani ya minlabay dizan kanangiza minsogod iza paghawag nagalaong nga Ginoo nga kaliwat ni Dabid, kaloy-an mo hao! ");
INSERT INTO mmn_vpl VALUES ("MK10_48","071_10_48","MRK","10","48","48","Kamhan inbaheg iza na mga tao nagalaong nga magpahenek di ko dizan. Kamhan mintoda hinoa iza pagsinggit nga Ginoo nga kaliwat ni Dabid, kaloy-i intawon hao! ");
INSERT INTO mmn_vpl VALUES ("MK10_49","071_10_49","MRK","10","49","49","Pagpakabati ni Hisos minheneng iza dizan daw minsogo ka mga tao nga pakarinihen mazo iza. Kamhan minhawag siran ka nabota nga magsaza ko kay pakadizanen ko ni Hisos. Tindeg naa. ");
INSERT INTO mmn_vpl VALUES ("MK10_50","071_10_50","MRK","10","50","50","Mintindeg dazon si Bartimayas daw minpowas ka toong tameng. Kamhan minkandizan iza kan Hisos. ");
INSERT INTO mmn_vpl VALUES ("MK10_51","071_10_51","MRK","10","51","51","Kamhan nangotana si Hisos nga daw ono ya gosto mo kanao? Minsambag ya nabota nga Ginoo, ya gosto nao nga makakita ya kanaong mata. ");
INSERT INTO mmn_vpl VALUES ("MK10_52","071_10_52","MRK","10","52","52","Minsambag si Hisos nga omoli ko naa kay madazaw di ya mata mo kay hao ya insarigan mo. Kamhan madazaw matood ya toong mata. Min-iba iza kan Hisos paglargo. ");
INSERT INTO mmn_vpl VALUES ("MK11_1","071_11_1","MRK","11","1","1","Na, pagpasinged nin Hisos ngaro arani ka siyodad nga Hirosalem mindateng di siran ka dowang ka bariyo nga Bitpahi daw Bitani dizan tenged ka bobong inngaranan ka Olibo. Kamhan minsogo si Hisos ka toong sinarigan nga dowa siran ");
INSERT INTO mmn_vpl VALUES ("MK11_2","071_11_2","MRK","11","2","2","nga nagalaong nga komaro kamo naa ka bariyo dizan ka hon-ahan mazo. Pagdateng ka mazo doro makakita kamo dazon ka isang batan-en pen nga asno nga klasi na kabayo nga in-ektan dizan. Sokad wara masakzi na tao. Hobaden mazo iton daw tozokon mazo ngarini kanao. ");
INSERT INTO mmn_vpl VALUES ("MK11_3","071_11_3","MRK","11","3","3","Kon may mangotana kamazo nga kay ono sa mazo inbadbadan ya kabayo magsambag kamo nga inkinahanglan ini na kanaming oloolo. Kamhan ioli ka pagdali. ");
INSERT INTO mmn_vpl VALUES ("MK11_4","071_11_4","MRK","11","4","4","Na, pagkakamhan ni Hisos pagsogo kaniran namanaw sirang dowa paglargo. Nakitan niran matood ya kabayo nga in-ektan dizan ka gawas na alad. Paghobad pen niran kaiton ");
INSERT INTO mmn_vpl VALUES ("MK11_5","071_11_5","MRK","11","5","5","nangotana ya mga mintindeg dizan nga onhon sa mazo iton nga kaw-en sa mazo itong kabayo? ");
INSERT INTO mmn_vpl VALUES ("MK11_6","071_11_6","MRK","11","6","6","Minsambag siran nga togon ni Hisos ini. Kamhan mintogot dazon ya tao. ");
INSERT INTO mmn_vpl VALUES ("MK11_7","071_11_7","MRK","11","7","7","Kamhan intozok dazon niran dizan kan Hisos ya kabayo. Inhanigan sab niran ka kanirang mga bado ya likod na kabayo kay sakzan koman ni Hisos. ");
INSERT INTO mmn_vpl VALUES ("MK11_8","071_11_8","MRK","11","8","8","Pagpakasakay ka naiza inhanigan dazon ya dalan nga azihanan na kabayo ka mga bado na mga mataed nga tao. Impanbetangan disab na mga iba nga tao ka mga paka kay tahodon niran si Hisos. ");
INSERT INTO mmn_vpl VALUES ("MK11_9","071_11_9","MRK","11","9","9","Kamhan ya mga minhon-a kan Hisos daw ya mga mahori namagdengandengan siran pagsinggit nga sazaen, sazaen kay iko ya mindateng garing ka Ginoo! Tagan naiza iko ka dakola nga gahem. ");
INSERT INTO mmn_vpl VALUES ("MK11_10","071_11_10","MRK","11","10","10","Parig-enen sab naiza ya kanmong paghari ka mga tao singed gazed ka paghari ni Dabid nga kantang karaang tao. Sazaen, sazaen ya Diyos! Ani ini ya pagsaza na mga tao kan Hisos pagdateng naiza ka Hirosalem. ");
INSERT INTO mmn_vpl VALUES ("MK11_11","071_11_11","MRK","11","11","11","Pagkakamhan kaiza minseled si Hisos ka dakolang lagkaw nga pangamozoanan ka Diyos. Pagkakamhan naiza pagpaniid ka batasan na mga magsingbahay minbalik iza ka Bitani kay nadeleman di siran. Iba gihapon ya toong mga sinarigan nga napolo may dowa siran. ");
INSERT INTO mmn_vpl VALUES ("MK11_12","071_11_12","MRK","11","12","12","Na, pagkasonod nga aldaw ka pagpanaw niran dini ka Bitani imbengtas si Hisos. ");
INSERT INTO mmn_vpl VALUES ("MK11_13","071_11_13","MRK","11","13","13","Kamhan doro ka hon-ahan nakitan naiza ya isang tanem ani ngaran ya igira. Nandahon di gazed iton. Kamhan min-arani si Hisos ka tanem kay sosihen kon may protas. Ambaza kay mga dahon ka sa. Kay diri pen kon tigbonga bisan min-ataas ya mga dahon. ");
INSERT INTO mmn_vpl VALUES ("MK11_14","071_11_14","MRK","11","14","14","Kamhan minlaong si Hisos ka tanem nga sokad koman diri ko makapamonga bisan kon-o nga aldaw. Na, nabatian na toong mga sinarigan ya laong ni Hisos ka tanem. ");
INSERT INTO mmn_vpl VALUES ("MK11_15","071_11_15","MRK","11","15","15","Na, pagpakadateng ka ni Hisos ka siyodad nga Hirosalem minseled iza pag-isab ka dakolang lagkaw nga pangamozoanan ka Diyos. Kamhan impamogaw gazed naiza ya mga mamaligzaay daw ya mga mamalitay. Impandeeg sab naiza ya mga lamisa na mga Yodayo nga magsilihay ka mga kowarta nga indara na mga taga laing dapit. Impanowad disab naiza ya mga siya na mga magbaligzaay ka mga salapati nga mga ihaladay na mga tao ka Diyos. ");
INSERT INTO mmn_vpl VALUES ("MK11_16","071_11_16","MRK","11","16","16","Kamhan diri siran togotan pagdara ka bisan ono dini ka pawa na dakolang lagkaw na Diyos. ");
INSERT INTO mmn_vpl VALUES ("MK11_17","071_11_17","MRK","11","17","17","Kamhan minbaheg iza kaniran nga nagalaong nga may daan pinasoyat na Diyos nga nagalaong nga ya kanaong lagkaw ani ya lagkaw ka pagpangamozo na mga tao kanao. Ambaza kay inhinang di mazo iton ka datnganan na mga tolisan nga magapanlimbong ka mga tao. Ani ini ya inbaheg ni Hisos kaniran. ");
INSERT INTO mmn_vpl VALUES ("MK11_18","071_11_18","MRK","11","18","18","Pagpakahagdam ka na mga oloolo na mga pari na mga Yodayo daw ya mga maistro namagsabotsabot siran nga onhon sa niran pagpapatay kan Hisos. Piro nahaldek siran kan Hisos kay ya mga tao naazak gazed siran ampanalinga ka sindo ni Hisos. ");
INSERT INTO mmn_vpl VALUES ("MK11_19","071_11_19","MRK","11","19","19","Na, pagkadelem kaiza minlogwa sin Hisos ka siyodad nga Hirosalem. ");
INSERT INTO mmn_vpl VALUES ("MK11_20","071_11_20","MRK","11","20","20","Pagkamasiselem kaiza nagapasinged sin Hisos dizan kaiton nga tanem nga igira. Nakitan niran nga nangalaza matood iton garing ka gamot ngaro ka mga oldot. ");
INSERT INTO mmn_vpl VALUES ("MK11_21","071_11_21","MRK","11","21","21","Kamhan si Pidro nakataremdem iza kon in-ono ni Hisos kahabi agon minlaong iza kan Hisos nga Maistro, selengi! Nangalaza di gazed ya tanem nga ingabaan mo. ");
INSERT INTO mmn_vpl VALUES ("MK11_22","071_11_22","MRK","11","22","22","Minsambag si Hisos nga magsarig kamo ka Diyos. ");
INSERT INTO mmn_vpl VALUES ("MK11_23","071_11_23","MRK","11","23","23","Timan-an mazo gazed ini nga ya bobong dizan kon sogoon mo iton ka pagsibeg ngaro ka dagat ansibeg matood iton kon ansarig gazed kamo ka Diyos daw diri kamo andowadowa. ");
INSERT INTO mmn_vpl VALUES ("MK11_24","071_11_24","MRK","11","24","24","Panabaan ta kamo nga kon heget ya pagtoo mazo ka Diyos madawat mazo ya bisan ono nga kamazong pangazoon dizan kanangiza. ");
INSERT INTO mmn_vpl VALUES ("MK11_25","071_11_25","MRK","11","25","25","Wani pen ya sogo nao kamazo nga kon ampangamozo kamo ka Diyos pasaylohon mazo ya bisan sin-o nga nakasala kamazo dazaw pasaylohon isab kamo na kamazong Ama nga nagahela daked ka langit. ");
INSERT INTO mmn_vpl VALUES ("MK11_26","071_11_26","MRK","11","26","26","Piro kon diri kamo anpasaylo ka mga tao ka kanirang mga sala ya kamazong Ama nga nagahela daked ka langit diri isab iza anpasaylo ka kamazong mga sala. ");
INSERT INTO mmn_vpl VALUES ("MK11_27","071_11_27","MRK","11","27","27","Pagkakamhan ni Hisos pagsindo kaniran minbalik siran ka Hirosalem. Ka nagapanaw pen iza dalem ka dakolang lagkaw na Diyos may mga minkarini kanangiza nga mga oloolo na mga pari daw ya mga maistro ka tinoohan na mga Yodayo daw ya mga malaas. ");
INSERT INTO mmn_vpl VALUES ("MK11_28","071_11_28","MRK","11","28","28","Kamhan nangotana siran kan Hisos nga daw hain garing ya katenged mo ka pagbogaw ka mga tao kahabi? Daw sin-o ya minhatag kanmo ka katenged ka pagpadazon ka kanmong mga hinang dini kanami? ");
INSERT INTO mmn_vpl VALUES ("MK11_29","071_11_29","MRK","11","29","29","Minsambag si Hisos kaniran nga wani sab ya pangotana nao kamazo. Kon makasambag kamo anipen hao magpanan-og kamazo kon hain garing ya kanaong katenged ka paghinang kaiton. ");
INSERT INTO mmn_vpl VALUES ("MK11_30","071_11_30","MRK","11","30","30","Na, daw hain garing ya katenged ni Howan ka pagpamenzag ka mga tao? Magsambag kamo kanao. ");
INSERT INTO mmn_vpl VALUES ("MK11_31","071_11_31","MRK","11","31","31","Kamhan namaglalislalis siran kon ono sa kontana ya kanirang isambag kan Hisos. Namaglaonglaong siran nga kon ansambag kita nga garing ka Diyos ya katenged ni Howan basi long-on kita ni Hisos nga kay ono sa nga wara sa kamo magtoo kan Howan? ");
INSERT INTO mmn_vpl VALUES ("MK11_32","071_11_32","MRK","11","32","32","Piro kon ansambag kita nga garing ka tao ya katenged ni Howan pamookon kita na mga tao kay mintoo gazed siran nga si Howan ya matood nga propita na Diyos. ");
INSERT INTO mmn_vpl VALUES ("MK11_33","071_11_33","MRK","11","33","33","Kamhan minsambag siran kan Hisos nga wara kami mahagdam. Kamhan minsambag isab si Hisos kaniran nga diri sab hao ampanan-og kamazo kon hain garing ya kanaong katenged ka pagpadazon ka kanaong mga inhinang. ");
INSERT INTO mmn_vpl VALUES ("MK12_1","071_12_1","MRK","12","1","1","Pagkakamhan ni Hisos pagsambag ka mga maistro ka tinoohan na mga Yodayo minsogod iza pagpanaba kaniran ka pamolinged nagalaong nga may isang tao nga mintanem ka oma nga tamnanan ka mga obas. Inlibotan ya oma ka alad. Kamhan impakabotan naiza ya lopa kay hinangen ya salodanan ka sapa para ka pagkepeg ka mga obas. Kamhan inhinang naiza ya ataas nga lagkaw nga bantazan ka mga tanem. Kamhan nandapit iza ka mga saop. Kamhan minpanaw iza ngaro ka laing dapit. ");
INSERT INTO mmn_vpl VALUES ("MK12_2","071_12_2","MRK","12","2","2","Pagkahapit di anihen ya mga obas impakaro naiza ya toong sogoonon kay pakaw-en di kontana naiza ka toong mga kabahinan. ");
INSERT INTO mmn_vpl VALUES ("MK12_3","071_12_3","MRK","12","3","3","Kamhan pagdateng na mga sogoonon ka mga saop indakep hinoa niran kamhan imbonalan. Impaoli sab wara katagi. ");
INSERT INTO mmn_vpl VALUES ("MK12_4","071_12_4","MRK","12","4","4","Ka wara pen madogay insogo disab pagpakaro ya laing sogoonon piro imbonalan gihapon niran ya toong olo diri tahodon. ");
INSERT INTO mmn_vpl VALUES ("MK12_5","071_12_5","MRK","12","5","5","In-otrohan pagsogo ya laing sogoonon piro baza-baza nga impatay di gazed. Kamhan mataed pen gihapon ya mga sogoonon nga impakaro piro impamagbonalan ya isa daw impamagpatay sab ya mga iba. ");
INSERT INTO mmn_vpl VALUES ("MK12_6","071_12_6","MRK","12","6","6","Na, isa koman gazed ya nabilin. Ani iza ya maanak na tag-iza nga toong naazakan. Na, ya impakaro na tag-iza nga kataposan di gazed ani di izang maanak. Kay nagahena-hena iza nga tahodon gazed niran ya kanaong maanak. ");
INSERT INTO mmn_vpl VALUES ("MK12_7","071_12_7","MRK","12","7","7","Kamhan pagpakakita na mga saop nga wani di kaan andateng di ya maanak na tag-iza namagsabotsabot dazon siran nga waton di ngarini kanta ya maanak na tag-iza nga magdawatay kay-an kaini nga lopa nga toong irinsiya. Hala, pamagpatazen ta iza kay dazaw kita ka mazoy makapolos ka pagpanag-iza ka lopa. ");
INSERT INTO mmn_vpl VALUES ("MK12_8","071_12_8","MRK","12","8","8","Kamhan impamagtagenan matood niran ya maanak daw impamagpatay. Kamhan intimbag ya toong lawas ngaro ka gawas na alad na tanem. ");
INSERT INTO mmn_vpl VALUES ("MK12_9","071_12_9","MRK","12","9","9","Na, daw magaono sa koman ya tag-iza na lopa kaniran? Ankaro pen iza ka toong mga saop kay patazen gazed naiza siran. Kamhan pasaopan naiza ya tanem ka lain. ");
INSERT INTO mmn_vpl VALUES ("MK12_10","071_12_10","MRK","12","10","10","Pagkakamhan ni Hisos pagpamolinged kaniran mintiwas iza paglaong nga daw wara pen kamo makabasa ka daan pinasoyat na Diyos nga nagalaong nga ya matimgas nga bato nga inbizaan na mga minhinang ka lagkaw ani ya nahinang nga sinarigan ka pagparig-en ka primirong ogdok na lagkaw. ");
INSERT INTO mmn_vpl VALUES ("MK12_11","071_12_11","MRK","12","11","11","Inhinang iton na Ginoo kamhan madazaw gazed iton pagpakakita nami. Kilalhen mazo nga ya dakolang matimgas nga bato nga inbizaan mazo ani hao. ");
INSERT INTO mmn_vpl VALUES ("MK12_12","071_12_12","MRK","12","12","12","Na, pagpakabati na mga maistro na mga Yodayo daw ya mga malaas makasabot dazon siran nga naigo siran ka pamolinged ni Hisos. Agon pamagdakpen niran kontana si Hisos piro mahaldek siran ka mga tao. Kamhan namanaw di siran. ");
INSERT INTO mmn_vpl VALUES ("MK12_13","071_12_13","MRK","12","13","13","Kamhan pakarohon niran ya mga Parasiyo daw ya mga Yodayo nga minsakop di kan Hirodis nga hari. Kay magalit-agen kontana si Hisos pagpanaba. ");
INSERT INTO mmn_vpl VALUES ("MK12_14","071_12_14","MRK","12","14","14","Pagdateng niran nagalaong siran nga Maistro, mahagdam kami nga matadeng ya batasan mo daw matood ya mga panaba mo. Pagtoldo sab mo ka sindo na Diyos waray pinalabi mo nga bisan sin-o nga taohana. Na, panabaan mo kami. Daw makalapas kami ka balaed na mga Yodayo kon ambazad kami ka bohis kan Sisar nga hari nga nakadaeg ka kantang lopa? ");
INSERT INTO mmn_vpl VALUES ("MK12_15","071_12_15","MRK","12","15","15","Daw ambazad kami kon diri? Na, mahagdam si Hisos nga daeten iza kontana kamhan minbales iza pagpangotana kaniran nagalaong nga kay ono sa kamo minporba kamo kanao? Dadhen mazo ngarini ya isang palata nga kowarta kay anseleng hao kaiton. ");
INSERT INTO mmn_vpl VALUES ("MK12_16","071_12_16","MRK","12","16","16","Paghatag niran ka kowarta kan Hisos nangotana iza kaniran nga daw kanin-ong bayho ini ka kowarta? Daw kanin-ong ngaran ya insoyat dini? Minsambag siran nga kan Sisar gazed iton. ");
INSERT INTO mmn_vpl VALUES ("MK12_17","071_12_17","MRK","12","17","17","Kamhan minsambag si Hisos nga bayri mazo ya azoon ni Sisar kamazo. Bayri sab mazo ya azoon na Diyos kamazo. Kamhan nabereng siran kay diri siran makahimo ka paglalis kan Hisos. ");
INSERT INTO mmn_vpl VALUES ("MK12_18","071_12_18","MRK","12","18","18","Pagkakaan kaiza minkarini disab kan Hisos ya mga maistro na mga Yodayo ani ngaran ya Sadosiyo. Ya kanirang toldoan ya mga namola di nga tao diri gazed mabohi pagbalik garing ka lebeng. Na, nangotana siran kan Hisos nga ");
INSERT INTO mmn_vpl VALUES ("MK12_19","071_12_19","MRK","12","19","19","Maistro, ya kanaming karaan nga si Moysis imbilinan sa kami ka soyat kay nagatogon kanami nga kon mapatay ya isang tao kamhan imbilin ya asawa piro waray maanak kinahanglan ya lomon na napatay anikay makapangasawa ka toong ipag nga nabalo di dazaw ampanganak. Kamhan mabohi ka ya ngaran na toong magorang nga napatay. Ani ini ya togon ni Moysis kanami. ");
INSERT INTO mmn_vpl VALUES ("MK12_20","071_12_20","MRK","12","20","20","Na, izang mahon-a pen may maglomon nga pitong ka amaama. Naminze di ya kamagorangan. Kamhan napatay di iza ka waray maanak. ");
INSERT INTO mmn_vpl VALUES ("MK12_21","071_12_21","MRK","12","21","21","Kamhan ya toong asawa nga nabalo di impangasawa na primirong manghod. Pagkakamhan kaiza napatay kasab ya primirong manghod nga waray maanak. Singed kaiton ya kahimtang na ikadowang manghod ");
INSERT INTO mmn_vpl VALUES ("MK12_22","071_12_22","MRK","12","22","22","keteb ka gipos-an. Pagkahorot niran pagkapatay anipen mapatay ya babazi nga nabalo ka pitong ka maglomon. ");
INSERT INTO mmn_vpl VALUES ("MK12_23","071_12_23","MRK","12","23","23","Na, Maistro, wani ya pangotana nami kanmo kay mintoldo iko nga may tirmino ka pagbohi ka mga tao nga nangapatay. Daw kanin-ong asawa itong babazi kon mabohi pag-isab ya mga namagsonodsonod nga pitong ka maglomon kay iza ya asawa nirang tanan? ");
INSERT INTO mmn_vpl VALUES ("MK12_24","071_12_24","MRK","12","24","24","Minsambag si Hisos nga sazep mazo iton kay wara pen kamo makasabot ka daan pinasoyat na Diyos daw toong gahem. ");
INSERT INTO mmn_vpl VALUES ("MK12_25","071_12_25","MRK","12","25","25","Kay ka pagpangabohi na mga tao kay-an diri di magkaminze ya mga amaama daw ya mga babazi kay nabag-o di ya kanirang mga batasan singed ka batasan na mga sogoonon nga taga langit. ");
INSERT INTO mmn_vpl VALUES ("MK12_26","071_12_26","MRK","12","26","26","Mahimo gazed ya pagpabohi na Diyos ka mga tao pagbalik garing ka lebeng. Daw wara kamo magbasa ka libro nga insoyat ni Moysis nagalaong nga izang mahon-a pen mintindeg iza dizan tenged ka sagbet nga dogihen nga nagalaga. Kamhan may nabatian naiza nga saba na Diyos nga garing ka sagbet nagalaong nga hao nga Diyos ani ya hawagenen na kamazong mga karaan nga si Abraham daw si Isak daw si Hakob. Ani ini ya impasoyat na Diyos. Kamhan bisan patay di ya mga karaan magahawagen pen niran ya Diyos kay bohi ka siran daked. ");
INSERT INTO mmn_vpl VALUES ("MK12_27","071_12_27","MRK","12","27","27","Kamhan iza ya Diyos na mga bohi nga tao, diri kon Diyos na mga patay. Kamo nga mga Sadosiyo dakola ya sazep mazo kay nagatoldo kamo ka mga tao nga ya mga napatay nga tao diri mabohi pag-isab garing ka lebeng. ");
INSERT INTO mmn_vpl VALUES ("MK12_28","071_12_28","MRK","12","28","28","Na, may isang maistro ka tinoohan na mga Yodayo nga nanalinga kaizang paglalis na mga Sadosiyo kan Hisos. Mahagdam iza nga insakto gazed ya inkasambag ni Hisos. Kamhan nangotana iza nga Maistro, dizan ka kasogoan na Diyos daw ono ya labaw nga sogo? ");
INSERT INTO mmn_vpl VALUES ("MK12_29","071_12_29","MRK","12","29","29","Minsambag si Hisos nga wani ya labaw nga sogo na Diyos nagalaong nga kamo nga mga kaliwatan ni Israil, manalinga kamo. Isa ka gazed ya Ginoo, waray lain. Ya Ginoo ani iza ya kantang Diyos. ");
INSERT INTO mmn_vpl VALUES ("MK12_30","071_12_30","MRK","12","30","30","Kinahanglan nga pagaazaken mazo pagtineed ya Ginoo nga kamazong Diyos. Kamhan isahen mazo ya kamazong hena-hena ka pagtaremdem kanangiza. Ani ini ya labaw nga sogo. ");
INSERT INTO mmn_vpl VALUES ("MK12_31","071_12_31","MRK","12","31","31","Kamhan may ikadowang sogo nga kinahanglan mag-azak kamo ka kamazong iba singed ka pag-azak mazo ka kamazong kaogaringen. Ani ini ya dowang bolos nga sogo nga labaw ka mga iba nga sogo. ");
INSERT INTO mmn_vpl VALUES ("MK12_32","071_12_32","MRK","12","32","32","Kamhan minsambag ya maistro na mga Yodayo nga Maistro, insakto iton. Matood nga isa ka gazed ya Ginoo, waray lain. ");
INSERT INTO mmn_vpl VALUES ("MK12_33","071_12_33","MRK","12","33","33","Kamhan kon ampalabaw kami ka kaazak nami kanangiza dini ka tanan naming kaogaringen, kon maazak sab kami ka kanaming kaibahan singed ka pag-azak nami ka kanaming kaogaringen, madazaw gazed iton ka batasan mazo ka pagpansonog ka mga ihazep ka paghawag ka Diyos. ");
INSERT INTO mmn_vpl VALUES ("MK12_34","071_12_34","MRK","12","34","34","Na, pagpakabati ni Hisos ka insambag naizang maistro nagalaong iza nga madazaw ya kanmong hena-hena. Kon tomanen mo iton nga mga sogo, ya Diyos ani gazed ya insakopan mo. Ani ini ya sambag ni Hisos. Kamhan sokad kaiton wara di siran makasigi pagbalik pagpangotana kan Hisos. ");
INSERT INTO mmn_vpl VALUES ("MK12_35","071_12_35","MRK","12","35","35","Ka nagasindo pen si Hisos dalem ka dakolang lagkaw na Diyos nagalaong iza nga maghena-hena naa kamo ka intoldo na mga maistro na mga Yodayo nagalaong nga kaliwat ka lamang ni Dabid si Kristo. ");
INSERT INTO mmn_vpl VALUES ("MK12_36","071_12_36","MRK","12","36","36","Na, diri kon matood ya kanirang pagtoldo kay kawandini pen minngaran si Dabid kan Kristo nga toong Ginoo pagtandeg na Madazaw nga Ispirito na Diyos ka toong hinawa. Kay minlaong iza nga ya Diyos ani ya minpanaba ka kanaong Ginoo nga lomo-to ko naa dini ka kanaong too hangtod ka pagpakadaeg nao ka kanmong mga kaaway. Ani ini ya daan mga panaba ni Dabid mahitenged kan Kristo nga hari nga pinili na Diyos. ");
INSERT INTO mmn_vpl VALUES ("MK12_37","071_12_37","MRK","12","37","37","Kamhan kon minngaran si Dabid kan Kristo nga toong Ginoo daw ono say toong pagkakaliwat ka lamang ni Dabid? Na, ya mga mataed nga tao naazak gazed siran pagpangalinga ka toldoan ni Hisos. ");
INSERT INTO mmn_vpl VALUES ("MK12_38","071_12_38","MRK","12","38","38","Kamhan mindogang iza paglaong nga maghamarag kamo ka batasan na mga maistro ka mga Yodayo. Kay magabado siran ka mga ataas nga bado. Kamhan an-azi siran dizan ka mirkado kay naazak gazed siran nga madazaw ya pag-abiabi na mga tao kaniran. ");
INSERT INTO mmn_vpl VALUES ("MK12_39","071_12_39","MRK","12","39","39","Kada pagpista daw kada pagsingba naazak siran kon palo-toon siran ka magazong dapit. ");
INSERT INTO mmn_vpl VALUES ("MK12_40","071_12_40","MRK","12","40","40","Magapanlimbong sab siran ka mga balo nga babazi dazaw makaangken siran ka kanirang mga irinsiya. Kamhan magapaataasen sab niran ya kanirang pagpangamozo ka Diyos dazaw komoton niran ya kanirang mga sala. Agon pahamtangan siran na Diyos ka silot pagdakola ka silot naiza ka iba nga mga tao nga nakasala. ");
INSERT INTO mmn_vpl VALUES ("MK12_41","071_12_41","MRK","12","41","41","Pagkakamhan kaiza nagalo-to si Hisos dalem ka dakolang lagkaw na Diyos. Atbang iza ka betanganan ka kowarta nga ihaladay na mga tao. Kamhan minpaniid iza ka mga mataed nga tao nga minholog ka kanirang mga halad. Mataed ya mga kowartahan nga minholog ka dakolang kowarta. ");
INSERT INTO mmn_vpl VALUES ("MK12_42","071_12_42","MRK","12","42","42","Min-azi disab dizan ya isang balo nga babazi nga pobri gazed iza. Dos sintabos ka lamang ya toong inhatag. ");
INSERT INTO mmn_vpl VALUES ("MK12_43","071_12_43","MRK","12","43","43","Kamhan minpatipon si Hisos ka toong mga sinarigan kay nagalaong iza kaniran nga timan-an mazo gazed ini nga ya dos sintabos nga inhatag naitong balo nga pobri labaw gazed iton ka tibolos kowarta nga inhatag na mga iba nga tao. ");
INSERT INTO mmn_vpl VALUES ("MK12_44","071_12_44","MRK","12","44","44","Kay dakola pen ya kowarta niran piro nawara di gazed ya kowarta na babazi kay inhorot di naiza ka paghalad ya toong panginabohi. ");
INSERT INTO mmn_vpl VALUES ("MK13_1","071_13_1","MRK","13","1","1","Na, paglogwa ni Hisos ka dakolang lagkaw nga pangamozoanan ka Diyos minlaong ya isang sinarigan nga Maistro, selengan mo itong magazong kalagkawenan nga natipon paghinang ka dakolang lagkaw na Diyos. Magazon gihapon ya mga bato nga hininang nga singbahan. ");
INSERT INTO mmn_vpl VALUES ("MK13_2","071_13_2","MRK","13","2","2","Minsambag si Hisos nga paka selengi gazed mazo itong mga lagkaw. Mageba gazed iton kaan. Basta ya mga bato nga insompazan podo mabogto pagpangadeeg. ");
INSERT INTO mmn_vpl VALUES ("MK13_3","071_13_3","MRK","13","3","3","Na, ka nagalo-to si Hisos dizan ka bobong nga Olibo atbang ka dakolang lagkaw na Diyos si Pidro daw si Howan daw si Andris anikay toong iba koman. Kamhan nangotana siran nga ");
INSERT INTO mmn_vpl VALUES ("MK13_4","071_13_4","MRK","13","4","4","panan-ogan mo kami kon kon-o kon mageba iton nga mga lagkaw. Daw ono ya timaan kon matoman ya inpanaba mo kanami? ");
INSERT INTO mmn_vpl VALUES ("MK13_5","071_13_5","MRK","13","5","5","Kamhan minsogod si Hisos pagsindo kaniran nga maghamarag kamo kay basi magalimbogan kamo na mga tao. ");
INSERT INTO mmn_vpl VALUES ("MK13_6","071_13_6","MRK","13","6","6","Kay mataed ya mga andateng nga ampasingedsinged siran kanao magaangken nga si Kristo siran nga pinili na Diyos ka paghari ka mga tao. Kamhan malimbongan ya mga mataed nga tao. ");
INSERT INTO mmn_vpl VALUES ("MK13_7","071_13_7","MRK","13","7","7","Diri sab kamo magkahaldek kon makabati kamo nga may gobot na gira nga arani di koni kamazo, may gira disab koni doro ka aro. Matoman matood iton piro diri pen kon ani ya kataposan nga panahon dini ka kalibotan. ");
INSERT INTO mmn_vpl VALUES ("MK13_8","071_13_8","MRK","13","8","8","Kay ka wara pen matapos ya kalibotan ampakig-away ya isang longsod ka laing longsod, ampakig-away isab ya isang hari ka laing hari. Linogon isab ya mga nagakalainlain dapit daw madateng isab ka mga pihit. Iton nga tanan ani ya sinogdan ka lamang na mga kalised dini ka kalibotan. ");
INSERT INTO mmn_vpl VALUES ("MK13_9","071_13_9","MRK","13","9","9","Na, kamo nga kanaong mga sinarigan, mag-andam kamo ka kamazong hinawa kay dadhen kamo na mga tao dizan ka hokmanan bisan waray sala mazo. Kamhan dalem ka mga singbahan na mga Yodayo pamagbonalan kamo. Pansangilan sab kamo niran dizan ka mga laing tao nga magahari ka lopa na mga Yodayo. Ani ini ya hinang niran kamazo kay hao ya insakopan mazo. Kamhan panan-ogan mazo siran mahitenged kanao. ");
INSERT INTO mmn_vpl VALUES ("MK13_10","071_13_10","MRK","13","10","10","Ya sindo na Diyos mahitenged kanao kinahanglan iwali pen iton doro ka tibolos kalibotan dazaw mahagdam ya tanan mga tao anipen matapos ya kalibotan. ");
INSERT INTO mmn_vpl VALUES ("MK13_11","071_13_11","MRK","13","11","11","Mindogang pen si Hisos paglaong kaniran nga mapiriso kamo kay-an piro ka wara pen kamo magtindeg dizan ka hokmanan diri kamo magkawied kon ono ya isambag mazo kaniran kay antandeg ya Diyos ka kamazong hena-hena. Kamhan panabaen mazo kaniran kay diri kon garing ka hena-hena mazo ya pagpanaba kay garing hinoa ka Madazaw nga Ispirito na Diyos. ");
INSERT INTO mmn_vpl VALUES ("MK13_12","071_13_12","MRK","13","12","12","Na, wani pen ya panan-og mahitenged ka batasan na mga tao kay-an. Dadhen na isa ya toong lomon dizan ka laing tao dazaw patazen. Dadhen sab na ama ya toong maanak dazaw patazen. Masinopaken sab ya mga bata ka kanirang mga ginikanan. Kamhan garing ka sogo na bata patazen ya ginikanan. ");
INSERT INTO mmn_vpl VALUES ("MK13_13","071_13_13","MRK","13","13","13","Magakontarahan sab kamo na tanan mga tao kay hao ya insakopan mazo. Na, bisan sin-o ya antoo pen kanao keteb ka pagkatapos naiton nga mga kalised mahatagan iza ka bag-ong kinabohi nga diri mawara. ");
INSERT INTO mmn_vpl VALUES ("MK13_14","071_13_14","MRK","13","14","14","Na, impanan-ogan pen ni Hisos ya toong mga sinarigan mahitenged ka mga masiet nga kalised kay-an. Nagalaong iza nga pagpakakita mazo ka isang tao nga ansopak gazed ka Diyos ngandalem ka dakolang lagkaw nga pangamozoanan ka Diyos, kamo nga mga taga Yoda mandalagan gazed kamo daked ka bobong. ");
INSERT INTO mmn_vpl VALUES ("MK13_15","071_13_15","MRK","13","15","15","Bisan magahayahay kamo dizan ka pawa dalagan gazed kamo kay waray logar mazo ka pagpanhipid ka kamazong mga betang. ");
INSERT INTO mmn_vpl VALUES ("MK13_16","071_13_16","MRK","13","16","16","Bisan magatarabaho kamo daked ka kamazong oma dalagan gazed kamo kay waray logar mazo ka pagkawa ka kamazong bado dizan ka lagkaw. ");
INSERT INTO mmn_vpl VALUES ("MK13_17","071_13_17","MRK","13","17","17","Kalooy adaw na mga kabdes daw ya mga may pinasoso kay magalised siran ka pagdalagan. ");
INSERT INTO mmn_vpl VALUES ("MK13_18","071_13_18","MRK","13","18","18","Maghangzo kamo ka Diyos nga kontana diri kon panahon nga tig-oran ya pagdalagan mazo daw ya aldaw nga tigpahimlay ");
INSERT INTO mmn_vpl VALUES ("MK13_19","071_13_19","MRK","13","19","19","kay ya kasamok naiton nga panahona masara iton ka bisan ono ya kasamok sokad kawandini pen ka sinogdan pen na kalibotan hangtod koman daw kawanihen ka. ");
INSERT INTO mmn_vpl VALUES ("MK13_20","071_13_20","MRK","13","20","20","Kamhan kon diri padalien na Ginoo ya mga aldaw wara gazed ya tao nga mabohi. Piro magakalooy ya Ginoo ka toong mga pinili agon ampadali iza kaiton nga panahona kay-an. ");
INSERT INTO mmn_vpl VALUES ("MK13_21","071_13_21","MRK","13","21","21","Na, kay-an kaiton nga panahona kon may anlaong kamazo nga paka selengi, mindateng di si Kristo nga hari nga pinili na Diyos, diri kamo magtoo. Kon may anlaong sab kamazo nga paka selengi waton di iza ngarini, diri kamo magtoo. ");
INSERT INTO mmn_vpl VALUES ("MK13_22","071_13_22","MRK","13","22","22","Kay andateng pen kamazo ya mga ampasingedsinged kan Kristo daw ya magapatihinang ka mga propita na Diyos. Anhinang sab siran ka mga kaberenganan kay kon mahimo malimbongan ya mga tao nga pinili na Diyos. ");
INSERT INTO mmn_vpl VALUES ("MK13_23","071_13_23","MRK","13","23","23","Maghamarag gazed kamo kay minpakahagdam di hao kamazo. ");
INSERT INTO mmn_vpl VALUES ("MK13_24","071_13_24","MRK","13","24","24","Nagapadazon si Hisos pagsindo kaniran nagalaong nga pagkatiwas na mga masiet nga kalised kay-an andeglem ya sega, anlipsilipsi ya bolan. ");
INSERT INTO mmn_vpl VALUES ("MK13_25","071_13_25","MRK","13","25","25","Mangaholog sab ya mga bitoon garing daked ka langit. Magakaonga gazed ya kalangitan kay ipahezenghezeng na Diyos. ");
INSERT INTO mmn_vpl VALUES ("MK13_26","071_13_26","MRK","13","26","26","Anipen makita hao na mga tao kay domatengay hao iba ya mga gabon. Pagkarimbaba nao kay-an labaw gazed hao ka gahem daw madazaw selengan. ");
INSERT INTO mmn_vpl VALUES ("MK13_27","071_13_27","MRK","13","27","27","Kamhan sogoon nao ya kanaong mga sinogo nga taga langit dazaw patiponon niran ya mga tao nga impili nao daan garing ka mga dapit doro ka sebazan daw salpan daw timogan daw kanawazan daw bisan hain dini ka kalibotan. ");
INSERT INTO mmn_vpl VALUES ("MK13_28","071_13_28","MRK","13","28","28","Na, paniidan mazo ya batasan na tanem nga igira. Kon namag-o ya dahon mahagdam di kamo nga ampanhoraw kaan. ");
INSERT INTO mmn_vpl VALUES ("MK13_29","071_13_29","MRK","13","29","29","Singed iton ka inlaong nao kamazo koman. Pagpakakita mazo kaiza nga mga inlaong nao kamazo mahagdam kamo nga arani di gazed ya tirmino nao ka pagbalik ka kalibotan. ");
INSERT INTO mmn_vpl VALUES ("MK13_30","071_13_30","MRK","13","30","30","Matood nga ka wara pen mapatay ya kamazong kaliwatan matoman ya impanan-og o kamazo. ");
INSERT INTO mmn_vpl VALUES ("MK13_31","071_13_31","MRK","13","31","31","Mangawara ya kalangitan daw ya kalibotan piro ya kanaong mga panaba diri gazed mawara. ");
INSERT INTO mmn_vpl VALUES ("MK13_32","071_13_32","MRK","13","32","32","Na, waray mahagdam kon kon-o hao ambalik ka kalibotan. Bisan ya mga sogoonon nga tagalangit, bisan kon hao, wara mahagdam kay ya kanaong Ama nga Diyos iza kay mahagdam. ");
INSERT INTO mmn_vpl VALUES ("MK13_33","071_13_33","MRK","13","33","33","Agon maghamarag kamo kay wara kamo mahagdam kon kon-o iton andateng. ");
INSERT INTO mmn_vpl VALUES ("MK13_34","071_13_34","MRK","13","34","34","Na, ya pagbalik nao ngarini singed iton ka tao nga minpanaw doro ka aro. Impabantazan naiza ya toong lagkaw ka mga sogoonon. Impanhatag naiza ya tarabaho ka tagsa tagsa nga toong sogoonon. Insogo sab naiza ya magbantazay dizan ka pirtahan nagalaong nga diri ko mag-endang pagbantay. ");
INSERT INTO mmn_vpl VALUES ("MK13_35","071_13_35","MRK","13","35","35","Na, singed kaiton ya pagsogo nao kamazo kay wara kamo mahagdam kon ono orasa ya pagbalik na tag-iza ka lagkaw. Inday kon delem kon tenga na kahabzen kon pagtagaok na manok ka pagkamasiselem ya pagbalik nao. ");
INSERT INTO mmn_vpl VALUES ("MK13_36","071_13_36","MRK","13","36","36","Diri kamo magpakatorog kay basi ambalik hao pagdali. ");
INSERT INTO mmn_vpl VALUES ("MK13_37","071_13_37","MRK","13","37","37","Na, ya inlaong nao kamazo ani isab ya sogo nao ka tanan mga tao nga maghamarag gazed kamong tanan. ");
INSERT INTO mmn_vpl VALUES ("MK14_1","071_14_1","MRK","14","1","1","Pagkakamhan kaiza minkandizan si Hisos ka bariyo nga Bitani. Kon-isa pen pan-ihawen na mga Yodayo ya mga nati na karniro kay mamista siran. Kanen sab niran ya pan nga waray ipasoligay. Na, ya mga oloolo na mga pari daw ya mga maistro ka tinoohan na mga Yodayo nagapangita di siran ka paazi kon onhon niran pagdakep kan Hisos dazaw patazen niran. Piro kanirang tinago iton ");
INSERT INTO mmn_vpl VALUES ("MK14_2","071_14_2","MRK","14","2","2","kay nagalaong siran nga kay-an ka pagkaliwas na pista dakpen si Hisos dazaw diri magobot ya mga mamistahay. Ani ini ya sabot niran. ");
INSERT INTO mmn_vpl VALUES ("MK14_3","071_14_3","MRK","14","3","3","Na, dizan di si Hisos ka lagkaw ni Simon nga taga Bitani nga nabahawan ka kagid. Na, ka nagakaen pen si Hisos may minseled nga babazi nga nagadara ka garapahay nga hininang nga bato. Ya ngaran na bato nga garapa ani alabastar. Ya leen na grapa klasi na lana nga masarang kahamot. Waray insaket bisan ono. Mahal gazed kon paliten. Ani ngaran ya nardo. Kamhan in-otdan na babazi ya lieg na garapahay. Kamhan imbo-boan dazon naiza ya olo ni Hisos. ");
INSERT INTO mmn_vpl VALUES ("MK14_4","071_14_4","MRK","14","4","4","Na, pagpakakita ka na mga tao nangazehet siran. Kamhan nagalaong siran ka kanirang hena-hena nga kay ono sa inhanogon ya lana nga mahamot? ");
INSERT INTO mmn_vpl VALUES ("MK14_5","071_14_5","MRK","14","5","5","Kontana ipakowarta iton kay sobra ka sohol ka napolo nga ka bolan kon paliten. Kamhan ya halin ipanhatag ka mga pobri. Kamhan minbaheg siran ka babazi. ");
INSERT INTO mmn_vpl VALUES ("MK14_6","071_14_6","MRK","14","6","6","Piro minlaong si Hisos nga pabet-i lamang mazo ya hinang na babazi. Diri kamo magakasamok kanangiza kay madazaw gazed ya toong inhinang kanao. ");
INSERT INTO mmn_vpl VALUES ("MK14_7","071_14_7","MRK","14","7","7","Kay ya mga pobri onay siran magaibaiba kamazo. Kon ansogot kamo may logar mazo ka pagtabang kaniran. Piro hao diri di madogay ampanaw dini kamazo. ");
INSERT INTO mmn_vpl VALUES ("MK14_8","071_14_8","MRK","14","8","8","Insakto gazed ya hinang na babazi kanao kay minbo-bo di iza koman ka kanaong lawas dazaw naandaman ka paglebeng kay-an. ");
INSERT INTO mmn_vpl VALUES ("MK14_9","071_14_9","MRK","14","9","9","Timan-an mazo gazed ini nga ya pagbo-bo na babazi kanao diri malipatan iton kay dini ka tibolos kalibotan bisan hain dapit ya pagwali na mga tao ka sindo mahitenged kanao ipanan-og sab niran ya toong pagbo-bo kanao. ");
INSERT INTO mmn_vpl VALUES ("MK14_10","071_14_10","MRK","14","10","10","Pagkakamhan ni Hisos paglaong kaniran si Hodas nga taga Kariyoti nga isa dizan ka mga napolo may dowang ka sinarigan ni Hisos minkaro iza ka mga oloolo na mga pari na mga Yodayo kay an-edlaw gazed iza kan Hisos. ");
INSERT INTO mmn_vpl VALUES ("MK14_11","071_14_11","MRK","14","11","11","Pagpakabati ka na mga oloolo ka gosto ni Hodas namagsaza siran. Kamhan insaadan si Hodas ka kowarta. Kamhan minpanaw dazon si Hodas kay nagapangita iza ka paazi kon onhon naiza ka pag-edlaw kan Hisos. ");
INSERT INTO mmn_vpl VALUES ("MK14_12","071_14_12","MRK","14","12","12","Na, koman aldaw ani ya primirong aldaw ka pista ka pagpangaen na mga Yodayo ka pan nga waray ipasoligay. Pan-ihawen disab niran ya mga nati na karniro kay antaremdem siran nga pagbetang na mga karaan niran ka dogo na nati dizan ka pirtahan na lagkaw niran wara siran maazihi na tagalangit nga insogo na Diyos ka pagpamatay ka mga amaama nga panganay na mga taga Ihipto. Na, ya aldawa ka pista nangotana ya mga sinarigan kan Hisos nga Ginoo, daw hain ya lagkaw nga andaman nami ka pagkaen mo ka pista? ");
INSERT INTO mmn_vpl VALUES ("MK14_13","071_14_13","MRK","14","13","13","Kamhan dizan kaniran insogo ni Hisos ya dowa nga nagalaong nga komaro naa kamo ka siyodad nga Hirosalem. Kamhan may magabathay ka tadzaw nga ansogat kamazo. Sondon mazo iza. ");
INSERT INTO mmn_vpl VALUES ("MK14_14","071_14_14","MRK","14","14","14","Pagpakaseled sab naiza ka lagkaw maglaong kamo ka tag-iza na lagkaw nga Nong, ya kanaming maistro ani ya minsogo kanami ngarini kay ampangotana kanmo kon hain ya seled nga kananan naiza ka pista iba ka toong kasakopan? ");
INSERT INTO mmn_vpl VALUES ("MK14_15","071_14_15","MRK","14","15","15","Kamhan antoldo iza kamazo ngandaked ka ikadowang saleg nga may seled nga haloag nga ipapalastar daan ya mga kinahanglanen ta. Na, dizan kaiton andamen mazo ya kantang pagkaen. Ani ini ya pagtogon ni Hisos kaniran. ");
INSERT INTO mmn_vpl VALUES ("MK14_16","071_14_16","MRK","14","16","16","Kamhan namanaw di siran matood ngaro ka siyodad. Pagdateng niran doro nakitan matood niran ya tanan inlaong ni Hisos kaniran. Kamhan namag-andam siran ka pagkaen ka pista. ");
INSERT INTO mmn_vpl VALUES ("MK14_17","071_14_17","MRK","14","17","17","Pagkakahabzen kaiza mindateng si Hisos daw ya toong mga sinarigan nga napolo may dowa siran. ");
INSERT INTO mmn_vpl VALUES ("MK14_18","071_14_18","MRK","14","18","18","Na, ka nagapangaen pen siran minlaong si Hisos nga timan-an mazo gazed ini nga wadini gazed kanta ya an-edlaw kanao nga isa. Namagsaro kami koman na an-edlaw kanao. ");
INSERT INTO mmn_vpl VALUES ("MK14_19","071_14_19","MRK","14","19","19","Kamhan nagalised gazed ya hena-hena na mga sinarigan ka saba ni Hisos kaniran. Tagsa tagsa kaniran minsambag nga diri gazed kon hao iton! ");
INSERT INTO mmn_vpl VALUES ("MK14_20","071_14_20","MRK","14","20","20","Kamhan minsambag si Hisos nga dini kamazong napolo may dowa, ya isa ani om-edlaway kanao. Ya tao nga minsaro kanao ka pagkaen iza ya an-edlaw kanao. ");
INSERT INTO mmn_vpl VALUES ("MK14_21","071_14_21","MRK","14","21","21","Kay matoman gazed kaan ya daan pinasoyat na Diyos mahitenged ka pagkapatay nao. Basta ya tao nga om-edlaway kanao kaan intawon madazaw kon wara iza pakataoha. ");
INSERT INTO mmn_vpl VALUES ("MK14_22","071_14_22","MRK","14","22","22","Na, ka nagakaen pen siran minporot si Hisos ka pan. Pagpasalamat naiza ka Diyos impanipaktipak naiza iton kay ipanhatag ka toong mga sinarigan. Kamhan minlaong iza nga dawata ini kay ini nga pan kilalhen mazo nga kanaong lawas. ");
INSERT INTO mmn_vpl VALUES ("MK14_23","071_14_23","MRK","14","23","23","Kamhan minporot iza ka baso nga may imnenen nga sapa na mga obas. Pagpasalamat naiza ka Diyos impandoholan naiza siran. Kamhan min-inem sirang tanan. ");
INSERT INTO mmn_vpl VALUES ("MK14_24","071_14_24","MRK","14","24","24","Kamhan minlaong iza nga ini nga imnenen kilalhen mazo nga kanaong dogo nga ipaawas nao kay-an ka pagkapatay nao para ka sala na mga mataed nga tao. Ya kanaong dogo ani ya pirmahan na Diyos ka bag-ong saad naiza ka tanan mga tao. ");
INSERT INTO mmn_vpl VALUES ("MK14_25","071_14_25","MRK","14","25","25","Timan-an mazo gazed ini nga diri gazed hao an-inem pag-isab ka sapa na mga obas hangtod ka paghari na kanaong Ama ka bag-ong kalibotan. Anipen an-inem hao ka bag-ong imnenen. Ani ini ya inlaong ni Hisos kaniran. ");
INSERT INTO mmn_vpl VALUES ("MK14_26","071_14_26","MRK","14","26","26","Na, pagkakamhan niran pagkanta ka kasaza niran ka Diyos namanaw siran ngaro ka bobong nga Olibo. ");
INSERT INTO mmn_vpl VALUES ("MK14_27","071_14_27","MRK","14","27","27","Kamhan minlaong si Hisos kaniran nga mandalagan kaan kamong tanan kay mamiza kanao. Kamhan matoman ya daan pinasoyat na Diyos nga nagalaong nga ipapatay nao ya mag-aligrahay ka mga karniro. Kamhan mangabelagbelag di ya mga karniro. Ani ini ya daan pinasoyat na Diyos. ");
INSERT INTO mmn_vpl VALUES ("MK14_28","071_14_28","MRK","14","28","28","Kamhan pagkabohi nao pagbalik garing ka lebeng anhon-a hao kamazo doro ka Galiliya. ");
INSERT INTO mmn_vpl VALUES ("MK14_29","071_14_29","MRK","14","29","29","Minsambag si Pidro nga bisan bizaan iko nirang tanan, diri gazed hao ambiza kanmo. ");
INSERT INTO mmn_vpl VALUES ("MK14_30","071_14_30","MRK","14","30","30","Minsambag si Hisos nga timan-an mo gazed ini nga koman nga kahabzen ka wara pen tagaok ya manok ka ikadowa, ikatolo di mo hao kon ilimed paglaong nga diri kon iko ya kanaong sakop. ");
INSERT INTO mmn_vpl VALUES ("MK14_31","071_14_31","MRK","14","31","31","Kamhan minpahisambag si Pidro nga agad kon patazen pen hao iba kanmo diri ta ko gazed ilimed. Kamhan ya tanan mga sinarigan minpanaba isab siran kan Hisos singed ka pagpanaba ni Pidro. ");
INSERT INTO mmn_vpl VALUES ("MK14_32","071_14_32","MRK","14","32","32","Pagkakamhan kaiza minkaro sin Hisos ka Gitsimani nga tamnanan ka mga liwaan inngaranan ka Olibo. Pagdateng dizan minlaong si Hisos nga maglo-to naa kamo dini kay ampangamozo pen hao ka Diyos. ");
INSERT INTO mmn_vpl VALUES ("MK14_33","071_14_33","MRK","14","33","33","Kamhan impaiba naiza si Pidro daw si Santiago daw si Howan. Kamhan nagalised gazed ya hena-hena ni Hisos ");
INSERT INTO mmn_vpl VALUES ("MK14_34","071_14_34","MRK","14","34","34","daw nagalaong disab iza kaniran nga mabeg-at gazed ya kanaong hinawa anika daw ikapatazay di nao ini koman. Magtagad naa kamo dini. Diri di kamo magkatorog. ");
INSERT INTO mmn_vpl VALUES ("MK14_35","071_14_35","MRK","14","35","35","Pagkaro naiza ka hon-ahan minpatihapa iza ka lopa kay anhangzo iza ka Diyos nga kon mahimo ilikay naiza ya masiet nga kalised kaan. ");
INSERT INTO mmn_vpl VALUES ("MK14_36","071_14_36","MRK","14","36","36","Nagapanaba iza ka paghangzo nga Ama nao, iko ya makahimo ka tanan mga hinang. Kon somogot ko diri mo hao pag-ipapatay para ka mga sala na mga tao. Piro iko ka say magaponto kanao. ");
INSERT INTO mmn_vpl VALUES ("MK14_37","071_14_37","MRK","14","37","37","Pagkakamhan naiza paghangzo minbalik iza ka toong mga sinarigan. Nangatorog siran. Kamhan minlaong si Hisos kan Pidro pagpokaw nga Simon, daw torog di ko? Daw wara ko makaanget pagbantay iba kanao bisan isa ka lamang ka oras? ");
INSERT INTO mmn_vpl VALUES ("MK14_38","071_14_38","MRK","14","38","38","Diri kamo magpangatorog. Magpangamozo kamo ka Diyos dazaw diri kamo dag-en ka pagtintal na mga maonga. Ansogot gazed ya hinawa mazo nga diri matorog piro ya kamazong lawas maloza gazed. ");
INSERT INTO mmn_vpl VALUES ("MK14_39","071_14_39","MRK","14","39","39","Pagkakamhan kaiza minbalik si Hisos ka inkarohan naiza kazina kay ampangamozo iza ka toong Ama pag-isab singed ka toong pagpangamozo kazina. ");
INSERT INTO mmn_vpl VALUES ("MK14_40","071_14_40","MRK","14","40","40","Kamhan minbalik iza ka toong mga sakop nga tolo. Torog pen gihapon siran kay mabeg-at gazed ya mata niran. Kamhan waray sambag niran kan Hisos kay nangasipeg siran. ");
INSERT INTO mmn_vpl VALUES ("MK14_41","071_14_41","MRK","14","41","41","Pag-ikatlo naiza pagbalik ka toong mga sakop minlaong iza ka pagpokaw kaniran nga ono sang nagapahikatorog pen sa kamo gihapon? Igo di iza nga pagpahimlay mazo. Mindateng di koman ya tirmino nao ka pagkapatay. Magaedlawen di hao koman doro ka mga makasasala nga tao. ");
INSERT INTO mmn_vpl VALUES ("MK14_42","071_14_42","MRK","14","42","42","Pamangon di kamo. Selengi, waton di ngarini ya om-edlaway kanao. Mangaro di kita hinoa pagsogat kaniran. ");
INSERT INTO mmn_vpl VALUES ("MK14_43","071_14_43","MRK","14","43","43","Na, ka nagapanaba pen si Hisos mindateng di matood ya isang sinarigan nga si Hodas. Iba gihapon ya mga mataed nga tao nga magakagobot daw nagapandara ka mga lodzo daw ya mga ibonalay. Insogo siran na mga oloolo ka mga pari daw ya mga maistro ka tinoohan na mga Yodayo daw ya mga malaas. ");
INSERT INTO mmn_vpl VALUES ("MK14_44","071_14_44","MRK","14","44","44","Inpakahagdaman daan siran ni Hodas nga nagalaong nga ya tao nga pangamostahen nao pag-arek ani ya dakpen mazo. Bantazan gazed mazo pag-ated ngaro. ");
INSERT INTO mmn_vpl VALUES ("MK14_45","071_14_45","MRK","14","45","45","Na, pagkarini ni Hodas kan Hisos minlaong iza nga tinahod ong Maistro! Kamhan min-arek dazon iza kan Hisos pagpangamosta. ");
INSERT INTO mmn_vpl VALUES ("MK14_46","071_14_46","MRK","14","46","46","Kamhan indakep dazon si Hisos na mga tao. ");
INSERT INTO mmn_vpl VALUES ("MK14_47","071_14_47","MRK","14","47","47","Na, waton ya isang sakop ni Hisos nga nagahogot disab iza ka toong lodzo daw mintigbas. Kamhan nakawa dazon ya talinga na oripen na labaw nga pari. ");
INSERT INTO mmn_vpl VALUES ("MK14_48","071_14_48","MRK","14","48","48","Kamhan minlaong si Hisos ka mga gobot nga tao nga onosa wani baza kamo? Daw tolisan hao wani nga dakpen di sa mazo hao koman ka lodzo daw ibonalay? ");
INSERT INTO mmn_vpl VALUES ("MK14_49","071_14_49","MRK","14","49","49","Izang dini kaini aldaw-aldaw dizan ka dakolang lagkaw nga pangamozoanan ka Diyos nagatoldo sa hao kamazo. Kamhan wara sa mazo hao dakpa. Piro ya kaazi nao koman ani di ya pagtoman ka daan pinasoyat na Diyos mahitenged kanao. ");
INSERT INTO mmn_vpl VALUES ("MK14_50","071_14_50","MRK","14","50","50","Pagkakamhan ni Hisos paglaong kaiza namiza dazon kanangiza ya tanan mga sinarigan. Nandalagan siran pag-izaiza. ");
INSERT INTO mmn_vpl VALUES ("MK14_51","071_14_51","MRK","14","51","51","Na, may isang batan-en nga minsonod kan Hisos pagpanaw. Habel ka lamang ya toong bado. Kamhan intagenan kontana iza na mga tao ");
INSERT INTO mmn_vpl VALUES ("MK14_52","071_14_52","MRK","14","52","52","piro minlompat iza daw nabilin ya toong habel dizan kaniran. Minpahidalagan gazed iza ka waray bado. ");
INSERT INTO mmn_vpl VALUES ("MK14_53","071_14_53","MRK","14","53","53","Na, ya mga nandakep kan Hisos in-ated niran iza ngaro ka labaw nga pari. Namagkatipon di dizan ya tanan mga oloolo na mga pari daw ya mga malaas daw ya mga maistro ka tinoohan na mga Yodayo. ");
INSERT INTO mmn_vpl VALUES ("MK14_54","071_14_54","MRK","14","54","54","Na, si Pidro minpaantaw iza ka toong pagsonod kan Hisos keteb gazed ka pawa na lagkaw na labaw nga pari. Pagdateng ka ni Pidro dizan minlo-to iza iba ka mga magbantazay kay nagapanarang iza. ");
INSERT INTO mmn_vpl VALUES ("MK14_55","071_14_55","MRK","14","55","55","Na, dalem ka lagkaw nagatipon di ya mga oloolo na mga pari daw ya tanan mga maistro daw ya tanan mga malaas kay anpangita siran ka pagpamatood nga salaan si Hisos dazaw pahamtangan iza ka kamatazen piro waray sala naiza. ");
INSERT INTO mmn_vpl VALUES ("MK14_56","071_14_56","MRK","14","56","56","Mataed ya minpamakak kan Hisos piro wara mag-anika ya kanirang mga panan-og. ");
INSERT INTO mmn_vpl VALUES ("MK14_57","071_14_57","MRK","14","57","57","Kamhan mintindeg ya mga iba nga tao kay nagabakak isab siran paglaong nga ");
INSERT INTO mmn_vpl VALUES ("MK14_58","071_14_58","MRK","14","58","58","itong tao minlaong nga makageba iza ka dakolang lagkaw nga pangamozoanan ka Diyos nga hininang na mga tao. Pagkakamhan hinangen naiza koni ya bag-ong lagkaw ka tolo kang ka aldaw, waray antabang kanangiza. ");
INSERT INTO mmn_vpl VALUES ("MK14_59","071_14_59","MRK","14","59","59","Ani ini ya kanirang panan-og piro wara gazed mag-anika ya kanirang mga panan-og. ");
INSERT INTO mmn_vpl VALUES ("MK14_60","071_14_60","MRK","14","60","60","Kamhan ya labaw nga pari mintindeg dizan ka tenged niran kay nangotana iza kan Hisos nga daw waray ikasambag mo? Ono sa ya sombong niran kanmo? ");
INSERT INTO mmn_vpl VALUES ("MK14_61","071_14_61","MRK","14","61","61","Nagapahenek lamang si Hisos. Kamhan nangotana pag-isab ya labaw nga pari nga daw iko ya Maanak na Diyos nga hari nga pinili naiza? ");
INSERT INTO mmn_vpl VALUES ("MK14_62","071_14_62","MRK","14","62","62","Minsambag si Hisos nga ani gazed hao. Basta kay-an di gazed mazo hao kon makitan nga magalo-to hao dizan ka too na Diyos kay hao ya minhon-a ka bisan sin-o nga mahon-ang tao. Makitan isab mazo ya pagkarimbaba nao garing ka langit iba ya mga gabon. ");
INSERT INTO mmn_vpl VALUES ("MK14_63","071_14_63","MRK","14","63","63","Pagpakabati ka na labaw nga pari kaiton inggisi naiza ya toong kaogaringeng bado kay nazehet gazed iza nagalaong nga igo di iton. Wara di kita magkinahanglan ka dogang pen nga saksi. ");
INSERT INTO mmn_vpl VALUES ("MK14_64","071_14_64","MRK","14","64","64","Nakabati di kamo nga garboso gazed iza ka pagbakak nga iza ya Maanak na Diyos. Agon ono ya kamazong hena-hena kanangiza? Kamhan minsambag sirang tanan nga salaan gazed iza. Patazen di lamang iton. ");
INSERT INTO mmn_vpl VALUES ("MK14_65","071_14_65","MRK","14","65","65","Kamhan impamag-elban iza niran. Impamagbegketan isab ya toong mata daw impanombag iza. Kamhan minlaong siran pagsora nga tekmaen mo kon sin-o ya minlaparo kanmo! Kamhan ya mga magbantazay isab impanombag niran si Hisos. ");
INSERT INTO mmn_vpl VALUES ("MK14_66","071_14_66","MRK","14","66","66","Na, si Pidro dizan pen iza ka pawa na lagkaw na labaw nga pari. Kamhan may babazi nga binolanan na labaw nga pari nga minkadizan kanangiza. ");
INSERT INTO mmn_vpl VALUES ("MK14_67","071_14_67","MRK","14","67","67","Pagpakakita ka naiza kan Pidro nga nagapanarang nagaselengseleng gazed iza kan Pidro daw nagalaong nga iko ya nagaibaiba kan Hisos nga taga Nazarit. ");
INSERT INTO mmn_vpl VALUES ("MK14_68","071_14_68","MRK","14","68","68","Piro minlimed si Pidro nagalaong nga wara hao mahagdam. Kamhan minpasinged iza ngaro ka azihanan ka pirtahan. Kamhan mintagaok matood ya manok. ");
INSERT INTO mmn_vpl VALUES ("MK14_69","071_14_69","MRK","14","69","69","Na, pagpakakita ka na binolanan kan Pidro dizan ka pirtahan minpanaba iza pag-isab ka mga mintindeg dizan nga nagalaong nga iton nga tao ani gazed ya sakop ni Hisos. ");
INSERT INTO mmn_vpl VALUES ("MK14_70","071_14_70","MRK","14","70","70","Kamhan minlimed si Pidro pag-isab. Pagkateedteed kaiza minlaong ya mga mintindeg dizan nga iko gazed ya sakop ni Hisos kay taga Galiliya sa ko. ");
INSERT INTO mmn_vpl VALUES ("MK14_71","071_14_71","MRK","14","71","71","Basta kay minpaninhaga si Pidro paglaong nga mapatay pen hao kon bakaken hao. Inday kon sin-o itong taohana nga magalong-on mazo. ");
INSERT INTO mmn_vpl VALUES ("MK14_72","071_14_72","MRK","14","72","72","Na, pagkakamhan ni Pidro pagsambag mintagaok dazon ya manok. Ikadowa di ya pagpanagaok koman nga kahabzen. Kamhan nakataremdem di si Pidro ka inlaong ni Hisos nga ka wara pen tagaok ya manok ka ikadowa ilimed di mo hao ka katolo. Na, pagpakataremdem ka ni Pidro masara gazed ya toong paghaza kay inlimed sa naiza si Hisos. ");
INSERT INTO mmn_vpl VALUES ("MK15_1","071_15_1","MRK","15","1","1","Na, pagkamasiselem kaiza ya mga oloolo na mga pari daw ya mga malaas daw ya mga maistro ka tinoohan na mga Yodayo namagsabot siran kon onhon niran pagpapatay kan Hisos. Kamhan in-ektan niran si Hisos ka kadina dazaw iated niran ngaro kan Pilato nga gobirnador. ");
INSERT INTO mmn_vpl VALUES ("MK15_2","071_15_2","MRK","15","2","2","Kamhan nangotana si Pilato kan Hisos matod, iko ya hari na mga Yodayo? Minsambag si Hisos nga itong inlaong mo kanao hao iton. ");
INSERT INTO mmn_vpl VALUES ("MK15_3","071_15_3","MRK","15","3","3","Kamhan mataed ya ikabetangbetang kan Hisos na mga oloolo na mga pari. ");
INSERT INTO mmn_vpl VALUES ("MK15_4","071_15_4","MRK","15","4","4","Kamhan nangotana pag-isab si Pilato kan Hisos nga daw waray ikasambag mo? Daw wara ko makabati ka mga panaba niran kanmo? ");
INSERT INTO mmn_vpl VALUES ("MK15_5","071_15_5","MRK","15","5","5","Piro wara gazed si Hisos magsambag. Kamhan nabereng gazed si Pilato. ");
INSERT INTO mmn_vpl VALUES ("MK15_6","071_15_6","MRK","15","6","6","Na, kada toig ka pagpista na mga Yodayo ya batasan ni Pilato magapalogwa iza ka isang ka tao nga piniriso. Kamhan ya mga kataohan anikay magaparagbeet pagpili. ");
INSERT INTO mmn_vpl VALUES ("MK15_7","071_15_7","MRK","15","7","7","Na, dizan ka pirisohan may mga masinopaken ka gobirnador. Nakabono isab siran ka mga tao. Na, ya isa dizan kaniran ani si Barabas. ");
INSERT INTO mmn_vpl VALUES ("MK15_8","071_15_8","MRK","15","8","8","Kamhan nangarini ya mga tao kan Pilato kay anhangzo siran nagalaong nga ampabohi kami kontana ka piniriso kay ani ya batasan mo kanami kada pagkapista. ");
INSERT INTO mmn_vpl VALUES ("MK15_9","071_15_9","MRK","15","9","9","Minsambag si Pilato nga daw palogwaen mazo ya hari na mga Yodayo nga si Hiso Kristo? ");
INSERT INTO mmn_vpl VALUES ("MK15_10","071_15_10","MRK","15","10","10","Ani ini ya toong pangotana kay mahagdam iza nga nagaarig ya mga pari kan Hisos agon in-ated niran iza ngarini ka gobirnador dazaw pahamtangan iza ka kamatazen. ");
INSERT INTO mmn_vpl VALUES ("MK15_11","071_15_11","MRK","15","11","11","Kamhan ya mga oloolo na mga pari nagaapora siran ka mga tao ka pagpabohi hinoa kan Barabas. ");
INSERT INTO mmn_vpl VALUES ("MK15_12","071_15_12","MRK","15","12","12","Kamhan nangotana si Pilato pag-otro kaniran nga ono sa ya gosto mazo kaiton nga tao nga inngaranan mazo ka hari na mga Yodayo? ");
INSERT INTO mmn_vpl VALUES ("MK15_13","071_15_13","MRK","15","13","13","Kamhan namagdengan gazed ya mga tao pagsambag nga ipalansang di iton ka kros! ");
INSERT INTO mmn_vpl VALUES ("MK15_14","071_15_14","MRK","15","14","14","Nangotana si Pilato kay ono say sala naiza? Kamhan mindogang hinoa siran pagpaninggit nga ipalansang di iton ka kros! ");
INSERT INTO mmn_vpl VALUES ("MK15_15","071_15_15","MRK","15","15","15","Pasazaen kontana ni Pilato ya mga tao agon imbohian naiza si Barabas. Kamhan impalatos naiza si Hisos daw impaated iza ngaro ka mga soldaw dazaw ilansang di ka kros. ");
INSERT INTO mmn_vpl VALUES ("MK15_16","071_15_16","MRK","15","16","16","Kamhan in-ated na mga soldaw si Hisos dizan ka pawa na dakolang lagkaw na gobirnador. Kamhan inpatipon niran ya tanan mga soldaw dizan kan Hisos. ");
INSERT INTO mmn_vpl VALUES ("MK15_17","071_15_17","MRK","15","17","17","Kamhan impabadoan niran si Hisos ka mararag nga bado singed ka bado na hari piro lain. Pagkakamhan niran paglokong ka balala nga mga dogihen inhinang niran ka korona. Kamhan insokbot niran dizan ka olo ni Hisos kay nagapakahinang ka hari. ");
INSERT INTO mmn_vpl VALUES ("MK15_18","071_15_18","MRK","15","18","18","Kamhan nagasorasora siran pagsaza nagalaong nga tinahod ong hari na mga Yodayo! ");
INSERT INTO mmn_vpl VALUES ("MK15_19","071_15_19","MRK","15","19","19","Kamhan impamonalan niran ya toong olo daw impamang-elban iza. Kamhan dizan ka toong paahan nanlohod siran pagpatitahod. ");
INSERT INTO mmn_vpl VALUES ("MK15_20","071_15_20","MRK","15","20","20","Kamhan inhoboan dazon niran ka bado nga mararag kay ipabado niran pagbalik ya toong kaogaringeng bado. Kamhan in-ated iza ngaro ka gawas na siyodad kay ilansang di ka kros. ");
INSERT INTO mmn_vpl VALUES ("MK15_21","071_15_21","MRK","15","21","21","Na, ka nagapanaw pen siran dizan ka dalan may insogat niran nga si Simon nga garing ka oma pasinged ngarini ka Hirosalem. Taga Sirini iza daw ama isab iza ni Alihandro daw si Ropo. Kamhan insogo iza na mga soldaw ka pagpasili pagbathay ka kros ni Hisos. ");
INSERT INTO mmn_vpl VALUES ("MK15_22","071_15_22","MRK","15","22","22","Kamhan in-ated si Hisos doro ka dapit nga inngaranan ka Golgota. Na, ya kahologan na ngaran nga Golgota ani Ya Dapit ka Kalabira kay ani ya dapit ka pagpatay niran ka tao nga impahamtang ka kamatazen. ");
INSERT INTO mmn_vpl VALUES ("MK15_23","071_15_23","MRK","15","23","23","Pagdateng ka niran dizan impainem kontana si Hisos na mga soldaw ka bino sinaktan ka mayra nga tambal ka pagkawa ka kasakit ka paglansang piro diri iza an-inem. ");
INSERT INTO mmn_vpl VALUES ("MK15_24","071_15_24","MRK","15","24","24","Pagkakamhan kaiza inlansang si Hisos ka kros. Kamhan namagriparipa siran kon sin-oy makatag-iza ka mga bado ni Hisos. ");
INSERT INTO mmn_vpl VALUES ("MK15_25","071_15_25","MRK","15","25","25","Na, ya paglansang niran kan Hisos malabinazaw ya aldaw ka alas noybi. ");
INSERT INTO mmn_vpl VALUES ("MK15_26","071_15_26","MRK","15","26","26","May intapil niran nga sinoyat nga pasangil kan Hisos nagalaong nga si Hisos ini nga hari na mga Yodayo. ");
INSERT INTO mmn_vpl VALUES ("MK15_27","071_15_27","MRK","15","27","27","Kamhan dizan ka toong sain inlansang disab niran ya mga tolisan nga dowa siran. Ya isa dapit ka wala ni Hisos. Ya ikadowa dimbali ka toong too. ");
INSERT INTO mmn_vpl VALUES ("MK15_28","071_15_28","MRK","15","28","28","Ani ini ya pagtoman na daan pinasoyat na Diyos nagalaong nga dizan ka mga makasasala nga tao makalakip si Hisos pagpatay. Ani ini ya daan pinasoyat. ");
INSERT INTO mmn_vpl VALUES ("MK15_29","071_15_29","MRK","15","29","29","Na, ya mga namagpanlabay dizan ka kros nagabiaybiay siran kan Hisos nga nagalaong nga matod sa iton nga nagalaong ko nga makageba ko ka dakolang lagkaw nga pangamozoanan ka Diyos. Kamhan baza-baza hinangen mo pag-isab ya bag-ong lagkaw ka tolo kang ka aldaw. ");
INSERT INTO mmn_vpl VALUES ("MK15_30","071_15_30","MRK","15","30","30","Kon matood pen ya panaba mo tabangan mo koman ya kanmong kaogaringen pagtena ka kros. ");
INSERT INTO mmn_vpl VALUES ("MK15_31","071_15_31","MRK","15","31","31","Paglaonglaong na mga oloolo na mga pari nagasorasora isab siran kan Hisos nagalaong nga nakalibra iza ka mga iba nga tao piro diri iza makalibra ka toong kaogaringeng lawas. ");
INSERT INTO mmn_vpl VALUES ("MK15_32","071_15_32","MRK","15","32","32","Iko nga pinili koni na Diyos nga hari koni na mga kaliwatan ni Israil magtena ko ka kros dazaw anseleng kami daw antoo. Ani ini gihapon ya pagtamay kan Hisos na mga maistro ka tinoohan na mga Yodayo. Bisan ya dowang tolisan dizan ka sain ni Hisos maonga isab ya saba niran kan Hisos. ");
INSERT INTO mmn_vpl VALUES ("MK15_33","071_15_33","MRK","15","33","33","Na, pagkaedto di mindeglem gazed ya aldaw hangtod ka pagkabalantang na aldaw ka alas tris. ");
INSERT INTO mmn_vpl VALUES ("MK15_34","071_15_34","MRK","15","34","34","Kamhan ka hapit di alas tris mabaskeg gazed ya saba ni Hisos ka paghawag ka toong Ama ka saba nga Hinibriyo nagalaong nga kanaong Diyos, kay ono sa wani imbizaan di mo hao? ");
INSERT INTO mmn_vpl VALUES ("MK15_35","071_15_35","MRK","15","35","35","Na, ya mga minseleng dizan pagpakabati ka niran ka saba ni Hisos minlaong siran nga inhawag naiza si Iliyas nga karaang propita na Diyos. ");
INSERT INTO mmn_vpl VALUES ("MK15_36","071_15_36","MRK","15","36","36","Kamhan ya isang ka tao mindalagan iza ka pagkawa ka sizepanan. Kamhan inheem iton ka len-anan ka bino nga barato kamhan integseb ka liwaan dazaw idohol ka ba-ba ni Hisos kay dazaw makasizep. Kamhan minlaong ya tao nga tagad naa kita. Anseleng kita lamang kon ankarini si Iliyas pagtabang kanangiza. ");
INSERT INTO mmn_vpl VALUES ("MK15_37","071_15_37","MRK","15","37","37","Pagkakamhan kaiza mabaskeg gazed ya saba ni Hisos ka paghawag pag-isab. Kamhan nabogtoan dazon iza ka toong hinawa. ");
INSERT INTO mmn_vpl VALUES ("MK15_38","071_15_38","MRK","15","38","38","Kamhan dizan ka dakolang lagkaw nga pangamozoanan ka Diyos nagisi ya kortina garing daked lapos ngarimbaba ka sidsid. ");
INSERT INTO mmn_vpl VALUES ("MK15_39","071_15_39","MRK","15","39","39","Na, dizan atbang ka kros nagatindeg ya kapitan na mga soldaw. Pagpakakita naiza ka pagkapatay ni Hisos minlaong iza nga iton nga napatay iza matood ya Maanak na Diyos! ");
INSERT INTO mmn_vpl VALUES ("MK15_40","071_15_40","MRK","15","40","40","Kamhan dizan ka aro-aro may mga babazi nga naneleng isab ka pagkapatay ni Hisos. Si Mariya nga taga Magdala iton daw si Salomi daw ya iba nga Mariya nga ina na batan-en nga si Santiago daw si Hosi. ");
INSERT INTO mmn_vpl VALUES ("MK15_41","071_15_41","MRK","15","41","41","Ka waro pen si Hisos ka Galiliya nagaibaiba siran kanangiza daw nagapakaen. Waton disab ya mga mataed pen nga babazi nga nangiba kan Hisos ngarini ka Hirosalem. ");
INSERT INTO mmn_vpl VALUES ("MK15_42","071_15_42","MRK","15","42","42","Na, delem di wani. Konsilem ani aldawa ka pagpahimlay na mga Yodayo agon nagaandam di siran koman nga delem. ");
INSERT INTO mmn_vpl VALUES ("MK15_43","071_15_43","MRK","15","43","43","Kamhan si Hosi nga taga Aramatiya minkaro iza kan Pilato kay minbaid iza ka pagkawa ka lawas ni Hisos kay ilebeng. Tinahodan si Hosi kay iza isab ya sakop dizan ka hokmanan. Nagatagad isab iza ka pagkahari na Diyos. Inkawa naiza ya toong kahaldek ka pagpangazo naiza ka lawas ni Hisos kan Pilato. ");
INSERT INTO mmn_vpl VALUES ("MK15_44","071_15_44","MRK","15","44","44","Kamhan nabereng si Pilato ka pagpakabati naiza nga si Hisos patay di baza? Kamhan impakadizan naiza ya kapitan kay ampangotana nga daw patay di gazed si Hisos kon wara pen? ");
INSERT INTO mmn_vpl VALUES ("MK15_45","071_15_45","MRK","15","45","45","Minsambag ya kapitan nga patay di gazed iza. Pagkakamhan mintogot dazon si Pilato ka pagkawa kan Hosi ka lawas ni Hisos. ");
INSERT INTO mmn_vpl VALUES ("MK15_46","071_15_46","MRK","15","46","46","Pagpalit ni Hosi ka mapoti nga habel minkawa iza ka lawas ni Hisos dizan ka kros kay komotan naiza ka mga panapton nga mapoti. Kamhan inlebeng naiza doro ka hininang nga talangban nga lebnganan. Kamhan insirahan naiza ka bato. ");
INSERT INTO mmn_vpl VALUES ("MK15_47","071_15_47","MRK","15","47","47","Na, dizan disab si Mariya nga taga Magdala daw si Mariya nga ina ni Hosi kay anseleng siran kon hain dapita ya inlebgnan kan Hisos. ");
INSERT INTO mmn_vpl VALUES ("MK16_1","071_16_1","MRK","16","1","1","Na, paglabay ka na aldaw nga tigpahimlay si Mariya nga taga Magdala daw si Salomi daw si Mariya nga ina ni Santiago namalit siran ka mga pahamot kay dadhen niran ngaro ka lebnganan kay ibo-bo niran ya lawas ni Hisos. ");
INSERT INTO mmn_vpl VALUES ("MK16_2","071_16_2","MRK","16","2","2","Na, pagkamasiselem ka Dominggo pagsidlit ka na sega minpasinged siran ngaro ka lebnganan ni Hisos. ");
INSERT INTO mmn_vpl VALUES ("MK16_3","071_16_3","MRK","16","3","3","Ka wara pen siran dateng namaglaonglaong siran nga daw sin-o kombeet ya anlingan ka insira nga bato ka pirtahan na lebnganan? ");
INSERT INTO mmn_vpl VALUES ("MK16_4","071_16_4","MRK","16","4","4","Ambaza kay pagseleng niran ka pirtahan na lebeng naabri di sa baza ya pirtahan. Nalingan di matood ya insira nga bato nga dakola pagdazaw. ");
INSERT INTO mmn_vpl VALUES ("MK16_5","071_16_5","MRK","16","5","5","Pagpakaseled ka niran ka talangban nga lebnganan waton di ya batan-en nga amaama nga nagalo-to dizan ka too na mga babazi. Mapoti ya toong bado daw ataas. Kamhan nabereng gazed ya mga babazi ");
INSERT INTO mmn_vpl VALUES ("MK16_6","071_16_6","MRK","16","6","6","piro minlaong iza nga diri kamo magkabereng. Ya pangitan mazo nga si Hisos nga taga Nazarit nga inlansang ka kros, wara iza dini kay nabohi di iza garing ka mga patay. Selengi mazo. Wani ya dapit nga pinabentagan kanangiza. ");
INSERT INTO mmn_vpl VALUES ("MK16_7","071_16_7","MRK","16","7","7","Komaro naa kamo kanin Pidro nga toong mga sinarigan. Long-on mazo siran nga si Hisos anhon-a iza kamazo doro ka Galiliya. Doro kaiton makakita gazed kamo kanangiza singed ka inlaong kamazo ka mahon-a pen ka wara pen iza mapatay. Ani ini ya sogo na amaama kaniran. ");
INSERT INTO mmn_vpl VALUES ("MK16_8","071_16_8","MRK","16","8","8","Paglogwa na mga babazi dizan minpahidalagan gazed siran. Magapamidpid gazed ya kanirang lawas ka kabereng niran. Wara gazed siran magpanan-og ka bisan sin-o dizan ka kadalanan kay inkayasan siran. ");
INSERT INTO mmn_vpl VALUES ("MK16_9","071_16_9","MRK","16","9","9","Na, wani ya ikadowang panan-og mahitenged ka pagkabanhaw ni Hisos. Pagkabanhaw ni Hisos ka masiselem ka Dominggo minpakita iza paghon-a dizan kan Mariya nga taga Magdala. Na, si Mariya ani ya inharian na pitong ka maonga izang mahon-a pen kamhan impadalagan siran ni Hisos. ");
INSERT INTO mmn_vpl VALUES ("MK16_10","071_16_10","MRK","16","10","10","Pagpakakilala ni Mariya kan Hisos minlargo iza dazaw panan-ogon ya mga sakop ni Hisos. Pagdateng naiza kaniran nagahaza pen siran. ");
INSERT INTO mmn_vpl VALUES ("MK16_11","071_16_11","MRK","16","11","11","Pagpakabati niran nga nabohi di si Hisos kamhan nakitan disab ni Mariya wara siran magtoo. ");
INSERT INTO mmn_vpl VALUES ("MK16_12","071_16_12","MRK","16","12","12","Na, pagkakay-an minsogat isab si Hisos ka dowang ka sakop pagpanaw niran garing ka Hirosalem. Ya pagpakita ni Hisos kaniran diri kon singed ka pagpakita naiza kan Mariya. ");
INSERT INTO mmn_vpl VALUES ("MK16_13","071_16_13","MRK","16","13","13","Pagkakamhan kaiza minbalik siran ka Hirosalem kay panan-ogan niran ya mga iba nga sakop nga nakitan nami si Hisos. Ambaza kay diri siran antoo. ");
INSERT INTO mmn_vpl VALUES ("MK16_14","071_16_14","MRK","16","14","14","Na, pagkakay-an ka nagakaen pen ya mga sakop ni Hisos nga napolo may isa di siran, minkarini si Hisos kaniran. Kamhan minbaldeng iza kaniran kay kolang pen ya pagsarig niran. Magahi sab ya kanirang otok kay diri siran antoo ka saba na kanirang mga iba nga nakakita kan Hisos nga mabohi garing ka mga patay. ");
INSERT INTO mmn_vpl VALUES ("MK16_15","071_16_15","MRK","16","15","15","Minsogo sab iza kaniran nagalaong nga pamanaw kamo ngaro ka tanan mga tao dini ka tibolos kalibotan. Walihan mazo siran ka sindo mahitenged kanao. ");
INSERT INTO mmn_vpl VALUES ("MK16_16","071_16_16","MRK","16","16","16","Kamhan bisan sin-o ya antoo kanao daw magapabenzag diri pahamtangan iza na Diyos ka silot kay-an. Kamhan ya mga tao nga diri antoo kanao pahamtangan siran ka kamatazen kay waton pen ya kanirang mga sala. ");
INSERT INTO mmn_vpl VALUES ("MK16_17","071_16_17","MRK","16","17","17","Kamhan ya mga antoo kanao wani ya hinangen niran. Makapadalagan siran ka mga maonga pagsabi niran ka kanaong ngaran. Makapanaba isab siran ka mga lain saba nga garing ka Diyos nga diri kon inton-an niran. ");
INSERT INTO mmn_vpl VALUES ("MK16_18","071_16_18","MRK","16","18","18","Kon makaporot siran ka halas diri siran bangaen. Kon may anhilo kaniran diri siran mahilo. Kon andampa siran ka lawas na mga nabedlay maolian ya lawas na nabedlay. ");
INSERT INTO mmn_vpl VALUES ("MK16_19","071_16_19","MRK","16","19","19","Pagkakamhan ni Hisos paglaong kaniran nabohat iza ngandaked ka hela na Diyos. Kamhan minlo-to iza dizan ka too na Diyos. ");
INSERT INTO mmn_vpl VALUES ("MK16_20","071_16_20","MRK","16","20","20","Kamhan ya toong mga sakop namagtaligpanaw siran kay minwali siran ka tanan mga tao. Mintabang si Hisos kaniran. Imparig-en sab naiza ya pagwali niran ka mga timaan.");
INSERT INTO mmn_vpl VALUES ("LK1_1","072_1_1","LUK","1","1","1","Kan Tiyopilo ini nga kanaong higara, Mataed ya mga minsoyat mahitenged ka mga inhinang ni Hiso Kristo ka dini pen iza ka kalibotan. ");
INSERT INTO mmn_vpl VALUES ("LK1_2","072_1_2","LUK","1","2","2","Ya mga minhon-a pagsaksi ka toong mga inhinang siran isab ya mindara ka toong sindo ngarini kanta. ");
INSERT INTO mmn_vpl VALUES ("LK1_3","072_1_3","LUK","1","3","3","Na, dogay ya pagsosi nao ka kanirang sindo. Kamhan naazak isab hao nga ansoyat kanmo mahitenged kan Hisos sokad ka pagkatao naiza keteb ka pagkandaked naiza ");
INSERT INTO mmn_vpl VALUES ("LK1_4","072_1_4","LUK","1","4","4","dazaw mahagdam iko nga matood gazed ya inton-an mo mahitenged kan Hiso Kristo. ");
INSERT INTO mmn_vpl VALUES ("LK1_5","072_1_5","LUK","1","5","5","Na, kawandini pen ka paghari pen ni Hirodis ka lopa nga Yoda may isang tao nga si Zakariyas. Pari iza daw kaliwat sab iza ni Abiyas nga karaang pari na mga Yodayo. Kamhan ya ngaran na toong asawa si Ilizibit. Kaliwat iza na primirong pari na mga Yodayo si Aron ya ngaran. ");
INSERT INTO mmn_vpl VALUES ("LK1_6","072_1_6","LUK","1","6","6","Beetan gazed si Zakariyas daw si Ilizibit. Nagatoman gazed siran ka mga sogo na Diyos. ");
INSERT INTO mmn_vpl VALUES ("LK1_7","072_1_7","LUK","1","7","7","Piro waray maanak niran kay diri makapanganak si Ilizibit. Kamhan mga malaas disab sirang dowa. ");
INSERT INTO mmn_vpl VALUES ("LK1_8","072_1_8","LUK","1","8","8","Na, izang aldaw dizan ka lagkaw nga pangamozoanan ka Diyos nagatoman si Zakariyas ka toong katengdanan ka pagkapari. ");
INSERT INTO mmn_vpl VALUES ("LK1_9","072_1_9","LUK","1","9","9","Kamhan inhinang naiza daw ya mga iba nga pari ya batasan niran nga namagriparipa kon sin-oy makaseled ka ikadowang kowarto dazaw ansonog ka parina. Ya ngaran naiton nga kowarto ani ya Labaw nga Tinahodan nga Hel-anan na Ginoo. Kamhan si Zakariyas ani ya makaseled koman. ");
INSERT INTO mmn_vpl VALUES ("LK1_10","072_1_10","LUK","1","10","10","Dimbali ka logwa nagapangamozo ya mga mataed nga Yodayo kay ani ya batasan niran kada aldaw ka oras ka pagsonog na isa ka parina dalem. ");
INSERT INTO mmn_vpl VALUES ("LK1_11","072_1_11","LUK","1","11","11","Ka nagasonog pen si Zakariyas ka parina waton di baza ya sinogo nga garing ka Ginoo nga nagatindeg dizan ka too na lamisahay nga betanganan ka sinonog nga parina. ");
INSERT INTO mmn_vpl VALUES ("LK1_12","072_1_12","LUK","1","12","12","Kamhan nagalised ya hena-hena ni Zakariyas daw nabereng kon sin-o iton? ");
INSERT INTO mmn_vpl VALUES ("LK1_13","072_1_13","LUK","1","13","13","Kamhan minlaong ya sinogo nga Zakariyas, diri ko magkahaldek kay insambag di na Diyos ya kanmong inhangzo. An-anak ya kanmong asawa ka maimpis nga amaama. Ngaranan mo iza kan Howan. ");
INSERT INTO mmn_vpl VALUES ("LK1_14","072_1_14","LUK","1","14","14","Kay-an ka pagkatao naiza dakola ya kasaza mo daw kanmong kaibahan. ");
INSERT INTO mmn_vpl VALUES ("LK1_15","072_1_15","LUK","1","15","15","Kay tinahodan gazed iza dizan ka Ginoo. Diri iza an-inem ka bino daw bisan ono ya makahebeg. Sokad ka pagkatao naiza harian iza na Madazaw nga Ispirito nga garing ka Diyos. ");
INSERT INTO mmn_vpl VALUES ("LK1_16","072_1_16","LUK","1","16","16","Pabaliken sab naiza ya mga mataed na kaliwatan ni Israil ka Ginoo nga kanirang Diyos kay mga masinopaken gazed siran ka Diyos. ");
INSERT INTO mmn_vpl VALUES ("LK1_17","072_1_17","LUK","1","17","17","Iza nga si Howan anhon-a iza kan Hiso Kristo dazaw an-andam iza ka toong pagdateng. Kamhan may dakolang gahem naiza singed ka gahem ni Iliyas nga karaang propita na Diyos dazaw ipahosay ya mga ama ka kanirang mga maanak. Pabaliken sab naiza ya mga masinopaken ka paghena-hena ka madazaw. Kamhan an-andam siran ka kanirang hinawa ka pagdateng ni Hiso Kristo. Ani ini ya inlaong na sinogo kan Zakariyas. ");
INSERT INTO mmn_vpl VALUES ("LK1_18","072_1_18","LUK","1","18","18","Kamhan minsambag si Zakariyas nga inday kon matood ya inlaong mo kanao kay malaas di gazed hao daw ya kanaong asawa. ");
INSERT INTO mmn_vpl VALUES ("LK1_19","072_1_19","LUK","1","19","19","Minsambag ya sinogo nga hao si Gabril. Dizan ka Diyos nagatindeg hao. Insogo hao ka pagkarini kanmo kay ipakahagdam ya madazaw nga balita. ");
INSERT INTO mmn_vpl VALUES ("LK1_20","072_1_20","LUK","1","20","20","Piro maamang gazed iko keteb ka pagtoman naini nga inlaong nao kay wara ko magtoo kanao. Matoman gazed ini nga tanan ka hostong panahon. Ani ini ya insambag ni Gabril. ");
INSERT INTO mmn_vpl VALUES ("LK1_21","072_1_21","LUK","1","21","21","Na, bali ka logwa nagatagad pen ya mga tao kan Zakariyas. Nabereng gazed siran kon ono ya inkadogazan naiza dalem ka ikadowang kowarto. ");
INSERT INTO mmn_vpl VALUES ("LK1_22","072_1_22","LUK","1","22","22","Ka nagatagad pen siran minlogwa si Zakariyas piro wara iza makapanaba kaniran kay naamang di iza. Kamhan makasabot ya mga tao nga may nakitan ni Zakariyas nga garing ka Diyos kazina ka pagkapari naiza dalem ka ikadowang kowarto. Kamhan minsinyas lamang si Zakariyas ka mga tao kay diri iza makapanaba. ");
INSERT INTO mmn_vpl VALUES ("LK1_23","072_1_23","LUK","1","23","23","Pagtiwas ni Zakariyas ka toong pagkapari dizan ka dakolang lagkaw na Diyos min-oli iza ka toong lagkaw. ");
INSERT INTO mmn_vpl VALUES ("LK1_24","072_1_24","LUK","1","24","24","Ka wara pen madogay minkabdes matood ya toong asawa nga si Ilizibit. Kamhan nagahela-hela si Ilizibit keteb ka limang ka bolan. Nagalaong iza nga ");
INSERT INTO mmn_vpl VALUES ("LK1_25","072_1_25","LUK","1","25","25","nalooy gazed ya Ginoo kanao kay keteb koman dakola ya kanaong kasipeg kay wara hao makapanganak piro inkawa di na Diyos ya kanaong kasipeg. ");
INSERT INTO mmn_vpl VALUES ("LK1_26","072_1_26","LUK","1","26","26","Na, enem di nga ka bolan ya pagkabdes ni Ilizibit. Kamhan insogo na Diyos si Gabril nga taga langit ka pagkaro ka longsod nga Nazarit doro ka Galiliya. ");
INSERT INTO mmn_vpl VALUES ("LK1_27","072_1_27","LUK","1","27","27","Kay dizan may isang daraga nga asawhenen na amaama nga si Hosi nga kaliwat ni Dabid nga karaang hari na mga Yodayo. Kamhan ya ngaran naiton nga daraga si Mariya. ");
INSERT INTO mmn_vpl VALUES ("LK1_28","072_1_28","LUK","1","28","28","Pagdateng ni Gabril dizan kan Mariya minlaong iza nga magmalinawen ko. Dini ya Diyos iba kanmo. Kamhan minpanarangin gazed iza kanmo. ");
INSERT INTO mmn_vpl VALUES ("LK1_29","072_1_29","LUK","1","29","29","Pagpakabati ni Mariya nagalised gazed ya toong hena-hena. Kamhan nagalaong iza ka toong hena-hena nga ono sa ini nga inlaong naiza kanao? ");
INSERT INTO mmn_vpl VALUES ("LK1_30","072_1_30","LUK","1","30","30","Minsambag ya sinogo nga Mariya, diri ko magkahaldek kay inkaloy-an ko na Diyos. ");
INSERT INTO mmn_vpl VALUES ("LK1_31","072_1_31","LUK","1","31","31","Ankabdes iko kaan. Kamhan an-anak iko ka maimpis nga amaama. Ngaranan mo iza kan Hisos. ");
INSERT INTO mmn_vpl VALUES ("LK1_32","072_1_32","LUK","1","32","32","Dakola ya toong ngaran kay iza ya matood nga Maanak na Diyos nga pinakalabaw. Tagan iza na Ginoong Diyos ka lo-toanan ni Dabid ka paghari ka mga tao kay si Dabid ani ya apo ni Hiso Kristo. ");
INSERT INTO mmn_vpl VALUES ("LK1_33","072_1_33","LUK","1","33","33","Anhari iza ka mga kaliwatan ni Hakob kawanihen ka. Waray pagkatiwas na toong paghari ka mga tao. Ani ini ya inlaong ni Gabril. ");
INSERT INTO mmn_vpl VALUES ("LK1_34","072_1_34","LUK","1","34","34","Kamhan minsambag si Mariya nga ono sa ya panaba mo kanao kay wara pen sa hao maminze? ");
INSERT INTO mmn_vpl VALUES ("LK1_35","072_1_35","LUK","1","35","35","Minsambag si Gabril nga harian iko kaan na Madazaw nga Ispirito. Kamhan ya pinakalabaw nga Diyos anhatag iza ka kadazaw kanmo. Ya maimpis nga kanmong ianak waray sala naiza kay iza ya matood nga Maanak na Diyos. ");
INSERT INTO mmn_vpl VALUES ("LK1_36","072_1_36","LUK","1","36","36","Wani pen ya ilaong nao kanmo nga ya kanmong lomon nga si Ilizibit nga wara makapanganak minkabdes isab iza ka maanak nga amaama. Bisan malaas di iza ikaenem di koman nga ka bolan ya toong kinabdesen. ");
INSERT INTO mmn_vpl VALUES ("LK1_37","072_1_37","LUK","1","37","37","Kay ya Diyos may gahem naiza ka paghinang ka bisan ono. ");
INSERT INTO mmn_vpl VALUES ("LK1_38","072_1_38","LUK","1","38","38","Minsambag si Mariya nga wani hao nga sogoonon na Ginoo. Gosto hao nga matoman ya inlaong mo kanao. Kamhan minpanaw ya sinogo. ");
INSERT INTO mmn_vpl VALUES ("LK1_39","072_1_39","LUK","1","39","39","Ka wara pen madogay min-andam si Mariya ka toong panaw. Kamhan minpanaw iza pagdali ngaro ka longsod tenged ka mga bobong doro ka Yoda. ");
INSERT INTO mmn_vpl VALUES ("LK1_40","072_1_40","LUK","1","40","40","Pagdateng naiza doro minpanik iza dizan ka lagkaw nin Zakariyas. Kamhan nagasabi iza kan Ilizibit. ");
INSERT INTO mmn_vpl VALUES ("LK1_41","072_1_41","LUK","1","41","41","Pagpakabati ka ni Ilizibit ka saba ni Mariya minlihok dazon ya maimpis dalem ka toong tinai. Kamhan inharian si Ilizibit na Madazaw nga Ispirito nga garing ka Diyos. ");
INSERT INTO mmn_vpl VALUES ("LK1_42","072_1_42","LUK","1","42","42","Kamhan mabaskeg ya toong saba paglaong nga Mariya, dini ka tanan mga babazi iko ya madazaw. Madazaw isab ya maimpis nga kanmong ianak. ");
INSERT INTO mmn_vpl VALUES ("LK1_43","072_1_43","LUK","1","43","43","Kamhan masazaen gazed hao kay minbisita kanao ya ina na kanaong Ginoo! ");
INSERT INTO mmn_vpl VALUES ("LK1_44","072_1_44","LUK","1","44","44","Pagpakabati nao ka pagsabi mo kanao kazina minlihok dazon ka kasaza ya maimpis dalem ka kanaong tinai. ");
INSERT INTO mmn_vpl VALUES ("LK1_45","072_1_45","LUK","1","45","45","Mariya, panaranginan gazed iko na Diyos kay mintoo iko nga tomanen gazed naiza ya toong panaba kanmo. ");
INSERT INTO mmn_vpl VALUES ("LK1_46","072_1_46","LUK","1","46","46","Minsambag si Mariya nga sazaen gazed nao ya Ginoo. ");
INSERT INTO mmn_vpl VALUES ("LK1_47","072_1_47","LUK","1","47","47","Sazaen nao ya Diyos nga kanaong Manlolowas. ");
INSERT INTO mmn_vpl VALUES ("LK1_48","072_1_48","LUK","1","48","48","Kay bisan pobri hao nagataremdem iza kanao nga toong sogoonon. Sokad koman dini ka pagsonodsonod ka tanan mga kaliwatan na mga tao antaremdem siran kanao nagalaong nga hao gazed ya impanaranginan na Diyos ka madazaw. ");
INSERT INTO mmn_vpl VALUES ("LK1_49","072_1_49","LUK","1","49","49","Kay iza nga labaw ka gahem mintabang gazed iza kanao. Madazaw gazed ya toong ngaran. ");
INSERT INTO mmn_vpl VALUES ("LK1_50","072_1_50","LUK","1","50","50","Dini ka mga sonodsonod nga kaliwatan na mga tao inkaloy-an naiza ya tanan mga mintahod kanangiza. ");
INSERT INTO mmn_vpl VALUES ("LK1_51","072_1_51","LUK","1","51","51","Inpakita di naiza nga iza ya gamhanan pagpabelagbelag naiza ka mga garboso. ");
INSERT INTO mmn_vpl VALUES ("LK1_52","072_1_52","LUK","1","52","52","Inpaebes naiza ya mga hari. Kamhan inpahari naiza ya mga labing obos nga tao. ");
INSERT INTO mmn_vpl VALUES ("LK1_53","072_1_53","LUK","1","53","53","Dini ka mga binengtas nga tao may inhatag naiza nga madazaw. Kamhan inpapanaw naiza ya mga dato nga waray dara niran. ");
INSERT INTO mmn_vpl VALUES ("LK1_54","072_1_54","LUK","1","54","54","Intoman naiza ya toong saad ka kantang mga karaan. Kamhan mintabang iza kan Abraham nga toong sogoonon. ");
INSERT INTO mmn_vpl VALUES ("LK1_55","072_1_55","LUK","1","55","55","Nakataremdem iza ka pagtabang kan Abraham daw ya tanan mga kaliwatan naiza kawanihen ka! Ani ini ya insaza ni Mariya ka Diyos. ");
INSERT INTO mmn_vpl VALUES ("LK1_56","072_1_56","LUK","1","56","56","Kamhan dizan kan Ilizibit minhela iza ka hapit magtolong ka bolan. Kamhan min-oli iza. ");
INSERT INTO mmn_vpl VALUES ("LK1_57","072_1_57","LUK","1","57","57","Na, mindateng di ya tirmino ni Ilizibit ka pag-anak. Kamhan min-anak matood iza ka amaama. ");
INSERT INTO mmn_vpl VALUES ("LK1_58","072_1_58","LUK","1","58","58","Kamhan nakabati ya toong mga songbalay daw mga lomon nga inkaloy-an gazed na Ginoo si Ilizibit agon namagsaza sirang tanan iba kanangiza. ");
INSERT INTO mmn_vpl VALUES ("LK1_59","072_1_59","LUK","1","59","59","Pagdateng ka ikawalo nga aldaw inhinang niran ya bata ka batasan niran nga impatori. Insangay sab niran kontana ka ngaran na ama nga si Zakariyas. ");
INSERT INTO mmn_vpl VALUES ("LK1_60","072_1_60","LUK","1","60","60","Piro minlaong ya toong ina nga diri! Kay si Howan ya inngaran o kanangiza. ");
INSERT INTO mmn_vpl VALUES ("LK1_61","072_1_61","LUK","1","61","61","Minsambag siran kay ono sa? Waray inngaranan kan Howan nga lomon mo. ");
INSERT INTO mmn_vpl VALUES ("LK1_62","072_1_62","LUK","1","62","62","Kamhan minsinyas siran pagpangotana ka ama na bata kon ono ya inngaran. ");
INSERT INTO mmn_vpl VALUES ("LK1_63","072_1_63","LUK","1","63","63","Kamhan minsinyas iza kaniran dazaw ihatag ya soyatanan. Kamhan minsoyat iza nga si Howan ya toong ngaran. Kamhan nabereng gazed sirang tanan. ");
INSERT INTO mmn_vpl VALUES ("LK1_64","072_1_64","LUK","1","64","64","Kamhan nakalitok dazon si Zakariyas. Nakapanaba gazed iza ka toong pagsaza ka Diyos. ");
INSERT INTO mmn_vpl VALUES ("LK1_65","072_1_65","LUK","1","65","65","Pagpaniid na kanirang kaibahan nabereng sirang tanan. Kamhan dizan ka tanan kabobongan ka Yoda minlibot gazed ya panan-og mahitenged ka pagkatao ni Howan. ");
INSERT INTO mmn_vpl VALUES ("LK1_66","072_1_66","LUK","1","66","66","Kamhan nagahena-hena ya mga manalingahay nga dakola ya ngaran naini nga bata kay-an kay aligarahen gazed iza na Ginoo. ");
INSERT INTO mmn_vpl VALUES ("LK1_67","072_1_67","LUK","1","67","67","Kamhan si Zakariyas nga ama na bata inharian iza na Madazaw nga Ispirito nga garing ka Diyos. Kamhan minpasabot iza kaniran ka matood nga garing ka Diyos nagalaong nga ");
INSERT INTO mmn_vpl VALUES ("LK1_68","072_1_68","LUK","1","68","68","sazaen ta ya Ginoo kay iza ya Diyos na mga kaliwatan ni Israil. Kay iza ya minbisita kanta dazaw antabang. ");
INSERT INTO mmn_vpl VALUES ("LK1_69","072_1_69","LUK","1","69","69","Inhatag kita naiza ka Manlolowas nga labaw ka gahem. Kamhan iza disab ya kaliwat ni Dabid nga karaang sogoonon na Diyos. ");
INSERT INTO mmn_vpl VALUES ("LK1_70","072_1_70","LUK","1","70","70","Kawandini pen intandeg na Diyos ya hinawa na toong mga propita dazaw ");
INSERT INTO mmn_vpl VALUES ("LK1_71","072_1_71","LUK","1","71","71","siran ya ampakahagdam kanta daan nga malibri kita ka kantang mga kaaway nga mga minkontara kanta. ");
INSERT INTO mmn_vpl VALUES ("LK1_72","072_1_72","LUK","1","72","72","Nagatoman di iza ka toong saad ka kantang karaan nga ipakita naiza ya toong kalooy kaniran daw ya kanirang mga kaliwatan. ");
INSERT INTO mmn_vpl VALUES ("LK1_73","072_1_73","LUK","1","73","73","Kawandini pen minpakamatood ya Diyos ka toong saad kan Abraham nga nagalaong nga ");
INSERT INTO mmn_vpl VALUES ("LK1_74","072_1_74","LUK","1","74","74","iza ya antabang kanta dazaw malibri kita ka kantang mga kaaway. Kamhan diri kita mahaldek ka pag-alagad ka Diyos. ");
INSERT INTO mmn_vpl VALUES ("LK1_75","072_1_75","LUK","1","75","75","Antoman sab kita ka mga balaed na Diyos keteb ka pagkapatay nita kay iza ya antabang kanta ka pagbineetan. ");
INSERT INTO mmn_vpl VALUES ("LK1_76","072_1_76","LUK","1","76","76","Kamhan indogangan ni Zakariyas paglaong nga iko nga maanak nao, ngaranan ko ka propita na Diyos nga pinakalabaw kay iko ya anhon-a ka Ginoo dazaw an-andam iko ka toong pagdateng. ");
INSERT INTO mmn_vpl VALUES ("LK1_77","072_1_77","LUK","1","77","77","Iko ya ampakahagdam ka toong mga sakop nga domatengay di ya kanirang Manlolowas dazaw malibri siran ka silot ka kanirang mga sala. ");
INSERT INTO mmn_vpl VALUES ("LK1_78","072_1_78","LUK","1","78","78","Kay Maloloy-on gazed ya kantang Diyos. Ya pagdateng ni Hisos singed iton ka pagsirak na sega ka pagkamasiselem. ");
INSERT INTO mmn_vpl VALUES ("LK1_79","072_1_79","LUK","1","79","79","Kay pawaan naiza ya hena-hena na mga tao nga nagahela ka kadeglem daw magakahaldek ka pagkapatay niran. Sindoan naiza kita dazaw malinaw ya kantang hinawa. Ani ini ya mga panaba ni Zakariyas ka pagkatao na toong maanak nga si Howan. ");
INSERT INTO mmn_vpl VALUES ("LK1_80","072_1_80","LUK","1","80","80","Kamhan minsolig ya bata. Marig-en isab ya toong pagsarig ka Diyos. Kamhan nagahela iza doro ka kamingawan keteb ka pagsogod naiza ka pagsindo ka mga Yodayo nga mga kaliwatan ni Israil. ");
INSERT INTO mmn_vpl VALUES ("LK2_1","072_2_1","LUK","2","1","1","Wani ya panan-og mahitenged ka pagkatao ni Hiso Kristo. Na, ka wara pen matao si Hisos may labaw nga hari nga si Sisar Agosto ya ngaran daw taga Roma iza. Kamhan may sogo naiza nga ipalista ya ngaran na tanan mga Yodayo dazaw ambazad siran ka bohis. ");
INSERT INTO mmn_vpl VALUES ("LK2_2","072_2_2","LUK","2","2","2","Primirong lista iton ka pagkagobirnador ni Kiriniyo ka lopa nga Siriya. ");
INSERT INTO mmn_vpl VALUES ("LK2_3","072_2_3","LUK","2","3","3","Kamhan namanaw ya tanan mga tao ngaro ka mga longsod nga tagsa tagsa kaniran nga nataohan na kanirang mga ama kay anpalista siran pag-izaiza. ");
INSERT INTO mmn_vpl VALUES ("LK2_4","072_2_4","LUK","2","4","4","Kamhan dizan ka Nazarit nga longsod doro ka lopa nga Galiliya minpanaw si Hosi ngaro ka Bitlihim nga longsod doro ka lopa nga Yoda kay ya Bitlihim ani ya nataohan na toong apo nga si Dabid nga karaang hari. ");
INSERT INTO mmn_vpl VALUES ("LK2_5","072_2_5","LUK","2","5","5","Doro di si Hosi magpalista ka toong ngaran daw si Mariya nga toong asawhenen nga nakabdesan na Madazaw nga Ispirito nga garing ka Diyos. ");
INSERT INTO mmn_vpl VALUES ("LK2_6","072_2_6","LUK","2","6","6","Na, ka dizan pen siran mindateng di ya tirmino ni Mariya ka pag-anak. ");
INSERT INTO mmn_vpl VALUES ("LK2_7","072_2_7","LUK","2","7","7","Sirado gazed ya kolanganan kamhan dizan ka sironganan ka mga baka min-anak si Mariya ka panganay nga amaama. Pagpotos naiza ka bata ka lampin inpabentag dazon dizan ka pakananan na baka kay wara di ya logar dizan ka kolanganan. ");
INSERT INTO mmn_vpl VALUES ("LK2_8","072_2_8","LUK","2","8","8","Na, dizan ka samsamanan tenged ka Bitlihim may mga nagabantay ka mga karniro ka pagkakahabzen. ");
INSERT INTO mmn_vpl VALUES ("LK2_9","072_2_9","LUK","2","9","9","Kahabzen pen ngani dizan kaniran waton di baza ya isang sinogo nga garing ka Diyos. Kamhan nasirawan gazed siran ka kapawa nga garing daked ka Diyos. Kamhan nabereng gazed siran kon sin-o iton? ");
INSERT INTO mmn_vpl VALUES ("LK2_10","072_2_10","LUK","2","10","10","Kamhan minlaong ya sinogo kaniran nga diri kamo magkahaldek kay nagadara hao ka balita nga madazaw nga makasaza gazed ka tanan mga tao. ");
INSERT INTO mmn_vpl VALUES ("LK2_11","072_2_11","LUK","2","11","11","Kay natao di ya kamazong Manlolowas nga si Kristo nga Ginoo. Kamhan ya nataohan naiza nga bata ani ya longsod nga Bitlihim nga nataohan ni Dabid nga karaang hari. ");
INSERT INTO mmn_vpl VALUES ("LK2_12","072_2_12","LUK","2","12","12","Na, wani ya makilalhan kaiton nga bata. Pangitan mazo iza nga inpotos ka lampin daw nagabentag dizan ka pakananan na baka. Ani ini ya inlaong na sinogo dizan ka mga nagabantay ka mga karniro. ");
INSERT INTO mmn_vpl VALUES ("LK2_13","072_2_13","LUK","2","13","13","Kamhan nagatipon dazon ya mga mataed nga tagalangit dizan ka sinogo. Nagapahisaza siran ka Diyos nga nagalaong nga ");
INSERT INTO mmn_vpl VALUES ("LK2_14","072_2_14","LUK","2","14","14","sazaen ta ya Diyos nga nagahela daked ka langit kay palinawen naiza ya hinawa na mga mataed nga tao dimbaba ka kalibotan. Nakaangay gazed iza kaniran. Ani ini ya insaza niran. ");
INSERT INTO mmn_vpl VALUES ("LK2_15","072_2_15","LUK","2","15","15","Kamhan min-oli siran ngandaked ka langit. Kamhan namagsabot ya mga magbantazay ka mga karniro nga mamanaw di kita mazo ngaro ka longsod nga Bitlihim kay pangitan ta ya bata nga impanan-og kanta na sinogo nga garing ka Diyos. ");
INSERT INTO mmn_vpl VALUES ("LK2_16","072_2_16","LUK","2","16","16","Kamhan minpanaw dazon siran. Pagdateng niran doro ka nataohan na bata nakitan niran si Mariya daw si Hosi daw ya bata. Impabentag di matood ya maimpis dalem ka pakananan na baka. ");
INSERT INTO mmn_vpl VALUES ("LK2_17","072_2_17","LUK","2","17","17","Kamhan impanan-og niran ya pakahagdam na Diyos kaniran mahitenged kaiton nga bata. ");
INSERT INTO mmn_vpl VALUES ("LK2_18","072_2_18","LUK","2","18","18","Nabereng gazed ya mga manalingahay ka panan-og na mga magbantazay ");
INSERT INTO mmn_vpl VALUES ("LK2_19","072_2_19","LUK","2","19","19","piro inbetang ni Mariya ya kanirang mga panaba dalem ka toong hena-hena. ");
INSERT INTO mmn_vpl VALUES ("LK2_20","072_2_20","LUK","2","20","20","Kamhan nangoli ya mga magbantazay ka kanirang mga bohi. Nagakanta siran ka pagsaza ka Ginoo. Minsaza sab siran ka kanirang nakitan hasta ya kanirang nabatian garing ka sinogo na Diyos. ");
INSERT INTO mmn_vpl VALUES ("LK2_21","072_2_21","LUK","2","21","21","Na, pagdateng ka ikawalong ka aldaw ka pagpatori niran ka bata inngaranan matood kan Hisos kay ani ya insogo ni Gabril kan Mariya ka wara pen iza makabdesi. ");
INSERT INTO mmn_vpl VALUES ("LK2_22","072_2_22","LUK","2","22","24","Pagkadogay kaiza minpanaw si Mariya daw si Hosi ngaro ka siyodad nga Hirosalim. Indara niran si Hisos kay ipakita iza ka pari dizan ka dakolang lagkaw nga pangamozoanan ka Diyos dazaw isarig iza ka Diyos. Ani ini ya inhinang niran kay kawandini pen impasoyat na Diyos kan Moysis nagalaong nga ya bata nga panganay isarig iza ka Diyos. Kamhan iza gazed ya antoman ka mga balaed na Diyos. Inhatag sab nin Mariya ka pari ya isang ka paris nga limokon dazaw ihalad naiza ka Diyos kay balaed ini nagalaong nga ya babazi nga bag-o pen min-anak kinahanglan ipahalad ya isang ka paris nga limokon kon ya dowang bolos nga salapati ka Diyos dazaw mahinglo di ya lawas na babazi dizan ka pagseleng na Diyos. ");
INSERT INTO mmn_vpl VALUES ("LK2_25","072_2_25","LUK","2","25","25","Na, dizan ka Hirosalem may tao inngaranan kan Simiyon. Nagatoman gazed iza ka mga sogo na Diyos. Madazaw gazed ya pagpangalagad ka Diyos. Nagatagad iza ka pagtabang na Diyos ka mga kaliwatan ni Israil. Inharian sab iza na Madazaw nga Ispirito nga garing ka Diyos. ");
INSERT INTO mmn_vpl VALUES ("LK2_26","072_2_26","LUK","2","26","26","Minpakahagdam sab ya Ispirito kan Simiyon nga diri iza mapatay keteb ka pagkita naiza kan Kristo nga hari nga pinili na Diyos. ");
INSERT INTO mmn_vpl VALUES ("LK2_27","072_2_27","LUK","2","27","27","Na, pagtandeg na Ispirito ka hinawa ni Simiyon minseled di iza ka dakolang lagkaw nga pangamozoanan ka Diyos. Kamhan mindateng disab ya ginikanan ni Hisos nga nagadara ka kanirang maimpis kay inhinang niran ya batasan niran ka pagtoman ka sogo na Diyos. ");
INSERT INTO mmn_vpl VALUES ("LK2_28","072_2_28","LUK","2","28","28","Kamhan ingeel ni Simiyon si Hisos daw nagapasalamat iza ka Diyos nga nagalaong nga ");
INSERT INTO mmn_vpl VALUES ("LK2_29","072_2_29","LUK","2","29","29","Ginoo, hatagan mo hao nga kanmong sogoonon ka kalinaw ka kanaong pagkapatay kay mintoman di ya saad mo kanao ");
INSERT INTO mmn_vpl VALUES ("LK2_30","072_2_30","LUK","2","30","30","kay minkita di gazed hao ka Manlolowas nga makalibri ka kanmong mga sakop ka silot ka kanirang mga sala. ");
INSERT INTO mmn_vpl VALUES ("LK2_31","072_2_31","LUK","2","31","31","Iko ya min-andam ka toong pagdateng dini ka tanan mga tao. ");
INSERT INTO mmn_vpl VALUES ("LK2_32","072_2_32","LUK","2","32","32","Dizan ka mga tao nga diri kon Yodayo ilawan ni Hisos ya dalan nga minpasinged ngaro ka matood nga Diyos. Dini kanta nga mga Yodayo dakola ya kantang ngaran kay-an kay si Hisos ani ya kantang angay nga Yodayo. Ani ini ya inlaong ni Simiyon. ");
INSERT INTO mmn_vpl VALUES ("LK2_33","072_2_33","LUK","2","33","33","Kamhan nabereng gazed ya ama daw ina ni Hisos ka inlaong ni Simiyon mahitenged kan Hisos. ");
INSERT INTO mmn_vpl VALUES ("LK2_34","072_2_34","LUK","2","34","34","Kamhan minpanarangin si Simiyon kaniran. Kamhan dizan kan Mariya nga ina na bata minlaong iza nga ining bataa ani ya impili na Diyos. Iza ya anpabelag ka isa daw isa nga mga mataed nga Yodayo. Ya mga ampasakop kanangiza mahatagan siran ka bag-ong kinabohi nga diri mawara. Ya mga ansopak kanangiza pakarohon siran ka silotanan nga diri mapareng nga laga. Bisan iza ya pinili na Diyos sopaken iza na mga mataed nga tao. ");
INSERT INTO mmn_vpl VALUES ("LK2_35","072_2_35","LUK","2","35","35","Dizan kanangiza impakita ya kanirang mga hena-hena nga tinago. Kamhan, Mariya, masakit gazed ya kanmong beet kay-an singed ka doltan ya kanmong debdeb ka lodzo pagsopak na mga tao kan Hisos. Ani ini ya inlaong ni Simiyon. ");
INSERT INTO mmn_vpl VALUES ("LK2_36","072_2_36","LUK","2","36","36","Kamhan dizan disab may babazi nga propita na Diyos. Si Ana ya ngaran. Ya toong ama si Panwil nga kaliwat ni Asir. Malaas di gazed si Ana. Pitong ka toig ya toong pagkaminze. ");
INSERT INTO mmn_vpl VALUES ("LK2_37","072_2_37","LUK","2","37","37","Kamhan nabalo iza. Kamhan kawaloan nga ka toig may opat ya toong pagkamalaas. Kada aldaw daw kada kahabzen nagahela si Ana dizan ka dakolang lagkaw nga pangamozoanan ka Diyos kay nagapangalagad iza ka Diyos. Ya batasan naiza nagaanget iza ka makaen dazaw ampangamozo iza ka Diyos. ");
INSERT INTO mmn_vpl VALUES ("LK2_38","072_2_38","LUK","2","38","38","Na, ka nagapanaba pen si Simiyon kan Mariya mindateng disab si Ana. Kamhan nagapasalamat iza ka Diyos kay natao di si Hisos. Kamhan dizan ka mga Yodayo nga nagatagad ka pagpabalik na Diyos kaniran ka paghari ka kanirang siyodad nga Hirosalem minpanan-og si Ana mahitenged kan Hisos. ");
INSERT INTO mmn_vpl VALUES ("LK2_39","072_2_39","LUK","2","39","39","Pagkakamhan ni Hosi daw si Mariya pagtoman ka mga sogo na Ginoo nangoli siran ka Nazarit doro ka Galiliya. ");
INSERT INTO mmn_vpl VALUES ("LK2_40","072_2_40","LUK","2","40","40","Kamhan minsolig ya bata nga si Hisos. Mabaskeg ya toong lawas daw dakola isab ya toong kahagdamanan kay impanaranginan iza na Diyos ka madazaw. ");
INSERT INTO mmn_vpl VALUES ("LK2_41","072_2_41","LUK","2","41","41","Na, kada toig minbalik ya ginikanan ni Hisos ka siyodad nga Hirosalem kay mamista siran. Kamhan inhinang na mga Yodayo ya batasan niran ka pagpan-ihaw ka mga nati na karniro. ");
INSERT INTO mmn_vpl VALUES ("LK2_42","072_2_42","LUK","2","42","42","Kamhan izang toig min-iba si Hisos ka toong ginikanan pagpamista niran doro ka Hirosalem kay napolo may dowa nga ka toig di iza. ");
INSERT INTO mmn_vpl VALUES ("LK2_43","072_2_43","LUK","2","43","43","Pagkaliwas ka na pista minpabilin si Hisos doro ka Hirosalem. Kamhan wara mahagdam ya toong ginikanan. ");
INSERT INTO mmn_vpl VALUES ("LK2_44","072_2_44","LUK","2","44","44","Silaong niran nga dizan iza ka mga mataed nga namanaw nga tao. Pagpanaw niran ka isang aldaw dizan ka kanirang mga lomon daw mga kaibahan nagapakigkita gazed siran kan Hisos ");
INSERT INTO mmn_vpl VALUES ("LK2_45","072_2_45","LUK","2","45","45","piro wara niran makiti. Kamhan minbalik siran ka Hirosalem dazaw pangotanhen kon hain sa waro si Hisos. ");
INSERT INTO mmn_vpl VALUES ("LK2_46","072_2_46","LUK","2","46","46","Pagdateng ka ikatolong aldaw nakitan niran si Hisos dizan ka dakolang lagkaw nga pangamozoanan ka Diyos. Nagalo-to iza dizan ka mga maistro ka tinoohan na mga Yodayo. Nagapanalinga iza ka kanirang sindo. Kamhan may mga pangotana naiza kaniran. ");
INSERT INTO mmn_vpl VALUES ("LK2_47","072_2_47","LUK","2","47","47","Kamhan nabereng ya tanan mga manalingahay kay madazaw gazed ya mga sambag ni Hisos ka mga maistro. ");
INSERT INTO mmn_vpl VALUES ("LK2_48","072_2_48","LUK","2","48","48","Bisan ya ginikanan ni Hisos nabereng siran kamhan nagalaong ya ina nga Dong, kay ono sa ya nahinang mo kanami? Kami ni ama nangita gazed kanmo kay dakola ya kawied nami. ");
INSERT INTO mmn_vpl VALUES ("LK2_49","072_2_49","LUK","2","49","49","Minsambag si Hisos nga kay ono sa nangita sa kamo kanao? Kay ono sa wara kamo mahagdam nga kinahanglan dini ka hao ka lagkaw na kanaong Ama? ");
INSERT INTO mmn_vpl VALUES ("LK2_50","072_2_50","LUK","2","50","50","Piro wara siran makasabot ka toong sambag kaniran. ");
INSERT INTO mmn_vpl VALUES ("LK2_51","072_2_51","LUK","2","51","51","Kamhan min-oli si Hisos ka Nazarit iba ka toong ginikanan. Mintoo isab iza kaniran. Kamhan wara malipat ya toong ina ka mga inhinang ni Hisos. ");
INSERT INTO mmn_vpl VALUES ("LK2_52","072_2_52","LUK","2","52","52","Na, pagsolig ni Hisos mindakola ya toong kahagdamanan. Inpanaranginan gazed iza na Diyos. Nakaangay isab ya mga tao kanangiza. ");
INSERT INTO mmn_vpl VALUES ("LK3_1","072_3_1","LUK","3","1","1","Pagkadogay kaiza si Howan nga maanak ni Zakariyas minsogod di iza pagwali doro ka mga Yodayo. Na, ka nagasogod iza pagwali si Sisar Tibiriyo nga taga Roma ani ya labaw nga hari. Ilis iza ni Sisar Agosto. Kamhan ikanapolo may lima ding ka toig ya toong paghari. Kamhan may mga katimbang ni Sisar Tibiriyo. Si Ponsiyo Pilato ani ya toong katimbang doro ka lopa nga Yoda. Si Hirodis ani ya toong katimbang doro ka lopa nga Galiliya. Si Pilipo nga lomon ni Hirodis ani ya katimbang doro ka lopa nga Itoriya daw ya lopa nga Trakonitis. Kamhan si Lisaniyas ani ya katimbang doro ka lopa nga Abilina. ");
INSERT INTO mmn_vpl VALUES ("LK3_2","072_3_2","LUK","3","2","2","Kamhan si Anas daw si Kayapas ani ya mga labaw nga pari dizan ka mga Yodayo ka pagsogod ni Howan ka pagwali ka mga tao. Na, ka nagahela pen si Howan doro ka kamingawan mindateng ya mga panaba na Diyos dizan kanangiza. ");
INSERT INTO mmn_vpl VALUES ("LK3_3","072_3_3","LUK","3","3","3","Kamhan namanaw iza ngaro ka tanan mga dapit nga tenged ka sapa nga Hordan kay minwali iza ka mga tao nga nagalaong nga bizaan di mazo ya maongang batasan mazo. Kamhan benzagan ta kamo kay timaan iton nga impasaylo di na Diyos ya kamazong mga sala. ");
INSERT INTO mmn_vpl VALUES ("LK3_4","072_3_4","LUK","3","4","4","Na, ya inwali ni Howan ani ya nakatoman ka mga panaba ni Isayas nga karaang propita na Diyos mahitenged kan Howan nga nagalaong nga doro ka kamingawan may anhawag ka mga tao nga magalaong nga dazawen mazo ya kamazong batasan singed ka tao nga minhinglo ka dalan kay domatengay di ya Maanak na Diyos. ");
INSERT INTO mmn_vpl VALUES ("LK3_5","072_3_5","LUK","3","5","5","Kon kinabotan ya dalan ibetang mazo ya lopa. Kon antowastowas ya dalan patagen mazo. Kon nagaliko-liko ya dalan tol-iden mazo. Kon mataed ya bato hingloon mazo. Sinden mazo kaiton ya pagdazaw mazo ka kamazong batasan. ");
INSERT INTO mmn_vpl VALUES ("LK3_6","072_3_6","LUK","3","6","6","Kamhan ankita ya tanan mga tao ka Manlolowas nga garing ka Diyos pagdateng naiza ngarimbaba. Ani ini ya inlaong ni Isayas mahitenged ka pagwali ni Howan. ");
INSERT INTO mmn_vpl VALUES ("LK3_7","072_3_7","LUK","3","7","7","Na, masara gazed nga kataed ya mga tao nga minkarini kan Howan kay ampabenzag siran. Kamhan minbaheg iza kaniran nagalaong nga kamo nga mga bakaken, nagapasingedsinged kamo ka mga halas pagpandalagan niran garing ka sonog ka pagharing na tao ka oma. Kay ono sa kamo nangarini kanao? Daw gosto baza kamo andalagan ka pagkazehet na Diyos kamazo? ");
INSERT INTO mmn_vpl VALUES ("LK3_8","072_3_8","LUK","3","8","8","Kon matood gazed ya paghinelsel mazo ipakita mazo ya madazaw nga batasan. Azaw kamo maghambog ka kamazong pagkakaliwat ni Abraham. Timan-an mazo gazed ini nga bisan ya mga bato dizan ka lopa mahimo iton hinangen na Diyos nga mga kaliwatan ni Abraham. ");
INSERT INTO mmn_vpl VALUES ("LK3_9","072_3_9","LUK","3","9","9","Pamolinged ini nga andam daan ya Diyos ka pagbetang ka silot kamazo kay singed kamo ka liwaan nga diri mamonga ka madazaw nga bonga. Kon diri kon madazaw ya bonga na liwaan deegen iton kamhan sonogon. ");
INSERT INTO mmn_vpl VALUES ("LK3_10","072_3_10","LUK","3","10","10","Kamhan nabereng ya mga mataed nga tao ka mga panaba ni Howan kaniran. Agon nangotana siran nga daw ono kontana ya hinangen nami? ");
INSERT INTO mmn_vpl VALUES ("LK3_11","072_3_11","LUK","3","11","11","Minsambag si Howan nga ya tao nga dowang bolos ya bado kinahanglan ihatag ya isa dizan ka tao nga nahoboan. Ya tao nga may makaen kinahanglan magbahin dizan ka tao nga waray makaen. ");
INSERT INTO mmn_vpl VALUES ("LK3_12","072_3_12","LUK","3","12","12","Kamhan minkarini kan Howan ya mga magsokotay ka bohis nga pabayran na hari nga Romanhon. Kamhan ya batasan niran onay oswagan ya bohis. Na, ampabenzag siran kan Howan agon nangotana siran nga Maistro, daw ono kontana ya hinangen nami? ");
INSERT INTO mmn_vpl VALUES ("LK3_13","072_3_13","LUK","3","13","13","Minsambag si Howan nga azaw mazo pag-oswagan ya bohis. ");
INSERT INTO mmn_vpl VALUES ("LK3_14","072_3_14","LUK","3","14","14","Kamhan nangotana ya mga soldaw kan Howan nga bisan kami daw ono ya hinangen nami? Minsambag si Howan nga azaw kamo magpanapi pinaazi ka pagleges daw pagbetangbetang ka bisan sin-o nga tao. ");
INSERT INTO mmn_vpl VALUES ("LK3_15","072_3_15","LUK","3","15","15","Kamhan nangotana ya mga tao ka kanirang hena-hena nga si Howan daw iza si Kristo nga hari nga pinili na Diyos? ");
INSERT INTO mmn_vpl VALUES ("LK3_16","072_3_16","LUK","3","16","16","Minsambag si Howan kanirang tanan nga nagabenzag hao kamazo ka sapa piro may ansonod pen kanao nga magbenzag kamazo ka Madazaw nga Ispirito nga garing ka Diyos dazaw paharian kamo naiza nga Ispirito. Silotan sab naiza ya tao nga maongang batasan. Dizan kanangiza hao ya labing obos kay iza ya labaw ka gahem. ");
INSERT INTO mmn_vpl VALUES ("LK3_17","072_3_17","LUK","3","17","17","Pagdateng naiza dini kamazo pabelagen naiza ya mga madazaw nga tao daw ya mga maongang tao. Kay singed iza ka tao nga nagasisig ka begas. Kamhan ibetang naiza ya magazong begas dizan ka dapoganan piro ya apa sonogon iton dizan ka laga nga diri mapareng. Ani ini ya sambag ni Howan. ");
INSERT INTO mmn_vpl VALUES ("LK3_18","072_3_18","LUK","3","18","18","Kamhan mataed pen ya mga panaba ni Howan pagtambag naiza kaniran daw pagwali ka sindo mahitenged kan Hiso Kristo. ");
INSERT INTO mmn_vpl VALUES ("LK3_19","072_3_19","LUK","3","19","19","Waray kahaldek naiza ka pagbaheg naiza kan Hirodis nga hari nga minpanapaw ka ipag nga si Hirodiyas kamhan mataed pen ya maongang hinang ni Hirodis. ");
INSERT INTO mmn_vpl VALUES ("LK3_20","072_3_20","LUK","3","20","20","Kamhan mindogang gazed ya sala ni Hirodis kay minpapiriso iza kan Howan. ");
INSERT INTO mmn_vpl VALUES ("LK3_21","072_3_21","LUK","3","21","21","Na, ka wara pen mapiriso si Howan nagapanbenzag iza ka mga mataed nga tao. Pagkakamhan sab naiza pagbenzag kan Hisos nagapangamozo si Hisos ka Diyos. Kamhan singed ka naabri di ya langit. ");
INSERT INTO mmn_vpl VALUES ("LK3_22","072_3_22","LUK","3","22","22","Kamhan minkarimbaba kan Hisos ya Madazaw nga Ispirito nga garing ka Diyos. Minpasingedsinged iton ka salapati. Kamhan may saba na Diyos nga garing daked ka langit nagalaong nga iko ya kanaong Maanak nga kanaong naazakan. Nakasaza gazed iko kanao. Ani ini ya inlaong na Diyos. ");
INSERT INTO mmn_vpl VALUES ("LK3_23","072_3_23","LUK","3","23","23","Na, pagsogod ni Hisos pagsindo ka mga tao mga katloan nga ka toig ya toong pagkamalaas. Kamhan nagahena-hena ya mga tao nga si Hisos maanak ka lamang iza ni Hosi. Na, wani ya inkalista ka mga kaapoan ni Hosi. Si Hosi ani maanak ni Hili. ");
INSERT INTO mmn_vpl VALUES ("LK3_24","072_3_24","LUK","3","24","24","Kamhan si Hili maanak ni Matat. Kamhan si Matat maanak ni Libi. Kamhan si Libi maanak ni Milki. Kamhan si Milki maanak ni Hana. Kamhan si Hana maanak ni Hosi. ");
INSERT INTO mmn_vpl VALUES ("LK3_25","072_3_25","LUK","3","25","25","Kamhan si Hosi maanak ni Matatiyas. Kamhan si Matatiyas maanak ni Amos. Kamhan si Amos maanak ni Nahom. Kamhan si Nahom maanak ni Isli. Kamhan si Isli maanak ni Nagay. ");
INSERT INTO mmn_vpl VALUES ("LK3_26","072_3_26","LUK","3","26","26","Kamhan si Nagay maanak ni Maat. Kamhan si Maat maanak ni Matatiyas. Kamhan si Matatiyas maanak ni Simay. Kamhan si Simay maanak ni Hosi. Kamhan si Hosi maanak iza ni Zoda. ");
INSERT INTO mmn_vpl VALUES ("LK3_27","072_3_27","LUK","3","27","27","Kamhan si Zoda maanak ni Zohana. Kamhan si Zohana maanak ni Risa. Kamhan si Risa maanak ni Zorobabel. Kamhan si Zorobabel maanak ni Salatiil. Kamhan si Salatiil maanak ni Niri. ");
INSERT INTO mmn_vpl VALUES ("LK3_28","072_3_28","LUK","3","28","28","Kamhan si Niri maanak ni Milki. Kamhan si Milki maanak ni Adi. Kamhan si Adi maanak ni Kosam. Kamhan si Kosam maanak ni Ilmodam. Kamhan si Ilmodam maanak ni Iri. ");
INSERT INTO mmn_vpl VALUES ("LK3_29","072_3_29","LUK","3","29","29","Kamhan si Iri maanak ni Hoswi. Kamhan si Hoswi maanak ni Iliyazir. Kamhan si Iliyazir maanak ni Zorim. Kamhan si Zorim maanak ni Matat. Kamhan si Matat maanak ni Libi. ");
INSERT INTO mmn_vpl VALUES ("LK3_30","072_3_30","LUK","3","30","30","Kamhan si Libi maanak ni Simiyon. Kamhan si Simiyon maanak ni Hoda. Kamhan si Hoda maanak ni Hosi. Kamhan si Hosi maanak ni Zonan. Kamhan si Zonan maanak ni Iliyakim. ");
INSERT INTO mmn_vpl VALUES ("LK3_31","072_3_31","LUK","3","31","31","Kamhan si Iliyakim maanak ni Miliya. Kamhan si Miliya maanak ni Mina. Kamhan si Mina maanak ni Matata. Kamhan si Matata maanak ni Natan. Kamhan si Natan maanak ni Dabid. ");
INSERT INTO mmn_vpl VALUES ("LK3_32","072_3_32","LUK","3","32","32","Kamhan si Dabid maanak ni Isay. Kamhan si Isay maanak ni Obid. Kamhan si Obid maanak ni Boos. Kamhan si Boos maanak ni Salmon. Kamhan si Salmon maanak ni Naason. ");
INSERT INTO mmn_vpl VALUES ("LK3_33","072_3_33","LUK","3","33","33","Kamhan si Naason maanak ni Aminadab. Kamhan si Aminadab maanak ni Aram. Kamhan si Aram maanak ni Arni. Kamhan si Arni maanak ni Isrom. Kamhan si Isrom maanak ni Paras. Kamhan si Paras maanak ni Hoda. ");
INSERT INTO mmn_vpl VALUES ("LK3_34","072_3_34","LUK","3","34","34","Kamhan si Hoda maanak ni Hakob. Kamhan si Hakob maanak ni Isak. Kamhan si Isak maanak ni Abraham. Kamhan si Abraham maanak ni Tara. Kamhan si Tara maanak ni Nakor. ");
INSERT INTO mmn_vpl VALUES ("LK3_35","072_3_35","LUK","3","35","35","Kamhan si Nakor maanak ni Sirog. Kamhan si Sirog maanak ni Ragaw. Kamhan si Ragaw maanak ni Pilig. Kamhan si Pilig maanak ni Ibir. Kamhan si Ibir maanak ni Sila. ");
INSERT INTO mmn_vpl VALUES ("LK3_36","072_3_36","LUK","3","36","36","Kamhan si Sila maanak ni Kaynan. Kamhan si Kaynan maanak ni Arpahad. Kamhan si Arpahad maanak ni Sim. Kamhan si Sim maanak ni Niwi. Kamhan si Niwi maanak ni Lamak. ");
INSERT INTO mmn_vpl VALUES ("LK3_37","072_3_37","LUK","3","37","37","Kamhan si Lamak maanak ni Matosalan. Kamhan si Matosalan maanak ni Inok. Kamhan si Inok maanak ni Zarad. Kamhan si Zarad maanak ni Mahalalil. Kamhan si Mahalalil maanak ni Kaynan. ");
INSERT INTO mmn_vpl VALUES ("LK3_38","072_3_38","LUK","3","38","38","Kamhan si Kaynan maanak ni Inos. Kamhan si Inos maanak ni Sit. Kamhan si Sit maanak ni Adan. Kamhan si Adan maanak na Diyos. ");
INSERT INTO mmn_vpl VALUES ("LK4_1","072_4_1","LUK","4","1","1","Na, minpanaw si Hisos dizan ka sapa nga Hordan nga imbenzagan ni Howan kanangiza. Kamhan inharian iza na Madazaw nga Ispirito nga garing ka Diyos. Kamhan inpakaro iza na Ispirito ngaro ka kamingawan. ");
INSERT INTO mmn_vpl VALUES ("LK4_2","072_4_2","LUK","4","2","2","Keteb ka kap-atan nga ka aldaw min-anget si Hisos ka pagkaen doro. Kamhan magabengtasen di gazed iza. Kamhan intintal iza ni Satanas dazaw an-ato iza ka Diyos piro wara gazed si Hisos madaeg kay ingamit naiza pag-ato ya mga panaba na Diyos nga inpasoyat daan. ");
INSERT INTO mmn_vpl VALUES ("LK4_3","072_4_3","LUK","4","3","3","Pagkadizan ka ni Satanas kan Hisos nagalaong iza ka pagtintal nga kon iko ya matood nga Maanak na Diyos sogoon mo ya mga bato dazaw mahinang nga makaen kay magabengtasen di gazed iko. ");
INSERT INTO mmn_vpl VALUES ("LK4_4","072_4_4","LUK","4","4","4","Minsambag si Hisos nga diri hao ansogot kay may daan pinasoyat na Diyos nga nagalaong nga diri kon makaen ka lamang ya makabohi ka mga tao basta ya tanan mga panaba na Diyos ani gazed ya labaw nga makabohi ka mga tao. ");
INSERT INTO mmn_vpl VALUES ("LK4_5","072_4_5","LUK","4","5","5","Pagkakamhan kaiza impaiba ni Satanas si Hisos ngandaked ka poro na bobong nga ataas pagdazaw. Kamhan madali ya pagpaseleng ni Satanas kan Hisos ka tanang mga longsod dini ka haloag nga kalibotan. ");
INSERT INTO mmn_vpl VALUES ("LK4_6","072_4_6","LUK","4","6","7","Kamhan minlaong si Satanas kan Hisos nga kanao gazed ya katenged ka pagdomara kaiton nga kalongsoran. Hao isab ya ampili kon sin-o ya magadomara. Na, kon lomohod ko pagtahod kanao ihatag o kanmo ya katenged ka pagdomara kaiton nga tanan. ");
INSERT INTO mmn_vpl VALUES ("LK4_8","072_4_8","LUK","4","8","8","Minsambag si Hisos nga diri hao ansogot kay may daan pinasoyat na Diyos nga nagalaong nga ya Ginoo nga kamazong Diyos iza gazed ya sazaen mazo. Iza sab ya kamazong alagaden, waray lain. ");
INSERT INTO mmn_vpl VALUES ("LK4_9","072_4_9","LUK","4","9","9","Pagkakamhan kaiza impaiba ni Satanas pag-otro si Hisos ngaro ka siyodad nga Hirosalem. Kamhan in-ated iza ngandaked ka taway na binobongan nga dakolang lagkaw nga pangamozoanan ka Diyos. Kamhan minlaong si Satanas kan Hisos nga kon matood pen nga ikoy Maanak na Diyos emempag iko ngambaba ka lopa. ");
INSERT INTO mmn_vpl VALUES ("LK4_10","072_4_10","LUK","4","10","10","Kamhan diri masakitan ya lawas mo kay may daan pinasoyat na Diyos nga nagalaong nga pabantazan iko ka toong mga sinogo. ");
INSERT INTO mmn_vpl VALUES ("LK4_11","072_4_11","LUK","4","11","11","Bohaten iko niran. Kamhan bisan ya paa mo diri andasmag ka bato. ");
INSERT INTO mmn_vpl VALUES ("LK4_12","072_4_12","LUK","4","12","12","Minsambag si Hisos nga diri hao ansogot kay may daan pinasoyat na Diyos nga nagalaong nga azaw mazo pagsorazi ya Ginoo nga kamazong Diyos. ");
INSERT INTO mmn_vpl VALUES ("LK4_13","072_4_13","LUK","4","13","13","Na, wara gazed madaeg si Hisos agon minheneng di si Satanas pagporba. Kamhan minpanaw iza hangtod ka may logar pen naiza ka pagtintal kan Hisos. ");
INSERT INTO mmn_vpl VALUES ("LK4_14","072_4_14","LUK","4","14","14","Pagkakamhan kaiza min-oli di si Hisos ka lopa nga Galiliya. Inharian iza na Madazaw nga Ispirito nga garing ka Diyos. Kamhan impanan-og ya toong mga inhinang doro ka Galiliya. ");
INSERT INTO mmn_vpl VALUES ("LK4_15","072_4_15","LUK","4","15","15","Minsindo sab iza dalem ka mga singbahan na toong angay nga Yodayo. Kamhan insaza iza na mga mataed nga tao. ");
INSERT INTO mmn_vpl VALUES ("LK4_16","072_4_16","LUK","4","16","16","Pagkadogay kaiza mindateng iza ka longsod nga Nazarit nga toong sinoligan. PagkaSabado kaiza minseled iza ka singbahan kay ani ya toong batasan ka aldaw nga tigpahimlay na mga Yodayo. Kamhan mintindeg iza kay ambasa iza kaniran. ");
INSERT INTO mmn_vpl VALUES ("LK4_17","072_4_17","LUK","4","17","17","Intagan sab iza ka basahen nga insoyatan ni Isayas nga karaang propita na Diyos. Paghebad naiza ya linokot nga basahen inbasa naiza iton nga sinoyat nga nagalaong nga ");
INSERT INTO mmn_vpl VALUES ("LK4_18","072_4_18","LUK","4","18","18","inharian hao na Madazaw nga Ispirito nga garing ka Diyos kay inpili hao naiza ka pagwali ka mga pobri ka madazaw nga panan-og. Kamhan inpadara hao naiza ka mga binihag ka pagpanan-og kaniran nga nalibri di siran. Dazawen nao ya mata na mga nabota. Tabangan nao ya mga tao nga indaegdaeg. ");
INSERT INTO mmn_vpl VALUES ("LK4_19","072_4_19","LUK","4","19","19","Ipanan-og nao nga mindateng di ya tirmino ka paglibri na Diyos ka mga tao ka silot ka kanirang mga sala kon ansakop siran kanangiza. Ani ini ya imbasa ni Hisos. ");
INSERT INTO mmn_vpl VALUES ("LK4_20","072_4_20","LUK","4","20","20","Kamhan inlokot naiza ya basahen daw indohol ka magtimbangay nga tao. Paglo-to naiza ka pagsindo kaniran minseleng gazed siran pagdazaw kanangiza. ");
INSERT INTO mmn_vpl VALUES ("LK4_21","072_4_21","LUK","4","21","21","Kamhan minsogod iza ka pagsindo kaniran nga nagalaong nga koman aldaw mintoman gazed ini nga nabatian mazo kay hao gazed ya tao nga insoyatan na Diyos. ");
INSERT INTO mmn_vpl VALUES ("LK4_22","072_4_22","LUK","4","22","22","Kamhan nakaangay sirang tanan kan Hisos. Piro nabereng siran kon hain iza magtoon ka toong sindo. Minlaong siran nga taga dini ka lamang iza. Maanak ka lamang iza ni Hosi. ");
INSERT INTO mmn_vpl VALUES ("LK4_23","072_4_23","LUK","4","23","23","Na, mahagdam si Hisos nga nagadowadowa ya kanirang hena-hena. Kamhan minbaheg iza kaniran nagalaong nga kay ono sa nagadowadowa sa kamo? Wara kamo magtoo kanao. Kamhan ampahinang baza kamo kanao ka mga dakolang hinang dini ka kanaong kaogaringeng longsod singed ka kanaong inhinang nga nabatian mazo doro ka longsod nga Kapirnaom. ");
INSERT INTO mmn_vpl VALUES ("LK4_24","072_4_24","LUK","4","24","24","Timan-an mazo gazed ini nga bisan sin-o ya propita na Diyos kon andateng iza ka toong kaibahan wara iza tahoda. ");
INSERT INTO mmn_vpl VALUES ("LK4_25","072_4_25","LUK","4","25","25","Na, maghena-hena kamo kaini nga matood nga kawandini pen ka bohi ka si Iliyas nga karaang propita na Diyos wara gazed orana keteb ka tolong ka toig may tenga. Nadateng sab ya kantang lopa ka grabing pihit. Na, bisan mataed ya mga balo nga babazi nga Yodayo wara si Iliyas magtabang kaniran ");
INSERT INTO mmn_vpl VALUES ("LK4_26","072_4_26","LUK","4","26","26","kay impakaro hinoa iza na Diyos ka isang balo nga taga Siripat doro ka lain lopa nga Sidon dazaw tabangan iza. ");
INSERT INTO mmn_vpl VALUES ("LK4_27","072_4_27","LUK","4","27","27","Bisan si Ilaysa nga karaang propita na Diyos ka bohi pen iza mataed ya mga kagiden nga Yodayo piro wara iza magdazaw ka kanirang mga lawas. Ani hinoon ya intambal naiza si Naman nga taga Siriya. Ani ini ya inlaong ni Hisos ka toong kaibahan nga mga Yodayo. ");
INSERT INTO mmn_vpl VALUES ("LK4_28","072_4_28","LUK","4","28","28","Kamhan nazehet gazed siran pagdazaw kan Hisos kay minpanaba iza nga inkaloy-an na Diyos ya mga tao nga diri kon Yodayo. ");
INSERT INTO mmn_vpl VALUES ("LK4_29","072_4_29","LUK","4","29","29","Kamhan mintindeg gazed siran kay bogawen si Hisos dini ka kanirang longsod. Na, ya dapit na kanirang longsod ani ya bobongay. Kamhan imbira niran si Hisos dizan ka kilid na pangpang nga ataas pagdazaw. Kamhan itolod niran kontana si Hisos ngambaba ka pangpang. ");
INSERT INTO mmn_vpl VALUES ("LK4_30","072_4_30","LUK","4","30","30","Piro min-azi si Hisos dizan tenged kaniran. Kamhan minpanaw iza ngaro. Wara makapaniid ya mga tao kon ankar-in iza pagsinged. ");
INSERT INTO mmn_vpl VALUES ("LK4_31","072_4_31","LUK","4","31","31","Pagkakay-an kaiza mindateng si Hisos ka longsod nga Kapirnaom doro ka Galiliya. PagkaSabado kaiza nga tigpahimlay na mga Yodayo minsindo iza kaniran. ");
INSERT INTO mmn_vpl VALUES ("LK4_32","072_4_32","LUK","4","32","32","Kamhan nabereng gazed siran kay labaw gazed ka gahem ya mga panaba ni Hisos. ");
INSERT INTO mmn_vpl VALUES ("LK4_33","072_4_33","LUK","4","33","33","Na, ka dizan pen si Hisos ka singbahan may tao nga inboang na maonga nga minsinggit kanangiza nga nagalaong nga ");
INSERT INTO mmn_vpl VALUES ("LK4_34","072_4_34","LUK","4","34","34","Hisos nga taga Nazarit, kay ono sa nga hilabtan sa mo kami? Daw ani ya inkarini mo ya pagpatay mo kanami? Mahagdam gazed hao nga iko gazed ya Maanak na Diyos nga waray maonga. ");
INSERT INTO mmn_vpl VALUES ("LK4_35","072_4_35","LUK","4","35","35","Minsambag si Hisos pagbaheg nga magpahenek ko. Domalagan di ko ka tao. Ka wara pen magdalagan indagbes na maonga ya tao dizan tenged ka mga tao. Kamhan minpanaw ya maonga. Wara madaet ya lawas na tao. ");
INSERT INTO mmn_vpl VALUES ("LK4_36","072_4_36","LUK","4","36","36","Kamhan nabereng gazed ya mga naneleng. Namaglaong siran nga labaw gazed ka gahem ya pagpanaba ni Hisos! Bisan ya mga maonga antoo baza siran ka toong sogo. ");
INSERT INTO mmn_vpl VALUES ("LK4_37","072_4_37","LUK","4","37","37","Kamhan minlekep di gazed ya ngaran ni Hisos doro ka lopa nga Galiliya. ");
INSERT INTO mmn_vpl VALUES ("LK4_38","072_4_38","LUK","4","38","38","Na, kamhan di ya pagsingba ni Hisos agon minkaro iza ka lagkaw ni Simon. Na, ya bozag nga ogangan ni Simon imbangkag gazed iza. Kamhan minhangzo siran kan Hisos dazaw tabangan iza. ");
INSERT INTO mmn_vpl VALUES ("LK4_39","072_4_39","LUK","4","39","39","Na, pagkadizan ni Hisos ka nabedlay minbaheg iza ka hilanat. Kamhan inhowasan matood iza ka toong hilanat. Kamhan minbangon dazon iza kay ampakaen iza kaniran. ");
INSERT INTO mmn_vpl VALUES ("LK4_40","072_4_40","LUK","4","40","40","Pagkadelem ka kaiza impaarani na mga tao kan Hisos ya mga mataed nga tao nga nagaanget ka mga klasi nga mga masakit. Impandampa ni Hisos ya kanirang mga lawas. Kamhan nabahaw matood ya kanirang mga lawas. ");
INSERT INTO mmn_vpl VALUES ("LK4_41","072_4_41","LUK","4","41","41","Impalogwa isab naiza ya mga maonga ka mga tao. Paglogwa niran minsinggit siran nga iko ya Maanak na Diyos! Piro minbaheg iza kaniran. Kamhan diri togotan ka pagpanaba kay mahagdam siran nga iza si Kristo nga pinili na Diyos. Ani ini ya pagtabang ni Hisos ka mga tao ka dizan pen iza ka lagkaw ni Simon. ");
INSERT INTO mmn_vpl VALUES ("LK4_42","072_4_42","LUK","4","42","42","Na, pagkakamaaldawen ka minpanaw si Hisos ngaro ka waray tao kay ampangamozo iza ka Diyos. Kamhan impangitan iza na mga tao. Pag-apas niran gosto niran nga diri iza ampanaw. ");
INSERT INTO mmn_vpl VALUES ("LK4_43","072_4_43","LUK","4","43","43","Minsambag iza nga kinahanglan doro ka mga iba nga longsod anwali pen hao ka sindo mahitenged ka pagpasakop na Diyos ka mga tao kay ani ya tood na Diyos ka pagpakarimbaba kanao ka kalibotan. ");
INSERT INTO mmn_vpl VALUES ("LK4_44","072_4_44","LUK","4","44","44","Pagkakamhan doro ka tibolos lopa nga Yoda minwali iza ka mga Yodayo dalem ka kanirang singbahan. ");
INSERT INTO mmn_vpl VALUES ("LK5_1","072_5_1","LUK","5","1","1","May isang aldaw nga dizan si Hisos ka baybazen na danaw nga Ganasarit. Masara gazed nga kataed ya mga tao nga minheet kay ampanalinga siran ka sindo nga garing ka Diyos. ");
INSERT INTO mmn_vpl VALUES ("LK5_2","072_5_2","LUK","5","2","2","Kamhan dizan ka baybazen nakita ni Hisos ya dowang bolos nga baloto kay inbilin na mga mang-isdaay kay namaghogas pen siran ka mga lazà. ");
INSERT INTO mmn_vpl VALUES ("LK5_3","072_5_3","LUK","5","3","3","Kamhan minleen si Hisos ka baloto ni Simon. Kamhan minhangzo iza kan Simon ka pagpasibogsibog dizan ka sapa kay anlo-to iza pagsindo pen naiza ka mga tao. ");
INSERT INTO mmn_vpl VALUES ("LK5_4","072_5_4","LUK","5","4","4","Pagkakamhan naiza pagsindo kaniran minlaong iza kan Simon nga palawed kamo. Kamhan itaktak mazo ya kamazong lazà kay mataed ya isda dakoza kaiza. ");
INSERT INTO mmn_vpl VALUES ("LK5_5","072_5_5","LUK","5","5","5","Minsambag si Simon nga Maistro, kazinang kahabzen waray heneng nami ka pagpangisda. Kamhan wara gazed tarai ya kanaming lazà. Piro kon somogot ko kanami, managat kami pag-isab. ");
INSERT INTO mmn_vpl VALUES ("LK5_6","072_5_6","LUK","5","6","6","Na, pagpanagat niran pag-isab mataed matood ya isda. Magisi kontana ya kanirang lazà kay masara gazed nga kabeg-at ya pagbira. ");
INSERT INTO mmn_vpl VALUES ("LK5_7","072_5_7","LUK","5","7","7","Agon minhawag siran ka mga iba dizan ka lain baloto dazaw antabang. Pagdateng niran inpono gazed niran ya dowang baloto agon hapit di siran malened. ");
INSERT INTO mmn_vpl VALUES ("LK5_8","072_5_8","LUK","5","8","8","Pagpakakita ka ni Simon Pidro ka inhinang ni Hisos minlohod dazon iza ka paahan ni Hisos daw minlaong nga Ginoo, madazaw gazed iko. Maonga gazed hao agon pomanaw ko dini kanao. ");
INSERT INTO mmn_vpl VALUES ("LK5_9","072_5_9","LUK","5","9","9","Ani ini ya toong inlaong kay nabereng gazed iza daw ya toong mga iba ka kanirang inlazà. ");
INSERT INTO mmn_vpl VALUES ("LK5_10","072_5_10","LUK","5","10","10","Nabereng isab ya mga maanak ni Sibidiyo nga si Santiago daw si Howan nga mga iba ni Simon ka pagpangisda. Kamhan minsambag si Hisos kan Simon nga diri ko magkahaldek kay sokad koman antoldo hao kanmo dazaw mahagdam ko ka pagpasakop ka mga tao kanao singed ka pagpanlazà mo ka mga isda. ");
INSERT INTO mmn_vpl VALUES ("LK5_11","072_5_11","LUK","5","11","11","Kamhan mingozod siran ka kanirang mga baloto dizan ka baybazen. Kamhan imbizaan niran ya tanan kay an-iba gazed siran kan Hisos. ");
INSERT INTO mmn_vpl VALUES ("LK5_12","072_5_12","LUK","5","12","12","Na, may isang aldaw ka dizan pen si Hisos ka isang longsod insogat naiza ya tao nga masarang kagid. Pagpakakita naiza kan Hisos minlohod iza ka toong paahan. Minhangzo iza nga nagalaong nga Sinyor, kon somogot ko ka pagpangamozo nao kanmo dazawen mo ya kanaong masakit. ");
INSERT INTO mmn_vpl VALUES ("LK5_13","072_5_13","LUK","5","13","13","Kamhan inhogam iza ni Hisos daw nagalaong nga Loy, ansogot hao. Nawara di ya masakit ka kanmong lawas. Kamhan nadazaw di matood ya toong lawas. ");
INSERT INTO mmn_vpl VALUES ("LK5_14","072_5_14","LUK","5","14","14","Kamhan minsogo si Hisos nga nagalaong nga diri ko magpanan-og ka mga tao ka inhinang o kanmo. Pomanaw ko naa ngaro ka pari. Magpakita ko ka kanmong lawas diton. Kamhan magtoman ko ka balaed ni Moysis ka paghalad kay dazaw magmatood ya mga kataohan nga nawaraan di ko ka kanmong kagid. ");
INSERT INTO mmn_vpl VALUES ("LK5_15","072_5_15","LUK","5","15","15","Kamhan bisan diri ansogot si Hisos, impanan-og di hinoon ya toong inhinang dizan ka mga mataed nga tao. Kamhan masara gazed nga kataed ya tao nga mintipon dizan kan Hisos kay maazak siran pagpanalinga ka toong mga panaba. Anpatambal sab siran ka kanirang mga masakit ");
INSERT INTO mmn_vpl VALUES ("LK5_16","072_5_16","LUK","5","16","16","piro minpanaw hinoa si Hisos ngaro ka waray tao kay ampangamozo iza ka Diyos. ");
INSERT INTO mmn_vpl VALUES ("LK5_17","072_5_17","LUK","5","17","17","Na, may isang aldaw nga nagasindo pen si Hisos ka mga tao pag-isab. Kamhan dakoza kaiza namaglo-to ya mga Parasiyo daw ya mga maistro ka tinoohan na mga Yodayo. Garing siran ka tanan mga longsod ka Galiliya daw Yoda daw ya siyodad nga Hirosalem. Kamhan ya gahem na Diyos dizan iton kan Hisos ka pagdazaw ka mga masakiten nga tao. ");
INSERT INTO mmn_vpl VALUES ("LK5_18","072_5_18","LUK","5","18","18","Na, ka nagasindo pen iza kaniran may mga mindateng nga namaglahong ka tao nga diri mahingas ya lawas. Kamhan pabentagen kontana dizan ka pag-atobang kan Hisos. ");
INSERT INTO mmn_vpl VALUES ("LK5_19","072_5_19","LUK","5","19","19","Piro masiet gazed ya pirtahan ka tao agon minpanik siran ka hagdan ngandaked ka malakbang nga atep. Pagpakaboslot ka niran ka atep nga tenged ni Hisos intonton niran ya bowahan nga inbentagan na paralitiko. ");
INSERT INTO mmn_vpl VALUES ("LK5_20","072_5_20","LUK","5","20","20","Pagpakakita ka ni Hisos ka inhinang niran mahagdam iza nga minsarig gazed siran kanangiza ka pagbahaw kaiton nga tao. Kamhan minlaong iza ka nabedlay nga Loy, impasaylo di nao ya kanmong mga sala. ");
INSERT INTO mmn_vpl VALUES ("LK5_21","072_5_21","LUK","5","21","21","Pagpakabati ka na mga Parasiyo daw ya mga maistro ka inlaong ni Hisos ka paralitiko minlaong siran ka kanirang hena-hena nga garboso gazed si Hisos pagbakak nga iza ya Diyos kay ya Diyos ani ya may gahem ka pagpasaylo ka mga sala. ");
INSERT INTO mmn_vpl VALUES ("LK5_22","072_5_22","LUK","5","22","22","Mahagdam dazon si Hisos nga maonga ya kanirang hena-hena agon nangotana iza nga kay ono sa nga malain sa ya kamazong hena-hena kanao? ");
INSERT INTO mmn_vpl VALUES ("LK5_23","072_5_23","LUK","5","23","23","Dini ka paralitiko singed ka masazon ya pagpasaylo ka toong mga sala kay diri mazo makita kon dizan pen ya toong mga sala kon wara di. Piro malised ya pagdazaw ka toong lawas kay makita dazon kon madazaw di iton kon diri pen. ");
INSERT INTO mmn_vpl VALUES ("LK5_24","072_5_24","LUK","5","24","24","Koman ipakilala nao kamazo nga may gahem nao ka pagpasaylo ka mga sala na bisan sin-o nga tao kay hao gazed ya minhon-a ka bisan sin-o nga mahon-ang tao. Kamhan minsogo si Hisos ka paralitiko nga bomangon di ko. Lokoton di mo ya bentagan mo. Om-oli ko ngaro ka lagkaw mo. ");
INSERT INTO mmn_vpl VALUES ("LK5_25","072_5_25","LUK","5","25","25","Kamhan minbangon matood ya paralitiko daw minhipid dazon iza ka toong bentagan. Pagpanaw naiza ngaro ka toong lagkaw insaza gazed naiza ya Diyos. ");
INSERT INTO mmn_vpl VALUES ("LK5_26","072_5_26","LUK","5","26","26","Kamhan nabereng gazed ya tanan mga tao kay madazaw gazed ya inhinang ni Hisos. Insaza gazed niran ya Diyos daw nagalaong nga wara sa sokad ya nakitan nami nga singed kaini. ");
INSERT INTO mmn_vpl VALUES ("LK5_27","072_5_27","LUK","5","27","27","Pagkakamhan kaiza minpanaw si Hisos. Kamhan min-azi iza dizan ka opisina nga bayranan ka mga bohis na mga karga. Kamhan ya magsokotay ka mga bohis nga inngaranan kan Matiyo ani ya nakitan ni Hisos kay nagalo-to iza dizan ka toong opisina. Kamhan minlaong si Hisos kan Libi nga somakop ko kanao. ");
INSERT INTO mmn_vpl VALUES ("LK5_28","072_5_28","LUK","5","28","28","Kamhan mintindeg si Libi. Impamizaan naiza ya tanan kay an-iba iza kan Hisos. ");
INSERT INTO mmn_vpl VALUES ("LK5_29","072_5_29","LUK","5","29","29","Pagkakamhan kaiza dizan ka lagkaw min-andam si Libi ka dakolang kombiti kay ampakaen iza kan Hisos. Kamhan may mga mataed nga magsokotay singed kan Libi daw ya mga iba peng tao namagsaro kaniran. ");
INSERT INTO mmn_vpl VALUES ("LK5_30","072_5_30","LUK","5","30","30","Ka nagakaen pen sirang tanan impaniidan siran na mga Parasiyo daw ya mga iba nga maistro nga hopaw ka lamang ya kanirang pagtoo. Kamhan nagamahay siran ka mga sakop ni Hisos nga nagalaong nga kay ono sa kamo nga minsaro sa kamo daw ya mga magsokotay daw mga salaan nga tao? Ani ini ya pangotana niran kay ya batasan na mga magsokotay ka bohis onay oswagan ya bohis. ");
INSERT INTO mmn_vpl VALUES ("LK5_31","072_5_31","LUK","5","31","31","Minsambag si Hisos kaniran nga pamolinged ini nga ya mga tao nga madazaw ya lawas wara siran magpatambal basta kay ya mga masakiten. ");
INSERT INTO mmn_vpl VALUES ("LK5_32","072_5_32","LUK","5","32","32","Kamhan wara hao magkarini ka pagtabang ka mga matadeng nga tao basta kay ya mga makasasala dazaw anhinelsel siran ka kanirang mga sala. ");
INSERT INTO mmn_vpl VALUES ("LK5_33","072_5_33","LUK","5","33","33","Kamhan minlaong ya mga Parasiyo kan Hisos nga ya batasan na mga sakop ni Howan nga Magbenzagay daw ya kanaming mga sakop onay siran nga nagatoman ka batasan ka pag-anget ka makaen dazaw ampangamozo siran ka Diyos. Kamhan nabereng kami kay ya kamazong mga sakop nagakaen siran daw nagainem. ");
INSERT INTO mmn_vpl VALUES ("LK5_34","072_5_34","LUK","5","34","34","Minsambag si Hisos pagpamolinged nga ya kanaong kasakopan singed siran ka mga magkombitihay. Kamhan dizan kaniran hao ya singed ka banahen agon ka dini pen hao kaniran diri siran an-anget ka makaen. ");
INSERT INTO mmn_vpl VALUES ("LK5_35","072_5_35","LUK","5","35","35","Piro may tirmino nga kaw-en hao garing ka kanaong mga sakop anipen omanget siran ka makaen kay mabeg-at ya kanirang hinawa. ");
INSERT INTO mmn_vpl VALUES ("LK5_36","072_5_36","LUK","5","36","36","Wani ya pamolinged dazaw mahagdam kamo nga ya kanaong sindo diri makaangay ka mga balaed nga tinoohan na mga Yodayo kay ya kanaong sindo singed iton ka bag-ong panapton. Kamhan ya mga balaed na mga Yodayo singed iton ka bado nga nadonot di. Na, pagtopak nita ka nadonot nga bado diri di gamiten ya bag-ong panapton kay basi kay-an ka paglaba ka bado ankezes ya itopakay nga bag-ong panapton. Kamhan magakagisi ya daan bado pagdobli. ");
INSERT INTO mmn_vpl VALUES ("LK5_37","072_5_37","LUK","5","37","37","Bisan ya bag-ong bino nga magabora pen diri ihalin ka daan len-anan nga kindal na kanding kay kon begketen ya ba-ba na len-anan magisi gazed iton. Kamhan an-awas ya bino daw kanogon sab ya len-anan nga magisi. ");
INSERT INTO mmn_vpl VALUES ("LK5_38","072_5_38","LUK","5","38","38","Agon gamiten gazed ya bag-ong len-anan. Ani ini ya pamolinged ni Hisos ka mga tao dazaw mahagdam siran nga ya toong sindo diri makaangay ka mga balaed nga tinoohan na mga Yodayo. ");
INSERT INTO mmn_vpl VALUES ("LK5_39","072_5_39","LUK","5","39","39","Antiwas pen hao pagpamolinged kamazo. Ya mga balaed na mga Yodayo singed iton ka daan bino. Kamhan ya kanaong sindo singed iton ka bag-ong bino. Ya tao nga naanad pag-inem ka daan bino diri iza an-angay ka bag-ong bino kay magalaong iza nga ya daan bino ani ya madazaw. ");
INSERT INTO mmn_vpl VALUES ("LK6_1","072_6_1","LUK","6","1","1","May isang Sabado dizan ka homazan nagaazi si Hisos. Na, ya Sabado ani ya tigpahimlay na mga Yodayo. Pag-azi ni Hisos dizan nagapangitlo ya toong mga sakop ka homay daw nagapangorokoso. Kamhan kanen niran. ");
INSERT INTO mmn_vpl VALUES ("LK6_2","072_6_2","LUK","6","2","2","Pagpakapaniid ka na mga Parasiyo kanin Hisos minbaheg siran nga nagalaong nga minlapas gazed ya kanmong mga sakop ka balaed na Diyos kay koman nga tigpahimlay min-ani siran ka homay. ");
INSERT INTO mmn_vpl VALUES ("LK6_3","072_6_3","LUK","6","3","3","Minsambag si Hisos nga mahagdam kamo daan ka inhinang ni Dabid nga karaang tao na mga Yodayo. Kawandini pen imbengtas iza daw ya toong kaibahan kay inlopog siran na kanirang mga kaaway. ");
INSERT INTO mmn_vpl VALUES ("LK6_4","072_6_4","LUK","6","4","4","Agon pagdateng niran ka lagkaw nga pangamozoanan ka Diyos minkaen si Dabid ka tinapay nga inhalad na mga Yodayo ka Diyos. Kamhan minpakaen iza ka toong kaibahan. Minlapas matood sin Dabid ka kantang balaed kay ya mga pari anikay ankaen kitong mga tinapay. Piro wara sin Dabid makasala ka Diyos kay nagalised siran ka kabengtas. ");
INSERT INTO mmn_vpl VALUES ("LK6_5","072_6_5","LUK","6","5","5","Labaw pen ya gahem nao ka gahem ni Dabid kay minhon-a hao ka bisan sin-o nga mahon-ang tao agon hao ya ambeet kon ono ya madazaw nga hinang na tao ka aldaw nga tigpahimlay. Ani ini ya sambag ni Hisos ka mga Parasiyo. ");
INSERT INTO mmn_vpl VALUES ("LK6_6","072_6_6","LUK","6","6","6","May isa pen nga ka Sabado nga minseled gihapon si Hisos ka singbahan na mga Yodayo kay ansindo iza ka mga tao. Dizan disab may tao nga diri mahingas ya pikas nga toong alima. ");
INSERT INTO mmn_vpl VALUES ("LK6_7","072_6_7","LUK","6","7","7","Kamhan ya mga maistro ka tinoohan na mga Yodayo daw ya mga Parasiyo nagapaniid gazed siran kan Hisos kay kon dazawen naiza ya alima naiton nga tao awazen niran kay singed ka antarabaho iza koman nga aldaw nga tigpahimlay. ");
INSERT INTO mmn_vpl VALUES ("LK6_8","072_6_8","LUK","6","8","8","Mahagdam si Hisos ka kanirang hena-hena agon minlaong iza ka tao nga komarini ko naa. Tomindeg ko naa dini ka tenga. Kamhan mintoo dazon ya tao. ");
INSERT INTO mmn_vpl VALUES ("LK6_9","072_6_9","LUK","6","9","9","Kamhan nangotana si Hisos ka mga Parasiyo nagalaong nga ya balaed na Diyos mahitenged ka aldaw nga tigpahimlay daw itogot ka pagkalooy ka tao kon itogot ka pagdaet ka tao? ");
INSERT INTO mmn_vpl VALUES ("LK6_10","072_6_10","LUK","6","10","10","Pagseleng ni Hisos kanirang tanan minsogo iza ka tao nga Loy, henaten mo ya kanmong alima. Kamhan inhenat matood naiza ya toong alima. Kamhan minbalik dazon ya kabaskeg na toong alima singed ka karig-en na isang alima. ");
INSERT INTO mmn_vpl VALUES ("LK6_11","072_6_11","LUK","6","11","11","Kamhan nazehet gazed ya mga Parasiyo kan Hisos. Namagsabotsabot dazon siran nga patazen niran si Hisos. ");
INSERT INTO mmn_vpl VALUES ("LK6_12","072_6_12","LUK","6","12","12","Pagkakamhan kaiza minkandaked si Hisos ka kilid na bobong kay ampangamozo iza ka Diyos. Wara iza magheneng pagpangamozo kaiza nga kahabzen. ");
INSERT INTO mmn_vpl VALUES ("LK6_13","072_6_13","LUK","6","13","13","Pagkaaldaw kaiza inpatipon naiza ya toong mga sakop kay pilien naiza ya napolo may dowang ka tao nga toong mga sinarigan. Na, ya ngaran na mga sinarigan ani ya apostolis. ");
INSERT INTO mmn_vpl VALUES ("LK6_14","072_6_14","LUK","6","14","14","Ya primiro ani si Simon nga indagnazan naiza kan Pidro. Sonod si Andris nga toong manghod. Kamhan ya maglomon nga si Santiago daw si Howan. Kamhan si Pilipo daw si Bartolomi ");
INSERT INTO mmn_vpl VALUES ("LK6_15","072_6_15","LUK","6","15","15","daw si Matiyo daw si Tomas daw si Santiago nga maanak ni Alpiyo. Kamhan si Simon nga masinopaken ka hari nga Romanhon. ");
INSERT INTO mmn_vpl VALUES ("LK6_16","072_6_16","LUK","6","16","16","Kamhan si Hodas nga maanak ni Santiago daw si Hodas nga taga Kariyoti ani ya an-edlaw kan Hisos. Ani ini ya mga ngaran na mga sinarigan ni Hisos nga napolo may dowa siran. ");
INSERT INTO mmn_vpl VALUES ("LK6_17","072_6_17","LUK","6","17","17","Na, pagkakamhan ni Hisos pagpili kaniran min-iba iza kaniran paglegsad. Pagdateng naiza ngambaba ka patag minheneng iza kay mintipon dizan ya mga iba nga sakop naiza nga mataed siran. Kamhan masara gazed nga kataed ya mga tao dizan. Garing siran ka mga tanan dapit ka Yoda daw ya siyodad nga Hirosalem daw ya baybazen na dagat tenged ka longsod nga Tiro daw Sidon kay anpanalinga siran ka mga panaba ni Hisos. Ampatambal isab siran ka kanirang mga masakit. ");
INSERT INTO mmn_vpl VALUES ("LK6_18","072_6_18","LUK","6","18","18","Kamhan mindazaw iza ka mga tao nga imboang na mga maonga. ");
INSERT INTO mmn_vpl VALUES ("LK6_19","072_6_19","LUK","6","19","19","Antoldok kontana sirang tanan kan Hisos kay dakola ya toong gahem ka pagpabahaw kanirang tanan. ");
INSERT INTO mmn_vpl VALUES ("LK6_20","072_6_20","LUK","6","20","20","Kamhan minseleng si Hisos ka toong mga sakop daw nagalaong nga kamo nga kanaong mga sakop, masazaen kamo nga mga pobri kay mahatagan kamo na Diyos ka mga madazaw kay iza ya insakopan mazo. ");
INSERT INTO mmn_vpl VALUES ("LK6_21","072_6_21","LUK","6","21","21","Masazaen kamo kon inbengtas kamo koman kay bosogon kamo kay-an. Masazaen kamo nga nagahaza koman kay ankatawa ka kamo kay-an. ");
INSERT INTO mmn_vpl VALUES ("LK6_22","072_6_22","LUK","6","22","22","Masazaen kamo kon nagakontara daw nagabiza daw nagabetangbetang ya mga tao kamazo kay hao ya insakopan mazo. ");
INSERT INTO mmn_vpl VALUES ("LK6_23","072_6_23","LUK","6","23","23","Magsaza kamo kon maazihan mazo ini. Magsazaw kamo ka kasaza kay dakola ya primyo nga in-andam para kamazo daked ka langit. Kay bisan ya mga karaang propita na Diyos nga minhon-a kamazo, siran gihapon indaegdaeg na mga kaapoan na mga mindaegdaeg kamazo. ");
INSERT INTO mmn_vpl VALUES ("LK6_24","072_6_24","LUK","6","24","24","Kamhan kamo nga wili ya kamazong hena-hena ka kamazong kowarta, magalised kamo kay-an kay koman ka lamang ya kamazong kasaza. ");
INSERT INTO mmn_vpl VALUES ("LK6_25","072_6_25","LUK","6","25","25","Nangabosog di kamo koman piro magabengtasen kamo kay-an. Dakola ya kasaza mazo koman piro magahaza gazed kamo kay-an. ");
INSERT INTO mmn_vpl VALUES ("LK6_26","072_6_26","LUK","6","26","26","Kamo nga mga insaza na mga tao magalised kamo kay-an kay bisan ya mga karaang propita nga bakaken, insaza gihapon siran na mga kaapoan na mga minsaza kamazo. ");
INSERT INTO mmn_vpl VALUES ("LK6_27","072_6_27","LUK","6","27","27","Manalinga kamo kanao nga azaken mazo ya kamazong mga kaaway. Dizan ka mga nagakontara kamazo hinangen mazo ya madazaw. ");
INSERT INTO mmn_vpl VALUES ("LK6_28","072_6_28","LUK","6","28","28","Kon andaetdaet ya tao kamazo pagpanaba magsambag kamo ka madazaw. Kon ambetangbetang ya tao kamazo magtabang kamo kanangiza ka pag-ampo ka Diyos. ");
INSERT INTO mmn_vpl VALUES ("LK6_29","072_6_29","LUK","6","29","29","Kon ansampalo ya tao ka pikas nga pisngi mo ihatag mo hinoon ya isang pikas nga pisngi mo. Bisan kawsahan ko kamhan ya ipabazad ani ya kanmong bado idogang pen ya paghatag ka habel mo. ");
INSERT INTO mmn_vpl VALUES ("LK6_30","072_6_30","LUK","6","30","30","Bisan sin-o ya anpakitabang kamazo tagi iza. Kon kawaten ya mga betang mazo diri mazo pagbawien. ");
INSERT INTO mmn_vpl VALUES ("LK6_31","072_6_31","LUK","6","31","31","Magbatasan kamo ka mga iba nga tao singed ka batasan nga in-azakan mazo garing kaniran. ");
INSERT INTO mmn_vpl VALUES ("LK6_32","072_6_32","LUK","6","32","32","Kon anikay pagaazakan mazo ya mga nagakaangay kamazo, diri gazed kamo mahatagan na Diyos ka primyo daked ka langit. Kay bisan ya mga tao nga diri ankilala ka Diyos siran gihapon ya an-angay ka mga nagaangay kaniran. ");
INSERT INTO mmn_vpl VALUES ("LK6_33","072_6_33","LUK","6","33","33","Kon anbales kamo ka madazaw dizan ka mga nagaangay kamazo waray primyo mazo kay anika sab ya batasan na mga diri ankilala ka Diyos. ");
INSERT INTO mmn_vpl VALUES ("LK6_34","072_6_34","LUK","6","34","34","Kon anpaotang kamo ka mga tao nga an-impas kamazo waray primyo mazo kay anika sab ya batasan na mga tao nga diri ankilala ka Diyos. ");
INSERT INTO mmn_vpl VALUES ("LK6_35","072_6_35","LUK","6","35","35","Mag-angay kamo ka kamazong mga kaaway. Diri kamo magbales ka maonga. Magtabang kamo kaniran bisan wara siran magtabang kamazo dazaw ipakita mazo nga kamo ya mga maanak na Diyos nga pinakalabaw. Kamhan dakola ya primyo kamazo kay madazaw ya batasan na Diyos ka tanan mga tao bisan maonga siran daw wara magpasalamat kanangiza. ");
INSERT INTO mmn_vpl VALUES ("LK6_36","072_6_36","LUK","6","36","36","Agon kaloy-an mazo ya bisan sin-o nga tao singed ka pagkalooy na Ama mazo kaniran. ");
INSERT INTO mmn_vpl VALUES ("LK6_37","072_6_37","LUK","6","37","37","Diri kamo maghokom ka iba nga tao. Kamhan diri kamo hokman na Diyos. Diri kamo maghena-hena ka iba nga tao nga silotan iza na Diyos. Kamhan diri kamo silotan na Diyos. Magpasaylo kamo ka sazep na tao kamazo. Kamhan pasaylohon kamo na Diyos. ");
INSERT INTO mmn_vpl VALUES ("LK6_38","072_6_38","LUK","6","38","38","Homatag kamo ka mga mataed nga tao dazaw balsan kamo na Diyos. Ya hatag naiza kamazo singed iton ka isang ka gantang nga pono gazed ka begas daw pasobrahan pen. Kon dakola ya kamazong hatag balsan kamo ka kadakola. Kon geramay ya kamazong hatag balsan kamo ka geramay. ");
INSERT INTO mmn_vpl VALUES ("LK6_39","072_6_39","LUK","6","39","39","Minpamolinged isab si Hisos kaniran nga nagalaong nga ya nabota nga tao daw anhabit iza ka ibang tao nga nabota dazaw antabang ka pagpanaw? Diri. Kay kon ampanaw siran dizan ka dalan maholog gazed sirang dowa dalem ka teheb. ");
INSERT INTO mmn_vpl VALUES ("LK6_40","072_6_40","LUK","6","40","40","Kon gosto ya maistro nga madazaw ya batasan na mga antoon, primiro paniidan na maistro ya toong kaogaringeng batasan. Kay ya mga antoon kon makamhan siran pagtoon ya kanirang batasan daw ya batasan na maistro mag-anika iton. ");
INSERT INTO mmn_vpl VALUES ("LK6_41","072_6_41","LUK","6","41","41","Na, wani ya pamolinged mahitenged ka tao nga nagaazak ka pagpangita ka sazep dizan ka iba nga tao. Ya sala na tao nga nagapangita ka sazep singed iton ka toroso dizan ka mata. Kamhan ya sazep na tao nga inpangitan singed iton ka geramay nga poling dizan ka mata. Kamhan singed ka nabota ya tao nga nagapangita ka sazep kay silaong naiza nga waray sala naiza. ");
INSERT INTO mmn_vpl VALUES ("LK6_42","072_6_42","LUK","6","42","42","Na, onhon sa naiza pagkawa ka geramay nga poling dizan ka mata na iba nga tao kon may toroso dini ka toong mata? Ka primiro pen magbiza iza ka pagpagarbo ka toong batasan, anipen makatabang iza kaiton nga tao pagpabiza ka sala. ");
INSERT INTO mmn_vpl VALUES ("LK6_43","072_6_43","LUK","6","43","43","Ya liwaan nga waray kasakit mamonga iton ka madazaw nga bonga. Ya liwaan nga masakiten diri mamonga ka madazaw nga bonga. ");
INSERT INTO mmn_vpl VALUES ("LK6_44","072_6_44","LUK","6","44","44","Paniidan mazo ya bonga na liwaan kay ani ya timaan ka kahimtang na liwaan. Kay diri mamonga ya makahilo ka madazaw nga protas. ");
INSERT INTO mmn_vpl VALUES ("LK6_45","072_6_45","LUK","6","45","45","Singed iton ka tao kay kon magazon ya hena-hena na tao magazon isab ya panaba na tao. Piro kon maonga ya hena-hena na tao maonga isab ya panaba na tao. Kay bisan ono ya panaba na tao garing iton ka toong hena-hena. ");
INSERT INTO mmn_vpl VALUES ("LK6_46","072_6_46","LUK","6","46","46","Kay ono sa nga magasabi sa kamo kanao nga Ginoo, Ginoo, kamhan wara kamo magtoman ka kanaong sogo kamazo? ");
INSERT INTO mmn_vpl VALUES ("LK6_47","072_6_47","LUK","6","47","47","Pamolinged ini nga bisan sin-o ya nanalinga ka kanaong mga panaba kamhan tomanen naiza singed iza ");
INSERT INTO mmn_vpl VALUES ("LK6_48","072_6_48","LUK","6","48","48","ka tao nga minlagkaw dizan ka lopa nga madazaw ogdokan. Ararem isab ya pagteheb naiza ka toong mga ogdok. Pagkakamhan naiza paglagkaw minbaha ya sapa. Pag-azi ka na sapa dizan ka toong lagkaw diri madeeg iton kay marig-en gazed ya in-ogdokan. ");
INSERT INTO mmn_vpl VALUES ("LK6_49","072_6_49","LUK","6","49","49","Kamhan ya tao nga diri antoman ka kanaong mga panaba singed iza ka tao nga minlagkaw dizan ka lopa nga mahetek. Kamhan diri sab kon ararem ya pag-ogdok naiza. Pagbaha ka na sapa daw pag-azi ka na sapa dizan ka toong lagkaw nadeeg dazon iton kay diri kon marig-en ya ogdok. Nageba dazon ya toong lagkaw. Ani ini ya sindo ni Hisos kaniran. ");
INSERT INTO mmn_vpl VALUES ("LK7_1","072_7_1","LUK","7","1","1","Pagkakamhan ni Hisos pagpanaba ka toong sindo dizan ka pagpanalingzan na mga tao minpasinged iza ngaro ka longsod nga Kapirnaom. ");
INSERT INTO mmn_vpl VALUES ("LK7_2","072_7_2","LUK","7","2","2","Na, doro ka Kapirnaom may nagahela nga isang Romanhon nga kapitan ka mga soldaw. Kamhan may isang sogoonon naiza nga pinayangga nga nagapinal di ka toong masakit. ");
INSERT INTO mmn_vpl VALUES ("LK7_3","072_7_3","LUK","7","3","3","Pagpakabati ka na kapitan nga dizan di si Hisos impakaro naiza ya mga oloolo na mga Yodayo dazaw pakarinihen si Hisos dazaw ipatambal ya toong sogoonon. ");
INSERT INTO mmn_vpl VALUES ("LK7_4","072_7_4","LUK","7","4","4","Pagdateng niran kan Hisos minpakilooy siran nga nagalaong nga bisan Romanhon ya kapitan madazaw kon tabangan mo iza ");
INSERT INTO mmn_vpl VALUES ("LK7_5","072_7_5","LUK","7","5","5","kay nakaangay iza ka mga Yodayo kay izang dini kaini dakola ya pagtabang naiza kanami paghinang ka kanaming singbahan. ");
INSERT INTO mmn_vpl VALUES ("LK7_6","072_7_6","LUK","7","6","6","Kamhan min-iba si Hisos kaniran. Na, ka hapit siran andateng ka lagkaw inpasogat ka isab dazon na kapitan ka toong mga iba kay dazaw long-on si Hisos nga Ginoo, diri di lamang magpadateng ngarini ka lagkaw kay masipeg hao kon ampanik ko dini ka kanaong lagkaw kay diri kon Yodayo hao. ");
INSERT INTO mmn_vpl VALUES ("LK7_7","072_7_7","LUK","7","7","7","Agon kazina impasogoan nao iko ka mga Yodayo. Na, panabaen di mo lamang dini ka dalan dazaw mawara ya masakit na kanaong sogoonon kay labaw gazed ka gahem ya kanmong sogo. ");
INSERT INTO mmn_vpl VALUES ("LK7_8","072_7_8","LUK","7","8","8","Kay bisan hao antoman gazed hao ka sogo na minbeet kanao. Kamhan ansogo isab hao ka mga soldaw. Kon ansogo hao ka isa ka pagpanaw, antoo dazon iza. Kon ansogo hao ka iba ka pagkarini, antoo dazon iza. Kon ansogo hao ka kanaong oripen ka pagtarabaho, antoo dazon iza. ");
INSERT INTO mmn_vpl VALUES ("LK7_9","072_7_9","LUK","7","9","9","Pagpakabati ka ni Hisos ka mga panaba na kapitan nabereng iza kay dakola ya pagsarig naiza ka toong gahem. Kamhan minlaong iza ka mga magasonod ka toong panaw nga ya pagsarig na kapitan ka kanaong gahem dakola iton ka pagsarig na bisan sin-o nga kaliwat ni Israil. ");
INSERT INTO mmn_vpl VALUES ("LK7_10","072_7_10","LUK","7","10","10","Kamhan minbalik ka lagkaw ya mga sinogo na kapitan. Kamhan nakita niran nga madazaw di matood ya sogoonon. ");
INSERT INTO mmn_vpl VALUES ("LK7_11","072_7_11","LUK","7","11","11","Na, ka wara pen madogay minpasinged si Hisos ngaro ka longsod nga Nain. In-ibahan gihapon na toong mga sakop daw ya mga mataed nga tao. ");
INSERT INTO mmn_vpl VALUES ("LK7_12","072_7_12","LUK","7","12","12","Pagdateng ka naiza ka pirtahan na longsod insogat naiza ya mga tao nga namaglahong ka napatay kay ilebeng. Na, ya napatay nga amaama bogtong maanak iza na balo nga babazi. Kamhan mataed ya mga taga Nain min-iba ka balo pagkaro ka lebnganan. ");
INSERT INTO mmn_vpl VALUES ("LK7_13","072_7_13","LUK","7","13","13","Pagpakakita ka na Ginoo ka nabalo nga napatzan nagakalooy iza kamhan nagalaong nga diri ko maghaza. ");
INSERT INTO mmn_vpl VALUES ("LK7_14","072_7_14","LUK","7","14","14","Kamhan minkandizan si Hisos ka bentaganan na napatay nga inlahongan niran. Kamhan pagdampa naiza ka binentagan na napatay minheneng siran pagpanaw. Kamhan minlaong si Hisos ka napatay nga Loy, bomangon iko. ");
INSERT INTO mmn_vpl VALUES ("LK7_15","072_7_15","LUK","7","15","15","Kamhan minbangon matood ya tao daw minsogod iza pagpanaba. Kamhan imbalik iza ni Hisos ka toong ina. ");
INSERT INTO mmn_vpl VALUES ("LK7_16","072_7_16","LUK","7","16","16","Masara gazed ya pagpangabereng nirang tanan. Insaza sab niran ya Diyos nagalaong nga madazaw kay dini kanta mindateng di ya propita nga labaw ka gahem nga garing ka Diyos. Wara gazed magkalipat ya Diyos kanta nga toong mga sakop. ");
INSERT INTO mmn_vpl VALUES ("LK7_17","072_7_17","LUK","7","17","17","Kamhan ya inhinang ni Hisos inpanan-og ka tanan mga tao doro ka Yoda daw ya mga dapit tenged ka Yoda. ");
INSERT INTO mmn_vpl VALUES ("LK7_18","072_7_18","LUK","7","18","18","Kamhan impanan-og sab kan Howan na toong mga sakop kay doro pen ka prisohan si Howan nga Magbenzagay. ");
INSERT INTO mmn_vpl VALUES ("LK7_19","072_7_19","LUK","7","19","19","Kamhan impakaro ni Howan ya toong dowang ka sakop kan Hisos kay anpangotana kon tineed gazed nga iza ya pinili na Diyos kon antagad pen siran ka isa. ");
INSERT INTO mmn_vpl VALUES ("LK7_20","072_7_20","LUK","7","20","20","Pagdateng niran kan Hisos minlaong siran nga Ginoo, si Howan nga Magbenzagay ani minsogo kanami kay anpangotana kanmo nga daw iko ya pinili na Diyos kon antagad pen kami ka isa? ");
INSERT INTO mmn_vpl VALUES ("LK7_21","072_7_21","LUK","7","21","21","Na, ka wara pen iza magsambag indazaw naiza ya mga mataed nga tao ka kanirang mga masakit daw kaloza na lawas. Indazaw sab naiza ya mga tao nga inharian na mga maonga. Minhatag sab iza ka pagkita na mga mataed nga nabota. ");
INSERT INTO mmn_vpl VALUES ("LK7_22","072_7_22","LUK","7","22","22","Kamhan minsambag si Hisos ka mga sakop ni Howan nga panan-ogan mazo si Howan ka mga napaniidan mazo dini kanao daw ya kamazong nabatian. Kay hao ya magahatag ka pagkita ka mga nabota. Indazaw sab nao ya lawas na mga piang. Indazaw sab nao ya lawas na mga kagiden. Minhatag hao ka pagpakabati ka mga bengel. Imbohi sab nao ya mga napatay nga tao. Ipasabot sab nao ka mga pobri ya sindo mahitenged ka Diyos. ");
INSERT INTO mmn_vpl VALUES ("LK7_23","072_7_23","LUK","7","23","23","Kon diri andowadowa ya tao pagsarig kanao panaranginan gazed iza na Diyos ka madazaw. ");
INSERT INTO mmn_vpl VALUES ("LK7_24","072_7_24","LUK","7","24","24","Pagpakaoli ka na dowang ka sakop ni Howan minpangotana si Hisos ka kataohan mahitenged kan Howan nga nagalaong nga izang mahon-a pen pagkaro mazo dizan kan Howan doro ka kamingawan daw ono ya tozo mazo dizan kan Howan? Daw anseleng kamo kontana ka tigbaw nga nagapapalidpalid ka hangin? Diri. ");
INSERT INTO mmn_vpl VALUES ("LK7_25","072_7_25","LUK","7","25","25","Daw anseleng kamo kontana ka tao nga minbado ka mga mahalen? Diri. Kay nagahela ya singed kaiton dalem ka lagkaw na hari. ");
INSERT INTO mmn_vpl VALUES ("LK7_26","072_7_26","LUK","7","26","26","Daw minkaro kamo dazaw anseleng kamo ka propita na Diyos? Matood iton. Kamhan si Howan labaw pen iza ka mga iba nga propita na Diyos. ");
INSERT INTO mmn_vpl VALUES ("LK7_27","072_7_27","LUK","7","27","27","Kay iza ya inpanan-og ni Isayas nga nagalaong nga kawandini pen minlaong ya Diyos nga may sinogo nao nga ipahon-a nao dazaw an-andam iza ka pagdateng na kanaong Maanak. Ani ini ya inlaong na Diyos mahitenged kan Howan. ");
INSERT INTO mmn_vpl VALUES ("LK7_28","072_7_28","LUK","7","28","28","Indogangan pen ni Hisos paglaong nga pasabten nao kamo nga bisan sin-o ya propita nga natao dini ka kalibotan waray nakalabaw kan Howan. Piro dini kanao koman bisan sin-o ya labing obos nga minsakop kanao labaw iza kan Howan kay ya kasabtan naiza ka kanaong mga inhinang dakola pen iton ka kasabtan ni Howan. ");
INSERT INTO mmn_vpl VALUES ("LK7_29","072_7_29","LUK","7","29","29","Izang dini kaini ka pagwali ni Howan nanalinga ya tanan mga tao daw ya mga magsokotay ka bohis. Kamhan mintoo siran ka mga panaba na Diyos. Kamhan imbenzagan siran ni Howan. ");
INSERT INTO mmn_vpl VALUES ("LK7_30","072_7_30","LUK","7","30","30","Piro ya mga Parasiyo daw ya mga maistro ka tinoohan na mga Yodayo diri siran ansogot ka gosto na Diyos. Kamhan wara siran magpabenzag kan Howan. ");
INSERT INTO mmn_vpl VALUES ("LK7_31","072_7_31","LUK","7","31","31","Indogangan pen ni Hisos pagpanaba nga koman nga panahona pagpanalinga na mga Yodayo ka sindo nami ni Howan ");
INSERT INTO mmn_vpl VALUES ("LK7_32","072_7_32","LUK","7","32","32","singed siran ka mga bata nga nagadegza dizan ka pawa. Kamhan ya isang tipon nagamahay ka isang tipon nga nagalaong nga nagahoyop kami ka bonabon piro wara kamo magsazaw. Nagabaya-baya isab kami paglingaw piro wara kamo maghaza. ");
INSERT INTO mmn_vpl VALUES ("LK7_33","072_7_33","LUK","7","33","33","Singed kaiton ya batasan na mga Yodayo kay izang pagkarini ni Howan nga Magbenzagay nagaanget iza pagkaen, wara iza mag-inem ka makahebeg nga imnenen. Kamhan minlaong kamo nga inboang si Howan na mga maonga. ");
INSERT INTO mmn_vpl VALUES ("LK7_34","072_7_34","LUK","7","34","34","Kamhan hao ya minsonod kan Howan. Nagakaen hinoa hao daw min-inem. Kamhan minbetangbetang kamo kanao nga nagalaong nga selengi, waton ya maasap daw palahebeg. Nagapan-iba sab iza ka mga magsokotay ka bohis daw ya mga iba nga tao nga makasasala. ");
INSERT INTO mmn_vpl VALUES ("LK7_35","072_7_35","LUK","7","35","35","Piro nagalaong hao kamazo nga ya mga nakaangay ka sindo na Diyos siran kay mahagdam nga matadeng ya kanaming batasan ni Howan. ");
INSERT INTO mmn_vpl VALUES ("LK7_36","072_7_36","LUK","7","36","36","Na, may isang Parasiyo nga minpakaen kan Hisos. Kamhan minpanik si Hisos dizan ka toong lagkaw kay inlamisahan di ka makaen. ");
INSERT INTO mmn_vpl VALUES ("LK7_37","072_7_37","LUK","7","37","37","Na, dizan kaiton nga longsod may nagahela nga maongang babazi. Kamhan nabatian naiza nga dizan di si Hisos ka lagkaw na Parasiyo kay impakaen si Hisos. Kamhan mindateng di ya babazi. Mindara iza ka garapahay nga seldanan ka klasi na lana nga masarang kahamot. Mahal iton kon paliten. ");
INSERT INTO mmn_vpl VALUES ("LK7_38","072_7_38","LUK","7","38","38","Kamhan mintindeg ya babazi dizan ka paahan ni Hisos daw nagahaza. Kamhan nabasà ya paa ni Hisos ka loha na babazi agon intrapohan sab naiza ya paa ni Hisos ka toong bohok. Inhinang sab naiza ya batasan niran pagtahod niran ka bisita nga min-arek ka paa ni Hisos. Kamhan min-otod ya babazi ka lieg na garapahay kay ibo-bo naiza ka paa ni Hisos. ");
INSERT INTO mmn_vpl VALUES ("LK7_39","072_7_39","LUK","7","39","39","Pagpaniid ka na Parasiyo ka inhinang na babazi minlaong iza ka toong hena-hena nga kon ani ini ya matood nga propita na Diyos mahagdam iza nga maonga ya batasan na babazi nga nagatoldok kanangiza. ");
INSERT INTO mmn_vpl VALUES ("LK7_40","072_7_40","LUK","7","40","40","Kamhan minlaong si Hisos ka Parasiyo nga Simon, may ilaong ta kanmo. Minsambag si Simon nga Nong, long-an mo hao kon ono iton. ");
INSERT INTO mmn_vpl VALUES ("LK7_41","072_7_41","LUK","7","41","41","Kamhan minpamolinged si Hisos nga nagalaong nga may dowang ka tao nga min-otang dizan ka magpaotangay. Ya isa nakaotang ka kinintos pisos. Ya isa nakaotang ka singkwinta pisos. ");
INSERT INTO mmn_vpl VALUES ("LK7_42","072_7_42","LUK","7","42","42","Pagtoman ka na tirmino ka pagbazad waray kowarta niran piro madazaw kay impasaylo di siran na naotangan. Na, dizan kanirang dowa daw sin-o ya may dakolang pag-azak ka naotangan? ");
INSERT INTO mmn_vpl VALUES ("LK7_43","072_7_43","LUK","7","43","43","Minsambag si Simon nga ya tao nga may dakolang otang kombeet. Minlaong si Hisos nga madazaw ya sambag mo. ");
INSERT INTO mmn_vpl VALUES ("LK7_44","072_7_44","LUK","7","44","44","Kamhan minlingi si Hisos ka babazi daw nagalaong nga Simon, selengan mo iton nga babazi. Dakola ya pagtahod naiza kanao kay minhogas iza ka kanaong paa ka toong loha kamhan intarapohan ka toong bohok ya kanaong paa. Piro kanmo geramay ya pagtahod mo kanao kay kazina ka pagdateng nao dini ka lagkaw mo wara ko maghatag kanao ka sapa ka paghogas ka kanaong paa. ");
INSERT INTO mmn_vpl VALUES ("LK7_45","072_7_45","LUK","7","45","45","Wara ko magpangamosta kanao singed ka babazi kay sokad ka pagdateng naiza impakita naiza ya toong pagtahod kanao pag-arek naiza ka kanaong paa. ");
INSERT INTO mmn_vpl VALUES ("LK7_46","072_7_46","LUK","7","46","46","Wara ko magbo-bo ka kanaong olo ka bisan barato nga lana piro imbo-boan na babazi ya kanaong paa ka lana nga mahamot daw mahal. ");
INSERT INTO mmn_vpl VALUES ("LK7_47","072_7_47","LUK","7","47","47","Sabten mo ini nga dakola ya pag-azak na babazi kanao kay nawara ya toong mga sala bisan mataed ya sala. Piro ya tao nga magalaong ka toong hena-hena nga geramay ka ya toong sala geramay ka sab ya pag-azak naiza ka Diyos. ");
INSERT INTO mmn_vpl VALUES ("LK7_48","072_7_48","LUK","7","48","48","Kamhan minlaong si Hisos ka babazi nga nawara di gazed ya kanmong mga sala. ");
INSERT INTO mmn_vpl VALUES ("LK7_49","072_7_49","LUK","7","49","49","Pagpakabati ka na mga ibang dinapit namaglaong siran nga sin-o sa kombeet iton nga tao nga makapasaylo ka mga sala? ");
INSERT INTO mmn_vpl VALUES ("LK7_50","072_7_50","LUK","7","50","50","Kamhan indogangan pen ni Hisos pagpanaba ka babazi nga ya pagsarig mo kanao ani gazed ya nakawara ka mga sala mo. Om-oli ko naa kay impalinaw di nao ya kanmong hinawa. ");
INSERT INTO mmn_vpl VALUES ("LK8_1","072_8_1","LUK","8","1","1","Ka wara pen madogay minbisita si Hisos ka mga mataed nga longsod daw bariyo kay antoldo iza ka mga tao ka sindo mahitenged ka pagpasakop na Diyos ka mga tao. In-ibahan na toong mga sinarigan nga napolo may dowa siran. ");
INSERT INTO mmn_vpl VALUES ("LK8_2","072_8_2","LUK","8","2","2","In-ibahan isab na mga babazi nga nabahawan di ka mga masakit daw ya mga maonga. Dizan isab si Mariya nga taga Magdala nga izang mahon-a pen inharian iza na pitong ka maonga kamhan impadalagan siran ni Hisos. ");
INSERT INTO mmn_vpl VALUES ("LK8_3","072_8_3","LUK","8","3","3","May isa pen nga babazi si Zohana nga asawa ni Koza nga sinarigan ni Hirodis nga hari. Dizan isab si Sosana daw ya mga mataed pen nga babazi nga mintabang kanin Hisos. ");
INSERT INTO mmn_vpl VALUES ("LK8_4","072_8_4","LUK","8","4","4","Kamhan dizan kan Hisos mintipon ya mga mataed nga tao. Garing siran ka mga nagakalainlain bariyo. Kamhan mintoldo iza kaniran ka pamolinged nga nagalaong nga ");
INSERT INTO mmn_vpl VALUES ("LK8_5","072_8_5","LUK","8","5","5","wani ya pamolinged ka nagasabwag. Na, may isang aldaw nga minpanaw ya tao ngaro ka toong oma kay anpanabwag iza ka binhi nga homay. Pagpanabwag naiza ka mga binhi may mga natanak dizan ka dalan. Kamhan insagitnanan dizan. Kamhan inpanoktok na mga manokmanok. ");
INSERT INTO mmn_vpl VALUES ("LK8_6","072_8_6","LUK","8","6","6","Pagpanabwag pen na tao may mga natanak disab dizan ka kabatohan. Pagtobo na binhi dizan ka diri kon ararem nga lopa nangalaza dazon iton kay waray sapa. ");
INSERT INTO mmn_vpl VALUES ("LK8_7","072_8_7","LUK","8","7","7","May mga natanak disab dizan ka lopa nga nanhela pen ya mga liso na sagbet. Pagtobo na binhi mindengan isab ya sagbet nga dogihen. Kamhan inhal-ong gazed na sagbet ya mga tanem. ");
INSERT INTO mmn_vpl VALUES ("LK8_8","072_8_8","LUK","8","8","8","May mga natanak isab dizan ka lopa nga madazaw. Kamhan mintobo iton daw nangaohay ka isang ka gatos. Ani ini ya pamolinged ka nagasabwag. Kamhan minlaong si Hisos kaniran nga kamo nga mga manalingahay sabten mazo ini nga pamolinged. ");
INSERT INTO mmn_vpl VALUES ("LK8_9","072_8_9","LUK","8","9","9","Kamhan ya mga sakop ni Hisos nangotana siran kanangiza nga Nong, daw ono ya kahologan na pamolinged mo? ");
INSERT INTO mmn_vpl VALUES ("LK8_10","072_8_10","LUK","8","10","10","Minsambag si Hisos nga ipasabot na Diyos kamazo ya mga tinago mahitenged ka pagpasakop naiza ka mga tao. Piro dizan ka mga mataed nga tao ampamolinged hao pagtoldo kaniran. Kay mintoman di ya daan pinasoyat na Diyos mahitenged kaniran nagalaong nga bisan magaseleng ya mga tao ka kanaong mga inhinang diri siran makasabot. Bisan manalinga siran ka kanaong sindo diri siran makasabot kon ono ya kahologan. ");
INSERT INTO mmn_vpl VALUES ("LK8_11","072_8_11","LUK","8","11","11","Na, wani ya paghilwas ka pamolinged ka nagasabwag. Ya impanabwag na tao ani ya mga panaba na Diyos. ");
INSERT INTO mmn_vpl VALUES ("LK8_12","072_8_12","LUK","8","12","12","Kamhan ya mga binhi nga natanak dizan ka dalan ani ya singed ka mga manalingahay. Kay pagpanalinga niran ka sindo mahitenged kanao mindateng dazon si Satanas kay kaw-en naiza ya sindo nga nabatian niran dazaw diri siran antoo daw diri sab mahatagan siran ka bag-ong kinabohi nga diri mawara. ");
INSERT INTO mmn_vpl VALUES ("LK8_13","072_8_13","LUK","8","13","13","Kamhan ya mga binhi nga natanak dizan ka kabatohan ani ya singed ka mga manalingahay nga nakaangay ka sindo mahitenged kanao. Kamhan mintoo siran dazon. Piro magaawazen gazed siran na mga tao kay minsakop di siran kanao agon bizaan dazon niran ya kanirang pagtoo kanao kay ababa ka ya kanirang pag-anget ka kalised. ");
INSERT INTO mmn_vpl VALUES ("LK8_14","072_8_14","LUK","8","14","14","Kamhan ya mga binhi nga natanak dizan ka lopa nga nanhela pen ya mga liso na sagbet ani ya singed ka mga iba pen nga manalingahay. Kay nagapanalinga gazed siran ka sindo mahitenged kanao. Kamhan nawied sab siran daw ono ya kanirang panginabohi. Ganahan sab siran ka kowarta. Agon waray polos ya sindo kay singed ka nalipat dazon ya mga manalingahay. ");
INSERT INTO mmn_vpl VALUES ("LK8_15","072_8_15","LUK","8","15","15","Basta kay ya mga binhi nga napegas dizan ka lopa nga magazong tamnanan singed iton ka mga manalingahay ka sindo mahitenged kanao. Kamhan matood ya kanirang pagtoo. Dogay isab ya kanirang pag-anget ka mga kalised. Kamhan singed siran ka tanem nga madazaw ya mga bonga. ");
INSERT INTO mmn_vpl VALUES ("LK8_16","072_8_16","LUK","8","16","16","Kamhan minpamolinged pen iza kaniran nga nagalaong nga kon seg-an na tao ya moron diri pagtakloban, diri sab pagsalimdan. Ibetang hinoa daked ka artal kay dazaw pawaan ya mga minseled ka lagkaw. ");
INSERT INTO mmn_vpl VALUES ("LK8_17","072_8_17","LUK","8","17","17","Singed iton ka ipasabot nao kamazo ya kanaong mga pamolinged. Impakahagdam sab nao kamazo ya mga tinago na Diyos. ");
INSERT INTO mmn_vpl VALUES ("LK8_18","072_8_18","LUK","8","18","18","Manalinga gazed kamo dazaw ihatag pen kamazo na Diyos ya kasabtan kay bisan sin-o ya antoon ka sindo na Diyos padogangan pen na Diyos ya toong kasabtan. Kamhan ya tao nga diri antoman kaw-en na Diyos ya geramay nga inton-an naiza. Ani ini ya inlaong ni Hisos ka mga tao. ");
INSERT INTO mmn_vpl VALUES ("LK8_19","072_8_19","LUK","8","19","19","Kamhan minkarini kan Hisos ya toong ina daw mga lomon piro wara siran makaazi dizan kay mataed ya mga tao. ");
INSERT INTO mmn_vpl VALUES ("LK8_20","072_8_20","LUK","8","20","20","Kamhan impakahagdam iza na mga tao nga Nong, bali ka gawas ya kanmong ina daw mga lomon. Gosto siran anlaong kanmo. ");
INSERT INTO mmn_vpl VALUES ("LK8_21","072_8_21","LUK","8","21","21","Minsambag si Hisos nga ya mga tao nga ampanalinga ka mga panaba na Diyos daw tomanen ani gazed ya kanaong ina daw mga lomon. ");
INSERT INTO mmn_vpl VALUES ("LK8_22","072_8_22","LUK","8","22","22","Na, may isa pen nga aldaw minleen si Hisos ka baloto iba ya toong mga sinarigan. Kamhan minlaong iza kaniran nga ansakay kita dipi ka danaw. Kamhan minsakay siran ngaro. ");
INSERT INTO mmn_vpl VALUES ("LK8_23","072_8_23","LUK","8","23","23","Ka nagasakay pen siran natorog di si Hisos. Ka dizan pen siran ka tenga na danaw inbagzo gazed siran. Insapwan dazon na baled ya baloto daw malened kontana. ");
INSERT INTO mmn_vpl VALUES ("LK8_24","072_8_24","LUK","8","24","24","Kamhan impokaw dazon niran si Hisos daw nagalaong nga Maistro, Maistro, mangalemes di kita! Minbangon dazon si Hisos. Kamhan minbaheg iza ka hangin daw mga baled. Kamhan nalinaw matood ya tanan. ");
INSERT INTO mmn_vpl VALUES ("LK8_25","072_8_25","LUK","8","25","25","Kamhan minlaong si Hisos kaniran nga daw waray pagsarig mazo kanao? Kamhan nagakahaldek siran kay nabereng gazed siran daw namaglaong nga daw sin-o sa baza ini nga taohana? Kay bisan ya hangin daw ya mga baled antoo gazed ka toong pagbaheg! ");
INSERT INTO mmn_vpl VALUES ("LK8_26","072_8_26","LUK","8","26","26","Pagkakamhan ni Hisos pagbaheg ka bagzo minsangpet di siran ka lopa nga Girgasa dipi ka danaw daw lopa nga Galiliya. ");
INSERT INTO mmn_vpl VALUES ("LK8_27","072_8_27","LUK","8","27","27","Pagkawas ka ni Hisos ka baloto may tao nga taga dizan nga inhoropan gazed na maonga nga minsogat kanangiza. Dogay di ya paghinobo naiza. Diri kon lagkaw ya toong hel-anan kay dizan ka mga lebeng nga talangban nagahela iza. ");
INSERT INTO mmn_vpl VALUES ("LK8_28","072_8_28","LUK","8","28","28","Na, pagpakakita ka naiza kan Hisos minsinggit iza. Kamhan minhapa iza dizan ka paahan ni Hisos. Mabaskeg ya toong saba paglaong nga Hisos nga Maanak na Diyos, kay ono say inkarini mo? Anhangzo gazed hao nga diri mo gazed hao daegdaegen! ");
INSERT INTO mmn_vpl VALUES ("LK8_29","072_8_29","LUK","8","29","29","Ani ini ya inlaong na maonga nga minhari ka tao kay minsogo si Hisos nga domalagan ko dizan kaini nga tao. Kay dogay di ya toong kalised nga garing ka maonga. Imbantazan iza na mga tao daw in-ektan kontana piro nakabogto iza ka kadina daw lepes. Kamhan impadalagan iza na mga maonga ngaro ka kamingawan. ");
INSERT INTO mmn_vpl VALUES ("LK8_30","072_8_30","LUK","8","30","30","Kamhan nangotana si Hisos ka maonga nga daw ono ya ngaran mo? Minsambag iza nga hao si Kataedan. Ani ini ya toong ngaran kay mataed ya mga maonga nga minhari kaiton nga tao. ");
INSERT INTO mmn_vpl VALUES ("LK8_31","072_8_31","LUK","8","31","31","Kamhan minhangzo ya mga maonga nga kon malooy ko kanami, diri mo kami pagbogawen ngaro ka ararem nga teheb nga waray lopa nga kasagitnan. ");
INSERT INTO mmn_vpl VALUES ("LK8_32","072_8_32","LUK","8","32","32","Na, dizan ka kilid na bobong nagapansongad ya mga kababozan. Kamhan minhangzo ya mga maonga kan Hisos nga kon malooy ko kanami papanawen mo kami ngaro ka mga baboy. Pahel-en mo kami ka kanirang mga lawas. Kamhan intogotan siran ni Hisos. ");
INSERT INTO mmn_vpl VALUES ("LK8_33","072_8_33","LUK","8","33","33","Kamhan minpanaw ya mga maonga dizan ka lawas na tao. Minhari siran ka mga baboy. Kamhan minpahidalagan ya kababozan ngaro ka may pangpang nga ataas. Minpatiholog siran ngambaba ka danaw. Kamhan natibe siran pagkalemes. ");
INSERT INTO mmn_vpl VALUES ("LK8_34","072_8_34","LUK","8","34","34","Pagpakakita ka na mga magbantazay ka mga baboy nandalagan gazed siran ngaro ka kanirang longsod daw ya mga bariyo kay ampanan-og ka mga tao kon in-ono ni Hisos ya tao nga inhoropan ka maonga. ");
INSERT INTO mmn_vpl VALUES ("LK8_35","072_8_35","LUK","8","35","35","Kamhan minkarini dazon kan Hisos ya mga tao kay anseleng siran kontana ka tao kon in-ono sa iza. Pagdateng niran kan Hisos nakitan niran ya tao nga indazaw ni Hisos. Iza nga inhoropan na mga mataed nga maonga nagalo-to di iza dizan ka paahan ni Hisos. Inbadoan disab iza kay naolian ka madazaw nga beet. Kamhan nahaldek ya mga mindateng. ");
INSERT INTO mmn_vpl VALUES ("LK8_36","072_8_36","LUK","8","36","36","Kamhan ya mga minkita ka inhinang ni Hisos kazina, siran ya minpanan-og ka mga bag-ong mindateng nga indazaw ni Hisos ya tao nga inhoropan na maonga. ");
INSERT INTO mmn_vpl VALUES ("LK8_37","072_8_37","LUK","8","37","37","Kamhan ya tanan mga taga Girgasa minhangzo siran kan Hisos dazaw ampanaw iza dini ka kanirang lopa. Kay masara ya pagpangahaldek niran kay dakola gazed ya toong gahem. Kamhan minleen si Hisos ka baloto dazaw ampanaw. ");
INSERT INTO mmn_vpl VALUES ("LK8_38","072_8_38","LUK","8","38","38","Kamhan ya tao nga indazaw ni Hisos minhangzo iza nga an-iba piro diri iza paibahen ni Hisos. ");
INSERT INTO mmn_vpl VALUES ("LK8_39","072_8_39","LUK","8","39","39","Hinoa intogon nga om-oli ko ka mga lomon mo. Maglaong ko kaniran nga madazaw di ya lawas mo kay inkaloy-an ko na Diyos. Kamhan minkaro ya tao doro ka longsod. Minpanan-og iza ka tanan mga tao kon in-ono sa iza ni Hisos. ");
INSERT INTO mmn_vpl VALUES ("LK8_40","072_8_40","LUK","8","40","40","Na, pag-oli ni Hisos ngarindipi ka lopa nga Galiliya mataed ya mga tao nga minsogat kanangiza. ");
INSERT INTO mmn_vpl VALUES ("LK8_41","072_8_41","LUK","8","41","41","Kamhan may isang oloolo ka singbahan na mga Yodayo nga minkarini kan Hisos. Si Hariyo ya ngaran. Paglohod naiza dizan ka paahan ni Hisos minpakilooy gazed iza nagalaong nga kon mahimo ya beet mo ibahan mo hao ngaro ka kanaong lagkaw ");
INSERT INTO mmn_vpl VALUES ("LK8_42","072_8_42","LUK","8","42","42","kay nagapinal di ya kanaong bogtong maanak nga daragahay. Kamhan min-iba si Hisos kan Hariyo. Nagakasiet gazed iza nga nagapanaw kay mataed ya mga tao. ");
INSERT INTO mmn_vpl VALUES ("LK8_43","072_8_43","LUK","8","43","43","Na, may nagalopog kan Hisos nga babazi nga sokad ka napolo may dowang ka toig wara magheneng ya toong pagdog-a. Nagastohan disab iza ka mga mataed nga doktor piro wara pen mawara ya toong masakit. ");
INSERT INTO mmn_vpl VALUES ("LK8_44","072_8_44","LUK","8","44","44","Pagsonod naiza kan Hisos mintoldok iza ka pilos na toong bado. Kamhan madazaw matood ya toong lawas. ");
INSERT INTO mmn_vpl VALUES ("LK8_45","072_8_45","LUK","8","45","45","Kamhan nangotana si Hisos nga daw sin-o say mintoldok kanao? Minsambag sirang tanan nga diri kon hao. Kamhan minlaong si Pidro nga Nong, masara gazed nga kataed ya mga tao nga minheet kanmo. ");
INSERT INTO mmn_vpl VALUES ("LK8_46","072_8_46","LUK","8","46","46","Minsambag si Hisos nga may mintoldok kanao kay imbati gazed nao nga mintambal di hao ka tao. ");
INSERT INTO mmn_vpl VALUES ("LK8_47","072_8_47","LUK","8","47","47","Kamhan minkarini ya babazi kay mahagdam di iza nga diri mahimo ya pagtago. Paglohod naiza dizan ka paahan ni Hisos nagapidpid gazed ya toong lawas ka kahaldek. Kamhan dizan ka nabatian na mga tao minpanaba iza nga hao ya mintoldok ka kanmong bado kazina kay may kasakit nao. Kamhan madazaw matood ya kanaong lawas. ");
INSERT INTO mmn_vpl VALUES ("LK8_48","072_8_48","LUK","8","48","48","Minsambag si Hisos nga Day, basta ya pagsarig mo kanao madazaw di ya lawas mo. Om-oli ko naa. Diri ko magkawied kay diri ambalik ya kasakit mo. ");
INSERT INTO mmn_vpl VALUES ("LK8_49","072_8_49","LUK","8","49","49","Ka nagapanaba pen si Hisos may tao nga min-apas nga garing ka lagkaw ni Hariyo nga izang oloolo ka singbahan na mga Yodayo. Kamhan minlaong ya min-apas nga Hariyo, diri ko magpaiba kan Hisos ngaro ka lagkaw kay nawara di ya maanak mo. ");
INSERT INTO mmn_vpl VALUES ("LK8_50","072_8_50","LUK","8","50","50","Pagpakabati ka ni Hisos minsambag iza kan Hariyo nga diri ko magkawied. Magsarig ko naa kanao dazaw mabahaw ya maanak mo. ");
INSERT INTO mmn_vpl VALUES ("LK8_51","072_8_51","LUK","8","51","51","Pagdateng niran ka lagkaw diri ni Hisos ya mga tao paselden. Impaseled lamang si Pidro daw si Howan daw si Santiago daw ya ginikanan na bata. ");
INSERT INTO mmn_vpl VALUES ("LK8_52","072_8_52","LUK","8","52","52","Kamhan nagahaza gazed ya mga tao dizan kay nawara di ya bata. Kamhan minlaong si Hisos kaniran nga diri kamo maghaza kay diri kon patay ya bata. Igo ka lamang iza matorog. ");
INSERT INTO mmn_vpl VALUES ("LK8_53","072_8_53","LUK","8","53","53","Kamhan inkatawhan niran si Hisos kay mahagdam siran nga wara di ya babazi. ");
INSERT INTO mmn_vpl VALUES ("LK8_54","072_8_54","LUK","8","54","54","Kamhan minseled si Hisos ka kowarto nga inbentagan na babazi. Kamhan intagenan ni Hisos ya alima na babazi daw minsogo nga Day, bomangon ko naa. ");
INSERT INTO mmn_vpl VALUES ("LK8_55","072_8_55","LUK","8","55","55","Kamhan minbalik matood ya hinawa na babazi. Minbangon dazon iza. Kamhan minsogo si Hisos kaniran nga pakanen naa ya babazi. ");
INSERT INTO mmn_vpl VALUES ("LK8_56","072_8_56","LUK","8","56","56","Kamhan dakola gazed ya pagkabereng na toong ginikanan. Minsogo si Hisos kaniran nga diri kamo magpanaba dizan ka mga tao nga indazaw di nao iza. Ani ini ya pagtabang ni Hisos ka maanak ni Hariyo. ");
INSERT INTO mmn_vpl VALUES ("LK9_1","072_9_1","LUK","9","1","1","Na, pagkakamhan kaiza inpatipon ni Hisos ya toong mga sinarigan nga napolo may dowa siran. Kamhan intagan siran naiza ka gahem ka pagpadalagan ka tanan mga maonga. Intagan isab siran ka gahem ka pagpanbahaw ka mga masakit. ");
INSERT INTO mmn_vpl VALUES ("LK9_2","072_9_2","LUK","9","2","2","Kamhan impakaro siran naiza ngaro ka mga tao dazaw anwali siran ka sindo mahitenged ka pagpasakop na Diyos ka mga tao. Panbahawen sab niran ya mga masakiten. ");
INSERT INTO mmn_vpl VALUES ("LK9_3","072_9_3","LUK","9","3","3","Intogon sab siran nagalaong nga pikit ka lawas ka lamang ya dara mazo, waray lain harominta. Diri kamo maghabay ka kowarta. Diri sab kamo maglapid ka bado. ");
INSERT INTO mmn_vpl VALUES ("LK9_4","072_9_4","LUK","9","4","4","Dizan ka lagkaw nga inpanikan mazo maghela gazed kamo hastang ka pagpanaw mazo. ");
INSERT INTO mmn_vpl VALUES ("LK9_5","072_9_5","LUK","9","5","5","Dizan ka bariyo nga diri an-abiabi kamazo izabzab mazo ya abog dizan ka paa mazo dazaw mahagdam siran nga silotan siran kay-an kay diri siran an-angay ka sindo na Diyos ka pagpanalinga. ");
INSERT INTO mmn_vpl VALUES ("LK9_6","072_9_6","LUK","9","6","6","Pagkakamhan ni Hisos pagtogon kaniran minpanaw siran kay an-azi siran ka mga mataed nga bariyo. Nagawali siran ka sindo mahitenged kan Kristo. Inpanbahawan sab niran ya mga nabedlay. ");
INSERT INTO mmn_vpl VALUES ("LK9_7","072_9_7","LUK","9","7","7","Na, ka nagapasinged pen ya mga sakop ni Hisos doro ka mga lain dapit nabatian ni Hirodis nga hari kon ono ya hinang niran. Kamhan dakola ya toong kawied kay nagalaong ya mga tao nga si Hisos ani si Howan nga Magbenzagay. Nabohi iza pagbalik garing ka lebeng. ");
INSERT INTO mmn_vpl VALUES ("LK9_8","072_9_8","LUK","9","8","8","May mga iba nga tao nga nagalaong nga si Hisos ani si Iliyas nga karaang propita na Diyos. May mga iba pen nga tao nga nagalaong nga si Hisos propita iza singed ka isa pen nga karaang propita. ");
INSERT INTO mmn_vpl VALUES ("LK9_9","072_9_9","LUK","9","9","9","Kamhan minlaong si Hirodis nga izang dini kaini inpaotdan nao ya lieg ni Howan agon sin-o kombeet iton nga taohana nga impanan-og kanao na mga tao. Kamhan gosto gazed iza anseleng kan Hisos. ");
INSERT INTO mmn_vpl VALUES ("LK9_10","072_9_10","LUK","9","10","10","Na, pag-oli ka na mga sinarigan ni Hisos inpanan-ogan niran iza kon ono ya hinang niran. Kamhan inpaiba siran ni Hisos doro ka longsod nga Bitsayda kay ampahimlay siran. ");
INSERT INTO mmn_vpl VALUES ("LK9_11","072_9_11","LUK","9","11","11","Kamhan dizan ka inpanawan niran mataed di ya mga mahagdam nga waro di sin Hisos agon nang-apas siran. Min-abiabi si Hisos kaniran kamhan minsindo iza kaniran mahitenged ka pagpasakop na Diyos kaniran. Inpanbahaw sab naiza ya mga masakiten. ");
INSERT INTO mmn_vpl VALUES ("LK9_12","072_9_12","LUK","9","12","12","Pagkadelem ka kaiza minkarini kan Hisos ya toong mga sinarigan nga napolo may dowa siran. Minlaong siran kanangiza nga papanawen mo naa ya mga tao ngaro ka mga bariyobariyo dazaw ampangita siran ka kolanganan daw makapamalit siran ka pagkaen niran kay dini kita ka kamingawan. ");
INSERT INTO mmn_vpl VALUES ("LK9_13","072_9_13","LUK","9","13","13","Minsambag si Hisos nga magpakaen hinoa kamo kaniran. Minsambag siran nga lima komang bolos ya pan kamhan dowa komang bolos ya isda. Daw paliten nami ya makaen para kaiton nga mga mataed nga tao? ");
INSERT INTO mmn_vpl VALUES ("LK9_14","072_9_14","LUK","9","14","14","Ani ini ya inlaong niran kay ya mga amaama dizan hapit maglimang ka libo siran tanan. Wara pen ya labet na mga babazi daw mga bata. Kamhan minsambag si Hisos ka toong mga sinarigan nga palo-toon di mazo sirang tanan. Kada tipon may tinagkalim-an. ");
INSERT INTO mmn_vpl VALUES ("LK9_15","072_9_15","LUK","9","15","15","Kamhan impalo-to di sirang tanan. ");
INSERT INTO mmn_vpl VALUES ("LK9_16","072_9_16","LUK","9","16","16","Paghawid ni Hisos ka mga pan nga limang bolos daw ya isda nga dowang bolos minhangad iza ka langit. Kamhan minpasalamat iza ka Diyos. Kamhan intipaktipak naiza ya mga pan anipen naiza ipanhatag ka toong mga sinarigan. Kamhan inpandohol niran ka mga tao. ");
INSERT INTO mmn_vpl VALUES ("LK9_17","072_9_17","LUK","9","17","17","Pagkakamhan niran pagkaen nangabosog sirang tanan. Pagpakahipid niran ka salin nga tinipak nangapono pen ya napolo may dowang ka alat. ");
INSERT INTO mmn_vpl VALUES ("LK9_18","072_9_18","LUK","9","18","18","Na, izang aldaw ka pagpangamozo ni Hisos nga isa ka iza minkarini ya toong mga sinarigan. Kamhan nangotana si Hisos kaniran nga daw ono ya pagngaran na mga tao kanao? ");
INSERT INTO mmn_vpl VALUES ("LK9_19","072_9_19","LUK","9","19","19","Minsambag siran nga may nagalaong nga mated sa koni niran iko koni si Howan nga Magbenzagay. May nagalaong nga iko sab koni iton si Iliyas nga karaang propita na Diyos. May iba pen nagalaong nga iko sab koni ya isa pen nga karaang propita nga nabanhaw di. ");
INSERT INTO mmn_vpl VALUES ("LK9_20","072_9_20","LUK","9","20","20","Kamhan nangotana si Hisos kaniran nga daw sin-o say pagngaran mazo kanao? Minsambag si Pidro nga iko ani matood si Kristo nga hari nga pinili na Diyos. ");
INSERT INTO mmn_vpl VALUES ("LK9_21","072_9_21","LUK","9","21","21","Kamhan minsogo si Hisos kaniran nagalaong nga dizan ka bisan sin-o nga tao diri kamo magpanan-og kon sin-o sa hao. ");
INSERT INTO mmn_vpl VALUES ("LK9_22","072_9_22","LUK","9","22","22","Kay hao nga minhon-a ka bisan sin-o nga mahon-ang tao, an-azi pen hao ka mga mataed nga kalised. Kamhan magasawazen hao na mga malaas daw ya mga oloolo na mga pari daw ya mga maistro ka tinoohan na mga Yodayo. Kamhan pamagpatazen hao doro kaniran. Pagdateng ka ikatolong aldaw magabohien hao na Diyos pagbalik garing ka lebeng. ");
INSERT INTO mmn_vpl VALUES ("LK9_23","072_9_23","LUK","9","23","23","Indogangan pen ni Hisos pagpanaba kanirang tanan nga bisan sin-o ya anpasakop kanao kinahanglan bizaan naiza ya toong kaogaringen nga naazakan aldaw-aldaw daw angeten ya pagkapatay singed kanao. Ka diri madogay dakpen hao na mga tao kamhan ipalansang ka kros keteb ka mapatay hao. ");
INSERT INTO mmn_vpl VALUES ("LK9_24","072_9_24","LUK","9","24","24","Kamhan bisan sin-o ya diri ansakop kanao kay nawied iza nga basi patazen iza mawara hinoa iza. Piro bisan sin-o ya napatay kay hao ya toong insakopan mahatagan iza ka bag-ong kinabohi nga diri mawara. ");
INSERT INTO mmn_vpl VALUES ("LK9_25","072_9_25","LUK","9","25","25","Bisan kon maangken na tao ya tanan mga betang dini ka kalibotan kamhan mawara ka ya toong kaogaringen nga kinabohi daw ono ya makawa naiza? Wara gazed. ");
INSERT INTO mmn_vpl VALUES ("LK9_26","072_9_26","LUK","9","26","26","Mindogang pen si Hisos paglaong nga hao ya minhon-a ka bisan sin-o nga mahon-ang tao. Kamhan may tirmino nao ka pagbalik ka kalibotan. Iba sab kanao ya mga sogoonon nga taga langit. Magabado sab hao ka kalatì na kanaong Ama nga Diyos. Na, koman nga panahona ka wara pen hao magbalik ka kalibotan bisan sin-o ya anlimed kanao daw ya kanaong mga panaba anlimed isab hao kanangiza kay-an ka pagdateng nao. ");
INSERT INTO mmn_vpl VALUES ("LK9_27","072_9_27","LUK","9","27","27","Timan-an mazo gazed ini nga dini kamazo may mga diri mapatay nga tao hangtod ka pagpakakita niran kanao pagbalik nao dini ka kalibotan kay hao gazed ya hari nga pinili na Diyos. Ani ini ya sindo ni Hisos ka toong mga sinarigan. ");
INSERT INTO mmn_vpl VALUES ("LK9_28","072_9_28","LUK","9","28","28","Na, minlabay di ya walong ka aldaw. Kamhan inpaiba ni Hisos si Pidro daw si Howan daw si Santiago ngandaked ka bobong kay ampangamozo iza. ");
INSERT INTO mmn_vpl VALUES ("LK9_29","072_9_29","LUK","9","29","29","Ka nagapangamozo pen iza nabag-o di ya toong lawas piro si Hisos gazed iton. Masarang kapoti ya toong bado singed ka kalatì na sega. ");
INSERT INTO mmn_vpl VALUES ("LK9_30","072_9_30","LUK","9","30","30","Kamhan waton disab ya dowang ka tao nga si Moysis daw si Iliyas nga mga karaang tao na mga Yodayo. Namaglaonglaong sirang dowa daw si Hisos. ");
INSERT INTO mmn_vpl VALUES ("LK9_31","072_9_31","LUK","9","31","31","Madazaw gazed siran selengan kay nabag-o disab ya kanirang mga lawas. Nagalaonglaong siran mahitenged ka pagkapatay ni Hisos doro ka Hirosalem ka pagtoman naiza ka kabebet-en na Diyos. ");
INSERT INTO mmn_vpl VALUES ("LK9_32","072_9_32","LUK","9","32","32","Paglaonglaong pen niran nangatorog si Pidro daw ya toong mga iba. Kamhan min-imata siran kay nakakita di siran ka kalatì dizan kan Hisos. Nakita sab niran ya dowang ka tao nga mintindeg dizan kan Hisos. ");
INSERT INTO mmn_vpl VALUES ("LK9_33","072_9_33","LUK","9","33","33","Na, pagpakabelag ka ni Moysis daw si Iliyas kan Hisos minlaong si Pidro nga Ginoo, madazaw ya kantang pagtipon dini. Kon somogot ko hinangen nami ya mga tolong bolos nga tal-ob. Kanmo ya isa. Kan Moysis ya isa. Kan Iliyas ya isa. Ani ini ya inlaong ni Pidro kay diri iza mahagdam kon ono kontana ya toong ilaong kay mahaldek gazed siran. ");
INSERT INTO mmn_vpl VALUES ("LK9_34","072_9_34","LUK","9","34","34","Ka nagapanaba pen si Pidro intamdengan siran ka inarak. Pagkatamdengi ka niran nangahaldek gazed siran. ");
INSERT INTO mmn_vpl VALUES ("LK9_35","072_9_35","LUK","9","35","35","Kamhan nabatian niran ya saba dizan ka inarak nga nagalaong nga wani ya kanaong Maanak nga kanaong impili. Magtoo gazed kamo ka toong mga panaba kamazo. ");
INSERT INTO mmn_vpl VALUES ("LK9_36","072_9_36","LUK","9","36","36","Pagkakamhan kaiza nawara dazon si Iliyas daw si Moysis. Si Hisos ka ya nakita niran dizan. Kamhan wara siran magpanaba ka nakita niran kay dakola ya pagkabereng niran. ");
INSERT INTO mmn_vpl VALUES ("LK9_37","072_9_37","LUK","9","37","37","Pagkakonsilem paglogsong niran ngambaba nanogat kan Hisos ya mga mataed nga tao. ");
INSERT INTO mmn_vpl VALUES ("LK9_38","072_9_38","LUK","9","38","38","Kamhan dizan kaniran may isang tao nga minhawag kan Hisos nga nagalaong nga Maistro, indara nao ngarini kanmo ya kanaong bogtong maanak nga amaama. Kaloy-i intawon iza ");
INSERT INTO mmn_vpl VALUES ("LK9_39","072_9_39","LUK","9","39","39","kay isahay inharian iza na maonga. Kamhan ampahisinggit iza daw magakabiribid ka toong lawas hangtod ka pagbora na toong ba-ba. Kamhan impangageman ya toong lawas ka paglompatlompat ka lopa. Kamhan madogay maolian iza ka madazaw nga beet. ");
INSERT INTO mmn_vpl VALUES ("LK9_40","072_9_40","LUK","9","40","40","Kazina inhangzo nao ya mga sakop mo dazaw papanawen niran ya maonga piro wara siran makadaeg. ");
INSERT INTO mmn_vpl VALUES ("LK9_41","072_9_41","LUK","9","41","41","Minsambag si Hisos nga waray pagtoo mazo ka Diyos. Mga salaan sab kamo. Daw dogay pen hao magaanget ka kamazong batasan nga waray pagtoo kanao? Daw dogay pen hao magahela dini kamazo anipen makasabot kamo ka gahem na Diyos? Dadha ngarini ya maanak mo! ");
INSERT INTO mmn_vpl VALUES ("LK9_42","072_9_42","LUK","9","42","42","Na, ka pagkarini na bata kan Hisos impalompatlompat iza na maonga dizan ka lopa daw nabiribid ya toong lawas. Kamhan imbaheg ni Hisos ya maonga. Kamhan naolian matood ya bata ka madazaw nga beet. Kamhan imbalik ni Hisos ya bata ka toong ama. ");
INSERT INTO mmn_vpl VALUES ("LK9_43","072_9_43","LUK","9","43","43","Kamhan nangabereng gazed sirang tanan ka gahem na Diyos. Ka nagalaonglaong pen siran mahitenged ka tanan mga inhinang ni Hisos minlaong iza ka toong mga sinarigan nga ");
INSERT INTO mmn_vpl VALUES ("LK9_44","072_9_44","LUK","9","44","44","manalinga kamo kay hao nga minhon-a ka bisan sin-o nga mahon-ang tao itogyan hao dizan ka gahem na mga tao. ");
INSERT INTO mmn_vpl VALUES ("LK9_45","072_9_45","LUK","9","45","45","Na, pagpakabati ka na toong mga sakop wara siran makasabot kay wara naiza siran pasabota. Kamhan wara siran mangotana kon ono ya kahologan naititonay nawied gazed siran. ");
INSERT INTO mmn_vpl VALUES ("LK9_46","072_9_46","LUK","9","46","46","Pagkakamhan kaiza namaglalislalis ya mga sinarigan ni Hisos daw sin-o ya labaw dini kaniran? ");
INSERT INTO mmn_vpl VALUES ("LK9_47","072_9_47","LUK","9","47","47","Kamhan mahagdam si Hisos kon ono ya kanirang hena-hena. Kamhan impakarini naiza ya isang bata ka toong sain. ");
INSERT INTO mmn_vpl VALUES ("LK9_48","072_9_48","LUK","9","48","48","Kamhan minlaong iza kaniran nga garing ka pagtoo na tao kanao kon andawat iza ka bata andawat gihapon iza kanao. Kon andawat iza kanao andawat isab iza ka Diyos nga minpakarimbaba kanao. Dini kamazong tanan ya tao nga labing obos iza gazed ya labaw. ");
INSERT INTO mmn_vpl VALUES ("LK9_49","072_9_49","LUK","9","49","49","Kamhan si Howan nangotana iza kan Hisos nga Maistro, kazina napaniidan nami ya tao nga minpadalagan ka maonga dizan ka tao. Pagsogo naiza ka maonga ka pagpanaw inpanaba naiza ya ngaran mo. Kamhan minbaheg kami kaiton nga tao kay diri kon sakop nami iza. ");
INSERT INTO mmn_vpl VALUES ("LK9_50","072_9_50","LUK","9","50","50","Minsambag si Hisos nga diri kamo magbaheg kaiton nga tao. Kay bisan sin-o ya diri an-away kamazo makaangay gazed iza kamazo. ");
INSERT INTO mmn_vpl VALUES ("LK9_51","072_9_51","LUK","9","51","51","Na, pagkaarani ka na tirmino ni Hisos ka pagkandaked ka langit in-isa disab naiza ya toong hena-hena ka pagkaro ka siyodad nga Hirosalem. Agon impahon-a naiza ya toong mga sinogo ");
INSERT INTO mmn_vpl VALUES ("LK9_52","072_9_52","LUK","9","52","52","doro ka isang bariyo doro ka lopa nga Samariya dazaw an-andam siran ka toong pagkolang dizan. ");
INSERT INTO mmn_vpl VALUES ("LK9_53","072_9_53","LUK","9","53","53","Piro diri ansogot ya mga taga Samariya kay mahagdam siran nga anlargo pen si Hisos ka Hirosalem. Kamhan ya batasan niran diri paazihan ka mga komarohay ka siyodad nga Hirosalem. ");
INSERT INTO mmn_vpl VALUES ("LK9_54","072_9_54","LUK","9","54","54","Pagkahagdam ka na mga sinarigan nga si Santiago daw si Howan minlaong siran nga Ginoo, kon somogot ko ansogo kami ka laga ka pagkarimbaba kaniran garing ka langit dazaw masonog sirang tanan. ");
INSERT INTO mmn_vpl VALUES ("LK9_55","072_9_55","LUK","9","55","55","Piro diri ansogot si Hisos. Pagliso naiza kaniran imbahegan siran naiza. ");
INSERT INTO mmn_vpl VALUES ("LK9_56","072_9_56","LUK","9","56","56","Kamhan minpadazon siran pagpanaw doro ka lain bariyo. ");
INSERT INTO mmn_vpl VALUES ("LK9_57","072_9_57","LUK","9","57","57","Pagpasinged pen niran ngaro may isang amaama nga nagasogat kan Hisos. Kamhan nagalaong iza nga bisan hain ko magpanaw an-iba gazed hao kanmo. ");
INSERT INTO mmn_vpl VALUES ("LK9_58","072_9_58","LUK","9","58","58","Minsambag si Hisos nga bisan ya mga mire may mga pogad niran ka pagpahimlay. Bisan ya mga manokmanok may mga haponanan niran. Piro wara gazed ya kanaong lagkaw nga pahimlazanan. ");
INSERT INTO mmn_vpl VALUES ("LK9_59","072_9_59","LUK","9","59","59","Kamhan dizan ka iba nga tao minlaong si Hisos nga somakop ko kanao. Minsambag ya tao nga Ginoo, tagadan mo hao naa kay ankaro pen hao ka kanaong ama nga mapatazay di iza. ");
INSERT INTO mmn_vpl VALUES ("LK9_60","072_9_60","LUK","9","60","60","Minsambag si Hisos nga ya mga lomon mo nga diri ansakop kanao ani komay magkaro ka kanmong ama kay singed siran ka mga napatay nga tao kay waray hena-hena niran mahitenged ka Diyos. Kamhan iko pomanaw ko naa. Magtoldo ko ka mga tao ka sindo mahitenged ka pagpasakop na Diyos kaniran. ");
INSERT INTO mmn_vpl VALUES ("LK9_61","072_9_61","LUK","9","61","61","May iba pen nga tao minlaong kan Hisos nga Sinyor, ansakop hao kanmo piro togotan mo hao ka pag-oli ka kanaong mga lomon kay anbaid pen hao kaniran. ");
INSERT INTO mmn_vpl VALUES ("LK9_62","072_9_62","LUK","9","62","62","Minsambag si Hisos nga ya tao nga ansakop kanao kinahanglan isahen naiza ya toong hena-hena ka pagtarabaho ka Diyos singed ka tao nga nagadaro ka oma. Kamhan diri madazaw ya toong pagdaro kon anlingi-lingi iza ka toong azi. ");
INSERT INTO mmn_vpl VALUES ("LK10_1","072_10_1","LUK","10","1","1","Pagkakamhan kaiza minpili si Hisos ka mga iba pen nga sakop nga kapitoan may dowa sirang tanan. Kamhan impahon-a naiza ya tinagdowa ngaro ka tagsatagsa nga longsod daw ya mga dapit nga datnganan naiza kay-an. ");
INSERT INTO mmn_vpl VALUES ("LK10_2","072_10_2","LUK","10","2","2","Minlaong iza kaniran nga mataed ya tao nga gosto ansakop kanao piro talagsa ka ya mga ansindo kaniran mahitenged kanao. Kamhan singed siran ka mga homay nga hinog di. Haloag gazed ya homazan piro talagsa ka ya mga magaani. Agon hangzoon mazo ya tag-iza ka anihen dazaw dogangan naiza pagpadara ka mga magaani ka pag-ani kaiton. ");
INSERT INTO mmn_vpl VALUES ("LK10_3","072_10_3","LUK","10","3","3","Pomanaw di kamo. Pakarohan nao kamo ka mga salaan nga tao. Singed siran ka mga maiseg nga ido. Kamhan dizan kaniran ya batasan mazo singed iton ka batasan na mga karniro nga waray kaiseg. ");
INSERT INTO mmn_vpl VALUES ("LK10_4","072_10_4","LUK","10","4","4","Diri kamo maghabay ka kowarta bisan singko sintabos. Pikit ka lawas ka lamang ya dara mazo, waray lain harominta. Diri kamo magheneng ka panaw mazo ka paglaonglaong ka tao kay basi malangan kamo. ");
INSERT INTO mmn_vpl VALUES ("LK10_5","072_10_5","LUK","10","5","5","Dizan ka lagkaw nga impanikan mazo maglaong kamo paghon-a nga magmalinawen kamo ka paghela dini. ");
INSERT INTO mmn_vpl VALUES ("LK10_6","072_10_6","LUK","10","6","6","Kon ampapanik siran kamazo ibilin mazo kaniran ya magazong hena-hena. Piro kon diri siran ampapanik kamazo diri kamo maghatag ka hena-hena nga magazon. ");
INSERT INTO mmn_vpl VALUES ("LK10_7","072_10_7","LUK","10","7","7","Pabilin kamo dizan ka lagkaw nga inpanikan mazo paghon-a. Diri kamo magbalhinbalhin garing ka isang lagkaw ngaro ka lain. Ya makaen nga inlamisa niran singed iton ka sohol mazo agon kanen mazo daw inmen kay ya tarabahanti kinahanglan soholan. ");
INSERT INTO mmn_vpl VALUES ("LK10_8","072_10_8","LUK","10","8","8","Kon andateng kamo ka longsod kanen mazo ya makaen nga inlamisa niran. ");
INSERT INTO mmn_vpl VALUES ("LK10_9","072_10_9","LUK","10","9","9","Panbahawen mazo ya mga masakiten dizan kaniran. Maglaong kamo kaniran nga ansindo kami kamazo mahitenged ka pagpasakop na Diyos kamazo kay domatengay di ya hari nga pinili naiza. ");
INSERT INTO mmn_vpl VALUES ("LK10_10","072_10_10","LUK","10","10","10","Kon andateng kamo ka longsod nga diri makaangay kamazo mag-azi kamo dizan ka kanirang mga dalan kamhan maglaong kamo kaniran nga ");
INSERT INTO mmn_vpl VALUES ("LK10_11","072_10_11","LUK","10","11","11","bisan ya abog dini ka kanaming paa izabzab nami dazaw mahagdam kamo nga silotan kamo na Diyos. Magtimaan kamo kaini nga domatengay di ya hari nga pinili na Diyos. ");
INSERT INTO mmn_vpl VALUES ("LK10_12","072_10_12","LUK","10","12","12","Panabaan ta kamo nga kay-an ka tirmino na Diyos ka pagbetang ka silot ka mga tao ya silot naiza kamazo labaw pen iton ka silot ka mga taga Sodoma nga maongang longsod kawandini pen. ");
INSERT INTO mmn_vpl VALUES ("LK10_13","072_10_13","LUK","10","13","13","Kamhan minbaldeng si Hisos ka mga taga longsod nga mga dapit nga inhinangan naiza ka mga madazaw kay wara siran magbiza ka maongang hinang niran. Nagalaong iza nga kamo nga taga Korazin daw taga Bitsayda, magalised gazed kamo kay-an! Kay bisan minkita kamo ka kanaong mga inhinang nga madazaw wara kamo maghinelsel ka kamazong mga sala. Kon ipakita nao ini nga mga magazon dizan ka mga taga Tiro daw taga Sidon nga mga maongang tao kawandini pen, magahinang gazed siran ka batasan niran ka paghinelsel nga ambado ka maongang bado. Kamhan anbo-bo ka alibo ka kanirang mga olo. ");
INSERT INTO mmn_vpl VALUES ("LK10_14","072_10_14","LUK","10","14","14","Agon kay-an ka paghokom na Diyos ka mga tao ya silot naiza kamazo labaw pen iton ka silot naiza ka mga taga Tiro daw Sidon. ");
INSERT INTO mmn_vpl VALUES ("LK10_15","072_10_15","LUK","10","15","15","Minbaldeng sab si Hisos ka mga taga longsod ka Kapirnaom nagalaong nga kamo nga mga taga Kapirnaom, bisan nagahela hao dizan kamazo diri gazed kamo maghena-hena nga dakola ya kamazong ngaran dizan ka Diyos. Kay ipaababa gazed ya ngaran mazo kay wara kamo magbiza ka maongang hinang mazo. Madara gazed kamo baba ka inpirno. ");
INSERT INTO mmn_vpl VALUES ("LK10_16","072_10_16","LUK","10","16","16","Kamhan minlaong iza ka toong mga sinarigan nga ya tao nga ampanalinga kamazo, hao gazed ya panalingzan naiza. Ya ansorasora kamazo hao gazed ya insorasora naiza. Ya ansorasora kanao insorasora gazed naiza ya Diyos nga minpakarimbaba kanao. ");
INSERT INTO mmn_vpl VALUES ("LK10_17","072_10_17","LUK","10","17","17","Pagkadogay kaiza minbalik kan Hisos ya toong mga sinogo nga kapitoan may dowa siran. Nagasaza gazed siran daw nagalaong nga Ginoo, bisan ya mga maonga mintoo gazed siran ka kanaming sogo ka pagpadalagan pagpanaba nami ka kanmong ngaran. ");
INSERT INTO mmn_vpl VALUES ("LK10_18","072_10_18","LUK","10","18","18","Minsambag si Hisos nga mahagdam hao daan ka pagkapildi ni Satanas kay madali gazed ya toong pagkaholog garing daked ka langit singed ka kadali na kilat. ");
INSERT INTO mmn_vpl VALUES ("LK10_19","072_10_19","LUK","10","19","19","Intagan ta kamo matood ka gahem ka pagsagitnen ka mga halas daw ya mga orang-orang. Intagan sab kamo ka gahem ka pagpakadaeg kan Satanas nga kantang kaaway. Diri di gazed makaonga kamazo ya bisan ono. ");
INSERT INTO mmn_vpl VALUES ("LK10_20","072_10_20","LUK","10","20","20","Piro diri kamo magsaza kay may gahem mazo ka pagpakadaeg ka mga maonga. Magsaza hinoa kamo kay nalista di ya kamazong ngaran daked ka libro na Diyos. ");
INSERT INTO mmn_vpl VALUES ("LK10_21","072_10_21","LUK","10","21","21","Pagkakamhan kaiza insaza ni Hisos ya Madazaw nga Ispirito nga garing ka Diyos daw nagalaong iza ka toong Ama nga Diyos nga Ama nao nga tag-iza ka kalangitan daw kalibotan, palad pen kay ya mga tao nga hopaw ya kanirang pagtoo wara mo siran pasabota ka kanaong sindo bisan kon ataas ya kanirang grado. Hinoa ya mga ansarig kanao bisan geramay ya kanirang kahagdamanan siran ya impasabot mo ka kanaong sindo. Madazaw kay iko ya minponto kaiton. Ani ini ya inlaong ni Hisos ka toong Ama. ");
INSERT INTO mmn_vpl VALUES ("LK10_22","072_10_22","LUK","10","22","22","Kamhan minpanaba iza ka mga tao nga hao ya insarigan na kanaong Ama ka tanan mga inhinang naiza. Hosto ya kasabtan naiza kanao. Hosto gihapon ya kasabtan nao kanangiza. Kamhan dizan ka bisan sin-o ya impili nao ipasabot nao ya batasan na kanaong Ama. ");
INSERT INTO mmn_vpl VALUES ("LK10_23","072_10_23","LUK","10","23","23","Kamhan dizan ka waray lain tao nga makabati minpanaba si Hisos ka toong mga sinarigan nga madazaw ya pagpanarangin na Diyos kamazo kay kamo ya minkita ka kanaong mga inhinang. ");
INSERT INTO mmn_vpl VALUES ("LK10_24","072_10_24","LUK","10","24","24","Timan-an mazo gazed ini nga mataed ya mga karaang propita na Diyos daw ya mga karaang hari nga gosto siran anseleng ka kanaong mga hinang singed ka inselengan mazo dini kanao koman piro wara itogot na Diyos kaniran. Gosto sab siran ampanalinga ka kanaong sindo singed ka nabatian mazo dini kanao koman piro wara itogot na Diyos kaniran. ");
INSERT INTO mmn_vpl VALUES ("LK10_25","072_10_25","LUK","10","25","25","Pagkakamhan kaiza may isang maistro nga minkarini nga hanas ka mga balaed na Yodayo. Kamhan minlaong iza kan Hisos ka pagporba nga Maistro, daw ono ya kinahanglan nga hinangen o dazaw tagan hao ka bag-ong kinabohi nga diri mawara? ");
INSERT INTO mmn_vpl VALUES ("LK10_26","072_10_26","LUK","10","26","26","Minsambag si Hisos nga ono say impasoyat na Diyos kan Moysis nga kamazong karaan? Ono ya imbasa mo dizan kaiton nga kasoyatan? ");
INSERT INTO mmn_vpl VALUES ("LK10_27","072_10_27","LUK","10","27","27","Minsambag iza nga impasoyat na Diyos kan Moysis nga kinahanglan nga pagaazaken mazo pagtineed ya Ginoo nga kamazong Diyos. Kamhan isahen mazo ya kamazong hena-hena ka pagtaremdem kanangiza. Kamhan mag-azak kamo ka mga tao singed ka pag-azak mazo ka kamazong kaogaringen. ");
INSERT INTO mmn_vpl VALUES ("LK10_28","072_10_28","LUK","10","28","28","Minsambag si Hisos nga hosto ya kanmong sambag. Magtoman ko dazaw mahatagan ko ka bag-ong kinabohi nga diri mawara. ");
INSERT INTO mmn_vpl VALUES ("LK10_29","072_10_29","LUK","10","29","29","Kamhan amporba pen ya maistro kan Hisos nga nagalaong nga daw sin-o gazed ya tao nga angazen o kontana? ");
INSERT INTO mmn_vpl VALUES ("LK10_30","072_10_30","LUK","10","30","30","Minsambag si Hisos nga pamolinged ini nga may isang ka tao nga angay ta nga Yodayo. Kamhan nagalogsong iza garing ka Hirosalem pasinged ngaro ka longsod nga Hiriko. Kamhan inbanganan iza na mga tolisan. Inhoboan niran iza daw impamagbonalan. Kamhan inbizaan iza nga mapatazay. ");
INSERT INTO mmn_vpl VALUES ("LK10_31","072_10_31","LUK","10","31","31","Ka wara pen madogay may isang Yodayo nga pari nga nagalogsong dizan ka dalan. Pagpakakita ka naiza ka tao nga nagalised minlabay lamang iza dizan ka kilid na dalan. ");
INSERT INTO mmn_vpl VALUES ("LK10_32","072_10_32","LUK","10","32","32","Kamhan may nakasonod nga Yodayo gihapon. Kaliwat iza ni Libita nga karaang pari. Pagpakakita ka naiza ka tao nga mapatazay minlabay iza dizan ka kilid na dalan. ");
INSERT INTO mmn_vpl VALUES ("LK10_33","072_10_33","LUK","10","33","33","Kamhan may nakasonod pen isab nga taga Samariya. Na, ya mga taga Samariya daw ya mga Yodayo diri siran magkaangay kamhan intamay na mga Yodayo na mga taga Samariya kay diri kon mga kaliwatan ni Abraham siran. Na, pagdateng na taga Samariya ka tao nga nagalised inkaloy-an naiza bisan Yodayo ya tao. ");
INSERT INTO mmn_vpl VALUES ("LK10_34","072_10_34","LUK","10","34","34","Kamhan imbo-boan naiza ya toong mga samad ka lana insaketan sab ka tambal nga mahapdes gazed pagdazaw. Kamhan impandapihan naiza ya Yodayo daw impasakay ka toong kabayo dazaw iated ngaro ka kolanganan. Kamhan magatabangan iza dizan. ");
INSERT INTO mmn_vpl VALUES ("LK10_35","072_10_35","LUK","10","35","35","Pagkakonsilem inhatagan naiza ya tag-iza ka kolanganan ka kowarta daw nagalaong nga pag-aligarahen mo naa ini nga nabedlay. Kamhan pagbalik nao dini bayran ta ko ka kanmong magasto kon kolang pen ya kowarta. Ani ini ya pamolinged ni Hisos ka maistro nga Yodayo. ");
INSERT INTO mmn_vpl VALUES ("LK10_36","072_10_36","LUK","10","36","36","Kamhan nangotana iza nga dizan ka tolong ka tao daw sin-o say nakaangay pagtineed ka tao nga intolis? ");
INSERT INTO mmn_vpl VALUES ("LK10_37","072_10_37","LUK","10","37","37","Minsambag ya maistro nga ya tao nga nalooy kanangiza. Minsambag si Hisos nga pomanaw di ko. Kinahanglan maghaod ko ka toong batasan. ");
INSERT INTO mmn_vpl VALUES ("LK10_38","072_10_38","LUK","10","38","38","Pagkakamhan kaiza nagapadazon si Hisos ka kanirang pagpanaw. Mindateng siran ka isang bariyo nga hel-anan na isang babazi si Marta ya ngaran. Kamhan minpapanik iza kan Hisos kay ampakaen. ");
INSERT INTO mmn_vpl VALUES ("LK10_39","072_10_39","LUK","10","39","39","May lomon ni Marta si Mariya ya ngaran. Nagalo-to iza dini ka paahan ni Hisos kay naazak iza pagpanalinga ka toong sindo. ");
INSERT INTO mmn_vpl VALUES ("LK10_40","072_10_40","LUK","10","40","40","Kamhan nawied si Marta ka pagkaen. Agon minkarini iza kan Hisos ka pagbaid nga nagalaong nga Ginoo, daw waray pagkawied mo nga impasagdan hao na kanaong lomon ka pagsen-ad? Long-on mo iza nga tabangan mo ya kanmong lomon. ");
INSERT INTO mmn_vpl VALUES ("LK10_41","072_10_41","LUK","10","41","41","Minsambag ya Ginoo nga Marta, Marta, mataed gazed ya mga kawied mo. ");
INSERT INTO mmn_vpl VALUES ("LK10_42","072_10_42","LUK","10","42","42","Kamhan madazaw gazed ya impili ni Mariya kay minpanalinga iza ka kanaong mga panaba. Kamhan diri makawa ya toong intoon dini kanao. Kay anikay inkinahanglan na tao ya pagpanalinga ka kanaong sindo. ");
INSERT INTO mmn_vpl VALUES ("LK11_1","072_11_1","LUK","11","1","1","May isang aldaw nagapangamozo si Hisos ka Diyos. Pagkakamhan naiza pagpangamozo minlaong ya isang sakop nga Ginoo, toldoan mo kami ka pagpangamozo ka Diyos singed ka pagtoldo ni Howan ka toong mga sakop. ");
INSERT INTO mmn_vpl VALUES ("LK11_2","072_11_2","LUK","11","2","2","Minsambag si Hisos nga kon ampangamozo kamo ka Diyos maglaong kamo nga Ama nami nga Diyos, labaw gazed ya kanmong ngaran. Harian mo kami dini ka kalibotan. ");
INSERT INTO mmn_vpl VALUES ("LK11_3","072_11_3","LUK","11","3","3","Tagan mo kami kada aldaw ka kinahanglan nami nga pagkaen. ");
INSERT INTO mmn_vpl VALUES ("LK11_4","072_11_4","LUK","11","4","4","Pasaylohon mo ya kanaming mga sala singed ka pagpasaylo nami ka mga nakasala kanami. Ipaaro mo kanami ya magtintalay. ");
INSERT INTO mmn_vpl VALUES ("LK11_5","072_11_5","LUK","11","5","5","Pagkakamhan ni Hisos pagtoldo kaniran minpamolinged pen iza kaniran dazaw diri siran kapozan ka pagpangamozo ka Diyos. Kamhan nagalaong iza nga simpan may isang higara mo. Ka pagkatenga na kahabzen iko ya minkaro ka toong lagkaw dazaw hangzoon nga pari, kon mahimo pabayloan nao ya makaen ");
INSERT INTO mmn_vpl VALUES ("LK11_6","072_11_6","LUK","11","6","6","kay nadatngan hao na kanaong higara garing pen ka aro. Nahodtan di gazed hao ka makaen nao. ");
INSERT INTO mmn_vpl VALUES ("LK11_7","072_11_7","LUK","11","7","7","Kamhan minsambag iza garing dalem ka lagkaw nga diri di ko magsamok kanao kay nasirahan di ya kanaong lagkaw. Namentag di kami daw ya kanaming mga maimpis. Agon diri di hao ambangon ka gosto mong pangazoon kanao. ");
INSERT INTO mmn_vpl VALUES ("LK11_8","072_11_8","LUK","11","8","8","Kamhan mintoda ko hinoa pagpangazo kanangiza dazaw ihatag. Kamhan anbangon lamang iza daw anhatag kanmo ka tanan inkinahanglan mo. Na, ya paghatag naiza kanmo diri kon garing iton ka pagkaamigo mazo basta kay garing ka pagtoda mo ka pagpangazo. ");
INSERT INTO mmn_vpl VALUES ("LK11_9","072_11_9","LUK","11","9","9","Sabten mazo ini nga mangazo kamo ka Diyos ka kinahanglanen mazo. Kamhan tagan kamo naiza. Magpangita kamo. Kamhan ipakita naiza kamazo ya kamazong inkinahanglan. Maghawag kamo dazaw sambagen kamo na Diyos. Kamhan mabatian kamo naiza ka paghangzo mazo. ");
INSERT INTO mmn_vpl VALUES ("LK11_10","072_11_10","LUK","11","10","10","Kay bisan sin-o ya nagaazo ani tagan na Diyos ka toong kinahanglan. Ya tao nga nagapangita ani tabangan na Diyos. Ya tao nga nagahawag mabatian na Diyos ya toong paghangzo. ");
INSERT INTO mmn_vpl VALUES ("LK11_11","072_11_11","LUK","11","11","11","Kamo nga may maanak, kon an-azo ya maanak ka isda, daw ihatag ya halas? Diri. ");
INSERT INTO mmn_vpl VALUES ("LK11_12","072_11_12","LUK","11","12","12","Kon an-azo iza ka anak na manok daw ihatag ya orang-orang? Diri kay ihatag mazo hinoa ya madazaw. ");
INSERT INTO mmn_vpl VALUES ("LK11_13","072_11_13","LUK","11","13","13","Na, kamo nga mga salaan nga tao, mahagdam kamo ka paghatag ka madazaw ka kamazong mga maanak piro labaw pen gazed ya hatag na Ama mazo nga Diyos nga nagahela daked ka langit kay ihatag naiza ya toong Ispirito nga Madazaw dizan ka mga nangazo kanangiza. ");
INSERT INTO mmn_vpl VALUES ("LK11_14","072_11_14","LUK","11","14","14","Pagkakay-an kaiza minbogaw si Hisos ka maonga nga nakapeha ka isang tao. Kamhan nakalitok dazon ya tao agon nangabereng gazed ya mga tao. ");
INSERT INTO mmn_vpl VALUES ("LK11_15","072_11_15","LUK","11","15","15","Dizan disab ya mga minsora nga nagalaong nga si Hisos may gahem naiza ka pagbogaw ka mga maonga kay inharian iza ni Satanas inngaranan sab kan Bilsibol nga tag-iza ka mga maonga. ");
INSERT INTO mmn_vpl VALUES ("LK11_16","072_11_16","LUK","11","16","16","Kamhan nangazo ya mga iba peng tao ka timaan nga garing ka langit kay amporba siran kon garing si Hisos ka Diyos kon diri. ");
INSERT INTO mmn_vpl VALUES ("LK11_17","072_11_17","LUK","11","17","17","Mahagdam si Hisos ka kanirang hena-hena agon minsambag iza nga pamolinged ini nga kon awazen na hari ya toong mga sinogo mapildi gazed ya hari. Kon ampakig-away ya isa daw isa nga lomon dizan ka isang pamiliya mapildi isab ya pamiliya. ");
INSERT INTO mmn_vpl VALUES ("LK11_18","072_11_18","LUK","11","18","18","Agon kon anbogaw si Satanas ka toong kaogaringen nga ispirito dizan ka tao mapildi si Satanas. Minlaong kamo nga garing kan Bilsibol ya kanaong gahem ka pagbogaw ka mga maonga. ");
INSERT INTO mmn_vpl VALUES ("LK11_19","072_11_19","LUK","11","19","19","Sazep mazo iton kay bisan ya mga sakop mazo pagbogaw niran ka mga maonga mahagdam siran nga garing ka Diyos ya kanirang gahem, diri kon garing kan Bilsibol. Agon ansombong siran kamazo ka bakak. ");
INSERT INTO mmn_vpl VALUES ("LK11_20","072_11_20","LUK","11","20","20","Minsazep gazed kamo kay ya Diyos ani ya mintabang kanao ka pagbogaw ka mga maonga. Kamhan ipasabot di na Diyos kamazo nga dini kamazo mindateng di gazed ya Maanak na Diyos nga hari nga pinili na Diyos. ");
INSERT INTO mmn_vpl VALUES ("LK11_21","072_11_21","LUK","11","21","21","Pamolinged ini nga singed si Satanas ka kesgan nga tao nga nagadara ka bangkaw daw lodzo kay bantazan naiza ya toong lagkaw dazaw diri paghilabtan ya toong mga betang. ");
INSERT INTO mmn_vpl VALUES ("LK11_22","072_11_22","LUK","11","22","22","Kamhan hao kay nakadaeg kan Satanas pagdali kay intagenan nao ya toong bangkaw daw lodzo. Kamhan imbahinbahin nao ya toong mga betang dizan ka kanaong kaibahan. ");
INSERT INTO mmn_vpl VALUES ("LK11_23","072_11_23","LUK","11","23","23","Indogangan pen ni Hisos paglaong nga ya mga diri ansakop kanao ani ya ansopak kanao. Ya mga diri antabang ka mga tao ka pagsakop kanao singed ka nakalaag siran ka mga tao. ");
INSERT INTO mmn_vpl VALUES ("LK11_24","072_11_24","LUK","11","24","24","Ya tao nga diri magapadazon pagsakop kanao singed iza ka tao nga inharian na maonga. Kamhan minpanaw ya maonga kay ankaro ka banwa. Kamhan magapanawpanaw iza kay ampangita ka hel-anan. Kamhan waray datnganan naiza agon nagahena-hena iza nga an-oli di hao ka tao. ");
INSERT INTO mmn_vpl VALUES ("LK11_25","072_11_25","LUK","11","25","25","Pagdateng naiza ka tao ya beet na tao singed iton ka lagkaw nga inhingloan di daw inhipid ya tanan piro wara dizan ya magahari ka tao. ");
INSERT INTO mmn_vpl VALUES ("LK11_26","072_11_26","LUK","11","26","26","Kamhan minpanaw ya maonga kay ankawa iza ka toong mga iba nga pito siran daw maonga gazed. Kamhan sirang tanan ya magahari ka tao. Agon nagadogang gazed ya tao ka pagpakasala. Ani ini ya kahimtang na tao nga nagapanalinga ka kanaong sindo. Kamhan diri iza ampahari ka Ginoo dalem ka toong beet. ");
INSERT INTO mmn_vpl VALUES ("LK11_27","072_11_27","LUK","11","27","27","Pagkakamhan ni Hisos pagpanaba dizan ka kataohan may isang babazi nga minbaskeg ka toong paghawag nga nagalaong nga masazaen gazed ya babazi nga min-anak kanmo daw minpasoso. ");
INSERT INTO mmn_vpl VALUES ("LK11_28","072_11_28","LUK","11","28","28","Minsambag si Hisos nga masazaen hinoa ya mga nanalinga ka mga panaba na Diyos daw ya nagatoman kaiton. ");
INSERT INTO mmn_vpl VALUES ("LK11_29","072_11_29","LUK","11","29","29","Pagheetheet ka na mga mataed nga tao libot kan Hisos minpadazon iza paglaong kaniran nga koman nga panahona mga salaan gazed ya mga tao. Kamhan ampangazo siran kanao ka timaan piro anikay timaan nao kaniran ya singed kan Zona nga karaang propita na Diyos. ");
INSERT INTO mmn_vpl VALUES ("LK11_30","072_11_30","LUK","11","30","30","Kay kawandini pen pagdateng ni Zona ka longsod nga Ninibi mahagdam gazed ya mga taga Ninibi nga garing iza ka Diyos. Koman nga panahona mindateng disab hao nga garing ka Diyos. Makasabot ya mga tao kaini kay-an kay mabohi hao pagbalik garing ka lebeng singed ka pagkabohi ni Zona. Kay kawandini pen tolong ka aldaw ya paghela ni Zona dalem ka tinai na dakolang isda. ");
INSERT INTO mmn_vpl VALUES ("LK11_31","072_11_31","LUK","11","31","31","Na, may karaang rayna isab. Taga timogan iza kamhan aro ya toong pagpanaw ka pagpanalinga ka sindo na karaang hari nga si Salomon. Agon ansombong iza kamazo kay-an ka paghokom na Diyos ka mga tao kay bisan labaw ya kanaong pagsindo ka pagkalabaw na pagsindo ni Salomon wara kamo magpanalinga kanao. ");
INSERT INTO mmn_vpl VALUES ("LK11_32","072_11_32","LUK","11","32","32","Kay-an ka paghokom na Diyos ka mga tao ansombong kamazo isab ya mga taga Ninibi kay bisan labaw ya kanaong pagwali ka pagwali ni Zona wara kamo magbiza ka kamazong mga sala singed ka mga taga Ninibi kaiza nga mahon-a pen pagpakabati niran ka pagwali ni Zona. ");
INSERT INTO mmn_vpl VALUES ("LK11_33","072_11_33","LUK","11","33","33","Na, kon seg-an na tao ya moron diri pag-ileen ka parador, diri isab pagtakloban. Kamhan ibetang daked ka artal kay dazaw pawaan ya mga minseled ka lagkaw. ");
INSERT INTO mmn_vpl VALUES ("LK11_34","072_11_34","LUK","11","34","34","Dini ka kantang lawas minpasingedsinged ya kantang mata ka segà kay kon mapawa ya kantang pagkita singed ka kapawa gihapon ya tibolos lawas. Piro kon nabota kita singed ka nagahela kita ka kadeglem. ");
INSERT INTO mmn_vpl VALUES ("LK11_35","072_11_35","LUK","11","35","35","Singed iton ka hena-hena na tao. Kay kon madazaw ya toong hena-hena madazaw gihapon ya toong batasan. Kamhan kon maonga ya toong hena-hena maonga isab ya toong batasan. Magbantay kamo kay basi madag-en ya madazaw nga hena-hena ka mga maongang hena-hena. ");
INSERT INTO mmn_vpl VALUES ("LK11_36","072_11_36","LUK","11","36","36","Kon polos madazaw ya hena-hena na tao, polos madazaw ya toong batasan. Kamhan singed iza ka lagkaw nga mapawa gazed kay inseg-an naiza ya moron kamhan inbetang dizan ka artal. ");
INSERT INTO mmn_vpl VALUES ("LK11_37","072_11_37","LUK","11","37","37","Pagkakamhan ni Hisos pagpanaba kaniran dinapit iza na isang Parasiyo kay anpakaen. Kamhan minpanik si Hisos dizan ka lagkaw kay inlamisa di sa ya makaen. ");
INSERT INTO mmn_vpl VALUES ("LK11_38","072_11_38","LUK","11","38","38","Kamhan nabereng gazed ya Parasiyo ka batasan ni Hisos kay wara iza magtoman ka balaed nga garing ka mga karaan nga Yodayo nga nagalaong nga ka wara pen magkaen ya tao kinahanglan hogasan ya alima. ");
INSERT INTO mmn_vpl VALUES ("LK11_39","072_11_39","LUK","11","39","39","Minsambag ya Ginoo nga kamo nga mga Parasiyo, singed kamo ka tao nga inhogasan gazed ya gawas na mga baso daw palato piro ya seled napono gazed ka mga maripa kay naanad kamo paglimbong ka mga tao dazaw makakowarta. ");
INSERT INTO mmn_vpl VALUES ("LK11_40","072_11_40","LUK","11","40","40","Mga boang! Daw wara mahagdam ya Diyos ka kamazong hena-hena singed ka pagkita naiza ka kamazong lawas? ");
INSERT INTO mmn_vpl VALUES ("LK11_41","072_11_41","LUK","11","41","41","Magkalooy kamo hinoa ka mga tao. Ipanhatag mazo ka mga pobri ya makaen dizan ka mga palato mazo. Kamhan tigbeet ya pagkahinglo na kamazong lawas daw mga betang. ");
INSERT INTO mmn_vpl VALUES ("LK11_42","072_11_42","LUK","11","42","42","Kamo nga mga Parasiyo, magalised gazed kamo kay-an kay diri kon matood ya pagkaazak mazo ka Diyos. Kay bisan nagahatag kamo ka Diyos ka ikanapolo nga ka bahin na bisan ya mga klasi na zaman wara kamo magtoman ka mga labaw nga sogo na Diyos nga nagalaong nga tadengen mazo ya pagdomara mazo ka mga iba. Azaken mazo ya mga tao singed ka pag-azak na Diyos kaniran. Kinahanglan tomanen isab mazo ini singed ka paghatag mazo ka mga ikanapolo nga ka bahin dizan ka Diyos. ");
INSERT INTO mmn_vpl VALUES ("LK11_43","072_11_43","LUK","11","43","43","Kamo nga mga Parasiyo, magalised gazed kamo kay-an kay kada pagsingba mazo naazak kamo kon palo-toon kamo ka magazong dapit. Pag-azi sab mazo dizan ka mirkado naazak gazed kamo nga madazaw ya pag-abiabi na mga tao kamazo. ");
INSERT INTO mmn_vpl VALUES ("LK11_44","072_11_44","LUK","11","44","44","Kamo nga mga Parasiyo, magalised gazed kamo kay-an kay pagtoldo mazo ka mga tao indap-an siran ka kamazong mga sala. Singed gazed kamo ka mga lebeng nga waray timaan nga bato agon insagitnan na tao. ");
INSERT INTO mmn_vpl VALUES ("LK11_45","072_11_45","LUK","11","45","45","Kamhan minlaong ya isang maistro ka tinoohan na mga Yodayo nga Maistro, ya pagbaheg mo ka mga Parasiyo singed ka magatodaytodazen mo kami isab. ");
INSERT INTO mmn_vpl VALUES ("LK11_46","072_11_46","LUK","11","46","46","Minsambag si Hisos nga kamo nga mga maistro, magalised isab kamo kay-an kay impalisdan mazo ya mga tao ka sogo nga mabeg-at piro impalabzan lamang mazo itong mga sogo. ");
INSERT INTO mmn_vpl VALUES ("LK11_47","072_11_47","LUK","11","47","47","Magalised gazed kamo kay-an kay minhinang kamo ka mga madazaw nga pantiyon para ka mga karaang propita nga inpatay na kamazong mga karaan. ");
INSERT INTO mmn_vpl VALUES ("LK11_48","072_11_48","LUK","11","48","48","Agon minpakita kamo nga naazak kamo ka maongang hinang na kamazong kaapoan. Siran ya minbono ka mga karaang propita na Diyos. Kamhan kamo ya minhinang ka mga madazaw nga pantiyon. ");
INSERT INTO mmn_vpl VALUES ("LK11_49","072_11_49","LUK","11","49","49","Ani ini ya pagtoman ka mga panaba na Diyos nga nagalaong daan nga ipadara nao kamazo ya kanaong mga propita daw mga sinarigan. Kamhan pamagpatazen pen mazo ya mga pirang ka tao kaniran. Daegdaegen sab mazo ya mga iba pen nga sakop nao. ");
INSERT INTO mmn_vpl VALUES ("LK11_50","072_11_50","LUK","11","50","50","Agon koman madateng kamo ka silot ka pagpatay ka tanan mga matadeng nga tao sokad kawandini pen ka sinogdan pen na kalibotan. ");
INSERT INTO mmn_vpl VALUES ("LK11_51","072_11_51","LUK","11","51","51","Madateng kamo ka silot ka pagpatay kan Abil nga waray sala hangtod ka pagpatay kan Zakariyas nga inpatay dizan ka tenga-tenga na haladanan daw ya dakolang lagkaw na Diyos. Matood ya mga panaba nao kamazo nga ya mga tao nga bohi koman siran ya masilotan ka pagpatay kanirang tanan! ");
INSERT INTO mmn_vpl VALUES ("LK11_52","072_11_52","LUK","11","52","52","Kamo nga mga maistro ka tinoohan na mga Yodayo, magalised gazed kamo kay-an kay singed ka intagoan gazed mazo ya sindo na Diyos dalem ka kaban. Kamhan inkawa mazo ya liyabi. Ani ini ya kamazong hinang kay diri kamo ansogot ka sindo na Diyos. Kamhan nagabalabag isab kamo ka mga tao nga gosto makasabot ka sindo nga garing ka Diyos. ");
INSERT INTO mmn_vpl VALUES ("LK11_53","072_11_53","LUK","11","53","53","Pagkakamhan ni Hisos pagpanaba kaniran mintena iza ka lagkaw na Parasiyo. Kamhan malain ya kanirang hena-hena kan Hisos. Nagapakiglaonglaong isab siran kanangiza pagpangotana dazaw ");
INSERT INTO mmn_vpl VALUES ("LK11_54","072_11_54","LUK","11","54","54","masazep iza pagsambag kaniran. ");
INSERT INTO mmn_vpl VALUES ("LK12_1","072_12_1","LUK","12","1","1","Na, paglalis pen na mga Parasiyo kan Hisos mintipon di ya mga tao dizan kaniran. Masara gazed nga kataed ya mga tao. Kamhan magakasagitnan di ya kanirang mga paa ka kasiet. Kamhan dizan ka nabatian na mga tao minpanaba si Hisos ka toong mga sakop nagalaong nga maghamarag kamo kay basi limbongan kamo na mga Parasiyo. ");
INSERT INTO mmn_vpl VALUES ("LK12_2","072_12_2","LUK","12","2","2","Silaong niran nga natago ya kanirang mga sala ambaza kay bisan ono ya kanirang mga tinago mahagdaman gazed kay-an. ");
INSERT INTO mmn_vpl VALUES ("LK12_3","072_12_3","LUK","12","3","3","Kay may tirmino ka pagpakita ka bisan ono ya inpanaba na isa daw isa dizan ka dapit nga waray lain makabati. Bisan ono ya panaba nga hilemen lamang dalem ka lagkaw nga nasirahan mapanaba gihapon iton pagdakola dizan ka mga mataed nga tao kay-an. ");
INSERT INTO mmn_vpl VALUES ("LK12_4","072_12_4","LUK","12","4","4","Mga higara nao, sabten mazo ini nga ya mga an-away kanta ya kantang lawas anikay daeten niran. Agon diri kamo magkahaldek kaniran. ");
INSERT INTO mmn_vpl VALUES ("LK12_5","072_12_5","LUK","12","5","5","Magkahaldek kamo hinoa ka Diyos kay may gahem naiza ka pagpatay ka tao. May gahem sab naiza ka pagpadara ka ispirito na tao ngaro ka impirno. Agon iza gazed ya kahaldekan mazo. ");
INSERT INTO mmn_vpl VALUES ("LK12_6","072_12_6","LUK","12","6","6","Kamhan dakola isab ya kalooy na Diyos ka mga tao. Diri iza malipat ka bisan ono nga inhinang naiza. Bisan ya mga maza, ya pagpalit ka limang bolos bayinti sintabos ka lamang. Kamhan bisan barato ka lamang siran diri malipat ya Diyos ka bisan isang bolos nga maza. ");
INSERT INTO mmn_vpl VALUES ("LK12_7","072_12_7","LUK","12","7","7","Mahal kamo ka pagkamahal na mga maza. Agon diri kamo magkahaldek ka hinang na mga tao kamazo kay aligarahen gazed kamo na Diyos. Bisan ya bohok dizan ka olo mazo, imbilang na Diyos daan kon pirang ka legas ya bohok mazo. ");
INSERT INTO mmn_vpl VALUES ("LK12_8","072_12_8","LUK","12","8","8","Sabten mazo ini nga dizan ka mga tao bisan sin-o ya ankilala kanao siran gihapon ya makilalhan nao dizan ka mga taga langit nga sogoonon na Diyos. ");
INSERT INTO mmn_vpl VALUES ("LK12_9","072_12_9","LUK","12","9","9","Piro bisan sin-o ya anlimed kanao dizan ka mga tao iza gihapon ya inlimed nao dizan ka mga taga langit nga sogoonon na Diyos. ");
INSERT INTO mmn_vpl VALUES ("LK12_10","072_12_10","LUK","12","10","10","Bisan sin-o ya ampanaba ka maonga mahitenged kanao, kon anhinelsel iza pasaylohon iza na Diyos. Piro bisan sin-o ya ampanaba ka maonga mahitenged ka Madazaw nga Ispirito nga garing ka Diyos, diri gazed iza pasaylohon na Diyos. ");
INSERT INTO mmn_vpl VALUES ("LK12_11","072_12_11","LUK","12","11","11","Dadhen kamo kay-an na mga tao doro ka hokmanan ka oloolo na mga Yodayo kay hao ya insakopan mazo. Kamhan pag-atobang mazo kaniran daw ya mga lain tao nga magahari ka lopa na mga Yodayo diri kamo magkawied kon ono ya isambag mazo kaniran ");
INSERT INTO mmn_vpl VALUES ("LK12_12","072_12_12","LUK","12","12","12","kay antandeg ka kamazong hena-hena ya Madazaw nga Ispirito nga garing ka Diyos. Kamhan may isambag mazo kaniran. ");
INSERT INTO mmn_vpl VALUES ("LK12_13","072_12_13","LUK","12","13","13","Na, dizan ka kataohan libot kan Hisos may isang tao nagalaong nga Maistro, magpanaba ko ka kanaong lomon dazaw bahinan hao naiza ka irinsiya nga imbilin kanami na kanaming ama. ");
INSERT INTO mmn_vpl VALUES ("LK12_14","072_12_14","LUK","12","14","14","Minsambag si Hisos nga daw sin-oy minpili kanao ka pagpabahin kamazong dowa? ");
INSERT INTO mmn_vpl VALUES ("LK12_15","072_12_15","LUK","12","15","15","Kamhan minlaong si Hisos ka mga tao dizan nga bantazan mazo ya kamazong hena-hena dazaw diri kamo mag-arig ka bisan ono ya betang na kamazong mga iba. Kay bisan manobra gazed ya mga betang na tao, diri iton makahatag kanangiza ka bag-ong kinabohi nga diri mawara. ");
INSERT INTO mmn_vpl VALUES ("LK12_16","072_12_16","LUK","12","16","16","Kamhan minpamolinged pen si Hisos kaniran nga may isang tao nga kowartahan. Kamhan min-abet pagdakola ya toong intanem. ");
INSERT INTO mmn_vpl VALUES ("LK12_17","072_12_17","LUK","12","17","17","Kamhan nagalaong iza ka toong hena-hena nga pag-ani nao ka kanaong mga mais daw hain ibetang iton kay min-abet gazed. ");
INSERT INTO mmn_vpl VALUES ("LK12_18","072_12_18","LUK","12","18","18","Kamhan minlaong iza nga gebaen pen nao ya kanaong lagkaw. Kamhan anpahinang disab hao ka lagkaw nga haloag dazaw hipiden nao ya tanan mga mais hasta ya kanaong mga betang. ");
INSERT INTO mmn_vpl VALUES ("LK12_19","072_12_19","LUK","12","19","19","Pagkakamhan pagpahinang kaiton anlaong gazed hao ka kanaong kaogaringen nga dogay mahorot ya kanaong makaen daw mga betang agon anpahayahay pen hao. Anpahikaen hao. An-inem sab hao daw magapahisaza. ");
INSERT INTO mmn_vpl VALUES ("LK12_20","072_12_20","LUK","12","20","20","Kamhan anlaong ya Diyos kaiton nga tao nga nasazep gazed iko kay koman nga kahabzen mapatay di ko. Kamhan diri di ko makatag-iza ka kanmong mga in-andam kay ihatag lamang ka lain tao. ");
INSERT INTO mmn_vpl VALUES ("LK12_21","072_12_21","LUK","12","21","21","Pagkakamhan ni Hisos pagpamolinged minlaong iza nga singed kaiton ya kahimtang na tao nga wili ya toong hena-hena ka toong mga betang. Kamhan waray hena-hena naiza mahitenged ka Diyos agon singed ka napobri gazed iza. ");
INSERT INTO mmn_vpl VALUES ("LK12_22","072_12_22","LUK","12","22","22","Kamo nga kanaong kasakopan, diri kamo magkawied ka pagpangita ka panginabohi mazo kon ono ya pagkaen mazo daw ya pagabadoon mazo. ");
INSERT INTO mmn_vpl VALUES ("LK12_23","072_12_23","LUK","12","23","23","Ya kinabohi na tao mahal iton ka pagkamahal na makaen. Ya lawas na tao mahal iton ka pagkamahal na mga bado. ");
INSERT INTO mmn_vpl VALUES ("LK12_24","072_12_24","LUK","12","24","24","Paniidan mazo ya mga manokmanok. Waray mahimo niran pagtanem daw pag-ani. Kamhan waray lagkaw niran ka paghipid ka kanirang mga makaen. Hinoa ya Diyos nagapakaen kaniran. Na, mahal ya tao ka pagkamahal na mga manokmanok agon antabang gazed ya Ama kamazo ka pagpangita ka kamazong panginabohi. ");
INSERT INTO mmn_vpl VALUES ("LK12_25","072_12_25","LUK","12","25","25","Bisan ya kaataas na kamazong panoigen diri kamo magkawied kay garing ka pagkawied mazo diri kamo makaataas. ");
INSERT INTO mmn_vpl VALUES ("LK12_26","072_12_26","LUK","12","26","26","Agon diri isab kamo magkawied ka makaen daw pagabadoon mazo. ");
INSERT INTO mmn_vpl VALUES ("LK12_27","072_12_27","LUK","12","27","27","Paniidan mazo ya mga boyak nga tobo ka lamang. Kay waray mahimo niran pagtarabaho daw pagtahi ka kanirang bado. Kamhan bisan si Salomon nga karaang hari nga nagabado ka mga mahalen nga bado lopig gazed ka kagazen ya toong bado ka kagazen na mga boyak nga tobo ka lamang. ");
INSERT INTO mmn_vpl VALUES ("LK12_28","072_12_28","LUK","12","28","28","Na, mahal ya tao ka pagkamahal na mga boyak agon antabang gazed ya Diyos kamazo. Geramay gazed ya pagtoo mazo ka Diyos kay bisan ababa ya tirmino na mga boyak anhatag iza kaniran ka kagazon. Agon antabang isab iza kamazo. ");
INSERT INTO mmn_vpl VALUES ("LK12_29","072_12_29","LUK","12","29","29","Kamhan diri kamo magkawied maglaong nga waray makaen nami, waray mainem nami. ");
INSERT INTO mmn_vpl VALUES ("LK12_30","072_12_30","LUK","12","30","30","Kay ani kontana ya kawiedan na mga tao nga wara pen magsakop kanao. Piro bisan ono ya kinahanglan mazo mahagdam daan ya kamazong Ama. ");
INSERT INTO mmn_vpl VALUES ("LK12_31","072_12_31","LUK","12","31","31","Kamo nga kanaong kasakopan, wani ya kinahanglanen mazo paharien mazo ya Diyos ka kamazong beet dazaw antabang iza kamazo ka pagbineetan. Kamhan antabang iza kamazo ka mga kinahanglanen mazo. ");
INSERT INTO mmn_vpl VALUES ("LK12_32","072_12_32","LUK","12","32","32","Kamo nga kanaong mga sakop nga inbantazan nao, diri kamo magkahaldek kay bisan diri kon mataed kamo impili kamo na Diyos ka paghari ka bag-ong kalibotan iba kanangiza. ");
INSERT INTO mmn_vpl VALUES ("LK12_33","072_12_33","LUK","12","33","33","Agon ipamaligza mazo ya kamazong mga betang. Kamhan ya bazad ipanhatag ka mga pobri. Kon tomanen mazo ini nga sogo nao singed ka hinangen mazo ya pitaka nga diri madonot nga betanganan mazo ka mga mahalen daked ka hel-anan na Diyos. Kamhan diri madonot iton mga mahalen, diri maketket na mga ipos, diri paniken na tolisan ka pagkawat. ");
INSERT INTO mmn_vpl VALUES ("LK12_34","072_12_34","LUK","12","34","34","Kay kon hain ya kamazong mga mahalen waro disab ya hena-hena mazo ka pagtaremdem. ");
INSERT INTO mmn_vpl VALUES ("LK12_35","072_12_35","LUK","12","35","36","Mag-andam gazed kamo ka kanaong pagbalik singed ka pag-andam na mga sogoonon ka pagtagad niran ka kanirang amo nga om-oliay garing ka kombiti. Pagtagad pen niran imbadoan niran, inseg-an sab niran daan ya kanirang mga moron kay kon makabati siran ka paghawag na kanirang amo an-abri dazon siran. ");
INSERT INTO mmn_vpl VALUES ("LK12_37","072_12_37","LUK","12","37","38","Bisan kon tenga na kahabzen, bisan kamaaldawen ya pag-oli naiza, kon min-imata pen siran ka pag-abri ka pirtahan madazaw gazed ya toong panarangin kaniran. Kamhan iza hinoa ya ampakaen kanirang tanan. ");
INSERT INTO mmn_vpl VALUES ("LK12_39","072_12_39","LUK","12","39","39","Sabten mazo ini nga kon mahagdam daan ya tag-iza ka lagkaw kon ono orasa paniken na tolisan diri gazed iza an-endang pagbantay kay diri itogot ya kawatan ka pagpanik. ");
INSERT INTO mmn_vpl VALUES ("LK12_40","072_12_40","LUK","12","40","40","Agon mag-andam isab kamo daan kay andateng gazed hao kay-an ka oras nga wara kamo mahagdam. ");
INSERT INTO mmn_vpl VALUES ("LK12_41","072_12_41","LUK","12","41","41","Pagkakamhan ni Hisos pagpanaba nangotana si Pidro nga Ginoo, daw kami ka lamang ya inpanabaan mo kaiton nga pamolinged kon sirang tanan mga tao? ");
INSERT INTO mmn_vpl VALUES ("LK12_42","072_12_42","LUK","12","42","42","Minsambag si Hisos nga ipamolinged pen ta kamo mahitenged ka pagbalik nao ngarini. May isang sogoonon nga masarigan nga pinili na toong amo ka pagdomara ka mga iba nga sogoonon daw tagan sab siran ka makaen ka hostong orasa. ");
INSERT INTO mmn_vpl VALUES ("LK12_43","072_12_43","LUK","12","43","43","Kon antoman ya sinarigan ka mga sogo na toong amo dakola ya toong kasaza pagdateng na amo. ");
INSERT INTO mmn_vpl VALUES ("LK12_44","072_12_44","LUK","12","44","44","Kamhan insarigan iza na amo ka tanan mga betang. ");
INSERT INTO mmn_vpl VALUES ("LK12_45","072_12_45","LUK","12","45","45","Piro kon maonga ya hena-hena na sinarigan silaong naiza nga madogay pen ya pag-oli na kanaong amo. Kamhan minsogod iza pagpanbonal ka toong mga iba nga sogoonon nga amaama daw babazi. Minkaen sab iza daw min-inem iba ka mga palahebeg. ");
INSERT INTO mmn_vpl VALUES ("LK12_46","072_12_46","LUK","12","46","46","Lomaza iza om-inem daw komaen mindateng di ya toong amo ka waray tirmino nga aldaw. Kamhan silotan iza na amo iba ka mga tao nga diri masarigan. Kamhan patazen sirang tanan. ");
INSERT INTO mmn_vpl VALUES ("LK12_47","072_12_47","LUK","12","47","47","Silotan gazed iza na amo kay bisan nahagdam iza daan ka sogo na toong amo wara naiza tomana, wara mag-andam ka pagdateng na toong amo. ");
INSERT INTO mmn_vpl VALUES ("LK12_48","072_12_48","LUK","12","48","48","Kamhan ya sogoonon nga wara mahagdam kon ono ya sogo na toong amo, diri silotan pagdakola. Na, bisan sin-o ya tao kon insarigan iza na Diyos ka mga mataed, gosto ya Diyos nga magadogangan pen gazed na tao dazaw mataed gazed. Kamhan ya tao nga insarigan na toong kaibahan ka mga mataed, gosto isab siran nga magadogangan pen gazed na tao dazaw mataed gazed. ");
INSERT INTO mmn_vpl VALUES ("LK12_49","072_12_49","LUK","12","49","49","Indogangan pen ni Hisos pagpanaba kaniran nagalaong nga ya tood nao dini ka kalibotan singed hao ka tao nga nagaharing ka toong homay. Gosto nao kon magalaga di iton ");
INSERT INTO mmn_vpl VALUES ("LK12_50","072_12_50","LUK","12","50","50","piro madateng pen hao ka masiet nga kalised. Kamhan mabeg-at gazed ya kanaong hinawa hangtod ka makaazi hao kaiton nga kalised. ");
INSERT INTO mmn_vpl VALUES ("LK12_51","072_12_51","LUK","12","51","51","Diri kamo maghena-hena nga ya pagkarini nao dini ka kalibotan anhatag ka pagpakaangay dizan ka isa daw isa nga tao. Hinoa ya pagkarini nao ani ya sinogdan ka pagkaaway ka isa daw isa kay ya isa antoo kanao piro ya isa diri antoo kanao. ");
INSERT INTO mmn_vpl VALUES ("LK12_52","072_12_52","LUK","12","52","52","Kamhan dizan ka isang pamiliya nga limang bolos nga maglomon ampakig-away ya tolo dizan ka dowa. Ampakig-away isab ya dowa dizan ka tolo. ");
INSERT INTO mmn_vpl VALUES ("LK12_53","072_12_53","LUK","12","53","53","Ampakig-away ya ama ka toong maanak nga amaama. Ampakig-away isab ya maanak ka toong ama. Ampakig-away ya ina ka toong maanak nga babazi. Ampakig-away sab ya maanak ka toong ina. Ampakig-away ya ogangan nga bozag ka toong ogangan nga babazi. Ampakig-away sab ya ogangan ka toong ogangan nga bozag. ");
INSERT INTO mmn_vpl VALUES ("LK12_54","072_12_54","LUK","12","54","54","Kamhan minlaong si Hisos ka kataohan nga pagpakakita mazo ka dag-em nga mingaring ka salpan nagalaong kamo nga an-oran kaan. Kamhan maoran matood. ");
INSERT INTO mmn_vpl VALUES ("LK12_55","072_12_55","LUK","12","55","55","Pagpaniid mazo ka hangin mingaring ka timogan nagalaong disab kamo nga masega kaan. Kamhan minsega matood iton. ");
INSERT INTO mmn_vpl VALUES ("LK12_56","072_12_56","LUK","12","56","56","Mahagdam kamo daan kon madateng kamo ka oran kon sega piro ya mga timaan nga garing ka Diyos mahitenged ka kataposan nga panahon wara baza kamo makasabot. ");
INSERT INTO mmn_vpl VALUES ("LK12_57","072_12_57","LUK","12","57","57","Kay ono sa kamo diri kamo makakilala ka madazaw? ");
INSERT INTO mmn_vpl VALUES ("LK12_58","072_12_58","LUK","12","58","58","Wani ya kanaong tambag kamazo. Kon may ansombong kamazo kamhan dadhen ko naiza ka hokmanan na, ka wara pen kamo makadateng ka hokmanan hosazen mo iza kay kon makadateng kamo ka hokmanan itogyan ko naiza ka maghohokom. Kamhan ya maghohokom antogyan kanmo ka polis. Kamhan ipapiriso iko. ");
INSERT INTO mmn_vpl VALUES ("LK12_59","072_12_59","LUK","12","59","59","Kamhan dizan ko maghela hangtod ka pagkaimpas na kanmong molta. ");
INSERT INTO mmn_vpl VALUES ("LK13_1","072_13_1","LUK","13","1","1","Pagsindo pen ni Hisos kaniran may mga tao dizan kanangiza. Kamhan impanan-og iza niran mahitenged ka mga Yodayo nga taga Galiliya nga impamono ni Pilato paghalad niran ka mga ihazep dalem ka dakolang lagkaw nga pangamozoanan na Diyos. ");
INSERT INTO mmn_vpl VALUES ("LK13_2","072_13_2","LUK","13","2","2","Na, ya mga taga Galiliya daw ya mga taga Yoda diri magkaangay siran kamhan intamay gazed na mga taga Yoda ya mga taga Galiliya. Kamhan minlaong si Hisos kaniran nga nasazep kamo kon anhena-hena kamo nga dakola ya mga sala niran ka mga sala na mga iba nga taga Galiliya. Kamhan nangapatay siran. ");
INSERT INTO mmn_vpl VALUES ("LK13_3","072_13_3","LUK","13","3","3","Panabaan ta kamo nga kon diri kamo maghinelsel ka kamazong mga sala mangapatay isab kamong tanan. ");
INSERT INTO mmn_vpl VALUES ("LK13_4","072_13_4","LUK","13","4","4","Bisan ya mga napolo may walong ka tao nga napatay ka pagkasakem na lagkaw nga ataas ka pagkadeeg doro ka longsod nga Siloi, may sazep mazo kon anhena-hena kamo nga impatay siran kay dakola pen ya mga sala niran ka mga sala na mga iba nga taga Hirosalem. ");
INSERT INTO mmn_vpl VALUES ("LK13_5","072_13_5","LUK","13","5","5","Panabaan ta kamo nga kon diri kamo maghinelsel ka kamazong mga sala mangapatay isab kamong tanan. ");
INSERT INTO mmn_vpl VALUES ("LK13_6","072_13_6","LUK","13","6","6","Kamhan nagapamolinged si Hisos kaniran nga nagalaong nga ka warong aldaw may isang tao. Kamhan dizan ka toong oma may intanem naiza ani ngaran ya igira. Kamhan minbisita iza kaiton nga tanem kay sosihen kon may protas ambaza kay wara. ");
INSERT INTO mmn_vpl VALUES ("LK13_7","072_13_7","LUK","13","7","7","Agon minlaong iza ka toong saop nga ini nga kanaong tinanem tolo ding ka toig ya pagsosi nao ka bonga piro wara gazed mamonga. Hadhaden lamang ini kay kanogon ya lopa. ");
INSERT INTO mmn_vpl VALUES ("LK13_8","072_13_8","LUK","13","8","8","Minsambag ya saop nga Nong, pabet-i lamang iton koman toiga kay libonan kanao ya toboan daw bo-boan kanao ka abono. ");
INSERT INTO mmn_vpl VALUES ("LK13_9","072_13_9","LUK","13","9","9","Kon mamonga iton ka sonod nga toig madazaw gazed piro kon diri hadhaden o lamang. Ani ini ya pamolinged ni Hisos kaniran. ");
INSERT INTO mmn_vpl VALUES ("LK13_10","072_13_10","LUK","13","10","10","PagkaSabado nga tigpahimlay na mga Yodayo minsindo si Hisos kaniran dizan ka isang singbahan. ");
INSERT INTO mmn_vpl VALUES ("LK13_11","072_13_11","LUK","13","11","11","Na, dizan disab may babazi nga inhabay sokad ka napolo may walong ka toig. Kamhan nabozokot gazed iza, diri iza makatindeg pagtol-id. ");
INSERT INTO mmn_vpl VALUES ("LK13_12","072_13_12","LUK","13","12","12","Pagpakakita ka ni Hisos kaiton nga babazi minlaong iza nga nawara di ya masakit ka kanmong lawas. ");
INSERT INTO mmn_vpl VALUES ("LK13_13","072_13_13","LUK","13","13","13","Kamhan indampa ni Hisos ya likod na babazi. Kamhan nahenat matood ya toong likod. Mintindeg dazon iza. Kamhan insaza gazed naiza ya Diyos. ");
INSERT INTO mmn_vpl VALUES ("LK13_14","072_13_14","LUK","13","14","14","Piro nazehet ya oloolo ka singbahan kay inpabahaw ni Hisos ya babazi ka aldaw nga tigpahimlay. Kamhan minlaong ya oloolo ka mga tao nga kada simana may enem nga ka aldaw nga makatarabaho kamo. Magpatambal hinoa kamo kaiton nga mga aldaw kay ya pagtambal ka tao singed iton ka tarabaho. Basta ya kantang aldaw nga tigpahimlay diri gazed kamo magpatambal. ");
INSERT INTO mmn_vpl VALUES ("LK13_15","072_13_15","LUK","13","15","15","Minsambag si Hisos nga mga bakak ya kamazong batasan! Kay bisan kon aldaw nga tigpahimlay hobaden mazo ya tanan mga karabaw daw kabayo dazaw paimnen dizan ka sapa. ");
INSERT INTO mmn_vpl VALUES ("LK13_16","072_13_16","LUK","13","16","16","Kamhan minlaong kamo nga maonga gazed hao kay inkawa nao ya kasakit na babazi nga kaliwat ni Abraham nga impaanget ni Satanas ka napolo may walong ka toig. Kinahanglan librihen gazed iza koman aldaw nga kamazong tigpahimlay. ");
INSERT INTO mmn_vpl VALUES ("LK13_17","072_13_17","LUK","13","17","17","Kamhan masipeg gazed ya tanan mga kaaway ni Hisos. Kamhan minsaza ya tanan mga tao kay madazaw gazed ya toong pagtabang ka mga tao. ");
INSERT INTO mmn_vpl VALUES ("LK13_18","072_13_18","LUK","13","18","18","Kamhan indogangan pen ni Hisos paglaong kaniran nga wani ya pagmolinged mahitenged ka pagpaoswag na Diyos ka toong paghari dini ka mga tao. ");
INSERT INTO mmn_vpl VALUES ("LK13_19","072_13_19","LUK","13","19","19","Singed iton ka isang bolos nga liso inngaranan ka mostasa. Kamhan intanem na tao dizan ka toong oma. Bisan geramay iton ka bisan ono nga liso, ka pagsolig di mahinang iton ka dakolang liwaan kay doro ka lopa nga Yoda ya mostasa liwaan iton nga opat nga ka mitros ya kaataas. Kamhan magapogad ya mga manokmanok dizan ka mga sap-ay naiton. ");
INSERT INTO mmn_vpl VALUES ("LK13_20","072_13_20","LUK","13","20","20","Kamhan nagapamolinged pen si Hisos kaniran mahitenged ka pagpasakop na Diyos ka mga tao nagalaong nga ");
INSERT INTO mmn_vpl VALUES ("LK13_21","072_13_21","LUK","13","21","21","singed iton ka ipasoligay ka tinapay. Insaktan na babazi ka ipasoligay ya tolong ka takes nga harina. Kamhan minsolig iton kadakola gazed ya pagsolig. ");
INSERT INTO mmn_vpl VALUES ("LK13_22","072_13_22","LUK","13","22","22","Pagkakamhan ni Hisos pagpanaba kaniran minpasinged iza ngaro ka Hirosalem. Pag-azi naiza ka mga longsod daw ya mga bariyo nagasindo iza ka mga tao. ");
INSERT INTO mmn_vpl VALUES ("LK13_23","072_13_23","LUK","13","23","23","Kamhan nangotana ya isang tao nga Ginoo, daw talagsa ka lamang ya tao nga mahatagan ka bag-ong kinabohi nga waray kinateban? Minsambag si Hisos nga ");
INSERT INTO mmn_vpl VALUES ("LK13_24","072_13_24","LUK","13","24","24","magpakalaki kamo pagseled dizan ka masiet nga pirtahan. Kay mataed ya anseled kontana piro diri siran makaseled ");
INSERT INTO mmn_vpl VALUES ("LK13_25","072_13_25","LUK","13","25","25","kay insirahan na tag-iza. Kamhan dizan ka gawas anhawag kamo nga Ginoo, paselden mo kami, kamhan ansambag iza kamazo nga wara hao mahagdam kon sin-o sa kamo. ");
INSERT INTO mmn_vpl VALUES ("LK13_26","072_13_26","LUK","13","26","26","Kamhan anmahay kamo magalaong nga kami nga mga Yodayo ani ya min-iba kanmo ka pagkaen izang dini kaini. Minsindo iko dizan ka mga dalan na kanaming longsod. ");
INSERT INTO mmn_vpl VALUES ("LK13_27","072_13_27","LUK","13","27","27","Kamhan ansambag iza kamazo pag-isab nga wara hao mahagdam kon sin-o sa kamo. Mga salaan nga tao, iwat kamo dini kanao. ");
INSERT INTO mmn_vpl VALUES ("LK13_28","072_13_28","LUK","13","28","28","Pagkita mazo kan Abraham daw si Isak daw si Hakob daw ya tanan mga karaang propita na Diyos dizan ka hel-anan na Diyos, magapangageet kamo ka kamazong ngipen ka paghaza kay impamogaw kamo na Diyos. ");
INSERT INTO mmn_vpl VALUES ("LK13_29","072_13_29","LUK","13","29","29","Kamhan ampakaen ya Diyos ka mga mataed nga tao nga diri kon Yodayo nga garing ka sebazan daw salpan daw kanawazan daw timogan. ");
INSERT INTO mmn_vpl VALUES ("LK13_30","072_13_30","LUK","13","30","30","Magtimaan kamo kaini nga koman ya mga mahori, mahon-a siran kay-an. Kamhan ya mga mahon-a koman mahori siran kay-an. ");
INSERT INTO mmn_vpl VALUES ("LK13_31","072_13_31","LUK","13","31","31","Pagkakamhan ni Hisos pagpanaba kaniran mindateng di kanangiza ya mga Parasiyo. Kamhan minlaong siran nga pomanaw ko dini kay patazen ko kontana ni Hirodis nga hari. ");
INSERT INTO mmn_vpl VALUES ("LK13_32","072_13_32","LUK","13","32","32","Minsambag si Hisos nga hanas gazed si Hirodis paglimbong ka mga tao. Magkaro kamo kanangiza daw maglaong nga koman aldaw daw konsilem palogwaen pen nao ya mga maonga. Pabahawen sab nao ya kasakit na mga tao. Pagdateng ka ikatolong aldaw kamhan di gazed ya kanaong tarabaho. ");
INSERT INTO mmn_vpl VALUES ("LK13_33","072_13_33","LUK","13","33","33","Kamhan minlaong iza ka toong mga iba nga magapasinged pen hao ka dalan ngaro ka siyodad nga Hirosalem koman aldaw daw pagkakonsilem daw pagkakon-isa. Diri mahimo ya pagpatay ni Hirodis kanao dini kay ya siyodad nga Hirosalem ani ya napatzan na mga propita na Diyos. ");
INSERT INTO mmn_vpl VALUES ("LK13_34","072_13_34","LUK","13","34","34","Kamo nga mga taga Hirosalem, nagalised di gazed ya kanaong hena-hena kay inpatay mazo pagpamook ya mga karaang propita na Diyos daw ya mga sogoonon nga impakarini na Diyos kamazo. Gosto gazed hao an-aligara kamazo singed ka manggianak nga nagatipon ka toong mga pise dalem ka toong ampak piro diri kamo ansogot. ");
INSERT INTO mmn_vpl VALUES ("LK13_35","072_13_35","LUK","13","35","35","Sabten mazo ini nga pamanawan gazed na mga tao dini ka hel-anan mazo. Sokad koman diri kamo makakita kanao hangtod ka pagbalik nao. Kamhan ansaza kamo kanao magalaong nga sazaen ta iza nga impakarini na Diyos dini kanami. Ani ini ya inlaong ni Hisos kaniran. ");
INSERT INTO mmn_vpl VALUES ("LK14_1","072_14_1","LUK","14","1","1","May isa pen nga Sabado impakaen si Hisos na isang oloolo na mga Parasiyo. Kamhan nagapaniid gazed ya mga Parasiyo kon dazawen ni Hisos ya masakit na tao koman aldaw nga tigpahimlay. ");
INSERT INTO mmn_vpl VALUES ("LK14_2","072_14_2","LUK","14","2","2","Na, dizan kanangiza may tao nga nanghepeng di ya toong mga bitiis daw mga bekten. ");
INSERT INTO mmn_vpl VALUES ("LK14_3","072_14_3","LUK","14","3","3","Kamhan nangotana si Hisos ka mga maistro ka tinoohan na mga Yodayo daw ya mga Parasiyo nagalaong nga ya balaed na Diyos mahitenged ka aldaw nga tigpahimlay daw itogot ka pagkalooy ka masakiten kon diri? ");
INSERT INTO mmn_vpl VALUES ("LK14_4","072_14_4","LUK","14","4","4","Piro wara siran magsambag. Paghabit ni Hisos kaiton nga tao nadazaw matood ya toong lawas. Kamhan impaoli iza ni Hisos. ");
INSERT INTO mmn_vpl VALUES ("LK14_5","072_14_5","LUK","14","5","5","Kamhan minlaong iza ka mga Parasiyo nga dini kamazo sin-o ya may maanak kon may bohien nga karabaw nga naholog dalem ka gahong. Na, bisan aldaw nga tigpahimlay, batonon gazed mazo ya naholog. ");
INSERT INTO mmn_vpl VALUES ("LK14_6","072_14_6","LUK","14","6","6","Kamhan wara gihapon siran magsambag kan Hisos. ");
INSERT INTO mmn_vpl VALUES ("LK14_7","072_14_7","LUK","14","7","7","Kamhan minpaniid si Hisos ka batasan na mga iba nga bisita dizan ka lagkaw na Parasiyo kay impili niran ya mga lo-toanan nga madazaw ka pagkaen. Kamhan minlaong iza kaniran nga ");
INSERT INTO mmn_vpl VALUES ("LK14_8","072_14_8","LUK","14","8","8","kon pakanen kamo na tao ka kombiti, diri kamo maglo-to dizan ka mga madazaw nga lo-toanan kay basi may andateng sonod kanmo nga labaw kanmo. ");
INSERT INTO mmn_vpl VALUES ("LK14_9","072_14_9","LUK","14","9","9","Kamhan panabaan ko na oloolo ka kombiti nga magtindeg ko naa kay iza ya palo-toon nao dini. Kamhan masipeg gazed iko pagsibog mo dizan ka labing obos nga dapit. ");
INSERT INTO mmn_vpl VALUES ("LK14_10","072_14_10","LUK","14","10","10","Hinoa kon dapiten kamo maglo-to kamo dizan ka lo-toanan nga diri kon madazaw. Kamhan kon ankita kanmo ya oloolo anlaong iza kanmo nga higara, bomalhin ko naa dini kaini nga lo-toanan nga madazaw. Kamhan mahagdam ya mga naneleng nga iko matood ya higara na taglagkaw. ");
INSERT INTO mmn_vpl VALUES ("LK14_11","072_14_11","LUK","14","11","11","Kay bisan sin-o ya ampalabaw ka toong kaogaringen dizan ka toong mga iba, iza gazed ya impaebes na Diyos. Kamhan bisan sin-o ya mapaebes ka toong kaogaringen, iza gazed ya impalabaw na Diyos. ");
INSERT INTO mmn_vpl VALUES ("LK14_12","072_14_12","LUK","14","12","12","Pagkakamhan ni Hisos paglaong kaniran minlaong isab iza ka mindapit kanangiza nga kon an-andam iko ka kombiti, diri mo dapita ya kanmong mga higara daw mga lomon daw mga kaibahan daw ya kanmong songbalay nga kowartahan kay siran ya anbales pagdapit dazaw makaimpas kanmo. ");
INSERT INTO mmn_vpl VALUES ("LK14_13","072_14_13","LUK","14","13","13","Hinoa dapita mo ya mga pobri daw ya mga nabarian daw ya mga piang daw ya mga nabota. ");
INSERT INTO mmn_vpl VALUES ("LK14_14","072_14_14","LUK","14","14","14","Kamhan madazaw ya panarangin kanmo na Diyos kay diri siran makabales ka pag-impas kanmo. Mabalsan ko matood na Diyos kay-an ka aldawa ka pagkabohi naiza pagbalik ka mga matadeng nga tao garing ka lebeng. ");
INSERT INTO mmn_vpl VALUES ("LK14_15","072_14_15","LUK","14","15","15","Na, dizan ka mga tao nga mintambong ka pagkaen may isa nga nakabati kaiton nga inlaong ni Hisos. Kamhan minlaong iza nga dakola ya kasaza na mga tao nga pakanen na Diyos kay-an ka pagkahari naiza ka bag-ong kalibotan. ");
INSERT INTO mmn_vpl VALUES ("LK14_16","072_14_16","LUK","14","16","16","Minsambag si Hisos pagpamolinged nga may tao nga min-andam ka dakolang pagkaen. Indapit naiza ya mga mataed nga tao. ");
INSERT INTO mmn_vpl VALUES ("LK14_17","072_14_17","LUK","14","17","17","Pagkakamhan naiza pagpakaandam ka makaen impakaro di naiza ya toong sogoonon ka mga tao nga toong dinapit dazaw long-on nga komaro di kamo kay mangaen di naa kamo doro. ");
INSERT INTO mmn_vpl VALUES ("LK14_18","072_14_18","LUK","14","18","18","Ambaza kay minbaribad sirang tanan ka impanaba na sogoonon. Minlaong ya isa pagbaribad nga nakapalit di hao ka lopa nga in-oma nao. Kinahanglan nga sosihen nao iton. Pasaylohon mo hao kay diri hao makatambong. ");
INSERT INTO mmn_vpl VALUES ("LK14_19","072_14_19","LUK","14","19","19","Minlaong ya ikadowa nga nakapalit di hao ka mga karabaw nga napolo nga bolos. Kinahanglan nga porbahan nao pagdaro. Pasaylohon mo hao kay diri isab hao makatambong. ");
INSERT INTO mmn_vpl VALUES ("LK14_20","072_14_20","LUK","14","20","20","Kamhan minlaong ya ikatolo nga bag-o pen hao maminze agon diri hao makatambong. ");
INSERT INTO mmn_vpl VALUES ("LK14_21","072_14_21","LUK","14","21","21","Pagkakamhan kaiza min-oli ya sogoonon kay minpakahagdam ka toong amo. Kamhan nazehet gazed ya amo. Minsogo disab iza ka sogoonon nga pangarohen mo pagdali ya mga kadalanan nga haloag daw masiet dini ka longsod. Dadhen mo ngarini ya mga pobri daw ya mga nabarian daw ya mga nabota daw ya mga piang. ");
INSERT INTO mmn_vpl VALUES ("LK14_22","072_14_22","LUK","14","22","22","Ka wara pen madogay minlaong ya sogoonon nga Nong, mintoman di hao ka kanmong sogo kanao piro dakola pen ya makaen. ");
INSERT INTO mmn_vpl VALUES ("LK14_23","072_14_23","LUK","14","23","23","Minsambag ya amo nga komaro ko naa ka kadalanan nga aro ka longsod. Legesen mo ya mga tao pagpakarini dazaw mapono ya kanaong lagkaw. ");
INSERT INTO mmn_vpl VALUES ("LK14_24","072_14_24","LUK","14","24","24","Kay sabten mo ini nga bisan sin-o ya daan dinapit nao diri di gazed iza makatilaw ka kanaong in-andam. ");
INSERT INTO mmn_vpl VALUES ("LK14_25","072_14_25","LUK","14","25","25","Pagkakamhan ni Hisos pagbisita dizan minpasinged pen iza ngaro ka siyodad nga Hirosalem. Nangiba disab ya masarang kataed nga mga tao. Kamhan minliso iza dizan kaniran daw minpanaba nga ");
INSERT INTO mmn_vpl VALUES ("LK14_26","072_14_26","LUK","14","26","26","bisan sin-o ya ampasakop kanao kon palabawen naiza ya toong pag-azak ka toong ama daw ina daw asawa daw mga bata daw mga lomon daw toong kaogaringen ka kaazak naiza kanao, diri mahimo ya toong pagpasakop kanao. ");
INSERT INTO mmn_vpl VALUES ("LK14_27","072_14_27","LUK","14","27","27","Kon diri ampadazon ya tao pagtoman ka kanaong mga sogo kanangiza kay basi patazen iza diri mahimo ya toong pagpasakop kanao. ");
INSERT INTO mmn_vpl VALUES ("LK14_28","072_14_28","LUK","14","28","28","Ya tao nga ampasakop kanao singed iza ka tao nga gosto anhinang ka ataas nga lagkaw. Ka wara pen iza magsogod paghinang anhena-hena pen iza kon pira ya toong gasto nga ikakamhan ka lagkaw kon igo di ya toong kowarta kon diri. ");
INSERT INTO mmn_vpl VALUES ("LK14_29","072_14_29","LUK","14","29","29","Kon diri an-igo ya toong kowarta masazep gazed iza kon ansogod iza paghinang ka lagkaw kay ka wara pen makamhan mahorot matood ya toong kowarta. Kamhan biaybiazen gazed iza na toong kaibahan nga ");
INSERT INTO mmn_vpl VALUES ("LK14_30","072_14_30","LUK","14","30","30","nagalaong nga minsogod iza paghinang ka ataas nga lagkaw ambaza kay imbizaan di kay diri an-igo ya toong kowarta nga ikakamhan. ");
INSERT INTO mmn_vpl VALUES ("LK14_31","072_14_31","LUK","14","31","31","Na, ya tao nga ampasakop kanao singed isab iza ka isang hari nga may mga soldaw nga napolo nga ka libo. Kamhan ya hari nga toong kaaway mataed pen ya toong mga soldaw kay karohaan nga ka libo sirang tanan. Na, ka wara pen ya isang hari ampakiggira anhena-hena iza kon makadaeg iza ka toong kaaway kon diri. ");
INSERT INTO mmn_vpl VALUES ("LK14_32","072_14_32","LUK","14","32","32","Pagkakamhan naiza paghena-hena nga diri iza makadaeg ipahon-a naiza ya toong mga sogoonon ka hari nga kaaway dazaw ampakighosay iza. ");
INSERT INTO mmn_vpl VALUES ("LK14_33","072_14_33","LUK","14","33","33","Bisan ya tao nga ampasakop kanao kinahanglan maghena-hena iza paghon-a kon makabiza iza ka toong mga betang daw kaibahan dazaw ansakop iza kanao. Kon diri iza makabiza kanirang tanan diri gazed iza makasakop kanao kay diri iza makaanget ka mga kalised. ");
INSERT INTO mmn_vpl VALUES ("LK14_34","072_14_34","LUK","14","34","34","Kay ya pag-anget mazo ka mga kalised singed iton ka asin nga madazaw piro kon diri kamo makaanget ka mga kalised singed kamo ka asin nga wara di ya kaparat. Kamhan diri di gazed ambalik ya kaparat. ");
INSERT INTO mmn_vpl VALUES ("LK14_35","072_14_35","LUK","14","35","35","Agon itimbag lamang kay wara di ya polos. Kamo nga mga manalingahay, magtaremdem kamo kaini nga sindo nao kamazo. ");
INSERT INTO mmn_vpl VALUES ("LK15_1","072_15_1","LUK","15","1","1","Pagkakamhan kaiza minkarini kan Hisos ya mga mataed nga magsokotay ka bohis daw ya mga iba pen nga salaan nga tao kay manalinga siran kanangiza. ");
INSERT INTO mmn_vpl VALUES ("LK15_2","072_15_2","LUK","15","2","2","Kamhan minmahay ya mga Parasiyo daw ya mga maistro ka tinoohan na mga Yodayo nagalaong nga iton nga tao min-abiabi iza ka mga salaan nga tao daw minpakigsaro iza kaniran! ");
INSERT INTO mmn_vpl VALUES ("LK15_3","072_15_3","LUK","15","3","3","Mahagdam si Hisos ka kanirang mga panaba agon minpamolinged iza kaniran nga ");
INSERT INTO mmn_vpl VALUES ("LK15_4","072_15_4","LUK","15","4","4","simpan dini kamazo may isa nga minbohi ka mga isang ka gatos nga karniro kamhan nalaag ya isa. Kamhan daw ono ya kanmong hinangen? Imbilin ya mga kasizaman may sizam dizan ka samsamanan kay pangitan gazed ya isa nga nalaag hasta ka makita. ");
INSERT INTO mmn_vpl VALUES ("LK15_5","072_15_5","LUK","15","5","5","Pagkakiti mo ka isa seng-azen dazon. Kamhan minsaza gazed ya hinawa mo. ");
INSERT INTO mmn_vpl VALUES ("LK15_6","072_15_6","LUK","15","6","6","Pagdateng ka lagkaw patiponan disab ya mga kaibahan mo kay magalaong nga magsaza di kita kay nakitan nao ya isang karniro nga nalaag. ");
INSERT INTO mmn_vpl VALUES ("LK15_7","072_15_7","LUK","15","7","7","Kamhan ya mga salaan nga tao singed siran ka mga karniro nga nalaag. Paghinelsel na isang salaan ka toong mga sala labaw pen ya kasaza na Diyos ka toong kasaza ka mga kasizaman may sizam nga tao nga diri anhinelsel kay silaong niran nga waray sala niran. ");
INSERT INTO mmn_vpl VALUES ("LK15_8","072_15_8","LUK","15","8","8","Kamhan indogangan pen ni Hisos ka pagpamolinged kaniran nga may isang babazi nga napolong bolos ya toong palata nga kowarta nga bolawan. Kamhan nalaag ya isa. Kamhan an-ono ya babazi? Ansegà matood iza ka toong lamparahan kay silhigan naiza ya toong lagkaw. Sosihen gazed naiza ya toong lagkaw daw hangwan hangtod nga makitan naiza ya palata nga nalaag. ");
INSERT INTO mmn_vpl VALUES ("LK15_9","072_15_9","LUK","15","9","9","Kamhan patiponan dazon naiza ya toong kaibahan kay magalaong nga magsaza di kita kay nakitan di nao ya kanaong kowarta nga nalaag. ");
INSERT INTO mmn_vpl VALUES ("LK15_10","072_15_10","LUK","15","10","10","Kamhan ya kasaza niran singed iton ka kasaza na mga taga langit nga sogoonon na Diyos paghinelsel na isang ka tao ka toong mga sala. ");
INSERT INTO mmn_vpl VALUES ("LK15_11","072_15_11","LUK","15","11","11","Kamhan indogangan pen ni Hisos pagpamolinged kaniran nga may isang tao nga dowang bolos ya toong maanak nga amaama. ");
INSERT INTO mmn_vpl VALUES ("LK15_12","072_15_12","LUK","15","12","12","Kamhan minlaong ya manghod nga Tay, bahinen mo koman ya kanmong mga betang. Kamhan tagan mo hao ka kanaong irinsiya. Kamhan minbahin matood ya ama ka toong mga betang dizan kanirang dowa. ");
INSERT INTO mmn_vpl VALUES ("LK15_13","072_15_13","LUK","15","13","13","Ka wara pen madogay inbaligza na manghod ya toong kabahinan. Kamhan minpanaw iza doro ka aro. Kamhan kanogon gazed ya toong kowarta kay ingastogasto naiza ya toong kowarta ka maongang hinang. ");
INSERT INTO mmn_vpl VALUES ("LK15_14","072_15_14","LUK","15","14","14","Pagkahorot ka na toong kowarta mindateng ya dakolang pihit dizan kaiton nga dapita. Kamhan nagalised gazed iza kay wara di ya toong panginabohi. ");
INSERT INTO mmn_vpl VALUES ("LK15_15","072_15_15","LUK","15","15","15","Kamhan anpatarabaho iza ka isang tao dizan ka longsod. Kamhan insogo iza ka pagbahog ka mga baboy. Malised iton kay ya manghod Yodayo iza. Kamhan ya mga Yodayo diri ambohi ka mga baboy kay maonga koni. ");
INSERT INTO mmn_vpl VALUES ("LK15_16","072_15_16","LUK","15","16","16","Pagbahog naiza ka mga baboy ankaen iza kontana ka mga parot nga inbahog kaniran kay waray makaen naiza. ");
INSERT INTO mmn_vpl VALUES ("LK15_17","072_15_17","LUK","15","17","17","Pagkadogay ka kaiza minlaong ya manghod ka toong hena-hena nga nasazep gazed hao kay hapit hao mapatay ka kabengtas dini. Kamhan doro ka kanaong ama nanobra ya pagkaen na toong mga sinoholan. ");
INSERT INTO mmn_vpl VALUES ("LK15_18","072_15_18","LUK","15","18","18","Ampanaw di gazed hao. An-oli di hao ka kanaong ama kay long-on nao iza nga Tay, nakasala gazed hao ka Diyos daw kanmo. ");
INSERT INTO mmn_vpl VALUES ("LK15_19","072_15_19","LUK","15","19","19","Diri di kon angay pen nga maanak pen mo hao. Hinangen di mo lamang hao singed ka mga sinoholan mo. ");
INSERT INTO mmn_vpl VALUES ("LK15_20","072_15_20","LUK","15","20","20","Pagkakamhan naiza paghena-hena minpanaw iza pag-oli ngaro ka toong ama. Ka aro pen iza ka lagkaw nakakita di ya toong ama nga waton di ngarini ya toong maanak. Kamhan mintonaw ya toong hinawa ka kalooy. Min-ariari gazed iza ka pagsogat ka toong maanak. Kamhan minkolapot iza daw min-arek ka pagsaza. ");
INSERT INTO mmn_vpl VALUES ("LK15_21","072_15_21","LUK","15","21","21","Kamhan minlaong ya maanak nga Tay, nakasala hao ka Diyos daw kanmo agon diri di mo hao paglong-on nga kanmo peng maanak. ");
INSERT INTO mmn_vpl VALUES ("LK15_22","072_15_22","LUK","15","22","22","Kamhan ya ama minhawag dazon ka mga sogoonon nga dali kamo, dadha mazo ngarini ya bado nga madazaw. Kamhan badoi mazo ini daw sol-oti ka kanaong singsing daw sapatosi iza! ");
INSERT INTO mmn_vpl VALUES ("LK15_23","072_15_23","LUK","15","23","23","Kamhan dakpa mazo ya bohien nga pinahonlas. Ihawen mazo kay magapista gazed kita ka pagsaza. ");
INSERT INTO mmn_vpl VALUES ("LK15_24","072_15_24","LUK","15","24","24","Kay nabohi ka ya kanaong maanak nga silaong nao nga patay di. Nalaag iza piro nakaoli ka kanao. Pagkakamhan kaiza minsogod siran pagpabibo. ");
INSERT INTO mmn_vpl VALUES ("LK15_25","072_15_25","LUK","15","25","25","Kamhan wara dizan ya magorang kay waro pen iza ka oma. Pagpakaoli ka naiza nabatian naiza ya tanog na mga agong daw ya masamok ka kabibo. ");
INSERT INTO mmn_vpl VALUES ("LK15_26","072_15_26","LUK","15","26","26","Kamhan minhawag iza ka isang sogoonon nga nagalaong nga onosa wani nga mabibo sa kamo koman? ");
INSERT INTO mmn_vpl VALUES ("LK15_27","072_15_27","LUK","15","27","27","Minsambag iza nga min-oli di ya manghod mo. Agon inpatazan di na ama mo ka bohien nga pinahonlas kay bohi ka ya toong maanak. ");
INSERT INTO mmn_vpl VALUES ("LK15_28","072_15_28","LUK","15","28","28","Kamhan nazehet gazed ya magorang. Diri iza anseled ka lagkaw. Agon minlogwa ya toong ama kay anhangzo iza ka pagseled ngandalem ka lagkaw. ");
INSERT INTO mmn_vpl VALUES ("LK15_29","072_15_29","LUK","15","29","29","Kamhan minsambag ya magorang nga Tay, hao ya mintabang kanmo ka pirang ka toig. Bisan ono ya sogo mo kanao mintoman gazed hao. Kamhan wara mo hao hatagi bisan kanding ka lamang dazaw ampamista hao daw ya kanaong mga higara. ");
INSERT INTO mmn_vpl VALUES ("LK15_30","072_15_30","LUK","15","30","30","Hinoa ya maanak mo nga nakaosik-osik ka kanmong kowarta doro ka mga maongang babazi pagpakaoli naiza in-ihawan mo baza ka bohien nga pinahonlas. ");
INSERT INTO mmn_vpl VALUES ("LK15_31","072_15_31","LUK","15","31","31","Minsambag ya ama nga Loy, iko matood ya masarigan pagtarabaho dini kanao ka mga mataed nga toig. Kamhan kanmo di gazed ya tanan mga betang nao. ");
INSERT INTO mmn_vpl VALUES ("LK15_32","072_15_32","LUK","15","32","32","Madazaw isab ya pagpamista nao ka kanmong manghod kay bohi ka iza nga silaong nao patay di. Nalaag iza piro nakaoli ka kanao. Na, ani ini ya pamolinged ni Hisos dizan ka mga maistro ka tinoohan na mga Yodayo kay minmahay siran nga nagaabiabi si Hisos ka mga salaan nga tao. ");
INSERT INTO mmn_vpl VALUES ("LK16_1","072_16_1","LUK","16","1","1","Pagkakamhan kaiza minpamolinged si Hisos ka toong mga sakop nga nagalaong nga may isang tao nga kowartahan. Kamhan inpasarigan naiza ya toong kowarta dizan ka timbang nga hanas ka paggamit ka kowarta dazaw madogangan iton. Ka wara pen madogay impakahagdam ya amo nga in-osik-osikan na timbang ya toong kowarta. ");
INSERT INTO mmn_vpl VALUES ("LK16_2","072_16_2","LUK","16","2","2","Kamhan impakarini naiza ya timbang daw nagalaong nga ono sa wani nga nabatian nao kanmo? Ibalik mo kanao ya tanan mga kowarta kay palogwaen ta ko kaan. ");
INSERT INTO mmn_vpl VALUES ("LK16_3","072_16_3","LUK","16","3","3","Kamhan nagalised gazed ya hena-hena na timbang kay matood ya nabatian na amo. Kamhan minlaong iza ka toong hena-hena nga kon palogwaen hao naiza daw magaono di sa hao? Waray mahimo nao ka paghinang ka oma. Masipeg hao ka pagpangazo ka kowarta. ");
INSERT INTO mmn_vpl VALUES ("LK16_4","072_16_4","LUK","16","4","4","Agon an-andam hao daan dazaw ampaloon ya mga tao kanao ka kanirang lagkaw kay-an ka pagpalogwa kanao na kanaong amo. ");
INSERT INTO mmn_vpl VALUES ("LK16_5","072_16_5","LUK","16","5","5","Kamhan minpakarini iza ka mga otangan ka toong amo kay ansabot pen iza kaniran. Nangotana iza ka isa kon pira ya toong otang. ");
INSERT INTO mmn_vpl VALUES ("LK16_6","072_16_6","LUK","16","6","6","Minsambag iza nga nakaotang hao ka isang ka gatos nga ka taro nga lana. Kamhan mintogon ya timbang nga wani ya lista ka otang mo. Dali, isoyat mo naa ya kalim-an ka lamang. Kamhan ipakita nao iton ka kanaong amo. ");
INSERT INTO mmn_vpl VALUES ("LK16_7","072_16_7","LUK","16","7","7","Kamhan nangotana iza ka ikadowang otangan nga daw pira ya otang mo ka kanaong amo? Minsambag iza nga nakaotang hao ka isang ka libo nga ka sako nga begas. Kamhan mintogon ya timbang nga wani ya lista ka otang mo. Isoyat mo lamang ya walong ka gatos nga ka sako. Ani ini ya toong hinang dazaw kay-an ka pagpalogwa kanangiza na amo, siran ya anpaloon kanangiza. ");
INSERT INTO mmn_vpl VALUES ("LK16_8","072_16_8","LUK","16","8","8","Pagpaniid ka na amo ka paglimbong na timbang bisan diri iza maazak ka limbong minlaong iza nga hanas gazed iza pag-andam daan ka toong panginabohi. Ani ini ya pamolinged ni Hisos ka toong mga sakop. Kamhan minpanaba si Hisos kaniran nga ya mga tao nga diri antoo kanao singed siran ka timbang. Kamhan ya pagkahanas niran ka paghinang ka bakak labaw iton ka pagkahanas na kanaong mga sakop ka paghinang ka mga madazaw. ");
INSERT INTO mmn_vpl VALUES ("LK16_9","072_16_9","LUK","16","9","9","Panabaan ta kamo. Gamiten mazo ya kamazong kowarta ka pagpakig-azok ka mga tao dazaw kay-an ka pagpakahorot na kamazong kowarta siran ya an-abiabi kamazo daked ka hel-anan nga diri mageba kawanihen ka. ");
INSERT INTO mmn_vpl VALUES ("LK16_10","072_16_10","LUK","16","10","10","Kon matadeng ya batasan na tao nga insarigan ka mga talagsa kang betang, matadeng isab iza kon isarig kanangiza ya mga mataed nga betang. Kon limbongan ya tao nga insarigan ka mga talagsa kang betang, limbongan isab iza kon isarig kanangiza ya mga mataed nga betang. ");
INSERT INTO mmn_vpl VALUES ("LK16_11","072_16_11","LUK","16","11","11","Kon diri kon matadeng ya kamazong batasan ka pag-aligara ka kowarta nga insarig kamazo dini ka kalibotan, waray ampasarig kamazo ka matood nga mahalen daked ka hel-anan na Diyos. ");
INSERT INTO mmn_vpl VALUES ("LK16_12","072_16_12","LUK","16","12","12","Kon diri kon matadeng ya kamazong batasan ka pag-aligara ka mga betang na kamazong iba waray ampasarig kamazo ka pag-aligara ka bisan ono. ");
INSERT INTO mmn_vpl VALUES ("LK16_13","072_16_13","LUK","16","13","13","Kamhan ya isang sogoonon diri iza makaalagad pagdengan ka dowang ka agaron. Kay kon dowa ya toong agaron tahodon naiza ya isa piro magatamazen naiza ya isa. Kon dakola ya kaazak mazo ka kowarta diri mahimo ya pag-alagad mazo ka Diyos. ");
INSERT INTO mmn_vpl VALUES ("LK16_14","072_16_14","LUK","16","14","14","Na, dizan disab may mga Parasiyo nga in-awes ya dakolang kowarta. Kamhan pagkabati niran ka impanaba ni Hisos mahitenged ka kowarta intamaytamay gazed niran. ");
INSERT INTO mmn_vpl VALUES ("LK16_15","072_16_15","LUK","16","15","15","Minsambag si Hisos nga dizan ka mga tao nagapatihinang kamo ka madazaw nga batasan kay ampakita kamo kaniran nga waray sala mazo piro mahagdam ya Diyos ka kamazong hena-hena. Kamhan bisan dakola ya pagtahod na mga tao kamazo silotan gazed kamo na Diyos pagdobli. ");
INSERT INTO mmn_vpl VALUES ("LK16_16","072_16_16","LUK","16","16","16","Sokad kawandini pen dogay di hangtod ka pagdateng ni Howan nga Magbenzagay inton-an mazo ya daan balaed na Diyos daw ya sindo na mga karaang propita. Sokad ka pagdateng ni Howan inwalihan kamo ka sindo mahitenged ka pagpasakop na Diyos ka mga tao. Kamhan mataed ya ampakalaki pagpasakop kanao. ");
INSERT INTO mmn_vpl VALUES ("LK16_17","072_16_17","LUK","16","17","17","Kamhan ya daan balaed na Diyos, diri gazed makawa ya bisan isang ka toblok lamang kay matoman gazed ya tanan. Masazon ya pagkawara na kalibotan daw kalangitan ka pagkakawa na daan balaed na Diyos. ");
INSERT INTO mmn_vpl VALUES ("LK16_18","072_16_18","LUK","16","18","18","Kamhan wani ya isang sindo dizan ka daan balaed na Diyos nga bisan sin-o ya anpakigbelag ka toong asawa dazaw anminze iza ka laing babazi minhenay iza ka toong primirong asawa. Kamhan ya tao nga anminze ka babazi nga imbelagan na bana minhenay iza kay daan minze ya babazi. ");
INSERT INTO mmn_vpl VALUES ("LK16_19","072_16_19","LUK","16","19","19","Pagkakamhan kaiza indogangan pen ni Hisos pagpanan-og ka mga Parasiyo nga nagalaong nga may isang tao nga kowartahan nga mahal ya pagabadoon naiza. Madazaw isab ya toong pagakanen kada aldaw. ");
INSERT INTO mmn_vpl VALUES ("LK16_20","072_16_20","LUK","16","20","20","Kamhan may isang pobri nga si Lazaro ya ngaran. Masarang kataed ya toong mga samad. Impabentag iza dizan ka pirtahan na lagkaw na kowartahan ");
INSERT INTO mmn_vpl VALUES ("LK16_21","072_16_21","LUK","16","21","21","kay ankaen iza kontana ka bisan ya mga basora nga intimbag na kowartahan. Magalised gazed iza kay magapanilaan na mga ido ya toong mga samad. ");
INSERT INTO mmn_vpl VALUES ("LK16_22","072_16_22","LUK","16","22","22","Pagkadogay kaiza napatay ya pobri. Kamhan indara iza na mga tagalangit nga sogoonon na Diyos ngandaked ka hel-anan ni Abraham nga karaang propita. Kamhan napatay disab ya kowartahan. Kamhan inlebeng. ");
INSERT INTO mmn_vpl VALUES ("LK16_23","072_16_23","LUK","16","23","23","Baba ka inpirno min-anget iza ka masarang kasakit. Paghangad ka naiza nakakita iza kan Abraham doro ka aro daw si Lazaro dizan ka tepad naiza. ");
INSERT INTO mmn_vpl VALUES ("LK16_24","072_16_24","LUK","16","24","24","Kamhan minsinggit ya kowartahan nga apo Abraham! Kaloy-i intawon hao. Magsogo ko kan Lazaro dazaw patignawan ya kanaong dila ka sapa kay masakit gazed ya kanaong lawas dini ka masarang karangka nga laga. ");
INSERT INTO mmn_vpl VALUES ("LK16_25","072_16_25","LUK","16","25","25","Minsambag si Abraham nga daw makataremdem iko nga ka paghela pen mo dimbaba ka kalibotan madazaw gazed ya kahimtang mo piro dakola ya kalised ni Lazaro. Kamhan naloy-an si Lazaro dini kanao koman piro mangarohoy iko ka masarang kasakit. ");
INSERT INTO mmn_vpl VALUES ("LK16_26","072_16_26","LUK","16","26","26","Diri mahimo ya pagkaro ni Lazaro kanmo kay dizan ka tenga na kanaming dapit daw ya kanmong dapit may bonggawa nga haloag. Kamhan diri makadateng ya taga dindaked ngambaba kamazo. Bisan ya mga taga dimbaba diri siran makadateng dindaked. ");
INSERT INTO mmn_vpl VALUES ("LK16_27","072_16_27","LUK","16","27","27","Kamhan minhangzo ya kowartahan nga Apo, kon somogot ko pakarohen mo si Lazaro ka lagkaw na kanaong ama. ");
INSERT INTO mmn_vpl VALUES ("LK16_28","072_16_28","LUK","16","28","28","Kay limang bolos ya kanaong mga manghod doro. Kamhan pakahagdamen mo siran nga maonga ini nga datnganan nao dazaw maregda siran kay basi andateng siran dimbaba ka masarang kapaso. ");
INSERT INTO mmn_vpl VALUES ("LK16_29","072_16_29","LUK","16","29","29","Minsambag si Abraham nga mahagdam siran ka kasogoan nga impasoyat na Diyos kan Moysis daw ya mga karaang propita. Kontana tomanen niran iton. ");
INSERT INTO mmn_vpl VALUES ("LK16_30","072_16_30","LUK","16","30","30","Minsambag ya sapianan nga apo Abraham, diri siran antoman kaiton piro kon may mabohi pagbalik garing ka lebeng kamhan iza ya ambisita kaniran anhinelsel gazed siran ka kanirang mga sala. ");
INSERT INTO mmn_vpl VALUES ("LK16_31","072_16_31","LUK","16","31","31","Minsambag si Abraham nga kon diri siran antoo ka sindo ni Moysis daw ya mga karaang propita, diri gazed siran antoo ka tao bisan mabohi iza pagbalik garing ka lebeng. ");
INSERT INTO mmn_vpl VALUES ("LK17_1","072_17_1","LUK","17","1","1","Pagkakamhan kaiza minlaong si Hisos ka toong mga sakop nga magtimaan kamo kaini nga mataed gazed ya mga antintal kamazo dazaw ambiza kamo kanao. Kamhan ya tao nga magtintalay kamazo ka pagbiza kanao magalised gazed iza kay-an kay silotan gazed iza na Diyos pagdakola. ");
INSERT INTO mmn_vpl VALUES ("LK17_2","072_17_2","LUK","17","2","2","Madazaw kon ya bato nga galingan ibitay ka toong lieg kamhan itimbag iza ka dagat dazaw diri makapadazon ka pagtintal kamazo. Kamhan ya kalised naiza pagkalemes geramay iton ka kalised naiza kay-an garing ka pagsilot na Diyos kay mintintal iza ka tao nga bag-o pen minsakop kanao. ");
INSERT INTO mmn_vpl VALUES ("LK17_3","072_17_3","LUK","17","3","3","Agon magbantay kamo ka batasan mazo. Dizan ka kamazong lomon kan Kristo kon nakasazep ya isa bahegan mo iza. Kamhan kon anhinelsel iza pasaylohon mo iza. ");
INSERT INTO mmn_vpl VALUES ("LK17_4","072_17_4","LUK","17","4","4","Bisan kon kapito iza makasazep kanmo ka isang aldaw kamhan kapito iza magpangazo ka pasaylo, pasaylohon mo iza. ");
INSERT INTO mmn_vpl VALUES ("LK17_5","072_17_5","LUK","17","5","5","Kamhan minlaong ya mga sinarigan ni Hisos nga Ginoo, dakolaen mo ya kanaming pagsarig kanmo dazaw diri kami dag-en ka pagtintal na mga maonga. ");
INSERT INTO mmn_vpl VALUES ("LK17_6","072_17_6","LUK","17","6","6","Minpamolinged si Hisos pagsambag kaniran nga bisan singed ka kontana ka liso na mostasa ka kageramay ya pagtoo mazo kanao mahimo ya pagsogo mazo ka liwaan nga sikomoro ka pagsibeg ngaro ka dagat. Kamhan antoman iton ka sogo mazo, bisan ararem gazed ya dinoltan na mga gamot. ");
INSERT INTO mmn_vpl VALUES ("LK17_7","072_17_7","LUK","17","7","7","Kamo nga may mga sogoonon, bisan kon nagatarabaho ya isang sogoonon mo dizan ka oma, bisan kon nagabantay iza ka kanmong mga karniro, pag-oli naiza ka pagkadelem daw ono ya batasan mo? Diri ko ampakaen kanangiza paghon-a kanmo ");
INSERT INTO mmn_vpl VALUES ("LK17_8","072_17_8","LUK","17","8","8","kay ansogo hinoa nga magsen-ad ko naa kanao. Mag-ilis ko ka bado mo kay lamisahan mo hao ka kanaong panihapon. Ani ini ya sogo mo kamhan kon makakamhan iko pagkaen anipen kon ampanihapon iza sonod kanmo. ");
INSERT INTO mmn_vpl VALUES ("LK17_9","072_17_9","LUK","17","9","9","Bisan antoman ya sogoonon ka tanan mga sogo mo wara ko maglaong nga madazaw iza kay kanmong tarabahanti ka lamang iza. ");
INSERT INTO mmn_vpl VALUES ("LK17_10","072_17_10","LUK","17","10","10","Kamo nga kanaong mga sinarigan, singed kamo kaiton nga sogoonon. Agon kon makakamhan kamo pagtoman ka tanan mga sogo na Diyos kamazo, diri kamo maghena-hena nga kontana sazaen kamo na Diyos. Hinoa maglaong kamo nga mga sogoonon kami na Diyos nga nagatoman lamang ka kanaming katengdanan. ");
INSERT INTO mmn_vpl VALUES ("LK17_11","072_17_11","LUK","17","11","11","Pagpasinged pen ni Hisos ngaro ka Hirosalem min-azi iza dizan ka eltanan ka lopa nga Samariya daw ya lopa nga Galiliya. ");
INSERT INTO mmn_vpl VALUES ("LK17_12","072_17_12","LUK","17","12","12","Pag-azi pen naiza dizan ka isang bariyo ya mga tao nga kagiden nga napolo sirang tanan ani ya minsogat kanangiza. Kamhan mintindeg siran dizan ka aroaro kay diri siran ampaarani ka mga tao kay kagiden sa siran. ");
INSERT INTO mmn_vpl VALUES ("LK17_13","072_17_13","LUK","17","13","13","Kamhan nanhawag di siran kan Hisos, Maistro, kaloy-i intawon kami! ");
INSERT INTO mmn_vpl VALUES ("LK17_14","072_17_14","LUK","17","14","14","Pagpakakita ka ni Hisos kaniran minsogo iza kaniran ka pagpakita ka kanirang mga lawas ka mga pari. Ka nagapanaw pen siran ka pagtoman ka sogo ni Hisos nangadazaw matood ya kanirang mga lawas. ");
INSERT INTO mmn_vpl VALUES ("LK17_15","072_17_15","LUK","17","15","15","Pagpaniid ka na isang ka kagiden nga nadazaw di ya toong lawas minbalik iza dazon kan Hisos. Minbaskeg iza ka toong saba pagsaza naiza ka Diyos. ");
INSERT INTO mmn_vpl VALUES ("LK17_16","072_17_16","LUK","17","16","16","Kamhan minlohod iza dizan ka paahan ni Hisos ka pagpasalamat. Taga Samariya iza. Na, ya mga taga Samariya daw ya mga Yodayo diri siran magkaangay kamhan intamay na mga Yodayo ya mga taga Samariya kay diri kon mga kaliwatan siran ni Abraham. ");
INSERT INTO mmn_vpl VALUES ("LK17_17","072_17_17","LUK","17","17","17","Kamhan nangotana si Hisos nga daw diri kon napolo nga ka tao ya indazaw nao? Minkar-in sa ya mga Yodayo nga sizam siran nga ka tao? ");
INSERT INTO mmn_vpl VALUES ("LK17_18","072_17_18","LUK","17","18","18","Nabereng gazed hao kay ya isa nga diri kon Yodayo anikay minbalik kanao ka pagsaza ka Diyos. ");
INSERT INTO mmn_vpl VALUES ("LK17_19","072_17_19","LUK","17","19","19","Kamhan minlaong iza kaiton nga tao nga tomindeg ko naa. Omoli ko ngaro. Madazaw di ya lawas mo kay hao ya insarigan mo. ");
INSERT INTO mmn_vpl VALUES ("LK17_20","072_17_20","LUK","17","20","20","Pagkakamhan kaiza nangotana ya mga Parasiyo kan Hisos nga kon-o kon andateng ya pagkahari na Diyos dini ka kalibotan? Minsambag si Hisos nga waray timaan nga inpaseleng na Diyos kamazo. ");
INSERT INTO mmn_vpl VALUES ("LK17_21","072_17_21","LUK","17","21","21","Waray makapanaba nga dini di kon dizan di ya pagkahari na Diyos. Kay hao nga hari nga pinili na Diyos dini di hao kamazo. ");
INSERT INTO mmn_vpl VALUES ("LK17_22","072_17_22","LUK","17","22","22","Kamhan minlaong si Hisos ka toong mga sakop nga ka wara pen madogay gosto gazed kamo nga ambalik hao dini kamazo. Bisan isa kang ka aldaw ya pagbisita nao ansogot gazed kamo piro diri pen mahimo iton. ");
INSERT INTO mmn_vpl VALUES ("LK17_23","072_17_23","LUK","17","23","23","Kamhan kon anlaong ya mga tao kamazo nga doro di si Kristo kon dini di si Kristo, diri kamo magkaro. Diri kamo magsakop kaniran. ");
INSERT INTO mmn_vpl VALUES ("LK17_24","072_17_24","LUK","17","24","24","Kay ya pagdateng nao kay-an singed iton ka kilat nga magalapowasan dazon ya kalangitan garing ka sebazan ngaro ka salpan. ");
INSERT INTO mmn_vpl VALUES ("LK17_25","072_17_25","LUK","17","25","25","Kamhan ka wara pen dateng iton nga aldaw an-azi pen hao ka mga mataed nga kalised. Kamhan magasawazen hao na mga tao. ");
INSERT INTO mmn_vpl VALUES ("LK17_26","072_17_26","LUK","17","26","26","Kamhan ya batasan na mga tao kay-an ka pagbalik nao ngarini daw ya batasan na mga karaang tao ka bohi pen si Niwi mag-anika siran. ");
INSERT INTO mmn_vpl VALUES ("LK17_27","072_17_27","LUK","17","27","27","Kay kawandini pen ka wara pen dateng ya lenep nagapadazon ya mga tao pagpangaen daw pagpanginem daw pagpanminze keteb ka aldaw nga minseled sing Niwi ka arka. Kamhan mindateng matood ya lenep. Kamhan natibe siran pagpatay. ");
INSERT INTO mmn_vpl VALUES ("LK17_28","072_17_28","LUK","17","28","28","Kamhan ya batasan na mga tao kay-an ka pagbalik nao ngarini daw ya batasan na mga karaang tao ka bohi pen si Lot mag-anika siran. Kay nagapadazon siran pagpangaen daw pagpanginem daw pagpamaligza daw pagpamalit daw pagpananem daw pagpanhinang ka mga lagkaw ");
INSERT INTO mmn_vpl VALUES ("LK17_29","072_17_29","LUK","17","29","29","keteb ka aldaw ka pagpanaw ni Lot garing ka Sodoma nga maongang longsod. Kamhan minpaoran ya Diyos ka mga bato singed ka polbora nga masarang laga dimbaba ka longsod. Kamhan nangawara gazed ya mga tao nga imbilin dizan. ");
INSERT INTO mmn_vpl VALUES ("LK17_30","072_17_30","LUK","17","30","30","Anisab ya kahimtang na mga tao kay-an ka pagbalik nao dimbaba ka kalibotan. ");
INSERT INTO mmn_vpl VALUES ("LK17_31","072_17_31","LUK","17","31","31","Agon kon magahayahay kamo dizan ka pawa, dalagan gazed kamo kay waray logar mazo ka pagpanhipid ka kamazong mga betang. Bisan magatarabaho kamo daked ka kamazong oma, diri kamo magbalik ka kamazong lagkaw. ");
INSERT INTO mmn_vpl VALUES ("LK17_32","072_17_32","LUK","17","32","32","Magtaremdem kamo ka asawa ni Lot kay kawandini pen imbaloy iza kay minlingi iza paglayas pen naiza dizan ka longsod nga Sodoma. ");
INSERT INTO mmn_vpl VALUES ("LK17_33","072_17_33","LUK","17","33","33","Kon bizaan na tao ya pagtoo naiza kay basi patazen iza, diri iza mahatagan ka bag-ong kinabohi nga diri mawara. Kon patazen ya tao kay mintoo iza kanao, mahatagan iza ka bag-ong kinabohi nga diri mawara. ");
INSERT INTO mmn_vpl VALUES ("LK17_34","072_17_34","LUK","17","34","34","Sabten mazo nga ya kahabzena nga tirmino nao ka pagbalik ngarimbaba matorog ya dowang ka tao. Kamhan ya isa ibahen nao piro ya isa ibilin. ");
INSERT INTO mmn_vpl VALUES ("LK17_35","072_17_35","LUK","17","35","35","Magagaling sab ya dowang ka babazi ka mais. Kamhan ibahen nao ya isa piro ya isa ibilin. ");
INSERT INTO mmn_vpl VALUES ("LK17_36","072_17_36","LUK","17","36","36","Magatarabaho sab ya dowang ka tao doro ka oma. Kamhan ibahen nao ya isa piro ya isa ibilin. ");
INSERT INTO mmn_vpl VALUES ("LK17_37","072_17_37","LUK","17","37","37","Kamhan nangotana ya toong mga sakop nga Ginoo, daw hain ya dapit nga madateng na tanan impanaba mo? Minsambag si Hisos kaniran nga bisan sin-o ya maongang batasan nga tao silotan gazed iza. Singed iton ka pamolinged nga bisan hain ya lawas nga patay magatiponon na mga agila ka pagtoktok ka mga onod. ");
INSERT INTO mmn_vpl VALUES ("LK18_1","072_18_1","LUK","18","1","1","Pagkakamhan kaiza minpamolinged si Hisos ka toong mga sakop dazaw diri siran magmaloza ka pagpangamozo ka Diyos basta magapadazon hangtod ka pagsambag naiza kaniran. ");
INSERT INTO mmn_vpl VALUES ("LK18_2","072_18_2","LUK","18","2","2","Minlaong si Hisos nga simpan doro ka isang longsod may isang howis nga wara iza magtahod ka Diyos. Wara isab iza magtabang ka tao. ");
INSERT INTO mmn_vpl VALUES ("LK18_3","072_18_3","LUK","18","3","3","Kamhan may balo nga babazi dizan ka longsod nga nagabalikbalik ka howis kay nagapakilooy nga nagalaong nga tabangan mo hao kay may nakaangken-angken ka irinsiya nao. ");
INSERT INTO mmn_vpl VALUES ("LK18_4","072_18_4","LUK","18","4","4","Kamhan wara magtabang. Pagkateedteed minlaong ya howis ka toong hena-hena nga bisan waray labet nao ka Diyos daw mga tao ");
INSERT INTO mmn_vpl VALUES ("LK18_5","072_18_5","LUK","18","5","5","madazaw kon silotan nao ya kaaway naiton nga babazi nga masamok dini kanao. Kay diri hao makaanget ka toong pagbalikbalik dini kanao. ");
INSERT INTO mmn_vpl VALUES ("LK18_6","072_18_6","LUK","18","6","6","Ani ini ya pamolinged ka batasan na maongang howis. ");
INSERT INTO mmn_vpl VALUES ("LK18_7","072_18_7","LUK","18","7","8","Kamhan madazaw pen gazed ya pagtabang na Diyos ka toong mga pinili nga mga sakop kay diri iza an-alang-alang ka pagtabang kaniran singed ka maongang howis. Sabten mazo nga silotan na Diyos pagdali ya mga kaaway na toong mga kasakopan nga nagapakilooy aldaw daw kahabzen. Kamhan kay-an ka pagdateng nao daw may mga antoo kanao dini ka kalibotan? ");
INSERT INTO mmn_vpl VALUES ("LK18_9","072_18_9","LUK","18","9","9","Pagkakamhan ni Hisos pagpanaba kaniran dizan disab ya mga tao nga silaong niran nga waray sala niran. Intamay sab niran ya mga iba nga tao. Agon minpamolinged si Hisos pagpook kaniran nga nagalaong nga ");
INSERT INTO mmn_vpl VALUES ("LK18_10","072_18_10","LUK","18","10","10","may dowang ka tao nga minseled ka dakolang lagkaw nga pangamozoanan ka Diyos. Ya isa Parasiyo. Ya iba magsokotay ka bohis. ");
INSERT INTO mmn_vpl VALUES ("LK18_11","072_18_11","LUK","18","11","11","Kamhan mintindeg ya Parasiyo kay garboso iza pagpangamozo naiza ka Diyos nga nagalaong nga Diyos, salamat kay madazaw hao ka mga iba nga tao. Kay siran ya angamit ka kanirang katenged ka pagdogang ka kowarta, mga bakaken siran, mga maghehenay siran. Bisan ya magsokotay ka bohis nga nagatindeg dizan, madazaw hao kanangiza kay in-oswagan naiza ya bohis. ");
INSERT INTO mmn_vpl VALUES ("LK18_12","072_18_12","LUK","18","12","12","Kamhan kada simana ikadowa ya pag-anget nao ka pagkaen. Kamhan nagahatag hao kanmo ka ikanapolo nga ka bahin na tanan panapi nao. Ani ini ya pagpagarbo na Parasiyo ka pagpangamozo naiza ka Diyos. ");
INSERT INTO mmn_vpl VALUES ("LK18_13","072_18_13","LUK","18","13","13","Kamhan nagatindeg ya magsokotay ka bohis dizan ka kilid na singbahan. Masipeg iza ka paghangad ka langit ka pagpangamozo ka Diyos kay mahagdam iza nga salaan iza nga tao. Kamhan indanegdaneg naiza ya toong debdeb ka paghinelsel ka toong mga sala. Kamhan minlaong iza nga O Diyos, kaloy-an mo hao kay mataed gazed ya kanaong mga sala. ");
INSERT INTO mmn_vpl VALUES ("LK18_14","072_18_14","LUK","18","14","14","Kamhan napasaylo matood iza na Diyos. Piro ya Parasiyo diri mapasaylo. Kay bisan sin-o ya ampalabaw ka toong kaogaringen singed ka Parasiyo ipaebes gazed iza na Diyos. Kamhan bisan sin-o ya ampaebes ka toong kaogaringen singed ka magsokotay ka bohis ipalabaw iza na Diyos. ");
INSERT INTO mmn_vpl VALUES ("LK18_15","072_18_15","LUK","18","15","15","Pagkakamhan kaiza may mga mindara ka kanirang mga maimpisay dizan kan Hisos kay ipadampa siran kanangiza dazaw panaranginan ka madazaw. Piro inkasab-an siran na mga sakop ni Hisos. ");
INSERT INTO mmn_vpl VALUES ("LK18_16","072_18_16","LUK","18","16","16","Minsambag iza nga diri kamo magbaheg kaniran. Pakarinihen mazo siran kanao kay ya singed kaniran ani ya in-angay na Diyos. ");
INSERT INTO mmn_vpl VALUES ("LK18_17","072_18_17","LUK","18","17","17","Timan-an mazo gazed ini nga kon diri kamo ansarig ka Diyos singed ka pagsarig na bata ka toong ama diri kamo iangay na Diyos. ");
INSERT INTO mmn_vpl VALUES ("LK18_18","072_18_18","LUK","18","18","18","Pagkakamhan kaiza minkarini kan Hisos ya isang oloolo na mga Yodayo. Kamhan nangotana iza nga Madazaw nga Maistro, daw ono ya hinangen o nga madazaw dazaw tagan hao ka kinabohi nga diri mawara? ");
INSERT INTO mmn_vpl VALUES ("LK18_19","072_18_19","LUK","18","19","19","Minsambag si Hisos nga kay ono sang anngaran sa ko kanao nga madazaw? Ya Diyos kay madazaw. ");
INSERT INTO mmn_vpl VALUES ("LK18_20","072_18_20","LUK","18","20","20","Mahagdam ko daan ka mga kasogoan na Diyos nga azaw maghenay, azaw magpatay ka tao, azaw pangawat, azaw pamakak, magtahod ko ka kanmong ama daw ina. ");
INSERT INTO mmn_vpl VALUES ("LK18_21","072_18_21","LUK","18","21","21","Minsambag ya tao nga sokad ka batan-en pen hao nagatoman hao kaiton nga tanan mga sogo. ");
INSERT INTO mmn_vpl VALUES ("LK18_22","072_18_22","LUK","18","22","22","Pagpakabati ka ni Hisos ka toong sambag minsambag iza nga isa koman ya kolang mo. Omoli ko naa ngaro ka lagkaw mo. Kamhan ipamaligza mo ya mga betang mo. Kamhan ya bazad ipanhatag ka mga pobri. Anipen ko kon somakop kanao dazaw sobra pen ya mga mahalen mo daked ka hel-anan na Diyos. ");
INSERT INTO mmn_vpl VALUES ("LK18_23","072_18_23","LUK","18","23","23","Pagpakabati ka na tao ka panaba ni Hisos nagalised ya toong hinawa kay diri kontana naiza ibaligza ya toong mga betang. ");
INSERT INTO mmn_vpl VALUES ("LK18_24","072_18_24","LUK","18","24","24","Pagseleng ni Hisos kanangiza minlaong iza nga ya mga tao nga kowartahan malised gazed ya pagsakop niran ka Diyos. ");
INSERT INTO mmn_vpl VALUES ("LK18_25","072_18_25","LUK","18","25","25","Pamolinged ini nga ya karabaw kon an-azi ka teheb na dagem masazon iton ka pagsakop na kowartahan ka Diyos kay wili ya toong hena-hena ka toong kowarta. ");
INSERT INTO mmn_vpl VALUES ("LK18_26","072_18_26","LUK","18","26","26","Kamhan minsambag ya mga nakabati nga kon malised ya pagsakop na kowartahan ka Diyos diri baza makalangit ya bisan sin-o nga tao. ");
INSERT INTO mmn_vpl VALUES ("LK18_27","072_18_27","LUK","18","27","27","Minsambag si Hisos nga kon ya tao ka lamang diri makahimo piro ya Ginoo makahimo iza ka tanan. ");
INSERT INTO mmn_vpl VALUES ("LK18_28","072_18_28","LUK","18","28","28","Kamhan minlaong si Pidro kan Hisos nga kami nga kanmong mga sinarigan izang dini kaini minbiza kami ka kanaming hel-anan dazaw makasakop kami kanmo. ");
INSERT INTO mmn_vpl VALUES ("LK18_29","072_18_29","LUK","18","29","29","Minsambag si Hisos nga magtimaan kamo kaini nga ya tao nga minsakop kanao pasobrahan na Diyos ka pagbales ka magazon. Kay minbiza iza ka toong hel-anan daw asawa daw mga lomon daw ginikanan daw mga bata kay dazaw anwali iza ka sindo mahitenged kanao. ");
INSERT INTO mmn_vpl VALUES ("LK18_30","072_18_30","LUK","18","30","30","Pasobrahan matood na Diyos ya pagbales ka madazaw kaini nga tao koman nga panahon. Tagan sab iza ka bag-ong kinabohi daked ka Diyos kawanihen ka. ");
INSERT INTO mmn_vpl VALUES ("LK18_31","072_18_31","LUK","18","31","31","Kamhan impalain pagpatindeg ni Hisos ya toong mga sinarigan nga napolo may dowa siran. Kamhan minlaong iza kaniran nga mamanaw di kita ngaro ka siyodad nga Hirosalem. Kamhan matoman gazed ya tanan mga insoyat kanao na mga karaang propita na Diyos. ");
INSERT INTO mmn_vpl VALUES ("LK18_32","072_18_32","LUK","18","32","32","Kay doro kaiton nga dapit hao nga minhon-a ka bisan sin-o nga mahon-ang tao, iated hao doro ka mga diri kon Yodayo nga nagahari dini ka kantang lopa. Kamhan pagasorasorahen hao niran daw magapanelban. ");
INSERT INTO mmn_vpl VALUES ("LK18_33","072_18_33","LUK","18","33","33","Pagkakamhan niran paglatos kanao patazen hao niran. Pagdateng ka ikatolong aldaw sokad ka kanaong pagkapatay mabohi hao pagbalik garing ka lebeng. ");
INSERT INTO mmn_vpl VALUES ("LK18_34","072_18_34","LUK","18","34","34","Kamhan wara makasabot ya mga sinarigan ni Hisos. Wara niran masabti ya kahologan na toong impanaba kaniran kay singed ka intago sa. ");
INSERT INTO mmn_vpl VALUES ("LK18_35","072_18_35","LUK","18","35","35","Ka hapit di andateng si Hisos ka longsod nga Hiriko dizan ka kilid na karsada may nagalo-to nga isang nabota nga mang-azoay. ");
INSERT INTO mmn_vpl VALUES ("LK18_36","072_18_36","LUK","18","36","36","Pagpakabati ka naiza ka mga mataed nga tao nga minlabay dizan nangotana iza ka mga tao kon namag-ono sa siran dini kaini? ");
INSERT INTO mmn_vpl VALUES ("LK18_37","072_18_37","LUK","18","37","37","Minsambag siran nga nagalabay di si Hisos nga taga Nazarit. ");
INSERT INTO mmn_vpl VALUES ("LK18_38","072_18_38","LUK","18","38","38","Kamhan minsinggit ya nabota nga Ginoo nga kaliwat ni Dabid, kaloy-an mo hao! ");
INSERT INTO mmn_vpl VALUES ("LK18_39","072_18_39","LUK","18","39","39","Kamhan ya mga tao nga minhon-a kan Hisos pagpanaw minbaheg siran ka nabota nga nagalaong nga magpahenek di ko! Kamhan mintoda hinoa iza pagsinggit nga Ginoo nga kaliwat ni Dabid, kaloy-i intawon hao! ");
INSERT INTO mmn_vpl VALUES ("LK18_40","072_18_40","LUK","18","40","40","Pagpakabati ka ni Hisos minheneng iza dizan daw minsogo ka mga tao nga pakarinihen mazo iza. Pagdateng ka na nabota nangotana si Hisos nga ");
INSERT INTO mmn_vpl VALUES ("LK18_41","072_18_41","LUK","18","41","41","daw ono ya gosto mo kanao? Minsambag ya nabota nga Nong, ya gosto nao nga makakita kontana ya kanaong mata. ");
INSERT INTO mmn_vpl VALUES ("LK18_42","072_18_42","LUK","18","42","42","Minsambag si Hisos nga madazaw di ya mata mo kay hao ya insarigan mo. ");
INSERT INTO mmn_vpl VALUES ("LK18_43","072_18_43","LUK","18","43","43","Kamhan madazaw matood ya toong mata. Min-iba iza kan Hisos paglargo. Nagapasalamat gazed iza ka Diyos. Bisan ya tanan mga tao nagasaza siran ka Diyos kay minkita siran nga madazaw di ya nabota. ");
INSERT INTO mmn_vpl VALUES ("LK19_1","072_19_1","LUK","19","1","1","Pagkakamhan min-azi si Hisos ka longsod nga Hiriko. ");
INSERT INTO mmn_vpl VALUES ("LK19_2","072_19_2","LUK","19","2","2","Kamhan may isang tao dizan nga si Zakiyas ya ngaran. Oloolo iza na mga magsokotay ka bohis kamhan nakowartahan di iza. ");
INSERT INTO mmn_vpl VALUES ("LK19_3","072_19_3","LUK","19","3","3","Ankita kontana iza kon sin-o sa si Hisos piro ababa ya toong lawas agon imbalabagan iza na mga tao nga minlibot kan Hisos. ");
INSERT INTO mmn_vpl VALUES ("LK19_4","072_19_4","LUK","19","4","4","Kamhan mindalagan iza ngaro ka hon-ahan kay anpanik iza ka liwaan nga sikamoro dazaw makakita iza kan Hisos paglabay naiza dizan ka dalan. ");
INSERT INTO mmn_vpl VALUES ("LK19_5","072_19_5","LUK","19","5","5","Pagpakatenged ka ni Hisos dizan ka liwaan minhangad iza ngandaked. Kamhan minpanaba iza kan Zakiyas nga Zakiyas, magtena ko pagdali kay ambisita hao ka kanmong lagkaw koman nga aldaw. ");
INSERT INTO mmn_vpl VALUES ("LK19_6","072_19_6","LUK","19","6","6","Mintena dazon si Zakiyas. Dakola ya toong kasaza ka pagpaiba naiza kan Hisos dizan ka toong lagkaw. ");
INSERT INTO mmn_vpl VALUES ("LK19_7","072_19_7","LUK","19","7","7","Kamhan ya tanan nakakita kaiton minmahay siran nagalaong nga iton nga taohana minbisita baza iza ka lagkaw na salaan nga tao. ");
INSERT INTO mmn_vpl VALUES ("LK19_8","072_19_8","LUK","19","8","8","Kamhan dizan kan Hisos mintindeg si Zakiyas daw minlaong nga Ginoo, gosto hao magapanhatag ka katenga na kanaong mga betang dizan ka mga pobri. Kamhan dizan ka bisan sin-o ya in-oswagan nao ka bohis palabwan nao ka opat ya bazad nao kaniran. ");
INSERT INTO mmn_vpl VALUES ("LK19_9","072_19_9","LUK","19","9","9","Minsambag si Hisos nga koman nga aldaw dini ka tanan inhel-an mo mahatagan na Diyos ka bag-ong kinabohi nga diri mawara kay mintoo iko ka kanaong mga panaba. Kamhan iko ya matood nga kaliwat ni Abraham kay matood ya pagtoo mo ka Diyos singed ka pagtoo ni Abraham. ");
INSERT INTO mmn_vpl VALUES ("LK19_10","072_19_10","LUK","19","10","10","Minpanaba hao kanmo kaini kay ya tood nao dini ka kalibotan pangitan nao ya mga salaan nga tao kay tabangan nao siran dazaw malibri siran ka silot ka kanirang mga sala. ");
INSERT INTO mmn_vpl VALUES ("LK19_11","072_19_11","LUK","19","11","11","Pagkakamhan kaiza arani di si Hisos ka siyodad nga Hirosalem. Kamhan minlaong ya mga tao nga ka wara pen madogay antabang si Hisos kanta ka pagpaiwat ka mga taga Roma dini kanta dazaw iza ya anhari ka kantang hel-anan. Kamhan minpamolinged si Hisos kaniran nga ");
INSERT INTO mmn_vpl VALUES ("LK19_12","072_19_12","LUK","19","12","12","nagalaong nga ya batasan nao kay-an ka pagbalik nao ka paghari ka mga tao dini ka kalibotan singed iton ka isang tao nga maanak iza na labaw nga hari. Kamhan minpanaw iza doro ka aro kay dawaten naiza ya katenged ka paghari ka hel-anan na toong kaibahan. ");
INSERT INTO mmn_vpl VALUES ("LK19_13","072_19_13","LUK","19","13","13","Ka wara pen iza magpanaw impanipon naiza ya napolong ka sogoonon dazaw isarig kaniran ya toong kowarta dazaw dogangan niran iton. Kada isang sogoonon insarigan ka sinto pisos. Kamhan minsogo iza kaniran nga nagalaong nga hangtod ka pagbalik nao gamiten mazo ini nga kowarta dazaw madogangan iton. ");
INSERT INTO mmn_vpl VALUES ("LK19_14","072_19_14","LUK","19","14","14","Kamhan ya mga kaibahan naiton nga tao impahon-a niran ya kanirang sinogo doro ka labaw nga hari kay ipakahagdam nga diri kami ansogot nga ini nga tao ani ya anhari kanami. ");
INSERT INTO mmn_vpl VALUES ("LK19_15","072_19_15","LUK","19","15","15","Pagkadogay kaiza min-oli ya tao kay intagan di iza ka katenged ka paghari ka hel-anan na toong kaibahan. Kamhan impakarini naiza ya toong mga sogoonon nga insarigan ka kowarta kay ansosi iza kon pira ya nasobra ka toong kowarta. ");
INSERT INTO mmn_vpl VALUES ("LK19_16","072_19_16","LUK","19","16","16","Kamhan mindateng ya isa kay anlaong iza nga Sinyor, ya kanmong kowarta nga sinto pisos min-anak di ka isang ka libo. ");
INSERT INTO mmn_vpl VALUES ("LK19_17","072_19_17","LUK","19","17","17","Minsambag ya hari nga madazaw iko. Masarigan iko ka geramay nga kowarta agon isarig pen nao kanmo ya katenged ka pagkagobirnador ka napolong ka longsod. ");
INSERT INTO mmn_vpl VALUES ("LK19_18","072_19_18","LUK","19","18","18","Kamhan mindateng ya ikadowang sogoonon. Minlaong iza nga Sinyor, ya kanmong kowarta nga sinto pisos min-anak di ka kinintos. ");
INSERT INTO mmn_vpl VALUES ("LK19_19","072_19_19","LUK","19","19","19","Minsambag ya hari nga isarig pen nao kanmo ya katenged ka pagkagobirnador ka limang ka longsod. ");
INSERT INTO mmn_vpl VALUES ("LK19_20","072_19_20","LUK","19","20","20","Kamhan mindateng ya ikatlong sogoonon. Nagabaribad iza ka hari nagalaong nga Sinyor, wani ya insarig mo kanao nga impotos gazed sokad ka pagpanaw mo ");
INSERT INTO mmn_vpl VALUES ("LK19_21","072_19_21","LUK","19","21","21","kay nahaldek hao kanmo kay nahagdam di hao nga waray kalooy mo. An-ani iko dizan ka wara mo itanem. Anhipes iko dizan ka wara mo ipegas. ");
INSERT INTO mmn_vpl VALUES ("LK19_22","072_19_22","LUK","19","22","22","Minsambag ya hari nga maonga iko. Ya saba mo kanao anikay anhokom kanmo. Kon matood ya baribad mo nga an-ani hao ka wara nao itanem daw anhipes hao dizan ka wara nao ipegas ");
INSERT INTO mmn_vpl VALUES ("LK19_23","072_19_23","LUK","19","23","23","kay ono sa nga wara ko magbetang ka kanaong kowarta dizan ka bangko dazaw may anak di koman pag-oli nao? ");
INSERT INTO mmn_vpl VALUES ("LK19_24","072_19_24","LUK","19","24","24","Kamhan minsogo ya hari ka mga sogoonon dizan nga kaw-en mo ya kowarta nga sinto pisos. Ihatag iton ka sogoonon nga may isang ka libo. ");
INSERT INTO mmn_vpl VALUES ("LK19_25","072_19_25","LUK","19","25","25","Minsambag siran nga Sinyor, isang ka libo gazed ya toong kowarta! ");
INSERT INTO mmn_vpl VALUES ("LK19_26","072_19_26","LUK","19","26","26","Minsambag ya hari nga sabten mazo nga kon masarigan ya tao ka mga insarig nao dizan kanangiza magadogangan pen gazed hao ya insarig nao kanangiza. Piro kon diri masarigan ya tao magakaw-en gazed nao kanangiza ya tanan mga insarig nao. ");
INSERT INTO mmn_vpl VALUES ("LK19_27","072_19_27","LUK","19","27","27","Kamhan ya kanaong kaibahan nga diri ansogot kanao nga haoy magahari kaniran iated siran ngarini kanao. Pamatazen siran dini ka pagseleng nao. ");
INSERT INTO mmn_vpl VALUES ("LK19_28","072_19_28","LUK","19","28","28","Pagkakamhan ni Hisos pagpanaba kaniran minpanaw iza ngaro ka Hirosalem paghon-a kaniran. ");
INSERT INTO mmn_vpl VALUES ("LK19_29","072_19_29","LUK","19","29","29","Pagpasinged naiza dizan mindateng di siran ka dowang ka bariyo nga Bitpahi daw Bitani dizan tenged ka bobong nga inngaranan ka Olibo. Kamhan minsogo si Hisos ka toong sinarigan nga dowa siran ");
INSERT INTO mmn_vpl VALUES ("LK19_30","072_19_30","LUK","19","30","30","nga nagalaong nga komaro kamo naa ka bariyo dizan ka hon-ahan mazo. Pagdateng ka mazo doro makakita kamo dazon ka isang batan-en pen nga asno nga klasi na kabayo nga in-ektan dizan. Sokad wara masakzi na tao. Hobaden mazo iton daw tozokon mazo ngarini kanao. ");
INSERT INTO mmn_vpl VALUES ("LK19_31","072_19_31","LUK","19","31","31","Kon may mangotana nga tao kamazo magsambag kamo nga inkinahanglan ini na kanaming oloolo. ");
INSERT INTO mmn_vpl VALUES ("LK19_32","072_19_32","LUK","19","32","32","Pagkakamhan ni Hisos pagsogo kaniran namanaw dazon sirang dowa. Kamhan nakitan niran ya kabayo singed ka inlaong ni Hisos kaniran. ");
INSERT INTO mmn_vpl VALUES ("LK19_33","072_19_33","LUK","19","33","33","Paghobad niran kaiton nangotana ya mga tag-iza nga onhon sa mazo iton nga kaw-en sa mazo ya kabayo? ");
INSERT INTO mmn_vpl VALUES ("LK19_34","072_19_34","LUK","19","34","34","Minsambag siran nga inkinahanglan ini na kanaming oloolo. ");
INSERT INTO mmn_vpl VALUES ("LK19_35","072_19_35","LUK","19","35","35","Kamhan intozok dazon niran dizan kan Hisos ya kabayo. Inhanigan sab niran ka kanirang mga bado ya likod na kabayo kay sakzan koman ni Hisos. ");
INSERT INTO mmn_vpl VALUES ("LK19_36","072_19_36","LUK","19","36","36","Pagpakasakay ka naiza inhanigan dazon ya dalan nga azihanan na kabayo ka mga bado na mga tao. ");
INSERT INTO mmn_vpl VALUES ("LK19_37","072_19_37","LUK","19","37","37","Pag-azi naiza ka dalan logsong ka bobong nga Olibo arani ka Hirosalem namagdengan ya toong mga sakop pagsaza ka Diyos kay madazaw gazed ya tanan mga hinang ni Hisos nga nakita niran. Kamhan mindakola siran ka kanirang saba pagsinggit nga ");
INSERT INTO mmn_vpl VALUES ("LK19_38","072_19_38","LUK","19","38","38","sazaen, sazaen kay iko ya mindateng garing ka Ginoo. Iko ya anhatag kanami ka kalinaw ka hinawa nga garing ka Diyos. Sazaen gazed ya Diyos nga pinakalabaw. ");
INSERT INTO mmn_vpl VALUES ("LK19_39","072_19_39","LUK","19","39","39","Kamhan ya mga Parasiyo dizan ka kataohan minlaong siran kan Hisos nga Maistro, papaheneken mo ya kanmong mga sakop. ");
INSERT INTO mmn_vpl VALUES ("LK19_40","072_19_40","LUK","19","40","40","Minsambag si Hisos nga timan-an gazed mazo ini nga kon anpahenek ya kanaong mga sakop ya mga bato dini ka dalan siran ya ansinggit pagsaza kanao. ");
INSERT INTO mmn_vpl VALUES ("LK19_41","072_19_41","LUK","19","41","41","Kamhan nakakita di si Hisos ka siyodad nga Hirosalem. Pagseleng naiza kaiton minhaza iza ");
INSERT INTO mmn_vpl VALUES ("LK19_42","072_19_42","LUK","19","42","42","daw minlaong nga kamo nga mga taga Hirosalem, koman nga aldaw madazaw kon makasabot kamo nga gosto hao antabang kamazo dazaw magakaangay kamo daw ya Diyos piro intawon diri kamo makasabot. ");
INSERT INTO mmn_vpl VALUES ("LK19_43","072_19_43","LUK","19","43","43","Andateng matood ya tirmino kon libotan kamo na kamazong mga kaaway. Libotan gazed kamo ka kanirang mga harominta ka paggira daw mga soldaw. Kamhan diri kamo makalayas. ");
INSERT INTO mmn_vpl VALUES ("LK19_44","072_19_44","LUK","19","44","44","Madalahig isab ya kamazong mga bata ka pagpangapatay iba mazong tanan. Pangebaen gazed ya kamazong kalagkawenan. Basta ya mga bato nga insompazan podo mabogto pagpangadeeg. Kay impakarini hao na Diyos dini kamazo piro wara kamo magkilala kanao. ");
INSERT INTO mmn_vpl VALUES ("LK19_45","072_19_45","LUK","19","45","45","Pagkakamhan kaiza minseled si Hisos ka dakolang lagkaw nga pangamozoanan ka Diyos. Kamhan impamogaw gazed naiza ya mga mamaligzaay. ");
INSERT INTO mmn_vpl VALUES ("LK19_46","072_19_46","LUK","19","46","46","Minlaong iza kaniran nga may daan pinasoyat na Diyos nga nagalaong nga ya kanaong lagkaw ani ya lagkaw ka pagpangamozo na mga tao kanao ambaza kay inhinang di mazo iton ka datnganan na mga tolisan nga nagapanlimbong ka mga tao. ");
INSERT INTO mmn_vpl VALUES ("LK19_47","072_19_47","LUK","19","47","47","Pagkakamhan kaiza aldaw-aldaw dizan ka dakolang lagkaw na Diyos nagasindo si Hisos ka mga tao. Kamhan patazen iza kontana na mga oloolo na mga pari daw ya mga maistro ka tinoohan na mga Yodayo daw ya mga oloolo na mga tao. ");
INSERT INTO mmn_vpl VALUES ("LK19_48","072_19_48","LUK","19","48","48","Piro waray logar niran kay ampanalinga gazed ya mga tao ka mga panaba ni Hisos. ");
INSERT INTO mmn_vpl VALUES ("LK20_1","072_20_1","LUK","20","1","1","May isang aldaw nagatoldo pen si Hisos ka mga tao dizan ka dakolang lagkaw na Diyos. Nagawali iza kaniran ka sindo nga garing ka Diyos. Kamhan may mga minkarini kanangiza nga mga oloolo na mga pari daw ya mga maistro ka tinoohan na mga Yodayo daw ya mga malaas. ");
INSERT INTO mmn_vpl VALUES ("LK20_2","072_20_2","LUK","20","2","2","Kay anlaong siran kan Hisos nga panabaen mo kami daw hain garing ya katenged mo ka pagbogaw ka mga tao kahabi? Daw sin-o ya minhatag kanmo ka katenged ka pagpadazon ka kanmong mga hinang dini kanami? ");
INSERT INTO mmn_vpl VALUES ("LK20_3","072_20_3","LUK","20","3","3","Minsambag si Hisos nga wani sab ya pangotana nao kamazo. Magsambag naa kamo. ");
INSERT INTO mmn_vpl VALUES ("LK20_4","072_20_4","LUK","20","4","4","Daw hain garing ya katenged ni Howan ka pagpamenzag ka mga tao? Daw garing iton ka Diyos kon garing iton ka tao? ");
INSERT INTO mmn_vpl VALUES ("LK20_5","072_20_5","LUK","20","5","5","Kamhan namagsabot siran kon ono sa kontana ya kanirang isambag. Namaglaong siran nga kon ansambag kita nga garing ka Diyos ya katenged ni Howan basi long-on kita ni Hisos nga kay ono sa nga diri sa kamo antoo kan Howan? ");
INSERT INTO mmn_vpl VALUES ("LK20_6","072_20_6","LUK","20","6","6","Piro kon ansambag kita nga garing ka tao ya katenged ni Howan pamookon kita na mga tao kay mintoo gazed siran nga si Howan ya matood nga propita na Diyos. ");
INSERT INTO mmn_vpl VALUES ("LK20_7","072_20_7","LUK","20","7","7","Kamhan minsambag siran kan Hisos nga wara kami mahagdam. ");
INSERT INTO mmn_vpl VALUES ("LK20_8","072_20_8","LUK","20","8","8","Kamhan minsambag isab si Hisos nga diri sab hao ampanan-og kamazo kon hain garing ya kanaong katenged ka pagpadazon ka kanaong mga inhinang. ");
INSERT INTO mmn_vpl VALUES ("LK20_9","072_20_9","LUK","20","9","9","Pagkakamhan ni Hisos pagsambag ka mga maistro minsogod iza pagpamolinged ka mga tao nga nagalaong nga may isang tao nga mintanem ka oma nga tamnanan ka mga obas. Kamhan nandapit iza ka mga saop. Kamhan minpanaw iza ngaro ka laing dapit. Dogay iza makaoli. ");
INSERT INTO mmn_vpl VALUES ("LK20_10","072_20_10","LUK","20","10","10","Pagkahapit di anihen ya mga obas impakaro naiza ya toong sogoonon kay pakaw-en di kontana naiza ka toong mga kabahinan. Kamhan pagdateng na sogoonon ka mga saop indakep hinoa niran. Kamhan imbonalan. Impaoli sab wara katagi. ");
INSERT INTO mmn_vpl VALUES ("LK20_11","072_20_11","LUK","20","11","11","Ka wara pen madogay insogo disab pagpakaro ya laing sogoonon. Piro imbonalan gihapon niran diri tahodon. Impaoli sab, wara katagi. ");
INSERT INTO mmn_vpl VALUES ("LK20_12","072_20_12","LUK","20","12","12","Kamhan insogo pen ya ikatlong sogoonon. Piro intigbas iza niran. Kamhan intimbag ngaro ka gawas. ");
INSERT INTO mmn_vpl VALUES ("LK20_13","072_20_13","LUK","20","13","13","Pagkakamhan kaiza minlaong ya tag-iza ka toong hena-hena nga an-ono sa hao koman? Pakarohen nao ya kanaong maanak nga naazakan kay tahodon gazed niran ya kanaong maanak. ");
INSERT INTO mmn_vpl VALUES ("LK20_14","072_20_14","LUK","20","14","14","Kamhan pagpakakita na mga sakop nga wani di kaan andateng di ya maanak na tag-iza namagsabot dazon siran nga waton di ngarini kanta ya maanak na tag-iza nga magdawatay kay-an kaini nga lopa nga toong irinsiya. Hala, pamagpatazen ta iza kay dazaw kita ka mazoy makapolos ka pagpanag-iza kaini nga lopa. ");
INSERT INTO mmn_vpl VALUES ("LK20_15","072_20_15","LUK","20","15","15","Kamhan impamagtagenan matood niran ya maanak. Intimbag niran ya toong lawas ngaro ka gawas na alad na tanem. Kamhan impamagpatay niran. Na, daw magaono sa koman ya tag-iza ka lopa kaniran? ");
INSERT INTO mmn_vpl VALUES ("LK20_16","072_20_16","LUK","20","16","16","Ankaro pen iza ka toong mga sakop kay patazen gazed naiza siran. Kamhan pasaopan naiza ya tanem ka lain. Pagpakabati ka niran ka inpamolinged ni Hisos minlaong siran nga porbida! ");
INSERT INTO mmn_vpl VALUES ("LK20_17","072_20_17","LUK","20","17","17","Minseleng si Hisos kaniran daw nangotana daw ono sa lamang ya daan pinasoyat na Diyos nga nagalaong nga ya matimgas nga bato nga inbizaan na mga minhinang ka lagkaw ani ya nahinang nga sinarigan ka pagparig-en ka primirong ogdok na lagkaw. ");
INSERT INTO mmn_vpl VALUES ("LK20_18","072_20_18","LUK","20","18","18","Bisan sin-o ya makadasmag kaiton nga matimgas nga bato mangabari ya toong bekeg. Kamhan bisan sin-o ya madateng naiton nga matimgas nga bato ka pagkaligid magemek gazed ya toong lawas. Kilalhen mazo nga ya dakolang matimgas nga bato nga inbizaan mazo ani hao. ");
INSERT INTO mmn_vpl VALUES ("LK20_19","072_20_19","LUK","20","19","19","Pagpakabati ka na mga maistro daw ya mga oloolo na mga pari nakasabot siran nga naigo siran ka pamolinged ni Hisos. Kamhan pamagdakpen niran kontana si Hisos piro nahaldek siran ka mga tao. ");
INSERT INTO mmn_vpl VALUES ("LK20_20","072_20_20","LUK","20","20","20","Kamhan inpaniidan gazed niran si Hisos. Impakaro sab niran ya mga iba nga Parasiyo kay magapatihinang ka beetan kay magalit-agen kontana si Hisos pagpanaba dazaw isombong iza doro ka gobirnador. ");
INSERT INTO mmn_vpl VALUES ("LK20_21","072_20_21","LUK","20","21","21","Kamhan nangotana siran kan Hisos nga Maistro, mahagdam kami nga madazaw ya pagsindo mo ka mga tao. Matood isab ya mga panaba mo. Bisan ono ya katenged na tao waray pinalabi mo pagsindo mo kaniran ka matood nga garing ka Diyos. ");
INSERT INTO mmn_vpl VALUES ("LK20_22","072_20_22","LUK","20","22","22","Na, panabaan mo kami. Daw makalapas kami ka balaed na mga Yodayo kon ambazad kami ka bohis dizan kan Sisar nga hari nga nakadaeg ka kantang lopa? Daw ambazad kami kon diri? ");
INSERT INTO mmn_vpl VALUES ("LK20_23","072_20_23","LUK","20","23","23","Na, mahagdam si Hisos nga daeten iza kontana agon minlaong iza kaniran nga ");
INSERT INTO mmn_vpl VALUES ("LK20_24","072_20_24","LUK","20","24","24","ipakita mo kanao ya isang palata nga kowarta. Kamhan nangotana iza nga daw kanin-ong bayho ini ka kowarta? Daw kanin-ong ngaran ya insoyat dini? Minsambag siran nga kan Sisar gazed iton. ");
INSERT INTO mmn_vpl VALUES ("LK20_25","072_20_25","LUK","20","25","25","Minsambag si Hisos nga bayri mazo ya azoon ni Sisar kamazo. Bayri sab mazo ya azoon na Diyos kamazo. ");
INSERT INTO mmn_vpl VALUES ("LK20_26","072_20_26","LUK","20","26","26","Kamhan minpahenek di lamang ya mga maistro kay nabereng siran kay waray sazep ni Hisos ka pagsambag kaniran dizan ka nabatian na mga tao. ");
INSERT INTO mmn_vpl VALUES ("LK20_27","072_20_27","LUK","20","27","27","Pagkakamhan kaiza minkarini disab kan Hisos ya mga maistro na mga Yodayo ani ngaran ya Sadosiyo. Ya kanirang toldoan ya mga namola di nga tao diri gazed mabohi pagbalik garing ka lebeng. ");
INSERT INTO mmn_vpl VALUES ("LK20_28","072_20_28","LUK","20","28","28","Na, nangotana siran kan Hisos nga Maistro, ya kanaming karaan nga si Moysis imbilinan sa kami ka soyat kay nagatogon kanami nga kon mapatay ya isang tao kamhan imbilin ya asawa piro waray maanak kinahanglan ya lomon na napatay anikay makapangasawa ka toong ipag nga nabalo di dazaw ampanganak. Kamhan mabohi ka ya ngaran na toong magorang nga napatay. Ani ini ya togon ni Moysis kanami. ");
INSERT INTO mmn_vpl VALUES ("LK20_29","072_20_29","LUK","20","29","29","Na, izang mahon-a pen may maglomon nga pitong ka amaama. Naminze di ya kamagorangan. Kamhan napatay di iza ka waray maanak. ");
INSERT INTO mmn_vpl VALUES ("LK20_30","072_20_30","LUK","20","30","30","Kamhan ya toong asawa nga nabalo di impangasawa na primirong manghod. Pagkakamhan kaiza napatay kasab ya primirong manghod nga waray maanak. ");
INSERT INTO mmn_vpl VALUES ("LK20_31","072_20_31","LUK","20","31","31","Singed kaiton ya kahimtang na ikadowang manghod keteb ka gipos-an. ");
INSERT INTO mmn_vpl VALUES ("LK20_32","072_20_32","LUK","20","32","32","Pagkahorot niran pagkapatay anipen mapatay ya babazi nga nabalo ka pitong ka maglomon. ");
INSERT INTO mmn_vpl VALUES ("LK20_33","072_20_33","LUK","20","33","33","Na, Maistro, wani ya pangotana nami kanmo kay mintoldo iko nga may tirmino ka pagbohi ka mga tao nga nangapatay. Daw kanin-ong asawa itong babazi kon mabohi pag-isab ya mga namagsonodsonod nga pitong ka maglomon kay iza ya asawa nirang tanan? ");
INSERT INTO mmn_vpl VALUES ("LK20_34","072_20_34","LUK","20","34","34","Minsambag si Hisos nga ya mga amaama daw babazi dini ka kalibotan magminzeay siran. ");
INSERT INTO mmn_vpl VALUES ("LK20_35","072_20_35","LUK","20","35","35","Piro ya mga madazaw nga tao nga inbohi na Diyos pagbalik kay-an garing ka lebeng diri di siran magminzeay. ");
INSERT INTO mmn_vpl VALUES ("LK20_36","072_20_36","LUK","20","36","36","Kay singed siran ka mga taga langit nga sogoonon na Diyos kay diri siran mapatay kawanihen ka. Agon waray kinahanglan ka pagpanganak kay anhela siran daked ka hel-anan na Diyos kay mga maanak di siran na Diyos. ");
INSERT INTO mmn_vpl VALUES ("LK20_37","072_20_37","LUK","20","37","37","Mahimo gazed ya pagpabohi na Diyos ka mga tao pagbalik garing ka lebeng. Kay bisan si Moysis nga karaang tao, minsoyat iza daan nga nagalaong nga izang mahon-a pen mintindeg iza dizan tenged ka sagbet nga dogihen nga nagalaga. Kamhan may nabatian naiza nga saba na Diyos nga garing ka sagbet nagalaong nga hao nga Diyos ani ya hawagenen na kamazong mga karaan nga si Abraham daw si Isak daw si Hakob. Ani ini ya impasoyat na Diyos. ");
INSERT INTO mmn_vpl VALUES ("LK20_38","072_20_38","LUK","20","38","38","Kamhan bisan patay di ya mga karaan magahawagen pen niran ya Diyos kay bohi ka siran daked. Kamhan iza ya Diyos na mga bohi nga tao, diri kon Diyos na mga patay. Kamhan dizan ka pagseleng na Diyos mabohi ya tanan mga tao, bisan patay di ya kanirang lawas. ");
INSERT INTO mmn_vpl VALUES ("LK20_39","072_20_39","LUK","20","39","39","Pagkakamhan ni Hisos pagpanaba kaniran minsambag ya mga maistro nga Maistro, madazaw gazed ya mga panaba mo. ");
INSERT INTO mmn_vpl VALUES ("LK20_40","072_20_40","LUK","20","40","40","Kamhan sokad kaiton wara gazed siran makasigi pagbalik pagpangotana kan Hisos. ");
INSERT INTO mmn_vpl VALUES ("LK20_41","072_20_41","LUK","20","41","41","Kamhan minlaong si Hisos kaniran pag-isab nga diri kon matood ya kamazong intoldo nga kaliwat ka lamang ni Dabid si Kristo. ");
INSERT INTO mmn_vpl VALUES ("LK20_42","072_20_42","LUK","20","42","42","Kay dizan ka mga daan insoyat ni Dabid inngaranan ka Salmo minngaran si Dabid kan Kristo nga toong Ginoo. Kay minlaong iza nga ya Diyos ani ya minpanaba ka kanaong Ginoo nga lomo-to ko naa dini ka kanaong too ");
INSERT INTO mmn_vpl VALUES ("LK20_43","072_20_43","LUK","20","43","43","hangtod ka pagpakadaeg nao ka kanmong mga kaaway. Ani ini ya daan mga panaba ni Dabid mahitenged kan Kristo nga hari nga pinili na Diyos. ");
INSERT INTO mmn_vpl VALUES ("LK20_44","072_20_44","LUK","20","44","44","Kamhan kon minngaran si Dabid kan Kristo nga toong Ginoo daw ono say toong pagkakaliwat ka lamang ni Dabid? ");
INSERT INTO mmn_vpl VALUES ("LK20_45","072_20_45","LUK","20","45","45","Kamhan minlaong si Hisos ka toong mga sakop dizan ka nabatian nga mga tao ");
INSERT INTO mmn_vpl VALUES ("LK20_46","072_20_46","LUK","20","46","46","nga maghamarag kamo ka batasan na mga maistro ka mga Yodayo. Kay ambado siran ka mga ataas nga bado. Kamhan an-azi siran dizan ka mirkado kay naazak gazed siran nga madazaw ya pag-abiabi na mga tao kaniran. Kada pagpista daw kada pagsingba naazak siran kon palo-toon siran ka magazong dapit. ");
INSERT INTO mmn_vpl VALUES ("LK20_47","072_20_47","LUK","20","47","47","Kamhan magapanlimbong sab siran ka mga balo nga babazi dazaw makaangken siran ka kanirang mga irinsiya. Kamhan magapaataasen niran ya kanirang pagpangamozo ka Diyos dazaw komoton niran ya kanirang mga sala. Agon pahamtangan siran na Diyos ka silot pagdakola ka silot naiza ka iba nga mga tao nga nakasala. ");
INSERT INTO mmn_vpl VALUES ("LK21_1","072_21_1","LUK","21","1","1","Pagpanaba pen ni Hisos ka toong mga sakop nakita naiza ya mga kowartahan nga minholog ka kanirang mga halad dizan ka betanganan ka kowarta nga ihaladay. ");
INSERT INTO mmn_vpl VALUES ("LK21_2","072_21_2","LUK","21","2","2","Nakita isab naiza ya isang balo nga babazi nga pobri nga minholog ka dos sintabos ka lamang. ");
INSERT INTO mmn_vpl VALUES ("LK21_3","072_21_3","LUK","21","3","3","Kamhan minlaong si Hisos nga timan-an mazo gazed ini nga ya dos sintabos nga inhatag naitong balo nga pobri labaw gazed iton ka inhatag na tanan mga iba nga tao. ");
INSERT INTO mmn_vpl VALUES ("LK21_4","072_21_4","LUK","21","4","4","Kay dakola pen ya kowarta niran piro nawara di gazed ya kowarta na babazi kay inhorot di naiza ka paghalad ya toong panginabohi. ");
INSERT INTO mmn_vpl VALUES ("LK21_5","072_21_5","LUK","21","5","5","Kamhan namaglaonglaong ya toong mga sinarigan mahitenged ka dakolang lagkaw nga pangamozoanan ka Diyos dizan ka Hirosalem kay madazaw selengan ya mga bato nga hininang daw ya mga arti nga intapil dizan ka dingding. Kamhan minlaong iza nga ");
INSERT INTO mmn_vpl VALUES ("LK21_6","072_21_6","LUK","21","6","6","madazaw matood itong singbahan piro mageba gazed kay-an. Basta ya mga bato nga insompazan podo mabogto pagpangadeeg. ");
INSERT INTO mmn_vpl VALUES ("LK21_7","072_21_7","LUK","21","7","7","Kamhan nangotana siran nga Maistro, kon-o kon mageba iton? Daw ono ya timaan kon antoman ya inpanaba mo kanami? ");
INSERT INTO mmn_vpl VALUES ("LK21_8","072_21_8","LUK","21","8","8","Minsambag si Hisos nga maghamarag kamo kay basi magalimbongan kamo kay mataed ya mga andateng nga ampasingedsinged siran kanao magaangken nga si Kristo hao. Anlaong sab siran nga matapos di gazed ya kalibotan kaan. Kamhan diri kamo magtoo kaniran. ");
INSERT INTO mmn_vpl VALUES ("LK21_9","072_21_9","LUK","21","9","9","Kon makabati kamo nga may ampakiggira nga arani di koni kamazo daw mataed ya mga ansopak ka gobirnador, diri kamo magkahaldek kay kinahanglan matoman iton piro diri pen kon ani ya kataposan nga panahon dini ka kalibotan. ");
INSERT INTO mmn_vpl VALUES ("LK21_10","072_21_10","LUK","21","10","10","Kay ka wara pen matapos ya kalibotan ampakig-away ya isang longsod ka laing longsod. Ampakig-away isab ya isang hari ka laing hari. ");
INSERT INTO mmn_vpl VALUES ("LK21_11","072_21_11","LUK","21","11","11","Kamhan madateng ya mga nagakalainlain dapit ka dakolang linog daw mga pihit daw mga kasakit. May mga mahangadan isab nga kaberenganan daked ka langit. ");
INSERT INTO mmn_vpl VALUES ("LK21_12","072_21_12","LUK","21","12","12","Ka wara pen dateng itong mga kalised, kamo nga kanaong mga sinarigan, dadhen kamo na mga tao dizan ka hokmanan bisan waray sala mazo. Kamhan dalem ka mga singbahan na mga Yodayo pamagbonalan kamo. Kamhan pirisohon kamo niran. Pansangilan gazed kamo niran dizan ka mga laing tao nga magahari ka lopa na mga Yodayo. Ani ini ya hinang niran kamazo kay hao ya insakopan mazo. ");
INSERT INTO mmn_vpl VALUES ("LK21_13","072_21_13","LUK","21","13","13","Kamhan panan-ogan mazo siran mahitenged kanao. ");
INSERT INTO mmn_vpl VALUES ("LK21_14","072_21_14","LUK","21","14","14","Ka wara pen kamo magtindeg dizan ka hokmanan diri kamo mag-andam daan kon ono ya isambag mazo kaniran ");
INSERT INTO mmn_vpl VALUES ("LK21_15","072_21_15","LUK","21","15","15","kay hao ya antandeg ka kamazong hena-hena. Kamham madazaw gazed ya impanaba mazo kaniran. Kamhan dizan ka mga kaaway mazo waray makasambag ka pagsopak kamazo. ");
INSERT INTO mmn_vpl VALUES ("LK21_16","072_21_16","LUK","21","16","16","Na, wani pen ya panan-og mahitenged ka batasan na mga tao kay-an. Dadhen kamo na mga ginikanan mazo daw ya mga lomon daw ya mga azok mazo dizan ka mga laing tao dazaw patazen kamo kamhan patazen ya mga isa kamazo. ");
INSERT INTO mmn_vpl VALUES ("LK21_17","072_21_17","LUK","21","17","17","Magakontarahan sab kamo na tanan mga tao kay hao ya insakopan mazo. ");
INSERT INTO mmn_vpl VALUES ("LK21_18","072_21_18","LUK","21","18","19","Kon diri kamo ambiza ka pagtoo mazo kanao keteb ka pagkatapos naitong mga kalised mahatagan kamo ka bag-ong kinabohi nga diri mawara. Bisan ya isang ka legas nga bohok mazo diri magkasonog baba ka impirno. ");
INSERT INTO mmn_vpl VALUES ("LK21_20","072_21_20","LUK","21","20","20","Na, impanan-ogan pen ni Hisos ya toong mga sinarigan mahitenged ka mga masiet nga kalised nga andateng kay-an. Nagalaong iza nga pagpakakita mazo nga inlibotan di ya siyodad nga Hirosalem na mga mataed nga soldaw, mahagdam kamo nga ka diri pen madogay madaeg gazed itong siyodad. ");
INSERT INTO mmn_vpl VALUES ("LK21_21","072_21_21","LUK","21","21","21","Kamhan kamo nga mga taga Yoda mandalagan gazed kamo ngaro ka bobong. Kamo nga nagahela ka Hirosalem, magbakwit kamo. Kamo nga nagahela doro ka aroaro, diri di kamo magbalik ka Hirosalem. ");
INSERT INTO mmn_vpl VALUES ("LK21_22","072_21_22","LUK","21","22","22","Kay tirmino di ini ka pagsilot na Diyos ka mga taga Hirosalem kay matoman di ya tanan mga panaba na Diyos nga impasoyat ka mga karaang propita. ");
INSERT INTO mmn_vpl VALUES ("LK21_23","072_21_23","LUK","21","23","23","Kalooy adaw na mga kabdes daw ya mga may pinasoso kay magalised siran ka pagdalagan. Nagalised matood ya tanan mga taga kalibotan. Nazehet gazed ya Diyos ka mga taga Yoda. ");
INSERT INTO mmn_vpl VALUES ("LK21_24","072_21_24","LUK","21","24","24","Pagarisen ya mga mataed nga tao. Kamhan pamihagen ya mga imbilin nga tao doro ka bisan hain ya dapit dini ka kalibotan. Madaeg gazed ya Hirosalem na mga tao nga diri kon Yodayo. Kamhan siran ya magahari dizan keteb ka pagtirmino na Diyos kaniran. ");
INSERT INTO mmn_vpl VALUES ("LK21_25","072_21_25","LUK","21","25","25","Nagapadazon si Hisos pagsindo kaniran nagalaong nga ya pagkatiwas na mga masiet nga kalised kay-an maonga nga hangden ya sega daw bolan daw mga bitoon. Kamhan magalised gazed ya mga taga kalibotan kay nahaldek siran kay ya mga maonga nga inhinang na mga tao singed iton ka pagdagook na dakolang baled na dagat ka pagbagzo. ");
INSERT INTO mmn_vpl VALUES ("LK21_26","072_21_26","LUK","21","26","26","Ingetasan ya mga tao ka pagkawied kon ono pen ya kalised kay nalaag di ka dalan ya mga bitoon daw bolan daw sega. ");
INSERT INTO mmn_vpl VALUES ("LK21_27","072_21_27","LUK","21","27","27","Anipen makita hao na mga tao kay domatengay hao iba ya gabon. Labaw gazed hao ka gahem daw madazaw selengan. ");
INSERT INTO mmn_vpl VALUES ("LK21_28","072_21_28","LUK","21","28","28","Kon domateng iton nga impanan-og nao kamazo maghangad kamo, magsaza kamo kay ka wara pen madogay ambalik hao ngarimbaba ka kalibotan. ");
INSERT INTO mmn_vpl VALUES ("LK21_29","072_21_29","LUK","21","29","29","Na, paniidan mazo ya batasan na tanem nga igira daw bisan ono ya tanem mazo. ");
INSERT INTO mmn_vpl VALUES ("LK21_30","072_21_30","LUK","21","30","30","Kon namag-o ya dahon mahagdam di kamo nga ampanhoraw di kaan. ");
INSERT INTO mmn_vpl VALUES ("LK21_31","072_21_31","LUK","21","31","31","Singed iton ka inlaong nao kamazo koman. Pagpakakita mazo kaiza nga mga inlaong nao kamazo mahagdam kamo nga arani di gazed ya tirmino nao ka pagbalik ka kalibotan. ");
INSERT INTO mmn_vpl VALUES ("LK21_32","072_21_32","LUK","21","32","32","Matood nga ka wara pen mapatay ya kamazong kaliwatan matoman ya impanan-og o kamazo. ");
INSERT INTO mmn_vpl VALUES ("LK21_33","072_21_33","LUK","21","33","33","Mangawara ya kalangitan daw ya kalibotan piro ya kanaong mga panaba diri gazed mawara. ");
INSERT INTO mmn_vpl VALUES ("LK21_34","072_21_34","LUK","21","34","34","Maghamarag gazed kamo kay basi dakola ya kamazong hena-hena ka pag-osik-osik daw ya mga makahebeg daw ya mga kawied kon ono ya kamazong panginabohi. Kamhan mabereng gazed kamo ka pagbalik nao kay madali ka gazed ya pagbalik nao singed ka kadali na pagbekas na balatik. ");
INSERT INTO mmn_vpl VALUES ("LK21_35","072_21_35","LUK","21","35","35","Bisan sin-o ya tao waray mahagdam kon kon-o hao ambalik ka kalibotan. ");
INSERT INTO mmn_vpl VALUES ("LK21_36","072_21_36","LUK","21","36","36","Agon mag-andam kamo daan. Maghangzo kamo ka Diyos nga pabaskegen ya kamazong pagsarig dazaw makaanget kamo ka mga kalised. Kamhan waray kasipeg mazo pag-atobang mazo kanao kay-an ka pagbalik nao. Ani ini ya impanaba ni Hisos ka toong mga sakop. ");
INSERT INTO mmn_vpl VALUES ("LK21_37","072_21_37","LUK","21","37","37","Kamhan kada aldaw dizan ka dakolang lagkaw nga pangamozoanan ka Diyos nagasindo iza ka mga tao. Kada pagkadelem ambalik iza ka bobong nga Olibo kay dizan iza kon kahabzen. ");
INSERT INTO mmn_vpl VALUES ("LK21_38","072_21_38","LUK","21","38","38","Kada masiselem ambalik ya mga mataed nga tao ka lagkaw na Diyos kay ampanalinga siran ka mga panaba ni Hisos. ");
INSERT INTO mmn_vpl VALUES ("LK22_1","072_22_1","LUK","22","1","1","Na, kon-isa pen pan-ihawen na mga Yodayo ya mga nati na karniro kay ampista siran. Kanen sab niran ya pan nga waray ipasoligay. ");
INSERT INTO mmn_vpl VALUES ("LK22_2","072_22_2","LUK","22","2","2","Kamhan ya mga oloolo na mga pari daw ya mga maistro ka tinoohan na mga Yodayo nagapangita di siran ka paazi kon onhon niran pagdakep kan Hisos dazaw patazen niran. Nawied isab siran kay basi magobot ya mga mamistahay kay mataed ya mga mintoo kan Hisos. ");
INSERT INTO mmn_vpl VALUES ("LK22_3","072_22_3","LUK","22","3","3","Kamhan dizan ka mga napolo may dowang ka sinarigan ni Hisos, si Hodas nga taga Kariyoti inharian di iza ni Satanas. ");
INSERT INTO mmn_vpl VALUES ("LK22_4","072_22_4","LUK","22","4","4","Kamhan minkaro iza ka mga oloolo na mga pari daw ya mga magbantazay ka lagkaw na Diyos. Kamhan namagsabot siran kon onhon sa ni Hodas pagtogyan kan Hisos dizan kaniran. ");
INSERT INTO mmn_vpl VALUES ("LK22_5","072_22_5","LUK","22","5","5","Namagsaza gazed ya mga oloolo daw minsohol isab siran kan Hodas ka kowarta. ");
INSERT INTO mmn_vpl VALUES ("LK22_6","072_22_6","LUK","22","6","6","Kamhan minpanaw iza kay nagapangita iza ka paazi kon onhon naiza pagtogyan kan Hisos dizan kaniran dazaw diri mahagdam ya mga mataed nga tao kay basi magobot siran. ");
INSERT INTO mmn_vpl VALUES ("LK22_7","072_22_7","LUK","22","7","7","Kamhan pagkakon-isa di primirong aldaw ini ka pista ka pagpangaen na mga Yodayo ka pan nga waray ipasoligay. Pan-ihawen disab niran ya mga nati na karniro kay antaremdem siran nga pagbetang na mga karaan niran ka dogo na nati dizan ka pirtahan na lagkaw niran, wara siran maazihi na taga langit nga insogo na Diyos ka pagpamatay ka mga amaama nga panganay na mga taga Ihipto. Ani ini ya intaremdeman niran. ");
INSERT INTO mmn_vpl VALUES ("LK22_8","072_22_8","LUK","22","8","8","Kamhan minsogo si Hisos kan Pidro daw si Howan nga nagalaong nga komaro kamo naa kay mag-andam kamo ka pagkaen ta ka pista. ");
INSERT INTO mmn_vpl VALUES ("LK22_9","072_22_9","LUK","22","9","9","Minsambag siran daw hain ya lagkaw nga andaman nami kaiton? ");
INSERT INTO mmn_vpl VALUES ("LK22_10","072_22_10","LUK","22","10","10","Minsambag si Hisos nga komaro kamo naa ngaro ka siyodad nga Hirosalem. Kamhan may magabathay ka tadzaw nga ansogat kamazo. Sondon mazo iza dizan ka lagkaw nga inpanikan naiza. ");
INSERT INTO mmn_vpl VALUES ("LK22_11","072_22_11","LUK","22","11","11","Kamhan maglaong kamo ka tag-iza na lagkaw nga Nong, ya kanaming maistro ani ya minsogo kanami ngarini kay ampangotana kanmo kon hain ya seled nga kananan naiza ka pista iba ka toong kasakopan? ");
INSERT INTO mmn_vpl VALUES ("LK22_12","072_22_12","LUK","22","12","12","Kamhan ipakita naiza kamazo ya ikadowang saleg nga may seled nga haloag nga ipapalastar daan ya mga kinahanglanen ta. Na, dizan kaiton andamen mazo ya kantang pagkaen. Ani ini ya pagtogon ni Hisos kaniran. ");
INSERT INTO mmn_vpl VALUES ("LK22_13","072_22_13","LUK","22","13","13","Kamhan namanaw di siran ngaro ka siyodad. Pagdateng niran doro nakitan matood niran ya tanan inlaong ni Hisos. Kamhan namag-andam siran ka pagkaen ka pista. ");
INSERT INTO mmn_vpl VALUES ("LK22_14","072_22_14","LUK","22","14","14","Pagkakahabzen kaiza dizan ka kananan mintambong si Hisos daw ya toong mga sinarigan. ");
INSERT INTO mmn_vpl VALUES ("LK22_15","072_22_15","LUK","22","15","15","Ka nagakaen pen siran minlaong iza kaniran nga madazaw gazed ya pagtambong nita dini kay naazak hao ansaro kaini nga makaen ka pista dini kamazo ka wara pen hao mag-azi ka masiet nga kalised. ");
INSERT INTO mmn_vpl VALUES ("LK22_16","072_22_16","LUK","22","16","16","Sabten mazo nga diri gazed hao mamista pag-isab hangtod ka paghari na kanaong Ama ka bag-ong kalibotan. ");
INSERT INTO mmn_vpl VALUES ("LK22_17","072_22_17","LUK","22","17","17","Kamhan minporot iza ka baso nga may imnenen nga sapa na mga obas. Pagkakamhan naiza pagpasalamat ka Diyos minlaong iza nga dawata mazo, bahina mazo pag-inem. ");
INSERT INTO mmn_vpl VALUES ("LK22_18","072_22_18","LUK","22","18","18","Panan-ogan ta kamo nga diri gazed hao an-inem pag-isab ka sapa na mga obas hangtod ka paghari na kanaong Ama ka bag-ong kalibotan. ");
INSERT INTO mmn_vpl VALUES ("LK22_19","072_22_19","LUK","22","19","19","Pagkakamhan niran pag-inem minporot si Hisos ka pan. Pagpasalamat naiza ka Diyos impanipaktipak naiza iton kay ipanhatag kaniran. Kamhan minlaong iza nga ini nga pan kilalhen mazo nga kanaong lawas nga patazen kay-an kay ikabazad ka kamazong mga sala. Sokad koman maghaod kamo ka kanaong batasan dazaw magtaremdem kamo ka kanaong pagkapatay. ");
INSERT INTO mmn_vpl VALUES ("LK22_20","072_22_20","LUK","22","20","20","Ini nga imnenen kilalhen mazo nga kanaong dogo nga ipaawas nao kay-an ka pagkapatay nao kay ikabazad iton ka kamazong mga sala. Ya kanaong dogo ani ya pirmahan na Diyos ka bag-ong saad naiza ka tanan mga tao. ");
INSERT INTO mmn_vpl VALUES ("LK22_21","072_22_21","LUK","22","21","21","Kamhan minlaong si Hisos nga timan-an mazo gazed ini nga wadini gazed kanta ya an-edlaw kanao nga isa. Ya tao nga minsaro kanao ka pagkaen iza ya an-edlaw kanao. ");
INSERT INTO mmn_vpl VALUES ("LK22_22","072_22_22","LUK","22","22","22","Kay minbeet daan ya Diyos nga patazen hao basta ya tao nga om-edlaway kanao intawon madazaw kon wara iza pakataoha. ");
INSERT INTO mmn_vpl VALUES ("LK22_23","072_22_23","LUK","22","23","23","Kamhan nangotana siran nga sin-o sa baza wani kantang tanan ya magalong-on ni Hisos dini? ");
INSERT INTO mmn_vpl VALUES ("LK22_24","072_22_24","LUK","22","24","24","Pagkakamhan kaiza minlalis siran nga daw sin-o ya labaw dini kanta? ");
INSERT INTO mmn_vpl VALUES ("LK22_25","072_22_25","LUK","22","25","25","Kamhan minlaong si Hisos kaniran nga mahagdam kamo ka batasan na mga diri kon Yodayo nga nagahari dini ka kantang lopa. Magmandaray gazed siran ka mga tao. ");
INSERT INTO mmn_vpl VALUES ("LK22_26","072_22_26","LUK","22","26","26","Piro kamo nga kanaong mga sakop, diri kamo maghaod ka kanirang batasan kay dizan kamazo ya labaw nga tao kinahanglan ampangalagad iza kamazo singed ka pagpangalagad na manghod nga gipos-an. Kamhan ya oloolo mazo kinahanglan ampangalagad iza kamazo singed ka pagpangalagad na sogoonon. ");
INSERT INTO mmn_vpl VALUES ("LK22_27","072_22_27","LUK","22","27","27","Ya tao nga nagakaen labaw iza ka tao nga mag-ateday ka makaen. Kamhan bisan hao ya oloolo mazo singed hao ka tao nga mag-ateday ka kamazong makaen. ");
INSERT INTO mmn_vpl VALUES ("LK22_28","072_22_28","LUK","22","28","28","Sokad ka pagsakop mazo kanao min-azi kamo ka mga kalised iba kanao. ");
INSERT INTO mmn_vpl VALUES ("LK22_29","072_22_29","LUK","22","29","29","Agon may ihatag nao kamazo singed ka inhatag kanao na kanaong Ama. Kay impili hao naiza ka paghari ka bag-ong kalibotan. Kamhan pilien ta kamo isab ");
INSERT INTO mmn_vpl VALUES ("LK22_30","072_22_30","LUK","22","30","30","dazaw magsaro kita ka makaen kay-an ka paghari nao. Kamhan kamo isab ya anlo-to dizan ka lo-toanan ka paghari kay anpanhokom kamo ka mga kaliwatan na mga napolo may dowang bolos nga maanak ni Israil. ");
INSERT INTO mmn_vpl VALUES ("LK22_31","072_22_31","LUK","22","31","31","Simon, Simon, may ilaong ta kamo kay dini kanao intogotan si Satanas ka pagsoray kamazong tanan singed ka tao nga nagasisig ka begas. Kay gosto naiza nga ambiza kamo kanao. ");
INSERT INTO mmn_vpl VALUES ("LK22_32","072_22_32","LUK","22","32","32","Agon nagatabang hao kanmo ka pag-ampo ka Diyos dazaw diri magmaloza ya kanmong pagtoo kanao. Kamhan pagbalik mo kanao kay-an tabangan mo isab ya mga kaibahan mo dazaw heget ya kanirang pagtoo kanao. ");
INSERT INTO mmn_vpl VALUES ("LK22_33","072_22_33","LUK","22","33","33","Minsambag si Pidro nga Ginoo, waray bali kon prisohon hao iba kanmo basta diri gazed hao ambiza kanmo bisan patazen hao. ");
INSERT INTO mmn_vpl VALUES ("LK22_34","072_22_34","LUK","22","34","34","Minsambag si Hisos nga Pidro, timan-an mo gazed ini nga pagkakamaaldawen ka ka wara pen tagaok ya manok, ikatolo di mo hao kon ilimed paglaong nga diri kon iko ya kanaong sakop. ");
INSERT INTO mmn_vpl VALUES ("LK22_35","072_22_35","LUK","22","35","35","Mindogang iza pagpanaba kaniran nga izang dini kaini ka pagpakaro nao kamazo ka pagwali ka mga tao pikit ka lawas ka lamang ya dara mazo. Kamhan daw may kolang mazo? Minsambag siran nga wara gazed. ");
INSERT INTO mmn_vpl VALUES ("LK22_36","072_22_36","LUK","22","36","36","Minsambag iza nga matood iton kay dakola ya kaazak na mga Yodayo kanao agon minpakaen siran kamazo piro awazen hao niran koman agon maghabay kamo ka kamazong kowarta, magdara kamo ka kamazong hambag. Kon waray lodzo ibaligza mazo ya kamazong bado dazaw may ikapalit ka lodzo. ");
INSERT INTO mmn_vpl VALUES ("LK22_37","072_22_37","LUK","22","37","37","Panabaan ta kamo nga kinahanglan matoman ya daan pinasoyat na Diyos mahitenged kanao nga nagalaong nga dizan ka mga makasasala nga tao makalakip si Hisos pagpatay. Kay tomanen gazed ya tanan pinasoyat na Diyos mahitenged kanao. ");
INSERT INTO mmn_vpl VALUES ("LK22_38","072_22_38","LUK","22","38","38","Kamhan minsazep ya toong mga sakop kay silaong niran nga minsogo iza kaniran ka pagtigbas agon minlaong siran nga Ginoo, selengi! Wani ya lodzo nga dowang bolos. Minsambag iza nga igo di nga sazep mazo. ");
INSERT INTO mmn_vpl VALUES ("LK22_39","072_22_39","LUK","22","39","39","Kamhan minlogwa iza kay ambalik iza ka bobong nga Olibo ya ngaran. Kamhan nangiba disab ya toong mga sinarigan. ");
INSERT INTO mmn_vpl VALUES ("LK22_40","072_22_40","LUK","22","40","40","Pagdateng niran dizan minlaong iza kaniran nga maghangzo kamo ka Diyos dazaw diri kamo dag-en ka pagtintal na mga maonga. ");
INSERT INTO mmn_vpl VALUES ("LK22_41","072_22_41","LUK","22","41","41","Kamhan minkaro iza ka hon-ahan nga aroaro kaniran. Kamhan minlohod iza daw minhangzo iza ka Diyos nagalaong nga ");
INSERT INTO mmn_vpl VALUES ("LK22_42","072_22_42","LUK","22","42","42","Ama nao, kon somogot ko diri mo hao pag-ipapatay para ka mga sala na mga tao. Piro iko ka say magaponto kanao. ");
INSERT INTO mmn_vpl VALUES ("LK22_43","072_22_43","LUK","22","43","43","Ka nagahangzo pen iza mindateng dizan kanangiza ya sinogo nga garing ka langit kay magatabangan si Hisos ");
INSERT INTO mmn_vpl VALUES ("LK22_44","072_22_44","LUK","22","44","44","kay mabeg-at gazed ya toong hena-hena anika daw ikapatazay di naiza. Pagtodahi ka naiza ka toong paghangzo impanholasan gazed iza. Pagpanoro ka na toong holas ka lopa singed iton ka dogo nga tibolos. ");
INSERT INTO mmn_vpl VALUES ("LK22_45","072_22_45","LUK","22","45","45","Pagkakamhan naiza paghangzo ka Diyos minbalik iza ka toong mga sinarigan. Nangatorog gazed siran kay impanhowozan siran tenged ka kabeg-at na kanirang hinawa. ");
INSERT INTO mmn_vpl VALUES ("LK22_46","072_22_46","LUK","22","46","46","Nangotana si Hisos kaniran nga kay ono sang mangatorog sa kamo? Pamangon di kamo. Magpangamozo kamo ka Diyos kay basi dag-en kamo ka pagtintal na mga maonga. ");
INSERT INTO mmn_vpl VALUES ("LK22_47","072_22_47","LUK","22","47","47","Na, ka nagapanaba pen si Hisos kaniran mindateng di ya mga mataed nga tao. Kamhan ya isang sinarigan nga si Hodas iza ya minhon-a kaniran. Ka pagdateng ni Hodas dizan kan Hisos an-arek iza kontana kan Hisos ka pagpangamosta ");
INSERT INTO mmn_vpl VALUES ("LK22_48","072_22_48","LUK","22","48","48","piro minlaong si Hisos nga Hodas, daw an-arek iko ka pag-edlaw kanao? ");
INSERT INTO mmn_vpl VALUES ("LK22_49","072_22_49","LUK","22","49","49","Pagpakahagdam ka na mga sakop ni Hisos nga dakpen di sa baza si Hisos minlaong siran nga Ginoo, daw antigbas kami kaniran? ");
INSERT INTO mmn_vpl VALUES ("LK22_50","072_22_50","LUK","22","50","50","Kamhan nagahogot ya isa ka toong lodzo daw mintigbas. Kamhan nakawa dazon ya talinga nga too na oripen na labaw nga pari. ");
INSERT INTO mmn_vpl VALUES ("LK22_51","072_22_51","LUK","22","51","51","Minlaong dazon si Hisos nga igo di iza nga hinang mo! Kamhan minhogam si Hisos ka talinga na oripen kay insompay ka naiza ya tigbas. ");
INSERT INTO mmn_vpl VALUES ("LK22_52","072_22_52","LUK","22","52","52","Kamhan minlaong iza ka oloolo na mga pari daw ya mga magbantazay ka lagkaw na Diyos daw ya mga malaas nga ono sa wani baza kamo? Daw tolisan hao wani nga dakpen di sa mazo hao koman ka lodzo daw ibonalay? ");
INSERT INTO mmn_vpl VALUES ("LK22_53","072_22_53","LUK","22","53","53","Izang dini kaini dizan ka dakolang lagkaw nga pangamozoanan ka Diyos aldaw-aldaw nagaibaiba hao kamazo. Kamhan wara sa mazo hao dakpa. Piro magadakpen sa mazo hao koman kay si Satanas ani ya nagahari kamazo nga nagahela ka kadeglem. ");
INSERT INTO mmn_vpl VALUES ("LK22_54","072_22_54","LUK","22","54","54","Kamhan mindakep matood siran kan Hisos daw min-ated ngaro ka lagkaw na labaw nga pari. Kamhan minsonod si Pidro nga nagapaantaw. ");
INSERT INTO mmn_vpl VALUES ("LK22_55","072_22_55","LUK","22","55","55","Pagdateng naiza dizan ka pawa na lagkaw minlo-to iza dizan ka mga tao nga minharing kay magapanarang. ");
INSERT INTO mmn_vpl VALUES ("LK22_56","072_22_56","LUK","22","56","56","Dizan disab may isang babazi nga binolanan na labaw nga pari. Pagpakakita ka naiza kan Pidro nga nagapanarang nagapahiseleng iza ka bayho ni Pidro. Kamhan minpanaba iza ka toong mga iba nga itong tao nga dizan ka gabok iza gazed ya iba na tao nga nadakpan kazina. ");
INSERT INTO mmn_vpl VALUES ("LK22_57","072_22_57","LUK","22","57","57","Kamhan minlimed si Pidro nagalaong nga inday kon sin-o iton. ");
INSERT INTO mmn_vpl VALUES ("LK22_58","072_22_58","LUK","22","58","58","Ka wara pen madogay nakilalhan disab iza na ibang tao nga nagalaong nga iko ya sakop ni Hisos. Minsambag si Pidro nga diri gazed kon hao iton! ");
INSERT INTO mmn_vpl VALUES ("LK22_59","072_22_59","LUK","22","59","59","Pagkateedteed kaiza minlaong ya isa pen nga tao mahitenged kan Pidro nga sakop gazed iza ni Hisos kay taga Galiliya gihapon iza. ");
INSERT INTO mmn_vpl VALUES ("LK22_60","072_22_60","LUK","22","60","60","Kamhan minsambag si Pidro paglimed nga wara gazed hao mahagdam kon sin-o itong taohana nga magalong-on mazo. Na, ka nagapanaba pen si Pidro paglimed kan Hisos mintagaok ya manok. ");
INSERT INTO mmn_vpl VALUES ("LK22_61","072_22_61","LUK","22","61","61","Kamhan minlingi si Hisos ka pagseleng kan Pidro. Kamhan nakataremdem di si Pidro ka inlaong ni Hisos nga pagkakamaaldawan ka ka wara pen tagaok ya manok katlo mo hao ilimed. ");
INSERT INTO mmn_vpl VALUES ("LK22_62","072_22_62","LUK","22","62","62","Na, pagpakataremdem ka ni Pidro masara gazed ya toong paghaza kay inlimed sa naiza si Hisos. ");
INSERT INTO mmn_vpl VALUES ("LK22_63","072_22_63","LUK","22","63","63","Kamhan ya mga nagabantay kan Hisos nagasorasora gazed siran kamhan imbonalan niran si Hisos. ");
INSERT INTO mmn_vpl VALUES ("LK22_64","072_22_64","LUK","22","64","64","Impamagbegketan isab ya toong mata. Kamhan minlaong siran pagsora nga tekmaen mo kon sin-o ya minlaparo kanmo! ");
INSERT INTO mmn_vpl VALUES ("LK22_65","072_22_65","LUK","22","65","65","Mataed pen gazed ya impanaba niran pagsorasora kan Hisos. ");
INSERT INTO mmn_vpl VALUES ("LK22_66","072_22_66","LUK","22","66","66","Pagkamasiselem ka kaiza nagatipon di ya mga malaas daw ya mga oloolo na mga pari daw ya tanan mga maistro. Kay hokman niran si Hisos. Kamhan iated si Hisos dizan ka labaw nga hokmanan. ");
INSERT INTO mmn_vpl VALUES ("LK22_67","072_22_67","LUK","22","67","67","Kamhan minlaong siran kan Hisos nga kon iko si Kristo nga hari nga pinili na Diyos magpanan-og naa iko. Minsambag si Hisos nga kon panabaan ta kamo nga hao si Kristo nga hari nga pinili na Diyos diri gazed kamo antoo kanao. ");
INSERT INTO mmn_vpl VALUES ("LK22_68","072_22_68","LUK","22","68","68","Kamhan kon pangotanhen nao kamo mahitenged ka pagsangil mazo kanao, diri gazed kamo ansambag kanao. ");
INSERT INTO mmn_vpl VALUES ("LK22_69","072_22_69","LUK","22","69","69","Kamhan wani gazed ya kanaong sambag kamazo. Hao ya tao nga impanan-og na mga daan propita na Diyos. Ka wara pen madogay an-oli hao ka Diyos nga labaw ka gahem. Kay dizan ka toong too anlo-to hao ka paghari kay hao ya minhon-a ka bisan sin-o nga mahon-ang tao. ");
INSERT INTO mmn_vpl VALUES ("LK22_70","072_22_70","LUK","22","70","70","Kamhan minlaong sirang tanan nga agon min-angken iko nga iko ya Maanak na Diyos. Minsambag si Hisos nga ya kamazong inlaong hao iton. ");
INSERT INTO mmn_vpl VALUES ("LK22_71","072_22_71","LUK","22","71","71","Minlaong siran nga wara di kita magkinahanglan ka dogang pen nga saksi kay nabatian di nita ya toong bakak nga iza ya Maanak na Diyos. ");
INSERT INTO mmn_vpl VALUES ("LK23_1","072_23_1","LUK","23","1","1","Kamhan nanindeg dazon ya tanan mga oloolo na mga Yodayo kay kamhan di ya pagsabot niran kon onhon niran pagpapatay kan Hisos. Kamhan in-ated niran si Hisos dizan kan Pilato. ");
INSERT INTO mmn_vpl VALUES ("LK23_2","072_23_2","LUK","23","2","2","Pagdateng niran dizan minsogod di siran pagbetangbetang kan Hisos nga nagalaong nga indakep nami ini nga taohana kay minhagad iza kanami ka pagsopak ka kantang hari nga taga Roma nga si Sisar. Kamhan diri pabayran ya bohis. Min-angken isab iza nga iza gazed si Kristo nga hari na mga Yodayo. ");
INSERT INTO mmn_vpl VALUES ("LK23_3","072_23_3","LUK","23","3","3","Kamhan nangotana si Pilato kan Hisos nga matod, ey, iko ya hari na mga Yodayo? Minsambag si Hisos nga itong inlaong mo kanao hao iton. ");
INSERT INTO mmn_vpl VALUES ("LK23_4","072_23_4","LUK","23","4","4","Kamhan minlaong si Pilato ka mga oloolo na mga pari daw ya mga mataed nga tao nga diri nao silotan ini nga tao kay waray sala naiza. ");
INSERT INTO mmn_vpl VALUES ("LK23_5","072_23_5","LUK","23","5","5","Mintoda gazed siran pagbetangbetang nga nagalaong nga nagapagobot iza ka mga tao doro ka lopa nga Galiliya. Kamhan in-oswagan ya kagobot ngarini ka Yoda daw Hirosalem kay mintoldo iza ka mga tao ka pagsopak ka kantang hari nga taga Roma. ");
INSERT INTO mmn_vpl VALUES ("LK23_6","072_23_6","LUK","23","6","6","Pagpakabati ka ni Pilato kaiza nangotana iza nga daw taga Galiliya ini nga tao? ");
INSERT INTO mmn_vpl VALUES ("LK23_7","072_23_7","LUK","23","7","7","Pagkahagdam naiza nga garing si Hisos ka lopa nga Galiliya nga inharian ni Hirodis impadara naiza si Hisos dizan kan Hirodis kay magbisitahay si Hirodis dini ka Hirosalem kay ampamista iza. ");
INSERT INTO mmn_vpl VALUES ("LK23_8","072_23_8","LUK","23","8","8","Pagpakakita ka ni Hirodis kan Hisos may kasaza naiza kay dogay di gosto gazed iza ankita kan Hisos kay mataed ya mga minpanan-og mahitenged ka mga inhinang ni Hisos. Kamhan gosto si Hirodis ankita ka dakolang hinang ni Hisos. ");
INSERT INTO mmn_vpl VALUES ("LK23_9","072_23_9","LUK","23","9","9","Kamhan mataed ya pangotana ni Hirodis kan Hisos piro wara iza magsambag. ");
INSERT INTO mmn_vpl VALUES ("LK23_10","072_23_10","LUK","23","10","10","Kamhan nazehet gazed ya mga oloolo na mga pari daw ya mga maistro pagbetangbetang niran kan Hisos. ");
INSERT INTO mmn_vpl VALUES ("LK23_11","072_23_11","LUK","23","11","11","Kamhan insorasora iza ni Hirodis daw ya toong mga soldaw. Insol-oban iza niran ka ataas nga bado nga magazon selengan dazaw anhaod ka hari. Kamhan ingkatawhan isab nirang tanan si Hisos. ");
INSERT INTO mmn_vpl VALUES ("LK23_12","072_23_12","LUK","23","12","12","Kamhan namagkahosay di si Hirodis daw si Pilato bisan wara siran magkaangay sokad. ");
INSERT INTO mmn_vpl VALUES ("LK23_13","072_23_13","LUK","23","13","13","Kamhan impantipon ni Pilato ya mga oloolo na mga pari daw ya mga malaas daw ya mga tao nga Yodayo. ");
INSERT INTO mmn_vpl VALUES ("LK23_14","072_23_14","LUK","23","14","14","Kamhan minlaong iza nga ya pagdimanda mazo kanao kaini nga taohana minlaong kamo nga nagakasamok iza ka mga tao dazaw sopaken niran si Sisar. Na, pagpangotana nao kanangiza dini ka pagpakabati mazo bisan ono ya imbetangbetang mazo, waray sala naiza. ");
INSERT INTO mmn_vpl VALUES ("LK23_15","072_23_15","LUK","23","15","15","Pag-atobang isab naiza dizan kan Hirodis waray sala naiza angay silotan ka kamatazen. ");
INSERT INTO mmn_vpl VALUES ("LK23_16","072_23_16","LUK","23","16","16","Agon ipalatos lamang nao. Kamhan bohian nao iza. ");
INSERT INTO mmn_vpl VALUES ("LK23_17","072_23_17","LUK","23","17","17","Ani ini ya impanaba ni Pilato kay kada toig ka pagpamista na mga Yodayo ya batasan ni Pilato magapalogwa iza ka isang piniriso nga angay niran. ");
INSERT INTO mmn_vpl VALUES ("LK23_18","072_23_18","LUK","23","18","18","Kamhan namagdengan ya mga Yodayo pagpaninggit nga waray labet nami kaiton nga tao. Ani hinoay bohii si Barabas. ");
INSERT INTO mmn_vpl VALUES ("LK23_19","072_23_19","LUK","23","19","19","Na, si Barabas napriso iza kay inpasopak naiza ya mga tao dini ka Hirosalem. Kamhan nakabono iza ka tao ka pag-away nirang tanan. ");
INSERT INTO mmn_vpl VALUES ("LK23_20","072_23_20","LUK","23","20","20","Na, minpanaba si Pilato ka mga tao pag-isab kay gosto naiza bohian si Hisos. ");
INSERT INTO mmn_vpl VALUES ("LK23_21","072_23_21","LUK","23","21","21","Kamhan naninggit hinoa siran nga ipalansang iza ka kros! Ipalansang iza ka kros! ");
INSERT INTO mmn_vpl VALUES ("LK23_22","072_23_22","LUK","23","22","22","Kamhan ikatolo di ya pagpanaba ni Pilato kaniran nga kay ono sa kamo kaiton? Waray sala naitong tao. Diri iza silotan ka kamatazen. Ipalatos nao iza kamhan bohian. ");
INSERT INTO mmn_vpl VALUES ("LK23_23","072_23_23","LUK","23","23","23","Kamhan mintoda gazed siran pagpaninggit nga ipalansang gazed iza ka kros! Kamhan indag-en si Pilato ka kanirang mga panaba. ");
INSERT INTO mmn_vpl VALUES ("LK23_24","072_23_24","LUK","23","24","24","Minhokom iza ka pagpapatay kan Hisos kay pasazaen naiza ya mga tao. ");
INSERT INTO mmn_vpl VALUES ("LK23_25","072_23_25","LUK","23","25","25","Kamhan inbohian naiza si Barabas bisan inpasopak naiza ya mga tao kan Sisar nga hari. Nakabono isab iza ka tao. Kamhan minsogo si Pilato ka mga soldaw ka pagpatay kan Hisos kay pasazaen naiza ya mga tao. ");
INSERT INTO mmn_vpl VALUES ("LK23_26","072_23_26","LUK","23","26","26","Pagpakaated na mga soldaw kan Hisos ngaro ka patazanan may insogat niran nga si Simon nga garing ka oma pasinged ngarini ka Hirosalem. Taga Sirini iza. Kamhan indakep niran iza kay pabathazen ka kros ni Hisos. Pagsili ka naiza pagbathay ka kros minsonod iza pagpanaw kan Hisos. ");
INSERT INTO mmn_vpl VALUES ("LK23_27","072_23_27","LUK","23","27","27","Kamhan mataed gazed ya mga tao nga namagsonod kan Hisos. Apil kaniran ya mga babazi nga nagahaza kay patazen di kaan si Hisos. ");
INSERT INTO mmn_vpl VALUES ("LK23_28","072_23_28","LUK","23","28","28","Paglingi ni Hisos kaniran minlaong iza nga kamo nga mga babazi nga taga Hirosalem, diri kamo maghaza kanao. Ani hazai mazo ya kamazong kaogaringen daw ya kamazong mga bata. ");
INSERT INTO mmn_vpl VALUES ("LK23_29","072_23_29","LUK","23","29","29","Kay ka wara pen madogay an-azi ya mga taga Hirosalem ka masiet nga kalised. Kamhan anlaong ya mga tao nga madazaw ya kahimtang na mga babazi nga wara makapanganak daw ya mga babazi nga wara makapasoso ka mga bata! ");
INSERT INTO mmn_vpl VALUES ("LK23_30","072_23_30","LUK","23","30","30","Kamhan ansogod siran paghawag ka mga bobong nga pangatelmagan kami! Anhawag siran ka mga pongtod nga libonan kami! ");
INSERT INTO mmn_vpl VALUES ("LK23_31","072_23_31","LUK","23","31","31","Mindogang si Hisos pagpanaba kaniran nga kon kasab-an hao bisan waray sala nao, daw ono pen ya andateng ka mga tao nga nakasala? ");
INSERT INTO mmn_vpl VALUES ("LK23_32","072_23_32","LUK","23","32","32","Na, may dowang ka tao nga dakola ya kanirang sala. Kamhan in-ated isab siran na mga soldaw kay patazen siran daw si Hisos doro ka patazanan inngaranan ka Dapit ka Kalabira kay ani ya dapit ka pagpatay niran ka tao nga inpahamtang ka kamatazen. ");
INSERT INTO mmn_vpl VALUES ("LK23_33","072_23_33","LUK","23","33","33","Pagdateng niran dizan inlansang niran si Hisos ka kros. Inlansang sab ya dowang ka tao nga salaan. Ya isa dapit ka too ni Hisos. Ya ikadowa dapit ka toong wala. ");
INSERT INTO mmn_vpl VALUES ("LK23_34","072_23_34","LUK","23","34","34","Kamhan minpanaba si Hisos nga Ama, pasaylohon mo ya mga minlansang kanao kay wara siran mahagdam kon ono ya hinang niran. Kamhan namagriparipa ya mga soldaw kon sin-oy makatag-iza ka mga bado ni Hisos. ");
INSERT INTO mmn_vpl VALUES ("LK23_35","072_23_35","LUK","23","35","35","Naneleng ya mga tao pagtindeg niran dizan. Kamhan nagasorasora ya mga oloolo na mga Yodayo nga nagalaong nga nakalibri iza ka mga iba nga tao piro diri iza makalibri ka toong kaogaringeng lawas. Kon iza matood si Kristo nga hari nga pinili na Diyos makalibri iza ka toong kaogaringeng lawas. ");
INSERT INTO mmn_vpl VALUES ("LK23_36","072_23_36","LUK","23","36","36","Impanora isab iza na mga soldaw pagpainem ka bino nga barato ");
INSERT INTO mmn_vpl VALUES ("LK23_37","072_23_37","LUK","23","37","37","nga nagalaong nga kon iko matood ya hari na mga Yodayo libriha ya kanmong kaogaringeng lawas! ");
INSERT INTO mmn_vpl VALUES ("LK23_38","072_23_38","LUK","23","38","38","Na, dapit daked ka poro ni Hisos intapil sab ya sinoyat nga nagalaong nga si Hisos ini nga hari na mga Yodayo. ");
INSERT INTO mmn_vpl VALUES ("LK23_39","072_23_39","LUK","23","39","39","Bisan ya isang tao nga inlansang dizan ka sain ni Hisos maonga ya toong saba kan Hisos nga nagalaong nga daw diri kon si Kristo iko? Kontana librihen mo ya kanmong kaogaringeng lawas daw kanaming dowa! ");
INSERT INTO mmn_vpl VALUES ("LK23_40","072_23_40","LUK","23","40","40","Kamhan inbaheg iza na toong iba nga nagalaong nga kay ono sa waray kasipeg mo ka pagpanaba ka Diyos? Bisan mag-ani ka ya pagsilot kanangiza daw kantang dowa, ");
INSERT INTO mmn_vpl VALUES ("LK23_41","072_23_41","LUK","23","41","41","waray sala naiza piro kitang dowa imbalsan gazed kita ka kantang sala. ");
INSERT INTO mmn_vpl VALUES ("LK23_42","072_23_42","LUK","23","42","42","Kamhan minlaong iza kan Hisos nga Hisos, taremdemen mo hao kay-an ka pagbalik mo ka paghari mo ka kalibotan. ");
INSERT INTO mmn_vpl VALUES ("LK23_43","072_23_43","LUK","23","43","43","Minsambag si Hisos nga panabaan ta ko nga koman nga aldaw iba iko kanao doro ka datnganan nga madazaw. ");
INSERT INTO mmn_vpl VALUES ("LK23_44","072_23_44","LUK","23","44","44","Na, pagkaedto di mindeglem gazed ya aldaw hangtod ka pagkabalantang na aldaw ka alas tris. ");
INSERT INTO mmn_vpl VALUES ("LK23_45","072_23_45","LUK","23","45","45","Nagalipsilipsi ya sega. Kamhan dizan ka dakolang lagkaw nga pangamozoanan ka Diyos nagisi ya kortina garing daked lapos ngarimbaba ka sidsid. ");
INSERT INTO mmn_vpl VALUES ("LK23_46","072_23_46","LUK","23","46","46","Pagkakamhan kaiza dakola ya pagsinggit ni Hisos nga nagalaong nga Ama, ihatag nao kanmo ya kanaong ispirito. Pagkakamhan kaiza nabogtoan dazon iza ka toong hinawa. ");
INSERT INTO mmn_vpl VALUES ("LK23_47","072_23_47","LUK","23","47","47","Kamhan ya kapitan na mga soldaw pagkita naiza ka pagkapatay ni Hisos minlaong iza pagsaza ka Diyos nga iton nga napatay iza matood ya madazaw nga tao! ");
INSERT INTO mmn_vpl VALUES ("LK23_48","072_23_48","LUK","23","48","48","Kamhan ya mga mataed nga tao nga nagatipon dizan nga nakakita ka pagkapatay ni Hisos nangoli di sirang tanan kay mabeg-at gazed ya kanirang hinawa. ");
INSERT INTO mmn_vpl VALUES ("LK23_49","072_23_49","LUK","23","49","49","Kamhan ya tanan mga higara ni Hisos daw ya mga babazi nga nangiba kan Hisos garing ka Galiliya nagapaantaw siran ka pagseleng kaini nga tanan. ");
INSERT INTO mmn_vpl VALUES ("LK23_50","072_23_50","LUK","23","50","51","Kamhan may amaama nga si Hosi ya ngaran. Taga Aramatiya iza nga isang longsod na mga Yodayo. Beetan si Hosi daw naazak iza nga antoman ka mga sogo na Diyos. Nagatagad isab iza ka pagkahari na Diyos. Sakop isab iza ka labaw nga hokmanan na mga Yodayo piro wara iza magsogot ka gosto na toong kaibahan paghokom niran kan Hisos ka kamatazen. ");
INSERT INTO mmn_vpl VALUES ("LK23_52","072_23_52","LUK","23","52","52","Kamhan minkarini iza kan Pilato kay minbaid iza ka pagkawa ka lawas ni Hisos. ");
INSERT INTO mmn_vpl VALUES ("LK23_53","072_23_53","LUK","23","53","53","Mintogot si Pilato. Kamhan minkawa si Hosi ka lawas ni Hisos doro ka kros. Kamhan inkomotan naiza ka mga panapton nga mapoti. Kamhan inhinang naiza ya batasan na mga Yodayo nga inlebeng doro ka hininang nga talangban nga isang lebnganan. Anipen kalebngi ini ka tao. ");
INSERT INTO mmn_vpl VALUES ("LK23_54","072_23_54","LUK","23","54","54","Pagkakamhan kaiza delem di. Pagkasalep ka na sega kaan ani ya pagsogod ka Sabado nga tigpahimlay na mga Yodayo. ");
INSERT INTO mmn_vpl VALUES ("LK23_55","072_23_55","LUK","23","55","55","Kamhan ya mga babazi nga nangiba kan Hisos garing ka Galiliya ngarini ka Hirosalem minsonod di siran kan Hosi kay anseleng siran kon hain dapita ya inlebngan kan Hisos. Kamhan nakita niran ya pagpabentag ni Hosi ka lawas ni Hisos dizan kaiton. ");
INSERT INTO mmn_vpl VALUES ("LK23_56","072_23_56","LUK","23","56","56","Kamhan min-oli di siran kay an-andam siran daan ka lana nga mahamot daw ya ihaplasay para ka lawas ni Hisos kay ani ya batasan na mga Yodayo. Pagkakamhan niran pag-andam minpahimlay siran kay balaed iton na mga Yodayo. ");
INSERT INTO mmn_vpl VALUES ("LK24_1","072_24_1","LUK","24","1","1","Na, pagkamasiselem ka Domingo pagsidlit ka na sega minpasinged ya mga babazi ngaro ka lebnganan kay dadhen niran ya ihaplasay nga kanirang in-andam. ");
INSERT INTO mmn_vpl VALUES ("LK24_2","072_24_2","LUK","24","2","2","Pagdateng niran doro nalingan di baza ya bato nga insira ka pirtahan na lebnganan. ");
INSERT INTO mmn_vpl VALUES ("LK24_3","072_24_3","LUK","24","3","3","Kamhan minseled siran ka talangban nga lebnganan piro wara di sab dalem ya lawas ni Ginoong Hisos. ");
INSERT INTO mmn_vpl VALUES ("LK24_4","072_24_4","LUK","24","4","4","Kamhan nabereng siran kon hain iton. Ka wara pen siran magpanaba waton di ya dowang ka amaama nga nagatindeg dizan ka kanirang sain. Masarang kapoti ya kanirang bado singed ka kalati na sega. ");
INSERT INTO mmn_vpl VALUES ("LK24_5","072_24_5","LUK","24","5","5","Kamhan mindoko dazon ya mga babazi kay nangahaldek gazed siran kon sin-o iton. Kamhan minlaong ya dowang ka amaama nga kay ono sa nga impangitan sa mazo ya tao nga bohi dini ka lebnganan? Wara iza dini kay nabohi di iza pagbalik garing ka mga patay. ");
INSERT INTO mmn_vpl VALUES ("LK24_6","072_24_6","LUK","24","6","6","Magtaremdem kamo ka toong inlaong kamazo ka doro pen iza ka Galiliya ");
INSERT INTO mmn_vpl VALUES ("LK24_7","072_24_7","LUK","24","7","7","nga nagalaong nga iated iza dizan ka mga maongang tao. Kamhan pamagpatazen iza doro ka kros. Pagdateng ka ikatolong aldaw magabohien iza na Diyos pagbalik garing ka mga patay. Ani ini ya impanaba niran ka mga babazi. ");
INSERT INTO mmn_vpl VALUES ("LK24_8","072_24_8","LUK","24","8","8","Kamhan nakataremdem gazed ya mga babazi ka mga panaba ni Hisos kaniran. ");
INSERT INTO mmn_vpl VALUES ("LK24_9","072_24_9","LUK","24","9","9","Min-oli dazon siran kay panan-ogan niran ya mga sinarigan ni Hisos nga napolo may isa siran daw ya tanan mga kaibahan mahitenged ka kanirang naazihan kazina doro ka lebnganan. ");
INSERT INTO mmn_vpl VALUES ("LK24_10","072_24_10","LUK","24","10","10","Ya ngaran naitong mga babazi ani si Mariya nga taga Magdala daw si Zohana daw si Mariya nga ina ni Santiago. Sirang tolo daw ya mga iba nga babazi nga kaibahan niran, ani ya minpanan-og kaiza dizan ka mga sinarigan ni Hisos ");
INSERT INTO mmn_vpl VALUES ("LK24_11","072_24_11","LUK","24","11","11","piro wara magtoo. Silaong niran nga binoang ya impanaba na mga babazi agon wara siran magtoo ka kanirang saba. ");
INSERT INTO mmn_vpl VALUES ("LK24_12","072_24_12","LUK","24","12","12","Kamhan minhinalit si Pidro pagtindeg. Kamhan mindalagan ngaro ka talangban nga lebnganan kan Hisos. Minpongko iza ka pag-irab dalem kaiton. Kamhan nakita matood naiza ya mga panapton nga mapoti nga impotos ka lawas ni Hisos kay anikay nabilin dalem. Kamhan min-oli di iza. Nabereng gazed iza kon naono sa gazed wani? ");
INSERT INTO mmn_vpl VALUES ("LK24_13","072_24_13","LUK","24","13","13","Na, dizan ka dalan nga mingaring ka Hirosalem may dowang ka sakop ni Hisos nagapasinged siran ngaro ka bariyo nga inngaranan ka Imayas. Napolo may isang ka kilomitro ya kaaro garing ka Hirosalem. ");
INSERT INTO mmn_vpl VALUES ("LK24_14","072_24_14","LUK","24","14","14","Namaglaonglaong sirang dowa mahitenged ka pagpatay na mga tao kan Hisos doro ka Hirosalem. ");
INSERT INTO mmn_vpl VALUES ("LK24_15","072_24_15","LUK","24","15","15","Ka nagalaonglaong pen siran minkandizan si Hisos kaniran daw min-iba kaniran pagpanaw. ");
INSERT INTO mmn_vpl VALUES ("LK24_16","072_24_16","LUK","24","16","16","Nakita niran iza nga tao piro wara gazed siran makakilala nga si Hisos iton. ");
INSERT INTO mmn_vpl VALUES ("LK24_17","072_24_17","LUK","24","17","17","Kamhan nangotana iza kaniran nga ono sa ya inlaonglaongan mazo koman ka pagpanaw mazo? Minheneng siran pagpanaw. Masarang kabeg-at ya kanirang hinawa. ");
INSERT INTO mmn_vpl VALUES ("LK24_18","072_24_18","LUK","24","18","18","Kamhan minsambag ya isa nga si Kolopasa ya ngaran nga nabereng gazed hao kay iko ka sa ya bisita ka Hirosalem nga wara pen mahagdam ka inhinang na mga tao kan Hisos doro kaiza nga mga aldaw. ");
INSERT INTO mmn_vpl VALUES ("LK24_19","072_24_19","LUK","24","19","19","Nangotana si Hisos nga ono sa baza wani inlaong mazo? Minsambag siran nga si Hisos nga taga Nazarit propita gazed iza garing ka Diyos. Madazaw gazed ya toong mga inhinang. Labaw ka gahem ya toong mga panaba. Minkilala ya tanan mga tao nga garing iza ka Diyos kay minpamatood ya Diyos ka toong mga inhinang. ");
INSERT INTO mmn_vpl VALUES ("LK24_20","072_24_20","LUK","24","20","20","Piro in-ated iza na kanaming mga oloolo dizan ka mga taga Roma nga nagahari ka kantang hel-anan. Kamhan impahamtangan iza niran ka pagkapatay. Kamhan impalansang iza ka kros. ");
INSERT INTO mmn_vpl VALUES ("LK24_21","072_24_21","LUK","24","21","21","In-alam kontana nami nga iza gazed ya antabang kanami ka pagpaiwat ka mga taga Roma dini ka kanaming lopa. Silaong nami nga iza ya makalibri kanami nga mga kaliwatan ni Israil. Ambaza kay impatay iza. Ikatlo ding aldaw koman sokad ka iton. ");
INSERT INTO mmn_vpl VALUES ("LK24_22","072_24_22","LUK","24","22","22","Kamhan may mga babazi nga kaibahan nami nabereng kami ka inlaong niran kazina kay minboas koni siran pagbisita ka lebnganan ni Hisos ");
INSERT INTO mmn_vpl VALUES ("LK24_23","072_24_23","LUK","24","23","23","piro wara dizan ya toong lawas. Pagbalik niran kanami minlaong siran nga may nakita niran garing ka Diyos. Dizan ka pagkita niran waton ya dowang ka sinogo nga garing ka Diyos nagalaong nga nabohi di si Hisos garing ka mga patay. ");
INSERT INTO mmn_vpl VALUES ("LK24_24","072_24_24","LUK","24","24","24","Kamhan min-ariari ya kanaming kaibahan ka paglargo ka talangban nga lebnganan kan Hisos. Kamhan ya nakitan niran dizan singed iton ka inlaong na mga babazi kay wara gazed ya lawas ni Hisos dizan. ");
INSERT INTO mmn_vpl VALUES ("LK24_25","072_24_25","LUK","24","25","25","Minsambag si Hisos kaniran nga kay ono sang magakalibeg sa kamo? Hasta ono sang magadowadowa sa kamo ka pagtoo ka tanan mga inlaong na mga karaang propita? ");
INSERT INTO mmn_vpl VALUES ("LK24_26","072_24_26","LUK","24","26","26","Kay minpanaba siran daan nga si Kristo nga hari nga pinili na Diyos kinahanglan an-azi iza ka masiet nga kalised hon-a ka toong pagkahari. ");
INSERT INTO mmn_vpl VALUES ("LK24_27","072_24_27","LUK","24","27","27","Kamhan impasabot ni Hisos kaniran ya tanan mga kasoyatan mahitenged kanangiza. Minsogod iza dizan ka mga sinoyat ni Moysis daw ya mga karaang propita na Diyos ka pagpasabot kaniran. ");
INSERT INTO mmn_vpl VALUES ("LK24_28","072_24_28","LUK","24","28","28","Pagkakamhan kaiza mindateng siran ka bariyo nga Imayas nga kanirang datnganan. Kamhan ambelag kontana si Hisos kaniran ");
INSERT INTO mmn_vpl VALUES ("LK24_29","072_24_29","LUK","24","29","29","piro inhawidan iza niran daw nagalaong nga magkolang ko naa dini kanami kay basi makahabzenan di ko. Kamhan minpanik iza iba kaniran dizan ka lagkaw. ");
INSERT INTO mmn_vpl VALUES ("LK24_30","072_24_30","LUK","24","30","30","Pagpanihapon pen niran minporot si Hisos ka pan. Pagkakamhan naiza pagpasalamat ka Diyos minpanipaktipak iza ka pan. Kamhan impanhatag kaniran. ");
INSERT INTO mmn_vpl VALUES ("LK24_31","072_24_31","LUK","24","31","31","Kamhan singed ka nakaimata dazon ya kanirang mata. Minkilala gazed nga si Hisos ini! Kamhan nawara dazon iza dizan ka pagkita niran. ");
INSERT INTO mmn_vpl VALUES ("LK24_32","072_24_32","LUK","24","32","32","Namaglaonglaong siran nga si Hisos matood iton kay malinaw gazed ya kantang hinawa kazina ka pagpanaba naiza kanta dizan ka dalan daw pagpasabot naiza kanta ka kasoyatan na Diyos. ");
INSERT INTO mmn_vpl VALUES ("LK24_33","072_24_33","LUK","24","33","33","Kamhan min-ariari siran pagbalik ka Hirosalem. Pagdateng niran dizan minpanik siran dizan ka lagkaw nga intambongan na mga sinarigan ni Hisos nga napolo may isa siran daw ya mga iba nga tao dizan kaniran. ");
INSERT INTO mmn_vpl VALUES ("LK24_34","072_24_34","LUK","24","34","34","Pagseled niran ka lagkaw inlong-an siran paghon-a nga nabohi matood ya Ginoo garing ka mga patay kay minpakita iza kan Simon. ");
INSERT INTO mmn_vpl VALUES ("LK24_35","072_24_35","LUK","24","35","35","Kamhan inpanan-og nirang dowa ya naazihan niran dizan ka dalan daw ya pagkilala niran kan Ginoong Hisos pagpanipaktipak naiza ka pan. ");
INSERT INTO mmn_vpl VALUES ("LK24_36","072_24_36","LUK","24","36","36","Ka pagpanaba pen niran minkarini si Hisos tenged kanirang tanan. Minlaong iza kaniran nga palinawen di mazo ya kamazong hinawa. ");
INSERT INTO mmn_vpl VALUES ("LK24_37","072_24_37","LUK","24","37","37","Inkelbaan siran ka pagpangahaldek. Silaong niran nga pooy di ini nga minbotho dakoza kaniran! ");
INSERT INTO mmn_vpl VALUES ("LK24_38","072_24_38","LUK","24","38","38","Kamhan minlaong si Hisos nga kay ono sang nabereng sa kamo? Kay ono sang nagakadowadowa sa kamo kon sin-o sa hao? ");
INSERT INTO mmn_vpl VALUES ("LK24_39","072_24_39","LUK","24","39","39","Selengi mazo ya palad na kanaong alima daw paa. Hao matood ini nga si Hisos. Maghogam naa kamo kanao dazaw mahagdam kamo nga kanaong lawas gazed ini. Diri kon singed ka pooy nga waray kindal daw mga bekeg. ");
INSERT INTO mmn_vpl VALUES ("LK24_40","072_24_40","LUK","24","40","40","Kamhan impakita naiza kaniran ya toong mga alima daw paa. ");
INSERT INTO mmn_vpl VALUES ("LK24_41","072_24_41","LUK","24","41","41","Kamhan nagasaza siran piro singed ka nagadowadowa pen siran kon si Hisos ini kon diri. Kamhan nangotana si Hisos kaniran nga daw wadini ya sinen-ad mazo? ");
INSERT INTO mmn_vpl VALUES ("LK24_42","072_24_42","LUK","24","42","42","Kamhan inhatagan iza niran ka geramay nga onod na isda nga inhalob niran. ");
INSERT INTO mmn_vpl VALUES ("LK24_43","072_24_43","LUK","24","43","43","Pagdawat ka naiza inkaen naiza iton dizan ka pagseleng niran. ");
INSERT INTO mmn_vpl VALUES ("LK24_44","072_24_44","LUK","24","44","44","Kamhan minlaong iza nga mintoman di ya mga panaba nao kamazo ka pag-ibaiba pen nao kamazo kay kinahanglan matoman gazed ya tanan mga insoyat ni Moysis mahitenged kanao daw ya mga sinoyat na mga karaang propita daw mga insoyat ni Dabid inngaranan ka Salmo. ");
INSERT INTO mmn_vpl VALUES ("LK24_45","072_24_45","LUK","24","45","45","Kamhan minpawa si Hisos ka kanirang mga otok dazaw makasabot siran ka kasoyatan na Diyos. ");
INSERT INTO mmn_vpl VALUES ("LK24_46","072_24_46","LUK","24","46","46","Kamhan indogangan pen naiza pagpanaba kaniran nga impasoyat daan na Diyos nga nagalaong nga si Kristo nga hari nga pinili nao kinahanglan an-azi iza ka masiet nga kalised. Pagdateng ka ikatolong aldaw mabohi iza pagbalik garing ka lebeng. ");
INSERT INTO mmn_vpl VALUES ("LK24_47","072_24_47","LUK","24","47","47","Kamhan iwali gazed ya toong sindo maglaong nga bizaan na mga tao ya kanirang mga sala dazaw pasaylohon siran na Diyos. Walihan ya mga taga Hirosalem paghon-a kamhan walihan pen doro ka tibolos kalibotan. ");
INSERT INTO mmn_vpl VALUES ("LK24_48","072_24_48","LUK","24","48","48","Na, kamo nga kanaong mga sinarigan, kamo ya nakasaksi ka pagtoman naini nga tanan. ");
INSERT INTO mmn_vpl VALUES ("LK24_49","072_24_49","LUK","24","49","49","Panabaan ta kamo nga ipakarimbaba nao kamazo ya Madazaw nga Ispirito nga insaad na Ama nao kamazo. Maghela kamo dini ka Hirosalem hangtod ka paghari naini nga Ispirito kamazo. Kamhan may gahem mazo ka pagsindo ka mga tao mahitenged kanao. ");
INSERT INTO mmn_vpl VALUES ("LK24_50","072_24_50","LUK","24","50","50","Pagkakamhan ni Hisos pagpanaba kaniran impaiba naiza siran ngaro ka gawas na siyodad keteb ka bariyo nga Bitani. Pagdateng ka niran dizan minbakzaw si Hisos ka toong alima tenged kaniran kay ampanarangin iza kaniran ka madazaw. ");
INSERT INTO mmn_vpl VALUES ("LK24_51","072_24_51","LUK","24","51","51","Ka nagapanarangin pen iza kaniran nabohat iza ngandaked ka langit pagbelag kaniran. ");
INSERT INTO mmn_vpl VALUES ("LK24_52","072_24_52","LUK","24","52","52","Kamhan pagbalik niran ka Hirosalem malinaw gazed ya hinawa niran. ");
INSERT INTO mmn_vpl VALUES ("LK24_53","072_24_53","LUK","24","53","53","Kada aldaw dizan ka dakolang lagkaw nga pangamozoanan ka Diyos insaza niran ya Diyos.");
INSERT INTO mmn_vpl VALUES ("JN1_1","073_1_1","JHN","1","1","1","Kawandini pen dogay di ka wara pen mahinang ya bisan ono, daan di ya inngaranan ka Saba na Diyos kay nagapakahagdam iza kon ono ya hena-hena na Diyos. Kamhan iza daw ya Diyos nagakatibe siran. Iza gazed ani ya matood nga Diyos. ");
INSERT INTO mmn_vpl VALUES ("JN1_2","073_1_2","JHN","1","2","2","Iza daw ya Diyos nagakatibe siran sokad pen gazed ka sinogdan. ");
INSERT INTO mmn_vpl VALUES ("JN1_3","073_1_3","JHN","1","3","3","Kamhan iza ya maghinangay ka bisan ono ya impahinang na Diyos kay kon wara iza diri mahinang ya bisan ono. ");
INSERT INTO mmn_vpl VALUES ("JN1_4","073_1_4","JHN","1","4","4","Kamhan iza isab ya tag-iza ka bag-ong kinabohi nga diri mawara. Kamhan iton nga kinabohi ani ya makakawa ka kadeglem dalem ka hena-hena na tanan mga tao. ");
INSERT INTO mmn_vpl VALUES ("JN1_5","073_1_5","JHN","1","5","5","Kamhan iza nga tag-iza ka kinabohi ani isab ya kapawa nga makakawa ka kadeglem dini ka kalibotan. Kamhan diri mahimo pagdeglem ya kapawa. ");
INSERT INTO mmn_vpl VALUES ("JN1_6","073_1_6","JHN","1","6","6","Na, may tao nga inngaranan kan Howan. Insogo iza na Diyos ngarini ");
INSERT INTO mmn_vpl VALUES ("JN1_7","073_1_7","JHN","1","7","7","dazaw anpanan-og iza ka mga tao nga si Hiso Kristo ani ya matood nga kapawa dazaw antoo sirang tanan. ");
INSERT INTO mmn_vpl VALUES ("JN1_8","073_1_8","JHN","1","8","8","Iton nga tao nga si Howan diri kon iza ya kapawa kay iza hinoa ya nagapakahagdam ka mga tao kon sin-o ya kapawa. ");
INSERT INTO mmn_vpl VALUES ("JN1_9","073_1_9","JHN","1","9","9","Kay domatengay si Hiso Kristo nga matood nga kapawa kay iza ya makakawa ka kadeglem dalem ka hena-hena na tanan mga tao. ");
INSERT INTO mmn_vpl VALUES ("JN1_10","073_1_10","JHN","1","10","10","Pagdateng naiza dini ka kalibotan wara makakilala ya mga tao kanangiza bisan iza ya minhinang ka tibolos kalibotan. ");
INSERT INTO mmn_vpl VALUES ("JN1_11","073_1_11","JHN","1","11","11","Pagdateng naiza ka toong kaogaringeng longsod imbogaw iza na toong kaibahan. ");
INSERT INTO mmn_vpl VALUES ("JN1_12","073_1_12","JHN","1","12","12","Piro may mga iba nga tao nga mintoo nga si Kristo gazed iza. Kamhan minpasakop siran kanangiza. Kamhan inhinang naiza nga siran di ya mga maanak na Diyos. ");
INSERT INTO mmn_vpl VALUES ("JN1_13","073_1_13","JHN","1","13","13","Ya pagkamaanak niran garing iton ka inhinang na Diyos, diri kon garing ka inhinang na tao pagpaliwat. ");
INSERT INTO mmn_vpl VALUES ("JN1_14","073_1_14","JHN","1","14","14","Na, si Kristo natao iza dazaw nahitibe iza dimbaba kanta kay dakola ya kalooy naiza ka mga tao. Kamhan polos matood ya toong panaba. Nakita nami nga madazaw ya batasan ni Kristo kay ya batasan naiza daw ya toong Ama mag-anika kay bogtong Maanak na Diyos si Kristo. ");
INSERT INTO mmn_vpl VALUES ("JN1_15","073_1_15","JHN","1","15","15","Iza ya impanan-og ni Howan kay dizan ka mga tao minbaskeg si Howan ka toong paghawag nga nagalaong nga wani di koman ya tao nga impanan-og nao kamazo nga ya ansonod pen kanao labaw gazed iza kanao kay ka wara pen hao matao daan ka iza nga bohi. ");
INSERT INTO mmn_vpl VALUES ("JN1_16","073_1_16","JHN","1","16","16","Maloozon iza kamhan madazaw gazed ya indawat naming tanan garing kanangiza. ");
INSERT INTO mmn_vpl VALUES ("JN1_17","073_1_17","JHN","1","17","17","Inhatag ni Moysis kanta ya daan balaed na Diyos kamhan si Kristo ani nagapasabot kanta nga dakola ya kalooy na Diyos kanta. Kamhan polos matood ya toong panaba. ");
INSERT INTO mmn_vpl VALUES ("JN1_18","073_1_18","JHN","1","18","18","Waray nakakita ka Diyos sokad. Kamhan ya toong bogtong Maanak ani nagapasabot kanta kon ono ya hena-hena na Diyos kay nagakatibe siran daan paghela daked ka langit. ");
INSERT INTO mmn_vpl VALUES ("JN1_19","073_1_19","JHN","1","19","19","Na, ka nagapanan-og pen si Howan ka mga tao mahitenged kan Kristo nalibeg ya mga Yodayo kon si Kristo kon si Howan iton. Kamhan ya mga oloolo na mga Yodayo dini ka Hirosalem minpadara siran ka mga pari daw ya mga Libita doro kan Howan dazaw pangotanhen kon sin-o sa iza. ");
INSERT INTO mmn_vpl VALUES ("JN1_20","073_1_20","JHN","1","20","20","Kamhan madazaw ya sambag ni Howan nagalaong nga si Howan hao. Lain gazed si Kristo nga hari nga pinili na Diyos. Diri gazed kon hao iza. ");
INSERT INTO mmn_vpl VALUES ("JN1_21","073_1_21","JHN","1","21","21","Kamhan nangotana siran daw sin-o sa ko? Daw iko si Iliyas nga karaang propita na Diyos? Minsambag iza nga diri kon hao iton. Kamhan nangotana siran pag-isab daw iko ya propita nga kanaming intagadan? Minsambag si Howan nga diri kon hao iton. ");
INSERT INTO mmn_vpl VALUES ("JN1_22","073_1_22","JHN","1","22","22","Kamhan minlaong siran nga panan-ogan mo kami kon sin-o sa iko dazaw may ikasambag nami dizan ka mga minsogo kanami. Ono sa ya ikapanaba mo mahitenged ka kanmong kaogaringen? ");
INSERT INTO mmn_vpl VALUES ("JN1_23","073_1_23","JHN","1","23","23","Kamhan minsambag si Howan nga hao di ya maghawagay ka mga tao doro ka kamingawan nga nagalaong nga dazawen mazo ya kamazong batasan singed ka tao nga minhinglo ka dalan kay domatengay di ya Maanak na Diyos. Ani ini ya pagtoman na daan soyat ni Isayas mahitenged kanao. ");
INSERT INTO mmn_vpl VALUES ("JN1_24","073_1_24","JHN","1","24","24","Kamhan dizan disab may mga mataed nga maistro ka tinoohan na mga Yodayo. Parasiyo ya ngaran niran. ");
INSERT INTO mmn_vpl VALUES ("JN1_25","073_1_25","JHN","1","25","25","Kamhan minlaong siran kan Howan nga mated minlaong ko nga diri kon si Kristo iko, diri kon si Iliyas iko, diri kon iko ya propita nga kanaming intagadan agon kay ono sa nga nagapamenzag sa ko ka mga tao? ");
INSERT INTO mmn_vpl VALUES ("JN1_26","073_1_26","JHN","1","26","26","Minsambag si Howan nga hao ya nagapamenzag ka mga tao ka sapa kamhan dakoza ka tenged mazo mindateng di ya isa nga tao nga wara kamo mahagdam kon sin-o sa iza. ");
INSERT INTO mmn_vpl VALUES ("JN1_27","073_1_27","JHN","1","27","27","Bisan mindateng iza sonod kanao iza ya labaw gazed. Kamhan dizan kanangiza hao ya labing obos kay iza gazed ya labaw ka gahem. Ani ini ya insambag ni Howan ka mga Parasiyo ");
INSERT INTO mmn_vpl VALUES ("JN1_28","073_1_28","JHN","1","28","28","ka doro pen iza ka longsod nga Bitani dipi ka sapa nga Hordan nga benzaganan naiza ka mga tao. ");
INSERT INTO mmn_vpl VALUES ("JN1_29","073_1_29","JHN","1","29","29","Pagsonod nga ka aldaw nakita ni Howan si Hisos nga nagapasinged ngarini kanangiza. Kamhan minlaong si Howan nga kilalhen mazo iza nga inngaranan ka Nati na Karniro nga impakapatay na Diyos dazaw mawaraan ka sala ya tanan mga tao. ");
INSERT INTO mmn_vpl VALUES ("JN1_30","073_1_30","JHN","1","30","30","Iza ya impanan-og nao kamazo nagalaong nga may isang tao nga andateng sonod kanao. Dizan kanangiza hao ya labing obos kay ka wara pen hao matao daan ka iza nga bohi. ");
INSERT INTO mmn_vpl VALUES ("JN1_31","073_1_31","JHN","1","31","31","Izang mahon-a pen wara hao mahagdam kon sin-o iza. Kamhan impamenzagan nao ya mga tao nga kaliwatan ni Israil dazaw mahagdam siran nga domatengay di ya Maanak na Diyos. ");
INSERT INTO mmn_vpl VALUES ("JN1_32","073_1_32","JHN","1","32","32","Kamhan indogangan pen ni Howan paglaong kaniran mahitenged kan Hisos nga mindateng di matood iza kay pagkakamhan nao pagbenzag kanangiza nakitan nao ya Madazaw nga Ispirito nga garing ka Diyos nga minkarimbaba daw minhapon dizan kanangiza. Minpasingedsinged iton ka salapati. ");
INSERT INTO mmn_vpl VALUES ("JN1_33","073_1_33","JHN","1","33","33","Izang mahon-a pen wara pen hao mahagdam kon sin-o iza piro impanan-ogan hao daan na Diyos nga nagalaong nga pagpamenzag mo ka mga tao kay-an makitan mo ya isang tao nga inhaponan na Madazaw nga Ispirito nga garing kanao. Minpasingedsinged iton ka salapati. Kamhan ya tao nga inhaponan ani ya magbenzag ka mga tao ka Madazaw nga Ispirito nga garing kanao dazaw paharian siran naiza nga Ispirito. Ani ini ya pagpanaba na Diyos kanao nga si Howan. ");
INSERT INTO mmn_vpl VALUES ("JN1_34","073_1_34","JHN","1","34","34","Na, nakitan di nao iton nga tao nga pinili na Diyos. Kamhan iza matood ya Maanak na Diyos. ");
INSERT INTO mmn_vpl VALUES ("JN1_35","073_1_35","JHN","1","35","35","Pagsonod nga ka aldaw dizan di isab si Howan iba ka toong mga sakop nga dowa siran. ");
INSERT INTO mmn_vpl VALUES ("JN1_36","073_1_36","JHN","1","36","36","Kamhan minseleng si Howan kan Hisos nga nagalabay dizan kaniran. Kamhan minlaong iza nga waza ngaro ya Nati na Karniro nga impakapatay na Diyos. ");
INSERT INTO mmn_vpl VALUES ("JN1_37","073_1_37","JHN","1","37","37","Pagpakabati ka na mga sakop ni Howan kaiza minsonod sirang dowa kan Hisos. ");
INSERT INTO mmn_vpl VALUES ("JN1_38","073_1_38","JHN","1","38","38","Paglingi ni Hisos nakakita iza kanirang dowa nga nagasonod kanangiza. Kamhan minpangotana iza kaniran nga daw ono kombeet ya pagakinahanglanen mazo kanao? Minsambag siran nga Maistro, daw hain ko maghela? ");
INSERT INTO mmn_vpl VALUES ("JN1_39","073_1_39","JHN","1","39","39","Minsambag si Hisos nga mamanaw di kita ngaro dazaw mahagdam kamo. Kamhan min-iba siran kan Hisos ngaro ka toong inhel-an. Kamhan namagloon pen siran pagkolang dakoza kay nadelem ya sega. ");
INSERT INTO mmn_vpl VALUES ("JN1_40","073_1_40","JHN","1","40","40","Na, ya isa nga nakabati kan Howan si Andris ya ngaran. Kamhan min-iba di iza kan Hisos. Maglomon iza daw si Simon Pidro. ");
INSERT INTO mmn_vpl VALUES ("JN1_41","073_1_41","JHN","1","41","41","Kamhan nagapangita iza pagdali ka toong lomon nga si Simon kay inlaong nga nakitan nami ya Misayas. Na, ya kahologan na ngaran nga Misayas ani si Kristo nga hari nga pinili na Diyos. ");
INSERT INTO mmn_vpl VALUES ("JN1_42","073_1_42","JHN","1","42","42","Pagkakamhan ni Andris pagpanaba kan Simon in-iba pen naiza si Simon ngaro kan Hisos. Pagdateng niran doro minseleng si Hisos kan Simon. Kamhan minlaong iza nga iko si Simon nga maanak ni Howan kamhan anngaran hao kanmo kan Sipas. Na, ya ngaran nga si Sipas daw si Pidro mag-anika. Na, ya kahologan na ngaran nga Pidro ani ya dakolang bato. ");
INSERT INTO mmn_vpl VALUES ("JN1_43","073_1_43","JHN","1","43","43","Pagsonod nga ka aldaw minkaro si Hisos ka lopa nga Galiliya. Kamhan si Pilipo ani ya nakitan naiza. Kamhan minlaong iza nga somakop ko kanao. ");
INSERT INTO mmn_vpl VALUES ("JN1_44","073_1_44","JHN","1","44","44","Taga Bitsayda si Pilipo. Anisab ya kaogaringeng longsod ni Andris daw si Pidro. ");
INSERT INTO mmn_vpl VALUES ("JN1_45","073_1_45","JHN","1","45","45","Pagkakamhan kaiza nangita si Pilipo kan Nataniyal kay minlaong nga wadini di kanta ya isang tao. Kamhan iza ya impanan-og ni Moysis dizan ka basahen nga mga daan balaed na Diyos daw dizan ka mga soyat na mga karaang propita na Diyos. Si Hisos iza nga maanak ni Hosi nga taga Nazarit. ");
INSERT INTO mmn_vpl VALUES ("JN1_46","073_1_46","JHN","1","46","46","Minsambag si Nataniyal nga geramay ya longsod nga Nazarit kamhan waray polos ya taga dizan kaiton. Minsambag si Pilipo nga mag-iba kita naa ngaro dazaw ankita ko kanangiza. ");
INSERT INTO mmn_vpl VALUES ("JN1_47","073_1_47","JHN","1","47","47","Pagkita ni Hisos kan Nataniyal nga minkarini di minlaong si Hisos nga wani ngarini kanao ya matood nga kaliwat ni Israil. Matadeng gazed ya toong batasan. ");
INSERT INTO mmn_vpl VALUES ("JN1_48","073_1_48","JHN","1","48","48","Minsambag si Nataniyal nga ono sa nga nakakilala sa ko kanao? Minsambag si Hisos nga ka wara pen ko hawaga ni Pilipo nakitan nao iko dizan ka tenged na tanem ani ngaran ya igira. ");
INSERT INTO mmn_vpl VALUES ("JN1_49","073_1_49","JHN","1","49","49","Minsambag si Nataniyal nga Maistro, iko matood ya Maanak na Diyos. Iko matood ya hari nga pinili na Diyos ka mga taga Israil! ");
INSERT INTO mmn_vpl VALUES ("JN1_50","073_1_50","JHN","1","50","50","Minsambag si Hisos nga Nataniyal, daw mintoo iko kanao kay impanaba nao nga nakitan nao iko dizan ka tenged na tanem nga igira? Labaw pen gazed kay-an ya nakitan mo nga kanaong mga hinang. ");
INSERT INTO mmn_vpl VALUES ("JN1_51","073_1_51","JHN","1","51","51","Indogangan pen ni Hisos paglaong nga timan-an mo gazed ini. Ya tood nao ka pagdateng dini kamazo impasabot nao kamazo kon ono ya inhena-hena na Diyos. Kamhan singed ka naabri di ya langit. Kamhan hao nga si Hisos singed hao ka hagdan dimbaba nga nakadateng daked ka hel-anan na Diyos. Kamhan ya mga taga langit nga sinogo nao magakandaked siran garing kanao. Kamhan magakarimbaba siran kanao kay hao gazed ya mahon-a ka bisan sin-o ya mahon-ang tao. ");
INSERT INTO mmn_vpl VALUES ("JN2_1","073_2_1","JHN","2","1","1","Pagdateng ka ikatlong aldaw may kombiti ka pagpangasawa doro ka bariyo nga Kana doro ka Galiliya. Kamhan ya ina ni Hisos dinapit iza. ");
INSERT INTO mmn_vpl VALUES ("JN2_2","073_2_2","JHN","2","2","2","Mga dinapit disab si Hisos daw ya toong mga sakop. ");
INSERT INTO mmn_vpl VALUES ("JN2_3","073_2_3","JHN","2","3","3","Ka nagakaen pen siran inkabsan di ya bino nga imnenen na mga magkombitihay. Kamhan ya ina ni Hisos minlaong kanangiza nga nahodtan di siran ka bino. ");
INSERT INTO mmn_vpl VALUES ("JN2_4","073_2_4","JHN","2","4","4","Minsambag si Hisos nga Ina, hao ka magaponto kon kon-o hao magtabang kaniran. ");
INSERT INTO mmn_vpl VALUES ("JN2_5","073_2_5","JHN","2","5","5","Kamhan minlaong ya toong ina ka mga sogoonon nga bisan ono ya ipansogo naiza kamazo magtoman kamo. ");
INSERT INTO mmn_vpl VALUES ("JN2_6","073_2_6","JHN","2","6","6","Na, dizan ka lagkaw nga kombitihanan may mga dakolang tadzaw nga enem nga ka bolos. Ya leen na tagsa tagsa taglimang ka taro nga sapa. Kay inhinang na mga Yodayo ya batasan na mga karaang Yodayo nga ka wara pen makakaen ya mga tao kinahanglan bo-boan ka sapa ya kanirang mga alima. ");
INSERT INTO mmn_vpl VALUES ("JN2_7","073_2_7","JHN","2","7","7","Kamhan minsogo si Hisos ka mga sogoonon nga pon-on mazo ya mga tadzaw ka sapa. Kamhan nanag-eb dazon siran dazaw ihalin ya sapa keteb ka pagkapono na mga tadzaw. ");
INSERT INTO mmn_vpl VALUES ("JN2_8","073_2_8","JHN","2","8","8","Kamhan minsogo si Hisos nga tigisan mo ya magsen-aday dazaw iza ya amporba pag-inem. Kamhan intigisan niran iza. ");
INSERT INTO mmn_vpl VALUES ("JN2_9","073_2_9","JHN","2","9","9","Pagtilaw naiza ka sapa ambaza kay bino di sa baza iton. Wara iza mahagdam kon hain garing ya bino piro mahagdam ya mga sogoonon kay siran ya minsag-eb kazina. Kamhan impakarini na magsen-aday ya banahen. ");
INSERT INTO mmn_vpl VALUES ("JN2_10","073_2_10","JHN","2","10","10","Kay minlaong iza nga ya batasan na mga nagakombiti ani inhon-a pag-inem ya masarang kadazaw nga bino. Kon dakola di ya pag-inem na mga tao anipen ihatag ya matab-ang. Kamhan ya kanmong batasan inmahori di hinoa ya madazaw nga bino. ");
INSERT INTO mmn_vpl VALUES ("JN2_11","073_2_11","JHN","2","11","11","Ani ini ya primirong dakolang inhinang ni Hisos doro ka bariyo nga Kana doro ka Galiliya. Kay impasabot naiza kaniran nga dakola ya toong gahem nga garing ka Diyos. Kamhan ya toong mga sakop mintoo di siran nga garing iza ka Diyos. ");
INSERT INTO mmn_vpl VALUES ("JN2_12","073_2_12","JHN","2","12","12","Pagkakamhan kaiza minkandilod si Hisos ka longsod nga Kapirnaom. Nangiba disab ya toong ina daw mga manghod daw mga sakop. Diri kon madogay ya pagpabilin niran doro. ");
INSERT INTO mmn_vpl VALUES ("JN2_13","073_2_13","JHN","2","13","13","Na, kada toig antaremdem ya mga Yodayo ka paglibri na Diyos ka kanirang mga karaan ka pagkaoripen pen niran doro ka lopa nga Ihipto. Kamhan ya batasan niran ka pagtaremdem ka pista mangihaw siran ka mga nati na karniro. Agon minkaro si Hisos ka siyodad nga Hirosalem nga ani say logar nga pistahanan niran. ");
INSERT INTO mmn_vpl VALUES ("JN2_14","073_2_14","JHN","2","14","14","Pagdateng naiza ka dakolang lagkaw nga pangamozoanan ka Diyos nakitan naiza ya mga mamaligzaay ka mga baka daw mga karniro daw mga salapati. Kay inhinang na mga Yodayo ya kanirang batasan nga magahalad ka mga ihazep paghawag niran ka Diyos. Nakitan isab ni Hisos ya mga Yodayo nga magsilihay ka mga kowarta nga indara na mga taga laing dapit. ");
INSERT INTO mmn_vpl VALUES ("JN2_15","073_2_15","JHN","2","15","15","Kamhan minhinang si Hisos ka ilatosay nga lepes kay bogawen naiza sirang tanan dizan ka lagkaw na Diyos. Impaiwat gazed ya mga karniro daw mga baka. Inzabo sab naiza ya kowarta na mga magsilihay daw impanowad ya kanirang mga lamisa. ");
INSERT INTO mmn_vpl VALUES ("JN2_16","073_2_16","JHN","2","16","16","Kamhan minbaheg iza ka mga magbaligzaay ka mga salapati nga kaw-en sa mazo ya kamazong mga salapati dini! Azaw mazo paghinangen ka taboan ya lagkaw nga pangamozoanan ka kanaong Ama. ");
INSERT INTO mmn_vpl VALUES ("JN2_17","073_2_17","JHN","2","17","17","Kamhan nakataremdem ya toong mga sakop ka daan impasoyat na Diyos nga nagalaong nga Diyos, ya pagbogaw nao ka mga maonga nga tao dizan ka kanmong lagkaw ani ya sinogdan ka pagkontara niran kanao. ");
INSERT INTO mmn_vpl VALUES ("JN2_18","073_2_18","JHN","2","18","18","Kamhan minlaong ya mga Yodayo kan Hisos nga pakitahen mo kami ka timaan dazaw mahagdam kami nga garing ka Diyos ya gahem mo ka pagbogaw ka mga tao dini. ");
INSERT INTO mmn_vpl VALUES ("JN2_19","073_2_19","JHN","2","19","19","Minsambag si Hisos nga ini nga dakolang lagkaw nga pangamozoanan ka Diyos geb-a mazo ini. Kamhan hinangen gazed nao ini pagbag-o ka tolo kang ka aldaw. ");
INSERT INTO mmn_vpl VALUES ("JN2_20","073_2_20","JHN","2","20","20","Minsambag siran nga kap-atan may enem nga ka toig ya paghinang nami kaini nga lagkaw. Onhon sa mo paghinang pagbag-o ka tolong ka aldaw? ");
INSERT INTO mmn_vpl VALUES ("JN2_21","073_2_21","JHN","2","21","21","Na, ani ini ya pamolinged ni Hisos kaniran mahitenged ka toong kaogaringeng lawas ");
INSERT INTO mmn_vpl VALUES ("JN2_22","073_2_22","JHN","2","22","22","kay kay-an patazen iza na mga tao. Kamhan pagdateng ka ikatlong aldaw mabohi iza pagbalik garing ka lebeng. Kon makamhan iton anipen makataremdem ya toong mga sakop kaiza nga pamolinged. Kamhan mintoo siran ka kasoyatan na Diyos daw ya mga panaba ni Hisos. ");
INSERT INTO mmn_vpl VALUES ("JN2_23","073_2_23","JHN","2","23","23","Na, dizan ka Hirosalem nakapamista pen ya mga Yodayo. Kamhan mataed ya mga mintoo kan Hisos pagkita niran ka mga dakolang inhinang naiza. ");
INSERT INTO mmn_vpl VALUES ("JN2_24","073_2_24","JHN","2","24","24","Kamhan diri si Hisos ansarig kaniran. ");
INSERT INTO mmn_vpl VALUES ("JN2_25","073_2_25","JHN","2","25","25","Kay nahagdam iza daan kon ono ya inhena-hena na tanan mga tao. Kamhan waray kinahanglan naiza ka tao ka pagpasabot kanangiza ka kanirang inhena-hena kay nahagdam sa iza daan. ");
INSERT INTO mmn_vpl VALUES ("JN3_1","073_3_1","JHN","3","1","1","Kamhan may isang oloolo na mga Yodayo si Nikodimo ya ngaran. Parasiyo iza nga nagatoman ka mga balaed na karaang mga Yodayo. ");
INSERT INTO mmn_vpl VALUES ("JN3_2","073_3_2","JHN","3","2","2","Ka isang kahabzen minkarini iza kan Hisos. Kamhan minlaong iza nga Maistro, mahagdam kami nga impakarini ko na Diyos ka pagtoldo kanami kay bisan sin-o nga taohana wara iza nakahimo ka mga inhinang singed kanmo kon wara iza tagi na Diyos ka gahem. ");
INSERT INTO mmn_vpl VALUES ("JN3_3","073_3_3","JHN","3","3","3","Minsambag si Hisos nga timan-an mo gazed ini. Kon diri hinangen na Diyos ya tao pagbag-o diri gazed magkaangay ya tao daw ya Diyos. ");
INSERT INTO mmn_vpl VALUES ("JN3_4","073_3_4","JHN","3","4","4","Nangotana si Nikodimo nga ya malaas nga tao onhon sa na Diyos paghinang pagbag-o? Daw ipaleen pen iza ka tinai na toong ina dazaw matao pag-isab? ");
INSERT INTO mmn_vpl VALUES ("JN3_5","073_3_5","JHN","3","5","5","Minsambag si Hisos nga timan-an mo gazed ini. Kon diri hinangen na Madazaw nga Ispirito na Diyos ya tao pagbag-o diri gazed magkaangay ya tao daw ya Diyos. Iton nga Ispirito singed iza ka sapa nga makahinglo ka hena-hena na tao. ");
INSERT INTO mmn_vpl VALUES ("JN3_6","073_3_6","JHN","3","6","6","Garing ka lawas na tao inhinang gihapon ya lawas na tao pag-anak. Kamhan garing ka Madazaw nga Ispirito na Diyos inhinang gihapon ya kaliwat na Ispirito na Diyos pag-anak. ");
INSERT INTO mmn_vpl VALUES ("JN3_7","073_3_7","JHN","3","7","7","Diri ko magkabereng ka impanaba nao kanmo nga kinahanglan nga hinangen iko na Diyos pagbag-o. ");
INSERT INTO mmn_vpl VALUES ("JN3_8","073_3_8","JHN","3","8","8","Pamolinged ta ko nga ya hangin ani magabeet kon hain azi. Kamhan pag-azi na hangin dizan kanmo nakabati ko piro wara ko mahagdam kon hain garing. Wara ko mahagdam kon hain andateng. Pamolinged ini ka hinang na Madazaw nga Ispirito na Diyos dizan ka tao. ");
INSERT INTO mmn_vpl VALUES ("JN3_9","073_3_9","JHN","3","9","9","Minsambag si Nikodimo nga onhon sa na Diyos paghinang ka tao pagbag-o? ");
INSERT INTO mmn_vpl VALUES ("JN3_10","073_3_10","JHN","3","10","10","Minsambag si Hisos nga nabereng hao kay bisan iko ya maistro na mga kaliwatan ni Israil wara ko makasabot ka intoldo nao kanmo. ");
INSERT INTO mmn_vpl VALUES ("JN3_11","073_3_11","JHN","3","11","11","Ya nahagdaman nami impanaba nami kamazo. Impanan-og sab nami kamazo ya nakitan nami kamhan wara kamo manoo ka kanaming mga panaba. ");
INSERT INTO mmn_vpl VALUES ("JN3_12","073_3_12","JHN","3","12","12","Inpanan-og di nao kanmo mahitenged ka inhinang na tao. Kamhan wara ko magtoo kanao agon onhon sa mo pagtoo kon ampanan-og hao kanmo mahitenged ka inhinang na Diyos? ");
INSERT INTO mmn_vpl VALUES ("JN3_13","073_3_13","JHN","3","13","13","Hao kay mahagdam kon ono ya inhinang na Diyos kay garing daked hao. Kamhan ankandaked isab hao pagbalik kay hao ya mahon-a ka bisan sin-o ya mahon-ang tao. ");
INSERT INTO mmn_vpl VALUES ("JN3_14","073_3_14","JHN","3","14","14","Kawandini pen ka doro pen sin Moysis ka dakolang nag-as impamanga siran na mga halas nga marara. Kamhan inhinang ni Moysis ya bronsi nga singed ka halas ya hitsora. Kamhan inbetang naiza iton dizan ka toko dazaw selengan na mga tao. Kamhan nabahaw matood ya mga tao kon anhangad siran ka bronsi. Pamolinged gazed ini ka kanaong pagkapatay ka kros. ");
INSERT INTO mmn_vpl VALUES ("JN3_15","073_3_15","JHN","3","15","15","Kay garing ka kanaong pagkapatay bisan sin-o ya antoo kanao tagan gazed iza ka bag-ong kinabohi nga diri mawara. ");
INSERT INTO mmn_vpl VALUES ("JN3_16","073_3_16","JHN","3","16","16","Kay dakola gazed ya kalooy na Diyos ka tanan mga tao. Kamhan intagan naiza ka toong bogtong Maanak dazaw bisan sin-o ya antoo kanangiza diri madara ngaro ka impirno basta tagan iza hinoa ka bag-ong kinabohi nga diri mawara. ");
INSERT INTO mmn_vpl VALUES ("JN3_17","073_3_17","JHN","3","17","17","Kay wara ipadara na Diyos ya toong Maanak dini ka kalibotan dazaw silotan ya mga tao. Hinoa tabangan naiza siran dazaw malibri siran kaiton nga silot. ");
INSERT INTO mmn_vpl VALUES ("JN3_18","073_3_18","JHN","3","18","18","Ya tanan tao nga antoo ka Maanak diri silotan piro ya diri antoo kanangiza insilotan di kay wara iza magtoo ka bogtong Maanak na Diyos. ");
INSERT INTO mmn_vpl VALUES ("JN3_19","073_3_19","JHN","3","19","19","Ani ini ya paghokom na Diyos kaniran kay hao nga matood nga kapawa pagdateng nao dini ka kalibotan diri siran maazak kanao. Hinoa impili niran ya kadeglem kay maazak siran paghinang ka maonga. ");
INSERT INTO mmn_vpl VALUES ("JN3_20","073_3_20","JHN","3","20","20","Bisan sin-o nga nagahinang ka maonga diri gazed iza maazak ka kapawa. Hinoa minpaaro iza ka kapawa kay basi makitan sa ya toong mga hinang nga maonga. ");
INSERT INTO mmn_vpl VALUES ("JN3_21","073_3_21","JHN","3","21","21","Ya tao nga nagatoman ka naazakan na Diyos minkarini iza ka kapawa dazaw makitan nga garing ka Diyos ya toong mga hinang. ");
INSERT INTO mmn_vpl VALUES ("JN3_22","073_3_22","JHN","3","22","22","Pagkakamhan kaiza si Hisos daw ya toong mga sakop minkaro siran ka lopa nga Yoda. Nabilin iza doro iba kaniran. Namenzagay sab siran ka mga tao singed ka batasan ni Howan. ");
INSERT INTO mmn_vpl VALUES ("JN3_23","073_3_23","JHN","3","23","23","Nagabenzag pen si Howan gihapon doro ka longsod nga Aynon arani ka longsod nga Salim kay dakola ya sapa doro. Nangaro ya mga tao kan Howan kay ampabenzag siran ");
INSERT INTO mmn_vpl VALUES ("JN3_24","073_3_24","JHN","3","24","24","kay wara pen si Howan mapiriso. ");
INSERT INTO mmn_vpl VALUES ("JN3_25","073_3_25","JHN","3","25","25","Na, ya mga sakop ni Howan daw ya isang tao nga Yodayo namaglalislalis siran ka batasan na mga Yodayo nga kinahanglan bo-boan ka sapa ya lawas niran anipen siran makakaen. ");
INSERT INTO mmn_vpl VALUES ("JN3_26","073_3_26","JHN","3","26","26","Kamhan minkandizan siran kan Howan. Minlaong siran nga Maistro, ya tao nga kanmong iba dipi ka sapa nga Hordan nga impanan-ogan mo kanami nagapamenzag di iza ka mga tao koman. Imbizaan iko na mga tao kay masara gazed nga kataed ya minkandipi kanangiza. ");
INSERT INTO mmn_vpl VALUES ("JN3_27","073_3_27","JHN","3","27","27","Minsambag si Howan nga waray tao nga makadawat ka bisan ono kon wara hatagi na Diyos. ");
INSERT INTO mmn_vpl VALUES ("JN3_28","073_3_28","JHN","3","28","28","Izang dini kaini nabatian mazo ya impanan-og nao nga diri kon hao si Kristo nga hari nga pinili na Diyos. Hinoa insogo hao ngarini paghon-a kanangiza dazaw an-andam hao ka toong pagdateng. ");
INSERT INTO mmn_vpl VALUES ("JN3_29","073_3_29","JHN","3","29","29","Pamolinged ta kamo nga ya tao nga nangasawa iza ya insondan na asawa. Ya maglaongay na nangasawa nagasaza iza kon makaganas di ka babazi kay kamhan di ya toong tarabaho. Singed kaiton ya kanaong kasaza kay mataed di ya nanalinga kan Hisos daw ya mga minsakop di kanangiza. Kamhan di ya kanaong tarabaho ka pagpakilala kan Hisos dini kamazo. ");
INSERT INTO mmn_vpl VALUES ("JN3_30","073_3_30","JHN","3","30","30","Ya pagkabantog ni Hisos an-oswag gazed iton. Kamhan angeramay ya kanaong pagkabantog. ");
INSERT INTO mmn_vpl VALUES ("JN3_31","073_3_31","JHN","3","31","31","Si Hisos garing iza ka Diyos. Kamhan iza ya labaw ka tanan. Taga kalibotan ka lamang hao. Kamhan anpanaba hao mahitenged ka kalibotan ka lamang. Iza nga garing daked ka Ginoo labaw iza ka tanan. ");
INSERT INTO mmn_vpl VALUES ("JN3_32","073_3_32","JHN","3","32","32","Impanan-og naiza ya toong nakitan daw nabatian piro talagsa ka ya mintoo ka toong mga panaba. ");
INSERT INTO mmn_vpl VALUES ("JN3_33","073_3_33","JHN","3","33","33","Kamhan bisan sin-o ya mintoo kanangiza siran gazed ya ampanan-og nga polos matood ya mga panaba na Diyos. ");
INSERT INTO mmn_vpl VALUES ("JN3_34","073_3_34","JHN","3","34","34","Kay iza nga inpakarimbaba na Diyos minpanaba iza ka mga panaba na Diyos kay insakto gazed ya Madazaw nga Ispirito na Diyos dizan kanangiza. ");
INSERT INTO mmn_vpl VALUES ("JN3_35","073_3_35","JHN","3","35","35","Naazak gazed ya Diyos kan Hisos. Kamhan inhatag na Diyos ya tanan dizan kanangiza. ");
INSERT INTO mmn_vpl VALUES ("JN3_36","073_3_36","JHN","3","36","36","Bisan sin-o ya antoo ka Maanak na Diyos may toong bag-ong kinabohi nga diri mawara. Bisan sin-o ya diri antoo ka Maanak na Diyos diri iza tagan ka kinabohi basta kay silotan gazed iza na Diyos ka waray pagheneng. ");
INSERT INTO mmn_vpl VALUES ("JN4_1","073_4_1","JHN","4","1","1","Kamhan nakabati ya mga Parasiyo nga mataed di koman ya mga tao nga gosto ampasakop kan Hisos daw ampabenzag kamhan ya kan Howan geramay ka. ");
INSERT INTO mmn_vpl VALUES ("JN4_2","073_4_2","JHN","4","2","2","Diri kon si Hisos ya magapamenzag ka mga tao kay ya toong mga sakop ka lamang. ");
INSERT INTO mmn_vpl VALUES ("JN4_3","073_4_3","JHN","4","3","3","Kamhan mahagdam si Hisos nga nakabati di ya mga Parasiyo nga nabantog di ya toong ngaran agon minpanaw iza dizan ka lopa nga Yoda kay ambalik iza ka lopa nga Galiliya. ");
INSERT INTO mmn_vpl VALUES ("JN4_4","073_4_4","JHN","4","4","4","Ya dalan pasinged ngaro ka Galiliya minlapos iton ka lopa nga Samariya. ");
INSERT INTO mmn_vpl VALUES ("JN4_5","073_4_5","JHN","4","5","5","Kamhan nakadateng si Hisos ka longsod nga Saykar doro ka Samariya. Arani iton ka oma nga intagan ni Hakob nga karaang tao ka toong maanak nga si Hosi. ");
INSERT INTO mmn_vpl VALUES ("JN4_6","073_4_6","JHN","4","6","6","Kamhan dizan ka pagaazihan ni Hisos may atabay nga kinabotan ni Hakob. Na, pagdateng ni Hisos dakoza nagalo-to iza kay ampahoway iza ka toong pagpanaw ka pag-odto di na sega. ");
INSERT INTO mmn_vpl VALUES ("JN4_7","073_4_7","JHN","4","7","7","Na, ka dizan pen si Hisos may nagapasinged ngarini nga babazi nga somag-ebay. Taga Samariya iza. Kamhan minlaong si Hisos ka babazi nga paimnen mo hao. ");
INSERT INTO mmn_vpl VALUES ("JN4_8","073_4_8","JHN","4","8","8","Minlaong iza kaiton kay nanlargo pen ya toong mga sakop ka longsod dazaw paliten ya makaen. ");
INSERT INTO mmn_vpl VALUES ("JN4_9","073_4_9","JHN","4","9","9","Kamhan nabereng ya babazi kay ya batasan na mga Yodayo diri angamit ka mga betangan na taga Samariya ka pag-inem. Agon minsambag iza kan Hisos nga Yodayo iko. Ono sa nga azoan sa mo hao ka sapa? ");
INSERT INTO mmn_vpl VALUES ("JN4_10","073_4_10","JHN","4","10","10","Minsambag si Hisos nga kon nahagdam pen ko ka inhatag na Diyos kanmo, kon makakilala pen ko kon sin-o sa hao nga minpangazo kanmo ka sapa, iko hinoa ya an-azo kanao ka sapa kay paimnen ta ko ka sapa nga diri di ko ohawen kawanihen ka. ");
INSERT INTO mmn_vpl VALUES ("JN4_11","073_4_11","JHN","4","11","11","Kamhan minlaong ya babazi nga Nong, waray ikasag-eb mo hasta ararem ini nga atabay nga ingkabotan. Kamhan daw hain ko magkawa ka sapa nga makakawa ka kaohaw kawanihen ka? ");
INSERT INTO mmn_vpl VALUES ("JN4_12","073_4_12","JHN","4","12","12","Daw labaw pen baza iko kan Hakob nga kanaming karaan? Iza ya minhinang kaini nga ingkabotan nga atabay. Iza daw ya toong mga maanak daw mga bohien nga baka min-inem sirang tanan dini kaini nga sapa. ");
INSERT INTO mmn_vpl VALUES ("JN4_13","073_4_13","JHN","4","13","13","Minsambag si Hisos nga ya tao nga magainem kaini nga sapa ohawen iza pag-isab. ");
INSERT INTO mmn_vpl VALUES ("JN4_14","073_4_14","JHN","4","14","14","Kamhan ya an-inem ka sapa nga kanaong ihatag diri di gazed iza ohawen pag-isab kay kawanihen ka mahinang iton ka singed ka tobod dalem ka toong beet. Diri isab mawara ya bag-ong kinabohi naiza. ");
INSERT INTO mmn_vpl VALUES ("JN4_15","073_4_15","JHN","4","15","15","Minsambag ya babazi nga Nong, tagan mo hao ka sapa nga impanaba mo dazaw diri di hao ohawen pag-isab. Diri di hao an-isab pagbalik ka pagsag-eb dini. ");
INSERT INTO mmn_vpl VALUES ("JN4_16","073_4_16","JHN","4","16","16","Minsambag si Hisos nga pakarinihen mo ya kanmong bana. ");
INSERT INTO mmn_vpl VALUES ("JN4_17","073_4_17","JHN","4","17","17","Minsambag ya babazi nga waray bana nao. Minlaong si Hisos nga hosto ya sambag mo nga waray bana mo ");
INSERT INTO mmn_vpl VALUES ("JN4_18","073_4_18","JHN","4","18","18","kay lima di ya nangazi kanmo nga bana. Kamhan ya mintipon kanmo koman diri kon iza ya bana mo. Matood ya sambag mo kanao. ");
INSERT INTO mmn_vpl VALUES ("JN4_19","073_4_19","JHN","4","19","19","Minsambag ya babazi nga Nong, mahagdam di hao nga iko ya matood nga propita na Diyos kay nahagdam iko daan ka kanaong batasan. ");
INSERT INTO mmn_vpl VALUES ("JN4_20","073_4_20","JHN","4","20","20","Wani pen ya pangotana nao kanmo nga kay ono sa kamo nga Yodayo nagalaong nga kinahanglan doro ka siyodad nga Hirosalem ipahalad ya ihazep ka paghawag ka Diyos? Kay ya batasan na kanaming karaan ya bobong nga Girasim ani ya dapit niran ka paghawag ka Diyos. ");
INSERT INTO mmn_vpl VALUES ("JN4_21","073_4_21","JHN","4","21","21","Minsambag si Hisos nga toohi hao nga arani di ya tirmino nga diri di anhawag ya mga tao ka Ama nga Diyos dizan ka bobong nga Girasim bisan kon doro ka siyodad nga Hirosalem. ");
INSERT INTO mmn_vpl VALUES ("JN4_22","073_4_22","JHN","4","22","22","Kamo nga taga Samariya wara gazed kamo mahagdam kon sin-o ya kamazong pangamozoan. Kami nga mga Yodayo mahagdam sa kami kon sin-o ya kanaming pangamozoan kay ya Manlolowas ka mga tao Yodayo ya toong kaliwat. ");
INSERT INTO mmn_vpl VALUES ("JN4_23","073_4_23","JHN","4","23","23","Mindateng di ya tirmino nga ya mga matood nga magsingbahay kinahanglan magaangay ya kanirang hena-hena ka Madazaw nga Ispirito nga garing ka Diyos. Kinahanglan antoo isab siran nga hao ya matood nga Diyos. Ya tao nga nagabatasan singed kaiton iza ya naazakan na Ama ka pagsingba kanangiza. ");
INSERT INTO mmn_vpl VALUES ("JN4_24","073_4_24","JHN","4","24","24","Kay ya Diyos ani ya Madazaw nga Ispirito. Kamhan ya mga anhawag kanangiza kinahanglan mag-angay ya kanirang hena-hena kaiton nga Ispirito. Kinahanglan antoo isab siran nga hao ya matood nga Diyos. ");
INSERT INTO mmn_vpl VALUES ("JN4_25","073_4_25","JHN","4","25","25","Minsambag ya babazi nga mahagdam hao nga ankarini ya Misayas. Inngaranan iza kan Kristo nga hari nga pinili na Diyos. Iza ya ampakita kanta ka tanan kay-an ka pagdateng naiza. ");
INSERT INTO mmn_vpl VALUES ("JN4_26","073_4_26","JHN","4","26","26","Minsambag si Hisos nga hao nga nagalaong kanmo koman ani iza si Kristo. ");
INSERT INTO mmn_vpl VALUES ("JN4_27","073_4_27","JHN","4","27","27","Kamhan nakabalik ya mga sakop ni Hisos. Nabereng siran kay ono ya pagkiglaonglaong naiza ka babazi kamhan wara siran mangotana ka babazi kon ono ya toong gosto. Wara sab siran mangotana kan Hisos kon ono ya inlaong naiza ka babazi. ");
INSERT INTO mmn_vpl VALUES ("JN4_28","073_4_28","JHN","4","28","28","Kamhan imbilin pen na babazi ya toong tadzaw dizan kay an-oli pen iza ka longsod. Pagdateng ka naiza doro minlaong iza ka mga tao nga ");
INSERT INTO mmn_vpl VALUES ("JN4_29","073_4_29","JHN","4","29","29","ibahan mazo hao ngaro kay dazaw makakita kamo ka tao nga minpanaba kanao ka tanan nahinang nao. Ani di iton doro kombeet si Kristo nga hari nga pinili na Diyos. ");
INSERT INTO mmn_vpl VALUES ("JN4_30","073_4_30","JHN","4","30","30","Kamhan minpanaw siran pasinged ngaro kan Hisos. ");
INSERT INTO mmn_vpl VALUES ("JN4_31","073_4_31","JHN","4","31","31","Ka wara pen dateng siran inhagad kontana si Hisos na toong mga sakop nagalaong nga Maistro, komaen di ko naa. ");
INSERT INTO mmn_vpl VALUES ("JN4_32","073_4_32","JHN","4","32","32","Minsambag si Hisos nga may makaen nao nga wara mazo mahagdami. ");
INSERT INTO mmn_vpl VALUES ("JN4_33","073_4_33","JHN","4","33","33","Kamhan namaglaonglaong ya mga sakop nga daw may tao nga mindara ngarini ka makaen? ");
INSERT INTO mmn_vpl VALUES ("JN4_34","073_4_34","JHN","4","34","34","Minsambag si Hisos nga singed ka kanaong makaen ya pagtoman ka naazakan na Diyos nga minpakarimbaba kanao daw ya pagtiwas ka toong tarabaho. ");
INSERT INTO mmn_vpl VALUES ("JN4_35","073_4_35","JHN","4","35","35","Pamolinged ini nga kon anseleng kamo ka bag-ong inpogas anlaong kamo nga opat pen ka bolan maani di iton. Timan-an mazo gazed ini nga mindateng di gazed ya tirmino ka pag-ani. Selengi mazo ya mga tao nga gosto antoo kanao kay singed siran ka abot nga anihen. ");
INSERT INTO mmn_vpl VALUES ("JN4_36","073_4_36","JHN","4","36","36","Ya mga antabang ka mga tao ka pagpasakop kanao soholan nao siran. Kamhan ya mga minsakop kanao matagan nao siran ka bag-ong kinabohi nga diri mawara. Ya isang tao singed ka nagapogas iza ka kanaong sindo. Ya isang tao singed ka magaani iza ka tanem. Kamhan mindengan sirang dowa pagsaza kay poslanan ya kanirang tarabaho. ");
INSERT INTO mmn_vpl VALUES ("JN4_37","073_4_37","JHN","4","37","37","Matood ya daan inlaong nga ya isang tao magtanemay iza, kamhan ya isang tao mag-anihay iza. ");
INSERT INTO mmn_vpl VALUES ("JN4_38","073_4_38","JHN","4","38","38","Impadara nao kamo dazaw mangani ka wara mazo hagoi. Ya iba ani naghago kamhan kamo ya nagapahimolos ka kanirang hinagoan. Ani ini ya intoldo ni Hisos ka toong mga sakop. ");
INSERT INTO mmn_vpl VALUES ("JN4_39","073_4_39","JHN","4","39","39","Kamhan doro kaiton nga longsod mataed di ya mga taga Samariya nga mintoo di kan Hisos kay impanan-ogan siran na babazi nagalaong nga iton nga tao ani ya minpanaba kanao ka tanan nahinang nao. ");
INSERT INTO mmn_vpl VALUES ("JN4_40","073_4_40","JHN","4","40","40","Agon pagdateng niran kan Hisos inhagad niran iza ka pagkolang doro ka lagkaw niran. Kamhan nabilin iza doro kaniran keteb ka dowang ka aldaw. ");
INSERT INTO mmn_vpl VALUES ("JN4_41","073_4_41","JHN","4","41","41","Kay nagasindo iza kaniran. Kamhan mataed pen ya mga mintoo kanangiza. ");
INSERT INTO mmn_vpl VALUES ("JN4_42","073_4_42","JHN","4","42","42","Nagalaong sab siran ka babazi nga mintoo di kami kazina kay nakabati kami ka kanmong saba. Kamhan nakabati disab kami ka toong pagsindo agon mahagdam kami nga iza gazed ya Manlolowas ka tanan mga tao. ");
INSERT INTO mmn_vpl VALUES ("JN4_43","073_4_43","JHN","4","43","43","Na, pagdateng ka ikatolong aldaw minpanaw si Hisos kay anlargo iza ka lopa nga Galiliya nga hel-anan na mga diri kon toong kaibahan. ");
INSERT INTO mmn_vpl VALUES ("JN4_44","073_4_44","JHN","4","44","44","Kay minlaong iza nga bisan sin-o ya propita na Diyos wara iza tahoda na toong kaibahan. ");
INSERT INTO mmn_vpl VALUES ("JN4_45","073_4_45","JHN","4","45","45","Pagdateng ka naiza doro magaabiabihen matood iza na mga taga dizan kay izang dini kaini ka pagkaro niran ka Hirosalem ka pista na mga Yodayo nakakita siran ka toong mga hininang. ");
INSERT INTO mmn_vpl VALUES ("JN4_46","073_4_46","JHN","4","46","46","Kamhan mindateng si Hisos ka longsod nga Kana doro ka Galiliya nga dapit nga inhinang naiza ya bino garing ka sapa. Kamhan may isang tao nga minkarini garing ka longsod nga Kapirnaom. Sinarigan iza ni Hirodis nga hari. Kamhan masakiten ya toong bata nga amaama. ");
INSERT INTO mmn_vpl VALUES ("JN4_47","073_4_47","JHN","4","47","47","Pagpakabati ka naiza nga mindateng di si Hisos dini ka lopa nga Galiliya garing ka lopa nga Yoda minkarini iza kan Hisos kay hangzoon naiza ka pag-iba doro ka toong lagkaw kay ipatambal ya toong bata nga nagapinal di ka toong masakit. ");
INSERT INTO mmn_vpl VALUES ("JN4_48","073_4_48","JHN","4","48","48","Minsambag si Hisos nga kon diri ko ankita ka mga timaan nga garing ka Diyos daw ya mga hininang nga kaberenganan diri ko antoo kanao. ");
INSERT INTO mmn_vpl VALUES ("JN4_49","073_4_49","JHN","4","49","49","Minsambag ya oloolo nga Nong, kon mahimo ya beet mo karohon mo dazon kay basi mapatay ya kanaong bata. ");
INSERT INTO mmn_vpl VALUES ("JN4_50","073_4_50","JHN","4","50","50","Minsambag si Hisos nga omoli di ko ngaro kay nadazaw di ya bata mo. Kamhan mintoo ya oloolo ka mga panaba ni Hisos. Minpanaw dazon iza. ");
INSERT INTO mmn_vpl VALUES ("JN4_51","073_4_51","JHN","4","51","51","Ka nagapasinged pen iza ngaro insogat iza na toong mga sogoonon kay nagalaong nga Nong, nadazaw di ya bata mo. ");
INSERT INTO mmn_vpl VALUES ("JN4_52","073_4_52","JHN","4","52","52","Kamhan nangotana iza daw ono orasa ya pagkawara na toong masakit? Minsambag siran nga kahabi ka pagkaala ona nakawa di ya toong hilanat. ");
INSERT INTO mmn_vpl VALUES ("JN4_53","073_4_53","JHN","4","53","53","Kamhan mahagdam ya oloolo nga ani indenganan izang pagpanaba pen ni Hisos nga nadazaw di ya bata mo. Kamhan mintoo gazed ya oloolo kan Hisos lakip ya tibolos inhel-an naiza. ");
INSERT INTO mmn_vpl VALUES ("JN4_54","073_4_54","JHN","4","54","54","Na, sokad ka pagdateng ni Hisos ka Galiliya garing ka lopa nga Yoda ikadowang timaan iton nga inhinang naiza dazaw mahagdam siran nga garing iza ka Diyos. ");
INSERT INTO mmn_vpl VALUES ("JN5_1","073_5_1","JHN","5","1","1","Pagkakamhan kaiza minkaro si Hisos ka siyodad nga Hirosalem kay may pista na mga Yodayo. ");
INSERT INTO mmn_vpl VALUES ("JN5_2","073_5_2","JHN","5","2","2","Na, dakoza ka Hirosalem may pirtahan nga azihanan na mga mag-ateday ka karniro nga ihaladay ka Diyos. Kamhan may linaw dizan ka pirtahan. Dizan ka kilid na linaw may mga tal-ob nga limang bolos nga pahimlazanan na mga nabedlay nga tao. Ya ngaran naiton nga dapit ani ya Bitsayda ka saba nga Hinibriyo. ");
INSERT INTO mmn_vpl VALUES ("JN5_3","073_5_3","JHN","5","3","3","Mataed ya mga masakiten nga namentag dizan. May nangabota, may nangapiang, may diri makahingas ka lawas. Nagatagad sirang tanan ka pagkotaw kaiton nga linaw. ");
INSERT INTO mmn_vpl VALUES ("JN5_4","073_5_4","JHN","5","4","4","Kay may panahon nga andateng ya sogoonon nga taga langit kay ankotaw ka linaw. Kamhan ya masakiten nga makahon-a pagtena nawaraan matood iza ka bisan ono ya toong masakit. ");
INSERT INTO mmn_vpl VALUES ("JN5_5","073_5_5","JHN","5","5","5","Na, may isang ka tao dizan. Kamhan katloan may walo ding ka toig ya toong pagkabedlay. ");
INSERT INTO mmn_vpl VALUES ("JN5_6","073_5_6","JHN","5","6","6","Pagpakakita ni Hisos ka tao nahagdam iza nga dogay di gazed ya toong pagbentag dizan. Kamhan minlaong si Hisos nga daw ansogot ko nga mawara ya masakit mo? ");
INSERT INTO mmn_vpl VALUES ("JN5_7","073_5_7","JHN","5","7","7","Minsambag ya nabedlay nga Nong, waray makabohat kanao ngaro ka linaw kon somobosobo di iton. Pagpangalimbasog nao ka pagdateng ka linaw nahon-ahan hao na iba. ");
INSERT INTO mmn_vpl VALUES ("JN5_8","073_5_8","JHN","5","8","8","Minlaong si Hisos nga bomangon di ko. Lokoton mo ya kanmong banig. Kamhan pomanaw ko. ");
INSERT INTO mmn_vpl VALUES ("JN5_9","073_5_9","JHN","5","9","9","Kamhan madazaw di matood ya tao. Minlokot iza ka toong banig. Kamhan minpanaw iza. Ani ini ya hinang ni Hisos ka aldaw nga tigpahimlay na mga Yodayo. ");
INSERT INTO mmn_vpl VALUES ("JN5_10","073_5_10","JHN","5","10","10","Kamhan ya tao nga madazaw di imbaheg iza na mga Yodayo nga nagalaong nga diri ko magdara ka banig mo kay nagalapas iko ka balaed na mga karaan nga Yodayo kay singed ka magatarabaho iko koman nga aldaw nga tigpahimlay. ");
INSERT INTO mmn_vpl VALUES ("JN5_11","073_5_11","JHN","5","11","11","Minsambag ya tao nga ya mintambal kanao ani ya minsogo kanao ka pagdara ka banig. ");
INSERT INTO mmn_vpl VALUES ("JN5_12","073_5_12","JHN","5","12","12","Nangotana siran daw sin-o sa iza taoha nga minsogo kanmo? ");
INSERT INTO mmn_vpl VALUES ("JN5_13","073_5_13","JHN","5","13","13","Kamhan ya tao nga madazaw di wara iza mahagdam kon sin-o iton kay minbelag dazon si Hisos pagpanaw kay mataed di ya mga tao dini kaini nga dapita. ");
INSERT INTO mmn_vpl VALUES ("JN5_14","073_5_14","JHN","5","14","14","Pagkateedteed ka nakitan ni Hisos ya tao nga indazaw naiza dalem ka dakolang lagkaw nga pangamozoanan ka Diyos. Kamhan minlaong si Hisos nga selengi, madazaw di gazed ya lawas mo. Bomiza di ko ka batasan nga maonga dazaw diri di ko matagan ka kalised dakola pen ka mahon-a. ");
INSERT INTO mmn_vpl VALUES ("JN5_15","073_5_15","JHN","5","15","15","Kamhan minpanaw ya tao. Minpanan-og iza ka mga oloolo na mga Yodayo nga si Hisos ya ngaran na tao nga nakatambal kanangiza. ");
INSERT INTO mmn_vpl VALUES ("JN5_16","073_5_16","JHN","5","16","16","Kamhan minsogod di siran pagdaegdaeg kan Hisos kay indazaw naiza ya tao ka aldaw nga tigpahimlay. ");
INSERT INTO mmn_vpl VALUES ("JN5_17","073_5_17","JHN","5","17","17","Agon minsambag si Hisos kaniran nga ya kanaong Ama nga Diyos wara iza magheneng ka toong pagkalooy ka tao ka aldaw nga tigpahimlay. Kamhan hao ya ampadazon ka toong tarabaho. ");
INSERT INTO mmn_vpl VALUES ("JN5_18","073_5_18","JHN","5","18","18","Pagpakabati na mga Yodayo kaiza gosto gazed siran ampatay kan Hisos kay minlapas iza koni ka balaed mahitenged ka aldaw nga tigpahimlay. In-angay disab koni naiza ya toong kaogaringen ka pagkalabaw ka kaogaringen na Diyos kay minlaong iza nga ya Diyos ani gazed ya toong Ama. ");
INSERT INTO mmn_vpl VALUES ("JN5_19","073_5_19","JHN","5","19","19","Kamhan minlaong si Hisos kaniran nga timan-an mazo gazed ini. Hao nga Maanak na Diyos, waray mahimo na kanaong kaogaringen ka paghinang ka bisan ono. Nagahinang lamang hao ka nakita nao nga inhinang na kanaong Ama. Kay bisan ono ya inhinang na Ama ani isab ya inhinang na toong Maanak. ");
INSERT INTO mmn_vpl VALUES ("JN5_20","073_5_20","JHN","5","20","20","Naazak gazed ya Ama kanao nga toong Maanak. Kamhan impakita hao naiza ka tanan mga inhinang naiza. Kamhan pahinangen pen hao naiza ka labaw pen nga tarabaho dazaw mabereng kamo. ");
INSERT INTO mmn_vpl VALUES ("JN5_21","073_5_21","JHN","5","21","21","Ya Ama ani ya magabohi ka mga tao pagbalik garing ka lebeng. Kamhan hao nga toong Maanak anhatag sab hao ka kinabohi dizan ka bisan sin-o ya pinili nao nga tao. ");
INSERT INTO mmn_vpl VALUES ("JN5_22","073_5_22","JHN","5","22","22","Ya Ama nga Diyos diri anhokom ka tao. Hinoa inhatag naiza ka toong Maanak ya tanan katenged ka paghokom ");
INSERT INTO mmn_vpl VALUES ("JN5_23","073_5_23","JHN","5","23","23","dazaw antahod ya tanan tao ka Maanak na Diyos singed ka pagtahod niran ka Ama nga Diyos. Ya tao nga diri antahod ka Maanak na Diyos singed ka diri isab iza antahod ka Ama nga minpakarimbaba kanangiza. ");
INSERT INTO mmn_vpl VALUES ("JN5_24","073_5_24","JHN","5","24","24","Timan-an mazo gazed ini. Ya tao nga manalinga ka kanaong sindo kamhan antoo kanangiza nga minpakarimbaba kanao, intagan di gazed iton nga tao ka bag-ong kinabohi nga diri mawara. Diri iza silotan ka kamatazen ka toong mga sala hinoa may toong kinabohi nga diri mawara. ");
INSERT INTO mmn_vpl VALUES ("JN5_25","073_5_25","JHN","5","25","25","Manalinga kamo! Mindateng di koman ya panahon nga ampanalinga ya mga patay nga tao ka saba na Maanak na Diyos. Kamhan ya mga makabati mabohi gazed siran pagbalik garing ka mga lebeng. ");
INSERT INTO mmn_vpl VALUES ("JN5_26","073_5_26","JHN","5","26","26","Garing ka kaogaringen na Ama nga Diyos ya kinabohi. Kamhan garing sab ka kaogaringen na toong Maanak ya kinabohi kay ani ya hatag na Ama. ");
INSERT INTO mmn_vpl VALUES ("JN5_27","073_5_27","JHN","5","27","27","Intagan isab naiza ya toong Maanak ka katenged ka paghokom ka tanan mga tao kay ining Maanak iza ya minhon-a ka bisan sin-o ya mahon-ang tao. ");
INSERT INTO mmn_vpl VALUES ("JN5_28","073_5_28","JHN","5","28","28","Diri kamo magkabereng kaini nga pagpanaba nao kamazo kay andateng ya tirmino nga makabati ka saba nao ya tanan mga patay dalem ka mga lebeng. ");
INSERT INTO mmn_vpl VALUES ("JN5_29","073_5_29","JHN","5","29","29","Kamhan manlogwa sirang tanan. Ya mga minhinang ka madazaw ka bohi ka siran, palogwaen siran dazaw mahatagan ka bag-ong kinabohi nga diri mawara. Kamhan ya mga minhinang ka maonga palogwaen siran dazaw mahokman siran ka silot nga waray kinateban. ");
INSERT INTO mmn_vpl VALUES ("JN5_30","073_5_30","JHN","5","30","30","Ya kanaong katenged ka paghokom ka mga tao garing iton ka inpanaba na Diyos kanao, diri kon garing ka kanaong kaogaringen. Kamhan matadeng ya kanaong paghokom kay wara hao magtoman ka kanaong naazakan basta kay mintoman hao ka naazakan na Ama nga minpakarimbaba kanao. ");
INSERT INTO mmn_vpl VALUES ("JN5_31","073_5_31","JHN","5","31","31","Kon hao kay nagapamatood ka kanaong kaogaringen dazaw mahagdam kamo nga garing hao ka Diyos anhena-hena kamo nga diri kon matood ya kanaong mga panaba. ");
INSERT INTO mmn_vpl VALUES ("JN5_32","073_5_32","JHN","5","32","32","Ya Ama nga Diyos iza ya nagapamatood nga garing hao kanangiza. Kamhan mahagdam hao nga matood gazed ya toong mga panaba bahin kanao. ");
INSERT INTO mmn_vpl VALUES ("JN5_33","073_5_33","JHN","5","33","33","Izang dini kaini insogo mazo ya tao ngaro kan Howan nga Magbenzagay kay impapangotana mazo kon sin-o sa hao. Kamhan minsambag iza pagpamatood nga garing hao ka Diyos. ");
INSERT INTO mmn_vpl VALUES ("JN5_34","073_5_34","JHN","5","34","34","Bisan wara hao magkinahanglan ka pagpamatood na tao kon sin-o sa hao ipataremdem nao kamazo ya saba ni Howan kay kon antoo kamo kaini malibri gazed kamo ka silot ka kamazong mga sala. ");
INSERT INTO mmn_vpl VALUES ("JN5_35","073_5_35","JHN","5","35","35","Izang dini kaini si Howan singed iza ka lati na segà kay nagapakita iza kamazo ka dalan ngaro ka Ginoo. Nagailaw ya toong pagsindo ka kamazong hena-hena. Kamhan minsaza kamo ka kadali ka. ");
INSERT INTO mmn_vpl VALUES ("JN5_36","073_5_36","JHN","5","36","36","Na, may labaw pen nga nagapamatood nga ya Diyos ani minpakarimbaba kanao. Kamhan ya mga hinang nga inpahinang kanao na kanaong Ama, ani gazed ya nagapamatood nga ya Ama ani ya minpakarimbaba kanao. ");
INSERT INTO mmn_vpl VALUES ("JN5_37","073_5_37","JHN","5","37","37","Kamhan iza nga minpakarimbaba kanao, iza gazed ya nagapamatood nga garing hao kanangiza. Ya toong saba diri mahimo pagpanalinga. Kamhan ya toong lawas diri mahimo pagpakita. ");
INSERT INTO mmn_vpl VALUES ("JN5_38","073_5_38","JHN","5","38","38","Ya toong mga panaba wara gazed makadateng ka kamazong hena-hena kay wara kamo magtoo nga hao ya inpakarimbaba naiza. ");
INSERT INTO mmn_vpl VALUES ("JN5_39","073_5_39","JHN","5","39","39","Ya batasan mazo minsosi pagbasa ka mga daan pinasoyat na Diyos kay ya hena-hena mazo ya pagbasa mazo ani anhatag kamazo ka bag-ong kinabohi nga diri mawara. Ambaza kay bisan nagapamatood ya mga pinasoyat nga garing hao ka Diyos ");
INSERT INTO mmn_vpl VALUES ("JN5_40","073_5_40","JHN","5","40","40","wara kamo magpasakop kanao dazaw may bag-ong kinabohi mazo nga diri mawara. ");
INSERT INTO mmn_vpl VALUES ("JN5_41","073_5_41","JHN","5","41","41","Wara hao magpasaza ka mga tao kanao. ");
INSERT INTO mmn_vpl VALUES ("JN5_42","073_5_42","JHN","5","42","42","Mahagdam sab hao nga diri kon matood ya pagkaazak mazo ka Diyos. ");
INSERT INTO mmn_vpl VALUES ("JN5_43","073_5_43","JHN","5","43","43","Mindateng hao garing ka Ama nao. Inhatagan hao naiza ka dakola nga gahem kamhan wara kamo magtoo kanao. Kon may iba nga tao nga andateng dini kamazo kamhan nagalaong iza nga iza matood si Kristo, antoo baza kamo kaiton nga tao. ");
INSERT INTO mmn_vpl VALUES ("JN5_44","073_5_44","JHN","5","44","44","Gosto kamo nga sazaen kamo na kamazong mga iba piro wara kamo gosto nga sazaen kamo na bogtong Diyos. Agon onhon sa mazo pagtoo kanao? ");
INSERT INTO mmn_vpl VALUES ("JN5_45","073_5_45","JHN","5","45","45","Azaw kamo maghena-hena nga isombong nao kamo ka kanaong Ama. Si Moysis nga kamazong insarigan ani hinoa ya ansombong kamazo. ");
INSERT INTO mmn_vpl VALUES ("JN5_46","073_5_46","JHN","5","46","46","Kay kon matood ya pagtoo mazo kan Moysis, antoo isab kamo kanao kay iza ya minsoyat daan mahitenged kanao. ");
INSERT INTO mmn_vpl VALUES ("JN5_47","073_5_47","JHN","5","47","47","Wara kamo magtoo ka toong mga sinoyat agon onhon sa mazo pagtoo ka kanaong mga panaba? ");
INSERT INTO mmn_vpl VALUES ("JN6_1","073_6_1","JHN","6","1","1","Pagkakamhan minsakay di si Hisos ngandipi ka danaw nga Galiliya. Ya ibang ngaran na danaw ani Tibiriyas. ");
INSERT INTO mmn_vpl VALUES ("JN6_2","073_6_2","JHN","6","2","2","Kamhan mataed ya tao nga nagasonod kan Hisos kay nakapaniid siran ka toong mga inhinang pagpakadazaw naiza ka mga masakit. Mga timaan iton nga garing iza ka Diyos. ");
INSERT INTO mmn_vpl VALUES ("JN6_3","073_6_3","JHN","6","3","3","Kamhan mintokad iza ngandaked ka pagkahiping na bobong. Minlo-to iza dizan daw ya toong mga sinarigan. ");
INSERT INTO mmn_vpl VALUES ("JN6_4","073_6_4","JHN","6","4","4","Na, iton nga panahon hapit di andateng ya pista na mga Yodayo nga mangihaw siran ka mga nati na karniro. ");
INSERT INTO mmn_vpl VALUES ("JN6_5","073_6_5","JHN","6","5","5","Kamhan pagpakakita ni Hisos ka mga mataed nga tao nga nangarini kanangiza minlaong iza kan Pilipo nga daw hain kita makapalit ka makaen nga an-igo ka pagpakaen kaiton nga mga mataed nga tao? ");
INSERT INTO mmn_vpl VALUES ("JN6_6","073_6_6","JHN","6","6","6","Na, ya pangotana ni Hisos porba lamang naiza kan Pilipo kay mahagdam si Hisos ka toong kaogaringen nga makabagat iza ka toong nga ipakaen kaniran. ");
INSERT INTO mmn_vpl VALUES ("JN6_7","073_6_7","JHN","6","7","7","Minsambag si Pilipo nga bisan ya sohol ka enem nga ka bolan diri an-igo iton ka pagpamalit ka makaen ka tagsatagsa kaniran bisan geramay ka ya ipakaen ta kaniran. ");
INSERT INTO mmn_vpl VALUES ("JN6_8","073_6_8","JHN","6","8","8","Kamhan ya isang sinarigan nga si Andris nga lomon ni Simon Pidro minlaong iza kan Hisos nga ");
INSERT INTO mmn_vpl VALUES ("JN6_9","073_6_9","JHN","6","9","9","wani dakoza ya bata nga amaama nga may limang bolos nga pan daw dowang bolos nga isda. Piro diri gazed maigo ini kaini nga mataed nga mga tao. ");
INSERT INTO mmn_vpl VALUES ("JN6_10","073_6_10","JHN","6","10","10","Kamhan minlaong si Hisos kaniran nga palo-toon di mazo sirang tanan. Na, talagsa ka ya liwaan dizan agon nanlo-to di ya mga tao. Hapit maglimang ka libo ya amaama. Wara pen ya labet na mga babazi daw mga bata ka pagbilang niran. ");
INSERT INTO mmn_vpl VALUES ("JN6_11","073_6_11","JHN","6","11","11","Pagkakamhan ka minkawa si Hisos ka mga pan. Minpasalamat iza ka Diyos. Kamhan inbahinbahin naiza iton ka mga tao nga nagalo-to dizan. Inbahinbahin sab naiza ya mga isda. Bisan kon kapira magdogang, dakola pen gihapon nga isda daw pan. ");
INSERT INTO mmn_vpl VALUES ("JN6_12","073_6_12","JHN","6","12","12","Pagkabosog di niran minlaong si Hisos ka toong mga sinarigan nga hipiden di mazo ya mga salin nga pan dazaw waray makanam. ");
INSERT INTO mmn_vpl VALUES ("JN6_13","073_6_13","JHN","6","13","13","Pagkakamhan niran paghipid nangapono pen ya napolo may dowang ka alat na salin garing ka lima kang bolos nga pan. ");
INSERT INTO mmn_vpl VALUES ("JN6_14","073_6_14","JHN","6","14","14","Kamhan minlaong ya mga tao nga iton nga tao ani gazed ya intagadan nita nga matood nga propita nga garing ka Diyos. Kay nakakita siran kaiton nga timaan nga inpataed ni Hisos ya geramay nga pan daw isda. ");
INSERT INTO mmn_vpl VALUES ("JN6_15","073_6_15","JHN","6","15","15","Na, nakasabot si Hisos ka hena-hena na mga tao mahitenged kanangiza nga pamagkaw-en iza niran kontana kay hinangen nga hari niran. Agon minbogtong iza pagpanaw pagbalik daked ka bobong. ");
INSERT INTO mmn_vpl VALUES ("JN6_16","073_6_16","JHN","6","16","16","Na, pagsalep di na sega minlogsong di ya toong mga sinarigan ka baybazen na danaw. ");
INSERT INTO mmn_vpl VALUES ("JN6_17","073_6_17","JHN","6","17","17","Na, kahabzen di wara pen gihapon mag-apas si Hisos kaniran. Kamhan minleen siran ka baloto kay anhon-a siran pagsakay ngandipi ka baybazen ka longsod nga Kapirnaom. ");
INSERT INTO mmn_vpl VALUES ("JN6_18","073_6_18","JHN","6","18","18","Na, ka wara pen siran dateng dipi nandakola ya mga baled kay dizan ka danaw makeseg ya hangin. ");
INSERT INTO mmn_vpl VALUES ("JN6_19","073_6_19","JHN","6","19","19","Pagbegsay di niran ka hapit mag-enem nga ka kilomitro anipen niran makiti si Hisos nga nagapanaw dizan ka hopaw na sapa nga nagasinged baza ngarini kaniran. Nangahaldek gazed siran. ");
INSERT INTO mmn_vpl VALUES ("JN6_20","073_6_20","JHN","6","20","20","Kamhan minlaong si Hisos kaniran nga diri kamo magkahaldek kay hao ya nakitan mazo. ");
INSERT INTO mmn_vpl VALUES ("JN6_21","073_6_21","JHN","6","21","21","Kamhan nagasaza di siran nga minpasakay kanangiza. Kamhan mindonggo dazon siran dipi ka baybazen. ");
INSERT INTO mmn_vpl VALUES ("JN6_22","073_6_22","JHN","6","22","22","Pagkaaldaw ya mga tao nga nangabilin dipi ka baybazen, nakapaniid siran nga isa ka ya baloto nga nabilin kahabi. Kamhan nahagdam siran nga wara magsakay si Hisos ka baloto iba ka toong mga sinarigan pagpanaw niran kahabi. ");
INSERT INTO mmn_vpl VALUES ("JN6_23","073_6_23","JHN","6","23","23","Kamhan may mga iba pen nga baloto nga mindateng di garing ka longsod nga Tibiriyas arani ka dapit nga impasalamatan ni Hisos ka pagpakaen ka mga tao. ");
INSERT INTO mmn_vpl VALUES ("JN6_24","073_6_24","JHN","6","24","24","Pagpakakita na mga tao nga wara dizan si Hisos daw ya toong mga sinarigan nanakay siran ka mga baloto dipi ka Kapirnaom kay anpangita siran kan Hisos. ");
INSERT INTO mmn_vpl VALUES ("JN6_25","073_6_25","JHN","6","25","25","Pagpakakita niran kanangiza dipi ka dagat nangotana siran nga Maistro, daw kagan-o ko dateng dini? ");
INSERT INTO mmn_vpl VALUES ("JN6_26","073_6_26","JHN","6","26","26","Minsambag si Hisos nga timan-an mazo gazed ini. Wara kamo magpangita kanao kay nakakita kamo ka inhinang nao kahabi basta kay nangita kamo kanao kay nakakaen kamo ka pan ka pagkabosog. ");
INSERT INTO mmn_vpl VALUES ("JN6_27","073_6_27","JHN","6","27","27","Abay kamo paghena-hena mahitenged ka makaen nga madali ampan-es. Maghena-hena kamo hinoa ka makaen nga diri ampan-es kay makahatag iton kamazo ka bag-ong kinabohi nga diri mawara. Hao ya makahatag kamazo kaini nga makaen nga diri ampan-es kay ya Diyos nga kanaong Ama ani ya minhatag kanao ka gahem. ");
INSERT INTO mmn_vpl VALUES ("JN6_28","073_6_28","JHN","6","28","28","Kamhan nangotana siran nga ono sa ya kanaming hinangen dazaw makatoman kami ka naazakan na Diyos? ");
INSERT INTO mmn_vpl VALUES ("JN6_29","073_6_29","JHN","6","29","29","Minsambag si Hisos nga ya naazakan na Diyos ani ya pagtoo mazo kanao nga toong inpakarimbaba. ");
INSERT INTO mmn_vpl VALUES ("JN6_30","073_6_30","JHN","6","30","30","Minsambag siran nga daw ono pen ya kaberenganan nga ipakita mo kanami dazaw antoo kami kanmo? Daw ono pen ya kanmong mahinang? ");
INSERT INTO mmn_vpl VALUES ("JN6_31","073_6_31","JHN","6","31","31","Kay ya mga karaan nami nakakaen siran ka makaen nga inngaranan ka mana ka doro pen siran ka dakolang nag-as kay dizan ka daan pinasoyat na Diyos nagalaong nga intagan siran naiza ka makaen nga garing daked ka langit. ");
INSERT INTO mmn_vpl VALUES ("JN6_32","073_6_32","JHN","6","32","32","Minsambag si Hisos nga timan-an mazo gazed ini. Diri kon si Moysis nga karaang propita ya minhatag kaniran ka makaen nga garing daked ka langit basta ya kanaong Ama. Kamhan iza isab ya magahatag kamazo ka matood nga makaen garing ka langit. ");
INSERT INTO mmn_vpl VALUES ("JN6_33","073_6_33","JHN","6","33","33","Kay ya makaen nga inhatag na Diyos ani ya minkarimbaba garing daked ka langit. Kamhan makahatag iton ka tanan mga tao ka bag-ong kinabohi nga diri mawara. ");
INSERT INTO mmn_vpl VALUES ("JN6_34","073_6_34","JHN","6","34","34","Minsambag siran nga Nong, tagan mo kami koman kaini nga makaen nga diri ampan-es kawanihen ka. ");
INSERT INTO mmn_vpl VALUES ("JN6_35","073_6_35","JHN","6","35","35","Minsambag si Hisos nga ya makaen nga makahatag ka bag-ong kinabohi nga diri mawara ani hao. Kamhan ya tao nga ansakop kanao diri di iza magabengtasen. Ya tao nga antoo kanao diri iza ohawen kawanihen ka. ");
INSERT INTO mmn_vpl VALUES ("JN6_36","073_6_36","JHN","6","36","36","Izang dini kaini inlong-an nao kamo nga bisan minkita kamo kanao, wara kamo magtoo kanao. ");
INSERT INTO mmn_vpl VALUES ("JN6_37","073_6_37","JHN","6","37","37","Ya tanan mga tao nga insarig kanao na kanaong Ama siran ya antoo kanao. Kamhan siran nga mga mintoo di kanao diri gazed nao pagabogawen. ");
INSERT INTO mmn_vpl VALUES ("JN6_38","073_6_38","JHN","6","38","38","Kay minkarimbaba hao garing ka langit dazaw antoman hao ka pagbeet na Diyos nga minpakarimbaba kanao. Diri kon kanaong kaogaringeng pagbeet. ");
INSERT INTO mmn_vpl VALUES ("JN6_39","073_6_39","JHN","6","39","39","Kamhan ya naazakan na Diyos ani ya paghatag ka bag-ong kinabohi nga diri mawara dizan ka mga tao nga insarig naiza kanao. Kamhan panbohien nao sirang tanan pagbalik garing ka mga lebeng kay-an ka kataposan nga aldaw. ");
INSERT INTO mmn_vpl VALUES ("JN6_40","073_6_40","JHN","6","40","40","Kay naazakan na kanaong Ama nga ya tanan mga minkita ka toong Maanak daw mintoo kanangiza tagan gazed siran ka bag-ong kinabohi nga diri mawara. Kamhan panbohien nao siran pagbalik garing ka mga lebeng kay-an ka kataposan nga aldaw. ");
INSERT INTO mmn_vpl VALUES ("JN6_41","073_6_41","JHN","6","41","41","Pagkakamhan ka nagamahay ya mga oloolo na mga Yodayo kay minlaong si Hisos nga iza ya makaen nga mingaring daked ka langit. ");
INSERT INTO mmn_vpl VALUES ("JN6_42","073_6_42","JHN","6","42","42","Kamhan namaglaonglaong siran nga ini nga tao nga si Hisos maanak ka lamang iza ni Hosi. Nakakilala kita ka toong ama daw ina. Kamhan ono sa iza minlaong nga mingaring iza daked ka langit? ");
INSERT INTO mmn_vpl VALUES ("JN6_43","073_6_43","JHN","6","43","43","Minsambag si Hisos kaniran nga diri kamo magmahay. ");
INSERT INTO mmn_vpl VALUES ("JN6_44","073_6_44","JHN","6","44","44","Kay bisan sin-o nga taohana diri iza ansakop kanao kon diri antandeg ka toong hinawa ya Diyos nga minpakarimbaba kanao. Kamhan ya tao nga ansakop kanao bohien nao iza pagbalik garing ka lebeng kay-an ka kataposan nga aldaw. ");
INSERT INTO mmn_vpl VALUES ("JN6_45","073_6_45","JHN","6","45","45","Kay kawandini pen minsoyat ya mga propita na Diyos nagalaong nga ya tanan mga tao pagasindoon siran na Diyos. Kamhan ya mga nagapanalinga ka kanaong Ama daw magatoon ka toong pagsindo siran ya ansakop kanao. ");
INSERT INTO mmn_vpl VALUES ("JN6_46","073_6_46","JHN","6","46","46","Waray makakita ka Ama nga Diyos sokad. Hao kay makakita kanangiza kay garing hao kanangiza. ");
INSERT INTO mmn_vpl VALUES ("JN6_47","073_6_47","JHN","6","47","47","Sabten mazo ini nga ya tao nga antoo kanao tagan matood iza ka bag-ong kinabohi nga diri mawara. ");
INSERT INTO mmn_vpl VALUES ("JN6_48","073_6_48","JHN","6","48","48","Na, ya makaen nga makahatag ka bag-ong kinabohi nga diri mawara ani hao. ");
INSERT INTO mmn_vpl VALUES ("JN6_49","073_6_49","JHN","6","49","49","Ya kamazong mga karaan nangapatay siran doro ka dakolang nag-as bisan minkaen siran ka makaen nga inngaranan ka mana nga nangatanak garing daked ka langit. ");
INSERT INTO mmn_vpl VALUES ("JN6_50","073_6_50","JHN","6","50","50","Kamhan ya matood nga makaen nga impanan-og nao nga mingaring ka langit, ya tao nga ankaen kaiton mabohi iza kawanihen ka. ");
INSERT INTO mmn_vpl VALUES ("JN6_51","073_6_51","JHN","6","51","51","Kay hao ya matood nga makaen nga mingaring daked ka langit. Kamhan ya tao nga ankaen kanao mabohi iza kawanihen ka. Kamhan ya matood nga makaen nga ihatag nao ani ya kanaong lawas. Ihatag nao iton para ka tanan mga tao dazaw may bag-ong kinabohi niran. Ani ini ya sambag ni Hisos ka mga Yodayo. ");
INSERT INTO mmn_vpl VALUES ("JN6_52","073_6_52","JHN","6","52","52","Kamhan nagalalis ya mga oloolo na mga Yodayo ka isa daw isa nagalaong nga onhon sa naiton nga tao paghatag kanta ka toong lawas nga ipakaen sa? ");
INSERT INTO mmn_vpl VALUES ("JN6_53","073_6_53","JHN","6","53","53","Minsambag si Hisos nga sabten mazo ini nga kon diri kamo ankaen ka kanaong onod, kon diri isab kamo an-inem ka kanaong dogo waray kinabohi mazo nga matood nga garing ka Diyos. ");
INSERT INTO mmn_vpl VALUES ("JN6_54","073_6_54","JHN","6","54","54","Ya tao nga ankaen ka kanaong onod daw an-inem ka kanaong dogo may toong bag-ong kinabohi nga diri mawara. Kamhan bohien ka sab nao iza pagbalik garing ka lebeng kay-an ka kataposan nga aldaw. ");
INSERT INTO mmn_vpl VALUES ("JN6_55","073_6_55","JHN","6","55","55","Kay ya onod nao ani ya matood nga makaen. Ya dogo nao ani ya matood nga imnenen. ");
INSERT INTO mmn_vpl VALUES ("JN6_56","073_6_56","JHN","6","56","56","Ya tao nga ankaen ka onod nao daw an-inem ka dogo nao naisa ka kami. ");
INSERT INTO mmn_vpl VALUES ("JN6_57","073_6_57","JHN","6","57","57","Ya Diyos nga diri mapatay minpakarimbaba iza kanao. Kamhan garing kanangiza ya kanaong pagkabohi. Kamhan ya tao nga ankaen kanao mabohi isab iza kay garing kanao ya toong pagkabohi. ");
INSERT INTO mmn_vpl VALUES ("JN6_58","073_6_58","JHN","6","58","58","Ya makaen nga inlaong nao kamazo mingaring iton ka langit. Diri kon singed ka makaen inngaranan ka mana nga inkaen na kamazong karaan kay bisan minkaen siran kaiza nangapatay siran gihapon. Kamhan ya tao nga ankaen ka makaen nga inhatag nao may toong bag-ong kinabohi nga diri mawara. ");
INSERT INTO mmn_vpl VALUES ("JN6_59","073_6_59","JHN","6","59","59","Ani ini ya pagpanaba ni Hisos pagsindo naiza dizan ka singbahan na mga Yodayo doro ka longsod nga Kapirnaom. ");
INSERT INTO mmn_vpl VALUES ("JN6_60","073_6_60","JHN","6","60","60","Pagpakabati ka na mga sakop ni Hisos ka toong pagsindo mataed siran namaglaonglaong nga malised iton nga sindo. Daw sin-o ya makaanget ka pagpanalinga? ");
INSERT INTO mmn_vpl VALUES ("JN6_61","073_6_61","JHN","6","61","61","Kamhan bisan waray maglaong kan Hisos mahagdam iza ka kanirang pagmahay. Kamhan nangotana iza nga daw nazehet kamo ka kanaong pagsindo? ");
INSERT INTO mmn_vpl VALUES ("JN6_62","073_6_62","JHN","6","62","62","Kay-an ka pagkita mazo ka pagkandaked nao ka daan hela nao andakola pen ya pagkazehet mazo. ");
INSERT INTO mmn_vpl VALUES ("JN6_63","073_6_63","JHN","6","63","63","Ya Madazaw nga Ispirito na Diyos iza kay makahatag ka tao ka matood nga kinabohi, diri kon garing iton ka hinang na tao. Ya kanaong inpanaba kamazo garing iton ka Madazaw nga Ispirito na Diyos. Kamhan makahatag iton kamazo ka bag-ong kinabohi. ");
INSERT INTO mmn_vpl VALUES ("JN6_64","073_6_64","JHN","6","64","64","Piro dini kamazo may mga diri antoo kanao. Ani ini ya inlaong ni Hisos kay sokad ka pagsakop niran kanangiza nahagdam iza daan kon sin-o ya diri antoo kanangiza. Nahagdam sab iza daan kon sin-o iton dizan nga an-edlaw kanangiza. ");
INSERT INTO mmn_vpl VALUES ("JN6_65","073_6_65","JHN","6","65","65","Indogangan naiza paglaong kaniran nga ipanan-og nao kamazo nga waray makasakop kanao kon diri ipatandeg na kanaong Ama ya hinawa na tao. ");
INSERT INTO mmn_vpl VALUES ("JN6_66","073_6_66","JHN","6","66","66","Pagpanaba ni Hisos singed kaiton mataed ya toong sakop nga minbelag di kanangiza. ");
INSERT INTO mmn_vpl VALUES ("JN6_67","073_6_67","JHN","6","67","67","Kamhan nangotana si Hisos ka napolo may dowa nga mga sinarigan nga daw anbelag sab kamo kanao? ");
INSERT INTO mmn_vpl VALUES ("JN6_68","073_6_68","JHN","6","68","68","Minsambag si Simon Pidro nga Ginoo, waray lain insakopan nami. Iko ka say tag-iza ka mga panaba nga makahatag ka bag-ong kinabohi nga diri mawara. ");
INSERT INTO mmn_vpl VALUES ("JN6_69","073_6_69","JHN","6","69","69","Mintoo kami kanmo. Nahagdam sab kami nga iko ya isa nga waray sala nga garing ka Diyos. ");
INSERT INTO mmn_vpl VALUES ("JN6_70","073_6_70","JHN","6","70","70","Minsambag si Hisos nga kamo ya kanaong impili nga napolo may dowa nga tao kamhan ya isa kan Satanas iza. ");
INSERT INTO mmn_vpl VALUES ("JN6_71","073_6_71","JHN","6","71","71","Ani ini ya inlaong ni Hisos kay dizan ka toong mga napolo may dowa nga sinarigan si Hodas nga maanak ni Simon Iskariyoti ani iza ya an-edlaw kan Hisos. ");
INSERT INTO mmn_vpl VALUES ("JN7_1","073_7_1","JHN","7","1","1","Pagkakamhan dizan lamang ka lopa nga Galiliya minsoroy si Hisos pagwali naiza ka mga tao. Diri di iza ankaro ka lopa nga Yoda kay patazen sa iza kontana na mga oloolo na mga Yodayo. ");
INSERT INTO mmn_vpl VALUES ("JN7_2","073_7_2","JHN","7","2","2","Na, iton nga panahon hapit di andateng ya isang pista na mga Yodayo. Pagpista niran inhinang niran ya mga tal-ob kay ani ya batasan niran ka pagpasalamat ka Diyos ka kanirang anihen. Agon inngaranan niran ka Pista ka Mga Tal-ob. ");
INSERT INTO mmn_vpl VALUES ("JN7_3","073_7_3","JHN","7","3","3","Kamhan ya mga lomon ni Hisos minlaong siran kanangiza nga pomanaw ko dini ka Galiliya. Komaro ko naa ngaro ka lopa nga Yoda dazaw ya mga taga Yoda nga mintoo kanmo makakita sab siran ka mga hinang mo. ");
INSERT INTO mmn_vpl VALUES ("JN7_4","073_7_4","JHN","7","4","4","Kay kon matood nga timaan iton nga garing iko ka Diyos ipakita ya kanmong kaogaringen doro ka lopa nga Yoda kay kon ipabantog na tao ya toong kaogaringeng ngaran diri iza antarabaho dini ka waray makakita. ");
INSERT INTO mmn_vpl VALUES ("JN7_5","073_7_5","JHN","7","5","5","Ani ini ya kanirang saba kan Hisos kay bisan siran ya toong mga lomon wara pen siran magtoo nga garing iza ka Diyos. ");
INSERT INTO mmn_vpl VALUES ("JN7_6","073_7_6","JHN","7","6","6","Kamhan minsambag si Hisos nga wara pen dateng ya kanaong tirmino ka pagpakita ka kanaong kaogaringen ka mga tao. Kamo ka lamang ya ankaro ka pista koman kay waray tirmino mazo ka pagtoman ka naazakan na Diyos singed kanao. ");
INSERT INTO mmn_vpl VALUES ("JN7_7","073_7_7","JHN","7","7","7","Diri magakontara ya mga tao kamazo. Hao ya pagakontarahan niran kay minbaheg hao kaniran kay maonga ya batasan niran. ");
INSERT INTO mmn_vpl VALUES ("JN7_8","073_7_8","JHN","7","8","8","Kamo ka lamang ya ankaro ka pista. Diri hao an-iba kamazo kay wara pen dateng ya kanaong tirmino ka pagpakita ka kanaong kaogaringen dizan ka mga tao. ");
INSERT INTO mmn_vpl VALUES ("JN7_9","073_7_9","JHN","7","9","9","Pagkakamhan naiza paglaong nabilin iza dizan ka lopa nga Galiliya. ");
INSERT INTO mmn_vpl VALUES ("JN7_10","073_7_10","JHN","7","10","10","Na, pagpanaw na toong mga lomon ngaro ka pista anipen iza ankaro nga isa ka iza. ");
INSERT INTO mmn_vpl VALUES ("JN7_11","073_7_11","JHN","7","11","11","Kamhan dizan ka pista may mga oloolo na mga Yodayo. Nagapakigkita siran kan Hisos daw hain sa iza? ");
INSERT INTO mmn_vpl VALUES ("JN7_12","073_7_12","JHN","7","12","12","Namaglaonglaong sab ya mga tao paghilom nga beetan si Hisos. Kamhan minsambag ya mga isang tao nga diri gazed kay nagapanlimbong iza ka mga tao. ");
INSERT INTO mmn_vpl VALUES ("JN7_13","073_7_13","JHN","7","13","13","Diri ambaskeg ya mga tao ka kanirang saba kay nahaldek siran ka kanirang mga oloolo nga Yodayo. ");
INSERT INTO mmn_vpl VALUES ("JN7_14","073_7_14","JHN","7","14","14","Na, ka hapit di matenga nga ka pista minseled si Hisos ka dakolang lagkaw nga pangamozoanan ka Diyos kay ansogod iza ka pagsindo ka mga tao dizan. ");
INSERT INTO mmn_vpl VALUES ("JN7_15","073_7_15","JHN","7","15","15","Kamhan nabereng ya mga Yodayo nagalaong nga onhon sa baza iza nakalabaw pagsabot ka tanan? Wara iza mag-iskwila dini kanami sokad. ");
INSERT INTO mmn_vpl VALUES ("JN7_16","073_7_16","JHN","7","16","16","Minsambag si Hisos nga ya pagsindo nao diri kon garing kanao kay garing gazed ka Diyos nga minpakarimbaba kanao. ");
INSERT INTO mmn_vpl VALUES ("JN7_17","073_7_17","JHN","7","17","17","Kamhan kon maazak ya tao ka pagtoman ka maazakan na Diyos mahagdam sab iza nga garing ka Diyos ya pagsindo nao, diri kon garing ka kanaong hena-hena. ");
INSERT INTO mmn_vpl VALUES ("JN7_18","073_7_18","JHN","7","18","18","Kon garing ka kaogaringen na tao ya pagsindo gosto naiza nga sazaen iza na mga tao. Kon gosto na tao ka pagsaza ka Diyos nga minsarig kanangiza ka pagsindo, matadeng gazed ini nga tao diri kon bakaken. ");
INSERT INTO mmn_vpl VALUES ("JN7_19","073_7_19","JHN","7","19","19","Kawandini pen minhatag si Moysis kamazo ka balaed na Diyos. Kamhan bisan kamo ya diri antoman kaiton nga balaed, gosto baza kamo ampatay kanao nga minlapas koni kaiton nga balaed. ");
INSERT INTO mmn_vpl VALUES ("JN7_20","073_7_20","JHN","7","20","20","Kamhan minsambag ya mga tao kan Hisos nga inboang ko na maonga! Daw sin-o say ampatay kanmo kontana? ");
INSERT INTO mmn_vpl VALUES ("JN7_21","073_7_21","JHN","7","21","21","Minsambag si Hisos nga izang dini kaini ya hinang nao nga minpakawara ka kasakit na nabedlay nabereng kamo kay minhinang hao kaiton ka aldaw nga tigpahimlay. ");
INSERT INTO mmn_vpl VALUES ("JN7_22","073_7_22","JHN","7","22","23","Na, bisan kon aldaw nga tigpahimlay anhinang kamo ka batasan mazo ka amaamahay nga impatori kay antoman kamo koni ka balaed nga inhatag ni Moysis daw ya mga karaang Yodayo. Kamhan kay ono say pagakazethan mazo kanao pagpakadazaw nao ka lawas na nabedlay ka aldaw nga tigpahimlay? ");
INSERT INTO mmn_vpl VALUES ("JN7_24","073_7_24","JHN","7","24","24","Magheneng kamo pagdaetdaet kanao ka pagpanaba mazo mahitenged ka hinang nao ka nabedlay. Basta dazawen mazo ya kamazong hena-hena. ");
INSERT INTO mmn_vpl VALUES ("JN7_25","073_7_25","JHN","7","25","25","Kamhan namaglaong ya mga isang taga Hirosalem nga iton nga tao ani kombeet ya patazenen na kantang mga oloolo. ");
INSERT INTO mmn_vpl VALUES ("JN7_26","073_7_26","JHN","7","26","26","Bisan mabaskeg ya toong pagpanaba wara iza bahegi na kantang mga oloolo. Basi hinoa mahagdam di siran nga ani iza gazed si Kristo nga hari nga pinili na Diyos. ");
INSERT INTO mmn_vpl VALUES ("JN7_27","073_7_27","JHN","7","27","27","Mahagdam kita daan kon taga diin iton nga tao. Basta kay kon domateng si Kristo waray mahagdam kon hain iza garing. ");
INSERT INTO mmn_vpl VALUES ("JN7_28","073_7_28","JHN","7","28","28","Pagpakabati ni Hisos kaiton mindakola iza ka toong saba pagsindo naiza dizan ka lagkaw nga pangamozoanan ka Diyos nagalaong nga daw wara kamo mahagdam kon sin-o sa hao? Daw wara baza kamo mahagdam kon hain garing hao? Wara gazed hao magbeet ka kanaong pagkarini. Ya minpakarimbaba kanao matadeng gazed iza. Kamhan wara kamo mahagdam kon sin-o iza. ");
INSERT INTO mmn_vpl VALUES ("JN7_29","073_7_29","JHN","7","29","29","Mahagdam hao daan kon sin-o sa iza kay garing sa hao kanangiza kay iza ya minpakarimbaba kanao. ");
INSERT INTO mmn_vpl VALUES ("JN7_30","073_7_30","JHN","7","30","30","Pagkakamhan ni Hisos pagpanaba kaiza dakpen kontana iza na mga oloolo na mga Yodayo kay ipapriso piro wara mahimo kay wara pen dateng ya tirmino nga dakpen iza. ");
INSERT INTO mmn_vpl VALUES ("JN7_31","073_7_31","JHN","7","31","31","Dizan disab may mga mamistahay nga mintoo di kan Hisos nagalaong nga kon andateng si Kristo nga kantang intagadan daw labaw pen ya toong hinang ka mga inhinang naiton nga tao? ");
INSERT INTO mmn_vpl VALUES ("JN7_32","073_7_32","JHN","7","32","32","Na, ya mga Parasiyo nakabati siran ka mga panaba na mga tao mahitenged kan Hisos. Kamhan siran daw ya mga oloolo na mga pari minsogo siran ka mga soldaw ka pagdakep kan Hisos. ");
INSERT INTO mmn_vpl VALUES ("JN7_33","073_7_33","JHN","7","33","33","Mahagdam si Hisos ka kanirang hinang agon minlaong iza nga diri pen hao madakep kay an-iba pen hao kamazo ka diri kon madogay. Kamhan an-oli hao daked kanangiza nga minpakarimbaba kanao. ");
INSERT INTO mmn_vpl VALUES ("JN7_34","073_7_34","JHN","7","34","34","Kamhan ampangita kamo kanao piro diri hao kakitan. Diri sab kamo makasonod kanao doro ka kanaong karohan. ");
INSERT INTO mmn_vpl VALUES ("JN7_35","073_7_35","JHN","7","35","35","Namaglaong ya mga oloolo nga Yodayo nga daw ankar-in sa baza iza pagsinged nga diri sa kita makasonod kanangiza? Daw ankaro iza ka mga lain dapit nga inlaaglaagan na angay ta dazaw antoldo pen iza ka mga diri kon Yodayo doro? ");
INSERT INTO mmn_vpl VALUES ("JN7_36","073_7_36","JHN","7","36","36","Nagahena-hena siran nga kay ono sa iza maglaong nga ampangita kami kanangiza kamhan diri iza makita kay diri kami makasonod ngaro ka karohan naiza? Ani ini ya kanirang hena-hena kay wara siran mahagdam kon ono ya kahologan na toong inpanaba kaniran. ");
INSERT INTO mmn_vpl VALUES ("JN7_37","073_7_37","JHN","7","37","37","Pagdateng ka pagkaliwas na pista mintindeg si Hisos dizan ka lagkaw na Diyos. Kamhan minbaskeg iza ka toong saba pagsindo naiza kaniran. Kamhan minpamolinged iza nagalaong nga ya in-ohaw nga tao kinahanglan komarini iza dini kanao dazaw an-inem iza ka sapa nga ihatag nao kanangiza. ");
INSERT INTO mmn_vpl VALUES ("JN7_38","073_7_38","JHN","7","38","38","Dini ka tao nga mintoo kanao ihatag nao ya bag-ong kinabohi nga diri mawara. Kamhan iton nga kinabohi ani ya singed ka mga sapa nga diri anhebas. Pamolinged ini nga impasoyat daan na Diyos. ");
INSERT INTO mmn_vpl VALUES ("JN7_39","073_7_39","JHN","7","39","39","Ani ini ya insindo ni Hisos mahitenged ka Madazaw nga Ispirito nga garing ka Diyos. Pagpanaba ni Hisos kaniran wara pen dateng ya Ispirito dini ka mga mintoo kanangiza. Kay kinahanglan patazen pen si Hisos. Kamhan mabohi iza pagbalik garing ka lebeng anipen domateng ya Madazaw nga Ispirito nga garing ka Diyos. ");
INSERT INTO mmn_vpl VALUES ("JN7_40","073_7_40","JHN","7","40","40","Pagpakabati ka na mga tao ka mga panaba ni Hisos minlaong ya mga isa nga iton nga tao ani gazed ya propita nga kanaming intagadan. ");
INSERT INTO mmn_vpl VALUES ("JN7_41","073_7_41","JHN","7","41","41","Minlaong ya mga iba nga iton nga tao ani gazed si Kristo nga hari nga pinili na Diyos. Dizan disab may mga nagalalis nga nagalaong nga si Kristo diri kon garing iza ka Galiliya ");
INSERT INTO mmn_vpl VALUES ("JN7_42","073_7_42","JHN","7","42","42","kay impasoyat na Diyos daan nagalaong nga si Kristo kaliwatan iza ni Dabid. Kamhan matao iza doro ka longsod nga Bitlihim nga nataohan ni Dabid. ");
INSERT INTO mmn_vpl VALUES ("JN7_43","073_7_43","JHN","7","43","43","Kamhan nagalalislalis ya isa daw isa kon iza si Kristo kon diri sa. ");
INSERT INTO mmn_vpl VALUES ("JN7_44","073_7_44","JHN","7","44","44","Kamhan may mga isa nga gosto andakep kanangiza piro wara iza madakep. ");
INSERT INTO mmn_vpl VALUES ("JN7_45","073_7_45","JHN","7","45","45","Pagkakamhan minbalik ya mga soldaw ka mga oloolo na mga pari daw ya mga Parasiyo. Pagdateng niran nangotana ya mga oloolo nga kay ono sa wara mazo dadha iza ngarini? ");
INSERT INTO mmn_vpl VALUES ("JN7_46","073_7_46","JHN","7","46","46","Minsambag siran nga wara sa sokad ya tao nga makapanaba singed kaini nga tao. ");
INSERT INTO mmn_vpl VALUES ("JN7_47","073_7_47","JHN","7","47","47","Minsambag ya mga Parasiyo nga inlimbongan sab baza kamo naiza. ");
INSERT INTO mmn_vpl VALUES ("JN7_48","073_7_48","JHN","7","48","48","Dini kanami nga kamazong mga oloolo daw ya mga Parasiyo waray antoo kan Hisos. ");
INSERT INTO mmn_vpl VALUES ("JN7_49","073_7_49","JHN","7","49","49","Kamhan ya mga tao dini nga inlimbongan naiza wara siran mahagdam ka balaed ni Moysis singed kanami agon silotan gazed siran. ");
INSERT INTO mmn_vpl VALUES ("JN7_50","073_7_50","JHN","7","50","50","Kamhan dini ka mga oloolo may isa nga minbisita kan Hisos izang dini kaini si Nikodimo ya ngaran. Iza ya minlaong kaniran nga ");
INSERT INTO mmn_vpl VALUES ("JN7_51","073_7_51","JHN","7","51","51","ya kantang balaed diri mahimo ya paghokom ka tao kon wara pen ya logar naiza ka pagsambag ka mga ampangotana kanangiza. ");
INSERT INTO mmn_vpl VALUES ("JN7_52","073_7_52","JHN","7","52","52","Minsambag siran nga kay ono sa ko antabang kanangiza? Daw taga Galiliya iko singed kanangiza? Magtoon ko ka kasoyatan na Diyos dazaw mahagdam ko nga bisan sin-o ya propita na Diyos wara iza garing ka Galiliya. ");
INSERT INTO mmn_vpl VALUES ("JN7_53","073_7_53","JHN","7","53","53","Na, pagkakamhan kaiza nangoli di ya tagsa tagsa kaniran. ");
INSERT INTO mmn_vpl VALUES ("JN8_1","073_8_1","JHN","8","1","1","Kamhan minbalik si Hisos ka bobong nga Olibo ya ngaran. ");
INSERT INTO mmn_vpl VALUES ("JN8_2","073_8_2","JHN","8","2","2","Pagkamasiselem ka minsazo iza pagbalik ka dakolang lagkaw nga pangamozoanan ka Diyos. Kamhan mataed ya mga tao nga nagatipon dizan. Kamhan minlo-to iza kay ansindo pen iza kaniran. ");
INSERT INTO mmn_vpl VALUES ("JN8_3","073_8_3","JHN","8","3","3","Na, ka nagasindo pen iza kaniran minkarini ya mga maistro ka tinoohan na mga Yodayo daw ya mga Parasiyo. Kay in-ated niran ya isang babazi nga nasakpan nga nanapaw. Kamhan patindegen iza dizan ka tenged na mga tao. ");
INSERT INTO mmn_vpl VALUES ("JN8_4","073_8_4","JHN","8","4","4","Kamhan minlaong siran kan Hisos nga Maistro, ini nga babazi nasakpan nga nanapaw. ");
INSERT INTO mmn_vpl VALUES ("JN8_5","073_8_5","JHN","8","5","5","Kamhan ya balaed nga inhatag kanta ni Moysis ani nagasogo nga ya minhinang ka singed kaiton kinahanglan pamagbatohan keteb ka pagpatay. Na, ono ya kanmong ikapanaba? ");
INSERT INTO mmn_vpl VALUES ("JN8_6","073_8_6","JHN","8","6","6","Ani ini ya kanirang pangotana kay gosto siran anporba kan Hisos dazaw may ikasombong niran. Kamhan mindongò si Hisos ka pagsoyat ka lopa nga ingamit ya toong toldo. ");
INSERT INTO mmn_vpl VALUES ("JN8_7","073_8_7","JHN","8","7","7","Sigi niran baliken ya pagpangotana. Kamhan mintindeg si Hisos daw maglaong kaniran nga dini kamazo bisan sin-o ya wara makasala iza gazed ya anhon-a pagpook kanangiza. ");
INSERT INTO mmn_vpl VALUES ("JN8_8","073_8_8","JHN","8","8","8","Kamhan mindongò iza pagbalik ka pagsoyat ka lopa. ");
INSERT INTO mmn_vpl VALUES ("JN8_9","073_8_9","JHN","8","9","9","Pagpakabati ka niran ka saba ni Hisos nagatagsatagsa siran pagpanaw dizan. Ya mga malaas nanhon-a sonod ya mga batan-en. Wara ya minbato ka babazi kay nasakpan ya hinawa niran ka saba ni Hisos. Kamhan si Hisos ya nabilin daw ya babazi nga nagatindeg dizan. ");
INSERT INTO mmn_vpl VALUES ("JN8_10","073_8_10","JHN","8","10","10","Paghangad naiza ka babazi minlaong iza nga Day, daw hain sa siran? Daw waray minpabilin ka pagsilot kanmo ka pagpatay? ");
INSERT INTO mmn_vpl VALUES ("JN8_11","073_8_11","JHN","8","11","11","Minsambag ya babazi nga wara, Sinyor. Minsambag si Hisos nga diri hao isab ansilot kanmo. Pomanaw di ko. Bomiza di ko ka batasan nga maonga. Ani ini ya impanaba naiza ka babazi. ");
INSERT INTO mmn_vpl VALUES ("JN8_12","073_8_12","JHN","8","12","12","Kamhan dizan ka mga tao indogangan pen ni Hisos pagsindo kaniran mahitenged ka toong kaogaringen nga nagalaong nga hao ya tag-iza ka kapawa. Kamhan makawara hao ka kadeglem dalem ka hena-hena na tanan mga tao. Kamhan ya tao nga antoo kanao singed ka diri kon madeglem ya toong panawan kay ilawan di iza. Kamhan iton nga kapawa nga makawara ka kadeglem ani isab ya makahatag kanangiza ka kinabohi nga diri mawara. ");
INSERT INTO mmn_vpl VALUES ("JN8_13","073_8_13","JHN","8","13","13","Minsambag ya mga Parasiyo nga iko ka lamang ya minpanan-og mahitenged ka kanmong kaogaringen agon diri kon matood. ");
INSERT INTO mmn_vpl VALUES ("JN8_14","073_8_14","JHN","8","14","14","Minsambag si Hisos nga bisan hao ya minpanan-og mahitenged ka kanaong kaogaringen matood ya kanaong panaba kay mahagdam hao kon hain hao garing daw hain ya kanaong panawanan. Basta kamo wara kamo mahagdam kon hain hao garing daw hain ya kanaong panawanan. ");
INSERT INTO mmn_vpl VALUES ("JN8_15","073_8_15","JHN","8","15","15","Garing ka kamazong hena-hena ya paghokom mazo kanao. Diri hao anhaod ka kamazong batasan ka paghokom ");
INSERT INTO mmn_vpl VALUES ("JN8_16","073_8_16","JHN","8","16","16","kay matadeng ya paghokom nao ka tao kay diri kon isa ka hao ya anhokom basta hao daw iza nga minpakarimbaba kanao. ");
INSERT INTO mmn_vpl VALUES ("JN8_17","073_8_17","JHN","8","17","17","May balaed mazo nga nagalaong nga kon mag-anika ya panan-og na dowang ka saksi matood gazed ya kanirang panan-og. ");
INSERT INTO mmn_vpl VALUES ("JN8_18","073_8_18","JHN","8","18","18","Na, hao ya nagapanan-og kon sin-o sa hao. Kamhan nagapamatood ya Ama nga Diyos nga hao ya inpakarimbaba naiza. ");
INSERT INTO mmn_vpl VALUES ("JN8_19","073_8_19","JHN","8","19","19","Minsambag ya mga Parasiyo pagpangotana nga daw hain ya Ama mo maghela? Minsambag si Hisos nga wara kamo makasabot kon sin-o sa hao daw sin-o ya kanaong Ama. Kon ankilala kamo kanao makakilala sab kamo ka Ama nao. ");
INSERT INTO mmn_vpl VALUES ("JN8_20","073_8_20","JHN","8","20","20","Ani ini ya pagpanaba ni Hisos ka dizan pen iza ka dakolang lagkaw nga pangamozoanan ka Diyos. Pagpanaba naiza kaiton dizan iza ka betanganan ka kowarta nga ihaladay na mga tao. Labzanan iton na mga mataed nga tao. Kamhan waray andakep kanangiza kay wara pen dateng ya tirmino nga dakpen iza. ");
INSERT INTO mmn_vpl VALUES ("JN8_21","073_8_21","JHN","8","21","21","Na, indogangan pen ni Hisos pagsindo kaniran nagalaong nga may tirmino nao nga ampanaw hao dini kamazo. Kamhan ampangita gazed kamo kanao piro mapatay kamo kay may mga sala pen mazo kay diri kamo antoo kanao. Diri mahimo ya pagkaro mazo ka kanaong datnganan. ");
INSERT INTO mmn_vpl VALUES ("JN8_22","073_8_22","JHN","8","22","22","Namaglaonglaong dazon ya mga oloolo pagsora nga iza gazed ya ampatay ka toong kaogaringeng lawas agon minlaong iza nga diri sa kita makakaro ka toong datnganan. ");
INSERT INTO mmn_vpl VALUES ("JN8_23","073_8_23","JHN","8","23","23","Indogangan pen ni Hisos pagpanaba kaniran nagalaong nga taga lopa gazed kamo basta hao taga daked sa hao. Kanang kalibotan ya tanan hena-hena mazo piro ya kanaong hena-hena diri kon kanang kalibotan. ");
INSERT INTO mmn_vpl VALUES ("JN8_24","073_8_24","JHN","8","24","24","Minlaong hao kamazo nga mapatay kamo ka wara mapasaylo ya mga sala mazo. Antoman gazed ini kon diri kamo antoo nga hao si Kristo nga hari nga pinili na Diyos. ");
INSERT INTO mmn_vpl VALUES ("JN8_25","073_8_25","JHN","8","25","25","Minsambag siran nga daw sin-o sa iko? Minsambag si Hisos nga hao ya impanan-og nao kamazo sokad ka pagdateng nao dini kamazo. ");
INSERT INTO mmn_vpl VALUES ("JN8_26","073_8_26","JHN","8","26","26","Kamhan mataed pen kontana ya baheg nao kamazo paghokom ka kamazong batasan. Basta koman dini ka mga tao inpanan-og nao ya nabatian nao garing ka minpakarimbaba kanao kay matadeng gazed iza. ");
INSERT INTO mmn_vpl VALUES ("JN8_27","073_8_27","JHN","8","27","27","Kamhan wara siran makasabot nga ya Diyos nga toong Ama ani ya impanan-og ni Hisos kaniran. ");
INSERT INTO mmn_vpl VALUES ("JN8_28","073_8_28","JHN","8","28","28","Agon indogangan pen ni Hisos paglaong kaniran nga kay-an kon ilansang di hao mazo ka kros anipen kamo mahagdam nga hao si Kristo nga hari nga pinili na Diyos. Kamhan mahagdam isab kamo nga diri kon hao ya ambeet ka kanaong mga inhinang basta ya mga panaba nao garing iton ka Ama nga minsindo kanao. ");
INSERT INTO mmn_vpl VALUES ("JN8_29","073_8_29","JHN","8","29","29","Kamhan iza nga minpakarimbaba kanao onay nagaibaiba kanao. Diri iza ambelag kanao kay onay hao nagahinang ka mga makasaza kanangiza. ");
INSERT INTO mmn_vpl VALUES ("JN8_30","073_8_30","JHN","8","30","30","Na, pagkakamhan kaiza mataed ya mintoo ka toong mga panaba. ");
INSERT INTO mmn_vpl VALUES ("JN8_31","073_8_31","JHN","8","31","31","Kamhan dizan ka mga Yodayo nga mintoo kanangiza minlaong si Hisos nga kon tomanen mazo ya kanaong sindo, kamo matood ya kanaong mga sakop. ");
INSERT INTO mmn_vpl VALUES ("JN8_32","073_8_32","JHN","8","32","32","Kamhan mahagdaman mazo nga hao nga si Kristo ani ya matood nga Diyos. Kamhan anlibri hao kamazo ka pagkaoripen mazo. ");
INSERT INTO mmn_vpl VALUES ("JN8_33","073_8_33","JHN","8","33","33","Minsambag siran nga mga kaliwatan kami ni Abraham nga toboan na mga Yodayo. Sokad kawandini pen dogay di waray tag-iza kanami. Kay ono sa ko nagalaong nga iko ya anlibri kanami ka pagkaoripen nami kon ansakop kami kanmo? ");
INSERT INTO mmn_vpl VALUES ("JN8_34","073_8_34","JHN","8","34","34","Minsambag si Hisos nga timan-an mazo gazed ini nga kon maonga ya batasan na tao singed ka in-oripen iza na maongang batasan kamhan diri iza makabohi ka toong kaogaringen dizan ka gapos. ");
INSERT INTO mmn_vpl VALUES ("JN8_35","073_8_35","JHN","8","35","35","Pamolinged ini nga ya oripen nga tao wara gazed ya katenged naiza dini ka lagkaw na toong amo basta kay ya maanak na amo ani ya may katenged kay iza ya kaliwat. ");
INSERT INTO mmn_vpl VALUES ("JN8_36","073_8_36","JHN","8","36","36","Kamhan hao nga Maanak na Diyos kon hao ya anlibri kamazo garing ka pagkaoripen mazo ka maongang batasan matood gazed ya pagkalibri mazo. ");
INSERT INTO mmn_vpl VALUES ("JN8_37","073_8_37","JHN","8","37","37","Bisan kamo matood ya mga kaliwatan ni Abraham gosto baza kamo ampatay kanao kay diri kamo ansogot ka kanaong sindo. ");
INSERT INTO mmn_vpl VALUES ("JN8_38","073_8_38","JHN","8","38","38","Impanaba nao ya nakitan nao ka daked pen hao ka Ama nao. Kamhan ya nabatian mazo dizan ka ama mazo ani ya inhinang mazo. ");
INSERT INTO mmn_vpl VALUES ("JN8_39","073_8_39","JHN","8","39","39","Minsambag ya mga Yodayo nga si Abraham ani ya toboan nami nga mga Yodayo. Minsambag si Hisos nga kon kamo ya mga kaliwatan ni Abraham ya batasan mazo daw si Abraham mag-anika. ");
INSERT INTO mmn_vpl VALUES ("JN8_40","073_8_40","JHN","8","40","40","Ambaza kay gosto kamo ampatay kanao kay nagasindo hao kamazo ka nabatian nao garing ka Diyos. Wara si Abraham magbatasan singed kamazo. ");
INSERT INTO mmn_vpl VALUES ("JN8_41","073_8_41","JHN","8","41","41","Inhaod mazo ya batasan na ama mazo. Minsambag siran pag-iseg nga kami nga mga Yodayo isa ka gazed ya ama nami ani iza ya matood nga Diyos. Wara kami magbiza kaini nga tinoohan nami sokad. ");
INSERT INTO mmn_vpl VALUES ("JN8_42","073_8_42","JHN","8","42","42","Minsambag si Hisos nga kon ani iza ya Diyos mazo makaangay kamo kanao kay garing hao kanangiza. Kamhan diri kon hao ya nagabeet ka pagpakarimbaba kanao kay ya Diyos iza gazed ya nagabeet. ");
INSERT INTO mmn_vpl VALUES ("JN8_43","073_8_43","JHN","8","43","43","Wara kamo makasabot ka kanaong sindo kay diri kamo ansogot pagpanalinga. ");
INSERT INTO mmn_vpl VALUES ("JN8_44","073_8_44","JHN","8","44","44","Mga kaliwatan kamo ni Satanas. Kamhan gosto kamo antoman ka toong naazakan nga patazen hao. Talamono iza sokad ka kawandini pen dogay di. Awazen naiza hao nga matood nga Diyos kay wara iza mag-angay ka insindo na Diyos. Kamhan wara iza magpanaba ka matood kay bakaken iza kay iza ya ama ka tanan mga bakak. ");
INSERT INTO mmn_vpl VALUES ("JN8_45","073_8_45","JHN","8","45","45","Kamhan hao ya minpanaba kamazo ka matood nga mga salaan kamo. Kamhan diri kamo antoo kanao. ");
INSERT INTO mmn_vpl VALUES ("JN8_46","073_8_46","JHN","8","46","46","Dini kamazo waray makapahamtang kanao ka sala. Matood ya pagpanaba nao kamazo kamhan kay ono sa nga diri kamo antoo kanao? ");
INSERT INTO mmn_vpl VALUES ("JN8_47","073_8_47","JHN","8","47","47","Kon mga maanak kamo na Diyos ampanalinga kamo ka mga panaba na Diyos. Piro diri kon mga maanak kamo na Diyos agon diri kamo ampanalinga ka toong mga panaba. ");
INSERT INTO mmn_vpl VALUES ("JN8_48","073_8_48","JHN","8","48","48","Kamhan nazehet ya mga oloolo na mga Yodayo nagalaong nga matood gazed ya paglaong nami nga taga Samariya iko nga kaaway na mga Yodayo. Inboang sab ko na maonga! ");
INSERT INTO mmn_vpl VALUES ("JN8_49","073_8_49","JHN","8","49","49","Kamhan mahetek ya pagsambag ni Hisos nagalaong nga wara gazed hao boanga na maonga. Intahod nao ya kanaong Ama kamhan insora mazo hao. ");
INSERT INTO mmn_vpl VALUES ("JN8_50","073_8_50","JHN","8","50","50","Dizan ka mga tao diri hao ampasaza ka kanaong kaogaringen. May isa nga ampasaza ka mga tao kanao. Kamhan matadeng ya toong panaba mahitenged kanao. ");
INSERT INTO mmn_vpl VALUES ("JN8_51","073_8_51","JHN","8","51","51","Timan-an mazo gazed ini nga ya tao nga mintoman ka kanaong sindo diri iza pahamtangan ka kamatazen ka toong mga sala. ");
INSERT INTO mmn_vpl VALUES ("JN8_52","073_8_52","JHN","8","52","52","Minsambag ya mga Yodayo nga nahagdam kami nga inboang ko na maonga. Patay di si Abraham daw ya mga karaang propita na Diyos. Onhon sa mo paglaong nga kon tomanen na tao ya sindo mo diri iza mapatay? ");
INSERT INTO mmn_vpl VALUES ("JN8_53","073_8_53","JHN","8","53","53","Daw labaw iko kan Abraham nga kanaming apo? Iza daw ya mga karaang propita patay di sirang tanan. Daw sin-o sa ko baza? ");
INSERT INTO mmn_vpl VALUES ("JN8_54","073_8_54","JHN","8","54","54","Minsambag si Hisos nga kon ampasaza hao ka kanaong kaogaringen waray kaposlanan kaiton. Ya Ama nao iza kay magapasaza kanao. Iza ya inlaong mazo nga kamazong Diyos. ");
INSERT INTO mmn_vpl VALUES ("JN8_55","073_8_55","JHN","8","55","55","Ambaza kay wara kamo magkilala kanangiza. Hao ya mahagdam kanangiza. Kon nagalaong hao nga wara sa hao mahagdam bakaken hao singed kamazo. Mahagdam gazed hao kanangiza. Tomanen sab nao ya toong sindo. ");
INSERT INTO mmn_vpl VALUES ("JN8_56","073_8_56","JHN","8","56","56","Kawandini pen ka bohi ka si Abraham nga apo mazo nagapahisaza iza kay in-alam naiza ya tirmino ka pagdateng nao ngarimbaba ka kalibotan. Kamhan pagpakakita naiza ka kanaong pagdateng dakola gazed ya toong kasaza. ");
INSERT INTO mmn_vpl VALUES ("JN8_57","073_8_57","JHN","8","57","57","Minsambag ya mga Yodayo nga wara pen ko magdateng ka kalim-an nga ka toig agon onhon sa mo pagkita kan Abraham nga karaan? ");
INSERT INTO mmn_vpl VALUES ("JN8_58","073_8_58","JHN","8","58","58","Minsambag si Hisos nga timan-an mazo gazed ini nga ka wara pen matao si Abraham dizan hao daan. ");
INSERT INTO mmn_vpl VALUES ("JN8_59","073_8_59","JHN","8","59","59","Pagpakabati niran kaiton namorot siran ka mga bato kay pookon iza kontana piro impasalimed iza na Diyos dizan ka mga tao. Kamhan minpanaw iza dizan ka dakolang lagkaw nga pangamozoanan ka Diyos. ");
INSERT INTO mmn_vpl VALUES ("JN9_1","073_9_1","JHN","9","1","1","Lomaza ka pomanaw si Hisos may nakitan naiza nga tao nga dara ka pagkatao ya pagkabota. ");
INSERT INTO mmn_vpl VALUES ("JN9_2","073_9_2","JHN","9","2","2","Kamhan nangotana ya mga sakop ni Hisos nga Maistro, kay ono sa nga inkatao ya pagkabota naiton nga tao? Daw sin-o ya nakasala iza kon ya toong ginikanan? ");
INSERT INTO mmn_vpl VALUES ("JN9_3","073_9_3","JHN","9","3","3","Minsambag si Hisos nga ya toong pagkabota diri kon garing ka toong sala. Diri kon garing ka sala na toong ginikanan basta minbeet ya Diyos dazaw impakita ya hinang nga madazaw gazed. ");
INSERT INTO mmn_vpl VALUES ("JN9_4","073_9_4","JHN","9","4","4","Ka aldaw pen magatarabaho pen ya tao. Kon kahabzen di diri mahimo. Pamolinged ini mahitenged kanao kay ka dini pen hao ka kalibotan kinahanglan antoman hao ka tarabaho nga inhatag na Diyos nga minpakarimbaba kanao kay diri kita makatarabaho kon patay di kita. ");
INSERT INTO mmn_vpl VALUES ("JN9_5","073_9_5","JHN","9","5","5","Ka dini pen hao ka kalibotan singed ka maaldaw pen kay hao ya makapawa ka kadeglem dini ka kalibotan. ");
INSERT INTO mmn_vpl VALUES ("JN9_6","073_9_6","JHN","9","6","6","Ka nagapanaba pen si Hisos min-eleb iza dizan ka lopa kay intigmel naiza ya inelban nga lopa. Kamhan indapi ka mata na bota. ");
INSERT INTO mmn_vpl VALUES ("JN9_7","073_9_7","JHN","9","7","7","Kamhan minsogo iza nga nagalaong nga komaro ko ka linaw inngaranan ka Siloi. Maghiram-os ko doro. Na, ya kahologan na ngaran nga Siloi ani Darahanan. Na, mintoman ya bota ka sogo ni Hisos. Paghiram-os naiza nakakita matood ya toong mata kamhan minbalik iza. ");
INSERT INTO mmn_vpl VALUES ("JN9_8","073_9_8","JHN","9","8","8","Kamhan ya mga songbalay daw ya mga tao nga nakakita ka bota nga mangazoay ka wara pen iza madazaw nangotana siran nga daw iton ya tao nga nagalo-to ka pagpangazo izang dini kaini? ");
INSERT INTO mmn_vpl VALUES ("JN9_9","073_9_9","JHN","9","9","9","Kamhan minlaong ya isa nga ani gazed iton. Minlaong ya iba nga diri kay masingedsinged lamang ya kanirang bayho. Kamhan ya tao nga madazaw di minlaong iza nga hao matood. ");
INSERT INTO mmn_vpl VALUES ("JN9_10","073_9_10","JHN","9","10","10","Minsambag siran nga naono di sa nga nakakita di sa ya mata mo? ");
INSERT INTO mmn_vpl VALUES ("JN9_11","073_9_11","JHN","9","11","11","Minsambag iza nga ya tao nga inngaranan kan Hisos min-eleb iza ka lopa. Kamhan insampenan naiza ya kanaong mata ka imbasà nga lopa. Minsogo sab iza kanao nga komaro ko ka sapa nga Siloi. Maghiram-os ko doro. Kamhan mintoman hao ka toong sogo. Paghiram-os nao dizan nakakita di matood ya kanaong mata. ");
INSERT INTO mmn_vpl VALUES ("JN9_12","073_9_12","JHN","9","12","12","Kamhan nangotana siran daw hain sa iza koman? Minsambag ya tao nga wara hao mahagdam. ");
INSERT INTO mmn_vpl VALUES ("JN9_13","073_9_13","JHN","9","13","13","Pagkakamhan ka in-ated niran dizan ka mga Parasiyo ya tao nga indazaw ni Hisos. ");
INSERT INTO mmn_vpl VALUES ("JN9_14","073_9_14","JHN","9","14","14","Na, izang aldaw ka pagbasà ni Hisos ka lopa ka pagdazaw ka mata na tao ani tigpahimlay na mga Yodayo. ");
INSERT INTO mmn_vpl VALUES ("JN9_15","073_9_15","JHN","9","15","15","Agon nangotana ya mga Parasiyo pag-isab nga ono sa nga nakakita di sa ko? Minsambag iza nga insampenan naiza ya kanaong mata ka lopa nga imbasà ka eleb. Kamhan impahiram-os hao. Kamhan nakakita di ya kanaong mata. ");
INSERT INTO mmn_vpl VALUES ("JN9_16","073_9_16","JHN","9","16","16","Kamhan minlaong ya mga Parasiyo nga itong tao diri kon garing iza ka Diyos kay minlapas gazed iza ka balaed na Diyos kay indazaw naiza ya bota ka aldaw nga tigpahimlay. Kamhan ya pagtambal ka tao singed iton ka tarabaho. Minlaong ya ibang mga Parasiyo nga kon salaan iton nga tao onhon sa naiza paghinang ka madazaw singed kaiton? Kamhan namaglalis gazed siran. ");
INSERT INTO mmn_vpl VALUES ("JN9_17","073_9_17","JHN","9","17","17","Agon minbalik siran pagpangotana ka tao nga daw ono ya hena-hena mo mahitenged kaitong tao kay iko ya indazaw naiza? Minsambag iza nga propita gazed iza na Diyos. ");
INSERT INTO mmn_vpl VALUES ("JN9_18","073_9_18","JHN","9","18","18","Bisan ani ya toong sambag diri antoo ya mga Parasiyo nga iza ya bota nga nadazaw di. Agon impakarini niran ya ginikanan ");
INSERT INTO mmn_vpl VALUES ("JN9_19","073_9_19","JHN","9","19","19","kay mangotana siran daw iton ya maanak mazo nga nabota sokad ka pagkatao? Naono sa nga nakakita di sa iza? ");
INSERT INTO mmn_vpl VALUES ("JN9_20","073_9_20","JHN","9","20","20","Minsambag ya ginikanan nga ani matood ya kanaming maanak nga nabota sokad ka pagkatao naiza ");
INSERT INTO mmn_vpl VALUES ("JN9_21","073_9_21","JHN","9","21","21","piro wara gazed kami mahagdam kon onhon sa naiza pagkita koman. Wara gazed kami mahagdam kon sin-o ya nakadazaw ka toong mata. Bot-an di iza agon pangotanhen mazo iza kay iza gazed ya ampanan-og kamazo. ");
INSERT INTO mmn_vpl VALUES ("JN9_22","073_9_22","JHN","9","22","22","Ani ya pagsambag na toong ginikanan kay mahaldek siran ka mga Yodayo kay may daan sabot na Yodayo nga kon may tao nga ampanan-og nga si Hisos ani si Kristo nga hari nga pinili na Diyos bogawen gazed ya tao dini ka singbahan na mga Yodayo. ");
INSERT INTO mmn_vpl VALUES ("JN9_23","073_9_23","JHN","9","23","23","Agon minsambag ya ginikanan nga iza ya pangotanhen mazo kay bot-an di iza. ");
INSERT INTO mmn_vpl VALUES ("JN9_24","073_9_24","JHN","9","24","24","Kamhan impabalik pag-isab na mga Parasiyo ya tao nga madazaw di. Kamhan nagalaong siran nga sazaen mo ya Diyos kay iza ya nakadazaw kanmo. Diri kon si Hisos kay nahagdam sa kami nga maonga iza nga tao. ");
INSERT INTO mmn_vpl VALUES ("JN9_25","073_9_25","JHN","9","25","25","Minsambag iza nga wara hao mahagdam kon maonga iza basta kay nahagdam hao nga izang dini kaini nabota hao piro koman nakakita di hao. ");
INSERT INTO mmn_vpl VALUES ("JN9_26","073_9_26","JHN","9","26","26","Kamhan nangotana siran nga daw in-ono naiza ya mata mo pagtambal nga nakakita di sa? ");
INSERT INTO mmn_vpl VALUES ("JN9_27","073_9_27","JHN","9","27","27","Minsambag nga impanan-ogan di nao kamo piro diri kamo antoo. Kay ono sa nga baliken pen sa ya pagpanan-og nao kamazo? Daw naazak isab kamo pagpasakop kanangiza? ");
INSERT INTO mmn_vpl VALUES ("JN9_28","073_9_28","JHN","9","28","28","Kamhan nazehet siran pagsora nagalaong nga iza ya insakopan mo basta kan Moysis kami. ");
INSERT INTO mmn_vpl VALUES ("JN9_29","073_9_29","JHN","9","29","29","Kay mahagdam gazed kami nga ya Diyos ani ya minsogo kan Moysis piro ya tao nga inngaranan kan Hisos wara kami mahagdam kon taga diin iza! ");
INSERT INTO mmn_vpl VALUES ("JN9_30","073_9_30","JHN","9","30","30","Minsambag ya tao nga nabereng hao kamazo kay wara kamo mahagdam kon hain garing ya tao nga mindazaw ka kanaong mata. ");
INSERT INTO mmn_vpl VALUES ("JN9_31","073_9_31","JHN","9","31","31","Mahagdam kita nga diri antabang ya Diyos ka tao nga maonga ya batasan. Hinoa tabangan naiza ya tao nga mintahod kanangiza daw mintoman ka toong naazakan. ");
INSERT INTO mmn_vpl VALUES ("JN9_32","073_9_32","JHN","9","32","32","Sokad kawandini pen ka sinogdan pen na kalibotan keteb koman waray nabatian nga may makadazaw ka tao nga nabota daan ka pagkatao. ");
INSERT INTO mmn_vpl VALUES ("JN9_33","073_9_33","JHN","9","33","33","Kon diri kon garing ka Diyos ini nga tao diri gazed iza makadazaw kanao. Ani ini ya sambag na tao nga nadazaw di. ");
INSERT INTO mmn_vpl VALUES ("JN9_34","073_9_34","JHN","9","34","34","Minsambag siran nga inkatao ya pagkabota mo kay iko ya salaan kamhan iko baza ya antoldo baza kanami nga mga maistro. Kamhan imbogaw niran iza dini ka singbahan niran. ");
INSERT INTO mmn_vpl VALUES ("JN9_35","073_9_35","JHN","9","35","35","Pagpakabati ka ni Hisos minkaro dazon iza ka tao nga indazaw naiza kay ampangotana iza nga daw mintoo iko nga mindateng di ya tao nga minhon-a ka bisan sin-o nga mahon-ang tao? ");
INSERT INTO mmn_vpl VALUES ("JN9_36","073_9_36","JHN","9","36","36","Minsambag ya tao nga Sinyor, ipanan-og mo kanao kon sin-o iza dazaw antoo hao. ");
INSERT INTO mmn_vpl VALUES ("JN9_37","073_9_37","JHN","9","37","37","Minsambag si Hisos nga nakakita di ko kanangiza kay iza ya minpakiglaong kanmo koman. ");
INSERT INTO mmn_vpl VALUES ("JN9_38","073_9_38","JHN","9","38","38","Minsambag ya tao nga Ginoo, antoo hao kanmo. Kamhan minlohod iza ka pagtahod kan Hisos. ");
INSERT INTO mmn_vpl VALUES ("JN9_39","073_9_39","JHN","9","39","39","Kamhan minpamolinged si Hisos nga nagalaong nga timan-an mo gazed ini. Ya tood nao ka pagkarini ka kalibotan dazawen nao ya mata na mga nabota. Kamhan ya mga tao nga madazaw di koni ya mata, siran di hinoa ya mga bota. ");
INSERT INTO mmn_vpl VALUES ("JN9_40","073_9_40","JHN","9","40","40","Pagpakabati ka na mga Parasiyo ka mga panaba ni Hisos minlaong siran nga ipasabot mo kanami ya kahologan na pamolinged mo. Daw kami disab ya mga nabota? ");
INSERT INTO mmn_vpl VALUES ("JN9_41","073_9_41","JHN","9","41","41","Minsambag si Hisos nga ya tao nga waray kahagdamanan mahitenged ka Diyos waray sala naiza ka pag-away kanao. Basta kay makasasala kamo kay bisan naanad kamo koni ka pagsindo na Diyos min-away baza kamo kanao. ");
INSERT INTO mmn_vpl VALUES ("JN10_1","073_10_1","JHN","10","1","1","Kamhan minpamolinged iza kaniran mahitenged ka batasan na mag-aligrahay ka toong mga bohien. Minlaong iza nga simpan may alad nga inseldan ka mga bohien nga karniro. Na, ya matood nga nagaaligara min-azi iza dizan ka pirtahan na alad. Kamhan ya tao nga minpanik hinoa ka alad ani gazed ya kawatan daw tolisan. ");
INSERT INTO mmn_vpl VALUES ("JN10_2","073_10_2","JHN","10","2","2","Kamhan ya tao nga nagaazi dizan ka pirtahan iza matood ya nagaaligara ka mga karniro. ");
INSERT INTO mmn_vpl VALUES ("JN10_3","073_10_3","JHN","10","3","3","Kamhan abrihan na magbantazay ya pirtahan dazaw makaseled ya nagaaligara. Makilalhan dazon na mga karniro ya toong saba paghawag naiza ka kanirang tagsa tagsang ngaran. Kamhan mag-ona iza kaniran ngaro ka gawas. ");
INSERT INTO mmn_vpl VALUES ("JN10_4","073_10_4","JHN","10","4","4","Pagpalogwa ka naiza kanirang tanan iza ya anhon-a kaniran pagpanaw. Kamhan nanonod siran kay nakakilala sa siran ka toong nga hinawag. ");
INSERT INTO mmn_vpl VALUES ("JN10_5","073_10_5","JHN","10","5","5","Diri gazed siran ansonod ka laing tao kay mandalagan hinoa siran kay wara sa siran makakilala ka toong hinawag. ");
INSERT INTO mmn_vpl VALUES ("JN10_6","073_10_6","JHN","10","6","6","Ani ini ya pamolinged ni Hisos ka mga Yodayo kamhan wara siran makasabot kon ono ya kahologan. ");
INSERT INTO mmn_vpl VALUES ("JN10_7","073_10_7","JHN","10","7","7","Agon minpanaba si Hisos kaniran pag-isab nagalaong nga sabten mazo ini nga ya pirtahan ka pagpaazi ka mga karniro ani hao. ");
INSERT INTO mmn_vpl VALUES ("JN10_8","073_10_8","JHN","10","8","8","Kamhan ya mga kawatan daw tolisan ani ya mga mindateng paghon-a kanao daw mintoldo disab ka bakak piro diri antoo kaniran ya kanaong mga sakop. ");
INSERT INTO mmn_vpl VALUES ("JN10_9","073_10_9","JHN","10","9","9","Ya pirtahan na alad hao gazed. Bisan sin-o ya ankilala kanao diri pahamtangan iza na Diyos ka kamatazen ka toong mga sala. Insakto isab ya pag-aligara nao kanangiza. ");
INSERT INTO mmn_vpl VALUES ("JN10_10","073_10_10","JHN","10","10","10","Ya tood na mga kawatan gosto kawaten daw patazen daw daeten ya mga karniro. Kamhan ya tood nao hinoa anhatag hao kaniran ka bag-ong kinabohi nga diri mawara daw madazaw gazed. ");
INSERT INTO mmn_vpl VALUES ("JN10_11","073_10_11","JHN","10","11","11","Hao ya matood nga nagaaligara kaniran. Madazaw gazed ya kanaong pag-aligara kay andam hao ka pagpakapatay para kaniran. ");
INSERT INTO mmn_vpl VALUES ("JN10_12","073_10_12","JHN","10","12","12","Lain ya batasan na sinoholan kay diri kon tag-iza iza ka mga karniro. Agon pagkita naiza ka maiseg nga ido andalagan dazon iza pagbiza ka mga karniro. Kamhan insakmit dazon siran na ido daw impadalagan. ");
INSERT INTO mmn_vpl VALUES ("JN10_13","073_10_13","JHN","10","13","13","Ani gazed ya batasan na sinoholan kay sohol ka lamang ya toong hena-hena, diri an-aligara ka mga karniro. ");
INSERT INTO mmn_vpl VALUES ("JN10_14","073_10_14","JHN","10","14","14","Minlaong sab si Hisos nga hao ya matood nga nagaaligara. Ya pagkaangay nao daw ya kanaong mga sakop ");
INSERT INTO mmn_vpl VALUES ("JN10_15","073_10_15","JHN","10","15","15","singed iton ka pagkaangay nao daw ya kanaong Ama. Kamhan andam hao ka pagpakapatay para kaniran. ");
INSERT INTO mmn_vpl VALUES ("JN10_16","073_10_16","JHN","10","16","16","May mga iba pen nga tao nga ansakop pen kanao nga diri kon Yodayo siran. Kinahanglan patiponon nao siran isab. Kamhan antoo siran ka kanaong hinawag. Kamhan isa kang ka tipon sirang tanan. Isa ka gihapon ya matood nga mag-aligrahay kanirang tanan. ");
INSERT INTO mmn_vpl VALUES ("JN10_17","073_10_17","JHN","10","17","17","Kamhan hao ya naazakan na Ama kay andam hao ka pagpakapatay dazaw mabohi kasab hao pagbalik garing ka lebeng. ");
INSERT INTO mmn_vpl VALUES ("JN10_18","073_10_18","JHN","10","18","18","Waray tao nga may mahimo ka pagpatay kanao kay hao ya ambeet kon mapatay hao daw diri. May gahem nao ka pagtogot ka kanaong pagkapatay. May gahem sab nao ka pagbawi ka kanaong kinabohi. Intagan hao na Ama kaini nga gahem. Ani ini ya pagpanaba ni Hisos kaniran. ");
INSERT INTO mmn_vpl VALUES ("JN10_19","073_10_19","JHN","10","19","19","Pagpakabati na mga Yodayo ka mga panaba ni Hisos namag-inaway ya isa daw isa. ");
INSERT INTO mmn_vpl VALUES ("JN10_20","073_10_20","JHN","10","20","20","Mataed ya nagalaong nga inboang iza na maonga. Diri kamo magpanalinga kanangiza. ");
INSERT INTO mmn_vpl VALUES ("JN10_21","073_10_21","JHN","10","21","21","Minsambag ya mga iba nga ya tao nga inboang na maonga diri gazed iza makasindo singed kaiton. Kamhan waray mahimo na maonga ka pagdazaw ka mata na bota. ");
INSERT INTO mmn_vpl VALUES ("JN10_22","073_10_22","JHN","10","22","22","Na, iton nga panahon mindateng di ya pista na mga Yodayo dini ka Hirosalem. Na, iton nga pista ani pagtaremdem na mga Yodayo ka pagdazaw niran ka dakolang lagkaw nga pangamozoanan ka Diyos. ");
INSERT INTO mmn_vpl VALUES ("JN10_23","073_10_23","JHN","10","23","23","Panahon ka na amihan. Kamhan nagapanawpanaw si Hisos dizan ka inngaranan ka Diskanso ni Salomon nga dapit dizan ka dakolang lagkaw na Diyos. ");
INSERT INTO mmn_vpl VALUES ("JN10_24","073_10_24","JHN","10","24","24","Kamhan inlibotan iza na mga Yodayo kay dazaw legsen pagpangotana nga daw dogay pen ya pagpakilala mo kanami? Kon si Kristo iko nga hari nga pinili na Diyos kon diri? Magpanan-og ko kanami dazaw mahagdam kami. ");
INSERT INTO mmn_vpl VALUES ("JN10_25","073_10_25","JHN","10","25","25","Minsambag si Hisos nga impanan-ogan di kamo kamhan wara kamo magtoo. Intagan hao na Diyos ka gahem ka paghinang ka mga madazaw. Kamhan ya mga inhinang nao ani nagapamatood kamazo kon sin-o sa hao ");
INSERT INTO mmn_vpl VALUES ("JN10_26","073_10_26","JHN","10","26","26","ambaza kay diri kamo antoo kay diri kon kamo ya kanaong mga sakop. ");
INSERT INTO mmn_vpl VALUES ("JN10_27","073_10_27","JHN","10","27","27","Kon kamo ya kanaong mga sakop makilalhan gazed mazo ya kanaong mga panaba singed ka pagkilala na mga karniro ka tao nga nagaaligara kaniran. Mahagdam hao kon sin-o ya kanaong mga sakop. Kamhan hao kay insakopan niran. ");
INSERT INTO mmn_vpl VALUES ("JN10_28","073_10_28","JHN","10","28","28","Anhatag hao kaniran ka bag-ong kinabohi nga diri mawara. Kamhan diri gazed siran madara ngaro ka impirno. Waray makakawa kaniran garing ka kanaong paghawid. ");
INSERT INTO mmn_vpl VALUES ("JN10_29","073_10_29","JHN","10","29","29","Kay ya Ama nao nga minhatag kaniran kanao labaw gazed iza ka gahem. Kamhan waray makakawa ka kanaong sakop garing ka paghawid na Ama nao. ");
INSERT INTO mmn_vpl VALUES ("JN10_30","073_10_30","JHN","10","30","30","Ya Ama nao daw hao isa ka gazed. ");
INSERT INTO mmn_vpl VALUES ("JN10_31","073_10_31","JHN","10","31","31","Pagpakabati ka na mga Yodayo kaini nga mga panaba ni Hisos namorot siran pag-isab ka mga bato kay pookon kontana iza. ");
INSERT INTO mmn_vpl VALUES ("JN10_32","073_10_32","JHN","10","32","32","Kamhan nagalaong si Hisos kaniran nga impakita nao kamazo ya mataed nga madazaw nga hinang nga inpahinang ni Ama. Kay ono sa nga pookon mazo hao? Daw ono ya inhinang nao nga diri kamo maazak? ");
INSERT INTO mmn_vpl VALUES ("JN10_33","073_10_33","JHN","10","33","33","Minsambag siran nga diri nami pookon tenged ka bisan isang hinang nga madazaw basta ya pagpanaba mo ka maonga mahitenged ka Diyos. Tao ka lamang iko kamhan nagapahinanghinang iko nga Diyos. ");
INSERT INTO mmn_vpl VALUES ("JN10_34","073_10_34","JHN","10","34","34","Minsambag si Hisos nga dizan ka kamazong balaed may sinoyat nagalaong nga ya mga karaang oloolo na mga Yodayo siran ya mga ginoo ka mga tao. ");
INSERT INTO mmn_vpl VALUES ("JN10_35","073_10_35","JHN","10","35","35","Iton nga sinoyat diri mahimo balhinen kawanihen ka kay ani impasoyat na Diyos nga nagalaong nga ya mga karaang oloolo na mga Yodayo siran ya intagan ka sindo na Diyos. Kamhan siran ya inngaranan ka mga ginoo na mga tao. ");
INSERT INTO mmn_vpl VALUES ("JN10_36","073_10_36","JHN","10","36","36","Hao ya pinili daw inpakarimbaba na Diyos ka pagtoman ka toong naazakan dini ka kalibotan. Kay ono sa kamo minbaheg kanao nga nagalaong nga maonga ya kanaong panaba mahitenged ka Diyos kay minpanaba hao nga hao matood ya Maanak na Diyos? ");
INSERT INTO mmn_vpl VALUES ("JN10_37","073_10_37","JHN","10","37","37","Kon wara hao magtoman ka mga hinang nga naazakan na kanaong Ama diri kamo magtoo kanao. ");
INSERT INTO mmn_vpl VALUES ("JN10_38","073_10_38","JHN","10","38","38","Kon nagahinang hao ka toong mga tarabaho, bisan wara kamo magtoo ka kanaong mga panaba, toohi mazo nga ya mga hinang nao garing gazed ka Ama kamhan makasabot kamo nga kami ni Ama isa ka gazed kami. ");
INSERT INTO mmn_vpl VALUES ("JN10_39","073_10_39","JHN","10","39","39","Pagpakabati ka na mga Yodayo kaiza nga pinanaba ni Hisos dakpen kontana niran pag-isab piro min-azi iza dizan tenged kaniran. Kamhan nakalayas iza kaniran dini ka dakolang lagkaw nga pangamozoanan ka Diyos. ");
INSERT INTO mmn_vpl VALUES ("JN10_40","073_10_40","JHN","10","40","40","Kamhan minbalik iza pag-isab dipi ka sapa nga Hordan doro dapit kaizang imbenzagan ni Howan. Kamhan nabilin iza doro. ");
INSERT INTO mmn_vpl VALUES ("JN10_41","073_10_41","JHN","10","41","41","Kamhan mataed ya tao nga nangaro kanangiza. Namaglaong siran nga si Howan bisan wara iza maghinang ka timaan nga garing ka Diyos, matood gazed ya tanan mga panaba naiza kanami mahitenged kaini nga tao. ");
INSERT INTO mmn_vpl VALUES ("JN10_42","073_10_42","JHN","10","42","42","Kamhan dizan kaniran mataed ya mga mintoo kan Hisos. ");
INSERT INTO mmn_vpl VALUES ("JN11_1","073_11_1","JHN","11","1","1","Na, may isang tao nga nasakit ani ngaran si Lazaro nga taga Bitani. Taga dini disab si Mariya daw ya toong lomon nga si Marta. ");
INSERT INTO mmn_vpl VALUES ("JN11_2","073_11_2","JHN","11","2","2","Na, si Mariya ani ya ambo-bo kay-an ka paahan ni Hisos ka mahamot daw tarapohan ka toong bohok. Maglomon iza daw si Lazaro nga nabedlay. ");
INSERT INTO mmn_vpl VALUES ("JN11_3","073_11_3","JHN","11","3","3","Kamhan insogo ni Mariya daw si Marta ya isa ngaro kan Hisos dazaw ipakahagdam nga nagalaong nga Ginoo, iza nga kinaazak mo nabedlay iza. ");
INSERT INTO mmn_vpl VALUES ("JN11_4","073_11_4","JHN","11","4","4","Pagpakabati ni Hisos minlaong iza nga ya tood na sakit ni Lazaro diri kon ikapatay. Hinoa pabet-an na Diyos dazaw ipakita naiza ya hinang nga madazaw gazed. Kay pasabten naiza ya mga tao nga Hao ya Maanak na Diyos. ");
INSERT INTO mmn_vpl VALUES ("JN11_5","073_11_5","JHN","11","5","5","Na, maghigara gazed si Hisos daw si Marta daw si Mariya daw si Lazaro. ");
INSERT INTO mmn_vpl VALUES ("JN11_6","073_11_6","JHN","11","6","6","Pagpakabati ni Hisos nga nasakit si Lazaro bisan dakola ya kalooy naiza kaniran nagatagad iza ka dowa pen ka aldaw dipi ka sapa. ");
INSERT INTO mmn_vpl VALUES ("JN11_7","073_11_7","JHN","11","7","7","Pagdateng di na dowang ka aldaw minlaong si Hisos ka toong mga sakop nga mamanaw di kita kamazo pagbalik ngaro ka lopa nga Yoda. ");
INSERT INTO mmn_vpl VALUES ("JN11_8","073_11_8","JHN","11","8","8","Minsambag siran nga Maistro, daw ambalik pen ko ngaro? Pamokoon di ko kontana na mga Yodayo. ");
INSERT INTO mmn_vpl VALUES ("JN11_9","073_11_9","JHN","11","9","9","Kamhan waray kawied naiza nga patazen iza kay mahagdam iza nga wara pen dateng ya tirmino. Agon minpamolinged iza kaniran nagalaong nga ka isang aldaw napolo may dowang ka oras ya kapawa. Kon aldaw ya kantang pagpanaw waray makasapdok kanta kay mapawa ya kalibotan. ");
INSERT INTO mmn_vpl VALUES ("JN11_10","073_11_10","JHN","11","10","10","Kon ampanaw ya tao ka kahabzen masapdok iza kay diri iza makakita kon ankar-in sa iza kay madeglem di. Ani ini ya pagpanaba ni Hisos kaniran. ");
INSERT INTO mmn_vpl VALUES ("JN11_11","073_11_11","JHN","11","11","11","Kamhan mindogang iza pagpanaba nga ya kantang higara nga si Lazaro natorog di iza. Karohon di nao kay pokawen nao iza. ");
INSERT INTO mmn_vpl VALUES ("JN11_12","073_11_12","JHN","11","12","12","Minsambag siran nga Ginoo, kon iza ka iza natorog lamang madazaw iza ka toong masakit. ");
INSERT INTO mmn_vpl VALUES ("JN11_13","073_11_13","JHN","11","13","13","Ya pamolinged ni Hisos mahitenged ka pagkapatay ni Lazaro silaong na mga sakop nga natorog ka iza. ");
INSERT INTO mmn_vpl VALUES ("JN11_14","073_11_14","JHN","11","14","14","Kamhan impasabot ni Hisos kaniran nagalaong nga napatay matood si Lazaro. ");
INSERT INTO mmn_vpl VALUES ("JN11_15","073_11_15","JHN","11","15","15","Kamhan tenged kamazo madazaw kay izang dini kaini wara hao doro ka pagkapatay ni Lazaro. Kay padakolaen kay-an ya kamazong pagsarig kanao pagpakakita mazo ka kanaong hinang. Mamanaw di kita kamazo ngaro. ");
INSERT INTO mmn_vpl VALUES ("JN11_16","073_11_16","JHN","11","16","16","Kamhan si Tomas nga isang sakop nga indagnazan kan Kaloha minlaong iza ka toong kaibahan nga mag-iba di kita kan Hisos ngaro ka lopa nga Yoda dazaw mahilakip kita kan Hisos pagpatay kanangiza na mga Yodayo. ");
INSERT INTO mmn_vpl VALUES ("JN11_17","073_11_17","JHN","11","17","17","Pagdateng ni Hisos ka longsod nga Bitani mahagdam iza nga si Lazaro opat ding ka aldaw dizan iza ka lebnganan. ");
INSERT INTO mmn_vpl VALUES ("JN11_18","073_11_18","JHN","11","18","18","Kamhan ya Bitani nakatenged iton ka siyodad nga Hirosalem hapit magtolong ka kilomitro ya kaaro. ");
INSERT INTO mmn_vpl VALUES ("JN11_19","073_11_19","JHN","11","19","19","Kamhan mataed ya mga Yodayo minkarini kanin Marta nga napatzan kay ampakig-angay ka kalised niran. ");
INSERT INTO mmn_vpl VALUES ("JN11_20","073_11_20","JHN","11","20","20","Ka wara pen dateng si Hisos ka longsod nabatian ni Marta nga dizan di si Hisos. Kamhan minpanaw iza ka pagsogat kanangiza. Dizan pen ka lagkaw nagatagad si Mariya. ");
INSERT INTO mmn_vpl VALUES ("JN11_21","073_11_21","JHN","11","21","21","Kamhan si Marta nagalaong kan Hisos nga Ginoo, izang dini kaini diri gazed mamola ya kanaong lomon kon dini ka ko. ");
INSERT INTO mmn_vpl VALUES ("JN11_22","073_11_22","JHN","11","22","22","Hinoa mahagdam hao nga bisan koman anhatag ya Diyos kanmo ka bisan ono ya kanmong pangazoon. ");
INSERT INTO mmn_vpl VALUES ("JN11_23","073_11_23","JHN","11","23","23","Minsambag si Hisos nga Day, ya kanmong lomon mabohi gazed iza pagbalik garing ka lebeng. ");
INSERT INTO mmn_vpl VALUES ("JN11_24","073_11_24","JHN","11","24","24","Minsambag si Marta nga mahagdam hao nga mabohi iza pagbalik kay-an ka kataposan nga aldaw nga tirmino nga pagapanbohien di na Diyos ya mga napatay. ");
INSERT INTO mmn_vpl VALUES ("JN11_25","073_11_25","JHN","11","25","25","Minsambag si Hisos nga hao ya ambohi ka mga napatay garing ka lebeng. Hao ya anhatag kaniran ka kinabohi nga diri mawara. Kamhan ya tao nga mintoo kanao mabohi gazed iza pagbalik bisan min-azi iza ka pagkapatay. ");
INSERT INTO mmn_vpl VALUES ("JN11_26","073_11_26","JHN","11","26","26","Kamhan diri gazed iza madara ngaro ka impirno kay intagan iza ka bag-ong kinabohi nga diri mawara kay mintoo iza kanao. Daw mintoo iko kaini? ");
INSERT INTO mmn_vpl VALUES ("JN11_27","073_11_27","JHN","11","27","27","Minsambag si Marta nga Ginoo, matood iton. Mintoo hao daan nga iko gazed si Kristo nga Maanak na Diyos nga kanaming intagadan. ");
INSERT INTO mmn_vpl VALUES ("JN11_28","073_11_28","JHN","11","28","28","Pagkakamhan ni Marta pagpanaba min-oli iza kay anhawag ka toong lomon nga si Mariya. Kamhan minpahenek iza ka toong saba nagalaong nga Mariya, waton di doro ya Maistro. Pakarohon ko naiza. ");
INSERT INTO mmn_vpl VALUES ("JN11_29","073_11_29","JHN","11","29","29","Pagpakabati ka ni Mariya kaiza mindali iza pagtindeg kay an-apas iza ngaro kan Hisos. ");
INSERT INTO mmn_vpl VALUES ("JN11_30","073_11_30","JHN","11","30","30","Kay si Hisos wara pen iza dateng ka longsod. Doro pen iza ka dapit nga inkarohan ni Marta gawas ka longsod. ");
INSERT INTO mmn_vpl VALUES ("JN11_31","073_11_31","JHN","11","31","31","Ya mga Yodayo nga nagapakig-angay ka hinawa na napatzan pagpakakita ka niran nga mindali si Mariya pagtindeg daw paglogwa ka lagkaw minlopog siran kay silaong niran nga angkaro iza ka inlebngan dazaw anhaza iza doro. ");
INSERT INTO mmn_vpl VALUES ("JN11_32","073_11_32","JHN","11","32","32","Pagdateng ni Mariya dizan kan Hisos minlohod iza dizan ka toong paahan. Kamhan magalaong iza nga Ginoo, diri gazed mapatay ya kanaong lomon kon dini ka ko. ");
INSERT INTO mmn_vpl VALUES ("JN11_33","073_11_33","JHN","11","33","33","Pagpakakita ka ni Hisos ka pagpanhaza ni Mariya daw ya mga Yodayo nga toong kaibahan mabeg-at ya hinawa ni Hisos. Mindakola disab iza paghinawa tenged ka kalooy naiza kaniran. ");
INSERT INTO mmn_vpl VALUES ("JN11_34","073_11_34","JHN","11","34","34","Kamhan nangotana iza daw hain mazo ilebeng iza? Minsambag siran nga Ginoo, ibahan mo kami doro ka lebnganan dazaw selengan mo. ");
INSERT INTO mmn_vpl VALUES ("JN11_35","073_11_35","JHN","11","35","35","Kamhan si Hisos minhaza iza. ");
INSERT INTO mmn_vpl VALUES ("JN11_36","073_11_36","JHN","11","36","36","Namaglaonglaong ya mga Yodayo nga selengi mazo, dakola gazed ya toong pagkaazak kan Lazaro. ");
INSERT INTO mmn_vpl VALUES ("JN11_37","073_11_37","JHN","11","37","37","Namaglaong sab ya mga isa nga iza ya mindazaw ka mata na bota. Kamhan ono sa nga wara sa magtabang kan Lazaro dazaw diri mapatay. ");
INSERT INTO mmn_vpl VALUES ("JN11_38","073_11_38","JHN","11","38","38","Pagdateng ni Hisos ka hininang nga talangban nga lebnganan mabeg-at isab ya toong hinawa ka kalooy. Na, dizan ka pirtahan na lebnganan may insira nga bato. ");
INSERT INTO mmn_vpl VALUES ("JN11_39","073_11_39","JHN","11","39","39","Kamhan minsogo si Hisos kaniran nga kaw-a mazo ya bato! Si Marta nga napatzan nagalaong nga Ginoo, mabaho di iza koman kay opat ding ka aldaw ya paglebeng. ");
INSERT INTO mmn_vpl VALUES ("JN11_40","073_11_40","JHN","11","40","40","Minsambag si Hisos nga izang dini kaini daw wara sa hao maglaong kanmo nga kon tomoo ko kanao makitan mo ya hinang nga ampasaza ka Diyos. ");
INSERT INTO mmn_vpl VALUES ("JN11_41","073_11_41","JHN","11","41","41","Kamhan inkawa niran ya bato nga insira ka lebeng. Kamhan minhangad si Hisos daw minlaong nga Ama, palad pen kay kon anhangzo hao kanmo manalinga ko kanao. ");
INSERT INTO mmn_vpl VALUES ("JN11_42","073_11_42","JHN","11","42","42","Mahagdam hao nga onay ko ampanalinga kanao. Minpanaba hao kanmo koman kay dazaw ya mga kataohan nga nagatindeg dini antoo siran nga iko matood ya minpakarimbaba kanao. ");
INSERT INTO mmn_vpl VALUES ("JN11_43","073_11_43","JHN","11","43","43","Pagkakamhan naiza pagpanaba kaini minbaskeg iza ka toong paghawag nga Lazaro, lomogwa ko dizan kaiton! ");
INSERT INTO mmn_vpl VALUES ("JN11_44","073_11_44","JHN","11","44","44","Pagkakamhan naiza paghawag minlogwa matood ya namola dizan ka lebeng. Binegketan pen iza ka panapton nakalakip ya toong alima daw paa. Impotos sab ya bayho ka panyo. Batasan iton na mga Yodayo kon magalebeng. Kamhan minsogo si Hisos kaniran nga kaw-an mazo ya panapton daw potos dazaw makapanaw. ");
INSERT INTO mmn_vpl VALUES ("JN11_45","073_11_45","JHN","11","45","45","Kamhan ya mga mataed nga Yodayo nga min-iba kan Mariya mintoo gazed siran kan Hisos kay nakakita siran ka pagpabohi naiza kan Lazaro pagbalik garing ka lebeng. ");
INSERT INTO mmn_vpl VALUES ("JN11_46","073_11_46","JHN","11","46","46","Kamhan may mga isa nga min-oli di siran kay ampakahagdam ka mga Parasiyo kaiton nga inhinang ni Hisos. ");
INSERT INTO mmn_vpl VALUES ("JN11_47","073_11_47","JHN","11","47","47","Kamhan ya mga oloolo na mga pari daw ya mga Parasiyo impantipon niran ya mga malaas nga Yodayo. Pagtipon nirang tanan namagsabot siran nga ono sa ya hinangen ta kaiton nga tao kay mataed ya inhinang naiza nga makahatag ka kabereng ka tao. ");
INSERT INTO mmn_vpl VALUES ("JN11_48","073_11_48","JHN","11","48","48","Kon pasagdan ta basi anpasakop kanangiza ya tanan mga tao. Kamhan sorongon kita na mga taga Roma daw geb-en ya dakolang lagkaw nga pangamozoanan ka Diyos. Pamatazen gazed kitang tanan nga Yodayo. ");
INSERT INTO mmn_vpl VALUES ("JN11_49","073_11_49","JHN","11","49","49","Kamhan may isang oloolo nga labaw nga pari kaiton nga panahon si Kayapas ya ngaran. Nagabiaybiay iza kaniran nagalaong nga kolang pen gazed ya pagsabot mazo. ");
INSERT INTO mmn_vpl VALUES ("JN11_50","073_11_50","JHN","11","50","50","Sabten mazo gazed ini nga madazaw kon patazen na mga taga Roma itong tao dazaw diri matibe ya tanan mga Yodayo pagkapildi. ");
INSERT INTO mmn_vpl VALUES ("JN11_51","073_11_51","JHN","11","51","51","Na, ya ingkapanaba ni Kayapas diri kon toong kinaogaringen nga paghena-hena. Pinili iza nga labaw nga pari kaiton nga panahon. Kamhan impatandeg na Diyos ya toong hinawa ka pagpanaba ka matood nagalaong nga si Hisos kinahanglan mapatay iza para ka tanan mga Yodayo ");
INSERT INTO mmn_vpl VALUES ("JN11_52","073_11_52","JHN","11","52","52","lakip isab ya mga tao nga diri kon Yodayo nga nangabelagbelag doro ka mga lain dapit dazaw maisa ka siran pagsakop ka Diyos. ");
INSERT INTO mmn_vpl VALUES ("JN11_53","073_11_53","JHN","11","53","53","Kamhan sokad ka pagtipon na mga oloolo na mga Yodayo nagapadazon siran pagsabotsabot kon onhon niran pagpatay kan Hisos. ");
INSERT INTO mmn_vpl VALUES ("JN11_54","073_11_54","JHN","11","54","54","Kamhan dini ka lopa nga hel-anan na mga Yodayo diri di si Hisos magapanawpanaw. Minpanaw iza hinoa hangtod nakadateng ka mamingaw. Kamhan mindateng iza ka longsod nga Iprim. Nabilin iza doro iba ya toong mga sakop. ");
INSERT INTO mmn_vpl VALUES ("JN11_55","073_11_55","JHN","11","55","55","Pagkadogay kaiza hapit di andateng ya isang pista na mga Yodayo. Na, iton nga pista ani taremdemen na mga Yodayo ka paglibri na Diyos ka kanirang mga karaan ka pagkaoripen pen niran doro ka lopa nga Ihipto. Kamhan ya batasan niran ka pagtaremdem ka pista mangihaw siran ka mga nati na karniro. Mataed ya ankaro ka siyodad nga Hirosalem nga pistahanan. Garing siran ka bisan hain nga longsod. Minsazo siran pagkaro kay ya batasan niran amparigo siran anipen siran makapamista. ");
INSERT INTO mmn_vpl VALUES ("JN11_56","073_11_56","JHN","11","56","56","Kamhan dizan ka dakolang lagkaw nga pangamozoanan ka Diyos nangita ya mga tao kan Hisos piro wara sa iza dizan. Kamhan nangotana ya isa daw isa daw ono ya kamazong hena-hena? Daw antambong si Hisos ka pista kon diri? ");
INSERT INTO mmn_vpl VALUES ("JN11_57","073_11_57","JHN","11","57","57","Insogo sab na mga oloolo na mga pari daw ya mga Parasiyo nagalaong nga kon may mahagdam ka hinel-an ni Hisos ipakahagdam dazon kay dazaw pamagdakpen iza pagdali. ");
INSERT INTO mmn_vpl VALUES ("JN12_1","073_12_1","JHN","12","1","1","Na, enem nga ka aldaw ka wara pen dateng ya pista na mga Yodayo nga mangihaw siran ka mga nati na karniro minbalik si Hisos ka longsod nga Bitani nga hel-anan ni Lazaro nga inbohi naiza pagbalik garing ka lebeng. ");
INSERT INTO mmn_vpl VALUES ("JN12_2","073_12_2","JHN","12","2","2","Pagkadelem kaiza nagapakaen siran kan Hisos. Si Marta ya nagaaligara ka makaen. Si Lazaro dizan iza ka mga mintambong ka pagkaen iba kan Hisos. ");
INSERT INTO mmn_vpl VALUES ("JN12_3","073_12_3","JHN","12","3","3","Kamhan si Mariya minkawa iza ka tenga na kilo na klasi na lana nga masarang kahamot ani ngaran ya nardo. Waray insaket bisan ono kamhan mahal gazed kon paliten. Kamhan imbo-bo ni Mariya ka paa ni Hisos. Kamhan intrapohan ni Mariya ka toong bohok. Insenep gazed ya lagkaw ka kahamot naiton nga lana. ");
INSERT INTO mmn_vpl VALUES ("JN12_4","073_12_4","JHN","12","4","4","Pagkakamhan si Hodas nga taga Kariyoti nga isang sinarigan nga mag-edlaway kan Hisos minbaheg iza kan Mariya nagalaong ");
INSERT INTO mmn_vpl VALUES ("JN12_5","073_12_5","JHN","12","5","5","kay ono sa inhanogon sa mo ya lana nga mahamot? Kontana ipakowarta iton kay sobra ka sohol ka napolo nga ka bolan kon paliten. Kamhan ya halin ipanhatag ka mga pobri. ");
INSERT INTO mmn_vpl VALUES ("JN12_6","073_12_6","JHN","12","6","6","Ani ini ya baheg ni Hodas kan Mariya. Kamhan diri kon kanang kalooy ka mga pobri kay kawatan gazed si Hodas. Dini ka mga sinarigan ni Hisos iza ya maghipesay ka kowarta piro onay iza mangawat kaiton. ");
INSERT INTO mmn_vpl VALUES ("JN12_7","073_12_7","JHN","12","7","7","Minsambag si Hisos kan Hodas nga pabet-i si Mariya kay ya halin na lana nga mahamot gamiten pen naiza iton kay-an ka pag-andam ka kanaong lawas ka paglebeng. ");
INSERT INTO mmn_vpl VALUES ("JN12_8","073_12_8","JHN","12","8","8","Ya mga pobri onay siran magaibaiba kamazo. Basta hao diri di madogay dini kamazo kay ampanaw hao dini. Ani ini ya sambag ni Hisos kan Hodas. ");
INSERT INTO mmn_vpl VALUES ("JN12_9","073_12_9","JHN","12","9","9","Na, masara gazed nga kataed ya mga Yodayo nakabati nga mindateng di si Hisos ka Bitani. Kamhan min-apas sirang tanan kay gosto anseleng kanangiza daw si Lazaro nga inbohi naiza pagbalik garing ka lebeng. ");
INSERT INTO mmn_vpl VALUES ("JN12_10","073_12_10","JHN","12","10","10","Agon ya mga oloolo na mga Yodayo namagsabot siran nga patazen si Lazaro isab ");
INSERT INTO mmn_vpl VALUES ("JN12_11","073_12_11","JHN","12","11","11","kay tenged kanangiza mataed ya mga Yodayo nga namiza ka kanirang oloolo dazaw ansakop kan Hisos. ");
INSERT INTO mmn_vpl VALUES ("JN12_12","073_12_12","JHN","12","12","12","Pagsonod nga ka aldaw masara gazed nga kataed ya mga mamistahay nga mintambong dini ka siyodad nga Hirosalem. Pagpakabati niran nga hapit di andateng si Hisos ka Hirosalem ");
INSERT INTO mmn_vpl VALUES ("JN12_13","073_12_13","JHN","12","13","13","nangotod siran ka mga paka na palmira nga klasi na nizog. Kamhan ipangamay niran kan Hisos ka pagtahod kay ani say batasan niran kon magasogat siran ka hari nga andateng kaniran. Pagsogat niran kan Hisos naninggit siran nga sazaen, sazaen kay iko ya hari nga impakarini na Ginoo. Intagan naiza iko ka dakola nga gahem. Sazaen kay iko matood ya hari nga pinili na Diyos ka mga kaliwatan ni Israil. Ani ini ya pagsaza na mga tao kan Hisos pagdateng naiza ka Hirosalem. ");
INSERT INTO mmn_vpl VALUES ("JN12_14","073_12_14","JHN","12","14","14","Kamhan ya pagkabayo ni Hisos ka isang batan-en pen nga asno nga klasi na kabayo ani nakatoman ka insoyat na karaang propita nga nagalaong nga ");
INSERT INTO mmn_vpl VALUES ("JN12_15","073_12_15","JHN","12","15","15","kamo nga mga taga Siyon, diri kamo magkahaldek. Selengi mazo kay waton di ngarini ya kamazong hari nga nagakabayo ka batan-en pen nga asno. Diri kon maiseg iza paghari naiza ka mga tao. Ani ini ya panan-og na karaang propita na Diyos. ");
INSERT INTO mmn_vpl VALUES ("JN12_16","073_12_16","JHN","12","16","16","Kamhan ya pagdateng ni Hisos dizan ka Hirosalem wara pen makasabot ya toong mga sakop kon ono ya kahologan. Kay-an ka pag-oli naiza ngandaked anipen siran nakataremdem nga ya pagdateng naiza nakatoman matood ka daan pinasoyat na Diyos mahitenged kanangiza. ");
INSERT INTO mmn_vpl VALUES ("JN12_17","073_12_17","JHN","12","17","17","Kamhan ya mga mataed nga tao nga min-iba kan Hisos izang dini kaini ka paghawag naiza kan Lazaro ka paglogwa garing ka lebnganan, siran ya minpanan-og kaiton dizan ka mga tao. ");
INSERT INTO mmn_vpl VALUES ("JN12_18","073_12_18","JHN","12","18","18","Kamhan sirang tanan nanogat kan Hisos kay nakabati siran nga inhinang naiza ya timaan nga garing ka Diyos. ");
INSERT INTO mmn_vpl VALUES ("JN12_19","073_12_19","JHN","12","19","19","Kamhan nagalaong ya mga Parasiyo nga selengi mazo. Pildi gazed kita kay insakopan iza na masarang kataed nga tao. ");
INSERT INTO mmn_vpl VALUES ("JN12_20","073_12_20","JHN","12","20","20","Kamhan may mga tao nga Ginirika ya saba nga namista isab siran kay ansingba siran ka Diyos dizan ka Hirosalem. ");
INSERT INTO mmn_vpl VALUES ("JN12_21","073_12_21","JHN","12","21","21","Kamhan siran isab ya ampakilala kontana kan Hisos agon minkarini siran ka isang sinarigan nga si Pilipo nga taga Bitsayda nga longsod doro ka Galiliya. Kamhan minlaong siran nga Nong, kon mahimo ampakigkita kami kan Hisos. ");
INSERT INTO mmn_vpl VALUES ("JN12_22","073_12_22","JHN","12","22","22","Agon inkaro ni Pilipo si Andris kay panan-ogan sa. Kamhan sirang dowa minkaro kan Hisos kay ipanan-og nga ampakigkita kanmo ya mga taga Girika. ");
INSERT INTO mmn_vpl VALUES ("JN12_23","073_12_23","JHN","12","23","23","Minsambag si Hisos nga mindateng di ya tirmino nga patazen di hao nga minhon-a ka bisan sin-o nga mahon-ang tao. ");
INSERT INTO mmn_vpl VALUES ("JN12_24","073_12_24","JHN","12","24","24","Timan-an mazo gazed ini nga ya isang bolos nga binhi nga homay kon diri itanem daw diri mapatay dalem ka lopa isa ka gazed iton nga binhi. Piro kon itanem mapatay daw tomobo. Kamhan mataed ya ohay. ");
INSERT INTO mmn_vpl VALUES ("JN12_25","073_12_25","JHN","12","25","25","Bisan sin-o ya diri ansakop kanao kay nawied iza nga basi patazen iza, diri gazed mahatagan iza ka bag-ong kinabohi nga diri mawara. Kamhan ya tao nga waray kawied kon patazen iza na mga tao kay hao ya insakopan naiza iza gazed mahatagan ka bag-ong kinabohi nga diri mawara. ");
INSERT INTO mmn_vpl VALUES ("JN12_26","073_12_26","JHN","12","26","26","Ya tao nga ampaalagad kanao kinahanglan antoman iza ka kanaong naazakan. Kamhan ya kanaong inkarohan daw toong karohanan mag-anika. Bisan sin-o ya antoman ka kanaong naazakan sazaen iza na kanaong Ama. ");
INSERT INTO mmn_vpl VALUES ("JN12_27","073_12_27","JHN","12","27","27","Indogang pen ni Hisos paglaong ka toong mga sinarigan nga mindateng di ya tirmino nga patazen di hao agon mabeg-at gazed ya kanaong hinawa. Daw anhangzo hao ka kanaong Ama dazaw diri ipapatay? Diri sa kay ya tood nao ka pagdateng ngarini koman angeten nao ya kalised. ");
INSERT INTO mmn_vpl VALUES ("JN12_28","073_12_28","JHN","12","28","28","Kamhan minpanaba isab si Hisos ka toong Ama daked nagalaong nga Ama, ipasabot mo kaini nga mga tao nga iko ya labaw ka gahem. Kamhan may saba nga minsambag garing daked ka langit nagalaong nga izang dini kaini impakita di nao ya kanaong gahem dizan ka mga inhinang mo. Impakita pen sab nao ya kanaong gahem dizan ka kanmong hinang. Ani ini ya sambag garing daked. ");
INSERT INTO mmn_vpl VALUES ("JN12_29","073_12_29","JHN","12","29","29","Kamhan ya mga tao nga nagatindeg dizan nakabati di siran ka tanog na saba. Kamhan minlaong siran nga mindag-ok di sa! Minlaong sab ya mga iba nga impanabaan gazed si Hisos na sinogo na Diyos nga taga langit! ");
INSERT INTO mmn_vpl VALUES ("JN12_30","073_12_30","JHN","12","30","30","Kamhan minsambag si Hisos kaniran nga ya saba nga nabatian mazo para kamazo itong panaba diri kon para kanao. ");
INSERT INTO mmn_vpl VALUES ("JN12_31","073_12_31","JHN","12","31","31","Ya tirmino ka pagpanhokom na Diyos ka mga tao mindateng di gazed. Bogawen sab si Satanas nga magahari ka mga taga kalibotan. Iitsa gazed iza ngaro ka kadeglem. ");
INSERT INTO mmn_vpl VALUES ("JN12_32","073_12_32","JHN","12","32","32","Pagkakamhan niran paglansang kanao ka kros mabohi hao pagbalik garing ka lebeng. Kamhan kabigen nao ya tanan mga tao ngarini kanao. ");
INSERT INTO mmn_vpl VALUES ("JN12_33","073_12_33","JHN","12","33","33","Ani ini ya inlaong ni Hisos kay ipasabot kaniran ya kaazi na toong kamatazen. ");
INSERT INTO mmn_vpl VALUES ("JN12_34","073_12_34","JHN","12","34","34","Kamhan minsambag ya mga tao nga dizan ka kanaming balaed nabatian nami nga diri mapatay si Kristo nga hari nga pinili na Diyos. Agon kay ono say pagalaong mo nga kinahanglan ilansang ya isang tao nga inngaranan ka minhon-a ka bisan sin-o nga mahon-ang tao? Daw sin-o sa baza ya tao nga inngaranan ka minhon-a ka bisan sin-o nga mahon-ang tao? ");
INSERT INTO mmn_vpl VALUES ("JN12_35","073_12_35","JHN","12","35","35","Minsambag si Hisos mahitenged ka toong kaogaringen nagalaong nga hao ya tag-iza ka kapawa. Kamhan makawara hao ka kadeglem dalem ka hena-hena na mga tao. Ka diri kon madogay ampanaw hao dini ka kalibotan. Agon ka dini pen hao kamazo komarini kamo kanao kay basi madaeg kamo ka tag-iza ka kadeglem. Kay ya tao nga magapanaw ka kadeglem wara iza mahagdam kon ankar-in sa iza pasinged. ");
INSERT INTO mmn_vpl VALUES ("JN12_36","073_12_36","JHN","12","36","36","Ka dini pen hao kamazo magtoo kamo kanao nga tag-iza ka kapawa. Kamhan makaangay kamo ka kapawa. Pagkakamhan ni Hisos paglaong kaiza minbelag iza kaniran. Diri siran mahagdam kon ankar-in sa iza. ");
INSERT INTO mmn_vpl VALUES ("JN12_37","073_12_37","JHN","12","37","37","Bisan inhinang naiza ya mga mataed nga timaan garing ka Diyos diri antoo ya mga Yodayo kanangiza. ");
INSERT INTO mmn_vpl VALUES ("JN12_38","073_12_38","JHN","12","38","38","Agon mintoman ya panan-og ni Isayas nga karaang propita na Diyos kay kawandini pen minlaong iza nga wani ya inlaong na Diyos mahitenged kan Kristo nga Ginoo, waray antoo ka kanaming panan-og mahitenged kan Kristo bisan impakita na Ginoo ya mga mataed nga timaan dizan kanangiza. Ani ini ya daan inlaong ni Isayas. ");
INSERT INTO mmn_vpl VALUES ("JN12_39","073_12_39","JHN","12","39","39","May iba pen nga sinoyat ni Isayas nagalaong nga diri mahimo ya pagtoo na mga Yodayo kan Hisos kay ");
INSERT INTO mmn_vpl VALUES ("JN12_40","073_12_40","JHN","12","40","40","singed ka impakabota na Diyos ya kanirang mata. Impagahi isab naiza ya kanirang otok dazaw diri siran makasabot kay diri siran gosto nga ambiza ka kanirang mga sala. Agon diri siran tagan na Diyos ka magazong hena-hena. ");
INSERT INTO mmn_vpl VALUES ("JN12_41","073_12_41","JHN","12","41","41","Ani ini ya inlaong ni Isayas kay kawandini pen minkita gazed iza ka pagkaGinoo ni Hiso Kristo nga Maanak na Diyos. Kamhan minpanan-og si Isayas daan mahitenged ka pagdateng ni Hisos ngarini ka kalibotan. ");
INSERT INTO mmn_vpl VALUES ("JN12_42","073_12_42","JHN","12","42","42","Kamhan dizan ka mga oloolo na mga Yodayo mataed ya mga mintoo kan Hisos. Kamhan mahaldek siran ka pagpanan-og ka kanirang pagtoo kay basi pamogawen siran na mga Parasiyo dizan ka singbahan na mga Yodayo. ");
INSERT INTO mmn_vpl VALUES ("JN12_43","073_12_43","JHN","12","43","43","Ani ini ya kanirang batasan kay impalabi niran ya pagsaza na mga tao kaniran ka pagsaza na Diyos. ");
INSERT INTO mmn_vpl VALUES ("JN12_44","073_12_44","JHN","12","44","44","Kamhan si Hisos minbaskeg iza ka toong saba nagalaong nga ya tao nga mintoo kanao diri kon hao ka lamang ya intoohan naiza basta antoo isab iza ka Diyos nga minpakarimbaba kanao. ");
INSERT INTO mmn_vpl VALUES ("JN12_45","073_12_45","JHN","12","45","45","Ya tao nga nakakita kanao nakakita isab iza ka Diyos nga minpakarimbaba kanao. ");
INSERT INTO mmn_vpl VALUES ("JN12_46","073_12_46","JHN","12","46","46","Hao nga tag-iza ka kapawa mindateng hao dini ka kalibotan dazaw bisan sin-o ya antoo kanao kaw-en nao ya kadeglem dalem ka toong hena-hena. ");
INSERT INTO mmn_vpl VALUES ("JN12_47","073_12_47","JHN","12","47","47","Bisan sin-o ya ampanalinga ka kanaong pagsindo kamhan diri iza antoman, diri kon hao ya anhokom kanangiza kay diri kon ani ya kanaong tozo. Hinoa minkarini hao dazaw antabang hao ka mga tao dazaw diri siran pahamtangan na Diyos ka silot ka kanirang mga sala. ");
INSERT INTO mmn_vpl VALUES ("JN12_48","073_12_48","JHN","12","48","48","Kay-an ka kataposan nga aldaw may maghohokom ka tao nga diri ansakop kanao daw diri antoman ka kanaong pagsindo. Ya kanaong sindo nga indirian na tao ani gazed ya maghohokom kaiton nga tao kay-an ka kataposan nga aldaw. ");
INSERT INTO mmn_vpl VALUES ("JN12_49","073_12_49","JHN","12","49","49","Kay ya impanaba nao diri kon garing ka kanaong kaogaringeng katenged basta ya kanaong Ama nga minpakarimbaba kanao ani minsogo kon ono say kanaong ipanaba. ");
INSERT INTO mmn_vpl VALUES ("JN12_50","073_12_50","JHN","12","50","50","Mahagdam hao nga ya toong kasogoan magahatag matood ka bag-ong kinabohi nga diri mawara. Agon ya kanaong impanaba kamazo si Ama ya minsogo kanao. Ani ini ya pagsindo ni Hisos ka mga tao. ");
INSERT INTO mmn_vpl VALUES ("JN13_1","073_13_1","JHN","13","1","1","Dispiras iton ka pista nga mangihaw ya mga Yodayo ka mga nati na karniro. Kamhan mahagdam si Hisos nga mindateng di ya tirmino nga ampanaw iza dini ka kalibotan kay ankandaked di ka toong Ama. Ipakita disab naiza koman nga pagaazaken naiza pagtineed ya toong mga sakop nga in-angay naiza dini ka kalibotan. ");
INSERT INTO mmn_vpl VALUES ("JN13_2","073_13_2","JHN","13","2","2","Na, delem di wani. Kamhan nanihapon di si Hisos daw ya toong mga sinarigan. Kamhan impatandeg daan ni Satanas ya hena-hena ni Hodas nga maanak ni Simon Iskariyoti dazaw edlawan di naiza si Hisos. ");
INSERT INTO mmn_vpl VALUES ("JN13_3","073_13_3","JHN","13","3","3","Kamhan si Hisos bisan mahagdam iza nga intagan iza na Ama ka labaw nga gahem, bisan iza matood ya mingaring ka Diyos daw iza isab ya an-oli kaan ka Diyos, minpangalagad iza ka toong mga sinarigan. ");
INSERT INTO mmn_vpl VALUES ("JN13_4","073_13_4","JHN","13","4","4","Kamhan ka nanihapon pen siran mintindeg iza. Minkawa iza ka isang lapid nga toong bado kay ambakes iza ka toalya. ");
INSERT INTO mmn_vpl VALUES ("JN13_5","073_13_5","JHN","13","5","5","Inhalin naiza ya sapa dizan ka palanggana. Kamhan minsogod iza paghogas ka kanirang paa. Kamhan impanarapohan ka toalya nga toong binakes. ");
INSERT INTO mmn_vpl VALUES ("JN13_6","073_13_6","JHN","13","6","6","Pagdateng naiza kan Simon Pidro minlaong si Pidro nga Ginoo, daw anhogas ko ka kanaong paa? ");
INSERT INTO mmn_vpl VALUES ("JN13_7","073_13_7","JHN","13","7","7","Minsambag si Hisos nga ya batasan nao dini kamazo koman diri pen mo masabtan. Kay-an ka lamang makasabot ko. ");
INSERT INTO mmn_vpl VALUES ("JN13_8","073_13_8","JHN","13","8","8","Minsambag si Pidro nga diri gazed hao ampahogas kanmo ka kanaong paa. Minsambag si Hisos nga kon diri ko ampahogas ka kanmong paa diri kon iko di ya kanaong sakop. ");
INSERT INTO mmn_vpl VALUES ("JN13_9","073_13_9","JHN","13","9","9","Minsambag si Simon Pidro nga Ginoo, ilakip mo ya kanaong alima daw olo paghogas daw paa! ");
INSERT INTO mmn_vpl VALUES ("JN13_10","073_13_10","JHN","13","10","10","Minsambag si Hisos nga pamolinged ini nga ya batasan na mamistahay namarigo iza daan. Kamhan pagdateng naiza ka pistahanan paa ka lamang ya isaben paghogas kay nahingloan di daan ya lawas. Dini kamazo nahingloan di kamo ka kamazong mga sala kamhan may isa nga wara kahingloi. ");
INSERT INTO mmn_vpl VALUES ("JN13_11","073_13_11","JHN","13","11","11","Ani ini ya impanaba ni Hisos kay mahagdam iza daan kon sin-o ya mag-edlaway kanangiza agon minlaong iza nga dini kamazo may isang tao nga wara kahingloi. ");
INSERT INTO mmn_vpl VALUES ("JN13_12","073_13_12","JHN","13","12","12","Pagkakamhan ka naiza paghogas ka paa niran imbado disab naiza pagbalik. Kamhan minbalik iza ka toong lo-toanan. Kamhan nangotana iza kaniran nga daw makasabot kamo kon ono ya kahologan na pagpangalagad nao kamazo? ");
INSERT INTO mmn_vpl VALUES ("JN13_13","073_13_13","JHN","13","13","13","Dini kanta ya batasan mazo pagangaranan mazo hao ka Maistro daw Ginoo. Kamhan hosto gazed kay ani hao. ");
INSERT INTO mmn_vpl VALUES ("JN13_14","073_13_14","JHN","13","14","14","Kamhan bisan hao ya Ginoo daw ya Maistro mazo minpangalagad hao paghogas ka kamazong paa. Kinahanglan maghinogasay isab kamo ka kamazong paa. ");
INSERT INTO mmn_vpl VALUES ("JN13_15","073_13_15","JHN","13","15","15","Iton nga batasan nao haoden gazed mazo. Magpaebes kamo ka kamazong kaogaringen dizan ka isa daw isa singed ka pagpangalagad nao kamazo. ");
INSERT INTO mmn_vpl VALUES ("JN13_16","073_13_16","JHN","13","16","16","Sabten mazo ini nga ya oripen diri kon labaw iza ka toong amo. Hinoa ababa gazed iza. Kamhan ya tao nga insogo diri kon labaw iza ka tao nga minsogo kanangiza ka pagpapanaw. ");
INSERT INTO mmn_vpl VALUES ("JN13_17","073_13_17","JHN","13","17","17","Kon sabten mazo ini nga sindo nao panaranginan kamo na Diyos ka madazaw kon tomanen mazo. ");
INSERT INTO mmn_vpl VALUES ("JN13_18","073_13_18","JHN","13","18","18","Kamhan ya impanaba nao diri kon mahitenged kamazong tanan kay mahagdam hao daan nga maonga ya batasan na isang tao nga pinili nao. Kay kinahanglan matoman ya daan pinasoyat na Diyos nga nagalaong nga ya tao nga minsaro kanao ka pagkaen iza ya an-edlaw kanao. ");
INSERT INTO mmn_vpl VALUES ("JN13_19","073_13_19","JHN","13","19","19","Impanan-ogan ta kamo koman ka wara pen tongop kay dazaw kon tomongop kay-an antoo kamo nga hao gazed si Kristo nga hari nga pinili na Diyos. ");
INSERT INTO mmn_vpl VALUES ("JN13_20","073_13_20","JHN","13","20","20","Sabten mazo ini nga ya tao nga nakaangay ka sinogo nao singed ka nakaangay gihapon iza kanao. Kamhan ya tao nga nakaangay kanao nakaangay isab iza ka Diyos nga minpakarimbaba kanao. ");
INSERT INTO mmn_vpl VALUES ("JN13_21","073_13_21","JHN","13","21","21","Pagkakamhan ni Hisos paglaong kaniran mabeg-at gazed ya toong hinawa. Kamhan minlaong iza nga timan-an mazo gazed ini nga wadini kanta matood ya an-edlaw kanao nga isa. ");
INSERT INTO mmn_vpl VALUES ("JN13_22","073_13_22","JHN","13","22","22","Ya toong mga sinarigan namagsinelengay siran kay wara nirang mahagdami kon sin-o ya an-edlaw kanangiza. ");
INSERT INTO mmn_vpl VALUES ("JN13_23","073_13_23","JHN","13","23","23","Kamhan dizan ka saing ni Hisos may isang sinarigan nga kinaazak naiza. ");
INSERT INTO mmn_vpl VALUES ("JN13_24","073_13_24","JHN","13","24","24","Kamhan insingyasan iza ni Simon Pidro daw nagalaong nga mangotana ko kan Hisos kon sin-o ya toong impasabot. ");
INSERT INTO mmn_vpl VALUES ("JN13_25","073_13_25","JHN","13","25","25","Kamhan inlingi naitong sinarigan daw minpahenek pagpangotana kan Hisos nga Ginoo, daw sin-o ya an-edlaw kanmo? ");
INSERT INTO mmn_vpl VALUES ("JN13_26","073_13_26","JHN","13","26","26","Minsambag si Hisos nga ya tao nga doholan nao ka pan nga itenleb nao ka sabaw aniton ya an-edlaw kanao. Kamhan pagtenleb naiza ka pan indohol matood kan Hodas nga maanak ni Simon Iskariyoti. ");
INSERT INTO mmn_vpl VALUES ("JN13_27","073_13_27","JHN","13","27","27","Pagdawat ni Hodas inharian dazon iza ni Satanas. Kamhan minlaong si Hisos nga ipadazon ya nahena-henaan mo pagdali. ");
INSERT INTO mmn_vpl VALUES ("JN13_28","073_13_28","JHN","13","28","28","Kamhan ya mga iba nga sinarigan dizan ka lamisa diri siran makasabot kon ono ya impanaba ni Hisos kan Hodas. ");
INSERT INTO mmn_vpl VALUES ("JN13_29","073_13_29","JHN","13","29","29","Dini kaniran si Hodas ya nagahipes ka kowarta. Kamhan may nagahena-hena nga minsogo si Hisos kan Hodas ka pagpalit ka mga kinahanglan niran ka pista. May nagahena-hena nga tagan naiza ya mga pobri ka hinabang. ");
INSERT INTO mmn_vpl VALUES ("JN13_30","073_13_30","JHN","13","30","30","Pagdawat ka ni Hodas ka inhatag ni Hisos nga pan mindali iza paglogwa ka lagkaw. Na, kahabzen di gazed. ");
INSERT INTO mmn_vpl VALUES ("JN13_31","073_13_31","JHN","13","31","31","Kamhan minlaong si Hisos ka toong mga sinarigan nga koman nga panahon hao nga minhon-a ka bisan sin-o nga mahon-ang tao tomanen nao ya kabebet-en na Diyos. Ini nga pagkapatay nao pagbeet daan na Diyos dazaw dini kanao ipakita nga iza ya labaw ka gahem. ");
INSERT INTO mmn_vpl VALUES ("JN13_32","073_13_32","JHN","13","32","32","Ya pagkapatay nao ipakita nga dakola gazed ya kalooy na Diyos ka mga tao. Kamhan ka wara pen madogay ihatag sab naiza kanao ya labaw nga gahem. ");
INSERT INTO mmn_vpl VALUES ("JN13_33","073_13_33","JHN","13","33","33","Kamo nga mga sinarigan nao singed kamo ka kanaong mga maanak. Na, diri hao magadogay dini kamazo. Kamhan ampangita gazed kamo kanao. Ya impanaba nao ka mga Yodayo inlaong sab nao kamazo nga diri kamo makaiba kanao ngaro ka karohanan nao. ");
INSERT INTO mmn_vpl VALUES ("JN13_34","073_13_34","JHN","13","34","34","Kamhan wani ya bag-ong sogo nao kamazo nga mag-angay-angay kamo. Kinahanglan ya kanaong batasan nga maloozon daw ya kamazong batasan mag-anika. ");
INSERT INTO mmn_vpl VALUES ("JN13_35","073_13_35","JHN","13","35","35","Kay kon magkinaloy-anay kamo ka isa daw isa makakilala ya tanan mga tao nga kamo ya mga sakop nao. ");
INSERT INTO mmn_vpl VALUES ("JN13_36","073_13_36","JHN","13","36","36","Kamhan si Simon Pidro nangotana kanangiza nga Ginoo, daw ankar-in di sa ko? Minsambag si Hisos nga ya karohan nao diri pen ko makaiba kanao piro kay-an makakaro ka ko. ");
INSERT INTO mmn_vpl VALUES ("JN13_37","073_13_37","JHN","13","37","37","Nangotana si Pidro nga Ginoo, kay ono sa nga diri hao makaiba kanmo koman? Dini kanao andam di hao daan ka pagpakapatay para kanmo. ");
INSERT INTO mmn_vpl VALUES ("JN13_38","073_13_38","JHN","13","38","38","Minsambag si Hisos nga daw andam iko gazed ka pagpakapatay para kanao? Timan-an mo gazed ini nga ka wara pen tagaok ya manok ikalimed di mo hao ka ikatolo. ");
INSERT INTO mmn_vpl VALUES ("JN14_1","073_14_1","JHN","14","1","1","Indogangan ni Hisos pagpanaba ka toong mga sinarigan nagalaong nga diri kamo magkawied. Hinoa magsarig kamo ka Diyos daw kanao. ");
INSERT INTO mmn_vpl VALUES ("JN14_2","073_14_2","JHN","14","2","2","Daked ka Ama nao haloag gazed iton. Kamhan ankaro hao dazaw an-andam hao ka kamazong hel-anan. Kon diri kon matood ini diri gazed hao maglaong kamazo. ");
INSERT INTO mmn_vpl VALUES ("JN14_3","073_14_3","JHN","14","3","3","Pagkakamhan nao pag-andam ka kamazong hel-anan ambalik hao ngarini kay pan-ibahen di kamo dazaw magakatibe kita daked. ");
INSERT INTO mmn_vpl VALUES ("JN14_4","073_14_4","JHN","14","4","4","Mahagdam kamo ka dalan nga magasinged ngaro ka kanaong karohanan. ");
INSERT INTO mmn_vpl VALUES ("JN14_5","073_14_5","JHN","14","5","5","Si Tomas minlaong kanangiza nga Ginoo, diri kami mahagdam kon hain ko karo. Onhon sa nami pagkahagdam kon hain ya dalan pag-azi? ");
INSERT INTO mmn_vpl VALUES ("JN14_6","073_14_6","JHN","14","6","6","Minsambag si Hisos nga ya dalan ka pag-azi ngaro ani hao. Kay hao nga si Kristo ani ya matood nga Diyos. Kamhan ya tag-iza ka bag-ong kinabohi nga diri mawara ani hao. Kamhan bisan sin-o nga tao kon diri iza an-azi dini kanao, diri iza andateng ka kanaong Ama. ");
INSERT INTO mmn_vpl VALUES ("JN14_7","073_14_7","JHN","14","7","7","Kon insakto ya pagkilala mazo kanao, makakilala isab kamo ka kanaong Ama. Sokad komang kahabzen makasabot kamo ka batasan na Ama pagbag-o kay dini kanao impasabot nao kamazo kon ono ya hena-hena na Diyos. ");
INSERT INTO mmn_vpl VALUES ("JN14_8","073_14_8","JHN","14","8","8","Si Pilipo minlaong kanangiza nga Ginoo, ipakita mo kanami ya Ama kay anika iton ya inkinahanglan nami. ");
INSERT INTO mmn_vpl VALUES ("JN14_9","073_14_9","JHN","14","9","9","Minsambag si Hisos nga Pilipo, dogay di wani ya pag-ibaiba nao kamazo. Kay ono sang wara pen sa ko makakilala kanao? Ya tao nga nakakita kanao singed ka nakakita isab iza ka kanaong Ama. Kay ono sa nangotana pen sa ko nga ipakita nao kamazo ya Ama? ");
INSERT INTO mmn_vpl VALUES ("JN14_10","073_14_10","JHN","14","10","10","Daw wara ko magtoo nga kami ni Ama isa ka gazed kami? Ya pagsindo nao kamazo diri kon garing kanao kay ya Ama nga nagakatibe dini kanao ani ya minhinang ka toong kaogaringeng tarabaho. ");
INSERT INTO mmn_vpl VALUES ("JN14_11","073_14_11","JHN","14","11","11","Toohan mazo nga kami ni Ama naisa ka gazed. Kon diri kamo antoo kaini magtoo kamo nga ya mga inhinang nao ani nagapamatood nga naisa ka gazed kami ni Ama. ");
INSERT INTO mmn_vpl VALUES ("JN14_12","073_14_12","JHN","14","12","12","Sabten mazo ini nga ya tao nga ampasakop kanao anhinang iza ka mga hinang singed ka kanaong mga inhinang. Kamhan ya toong mga hinang labaw pen iton ka kanaong mga inhinang kay ankandaked sa hao kan Ama. ");
INSERT INTO mmn_vpl VALUES ("JN14_13","073_14_13","JHN","14","13","13","Kon hao ya insakopan mazo, bisan ono nga pangazoon mazo kanao ihatag gazed nao kamazo. Ani ini ya kanaong hinang dazaw magasazaen ya Ama dini kanao nga toong Maanak. ");
INSERT INTO mmn_vpl VALUES ("JN14_14","073_14_14","JHN","14","14","14","Kon ampangazo kamo ka bisan ono kay hao ya insakopan mazo ihatag nao matood ya pangazoon mazo. ");
INSERT INTO mmn_vpl VALUES ("JN14_15","073_14_15","JHN","14","15","15","Kon matood ya pagkaazak mazo kanao tomanen mazo ya kanaong mga sogo. ");
INSERT INTO mmn_vpl VALUES ("JN14_16","073_14_16","JHN","14","16","16","Kamhan mangazo hao ka Ama daked dazaw tagan kamo ka Magsindoay ilis kanao. Kamhan iza ya an-iba kamazo kawanihen ka. ");
INSERT INTO mmn_vpl VALUES ("JN14_17","073_14_17","JHN","14","17","17","Iton nga Magsindoay ani ya Madazaw nga Ispirito nga garing ka Diyos. Pasabten naiza kamo kon ono ya insindo na Diyos. Diri mahimo ya pag-iba naiza ka mga diri ampasakop kanao kay waray kasabtan niran agon wara siran mahagdam kon sin-o sa iza. Piro nahagdam di kamo kanangiza kay mintineed di iza paghela dalem ka beet mazo. ");
INSERT INTO mmn_vpl VALUES ("JN14_18","073_14_18","JHN","14","18","18","Diri hao ambiza kamazo. Ambalik ka gazed hao dini kamazo. ");
INSERT INTO mmn_vpl VALUES ("JN14_19","073_14_19","JHN","14","19","19","Ka diri madogay ya mga diri antoo kanao diri siran makakita kanao pag-isab piro kamo nga kanaong mga sakop ankita gazed kamo kanao. Kay hao bohi sa agon mabohi sab kamo kawanihen ka. ");
INSERT INTO mmn_vpl VALUES ("JN14_20","073_14_20","JHN","14","20","20","Kay-an ka pagdateng kamazo na Madazaw nga Ispirito nga garing ka Diyos anipen kamo makasabot nga kami ni Ama naisa ka gazed. Kamhan kamo daw hao naisa ka disab kita. ");
INSERT INTO mmn_vpl VALUES ("JN14_21","073_14_21","JHN","14","21","21","Ya tao nga nagatoon ka kanaong kasogoan daw mintoman azaken hao naiza. Kamhan iza nga min-azak kanao in-azak isab iza na kanaong Ama. Azaken sab nao iza kamhan ipakita kanangiza ya kanaong kaogaringen. ");
INSERT INTO mmn_vpl VALUES ("JN14_22","073_14_22","JHN","14","22","22","Si Hodas nga diri kon taga Kariyoti minpangotana iza kan Hisos nga Ginoo, kay ono sa dini kanami ka lamang impakita mo ya kanmong kaogaringen kamhan diri ilakip ya mga iba pen nga tao? ");
INSERT INTO mmn_vpl VALUES ("JN14_23","073_14_23","JHN","14","23","23","Minsambag si Hisos nga kon naazak ya tao kanao tomanen naiza ya kanaong sindo. Kamhan iza ya in-azak na kanaong Ama. Kamhan dini kaini nga tao magakatibe kami ni Ama. ");
INSERT INTO mmn_vpl VALUES ("JN14_24","073_14_24","JHN","14","24","24","Kamhan ya tao nga diri maazak kanao diri iza antoman ka kanaong sindo. Kamhan ya pagsindo nga impanalingahen mazo diri kon garing kanao kay garing gazed ka Ama nga minpakarimbaba kanao. ");
INSERT INTO mmn_vpl VALUES ("JN14_25","073_14_25","JHN","14","25","25","Ka dini pen hao kamazo impanabaan ta kamo. ");
INSERT INTO mmn_vpl VALUES ("JN14_26","073_14_26","JHN","14","26","26","Kamhan ya Magsindoay nga Madazaw nga Ispirito nga insogo na kanaong Ama insili kanao. Iza ya antoldo kamazo ka tanan inkinahanglan mazo. Pataremdemen disab naiza kamazo ya tanan impanaba nao kamazo. ");
INSERT INTO mmn_vpl VALUES ("JN14_27","073_14_27","JHN","14","27","27","Kamhan ya malinaw nga hinawa ibilin nao kamazo. Garing kanao ini nga kalinaw. Ya taga kalibotan waray ikahatag naiza singed ka inhatag nao kamazo. Diri kamo magkawied. Diri sab kamo magkahaldek. ");
INSERT INTO mmn_vpl VALUES ("JN14_28","073_14_28","JHN","14","28","28","Izang dini kaini nabatian mazo ya kanaong impanaba nga ampanaw hao dini kamazo. Kamhan ambalik gazed hao. Na, kon matood ya pagkaazak mazo kanao may kasaza mazo kay an-oli di hao ka kanaong Ama kay labaw iza kanao kay hao ya toong Maanak. ");
INSERT INTO mmn_vpl VALUES ("JN14_29","073_14_29","JHN","14","29","29","Ka wara pen toman kaiton impakahagdam ta kamo daan kay dazaw kay-an ka pagtoman di antoo kamo kaini nga impanaba nao kamazo. ");
INSERT INTO mmn_vpl VALUES ("JN14_30","073_14_30","JHN","14","30","30","Diri di hao andogay ka paglaonglaong kamazo kay domatengay di si Satanas nga magahari ka mga taga kalibotan piro diri mahimo ya paghari naiza kanao. ");
INSERT INTO mmn_vpl VALUES ("JN14_31","073_14_31","JHN","14","31","31","Inhinang nao ya tanan mga sogo na Ama kanao dazaw mahagdam ya mga tao nga ya Ama ani ya kinaazak nao. Na, hala di manindeg di kita. ");
INSERT INTO mmn_vpl VALUES ("JN15_1","073_15_1","JHN","15","1","1","Kamhan indogangan ni Hisos pagsindo ka toong mga sinarigan nagalaong nga pamolinged ta kamo mahitenged ka pagtabang nao kamazo ka paghinang ka mga madazaw. Na, hao ya singed ka lawas na tanem ani ngaran ya obas. Ya tag-iza isab na tamnanan ka obas ani ya Ama nao. ");
INSERT INTO mmn_vpl VALUES ("JN15_2","073_15_2","JHN","15","2","2","Kamhan ya mga sap-ay na tanem ani ya mga tao. Ya mga wara mamonga impan-otdan na Ama nao. Ya mga bomongahay inhingloan hinoa naiza kay dazaw homatag ka mataed nga bonga. ");
INSERT INTO mmn_vpl VALUES ("JN15_3","073_15_3","JHN","15","3","3","Nahingloan di daan kamo kay ya insindo na Diyos nga inpanaba nao kamazo dizan di iton ka kamazong hena-hena. ");
INSERT INTO mmn_vpl VALUES ("JN15_4","073_15_4","JHN","15","4","4","Hegeten mazo ya pagsarig mazo kanao kamhan pabilin hao dini kamazo. Simpan may sap-ay nga in-otod di diri iton makabonga kay in-otod di. Singed iton kamazo kay kon bomiza kamo ka pagsarig mazo kanao waray antabang kamazo ka paghinang ka mga madazaw. ");
INSERT INTO mmn_vpl VALUES ("JN15_5","073_15_5","JHN","15","5","5","Kay hao ya singed ka lawas na tanem. Kamo disab ya singed ka mga sap-ay. Kon hegeten mazo ya pagsarig mazo kanao mataed ya mga hininang mazo nga makasaza ka Diyos kay hao ya min-ibaiba kamazo. Kay waray mahimo kon wara hao mag-iba kamazo. ");
INSERT INTO mmn_vpl VALUES ("JN15_6","073_15_6","JHN","15","6","6","Kon bomiza ya tao ka toong pagsarig kanao bizaan disab nao iza singed ka sap-ay nga in-otod di. Kamhan pagkalaza ipanipon ya mga sap-ay nga in-otod di kamhan sonogon. ");
INSERT INTO mmn_vpl VALUES ("JN15_7","073_15_7","JHN","15","7","7","Kon hegeten mazo ya pagsarig mazo kanao, kon diri kamo magkalipat ka kanaong inpanaba kamazo, makapangazo kamo ka bisan ono kamhan makadawat kamo. ");
INSERT INTO mmn_vpl VALUES ("JN15_8","073_15_8","JHN","15","8","8","Kon antoman kamo ka naazakan na kanaong Ama magasazaen gazed iza kay nagapamatood kamo nga kamo di ya kanaong mga sakop. ");
INSERT INTO mmn_vpl VALUES ("JN15_9","073_15_9","JHN","15","9","9","Ya pag-azak na Ama kanao daw ya pag-azak nao kamazo mag-anika. Diri kamo magbiza ka kamazong pagsarig kanao. ");
INSERT INTO mmn_vpl VALUES ("JN15_10","073_15_10","JHN","15","10","10","Kon tomanen mazo ya kanaong mga sogo magkaangay kita singed ka pagkaangay nao daw ya kanaong Ama kay mintoman isab hao ka toong mga sogo kanao. ");
INSERT INTO mmn_vpl VALUES ("JN15_11","073_15_11","JHN","15","11","11","Impanabaan ta kamo kaini nga tanan dazaw ya kanaong kasaza nga garing ka pagtoman nao ka mga sogo na kanaong Ama ani disab ya kamazong kasaza kay mintoman kamo ka kanaong inpanaba kamazo. Kamhan dakola gazed ya kasaza mazo. ");
INSERT INTO mmn_vpl VALUES ("JN15_12","073_15_12","JHN","15","12","12","Wani ya kanaong sogo kamazo nga mag-angay-angay kamo haod ka pagpakaangay nao kamazo. ");
INSERT INTO mmn_vpl VALUES ("JN15_13","073_15_13","JHN","15","13","13","Ya labaw nga kaazak na tao ihatag ka toong mga higara ani ya pagpakapatay ka lawas pagsili kaniran. ");
INSERT INTO mmn_vpl VALUES ("JN15_14","073_15_14","JHN","15","14","14","Na, kamo ani ya kanaong mga higara kon tomanen mazo ya mga sogo nao kamazo. ");
INSERT INTO mmn_vpl VALUES ("JN15_15","073_15_15","JHN","15","15","15","Diri hao anngaran kamazo ka mga sogoonon nao kay ya tao nga insogo wara iza mahagdam ka hena-hena na toong amo. Hinoa ngaranan di ta kamo nga kanaong mga higara kay impakahagdam di nao ya tanan nabatian nao nga garing ka kanaong Ama. ");
INSERT INTO mmn_vpl VALUES ("JN15_16","073_15_16","JHN","15","16","16","Izang mahon-a pen diri kon kamo ya ampasakop kanao imbis kay hao hinoa ya minpasakop kamazo kay impili ta kamo dazaw pakarohon kamo ngaro ka mga tao. Ya pagdara mazo ka kanaong sindo dizan kaniran singed iton ka tanem nga mamonga ka mga madazaw nga bonga. Kamhan inhatagan kamo ni Ama ka bisan ono nga azoon mazo kay hao ya insakopan mazo. ");
INSERT INTO mmn_vpl VALUES ("JN15_17","073_15_17","JHN","15","17","17","Wani ya isogo nao kamazo nga mag-angay-angay kamo. ");
INSERT INTO mmn_vpl VALUES ("JN15_18","073_15_18","JHN","15","18","18","Pagkontara na mga tao kamazo diri kamo magkabereng kay hao ya inkontara niran paghon-a. ");
INSERT INTO mmn_vpl VALUES ("JN15_19","073_15_19","JHN","15","19","19","Kon nagaangay kamo ka mga diri kon sakop nao, an-angay gihapon siran kamazo. Impili nao kamo ka pagbelag kaniran agon wara kamo mag-angay kaniran. Kamhan kontarahon kamo niran. ");
INSERT INTO mmn_vpl VALUES ("JN15_20","073_15_20","JHN","15","20","20","Magtaremdem kamo ka sindo nao kamazo nga ya oripen diri kon labaw iza ka toong amo. Hinoa ababa gazed iza. Pinagadaegdaeg hao na mga tao. Kamhan magadaegdaeg sab siran kamazo. Kon intoman niran ya kanaong inpanaba tomanen sab niran ya kamazong ipanaba. ");
INSERT INTO mmn_vpl VALUES ("JN15_21","073_15_21","JHN","15","21","21","Ani ini ya batasan niran kamazo kay hao ya insakopan mazo. Diri isab siran ankilala kanangiza nga minpakarimbaba kanao agon nagadaegdaeg siran kamazo. ");
INSERT INTO mmn_vpl VALUES ("JN15_22","073_15_22","JHN","15","22","22","Kon wara hao makarimbaba, kon wara hao magsindo kaniran nga hao ya kanirang intagadan, may baribad niran ka sala niran nga pagdiri kanao. Piro kay diri di gazed siran makabaribad ka sala niran kay minkarimbaba matood hao. Kamhan diri siran ampanoo kanao. ");
INSERT INTO mmn_vpl VALUES ("JN15_23","073_15_23","JHN","15","23","23","Ya tao nga nagakontara kanao nagakontara isab iza ka kanaong Ama daked. ");
INSERT INTO mmn_vpl VALUES ("JN15_24","073_15_24","JHN","15","24","24","Dizan kaniran kon wara nao hinanga ya mga madazaw nga wara pen mahinang na tao sokad may ikabaribad niran ka sala niran ka pagdiri kanao. Piro kay minkita siran gazed kaini nga mga inhinang nao. Kamhan magakontara siran kanao daw ya kanaong Ama. ");
INSERT INTO mmn_vpl VALUES ("JN15_25","073_15_25","JHN","15","25","25","Ani ini ya kanirang batasan dazaw matoman ya daan pinasoyat dizan ka kanirang balaed nagalaong nga inkontara hao niran bisan waray sala nao. ");
INSERT INTO mmn_vpl VALUES ("JN15_26","073_15_26","JHN","15","26","26","Na, dini kamazo andateng ya Magsindoay nga Madazaw nga Ispirito nga garing ka Ama daked. Pasabten naiza kamo kon ono ya matood. Iza nga inpakarimbaba nao garing ka Ama ani ya ampamatood nga hao gazed si Kristo nga hari nga pinili na Diyos. ");
INSERT INTO mmn_vpl VALUES ("JN15_27","073_15_27","JHN","15","27","27","Kamo disab ya ampanan-og kaini dizan ka mga tao kay sokad ka sinogdan ka pagsindo nao ka mga tao kamo ya min-iba kanao. ");
INSERT INTO mmn_vpl VALUES ("JN16_1","073_16_1","JHN","16","1","1","Impanabaan ta kamo kaini nga tanan dazaw pagdateng na mga kalised kamazo diri kamo ambiza kanao. ");
INSERT INTO mmn_vpl VALUES ("JN16_2","073_16_2","JHN","16","2","2","Pamogawen kamo ka singbahan na mga Yodayo. Arani di ya tirmino nga ya ampatay kamazo silaong naiza tomanen naiza ya sogo na Diyos. ");
INSERT INTO mmn_vpl VALUES ("JN16_3","073_16_3","JHN","16","3","3","Ani ini ya toong hininang kay wara iza magkilala kanami ni Ama. ");
INSERT INTO mmn_vpl VALUES ("JN16_4","073_16_4","JHN","16","4","4","Impanabaan ta kamo kaini dazaw kon inhinang niran ini kamazo makataremdem di kamo nga impakahagdam kamo daan. Izang dini kaini ka pagsogod nao ka pagsindo kamazo wara hao magpakahagdam kamazo kaini kay nagaiba pen hao kamazo. ");
INSERT INTO mmn_vpl VALUES ("JN16_5","073_16_5","JHN","16","5","5","Piro pomanaway di hao kay an-oli di hao ka Ama nga minpakarimbaba kanao. Kamhan waray isa dini kamazo nga mangotana kanao kon ankar-in sa hao pagsinged. ");
INSERT INTO mmn_vpl VALUES ("JN16_6","073_16_6","JHN","16","6","6","Imbis kay dakola ya kamazong pag-awa kay minpakahagdam di hao kamazo ka mga kalised nga domatengay kamazo. ");
INSERT INTO mmn_vpl VALUES ("JN16_7","073_16_7","JHN","16","7","7","Sabten mazo ini nga ya pagpanaw nao dini kamazo madazaw iton kay kon diri hao anpanaw diri andateng dini kamazo ya Magsindoay nga Madazaw nga Ispirito nga garing ka Ama daked. Pagpanaw nao dini kamazo ipakarimbaba pen nao iza kamazo. ");
INSERT INTO mmn_vpl VALUES ("JN16_8","073_16_8","JHN","16","8","8","Pagdateng naiza pasabten naiza ya mga tao nga mga salaan siran. Pasabten disab naiza nga hao ya madazaw. Pasabten sab naiza mahitenged ka pagpahamtang kaniran na Diyos ka kamatazen. ");
INSERT INTO mmn_vpl VALUES ("JN16_9","073_16_9","JHN","16","9","9","Ya pagdiri niran kanao ani ya sala niran. ");
INSERT INTO mmn_vpl VALUES ("JN16_10","073_16_10","JHN","16","10","10","Pasabten sab siran nga hao ya waray sala kay an-oli hao daked kan Ama. Kamhan diri di mazo hao makita. ");
INSERT INTO mmn_vpl VALUES ("JN16_11","073_16_11","JHN","16","11","11","Pasabten sab naiza nga waray kinateban ya silot ka mga tao nga diri antoo kanao kay minpahamtang ya Diyos daan ka silot kan Satanas nga tag-iza kaniran. ");
INSERT INTO mmn_vpl VALUES ("JN16_12","073_16_12","JHN","16","12","12","Mataed pen kontana ya ipanaba nao kamazo piro diri kamo makaanget ka pagpanalinga. ");
INSERT INTO mmn_vpl VALUES ("JN16_13","073_16_13","JHN","16","13","13","Na, ya Magsindoay nga Madazaw nga Ispirito kon andateng iza garing ka Ama pasabten naiza kamo ka tanan mga insindo na Diyos. Kay diri kon garing ka toong kaogaringeng pagbeet ya pagpasabot naiza kay ya toong nabatian hinoa nga garing daked anikay magapansindo. Kamhan pasabten sab kamo naiza ya mga kaazi nga wara pen toman dini ka kalibotan. ");
INSERT INTO mmn_vpl VALUES ("JN16_14","073_16_14","JHN","16","14","14","Magasazaen hao naiza nga Ispirito kay ya sindo nga nabatian naiza dini kanao ani ya toong ipanan-og kamazo. ");
INSERT INTO mmn_vpl VALUES ("JN16_15","073_16_15","JHN","16","15","15","Ya kan Ama nga sindo ani sab ya kanaong pagsindo. Kamhan ya sindo nga nabatian na Ispirito dini kanao ani sab ya toong pagsindo kamazo. ");
INSERT INTO mmn_vpl VALUES ("JN16_16","073_16_16","JHN","16","16","16","Ka diri di madogay diri di mazo hao makitan. Kamhan diri ka isab madogay nga makakita kamo kanao pag-isab. ");
INSERT INTO mmn_vpl VALUES ("JN16_17","073_16_17","JHN","16","17","17","Pagpakabati ka na toong mga sinarigan namaglaonglaong di siran nga daw ono waro ya kahologan na impanaba kanta nga nagalaong sa iza nga diri di madogay nga diri mazo hao makita. Diri ka isab madogay nga makakita kamo kanao pag-isab kay ambalik hao kan Ama. ");
INSERT INTO mmn_vpl VALUES ("JN16_18","073_16_18","JHN","16","18","18","Daw ono ya kahologan na toong magaasangpanabaen nga diri di iza madogay dini? Diri sa kita makasabot. ");
INSERT INTO mmn_vpl VALUES ("JN16_19","073_16_19","JHN","16","19","19","Mahagdam si Hisos nga may ipangotana kontana niran agon inlong-an naiza siran nga daw ani pagapanabaen mazo ya kamazong kawied ka pagakahologan na impanaba nao kamazo nga diri di andogay nga diri di mazo hao makitan. Diri ka isab madogay nga makakita kamo kanao pag-isab. ");
INSERT INTO mmn_vpl VALUES ("JN16_20","073_16_20","JHN","16","20","20","Sabten mazo ini nga kay-an ka pagkapatay nao magahaza kamo ka pag-awa kanao. Kamhan ya mga tao nga diri antoo kanao magasaza hinoa siran. Kamhan ya kamazong pag-awa masilihan ka kay-an ka kasaza. ");
INSERT INTO mmn_vpl VALUES ("JN16_21","073_16_21","JHN","16","21","21","Pamolingdan ini mahitenged ka pagpamati na kabdes. Ka hapit di iza mataohan na maimpis dakola ya toong pagbati ka masakit. Kamhan pagkatao di nalipat ka iza ka toong masakit. Minsaza di iza hinoa kay natao di ya bata. ");
INSERT INTO mmn_vpl VALUES ("JN16_22","073_16_22","JHN","16","22","22","Singed sab kamo ka kaazi na kabdes nga dakola ya pag-anget kay nabeg-atan ya kamazong hinawa kay ampanaw di hao piro magkita kita kay-an pag-isab. Kamhan pahangkazan gazed ya kamazong hinawa. Waray makakawa kaini nga kasaza mazo. ");
INSERT INTO mmn_vpl VALUES ("JN16_23","073_16_23","JHN","16","23","23","Kay-an ka pagbalik nao garing ka lebeng diri di kon hao ya azoanan mazo. Sabten mazo ini nga ya Ama nao iza ya anhatag kamazo ka bisan ono ya pagpangazoon kay hao ya insakopan mazo. ");
INSERT INTO mmn_vpl VALUES ("JN16_24","073_16_24","JHN","16","24","24","Keteb koman pagpangazo mazo kan Ama wara pen hao malakip ka pagsabi mazo. Na, bag-o di ilakip mazo hao pagsabi mazo kay hao ya insakopan mazo. Kamhan hatagan kamo dazaw dakola gazed ya kasaza mazo. ");
INSERT INTO mmn_vpl VALUES ("JN16_25","073_16_25","JHN","16","25","25","Izang dini kaini ya batasan nao ka pagsindo kamazo impaazi nao ka pamolinged. Kamhan arani di ya tirmino nga diri di hao angamit ka mga pamolinged kay ampanaba hao kamazo mahitenged kan Ama ka mga makalaro nga panaba. ");
INSERT INTO mmn_vpl VALUES ("JN16_26","073_16_26","JHN","16","26","26","Kon domateng di hao ngandaked kan Ama ya mga magapan-azoon mazo kanao ilargo mazo kan Ama ilakip sab hao pagsabi kay hao ya insakopan mazo. Panalingzan gazed kamo ni Ama singed ka pagpanalinga naiza kanao. ");
INSERT INTO mmn_vpl VALUES ("JN16_27","073_16_27","JHN","16","27","27","Kay magaazaken kamo ni Ama kay hao ya in-azak mazo. Nagatoo disab kamo nga inpakarimbaba hao ni Ama kamazo. ");
INSERT INTO mmn_vpl VALUES ("JN16_28","073_16_28","JHN","16","28","28","Minkarimbaba hao ka kalibotan garing kan Ama daked. Kamhan ampanaw ka hao dini ka kalibotan kay an-oli ka hao ngandaked kan Ama. ");
INSERT INTO mmn_vpl VALUES ("JN16_29","073_16_29","JHN","16","29","29","Pagkakamhan ni Hisos paglaong kaiza maglaong ya toong mga sinarigan nga makalaro di ya kanmong pagpanan-og. Diri di kon pamolinged singed ka mahon-a pen. ");
INSERT INTO mmn_vpl VALUES ("JN16_30","073_16_30","JHN","16","30","30","Bisan wara kami magpangotana kanmo mahagdam iko daan kon ono ya kanaming hena-hena. Agon nagatoo gazed kami nga garing ko matood ka Diyos. ");
INSERT INTO mmn_vpl VALUES ("JN16_31","073_16_31","JHN","16","31","31","Minsambag si Hisos nga daw mintoo kamo nga garing hao ka Diyos? ");
INSERT INTO mmn_vpl VALUES ("JN16_32","073_16_32","JHN","16","32","32","Manalinga kamo nga ka diri pen madogay manbelagbelag kamo tanan ngaro ka kamazong lagkaw. Mabizaan hao mazo piro ya Ama an-iba pen iza kanao. ");
INSERT INTO mmn_vpl VALUES ("JN16_33","073_16_33","JHN","16","33","33","Impanabaan ta kamo kaini nga tanan kay dazaw waray kawied mazo kay hao ya insakopan mazo. Bisan magaazi kamo ka mga masiet nga kalised dini ka kalibotan, diri di kamo magkahaldek kay nakadaeg di hao ka tag-iza na mga maonga dini ka kalibotan. ");
INSERT INTO mmn_vpl VALUES ("JN17_1","073_17_1","JHN","17","1","1","Pagkakamhan ni Hisos pagpanaba ka toong mga sinarigan minhangad iza ka langit ka pagpangamozo ka Diyos nagalaong nga Ama, mindateng di ya tirmino nga ampanaw hao dini ka kalibotan. Ipakita mo nga pinakalabaw hao nga Maanak mo dazaw sazaen disab iko nga Ama. ");
INSERT INTO mmn_vpl VALUES ("JN17_2","073_17_2","JHN","17","2","2","Insarigan mo hao daan ka gahem dazaw hao ya anhatag ka bag-ong kinabohi nga diri mawara dini ka tanan mga tao nga inkahatag mo kanao. ");
INSERT INTO mmn_vpl VALUES ("JN17_3","073_17_3","JHN","17","3","3","Kamhan ya bag-ong kinabohi nga diri mawara ani ya pagkaangay niran kanmo nga bogtong matood nga Diyos daw kanao nga si Hiso Kristo nga inpakarimbaba mo. ");
INSERT INTO mmn_vpl VALUES ("JN17_4","073_17_4","JHN","17","4","4","Dini ka kalibotan minpakita di hao ka mga tao nga iko ya labaw ka gahem kay nakakamhan di hao ka tarabaho nga insarig mo kanao. ");
INSERT INTO mmn_vpl VALUES ("JN17_5","073_17_5","JHN","17","5","5","Kamhan, Ama, pagdateng nao daked kanmo ibalik mo kanao ya katenged nga kanao gazed kawandini pen ka pagkatibe ta ka wara pen mahinang ya kalibotan. ");
INSERT INTO mmn_vpl VALUES ("JN17_6","073_17_6","JHN","17","6","6","Impakilala di nao iko dini ka mga tao nga inhatag mo kanao dini ka kalibotan. Kamhan kanmo siran. Kamhan inhatag mo siran kanao. Kamhan intoman niran ya impanaba mo kaniran. ");
INSERT INTO mmn_vpl VALUES ("JN17_7","073_17_7","JHN","17","7","7","Kamhan mahagdam siran nga ya tanan impasindo nao nga inhatag mo kanao mingaring gazed kanmo. ");
INSERT INTO mmn_vpl VALUES ("JN17_8","073_17_8","JHN","17","8","8","Kay inhatag nao kaniran ya mga sindo nga inhatag mo kanao. Kamhan mintoo siran agon mahagdam siran nga hao matood ya garing kanmo. Mintoo disab siran nga iko ya minpakarimbaba kanao. ");
INSERT INTO mmn_vpl VALUES ("JN17_9","073_17_9","JHN","17","9","9","Ama, ini nga paghangzo nao diri kon para ka mga tao nga wara magsakop kanao kay ani hinoa ya inpangamozo nao ya mga tao nga inhatag mo kanao kay kanmo siran. ");
INSERT INTO mmn_vpl VALUES ("JN17_10","073_17_10","JHN","17","10","10","Kay ya kanaong mga sakop anisab ya kanmong mga sakop. Kamhan ya kanmong mga sakop anisab ya kanaong mga sakop. Kamhan dini kaniran insaza hao. ");
INSERT INTO mmn_vpl VALUES ("JN17_11","073_17_11","JHN","17","11","11","An-oli di hao kanmo. Diri di hao andogay dini ka kalibotan piro mabilin pen siran dini ka kalibotan. Ama, ihangzo nao kanmo kay iko ya matood nga Diyos. Iko ya labaw ka gahem. Bantazan mo siran nga mga sakop nga inhatag mo kanao kay dazaw namag-angay siran ka hena-hena singed ka pagkaangay nga hena-hena ta. ");
INSERT INTO mmn_vpl VALUES ("JN17_12","073_17_12","JHN","17","12","12","Pag-ibaiba pen nao kaniran hao ya nagaaligara kaniran kay intagan mo hao ka gahem ka pagbantay kaniran nga mga inhatag mo kanao. Imbantazan gazed nao siran kamhan waray isa kaniran nga madara doro ka impirno. Si Hodas anikay ansopak kanao kamhan ya impirno ani ya toong datnganan. Kamhan matoman ya daan pinasoyat mo mahitenged kanangiza. ");
INSERT INTO mmn_vpl VALUES ("JN17_13","073_17_13","JHN","17","13","13","Ama, arani di ya tirmino ka pag-oli nao kanmo. Kamhan ini nga paghangzo nao inpabati nao kaniran dazaw magsaza gazed siran iba kanao. ");
INSERT INTO mmn_vpl VALUES ("JN17_14","073_17_14","JHN","17","14","14","Inhatag di nao kaniran ya kanmong sindo. Kamhan inkontara siran na mga diri kon sakop nao kay siran di ya mga maanak mo kamhan taga daked siran singed kanao. ");
INSERT INTO mmn_vpl VALUES ("JN17_15","073_17_15","JHN","17","15","15","Diri mo kaw-en siran garing ka kalibotan hinoa panalipedan mo siran kay dazaw diri siran madaeg ni Satanas. ");
INSERT INTO mmn_vpl VALUES ("JN17_16","073_17_16","JHN","17","16","16","Taga daked siran singed kanao nga taga daked. ");
INSERT INTO mmn_vpl VALUES ("JN17_17","073_17_17","JHN","17","17","17","Gamiten mo ya kanmong mga panaba ka pagtabang kanirang ka pagtoman ka kanmong naazakan. Kay iko ya minpanaba daan ka mga matood nga panaba. ");
INSERT INTO mmn_vpl VALUES ("JN17_18","073_17_18","JHN","17","18","18","Inpakarimbaba mo hao ka kalibotan. Kamhan pakarohon disab nao siran ngaro ka mga tao. ");
INSERT INTO mmn_vpl VALUES ("JN17_19","073_17_19","JHN","17","19","19","Tenged kaniran inhatag nao ya kanaong kaogaringen ka pagtoman ka kanmong naazakan dazaw tabangan siran ka pagtoman ka sindo nga impasabot nao kaniran. ");
INSERT INTO mmn_vpl VALUES ("JN17_20","073_17_20","JHN","17","20","20","Ama, ya mga sinarigan nao diri kon para kaniran ka lamang ya inhangzo nao kanmo. Kay ilakip gihapon ya mga mahoring sakop nga insindo naini nga mga sinarigan. ");
INSERT INTO mmn_vpl VALUES ("JN17_21","073_17_21","JHN","17","21","21","Kamhan namag-angay di siran ka hena-hena singed ka pagkaangay nga hena-hena ta. Kamhan namag-angay disab siran kanta dazaw antoo ya mga tao nga iko gazed ya minpakarimbaba kanao. ");
INSERT INTO mmn_vpl VALUES ("JN17_22","073_17_22","JHN","17","22","22","Ya madazaw nga inhatag mo kanao inhatag disab nao ka kanaong mga sakop kay dazaw namag-angay di siran ka hena-hena singed ka pagkaangay nga hena-hena ta. ");
INSERT INTO mmn_vpl VALUES ("JN17_23","073_17_23","JHN","17","23","23","Hao daw siran nagakaangay ka hena-hena. Angay isab ya kantang hena-hena dazaw insakto gazed ya pagkaangay niran. Kamhan mahagdam ya mga tao nga iko ya minpakarimbaba kanao kay min-azak ko kaniran singed ka pag-azak mo kanao. ");
INSERT INTO mmn_vpl VALUES ("JN17_24","073_17_24","JHN","17","24","24","Ama, gosto nao nga ya mga sakop nga inhatag mo kanao pahel-en nao siran daked iba kanao dazaw anseleng siran ka madazaw dizan kanao nga inhatag mo kanao paghon-a kay hao ya naazakan mo ka wara pen mahinang ya kalibotan. ");
INSERT INTO mmn_vpl VALUES ("JN17_25","073_17_25","JHN","17","25","25","Ama, polos matadeng ya batasan mo. Kamhan ya mga diri ansakop kanao wara siran makasabot kanmo. Nakasabot hao kanmo kamhan ya mga minsarig kanao siran disab mahagdam nga iko ya minpakarimbaba kanao. ");
INSERT INTO mmn_vpl VALUES ("JN17_26","073_17_26","JHN","17","26","26","Impasabot di nao siran kon ono ya kanmong hena-hena. Kamhan ampasabot pen hao kaniran kon ono ya kanmong hena-hena dazaw mahagdam siran nga dakola ya pagkaazak mo kanao. Kamhan hao daw siran nagakaangay ka hena-hena. ");
INSERT INTO mmn_vpl VALUES ("JN18_1","073_18_1","JHN","18","1","1","Pagkakamhan ni Hisos paghangzo ka toong Ama minpanaw iza daw ya toong mga sinarigan dizan ka Hirosalem. Kamhan minsinged siran ngandipi ka isang lozo na alog inngaranan ka Kidron. May isang tamnanan ka mga liwaan dizan. Kamhan minseled si Hisos daw ya toong mga sinarigan. ");
INSERT INTO mmn_vpl VALUES ("JN18_2","073_18_2","JHN","18","2","2","Si Hodas nga mag-edlaway kanangiza nahagdam disab kaiton nga dapit kay ya batasan ni Hisos onay makigtipon ka toong mga sinarigan dizan. ");
INSERT INTO mmn_vpl VALUES ("JN18_3","073_18_3","JHN","18","3","3","Kamhan mindateng si Hodas impaiba disab ya isang ka panen nga mga soldaw daw ya mga magbantazay ka singbahan na mga Yodayo kay insogo siran na mga oloolo na mga pari daw ya mga Parasiyo. Namagsolò di siran kay kahabzen di. Namagdara siran ka mga iawazay. ");
INSERT INTO mmn_vpl VALUES ("JN18_4","073_18_4","JHN","18","4","4","Mahagdam si Hisos daan kon ono ya tanan kaazi naiza kaan. Agon minsogat iza kaniran daw nangotana nga daw sin-o ya impangita mazo? ");
INSERT INTO mmn_vpl VALUES ("JN18_5","073_18_5","JHN","18","5","5","Minsambag siran nga si Hisos nga taga Nazarit. Minlaong si Hisos nga wani ka sa hao. Kamhan si Hodas nga mag-edlaway mintindeg iza dizan iba ka mga soldaw. ");
INSERT INTO mmn_vpl VALUES ("JN18_6","073_18_6","JHN","18","6","6","Pagsambag ni Hisos kaniran nga wani ka hao nanibeg siran daw nagapatideeg ka pagkahaldek. ");
INSERT INTO mmn_vpl VALUES ("JN18_7","073_18_7","JHN","18","7","7","Kamhan min-otro si Hisos pagpangotana kaniran nga daw sin-o wani ya impangita mazo? Minsambag siran nga si Hisos nga taga Nazarit. ");
INSERT INTO mmn_vpl VALUES ("JN18_8","073_18_8","JHN","18","8","8","Minlaong si Hisos nga inlong-an ta kamo nga wani ka sa hao dakoza. Kamhan kon hao ka ya tozo mazo azaw mazo hilabti ya mga sinarigan nao. ");
INSERT INTO mmn_vpl VALUES ("JN18_9","073_18_9","JHN","18","9","9","Ani ini ya insambag ni Hisos dazaw matoman izang inlaong naiza ka toong Ama nagalaong nga ya kanaong mga sakop nga inhatag mo kanao waray isa kaniran nga nakawa na mga maonga. ");
INSERT INTO mmn_vpl VALUES ("JN18_10","073_18_10","JHN","18","10","10","Kamhan si Simon Pidro nga may lodzo minhogot iza daw mintigbas. Kamhan nakawa dazon ya talinga nga too na oripen na labaw nga pari. Si Malko ya ngaran na oripen. ");
INSERT INTO mmn_vpl VALUES ("JN18_11","073_18_11","JHN","18","11","11","Kamhan minbaheg si Hisos kan Pidro nga isog-ob ya lodzo mo. Angeten nao ini nga masarang kalised nga garing ka kanaong Ama. ");
INSERT INTO mmn_vpl VALUES ("JN18_12","073_18_12","JHN","18","12","12","Kamhan indakep si Hisos na mga soldaw daw ya kanirang kapitan daw ya mga magbantazay nga Yodayo kamhan ingapos dazon. ");
INSERT INTO mmn_vpl VALUES ("JN18_13","073_18_13","JHN","18","13","13","Kamhan in-ated ngaro kan Anas paghon-a kay iza ya ogangan ni Kayapas nga labaw nga pari koman nga panahon. ");
INSERT INTO mmn_vpl VALUES ("JN18_14","073_18_14","JHN","18","14","14","Izang dini kaini si Kayapas ani ya minsogo ka mga Yodayo nga nagalaong nga magazon gazed kon isa ka lamang nga tao ya patazen na mga taga Roma dazaw diri matibe ya mga Yodayo pagkapildi. ");
INSERT INTO mmn_vpl VALUES ("JN18_15","073_18_15","JHN","18","15","15","Kamhan si Simon Pidro daw ya ibang sinarigan nagasonod siran kan Hisos pagpanaw. Kamhan ya isa nga sinarigan inkilalhan iza na labaw nga pari. Kamhan min-iba iza kan Hisos pagseled dizan ka pawa na lagkaw na labaw nga pari. ");
INSERT INTO mmn_vpl VALUES ("JN18_16","073_18_16","JHN","18","16","16","Minpabilin si Pidro logwa ka pirtahan. Kamhan ya isang sinarigan nga inkilalhan na labaw nga pari minbalik iza paglogwa. Kamhan dizan ka binolanan nga nagabantay ka pirtahan minbaid iza kay paselden kontana si Pidro. ");
INSERT INTO mmn_vpl VALUES ("JN18_17","073_18_17","JHN","18","17","17","Kamhan nangotana ya binolanan kan Pidro nga daw iko isab ya sakop naini nga tao nga indakep? Minsambag si Pidro nga diri, ey! ");
INSERT INTO mmn_vpl VALUES ("JN18_18","073_18_18","JHN","18","18","18","Kamhan ya mga sogoonon daw ya mga magbantazay namagharing siran ka pagpanarang kay matignaw gazed koman nga kahabzen. Pagtindeg niran dizan minpanarang si Pidro iba kaniran. ");
INSERT INTO mmn_vpl VALUES ("JN18_19","073_18_19","JHN","18","19","19","Kamhan si Hisos impangotana di iza na labaw nga pari mahitenged ka toong mga sinarigan daw ya toong pagsindo ka mga tao. ");
INSERT INTO mmn_vpl VALUES ("JN18_20","073_18_20","JHN","18","20","20","Minsambag si Hisos nga pagsindo nao ka mga tao diri hao ansindo dizan ka waray makakita kay dizan hao ka mga singbahan daw ya dakolang lagkaw nga pangamozoanan ka Diyos kay tiponanan iton na angay ta. ");
INSERT INTO mmn_vpl VALUES ("JN18_21","073_18_21","JHN","18","21","21","Kamhan diri ko magpangotana kanao kon ono ya pagsindo nao. Pangotanhen mo ya mga minpanalinga kanao kon ono ya ingkapanaba nao kaniran kay nakabati gazed siran. ");
INSERT INTO mmn_vpl VALUES ("JN18_22","073_18_22","JHN","18","22","22","Paglaong ni Hisos kaiza inlaparo iza na isang magbantazay. Kamhan imbaheg nga azaw ko magsambag ka labaw nga pari singed kaiton. ");
INSERT INTO mmn_vpl VALUES ("JN18_23","073_18_23","JHN","18","23","23","Minsambag si Hisos nga kon maonga pen ya inkapanaba nao ka pari ipanan-og mo dazon dini ka mga tao. Piro kon matood ya impanaba nao ono sang inlaparo sa mo hao? ");
INSERT INTO mmn_vpl VALUES ("JN18_24","073_18_24","JHN","18","24","24","Kamhan inpagapos ni Anas si Hisos daw impaated ngaro kan Kayapas nga labaw nga pari. ");
INSERT INTO mmn_vpl VALUES ("JN18_25","073_18_25","JHN","18","25","25","Kamhan si Simon Pidro nagapanarang pen iza pagtindeg dizan ka pawa. Kamhan inlong-an iza nga daw iko isab ya sakop naiton nga tao? Kamhan minlimed si Pidro nga diri, ey! ");
INSERT INTO mmn_vpl VALUES ("JN18_26","073_18_26","JHN","18","26","26","Kamhan inlong-an iza na isang oripen na labaw nga pari nga lomon na oripen nga inkaw-an ni Pidro ka talinga. Kamhan minlaong iza kan Pidro nga iko gazed ya nakitan o iba kan Hisos doro ka intamnan ka mga liwaan. ");
INSERT INTO mmn_vpl VALUES ("JN18_27","073_18_27","JHN","18","27","27","Kamhan minlimed gazed si Pidro pag-isab nga diri, ey! Kamhan mintagaok dazon ya manok. ");
INSERT INTO mmn_vpl VALUES ("JN18_28","073_18_28","JHN","18","28","28","Pagkamasiselem ka in-ated niran si Hisos garing kanin Kayapas ngaro ka kolanganan na mga soldaw dalem ka dakolang lagkaw ni Pilato nga gobirnador nga Romanhon. Kamhan ya mga min-ated kanangiza oloolo siran na mga Yodayo. Kamhan diri siran anseled kaiton nga lagkaw kay ya batasan niran ya pagseled na Yodayo ka lagkaw na tao nga diri kon Yodayo ani ya makaonga koni ka Yodayo. Kamhan kon anseled siran diri siran makapamista iba ka angay niran nga Yodayo. ");
INSERT INTO mmn_vpl VALUES ("JN18_29","073_18_29","JHN","18","29","29","Kamhan minlogwa si Pilato pagsogat kaniran kay nangotana iza daw ono say ikasombong mazo mahitenged kaiton nga tao? ");
INSERT INTO mmn_vpl VALUES ("JN18_30","073_18_30","JHN","18","30","30","Minsambag siran nga kon diri kon maonga ya toong batasan diri gazed nami ipadateng iza ka pagsombong dini kanmo. ");
INSERT INTO mmn_vpl VALUES ("JN18_31","073_18_31","JHN","18","31","31","Minsambag si Pilato nga kon may sala naiza dizan kamazo iated dizan ka mga oloolo mazo nga Yodayo kay siran ya anhokom kay may mga balaed sa mazo. Minsambag siran nga diri kami makabeetbeet ka paghokom ka pagpatay ka tao kay makalapas kami ka balaed mazo nga taga Roma nga labaw kanami. ");
INSERT INTO mmn_vpl VALUES ("JN18_32","073_18_32","JHN","18","32","32","Ani ini ya impanaba na mga Yodayo kamhan natoman ya mga panaba ni Hisos kay ya pagpatay ka tao ka kros batasan iton na mga Romanhon, diri kon batasan na mga Yodayo. ");
INSERT INTO mmn_vpl VALUES ("JN18_33","073_18_33","JHN","18","33","33","Pagkakamhan kaiza minbalik si Pilato pagseled ka toong lagkaw. Kamhan impaseled si Hisos kay nangotana nga matod, ey, iko ya hari na mga Yodayo? ");
INSERT INTO mmn_vpl VALUES ("JN18_34","073_18_34","JHN","18","34","34","Minsambag si Hisos nga ini nga pangotana mo kanao daw garing iton ka kanmong kaogaringeng hena-hena kon napanan-ogan di ko hinoa na mga tao? ");
INSERT INTO mmn_vpl VALUES ("JN18_35","073_18_35","JHN","18","35","35","Minsambag si Pilato nga diri kon Yodayo hao. Anika say min-ated kanmo ngarini kanao ya mga oloolo na kanmong kaibahan nga Yodayo. Daw ono sa ya kanmong inhinang nga maonga? ");
INSERT INTO mmn_vpl VALUES ("JN18_36","073_18_36","JHN","18","36","36","Minsambag si Hisos nga ya batasan nao diri kon singed ka hari dini ka kalibotan. Kay kon singed hao kaiza pagaawazen gazed na kanaong mga sogoonon kay dazaw diri hao madakpan na mga oloolo na mga Yodayo. Lain gazed ya kanaong batasan ka batasan na hari dini ka kalibotan. ");
INSERT INTO mmn_vpl VALUES ("JN18_37","073_18_37","JHN","18","37","37","Minsambag si Pilato nga agon hari iko matood. Minsambag si Hisos nga iko ya minlaong nga hari hao. Ya pagpanan-og ka matood ani ya tood nao ka pagpakatao daw pagkarini ka kalibotan. Kamhan ya tao nga an-angay ka matood ampanalinga iza kanao. ");
INSERT INTO mmn_vpl VALUES ("JN18_38","073_18_38","JHN","18","38","38","Minsambag si Pilato nga ya matood daw ono sa ya kahologan naiton? Kamhan minlogwa si Pilato pag-isab kay anpakahagdam iza ka mga Yodayo nagalaong nga diri nao silotan iton nga tao kay waray sala naiza. ");
INSERT INTO mmn_vpl VALUES ("JN18_39","073_18_39","JHN","18","39","39","May batasan mazo koni nga kada toig pagdateng na kamazong pista nga mangihaw ka mga nati na karniro palogwaen mazo ya isang piniriso nga mapilian mazo. Daw gosto mazo palogwaen nao ya hari na mga Yodayo? ");
INSERT INTO mmn_vpl VALUES ("JN18_40","073_18_40","JHN","18","40","40","Kamhan namagdengan ya mga Yodayo pagsinggit pag-isab nga diri kon si Hisos palogwaen kay si Barabas hinoa! Na, si Barabas mangazaw iza. ");
INSERT INTO mmn_vpl VALUES ("JN19_1","073_19_1","JHN","19","1","1","Pagkakamhan kaiza impanlatos ni Pilato si Hisos. ");
INSERT INTO mmn_vpl VALUES ("JN19_2","073_19_2","JHN","19","2","2","Kamhan inlokong na mga soldaw ya balala nga mga dogihen kay inhinang niran ka korona. Kamhan insokbot niran dizan ka olo ni Hisos. Kamhan impabadoan iza ka mararag nga bado ");
INSERT INTO mmn_vpl VALUES ("JN19_3","073_19_3","JHN","19","3","3","kay nagapakahinang ka hari. Kamhan nagasorasora siran pagsaza nagalaong nga tinahod ong hari na mga Yodayo! Kamhan indagpi niran. ");
INSERT INTO mmn_vpl VALUES ("JN19_4","073_19_4","JHN","19","4","4","Pagkakamhan kaiza minlogwa si Pilato pag-isab kay anlaong iza ka mga Yodayo nga manalinga kamo. Palogwaen nao ini nga tao ngarini kamazo kay dazaw mahagdam kamo nga waray nasaksihan o nga sala naiza. ");
INSERT INTO mmn_vpl VALUES ("JN19_5","073_19_5","JHN","19","5","5","Kamhan impalogwa di si Hisos nga pinasokbotan na korona nga dogihen. Binadoan isab iza ka mararag nga bado. Kamhan minlaong si Pilato ka mga Yodayo nga wani di ya tao! ");
INSERT INTO mmn_vpl VALUES ("JN19_6","073_19_6","JHN","19","6","6","Pagpakakita ka na mga oloolo nga pari daw ya mga magbantazay kan Hisos naninggit siran nga ilansang di iton ka kros! Kamhan ya pagkasamok niran nakadaeg ka mga panaba ni Pilato. Agon minsambag iza kaniran nga kamazo ka lamang kay waray labet nao kaiton nga tao nga waray sala. ");
INSERT INTO mmn_vpl VALUES ("JN19_7","073_19_7","JHN","19","7","7","Minsambag ya mga Yodayo nga minlapas gazed iza ka kanaming balaed nga ya tao nga magapakahinang nga iza ya Maanak na Diyos patazen iza. ");
INSERT INTO mmn_vpl VALUES ("JN19_8","073_19_8","JHN","19","8","8","Pagpakabati ka ni Pilato ka kanirang paglaong nga si Hisos ya Maanak na Diyos masara ya toong pagkahaldek. ");
INSERT INTO mmn_vpl VALUES ("JN19_9","073_19_9","JHN","19","9","9","Kamhan minbalik iza pagseled ka palasiyo. Kamhan nangotana iza kan Hisos nga daw hain sa ko garing? Kamhan wara gazed si Hisos magsambag. ");
INSERT INTO mmn_vpl VALUES ("JN19_10","073_19_10","JHN","19","10","10","Minlaong si Pilato nga magtahod ko kanao pagsambag. Daw diri sa ko mahagdam nga hao ya ambeet kon bohian ko kon ipalansang ko ka kros? ");
INSERT INTO mmn_vpl VALUES ("JN19_11","073_19_11","JHN","19","11","11","Minsambag si Hisos nga waray pagbeet mo kanao kon wara ko tagi na Diyos ka gahem. Agon siran nga min-ated kanao ngarini kanmo dakola ya sala niran ka kanmong sala. ");
INSERT INTO mmn_vpl VALUES ("JN19_12","073_19_12","JHN","19","12","12","Pagpakabati ka ni Pilato ka sambag ni Hisos pabohian kontana naiza piro naninggit ya mga Yodayo bali ka logwa nga kon pabohian mo ini nga tao diri kon iko ya higara ni Sisar nga hari nga Romanhon kay bisan sin-o ya magpakahari iza gazed ya kaaway ni Sisar. ");
INSERT INTO mmn_vpl VALUES ("JN19_13","073_19_13","JHN","19","13","13","Pagpakabati ni Pilato ka mga panaba niran impalogwa naiza si Hisos ngambali ka hokmanan. Kamhan minlo-to si Pilato dizan ka hokmanan. Ini nga hokmanan inngaranan ka Salog nga Siniminto. Kamhan ya saba nga Hinibriyo ka hokmanan ani Gabata. ");
INSERT INTO mmn_vpl VALUES ("JN19_14","073_19_14","JHN","19","14","14","Dispiras di wani na pistahanan nga mangihaw ya mga Yodayo ka mga nati na karniro. Ka hapit di mag-edto minlaong si Pilato ka mga Yodayo nga wani di ya kamazong hari. ");
INSERT INTO mmn_vpl VALUES ("JN19_15","073_19_15","JHN","19","15","15","Kamhan naninggit siran pagsambag nga patazen iza! Patazen! Ipalansang di iton ka kros! Nangotana si Pilato nga daw gosto mazo ipalansang nao ka kros ya kamazong hari? Minsambag ya mga oloolo nga pari nagalaong nga diri kon iza ya hari nami kay si Sisar anikay hari nami. ");
INSERT INTO mmn_vpl VALUES ("JN19_16","073_19_16","JHN","19","16","16","Kamhan inhatag ni Pilato si Hisos kaniran dazaw ilansang ka kros. ");
INSERT INTO mmn_vpl VALUES ("JN19_17","073_19_17","JHN","19","17","17","Ka nagabathay iza ka kros in-ated niran iza ngaro ka gawas na siyodad ngaro ka may dapit nga inngaranan ka Dapit ka Kalabira kay ani ya dapit ka pagpatay niran ka tao nga impahamtangan ka kamatazen. Na, ya saba nga Hinibriyo kaini nga dapit ani Golgota. ");
INSERT INTO mmn_vpl VALUES ("JN19_18","073_19_18","JHN","19","18","18","Doro niran inlansang ka kros. Iba disab ya dowang ka tao. Ya isa dizan ka kilid ni Hisos dapit ka toong too, ya isa dapit ka toong wala. ");
INSERT INTO mmn_vpl VALUES ("JN19_19","073_19_19","JHN","19","19","19","Insoyat disab ni Pilato ya timaan kay tapilen iton dizan ka kros. Ya toong sinoyat ani ini nga si Hisos nga taga Nazarit ini nga hari na mga Yodayo. ");
INSERT INTO mmn_vpl VALUES ("JN19_20","073_19_20","JHN","19","20","20","Mataed ya mga Yodayo nga nakabasa kaiton nga tinapil kay ya dapit nga inlansangan kan Hisos diri kon aro iton ka siyodad nga Hirosalem. Kamhan tolong ka kalasi nga saba ya sinoyat nga intapil nga Hinibriyo daw Linatin daw Ginirika. ");
INSERT INTO mmn_vpl VALUES ("JN19_21","073_19_21","JHN","19","21","21","Kamhan ya mga oloolo nga pari minlaong siran kan Pilato nga diri mo pagsoyat nga ani ini ya hari na mga Yodayo. Ilisan mo hinoa nga ini nga tao iza ya minpanaba nga iza ya hari na mga Yodayo. ");
INSERT INTO mmn_vpl VALUES ("JN19_22","073_19_22","JHN","19","22","22","Minsambag si Pilato nga ya inkasoyat di nao diri di nao ilisan. ");
INSERT INTO mmn_vpl VALUES ("JN19_23","073_19_23","JHN","19","23","23","Pagkakamhan na mga soldaw paglansang kan Hisos ka kros inkawa niran ya toong mga bado. Kamhan imbahin niran ka opat nga ka bolos kay dazaw nagatagsatagsa siran ka bado. Kamhan may isa peng nga bado naiza nga waray sinompazan kay ingaring dindaked ya paghinang lapos ka paa. ");
INSERT INTO mmn_vpl VALUES ("JN19_24","073_19_24","JHN","19","24","24","Kamhan namaglaonglaong siran nga diri nita gisien ini nga bado ka pagbahin. Magriparipa hinoa kita kon sin-o ya makatag-iza. Ani ini ya hinang niran dazaw matoman ya daan pinasoyat na Diyos mahitenged kan Hisos nga nagalaong nga imbahinbahin niran ya kanaong mga bado. Inriparipahan sab niran ya isang bado nao. Kamhan nakatoman gazed siran kaiton. ");
INSERT INTO mmn_vpl VALUES ("JN19_25","073_19_25","JHN","19","25","25","Kamhan dizan ka inlansangan ni Hisos mintindeg ya toong ina daw ya isang lomon na toong ina daw si Mariya nga asawa ni Kolopasa daw si Mariya nga taga Magdala. ");
INSERT INTO mmn_vpl VALUES ("JN19_26","073_19_26","JHN","19","26","26","Pagpakakita ka ni Hisos ka toong ina daw ya isang sinarigan nga toong naazakan nga mintindeg dizan ka saing na ina minlaong iza nga Ina, iza nga dizan ka kanmong sain ani di ya kanmong maanak. ");
INSERT INTO mmn_vpl VALUES ("JN19_27","073_19_27","JHN","19","27","27","Kamhan minlaong disab si Hisos ka toong sinarigan nga ina di mo koman iza. Kamhan sokad kaiza impahela di si Mariya doro ka lagkaw naiton nga sinarigan kay aligarahen. ");
INSERT INTO mmn_vpl VALUES ("JN19_28","073_19_28","JHN","19","28","28","Pagkakaan kaiza mahagdam si Hisos nga ya tanan insogo na toong Ama intoman di naiza. Agon nakapanaba di iza nga in-ohaw di hao. Ani ini ya toong inlaong dazaw matoman ya daan pinasoyat na Diyos mahitenged ka toong kaazi. ");
INSERT INTO mmn_vpl VALUES ("JN19_29","073_19_29","JHN","19","29","29","Kamhan may isang ka kaldohan dizan nga pono ka sokà. Kamhan minkawa ya soldaw ka sizepanan kay heeman iton ka len-anan ka sokà daw tegseben dizan ka liwaan dazaw idohol ka ba-ba ni Hisos. ");
INSERT INTO mmn_vpl VALUES ("JN19_30","073_19_30","JHN","19","30","30","Pagkakamhan ni Hisos pagtilaw minlaong iza nga intoman di nao ya tanan insogo ni Ama. Kamhan mindongo iza. Kamhan insarig di naiza ya toong hinawa ka pagkabogto di. ");
INSERT INTO mmn_vpl VALUES ("JN19_31","073_19_31","JHN","19","31","31","Na, konsilem ani aldaw ka pagpahimlay na mga Yodayo agon koman nga delem nagaandam siran. Kamhan ya mga Yodayo minhangzo siran kan Pilato nga nagalaong nga kon mahimo pamarien di ya bitiis na mga imamatzen nga inlansang ka mga kros dazaw madali siran mapatay kay kaw-en sa nami ya lawas niran dazaw diri di mabitay kay mahal gazed konsilem nga aldaw nga tigpahimlay daw nakadengan ka pista. ");
INSERT INTO mmn_vpl VALUES ("JN19_32","073_19_32","JHN","19","32","32","Kamhan nangaro ya mga soldaw ka dapit ka mga inlansangan. Impamarian di niran ya bitiis na dowang ka tao nga inlansangan ka kros iba kan Hisos. ");
INSERT INTO mmn_vpl VALUES ("JN19_33","073_19_33","JHN","19","33","33","Pagdateng di niran kan Hisos nakapaniid di siran nga patay di iza. Kamhan wara niran pamarii ya toong mga bitiis. ");
INSERT INTO mmn_vpl VALUES ("JN19_34","073_19_34","JHN","19","34","34","Kamhan ya kilid ni Hisos indosag dazon na isang soldaw ka toong bangkaw. Kamhan min-awas dazon ya dogo daw sapa. ");
INSERT INTO mmn_vpl VALUES ("JN19_35","073_19_35","JHN","19","35","35","Na, ya minseleng ani ya minpanan-og mahitenged kaiton nga tanan. Kamhan matood ya toong pagpanan-og. Mahagdam iza nga polos matood ya toong mga panaba dazaw manoo disab kamo. ");
INSERT INTO mmn_vpl VALUES ("JN19_36","073_19_36","JHN","19","36","36","Kay ini nga kaazi ni Hisos ani nakatoman ka daan pinasoyat na Diyos nagalaong nga wara mabarii ya toong bekeg bisan isa. ");
INSERT INTO mmn_vpl VALUES ("JN19_37","073_19_37","JHN","19","37","37","Nakatoman isab ya ibang daan pinasoyat na Diyos nagalaong nga anseleng ya mga tao kanangiza nga kanirang indosag. ");
INSERT INTO mmn_vpl VALUES ("JN19_38","073_19_38","JHN","19","38","38","Pagkakaan kaiza si Hosi minkaro iza kan Pilato. Taga Arimatiya si Hosi. Sakop iza ni Hisos kamhan mintago iza ka toong pagpasakop kay nahaldek iza ka mga Yodayo. Kamhan iza ya minbaid kan Pilato ka pagkawa ka lawas ni Hisos kay ilebeng. Kamhan mintogot si Pilato agon impakawa ni Hosi iton. ");
INSERT INTO mmn_vpl VALUES ("JN19_39","073_19_39","JHN","19","39","39","Kamhan si Nikodimo nga izang bisita kan Hisos ka mahon-a pen ka kahabzen, iza koman ya minkarini daw mindara ka mga kalim-an nga ka kilo nga pahamot sinaketan ka mira daw alosa nga polos mahamot. ");
INSERT INTO mmn_vpl VALUES ("JN19_40","073_19_40","JHN","19","40","40","Kamhan inkawa nirang dowa ya lawas ni Hisos. Kamhan inkomotan iton ka mga bag-ong panapton nga mapoti iba ya mga mahamot kay ani ya batasan na mga Yodayo ka pag-andam ka namola ka paglebeng. ");
INSERT INTO mmn_vpl VALUES ("JN19_41","073_19_41","JHN","19","41","41","Na, dizan ka dapit ka inlansangan kan Hisos may isang tamnanan. Kamhan dizan ka tenga na tamnanan may bag-ong hininang nga talangban nga lebnganan nga wara pen gazed kalebngi. ");
INSERT INTO mmn_vpl VALUES ("JN19_42","073_19_42","JHN","19","42","42","Kamhan inlebeng niran si Hisos dizan kay kinahanglan ilebeng dazon kay aldaw iton ka pag-andam na mga Yodayo ka kanirang tigpahimlay daw nakadengan ka kanirang pista. ");
INSERT INTO mmn_vpl VALUES ("JN20_1","073_20_1","JHN","20","1","1","Na, pagkamaaldawen ka ka Dominggo si Mariya nga taga Magdala minsazo iza pagdateng ka talangban nga inlebngan kan Hisos. Kamhan nakakita iza nga nakawa di ya bato garing ka pirtahan na lebnganan. ");
INSERT INTO mmn_vpl VALUES ("JN20_2","073_20_2","JHN","20","2","2","Kamhan mindalagan iza ngaro kan Simon Pidro daw ya isang sinarigan nga naazakan ni Hisos. Kamhan minlaong iza kaniran nga inkawat di ya lawas na Ginoo dizan ka lebnganan. Wara kami mahagdam kon hain di waro ibetang. ");
INSERT INTO mmn_vpl VALUES ("JN20_3","073_20_3","JHN","20","3","3","Kamhan si Pidro daw ya isang sinarigan minpanaw siran ngaro ka lebnganan. ");
INSERT INTO mmn_vpl VALUES ("JN20_4","073_20_4","JHN","20","4","4","Pagdalagan nirang dowa ngaro mindateng ya isang sinarigan kan Pidro paghon-a kay mabaskeg iza pagdalagan. ");
INSERT INTO mmn_vpl VALUES ("JN20_5","073_20_5","JHN","20","5","5","Kamhan minpongko iza ka pag-irab dalem ka lebnganan piro wara di magseled. Kamhan nakitan matood naiza ya mga panapton nga mapoti nga impotos ka lawas ni Hisos kay anikay nabilin dalem. ");
INSERT INTO mmn_vpl VALUES ("JN20_6","073_20_6","JHN","20","6","6","Pagdateng ni Simon Pidro sonod kanangiza minlargo iza pagseled ka lebnganan. Kamhan nakitan disab naiza ya mga panapton nga mapoti ");
INSERT INTO mmn_vpl VALUES ("JN20_7","073_20_7","JHN","20","7","7","daw ya panyo nga impotos ka olo ni Hisos. Napilo di ya panyo dizan nahilain ka mga panapton. ");
INSERT INTO mmn_vpl VALUES ("JN20_8","073_20_8","JHN","20","8","8","Kamhan ya isang sinarigan nga nakahon-a pagdateng minseled disab iza ngandalem ka linebngan. Pagpakakita ka naiza ka mga potos ka lawas ni Hisos nga nangabilin mintoo gazed iza nga nabohi di si Hisos pagbalik garing ka lebeng. ");
INSERT INTO mmn_vpl VALUES ("JN20_9","073_20_9","JHN","20","9","9","Kay wara pen siran makasabot pagdazaw ka daan pinasoyat na Diyos mahitenged kan Hisos nagalaong nga kinahanglan mabohi iza pagbalik garing ka lebeng. ");
INSERT INTO mmn_vpl VALUES ("JN20_10","073_20_10","JHN","20","10","10","Pagkakamhan nirang dowa pagseleng nagatagsatagsa di siran pag-oli ka lagkaw. ");
INSERT INTO mmn_vpl VALUES ("JN20_11","073_20_11","JHN","20","11","11","Kamhan si Mariya mintindeg pen iza dizan ka logwa na lebnganan. Pagpahihaza pen naiza minpongko iza ka pag-irab dalem ka lebnganan. ");
INSERT INTO mmn_vpl VALUES ("JN20_12","073_20_12","JHN","20","12","12","Kamhan nakitan naiza ya dowang ka tao nga sinogo nga garing ka Diyos. Mapoti ya kanirang bado. Minlo-to siran dizan ka binatengan na lawas ni Hisos. Ya isa dapit ka toong olo. Ya isa dapit ka toong paa. ");
INSERT INTO mmn_vpl VALUES ("JN20_13","073_20_13","JHN","20","13","13","Kamhan nangotana siran kan Mariya nga Day, kay ono sa nga nagapahihaza sa ko? Minsambag iza nga kay inkawat niran ya kanaong Ginoo. Kamhan wara hao mahagdam kon hain di waro ibetang. ");
INSERT INTO mmn_vpl VALUES ("JN20_14","073_20_14","JHN","20","14","14","Paglingi naiza nakakita iza kan Hisos nga nagatindeg dizan piro wara si Mariya makakilala nga ani iton si Hisos. ");
INSERT INTO mmn_vpl VALUES ("JN20_15","073_20_15","JHN","20","15","15","Nangotana si Hisos kanangiza nga Day, kay ono sa nga nagapahihaza sa ko? Daw sin-o ya impangita mo? Na, ya hena-hena ni Mariya saop iza dini ka tamnanan agon minsambag iza nga Nong, kon minbalhin ko ka lawas ni Hisos itoldo mo kanao kon hain mo iza ibetang kay kaw-en nao iza. ");
INSERT INTO mmn_vpl VALUES ("JN20_16","073_20_16","JHN","20","16","16","Minsambag si Hisos nga Mariya! Na, pagpakabati ka ni Mariya ka pagsabi na tao minlingi iza pag-isab daw minsambag ka saba nga Hinibriyo nga Raboni! Na, ya kahologan na panaba nga Raboni ani Maistro. ");
INSERT INTO mmn_vpl VALUES ("JN20_17","073_20_17","JHN","20","17","17","Kamhan minlaong si Hisos nga azaw hao paghawidi kay wara pen hao makakandaked ka Ama nao pagbalik. Karohon di mo hinoa ya kanaong mga sakop. Panan-ogan mo siran nga ankandaked hao ka kanaong Ama daw kamazong Ama. Anisab ya kanaong Diyos daw ya kamazong Diyos. ");
INSERT INTO mmn_vpl VALUES ("JN20_18","073_20_18","JHN","20","18","18","Kamhan minkaro dazon si Mariya nga taga Magdala ka mga sinarigan ni Hisos. Minlaong iza kaniran nga nakakita hao ka Ginoo. Kamhan impanan-og ni Mariya kaniran ya tanang inlaong ni Hisos kanangiza. ");
INSERT INTO mmn_vpl VALUES ("JN20_19","073_20_19","JHN","20","19","19","Na, pagkadelem ka aldaw nga Dominggo ya mga sinarigan ni Hisos namagtipon siran dalem ka lagkaw nga siniradohan kay nagapangahaldek siran ka mga oloolo na mga Yodayo. Kamhan minkarini si Hisos tenged kanirang tanan. Kamhan minlaong iza kaniran nga palinawen ya kamazong hinawa. ");
INSERT INTO mmn_vpl VALUES ("JN20_20","073_20_20","JHN","20","20","20","Pagkakamhan naiza pagpanaba impakita naiza kaniran ya toong mga alima daw ya isang lozo nga kilid na lawas kay ani ya pagpamatood kaniran nga iza si Hisos. Pagpakakilala niran nga iza matood ya kanirang Ginoo dakola ya pagsaza niran. ");
INSERT INTO mmn_vpl VALUES ("JN20_21","073_20_21","JHN","20","21","21","Kamhan minlaong iza kaniran pag-isab nga palinawen ya kamazong hinawa. Hao ya inpakarimbaba na Ama dini ka kalibotan. Kamhan pakarohon sab nao kamo ka mga tao. ");
INSERT INTO mmn_vpl VALUES ("JN20_22","073_20_22","JHN","20","22","22","Pagkakamhan naiza pagpanaba minhimoswak iza kaniran daw minlaong nga dini kamazo paharien mazo ya Madazaw nga Ispirito nga garing ka Diyos. ");
INSERT INTO mmn_vpl VALUES ("JN20_23","073_20_23","JHN","20","23","23","Sokad koman kon pasaylohon mazo ya mga sala na bisan sin-o nga tao impasaylo di iza. Kamhan kon diri mazo iza pasaylohon, diri isab iza mapasaylo. ");
INSERT INTO mmn_vpl VALUES ("JN20_24","073_20_24","JHN","20","24","24","Kamhan dizan ka mga napolo may dowa nga ka sinarigan si Tomas nga indagnazan kan Kaloha wara iza mag-iba kaniran ka pagdateng ni Hisos. ");
INSERT INTO mmn_vpl VALUES ("JN20_25","073_20_25","JHN","20","25","25","Agon impanan-ogan iza na mga sinarigan nga nakitan nami ya Ginoo! Minsambag si Tomas nga diri hao antoo. Kinahanglan ankita hao ka in-azihan na lansang dizan ka toong mga alima. Kinahanglan anhogam sab hao ka samad dizan ka isang lozo nga kilid na toong lawas anipen hao makatoo nga nabohi di iza. ");
INSERT INTO mmn_vpl VALUES ("JN20_26","073_20_26","JHN","20","26","26","Na, pagdateng ka ikawalo nga aldaw dizan ka lagkaw mintipon disab ya mga sinarigan iba disab si Tomas. Bisan kon sirado ya lagkaw minkarini si Hisos tenged kaniran. Kamhan minlaong iza nga palinawen ya kamazong hinawa. ");
INSERT INTO mmn_vpl VALUES ("JN20_27","073_20_27","JHN","20","27","27","Kamhan minlaong iza nga Tomas, paka selengi ya palad na kanaong alima. Maghogam ko naa kaini daw ya samad dini ka isang lozo na lawas. Diri ko magdowadowa. Magtoo ko hinoa nga hao matood ini nga si Hisos. ");
INSERT INTO mmn_vpl VALUES ("JN20_28","073_20_28","JHN","20","28","28","Minsambag si Tomas nga iko gazed ya kanaong Ginoo daw ya kanaong Diyos! ");
INSERT INTO mmn_vpl VALUES ("JN20_29","073_20_29","JHN","20","29","29","Minsambag si Hisos nga mintoo ko kanao kay nakakita di ko kanao. Madazaw pen ya tao nga mintoo kanao bisan wara iza makakita kanao. ");
INSERT INTO mmn_vpl VALUES ("JN20_30","073_20_30","JHN","20","30","30","Kamhan dizan ka pagseleng na toong mga sinarigan mataed pen ya mga inhinang ni Hisos nga wara hao magsoyat dini ka basahen. ");
INSERT INTO mmn_vpl VALUES ("JN20_31","073_20_31","JHN","20","31","31","Kamhan insoyat nao ini kay dazaw antoo kamo nga si Hisos iza matood si Kristo nga Maanak na Diyos. Kamhan ya pagtoo mazo kanangiza ani anhatag kamazo ka bag-ong kinabohi nga diri mawara kay iza ya insakopan mazo. ");
INSERT INTO mmn_vpl VALUES ("JN21_1","073_21_1","JHN","21","1","1","Pagkadogaydogay kaiza dizan ka baybazen na dagat nga Tibiriyas minkadizan si Hisos pag-isab ka toong mga sinarigan. Na, ya toong pag-azi dizan kaniran singed kaini. ");
INSERT INTO mmn_vpl VALUES ("JN21_2","073_21_2","JHN","21","2","2","May isang aldaw si Simon Pidro daw si Tomas nga indagnazan kan Kaloha daw si Nataniyal nga taga Kana nga longsod doro ka Galiliya daw ya mga maanak ni Sibidiyo daw may mga dowa pen nga sinarigan namagtipon sirang tanan. ");
INSERT INTO mmn_vpl VALUES ("JN21_3","073_21_3","JHN","21","3","3","Kamhan minlaong si Simon Pidro kaniran nga ampangisda pen hao. Minsambag siran nga an-iba kami. Kamhan minleen siran ka baloto. Kamhan nangisda siran keteb ka pagkamasiselem piro wara gazed tarai ya kanirang lazà. ");
INSERT INTO mmn_vpl VALUES ("JN21_4","073_21_4","JHN","21","4","4","Pagpamawa-pawa di na masiselem si Hisos mintindeg iza dizan ka baybazen piro wara iza makilalhi na toong mga sinarigan. ");
INSERT INTO mmn_vpl VALUES ("JN21_5","073_21_5","JHN","21","5","5","Kamhan minlaong si Hisos kaniran nga kamo dakoza, daw may nakawa mazo nga isda? Minsambag siran nga wara gazed. ");
INSERT INTO mmn_vpl VALUES ("JN21_6","073_21_6","JHN","21","6","6","Minlaong si Hisos nga ipasidalem mazo ya kamazong lazà dapit ka too na baloto dazaw makakawa kamo. Pagpanagat niran pag-isab mataed matood ya isda kamhan wara madaeg ya lazà pagbetang dalem ka baloto. ");
INSERT INTO mmn_vpl VALUES ("JN21_7","073_21_7","JHN","21","7","7","Kamhan ya isang sinarigan nga naazakan ni Hisos minlaong iza kan Pidro nga ya kantang Ginoo iton dizan! Pagpakabati ka ni Simon Pidro nga ya Ginoo iton imbakes naiza ya isang lapid nga bado nga inkawa naiza kazina kay nangisda. Kamhan min-empag iza ka sapa. ");
INSERT INTO mmn_vpl VALUES ("JN21_8","073_21_8","JHN","21","8","8","Ya mga ibang sinarigan namagsakay pen siran ka baloto ngaro ka baybazen daw nagabira disab ka lazà nga napono ka isda. Diri kon aro siran ka baybazen kay hapit magkalim-an ka lamang nga ka depa ya kaaro. ");
INSERT INTO mmn_vpl VALUES ("JN21_9","073_21_9","JHN","21","9","9","Pagdateng niran ka baybazen nakitan niran ya hinaring nga mabaga nga may mga hinal-ob nga isda. Dizan disab ya mga binetang nga makaen. ");
INSERT INTO mmn_vpl VALUES ("JN21_10","073_21_10","JHN","21","10","10","Kamhan minlaong si Hisos kaniran nga dadhen mazo ngarini ya mga isda nga nakawa. ");
INSERT INTO mmn_vpl VALUES ("JN21_11","073_21_11","JHN","21","11","11","Kamhan minleen si Simon Pidro ka baloto. Mingozod iza ka lazà ngarini ka baybazen. Napono iton ka mga dakolang isda. Isang ka gatos may kalim-an daw tolong bolos ya tanan. Kamhan bisan masarang kataed ya kanirang makawa, wara gazed magisi ya lazà. ");
INSERT INTO mmn_vpl VALUES ("JN21_12","073_21_12","JHN","21","12","12","Kamhan minlaong si Hisos kaniran nga dali kamo ngarini kay mangaen di kamo. Kamhan dizan ka mga sinarigan waray isa nga nakagahem pagpangotana kanangiza kon sin-o sa iza kay mahagdam di sa siran nga iza ya kanirang Ginoo. ");
INSERT INTO mmn_vpl VALUES ("JN21_13","073_21_13","JHN","21","13","13","Dizan kaniran inkawa ni Hisos ya makaen kamhan impanhatag naiza kaniran iba disab ya isda. ");
INSERT INTO mmn_vpl VALUES ("JN21_14","073_21_14","JHN","21","14","14","Kamhan ya pagkarini ni Hisos ka toong mga sinarigan ikatlo di sokad ka pagkabohi naiza pagbalik garing ka lebeng. ");
INSERT INTO mmn_vpl VALUES ("JN21_15","073_21_15","JHN","21","15","15","Pagkakamhan niran pagpamahaw nangotana si Hisos kan Simon Pidro nga Simon nga maanak ni Howan, daw pagaazaken mo hao labaw pen ka kaazak na mga iba mo kanao? Minsambag si Pidro nga Oo Ginoo, mahagdam iko nga naazak hao kanmo. Minsambag si Hisos nga aligarahen mo ya mga bag-ong minsakop kanao singed ka pag-aligara na tao ka toong mga bohien nga nati na karniro. ");
INSERT INTO mmn_vpl VALUES ("JN21_16","073_21_16","JHN","21","16","16","Kamhan nangotana si Hisos kanangiza pag-isab nga Simon nga maanak ni Howan, daw maazak ko kanao? Minsambag si Pidro nga Oo Ginoo, mahagdam ko nga naazak hao kanmo. Minsambag si Hisos nga magsindo ko ka kanaong mga sakop singed ka pagdara na mag-aligrahay ka toong mga bohien nga karniro. ");
INSERT INTO mmn_vpl VALUES ("JN21_17","073_21_17","JHN","21","17","17","Kamhan ikatlo di ya pagpangotana ni Hisos kan Pidro nga nagalaong nga Simon nga maanak ni Howan, daw maazak ko kanao? Kamhan mabeg-at di ya hinawa ni Pidro kay ikatlo di pagpangotana ni Hisos kon azaken iza ni Pidro. Kamhan minsambag si Pidro nga Ginoo, mahagdam ko daan ka bisan ono ya kanaong hena-hena. Mahagdam ko nga naazak hao kanmo. Minsambag si Hisos nga aligarahen mo ya kanaong mga sakop singed ka pag-aligara na tao ka toong mga bohien nga karniro. ");
INSERT INTO mmn_vpl VALUES ("JN21_18","073_21_18","JHN","21","18","18","Pidro, sabten mo ini nga ka batan-en pen iko, iko ya nagabakes ka kanmong bado. Iko sab ya minbeet kon angkar-in ko pagsinged ka pagpanaw mo. Piro kay-an ka pagkamalaas di mo madepa ya kanmong mga alima. Kamhan ektan iko na mga lain tao. Kamhan dadhen ko ngaro ka dapit nga diri mo kontana karohon. ");
INSERT INTO mmn_vpl VALUES ("JN21_19","073_21_19","JHN","21","19","19","Ani ini ya impanaba ni Hisos mahitenged ka pagkapatay ni Pidro ka kros kay sazaen ni Pidro ya Diyos pagtoman naiza ka naazakan na Diyos kay-an. Pagpanaba ni Hisos kaiton minlaong pen iza kan Pidro nga diri ko magheneng pagtoman ka kanaong naazakan. ");
INSERT INTO mmn_vpl VALUES ("JN21_20","073_21_20","JHN","21","20","20","Kamhan minlingi si Pidro daw nakitan naiza ya isang sinarigan nga naazakan ni Hisos nga minsonod di ngarini kaniran. Iton nga sinarigan ani ya saing kan Hisos izang dini kaini pagpanihapon nirang tanan daw nangotana nga Ginoo, daw sin-o wani ya an-edlaw kanmo? ");
INSERT INTO mmn_vpl VALUES ("JN21_21","073_21_21","JHN","21","21","21","Pagpakakita ka ni Pidro kanangiza nangotana iza kan Hisos nga Ginoo, daw ono ya kaazi na toong kamatazen? ");
INSERT INTO mmn_vpl VALUES ("JN21_22","073_21_22","JHN","21","22","22","Minsambag si Hisos nga waray labet mo kon amponto hao nga mabohi ka iza hangtod ka kanaong pagbalik kon diri. Magtoman ko hinoa ka kanaong naazakan! ");
INSERT INTO mmn_vpl VALUES ("JN21_23","073_21_23","JHN","21","23","23","Kamhan dizan ka mga sakop ni Hisos inpanan-ogan nga iton nga sinarigan diri iza mapatay. Piro wara si Hisos maglaong kan Pidro kaiton. Anikay saba naiza nga waray labet mo kon amponto hao nga mabohi ya sinarigan hangtod ka kanaong pagbalik kon diri. ");
INSERT INTO mmn_vpl VALUES ("JN21_24","073_21_24","JHN","21","24","24","Na, iton nga sinarigan nga naazakan ni Hisos ani hao nga si Howan. Hao ya minsaksi ka mga inhinang ni Hisos kamhan minsoyat hao. Kamhan mahagdam kita nga matood gazed ini nga sinoyat nao. ");
INSERT INTO mmn_vpl VALUES ("JN21_25","073_21_25","JHN","21","25","25","Kamhan mataed pen ya mga inhinang ni Hisos. Kon madogangan pen pagsoyat ka tanan diri an-igo ka tibolos kalibotan ya katiponan na mga basahen nga insoyat mahitenged ka mga inhinang ni Hisos.");
INSERT INTO mmn_vpl VALUES ("AC1_1","074_1_1","ACT","1","1","1","Kan Tiyopilo ini nga kanaong higara, Dizan ka mahon-ang soyat inpanan-og nao ya tanan mga hininang daw intoldo ni Hisos sokad ka pagsogod naiza ya toong hinang ");
INSERT INTO mmn_vpl VALUES ("AC1_2","074_1_2","ACT","1","2","2","keteb ka aldaw nga nabohat iza ngandaked ka langit. Na, ka wara pen iza bohata inpanoldoan naiza ya toong mga sinarigan ka togon nga garing ka Madazaw nga Ispirito na Diyos. Kamhan ya ngaran niran nga mga sinarigan ani ya apostolis nga inpili ni Hisos daan. ");
INSERT INTO mmn_vpl VALUES ("AC1_3","074_1_3","ACT","1","3","3","Sokad ka toong pagkabohi garing ka pagkapatay keteb ka kap-atan nga ka aldaw onay iza minkandizan kaniran. Mataed ya pagpamatood naiza kaniran nga nabohi gazed iza. Nakitan iza niran daw minpakiglaong iza kaniran nga iza matood ya hari nga pinili na Diyos nga intagadan niran. ");
INSERT INTO mmn_vpl VALUES ("AC1_4","074_1_4","ACT","1","4","4","Ka nagaibaiba pen iza kaniran minsogo iza kaniran nga nagalaong nga diri kamo magpanaw dini ka siyodad nga Hirosalem. Magtagad naa kamo kay domatengay di ya Madazaw nga Ispirito nga garing ka Diyos kay iza gazed ya insaad na Ama nao kamazo nga inpanan-og nao kamazo. ");
INSERT INTO mmn_vpl VALUES ("AC1_5","074_1_5","ACT","1","5","5","Namenzag si Howan ka mga tao ka sapa piro ka wara pen madogay benzagan kamo ka Madazaw nga Ispirito nga garing ka Diyos dazaw paharian kamo naiza nga Ispirito. Ani ini ya sogo ni Hisos ka toong mga apostolis. ");
INSERT INTO mmn_vpl VALUES ("AC1_6","074_1_6","ACT","1","6","6","Pagtipon na mga apostolis pag-isab nangotana siran kan Hisos nga Ginoo, matod koman nga panahona iko ya antabang kanami ka pagpaiwat ka mga taga Roma dini kanami dazaw kami ka ya anhari ka mga hel-anan nami. ");
INSERT INTO mmn_vpl VALUES ("AC1_7","074_1_7","ACT","1","7","7","Minsambag si Hisos nga ya Ama nao anikay magabeet ka pagsonodsonod na panahon hangtod ka paghatag di ka magahari dini kamazong tanan. Waray labet mazo ka pagpaiwat ka mga taga Roma dini kamazo kay ");
INSERT INTO mmn_vpl VALUES ("AC1_8","074_1_8","ACT","1","8","8","koman nga panahona ya Madazaw nga Ispirito nga garing ka Diyos ani ya andateng dini kamazo. Kamhan may gahem mazo ka pagpanan-og ka mga tao mahitenged ka mga inhinang nao nga insaksihan mazo. Ka primiro pen walihan mazo ya mga taga Hirosalem. Kamhan walihan mazo ya tanan mga taga Yoda daw ya mga taga Samariya daw doro pen ka bisan hain nga dapit dini ka tibolos kalibotan. ");
INSERT INTO mmn_vpl VALUES ("AC1_9","074_1_9","ACT","1","9","9","Pagkakamhan ni Hisos pagpanaba dizan ka pagseleng niran nabohat matood iza ngandaked ka langit. Pagpasalimed ka na inarak wara di niran makiti. ");
INSERT INTO mmn_vpl VALUES ("AC1_10","074_1_10","ACT","1","10","10","Ka nagaseleng pen siran ka langit ka kaazi ni Hisos waton di baza ya dowang ka amaama nga nagabado ka mapoti daw nagatindeg dizan tepad kaniran. ");
INSERT INTO mmn_vpl VALUES ("AC1_11","074_1_11","ACT","1","11","11","Kamhan nagalaong siran nga kamo nga mga taga Galiliya, igo di gazed ya paghangad mazo ka langit. Kay si Hisos nga nabohat ngandaked iza gazed ya ambalik pag-isab singed ka toong kaazi nga nakitan mazo koman. Ani ini ya pagpanaba nirang dowa ka mga sinarigan ni Hisos. ");
INSERT INTO mmn_vpl VALUES ("AC1_12","074_1_12","ACT","1","12","12","Kamhan namanaw ya mga sinarigan dizan ka bobong nga Olibo kay ambalik siran ka siyodad nga Hirosalem nga hapit mag-isang ka kilomitro ya kaaro. ");
INSERT INTO mmn_vpl VALUES ("AC1_13","074_1_13","ACT","1","13","13","Pagdateng niran ka Hirosalem minpanik siran dizan ka lagkaw nga may seled nga haloag ngandaked ka ikadowang saleg kay ani ya hel-anan nirang tanan nga si Pidro daw si Howan daw si Santiago daw si Andris daw si Pilipo daw si Tomas daw si Bartolomi daw si Matiyo daw si Santiago nga maanak ni Alpiyo daw si Simon nga masinopaken ka hari nga Romanhon daw si Hodas nga maanak na ibang tao nga si Santiago ya ngaran. ");
INSERT INTO mmn_vpl VALUES ("AC1_14","074_1_14","ACT","1","14","14","Sirang tanan daw ya mga babazi daw si Mariya nga ina ni Hisos daw ya mga lomon ni Hisos mintipon di ngandaked ka ikadowang saleg. Ya batasan niran onay siran magtipon kay namagtibe siran pagpangamozo ka Diyos. ");
INSERT INTO mmn_vpl VALUES ("AC1_15","074_1_15","ACT","1","15","15","May isang aldaw mintindeg si Pidro ka pagpanaba kaniran. Isang ka gatos may karohaan nga ka tao siran nga mga sakop ni Kristo. ");
INSERT INTO mmn_vpl VALUES ("AC1_16","074_1_16","ACT","1","16","16","Kamhan nagalaong si Pidro nga kanaong mga lomon kan Kristo, kawandini pen ya Madazaw nga Ispirito nga garing ka Diyos ani ya minpatandeg ka hinawa ni Dabid nga karaang hari dazaw ansoyat iza daan mahitenged ka izang tao nga manonood ka mga mindakep kan Hisos. Kamhan mintoman di gazed ya sinoyat mahitenged kan Hodas kay iza matood ya min-edlaw kan Hisos. ");
INSERT INTO mmn_vpl VALUES ("AC1_17","074_1_17","ACT","1","17","17","Izang dini kaini iza ya iba ta kay sinarigan isab iza nga napili ni Hisos singed kanta. ");
INSERT INTO mmn_vpl VALUES ("AC1_18","074_1_18","ACT","1","18","18","Paghinang naiza ka maonga indawat naiza ya kowarta nga inkabazad ka pagpatay kan Hisos. Kamhan minpalit iza ka oma. Kamhan dizan kaiton nga oma minpatiholog iza ka pagpakapatay. Minboto disab ya toong tinai kamhan horot gazed pag-awas ya toong kinaen. ");
INSERT INTO mmn_vpl VALUES ("AC1_19","074_1_19","ACT","1","19","19","Kamhan ya tanan mga taga Hirosalem mahagdam siran kon ono ya kamatazen ni Hodas. Agon inngaranan niran ya oma nga Akeldama. Na, ya kahologan na Akeldama ani ya omaha nga imbayran ka dogo na tao. ");
INSERT INTO mmn_vpl VALUES ("AC1_20","074_1_20","ACT","1","20","20","Kay dizan ka Salmo nga mga daan insoyat ni Dabid may mga panaba naiza mahitenged kan Hodas nga nagalaong nga ya hel-anan naitong tao inpamanawan gazed na mga tao. Kamhan diri gazed anhela ya mga tao dizan. Wani pen ya insoyat nga nagalaong nga madazaw kon may an-ilis ka toong katengdanan ka pagkasinarigan. Ani ini ya daan insoyat ni Dabid mahitenged kan Hodas. ");
INSERT INTO mmn_vpl VALUES ("AC1_21","074_1_21","ACT","1","21","22","Kamhan indogangan ni Pidro pagpanaba kaniran nga nagalaong nga dini kanta may mga tao nga min-ibaiba kanta doro ka bisan hain ya pagpanaw nita daw si Hisos sokad ka pagbenzag ni Howan ka mga tao hangtod ka nabohat si Hisos ngandaked ka langit. Kamhan dini kanta koman magpili naa kita ka sinarigan dazaw makaiba isab iza kanta ka pagpanan-og ka mga tao nga nabohi di si Hisos pagbalik garing ka lebeng. ");
INSERT INTO mmn_vpl VALUES ("AC1_23","074_1_23","ACT","1","23","23","Kamhan minpili siran ka dowang bolos nga tao nga si Hosi Hosto daw si Matiyas. Si Hosi inngaranan sab iza kan Barsabas. ");
INSERT INTO mmn_vpl VALUES ("AC1_24","074_1_24","ACT","1","24","24","Kamhan nangamozo siran ka Diyos nga nagalaong nga Ginoo, iko ya mahagdam kon ono ya hena-hena na tanan mga tao. Agon pakahagdamen mo kami kon sin-o ya kanmong pilien dini ka dowang ka tao ");
INSERT INTO mmn_vpl VALUES ("AC1_25","074_1_25","ACT","1","25","25","dazaw sinarigan ya isa na Diyos ilis kan Hodas kay imbizaan ni Hodas si Hisos. Kamhan waro di iza ka toong dapit baba ka impirno. Ani ini ya pagpangamozo niran ka Diyos. ");
INSERT INTO mmn_vpl VALUES ("AC1_26","074_1_26","ACT","1","26","26","Kamhan inhinang niran ya batasan niran nga namagriparipa kon sin-o ya makailis. Na, si Matiyas ani ya makailis. Kamhan iza ya bag-ong nakatibe dizan ka mga napolo may isa nga ka sinarigan inngaranan ka mga apostolis. ");
INSERT INTO mmn_vpl VALUES ("AC2_1","074_2_1","ACT","2","1","1","Pagdateng na aldaw ka izang pista na mga Yodayo inngaranan ka Pintikosta mintipon disab ya tanan mga sakop ni Hisos dizan ka lagkaw. ");
INSERT INTO mmn_vpl VALUES ("AC2_2","074_2_2","ACT","2","2","2","Kamhan nabatian niran ya masarang kabezeng garing daked ka langit singed ka kabezeng pagtoda na hangin nga makeseg. Kamhan minlekep iton ka tibolos lagkaw nga intiponan niran. ");
INSERT INTO mmn_vpl VALUES ("AC2_3","074_2_3","ACT","2","3","3","Kamhan nakakita siran ka kapawa singed ka kapawa na laga nga mingaring daked ka langit. Kamhan mindateng di ka kada poro na olo na tao. ");
INSERT INTO mmn_vpl VALUES ("AC2_4","074_2_4","ACT","2","4","4","Kamhan inharian sirang tanan na Madazaw nga Ispirito nga garing ka Diyos. Kamhan minsogod di siran pagpanaba ka mga nagakalainlain nga saba kay minpatandeg ya Ispirito ka kanirang hinawa ka pagpanaba ka mga diri kon kanirang kaogaringen nga saba. ");
INSERT INTO mmn_vpl VALUES ("AC2_5","074_2_5","ACT","2","5","5","Kamhan dizan ka siyodad nga Hirosalem may mga Yodayo nga madazaw ya pagpangalagad niran ka Diyos. Garing siran ka tanan mga dapit dini ka tibolos kalibotan. ");
INSERT INTO mmn_vpl VALUES ("AC2_6","074_2_6","ACT","2","6","6","Kamhan masara gazed nga kataed siran nga nandogok kay nakabati siran ka tagsa tagsa nga sinarigan ni Hisos nga nagapanaba di baza ka mga saba nga inkatao na mga tagsa tagsa nga mga nakabati. ");
INSERT INTO mmn_vpl VALUES ("AC2_7","074_2_7","ACT","2","7","7","Kamhan dakola ya pagkabereng na mga Yodayo nga nagalaong nga iton nga mga taohana daw diri kon polos taga Galiliya siran? ");
INSERT INTO mmn_vpl VALUES ("AC2_8","074_2_8","ACT","2","8","8","In-ono sa niran pagpanaba ka kantang tagsa tagsang mga saba? ");
INSERT INTO mmn_vpl VALUES ("AC2_9","074_2_9","ACT","2","9","9","Dini kanta may mga taga lopa nga Partya daw Midya daw Ilam daw Misopotamya daw Yoda daw Kapadosya daw Ponto daw Asya ");
INSERT INTO mmn_vpl VALUES ("AC2_10","074_2_10","ACT","2","10","10","daw Prigiya daw Panpilya daw Ihipto daw ya mga dapit doro ka Libya arani ka longsod nga Sirini. Dini sab kanta may mga bisita nga taga Roma. Mga Yodayo siran daw mga diri kon Yodayo nga minsakop di ka tinoohan na mga Yodayo. ");
INSERT INTO mmn_vpl VALUES ("AC2_11","074_2_11","ACT","2","11","11","May mga iba pen nga tao dini kanta nga mga taga Krita daw Arabya. Bisan taga doro kitang tanan nakabati kita kaniran nga nagapanaba ka kantang tagsa tagsa nga saba mahitenged ka mga madazaw nga inhinang na Diyos. ");
INSERT INTO mmn_vpl VALUES ("AC2_12","074_2_12","ACT","2","12","12","Kamhan nabereng sirang tanan daw nagakalibeg. Nangotana siran nga ono sa wani ya kahologan naiton? ");
INSERT INTO mmn_vpl VALUES ("AC2_13","074_2_13","ACT","2","13","13","Kamhan may mga iba nga tao nagapanora ka mga sinarigan nga nagalaong nga ah, mga hebeg ini nga mga tao! ");
INSERT INTO mmn_vpl VALUES ("AC2_14","074_2_14","ACT","2","14","14","Kamhan mintindeg si Pidro iba ya mga napolo may isa nga sinarigan. Kamhan mabaskeg ya toong saba pagpanaba nga nagalaong nga kanaong mga kaibahan nga Yodayo daw ya mga taga Hirosalem manalinga kamo ka kanaong ipanaba. ");
INSERT INTO mmn_vpl VALUES ("AC2_15","074_2_15","ACT","2","15","15","Diri kon mga hebeg iton mga tao kay ya batasan na mga mamistahay diri siran an-inem kon wara pen ataas ya sega ka aldaw na pista. ");
INSERT INTO mmn_vpl VALUES ("AC2_16","074_2_16","ACT","2","16","16","Lain ini kay nagapanaba di siran ka mga nagakalainlain nga saba kay ya Madazaw nga Ispirito nga garing ka Diyos ani ya minpatandeg ka kanirang hinawa ka pagpanaba ka mga diri kon kanirang saba. Kamhan mintoman di ya inlaong ni Zowil nga propita na Diyos kay kawandini pen nagalaong iza nga ");
INSERT INTO mmn_vpl VALUES ("AC2_17","074_2_17","ACT","2","17","17","wani ya sindo na Diyos nga kay-an ka pagkaarani ka na pagkatiwas na kalibotan dizan ka bisan sin-o nga taohana paharien naiza ya toong Ispirito nga Madazaw. Kamhan ya kamazong mga maanak amaama daw babazi anpasabot siran ka matood nga garing ka Diyos. Kamhan ya mga batan-en nga amaama may makitan niran nga garing ka Diyos. Kamhan ya mga malaas nga amaama patag-inepen siran na Ginoo. ");
INSERT INTO mmn_vpl VALUES ("AC2_18","074_2_18","ACT","2","18","18","Bisan ya mga oripen nga amaama daw babazi ihatag kaniran ya Madazaw nga Ispirito nga garing ka Diyos. Kamhan anpasabot siran ka matood nga garing ka Diyos. ");
INSERT INTO mmn_vpl VALUES ("AC2_19","074_2_19","ACT","2","19","19","Kamhan daked ka langit ipakita na Diyos ya mga kaberenganan. Dimbaba isab ka lopa ipakita na Diyos ya mga timaan nga iza gazed ya labaw ka gahem. Iba gihapon ya dogo daw ya laga daw ya aso nga singed ka dag-em. ");
INSERT INTO mmn_vpl VALUES ("AC2_20","074_2_20","ACT","2","20","20","Andeglem ya sega, anrarag ya bolan singed ka dogo. Kamhan andateng ya tirmino ni Hisos ka pagbalik ngarimbaba dazaw anhokom iza ka tanan mga tao kay iza ya labaw ka gahem. ");
INSERT INTO mmn_vpl VALUES ("AC2_21","074_2_21","ACT","2","21","21","Kamhan bisan sin-o ya ansangpit kan Hiso Kristo matabangan gazed iza. Ani ini ya daan inlaong ni Zowil nga propita na Diyos. ");
INSERT INTO mmn_vpl VALUES ("AC2_22","074_2_22","ACT","2","22","22","Kamhan indogangan ni Pidro pagsindo ka mga tao nga nagalaong nga mga kaibahan nao nga taga Israil, magpanalinga kamo! Dini kamazo inpahinang na Diyos kan Hisos nga taga Nazarit ya mga kaberenganan kay timaan iton nga iza ya inpakarimbaba na Diyos. Mahagdam kamo kaiza kay izang dini kaini nakitan mazo ya toong mga inhinang. ");
INSERT INTO mmn_vpl VALUES ("AC2_23","074_2_23","ACT","2","23","23","Kawandini pen mahagdam ya Diyos daw minbeet daan nga patazen mazo si Hisos. Kamhan kamo gazed ya minleges ka mga maonga nga tao dazaw ilansang si Hisos ka kros. ");
INSERT INTO mmn_vpl VALUES ("AC2_24","074_2_24","ACT","2","24","24","Kamhan minbohi ya Diyos kan Hisos pagbalik garing ka lebeng kay nakadaeg iza ka bisan ono nga makapakamola ka tao. ");
INSERT INTO mmn_vpl VALUES ("AC2_25","074_2_25","ACT","2","25","25","Na, ya pagbohi kan Hisos garing ka lebeng ani ya nakatoman ka insoyat ni Dabid nga karaang hari kay kawandini pen nagalaong iza mahitenged kan Hisos nga onay hao nakakita ka Diyos. Kamhan iza ya antabang kanao dazaw diri hao madaeg na mga maonga. ");
INSERT INTO mmn_vpl VALUES ("AC2_26","074_2_26","ACT","2","26","26","Agon malinaw gazed ya kanaong hinawa. Sazaen gazed nao ya Diyos. Waray kawied nao kay bisan mapatay hao diri iza ambilin ka kanaong lawas ka pagkalatà dalem ka lebeng. ");
INSERT INTO mmn_vpl VALUES ("AC2_27","074_2_27","ACT","2","27","27","Kay diri mo bizaan ya kanaong ispirito dalem ka lebeng. Diri mo itogot nga malatà ya kanaong lawas dalem ka lebnganan kay hao ya kanmong Maanak nga waray sala. ");
INSERT INTO mmn_vpl VALUES ("AC2_28","074_2_28","ACT","2","28","28","Minpakahagdam iko kanao ka dalan nga minpasinged ngaro ka datnganan nga madazaw. Dini iko iba kanao agon dakola gazed ya kanaong kasaza. ");
INSERT INTO mmn_vpl VALUES ("AC2_29","074_2_29","ACT","2","29","29","Ani ini ya daan insoyat ni Dabid mahitenged kan Hiso Kristo kay si Dabid nga apo na mga Yodayo wara gazed iza magsoyat mahitenged ka toong kaogaringeng lawas kay napatay di matood iza daw inlebeng. Kamhan dini pen kanta ya toong pantiyon. ");
INSERT INTO mmn_vpl VALUES ("AC2_30","074_2_30","ACT","2","30","30","Na, si Dabid ani ya karaang propita nga insaad na Diyos. Pagsaad na Diyos gosto naiza kon mahagdam si Dabid nga marig-en ya saad agon minngaran iza ka toong kaogaringeng ngaran kay iza ya Diyos. Kamhan marig-en ya saad nga nagalaong nga tagan ya isang kaliwat ni Dabid ka lo-toanan ni Dabid ka paghari ka mga tao. ");
INSERT INTO mmn_vpl VALUES ("AC2_31","074_2_31","ACT","2","31","31","Kamhan mahagdam si Dabid daan kon ono ya hinangen na Diyos agon minpanan-og iza daan mahitenged ka pagbohi ni Kristo pagbalik garing ka lebeng nga nagalaong nga diri mabiza iza baba ka lebeng. Diri sab malatà ya toong lawas. Ani ini ya daan inlaong ni Dabid mahitenged ka pagbohi ni Hiso Kristo pagbalik garing ka lebeng. ");
INSERT INTO mmn_vpl VALUES ("AC2_32","074_2_32","ACT","2","32","32","Kamhan indogangan ni Pidro pagpanaba nga mintoman di ya mga panaba ni Dabid kay si Hisos iza ya inbohi na Diyos kay kaming tanan ya minsaksi nga nabohi di si Hisos. ");
INSERT INTO mmn_vpl VALUES ("AC2_33","074_2_33","ACT","2","33","33","Kamhan imbohat di iza daked ka too na Diyos kay intagan di iza ka labaw nga gahem ka paghari ka mga tao. Kamhan minsaad ya Diyos kan Hisos nga ipakarimbaba naiza ya toong Ispirito. Kamhan dini kanta mindateng di matood iza nga Ispirito. Ani ini ya nakitan mazo daw ya nabatian mazo kazina ka pagpanaba niran ka mga nagakalainlain nga saba. ");
INSERT INTO mmn_vpl VALUES ("AC2_34","074_2_34","ACT","2","34","34","Si Hisos ani ya nabohat ngandaked ka Diyos diri kon si Dabid. Ani ini ya kahologan na daan inpanaba ni Dabid nga nagalaong nga minpanaba ya Diyos ka kanaong Ginoo nga lomo-to ko naa dini ka kanaong too ");
INSERT INTO mmn_vpl VALUES ("AC2_35","074_2_35","ACT","2","35","35","hangtod ka pagpakadaeg nao ka kanmong mga kaaway. Ani ini ya daan inpanaba ni Dabid mahitenged kan Kristo. ");
INSERT INTO mmn_vpl VALUES ("AC2_36","074_2_36","ACT","2","36","36","Mga kaibahan nao nga taga Israil, timan-an mazo gazed ini nga si Hisos nga inpapatay mazo iza matood ya Ginoo nga hari nga pinili na Diyos. ");
INSERT INTO mmn_vpl VALUES ("AC2_37","074_2_37","ACT","2","37","37","Pagpakabati ka na mga tao kaini nga sindo ni Pidro masakit gazed ya kanirang hinawa singed ka indoltan ka lodzo. Kamhan nangotana siran kanin Pidro nga kaibahan nami, daw ono kontana ya hinangen nami? ");
INSERT INTO mmn_vpl VALUES ("AC2_38","074_2_38","ACT","2","38","38","Minsambag si Pidro nga bizaan mazo ya kamazong mga sala. Kamhan magpabenzag di kamo kay ani ya timaan nga minsakop di kamo kan Hiso Kristo daw inpasaylo disab na Diyos ya kamazong mga sala. Kamhan mahatagan kamo ka Madazaw nga Ispirito nga garing ka Diyos. ");
INSERT INTO mmn_vpl VALUES ("AC2_39","074_2_39","ACT","2","39","39","Kay iza nga Ispirito ani ya insaad daan na Diyos kamazo daw ya kamazong mga maanak daw ya tanan mga tao nga diri kon Yodayo daw ya bisan sin-o nga inpili na kantang Ginoong Diyos. ");
INSERT INTO mmn_vpl VALUES ("AC2_40","074_2_40","ACT","2","40","40","Kamhan ataas pen ya pagpanan-og ni Pidro kaniran daw minsindo nga nagalaong nga bemelag di kamo ka mga salaan nga tao kay may tirmino na Diyos ka pagsilot kaniran. ");
INSERT INTO mmn_vpl VALUES ("AC2_41","074_2_41","ACT","2","41","41","Kamhan ya mga mintoo ka sindo ni Pidro nabenzagan di siran. Dizan ka mga sakop ni Hisos mindogang ya Diyos ka pagtaed kaniran ka pagpasakop kan Hisos ka hapit magtolong ka libo nga ka tao ka isa kang aldaw. ");
INSERT INTO mmn_vpl VALUES ("AC2_42","074_2_42","ACT","2","42","42","Kamhan minhatag siran ka tanan kaogaringen niran ka pagtoon ka sindo na mga sinarigan ni Hisos. Namag-angay disab siran ka hena-hena. Inhinang sab niran ya batasan niran ka pagtaremdem ka pagkapatay ni Hisos nga inpanipaktipak niran ya pan. Namagtibe disab siran pagpangamozo ka Diyos. ");
INSERT INTO mmn_vpl VALUES ("AC2_43","074_2_43","ACT","2","43","43","Masara gazed ya pagpangabereng na tanan mga tao kay inpahinang na Diyos ya mga sinarigan ka mga madazaw nga kaberenganan kay timaan iton nga labaw gazed ya Diyos ka gahem. ");
INSERT INTO mmn_vpl VALUES ("AC2_44","074_2_44","ACT","2","44","44","Kamhan ya tanan mga minsakop kan Kristo namag-isa di ya kanirang hena-hena. Nagabahinbahin gihapon siran ka kanirang mga betang. ");
INSERT INTO mmn_vpl VALUES ("AC2_45","074_2_45","ACT","2","45","45","Nagapamaligza disab siran ka kanirang lopa daw ya mga betang. Kamhan inpanhatag niran ya kowarta nga halin. Ya kinahanglan na tagsa tagsa ani inhatag. ");
INSERT INTO mmn_vpl VALUES ("AC2_46","074_2_46","ACT","2","46","46","Kada aldaw mintipon disab siran dalem ka dakolang lagkaw nga pangamozoanan ka Diyos. Kamhan dizan ka tagsa tagsang lagkaw inhinang niran ya batasan niran ka pagtaremdem ka pagkapatay ni Hisos nga inpanipaktipak niran ya pan. Pagpangaen niran malinaw gazed ya kanirang hinawa. Maangay-angazen sab siran ka mga tao. ");
INSERT INTO mmn_vpl VALUES ("AC2_47","074_2_47","ACT","2","47","47","Minsaza siran ka Diyos. Nakaangay isab ya mga tao kaniran. Kamhan dizan kaniran kada aldaw mindogang ya Diyos ka pagtaed ka mga tao nga inhatagan di ka bag-ong kinabohi nga diri mawara. ");
INSERT INTO mmn_vpl VALUES ("AC3_1","074_3_1","ACT","3","1","1","May isang aldaw nga pagkabalantang na pagkadelem si Pidro daw si Howan minkaro siran ka dakolang lagkaw nga pangamozoanan ka Diyos kay ani ya batasan na mga Yodayo kada delem. ");
INSERT INTO mmn_vpl VALUES ("AC3_2","074_3_2","ACT","3","2","2","Kamhan dizan ka pirtahan inngaranan ka Pirtahan nga Madazaw may isang ka tao nga napiang nga ingkatao ya toong pagkapiang. Kada aldaw pagalahongan iza na mga tao kay dizan ka mga tao nga nagaseled ka dakolang lagkaw na Diyos anpangazo iza ka kowarta. ");
INSERT INTO mmn_vpl VALUES ("AC3_3","074_3_3","ACT","3","3","3","Pagpakakita ka naiza kanin Pidro nga naneled nangazo iza ka kowarta. ");
INSERT INTO mmn_vpl VALUES ("AC3_4","074_3_4","ACT","3","4","4","Kamhan minseleng sin Pidro kanangiza. Minsogo si Pidro nga selengi kami! ");
INSERT INTO mmn_vpl VALUES ("AC3_5","074_3_5","ACT","3","5","5","Kamhan minseleng gazed ya napiang kanirang dowa kay nagatagad iza ka kowarta. ");
INSERT INTO mmn_vpl VALUES ("AC3_6","074_3_6","ACT","3","6","6","Kamhan minlaong si Pidro nga wara gazed ya kanaong kowarta piro si Hiso Kristo nga taga Nazarit iza ya antabang kanmo. Bomangon di ko. Pomanaw ko naa ngaro. ");
INSERT INTO mmn_vpl VALUES ("AC3_7","074_3_7","ACT","3","7","7","Kamhan paghawidi ni Pidro ka toong alima ka pagpatindeg marig-en matood ya mga paa daw bokoboko. ");
INSERT INTO mmn_vpl VALUES ("AC3_8","074_3_8","ACT","3","8","8","Kamhan minlakso iza pagtindeg daw minpanaw disab iza. Kamhan minseled iza ka dakolang lagkaw na Diyos iba kanin Pidro. Nakapanaw iza daw nagalinaksolakso daw nagasaza ka Diyos pagdakola. ");
INSERT INTO mmn_vpl VALUES ("AC3_9","074_3_9","ACT","3","9","9","Ya mga tao nakakita kanangiza nga nagapanaw daw nagasaza ka Diyos. ");
INSERT INTO mmn_vpl VALUES ("AC3_10","074_3_10","ACT","3","10","10","Pagkilala niran nga iza gazed ya mangazoay nga nagalo-to bali ka pirtahan inngaranan ka Pirtahan nga Madazaw dakola gazed ya pagkabereng niran kay madazaw di iza. ");
INSERT INTO mmn_vpl VALUES ("AC3_11","074_3_11","ACT","3","11","11","Ka nagahawid pen kanin Pidro ya piang nga madazaw di nabereng ya tanan mga tao. Kamhan bali ka isang lozo inngaranan ka Diskanso ni Salomon nandogok siran pagdalagan dizan kanin Pidro. ");
INSERT INTO mmn_vpl VALUES ("AC3_12","074_3_12","ACT","3","12","12","Pagpakakita ni Pidro kaniran minlaong iza kaniran nga kanaong kaibahan nga taga Israil, kay ono sa kamo magkabereng? Kay ono sa kamo magselengseleng kanami? Daw nagahena-hena kamo nga garing ka kanaming kaogaringeng gahem kon batasan nga madazaw nakapabahaw kami kaini nga tao? Diri gazed kay ");
INSERT INTO mmn_vpl VALUES ("AC3_13","074_3_13","ACT","3","13","13","ya Diyos nga inhawag na kantang karaan nga si Abraham daw si Isak daw si Hakob, iza ya nakapabahaw kaini nga tao dazaw sazaen ya toong Sogoonon nga si Hisos. Izang mahon-a pen in-ated mazo si Hisos doro kan Pilato nga gobirnador. Kamhan si Pilato nakahokom nga bohien iza piro diri kamo ansogot. ");
INSERT INTO mmn_vpl VALUES ("AC3_14","074_3_14","ACT","3","14","14","Bisan madazaw ya batasan ni Hisos daw waray sala naiza, diri kamo ansogot nga bohien iza. Hinoa inhangzo mazo si Pilato dazaw bohien naiza ya tao nga talamono. ");
INSERT INTO mmn_vpl VALUES ("AC3_15","074_3_15","ACT","3","15","15","Kamhan minpatay kamo kan Hisos nga tag-iza ka kinabohi nga diri mawara. Kamhan inbohi iza na Diyos pagbalik garing ka lebeng. Ani ini ya ipanan-og nami kamazo. ");
INSERT INTO mmn_vpl VALUES ("AC3_16","074_3_16","ACT","3","16","16","Si Hisos nga kanaming intoohan ani gazed ya nakadazaw kaini nga tao nga nakilalhan mazo daan. Dini ka pagpakakita mazong tanan ya pagtoo kan Hisos ani gazed ya nakadazaw ka toong lawas. ");
INSERT INTO mmn_vpl VALUES ("AC3_17","074_3_17","ACT","3","17","17","Mga kaibahan nao, mahagdam hao nga izang mahon-a pen pagpapatay mazo daw ya kamazong oloolo kan Hisos wara pen kamo makasabot kon sin-o sa iza. ");
INSERT INTO mmn_vpl VALUES ("AC3_18","074_3_18","ACT","3","18","18","Kamhan ya mga karaang propita intandeg na Diyos ya hinawa niran dazaw ansindo siran nga si Kristo nga hari nga pinili na Diyos kinahanglan patazen iza. Kamhan mintoman ya Diyos ka toong mga panaba. ");
INSERT INTO mmn_vpl VALUES ("AC3_19","074_3_19","ACT","3","19","19","Agon maghinelsel kamo. Magbalik disab kamo ka Diyos dazaw kaw-en naiza ya kamazong mga sala. ");
INSERT INTO mmn_vpl VALUES ("AC3_20","074_3_20","ACT","3","20","20","Kamhan an-iba iza kamazo. Palinawen disab naiza ya kamazong hinawa. Kamhan ipakarimbaba kamazo si Hisos kay iza matood si Kristo nga hari nga pinili na Diyos. ");
INSERT INTO mmn_vpl VALUES ("AC3_21","074_3_21","ACT","3","21","21","Kinahanglan anpabilin si Kristo daked ka langit keteb ka tirmino ka pagbag-o na Diyos ka kalibotan nga inpanan-og na toong mga karaang propita. ");
INSERT INTO mmn_vpl VALUES ("AC3_22","074_3_22","ACT","3","22","22","Kay kawandini pen minlaong si Moysis nga kantang karaan nga ya Ginoo nga kamazong Diyos pakarinhen naiza kay-an ya matood nga propita nga kaliwat ni Israil singed ka pagpakarini naiza kanao nga si Moysis. Kinahanglan tomanen mazo ya tanan ipanaba naiza kamazo. ");
INSERT INTO mmn_vpl VALUES ("AC3_23","074_3_23","ACT","3","23","23","Kamhan bisan sin-o ya diri antoman ka ipanaba naiza pabelagen iza ka mga sakop na Diyos daw patazen iza. Ani ini ya daan inlaong ni Moysis. ");
INSERT INTO mmn_vpl VALUES ("AC3_24","074_3_24","ACT","3","24","24","Kamhan indogangan ni Pidro pagsindo kaniran nga nagalaong nga ya mga karaang propita sokad kan Samwil siran gihapon ya minpanan-og isab mahitenged ka pagdateng ni Kristo koman nga panahon. ");
INSERT INTO mmn_vpl VALUES ("AC3_25","074_3_25","ACT","3","25","25","Mga kaliwatan kamo na mga propita. Kamhan inlakipan disab kamo ka saad na Diyos ka kantang karaan. Kay kawandini pen minsaad iza kan Abraham nga kantang apo nga nagalaong nga may kanmong kaliwat nga wara pen matao. Garing kanangiza panaranginan na Diyos ya tanan mga tao ka madazaw dini ka tibolos kalibotan. Ani ini ya daan saad na Diyos kan Abraham. ");
INSERT INTO mmn_vpl VALUES ("AC3_26","074_3_26","ACT","3","26","26","Kamhan inpili na Diyos ya toong Sogoonon daw inpadara paghon-a ngarini kamazo dazaw panaranginan kamo ka madazaw pagtabang naiza kamazo ka pagbiza ka kamazong batasan nga maonga. Ani ini ya pagsindo ni Pidro ka mga tao. ");
INSERT INTO mmn_vpl VALUES ("AC4_1","074_4_1","ACT","4","1","1","Na, ka nagasindo pen sin Pidro ka mga tao minkarini di kaniran ya mga oloolo na mga pari daw ya kapitan ka mga magbantazay ka lagkaw na Diyos daw ya mga maistro na mga Yodayo ani ngaran ya Sadosiyo. Ya toldoan na Sadosiyo ya mga namola di nga tao diri mabohi pagbalik garing ka lebeng. ");
INSERT INTO mmn_vpl VALUES ("AC4_2","074_4_2","ACT","4","2","2","Kamhan nazehet siran kay sin Pidro nagatoldo ka mga Yodayo nga nabohi di si Hisos pagbalik garing ka lebeng. Agon nagamatood iton nga ya mga namola nga tao may tirmino nga mabohi isab siran pagbalik garing ka lebeng. Ani ini ya pagtoldo nin Pidro. ");
INSERT INTO mmn_vpl VALUES ("AC4_3","074_4_3","ACT","4","3","3","Kamhan indakep sirang dowa na mga oloolo daw inpriso hangtod ka pagkasonod nga aldaw kay delem di. ");
INSERT INTO mmn_vpl VALUES ("AC4_4","074_4_4","ACT","4","4","4","Ya mga nanalinga kanin Pidro kazina mataed ya mintoo ka kanirang sindo mahitenged kan Kristo. Kamhan ya mga minsakop kan Kristo mindogang pen siran ka pagtaed ka hapit maglimang ka libo nga amaama. ");
INSERT INTO mmn_vpl VALUES ("AC4_5","074_4_5","ACT","4","5","5","Ka pagkasonod nga aldaw ya mga oloolo na mga pari daw ya mga malaas daw ya mga maistro ka tinoohan na mga Yodayo nagatipon di sirang tanan dizan ka Hirosalem. ");
INSERT INTO mmn_vpl VALUES ("AC4_6","074_4_6","ACT","4","6","6","Nakigkita siran kan Anas nga labaw nga pari daw si Kayapas daw ya mga lomon niran nga si Howan daw si Alihandro daw ya mga iba nga sakop ni Anas nagatipon di sirang tanan. ");
INSERT INTO mmn_vpl VALUES ("AC4_7","074_4_7","ACT","4","7","7","Kay inpakarini niran sin Pidro dazaw pangotanhen nga kahabi in-ono sa mazo paghinang kaiton? Kamo dowa sin-o sa ya minhatag kamazo ka gahem ka paghinang kaiton? ");
INSERT INTO mmn_vpl VALUES ("AC4_8","074_4_8","ACT","4","8","8","Pagsambag ni Pidro inharian iza na Madazaw nga Ispirito nga garing ka Diyos. Kamhan minlaong iza nga kamo nga mga oloolo na mga Yodayo daw ya mga malaas nga intahod nami, ");
INSERT INTO mmn_vpl VALUES ("AC4_9","074_4_9","ACT","4","9","9","kon gosto kamo mahagdam kon in-ono nami pagdazaw ka napiang kahabi ");
INSERT INTO mmn_vpl VALUES ("AC4_10","074_4_10","ACT","4","10","10","manalinga kamong tanan daw ya tanan mga taga Israil kay anpanan-og kami kamazo. Ya tao nga nagatindeg dini ka pagseleng mazo madazaw di iza kay si Hiso Kristo nga taga Nazarit ani ya may gahem ka paghatag kanangiza ka madazaw nga lawas. Inpalansang mazo si Hisos ka kros. Kamhan inbohi iza na Diyos pagbalik garing ka lebeng. ");
INSERT INTO mmn_vpl VALUES ("AC4_11","074_4_11","ACT","4","11","11","Kilalhen mazo nga si Hisos ani gazed ya inpanan-og na daan pinasoyat na Diyos nga nagalaong nga ya matimgas nga bato nga inbizaan na mga minhinang ka lagkaw ani ya nahinang nga sinarigan ka pagparig-en ka primirong ogdok na lagkaw. ");
INSERT INTO mmn_vpl VALUES ("AC4_12","074_4_12","ACT","4","12","12","Kay si Hisos iza kay makatabang kanta dazaw malibri kita ka silot ka kantang mga sala. Kay dini ka tibolos kalibotan waray lain ngaran nga inhatag na Diyos ka mga tao nga makalibri kaniran ka silot ka kanirang mga sala. Ani ini ya sambag ni Pidro kaniran. ");
INSERT INTO mmn_vpl VALUES ("AC4_13","074_4_13","ACT","4","13","13","Kamhan ya mga oloolo na mga Yodayo nabereng siran kay bisan wara sin Pidro mag-iskwila, waray kasipeg niran ka pagsambag. Nagalaong sab ya mga oloolo nga ya dowang ka tao ani matood ya min-ibaiba kan Hisos kaizang dini kaini. ");
INSERT INTO mmn_vpl VALUES ("AC4_14","074_4_14","ACT","4","14","14","Kamhan waray ikapanaba niran pag-away kan Pidro daw si Howan kay nakitan niran ya tao nga madazaw di nga nagatindeg dizan iba kanin Pidro. ");
INSERT INTO mmn_vpl VALUES ("AC4_15","074_4_15","ACT","4","15","15","Kamhan minpalogwa siran kanin Pidro ka hokmanan dazaw mamagsabot siran nga ");
INSERT INTO mmn_vpl VALUES ("AC4_16","074_4_16","ACT","4","16","16","nagalaong nga in-ono sa nita iton nga dowang ka tao? Kay mahagdam ya tanan mga taga Hirosalem nga minhinang siran ka kaberenganan nga talagsa ka ya nakakita dini ka kalibotan. Diri kita makalimed kaini. ");
INSERT INTO mmn_vpl VALUES ("AC4_17","074_4_17","ACT","4","17","17","Agon haldeken ta siran dazaw dizan ka bisan sin-o nga tao diri siran anpanan-og mahitenged kan Hisos dazaw diri mapanan-og pagdazaw ya inhinang niran. ");
INSERT INTO mmn_vpl VALUES ("AC4_18","074_4_18","ACT","4","18","18","Kamhan inpaseled niran sin Pidro pagbalik. Kamhan inbaheg siran nagalaong nga diri gazed kamo magpanan-og kon magtoldo ka mga tao mahitenged kan Hisos. ");
INSERT INTO mmn_vpl VALUES ("AC4_19","074_4_19","ACT","4","19","19","Minsambag si Pidro daw si Howan nga maghena-hena kamo. Daw madazaw ya pagtoo nami ka kamazong baheg kon ya pagtoman nami ka sogo na Diyos? ");
INSERT INTO mmn_vpl VALUES ("AC4_20","074_4_20","ACT","4","20","20","Diri mahimo nga henengen nami pagpanaba ka mga tao ya nakitan daw nabatian nami. ");
INSERT INTO mmn_vpl VALUES ("AC4_21","074_4_21","ACT","4","21","21","Kamhan inhinaldekan siran na mga oloolo pag-isab. Kamhan inpalogwa kay diri siran mahagdam kon in-ono niran pagsilot kay basi magobot ya mga Yodayo kay insaza ya Diyos nirang tanan kay madazaw di ya napiang. ");
INSERT INTO mmn_vpl VALUES ("AC4_22","074_4_22","ACT","4","22","22","Kamhan ya tao nga inhinangan ka kaberenganan kapin ka kap-atan nga ka toig ya toong pagkamalaas. ");
INSERT INTO mmn_vpl VALUES ("AC4_23","074_4_23","ACT","4","23","23","Pagpakalogwa kanin Pidro ka priso minbalik di sirang dowa ka kanirang kaibahan. Kamhan minpakahagdam kaniran ka tanan mga inpanaba na mga malaas daw ya mga oloolo na mga pari. ");
INSERT INTO mmn_vpl VALUES ("AC4_24","074_4_24","ACT","4","24","24","Kamhan namagdengan siran pagpangamozo ka Diyos nga nagalaong nga Ginoo, iko matood ya maghinangay ka langit daw lopa daw ya dagat daw bisan ono ya nagahela kanirang tanan. ");
INSERT INTO mmn_vpl VALUES ("AC4_25","074_4_25","ACT","4","25","25","Ya kanmong Ispirito ani ya mintandeg ka hinawa ni Dabid nga kanaming karaan nga kanmong sogoonon. Kamhan nagalaong iza nga kay ono sa nazehet ya mga tao nga diri kon Yodayo? Kay ono sa siran nagahena-hena ka maonga nga waray kaposlanan? ");
INSERT INTO mmn_vpl VALUES ("AC4_26","074_4_26","ACT","4","26","26","Nagaandam ya mga hari dini ka kalibotan. Namagsabot disab ya mga oloolo kay awazen niran ya Ginoo daw ya hari nga pinili naiza. Ani ini ya mga panaba ni Dabid kawandini pen. ");
INSERT INTO mmn_vpl VALUES ("AC4_27","074_4_27","ACT","4","27","27","Kamhan mintoman di iton kay dini kaini nga siyodad nga Hirosalem nagatipon di si Hirodis daw si Ponsiyo Pilato daw ya mga diri kon Yodayo daw ya mga taga Israil kay namagsabot siran nga patazen si Hisos nga kanmong Sogoonon nga waray sala. Iza matood ya hari nga kanmong pinili nga intagadan na mga Yodayo. ");
INSERT INTO mmn_vpl VALUES ("AC4_28","074_4_28","ACT","4","28","28","Mintipon matood siran ka paghinang ka tanan nga kanmo ding daan inbet-an. ");
INSERT INTO mmn_vpl VALUES ("AC4_29","074_4_29","ACT","4","29","29","Ginoo, mahagdam iko daan ka paghinaldek niran kanami. Agon tabangan mo kami dazaw waray kahaldek nami ka pagpanaba ka sindo nga insogo mo kanami. ");
INSERT INTO mmn_vpl VALUES ("AC4_30","074_4_30","ACT","4","30","30","Dazawen mo ya mga nabedlay dini. Hinangen mo ya mga madazaw nga kaberenganan kay timaan iton nga si Hisos ani gazed ya kanmong Maanak nga waray sala kamhan iza matood ya labaw ka gahem. ");
INSERT INTO mmn_vpl VALUES ("AC4_31","074_4_31","ACT","4","31","31","Pagkakamhan niran pagpangamozo ka Diyos ya lagkaw nga tiponanan niran mindeegdeeg gazed iton. Kamhan inharian sirang tanan na Madazaw nga Ispirito nga garing ka Diyos. Kamhan nawara di ya kahaldek niran ka pagpanan-og ka mga tao ka sindo na Diyos. ");
INSERT INTO mmn_vpl VALUES ("AC4_32","074_4_32","ACT","4","32","32","Na, ya tanan mga minsakop kan Hisos naisa di ya kanirang hena-hena. Kamhan dizan kaniran waray isa nga nagalaong nga iza kay tag-iza ka toong mga betang kay magabahinbahinen niran ya tanan mga betang niran. ");
INSERT INTO mmn_vpl VALUES ("AC4_33","074_4_33","ACT","4","33","33","Minwali isab ya mga sinarigan ni Hisos nga nabohi di si Ginoong Hisos pagbalik garing ka lebeng kay minkita di matood siran kanangiza. Intagan siran na Diyos ka may dakolang gahem ka pagwali kaini. Kamhan minpanarangin ya Diyos ka madazaw kanirang tanan. ");
INSERT INTO mmn_vpl VALUES ("AC4_34","074_4_34","ACT","4","34","34","Dizan kaniran waray isa nga nakolangan kay ya mga tag-iza ka mga oma daw mga lagkaw inbaligza di niran. ");
INSERT INTO mmn_vpl VALUES ("AC4_35","074_4_35","ACT","4","35","35","Kamhan inhatag ya bazad ka mga sinarigan. Kamhan inbahinbahin niran iton kay ya kinahanglan na tagsa tagsa ani inhatag. ");
INSERT INTO mmn_vpl VALUES ("AC4_36","074_4_36","ACT","4","36","36","Kamhan may isang tao nga taga Sipro nga kaliwat ni Libita si Hosi ya ngaran. Indagnazan iza na mga sinarigan kan Barnabi kay ya batasan naiza magtabangay ka mga tao. ");
INSERT INTO mmn_vpl VALUES ("AC4_37","074_4_37","ACT","4","37","37","Kamhan ya hinang naiza inbaligza naiza ya isang oma. Kamhan inhatag naiza ya kowarta ka mga sinarigan ni Hisos. ");
INSERT INTO mmn_vpl VALUES ("AC5_1","074_5_1","ACT","5","1","1","Kamhan may isa pen nga tao si Ananiyas ya ngaran daw si Sapira ya toong asawa. Minbaligza disab siran ka kanirang lopa. ");
INSERT INTO mmn_vpl VALUES ("AC5_2","074_5_2","ACT","5","2","2","Kamhan inkawa niran ya halin kay may daan sabot niran ka paglimed ka mga sinarigan ni Hisos. Kamhan ya nabilin indara ngaro ka mga sinarigan. ");
INSERT INTO mmn_vpl VALUES ("AC5_3","074_5_3","ACT","5","3","3","Kamhan si Pidro nangotana iza kan Ananiyas nga nagalaong nga Ananiyas, kay ono sa inharian ni Satanas ya hena-hena mo ka pagbakak ka Madazaw nga Ispirito nga garing ka Diyos? Minpanaba ko kanao nga ya bazad ka lopa inhorot di mazo ka paghatag dini kanami ambaza kay inkawa mazo daan ya halin. ");
INSERT INTO mmn_vpl VALUES ("AC5_4","074_5_4","ACT","5","4","4","Ka wara pen mazo ibaligza ya lopa, kamazo iton. Pagbaligza mazo kaiton nga lopa ya kowarta kamazo gihapon. Kamhan wara gazed kami magleges kamazo ka paghatag kanami ka bisan geramay ka. Kay ono sa kamo maghena-hena ka paglimed kanami? Ya Diyos iza ya imbakakan mazo, diri kon tao. ");
INSERT INTO mmn_vpl VALUES ("AC5_5","074_5_5","ACT","5","5","5","Pagpakabati ka ni Ananiyas ka mga panaba ni Pidro nadeeg iza ka pagkapatay. Kamhan ya tanan mga nakabati masara ya pagkahaldek niran. ");
INSERT INTO mmn_vpl VALUES ("AC5_6","074_5_6","ACT","5","6","6","Kamhan mindateng di ya mga batan-en nga amaama ka pagkomot ka toong lawas kay indara niran bali ka gawas na siyodad dazaw ilebeng. ");
INSERT INTO mmn_vpl VALUES ("AC5_7","074_5_7","ACT","5","7","7","Ka paglabay ka mga tolong ka oras minseled disab ya asawa na namola piro wara pen iza mahagdam nga wara di ya toong bana. ");
INSERT INTO mmn_vpl VALUES ("AC5_8","074_5_8","ACT","5","8","8","Kamhan si Pidro nangotana kanangiza nga magsogilen ko kanao, daw inhorot mazo paghatag kanami ya halin ka kamazong lopa? Minsambag si Sapira nga hee ani matood iton. ");
INSERT INTO mmn_vpl VALUES ("AC5_9","074_5_9","ACT","5","9","9","Kamhan nangotana si Pidro pag-isab nga kay ono sa kamo magsabot daan ka pagpanoray ka Madazaw nga Ispirito nga garing ka Diyos? Bantay kay ya mga nakalebeng ka kanmong bana mindateng di siran ka pirtahan kay ilebeng disab ko kaan! ");
INSERT INTO mmn_vpl VALUES ("AC5_10","074_5_10","ACT","5","10","10","Kamhan dizan ka paahan ni Pidro nadeeg si Sapira ka pagkapatay. Kamhan minseled pagbalik ya mga batan-en. Pagpakakita niran nga patay di iza indara sab niran ya toong lawas bali ka gawas na siyodad dazaw ilebeng dizan ka saing na toong bana. ");
INSERT INTO mmn_vpl VALUES ("AC5_11","074_5_11","ACT","5","11","11","Kamhan masara gazed ya pagpangahaldek na tanan mga sakop ni Hisos daw bisan sin-o ya nakabati nga nawara di sin Ananiyas. ");
INSERT INTO mmn_vpl VALUES ("AC5_12","074_5_12","ACT","5","12","12","Kamhan ya tanan mga sakop ni Hisos nagatipon siran dizan ka dakolang lagkaw nga pangamozoanan ka Diyos dizan ka isang diskanso inngaranan ka Diskanso ni Salomon. Kamhan dizan kaniran inpahinang na Diyos ya mga sinarigan ka mga madazaw nga kaberenganan kay timaan ini nga labaw ya Diyos ka gahem. ");
INSERT INTO mmn_vpl VALUES ("AC5_13","074_5_13","ACT","5","13","13","Kamhan intahod siran na mga tao piro ya mga wara magsakop kan Hisos wara siran mangahas ka pagtipon kaniran. ");
INSERT INTO mmn_vpl VALUES ("AC5_14","074_5_14","ACT","5","14","14","Kamhan mindogang ya Diyos ka pagtaed ka mga minsakop ka Ginoo. Kamhan masara gazed nga kataed ya mga amaama daw mga babazi. ");
INSERT INTO mmn_vpl VALUES ("AC5_15","074_5_15","ACT","5","15","15","Kamhan inpandara na mga tao ya mga masakiten dizan ka kadalanan na siyodad. Kamhan inpabentag siran ka mga katri daw ya mga banig dazaw pabaskegen siran kon matamdengan siran ka lambong ni Pidro pag-azi naiza. ");
INSERT INTO mmn_vpl VALUES ("AC5_16","074_5_16","ACT","5","16","16","Kamhan nakadateng di ya mga tao garing ka mga longsod libot ka siyodad nga Hirosalem. Nagadara siran ka mga masakiten daw ya mga tao nga inharian na mga maonga. Kamhan indazaw sirang tanan. ");
INSERT INTO mmn_vpl VALUES ("AC5_17","074_5_17","ACT","5","17","17","Kamhan ya labaw nga pari daw ya tanan kaibahan naiza nga mga sakop na mga Sadosiyo min-arig gazed siran ka mga sinarigan ni Hisos. ");
INSERT INTO mmn_vpl VALUES ("AC5_18","074_5_18","ACT","5","18","18","Agon inpadakep niran ya mga sinarigan kamhan inpamiriso. ");
INSERT INTO mmn_vpl VALUES ("AC5_19","074_5_19","ACT","5","19","19","Na, pagkakahabzen kaiza may isang sinogo nga garing ka Diyos nga min-abri ka pirtahan na prisohan. Kamhan inpalogwa daw inlong-an naiza nga ");
INSERT INTO mmn_vpl VALUES ("AC5_20","074_5_20","ACT","5","20","20","bomalik naa kamo ngaro ka dakolang lagkaw nga pangamozoanan ka Diyos. Magpanan-og kamo ka mga tao mahitenged kan Kristo nga tag-iza ka kinabohi nga diri mawara. ");
INSERT INTO mmn_vpl VALUES ("AC5_21","074_5_21","ACT","5","21","21","Mintoman siran kaiton nga sogo kay pagkakaaldawen minseled siran pagbalik ka dakolang lagkaw nga pangamozoanan ka Diyos. Kamhan minsogod di siran pagsindo ka mga tao mahitenged kan Hisos. Ka nagasindo pen siran ya labaw nga pari daw ya toong kaibahan inpatipon niran ya tanan mga oloolo nga taga Israil dazaw manambong ka Labaw nga Hokmanan. Kamhan kaw-en niran kontana sin Pidro garing ka prisohan dazaw iated dizan ka Hokmanan. ");
INSERT INTO mmn_vpl VALUES ("AC5_22","074_5_22","ACT","5","22","22","Ambaza kay pagdateng ka na mga polis dizan ka prisohan nawara di sa baza ya mga sinarigan dalem. Kamhan minbalik di siran ka mga oloolo kay pakahagdamen nga ");
INSERT INTO mmn_vpl VALUES ("AC5_23","074_5_23","ACT","5","23","23","pagdateng nami ka pirisohan nakitan nami nga madazaw ya pagkasira daw ya tanan mga gowardiya nga nagabantay ka mga pirtahan. Piro pag-abri nami waray tao dalem ka pirisohan! ");
INSERT INTO mmn_vpl VALUES ("AC5_24","074_5_24","ACT","5","24","24","Pagpakabati ka na kapitan daw ya mga oloolo na mga pari nagalised ya kanirang hena-hena kay in-ono sa nin Pidro pagpanaw kazina? ");
INSERT INTO mmn_vpl VALUES ("AC5_25","074_5_25","ACT","5","25","25","Kamhan may tao nga minseled daw minlaong nga dizan ka dakolang lagkaw na Diyos waton di ya mga tao nga kamazong mga piniriso nga nagatoldo ka mga tao! ");
INSERT INTO mmn_vpl VALUES ("AC5_26","074_5_26","ACT","5","26","26","Kamhan ya kapitan daw ya toong mga sakop minkaro siran ka dakolang lagkaw na Diyos kay dakpen niran ya mga sinarigan. Wara siran maggamit ka armas kay mahaldek siran kay basi pamookon siran na mga tao. ");
INSERT INTO mmn_vpl VALUES ("AC5_27","074_5_27","ACT","5","27","27","Kamhan in-ated si Pidro daw si Howan dizan ka Labaw nga Hokmanan dazaw pangotanhen na labaw nga pari nga nagalaong nga ");
INSERT INTO mmn_vpl VALUES ("AC5_28","074_5_28","ACT","5","28","28","kahabi minbaheg gazed kami kamazo ka pagheneng ka pagtoldo ka mga tao mahitenged ka ngaran na kamazong oloolo piro wara kamo magtoo kay dini ka tibolos siyodad nga Hirosalem mahagdam di ya tanan mga tao ka kamazong toldoan nga kami koni ya minpatay ka tao nga kamazong insakopan. ");
INSERT INTO mmn_vpl VALUES ("AC5_29","074_5_29","ACT","5","29","29","Kamhan si Pidro daw ya mga iba nga sinarigan minsambag nga kinahanglan tomanen nami ya sogo na Diyos, diri kon sogo na mga tao. ");
INSERT INTO mmn_vpl VALUES ("AC5_30","074_5_30","ACT","5","30","30","Ya Diyos nga hawagenen na kantang mga karaan ani gazed ya minbohi kan Hisos pagbalik garing ka lebeng pagkakamhan mazo pagpatay kanangiza pinaazi ka paglansang kanangiza ka kros. ");
INSERT INTO mmn_vpl VALUES ("AC5_31","074_5_31","ACT","5","31","31","Ya Diyos ani ya minbohat kanangiza nga Oloolo daw Manlolowas dizan ka toong too dazaw anhatag ka mga taga Israil ka logar ka paghinelsel dazaw pasaylohon na Diyos ya kanirang mga sala. ");
INSERT INTO mmn_vpl VALUES ("AC5_32","074_5_32","ACT","5","32","32","Kami ya minpanan-og kaini. Kamhan ya Madazaw nga Ispirito nga inhatag na Diyos dizan ka mga magatoman ka toong sindo ani ya mintabang kanami ka pagpanan-og kaini. Ani ini ya pagsambag na mga sinarigan. ");
INSERT INTO mmn_vpl VALUES ("AC5_33","074_5_33","ACT","5","33","33","Pagpakabati ka na mga sakop na Labaw nga Hokmanan nazehet gazed siran daw pamatazen kontana ya mga sinarigan. ");
INSERT INTO mmn_vpl VALUES ("AC5_34","074_5_34","ACT","5","34","34","Piro may isa kaniran si Gamaliyal ya ngaran. Sakop iza na mga Parasiyo daw maistro sab iza ka daan balaed na Diyos. Matinahodon iza na tanan mga Yodayo. Kamhan mintindeg iza daw minsogo nga nagalaong nga palogwaen sin Pidro. ");
INSERT INTO mmn_vpl VALUES ("AC5_35","074_5_35","ACT","5","35","35","Kamhan minpanaba iza kaniran nga mga kaibahan nao nga taga Israil, magbantay gazed kamo ka kamazong hinangen ka mga taohana nga indakep mazo. ");
INSERT INTO mmn_vpl VALUES ("AC5_36","074_5_36","ACT","5","36","36","Kay izang mahon-a pen may isang ka tao nga si Todas ya ngaran. Gosto naiza nga dakola ya toong pagkadato. Kamhan may mga opat nga ka gatos nga tao nga minsakop kanangiza. Pagkadogay kaiza imbono iza kamhan namagkabelagbelag di ya tanan mga sakop naiza kay wara di ya kanirang oloolo. Agon ya hinang ni Todas wara makapadazon. ");
INSERT INTO mmn_vpl VALUES ("AC5_37","074_5_37","ACT","5","37","37","Kamhan ya panahon ka pagpalista na gobirnador ka mga tao si Hodas nga taga Galiliya minpadakola disab iza ka toong ngaran. Mataed disab ya toong mga sakop. Pagkadogay kaiza imbono iza kamhan namagkabelagbelag disab ya tanan mga sakop naiza. ");
INSERT INTO mmn_vpl VALUES ("AC5_38","074_5_38","ACT","5","38","38","Na, itong mga tao nga indakep mazo abay mazo paghilabti. Pasagdi lamang siran kay kon garing ka tao ka lamang ya kanirang toldoan madali mawara iton. ");
INSERT INTO mmn_vpl VALUES ("AC5_39","074_5_39","ACT","5","39","39","Kamhan kon ya Diyos ani ya minsogo kaniran ngarini diri gazed kamo makadaeg kaniran kay ya Diyos ani hinoa ya in-away mazo. Ani ini ya pagpanaba ni Gamaliyal kaniran. ");
INSERT INTO mmn_vpl VALUES ("AC5_40","074_5_40","ACT","5","40","40","Kamhan mintoo siran ka toong tambag kaniran. Pagpaseled niran ka mga sinarigan pagbalik inpalatos gazed siran. Kamhan imbahegan nga nagalaong nga magheneng kamo pagtoldo ka mga tao mahitenged ka ngaran na kamazong oloolo. Kamhan imbohian siran. ");
INSERT INTO mmn_vpl VALUES ("AC5_41","074_5_41","ACT","5","41","41","Na, pagpanaw na mga sinarigan dizan ka hokmanan dakola gazed ya kanirang kasaza kay siran ya mga pinili na Diyos ka pag-anget ka mga kalised kay si Hisos ya insakopan niran. ");
INSERT INTO mmn_vpl VALUES ("AC5_42","074_5_42","ACT","5","42","42","Kamhan kada aldaw bisan dalem ka dakolang lagkaw na Diyos, bisan dizan ka mga lagkaw na mga tao nagasindo siran ka mga tao daw ipasabot nga si Hisos iza matood si Kristo nga hari nga pinili na Diyos. ");
INSERT INTO mmn_vpl VALUES ("AC6_1","074_6_1","ACT","6","1","1","Ka wara pen madogay ka nagadogang pen ka pagtaed ya mga ansakop kan Hisos ya mga Yodayo nga Ginirika ya saba nagamahay siran ka mga Yodayo nga Hinibriyo ya saba. Kay ya mga balo nga babazi nga sakop niran wara katagi koni ka bahin kada aldaw ka pagpanhatag ka makaen ka kada isa. ");
INSERT INTO mmn_vpl VALUES ("AC6_2","074_6_2","ACT","6","2","2","Kamhan ya mga napolo may dowa nga sinarigan ni Hisos minpatipon siran ka tanan mga sakop ni Hisos kay long-on nga diri kon madazaw kon pasagdan nami ya pagwali ka sindo na Diyos dazaw aligarahen ka pagpakaen ka mga tao. ");
INSERT INTO mmn_vpl VALUES ("AC6_3","074_6_3","ACT","6","3","3","Agon mga kaibahan, dizan kamazo magpili kamo ka pitong bolos nga amaama nga inharian na Madazaw nga Ispirito nga garing ka Diyos daw dakola disab ya kasabtan niran mahitenged ka sindo na Diyos. Kamhan siran ya an-aligara ka pagpakaen ka mga tao. ");
INSERT INTO mmn_vpl VALUES ("AC6_4","074_6_4","ACT","6","4","4","Kay kami ya anhatag ka tanan kaogaringen nami ka pag-ampo daw pagwali. Ani ini ya intogon na mga sinarigan ka tanan mga sakop ni Hisos. ");
INSERT INTO mmn_vpl VALUES ("AC6_5","074_6_5","ACT","6","5","5","Kamhan ya tanan mga tao gosto kaiton nga plano na mga sinarigan. Agon may pitong ka tao nga impili niran. Ya primiro ani si Istiban. Heget gazed ya pagtoo naiza kan Hisos kay inharian iza na Madazaw nga Ispirito nga garing ka Diyos. Sonod si Pilipo daw si Prokoro daw si Nikanor daw si Timon daw si Parminas daw si Nikolas nga taga Antiyokya. Bisan diri kon Yodayo ya ginikanan ni Nikolas minsakop iza ka tinoohan na mga Yodayo. ");
INSERT INTO mmn_vpl VALUES ("AC6_6","074_6_6","ACT","6","6","6","Pagkakamhan niran pagpili kaiton nga mga pitong ka tao indara ngaro ka mga sinarigan. Kamhan minpangamozo ya mga sinarigan ka Diyos. Minpandampa disab ka mga olo nirang pito kay ani ya pagpakilala dizan ka mga iba nga ya pitong ka tao magtabangay di siran ka mga sinarigan ka pagdomara ka mga sakop ni Hisos. ");
INSERT INTO mmn_vpl VALUES ("AC6_7","074_6_7","ACT","6","7","7","Kamhan doro ka siyodad nga Hirosalem mataed ya mga anpanalinga ka sindo nga garing ka Diyos. Kamhan ya mga minsakop kan Hisos mindogang pen siran ka pagtaed. Kamhan ya mga mataed nga pari minsakop disab kan Hisos. ");
INSERT INTO mmn_vpl VALUES ("AC6_8","074_6_8","ACT","6","8","8","Kamhan si Istiban inpanaranginan iza na Diyos ka madazaw daw gahem. Kamhan dizan ka mga tao minhinang iza ka mga madazaw nga kaberenganan kay timaan iton nga si Hisos labaw gazed iza ka gahem. ");
INSERT INTO mmn_vpl VALUES ("AC6_9","074_6_9","ACT","6","9","9","Kamhan minkandizan kan Istiban ya mga iba nga tao. Sakop siran ka isang singbahan na mga Yodayo inngaranan ka Mga Tao nga Binohian kay kaizang mahon-a pen mga oripen siran. Taga Sirini daw taga Alihandriya siran. Garing sab siran ka lopa nga Silisiya daw Asya. Sirang tanan ya minpakiglalis kan Istiban. ");
INSERT INTO mmn_vpl VALUES ("AC6_10","074_6_10","ACT","6","10","10","Piro wara siran makadaeg kay inharian si Istiban na Madazaw nga Ispirito nga garing ka Diyos. Dakola disab ya kasabtan naiza ka sindo na Diyos. ");
INSERT INTO mmn_vpl VALUES ("AC6_11","074_6_11","ACT","6","11","11","Kamhan dizan ka waray lain makakita minsohol siran ka mga iba nga tao dazaw ambetangbetang siran kan Istiban nga nagalaong nga nakabati kami kan Istiban ka pagpanaba ka maonga mahitenged ka kantang karaan nga si Moysis daw ya Diyos. ");
INSERT INTO mmn_vpl VALUES ("AC6_12","074_6_12","ACT","6","12","12","Kamhan nazehet ya mga tao kan Istiban. Agon inpadakep iza na mga malaas daw ya mga maistro ka tinoohan na mga Yodayo kay dadhen dizan ka kanirang mga oloolo. ");
INSERT INTO mmn_vpl VALUES ("AC6_13","074_6_13","ACT","6","13","13","Kamhan minkawa siran ka mga bakaken ka pagbetangbetang kan Istiban nga nagalaong nga ini nga tao onay iza nagapanaba ka maonga mahitenged kan Moysis daw ya Diyos. ");
INSERT INTO mmn_vpl VALUES ("AC6_14","074_6_14","ACT","6","14","14","Kay nakabati kami ka toong toldoan nga nagalaong nga si Hisos nga taga Nazarit geb-en koni naiza ya dakolang lagkaw na Diyos. Isaben sab naiza koni ya mga batasan nga imbilin ni Moysis kanta. Ani ini ya kanirang inpanaba. ");
INSERT INTO mmn_vpl VALUES ("AC6_15","074_6_15","ACT","6","15","15","Kamhan si Istiban pagseleng naiza ka tanan mga oloolo madazaw selengan ya bayho singed ka bayho na taga langit nga sinogo nga garing ka Diyos. ");
INSERT INTO mmn_vpl VALUES ("AC7_1","074_7_1","ACT","7","1","1","Kamhan ya labaw nga pari nangotana iza kan Istiban nga daw matood ya mga sombong niran kanmo? ");
INSERT INTO mmn_vpl VALUES ("AC7_2","074_7_2","ACT","7","2","2","Kamhan si Istiban mindiskorso pagsambag kaniran nga nagalaong nga kamo nga mga kaibahan nao daw kamalaasan! Pagpanalinga kamo kay anpataremdem hao kamazo kon ono ya kaazi na kantang mga karaan. Ya Diyos nga nagahela daked ka langit minkarini iza ka kantang karaan nga si Abraham ka nagahela pen iza doro ka lopa nga Misopotamya, wara pen iza maglaling doro ka longsod nga Haran. ");
INSERT INTO mmn_vpl VALUES ("AC7_3","074_7_3","ACT","7","3","3","Kamhan minsogo ya Diyos kan Abraham nga nagalaong nga Abraham, bemelag ko naa ka kanmong mga lomon. Kamhan pomanaw ko dini ka kanmong hel-anan. Maglaling ko ngaro ka lopa nga ipakita nao kanmo. Ani ini ya sogo na Diyos kan Abraham. ");
INSERT INTO mmn_vpl VALUES ("AC7_4","074_7_4","ACT","7","4","4","Kamhan minpanaw si Abraham ka lopa nga Kaldiya kay minlaling iza doro dapit ka longsod nga Haran. Ka pagkapatay na ama ni Abraham inpalaling iza na Diyos dini kaini nga lopa na kantang hinel-an keteb koman. ");
INSERT INTO mmn_vpl VALUES ("AC7_5","074_7_5","ACT","7","5","5","Kamhan pagdateng ni Abraham dini kaini nga lopa wara pen maghatag ya Diyos kanangiza ka pagpanag-iza ka bisan isa ka nga kalakang ka lopa. Kamhan bisan wara pen ya maanak ni Abraham minsaad ya Diyos kanangiza nga nagalaong nga kamo daw ya kanmong mga kaliwatan tagan nao kamo ka pagpanag-iza kaini nga lopa. ");
INSERT INTO mmn_vpl VALUES ("AC7_6","074_7_6","ACT","7","6","6","Ka wara pen matoman ya insaad nao kanmo ya kanmong mga kaliwatan mga istranyo siran doro ka aro nga lopa na mga lain tao. Kamhan oripenen siran doro daw daegdaegen siran keteb ka opat nga ka gatos nga ka toig. ");
INSERT INTO mmn_vpl VALUES ("AC7_7","074_7_7","ACT","7","7","7","Kamhan silotan nao ya kataohan nga kanirang alagadan. Kamhan mamanaw siran garing kaiton nga dapit kay dini kaini nga lopa hao ya hawagenen niran. Ani ini ya pagpanaba na Diyos kan Abraham. ");
INSERT INTO mmn_vpl VALUES ("AC7_8","074_7_8","ACT","7","8","8","Kamhan insogo na Diyos si Abraham ka paghinang ka batasan nga magpatori ya amaama kay timaan ini ka saad na Diyos kan Abraham nga kamo daw ya kanmong mga kaliwatan tagan nao kamo ka pagpanag-iza kaini nga lopa. Kamhan intori ni Abraham si Isak pagdateng ka ikawalo nga aldaw ka pagkatao. Kamhan intori isab ni Isak ya toong maanak nga si Hakob. Kamhan intori ni Hakob ya toong mga maanak nga napolo may dowang bolos sirang tanan. Kamhan siran ya kantang mga karaan. ");
INSERT INTO mmn_vpl VALUES ("AC7_9","074_7_9","ACT","7","9","9","Na, ya batasan na mga maanak ni Hakob nga kantang mga karaan min-arig gazed siran kan Hosi nga kanirang gipos-an. Agon minbaligza siran kan Hosi ka pag-oripen doro ka lopa nga Ihipto piro ya Diyos ani ya min-iba kanangiza. ");
INSERT INTO mmn_vpl VALUES ("AC7_10","074_7_10","ACT","7","10","10","Kamhan bisan nagaazi si Hosi ka mga masiet nga kalised intabangan iza na Diyos. Kamhan inhatagan iza na Diyos ka dakolang kahagdamanan. Kamhan si Paraon nga hari ka mga taga Ihipto nakaangay iza kan Hosi. Kamhan inpagobirnador ni Paraon si Hosi daw inpabantay ka tanan mga betang naiza. ");
INSERT INTO mmn_vpl VALUES ("AC7_11","074_7_11","ACT","7","11","11","Na, pagkagobirnador ni Hosi ka lopa nga Ihipto may pihit ka tibolos Ihipto daw ya lopa nga Kanaan. Kamhan masara gazed ya kabengtas na tanan mga tao. Waray makaen nin Hakob nga kantang mga karaan. ");
INSERT INTO mmn_vpl VALUES ("AC7_12","074_7_12","ACT","7","12","12","Na, pagpakabati ka ni Hakob nga may dinapog nga makaen doro ka lopa nga Ihipto inpakaro naiza ya kantang mga karaan doro dazaw makapalit siran ka makaen. ");
INSERT INTO mmn_vpl VALUES ("AC7_13","074_7_13","ACT","7","13","13","Na, ka ikadowa niran pagbisita doro minpakilala si Hosi kaniran nga hao ya kamazong gipos-an nga silaong mazo nga patay di. Minpakilala isab kan Paraon nga maglomon siran daw si Hosi. ");
INSERT INTO mmn_vpl VALUES ("AC7_14","074_7_14","ACT","7","14","14","Kamhan minsogo si Hosi ka toong mga lomon nga nagalaong nga karohon si Hakob nga kantang ama daw ya tanan mga sakop naiza nga kapitoan may limang ka tao sirang tanan. ");
INSERT INTO mmn_vpl VALUES ("AC7_15","074_7_15","ACT","7","15","15","Kamhan nalaling si Hakob ngaro ka lopa nga Ihipto. Kamhan ya lopa nga Ihipto ani ya napatazan ni Hakob daw ya toong mga maanak nga kantang mga karaan. ");
INSERT INTO mmn_vpl VALUES ("AC7_16","074_7_16","ACT","7","16","16","Piro ya kanirang mga lawas inbalhin doro ka longsod nga Sikem kamhan doro inlebeng siran ka lebnganan nga daan pinalit ni Abraham garing ka mga maanak ni Hamor. ");
INSERT INTO mmn_vpl VALUES ("AC7_17","074_7_17","ACT","7","17","17","Na, pagkaarani ka na tirmino nga tomanen na Diyos ya toong saad kan Abraham ka paghatag ka pagpanag-iza ka lopa nga Kanaan ka toong mga kaliwatan mindogang di gazed ka pagtaed ya kantang mga angay doro ka lopa nga Ihipto kay nadogay di siran paghela doro. ");
INSERT INTO mmn_vpl VALUES ("AC7_18","074_7_18","ACT","7","18","18","Kamhan may min-ilis ka paghari ka mga taga Ihipto nga wara makataremdem kan Hosi kay dogay di gazed ya pagkapatay ni Hosi. ");
INSERT INTO mmn_vpl VALUES ("AC7_19","074_7_19","ACT","7","19","19","Kamhan inlimbongan na hari ya kantang mga angay. Indaegdaeg siran nga kantang mga karaan. Kamhan insogo siran ka pagbiza ka kanirang mga masoso doro ka oma dazaw mapatay siran. ");
INSERT INTO mmn_vpl VALUES ("AC7_20","074_7_20","ACT","7","20","20","Na, ka nagahinang pen ya hari kaiton nga maonga natao di si Moysis nga naazakan na Diyos. Keteb ka tolong ka bolan ya pagtago kan Moysis na toong ginikanan dizan ka kanirang lagkaw dazaw diri patazen. ");
INSERT INTO mmn_vpl VALUES ("AC7_21","074_7_21","ACT","7","21","21","Pagsoligsolig ka ni Moysis imbizaan niran dizan ka gawas kamhan nakitan iza na maanak nga babazi ni Paraon. Kamhan imbohi naiza si Moysis. ");
INSERT INTO mmn_vpl VALUES ("AC7_22","074_7_22","ACT","7","22","22","Kamhan intoldoan si Moysis ka tanan kahagdamanan na mga Ihiptohanen. Kamhan labaw ka gahem ya mga panaba ni Moysis daw ya toong mga inhinang. ");
INSERT INTO mmn_vpl VALUES ("AC7_23","074_7_23","ACT","7","23","23","Na, pagdateng ni Moysis ka kap-atan nga ka toig nga panoigen minbisita iza ka toong angay nga mga taga Israil. ");
INSERT INTO mmn_vpl VALUES ("AC7_24","074_7_24","ACT","7","24","24","Kamhan nakitan naiza ya isa kaniran nga imbonalan na taga Ihipto. Kamhan inpatay ni Moysis ya taga Ihipto kay mintabang iza ka toong angay pagbales ka maonga. ");
INSERT INTO mmn_vpl VALUES ("AC7_25","074_7_25","ACT","7","25","25","Kay silaong ni Moysis nga ya toong mga angay nahagdam siran daan nga iza ya insogo na Diyos ka pagtabang kaniran ambaza kay wara siran makasabot. ");
INSERT INTO mmn_vpl VALUES ("AC7_26","074_7_26","ACT","7","26","26","Pagsonod nga ka aldaw nakitan naiza ya toong mga angay nga nagaaway sirang dowa. Kamhan minbaheg iza kaniran ka paghosay nga nagalaong nga mga higara, abay kamo pag-away kay maglomon sa kamo! ");
INSERT INTO mmn_vpl VALUES ("AC7_27","074_7_27","ACT","7","27","27","Kamhan ya isa nga minpakig-away ka toong iba mintolod iza kan Moysis daw nagalaong nga sin-oy minpili kanmo ka pagbeet daw paghokom kanami? ");
INSERT INTO mmn_vpl VALUES ("AC7_28","074_7_28","ACT","7","28","28","Daw patazen mo hao singed ka pagpatay mo ka taga Ihipto kahabi? ");
INSERT INTO mmn_vpl VALUES ("AC7_29","074_7_29","ACT","7","29","29","Pagpakabati ka ni Moysis kaiton mindalagan iza kay mahaldek iza. Kamhan nagahela iza doro ka longsod nga Madiyan aro ka toong dapit. Pagkadogay kaiza naminze iza doro. Kamhan dowang bolos ya toong maanak nga polos amaama. ");
INSERT INTO mmn_vpl VALUES ("AC7_30","074_7_30","ACT","7","30","30","Na, pagdateng ka kap-atan nga ka toig ka doro di si Moysis ka kamingawan nga bobong nga Sinay inpakadizan na Diyos kan Moysis ya toong sinogo dizan ka sagbet nga minlaga di. ");
INSERT INTO mmn_vpl VALUES ("AC7_31","074_7_31","ACT","7","31","31","Pagpakakita ka ni Moysis kaiton nga sinogo nabereng iza kon ono iton. Kamhan min-arani iza ka sagbet dazaw sosihen. Kamhan nabatian naiza ya saba na Diyos nga nagalaong nga ");
INSERT INTO mmn_vpl VALUES ("AC7_32","074_7_32","ACT","7","32","32","Hao ya Diyos nga hawagenen na kanmong mga karaan. Hao ya Diyos ni Abraham daw si Isak daw si Hakob nga kanmong kaapoan. Kamhan nagapidpid gazed ya lawas ni Moysis ka kahaldek. Wara iza magpadazon pagseleng ka sagbet. ");
INSERT INTO mmn_vpl VALUES ("AC7_33","074_7_33","ACT","7","33","33","Kamhan minsogo ya Diyos kan Moysis nga kaw-en mo ya kanmong mga sinilas kay madazaw ya lopa nga intindegan mo kay dini hao kanmo. ");
INSERT INTO mmn_vpl VALUES ("AC7_34","074_7_34","ACT","7","34","34","Mahagdam hao nga koman dakola gazed ya kalised na kanaong mga sakop doro ka lopa nga Ihipto. Nabatian disab nao ya kanirang paghangzo kanao. Agon minkarimbaba di hao kay antabang hao kaniran. Komarini ko naa kay pakarohon nao iko ngaro ka Ihipto. Ani ini ya sogo na Diyos kan Moysis. ");
INSERT INTO mmn_vpl VALUES ("AC7_35","074_7_35","ACT","7","35","35","Kamhan si Moysis ani ya insogo na Diyos ka pag-oloolo daw pagtabang ka kantang mga karaan. Izang mahon-a pen iza ya insopakan na toong angay nga nagalaong nga sin-oy minpili kanmo ka pagbeet daw paghokom kanami? Piro intabangan iza na sinogo na Diyos nga minkandizan ka sagbet nga minlaga di pagseleng ni Moysis. ");
INSERT INTO mmn_vpl VALUES ("AC7_36","074_7_36","ACT","7","36","36","Kamhan si Moysis ya mintoldo kaniran pagpanaw niran garing ka lopa nga Ihipto. Keteb ka kap-atan nga ka toig doro ka Ihipto daw doro ka dagat nga inngaranan ka Mararag daw doro ka kamingawan minhinang iza ka mga madazaw nga kaberenganan kay timaan iton nga labaw ya Diyos ka gahem. ");
INSERT INTO mmn_vpl VALUES ("AC7_37","074_7_37","ACT","7","37","37","Kamhan si Moysis ani disab ya minpakahagdam ka kantang karaan nga taga Israil nga nagalaong nga dini kamazo pilien pen na Diyos ya isang propita singed ka pagpili naiza kanao. ");
INSERT INTO mmn_vpl VALUES ("AC7_38","074_7_38","ACT","7","38","38","Ka nagapanaw pen ya kantang mga karaan doro ka kamingawan si Moysis ya nagaiba kaniran. Kamhan doro ka bobong nga Sinay minpanaba kanangiza ya sinogo nga garing ka Diyos. Kamhan nadawat ni Moysis ya sindo na Diyos dazaw ihatag isab kanta. ");
INSERT INTO mmn_vpl VALUES ("AC7_39","074_7_39","ACT","7","39","39","Piro ya kantang mga karaan diri siran ansogot kan Moysis. Minsopak siran kanangiza kay naazak siran pagbalik ka lopa nga Ihipto. ");
INSERT INTO mmn_vpl VALUES ("AC7_40","074_7_40","ACT","7","40","40","Kamhan ka daked pen si Moysis ka bobong nga Sinay minhangzo siran kan Aron nga kanirang pari nga nagalaong nga hinangen mo kanami ya mga diyosdiyos dazaw may anhon-a kanami pagpanaw dini ka kamingawan kay wara kami mahagdam kon hain wani si Moysis nga mindara kanta garing ka lopa nga Ihipto. ");
INSERT INTO mmn_vpl VALUES ("AC7_41","074_7_41","ACT","7","41","41","Kamhan inhinang niran ya diyosdiyos nga singed ka hitsora na nati na baka. Kamhan inhalad disab niran ya ihazep kay magpista gazed siran ka pagsaza ka kanirang inhinang. ");
INSERT INTO mmn_vpl VALUES ("AC7_42","074_7_42","ACT","7","42","42","Kamhan imbizaan siran na Diyos. Inpasagdan siran naiza ka paghawag ka bolan daw sega daw ya mga bitoon. Ani ya nakatoman ka insoyat na mga propita na Diyos mahitenged ka batasan na mga kataohan nga taga Israil nga nagalaong nga kamo nga mga kaliwatan ni Israil, ka waro pen kamo ka kamingawan ka kap-atan nga ka toig diri kon hao ya inhawag daw haladan mazo. ");
INSERT INTO mmn_vpl VALUES ("AC7_43","074_7_43","ACT","7","43","43","Kay nagadaradara kamo ka lalagkaway nga hel-anan na kamazong diyos nga si Molok daw ya hitsora na bitoon nga kamazong diyos nga si Ripan. Siran ya mga diyos nga inhinang mazo dazaw hawagen. Agon ipabihag ta kamo doro ka aro bali pen ka lopa nga Babilonya. Ani ini ya insoyat na mga karaang propita na Diyos mahitenged ka kantang mga karaan. ");
INSERT INTO mmn_vpl VALUES ("AC7_44","074_7_44","ACT","7","44","44","Kamhan ya kantang mga karaan wara siran magtahod ka matood nga Diyos bisan ya hinipid nga lagkaw nga pangamozoanan ka Diyos ani ya indaradara niran doro ka kamingawan. Na, iton nga lagkaw nahinang nga kindal na mga kanding dazaw masazon paghipid. Kay inhinang ni Moysis iton kay may haodan nga inpakita kanangiza na Diyos. ");
INSERT INTO mmn_vpl VALUES ("AC7_45","074_7_45","ACT","7","45","45","Na, pagkamola ni Moysis si Hoswi ya ilis. Kamhan pagdateng nin Hoswi ka kalopaan nga insaad na Diyos ka kantang mga karaan indara sab niran iton nga lagkaw nga pangamozoanan ka Diyos. Kamhan inbogaw na Diyos ya mga lain tao nga nagahela doro. Kamhan imbilin niran ya lagkaw doro hangtod ka paghari ni Dabid kaniran. ");
INSERT INTO mmn_vpl VALUES ("AC7_46","074_7_46","ACT","7","46","46","Kamhan mintabang ya Diyos kan Dabid ka pagpakadaeg ka toong mga kaaway. Kamhan minhangzo si Dabid ka Diyos nga nagalaong nga Diyos, kon mahimo togotan mo hao ka paghinang ka dakolang lagkaw para kanmo nga Diyos ni Hakob nga kanaming karaan. ");
INSERT INTO mmn_vpl VALUES ("AC7_47","074_7_47","ACT","7","47","47","Piro si Salomon nga maanak ni Dabid ani ya nakahinang kaiton. ");
INSERT INTO mmn_vpl VALUES ("AC7_48","074_7_48","ACT","7","48","48","Kamhan ya matood nga Diyos diri gazed magkinahanglan ka paghela dalem ka lagkaw nga inhinang na tao kay kawandini pen minsoyat ya propita na Diyos nga ");
INSERT INTO mmn_vpl VALUES ("AC7_49","074_7_49","ACT","7","49","49","wani ya inlaong na Diyos mahitenged ka toong kaogaringen nga ya langit ani ya kanaong lo-toanan ka paghari. Kamhan ya kalibotan ani ya pahimlazanan na kanaong paa. ");
INSERT INTO mmn_vpl VALUES ("AC7_50","074_7_50","ACT","7","50","50","Bisan ono ya lagkaw nga inhinang mazo kolang pen iton ka paghela kanao kay hao ya maghinangay ka langit daw tibolos kalibotan. Ani ini ya insoyat na karaang propita. ");
INSERT INTO mmn_vpl VALUES ("AC7_51","074_7_51","ACT","7","51","51","Kamhan indogangan ni Istiban pagpanaba kaniran nga nagalaong nga kamong tanan, magahi gazed ya kamazong otok. Bisan mga Yodayo kamo minbiza kamo ka Diyos. Insopak mazo pag-onay ya Madazaw nga Ispirito nga garing ka Diyos singed ka batasan na kamazong mga karaan. ");
INSERT INTO mmn_vpl VALUES ("AC7_52","074_7_52","ACT","7","52","52","Daw may propita nga wara madaegdaeg na kamazong mga karaan? Inpatay niran ya mga sinogo na Diyos nga minpakahagdam kaniran ka pagdateng na toong Sogoonon nga waray sala. Kamhan kamo ya min-edlaw daw minpatay kanangiza. ");
INSERT INTO mmn_vpl VALUES ("AC7_53","074_7_53","ACT","7","53","53","Kamo ya mga mindawat ka mga sogo na Diyos nga indara na sinogo na Diyos piro wara kamo magtoman kaiton. Ani ini ya pagsambag ni Istiban dizan ka mga oloolo nga Yodayo. ");
INSERT INTO mmn_vpl VALUES ("AC7_54","074_7_54","ACT","7","54","54","Pagpakabati na mga sakop na labaw nga pari nagapangageet siran ka kanirang ngipen ka kazehet. ");
INSERT INTO mmn_vpl VALUES ("AC7_55","074_7_55","ACT","7","55","55","Kamhan inharian si Istiban na Madazaw nga Ispirito nga garing ka Diyos. Paghangad naiza nakitan naiza ya Diyos nga madazaw selengan daw si Hisos nga nagatindeg dizan ka too na Diyos. ");
INSERT INTO mmn_vpl VALUES ("AC7_56","074_7_56","ACT","7","56","56","Kamhan minlaong si Istiban nga magseleng kamo! Nakitan nao ya langit nga naabri di daw si Hisos nga nagatindeg dizan ka too na Diyos! ");
INSERT INTO mmn_vpl VALUES ("AC7_57","074_7_57","ACT","7","57","57","Kamhan insampenan niran ya kanirang talinga dazaw diri makabati ka toong saba. Naninggit siran kay dakola ya kazehet niran kan Istiban. Kamhan mindengan sirang tanan pagdasmag kanangiza. ");
INSERT INTO mmn_vpl VALUES ("AC7_58","074_7_58","ACT","7","58","58","Kamhan intolod niran iza dizan ka logwa na siyodad kamhan inpamook. Kamhan dizan ka batan-en nga si Saolo inpabantazan na mga saksi ya kanirang mga bado dazaw masazon pagpook. ");
INSERT INTO mmn_vpl VALUES ("AC7_59","074_7_59","ACT","7","59","59","Pagpamook pen niran kan Istiban minhawag iza nga Ginoong Hisos, dawatan di mo ya kanaong ispirito kay mapatay di hao! ");
INSERT INTO mmn_vpl VALUES ("AC7_60","074_7_60","ACT","7","60","60","Paglohod naiza mabaskeg ya toong saba ka paghawag nga Ginoo, diri ko magtaremdem ka inhinang niran kanao. Pagkakamhan naiza pagpanaba napatay iza. Ani ini ya kaazi ni Istiban. ");
INSERT INTO mmn_vpl VALUES ("AC8_1","074_8_1","ACT","8","1","1","Kamhan ya batan-en nga si Saolo naazak iza ka pagpatay niran kan Istiban. Kamhan ya pagpatay na mga Yodayo kan Istiban ani ya sinogdan ka maiseg nga pagdaegdaeg ka mga sakop ni Hisos nga nagatipon dizan ka siyodad nga Hirosalem. Kamhan namagkabelag ya tanan mga sakop ni Hisos ngaro ka lopa nga Yoda daw Samariya piro ya mga sinarigan ni Hisos minpabilin siran dizan ka Hirosalem. ");
INSERT INTO mmn_vpl VALUES ("AC8_2","074_8_2","ACT","8","2","2","Kamhan ya mga Yodayo nga madazaw ya pagpangalagad niran ka Diyos inlebeng niran si Istiban. Dakola disab ya paghaza niran kan Istiban. ");
INSERT INTO mmn_vpl VALUES ("AC8_3","074_8_3","ACT","8","3","3","Kamhan gosto ni Saolo nga patazen ya mga mataed nga sakop ni Hisos. Agon namanikpanik iza ka tagsa tagsang ka lagkaw dazaw dakpen siran. Bisan kon amaama kon babazi inpamiriso sirang tanan. ");
INSERT INTO mmn_vpl VALUES ("AC8_4","074_8_4","ACT","8",